(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     59737,       2763]*)
(*NotebookOutlinePosition[     75062,       3206]*)
(*  CellTagsIndexPosition[     73947,       3158]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "NumericalMath",
 StyleBox["`", "MB"],
 "ComputerArithmetic",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.80.1", "1.1"}],

Cell[TextData[{
 "The arithmetic used by ",
 StyleBox["Mathematica", "TI"],
 " is a mixture of variable precision software arithmetic and whatever is \
provided by the manufacturer of the floating\[Hyphen]point hardware (or the \
designer of the compiler, if there is no floating\[Hyphen]point hardware). If \
you want to examine the machine arithmetic on your machine you can use the \
functions defined in ",
 StyleBox["NumericalMath`Microscope`", "MR"],
 ". If you want to learn about the basic ideas of computer \
floating\[Hyphen]point arithmetic in general you can use ",
 StyleBox["NumericalMath`ComputerArithmetic`", "MR"],
 ". This allows you to examine arithmetic with various bases, precisions, and \
rounding rules. "
}], "Text",
 CellTags->{"S5.80.1", "1.2"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["ComputerNumber[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["convert the ordinary number ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" to a computer number in the arithmetic currently in effect",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ComputerNumber[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["sign", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["mantissa", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["exp", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["form the computer number with sign ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["sign", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", mantissa ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["mantissa", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", and exponent ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["exp", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ComputerNumber[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["sign", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["mantissa", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["exp", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["value", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "the complete data object that makes up a computer number",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["NaN", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "a nonrepresentable number in the current arithmetic ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.80.1"],

Cell[TextData[{
 "Computer numbers and nonnumbers in ",
 StyleBox["NumericalMath`ComputerArithmetic`", "MR"],
 ". "
}], "Caption",
 CellTags->"S5.80.1"],

Cell[TextData[{
 "Much of the information carried around in the data object that makes up a \
computer number is redundant. In particular, the first three arguments \
contain exactly the same information as the fourth argument. The redundancy \
exists partly for the sake of efficiency and partly to allow the user access \
to the various fields. The fifth argument has nothing to do with the computer \
number itself. It instead represents what the value of the number would be \
without the cumulative effects of all the roundoff errors that went into the \
computer number. It is computed using ",
 StyleBox["Mathematica", "TI"],
 "\[CloseCurlyQuote]s high\[Hyphen]precision arithmetic and can generally be \
regarded as the correct value of the number. Comparing the computer number \
with this number gives the error in the computer number. "
}], "Text",
 CellTags->{"S5.80.1", "1.3"}],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.80.1", "1.4"}],

Cell["<<NumericalMath`ComputerArithmetic`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.80.1"],

Cell["\<\
Here is the computer number representing the ordinary number 2. \
\>", "MathCaption",
 CellTags->{"S5.80.1", "1.5"}],

Cell[CellGroupData[{

Cell["a = ComputerNumber[2]", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.80.1"],

Cell[BoxData[
 TagBox[
  InterpretationBox["\<\"2.000000000000000000\"\>",
   2.,
   AutoDelete->True],
  (BaseForm[#, 10]& )]], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.80.1"]
}, Open  ]],

Cell[TextData[{
 "This gives the computer number representation of ",
 Cell[BoxData[
  FormBox["\[Pi]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.80.1", "1.6"}],

Cell[CellGroupData[{

Cell["b = ComputerNumber[Pi]", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.80.1"],

Cell[BoxData[
 TagBox[
  InterpretationBox["\<\"3.142000000000000000\"\>",
   3.142,
   AutoDelete->True],
  (BaseForm[#, 10]& )]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.80.1"]
}, Open  ]],

Cell["\<\
Arithmetic works with computer numbers just as with ordinary numbers. \
\>", "MathCaption",
 CellTags->{"S5.80.1", "1.7"}],

Cell[CellGroupData[{

Cell["c = a + b", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.80.1"],

Cell[BoxData[
 TagBox[
  InterpretationBox["\<\"5.142000000000000000\"\>",
   5.142,
   AutoDelete->True],
  (BaseForm[#, 10]& )]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.80.1"]
}, Open  ]],

Cell[TextData[{
 "Here is the complete structure of ",
 StyleBox["c", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.80.1", "1.8"}],

Cell[CellGroupData[{

Cell["InputForm[c]", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.80.1"],

Cell["\<\
ComputerNumber[1, 5142, -3, 2571/500,   \
5.1415926535897932384626433832795028842`24.]\
\>", "Output",
 CellLabel->"Out[5]//InputForm= ",
 CellTags->"S5.80.1"]
}, Open  ]],

Cell["You can also enter just the sign, mantissa, and exponent. ", \
"MathCaption",
 CellTags->{"S5.80.1", "1.9"}],

Cell[CellGroupData[{

Cell["ComputerNumber[-1, 1234, -6]", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.80.1"],

Cell[BoxData[
 TagBox[
  InterpretationBox["\<\"-0.001234000000000000000\"\>",
   -0.001234,
   AutoDelete->True],
  (BaseForm[#, 10]& )]], "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S5.80.1"]
}, Open  ]],

Cell[TextData[{
 "But if your input doesn\[CloseCurlyQuote]t make sense in the arithmetic \
currently in effect you get ",
 StyleBox["NaN", "MR"],
 ". Here the problem is that the mantissa is only three digits long. "
}], "MathCaption",
 CellTags->{"S5.80.1", "1.10"}],

Cell[CellGroupData[{

Cell["ComputerNumber[-1, 123, 7]", "Input",
 CellLabel->"In[7]:= ",
 CellTags->"S5.80.1"],

Cell[BoxData["NaN"], "Output",
 CellLabel->"Out[7]= ",
 CellTags->"S5.80.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["SetArithmetic[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["set the arithmetic to be ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" digits, base 10",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["SetArithmetic[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["b", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["set the arithmetic to be ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" digits, base ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["b", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Arithmetic[ ]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "give the parameters of the arithmetic currently in effect",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.80.1"],

Cell["Changing the type of arithmetic to be used. ", "Caption",
 CellTags->"S5.80.1"],

Cell[TextData[{
 "The default arithmetic is four digits in base 10 with a rounding rule of ",
 StyleBox["RoundToEven", "MR"],
 ". Only numbers between ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["10", 
    RowBox[{"-", "50"}]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{".9999", "\[Cross]", 
    SuperscriptBox["10", "50"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " are allowed. Mixed\[Hyphen]mode arithmetic is not allowed and division is \
not done with correct rounding. (It is performed as two operations: \
multiplication by the reciprocal. Each operation involves rounding errors.) "
}], "MathCaption",
 CellTags->{"S5.80.1", "1.11"}],

Cell[CellGroupData[{

Cell["Arithmetic[ ]", "Input",
 CellLabel->"In[8]:= ",
 CellTags->"S5.80.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", "10", ",", 
   RowBox[{"RoundingRule", "\[Rule]", "RoundToEven"}], ",", 
   RowBox[{"ExponentRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "50"}], ",", "50"}], "}"}]}], ",", 
   RowBox[{"MixedMode", "\[Rule]", "False"}], ",", 
   RowBox[{"IdealDivide", "\[Rule]", "False"}]}], "}"}]], "Output",
 CellLabel->"Out[8]= ",
 CellTags->"S5.80.1"]
}, Open  ]],

Cell["Now the arithmetic is set to be six digits in base 8. ", "MathCaption",
 CellTags->{"S5.80.1", "1.12"}],

Cell[CellGroupData[{

Cell["SetArithmetic[6, 8]", "Input",
 CellLabel->"In[9]:= ",
 CellTags->"S5.80.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6", ",", "8", ",", 
   RowBox[{"RoundingRule", "\[Rule]", "RoundToEven"}], ",", 
   RowBox[{"ExponentRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "50"}], ",", "50"}], "}"}]}], ",", 
   RowBox[{"MixedMode", "\[Rule]", "False"}], ",", 
   RowBox[{"IdealDivide", "\[Rule]", "False"}]}], "}"}]], "Output",
 CellLabel->"Out[9]= ",
 CellTags->"S5.80.1"]
}, Open  ]],

Cell["\<\
The result is displayed in octal (with trailing zeros suppressed). \
\>", "MathCaption",
 CellTags->{"S5.80.1", "1.13"}],

Cell[CellGroupData[{

Cell["ComputerNumber[Pi]", "Input",
 CellLabel->"In[10]:= ",
 CellTags->"S5.80.1"],

Cell[BoxData[
 TagBox[
  InterpretationBox[
   SubscriptBox["\<\"3.11040000000000000000\"\>", "8"],
   3.1416015625,
   AutoDelete->True],
  (BaseForm[#, 8]& )]], "Output",
 CellLabel->"Out[10]= ",
 CellTags->"S5.80.1"]
}, Open  ]],

Cell["\<\
There are several options that can be used when setting the arithmetic. In \
addition to changing the precision and the base, you can control the type of \
rounding used, the magnitude of the numbers allowed, whether \
mixed\[Hyphen]mode arithmetic is to be allowed, and whether division is to be \
done with a single rounding operation. \
\>", "Text",
 CellTags->{"S5.80.1", "1.14"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["option name", "TI",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["default value", "TI",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox["",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["RoundingRule", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["RoundToEven", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "the type of rounding to be used ",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ExponentRange", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["{-50,", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["50}", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "the range of exponents that are to be allowed ",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["MixedMode", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["False", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "whether mixed\[Hyphen]mode arithmetic is to be allowed ",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["IdealDivide", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["False", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "whether correctly rounded division is to be used",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
 GridBoxOptions->{RowLines->{True, False},
 RowSpacings->0.4},
 CellTags->"S5.80.1"],

Cell[TextData[{
 "Options for ",
 StyleBox["SetArithmetic", "MR"],
 "."
}], "Caption",
 CellTags->"S5.80.1"],

Cell[TextData[{
 "It should be noted that correctly rounded division is implemented by the \
function ",
 StyleBox["IdealDivide", "MR"],
 ". This function can be used whether or not the arithmetic is set to \
automatically use correct division. It is difficult to get ",
 StyleBox["x/y", "MR"],
 " to give correctly rounded division since the ",
 StyleBox["x/y", "MR"],
 " is converted to ",
 StyleBox["x", "MR"],
 " ",
 StyleBox["y^(-1)", "MR"],
 " before the package ever sees it. The way we get around this is to define \
",
 StyleBox["$PreRead", "MR"],
 " to convert ",
 StyleBox["x/y", "MR"],
 " into ",
 StyleBox["x", "MR"],
 " ",
 StyleBox["~IdealDivide~", "MR"],
 " ",
 StyleBox["y", "MR"],
 " before the parser has a chance to change it to ",
 StyleBox["x", "MR"],
 " ",
 StyleBox["y^(-1)", "MR"],
 ". If you want to use ",
 StyleBox["$PreRead", "MR"],
 " for your own purposes this will interfere with your definition. "
}], "Text",
 CellTags->{"S5.80.1", "1.15"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["RoundToEven", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "round to the nearest representable number and, in the case of a tie \
round, round to the one represented by an even mantissa",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["RoundToInfinity", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "round to the nearest representable number and, in the case of a tie \
round, round away from 0",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Truncation", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["simply discard excess digits, much as ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["Floor", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" does for positive numbers",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.80.1"],

Cell["Types of rounding available. ", "Caption",
 CellTags->"S5.80.1"],

Cell["\<\
Mixed\[Hyphen]mode arithmetic (any arithmetic operation involving an integer \
and a computer number) is not allowed. \
\>", "MathCaption",
 CellTags->{"S5.80.1", "1.16"}],

Cell[CellGroupData[{

Cell["3 ComputerNumber[Pi]", "Input",
 CellLabel->"In[11]:= ",
 CellTags->"S5.80.1"],

Cell[BoxData[
 RowBox[{"3", " ", 
  TagBox[
   InterpretationBox[
    SubscriptBox["\<\"3.11040000000000000000\"\>", "8"],
    3.1416015625,
    AutoDelete->True],
   (BaseForm[#, 8]& )]}]], "Output",
 CellLabel->"Out[11]= ",
 CellTags->"S5.80.1"]
}, Open  ]],

Cell["\<\
This turns on mixed\[Hyphen]mode arithmetic (and sets the arithmetic to six \
digits in hexadecimal). \
\>", "MathCaption",
 CellTags->{"S5.80.1", "1.17"}],

Cell[CellGroupData[{

Cell["SetArithmetic[6, 16, MixedMode -> True]", "Input",
 CellLabel->"In[12]:= ",
 CellTags->"S5.80.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6", ",", "16", ",", 
   RowBox[{"RoundingRule", "\[Rule]", "RoundToEven"}], ",", 
   RowBox[{"ExponentRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "50"}], ",", "50"}], "}"}]}], ",", 
   RowBox[{"MixedMode", "\[Rule]", "True"}], ",", 
   RowBox[{"IdealDivide", "\[Rule]", "False"}]}], "}"}]], "Output",
 CellLabel->"Out[12]= ",
 CellTags->"S5.80.1"]
}, Open  ]],

Cell["Now the product is computed. ", "MathCaption",
 CellTags->{"S5.80.1", "1.18"}],

Cell[CellGroupData[{

Cell["3 ComputerNumber[Pi]", "Input",
 CellLabel->"In[13]:= ",
 CellTags->"S5.80.1"],

Cell[BoxData[
 TagBox[
  InterpretationBox[
   SubscriptBox["\<\"9.6cbe5000000000\"\>", "16"],
   9.42477893829346,
   AutoDelete->True],
  (BaseForm[#, 16]& )]], "Output",
 CellLabel->"Out[13]= ",
 CellTags->"S5.80.1"]
}, Open  ]],

Cell["\<\
There are many things about computer arithmetic that are very different from \
ordinary arithmetic. Most of these differences are quite easy to demonstrate. \
\
\>", "Text",
 CellTags->{"S5.80.1", "1.19"}],

Cell["This sets the arithmetic back to the default. ", "MathCaption",
 CellTags->{"S5.80.1", "1.20"}],

Cell[CellGroupData[{

Cell["SetArithmetic[4, 10]", "Input",
 CellLabel->"In[14]:= ",
 CellTags->"S5.80.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", "10", ",", 
   RowBox[{"RoundingRule", "\[Rule]", "RoundToEven"}], ",", 
   RowBox[{"ExponentRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "50"}], ",", "50"}], "}"}]}], ",", 
   RowBox[{"MixedMode", "\[Rule]", "False"}], ",", 
   RowBox[{"IdealDivide", "\[Rule]", "False"}]}], "}"}]], "Output",
 CellLabel->"Out[14]= ",
 CellTags->"S5.80.1"]
}, Open  ]],

Cell["\<\
Expressions are evaluated numerically before they become computer numbers. \
\>", "MathCaption",
 CellTags->{"S5.80.1", "1.21"}],

Cell[CellGroupData[{

Cell["ComputerNumber[Pi - 22/7]", "Input",
 CellLabel->"In[15]:= ",
 CellTags->"S5.80.1"],

Cell[BoxData[
 TagBox[
  InterpretationBox["\<\"-0.001264000000000000000\"\>",
   -0.001264,
   AutoDelete->True],
  (BaseForm[#, 10]& )]], "Output",
 CellLabel->"Out[15]= ",
 CellTags->"S5.80.1"]
}, Open  ]],

Cell["\<\
If the separate parts are converted to computer numbers first, catastrophic \
cancellation of digits can occur. \
\>", "MathCaption",
 CellTags->{"S5.80.1", "1.22"}],

Cell[CellGroupData[{

Cell["ComputerNumber[Pi] - ComputerNumber[22/7]", "Input",
 CellLabel->"In[16]:= ",
 CellTags->"S5.80.1"],

Cell[BoxData[
 TagBox[
  InterpretationBox["\<\"-0.001000000000000000000\"\>",
   -0.001,
   AutoDelete->True],
  (BaseForm[#, 10]& )]], "Output",
 CellLabel->"Out[16]= ",
 CellTags->"S5.80.1"]
}, Open  ]],

Cell["\<\
Summing the terms from smallest to largest gives one answer. \
\>", "MathCaption",
 CellTags->{"S5.80.1", "1.23"}],

Cell[CellGroupData[{

Cell["\<\
(sum = 0;
 Do[sum += ComputerNumber[i]^(-2),
  {i, 200}];
 FullForm[sum])\
\>", "Input",
 CellLabel->"In[17]:= ",
 CellTags->"S5.80.1"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"ComputerNumber", "[", 
    RowBox[{"1", ",", "1625", ",", 
     RowBox[{"-", "3"}], ",", 
     RowBox[{"Rational", "[", 
      RowBox[{"13", ",", "8"}], "]"}], ",", 
     "1.63994654601499726794569455282818613228`23.698970004336047"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 CellLabel->"Out[17]//FullForm= ",
 CellTags->"S5.80.1"]
}, Open  ]],

Cell["\<\
As a general rule, it is better to sum from smallest to largest. You can see \
what the error is by comparing the mantissa (the second argument) to the \
correct value (the last argument). \
\>", "MathCaption",
 CellTags->{"S5.80.1", "1.24"}],

Cell[CellGroupData[{

Cell["\<\
(sum = 0;
 Do[sum += ComputerNumber[i]^(-2),
      {i, 200, 1, -1}];
 FullForm[sum])\
\>", "Input",
 CellLabel->"In[18]:= ",
 CellTags->"S5.80.1"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"ComputerNumber", "[", 
    RowBox[{"1", ",", "1640", ",", 
     RowBox[{"-", "3"}], ",", 
     RowBox[{"Rational", "[", 
      RowBox[{"41", ",", "25"}], "]"}], ",", 
     "1.63994654601499726794569455282818613228`23.69897000433602"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 CellLabel->"Out[18]//FullForm= ",
 CellTags->"S5.80.1"]
}, Open  ]],

Cell["\<\
Here is an example where summing from largest to smallest gives the better \
result. \
\>", "MathCaption",
 CellTags->{"S5.80.1", "1.25"}],

Cell[CellGroupData[{

Cell["\<\
(sum = 0;
 Do[sum += 1/ComputerNumber[i], {i, 300}];
 FullForm[sum])\
\>", "Input",
 CellLabel->"In[19]:= ",
 CellTags->"S5.80.1"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"ComputerNumber", "[", 
    RowBox[{"1", ",", "6281", ",", 
     RowBox[{"-", "3"}], ",", 
     RowBox[{"Rational", "[", 
      RowBox[{"6281", ",", "1000"}], "]"}], ",", 
     "6.28266388029950346191948554104728928323`23.99999999999999"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 CellLabel->"Out[19]//FullForm= ",
 CellTags->"S5.80.1"]
}, Open  ]],

Cell["The difference is slight, and such examples are rare. ", "MathCaption",
 CellTags->{"S5.80.1", "1.26"}],

Cell[CellGroupData[{

Cell["\<\
(sum = 0;
 Do[sum += 1/ComputerNumber[i],
      {i, 300, 1, -1}];
 FullForm[sum])\
\>", "Input",
 CellLabel->"In[20]:= ",
 CellTags->"S5.80.1"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"ComputerNumber", "[", 
    RowBox[{"1", ",", "6280", ",", 
     RowBox[{"-", "3"}], ",", 
     RowBox[{"Rational", "[", 
      RowBox[{"157", ",", "25"}], "]"}], ",", 
     "6.28266388029950346191948554104728928323`24.000000000000007"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 CellLabel->"Out[20]//FullForm= ",
 CellTags->"S5.80.1"]
}, Open  ]],

Cell["\<\
Basic arithmetic is all that is implemented in the package. We could easily \
extend things to include elementary functions. \
\>", "MathCaption",
 CellTags->{"S5.80.1", "1.27"}],

Cell[CellGroupData[{

Cell["Sin[ComputerNumber[N[Pi]/7]]", "Input",
 CellLabel->"In[21]:= ",
 CellTags->"S5.80.1"],

Cell[BoxData[
 RowBox[{"Sin", "[", 
  TagBox[
   InterpretationBox["\<\"0.4488000000000000000\"\>",
    0.4488,
    AutoDelete->True],
   (BaseForm[#, 10]& )], "]"}]], "Output",
 CellLabel->"Out[21]= ",
 CellTags->"S5.80.1"]
}, Open  ]],

Cell["Here is the square root of 47. ", "MathCaption",
 CellTags->{"S5.80.1", "1.28"}],

Cell[CellGroupData[{

Cell["sq = ComputerNumber[Sqrt[47]]", "Input",
 CellLabel->"In[22]:= ",
 CellTags->"S5.80.1"],

Cell[BoxData[
 TagBox[
  InterpretationBox["\<\"6.856000000000000000\"\>",
   6.856,
   AutoDelete->True],
  (BaseForm[#, 10]& )]], "Output",
 CellLabel->"Out[22]= ",
 CellTags->"S5.80.1"]
}, Open  ]],

Cell["\<\
It is a theorem that correctly rounded square roots of small integers will \
always square back to the original integer if the arithmetic is correct. \
\>", "MathCaption",
 CellTags->{"S5.80.1", "1.29"}],

Cell[CellGroupData[{

Cell["sq sq", "Input",
 CellLabel->"In[23]:= ",
 CellTags->"S5.80.1"],

Cell[BoxData[
 TagBox[
  InterpretationBox["\<\"47.00000000000000000\"\>",
   47.,
   AutoDelete->True],
  (BaseForm[#, 10]& )]], "Output",
 CellLabel->"Out[23]= ",
 CellTags->"S5.80.1"]
}, Open  ]],

Cell["But a similar theorem for cube roots does not exist. ", "MathCaption",
 CellTags->{"S5.80.1", "1.30"}],

Cell[CellGroupData[{

Cell["cr = ComputerNumber[3^(1/3)]; cr cr cr", "Input",
 CellLabel->"In[24]:= ",
 CellTags->"S5.80.1"],

Cell[BoxData[
 TagBox[
  InterpretationBox["\<\"2.998000000000000000\"\>",
   2.998,
   AutoDelete->True],
  (BaseForm[#, 10]& )]], "Output",
 CellLabel->"Out[24]= ",
 CellTags->"S5.80.1"]
}, Open  ]],

Cell[TextData[{
 "This changes the arithmetic to seven digits in base 10 with a rounding rule \
of ",
 StyleBox["RoundToEven", "MR"],
 " and an exponent range of ",
 Cell[BoxData[
  FormBox["-", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "50 to 50. "
}], "MathCaption",
 CellTags->{"S5.80.1", "1.31"}],

Cell[CellGroupData[{

Cell["SetArithmetic[7]", "Input",
 CellLabel->"In[25]:= ",
 CellTags->"S5.80.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"7", ",", "10", ",", 
   RowBox[{"RoundingRule", "\[Rule]", "RoundToEven"}], ",", 
   RowBox[{"ExponentRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "50"}], ",", "50"}], "}"}]}], ",", 
   RowBox[{"MixedMode", "\[Rule]", "False"}], ",", 
   RowBox[{"IdealDivide", "\[Rule]", "False"}]}], "}"}]], "Output",
 CellLabel->"Out[25]= ",
 CellTags->"S5.80.1"]
}, Open  ]],

Cell["This number rounds down. ", "MathCaption",
 CellTags->{"S5.80.1", "1.32"}],

Cell[CellGroupData[{

Cell["ComputerNumber[.9999999499999999999999999]", "Input",
 CellLabel->"In[26]:= ",
 CellTags->"S5.80.1"],

Cell[BoxData[
 TagBox[
  InterpretationBox["\<\"1.000000000000000000\"\>",
   1.,
   AutoDelete->True],
  (BaseForm[#, 10]& )]], "Output",
 CellLabel->"Out[26]= ",
 CellTags->"S5.80.1"]
}, Open  ]],

Cell["\<\
This number rounds up because it rounds toward the mantissa that is even \
(1000000) rather than the one that is odd (9999999). \
\>", "MathCaption",
 CellTags->{"S5.80.1", "1.33"}],

Cell[CellGroupData[{

Cell["ComputerNumber[.9999999500000000000000000]", "Input",
 CellLabel->"In[27]:= ",
 CellTags->"S5.80.1"],

Cell[BoxData[
 TagBox[
  InterpretationBox["\<\"1.000000000000000000\"\>",
   1.,
   AutoDelete->True],
  (BaseForm[#, 10]& )]], "Output",
 CellLabel->"Out[27]= ",
 CellTags->"S5.80.1"]
}, Open  ]],

Cell["\<\
Again it rounds toward the even mantissa (1000000 rather than 1000001). \
\>", "MathCaption",
 CellTags->{"S5.80.1", "1.34"}],

Cell[CellGroupData[{

Cell["ComputerNumber[1.000000500000000000000000]", "Input",
 CellLabel->"In[28]:= ",
 CellTags->"S5.80.1"],

Cell[BoxData[
 TagBox[
  InterpretationBox["\<\"1.000000000000000000\"\>",
   1.,
   AutoDelete->True],
  (BaseForm[#, 10]& )]], "Output",
 CellLabel->"Out[28]= ",
 CellTags->"S5.80.1"]
}, Open  ]],

Cell["\<\
The reciprocal of the reciprocal is not the original number; in fact it may \
be quite different. \
\>", "MathCaption",
 CellTags->{"S5.80.1", "1.35"}],

Cell[CellGroupData[{

Cell["(x = ComputerNumber[9010004]; y = 1/x; z = 1/y)", "Input",
 CellLabel->"In[29]:= ",
 CellTags->"S5.80.1"],

Cell[BoxData["9.0100069999999999999999999999998441`18.95472512838863*^6"], \
"Output",
 CellLabel->"Out[29]= ",
 CellTags->"S5.80.1"]
}, Open  ]],

Cell["\<\
This is multiplication by the reciprocal. It involves two rounding \
operations. \
\>", "MathCaption",
 CellTags->{"S5.80.1", "1.36"}],

Cell[CellGroupData[{

Cell["ComputerNumber[2]/x", "Input",
 CellLabel->"In[30]:= ",
 CellTags->"S5.80.1"],

Cell[BoxData["2.2197539999999999999999999999983`18.346304847260416*^-7"], \
"Output",
 CellLabel->"Out[30]= ",
 CellTags->"S5.80.1"]
}, Open  ]],

Cell[TextData[{
 "This is true division. It uses a single rounding operation. You can get \
this better type of division to work with \[OpenCurlyDoubleQuote]",
 StyleBox["/", "MR"],
 "\[CloseCurlyDoubleQuote] by setting the option ",
 StyleBox["IdealDivide", "MR"],
 " to ",
 StyleBox["True", "MR"],
 " when you use ",
 StyleBox["SetArithmetic", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.80.1", "1.37"}],

Cell[CellGroupData[{

Cell["IdealDivide[ComputerNumber[2], x]", "Input",
 CellLabel->"In[31]:= ",
 CellTags->"S5.80.1"],

Cell[BoxData["2.2197549999999999999999999999989`18.346305042910195*^-7"], \
"Output",
 CellLabel->"Out[31]= ",
 CellTags->"S5.80.1"]
}, Open  ]],

Cell[TextData[{
 StyleBox["Normal", "MR"],
 " converts a computer number back to an ordinary rational number with \
exactly the same value. "
}], "MathCaption",
 CellTags->{"S5.80.1", "1.38"}],

Cell[CellGroupData[{

Cell["Normal[ComputerNumber[Pi]]", "Input",
 CellLabel->"In[32]:= ",
 CellTags->"S5.80.1"],

Cell[BoxData[
 FractionBox["3141593", "1000000"]], "Output",
 CellLabel->"Out[32]= ",
 CellTags->"S5.80.1"]
}, Open  ]],

Cell["Now we change the arithmetic again. ", "MathCaption",
 CellTags->{"S5.80.1", "1.39"}],

Cell[CellGroupData[{

Cell["\<\
SetArithmetic[3, 2,
 RoundingRule -> Truncation,
    ExponentRange -> {-3,3}]\
\>", "Input",
 CellLabel->"In[33]:= ",
 CellTags->"S5.80.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "2", ",", 
   RowBox[{"RoundingRule", "\[Rule]", "Truncation"}], ",", 
   RowBox[{"ExponentRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "3"}], ",", "3"}], "}"}]}], ",", 
   RowBox[{"MixedMode", "\[Rule]", "False"}], ",", 
   RowBox[{"IdealDivide", "\[Rule]", "False"}]}], "}"}]], "Output",
 CellLabel->"Out[33]= ",
 CellTags->"S5.80.1"]
}, Open  ]],

Cell["\<\
This suppresses error messages that will result from plotting nonnumeric \
values in the following examples. \
\>", "MathCaption",
 CellTags->{"S5.80.1", "1.40"}],

Cell["\<\
Off[ComputerNumber::ovrflw];
Off[ComputerNumber::undflw];
Off[Plot::plnr];\
\>", "Input",
 CellLabel->"In[34]:= ",
 CellTags->"S5.80.1"],

Cell["\<\
It is easy to plot the error in the computer number representation of each \
number. \
\>", "MathCaption",
 CellTags->{"S5.80.1", "1.41"}],

Cell[CellGroupData[{

Cell["\<\
(error[n_?NumberQ] := Normal[ComputerNumber[n]] - n;
Plot[error[x], {x, -10, 10}, PlotPoints -> 193])\
\>", "Input",
 CellLabel->"In[35]:= ",
 CellTags->"S5.80.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.500063 0.0595337 0.308892 0.294506 [
[.05356 .29639 -12 -9 ]
[.05356 .29639 12 0 ]
[.20239 .29639 -6 -9 ]
[.20239 .29639 6 0 ]
[.35123 .29639 -12 -9 ]
[.35123 .29639 12 0 ]
[.6489 .29639 -9 -9 ]
[.6489 .29639 9 0 ]
[.79773 .29639 -3 -9 ]
[.79773 .29639 3 0 ]
[.94657 .29639 -9 -9 ]
[.94657 .29639 9 0 ]
[.48756 .01439 -12 -4.5 ]
[.48756 .01439 0 4.5 ]
[.48756 .16164 -24 -4.5 ]
[.48756 .16164 0 4.5 ]
[.48756 .45615 -18 -4.5 ]
[.48756 .45615 0 4.5 ]
[.48756 .6034 -6 -4.5 ]
[.48756 .6034 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.05356 .30889 m
.05356 .31514 L
s
[(-7.5)] .05356 .29639 0 1 Mshowa
.20239 .30889 m
.20239 .31514 L
s
[(-5)] .20239 .29639 0 1 Mshowa
.35123 .30889 m
.35123 .31514 L
s
[(-2.5)] .35123 .29639 0 1 Mshowa
.6489 .30889 m
.6489 .31514 L
s
[(2.5)] .6489 .29639 0 1 Mshowa
.79773 .30889 m
.79773 .31514 L
s
[(5)] .79773 .29639 0 1 Mshowa
.94657 .30889 m
.94657 .31514 L
s
[(7.5)] .94657 .29639 0 1 Mshowa
.125 Mabswid
.08333 .30889 m
.08333 .31264 L
s
.11309 .30889 m
.11309 .31264 L
s
.14286 .30889 m
.14286 .31264 L
s
.17263 .30889 m
.17263 .31264 L
s
.23216 .30889 m
.23216 .31264 L
s
.26193 .30889 m
.26193 .31264 L
s
.2917 .30889 m
.2917 .31264 L
s
.32146 .30889 m
.32146 .31264 L
s
.381 .30889 m
.381 .31264 L
s
.41076 .30889 m
.41076 .31264 L
s
.44053 .30889 m
.44053 .31264 L
s
.4703 .30889 m
.4703 .31264 L
s
.52983 .30889 m
.52983 .31264 L
s
.5596 .30889 m
.5596 .31264 L
s
.58936 .30889 m
.58936 .31264 L
s
.61913 .30889 m
.61913 .31264 L
s
.67866 .30889 m
.67866 .31264 L
s
.70843 .30889 m
.70843 .31264 L
s
.7382 .30889 m
.7382 .31264 L
s
.76796 .30889 m
.76796 .31264 L
s
.8275 .30889 m
.8275 .31264 L
s
.85727 .30889 m
.85727 .31264 L
s
.88703 .30889 m
.88703 .31264 L
s
.9168 .30889 m
.9168 .31264 L
s
.02379 .30889 m
.02379 .31264 L
s
.97633 .30889 m
.97633 .31264 L
s
.25 Mabswid
0 .30889 m
1 .30889 L
s
.50006 .01439 m
.50631 .01439 L
s
[(-1)] .48756 .01439 1 0 Mshowa
.50006 .16164 m
.50631 .16164 L
s
[(-0.5)] .48756 .16164 1 0 Mshowa
.50006 .45615 m
.50631 .45615 L
s
[(0.5)] .48756 .45615 1 0 Mshowa
.50006 .6034 m
.50631 .6034 L
s
[(1)] .48756 .6034 1 0 Mshowa
.125 Mabswid
.50006 .04384 m
.50381 .04384 L
s
.50006 .07329 m
.50381 .07329 L
s
.50006 .10274 m
.50381 .10274 L
s
.50006 .13219 m
.50381 .13219 L
s
.50006 .19109 m
.50381 .19109 L
s
.50006 .22054 m
.50381 .22054 L
s
.50006 .24999 m
.50381 .24999 L
s
.50006 .27944 m
.50381 .27944 L
s
.50006 .33834 m
.50381 .33834 L
s
.50006 .36779 m
.50381 .36779 L
s
.50006 .39724 m
.50381 .39724 L
s
.50006 .42669 m
.50381 .42669 L
s
.50006 .4856 m
.50381 .4856 L
s
.50006 .51505 m
.50381 .51505 L
s
.50006 .5445 m
.50381 .5445 L
s
.50006 .57395 m
.50381 .57395 L
s
.25 Mabswid
.50006 0 m
.50006 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .60332 m
.02393 .60274 L
.02414 .6017 L
.02563 .5943 L
.02901 .57759 L
.03527 .54662 L
.04174 .51464 L
.04796 .48384 L
.05395 .45421 L
.06033 .42268 L
.06646 .39232 L
.07236 .36314 L
.07564 .34693 L
.07864 .33206 L
.08159 .31749 L
.08231 .31395 L
.0827 .312 L
.08307 .31016 L
.08317 .30966 L
.08328 .30912 L
.0834 .60304 L
.08351 .6025 L
.08391 .60052 L
.08469 .59666 L
.09061 .56737 L
.09691 .53618 L
.10298 .50617 L
.10943 .47426 L
.11565 .44352 L
.12162 .41395 L
.12798 .38249 L
.13411 .3522 L
.13723 .33673 L
.13888 .32859 L
.14061 .32001 L
.14137 .31629 L
.14217 .3123 L
.14241 .31113 L
.14263 .31001 L
.14284 .30901 L
.14295 .60296 L
.14306 .60243 L
.14388 .59836 L
.14688 .5835 L
.15303 .55311 L
.15893 .52388 L
.16523 .49276 L
.17128 .46281 L
.17772 .43097 L
.18392 .4003 L
Mistroke
.18988 .3708 L
.19623 .3394 L
.19916 .32489 L
.20071 .31725 L
.20155 .31307 L
.20196 .31103 L
.20214 .31014 L
.20234 .30917 L
.20254 .60266 L
.20274 .6017 L
.20317 .59958 L
.20408 .59507 L
.20568 .58715 L
.20883 .57156 L
.2152 .54005 L
.22133 .50972 L
.22723 .48056 L
.2335 .44951 L
.23954 .41963 L
.24597 .38785 L
.25216 .35724 L
.25811 .3278 L
.25968 .32002 L
.26045 .31619 L
.26117 .31266 L
.26157 .31069 L
.26177 .30969 L
.26188 .30912 L
.26199 .45585 L
.2621 .45528 L
.26221 .45474 L
.26242 .45372 L
.26288 .45143 L
.26444 .44372 L
.27041 .41418 L
.27677 .38274 L
.28288 .35248 L
.28601 .33703 L
.28765 .3289 L
.28939 .32032 L
.29014 .3166 L
.29094 .31262 L
.29118 .31145 L
.2914 .31033 L
.29161 .30934 L
.29172 .45602 L
.29182 .4555 L
.29265 .45143 L
.29565 .43658 L
.30179 .40621 L
Mistroke
.30769 .37701 L
.31398 .34591 L
.31687 .33162 L
.3185 .32352 L
.3193 .31957 L
.32003 .31599 L
.3204 .31414 L
.32081 .31213 L
.32099 .31121 L
.32119 .31024 L
.32136 .30941 L
.32154 .45575 L
.32165 .45521 L
.32175 .4547 L
.32195 .45375 L
.32238 .45161 L
.32316 .44774 L
.32646 .43142 L
.33244 .40184 L
.3388 .37036 L
.34493 .34006 L
.34654 .33208 L
.34828 .32346 L
.34908 .3195 L
.34993 .31533 L
.35065 .31176 L
.35085 .31078 L
.35095 .31025 L
.35106 .30974 L
.35126 .45601 L
.35144 .45511 L
.35744 .42542 L
.36382 .39384 L
.36997 .36343 L
.37588 .33419 L
.37891 .31919 L
.37979 .31487 L
.38022 .31274 L
.38062 .31076 L
.3808 .30984 L
.38098 .30898 L
.38118 .38161 L
.38136 .3807 L
.38218 .37668 L
.3882 .34688 L
.39125 .33178 L
.39287 .32378 L
.39376 .31937 L
.39461 .31519 L
.3954 .31124 L
Mistroke
.39562 .31016 L
.39574 .30957 L
.39586 .30901 L
.39605 .38165 L
.39616 .38113 L
.39627 .38057 L
.3978 .37304 L
.40077 .3583 L
.40384 .34312 L
.4072 .32651 L
.40875 .31884 L
.4096 .31463 L
.41002 .31256 L
.41021 .31165 L
.41041 .31065 L
.4106 .30972 L
.41077 .38247 L
.41096 .38155 L
.41116 .38056 L
.41197 .37654 L
.41339 .36951 L
.41648 .35425 L
.41984 .33761 L
.4214 .32989 L
.42306 .32167 L
.42387 .31767 L
.42463 .31391 L
.42496 .31227 L
.42531 .31053 L
.4255 .30963 L
.4257 .38226 L
.42588 .38135 L
.42605 .38051 L
.43214 .3504 L
.43524 .33506 L
.43687 .32697 L
.43861 .31839 L
.43935 .31472 L
.43974 .3128 L
.44015 .31077 L
.44037 .30969 L
.44049 .30908 L
.44061 .34532 L
.44081 .34432 L
.44103 .34325 L
.44185 .33918 L
.44484 .32437 L
.44645 .31644 L
.44689 .31426 L
.44735 .31197 L
Mistroke
.44754 .31102 L
.44775 .31 L
.44786 .30942 L
.44797 .3457 L
.44808 .34517 L
.44818 .34466 L
.45133 .32907 L
.45284 .32163 L
.45366 .31754 L
.45444 .31371 L
.45476 .31212 L
.4551 .31046 L
.45527 .30958 L
.45547 .34544 L
.45564 .34457 L
.45581 .34376 L
.45732 .33629 L
.45896 .32817 L
.46051 .3205 L
.4619 .31361 L
.46228 .31173 L
.46249 .31069 L
.46269 .30973 L
.46285 .3089 L
.46303 .34483 L
.46323 .34385 L
.46341 .34295 L
.46663 .32703 L
.4682 .31928 L
.46894 .31562 L
.46962 .31225 L
.46997 .31053 L
.47014 .30966 L
.47033 .32712 L
.47053 .32616 L
.47073 .32514 L
.47111 .32329 L
.47251 .31636 L
.4729 .3144 L
.47334 .31227 L
.47353 .31129 L
.47374 .31025 L
.47392 .30937 L
.47412 .3268 L
.47431 .32585 L
.47448 .32499 L
.47488 .32305 L
.47559 .31953 L
.47633 .31586 L
.47674 .31385 L
Mistroke
.47712 .31195 L
.47748 .31017 L
.47768 .30917 L
.47787 .32666 L
.47802 .32588 L
.4782 .32503 L
.47855 .3233 L
.47935 .31931 L
.48022 .31503 L
.48064 .31296 L
.48103 .31099 L
.48121 .31013 L
.48139 .30922 L
.48159 .32663 L
.48178 .3257 L
.48339 .31773 L
.48424 .31354 L
.4847 .31125 L
.48493 .31013 L
.48513 .30912 L
.48533 .31736 L
.48551 .31644 L
.48592 .31444 L
.48637 .31223 L
.48656 .31126 L
.48678 .31019 L
.48696 .30929 L
.48713 .31765 L
.48731 .31676 L
.4875 .31581 L
.48829 .31192 L
.48849 .31091 L
.48868 .30996 L
.48879 .30944 L
.48891 .31807 L
.48911 .31708 L
.48987 .31332 L
.4903 .31116 L
.49052 .31008 L
.49065 .30946 L
.49076 .31809 L
.49087 .31756 L
.49097 .31706 L
.49116 .31611 L
.49159 .314 L
.49237 .31014 L
.49254 .30932 L
Mfstroke
.50751 .30888 m
.50761 .30836 L
.50801 .30641 L
.50874 .30276 L
.50913 .30087 L
.50923 .30035 L
.50934 .29979 L
.50955 .30799 L
.50966 .30745 L
.50978 .30686 L
.50999 .30579 L
.5104 .30378 L
.51079 .30187 L
.51097 .30093 L
.51115 .30007 L
.51135 .30828 L
.51146 .30775 L
.51157 .3072 L
.51195 .30532 L
.51263 .30193 L
.51282 .30101 L
.51302 .30001 L
.51321 .30828 L
.51338 .30742 L
.51409 .30391 L
.51448 .30198 L
.51467 .30104 L
.51485 .30018 L
.51504 .30844 L
.51524 .30743 L
.51568 .30529 L
.51644 .3015 L
.51785 .29452 L
.51819 .29283 L
.51838 .2919 L
.51856 .29102 L
.51866 .29052 L
.51877 .30838 L
.51896 .30744 L
.51933 .30559 L
.52082 .29826 L
.52122 .29626 L
.52166 .2941 L
.52187 .29306 L
.52207 .29207 L
.52225 .29118 L
.52244 .30862 L
.52255 .30808 L
.52267 .30751 L
.52288 .30647 L
Mistroke
.52327 .30452 L
.52415 .30017 L
.52497 .29612 L
.52537 .29414 L
.52573 .29234 L
.52591 .29146 L
.5261 .29051 L
.52629 .30802 L
.52645 .30718 L
.52723 .30337 L
.528 .29953 L
.52886 .29529 L
.52926 .29332 L
.52948 .29224 L
.52958 .2917 L
.52968 .2912 L
.52988 .30866 L
.52998 .30815 L
.53009 .30761 L
.53046 .30578 L
.53215 .2974 L
.53376 .28945 L
.5355 .28085 L
.5363 .2769 L
.53673 .27474 L
.53695 .27369 L
.53714 .27272 L
.53732 .30866 L
.53749 .30782 L
.53786 .30598 L
.53865 .30207 L
.5415 .28798 L
.54312 .27997 L
.54391 .27604 L
.54426 .27432 L
.54444 .27341 L
.54464 .27244 L
.54484 .30828 L
.54502 .3074 L
.54537 .30567 L
.54613 .3019 L
.54773 .29397 L
.54944 .28552 L
.55019 .28181 L
.55101 .27773 L
.55138 .27593 L
.55177 .27401 L
.55195 .27307 L
.55213 .27219 L
.55229 .3082 L
Mistroke
.55247 .30734 L
.55401 .29971 L
.55572 .29127 L
.55726 .28363 L
.55802 .27986 L
.55842 .27788 L
.55885 .27578 L
.55922 .27395 L
.55932 .27345 L
.55943 .27291 L
.55963 .30875 L
.55982 .3078 L
.56 .3069 L
.56034 .30521 L
.56362 .28899 L
.56962 .25932 L
.57271 .24401 L
.57347 .24028 L
.57386 .23833 L
.57408 .23727 L
.57428 .23628 L
.57438 .23575 L
.5745 .30881 L
.57462 .30818 L
.57474 .30761 L
.57516 .30551 L
.576 .30138 L
.58225 .27044 L
.58512 .25625 L
.58675 .24819 L
.58755 .24426 L
.58827 .24066 L
.58864 .23884 L
.58884 .23788 L
.58904 .23685 L
.58922 .23596 L
.58942 .3086 L
.5896 .30771 L
.58977 .30686 L
.59138 .2989 L
.59467 .28262 L
.60071 .25274 L
.60233 .24473 L
.60312 .24082 L
.60384 .23727 L
.60403 .23634 L
.60423 .23533 L
.60443 .30801 L
.6046 .30713 L
.60542 .30311 L
Mistroke
.60714 .29459 L
.61032 .27887 L
.61329 .26416 L
.61614 .25006 L
.61696 .246 L
.61774 .24214 L
.61844 .23867 L
.61863 .23773 L
.61884 .23671 L
.61903 .23576 L
.61921 .30852 L
.61939 .30759 L
.61957 .30672 L
.61997 .30475 L
.62077 .30077 L
.62221 .29363 L
.62547 .27754 L
.63155 .24744 L
.63802 .21546 L
.64125 .19945 L
.64425 .18464 L
.64715 .17027 L
.64786 .16677 L
.64823 .16494 L
.64862 .16301 L
.64872 .16251 L
.64883 .16198 L
.64895 .30865 L
.64906 .3081 L
.64946 .30613 L
.65024 .30225 L
.65673 .27016 L
.66298 .23924 L
.66899 .20949 L
.67204 .19442 L
.67539 .17784 L
.67692 .17025 L
.67777 .16607 L
.67819 .16401 L
.67839 .163 L
.67857 .1621 L
.67876 .30843 L
.67893 .30757 L
.67932 .30567 L
.68013 .30165 L
.68155 .29462 L
.68758 .26477 L
.694 .23302 L
.70018 .20244 L
.7033 .18704 L
Mistroke
.70613 .17303 L
.70688 .16931 L
.70728 .16734 L
.7077 .16526 L
.70807 .16344 L
.70817 .16294 L
.70828 .16241 L
.70847 .30869 L
.70866 .30775 L
.70884 .30685 L
.70918 .30516 L
.71246 .28898 L
.71842 .25947 L
.72477 .22806 L
.73088 .19782 L
.734 .18239 L
.73564 .17427 L
.73654 .16983 L
.73738 .16569 L
.73776 .16379 L
.73795 .16285 L
.73813 .16198 L
.73833 .30824 L
.73844 .30771 L
.73855 .30715 L
.73893 .30526 L
.74064 .29682 L
.74364 .28198 L
.74953 .25281 L
.75581 .22174 L
.76186 .19185 L
.76828 .16006 L
.77447 .12944 L
.78043 .09999 L
.78676 .06865 L
.79286 .03847 L
.79446 .03056 L
.7953 .0264 L
.7962 .02198 L
.79698 .01812 L
.79719 .01707 L
.79742 .01593 L
.79753 .01538 L
.79764 .01486 L
.79783 .30839 L
.79802 .30749 L
.79821 .30653 L
.79856 .30481 L
.79934 .30091 L
.80585 .26874 L
Mistroke
.81212 .23774 L
.81815 .20791 L
.82456 .17618 L
.83074 .14563 L
.83667 .11624 L
.843 .08497 L
.84908 .05486 L
.85218 .03952 L
.85382 .03144 L
.85555 .02286 L
.85629 .01919 L
.85668 .01726 L
.8569 .01621 L
.85709 .01524 L
.8572 .01472 L
.85731 .30866 L
.85744 .30804 L
.85755 .30748 L
.85797 .30541 L
.85879 .30134 L
.86179 .28653 L
.86804 .2556 L
.87406 .22583 L
.88046 .19417 L
.88662 .16368 L
.89255 .13436 L
.89886 .10315 L
.90493 .07311 L
.90802 .05782 L
.91138 .04117 L
.91295 .03343 L
.91461 .0252 L
.9153 .02182 L
.91603 .01817 L
.91624 .01716 L
.91646 .01609 L
.91664 .01517 L
.91684 .30868 L
.91703 .30774 L
.91724 .30673 L
.9176 .30491 L
.92408 .27287 L
.93032 .242 L
.93632 .2123 L
.94271 .18071 L
.94886 .15028 L
.95477 .12103 L
.96107 .08988 L
.96713 .05991 L
.97357 .02803 L
Mistroke
.97511 .02042 L
.9758 .017 L
.97619 .01509 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.80.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[37]= ",
 CellTags->"S5.80.1"]
}, Open  ]],

Cell["You can zoom in to see the hole at zero. ", "MathCaption",
 CellTags->{"S5.80.1", "1.42"}],

Cell[CellGroupData[{

Cell["Plot[error[x], {x, -1, 1}, PlotPoints -> 47]", "Input",
 CellLabel->"In[36]:= ",
 CellTags->"S5.80.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.47619 0.309017 2.35442 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -12 -9 ]
[.2619 .29652 12 0 ]
[.7381 .29652 -9 -9 ]
[.7381 .29652 9 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 .07358 -24 -4.5 ]
[.4875 .07358 0 4.5 ]
[.4875 .1913 -30 -4.5 ]
[.4875 .1913 0 4.5 ]
[.4875 .42674 -24 -4.5 ]
[.4875 .42674 0 4.5 ]
[.4875 .54446 -18 -4.5 ]
[.4875 .54446 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-1)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-0.5)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(0.5)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(1)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.07143 .30902 m
.07143 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.16667 .30902 m
.16667 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.35714 .30902 m
.35714 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.45238 .30902 m
.45238 .31277 L
s
.54762 .30902 m
.54762 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.64286 .30902 m
.64286 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.83333 .30902 m
.83333 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.92857 .30902 m
.92857 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 .07358 m
.50625 .07358 L
s
[(-0.1)] .4875 .07358 1 0 Mshowa
.5 .1913 m
.50625 .1913 L
s
[(-0.05)] .4875 .1913 1 0 Mshowa
.5 .42674 m
.50625 .42674 L
s
[(0.05)] .4875 .42674 1 0 Mshowa
.5 .54446 m
.50625 .54446 L
s
[(0.1)] .4875 .54446 1 0 Mshowa
.125 Mabswid
.5 .09712 m
.50375 .09712 L
s
.5 .12066 m
.50375 .12066 L
s
.5 .14421 m
.50375 .14421 L
s
.5 .16775 m
.50375 .16775 L
s
.5 .21484 m
.50375 .21484 L
s
.5 .23838 m
.50375 .23838 L
s
.5 .26193 m
.50375 .26193 L
s
.5 .28547 m
.50375 .28547 L
s
.5 .33256 m
.50375 .33256 L
s
.5 .35611 m
.50375 .35611 L
s
.5 .37965 m
.50375 .37965 L
s
.5 .40319 m
.50375 .40319 L
s
.5 .45028 m
.50375 .45028 L
s
.5 .47383 m
.50375 .47383 L
s
.5 .49737 m
.50375 .49737 L
s
.5 .52091 m
.50375 .52091 L
s
.5 .05003 m
.50375 .05003 L
s
.5 .02649 m
.50375 .02649 L
s
.5 .00294 m
.50375 .00294 L
s
.5 .568 m
.50375 .568 L
s
.5 .59155 m
.50375 .59155 L
s
.5 .61509 m
.50375 .61509 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .60332 m
.04397 .50365 L
.05446 .45178 L
.06595 .39496 L
.07111 .36943 L
.07664 .34211 L
.07932 .32886 L
.08064 .32235 L
.08185 .31634 L
.08242 .31352 L
.08296 .31088 L
.08351 .60242 L
.08413 .59939 L
.0866 .58718 L
.10683 .48717 L
.11711 .43632 L
.12833 .38082 L
.13353 .35511 L
.13639 .341 L
.13908 .32771 L
.1403 .32166 L
.14159 .31528 L
.14227 .31194 L
.14265 .31005 L
.14301 .60258 L
.14363 .59948 L
.14431 .59614 L
.14905 .57269 L
.17063 .466 L
.18143 .41261 L
.19142 .36321 L
.19642 .33848 L
.19887 .32637 L
.20112 .31527 L
.20171 .31233 L
.20226 .30959 L
.20284 .60104 L
.20347 .59792 L
.20601 .58536 L
.21142 .55864 L
.23179 .45792 L
.24218 .40655 L
.24765 .3795 L
.25344 .35087 L
.25861 .32531 L
.26002 .31831 L
.26081 .31445 L
.26119 .31255 L
.26155 .31079 L
.26223 .45455 L
Mistroke
.2626 .45275 L
.26298 .45084 L
.26429 .44436 L
.2743 .39488 L
.27968 .36828 L
.28549 .33954 L
.28816 .32634 L
.28962 .31913 L
.29033 .31561 L
.29098 .31241 L
.29158 .30946 L
.29214 .45382 L
.29274 .45087 L
.29339 .44767 L
.29602 .43463 L
.30616 .38452 L
.31154 .35793 L
.31436 .34397 L
.31733 .32929 L
.31861 .32297 L
.31997 .31623 L
.32037 .31424 L
.32075 .31236 L
.32109 .31067 L
.32146 .45599 L
.32182 .45425 L
.32219 .45241 L
.32285 .44912 L
.32792 .4241 L
.33784 .37502 L
.34278 .35061 L
.3455 .33717 L
.34808 .32442 L
.34924 .31868 L
.35047 .31259 L
.35111 .30941 L
.35148 .45475 L
.35182 .45305 L
.35307 .44685 L
.35764 .4243 L
.36726 .3767 L
.37272 .34971 L
.37538 .33655 L
.3778 .32458 L
.37905 .31843 L
.3797 .31519 L
.38006 .31341 L
.3804 .31175 L
.38101 .38233 L
.38167 .37902 L
Mistroke
.38285 .3732 L
.38825 .34652 L
.39097 .33308 L
.39355 .3203 L
.39497 .31326 L
.39536 .31133 L
.39578 .30928 L
.39617 .38091 L
.39653 .37916 L
.39925 .36569 L
.40414 .34152 L
.40681 .32832 L
.4093 .316 L
.40997 .3127 L
.4106 .30956 L
.41095 .38141 L
.41133 .37953 L
.412 .37623 L
.41496 .36159 L
.42017 .33586 L
.42253 .32418 L
.42377 .31804 L
.42445 .3147 L
.42508 .31159 L
.42541 .30992 L
.42577 .38172 L
.42617 .37975 L
.42653 .37795 L
.42787 .37135 L
.43049 .35839 L
.43613 .3305 L
.43869 .31787 L
.44013 .31074 L
Mfstroke
.5596 .30865 m
.55993 .307 L
.56482 .28282 L
.56736 .27029 L
.57007 .25688 L
.57138 .25038 L
.57263 .24422 L
.57375 .2387 L
.57438 .23558 L
.57496 .30628 L
.5756 .30313 L
.57628 .29973 L
.57752 .2936 L
.58035 .27963 L
.58331 .26497 L
.58607 .25136 L
.58738 .24487 L
.58802 .24169 L
.58862 .23876 L
.5893 .30895 L
.58966 .30717 L
.59004 .30528 L
.59133 .29889 L
.59709 .27045 L
.5995 .25853 L
.60208 .24575 L
.60284 .24198 L
.60322 .24013 L
.60357 .23841 L
.60421 .30879 L
.60456 .3071 L
.60492 .3053 L
.60757 .2922 L
.61245 .26805 L
.61502 .25536 L
.61642 .24844 L
.61772 .242 L
.61831 .23908 L
.61887 .23632 L
.61951 .30672 L
.6201 .30383 L
.62269 .29098 L
.62726 .26843 L
.63681 .2212 L
.64224 .19436 L
.64489 .18123 L
.64732 .16923 L
.64791 .1663 L
.64855 .16317 L
.64891 .30852 L
Mistroke
.64924 .30689 L
.64988 .30371 L
.65232 .29168 L
.65768 .26513 L
.6634 .23685 L
.66866 .21086 L
.67356 .18667 L
.67602 .17449 L
.67669 .17115 L
.67742 .16758 L
.6781 .16421 L
.67872 .30829 L
.67939 .30495 L
.68011 .30141 L
.6814 .29506 L
.6843 .28068 L
.68959 .25455 L
.69449 .23033 L
.69976 .20425 L
.70219 .19224 L
.70474 .17962 L
.70692 .16884 L
.70752 .16589 L
.70816 .16274 L
.70876 .30692 L
.7093 .30422 L
.72017 .25048 L
.72494 .22689 L
.73019 .20098 L
.73262 .18894 L
.73523 .17602 L
.7365 .16977 L
.73712 .16669 L
.7377 .16383 L
.73822 .3084 L
.73878 .30566 L
.73995 .29985 L
.75028 .2488 L
.76995 .15153 L
.78087 .09751 L
.78566 .07385 L
.7909 .04794 L
.79336 .03579 L
.79471 .02912 L
.79598 .02281 L
.79656 .01995 L
.79717 .01693 L
.79784 .30792 L
.79846 .30485 L
.80072 .29371 L
Mistroke
.81106 .24255 L
.83081 .14493 L
.84179 .09065 L
.85183 .04099 L
.85423 .02912 L
.85555 .0226 L
.85619 .0194 L
.85679 .01646 L
.85713 .01476 L
.8575 .30727 L
.85786 .30546 L
.85826 .30348 L
.8596 .29688 L
.8622 .284 L
.87206 .23525 L
.89316 .13095 L
.90288 .08286 L
.90801 .0575 L
.91346 .03056 L
.91478 .02405 L
.91547 .02063 L
.9162 .01703 L
.91659 .01511 L
.91701 .30731 L
.9174 .3054 L
.91776 .30363 L
.91922 .2964 L
.92455 .27006 L
.93504 .21815 L
.95542 .11741 L
.97619 .01472 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.80.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[38]= ",
 CellTags->"S5.80.1"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.80.1"->{
    Cell[1776, 53, 148, 6, 36, "Subsection",
      CellTags->{"S5.80.1", "1.1"}],
    Cell[1927, 61, 772, 15, 120, "Text",
      CellTags->{"S5.80.1", "1.2"}],
    Cell[2702, 78, 4661, 143, 162, "DefinitionBox",
      CellTags->"S5.80.1"],
    Cell[7366, 223, 152, 5, 15, "Caption",
      CellTags->"S5.80.1"],
    Cell[7521, 230, 890, 14, 136, "Text",
      CellTags->{"S5.80.1", "1.3"}],
    Cell[8414, 246, 78, 1, 40, "MathCaption",
      CellTags->{"S5.80.1", "1.4"}],
    Cell[8495, 249, 98, 2, 28, "Input",
      CellTags->"S5.80.1"],
    Cell[8596, 253, 126, 3, 38, "MathCaption",
      CellTags->{"S5.80.1", "1.5"}],
    Cell[8747, 260, 84, 2, 28, "Input",
      CellTags->"S5.80.1"],
    Cell[8834, 264, 184, 7, 25, "Output",
      CellTags->"S5.80.1"],
    Cell[9033, 274, 241, 7, 70, "MathCaption",
      CellTags->{"S5.80.1", "1.6"}],
    Cell[9299, 285, 85, 2, 70, "Input",
      CellTags->"S5.80.1"],
    Cell[9387, 289, 187, 7, 70, "Output",
      CellTags->"S5.80.1"],
    Cell[9589, 299, 132, 3, 70, "MathCaption",
      CellTags->{"S5.80.1", "1.7"}],
    Cell[9746, 306, 72, 2, 70, "Input",
      CellTags->"S5.80.1"],
    Cell[9821, 310, 187, 7, 70, "Output",
      CellTags->"S5.80.1"],
    Cell[10023, 320, 132, 5, 70, "MathCaption",
      CellTags->{"S5.80.1", "1.8"}],
    Cell[10180, 329, 75, 2, 70, "Input",
      CellTags->"S5.80.1"],
    Cell[10258, 333, 169, 5, 70, "Output",
      CellTags->"S5.80.1"],
    Cell[10442, 341, 114, 2, 70, "MathCaption",
      CellTags->{"S5.80.1", "1.9"}],
    Cell[10581, 347, 91, 2, 70, "Input",
      CellTags->"S5.80.1"],
    Cell[10675, 351, 195, 7, 70, "Output",
      CellTags->"S5.80.1"],
    Cell[10885, 361, 268, 6, 70, "MathCaption",
      CellTags->{"S5.80.1", "1.10"}],
    Cell[11178, 371, 89, 2, 70, "Input",
      CellTags->"S5.80.1"],
    Cell[11270, 375, 76, 2, 70, "Output",
      CellTags->"S5.80.1"],
    Cell[11361, 380, 2738, 86, 70, "DefinitionBox",
      CellTags->"S5.80.1"],
    Cell[14102, 468, 85, 1, 70, "Caption",
      CellTags->"S5.80.1"],
    Cell[14190, 471, 775, 19, 70, "MathCaption",
      CellTags->{"S5.80.1", "1.11"}],
    Cell[14990, 494, 76, 2, 70, "Input",
      CellTags->"S5.80.1"],
    Cell[15069, 498, 414, 11, 70, "Output",
      CellTags->"S5.80.1"],
    Cell[15498, 512, 109, 1, 70, "MathCaption",
      CellTags->{"S5.80.1", "1.12"}],
    Cell[15632, 517, 82, 2, 70, "Input",
      CellTags->"S5.80.1"],
    Cell[15717, 521, 413, 11, 70, "Output",
      CellTags->"S5.80.1"],
    Cell[16145, 535, 130, 3, 70, "MathCaption",
      CellTags->{"S5.80.1", "1.13"}],
    Cell[16300, 542, 82, 2, 70, "Input",
      CellTags->"S5.80.1"],
    Cell[16385, 546, 219, 8, 70, "Output",
      CellTags->"S5.80.1"],
    Cell[16619, 557, 394, 7, 70, "Text",
      CellTags->{"S5.80.1", "1.14"}],
    Cell[17016, 566, 4553, 131, 70, "DefinitionBox3Col",
      CellTags->"S5.80.1"],
    Cell[21572, 699, 108, 5, 70, "Caption",
      CellTags->"S5.80.1"],
    Cell[21683, 706, 974, 32, 70, "Text",
      CellTags->{"S5.80.1", "1.15"}],
    Cell[22660, 740, 2032, 60, 70, "DefinitionBox",
      CellTags->"S5.80.1"],
    Cell[24695, 802, 70, 1, 70, "Caption",
      CellTags->"S5.80.1"],
    Cell[24768, 805, 181, 4, 70, "MathCaption",
      CellTags->{"S5.80.1", "1.16"}],
    Cell[24974, 813, 84, 2, 70, "Input",
      CellTags->"S5.80.1"],
    Cell[25061, 817, 247, 9, 70, "Output",
      CellTags->"S5.80.1"],
    Cell[25323, 829, 165, 4, 70, "MathCaption",
      CellTags->{"S5.80.1", "1.17"}],
    Cell[25513, 837, 103, 2, 70, "Input",
      CellTags->"S5.80.1"],
    Cell[25619, 841, 414, 11, 70, "Output",
      CellTags->"S5.80.1"],
    Cell[26048, 855, 84, 1, 70, "MathCaption",
      CellTags->{"S5.80.1", "1.18"}],
    Cell[26157, 860, 84, 2, 70, "Input",
      CellTags->"S5.80.1"],
    Cell[26244, 864, 219, 8, 70, "Output",
      CellTags->"S5.80.1"],
    Cell[26478, 875, 215, 5, 70, "Text",
      CellTags->{"S5.80.1", "1.19"}],
    Cell[26696, 882, 101, 1, 70, "MathCaption",
      CellTags->{"S5.80.1", "1.20"}],
    Cell[26822, 887, 84, 2, 70, "Input",
      CellTags->"S5.80.1"],
    Cell[26909, 891, 415, 11, 70, "Output",
      CellTags->"S5.80.1"],
    Cell[27339, 905, 138, 3, 70, "MathCaption",
      CellTags->{"S5.80.1", "1.21"}],
    Cell[27502, 912, 89, 2, 70, "Input",
      CellTags->"S5.80.1"],
    Cell[27594, 916, 196, 7, 70, "Output",
      CellTags->"S5.80.1"],
    Cell[27805, 926, 175, 4, 70, "MathCaption",
      CellTags->{"S5.80.1", "1.22"}],
    Cell[28005, 934, 105, 2, 70, "Input",
      CellTags->"S5.80.1"],
    Cell[28113, 938, 193, 7, 70, "Output",
      CellTags->"S5.80.1"],
    Cell[28321, 948, 124, 3, 70, "MathCaption",
      CellTags->{"S5.80.1", "1.23"}],
    Cell[28470, 955, 145, 7, 70, "Input",
      CellTags->"S5.80.1"],
    Cell[28618, 964, 457, 14, 70, "Output",
      CellTags->"S5.80.1"],
    Cell[29090, 981, 252, 5, 70, "MathCaption",
      CellTags->{"S5.80.1", "1.24"}],
    Cell[29367, 990, 156, 7, 70, "Input",
      CellTags->"S5.80.1"],
    Cell[29526, 999, 457, 14, 70, "Output",
      CellTags->"S5.80.1"],
    Cell[29998, 1016, 148, 4, 70, "MathCaption",
      CellTags->{"S5.80.1", "1.25"}],
    Cell[30171, 1024, 140, 6, 70, "Input",
      CellTags->"S5.80.1"],
    Cell[30314, 1032, 461, 14, 70, "Output",
      CellTags->"S5.80.1"],
    Cell[30790, 1049, 109, 1, 70, "MathCaption",
      CellTags->{"S5.80.1", "1.26"}],
    Cell[30924, 1054, 153, 7, 70, "Input",
      CellTags->"S5.80.1"],
    Cell[31080, 1063, 459, 14, 70, "Output",
      CellTags->"S5.80.1"],
    Cell[31554, 1080, 188, 4, 70, "MathCaption",
      CellTags->{"S5.80.1", "1.27"}],
    Cell[31767, 1088, 92, 2, 70, "Input",
      CellTags->"S5.80.1"],
    Cell[31862, 1092, 224, 8, 70, "Output",
      CellTags->"S5.80.1"],
    Cell[32101, 1103, 86, 1, 70, "MathCaption",
      CellTags->{"S5.80.1", "1.28"}],
    Cell[32212, 1108, 93, 2, 70, "Input",
      CellTags->"S5.80.1"],
    Cell[32308, 1112, 188, 7, 70, "Output",
      CellTags->"S5.80.1"],
    Cell[32511, 1122, 213, 4, 70, "MathCaption",
      CellTags->{"S5.80.1", "1.29"}],
    Cell[32749, 1130, 69, 2, 70, "Input",
      CellTags->"S5.80.1"],
    Cell[32821, 1134, 186, 7, 70, "Output",
      CellTags->"S5.80.1"],
    Cell[33022, 1144, 108, 1, 70, "MathCaption",
      CellTags->{"S5.80.1", "1.30"}],
    Cell[33155, 1149, 102, 2, 70, "Input",
      CellTags->"S5.80.1"],
    Cell[33260, 1153, 188, 7, 70, "Output",
      CellTags->"S5.80.1"],
    Cell[33463, 1163, 341, 10, 70, "MathCaption",
      CellTags->{"S5.80.1", "1.31"}],
    Cell[33829, 1177, 80, 2, 70, "Input",
      CellTags->"S5.80.1"],
    Cell[33912, 1181, 415, 11, 70, "Output",
      CellTags->"S5.80.1"],
    Cell[34342, 1195, 80, 1, 70, "MathCaption",
      CellTags->{"S5.80.1", "1.32"}],
    Cell[34447, 1200, 106, 2, 70, "Input",
      CellTags->"S5.80.1"],
    Cell[34556, 1204, 185, 7, 70, "Output",
      CellTags->"S5.80.1"],
    Cell[34756, 1214, 191, 4, 70, "MathCaption",
      CellTags->{"S5.80.1", "1.33"}],
    Cell[34972, 1222, 106, 2, 70, "Input",
      CellTags->"S5.80.1"],
    Cell[35081, 1226, 185, 7, 70, "Output",
      CellTags->"S5.80.1"],
    Cell[35281, 1236, 135, 3, 70, "MathCaption",
      CellTags->{"S5.80.1", "1.34"}],
    Cell[35441, 1243, 106, 2, 70, "Input",
      CellTags->"S5.80.1"],
    Cell[35550, 1247, 185, 7, 70, "Output",
      CellTags->"S5.80.1"],
    Cell[35750, 1257, 161, 4, 70, "MathCaption",
      CellTags->{"S5.80.1", "1.35"}],
    Cell[35936, 1265, 111, 2, 70, "Input",
      CellTags->"S5.80.1"],
    Cell[36050, 1269, 133, 3, 70, "Output",
      CellTags->"S5.80.1"],
    Cell[36198, 1275, 144, 4, 70, "MathCaption",
      CellTags->{"S5.80.1", "1.36"}],
    Cell[36367, 1283, 83, 2, 70, "Input",
      CellTags->"S5.80.1"],
    Cell[36453, 1287, 132, 3, 70, "Output",
      CellTags->"S5.80.1"],
    Cell[36600, 1293, 409, 12, 70, "MathCaption",
      CellTags->{"S5.80.1", "1.37"}],
    Cell[37034, 1309, 97, 2, 70, "Input",
      CellTags->"S5.80.1"],
    Cell[37134, 1313, 132, 3, 70, "Output",
      CellTags->"S5.80.1"],
    Cell[37281, 1319, 192, 5, 70, "MathCaption",
      CellTags->{"S5.80.1", "1.38"}],
    Cell[37498, 1328, 90, 2, 70, "Input",
      CellTags->"S5.80.1"],
    Cell[37591, 1332, 107, 3, 70, "Output",
      CellTags->"S5.80.1"],
    Cell[37713, 1338, 91, 1, 70, "MathCaption",
      CellTags->{"S5.80.1", "1.39"}],
    Cell[37829, 1343, 149, 6, 70, "Input",
      CellTags->"S5.80.1"],
    Cell[37981, 1351, 411, 11, 70, "Output",
      CellTags->"S5.80.1"],
    Cell[38407, 1365, 172, 4, 70, "MathCaption",
      CellTags->{"S5.80.1", "1.40"}],
    Cell[38582, 1371, 146, 6, 70, "Input",
      CellTags->"S5.80.1"],
    Cell[38731, 1379, 148, 4, 70, "MathCaption",
      CellTags->{"S5.80.1", "1.41"}],
    Cell[38904, 1387, 173, 5, 70, "Input",
      CellTags->"S5.80.1"],
    Cell[39080, 1394, 12936, 852, 70, 12865, 849, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.80.1"],
    Cell[52019, 2248, 181, 6, 70, "Output",
      CellTags->"S5.80.1"],
    Cell[52215, 2257, 96, 1, 70, "MathCaption",
      CellTags->{"S5.80.1", "1.42"}],
    Cell[52336, 2262, 108, 2, 70, "Input",
      CellTags->"S5.80.1"],
    Cell[52447, 2266, 7078, 485, 70, 7007, 482, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.80.1"],
    Cell[59528, 2753, 181, 6, 70, "Output",
      CellTags->"S5.80.1"]},
  "1.1"->{
    Cell[1776, 53, 148, 6, 36, "Subsection",
      CellTags->{"S5.80.1", "1.1"}]},
  "1.2"->{
    Cell[1927, 61, 772, 15, 120, "Text",
      CellTags->{"S5.80.1", "1.2"}]},
  "1.3"->{
    Cell[7521, 230, 890, 14, 136, "Text",
      CellTags->{"S5.80.1", "1.3"}]},
  "1.4"->{
    Cell[8414, 246, 78, 1, 40, "MathCaption",
      CellTags->{"S5.80.1", "1.4"}]},
  "1.5"->{
    Cell[8596, 253, 126, 3, 38, "MathCaption",
      CellTags->{"S5.80.1", "1.5"}]},
  "1.6"->{
    Cell[9033, 274, 241, 7, 70, "MathCaption",
      CellTags->{"S5.80.1", "1.6"}]},
  "1.7"->{
    Cell[9589, 299, 132, 3, 70, "MathCaption",
      CellTags->{"S5.80.1", "1.7"}]},
  "1.8"->{
    Cell[10023, 320, 132, 5, 70, "MathCaption",
      CellTags->{"S5.80.1", "1.8"}]},
  "1.9"->{
    Cell[10442, 341, 114, 2, 70, "MathCaption",
      CellTags->{"S5.80.1", "1.9"}]},
  "1.10"->{
    Cell[10885, 361, 268, 6, 70, "MathCaption",
      CellTags->{"S5.80.1", "1.10"}]},
  "1.11"->{
    Cell[14190, 471, 775, 19, 70, "MathCaption",
      CellTags->{"S5.80.1", "1.11"}]},
  "1.12"->{
    Cell[15498, 512, 109, 1, 70, "MathCaption",
      CellTags->{"S5.80.1", "1.12"}]},
  "1.13"->{
    Cell[16145, 535, 130, 3, 70, "MathCaption",
      CellTags->{"S5.80.1", "1.13"}]},
  "1.14"->{
    Cell[16619, 557, 394, 7, 70, "Text",
      CellTags->{"S5.80.1", "1.14"}]},
  "1.15"->{
    Cell[21683, 706, 974, 32, 70, "Text",
      CellTags->{"S5.80.1", "1.15"}]},
  "1.16"->{
    Cell[24768, 805, 181, 4, 70, "MathCaption",
      CellTags->{"S5.80.1", "1.16"}]},
  "1.17"->{
    Cell[25323, 829, 165, 4, 70, "MathCaption",
      CellTags->{"S5.80.1", "1.17"}]},
  "1.18"->{
    Cell[26048, 855, 84, 1, 70, "MathCaption",
      CellTags->{"S5.80.1", "1.18"}]},
  "1.19"->{
    Cell[26478, 875, 215, 5, 70, "Text",
      CellTags->{"S5.80.1", "1.19"}]},
  "1.20"->{
    Cell[26696, 882, 101, 1, 70, "MathCaption",
      CellTags->{"S5.80.1", "1.20"}]},
  "1.21"->{
    Cell[27339, 905, 138, 3, 70, "MathCaption",
      CellTags->{"S5.80.1", "1.21"}]},
  "1.22"->{
    Cell[27805, 926, 175, 4, 70, "MathCaption",
      CellTags->{"S5.80.1", "1.22"}]},
  "1.23"->{
    Cell[28321, 948, 124, 3, 70, "MathCaption",
      CellTags->{"S5.80.1", "1.23"}]},
  "1.24"->{
    Cell[29090, 981, 252, 5, 70, "MathCaption",
      CellTags->{"S5.80.1", "1.24"}]},
  "1.25"->{
    Cell[29998, 1016, 148, 4, 70, "MathCaption",
      CellTags->{"S5.80.1", "1.25"}]},
  "1.26"->{
    Cell[30790, 1049, 109, 1, 70, "MathCaption",
      CellTags->{"S5.80.1", "1.26"}]},
  "1.27"->{
    Cell[31554, 1080, 188, 4, 70, "MathCaption",
      CellTags->{"S5.80.1", "1.27"}]},
  "1.28"->{
    Cell[32101, 1103, 86, 1, 70, "MathCaption",
      CellTags->{"S5.80.1", "1.28"}]},
  "1.29"->{
    Cell[32511, 1122, 213, 4, 70, "MathCaption",
      CellTags->{"S5.80.1", "1.29"}]},
  "1.30"->{
    Cell[33022, 1144, 108, 1, 70, "MathCaption",
      CellTags->{"S5.80.1", "1.30"}]},
  "1.31"->{
    Cell[33463, 1163, 341, 10, 70, "MathCaption",
      CellTags->{"S5.80.1", "1.31"}]},
  "1.32"->{
    Cell[34342, 1195, 80, 1, 70, "MathCaption",
      CellTags->{"S5.80.1", "1.32"}]},
  "1.33"->{
    Cell[34756, 1214, 191, 4, 70, "MathCaption",
      CellTags->{"S5.80.1", "1.33"}]},
  "1.34"->{
    Cell[35281, 1236, 135, 3, 70, "MathCaption",
      CellTags->{"S5.80.1", "1.34"}]},
  "1.35"->{
    Cell[35750, 1257, 161, 4, 70, "MathCaption",
      CellTags->{"S5.80.1", "1.35"}]},
  "1.36"->{
    Cell[36198, 1275, 144, 4, 70, "MathCaption",
      CellTags->{"S5.80.1", "1.36"}]},
  "1.37"->{
    Cell[36600, 1293, 409, 12, 70, "MathCaption",
      CellTags->{"S5.80.1", "1.37"}]},
  "1.38"->{
    Cell[37281, 1319, 192, 5, 70, "MathCaption",
      CellTags->{"S5.80.1", "1.38"}]},
  "1.39"->{
    Cell[37713, 1338, 91, 1, 70, "MathCaption",
      CellTags->{"S5.80.1", "1.39"}]},
  "1.40"->{
    Cell[38407, 1365, 172, 4, 70, "MathCaption",
      CellTags->{"S5.80.1", "1.40"}]},
  "1.41"->{
    Cell[38731, 1379, 148, 4, 70, "MathCaption",
      CellTags->{"S5.80.1", "1.41"}]},
  "1.42"->{
    Cell[52215, 2257, 96, 1, 70, "MathCaption",
      CellTags->{"S5.80.1", "1.42"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.80.1", 60360, 2779},
  {"1.1", 69818, 3028},
  {"1.2", 69912, 3031},
  {"1.3", 70002, 3034},
  {"1.4", 70093, 3037},
  {"1.5", 70188, 3040},
  {"1.6", 70284, 3043},
  {"1.7", 70380, 3046},
  {"1.8", 70476, 3049},
  {"1.9", 70573, 3052},
  {"1.10", 70671, 3055},
  {"1.11", 70770, 3058},
  {"1.12", 70870, 3061},
  {"1.13", 70969, 3064},
  {"1.14", 71068, 3067},
  {"1.15", 71160, 3070},
  {"1.16", 71253, 3073},
  {"1.17", 71352, 3076},
  {"1.18", 71451, 3079},
  {"1.19", 71549, 3082},
  {"1.20", 71641, 3085},
  {"1.21", 71740, 3088},
  {"1.22", 71839, 3091},
  {"1.23", 71938, 3094},
  {"1.24", 72037, 3097},
  {"1.25", 72136, 3100},
  {"1.26", 72236, 3103},
  {"1.27", 72336, 3106},
  {"1.28", 72436, 3109},
  {"1.29", 72535, 3112},
  {"1.30", 72635, 3115},
  {"1.31", 72735, 3118},
  {"1.32", 72836, 3121},
  {"1.33", 72935, 3124},
  {"1.34", 73035, 3127},
  {"1.35", 73135, 3130},
  {"1.36", 73235, 3133},
  {"1.37", 73335, 3136},
  {"1.38", 73436, 3139},
  {"1.39", 73536, 3142},
  {"1.40", 73635, 3145},
  {"1.41", 73735, 3148},
  {"1.42", 73835, 3151}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 148, 6, 36, "Subsection",
  CellTags->{"S5.80.1", "1.1"}],
Cell[1927, 61, 772, 15, 120, "Text",
  CellTags->{"S5.80.1", "1.2"}],
Cell[2702, 78, 4661, 143, 162, "DefinitionBox",
  CellTags->"S5.80.1"],
Cell[7366, 223, 152, 5, 15, "Caption",
  CellTags->"S5.80.1"],
Cell[7521, 230, 890, 14, 136, "Text",
  CellTags->{"S5.80.1", "1.3"}],
Cell[8414, 246, 78, 1, 40, "MathCaption",
  CellTags->{"S5.80.1", "1.4"}],
Cell[8495, 249, 98, 2, 28, "Input",
  CellTags->"S5.80.1"],
Cell[8596, 253, 126, 3, 38, "MathCaption",
  CellTags->{"S5.80.1", "1.5"}],

Cell[CellGroupData[{
Cell[8747, 260, 84, 2, 28, "Input",
  CellTags->"S5.80.1"],
Cell[8834, 264, 184, 7, 25, "Output",
  CellTags->"S5.80.1"]
}, Open  ]],
Cell[9033, 274, 241, 7, 70, "MathCaption",
  CellTags->{"S5.80.1", "1.6"}],

Cell[CellGroupData[{
Cell[9299, 285, 85, 2, 70, "Input",
  CellTags->"S5.80.1"],
Cell[9387, 289, 187, 7, 70, "Output",
  CellTags->"S5.80.1"]
}, Open  ]],
Cell[9589, 299, 132, 3, 70, "MathCaption",
  CellTags->{"S5.80.1", "1.7"}],

Cell[CellGroupData[{
Cell[9746, 306, 72, 2, 70, "Input",
  CellTags->"S5.80.1"],
Cell[9821, 310, 187, 7, 70, "Output",
  CellTags->"S5.80.1"]
}, Open  ]],
Cell[10023, 320, 132, 5, 70, "MathCaption",
  CellTags->{"S5.80.1", "1.8"}],

Cell[CellGroupData[{
Cell[10180, 329, 75, 2, 70, "Input",
  CellTags->"S5.80.1"],
Cell[10258, 333, 169, 5, 70, "Output",
  CellTags->"S5.80.1"]
}, Open  ]],
Cell[10442, 341, 114, 2, 70, "MathCaption",
  CellTags->{"S5.80.1", "1.9"}],

Cell[CellGroupData[{
Cell[10581, 347, 91, 2, 70, "Input",
  CellTags->"S5.80.1"],
Cell[10675, 351, 195, 7, 70, "Output",
  CellTags->"S5.80.1"]
}, Open  ]],
Cell[10885, 361, 268, 6, 70, "MathCaption",
  CellTags->{"S5.80.1", "1.10"}],

Cell[CellGroupData[{
Cell[11178, 371, 89, 2, 70, "Input",
  CellTags->"S5.80.1"],
Cell[11270, 375, 76, 2, 70, "Output",
  CellTags->"S5.80.1"]
}, Open  ]],
Cell[11361, 380, 2738, 86, 70, "DefinitionBox",
  CellTags->"S5.80.1"],
Cell[14102, 468, 85, 1, 70, "Caption",
  CellTags->"S5.80.1"],
Cell[14190, 471, 775, 19, 70, "MathCaption",
  CellTags->{"S5.80.1", "1.11"}],

Cell[CellGroupData[{
Cell[14990, 494, 76, 2, 70, "Input",
  CellTags->"S5.80.1"],
Cell[15069, 498, 414, 11, 70, "Output",
  CellTags->"S5.80.1"]
}, Open  ]],
Cell[15498, 512, 109, 1, 70, "MathCaption",
  CellTags->{"S5.80.1", "1.12"}],

Cell[CellGroupData[{
Cell[15632, 517, 82, 2, 70, "Input",
  CellTags->"S5.80.1"],
Cell[15717, 521, 413, 11, 70, "Output",
  CellTags->"S5.80.1"]
}, Open  ]],
Cell[16145, 535, 130, 3, 70, "MathCaption",
  CellTags->{"S5.80.1", "1.13"}],

Cell[CellGroupData[{
Cell[16300, 542, 82, 2, 70, "Input",
  CellTags->"S5.80.1"],
Cell[16385, 546, 219, 8, 70, "Output",
  CellTags->"S5.80.1"]
}, Open  ]],
Cell[16619, 557, 394, 7, 70, "Text",
  CellTags->{"S5.80.1", "1.14"}],
Cell[17016, 566, 4553, 131, 70, "DefinitionBox3Col",
  CellTags->"S5.80.1"],
Cell[21572, 699, 108, 5, 70, "Caption",
  CellTags->"S5.80.1"],
Cell[21683, 706, 974, 32, 70, "Text",
  CellTags->{"S5.80.1", "1.15"}],
Cell[22660, 740, 2032, 60, 70, "DefinitionBox",
  CellTags->"S5.80.1"],
Cell[24695, 802, 70, 1, 70, "Caption",
  CellTags->"S5.80.1"],
Cell[24768, 805, 181, 4, 70, "MathCaption",
  CellTags->{"S5.80.1", "1.16"}],

Cell[CellGroupData[{
Cell[24974, 813, 84, 2, 70, "Input",
  CellTags->"S5.80.1"],
Cell[25061, 817, 247, 9, 70, "Output",
  CellTags->"S5.80.1"]
}, Open  ]],
Cell[25323, 829, 165, 4, 70, "MathCaption",
  CellTags->{"S5.80.1", "1.17"}],

Cell[CellGroupData[{
Cell[25513, 837, 103, 2, 70, "Input",
  CellTags->"S5.80.1"],
Cell[25619, 841, 414, 11, 70, "Output",
  CellTags->"S5.80.1"]
}, Open  ]],
Cell[26048, 855, 84, 1, 70, "MathCaption",
  CellTags->{"S5.80.1", "1.18"}],

Cell[CellGroupData[{
Cell[26157, 860, 84, 2, 70, "Input",
  CellTags->"S5.80.1"],
Cell[26244, 864, 219, 8, 70, "Output",
  CellTags->"S5.80.1"]
}, Open  ]],
Cell[26478, 875, 215, 5, 70, "Text",
  CellTags->{"S5.80.1", "1.19"}],
Cell[26696, 882, 101, 1, 70, "MathCaption",
  CellTags->{"S5.80.1", "1.20"}],

Cell[CellGroupData[{
Cell[26822, 887, 84, 2, 70, "Input",
  CellTags->"S5.80.1"],
Cell[26909, 891, 415, 11, 70, "Output",
  CellTags->"S5.80.1"]
}, Open  ]],
Cell[27339, 905, 138, 3, 70, "MathCaption",
  CellTags->{"S5.80.1", "1.21"}],

Cell[CellGroupData[{
Cell[27502, 912, 89, 2, 70, "Input",
  CellTags->"S5.80.1"],
Cell[27594, 916, 196, 7, 70, "Output",
  CellTags->"S5.80.1"]
}, Open  ]],
Cell[27805, 926, 175, 4, 70, "MathCaption",
  CellTags->{"S5.80.1", "1.22"}],

Cell[CellGroupData[{
Cell[28005, 934, 105, 2, 70, "Input",
  CellTags->"S5.80.1"],
Cell[28113, 938, 193, 7, 70, "Output",
  CellTags->"S5.80.1"]
}, Open  ]],
Cell[28321, 948, 124, 3, 70, "MathCaption",
  CellTags->{"S5.80.1", "1.23"}],

Cell[CellGroupData[{
Cell[28470, 955, 145, 7, 70, "Input",
  CellTags->"S5.80.1"],
Cell[28618, 964, 457, 14, 70, "Output",
  CellTags->"S5.80.1"]
}, Open  ]],
Cell[29090, 981, 252, 5, 70, "MathCaption",
  CellTags->{"S5.80.1", "1.24"}],

Cell[CellGroupData[{
Cell[29367, 990, 156, 7, 70, "Input",
  CellTags->"S5.80.1"],
Cell[29526, 999, 457, 14, 70, "Output",
  CellTags->"S5.80.1"]
}, Open  ]],
Cell[29998, 1016, 148, 4, 70, "MathCaption",
  CellTags->{"S5.80.1", "1.25"}],

Cell[CellGroupData[{
Cell[30171, 1024, 140, 6, 70, "Input",
  CellTags->"S5.80.1"],
Cell[30314, 1032, 461, 14, 70, "Output",
  CellTags->"S5.80.1"]
}, Open  ]],
Cell[30790, 1049, 109, 1, 70, "MathCaption",
  CellTags->{"S5.80.1", "1.26"}],

Cell[CellGroupData[{
Cell[30924, 1054, 153, 7, 70, "Input",
  CellTags->"S5.80.1"],
Cell[31080, 1063, 459, 14, 70, "Output",
  CellTags->"S5.80.1"]
}, Open  ]],
Cell[31554, 1080, 188, 4, 70, "MathCaption",
  CellTags->{"S5.80.1", "1.27"}],

Cell[CellGroupData[{
Cell[31767, 1088, 92, 2, 70, "Input",
  CellTags->"S5.80.1"],
Cell[31862, 1092, 224, 8, 70, "Output",
  CellTags->"S5.80.1"]
}, Open  ]],
Cell[32101, 1103, 86, 1, 70, "MathCaption",
  CellTags->{"S5.80.1", "1.28"}],

Cell[CellGroupData[{
Cell[32212, 1108, 93, 2, 70, "Input",
  CellTags->"S5.80.1"],
Cell[32308, 1112, 188, 7, 70, "Output",
  CellTags->"S5.80.1"]
}, Open  ]],
Cell[32511, 1122, 213, 4, 70, "MathCaption",
  CellTags->{"S5.80.1", "1.29"}],

Cell[CellGroupData[{
Cell[32749, 1130, 69, 2, 70, "Input",
  CellTags->"S5.80.1"],
Cell[32821, 1134, 186, 7, 70, "Output",
  CellTags->"S5.80.1"]
}, Open  ]],
Cell[33022, 1144, 108, 1, 70, "MathCaption",
  CellTags->{"S5.80.1", "1.30"}],

Cell[CellGroupData[{
Cell[33155, 1149, 102, 2, 70, "Input",
  CellTags->"S5.80.1"],
Cell[33260, 1153, 188, 7, 70, "Output",
  CellTags->"S5.80.1"]
}, Open  ]],
Cell[33463, 1163, 341, 10, 70, "MathCaption",
  CellTags->{"S5.80.1", "1.31"}],

Cell[CellGroupData[{
Cell[33829, 1177, 80, 2, 70, "Input",
  CellTags->"S5.80.1"],
Cell[33912, 1181, 415, 11, 70, "Output",
  CellTags->"S5.80.1"]
}, Open  ]],
Cell[34342, 1195, 80, 1, 70, "MathCaption",
  CellTags->{"S5.80.1", "1.32"}],

Cell[CellGroupData[{
Cell[34447, 1200, 106, 2, 70, "Input",
  CellTags->"S5.80.1"],
Cell[34556, 1204, 185, 7, 70, "Output",
  CellTags->"S5.80.1"]
}, Open  ]],
Cell[34756, 1214, 191, 4, 70, "MathCaption",
  CellTags->{"S5.80.1", "1.33"}],

Cell[CellGroupData[{
Cell[34972, 1222, 106, 2, 70, "Input",
  CellTags->"S5.80.1"],
Cell[35081, 1226, 185, 7, 70, "Output",
  CellTags->"S5.80.1"]
}, Open  ]],
Cell[35281, 1236, 135, 3, 70, "MathCaption",
  CellTags->{"S5.80.1", "1.34"}],

Cell[CellGroupData[{
Cell[35441, 1243, 106, 2, 70, "Input",
  CellTags->"S5.80.1"],
Cell[35550, 1247, 185, 7, 70, "Output",
  CellTags->"S5.80.1"]
}, Open  ]],
Cell[35750, 1257, 161, 4, 70, "MathCaption",
  CellTags->{"S5.80.1", "1.35"}],

Cell[CellGroupData[{
Cell[35936, 1265, 111, 2, 70, "Input",
  CellTags->"S5.80.1"],
Cell[36050, 1269, 133, 3, 70, "Output",
  CellTags->"S5.80.1"]
}, Open  ]],
Cell[36198, 1275, 144, 4, 70, "MathCaption",
  CellTags->{"S5.80.1", "1.36"}],

Cell[CellGroupData[{
Cell[36367, 1283, 83, 2, 70, "Input",
  CellTags->"S5.80.1"],
Cell[36453, 1287, 132, 3, 70, "Output",
  CellTags->"S5.80.1"]
}, Open  ]],
Cell[36600, 1293, 409, 12, 70, "MathCaption",
  CellTags->{"S5.80.1", "1.37"}],

Cell[CellGroupData[{
Cell[37034, 1309, 97, 2, 70, "Input",
  CellTags->"S5.80.1"],
Cell[37134, 1313, 132, 3, 70, "Output",
  CellTags->"S5.80.1"]
}, Open  ]],
Cell[37281, 1319, 192, 5, 70, "MathCaption",
  CellTags->{"S5.80.1", "1.38"}],

Cell[CellGroupData[{
Cell[37498, 1328, 90, 2, 70, "Input",
  CellTags->"S5.80.1"],
Cell[37591, 1332, 107, 3, 70, "Output",
  CellTags->"S5.80.1"]
}, Open  ]],
Cell[37713, 1338, 91, 1, 70, "MathCaption",
  CellTags->{"S5.80.1", "1.39"}],

Cell[CellGroupData[{
Cell[37829, 1343, 149, 6, 70, "Input",
  CellTags->"S5.80.1"],
Cell[37981, 1351, 411, 11, 70, "Output",
  CellTags->"S5.80.1"]
}, Open  ]],
Cell[38407, 1365, 172, 4, 70, "MathCaption",
  CellTags->{"S5.80.1", "1.40"}],
Cell[38582, 1371, 146, 6, 70, "Input",
  CellTags->"S5.80.1"],
Cell[38731, 1379, 148, 4, 70, "MathCaption",
  CellTags->{"S5.80.1", "1.41"}],

Cell[CellGroupData[{
Cell[38904, 1387, 173, 5, 70, "Input",
  CellTags->"S5.80.1"],
Cell[39080, 1394, 12936, 852, 70, 12865, 849, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.80.1"],
Cell[52019, 2248, 181, 6, 70, "Output",
  CellTags->"S5.80.1"]
}, Open  ]],
Cell[52215, 2257, 96, 1, 70, "MathCaption",
  CellTags->{"S5.80.1", "1.42"}],

Cell[CellGroupData[{
Cell[52336, 2262, 108, 2, 70, "Input",
  CellTags->"S5.80.1"],
Cell[52447, 2266, 7078, 485, 70, 7007, 482, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.80.1"],
Cell[59528, 2753, 181, 6, 70, "Output",
  CellTags->"S5.80.1"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

