(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     38162,       1259]*)
(*NotebookOutlinePosition[     45002,       1462]*)
(*  CellTagsIndexPosition[     44462,       1437]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Statistics",
 StyleBox["`", "MB"],
 "ConfidenceIntervals",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.96.1", "1.1"}],

Cell["\<\
A confidence interval gives a bound within which a parameter is expected to \
lie with a certain probability. Interval estimation of a parameter is often \
useful in observing the accuracy of an estimator as well as in making \
statistical inferences about the parameter in question. With this package, \
you can find confidence intervals for various parameters such as means, \
differences between two population means, variances, and ratios of the \
variance of two populations. The functions in this package calculate sample \
estimates and return bounds for intervals using the specified confidence \
level. The confidence intervals computed in this package assume that the \
univariate data are normally distributed. \
\>", "Text",
 CellTags->{"S5.96.1", "1.2"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["MeanCI[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the confidence interval for the population mean of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" based on the Student ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["t",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" distribution ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["MeanCI[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", KnownVariance -> ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["var", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the confidence interval for the population mean of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" based on the normal distribution ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.96.1"],

Cell["Confidence interval for the mean.", "Caption",
 CellTags->"S5.96.1"],

Cell[TextData[{
 "A confidence interval for the mean of a distribution is centered at ",
 Cell[BoxData[
  FormBox[
   OverscriptBox[
    StyleBox["x",
     "TI"], "_"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and has a half length proportional to the standard deviation ",
 Cell[BoxData[
  FormBox["\[Sigma]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " of the estimator. If the variance of the underlying distribution is known, \
and given by the option ",
 StyleBox["KnownVariance -> ", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 StyleBox["var", "TI",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 ", then the interval is calculated using the appropriate quantile ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["z",
     "TI"], 
    StyleBox["c",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " of the standard normal distribution. The resulting interval is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     OverscriptBox[
      StyleBox["x",
       "TI"], "_"], "-", 
     SubscriptBox[
      StyleBox["z",
       "TI"], 
      StyleBox["c",
       "TI"]], "\[Sigma]", ",", 
     OverscriptBox[
      StyleBox["x",
       "TI"], "_"], "+", 
     SubscriptBox[
      StyleBox["z",
       "TI"], 
      StyleBox["c",
       "TI"]], "\[Sigma]"}], ")"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", where ",
 Cell[BoxData[
  FormBox[
   StyleBox["c",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is ",
 StyleBox["(1", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 " ",
 StyleBox["+", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 " ",
 StyleBox["ConfidenceLevel)/2", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 " and ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Sigma]", "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " ",
 Cell[BoxData[
  FormBox["=", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " ",
 StyleBox["var", "TI",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 ". "
}], "Text",
 CellTags->{"S5.96.1", "1.3"}],

Cell[TextData[{
 "If the variance is unknown, the standard deviation must be estimated, and \
the confidence interval takes the form ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     OverscriptBox[
      StyleBox["x",
       "TI"], "_"], "-", 
     SubscriptBox[
      StyleBox["t",
       "TI"], 
      StyleBox["c",
       "TI"]], 
     StyleBox["s",
      "TI"], ",", 
     OverscriptBox[
      StyleBox["x",
       "TI"], "_"], "+", 
     SubscriptBox[
      StyleBox["t",
       "TI"], 
      StyleBox["c",
       "TI"]], 
     StyleBox["s",
      "TI"]}], ")"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", where ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["t",
     "TI"], 
    StyleBox["c",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is the ",
 Cell[BoxData[
  FormBox[
   StyleBox["c",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " quantile of the Student ",
 Cell[BoxData[
  FormBox[
   StyleBox["t",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " distribution and ",
 Cell[BoxData[
  FormBox[
   StyleBox["s",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is the standard error of the mean. The confidence level used in computing \
the interval is specified by the option ",
 StyleBox["ConfidenceLevel", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 ", which has a default value of ",
 Cell[BoxData[
  FormBox[".95", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "Text",
 CellTags->{"S5.96.1", "1.4"}],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.96.1", "1.5"}],

Cell["<<Statistics`ConfidenceIntervals`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.96.1"],

Cell["\<\
Here is a list of sample values. The data are assumed to be a random sample \
from the normally distributed population with unknown variance. \
\>", "MathCaption",
 CellTags->{"S5.96.1", "1.6"}],

Cell["\<\
data1 = {2.1, 1.2, 0.7, 1.0, 1.1, 3.2, 3.2,
3.3, 2.1, 0.3};\
\>", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.96.1"],

Cell[TextData[{
 "The confidence bounds that are computed are based on the Student ",
 Cell[BoxData[
  FormBox[
   StyleBox["t",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " distribution with confidence level ",
 Cell[BoxData[
  FormBox[".95", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.96.1", "1.7"}],

Cell[CellGroupData[{

Cell["MeanCI[data1]", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.96.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.0185732000582792`", ",", "2.6214267999417213`"}], 
  "}"}]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.96.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["option name", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->True,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->True,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["default value", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->True,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->True,
      RowSpacings->0.4}], Cell[TextData[StyleBox["",
      GridBoxOptions->{RowLines->True,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->True,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ConfidenceLevel", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->True,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->True,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[".95", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->True,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->True,
      RowSpacings->0.4}], Cell[TextData[StyleBox["confidence level ",
      GridBoxOptions->{RowLines->True,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->True,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
 GridBoxOptions->{RowLines->True,
 RowSpacings->0.4},
 CellTags->"S5.96.1"],

Cell["Option for all confidence interval functions.", "Caption",
 CellTags->"S5.96.1"],

Cell[TextData[{
 "You can calculate confidence intervals for the difference in means of two \
populations using ",
 StyleBox["MeanDifferenceCI", "MR"],
 ". "
}], "Text",
 CellTags->{"S5.96.1", "1.8"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["MeanDifferenceCI[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["data",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["data",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "give the confidence interval for the difference between the population \
mean of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["data",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and the population mean of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["data",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" based on the Student ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["t",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" distribution",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["MeanDifferenceCI[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["data",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["data",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", KnownVariance -> {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["var",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["var",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "give the confidence interval for the difference between the population \
mean of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["data",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and the population mean of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["data",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" based on the normal distribution ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.96.1"],

Cell["Confidence intervals for difference in means. ", "Caption",
 CellTags->"S5.96.1"],

Cell[TextData[{
 "If variances are unknown, you can specify that the population variances are \
equal with ",
 StyleBox["EqualVariances", "MR"],
 " ",
 StyleBox["->", "MR"],
 " ",
 StyleBox["True", "MR"],
 ". In this case the Student ",
 Cell[BoxData[
  FormBox[
   StyleBox["t",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " distribution is used with ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     StyleBox["n",
      "TI"], "1"], "+", 
    SubscriptBox[
     StyleBox["n",
      "TI"], "2"], "-", "2"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " degrees of freedom, where ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["n",
     "TI"], "1"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["n",
     "TI"], "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " are the sample sizes from the first and the second populations, \
respectively. If the unknown variances are not specified as equal, a more \
conservative interval is computed using Welch\[CloseCurlyQuote]s approximate \
",
 Cell[BoxData[
  FormBox[
   StyleBox["t",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "\[Hyphen]statistic. "
}], "Text",
 CellTags->{"S5.96.1", "1.9"}],

Cell["\<\
Here is a second list of sample values from a population whose variance is \
unknown. \
\>", "MathCaption",
 CellTags->{"S5.96.1", "1.10"}],

Cell["\<\
data2 = {1.8, 0.2, 1.5, 1.9, 1.1, 3.0, 2.3,
 0.9, 2.4, 1.0};\
\>", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.96.1"],

Cell["\<\
This is the interval for the difference in the two means, assuming equal \
variances. \
\>", "MathCaption",
 CellTags->{"S5.96.1", "1.11"}],

Cell[CellGroupData[{

Cell["\<\
MeanDifferenceCI[data1, data2,
        EqualVariances -> True]\
\>", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.96.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.7186666910511741`"}], ",", "1.1386666910511745`"}], 
  "}"}]], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S5.96.1"]
}, Open  ]],

Cell["\<\
If equal variances cannot be assumed, the computed interval is larger, or \
more conservative. \
\>", "MathCaption",
 CellTags->{"S5.96.1", "1.12"}],

Cell[CellGroupData[{

Cell["MeanDifferenceCI[data1, data2]", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.96.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.7240928772324295`"}], ",", "1.14409287723243`"}], 
  "}"}]], "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S5.96.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["option name", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["default value", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox["",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["EqualVariances", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["False", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "whether the unknown population variances are assumed equal",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["KnownVariance", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["None", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "value of the known population variance ",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["KnownStandardDeviation", "MR",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["None", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "value of the known population standard deviation ",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
 GridBoxOptions->{RowLines->{True, False},
 RowSpacings->0.4},
 CellTags->"S5.96.1"],

Cell["Options for the confidence interval for difference in means.", "Caption",
 CellTags->"S5.96.1"],

Cell[TextData[{
 "You can also compute intervals for population variance and ratio of \
population variances. The bounds for these intervals are determined by the \
sample standard deviations and the appropriate quantiles from the \
chi\[Hyphen]square or the ",
 Cell[BoxData[
  FormBox[
   StyleBox["F",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "\[Hyphen]ratio distributions. Note that the ",
 StyleBox["ConfidenceLevel", "MR"],
 " option is available for all confidence interval functions provided in this \
package. "
}], "Text",
 CellTags->{"S5.96.1", "1.13"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["VarianceCI[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "give the confidence interval for the population variance of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" based on the chi\[Hyphen]square distribution ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["VarianceRatioCI[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["data",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["data",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "give the confidence interval for the ratio of the population variance \
of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["data",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" to the population variance of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["data",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" based on the ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["F",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["\[Hyphen]ratio distribution ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.96.1"],

Cell["Confidence intervals for variances.", "Caption",
 CellTags->"S5.96.1"],

Cell["\<\
Here is the interval for the population variance of the first sample. \
\>", "MathCaption",
 CellTags->{"S5.96.1", "1.14"}],

Cell[CellGroupData[{

Cell["VarianceCI[data1]", "Input",
 CellLabel->"In[7]:= ",
 CellTags->"S5.96.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.5938147444982542`", ",", "4.18310025279026`"}], "}"}]], "Output",\

 CellLabel->"Out[7]= ",
 CellTags->"S5.96.1"]
}, Open  ]],

Cell[TextData[{
 "This gives the ",
 Cell[BoxData[
  FormBox["90", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " percent confidence interval for the ratio of two variances whose \
populations are represented by the two samples. "
}], "MathCaption",
 CellTags->{"S5.96.1", "1.15"}],

Cell[CellGroupData[{

Cell["\<\
VarianceRatioCI[data1, data2,
          ConfidenceLevel -> .9]\
\>", "Input",
 CellLabel->"In[8]:= ",
 CellTags->"S5.96.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.5650243504349138`", ",", "5.709775243752686`"}], "}"}]], "Output",\

 CellLabel->"Out[8]= ",
 CellTags->"S5.96.1"]
}, Open  ]],

Cell[TextData[{
 "The package also provides functions for calculating confidence intervals \
from derived statistics rather than sample data. This may be useful when \
parameter estimates are available, in which case you do not have to input any \
data. You can use functions from the ",
 StyleBox["Statistics`DescriptiveStatistics`", "MR"],
 " package to get the necessary derived statistics of your sample data. This \
package is automatically loaded when you load ",
 StyleBox["Statistics`ConfidenceIntervals`", "MR"],
 ".  "
}], "Text",
 CellTags->{"S5.96.1", "1.16"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["NormalCI[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["mean", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["sd", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the confidence interval centered at ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["mean", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" with standard deviation ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["sd", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["StudentTCI[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["mean", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["se", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dof", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the confidence interval centered at ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["mean", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" with specified standard error ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["se", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dof", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" degrees of freedom ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ChiSquareCI[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["variance", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dof", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "give the confidence interval for the population variance, given sample \
variance ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["variance", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dof", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" degrees of freedom ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["FRatioCI[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ratio", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["numdof", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dendof", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "give the confidence interval for the ratio of population variances, \
given the ratio of sample variances ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ratio", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[
      " and where the sample variances in the numerator and denominator have \
",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["numdof", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dendof", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" degrees of freedom, respectively ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.96.1"],

Cell["Confidence intervals given sample estimates. ", "Caption",
 CellTags->"S5.96.1"],

Cell["\<\
This calculates the mean of the sample data that were given at the beginning \
of this section. \
\>", "MathCaption",
 CellTags->{"S5.96.1", "1.17"}],

Cell[CellGroupData[{

Cell["mean = Mean[data1]", "Input",
 CellLabel->"In[9]:= ",
 CellTags->"S5.96.1"],

Cell[BoxData["1.8200000000000003`"], "Output",
 CellLabel->"Out[9]= ",
 CellTags->"S5.96.1"]
}, Open  ]],

Cell[TextData[{
 "This estimates the standard error of the mean using a function from the \
package ",
 StyleBox["Statistics`DescriptiveStatistics`", "MR"],
 "  which is automatically loaded with this one. "
}], "MathCaption",
 CellTags->{"S5.96.1", "1.18"}],

Cell[CellGroupData[{

Cell["se = StandardErrorOfSampleMean[data1]", "Input",
 CellLabel->"In[10]:= ",
 CellTags->"S5.96.1"],

Cell[BoxData["0.35427547348230465`"], "Output",
 CellLabel->"Out[10]= ",
 CellTags->"S5.96.1"]
}, Open  ]],

Cell[TextData[{
 "The same interval is computed using the estimated standard error as was \
found by using ",
 StyleBox["MeanCI", "MR"],
 " above. "
}], "MathCaption",
 CellTags->{"S5.96.1", "1.19"}],

Cell[CellGroupData[{

Cell["\<\
StudentTCI[mean, se, Length[data1] - 1,
ConfidenceLevel -> 0.9]\
\>", "Input",
 CellLabel->"In[11]:= ",
 CellTags->"S5.96.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.1705730478366765`", ",", "2.469426952163324`"}], "}"}]], "Output",\

 CellLabel->"Out[11]= ",
 CellTags->"S5.96.1"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.96.1"->{
    Cell[1776, 53, 146, 6, 36, "Subsection",
      CellTags->{"S5.96.1", "1.1"}],
    Cell[1925, 61, 777, 12, 120, "Text",
      CellTags->{"S5.96.1", "1.2"}],
    Cell[2705, 75, 2575, 78, 102, "DefinitionBox",
      CellTags->"S5.96.1"],
    Cell[5283, 155, 74, 1, 15, "Caption",
      CellTags->"S5.96.1"],
    Cell[5360, 158, 2365, 84, 88, "Text",
      CellTags->{"S5.96.1", "1.3"}],
    Cell[7728, 244, 1896, 70, 72, "Text",
      CellTags->{"S5.96.1", "1.4"}],
    Cell[9627, 316, 78, 1, 40, "MathCaption",
      CellTags->{"S5.96.1", "1.5"}],
    Cell[9708, 319, 96, 2, 28, "Input",
      CellTags->"S5.96.1"],
    Cell[9807, 323, 204, 4, 56, "MathCaption",
      CellTags->{"S5.96.1", "1.6"}],
    Cell[10014, 329, 130, 5, 45, "Input",
      CellTags->"S5.96.1"],
    Cell[10147, 336, 432, 13, 56, "MathCaption",
      CellTags->{"S5.96.1", "1.7"}],
    Cell[10604, 353, 76, 2, 70, "Input",
      CellTags->"S5.96.1"],
    Cell[10683, 357, 158, 5, 70, "Output",
      CellTags->"S5.96.1"],
    Cell[10856, 365, 1647, 52, 70, "DefinitionBox3Col",
      CellTags->"S5.96.1"],
    Cell[12506, 419, 86, 1, 70, "Caption",
      CellTags->"S5.96.1"],
    Cell[12595, 422, 200, 6, 70, "Text",
      CellTags->{"S5.96.1", "1.8"}],
    Cell[12798, 430, 5399, 162, 70, "DefinitionBox",
      CellTags->"S5.96.1"],
    Cell[18200, 594, 87, 1, 70, "Caption",
      CellTags->"S5.96.1"],
    Cell[18290, 597, 1448, 50, 70, "Text",
      CellTags->{"S5.96.1", "1.9"}],
    Cell[19741, 649, 149, 4, 70, "MathCaption",
      CellTags->{"S5.96.1", "1.10"}],
    Cell[19893, 655, 131, 5, 70, "Input",
      CellTags->"S5.96.1"],
    Cell[20027, 662, 149, 4, 70, "MathCaption",
      CellTags->{"S5.96.1", "1.11"}],
    Cell[20201, 670, 133, 5, 70, "Input",
      CellTags->"S5.96.1"],
    Cell[20337, 677, 177, 6, 70, "Output",
      CellTags->"S5.96.1"],
    Cell[20529, 686, 158, 4, 70, "MathCaption",
      CellTags->{"S5.96.1", "1.12"}],
    Cell[20712, 694, 93, 2, 70, "Input",
      CellTags->"S5.96.1"],
    Cell[20808, 698, 175, 6, 70, "Output",
      CellTags->"S5.96.1"],
    Cell[20998, 707, 3354, 96, 70, "DefinitionBox3Col",
      CellTags->"S5.96.1"],
    Cell[24355, 805, 101, 1, 70, "Caption",
      CellTags->"S5.96.1"],
    Cell[24459, 808, 617, 15, 70, "Text",
      CellTags->{"S5.96.1", "1.13"}],
    Cell[25079, 825, 3538, 107, 70, "DefinitionBox",
      CellTags->"S5.96.1"],
    Cell[28620, 934, 76, 1, 70, "Caption",
      CellTags->"S5.96.1"],
    Cell[28699, 937, 133, 3, 70, "MathCaption",
      CellTags->{"S5.96.1", "1.14"}],
    Cell[28857, 944, 80, 2, 70, "Input",
      CellTags->"S5.96.1"],
    Cell[28940, 948, 155, 5, 70, "Output",
      CellTags->"S5.96.1"],
    Cell[29110, 956, 319, 8, 70, "MathCaption",
      CellTags->{"S5.96.1", "1.15"}],
    Cell[29454, 968, 133, 5, 70, "Input",
      CellTags->"S5.96.1"],
    Cell[29590, 975, 156, 5, 70, "Output",
      CellTags->"S5.96.1"],
    Cell[29761, 983, 572, 11, 70, "Text",
      CellTags->{"S5.96.1", "1.16"}],
    Cell[30336, 996, 6316, 196, 70, "DefinitionBox",
      CellTags->"S5.96.1"],
    Cell[36655, 1194, 86, 1, 70, "Caption",
      CellTags->"S5.96.1"],
    Cell[36744, 1197, 159, 4, 70, "MathCaption",
      CellTags->{"S5.96.1", "1.17"}],
    Cell[36928, 1205, 81, 2, 70, "Input",
      CellTags->"S5.96.1"],
    Cell[37012, 1209, 92, 2, 70, "Output",
      CellTags->"S5.96.1"],
    Cell[37119, 1214, 258, 6, 70, "MathCaption",
      CellTags->{"S5.96.1", "1.18"}],
    Cell[37402, 1224, 101, 2, 70, "Input",
      CellTags->"S5.96.1"],
    Cell[37506, 1228, 94, 2, 70, "Output",
      CellTags->"S5.96.1"],
    Cell[37615, 1233, 199, 6, 70, "MathCaption",
      CellTags->{"S5.96.1", "1.19"}],
    Cell[37839, 1243, 135, 5, 70, "Input",
      CellTags->"S5.96.1"],
    Cell[37977, 1250, 157, 5, 70, "Output",
      CellTags->"S5.96.1"]},
  "1.1"->{
    Cell[1776, 53, 146, 6, 36, "Subsection",
      CellTags->{"S5.96.1", "1.1"}]},
  "1.2"->{
    Cell[1925, 61, 777, 12, 120, "Text",
      CellTags->{"S5.96.1", "1.2"}]},
  "1.3"->{
    Cell[5360, 158, 2365, 84, 88, "Text",
      CellTags->{"S5.96.1", "1.3"}]},
  "1.4"->{
    Cell[7728, 244, 1896, 70, 72, "Text",
      CellTags->{"S5.96.1", "1.4"}]},
  "1.5"->{
    Cell[9627, 316, 78, 1, 40, "MathCaption",
      CellTags->{"S5.96.1", "1.5"}]},
  "1.6"->{
    Cell[9807, 323, 204, 4, 56, "MathCaption",
      CellTags->{"S5.96.1", "1.6"}]},
  "1.7"->{
    Cell[10147, 336, 432, 13, 56, "MathCaption",
      CellTags->{"S5.96.1", "1.7"}]},
  "1.8"->{
    Cell[12595, 422, 200, 6, 70, "Text",
      CellTags->{"S5.96.1", "1.8"}]},
  "1.9"->{
    Cell[18290, 597, 1448, 50, 70, "Text",
      CellTags->{"S5.96.1", "1.9"}]},
  "1.10"->{
    Cell[19741, 649, 149, 4, 70, "MathCaption",
      CellTags->{"S5.96.1", "1.10"}]},
  "1.11"->{
    Cell[20027, 662, 149, 4, 70, "MathCaption",
      CellTags->{"S5.96.1", "1.11"}]},
  "1.12"->{
    Cell[20529, 686, 158, 4, 70, "MathCaption",
      CellTags->{"S5.96.1", "1.12"}]},
  "1.13"->{
    Cell[24459, 808, 617, 15, 70, "Text",
      CellTags->{"S5.96.1", "1.13"}]},
  "1.14"->{
    Cell[28699, 937, 133, 3, 70, "MathCaption",
      CellTags->{"S5.96.1", "1.14"}]},
  "1.15"->{
    Cell[29110, 956, 319, 8, 70, "MathCaption",
      CellTags->{"S5.96.1", "1.15"}]},
  "1.16"->{
    Cell[29761, 983, 572, 11, 70, "Text",
      CellTags->{"S5.96.1", "1.16"}]},
  "1.17"->{
    Cell[36744, 1197, 159, 4, 70, "MathCaption",
      CellTags->{"S5.96.1", "1.17"}]},
  "1.18"->{
    Cell[37119, 1214, 258, 6, 70, "MathCaption",
      CellTags->{"S5.96.1", "1.18"}]},
  "1.19"->{
    Cell[37615, 1233, 199, 6, 70, "MathCaption",
      CellTags->{"S5.96.1", "1.19"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.96.1", 38785, 1275},
  {"1.1", 42630, 1376},
  {"1.2", 42724, 1379},
  {"1.3", 42814, 1382},
  {"1.4", 42905, 1385},
  {"1.5", 42996, 1388},
  {"1.6", 43091, 1391},
  {"1.7", 43187, 1394},
  {"1.8", 43285, 1397},
  {"1.9", 43375, 1400},
  {"1.10", 43468, 1403},
  {"1.11", 43567, 1406},
  {"1.12", 43666, 1409},
  {"1.13", 43765, 1412},
  {"1.14", 43858, 1415},
  {"1.15", 43957, 1418},
  {"1.16", 44056, 1421},
  {"1.17", 44149, 1424},
  {"1.18", 44249, 1427},
  {"1.19", 44349, 1430}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 146, 6, 36, "Subsection",
  CellTags->{"S5.96.1", "1.1"}],
Cell[1925, 61, 777, 12, 120, "Text",
  CellTags->{"S5.96.1", "1.2"}],
Cell[2705, 75, 2575, 78, 102, "DefinitionBox",
  CellTags->"S5.96.1"],
Cell[5283, 155, 74, 1, 15, "Caption",
  CellTags->"S5.96.1"],
Cell[5360, 158, 2365, 84, 88, "Text",
  CellTags->{"S5.96.1", "1.3"}],
Cell[7728, 244, 1896, 70, 72, "Text",
  CellTags->{"S5.96.1", "1.4"}],
Cell[9627, 316, 78, 1, 40, "MathCaption",
  CellTags->{"S5.96.1", "1.5"}],
Cell[9708, 319, 96, 2, 28, "Input",
  CellTags->"S5.96.1"],
Cell[9807, 323, 204, 4, 56, "MathCaption",
  CellTags->{"S5.96.1", "1.6"}],
Cell[10014, 329, 130, 5, 45, "Input",
  CellTags->"S5.96.1"],
Cell[10147, 336, 432, 13, 56, "MathCaption",
  CellTags->{"S5.96.1", "1.7"}],

Cell[CellGroupData[{
Cell[10604, 353, 76, 2, 70, "Input",
  CellTags->"S5.96.1"],
Cell[10683, 357, 158, 5, 70, "Output",
  CellTags->"S5.96.1"]
}, Open  ]],
Cell[10856, 365, 1647, 52, 70, "DefinitionBox3Col",
  CellTags->"S5.96.1"],
Cell[12506, 419, 86, 1, 70, "Caption",
  CellTags->"S5.96.1"],
Cell[12595, 422, 200, 6, 70, "Text",
  CellTags->{"S5.96.1", "1.8"}],
Cell[12798, 430, 5399, 162, 70, "DefinitionBox",
  CellTags->"S5.96.1"],
Cell[18200, 594, 87, 1, 70, "Caption",
  CellTags->"S5.96.1"],
Cell[18290, 597, 1448, 50, 70, "Text",
  CellTags->{"S5.96.1", "1.9"}],
Cell[19741, 649, 149, 4, 70, "MathCaption",
  CellTags->{"S5.96.1", "1.10"}],
Cell[19893, 655, 131, 5, 70, "Input",
  CellTags->"S5.96.1"],
Cell[20027, 662, 149, 4, 70, "MathCaption",
  CellTags->{"S5.96.1", "1.11"}],

Cell[CellGroupData[{
Cell[20201, 670, 133, 5, 70, "Input",
  CellTags->"S5.96.1"],
Cell[20337, 677, 177, 6, 70, "Output",
  CellTags->"S5.96.1"]
}, Open  ]],
Cell[20529, 686, 158, 4, 70, "MathCaption",
  CellTags->{"S5.96.1", "1.12"}],

Cell[CellGroupData[{
Cell[20712, 694, 93, 2, 70, "Input",
  CellTags->"S5.96.1"],
Cell[20808, 698, 175, 6, 70, "Output",
  CellTags->"S5.96.1"]
}, Open  ]],
Cell[20998, 707, 3354, 96, 70, "DefinitionBox3Col",
  CellTags->"S5.96.1"],
Cell[24355, 805, 101, 1, 70, "Caption",
  CellTags->"S5.96.1"],
Cell[24459, 808, 617, 15, 70, "Text",
  CellTags->{"S5.96.1", "1.13"}],
Cell[25079, 825, 3538, 107, 70, "DefinitionBox",
  CellTags->"S5.96.1"],
Cell[28620, 934, 76, 1, 70, "Caption",
  CellTags->"S5.96.1"],
Cell[28699, 937, 133, 3, 70, "MathCaption",
  CellTags->{"S5.96.1", "1.14"}],

Cell[CellGroupData[{
Cell[28857, 944, 80, 2, 70, "Input",
  CellTags->"S5.96.1"],
Cell[28940, 948, 155, 5, 70, "Output",
  CellTags->"S5.96.1"]
}, Open  ]],
Cell[29110, 956, 319, 8, 70, "MathCaption",
  CellTags->{"S5.96.1", "1.15"}],

Cell[CellGroupData[{
Cell[29454, 968, 133, 5, 70, "Input",
  CellTags->"S5.96.1"],
Cell[29590, 975, 156, 5, 70, "Output",
  CellTags->"S5.96.1"]
}, Open  ]],
Cell[29761, 983, 572, 11, 70, "Text",
  CellTags->{"S5.96.1", "1.16"}],
Cell[30336, 996, 6316, 196, 70, "DefinitionBox",
  CellTags->"S5.96.1"],
Cell[36655, 1194, 86, 1, 70, "Caption",
  CellTags->"S5.96.1"],
Cell[36744, 1197, 159, 4, 70, "MathCaption",
  CellTags->{"S5.96.1", "1.17"}],

Cell[CellGroupData[{
Cell[36928, 1205, 81, 2, 70, "Input",
  CellTags->"S5.96.1"],
Cell[37012, 1209, 92, 2, 70, "Output",
  CellTags->"S5.96.1"]
}, Open  ]],
Cell[37119, 1214, 258, 6, 70, "MathCaption",
  CellTags->{"S5.96.1", "1.18"}],

Cell[CellGroupData[{
Cell[37402, 1224, 101, 2, 70, "Input",
  CellTags->"S5.96.1"],
Cell[37506, 1228, 94, 2, 70, "Output",
  CellTags->"S5.96.1"]
}, Open  ]],
Cell[37615, 1233, 199, 6, 70, "MathCaption",
  CellTags->{"S5.96.1", "1.19"}],

Cell[CellGroupData[{
Cell[37839, 1243, 135, 5, 70, "Input",
  CellTags->"S5.96.1"],
Cell[37977, 1250, 157, 5, 70, "Output",
  CellTags->"S5.96.1"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

