(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     47053,       1591]*)
(*NotebookOutlinePosition[     56102,       1858]*)
(*  CellTagsIndexPosition[     55312,       1823]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "NumberTheory",
 StyleBox["`", "MB"],
 "ContinuedFractions",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.67.1", "1.1"}],

Cell["\<\
The decimal expansion is the most common way to represent a real number. This \
package supports two alternative representations as follows: (1)\
\[NonBreakingSpace]the continued fraction expansion of a real number and (2)\
\[NonBreakingSpace]the arbitrary base expansion of a rational number in terms \
of preperiodic and periodic parts. \
\>", "Text",
 CellTags->{"S5.67.1", "1.2"}],

Cell[TextData[{
 "The ",
 StyleBox["continued fraction expansion", "TI"],
 " of a real number ",
 Cell[BoxData[
  FormBox[
   StyleBox["x",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is a representation of the form "
}], "Text",
 CellTags->{"S5.67.1", "1.3"}],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox[
    StyleBox["a",
     "TI"], "0"], "+", 
   FractionBox["1", 
    RowBox[{
     SubscriptBox[
      StyleBox["a",
       "TI"], "1"], "+", 
     FractionBox["1", 
      RowBox[{
       SubscriptBox[
        StyleBox["a",
         "TI"], "2"], "+", "\[CenterEllipsis]"}]]}]]}], 
  TraditionalForm]], "DisplayFormula",
 UnderoverscriptBoxOptions->{LimitsPositioning->True},
 GridBoxOptions->{ColumnWidths->Automatic},
 CellTags->{"S5.67.1", "1.4"}],

Cell[TextData[{
 "The integers ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["a",
     "TI"], 
    StyleBox["i",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " are called the ",
 StyleBox["partial quotients", "TI"],
 ". Rational numbers have a finite number of partial quotients, while \
irrational numbers have an infinite continued fraction expansion. Continued \
fractions also find application in the factorization of integers (see, for \
example, Chapter 10 in [Rosen]). "
}], "Text",
 CellTags->{"S5.67.1", "1.5"}],

Cell[TextData[{
 "If the number ",
 Cell[BoxData[
  FormBox[
   StyleBox["x",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " has partial quotients ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     StyleBox["a",
      "TI"], "0"], ",", 
    SubscriptBox[
     StyleBox["a",
      "TI"], "1"], ",", "\[Ellipsis]"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", the rational number ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     StyleBox["p",
      "TI"], 
     StyleBox["n",
      "TI"]], "/", 
    SubscriptBox[
     StyleBox["q",
      "TI"], 
     StyleBox["n",
      "TI"]]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " formed by considering the first ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " partial quotients ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     StyleBox["a",
      "TI"], "0"], ",", 
    SubscriptBox[
     StyleBox["a",
      "TI"], "1"], ",", "\[Ellipsis]", ",", 
    SubscriptBox[
     StyleBox["a",
      "TI"], 
     StyleBox["n",
      "TI"]]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", is called the ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " ",
 StyleBox["convergent", "TI"],
 " of ",
 Cell[BoxData[
  FormBox[
   StyleBox["x",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". The convergents of a number provide, in a certain sense, the best \
rational approximation with a small denominator to the given real number. "
}], "Text",
 CellTags->{"S5.67.1", "1.6"}],

Cell[TextData[{
 "In ",
 StyleBox["Mathematica", "TI"],
 " versions 4.0 and later, the kernel functions ",
 StyleBox["ContinuedFraction", "MR"],
 " and ",
 StyleBox["RealDigits", "MR"],
 " can be used to produce continued fraction and periodic representations of \
rational numbers. ",
 StyleBox["FromContinuedFraction", "MR"],
 " and ",
 StyleBox["FromDigits", "MR"],
 " are used to invert these operations. This package enhances these \
capabilities by providing functions for computing convergents and for nicely \
typesetting continued fractions and periodic forms. "
}], "Text",
 CellTags->{"S5.67.1", "1.7"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["ContinuedFractionForm[{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["a",
          "TI"], "0"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["a",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] }]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "a representation of a continued fraction with partial quotients ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["a",
          "TI"], "0"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["a",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ContinuedFractionForm[{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["a",
          "TI"], "0"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["a",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] , {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["p",
          "TI"], "0"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["p",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] }}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "a representation of a continued fraction with partial quotients ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["a",
          "TI"], "0"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["a",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and additional quotients ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["p",
          "TI"], "0"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["p",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" that repeat periodically",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Normal[ContinuedFractionForm[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["quotients", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "give the rational number corresponding to the given continued fraction",
      
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.67.1"],

Cell["Continued fractions. ", "Caption",
 CellTags->"S5.67.1"],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.67.1", "1.8"}],

Cell["<<NumberTheory`ContinuedFractions`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.67.1"],

Cell[TextData[{
 "The kernel function ",
 StyleBox["ContinuedFraction", "MR"],
 " generates a list of the partial quotients of the continued fraction. Here \
are the first 10 terms of the expansion of ",
 StyleBox["pi", "TI"],
 ". "
}], "MathCaption",
 CellTags->{"S5.67.1", "1.9"}],

Cell[CellGroupData[{

Cell["cf = ContinuedFraction[Pi, 10]", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.67.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "3", ",", "7", ",", "15", ",", "1", ",", "292", ",", "1", ",", "1", ",", 
   "1", ",", "2", ",", "1"}], "}"}]], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.67.1"]
}, Open  ]],

Cell[TextData[{
 StyleBox["ContinuedFractionForm", "MR"],
 " can be wrapped around the result of ",
 StyleBox["ContinuedFraction", "MR"],
 " for a much clearer representation as a sum of nested fractions. "
}], "MathCaption",
 CellTags->{"S5.67.1", "1.10"}],

Cell[CellGroupData[{

Cell["ContinuedFractionForm[cf]", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.67.1"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{"3", "+", 
    FractionBox["1", 
     RowBox[{"7", "+", 
      FractionBox["1", 
       RowBox[{"15", "+", 
        FractionBox["1", 
         RowBox[{"1", "+", 
          FractionBox["1", 
           RowBox[{"292", "+", 
            FractionBox["1", 
             RowBox[{"1", "+", 
              FractionBox["1", 
               RowBox[{"1", "+", 
                FractionBox["1", 
                 RowBox[{"1", "+", 
                  FractionBox["1", 
                   RowBox[{"2", "+", 
                    FractionBox["1", "1"]}]]}]]}]]}]]}]]}]]}]]}]]}],
   ScriptSizeMultipliers->1],
  ContinuedFractionForm[{3, 7, 15, 1, 292, 1, 1, 1, 2, 1}]]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.67.1"]
}, Open  ]],

Cell[TextData[{
 "Quadratic irrational numbers are of the form ",
 Cell[BoxData[
  FormBox[
   FractionBox[
    RowBox[{
     StyleBox["p",
      "TI"], "\[PlusMinus]", 
     SqrtBox[
      StyleBox["d",
       "TI"]]}], 
    StyleBox["q",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", where ",
 Cell[BoxData[
  FormBox[
   StyleBox["d",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", ",
 Cell[BoxData[
  FormBox[
   StyleBox["p",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", and ",
 Cell[BoxData[
  FormBox[
   StyleBox["q",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " are integers; ",
 Cell[BoxData[
  FormBox[
   StyleBox["d",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is positive and not a perfect square; and ",
 Cell[BoxData[
  FormBox[
   StyleBox["q",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is nonzero and divides ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["d",
     "TI"], "-", 
    SuperscriptBox[
     StyleBox["p",
      "TI"], "2"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". Such numbers have a continued fraction expansion that is infinite but \
periodic. Thus they can be represented finitely in terms of the preperiodic \
part followed by the periodically repeating part. "
}], "Text",
 CellTags->{"S5.67.1", "1.11"}],

Cell[TextData[{
 "This is the continued fraction expansion of the square root of 7, a \
quadratic irrational. Typesetting rules defined for ",
 StyleBox["ContinuedFractionForm", "MR"],
 " put the repeating block in parenthesis, and add an ellipse to mark the \
repetition. "
}], "MathCaption",
 CellTags->{"S5.67.1", "1.12"}],

Cell[CellGroupData[{

Cell["\<\
cf = ContinuedFractionForm[
    ContinuedFraction[Sqrt[7]]
]\
\>", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.67.1"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{"2", "+", 
    FractionBox["1", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       FractionBox["1", 
        RowBox[{"1", "+", 
         FractionBox["1", 
          RowBox[{"1", "+", 
           FractionBox["1", 
            RowBox[{"4", "+", 
             FractionBox["1", "\[Ellipsis]"]}]]}]]}]]}], ")"}]]}],
   ScriptSizeMultipliers->1,
   SpanSymmetric->False],
  ContinuedFractionForm[{2, {1, 1, 1, 4}}]]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.67.1"]
}, Open  ]],

Cell[TextData[{
 "A continued fraction can be turned back into a rational or quadratic \
irrational by application of ",
 StyleBox["Normal", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.67.1", "1.13"}],

Cell[CellGroupData[{

Cell["Normal[cf]", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.67.1"],

Cell[BoxData[
 SqrtBox["7"]], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S5.67.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["Convergents[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["rat", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "give the convergents for all terms of the continued fraction \
corresponding to the rational or quadratic irrational number ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["rat", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Convergents[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["num", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["terms", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "give the convergents for the given number of terms of the continued \
fraction expansion of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["num", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Convergents[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["cf", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the convergents for the particular continued fraction ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["cf", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" returned from ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ContinuedFractions", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" or ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ContinuedFractionForm", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["QuadraticIrrationalQ[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["whether ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is a quadratic irrational",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.67.1"],

Cell["Finding convergents and quadratic irrationals. ", "Caption",
 CellTags->"S5.67.1"],

Cell["\<\
The golden ratio has all of its partial quotients equal to one. \
\>", "MathCaption",
 CellTags->{"S5.67.1", "1.14"}],

Cell[CellGroupData[{

Cell["\<\
cf = ContinuedFractionForm[
    ContinuedFraction[GoldenRatio, 10]
]\
\>", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.67.1"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{"1", "+", 
    FractionBox["1", 
     RowBox[{"1", "+", 
      FractionBox["1", 
       RowBox[{"1", "+", 
        FractionBox["1", 
         RowBox[{"1", "+", 
          FractionBox["1", 
           RowBox[{"1", "+", 
            FractionBox["1", 
             RowBox[{"1", "+", 
              FractionBox["1", 
               RowBox[{"1", "+", 
                FractionBox["1", 
                 RowBox[{"1", "+", 
                  FractionBox["1", 
                   RowBox[{"1", "+", 
                    FractionBox["1", "1"]}]]}]]}]]}]]}]]}]]}]]}]]}],
   ScriptSizeMultipliers->1],
  ContinuedFractionForm[{1, 1, 1, 1, 1, 1, 1, 1, 1, 1}]]], "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S5.67.1"]
}, Open  ]],

Cell["\<\
This gives a list of the convergents of the continued fraction. These \
convergents have the Fibonacci numbers for numerators and denominators. \
\>", "MathCaption",
 CellTags->{"S5.67.1", "1.15"}],

Cell[CellGroupData[{

Cell["Convergents[cf]", "Input",
 CellLabel->"In[7]:= ",
 CellTags->"S5.67.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", 
   FractionBox["3", "2"], ",", 
   FractionBox["5", "3"], ",", 
   FractionBox["8", "5"], ",", 
   FractionBox["13", "8"], ",", 
   FractionBox["21", "13"], ",", 
   FractionBox["34", "21"], ",", 
   FractionBox["55", "34"], ",", 
   FractionBox["89", "55"]}], "}"}]], "Output",
 CellLabel->"Out[7]= ",
 CellTags->"S5.67.1"]
}, Open  ]],

Cell["\<\
The convergents of a number converge to it while alternating sides. \
\>", "MathCaption",
 CellTags->{"S5.67.1", "1.16"}],

Cell[CellGroupData[{

Cell["% - N[GoldenRatio]", "Input",
 CellLabel->"In[8]:= ",
 CellTags->"S5.67.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.6180339887498949`"}], ",", "0.3819660112501051`", ",", 
   RowBox[{"-", "0.1180339887498949`"}], ",", "0.04863267791677184`", ",", 
   RowBox[{"-", "0.018033988749894814`"}], ",", "0.0069660112501050975`", ",",
    
   RowBox[{"-", "0.0026493733652794837`"}], ",", "0.0010136302977241662`", 
   ",", 
   RowBox[{"-", "0.00038692992636546464`"}], ",", "0.00014782943192326314`"}],
   "}"}]], "Output",
 CellLabel->"Out[8]= ",
 CellTags->"S5.67.1"]
}, Open  ]],

Cell[TextData[{
 "Another useful representation of certain types of numbers is the base ",
 Cell[BoxData[
  FormBox[
   StyleBox["b",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " expansion. Not all such expansions are finite. An infinite base ",
 Cell[BoxData[
  FormBox[
   StyleBox["b",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " expansion ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    RowBox[{"(", 
     RowBox[{".", 
      SubscriptBox[
       StyleBox["c",
        "TI"], "1"], " ", 
      SubscriptBox[
       StyleBox["c",
        "TI"], "2"], " ", 
      SubscriptBox[
       StyleBox["c",
        "TI"], "3"], " ", "\[CenterEllipsis]"}], ")"}], 
    StyleBox["b",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is periodic if there are positive integers ",
 Cell[BoxData[
  FormBox[
   StyleBox["m",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox["k",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " such that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     StyleBox["c",
      "TI"], 
     RowBox[{
      StyleBox["n",
       "TI"], "+", 
      StyleBox["k",
       "TI"]}]], "=", 
    SubscriptBox[
     StyleBox["c",
      "TI"], 
     StyleBox["n",
      "TI"]]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " for ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["n",
     "TI"], "\[GreaterEqual]", 
    StyleBox["m",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". It is common to express the base expansion "
}], "Text",
 CellTags->{"S5.67.1", "1.17"}],

Cell[BoxData[
 FormBox[
  SubscriptBox[
   RowBox[{"(", 
    RowBox[{".", 
     SubscriptBox[
      StyleBox["c",
       "TI"], "1"], " ", 
     SubscriptBox[
      StyleBox["c",
       "TI"], "2"], " ", 
     RowBox[{"\[CenterEllipsis]", " "}], 
     SubscriptBox[
      StyleBox["c",
       "TI"], 
      RowBox[{
       StyleBox["m",
        "TI"], "-", "1"}]], " ", 
     SubscriptBox[
      StyleBox["c",
       "TI"], 
      StyleBox["m",
       "TI"]], " ", 
     RowBox[{"\[CenterEllipsis]", " "}], 
     SubscriptBox[
      StyleBox["c",
       "TI"], 
      RowBox[{
       StyleBox["m",
        "TI"], "+", 
       StyleBox["k",
        "TI"], "-", "1"}]], " ", 
     SubscriptBox[
      StyleBox["c",
       "TI"], 
      StyleBox["m",
       "TI"]], " ", 
     RowBox[{"\[CenterEllipsis]", " "}], 
     SubscriptBox[
      StyleBox["c",
       "TI"], 
      RowBox[{
       StyleBox["m",
        "TI"], "+", 
       StyleBox["k",
        "TI"], "-", "1"}]], " ", 
     SubscriptBox[
      StyleBox["c",
       "TI"], 
      StyleBox["m",
       "TI"]], " ", "\[CenterEllipsis]"}], ")"}], 
   StyleBox["b",
    "TI"]], TraditionalForm]], "DisplayFormula",
 UnderoverscriptBoxOptions->{LimitsPositioning->True},
 GridBoxOptions->{ColumnWidths->Automatic},
 CellTags->{"S5.67.1", "1.18"}],

Cell["as ", "Text",
 CellTags->{"S5.67.1", "1.19"}],

Cell[BoxData[
 FormBox[
  SubscriptBox[
   RowBox[{"(", 
    RowBox[{".", 
     SubscriptBox[
      StyleBox["c",
       "TI"], "1"], " ", 
     SubscriptBox[
      StyleBox["c",
       "TI"], "2"], " ", "\[CenterEllipsis]", ",", 
     SubscriptBox[
      StyleBox["c",
       "TI"], 
      RowBox[{
       StyleBox["m",
        "TI"], "-", "1"}]], ",", 
     OverscriptBox[
      RowBox[{
       SubscriptBox[
        StyleBox["c",
         "TI"], 
        StyleBox["m",
         "TI"]], " ", 
       RowBox[{"\[Ellipsis]", " "}], 
       SubscriptBox[
        StyleBox["c",
         "TI"], 
        RowBox[{
         StyleBox["m",
          "TI"], "+", 
         StyleBox["k",
          "TI"], "-", "1"}]]}], "_"]}], ")"}], 
   StyleBox["b",
    "TI"]], TraditionalForm]], "DisplayFormula",
 UnderoverscriptBoxOptions->{LimitsPositioning->True},
 GridBoxOptions->{ColumnWidths->Automatic},
 CellTags->{"S5.67.1", "1.20"}],

Cell["\<\
The nonrepeating elements constitute the preperiodic part and the repeating \
elements constitute the periodic part. \
\>", "Text",
 CellTags->{"S5.67.1", "1.21"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["PeriodicForm[{{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["a",
          "TI"], "0"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] , {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["a",
          "TI"], 
         StyleBox["m",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",\[Ellipsis] }}, ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["exp", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "a representation of a repeated decimal expansion in terms of \
preperiodic and periodic parts with a specific exponent as found by ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["RealDigits", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["PeriodicForm[{{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["a",
          "TI"], "0"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",\[Ellipsis] , {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["a",
          "TI"], 
         StyleBox["m",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",\[Ellipsis] }}, ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["exp", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["b", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["a representation of an expansion in base ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["b",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Normal[PeriodicForm[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["args", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "give the rational number corresponding to the decimal expansion",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.67.1"],

Cell["Periodic expansions. ", "Caption",
 CellTags->"S5.67.1"],

Cell["\<\
This rational number has a finite decimal expansion; the preperiodic part has \
length two and the periodic part has length zero. \
\>", "MathCaption",
 CellTags->{"S5.67.1", "1.22"}],

Cell[CellGroupData[{

Cell["PeriodicForm[RealDigits[ 1/20 ]]", "Input",
 CellLabel->"In[9]:= ",
 CellTags->"S5.67.1"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    RowBox[{"0", ".", "0"}], "5"}],
   ZeroWidthTimes->True],
  PeriodicForm[{{5}, {-1}}]]], "Output",
 CellLabel->"Out[9]= ",
 CellTags->"S5.67.1"]
}, Open  ]],

Cell["\<\
This rational number has an infinite decimal expansion; the preperiodic part \
has length zero and the periodic part has length 16. The periodic part is \
highlighted. \
\>", "MathCaption",
 CellTags->{"S5.67.1", "1.23"}],

Cell[CellGroupData[{

Cell["PeriodicForm[RealDigits[ 1/17 ]]", "Input",
 CellLabel->"In[10]:= ",
 CellTags->"S5.67.1"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    RowBox[{"0", ".", "0"}], 
    OverscriptBox["5", "_"], 
    OverscriptBox["8", "_"], 
    OverscriptBox["8", "_"], 
    OverscriptBox["2", "_"], 
    OverscriptBox["3", "_"], 
    OverscriptBox["5", "_"], 
    OverscriptBox["2", "_"], 
    OverscriptBox["9", "_"], 
    OverscriptBox["4", "_"], 
    OverscriptBox["1", "_"], 
    OverscriptBox["1", "_"], 
    OverscriptBox["7", "_"], 
    OverscriptBox["6", "_"], 
    OverscriptBox["4", "_"], 
    OverscriptBox["7", "_"], 
    OverscriptBox["0", "_"]}],
   ZeroWidthTimes->True],
  PeriodicForm[{{{5, 8, 8, 2, 3, 5, 2, 9, 4, 1, 1, 7, 6, 4, 7, 0}}, {{-1, 
   2992, 1073741824, 0, 0, 0, 0, 0, -1000, 0, 49712, 8560, 50832, 0, 
   167772242, 0}}}]]], "Output",
 CellLabel->"Out[10]= ",
 CellTags->"S5.67.1"]
}, Open  ]],

Cell[TextData[{
 "The decimal number ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "/", "10"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " has an infinite binary expansion. This is the reason that ",
 Cell[BoxData[
  FormBox["0.1", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " cannot be stored in a binary digital computer without representation \
error. "
}], "MathCaption",
 CellTags->{"S5.67.1", "1.24"}],

Cell[CellGroupData[{

Cell["PeriodicForm[RealDigits[ 1/10, 2 ], 2]", "Input",
 CellLabel->"In[11]:= ",
 CellTags->"S5.67.1"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    RowBox[{"0", ".", "0"}], "0", "0", 
    OverscriptBox["1", "_"], 
    OverscriptBox["1", "_"], 
    OverscriptBox["0", "_"], 
    SubscriptBox[
     OverscriptBox["0", "_"], "2"]}],
   ZeroWidthTimes->True],
  PeriodicForm[{{{1, 1, 0, 0}}, {{-3, 0, 0, 0}}}, 2]]], "Output",
 CellLabel->"Out[11]= ",
 CellTags->"S5.67.1"]
}, Open  ]],

Cell["\<\
This reconstructs the previous rational number from its binary digit \
expansion. \
\>", "MathCaption",
 CellTags->{"S5.67.1", "1.25"}],

Cell[CellGroupData[{

Cell["Normal[ % ]", "Input",
 CellLabel->"In[12]:= ",
 CellTags->"S5.67.1"],

Cell[BoxData[
 FractionBox["1", "10"]], "Output",
 CellLabel->"Out[12]= ",
 CellTags->"S5.67.1"]
}, Open  ]],

Cell["\<\
The periodic expansion can be found to any base. If the base is under 36, the \
letters of the alphabet are used for the digits. \
\>", "MathCaption",
 CellTags->{"S5.67.1", "1.26"}],

Cell[CellGroupData[{

Cell["PeriodicForm[RealDigits[573498753434/13, 16], 16]", "Input",
 CellLabel->"In[13]:= ",
 CellTags->"S5.67.1"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    RowBox[{"0", ".", "A"}], "4", "5", "7", "9", "E", "2", "9", "5", 
    OverscriptBox["B", "_"], 
    OverscriptBox["1", "_"], 
    SubscriptBox[
     OverscriptBox["3", "_"], "16"], "\[Times]", 
    SuperscriptBox["16", "9"]}],
   ZeroWidthTimes->True],
  PeriodicForm[{{10, 4, 5, 7, 9, 14, 2, 9, 5, {11, 1, 3}}, 9}, 16]]], "Output",\

 CellLabel->"Out[13]= ",
 CellTags->"S5.67.1"]
}, Open  ]],

Cell[TextData[{
 "Here is a classical example with a lengthy periodic part involving pairs of \
digits ",
 Cell[BoxData[
  FormBox[
   RowBox[{
   "00", "\[NonBreakingSpace]", "01", "\[NonBreakingSpace]", 
    "\[CenterEllipsis]"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " in the decimal digit expansion (see [Glaisher]). "
}], "MathCaption",
 CellTags->{"S5.67.1", "1.27"}],

Cell[CellGroupData[{

Cell["PeriodicForm[RealDigits[1/9801]]", "Input",
 CellLabel->"In[14]:= ",
 CellTags->"S5.67.1"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    RowBox[{"0", ".", "0"}], "0", "0", 
    OverscriptBox["1", "_"], 
    OverscriptBox["0", "_"], 
    OverscriptBox["2", "_"], 
    OverscriptBox["0", "_"], 
    OverscriptBox["3", "_"], 
    OverscriptBox["0", "_"], 
    OverscriptBox["4", "_"], 
    OverscriptBox["0", "_"], 
    OverscriptBox["5", "_"], 
    OverscriptBox["0", "_"], 
    OverscriptBox["6", "_"], 
    OverscriptBox["0", "_"], 
    OverscriptBox["7", "_"], 
    OverscriptBox["0", "_"], 
    OverscriptBox["8", "_"], 
    OverscriptBox["0", "_"], 
    OverscriptBox["9", "_"], 
    OverscriptBox["1", "_"], 
    OverscriptBox["0", "_"], 
    OverscriptBox["1", "_"], 
    OverscriptBox["1", "_"], 
    OverscriptBox["1", "_"], 
    OverscriptBox["2", "_"], 
    OverscriptBox["1", "_"], 
    OverscriptBox["3", "_"], 
    OverscriptBox["1", "_"], 
    OverscriptBox["4", "_"], 
    OverscriptBox["1", "_"], 
    OverscriptBox["5", "_"], 
    OverscriptBox["1", "_"], 
    OverscriptBox["6", "_"], 
    OverscriptBox["1", "_"], 
    OverscriptBox["7", "_"], 
    OverscriptBox["1", "_"], 
    OverscriptBox["8", "_"], 
    OverscriptBox["1", "_"], 
    OverscriptBox["9", "_"], 
    OverscriptBox["2", "_"], 
    OverscriptBox["0", "_"], 
    OverscriptBox["2", "_"], 
    OverscriptBox["1", "_"], 
    OverscriptBox["2", "_"], 
    OverscriptBox["2", "_"], 
    OverscriptBox["2", "_"], 
    OverscriptBox["3", "_"], 
    OverscriptBox["2", "_"], 
    OverscriptBox["4", "_"], 
    OverscriptBox["2", "_"], 
    OverscriptBox["5", "_"], 
    OverscriptBox["2", "_"], 
    OverscriptBox["6", "_"], 
    OverscriptBox["2", "_"], 
    OverscriptBox["7", "_"], 
    OverscriptBox["2", "_"], 
    OverscriptBox["8", "_"], 
    OverscriptBox["2", "_"], 
    OverscriptBox["9", "_"], 
    OverscriptBox["3", "_"], 
    OverscriptBox["0", "_"], 
    OverscriptBox["3", "_"], 
    OverscriptBox["1", "_"], 
    OverscriptBox["3", "_"], 
    OverscriptBox["2", "_"], 
    OverscriptBox["3", "_"], 
    OverscriptBox["3", "_"], 
    OverscriptBox["3", "_"], 
    OverscriptBox["4", "_"], 
    OverscriptBox["3", "_"], 
    OverscriptBox["5", "_"], 
    OverscriptBox["3", "_"], 
    OverscriptBox["6", "_"], 
    OverscriptBox["3", "_"], 
    OverscriptBox["7", "_"], 
    OverscriptBox["3", "_"], 
    OverscriptBox["8", "_"], 
    OverscriptBox["3", "_"], 
    OverscriptBox["9", "_"], 
    OverscriptBox["4", "_"], 
    OverscriptBox["0", "_"], 
    OverscriptBox["4", "_"], 
    OverscriptBox["1", "_"], 
    OverscriptBox["4", "_"], 
    OverscriptBox["2", "_"], 
    OverscriptBox["4", "_"], 
    OverscriptBox["3", "_"], 
    OverscriptBox["4", "_"], 
    OverscriptBox["4", "_"], 
    OverscriptBox["4", "_"], 
    OverscriptBox["5", "_"], 
    OverscriptBox["4", "_"], 
    OverscriptBox["6", "_"], 
    OverscriptBox["4", "_"], 
    OverscriptBox["7", "_"], 
    OverscriptBox["4", "_"], 
    OverscriptBox["8", "_"], 
    OverscriptBox["4", "_"], 
    OverscriptBox["9", "_"], 
    OverscriptBox["5", "_"], 
    OverscriptBox["0", "_"], 
    OverscriptBox["5", "_"], 
    OverscriptBox["1", "_"], 
    OverscriptBox["5", "_"], 
    OverscriptBox["2", "_"], 
    OverscriptBox["5", "_"], 
    OverscriptBox["3", "_"], 
    OverscriptBox["5", "_"], 
    OverscriptBox["4", "_"], 
    OverscriptBox["5", "_"], 
    OverscriptBox["5", "_"], 
    OverscriptBox["5", "_"], 
    OverscriptBox["6", "_"], 
    OverscriptBox["5", "_"], 
    OverscriptBox["7", "_"], 
    OverscriptBox["5", "_"], 
    OverscriptBox["8", "_"], 
    OverscriptBox["5", "_"], 
    OverscriptBox["9", "_"], 
    OverscriptBox["6", "_"], 
    OverscriptBox["0", "_"], 
    OverscriptBox["6", "_"], 
    OverscriptBox["1", "_"], 
    OverscriptBox["6", "_"], 
    OverscriptBox["2", "_"], 
    OverscriptBox["6", "_"], 
    OverscriptBox["3", "_"], 
    OverscriptBox["6", "_"], 
    OverscriptBox["4", "_"], 
    OverscriptBox["6", "_"], 
    OverscriptBox["5", "_"], 
    OverscriptBox["6", "_"], 
    OverscriptBox["6", "_"], 
    OverscriptBox["6", "_"], 
    OverscriptBox["7", "_"], 
    OverscriptBox["6", "_"], 
    OverscriptBox["8", "_"], 
    OverscriptBox["6", "_"], 
    OverscriptBox["9", "_"], 
    OverscriptBox["7", "_"], 
    OverscriptBox["0", "_"], 
    OverscriptBox["7", "_"], 
    OverscriptBox["1", "_"], 
    OverscriptBox["7", "_"], 
    OverscriptBox["2", "_"], 
    OverscriptBox["7", "_"], 
    OverscriptBox["3", "_"], 
    OverscriptBox["7", "_"], 
    OverscriptBox["4", "_"], 
    OverscriptBox["7", "_"], 
    OverscriptBox["5", "_"], 
    OverscriptBox["7", "_"], 
    OverscriptBox["6", "_"], 
    OverscriptBox["7", "_"], 
    OverscriptBox["7", "_"], 
    OverscriptBox["7", "_"], 
    OverscriptBox["8", "_"], 
    OverscriptBox["7", "_"], 
    OverscriptBox["9", "_"], 
    OverscriptBox["8", "_"], 
    OverscriptBox["0", "_"], 
    OverscriptBox["8", "_"], 
    OverscriptBox["1", "_"], 
    OverscriptBox["8", "_"], 
    OverscriptBox["2", "_"], 
    OverscriptBox["8", "_"], 
    OverscriptBox["3", "_"], 
    OverscriptBox["8", "_"], 
    OverscriptBox["4", "_"], 
    OverscriptBox["8", "_"], 
    OverscriptBox["5", "_"], 
    OverscriptBox["8", "_"], 
    OverscriptBox["6", "_"], 
    OverscriptBox["8", "_"], 
    OverscriptBox["7", "_"], 
    OverscriptBox["8", "_"], 
    OverscriptBox["8", "_"], 
    OverscriptBox["8", "_"], 
    OverscriptBox["9", "_"], 
    OverscriptBox["9", "_"], 
    OverscriptBox["0", "_"], 
    OverscriptBox["9", "_"], 
    OverscriptBox["1", "_"], 
    OverscriptBox["9", "_"], 
    OverscriptBox["2", "_"], 
    OverscriptBox["9", "_"], 
    OverscriptBox["3", "_"], 
    OverscriptBox["9", "_"], 
    OverscriptBox["4", "_"], 
    OverscriptBox["9", "_"], 
    OverscriptBox["5", "_"], 
    OverscriptBox["9", "_"], 
    OverscriptBox["6", "_"], 
    OverscriptBox["9", "_"], 
    OverscriptBox["7", "_"], 
    OverscriptBox["9", "_"], 
    OverscriptBox["9", "_"], 
    OverscriptBox["0", "_"], 
    OverscriptBox["0", "_"], 
    OverscriptBox["0", "_"]}],
   ZeroWidthTimes->True],
  PeriodicForm[{{{1, 0, 2, 0, 3, 0, 4, 0, 5, 0, 6, 0, 7, 0, 8, 0, 9, 1, 0, 1, 
   1, 1, 2, 1, 3, 1, 4, 1, 5, 1, 6, 1, 7, 1, 8, 1, 9, 2, 0, 2, 1, 2, 2, 2, 3, 
   2, 4, 2, 5, 2, 6, 2, 7, 2, 8, 2, 9, 3, 0, 3, 1, 3, 2, 3, 3, 3, 4, 3, 5, 3, 
   6, 3, 7, 3, 8, 3, 9, 4, 0, 4, 1, 4, 2, 4, 3, 4, 4, 4, 5, 4, 6, 4, 7, 4, 8, 
   4, 9, 5, 0, 5, 1, 5, 2, 5, 3, 5, 4, 5, 5, 5, 6, 5, 7, 5, 8, 5, 9, 6, 0, 6, 
   1, 6, 2, 6, 3, 6, 4, 6, 5, 6, 6, 6, 7, 6, 8, 6, 9, 7, 0, 7, 1, 7, 2, 7, 3, 
   7, 4, 7, 5, 7, 6, 7, 7, 7, 8, 7, 9, 8, 0, 8, 1, 8, 2, 8, 3, 8, 4, 8, 5, 8, 
   6, 8, 7, 8, 8, 8, 9, 9, 0, 9, 1, 9, 2, 9, 3, 9, 4, 9, 5, 9, 6, 9, 7, 9, 9, 
   0, 0, 0}}, {{-3, 158557656, 1, 28050752, 158557680, 1, 28050912, 158591072,
    1, 28050368, 158557704, 1, 28051760, 158686808, 1, 28051912, 158557728, 1,
    28052064, 158557752, 1, 28052216, 158557776, 1, 28052376, 158557800, 1, 
   28052528, 158691728, 1, 28052680, 158691760, 1, 28052840, 158557824, 1, 
   28052992, 158557848, 1, 28053144, 158557872, 1, 28053296, 158557896, 1, 
   28053448, 158557920, 1, 28053600, 158691776, 1, 28053760, 158691792, 1, 
   28053912, 158557944, 1, 28054064, 158557968, 1, 28054216, 158557992, 1, 
   28054376, 158452832, 1, 28054536, 158591592, 1, 28054696, 158558016, 1, 
   28054848, 158591496, 1, 28055008, 158558040, 1, 28055168, 158558064, 1, 
   28055312, 158558200, 1, 28055456, 158558240, 1, 27803984, 158591456, 1, 
   28055736, 158558152, 1, 28055880, 158709688, 1, 28056032, 158558176, 1, 
   28056184, 158709704, 1, 28056336, 158572784, 1, 28056488, 158572760, 1, 
   28056640, 158558280, 1, 28056792, 158709720, 1, 28056936, 158709744, 1, 
   28057088, 158709760, 1, 28057240, 158709776, 1, 28057384, 158709800, 1, 
   28057544, 158709816, 1, 28057696, 158709840, 1, 28057848, 158709856, 1, 
   26285792, 158709872, 1, 26286472, 158709888, 1, 26285840, 158709904, 1, 
   26286520, 158709920, 1, 26045312, 158709936, 1, 26245048, 158709952, 1, 
   26069408, 158709968, 1, 26245008, 158709984, 1, 25285608, 25285608, 1244, 
   0, 0, 75858068, 1, 1, 1, 25175008, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
   0, 0, 157906299, 0, 157892608, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
   0}}}]]], "Output",
 CellLabel->"Out[14]= ",
 CellTags->"S5.67.1"]
}, Open  ]],

Cell[CellGroupData[{

Cell["References", "Subsubsection",
 CellTags->{"S5.67.1", "1.28"}],

Cell[TextData[{
 "[Rosen] K. H. Rosen, ",
 StyleBox["Elementary Number Theory and Its Applications", "TI"],
 ", Third edition, Addison Wesley, Reading, MA, 1993.\n[Glaisher] J. W. L. \
Glaisher, ",
 StyleBox["Messenger of Math", "TI"],
 ". 2, 41, 1873. "
}], "Text",
 CellTags->{"S5.67.1", "1.29"}]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.67.1"->{
    Cell[1776, 53, 147, 6, 36, "Subsection",
      CellTags->{"S5.67.1", "1.1"}],
    Cell[1926, 61, 394, 7, 56, "Text",
      CellTags->{"S5.67.1", "1.2"}],
    Cell[2323, 70, 312, 11, 24, "Text",
      CellTags->{"S5.67.1", "1.3"}],
    Cell[2638, 83, 499, 19, 57, "DisplayFormula",
      CellTags->{"S5.67.1", "1.4"}],
    Cell[3140, 104, 584, 17, 56, "Text",
      CellTags->{"S5.67.1", "1.5"}],
    Cell[3727, 123, 2003, 76, 73, "Text",
      CellTags->{"S5.67.1", "1.6"}],
    Cell[5733, 201, 614, 16, 88, "Text",
      CellTags->{"S5.67.1", "1.7"}],
    Cell[6350, 219, 6691, 200, 160, "DefinitionBox",
      CellTags->"S5.67.1"],
    Cell[13044, 421, 62, 1, 15, "Caption",
      CellTags->"S5.67.1"],
    Cell[13109, 424, 78, 1, 40, "MathCaption",
      CellTags->{"S5.67.1", "1.8"}],
    Cell[13190, 427, 97, 2, 28, "Input",
      CellTags->"S5.67.1"],
    Cell[13290, 431, 282, 8, 70, "MathCaption",
      CellTags->{"S5.67.1", "1.9"}],
    Cell[13597, 443, 93, 2, 70, "Input",
      CellTags->"S5.67.1"],
    Cell[13693, 447, 209, 6, 70, "Output",
      CellTags->"S5.67.1"],
    Cell[13917, 456, 257, 6, 70, "MathCaption",
      CellTags->{"S5.67.1", "1.10"}],
    Cell[14199, 466, 88, 2, 70, "Input",
      CellTags->"S5.67.1"],
    Cell[14290, 470, 767, 24, 70, "Output",
      CellTags->"S5.67.1"],
    Cell[15072, 497, 1608, 58, 70, "Text",
      CellTags->{"S5.67.1", "1.11"}],
    Cell[16683, 557, 325, 7, 70, "MathCaption",
      CellTags->{"S5.67.1", "1.12"}],
    Cell[17033, 568, 131, 6, 70, "Input",
      CellTags->"S5.67.1"],
    Cell[17167, 576, 525, 18, 70, "Output",
      CellTags->"S5.67.1"],
    Cell[17707, 597, 204, 6, 70, "MathCaption",
      CellTags->{"S5.67.1", "1.13"}],
    Cell[17936, 607, 73, 2, 70, "Input",
      CellTags->"S5.67.1"],
    Cell[18012, 611, 85, 3, 70, "Output",
      CellTags->"S5.67.1"],
    Cell[18112, 617, 4226, 131, 70, "DefinitionBox",
      CellTags->"S5.67.1"],
    Cell[22341, 750, 88, 1, 70, "Caption",
      CellTags->"S5.67.1"],
    Cell[22432, 753, 127, 3, 70, "MathCaption",
      CellTags->{"S5.67.1", "1.14"}],
    Cell[22584, 760, 139, 6, 70, "Input",
      CellTags->"S5.67.1"],
    Cell[22726, 768, 761, 24, 70, "Output",
      CellTags->"S5.67.1"],
    Cell[23502, 795, 207, 4, 70, "MathCaption",
      CellTags->{"S5.67.1", "1.15"}],
    Cell[23734, 803, 78, 2, 70, "Input",
      CellTags->"S5.67.1"],
    Cell[23815, 807, 384, 12, 70, "Output",
      CellTags->"S5.67.1"],
    Cell[24214, 822, 131, 3, 70, "MathCaption",
      CellTags->{"S5.67.1", "1.16"}],
    Cell[24370, 829, 81, 2, 70, "Input",
      CellTags->"S5.67.1"],
    Cell[24454, 833, 505, 12, 70, "Output",
      CellTags->"S5.67.1"],
    Cell[24974, 848, 1881, 72, 70, "Text",
      CellTags->{"S5.67.1", "1.17"}],
    Cell[26858, 922, 1298, 55, 70, "DisplayFormula",
      CellTags->{"S5.67.1", "1.18"}],
    Cell[28159, 979, 51, 1, 70, "Text",
      CellTags->{"S5.67.1", "1.19"}],
    Cell[28213, 982, 923, 37, 70, "DisplayFormula",
      CellTags->{"S5.67.1", "1.20"}],
    Cell[29139, 1021, 173, 4, 70, "Text",
      CellTags->{"S5.67.1", "1.21"}],
    Cell[29315, 1027, 4518, 137, 70, "DefinitionBox",
      CellTags->"S5.67.1"],
    Cell[33836, 1166, 62, 1, 70, "Caption",
      CellTags->"S5.67.1"],
    Cell[33901, 1169, 193, 4, 70, "MathCaption",
      CellTags->{"S5.67.1", "1.22"}],
    Cell[34119, 1177, 95, 2, 70, "Input",
      CellTags->"S5.67.1"],
    Cell[34217, 1181, 206, 8, 70, "Output",
      CellTags->"S5.67.1"],
    Cell[34438, 1192, 231, 5, 70, "MathCaption",
      CellTags->{"S5.67.1", "1.23"}],
    Cell[34694, 1201, 96, 2, 70, "Input",
      CellTags->"S5.67.1"],
    Cell[34793, 1205, 819, 26, 70, "Output",
      CellTags->"S5.67.1"],
    Cell[35627, 1234, 488, 13, 70, "MathCaption",
      CellTags->{"S5.67.1", "1.24"}],
    Cell[36140, 1251, 102, 2, 70, "Input",
      CellTags->"S5.67.1"],
    Cell[36245, 1255, 382, 13, 70, "Output",
      CellTags->"S5.67.1"],
    Cell[36642, 1271, 145, 4, 70, "MathCaption",
      CellTags->{"S5.67.1", "1.25"}],
    Cell[36812, 1279, 75, 2, 70, "Input",
      CellTags->"S5.67.1"],
    Cell[36890, 1283, 96, 3, 70, "Output",
      CellTags->"S5.67.1"],
    Cell[37001, 1289, 192, 4, 70, "MathCaption",
      CellTags->{"S5.67.1", "1.26"}],
    Cell[37218, 1297, 113, 2, 70, "Input",
      CellTags->"S5.67.1"],
    Cell[37334, 1301, 443, 14, 70, "Output",
      CellTags->"S5.67.1"],
    Cell[37792, 1318, 419, 11, 70, "MathCaption",
      CellTags->{"S5.67.1", "1.27"}],
    Cell[38236, 1333, 96, 2, 70, "Input",
      CellTags->"S5.67.1"],
    Cell[38335, 1337, 8285, 234, 70, "Output",
      CellTags->"S5.67.1"],
    Cell[46657, 1576, 67, 1, 70, "Subsubsection",
      CellTags->{"S5.67.1", "1.28"}],
    Cell[46727, 1579, 298, 8, 70, "Text",
      CellTags->{"S5.67.1", "1.29"}]},
  "1.1"->{
    Cell[1776, 53, 147, 6, 36, "Subsection",
      CellTags->{"S5.67.1", "1.1"}]},
  "1.2"->{
    Cell[1926, 61, 394, 7, 56, "Text",
      CellTags->{"S5.67.1", "1.2"}]},
  "1.3"->{
    Cell[2323, 70, 312, 11, 24, "Text",
      CellTags->{"S5.67.1", "1.3"}]},
  "1.4"->{
    Cell[2638, 83, 499, 19, 57, "DisplayFormula",
      CellTags->{"S5.67.1", "1.4"}]},
  "1.5"->{
    Cell[3140, 104, 584, 17, 56, "Text",
      CellTags->{"S5.67.1", "1.5"}]},
  "1.6"->{
    Cell[3727, 123, 2003, 76, 73, "Text",
      CellTags->{"S5.67.1", "1.6"}]},
  "1.7"->{
    Cell[5733, 201, 614, 16, 88, "Text",
      CellTags->{"S5.67.1", "1.7"}]},
  "1.8"->{
    Cell[13109, 424, 78, 1, 40, "MathCaption",
      CellTags->{"S5.67.1", "1.8"}]},
  "1.9"->{
    Cell[13290, 431, 282, 8, 70, "MathCaption",
      CellTags->{"S5.67.1", "1.9"}]},
  "1.10"->{
    Cell[13917, 456, 257, 6, 70, "MathCaption",
      CellTags->{"S5.67.1", "1.10"}]},
  "1.11"->{
    Cell[15072, 497, 1608, 58, 70, "Text",
      CellTags->{"S5.67.1", "1.11"}]},
  "1.12"->{
    Cell[16683, 557, 325, 7, 70, "MathCaption",
      CellTags->{"S5.67.1", "1.12"}]},
  "1.13"->{
    Cell[17707, 597, 204, 6, 70, "MathCaption",
      CellTags->{"S5.67.1", "1.13"}]},
  "1.14"->{
    Cell[22432, 753, 127, 3, 70, "MathCaption",
      CellTags->{"S5.67.1", "1.14"}]},
  "1.15"->{
    Cell[23502, 795, 207, 4, 70, "MathCaption",
      CellTags->{"S5.67.1", "1.15"}]},
  "1.16"->{
    Cell[24214, 822, 131, 3, 70, "MathCaption",
      CellTags->{"S5.67.1", "1.16"}]},
  "1.17"->{
    Cell[24974, 848, 1881, 72, 70, "Text",
      CellTags->{"S5.67.1", "1.17"}]},
  "1.18"->{
    Cell[26858, 922, 1298, 55, 70, "DisplayFormula",
      CellTags->{"S5.67.1", "1.18"}]},
  "1.19"->{
    Cell[28159, 979, 51, 1, 70, "Text",
      CellTags->{"S5.67.1", "1.19"}]},
  "1.20"->{
    Cell[28213, 982, 923, 37, 70, "DisplayFormula",
      CellTags->{"S5.67.1", "1.20"}]},
  "1.21"->{
    Cell[29139, 1021, 173, 4, 70, "Text",
      CellTags->{"S5.67.1", "1.21"}]},
  "1.22"->{
    Cell[33901, 1169, 193, 4, 70, "MathCaption",
      CellTags->{"S5.67.1", "1.22"}]},
  "1.23"->{
    Cell[34438, 1192, 231, 5, 70, "MathCaption",
      CellTags->{"S5.67.1", "1.23"}]},
  "1.24"->{
    Cell[35627, 1234, 488, 13, 70, "MathCaption",
      CellTags->{"S5.67.1", "1.24"}]},
  "1.25"->{
    Cell[36642, 1271, 145, 4, 70, "MathCaption",
      CellTags->{"S5.67.1", "1.25"}]},
  "1.26"->{
    Cell[37001, 1289, 192, 4, 70, "MathCaption",
      CellTags->{"S5.67.1", "1.26"}]},
  "1.27"->{
    Cell[37792, 1318, 419, 11, 70, "MathCaption",
      CellTags->{"S5.67.1", "1.27"}]},
  "1.28"->{
    Cell[46657, 1576, 67, 1, 70, "Subsubsection",
      CellTags->{"S5.67.1", "1.28"}]},
  "1.29"->{
    Cell[46727, 1579, 298, 8, 70, "Text",
      CellTags->{"S5.67.1", "1.29"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.67.1", 47676, 1607},
  {"1.1", 52495, 1732},
  {"1.2", 52589, 1735},
  {"1.3", 52677, 1738},
  {"1.4", 52766, 1741},
  {"1.5", 52865, 1744},
  {"1.6", 52955, 1747},
  {"1.7", 53046, 1750},
  {"1.8", 53136, 1753},
  {"1.9", 53232, 1756},
  {"1.10", 53330, 1759},
  {"1.11", 53429, 1762},
  {"1.12", 53523, 1765},
  {"1.13", 53622, 1768},
  {"1.14", 53721, 1771},
  {"1.15", 53820, 1774},
  {"1.16", 53919, 1777},
  {"1.17", 54018, 1780},
  {"1.18", 54112, 1783},
  {"1.19", 54216, 1786},
  {"1.20", 54307, 1789},
  {"1.21", 54410, 1792},
  {"1.22", 54503, 1795},
  {"1.23", 54603, 1798},
  {"1.24", 54703, 1801},
  {"1.25", 54804, 1804},
  {"1.26", 54904, 1807},
  {"1.27", 55004, 1810},
  {"1.28", 55105, 1813},
  {"1.29", 55206, 1816}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 147, 6, 36, "Subsection",
  CellTags->{"S5.67.1", "1.1"}],
Cell[1926, 61, 394, 7, 56, "Text",
  CellTags->{"S5.67.1", "1.2"}],
Cell[2323, 70, 312, 11, 24, "Text",
  CellTags->{"S5.67.1", "1.3"}],
Cell[2638, 83, 499, 19, 57, "DisplayFormula",
  CellTags->{"S5.67.1", "1.4"}],
Cell[3140, 104, 584, 17, 56, "Text",
  CellTags->{"S5.67.1", "1.5"}],
Cell[3727, 123, 2003, 76, 73, "Text",
  CellTags->{"S5.67.1", "1.6"}],
Cell[5733, 201, 614, 16, 88, "Text",
  CellTags->{"S5.67.1", "1.7"}],
Cell[6350, 219, 6691, 200, 160, "DefinitionBox",
  CellTags->"S5.67.1"],
Cell[13044, 421, 62, 1, 15, "Caption",
  CellTags->"S5.67.1"],
Cell[13109, 424, 78, 1, 40, "MathCaption",
  CellTags->{"S5.67.1", "1.8"}],
Cell[13190, 427, 97, 2, 28, "Input",
  CellTags->"S5.67.1"],
Cell[13290, 431, 282, 8, 70, "MathCaption",
  CellTags->{"S5.67.1", "1.9"}],

Cell[CellGroupData[{
Cell[13597, 443, 93, 2, 70, "Input",
  CellTags->"S5.67.1"],
Cell[13693, 447, 209, 6, 70, "Output",
  CellTags->"S5.67.1"]
}, Open  ]],
Cell[13917, 456, 257, 6, 70, "MathCaption",
  CellTags->{"S5.67.1", "1.10"}],

Cell[CellGroupData[{
Cell[14199, 466, 88, 2, 70, "Input",
  CellTags->"S5.67.1"],
Cell[14290, 470, 767, 24, 70, "Output",
  CellTags->"S5.67.1"]
}, Open  ]],
Cell[15072, 497, 1608, 58, 70, "Text",
  CellTags->{"S5.67.1", "1.11"}],
Cell[16683, 557, 325, 7, 70, "MathCaption",
  CellTags->{"S5.67.1", "1.12"}],

Cell[CellGroupData[{
Cell[17033, 568, 131, 6, 70, "Input",
  CellTags->"S5.67.1"],
Cell[17167, 576, 525, 18, 70, "Output",
  CellTags->"S5.67.1"]
}, Open  ]],
Cell[17707, 597, 204, 6, 70, "MathCaption",
  CellTags->{"S5.67.1", "1.13"}],

Cell[CellGroupData[{
Cell[17936, 607, 73, 2, 70, "Input",
  CellTags->"S5.67.1"],
Cell[18012, 611, 85, 3, 70, "Output",
  CellTags->"S5.67.1"]
}, Open  ]],
Cell[18112, 617, 4226, 131, 70, "DefinitionBox",
  CellTags->"S5.67.1"],
Cell[22341, 750, 88, 1, 70, "Caption",
  CellTags->"S5.67.1"],
Cell[22432, 753, 127, 3, 70, "MathCaption",
  CellTags->{"S5.67.1", "1.14"}],

Cell[CellGroupData[{
Cell[22584, 760, 139, 6, 70, "Input",
  CellTags->"S5.67.1"],
Cell[22726, 768, 761, 24, 70, "Output",
  CellTags->"S5.67.1"]
}, Open  ]],
Cell[23502, 795, 207, 4, 70, "MathCaption",
  CellTags->{"S5.67.1", "1.15"}],

Cell[CellGroupData[{
Cell[23734, 803, 78, 2, 70, "Input",
  CellTags->"S5.67.1"],
Cell[23815, 807, 384, 12, 70, "Output",
  CellTags->"S5.67.1"]
}, Open  ]],
Cell[24214, 822, 131, 3, 70, "MathCaption",
  CellTags->{"S5.67.1", "1.16"}],

Cell[CellGroupData[{
Cell[24370, 829, 81, 2, 70, "Input",
  CellTags->"S5.67.1"],
Cell[24454, 833, 505, 12, 70, "Output",
  CellTags->"S5.67.1"]
}, Open  ]],
Cell[24974, 848, 1881, 72, 70, "Text",
  CellTags->{"S5.67.1", "1.17"}],
Cell[26858, 922, 1298, 55, 70, "DisplayFormula",
  CellTags->{"S5.67.1", "1.18"}],
Cell[28159, 979, 51, 1, 70, "Text",
  CellTags->{"S5.67.1", "1.19"}],
Cell[28213, 982, 923, 37, 70, "DisplayFormula",
  CellTags->{"S5.67.1", "1.20"}],
Cell[29139, 1021, 173, 4, 70, "Text",
  CellTags->{"S5.67.1", "1.21"}],
Cell[29315, 1027, 4518, 137, 70, "DefinitionBox",
  CellTags->"S5.67.1"],
Cell[33836, 1166, 62, 1, 70, "Caption",
  CellTags->"S5.67.1"],
Cell[33901, 1169, 193, 4, 70, "MathCaption",
  CellTags->{"S5.67.1", "1.22"}],

Cell[CellGroupData[{
Cell[34119, 1177, 95, 2, 70, "Input",
  CellTags->"S5.67.1"],
Cell[34217, 1181, 206, 8, 70, "Output",
  CellTags->"S5.67.1"]
}, Open  ]],
Cell[34438, 1192, 231, 5, 70, "MathCaption",
  CellTags->{"S5.67.1", "1.23"}],

Cell[CellGroupData[{
Cell[34694, 1201, 96, 2, 70, "Input",
  CellTags->"S5.67.1"],
Cell[34793, 1205, 819, 26, 70, "Output",
  CellTags->"S5.67.1"]
}, Open  ]],
Cell[35627, 1234, 488, 13, 70, "MathCaption",
  CellTags->{"S5.67.1", "1.24"}],

Cell[CellGroupData[{
Cell[36140, 1251, 102, 2, 70, "Input",
  CellTags->"S5.67.1"],
Cell[36245, 1255, 382, 13, 70, "Output",
  CellTags->"S5.67.1"]
}, Open  ]],
Cell[36642, 1271, 145, 4, 70, "MathCaption",
  CellTags->{"S5.67.1", "1.25"}],

Cell[CellGroupData[{
Cell[36812, 1279, 75, 2, 70, "Input",
  CellTags->"S5.67.1"],
Cell[36890, 1283, 96, 3, 70, "Output",
  CellTags->"S5.67.1"]
}, Open  ]],
Cell[37001, 1289, 192, 4, 70, "MathCaption",
  CellTags->{"S5.67.1", "1.26"}],

Cell[CellGroupData[{
Cell[37218, 1297, 113, 2, 70, "Input",
  CellTags->"S5.67.1"],
Cell[37334, 1301, 443, 14, 70, "Output",
  CellTags->"S5.67.1"]
}, Open  ]],
Cell[37792, 1318, 419, 11, 70, "MathCaption",
  CellTags->{"S5.67.1", "1.27"}],

Cell[CellGroupData[{
Cell[38236, 1333, 96, 2, 70, "Input",
  CellTags->"S5.67.1"],
Cell[38335, 1337, 8285, 234, 70, "Output",
  CellTags->"S5.67.1"]
}, Open  ]],

Cell[CellGroupData[{
Cell[46657, 1576, 67, 1, 70, "Subsubsection",
  CellTags->{"S5.67.1", "1.28"}],
Cell[46727, 1579, 298, 8, 70, "Text",
  CellTags->{"S5.67.1", "1.29"}]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

