(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     78706,       2671]*)
(*NotebookOutlinePosition[     86439,       2902]*)
(*  CellTagsIndexPosition[     85699,       2869]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Statistics",
 StyleBox["`", "MB"],
 "ContinuousDistributions",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.97.1", "1.1"}],

Cell[TextData[{
 "This package gives you access to the most commonly used continuous \
statistical distributions. You can compute their densities, means, variances, \
and other related properties. The distributions themselves are represented in \
the symbolic form ",
 StyleBox["name", "TI"],
 StyleBox["[", "MR"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["param",
     "TI"], "1"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox[", ", "MR"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["param",
     "TI"], "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox[", \[Ellipsis] ]", "MR"],
 ". Functions such as ",
 StyleBox["Mean", "MR"],
 ", which give properties of statistical distributions, take the symbolic \
representation of the distribution as an argument. "
}], "Text",
 CellTags->{"S5.97.1", "1.2"}],

Cell[TextData[{
 "Several of the most commonly used distributions are derived from the normal \
or Gaussian distribution. These distributions can also be found in the ",
 StyleBox["NormalDistribution", "MR"],
 " package. You should use ",
 StyleBox["NormalDistribution", "MR"],
 " instead of this package when you need only the normal, Student ",
 Cell[BoxData[
  FormBox[
   StyleBox["t",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", chi\[Hyphen]square, or ",
 Cell[BoxData[
  FormBox[
   StyleBox["F",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "\[Hyphen]ratio distributions. Descriptions of these four distributions are \
given in more detail in the ",
 StyleBox["NormalDistribution", "MR"],
 " section. The package ",
 StyleBox["DiscreteDistributions", "MR"],
 " contains many discrete statistical distributions. "
}], "Text",
 CellTags->{"S5.97.1", "1.3"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["ChiSquareDistribution[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["chi\[Hyphen]square distribution with ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" degrees of freedom ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["FRatioDistribution[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["n",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["n",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["F",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["\[Hyphen]ratio distribution with ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["n",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" numerator and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["n",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" denominator degrees of freedom ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["NormalDistribution[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["\[Mu]", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["\[Sigma]", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["normal (Gaussian) distribution with mean ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["\[Mu]", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and standard deviation ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["\[Sigma]", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["StudentTDistribution[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Student ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["t",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" distribution with ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["n",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" degrees of freedom ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.97.1"],

Cell["Common distributions derived from the normal distribution. ", "Caption",
 CellTags->"S5.97.1"],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["BetaDistribution[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["alpha", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["beta", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["continuous beta distribution with shape parameters ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["\[Alpha]", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["\[Beta]", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["CauchyDistribution[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["a", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["b", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Cauchy distribution with location parameter ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["a",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and scale parameter ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["b",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ChiDistribution[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["chi distribution with ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" degrees of freedom ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ExponentialDistribution[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["lambda", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "exponential distribution with scale inversely proportional to \
parameter ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["\[Lambda]", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ExtremeValueDistribution[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["alpha", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["beta", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "extreme value (Fisher\[Hyphen]Tippett) distribution with location \
parameter ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["\[Alpha]", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and scale parameter ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["\[Beta]", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["GammaDistribution[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["alpha", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["lambda", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["gamma distribution with shape parameter ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["\[Alpha]", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and scale parameter ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["\[Lambda]", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["HalfNormalDistribution[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["theta", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "half\[Hyphen]normal distribution with scale inversely proportional to \
parameter ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["\[Theta]", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["LaplaceDistribution[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["mu", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["beta", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Laplace (double exponential) distribution with mean ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["\[Mu]", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and scale parameter ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["\[Beta]", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["LogisticDistribution[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["mu", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["beta", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["logistic distribution with mean ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["\[Mu]", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and scale parameter ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["\[Beta]", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["LogNormalDistribution[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["mu", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["sigma", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "lognormal distribution based on a normal distribution with mean ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["\[Mu]", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and standard deviation ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["\[Sigma]", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ParetoDistribution[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["k", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["alpha", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Pareto distribution with minimum value parameter ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["k",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and shape parameter ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["\[Alpha]", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["RayleighDistribution[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["sigma", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Rayleigh distribution with scale parameter ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["\[Sigma]", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["UniformDistribution[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["min", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["max", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["uniform distribution on the interval ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["min", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["max", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["WeibullDistribution[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["alpha", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["beta", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Weibull distribution with shape parameter ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["\[Alpha]", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and scale parameter ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["\[Beta]", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.97.1"],

Cell["Continuous statistical distributions. ", "Caption",
 CellTags->"S5.97.1"],

Cell[TextData[{
 "The ",
 StyleBox["uniform distribution", "TB"],
 " ",
 StyleBox["UniformDistribution[", "MR"],
 StyleBox["min", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["max", "TI"],
 StyleBox["]", "MR"],
 ", commonly referred to as the rectangular distribution, characterizes a \
random variable whose value is everywhere equally likely. An example of a \
uniformly distributed random variable is the location of a point chosen \
randomly on a line from ",
 StyleBox["min", "MR"],
 " to ",
 StyleBox["max", "MR"],
 ". If ",
 Cell[BoxData[
  FormBox[
   StyleBox["X",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is uniformly distributed on [",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "\[Pi]"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", ",
 Cell[BoxData[
  FormBox["\[Pi]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "], then the random variable ",
 Cell[BoxData[
  FormBox[
   RowBox[{"tan", 
    StyleBox["X",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " follows a ",
 StyleBox["Cauchy distribution", "TB"],
 " ",
 StyleBox["CauchyDistribution[", "MR"],
 StyleBox["a", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["b", "TI"],
 StyleBox["]", "MR"],
 ", with ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["a",
     "TI"], "=", "0"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["b",
     "TI"], "=", "1"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "Text",
 CellTags->{"S5.97.1", "1.4"}],

Cell[TextData[{
 "The ",
 StyleBox["lognormal distribution", "TB"],
 " ",
 StyleBox["LogNormalDistribution[", "MR"],
 StyleBox["mu", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["sigma", "TI"],
 StyleBox["]", "MR"],
 " is the distribution followed by the exponential of a normally distributed \
random variable. This distribution arises when many independent random \
variables are combined in a multiplicative fashion. The ",
 StyleBox["halfnormal distribution", "TB"],
 " ",
 StyleBox["HalfNormalDistribution[", "MR"],
 StyleBox["theta", "TI"],
 StyleBox["]", "MR"],
 " is proportional to the distribution ",
 StyleBox["NormalDistribution[0,", "MR"],
 " ",
 StyleBox["1/(", "MR"],
 StyleBox["theta", "TI"],
 StyleBox[" Sqrt[2/Pi])]", "MR"],
 " limited to the domain [0, ",
 Cell[BoxData[
  FormBox["\[Infinity]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "). "
}], "Text",
 CellTags->{"S5.97.1", "1.5"}],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Alpha]", "=", 
    StyleBox["n",
     "TI"], "/", "2"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Lambda]", "=", "2"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", the ",
 StyleBox["gamma distribution", "TB"],
 " ",
 StyleBox["GammaDistribution[", "MR"],
 StyleBox["alpha", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["lambda", "TI"],
 StyleBox["]", "MR"],
 " describes the distribution of a sum of squares of ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " unit normal random variables. This form of the gamma distribution is \
called a ",
 StyleBox["chi\[Hyphen]square distribution", "TB"],
 " with ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " degrees of freedom. When ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Alpha]", "=", "1"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", the gamma distribution takes on the form of the ",
 StyleBox["exponential distribution", "TB"],
 " ",
 StyleBox["ExponentialDistribution[", "MR"],
 StyleBox["lambda", "TI"],
 StyleBox["]", "MR"],
 ", often used in describing the waiting time between events. "
}], "Text",
 CellTags->{"S5.97.1", "1.6"}],

Cell[TextData[{
 "The ",
 StyleBox["chi distribution", "TB"],
 " ",
 StyleBox["ChiDistribution[", "MR"],
 StyleBox["n", "TI"],
 StyleBox["]", "MR"],
 " is followed by the square root of a chi\[Hyphen]square random variable. \
For ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["n",
     "TI"], "=", "1"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", the chi distribution is identical to ",
 StyleBox["HalfNormalDistribution[", "MR"],
 StyleBox["theta", "TI"],
 StyleBox["]", "MR"],
 " with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Theta]", "=", "1"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". For ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["n",
     "TI"], "=", "2"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", the chi distribution is identical to the ",
 StyleBox["Rayleigh distribution", "TB"],
 " ",
 StyleBox["RayleighDistribution[", "MR"],
 StyleBox["sigma", "TI"],
 StyleBox["]", "MR"],
 " with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Sigma]", "=", "1"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "Text",
 CellTags->{"S5.97.1", "1.7"}],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["X",
     "TI"], "1"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["X",
     "TI"], "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " have independent gamma distributions with equal scale parameters, the \
random variable ",
 Cell[BoxData[
  FormBox[
   FractionBox[
    SubscriptBox[
     StyleBox["X",
      "TI"], "1"], 
    RowBox[{
     SubscriptBox[
      StyleBox["X",
       "TI"], "1"], "+", 
     SubscriptBox[
      StyleBox["X",
       "TI"], "2"]}]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " follows the ",
 StyleBox["beta distribution", "TB"],
 " ",
 StyleBox["BetaDistribution[", "MR"],
 StyleBox["alpha", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["beta", "TI"],
 StyleBox["]", "MR"],
 ", where ",
 Cell[BoxData[
  FormBox["\[Alpha]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox["\[Beta]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " are the shape parameters of the gamma variables. "
}], "Text",
 CellTags->{"S5.97.1", "1.8"}],

Cell[TextData[{
  "The ",
  StyleBox["Weibull distribution", "TB"],
  " ",
  StyleBox["WeibullDistribution[", "MR"],
  StyleBox["alpha", "TI"],
  StyleBox[", ", "MR"],
  StyleBox["beta", "TI"],
  StyleBox["]", "MR"],
  " is commonly used in engineering to describe the lifetime of an object. \
The ",
  StyleBox["extreme value distribution", "TB"],
  " ",
  StyleBox["ExtremeValueDistribution[", "MR"],
  StyleBox["alpha", "TI"],
  StyleBox[", ", "MR"],
  StyleBox["beta", "TI"],
  StyleBox["]", "MR"],
  " is the limiting distribution for the  largest values in large samples \
drawn from a variety of distributions, including the normal distribution. The \
limiting distribution for the smallest values in such samples can be obtained \
by multiplying ",
  StyleBox["ExtremeValueDistribution[", "MR"],
  StyleBox["alpha", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["beta", "TI"],
  StyleBox["]", "MR"],
  " random variables by -1. The extreme value distribution is sometimes \
referred to as the log\[Hyphen]Weibull distribution because of logarithmic \
relationships between an extreme value distributed random variable and a \
properly shifted and scaled Weibull distributed random variable. "
}], "Text",
  CellTags->{"S5.97.1", "1.9"}],

Cell[TextData[{
 "The ",
 StyleBox["Laplace distribution", "TB"],
 " ",
 StyleBox["LaplaceDistribution[", "MR"],
 StyleBox["mu", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["beta", "TI"],
 StyleBox["]", "MR"],
 " is the distribution of the difference of two independent random variables \
with identical exponential distributions. The ",
 StyleBox["logistic distribution", "TB"],
 " ",
 StyleBox["LogisticDistribution[", "MR"],
 StyleBox["mu", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["beta", "TI"],
 StyleBox["]", "MR"],
 " is frequently used in place of the normal distribution when a distribution \
with longer tails is desired. "
}], "Text",
 CellTags->{"S5.97.1", "1.10"}],

Cell[TextData[{
 "The ",
 StyleBox["Pareto distribution", "TB"],
 " ",
 StyleBox["ParetoDistribution[", "MR"],
 StyleBox["k", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["alpha", "TI"],
 StyleBox["]", "MR"],
 " may be used to describe income, ",
 Cell[BoxData[
  FormBox[
   StyleBox["k",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " representing the minimum income possible. "
}], "Text",
 CellTags->{"S5.97.1", "1.11"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["NoncentralChiSquareDistribution[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["lambda", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["noncentral chi\[Hyphen]square distribution with ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" degrees of freedom and noncentrality parameter ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["\[Lambda]", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["NoncentralStudentTDistribution[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["lambda", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["noncentral Student ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["t",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" distribution with ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" degrees of freedom and noncentrality parameter ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["\[Lambda]", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["NoncentralFRatioDistribution[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["n",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["n",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["lambda", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["noncentral ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["F",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["\[Hyphen]ratio distribution with ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["n",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" numerator degrees of freedom and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["n",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[
      " denominator degrees of freedom and numerator noncentrality parameter \
",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["\[Lambda]", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.97.1"],

Cell["Distributions with noncentrality parameters.", "Caption",
 CellTags->"S5.97.1"],

Cell[TextData[{
 "Distributions that are derived from normal distributions with nonzero means \
are called ",
 StyleBox["noncentral distributions", "TI"],
 ". "
}], "Text",
 CellTags->{"S5.97.1", "1.12"}],

Cell[TextData[{
 "The sum of the squares of ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " normally distributed random variables with variance ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["\[Sigma]", "2"], "=", "1"}], TraditionalForm]], 
  "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and nonzero means follows a ",
 StyleBox["noncentral chi\[Hyphen]square distribution", "TB"],
 " ",
 StyleBox["NoncentralChiSquareDistribution[", "MR"],
 StyleBox["n", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["lambda", "TI"],
 StyleBox["]", "MR"],
 ". The noncentrality parameter ",
 Cell[BoxData[
  FormBox["\[Lambda]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is the sum of the squares of the means of the random variables in the sum. \
Note that in various places in the literature, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Lambda]", "/", "2"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " or ",
 Cell[BoxData[
  FormBox[
   SqrtBox["\[Lambda]"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is used as the noncentrality parameter. "
}], "Text",
 CellTags->{"S5.97.1", "1.13"}],

Cell[TextData[{
 "The ",
 StyleBox["noncentral Student ", "TB"],
 StyleBox["t", "TBI"],
 StyleBox[" distribution", "TB"],
 " ",
 StyleBox["NoncentralStudentTDistribution[", "MR"],
 StyleBox["n", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["lambda", "TI"],
 StyleBox["]", "MR"],
 " describes the ratio ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["X",
     "TI"], "/", 
    SqrtBox[
     RowBox[{
      SubsuperscriptBox["\[Chi]", 
       StyleBox["n",
        "TI"], "2"], "/", 
      StyleBox["n",
       "TI"]}]]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " where ",
 Cell[BoxData[
  FormBox[
   SubsuperscriptBox["\[Chi]", 
    StyleBox["n",
     "TI"], "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is a central chi\[Hyphen]square random variable with ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " degrees of freedom, and ",
 Cell[BoxData[
  FormBox[
   StyleBox["X",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is an independent normally distributed random variable with variance ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["\[Sigma]", "2"], "=", "1"}], TraditionalForm]], 
  "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and mean ",
 Cell[BoxData[
  FormBox["\[Lambda]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "Text",
 CellTags->{"S5.97.1", "1.14"}],

Cell[TextData[{
 "The ",
 StyleBox["noncentral ", "TB"],
 StyleBox["F", "TBI"],
 StyleBox["\[Hyphen]ratio distribution", "TB"],
 " ",
 StyleBox["NoncentralFRatioDistribution[", "MR"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["n",
     "TI"], "1"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox[", ", "MR"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["n",
     "TI"], "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox[", ", "MR"],
 StyleBox["lambda", "TI"],
 StyleBox["]", "MR"],
 " is the distribution of the ratio of a noncentral chi\[Hyphen]square random \
variable with noncentrality parameter ",
 Cell[BoxData[
  FormBox["\[Lambda]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["n",
     "TI"], "1"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " degrees of freedom to a central chi\[Hyphen]square random variable with ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["n",
     "TI"], "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " degrees of freedom. "
}], "Text",
 CellTags->{"S5.97.1", "1.15"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["PDF[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["probability density function at ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["x",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["CDF[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["cumulative distribution function at ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["x",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Quantile[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["q", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["q",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SuperscriptBox["\[Null]", "th"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" quantile ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Domain[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "range of values of the variable (support) ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Mean[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["mean ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Variance[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["variance ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["StandardDeviation[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["standard deviation ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Skewness[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["coefficient of skewness ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Kurtosis[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["coefficient of kurtosis ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["KurtosisExcess[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["kurtosis excess ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["CharacteristicFunction[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["t", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["characteristic function ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"\[Phi]", 
         RowBox[{"(", 
          StyleBox["t",
           "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ExpectedValue[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["expected value of pure function ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["f",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" with respect to the specified distribution ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ExpectedValue[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["expected value of function ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["f",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["x",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" with respect to the specified distribution ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Random[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "pseudorandom number with specified distribution ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["RandomArray[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dims", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["pseudorandom array with dimensionality ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dims", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", and elements from the specified distribution ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.97.1"],

Cell["Functions of statistical distributions. ", "Caption",
 CellTags->"S5.97.1"],

Cell[TextData[{
 "The ",
 StyleBox["cumulative distribution function", "TB"],
 " (cdf) at ",
 Cell[BoxData[
  FormBox[
   StyleBox["x",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is given by the integral of the ",
 StyleBox["probability density function", "TB"],
 " (pdf) up to ",
 Cell[BoxData[
  FormBox[
   StyleBox["x",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". The pdf can therefore be obtained by differentiating the cdf (perhaps in \
a generalized sense). In this package the distributions are represented in \
symbolic form. ",
 StyleBox["PDF[", "MR"],
 StyleBox["dist", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["x", "TI"],
 StyleBox["]", "MR"],
 " evaluates the density at ",
 Cell[BoxData[
  FormBox[
   StyleBox["x",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " if ",
 Cell[BoxData[
  FormBox[
   StyleBox["x",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is a numerical value, and otherwise leaves the function in symbolic form. \
Similarly, ",
 StyleBox["CDF[", "MR"],
 StyleBox["dist", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["x", "TI"],
 StyleBox["]", "MR"],
 " gives the cumulative distribution. ",
 StyleBox["Domain[", "MR"],
 StyleBox["dist", "TI"],
 StyleBox["]", "MR"],
 " gives the domain of ",
 StyleBox["PDF[", "MR"],
 StyleBox["dist", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["x", "TI"],
 StyleBox["]", "MR"],
 " and ",
 StyleBox["CDF[", "MR"],
 StyleBox["dist", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["x", "TI"],
 StyleBox["]", "MR"],
 ". "
}], "Text",
 CellTags->{"S5.97.1", "1.16"}],

Cell[TextData[{
 "The quantile ",
 StyleBox["Quantile[", "MR"],
 StyleBox["dist", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["q", "TI"],
 StyleBox["]", "MR"],
 " is effectively the inverse of the cdf. It gives the value of ",
 Cell[BoxData[
  FormBox[
   StyleBox["x",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " at which ",
 StyleBox["CDF[", "MR"],
 StyleBox["dist", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["x", "TI"],
 StyleBox["]", "MR"],
 " reaches ",
 Cell[BoxData[
  FormBox[
   StyleBox["q",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". The median is given by ",
 StyleBox["Quantile[", "MR"],
 StyleBox["dist", "TI"],
 StyleBox[", 1/2]", "MR"],
 "; quartiles, deciles and percentiles can also be expressed as quantiles. \
Quantiles are used in constructing confidence intervals for statistical \
parameters. "
}], "Text",
 CellTags->{"S5.97.1", "1.17"}],

Cell[TextData[{
 "The mean ",
 StyleBox["Mean[", "MR"],
 StyleBox["dist", "TI"],
 StyleBox["]", "MR"],
 " is the expectation of the random variable distributed according to ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"d", "i", "s", "t"}],
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and is usually denoted by ",
 Cell[BoxData[
  FormBox["\[Mu]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". The mean is given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Integral]", 
    StyleBox["x",
     "TI"], 
    StyleBox["f",
     "TI"], 
    RowBox[{"(", 
     StyleBox["x",
      "TI"], ")"}], "\[DifferentialD]", 
    StyleBox["x",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", where ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["f",
     "TI"], 
    RowBox[{"(", 
     StyleBox["x",
      "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is the pdf of the distribution. The variance ",
 StyleBox["Variance[", "MR"],
 StyleBox["dist", "TI"],
 StyleBox["]", "MR"],
 " is given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Integral]", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       StyleBox["x",
        "TI"], "-", "\[Mu]"}], ")"}], "2"], 
    StyleBox["f",
     "TI"], 
    RowBox[{"(", 
     StyleBox["x",
      "TI"], ")"}], "\[DifferentialD]", 
    StyleBox["x",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". The square root of the variance is called the standard deviation, and is \
usually denoted by ",
 Cell[BoxData[
  FormBox["\[Sigma]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "Text",
 CellTags->{"S5.97.1", "1.18"}],

Cell[TextData[{
 "The ",
 StyleBox["Skewness[", "MR"],
 StyleBox["dist", "TI"],
 StyleBox["]", "MR"],
 " and ",
 StyleBox["Kurtosis[", "MR"],
 StyleBox["dist", "TI"],
 StyleBox["]", "MR"],
 " functions give shape statistics summarizing the asymmetry and the \
peakedness of a distribution, respectively. Skewness is given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["1", 
     SuperscriptBox["\[Sigma]", "3"]], "\[Integral]", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       StyleBox["x",
        "TI"], "-", "\[Mu]"}], ")"}], "3"], 
    StyleBox["f",
     "TI"], 
    RowBox[{"(", 
     StyleBox["x",
      "TI"], ")"}], "\[DifferentialD]", 
    StyleBox["x",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and kurtosis is given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["1", 
     SuperscriptBox["\[Sigma]", "4"]], "\[Integral]", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       StyleBox["x",
        "TI"], "-", "\[Mu]"}], ")"}], "4"], 
    StyleBox["f",
     "TI"], 
    RowBox[{"(", 
     StyleBox["x",
      "TI"], ")"}], "\[DifferentialD]", 
    StyleBox["x",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "Text",
 CellTags->{"S5.97.1", "1.19"}],

Cell[TextData[{
 "The characteristic function ",
 StyleBox["CharacteristicFunction[", "MR"],
 StyleBox["dist", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["t", "TI"],
 StyleBox["]", "MR"],
 " is given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Phi]", 
    RowBox[{"(", 
     StyleBox["t",
      "TI"], ")"}], "=", "\[Integral]", 
    StyleBox["f",
     "TI"], 
    RowBox[{"(", 
     StyleBox["x",
      "TI"], ")"}], "exp", 
    RowBox[{"(", 
     StyleBox[
      RowBox[{"i", "t", "x"}],
      "TI"], ")"}], "\[DifferentialD]", 
    StyleBox["x",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". In the discrete case, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Phi]", 
    RowBox[{"(", 
     StyleBox["t",
      "TI"], ")"}], "=", "\[Sum]", 
    StyleBox["f",
     "TI"], 
    RowBox[{"(", 
     StyleBox["x",
      "TI"], ")"}], "exp", 
    RowBox[{"(", 
     StyleBox[
      RowBox[{"i", "t", "x"}],
      "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". Each distribution has a unique characteristic function, which is \
sometimes used instead of the pdf to define a distribution. "
}], "Text",
 CellTags->{"S5.97.1", "1.20"}],

Cell[TextData[{
 StyleBox["Random[", "MR"],
 StyleBox["dist", "TI"],
 StyleBox["]", "MR"],
 " gives pseudorandom numbers from the specified distribution. It can be used \
with a seed like other built\[Hyphen]in forms of ",
 StyleBox["Random", "MR"],
 ", as described in the section on pseudorandom numbers in ",
 StyleBox["The Mathematica Book", "TI"],
 ". "
}], "Text",
 CellTags->{"S5.97.1", "1.21"}],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.97.1", "1.22"}],

Cell["<<Statistics`ContinuousDistributions`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.97.1"],

Cell[TextData[{
 "This gives a symbolic representation of the gamma distribution with ",
 Cell[BoxData[
  FormBox["3", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " as the shape parameter and ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " as the scale parameter. "
}], "MathCaption",
 CellTags->{"S5.97.1", "1.23"}],

Cell[CellGroupData[{

Cell["gdist = GammaDistribution[3, 1]", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.97.1"],

Cell[BoxData[
 RowBox[{"GammaDistribution", "[", 
  RowBox[{"3", ",", "1"}], "]"}]], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.97.1"]
}, Open  ]],

Cell[TextData[{
 "Here is the cumulative distribution function evaluated at ",
 Cell[BoxData[
  FormBox["10", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.97.1", "1.24"}],

Cell[CellGroupData[{

Cell["CDF[gdist, 10]", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.97.1"],

Cell[BoxData[
 RowBox[{"GammaRegularized", "[", 
  RowBox[{"3", ",", "0", ",", "10"}], "]"}]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.97.1"]
}, Open  ]],

Cell[TextData[{
 "This is the cumulative distribution function. It is given in terms of the \
built\[Hyphen]in function ",
 StyleBox["GammaRegularized", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.97.1", "1.25"}],

Cell[CellGroupData[{

Cell["cdfunction = CDF[gdist, x]", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.97.1"],

Cell[BoxData[
 RowBox[{"GammaRegularized", "[", 
  RowBox[{"3", ",", "0", ",", "x"}], "]"}]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.97.1"]
}, Open  ]],

Cell["Here is a plot of the cumulative distribution function. ", "MathCaption",
 CellTags->{"S5.97.1", "1.26"}],

Cell[CellGroupData[{

Cell["Plot[cdfunction, {x, 0, 10}]", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.97.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0952381 0.0147151 0.590238 [
[.21429 .00222 -3 -9 ]
[.21429 .00222 3 0 ]
[.40476 .00222 -3 -9 ]
[.40476 .00222 3 0 ]
[.59524 .00222 -3 -9 ]
[.59524 .00222 3 0 ]
[.78571 .00222 -3 -9 ]
[.78571 .00222 3 0 ]
[.97619 .00222 -6 -9 ]
[.97619 .00222 6 0 ]
[.01131 .13276 -18 -4.5 ]
[.01131 .13276 0 4.5 ]
[.01131 .25081 -18 -4.5 ]
[.01131 .25081 0 4.5 ]
[.01131 .36886 -18 -4.5 ]
[.01131 .36886 0 4.5 ]
[.01131 .48691 -18 -4.5 ]
[.01131 .48691 0 4.5 ]
[.01131 .60495 -6 -4.5 ]
[.01131 .60495 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .01472 m
.21429 .02097 L
s
[(2)] .21429 .00222 0 1 Mshowa
.40476 .01472 m
.40476 .02097 L
s
[(4)] .40476 .00222 0 1 Mshowa
.59524 .01472 m
.59524 .02097 L
s
[(6)] .59524 .00222 0 1 Mshowa
.78571 .01472 m
.78571 .02097 L
s
[(8)] .78571 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(10)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.2619 .01472 m
.2619 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.5 .01472 m
.5 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.7381 .01472 m
.7381 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .13276 m
.03006 .13276 L
s
[(0.2)] .01131 .13276 1 0 Mshowa
.02381 .25081 m
.03006 .25081 L
s
[(0.4)] .01131 .25081 1 0 Mshowa
.02381 .36886 m
.03006 .36886 L
s
[(0.6)] .01131 .36886 1 0 Mshowa
.02381 .48691 m
.03006 .48691 L
s
[(0.8)] .01131 .48691 1 0 Mshowa
.02381 .60495 m
.03006 .60495 L
s
[(1)] .01131 .60495 1 0 Mshowa
.125 Mabswid
.02381 .04423 m
.02756 .04423 L
s
.02381 .07374 m
.02756 .07374 L
s
.02381 .10325 m
.02756 .10325 L
s
.02381 .16227 m
.02756 .16227 L
s
.02381 .19179 m
.02756 .19179 L
s
.02381 .2213 m
.02756 .2213 L
s
.02381 .28032 m
.02756 .28032 L
s
.02381 .30983 m
.02756 .30983 L
s
.02381 .33935 m
.02756 .33935 L
s
.02381 .39837 m
.02756 .39837 L
s
.02381 .42788 m
.02756 .42788 L
s
.02381 .45739 m
.02756 .45739 L
s
.02381 .51642 m
.02756 .51642 L
s
.02381 .54593 m
.02756 .54593 L
s
.02381 .57544 m
.02756 .57544 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .01472 m
.02499 .01472 L
.02605 .01472 L
.02729 .01472 L
.02846 .01473 L
.02954 .01474 L
.03053 .01475 L
.03163 .01477 L
.03279 .01479 L
.03395 .01482 L
.0352 .01487 L
.03746 .01498 L
.04016 .01515 L
.04262 .01537 L
.04748 .01597 L
.05023 .01642 L
.05278 .01692 L
.06244 .01958 L
.06795 .02166 L
.07314 .02403 L
.08284 .02954 L
.10458 .04693 L
.12466 .06869 L
.14313 .09273 L
.18262 .15296 L
.22059 .21612 L
.26101 .28256 L
.29992 .34162 L
.34128 .39675 L
.38113 .4416 L
.41946 .47725 L
.46024 .50786 L
.49951 .53112 L
.53726 .54868 L
.57746 .56314 L
.61615 .57375 L
.65729 .58225 L
.69691 .58833 L
.73502 .5927 L
.77558 .59613 L
.81463 .59855 L
.85612 .60042 L
.89611 .60172 L
.93457 .60262 L
.97549 .60331 L
.97619 .60332 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.97.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S5.97.1"]
}, Open  ]],

Cell["\<\
This is a pseudorandom array with elements distributed according to the gamma \
distribution. \
\>", "MathCaption",
 CellTags->{"S5.97.1", "1.27"}],

Cell[CellGroupData[{

Cell["RandomArray[gdist, 5]", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.97.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "3.128098565186732`", ",", "2.4308253020039468`", ",", 
   "1.9998558767648924`", ",", "5.315229000949548`", ",", 
   "5.204054374664439`"}], "}"}]], "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S5.97.1"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.97.1"->{
    Cell[1776, 53, 150, 6, 40, "Subsection",
      CellTags->{"S5.97.1", "1.1"}],
    Cell[1929, 61, 925, 26, 93, "Text",
      CellTags->{"S5.97.1", "1.2"}],
    Cell[2857, 89, 964, 25, 110, "Text",
      CellTags->{"S5.97.1", "1.3"}],
    Cell[3824, 116, 6503, 194, 150, "DefinitionBox",
      CellTags->"S5.97.1"],
    Cell[10330, 312, 100, 1, 17, "Caption",
      CellTags->"S5.97.1"],
    Cell[10433, 315, 19432, 579, 580, "DefinitionBox",
      CellTags->"S5.97.1"],
    Cell[29868, 896, 79, 1, 17, "Caption",
      CellTags->"S5.97.1"],
    Cell[29950, 899, 1732, 62, 93, "Text",
      CellTags->{"S5.97.1", "1.4"}],
    Cell[31685, 963, 941, 29, 110, "Text",
      CellTags->{"S5.97.1", "1.5"}],
    Cell[32629, 994, 1509, 49, 93, "Text",
      CellTags->{"S5.97.1", "1.6"}],
    Cell[34141, 1045, 1246, 44, 76, "Text",
      CellTags->{"S5.97.1", "1.7"}],
    Cell[35390, 1091, 1325, 49, 68, "Text",
      CellTags->{"S5.97.1", "1.8"}],
    Cell[36718, 1142, 1246, 33, 161, "Text",
      CellTags->{"S5.97.1", "1.9"}],
    Cell[37967, 1177, 672, 21, 76, "Text",
      CellTags->{"S5.97.1", "1.10"}],
    Cell[38642, 1200, 468, 17, 42, "Text",
      CellTags->{"S5.97.1", "1.11"}],
    Cell[39113, 1219, 6286, 186, 166, "DefinitionBox",
      CellTags->"S5.97.1"],
    Cell[45402, 1407, 85, 1, 17, "Caption",
      CellTags->"S5.97.1"],
    Cell[45490, 1410, 204, 6, 42, "Text",
      CellTags->{"S5.97.1", "1.12"}],
    Cell[45697, 1418, 1322, 39, 94, "Text",
      CellTags->{"S5.97.1", "1.13"}],
    Cell[47022, 1459, 1585, 57, 83, "Text",
      CellTags->{"S5.97.1", "1.14"}],
    Cell[48610, 1518, 1320, 44, 76, "Text",
      CellTags->{"S5.97.1", "1.15"}],
    Cell[49933, 1564, 14618, 451, 430, "DefinitionBox",
      CellTags->"S5.97.1"],
    Cell[64554, 2017, 81, 1, 17, "Caption",
      CellTags->"S5.97.1"],
    Cell[64638, 2020, 1718, 62, 110, "Text",
      CellTags->{"S5.97.1", "1.16"}],
    Cell[66359, 2084, 961, 33, 76, "Text",
      CellTags->{"S5.97.1", "1.17"}],
    Cell[67323, 2119, 1859, 68, 76, "Text",
      CellTags->{"S5.97.1", "1.18"}],
    Cell[69185, 2189, 1324, 50, 63, "Text",
      CellTags->{"S5.97.1", "1.19"}],
    Cell[70512, 2241, 1234, 46, 59, "Text",
      CellTags->{"S5.97.1", "1.20"}],
    Cell[71749, 2289, 402, 11, 59, "Text",
      CellTags->{"S5.97.1", "1.21"}],
    Cell[72154, 2302, 79, 1, 41, "MathCaption",
      CellTags->{"S5.97.1", "1.22"}],
    Cell[72236, 2305, 100, 2, 70, "Input",
      CellTags->"S5.97.1"],
    Cell[72339, 2309, 425, 11, 70, "MathCaption",
      CellTags->{"S5.97.1", "1.23"}],
    Cell[72789, 2324, 94, 2, 70, "Input",
      CellTags->"S5.97.1"],
    Cell[72886, 2328, 140, 4, 70, "Output",
      CellTags->"S5.97.1"],
    Cell[73041, 2335, 248, 7, 70, "MathCaption",
      CellTags->{"S5.97.1", "1.24"}],
    Cell[73314, 2346, 77, 2, 70, "Input",
      CellTags->"S5.97.1"],
    Cell[73394, 2350, 150, 4, 70, "Output",
      CellTags->"S5.97.1"],
    Cell[73559, 2357, 216, 6, 70, "MathCaption",
      CellTags->{"S5.97.1", "1.25"}],
    Cell[73800, 2367, 89, 2, 70, "Input",
      CellTags->"S5.97.1"],
    Cell[73892, 2371, 149, 4, 70, "Output",
      CellTags->"S5.97.1"],
    Cell[74056, 2378, 111, 1, 70, "MathCaption",
      CellTags->{"S5.97.1", "1.26"}],
    Cell[74192, 2383, 91, 2, 70, "Input",
      CellTags->"S5.97.1"],
    Cell[74286, 2387, 3678, 250, 70, 3607, 247, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.97.1"],
    Cell[77967, 2639, 180, 6, 70, "Output",
      CellTags->"S5.97.1"],
    Cell[78162, 2648, 157, 4, 70, "MathCaption",
      CellTags->{"S5.97.1", "1.27"}],
    Cell[78344, 2656, 84, 2, 70, "Input",
      CellTags->"S5.97.1"],
    Cell[78431, 2660, 247, 7, 70, "Output",
      CellTags->"S5.97.1"]},
  "1.1"->{
    Cell[1776, 53, 150, 6, 40, "Subsection",
      CellTags->{"S5.97.1", "1.1"}]},
  "1.2"->{
    Cell[1929, 61, 925, 26, 93, "Text",
      CellTags->{"S5.97.1", "1.2"}]},
  "1.3"->{
    Cell[2857, 89, 964, 25, 110, "Text",
      CellTags->{"S5.97.1", "1.3"}]},
  "1.4"->{
    Cell[29950, 899, 1732, 62, 93, "Text",
      CellTags->{"S5.97.1", "1.4"}]},
  "1.5"->{
    Cell[31685, 963, 941, 29, 110, "Text",
      CellTags->{"S5.97.1", "1.5"}]},
  "1.6"->{
    Cell[32629, 994, 1509, 49, 93, "Text",
      CellTags->{"S5.97.1", "1.6"}]},
  "1.7"->{
    Cell[34141, 1045, 1246, 44, 76, "Text",
      CellTags->{"S5.97.1", "1.7"}]},
  "1.8"->{
    Cell[35390, 1091, 1325, 49, 68, "Text",
      CellTags->{"S5.97.1", "1.8"}]},
  "1.9"->{
    Cell[36718, 1142, 1246, 33, 161, "Text",
      CellTags->{"S5.97.1", "1.9"}]},
  "1.10"->{
    Cell[37967, 1177, 672, 21, 76, "Text",
      CellTags->{"S5.97.1", "1.10"}]},
  "1.11"->{
    Cell[38642, 1200, 468, 17, 42, "Text",
      CellTags->{"S5.97.1", "1.11"}]},
  "1.12"->{
    Cell[45490, 1410, 204, 6, 42, "Text",
      CellTags->{"S5.97.1", "1.12"}]},
  "1.13"->{
    Cell[45697, 1418, 1322, 39, 94, "Text",
      CellTags->{"S5.97.1", "1.13"}]},
  "1.14"->{
    Cell[47022, 1459, 1585, 57, 83, "Text",
      CellTags->{"S5.97.1", "1.14"}]},
  "1.15"->{
    Cell[48610, 1518, 1320, 44, 76, "Text",
      CellTags->{"S5.97.1", "1.15"}]},
  "1.16"->{
    Cell[64638, 2020, 1718, 62, 110, "Text",
      CellTags->{"S5.97.1", "1.16"}]},
  "1.17"->{
    Cell[66359, 2084, 961, 33, 76, "Text",
      CellTags->{"S5.97.1", "1.17"}]},
  "1.18"->{
    Cell[67323, 2119, 1859, 68, 76, "Text",
      CellTags->{"S5.97.1", "1.18"}]},
  "1.19"->{
    Cell[69185, 2189, 1324, 50, 63, "Text",
      CellTags->{"S5.97.1", "1.19"}]},
  "1.20"->{
    Cell[70512, 2241, 1234, 46, 59, "Text",
      CellTags->{"S5.97.1", "1.20"}]},
  "1.21"->{
    Cell[71749, 2289, 402, 11, 59, "Text",
      CellTags->{"S5.97.1", "1.21"}]},
  "1.22"->{
    Cell[72154, 2302, 79, 1, 41, "MathCaption",
      CellTags->{"S5.97.1", "1.22"}]},
  "1.23"->{
    Cell[72339, 2309, 425, 11, 70, "MathCaption",
      CellTags->{"S5.97.1", "1.23"}]},
  "1.24"->{
    Cell[73041, 2335, 248, 7, 70, "MathCaption",
      CellTags->{"S5.97.1", "1.24"}]},
  "1.25"->{
    Cell[73559, 2357, 216, 6, 70, "MathCaption",
      CellTags->{"S5.97.1", "1.25"}]},
  "1.26"->{
    Cell[74056, 2378, 111, 1, 70, "MathCaption",
      CellTags->{"S5.97.1", "1.26"}]},
  "1.27"->{
    Cell[78162, 2648, 157, 4, 70, "MathCaption",
      CellTags->{"S5.97.1", "1.27"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.97.1", 79335, 2687},
  {"1.1", 83121, 2784},
  {"1.2", 83215, 2787},
  {"1.3", 83304, 2790},
  {"1.4", 83394, 2793},
  {"1.5", 83486, 2796},
  {"1.6", 83578, 2799},
  {"1.7", 83670, 2802},
  {"1.8", 83763, 2805},
  {"1.9", 83856, 2808},
  {"1.10", 83951, 2811},
  {"1.11", 84045, 2814},
  {"1.12", 84139, 2817},
  {"1.13", 84232, 2820},
  {"1.14", 84327, 2823},
  {"1.15", 84422, 2826},
  {"1.16", 84517, 2829},
  {"1.17", 84613, 2832},
  {"1.18", 84707, 2835},
  {"1.19", 84802, 2838},
  {"1.20", 84897, 2841},
  {"1.21", 84992, 2844},
  {"1.22", 85086, 2847},
  {"1.23", 85185, 2850},
  {"1.24", 85286, 2853},
  {"1.25", 85386, 2856},
  {"1.26", 85486, 2859},
  {"1.27", 85586, 2862}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 150, 6, 40, "Subsection",
  CellTags->{"S5.97.1", "1.1"}],
Cell[1929, 61, 925, 26, 93, "Text",
  CellTags->{"S5.97.1", "1.2"}],
Cell[2857, 89, 964, 25, 110, "Text",
  CellTags->{"S5.97.1", "1.3"}],
Cell[3824, 116, 6503, 194, 150, "DefinitionBox",
  CellTags->"S5.97.1"],
Cell[10330, 312, 100, 1, 17, "Caption",
  CellTags->"S5.97.1"],
Cell[10433, 315, 19432, 579, 580, "DefinitionBox",
  CellTags->"S5.97.1"],
Cell[29868, 896, 79, 1, 17, "Caption",
  CellTags->"S5.97.1"],
Cell[29950, 899, 1732, 62, 93, "Text",
  CellTags->{"S5.97.1", "1.4"}],
Cell[31685, 963, 941, 29, 110, "Text",
  CellTags->{"S5.97.1", "1.5"}],
Cell[32629, 994, 1509, 49, 93, "Text",
  CellTags->{"S5.97.1", "1.6"}],
Cell[34141, 1045, 1246, 44, 76, "Text",
  CellTags->{"S5.97.1", "1.7"}],
Cell[35390, 1091, 1325, 49, 68, "Text",
  CellTags->{"S5.97.1", "1.8"}],
Cell[36718, 1142, 1246, 33, 161, "Text",
  CellTags->{"S5.97.1", "1.9"}],
Cell[37967, 1177, 672, 21, 76, "Text",
  CellTags->{"S5.97.1", "1.10"}],
Cell[38642, 1200, 468, 17, 42, "Text",
  CellTags->{"S5.97.1", "1.11"}],
Cell[39113, 1219, 6286, 186, 166, "DefinitionBox",
  CellTags->"S5.97.1"],
Cell[45402, 1407, 85, 1, 17, "Caption",
  CellTags->"S5.97.1"],
Cell[45490, 1410, 204, 6, 42, "Text",
  CellTags->{"S5.97.1", "1.12"}],
Cell[45697, 1418, 1322, 39, 94, "Text",
  CellTags->{"S5.97.1", "1.13"}],
Cell[47022, 1459, 1585, 57, 83, "Text",
  CellTags->{"S5.97.1", "1.14"}],
Cell[48610, 1518, 1320, 44, 76, "Text",
  CellTags->{"S5.97.1", "1.15"}],
Cell[49933, 1564, 14618, 451, 430, "DefinitionBox",
  CellTags->"S5.97.1"],
Cell[64554, 2017, 81, 1, 17, "Caption",
  CellTags->"S5.97.1"],
Cell[64638, 2020, 1718, 62, 110, "Text",
  CellTags->{"S5.97.1", "1.16"}],
Cell[66359, 2084, 961, 33, 76, "Text",
  CellTags->{"S5.97.1", "1.17"}],
Cell[67323, 2119, 1859, 68, 76, "Text",
  CellTags->{"S5.97.1", "1.18"}],
Cell[69185, 2189, 1324, 50, 63, "Text",
  CellTags->{"S5.97.1", "1.19"}],
Cell[70512, 2241, 1234, 46, 59, "Text",
  CellTags->{"S5.97.1", "1.20"}],
Cell[71749, 2289, 402, 11, 59, "Text",
  CellTags->{"S5.97.1", "1.21"}],
Cell[72154, 2302, 79, 1, 41, "MathCaption",
  CellTags->{"S5.97.1", "1.22"}],
Cell[72236, 2305, 100, 2, 70, "Input",
  CellTags->"S5.97.1"],
Cell[72339, 2309, 425, 11, 70, "MathCaption",
  CellTags->{"S5.97.1", "1.23"}],

Cell[CellGroupData[{
Cell[72789, 2324, 94, 2, 70, "Input",
  CellTags->"S5.97.1"],
Cell[72886, 2328, 140, 4, 70, "Output",
  CellTags->"S5.97.1"]
}, Open  ]],
Cell[73041, 2335, 248, 7, 70, "MathCaption",
  CellTags->{"S5.97.1", "1.24"}],

Cell[CellGroupData[{
Cell[73314, 2346, 77, 2, 70, "Input",
  CellTags->"S5.97.1"],
Cell[73394, 2350, 150, 4, 70, "Output",
  CellTags->"S5.97.1"]
}, Open  ]],
Cell[73559, 2357, 216, 6, 70, "MathCaption",
  CellTags->{"S5.97.1", "1.25"}],

Cell[CellGroupData[{
Cell[73800, 2367, 89, 2, 70, "Input",
  CellTags->"S5.97.1"],
Cell[73892, 2371, 149, 4, 70, "Output",
  CellTags->"S5.97.1"]
}, Open  ]],
Cell[74056, 2378, 111, 1, 70, "MathCaption",
  CellTags->{"S5.97.1", "1.26"}],

Cell[CellGroupData[{
Cell[74192, 2383, 91, 2, 70, "Input",
  CellTags->"S5.97.1"],
Cell[74286, 2387, 3678, 250, 70, 3607, 247, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.97.1"],
Cell[77967, 2639, 180, 6, 70, "Output",
  CellTags->"S5.97.1"]
}, Open  ]],
Cell[78162, 2648, 157, 4, 70, "MathCaption",
  CellTags->{"S5.97.1", "1.27"}],

Cell[CellGroupData[{
Cell[78344, 2656, 84, 2, 70, "Input",
  CellTags->"S5.97.1"],
Cell[78431, 2660, 247, 7, 70, "Output",
  CellTags->"S5.97.1"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

