(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    130800,       6877]*)
(*NotebookOutlinePosition[    134853,       6998]*)
(*  CellTagsIndexPosition[    134553,       6983]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  "Graphics",
  StyleBox["`", "MB"],
  "ContourPlot3D",
  StyleBox["`", "MB"]
}], "Subsection",
  CellTags->{"S5.30.1", "1.1"}],

Cell[TextData[{
  "You can create standard two\[Hyphen]dimensional contour plots using the \
built\[Hyphen]in functions ",
  StyleBox["ContourPlot", "MR"],
  " and ",
  StyleBox["ListContourPlot", "MR"],
  ". ",
  StyleBox["ContourPlot3D", "MR"],
  " is the three\[Hyphen]dimensional analog of ",
  StyleBox["ContourPlot", "MR"],
  ". ",
  StyleBox["ContourPlot[", "MR"],
  StyleBox["f", "TI"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`{\)], "InlineFormula"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["xmin", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["xmax", "TI"],
  Cell[BoxData[
      \(TraditionalForm\`}\)], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`{\)], "InlineFormula"],
  StyleBox["y", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["ymin", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["ymax", "TI"],
  Cell[BoxData[
      \(TraditionalForm\`}\)], "InlineFormula"],
  StyleBox["]", "MR"],
  " will plot lines showing particular values of ",
  Cell[BoxData[
      FormBox[
        StyleBox["f",
          "TI"], TraditionalForm]], "InlineFormula"],
  " as a function of ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  " and ",
  Cell[BoxData[
      FormBox[
        StyleBox["y",
          "TI"], TraditionalForm]], "InlineFormula"],
  ". Similarly, ",
  StyleBox["ContourPlot3D[", "MR"],
  StyleBox["f", "TI"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`{\)], "InlineFormula"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["xmin", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["xmax", "TI"],
  Cell[BoxData[
      \(TraditionalForm\`}\)], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`{\)], "InlineFormula"],
  StyleBox["y", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["ymin", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["ymax", "TI"],
  Cell[BoxData[
      \(TraditionalForm\`}\)], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`{\)], "InlineFormula"],
  StyleBox["z", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["zmin", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["zmax", "TI"],
  Cell[BoxData[
      \(TraditionalForm\`}\)], "InlineFormula"],
  StyleBox["]", "MR"],
  " will plot surfaces showing particular values of ",
  Cell[BoxData[
      FormBox[
        StyleBox["f",
          "TI"], TraditionalForm]], "InlineFormula"],
  " as a function of ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  ", ",
  Cell[BoxData[
      FormBox[
        StyleBox["y",
          "TI"], TraditionalForm]], "InlineFormula"],
  ", and ",
  Cell[BoxData[
      FormBox[
        StyleBox["z",
          "TI"], TraditionalForm]], "InlineFormula"],
  ". ",
  StyleBox["ContourPlot3D", "MR"],
  " works by dividing the three\[Hyphen]dimensional space into cubes and \
deciding if the surface intersects each cube. If the surface does intersect a \
cube, ",
  StyleBox["ContourPlot3D", "MR"],
  " will subdivide this cube further, and so on. "
}], "Text",
  CellTags->{"S5.30.1", "1.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"ContourPlot3D[\"\>",
                      "MR"], 
                    StyleBox["\<\"f\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], 
                    StyleBox["\<\"x\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"xmin\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"xmax\"\>",
                      "TI"], Cell[BoxData[
                        \(TraditionalForm\`}\)], "InlineFormula"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], 
                    StyleBox["\<\"y\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"ymin\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"ymax\"\>",
                      "TI"], Cell[BoxData[
                        \(TraditionalForm\`}\)], "InlineFormula"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], 
                    StyleBox["\<\"z\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"zmin\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"zmax\"\>",
                      "TI"], Cell[BoxData[
                        \(TraditionalForm\`}\)], "InlineFormula"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  
                  RowBox[{"\<\"generate a three\[Hyphen]dimensional contour \
plot of \"\>", 
                    StyleBox["\<\"f\"\>",
                      "TI"], "\<\" as a function of \"\>", 
                    StyleBox["\<\"x\"\>",
                      "TI"], \(\(,\)\(\ \)\), 
                    StyleBox["\<\"y\"\>",
                      "TI"], \(\(,\)\(\ \)\(and\)\(\ \)\), 
                    StyleBox["\<\"z\"\>",
                      "TI"]}], TraditionalForm]]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"ListContourPlot3D[\"\>",
                      "MR"], Cell[BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], Cell[
                    BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], Cell[
                    BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], Cell[
                    BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"f\"\>",
                              "TI"], "\<\"111\"\>"], TraditionalForm]], 
                      "InlineFormula"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"f\"\>",
                              "TI"], "\<\"112\"\>"], TraditionalForm]], 
                      "InlineFormula"], 
                    StyleBox[",",
                      "MR"], "\<\" \[Ellipsis] \"\>", Cell[BoxData[
                        \(TraditionalForm\`}\)], "InlineFormula"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], Cell[
                    BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"f\"\>",
                              "TI"], "\<\"121\"\>"], TraditionalForm]], 
                      "InlineFormula"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"f\"\>",
                              "TI"], "\<\"122\"\>"], TraditionalForm]], 
                      "InlineFormula"], 
                    StyleBox[",",
                      "MR"], "\<\" \[Ellipsis] \"\>", Cell[BoxData[
                        \(TraditionalForm\`}\)], "InlineFormula"], 
                    StyleBox[",",
                      "MR"], "\<\" \[Ellipsis] \"\>", Cell[BoxData[
                        \(TraditionalForm\`}\)], "InlineFormula"], 
                    StyleBox[",",
                      "MR"], "\<\" \[Ellipsis] \"\>", Cell[BoxData[
                        \(TraditionalForm\`}\)], "InlineFormula"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  
                  RowBox[{"\<\"generate a three\[Hyphen]dimensional contour \
plot from the three\[Hyphen]dimensional array of values \"\>", Cell[BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"f\"\>",
                              "TI"], 
                            StyleBox["\<\"zyx\"\>",
                              "TI"]], TraditionalForm]], "InlineFormula"]}], 
                  TraditionalForm]]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S5.30.1"],

Cell["\<\
Making three\[Hyphen]dimensional contour plots. \
\>", "Caption",
  CellTags->"S5.30.1"],

Cell["This loads the package. ", "MathCaption",
  CellTags->{"S5.30.1", "1.3"}],

Cell["<<Graphics`ContourPlot3D`", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S5.30.1"],

Cell["\<\
This produces a three\[Hyphen]dimensional plot of the zero values \
of the function. \
\>", "MathCaption",
  CellTags->{"S5.30.1", "1.4"}],

Cell[CellGroupData[{

Cell["\<\
ContourPlot3D[Cos[Sqrt[ x^2 + y^2 + z^2 ]],
 {x,-2,2}, {y,0,2}, {z,-2,2}]\
\>", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S5.30.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.1015 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0651648 1.12549 9.21572e-18 1.12549 [
[ 0 0 0 0 ]
[ 1 1.1015 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.07961 .26916 m
0 .93177 L
s
0 .93177 m
.24118 1.1015 L
s
.24118 1.1015 m
.27861 .47209 L
s
.27861 .47209 m
.07961 .26916 L
s
.76539 0 m
.91896 .25023 L
s
.91896 .25023 m
1 .91564 L
s
1 .91564 m
.82361 .69772 L
s
.82361 .69772 m
.76539 0 L
s
.07961 .26916 m
0 .93177 L
s
0 .93177 m
.82361 .69772 L
s
.82361 .69772 m
.76539 0 L
s
.76539 0 m
.07961 .26916 L
s
.27861 .47209 m
.91896 .25023 L
s
.91896 .25023 m
1 .91564 L
s
1 .91564 m
.24118 1.1015 L
s
.24118 1.1015 m
.27861 .47209 L
s
0 0 m
1 0 L
1 1.1015 L
0 1.1015 L
closepath
clip
newpath
.5 Mabswid
.66 .534 .7 r
.44792 .5067 m .4318 .44873 L .54386 .42846 L p F P
0 g
s
.667 .573 .74 r
.52104 .36568 m .54386 .42846 L .4318 .44873 L p F P
0 g
s
.667 .573 .74 r
.4318 .44873 m .42091 .4191 L .52104 .36568 L p F P
0 g
s
.724 .57 .68 r
.4318 .44873 m .44792 .5067 L .39157 .57587 L p F P
0 g
s
.724 .57 .68 r
.39037 .44659 m .4318 .44873 L p .39157 .57587 L F P
0 g
s
.719 .6 .723 r
.4318 .44873 m .42091 .4191 L .39037 .44659 L closepath p F P
0 g
s
.724 .57 .68 r
.32 .5322 m .39037 .44659 L p .39157 .57587 L F P
0 g
s
.741 .599 .698 r
.39037 .44659 m .32 .5322 L .29267 .4494 L p F P
0 g
s
.741 .599 .698 r
.29267 .4494 m .3048 .43477 L .39037 .44659 L p F P
0 g
s
.735 .629 .741 r
.39325 .35519 m .3048 .43477 L .39037 .44659 L p F P
0 g
s
.735 .629 .741 r
.39037 .44659 m .42091 .4191 L .39325 .35519 L p F P
0 g
s
.678 .606 .768 r
.52104 .36568 m .42091 .4191 L .39325 .35519 L p F P
0 g
s
.648 .51 .681 r
.46415 .57589 m .44792 .5067 L .54828 .44416 L p F P
0 g
s
.66 .534 .7 r
.54386 .42846 m .54828 .44416 L .44792 .5067 L p F P
0 g
s
.706 .547 .67 r
.46415 .57589 m .44792 .5067 L .39157 .57587 L closepath p F P
0 g
s
.765 .636 .718 r
.29267 .4494 m .3048 .43477 L .28426 .42942 L closepath p F P
0 g
s
.755 .656 .752 r
.36488 .3011 m .39325 .35519 L .3048 .43477 L p F P
0 g
s
.755 .656 .752 r
.2638 .38973 m .36488 .3011 L p .3048 .43477 L F P
0 g
s
.755 .656 .752 r
.3048 .43477 m .28426 .42942 L .2638 .38973 L p F P
0 g
s
.627 .437 .605 r
.46415 .57589 m .57495 .55402 L p .48748 .67801 L F P
0 g
s
.627 .437 .605 r
.48748 .67801 m .4732 .68069 L .46415 .57589 L p F P
0 g
s
.648 .51 .681 r
.54828 .44416 m .57495 .55402 L .46415 .57589 L p F P
0 g
s
.7 .491 .601 r
.39157 .57587 m .46415 .57589 L .4732 .68069 L p F P
0 g
s
.7 .491 .601 r
.4732 .68069 m .35643 .68067 L .39157 .57587 L p F P
0 g
s
.722 .514 .608 r
.33062 .57228 m .39157 .57587 L .35643 .68067 L p F P
0 g
s
.724 .57 .68 r
.39157 .57587 m .33062 .57228 L .32 .5322 L p F P
0 g
s
.759 .59 .668 r
.33062 .57228 m .32 .5322 L .29973 .56661 L closepath p F P
0 g
s
.781 .619 .68 r
.29973 .56661 m .32 .5322 L .29267 .4494 L p F P
0 g
s
.678 .606 .768 r
.39325 .35519 m .49367 .30234 L .52104 .36568 L p F P
0 g
s
.69 .642 .797 r
.49367 .30234 m .39325 .35519 L .36488 .3011 L p F P
0 g
s
.781 .619 .68 r
.29267 .4494 m .23349 .54836 L .29973 .56661 L p F P
0 g
s
.805 .652 .694 r
.23349 .54836 m .29267 .4494 L .28426 .42942 L p F P
0 g
s
.722 .514 .608 r
.35643 .68067 m .33973 .67973 L .33062 .57228 L p F P
0 g
s
.763 .545 .602 r
.29973 .56661 m .33062 .57228 L .33973 .67973 L p F P
0 g
s
.805 .652 .694 r
.28426 .42942 m .24383 .41367 L p .23349 .54836 L F P
0 g
s
.785 .667 .734 r
.28426 .42942 m .2638 .38973 L .24383 .41367 L closepath p F P
0 g
s
.574 .482 .713 r
.54828 .44416 m .54386 .42846 L .63569 .37906 L p F P
0 g
s
.597 .534 .755 r
.62468 .34837 m .63569 .37906 L .54386 .42846 L p F P
0 g
s
.597 .534 .755 r
.54386 .42846 m .52104 .36568 L .62468 .34837 L p F P
0 g
s
.573 .462 .69 r
.57495 .55402 m .54828 .44416 L .65275 .43877 L p F P
0 g
s
.574 .482 .713 r
.63569 .37906 m .65275 .43877 L .54828 .44416 L p F P
0 g
s
.763 .545 .602 r
.33973 .67973 m .2737 .66823 L .29973 .56661 L p F P
0 g
s
.796 .577 .604 r
.23349 .54836 m .29973 .56661 L .2737 .66823 L p F P
0 g
s
.604 .564 .782 r
.62468 .34837 m .52104 .36568 L .49367 .30234 L p F P
0 g
s
.766 .699 .788 r
.36488 .3011 m .2638 .38973 L .23352 .34263 L p F P
0 g
s
.805 .701 .75 r
.24383 .41367 m .2638 .38973 L .23352 .34263 L p F P
0 g
s
.69 .642 .797 r
.36488 .3011 m .46586 .24812 L .49367 .30234 L p F P
0 g
s
.701 .678 .824 r
.46586 .24812 m .36488 .3011 L .33558 .25489 L p F P
0 g
s
.766 .699 .788 r
.23352 .34263 m .33558 .25489 L .36488 .3011 L p F P
0 g
s
.805 .652 .694 r
.24383 .41367 m .17799 .52568 L .23349 .54836 L p F P
0 g
s
.836 .689 .701 r
.19652 .38672 m .24383 .41367 L .17799 .52568 L p F P
0 g
s
.805 .701 .75 r
.23352 .34263 m .19652 .38672 L .24383 .41367 L p F P
0 g
s
.529 .365 .603 r
.57495 .55402 m .67053 .5099 L p .67136 .62241 L F P
0 g
s
.529 .365 .603 r
.67136 .62241 m .57636 .56725 L .57495 .55402 L p F P
0 g
s
.573 .462 .69 r
.65275 .43877 m .67053 .5099 L .57495 .55402 L p F P
0 g
s
.627 .437 .605 r
.57495 .55402 m .57636 .56725 L .48748 .67801 L p F P
0 g
s
.604 .564 .782 r
.49367 .30234 m .59734 .28195 L .62468 .34837 L p F P
0 g
s
.61 .602 .818 r
.59734 .28195 m .49367 .30234 L .46586 .24812 L p F P
0 g
s
.531 .364 .6 r
.58573 .65893 m .57636 .56725 L .67136 .62241 L closepath p F P
0 g
s
.624 .431 .602 r
.58573 .65893 m .57636 .56725 L .48748 .67801 L closepath p F P
0 g
s
.796 .577 .604 r
.2737 .66823 m .20756 .64994 L .23349 .54836 L p F P
0 g
s
.831 .613 .607 r
.17799 .52568 m .23349 .54836 L .20756 .64994 L p F P
0 g
s
.783 .736 .81 r
.33558 .25489 m .23352 .34263 L .20177 .304 L p F P
0 g
s
.826 .738 .767 r
.19652 .38672 m .23352 .34263 L .20177 .304 L p F P
0 g
s
.589 .325 .485 r
.46244 .77031 m .4732 .68069 L .48748 .67801 L p F P
0 g
s
.683 .409 .501 r
.35643 .68067 m .4732 .68069 L .46244 .77031 L p F P
0 g
s
.683 .409 .501 r
.46244 .77031 m .38612 .77029 L .35643 .68067 L p F P
0 g
s
.707 .422 .49 r
.33973 .67973 m .35643 .68067 L .38612 .77029 L p F P
0 g
s
.707 .422 .49 r
.38612 .77029 m .32203 .76688 L .33973 .67973 L p F P
0 g
s
.758 .473 .501 r
.2737 .66823 m .33973 .67973 L .32203 .76688 L p F P
0 g
s
.701 .678 .824 r
.46104 .24012 m .46586 .24812 L p .33558 .25489 L F P
0 g
s
.701 .678 .824 r
.33558 .25489 m .37342 .23479 L .46104 .24012 L p F P
0 g
s
.714 .72 .854 r
.37342 .23479 m .33558 .25489 L .30515 .21558 L p F P
0 g
s
.783 .736 .81 r
.20177 .304 m .30515 .21558 L .33558 .25489 L p F P
0 g
s
.61 .602 .818 r
.46586 .24812 m .5699 .2254 L .59734 .28195 L p F P
0 g
s
.614 .642 .854 r
.54206 .17673 m .5699 .2254 L .46586 .24812 L p F P
0 g
s
.614 .642 .854 r
.50235 .18587 m .54206 .17673 L p .46586 .24812 L F P
0 g
s
.614 .642 .854 r
.46586 .24812 m .46104 .24012 L .50235 .18587 L p F P
0 g
s
.587 .327 .489 r
.57992 .73773 m .48748 .67801 L .58573 .65893 L closepath p F P
0 g
s
.589 .325 .485 r
.48748 .67801 m .57992 .73773 L p .46244 .77031 L F P
0 g
s
.836 .689 .701 r
.17799 .52568 m .13131 .49896 L .19652 .38672 L p F P
0 g
s
.863 .728 .712 r
.15862 .35515 m .19652 .38672 L .13131 .49896 L p F P
0 g
s
.826 .738 .767 r
.20177 .304 m .15862 .35515 L .19652 .38672 L p F P
0 g
s
.618 .647 .857 r
.46104 .24012 m .43738 .20158 L .50235 .18587 L closepath p F P
0 g
s
.7 .681 .829 r
.46104 .24012 m .43738 .20158 L .37342 .23479 L closepath p F P
0 g
s
.831 .613 .607 r
.20756 .64994 m .15164 .62754 L .17799 .52568 L p F P
0 g
s
.865 .65 .61 r
.13131 .49896 m .17799 .52568 L .15164 .62754 L p F P
0 g
s
.714 .72 .854 r
.30515 .21558 m .31814 .2086 L .37342 .23479 L p F P
0 g
s
.711 .721 .857 r
.40802 .16135 m .31814 .2086 L .37342 .23479 L p F P
0 g
s
.711 .721 .857 r
.37342 .23479 m .43738 .20158 L .40802 .16135 L p F P
0 g
s
.451 .405 .716 r
.63569 .37906 m .6578 .3545 L p .71546 .47109 L F P
0 g
s
.451 .405 .716 r
.71546 .47109 m .65275 .43877 L .63569 .37906 L p F P
0 g
s
.507 .481 .763 r
.63569 .37906 m .62468 .34837 L .6578 .3545 L closepath p F P
0 g
s
.758 .473 .501 r
.32203 .76688 m .28952 .76149 L .2737 .66823 L p F P
0 g
s
.791 .5 .495 r
.20756 .64994 m .2737 .66823 L .28952 .76149 L p F P
0 g
s
.495 .502 .794 r
.6578 .3545 m .62468 .34837 L .59734 .28195 L p F P
0 g
s
.47 .396 .691 r
.67053 .5099 m .65275 .43877 L .71546 .47109 L closepath p F P
0 g
s
.461 .223 .465 r
.57992 .73773 m .67136 .62241 L .58573 .65893 L closepath p F P
0 g
s
.387 .264 .589 r
.71546 .47109 m .67053 .5099 L .68408 .61686 L p F P
0 g
s
.529 .365 .603 r
.67053 .5099 m .68408 .61686 L .67136 .62241 L p F P
0 g
s
.495 .502 .794 r
.59734 .28195 m .69439 .29799 L .6578 .3545 L p F P
0 g
s
.477 .53 .833 r
.69439 .29799 m .59734 .28195 L .5699 .2254 L p F P
0 g
s
.618 .687 .892 r
.50235 .18587 m .43738 .20158 L .40802 .16135 L p F P
0 g
s
.791 .5 .495 r
.28952 .76149 m .21973 .74415 L .20756 .64994 L p F P
0 g
s
.834 .535 .482 r
.15164 .62754 m .20756 .64994 L .21973 .74415 L p F P
0 g
s
.863 .728 .712 r
.13131 .49896 m .09254 .46827 L .15862 .35515 L p F P
0 g
s
.451 .405 .716 r
.6578 .3545 m .73705 .39275 L p .71546 .47109 L F P
0 g
s
.428 .415 .743 r
.6578 .3545 m .73705 .39275 L .70813 .30425 L p F P
0 g
s
.428 .415 .743 r
.70813 .30425 m .69439 .29799 L .6578 .3545 L p F P
0 g
s
.865 .65 .61 r
.12109 .53683 m .13131 .49896 L p .15164 .62754 L F P
0 g
s
.902 .694 .612 r
.13131 .49896 m .12109 .53683 L .08891 .4812 L p F P
0 g
s
.902 .694 .612 r
.08891 .4812 m .09254 .46827 L .13131 .49896 L p F P
0 g
s
.477 .53 .833 r
.5699 .2254 m .68044 .23939 L p .69439 .29799 L F P
0 g
s
.479 .563 .863 r
.68044 .23939 m .5699 .2254 L .54206 .17673 L p F P
0 g
s
.613 .683 .892 r
.50235 .18587 m .54206 .17673 L .5136 .13496 L p F P
0 g
s
.613 .683 .892 r
.5136 .13496 m .49988 .13825 L .50235 .18587 L p F P
0 g
s
.618 .687 .892 r
.40802 .16135 m .49988 .13825 L .50235 .18587 L p F P
0 g
s
.865 .65 .61 r
.15164 .62754 m .14353 .62313 L .12109 .53683 L p F P
0 g
s
.869 .652 .606 r
.14353 .62313 m .12109 .53683 L .10451 .60124 L closepath p F P
0 g
s
.905 .694 .607 r
.10451 .60124 m .12109 .53683 L .08891 .4812 L p F P
0 g
s
.834 .535 .482 r
.21973 .74415 m .16114 .72256 L .15164 .62754 L p F P
0 g
s
.878 .57 .461 r
.14353 .62313 m .15164 .62754 L .16114 .72256 L p F P
0 g
s
.878 .57 .461 r
.10864 .66066 m .14353 .62313 L p .16114 .72256 L F P
0 g
s
.884 .579 .465 r
.10864 .66066 m .10451 .60124 L .14353 .62313 L closepath p F P
0 g
s
.452 .212 .458 r
.67136 .62241 m .68408 .61686 L p .57896 .74953 L F P
0 g
s
.452 .212 .458 r
.57896 .74953 m .57992 .73773 L .67136 .62241 L p F P
0 g
s
.506 .139 .278 r
.44384 .81141 m .46244 .77031 L .57896 .74953 L p F P
0 g
s
.589 .325 .485 r
.57992 .73773 m .57896 .74953 L .46244 .77031 L p F P
0 g
s
.641 .278 .341 r
.44384 .81141 m .38612 .77029 L .46244 .77031 L closepath p F P
0 g
s
.651 .263 .295 r
.38612 .77029 m .44384 .81141 L .42474 .84191 L p F P
0 g
s
.651 .263 .295 r
.32203 .76688 m .38612 .77029 L p .42474 .84191 L F P
0 g
s
.387 .264 .589 r
.68408 .61686 m .75764 .55694 L .71546 .47109 L p F P
0 g
s
.339 .243 .597 r
.74911 .43531 m .71546 .47109 L .75764 .55694 L p F P
0 g
s
.451 .405 .716 r
.73705 .39275 m .74911 .43531 L .71546 .47109 L p F P
0 g
s
.651 .263 .295 r
.3079 .7872 m .32203 .76688 L p .42474 .84191 L F P
0 g
s
.732 .361 .348 r
.3079 .7872 m .28952 .76149 L .32203 .76688 L closepath p F P
0 g
s
.248 .053 .408 r
.75764 .55694 m .68408 .61686 L .67972 .70752 L p F P
0 g
s
.452 .212 .458 r
.68408 .61686 m .67972 .70752 L .57896 .74953 L p F P
0 g
s
.479 .563 .863 r
.54206 .17673 m .65294 .18727 L .68044 .23939 L p F P
0 g
s
.454 .602 .908 r
.65294 .18727 m .54206 .17673 L .5136 .13496 L p F P
0 g
s
.76 .361 .296 r
.28952 .76149 m .3079 .7872 L .27192 .82003 L p F P
0 g
s
.76 .361 .296 r
.27192 .82003 m .21973 .74415 L .28952 .76149 L p F P
0 g
s
.905 .694 .607 r
.08891 .4812 m .06481 .57123 L .10451 .60124 L p F P
0 g
s
.925 .614 .437 r
.10451 .60124 m .10864 .66066 L .06965 .65523 L p F P
0 g
s
.925 .614 .437 r
.06965 .65523 m .06481 .57123 L .10451 .60124 L p F P
0 g
s
.391 .43 .782 r
.70813 .30425 m .69439 .29799 L .69979 .28268 L closepath p F P
0 g
s
.477 .53 .833 r
.68044 .23939 m .69979 .28268 L .69439 .29799 L p F P
0 g
s
.301 0 .19 r
.55343 .81526 m .57896 .74953 L .67972 .70752 L p F P
0 g
s
.506 .139 .278 r
.57896 .74953 m .55343 .81526 L .44384 .81141 L p F P
0 g
s
.788 .372 .261 r
.21973 .74415 m .27192 .82003 L .2611 .82444 L p F P
0 g
s
.788 .372 .261 r
.16114 .72256 m .21973 .74415 L p .2611 .82444 L F P
0 g
s
.327 .321 .7 r
.74911 .43531 m .73705 .39275 L .76073 .41455 L closepath p F P
0 g
s
.267 .312 .723 r
.76073 .41455 m .73705 .39275 L .70813 .30425 L p F P
0 g
s
.651 .263 .295 r
.42474 .84191 m .37884 .83997 L .3079 .7872 L p F P
0 g
s
.667 .235 .214 r
.37884 .83997 m .3079 .7872 L .27192 .82003 L p F P
0 g
s
.267 .312 .723 r
.70813 .30425 m .7768 .36555 L .76073 .41455 L p F P
0 g
s
.18 .296 .747 r
.7768 .36555 m .70813 .30425 L .69979 .28268 L p F P
0 g
s
.161 .119 .559 r
.76073 .41455 m .74911 .43531 L .76706 .54753 L p F P
0 g
s
.339 .243 .597 r
.75764 .55694 m .76706 .54753 L .74911 .43531 L p F P
0 g
s
.454 .602 .908 r
.5136 .13496 m .62517 .14363 L .65294 .18727 L p F P
0 g
s
.18 .296 .747 r
.69979 .28268 m .70304 .24924 L p .7768 .36555 L F P
0 g
s
.351 .443 .815 r
.69979 .28268 m .68044 .23939 L .70304 .24924 L closepath p F P
0 g
s
.295 .455 .85 r
.70304 .24924 m .68044 .23939 L .65294 .18727 L p F P
0 g
s
.48 .07 .185 r
.42474 .84191 m .44384 .81141 L .55343 .81526 L p F P
0 g
s
.788 .372 .261 r
.2611 .82444 m .21606 .81016 L .16114 .72256 L p F P
0 g
s
.824 .382 .184 r
.11174 .6971 m .16114 .72256 L .21606 .81016 L p F P
0 g
s
.878 .57 .461 r
.16114 .72256 m .11174 .6971 L .10864 .66066 L p F P
0 g
s
.161 .119 .559 r
.76706 .54753 m .79247 .50501 L .76073 .41455 L p F P
0 g
s
0 .007 .52 r
.7768 .36555 m .76073 .41455 L .79247 .50501 L p F P
0 g
s
.923 .607 .428 r
.11174 .6971 m .10864 .66066 L .06965 .65523 L p F P
0 g
s
.248 .053 .408 r
.67972 .70752 m .72726 .67051 L .75764 .55694 L p F P
0 g
s
.13 0 .348 r
.76706 .54753 m .75764 .55694 L .72726 .67051 L p F P
0 g
s
.18 .296 .747 r
.70304 .24924 m .77909 .31929 L .7768 .36555 L p F P
0 g
s
0 .224 .736 r
.69456 .20476 m .70304 .24924 L .77909 .31929 L p F P
0 g
s
.295 .455 .85 r
.65294 .18727 m .69456 .20476 L .70304 .24924 L p F P
0 g
s
.004 0 .071 r
.66592 .74851 m .72726 .67051 L .67972 .70752 L closepath p F P
0 g
s
.301 0 .19 r
.67972 .70752 m .66592 .74851 L .55343 .81526 L p F P
0 g
s
.222 .464 .879 r
.69456 .20476 m .65294 .18727 L .62517 .14363 L p F P
0 g
s
0 0 .258 r
.79247 .50501 m .76706 .54753 L .76298 .63631 L p F P
0 g
s
.13 0 .348 r
.72726 .67051 m .76298 .63631 L .76706 .54753 L p F P
0 g
s
.824 .382 .184 r
.21606 .81016 m .16313 .78568 L .11174 .6971 L p F P
0 g
s
.839 .372 .057 r
.07057 .66781 m .11174 .6971 L .16313 .78568 L p F P
0 g
s
.923 .607 .428 r
.06965 .65523 m .07057 .66781 L .11174 .6971 L p F P
0 g
s
.305 0 0 r
.41176 .85179 m .42474 .84191 L .54888 .82357 L p F P
0 g
s
.48 .07 .185 r
.55343 .81526 m .54888 .82357 L .42474 .84191 L p F P
0 g
s
.552 .062 .045 r
.41176 .85179 m .37884 .83997 L .42474 .84191 L closepath p F P
0 g
s
.51 0 0 r
.37884 .83997 m .41176 .85179 L .37837 .86377 L p F P
0 g
s
.51 0 0 r
.37837 .86377 m .28393 .82928 L .37884 .83997 L p F P
0 g
s
.667 .235 .214 r
.27192 .82003 m .28393 .82928 L .37884 .83997 L p F P
0 g
s
.678 .191 .086 r
.28393 .82928 m .2611 .82444 L .27192 .82003 L closepath p F P
0 g
s
0 .007 .52 r
.79247 .50501 m .80762 .45727 L .7768 .36555 L p F P
0 g
s
0 0 .431 r
.77909 .31929 m .7768 .36555 L .80762 .45727 L p F P
0 g
s
.183 0 .037 r
.54888 .82357 m .55343 .81526 L .66592 .74851 L p F P
0 g
s
.222 .464 .879 r
.62517 .14363 m .67321 .16323 L .69456 .20476 L p F P
0 g
s
0 .224 .736 r
.77909 .31929 m .7691 .2754 L .69456 .20476 L p F P
0 g
s
0 .157 .697 r
.67321 .16323 m .69456 .20476 L .7691 .2754 L p F P
0 g
s
.494 0 0 r
.28393 .82928 m .37837 .86377 L p .2355 .82543 L F P
0 g
s
.494 0 0 r
.2355 .82543 m .2611 .82444 L .28393 .82928 L p F P
0 g
s
0 0 0 r
.72726 .67051 m .76298 .63631 L p .65107 .77871 L F P
0 g
s
0 0 0 r
.65107 .77871 m .66592 .74851 L .72726 .67051 L p F P
0 g
s
.839 .372 .057 r
.16313 .78568 m .12042 .75692 L .07057 .66781 L p F P
0 g
s
.668 .135 0 r
.2355 .82543 m .21606 .81016 L .2611 .82444 L closepath p F P
0 g
s
0 0 0 r
.52418 .84423 m .54888 .82357 L .65107 .77871 L p F P
0 g
s
.183 0 .037 r
.66592 .74851 m .65107 .77871 L .54888 .82357 L p F P
0 g
s
.305 0 0 r
.54888 .82357 m .52418 .84423 L .41176 .85179 L p F P
0 g
s
.086 0 0 r
.52418 .84423 m .41176 .85179 L .37837 .86377 L p F P
0 g
s
0 0 .258 r
.76298 .63631 m .77539 .61644 L .79247 .50501 L p F P
0 g
s
0 0 .112 r
.80762 .45727 m .79247 .50501 L .77539 .61644 L p F P
0 g
s
.619 .053 0 r
.21606 .81016 m .2355 .82543 L .1985 .81374 L p F P
0 g
s
.619 .053 0 r
.1985 .81374 m .16313 .78568 L .21606 .81016 L p F P
0 g
s
0 .157 .697 r
.7691 .2754 m .7474 .23382 L .67321 .16323 L p F P
0 g
s
0 0 .431 r
.80762 .45727 m .80928 .41194 L .77909 .31929 L p F P
0 g
s
0 0 .28 r
.7691 .2754 m .77909 .31929 L .80928 .41194 L p F P
0 g
s
0 0 0 r
.75456 .65612 m .77539 .61644 L .76298 .63631 L closepath p F P
0 g
s
0 0 0 r
.76298 .63631 m .75456 .65612 L p .65107 .77871 L F P
0 g
s
.494 0 0 r
.37837 .86377 m .34367 .86211 L .2355 .82543 L p F P
0 g
s
0 .408 .727 r
.34367 .86211 m .2355 .82543 L .1985 .81374 L p F P
0 g
s
.507 0 0 r
.16313 .78568 m .1985 .81374 L .16092 .78914 L p F P
0 g
s
.507 0 0 r
.16092 .78914 m .12042 .75692 L .16313 .78568 L p F P
0 g
s
0 0 .112 r
.77539 .61644 m .79272 .56946 L .80762 .45727 L p F P
0 g
s
.766 .684 .138 r
.80928 .41194 m .80762 .45727 L .79272 .56946 L p F P
0 g
s
0 0 0 r
.65107 .77871 m .64039 .78817 L .52418 .84423 L p F P
0 g
s
.086 0 0 r
.37837 .86377 m .49306 .8542 L .52418 .84423 L p F P
0 g
s
.351 .81 .7 r
.64039 .78817 m .52418 .84423 L .49306 .8542 L p F P
0 g
s
0 0 0 r
.75456 .65612 m .67586 .75633 L .65107 .77871 L p F P
0 g
s
.479 .821 .533 r
.64039 .78817 m .67586 .75633 L .65107 .77871 L closepath p F P
0 g
s
0 0 0 r
.67586 .75633 m .75456 .65612 L .73106 .68696 L p F P
0 g
s
.789 .892 .477 r
.77539 .61644 m .75456 .65612 L .73106 .68696 L p F P
0 g
s
.789 .892 .477 r
.73106 .68696 m .79272 .56946 L .77539 .61644 L p F P
0 g
s
.197 .722 .848 r
.49306 .8542 m .37837 .86377 L .34367 .86211 L p F P
0 g
s
0 0 .28 r
.78024 .30957 m .7691 .2754 L p .80928 .41194 L F P
0 g
s
.814 .451 0 r
.7691 .2754 m .78024 .30957 L .75115 .24541 L p F P
0 g
s
.814 .451 0 r
.75115 .24541 m .7474 .23382 L .7691 .2754 L p F P
0 g
s
.719 .98 .77 r
.67586 .75633 m .64039 .78817 L .61211 .79884 L p F P
0 g
s
.351 .81 .7 r
.49306 .8542 m .61211 .79884 L .64039 .78817 L p F P
0 g
s
0 0 0 r
.73106 .68696 m .7172 .70461 L .67586 .75633 L p F P
0 g
s
.719 .98 .77 r
.61211 .79884 m .7172 .70461 L .67586 .75633 L p F P
0 g
s
0 .408 .727 r
.1985 .81374 m .30784 .84817 L .34367 .86211 L p F P
0 g
s
.037 .505 .884 r
.30784 .84817 m .1985 .81374 L .16092 .78914 L p F P
0 g
s
0 0 .239 r
.8076 .40464 m .78024 .30957 L .79835 .36889 L closepath p F P
0 g
s
0 0 .28 r
.80928 .41194 m .8076 .40464 L .78024 .30957 L p F P
0 g
s
.837 .476 0 r
.79835 .36889 m .78024 .30957 L .75115 .24541 L p F P
0 g
s
.766 .684 .138 r
.79272 .56946 m .7955 .52499 L .80928 .41194 L p F P
0 g
s
.965 .791 .355 r
.8076 .40464 m .80928 .41194 L .7955 .52499 L p F P
0 g
s
.97 .784 .354 r
.79066 .43925 m .79835 .36889 L .8076 .40464 L closepath p F P
0 g
s
.965 .791 .355 r
.79066 .43925 m .8076 .40464 L p .7955 .52499 L F P
0 g
s
.939 .954 .642 r
.79272 .56946 m .7955 .52499 L p .72341 .69055 L F P
0 g
s
.939 .954 .642 r
.72341 .69055 m .73106 .68696 L .79272 .56946 L p F P
0 g
s
.197 .722 .848 r
.34367 .86211 m .46033 .85093 L .49306 .8542 L p F P
0 g
s
.382 .788 .982 r
.34367 .86211 m .46033 .85093 L .45459 .84845 L p F P
0 g
s
.382 .788 .982 r
.30784 .84817 m .34367 .86211 L p .45459 .84845 L F P
0 g
s
.592 .939 .935 r
.61211 .79884 m .49306 .8542 L .46033 .85093 L p F P
0 g
s
.837 .476 0 r
.75115 .24541 m .77602 .32784 L .79835 .36889 L p F P
0 g
s
.037 .505 .884 r
.16092 .78914 m .27105 .8225 L .30784 .84817 L p F P
0 g
s
.827 .983 .699 r
.7172 .70461 m .72341 .69055 L .73106 .68696 L closepath p F P
0 g
s
.804 .996 .863 r
.7172 .70461 m .61211 .79884 L .5819 .79549 L p F P
0 g
s
.592 .939 .935 r
.46033 .85093 m .5819 .79549 L .61211 .79884 L p F P
0 g
s
.996 .769 .459 r
.79835 .36889 m .79066 .43925 L .76452 .42751 L p F P
0 g
s
.996 .769 .459 r
.76452 .42751 m .77602 .32784 L .79835 .36889 L p F P
0 g
s
.804 .996 .863 r
.72341 .69055 m .7172 .70461 L p .5819 .79549 L F P
0 g
s
.939 .954 .642 r
.7955 .52499 m .72743 .65975 L .72341 .69055 L p F P
0 g
s
.973 .919 .679 r
.78525 .4827 m .7955 .52499 L .72743 .65975 L p F P
0 g
s
.965 .791 .355 r
.7955 .52499 m .78525 .4827 L .79066 .43925 L p F P
0 g
s
.907 .978 .789 r
.70428 .68917 m .72743 .65975 L .72341 .69055 L closepath p F P
0 g
s
.804 .996 .863 r
.5819 .79549 m .70428 .68917 L .72341 .69055 L p F P
0 g
s
.382 .788 .982 r
.45459 .84845 m .35147 .8438 L .30784 .84817 L p F P
0 g
s
.485 .763 .992 r
.35147 .8438 m .30784 .84817 L .27105 .8225 L p F P
0 g
s
.686 .906 .973 r
.45459 .84845 m .46033 .85093 L .5819 .79549 L p F P
0 g
s
.681 .898 .975 r
.4262 .83522 m .50322 .80097 L .45459 .84845 L closepath p F P
0 g
s
.686 .906 .973 r
.54998 .77952 m .50322 .80097 L .45459 .84845 L p F P
0 g
s
.686 .906 .973 r
.5819 .79549 m .54998 .77952 L p .45459 .84845 L F P
0 g
s
.413 .797 .991 r
.4262 .83522 m .35147 .8438 L .45459 .84845 L closepath p F P
0 g
s
.997 .776 .47 r
.78525 .4827 m .79066 .43925 L .76452 .42751 L p F P
0 g
s
.5 .766 .991 r
.35147 .8438 m .4262 .83522 L .39083 .8082 L p F P
0 g
s
.5 .766 .991 r
.39083 .8082 m .286 .82091 L .35147 .8438 L p F P
0 g
s
.485 .763 .992 r
.27105 .8225 m .286 .82091 L .35147 .8438 L p F P
0 g
s
.913 .919 .808 r
.72743 .65975 m .70428 .68917 L .67518 .6734 L p F P
0 g
s
.913 .919 .808 r
.67518 .6734 m .71843 .61864 L .72743 .65975 L p F P
0 g
s
.973 .919 .679 r
.72743 .65975 m .71843 .61864 L .78525 .4827 L p F P
0 g
s
.836 .937 .893 r
.70428 .68917 m .5819 .79549 L .54998 .77952 L p F P
0 g
s
.836 .937 .893 r
.54998 .77952 m .67518 .6734 L .70428 .68917 L p F P
0 g
s
.954 .848 .7 r
.76255 .44256 m .78525 .4827 L .71843 .61864 L p F P
0 g
s
.997 .776 .47 r
.76452 .42751 m .76255 .44256 L .78525 .4827 L p F P
0 g
s
.7 .834 .947 r
.50322 .80097 m .4262 .83522 L .39083 .8082 L p F P
0 g
s
.7 .834 .947 r
.39083 .8082 m .50031 .75897 L .50322 .80097 L p F P
0 g
s
.706 .838 .946 r
.51655 .75144 m .50031 .75897 L .50322 .80097 L p F P
0 g
s
.706 .838 .946 r
.50322 .80097 m .54998 .77952 L .51655 .75144 L p F P
0 g
s
.892 .855 .799 r
.71843 .61864 m .67518 .6734 L .64421 .64398 L p F P
0 g
s
.892 .855 .799 r
.64421 .64398 m .69492 .58008 L .71843 .61864 L p F P
0 g
s
.954 .848 .7 r
.71843 .61864 m .69492 .58008 L .76255 .44256 L p F P
0 g
s
.825 .859 .872 r
.67518 .6734 m .54998 .77952 L .51655 .75144 L p F P
0 g
s
.825 .859 .872 r
.51655 .75144 m .64421 .64398 L .67518 .6734 L p F P
0 g
s
.25 Mabswid
.76539 0 m
.91896 .25023 L
s
.91896 .25023 m
1 .91564 L
s
1 .91564 m
.82361 .69772 L
s
.82361 .69772 m
.76539 0 L
s
.07961 .26916 m
0 .93177 L
s
0 .93177 m
.82361 .69772 L
s
.82361 .69772 m
.76539 0 L
s
.76539 0 m
.07961 .26916 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S5.30.1"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics3D  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S5.30.1"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"option name\"\>",
                      "TI"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"default value\"\>",
                      "TI"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`\[Null]\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"Contours\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"{0.}\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`"the list of values for the contours to be \
plotted"\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"ContourStyle\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"{}\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`"the list of styles for the contours to be \
plotted"\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"MaxRecursion\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"1\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`"the number of levels of recursion used in \
each cube"\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"PlotPoints\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"{3,5}\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`"the number of evaluation points to use in \
each direction"\)]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False}},
  CellTags->"S5.30.1"],

Cell[TextData[{
  "Options for ",
  StyleBox["ContourPlot3D", "MR"],
  "."
}], "Caption",
  CellTags->"S5.30.1"],

Cell[TextData[{
  "Each value specified in ",
  StyleBox["Contours", "MR"],
  " generates a different surface. ",
  StyleBox["ContourStyle", "MR"],
  " colors each surface. To use this option, you must set ",
  StyleBox["Lighting", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["False", "MR"],
  ". ",
  StyleBox["MaxRecursion", "MR"],
  " sets the number of times you subdivide each cube. However, if the surface \
does not intersect the cube, the cube is not subdivided. With ",
  StyleBox["MaxRecursion", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["0", "MR"],
  " the plot points are chosen from ",
  StyleBox["PlotPoints", "MR"],
  " ",
  StyleBox["->x", "MR"],
  " or ",
  StyleBox["PlotPoints", "MR"],
  " ",
  StyleBox["->", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`{\)], "InlineFormula"],
  StyleBox["x,", "MR"],
  " ",
  StyleBox["y,", "MR"],
  " ",
  StyleBox["z", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`}\)], "InlineFormula"],
  ". If ",
  StyleBox["MaxRecursion", "MR"],
  " is greater than ",
  Cell[BoxData[
      \(TraditionalForm\`0\)], "InlineFormula"],
  ", recursion takes place. You can give a different number of plot points \
for the first and subsequent divisions of a cube. ",
  StyleBox["PlotPoints", "MR"],
  " ",
  StyleBox["->", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`{\)], "InlineFormula"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["\<\"x\"\>",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["\<\"x\"\>",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  Cell[BoxData[
      \(TraditionalForm\`}\)], "InlineFormula"],
  " means that ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["\<\"x\"\>",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  " plot points are used first, and then if you subdivide, ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["\<\"x\"\>",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  " plot points are used. ",
  StyleBox["PlotPoints", "MR"],
  " ",
  StyleBox["->", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`{\)], "InlineFormula"],
  Cell[BoxData[
      \(TraditionalForm\`{\)], "InlineFormula"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["\<\"x\"\>",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["\<\"x\"\>",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  Cell[BoxData[
      \(TraditionalForm\`}\)], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`{\)], "InlineFormula"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["\<\"y\"\>",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["\<\"y\"\>",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  Cell[BoxData[
      \(TraditionalForm\`}\)], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`{\)], "InlineFormula"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["\<\"z\"\>",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["\<\"z\"\>",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  Cell[BoxData[
      \(TraditionalForm\`}\)], "InlineFormula"],
  Cell[BoxData[
      \(TraditionalForm\`}\)], "InlineFormula"],
  " is also valid. ",
  StyleBox["ContourPlot3D", "MR"],
  " and ",
  StyleBox["ListContourPlot3D", "MR"],
  " return a ",
  StyleBox["Graphics3D", "MR"],
  " object. This means the functions will accept any option that can be \
specified for a ",
  StyleBox["Graphics3D", "MR"],
  " object. "
}], "Text",
  CellTags->{"S5.30.1", "1.5"}],

Cell[TextData[{
  "Here is another plot showing a contour value of ",
  Cell[BoxData[
      \(TraditionalForm\`0.1\)], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S5.30.1", "1.6"}],

Cell[CellGroupData[{

Cell["\<\
ContourPlot3D[x y z,
   {x,-1,1}, {y,-1,1}, {z,-1,1},
      Contours -> {.1}]\
\>", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S5.30.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.0855 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0567234 1.16608 6.45642e-17 1.16608 [
[ 0 0 0 0 ]
[ 1 1.0855 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.40037 1.0855 L
s
.40037 1.0855 m
.41799 .58158 L
s
.41799 .58158 m
.08846 .24555 L
s
.67245 0 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.67245 0 m
.08846 .24555 L
s
.41799 .58158 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.40037 1.0855 L
s
.40037 1.0855 m
.41799 .58158 L
s
0 0 m
1 0 L
1 1.0855 L
0 1.0855 L
closepath
clip
newpath
.5 Mabswid
.896 .677 .598 r
.59216 .47896 m .63079 .51342 L .62448 .56999 L p F P
0 g
s
.86 .682 .659 r
.58232 .537 m .62448 .56999 L .60968 .63096 L p F P
0 g
s
.896 .677 .598 r
.62448 .56999 m .58232 .537 L .59216 .47896 L p F P
0 g
s
.856 .645 .616 r
.54372 .44595 m .59216 .47896 L .58232 .537 L p F P
0 g
s
.706 .707 .848 r
.47545 .7561 m .41545 .78126 L .3799 .74114 L p F P
0 g
s
.85 .693 .687 r
.59783 .65761 m .60968 .63096 L .57173 .60637 L closepath p F P
0 g
s
.86 .682 .659 r
.56509 .59149 m .58232 .537 L p .60968 .63096 L F P
0 g
s
.86 .682 .659 r
.60968 .63096 m .57173 .60637 L .56509 .59149 L p F P
0 g
s
.734 .704 .822 r
.53656 .7226 m .47545 .7561 L .44081 .71246 L p F P
0 g
s
.706 .707 .848 r
.3799 .74114 m .44081 .71246 L .47545 .7561 L p F P
0 g
s
.612 .415 .591 r
.29545 .51111 m .29454 .45118 L .35874 .43508 L p F P
0 g
s
.848 .658 .646 r
.56509 .59149 m .58232 .537 L .536 .51015 L closepath p F P
0 g
s
.856 .645 .616 r
.5315 .49389 m .54372 .44595 L p .58232 .537 L F P
0 g
s
.856 .645 .616 r
.58232 .537 m .536 .51015 L .5315 .49389 L p F P
0 g
s
.773 .693 .776 r
.57173 .60637 m .59783 .65761 L .56118 .70358 L p F P
0 g
s
.824 .615 .621 r
.5315 .49389 m .54372 .44595 L .51807 .43442 L closepath p F P
0 g
s
.759 .705 .801 r
.53656 .7226 m .56118 .70358 L .5097 .68365 L closepath p F P
0 g
s
.734 .704 .822 r
.5097 .68365 m .53656 .7226 L p .44081 .71246 L F P
0 g
s
.773 .693 .776 r
.56101 .60044 m .57173 .60637 L p .56118 .70358 L F P
0 g
s
.773 .693 .776 r
.50287 .67276 m .56101 .60044 L p .56118 .70358 L F P
0 g
s
.773 .693 .776 r
.56118 .70358 m .5097 .68365 L .50287 .67276 L p F P
0 g
s
.707 .665 .806 r
.44081 .71246 m .3799 .74114 L .34339 .69147 L p F P
0 g
s
.663 .463 .605 r
.35874 .43508 m .42889 .42407 L p .4261 .48997 L F P
0 g
s
.663 .463 .605 r
.4261 .48997 m .36233 .49704 L .35874 .43508 L p F P
0 g
s
.612 .415 .591 r
.35874 .43508 m .36233 .49704 L .29545 .51111 L p F P
0 g
s
.759 .557 .624 r
.51807 .43442 m .5315 .49389 L .52736 .50641 L p F P
0 g
s
.759 .557 .624 r
.46048 .4234 m .51807 .43442 L p .52736 .50641 L F P
0 g
s
.836 .674 .682 r
.57173 .60637 m .56509 .59149 L .56101 .60044 L closepath p F P
0 g
s
.811 .642 .673 r
.56101 .60044 m .56509 .59149 L .536 .51015 L p F P
0 g
s
.786 .67 .735 r
.56101 .60044 m .50287 .67276 L .46829 .60549 L p F P
0 g
s
.786 .67 .735 r
.46829 .60549 m .49369 .57418 L .56101 .60044 L p F P
0 g
s
.811 .642 .673 r
.52736 .50641 m .49369 .57418 L .56101 .60044 L p F P
0 g
s
.811 .642 .673 r
.536 .51015 m .52736 .50641 L p .56101 .60044 L F P
0 g
s
.734 .704 .822 r
.44081 .71246 m .49454 .67921 L .5097 .68365 L p F P
0 g
s
.725 .679 .805 r
.44081 .71246 m .49454 .67921 L .41001 .66526 L closepath p F P
0 g
s
.707 .665 .806 r
.41001 .66526 m .44081 .71246 L p .34339 .69147 L F P
0 g
s
.696 .5 .619 r
.43468 .47596 m .46048 .4234 L .42889 .42407 L closepath p F P
0 g
s
.663 .463 .605 r
.42889 .42407 m .43468 .47596 L .4261 .48997 L p F P
0 g
s
.82 .626 .64 r
.536 .51015 m .5315 .49389 L .52736 .50641 L closepath p F P
0 g
s
.759 .557 .624 r
.43468 .47596 m .46048 .4234 L p .52736 .50641 L F P
0 g
s
.65 .47 .627 r
.29545 .51111 m .36233 .49704 L p .35797 .56916 L F P
0 g
s
.65 .47 .627 r
.35797 .56916 m .30163 .57792 L .29545 .51111 L p F P
0 g
s
.751 .687 .79 r
.5097 .68365 m .50287 .67276 L .49454 .67921 L closepath p F P
0 g
s
.757 .578 .654 r
.43675 .48975 m .52736 .50641 L .49369 .57418 L p F P
0 g
s
.759 .557 .624 r
.52736 .50641 m .43675 .48975 L .43468 .47596 L p F P
0 g
s
.736 .656 .77 r
.46829 .60549 m .50287 .67276 L .49454 .67921 L p F P
0 g
s
.736 .656 .77 r
.40525 .65657 m .46829 .60549 L p .49454 .67921 L F P
0 g
s
.736 .656 .77 r
.49454 .67921 m .41001 .66526 L .40525 .65657 L p F P
0 g
s
.67 .495 .64 r
.37064 .55736 m .4261 .48997 L .36233 .49704 L closepath p F P
0 g
s
.65 .47 .627 r
.36233 .49704 m .37064 .55736 L .35797 .56916 L p F P
0 g
s
.707 .665 .806 r
.34339 .69147 m .39277 .66438 L .41001 .66526 L p F P
0 g
s
.698 .641 .788 r
.34339 .69147 m .39277 .66438 L .32878 .66556 L closepath p F P
0 g
s
.698 .514 .636 r
.43675 .48975 m .43468 .47596 L .4261 .48997 L closepath p F P
0 g
s
.7 .539 .665 r
.4261 .48997 m .43675 .48975 L p .37278 .56758 L F P
0 g
s
.7 .539 .665 r
.37278 .56758 m .37064 .55736 L .4261 .48997 L p F P
0 g
s
.757 .578 .654 r
.49369 .57418 m .45446 .56727 L .43675 .48975 L p F P
0 g
s
.7 .539 .665 r
.43675 .48975 m .45446 .56727 L .37278 .56758 L p F P
0 g
s
.66 .513 .673 r
.3078 .60856 m .35797 .56916 L .30163 .57792 L closepath p F P
0 g
s
.702 .588 .725 r
.39277 .66438 m .32878 .66556 L .3078 .60856 L p F P
0 g
s
.712 .646 .782 r
.41001 .66526 m .40525 .65657 L .39277 .66438 L closepath p F P
0 g
s
.702 .588 .725 r
.37278 .56758 m .40525 .65657 L .39277 .66438 L p F P
0 g
s
.702 .588 .725 r
.35797 .56916 m .37278 .56758 L p .39277 .66438 L F P
0 g
s
.702 .588 .725 r
.3078 .60856 m .35797 .56916 L p .39277 .66438 L F P
0 g
s
.75 .613 .706 r
.46829 .60549 m .49369 .57418 L .45446 .56727 L closepath p F P
0 g
s
.706 .59 .724 r
.45446 .56727 m .46829 .60549 L .40525 .65657 L p F P
0 g
s
.706 .59 .724 r
.40525 .65657 m .37278 .56758 L .45446 .56727 L p F P
0 g
s
.675 .522 .67 r
.37278 .56758 m .37064 .55736 L .35797 .56916 L closepath p F P
0 g
s
.913 .965 .799 r
.77667 .76711 m .78056 .73071 L p .71378 .81663 L F P
0 g
s
.913 .965 .799 r
.71378 .81663 m .73766 .81743 L .77667 .76711 L p F P
0 g
s
.816 .899 .9 r
.77667 .76711 m .78056 .73071 L .80359 .74659 L closepath p F P
0 g
s
.741 .891 .947 r
.78056 .73071 m .80359 .74659 L .87274 .70997 L p F P
0 g
s
.977 .883 .669 r
.72538 .8476 m .71378 .81663 L .73766 .81743 L closepath p F P
0 g
s
.714 .832 .938 r
.94408 .68131 m .87274 .70997 L .84514 .68403 L p F P
0 g
s
.741 .891 .947 r
.87274 .70997 m .84514 .68403 L p .78056 .73071 L F P
0 g
s
.989 .837 .598 r
.71378 .81663 m .72538 .8476 L .71051 .92042 L p F P
0 g
s
.714 .832 .938 r
.84514 .68403 m .91785 .65138 L .94408 .68131 L p F P
0 g
s
.648 .32 .403 r
.62734 .29439 m .59807 .25945 L .63258 .25865 L closepath p F P
0 g
s
.747 .389 .374 r
.59807 .25945 m .62734 .29439 L .62541 .30276 L p F P
0 g
s
.747 .389 .374 r
.53542 .2462 m .59807 .25945 L p .62541 .30276 L F P
0 g
s
.602 .289 .411 r
.63258 .25865 m .71143 .24539 L .70934 .29376 L p F P
0 g
s
.602 .289 .411 r
.62734 .29439 m .63258 .25865 L p .70934 .29376 L F P
0 g
s
.815 .933 .909 r
.77471 .72772 m .78395 .72066 L .78056 .73071 L closepath p F P
0 g
s
.741 .891 .947 r
.84514 .68403 m .78395 .72066 L .78056 .73071 L p F P
0 g
s
.913 .965 .799 r
.78056 .73071 m .77471 .72772 L p .71378 .81663 L F P
0 g
s
.994 .785 .511 r
.69003 .88421 m .71051 .92042 L .7047 .99348 L p F P
0 g
s
.989 .837 .598 r
.70772 .8187 m .71378 .81663 L p .71051 .92042 L F P
0 g
s
.989 .837 .598 r
.71051 .92042 m .69003 .88421 L .70772 .8187 L p F P
0 g
s
.747 .389 .374 r
.52048 .27211 m .53542 .2462 L p .62541 .30276 L F P
0 g
s
.844 .467 .338 r
.52048 .27211 m .50684 .23195 L .53542 .2462 L closepath p F P
0 g
s
.542 .256 .431 r
.70934 .29376 m .71143 .24539 L .78722 .22537 L p F P
0 g
s
.796 .987 .89 r
.78395 .72066 m .77471 .72772 L .74529 .72576 L p F P
0 g
s
.913 .965 .799 r
.77471 .72772 m .71199 .80836 L .71378 .81663 L p F P
0 g
s
.91 .973 .794 r
.71199 .80836 m .77471 .72772 L .74529 .72576 L p F P
0 g
s
.796 .987 .89 r
.82076 .66933 m .78395 .72066 L p .74529 .72576 L F P
0 g
s
.757 .929 .944 r
.78395 .72066 m .82076 .66933 L .84514 .68403 L closepath p F P
0 g
s
.981 .91 .646 r
.70772 .8187 m .71199 .80836 L .71378 .81663 L closepath p F P
0 g
s
.889 .528 .355 r
.50684 .23195 m .52048 .27211 L .51534 .27717 L p F P
0 g
s
.889 .528 .355 r
.44968 .18896 m .50684 .23195 L p .51534 .27717 L F P
0 g
s
.687 .913 .972 r
.82076 .66933 m .84514 .68403 L .91785 .65138 L p F P
0 g
s
.542 .256 .431 r
.78722 .22537 m .78844 .27593 L .70934 .29376 L p F P
0 g
s
.932 .923 .549 r
.71199 .80836 m .71745 .76144 L p .68132 .84859 L F P
0 g
s
.932 .923 .549 r
.68132 .84859 m .70772 .8187 L .71199 .80836 L p F P
0 g
s
.91 .973 .794 r
.74529 .72576 m .71745 .76144 L .71199 .80836 L p F P
0 g
s
.988 .875 .527 r
.69003 .88421 m .68132 .84859 L .70772 .8187 L closepath p F P
0 g
s
.602 .289 .411 r
.70934 .29376 m .63723 .30249 L .62734 .29439 L p F P
0 g
s
.631 .273 .346 r
.63723 .30249 m .62541 .30276 L .62734 .29439 L closepath p F P
0 g
s
.994 .785 .511 r
.7047 .99348 m .6804 .95939 L .69003 .88421 L p F P
0 g
s
.687 .913 .972 r
.91785 .65138 m .89116 .62864 L p .82076 .66933 L F P
0 g
s
.564 .128 .17 r
.60804 .33637 m .62541 .30276 L .63723 .30249 L p F P
0 g
s
.716 .295 .244 r
.52514 .28196 m .62541 .30276 L .60804 .33637 L p F P
0 g
s
.747 .389 .374 r
.62541 .30276 m .52514 .28196 L .52048 .27211 L p F P
0 g
s
.572 .219 .331 r
.70282 .33113 m .63723 .30249 L .70934 .29376 L closepath p F P
0 g
s
.564 .128 .17 r
.63723 .30249 m .70282 .33113 L p .60804 .33637 L F P
0 g
s
.523 .158 .288 r
.70934 .29376 m .78844 .27593 L .78539 .3224 L p F P
0 g
s
.523 .158 .288 r
.70282 .33113 m .70934 .29376 L p .78539 .3224 L F P
0 g
s
.831 .418 .259 r
.52514 .28196 m .51534 .27717 L .52048 .27211 L closepath p F P
0 g
s
.997 .839 .497 r
.68132 .84859 m .69003 .88421 L .6804 .95939 L p F P
0 g
s
.889 .528 .355 r
.51534 .27717 m .46064 .24146 L .44968 .18896 L p F P
0 g
s
.928 .58 .353 r
.39935 .14023 m .44968 .18896 L .46064 .24146 L p F P
0 g
s
.716 .295 .244 r
.60804 .33637 m .56375 .32736 L .52514 .28196 L p F P
0 g
s
.772 .288 .079 r
.51534 .27717 m .52514 .28196 L .56375 .32736 L p F P
0 g
s
.511 .408 .674 r
.21239 .77016 m .20579 .73529 L .25708 .74625 L closepath p F P
0 g
s
.481 .467 .764 r
.25708 .74625 m .20579 .73529 L .18199 .67164 L p F P
0 g
s
.772 .288 .079 r
.48037 .28527 m .51534 .27717 L p .56375 .32736 L F P
0 g
s
.858 .424 .181 r
.48037 .28527 m .46064 .24146 L .51534 .27717 L closepath p F P
0 g
s
.481 .467 .764 r
.18199 .67164 m .21678 .63794 L p .25708 .74625 L F P
0 g
s
.555 .587 .841 r
.18199 .67164 m .16454 .64228 L .21678 .63794 L closepath p F P
0 g
s
.473 .331 .607 r
.21823 .85008 m .21239 .77016 L .25708 .74625 L p F P
0 g
s
.703 .973 .925 r
.81702 .66848 m .83167 .65967 L .82076 .66933 L closepath p F P
0 g
s
.687 .913 .972 r
.89116 .62864 m .83167 .65967 L .82076 .66933 L p F P
0 g
s
.796 .987 .89 r
.74529 .72576 m .81702 .66848 L .82076 .66933 L p F P
0 g
s
.65 .88 .523 r
.71745 .76144 m .73374 .73789 L .74529 .72576 L closepath p F P
0 g
s
0 0 0 r
.73374 .73789 m .74529 .72576 L .81702 .66848 L p F P
0 g
s
.545 .639 .894 r
.21678 .63794 m .16454 .64228 L .11797 .5828 L p F P
0 g
s
0 0 0 r
.79255 .69501 m .81702 .66848 L .83167 .65967 L p F P
0 g
s
0 0 0 r
.81702 .66848 m .79255 .69501 L .73374 .73789 L p F P
0 g
s
.932 .923 .549 r
.71745 .76144 m .6816 .84252 L .68132 .84859 L p F P
0 g
s
0 0 0 r
.73374 .73789 m .71745 .76144 L .6816 .84252 L p F P
0 g
s
.653 .959 .935 r
.83167 .65967 m .88073 .62545 L .89116 .62864 L closepath p F P
0 g
s
0 0 0 r
.83167 .65967 m .88073 .62545 L p .79255 .69501 L F P
0 g
s
.997 .839 .497 r
.67729 .85823 m .68132 .84859 L p .6804 .95939 L F P
0 g
s
.997 .839 .497 r
.6804 .95939 m .66478 .9209 L .67729 .85823 L p F P
0 g
s
.523 .158 .288 r
.78539 .3224 m .71825 .33392 L .70282 .33113 L p F P
0 g
s
.506 .086 .178 r
.71825 .33392 m .70102 .33596 L .70282 .33113 L closepath p F P
0 g
s
.564 .128 .17 r
.70282 .33113 m .70102 .33596 L .60804 .33637 L p F P
0 g
s
.482 .305 .564 r
.21791 .9278 m .21823 .85008 L .2786 .82396 L p F P
0 g
s
.473 .331 .607 r
.27003 .75139 m .2786 .82396 L .21823 .85008 L p F P
0 g
s
.473 .331 .607 r
.25708 .74625 m .27003 .75139 L p .21823 .85008 L F P
0 g
s
.928 .58 .353 r
.46064 .24146 m .40616 .1941 L .39935 .14023 L p F P
0 g
s
.89 .481 .223 r
.46064 .24146 m .48037 .28527 L .47196 .28314 L p F P
0 g
s
.89 .481 .223 r
.40616 .1941 m .46064 .24146 L p .47196 .28314 L F P
0 g
s
.886 .841 .378 r
.67729 .85823 m .6816 .84252 L .68132 .84859 L closepath p F P
0 g
s
.478 .385 .672 r
.27003 .75139 m .25708 .74625 L .26771 .73951 L closepath p F P
0 g
s
.481 .467 .764 r
.22999 .63797 m .26771 .73951 L .25708 .74625 L p F P
0 g
s
.481 .467 .764 r
.21678 .63794 m .22999 .63797 L p .25708 .74625 L F P
0 g
s
.239 0 0 r
.59368 .34124 m .60804 .33637 L .70102 .33596 L p F P
0 g
s
.52 0 0 r
.59368 .34124 m .56375 .32736 L .60804 .33637 L closepath p F P
0 g
s
.215 .729 .879 r
.70102 .33596 m .71825 .33392 L p .76392 .34465 L F P
0 g
s
.215 .729 .879 r
.67089 .34761 m .70102 .33596 L p .76392 .34465 L F P
0 g
s
.239 0 0 r
.70102 .33596 m .67089 .34761 L .59368 .34124 L p F P
0 g
s
.464 .047 .163 r
.78102 .33709 m .71825 .33392 L .78539 .3224 L closepath p F P
0 g
s
.215 .729 .879 r
.71825 .33392 m .78102 .33709 L .76392 .34465 L p F P
0 g
s
.842 .777 .272 r
.66478 .9209 m .6654 .90306 L .67729 .85823 L closepath p F P
0 g
s
0 0 0 r
.6816 .84252 m .71962 .78868 L p .6654 .90306 L F P
0 g
s
0 0 0 r
.6654 .90306 m .67729 .85823 L .6816 .84252 L p F P
0 g
s
0 0 0 r
.6816 .84252 m .71962 .78868 L .73374 .73789 L p F P
0 g
s
.52 .57 .846 r
.22999 .63797 m .21678 .63794 L .22414 .6279 L closepath p F P
0 g
s
.545 .639 .894 r
.18448 .57119 m .22414 .6279 L .21678 .63794 L p F P
0 g
s
.545 .639 .894 r
.11797 .5828 m .18448 .57119 L p .21678 .63794 L F P
0 g
s
.399 .331 .665 r
.26771 .73951 m .31324 .69672 L p .32663 .79534 L F P
0 g
s
.399 .331 .665 r
.32663 .79534 m .27003 .75139 L .26771 .73951 L p F P
0 g
s
.47 .46 .765 r
.29673 .65199 m .31324 .69672 L .26771 .73951 L p F P
0 g
s
.47 .46 .765 r
.26771 .73951 m .22999 .63797 L .29673 .65199 L p F P
0 g
s
.109 0 .165 r
.79255 .69501 m .73374 .73789 L .71962 .78868 L p F P
0 g
s
.447 .327 .624 r
.2786 .82396 m .27003 .75139 L .32663 .79534 L closepath p F P
0 g
s
.306 0 0 r
.56375 .32736 m .59368 .34124 L .55495 .324 L p F P
0 g
s
.306 0 0 r
.55495 .324 m .48511 .29157 L .56375 .32736 L p F P
0 g
s
.772 .288 .079 r
.56375 .32736 m .48511 .29157 L .48037 .28527 L p F P
0 g
s
.438 .528 .852 r
.25237 .57138 m .29673 .65199 L .22999 .63797 L p F P
0 g
s
.438 .528 .852 r
.24326 .57002 m .25237 .57138 L p .22999 .63797 L F P
0 g
s
.438 .528 .852 r
.22999 .63797 m .22414 .6279 L .24326 .57002 L p F P
0 g
s
.596 .684 .903 r
.18448 .57119 m .11797 .5828 L .06815 .52979 L p F P
0 g
s
.508 .604 .884 r
.22414 .6279 m .18448 .57119 L .24326 .57002 L closepath p F P
0 g
s
0 0 0 r
.88073 .62545 m .86674 .64137 L p .79255 .69501 L F P
0 g
s
.482 .305 .564 r
.2786 .82396 m .28147 .90425 L .21791 .9278 L p F P
0 g
s
.411 .262 .567 r
.28147 .90425 m .2786 .82396 L .32663 .79534 L p F P
0 g
s
.195 .675 .932 r
.59368 .34124 m .67089 .34761 L .66615 .34508 L p F P
0 g
s
.195 .675 .932 r
.55495 .324 m .59368 .34124 L p .66615 .34508 L F P
0 g
s
.768 .257 0 r
.48511 .29157 m .47196 .28314 L .48037 .28527 L closepath p F P
0 g
s
.89 .481 .223 r
.47196 .28314 m .42314 .24671 L .40616 .1941 L p F P
0 g
s
0 .292 .661 r
.48511 .29157 m .55495 .324 L .54682 .3178 L p F P
0 g
s
0 .292 .661 r
.47196 .28314 m .48511 .29157 L p .54682 .3178 L F P
0 g
s
.491 .641 .922 r
.24326 .57002 m .18448 .57119 L .13572 .5139 L p F P
0 g
s
.596 .684 .903 r
.06815 .52979 m .13572 .5139 L .18448 .57119 L p F P
0 g
s
.751 .237 0 r
.43719 .26583 m .42314 .24671 L .47196 .28314 L closepath p F P
0 g
s
0 .292 .661 r
.43719 .26583 m .47196 .28314 L p .54682 .3178 L F P
0 g
s
.085 .122 .603 r
.32356 .67106 m .31324 .69672 L .33318 .78997 L p F P
0 g
s
.268 .334 .747 r
.31324 .69672 m .29673 .65199 L .32356 .67106 L closepath p F P
0 g
s
.399 .331 .665 r
.31324 .69672 m .33318 .78997 L .32663 .79534 L p F P
0 g
s
.228 0 .203 r
.7911 .70174 m .80603 .6878 L .79255 .69501 L closepath p F P
0 g
s
0 0 0 r
.86674 .64137 m .80603 .6878 L .79255 .69501 L p F P
0 g
s
.109 0 .165 r
.7911 .70174 m .79255 .69501 L p .71962 .78868 L F P
0 g
s
.411 .262 .567 r
.33538 .80727 m .34121 .87492 L .28147 .90425 L p F P
0 g
s
.411 .262 .567 r
.32663 .79534 m .33538 .80727 L p .28147 .90425 L F P
0 g
s
.103 .319 .793 r
.32356 .67106 m .29673 .65199 L .25237 .57138 L p F P
0 g
s
0 0 0 r
.71811 .80084 m .6899 .86933 L .6654 .90306 L p F P
0 g
s
0 0 0 r
.71962 .78868 m .71811 .80084 L p .6654 .90306 L F P
0 g
s
.357 .263 .61 r
.33538 .80727 m .32663 .79534 L .33318 .78997 L closepath p F P
0 g
s
.375 .096 .356 r
.80603 .6878 m .86341 .66112 L p .78638 .75297 L F P
0 g
s
.375 .096 .356 r
.78638 .75297 m .7911 .70174 L .80603 .6878 L p F P
0 g
s
.282 0 .22 r
.80603 .6878 m .86341 .66112 L .86674 .64137 L closepath p F P
0 g
s
.109 0 .165 r
.71962 .78868 m .72766 .78326 L .7911 .70174 L p F P
0 g
s
.313 .048 .341 r
.72766 .78326 m .78638 .75297 L .7911 .70174 L closepath p F P
0 g
s
.248 .185 .587 r
.33318 .78997 m .35882 .73195 L p .36154 .85929 L F P
0 g
s
.248 .185 .587 r
.36154 .85929 m .33538 .80727 L .33318 .78997 L p F P
0 g
s
.085 .122 .603 r
.33318 .78997 m .35882 .73195 L .32356 .67106 L p F P
0 g
s
.206 0 .309 r
.71811 .80084 m .72766 .78326 L .71962 .78868 L closepath p F P
0 g
s
.332 .223 .577 r
.34121 .87492 m .33538 .80727 L .36154 .85929 L closepath p F P
0 g
s
.323 .085 .39 r
.72766 .78326 m .78638 .75297 L p .7143 .85358 L F P
0 g
s
.323 .085 .39 r
.7143 .85358 m .71811 .80084 L .72766 .78326 L p F P
0 g
s
.412 .556 .889 r
.25237 .57138 m .24326 .57002 L .24309 .55772 L closepath p F P
0 g
s
.491 .641 .922 r
.20472 .50663 m .24309 .55772 L .24326 .57002 L p F P
0 g
s
.491 .641 .922 r
.13572 .5139 m .20472 .50663 L p .24326 .57002 L F P
0 g
s
.215 .729 .879 r
.76392 .34465 m .68668 .34636 L .67089 .34761 L p F P
0 g
s
.349 .773 .975 r
.68668 .34636 m .66615 .34508 L .67089 .34761 L closepath p F P
0 g
s
.246 .026 .369 r
.6899 .86933 m .7143 .85358 L .71811 .80084 L closepath p F P
0 g
s
0 0 .495 r
.31565 .61459 m .32356 .67106 L .35882 .73195 L p F P
0 g
s
.103 .319 .793 r
.25237 .57138 m .31565 .61459 L .32356 .67106 L p F P
0 g
s
0 .3 .795 r
.31565 .61459 m .25237 .57138 L .24309 .55772 L p F P
0 g
s
.419 .813 .986 r
.75092 .33688 m .68668 .34636 L .76392 .34465 L closepath p F P
0 g
s
.516 .801 .997 r
.68668 .34636 m .75092 .33688 L p .63376 .31845 L F P
0 g
s
.516 .801 .997 r
.63376 .31845 m .66615 .34508 L .68668 .34636 L p F P
0 g
s
.44 .763 .996 r
.63376 .31845 m .56527 .32451 L .66615 .34508 L closepath p F P
0 g
s
.195 .675 .932 r
.66615 .34508 m .56527 .32451 L .55495 .324 L p F P
0 g
s
0 .3 .795 r
.24309 .55772 m .23251 .51014 L p .31565 .61459 L F P
0 g
s
.395 .571 .908 r
.24309 .55772 m .20472 .50663 L .23251 .51014 L closepath p F P
0 g
s
.375 .096 .356 r
.86341 .66112 m .86241 .72305 L .78638 .75297 L p F P
0 g
s
.304 .687 .977 r
.56527 .32451 m .54682 .3178 L .55495 .324 L closepath p F P
0 g
s
0 .292 .661 r
.54682 .3178 m .48203 .28657 L .43719 .26583 L p F P
0 g
s
.44 .732 .989 r
.56527 .32451 m .63376 .31845 L p .51315 .28776 L F P
0 g
s
.44 .732 .989 r
.51315 .28776 m .54682 .3178 L .56527 .32451 L p F P
0 g
s
.446 .204 .452 r
.78615 .82197 m .78638 .75297 L .86241 .72305 L p F P
0 g
s
.323 .085 .39 r
.78638 .75297 m .78615 .82197 L .7143 .85358 L p F P
0 g
s
.345 .681 .979 r
.51315 .28776 m .48203 .28657 L .54682 .3178 L closepath p F P
0 g
s
.248 .185 .587 r
.3631 .7455 m .37898 .8233 L .36154 .85929 L p F P
0 g
s
.248 .185 .587 r
.35882 .73195 m .3631 .7455 L p .36154 .85929 L F P
0 g
s
.516 .801 .997 r
.75092 .33688 m .71553 .30077 L .63376 .31845 L p F P
0 g
s
0 0 .297 r
.3631 .7455 m .35882 .73195 L .3576 .72482 L closepath p F P
0 g
s
0 0 .495 r
.32002 .62265 m .31565 .61459 L p .35882 .73195 L F P
0 g
s
0 0 .495 r
.35882 .73195 m .3576 .72482 L .32002 .62265 L p F P
0 g
s
0 .3 .795 r
.23251 .51014 m .27354 .53704 L p .31565 .61459 L F P
0 g
s
.601 .766 .959 r
.71553 .30077 m .63376 .31845 L .59358 .2752 L p F P
0 g
s
.44 .732 .989 r
.63376 .31845 m .59358 .2752 L .51315 .28776 L p F P
0 g
s
0 0 .392 r
.32002 .62265 m .31565 .61459 L .31097 .6038 L closepath p F P
0 g
s
0 .3 .795 r
.27354 .53704 m .31097 .6038 L .31565 .61459 L p F P
0 g
s
0 0 .18 r
.37898 .8233 m .3631 .7455 L .37552 .80271 L closepath p F P
0 g
s
.8 .504 0 r
.3576 .72482 m .33811 .68025 L p .37552 .80271 L F P
0 g
s
.8 .504 0 r
.37552 .80271 m .3631 .7455 L .3576 .72482 L p F P
0 g
s
.757 .423 0 r
.3576 .72482 m .32002 .62265 L .33811 .68025 L closepath p F P
0 g
s
.446 .204 .452 r
.86241 .72305 m .86588 .79445 L .78615 .82197 L p F P
0 g
s
.846 .471 0 r
.33811 .68025 m .32002 .62265 L .31097 .6038 L p F P
0 g
s
.846 .471 0 r
.31097 .6038 m .2865 .56094 L p .33811 .68025 L F P
0 g
s
.638 .241 0 r
.31097 .6038 m .27354 .53704 L .2865 .56094 L closepath p F P
0 g
s
.601 .766 .959 r
.59358 .2752 m .67711 .25306 L .71553 .30077 L p F P
0 g
s
.8 .504 0 r
.33811 .68025 m .34768 .75412 L .37552 .80271 L p F P
0 g
s
.97 .654 .301 r
.30175 .6295 m .33811 .68025 L .34768 .75412 L p F P
0 g
s
.846 .471 0 r
.2865 .56094 m .30175 .6295 L .33811 .68025 L p F P
0 g
s
.97 .654 .301 r
.34768 .75412 m .30698 .70552 L .30175 .6295 L p F P
0 g
s
.25 Mabswid
.67245 0 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.67245 0 m
.08846 .24555 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S5.30.1"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics3D  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S5.30.1"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"option name\"\>",
                      "TI"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"default value\"\>",
                      "TI"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`\[Null]\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"Contours\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"{0.}\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`"the list of values for the contours to be \
plotted"\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"ContourStyle\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"{}\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`"the list of styles for the contours to be \
plotted"\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"MeshRange\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"Automatic\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{"\<\"the ranges of \"\>", 
                    StyleBox["\<\"x\"\>",
                      "TI"], \(\(,\)\(\ \)\), 
                    StyleBox["\<\"y\"\>",
                      "TI"], \(\(,\)\(\ \)\(and\)\(\ \)\), 
                    StyleBox["\<\"z\"\>",
                      "TI"]}], TraditionalForm]]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False}},
  CellTags->"S5.30.1"],

Cell[TextData[{
  "Options for ",
  StyleBox["ListContourPlot3D", "MR"],
  "."
}], "Caption",
  CellTags->"S5.30.1"],

Cell[TextData[{
  StyleBox["ListContourPlot3D", "MR"],
  " takes a three\[Hyphen]dimensional data set interpreted as a \
representation of a function ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["f",
            "TI"], 
          RowBox[{"(", 
            RowBox[{
              StyleBox["x",
                "TI"], ",", 
              StyleBox["y",
                "TI"], ",", 
              StyleBox["z",
                "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula"],
  ", where the ranges of ",
  StyleBox["x", "TI"],
  ", ",
  StyleBox["y", "TI"],
  ", and ",
  StyleBox["z", "TI"],
  " are set by the ",
  StyleBox["MeshRange", "MR"],
  " option. With the default value of ",
  StyleBox["Automatic", "MR"],
  " for ",
  StyleBox["MeshRange", "MR"],
  ", the ranges of ",
  StyleBox["x", "TI"],
  ", ",
  StyleBox["y", "TI"],
  ", and ",
  StyleBox["z", "TI"],
  " are specified by the dimensions of the data set. "
}], "Text",
  CellTags->{"S5.30.1", "1.7"}],

Cell["\<\
This defines a three\[Hyphen]dimensional array of data. \
\>", \
"MathCaption",
  CellTags->{"S5.30.1", "1.8"}],

Cell["\<\
data = Table[x^2 + 2*y^2 + 3*z^2,
                   {z, -1, 1, .25},
                   {y, -1, 1, .25},
                   {x, -1, 1, .25}];\
\>", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S5.30.1"],

Cell[TextData[{
  "Here is a plot of the contours ",
  Cell[BoxData[
      \(TraditionalForm\`1.5\)], "InlineFormula"],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`3.0\)], "InlineFormula"],
  " specified by green and red contour surfaces, respectively. "
}], "MathCaption",
  CellTags->{"S5.30.1", "1.9"}],

Cell[CellGroupData[{

Cell["\<\
ListContourPlot3D[data,
 MeshRange -> {{-1,1}, {-1,1}, {-1,1}},
    Contours -> {1.5, 3.},
    Lighting -> False, Axes -> True,
    ContourStyle -> {{RGBColor[0,1,0]},
       {RGBColor[1,0,0]}}]\
\>", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S5.30.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.0855 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0567234 1.16608 6.45642e-17 1.16608 [
[.09072 .22988 -11.8315 -9 ]
[.09072 .22988 .16848 0 ]
[.21906 .17566 -22.6146 -9 ]
[.21906 .17566 1.38537 0 ]
[.3545 .11847 -5.39155 -9 ]
[.3545 .11847 .60845 0 ]
[.49765 .05807 -15.3884 -9 ]
[.49765 .05807 2.61165 0 ]
[.64919 -0.00583 -4.86734 -9 ]
[.64919 -0.00583 1.13266 0 ]
[.00955 .82643 -6.92724 0 ]
[.00955 .82643 5.07276 9 ]
[.12079 .90442 -13.4221 0 ]
[.12079 .90442 10.5779 9 ]
[.22056 .97437 -3.26269 0 ]
[.22056 .97437 2.73731 9 ]
[.31055 1.03745 -9.54626 0 ]
[.31055 1.03745 8.45374 9 ]
[.39213 1.09464 -3.11145 0 ]
[.39213 1.09464 2.88855 9 ]
[.07325 .26228 -12 -2.6177 ]
[.07325 .26228 0 6.3823 ]
[.05474 .37813 -24 -2.72059 ]
[.05474 .37813 0 6.27941 ]
[.03462 .5041 -6 -2.83339 ]
[.03462 .5041 0 6.16661 ]
[.01266 .64157 -18 -2.95759 ]
[.01266 .64157 0 6.04241 ]
[-0.01139 .79218 -6 -3.09501 ]
[-0.01139 .79218 0 5.90499 ]
[ 0 0 0 0 ]
[ 1 1.0855 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.08846 .24555 m
.67245 0 L
s
.10087 .24033 m
.10595 .24556 L
s
[(-1)] .09072 .22988 .97192 1 Mshowa
.22871 .18658 m
.23354 .19204 L
s
[(-0.5)] .21906 .17566 .88455 1 Mshowa
.36358 .12987 m
.36813 .13557 L
s
[(0)] .3545 .11847 .79718 1 Mshowa
.50609 .06995 m
.51031 .07589 L
s
[(0.5)] .49765 .05807 .70982 1 Mshowa
.65689 .00654 m
.66074 .01273 L
s
[(1)] .64919 -0.00583 .62245 1 Mshowa
.125 Mabswid
.12591 .22981 m
.12892 .23297 L
s
.1512 .21917 m
.15419 .22236 L
s
.17676 .20842 m
.17972 .21164 L
s
.2026 .19756 m
.20553 .20081 L
s
.25511 .17548 m
.25797 .17879 L
s
.28179 .16426 m
.28462 .1676 L
s
.30875 .15292 m
.31155 .15628 L
s
.33602 .14146 m
.33878 .14485 L
s
.39145 .11815 m
.39414 .1216 L
s
.41963 .1063 m
.42229 .10978 L
s
.44813 .09432 m
.45074 .09783 L
s
.47695 .0822 m
.47952 .08574 L
s
.53556 .05756 m
.53805 .06115 L
s
.56537 .04502 m
.56782 .04865 L
s
.59553 .03235 m
.59793 .036 L
s
.62603 .01952 m
.62839 .0232 L
s
.25 Mabswid
0 .80374 m
.40037 1.0855 L
s
.01178 .81203 m
.01289 .80482 L
s
[(-1)] .00955 .82643 .15454 -1 Mshowa
.1225 .88995 m
.12336 .88271 L
s
[(-0.5)] .12079 .90442 .11851 -1 Mshowa
.22183 .95985 m
.22246 .95259 L
s
[(0)] .22056 .97437 .08756 -1 Mshowa
.31143 1.0229 m
.31187 1.01563 L
s
[(0.5)] .31055 1.03745 .0607 -1 Mshowa
.39267 1.08007 m
.39294 1.07279 L
s
[(1)] .39213 1.09464 .03715 -1 Mshowa
.125 Mabswid
.03493 .82832 m
.03556 .82399 L
s
.05756 .84424 m
.05816 .83991 L
s
.07969 .85982 m
.08026 .85548 L
s
.10133 .87505 m
.10187 .87071 L
s
.14322 .90453 m
.14371 .90018 L
s
.1635 .9188 m
.16396 .91445 L
s
.18335 .93277 m
.18378 .92842 L
s
.20279 .94645 m
.2032 .9421 L
s
.24048 .97297 m
.24084 .96861 L
s
.25875 .98583 m
.25909 .98147 L
s
.27666 .99844 m
.27697 .99407 L
s
.29422 1.01079 m
.29451 1.00643 L
s
.32831 1.03478 m
.32855 1.03041 L
s
.34486 1.04643 m
.34508 1.04206 L
s
.3611 1.05786 m
.3613 1.05349 L
s
.37703 1.06907 m
.37721 1.0647 L
s
.25 Mabswid
.08846 .24555 m
0 .80374 L
s
.0867 .25665 m
.09342 .25384 L
s
[(-1)] .07325 .26228 1 -0.41829 Mshowa
.0683 .37277 m
.07507 .37009 L
s
[(-0.5)] .05474 .37813 1 -0.39542 Mshowa
.04829 .49904 m
.05512 .49651 L
s
[(0)] .03462 .5041 1 -0.37036 Mshowa
.02645 .63684 m
.03334 .63448 L
s
[(0.5)] .01266 .64157 1 -0.34276 Mshowa
.00252 .78784 m
.00948 .78567 L
s
[(1)] -0.01139 .79218 1 -0.31222 Mshowa
.125 Mabswid
.08314 .27912 m
.08718 .27745 L
s
.07952 .30196 m
.08356 .30031 L
s
.07584 .32518 m
.07989 .32354 L
s
.0721 .34878 m
.07616 .34715 L
s
.06443 .39717 m
.0685 .39558 L
s
.0605 .42199 m
.06458 .42042 L
s
.0565 .44723 m
.06058 .44568 L
s
.05243 .47291 m
.05652 .47137 L
s
.04407 .52563 m
.04818 .52413 L
s
.03978 .55269 m
.0439 .55121 L
s
.03542 .58024 m
.03954 .57878 L
s
.03097 .60828 m
.0351 .60685 L
s
.02184 .66593 m
.02598 .66453 L
s
.01714 .69556 m
.0213 .69418 L
s
.01236 .72574 m
.01652 .72439 L
s
.00749 .7565 m
.01165 .75517 L
s
.25 Mabswid
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.40037 1.0855 L
s
.40037 1.0855 m
.41799 .58158 L
s
.41799 .58158 m
.08846 .24555 L
s
.67245 0 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.67245 0 m
.08846 .24555 L
s
.41799 .58158 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.40037 1.0855 L
s
.40037 1.0855 m
.41799 .58158 L
s
0 0 m
1 0 L
1 1.0855 L
0 1.0855 L
closepath
clip
newpath
.5 Mabswid
1 0 0 r
.38878 .66107 m .4648 .65966 L p .44185 .73878 L F P
0 g
s
1 0 0 r
.44185 .73878 m .40915 .73936 L .38878 .66107 L p F P
0 g
s
1 0 0 r
.44368 .60398 m .4648 .65966 L .38878 .66107 L p F P
0 g
s
1 0 0 r
.38878 .66107 m .38405 .64873 L .44368 .60398 L p F P
0 g
s
1 0 0 r
.44368 .60398 m .38405 .64873 L .34994 .57664 L p F P
0 g
s
1 0 0 r
.47628 .70311 m .4648 .65966 L .53634 .6534 L closepath p F P
0 g
s
1 0 0 r
.50365 .56627 m .53634 .6534 L .4648 .65966 L p F P
0 g
s
1 0 0 r
.4648 .65966 m .44368 .60398 L .50365 .56627 L p F P
0 g
s
1 0 0 r
.4648 .65966 m .47628 .70311 L .44185 .73878 L p F P
0 g
s
1 0 0 r
.50035 .55898 m .50365 .56627 L .44368 .60398 L p F P
0 g
s
1 0 0 r
.44368 .60398 m .42357 .56049 L .50035 .55898 L p F P
0 g
s
1 0 0 r
.42357 .56049 m .44368 .60398 L p .34994 .57664 L F P
0 g
s
1 0 0 r
.41465 .80504 m .40915 .73936 L .44185 .73878 L closepath p F P
0 g
s
1 0 0 r
.56908 .54807 m .59706 .62343 L .53634 .6534 L p F P
0 g
s
1 0 0 r
.52379 .55605 m .56908 .54807 L p .53634 .6534 L F P
0 g
s
1 0 0 r
.53634 .6534 m .50365 .56627 L .52379 .55605 L p F P
0 g
s
1 0 0 r
.50365 .56627 m .52379 .55605 L .50035 .55898 L closepath p F P
0 g
s
1 0 0 r
.47021 .50207 m .50035 .55898 L .42357 .56049 L p F P
0 g
s
1 0 0 r
.42357 .56049 m .40987 .53539 L .47021 .50207 L p F P
0 g
s
1 0 0 r
.34994 .57664 m .37564 .55721 L .42357 .56049 L p F P
0 g
s
1 0 0 r
.42357 .56049 m .40987 .53539 L .37564 .55721 L closepath p F P
0 g
s
1 0 0 r
.34994 .57664 m .37564 .55721 L .33217 .54741 L closepath p F P
0 g
s
1 0 0 r
.52379 .55605 m .50035 .55898 L .47021 .50207 L p F P
0 g
s
1 0 0 r
.37447 .4819 m .40987 .53539 L .37564 .55721 L p F P
0 g
s
1 0 0 r
.31392 .52092 m .37447 .4819 L p .37564 .55721 L F P
0 g
s
1 0 0 r
.37564 .55721 m .33217 .54741 L .31392 .52092 L p F P
0 g
s
1 0 0 r
.56908 .54807 m .56442 .53755 L .52379 .55605 L closepath p F P
0 g
s
1 0 0 r
.53146 .47345 m .56442 .53755 L .52379 .55605 L p F P
0 g
s
1 0 0 r
.47021 .50207 m .53146 .47345 L p .52379 .55605 L F P
0 g
s
1 0 0 r
.63341 .53062 m .65908 .60049 L .59706 .62343 L p F P
0 g
s
1 0 0 r
.59706 .62343 m .56908 .54807 L .63341 .53062 L p F P
0 g
s
1 0 0 r
.47021 .50207 m .40987 .53539 L .37447 .4819 L p F P
0 g
s
1 0 0 r
.62648 .51462 m .63341 .53062 L .56908 .54807 L p F P
0 g
s
1 0 0 r
.56908 .54807 m .56442 .53755 L .62648 .51462 L p F P
0 g
s
1 0 0 r
.43874 .85891 m .40483 .85946 L .41465 .80504 L closepath p F P
0 g
s
1 0 0 r
.62648 .51462 m .56442 .53755 L .53146 .47345 L p F P
0 g
s
1 0 0 r
.53146 .47345 m .47021 .50207 L .43555 .44761 L p F P
0 g
s
1 0 0 r
.37447 .4819 m .43555 .44761 L .47021 .50207 L p F P
0 g
s
1 0 0 r
.6948 .50731 m .72291 .58464 L .65908 .60049 L p F P
0 g
s
1 0 0 r
.65908 .60049 m .63341 .53062 L .6948 .50731 L p F P
0 g
s
1 0 0 r
.37447 .4819 m .31392 .52092 L .27563 .47713 L p F P
0 g
s
1 0 0 r
.6902 .49648 m .6948 .50731 L .63341 .53062 L p F P
0 g
s
1 0 0 r
.63341 .53062 m .62648 .51462 L .6902 .49648 L p F P
0 g
s
1 0 0 r
.6902 .49648 m .62648 .51462 L .59398 .4495 L p F P
0 g
s
1 0 0 r
.53146 .47345 m .59398 .4495 L .62648 .51462 L p F P
0 g
s
1 0 0 r
.43555 .44761 m .37447 .4819 L .33719 .43704 L p F P
0 g
s
1 0 0 r
.27563 .47713 m .33719 .43704 L .37447 .4819 L p F P
0 g
s
1 0 0 r
.59398 .4495 m .53146 .47345 L .49752 .41799 L p F P
0 g
s
1 0 0 r
.43555 .44761 m .49752 .41799 L .53146 .47345 L p F P
0 g
s
1 0 0 r
.7891 .57605 m .72291 .58464 L .6948 .50731 L p F P
0 g
s
1 0 0 r
.49752 .41799 m .43555 .44761 L .39925 .4017 L p F P
0 g
s
1 0 0 r
.33719 .43704 m .39925 .4017 L .43555 .44761 L p F P
0 g
s
1 0 0 r
.37829 .90342 m .40483 .85946 L .43874 .85891 L p F P
0 g
s
1 0 0 r
.43874 .85891 m .47357 .87736 L p .37829 .90342 L F P
0 g
s
1 0 0 r
.6948 .50731 m .73385 .48768 L p .7891 .57605 L F P
0 g
s
1 0 0 r
.6948 .50731 m .6902 .49648 L .73385 .48768 L closepath p F P
0 g
s
1 0 0 r
.73385 .48768 m .6902 .49648 L .65815 .43026 L p F P
0 g
s
1 0 0 r
.59398 .4495 m .65815 .43026 L .6902 .49648 L p F P
0 g
s
1 0 0 r
.65815 .43026 m .59398 .4495 L .56073 .393 L p F P
0 g
s
1 0 0 r
.49752 .41799 m .56073 .393 L .59398 .4495 L p F P
0 g
s
1 0 0 r
.33719 .43704 m .27563 .47713 L .23467 .44218 L p F P
0 g
s
0 1 0 r
.41976 .67466 m .49939 .6732 L p .47713 .74435 L F P
0 g
s
0 1 0 r
.47713 .74435 m .42878 .7452 L .41976 .67466 L p F P
0 g
s
0 1 0 r
.46872 .58227 m .49939 .6732 L .41976 .67466 L p F P
0 g
s
0 1 0 r
.41976 .67466 m .4061 .63431 L .46872 .58227 L p F P
0 g
s
0 1 0 r
.37004 .67148 m .41976 .67466 L .42878 .7452 L p F P
0 g
s
0 1 0 r
.41976 .67466 m .4061 .63431 L .37004 .67148 L closepath p F P
0 g
s
0 1 0 r
.4061 .63431 m .37655 .57136 L .46872 .58227 L closepath p F P
0 g
s
0 1 0 r
.37655 .57136 m .4061 .63431 L .37004 .67148 L p F P
0 g
s
0 1 0 r
.50269 .69654 m .5237 .67037 L .49939 .6732 L closepath p F P
0 g
s
0 1 0 r
.5237 .67037 m .49939 .6732 L .46872 .58227 L p F P
0 g
s
0 1 0 r
.49939 .6732 m .50269 .69654 L .47713 .74435 L p F P
0 g
s
0 1 0 r
.42878 .7452 m .34064 .73982 L .37004 .67148 L p F P
0 g
s
0 1 0 r
.34064 .73982 m .32491 .66201 L .37004 .67148 L closepath p F P
0 g
s
0 1 0 r
.36147 .56799 m .37655 .57136 L p .37004 .67148 L F P
0 g
s
0 1 0 r
.3067 .62422 m .36147 .56799 L p .37004 .67148 L F P
0 g
s
0 1 0 r
.37004 .67148 m .32491 .66201 L .3067 .62422 L p F P
0 g
s
1 0 0 r
.56073 .393 m .49752 .41799 L .46217 .37101 L p F P
0 g
s
1 0 0 r
.39925 .4017 m .46217 .37101 L .49752 .41799 L p F P
0 g
s
0 1 0 r
.46872 .58227 m .54185 .57324 L p .5237 .67037 L F P
0 g
s
0 1 0 r
.54185 .57324 m .5316 .55035 L .46872 .58227 L closepath p F P
0 g
s
0 1 0 r
.49683 .48822 m .5316 .55035 L .46872 .58227 L p F P
0 g
s
0 1 0 r
.46872 .58227 m .4333 .52115 L .49683 .48822 L p F P
0 g
s
0 1 0 r
.4333 .52115 m .46872 .58227 L .37655 .57136 L p F P
0 g
s
0 1 0 r
.5237 .67037 m .57068 .66265 L p .50739 .74185 L F P
0 g
s
0 1 0 r
.50739 .74185 m .50269 .69654 L .5237 .67037 L p F P
0 g
s
0 1 0 r
.57068 .66265 m .56575 .64438 L .5237 .67037 L closepath p F P
0 g
s
0 1 0 r
.54185 .57324 m .56575 .64438 L .5237 .67037 L p F P
0 g
s
0 1 0 r
.50739 .74185 m .50269 .69654 L .47713 .74435 L closepath p F P
0 g
s
1 0 0 r
.39925 .4017 m .33719 .43704 L .29751 .40089 L p F P
0 g
s
1 0 0 r
.23467 .44218 m .29751 .40089 L .33719 .43704 L p F P
0 g
s
1 0 0 r
.73385 .48768 m .75608 .48428 L .7891 .57605 L p F P
0 g
s
1 0 0 r
.75608 .48428 m .73385 .48768 L .75287 .47655 L closepath p F P
0 g
s
1 0 0 r
.72436 .41581 m .75287 .47655 L .73385 .48768 L p F P
0 g
s
1 0 0 r
.65815 .43026 m .72436 .41581 L p .73385 .48768 L F P
0 g
s
1 0 0 r
.7891 .57605 m .84641 .54171 L .85966 .58811 L closepath p F P
0 g
s
1 0 0 r
.82497 .4815 m .84641 .54171 L .7891 .57605 L p F P
0 g
s
1 0 0 r
.7891 .57605 m .75608 .48428 L .82497 .4815 L p F P
0 g
s
0 1 0 r
.57068 .66265 m .56575 .64438 L .6299 .6181 L p F P
0 g
s
0 1 0 r
.60926 .55648 m .6299 .6181 L .56575 .64438 L p F P
0 g
s
0 1 0 r
.56575 .64438 m .54185 .57324 L .60926 .55648 L p F P
0 g
s
0 1 0 r
.57874 .73064 m .57068 .66265 L .63745 .64575 L p F P
0 g
s
0 1 0 r
.6299 .6181 m .63745 .64575 L .57068 .66265 L p F P
0 g
s
0 1 0 r
.57068 .66265 m .57874 .73064 L .50739 .74185 L p F P
0 g
s
0 1 0 r
.59572 .52556 m .60926 .55648 L .54185 .57324 L p F P
0 g
s
0 1 0 r
.54185 .57324 m .5316 .55035 L .59572 .52556 L p F P
0 g
s
0 1 0 r
.37655 .57136 m .37045 .5612 L .4333 .52115 L p F P
0 g
s
0 1 0 r
.37655 .57136 m .37045 .5612 L .36147 .56799 L closepath p F P
0 g
s
1 0 0 r
.72436 .41581 m .65815 .43026 L .62557 .37267 L p F P
0 g
s
1 0 0 r
.56073 .393 m .62557 .37267 L .65815 .43026 L p F P
0 g
s
1 0 0 r
.4601 .90214 m .47357 .87736 L .53711 .89643 L closepath p F P
0 g
s
1 0 0 r
.47357 .87736 m .4601 .90214 L .37829 .90342 L p F P
0 g
s
0 1 0 r
.59572 .52556 m .5316 .55035 L .49683 .48822 L p F P
0 g
s
0 1 0 r
.36147 .56799 m .3067 .62422 L .26755 .57357 L p F P
0 g
s
0 1 0 r
.26755 .57357 m .30483 .53542 L .36147 .56799 L p F P
0 g
s
0 1 0 r
.33222 .51461 m .30483 .53542 L .36147 .56799 L p F P
0 g
s
0 1 0 r
.36147 .56799 m .37045 .5612 L .33222 .51461 L p F P
0 g
s
1 0 0 r
.80569 .43399 m .82497 .4815 L .75608 .48428 L p F P
0 g
s
1 0 0 r
.75608 .48428 m .75287 .47655 L .80569 .43399 L p F P
0 g
s
0 1 0 r
.4333 .52115 m .37045 .5612 L .33222 .51461 L p F P
0 g
s
0 1 0 r
.41565 .79762 m .42878 .7452 L .47713 .74435 L p F P
0 g
s
0 1 0 r
.34064 .73982 m .42878 .7452 L .41565 .79762 L p F P
0 g
s
1 0 0 r
.7931 .4063 m .80569 .43399 L .75287 .47655 L p F P
0 g
s
1 0 0 r
.75287 .47655 m .72436 .41581 L .7931 .4063 L p F P
0 g
s
0 1 0 r
.50209 .77844 m .47713 .74435 L .50739 .74185 L closepath p F P
0 g
s
0 1 0 r
.47713 .74435 m .50209 .77844 L p .41565 .79762 L F P
0 g
s
1 0 0 r
.46217 .37101 m .39925 .4017 L .36081 .36437 L p F P
0 g
s
1 0 0 r
.29751 .40089 m .36081 .36437 L .39925 .4017 L p F P
0 g
s
1 0 0 r
.62557 .37267 m .56073 .393 L .52632 .34495 L p F P
0 g
s
1 0 0 r
.46217 .37101 m .52632 .34495 L .56073 .393 L p F P
0 g
s
0 1 0 r
.50739 .74185 m .57874 .73064 L .5724 .78612 L p F P
0 g
s
0 1 0 r
.50209 .77844 m .50739 .74185 L p .5724 .78612 L F P
0 g
s
0 1 0 r
.41565 .79762 m .36401 .79458 L .34064 .73982 L p F P
0 g
s
0 1 0 r
.36401 .79458 m .31709 .78551 L .34064 .73982 L closepath p F P
0 g
s
0 1 0 r
.63745 .64575 m .6299 .6181 L .69607 .6045 L p F P
0 g
s
0 1 0 r
.67173 .53154 m .69607 .6045 L .6299 .6181 L p F P
0 g
s
0 1 0 r
.6299 .6181 m .60926 .55648 L .67173 .53154 L p F P
0 g
s
0 1 0 r
.49683 .48822 m .4333 .52115 L .39613 .47344 L p F P
0 g
s
0 1 0 r
.33222 .51461 m .39613 .47344 L .4333 .52115 L p F P
0 g
s
0 1 0 r
.66162 .50795 m .67173 .53154 L .60926 .55648 L p F P
0 g
s
0 1 0 r
.60926 .55648 m .59572 .52556 L .66162 .50795 L p F P
0 g
s
0 1 0 r
.64655 .71424 m .63745 .64575 L .70125 .62318 L p F P
0 g
s
0 1 0 r
.69607 .6045 m .70125 .62318 L .63745 .64575 L p F P
0 g
s
0 1 0 r
.63745 .64575 m .64655 .71424 L .57874 .73064 L p F P
0 g
s
0 1 0 r
.5724 .78612 m .57874 .73064 L .64655 .71424 L p F P
0 g
s
0 1 0 r
.66162 .50795 m .59572 .52556 L .56155 .46235 L p F P
0 g
s
0 1 0 r
.49683 .48822 m .56155 .46235 L .59572 .52556 L p F P
0 g
s
1 0 0 r
.52632 .34495 m .46217 .37101 L .42494 .33254 L p F P
0 g
s
1 0 0 r
.36081 .36437 m .42494 .33254 L .46217 .37101 L p F P
0 g
s
1 0 0 r
.21286 .42945 m .23467 .44218 L .29751 .40089 L p F P
0 g
s
1 0 0 r
.7931 .4063 m .72436 .41581 L .69246 .35709 L p F P
0 g
s
1 0 0 r
.62557 .37267 m .69246 .35709 L .72436 .41581 L p F P
0 g
s
0 1 0 r
.56155 .46235 m .49683 .48822 L .46065 .43942 L p F P
0 g
s
0 1 0 r
.39613 .47344 m .46065 .43942 L .49683 .48822 L p F P
0 g
s
1 0 0 r
.84641 .54171 m .90229 .50011 L p .90239 .60293 L F P
0 g
s
1 0 0 r
.90239 .60293 m .85966 .58811 L .84641 .54171 L p F P
0 g
s
1 0 0 r
.89746 .48641 m .90229 .50011 L .84641 .54171 L p F P
0 g
s
1 0 0 r
.84641 .54171 m .82497 .4815 L .89746 .48641 L p F P
0 g
s
1 0 0 r
.69246 .35709 m .62557 .37267 L .59208 .32354 L p F P
0 g
s
1 0 0 r
.52632 .34495 m .59208 .32354 L .62557 .37267 L p F P
0 g
s
1 0 0 r
.37241 .90775 m .37829 .90342 L .4601 .90214 L p F P
0 g
s
1 0 0 r
.43527 .922 m .4601 .90214 L .53711 .89643 L p F P
0 g
s
1 0 0 r
.4601 .90214 m .43527 .922 L .37241 .90775 L p F P
0 g
s
1 0 0 r
.86525 .40521 m .89746 .48641 L .82497 .4815 L p F P
0 g
s
1 0 0 r
.83377 .40381 m .86525 .40521 L p .82497 .4815 L F P
0 g
s
1 0 0 r
.82497 .4815 m .80569 .43399 L .83377 .40381 L p F P
0 g
s
0 1 0 r
.5724 .78612 m .5236 .79351 L .50209 .77844 L p F P
0 g
s
0 1 0 r
.5236 .79351 m .49835 .79622 L .50209 .77844 L closepath p F P
0 g
s
0 1 0 r
.50209 .77844 m .49835 .79622 L .41565 .79762 L p F P
0 g
s
0 1 0 r
.30483 .53542 m .26755 .57357 L .22429 .54755 L p F P
0 g
s
0 1 0 r
.22429 .54755 m .28182 .48884 L .30483 .53542 L p F P
0 g
s
0 1 0 r
.29118 .48169 m .28182 .48884 L .30483 .53542 L p F P
0 g
s
0 1 0 r
.30483 .53542 m .33222 .51461 L .29118 .48169 L p F P
0 g
s
1 0 0 r
.36081 .36437 m .29751 .40089 L .25481 .37369 L p F P
0 g
s
1 0 0 r
.29751 .40089 m .25481 .37369 L p .21286 .42945 L F P
0 g
s
0 1 0 r
.70125 .62318 m .69607 .6045 L .74189 .60414 L closepath p F P
0 g
s
0 1 0 r
.74189 .60414 m .69607 .6045 L .67173 .53154 L p F P
0 g
s
0 1 0 r
.39613 .47344 m .33222 .51461 L .29118 .48169 L p F P
0 g
s
0 1 0 r
.7114 .69232 m .70125 .62318 L .74189 .60414 L p F P
0 g
s
0 1 0 r
.70125 .62318 m .7114 .69232 L .64655 .71424 L p F P
0 g
s
0 1 0 r
.64182 .76993 m .64655 .71424 L .7114 .69232 L p F P
0 g
s
0 1 0 r
.64655 .71424 m .64182 .76993 L .5724 .78612 L p F P
0 g
s
0 1 0 r
.67173 .53154 m .72989 .49767 L p .74189 .60414 L F P
0 g
s
0 1 0 r
.67173 .53154 m .66162 .50795 L .72989 .49767 L closepath p F P
0 g
s
1 0 0 r
.53711 .89643 m .60312 .89262 L .57426 .91957 L p F P
0 g
s
1 0 0 r
.501 .92769 m .53711 .89643 L p .57426 .91957 L F P
0 g
s
1 0 0 r
.53711 .89643 m .501 .92769 L .43527 .922 L p F P
0 g
s
1 0 0 r
.37241 .90775 m .43527 .922 L .41122 .93044 L p F P
0 g
s
1 0 0 r
.3303 .92118 m .37241 .90775 L p .41122 .93044 L F P
0 g
s
1 0 0 r
.59208 .32354 m .52632 .34495 L .49027 .30536 L p F P
0 g
s
1 0 0 r
.42494 .33254 m .49027 .30536 L .52632 .34495 L p F P
0 g
s
0 1 0 r
.72989 .49767 m .66162 .50795 L .628 .44358 L p F P
0 g
s
0 1 0 r
.56155 .46235 m .628 .44358 L .66162 .50795 L p F P
0 g
s
1 0 0 r
.80569 .43399 m .7931 .4063 L .83377 .40381 L closepath p F P
0 g
s
0 1 0 r
.628 .44358 m .56155 .46235 L .52632 .41245 L p F P
0 g
s
0 1 0 r
.46065 .43942 m .52632 .41245 L .56155 .46235 L p F P
0 g
s
0 1 0 r
.46065 .43942 m .39613 .47344 L .35651 .43924 L p F P
0 g
s
0 1 0 r
.29118 .48169 m .35651 .43924 L .39613 .47344 L p F P
0 g
s
0 1 0 r
.39929 .81286 m .41565 .79762 L .49835 .79622 L p F P
0 g
s
0 1 0 r
.39929 .81286 m .36401 .79458 L .41565 .79762 L closepath p F P
0 g
s
1 0 0 r
.42494 .33254 m .36081 .36437 L .31963 .33588 L p F P
0 g
s
1 0 0 r
.25481 .37369 m .31963 .33588 L .36081 .36437 L p F P
0 g
s
1 0 0 r
.19003 .41963 m .21791 .39813 L .21286 .42945 L closepath p F P
0 g
s
1 0 0 r
.25481 .37369 m .21791 .39813 L .21286 .42945 L p F P
0 g
s
0 1 0 r
.49835 .79622 m .5236 .79351 L p .5431 .82299 L F P
0 g
s
0 1 0 r
.5431 .82299 m .46409 .83129 L .49835 .79622 L p F P
0 g
s
0 1 0 r
.49835 .79622 m .46409 .83129 L .39929 .81286 L p F P
0 g
s
0 1 0 r
.36401 .79458 m .39929 .81286 L .36443 .82126 L p F P
0 g
s
0 1 0 r
.31709 .78551 m .36401 .79458 L p .36443 .82126 L F P
0 g
s
0 1 0 r
.56764 .79558 m .5236 .79351 L .5724 .78612 L closepath p F P
0 g
s
0 1 0 r
.5236 .79351 m .56764 .79558 L .5431 .82299 L p F P
0 g
s
1 0 0 r
.83377 .40381 m .7931 .4063 L .76187 .34637 L p F P
0 g
s
1 0 0 r
.69246 .35709 m .76187 .34637 L .7931 .4063 L p F P
0 g
s
1 0 0 r
.76187 .34637 m .69246 .35709 L .65991 .30684 L p F P
0 g
s
1 0 0 r
.59208 .32354 m .65991 .30684 L .69246 .35709 L p F P
0 g
s
0 1 0 r
.74189 .60414 m .76628 .61755 L p .7114 .69232 L F P
0 g
s
0 1 0 r
.76628 .61755 m .74189 .60414 L .76171 .59335 L closepath p F P
0 g
s
0 1 0 r
.72989 .49767 m .76171 .59335 L .74189 .60414 L p F P
0 g
s
1 0 0 r
.94075 .65586 m .92703 .58566 L .90239 .60293 L closepath p F P
0 g
s
1 0 0 r
.90229 .50011 m .92703 .58566 L .90239 .60293 L p F P
0 g
s
0 1 0 r
.56764 .79558 m .5724 .78612 L .64182 .76993 L p F P
0 g
s
0 1 0 r
.29512 .78993 m .31709 .78551 L p .36443 .82126 L F P
0 g
s
0 1 0 r
.52632 .41245 m .46065 .43942 L .4224 .404 L p F P
0 g
s
0 1 0 r
.35651 .43924 m .4224 .404 L .46065 .43942 L p F P
0 g
s
0 1 0 r
.7738 .66441 m .7114 .69232 L .70822 .74828 L p F P
0 g
s
0 1 0 r
.76628 .61755 m .7738 .66441 L .7114 .69232 L p F P
0 g
s
0 1 0 r
.7114 .69232 m .70822 .74828 L .64182 .76993 L p F P
0 g
s
1 0 0 r
.49027 .30536 m .42494 .33254 L .38524 .30281 L p F P
0 g
s
1 0 0 r
.31963 .33588 m .38524 .30281 L .42494 .33254 L p F P
0 g
s
1 0 0 r
.65991 .30684 m .59208 .32354 L .55724 .28285 L p F P
0 g
s
1 0 0 r
.49027 .30536 m .55724 .28285 L .59208 .32354 L p F P
0 g
s
1 0 0 r
.57426 .91957 m .60312 .89262 L .67097 .87971 L p F P
0 g
s
0 1 0 r
.76171 .59335 m .81686 .552 L p .79768 .65078 L F P
0 g
s
0 1 0 r
.79768 .65078 m .76628 .61755 L .76171 .59335 L p F P
0 g
s
0 1 0 r
.80242 .50843 m .81686 .552 L .76171 .59335 L p F P
0 g
s
0 1 0 r
.76171 .59335 m .72989 .49767 L .80242 .50843 L p F P
0 g
s
0 1 0 r
.628 .44358 m .69679 .43206 L .72989 .49767 L p F P
0 g
s
0 1 0 r
.69679 .43206 m .628 .44358 L .59368 .39256 L p F P
0 g
s
0 1 0 r
.52632 .41245 m .59368 .39256 L .628 .44358 L p F P
0 g
s
0 1 0 r
.72989 .49767 m .7741 .43939 L .80242 .50843 L closepath p F P
0 g
s
0 1 0 r
.76859 .42808 m .7741 .43939 L .72989 .49767 L p F P
0 g
s
0 1 0 r
.72989 .49767 m .69679 .43206 L .76859 .42808 L p F P
0 g
s
1 0 0 r
.86525 .40521 m .83377 .40381 L .84975 .3716 L closepath p F P
0 g
s
1 0 0 r
.83434 .34073 m .84975 .3716 L .83377 .40381 L p F P
0 g
s
1 0 0 r
.76187 .34637 m .83434 .34073 L p .83377 .40381 L F P
0 g
s
0 1 0 r
.64182 .76993 m .63538 .78414 L .56764 .79558 L p F P
0 g
s
0 1 0 r
.5431 .82299 m .56764 .79558 L .63538 .78414 L p F P
0 g
s
1 0 0 r
.21791 .39813 m .19003 .41963 L .14009 .41484 L p F P
0 g
s
0 1 0 r
.7738 .66441 m .76628 .61755 L .79768 .65078 L closepath p F P
0 g
s
1 0 0 r
.41122 .93044 m .43527 .922 L .501 .92769 L p F P
0 g
s
1 0 0 r
.23658 .36674 m .21791 .39813 L p .14009 .41484 L F P
0 g
s
1 0 0 r
.21791 .39813 m .23658 .36674 L .25481 .37369 L closepath p F P
0 g
s
0 1 0 r
.36443 .82126 m .39929 .81286 L .46409 .83129 L closepath p F P
0 g
s
0 1 0 r
.63538 .78414 m .64182 .76993 L .70822 .74828 L p F P
0 g
s
0 1 0 r
.28182 .48884 m .28391 .47867 L p .20029 .54759 L F P
0 g
s
0 1 0 r
.20029 .54759 m .22429 .54755 L .28182 .48884 L p F P
0 g
s
0 1 0 r
.28182 .48884 m .28391 .47867 L .29118 .48169 L closepath p F P
0 g
s
0 1 0 r
.28391 .47867 m .29118 .48169 L .35651 .43924 L p F P
0 g
s
0 1 0 r
.59368 .39256 m .52632 .41245 L .48937 .37589 L p F P
0 g
s
0 1 0 r
.4224 .404 m .48937 .37589 L .52632 .41245 L p F P
0 g
s
1 0 0 r
.23658 .36674 m .25481 .37369 L .31963 .33588 L p F P
0 g
s
1 0 0 r
.83434 .34073 m .76187 .34637 L .73028 .29499 L p F P
0 g
s
1 0 0 r
.65991 .30684 m .73028 .29499 L .76187 .34637 L p F P
0 g
s
1 0 0 r
.55724 .28285 m .49027 .30536 L .45206 .27445 L p F P
0 g
s
1 0 0 r
.38524 .30281 m .45206 .27445 L .49027 .30536 L p F P
0 g
s
0 1 0 r
.24515 .47654 m .28391 .47867 L .3136 .41908 L closepath p F P
0 g
s
0 1 0 r
.35651 .43924 m .3136 .41908 L .28391 .47867 L p F P
0 g
s
0 1 0 r
.28391 .47867 m .24515 .47654 L p .20029 .54759 L F P
0 g
s
1 0 0 r
.64654 .90425 m .67097 .87971 L .7402 .85741 L p F P
0 g
s
1 0 0 r
.67097 .87971 m .64654 .90425 L .57426 .91957 L p F P
0 g
s
1 0 0 r
.73028 .29499 m .65991 .30684 L .62628 .26506 L p F P
0 g
s
1 0 0 r
.55724 .28285 m .62628 .26506 L .65991 .30684 L p F P
0 g
s
0 1 0 r
.3136 .41908 m .35651 .43924 L .4224 .404 L p F P
0 g
s
0 1 0 r
.77271 .70161 m .79768 .65078 L .7738 .66441 L closepath p F P
0 g
s
0 1 0 r
.77271 .70161 m .7738 .66441 L p .70822 .74828 L F P
0 g
s
0 1 0 r
.36443 .82126 m .34811 .81816 L .29512 .78993 L p F P
0 g
s
0 1 0 r
.34811 .81816 m .29512 .78993 L .25117 .76929 L p F P
0 g
s
1 0 0 r
.27956 .31866 m .31963 .33588 L .38524 .30281 L p F P
0 g
s
1 0 0 r
.31963 .33588 m .27956 .31866 L .23658 .36674 L p F P
0 g
s
0 1 0 r
.76859 .42808 m .69679 .43206 L .66336 .37992 L p F P
0 g
s
0 1 0 r
.59368 .39256 m .66336 .37992 L .69679 .43206 L p F P
0 g
s
0 1 0 r
.70822 .74828 m .7044 .75768 L .63538 .78414 L p F P
0 g
s
0 1 0 r
.61604 .80757 m .63538 .78414 L .7044 .75768 L p F P
0 g
s
0 1 0 r
.63538 .78414 m .61604 .80757 L .5431 .82299 L p F P
0 g
s
1 0 0 r
.41122 .93044 m .35749 .92756 L .3303 .92118 L p F P
0 g
s
1 0 0 r
.35749 .92756 m .30863 .91899 L .3303 .92118 L closepath p F P
0 g
s
1 0 0 r
.91756 .72883 m .94338 .71223 L .94075 .65586 L closepath p F P
0 g
s
0 1 0 r
.7044 .75768 m .75058 .73 L .70822 .74828 L closepath p F P
0 g
s
0 1 0 r
.70822 .74828 m .75058 .73 L .77271 .70161 L p F P
0 g
s
0 1 0 r
.66336 .37992 m .59368 .39256 L .55803 .35493 L p F P
0 g
s
0 1 0 r
.48937 .37589 m .55803 .35493 L .59368 .39256 L p F P
0 g
s
1 0 0 r
.20756 .36265 m .23658 .36674 L .27956 .31866 L p F P
0 g
s
1 0 0 r
.14009 .41484 m .20756 .36265 L .23658 .36674 L p F P
0 g
s
0 1 0 r
.48937 .37589 m .4224 .404 L .38125 .3825 L p F P
0 g
s
0 1 0 r
.4224 .404 m .38125 .3825 L .3136 .41908 L p F P
0 g
s
0 1 0 r
.79768 .65078 m .83175 .62653 L p .77127 .71962 L F P
0 g
s
0 1 0 r
.77127 .71962 m .77271 .70161 L .79768 .65078 L p F P
0 g
s
0 1 0 r
.81686 .552 m .83175 .62653 L .79768 .65078 L p F P
0 g
s
1 0 0 r
.62628 .26506 m .55724 .28285 L .52052 .2508 L p F P
0 g
s
1 0 0 r
.45206 .27445 m .52052 .2508 L .55724 .28285 L p F P
0 g
s
1 0 0 r
.57426 .91957 m .52349 .92655 L .501 .92769 L p F P
0 g
s
1 0 0 r
.52349 .92655 m .49723 .92912 L .501 .92769 L closepath p F P
0 g
s
1 0 0 r
.501 .92769 m .49723 .92912 L .41122 .93044 L p F P
0 g
s
1 0 0 r
.71576 .88375 m .7402 .85741 L .81029 .82558 L p F P
0 g
s
1 0 0 r
.7402 .85741 m .71576 .88375 L .64654 .90425 L p F P
0 g
s
0 1 0 r
.84628 .52264 m .81686 .552 L .83175 .62653 L p F P
0 g
s
0 1 0 r
.81686 .552 m .80242 .50843 L .84628 .52264 L closepath p F P
0 g
s
0 1 0 r
.84628 .52264 m .80242 .50843 L .7741 .43939 L p F P
0 g
s
1 0 0 r
.39478 .93093 m .41122 .93044 L .49723 .92912 L p F P
0 g
s
1 0 0 r
.39478 .93093 m .35749 .92756 L .41122 .93044 L closepath p F P
0 g
s
1 0 0 r
.45206 .27445 m .38524 .30281 L .34238 .28227 L p F P
0 g
s
1 0 0 r
.38524 .30281 m .34238 .28227 L p .27956 .31866 L F P
0 g
s
0 1 0 r
.17053 .58993 m .20533 .51711 L .20029 .54759 L closepath p F P
0 g
s
0 1 0 r
.24515 .47654 m .20533 .51711 L .20029 .54759 L p F P
0 g
s
1 0 0 r
.49723 .92912 m .46225 .93021 L .39478 .93093 L p F P
0 g
s
1 0 0 r
.46225 .93021 m .49723 .92912 L .52349 .92655 L p F P
0 g
s
1 0 0 r
.73028 .29499 m .80376 .28818 L .83434 .34073 L p F P
0 g
s
0 1 0 r
.68379 .78457 m .7044 .75768 L .75058 .73 L p F P
0 g
s
0 1 0 r
.7044 .75768 m .68379 .78457 L .61604 .80757 L p F P
0 g
s
1 0 0 r
.35749 .92756 m .39478 .93093 L p .28654 .91271 L F P
0 g
s
1 0 0 r
.28654 .91271 m .30863 .91899 L .35749 .92756 L p F P
0 g
s
0 1 0 r
.53207 .82616 m .46409 .83129 L .5431 .82299 L closepath p F P
0 g
s
0 1 0 r
.42404 .82382 m .46409 .83129 L .53207 .82616 L p F P
0 g
s
0 1 0 r
.35735 .81999 m .34811 .81816 L .36443 .82126 L closepath p F P
0 g
s
0 1 0 r
.46409 .83129 m .42404 .82382 L .35735 .81999 L p F P
0 g
s
0 1 0 r
.35735 .81999 m .36443 .82126 L .46409 .83129 L p F P
0 g
s
1 0 0 r
.56921 .92159 m .52349 .92655 L .57426 .91957 L closepath p F P
0 g
s
1 0 0 r
.52349 .92655 m .56921 .92159 L p .46225 .93021 L F P
0 g
s
0 1 0 r
.75058 .73 m .77127 .71962 L .77271 .70161 L closepath p F P
0 g
s
1 0 0 r
.80376 .28818 m .73028 .29499 L .69793 .25212 L p F P
0 g
s
1 0 0 r
.62628 .26506 m .69793 .25212 L .73028 .29499 L p F P
0 g
s
0 1 0 r
.75058 .73 m .77127 .71962 L p .68379 .78457 L F P
0 g
s
1 0 0 r
.78448 .85536 m .81029 .82558 L .8728 .79396 L p F P
0 g
s
1 0 0 r
.81029 .82558 m .87912 .76938 L .8728 .79396 L closepath p F P
0 g
s
1 0 0 r
.81029 .82558 m .78448 .85536 L p .71576 .88375 L F P
0 g
s
1 0 0 r
.91756 .72883 m .94338 .71223 L p .8728 .79396 L F P
0 g
s
1 0 0 r
.8728 .79396 m .87912 .76938 L .91756 .72883 L p F P
0 g
s
0 1 0 r
.55803 .35493 m .48937 .37589 L .44997 .35318 L p F P
0 g
s
0 1 0 r
.38125 .3825 m .44997 .35318 L .48937 .37589 L p F P
0 g
s
0 1 0 r
.7741 .43939 m .77918 .42863 L p .84628 .52264 L F P
0 g
s
0 1 0 r
.7741 .43939 m .76859 .42808 L .77918 .42863 L closepath p F P
0 g
s
1 0 0 r
.56921 .92159 m .57426 .91957 L .64654 .90425 L p F P
0 g
s
0 1 0 r
.53207 .82616 m .5431 .82299 L .61604 .80757 L p F P
0 g
s
0 1 0 r
.77918 .42863 m .76859 .42808 L .73607 .37478 L p F P
0 g
s
0 1 0 r
.66336 .37992 m .73607 .37478 L .76859 .42808 L p F P
0 g
s
0 1 0 r
.88507 .57609 m .83175 .62653 L .82896 .67985 L p F P
0 g
s
0 1 0 r
.83175 .62653 m .88507 .57609 L .84628 .52264 L p F P
0 g
s
0 1 0 r
.83175 .62653 m .82896 .67985 L .77127 .71962 L p F P
0 g
s
0 1 0 r
.34811 .81816 m .35735 .81999 L .31437 .79348 L p F P
0 g
s
0 1 0 r
.25117 .76929 m .28649 .78816 L .34811 .81816 L p F P
0 g
s
0 1 0 r
.31437 .79348 m .28649 .78816 L .34811 .81816 L p F P
0 g
s
0 1 0 r
.73607 .37478 m .66336 .37992 L .62902 .34126 L p F P
0 g
s
0 1 0 r
.55803 .35493 m .62902 .34126 L .66336 .37992 L p F P
0 g
s
1 0 0 r
.52052 .2508 m .45206 .27445 L .41101 .25265 L p F P
0 g
s
1 0 0 r
.34238 .28227 m .41101 .25265 L .45206 .27445 L p F P
0 g
s
1 0 0 r
.69793 .25212 m .62628 .26506 L .59111 .23193 L p F P
0 g
s
1 0 0 r
.52052 .2508 m .59111 .23193 L .62628 .26506 L p F P
0 g
s
0 1 0 r
.74715 .75325 m .77127 .71962 L .82896 .67985 L p F P
0 g
s
0 1 0 r
.77127 .71962 m .74715 .75325 L .68379 .78457 L p F P
0 g
s
1 0 0 r
.46225 .93021 m .39478 .93093 L .35236 .91848 L p F P
0 g
s
1 0 0 r
.39478 .93093 m .35236 .91848 L .28654 .91271 L p F P
0 g
s
0 1 0 r
.77918 .42863 m .84595 .44843 L p .84628 .52264 L F P
0 g
s
0 1 0 r
.77918 .42863 m .84595 .44843 L .81368 .38852 L p F P
0 g
s
0 1 0 r
.81368 .38852 m .76843 .37596 L .77918 .42863 L p F P
0 g
s
0 1 0 r
.73607 .37478 m .76843 .37596 L .77918 .42863 L p F P
0 g
s
1 0 0 r
.64654 .90425 m .63945 .90721 L .56921 .92159 L p F P
0 g
s
1 0 0 r
.63945 .90721 m .56921 .92159 L .53224 .92256 L p F P
0 g
s
1 0 0 r
.56921 .92159 m .53224 .92256 L .46225 .93021 L p F P
0 g
s
1 0 0 r
.13234 .41641 m .14009 .41484 L .20756 .36265 L p F P
0 g
s
0 1 0 r
.42404 .82382 m .35735 .81999 L .31437 .79348 L p F P
0 g
s
0 1 0 r
.88507 .57609 m .86314 .49125 L .84628 .52264 L closepath p F P
0 g
s
0 1 0 r
.84595 .44843 m .86314 .49125 L .84628 .52264 L p F P
0 g
s
0 1 0 r
.28649 .78816 m .25117 .76929 L .20757 .71728 L p F P
0 g
s
0 1 0 r
.22455 .48651 m .24515 .47654 L .3136 .41908 L p F P
0 g
s
0 1 0 r
.20533 .51711 m .22455 .48651 L .24515 .47654 L closepath p F P
0 g
s
1 0 0 r
.27956 .31866 m .27486 .31779 L .20756 .36265 L p F P
0 g
s
1 0 0 r
.1737 .36839 m .20756 .36265 L .27486 .31779 L p F P
0 g
s
1 0 0 r
.20756 .36265 m .1737 .36839 L .13234 .41641 L p F P
0 g
s
1 0 0 r
.94338 .71223 m .93411 .75551 L .8728 .79396 L p F P
0 g
s
0 1 0 r
.22455 .48651 m .20533 .51711 L .17053 .58993 L p F P
0 g
s
0 1 0 r
.26904 .43958 m .3136 .41908 L .36812 .38059 L p F P
0 g
s
0 1 0 r
.3136 .41908 m .36812 .38059 L .38125 .3825 L closepath p F P
0 g
s
0 1 0 r
.3136 .41908 m .26904 .43958 L .22455 .48651 L p F P
0 g
s
0 1 0 r
.61604 .80757 m .60224 .81162 L .53207 .82616 L p F P
0 g
s
0 1 0 r
.60224 .81162 m .61604 .80757 L .68379 .78457 L p F P
0 g
s
1 0 0 r
.63945 .90721 m .64654 .90425 L .71576 .88375 L p F P
0 g
s
0 1 0 r
.60224 .81162 m .53207 .82616 L .49359 .81838 L p F P
0 g
s
0 1 0 r
.53207 .82616 m .49359 .81838 L .42404 .82382 L p F P
0 g
s
1 0 0 r
.1737 .36839 m .13234 .41641 L .09257 .44868 L p F P
0 g
s
1 0 0 r
.27486 .31779 m .29728 .30529 L .27956 .31866 L closepath p F P
0 g
s
1 0 0 r
.34238 .28227 m .29728 .30529 L .27956 .31866 L p F P
0 g
s
0 1 0 r
.55803 .35493 m .62902 .34126 L .5931 .31659 L p F P
0 g
s
0 1 0 r
.5931 .31659 m .52035 .33117 L .55803 .35493 L p F P
0 g
s
0 1 0 r
.44997 .35318 m .52035 .33117 L .55803 .35493 L p F P
0 g
s
1 0 0 r
.35236 .91848 m .28654 .91271 L .24141 .88583 L p F P
0 g
s
1 0 0 r
.69793 .25212 m .77274 .24424 L .80376 .28818 L p F P
0 g
s
1 0 0 r
.22405 .32488 m .27486 .31779 L .29728 .30529 L p F P
0 g
s
1 0 0 r
.27486 .31779 m .22405 .32488 L .1737 .36839 L p F P
0 g
s
1 0 0 r
.52052 .2508 m .59111 .23193 L .55764 .21036 L p F P
0 g
s
1 0 0 r
.48131 .22783 m .52052 .2508 L p .55764 .21036 L F P
0 g
s
1 0 0 r
.41101 .25265 m .48131 .22783 L .52052 .2508 L p F P
0 g
s
1 0 0 r
.29728 .30529 m .33591 .2808 L p .22405 .32488 L F P
0 g
s
1 0 0 r
.29728 .30529 m .33591 .2808 L .34238 .28227 L closepath p F P
0 g
s
1 0 0 r
.71576 .88375 m .71136 .88563 L .63945 .90721 L p F P
0 g
s
1 0 0 r
.71136 .88563 m .63945 .90721 L .60443 .90768 L p F P
0 g
s
1 0 0 r
.53224 .92256 m .60443 .90768 L .63945 .90721 L p F P
0 g
s
0 1 0 r
.36812 .38059 m .38125 .3825 L .44997 .35318 L p F P
0 g
s
1 0 0 r
.85791 .81232 m .8728 .79396 L .93411 .75551 L p F P
0 g
s
1 0 0 r
.8728 .79396 m .85791 .81232 L .78448 .85536 L p F P
0 g
s
1 0 0 r
.69793 .25212 m .77274 .24424 L .75705 .22694 L p F P
0 g
s
1 0 0 r
.66435 .21795 m .69793 .25212 L p .75705 .22694 L F P
0 g
s
1 0 0 r
.59111 .23193 m .66435 .21795 L .69793 .25212 L p F P
0 g
s
1 0 0 r
.53224 .92256 m .46225 .93021 L .42117 .9175 L p F P
0 g
s
1 0 0 r
.35236 .91848 m .42117 .9175 L .46225 .93021 L p F P
0 g
s
0 1 0 r
.76843 .37596 m .73607 .37478 L .70307 .33517 L p F P
0 g
s
0 1 0 r
.62902 .34126 m .70307 .33517 L .73607 .37478 L p F P
0 g
s
0 1 0 r
.28649 .78816 m .31437 .79348 L .2704 .74673 L p F P
0 g
s
0 1 0 r
.2704 .74673 m .26098 .74506 L .28649 .78816 L p F P
0 g
s
0 1 0 r
.20757 .71728 m .26098 .74506 L .28649 .78816 L p F P
0 g
s
0 1 0 r
.18668 .67559 m .19167 .64621 L .17053 .58993 L closepath p F P
0 g
s
0 1 0 r
.20404 .53715 m .17053 .58993 L .19167 .64621 L p F P
0 g
s
0 1 0 r
.17053 .58993 m .20404 .53715 L .22455 .48651 L p F P
0 g
s
1 0 0 r
.33591 .2808 m .34238 .28227 L .41101 .25265 L p F P
0 g
s
0 1 0 r
.68379 .78457 m .67412 .78737 L .60224 .81162 L p F P
0 g
s
0 1 0 r
.67412 .78737 m .60224 .81162 L .56558 .80322 L p F P
0 g
s
0 1 0 r
.49359 .81838 m .56558 .80322 L .60224 .81162 L p F P
0 g
s
1 0 0 r
.71136 .88563 m .76001 .86642 L .71576 .88375 L closepath p F P
0 g
s
1 0 0 r
.78448 .85536 m .76001 .86642 L .71576 .88375 L p F P
0 g
s
0 1 0 r
.67412 .78737 m .74715 .75325 L .68379 .78457 L closepath p F P
0 g
s
0 1 0 r
.49359 .81838 m .42404 .82382 L .38205 .79686 L p F P
0 g
s
0 1 0 r
.31437 .79348 m .38205 .79686 L .42404 .82382 L p F P
0 g
s
0 1 0 r
.26904 .43958 m .22455 .48651 L .20404 .53715 L p F P
0 g
s
0 1 0 r
.26098 .74506 m .20757 .71728 L .18668 .67559 L p F P
0 g
s
0 1 0 r
.81936 .69404 m .85985 .65154 L .82896 .67985 L closepath p F P
0 g
s
0 1 0 r
.82896 .67985 m .85985 .65154 L .88507 .57609 L p F P
0 g
s
0 1 0 r
.82896 .67985 m .81936 .69404 L .74715 .75325 L p F P
0 g
s
0 1 0 r
.5931 .31659 m .62902 .34126 L .70307 .33517 L p F P
0 g
s
0 1 0 r
.33495 .39538 m .36812 .38059 L .43325 .35014 L p F P
0 g
s
0 1 0 r
.44997 .35318 m .43325 .35014 L .36812 .38059 L p F P
0 g
s
0 1 0 r
.36812 .38059 m .33495 .39538 L p .26904 .43958 L F P
0 g
s
1 0 0 r
.29435 .28547 m .33591 .2808 L .40173 .25017 L p F P
0 g
s
1 0 0 r
.41101 .25265 m .40173 .25017 L .33591 .2808 L p F P
0 g
s
1 0 0 r
.33591 .2808 m .29435 .28547 L .22405 .32488 L p F P
0 g
s
0 1 0 r
.43325 .35014 m .44997 .35318 L .52035 .33117 L p F P
0 g
s
1 0 0 r
.76001 .86642 m .71136 .88563 L .6785 .88533 L p F P
0 g
s
1 0 0 r
.60443 .90768 m .6785 .88533 L .71136 .88563 L p F P
0 g
s
0 1 0 r
.18668 .67559 m .19167 .64621 L p .26098 .74506 L F P
0 g
s
0 1 0 r
.85985 .65154 m .87769 .62125 L .88507 .57609 L closepath p F P
0 g
s
0 1 0 r
.76843 .37596 m .81368 .38852 L .78251 .35377 L p F P
0 g
s
0 1 0 r
.78251 .35377 m .71398 .33544 L .76843 .37596 L p F P
0 g
s
0 1 0 r
.70307 .33517 m .71398 .33544 L .76843 .37596 L p F P
0 g
s
0 1 0 r
.38205 .79686 m .31437 .79348 L .2704 .74673 L p F P
0 g
s
1 0 0 r
.55764 .21036 m .59111 .23193 L .66435 .21795 L p F P
0 g
s
1 0 0 r
.42117 .9175 m .35236 .91848 L .30812 .89119 L p F P
0 g
s
1 0 0 r
.24141 .88583 m .30812 .89119 L .35236 .91848 L p F P
0 g
s
1 0 0 r
.15227 .38548 m .1737 .36839 L .22405 .32488 L closepath p F P
0 g
s
1 0 0 r
.15227 .38548 m .1737 .36839 L p .09257 .44868 L F P
0 g
s
0 1 0 r
.74715 .75325 m .67412 .78737 L .63949 .77802 L p F P
0 g
s
0 1 0 r
.56558 .80322 m .63949 .77802 L .67412 .78737 L p F P
0 g
s
1 0 0 r
.40173 .25017 m .41101 .25265 L .48131 .22783 L p F P
0 g
s
1 0 0 r
.78163 .85659 m .76001 .86642 L p .6785 .88533 L F P
0 g
s
1 0 0 r
.76001 .86642 m .78163 .85659 L .78448 .85536 L closepath p F P
0 g
s
1 0 0 r
.60443 .90768 m .53224 .92256 L .4927 .90938 L p F P
0 g
s
1 0 0 r
.42117 .9175 m .4927 .90938 L .53224 .92256 L p F P
0 g
s
1 0 0 r
.78163 .85659 m .78448 .85536 L .85791 .81232 L p F P
0 g
s
1 0 0 r
.30812 .89119 m .24141 .88583 L .19512 .84357 L p F P
0 g
s
0 1 0 r
.56558 .80322 m .49359 .81838 L .45285 .79077 L p F P
0 g
s
0 1 0 r
.38205 .79686 m .45285 .79077 L .49359 .81838 L p F P
0 g
s
1 0 0 r
.75404 .85535 m .78163 .85659 L .84212 .8188 L p F P
0 g
s
1 0 0 r
.85791 .81232 m .84212 .8188 L .78163 .85659 L p F P
0 g
s
1 0 0 r
.6785 .88533 m .75404 .85535 L .78163 .85659 L p F P
0 g
s
1 0 0 r
.93411 .75551 m .93119 .75935 L .85791 .81232 L p F P
0 g
s
0 1 0 r
.5931 .31659 m .50852 .32859 L .52035 .33117 L closepath p F P
0 g
s
0 1 0 r
.52035 .33117 m .50852 .32859 L .43325 .35014 L p F P
0 g
s
1 0 0 r
.36557 .25337 m .40173 .25017 L .47545 .22601 L p F P
0 g
s
1 0 0 r
.48131 .22783 m .47545 .22601 L .40173 .25017 L p F P
0 g
s
1 0 0 r
.40173 .25017 m .36557 .25337 L .29435 .28547 L p F P
0 g
s
0 1 0 r
.43325 .35014 m .40646 .36204 L .33495 .39538 L p F P
0 g
s
0 1 0 r
.40646 .36204 m .43325 .35014 L .50852 .32859 L p F P
0 g
s
0 1 0 r
.71474 .74261 m .74715 .75325 L .79586 .6991 L p F P
0 g
s
0 1 0 r
.74715 .75325 m .81936 .69404 L .79586 .6991 L closepath p F P
0 g
s
0 1 0 r
.63949 .77802 m .71474 .74261 L .74715 .75325 L p F P
0 g
s
0 1 0 r
.85985 .65154 m .87769 .62125 L p .79586 .6991 L F P
0 g
s
0 1 0 r
.79586 .6991 m .81936 .69404 L .85985 .65154 L p F P
0 g
s
1 0 0 r
.09257 .44868 m .11025 .428 L .15227 .38548 L p F P
0 g
s
1 0 0 r
.07214 .50323 m .11025 .428 L .09257 .44868 L closepath p F P
0 g
s
1 0 0 r
.84212 .8188 m .85791 .81232 L .93119 .75935 L p F P
0 g
s
0 1 0 r
.19167 .64621 m .22757 .66377 L p .26098 .74506 L F P
0 g
s
0 1 0 r
.22757 .66377 m .19167 .64621 L .21147 .61667 L closepath p F P
0 g
s
0 1 0 r
.19167 .64621 m .21147 .61667 L .20404 .53715 L p F P
0 g
s
0 1 0 r
.71398 .33544 m .69755 .33105 L .70307 .33517 L closepath p F P
0 g
s
0 1 0 r
.70307 .33517 m .69755 .33105 L .5931 .31659 L p F P
0 g
s
1 0 0 r
.93119 .75935 m .90735 .76819 L p .84212 .8188 L F P
0 g
s
1 0 0 r
.55764 .21036 m .52935 .2146 L .48131 .22783 L p F P
0 g
s
1 0 0 r
.52935 .2146 m .47545 .22601 L .48131 .22783 L closepath p F P
0 g
s
0 1 0 r
.2704 .74673 m .26098 .74506 L .26312 .73563 L closepath p F P
0 g
s
0 1 0 r
.22757 .66377 m .26312 .73563 L .26098 .74506 L p F P
0 g
s
1 0 0 r
.75705 .22694 m .70767 .21293 L .66435 .21795 L p F P
0 g
s
1 0 0 r
.70767 .21293 m .65052 .20816 L .66435 .21795 L closepath p F P
0 g
s
1 0 0 r
.66435 .21795 m .65052 .20816 L .55764 .21036 L p F P
0 g
s
0 1 0 r
.33495 .39538 m .28744 .42651 L .26904 .43958 L p F P
0 g
s
0 1 0 r
.26259 .45613 m .28744 .42651 L .26904 .43958 L closepath p F P
0 g
s
0 1 0 r
.26259 .45613 m .26904 .43958 L p .20404 .53715 L F P
0 g
s
1 0 0 r
.4927 .90938 m .42117 .9175 L .37802 .88965 L p F P
0 g
s
1 0 0 r
.30812 .89119 m .37802 .88965 L .42117 .9175 L p F P
0 g
s
1 0 0 r
.6785 .88533 m .60443 .90768 L .56665 .89381 L p F P
0 g
s
1 0 0 r
.4927 .90938 m .56665 .89381 L .60443 .90768 L p F P
0 g
s
0 1 0 r
.45285 .79077 m .38205 .79686 L .33871 .74918 L p F P
0 g
s
0 1 0 r
.2704 .74673 m .33871 .74918 L .38205 .79686 L p F P
0 g
s
0 1 0 r
.71398 .33544 m .78251 .35377 L .76738 .34976 L p F P
0 g
s
0 1 0 r
.69755 .33105 m .71398 .33544 L p .76738 .34976 L F P
0 g
s
0 1 0 r
.21147 .61667 m .20404 .53715 L .2309 .50929 L p F P
0 g
s
0 1 0 r
.20404 .53715 m .2309 .50929 L .26259 .45613 L p F P
0 g
s
0 1 0 r
.29469 .68017 m .33871 .74918 L .2704 .74673 L p F P
0 g
s
0 1 0 r
.2704 .74673 m .26312 .73563 L .29469 .68017 L p F P
0 g
s
0 1 0 r
.5931 .31659 m .69755 .33105 L .66968 .32366 L closepath p F P
0 g
s
0 1 0 r
.66968 .32366 m .69755 .33105 L p .76738 .34976 L F P
0 g
s
1 0 0 r
.74113 .21248 m .70767 .21293 L .75705 .22694 L closepath p F P
0 g
s
0 1 0 r
.50852 .32859 m .5931 .31659 L .55905 .33348 L p F P
0 g
s
0 1 0 r
.47944 .34194 m .50852 .32859 L p .55905 .33348 L F P
0 g
s
0 1 0 r
.50852 .32859 m .47944 .34194 L .40646 .36204 L p F P
0 g
s
1 0 0 r
.47545 .22601 m .52935 .2146 L p .51351 .21123 L F P
0 g
s
1 0 0 r
.51351 .21123 m .43838 .22858 L .47545 .22601 L p F P
0 g
s
1 0 0 r
.47545 .22601 m .43838 .22858 L .36557 .25337 L p F P
0 g
s
0 1 0 r
.26312 .73563 m .22757 .66377 L .29469 .68017 L closepath p F P
0 g
s
0 1 0 r
.63949 .77802 m .56558 .80322 L .52632 .77472 L p F P
0 g
s
0 1 0 r
.45285 .79077 m .52632 .77472 L .56558 .80322 L p F P
0 g
s
0 1 0 r
.28744 .42651 m .32763 .40255 L p .25201 .49285 L F P
0 g
s
0 1 0 r
.25201 .49285 m .26259 .45613 L .28744 .42651 L p F P
0 g
s
0 1 0 r
.28744 .42651 m .32763 .40255 L .33495 .39538 L closepath p F P
0 g
s
1 0 0 r
.37802 .88965 m .30812 .89119 L .26245 .84815 L p F P
0 g
s
1 0 0 r
.19512 .84357 m .26245 .84815 L .30812 .89119 L p F P
0 g
s
0 1 0 r
.2309 .50929 m .25201 .49285 L .26259 .45613 L closepath p F P
0 g
s
1 0 0 r
.55379 .209 m .52935 .2146 L .55764 .21036 L closepath p F P
0 g
s
1 0 0 r
.52935 .2146 m .55379 .209 L .51351 .21123 L p F P
0 g
s
0 1 0 r
.55905 .33348 m .5931 .31659 L .66968 .32366 L p F P
0 g
s
1 0 0 r
.70767 .21293 m .74113 .21248 L p .62927 .19978 L F P
0 g
s
1 0 0 r
.62927 .19978 m .65052 .20816 L .70767 .21293 L p F P
0 g
s
0 1 0 r
.32763 .40255 m .33495 .39538 L .40646 .36204 L p F P
0 g
s
1 0 0 r
.21583 .78873 m .26245 .84815 L .19512 .84357 L p F P
0 g
s
1 0 0 r
.1768 .78678 m .21583 .78873 L p .19512 .84357 L F P
0 g
s
1 0 0 r
.19512 .84357 m .17187 .81475 L .1768 .78678 L p F P
0 g
s
1 0 0 r
.55379 .209 m .55764 .21036 L .65052 .20816 L p F P
0 g
s
0 1 0 r
.87769 .62125 m .86474 .6228 L p .79586 .6991 L F P
0 g
s
1 0 0 r
.75404 .85535 m .6785 .88533 L .64267 .87053 L p F P
0 g
s
1 0 0 r
.56665 .89381 m .64267 .87053 L .6785 .88533 L p F P
0 g
s
1 0 0 r
.65052 .20816 m .62927 .19978 L .55379 .209 L p F P
0 g
s
0 1 0 r
.25758 .57127 m .29469 .68017 L .22757 .66377 L p F P
0 g
s
0 1 0 r
.22757 .66377 m .21147 .61667 L .25758 .57127 L p F P
0 g
s
0 1 0 r
.2548 .54399 m .25758 .57127 L .21147 .61667 L p F P
0 g
s
0 1 0 r
.2309 .50929 m .2548 .54399 L p .21147 .61667 L F P
0 g
s
1 0 0 r
.51351 .21123 m .55379 .209 L .62927 .19978 L p F P
0 g
s
1 0 0 r
.56665 .89381 m .4927 .90938 L .45085 .88081 L p F P
0 g
s
1 0 0 r
.37802 .88965 m .45085 .88081 L .4927 .90938 L p F P
0 g
s
0 1 0 r
.2548 .54399 m .2309 .50929 L .25201 .49285 L closepath p F P
0 g
s
0 1 0 r
.71474 .74261 m .63949 .77802 L .60192 .7484 L p F P
0 g
s
0 1 0 r
.52632 .77472 m .60192 .7484 L .63949 .77802 L p F P
0 g
s
1 0 0 r
.83064 .81769 m .87461 .79186 L .84212 .8188 L closepath p F P
0 g
s
1 0 0 r
.90735 .76819 m .87461 .79186 L .84212 .8188 L p F P
0 g
s
1 0 0 r
.84212 .8188 m .83064 .81769 L .75404 .85535 L p F P
0 g
s
0 1 0 r
.52632 .77472 m .45285 .79077 L .41037 .74205 L p F P
0 g
s
0 1 0 r
.33871 .74918 m .41037 .74205 L .45285 .79077 L p F P
0 g
s
0 1 0 r
.31326 .45725 m .32763 .40255 L .39622 .37254 L p F P
0 g
s
0 1 0 r
.40646 .36204 m .39622 .37254 L .32763 .40255 L p F P
0 g
s
0 1 0 r
.32763 .40255 m .31326 .45725 L .25201 .49285 L p F P
0 g
s
1 0 0 r
.07336 .58008 m .09159 .56005 L .07214 .50323 L closepath p F P
0 g
s
1 0 0 r
.17187 .81475 m .14864 .7812 L .1768 .78678 L closepath p F P
0 g
s
1 0 0 r
.74113 .21248 m .70865 .19834 L .62927 .19978 L p F P
0 g
s
0 1 0 r
.39622 .37254 m .40646 .36204 L .47944 .34194 L p F P
0 g
s
0 1 0 r
.36679 .67157 m .41037 .74205 L .33871 .74918 L p F P
0 g
s
0 1 0 r
.33871 .74918 m .29469 .68017 L .36679 .67157 L p F P
0 g
s
1 0 0 r
.83064 .81769 m .75404 .85535 L .72033 .83938 L p F P
0 g
s
1 0 0 r
.64267 .87053 m .72033 .83938 L .75404 .85535 L p F P
0 g
s
0 1 0 r
.25201 .49285 m .31326 .45725 L p .27672 .55861 L F P
0 g
s
0 1 0 r
.27672 .55861 m .2548 .54399 L .25201 .49285 L p F P
0 g
s
0 1 0 r
.79586 .6991 m .79071 .697 L .71474 .74261 L p F P
0 g
s
0 1 0 r
.79071 .697 m .71474 .74261 L .67905 .71162 L p F P
0 g
s
0 1 0 r
.60192 .7484 m .67905 .71162 L .71474 .74261 L p F P
0 g
s
1 0 0 r
.45085 .88081 m .37802 .88965 L .33317 .84571 L p F P
0 g
s
1 0 0 r
.26245 .84815 m .33317 .84571 L .37802 .88965 L p F P
0 g
s
0 1 0 r
.79071 .697 m .80154 .68908 L .79586 .6991 L closepath p F P
0 g
s
0 1 0 r
.86474 .6228 m .80154 .68908 L .79586 .6991 L p F P
0 g
s
1 0 0 r
.1768 .78678 m .14864 .7812 L .10343 .69314 L p F P
0 g
s
1 0 0 r
.64267 .87053 m .56665 .89381 L .52632 .86433 L p F P
0 g
s
1 0 0 r
.45085 .88081 m .52632 .86433 L .56665 .89381 L p F P
0 g
s
1 0 0 r
.33317 .84571 m .26245 .84815 L .21583 .78873 L p F P
0 g
s
0 1 0 r
.80154 .68908 m .86474 .6228 L .83403 .5943 L p F P
0 g
s
1 0 0 r
.87461 .79186 m .83064 .81769 L .79921 .80029 L p F P
0 g
s
1 0 0 r
.72033 .83938 m .79921 .80029 L .83064 .81769 L p F P
0 g
s
0 1 0 r
.60192 .7484 m .52632 .77472 L .48492 .72483 L p F P
0 g
s
0 1 0 r
.41037 .74205 m .48492 .72483 L .52632 .77472 L p F P
0 g
s
0 1 0 r
.80154 .68908 m .79071 .697 L .75707 .6644 L p F P
0 g
s
0 1 0 r
.67905 .71162 m .75707 .6644 L .79071 .697 L p F P
0 g
s
0 1 0 r
.75707 .6644 m .79051 .63983 L .80154 .68908 L p F P
0 g
s
0 1 0 r
.83403 .5943 m .79051 .63983 L .80154 .68908 L p F P
0 g
s
0 1 0 r
.38358 .42729 m .39622 .37254 L .47317 .34885 L p F P
0 g
s
0 1 0 r
.47944 .34194 m .47317 .34885 L .39622 .37254 L p F P
0 g
s
0 1 0 r
.39622 .37254 m .38358 .42729 L .31326 .45725 L p F P
0 g
s
0 1 0 r
.76738 .34976 m .71585 .33601 L .66968 .32366 L p F P
0 g
s
0 1 0 r
.71585 .33601 m .65613 .33132 L .66968 .32366 L closepath p F P
0 g
s
0 1 0 r
.66968 .32366 m .65613 .33132 L .55905 .33348 L p F P
0 g
s
1 0 0 r
.89356 .76298 m .87461 .79186 L p .79921 .80029 L F P
0 g
s
1 0 0 r
.87461 .79186 m .89356 .76298 L .90735 .76819 L closepath p F P
0 g
s
1 0 0 r
.09725 .67768 m .07336 .58008 L .09159 .56005 L p F P
0 g
s
1 0 0 r
.62927 .19978 m .6056 .20093 L .51351 .21123 L p F P
0 g
s
1 0 0 r
.6056 .20093 m .62927 .19978 L .70865 .19834 L p F P
0 g
s
0 1 0 r
.25758 .57127 m .2548 .54399 L .27672 .55861 L closepath p F P
0 g
s
0 1 0 r
.55905 .33348 m .52949 .33765 L .47944 .34194 L p F P
0 g
s
0 1 0 r
.52949 .33765 m .47317 .34885 L .47944 .34194 L closepath p F P
0 g
s
1 0 0 r
.21583 .78873 m .1768 .78678 L .19721 .75861 L closepath p F P
0 g
s
1 0 0 r
.16976 .70427 m .19721 .75861 L .1768 .78678 L p F P
0 g
s
1 0 0 r
.10343 .69314 m .16976 .70427 L p .1768 .78678 L F P
0 g
s
0 1 0 r
.36679 .67157 m .29469 .68017 L .35373 .64417 L closepath p F P
0 g
s
0 1 0 r
.3243 .55751 m .35373 .64417 L .29469 .68017 L p F P
0 g
s
0 1 0 r
.27672 .55861 m .3243 .55751 L p .29469 .68017 L F P
0 g
s
0 1 0 r
.29469 .68017 m .25758 .57127 L .27672 .55861 L p F P
0 g
s
1 0 0 r
.14141 .63273 m .16976 .70427 L .10343 .69314 L p F P
0 g
s
1 0 0 r
.10343 .69314 m .09725 .67768 L .14141 .63273 L p F P
0 g
s
0 1 0 r
.48492 .72483 m .41037 .74205 L .36679 .67157 L p F P
0 g
s
1 0 0 r
.12759 .57697 m .14141 .63273 L .09725 .67768 L p F P
0 g
s
1 0 0 r
.09159 .56005 m .12759 .57697 L p .09725 .67768 L F P
0 g
s
1 0 0 r
.52632 .86433 m .45085 .88081 L .40703 .83585 L p F P
0 g
s
1 0 0 r
.33317 .84571 m .40703 .83585 L .45085 .88081 L p F P
0 g
s
1 0 0 r
.72033 .83938 m .64267 .87053 L .60403 .83995 L p F P
0 g
s
1 0 0 r
.52632 .86433 m .60403 .83995 L .64267 .87053 L p F P
0 g
s
0 1 0 r
.31859 .53537 m .31326 .45725 L .38358 .42729 L p F P
0 g
s
0 1 0 r
.31326 .45725 m .31859 .53537 L .27672 .55861 L p F P
0 g
s
0 1 0 r
.67905 .71162 m .60192 .7484 L .56181 .69719 L p F P
0 g
s
0 1 0 r
.48492 .72483 m .56181 .69719 L .60192 .7484 L p F P
0 g
s
0 1 0 r
.75509 .38987 m .71585 .33601 L .76738 .34976 L closepath p F P
0 g
s
0 1 0 r
.4626 .40363 m .47317 .34885 L .52949 .33765 L p F P
0 g
s
0 1 0 r
.47317 .34885 m .4626 .40363 L .38358 .42729 L p F P
0 g
s
0 1 0 r
.3243 .55751 m .27672 .55861 L .31859 .53537 L closepath p F P
0 g
s
1 0 0 r
.40703 .83585 m .33317 .84571 L .28709 .78503 L p F P
0 g
s
1 0 0 r
.21583 .78873 m .28709 .78503 L .33317 .84571 L p F P
0 g
s
1 0 0 r
.24506 .71523 m .28709 .78503 L .21583 .78873 L p F P
0 g
s
1 0 0 r
.21583 .78873 m .19721 .75861 L .24506 .71523 L p F P
0 g
s
0 1 0 r
.55522 .34991 m .52949 .33765 L .55905 .33348 L closepath p F P
0 g
s
0 1 0 r
.52949 .33765 m .55522 .34991 L p .4626 .40363 L F P
0 g
s
0 1 0 r
.65613 .33132 m .71585 .33601 L .75509 .38987 L p F P
0 g
s
0 1 0 r
.55905 .33348 m .65613 .33132 L .64745 .38164 L p F P
0 g
s
0 1 0 r
.55522 .34991 m .55905 .33348 L p .64745 .38164 L F P
0 g
s
1 0 0 r
.79921 .80029 m .87881 .75329 L .89356 .76298 L p F P
0 g
s
1 0 0 r
.79921 .80029 m .72033 .83938 L .68359 .8075 L p F P
0 g
s
1 0 0 r
.60403 .83995 m .68359 .8075 L .72033 .83938 L p F P
0 g
s
0 1 0 r
.75509 .38987 m .64745 .38164 L .65613 .33132 L p F P
0 g
s
0 1 0 r
.75707 .6644 m .67905 .71162 L .64044 .65897 L p F P
0 g
s
0 1 0 r
.56181 .69719 m .64044 .65897 L .67905 .71162 L p F P
0 g
s
0 1 0 r
.56181 .69719 m .48492 .72483 L .442 .65288 L p F P
0 g
s
0 1 0 r
.36679 .67157 m .442 .65288 L .48492 .72483 L p F P
0 g
s
1 0 0 r
.24044 .70591 m .24506 .71523 L .19721 .75861 L p F P
0 g
s
1 0 0 r
.19721 .75861 m .16976 .70427 L .24044 .70591 L p F P
0 g
s
0 1 0 r
.42463 .61559 m .442 .65288 L .36679 .67157 L p F P
0 g
s
0 1 0 r
.36679 .67157 m .35373 .64417 L .42463 .61559 L p F P
0 g
s
1 0 0 r
.60403 .83995 m .52632 .86433 L .48373 .81822 L p F P
0 g
s
1 0 0 r
.40703 .83585 m .48373 .81822 L .52632 .86433 L p F P
0 g
s
1 0 0 r
.70865 .19834 m .70394 .19859 L .6056 .20093 L p F P
0 g
s
1 0 0 r
.51351 .21123 m .6056 .20093 L .59215 .21573 L closepath p F P
0 g
s
0 1 0 r
.39905 .53997 m .42463 .61559 L .35373 .64417 L p F P
0 g
s
0 1 0 r
.35373 .64417 m .3243 .55751 L .39905 .53997 L p F P
0 g
s
0 1 0 r
.3902 .50623 m .38358 .42729 L .4626 .40363 L p F P
0 g
s
0 1 0 r
.38358 .42729 m .3902 .50623 L .31859 .53537 L p F P
0 g
s
0 1 0 r
.3243 .55751 m .31859 .53537 L .3902 .50623 L p F P
0 g
s
0 1 0 r
.79051 .63983 m .75707 .6644 L .72011 .61019 L p F P
0 g
s
0 1 0 r
.64044 .65897 m .72011 .61019 L .75707 .6644 L p F P
0 g
s
0 1 0 r
.79051 .63983 m .83403 .5943 L .79842 .53201 L p F P
0 g
s
0 1 0 r
.3902 .50623 m .39905 .53997 L .3243 .55751 L p F P
0 g
s
1 0 0 r
.87881 .75329 m .79921 .80029 L .76451 .76691 L p F P
0 g
s
1 0 0 r
.68359 .8075 m .76451 .76691 L .79921 .80029 L p F P
0 g
s
0 1 0 r
.72011 .61019 m .7315 .60177 L .79051 .63983 L p F P
0 g
s
0 1 0 r
.79842 .53201 m .7315 .60177 L .79051 .63983 L p F P
0 g
s
0 1 0 r
.64745 .38164 m .58733 .38295 L .55522 .34991 L p F P
0 g
s
0 1 0 r
.58733 .38295 m .5497 .38679 L .55522 .34991 L closepath p F P
0 g
s
0 1 0 r
.55522 .34991 m .5497 .38679 L .4626 .40363 L p F P
0 g
s
1 0 0 r
.19566 .59183 m .24044 .70591 L .16976 .70427 L p F P
0 g
s
1 0 0 r
.16976 .70427 m .14141 .63273 L .19566 .59183 L p F P
0 g
s
1 0 0 r
.14141 .63273 m .12759 .57697 L .19566 .59183 L closepath p F P
0 g
s
1 0 0 r
.6056 .20093 m .70394 .19859 L .68338 .22565 L p F P
0 g
s
1 0 0 r
.59215 .21573 m .6056 .20093 L p .68338 .22565 L F P
0 g
s
1 0 0 r
.48373 .81822 m .40703 .83585 L .36168 .77383 L p F P
0 g
s
1 0 0 r
.28709 .78503 m .36168 .77383 L .40703 .83585 L p F P
0 g
s
0 1 0 r
.64044 .65897 m .56181 .69719 L .51974 .62374 L p F P
0 g
s
0 1 0 r
.442 .65288 m .51974 .62374 L .56181 .69719 L p F P
0 g
s
1 0 0 r
.3153 .69449 m .36168 .77383 L .28709 .78503 L p F P
0 g
s
1 0 0 r
.265 .70312 m .3153 .69449 L p .28709 .78503 L F P
0 g
s
1 0 0 r
.28709 .78503 m .24506 .71523 L .265 .70312 L p F P
0 g
s
1 0 0 r
.76451 .76691 m .84628 .71822 L .87881 .75329 L p F P
0 g
s
1 0 0 r
.68359 .8075 m .60403 .83995 L .56287 .79254 L p F P
0 g
s
1 0 0 r
.48373 .81822 m .56287 .79254 L .60403 .83995 L p F P
0 g
s
0 1 0 r
.50685 .59533 m .51974 .62374 L .442 .65288 L p F P
0 g
s
0 1 0 r
.442 .65288 m .42463 .61559 L .50685 .59533 L p F P
0 g
s
0 1 0 r
.4626 .40363 m .5497 .38679 L p .52964 .47231 L F P
0 g
s
0 1 0 r
.52964 .47231 m .47068 .4832 L .4626 .40363 L p F P
0 g
s
0 1 0 r
.4626 .40363 m .47068 .4832 L .3902 .50623 L p F P
0 g
s
0 1 0 r
.39905 .53997 m .3902 .50623 L .47068 .4832 L p F P
0 g
s
0 1 0 r
.47675 .50595 m .50685 .59533 L .42463 .61559 L p F P
0 g
s
0 1 0 r
.42463 .61559 m .39905 .53997 L .47675 .50595 L p F P
0 g
s
0 1 0 r
.71358 .59765 m .72011 .61019 L .64044 .65897 L p F P
0 g
s
0 1 0 r
.64044 .65897 m .5994 .58402 L .71358 .59765 L p F P
0 g
s
0 1 0 r
.51974 .62374 m .5994 .58402 L .64044 .65897 L p F P
0 g
s
0 1 0 r
.47068 .4832 m .47675 .50595 L .39905 .53997 L p F P
0 g
s
0 1 0 r
.77867 .48409 m .72479 .47071 L .75509 .38987 L closepath p F P
0 g
s
0 1 0 r
.64745 .38164 m .75509 .38987 L .72479 .47071 L p F P
0 g
s
0 1 0 r
.55612 .43982 m .58733 .38295 L .5497 .38679 L closepath p F P
0 g
s
0 1 0 r
.5497 .38679 m .55612 .43982 L .52964 .47231 L p F P
0 g
s
1 0 0 r
.56287 .79254 m .48373 .81822 L .43929 .75479 L p F P
0 g
s
1 0 0 r
.36168 .77383 m .43929 .75479 L .48373 .81822 L p F P
0 g
s
1 0 0 r
.76451 .76691 m .68359 .8075 L .64402 .75866 L p F P
0 g
s
1 0 0 r
.56287 .79254 m .64402 .75866 L .68359 .8075 L p F P
0 g
s
0 1 0 r
.77867 .48409 m .79842 .53201 L .7315 .60177 L p F P
0 g
s
0 1 0 r
.58733 .38295 m .64745 .38164 L p .5606 .46825 L F P
0 g
s
0 1 0 r
.5606 .46825 m .55612 .43982 L .58733 .38295 L p F P
0 g
s
1 0 0 r
.24506 .71523 m .24044 .70591 L .265 .70312 L closepath p F P
0 g
s
0 1 0 r
.72479 .47071 m .66228 .46614 L .64745 .38164 L p F P
0 g
s
0 1 0 r
.64745 .38164 m .66228 .46614 L .5606 .46825 L p F P
0 g
s
0 1 0 r
.72011 .61019 m .7315 .60177 L .71358 .59765 L closepath p F P
0 g
s
1 0 0 r
.265 .70312 m .24044 .70591 L .19566 .59183 L p F P
0 g
s
0 1 0 r
.72479 .47071 m .77867 .48409 L p .7315 .60177 L F P
0 g
s
0 1 0 r
.67947 .51771 m .72479 .47071 L p .7315 .60177 L F P
0 g
s
0 1 0 r
.7315 .60177 m .71358 .59765 L .67947 .51771 L p F P
0 g
s
0 1 0 r
.51974 .62374 m .5994 .58402 L .50685 .59533 L closepath p F P
0 g
s
1 0 0 r
.68338 .22565 m .63944 .22669 L .59215 .21573 L p F P
0 g
s
1 0 0 r
.43929 .75479 m .36168 .77383 L .3153 .69449 L p F P
0 g
s
0 1 0 r
.5994 .58402 m .67947 .51771 L .71358 .59765 L closepath p F P
0 g
s
0 1 0 r
.5994 .58402 m .50685 .59533 L .47675 .50595 L p F P
0 g
s
0 1 0 r
.47675 .50595 m .52964 .47231 L .47068 .4832 L closepath p F P
0 g
s
0 1 0 r
.47675 .50595 m .52964 .47231 L p .5994 .58402 L F P
0 g
s
1 0 0 r
.19566 .59183 m .2699 .58095 L p .265 .70312 L F P
0 g
s
1 0 0 r
.3153 .69449 m .265 .70312 L .30869 .68086 L closepath p F P
0 g
s
1 0 0 r
.2699 .58095 m .30869 .68086 L .265 .70312 L p F P
0 g
s
1 0 0 r
.84628 .71822 m .76451 .76691 L .7267 .71651 L p F P
0 g
s
1 0 0 r
.64402 .75866 m .7267 .71651 L .76451 .76691 L p F P
0 g
s
0 1 0 r
.5606 .46825 m .55612 .43982 L .52964 .47231 L closepath p F P
0 g
s
0 1 0 r
.52964 .47231 m .5606 .46825 L .5994 .58402 L p F P
0 g
s
0 1 0 r
.66228 .46614 m .67947 .51771 L .5994 .58402 L p F P
0 g
s
0 1 0 r
.5994 .58402 m .5606 .46825 L .66228 .46614 L p F P
0 g
s
1 0 0 r
.64402 .75866 m .56287 .79254 L .51952 .72763 L p F P
0 g
s
1 0 0 r
.43929 .75479 m .51952 .72763 L .56287 .79254 L p F P
0 g
s
0 1 0 r
.67947 .51771 m .72479 .47071 L .66228 .46614 L closepath p F P
0 g
s
1 0 0 r
.7267 .71651 m .81038 .66612 L .84628 .71822 L p F P
0 g
s
1 0 0 r
.51952 .72763 m .43929 .75479 L .39348 .67377 L p F P
0 g
s
1 0 0 r
.3153 .69449 m .39348 .67377 L .43929 .75479 L p F P
0 g
s
1 0 0 r
.3836 .6529 m .39348 .67377 L .3153 .69449 L p F P
0 g
s
1 0 0 r
.3153 .69449 m .30869 .68086 L .3836 .6529 L p F P
0 g
s
1 0 0 r
.6786 .28029 m .63944 .22669 L .68338 .22565 L closepath p F P
0 g
s
1 0 0 r
.34781 .55957 m .3836 .6529 L .30869 .68086 L p F P
0 g
s
1 0 0 r
.30869 .68086 m .2699 .58095 L .34781 .55957 L p F P
0 g
s
1 0 0 r
.7267 .71651 m .64402 .75866 L .60195 .69219 L p F P
0 g
s
1 0 0 r
.51952 .72763 m .60195 .69219 L .64402 .75866 L p F P
0 g
s
1 0 0 r
.60195 .69219 m .51952 .72763 L .47447 .64493 L p F P
0 g
s
1 0 0 r
.39348 .67377 m .47447 .64493 L .51952 .72763 L p F P
0 g
s
1 0 0 r
.81038 .66612 m .7267 .71651 L .68607 .64841 L p F P
0 g
s
1 0 0 r
.60195 .69219 m .68607 .64841 L .7267 .71651 L p F P
0 g
s
1 0 0 r
.46794 .63077 m .47447 .64493 L .39348 .67377 L p F P
0 g
s
1 0 0 r
.39348 .67377 m .3836 .6529 L .46794 .63077 L p F P
0 g
s
1 0 0 r
.42881 .52736 m .46794 .63077 L .3836 .6529 L p F P
0 g
s
1 0 0 r
.3836 .6529 m .34781 .55957 L .42881 .52736 L p F P
0 g
s
1 0 0 r
.79108 .63162 m .81038 .66612 L p .68607 .64841 L F P
0 g
s
1 0 0 r
.66903 .61436 m .68607 .64841 L .60195 .69219 L p F P
0 g
s
1 0 0 r
.60195 .69219 m .5623 .61639 L .66903 .61436 L p F P
0 g
s
1 0 0 r
.5623 .61639 m .60195 .69219 L p .47447 .64493 L F P
0 g
s
1 0 0 r
.47447 .64493 m .5298 .62029 L .5623 .61639 L p F P
0 g
s
1 0 0 r
.47447 .64493 m .5298 .62029 L .46794 .63077 L closepath p F P
0 g
s
1 0 0 r
.68607 .64841 m .73463 .61875 L .79108 .63162 L p F P
0 g
s
1 0 0 r
.79108 .63162 m .77099 .59192 L .73463 .61875 L closepath p F P
0 g
s
1 0 0 r
.69125 .36299 m .6451 .364 L .6786 .28029 L closepath p F P
0 g
s
1 0 0 r
.5298 .62029 m .46794 .63077 L .42881 .52736 L p F P
0 g
s
1 0 0 r
.68607 .64841 m .73463 .61875 L .66903 .61436 L closepath p F P
0 g
s
1 0 0 r
.42881 .52736 m .51223 .48417 L p .5298 .62029 L F P
0 g
s
1 0 0 r
.5623 .61639 m .5578 .60633 L .5298 .62029 L closepath p F P
0 g
s
1 0 0 r
.51223 .48417 m .5578 .60633 L .5298 .62029 L p F P
0 g
s
1 0 0 r
.72822 .4898 m .77099 .59192 L .73463 .61875 L p F P
0 g
s
1 0 0 r
.64267 .55355 m .72822 .4898 L p .73463 .61875 L F P
0 g
s
1 0 0 r
.73463 .61875 m .66903 .61436 L .64267 .55355 L p F P
0 g
s
1 0 0 r
.64267 .55355 m .66903 .61436 L .5623 .61639 L p F P
0 g
s
1 0 0 r
.5623 .61639 m .5578 .60633 L .64267 .55355 L p F P
0 g
s
1 0 0 r
.61358 .47435 m .64267 .55355 L .5578 .60633 L p F P
0 g
s
1 0 0 r
.5578 .60633 m .51223 .48417 L .61358 .47435 L p F P
0 g
s
1 0 0 r
.51223 .48417 m .59691 .41364 L .61358 .47435 L closepath p F P
0 g
s
1 0 0 r
.6451 .364 m .69125 .36299 L p .61358 .47435 L F P
0 g
s
1 0 0 r
.61358 .47435 m .59691 .41364 L .6451 .364 L p F P
0 g
s
1 0 0 r
.69125 .36299 m .72183 .47212 L .61358 .47435 L p F P
0 g
s
1 0 0 r
.72183 .47212 m .72822 .4898 L .64267 .55355 L p F P
0 g
s
1 0 0 r
.64267 .55355 m .61358 .47435 L .72183 .47212 L p F P
0 g
s
.25 Mabswid
.67245 0 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.67245 0 m
.08846 .24555 L
s
.08846 .24555 m
.67245 0 L
s
.10087 .24033 m
.10595 .24556 L
s
[(-1)] .09072 .22988 .97192 1 Mshowa
.22871 .18658 m
.23354 .19204 L
s
[(-0.5)] .21906 .17566 .88455 1 Mshowa
.36358 .12987 m
.36813 .13557 L
s
[(0)] .3545 .11847 .79718 1 Mshowa
.50609 .06995 m
.51031 .07589 L
s
[(0.5)] .49765 .05807 .70982 1 Mshowa
.65689 .00654 m
.66074 .01273 L
s
[(1)] .64919 -0.00583 .62245 1 Mshowa
.125 Mabswid
.12591 .22981 m
.12892 .23297 L
s
.1512 .21917 m
.15419 .22236 L
s
.17676 .20842 m
.17972 .21164 L
s
.2026 .19756 m
.20553 .20081 L
s
.25511 .17548 m
.25797 .17879 L
s
.28179 .16426 m
.28462 .1676 L
s
.30875 .15292 m
.31155 .15628 L
s
.33602 .14146 m
.33878 .14485 L
s
.39145 .11815 m
.39414 .1216 L
s
.41963 .1063 m
.42229 .10978 L
s
.44813 .09432 m
.45074 .09783 L
s
.47695 .0822 m
.47952 .08574 L
s
.53556 .05756 m
.53805 .06115 L
s
.56537 .04502 m
.56782 .04865 L
s
.59553 .03235 m
.59793 .036 L
s
.62603 .01952 m
.62839 .0232 L
s
.25 Mabswid
0 .80374 m
.40037 1.0855 L
s
.01178 .81203 m
.01289 .80482 L
s
[(-1)] .00955 .82643 .15454 -1 Mshowa
.1225 .88995 m
.12336 .88271 L
s
[(-0.5)] .12079 .90442 .11851 -1 Mshowa
.22183 .95985 m
.22246 .95259 L
s
[(0)] .22056 .97437 .08756 -1 Mshowa
.31143 1.0229 m
.31187 1.01563 L
s
[(0.5)] .31055 1.03745 .0607 -1 Mshowa
.39267 1.08007 m
.39294 1.07279 L
s
[(1)] .39213 1.09464 .03715 -1 Mshowa
.125 Mabswid
.03493 .82832 m
.03556 .82399 L
s
.05756 .84424 m
.05816 .83991 L
s
.07969 .85982 m
.08026 .85548 L
s
.10133 .87505 m
.10187 .87071 L
s
.14322 .90453 m
.14371 .90018 L
s
.1635 .9188 m
.16396 .91445 L
s
.18335 .93277 m
.18378 .92842 L
s
.20279 .94645 m
.2032 .9421 L
s
.24048 .97297 m
.24084 .96861 L
s
.25875 .98583 m
.25909 .98147 L
s
.27666 .99844 m
.27697 .99407 L
s
.29422 1.01079 m
.29451 1.00643 L
s
.32831 1.03478 m
.32855 1.03041 L
s
.34486 1.04643 m
.34508 1.04206 L
s
.3611 1.05786 m
.3613 1.05349 L
s
.37703 1.06907 m
.37721 1.0647 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S5.30.1"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics3D  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S5.30.1"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for X",
ScreenRectangle->{{0, 1024}, {0, 768}},
WindowSize->{550, 600},
WindowMargins->{{Automatic, 0}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.30.1"->{
    Cell[1776, 53, 143, 6, 70, "Subsection",
      CellTags->{"S5.30.1", "1.1"}],
    Cell[1922, 61, 3265, 126, 70, "Text",
      CellTags->{"S5.30.1", "1.2"}],
    Cell[5190, 189, 6063, 133, 70, "DefinitionBox",
      CellTags->"S5.30.1"],
    Cell[11256, 324, 98, 3, 70, "Caption",
      CellTags->"S5.30.1"],
    Cell[11357, 329, 79, 1, 70, "MathCaption",
      CellTags->{"S5.30.1", "1.3"}],
    Cell[11439, 332, 90, 2, 70, "Input",
      CellTags->"S5.30.1"],
    Cell[11532, 336, 148, 4, 70, "MathCaption",
      CellTags->{"S5.30.1", "1.4"}],
    Cell[11705, 344, 146, 5, 70, "Input",
      CellTags->"S5.30.1"],
    Cell[11854, 351, 23625, 1284, 70, 23551, 1281, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.30.1"],
    Cell[35482, 1637, 180, 5, 70, "Output",
      CellTags->"S5.30.1"],
    Cell[35677, 1645, 2561, 60, 70, "DefinitionBox3Col",
      CellTags->"S5.30.1"],
    Cell[38241, 1707, 112, 5, 70, "Caption",
      CellTags->"S5.30.1"],
    Cell[38356, 1714, 4112, 146, 70, "Text",
      CellTags->{"S5.30.1", "1.5"}],
    Cell[42471, 1862, 194, 6, 70, "MathCaption",
      CellTags->{"S5.30.1", "1.6"}],
    Cell[42690, 1872, 150, 6, 70, "Input",
      CellTags->"S5.30.1"],
    Cell[42843, 1880, 22214, 1188, 70, 22140, 1185, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.30.1"],
    Cell[65060, 3070, 180, 5, 70, "Output",
      CellTags->"S5.30.1"],
    Cell[65255, 3078, 2348, 55, 70, "DefinitionBox3Col",
      CellTags->"S5.30.1"],
    Cell[67606, 3135, 116, 5, 70, "Caption",
      CellTags->"S5.30.1"],
    Cell[67725, 3142, 996, 37, 70, "Text",
      CellTags->{"S5.30.1", "1.7"}],
    Cell[68724, 3181, 121, 4, 70, "MathCaption",
      CellTags->{"S5.30.1", "1.8"}],
    Cell[68848, 3187, 215, 7, 70, "Input",
      CellTags->"S5.30.1"],
    Cell[69066, 3196, 313, 9, 70, "MathCaption",
      CellTags->{"S5.30.1", "1.9"}],
    Cell[69404, 3209, 267, 9, 70, "Input",
      CellTags->"S5.30.1"],
    Cell[69674, 3220, 60915, 3646, 70, 60841, 3643, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.30.1"],
    Cell[130592, 6868, 180, 5, 70, "Output",
      CellTags->"S5.30.1"]},
  "1.1"->{
    Cell[1776, 53, 143, 6, 70, "Subsection",
      CellTags->{"S5.30.1", "1.1"}]},
  "1.2"->{
    Cell[1922, 61, 3265, 126, 70, "Text",
      CellTags->{"S5.30.1", "1.2"}]},
  "1.3"->{
    Cell[11357, 329, 79, 1, 70, "MathCaption",
      CellTags->{"S5.30.1", "1.3"}]},
  "1.4"->{
    Cell[11532, 336, 148, 4, 70, "MathCaption",
      CellTags->{"S5.30.1", "1.4"}]},
  "1.5"->{
    Cell[38356, 1714, 4112, 146, 70, "Text",
      CellTags->{"S5.30.1", "1.5"}]},
  "1.6"->{
    Cell[42471, 1862, 194, 6, 70, "MathCaption",
      CellTags->{"S5.30.1", "1.6"}]},
  "1.7"->{
    Cell[67725, 3142, 996, 37, 70, "Text",
      CellTags->{"S5.30.1", "1.7"}]},
  "1.8"->{
    Cell[68724, 3181, 121, 4, 70, "MathCaption",
      CellTags->{"S5.30.1", "1.8"}]},
  "1.9"->{
    Cell[69066, 3196, 313, 9, 70, "MathCaption",
      CellTags->{"S5.30.1", "1.9"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.30.1", 131413, 6893},
  {"1.1", 133681, 6952},
  {"1.2", 133775, 6955},
  {"1.3", 133866, 6958},
  {"1.4", 133962, 6961},
  {"1.5", 134059, 6964},
  {"1.6", 134153, 6967},
  {"1.7", 134251, 6970},
  {"1.8", 134343, 6973},
  {"1.9", 134441, 6976}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 143, 6, 70, "Subsection",
  CellTags->{"S5.30.1", "1.1"}],
Cell[1922, 61, 3265, 126, 70, "Text",
  CellTags->{"S5.30.1", "1.2"}],
Cell[5190, 189, 6063, 133, 70, "DefinitionBox",
  CellTags->"S5.30.1"],
Cell[11256, 324, 98, 3, 70, "Caption",
  CellTags->"S5.30.1"],
Cell[11357, 329, 79, 1, 70, "MathCaption",
  CellTags->{"S5.30.1", "1.3"}],
Cell[11439, 332, 90, 2, 70, "Input",
  CellTags->"S5.30.1"],
Cell[11532, 336, 148, 4, 70, "MathCaption",
  CellTags->{"S5.30.1", "1.4"}],

Cell[CellGroupData[{
Cell[11705, 344, 146, 5, 70, "Input",
  CellTags->"S5.30.1"],
Cell[11854, 351, 23625, 1284, 70, 23551, 1281, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.30.1"],
Cell[35482, 1637, 180, 5, 70, "Output",
  CellTags->"S5.30.1"]
}, Open  ]],
Cell[35677, 1645, 2561, 60, 70, "DefinitionBox3Col",
  CellTags->"S5.30.1"],
Cell[38241, 1707, 112, 5, 70, "Caption",
  CellTags->"S5.30.1"],
Cell[38356, 1714, 4112, 146, 70, "Text",
  CellTags->{"S5.30.1", "1.5"}],
Cell[42471, 1862, 194, 6, 70, "MathCaption",
  CellTags->{"S5.30.1", "1.6"}],

Cell[CellGroupData[{
Cell[42690, 1872, 150, 6, 70, "Input",
  CellTags->"S5.30.1"],
Cell[42843, 1880, 22214, 1188, 70, 22140, 1185, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.30.1"],
Cell[65060, 3070, 180, 5, 70, "Output",
  CellTags->"S5.30.1"]
}, Open  ]],
Cell[65255, 3078, 2348, 55, 70, "DefinitionBox3Col",
  CellTags->"S5.30.1"],
Cell[67606, 3135, 116, 5, 70, "Caption",
  CellTags->"S5.30.1"],
Cell[67725, 3142, 996, 37, 70, "Text",
  CellTags->{"S5.30.1", "1.7"}],
Cell[68724, 3181, 121, 4, 70, "MathCaption",
  CellTags->{"S5.30.1", "1.8"}],
Cell[68848, 3187, 215, 7, 70, "Input",
  CellTags->"S5.30.1"],
Cell[69066, 3196, 313, 9, 70, "MathCaption",
  CellTags->{"S5.30.1", "1.9"}],

Cell[CellGroupData[{
Cell[69404, 3209, 267, 9, 70, "Input",
  CellTags->"S5.30.1"],
Cell[69674, 3220, 60915, 3646, 70, 60841, 3643, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.30.1"],
Cell[130592, 6868, 180, 5, 70, "Output",
  CellTags->"S5.30.1"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

