(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     11800,        391]*)
(*NotebookOutlinePosition[     14791,        486]*)
(*  CellTagsIndexPosition[     14511,        471]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Calculus",
 StyleBox["`", "MB"],
 "DSolveIntegrals",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.11.1", "1.1"}],

Cell[TextData[{
 "Most nonlinear partial differential equations do not allow for general \
solutions. In these cases it is advisable to use the ",
 StyleBox["CompleteIntegral", "MR"],
 " function that attempts to find a sufficiently representative family of \
particular solutions called a ",
 StyleBox["complete integral", "TI"],
 ". "
}], "Text",
 CellTags->{"S5.11.1", "1.2"}],

Cell["\<\
A complete integral of an equation is known to be exhaustive in the sense \
that solutions of almost all boundary value problems for the equation may \
then be expressed in quadratures of the complete integral. Thus, the complete \
integral plays a role similar to that of the Green\[CloseCurlyQuote]s \
function for linear second\[Hyphen]order partial differential equations. \
\>", "Text",
 CellTags->{"S5.11.1", "1.3"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["CompleteIntegral[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["eqn", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["u", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["y", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",\[Ellipsis] ], {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["y", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",\[Ellipsis] }]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "build a complete integral of the differential equation with respect to \
",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["u", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["y", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",\[Ellipsis] ]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.11.1"],

Cell["Finding the complete integral of an equation.", "Caption",
 CellTags->"S5.11.1"],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.11.1", "1.4"}],

Cell["<<Calculus`DSolveIntegrals`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.11.1"],

Cell[TextData[{
 "Here ",
 StyleBox["B[1]", "MR"],
 " and ",
 StyleBox["B[2]", "MR"],
 " are parameters of the solution. "
}], "MathCaption",
 CellTags->{"S5.11.1", "1.5"}],

Cell[CellGroupData[{

Cell["\<\
CompleteIntegral[
    D[u[x, y], y] ==
      (u[x, y] + x^2*D[u[x, y], x]^2)/y,
  u[x,y], {x,y}]\
\>", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.11.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"x", ",", "y"}], "]"}], "\[Rule]", 
     RowBox[{
      FractionBox["1", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", "y"}], "-", 
           RowBox[{"B", "[", "1", "]"}]}], ")"}], " ", 
         RowBox[{"B", "[", "1", "]"}]}], "-", 
        RowBox[{"2", " ", 
         RowBox[{"B", "[", "1", "]"}], " ", 
         RowBox[{"Log", "[", "x", "]"}]}], "-", 
        SuperscriptBox[
         RowBox[{"Log", "[", "x", "]"}], "2"]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"x", ",", "y"}], "]"}], "\[Rule]", 
     RowBox[{
      FractionBox["1", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", "y"}], "-", 
           RowBox[{"B", "[", "1", "]"}]}], ")"}], " ", 
         RowBox[{"B", "[", "1", "]"}]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"B", "[", "1", "]"}], " ", 
         RowBox[{"Log", "[", "x", "]"}]}], "-", 
        SuperscriptBox[
         RowBox[{"Log", "[", "x", "]"}], "2"]}], ")"}]}]}], "}"}]}], 
  "}"}]], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.11.1"]
}, Open  ]],

Cell[TextData[{
 StyleBox["B[", "MR"],
 StyleBox["n", "TI"],
 StyleBox["]", "MR"],
 " is the default name for the parameters appearing in the result of ",
 StyleBox["CompleteIntegral", "MR"],
 ". The names of parameters may be selected using the option ",
 StyleBox["GeneratedParameters", "MR"],
 ", just as the names of the undetermined constants in the result of ",
 StyleBox["DSolve", "MR"],
 " may be selected using this option. "
}], "Text",
 CellTags->{"S5.11.1", "1.6"}],

Cell["\<\
This shows how the names of parameters of the complete integral may be \
changed. The integral is Example 6.7 from KamkeII. \
\>", "MathCaption",
 CellTags->{"S5.11.1", "1.7"}],

Cell[CellGroupData[{

Cell["\<\
CompleteIntegral[-u[x, y] + (2 + y)*D[u[x, y], y] +
   x*D[u[x, y], x] + 3*D[u[x, y], x]^2 == 0,
   u[x,y], {x,y}, GeneratedParameters -> F]\
\>", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.11.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"x", ",", "y"}], "]"}], "\[Rule]", 
     RowBox[{"12", "-", 
      FractionBox[
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"C", "[", "3", "]"}]], "8"], "-", 
      FractionBox[
       SqrtBox[
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"C", "[", "3", "]"}]]}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "12"}], "+", "x"}], ")"}], "2"]}]], 
       RowBox[{"2", " ", 
        SqrtBox["6"]}]], "-", 
      RowBox[{"2", " ", "x"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "+", "y"}], ")"}], " ", 
       RowBox[{"C", "[", "3", "]"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"x", ",", "y"}], "]"}], "\[Rule]", 
     RowBox[{"12", "-", 
      FractionBox[
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"C", "[", "3", "]"}]], "8"], "+", 
      FractionBox[
       SqrtBox[
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"C", "[", "3", "]"}]]}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "12"}], "+", "x"}], ")"}], "2"]}]], 
       RowBox[{"2", " ", 
        SqrtBox["6"]}]], "-", 
      RowBox[{"2", " ", "x"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "+", "y"}], ")"}], " ", 
       RowBox[{"C", "[", "3", "]"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"x", ",", "y"}], "]"}], "\[Rule]", 
     RowBox[{"12", "+", 
      RowBox[{"8", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"C", "[", "3", "]"}]]}], "-", 
      RowBox[{"2", " ", 
       SqrtBox[
        FractionBox["2", "3"]], " ", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"C", "[", "3", "]"}]], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "12"}], "+", "x"}], ")"}], "2"]}]]}], "-", 
      RowBox[{"2", " ", "x"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "+", "y"}], ")"}], " ", 
       RowBox[{"C", "[", "3", "]"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"x", ",", "y"}], "]"}], "\[Rule]", 
     RowBox[{"12", "+", 
      RowBox[{"8", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"C", "[", "3", "]"}]]}], "+", 
      RowBox[{"2", " ", 
       SqrtBox[
        FractionBox["2", "3"]], " ", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"C", "[", "3", "]"}]], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "12"}], "+", "x"}], ")"}], "2"]}]]}], "-", 
      RowBox[{"2", " ", "x"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "+", "y"}], ")"}], " ", 
       RowBox[{"C", "[", "3", "]"}]}]}]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.11.1"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Reference", "Subsubsection",
 CellTags->{"S5.11.1", "1.8"}],

Cell[TextData[{
 "[KamkeII] E. Kamke, ",
 StyleBox["Differentialgleichungen, L\[ODoubleDot]sungsmethoden und L\
\[ODoubleDot]sungen, Band 2, Partielle Differentialgleichungen Erster Ordnung \
fur Eine Gesuchte Funktion", "TI"],
 ", Academische Verlagsgesellschaft, Leipzig, 1948. "
}], "Text",
 CellTags->{"S5.11.1", "1.9"}]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.11.1"->{
    Cell[1776, 53, 140, 6, 36, "Subsection",
      CellTags->{"S5.11.1", "1.1"}],
    Cell[1919, 61, 379, 9, 56, "Text",
      CellTags->{"S5.11.1", "1.2"}],
    Cell[2301, 72, 432, 7, 72, "Text",
      CellTags->{"S5.11.1", "1.3"}],
    Cell[2736, 81, 2565, 81, 64, "DefinitionBox",
      CellTags->"S5.11.1"],
    Cell[5304, 164, 86, 1, 15, "Caption",
      CellTags->"S5.11.1"],
    Cell[5393, 167, 78, 1, 40, "MathCaption",
      CellTags->{"S5.11.1", "1.4"}],
    Cell[5474, 170, 90, 2, 28, "Input",
      CellTags->"S5.11.1"],
    Cell[5567, 174, 172, 7, 40, "MathCaption",
      CellTags->{"S5.11.1", "1.5"}],
    Cell[5764, 185, 167, 7, 79, "Input",
      CellTags->"S5.11.1"],
    Cell[5934, 194, 1324, 43, 74, "Output",
      CellTags->"S5.11.1"],
    Cell[7273, 240, 477, 12, 56, "Text",
      CellTags->{"S5.11.1", "1.6"}],
    Cell[7753, 254, 186, 4, 58, "MathCaption",
      CellTags->{"S5.11.1", "1.7"}],
    Cell[7964, 262, 211, 6, 71, "Input",
      CellTags->"S5.11.1"],
    Cell[8178, 270, 3165, 102, 196, "Output",
      CellTags->"S5.11.1"],
    Cell[11380, 377, 65, 1, 35, "Subsubsection",
      CellTags->{"S5.11.1", "1.8"}],
    Cell[11448, 380, 324, 7, 59, "Text",
      CellTags->{"S5.11.1", "1.9"}]},
  "1.1"->{
    Cell[1776, 53, 140, 6, 36, "Subsection",
      CellTags->{"S5.11.1", "1.1"}]},
  "1.2"->{
    Cell[1919, 61, 379, 9, 56, "Text",
      CellTags->{"S5.11.1", "1.2"}]},
  "1.3"->{
    Cell[2301, 72, 432, 7, 72, "Text",
      CellTags->{"S5.11.1", "1.3"}]},
  "1.4"->{
    Cell[5393, 167, 78, 1, 40, "MathCaption",
      CellTags->{"S5.11.1", "1.4"}]},
  "1.5"->{
    Cell[5567, 174, 172, 7, 40, "MathCaption",
      CellTags->{"S5.11.1", "1.5"}]},
  "1.6"->{
    Cell[7273, 240, 477, 12, 56, "Text",
      CellTags->{"S5.11.1", "1.6"}]},
  "1.7"->{
    Cell[7753, 254, 186, 4, 58, "MathCaption",
      CellTags->{"S5.11.1", "1.7"}]},
  "1.8"->{
    Cell[11380, 377, 65, 1, 35, "Subsubsection",
      CellTags->{"S5.11.1", "1.8"}]},
  "1.9"->{
    Cell[11448, 380, 324, 7, 59, "Text",
      CellTags->{"S5.11.1", "1.9"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.11.1", 12423, 407},
  {"1.1", 13662, 440},
  {"1.2", 13756, 443},
  {"1.3", 13844, 446},
  {"1.4", 13932, 449},
  {"1.5", 14027, 452},
  {"1.6", 14123, 455},
  {"1.7", 14213, 458},
  {"1.8", 14309, 461},
  {"1.9", 14407, 464}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 140, 6, 36, "Subsection",
  CellTags->{"S5.11.1", "1.1"}],
Cell[1919, 61, 379, 9, 56, "Text",
  CellTags->{"S5.11.1", "1.2"}],
Cell[2301, 72, 432, 7, 72, "Text",
  CellTags->{"S5.11.1", "1.3"}],
Cell[2736, 81, 2565, 81, 64, "DefinitionBox",
  CellTags->"S5.11.1"],
Cell[5304, 164, 86, 1, 15, "Caption",
  CellTags->"S5.11.1"],
Cell[5393, 167, 78, 1, 40, "MathCaption",
  CellTags->{"S5.11.1", "1.4"}],
Cell[5474, 170, 90, 2, 28, "Input",
  CellTags->"S5.11.1"],
Cell[5567, 174, 172, 7, 40, "MathCaption",
  CellTags->{"S5.11.1", "1.5"}],

Cell[CellGroupData[{
Cell[5764, 185, 167, 7, 79, "Input",
  CellTags->"S5.11.1"],
Cell[5934, 194, 1324, 43, 74, "Output",
  CellTags->"S5.11.1"]
}, Open  ]],
Cell[7273, 240, 477, 12, 56, "Text",
  CellTags->{"S5.11.1", "1.6"}],
Cell[7753, 254, 186, 4, 58, "MathCaption",
  CellTags->{"S5.11.1", "1.7"}],

Cell[CellGroupData[{
Cell[7964, 262, 211, 6, 71, "Input",
  CellTags->"S5.11.1"],
Cell[8178, 270, 3165, 102, 196, "Output",
  CellTags->"S5.11.1"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11380, 377, 65, 1, 35, "Subsubsection",
  CellTags->{"S5.11.1", "1.8"}],
Cell[11448, 380, 324, 7, 59, "Text",
  CellTags->{"S5.11.1", "1.9"}]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

