(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     85148,       2775]*)
(*NotebookOutlinePosition[     92656,       2996]*)
(*  CellTagsIndexPosition[     92091,       2970]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Statistics",
 StyleBox["`", "MB"],
 "DataManipulation",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.98.1", "1.1"}],

Cell[TextData[{
 "The usual form of input for most statistical functions is a list of data. \
If the data points are read in from a file using ",
 StyleBox["ReadList", "MR"],
 ", it is often necessary to change the format or content of the output to \
create the required list. The functions described below are an extension of \
the large number of built\[Hyphen]in list manipulation functions found in ",
 StyleBox["The Mathematica Book", "TI"],
 ". "
}], "Text",
 CellTags->{"S5.98.1", "1.2"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["Column[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SuperscriptBox["\[Null]", "th"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" column of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Column[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["n",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["n",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] }]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give a list of the columns ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["n",
          "TI"], 
         StyleBox["i",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ColumnTake[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["spec", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["take columns specified by ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["spec", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ColumnDrop[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["spec", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["drop columns specified by ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["spec", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ColumnJoin[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["data",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["data",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] ]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["join elements in corresponding columns in ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["data",
          "TI"], 
         StyleBox["i",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["RowJoin[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["data",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["data",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] ]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["join elements in corresponding rows in ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["data",
          "TI"], 
         StyleBox["i",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["DropNonNumeric[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["list", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["drop nonnumeric elements in ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["list", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["DropNonNumeric[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["drop rows with nonnumeric elements in the matrix ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["DropNonNumericColumn[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["drop columns with nonnumeric elements in ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.98.1"],

Cell["Data manipulation functions.", "Caption",
 CellTags->"S5.98.1"],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.98.1", "1.3"}],

Cell["<<Statistics`DataManipulation`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.98.1"],

Cell[TextData[{
 "Each data point is paired with a letter. There is also a missing value \
noted by\[NonBreakingSpace]",
 StyleBox["i", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.98.1", "1.4"}],

Cell[CellGroupData[{

Cell["\<\
data = {{a, 3}, {b, 6}, {c, 4}, {d, i},
   {e, 5}, {f, 4}}\
\>", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.98.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "i"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"e", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", "4"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.98.1"]
}, Open  ]],

Cell["The second column of the data is extracted. ", "MathCaption",
 CellTags->{"S5.98.1", "1.5"}],

Cell[CellGroupData[{

Cell["col2 = Column[data, 2]", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.98.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "6", ",", "4", ",", "i", ",", "5", ",", "4"}], 
  "}"}]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.98.1"]
}, Open  ]],

Cell[TextData[{
 "Here is the data with all the nonnumeric elements dropped. Most of the \
available statistical functions can now use ",
 StyleBox["newdata", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.98.1", "1.6"}],

Cell[CellGroupData[{

Cell["newdata = DropNonNumeric[col2]", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.98.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "6", ",", "4", ",", "5", ",", "4"}], "}"}]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.98.1"]
}, Open  ]],

Cell[TextData[{
  "It is frequently useful to define requirements for extracting or dropping \
particular elements from a list. ",
  StyleBox["TakeWhile", "MR"],
  " and ",
  StyleBox["LengthWhile", "MR"],
  " augment the built\[Hyphen]in ",
  StyleBox["Select", "MR"],
  " by providing alternative ways to apply criteria for sequential selection. \
"
}], "Text",
  CellTags->{"S5.98.1", "1.7"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["TakeWhile[", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["list", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[", ", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["pred", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["]", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[{
              StyleBox["take elements from beginning of ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["list", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" while ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["pred", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" is ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["True", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[{
              StyleBox["LengthWhile[", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["list", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[", ", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["pred", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["]", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[{
              StyleBox["give the number of contiguous elements for which ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["pred", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" is ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["True", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[", starting from the beginning of ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["list", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S5.98.1"],

Cell["Functions to extract or describe data.", "Caption",
 CellTags->"S5.98.1"],

Cell[TextData[{
 "If you want to extract only the first sequence of elements for which a \
predicate is ",
 StyleBox["True", "MR"],
 ", you can use ",
 StyleBox["TakeWhile", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.98.1", "1.8"}],

Cell[CellGroupData[{

Cell["TakeWhile[col2, NumberQ]", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.98.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "6", ",", "4"}], "}"}]], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S5.98.1"]
}, Open  ]],

Cell["Here is the length of the sequence. ", "MathCaption",
 CellTags->{"S5.98.1", "1.9"}],

Cell[CellGroupData[{

Cell["LengthWhile[col2, NumberQ]", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.98.1"],

Cell[BoxData["3"], "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S5.98.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["Frequencies[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["list", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the distinct elements in ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["list", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" paired with their frequencies ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["QuantileForm[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["list", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the sorted elements in ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["list", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" paired with their quantile positions ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["CumulativeSums[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["list", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the cumulative sums of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["list", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.98.1"],

Cell["Functions that summarize data.", "Caption",
 CellTags->"S5.98.1"],

Cell[TextData[{
 "Once you have your data in the correct list format, you can use ",
 StyleBox["Frequencies", "MR"],
 " to observe the distribution of the data. The output of this function, as \
well as that of ",
 StyleBox["QuantileForm", "MR"],
 ", is a list in the correct format for use in various plotting functions. \
This provides a simple way to observe your sample. "
}], "Text",
 CellTags->{"S5.98.1", "1.10"}],

Cell[TextData[{
 "This gives a list of the elements of ",
 StyleBox["newdata", "MR"],
 " along with their frequency of occurrence. "
}], "MathCaption",
 CellTags->{"S5.98.1", "1.11"}],

Cell[CellGroupData[{

Cell["freq = Frequencies[newdata]", "Input",
 CellLabel->"In[7]:= ",
 CellTags->"S5.98.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "6"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[7]= ",
 CellTags->"S5.98.1"]
}, Open  ]],

Cell["\<\
This loads another package, which contains assorted graphics functions. \
\>", "MathCaption",
 CellTags->{"S5.98.1", "1.12"}],

Cell["<<Graphics`Graphics`", "Input",
 CellLabel->"In[8]:= ",
 CellTags->"S5.98.1"],

Cell["Here is a histogram of the data. ", "MathCaption",
 CellTags->{"S5.98.1", "1.13"}],

Cell[CellGroupData[{

Cell["BarChart[freq]", "Input",
 CellLabel->"In[9]:= ",
 CellTags->"S5.98.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0952381 0.238095 0.0147151 0.294302 [
[.14286 .00222 -3 -9 ]
[.14286 .00222 3 0 ]
[.38095 .00222 -3 -9 ]
[.38095 .00222 3 0 ]
[.61905 .00222 -3 -9 ]
[.61905 .00222 3 0 ]
[.85714 .00222 -3 -9 ]
[.85714 .00222 3 0 ]
[-0.0125 .16187 -18 -4.5 ]
[-0.0125 .16187 0 4.5 ]
[-0.0125 .30902 -6 -4.5 ]
[-0.0125 .30902 0 4.5 ]
[-0.0125 .45617 -18 -4.5 ]
[-0.0125 .45617 0 4.5 ]
[-0.0125 .60332 -6 -4.5 ]
[-0.0125 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.14286 .01472 m
.14286 .02097 L
s
[(3)] .14286 .00222 0 1 Mshowa
.38095 .01472 m
.38095 .02097 L
s
[(4)] .38095 .00222 0 1 Mshowa
.61905 .01472 m
.61905 .02097 L
s
[(5)] .61905 .00222 0 1 Mshowa
.85714 .01472 m
.85714 .02097 L
s
[(6)] .85714 .00222 0 1 Mshowa
0 .01472 m
1 .01472 L
s
0 .16187 m
.00625 .16187 L
s
[(0.5)] -0.0125 .16187 1 0 Mshowa
0 .30902 m
.00625 .30902 L
s
[(1)] -0.0125 .30902 1 0 Mshowa
0 .45617 m
.00625 .45617 L
s
[(1.5)] -0.0125 .45617 1 0 Mshowa
0 .60332 m
.00625 .60332 L
s
[(2)] -0.0125 .60332 1 0 Mshowa
.125 Mabswid
0 .04415 m
.00375 .04415 L
s
0 .07358 m
.00375 .07358 L
s
0 .10301 m
.00375 .10301 L
s
0 .13244 m
.00375 .13244 L
s
0 .1913 m
.00375 .1913 L
s
0 .22073 m
.00375 .22073 L
s
0 .25016 m
.00375 .25016 L
s
0 .27959 m
.00375 .27959 L
s
0 .33845 m
.00375 .33845 L
s
0 .36788 m
.00375 .36788 L
s
0 .39731 m
.00375 .39731 L
s
0 .42674 m
.00375 .42674 L
s
0 .4856 m
.00375 .4856 L
s
0 .51503 m
.00375 .51503 L
s
0 .54446 m
.00375 .54446 L
s
0 .57389 m
.00375 .57389 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.04762 .01472 m
.04762 .30902 L
.2381 .30902 L
.2381 .01472 L
F
0 g
.5 Mabswid
.04762 .01472 m
.04762 .30902 L
.2381 .30902 L
.2381 .01472 L
.04762 .01472 L
s
1 0 0 r
.28571 .01472 m
.28571 .60332 L
.47619 .60332 L
.47619 .01472 L
F
0 g
.28571 .01472 m
.28571 .60332 L
.47619 .60332 L
.47619 .01472 L
.28571 .01472 L
s
1 0 0 r
.52381 .01472 m
.52381 .30902 L
.71429 .30902 L
.71429 .01472 L
F
0 g
.52381 .01472 m
.52381 .30902 L
.71429 .30902 L
.71429 .01472 L
.52381 .01472 L
s
1 0 0 r
.7619 .01472 m
.7619 .30902 L
.95238 .30902 L
.95238 .01472 L
F
0 g
.7619 .01472 m
.7619 .30902 L
.95238 .30902 L
.95238 .01472 L
.7619 .01472 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.98.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[9]= ",
 CellTags->"S5.98.1"]
}, Open  ]],

Cell[TextData[{
 "If your sample size is fairly large, it may be difficult to clearly \
summarize your data using ",
 StyleBox["Frequencies", "MR"],
 ". In this case it is better to count the frequency of data points contained \
in a collection of intervals. ",
 StyleBox["BinCounts", "MR"],
 " and ",
 StyleBox["RangeCounts", "MR"],
 " do this for the cases of constant and variable length intervals, \
respectively. You can also use ",
 StyleBox["CategoryCounts", "MR"],
 " to count frequencies of particular types of data. "
}], "Text",
 CellTags->{"S5.98.1", "1.14"}],

Cell["\<\
For each of the three count functions, there is also a corresponding list \
function that gives the elements themselves that fall in the specified \
intervals or match specified types of data. \
\>", "Text",
 CellTags->{"S5.98.1", "1.15"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["BinCounts[{", "MR",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] }, {", "MR",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox["xmin", "TI",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox["xmax", "TI",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox["dx", "TI",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, False, False, True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["list the number of elements in the data ",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] that lie in bins from ",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox["xmin", "TI",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[" to ",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox["xmax", "TI",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[" in steps of ",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox["dx", "TI",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, False, False, True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["RangeCounts[{", "MR",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] }, {", "MR",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["c",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["c",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] }]", "MR",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, False, False, True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["list the number of elements in the data ",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] that lie between successive cutoffs ",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["c",
          "TI"], 
         StyleBox["i",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, False, False, True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["CategoryCounts[{", "MR",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] }, {", "MR",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["e",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["e",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] }]", "MR",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, False, False, True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["list the number of elements in the data ",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] that match each of the ",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["e",
          "TI"], 
         StyleBox["i",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, False, False, True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["CategoryCounts[{", "MR",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] }, {{", "MR",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["e",
          "TI"], "11"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["e",
          "TI"], "12"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] }, {", "MR",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["e",
          "TI"], "21"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["e",
          "TI"], "22"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] }, \[Ellipsis] }]", "MR",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, False, False, True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "list the number of elements that match any of the elements in each \
list ",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox["{", "MR",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["e",
          "TI"], 
         RowBox[{
          StyleBox["i",
           "TI"], "1"}]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["e",
          "TI"], 
         RowBox[{
          StyleBox["i",
           "TI"], "2"}]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] }",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[" ", "TR",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, False, False, True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["BinLists[{", "MR",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] }, {", "MR",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox["xmin", "TI",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox["xmax", "TI",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox["dx", "TI",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, False, False, True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["list the elements that lie in bins from ",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox["xmin", "TI",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[" to ",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox["xmax", "TI",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[" in steps of ",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox["dx", "TI",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, False, False, True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["RangeLists[{", "MR",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] }, {", "MR",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["c",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["c",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] }]", "MR",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, False, False, True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["list the elements that lie between successive cutoffs ",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["c",
          "TI"], 
         StyleBox["i",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, False, False, True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["CategoryLists[{", "MR",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] }, {", "MR",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["e",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["e",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] }]", "MR",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, False, False, True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["list the elements that match each of the ",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["e",
          "TI"], 
         StyleBox["i",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, False, False, True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["CategoryLists[{", "MR",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] }, {{", "MR",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["e",
          "TI"], "11"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["e",
          "TI"], "12"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] }, {", "MR",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["e",
          "TI"], "21"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["e",
          "TI"], "22"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] }, \[Ellipsis] }]", "MR",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, False, False, True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "list the elements that match any of the elements in each list ",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox["{", "MR",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["e",
          "TI"], 
         RowBox[{
          StyleBox["i",
           "TI"], "1"}]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["e",
          "TI"], 
         RowBox[{
          StyleBox["i",
           "TI"], "2"}]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] }",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[" ", "TR",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, False, False, True, False},
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->{False, False, False, True, False},
 RowSpacings->0.4},
 CellTags->"S5.98.1"],

Cell["Functions that categorize data.", "Caption",
 CellTags->"S5.98.1"],

Cell["\<\
This gives a list of randomly generated values of the sine function. \
\>", "MathCaption",
 CellTags->{"S5.98.1", "1.16"}],

Cell["sindata = N[Table[Sin[Pi Random[]],{100}]];", "Input",
 CellLabel->"In[10]:= ",
 CellTags->"S5.98.1"],

Cell[TextData[{
 "These are the frequencies of data for intervals between ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " of length ",
 Cell[BoxData[
  FormBox["0.2", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.98.1", "1.17"}],

Cell[CellGroupData[{

Cell["freq = BinCounts[sindata, {0, 1, 0.2}]", "Input",
 CellLabel->"In[11]:= ",
 CellTags->"S5.98.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"8", ",", "14", ",", "23", ",", "14", ",", "41"}], "}"}]], "Output",\

 CellLabel->"Out[11]= ",
 CellTags->"S5.98.1"]
}, Open  ]],

Cell["This is a list of the midpoints of the five intervals. ", "MathCaption",
 CellTags->{"S5.98.1", "1.18"}],

Cell[CellGroupData[{

Cell["midpoints = {0.1, 0.3, 0.5, 0.7, 0.9}", "Input",
 CellLabel->"In[12]:= ",
 CellTags->"S5.98.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.1`", ",", "0.3`", ",", "0.5`", ",", "0.7`", ",", "0.9`"}], 
  "}"}]], "Output",
 CellLabel->"Out[12]= ",
 CellTags->"S5.98.1"]
}, Open  ]],

Cell[TextData[{
 "This is the histogram for the data set using a function from the ",
 StyleBox["Graphics`Graphics`", "MR"],
 " package that was previously loaded. "
}], "MathCaption",
 CellTags->{"S5.98.1", "1.19"}],

Cell[CellGroupData[{

Cell["BarChart[Transpose[{freq, midpoints}]]", "Input",
 CellLabel->"In[13]:= ",
 CellTags->"S5.98.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0769231 0.192308 0.0147151 0.0143562 [
[.11538 .00222 -9 -9 ]
[.11538 .00222 9 0 ]
[.30769 .00222 -9 -9 ]
[.30769 .00222 9 0 ]
[.5 .00222 -9 -9 ]
[.5 .00222 9 0 ]
[.69231 .00222 -9 -9 ]
[.69231 .00222 9 0 ]
[.88462 .00222 -9 -9 ]
[.88462 .00222 9 0 ]
[-0.0125 .15828 -12 -4.5 ]
[-0.0125 .15828 0 4.5 ]
[-0.0125 .30184 -12 -4.5 ]
[-0.0125 .30184 0 4.5 ]
[-0.0125 .4454 -12 -4.5 ]
[-0.0125 .4454 0 4.5 ]
[-0.0125 .58896 -12 -4.5 ]
[-0.0125 .58896 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11538 .01472 m
.11538 .02097 L
s
[(0.1)] .11538 .00222 0 1 Mshowa
.30769 .01472 m
.30769 .02097 L
s
[(0.3)] .30769 .00222 0 1 Mshowa
.5 .01472 m
.5 .02097 L
s
[(0.5)] .5 .00222 0 1 Mshowa
.69231 .01472 m
.69231 .02097 L
s
[(0.7)] .69231 .00222 0 1 Mshowa
.88462 .01472 m
.88462 .02097 L
s
[(0.9)] .88462 .00222 0 1 Mshowa
0 .01472 m
1 .01472 L
s
0 .15828 m
.00625 .15828 L
s
[(10)] -0.0125 .15828 1 0 Mshowa
0 .30184 m
.00625 .30184 L
s
[(20)] -0.0125 .30184 1 0 Mshowa
0 .4454 m
.00625 .4454 L
s
[(30)] -0.0125 .4454 1 0 Mshowa
0 .58896 m
.00625 .58896 L
s
[(40)] -0.0125 .58896 1 0 Mshowa
.125 Mabswid
0 .04343 m
.00375 .04343 L
s
0 .07214 m
.00375 .07214 L
s
0 .10085 m
.00375 .10085 L
s
0 .12956 m
.00375 .12956 L
s
0 .18699 m
.00375 .18699 L
s
0 .2157 m
.00375 .2157 L
s
0 .24441 m
.00375 .24441 L
s
0 .27313 m
.00375 .27313 L
s
0 .33055 m
.00375 .33055 L
s
0 .35926 m
.00375 .35926 L
s
0 .38798 m
.00375 .38798 L
s
0 .41669 m
.00375 .41669 L
s
0 .47411 m
.00375 .47411 L
s
0 .50283 m
.00375 .50283 L
s
0 .53154 m
.00375 .53154 L
s
0 .56025 m
.00375 .56025 L
s
0 .61768 m
.00375 .61768 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.03846 .01472 m
.03846 .12956 L
.19231 .12956 L
.19231 .01472 L
F
0 g
.5 Mabswid
.03846 .01472 m
.03846 .12956 L
.19231 .12956 L
.19231 .01472 L
.03846 .01472 L
s
1 0 0 r
.23077 .01472 m
.23077 .2157 L
.38462 .2157 L
.38462 .01472 L
F
0 g
.23077 .01472 m
.23077 .2157 L
.38462 .2157 L
.38462 .01472 L
.23077 .01472 L
s
1 0 0 r
.42308 .01472 m
.42308 .34491 L
.57692 .34491 L
.57692 .01472 L
F
0 g
.42308 .01472 m
.42308 .34491 L
.57692 .34491 L
.57692 .01472 L
.42308 .01472 L
s
1 0 0 r
.61538 .01472 m
.61538 .2157 L
.76923 .2157 L
.76923 .01472 L
F
0 g
.61538 .01472 m
.61538 .2157 L
.76923 .2157 L
.76923 .01472 L
.61538 .01472 L
s
1 0 0 r
.80769 .01472 m
.80769 .60332 L
.96154 .60332 L
.96154 .01472 L
F
0 g
.80769 .01472 m
.80769 .60332 L
.96154 .60332 L
.96154 .01472 L
.80769 .01472 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.98.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[13]= ",
 CellTags->"S5.98.1"]
}, Open  ]],

Cell[TextData[{
 "The count and list functions can be used to categorize bivariate and \
general ",
 Cell[BoxData[
  FormBox[
   StyleBox["p",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "\[Hyphen]variate data, by an obvious extension of the syntax. A \
two\[Hyphen]dimensional array is generated for bivariate data and a ",
 Cell[BoxData[
  FormBox[
   StyleBox["p",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "\[Hyphen]dimensional array is generated for ",
 Cell[BoxData[
  FormBox[
   StyleBox["p",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "\[Hyphen]variate data. The following table describes the syntax for \
bivariate data for the count functions, but the same syntax applies to the \
list functions. "
}], "Text",
 CellTags->{"S5.98.1", "1.20"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["BinCounts[{{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, \[Ellipsis] }, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xmin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xmax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dx", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ymin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ymax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dy", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "list the number of elements in the bivariate data that lie in the two\
\[Hyphen]dimensional bins specified by steps in the ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["x",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["y",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" dimensions ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["RangeCounts[{{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, \[Ellipsis] }, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["xc",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["xc",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] }, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["yc",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["yc",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] }]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "list the number of elements in the bivariate data that lie between \
successive cutoffs in the ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["x",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["y",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" dimensions ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["CategoryCounts[{{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, \[Ellipsis] }, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["xe",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["xe",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] }, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["ye",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["ye",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] }]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "list the number of elements in the bivariate data that match ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["xe",
          "TI"], 
         StyleBox["i",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["ye",
          "TI"], 
         StyleBox["j",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "TR",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["i",
          "TI"], "=", "1", ",", "2", ",", "..."}], TraditionalForm]], 
       "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["j",
          "TI"], "=", "1", ",", "2", ",", "..."}], TraditionalForm]], 
       "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["CategoryCounts[{{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, \[Ellipsis] }, {{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["xe",
          "TI"], "11"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["xe",
          "TI"], "12"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] }, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["xe",
          "TI"], "21"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["xe",
          "TI"], "22"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] }, \[Ellipsis] },", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["{{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["ye",
          "TI"], "11"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["ye",
          "TI"], "12"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] }, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["ye",
          "TI"], "21"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["ye",
          "TI"], "22"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] }, \[Ellipsis] } ]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "list the number of elements in the bivariate data that match ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["xe",
          "TI"], 
         StyleBox["i",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["ye",
          "TI"], 
         StyleBox["j",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", where ", "TR",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["xe",
          "TI"], 
         StyleBox["i",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is any member of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["xe",
          "TI"], 
         RowBox[{
          StyleBox["i",
           "TI"], "1"}]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["xe",
          "TI"], 
         RowBox[{
          StyleBox["i",
           "TI"], "2"}]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] }",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and ", "TR",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["ye",
          "TI"], 
         StyleBox["j",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is any member of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["ye",
          "TI"], 
         RowBox[{
          StyleBox["j",
           "TI"], "1"}]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["ye",
          "TI"], 
         RowBox[{
          StyleBox["j",
           "TI"], "2"}]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] }",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ", "TR",
       GridBoxOptions->{RowLines->{False, False, False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.98.1"],

Cell["Categorizing bivariate data.", "Caption",
 CellTags->"S5.98.1"]
}, Open  ]]
},
FrontEndVersion->"5.2 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
WindowSize->{550, 500},
WindowMargins->{{Automatic, 211}, {Automatic, 36}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.98.1"->{
    Cell[1776, 53, 143, 6, 40, "Subsection",
      CellTags->{"S5.98.1", "1.1"}],
    Cell[1922, 61, 496, 10, 76, "Text",
      CellTags->{"S5.98.1", "1.2"}],
    Cell[2421, 73, 10918, 342, 222, "DefinitionBox",
      CellTags->"S5.98.1"],
    Cell[13342, 417, 69, 1, 17, "Caption",
      CellTags->"S5.98.1"],
    Cell[13414, 420, 78, 1, 41, "MathCaption",
      CellTags->{"S5.98.1", "1.3"}],
    Cell[13495, 423, 93, 2, 31, "Input",
      CellTags->"S5.98.1"],
    Cell[13591, 427, 198, 6, 41, "MathCaption",
      CellTags->{"S5.98.1", "1.4"}],
    Cell[13814, 437, 129, 5, 51, "Input",
      CellTags->"S5.98.1"],
    Cell[13946, 444, 453, 16, 27, "Output",
      CellTags->"S5.98.1"],
    Cell[14414, 463, 98, 1, 41, "MathCaption",
      CellTags->{"S5.98.1", "1.5"}],
    Cell[14537, 468, 85, 2, 31, "Input",
      CellTags->"S5.98.1"],
    Cell[14625, 472, 162, 5, 27, "Output",
      CellTags->"S5.98.1"],
    Cell[14802, 480, 221, 6, 58, "MathCaption",
      CellTags->{"S5.98.1", "1.6"}],
    Cell[15048, 490, 93, 2, 31, "Input",
      CellTags->"S5.98.1"],
    Cell[15144, 494, 149, 4, 27, "Output",
      CellTags->"S5.98.1"],
    Cell[15308, 501, 395, 11, 59, "Text",
      CellTags->{"S5.98.1", "1.7"}],
    Cell[15706, 514, 3688, 92, 88, "DefinitionBox",
      CellTags->"S5.98.1"],
    Cell[19397, 608, 79, 1, 17, "Caption",
      CellTags->"S5.98.1"],
    Cell[19479, 611, 236, 8, 58, "MathCaption",
      CellTags->{"S5.98.1", "1.8"}],
    Cell[19740, 623, 87, 2, 31, "Input",
      CellTags->"S5.98.1"],
    Cell[19830, 627, 129, 4, 27, "Output",
      CellTags->"S5.98.1"],
    Cell[19974, 634, 90, 1, 41, "MathCaption",
      CellTags->{"S5.98.1", "1.9"}],
    Cell[20089, 639, 89, 2, 31, "Input",
      CellTags->"S5.98.1"],
    Cell[20181, 643, 74, 2, 27, "Output",
      CellTags->"S5.98.1"],
    Cell[20270, 648, 2607, 81, 128, "DefinitionBox",
      CellTags->"S5.98.1"],
    Cell[22880, 731, 71, 1, 17, "Caption",
      CellTags->"S5.98.1"],
    Cell[22954, 734, 420, 9, 76, "Text",
      CellTags->{"S5.98.1", "1.10"}],
    Cell[23377, 745, 183, 5, 41, "MathCaption",
      CellTags->{"S5.98.1", "1.11"}],
    Cell[23585, 754, 90, 2, 31, "Input",
      CellTags->"S5.98.1"],
    Cell[23678, 758, 335, 12, 27, "Output",
      CellTags->"S5.98.1"],
    Cell[24028, 773, 135, 3, 41, "MathCaption",
      CellTags->{"S5.98.1", "1.12"}],
    Cell[24166, 778, 83, 2, 31, "Input",
      CellTags->"S5.98.1"],
    Cell[24252, 782, 88, 1, 70, "MathCaption",
      CellTags->{"S5.98.1", "1.13"}],
    Cell[24365, 787, 77, 2, 70, "Input",
      CellTags->"S5.98.1"],
    Cell[24445, 791, 2756, 199, 70, 2685, 196, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.98.1"],
    Cell[27204, 992, 180, 6, 70, "Output",
      CellTags->"S5.98.1"],
    Cell[27399, 1001, 571, 14, 70, "Text",
      CellTags->{"S5.98.1", "1.14"}],
    Cell[27973, 1017, 249, 5, 70, "Text",
      CellTags->{"S5.98.1", "1.15"}],
    Cell[28225, 1024, 27925, 717, 70, "DefinitionBox",
      CellTags->"S5.98.1"],
    Cell[56153, 1743, 72, 1, 70, "Caption",
      CellTags->"S5.98.1"],
    Cell[56228, 1746, 132, 3, 70, "MathCaption",
      CellTags->{"S5.98.1", "1.16"}],
    Cell[56363, 1751, 107, 2, 70, "Input",
      CellTags->"S5.98.1"],
    Cell[56473, 1755, 497, 15, 70, "MathCaption",
      CellTags->{"S5.98.1", "1.17"}],
    Cell[56995, 1774, 102, 2, 70, "Input",
      CellTags->"S5.98.1"],
    Cell[57100, 1778, 156, 5, 70, "Output",
      CellTags->"S5.98.1"],
    Cell[57271, 1786, 110, 1, 70, "MathCaption",
      CellTags->{"S5.98.1", "1.18"}],
    Cell[57406, 1791, 101, 2, 70, "Input",
      CellTags->"S5.98.1"],
    Cell[57510, 1795, 168, 5, 70, "Output",
      CellTags->"S5.98.1"],
    Cell[57693, 1803, 216, 5, 70, "MathCaption",
      CellTags->{"S5.98.1", "1.19"}],
    Cell[57934, 1812, 102, 2, 70, "Input",
      CellTags->"S5.98.1"],
    Cell[58039, 1816, 3045, 221, 70, 2974, 218, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.98.1"],
    Cell[61087, 2039, 181, 6, 70, "Output",
      CellTags->"S5.98.1"],
    Cell[61283, 2048, 906, 25, 70, "Text",
      CellTags->{"S5.98.1", "1.20"}],
    Cell[62192, 2075, 22868, 694, 70, "DefinitionBox",
      CellTags->"S5.98.1"],
    Cell[85063, 2771, 69, 1, 70, "Caption",
      CellTags->"S5.98.1"]},
  "1.1"->{
    Cell[1776, 53, 143, 6, 40, "Subsection",
      CellTags->{"S5.98.1", "1.1"}]},
  "1.2"->{
    Cell[1922, 61, 496, 10, 76, "Text",
      CellTags->{"S5.98.1", "1.2"}]},
  "1.3"->{
    Cell[13414, 420, 78, 1, 41, "MathCaption",
      CellTags->{"S5.98.1", "1.3"}]},
  "1.4"->{
    Cell[13591, 427, 198, 6, 41, "MathCaption",
      CellTags->{"S5.98.1", "1.4"}]},
  "1.5"->{
    Cell[14414, 463, 98, 1, 41, "MathCaption",
      CellTags->{"S5.98.1", "1.5"}]},
  "1.6"->{
    Cell[14802, 480, 221, 6, 58, "MathCaption",
      CellTags->{"S5.98.1", "1.6"}]},
  "1.7"->{
    Cell[15308, 501, 395, 11, 59, "Text",
      CellTags->{"S5.98.1", "1.7"}]},
  "1.8"->{
    Cell[19479, 611, 236, 8, 58, "MathCaption",
      CellTags->{"S5.98.1", "1.8"}]},
  "1.9"->{
    Cell[19974, 634, 90, 1, 41, "MathCaption",
      CellTags->{"S5.98.1", "1.9"}]},
  "1.10"->{
    Cell[22954, 734, 420, 9, 76, "Text",
      CellTags->{"S5.98.1", "1.10"}]},
  "1.11"->{
    Cell[23377, 745, 183, 5, 41, "MathCaption",
      CellTags->{"S5.98.1", "1.11"}]},
  "1.12"->{
    Cell[24028, 773, 135, 3, 41, "MathCaption",
      CellTags->{"S5.98.1", "1.12"}]},
  "1.13"->{
    Cell[24252, 782, 88, 1, 70, "MathCaption",
      CellTags->{"S5.98.1", "1.13"}]},
  "1.14"->{
    Cell[27399, 1001, 571, 14, 70, "Text",
      CellTags->{"S5.98.1", "1.14"}]},
  "1.15"->{
    Cell[27973, 1017, 249, 5, 70, "Text",
      CellTags->{"S5.98.1", "1.15"}]},
  "1.16"->{
    Cell[56228, 1746, 132, 3, 70, "MathCaption",
      CellTags->{"S5.98.1", "1.16"}]},
  "1.17"->{
    Cell[56473, 1755, 497, 15, 70, "MathCaption",
      CellTags->{"S5.98.1", "1.17"}]},
  "1.18"->{
    Cell[57271, 1786, 110, 1, 70, "MathCaption",
      CellTags->{"S5.98.1", "1.18"}]},
  "1.19"->{
    Cell[57693, 1803, 216, 5, 70, "MathCaption",
      CellTags->{"S5.98.1", "1.19"}]},
  "1.20"->{
    Cell[61283, 2048, 906, 25, 70, "Text",
      CellTags->{"S5.98.1", "1.20"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.98.1", 85780, 2791},
  {"1.1", 90154, 2906},
  {"1.2", 90248, 2909},
  {"1.3", 90337, 2912},
  {"1.4", 90433, 2915},
  {"1.5", 90530, 2918},
  {"1.6", 90626, 2921},
  {"1.7", 90723, 2924},
  {"1.8", 90814, 2927},
  {"1.9", 90911, 2930},
  {"1.10", 91008, 2933},
  {"1.11", 91100, 2936},
  {"1.12", 91199, 2939},
  {"1.13", 91298, 2942},
  {"1.14", 91396, 2945},
  {"1.15", 91490, 2948},
  {"1.16", 91583, 2951},
  {"1.17", 91683, 2954},
  {"1.18", 91784, 2957},
  {"1.19", 91884, 2960},
  {"1.20", 91984, 2963}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 143, 6, 40, "Subsection",
  CellTags->{"S5.98.1", "1.1"}],
Cell[1922, 61, 496, 10, 76, "Text",
  CellTags->{"S5.98.1", "1.2"}],
Cell[2421, 73, 10918, 342, 222, "DefinitionBox",
  CellTags->"S5.98.1"],
Cell[13342, 417, 69, 1, 17, "Caption",
  CellTags->"S5.98.1"],
Cell[13414, 420, 78, 1, 41, "MathCaption",
  CellTags->{"S5.98.1", "1.3"}],
Cell[13495, 423, 93, 2, 31, "Input",
  CellTags->"S5.98.1"],
Cell[13591, 427, 198, 6, 41, "MathCaption",
  CellTags->{"S5.98.1", "1.4"}],

Cell[CellGroupData[{
Cell[13814, 437, 129, 5, 51, "Input",
  CellTags->"S5.98.1"],
Cell[13946, 444, 453, 16, 27, "Output",
  CellTags->"S5.98.1"]
}, Open  ]],
Cell[14414, 463, 98, 1, 41, "MathCaption",
  CellTags->{"S5.98.1", "1.5"}],

Cell[CellGroupData[{
Cell[14537, 468, 85, 2, 31, "Input",
  CellTags->"S5.98.1"],
Cell[14625, 472, 162, 5, 27, "Output",
  CellTags->"S5.98.1"]
}, Open  ]],
Cell[14802, 480, 221, 6, 58, "MathCaption",
  CellTags->{"S5.98.1", "1.6"}],

Cell[CellGroupData[{
Cell[15048, 490, 93, 2, 31, "Input",
  CellTags->"S5.98.1"],
Cell[15144, 494, 149, 4, 27, "Output",
  CellTags->"S5.98.1"]
}, Open  ]],
Cell[15308, 501, 395, 11, 59, "Text",
  CellTags->{"S5.98.1", "1.7"}],
Cell[15706, 514, 3688, 92, 88, "DefinitionBox",
  CellTags->"S5.98.1"],
Cell[19397, 608, 79, 1, 17, "Caption",
  CellTags->"S5.98.1"],
Cell[19479, 611, 236, 8, 58, "MathCaption",
  CellTags->{"S5.98.1", "1.8"}],

Cell[CellGroupData[{
Cell[19740, 623, 87, 2, 31, "Input",
  CellTags->"S5.98.1"],
Cell[19830, 627, 129, 4, 27, "Output",
  CellTags->"S5.98.1"]
}, Open  ]],
Cell[19974, 634, 90, 1, 41, "MathCaption",
  CellTags->{"S5.98.1", "1.9"}],

Cell[CellGroupData[{
Cell[20089, 639, 89, 2, 31, "Input",
  CellTags->"S5.98.1"],
Cell[20181, 643, 74, 2, 27, "Output",
  CellTags->"S5.98.1"]
}, Open  ]],
Cell[20270, 648, 2607, 81, 128, "DefinitionBox",
  CellTags->"S5.98.1"],
Cell[22880, 731, 71, 1, 17, "Caption",
  CellTags->"S5.98.1"],
Cell[22954, 734, 420, 9, 76, "Text",
  CellTags->{"S5.98.1", "1.10"}],
Cell[23377, 745, 183, 5, 41, "MathCaption",
  CellTags->{"S5.98.1", "1.11"}],

Cell[CellGroupData[{
Cell[23585, 754, 90, 2, 31, "Input",
  CellTags->"S5.98.1"],
Cell[23678, 758, 335, 12, 27, "Output",
  CellTags->"S5.98.1"]
}, Open  ]],
Cell[24028, 773, 135, 3, 41, "MathCaption",
  CellTags->{"S5.98.1", "1.12"}],
Cell[24166, 778, 83, 2, 31, "Input",
  CellTags->"S5.98.1"],
Cell[24252, 782, 88, 1, 70, "MathCaption",
  CellTags->{"S5.98.1", "1.13"}],

Cell[CellGroupData[{
Cell[24365, 787, 77, 2, 70, "Input",
  CellTags->"S5.98.1"],
Cell[24445, 791, 2756, 199, 70, 2685, 196, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.98.1"],
Cell[27204, 992, 180, 6, 70, "Output",
  CellTags->"S5.98.1"]
}, Open  ]],
Cell[27399, 1001, 571, 14, 70, "Text",
  CellTags->{"S5.98.1", "1.14"}],
Cell[27973, 1017, 249, 5, 70, "Text",
  CellTags->{"S5.98.1", "1.15"}],
Cell[28225, 1024, 27925, 717, 70, "DefinitionBox",
  CellTags->"S5.98.1"],
Cell[56153, 1743, 72, 1, 70, "Caption",
  CellTags->"S5.98.1"],
Cell[56228, 1746, 132, 3, 70, "MathCaption",
  CellTags->{"S5.98.1", "1.16"}],
Cell[56363, 1751, 107, 2, 70, "Input",
  CellTags->"S5.98.1"],
Cell[56473, 1755, 497, 15, 70, "MathCaption",
  CellTags->{"S5.98.1", "1.17"}],

Cell[CellGroupData[{
Cell[56995, 1774, 102, 2, 70, "Input",
  CellTags->"S5.98.1"],
Cell[57100, 1778, 156, 5, 70, "Output",
  CellTags->"S5.98.1"]
}, Open  ]],
Cell[57271, 1786, 110, 1, 70, "MathCaption",
  CellTags->{"S5.98.1", "1.18"}],

Cell[CellGroupData[{
Cell[57406, 1791, 101, 2, 70, "Input",
  CellTags->"S5.98.1"],
Cell[57510, 1795, 168, 5, 70, "Output",
  CellTags->"S5.98.1"]
}, Open  ]],
Cell[57693, 1803, 216, 5, 70, "MathCaption",
  CellTags->{"S5.98.1", "1.19"}],

Cell[CellGroupData[{
Cell[57934, 1812, 102, 2, 70, "Input",
  CellTags->"S5.98.1"],
Cell[58039, 1816, 3045, 221, 70, 2974, 218, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.98.1"],
Cell[61087, 2039, 181, 6, 70, "Output",
  CellTags->"S5.98.1"]
}, Open  ]],
Cell[61283, 2048, 906, 25, 70, "Text",
  CellTags->{"S5.98.1", "1.20"}],
Cell[62192, 2075, 22868, 694, 70, "DefinitionBox",
  CellTags->"S5.98.1"],
Cell[85063, 2771, 69, 1, 70, "Caption",
  CellTags->"S5.98.1"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

