(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     31400,       1094]*)
(*NotebookOutlinePosition[     37592,       1279]*)
(*  CellTagsIndexPosition[     37077,       1255]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Statistics",
 StyleBox["`", "MB"],
 "DataSmoothing",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.99.1", "1.1"}],

Cell[TextData[{
 "A series of raw data ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["x",
       "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["x",
       "TI"], "2"], ",", "\[Ellipsis]", ",", 
     SubscriptBox[
      StyleBox["x",
       "TI"], 
      StyleBox["n",
       "TI"]]}], "}"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is sometimes transformed to a new series of data before it is analyzed. \
The purpose of this transformation is to smooth out local fluctuations in the \
raw data, so the transformation is called data smoothing or a smoother. One \
common type of smoother employs a linear transformation and is called a \
linear filter. A linear filter with weights ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["c",
       "TI"], "0"], ",", 
     SubscriptBox[
      StyleBox["c",
       "TI"], "1"], ",", "\[Ellipsis]", ",", 
     SubscriptBox[
      StyleBox["c",
       "TI"], 
      RowBox[{
       StyleBox["r",
        "TI"], "-", "1"}]]}], "}"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " transforms the given data to weighted averages ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{
      StyleBox["j",
       "TI"], "=", "0"}], 
     RowBox[{
      StyleBox["r",
       "TI"], "-", "1"}],
     LimitsPositioning->True], 
    SubscriptBox[
     StyleBox["c",
      "TI"], 
     StyleBox["j",
      "TI"]], 
    SubscriptBox[
     StyleBox["x",
      "TI"], 
     RowBox[{
      StyleBox["t",
       "TI"], "-", 
      StyleBox["j",
       "TI"]}]]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " for ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["t",
     "TI"], "=", 
    StyleBox["r",
     "TI"], ",", 
    StyleBox["r",
     "TI"], "+", "1", ",", "\[Ellipsis]", ",", 
    StyleBox["n",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". Notice that the new data set has length ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["n",
     "TI"], "-", 
    StyleBox["r",
     "TI"], "+", "1"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". If ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{
      StyleBox["j",
       "TI"], "=", "0"}], 
     RowBox[{
      StyleBox["r",
       "TI"], "-", "1"}],
     LimitsPositioning->True], 
    SubscriptBox[
     StyleBox["c",
      "TI"], 
     StyleBox["j",
      "TI"]], "=", "1"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " the linear filter is also called an ",
 Cell[BoxData[
  FormBox[
   StyleBox["r",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "\[Hyphen]term moving average. If all the weights are equal and they sum to \
unity, the linear filter is called a simple moving average. "
}], "Text",
 CellTags->{"S5.99.1", "1.2"}],

Cell[TextData[{
 "If the median of ",
 Cell[BoxData[
  FormBox[
   StyleBox["r",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " data points is substituted in place of the average, we obtain a moving \
median smoother of span ",
 Cell[BoxData[
  FormBox[
   StyleBox["r",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". Repeated application of a moving median smoother can quickly lead to \
convergence for odd ",
 Cell[BoxData[
  FormBox[
   StyleBox["r",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". Since the values at the ends of the data series are lost with each \
application of the smoother, we maintain the length of the series by adding \
on the end values from the original data at all the intermediate steps of \
repeated moving median smoothing. "
}], "Text",
 CellTags->{"S5.99.1", "1.3"}],

Cell[TextData[{
 "Exponential smoothing corresponds to a weighted average with exponentially \
decreasing weights. Let ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["y",
     "TI"], 
    StyleBox["t",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " be the smoothed value at time ",
 Cell[BoxData[
  FormBox[
   StyleBox["t",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", then ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["y",
     "TI"], 
    RowBox[{
     StyleBox["t",
      "TI"], "+", "1"}]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " can be obtained efficiently by using ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     StyleBox["y",
      "TI"], 
     RowBox[{
      StyleBox["t",
       "TI"], "+", "1"}]], "=", 
    SubscriptBox[
     StyleBox["y",
      "TI"], 
     StyleBox["t",
      "TI"]], "+", 
    StyleBox["a",
     "TI"], 
    RowBox[{"(", 
     RowBox[{
      SubscriptBox[
       StyleBox["x",
        "TI"], 
       RowBox[{
        StyleBox["t",
         "TI"], "+", "1"}]], "-", 
      SubscriptBox[
       StyleBox["y",
        "TI"], 
       StyleBox["t",
        "TI"]]}], ")"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " where ",
 Cell[BoxData[
  FormBox[
   StyleBox["a",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is the smoothing constant (",
 Cell[BoxData[
  FormBox[
   RowBox[{"0", "<", 
    StyleBox["a",
     "TI"], "<", "1"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "). An initial value ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["y",
     "TI"], "0"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is needed to start the iteration and it is commonly chosen to be ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["x",
     "TI"], "1"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". For multivariate data the smoothing constant can be a matrix. "
}], "Text",
 CellTags->{"S5.99.1", "1.4"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["MovingAverage[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["r", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["smooth ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" using a simple ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["r",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["\[Hyphen]term moving average ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["MovingMedian[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["r", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["smooth ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" using a moving median of span ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["r",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["MovingMedian[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["r", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", RepeatedSmoothing -> True]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["smooth ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" by repeatedly applying a moving median of span ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["r",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["LinearFilter[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["c",
          "TI"], "0"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["c",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] , ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["c",
          "TI"], 
         RowBox[{
          StyleBox["r",
           "TI"], "-", "1"}]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["pass the data ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"\[Ellipsis]", " "}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], 
         StyleBox["n",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" through the linear filter and give ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         UnderoverscriptBox["\[Sum]", 
          RowBox[{
           StyleBox["j",
            "TI"], "=", "0"}], 
          RowBox[{
           StyleBox["r",
            "TI"], "-", "1"}],
          LimitsPositioning->True], 
         SubscriptBox[
          StyleBox["c",
           "TI"], 
          StyleBox["j",
           "TI"]], 
         SubscriptBox[
          StyleBox["x",
           "TI"], 
          RowBox[{
           StyleBox["t",
            "TI"], "-", 
           StyleBox["j",
            "TI"]}]]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" for ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["t",
          "TI"], "=", 
         StyleBox["r",
          "TI"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["r",
          "TI"], "+", "1"}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"\[Ellipsis]", " "}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["n",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ExponentialSmoothing[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["a", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["smooth ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[
      " using an exponentially weighted average with a smoothing constant ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["a",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and a starting value set to the first entry in ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ExponentialSmoothing[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["a", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "0"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["smooth ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[
      " using an exponentially weighted average with a smoothing constant ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["a",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and a starting value ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "0"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.99.1"],

Cell["Data smoothing functions. ", "Caption",
 CellTags->"S5.99.1"],

Cell[TextData[{
 "The functions in this package work for both univariate and multivariate \
data. Data should be entered as a list in the univariate case, and a list of \
length\[Hyphen]",
 Cell[BoxData[
  FormBox[
   StyleBox["m",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " lists in the ",
 Cell[BoxData[
  FormBox[
   StyleBox["m",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "\[Hyphen]variate case. "
}], "Text",
 CellTags->{"S5.99.1", "1.5"}],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.99.1", "1.6"}],

Cell["<<Statistics`DataSmoothing`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.99.1"],

Cell["Data must be entered as a list. ", "MathCaption",
 CellTags->{"S5.99.1", "1.7"}],

Cell["data1 = {7.,4.,5.,3.,8.,5.,2.,3.,6.,8.};", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.99.1"],

Cell["\<\
Here is a simple 2\[Hyphen]term moving average. \
\>", "MathCaption",
 CellTags->{"S5.99.1", "1.8"}],

Cell[CellGroupData[{

Cell["MovingAverage[data1, 2]", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.99.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "5.5`", ",", "4.5`", ",", "4.`", ",", "5.5`", ",", "6.5`", ",", "3.5`", ",",
    "2.5`", ",", "4.5`", ",", "7.`"}], "}"}]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.99.1"]
}, Open  ]],

Cell["\<\
In the case of multivariate data, each entry in a data list is itself a list. \
\
\>", "MathCaption",
 CellTags->{"S5.99.1", "1.9"}],

Cell["data2 = {{a,b}, {c,d}, {e,f}, {g,h}};", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.99.1"],

Cell["\<\
This gives a simple 3\[Hyphen]term moving average of the \
two\[Hyphen]dimensional data. The moving average is done for each dimension \
(or column) of the data separately. \
\>", "MathCaption",
 CellTags->{"S5.99.1", "1.10"}],

Cell[CellGroupData[{

Cell["MovingAverage[data2, 3]", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.99.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      FractionBox["1", "3"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c", "+", "e"}], ")"}]}], ",", 
     RowBox[{
      FractionBox["1", "3"], " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "d", "+", "f"}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      FractionBox["1", "3"], " ", 
      RowBox[{"(", 
       RowBox[{"c", "+", "e", "+", "g"}], ")"}]}], ",", 
     RowBox[{
      FractionBox["1", "3"], " ", 
      RowBox[{"(", 
       RowBox[{"d", "+", "f", "+", "h"}], ")"}]}]}], "}"}]}], "}"}]], "Output",\

 CellLabel->"Out[5]= ",
 CellTags->"S5.99.1"]
}, Open  ]],

Cell["\<\
A moving median is an example of nonlinear smoothing. It is often used to \
preserve edges while eliminating noisy spikes in the data. This smooths the \
data using a moving median of span 3. \
\>", "MathCaption",
 CellTags->{"S5.99.1", "1.11"}],

Cell[CellGroupData[{

Cell["MovingMedian[data1, 3]", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.99.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "5.`", ",", "4.`", ",", "5.`", ",", "5.`", ",", "5.`", ",", "3.`", ",", 
   "3.`", ",", "6.`"}], "}"}]], "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S5.99.1"]
}, Open  ]],

Cell["\<\
Here smoothing is repeated until the result no longer changes. Only odd\
\[Hyphen]numbered spans are allowed in repeated smoothing to ensure \
convergence. \
\>", "MathCaption",
 CellTags->{"S5.99.1", "1.12"}],

Cell[CellGroupData[{

Cell["MovingMedian[data1, 3, RepeatedSmoothing->True]", "Input",
 CellLabel->"In[7]:= ",
 CellTags->"S5.99.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "5.`", ",", "5.`", ",", "5.`", ",", "5.`", ",", "5.`", ",", "3.`", ",", 
   "3.`", ",", "6.`"}], "}"}]], "Output",
 CellLabel->"Out[7]= ",
 CellTags->"S5.99.1"]
}, Open  ]],

Cell["\<\
Here is an example of smoothing multivariate data by a moving median. The \
moving median is done for each dimension (or column) of the data separately. \
\
\>", "MathCaption",
 CellTags->{"S5.99.1", "1.13"}],

Cell[CellGroupData[{

Cell["MovingMedian[{{3,4},{9,2},{1,5},{2,6},{2,3}}, 4]", "Input",
 CellLabel->"In[8]:= ",
 CellTags->"S5.99.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox["5", "2"], ",", 
     FractionBox["9", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[8]= ",
 CellTags->"S5.99.1"]
}, Open  ]],

Cell["\<\
A simple moving average is a special case of a linear filter where all the \
weights are equal and their sum is unity. \
\>", "MathCaption",
 CellTags->{"S5.99.1", "1.14"}],

Cell[CellGroupData[{

Cell["LinearFilter[data1, {1/2, 1/2}]", "Input",
 CellLabel->"In[9]:= ",
 CellTags->"S5.99.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "5.5`", ",", "4.5`", ",", "4.`", ",", "5.5`", ",", "6.5`", ",", "3.5`", ",",
    "2.5`", ",", "4.5`", ",", "7.`"}], "}"}]], "Output",
 CellLabel->"Out[9]= ",
 CellTags->"S5.99.1"]
}, Open  ]],

Cell[TextData[{
 "This linear filter has weights ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     StyleBox["c",
      "TI"], "0"], "=", "1", ",", 
    SubscriptBox[
     StyleBox["c",
      "TI"], "1"], "=", "2", ",", 
    SubscriptBox[
     StyleBox["c",
      "TI"], "2"], "=", "3"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and gives ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     StyleBox["x",
      "TI"], 
     StyleBox["t",
      "TI"]], "+", "2", 
    SubscriptBox[
     StyleBox["x",
      "TI"], 
     RowBox[{
      StyleBox["t",
       "TI"], "-", "1"}]], "+", "3", 
    SubscriptBox[
     StyleBox["x",
      "TI"], 
     RowBox[{
      StyleBox["t",
       "TI"], "-", "2"}]]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". Notice the order in which the weights are entered. "
}], "MathCaption",
 CellTags->{"S5.99.1", "1.15"}],

Cell[CellGroupData[{

Cell["LinearFilter[data1, {1, 2, 3}]", "Input",
 CellLabel->"In[10]:= ",
 CellTags->"S5.99.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "34.`", ",", "25.`", ",", "29.`", ",", "30.`", ",", "36.`", ",", "22.`", 
   ",", "18.`", ",", "29.`"}], "}"}]], "Output",
 CellLabel->"Out[10]= ",
 CellTags->"S5.99.1"]
}, Open  ]],

Cell[TextData[{
 "For multivariate data you can include matrix weights for the linear filter. \
Here the weights are ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     StyleBox["c",
      "TI"], "0"], "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "0.5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.5", ",", "1"}], "}"}]}], "}"}]}], TraditionalForm]], 
  "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     StyleBox["c",
      "TI"], "1"], "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], TraditionalForm]], 
  "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.99.1", "1.16"}],

Cell[CellGroupData[{

Cell["LinearFilter[data2, {{{1,0.5},{0.5,1}},{{1,0},{0,1}}}]", "Input",
 CellLabel->"In[11]:= ",
 CellTags->"S5.99.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "+", "c", "+", 
      RowBox[{"0.5`", " ", "d"}]}], ",", 
     RowBox[{"b", "+", 
      RowBox[{"0.5`", " ", "c"}], "+", "d"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"c", "+", "e", "+", 
      RowBox[{"0.5`", " ", "f"}]}], ",", 
     RowBox[{"d", "+", 
      RowBox[{"0.5`", " ", "e"}], "+", "f"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"e", "+", "g", "+", 
      RowBox[{"0.5`", " ", "h"}]}], ",", 
     RowBox[{"f", "+", 
      RowBox[{"0.5`", " ", "g"}], "+", "h"}]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[11]= ",
 CellTags->"S5.99.1"]
}, Open  ]],

Cell["\<\
Here exponential smoothing is done with the smoothing constant 0.8 and \
starting value 0.5. \
\>", "MathCaption",
 CellTags->{"S5.99.1", "1.17"}],

Cell[CellGroupData[{

Cell["ExponentialSmoothing[data1, 0.8, 0.5]", "Input",
 CellLabel->"In[12]:= ",
 CellTags->"S5.99.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "5.7`", ",", "4.34`", ",", "4.868`", ",", "3.3735999999999997`", ",", 
   "7.07472`", ",", "5.414944`", ",", "2.6829888`", ",", "2.93659776`", ",", 
   "5.387319552`", ",", "7.4774639104`"}], "}"}]], "Output",
 CellLabel->"Out[12]= ",
 CellTags->"S5.99.1"]
}, Open  ]],

Cell["\<\
This time the starting value is taken to be the first entry in the data list, \
which is 7. \
\>", "MathCaption",
 CellTags->{"S5.99.1", "1.18"}],

Cell[CellGroupData[{

Cell["ExponentialSmoothing[data1, 0.8]", "Input",
 CellLabel->"In[13]:= ",
 CellTags->"S5.99.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "7.`", ",", "4.6`", ",", "4.92`", ",", "3.384`", ",", "7.0768`", ",", 
   "5.41536`", ",", "2.6830719999999997`", ",", "2.9366144`", ",", 
   "5.38732288`", ",", "7.477464576`"}], "}"}]], "Output",
 CellLabel->"Out[13]= ",
 CellTags->"S5.99.1"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.99.1"->{
    Cell[1776, 53, 140, 6, 36, "Subsection",
      CellTags->{"S5.99.1", "1.1"}],
    Cell[1919, 61, 3107, 115, 140, "Text",
      CellTags->{"S5.99.1", "1.2"}],
    Cell[5029, 178, 952, 26, 88, "Text",
      CellTags->{"S5.99.1", "1.3"}],
    Cell[5984, 206, 2257, 87, 90, "Text",
      CellTags->{"S5.99.1", "1.4"}],
    Cell[8244, 295, 13843, 431, 242, "DefinitionBox",
      CellTags->"S5.99.1"],
    Cell[22090, 728, 67, 1, 15, "Caption",
      CellTags->"S5.99.1"],
    Cell[22160, 731, 549, 17, 40, "Text",
      CellTags->{"S5.99.1", "1.5"}],
    Cell[22712, 750, 78, 1, 70, "MathCaption",
      CellTags->{"S5.99.1", "1.6"}],
    Cell[22793, 753, 90, 2, 70, "Input",
      CellTags->"S5.99.1"],
    Cell[22886, 757, 86, 1, 70, "MathCaption",
      CellTags->{"S5.99.1", "1.7"}],
    Cell[22975, 760, 103, 2, 70, "Input",
      CellTags->"S5.99.1"],
    Cell[23081, 764, 110, 3, 70, "MathCaption",
      CellTags->{"S5.99.1", "1.8"}],
    Cell[23216, 771, 86, 2, 70, "Input",
      CellTags->"S5.99.1"],
    Cell[23305, 775, 221, 6, 70, "Output",
      CellTags->"S5.99.1"],
    Cell[23541, 784, 142, 4, 70, "MathCaption",
      CellTags->{"S5.99.1", "1.9"}],
    Cell[23686, 790, 100, 2, 70, "Input",
      CellTags->"S5.99.1"],
    Cell[23789, 794, 236, 5, 70, "MathCaption",
      CellTags->{"S5.99.1", "1.10"}],
    Cell[24050, 803, 86, 2, 70, "Input",
      CellTags->"S5.99.1"],
    Cell[24139, 807, 683, 25, 70, "Output",
      CellTags->"S5.99.1"],
    Cell[24837, 835, 255, 5, 70, "MathCaption",
      CellTags->{"S5.99.1", "1.11"}],
    Cell[25117, 844, 85, 2, 70, "Input",
      CellTags->"S5.99.1"],
    Cell[25205, 848, 202, 6, 70, "Output",
      CellTags->"S5.99.1"],
    Cell[25422, 857, 219, 5, 70, "MathCaption",
      CellTags->{"S5.99.1", "1.12"}],
    Cell[25666, 866, 110, 2, 70, "Input",
      CellTags->"S5.99.1"],
    Cell[25779, 870, 202, 6, 70, "Output",
      CellTags->"S5.99.1"],
    Cell[25996, 879, 218, 5, 70, "MathCaption",
      CellTags->{"S5.99.1", "1.13"}],
    Cell[26239, 888, 111, 2, 70, "Input",
      CellTags->"S5.99.1"],
    Cell[26353, 892, 265, 10, 70, "Output",
      CellTags->"S5.99.1"],
    Cell[26633, 905, 182, 4, 70, "MathCaption",
      CellTags->{"S5.99.1", "1.14"}],
    Cell[26840, 913, 94, 2, 70, "Input",
      CellTags->"S5.99.1"],
    Cell[26937, 917, 221, 6, 70, "Output",
      CellTags->"S5.99.1"],
    Cell[27173, 926, 959, 39, 70, "MathCaption",
      CellTags->{"S5.99.1", "1.15"}],
    Cell[28157, 969, 94, 2, 70, "Input",
      CellTags->"S5.99.1"],
    Cell[28254, 973, 211, 6, 70, "Output",
      CellTags->"S5.99.1"],
    Cell[28480, 982, 895, 34, 70, "MathCaption",
      CellTags->{"S5.99.1", "1.16"}],
    Cell[29400, 1020, 118, 2, 70, "Input",
      CellTags->"S5.99.1"],
    Cell[29521, 1024, 673, 22, 70, "Output",
      CellTags->"S5.99.1"],
    Cell[30209, 1049, 156, 4, 70, "MathCaption",
      CellTags->{"S5.99.1", "1.17"}],
    Cell[30390, 1057, 101, 2, 70, "Input",
      CellTags->"S5.99.1"],
    Cell[30494, 1061, 298, 7, 70, "Output",
      CellTags->"S5.99.1"],
    Cell[30807, 1071, 155, 4, 70, "MathCaption",
      CellTags->{"S5.99.1", "1.18"}],
    Cell[30987, 1079, 96, 2, 70, "Input",
      CellTags->"S5.99.1"],
    Cell[31086, 1083, 286, 7, 70, "Output",
      CellTags->"S5.99.1"]},
  "1.1"->{
    Cell[1776, 53, 140, 6, 36, "Subsection",
      CellTags->{"S5.99.1", "1.1"}]},
  "1.2"->{
    Cell[1919, 61, 3107, 115, 140, "Text",
      CellTags->{"S5.99.1", "1.2"}]},
  "1.3"->{
    Cell[5029, 178, 952, 26, 88, "Text",
      CellTags->{"S5.99.1", "1.3"}]},
  "1.4"->{
    Cell[5984, 206, 2257, 87, 90, "Text",
      CellTags->{"S5.99.1", "1.4"}]},
  "1.5"->{
    Cell[22160, 731, 549, 17, 40, "Text",
      CellTags->{"S5.99.1", "1.5"}]},
  "1.6"->{
    Cell[22712, 750, 78, 1, 70, "MathCaption",
      CellTags->{"S5.99.1", "1.6"}]},
  "1.7"->{
    Cell[22886, 757, 86, 1, 70, "MathCaption",
      CellTags->{"S5.99.1", "1.7"}]},
  "1.8"->{
    Cell[23081, 764, 110, 3, 70, "MathCaption",
      CellTags->{"S5.99.1", "1.8"}]},
  "1.9"->{
    Cell[23541, 784, 142, 4, 70, "MathCaption",
      CellTags->{"S5.99.1", "1.9"}]},
  "1.10"->{
    Cell[23789, 794, 236, 5, 70, "MathCaption",
      CellTags->{"S5.99.1", "1.10"}]},
  "1.11"->{
    Cell[24837, 835, 255, 5, 70, "MathCaption",
      CellTags->{"S5.99.1", "1.11"}]},
  "1.12"->{
    Cell[25422, 857, 219, 5, 70, "MathCaption",
      CellTags->{"S5.99.1", "1.12"}]},
  "1.13"->{
    Cell[25996, 879, 218, 5, 70, "MathCaption",
      CellTags->{"S5.99.1", "1.13"}]},
  "1.14"->{
    Cell[26633, 905, 182, 4, 70, "MathCaption",
      CellTags->{"S5.99.1", "1.14"}]},
  "1.15"->{
    Cell[27173, 926, 959, 39, 70, "MathCaption",
      CellTags->{"S5.99.1", "1.15"}]},
  "1.16"->{
    Cell[28480, 982, 895, 34, 70, "MathCaption",
      CellTags->{"S5.99.1", "1.16"}]},
  "1.17"->{
    Cell[30209, 1049, 156, 4, 70, "MathCaption",
      CellTags->{"S5.99.1", "1.17"}]},
  "1.18"->{
    Cell[30807, 1071, 155, 4, 70, "MathCaption",
      CellTags->{"S5.99.1", "1.18"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.99.1", 32023, 1110},
  {"1.1", 35324, 1197},
  {"1.2", 35418, 1200},
  {"1.3", 35510, 1203},
  {"1.4", 35600, 1206},
  {"1.5", 35691, 1209},
  {"1.6", 35782, 1212},
  {"1.7", 35878, 1215},
  {"1.8", 35974, 1218},
  {"1.9", 36071, 1221},
  {"1.10", 36169, 1224},
  {"1.11", 36268, 1227},
  {"1.12", 36367, 1230},
  {"1.13", 36466, 1233},
  {"1.14", 36565, 1236},
  {"1.15", 36664, 1239},
  {"1.16", 36764, 1242},
  {"1.17", 36864, 1245},
  {"1.18", 36964, 1248}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 140, 6, 36, "Subsection",
  CellTags->{"S5.99.1", "1.1"}],
Cell[1919, 61, 3107, 115, 140, "Text",
  CellTags->{"S5.99.1", "1.2"}],
Cell[5029, 178, 952, 26, 88, "Text",
  CellTags->{"S5.99.1", "1.3"}],
Cell[5984, 206, 2257, 87, 90, "Text",
  CellTags->{"S5.99.1", "1.4"}],
Cell[8244, 295, 13843, 431, 242, "DefinitionBox",
  CellTags->"S5.99.1"],
Cell[22090, 728, 67, 1, 15, "Caption",
  CellTags->"S5.99.1"],
Cell[22160, 731, 549, 17, 40, "Text",
  CellTags->{"S5.99.1", "1.5"}],
Cell[22712, 750, 78, 1, 70, "MathCaption",
  CellTags->{"S5.99.1", "1.6"}],
Cell[22793, 753, 90, 2, 70, "Input",
  CellTags->"S5.99.1"],
Cell[22886, 757, 86, 1, 70, "MathCaption",
  CellTags->{"S5.99.1", "1.7"}],
Cell[22975, 760, 103, 2, 70, "Input",
  CellTags->"S5.99.1"],
Cell[23081, 764, 110, 3, 70, "MathCaption",
  CellTags->{"S5.99.1", "1.8"}],

Cell[CellGroupData[{
Cell[23216, 771, 86, 2, 70, "Input",
  CellTags->"S5.99.1"],
Cell[23305, 775, 221, 6, 70, "Output",
  CellTags->"S5.99.1"]
}, Open  ]],
Cell[23541, 784, 142, 4, 70, "MathCaption",
  CellTags->{"S5.99.1", "1.9"}],
Cell[23686, 790, 100, 2, 70, "Input",
  CellTags->"S5.99.1"],
Cell[23789, 794, 236, 5, 70, "MathCaption",
  CellTags->{"S5.99.1", "1.10"}],

Cell[CellGroupData[{
Cell[24050, 803, 86, 2, 70, "Input",
  CellTags->"S5.99.1"],
Cell[24139, 807, 683, 25, 70, "Output",
  CellTags->"S5.99.1"]
}, Open  ]],
Cell[24837, 835, 255, 5, 70, "MathCaption",
  CellTags->{"S5.99.1", "1.11"}],

Cell[CellGroupData[{
Cell[25117, 844, 85, 2, 70, "Input",
  CellTags->"S5.99.1"],
Cell[25205, 848, 202, 6, 70, "Output",
  CellTags->"S5.99.1"]
}, Open  ]],
Cell[25422, 857, 219, 5, 70, "MathCaption",
  CellTags->{"S5.99.1", "1.12"}],

Cell[CellGroupData[{
Cell[25666, 866, 110, 2, 70, "Input",
  CellTags->"S5.99.1"],
Cell[25779, 870, 202, 6, 70, "Output",
  CellTags->"S5.99.1"]
}, Open  ]],
Cell[25996, 879, 218, 5, 70, "MathCaption",
  CellTags->{"S5.99.1", "1.13"}],

Cell[CellGroupData[{
Cell[26239, 888, 111, 2, 70, "Input",
  CellTags->"S5.99.1"],
Cell[26353, 892, 265, 10, 70, "Output",
  CellTags->"S5.99.1"]
}, Open  ]],
Cell[26633, 905, 182, 4, 70, "MathCaption",
  CellTags->{"S5.99.1", "1.14"}],

Cell[CellGroupData[{
Cell[26840, 913, 94, 2, 70, "Input",
  CellTags->"S5.99.1"],
Cell[26937, 917, 221, 6, 70, "Output",
  CellTags->"S5.99.1"]
}, Open  ]],
Cell[27173, 926, 959, 39, 70, "MathCaption",
  CellTags->{"S5.99.1", "1.15"}],

Cell[CellGroupData[{
Cell[28157, 969, 94, 2, 70, "Input",
  CellTags->"S5.99.1"],
Cell[28254, 973, 211, 6, 70, "Output",
  CellTags->"S5.99.1"]
}, Open  ]],
Cell[28480, 982, 895, 34, 70, "MathCaption",
  CellTags->{"S5.99.1", "1.16"}],

Cell[CellGroupData[{
Cell[29400, 1020, 118, 2, 70, "Input",
  CellTags->"S5.99.1"],
Cell[29521, 1024, 673, 22, 70, "Output",
  CellTags->"S5.99.1"]
}, Open  ]],
Cell[30209, 1049, 156, 4, 70, "MathCaption",
  CellTags->{"S5.99.1", "1.17"}],

Cell[CellGroupData[{
Cell[30390, 1057, 101, 2, 70, "Input",
  CellTags->"S5.99.1"],
Cell[30494, 1061, 298, 7, 70, "Output",
  CellTags->"S5.99.1"]
}, Open  ]],
Cell[30807, 1071, 155, 4, 70, "MathCaption",
  CellTags->{"S5.99.1", "1.18"}],

Cell[CellGroupData[{
Cell[30987, 1079, 96, 2, 70, "Input",
  CellTags->"S5.99.1"],
Cell[31086, 1083, 286, 7, 70, "Output",
  CellTags->"S5.99.1"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

