(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     83258,       2610]*)
(*NotebookOutlinePosition[     91922,       2869]*)
(*  CellTagsIndexPosition[     91183,       2836]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Statistics",
 StyleBox["`", "MB"],
 "DescriptiveStatistics",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S6.0.1", "1.1"}],

Cell[TextData[{
 "Descriptive statistics refers to properties of distributions, such as \
location, dispersion, and shape. The functions in this package compute \
descriptive statistics of lists of data. You can calculate some of the \
standard descriptive statistics for various known distributions by using the \
",
 StyleBox["Statistics`ContinuousDistributions`", "MR"],
 " and ",
 StyleBox["Statistics`DiscreteDistributions`", "MR"],
 " packages. This package also provides some commonly used data \
transformations. "
}], "Text",
 CellTags->{"S6.0.1", "1.2"}],

Cell[TextData[{
 "Note that this package is automatically loaded when most other statistical \
packages are used. For example, all the functions described below are \
available for use with the package ",
 StyleBox["Statistics`HypothesisTests`", "MR"],
 ". "
}], "Text",
 CellTags->{"S6.0.1", "1.3"}],

Cell[TextData[{
 "The statistics are calculated assuming that each value of data ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["x",
     "TI"], 
    StyleBox["i",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " has probability equal to ",
 Cell[BoxData[
  FormBox[
   FractionBox["1", 
    StyleBox["n",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", where ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is the number of elements in the data. "
}], "Text",
 CellTags->{"S6.0.1", "1.4"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["Mean[", "MR",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{
      RowLines->{
       False, False, False, False, False, False, False, False, False, False, 
        True},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["average value ",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         FractionBox["1", 
          StyleBox["n",
           "TI"]], 
         UnderscriptBox["\[Sum]", 
          StyleBox["i",
           "TI"],
          LimitsPositioning->True], 
         SubscriptBox[
          StyleBox["x",
           "TI"], 
          StyleBox["i",
           "TI"]]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{
      RowLines->{
       False, False, False, False, False, False, False, False, False, False, 
        True},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Median[", "MR",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{
      RowLines->{
       False, False, False, False, False, False, False, False, False, False, 
        True},
      RowSpacings->0.4}], Cell[TextData[StyleBox["median (central value)",
      GridBoxOptions->{
      RowLines->{
       False, False, False, False, False, False, False, False, False, False, 
        True},
      RowSpacings->0.4}]],
      GridBoxOptions->{
      RowLines->{
       False, False, False, False, False, False, False, False, False, False, 
        True},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Mode[", "MR",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{
      RowLines->{
       False, False, False, False, False, False, False, False, False, False, 
        True},
      RowSpacings->0.4}], Cell[TextData[StyleBox["mode ",
      GridBoxOptions->{
      RowLines->{
       False, False, False, False, False, False, False, False, False, False, 
        True},
      RowSpacings->0.4}]],
      GridBoxOptions->{
      RowLines->{
       False, False, False, False, False, False, False, False, False, False, 
        True},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["GeometricMean[", "MR",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{
      RowLines->{
       False, False, False, False, False, False, False, False, False, False, 
        True},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["geometric mean ",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           UnderscriptBox["\[Product]", 
            StyleBox["i",
             "TI"],
            LimitsPositioning->True], 
           SubscriptBox[
            StyleBox["x",
             "TI"], 
            StyleBox["i",
             "TI"]]}], ")"}], 
         FractionBox["1", 
          StyleBox["n",
           "TI"]]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{
      RowLines->{
       False, False, False, False, False, False, False, False, False, False, 
        True},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["HarmonicMean[", "MR",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{
      RowLines->{
       False, False, False, False, False, False, False, False, False, False, 
        True},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["harmonic mean ",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["n",
          "TI"], "/", 
         UnderscriptBox["\[Sum]", 
          StyleBox["i",
           "TI"],
          LimitsPositioning->True], 
         FractionBox["1", 
          SubscriptBox[
           StyleBox["x",
            "TI"], 
           StyleBox["i",
            "TI"]]]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{
      RowLines->{
       False, False, False, False, False, False, False, False, False, False, 
        True},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["RootMeanSquare[", "MR",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{
      RowLines->{
       False, False, False, False, False, False, False, False, False, False, 
        True},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["root mean square ",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SqrtBox[
         RowBox[{
          FractionBox["1", 
           StyleBox["n",
            "TI"]], 
          UnderscriptBox["\[Sum]", 
           StyleBox["i",
            "TI"],
           LimitsPositioning->True], 
          SubsuperscriptBox[
           StyleBox["x",
            "TI"], 
           StyleBox["i",
            "TI"], "2"]}]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{
      RowLines->{
       False, False, False, False, False, False, False, False, False, False, 
        True},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["TrimmedMean[", "MR",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{
      RowLines->{
       False, False, False, False, False, False, False, False, False, False, 
        True},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["mean of remaining entries, when a fraction ",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}],
      StyleBox[" is removed from each end of the sorted list of data ",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{
      RowLines->{
       False, False, False, False, False, False, False, False, False, False, 
        True},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["TrimmedMean[", "MR",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["f",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["f",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{
      RowLines->{
       False, False, False, False, False, False, False, False, False, False, 
        True},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["mean of remaining entries, when fractions ",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["f",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}],
      StyleBox[" and ",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["f",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}],
      StyleBox[" are dropped from each end of the sorted data ",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{
      RowLines->{
       False, False, False, False, False, False, False, False, False, False, 
        True},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Quantile[", "MR",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}],
      StyleBox["q", "TI",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{
      RowLines->{
       False, False, False, False, False, False, False, False, False, False, 
        True},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["q",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SuperscriptBox["\[Null]", "th"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}],
      StyleBox[" quantile ",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{
      RowLines->{
       False, False, False, False, False, False, False, False, False, False, 
        True},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["InterpolatedQuantile[", "MR",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}],
      StyleBox["q", "TI",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{
      RowLines->{
       False, False, False, False, False, False, False, False, False, False, 
        True},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["q",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SuperscriptBox["\[Null]", "th"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}],
      StyleBox[
      " quantile of the distribution inferred by linear interpolation of the \
entries in the list of data ",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{
      RowLines->{
       False, False, False, False, False, False, False, False, False, False, 
        True},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Quartiles[", "MR",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{
      RowLines->{
       False, False, False, False, False, False, False, False, False, False, 
        True},
      RowSpacings->0.4}], Cell[TextData[StyleBox["list of quartiles ",
      GridBoxOptions->{
      RowLines->{
       False, False, False, False, False, False, False, False, False, False, 
        True},
      RowSpacings->0.4}]],
      GridBoxOptions->{
      RowLines->{
       False, False, False, False, False, False, False, False, False, False, 
        True},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["LocationReport[", "MR",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{
      RowLines->{
       False, False, False, False, False, False, False, False, False, False, 
        True},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["list of location statistics including ",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}],
      StyleBox["Mean", "MR",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}],
      StyleBox["HarmonicMean", "MR",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}],
      StyleBox[", and ",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}],
      StyleBox["Median", "MR",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{
      RowLines->{
       False, False, False, False, False, False, False, False, False, False, 
        True},
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{
 RowLines->{
  False, False, False, False, False, False, False, False, False, False, True},
 
 RowSpacings->0.4},
 CellTags->"S6.0.1"],

Cell["Location statistics. ", "Caption",
 CellTags->"S6.0.1"],

Cell[TextData[{
 "Location statistics describe where the data are located. The most common \
functions include measures of central tendency like the mean, median, and \
mode. ",
 StyleBox["Quantile[", "MR"],
 StyleBox["data", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["q", "TI"],
 StyleBox["]", "MR"],
 " gives the location before which ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"100", 
     StyleBox["q",
      "TI"]}], ")"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " percent of the data lie. In other words, ",
 StyleBox["Quantile", "MR"],
 " gives a value ",
 Cell[BoxData[
  FormBox[
   StyleBox["z",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " such that the probability that ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     SubscriptBox[
      StyleBox["x",
       "TI"], 
      StyleBox["i",
       "TI"]], "<", 
     StyleBox["z",
      "TI"]}], ")"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is less than or equal to ",
 Cell[BoxData[
  FormBox[
   StyleBox["q",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and the probability that ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     SubscriptBox[
      StyleBox["x",
       "TI"], 
      StyleBox["i",
       "TI"]], "\[LessEqual]", 
     StyleBox["z",
      "TI"]}], ")"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is greater than or equal to ",
 Cell[BoxData[
  FormBox[
   StyleBox["q",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". The interpolated quantile values at ",
 Cell[BoxData[
  FormBox[
   StyleBox["q",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " = 0.25, 0.5 and 0.75 are called the quartiles, and you can obtain them \
using ",
 StyleBox["Quartiles", "MR"],
 ". "
}], "Text",
 CellTags->{"S6.0.1", "1.5"}],

Cell[TextData[{
 "Note that the functions ",
 StyleBox["Mean", "MR"],
 ", ",
 StyleBox["Median", "MR"],
 ", and ",
 StyleBox["Quantile", "MR"],
 " are found in the kernel. This package does not need to be loaded to use \
them on lists of data. "
}], "Text",
 CellTags->{"S6.0.1", "1.6"}],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S6.0.1", "1.7"}],

Cell["<<Statistics`DescriptiveStatistics`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S6.0.1"],

Cell["Here is a data set. ", "MathCaption",
 CellTags->{"S6.0.1", "1.8"}],

Cell[CellGroupData[{

Cell["data = {6.5, 3.8, 6.6, 5.7, 6.0, 6.4, 5.3}", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S6.0.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "6.5`", ",", "3.8`", ",", "6.6`", ",", "5.7`", ",", "6.`", ",", "6.4`", ",",
    "5.3`"}], "}"}]], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S6.0.1"]
}, Open  ]],

Cell["\<\
This gives some general location information about the data. \
\>", "MathCaption",
 CellTags->{"S6.0.1", "1.9"}],

Cell[CellGroupData[{

Cell["LocationReport[data]", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S6.0.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Mean", "\[Rule]", "5.757142857142857`"}], ",", 
   RowBox[{"HarmonicMean", "\[Rule]", "5.575229440519171`"}], ",", 
   RowBox[{"Median", "\[Rule]", "6.`"}]}], "}"}]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S6.0.1"]
}, Open  ]],

Cell[TextData[{
 "You can use the replacement operator ",
 StyleBox["/.", "MR"],
 " to extract a particular statistic from the report."
}], "MathCaption",
 CellTags->{"S6.0.1", "1.10"}],

Cell[CellGroupData[{

Cell["m = Mean /. %", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S6.0.1"],

Cell[BoxData["5.757142857142857`"], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S6.0.1"]
}, Open  ]],

Cell[TextData[{
 "This is the mean when the smallest entry in the list is excluded. ",
 StyleBox["TrimmedMean", "MR"],
 " allows you to describe the data with removed outliers. "
}], "MathCaption",
 CellTags->{"S6.0.1", "1.11"}],

Cell[CellGroupData[{

Cell["TrimmedMean[data, {1/7, 0}]", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S6.0.1"],

Cell[BoxData["6.083333333333333`"], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S6.0.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["SampleRange[", "MR",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{
      RowLines->{
       False, False, False, False, False, False, False, False, False, False, 
        False, True},
      RowSpacings->0.4}], Cell[TextData[StyleBox["range ",
      GridBoxOptions->{
      RowLines->{
       False, False, False, False, False, False, False, False, False, False, 
        False, True},
      RowSpacings->0.4}]],
      GridBoxOptions->{
      RowLines->{
       False, False, False, False, False, False, False, False, False, False, 
        False, True},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Variance[", "MR",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{
      RowLines->{
       False, False, False, False, False, False, False, False, False, False, 
        False, True},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["unbiased estimate of variance, ",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         FractionBox["1", 
          RowBox[{
           StyleBox["n",
            "TI"], "-", "1"}]], 
         UnderscriptBox["\[Sum]", 
          StyleBox["i",
           "TI"],
          LimitsPositioning->True], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SubscriptBox[
             StyleBox["x",
              "TI"], 
             StyleBox["i",
              "TI"]], "-", 
            OverscriptBox[
             StyleBox["x",
              "TI"], "_"]}], ")"}], "2"]}], TraditionalForm]], 
       "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{
      RowLines->{
       False, False, False, False, False, False, False, False, False, False, 
        False, True},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["VarianceMLE[", "MR",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{
      RowLines->{
       False, False, False, False, False, False, False, False, False, False, 
        False, True},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["maximum likelihood estimate of variance, ",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         FractionBox["1", 
          StyleBox["n",
           "TI"]], 
         UnderscriptBox["\[Sum]", 
          StyleBox["i",
           "TI"],
          LimitsPositioning->True], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SubscriptBox[
             StyleBox["x",
              "TI"], 
             StyleBox["i",
              "TI"]], "-", 
            OverscriptBox[
             StyleBox["x",
              "TI"], "_"]}], ")"}], "2"]}], TraditionalForm]], 
       "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{
      RowLines->{
       False, False, False, False, False, False, False, False, False, False, 
        False, True},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["VarianceOfSampleMean[", "MR",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{
      RowLines->{
       False, False, False, False, False, False, False, False, False, False, 
        False, True},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["unbiased estimate of variance of sample mean, ",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        FractionBox["1", 
         StyleBox["n",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}],
      StyleBox["Variance[", "MR",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{
      RowLines->{
       False, False, False, False, False, False, False, False, False, False, 
        False, True},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["StandardDeviation[", "MR",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{
      RowLines->{
       False, False, False, False, False, False, False, False, False, False, 
        False, True},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "unbiased estimate of standard deviation ",
      GridBoxOptions->{
      RowLines->{
       False, False, False, False, False, False, False, False, False, False, 
        False, True},
      RowSpacings->0.4}]],
      GridBoxOptions->{
      RowLines->{
       False, False, False, False, False, False, False, False, False, False, 
        False, True},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["StandardDeviationMLE[", "MR",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{
      RowLines->{
       False, False, False, False, False, False, False, False, False, False, 
        False, True},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "maximum likelihood estimate of standard deviation ",
      GridBoxOptions->{
      RowLines->{
       False, False, False, False, False, False, False, False, False, False, 
        False, True},
      RowSpacings->0.4}]],
      GridBoxOptions->{
      RowLines->{
       False, False, False, False, False, False, False, False, False, False, 
        False, True},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["StandardErrorOfSampleMean[", "MR",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{
      RowLines->{
       False, False, False, False, False, False, False, False, False, False, 
        False, True},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "unbiased estimate of standard error (standard deviation) of sample mean \
",
      GridBoxOptions->{
      RowLines->{
       False, False, False, False, False, False, False, False, False, False, 
        False, True},
      RowSpacings->0.4}]],
      GridBoxOptions->{
      RowLines->{
       False, False, False, False, False, False, False, False, False, False, 
        False, True},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["CoefficientOfVariation[", "MR",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{
      RowLines->{
       False, False, False, False, False, False, False, False, False, False, 
        False, True},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "coefficient of variation (ratio of standard deviation to mean)",
      GridBoxOptions->{
      RowLines->{
       False, False, False, False, False, False, False, False, False, False, 
        False, True},
      RowSpacings->0.4}]],
      GridBoxOptions->{
      RowLines->{
       False, False, False, False, False, False, False, False, False, False, 
        False, True},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["MeanDeviation[", "MR",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{
      RowLines->{
       False, False, False, False, False, False, False, False, False, False, 
        False, True},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["mean absolute deviation, ",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         FractionBox["1", 
          StyleBox["n",
           "TI"]], 
         UnderscriptBox["\[Sum]", 
          StyleBox["i",
           "TI"],
          LimitsPositioning->True], "\[VerticalSeparator]", 
         SubscriptBox[
          StyleBox["x",
           "TI"], 
          StyleBox["i",
           "TI"]], "-", 
         OverscriptBox[
          StyleBox["x",
           "TI"], "_"], "\[VerticalSeparator]"}], TraditionalForm]], 
       "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{
      RowLines->{
       False, False, False, False, False, False, False, False, False, False, 
        False, True},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["MedianDeviation[", "MR",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{
      RowLines->{
       False, False, False, False, False, False, False, False, False, False, 
        False, True},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["median absolute deviation, median of ",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"\[VerticalSeparator]", 
         SubscriptBox[
          StyleBox["x",
           "TI"], 
          StyleBox["i",
           "TI"]], "-", 
         StyleBox["median",
          "TI"], "\[VerticalSeparator]"}], TraditionalForm]], "InlineFormula",
       
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}],
      StyleBox[" values ",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{
      RowLines->{
       False, False, False, False, False, False, False, False, False, False, 
        False, True},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["InterquartileRange[", "MR",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{
      RowLines->{
       False, False, False, False, False, False, False, False, False, False, 
        False, True},
      RowSpacings->0.4}], Cell[TextData[StyleBox["interquartile range ",
      GridBoxOptions->{
      RowLines->{
       False, False, False, False, False, False, False, False, False, False, 
        False, True},
      RowSpacings->0.4}]],
      GridBoxOptions->{
      RowLines->{
       False, False, False, False, False, False, False, False, False, False, 
        False, True},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["QuartileDeviation[", "MR",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{
      RowLines->{
       False, False, False, False, False, False, False, False, False, False, 
        False, True},
      RowSpacings->0.4}], Cell[TextData[StyleBox["quartile deviation ",
      GridBoxOptions->{
      RowLines->{
       False, False, False, False, False, False, False, False, False, False, 
        False, True},
      RowSpacings->0.4}]],
      GridBoxOptions->{
      RowLines->{
       False, False, False, False, False, False, False, False, False, False, 
        False, True},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["DispersionReport[", "MR",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{
      RowLines->{
       False, False, False, False, False, False, False, False, False, False, 
        False, True},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["list of dispersion statistics including ",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}],
      StyleBox["Variance", "MR",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}],
      StyleBox["StandardDeviation", "MR",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}],
      StyleBox["SampleRange", "MR",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}],
      StyleBox["MeanDeviation", "MR",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}],
      StyleBox["MedianDeviation", "MR",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}],
      StyleBox[", and ",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}],
      StyleBox["QuartileDeviation", "MR",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{
       RowLines->{
        False, False, False, False, False, False, False, False, False, False, 
         False, True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{
      RowLines->{
       False, False, False, False, False, False, False, False, False, False, 
        False, True},
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{
 RowLines->{
  False, False, False, False, False, False, False, False, False, False, False,
    True},
 RowSpacings->0.4},
 CellTags->"S6.0.1"],

Cell["Dispersion statistics. ", "Caption",
 CellTags->"S6.0.1"],

Cell["\<\
Dispersion statistics summarize the scatter or spread of the data. Most of \
these functions describe deviation from a particular location. For instance, \
variance is a measure of deviation from the mean, and standard deviation is \
just the square root of the variance. \
\>", "Text",
 CellTags->{"S6.0.1", "1.12"}],

Cell[TextData[{
 "The range is a value describing the total spread of the data. ",
 StyleBox["SampleRange", "MR"],
 " gives the difference between the largest and smallest value in ",
 StyleBox["data", "MR"],
 ", while ",
 StyleBox["InterquartileRange", "MR"],
 " gives the difference between the ",
 Cell[BoxData[
  FormBox["0.75", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and the ",
 Cell[BoxData[
  FormBox["0.25", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " quartiles. "
}], "Text",
 CellTags->{"S6.0.1", "1.13"}],

Cell[TextData[{
 "Note that the functions ",
 StyleBox["Variance", "MR"],
 " and ",
 StyleBox["StandardDeviation", "MR"],
 " are found in the kernel. This package does not need to be loaded to use \
them on lists of data. "
}], "Text",
 CellTags->{"S6.0.1", "1.14"}],

Cell[TextData[{
 "This gives an unbiased estimate for the variance of the data with ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["n",
     "TI"], "-", "1"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " as the divisor. "
}], "MathCaption",
 CellTags->{"S6.0.1", "1.15"}],

Cell[CellGroupData[{

Cell["var1 = Variance[data]", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S6.0.1"],

Cell[BoxData["0.962857142857143`"], "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S6.0.1"]
}, Open  ]],

Cell[TextData[{
 "Here is the maximum likelihood estimate with division by ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S6.0.1", "1.16"}],

Cell[CellGroupData[{

Cell["var2 = VarianceMLE[data]", "Input",
 CellLabel->"In[7]:= ",
 CellTags->"S6.0.1"],

Cell[BoxData["0.8253061224489796`"], "Output",
 CellLabel->"Out[7]= ",
 CellTags->"S6.0.1"]
}, Open  ]],

Cell["We can check the relationship between the two estimators. ", \
"MathCaption",
 CellTags->{"S6.0.1", "1.17"}],

Cell[CellGroupData[{

Cell["var1 (Length[data] - 1) == var2 Length[data]", "Input",
 CellLabel->"In[8]:= ",
 CellTags->"S6.0.1"],

Cell[BoxData["True"], "Output",
 CellLabel->"Out[8]= ",
 CellTags->"S6.0.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["CentralMoment[", "MR",
       GridBoxOptions->{
       RowLines->{False, False, False, False, False, False, True},
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{
       RowLines->{False, False, False, False, False, False, True},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{
       RowLines->{False, False, False, False, False, False, True},
       RowSpacings->0.4}],
      StyleBox["r", "TI",
       GridBoxOptions->{
       RowLines->{False, False, False, False, False, False, True},
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{
       RowLines->{False, False, False, False, False, False, True},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{
       RowLines->{False, False, False, False, False, False, True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{
      RowLines->{False, False, False, False, False, False, True},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["r",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{
       RowLines->{False, False, False, False, False, False, True},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SuperscriptBox["\[Null]", "th"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{
       RowLines->{False, False, False, False, False, False, True},
       RowSpacings->0.4}],
      StyleBox[" central moment ",
       GridBoxOptions->{
       RowLines->{False, False, False, False, False, False, True},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         FractionBox["1", 
          StyleBox["n",
           "TI"]], 
         UnderscriptBox["\[Sum]", 
          StyleBox["i",
           "TI"],
          LimitsPositioning->True], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SubscriptBox[
             StyleBox["x",
              "TI"], 
             StyleBox["i",
              "TI"]], "-", 
            OverscriptBox[
             StyleBox["x",
              "TI"], "_"]}], ")"}], 
          StyleBox["r",
           "TI"]]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{
       RowLines->{False, False, False, False, False, False, True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{
      RowLines->{False, False, False, False, False, False, True},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Skewness[", "MR",
       GridBoxOptions->{
       RowLines->{False, False, False, False, False, False, True},
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{
       RowLines->{False, False, False, False, False, False, True},
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{
       RowLines->{False, False, False, False, False, False, True},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{
       RowLines->{False, False, False, False, False, False, True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{
      RowLines->{False, False, False, False, False, False, True},
      RowSpacings->0.4}], Cell[TextData[StyleBox["coefficient of skewness ",
      GridBoxOptions->{
      RowLines->{False, False, False, False, False, False, True},
      RowSpacings->0.4}]],
      GridBoxOptions->{
      RowLines->{False, False, False, False, False, False, True},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["PearsonSkewness1[", "MR",
       GridBoxOptions->{
       RowLines->{False, False, False, False, False, False, True},
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{
       RowLines->{False, False, False, False, False, False, True},
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{
       RowLines->{False, False, False, False, False, False, True},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{
       RowLines->{False, False, False, False, False, False, True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{
      RowLines->{False, False, False, False, False, False, True},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "Pearson\[CloseCurlyQuote]s first coefficient of skewness ",
      GridBoxOptions->{
      RowLines->{False, False, False, False, False, False, True},
      RowSpacings->0.4}]],
      GridBoxOptions->{
      RowLines->{False, False, False, False, False, False, True},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["PearsonSkewness2[", "MR",
       GridBoxOptions->{
       RowLines->{False, False, False, False, False, False, True},
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{
       RowLines->{False, False, False, False, False, False, True},
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{
       RowLines->{False, False, False, False, False, False, True},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{
       RowLines->{False, False, False, False, False, False, True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{
      RowLines->{False, False, False, False, False, False, True},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "Pearson\[CloseCurlyQuote]s second coefficient of skewness ",
      GridBoxOptions->{
      RowLines->{False, False, False, False, False, False, True},
      RowSpacings->0.4}]],
      GridBoxOptions->{
      RowLines->{False, False, False, False, False, False, True},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["QuartileSkewness[", "MR",
       GridBoxOptions->{
       RowLines->{False, False, False, False, False, False, True},
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{
       RowLines->{False, False, False, False, False, False, True},
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{
       RowLines->{False, False, False, False, False, False, True},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{
       RowLines->{False, False, False, False, False, False, True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{
      RowLines->{False, False, False, False, False, False, True},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "quartile coefficient of skewness",
      GridBoxOptions->{
      RowLines->{False, False, False, False, False, False, True},
      RowSpacings->0.4}]],
      GridBoxOptions->{
      RowLines->{False, False, False, False, False, False, True},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Kurtosis[", "MR",
       GridBoxOptions->{
       RowLines->{False, False, False, False, False, False, True},
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{
       RowLines->{False, False, False, False, False, False, True},
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{
       RowLines->{False, False, False, False, False, False, True},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{
       RowLines->{False, False, False, False, False, False, True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{
      RowLines->{False, False, False, False, False, False, True},
      RowSpacings->0.4}], Cell[TextData[StyleBox["kurtosis coefficient",
      GridBoxOptions->{
      RowLines->{False, False, False, False, False, False, True},
      RowSpacings->0.4}]],
      GridBoxOptions->{
      RowLines->{False, False, False, False, False, False, True},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["KurtosisExcess[", "MR",
       GridBoxOptions->{
       RowLines->{False, False, False, False, False, False, True},
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{
       RowLines->{False, False, False, False, False, False, True},
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{
       RowLines->{False, False, False, False, False, False, True},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{
       RowLines->{False, False, False, False, False, False, True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{
      RowLines->{False, False, False, False, False, False, True},
      RowSpacings->0.4}], Cell[TextData[StyleBox["kurtosis excess",
      GridBoxOptions->{
      RowLines->{False, False, False, False, False, False, True},
      RowSpacings->0.4}]],
      GridBoxOptions->{
      RowLines->{False, False, False, False, False, False, True},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ShapeReport[", "MR",
       GridBoxOptions->{
       RowLines->{False, False, False, False, False, False, True},
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{
       RowLines->{False, False, False, False, False, False, True},
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{
       RowLines->{False, False, False, False, False, False, True},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{
       RowLines->{False, False, False, False, False, False, True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{
      RowLines->{False, False, False, False, False, False, True},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["list of shape statistics including ",
       GridBoxOptions->{
       RowLines->{False, False, False, False, False, False, True},
       RowSpacings->0.4}],
      StyleBox["Skewness", "MR",
       GridBoxOptions->{
       RowLines->{False, False, False, False, False, False, True},
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{
       RowLines->{False, False, False, False, False, False, True},
       RowSpacings->0.4}],
      StyleBox["QuartileSkewness", "MR",
       GridBoxOptions->{
       RowLines->{False, False, False, False, False, False, True},
       RowSpacings->0.4}],
      StyleBox[", and ",
       GridBoxOptions->{
       RowLines->{False, False, False, False, False, False, True},
       RowSpacings->0.4}],
      StyleBox["KurtosisExcess", "MR",
       GridBoxOptions->{
       RowLines->{False, False, False, False, False, False, True},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{
       RowLines->{False, False, False, False, False, False, True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{
      RowLines->{False, False, False, False, False, False, True},
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->{False, False, False, False, False, False, True},
 RowSpacings->0.4},
 CellTags->"S6.0.1"],

Cell["Shape statistics. ", "Caption",
 CellTags->"S6.0.1"],

Cell["\<\
You can get some information about the shape of a distribution using shape \
statistics. Skewness describes the amount of asymmetry. Kurtosis measures the \
concentration of data around the peak and in the tails versus the \
concentration in the flanks. \
\>", "Text",
 CellTags->{"S6.0.1", "1.18"}],

Cell[TextData[{
 StyleBox["Skewness", "MR"],
 " is calculated by dividing the third central moment by the cube of the \
standard deviation. Pearson\[CloseCurlyQuote]s two coefficients provide two \
other well\[Hyphen]known measures of skewness. ",
 StyleBox["PearsonSkewness1", "MR"],
 " and ",
 StyleBox["PearsonSkewness2", "MR"],
 " are found by multiplying three times the difference between the mean and \
either the mode or the median, respectively, and dividing this quantity by \
the standard deviation of the sample. ",
 StyleBox["QuartileSkewness", "MR"],
 " gives a measure of asymmetry within the first and third quartiles. "
}], "Text",
 CellTags->{"S6.0.1", "1.19"}],

Cell[TextData[{
 StyleBox["Kurtosis", "MR"],
 " is calculated by dividing the fourth central moment by the square of the \
sample variance (",
 StyleBox["VarianceMLE", "MR"],
 ") of the data. ",
 StyleBox["KurtosisExcess", "MR"],
 " is shifted so that it is zero for the normal distribution, positive for \
distributions with a prominent peak and heavy tails, and negative for \
distributions with prominent flanks. "
}], "Text",
 CellTags->{"S6.0.1", "1.20"}],

Cell["\<\
Here is the second central moment, which is the same as the maximum \
likelihood estimate of variance. \
\>", "MathCaption",
 CellTags->{"S6.0.1", "1.21"}],

Cell[CellGroupData[{

Cell["CentralMoment[data, 2]", "Input",
 CellLabel->"In[9]:= ",
 CellTags->"S6.0.1"],

Cell[BoxData["0.8253061224489796`"], "Output",
 CellLabel->"Out[9]= ",
 CellTags->"S6.0.1"]
}, Open  ]],

Cell["\<\
A negative value for skewness indicates that the distribution underlying the \
data has a long left\[Hyphen]sided tail. \
\>", "MathCaption",
 CellTags->{"S6.0.1", "1.22"}],

Cell[CellGroupData[{

Cell["Skewness[data]", "Input",
 CellLabel->"In[10]:= ",
 CellTags->"S6.0.1"],

Cell[BoxData[
 RowBox[{"-", "1.2010831332504142`"}]], "Output",
 CellLabel->"Out[10]= ",
 CellTags->"S6.0.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["ExpectedValue[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["expected value of the pure function ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["f",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" with respect to the sample distribution of the data ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ExpectedValue[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["expected value of the function ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["f",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["x",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" with respect to the sample distribution of the data ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S6.0.1"],

Cell["Expected value. ", "Caption",
 CellTags->"S6.0.1"],

Cell["\<\
Other location, dispersion, and shape statistics can be computed by taking \
the expected value of a function with respect to the sample distribution of \
the data. \
\>", "Text",
 CellTags->{"S6.0.1", "1.23"}],

Cell["This gives the average square root of the data. ", "MathCaption",
 CellTags->{"S6.0.1", "1.24"}],

Cell[CellGroupData[{

Cell["ExpectedValue[Sqrt[#]&, data]", "Input",
 CellLabel->"In[11]:= ",
 CellTags->"S6.0.1"],

Cell[BoxData["2.3909810251880033`"], "Output",
 CellLabel->"Out[11]= ",
 CellTags->"S6.0.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["ZeroMean[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "transform the data so that the mean of the result is zero",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Standardize[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "transform the data so that the mean is zero and the unbiased estimate \
of variance is unity",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Standardize[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", MLE -> True]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "transform the data so that the mean is zero and the maximum likelihood \
estimate of variance is unity ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S6.0.1"],

Cell["Data transformations. ", "Caption",
 CellTags->"S6.0.1"],

Cell[TextData[{
 "Occasionally it is useful to apply transformations to the data using \
descriptive statistics. ",
 StyleBox["ZeroMean", "MR"],
 " shifts the data to have zero mean and ",
 StyleBox["Standardize", "MR"],
 " both shifts and scales the data to have unity variance. The default is to \
standardize using the unbiased estimate of variance; the maximum likelihood \
estimate is selected using the option ",
 StyleBox["MLE", "MR"],
 " ",
 StyleBox["->", "MR"],
 " ",
 StyleBox["True", "MR"],
 ". "
}], "Text",
 CellTags->{"S6.0.1", "1.25"}],

Cell["The mean of the shifted data is approximately 0. ", "MathCaption",
 CellTags->{"S6.0.1", "1.26"}],

Cell[CellGroupData[{

Cell["Mean[ZeroMean[data]]", "Input",
 CellLabel->"In[12]:= ",
 CellTags->"S6.0.1"],

Cell[BoxData["0.`"], "Output",
 CellLabel->"Out[12]= ",
 CellTags->"S6.0.1"]
}, Open  ]],

Cell["After standardizing, the variance is approximately 1. ", "MathCaption",
 CellTags->{"S6.0.1", "1.27"}],

Cell[CellGroupData[{

Cell["Variance[Standardize[data]]", "Input",
 CellLabel->"In[13]:= ",
 CellTags->"S6.0.1"],

Cell[BoxData["0.9999999999999997`"], "Output",
 CellLabel->"Out[13]= ",
 CellTags->"S6.0.1"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S6.0.1"->{
    Cell[1776, 53, 147, 6, 36, "Subsection",
      CellTags->{"S6.0.1", "1.1"}],
    Cell[1926, 61, 564, 12, 88, "Text",
      CellTags->{"S6.0.1", "1.2"}],
    Cell[2493, 75, 300, 7, 56, "Text",
      CellTags->{"S6.0.1", "1.3"}],
    Cell[2796, 84, 696, 25, 44, "Text",
      CellTags->{"S6.0.1", "1.4"}],
    Cell[3495, 111, 25899, 810, 380, "DefinitionBox",
      CellTags->"S6.0.1"],
    Cell[29397, 923, 61, 1, 15, "Caption",
      CellTags->"S6.0.1"],
    Cell[29461, 926, 2061, 74, 104, "Text",
      CellTags->{"S6.0.1", "1.5"}],
    Cell[31525, 1002, 287, 10, 70, "Text",
      CellTags->{"S6.0.1", "1.6"}],
    Cell[31815, 1014, 77, 1, 70, "MathCaption",
      CellTags->{"S6.0.1", "1.7"}],
    Cell[31895, 1017, 97, 2, 70, "Input",
      CellTags->"S6.0.1"],
    Cell[31995, 1021, 73, 1, 70, "MathCaption",
      CellTags->{"S6.0.1", "1.8"}],
    Cell[32093, 1026, 104, 2, 70, "Input",
      CellTags->"S6.0.1"],
    Cell[32200, 1030, 195, 6, 70, "Output",
      CellTags->"S6.0.1"],
    Cell[32410, 1039, 122, 3, 70, "MathCaption",
      CellTags->{"S6.0.1", "1.9"}],
    Cell[32557, 1046, 82, 2, 70, "Input",
      CellTags->"S6.0.1"],
    Cell[32642, 1050, 273, 7, 70, "Output",
      CellTags->"S6.0.1"],
    Cell[32930, 1060, 185, 5, 70, "MathCaption",
      CellTags->{"S6.0.1", "1.10"}],
    Cell[33140, 1069, 75, 2, 70, "Input",
      CellTags->"S6.0.1"],
    Cell[33218, 1073, 90, 2, 70, "Output",
      CellTags->"S6.0.1"],
    Cell[33323, 1078, 228, 5, 70, "MathCaption",
      CellTags->{"S6.0.1", "1.11"}],
    Cell[33576, 1087, 89, 2, 70, "Input",
      CellTags->"S6.0.1"],
    Cell[33668, 1091, 90, 2, 70, "Output",
      CellTags->"S6.0.1"],
    Cell[33773, 1096, 25688, 777, 70, "DefinitionBox",
      CellTags->"S6.0.1"],
    Cell[59464, 1875, 63, 1, 70, "Caption",
      CellTags->"S6.0.1"],
    Cell[59530, 1878, 327, 6, 70, "Text",
      CellTags->{"S6.0.1", "1.12"}],
    Cell[59860, 1886, 890, 25, 70, "Text",
      CellTags->{"S6.0.1", "1.13"}],
    Cell[60753, 1913, 266, 8, 70, "Text",
      CellTags->{"S6.0.1", "1.14"}],
    Cell[61022, 1923, 319, 10, 70, "MathCaption",
      CellTags->{"S6.0.1", "1.15"}],
    Cell[61366, 1937, 83, 2, 70, "Input",
      CellTags->"S6.0.1"],
    Cell[61452, 1941, 90, 2, 70, "Output",
      CellTags->"S6.0.1"],
    Cell[61557, 1946, 269, 9, 70, "MathCaption",
      CellTags->{"S6.0.1", "1.16"}],
    Cell[61851, 1959, 86, 2, 70, "Input",
      CellTags->"S6.0.1"],
    Cell[61940, 1963, 91, 2, 70, "Output",
      CellTags->"S6.0.1"],
    Cell[62046, 1968, 114, 2, 70, "MathCaption",
      CellTags->{"S6.0.1", "1.17"}],
    Cell[62185, 1974, 106, 2, 70, "Input",
      CellTags->"S6.0.1"],
    Cell[62294, 1978, 76, 2, 70, "Output",
      CellTags->"S6.0.1"],
    Cell[62385, 1983, 11060, 303, 70, "DefinitionBox",
      CellTags->"S6.0.1"],
    Cell[73448, 2288, 58, 1, 70, "Caption",
      CellTags->"S6.0.1"],
    Cell[73509, 2291, 309, 6, 70, "Text",
      CellTags->{"S6.0.1", "1.18"}],
    Cell[73821, 2299, 679, 14, 70, "Text",
      CellTags->{"S6.0.1", "1.19"}],
    Cell[74503, 2315, 460, 11, 70, "Text",
      CellTags->{"S6.0.1", "1.20"}],
    Cell[74966, 2328, 165, 4, 70, "MathCaption",
      CellTags->{"S6.0.1", "1.21"}],
    Cell[75156, 2336, 84, 2, 70, "Input",
      CellTags->"S6.0.1"],
    Cell[75243, 2340, 91, 2, 70, "Output",
      CellTags->"S6.0.1"],
    Cell[75349, 2345, 182, 4, 70, "MathCaption",
      CellTags->{"S6.0.1", "1.22"}],
    Cell[75556, 2353, 77, 2, 70, "Input",
      CellTags->"S6.0.1"],
    Cell[75636, 2357, 109, 3, 70, "Output",
      CellTags->"S6.0.1"],
    Cell[75760, 2363, 3224, 98, 70, "DefinitionBox",
      CellTags->"S6.0.1"],
    Cell[78987, 2463, 56, 1, 70, "Caption",
      CellTags->"S6.0.1"],
    Cell[79046, 2466, 220, 5, 70, "Text",
      CellTags->{"S6.0.1", "1.23"}],
    Cell[79269, 2473, 102, 1, 70, "MathCaption",
      CellTags->{"S6.0.1", "1.24"}],
    Cell[79396, 2478, 92, 2, 70, "Input",
      CellTags->"S6.0.1"],
    Cell[79491, 2482, 92, 2, 70, "Output",
      CellTags->"S6.0.1"],
    Cell[79598, 2487, 2387, 71, 70, "DefinitionBox",
      CellTags->"S6.0.1"],
    Cell[81988, 2560, 62, 1, 70, "Caption",
      CellTags->"S6.0.1"],
    Cell[82053, 2563, 551, 16, 70, "Text",
      CellTags->{"S6.0.1", "1.25"}],
    Cell[82607, 2581, 103, 1, 70, "MathCaption",
      CellTags->{"S6.0.1", "1.26"}],
    Cell[82735, 2586, 83, 2, 70, "Input",
      CellTags->"S6.0.1"],
    Cell[82821, 2590, 76, 2, 70, "Output",
      CellTags->"S6.0.1"],
    Cell[82912, 2595, 108, 1, 70, "MathCaption",
      CellTags->{"S6.0.1", "1.27"}],
    Cell[83045, 2600, 90, 2, 70, "Input",
      CellTags->"S6.0.1"],
    Cell[83138, 2604, 92, 2, 70, "Output",
      CellTags->"S6.0.1"]},
  "1.1"->{
    Cell[1776, 53, 147, 6, 36, "Subsection",
      CellTags->{"S6.0.1", "1.1"}]},
  "1.2"->{
    Cell[1926, 61, 564, 12, 88, "Text",
      CellTags->{"S6.0.1", "1.2"}]},
  "1.3"->{
    Cell[2493, 75, 300, 7, 56, "Text",
      CellTags->{"S6.0.1", "1.3"}]},
  "1.4"->{
    Cell[2796, 84, 696, 25, 44, "Text",
      CellTags->{"S6.0.1", "1.4"}]},
  "1.5"->{
    Cell[29461, 926, 2061, 74, 104, "Text",
      CellTags->{"S6.0.1", "1.5"}]},
  "1.6"->{
    Cell[31525, 1002, 287, 10, 70, "Text",
      CellTags->{"S6.0.1", "1.6"}]},
  "1.7"->{
    Cell[31815, 1014, 77, 1, 70, "MathCaption",
      CellTags->{"S6.0.1", "1.7"}]},
  "1.8"->{
    Cell[31995, 1021, 73, 1, 70, "MathCaption",
      CellTags->{"S6.0.1", "1.8"}]},
  "1.9"->{
    Cell[32410, 1039, 122, 3, 70, "MathCaption",
      CellTags->{"S6.0.1", "1.9"}]},
  "1.10"->{
    Cell[32930, 1060, 185, 5, 70, "MathCaption",
      CellTags->{"S6.0.1", "1.10"}]},
  "1.11"->{
    Cell[33323, 1078, 228, 5, 70, "MathCaption",
      CellTags->{"S6.0.1", "1.11"}]},
  "1.12"->{
    Cell[59530, 1878, 327, 6, 70, "Text",
      CellTags->{"S6.0.1", "1.12"}]},
  "1.13"->{
    Cell[59860, 1886, 890, 25, 70, "Text",
      CellTags->{"S6.0.1", "1.13"}]},
  "1.14"->{
    Cell[60753, 1913, 266, 8, 70, "Text",
      CellTags->{"S6.0.1", "1.14"}]},
  "1.15"->{
    Cell[61022, 1923, 319, 10, 70, "MathCaption",
      CellTags->{"S6.0.1", "1.15"}]},
  "1.16"->{
    Cell[61557, 1946, 269, 9, 70, "MathCaption",
      CellTags->{"S6.0.1", "1.16"}]},
  "1.17"->{
    Cell[62046, 1968, 114, 2, 70, "MathCaption",
      CellTags->{"S6.0.1", "1.17"}]},
  "1.18"->{
    Cell[73509, 2291, 309, 6, 70, "Text",
      CellTags->{"S6.0.1", "1.18"}]},
  "1.19"->{
    Cell[73821, 2299, 679, 14, 70, "Text",
      CellTags->{"S6.0.1", "1.19"}]},
  "1.20"->{
    Cell[74503, 2315, 460, 11, 70, "Text",
      CellTags->{"S6.0.1", "1.20"}]},
  "1.21"->{
    Cell[74966, 2328, 165, 4, 70, "MathCaption",
      CellTags->{"S6.0.1", "1.21"}]},
  "1.22"->{
    Cell[75349, 2345, 182, 4, 70, "MathCaption",
      CellTags->{"S6.0.1", "1.22"}]},
  "1.23"->{
    Cell[79046, 2466, 220, 5, 70, "Text",
      CellTags->{"S6.0.1", "1.23"}]},
  "1.24"->{
    Cell[79269, 2473, 102, 1, 70, "MathCaption",
      CellTags->{"S6.0.1", "1.24"}]},
  "1.25"->{
    Cell[82053, 2563, 551, 16, 70, "Text",
      CellTags->{"S6.0.1", "1.25"}]},
  "1.26"->{
    Cell[82607, 2581, 103, 1, 70, "MathCaption",
      CellTags->{"S6.0.1", "1.26"}]},
  "1.27"->{
    Cell[82912, 2595, 108, 1, 70, "MathCaption",
      CellTags->{"S6.0.1", "1.27"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S6.0.1", 83880, 2626},
  {"1.1", 88610, 2751},
  {"1.2", 88703, 2754},
  {"1.3", 88791, 2757},
  {"1.4", 88878, 2760},
  {"1.5", 88966, 2763},
  {"1.6", 89058, 2766},
  {"1.7", 89149, 2769},
  {"1.8", 89245, 2772},
  {"1.9", 89341, 2775},
  {"1.10", 89439, 2778},
  {"1.11", 89538, 2781},
  {"1.12", 89637, 2784},
  {"1.13", 89729, 2787},
  {"1.14", 89822, 2790},
  {"1.15", 89914, 2793},
  {"1.16", 90014, 2796},
  {"1.17", 90113, 2799},
  {"1.18", 90212, 2802},
  {"1.19", 90304, 2805},
  {"1.20", 90397, 2808},
  {"1.21", 90490, 2811},
  {"1.22", 90589, 2814},
  {"1.23", 90688, 2817},
  {"1.24", 90780, 2820},
  {"1.25", 90879, 2823},
  {"1.26", 90972, 2826},
  {"1.27", 91071, 2829}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 147, 6, 36, "Subsection",
  CellTags->{"S6.0.1", "1.1"}],
Cell[1926, 61, 564, 12, 88, "Text",
  CellTags->{"S6.0.1", "1.2"}],
Cell[2493, 75, 300, 7, 56, "Text",
  CellTags->{"S6.0.1", "1.3"}],
Cell[2796, 84, 696, 25, 44, "Text",
  CellTags->{"S6.0.1", "1.4"}],
Cell[3495, 111, 25899, 810, 380, "DefinitionBox",
  CellTags->"S6.0.1"],
Cell[29397, 923, 61, 1, 15, "Caption",
  CellTags->"S6.0.1"],
Cell[29461, 926, 2061, 74, 104, "Text",
  CellTags->{"S6.0.1", "1.5"}],
Cell[31525, 1002, 287, 10, 70, "Text",
  CellTags->{"S6.0.1", "1.6"}],
Cell[31815, 1014, 77, 1, 70, "MathCaption",
  CellTags->{"S6.0.1", "1.7"}],
Cell[31895, 1017, 97, 2, 70, "Input",
  CellTags->"S6.0.1"],
Cell[31995, 1021, 73, 1, 70, "MathCaption",
  CellTags->{"S6.0.1", "1.8"}],

Cell[CellGroupData[{
Cell[32093, 1026, 104, 2, 70, "Input",
  CellTags->"S6.0.1"],
Cell[32200, 1030, 195, 6, 70, "Output",
  CellTags->"S6.0.1"]
}, Open  ]],
Cell[32410, 1039, 122, 3, 70, "MathCaption",
  CellTags->{"S6.0.1", "1.9"}],

Cell[CellGroupData[{
Cell[32557, 1046, 82, 2, 70, "Input",
  CellTags->"S6.0.1"],
Cell[32642, 1050, 273, 7, 70, "Output",
  CellTags->"S6.0.1"]
}, Open  ]],
Cell[32930, 1060, 185, 5, 70, "MathCaption",
  CellTags->{"S6.0.1", "1.10"}],

Cell[CellGroupData[{
Cell[33140, 1069, 75, 2, 70, "Input",
  CellTags->"S6.0.1"],
Cell[33218, 1073, 90, 2, 70, "Output",
  CellTags->"S6.0.1"]
}, Open  ]],
Cell[33323, 1078, 228, 5, 70, "MathCaption",
  CellTags->{"S6.0.1", "1.11"}],

Cell[CellGroupData[{
Cell[33576, 1087, 89, 2, 70, "Input",
  CellTags->"S6.0.1"],
Cell[33668, 1091, 90, 2, 70, "Output",
  CellTags->"S6.0.1"]
}, Open  ]],
Cell[33773, 1096, 25688, 777, 70, "DefinitionBox",
  CellTags->"S6.0.1"],
Cell[59464, 1875, 63, 1, 70, "Caption",
  CellTags->"S6.0.1"],
Cell[59530, 1878, 327, 6, 70, "Text",
  CellTags->{"S6.0.1", "1.12"}],
Cell[59860, 1886, 890, 25, 70, "Text",
  CellTags->{"S6.0.1", "1.13"}],
Cell[60753, 1913, 266, 8, 70, "Text",
  CellTags->{"S6.0.1", "1.14"}],
Cell[61022, 1923, 319, 10, 70, "MathCaption",
  CellTags->{"S6.0.1", "1.15"}],

Cell[CellGroupData[{
Cell[61366, 1937, 83, 2, 70, "Input",
  CellTags->"S6.0.1"],
Cell[61452, 1941, 90, 2, 70, "Output",
  CellTags->"S6.0.1"]
}, Open  ]],
Cell[61557, 1946, 269, 9, 70, "MathCaption",
  CellTags->{"S6.0.1", "1.16"}],

Cell[CellGroupData[{
Cell[61851, 1959, 86, 2, 70, "Input",
  CellTags->"S6.0.1"],
Cell[61940, 1963, 91, 2, 70, "Output",
  CellTags->"S6.0.1"]
}, Open  ]],
Cell[62046, 1968, 114, 2, 70, "MathCaption",
  CellTags->{"S6.0.1", "1.17"}],

Cell[CellGroupData[{
Cell[62185, 1974, 106, 2, 70, "Input",
  CellTags->"S6.0.1"],
Cell[62294, 1978, 76, 2, 70, "Output",
  CellTags->"S6.0.1"]
}, Open  ]],
Cell[62385, 1983, 11060, 303, 70, "DefinitionBox",
  CellTags->"S6.0.1"],
Cell[73448, 2288, 58, 1, 70, "Caption",
  CellTags->"S6.0.1"],
Cell[73509, 2291, 309, 6, 70, "Text",
  CellTags->{"S6.0.1", "1.18"}],
Cell[73821, 2299, 679, 14, 70, "Text",
  CellTags->{"S6.0.1", "1.19"}],
Cell[74503, 2315, 460, 11, 70, "Text",
  CellTags->{"S6.0.1", "1.20"}],
Cell[74966, 2328, 165, 4, 70, "MathCaption",
  CellTags->{"S6.0.1", "1.21"}],

Cell[CellGroupData[{
Cell[75156, 2336, 84, 2, 70, "Input",
  CellTags->"S6.0.1"],
Cell[75243, 2340, 91, 2, 70, "Output",
  CellTags->"S6.0.1"]
}, Open  ]],
Cell[75349, 2345, 182, 4, 70, "MathCaption",
  CellTags->{"S6.0.1", "1.22"}],

Cell[CellGroupData[{
Cell[75556, 2353, 77, 2, 70, "Input",
  CellTags->"S6.0.1"],
Cell[75636, 2357, 109, 3, 70, "Output",
  CellTags->"S6.0.1"]
}, Open  ]],
Cell[75760, 2363, 3224, 98, 70, "DefinitionBox",
  CellTags->"S6.0.1"],
Cell[78987, 2463, 56, 1, 70, "Caption",
  CellTags->"S6.0.1"],
Cell[79046, 2466, 220, 5, 70, "Text",
  CellTags->{"S6.0.1", "1.23"}],
Cell[79269, 2473, 102, 1, 70, "MathCaption",
  CellTags->{"S6.0.1", "1.24"}],

Cell[CellGroupData[{
Cell[79396, 2478, 92, 2, 70, "Input",
  CellTags->"S6.0.1"],
Cell[79491, 2482, 92, 2, 70, "Output",
  CellTags->"S6.0.1"]
}, Open  ]],
Cell[79598, 2487, 2387, 71, 70, "DefinitionBox",
  CellTags->"S6.0.1"],
Cell[81988, 2560, 62, 1, 70, "Caption",
  CellTags->"S6.0.1"],
Cell[82053, 2563, 551, 16, 70, "Text",
  CellTags->{"S6.0.1", "1.25"}],
Cell[82607, 2581, 103, 1, 70, "MathCaption",
  CellTags->{"S6.0.1", "1.26"}],

Cell[CellGroupData[{
Cell[82735, 2586, 83, 2, 70, "Input",
  CellTags->"S6.0.1"],
Cell[82821, 2590, 76, 2, 70, "Output",
  CellTags->"S6.0.1"]
}, Open  ]],
Cell[82912, 2595, 108, 1, 70, "MathCaption",
  CellTags->{"S6.0.1", "1.27"}],

Cell[CellGroupData[{
Cell[83045, 2600, 90, 2, 70, "Input",
  CellTags->"S6.0.1"],
Cell[83138, 2604, 92, 2, 70, "Output",
  CellTags->"S6.0.1"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

