(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     18410,        585]*)
(*NotebookOutlinePosition[     19564,        623]*)
(*  CellTagsIndexPosition[     19492,        617]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  "Miscellaneous",
  StyleBox["`", "MB"],
  "Dictionary",
  StyleBox["`", "MB"]
}], "Subsection"],

Cell["\<\
This package provides functions for simple interaction with a \
dictionary of words. A default dictionary is available, but you can easily \
use your own custom dictionaries as well.\
\>", "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["FindWords[", "MR"],
              StyleBox["patt", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "list all words in the dictionary matching the string pattern ",
              
              StyleBox["patt",
                FontSlant->"Italic"]
            }]]},
          {Cell[TextData[{
              StyleBox["FindWords[", "MR"],
              StyleBox["patt", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "list at most ",
              StyleBox["n",
                FontSlant->"Italic"],
              " words"
            }]]},
          {Cell[TextData[{
              StyleBox["DictionaryWordQ[", "MR"],
              StyleBox["patt", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "test if the dictionary contains a word matching ",
              StyleBox["patt",
                FontSlant->"Italic"]
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.3.2"],

Cell["Basic functions for looking up words in the dictionary. ", "Caption"],

Cell["This loads the package. ", "MathCaption"],

Cell["<<Miscellaneous`Dictionary`", "Input",
  CellLabel->"In[1]:="],

Cell[TextData[{
  "This finds all words in the dictionary starting with ",
  StyleBox["\"m\"", "MR"],
  " and ending with ",
  StyleBox["\"th\"", "MR"],
  ". "
}], "MathCaption"],

Cell[CellGroupData[{

Cell["FindWords[\"m\"~~___~~\"th\"]", "Input",
  CellLabel->"In[2]:="],

Cell[BoxData[
    \({"Macbeth", "mammoth", "math", "matzoth", "megadeath", "megalith", 
      "Meredith", "millionth", "mirth", "Monmouth", "monolith", "month", 
      "moth", "motormouth", "mouth", "myth"}\)], "Output",
  CellLabel->"Out[2]="]
}, Open  ]],

Cell[TextData[{
  "Since ",
  StyleBox["FindWords", "MR"],
  " is based on ",
  StyleBox["StringMatchQ", "MR"],
  ", the wild card characters ",
  StyleBox["\"*\"", "MR"],
  " and ",
  StyleBox["\"@\"", "MR"],
  " also work."
}], "MathCaption"],

Cell[CellGroupData[{

Cell["FindWords[\"m*th\"]", "Input",
  CellLabel->"In[3]:="],

Cell[BoxData[
    \({"Macbeth", "mammoth", "math", "matzoth", "megadeath", "megalith", 
      "Meredith", "millionth", "mirth", "Monmouth", "monolith", "month", 
      "moth", "motormouth", "mouth", "myth"}\)], "Output",
  CellLabel->"Out[3]="]
}, Open  ]],

Cell[TextData[{
  "This shows the first 10 words whose third letter is ",
  StyleBox["\"x\"", "MR"],
  ". "
}], "MathCaption"],

Cell[CellGroupData[{

Cell["FindWords[_~~_~~\"x\"~~___,10]", "Input",
  CellLabel->"In[4]:="],

Cell[BoxData[
    \({"anxieties", "anxiety", "anxious", "anxiously", "anxiousness", 
      "auxiliaries", "auxiliary", "auxin", "Baxter", "box"}\)], "Output",
  CellLabel->"Out[4]="]
}, Open  ]],

Cell[TextData[{
  "This checks whether the word ",
  StyleBox["\"math\"", "MR"],
  " is in the dictionary. "
}], "MathCaption"],

Cell[CellGroupData[{

Cell["DictionaryWordQ[\"math\"]", "Input",
  CellLabel->"In[5]:="],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[5]="]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["IgnoreCase \[Rule] False", "MR"],
              " "
            }]], Cell["treat upper- and lowercase letters as different"]},
          {Cell[TextData[{
              StyleBox["SpellingCorrection \[Rule] True", "MR"],
              " "
            }]], Cell["\<\
permit small spelling corrections in the words when the pattern is a literal \
string\
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.3.2"],

Cell[TextData[{
  "Options for ",
  StyleBox["DictionaryWordQ", "MR"],
  " and ",
  StyleBox["FindWords", "MR"],
  ". "
}], "Caption"],

Cell[TextData[{
  "By default,  ",
  StyleBox["DictionaryWordQ", "MR"],
  " and ",
  StyleBox["FindWords", "MR"],
  " treat upper- and lowercase letters equivalently."
}], "MathCaption"],

Cell[CellGroupData[{

Cell["FindWords[\"I\"~~___,10]", "Input",
  CellLabel->"In[6]:="],

Cell[BoxData[
    \({"I", "Iaccoca", "Iago", "iamb", "iambi", "iambic", "iambics", "iambs", 
      "iambus", "iambuses"}\)], "Output",
  CellLabel->"Out[6]="]
}, Open  ]],

Cell[TextData[{
  "You can distinguish between upper- and lowercase by specifying ",
  StyleBox["IgnoreCase -> False", "MR"],
  "."
}], "MathCaption"],

Cell[CellGroupData[{

Cell["FindWords[\"I\"~~___,10, IgnoreCase->False]", "Input",
  CellLabel->"In[7]:="],

Cell[BoxData[
    \({"I", "Iaccoca", "Iago", "Ian", "Iapetus", "Ibadan", "Iberia", 
      "Iberian", "Iberians", "Ibiza"}\)], "Output",
  CellLabel->"Out[7]="]
}, Open  ]],

Cell[TextData[{
  "If the pattern is given as a literal string, you can also find words \
matching with small spelling corrections by using the ",
  StyleBox["SpellingCorrection", "MR"],
  " option."
}], "MathCaption"],

Cell[CellGroupData[{

Cell["FindWords[\"neccessary\", SpellingCorrection->True]", "Input",
  CellLabel->"In[8]:="],

Cell[BoxData[
    \({"necessary"}\)], "Output",
  CellLabel->"Out[8]="]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["$Dictionary", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              " "
            }]], Cell[
            "variable storing the dictionary as a list of strings"]},
          {Cell[TextData[{
              StyleBox["$DefaultDictionaryFile", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              " "
            }]], Cell["\<\
the full file path specifying the default dictionary file to be used\
\>"]},
          {Cell[TextData[{
              StyleBox["GetDictionary", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["[", "MR"],
              StyleBox["file", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "get ",
              StyleBox["$Dictionary", "MR"],
              " from the dictionary file specified by ",
              StyleBox["file",
                FontSlant->"Italic"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.3.2"],

Cell["Manipulating which dictionary to use. ", "Caption"],

Cell[TextData[{
  "Once the dictionary is loaded, it is stored as a list of strings in ",
  StyleBox["$Dictionary", "MR"],
  ". If ",
  StyleBox["$Dictionary", "MR"],
  " is undefined, the loading happens automatically when one of the \
dictionary functions is called."
}], "Text"],

Cell["This shows the number of words in the dictionary.", "MathCaption"],

Cell[CellGroupData[{

Cell["Length[$Dictionary]", "Input",
  CellLabel->"In[9]:="],

Cell[BoxData[
    \(92948\)], "Output",
  CellLabel->"Out[9]="]
}, Open  ]],

Cell["The first 10 words in the dictionary.", "MathCaption"],

Cell[CellGroupData[{

Cell["Take[$Dictionary,10]", "Input",
  CellLabel->"In[10]:="],

Cell[BoxData[
    \({"a", "Aachen", "aah", "Aaliyah", "aardvark", "aardvarks", "Aaron", 
      "abaci", "aback", "abacus"}\)], "Output",
  CellLabel->"Out[10]="]
}, Open  ]],

Cell[TextData[{
  "The file path for the default dictionary file used is stored in ",
  StyleBox["$DefaultDictionaryFile", "MR"],
  ". The default dictionary is based on the Spell Check Oriented Word Lists \
(SCOWL) size 60 (\[Copyright] 2000-2004 by Kevin Atkinson, see ",
  ButtonBox["http://wordlist.sourceforge.net/scowl-readme",
    ButtonData:>{
      URL[ "http://wordlist.sourceforge.net/scowl-readme"], None},
    ButtonStyle->"Hyperlink"],
  " for information), with a few modifications, some of which are collected \
from the \[OpenCurlyDoubleQuote]2of12\[CloseCurlyDoubleQuote] list by Alan \
Beale (see ",
  ButtonBox["http://wordlist.sourceforge.net/12dicts-readme.html",
    ButtonData:>{
      URL[ "http://wordlist.sourceforge.net/12dicts-readme.html"], None},
    ButtonStyle->"Hyperlink"],
  ")."
}], "Text"],

Cell[TextData[{
  "You can specify your own dictionary file, which is simply a file with one \
word on each line. You can either load it using ",
  StyleBox["GetDictionary[", "MR"],
  StyleBox["file",
    FontSlant->"Italic"],
  StyleBox["]", "MR"],
  " or redefine ",
  StyleBox["$DefaultDictionaryFile", "MR"],
  " before the dictionary is loaded."
}], "Text"],

Cell[TextData[{
  "You can specify the dictionary directly by redefining ",
  StyleBox["$Dictionary", "MR"],
  "."
}], "MathCaption"],

Cell["$Dictionary={\"this\",\"that\",\"some\"};", "Input",
  CellLabel->"In[11]:="],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindWords["\<t\>" ~~ __]\)], "Input",
  CellLabel->"In[12]:="],

Cell[BoxData[
    \({"this", "that"}\)], "Output",
  CellLabel->"Out[12]="]
}, Open  ]],

Cell["Reload the default dictionary.", "MathCaption"],

Cell["GetDictionary[];", "Input",
  CellLabel->"In[13]:="],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Anagrams[", "MR"],
              StyleBox["\"string\"", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "find anagrams of ",
              StyleBox["\"string\"",
                FontSlant->"Italic"],
              " using words from the dictionary"
            }]]},
          {Cell[TextData[{
              StyleBox["Anagrams[", "MR"],
              StyleBox["\"string\"", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "find anagrams of ",
              StyleBox["\"string\"",
                FontSlant->"Italic"],
              " using at most ",
              StyleBox["n",
                FontSlant->"Italic"],
              " words"
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.3.2"],

Cell["Finding anagrams. ", "Caption"],

Cell[TextData[{
  "The ",
  StyleBox["Anagrams", "MR"],
  " function will construct all possible anagrams of the letters in the given \
string, that is, all possible ways of using all the letters in the string to \
construct words from the dictionary. All nonletter characters are ignored \
when forming the anagrams."
}], "Text"],

Cell[TextData[{
  "This shows all the ways of decomposing the letters in ",
  StyleBox["\"super\"", "MR"],
  " into individual words. Note that accented letters are ignored."
}], "MathCaption"],

Cell[CellGroupData[{

Cell["Anagrams[\"super\"]", "Input",
  CellLabel->"In[14]:="],

Cell[BoxData[
    \({{"puers"}, {"purse"}, {"super"}, {"er", "pus"}, {"er", "sup"}, {"er", 
        "ups"}, {"er", "UPS"}, {"per", "us"}, {"per", "US"}, {"pus", 
        "re"}, {"re", "sup"}, {"re", "ups"}, {"re", "UPS"}, {"rep", 
        "us"}, {"rep", "US"}}\)], "Output",
  CellLabel->"Out[14]="]
}, Open  ]],

Cell[TextData[{
  "Note that the first time you use ",
  StyleBox["Anagrams", "MR"],
  ", it takes extra time because a frequency table is generated and cached. \
If you are looking for anagrams with many letters, it is important to limit \
the number of words in the result to avoid exponential slowdown."
}], "Text"],

Cell["This restrict the anagrams to a maximum of two words.", "MathCaption"],

Cell[CellGroupData[{

Cell["Anagrams[\"superman\",2]", "Input",
  CellLabel->"In[15]:="],

Cell[BoxData[
    \({{"superman"}, {"Superman"}, {"am", "prunes"}, {"AM", 
        "prunes"}, {"amen", "spur"}, {"Amen", "spur"}, {"amp", 
        "nurse"}, {"amp", "runes"}, {"amps", "rune"}, {"Amur", 
        "pens"}, {"anus", "perm"}, {"anus", "Perm"}, {"Arne", 
        "sump"}, {"Arne", "umps"}, {"arum", "pens"}, {"arums", 
        "pen"}, {"aspen", "rum"}, {"Aspen", "rum"}, {"earn", 
        "sump"}, {"earn", "umps"}, {"earns", "ump"}, {"Earp", 
        "muns"}, {"Erma", "puns"}, {"Erma", "spun"}, {"Erna", 
        "sump"}, {"Erna", "umps"}, {"ma", "prunes"}, {"Mae", 
        "spurn"}, {"man", "puers"}, {"man", "purse"}, {"man", 
        "super"}, {"Man", "puers"}, {"Man", "purse"}, {"Man", 
        "super"}, {"mane", "spur"}, {"mans", "Peru"}, {"mans", 
        "pure"}, {"map", "nurse"}, {"map", "runes"}, {"maps", 
        "rune"}, {"mare", "puns"}, {"mare", "spun"}, {"mares", 
        "pun"}, {"Marne", "pus"}, {"Marne", "sup"}, {"Marne", 
        "ups"}, {"Marne", "UPS"}, {"mas", "prune"}, {"maser", 
        "pun"}, {"mean", "spur"}, {"men", "supra"}, {"menu", 
        "pars"}, {"menu", "raps"}, {"menu", "rasp"}, {"menu", 
        "spar"}, {"menus", "par"}, {"menus", "rap"}, {"mu", 
        "Prensa"}, {"muns", "pare"}, {"muns", "pear"}, {"muns", 
        "rape"}, {"muns", "reap"}, {"nae", "rumps"}, {"Nam", 
        "puers"}, {"Nam", "purse"}, {"Nam", "super"}, {"name", 
        "spur"}, {"nap", "Remus"}, {"nap", "serum"}, {"nape", 
        "rums"}, {"napes", "rum"}, {"neap", "rums"}, {"neaps", 
        "rum"}, {"near", "sump"}, {"near", "umps"}, {"nears", "ump"}, {"nu", 
        "remaps"}, {"nurse", "Pam"}, {"nus", "remap"}, {"pa", 
        "Sumner"}, {"Pam", "runes"}, {"pan", "Remus"}, {"pan", 
        "serum"}, {"Pan", "Remus"}, {"Pan", "serum"}, {"pane", 
        "rums"}, {"panes", "rum"}, {"Pena", "rums"}, {"Prensa", 
        "um"}, {"prune", "Sam"}, {"pun", "reams"}, {"pun", "smear"}, {"puns", 
        "ream"}, {"ran", "spume"}, {"ream", "spun"}, {"remap", 
        "sun"}, {"remaps", "UN"}, {"Rena", "sump"}, {"Rena", 
        "umps"}, {"rump", "sane"}, {"rump", "Sean"}, {"rune", 
        "spam"}, {"rune", "Spam"}, {"saner", "ump"}, {"snare", 
        "ump"}}\)], "Output",
  CellLabel->"Out[15]="]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["SpellCheck[", "MR"],
              StyleBox["\"string\"", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "do a basic spell check of ",
              StyleBox["\"string\"",
                FontSlant->"Italic"],
              " using words from the dictionary"
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.3.2"],

Cell["Spell checking. ", "Caption"],

Cell[TextData[{
  "You can use the ",
  StyleBox["SpellCheck", "MR"],
  " function to perform a basic spell check of the words in a string. The \
return value is a list where the first element is the string with possible \
misspelled words highlighted in red, while the second element is a list of \
these words. Note that this spell check is different from the one performed \
by the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ",
  StyleBox["Check Spelling", "SR"],
  " menu command."
}], "Text"],

Cell["\<\
This spell checks the sentence using the words in the dictionary.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SpellCheck["\<The return valures is a list where the fisrt element is \
the string with possible misspelled words highlighted in red, while the \
second elemnt is a list of these words.\>"]\)], "Input",
  CellLabel->"In[16]:="],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"\<\"The return \
\\!\\(\\*StyleBox[\\\"valures\\\",FontColor->RGBColor[1,0,0]]\\) is a list \
where the \\!\\(\\*StyleBox[\\\"fisrt\\\",FontColor->RGBColor[1,0,0]]\\) \
element is the string with possible misspelled words highlighted in red, \
while the second \\!\\(\\*StyleBox[\\\"elemnt\\\",FontColor->RGBColor[1,0,0]]\
\\) is a list of these words.\"\>", ",", \({"valures", "fisrt", "elemnt"}\)}],
       "}"}]], "Output",
  CellLabel->"Out[16]="]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.1 for Microsoft Windows",
ScreenRectangle->{{0, 1400}, {0, 967}},
ScreenStyleEnvironment->"Brackets",
WindowSize->{823, 797},
WindowMargins->{{79, Automatic}, {Automatic, -24}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S2.3.2"->{
    Cell[2101, 66, 1354, 41, 90, "DefinitionBox",
      CellTags->"S2.3.2"],
    Cell[5503, 193, 613, 17, 68, "DefinitionBox",
      CellTags->"S2.3.2"],
    Cell[7568, 273, 1309, 37, 90, "DefinitionBox",
      CellTags->"S2.3.2"],
    Cell[11519, 404, 1120, 34, 68, "DefinitionBox",
      CellTags->"S2.3.2"],
    Cell[16364, 524, 592, 17, 46, "DefinitionBox",
      CellTags->"S2.3.2"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S2.3.2", 19077, 602}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 113, 5, 40, "Subsection"],
Cell[1892, 60, 206, 4, 42, "Text"],
Cell[2101, 66, 1354, 41, 90, "DefinitionBox",
  CellTags->"S2.3.2"],
Cell[3458, 109, 75, 0, 17, "Caption"],
Cell[3536, 111, 47, 0, 41, "MathCaption"],
Cell[3586, 113, 68, 1, 31, "Input"],
Cell[3657, 116, 178, 6, 41, "MathCaption"],

Cell[CellGroupData[{
Cell[3860, 126, 70, 1, 31, "Input"],
Cell[3933, 129, 244, 4, 46, "Output"]
}, Open  ]],
Cell[4192, 136, 244, 10, 41, "MathCaption"],

Cell[CellGroupData[{
Cell[4461, 150, 60, 1, 31, "Input"],
Cell[4524, 153, 244, 4, 46, "Output"]
}, Open  ]],
Cell[4783, 160, 126, 4, 41, "MathCaption"],

Cell[CellGroupData[{
Cell[4934, 168, 71, 1, 31, "Input"],
Cell[5008, 171, 182, 3, 27, "Output"]
}, Open  ]],
Cell[5205, 177, 127, 4, 41, "MathCaption"],

Cell[CellGroupData[{
Cell[5357, 185, 66, 1, 31, "Input"],
Cell[5426, 188, 62, 2, 27, "Output"]
}, Open  ]],
Cell[5503, 193, 613, 17, 68, "DefinitionBox",
  CellTags->"S2.3.2"],
Cell[6119, 212, 134, 6, 17, "Caption"],
Cell[6256, 220, 186, 6, 41, "MathCaption"],

Cell[CellGroupData[{
Cell[6467, 230, 65, 1, 31, "Input"],
Cell[6535, 233, 158, 3, 27, "Output"]
}, Open  ]],
Cell[6708, 239, 150, 4, 41, "MathCaption"],

Cell[CellGroupData[{
Cell[6883, 247, 84, 1, 31, "Input"],
Cell[6970, 250, 159, 3, 27, "Output"]
}, Open  ]],
Cell[7144, 256, 218, 5, 58, "MathCaption"],

Cell[CellGroupData[{
Cell[7387, 265, 92, 1, 31, "Input"],
Cell[7482, 268, 71, 2, 27, "Output"]
}, Open  ]],
Cell[7568, 273, 1309, 37, 90, "DefinitionBox",
  CellTags->"S2.3.2"],
Cell[8880, 312, 57, 0, 17, "Caption"],
Cell[8940, 314, 281, 7, 42, "Text"],
Cell[9224, 323, 72, 0, 41, "MathCaption"],

Cell[CellGroupData[{
Cell[9321, 327, 60, 1, 31, "Input"],
Cell[9384, 330, 63, 2, 27, "Output"]
}, Open  ]],
Cell[9462, 335, 60, 0, 41, "MathCaption"],

Cell[CellGroupData[{
Cell[9547, 339, 62, 1, 31, "Input"],
Cell[9612, 342, 161, 3, 27, "Output"]
}, Open  ]],
Cell[9788, 348, 827, 17, 59, "Text"],
Cell[10618, 367, 362, 10, 42, "Text"],
Cell[10983, 379, 133, 4, 41, "MathCaption"],
Cell[11119, 385, 83, 1, 31, "Input"],

Cell[CellGroupData[{
Cell[11227, 390, 82, 2, 29, "Input"],
Cell[11312, 394, 75, 2, 27, "Output"]
}, Open  ]],
Cell[11402, 399, 53, 0, 41, "MathCaption"],
Cell[11458, 401, 58, 1, 31, "Input"],
Cell[11519, 404, 1120, 34, 68, "DefinitionBox",
  CellTags->"S2.3.2"],
Cell[12642, 440, 37, 0, 17, "Caption"],
Cell[12682, 442, 330, 7, 42, "Text"],
Cell[13015, 451, 193, 4, 41, "MathCaption"],

Cell[CellGroupData[{
Cell[13233, 459, 61, 1, 31, "Input"],
Cell[13297, 462, 299, 5, 46, "Output"]
}, Open  ]],
Cell[13611, 470, 318, 6, 42, "Text"],
Cell[13932, 478, 76, 0, 41, "MathCaption"],

Cell[CellGroupData[{
Cell[14033, 482, 66, 1, 31, "Input"],
Cell[14102, 485, 2247, 36, 293, "Output"]
}, Open  ]],
Cell[16364, 524, 592, 17, 46, "DefinitionBox",
  CellTags->"S2.3.2"],
Cell[16959, 543, 35, 0, 17, "Caption"],
Cell[16997, 545, 513, 13, 59, "Text"],
Cell[17513, 560, 96, 2, 41, "MathCaption"],

Cell[CellGroupData[{
Cell[17634, 566, 247, 4, 49, "Input"],
Cell[17884, 572, 498, 9, 46, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

