(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     41735,       1291]*)
(*NotebookOutlinePosition[     47471,       1466]*)
(*  CellTagsIndexPosition[     46932,       1441]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Statistics",
 StyleBox["`", "MB"],
 "DiscreteDistributions",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S6.1.1", "1.1"}],

Cell[TextData[{
 "This package gives you access to the most commonly used discrete \
statistical distributions. You can compute their densities, means, variances, \
and other related properties. The distributions themselves are represented in \
the symbolic form ",
 StyleBox["name", "TI"],
 StyleBox["[", "MR"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["param",
     "TI"], "1"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox[", ", "MR"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["param",
     "TI"], "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox[", \[Ellipsis] ]", "MR"],
 ". Functions such as ",
 StyleBox["Mean", "MR"],
 ", which give properties of statistical distributions, take the symbolic \
representation of the distribution as an argument. The package ",
 StyleBox["ContinuousDistributions", "MR"],
 " contains many continuous statistical distributions. "
}], "Text",
 CellTags->{"S6.1.1", "1.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["BernoulliDistribution[", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["p", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["]", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[{
              StyleBox["Bernoulli distribution with mean ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    StyleBox["p",
                      "TI"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[{
              StyleBox["BinomialDistribution[", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["n", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[", ", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["p", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["]", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[{
              StyleBox[
              "binomial distribution for the number of successes that occur \
in ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    StyleBox["n",
                      "TI"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[
              " trials, where the probability of success in a trial is ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    StyleBox["p",
                      "TI"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[{
              StyleBox["DiscreteUniformDistribution[", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["n", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["]", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[{
              StyleBox["discrete uniform distribution with ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    StyleBox["n",
                      "TI"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[" states ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[{
              StyleBox["GeometricDistribution[", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["p", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["]", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[{
              StyleBox[
              "geometric distribution for the number of trials before the \
first success, where the probability of success in a trial is ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    StyleBox["p",
                      "TI"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[{
              StyleBox["HypergeometricDistribution[", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["n", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[", ", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], 
                      StyleBox[\(s  u  c  c\),
                        "TI"]], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[", ", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], 
                      StyleBox[\(t  o  t\),
                        "TI"]], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox["]", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[{
              StyleBox[
              "hypergeometric distribution for the number of successes out of \
a sample of size ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    StyleBox["n",
                      "TI"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[", from a population of size ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], 
                      StyleBox[\(t  o  t\),
                        "TI"]], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[" containing ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], 
                      StyleBox[\(s  u  c  c\),
                        "TI"]], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[" successes ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[{
              StyleBox["LogSeriesDistribution[", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["theta", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["]", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[{
              StyleBox["logarithmic series distribution with parameter ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  \(TraditionalForm\`\[Theta]\)], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[{
              StyleBox["NegativeBinomialDistribution[", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["n", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[", ", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["p", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["]", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[{
              StyleBox["negative binomial distribution with parameters ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    StyleBox["n",
                      "TI"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[" and ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    StyleBox["p",
                      "TI"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[{
              StyleBox["PoissonDistribution[", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["mu", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["]", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[{
              StyleBox["Poisson distribution with mean ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  \(TraditionalForm\`\[Mu]\)], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S6.1.1"],

Cell[TextData[{
 "Statistical distributions from the package ",
 StyleBox["DiscreteDistributions", "MR"],
 "."
}], "Caption",
 CellTags->"S6.1.1"],

Cell["\<\
Most of the common discrete statistical distributions can be understood by \
considering a sequence of trials, each with two possible outcomes, for \
example, success and failure. \
\>", "Text",
 CellTags->{"S6.1.1", "1.3"}],

Cell[TextData[{
 "The ",
 StyleBox["Bernoulli distribution", "TB"],
 " ",
 StyleBox["BernoulliDistribution[", "MR"],
 StyleBox["p", "TI"],
 StyleBox["]", "MR"],
 " is the probability distribution for a single trial in which success, \
corresponding to value 1, occurs with probability ",
 Cell[BoxData[
  FormBox[
   StyleBox["p",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", and failure, corresponding to value 0, occurs with probability ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "-", 
    StyleBox["p",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "Text",
 CellTags->{"S6.1.1", "1.4"}],

Cell[TextData[{
 "The ",
 StyleBox["binomial distribution", "TB"],
 " ",
 StyleBox["BinomialDistribution[", "MR"],
 StyleBox["n", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["p", "TI"],
 StyleBox["]", "MR"],
 " is the distribution of the number of successes that occur in ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " independent trials, where the probability of success in each trial is ",
 Cell[BoxData[
  FormBox[
   StyleBox["p",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "Text",
 CellTags->{"S6.1.1", "1.5"}],

Cell[TextData[{
  "The ",
  StyleBox["negative binomial distribution", "TB"],
  " ",
  StyleBox["NegativeBinomialDistribution[", "MR"],
  StyleBox["n", "TI"],
  StyleBox[", ", "MR"],
  StyleBox["p", "TI"],
  StyleBox["]", "MR"],
  " for positive integer ",
  StyleBox["n",
    FontSlant->"Italic"],
  " is the distribution of the number of failures that occur in a sequence of \
trials before ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " successes have occurred, where the probability of success in each trial \
is ",
  Cell[BoxData[
      FormBox[
        StyleBox["p",
          "TI"], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  ". The distribution is defined for any positive ",
  StyleBox["n",
    FontSlant->"Italic"],
  ", though the interpretation of ",
  StyleBox["n",
    FontSlant->"Italic"],
  " as the number of successes and ",
  StyleBox["p",
    FontSlant->"Italic"],
  " as the success probability no longer holds if ",
  StyleBox["n",
    FontSlant->"Italic"],
  " in not an integer.",
  " "
}], "Text",
  CellTags->{"S6.1.1", "1.6"}],

Cell[TextData[{
 "The terms in the series expansion of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["l",
     "TI"], 
    StyleBox["o",
     "TI"], 
    StyleBox["g",
     "TI"], 
    RowBox[{"(", 
     RowBox[{"1", "-", "\[Theta]"}], ")"}]}], TraditionalForm]], 
  "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " about ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Theta]", "=", "0"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " are proportional to the probabilities of a discrete random variable \
following the ",
 StyleBox["logarithmic series distribution", "TB"],
 " ",
 StyleBox["LogSeriesDistribution[", "MR"],
 StyleBox["theta", "TI"],
 StyleBox["]", "MR"],
 ". The distribution of the number of items of a product purchased by a buyer \
in a specified interval is sometimes modeled by this distribution. "
}], "Text",
 CellTags->{"S6.1.1", "1.7"}],

Cell[TextData[{
 "The ",
 StyleBox["geometric distribution", "TB"],
 " ",
 StyleBox["GeometricDistribution[", "MR"],
 StyleBox["p", "TI"],
 StyleBox["]", "MR"],
 " is the distribution of the total number of trials before the first success \
occurs, where the probability of success in each trial is ",
 Cell[BoxData[
  FormBox[
   StyleBox["p",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "Text",
 CellTags->{"S6.1.1", "1.8"}],

Cell[TextData[{
 "The ",
 StyleBox["hypergeometric distribution", "TB"],
 " ",
 StyleBox["HypergeometricDistribution[", "MR"],
 StyleBox["n", "TI"],
 StyleBox[", ", "MR"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["n",
     "TI"], 
    StyleBox[
     RowBox[{"s", "u", "c", "c"}],
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox[", ", "MR"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["n",
     "TI"], 
    StyleBox[
     RowBox[{"t", "o", "t"}],
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox["]", "MR"],
 " is used in place of the binomial distribution for experiments in which the \
",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " trials correspond to sampling without replacement from a population of \
size ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["n",
     "TI"], 
    StyleBox[
     RowBox[{"t", "o", "t"}],
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " with ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["n",
     "TI"], 
    StyleBox[
     RowBox[{"s", "u", "c", "c"}],
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " potential successes. "
}], "Text",
 CellTags->{"S6.1.1", "1.9"}],

Cell[TextData[{
 "The ",
 StyleBox["discrete uniform distribution", "TB"],
 " ",
 StyleBox["DiscreteUniformDistribution[", "MR"],
 StyleBox["n", "TI"],
 StyleBox["]", "MR"],
 " represents an experiment with ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " outcomes that occur with equal probabilities. "
}], "Text",
 CellTags->{"S6.1.1", "1.10"}],

Cell[TextData[{
 "The ",
 StyleBox["Poisson distribution", "TB"],
 " ",
 StyleBox["PoissonDistribution[", "MR"],
 StyleBox["mu", "TI"],
 StyleBox["]", "MR"],
 " describes the number of points in a unit interval, where points are \
distributed with uniform density ",
 Cell[BoxData[
  FormBox["\[Mu]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "Text",
 CellTags->{"S6.1.1", "1.11"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["PDF[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["probability density function at ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["x",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["CDF[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["cumulative distribution function at ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["x",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Quantile[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["q", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["q",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SuperscriptBox["\[Null]", "th"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" quantile ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Domain[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "range of values of the variable (support) ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Mean[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["mean ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Variance[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["variance ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["StandardDeviation[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["standard deviation ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Skewness[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["coefficient of skewness ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Kurtosis[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["coefficient of kurtosis ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["KurtosisExcess[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["kurtosis excess ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["CharacteristicFunction[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["t", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["characteristic function ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"\[Phi]", 
         RowBox[{"(", 
          StyleBox["t",
           "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ExpectedValue[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["expected value of pure function ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["f",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" with respect to the specified distribution ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ExpectedValue[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["expected value of function ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["f",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["x",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" with respect to the specified distribution ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Random[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "pseudorandom number with specified distribution ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["RandomArray[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dims", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["pseudorandom array with dimensionality ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dims", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", and elements from the specified distribution ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S6.1.1"],

Cell["Functions of statistical distributions. ", "Caption",
 CellTags->"S6.1.1"],

Cell[TextData[{
 "In this package distributions are represented in symbolic form. ",
 StyleBox["PDF[", "MR"],
 StyleBox["dist", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["x", "TI"],
 StyleBox["]", "MR"],
 " evaluates the density at ",
 Cell[BoxData[
  FormBox[
   StyleBox["x",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " if ",
 Cell[BoxData[
  FormBox[
   StyleBox["x",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is a numerical value, and otherwise leaves the function in symbolic form \
whenever possible. Similarly, ",
 StyleBox["CDF[", "MR"],
 StyleBox["dist", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["x", "TI"],
 StyleBox["]", "MR"],
 " gives the cumulative distribution and ",
 StyleBox["Mean[", "MR"],
 StyleBox["dist", "TI"],
 StyleBox["]", "MR"],
 " gives the mean of the specified distribution. For a more complete \
description of the various functions of a statistical distribution, see the \
description of their continuous analogues in the section concerning the \
package ",
 StyleBox["Statistics`ContinuousDistributions`", "MR"],
 ". "
}], "Text",
 CellTags->{"S6.1.1", "1.12"}],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S6.1.1", "1.13"}],

Cell["<<Statistics`DiscreteDistributions`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S6.1.1"],

Cell[TextData[{
 "Here is a symbolic representation of the binomial distribution for ",
 Cell[BoxData[
  FormBox["34", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " trials, each having probability ",
 Cell[BoxData[
  FormBox["0.3", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " of success. "
}], "MathCaption",
 CellTags->{"S6.1.1", "1.14"}],

Cell[CellGroupData[{

Cell["bdist = BinomialDistribution[34, 0.3]", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S6.1.1"],

Cell[BoxData[
 RowBox[{"BinomialDistribution", "[", 
  RowBox[{"34", ",", "0.3`"}], "]"}]], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S6.1.1"]
}, Open  ]],

Cell["This is the mean of the distribution. ", "MathCaption",
 CellTags->{"S6.1.1", "1.15"}],

Cell[CellGroupData[{

Cell["Mean[bdist]", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S6.1.1"],

Cell[BoxData["10.2`"], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S6.1.1"]
}, Open  ]],

Cell["\<\
You can get the equation for the mean by using symbolic variables as \
arguments. \
\>", "MathCaption",
 CellTags->{"S6.1.1", "1.16"}],

Cell[CellGroupData[{

Cell["Mean[BinomialDistribution[n, p]]", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S6.1.1"],

Cell[BoxData[
 RowBox[{"n", " ", "p"}]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S6.1.1"]
}, Open  ]],

Cell[TextData[{
 "Here is the ",
 Cell[BoxData[
  FormBox[
   RowBox[{"50", "%"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " quantile, which is equal to the median. "
}], "MathCaption",
 CellTags->{"S6.1.1", "1.17"}],

Cell[CellGroupData[{

Cell["Quantile[bdist, 0.5]", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S6.1.1"],

Cell[BoxData["10"], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S6.1.1"]
}, Open  ]],

Cell[TextData[{
 "This gives the expected value of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["x",
     "TI"], "3"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " with respect to the binomial distribution. "
}], "MathCaption",
 CellTags->{"S6.1.1", "1.18"}],

Cell[CellGroupData[{

Cell["ExpectedValue[x^3, bdist, x]", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S6.1.1"],

Cell[BoxData["1282.547999999998`"], "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S6.1.1"]
}, Open  ]],

Cell["\<\
The elements of this matrix are pseudorandom numbers from the binomial \
distribution. \
\>", "MathCaption",
 CellTags->{"S6.1.1", "1.19"}],

Cell[CellGroupData[{

Cell["RandomArray[bdist, {2, 3}]", "Input",
 CellLabel->"In[7]:= ",
 CellTags->"S6.1.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"8", ",", "10", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "9", ",", "6"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[7]= ",
 CellTags->"S6.1.1"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S6.1.1"->{
    Cell[1776, 53, 147, 6, 40, "Subsection",
      CellTags->{"S6.1.1", "1.1"}],
    Cell[1926, 61, 1036, 28, 110, "Text",
      CellTags->{"S6.1.1", "1.2"}],
    Cell[2965, 91, 13063, 321, 372, "DefinitionBox",
      CellTags->"S6.1.1"],
    Cell[16031, 414, 146, 5, 17, "Caption",
      CellTags->"S6.1.1"],
    Cell[16180, 421, 234, 5, 42, "Text",
      CellTags->{"S6.1.1", "1.3"}],
    Cell[16417, 428, 703, 23, 59, "Text",
      CellTags->{"S6.1.1", "1.4"}],
    Cell[17123, 453, 666, 23, 42, "Text",
      CellTags->{"S6.1.1", "1.5"}],
    Cell[17792, 478, 1210, 41, 93, "Text",
      CellTags->{"S6.1.1", "1.6"}],
    Cell[19005, 521, 922, 30, 76, "Text",
      CellTags->{"S6.1.1", "1.7"}],
    Cell[19930, 553, 485, 16, 42, "Text",
      CellTags->{"S6.1.1", "1.8"}],
    Cell[20418, 571, 1460, 57, 59, "Text",
      CellTags->{"S6.1.1", "1.9"}],
    Cell[21881, 630, 439, 15, 42, "Text",
      CellTags->{"S6.1.1", "1.10"}],
    Cell[22323, 647, 431, 14, 42, "Text",
      CellTags->{"S6.1.1", "1.11"}],
    Cell[22757, 663, 14617, 451, 430, "DefinitionBox",
      CellTags->"S6.1.1"],
    Cell[37377, 1116, 80, 1, 17, "Caption",
      CellTags->"S6.1.1"],
    Cell[37460, 1119, 1197, 37, 110, "Text",
      CellTags->{"S6.1.1", "1.12"}],
    Cell[38660, 1158, 78, 1, 41, "MathCaption",
      CellTags->{"S6.1.1", "1.13"}],
    Cell[38741, 1161, 97, 2, 31, "Input",
      CellTags->"S6.1.1"],
    Cell[38841, 1165, 419, 11, 58, "MathCaption",
      CellTags->{"S6.1.1", "1.14"}],
    Cell[39285, 1180, 99, 2, 31, "Input",
      CellTags->"S6.1.1"],
    Cell[39387, 1184, 146, 4, 27, "Output",
      CellTags->"S6.1.1"],
    Cell[39548, 1191, 92, 1, 41, "MathCaption",
      CellTags->{"S6.1.1", "1.15"}],
    Cell[39665, 1196, 73, 2, 31, "Input",
      CellTags->"S6.1.1"],
    Cell[39741, 1200, 77, 2, 27, "Output",
      CellTags->"S6.1.1"],
    Cell[39833, 1205, 144, 4, 41, "MathCaption",
      CellTags->{"S6.1.1", "1.16"}],
    Cell[40002, 1213, 94, 2, 31, "Input",
      CellTags->"S6.1.1"],
    Cell[40099, 1217, 95, 3, 27, "Output",
      CellTags->"S6.1.1"],
    Cell[40209, 1223, 259, 8, 41, "MathCaption",
      CellTags->{"S6.1.1", "1.17"}],
    Cell[40493, 1235, 82, 2, 31, "Input",
      CellTags->"S6.1.1"],
    Cell[40578, 1239, 74, 2, 27, "Output",
      CellTags->"S6.1.1"],
    Cell[40667, 1244, 314, 10, 41, "MathCaption",
      CellTags->{"S6.1.1", "1.18"}],
    Cell[41006, 1258, 90, 2, 31, "Input",
      CellTags->"S6.1.1"],
    Cell[41099, 1262, 90, 2, 27, "Output",
      CellTags->"S6.1.1"],
    Cell[41204, 1267, 149, 4, 41, "MathCaption",
      CellTags->{"S6.1.1", "1.19"}],
    Cell[41378, 1275, 88, 2, 31, "Input",
      CellTags->"S6.1.1"],
    Cell[41469, 1279, 238, 8, 27, "Output",
      CellTags->"S6.1.1"]},
  "1.1"->{
    Cell[1776, 53, 147, 6, 40, "Subsection",
      CellTags->{"S6.1.1", "1.1"}]},
  "1.2"->{
    Cell[1926, 61, 1036, 28, 110, "Text",
      CellTags->{"S6.1.1", "1.2"}]},
  "1.3"->{
    Cell[16180, 421, 234, 5, 42, "Text",
      CellTags->{"S6.1.1", "1.3"}]},
  "1.4"->{
    Cell[16417, 428, 703, 23, 59, "Text",
      CellTags->{"S6.1.1", "1.4"}]},
  "1.5"->{
    Cell[17123, 453, 666, 23, 42, "Text",
      CellTags->{"S6.1.1", "1.5"}]},
  "1.6"->{
    Cell[17792, 478, 1210, 41, 93, "Text",
      CellTags->{"S6.1.1", "1.6"}]},
  "1.7"->{
    Cell[19005, 521, 922, 30, 76, "Text",
      CellTags->{"S6.1.1", "1.7"}]},
  "1.8"->{
    Cell[19930, 553, 485, 16, 42, "Text",
      CellTags->{"S6.1.1", "1.8"}]},
  "1.9"->{
    Cell[20418, 571, 1460, 57, 59, "Text",
      CellTags->{"S6.1.1", "1.9"}]},
  "1.10"->{
    Cell[21881, 630, 439, 15, 42, "Text",
      CellTags->{"S6.1.1", "1.10"}]},
  "1.11"->{
    Cell[22323, 647, 431, 14, 42, "Text",
      CellTags->{"S6.1.1", "1.11"}]},
  "1.12"->{
    Cell[37460, 1119, 1197, 37, 110, "Text",
      CellTags->{"S6.1.1", "1.12"}]},
  "1.13"->{
    Cell[38660, 1158, 78, 1, 41, "MathCaption",
      CellTags->{"S6.1.1", "1.13"}]},
  "1.14"->{
    Cell[38841, 1165, 419, 11, 58, "MathCaption",
      CellTags->{"S6.1.1", "1.14"}]},
  "1.15"->{
    Cell[39548, 1191, 92, 1, 41, "MathCaption",
      CellTags->{"S6.1.1", "1.15"}]},
  "1.16"->{
    Cell[39833, 1205, 144, 4, 41, "MathCaption",
      CellTags->{"S6.1.1", "1.16"}]},
  "1.17"->{
    Cell[40209, 1223, 259, 8, 41, "MathCaption",
      CellTags->{"S6.1.1", "1.17"}]},
  "1.18"->{
    Cell[40667, 1244, 314, 10, 41, "MathCaption",
      CellTags->{"S6.1.1", "1.18"}]},
  "1.19"->{
    Cell[41204, 1267, 149, 4, 41, "MathCaption",
      CellTags->{"S6.1.1", "1.19"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S6.1.1", 42363, 1307},
  {"1.1", 45132, 1380},
  {"1.2", 45225, 1383},
  {"1.3", 45315, 1386},
  {"1.4", 45404, 1389},
  {"1.5", 45494, 1392},
  {"1.6", 45584, 1395},
  {"1.7", 45675, 1398},
  {"1.8", 45765, 1401},
  {"1.9", 45855, 1404},
  {"1.10", 45947, 1407},
  {"1.11", 46039, 1410},
  {"1.12", 46131, 1413},
  {"1.13", 46226, 1416},
  {"1.14", 46324, 1419},
  {"1.15", 46424, 1422},
  {"1.16", 46522, 1425},
  {"1.17", 46621, 1428},
  {"1.18", 46720, 1431},
  {"1.19", 46820, 1434}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 147, 6, 40, "Subsection",
  CellTags->{"S6.1.1", "1.1"}],
Cell[1926, 61, 1036, 28, 110, "Text",
  CellTags->{"S6.1.1", "1.2"}],
Cell[2965, 91, 13063, 321, 372, "DefinitionBox",
  CellTags->"S6.1.1"],
Cell[16031, 414, 146, 5, 17, "Caption",
  CellTags->"S6.1.1"],
Cell[16180, 421, 234, 5, 42, "Text",
  CellTags->{"S6.1.1", "1.3"}],
Cell[16417, 428, 703, 23, 59, "Text",
  CellTags->{"S6.1.1", "1.4"}],
Cell[17123, 453, 666, 23, 42, "Text",
  CellTags->{"S6.1.1", "1.5"}],
Cell[17792, 478, 1210, 41, 93, "Text",
  CellTags->{"S6.1.1", "1.6"}],
Cell[19005, 521, 922, 30, 76, "Text",
  CellTags->{"S6.1.1", "1.7"}],
Cell[19930, 553, 485, 16, 42, "Text",
  CellTags->{"S6.1.1", "1.8"}],
Cell[20418, 571, 1460, 57, 59, "Text",
  CellTags->{"S6.1.1", "1.9"}],
Cell[21881, 630, 439, 15, 42, "Text",
  CellTags->{"S6.1.1", "1.10"}],
Cell[22323, 647, 431, 14, 42, "Text",
  CellTags->{"S6.1.1", "1.11"}],
Cell[22757, 663, 14617, 451, 430, "DefinitionBox",
  CellTags->"S6.1.1"],
Cell[37377, 1116, 80, 1, 17, "Caption",
  CellTags->"S6.1.1"],
Cell[37460, 1119, 1197, 37, 110, "Text",
  CellTags->{"S6.1.1", "1.12"}],
Cell[38660, 1158, 78, 1, 41, "MathCaption",
  CellTags->{"S6.1.1", "1.13"}],
Cell[38741, 1161, 97, 2, 31, "Input",
  CellTags->"S6.1.1"],
Cell[38841, 1165, 419, 11, 58, "MathCaption",
  CellTags->{"S6.1.1", "1.14"}],

Cell[CellGroupData[{
Cell[39285, 1180, 99, 2, 31, "Input",
  CellTags->"S6.1.1"],
Cell[39387, 1184, 146, 4, 27, "Output",
  CellTags->"S6.1.1"]
}, Open  ]],
Cell[39548, 1191, 92, 1, 41, "MathCaption",
  CellTags->{"S6.1.1", "1.15"}],

Cell[CellGroupData[{
Cell[39665, 1196, 73, 2, 31, "Input",
  CellTags->"S6.1.1"],
Cell[39741, 1200, 77, 2, 27, "Output",
  CellTags->"S6.1.1"]
}, Open  ]],
Cell[39833, 1205, 144, 4, 41, "MathCaption",
  CellTags->{"S6.1.1", "1.16"}],

Cell[CellGroupData[{
Cell[40002, 1213, 94, 2, 31, "Input",
  CellTags->"S6.1.1"],
Cell[40099, 1217, 95, 3, 27, "Output",
  CellTags->"S6.1.1"]
}, Open  ]],
Cell[40209, 1223, 259, 8, 41, "MathCaption",
  CellTags->{"S6.1.1", "1.17"}],

Cell[CellGroupData[{
Cell[40493, 1235, 82, 2, 31, "Input",
  CellTags->"S6.1.1"],
Cell[40578, 1239, 74, 2, 27, "Output",
  CellTags->"S6.1.1"]
}, Open  ]],
Cell[40667, 1244, 314, 10, 41, "MathCaption",
  CellTags->{"S6.1.1", "1.18"}],

Cell[CellGroupData[{
Cell[41006, 1258, 90, 2, 31, "Input",
  CellTags->"S6.1.1"],
Cell[41099, 1262, 90, 2, 27, "Output",
  CellTags->"S6.1.1"]
}, Open  ]],
Cell[41204, 1267, 149, 4, 41, "MathCaption",
  CellTags->{"S6.1.1", "1.19"}],

Cell[CellGroupData[{
Cell[41378, 1275, 88, 2, 31, "Input",
  CellTags->"S6.1.1"],
Cell[41469, 1279, 238, 8, 27, "Output",
  CellTags->"S6.1.1"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

