(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   2134570,      77781]*)
(*NotebookOutlinePosition[   2146777,      78082]*)
(*  CellTagsIndexPosition[   2146657,      78075]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["NumericalMath`EquationTrekker`", "Subsection",
  CellTags->"EquationTrekker"],

Cell["\<\
This package provides an interactive tool for investigating the solutions of \
differential equations as well as other types of equations that have \
solutions that can be viewed as paths or trajectories.\
\>", "Text",
  CellTags->"EquationTrekker"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " provides a general tool, ",
  StyleBox["NDSolve", "MR"],
  ", for finding numerical solutions of differential equations.   The ability \
to simply specify differentiation equations in mathematical form gives a \
great deal of convenience over FORTRAN and C++ solver packages.  However, for \
low dimensional systems, an additional level of interactivity can be achieved \
with a graphical user interface.  ",
  StyleBox["EquationTrekker", "MR"],
  " allows you to give the equation, optionally with parameters, and then it \
opens a window that allows you to specify initial conditions simply by using \
the mouse.   "
}], "Text",
  CellTags->"EquationTrekker"],

Cell["This loads the package.", "MathCaption",
  CellTags->"EquationTrekker"],

Cell[BoxData[
    \(<< \ NumericalMath`EquationTrekker`\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"EquationTrekker"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Basic use", "SubsectionIcon",
  CellTags->"EquationTrekker"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["EquationTrekker",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox[\(eqns, \ y, \ {x, \ xmin, \ xmax}, \ opts\),
                "TI"], 
              StyleBox["]",
                "TI"]}], Cell[TextData[{
              StyleBox[
              "open a graphical interface for specifying initial conditions \
and showing the resulting numerical solutions to the ordinary differential \
equations ",
                GridBoxOptions->{ColumnWidths->{0.35, 0.65}}],
              StyleBox["eqns", "TI",
                GridBoxOptions->{ColumnWidths->{0.35, 0.65}}],
              StyleBox[" for the function ",
                GridBoxOptions->{ColumnWidths->{0.35, 0.65}}],
              StyleBox["y", "TI",
                GridBoxOptions->{ColumnWidths->{0.35, 0.65}}],
              StyleBox[" with the independent variable ",
                GridBoxOptions->{ColumnWidths->{0.35, 0.65}}],
              StyleBox["x", "TI",
                GridBoxOptions->{ColumnWidths->{0.35, 0.65}}],
              StyleBox[" in the range ",
                GridBoxOptions->{ColumnWidths->{0.35, 0.65}}],
              StyleBox["xmin", "TI",
                GridBoxOptions->{ColumnWidths->{0.35, 0.65}}],
              StyleBox[" to ",
                GridBoxOptions->{ColumnWidths->{0.35, 0.65}}],
              StyleBox["xmax", "TI",
                GridBoxOptions->{ColumnWidths->{0.35, 0.65}}],
              StyleBox[". ",
                GridBoxOptions->{ColumnWidths->{0.35, 0.65}}]
            }], "Text",
              GridBoxOptions->{ColumnWidths->{0.35, 0.65}}]}
          }], TextForm]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.35, 0.65}},
  CellTags->"EquationTrekker"],

Cell["\<\
Choosing initial conditions for differential equations using a graphical \
interface.\
\>", "Caption",
  CellTags->"EquationTrekker"],

Cell[TextData[{
  "It is appropriate to start with a very simple example to demonstrate how \
the ",
  StyleBox["EquationTrekker", "MR"],
  " operates.  Entering"
}], "Text",
  CellTags->"EquationTrekker"],

Cell[BoxData[
    \(EquationTrekker[\(y''\)[x]\  + \ y[x]\  \[Equal] \ 0, 
      y, {x, \[Pi]\/8, \ 2\ \[Pi]}]\)], "Input",
  CellLabel->"In[2]:=",
  Evaluatable->False,
  CellTags->"EquationTrekker"],

Cell["\<\
brings up a separate window like the one shown below (starting with a blank \
canvas)\
\>", "Text",
  CellTags->"EquationTrekker"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008g0001cB000`400?l0
0000o`00003oo`3ooooo0?ooocT0oooo00000`1VIWh0nocm0?_lo@3o0?_l
oOl0nocm=@3ko?d10?ooo`0000<0IVIn0?_lo@2XZK/0o`2XZK_o0:RY^c@0
Z:Vk0@3ko?d10?ooo`0000<0IVIn0?_lo@2XZK/0o`1VIWko06IVOS<0IVIn
0@2XZK/10?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT0?l0lNoR
TP3akn830>3Oh`03075_I03akn80lNoR09L0lNoR00<0IVIn0:RY^`3ko?d0
0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0o`3ooonA0?ooo`050?7_
hP3Pgn<0h=oS0>3Oh`1aKf@0V03Pgn<0103akn80IVIn0:RY^`3ko?d10?oo
o`0000D0IVIn0?_lo@2XZK/0IVIn075_I03o0?oooi40oooo00D0lNoR0>3O
h`3Pgn<0h=oS075_I02H0>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo0000
1@1VIWh0nocm0:RY^`1VIWh0LFmT0?l0ooooT@3oool01@3akn80h=oS0>3O
h`3Pgn<0LFmT0080h=oSU03oool20>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40
oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT0?l0ooooT@3oool01@3akn80
h=oS0>3Oh`3Pgn<0LFmT0080h=oST`2LW9h01`3oool0h=oS0>3Oh`3akn80
IVIn0:RY^`3ko?d00@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0o`3o
oonA0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<00`2LW9h0oooo
0>3Oh`2?0>3Oh`0809bLWP3oool0h=oS0>3Oh`3akn80IVIn0:RY^`3ko?d1
0?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I0370?ooo`0309nOW`3oool0
oooo0<H0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0309bLWP3o
ool0h=oS08l0h=oS00P0W9bN0?ooo`3Pgn<0h=oS0?7_hP1VIWh0Z:Vk0?_l
o@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT0<L0oooo00<0Ogmo0?oo
o`3oool0aP3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00<0W9bN
0?ooo`3Pgn<06P3Pgn=O0:F//P050>7Pi03ViNP0k>_^0?3`lP3bl_@01@3c
lo@30?Sgn080lo?d00D0lo?e0?Cdm@3emOH0m??e0>GTj0020>3Oh`0809bL
WP3oool0h=oS0>3Oh`3akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_l
o@2XZK/0IVIn075_I0370?ooo`0307moO`3oool0oooo0<H0oooo00D0lNoR
0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0309bLWP3oool0h=oS01X0h=oS00<0
YJbb0?ooo`3oool0F`3oool01@2U[;80g]cO0>CRh01kUjd09EN500`003ad
00@05den06^;YP3blNh0l_7c0P3Pgn<0202LW9h0oooo0>3Oh`3Pgn<0lNoR
06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0a`3o
ool00`1oOgl0oooo0?ooo`360?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@0
0P3Pgn<00`2LW9h0oooo0>3Oh`0J0>3Oh`030:F//P3oool0oooo05/0oooo
00D0YJbb0=[Hf@1VQJ40BW6C0;:m``0<000000040<36a@18KY00JXZT0>o_
l@80h=oS00P0W9bN0?ooo`3Pgn<0h=oS0?7_hP1VIWh0Z:Vk0?_lo@40oooo
00001@1VIWh0nocm0:RY^`1VIWh0LFmT0<L0oooo00<0Ogmo0?ooo`3oool0
aP3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00<0W9bN0?ooo`3P
gn<06P3Pgn<00`2U[;80oooo0?ooo`1K0?ooo`050:F//P3HeMH05den0;o7
bP36aML0300000001036aML0][fm01M=OP3[j^d20>3Oh`0809bLWP3oool0
h=oS0>3Oh`3akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0
IVIn075_I02[0?ooo`030?ogl`3oj]l0oooo01T0oooo00<0Ogmo0?ooo`3o
ool0aP3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00<0W9bN0?oo
o`3Pgn<0203Pgn<7000000030>3Oh`00000000000080000000<0h=oS0000
000000000`3Pgn<00`2U[;80oooo0?ooo`1K0?ooo`040:F//P3IeMD003ad
0?ooo`H0cLcO0P0000060<g<g`030?ooo`00?7@0j>OZ0080h=oS00P0W9bN
0?ooo`3Pgn<0h=oS0?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm
0:RY^`1VIWh0LFmT0:T0oooo00@0ooOc0?n/P`3oJR00ooC_6P3oool00`1o
Ogl0oooo0?ooo`360?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<0
0`2LW9h0oooo0>3Oh`090>3Oh`0=0000003Pgn<000000>3Oh`000000h=oS
0000003Pgn<000000>3Oh`000000h=oS000000040>3Oh`030:F//P3oool0
oooo05/0oooo00@0YJbb0=WEe@00?7@0oooo1@3BdN@4000000D0d]7T00<0
oooo000lM03Wi^T00P3Pgn<0202LW9h0oooo0>3Oh`3Pgn<0lNoR06IVOP2X
ZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0Y`3oool01@3o
o?/0okNC0?mX703oE@00ojEh01/0oooo00<0Ogmo0?ooo`3oool0aP3oool0
1@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00<0W9bN0?ooo`3Pgn<00`3P
gn<010000000h=oS0>3Oh`0000020>3Oh`090000003Pgn<000000>3Oh`00
0000h=oS0000003Pgn<000000080h=oS00<000000>3Oh`3Pgn<00`3Pgn<0
0`2U[;80oooo0?ooo`0N0?ooo`<000000`3oool00`000000oooo00000004
00000080oooo0`0000030?ooo`<00000103oool00`000000oooo0?ooo`02
0?ooo`<000000`3oool3000000<0oooo0`0000040?ooo`030000003oool0
oooo00H0oooo00@0YJbb0=WEe@00?7@0oooo103FenL6000000@0e]OW00<0
oooo000lM03Wi^T00P3Pgn<0202LW9h0oooo0>3Oh`3Pgn<0lNoR06IVOP2X
ZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0Y@3oool00`3o
o?/0okB?0?m]90020?mE00030?mJ203ok><0oooo00X0oooo00<0onoW0?oZ
g`3oh]<00P3oe;l00`3o`Z<0oknO0?nbR`080?nZO`080;mZ?`3oZWl0okbK
0?o7Z`3oe;l0onCG0?oZg`3oo?_10?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1a
Kf@00P3Pgn<00`2LW9h0oooo0>3Oh`040>3Oh`030000003Pgn<000000080
h=oS00D000000>3Oh`000000h=oS000000020>3Oh`80000000@0h=oS0000
003Pgn<00000103Pgn<00`2U[;80oooo0?ooo`0M0?ooo`050000003oool0
oooo0?ooo`0000001@3oool00`000000oooo0?ooo`020?ooo`070000003o
ool0oooo0?ooo`000000oooo000000030?ooo`050000003oool0oooo0?oo
o`0000000`3oool01`000000oooo0?ooo`3oool000000?ooo`0000000`3o
ool00`000000oooo000000030?ooo`050000003oool0oooo0?ooo`000000
203oool0102U[;80fMGE000lM03oool30=WJi`P000000`3If^L00`3oool0
03ad0>OVj@020>3Oh`0809bLWP3oool0h=oS0>3Oh`3akn80IVIn0:RY^`3k
o?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I02T0?ooo`030?o7Z`3o
KB@0oeD000<0oeD000H0oj9d0?ooo`3oool0onoW0?oG``3o^YL70?nZO`03
0?njU`3o_il0olN[0080omBo00<0onOK0?oZg`3omo<0203oool0201oOgl0
oooo0?o/h`3oh]<0omBo0?o4Y`3o_il0ojb32@3oZWl01P3o^YL0olZ_0?oD
_`3ogll0on[O0?odkk80oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3O
h`0309bLWP3oool0h=oS00D0h=oS00<000000>3Oh`3Pgn<01@0000020>3O
h`80000000@0h=oS000000000000h=oS0P0000030>3Oh`030:F//P3oool0
oooo01d0oooo00D000000?ooo`3oool0oooo000000060?ooo`050000003o
ool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`030?ooo`050000
003oool0oooo0?ooo`0000000`3oool01@000000oooo0?ooo`3oool00000
00D0oooo00<000000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool0
000000P0oooo00@0YJbb0=WEe@00?7@0oooo1P3If^L2000000H0fM[W00<0
oooo000lM03Wi^T00P3Pgn<0202LW9h0oooo0>3Oh`3Pgn<0lNoR06IVOP2X
ZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0V`3oool02@3o
o?/0ojEh0?mM303oFPP0oj1`0?ogl`3oool0olBW0?m`:0060?mE00060?nP
K`3oZWl0ojYo0?njU`3od[/0onoW5`3oool00`1oOgl0oooo0?ooo`0>0?oo
o`060?o_i`3ogll0omBo0?o:[`3o_il0okB?1P3oZWl00`3o^YL0omc;0?oj
m`2Y0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<00`2LW9h0oooo
0>3Oh`050>3Oh`030000003Pgn<0h=oS0180h=oS00<0YJbb0?ooo`3oool0
7@3oool01@000000oooo0?ooo`3oool0000000L0oooo00@000000?ooo`3o
ool000000`3oool00`000000oooo0?ooo`030?ooo`050000003oool0oooo
0?ooo`0000000`3oool01@000000oooo0?ooo`3oool0000000D0oooo00<0
00000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool0000000P0oooo
00@0YJbb0=WEe@00?7@0oooo1P3SiO02000000H0hnG`00<0oooo000lM03W
i^T00P3Pgn<0202LW9h0oooo0>3Oh`3Pgn<0lNoR06IVOP2XZK/0nocm0@3o
ool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0V`3oool00`3oYGP0oeD00?mE
00020?mE00030?n:D03oKRH0oeD000L0oeD000<0oj9d0?oln`3oool06P3o
ool00`1oOgl0oooo0?ooo`0J0?ooo`070?o_i`3oc;<0ojn70?nZO`3o[hL0
olN[0?oZg`2U0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<00`2L
W9h0oooo0>3Oh`050>3Oh`8000004`3Pgn<00`2U[;80oooo0?ooo`0M0?oo
o`@000002@3oool00`000000oooo0?ooo`03000000@0oooo0P0000040?oo
o`030000003oool0oooo0080oooo0`0000020?ooo`@00000103oool20000
00@0oooo00<000000?ooo`3oool01P3oool0102U[;80fMGE000lM03oool6
0?3ao08000001P3`lO`00`3oool003ad0>OVj@020>3Oh`0809bLWP3oool0
h=oS0>3Oh`3akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0
IVIn075_I02K0?ooo`030?mM303oE@00oeD000d0oeD000<0oi1H0?ogl`3o
ool06@3oool00`1oOgl0oooo0?ooo`0N0?ooo`030?ojm`3oh]<0oknO0080
ojYo00<0ojb30?o7Z`3ok><0X03oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT
0080h=oS00<0W9bN0?ooo`3Pgn<0103Pgn<2000000030>3Oh`000000h=oS
0140h=oS00<0YJbb0?ooo`3oool07@3oool00`000000oooo0?ooo`0:0?oo
o`030000003oool0000000<0oooo00<000000?ooo`3oool00`3oool01@00
0000oooo0000003oool0000000<0oooo00L000000?ooo`3oool0oooo0000
003oool0000000T0oooo00D000000?ooo`000000oooo000000080?ooo`04
0:F//P3IeMD003ad0?ooo`H0m_Om0P0000060?Kgo@030?ooo`00?7@0inKY
0080h=oS00P0W9bN0?ooo`3Pgn<0h=oS0?7_hP1VIWh0Z:Vk0?_lo@40oooo
00001@1VIWh0nocm0:RY^`1VIWh0LFmT09/0oooo00<0oed<0?mE003oE@00
0P3oE@001`3oF@H0okbK0?nZO`3oUF00oh100?mZ803oF0@01@3oE@000`3o
T5P0oock0?ooo`0H0?ooo`0307moO`3oool0oooo02<0oooo00<0oock0?oR
d`3o_9/00P3oZWl00`3o]8l0omBo0?ojm`2K0?ooo`050?7_hP3Pgn<0h=oS
0>3Oh`1aKf@00P3Pgn<00`2LW9h0oooo0>3Oh`0J0>3Oh`030:F//P3oool0
oooo01d0oooo00D000000?ooo`3oool0oooo000000040?ooo`070000003o
ool0oooo0?ooo`000000oooo000000030?ooo`030000003oool0000000<0
oooo00<000000?ooo`3oool00P0000030?ooo`050000003oool0oooo0?oo
o`0000000P3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo
0?ooo`0000000P3oool2000000P0oooo00@0YJbb0=WEe@00?7@0oooo1P3h
o?d2000000H0n?cm00<0oooo000lM03Wi^T00P3Pgn<0202LW9h0oooo0>3O
h`3Pgn<0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IV
OP1aKf@0V`3oool00`3oYGP0oeD00?mE00020?mE00030?nPL03oool0oooo
00<0oooo00T0oock0?oZg`3oe;l0ol:S0?n_Q`3oV6@0oh940?nRM03oo?/0
603oool00`1oOgl0oooo0?ooo`0X0?ooo`030?odk`3oe;l0ojn70080ojYo
00<0ojn70?o?]`3ol^/0UP3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080
h=oS00<0W9bN0?ooo`3Pgn<06P3Pgn<00`2U[;80oooo0?ooo`0N0?ooo`<0
00001P3oool3000000<0oooo0`0000030?ooo`<00000103oool00`000000
oooo0?ooo`020?ooo`<000000`3oool400000080oooo0`0000040?ooo`03
0000003oool0oooo00H0oooo00@0YJbb0=WEe@00?7@0oooo1P3moOd20000
00H0oOgm00<0oooo000lM03Wi^T00P3Pgn<0202LW9h0oooo0>3Oh`3Pgn<0
lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0
V`3oool01P3oo?/0ojEh0?mM303oFPP0oj1`0?oglbH0oooo00<0Ogmo0?oo
o`3oool0;@3oool00`3on_L0om[70?ngT`020?nZO`030?ngT`3of/L0oo[g
0940oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0309bLWP3oool0
h=oS01X0h=oS00<0YJbb0?ooo`3oool0F`3oool0102U[;80fMGE000lM03o
ool60?gmo@8000001P3moOd00`3oool003ad0>KVj@020>3Oh`0809bLWP3o
ool0h=oS0>3Oh`3akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2X
ZK/0IVIn075_I0370?ooo`0307moO`3oool0oooo0380oooo00H0oo;[0?o?
]`3o[hL0oie/0?njU`3oknN>0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@0
0P3Pgn<00`2LW9h0oooo0>3Oh`0J0>3Oh`030:F//P3oool0oooo05/0oooo
00@0YJbb0=SDe000?7@0oooo1P3moOd2000000H0oOgm00<0oooo000lM03U
iNP00P3Pgn<0202LW9h0oooo0>3Oh`3Pgn<0lNoR06IVOP2XZK/0nocm0@3o
ool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0a`3oool00`1oOgl0oooo0?oo
o`0f0?ooo`050?oRd`3oZ7`0oiYX0?oB^`3oo?/0R`3oool01@3akn80h=oS
0>3Oh`3Pgn<0LFmT0080h=oS00<0W9bN0?ooo`3Pgn<06P3Pgn<00`2U[;80
oooo0?ooo`1K0?ooo`040:F//P3IeMD09EN50;o>g0H0oooo0P0000060?oo
o`030;o>f`0UEhD0hN7T0080h=oS00P0W9bN0?ooo`3Pgn<0h=oS0?7_hP1V
IWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT0<L0oooo
00<0Ogmo0?ooo`3oool0>03oool01@3omo<0olZ_0?nPL03oZWl0oncS08T0
oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0309bLWP3oool0h=oS
01X0h=oS00<0YJbb0?ooo`3oool0F`3oool01@2U[;80fMGE07VDZ@1EOJ80
`<oM00D0oooo0P0000050?ooo`040=GOj01EOJ80NIF[0=oMh080h=oS00P0
W9bN0?ooo`3Pgn<0h=oS0?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0
nocm0:RY^`1VIWh0LFmT0<L0oooo00<0Ogmo0?ooo`3oool0>`3oool01@3o
im/0ok:;0?nMK03oc;<0oo[g08H0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_
I0020>3Oh`0309bLWP3oool0h=oS01X0h=oS00<0YJbb0?ooo`3oool0F`3o
ool01@2U[;80f]OI0=oLf01iU:T09EN500`003ad00@05den06J6X@3Pg]X0
g=_M0P3Pgn<0202LW9h0oooo0>3Oh`3Pgn<0lNoR06IVOP2XZK/0nocm0@3o
ool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0a`3oool00`1oOgl0oooo0?oo
o`0m0?ooo`050?ojm`3o`Z<0oiQT0?nZO`3oj]l0Q03oool01@3akn80h=oS
0>3Oh`3Pgn<0LFmT0080h=oS00<0W9bN0?ooo`3Pgn<06P3Pgn=O0:F//P03
0=oMh03JemT0f=CD00L0em?D0`3Cc/`30=OCe0040=SDe03IeMD0f]OI0=oM
h080h=oS00P0W9bN0?ooo`3Pgn<0h=oS0?7_hP1VIWh0Z:Vk0?_lo@40oooo
00001@1VIWh0nocm0:RY^`1VIWh0LFmT0<L0oooo00<0Ogmo0?ooo`3oool0
@03oool01@3oim/0oj1`0?nHI03oaj/0oo[g0840oooo00D0lNoR0>3Oh`3P
gn<0h=oS075_I0020>3Oh`0309bLWP3oool0h=oS08l0h=oS00P0W9bN0?oo
o`3Pgn<0h=oS0?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY
^`1VIWh0LFmT0<L0oooo00<0Ogmo0?ooo`3oool0@P3oool01@3oo?/0olbc
0?nHI03oZ7`0on;C07l0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3O
h`0309bLWP3oool0h=oS08l0h=oS00P0W9bN0?ooo`3Pgn<0h=oS0?7_hP1V
IWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT0<L0oooo
00<0Ogmo0?ooo`3oool0A@3oool01@3ol^/0ojb30?nBG03oa:L0oo[g07`0
oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0309bLWP3oool0h=oS
08l0h=oS00P0W9bN0?ooo`3Pgn<0h=oS0?7_hP1VIWh0Z:Vk0?_lo@40oooo
00001@1VIWh0nocm0:RY^`1VIWh0LFmT0<L0oooo00<0Ogmo0?ooo`3oool0
B03oool0103oe;l0oj1`0?nUN03oh]=j0?ooo`050?7_hP3Pgn<0h=oS0>3O
h`1aKf@00P3Pgn<00`2LW9h0oooo0>3Oh`2?0>3Oh`0809bLWP3oool0h=oS
0>3Oh`3akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn
075_I0370?ooo`0307moO`3oool0oooo04X0oooo00D0ooC_0?ndS`3oTU`0
oknO0?ogl`1g0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<00`2L
W9h0oooo0>3Oh`0J0>3Ohel0YJbb00D0hN3T0>KUj03/jnh0l?3b0?;bm005
0??cm0<0n?Oh0P3clo@01@3cloD0m?Ce0?GemP3dloD0iNCX0080h=oS00P0
W9bN0?ooo`3Pgn<0h=oS0?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0
nocm0:RY^`1VIWh0LFmT0<L0oooo00<0Ogmo0?ooo`3oool0C@3oool0103o
g</0oiYX0?nRM03oglme0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3P
gn<00`2LW9h0oooo0>3Oh`0J0>3Oh`030:F//P3oool0oooo05/0oooo00D0
YJbb0=kLg`3Th^00NiN]02EGQ@0<000lM00401M=OP1[RjH0l_7^0?;al`80
h=oS00P0W9bN0?ooo`3Pgn<0h=oS0?7_hP1VIWh0Z:Vk0?_lo@40oooo0000
1@1VIWh0nocm0:RY^`1VIWh0LFmT0<L0oooo00<0Ogmo0?ooo`3oool0C`3o
ool0103omo<0okNC0?nMK03oel=c0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1a
Kf@00P3Pgn<00`2LW9h0oooo0>3Oh`0J0>3Oh`030:F//P3oool0oooo05/0
oooo00D0YJbb0=[Hf@1VQJ40BW6C0;:m``0<000000040<36a@18KY00JXZT
0>o_l@80h=oS00P0W9bN0?ooo`3Pgn<0h=oS0?7_hP1VIWh0Z:Vk0?_lo@40
oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT0<L0oooo00<0Ogmo0?ooo`3o
ool0DP3oool00`3o_il0oj1`0?odk`1a0?ooo`050?7_hP3Pgn<0h=oS0>3O
h`1aKf@00P3Pgn<00`2LW9h0oooo0>3Oh`080>3Oh``0000000<0h=oS0000
000000000`3Pgn<00`2U[;80oooo0?ooo`1K0?ooo`050:F//P3HeMH05den
0;o7bP36aML0300000001036aML0][fm01M=OP3[j^d20>3Oh`0809bLWP3o
ool0h=oS0>3Oh`3akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2X
ZK/0IVIn075_I0370?ooo`0307moO`3oool0oooo05<0oooo00<0ooC_0?nZ
O`3o`Z<0L03oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00<0W9bN
0?ooo`3Pgn<02@3Pgn<01@000000h=oS0000003Pgn<000000080h=oS00<0
00000>3Oh`0000000P3Pgn<00`000000h=oS0>3Oh`020>3Oh`030:F//P3o
ool0oooo05/0oooo00@0YJbb0=WEe@00?7@0oooo1P3=c=l2000000H0cLcO
00<0oooo000lM03XinX00P3Pgn<0202LW9h0oooo0>3Oh`3Pgn<0lNoR06IV
OP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0a`3oool0
0`1oOgl0oooo0?ooo`1E0?ooo`030?oJa`3oYGP0onOK06h0oooo00D0lNoR
0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0309bLWP3oool0h=oS00<0h=oS00@0
00000>3Oh`3Pgn<000000P3Pgn<01@000000h=oS0000003Pgn<000000080
h=oS00<000000>3Oh`0000000P3Pgn<00`000000h=oS0>3Oh`020>3Oh`03
0:F//P3oool0oooo05/0oooo00@0YJbb0=WEe@00?7@0oooo1@3BdN@40000
00D0d]7T00<0oooo000lM03Wi^T00P3Pgn<0202LW9h0oooo0>3Oh`3Pgn<0
lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0
a`3oool00`1oOgl0oooo0?ooo`1F0?ooo`040?oln`3o]8l0ok:;0?ojmf`0
oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0309bLWP3oool0h=oS
00@0h=oS00<000000>3Oh`0000000P3Pgn<01@000000h=oS0000003Pgn<0
00000080h=oS00H000000>3Oh`00000000000>3Oh`0000040>3Oh`030:F/
/P3oool0oooo01h0oooo0`0000030?ooo`030000003oool0oooo00<00000
0`3oool300000080oooo1@0000020?ooo`<000000`3oool3000000<0oooo
0`0000030?ooo`<000000`3oool3000000L0oooo00@0YJbb0=WEe@00?7@0
oooo103FenL6000000@0e]OW00<0oooo000lM03Wi^T00P3Pgn<0202LW9h0
oooo0>3Oh`3Pgn<0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0
Z:Vk06IVOP1aKf@0a`3oool00`1oOgl0oooo0?ooo`1H0?ooo`030?o_i`3o
X700om:k06/0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0309bL
WP3oool0h=oS00D0h=oS00<000000>3Oh`3Pgn<01@0000020>3Oh`@00000
00<0h=oS0000003Pgn<0103Pgn<00`2U[;80oooo0?ooo`0M0?ooo`050000
003oool0oooo0?ooo`000000103oool01`000000oooo0?ooo`3oool00000
0?ooo`0000000`3oool010000000oooo0?ooo`0000040?ooo`070000003o
ool0oooo0?ooo`000000oooo000000030?ooo`030000003oool0000000<0
oooo00<000000?ooo`0000000`3oool00`000000oooo000000030?ooo`03
0000003oool0oooo00@0oooo00@0YJbb0=WEe@00?7@0oooo0`3If^L80000
00<0fM[W00<0oooo000lM03Wi^T00P3Pgn<0202LW9h0oooo0>3Oh`3Pgn<0
lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0
]@3oool03P2o_kl0?3`l03`l?01TI6@0lo?c0?ooo`0l?3`0alO70?ooo`2S
Xj<0:2PX0410@014A4@0gmoO103oool00`1oOgl0oooo0?ooo`1J0?ooo`03
0?o:[`3oZWl0onoW06T0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3O
h`0309bLWP3oool0h=oS00D0h=oS00<000000>3Oh`3Pgn<04P3Pgn<00`2U
[;80oooo0?ooo`0M0?ooo`050000003oool0oooo0?ooo`000000203oool0
0`000000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`0000000`3o
ool01@000000oooo0?ooo`3oool0000000D0oooo00<000000?ooo`3oool0
0`3oool00`000000oooo000000030?ooo`030000003oool0000000<0oooo
00<000000?ooo`3oool0103oool0102U[;80fMGE000lM03oool60=WJi`80
00001P3If^L00`3oool003ad0>OVj@020>3Oh`0809bLWP3oool0h=oS0>3O
h`3akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_
I02d0?ooo`0?0??cl`0L71`0hn?S0?ooo`18B4P0UiNG0?ooo`37alL0kno_
0=OGe`0/;2`0lo?c0?ooo`2?Shl0H61P00@0oooo00<0Ogmo0?ooo`3oool0
F`3oool0103oo?/0ojb30?njU`3oo?]W0?ooo`050?7_hP3Pgn<0h=oS0>3O
h`1aKf@00P3Pgn<00`2LW9h0oooo0>3Oh`050>3Oh`8000002@3Pgn<00`00
0000h=oS0>3Oh`070>3Oh`030:F//P3oool0oooo01d0oooo00D000000?oo
o`3oool0oooo000000080?ooo`030000003oool0oooo00@00000103oool0
10000000oooo0?ooo`0000030?ooo`030000003oool0oooo00@000000P3o
ool4000000030?ooo`000000oooo0080oooo00<000000?ooo`0000000`3o
ool00`000000oooo0?ooo`040?ooo`040:F//P3IeMD003ad0?ooo`H0hnG`
0P0000060>?Ul0030?ooo`00?7@0inKY0080h=oS00P0W9bN0?ooo`3Pgn<0
h=oS0?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0
LFmT0;00oooo00H0_kno07moO`1oOgl0_kno0<?3``0h>3P20?ooo`0309^K
V`1@D500oooo0080oooo00H0WinO061PH03oool0oooo0;no_`10@4040?oo
o`0307moO`3oool0oooo05d0oooo00<0om[70?nPL03ogll0IP3oool01@3a
kn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00<0W9bN0?ooo`3Pgn<0103Pgn<2
000000030>3Oh`000000h=oS0140h=oS00<0YJbb0?ooo`3oool07@3oool0
1@000000oooo0?ooo`3oool0000000H0oooo0P0000020?ooo`050000003o
ool0oooo0?ooo`0000001@3oool00`000000oooo0000000300000080oooo
00L000000?ooo`3oool0oooo0000003oool0000000<0oooo00<000000?oo
o`0000000`3oool00`000000oooo0?ooo`03000000L0oooo00@0YJbb0=WE
e@00?7@0oooo1P3`lO`2000000H0l?7l00<0oooo000lM03Wi^T00P3Pgn<0
202LW9h0oooo0>3Oh`3Pgn<0lNoR06IVOP2XZK/0nocm0@3oool0000506IV
OP3ko?d0Z:Vk06IVOP1aKf@0/03oool01P2o_kl0Ogmo07moO`2o_kl0WinO
05aLG080oooo00<0_kno0410@03oool00P3oool01P3GemL092@T0=oOg`3o
ool0I6AT08N7Q`@0oooo00<0Ogmo0?ooo`3oool0G`3oool00`3o/X/0ojEh
0?ogl`1T0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<00`2LW9h0
oooo0>3Oh`0J0>3Oh`030:F//P3oool0oooo01d0oooo00D000000?ooo`3o
ool0oooo000000080?ooo`030000003oool0000000<0oooo00<000000?oo
o`3oool00`3oool00`000000oooo000000050?ooo`070000003oool0oooo
0?ooo`000000oooo000000030?ooo`030000003oool0000000<0oooo00<0
00000?ooo`0000000`3oool00`000000oooo0?ooo`040?ooo`040:F//P3I
eMD003ad0?ooo`H0m_Om0P0000060?Kgo@030?ooo`00?7@0inKY0080h=oS
00P0W9bN0?ooo`3Pgn<0h=oS0?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1V
IWh0nocm0:RY^`1VIWh0LFmT0;@0oooo00H0Xj>S05aLG03oool0oooo0;no
_`10@4040?ooo`0508>3P`0T92@0>3Ph02`/;03gmoL0103oool00`1oOgl0
oooo0?ooo`1P0?ooo`030?o/h`3oXW@0olBW06<0oooo00D0lNoR0>3Oh`3P
gn<0h=oS075_I0020>3Oh`0309bLWP3oool0h=oS01X0h=oS00<0YJbb0?oo
o`3oool07@3oool01@000000oooo0?ooo`3oool0000000@0oooo00L00000
0?ooo`3oool0oooo0000003oool0000000<0oooo00<000000?ooo`000000
0`3oool00`000000oooo000000030?ooo`030000003oool0000000<0oooo
00<000000?ooo`0000000`3oool00`000000oooo000000030?ooo`030000
003oool0000000<0oooo00<000000?ooo`3oool0103oool0102U[;80fMGE
000lM03oool60?Slo@8000001P3ho?d00`3oool003ad0>OVj@020>3Oh`08
09bLWP3oool0h=oS0>3Oh`3akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn
0?_lo@2XZK/0IVIn075_I02d0?ooo`060<?3``0h>3P0oooo0?ooo`2OWil0
F5QH0`3oool01P3_knl071`L0>_[j`3oool0I6AT08n?S`80oooo00D0WinO
07moO`0o?cl0Ogmo09nOW`1R0?ooo`030?o7Z`3oWF`0on;C0640oooo00D0
lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0309bLWP3oool0h=oS01X0h=oS
00<0YJbb0?ooo`3oool07P3oool3000000H0oooo0`0000030?ooo`<00000
0`3oool3000000<0oooo0`0000030?ooo`<000000`3oool3000000<0oooo
0`0000030?ooo`<000001`3oool0102U[;80fMGE000lM03oool60?gmo@80
00001P3moOd00`3oool003ad0>OVj@020>3Oh`0809bLWP3oool0h=oS0>3O
h`3akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_
I02d0?ooo`060??cl`0L71`0hn?S0?ooo`1HF5P0UiNG0`3oool01P3Shn<0
410@0>_[j`3oool0I6AT07moO`@0oooo00<0Ogmo0?ooo`3oool0H`3oool0
103om>l0ojYo0?nZO`3on_MO0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@0
0P3Pgn<00`2LW9h0oooo0>3Oh`0J0>3Oh`030:F//P3oool0oooo05/0oooo
00@0YJbb0=WEe@00?7@0oooo1P3moOd2000000H0oOgm00<0oooo000lM03V
i^T00P3Pgn<0202LW9h0oooo0>3Oh`3Pgn<0lNoR06IVOP2XZK/0nocm0@3o
ool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0]@3oool01@2SXj<0=3@d0410
@01TI6@0no_k00@0oooo00D0Rh^;03Ph>00h>3P0B4Q80>_[j`040?ooo`03
07moO`3oool0oooo06D0oooo00<0onCG0?nJJ03oc;<0GP3oool01@3akn80
h=oS0>3Oh`3Pgn<0LFmT0080h=oS00<0W9bN0?ooo`3Pgn<06P3Pgn<00`2U
[;80oooo0?ooo`1K0?ooo`040:F//P3He=@003ad0?ooo`H0oOgm0P000006
0?gmo@030?ooo`00?7@0iNGX0080h=oS00P0W9bN0?ooo`3Pgn<0h=oS0?7_
hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT0<L0
oooo00<0Ogmo0?ooo`3oool0I`3oool00`3oc;<0oie/0?oWf`1L0?ooo`05
0?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<00`2LW9h0oooo0>3Oh`0J0>3O
h`030:F//P3oool0oooo05/0oooo00@0YJbb0=WEe@0UEhD0_lkL1P3oool2
000000H0oooo00<0_lkK02EGQ@3QhN@00P3Pgn<0202LW9h0oooo0>3Oh`3P
gn<0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1a
Kf@0a`3oool00`1oOgl0oooo0?ooo`1X0?ooo`040?odk`3oWF`0okbK0?od
keX0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0309bLWP3oool0
h=oS01X0h=oS00<0YJbb0?ooo`3oool0F`3oool01@2U[;80fMGE07VDZ@1E
OJ80`<oM00D0oooo0P0000050?ooo`040=GOj01EOJ80NIF[0=oMh080h=oS
00P0W9bN0?ooo`3Pgn<0h=oS0?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1V
IWh0nocm0:RY^`1VIWh0LFmT0<L0oooo00<0Ogmo0?ooo`3oool0JP3oool0
0`3oh]<0oiEP0?oZg`1I0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3P
gn<00`2LW9h0oooo0>3Oh`0J0>3Oh`030:F//P3oool0oooo05/0oooo00D0
YJbb0=[Gf@3Og=P0NIBY02EGQ@0<000lM00401M=OP1VQZ40h=kJ0=cKg@80
h=oS00P0W9bN0?ooo`3Pgn<0h=oS0?7_hP1VIWh0Z:Vk0?_lo@40oooo0000
1@1VIWh0nocm0:RY^`1VIWh0LFmT0<L0oooo00<0Ogmo0?ooo`3oool0J`3o
ool00`3on_L0oie/0?oG``1H0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@0
0P3Pgn<00`2LW9h0oooo0>3Oh`0J0>3Ohel0YJbb00<0gmgP0=[Gf@3He=@0
1`3Gdm@30=?>c0<0em?D00@0f=CD0=WEe@3JemT0gmgP0P3Pgn<0202LW9h0
oooo0>3Oh`3Pgn<0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0
Z:Vk06IVOP1aKf@0a`3oool00`1oOgl0oooo0?ooo`1]0?ooo`030?n_Q`3o
_il0oooo05H0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0309bL
WP3oool0h=oS08l0h=oS00P0W9bN0?ooo`3Pgn<0h=oS0?7_hP1VIWh0Z:Vk
0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT0<L0oooo00<0Ogmo
0?ooo`3oool0KP3oool00`3obZl0ojQl0?ojm`1E0?ooo`050?7_hP3Pgn<0
h=oS0>3Oh`1aKf@00P3Pgn<00`2LW9h0oooo0>3Oh`2?0>3Oh`0809bLWP3o
ool0h=oS0>3Oh`3akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2X
ZK/0IVIn075_I01D0?ooo`030?o/h`3o/X/0oooo0700oooo00<0Ogmo0?oo
o`3oool0K`3oool00`3oi=L0oie/0?obj`1D0?ooo`050?7_hP3Pgn<0h=oS
0>3Oh`1aKf@00P3Pgn<00`2LW9h0oooo0>3Oh`2?0>3Oh`0809bLWP3oool0
h=oS0>3Oh`3akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0
IVIn075_I01C0?ooo`030?oD_`3oX700ooOc0740oooo00<0Ogmo0?ooo`3o
ool0L03oool00`3om>l0oie/0?oTe`1C0?ooo`050?7_hP3Pgn<0h=oS0>3O
h`1aKf@00P3Pgn<00`2LW9h0oooo0>3Oh`2?0>3Oh`0809bLWP3oool0h=oS
0>3Oh`3akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn
075_I01B0?ooo`030?nbR`3o]8l0oooo0780oooo00<0Ogmo0?ooo`3oool0
L@3oool00`3on_L0oiYX0?oJa`1B0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1a
Kf@00P3Pgn<00`2LW9h0oooo0>3Oh`2?0>3Oh`0809bLWP3oool0h=oS0>3O
h`3akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_
I01@0?ooo`030?ojm`3oWF`0om:k07@0oooo00<0Ogmo0?ooo`3oool0L`3o
ool00`3o/X/0okB?0?ooo`1@0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@0
0P3Pgn<00`2LW9h0oooo0>3Oh`2?0>3Oh`0809bLWP3oool0h=oS0>3Oh`3a
kn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I01?
0?ooo`030?o_i`3oUF00on[O07D0oooo00<0Ogmo0?ooo`3oool0M03oool0
0`3od[/0ojYo0?ojm`1?0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3P
gn<00`2LW9h0oooo0>3Oh`0H0>3Oh`030000003Pgn<0h=oS03X0h=oS1000
000f0>3Oh`0809bLWP3oool0h=oS0>3Oh`3akn80IVIn0:RY^`3ko?d10?oo
o`0000D0IVIn0?_lo@2XZK/0IVIn075_I01>0?ooo`030?oOc`3oVVP0ooOc
07H0oooo00<0Ogmo0?ooo`3oool0M@3oool00`3oj]l0oie/0?obj`1>0?oo
o`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<00`2LW9h0oooo0>3Oh`0H
0>3Oh`030000003Pgn<0h=oS03h0h=oS00<000000>3Oh`3Pgn<0<`3Pgn<0
202LW9h0oooo0>3Oh`3Pgn<0lNoR06IVOP2XZK/0nocm0@3oool0000506IV
OP3ko?d0Z:Vk06IVOP1aKf@0C@3oool00`3oc;<0ojYo0?oln`1g0?ooo`03
07moO`3oool0oooo07H0oooo00<0ooC_0?nPL03oh]<0C@3oool01@3akn80
h=oS0>3Oh`3Pgn<0LFmT0080h=oS00<0W9bN0?ooo`3Pgn<0103Pgn<00`00
0000h=oS000000030>3Oh`030000003Pgn<0h=oS0080000000@0h=oS0000
003Pgn<0h=oS0`0000020>3Oh`040000003Pgn<00000000000<0h=oS0`00
00020>3Oh`050000003Pgn<0h=oS0>3Oh`0000000P3Pgn<2000000040>3O
h`000000h=oS0>3Oh`<000000P3Pgn<01P000000h=oS0>3Oh`3Pgn<00000
0>3Oh`800000103Pgn<00`000000h=oS0>3Oh`020>3Oh`030000003Pgn<0
h=oS0080000000@0h=oS0000003Pgn<000000`3Pgn<00`000000h=oS0>3O
h`02000000040>3Oh`000000h=oS0>3Oh`<00000<03Pgn<0202LW9h0oooo
0>3Oh`3Pgn<0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk
06IVOP1aKf@0C03oool00`3o]8l0olBW0?ooo`1h0?ooo`0307moO`3oool0
oooo07P0oooo00<0ojQl0?oJa`3oool0B`3oool01@3akn80h=oS0>3Oh`3P
gn<0LFmT0080h=oS00<0W9bN0?ooo`3Pgn<0103Pgn<00`000000h=oS0000
00030>3Oh`030000003Pgn<000000080h=oS0P0000000`3Pgn<000000>3O
h`020>3Oh`040000003Pgn<0000000000080h=oS00<000000>3Oh`000000
0`3Pgn<00`000000h=oS000000030>3Oh`030000003Pgn<000000080h=oS
0P0000000`3Pgn<000000>3Oh`020>3Oh`030000003Pgn<0000000<0h=oS
00<000000>3Oh`0000001@3Pgn<01@000000h=oS0>3Oh`3Pgn<000000080
h=oS00<000000>3Oh`3Pgn<00P0000000`3Pgn<000000>3Oh`020>3Oh`03
0000003Pgn<000000080h=oS0P0000000`3Pgn<000000>3Oh`020>3Oh`03
0000003Pgn<0h=oS02d0h=oS00P0W9bN0?ooo`3Pgn<0h=oS0?7_hP1VIWh0
Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT04X0oooo00<0
oo[g0?nJJ03of/L0NP3oool00`1oOgl0oooo0?ooo`1i0?ooo`030?o4Y`3o
]8l0oooo04X0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0309bL
WP3oool0h=oS00@0h=oS00<000000>3Oh`0000000`3Pgn<00`000000h=oS
000000030>3Oh`030000003Pgn<0000000D0h=oS00L000000>3Oh`3Pgn<0
h=oS0000003Pgn<0000000D0h=oS00L000000>3Oh`3Pgn<0h=oS0000003P
gn<0000000<0h=oS00<000000>3Oh`0000001@3Pgn<01`000000h=oS0>3O
h`3Pgn<000000>3Oh`0000001@3Pgn<01@000000h=oS0>3Oh`3Pgn<00000
0080h=oS00L000000>3Oh`3Pgn<0h=oS0000003Pgn<0000000<0h=oS00<0
00000>3Oh`0000000`3Pgn<00`000000h=oS0000000c0>3Oh`0809bLWP3o
ool0h=oS0>3Oh`3akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2X
ZK/0IVIn075_I0190?ooo`030?ojm`3oXW@0on[O07/0oooo00<0Ogmo0?oo
o`3oool0NP3oool00`3og</0ojYo0?ojm`190?ooo`050?7_hP3Pgn<0h=oS
0>3Oh`1aKf@00P3Pgn<00`2LW9h0oooo0?ooo`030?ooo`040>3Oh`000000
h=oS000000<0h=oS00<000000>3Oh`0000000`3Pgn<00`000000h=oS0000
0004000000030>3Oh`000000h=oS0080h=oS00<000000>3Oh`0000001000
00000`3Pgn<000000>3Oh`020>3Oh`030000003Pgn<0000000<0h=oS00<0
00000>3Oh`000000100000000`3Pgn<000000>3Oh`020>3Oh`030000003P
gn<0000000D0h=oS00@000000>3Oh`3Pgn<00000103Pgn<4000000030>3O
h`000000h=oS0080h=oS00<000000>3Oh`0000000`3Pgn<00`000000h=oS
0000000400000080h=oS;@3oool0202LW9h0oooo0>3Oh`3Pgn<0lNoR06IV
OP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0B03oool0
0`3on_L0okB?0?ojm`1l0?ooo`0307moO`3oool0oooo07/0oooo00<0onoW
0?nJJ03ol^/0B03oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS1P2L
W9h00`3Pgn<000000>3Oh`0200000080h=oS00<000000>3Oh`0000000P3P
gn<2000000030>3Oh`000000h=oS0080h=oS00@000000>3Oh`0000000000
0P3Pgn<00`000000h=oS000000030>3Oh`040000003Pgn<0000000000080
h=oS00<000000>3Oh`0000000P3Pgn<2000000030>3Oh`000000h=oS0080
h=oS00@000000>3Oh`00000000000P3Pgn<00`000000h=oS000000050>3O
h`D000000P3Pgn<01P000000h=oS0>3Oh`3Pgn<000000>3Oh`8000000P3P
gn<00`000000h=oS000000020>3Oh`80000000<0h=oS0000003Pgn<00P3P
gn<00`000000h=oS0>3Oh`0^09bLWP070?ooo`3Pgn<0h=oS0?7_hP1VIWh0
Z:Vk0?_lo@010?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I0170?ooo`03
0?oln`3o]8l0oo[g07d0oooo00<0Ogmo0?ooo`3oool0O03oool00`3omo<0
oj1`0?oTe`170?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@02@3Pgn<01000
0000h=oS0000003Pgn<2000000<0h=oS0P000000103Pgn<000000>3Oh`3P
gn<300000080h=oS00@000000>3Oh`00000000000`3Pgn<300000080h=oS
00@000000>3Oh`00000000000`3Pgn<2000000040>3Oh`000000h=oS0>3O
h`<000000P3Pgn<01@000000h=oS000000000000h=oS00<00000103Pgn<0
0`000000h=oS0>3Oh`020>3Oh`030000003Pgn<0h=oS00<000000P3Pgn<0
10000000h=oS0000000000030>3Oh`80000000@0h=oS0000003Pgn<0h=oS
0`00000d0>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm
0:RY^`1VIWh0LFmT04H0oooo00<0oo[g0?ndS`3omo<0OP3oool00`1oOgl0
oooo0?ooo`1n0?ooo`030?n/P`3oc;<0oooo04D0oooo00D0lNoR0>3Oh`3P
gn<0h=oS075_I0090>3Oh`030000003Pgn<0h=oS00T0h=oS00<000000>3O
h`3Pgn<06`3Pgn<00`000000h=oS0>3Oh`0;0>3Oh`030000003Pgn<0h=oS
00<0h=oS00<000000>3Oh`3Pgn<00P3Pgn<00`000000h=oS0>3Oh`190>3O
h`040?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0
LFmT04D0oooo00<0oo[g0?ndS`3on_L0O`3oool00`1oOgl0oooo0?ooo`1o
0?ooo`030?o4Y`3o^YL0oock04@0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_
I0090>3Oh`030000003Pgn<0h=oS00T0h=oS00<000000>3Oh`3Pgn<06`3P
gn<00`000000h=oS0>3Oh`0;0>3Oh`030000003Pgn<0h=oS00<0h=oS1@00
001<0>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY
^`1VIWh0LFmT04@0oooo00<0ooOc0?n_Q`3on_L0P03oool00`1oOgl0oooo
0?ooo`200?ooo`030?oOc`3oYGP0ooOc04<0oooo00D0lNoR0>3Oh`3Pgn<0
h=oS075_I02H0>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0
nocm0:RY^`1VIWh0LFmT04<0oooo00<0ooOc0?nHI03ol^/0P@3oool00`1o
Ogl0oooo0?ooo`210?ooo`030?o_i`3oVVP0oo[g0480oooo00D0lNoR0>3O
h`3Pgn<0h=oS075_I02H0>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo0000
1@1VIWh0nocm0:RY^`1VIWh0LFmT0480oooo00<0ooC_0?nPL03ol^/0PP3o
ool00`1oOgl0oooo0?ooo`220?ooo`030?o_i`3oYGP0oock0440oooo00D0
lNoR0>3Oh`3Pgn<0h=oS075_I02H0>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40
oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT0440oooo00<0oo[g0?nZO`3o
mo<0P`3oool00`1oOgl0oooo0?ooo`230?ooo`030?oOc`3o^YL0oooo0400
oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I02H0>3Oh`040?7_hP1VIWh0Z:Vk
0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT0400oooo00<0oock
0?nZO`3om>l0Q03oool00`1oOgl0oooo0?ooo`240?ooo`030?o4Y`3ockL0
oooo03l0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I02H0>3Oh`040?7_hP1V
IWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT03l0oooo
00<0oo[g0?nUN03on_L0Q@3oool00`1oOgl0oooo0?ooo`250?ooo`030?n/
P`3oh]<0oooo03h0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I02H0>3Oh`04
0?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT
03l0oooo00<0oiYX0?oWf`3oool0Q@3oool00`1oOgl0oooo0?ooo`260?oo
o`030?nPL03ol^/0oooo03d0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I02H
0>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1V
IWh0LFmT03h0oooo00<0ojQl0?oLb`3oool0OP3oool01@3goOl0goWo0<of
o`2olol0^o;o0080Wngo00<0PnOo03nV_`1oi_l01P1oi_l01`2?jOl0Wngo
0;?`o`2olol0eoOo0=oio`3goOl0NP3oool00`3omo<0oiYX0?ojm`0m0?oo
o`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn>D0?ooo`80h=oS00@0lNoR
06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0?@3o
ool00`3o`Z<0olN[0?ooo`1d0?ooo`040?Omo`3Gmol0]o7o09O[o`L0OnKo
00D0QnSo09o]o`2_l?l0_o?o0<?co`020=oio`030?_no`1oOgl0oooo00H0
oooo00L0koco0=oio`3;mOl0_o?o0:O^o`2OkOl0QnSo00D0OnKo00<0Wngo
0<_eo`3goOl0L`3oool00`3oknL0ojYo0?ooo`0l0?ooo`050?7_hP3Pgn<0
h=oS0>3Oh`1aKf@00P3Pgn>C09bLWP070?ooo`3Pgn<0h=oS0?7_hP1VIWh0
Z:Vk0?_lo@010?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I00l0?ooo`03
0?oB^`3o/X/0oooo06d0oooo00@0mogo0=Ogo`2glOl0Un_o101oi_l01027
j?l0Ynko0<Odo`3Wn_l?0?ooo`0307moO`3oool0oooo0140oooo00<0goWo
0;?`o`27j?l00P1oi_l00`2?jOl0[o3o0>_ko`1_0?ooo`030?oLb`3o]8l0
oooo03/0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0309bLWP3o
ool0h=oS08l0h=oS00P0W9bN0?ooo`3Pgn<0h=oS0?7_hP1VIWh0Z:Vk0?_l
o@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT03/0oooo00<0onCG0?nR
M03oool0JP3oool0203Sn_l0Un_o07CTo`1oi_l0QnSo0:O^o`37m?l0io[o
5`3oool00`1oOgl0oooo0?ooo`0F0?ooo`030>olo`3?m_l0Tn[o0080OnKo
00<0PnOo09o]o`3Gmol0J`3oool00`3oa:L0om[70?ooo`0j0?ooo`050?7_
hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<00`2LW9h0oooo0>3Oh`2?0>3Oh`08
09bLWP3oool0h=oS0>3Oh`3akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn
0?_lo@2XZK/0IVIn075_I00j0?ooo`030?odk`3oUF00oo[g06P0oooo00D0
jo_o09_/o`1hiOl0Vnco0>?jo`0M0?ooo`0307moO`3oool0oooo01/0oooo
00L0noko0=oio`2Wk_l0OnKo07CTo`2;jOl0koco06P0oooo00<0ojQl0?oR
d`3oool0>@3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00<0W9bN
0?ooo`3Pgn<08P3Pgn=G0:F//P050>7Pi03ViNP0k>_^0?3`lP3bl_@01@3c
lo@30?Sgn080lo?d00D0lo?e0?Cdm@3emOH0m??e0>GTj0020>3Oh`0809bL
WP3oool0h=oS0>3Oh`3akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_l
o@2XZK/0IVIn075_I00i0?ooo`030?oln`3oUF00oo;[06H0oooo00D0io[o
08oYo`1hiOl0Tn[o0=_ho`0P0?ooo`0307moO`3oool0oooo0200oooo00D0
eoOo07SUo`1/hol0_o?o0?_no`1V0?ooo`030?nPL03ol^/0oooo03P0oooo
00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0309bLWP3oool0h=oS0280
h=oS00<0YJbb0?ooo`3oool0D`3oool01@2U[;80g]cO0>CRh01kUjd09EN5
00`003ad00@05den06^;YP3blNh0l_7c0P3Pgn<0202LW9h0oooo0>3Oh`3P
gn<0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1a
Kf@0>@3oool00`3oX700onCG0?ooo`1S0?ooo`050>_ko`27j?l0M>Co08oY
o`3Sn_l08`3oool00`1oOgl0oooo0?ooo`0R0?ooo`050?Omo`2Wk_l0J>;o
08oYo`3[nol0I03oool00`3om>l0oie/0?ojm`0h0?ooo`050?7_hP3Pgn<0
h=oS0>3Oh`1aKf@00P3Pgn<00`2LW9h0oooo0>3Oh`0R0>3Oh`030:F//P3o
ool0oooo05<0oooo00D0YJbb0=[Hf@1VQJ40BW6C0;:m``0<000000040<36
a@18KY00JXZT0>o_l@80h=oS00P0W9bN0?ooo`3Pgn<0h=oS0?7_hP1VIWh0
Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT03P0oooo00<0
okB?0?o?]`3oool0H@3oool01@3Sn_l0OnKo073To`27j?l0io[o02H0oooo
00<0Ogmo0?ooo`3oool09@3oool0103Gmol0N>Go073To`2olomS0?ooo`03
0?oZg`3oZWl0oooo03L0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3O
h`0309bLWP3oool0h=oS0180h=oS0P00000>0>3Oh`030:F//P3oool0oooo
05<0oooo00D0YJbb0=SEeP0GCGh0_lO:0<K5e`0<000000040<K5e`2f_Kd0
5den0>_Zk@80h=oS00P0W9bN0?ooo`3Pgn<0h=oS0?7_hP1VIWh0Z:Vk0?_l
o@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT03L0oooo0P3oa:MP0?oo
o`050?_no`2Wk_l0K>?o08OXo`3[nol0:@3oool00`1oOgl0oooo0?ooo`0W
0?ooo`050?Omo`2Wk_l0K>?o09?Zo`3Wn_l0H@3oool00`3od[/0okB?0?oo
o`0f0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<00`2LW9h0oooo
0>3Oh`0A0>3Oh`040000003Pgn<0h=oS000000d0h=oS00<0YJbb0?ooo`3o
ool0D`3oool0102U[;80fMGE000lM03oool60<g<g`8000001P3=c=l00`3o
ool003ad0>SWjP020>3Oh`0809bLWP3oool0h=oS0>3Oh`3akn80IVIn0:RY
^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I00f0?ooo`030?oO
c`3oZ7`0oooo05h0oooo00@0mogo09O[o`1ThOl0^o;o;03oool00`1oOgl0
oooo0?ooo`0Z0?ooo`050=?go`1oi_l0J>;o0;_bo`3ko_l0G`3oool00`3o
/X/0om[70?ooo`0e0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<0
0`2LW9h0oooo0>3Oh`0<0>3Oh`060000003Pgn<0h=oS0000003Pgn<00000
0P3Pgn<00`000000h=oS0>3Oh`0;0>3Oh`030:F//P3oool0oooo05<0oooo
00@0YJbb0=WEe@00?7@0oooo1@3BdN@4000000D0d]7T00<0oooo000lM03W
i^T00P3Pgn<0202LW9h0oooo0>3Oh`3Pgn<0lNoR06IVOP2XZK/0nocm0@3o
ool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0=@3oool00`3oj]l0oie/0?ol
n`1M0?ooo`040>olo`27j?l0J>;o0<_eobh0oooo00<0Ogmo0?ooo`3oool0
;03oool01@3goOl0Ynko06CQo`2Kk?l0noko05h0oooo00<0oiYX0?oRd`3o
ool0=03oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00<0W9bN0?oo
o`3Pgn<03@3Pgn<01@000000h=oS0000003Pgn<000000080h=oS00<00000
0>3Oh`3Pgn<02`3Pgn<00`2U[;80oooo0?ooo`190?ooo`<000001`3oool0
102U[;80fMGE000lM03oool40=KGi`H00000103FenL00`3oool003ad0>OV
j@020>3Oh`0809bLWP3oool0h=oS0>3Oh`3akn80IVIn0:RY^`3ko?d10?oo
o`0000D0IVIn0?_lo@2XZK/0IVIn075_I00d0?ooo`030?ogl`3oUF00ooOc
05`0oooo00@0io[o07cVo`1`i?l0foSo<03oool00`1oOgl0oooo0?ooo`0_
0?ooo`040<Odo`1Xh_l0SnWo0??moe`0oooo00<0oo[g0?nJJ03ol^/0=03o
ool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00<0W9bN0?ooo`3Pgn<0
3P3Pgn<010000000h=oS0>3Oh`0000020>3Oh`030000003Pgn<0h=oS00/0
h=oS00<0YJbb0?ooo`3oool0B03oool01@000000oooo0?ooo`3oool00000
00H0oooo00@0YJbb0=WEe@00?7@0oooo0`3If^L8000000<0fM[W00<0oooo
000lM03Wi^T00P3Pgn<0202LW9h0oooo0>3Oh`3Pgn<0lNoR06IVOP2XZK/0
nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0<`3oool00`3oo?/0
oie/0?oZg`1K0?ooo`040=_ho`1`i?l0O>Ko0>?joc80oooo00<0Ogmo0?oo
o`3oool0<@3oool0103Cmol0L>Co08?Wo`3_o?mK0?ooo`030?odk`3oVVP0
oo[g03<0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0309bLWP3o
ool0h=oS00h0h=oS00@000000>3Oh`3Pgn<000000P3Pgn<00`000000h=oS
0>3Oh`0;0>3Oh`030:F//P3oool0oooo04P0oooo00D000000?ooo`3oool0
oooo000000060?ooo`040:F//P3IeMD003ad0?ooo`H0fM[W0P0000060=WJ
i`030?ooo`00?7@0inKY0080h=oS00P0W9bN0?ooo`3Pgn<0h=oS0?7_hP1V
IWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT03<0oooo
00<0oj9d0?oTe`3oool0F@3oool0103;mOl0K>?o08OXo`3_o?ld0?ooo`03
07moO`3oool0oooo03<0oooo00@0goWo07CTo`1di?l0ho[oFP3oool00`3o
i=L0ojQl0?ooo`0b0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<0
0`2LW9h0oooo0>3Oh`0>0>3Oh`8000000P3Pgn<2000000h0h=oS00<0YJbb
0?ooo`3oool0B03oool01@000000oooo0?ooo`3oool0000000H0oooo00@0
YJbb0=WEe@00?7@0oooo1P3SiO02000000H0hnG`00<0oooo000lM03Wi^T0
0P3Pgn<0202LW9h0oooo0>3Oh`3Pgn<0lNoR06IVOP2XZK/0nocm0@3oool0
000506IVOP3ko?d0Z:Vk06IVOP1aKf@0<P3oool00`3o^YL0olZ_0?ooo`1H
0?ooo`040;_bo`1ThOl0Un_o0??mocH0oooo00<0Ogmo0?ooo`3oool0=@3o
ool0103Wn_l0PnOo06cSo`3GmomI0?ooo`030?o:[`3o_il0oooo0340oooo
00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0309bLWP3oool0h=oS00d0
h=oS0P0000000`3Pgn<000000>3Oh`0@0>3Oh`030:F//P3oool0oooo04P0
oooo00D000000?ooo`3oool0oooo000000060?ooo`040:F//P3IeMD003ad
0?ooo`H0l?7l0P0000060?3ao0030?ooo`00?7@0inKY0080h=oS00P0W9bN
0?ooo`3Pgn<0h=oS0?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm
0:RY^`1VIWh0LFmT0340oooo00<0olZ_0?nlV`3oool0E`3oool01033lol0
H>3o0:O^o`3ko_lh0?ooo`0307moO`3oool0oooo03L0oooo00D0koco08oY
o`1/hol0_o?o0?_no`1G0?ooo`030?n_Q`3oel<0oooo0300oooo00D0lNoR
0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0309bLWP3oool0h=oS0280h=oS00<0
YJbb0?ooo`3oool0B03oool01@000000oooo0?ooo`3oool0000000H0oooo
00@0YJbb0=WEe@00?7@0oooo1P3fmod2000000H0m_Om00<0oooo000lM03W
i^T00P3Pgn<0202LW9h0oooo0>3Oh`3Pgn<0lNoR06IVOP2XZK/0nocm0@3o
ool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0<03oool00`3oi=L0ojEh0?oo
o`1F0?ooo`030?_no`1hiOl0SnWo03/0oooo00<0Ogmo0?ooo`3oool0>@3o
ool01@3goOl0Xngo063Po`2_l?l0noko05H0oooo00<0oie/0?oZg`3oool0
;`3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00<0W9bN0?ooo`3P
gn<08P3Pgn<00`2U[;80oooo0?ooo`180?ooo`050000003oool0oooo0?oo
o`0000001P3oool0102U[;80fMGE000lM03oool60?Slo@8000001P3ho?d0
0`3oool003ad0>OVj@020>3Oh`0809bLWP3oool0h=oS0>3Oh`3akn80IVIn
0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I00_0?ooo`03
0?o/h`3oVVP0oo[g05H0oooo00<0[o3o06cSo`3Sn_l0?03oool00`1oOgl0
oooo0?ooo`0k0?ooo`040?_no`2cl?l0I>7o0;OaoeD0oooo00<0oo[g0?nH
I03omo<0;`3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00<0W9bN
0?ooo`3Pgn<08P3Pgn<00`2U[;80oooo0?ooo`190?ooo`<000001`3oool0
102U[;80fMGE000lM03oool60?gmo@8000001P3moOd00`3oool003ad0>OV
j@020>3Oh`0809bLWP3oool0h=oS0>3Oh`3akn80IVIn0:RY^`3ko?d10?oo
o`0000D0IVIn0?_lo@2XZK/0IVIn075_I00_0?ooo`030?nEH03omo<0oooo
05@0oooo00<0jo_o06CQo`2[kol0?P3oool00`1oOgl0oooo0?ooo`0n0?oo
o`0309O[o`1oi_l0koco05@0oooo00<0on;C0?njU`3oool0;P3oool01@3a
kn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00<0W9bN0?ooo`3Pgn<08P3Pgn<0
0`2U[;80oooo0?ooo`1C0?ooo`040:F//P3IeMD003ad0?ooo`H0oOgm0P00
00060?gmo@030?ooo`00?7@0i^KY0080h=oS00P0W9bN0?ooo`3Pgn<0h=oS
0?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT
02h0oooo00<0olBW0?oB^`3oool0D`3oool0103ko_l0Tn[o08oYo`3_o?lo
0?ooo`0307moO`3oool0oooo03l0oooo00<0goWo063Po`2cl?l0E03oool0
0`3oWF`0onOK0?ooo`0]0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3P
gn<00`2LW9h0oooo0>3Oh`0R0>3Oh`030:F//P3oool0oooo05<0oooo00@0
YJbb0=SDe000?7@0oooo1P3moOd2000000H0oOgm00<0oooo000lM03UiNP0
0P3Pgn<0202LW9h0oooo0>3Oh`3Pgn<0lNoR06IVOP2XZK/0nocm0@3oool0
000506IVOP3ko?d0Z:Vk06IVOP1aKf@0;@3oool00`3on_L0oie/0?ooo`1C
0?ooo`030;Oao`1Lh?l0eoOo0440oooo00<0Ogmo0?ooo`3oool0@@3oool0
0`2[kol0L>Co0>?jo`1B0?ooo`030?odk`3oWF`0oooo02d0oooo00D0lNoR
0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0309bLWP3oool0h=oS0280h=oS00<0
YJbb0?ooo`3oool0D`3oool0102U[;80fMGE02EGQ@2oc]`60?ooo`800000
1P3oool00`2oc]/09EN50>7Qi0020>3Oh`0809bLWP3oool0h=oS0>3Oh`3a
kn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I00]
0?ooo`030?ndS`3oj]l0oooo0540oooo00@0goWo063Po`2Gjol0noko@P3o
ool00`1oOgl0oooo0?ooo`120?ooo`040>_ko`1ThOl0Un_o0?_noe40oooo
00<0olZ_0?o?]`3oool0;03oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080
h=oS00<0W9bN0?ooo`3Pgn<08P3Pgn<00`2U[;80oooo0?ooo`1C0?ooo`05
0:F//P3IeMD0NIBY05EmXP30cmd01@3oool2000000D0oooo00@0eMoX05Em
XP1iUJ/0gmgP0P3Pgn<0202LW9h0oooo0>3Oh`3Pgn<0lNoR06IVOP2XZK/0
nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0;03oool00`3oknL0
ojYo0?ooo`1A0?ooo`0309O[o`1li_l0koco04@0oooo00<0Ogmo0?ooo`3o
ool0A03oool00`2_l?l0H>3o0>Ojo`1A0?ooo`030?nJJ03on_L0oooo02/0
oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0309bLWP3oool0h=oS
0280h=oS00<0YJbb0?ooo`3oool0D`3oool01@2U[;80f]OI0=oLf01iU:T0
9EN500`003ad00@05den06J6X@3Pg]X0g=_M0P3Pgn<0202LW9h0oooo0>3O
h`3Pgn<0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IV
OP1aKf@0;03oool00`3oZWl0ooOc0?ooo`1?0?ooo`030=oio`1Ph?l0boGo
04H0oooo00<0Ogmo0?ooo`3oool0A@3oool0103coOl0OnKo0:__o`3ko_m?
0?ooo`030?oTe`3oZWl0oooo02/0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_
I0020>3Oh`0309bLWP3oool0h=oS0280h=oSE`2U[;800`3OgN00f]OI0=SD
e0070=OCe0<0dlk<0`3Gdm@0103He=@0fMGE0=[Gf@3OgN020>3Oh`0809bL
WP3oool0h=oS0>3Oh`3akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_l
o@2XZK/0IVIn075_I00[0?ooo`030?oOc`3oaj/0oooo04l0oooo00<0/o3o
07SUo`3coOl0A`3oool00`1oOgl0oooo0?ooo`170?ooo`030;oco`1ThOl0
foSo04l0oooo00<0ojYo0?oTe`3oool0:P3oool01@3akn80h=oS0>3Oh`3P
gn<0LFmT0080h=oS00<0W9bN0?ooo`3Pgn<0S`3Pgn<0202LW9h0oooo0>3O
h`3Pgn<0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IV
OP1aKf@0:`3oool00`3oZ7`0oock0?ooo`1>0?ooo`0307cVo`2Gjol0oooo
04P0oooo00<0Ogmo0?ooo`3oool0B03oool0103coOl0PnOo08oYo`3goOm=
0?ooo`030?odk`3oWF`0oooo02X0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_
I0020>3Oh`0309bLWP3oool0h=oS08l0h=oS00P0W9bN0?ooo`3Pgn<0h=oS
0?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT
02X0oooo0P3oe;m>0?ooo`030>Ojo`1Lh?l0_o?o04X0oooo00<0Ogmo0?oo
o`3oool0BP3oool00`3?m_l0N>Go0??mo`1=0?ooo`030?o7Z`3oa:L0oooo
02T0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0309bLWP3oool0
h=oS08l0h=oS00P0W9bN0?ooo`3Pgn<0h=oS0?7_hP1VIWh0Z:Vk0?_lo@40
oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT02T0oooo00<0oock0?n/P`3o
ool0C@3oool00`37m?l0N>Go0>olo`1;0?ooo`0307moO`3oool0oooo04/0
oooo00<0mogo07oVo`3Wn_l0C@3oool00`3oXW@0ooOc0?ooo`0X0?ooo`05
0?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<00`2LW9h0oooo0>3Oh`2?0>3O
h`0809bLWP3oool0h=oS0>3Oh`3akn80IVIn0:RY^`3ko?d10?ooo`0000D0
IVIn0?_lo@2XZK/0IVIn075_I00Y0?ooo`030?njU`3oim/0oooo04`0oooo
00<0SnWo09o]o`3oool0C03oool00`1oOgl0oooo0?ooo`1=0?ooo`0307oV
o`3Kn?l0oooo04/0oooo00<0oncS0?nUN03oool0:03oool01@3akn80h=oS
0>3Oh`3Pgn<0LFmT0080h=oS00<0W9bN0?ooo`3Pgn<08P3Pgn=[0:F//P80
h=oS00P0W9bN0?ooo`3Pgn<0h=oS0?7_hP1VIWh0Z:Vk0?_lo@40oooo0000
1@1VIWh0nocm0:RY^`1VIWh0LFmT02P0oooo00<0oo[g0?n_Q`3oool0B`3o
ool00`3coOl0L>Co0;_bo`1>0?ooo`0307moO`3oool0oooo04h0oooo00<0
O>Ko0<_eo`3oool0B`3oool00`3o/X/0omo?0?ooo`0W0?ooo`050?7_hP3P
gn<0h=oS0>3Oh`1aKf@00P3Pgn<00`2LW9h0oooo0>3Oh`0R0>3Oh`030:F/
/P3oool0oooo06L0oooo00D0YJbb0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`04
0?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT
02P0oooo00<0ojn70?odk`3oool0BP3oool00`3Cmol0J>;o0>Ojo`1?0?oo
o`0307moO`3oool0oooo04l0oooo00<0QnSo0;Oao`3oool0B`3oool00`3o
XW@0oock0?ooo`0V0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<0
0`2LW9h0oooo0>3Oh`030>3Oh`8000007@3Pgn<00`2U[;80oooo0?ooo`1W
0?ooo`050:F//P3Pgn<0h=oS09bLWP3oool00P3Pgn<0103akn80IVIn0:RY
^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I00W0?ooo`030?oW
f`3o]8l0oooo04X0oooo00<0Wngo08OXo`3oool0D03oool00`1oOgl0oooo
0?ooo`1@0?ooo`0308oYo`2glOl0oooo04X0oooo00<0om[70?njU`3oool0
9P3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00<0W9bN0?ooo`3P
gn<00`3Pgn<00`000000h=oS0000000:0>3Oh`030000003Pgn<0h=oS00@0
h=oS0P0000030>3Oh`030000003Pgn<0h=oS00<0h=oS00<0YJbb0?ooo`3o
ool0I`3oool01@2U[;80h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IV
OP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@09`3oool0
0`3oXW@0ooOc0?ooo`180?ooo`030?_no`1`i?l0Xngo0580oooo00<0Ogmo
0?ooo`3oool0D@3oool20:O^od/0oooo00<0ojb30?o_i`3oool09@3oool0
1@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00<0W9bN0?ooo`3Pgn<01@3P
gn<00`000000h=oS0>3Oh`070>3Oh`030000003Pgn<0h=oS00@0h=oS00@0
00000>3Oh`3Pgn<000000`3Pgn<00`000000h=oS0>3Oh`020>3Oh`030:F/
/P3oool0oooo06L0oooo00D0YJbb0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`04
0?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT
02H0oooo00<0olng0?o</`3oool0B03oool00`3goOl0M>Co0=oio`1C0?oo
o`0307moO`3oool0oooo0580oooo00<0]o7o09?Zo`3oool0B@3oool00`3o
o?/0ojYo0?ooo`0U0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<0
0`2LW9h0oooo0>3Oh`060>3Oh`030000003Pgn<0h=oS00D0h=oS00@00000
0>3Oh`3Pgn<000000P3Pgn<00`000000h=oS000000020>3Oh`030000003P
gn<0h=oS0080h=oS00D000000>3Oh`3Pgn<0h=oS0:F//P1Y0?ooo`050:F/
/P3Pgn<0h=oS09bLWP3oool00P3Pgn<0103akn80IVIn0:RY^`3ko?d10?oo
o`0000D0IVIn0?_lo@2XZK/0IVIn075_I00U0?ooo`030?oln`3oX700oooo
04P0oooo00<0mogo08_Yo`3goOl0E03oool00`1oOgl0oooo0?ooo`1C0?oo
o`030<ofo`2?jOl0oooo04T0oooo00<0olZ_0?oB^`3oool0903oool01@3a
kn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00<0W9bN0?ooo`3Pgn<01P3Pgn<2
000000H0h=oS00T000000>3Oh`3Pgn<0h=oS0000003Pgn<000000>3Oh`00
00000P3Pgn<00`000000h=oS0>3Oh`020>3Oh`050000003Pgn<0h=oS0>3O
h`2U[;80BP3oool3000000<0oooo00<000000?ooo`3oool00`0000030?oo
o`<000000`3oool3000000L0oooo00D0YJbb0>3Oh`3Pgn<0W9bN0?ooo`02
0>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1V
IWh0LFmT02D0oooo00<0okZG0?oTe`3oool0A`3oool00`3coOl0N>Go0>ol
o`1E0?ooo`0307moO`3oool0oooo05@0oooo00<0goWo09?Zo`3ko_l0B@3o
ool00`3oX700oo[g0?ooo`0S0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@0
0P3Pgn<00`2LW9h0oooo0>3Oh`060>3Oh`030000003Pgn<0000000D0h=oS
00<000000>3Oh`3Pgn<00P3Pgn<010000000h=oS0>3Oh`0000020>3Oh`03
0000003Pgn<0h=oS0080h=oS00D000000>3Oh`3Pgn<0h=oS0:F//P190?oo
o`050000003oool0oooo0?ooo`000000103oool01`000000oooo0?ooo`3o
ool000000?ooo`0000000`3oool00`000000oooo000000030?ooo`030000
003oool0oooo00@0oooo00D0YJbb0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`04
0?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT
02@0oooo00<0ooOc0?nXO03oool0A`3oool00`3ko_l0RnWo0?Omo`1F0?oo
o`0307moO`3oool0oooo05D0oooo00<0goWo07oVo`3goOl0B03oool00`3o
knL0okB?0?ooo`0S0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<0
0`2LW9h0oooo0>3Oh`060>3Oh`030000003Pgn<0000000D0h=oS00<00000
0>3Oh`3Pgn<00P3Pgn<010000000h=oS0>3Oh`0000020>3Oh`030000003P
gn<0h=oS0080h=oS00D000000>3Oh`3Pgn<0h=oS0:F//P190?ooo`050000
003oool0oooo0?ooo`000000103oool01`000000oooo0?ooo`3oool00000
0?ooo`0000000`3oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo00@0oooo00D0YJbb0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`040?7_hP1V
IWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT02@0oooo
00<0ojQl0?oWf`3oool0AP3oool00`3goOl0OnKo0?Omo`1G0?ooo`0307mo
O`3oool0oooo05H0oooo00<0logo09O[o`3coOl0B03oool00`3o]8l0onOK
0?ooo`0R0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<00`2LW9h0
oooo0>3Oh`060>3Oh`030000003Pgn<0000000D0h=oS00<000000>3Oh`3P
gn<00P3Pgn<200000080h=oS0P0000050>3Oh`050000003Pgn<0h=oS0>3O
h`2U[;80B@3oool01@000000oooo0?ooo`3oool0000000@0oooo00L00000
0?ooo`3oool0oooo0000003oool0000000<0oooo00<000000?ooo`3oool0
0`3oool00`000000oooo0?ooo`040?ooo`050:F//P3Pgn<0h=oS09bLWP3o
ool00P3Pgn<0103akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2X
ZK/0IVIn075_I00S0?ooo`030?oWf`3oZWl0oooo04H0oooo00<0logo07SU
o`3_o?l0F03oool00`1oOgl0oooo0?ooo`1G0?ooo`030??mo`1di?l0logo
04L0oooo00<0oock0?nUN03oool08P3oool01@3akn80h=oS0>3Oh`3Pgn<0
LFmT0080h=oS00<0W9bN0?ooo`3Pgn<01@3Pgn<2000000030>3Oh`000000
h=oS00@0h=oS00@000000>3Oh`3Pgn<0h=oS0P0000000`3Pgn<000000>3O
h`070>3Oh`050000003Pgn<0h=oS0>3Oh`2U[;80B@3oool01@000000oooo
0?ooo`3oool0000000@0oooo00D000000?ooo`3oool0oooo000000020?oo
o`<000000P3oool4000000L0oooo00D0YJbb0>3Oh`3Pgn<0W9bN0?ooo`02
0>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1V
IWh0LFmT02<0oooo00<0oj9d0?ogl`3oool0A@3oool00`3_o?l0I>7o0>_k
o`1I0?ooo`0307moO`3oool0oooo05P0oooo00<0ho[o073To`3ko_l0A`3o
ool00`3of/L0olBW0?ooo`0Q0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@0
0P3Pgn<00`2LW9h0oooo0>3Oh`0:0>3Oh`050000003Pgn<0h=oS0>3Oh`00
00003`3Pgn<01@000000h=oS0>3Oh`3Pgn<0YJbb04T0oooo00D000000?oo
o`3oool0oooo000000040?ooo`070000003oool0oooo0?ooo`000000oooo
000000030?ooo`030000003oool0000000X0oooo00D0YJbb0>3Oh`3Pgn<0
W9bN0?ooo`020>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0
nocm0:RY^`1VIWh0LFmT0280oooo00<0olng0?noW`3oool0A@3oool00`3_
o?l0L>Co0>_ko`1J0?ooo`0307moO`3oool0oooo05T0oooo00<0coKo073T
o`3ko_l0A`3oool00`3oZWl0ooC_0?ooo`0P0?ooo`050?7_hP3Pgn<0h=oS
0>3Oh`1aKf@00P3Pgn<00`2LW9h0oooo0>3Oh`0:0>3Oh`030000003Pgn<0
h=oS0080h=oS00<000000>3Oh`3Pgn<02`3Pgn<00`000000h=oS0>3Oh`02
0>3Oh`030:F//P3oool0oooo04L0oooo00D000000?ooo`3oool0oooo0000
00040?ooo`070000003oool0oooo0?ooo`000000oooo000000030?ooo`04
0000003oool0oooo000000T0oooo00D0YJbb0>3Oh`3Pgn<0W9bN0?ooo`02
0>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1V
IWh0LFmT0280oooo00<0oiQT0?oln`3oool0A03oool00`3_o?l0M>Co0?Om
o`1K0?ooo`0307moO`3oool0oooo05X0oooo00<0Znoo09?Zo`3oool0AP3o
ool00`3om>l0oj1`0?ooo`0P0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@0
0P3Pgn<00`2LW9h0oooo0>3Oh`0;0>3Oh`030000003Pgn<0h=oS0080h=oS
00<000000>3Oh`3Pgn<02@3Pgn<00`000000h=oS0>3Oh`030>3Oh`030:F/
/P3oool0oooo04P0oooo0`0000060?ooo`<000000`3oool3000000<0oooo
100000060?ooo`050:F//P3Pgn<0h=oS09bLWP3oool00P3Pgn<0103akn80
IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I00Q0?oo
o`030?o</`3oaj/0oooo04@0oooo00<0logo06CQo`3[nol0G03oool00`1o
Ogl0oooo0?ooo`1K0?ooo`0308_Yo`2glOl0oooo04H0oooo00<0oknO0?oG
``3oool07`3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00<0W9bN
0?ooo`3Pgn<02`3Pgn<00`000000h=oS0>3Oh`0D0>3Oh`030:F//P3oool0
oooo06L0oooo00D0YJbb0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`040?7_hP1V
IWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT0240oooo
00<0oi9L0?oln`3oool0@`3oool00`3goOl0M>Co0>_ko`1;0?ooo`080;no
_`0l?3`0?3`l06ATI03clo<0oooo03`l?037alL30?ooo`030<O7a`1dM7@0
oooo00@0oooo00<0Ogmo0?ooo`3oool0G03oool00`1hiOl0doOo0?ooo`16
0?ooo`030?nMK03oool0oooo01h0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_
I0020>3Oh`0309bLWP3oool0h=oS0280h=oS00<0YJbb0?ooo`3oool0I`3o
ool01@2U[;80h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0
nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0803oool00`3oi=L0
ojb30?ooo`130?ooo`030?_no`1di?l0koco04/0oooo00T0lo?c01`L703S
hn<0oooo04Q8B02GUiL0oooo0<O7a`3_knl00`3oool00`2o_kl0H61P0?oo
o`040?ooo`0307moO`3oool0oooo05`0oooo00<0noko063Po`3Sn_l0AP3o
ool00`3o]i<0omo?0?ooo`0N0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@0
0P3Pgn<00`2LW9h0oooo0>3Oh`0R0>3Oh`030:F//P3oool0oooo06L0oooo
00D0YJbb0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`040?7_hP1VIWh0Z:Vk0?_l
o@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT0200oooo00<0oj1`0?od
k`3oool0@`3oool00`1li_l0coKo0?ooo`170?ooo`060;no_`1oOgl0Ogmo
0;no_`33`l<0>3Ph0P3oool00`2KVi/0D51@0?ooo`020?ooo`0604A4A00D
51@0820P01PH600<30`0F5QH103oool00`1oOgl0oooo0?ooo`1M0?ooo`03
0>olo`1Ph?l0mogo04D0oooo00<0ooOc0?nRM03oool07P3oool01@3akn80
h=oS0>3Oh`3Pgn<0LFmT0080h=oS00<0W9bN0?ooo`3Pgn<08P3Pgn<00`2U
[;80oooo0?ooo`1W0?ooo`050:F//P3Pgn<0h=oS09bLWP3oool00P3Pgn<0
103akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_
I00O0?ooo`030?o_i`3o[hL0oooo04<0oooo00<0]o7o09o]o`3oool0B03o
ool01P2o_kl0Ogmo07moO`2o_kl0WinO05aLG080oooo00<0_kno0410@03o
ool00P3oool01@2k^k/0C4a<0?_kn`2o_kl0H61P00D0oooo00<0Ogmo0?oo
o`3oool0GP3oool00`3Kn?l0J>;o0?_no`150?ooo`030?nJJ03omo<0oooo
01d0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0309bLWP3oool0
h=oS0280h=oS00<0YJbb0?ooo`3oool0I`3oool01@2U[;80h=oS0>3Oh`2L
W9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3k
o?d0Z:Vk06IVOP1aKf@07`3oool00`3oYGP0oo;[0?ooo`120?ooo`030=oi
o`1`i?l0oooo04d0oooo00H0Xj>S05aLG03oool0oooo0;no_`10@4040?oo
o`04071`L02?Shl0_kno061PH0D0oooo00<0Ogmo0?ooo`3oool0G`3oool0
0`2kl_l0QnSo0?ooo`140?ooo`030?oLb`3o_il0oooo01d0oooo00D0lNoR
0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0309bLWP3oool0h=oS0280h=oSJ`2U
[;820>3Oh`0809bLWP3oool0h=oS0>3Oh`3akn80IVIn0:RY^`3ko?d10?oo
o`0000D0IVIn0?_lo@2XZK/0IVIn075_I00N0?ooo`030?o_i`3oWF`0oooo
0480oooo00<0noko06CQo`3coOl0CP3oool01P33`l<0>3Ph0?ooo`3oool0
WinO05QHF0@0oooo00@0no_k03`l?02KVi/0H61P0`3oool01@2OWil0Ogmo
03lo?`1oOgl0WinO0600oooo0P2SkOm50?ooo`030?nBG03oool0oooo01`0
oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0309bLWP3oool0h=oS
08l0h=oS00P0W9bN0?ooo`3Pgn<0h=oS0?7_hP1VIWh0Z:Vk0?_lo@40oooo
00001@1VIWh0nocm0:RY^`1VIWh0LFmT01h0oooo00<0ok:;0?oWf`3oool0
@P3oool00`1li_l0doOo0?ooo`1>0?ooo`060??cl`0L71`0hn?S0?ooo`1H
F5P0UiNG1@3oool00`37alL061PH061PH0050?ooo`0307moO`3oool0oooo
0640oooo00<0M>Co0<?co`3oool0@`3oool00`3o]8l0on;C0?ooo`0L0?oo
o`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<00`2LW9h0oooo0>3Oh`2?
0>3Oh`0809bLWP3oool0h=oS0>3Oh`3akn80IVIn0:RY^`3ko?d10?ooo`00
00D0IVIn0?_lo@2XZK/0IVIn075_I00M0?ooo`030?oln`3oXW@0oooo0480
oooo00<0[o3o09o]o`3oool0D03oool01@2SXj<0=3@d0410@01TI6@0no_k
00H0oooo00<0Ogmo061PH03oool0103oool00`1oOgl0oooo0?ooo`1R0?oo
o`0306cSo`3OnOl0oooo0480oooo00<0ooC_0?nUN03oool0703oool01@3a
kn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00<0W9bN0?ooo`3Pgn<0S`3Pgn<0
202LW9h0oooo0>3Oh`3Pgn<0lNoR06IVOP2XZK/0nocm0@3oool0000506IV
OP3ko?d0Z:Vk06IVOP1aKf@07@3oool00`3o_il0omBo0?ooo`110?ooo`03
0=oio`1di?l0oooo06<0oooo00<0Ogmo0?ooo`3oool0HP3oool00`3goOl0
H>3o0??mo`130?ooo`030?nPL03on_L0oooo01/0oooo00D0lNoR0>3Oh`3P
gn<0h=oS075_I0020>3Oh`0309bLWP3oool0h=oS08l0h=oS00P0W9bN0?oo
o`3Pgn<0h=oS0?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY
^`1VIWh0LFmT01d0oooo00<0oheD0?oln`3oool0@03oool00`3ko_l0H>3o
0??mo`1T0?ooo`0307moO`3oool0oooo06<0oooo00<0goWo08_Yo`3oool0
@P3oool00`3oe;l0olBW0?ooo`0K0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1a
Kf@00P3Pgn<00`2LW9h0oooo0>3Oh`0R0>3Ohf/0YJbb0P3Pgn<0202LW9h0
oooo0>3Oh`3Pgn<0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0
Z:Vk06IVOP1aKf@0703oool00`3obZl0olN[0?ooo`110?ooo`0307cVo`3C
mol0oooo06@0oooo00<0Ogmo0?ooo`3oool0I03oool00`2?jOl0aoCo0?oo
o`120?ooo`030?nBG03oool0oooo01X0oooo00D0lNoR0>3Oh`3Pgn<0h=oS
075_I0020>3Oh`0309bLWP3oool0h=oS0280h=oS00<0YJbb0?ooo`3oool0
I`3oool01@2U[;80h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IVOP2X
ZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0703oool00`3o
V6@0oock0?ooo`100?ooo`030:o`o`2OkOl0oooo06D0oooo00<0Ogmo0?oo
o`3oool0I03oool00`3ko_l0K>?o0?Omo`120?ooo`030?n/P`3oh]<0oooo
01X0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0309bLWP3oool0
h=oS00@0h=oS0P00000L0>3Oh`030:F//P3oool0oooo06L0oooo00D0YJbb
0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo
00001@1VIWh0nocm0:RY^`1VIWh0LFmT01/0oooo00<0omo?0?njU`3oool0
@03oool00`3Wn_l0L>Co0?ooo`1V0?ooo`0307moO`3oool0oooo06D0oooo
00<0goWo08oYo`3oool0@@3oool00`3ol^/0ojYo0?ooo`0J0?ooo`050?7_
hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<00`2LW9h0oooo0>3Oh`040>3Oh`03
0000003Pgn<0000000L0h=oS00<000000>3Oh`3Pgn<0103Pgn<200000080
h=oS00<000000>3Oh`3Pgn<01P3Pgn<00`2U[;80oooo0?ooo`1W0?ooo`05
0:F//P3Pgn<0h=oS09bLWP3oool00P3Pgn<0103akn80IVIn0:RY^`3ko?d1
0?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I00K0?ooo`030?nPL03om>l0
oooo0400oooo00<0H>3o0??mo`3oool0IP3oool00`1oOgl0oooo0?ooo`1V
0?ooo`0309o]o`3;mOl0oooo0440oooo00<0oiQT0?ojm`3oool06@3oool0
1@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00<0W9bN0?ooo`3Pgn<01P3P
gn<00`000000h=oS0>3Oh`040>3Oh`030000003Pgn<0h=oS00@0h=oS00@0
00000>3Oh`3Pgn<000000P3Pgn<00`000000h=oS0>3Oh`050>3Oh`030:F/
/P3oool0oooo06L0oooo00D0YJbb0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`04
0?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT
01X0oooo00<0onOK0?n/P`3oool0@03oool00`2[kol0^o;o0?ooo`1W0?oo
o`0307moO`3oool0oooo06L0oooo00<0L>Co0?Omo`3oool0@03oool00`3o
c;<0olN[0?ooo`0I0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<0
0`2LW9h0oooo0>3Oh`070>3Oh`030000003Pgn<0h=oS0080h=oS00@00000
0>3Oh`3Pgn<000000P3Pgn<00`000000h=oS000000020>3Oh`050000003P
gn<0h=oS0>3Oh`0000001P3Pgn<00`2U[;80oooo0?ooo`1W0?ooo`050:F/
/P3Pgn<0h=oS09bLWP3oool00P3Pgn<0103akn80IVIn0:RY^`3ko?d10?oo
o`0000D0IVIn0?_lo@2XZK/0IVIn075_I00J0?ooo`030?nPL03om>l0oooo
03l0oooo00<0noko06cSo`3oool0J03oool00`1oOgl0oooo0?ooo`1W0?oo
o`030=oio`2?jOl0oooo0400oooo00<0oock0?nJJ03oool06@3oool01@3a
kn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00<0W9bN0?ooo`3Pgn<01`3Pgn<2
000000<0h=oS00T000000>3Oh`3Pgn<0h=oS0000003Pgn<000000>3Oh`00
00000P3Pgn<01@000000h=oS0>3Oh`3Pgn<0000000H0h=oS00<0YJbb0?oo
o`3oool0B03oool3000000<0oooo00D000000?ooo`3oool0oooo00000004
0?ooo`<000000`3oool3000000L0oooo00D0YJbb0>3Oh`3Pgn<0W9bN0?oo
o`020>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY
^`1VIWh0LFmT01T0oooo00<0onoW0?nUN03oool0@03oool00`2?jOl0foSo
0?ooo`1X0?ooo`0307moO`3oool0oooo06P0oooo00<0Ynko0=Ogo`3oool0
@03oool00`3oX700oncS0?ooo`0H0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1a
Kf@00P3Pgn<00`2LW9h0oooo0>3Oh`070>3Oh`030000003Pgn<000000080
h=oS00<000000>3Oh`3Pgn<00P3Pgn<010000000h=oS0>3Oh`0000020>3O
h`050000003Pgn<0h=oS0>3Oh`0000001P3Pgn<00`2U[;80oooo0?ooo`17
0?ooo`050000003oool0oooo0?ooo`0000001P3oool01@000000oooo0?oo
o`3oool0000000<0oooo00<000000?ooo`0000000`3oool00`000000oooo
0?ooo`040?ooo`050:F//P3Pgn<0h=oS09bLWP3oool00P3Pgn<0103akn80
IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I00I0?oo
o`030?nZO`3oj]l0oooo03l0oooo00<0io[o09?Zo`3oool0J@3oool00`1o
Ogl0oooo0?ooo`1Y0?ooo`0307CTo`3ko_l0oooo03l0oooo00<0onOK0?n/
P`3oool0603oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00<0W9bN
0?ooo`3Pgn<01`3Pgn<00`000000h=oS000000020>3Oh`030000003Pgn<0
h=oS0080h=oS00@000000>3Oh`3Pgn<000000P3Pgn<01@000000h=oS0>3O
h`3Pgn<0000000H0h=oS00<0YJbb0?ooo`3oool0A`3oool01@000000oooo
0?ooo`3oool0000000H0oooo00D000000?ooo`3oool0oooo000000030?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`3oool0103oool01@2U
[;80h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0nocm0@3o
ool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0603oool00`3on_L0oiYX0?oo
o`100?ooo`0307oVo`3coOl0oooo06T0oooo00<0Ogmo0?ooo`3oool0J@3o
ool00`3Wn_l0Vnco0?ooo`100?ooo`030?nEH03oo?/0oooo01L0oooo00D0
lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0309bLWP3oool0h=oS00L0h=oS
00<000000>3Oh`0000000P3Pgn<00`000000h=oS0>3Oh`020>3Oh`800000
0P3Pgn<2000000@0h=oS00<000000>3Oh`3Pgn<0103Pgn<00`2U[;80oooo
0?ooo`170?ooo`050000003oool0oooo0?ooo`0000001P3oool01@000000
oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool00`3oool00`00
0000oooo0?ooo`040?ooo`050:F//P3Pgn<0h=oS09bLWP3oool00P3Pgn<0
103akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_
I00H0?ooo`030?ngT`3ogll0oooo03l0oooo00<0doOo0:?]o`3oool0H@3o
ool0103gooL0dooE0:oo/`27ohd507ooQ@0703noA@1oohD0Oon507ooQ@2C
oiP0]onj0>Ooj01V0?ooo`0309_/o`3Gmol0oooo03l0oooo00<0oknO0?o<
/`3oool05`3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00<0W9bN
0?ooo`3Pgn<01P3Pgn<2000000050>3Oh`000000h=oS0>3Oh`0000000`3P
gn<2000000030>3Oh`000000h=oS00H0h=oS00<000000>3Oh`3Pgn<0103P
gn<00`2U[;80oooo0?ooo`170?ooo`050000003oool0oooo0?ooo`000000
1P3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`00
00000`0000070?ooo`050:F//P3Pgn<0h=oS09bLWP3oool00P3Pgn<0103a
kn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I00G
0?ooo`030?oln`3oV6@0oooo0400oooo00<0O>Ko0?_no`3oool0G@3oool0
203Oon40Ron@07CoN`1oohD0Qon=0:_o[`3?om40moog1@3oool02@1oOgl0
oooo0?ooo`3oool0joo/0<?oaP2Goi`0Oon508?oR@0407ooQ@0307SoOP3_
oo00oooo05h0oooo00<0N>Go0?Omo`3oool0?P3oool00`3on_L0oj1`0?oo
o`0G0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<00`2LW9h0oooo
0>3Oh`0<0>3Oh`030000003Pgn<0h=oS00`0h=oS00<000000>3Oh`3Pgn<0
103Pgn<00`2U[;80oooo0?ooo`170?ooo`050000003oool0oooo0?ooo`00
0000103oool00`000000oooo000000030?ooo`070000003oool0oooo0?oo
o`000000oooo0000000:0?ooo`050:F//P3Pgn<0h=oS09bLWP3oool00P3P
gn<0103akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn
075_I00G0?ooo`030?o4Y`3oc;<0oooo03l0oooo00<0[o3o0<Odo`3oool0
F`3oool01@3Komd0UonL06coL`2Koj00hooT00/0oooo00<0Ogmo0?ooo`3o
ool02P3oool00`3coo@0WonT0?ooo`1N0?ooo`030=oio`2?jOl0oooo03l0
oooo00<0ojn70?o_i`3oool05P3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT
0080h=oS00<0W9bN0?ooo`3Pgn<03@3Pgn<00`000000h=oS0>3Oh`0:0>3O
h`030000003Pgn<0h=oS00D0h=oS00<0YJbb0?ooo`3oool0A`3oool01@00
0000oooo0?ooo`3oool0000000D0oooo0P0000030?ooo`050000003oool0
oooo0?ooo`0000000P3oool00`000000oooo0?ooo`070?ooo`050:F//P3P
gn<0h=oS09bLWP3oool00P3Pgn<0103akn80IVIn0:RY^`3ko?d10?ooo`00
00D0IVIn0?_lo@2XZK/0IVIn075_I00G0?ooo`030?nJJ03oo?/0oooo03h0
oooo00<0mogo07SUo`3oool0F@3oool01@3Oon40Ron@073oM`2Koj00gooQ
00h0oooo00<0Ogmo0?ooo`3oool0K03oool00`2;jOl0coKo0?ooo`0n0?oo
o`030?oWf`3o[8<0oooo01H0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I002
0>3Oh`0309bLWP3oool0h=oS00h0h=oS00<000000>3Oh`3Pgn<0203Pgn<0
0`000000h=oS0>3Oh`060>3Oh`030:F//P3oool0oooo04P0oooo0`000007
0?ooo`030000003oool0oooo0080oooo0`0000030?ooo`@000001P3oool0
1@2U[;80h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0nocm
0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@05P3oool00`3om>l0ojb3
0?ooo`0o0?ooo`0308oYo`3OnOl0oooo05H0oooo00D0gooQ08_oT01/og<0
Qon=0=ooh@0A0?ooo`0307moO`3oool0oooo06d0oooo00<0J>;o0?_no`3o
ool0?P3oool00`3oX700oock0?ooo`0E0?ooo`050?7_hP3Pgn<0h=oS0>3O
h`1aKf@00P3Pgn<00`2LW9h0oooo0>3Oh`0R0>3Oh`030:F//P3oool0oooo
06L0oooo00D0YJbb0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`040?7_hP1VIWh0
Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT01H0oooo00<0
olZ_0?oB^`3oool0?P3oool00`3Sn_l0QnSo0?ooo`1D0?ooo`050=ooh@2;
oi00K?mc08OoS@3Oon40503oool00`1oOgl0oooo0?ooo`1]0?ooo`030;?`
o`2_l?l0oooo03h0oooo00<0olN[0?oB^`3oool05@3oool01@3akn80h=oS
0>3Oh`3Pgn<0LFmT0080h=oS00<0W9bN0?ooo`3Pgn<08P3Pgn<00`2U[;80
oooo0?ooo`1W0?ooo`050:F//P3Pgn<0h=oS09bLWP3oool00P3Pgn<0103a
kn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I00F
0?ooo`030?nUN03oo?/0oooo03h0oooo00<0K>?o0>olo`3oool0D@3oool0
1@3Oon40Ron@06coL`27ohd0gooQ01L0oooo00<0Ogmo0?ooo`3oool0K@3o
ool00`3ko_l0H>3o0?_no`0n0?ooo`030?ogl`3oVVP0oooo01D0oooo00D0
lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0309bLWP3oool0h=oS0280h=oS
00<0YJbb0?ooo`3oool0I`3oool01@2U[;80h=oS0>3Oh`2LW9h0oooo0080
h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IV
OP1aKf@05P3oool00`3oXW@0oooo0?ooo`0m0?ooo`030<?co`2SkOl0oooo
0500oooo00@0`oo606CoJ`27ohd0gooQ6P3oool00`1oOgl0oooo0?ooo`1^
0?ooo`030:?]o`2olol0oooo03h0oooo00<0ojQl0?obj`3oool0503oool0
1@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00<0W9bN0?ooo`3Pgn<08P3P
gn<00`2U[;80oooo0?ooo`1W0?ooo`050:F//P3Pgn<0h=oS09bLWP3oool0
0P3Pgn<0103akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0
IVIn075_I00E0?ooo`030?oTe`3o]i<0oooo03h0oooo00<0I>7o0?_no`3o
ool0CP3oool00`3[on`0M?mk09ooY00M0?ooo`0307moO`3oool0oooo06h0
oooo00<0mogo06SRo`3oool0?P3oool00`3ogll0okZG0?ooo`0D0?ooo`05
0?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<00`2LW9h0oooo0>3Oh`0R0>3O
h`030:F//P3oool0oooo06L0oooo00D0YJbb0>3Oh`3Pgn<0W9bN0?ooo`02
0>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1V
IWh0LFmT01D0oooo00<0ojn70?o_i`3oool0?@3oool00`37m?l0Vnco0?oo
o`1>0?ooo`0309OoW01dog/0hooT01h0oooo00<0Ogmo0?ooo`3oool0K`3o
ool00`2?jOl0eoOo0?ooo`0n0?ooo`030?nPL03oool0oooo01<0oooo00D0
lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0309bLWP3oool0h=oS0280h=oS
J`2U[;820>3Oh`0809bLWP3oool0h=oS0>3Oh`3akn80IVIn0:RY^`3ko?d1
0?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I00E0?ooo`030?nPL03oool0
oooo03d0oooo00<0L>Co0?Omo`3oool0C03oool00`3Komd0I?m[0<_oc@0P
0?ooo`0307moO`3oool0oooo0240oooo00H0nook07SoOP0<oaL02?lD073o
M`3cooA80?ooo`030>olo`1/hol0oooo03h0oooo00<0ojb30?oln`3oool0
4`3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00<0W9bN0?ooo`3P
gn<0S`3Pgn<0202LW9h0oooo0>3Oh`3Pgn<0lNoR06IVOP2XZK/0nocm0@3o
ool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0503oool00`3on_L0ojb30?oo
o`0m0?ooo`030>Ojo`1li_l0oooo04`0oooo00<0Zon_07CoN`3coo@08@3o
ool00`1oOgl0oooo0?ooo`0Q0?ooo`0307SoOP00o``00?l<00800?l<00<0
L?mg0?ooo`3oool0A`3oool00`23iol0ho[o0?ooo`0m0?ooo`030?o</`3o
g</0oooo01<0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0309bL
WP3oool0h=oS08l0h=oS00P0W9bN0?ooo`3Pgn<0h=oS0?7_hP1VIWh0Z:Vk
0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT01@0oooo00<0olbc
0?oJa`3oool0?@3oool00`23iol0goWo0?ooo`1:0?ooo`030?_on`1hogh0
Yon[02<0oooo00<0Ogmo0?ooo`3oool08@3oool00`0<oaL00?l<003o3002
003o300300So503oool0oooo04L0oooo00<0io[o07CTo`3oool0?@3oool0
0`3ol^/0okNC0?ooo`0C0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3P
gn<00`2LW9h0oooo0>3Oh`2?0>3Oh`0809bLWP3oool0h=oS0>3Oh`3akn80
IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I00D0?oo
o`030?nXO03on_L0oooo03`0oooo00<0noko06cSo`3oool0BP3oool00`3K
omd0H?mW0=Oof@0T0?ooo`0307moO`3oool0oooo0240oooo00<03?lG003o
3000o``00P00o``00`08oa@0oooo0?ooo`180?ooo`0307CTo`3_o?l0oooo
03d0oooo00<0ojYo0?ooo`3oool04P3oool01@3akn80h=oS0>3Oh`3Pgn<0
LFmT0080h=oS00<0W9bN0?ooo`3Pgn<0S`3Pgn<0202LW9h0oooo0>3Oh`3P
gn<0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1a
Kf@0503oool00`3oYGP0oooo0?ooo`0l0?ooo`030:?]o`2olol0oooo04T0
oooo00<0Zon_07CoN`3coo@09@3oool00`1oOgl0oooo0?ooo`0Q0?ooo`03
07SoOP00o``00?l<00800?l<00<00ol>06OoKP3?om40B03oool00`3OnOl0
PnOo0?ooo`0m0?ooo`030?nZO`3oool0oooo0180oooo00D0lNoR0>3Oh`3P
gn<0h=oS075_I0020>3Oh`0309bLWP3oool0h=oS08l0h=oS00P0W9bN0?oo
o`3Pgn<0h=oS0?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY
^`1VIWh0LFmT01<0oooo00<0onoW0?ngT`3oool0?@3oool00`1Ph?l0oooo
0?ooo`170?ooo`030?_on`1hogh0Yon[02L0oooo00<0Ogmo0?ooo`3oool0
8@3oool01P3koo/0N?mn00co5`08oa@0E?mL00Co40800?l<00<0=?ln09Oo
W03_oo00AP3oool00`1`i?l0logo0?ooo`0l0?ooo`030?ngT`3ol^/0oooo
0180oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0309bLWP3oool0
h=oS08l0h=oS00P0W9bN0?ooo`3Pgn<0h=oS0?7_hP1VIWh0Z:Vk0?_lo@40
oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT01<0oooo00<0ol:S0?oRd`3o
ool0?03oool00`37m?l0Vnco0?ooo`170?ooo`030??om01Hof00eooI02P0
oooo00<0Ogmo0?ooo`3oool09P3oool00`1Lof@00?l<003o3002003o3003
00co5`1hogh0eooI04@0oooo00<0doOo08oYo`3oool0?03oool00`3of/L0
olng0?ooo`0B0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<00`2L
W9h0oooo0>3Oh`2?0>3Oh`0809bLWP3oool0h=oS0>3Oh`3akn80IVIn0:RY
^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I00C0?ooo`030?nR
M03oool0oooo03`0oooo00<0L>Co0?Omo`3oool0A`3oool00`1Xofl0hooT
0?ooo`0X0?ooo`0307moO`3oool0oooo02H0oooo00<0lood01co9`00o``0
1@00o``00`10odT0WonT0?Oom`120?ooo`0306SRo`3ko_l0oooo03/0oooo
00<0oo[g0?n_Q`3oool04P3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080
h=oS00<0W9bN0?ooo`3Pgn<0S`3Pgn<0202LW9h0oooo0>3Oh`3Pgn<0lNoR
06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@04`3o
ool00`3oYGP0oooo0?ooo`0k0?ooo`030>Ojo`1li_l0oooo04L0oooo00<0
O?n20<ood@3oool0:@3oool00`1oOgl0oooo0?ooo`0W0?ooo`030;_o_P04
oa000?l<00H00?l<00<05?lO073oM`3ComD0@03oool00`37m?l0Vnco0?oo
o`0l0?ooo`030?nZO`3oool0oooo0140oooo00D0lNoR0>3Oh`3Pgn<0h=oS
075_I0020>3Oh`0309bLWP3oool0h=oS00H0h=oS0`0000030>3Oh`<00000
0P3Pgn<01@000000h=oS0>3Oh`3Pgn<000000080h=oS0P0000001@3Pgn<0
00000>3Oh`000000h=oS0080000000@0h=oS0000003Pgn<0h=oS0`000002
0>3Oh`050000003Pgn<0h=oS0>3Oh`0000000P3Pgn<3000005/0h=oS00P0
W9bN0?ooo`3Pgn<0h=oS0?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0
nocm0:RY^`1VIWh0LFmT0180oooo00<0omO30?o:[`3oool0?03oool00`23
iol0goWo0?ooo`160?ooo`0309?oV02cokL0oooo02X0oooo00<0Ogmo0?oo
o`3oool0:03oool00`1hogh00?l<003o3004003o300500Co400hod40M?mk
0;oo`P3koo/0@03oool00`1ThOl0oooo0?ooo`0k0?ooo`030?nZO`3oool0
oooo0140oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0309bLWP3o
ool0h=oS00D0h=oS00L000000>3Oh`3Pgn<0h=oS0000003Pgn<0000000<0
h=oS00<000000>3Oh`0000000`3Pgn<00`000000h=oS000000020>3Oh`80
000000@0h=oS0000003Pgn<000000P3Pgn<00`000000h=oS000000030>3O
h`030000003Pgn<0000000<0h=oS00<000000>3Oh`0000000`3Pgn<00`00
0000h=oS0>3Oh`1H0>3Oh`0809bLWP3oool0h=oS0>3Oh`3akn80IVIn0:RY
^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I00B0?ooo`030?nZ
O`3on_L0oooo03/0oooo00<0noko06cSo`3oool0AP3oool00`2gokX0TonH
0?ooo`0[0?ooo`0307moO`3oool0oooo02P0oooo00<0lood023o:P00o``0
0P00o``00`18oe40[onc0??om0140?ooo`0308oYo`3Sn_l0oooo03/0oooo
00<0ojn70?ojm`3oool04@3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080
h=oS00<0W9bN0?ooo`3Pgn<0103Pgn<00`000000h=oS0>3Oh`040>3Oh`07
0000003Pgn<0h=oS0>3Oh`000000h=oS000000030>3Oh`030000003Pgn<0
000000<0h=oS00D000000>3Oh`000000h=oS000000020>3Oh`030000003P
gn<0000000<0h=oS00<000000>3Oh`0000000`3Pgn<00`000000h=oS0>3O
h`020>3Oh`030000003Pgn<0h=oS05T0h=oS00P0W9bN0?ooo`3Pgn<0h=oS
0?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT
0180oooo00<0ojYo0?ooo`3oool0>`3oool00`2SkOl0_o?o0?ooo`150?oo
o`030=?oe@1hogh0oooo02`0oooo00<0Ogmo0?ooo`3oool0:@3oool01P3?
om401?l@003o3000o``0B?mB0??om4D0oooo00<0coKo0:O^o`3oool0>`3o
ool00`3od[/0omO30?ooo`0A0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@0
0P3Pgn<00`2LW9h0oooo0?ooo`030?ooo`030>3Oh`000000h=oS00D0h=oS
00L000000>3Oh`3Pgn<0h=oS0000003Pgn<0000000<0h=oS00<000000>3O
h`0000000`3Pgn<01@000000h=oS0000003Pgn<000000080h=oS00<00000
0>3Oh`0000000`3Pgn<00`000000h=oS000000030>3Oh`030000003Pgn<0
h=oS00800000103Pgn=H0?ooo`0809bLWP3oool0h=oS0>3Oh`3akn80IVIn
0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I00A0?ooo`03
0?obj`3o]i<0oooo03`0oooo00<0J>;o0?ooo`3oool0A03oool00`3WonP0
I?m[0?_on`0]0?ooo`0307moO`3oool0oooo02X0oooo00D0L?mg003o3000
o``0U_nL07CoN`150?ooo`030?_no`1`i?l0oooo03/0oooo00<0ooC_0?nd
S`3oool04@3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS1P2LW9h0
0`3Pgn<000000>3Oh`050>3Oh`060000003Pgn<0h=oS0>3Oh`000000h=oS
0P0000020>3Oh`030000003Pgn<000000080h=oS0P000000103Pgn<00000
0>3Oh`0000020>3Oh`030000003Pgn<0000000<0h=oS00@000000>3Oh`00
000000000P3Pgn<00`000000h=oS000000030>3Oh`030000003Pgn<0h=oS
05T0W9bN00L0oooo0>3Oh`3Pgn<0lNoR06IVOP2XZK/0nocm0040oooo0000
1@1VIWh0nocm0:RY^`1VIWh0LFmT0140oooo00<0oknO0?oWf`3oool0>`3o
ool00`3goOl0N>Go0?ooo`140?ooo`030??om01Lof@0lood02h0oooo00<0
Ogmo0?ooo`3oool0:P3oool01P3koo/08?lZ003o302ool80Zon_0:?oYdD0
oooo00<0N>Go0?_no`3oool0>`3oool00`3oZWl0oooo0?ooo`0@0?ooo`05
0?7_hP3Pgn<0h=oS0>3Oh`1aKf@02@3Pgn<00`000000h=oS0>3Oh`050>3O
h`<000000P3Pgn<010000000h=oS0000000000030>3Oh`80000000<0h=oS
0000003Pgn<010000000103Pgn<000000>3Oh`3Pgn<300000080h=oS00@0
00000>3Oh`00000000000`3Pgn<3000005l0h=oS00@0lNoR06IVOP2XZK/0
nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@04@3oool00`3oZ7`0
oock0?ooo`0k0?ooo`030;?`o`2olol0oooo04@0oooo00<0J?m_0>?oi03o
ool0;P3oool00`1oOgl0oooo0?ooo`0[0?ooo`060<?oaP08oa@0_oo20?oo
o`1hogh0eooIA03oool00`2glOl0^o;o0?ooo`0k0?ooo`030?nZO`3oool0
oooo0100oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I00:0>3Oh`050000003P
gn<0h=oS0>3Oh`0000004@3Pgn<01@000000h=oS0>3Oh`3Pgn<0000007<0
h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IV
OP1aKf@04@3oool00`3oZWl0oooo0?ooo`0k0?ooo`0307oVo`3goOl0oooo
04<0oooo00<0O?n20<ood@3oool0;`3oool00`1oOgl0oooo0?ooo`0/0?oo
o`0607CoN`3ComD0oooo0?_on`1Tof/0lood@`3oool00`3ko_l0OnKo0?oo
o`0k0?ooo`030?njU`3oknL0oooo0100oooo00D0lNoR0>3Oh`3Pgn<0h=oS
075_I00;0>3Oh`<000004P3Pgn<01@000000h=oS0000003Pgn<000000080
h=oS00<000000>3Oh`3Pgn<0KP3Pgn<0103akn80IVIn0:RY^`3ko?d10?oo
o`0000D0IVIn0?_lo@2XZK/0IVIn075_I00@0?ooo`030?oJa`3ockL0oooo
03`0oooo00<0L>Co0?ooo`3oool0@P3oool00`2CoiP0/ong0?ooo`0`0?oo
o`0307moO`3oool0oooo02`0oooo0P3gooL20?ooo`030=_og@1dog/0oooo
04<0oooo00<0O>Ko0?ooo`3oool0>P3oool00`3oh]<0olN[0?ooo`0@0?oo
o`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@0V03Pgn<0103akn80IVIn0:RY^`3k
o?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I00@0?ooo`030?ndS`3o
l^/0oooo03/0oooo00<0koco08_Yo`3oool0@P3oool00`2gokX0TonH0?oo
o`0a0?ooo`0307moO`3oool0oooo0340oooo00<0Zon_0:?oY`3oool0@P3o
ool00`2?jOl0io[o0?ooo`0j0?ooo`030?oln`3o[8<0oooo0100oooo00D0
lNoR0>3Oh`3Pgn<0h=oS075_I02H0>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40
oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT0100oooo00<0ojEh0?ooo`3o
ool0>`3oool00`2_l?l0`o?o0?ooo`110?ooo`030=?oe@1hogh0oooo0380
oooo00<0Ogmo0?ooo`3oool0<P3oool00`1hogh0eooI0?ooo`110?ooo`03
0=oio`2Kk?l0oooo03/0oooo00<0ojYo0?ooo`3oool03`3oool01@3akn80
h=oS0>3Oh`3Pgn<0LFmT09P0h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool0
000506IVOP3ko?d0Z:Vk06IVOP1aKf@0403oool00`3oZWl0oooo0?ooo`0k
0?ooo`0307oVo`3ko_l0oooo0400oooo00<0iooX06CoJ`3koo/0<`3oool0
0`1oOgl0oooo0?ooo`0b0?ooo`030?_on`1Xofl0moog0480oooo00<0OnKo
0?ooo`3oool0>P3oool00`3oZWl0oooo0?ooo`0?0?ooo`050?7_hP3Pgn<0
h=oS0>3Oh`1aKf@0V03Pgn<0103akn80IVIn0:RY^`3ko?d10?ooo`0000D0
IVIn0?_lo@2XZK/0IVIn075_I00@0?ooo`030?nZO`3oool0oooo03/0oooo
00<0O>Ko0?ooo`3oool0@03oool00`1Lof@0lood0?ooo`0c0?ooo`0307mo
O`3oool0oooo03<0oooo00<0boo=09ooY03oool0@@3oool00`1hiOl0noko
0?ooo`0j0?ooo`030?nlV`3ok><0oooo00l0oooo00D0lNoR0>3Oh`3Pgn<0
h=oS075_I02H0>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0
nocm0:RY^`1VIWh0LFmT00l0oooo00<0oo;[0?ngT`3oool0>`3oool00`3O
nOl0Wngo0?ooo`100?ooo`030;oo`P2SojL0oooo03@0oooo00<0Ogmo0?oo
o`3oool0=03oool00`1loh80lood0?ooo`100?ooo`030;Oao`37m?l0oooo
03X0oooo00<0on;C0?o7Z`3oool03`3oool01@3akn80h=oS0>3Oh`3Pgn<0
LFmT09P0h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0
Z:Vk06IVOP1aKf@03`3oool00`3of/L0olng0?ooo`0k0?ooo`030:O^o`3C
mol0oooo0400oooo00<0K?mc0?_on`3oool0=03oool00`1oOgl0oooo0?oo
o`0d0?ooo`030>Ooj02?oi@0oooo0400oooo00<0mogo08?Wo`3oool0>P3o
ool00`3on_L0ojn70?ooo`0?0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@0
V03Pgn<0103akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0
IVIn075_I00?0?ooo`030?o?]`3of/L0oooo03/0oooo00<0OnKo0?_no`3o
ool0?`3oool00`33olH0]onj0?ooo`0e0?ooo`0307moO`3oool0oooo03D0
oooo00<0Ron@0>_ok03oool0@03oool00`1li_l0noko0?ooo`0j0?ooo`03
0?nZO`3oool0oooo00h0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I02H0>3O
h`040?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0
LFmT00l0oooo00<0okZG0?o_i`3oool0>`3oool00`1di?l0oooo0?ooo`0o
0?ooo`0307SoOP3oool0oooo03D0oooo00<0Ogmo0?ooo`3oool0=@3oool0
0`3coo@0Qon=0?ooo`100?ooo`030:o`o`37m?l0oooo03X0oooo00<0ojn7
0?ojm`3oool03P3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT09P0h=oS00@0
lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0
3`3oool00`3oZWl0oooo0?ooo`0j0?ooo`030<ofo`2OkOl0oooo03l0oooo
00<0^onn0;Oo^P3oool0=P3oool00`1oOgl0oooo0?ooo`0f0?ooo`0309oo
Y03;old0oooo03l0oooo00<0io[o08?Wo`3oool0>P3oool00`3oc;<0omc;
0?ooo`0>0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@0V03Pgn<0103akn80
IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I00?0?oo
o`030?nZO`3oool0oooo03X0oooo00<0RnWo0>Ojo`3oool0?`3oool00`1d
og/0oooo0?ooo`0f0?ooo`0307moO`3oool0oooo03H0oooo00<0nook07Co
N`3oool0@03oool00`1hiOl0oooo0?ooo`0i0?ooo`030?o/h`3o_9/0oooo
00h0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Ohi@0oooo0P3Pgn<0
103akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_
I00?0?ooo`030?nZO`3oool0oooo03X0oooo00<0L>Co0?ooo`3oool0?P3o
ool00`2kokh0Yon[0?ooo`0d0?ooo`070?ogm`3o_l80ohN<0;loA03oQh`0
oko20?ogm`0f0?ooo`030:_o[`2cokL0oooo03l0oooo00<0OnKo0?ooo`3o
ool0>P3oool00`3oZWl0oooo0?ooo`0=0?ooo`050?7_hP3Pgn<0h=oS0>3O
h`1aKf@00P3Pgn>C09bLWP070?ooo`3Pgn<0h=oS0?7_hP1VIWh0Z:Vk0?_l
o@010?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I00?0?ooo`030?nZO`3o
ool0oooo03X0oooo00<0OnKo0?ooo`3oool0?P3oool00`1`ogL0oooo0?oo
o`0`0?ooo`0?0?oKg03oZjh0oh>80?moQ03oQh`0oko20?ogm`1oOgl0ooOg
0?no`P3oQh`0ogn40?n;T03o/kH0on_/03<0oooo00<0J?m_0?_on`3oool0
?P3oool00`2Kk?l0ho[o0?ooo`0j0?ooo`030?nZO`3oool0oooo00d0oooo
00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0309bLWP3oool0h=oS08l0
h=oS00P0W9bN0?ooo`3Pgn<0h=oS0?7_hP1VIWh0Z:Vk0?_lo@40oooo0000
1@1VIWh0nocm0:RY^`1VIWh0LFmT00l0oooo00<0ojYo0?ooo`3oool0>@3o
ool00`3OnOl0Wngo0?ooo`0n0?ooo`030>?oi023ohT0oooo02h0oooo00H0
ok>f0?m`MP3oOh@0oj>W0?oCe@3ono/40?ooo`0307moO`3oool0oooo0080
oooo00L0ooOg0?o;c@3oTiL0ogn40?n7S03o_l80ooOg02l0oooo00<0UonL
0=?oe@3oool0?P3oool00`3Cmol0Znoo0?ooo`0j0?ooo`030?nZO`3oool0
oooo00d0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0309bLWP3o
ool0h=oS08l0h=oS00P0W9bN0?ooo`3Pgn<0h=oS0?7_hP1VIWh0Z:Vk0?_l
o@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT00h0oooo00<0oo;[0?ng
T`3oool0>P3oool00`2glOl0aoCo0?ooo`0n0?ooo`0308ooU03GomT0oooo
02`0oooo00@0ok>f0?mTJP3oZjh0oo_k203oool00`1oOgl0oooo0?ooo`06
0?ooo`060?ogm`3o_l80ohN<0?m/LP3oZjh0oo_k;03oool00`3[on`0Oon5
0?ooo`0n0?ooo`030>olo`2?jOl0oooo03X0oooo00<0ojYo0?ooo`3oool0
3@3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00@0W9bN0?ooo`3P
gn<0h=oSS01oWKT20>3Oh`0809bLWP3oool0h=oS0>3Oh`3akn80IVIn0:RY
^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I00>0?ooo`030?oG
``3od[/0oooo03X0oooo00<0QnSo0?Omo`3oool0?P3oool00`1/og<0oooo
0?ooo`0Z0?ooo`040?oKg03oH6H0oj^^0?okn`X0oooo00<0Ogmo0?ooo`3o
ool02P3oool0103o/kH0ofAZ0?n[[P3ono/[0?ooo`0306coL`3oool0oooo
03h0oooo00<0OnKo0?ooo`3oool0>@3oool00`3oZWl0oooo0?ooo`0=0?oo
o`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<01@2LW9h0oooo0>3Oh`3P
gn<0Oifi08X0h=oS00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`040?7_
hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT00h0
oooo00<0ol:S0?oWf`3oool0>P3oool00`1oi_l0oooo0?ooo`0m0?ooo`03
0>?oi027ohd0oooo02X0oooo00<0oj^^0?mdN@3olo<0303oool00`1oOgl0
oooo0?ooo`0<0?ooo`030?nc]P3oO840ooOg02X0oooo00<0UonL0<ood@3o
ool0?P3oool00`1oi_l0oooo0?ooo`0i0?ooo`030?nZO`3oool0oooo00d0
oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0509bLWP3oool0h=oS
0>3Oh`1oWKT0RP3Pgn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo0080h=oS00@0
lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0
3P3oool00`3o]8l0ooC_0?ooo`0j0?ooo`0307oVo`3oool0oooo03d0oooo
00<0TonH0=?oe@3oool0:03oool00`3ono/0ogQm0?nWZP0>0?ooo`0307mo
O`3oool0oooo00d0oooo00<0ooOg0?n?T`3olo<0:@3oool00`3WonP0Oon5
0?ooo`0n0?ooo`0308_Yo`3coOl0oooo03T0oooo00<0okB?0?odk`3oool0
3@3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00D0W9bN0?ooo`3P
gn<0h=oS07nM^@2:0>3Oh`0507nM^@3Pgn<0h=oS09bLWP3oool00P3Pgn<0
103akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_
I00>0?ooo`030?nZO`3oool0oooo03T0oooo00<0mogo08OXo`3oool0?P3o
ool00`1Xofl0oooo0?ooo`0W0?ooo`030?ogm`3oM7T0omOI00l0oooo00<0
Ogmo0?ooo`3oool03P3oool00`3ono/0ohnC0?ogm`0Y0?ooo`0306coL`3o
ool0oooo03d0oooo00<0Ynko0=Ogo`3oool0>@3oool00`3o_il0on[O0?oo
o`0=0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<01@2LW9h0oooo
0>3Oh`3Pgn<0Oifi08X0h=oS00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`020>3O
h`040?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0
LFmT00h0oooo00<0ojYo0?ooo`3oool0>@3oool20;ococh0oooo00<0iooX
08OoS@3oool09`3oool00`3ono/0ohnC0?ogm`0@0?ooo`0307moO`3oool0
oooo00l0oooo00<0ooOg0?mdN@3olo<0:03oool00`2Koj00dooE0?ooo`0m
0?ooo`030=oio`2OkOl0oooo03T0oooo00<0olZ_0?oOc`3oool03@3oool0
1@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00D0W9bN0?ooo`3Pgn<0h=oS
07nM^@2:0>3Oh`0507nM^@3Pgn<0h=oS09bLWP3oool00P3Pgn<0103akn80
IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I00>0?oo
o`030?nZO`3oool0oooo03T0oooo00<0Un_o0>Ojo`3oool0?@3oool00`2C
oiP0eooI0?ooo`0V0?ooo`030?ogm`3oSi<0oo?c0140oooo00<0Ogmo0?oo
o`3oool0403oool00`3ofm`0ogAi0?ooo`0W0?ooo`030>Ooj01oohD0oooo
03h0oooo00<0OnKo0?ooo`3oool0>03oool20?oD_`h0oooo00D0lNoR0>3O
h`3Pgn<0h=oS075_I0020>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0RP3P
gn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0
nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@03P3oool00`3oZWl0
oooo0?ooo`0i0?ooo`0307oVo`3oool0oooo03d0oooo00<0L?mg0?ooo`3o
ool09@3oool00`3ono/0ogQm0?ogm`0B0?ooo`0307moO`3oool0oooo0140
oooo00<0oj^^0?nSY`3oool09`3oool00`1dog/0oooo0?ooo`0m0?ooo`03
07oVo`3oool0oooo03P0oooo00<0omo?0?o:[`3oool03@3oool01@3akn80
h=oS0>3Oh`3Pgn<0LFmT0080h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2:
0>3Oh`0507nM^@3Pgn<0h=oS09bLWP3oool00P3Pgn<0103akn80IVIn0:RY
^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I00=0?ooo`030?ob
j`3o]i<0oooo03X0oooo00<0OnKo0?ooo`3oool0?03oool00`3koo/0Pon9
0?ooo`0V0?ooo`030?mhO@3oemT0oooo0180oooo00<0Ogmo0?ooo`3oool0
4P3oool00`3oN7d0omOI0?ooo`0V0?ooo`0308_oT03gooL0oooo03d0oooo
00<0OnKo0?ooo`3oool0>03oool00`3ok><0okbK0?ooo`0=0?ooo`050?7_
hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi
08X0h=oS00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`040?7_hP1VIWh0
Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT00d0oooo00<0
on[O0?noW`3oool0>@3oool00`3goOl0QnSo0?ooo`0m0?ooo`030=?oe@2[
ojl0oooo02D0oooo00<0oj^^0?nSY`3oool04`3oool00`1oOgl0oooo0?oo
o`0B0?ooo`030?okn`3oO840oo?c02H0oooo00<0/ong0<OobP3oool0?@3o
ool00`2Cj_l0jo_o0?ooo`0i0?ooo`030?nZO`3oool0oooo00`0oooo00D0
lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0509bLWP3oool0h=oS0>3Oh`1o
WKT0RP3Pgn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IV
OP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@03@3oool2
0?oD_`D0oooo00@0no_k09NGU`1oOgl0emOG0P3oool01`2[Zj/0inOW0?oo
o`3WinL0Rh^;07moO`3Shn<0:03oool00`3Gmol0Ynko0?ooo`030?ooo`07
0=?Cd`23Ph<0UiNG0?_kn`3oool0fm_K0;Ng]`020?ooo`040=_Kf`23Ph<0
Shn?0??clbd0oooo00@0UOfJ08VQRP1oOgl0emOG0P3oool01`2[Zj/0inOW
0?ooo`3clo<0Ti>C08>3P`3;bl/06P3oool00`3ofm`0ogAi0?ooo`0D0?oo
o`0307moO`3oool0oooo01<0oooo00<0oo_k0?n?T`3olo<0703oool0103g
moL0Vi^K07moO`3Ogml20?ooo`0709nOW`3clo<0oooo0<;^a01K]el0QhN7
0=_Kf`0^0?ooo`030<o?c`23Ph<0WinO0080oooo00/0clo?0<?3``3oool0
oooo0<o?c`23Ph<0Vi^K0?_kn`3oool0`o?o0;_bo`0Z0?ooo`040?Ogm`2K
Vi/0Ogmo0=oOg`80oooo00L0WinO0??cl`3oool0emOG07moO`23Ph<0jn_[
00<0oooo00<0ojYo0?ooo`3oool0303oool01@3akn80h=oS0>3Oh`3Pgn<0
LFmT0080h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2:0>3Oh`0507nM^@3P
gn<0h=oS09bLWP3oool00P3Pgn<0103akn80IVIn0:RY^`3ko?d10?ooo`00
00D0IVIn0?_lo@2XZK/0IVIn075_I00=0?ooo`030?njU`3oknL0oooo00@0
oooo00h0E5AD08N7Q`2k^k/071`L0<o?c`3oool0F5QH0<o?c`3kno/0:2PX
09^KV`2SXj<0=3@d0=_KfbL0oooo00<0Wngo0=oio`3oool00P3oool03`3;
bl/0<30`0;no_`1/K6`0H61P0?ooo`2g]kL0L71`0?ooo`3;bl/0<30`0;>c
/`2?Shl0>3Ph0?_kn`0/0?ooo`0>02ZZ<027QhL0^k^k01`L703?cll0oooo
05QHF03?cll0no_k03@d=02KVi/0_kno030`<02k^k/I0?ooo`030?mPIP3o
lo<0oooo01@0oooo00<0Ogmo0?ooo`3oool0503oool00`3ono/0ogQm0?oo
o`0J0?ooo`0?0?_kn`0l?3`0WinO0;>c/`0L71`0emOG0?ooo`10@400inOW
0>_[j`0X:2P0DMAG0;Ng]`0T92@0dm?C02`0oooo0140[jn_04A4A02o_kl0
H61P06a/K03oool0WinO08N7Q`3oool0[jn_03`l?02k^k/0N7Qh051@D03o
ool0io[o09O[o`0Y0?ooo`0?0?_kn`0l?3`0WinO0;>c/`0L71`0emOG0?oo
o`10@400inOW0>o_k`0T92@0Zj^[09>CT`0d=3@0kno_0080oooo00<0ojYo
0?ooo`3oool0303oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00D0
W9bN0?ooo`3Pgn<0h=oS07nM^@2:0>3Oh`0507nM^@3Pgn<0h=oS09bLWP3o
ool00P3Pgn<0103akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2X
ZK/0IVIn075_I00=0?ooo`030?nZO`3oool0oooo00<0oooo00H0gmoO020P
803kno/0oooo07moO`1/K6`30?ooo`060>OWi`2GUiL0oooo0?ooo`2?Shl0
N7Qh9`3oool00`1oi_l0oooo0?ooo`020?ooo`06061PH02KVi/0oooo0?Og
m`0820P0jn_[0`3oool01P1LG5`0Zj^[0?ooo`3oool0?3`l0<_;bb/0oooo
00H0gmoO012@5P3kno/0oooo07moO`1/K6`30?ooo`060<_;b`1`L700oooo
0?ooo`2g]kL0B4Q8603oool00`3o/kH0oj^^0?ooo`0E0?ooo`0307moO`3o
ool0oooo01D0oooo00<0ohnC0?oKg03oool06@3oool01P2o_kl0?3`l0?oo
o`3oool0M7Ad08^;R`<0oooo00H0/k>c08N7Q`1hogh0oooo09NGU`1XJ6P/
0?ooo`060410@02k^k/0oooo0>o_k`0D51@0no_k0`3oool0200l?3`0bl_;
0?ooo`3oool071`L0>OWi`3oool0OnKo:@3oool01P2o_kl0?3`l0?ooo`3o
ool0M7Ad08^;R`<0oooo00H0emOG0:NWY`3oool0oooo07moO`2GUiL20?oo
o`030?nZO`3oool0oooo00`0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I002
0>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0RP3Pgn<01@1oWKT0h=oS0>3O
h`2LW9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool0000506IV
OP3ko?d0Z:Vk06IVOP1aKf@03@3oool00`3oZWl0oooo07moO`0200000003
07moO`2WYjL0D51@0080oooo00<0/k>c0410@03oool00`3oool01@33`l<0
D51@05QHF02c/k<0A4A402L0oooo00L0OnKo00000000000000000?ooo`0X
:2P0clo?0080oooo00<0=3@d0;no_`3oool00P3oool01P0X:2P0_kno0?oo
o`3oool0@4100;no_bL0oooo00H0Ogmo000000000000Ogmo09Z^V`0^VS<2
0?ooo`030;>c/`10@400oooo00H0oooo00<0[jn_04A4A03oool05`3oool0
0`3oI6X0oo_k0?ooo`0E0?ooo`0307moO`3oool0oooo01D0oooo00<0omoP
0?n;T03oool06@3oool01P27QhL0L71`0?ooo`3oool0WinO061PH0D0oooo
00@0Ron@0?_on`2?Shl0I6AT;03oool01P0820P0kno_0?ooo`3oool0820P
0=oOg`<0oooo00P020P80=oOg`3oool0oooo020P803Ogml0oooo07oVobT0
oooo00H0QhN7071`L03oool0oooo09nOW`1PH6040?ooo`050:n_[`18B4P0
I6AT09^KV`1HF5P00P3oool00`3oZWl0oooo0?ooo`0<0?ooo`050?7_hP3P
gn<0h=oS0>3Oh`1aKf@00P3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08X0
h=oS00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`040?7_hP1VIWh0Z:Vk
0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT00d0oooo00<0ojYo
0?ooo`3oool00`3oool01P2OWil0H61P0?ooo`3oool0_kno0410@0<0oooo
00H0inOW01@D502c/k<0gmoO04Q8B010@40W0?ooo`0307oVo`3oool0oooo
0080oooo00H0820P0=oOg`3oool0oooo0410@02o_kl30?ooo`06020P801<
C4`0fm_K0:n_[`0P8200kno_:`3oool01P1`_7@0C81>0?ooo`3oool0_kno
0410@0D0oooo00@0_kno07moO`0`<300alO75`3oool00`3o/kH0oj^^0?oo
o`0F0?ooo`0307moO`3oool0oooo01H0oooo00<0ofQ^0?ooo`3oool0603o
ool207moO`80oooo00<0WinO061PH03oool0103oool0101cbgL0H9AR02PX
:03Kfm//0?ooo`060000003oool0oooo0?ooo`0P8200gmoO0`3oool02004
10@0I6AT0=oOg`2GUiL0=3@d0?_kn`3oool0OnKo:@3oool207moO`80oooo
00<0WinO061PH03oool00P3oool01P3Cdm<051@D0<O7a`3GemL0=3@d0410
@080oooo00<0ojYo0?ooo`3oool0303oool01@3akn80h=oS0>3Oh`3Pgn<0
LFmT0080h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2:0>3Oh`0507nM^@3P
gn<0h=oS09bLWP3oool00P3Pgn<0103akn80IVIn0:RY^`3ko?d10?ooo`00
00D0IVIn0?_lo@2XZK/0IVIn075_I00=0?ooo`030?nZO`3oool0oooo00<0
oooo00H0/k>c051@D03oool0oooo0;>c/`18B4P30?ooo`060:NWY`1LG5`0
oooo0?ooo`2o_kl0@4109`3oool00`1oi_l0oooo0?ooo`020?ooo`0603@d
=03?cll0oooo0?ooo`0d=3@0alO70`3oool01@0`<300Zj^[04a<C010@400
bl_;02`0oooo00H0G=QR04mCC`3oool0oooo0;>c/`18B4P50?ooo`040>OW
i`2WYjL0:2PX0>?ShaL0oooo00<0og1f0?okn`3oool05P3oool00`1oOgl0
oooo0?ooo`0F0?ooo`030?n?T`3ofm`0oooo01P0oooo00H0Ti>C071`L03o
ool0oooo09nOW`1XJ6P50?ooo`040;cT_P1S_fL0;2`/0??clb`0oooo00H0
51@D0>o_k`3oool0oooo020P803WinL30?ooo`05010@402SXj<0A4A404Q8
B03Ogml00P3oool00`1oi_l0oooo0?ooo`0W0?ooo`0609>CT`1`L700oooo
0?ooo`2OWil0J6QX0`3oool01P27QhL0O7al0?ooo`3oool0WinO04Q8B080
oooo00<0ojYo0?ooo`3oool0303oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT
0080h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2:0>3Oh`0507nM^@3Pgn<0
h=oS09bLWP3oool00P3Pgn<0103akn80IVIn0:RY^`3ko?d10?ooo`0000D0
IVIn0?_lo@2XZK/0IVIn075_I00=0?ooo`030?nZO`3oool0oooo00<0oooo
00H0dm?C02@T903oool0oooo08N7Q`1`L7030?ooo`060:n_[`1@D500oooo
0?ooo`2g]kL0H61P9`3oool00`1oi_l0oooo0?ooo`020?ooo`0605ADE02S
Xj<0oooo0?_kn`0<30`0jn_[0`3oool01P1TI6@0/k>c0?ooo`3oool0Shn?
0>o_kb/0oooo00H0JNU_02@T903oool0oooo08N7Q`1`L7030?ooo`060>OW
i`2;Rh/0oooo0?ooo`1PH600WinO5`3oool00`3oOh@0oooo0?ooo`0F0?oo
o`0307moO`3oool0oooo01H0oooo00<0omoP0?n;T03oool0603oool01P2c
/k<0A4A40?ooo`3oool0N7Qh08n?S`<0oooo00H0dm?C09>CT`3oool0O?n2
0410@02o_kl/0?ooo`0503@d=033`l<0oooo0??cl`0D51@0103oool01@14
A4@0]kNg0?ooo`3oool0UiNG0080oooo00<0OnKo0?ooo`3oool09`3oool0
1P2c/k<0A4A40?ooo`3oool0N7Qh08n?S`<0oooo00H0Shn?071`L03oool0
oooo09NGU`1oOgl20?ooo`030?nZO`3oool0oooo00`0oooo00D0lNoR0>3O
h`3Pgn<0h=oS075_I0020>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0RP3P
gn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0
nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@03@3oool00`3oZWl0
oooo0?ooo`040?ooo`0504A4A027QhL0_kno020P803GemL00`3oool01P3g
moL092@T08^;R`2o_kl0:2PX0<?3`bL0oooo00<0OnKo0?ooo`3oool00P3o
ool01@2k^k/0;2`/0;no_`1hN7P0H61P00@0oooo00H0clo?02@T902c/k<0
Shn?02`/;03gmoL[0?ooo`0607ooQ@14A4@0QhN70;no_`0P8200emOG0`3o
ool01P3kno/0;2`/09^KV`2_[jl061PH0=_KfaH0oooo00<0om_L0?nSY`3o
ool05`3oool00`1oOgl0oooo0?ooo`0G0?ooo`030?mXKP3oool0oooo01L0
oooo00H0no_k02PX:02OWil0]kNg030`<03WinL30?ooo`060>o_k`0L71`0
Vi^K05KBG00H61P0kno_;03oool01@2OWil0@4100;no_`1/K6`0Ogmo00@0
oooo00D0/k>c030`<02g]kL0QhN703`l?0020?ooo`0307oVo`3oool0oooo
02L0oooo00H0no_k02PX:02OWil0]kNg030`<03WinL30?ooo`060>OWi`0H
61P0WinO0;Ng]`0P8200fm_K0P3oool00`3oZWl0oooo0?ooo`0<0?ooo`05
0?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0
Oifi08X0h=oS00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`040?7_hP1V
IWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT00d0oooo
00<0ojYo0?ooo`3oool0103oool0103clo<0Shn?07moO`3Kfm/50?ooo`04
0??cl`2?Shl0Ogmo0=OGebP0oooo00<0OnKo0?ooo`3oool00`3oool0102o
_kl0Ogmo09nOW`3kno/50?ooo`040=_Kf`23Ph<0Rh^;0>o_kb`0oooo00D0
Oon50??cl`2?Shl0Ogmo0=_Kf`050?ooo`040>_[j`2GUiL0Ph>30=OGeaL0
oooo00<0oj^^0?oCe@3oool05`3oool00`1oOgl0oooo0?ooo`0G0?ooo`03
0?n?T`3ofm`0oooo01P0oooo00@0jn_[08N7Q`23Ph<0inOW1@3oool0103S
hn<0Shn?04?3B@3Ogml^0?ooo`040:n_[`1oOgl0Zj^[0?_kn`D0oooo00@0
clo?08>3P`2CTi<0lo?c0P3oool00`1oi_l0oooo0?ooo`0X0?ooo`040>_[
j`27QhL0Ph>30>OWi`D0oooo00@0inOW08N7Q`23Ph<0hn?S0`3oool00`3o
[8<0oock0?ooo`0<0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<0
1@2LW9h0oooo0>3Oh`3Pgn<0Oifi08X0h=oS00D0Oifi0>3Oh`3Pgn<0W9bN
0?ooo`020>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm
0:RY^`1VIWh0LFmT00d0oooo00<0ojYo0?ooo`3oool0>@3oool00`1oi_l0
oooo0?ooo`0k0?ooo`030??om02;oi00oooo02<0oooo00<0oh>80?okn`3o
ool05`3oool00`1oOgl0oooo0?ooo`0G0?ooo`030?oOh03oRi00oooo02<0
oooo00<0Qon=0?Oom`3oool0?03oool00`1oi_l0oooo0?ooo`0h0?ooo`03
0?noW`3oj]l0oooo00`0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3O
h`0509bLWP3oool0h=oS0>3Oh`1oWKT0RP3Pgn<01@1oWKT0h=oS0>3Oh`2L
W9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3k
o?d0Z:Vk06IVOP1aKf@03@3oool00`3oZWl0oooo0?ooo`0i0?ooo`0307oV
o`3oool0oooo03/0oooo00<0eooI0:OoZ`3oool08`3oool00`3oOh@0oooo
0?ooo`0G0?ooo`0307moO`3oool0oooo01P0oooo00<0og1f0?ooo`3oool0
8P3oool00`2SojL0fooM0?ooo`0l0?ooo`0307oVo`3oool0oooo03P0oooo
00<0olBW0?oTe`3oool0303oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080
h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2:0>3Oh`0507nM^@3Pgn<0h=oS
09bLWP3oool00P3Pgn<0103akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn
0?_lo@2XZK/0IVIn075_I00=0?ooo`030?nZO`3oool0oooo03T0oooo00<0
OnKo0?ooo`3oool0>`3oool00`2kokh0`oo60?ooo`0R0?ooo`030?okn`3o
PhP0oooo01P0oooo00<0Ogmo0?ooo`3oool0603oool00`3oOh@0oooo0?oo
o`0R0?ooo`030<?oaP2kokh0oooo03`0oooo00<0OnKo0?ooo`3oool0>03o
ool20?oD_`d0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0509bL
WP3oool0h=oS0>3Oh`1oWKT0RP3Pgn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo
0080h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk
06IVOP1aKf@03@3oool00`3oZWl0oooo0?ooo`0i0?ooo`0307oVo`3oool0
oooo03/0oooo00<0XonW0=_og@3oool08P3oool00`3ocm40ojnb0?ooo`0H
0?ooo`0307moO`3oool0oooo01P0oooo00<0ogn40?ooo`3oool08P3oool0
0`3Son@0VonP0?ooo`0l0?ooo`0307oVo`3oool0oooo03P0oooo00<0on;C
0?o7Z`3oool0303oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00D0
W9bN0?ooo`3Pgn<0h=oS07nM^@2:0>3Oh`0507nM^@3Pgn<0h=oS09bLWP3o
ool00P3Pgn<0103akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2X
ZK/0IVIn075_I00=0?ooo`030?nZO`3oool0oooo00P0oooo00<0WinO0?oo
o`3oool0;P3oool00`1oi_l0oooo0?ooo`070?ooo`0309nOW`3oool0oooo
0340oooo00<0Pon90?_on`3oool00`3oool00`2OWil0oooo0?ooo`0L0?oo
o`030?n_/P3ocm40oooo01P0oooo00<0Ogmo0?ooo`3oool0603oool00`3o
Oh@0oooo0?ooo`0M0?ooo`0309nOW`3oool0oooo00<0oooo00<0Oon50?oo
o`3oool0<P3oool00`2OWil0oooo0?ooo`060?ooo`0307oVo`3oool0oooo
02h0oooo00<0WinO0?ooo`3oool01`3oool00`3ok><0okbK0?ooo`0<0?oo
o`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<01@2LW9h0oooo0>3Oh`3P
gn<0Oifi08X0h=oS00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`040?7_
hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT00d0
oooo00<0ojYo0?ooo`3oool0203oool00`1oOgl0oooo0?ooo`0^0?ooo`03
07oVo`3oool0oooo00L0oooo00<0Ogmo0?ooo`3oool0<@3oool00`1oohD0
oooo0?ooo`030?ooo`0307moO`3oool0oooo01`0oooo00<0oh>80?okn`3o
ool0603oool00`1oOgl0oooo0?ooo`0H0?ooo`030?moQ03oool0oooo01d0
oooo00<0Ogmo0?ooo`3oool00`3oool00`1oohD0oooo0?ooo`0b0?ooo`03
07moO`3oool0oooo00H0oooo00<0OnKo0?ooo`3oool0;P3oool00`1oOgl0
oooo0?ooo`080?ooo`030?nZO`3oool0oooo00/0oooo00D0lNoR0>3Oh`3P
gn<0h=oS075_I0020>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0RP3Pgn<0
1@1oWKT0h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0nocm
0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@01@3oool00`2OWil0Ogmo
07moO`0507moO`030;mZ?`1oOgl0Ogmo00P0Ogmo00<0?clo07moO`1oOgl0
;P1oOgl00`0oY[l0Ogmo07moO`0707moO`0303lo?`1oOgl0Ogmo0340Ogmo
00<0?km507moO`1oOgl00`1oOgl00`0o?cl0Ogmo07moO`0L07moO`030;lo
A01oOgl0Ogmo01P0Ogmo00<0?clo07moO`1oOgl0601oOgl00`2o?d@0Ogmo
07moO`0M07moO`0303lo?`1oOgl0Ogmo00<0Ogmo00<0?km507moO`1oOgl0
<P1oOgl00`0o?cl0Ogmo07moO`0607moO`0303nV_`1oOgl0Ogmo02h0Ogmo
00<0?clo07moO`1oOgl0201oOgl00`2oJSl0Ogmo07moO`0507moO`0309nO
W`3oool0oooo00<0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`05
09bLWP3oool0h=oS0>3Oh`1oWKT0RP3Pgn<01@1oWKT0h=oS0>3Oh`2LW9h0
oooo0080h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0
Z:Vk06IVOP1aKf@03@3oool00`3oZWl0oooo0?ooo`080?ooo`0307moO`3o
ool0oooo02h0oooo00<0OnKo0?ooo`3oool01`3oool00`1oOgl0oooo0?oo
o`0a0?ooo`0307ooQ@3oool0oooo00<0oooo00<0Ogmo0?ooo`3oool0703o
ool00`3oPhP0oo_k0?ooo`0H0?ooo`0307moO`3oool0oooo01P0oooo00<0
ogn40?ooo`3oool07@3oool00`1oOgl0oooo0?ooo`030?ooo`0307ooQ@3o
ool0oooo0380oooo00<0Ogmo0?ooo`3oool01P3oool00`1oi_l0oooo0?oo
o`0^0?ooo`0307moO`3oool0oooo00P0oooo00<0ojYo0?ooo`3oool02`3o
ool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00D0W9bN0?ooo`3Pgn<0
h=oS07nM^@2:0>3Oh`0507nM^@3Pgn<0h=oS09bLWP3oool00P3Pgn<0103a
kn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I00=
0?ooo`030?nZO`3oool0oooo00P0oooo00<0WinO0?ooo`3oool0;P3oool0
0`1oi_l0oooo0?ooo`070?ooo`0309nOW`3oool0oooo0340oooo00<0Oon5
0?ooo`3oool00`3oool00`2OWil0oooo0?ooo`0L0?ooo`030?n[[P3odmD0
oooo01P0oooo00<0Ogmo0?ooo`3oool0603oool00`3oOh@0oooo0?ooo`0M
0?ooo`0309nOW`3oool0oooo00<0oooo00<0Oon50?ooo`3oool0<P3oool0
0`2OWil0oooo0?ooo`060?ooo`0307oVo`3oool0oooo02h0oooo00<0WinO
0?ooo`3oool0203oool00`3oZWl0oooo0?ooo`0;0?ooo`050?7_hP3Pgn<0
h=oS0>3Oh`1aKf@00P3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08X0h=oS
00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`040?7_hP1VIWh0Z:Vk0?_l
o@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT00d0oooo00<0ojYo0?oo
o`3oool0>@3oool00`1oi_l0oooo0?ooo`0k0?ooo`0308_oT03coo@0oooo
0280oooo00<0om_L0?nSY`3oool0603oool00`1oOgl0oooo0?ooo`0H0?oo
o`030?moQ03oool0oooo02<0oooo00<0Oon50?ooo`3oool0>`3oool00`1o
i_l0oooo0?ooo`0i0?ooo`030?nZO`3oool0oooo00/0oooo00D0lNoR0>3O
h`3Pgn<0h=oS075_I0020>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0RP3P
gn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0
nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@03@3oool00`3oZWl0
oooo0?ooo`0i0?ooo`0307oVo`3oool0oooo03/0oooo00<0Yon[0=Oof@3o
ool08`3oool00`3oOh@0oooo0?ooo`0G0?ooo`0307moO`3oool0oooo01P0
oooo00<0ogn40?ooo`3oool08`3oool00`1oohD0oooo0?ooo`0k0?ooo`03
07oVo`3oool0oooo03T0oooo00<0ojYo0?ooo`3oool02`3oool01@3akn80
h=oS0>3Oh`3Pgn<0LFmT0080h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2:
0>3Oh`0507nM^@3Pgn<0h=oS09bLWP3oool00P3Pgn<0103akn80IVIn0:RY
^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I00=0?ooo`030?nZ
O`3oool0oooo03T0oooo00<0OnKo0?ooo`3oool0>`3oool00`33olH0^onn
0?ooo`0S0?ooo`030?moQ03oool0oooo01L0oooo00<0Ogmo0?ooo`3oool0
603oool00`3oH6H0oooo0?ooo`0R0?ooo`030>?oi02Koj00oooo03`0oooo
00<0OnKo0?ooo`3oool0>@3oool00`3oZWl0oooo0?ooo`0;0?ooo`050?7_
hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi
08X0h=oS00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`040?7_hP1VIWh0
Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT00d0oooo00<0
ojYo0?ooo`3oool0>@3oool00`1oi_l0oooo0?ooo`0k0?ooo`030>?oi02K
oj00oooo02<0oooo00<0ohN<0?ogm`3oool05`3oool00`1oOgl0oooo0?oo
o`0H0?ooo`030?moQ03oool0oooo0280oooo00<0aoo:0;Oo^P3oool0?03o
ool00`1oi_l0oooo0?ooo`0h0?ooo`030?ojm`3o[hL0oooo00`0oooo00D0
lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0509bLWP3oool0h=oS0>3Oh`1o
WKT0RP3Pgn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IV
OP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@03@3oool0
0`3oZWl0oooo0?ooo`0i0?ooo`0307oVo`3oool0oooo03/0oooo00<0nook
08?oR@3oool08`3oool20?no`QP0oooo00<0Ogmo0?ooo`3oool0603oool0
0`3oWj<0oooo0?ooo`0R0?ooo`030:oo/`3?om40oooo03`0oooo00<0OnKo
0?ooo`3oool0>03oool00`3oh]<0olN[0?ooo`0<0?ooo`050?7_hP3Pgn<0
h=oS0>3Oh`1aKf@00P3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08X0h=oS
00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`040?7_hP1VIWh0Z:Vk0?_l
o@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT00d0oooo00<0ojYo0?oo
o`3oool0>@3oool00`27j?l0mogo0?ooo`0l0?ooo`0307ooQ@3oool0oooo
0280oooo00<0ooOg0?n7S03oool05`3oool00`1oOgl0oooo0?ooo`0m0?oo
o`0309OoW03WonP0oooo03`0oooo00<0OnKo0?ooo`3oool0>03oool20?oD
_`d0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0509bLWP3oool0
h=oS0>3Oh`1oWKT0RP3Pgn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo0080h=oS
00@0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1a
Kf@03@3oool00`3oZWl0oooo0?ooo`0i0?ooo`030:?]o`3Kn?l0oooo03`0
oooo00<0Oon50?ooo`3oool08`3oool00`3oL7H0oo_k0?ooo`0F0?ooo`03
07moO`3oool0oooo03d0oooo00<0Oon50?ooo`3oool0>`3oool00`3Wn_l0
Un_o0?ooo`0i0?ooo`030?o2X`3oim/0oooo00`0oooo00D0lNoR0>3Oh`3P
gn<0h=oS075_I0020>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0RP3Pgn<0
1@1oWKT0h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0nocm
0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@03@3oool00`3oZWl0oooo
0?ooo`0i0?ooo`030<?co`2kl_l0oooo03`0oooo00<0Oon50?ooo`3oool0
8`3oool00`3o/kH0oj^^0?ooo`0F0?ooo`0307moO`3oool0oooo03d0oooo
00<0Oon50?ooo`3oool0>`3oool00`37m?l0]o7o0?ooo`0i0?ooo`030?nd
S`3om>l0oooo00`0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`05
09bLWP3oool0h=oS0>3Oh`1oWKT0RP3Pgn<01@1oWKT0h=oS0>3Oh`2LW9h0
oooo0080h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0
Z:Vk06IVOP1aKf@03@3oool00`3oZWl0oooo0?ooo`0i0?ooo`030>?jo`2K
k?l0oooo03`0oooo00<0Qon=0?Oom`3oool0903oool00`3oI6X0oo_k0?oo
o`0E0?ooo`0307moO`3oool0oooo00l0oooo00P0ooog0?ooU`3ooc@0ool4
0?oo003oobP0oon;0?oolbH0oooo00<0L?mg0?ooo`3oool0>`3oool00`2W
k_l0eoOo0?ooo`0i0?ooo`030?nZO`3oool0oooo00`0oooo00D0lNoR0>3O
h`3Pgn<0h=oS075_I0020>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0RP3P
gn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0
nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@03@3oool00`3oZWl0
oooo0?ooo`0j0?ooo`0307oVo`3oool0oooo03/0oooo00<0]onj0<OobP3o
ool0903oool00`3o/kH0oj^^0?ooo`0E0?ooo`0307moO`3oool0oooo00h0
oooo00<0oooO0?oo:03oo`001@3oo`000`3oob@0oooO0?ooo`0S0?ooo`03
0??om01oohD0oooo03`0oooo00<0QnSo0?Omo`3oool0>@3oool00`3oZWl0
oooo0?ooo`0<0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<01@2L
W9h0oooo0>3Oh`3Pgn<0Oifi08X0h=oS00D0Oifi0>3Oh`3Pgn<0W9bN0?oo
o`020>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY
^`1VIWh0LFmT00d0oooo00<0ojYo0?ooo`3oool0>P3oool00`1oi_l0oooo
0?ooo`0k0?ooo`030>ool02?oi@0oooo02D0oooo00<0of1V0?ocl`3oool0
503oool00`1oOgl0oooo0?ooo`0=0?ooo`030?oom`3oobP0ool000L0ool0
00<0oolT0?ool`3oool08P3oool00`2SojL0cooA0?ooo`0l0?ooo`0307oV
o`3oool0oooo03T0oooo00<0ojYo0?ooo`3oool0303oool01@3akn80h=oS
0>3Oh`3Pgn<0LFmT0080h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2:0>3O
h`0507nM^@3Pgn<0h=oS09bLWP3oool00P3Pgn<0103akn80IVIn0:RY^`3k
o?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I00=0?ooo`030?nZO`3o
ool0oooo03X0oooo00<0OnKo0?ooo`3oool0?03oool00`1oohD0oooo0?oo
o`0T0?ooo`030?oKg03oM7T0oooo01@0oooo00<0Ogmo0?ooo`3oool03@3o
ool02@3ooiL0ool00?oo003on`00ogP50?l<2P3o20X0og060?oc00020?oo
00030?ooS`3oool0oooo0240oooo00<0O?n20?ooo`3oool0?03oool00`1o
i_l0oooo0?ooo`0i0?ooo`030?nZO`3oool0oooo00`0oooo00D0lNoR0>3O
h`3Pgn<0h=oS075_I0020>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0RP3P
gn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0
nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@03@3oool00`3oZWl0
oooo0?ooo`0j0?ooo`0307oVo`3oool0oooo03`0oooo00<0Oon50?ooo`3o
ool09@3oool00`3oZjh0oj>W0?ooo`0C0?ooo`0307moO`3oool0oooo00d0
oooo00@0oold0?oo003oo`00ogP5103o00X0103oL0H0ool00?oo003oob`R
0?ooo`030?_on`1dog/0oooo03d0oooo00<0OnKo0?ooo`3oool0>@3oool0
0`3oZWl0oooo0?ooo`0<0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3P
gn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08X0h=oS00D0Oifi0>3Oh`3Pgn<0
W9bN0?ooo`020>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0
nocm0:RY^`1VIWh0LFmT00d0oooo00<0ojb30?oln`3oool0>P3oool00`1o
i_l0oooo0?ooo`0l0?ooo`0309OoW03WonP0oooo02H0oooo00<0ogQm0?oG
f@3oool04P3oool00`1oOgl0oooo0?ooo`0=0?ooo`040?oo103oo`00ool0
0?l<2P@0o`0:00@0o`P:0?oo003oo`00ool08P3oool00`2cokL0_oo20?oo
o`0m0?ooo`0307oVo`3oool0oooo03P0oooo00<0oo;[0?ngT`3oool03@3o
ool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00D0W9bN0?ooo`3Pgn<0
h=oS07nM^@2:0>3Oh`0507nM^@3Pgn<0h=oS09bLWP3oool00P3Pgn<0103a
kn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I00=
0?ooo`030?nlV`3ok><0oooo03X0oooo00<0Tn[o0>_ko`3oool0?03oool0
0`3ComD0Zon_0?ooo`0V0?ooo`030?okn`3oO840oo?c0180oooo00<0Ogmo
0?ooo`3oool03@3oool0103oo`@0ool00?oo003o30X40?l02P040?l82P3o
o`00ool00?oo0280oooo00<0O?n20?Oom`3oool0?03oool00`3Wn_l0Un_o
0?ooo`0i0?ooo`030?oWf`3o`Z<0oooo00d0oooo00D0lNoR0>3Oh`3Pgn<0
h=oS075_I0020>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0RP3Pgn<01@1o
WKT0h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0nocm0@3o
ool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@03@3oool20?oD_c/0oooo00<0
/o3o0<_eo`3oool0?@3oool00`1oohD0oooo0?ooo`0V0?ooo`030?okn`3o
Si<0oo?c0140oooo00<0Ogmo0?ooo`3oool03@3oool0103ooc@0ool00?o[
0@3o<`P40?l02P040?m`1P3oo`00ool00?oo;280oooo00<0L?mg0?ooo`3o
ool0?03oool00`37m?l0]o7o0?ooo`0i0?ooo`030?oG``3od[/0oooo00d0
oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0509bLWP3oool0h=oS
0>3Oh`1oWKT0RP3Pgn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo0080h=oS00@0
lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0
3@3oool00`3oi=L0olBW0?ooo`0j0?ooo`030<ofo`2_l?l0oooo03d0oooo
00<0L?mg0?_on`3oool09`3oool00`3ono/0ohnC0?ocl`0@0?ooo`0307mo
O`3oool0oooo00d0oooo00T0ooNB0?n71@3o40T0o`0:0?lL2@3o30X0o`P:
0?m`1P3ol`000P3oo`000`3oohl0oooo0?ooo`0O0?ooo`030=Oof@2CoiP0
oooo03d0oooo00<0Ynko0=Ogo`3oool0>@3oool00`3oaj/0on;C0?ooo`0=
0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<01@2LW9h0oooo0>3O
h`3Pgn<0Oifi08X0h=oS00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`04
0?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT
00d0oooo00<0oock0?n/P`3oool0>P3oool00`3_o?l0SnWo0?ooo`0m0?oo
o`030:OoZ`2kokh0oooo02P0oooo00<0oo_k0?n?T`3olo<03`3oool00`1o
Ogl0oooo0?ooo`0<0?ooo`030?n[[P3o82P0o`0:0080o`0:00<0ok<30?oo
003oo`000`3oo`000`3oob@0oooc0?ooo`0P0?ooo`0308OoS@3[on`0oooo
03d0oooo00<0QnSo0?Omo`3oool0>@3oool00`3o[8<0oock0?ooo`0=0?oo
o`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<01@2LW9h0oooo0>3Oh`3P
gn<0Oifi08X0h=oS00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`040?7_
hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT00h0
oooo00<0ojYo0?ooo`3oool0>P3oool00`1oi_l0oooo0?ooo`0l0?ooo`03
0?_on`1Xofl0oooo02T0oooo00@0oo_k0?mdN@3oZjh0oo_k3@3oool00`1o
Ogl0oooo0?ooo`0:0?ooo`030?o3a@3o=3`0o`0:00<0o`0:00<0oc@80?ok
003oo`000`3oo`000`3oob@0oooO0?ooo`0Q0?ooo`0306CoJ`3oool0oooo
03d0oooo00<0OnKo0?ooo`3oool0>@3oool00`3oZWl0oooo0?ooo`0=0?oo
o`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<01@2LW9h0oooo0>3Oh`3P
gn<0Oifi08X0h=oS00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`040?7_
hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT00h0
oooo00<0ojYo0?ooo`3oool0>P3oool00`1oi_l0oooo0?ooo`0m0?ooo`03
08_oT03GomT0oooo02X0oooo00@0ok>f0?mTJP3oZjh0oo_k2`3oool00`1o
Ogl0oooo0?ooo`080?ooo`030?oOh03oF5l0o`@>00D0o`0:00L0okmd0?oo
>03oo`P0ool00?oo;03oohl0oooc0280oooo00<0_oo20:?oY`3oool0?P3o
ool00`1oi_l0oooo0?ooo`0i0?ooo`030?nZO`3oool0oooo00d0oooo00D0
lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0509bLWP3oool0h=oS0>3Oh`1o
WKT0RP3Pgn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IV
OP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@03P3oool0
0`3o/X/0ooOc0?ooo`0j0?ooo`0307CTo`3oool0oooo03d0oooo00<0koo`
07CoN`3oool0;03oool0103o/kH0ofAZ0?n[[P3ono/90?ooo`0307moO`3o
ool0oooo00H0oooo00<0ono`0?mdN@3o31H01P3o00X00`3o<3P0oooo0?oo
o`0W0?ooo`0306SoK`3koo/0oooo03d0oooo00<0noko08?Wo`3oool0>P3o
ool00`3oZWl0oooo0?ooo`0=0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@0
0P3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08X0h=oS00D0Oifi0>3Oh`3P
gn<0W9bN0?ooo`020>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1V
IWh0nocm0:RY^`1VIWh0LFmT00h0oooo00<0ol:S0?oWf`3oool0>P3oool0
0`23iol0jo_o0?ooo`0n0?ooo`0307SoOP3[on`0oooo02d0oooo00@0ok>f
0?mTJP3oZjh0oo_k1`3oool00`1oOgl0oooo0?ooo`040?ooo`030?okn`3o
Ui/0oaLP00P0o`0:00<0ok^n0?ooo`3oool09P3oool00`3GomT0Ron@0?oo
o`0n0?ooo`030<_eo`2cl?l0oooo03X0oooo00<0ojYo0?ooo`3oool03@3o
ool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00D0W9bN0?ooo`3Pgn<0
h=oS07nM^@2:0>3Oh`0507nM^@3Pgn<0h=oS09bLWP3oool00P3Pgn<0103a
kn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I00>
0?ooo`030?oG``3od[/0oooo03X0oooo00<0foSo09?Zo`3oool0?P3oool0
0`3Oon40Pon90?ooo`0_0?ooo`060?nc]P3oL7H0ogn40?nOX`3odmD0ooOg
0`3oool00`1oOgl0oooo0?ooo`040?ooo`070?o?d@3oJFl0oeUP0?n8S03o
Qh`0ogAi0?m0A`030?l02P030?ld?03oool0oooo02L0oooo00<0M?mk0>oo
l03oool0?P3oool00`2?jOl0koco0?ooo`0j0?ooo`030?nZO`3oool0oooo
00d0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0509bLWP3oool0
h=oS0>3Oh`1oWKT0RP3Pgn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo0080h=oS
00@0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1a
Kf@03P3oool00`3ol^/0okNC0?ooo`0k0?ooo`0307SUo`3oool0oooo03h0
oooo00<0L?mg0?Oom`3oool0<@3oool03`3ogn00oj^^0?n7S03oOh@0ohN<
0?no`P23Ng/0oooo0?okn`3obld0oi>G0?moQ03oK780oiNK0?ocl`040?oo
o`050?oSi03o00X0o`0:0?l02P3o[k80:03oool00`3[on`0M?mk0?ooo`0o
0?ooo`0307oVo`3oool0oooo03T0oooo00<0ooOc0?nbR`3oool03P3oool0
1@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00D0W9bN0?ooo`3Pgn<0h=oS
07nM^@2:0>3Oh`0507nM^@3Pgn<0h=oS09bLWP3oool00P3Pgn<0103akn80
IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I00?0?oo
o`030?nZO`3oool0oooo03X0oooo00<0OnKo0?Omo`3oool0?P3oool00`33
olH0VonP0?ooo`0e0?ooo`070?ogm`3o_l80^d=80?moQ03oPhP0ojnb0?o[
k0090?ooo`030?l<5P3o00X0ocQ002T0oooo00<0Pon90=_og@3oool0?`3o
ool00`1oi_l0oooo0?ooo`0i0?ooo`030?oLb`3oc;<0oooo00h0oooo00D0
lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0509bLWP3oool0h=oS0>3Oh`1o
WKT0RP3Pgn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IV
OP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@03`3oool0
0`3oZWl0oooo0?ooo`0j0?ooo`030;Oao`2olol0oooo03l0oooo00<0I?m[
0?Oom`3oool0=P3oool00`1oOgl0oooo0?ooo`0;0?ooo`030?llA03o00X0
oj^^02P0oooo00<0nook06coL`3oool0?`3oool00`3Gmol0Ynko0?ooo`0j
0?ooo`80omBo3`3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00D0
W9bN0?ooo`3Pgn<0h=oS07nM^@2:0>3Oh`0507nM^@3Pgn<0h=oS09bLWP3o
ool00P3Pgn<0103akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2X
ZK/0IVIn075_I00?0?ooo`030?nZO`3oool0oooo03/0oooo00<0OnKo0?oo
o`3oool0?P3oool00`3;old0WonT0?ooo`0f0?ooo`0307moO`3oool0oooo
00/0oooo00<0ofab0?lh@03ono/0:03oool00`2SojL0_oo20?ooo`0o0?oo
o`0309_/o`3Sn_l0oooo03X0oooo00<0ol:S0?oWf`3oool03P3oool01@3a
kn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM
^@2:0>3Oh`0507nM^@3Pgn<0h=oS09bLWP3oool00P3Pgn<0103akn80IVIn
0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I00?0?ooo`03
0?ngT`3ol^/0oooo03/0oooo00<0OnKo0?ooo`3oool0?`3oool00`1loh80
lood0?ooo`0e0?ooo`0307moO`3oool0oooo00/0oooo00<0oi>G0?n_/P3o
ool0:03oool00`1PofL0oooo0?ooo`0o0?ooo`0307oVo`3oool0oooo03X0
oooo00<0okNC0?obj`3oool03P3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT
0080h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2:0>3Oh`0507nM^@3Pgn<0
h=oS09bLWP3oool00P3Pgn<0103akn80IVIn0:RY^`3ko?d10?ooo`0000D0
IVIn0?_lo@2XZK/0IVIn075_I00?0?ooo`030?o?]`3of/L0oooo03/0oooo
00<0Wngo0=_ho`3oool0?`3oool00`3WonP0SonD0?ooo`0e0?ooo`0307mo
O`3oool0oooo00/0oooo00<0omoP0?okn`3oool09`3oool00`2Goi`0aoo:
0?ooo`100?ooo`0307oVo`3oool0oooo03X0oooo00<0ojYo0?ooo`3oool0
3P3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00D0W9bN0?ooo`3P
gn<0h=oS07nM^@2:0>3Oh`0507nM^@3Pgn<0h=oS09bLWP3oool00P3Pgn<0
103akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_
I00?0?ooo`030?oZg`3o_il0oooo03/0oooo00<0koco08_Yo`3oool0@03o
ool00`2;oi00joo/0?ooo`0d0?ooo`0307moO`3oool0oooo03@0oooo00<0
hooT07coPP3oool0@03oool00`3Wn_l0Un_o0?ooo`0k0?ooo`030?nZO`3o
ool0oooo00h0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0509bL
WP3oool0h=oS0>3Oh`1oWKT0RP3Pgn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo
0080h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk
06IVOP1aKf@03`3oool00`3oo?/0ojb30?ooo`0l0?ooo`0307cVo`3oool0
oooo03l0oooo00<0lood08OoS@3oool0=03oool00`1oOgl0oooo0?ooo`0d
0?ooo`0306CoJ`3_oo00oooo0400oooo00<0Znoo0=?go`3oool0>`3oool0
0`3oZWl0oooo0?ooo`0>0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3P
gn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08X0h=oS00D0Oifi0>3Oh`3Pgn<0
W9bN0?ooo`020>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0
nocm0:RY^`1VIWh0LFmT0100oooo00<0ojYo0?ooo`3oool0>`3oool00`23
iol0koco0?ooo`100?ooo`0309ooY03;old0oooo03<0oooo00<0Ogmo0?oo
o`3oool0<`3oool00`2_ok<0Yon[0?ooo`110?ooo`0308?Wo`3ko_l0oooo
03X0oooo00<0oo[g0?n_Q`3oool03`3oool01@3akn80h=oS0>3Oh`3Pgn<0
LFmT0080h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2:0>3Oh`0507nM^@3P
gn<0h=oS09bLWP3oool00P3Pgn<0103akn80IVIn0:RY^`3ko?d10?ooo`00
00D0IVIn0?_lo@2XZK/0IVIn075_I00@0?ooo`030?nZO`3oool0oooo03/0
oooo00<0doOo0:O^o`3oool0@03oool00`3koo/0M?mk0?ooo`0c0?ooo`03
07moO`3oool0oooo0380oooo00<0lood06coL`3koo/0@P3oool00`1oi_l0
oooo0?ooo`0j0?ooo`030?oG``3od[/0oooo00l0oooo00D0lNoR0>3Oh`3P
gn<0h=oS075_I0020>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0RP3Pgn<0
1@1oWKT0h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0nocm
0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0403oool00`3oZWl0oooo
0?ooo`0l0?ooo`0307CTo`3oool0oooo0400oooo00<0Zon_0;?o]`3oool0
<P3oool00`1oOgl0oooo0?ooo`0b0?ooo`0307SoOP3Komd0oooo0440oooo
00<0logo08_Yo`3oool0>`3oool00`3o/X/0ooOc0?ooo`0?0?ooo`050?7_
hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi
08X0h=oS00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`040?7_hP1VIWh0
Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT0100oooo00<0
olBW0?oTe`3oool0?03oool00`1hiOl0noko0?ooo`110?ooo`0306CoJ`3_
oo00oooo0340oooo00<0Ogmo0?ooo`3oool0<@3oool00`3;old0Pon90?oo
o`120?ooo`030;_bo`33lol0oooo03/0oooo00<0ojYo0?ooo`3oool03`3o
ool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00D0W9bN0?ooo`3Pgn<0
h=oS07nM^@2:0>3Oh`0507nM^@3Pgn<0h=oS09bLWP3oool00P3Pgn<0103a
kn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I00@
0?ooo`030?oOc`3obZl0oooo03`0oooo00<0/o3o0<?co`3oool0@@3oool0
0`3WonP0I?m[0?Oom`0a0?ooo`0307moO`3oool0oooo0300oooo00<0nook
063oI`3gooL0@`3oool00`27j?l0mogo0?ooo`0k0?ooo`030?n/P`3oool0
oooo00l0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0509bLWP3o
ool0h=oS0>3Oh`1oWKT0RP3Pgn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo0080
h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IV
OP1aKf@0403oool00`3omo<0ok:;0?ooo`0l0?ooo`030>_ko`23iol0oooo
0480oooo00<0dooE07coPP3oool0<03oool00`1oOgl0oooo0?ooo`0`0?oo
o`0306SoK`3Komd0oooo04<0oooo00<0M>Co0?ooo`3oool0>P3oool00`3o
h]<0olN[0?ooo`0@0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<0
1@2LW9h0oooo0>3Oh`3Pgn<0Oifi08X0h=oS00D0Oifi0>3Oh`3Pgn<0W9bN
0?ooo`020>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm
0:RY^`1VIWh0LFmT0140oooo00<0ojYo0?ooo`3oool0?03oool00`1/hol0
noko0?ooo`120?ooo`030;Oo^P2Goi`0oooo02l0oooo00<0Ogmo0?ooo`3o
ool0;`3oool00`1loh80boo=0?ooo`130?ooo`030=?go`2Cj_l0oooo03/0
oooo00<0okNC0?obj`3oool0403oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT
0080h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2:0>3Oh`0507nM^@3Pgn<0
h=oS09bLWP3oool00P3Pgn<0103akn80IVIn0:RY^`3ko?d10?ooo`0000D0
IVIn0?_lo@2XZK/0IVIn075_I00A0?ooo`030?nRM03oool0oooo03`0oooo
00<0Vnco0<ofo`3oool0@`3oool00`2CoiP0[onc0?ooo`0^0?ooo`0307mo
O`3oool0oooo02h0oooo00<0TonH0;Oo^P3oool0A03oool00`1hiOl0koco
0?ooo`0k0?ooo`030?nZO`3oool0oooo0100oooo00D0lNoR0>3Oh`3Pgn<0
h=oS075_I0020>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0RP3Pgn<01@1o
WKT0h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0nocm0@3o
ool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@04@3oool00`3o[hL0on[O0?oo
o`0l0?ooo`030>olo`1li_l0oooo04@0oooo00<0O?n20<_oc@3oool0;@3o
ool00`1oOgl0oooo0?ooo`0]0?ooo`030:_o[`2Koj00oooo04@0oooo00<0
mogo073To`3oool0?03oool00`3oZWl0oooo0?ooo`0@0?ooo`050?7_hP3P
gn<0h=oS0>3Oh`1aKf@00P3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08X0
h=oS00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`040?7_hP1VIWh0Z:Vk
0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT0140oooo00<0on[O
0?ndS`3oool0?@3oool00`1/hol0noko0?ooo`140?ooo`0306SoK`3Son@0
oooo02`0oooo00<0Ogmo0?ooo`3oool0;03oool00`37olX0Oon50?ooo`15
0?ooo`030:?]o`2olol0oooo03/0oooo00<0onOK0?o2X`3oool04@3oool0
1@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00D0W9bN0?ooo`3Pgn<0h=oS
07nM^@2:0>3Oh`0507nM^@3Pgn<0h=oS09bLWP3oool00P3Pgn<0103akn80
IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I00B0?oo
o`030?nRM03oool0oooo03`0oooo00<0Znoo0;oco`3oool0A03oool00`3c
oo@0N?mn0?Oom`0/0?ooo`0307moO`3oool0oooo02/0oooo00<0fooM073o
M`3koo/0AP3oool00`1ThOl0noko0?ooo`0k0?ooo`030?o4Y`3oi=L0oooo
0140oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0509bLWP3oool0
h=oS0>3Oh`1oWKT0RP3Pgn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo0080h=oS
00@0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1a
Kf@04P3oool00`3o[8<0oo;[0?ooo`0l0?ooo`030?Omo`1di?l0oooo04D0
oooo00<0moog08ooU03gooL0:`3oool00`1oOgl0oooo0?ooo`0Z0?ooo`03
0>ool01PofL0lood04H0oooo00<0doOo08oYo`3oool0?03oool00`3oZWl0
oock0?ooo`0A0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<01@2L
W9h0oooo0>3Oh`3Pgn<0Oifi08X0h=oS00D0Oifi0>3Oh`3Pgn<0W9bN0?oo
o`020>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY
^`1VIWh0LFmT0180oooo00<0onCG0?ngT`3oool0?@3oool00`1/hol0noko
0?ooo`150?ooo`030?Oom`2?oi@0moog02X0oooo00<0Ogmo0?ooo`3oool0
:@3oool00`3Son@0H?mW0>_ok0170?ooo`0307SUo`3_o?l0oooo03`0oooo
00<0ojYo0?ooo`3oool04@3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080
h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2:0>3Oh`0507nM^@3Pgn<0h=oS
09bLWP3oool00P3Pgn<0103akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn
0?_lo@2XZK/0IVIn075_I00C0?ooo`030?nRM03oool0oooo03`0oooo00<0
]o7o0:o`o`3oool0AP3oool00`3gooL0SonD0??om00Y0?ooo`0307moO`3o
ool0oooo02P0oooo00<0cooA06coL`3coo@0A`3oool00`3goOl0M>Co0?oo
o`0l0?ooo`030?oWf`3o`Z<0oooo0180oooo00D0lNoR0>3Oh`3Pgn<0h=oS
075_I0020>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0RP3Pgn<01@1oWKT0
h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool0
000506IVOP3ko?d0Z:Vk06IVOP1aKf@04`3oool00`3o[8<0ooC_0?ooo`0l
0?ooo`030?_no`1`i?l0oooo04L0oooo00<0nook08ooU03gooL0:03oool0
0`1oOgl0oooo0?ooo`0W0?ooo`030;_o_P1hogh0nook04P0oooo00<0Xngo
0<Odo`3oool0?03oool00`3oa:L0onCG0?ooo`0B0?ooo`050?7_hP3Pgn<0
h=oS0>3Oh`1aKf@00P3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08X0h=oS
00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`040?7_hP1VIWh0Z:Vk0?_l
o@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT01<0oooo00<0on;C0?no
W`3oool0?@3oool00`1hiOl0koco0?ooo`170?ooo`030?Oom`2?oi@0moog
02L0oooo00<0Ogmo0?ooo`3oool09P3oool00`2Ooj@0SonD0?ooo`190?oo
o`0306SRo`3oool0oooo03`0oooo00<0ojYo0?ooo`3oool04P3oool01@3a
kn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM
^@2:0>3Oh`0507nM^@3Pgn<0h=oS09bLWP3oool00P3Pgn<0103akn80IVIn
0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I00D0?ooo`03
0?nUN03oool0oooo03`0oooo00<0aoCo0:?]o`3oool0B03oool00`3gooL0
SonD0?Oom`0V0?ooo`0307moO`3oool0oooo02D0oooo00<0Qon=0:_o[`3o
ool0B@3oool00`3Cmol0Tn[o0?ooo`0m0?ooo`030?nZO`3oool0oooo0180
oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0509bLWP3oool0h=oS
0>3Oh`1oWKT0RP3Pgn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo0080h=oS00@0
lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0
503oool00`3oZ7`0ooC_0?ooo`0m0?ooo`0306cSo`3oool0oooo04P0oooo
00<0moog07SoOP37olX09@3oool00`1oOgl0oooo0?ooo`0S0?ooo`030?_o
n`1`ogL0_oo204/0oooo00<0N>Go0>Ojo`3oool0?03oool00`3om>l0okB?
0?ooo`0C0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<01@2LW9h0
oooo0>3Oh`3Pgn<0Oifi08X0h=oS00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`02
0>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1V
IWh0LFmT01@0oooo00<0om[70?o:[`3oool0?@3oool00`23iol0ho[o0?oo
o`1:0?ooo`030:?oY`1/og<0dooE02<0oooo00<0Ogmo0?ooo`3oool08P3o
ool00`3_oo00I?m[0=Oof@1;0?ooo`030?Omo`1/hol0oooo03d0oooo00<0
olbc0?oLb`3oool04`3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS
00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2:0>3Oh`0507nM^@3Pgn<0h=oS09bL
WP3oool00P3Pgn<0103akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_l
o@2XZK/0IVIn075_I00E0?ooo`030?nZO`3oool0oooo03`0oooo00<0doOo
09?Zo`3oool0B`3oool0103koo/0WonT07ooQ@3coo@Q0?ooo`0307moO`3o
ool0oooo0240oooo00<0_oo206CoJ`3WonP0C03oool00`2OkOl0`o?o0?oo
o`0m0?ooo`030?n/P`3oo?/0oooo01<0oooo00D0lNoR0>3Oh`3Pgn<0h=oS
075_I0020>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0RP3Pgn<01@1oWKT0
h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool0
000506IVOP3ko?d0Z:Vk06IVOP1aKf@05@3oool00`3oZWl0oo[g0?ooo`0m
0?ooo`0306SRo`3oool0oooo04`0oooo00@0koo`08OoS@2Goi`0nook7`3o
ool00`1oOgl0oooo0?ooo`0O0?ooo`040=_og@1`ogL0XonW0?_ondd0oooo
00<0I>7o0?_no`3oool0?@3oool00`3oZWl0oooo0?ooo`0C0?ooo`050?7_
hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi
08X0h=oS00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`040?7_hP1VIWh0
Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT01D0oooo00<0
omO30?o?]`3oool0?@3oool00`27j?l0foSo0?ooo`1>0?ooo`040>?oi023
ohT0VonP0?_onad0oooo00<0Ogmo0?ooo`3oool07@3oool0103[on`0N?mn
07ooQ@3gooM>0?ooo`030:?]o`2[kol0oooo03d0oooo00<0ooOc0?ndS`3o
ool0503oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00D0W9bN0?oo
o`3Pgn<0h=oS07nM^@2:0>3Oh`0507nM^@3Pgn<0h=oS09bLWP3oool00P3P
gn<0103akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn
075_I00F0?ooo`030?nZO`3oool0oooo03`0oooo00<0ho[o08?Wo`3oool0
D03oool0103;old0I?m[09OoW03coo@K0?ooo`0307moO`3oool0oooo01/0
oooo00@0moog08OoS@1`ogL0hooTC`3oool00`3ko_l0H>3o0?ooo`0n0?oo
o`030?oG``3od[/0oooo01@0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I002
0>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0RP3Pgn<01@1oWKT0h=oS0>3O
h`2LW9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool0000506IV
OP3ko?d0Z:Vk06IVOP1aKf@05P3oool00`3oZWl0oock0?ooo`0m0?ooo`03
06cSo`3goOl0oooo0540oooo00@0`oo6073oM`27ohd0joo/6@3oool00`1o
Ogl0oooo0?ooo`0J0?ooo`0309ooY01`ogL0cooA0540oooo00<0Tn[o0<?c
o`3oool0?P3oool00`3o[hL0oo[g0?ooo`0D0?ooo`050?7_hP3Pgn<0h=oS
0>3Oh`1aKf@00P3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08X0h=oS00D0
Oifi0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40
oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT01H0oooo00<0om:k0?oG``3o
ool0?@3oool00`3Kn?l0PnOo0?ooo`1C0?ooo`040=ooh@1loh80M?mk0=Oo
fAL0oooo00<0Ogmo0?ooo`3oool05`3oool0103Komd0Qon=06coL`2kokiB
0?ooo`030?Omo`1di?l0oooo03l0oooo00<0ojYo0?ooo`3oool0503oool0
1@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00D0W9bN0?ooo`3Pgn<0h=oS
07nM^@2:0>3Oh`0507nM^@3Pgn<0h=oS09bLWP3oool00P3Pgn<0103akn80
IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I00F0?oo
o`030?ojm`3oZWl0oooo03h0oooo00<0RnWo0<ofo`3oool0E03oool01@3_
oo00Ron@06SoK`2kokh0nook01@0oooo00<0Ogmo0?ooo`3oool0503oool0
1@3Komd0Pon906SoK`2?oi@0gooQ05@0oooo00<0PnOo0<ofo`3oool0?P3o
ool00`3on_L0ok:;0?ooo`0E0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@0
0P3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08X0h=oS00D0Oifi0>3Oh`3P
gn<0W9bN0?ooo`020>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1V
IWh0nocm0:RY^`1VIWh0LFmT01L0oooo00<0ojYo0?oln`3oool0?@3oool0
0`3ko_l0H>3o0?_no`1F0?ooo`050?_on`2Woj/0K?mc07coPP3?om404P3o
ool00`1oOgl0oooo0?ooo`0A0?ooo`050=_og@2;oi00L?mg08ooU03Oon40
EP3oool00`3[nol0N>Go0?ooo`0o0?ooo`030?oLb`3oc;<0oooo01D0oooo
00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0509bLWP3oool0h=oS0>3O
h`1oWKT0RP3Pgn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR
06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@05`3o
ool00`3oaj/0omc;0?ooo`0n0?ooo`030<ofo`2Gjol0oooo05P0oooo00D0
iooX09_oX01/og<0Pon90<ood@0?0?ooo`0307moO`3oool0oooo00`0oooo
00L0moog0<ood@2SojL0Oon506coL`2;oi00hooT05T0oooo00<0N>Go0=oi
o`3oool0?`3oool00`3o]8l0ooC_0?ooo`0E0?ooo`050?7_hP3Pgn<0h=oS
0>3Oh`1aKf@00P3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08X0h=oS00D0
Oifi0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40
oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT01L0oooo00<0ooC_0?n/P`3o
ool0?`3oool00`1oi_l0ho[o0?ooo`1J0?ooo`060>Ooj02Koj00K?mc07oo
Q@3ComD0nook2`3oool00`1oOgl0oooo0?ooo`070?ooo`030>Ooj02gokX0
Ron@0080Oon500<0Qon=0:oo/`3Oon40G03oool00`3OnOl0O>Ko0?ooo`10
0?ooo`030?nMK03oool0oooo01D0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_
I0020>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0RP3Pgn<01@1oWKT0h=oS
0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool00005
06IVOP3ko?d0Z:Vk06IVOP1aKf@0603oool00`3oYGP0oooo0?ooo`0n0?oo
o`030?Omo`1di?l0oooo05d0oooo00<0joo/09OoW01`ogL00`1oohD0102G
oi`0/ong0<ood@3WonP40?ooo`0607moO`3koo/0hooT0<?oaP2SojL0TonH
101oohD00`2Goi`0aoo:0??om01Q0?ooo`0306SRo`3[nol0oooo03l0oooo
00<0omO30?o2X`3oool05P3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080
h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2:0>3Oh`0507nM^@3Pgn<0h=oS
09bLWP3oool00P3Pgn<0103akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn
0?_lo@2XZK/0IVIn075_I00H0?ooo`030?ngT`3oj]l0oooo03l0oooo00<0
]o7o0:o`o`3oool0HP3oool0103WonP0boo=0:oo/`2Goi`407ooQ@0603no
A@23ohT0VonP0;_o_P3Komd0joo/I`3oool00`3Cmol0PnOo0?ooo`100?oo
o`030?nMK03omo<0oooo01H0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I002
0>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0RP3Pgn<01@1oWKT0h=oS0>3O
h`2LW9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool0000506IV
OP3ko?d0Z:Vk06IVOP1aKf@0603oool00`3ok><0ojn70?ooo`100?ooo`03
07SUo`3_o?l0oooo06T0oooo00<0Ogmo0?ooo`3oool0JP3oool00`1Xh_l0
koco0?ooo`0o0?ooo`030?oOc`3o]8l0oooo01L0oooo00D0lNoR0>3Oh`3P
gn<0h=oS075_I0020>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0RP3Pgn<0
1@1oWKT0h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0nocm
0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@06@3oool00`3oWF`0oooo
0?ooo`0o0?ooo`030>olo`1Xh_l0noko06T0oooo00<0Ogmo0?ooo`3oool0
J@3oool00`37m?l0Un_o0?ooo`100?ooo`030?nRM03omo<0oooo01L0oooo
00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0509bLWP3oool0h=oS0>3O
h`1oWKT0RP3Pgn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR
06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@06@3o
ool00`3o`Z<0omBo0?ooo`100?ooo`030:__o`2cl?l0oooo06P0oooo00<0
Ogmo0?ooo`3oool0J@3oool00`1Lh?l0logo0?ooo`0o0?ooo`030?o_i`3o
YGP0oooo01P0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0509bL
WP3oool0h=oS0>3Oh`1oWKT0RP3Pgn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo
0080h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk
06IVOP1aKf@06@3oool00`3oo?/0oie/0?ooo`110?ooo`03073To`3_o?l0
oooo06L0oooo00<0Ogmo0?ooo`3oool0J03oool00`2glOl0Wngo0?ooo`10
0?ooo`030?nXO03ok><0oooo01P0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_
I0020>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0RP3Pgn<01@1oWKT0h=oS
0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool00005
06IVOP3ko?d0Z:Vk06IVOP1aKf@06P3oool00`3oZ7`0oncS0?ooo`100?oo
o`030=oio`1li_l0oooo06L0oooo00<0Ogmo0?ooo`3oool0I`3oool00`3_
o?l0G>3o0?_no`100?ooo`030?ojm`3oXW@0oooo01T0oooo00D0lNoR0>3O
h`3Pgn<0h=oS075_I0020>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0RP3P
gn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0
nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@06P3oool00`3ok><0
ojYo0?ooo`110?ooo`0309O[o`37m?l0oooo0080oooo00<0[o3o0?_no`3o
ool0H@3oool00`1oOgl0oooo0?ooo`1W0?ooo`0306cSo`3OnOl0oooo0400
oooo00<0okNC0?oLb`3oool06@3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT
0080h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2:0>3Oh`0507nM^@3Pgn<0
h=oS09bLWP3oool00P3Pgn<0103akn80IVIn0:RY^`3ko?d10?ooo`0000D0
IVIn0?_lo@2XZK/0IVIn075_I00K0?ooo`030?nMK03oo?/0oooo0400oooo
00<0noko06CQo`3coOl00P3oool00`18g?l0]o7o0?ooo`1Q0?ooo`0307mo
O`3oool0oooo06H0oooo00<0OnKo0=Ogo`3oool0@03oool00`3on_L0oiYX
0?ooo`0J0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<01@2LW9h0
oooo0>3Oh`3Pgn<0Oifi08X0h=oS00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`02
0>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1V
IWh0LFmT01/0oooo00<0omBo0?o2X`3oool0@@3oool01P3Kn?l0O>Ko0?oo
o`3oool06=?o04SLoe00oooo00P0Zj^[04Q8B00h>3P0L71`0??cl`3oool0
820P0>?Sh`<0oooo00<0Zj^[07AdM03oool0103oool00`1oOgl0oooo0?oo
o`1U0?ooo`030:?]o`2Wk_l0oooo0440oooo00<0ol:S0?oG``3oool06P3o
ool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00D0W9bN0?ooo`3Pgn<0
h=oS07nM^@2:0>3Oh`0507nM^@3Pgn<0h=oS09bLWP3oool00P3Pgn<0103a
kn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I00L
0?ooo`030?nHI03oool0oooo0440oooo00<0Un_o0;Oao`3Cmol00P00c_l0
0`3Kn?l0oooo0?ooo`1<0?ooo`090=oOg`0T92@0lo?c0?ooo`10@400[jn_
0?ooo`2o_kl0moOg00<0oooo00<0WinO061PH03oool0103oool00`1oOgl0
oooo0?ooo`1T0?ooo`030;oco`1oi_l0oooo0480oooo00<0oiQT0?oln`3o
ool06P3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00D0W9bN0?oo
o`3Pgn<0h=oS07nM^@2:0>3Oh`0507nM^@3Pgn<0h=oS09bLWP3oool00P3P
gn<0103akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn
075_I00L0?ooo`030?njU`3ogll0oooo0480oooo00D0K>?o08?Wo`00c_l0
0<ko073To`1>0?ooo`060:>SX`1HF5P0oooo0?ooo`2?Shl0L71`0`3oool0
1P14A4@061PH020P800D51@030`<07AdM0@0oooo00<0Ogmo0?ooo`3oool0
H`3oool00`3OnOl0N>Go0?ooo`120?ooo`030?o</`3oaj/0oooo01/0oooo
00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0509bLWP3oool0h=oS0>3O
h`1oWKT0RP3Pgn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR
06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0703o
ool00`3omo<0oj1`0?ooo`110?ooo`030>_ko`3Am_l07]Co00800<ko00<0
3=3o0??mo`3oool0C03oool01P1oOgl0O7al0?ooo`3oool0WinO061PH0<0
oooo00D0^k^k06a/K03oool0WinO061PH0050?ooo`0307moO`3oool0oooo
0680oooo00<0jo_o05cPo`3ko_l0@`3oool00`3oWF`0oock0?ooo`0K0?oo
o`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<01@2LW9h0oooo0>3Oh`3P
gn<0Oifi08X0h=oS00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`040?7_
hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT01d0
oooo00<0oj9d0?odk`3oool0?03oool00`3Gmol0>=Wo003>o`07003>o`03
09O[o`3oool0oooo04/0oooo00H0Ph>307alO03oool0oooo09nOW`1PH604
0?ooo`04071`L02[Zj/0WinO061PH0D0oooo00<0Ogmo0?ooo`3oool0H@3o
ool00`3ko_l0M>Co0>_ko`130?ooo`030?oOc`3o]8l0oooo01`0oooo00D0
lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0509bLWP3oool0h=oS0>3Oh`1o
WKT0RP3Pgn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IV
OP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@07@3oool0
0`3oi=L0okB?0?ooo`0m0?ooo`030?Omo`1hiOl02=3o00H00<ko00<0:=Ko
0?ooo`3oool0B`3oool01P2SXj<0F5QH0?ooo`3oool0Shn?07QhN0@0oooo
00@0moOg03`l?02;Rh/0H61P0`3oool01@2OWil0Ogmo03lo?`1oOgl0WinO
0640oooo00<0QnSo0>?jo`3oool0@`3oool00`3oWF`0ooOc0?ooo`0L0?oo
o`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<01@2LW9h0oooo0>3Oh`3P
gn<0Oifi08X0h=oS00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`040?7_
hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT01h0
oooo00<0oiYX0?oln`3oool0?P3oool00`3;mOl0;=Ko003>o`05003>o`03
0;_bo`3oool0oooo04X0oooo00H0gmoO020P803clo<0oooo04a<C02g]kL5
0?ooo`030;no_`0D51@0H61P00D0oooo00<0Ogmo0?ooo`3oool0H03oool0
0`2;jOl0[o3o0?ooo`130?ooo`030?oZg`3o[hL0oooo01d0oooo00D0lNoR
0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0
RP3Pgn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IVOP2X
ZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@07P3oool00`3o
bZl0olbc0?ooo`0o0?ooo`030?Omo`1hiOl02=3o00@00<ko00<0F=oo0?oo
o`3oool0B`3oool0102;Rh/0=3@d03`l?01oOgl70?ooo`0307AdM01PH600
oooo00@0oooo00<0Ogmo0?ooo`3oool0G`3oool00`2kl_l0Vnco0?ooo`14
0?ooo`030?nXO03ok><0oooo01d0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_
I0020>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0RP3Pgn<01@1oWKT0h=oS
0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool00005
06IVOP3ko?d0Z:Vk06IVOP1aKf@07`3oool00`3oWF`0oooo0?ooo`100?oo
o`030=Ogo`14fol00<ko00800<ko00<01<oo0=_ho`3oool0G@3oool00`1o
Ogl0oooo0?ooo`1N0?ooo`030=_ho`27j?l0oooo04@0oooo00<0onoW0?nU
N03oool07P3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00D0W9bN
0?ooo`3Pgn<0h=oS07nM^@2:0>3Oh`0507nM^@3Pgn<0h=oS09bLWP3oool0
0P3Pgn<0103akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0
IVIn075_I00O0?ooo`030?n/P`3oim/0oooo0480oooo00D0Un_o01CBo`00
c_l00<ko07cVo`1N0?ooo`0307moO`3oool0oooo05d0oooo00<0koco07oV
o`3ko_l0A@3oool00`3o[8<0on[O0?ooo`0N0?ooo`050?7_hP3Pgn<0h=oS
0>3Oh`1aKf@00P3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08X0h=oS00D0
Oifi0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40
oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT01l0oooo00<0oo;[0?nUN03o
ool0@`3oool0203Sn_l0E=ko003>o`09d?l02m3o00S@o`1`i?l0logoFP3o
ool00`1oOgl0oooo0?ooo`1M0?ooo`0307SUo`3coOl0oooo04@0oooo00<0
oo[g0?nJJ03oool07`3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS
00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2:0>3Oh`0507nM^@3Pgn<0h=oS09bL
WP3oool00P3Pgn<0103akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_l
o@2XZK/0IVIn075_I00P0?ooo`030?nRM03omo<0oooo04@0oooo00<0AM_o
003>o`00c_l00P00c_l00`1`i?l0oooo0?ooo`1H0?ooo`0307moO`3oool0
oooo05`0oooo00<0RnWo0>_ko`3oool0A@3oool00`3o]i<0omc;0?ooo`0O
0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<01@2LW9h0oooo0>3O
h`3Pgn<0Oifi08X0h=oS00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`04
0?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT
0200oooo00<0omc;0?njU`3oool0A03oool00`0<d?l00<ko003>o`02003>
o`0300S@o`3oool0oooo05P0oooo00<0Ogmo0?ooo`3oool0F`3oool00`2G
jol0foSo0?ooo`160?ooo`030?nJJ03oool0oooo01l0oooo00D0lNoR0>3O
h`3Pgn<0h=oS075_I0020>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0RP3P
gn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0
nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@08@3oool00`3oV6@0
oock0?ooo`130?ooo`0300c@o`00c_l00<ko00800<ko00<02=3o0?ooo`3o
ool0F03oool00`1oOgl0oooo0?ooo`1J0?ooo`0309_/o`3Cmol0oooo04H0
oooo00<0olbc0?o7Z`3oool0803oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT
0080h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2:0>3Oh`0507nM^@3Pgn<0
h=oS09bLWP3oool00P3Pgn<0103akn80IVIn0:RY^`3ko?d10?ooo`0000D0
IVIn0?_lo@2XZK/0IVIn075_I00Q0?ooo`030?oLb`3o^YL0oooo04<0oooo
00<0N>Go003>o`00c_l00P00c_l00`1`i?l0oooo0?ooo`1H0?ooo`0307mo
O`3oool0oooo05T0oooo00<0Ynko0<_eo`3oool0A`3oool00`3oVVP0oock
0?ooo`0P0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<01@2LW9h0
oooo0>3Oh`3Pgn<0Oifi08X0h=oS00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`02
0>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1V
IWh0LFmT0280oooo00<0ojYo0?obj`3oool0@P3oool01P3ko_l0N>Go00c@
o`08d?l0L>Co0??moeX0oooo00<0Ogmo0?ooo`3oool0F03oool00`2kl_l0
]o7o0?ooo`170?ooo`030?o7Z`3ogll0oooo0240oooo00D0lNoR0>3Oh`3P
gn<0h=oS075_I0020>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0RP3Pgn<0
1@1oWKT0h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0nocm
0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@08P3oool00`3om>l0ojQl
0?ooo`2R0?ooo`0307moO`3oool0oooo05L0oooo00<0`o?o0:__o`3oool0
A`3oool00`3om>l0okB?0?ooo`0R0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1a
Kf@00P3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08X0h=oS00D0Oifi0>3O
h`3Pgn<0W9bN0?ooo`020>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo0000
1@1VIWh0nocm0:RY^`1VIWh0LFmT02<0oooo00<0olBW0?oOc`3oool0X@3o
ool00`1oOgl0oooo0?ooo`1F0?ooo`030<ofo`2_l?l0oooo04P0oooo00<0
okZG0?ogl`3oool08P3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS
00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2:0>3Oh`0507nM^@3Pgn<0h=oS09bL
WP3oool00P3Pgn<0103akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_l
o@2XZK/0IVIn075_I00T0?ooo`030?nUN03oool0oooo0:00oooo00<0Ogmo
0?ooo`3oool0E@3oool00`3Sn_l0Xngo0?ooo`180?ooo`030?oRd`3ockL0
oooo02<0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0509bLWP3o
ool0h=oS0>3Oh`1oWKT0RP3Pgn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo0080
h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IV
OP1aKf@0903oool00`3oel<0omBo0?ooo`2P0?ooo`0307moO`3oool0oooo
05@0oooo00<0io[o09_/o`3oool0B03oool00`3oo?/0ojYo0?ooo`0T0?oo
o`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<01@2LW9h0oooo0>3Oh`3P
gn<0Oifi08X0h=oS00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`040?7_
hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT02D0
oooo00<0ojQl0?ogl`3oool0W`3oool00`1oOgl0oooo0?ooo`1C0?ooo`03
0>olo`2Cj_l0oooo04T0oooo00<0oknO0?oZg`3oool0903oool01@3akn80
h=oS0>3Oh`3Pgn<0LFmT0080h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2:
0>3Oh`0507nM^@3Pgn<0h=oS09bLWP3oool00P3Pgn<0103akn80IVIn0:RY
^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I00U0?ooo`030?ob
j`3o]i<0oooo09l0oooo00<0Ogmo0?ooo`3oool0DP3oool00`3goOl0Tn[o
0?_no`190?ooo`030?obj`3o/X/0oooo02D0oooo00D0lNoR0>3Oh`3Pgn<0
h=oS075_I0020>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0RP3Pgn<01@1o
WKT0h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0nocm0@3o
ool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@09P3oool00`3o^YL0onCG0?oo
o`2N0?ooo`0307moO`3oool0oooo0540oooo00<0io[o07cVo`3goOl0BP3o
ool00`3oZ7`0oock0?ooo`0U0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@0
0P3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08X0h=oS00D0Oifi0>3Oh`3P
gn<0W9bN0?ooo`020>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1V
IWh0nocm0:RY^`1VIWh0LFmT02H0oooo00<0oo[g0?nUN03oool0WP3oool0
0`1oOgl0oooo0?ooo`1@0?ooo`030;_bo`23iol0noko04X0oooo00<0om[7
0?o7Z`3oool09P3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00D0
W9bN0?ooo`3Pgn<0h=oS07nM^@2:0>3Oh`0507nM^@3Pgn<0h=oS09bLWP3o
ool00P3Pgn<0103akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2X
ZK/0IVIn075_I00W0?ooo`030?oB^`3obZl0oooo09d0oooo00<0Ogmo0?oo
o`3oool0C`3oool00`2;jOl0Xngo0?ooo`1:0?ooo`030?oln`3oX700oooo
02L0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0509bLWP3oool0
h=oS0>3Oh`1oWKT0RP3Pgn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo0080h=oS
00@0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1a
Kf@0:03oool00`3oXW@0oo[g0?ooo`2L0?ooo`0307moO`3oool0oooo04d0
oooo00<0logo073To`3;mOl0C03oool00`3o]i<0on[O0?ooo`0W0?ooo`05
0?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0
Oifi08X0h=oS00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`040?7_hP1V
IWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT02P0oooo
00<0onOK0?ndS`3oool0W03oool00`1oOgl0oooo0?ooo`1<0?ooo`030>Oj
o`1hiOl0io[o04`0oooo00<0on[O0?nbR`3oool0:03oool01@3akn80h=oS
0>3Oh`3Pgn<0LFmT0080h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2:0>3O
h`0507nM^@3Pgn<0h=oS09bLWP3oool00P3Pgn<0103akn80IVIn0:RY^`3k
o?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I00Y0?ooo`030?nZO`3o
im/0oooo09/0oooo00<0Ogmo0?ooo`3oool0B`3oool00`2glOl0QnSo0?oo
o`1=0?ooo`030?nRM03omo<0oooo02P0oooo00D0lNoR0>3Oh`3Pgn<0h=oS
075_I0020>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0RP3Pgn<01@1oWKT0
h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool0
000506IVOP3ko?d0Z:Vk06IVOP1aKf@0:@3oool00`3om>l0oj9d0?ooo`2K
0?ooo`0307moO`3oool0oooo04T0oooo00<0noko08OXo`2Wk_l0CP3oool0
0`3oaj/0omBo0?ooo`0Y0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3P
gn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08X0h=oS00D0Oifi0>3Oh`3Pgn<0
W9bN0?ooo`020>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0
nocm0:RY^`1VIWh0LFmT02X0oooo00<0ol:S0?o?]`3oool0VP3oool00`1o
Ogl0oooo0?ooo`180?ooo`030>Ojo`1Hgol0doOo04h0oooo00<0oo[g0?nU
N03oool0:P3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00D0W9bN
0?ooo`3Pgn<0h=oS07nM^@2:0>3Oh`0507nM^@3Pgn<0h=oS09bLWP3oool0
0P3Pgn<0103akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0
IVIn075_I00[0?ooo`030?nHI03om>l0oooo09T0oooo00<0Ogmo0?ooo`3o
ool0A`3oool00`2olol0K>?o0>olo`1?0?ooo`030?n/P`3oj]l0oooo02X0
oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0509bLWP3oool0h=oS
0>3Oh`1oWKT0RP3Pgn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo0080h=oS00@0
lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0
:`3oool00`3ol^/0oj1`0?ooo`2I0?ooo`0307moO`3oool0oooo04H0oooo
00<0Ynko09_/o`3oool0C`3oool00`3oh]<0okB?0?ooo`0[0?ooo`050?7_
hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi
08X0h=oS00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`040?7_hP1VIWh0
Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT02`0oooo00<0
omO30?o2X`3oool0V03oool00`1oOgl0oooo0?ooo`140?ooo`030?_no`1d
i?l0/o3o0540oooo00<0oie/0?ooo`3oool0:`3oool01@3akn80h=oS0>3O
h`3Pgn<0LFmT0080h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2:0>3Oh`05
07nM^@3Pgn<0h=oS09bLWP3oool00P3Pgn<0103akn80IVIn0:RY^`3ko?d1
0?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I00]0?ooo`030?nbR`3of/L0
oooo09L0oooo00<0Ogmo0?ooo`3oool0@`3oool00`2olol0I>7o0=Ogo`1A
0?ooo`030?o4Y`3od[/0oooo02`0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_
I0020>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0RP3Pgn<01@1oWKT0h=oS
0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool00005
06IVOP3ko?d0Z:Vk06IVOP1aKf@0;@3oool00`3oo?/0ohY@0?o/h`2G0?oo
o`0307moO`3oool0oooo0440oooo00@0goWo073To`2SkOl0nokoD@3oool0
0`3om>l0oiYX0?ooo`0]0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3P
gn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08X0h=oS00D0Oifi0>3Oh`3Pgn<0
W9bN0?ooo`020>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0
nocm0:RY^`1VIWh0LFmT02h0oooo00<0ooC_0?nMK03oo?/0UP3oool00`1o
Ogl0oooo0?ooo`0o0?ooo`040?Omo`2Gjol0QnSo0?Omoe<0oooo00<0ojEh
0?obj`3oool0;@3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00D0
W9bN0?ooo`3Pgn<0h=oS07nM^@2:0>3Oh`0507nM^@3Pgn<0h=oS09bLWP3o
ool00P3Pgn<0103akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2X
ZK/0IVIn075_I00_0?ooo`030?oOc`3o^YL0oooo09D0oooo00<0Ogmo0?oo
o`3oool0?P3oool00`2Wk_l0OnKo0>?jo`1D0?ooo`030?oLb`3o/X/0oooo
02h0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0509bLWP3oool0
h=oS0>3Oh`1oWKT0RP3Pgn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo0080h=oS
00@0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1a
Kf@0<03oool00`3o[8<0om[70?ooo`2D0?ooo`0307moO`3oool0oooo03`0
oooo00<0boGo07cVo`3Cmol0E@3oool00`3omo<0oi9L0?oln`0_0?ooo`05
0?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0
Oifi08X0h=oS00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`040?7_hP1V
IWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT0340oooo
00<0oj9d0?obj`3oool0T`3oool00`1oOgl0oooo0?ooo`0j0?ooo`040=oi
o`1hiOl0Znoo0?_noeH0oooo00<0oie/0?o/h`3oool0;`3oool01@3akn80
h=oS0>3Oh`3Pgn<0LFmT0080h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2:
0>3Oh`0507nM^@3Pgn<0h=oS09bLWP3oool00P3Pgn<0103akn80IVIn0:RY
^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I00a0?ooo`030?ob
j`3oUF00oo[g09<0oooo00<0Ogmo0?ooo`3oool0>03oool0103coOl0RnWo
08oYo`3coOmG0?ooo`030?nbR`3of/L0oooo0300oooo00D0lNoR0>3Oh`3P
gn<0h=oS075_I0020>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0RP3Pgn<0
1@1oWKT0h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0nocm
0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0<P3oool00`3og</0ojQl
0?ooo`2B0?ooo`0307moO`3oool0oooo03L0oooo00<0Xngo06SRo`3OnOl0
F03oool00`3o_9/0olZ_0?ooo`0a0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1a
Kf@00P3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08X0h=oS00D0Oifi0>3O
h`3Pgn<0W9bN0?ooo`020>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo0000
1@1VIWh0nocm0:RY^`1VIWh0LFmT03<0oooo00<0okZG0?o</`3oool0T@3o
ool00`1oOgl0oooo0?ooo`0d0?ooo`040?Omo`2Gjol0J>;o0;_boeT0oooo
00<0om:k0?nbR`3oool0<P3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080
h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2:0>3Oh`0507nM^@3Pgn<0h=oS
09bLWP3oool00P3Pgn<0103akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn
0?_lo@2XZK/0IVIn075_I00d0?ooo`030?nMK03oi=L0oooo0900oooo00<0
Ogmo0?ooo`3oool0<P3oool0103Cmol0N>Go07CTo`3?m_mJ0?ooo`030?o_
i`3oYGP0oooo03<0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`05
09bLWP3oool0h=oS0>3Oh`1oWKT0RP3Pgn<01@1oWKT0h=oS0>3Oh`2LW9h0
oooo0080h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0
Z:Vk06IVOP1aKf@0=03oool00`3on_L0oiYX0?oln`2@0?ooo`0307moO`3o
ool0oooo02l0oooo00D0noko0:o`o`1/hol0Tn[o0>olo`1K0?ooo`030?od
k`3oX700oock03@0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`05
09bLWP3oool0h=oS0>3Oh`1oWKT0RP3Pgn<01@1oWKT0h=oS0>3Oh`2LW9h0
oooo0080h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0
Z:Vk06IVOP1aKf@0=@3oool00`3oi=L0ok:;0?ooo`1M0?ooo`0308OXo`2C
j_l0koco02l0oooo00<0Ogmo0?ooo`3oool0;@3oool01@3Wn_l0PnOo06cS
o`2glOl0noko05`0oooo00<0oo[g0?nHI03ol^/0=@3oool01@3akn80h=oS
0>3Oh`3Pgn<0LFmT0080h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2:0>3O
h`0507nM^@3Pgn<0h=oS09bLWP3oool00P3Pgn<0103akn80IVIn0:RY^`3k
o?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I00f0?ooo`030?o4Y`3o
bZl0oooo05d0oooo00@0coKo07SUo`1/hol0aoCo;@3oool00`1oOgl0oooo
0?ooo`0[0?ooo`040<?co`1`i?l0OnKo0=oioel0oooo00<0ojQl0?oTe`3o
ool0=@3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00D0W9bN0?oo
o`3Pgn<0h=oS07nM^@2:0>3Oh`0507nM^@3Pgn<0h=oS09bLWP3oool00P3P
gn<0103akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn
075_I00g0?ooo`030?nPL03oi=L0oooo05h0oooo00H0logo09o]o`1di?l0
QnSo0;oco`3goOlY0?ooo`0307moO`3oool0oooo02P0oooo00D0boGo08OX
o`1Xh_l0Xngo0?Omo`1P0?ooo`030?noW`3of/L0oooo03H0oooo00D0lNoR
0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0
RP3Pgn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IVOP2X
ZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0=`3oool00`3o
o?/0ojEh0?ogl`1Q0?ooo`060?Omo`2olol0QnSo06cSo`2[kol0noko9P3o
ool00`1oOgl0oooo0?ooo`0U0?ooo`050;Oao`1li_l0K>?o0:?]o`3_o?l0
HP3oool00`3od[/0olBW0?ooo`0g0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1a
Kf@00P3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08X0h=oS00D0Oifi0>3O
h`3Pgn<0W9bN0?ooo`020>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo0000
1@1VIWh0nocm0:RY^`1VIWh0LFmT03P0oooo00<0ooOc0?nZO`3on_L0I03o
ool0102cl?l0I>7o0:__o`3ko_lT0?ooo`0307moO`3oool0oooo0240oooo
00H0mogo0:?]o`1hiOl0N>Go0;_bo`3ko_mT0?ooo`030?oTe`3o[hL0oooo
03P0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0509bLWP3oool0
h=oS0>3Oh`1oWKT0RP3Pgn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo0080h=oS
00@0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1a
Kf@0>@3oool00`3om>l0oj1`0?ojm`1U0?ooo`050;?`o`1`i?l0QnSo0;oc
o`3goOl08@3oool00`1oOgl0oooo0?ooo`0N0?ooo`050>Ojo`2Gjol0O>Ko
08_Yo`3Cmol0I`3oool00`3ol^/0ojEh0?ooo`0i0?ooo`050?7_hP3Pgn<0
h=oS0>3Oh`1aKf@00P3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08X0h=oS
00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`040?7_hP1VIWh0Z:Vk0?_l
o@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT03X0oooo00<0on[O0?nJ
J03oo?/0IP3oool00`3goOl0_o?o08OXo`0207oVo`030;_bo`3coOl0oooo
01`0oooo00<0Ogmo0?ooo`3oool06P3oool01P3[nol0[o3o07oVo`1di?l0
SnWo0>OjofT0oooo00<0oo[g0?nRM03omo<0>P3oool01@3akn80h=oS0>3O
h`3Pgn<0LFmT0080h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2:0>3Oh`05
07nM^@3Pgn<0h=oS09bLWP3oool00P3Pgn<0103akn80IVIn0:RY^`3ko?d1
0?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I00k0?ooo`030?oOc`3oX700
oock06X0oooo00L0`o?o08_Yo`1oi_l0OnKo0:?]o`3Cmol0mogo01P0oooo
00<0Ogmo0?ooo`3oool05P3oool01`3Gmol0Vnco07oVo`1oi_l0Tn[o0<of
o`3ko_l0K03oool00`3oYGP0onoW0?ooo`0j0?ooo`050?7_hP3Pgn<0h=oS
0>3Oh`1aKf@00P3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08X0h=oS00D0
Oifi0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40
oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT03`0oooo00<0omBo0?nZO`3o
ool0K@3oool01`3Kn?l0Znoo08OXo`1oi_l0RnWo0;_bo`3goOl0503oool0
0`1oOgl0oooo0?ooo`0A0?ooo`030?Omo`33lol0RnWo0080OnKo00<0Ynko
0>?jo`3oool0K`3oool00`3o/X/0on;C0?ooo`0k0?ooo`050?7_hP3Pgn<0
h=oS0>3Oh`1aKf@00P3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08X0h=oS
00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`040?7_hP1VIWh0Z:Vk0?_l
o@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT03d0oooo00<0om:k0?o2
X`3oool0L03oool00`3coOl0`o?o08OXo`0507oVo`0609_/o`2[kol0_o?o
0=?go`3Sn_l0noko2@3oool00`1oOgl0oooo0?ooo`070?ooo`060>Ojo`3K
n?l0_o?o0:o`o`2OkOl0PnOo101oi_l00`27j?l0^o;o0??mo`1c0?ooo`03
0?o2X`3ockL0oooo03`0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3O
h`0509bLWP3oool0h=oS0>3Oh`1oWKT0RP3Pgn<01@1oWKT0h=oS0>3Oh`2L
W9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3k
o?d0Z:Vk06IVOP1aKf@0?P3oool00`3o`Z<0okbK0?ooo`1g0?ooo`060>?j
o`3Cmol0_o?o0:__o`2Kk?l0PnOo0P1oi_l00`23iol0OnKo07oVo`0407oV
o`0303nV_`1oi_l0OnKo00L0OnKo00H0Un_o0:?]o`2kl_l0coKo0=oio`3k
o_mi0?ooo`030?oB^`3o_9/0oooo03d0oooo00D0lNoR0>3Oh`3Pgn<0h=oS
075_I0020>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0RP3Pgn<01@1oWKT0
h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool0
000506IVOP3ko?d0Z:Vk06IVOP1aKf@0?`3oool00`3o_il0olng0?ooo`25
0?ooo`0307moO`3oool0oooo08D0oooo00<0on;C0?n/P`3oool0?P3oool0
1@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00D0W9bN0?ooo`3Pgn<0h=oS
07nM^@2:0>3Oh`0507nM^@3Pgn<0h=oS09bLWP3oool00P3Pgn<0103akn80
IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I0100?oo
o`030?njU`3oe;l0oooo08@0oooo00<0Ogmo0?ooo`3oool0Q03oool00`3o
m>l0oie/0?ooo`0o0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<0
1@2LW9h0oooo0>3Oh`3Pgn<0Oifi08X0h=oS00D0Oifi0>3Oh`3Pgn<0W9bN
0?ooo`020>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm
0:RY^`1VIWh0LFmT0440oooo00<0okNC0?oOc`3oool0P`3oool00`1oOgl0
oooo0?ooo`230?ooo`030?ogl`3oXW@0ooOc0400oooo00D0lNoR0>3Oh`3P
gn<0h=oS075_I0020>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0RP3Pgn<0
1@1oWKT0h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0nocm
0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0@P3oool00`3o]8l0on[O
0?ooo`220?ooo`0307moO`3oool0oooo0880oooo00<0onCG0?nRM03on_L0
@@3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00D0W9bN0?ooo`3P
gn<0h=oS07nM^@2:0>3Oh`0507nM^@3Pgn<0h=oS09bLWP3oool00P3Pgn<0
103akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_
I0130?ooo`030?nZO`3ok><0oooo0840oooo00<0Ogmo0?ooo`3oool0P@3o
ool00`3ogll0ojn70?oln`120?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@0
0P3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08X0h=oS00D0Oifi0>3Oh`3P
gn<0W9bN0?ooo`020>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1V
IWh0nocm0:RY^`1VIWh0LFmT04@0oooo00<0okB?0?ojm`3oool0P03oool0
0`1oOgl0oooo0?ooo`200?ooo`030?oD_`3o_il0oooo04<0oooo00D0lNoR
0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0
RP3Pgn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IVOP2X
ZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0A03oool00`3o
n_L0oj9d0?oWf`200?ooo`0307moO`3oool0oooo07l0oooo0P3oa:M50?oo
o`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<01@2LW9h0oooo0>3Oh`3P
gn<0Oifi08X0h=oS00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`040?7_
hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT04D0
oooo00<0oock0?nMK03oh]<0O`3oool00`1oOgl0oooo0?ooo`1n0?ooo`03
0?o4Y`3ockL0oooo04D0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3O
h`0509bLWP3oool0h=oS0>3Oh`1oWKT0RP3Pgn<01@1oWKT0h=oS0>3Oh`2L
W9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3k
o?d0Z:Vk06IVOP1aKf@0AP3oool00`3oo?/0oj9d0?o?]`1n0?ooo`0307mo
O`3oool0oooo07d0oooo00<0ojn70?oJa`3oool0AP3oool01@3akn80h=oS
0>3Oh`3Pgn<0LFmT0080h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2:0>3O
h`0507nM^@3Pgn<0h=oS09bLWP3oool00P3Pgn<0103akn80IVIn0:RY^`3k
o?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I0180?ooo`030?njU`3o
`Z<0oooo07`0oooo00<0Ogmo0?ooo`3oool0O03oool00`3o]8l0on[O0?oo
o`170?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<01@2LW9h0oooo
0>3Oh`3Pgn<0Oifi08X0h=oS00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`020>3O
h`040?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0
LFmT04T0oooo00<0olN[0?nbR`3oool0N`3oool00`1oOgl0oooo0?ooo`1j
0?ooo`030?oln`3oZWl0oo;[04T0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_
I0020>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0RP3Pgn<01@1oWKT0h=oS
0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool00005
06IVOP3ko?d0Z:Vk06IVOP1aKf@0BP3oool00`3ogll0ojQl0?ogl`1j0?oo
o`0307moO`3oool0oooo07T0oooo00<0ooC_0?nRM03ol^/0BP3oool01@3a
kn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM
^@2:0>3Oh`0507nM^@3Pgn<0h=oS09bLWP3oool00P3Pgn<0103akn80IVIn
0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I01;0?ooo`03
0?o/h`3oXW@0oo[g07T0oooo00<0Ogmo0?ooo`3oool0N03oool00`3oknL0
ojb30?ojm`1;0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<01@2L
W9h0oooo0>3Oh`3Pgn<0Oifi08X0h=oS00D0Oifi0>3Oh`3Pgn<0W9bN0?oo
o`020>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY
^`1VIWh0LFmT04`0oooo00<0onoW0?nMK03oim/0N03oool00`1oOgl0oooo
0?ooo`1g0?ooo`030?oTe`3o_9/0oooo04`0oooo00D0lNoR0>3Oh`3Pgn<0
h=oS075_I0020>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0RP3Pgn<01@1o
WKT0h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0nocm0@3o
ool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0C@3oool00`3on_L0oj9d0?oT
e`1g0?ooo`0307moO`3oool0oooo07H0oooo00<0omo?0?o2X`3oool0C@3o
ool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00D0W9bN0?ooo`3Pgn<0
h=oS07nM^@2:0>3Oh`0507nM^@3Pgn<0h=oS09bLWP3oool00P3Pgn<0103a
kn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I01?
0?ooo`030?n/P`3ockL0oooo07D0oooo00<0Ogmo0?ooo`3oool0M@3oool0
0`3oe;l0olBW0?ooo`1>0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3P
gn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08X0h=oS00D0Oifi0>3Oh`3Pgn<0
W9bN0?ooo`020>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0
nocm0:RY^`1VIWh0LFmT0500oooo00<0okB?0?o2X`3oool0M03oool00`1o
Ogl0oooo0?ooo`1d0?ooo`030?o7Z`3oe;l0oooo04l0oooo00D0lNoR0>3O
h`3Pgn<0h=oS075_I0020>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0RP3P
gn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0
nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0D@3oool00`3ockL0
ojn70?oln`1c0?ooo`0307moO`3oool0oooo07<0oooo00<0olBW0?oOc`3o
ool0D03oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00D0W9bN0?oo
o`3Pgn<0h=oS07nM^@2:0>3Oh`0507nM^@3Pgn<0h=oS09bLWP3oool00P3P
gn<0103akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn
075_I01B0?ooo`030?oB^`3oYGP0oock0780oooo00<0Ogmo0?ooo`3oool0
LP3oool00`3o_9/0onoW0?ooo`1A0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1a
Kf@00P3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08X0h=oS00D0Oifi0>3O
h`3Pgn<0W9bN0?ooo`020>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo0000
1@1VIWh0nocm0:RY^`1VIWh0LFmT05<0oooo00<0on;C0?nHI03oknL0L@3o
ool00`1oOgl0oooo0?ooo`1a0?ooo`030?ndS`3oj]l0oooo0580oooo00D0
lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0509bLWP3oool0h=oS0>3Oh`1o
WKT0RP3Pgn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IV
OP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0E03oool0
0`3om>l0oiQT0?oOc`1`0?ooo`0307moO`3oool0oooo06l0oooo00<0on;C
0?nRM03om>l0E03oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00D0
W9bN0?ooo`3Pgn<0h=oS07nM^@2:0>3Oh`0507nM^@3Pgn<0h=oS09bLWP3o
ool00P3Pgn<0103akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2X
ZK/0IVIn075_I01E0?ooo`040?ojm`3o[hL0oknO0?olnfh0oooo00<0Ogmo
0?ooo`3oool0K@3oool0103oo?/0okZG0?nbR`3omo=E0?ooo`050?7_hP3P
gn<0h=oS0>3Oh`1aKf@00P3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08X0
h=oS00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`040?7_hP1VIWh0Z:Vk
0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT05L0oooo00<0omo?
0?nBG03ogll0K@3oool00`1oOgl0oooo0?ooo`1/0?ooo`030?oWf`3oTU`0
om[705L0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0509bLWP3o
ool0h=oS0>3Oh`1oWKT0RP3Pgn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo0080
h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IV
OP1aKf@0F03oool0103oo?/0ojQl0?nlV`3oo?]I0?ooo`0>0:^[Z`18B4P0
>3Ph071`L03clo<0oooo020P803Shn<0oooo08N7Q`0/;2`0?3`l051@D03[
jn/40?ooo`0307moO`3oool0oooo06/0oooo00<0okB?0?nRM03oo?/0F03o
ool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00@0W9bN0?ooo`3Pgn<0
h=oSS01oWKT20>3Oh`0809bLWP3oool0h=oS0>3Oh`3akn80IVIn0:RY^`3k
o?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I01J0?ooo`030?oLb`3o
WF`0onoW05L0oooo00l0gmoO02@T903clo<0oooo0410@02_[jl0oooo0;no
_`3gmoL0^k^k0410@03kno/0oooo07moO`1PH600103oool00`1oOgl0oooo
0?ooo`1Y0?ooo`030?o_i`3oV6@0olng05X0oooo00D0lNoR0>3Oh`3Pgn<0
h=oS075_I0020>3Oh`0309bLWP3oool0h=oS08l0h=oS00P0W9bN0?ooo`3P
gn<0h=oS0?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1V
IWh0LFmT05/0oooo00@0ooOc0?nUN03obZl0oockE@3oool01P2SXj<0F5QH
0?ooo`3oool0Shn?071`L0<0oooo0P1oOgl20?ooo`030;no_`10@400oooo
00<0oooo00<0Ogmo0?ooo`3oool0J03oool00`3o_il0oie/0?odk`1K0?oo
o`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<00`2LW9h0oooo0>3Oh`2?
0>3Oh`0809bLWP3oool0h=oS0>3Oh`3akn80IVIn0:RY^`3ko?d10?ooo`00
00D0IVIn0?_lo@2XZK/0IVIn075_I01M0?ooo`030?oD_`3oV6@0onoW05@0
oooo00H0Ogmo07alO03oool0oooo09nOW`1PH6030?ooo`060;no_`0/;2`0
inOW0?Ogm`1@D500Vi^K103oool00`1oOgl0oooo0?ooo`1V0?ooo`030?oZ
g`3oT5P0omBo05d0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`03
09bLWP3oool0h=oS08l0h=oS00P0W9bN0?ooo`3Pgn<0h=oS0?7_hP1VIWh0
Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT05h0oooo00<0
oo;[0?nXO03ockL0D`3oool01P23Ph<0O7al0?ooo`3oool0WinO061PH0@0
oooo00D0I6AT02PX:00`<300A4A40?_kn`040?ooo`0307moO`3oool0oooo
06D0oooo00<0olN[0?nPL03ok><0GP3oool01@3akn80h=oS0>3Oh`3Pgn<0
LFmT0080h=oS00<0W9bN0?ooo`3Pgn<0S`3Pgn<0202LW9h0oooo0>3Oh`3P
gn<0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1a
Kf@0H03oool00`3o_il0oj9d0?obj`1A0?ooo`060:>SX`1HF5P0oooo0?oo
o`2?Shl0N7Qh0`3oool01P3[jn/0;2`/0??cl`3oool0A4A40:^[Z`80oooo
00D0WinO07moO`0o?cl0Ogmo09nOW`1S0?ooo`030?o_i`3oWF`0olN[0600
oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0309bLWP3oool0h=oS
08l0h=oS00P0W9bN0?ooo`3Pgn<0h=oS0?7_hP1VIWh0Z:Vk0?_lo@40oooo
00001@1VIWh0nocm0:RY^`1VIWh0LFmT0640oooo00<0oo;[0?nRM03oe;l0
D03oool01P3Ogml0820P0??cl`3oool0C4a<0;Ng]`<0oooo00H0hn?S02PX
:03clo<0oooo04A4A02OWil40?ooo`0307moO`3oool0oooo0680oooo00<0
om:k0?nMK03ol^/0H@3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS
00<0W9bN0?ooo`3Pgn<0S`3Pgn<0202LW9h0oooo0>3Oh`3Pgn<0lNoR06IV
OP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0H`3oool0
0`3o^YL0oj9d0?oln`1?0?ooo`0408^;R`0d=3@0?3`l07moO`D0oooo00D0
O7al03Ph>00d=3@0G5aL0?Ogm`040?ooo`0307moO`3oool0oooo0600oooo
00<0oock0?nUN03o_il0H`3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080
h=oS00<0W9bN0?ooo`3Pgn<0S`3Pgn<0202LW9h0oooo0>3Oh`3Pgn<0lNoR
06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0I03o
ool00`3oj]l0oiYX0?o?]`1P0?ooo`0307moO`3oool0oooo05l0oooo00<0
omc;0?nXO03ok><0I03oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS
00<0W9bN0?ooo`3Pgn<0S`3Pgn<0202LW9h0oooo0>3Oh`3Pgn<0lNoR06IV
OP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0IP3oool0
0`3oaj/0oiQT0?oLb`1N0?ooo`0307moO`3oool0oooo05d0oooo00@0ooOc
0?nPL03o^YL0oockI@3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS
00<0W9bN0?ooo`3Pgn<0103Pgn<00`000000h=oS0>3Oh`040>3Oh`800000
00@0h=oS0000003Pgn<00000103Pgn<2000000040>3Oh`000000h=oS0000
0080h=oS00@000000>3Oh`3Pgn<000000P3Pgn<300000080h=oS0P000002
0>3Oh`<000000P3Pgn<00`000000h=oS0>3Oh`020>3Oh`<00000EP3Pgn<0
202LW9h0oooo0>3Oh`3Pgn<0lNoR06IVOP2XZK/0nocm0@3oool0000506IV
OP3ko?d0Z:Vk06IVOP1aKf@0I`3oool0103omo<0ojYo0?nPL03om>mL0?oo
o`0307moO`3oool0oooo05`0oooo00<0om[70?n@F03oi=L0I`3oool01@3a
kn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00<0W9bN0?ooo`3Pgn<0103Pgn<0
0`000000h=oS0>3Oh`030>3Oh`030000003Pgn<0h=oS0080000000<0h=oS
0000003Pgn<00P3Pgn<00`000000h=oS0>3Oh`02000000050>3Oh`000000
h=oS0>3Oh`0000000P3Pgn<00`000000h=oS000000030>3Oh`030000003P
gn<000000080h=oS00L000000>3Oh`3Pgn<0h=oS0000003Pgn<0000000<0
h=oS00D000000>3Oh`3Pgn<0h=oS0000001E0>3Oh`0809bLWP3oool0h=oS
0>3Oh`3akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn
075_I01Y0?ooo`040?obj`3o[8<0okZG0?ogleX0oooo00<0Ogmo0?ooo`3o
ool0FP3oool0103oo?/0ojb30?ngT`3oo?]X0?ooo`050?7_hP3Pgn<0h=oS
0>3Oh`1aKf@00P3Pgn<00`2LW9h0oooo0>3Oh`040>3Oh`030000003Pgn<0
h=oS00<0h=oS00L000000>3Oh`3Pgn<0h=oS0000003Pgn<0000000<0h=oS
00L000000>3Oh`3Pgn<0h=oS0000003Pgn<000000080h=oS00H000000>3O
h`3Pgn<000000>3Oh`0000050>3Oh`040000003Pgn<0h=oS000000D0h=oS
00<000000>3Oh`3Pgn<0103Pgn<00`000000h=oS0>3Oh`1D0>3Oh`0809bL
WP3oool0h=oS0>3Oh`3akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_l
o@2XZK/0IVIn075_I01[0?ooo`040?oRd`3oUF00olBW0?olneP0oooo00<0
Ogmo0?ooo`3oool0F03oool0103on_L0olBW0?nHI03oi=MZ0?ooo`050?7_
hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<00`2LW9h0oooo0?ooo`030?ooo`03
0>3Oh`0000000000008000000`3Pgn<4000000030>3Oh`000000h=oS00<0
h=oS100000001@3Pgn<000000>3Oh`3Pgn<000000080h=oS00<000000>3O
h`00000010000000103Pgn<000000>3Oh`3Pgn<5000000030>3Oh`000000
h=oS00<0h=oS0P0000040>3Ohe<0oooo00P0W9bN0?ooo`3Pgn<0h=oS0?7_
hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT06d0
oooo00<0olng0?nBG03of/L0E`3oool00`1oOgl0oooo0?ooo`1F0?ooo`05
0?ogl`3o^YL0oiQT0?oB^`3oo?/0J`3oool01@3akn80h=oS0>3Oh`3Pgn<0
LFmT0080h=oS1P2LW9h00`3Pgn<000000>3Oh`020>3Oh`030000003Pgn<0
000000<0h=oS00@000000>3Oh`00000000000P3Pgn<01P000000h=oS0>3O
h`3Pgn<000000>3Oh`80000000L0h=oS000000000000h=oS0000003Pgn<0
000000<0h=oS00<000000>3Oh`0000000P3Pgn<01P000000h=oS0>3Oh`3P
gn<000000>3Oh`8000000P3Pgn<01@000000h=oS0>3Oh`3Pgn<000000080
h=oSE02LW9h01`3oool0h=oS0>3Oh`3akn80IVIn0:RY^`3ko?d00@3oool0
000506IVOP3ko?d0Z:Vk06IVOP1aKf@0KP3oool0103oo?/0olN[0?nUN03o
j]mE0?ooo`0307moO`3oool0oooo05@0oooo00@0oncS0?n/P`3oXW@0onCG
KP3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT00T0h=oS00D000000>3Oh`3P
gn<0h=oS000000020>3Oh`<000000P3Pgn<00`000000h=oS000000020>3O
h`<000000P3Pgn<00`000000h=oS000000020>3Oh`040000003Pgn<0h=oS
0>3Oh`<0000000@0h=oS00000000000000000P3Pgn<300000080h=oS00<0
00000>3Oh`0000000P3Pgn<3000005X0h=oS00@0lNoR06IVOP2XZK/0nocm
0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0L03oool0103oo?/0ok:;
0?nHI03oj]mC0?ooo`0307moO`3oool0oooo0580oooo00@0onoW0?nXO03o
ZWl0on[OL03oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT00T0h=oS00D00000
0>3Oh`3Pgn<0h=oS0000000O0>3Oh`030000003Pgn<0h=oS06P0h=oS00@0
lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0
LP3oool0103ol^/0oj1`0?nZO`3om>mA0?ooo`0307moO`3oool0oooo0500
oooo00@0omo?0?nUN03o]8l0ooC_LP3oool01@3akn80h=oS0>3Oh`3Pgn<0
LFmT00T0h=oS1000000P0>3Oh`030000003Pgn<0h=oS06P0h=oS00@0lNoR
06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0M03o
ool0103oi=L0oie/0?noW`3oo?]?0?ooo`0307moO`3oool0oooo04h0oooo
00@0omBo0?nPL03o_il0oockM03oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT
09P0h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk
06IVOP1aKf@0MP3oool0103of/L0oiQT0?ngT`3omo==0?ooo`0307moO`3o
ool0oooo04/0oooo00@0oock0?noW`3oX700olZ_M`3oool01@3akn80h=oS
0>3Oh`3Pgn<0LFmT09P0h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool00005
06IVOP3ko?d0Z:Vk06IVOP1aKf@0N03oool0103og</0oj9d0?nXO03oi=M;
0?ooo`0307moO`3oool0oooo04T0oooo00@0oo[g0?n_Q`3oXW@0omc;N@3o
ool01@3akn80h=oS0>3Oh`3Pgn<0LFmT09P0h=oS00@0lNoR06IVOP2XZK/0
nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0NP3oool01@3ol^/0
ojb30?nMK03oc;<0oock04P0oooo00<0Ogmo0?ooo`3oool0A`3oool0103o
knL0ok:;0?n_Q`3ok>=k0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@0V03P
gn<0103akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn
075_I01m0?ooo`040?o</`3oVVP0ok:;0?odkdH0oooo00<0Ogmo0?ooo`3o
ool0A@3oool0103oi=L0ojEh0?njU`3omo=m0?ooo`050?7_hP3Pgn<0h=oS
0>3Oh`1aKf@0V03Pgn<0103akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn
0?_lo@2XZK/0IVIn075_I01o0?ooo`040?oTe`3oXW@0oie/0?oLbd@0oooo
00<0Ogmo0?ooo`3oool0@`3oool0103oel<0ojQl0?o2X`3on_Mo0?ooo`05
0?7_hP3Pgn<0h=oS0>3Oh`1aKf@0V03Pgn<0103akn80IVIn0:RY^`3ko?d1
0?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I0210?ooo`050?ogl`3o^YL0
oiYX0?o2X`3oo?/0@@3oool00`1oOgl0oooo0?ooo`100?ooo`040?oWf`3o
/X/0oj1`0?oB^h80oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I02H0>3Oh`04
0?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT
08@0oooo00@0omBo0?nMK03o[8<0on[O?`3oool00`1oOgl0oooo0?ooo`0m
0?ooo`050?oRd`3oZWl0oie/0?ndS`3oj]l0Q03oool01@3akn80h=oS0>3O
h`3Pgn<0LFmT09P0h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool0000506IV
OP3ko?d0Z:Vk06IVOP1aKf@0QP3oool0103ok><0ojQl0?nJJ03oe;lm0?oo
o`0307moO`3oool0oooo03X0oooo00D0omc;0?nXO03oVVP0okbK0?o_i`27
0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@0V03Pgn<0103akn80IVIn0:RY
^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I0280?ooo`060?ol
n`3oa:L0oj1`0?nPL03od[/0oo[g>@3oool00`1oOgl0oooo0?ooo`0f0?oo
o`060?oln`3oel<0oj9d0?nMK03o`Z<0ooC_RP3oool01@3akn80h=oS0>3O
h`3Pgn<0LFmT09P0h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool0000506IV
OP3ko?d0Z:Vk06IVOP1aKf@0S03oool01P3oel<0ojb30?n/P`3o/X/0om[7
0?olncD0oooo00<0Ogmo0?ooo`3oool0<`3oool01P3on_L0olbc0?nPL03o
X700olN[0?ojmhd0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I02H0>3Oh`04
0?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT
08l0oooo00H0ooOc0?o:[`3oZWl0ojYo0?njU`3ok><b0?ooo`0307moO`3o
ool0oooo0300oooo00H0ooOc0?o4Y`3oX700oj9d0?o</`3on_N@0?ooo`05
0?7_hP3Pgn<0h=oS0>3Oh`1aKf@0V03Pgn<0103akn80IVIn0:RY^`3ko?d1
0?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I02C0?ooo`060?o_i`3o]8l0
ojEh0?nUN03oaj/0oo;[;P3oool00`1oOgl0oooo0?ooo`0]0?ooo`060?ob
j`3o_il0oie/0?nXO03od[/0oockT`3oool01@3akn80h=oS0>3Oh`3Pgn<0
LFmT0240h=oS0P00000O0>3Oh`800000E03Pgn<0103akn80IVIn0:RY^`3k
o?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I02F0?ooo`070?oln`3o
g</0ok:;0?nRM03o[hL0om[70?ojm`0Z0?ooo`0307moO`3oool0oooo02X0
oooo00D0oncS0?njU`3oWF`0ojb30?oLb`2G0?ooo`050?7_hP3Pgn<0h=oS
0>3Oh`1aKf@08@3Pgn<00`000000h=oS000000070>3Oh`030000003Pgn<0
h=oS00<0h=oS00<000000>3Oh`3Pgn<03P3Pgn<00`000000h=oS0000000=
0>3Oh`030000003Pgn<0h=oS00<0h=oS00<000000>3Oh`3Pgn<0?@3Pgn<0
103akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_
I02J0?ooo`070?odk`3oc;<0ojQl0?nPL03o]i<0onCG0?oln`0V0?ooo`03
07moO`3oool0oooo02D0oooo00L0on[O0?o?]`3o]8l0ojYo0?nPL03o[8<0
on;C09X0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I00S0>3Oh`030000003P
gn<0h=oS00@0h=oS00<000000>3Oh`3Pgn<01@3Pgn<00`000000h=oS0>3O
h`0?0>3Oh`030000003Pgn<0h=oS00X0h=oS00<000000>3Oh`3Pgn<01@3P
gn<00`000000h=oS0>3Oh`0l0>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo
00001@1VIWh0nocm0:RY^`1VIWh0LFmT09h0oooo00H0on[O0?nlV`3oXW@0
ojEh0?o7Z`3ol^/S0?ooo`0307moO`3oool0oooo01h0oooo00@0ooC_0?oG
``3oa:L0ojb30`3oZWl00`3o_il0om[70?odk`2N0?ooo`050?7_hP3Pgn<0
h=oS0>3Oh`1aKf@0903Pgn<00`000000h=oS0>3Oh`020>3Oh`040000003P
gn<0h=oS00000080h=oS00D000000>3Oh`3Pgn<0h=oS000000070>3Oh`03
0000003Pgn<0h=oS00L0h=oS00<000000>3Oh`3Pgn<0203Pgn<010000000
h=oS0>3Oh`0000020>3Oh`050000003Pgn<0h=oS0>3Oh`0000004P3Pgn<3
000002P0h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0
Z:Vk06IVOP1aKf@0X@3oool0103oo?/0omO30?n_Q`3oX7020?nZO`040?nd
S`3obZl0omc;0?obja`0oooo00<0Ogmo0?ooo`3oool05`3oool0103on_L0
on[O0?o?]`3o[hL30?nZO`040?ndS`3od[/0onCG0?olnj@0oooo00D0lNoR
0>3Oh`3Pgn<0h=oS075_I00T0>3Oh`8000000`3Pgn<01`000000h=oS0>3O
h`3Pgn<000000>3Oh`0000000`3Pgn<00`000000h=oS0>3Oh`050>3Oh`03
0000003Pgn<0h=oS00L0h=oS0P0000090>3Oh`070000003Pgn<0h=oS0>3O
h`000000h=oS000000030>3Oh`030000003Pgn<0h=oS00@0h=oS20000003
0>3Oh`050000003Pgn<0h=oS0>3Oh`0000009`3Pgn<0103akn80IVIn0:RY
^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I02W0?ooo`040?od
k`3ogll0olbc0?ngT`D0ojYo00@0okbK0?o?]`3oh]<0ooOc4`3oool00`1o
Ogl0oooo0?ooo`0A0?ooo`040?ojm`3oel<0oknO0?n/P`80ojYo00@0ojn7
0?noW`3of/L0oo[gZ`3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT02@0h=oS
00<000000>3Oh`0000000P3Pgn<00`000000h=oS0>3Oh`020>3Oh`030000
003Pgn<0h=oS0080h=oS00<000000>3Oh`3Pgn<01@3Pgn<00`000000h=oS
0>3Oh`070>3Oh`030000003Pgn<0000000P0h=oS00<000000>3Oh`3Pgn<0
0P3Pgn<00`000000h=oS0>3Oh`020>3Oh`030000003Pgn<0h=oS00l0h=oS
00D000000>3Oh`3Pgn<0h=oS0000000W0>3Oh`040?7_hP1VIWh0Z:Vk0?_l
o@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT0;00oooo00@0oncS0?oJ
a`3oaj/0ok:;103oZWl01@3o[hL0ol:S0?oB^`3oi=L0oo[g00X0oooo00D0
RGae0?oZg`3oj]l0on[O0?oG``020?oD_`040?o4Y`3o_il0oknO0?n_Q`T0
ojYo00@0ojn70?oB^`3oj]l0oock/@3oool01@3akn80h=oS0>3Oh`3Pgn<0
LFmT02@0h=oS00<000000>3Oh`0000000P3Pgn<00`000000h=oS0>3Oh`02
0>3Oh`030000003Pgn<0h=oS0080h=oS00<000000>3Oh`3Pgn<00P3Pgn<7
000000H0h=oS00<000000>3Oh`000000203Pgn<00`000000h=oS0>3Oh`02
0>3Oh`030000003Pgn<0h=oS0080h=oS00<000000>3Oh`3Pgn<03`3Pgn<0
1@000000h=oS0>3Oh`3Pgn<0000002L0h=oS00@0lNoR06IVOP2XZK/0nocm
0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0^03oool01@3on_L0onOK
0?oG``3oa:L0ojn700X0ojYo00D0]Fe90?noW`3o_il0oknO0?oB^`020?oD
_`040?oTe`3oj]l0on[O0?ojmkh0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_
I00T0>3Oh`030000003Pgn<000000080h=oS00<000000>3Oh`3Pgn<00P3P
gn<2000000<0h=oS00<000000>3Oh`3Pgn<01@3Pgn<00`000000h=oS0>3O
h`070>3Oh`030000003Pgn<0000000P0h=oS00<000000>3Oh`3Pgn<00P3P
gn<2000000<0h=oS00<000000>3Oh`3Pgn<0103Pgn<8000000<0h=oS00D0
00000>3Oh`3Pgn<0h=oS0000000W0>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40
oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT0<L0oooo00<0Ogmo0?ooo`3o
ool0aP3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT02<0h=oS0P0000001@3P
gn<000000>3Oh`3Pgn<0000000<0h=oS0P0000001@3Pgn<000000>3Oh`3P
gn<0000000L0h=oS00<000000>3Oh`3Pgn<01P3Pgn<2000000040>3Oh`00
0000h=oS00000080h=oS00D000000>3Oh`3Pgn<0h=oS000000030>3Oh`80
000000D0h=oS0000003Pgn<0h=oS0000000A0>3Oh`050000003Pgn<0h=oS
0>3Oh`0000009`3Pgn<0103akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn
0?_lo@2XZK/0IVIn075_I0370?ooo`0307moO`3oool0oooo0<H0oooo00D0
lNoR0>3Oh`3Pgn<0h=oS075_I00Y0>3Oh`030000003Pgn<0h=oS00L0h=oS
00<000000>3Oh`3Pgn<01@3Pgn<00`000000h=oS0>3Oh`0;0>3Oh`040000
003Pgn<0h=oS000000<0h=oS00<000000>3Oh`3Pgn<01`3Pgn<00`000000
h=oS0>3Oh`0?0>3Oh`050000003Pgn<0h=oS0>3Oh`0000009`3Pgn<0103a
kn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I037
0?ooo`0307moO`3oool0oooo0<H0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_
I00Z0>3Oh`030000003Pgn<0h=oS00D0h=oS00<000000>3Oh`3Pgn<05@3P
gn<010000000h=oS0>3Oh`0000030>3Oh`030000003Pgn<0h=oS00D0h=oS
00<000000>3Oh`3Pgn<0403Pgn<01@000000h=oS0>3Oh`3Pgn<0000002L0
h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IV
OP1aKf@0a`3oool00`1oOgl0oooo0?ooo`360?ooo`050?7_hP3Pgn<0h=oS
0>3Oh`1aKf@0:`3Pgn<00`000000h=oS0>3Oh`030>3Oh`030000003Pgn<0
h=oS01H0h=oS00@000000>3Oh`3Pgn<00000103Pgn<00`000000h=oS0>3O
h`030>3Oh`030000003Pgn<0h=oS0180h=oS0`00000X0>3Oh`040?7_hP1V
IWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT0<L0oooo
00<0Ogmo0?ooo`3oool0aP3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT09P0
h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IV
OP1aKf@0a`3oool00`1oOgl0oooo0?ooo`360?ooo`050?7_hP3Pgn<0h=oS
0>3Oh`1aKf@0V03Pgn<0103akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn
0?_lo@2XZK/0IVIn075_I0370?ooo`0307moO`3oool0oooo0<H0oooo00D0
lNoR0>3Oh`3Pgn<0h=oS075_I02H0>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40
oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT0<L0oooo00<0WinO0?ooo`3o
ool0aP3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT09P0h=oS00@0lNoR06IV
OP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0o`3ooonA
0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@0V03Pgn<0103akn80IVIn0:RY
^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I03o0?oooi40oooo
00D0lNoR0>3Oh`3Pgn<0h=oS075_I02H0>3Oh`040?7_hP1VIWh0Z:Vk0?_l
o@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT0?l0ooooT@3oool01@3a
kn80h=oS0>3Oh`3Pgn<0LFmT09P0h=oS00@0lNoR06IVOP2XZK/0nocm0@3o
ool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0o`3ooonA0?ooo`050?7_hP3P
gn<0h=oS0>3Oh`1aKf@0V03Pgn<0103akn80IVIn0:RY^`3ko?d10?ooo`00
00D0IVIn0?_lo@2XZK/0IVIn075_I03o0?oooi40oooo00D0lNoR0>3Oh`3P
gn<0h=oS075_I02H0>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo0000101V
IWh0nocm0:RY^`1VIWko075_I9<0LFmT0`3Pgn>I075_I0040?7_hP1VIWh0
Z:Vk0?_lo@40oooo0000101VIWh0nocm0:RY^`1VIWko0>3Ohol0h=oS<@3P
gn<00`1VIWh0Z:Vk0?_lo@010?ooo`0000@0IVIn0?_lo@2XZK/0IVIn2P3P
gn<00`3;eMH0W:fi08:FYP0@08:FYP0309BV/`31c]40h=oS0?l0h=oSo`3P
gn<A0>3Oh`0306IVOP2XZK/0nocm0040oooo0000101VIWh0nocm0:RY^`1V
IWh30>3Oh`030;>`X`2=R7X0oooo00<0h=oS00<0^/W>0:bia03OiNT04@3o
ool00`3ZkO00[;W40;[9cP180>3Oh`030;noa@3Pgn<0h=oS0?l0h=oSa@3P
gn<00`1VIWh0Z:Vk0?_lo@010?ooo`0000@0IVIn0?_lo@2XZK/0IVIn0`3P
gn<00`3FclH0/k2[0>o[i`030>3Oh`0308jP[P3`loD0oooo0180oooo00<0
l??e08jP[P3Pgn<0A`3Pgn<00`2o_lD0h=oS0>3Oh`050>3Oha@0YJbbo`3P
gn>/0>3Oh`0306IVOP2XZK/0nocm0040oooo0000101VIWh0nocm0:RY^`1V
IWh90>3Oh`0308:FYP3oool0oooo01<0oooo00<0PYJV0>3Oh`3Pgn<0AP3P
gn<00`2o_lD0h=oS0>3Oh`050>3Oh`030:F//P3o00X0o`0:0100o`0:00<0
YJbb0>3Oh`3Pgn<0o`3Pgn>Z0>3Oh`0306IVOP2XZK/0nocm0040oooo0000
101VIWh0nocm0:RY^`1VIWh30>3Oh`030>OWi`3oool0oo_o00<0h=oS00<0
PYJV0?ooo`3oool0100000030?ooo`<000000`3oool3000000<0oooo00<0
PYJV0>3Oh`3Pgn<00P3Pgn<010000000h=oS0>3Oh`3Pgn<2000000H0h=oS
00<000000>3Oh`3Pgn<0503Pgn<00`000000h=oS0>3Oh`0N0>3Oh`030;no
a@3Pgn<0h=oS00D0h=oS00<0YJbb0?l02P3o00X0403o00X00`2U[;80h=oS
0>3Oh`040>3Oh`040000003Pgn<0h=oS0>3Oh`8000001P3Pgn<00`000000
h=oS0>3Oh`3o0>3OhiL0h=oS00<0IVIn0:RY^`3ko?d00@3oool0000406IV
OP3ko?d0Z:Vk06IVOP<0h=oS00<0/k2S08f8NP3oool00`3Pgn<01022UZH0
oooo0?ooo`00000>0?ooo`050000003oool0oooo0?ooo`22UZH0103Pgn<2
000000<0h=oS0P0000040>3Oh`<00000503Pgn<3000001l0h=oS00<0_ko5
0>3Oh`3Pgn<01@3Pgn<00`2U[;80o`0:0?l02P0@0?l02P030:F//P3Pgn<0
h=oS00@0h=oS0P0000030>3Oh`800000103Pgn<300000?l0h=oSV03Pgn<0
0`1VIWh0Z:Vk0?_lo@010?ooo`0000@0IVIn0?_lo@2XZK/0IVIn0`3Pgn<0
0`3FclH0/k2[0>o[i`030>3Oh`0408:FYP3oool0oooo000000h0oooo00D0
00000?ooo`3oool0oooo08:FYP040>3Oh`<000000`3Pgn<200000080h=oS
1@00000B0>3Oh`D000003P3Pgn<00`000000h=oS0>3Oh`0=0>3Oh`030;no
a@3Pgn<0h=oS00D0h=oS00<0YJbb0?l02P3o00X0403o00X00`2U[;80h=oS
0>3Oh`040>3Oh`<000000`3Pgn<200000080h=oS1@00003o0>3OhiL0h=oS
00<0IVIn0:RY^`3ko?d00@3oool0000406IVOP3ko?d0Z:Vk06IVOPT0h=oS
00@0PYJV0?ooo`3oool000003P3oool01@000000oooo0?ooo`3oool0PYJV
00@0h=oS100000030>3Oh`800000:P3Pgn<3000000h0h=oS00<0_ko50>3O
h`3Pgn<01@3Pgn<00`2U[;80o`0:0?l02P0@0?l02P030:F//P3Pgn<0h=oS
00@0h=oS100000030>3Oh`800000o`3Pgn>M0>3Oh`0306IVOP2XZK/0nocm
0040oooo0000101VIWh0nocm0:RY^`1VIWh30>3Oh`030>OWi`3oool0oo_o
00<0h=oS00<0PYJV0?ooo`3oool04`3oool00`22UZH0h=oS0>3Oh`020>3O
h`D000000`3Pgn<2000001H0h=oS0P00000@0>3Oh`D000003@3Pgn<00`2o
_lD0h=oS0>3Oh`050>3Oh`030:F//P3o00X0o`0:0100o`0:00<0YJbb0>3O
h`3Pgn<0103Pgn<5000000<0h=oS0P00003o0>3Ohi`0h=oS00<0IVIn0:RY
^`3ko?d00@3oool0000406IVOP3ko?d0Z:Vk06IVOP<0h=oS00<0/k2S08f8
NP3oool00`3Pgn<00`22UZH0oooo0?ooo`0C0?ooo`0308:FYP3Pgn<0h=oS
0080h=oS0P0000020>3Oh`030000003Pgn<0h=oS0080h=oS0P00000D0>3O
h`<000004P3Pgn<00`000000h=oS0>3Oh`0=0>3Oh`030;noa@3Pgn<0h=oS
00D0h=oS00<0YJbb0?l02P3o00X0403o00X00`2U[;80h=oS0>3Oh`040>3O
h`8000000P3Pgn<00`000000h=oS0>3Oh`020>3Oh`800000o`3Pgn>K0>3O
h`0306IVOP2XZK/0nocm0040oooo0000101VIWh0nocm0:RY^`1VIWh30>3O
h`030=K?aP2c/:/0kn_W00<0h=oS00<0PYJV0?ooo`3oool04`3oool00`22
UZH0h=oS0>3Oh`020>3Oh`030000003Pgn<0h=oS0080h=oS00<000000>3O
h`3Pgn<00P3Pgn<2000000d0h=oS10000000103Pgn<0000000000000000?
0>3Oh`050000003Pgn<0h=oS0>3Oh`0000000`3Pgn<00`000000h=oS0>3O
h`090>3Oh`030;noa@3Pgn<0h=oS00D0h=oS00<0YJbb0?l02P3o00X0403o
00X00`2U[;80h=oS0>3Oh`040>3Oh`030000003Pgn<0h=oS0080h=oS00<0
00000>3Oh`3Pgn<00P3Pgn<200000?l0h=oSVP3Pgn<00`1VIWh0Z:Vk0?_l
o@010?ooo`0000@0IVIn0?_lo@2XZK/0IVIn2@3Pgn<01022UZH0oooo0?oo
o`00000>0?ooo`050000003oool0oooo0?ooo`22UZH01@3Pgn<01@000000
h=oS0>3Oh`3Pgn<0000000D0h=oS00<000000>3Oh`3Pgn<02@3Pgn<20000
00@0h=oS0`00000?0>3Oh`8000000`3Pgn<010000000h=oS0>3Oh`3Pgn<2
000000X0h=oS00<0_ko50>3Oh`3Pgn<01@3Pgn<00`2U[;80o`0:0?l02P0@
0?l02P030:F//P3Pgn<0h=oS00D0h=oS00D000000>3Oh`3Pgn<0h=oS0000
00050>3Oh`030000003Pgn<0h=oS0?l0h=oSV03Pgn<00`1VIWh0Z:Vk0?_l
o@010?ooo`0000@0IVIn0?_lo@2XZK/0IVIn0`3Pgn<00`3WinL0oooo0?ok
o`030>3Oh`0408:FYP3oool0oooo000000h0oooo00D000000?ooo`3oool0
oooo08:FYP050>3Oh`030000003Pgn<0h=oS0080h=oS00<000000>3Oh`3P
gn<03P3Pgn<00`000000h=oS0>3Oh`040>3Oh`030000003Pgn<0h=oS00d0
h=oS3@0000090>3Oh`030;noa@3Pgn<0h=oS00D0h=oS00<0YJbb0?l02P3o
00X0403o00X00`2U[;80h=oS0>3Oh`050>3Oh`030000003Pgn<0h=oS0080
h=oS00<000000>3Oh`3Pgn<0o`3Pgn>M0>3Oh`0306IVOP2XZK/0nocm0040
oooo0000101VIWh0nocm0:RY^`1VIWh30>3Oh`030;>`X`2=R7X0oooo00<0
h=oS00@0PYJV0?ooo`3oool000003P3oool01@000000oooo0?ooo`3oool0
PYJV00H0h=oS00D000000>3Oh`3Pgn<0h=oS0000000?0>3Oh`030000003P
gn<0h=oS00H0h=oS00<000000>3Oh`3Pgn<03@3Pgn<2000000<0h=oS00@0
00000>3Oh`3Pgn<0h=oS0P00000:0>3Oh`030;noa@3Pgn<0h=oS00D0h=oS
00<0YJbb0?l02P3o00X0403o00X00`2U[;80h=oS0>3Oh`060>3Oh`050000
003Pgn<0h=oS0>3Oh`000000o`3Pgn>O0>3Oh`0306IVOP2XZK/0nocm0040
oooo0000101VIWh0nocm0:RY^`1VIWh30>3Oh`030=K?aP2c/:/0kn_W00<0
h=oS00<0PYJV0?ooo`3oool04`3oool00`22UZH0h=oS0>3Oh`040>3Oh`03
0000003Pgn<0h=oS0080h=oS00<000000>3Oh`3Pgn<0303Pgn<00`000000
h=oS0>3Oh`060>3Oh`030000003Pgn<0h=oS00h0h=oS00D000000>3Oh`3P
gn<0h=oS000000030>3Oh`030000003Pgn<0h=oS00T0h=oS00<0_ko50>3O
h`3Pgn<01@3Pgn<00`2U[;80o`0:0?l02P0@0?l02P030:F//P3Pgn<0h=oS
00H0h=oS00<000000>3Oh`3Pgn<00P3Pgn<00`000000h=oS0>3Oh`3o0>3O
hi`0h=oS00<0IVIn0:RY^`3ko?d00@3oool0000406IVOP3ko?d0Z:Vk06IV
OPT0h=oS00<0PYJV0?ooo`3oool04`3oool00`22UZH0h=oS0>3Oh`050>3O
h`030000003Pgn<0h=oS008000003P3Pgn<00`000000h=oS0>3Oh`060>3O
h`030000003Pgn<0h=oS0180h=oS00<000000>3Oh`3Pgn<03@3Pgn<00`2o
_lD0h=oS0>3Oh`050>3Oh`030:F//P3o00X0o`0:0100o`0:00<0YJbb0>3O
h`3Pgn<01`3Pgn<00`000000h=oS0>3Oh`0200000?l0h=oSWP3Pgn<00`1V
IWh0Z:Vk0?_lo@010?ooo`0000@0IVIn0?_lo@2XZK/0IVIn0`3Pgn<00`3W
inL0oooo0?oko`030>3Oh`0408:FYP3oool0oooo000000h0oooo00D00000
0?ooo`3oool0oooo08:FYP070>3Oh`030000003Pgn<000000080h=oS00<0
00000>3Oh`3Pgn<02`3Pgn<00`000000h=oS0>3Oh`060>3Oh`030000003P
gn<0h=oS0100h=oS1@00000=0>3Oh`030;noa@3Pgn<0h=oS00D0h=oS00<0
YJbb0?l02P3o00X0403o00X00`2U[;80h=oS0>3Oh`070>3Oh`030000003P
gn<000000080h=oS00<000000>3Oh`3Pgn<0o`3Pgn>K0>3Oh`0306IVOP2X
ZK/0nocm0040oooo0000101VIWh0nocm0:RY^`1VIWh30>3Oh`030;>`X`2=
R7X0oooo00<0h=oS00@0PYJV0?ooo`3oool000003P3oool01@000000oooo
0?ooo`3oool0PYJV00P0h=oS00D000000>3Oh`3Pgn<0h=oS0000000>0>3O
h`030000003Pgn<0h=oS00@0h=oS00<000000>3Oh`3Pgn<04P3Pgn<30000
00h0h=oS00<0_ko50>3Oh`3Pgn<01@3Pgn<00`2U[;80o`0:0?l02P0@0?l0
2P030:F//P3Pgn<0h=oS00P0h=oS00D000000>3Oh`3Pgn<0h=oS0000003o
0>3Ohid0h=oS00<0IVIn0:RY^`3ko?d00@3oool0000406IVOP3ko?d0Z:Vk
06IVOP<0h=oS00<0e/o60;>`Z`3_jnL00`3Pgn<01022UZH0oooo0?ooo`00
000>0?ooo`050000003oool0oooo0?ooo`22UZH0203Pgn<01@000000h=oS
0>3Oh`3Pgn<0000000h0h=oS0P0000040>3Oh`8000005@3Pgn<00`000000
h=oS0>3Oh`0=0>3Oh`030;noa@3Pgn<0h=oS00D0h=oS00<0YJbb0?l02P3o
00X0403o00X00`2U[;80h=oS0>3Oh`080>3Oh`050000003Pgn<0h=oS0>3O
h`000000o`3Pgn>M0>3Oh`0306IVOP2XZK/0nocm0040oooo0000101VIWh0
nocm0:RY^`1VIWh90>3Oh`0308:FYP3oool0oooo00@000000`3oool30000
00<0oooo0`0000030?ooo`0308:FYP3Pgn<0h=oS00L0h=oS0`00000A0>3O
h`@000009`3Pgn<00`2o_lD0h=oS0>3Oh`050>3Oh`030:F//P3o00X0o`0:
0100o`0:00<0YJbb0>3Oh`3Pgn<02@3Pgn<300000?l0h=oSWP3Pgn<00`1V
IWh0Z:Vk0?_lo@010?ooo`0000@0IVIn0?_lo@2XZK/0IVIn2@3Pgn<00`2D
Y[<0j^g`0?ooo`0B0?ooo`030>[]l02DY[<0h=oS04L0h=oS00<0_ko50>3O
h`3Pgn<01@3Pgn<00`2U[;80o`0:0?l02P0@0?l02P030:F//P3Pgn<0h=oS
0?l0h=oSZP3Pgn<00`1VIWh0Z:Vk0?_lo@010?ooo`0000@0IVIn0?_lo@2X
ZK/0IVIn2@3Pgn<00`31c]40[;W40=oUj@0A0?ooo`030>[]l02/^L@0`LkA
0500h=oS502U[;;o0>3Ohj`0h=oS00<0IVIn0:RY^`3ko?d00@3oool00004
06IVOP3ko?d0Z:Vk06IVOPX0h=oS00<0bmGF09b]^@22UZH04022UZH00`2D
Y[<0`LkA0>3Oh`3o0>3Ohol0h=oS4@3Pgn<00`1VIWh0Z:Vk0?_lo@010?oo
o`0000@0IVIn0?_lo@2XZK/0IVIno`3Pgn?o0>3Ohc40h=oS00<0IVIn0:RY
^`3ko?d00@3oool0000306IVOP3gmoT0V9RW0?l0MgNBo`1gMi8c07MgTP40
V9RW0@3gmoT10?ooo`0000<0IVIn0?Ogn@2l_Ld0o`2l_Lgo0;bmcC@0_;g=
0@3gmoT10?ooo`0000<0IVIn0?Ogn@3Thn<0o`3Thn?o0>CShc@0i>?S0@3g
moT10?ooo`0000<0IVIn0?3am03oool0o`3oooo/0?ooo`030>CSh`2LY;T0
JgF?00<0JgF?00@0K7J@06]eS`1/MY00K7J@2@1[MHl01P2LY;T0i>?S0?oo
o`3oool0i>?S09bT^@@0JgF?00@0K7J@06]eS`1/MY00K7J@2@1[MHl01P2L
Y;T0i>?S0?ooo`3oool0k>[Z09bT^@@0YSU400@0YcY40:HiA02W>T@0YcY4
2@2V>D@00`2LY;T0k>[Z0?ooo`030?ooo`40l?7d0@3oool0000F06IVOP3R
hN80nocl0?_ko03ko?d0o?_m0?_ko@3ko?d0nocl0?clo@3lo?`0o?_m0?cl
o03lno`0o?cl0?_lo03lo?`0nocm0?cko03lo?d0no_m0?_lo080o?cl00@0
o?cm0?clo03knod0o?cm2`3lno`20<O2dI/0o?_lZ03ko?b20?_lo@0309bT
^@1[MHl0QHV`0100QHV`00H0JgF?09bT^@3ko?d0nocm09bT^@1[MHlA08F9
/00606]eS`2LY;T0nocl0?_ko02LY;T0YSU44@2Z?5D01`2V>D@0W:Bi0?_l
o03lo?`0o?_m0?_lo@3RhN800@3oool0000406IVOP3Ph>40m_Oi0?Ogn@80
m_Oi00/0m_Oh0?Ogn@3gmoP0m_Oh0?Kgn@3gmoP0moOi0?Ofn03fmoT0moOi
0?Kgn@020?Ogn@040?Ofn03fmoP0m_Oi0?Ogn@<0m_Oi00<0m_Oh0?Ogn@3g
moT02@3gmoT200h@40030<O2d@3gmoT0moOi09T0moOiZ03fmoV20?Ogn@03
06]eS`25RK00W9jn0100W9jn00H0QHV`06]eS`3gmoT0moOi06]eS`25RK0A
09bN_P0808F9/01[MHl0m_Oh0?Ogn02V>D@0ZSaE0<9BF`36E5X=0<IEG009
0<IDFP32DU/0ZSaE0:HiA03gmoP0moOi0?Ogn03gmoT0h>3Q0040oooo0000
1P1VIWh0g]gQ0?7am03alO@0l?7d0?3bm0l0FU9B00L0lO;d0?7am03`l_D0
lO7d0?7bm03`l_@0lO7d00X0l?7e0P0>41000`37`]40l?7e0?3am@3o0?3a
mD80l?7ePP3`lO@00`1[MHl0/[G@0:NX`P0@0:NX`P060;:ed01[MHl0l?7d
0?3am01[MHl0/[G@4@2WZ<801@2b]M00JgF?0?3am@3al_@0YSU40080`U9K
00<0beAI0<eIGP3=FEh02`3=FEh0103;E5T0`U9K0<9BF`2V>D@20?3am003
0?7am03`l_@0g]gQ0040oooo00001`1VIWh0g=_P0>[[l03Zjo00j^c`0>W[
k`1JDU800P3WinL20=kNgP80inOW00<0ikf40>OWi`3WinL00`3WinL20>o_
k`040>[/k`3Zjo00j^_`0>[[k`80j^_`00<0j^__0<O2d@37`]400`37`]42
0>[[l0030>OWk@3HeN00al;A00803Q0@00L0al;A0>[[l03Zjo00hn?Z0=7>
fP37`]40g=[S0080al;A0P3Zjo00203Mg>D0al;A0=oNiP3Mg>D0al;A0>CT
j`3Zjo00hn?Z0P37`]420>[[l080al;A0P3Zjo00103Mg>D0al;A0<O2d@3O
g^H30>[[l080al;A0P3Zjo020<O2d@@0j^_`0P37`]440>[[l080al;A103Z
jo001P3Ph>P0dLkJ0<O2d@3Ed]d0inO]0>[[l080al;A0P3Zjo000`3Ti>/0
al;A0=cJh`020<O2d@80j^_`00T0i>C[0<O2d@3Lf^<0j^_`0>3Pj03Ac]X0
al;A0=GBg@3Wind00P3Zjo020<O2dDH0j^_`Z03Zk?220>[[k`0406]eS`2f
^M40[Jk60:f^aPP0oooo00<0[Jk60:b^aP2][/H00`2][/H00`2/[/H0][WA
06]eS`020>[[k`0406]eS`2f^M40[Jk60:f^aP`0oooo0P2][/H00`2/[/H0
][WA06]eS`020>[[l0050:HiA03=FEh0beAI0<eFF`3>FEl02`3@FUl01`3>
FEl0cEIK0<]DF@3=FEh0YSU40>[[k`3Zjo000P3Zjnl10=cKh040oooo0000
101VIWh0fMWO0>?UjP3Si>X20>?Uj`0505YBDP2<S8`0g]kN0>OWi`3Ng]h0
0P3WinL00`36H`00inOW0>OWi`020>OWi`070>o_i`3_knl0kno_0>?UjP3S
i>X0hnC[0>?UjP020>?TjPD03Q0@0P3SiN/0103@d]P0KFeb00h@401RHfL2
00h@40060<O2d@3SiN/0_;k204U:C@0>4100SHnC0P0>41002P37`]40hnG[
09>CV@0>4100XJ>W09FFV`0>4100ZjNd0>3Rj02l_/8200h@4080hnG[0P0>
41000`37`]40hnG[09>DVP0200h@400409jOY@37`]40f][S0>?Uj`803Q0@
00D0al;A0>?Uj`0>41003Q0@0<O2d@030>?Uj`803Q0@00@0al;A0>?Uj`3S
iN/0hnG[0P0>41002P37`]40hnG[0>?Uj`3SiN/0YZJ]04I6BP0>4100HV=W
0;jkaP3Jf^<200h@40050<O2d@3SiN/0`lG:00h@4023PXT00P0>41003@37
`]40hnG[0<?5bP0>4100Ph:90>7Sj@2VYZd0ATI:00h@401RHfL0_[_60=[J
h`3SiN/00P0>41000`37`]40hnG[0>?Uj`140>?UjjP0hnCZPP3SiNX01@1[
MHl0_;kD0;:bbP2b//X0oooo00H0KVf?00<09BDf0;:bbP2b//X01@2b//X0
1P2l_]@0JgF?0>?UjP3SiNX0JgF?0;bne080/[;:00<0oooo02DU=P0U9CH0
2@0U9CH30;:bbP050;bne01[MHl0hnC[0>?Tj`2V>D@00P3=FEh0103@Ff00
e5aO0?ooo`3oool70=ALG`80oooo00X0e5aO0=1KH03=FEh0cEUN0:HiA03S
i>X0hnGZ0>?TjP3SiN/0fMWO0@3oool0000306IVOP3Gf=h0g=kV00<0g=kV
00D0FU9B0>OWi`3WinL0inOW0>OFcP020>OWi`050<ik003_U100inOW0>ON
aP3_S1000`3_knl01P3LgNH0g=kV0=cNi@3Lg^D0g=kV0=cNi@803Q0@00<0
al;A0=cNi@3Lg^D00P3Lg^D0101QHfH03Q0@09jKYP3Lg^D200h@40060<O2
d@3Lg^D0HVAW00h@402g//00_Ko50P0>41001@37`]40UINK00h@402g//00
[[2f00803Q0@00D0]k;00=cNi@1<CU003Q0@0<O2d@020=cNi@803Q0@00T0
al;A09jPY@0>4100YJ6]0:j`]P0>4100ShbG0<g:e`3Lg^D00P0>41001@37
`]40g=kU00h@400>4100al;A00<0g=kU0P0>41001037`]40g=kU0=cNi@3L
g^D200h@400:0<O2d@3Lg^D0g=kU0:JX[P0>4100UiBO0:j`]P1<CU00WZ2U
0=cNi@803Q0@00D0al;A0=[Kh`19Bdh0ATI:0<_;e00200h@400;0<O2d@3J
fn<0BD]>04I6BP3;bm@0YZR^00h@402GU9l0[[2f04a>D02NX:D00P3Lg^D2
00h@40030<O2d@3Lg^D0g=kU0?l0g=kUK`3Lg^D01@1[MHl0_l7F0;RicP2h
^Lh0oooo00H0KVf?00<09BDf0;RicP2h^Lh01@2h^Lh01P2o`MH0JgF?0=cN
i@3Lg^D0JgF?0;o1eP80^;W>00<0oooo02DU=P2h^Lh01`2h^Lh00`3oool0
9BDf0;RicP020;RicP090;o1eP1[MHl0g=kV0=cNi@2V>D@0cEUN0=5JGP3D
GF40DbDP00<0oooo1@3FGf<30?ooo`0505<U803DGF40dEYN0<eIGP2V>D@0
0P3Lg^D00`3Lg^H0g=kU0=OHgP010?ooo`0000@0IVIn0=GFg@3Ef>00e]SQ
0P3Ef>002@1JDU80S8b<0>OWi`3WinL0ikF40=IJ003FQ000olh00<iS0002
0=i[00050>neS03_knl0kno_0>o_k`3Ef>000P3Ef>400`3Een00e]SP0=KH
h@0200h@40050<O2d@3Fen00e]OP0=KGh034a/h00P0>41001P37`]40e]OP
00h@400>4100al;A0=KGh0803Q0@00D0al;A0=KGh00>41003Q0@0<O2d@02
00h@40060<O2d@3Cdmd03Q0@00h@4037`]40e]OP0P0>41000`37`]40e]OP
0=KGh00200h@40090<O2d@1:C4l03Q0@0<O2d@3Fen003Q0@04I6BP37`]40
e]OP00803Q0@00D0al;A0=KGh00>41003Q0@0<O2d@030=KGh0803Q0@00@0
al;A0=KGh03Fen00e]OP0P0>41001@37`]40e]OP0=KGh01:C4l03Q0@00D0
al;A0P0>41001@2g//00P7n700h@402TXjd0e]OP00803Q0@00L0]k;0081o
Q`0>4100Y:>]0=KGh01:C4l03Q0@00D0al;A00@0e]OP00h@400>4100al;A
AP3Fen2X0=KHh880eMSQ00D0JgF?0<?5f@2l_M40_;gA0?ooo`0702DU=PL0
_;gA00H0`lGI06]eS`3Ef>40eMSQ06]eS`33aMT20;bmd@030?ooo`0U9CH0
_;gA00L0_;gA00<0oooo02DU=P2l_M400P2l_M401@33aMT0JgF?0=KGh03E
en40YSU40080eEeP00<0f61Q0=UQHP167QX00`3oool30=UQHP<0oooo00<0
AQhJ0=UQHP3HH6400P3EGF001P2V>D@0e]SP0=GHh@3Een00eMSQ0=GFg@40
oooo00001`1VIWh0d]CM0<oBg03@d]`0d=;M0=3Bg01JDU800`3WinL02`3W
g/h0aTX00?O>003_[@00kkD00<i[0036FP00aV/00=j<BP3WY@00knO>00@0
d=;L00D0cm;L0=3Bg00>41003Q0@0<O2d@030=3Bg0050;Vka00>41003Q0@
0<O2d@3@d]`00P0>41001P37`]40d=;L00h@400>4100al;A0=3Bg0803Q0@
00D0al;A07UkP00>4100ZJVc0<W6e00200h@40050<O2d@3@d]`03Q0@00h@
4037`]400P3@d]`200h@40050<O2d@0>41003Q0@0<O2d@3@d]`00P0>4100
1P39a]@0d=;L00h@400>4100al;A0=3Bg0803Q0@00@0al;A0=3Bg03@d]`0
d=;L0P0>41001037`]40d=;L0=3Bg03@d]`200h@40030<O2d@3@d]`0d=;L
00H03Q0@00P0bLKD00h@400>4100ATI:00h@401dLWX0cLgI0=3Bg0803Q0@
00D0ATI:00h@401dLWX0cLgI0=3Bg00600h@40050<W6e03@d]`03Q0@00h@
4037`]40AP3@d]bX0<oBgH80d=;L00<0JgF?0<S9f`33a=H04033a=H01P38
bM/0JgF?0=3Bg03@d]`0JgF?0<S9f`80`lCF00<0oooo02DU=P33a=H01`33
a=H00`3oool09BDf0<?4eP020<?4eP070<S9f`1[MHl0cm;L0<oBg02V>D@0
eemO0=UQHP030=aUI@0504HN6P3oool0oooo0?ooo`3LIFD00`3oool02016
7QX0g6EU0=aUI@3LIFD0fF5R0=MOG`2V>D@0d=;M0P3@d]`10<oBg040d]CM
0@3oool0000K06IVOP3@d]/0blgH0<[=f@3;c]P0b/gH05YBDP3WaZd0ilJ<
0?O>603__@00mlH00>n]003W[@00ijD00=J<003>J`00ilH00?oF003_knL0
kno_0<[>f@3;cMP0blgI0<[=f@3;c]P0b/gH00803Q0@0`37`]401P3;cMT0
^[c700h@400>4100al;A0<W:eP803Q0@00H0al;A0<_=f@0>41003Q0@0<O2
d@3;cMT200h@40040<O2d@3;cMT0RXbC04M9C@<03Q0@00D0b<OD0<_=f@0>
41003Q0@0<O2d@020<_=f@803Q0@00T0al;A04M9C@0>4100al;A0<[:e`0>
4100ATI:0<W9eP3;cMT00P0>41001@37`]40b/cH00h@400>4100bLSE00<0
blgI0P0>41001037`]40blgI0<_=f@3;cMT200h@400:0<O2d@3:b]L0b/_G
04M9C@0>4100al;A0<[:e`0>4100ATI:0<W9eP803Q0@00D0J6I^00h@402H
VJ<0al;A0<[:e`0200h@400=06QVKP0>4100V9VS0<O2d@3:b]L0AdU=00h@
4037`]40b/[G00h@4016ATX0bLWF0<_=f@0200h@40030<O2d@3:b]L0b/_G
04@0blgIZ03;c]V20<_=f00306]eS`3;c=h0b<[I00P0b<[I00<0b<WI0<S:
f@38b]T00`38b]T01038bMT0b<[I0<_<gP1[MHl20<_=f00606]eS`3;c=h0
b<[I0<S:f@3oool09BDf1@38b]T04@38bMT0b<[I0<S:f@3oool09BDf0<S:
f@38bMT0b<[I0<_<gP1[MHl0blkH0<[=f02V>D@0eemO0=]TI03PIfD0h6IU
0080gVMW00<0AQhJ0?ooo`3oool00`3oool02P167QX0gVMW0=iWI`3PIVD0
h6MU0=]TI03GGel0YSU40<[>f03:c]T20<_=f@40d=;K0@3oool0000306IV
OP3?cmX0aLSD00<0aLSD00H0FU9B0<K6aP3Wg]H0cW/00>N]003_]@020>NU
00030=JD003>L`00eY@00080mlH00P3gmoL01035am@0aLSD0<G7e035am@2
0<G7e@@03Q0@0`34amD0101VJG003Q0@09JFX037`]4200h@40060<O2d@34
amD03Q0@00h@4037`]40a<OE0P0>41002@37`]40a<OE0<C7e@36a=80]k;0
00h@401WIfl0aLKD0<C7e@0200h@4080al;A00X0a<OE00h@400>4100al;A
08f@VP0>4100Y:>_0:^W]00>4100ShjH0P34amD200h@40050;Je`P2`[[/0
3Q0@07=cN`35a]@00`34amD200h@40040<O2d@34amD0a<OE0<C7e@803Q0@
00X0YJ6]0:ZZ]P36a=80QHRA00h@402MWJP0ZjNd00h@4026QY00a<OE0P0>
41001@37`]40QHRA00h@402TXjl0al;A00803Q0@00/0al;A08F8T@0>4100
Y:>_0<O2d@26Qi003Q0@09fMZ02[Yk@03Q0@08J6T0020<C7e@803Q0@00<0
YJ6]0:ZZ]P36a=80A034amFX0<C8e880a<OD00<0JgF?0=3Ah03;bm`0403;
bm`01P3@dN00JgF?0<C7e034am@0JgF?0=3Ah080bl_L00<0oooo02DU=P3;
bm`01`3;bm`00`3oool09BDf0<_;g0020<_;g0070=3Ah01[MHl0aLOD0<C7
e02V>D@0ffAT0=mUI0050>1ZJ00504HN6P3oool0oooo0?ooo`167QX01@3P
JVP0103OIF@0ffAT0:HiA034b=D20<C8e040aLOE0@3?cmX10?ooo`0000@0
IVIn0<c>fP32a=80`LCA0P31a=801P1JDU80inOW0>OWi`3WinL0eX@00>ne
0080ijD000P0eX@00<i[003W[@00mkD00?Nm003_knl0moOg0<;4dP<0`LCB
00D0`/CA0<74dP0>41003Q0@0<O2d@040<74d@060;6d`01jOHD03Q0@00h@
401`LgX03Q0@0P31a=4200h@4080`LCA0P0>41020<74d@0605MIG`0>4100
3Q0@071cNP2a]<00`LCA100>41001031a=403Q0@00h@400>41020<74d@04
08>6SP0>41003Q0@08>6SP<0`LCA00H03Q0@07YmQ@14ATX03Q0@071cNP2a
]<040<74d@803Q0@00@0al;A0<74d@31a=40`LCA0P0>41001@23QXh0EeUO
0<74d@31a=40PhJ>00803Q0@00<0PhJ>0<74d@31a=400P0>41001@37`]40
`LCA08>6SP0>4100X:>]00803Q0@00L0al;A0<74d@23QXh03Q0@0:2S[@31
a=40PhJ>00803Q0@00@0PhJ>0<74d@31a=40`LCA0P0>41000`23QXh0EeUO
0<74d@140<74dJP0`LCBPP32a=800`1[MHl0dm?R0<o@g@0@0<o@g@060=?C
hP1[MHl0`/CB0<;4dP1[MHl0dm?R0P3?d=d00`3oool09BDf0<o@g@070<o@
g@030?ooo`0U9CH0cm3M0080cm3M00L0dm?R06]eS`32a=80`LCA0:HiA03K
I6@0hFUU00D0h6aY1@3oool50>1/J@080>5YI@3KI6@0YSU40<74dP32a=40
`LCA0<74dP3<c]X10?ooo`0000@0IVIn0<[<f02n`<l0_L3?0P2n`<h01@1J
DU80W9bL0>OWi`3Wg]H0eX`00080gY@000@0eW/00<IS002m@P00kjD00P3g
[@00203g]@00oli:0;k0c`2n`<h0_/3?0;k0cP2n`<l0_L3>0P0>41000`37
`]40_/3>0;k0cP0I0;k0cP803Q0@00@0a/7@0;k0cP2n`<h0_/3>0P36`M0B
0;k0cP803Q0@00<0al;A0;k0cP2n`<h03@2n`<h200h@40030<O2d@2n`<h0
_/3>0080_/3>0P0>41000`37`]40_/3>0;k0cP1C0;k0cZP0_L3>PP2n`<h0
0`1[MHl0e]KT0=?Ch00@0=?Ch0060=KFi01[MHl0_/3>0;k0cP1[MHl0e]KT
0P3Cdn000`3oool09BDf0?ooo`080?ooo`0;02DU=P3Cdn00dm?P0=?Ch03F
e^@0JgF?0;k0c`2n`<h0YSU40>1VI@3QJVX0103SK6`30?ooo`0404HN6P3o
ool0oooo0?ooo`@0hfa/00@0hFYZ0>1VI@2V>D@0_L3?0P2n`<l10;k0cP40
b/cH0@3oool0000706IVOP39b]P0][S80;Vlb`2j_</0^[c<05YBDP020>o_
k`0<0=JL003FS000gY@00=J4003_Y@00gX`00;eJ003FL`00ki`00?O_i`3g
moL0oooo0P2i_<`0102j^l`0^Kc;0;Zlb`2i_<`200h@40@0al;A602i_<`0
0`25R9<0E5IM0;Vlc0020;Vlc003065SJ`1WIVd0aL7@0100^Kc<0P37`]42
00h@40@0al;A302i_<`200h@40030<K1d02i_<`0^Kc<0080^Kc<0P0>4100
0`36`M00^Kc<0;Vlc01C0;Vlc:P0^[c<PP2j_</00`1[MHl0f=SU0=?Ch@0@
0=?Ch@060=SHi@1[MHl0^[c;0;Zlb`1[MHl0f=SU0P3Cdn400`3oool0KVf?
06i]S`0806i]S`0>02DU=P3Cdn40dm?Q0=?Ch@3Hf>D0JgF?0;Zlb`2j_<`0
YSU40>1YJ03QKF`0i75]0>AaK`3TL6h30?ooo`0304HN6P3TL6h0AQhJ00<0
oooo0P3TL6h02@3TLFd0hFe/0>1YJ02V>D@0^[c<0;Zkc02i_</0][S80<W:
f0010?ooo`0000T0IVIn0<O9e`2d]/L0][S80;Jhb@2f^LT0FU9B08B4Q03W
imh00P3_knl01`36J`00mlH00>ne003_W000gX`00<i[003WW0000`3gmoL0
1P2f^<T0][W90;Nhb@2f^LT0]kW90;Jhb@D03Q0@7P2g^<T2061QJQ00]kS9
200>410=0;Nhb@0306]/MP11@dP0]kS900@0]kS900<0Jfaf0453B02g^<T0
E@2g^<VX0;JhbH80]kS900@0JgF?0=KFi03Hf>D0f=SV0`3Hf>D50=SHiP<0
f=SU0P3Hf>H20=SHi@090=KFi01[MHl0]kS90;Nhb@1[MHl0e]KT0=SHi@3H
f>H0oooo00X0KVf?00d09BDf0=SHiP3Hf>D0f=SU0=KFi01[MHl0]kS90;Ni
b@2V>D@0i6i]0>AdK`3WLFl0i7A_00<0oooo00D0AQhJ0>AdK`3TM6l0i7A_
04HN6P030?ooo`0:0>AdK`3WLFl0i7A_0>A^K@2V>D@0][W90;Jhb@2f^LT0
];K70<O9e`40oooo00000`1VIWh0a/SG0;Bfa`030;Bfa`0305YBDP3_knl0
kno_0080kno_00X0ijd00?O6203WY@00ii@00>N<003_imH0gY@i0>oF]@3o
moL0ooooo`2d]/OJ0;Bfa`0506]eS`3EeN<0g=_W0=cKi`3MfnL03P3LfnL0
1P3EeN<0JgF?0;Bfa`2d]/L0JgF?0=GEh`80g=_W00<0gM_W02DU=P0U9CH0
2@0U9CH30=cKi`090=GEh`1[MHl0];K70;Bfa`2V>D@0ig=_0>MeLP3ZMW<0
jWQf0080oooo00<0AQhJ0>UnN03YOWP00`3YOWP020167QX0oooo0?ooo`3Z
N7H0jWIc0>MeLP3WLfl0YSU4102d]/L10<K8e`40oooo00000`1VIWh0a/SG
0;Bfa`030;Bfa`0605YBDP2<S8`0kno_0>o_k`3WcW/0kno_0P3gmoL01`3W
U000mnO>0?Ogm`3gmoL0knOF0?Ogm`3oool0o`2d]/OJ0;Bfa`0306]eS`3E
e><0h=oZ0100h=oZ00H0eMCS06]eS`2d]/L0];K706]eS`3Ee><A0>3OjP09
0=GDh`1[MHl0];K70;Bfa`2V>D@0jWUc0>UlN03_PGX0lXV10080AQhJ00L0
jiR;0>ZKS03]UhX0jiR;0>ZKS03]UhX0jiR;0080AQhJ00D0lXV10>n1NP3Y
O7P0jWUc0:HiA0040;Bfa`40a/SG0@3oool0000306IVOP36b=L0/K?800<0
/K?800H0FU9B0>o_k`3_knl0kno_0?Ogk`3_knl20?Ogm`030?OWaP3gmoL0
oooo00<0moOg00<0oooo0;6cb02a/lP0o`2a/lSH0;6cb00306]eS`3]jo<0
jNSa0100jNSa00H0kN_c06]eS`2a/lP0/K?806]eS`3]jo<A0>WXl@0I0>g[
l`1[MHl0/K?80;6cb02V>D@0lH1e0?24O03eS8@0mif>0?:[UP3a/Y/0kKBK
0>beW03a/Y/0kKBK0>beW03a/Y/0kKBK0>beW03bZiH0mif>0?F<Q03`Q7`0
lH1e0:HiA0040;6cb040a/SG0@3oool0000306IVOP36b=L0^;O?00<0[jk7
00D0FU9B0:f][@3gmnl0moOg0>o_k`060?Ogm`80ooOg0P3ooooo0:n^amX0
[jk700<0JgF?0=;Ah`3blOL0403blOL01P3BdN<0JgF?0:n^a`2_[/L0JgF?
0=;Aha40l_7g00H0d]7S06]eS`2_[/L0[jk70:HiA03dRWd20?F@Q@d0l[RN
0P3eT8D00`3dRWd0YSU40:n^a`020:n^a`40^;O?0@36b=L10?ooo`0000<0
IVIn0<31d@37am@0o`2/ZlC/0:b[a00408B<XP1[MHl0c<_M0?_ko0d0oooo
00@0no_l0<c;g@1[MHl0Q8bR0P2/Zl@01024S:80JgF?0<c;g@3kno`=0?oo
o`040?_ko03<bmd0JgF?08B<XP80[:_400L0TIRZ0:HiA03oWhd0o[nT0?[L
]`3jjkL0n^Vf0080nNVf00@0n^Vf0?WY]P3ijKH0n^Vf0P3ijKH01P3jjkL0
n]bg0?joY03oWhd0YSU4096HZP<0[:_40@37am@10<31d@40oooo0000101V
IWh0`<7A0=;Bg`2e]<Wo0:BS_^`0Y:>n00<0Q8bR06]eS`1[MHl03`1[MHl0
0`24S:80Y:>n0:BS_P020:BS_P0308B<XP1[MHl0JgF?00l0JgF?00<0Q8bR
0:BS_P2TXkh00P2TXkh00`24S:80YSU40:HiA00?0:HiA00708B<XP2TXkh0
Y:>n0:BS_P2e]<T0d];O0<31d@010?ooo`0000H0IVIn0:RW_`3Vi^d0d];P
0;blc`2a/<Co0:RW_ol0Z:No;@2XYkl01@2a/<@0_;c?0=;Bh03Vi^d0Z:No
0040oooo00001`3oool0QhNK0=OHhP3lo?`0i>?X0=3@h03:b]X0o`2l_<oo
0;blcb/0_;c?00H0b/[J0=3@h03ThnP0o?cl0=OHhP27Qi/10?ooo`0000P0
oooo06IVOP2EU:/0emSR0?clo03blO<0k>_^0>7Rjol0emSRo`3Gf>8Y0=OH
hP070>7Rj`3/jnh0l_7c0?clo03Gf>80UIB[06IVOP010?ooo`000P3oool0
0`1VIWh0UIB[0=7AgP020?clo?l0ooooo`3oool[0?ooo`80o?cl00<0dM7N
09FDZ`1VIWh00P3oool000<0oooo0P1VIWh00`28Qid0UIB[0:RW_`3o0:RW
_ol0Z:No:P2XYkl0102EU:/0R8NM06IVOP1VIWh30?ooo`001@3ooooo06IV
O_l0IVIn;`1VIWh50?ooo`00\
\>"], "Graphics",
  CellLabel->"From In[6]:=",
  Evaluatable->False,
  ImageSize->{567, 461},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[TextData[{
  "The curves shown, which will be called \"treks\",  are the solutions \
(shown in the y' versus y phase plane) with initial conditions ",
  Cell[BoxData[
      \(TraditionalForm\`\((y(x\_0), \ y' \((x\_0)\))\)\)],
    GridBoxOptions->{ColumnWidths->{0.35, 0.65}}],
  " through the points displayed as dots.  By default, ",
  Cell[BoxData[
      \(TraditionalForm\`x\_0\)],
    GridBoxOptions->{ColumnWidths->{0.35, 0.65}}],
  " is taken to be zero, and the trek is shown for the extent of the range \
(",
  StyleBox["xmin", "TI"],
  ", ",
  StyleBox["xmax", "TI"],
  ") given in the command, in this example, ",
  Cell[BoxData[
      \(TraditionalForm\`\(\[Pi]\/8\) to\ \[Pi]\)],
    GridBoxOptions->{ColumnWidths->{0.35, 0.65}}],
  ".   To choose an initial condition, all you have to do is position the \
cursor and click the right mouse button.  The trek will be shown as soon as \
it can be computed by ",
  StyleBox["NDSolve", "MR"],
  ", which, for this example, is within the blink of an eye!  If you hold the \
right button down and drag the cursor, the solution will be updated in real \
time as you drag.   The currently selected trek is indicated by the larger \
yellow circle.  You can see from the screen shot above that there are \
numerous controls and values that can be set.  Each of these will be \
described once the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " interface has been demonstrated."
}], "Text",
  CellTags->"EquationTrekker"],

Cell[TextData[{
  "This starts the ",
  StyleBox["EquationTrekker", "MR"],
  " for the simple harmonic oscillator.  When you enter this command, a \
window like the screen shot above will open.  The window is running modally, \
which means that until you close the window,  the kernel is controlled \
through the window.  When you close the window, a list is returned and kernel \
control reverts to the notebook."
}], "MathCaption",
  CellTags->"EquationTrekker"],

Cell[CellGroupData[{

Cell[BoxData[
    \(EquationTrekker[\(y''\)[x]\  + \ y[x]\  \[Equal] \ 0, 
      y, {x, \[Pi]\/8, \ 2\ \[Pi]}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"EquationTrekker"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
%%ImageSize: 400 400 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.5 0.5 0.5 [
[0 .4875 -6 -9 ]
[0 .4875 6 0 ]
[.125 .4875 -15 -9 ]
[.125 .4875 15 0 ]
[.25 .4875 -12 -9 ]
[.25 .4875 12 0 ]
[.375 .4875 -15 -9 ]
[.375 .4875 15 0 ]
[.625 .4875 -12 -9 ]
[.625 .4875 12 0 ]
[.75 .4875 -9 -9 ]
[.75 .4875 9 0 ]
[.875 .4875 -12 -9 ]
[.875 .4875 12 0 ]
[1 .4875 -3 -9 ]
[1 .4875 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .125 -30 -4.5 ]
[.4875 .125 0 4.5 ]
[.4875 .25 -24 -4.5 ]
[.4875 .25 0 4.5 ]
[.4875 .375 -30 -4.5 ]
[.4875 .375 0 4.5 ]
[.4875 .625 -24 -4.5 ]
[.4875 .625 0 4.5 ]
[.4875 .75 -18 -4.5 ]
[.4875 .75 0 4.5 ]
[.4875 .875 -24 -4.5 ]
[.4875 .875 0 4.5 ]
[.4875 1 -6 -4.5 ]
[.4875 1 0 4.5 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .5 m
0 .50625 L
s
[(-1)] 0 .4875 0 1 Mshowa
.125 .5 m
.125 .50625 L
s
[(-0.75)] .125 .4875 0 1 Mshowa
.25 .5 m
.25 .50625 L
s
[(-0.5)] .25 .4875 0 1 Mshowa
.375 .5 m
.375 .50625 L
s
[(-0.25)] .375 .4875 0 1 Mshowa
.625 .5 m
.625 .50625 L
s
[(0.25)] .625 .4875 0 1 Mshowa
.75 .5 m
.75 .50625 L
s
[(0.5)] .75 .4875 0 1 Mshowa
.875 .5 m
.875 .50625 L
s
[(0.75)] .875 .4875 0 1 Mshowa
1 .5 m
1 .50625 L
s
[(1)] 1 .4875 0 1 Mshowa
.125 Mabswid
.025 .5 m
.025 .50375 L
s
.05 .5 m
.05 .50375 L
s
.075 .5 m
.075 .50375 L
s
.1 .5 m
.1 .50375 L
s
.15 .5 m
.15 .50375 L
s
.175 .5 m
.175 .50375 L
s
.2 .5 m
.2 .50375 L
s
.225 .5 m
.225 .50375 L
s
.275 .5 m
.275 .50375 L
s
.3 .5 m
.3 .50375 L
s
.325 .5 m
.325 .50375 L
s
.35 .5 m
.35 .50375 L
s
.4 .5 m
.4 .50375 L
s
.425 .5 m
.425 .50375 L
s
.45 .5 m
.45 .50375 L
s
.475 .5 m
.475 .50375 L
s
.525 .5 m
.525 .50375 L
s
.55 .5 m
.55 .50375 L
s
.575 .5 m
.575 .50375 L
s
.6 .5 m
.6 .50375 L
s
.65 .5 m
.65 .50375 L
s
.675 .5 m
.675 .50375 L
s
.7 .5 m
.7 .50375 L
s
.725 .5 m
.725 .50375 L
s
.775 .5 m
.775 .50375 L
s
.8 .5 m
.8 .50375 L
s
.825 .5 m
.825 .50375 L
s
.85 .5 m
.85 .50375 L
s
.9 .5 m
.9 .50375 L
s
.925 .5 m
.925 .50375 L
s
.95 .5 m
.95 .50375 L
s
.975 .5 m
.975 .50375 L
s
.25 Mabswid
0 .5 m
1 .5 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .125 m
.50625 .125 L
s
[(-0.75)] .4875 .125 1 0 Mshowa
.5 .25 m
.50625 .25 L
s
[(-0.5)] .4875 .25 1 0 Mshowa
.5 .375 m
.50625 .375 L
s
[(-0.25)] .4875 .375 1 0 Mshowa
.5 .625 m
.50625 .625 L
s
[(0.25)] .4875 .625 1 0 Mshowa
.5 .75 m
.50625 .75 L
s
[(0.5)] .4875 .75 1 0 Mshowa
.5 .875 m
.50625 .875 L
s
[(0.75)] .4875 .875 1 0 Mshowa
.5 1 m
.50625 1 L
s
[(1)] .4875 1 1 0 Mshowa
.125 Mabswid
.5 .025 m
.50375 .025 L
s
.5 .05 m
.50375 .05 L
s
.5 .075 m
.50375 .075 L
s
.5 .1 m
.50375 .1 L
s
.5 .15 m
.50375 .15 L
s
.5 .175 m
.50375 .175 L
s
.5 .2 m
.50375 .2 L
s
.5 .225 m
.50375 .225 L
s
.5 .275 m
.50375 .275 L
s
.5 .3 m
.50375 .3 L
s
.5 .325 m
.50375 .325 L
s
.5 .35 m
.50375 .35 L
s
.5 .4 m
.50375 .4 L
s
.5 .425 m
.50375 .425 L
s
.5 .45 m
.50375 .45 L
s
.5 .475 m
.50375 .475 L
s
.5 .525 m
.50375 .525 L
s
.5 .55 m
.50375 .55 L
s
.5 .575 m
.50375 .575 L
s
.5 .6 m
.50375 .6 L
s
.5 .65 m
.50375 .65 L
s
.5 .675 m
.50375 .675 L
s
.5 .7 m
.50375 .7 L
s
.5 .725 m
.50375 .725 L
s
.5 .775 m
.50375 .775 L
s
.5 .8 m
.50375 .8 L
s
.5 .825 m
.50375 .825 L
s
.5 .85 m
.50375 .85 L
s
.5 .9 m
.50375 .9 L
s
.5 .925 m
.50375 .925 L
s
.5 .95 m
.50375 .95 L
s
.5 .975 m
.50375 .975 L
s
.25 Mabswid
.5 0 m
.5 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of user PostScript
/mathtops {
gsave
MBeginOrig
moveto
MEndOrig
currentpoint
grestore
} bind def
/MAtocoords {
mathtops 4 2 roll mathtops
4 copy pop pop
3 -1 roll sub
/arry exch def
exch sub
/arrx exch def
arrx dup mul
arry dup mul
add sqrt
/arrl exch def
translate
} bind def
/MAarrowhead1 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto
-0.035 0 lineto fill
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto
-0.035 0 lineto
-0.05 0.0125 lineto stroke
} ifelse
grestore
} def
% End of user PostScript
1 .976 0 r
.5 Mabswid
.43743 .47557 m
.43694 .47685 L
.43648 .47815 L
.43605 .47945 L
.43564 .48076 L
.43393 .48786 L
.433 .49511 L
.43287 .50241 L
.43353 .50969 L
.43497 .51685 L
.43718 .52381 L
.44014 .53049 L
.44578 .53966 L
.45282 .54782 L
.46107 .55474 L
.47032 .56026 L
.48033 .56423 L
.49085 .56655 L
.50161 .56716 L
.51232 .56604 L
.52375 .56284 L
.53444 .55768 L
.54405 .55072 L
.55228 .54218 L
.55889 .53232 L
.56366 .52145 L
.56644 .50991 L
.56715 .49807 L
.56572 .48608 L
.56216 .47453 L
.5566 .46381 L
.5492 .45426 L
.54022 .44619 L
.52993 .43986 L
.51868 .43547 L
.50682 .43317 L
.49495 .43302 L
.48323 .43495 L
.47204 .43892 L
.46172 .4448 L
.45694 .44844 L
.4525 .4525 L
s
.02 w
.4525 .4525 Mdot
.5 Mabswid
.45694 .44844 m
.4525 .4525 L
s
% Start of user PostScript
-0.086123861 -0.10311495 -0.095000022 -0.095000042 MAarrowhead1
% End of user PostScript
0 .22 1 r
.28727 .96182 m
.29987 .96742 L
.31263 .97268 L
.32552 .97759 L
.33854 .98214 L
.38759 .99588 L
s
.38759 .99588 m
.4112 1 L
s
.59186 1 m
.63963 .98891 L
.68785 .97249 L
.7444 .94587 L
.79725 .91252 L
.84561 .87294 L
.88875 .82772 L
.92602 .77756 L
.95685 .7232 L
.98078 .66547 L
.99745 .60524 L
s
.99745 .60524 m
1 .5854 L
s
1 .41598 m
.98931 .36177 L
.96077 .285 L
.92026 .2138 L
.86886 .15004 L
.80788 .09535 L
.73891 .05116 L
.66374 .01863 L
s
.66374 .01863 m
.58994 0 L
s
.41306 0 m
.35982 .01124 L
.29191 .03607 L
.22821 .07028 L
.17 .11317 L
.11847 .16389 L
.07465 .22141 L
.03944 .28456 L
.01354 .35207 L
s
.01354 .35207 m
0 .41147 L
s
0 .58669 m
.00637 .62191 L
.02567 .68314 L
.05253 .74145 L
.07893 .78501 L
.09744 .81061 L
.1175 .835 L
s
.02 w
.1175 .835 Mdot
.5 Mabswid
.09744 .81061 m
.1175 .835 L
s
% Start of user PostScript
-0.80512196 0.62121157 -0.76500009 0.67000004 MAarrowhead1
% End of user PostScript
1 0 .439 r
.81308 .61677 m
.81534 .61054 L
.81747 .60427 L
.81947 .59795 L
.82135 .59159 L
.82926 .55698 L
.83344 .52172 L
.83387 .48621 L
.83052 .45086 L
.82344 .41607 L
.8127 .38222 L
.79844 .3497 L
.77562 .31109 L
.74784 .27587 L
.71559 .2447 L
.67945 .21813 L
.64009 .19663 L
.5982 .1806 L
.55454 .17033 L
.50989 .166 L
.46529 .16766 L
.4213 .17525 L
.37872 .18863 L
.33831 .20758 L
.30078 .23174 L
.2668 .26068 L
.23698 .2939 L
.21186 .33079 L
.19337 .3672 L
.17946 .40559 L
.17034 .44539 L
.16614 .48601 L
.16693 .52683 L
.17269 .56726 L
.18334 .60668 L
.19871 .6445 L
.21877 .68046 L
.24309 .71367 L
.27132 .74364 L
.30301 .76991 L
.3377 .79209 L
.37485 .80983 L
.4139 .82287 L
.45425 .831 L
.50171 .83415 L
.54913 .83052 L
.59556 .82019 L
.64005 .80338 L
.6817 .78043 L
.71221 .75812 L
Mistroke
.74 .7325 L
Mfstroke
.02 w
.74 .7325 Mdot
.5 Mabswid
.71221 .75812 m
.74 .7325 L
s
% Start of user PostScript
0.42441871 0.51623037 0.48000002 0.46500002 MAarrowhead1
% End of user PostScript
0 1 .894 r
.55852 .32363 m
.55415 .32224 L
.54974 .32095 L
.5453 .31978 L
.54083 .31871 L
.52248 .31554 L
.50391 .31422 L
.48529 .31476 L
.46683 .31716 L
.4487 .3214 L
.43108 .32743 L
.41416 .33519 L
.39161 .34906 L
.37127 .36599 L
.35353 .38564 L
.33877 .4076 L
.32728 .43145 L
.31929 .45668 L
.31497 .48279 L
.3144 .50926 L
.31791 .53707 L
.32556 .56404 L
.33718 .58955 L
.3525 .61303 L
.37118 .63393 L
.39279 .65178 L
.41685 .66618 L
.44279 .6768 L
.46959 .68332 L
.49706 .6858 L
.52459 .68419 L
.55158 .67852 L
.57744 .66892 L
.60159 .6556 L
.6235 .63885 L
.64269 .61904 L
.65856 .59691 L
.67102 .57269 L
.6798 .54692 L
.68473 .52014 L
.68569 .49292 L
.68266 .46586 L
.67571 .43953 L
.66499 .4145 L
.65059 .39112 L
.63854 .37615 L
.625 .3625 L
s
.02 w
.625 .3625 Mdot
.5 Mabswid
.63854 .37615 m
.625 .3625 L
s
% Start of user PostScript
0.27707044 -0.24770345 0.25000003 -0.27500002 MAarrowhead1
% End of user PostScript
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[2]:=",
  ImageSize->{400, 400},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006@0001T2000`400?l00000o`00003oo`3ooonA
0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00_`3oool500000<`0oooo00310?ooo`030000003o
ool0oooo0<`0oooo002U0?ooo`<003So6@3oool00`000000oooo0?ooo`050?ooo`<00000803oool2
000hoj80oooo002P0?ooo`D003So503oool4000000@0oooo00<000000?ooo`3oool01@3oool00`00
0000oooo0?ooo`0R0?ooo`@003SoWP3oool009X0oooo1P00>?lQ0?ooo`030000003oool0oooo00D0
oooo00<000000?ooo`3oool09P3oool4000hoiX0oooo002E0?ooo`D003So9P3oool2000000L0oooo
00<000000?ooo`3oool0:P3oool4000hoiH0oooo002A0?ooo`@003So=03oool00`000000oooo0?oo
o`0^0?ooo`@003SoTP3oool008h0oooo0`00>?lh0?ooo`030000003oool0oooo0380oooo1000>?n>
0?ooo`00S03oool2000hoc/0oooo00<000000?ooo`3oool0=P3oool4000hohX0oooo00290?ooo`<0
03So?@3oool00`000000oooo0?ooo`0j0?ooo`@003SoQP3oool008H0oooo0`00>?m00?ooo`030000
003oool0oooo03h0oooo0P00>?n40?ooo`00Q03oool2000hod<0oooo00<000000?ooo`3oool0@03o
ool2000hoh80oooo00210?ooo`<003SoA@3oool2000004<0oooo0`00>?mo0?ooo`00OP3oool3000h
odP0oooo00<000000?ooo`3oool0A@3oool2000hogd0oooo001l0?ooo`8003SoB`3oool00`000000
oooo0?ooo`170?ooo`8003SoN`3oool007T0oooo0`00>?m=0?ooo`030000003oool0oooo04T0oooo
0P00>?mi0?ooo`00M`3oool2000hoe00oooo00<000000?ooo`3oool0B`3oool3000hogH0oooo001e
0?ooo`8003SoDP3oool00`000000oooo0?ooo`1>0?ooo`8003SoM03oool007<0oooo0P00>?mD0?oo
o`030000003oool0oooo0500oooo0P00>?mb0?ooo`00L@3oool2000hoeH0oooo00<000000?ooo`3o
ool0DP3oool3000hofl0oooo001_0?ooo`8003SoF03oool00`000000oooo0?ooo`1E0?ooo`8003So
K@3oool006d0oooo0P00>?mJ0?ooo`800000F03oool2000hof/0oooo001/0?ooo`03000ho`3oool0
oooo05X0oooo00<000000?ooo`3oool0F@3oool2000hofT0oooo001Z0?ooo`8003SoG@3oool00`00
0000oooo0?ooo`1K0?ooo`8003SoI`3oool006P0oooo0P00>?mO0?ooo`030000003oool0oooo05d0
oooo00<003So0?ooo`3oool0I03oool006H0oooo0P00>?mQ0?ooo`030000003oool0oooo05h0oooo
0P00>?mT0?ooo`00I03oool2000hof<0oooo00<000000?ooo`3oool0H03oool2000hof80oooo001R
0?ooo`8003SoI@3oool00`000000oooo0?ooo`1R0?ooo`03000ho`3oool0oooo05l0oooo001P0?oo
o`8003SoI`3oool00`000000oooo0?ooo`1S0?ooo`8003SoG`3oool005l0oooo00<003So0?ooo`3o
ool0I`3oool00`000000oooo0?ooo`1U0?ooo`03000ho`3oool0oooo05`0oooo001M0?ooo`8003So
JP3oool00`000000oooo0?ooo`1V0?ooo`8003SoG03oool005`0oooo00<003So0?ooo`3oool0JP3o
ool2000006T0oooo0P00>?mJ0?ooo`00F`3oool00`00>?l0oooo0?ooo`1[0?ooo`030000003oool0
oooo06X0oooo00<003So0?ooo`3oool0E`3oool005T0oooo0P00>?m^0?ooo`030000003oool0oooo
06/0oooo0P00>?mG0?ooo`00F03oool00`00>?l0oooo0?ooo`1^0?ooo`030000003oool0oooo06d0
oooo00<003So0?ooo`3oool0E03oool005L0oooo00<003So0?ooo`3oool0K`3oool00`000000oooo
0?ooo`1^0?ooo`8003SoE03oool005D0oooo0P00>?mb0?ooo`030000003oool0oooo0700oooo0P00
>?mB0?ooo`00E03oool00`00>?l0oooo0?ooo`1b0?ooo`030000003oool0oooo0780oooo00<003So
0?ooo`3oool0C`3oool005<0oooo00<003So0?ooo`3oool0L`3oool00`000000oooo0?ooo`1c0?oo
o`8003SoC`3oool00540oooo0P00>?mf0?ooo`030000003oool0oooo07D0oooo00<003So0?ooo`3o
ool0C03oool00500oooo00<003So0?ooo`3oool0MP3oool00`000000oooo0?ooo`1f0?ooo`03000h
o`3oool0oooo04/0oooo001?0?ooo`03000ho`3oool0oooo07L0oooo0P00001h0?ooo`03000ho`3o
ool0oooo04X0oooo001=0?ooo`8003SoNP3oool00`000000oooo0?ooo`1h0?ooo`03000ho`3oool0
oooo04T0oooo001<0?ooo`03000ho`3oool0oooo07X0oooo00<000000?ooo`3oool0N@3oool00`00
>?l0oooo0?ooo`180?ooo`00B`3oool00`00>?l0oooo0?ooo`1k0?ooo`030000003oool0oooo07X0
oooo00<003So0?ooo`3oool0A`3oool004T0oooo0P00>?mn0?ooo`030000003oool0oooo07/0oooo
00<003So0?ooo`3oool0AP3oool004P0oooo00<003So0?ooo`3oool0OP3oool00`000000oooo0?oo
o`1l0?ooo`03000ho`3oool0oooo04D0oooo00170?ooo`03000ho`3oool0oooo07l0oooo00<00000
0?ooo`3oool0O@3oool00`00>?l0oooo0?ooo`140?ooo`00AP3oool00`00>?l0oooo0?ooo`200?oo
o`030000003oool0oooo07h0oooo00<003So0?ooo`3oool0@`3oool004D0oooo00<003So0?ooo`3o
ool0IP3oool2000000@0oooo0P0000050?ooo`030000003oool0oooo0080oooo0P0000070?ooo`03
0000003oool0oooo07l0oooo00<003So0?ooo`3oool0@P3oool004@0oooo00<003So0?ooo`3oool0
IP3oool010000000oooo0?ooo`00000:0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo0800oooo0P00>?m20?ooo`00@`3oool00`00>?l0
oooo0?ooo`1W0?ooo`040000003oool0oooo000000X0oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`040?ooo`<00000PP3oool00`00>?l0oooo0?ooo`0o0?ooo`00@P3oool00`00>?l0
oooo0?ooo`1R0?ooo`@000000P3oool010000000oooo0?ooo`00000;0?ooo`040000003oool0oooo
0?ooo`8000001`3oool00`000000oooo0?ooo`230?ooo`03000ho`3oool0oooo03h0oooo00110?oo
o`03000ho`3oool0oooo06T0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`00
00030?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0Q03oool00`00>?l0oooo0?oo
o`0m0?ooo`00@03oool00`00>?l0oooo0?ooo`1[0?ooo`8000002@3oool4000000<0oooo0`000006
0?ooo`030000003oool0oooo08D0oooo00<003So0?ooo`3oool0?03oool003l0oooo00<003So0?oo
o`3oool0Q`3oool00`000000oooo0?ooo`260?ooo`03000ho`3oool0oooo03/0oooo000n0?ooo`03
000ho`3oool0oooo08P0oooo00<000000?ooo`3oool0Q`3oool00`00>?l0oooo0?ooo`0j0?ooo`00
?@3oool00`00>?l0oooo0?ooo`290?ooo`030000003oool0oooo08P0oooo00<003So0?ooo`3oool0
>@3oool003`0oooo00<003So0?ooo`3oool0RP3oool00`000000oooo0?ooo`290?ooo`03000ho`3o
ool0oooo03P0oooo000k0?ooo`03000ho`3oool0oooo08/0oooo00<000000?ooo`3oool0RP3oool0
0`00>?l0oooo0?ooo`0g0?ooo`00>P3oool00`00>?l0oooo0?ooo`2<0?ooo`800000S03oool00`00
>?l0oooo0?ooo`0f0?ooo`00>@3oool00`00>?l0oooo0?ooo`2=0?ooo`030000003oool0oooo08`0
oooo00<003So0?ooo`3oool0=@3oool003P0oooo00<003So0?ooo`3oool0SP3oool00`000000oooo
0?ooo`2=0?ooo`03000ho`3oool0oooo03@0oooo000g0?ooo`03000ho`3oool0oooo08l0oooo00<0
00000?ooo`3oool0SP3oool00`00>?l0oooo0?ooo`0c0?ooo`00=P3oool00`00>?l0oooo0?ooo`2@
0?ooo`030000003oool0oooo08h0oooo00<003So0?ooo`3oool0<`3oool003D0oooo00<003So0?oo
o`3oool0T@3oool00`000000oooo0?ooo`2?0?ooo`03000ho`3oool0oooo0380oooo000d0?ooo`03
000ho`3oool0oooo0980oooo00<000000?ooo`3oool0T03oool00`00>?l0oooo0?ooo`0a0?ooo`00
<`3oool00`00>?l0oooo0?ooo`230?oooa`0o`1`R03oool00`00>?l0oooo0?ooo`0`0?ooo`00<P3o
ool00`00>?l0oooo0?ooo`1n0?ooo`H0o`1`403oool00`000000oooo0?ooo`090?ooo``0o`1`O@3o
ool00`00>?l0oooo0?ooo`0_0?ooo`00<P3oool00`00>?l0oooo0?ooo`1h0?ooo`H0o`1`5P3oool0
0`000000oooo0?ooo`0E0?ooo`@0o`1`NP3oool00`00>?l0oooo0?ooo`0^0?ooo`00<@3oool00`00
>?l0oooo0?ooo`1e0?ooo`@0o`1`703oool2000001X0oooo103o071f0?ooo`03000ho`3oool0oooo
02h0oooo000`0?ooo`03000ho`3oool0oooo07<0oooo0`3o070P0?ooo`030000003oool0oooo01d0
oooo103o071c0?ooo`03000ho`3oool0oooo02d0oooo000_0?ooo`03000ho`3oool0oooo0740oooo
0`3o070S0?ooo`030000003oool0oooo0240oooo103o071`0?ooo`03000ho`3oool0oooo02`0oooo
000_0?ooo`03000ho`3oool0oooo06l0oooo0P3o070V0?ooo`030000003oool0oooo02D0oooo0P3o
071_0?ooo`03000ho`3oool0oooo02/0oooo000^0?ooo`03000ho`3oool0oooo06d0oooo0`3o070X
0?ooo`030000003oool0oooo02L0oooo0P3o071^0?ooo`03000ho`3oool0oooo02X0oooo000]0?oo
o`03000ho`3oool0oooo06/0oooo0`3o070[0?ooo`030000003oool0oooo02T0oooo0P3o071]0?oo
o`03000ho`3oool0oooo02T0oooo000/0?ooo`03000ho`3oool0oooo06T0oooo0`3o070^0?ooo`03
0000003oool0oooo02/0oooo0`3o071Z0?ooo`03000ho`3oool0oooo02T0oooo000[0?ooo`03000h
o`3oool0oooo06P0oooo0P3o070a0?ooo`030000003oool0oooo02h0oooo0P3o071Y0?ooo`03000h
o`3oool0oooo02P0oooo000[0?ooo`03000ho`3oool0oooo06H0oooo0P3o070c0?ooo`030000003o
ool0oooo0300oooo0P3o071X0?ooo`03000ho`3oool0oooo02L0oooo000Z0?ooo`03000ho`3oool0
oooo06D0oooo0P3o070e0?ooo`030000003oool0oooo0380oooo0P3o071W0?ooo`03000ho`3oool0
oooo02H0oooo000Y0?ooo`03000ho`3oool0oooo06<0oooo0`3o070g0?ooo`800000=@3oool20?l0
L6H0oooo00<003So0?ooo`3oool09@3oool002P0oooo00<003So0?ooo`3oool0HP3oool20?l0L3X0
oooo00<000000?ooo`3oool0=P3oool20?l0L6D0oooo00<003So0?ooo`3oool0903oool002P0oooo
00<003So0?ooo`3oool0H03oool20?l0L3`0oooo00<000000?ooo`3oool0>03oool20?l0L6<0oooo
00<003So0?ooo`3oool0903oool002L0oooo00<003So0?ooo`3oool0G`3oool20?l0L3h0oooo00<0
00000?ooo`3oool0>P3oool20?l0L680oooo00<003So0?ooo`3oool08`3oool002H0oooo00<003So
0?ooo`3oool0GP3oool20?l0L400oooo00<000000?ooo`3oool0?03oool20?l0L640oooo00<003So
0?ooo`3oool08P3oool002D0oooo00<003So0?ooo`3oool0GP3oool00`3o0700oooo0?ooo`100?oo
o`030000003oool0oooo03h0oooo0P3o071P0?ooo`03000ho`3oool0oooo0240oooo000U0?ooo`03
000ho`3oool0oooo05`0oooo0P3o07130?ooo`030000003oool0oooo0400oooo0P3o071O0?ooo`03
000ho`3oool0oooo0200oooo000T0?ooo`03000ho`3oool0oooo05`0oooo00<0o`1`0?ooo`3oool0
@`3oool00`000000oooo0?ooo`120?ooo`030?l0L03oool0oooo05`0oooo00<003So0?ooo`3oool0
803oool002<0oooo00<003So0?ooo`3oool0F`3oool20?l0L4H0oooo00<000000?ooo`3oool0@`3o
ool20?l0L5d0oooo00<003So0?ooo`3oool07`3oool00280oooo00<003So0?ooo`3oool0FP3oool2
0?l0L4P0oooo00<000000?ooo`3oool0A@3oool00`3o0700oooo0?ooo`1J0?ooo`03000ho`3oool0
oooo01l0oooo000R0?ooo`03000ho`3oool0oooo05T0oooo00<0o`1`0?ooo`3oool0B03oool20000
04L0oooo0P3o071K0?ooo`03000ho`3oool0oooo01h0oooo000Q0?ooo`03000ho`3oool0oooo05P0
oooo0P3o071;0?ooo`030000003oool0oooo04P0oooo00<0o`1`0?ooo`3oool0F03oool00`00>?l0
oooo0?ooo`0N0?ooo`008@3oool00`00>?l0oooo0?ooo`1G0?ooo`030?l0L03oool0oooo04/0oooo
00<000000?ooo`3oool0B@3oool20?l0L5T0oooo00<003So0?ooo`3oool07@3oool00200oooo00<0
03So0?ooo`3oool0E`3oool00`3o0700oooo0?ooo`1<0?ooo`030000003oool0oooo04/0oooo00<0
o`1`0?ooo`3oool0E`3oool00`00>?l0oooo0?ooo`0L0?ooo`00803oool00`00>?l0oooo0?ooo`1F
0?ooo`030?l0L03oool0oooo04d0oooo00<000000?ooo`3oool0C03oool20?l0L5L0oooo00<003So
0?ooo`3oool0703oool001l0oooo00<003So0?ooo`3oool0EP3oool00`3o0700oooo0?ooo`1>0?oo
o`030000003oool0oooo04h0oooo00<0o`1`0?ooo`3oool0E@3oool00`00>?l0oooo0?ooo`0K0?oo
o`007`3oool00`00>?l0oooo0?ooo`1E0?ooo`030?l0L03oool0oooo04l0oooo00<000000?ooo`3o
ool0C`3oool20?l0L5D0oooo00<003So0?ooo`3oool06`3oool001h0oooo00<003So0?ooo`3oool0
E@3oool00`3o0700oooo0?ooo`0k0?ooo`800000103oool2000000@0oooo0P0000070?ooo`030000
003oool0oooo0540oooo00<0o`1`0?ooo`3oool0D`3oool00`00>?l0oooo0?ooo`0J0?ooo`007@3o
ool00`00>?l0oooo0?ooo`1D0?ooo`80o`1`?@3oool010000000oooo0?ooo`0000080?ooo`040000
003oool0oooo000000H0oooo00<000000?ooo`3oool0DP3oool00`3o0700oooo0?ooo`1B0?ooo`03
000ho`3oool0oooo01X0oooo000M0?ooo`03000ho`3oool0oooo05<0oooo00<0o`1`0?ooo`3oool0
?@3oool010000000oooo0?ooo`00000;0?ooo`030000003oool0oooo00@0oooo0`00001C0?ooo`03
0?l0L03oool0oooo0580oooo00<003So0?ooo`3oool06@3oool001`0oooo00<003So0?ooo`3oool0
D`3oool00`3o0700oooo0?ooo`0h0?ooo`@000000P3oool010000000oooo0?ooo`0000090?ooo`80
00001`3oool00`000000oooo0?ooo`1D0?ooo`030?l0L03oool0oooo0580oooo00<003So0?ooo`3o
ool0603oool001`0oooo00<003So0?ooo`3oool0DP3oool00`3o0700oooo0?ooo`0o0?ooo`040000
003oool0oooo000000T0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`1E0?ooo`03
0?l0L03oool0oooo0540oooo00<003So0?ooo`3oool0603oool001/0oooo00<003So0?ooo`3oool0
DP3oool00`3o0700oooo0?ooo`110?ooo`8000002P3oool3000000H0oooo00<000000?ooo`3oool0
EP3oool00`3o0700oooo0?ooo`1A0?ooo`03000ho`3oool0oooo01L0oooo000K0?ooo`03000ho`3o
ool0oooo0540oooo00<0o`1`0?ooo`3oool0E`3oool00`000000oooo0?ooo`1G0?ooo`030?l0L03o
ool0oooo0500oooo00<003So0?ooo`3oool05`3oool001X0oooo00<003So0?ooo`3oool0D@3oool0
0`3o0700oooo0?ooo`1H0?ooo`030000003oool0oooo05L0oooo00<0o`1`0?ooo`3oool0D@3oool0
0`00>?l0oooo0?ooo`0F0?ooo`006@3oool00`00>?l0oooo0?ooo`1A0?ooo`030?l0L03oool0oooo
05T0oooo00<000000?ooo`3oool0F03oool00`3o0700oooo0?ooo`1@0?ooo`03000ho`3oool0oooo
01H0oooo000I0?ooo`03000ho`3oool0oooo0500oooo00<0o`1`0?ooo`3oool0FP3oool00`000000
oooo0?ooo`1I0?ooo`030?l0L03oool0oooo0500oooo00<003So0?ooo`3oool05@3oool001P0oooo
00<003So0?ooo`3oool0D03oool00`3o0700oooo0?ooo`1K0?ooo`030000003oool0oooo05X0oooo
00<0o`1`0?ooo`3oool0D03oool00`00>?l0oooo0?ooo`0D0?ooo`00603oool00`00>?l0oooo0?oo
o`1?0?ooo`030?l0L03oool0oooo05`0oooo00<000000?ooo`3oool0F`3oool00`3o0700oooo0?oo
o`1?0?ooo`03000ho`3oool0oooo01@0oooo000G0?ooo`03000ho`3oool0oooo04l0oooo00<0o`1`
0?ooo`3oool0G@3oool2000005d0oooo00<0o`1`0?ooo`3oool0C`3oool00`00>?l0oooo0?ooo`0C
0?ooo`005`3oool00`00>?l0oooo0?ooo`1>0?ooo`030?l0L03oool0oooo05h0oooo00<000000?oo
o`3oool0G@3oool00`3o0700oooo0?ooo`1>0?ooo`03000ho`3oool0oooo01<0oooo000F0?ooo`03
000ho`3oool0oooo04l0oooo00<0o`1`0?ooo`3oool0GP3oool00`000000oooo0?ooo`1N0?ooo`03
0?l0L03oool0oooo04h0oooo00<003So0?ooo`3oool04P3oool001H0oooo00<003So0?ooo`3oool0
CP3oool00`3o0700oooo0?ooo`1O0?ooo`030000003oool0oooo05l0oooo00<0o`1`0?ooo`3oool0
C@3oool00`00>?l0oooo0?ooo`0B0?ooo`005@3oool00`00>?l0oooo0?ooo`1>0?ooo`030?l0L03o
ool0oooo0600oooo00<000000?ooo`3oool0H03oool00`3o0700oooo0?ooo`1=0?ooo`03000ho`3o
ool0oooo0140oooo000E0?ooo`03000ho`3oool0oooo04d0oooo00<0o`1`0?ooo`3oool0H@3oool0
0`000000oooo0?ooo`1P0?ooo`030?l0L03oool0oooo04d0oooo00<003So0?ooo`3oool04@3oool0
01@0oooo00<003So0?ooo`3oool0C@3oool00`3o0700oooo0?ooo`1R0?ooo`030000003oool0oooo
0640oooo00<0o`1`0?ooo`3oool0C@3oool00`00>?l0oooo0?ooo`0@0?ooo`00503oool00`00>?l0
oooo0?ooo`1<0?ooo`030?l0L03oool0oooo06<0oooo00<000000?ooo`3oool0HP3oool00`3o0700
oooo0?ooo`1<0?ooo`03000ho`3oool0oooo0100oooo000C0?ooo`03000ho`3oool0oooo04`0oooo
00<0o`1`0?ooo`3oool0I03oool00`000000oooo0?ooo`1S0?ooo`030?l0L03oool0oooo04/0oooo
00<003So0?ooo`3oool0403oool001<0oooo00<003So0?ooo`3oool0B`3oool00`3o0700oooo0?oo
o`1U0?ooo`030000003oool0oooo06@0oooo00<0o`1`0?ooo`3oool0B`3oool00`00>?l0oooo0?oo
o`0?0?ooo`004`3oool00`00>?l0oooo0?ooo`1;0?ooo`030?l0L03oool0oooo06D0oooo0P00001V
0?ooo`030?l0L03oool0oooo04X0oooo00<003So0?ooo`3oool03`3oool00180oooo00<003So0?oo
o`3oool0B`3oool00`3o0700oooo0?ooo`1V0?ooo`030000003oool0oooo06D0oooo00<0o`1`0?oo
o`3oool0B`3oool00`00>?l0oooo0?ooo`0>0?ooo`004P3oool00`00>?l0oooo0?ooo`1:0?ooo`03
0?l0L03oool0oooo06L0oooo00<000000?ooo`3oool0IP3oool00`3o0700oooo0?ooo`1:0?ooo`03
000ho`3oool0oooo00h0oooo000B0?ooo`03000ho`3oool0oooo04T0oooo00<0o`1`0?ooo`3oool0
J03oool00`000000oooo0?ooo`1W0?ooo`030?l0L03oool0oooo04T0oooo00<003So0?ooo`3oool0
3P3oool00140oooo00<003So0?ooo`3oool0BP3oool00`3o0700oooo0?ooo`1X0?ooo`030000003o
ool0oooo06P0oooo00<0o`1`0?ooo`3oool0B@3oool00`00>?l0oooo0?ooo`0=0?ooo`004@3oool0
0`00>?l0oooo0?ooo`190?ooo`030?l0L03oool0oooo06T0oooo00<000000?ooo`3oool0J@3oool0
0`3o0700oooo0?ooo`180?ooo`03000ho`3oool0oooo00d0oooo000@0?ooo`03000ho`3oool0oooo
04T0oooo00<0o`1`0?ooo`3oool0H@3ooolE003oi600oooo00<0o`1`0?ooo`3oool0B03oool00`00
>?l0oooo0?ooo`0=0?ooo`00403oool00`00>?l0oooo0?ooo`190?ooo`030?l0L03oool0oooo05X0
oooo1`00on@90?ooo`030000003oool0oooo00T0oooo1000onAM0?ooo`030?l0L03oool0oooo04P0
oooo00<003So0?ooo`3oool0303oool00100oooo00<003So0?ooo`3oool0B03oool00`3o0700oooo
0?ooo`1F0?ooo`D00?oT403oool00`000000oooo0?ooo`0=0?ooo`@00?oTF@3oool00`3o0700oooo
0?ooo`180?ooo`03000ho`3oool0oooo00`0oooo000?0?ooo`03000ho`3oool0oooo04P0oooo00<0
o`1`0?ooo`3oool0E@3oool2003oi1D0oooo00<000000?ooo`3oool04@3oool3003oi5L0oooo00<0
o`1`0?ooo`3oool0A`3oool00`00>?l0oooo0?ooo`0<0?ooo`003`3oool00`00>?l0oooo0?ooo`17
0?ooo`030?l0L03oool0oooo05@0oooo0P00on@G0?ooo`800000K@3oool00`3o0700oooo0?ooo`17
0?ooo`03000ho`3oool0oooo00/0oooo000>0?ooo`03000ho`3oool0oooo04P0oooo00<0o`1`0?oo
o`3oool0D@3oool3003oi1T0oooo00<000000?ooo`3oool0K03oool00`3o0700oooo0?ooo`170?oo
o`03000ho`3oool0oooo00/0oooo000>0?ooo`03000ho`3oool0oooo04L0oooo00<0o`1`0?ooo`3o
ool0D03oool2003oi1`0oooo00<000000?ooo`3oool0K@3oool00`3o0700oooo0?ooo`170?ooo`03
000ho`3oool0oooo00X0oooo000>0?ooo`03000ho`3oool0oooo04H0oooo00<0o`1`0?ooo`3oool0
C`3oool2003oi1h0oooo00<000000?ooo`3oool0K@3oool00`3o0700oooo0?ooo`170?ooo`03000h
o`3oool0oooo00X0oooo000=0?ooo`03000ho`3oool0oooo04L0oooo00<0o`1`0?ooo`3oool0C@3o
ool2003oi200oooo00<000000?ooo`3oool0KP3oool00`3o0700oooo0?ooo`160?ooo`03000ho`3o
ool0oooo00X0oooo000=0?ooo`03000ho`3oool0oooo04H0oooo00<0o`1`0?ooo`3oool0C03oool2
003oi280oooo00<000000?ooo`3oool0K`3oool00`3o0700oooo0?ooo`160?ooo`03000ho`3oool0
oooo00T0oooo000=0?ooo`03000ho`3oool0oooo04H0oooo00<0o`1`0?ooo`3oool0BP3oool2003o
i2@0oooo00<000000?ooo`3oool0K`3oool00`3o0700oooo0?ooo`160?ooo`03000ho`3oool0oooo
00T0oooo000<0?ooo`03000ho`3oool0oooo04H0oooo00<0o`1`0?ooo`3oool0B@3oool2003oi2H0
oooo00<000000?ooo`3oool0L03oool00`3o0700oooo0?ooo`150?ooo`03000ho`3oool0oooo00T0
oooo000<0?ooo`03000ho`3oool0oooo04H0oooo00<0o`1`0?ooo`3oool0A`3oool2003oi2P0oooo
00<000000?ooo`3oool0L03oool00`3o0700oooo0?ooo`160?ooo`03000ho`3oool0oooo00P0oooo
000;0?ooo`03000ho`3oool0oooo04H0oooo00<0o`1`0?ooo`3oool0A`3oool00`00on@0oooo0?oo
o`0X0?ooo`800000LP3oool00`3o0700oooo0?ooo`150?ooo`03000ho`3oool0oooo00P0oooo000;
0?ooo`03000ho`3oool0oooo04H0oooo00<0o`1`0?ooo`3oool0AP3oool00`00on@0oooo0?ooo`0Y
0?ooo`030000003oool0oooo0740oooo00<0o`1`0?ooo`3oool0AP3oool00`00>?l0oooo0?ooo`07
0?ooo`002`3oool00`00>?l0oooo0?ooo`150?ooo`030?l0L03oool0oooo04H0oooo00<00?oT0?oo
o`3oool0:P3oool00`000000oooo0?ooo`1b0?ooo`030?l0L03oool0oooo04D0oooo00<003So0?oo
o`3oool01`3oool000/0oooo00<003So0?ooo`3oool0A@3oool00`3o0700oooo0?ooo`150?ooo`03
003oi03oool0oooo02/0oooo00<000000?ooo`3oool0;03oool3003oi4<0oooo00<0o`1`0?ooo`3o
ool0A@3oool00`00>?l0oooo0?ooo`070?ooo`002P3oool00`00>?l0oooo0?ooo`150?ooo`030?l0
L03oool0oooo04@0oooo0P00on@^0?ooo`030000003oool0oooo02/0oooo1@00onA30?ooo`030?l0
L03oool0oooo04D0oooo00<003So0?ooo`3oool01P3oool000X0oooo00<003So0?ooo`3oool0A@3o
ool00`3o0700oooo0?ooo`130?ooo`03003oi03oool0oooo02h0oooo00<000000?ooo`3oool0:P3o
ool7003oi480oooo00<0o`1`0?ooo`3oool0A@3oool00`00>?l0oooo0?ooo`060?ooo`002P3oool0
0`00>?l0oooo0?ooo`140?ooo`030?l0L03oool0oooo04<0oooo00<00?oT0?ooo`3oool0;`3oool0
0`000000oooo0?ooo`0Z0?ooo`L00?oT@P3oool00`3o0700oooo0?ooo`150?ooo`03000ho`3oool0
oooo00H0oooo000:0?ooo`03000ho`3oool0oooo04@0oooo00<0o`1`0?ooo`3oool0@P3oool00`00
on@0oooo0?ooo`0`0?ooo`030000003oool0oooo02X0oooo1`00onA30?ooo`030?l0L03oool0oooo
04@0oooo00<003So0?ooo`3oool01P3oool000T0oooo00<003So0?ooo`3oool0A@3oool00`3o0700
oooo0?ooo`110?ooo`03003oi03oool0oooo01H0oooo0P0000040?ooo`8000000`3oool4000000<0
oooo0P0000070?ooo`030000003oool0oooo02/0oooo2000onA10?ooo`030?l0L03oool0oooo04D0
oooo00<003So0?ooo`3oool01@3oool000T0oooo00<003So0?ooo`3oool0A03oool00`3o0700oooo
0?ooo`110?ooo`03003oi03oool0oooo01H0oooo00@000000?ooo`3oool00000203oool00`000000
oooo0?ooo`030?ooo`040000003oool0oooo000000H0oooo00<000000?ooo`3oool0;03oool8003o
i400oooo00<0o`1`0?ooo`3oool0A@3oool00`00>?l0oooo0?ooo`050?ooo`002@3oool00`00>?l0
oooo0?ooo`140?ooo`030?l0L03oool0oooo0400oooo00<00?oT0?ooo`3oool05`3oool010000000
oooo0?ooo`0000090?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0103oool30000
0300oooo1P00on@o0?ooo`030?l0L03oool0oooo04@0oooo00<003So0?ooo`3oool01@3oool000T0
oooo00<003So0?ooo`3oool0@`3oool00`3o0700oooo0?ooo`100?ooo`03003oi03oool0oooo0180
oooo100000020?ooo`040000003oool0oooo000000X0oooo00<000000?ooo`3oool00P3oool20000
00L0oooo00<000000?ooo`3oool0<03oool8003oi3d0oooo00<0o`1`0?ooo`3oool0A03oool00`00
>?l0oooo0?ooo`050?ooo`002@3oool00`00>?l0oooo0?ooo`130?ooo`030?l0L03oool0oooo03l0
oooo00<00?oT0?ooo`3oool06@3oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo
000000<0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0a0?ooo`P00?oT?@3oool0
0`3o0700oooo0?ooo`140?ooo`03000ho`3oool0oooo00@0oooo00080?ooo`03000ho`3oool0oooo
04@0oooo00<0o`1`0?ooo`3oool0?P3oool00`00on@0oooo0?ooo`0K0?ooo`8000002P3oool20000
00@0oooo0`0000060?ooo`030000003oool0oooo0340oooo2P00on@k0?ooo`030?l0L03oool0oooo
04@0oooo00<003So0?ooo`3oool0103oool000P0oooo00<003So0?ooo`3oool0@`3oool00`3o0700
oooo0?ooo`0n0?ooo`03003oi03oool0oooo03L0oooo00<000000?ooo`3oool0<P3oool:003oi3X0
oooo00<0o`1`0?ooo`3oool0A03oool00`00>?l0oooo0?ooo`040?ooo`00203oool00`00>?l0oooo
0?ooo`130?ooo`030?l0L03oool0oooo03d0oooo00<00?oT0?ooo`3oool0>03oool00`000000oooo
0?ooo`0c0?ooo`/00?oT>@3oool00`3o0700oooo0?ooo`130?ooo`03000ho`3oool0oooo00@0oooo
00080?ooo`03000ho`3oool0oooo0480oooo00<0o`1`0?ooo`3oool0?P3oool00`00on@0oooo0?oo
o`0h0?ooo`030000003oool0oooo03<0oooo1@00on@30?ooo`@00?oT>03oool00`3o0700oooo0?oo
o`140?ooo`03000ho`3oool0oooo00<0oooo00080?ooo`03000ho`3oool0oooo0480oooo00<0o`1`
0?ooo`3oool0?@3oool00`00on@0oooo0?ooo`0i0?ooo`030000003oool0oooo03@0oooo1000onA0
0?ooo`030?l0L03oool0oooo04<0oooo00<003So0?ooo`3oool00`3oool000L0oooo00<003So0?oo
o`3oool0@`3oool00`3o0700oooo0?ooo`0m0?ooo`03003oi03oool0oooo03T0oooo00<000000?oo
o`3oool0=03oool5003oi3l0oooo00<0o`1`0?ooo`3oool0@`3oool00`00>?l0oooo0?ooo`030?oo
o`001`3oool00`00>?l0oooo0?ooo`120?ooo`030?l0L03oool0oooo03d0oooo00<00?oT0?ooo`3o
ool0>P3oool00`000000oooo0?ooo`0e0?ooo`@00?oT?`3oool00`3o0700oooo0?ooo`130?ooo`03
000ho`3oool0oooo00<0oooo00070?ooo`03000ho`3oool0oooo0480oooo00<0o`1`0?ooo`3oool0
?@3oool00`00on@0oooo0?ooo`0j0?ooo`800000=P3oool3003oi0030?ooo`00on@0oooo03h0oooo
00<0o`1`0?ooo`3oool0@`3oool00`00>?l0oooo0?ooo`020?ooo`001`3oool00`00>?l0oooo0?oo
o`110?ooo`030?l0L03oool0oooo03d0oooo00<00?oT0?ooo`3oool0>`3oool00`000000oooo0?oo
o`0f0?ooo`800?oT0P3oool00`00on@0oooo0?ooo`0l0?ooo`030?l0L03oool0oooo04<0oooo00<0
03So0?ooo`3oool00P3oool000H0oooo00<003So0?ooo`3oool0@P3oool00`3o0700oooo0?ooo`0m
0?ooo`03003oi03oool0oooo03/0oooo00<000000?ooo`3oool0=P3oool2003oi080oooo00<00?oT
0?ooo`3oool0?03oool00`3o0700oooo0?ooo`130?ooo`03000ho`3oool0oooo0080oooo00060?oo
o`03000ho`3oool0oooo0480oooo00<0o`1`0?ooo`3oool0?03oool00`00on@0oooo0?ooo`0l0?oo
o`030000003oool0oooo03L0oooo00D00?oT0?ooo`3oool0oooo003oi00n0?ooo`030?l0L03oool0
oooo0480oooo00<003So0?ooo`3oool00P3oool000H0oooo00<003So0?ooo`3oool0@P3oool00`3o
0700oooo0?ooo`0k0?ooo`03003oi03oool0oooo03D0oooo00<0ooT00?ooo`3oool01@3oool00`00
0000oooo0?ooo`0l0?ooo`03003oi03oool0oooo03/0oooo00<0o`1`0?ooo`3oool0@`3oool00`00
>?l0oooo0?ooo`010?ooo`00BP3oool00`3o0700oooo0?ooo`0l0?ooo`03003oi03oool0oooo03@0
oooo0P3on@070?ooo`030000003oool0oooo03`0oooo00<00?oT0?ooo`3oool0?03oool00`3o0700
oooo0?ooo`120?ooo`03000ho`3oool0oooo0040oooo001:0?ooo`030?l0L03oool0oooo03/0oooo
00<00?oT0?ooo`3oool0=@3oool20?oi00L0oooo00<000000?ooo`3oool0?@3oool00`00on@0oooo
0?ooo`0k0?ooo`030?l0L03oool0oooo0480oooo00<003So0?ooo`3oool00@3oool004X0oooo00<0
o`1`0?ooo`3oool0>`3oool00`00on@0oooo0?ooo`0d0?ooo`<0ooT01`3oool00`000000oooo0?oo
o`0m0?ooo`03003oi03oool0oooo03/0oooo00<0o`1`0?ooo`3oool0AP3oool004X0oooo00<0o`1`
0?ooo`3oool0>P3oool00`00on@0oooo0?ooo`0d0?ooo`<0ooT0203oool00`000000oooo0?ooo`0n
0?ooo`03003oi03oool0oooo03X0oooo00<0o`1`0?ooo`3oool0AP3oool004X0oooo00<0o`1`0?oo
o`3oool0>P3oool00`00on@0oooo0?ooo`0d0?ooo`<0ooT0203oool00`000000oooo0?ooo`0n0?oo
o`03003oi03oool0oooo03X0oooo00<0o`1`0?ooo`3oool0AP3oool004T0oooo00<0o`1`0?ooo`3o
ool0>P3oool00`00on@0oooo0?ooo`0d0?ooo`@0ooT0203oool200000400oooo00<00?oT0?ooo`3o
ool0>P3oool00`3o0700oooo0?ooo`150?ooo`00B@3oool00`3o0700oooo0?ooo`0j0?ooo`03003o
i03oool0oooo03<0oooo3@3on@000`000000oooo0?ooo`0o0?ooo`03003oi03oool0oooo03X0oooo
00<0o`1`0?ooo`3oool0A@3oool004T0oooo00<0o`1`0?ooo`3oool0>@3oool00`00on@0oooo0?oo
o`0c0?ooo`d0ooT000<0oooo0000003oool0@@3oool00`00on@0oooo0?ooo`0i0?ooo`030?l0L03o
ool0oooo04D0oooo00190?ooo`030?l0L03oool0oooo03T0oooo00<00?oT0?ooo`3oool0<`3ooolC
0?oi03h0oooo00<00?oT0?ooo`3oool0>@3oool00`3o0700oooo0?ooo`150?ooo`00B@3oool00`3o
0700oooo0?ooo`0h0?ooo`03003oi03oool0oooo03<0oooo2`3on@040?ooo`030000003oool0oooo
0080oooo0`3on@0l0?ooo`03003oi03oool0oooo03P0oooo00<0o`1`0?ooo`3oool0A@3oool004T0
oooo00<0o`1`0?ooo`3oool0>03oool00`00on@0oooo0?ooo`0b0?ooo`T0ooT01`3oool00`000000
oooo0?ooo`050?ooo`80ooT0>P3oool00`00on@0oooo0?ooo`0h0?ooo`030?l0L03oool0oooo04D0
oooo00180?ooo`030?l0L03oool0oooo03T0oooo00<00?oT0?ooo`3oool0<P3oool70?oi00T0oooo
00<000000?ooo`3oool01`3oool20?oi03P0oooo00<00?oT0?ooo`3oool0>03oool00`3o0700oooo
0?ooo`150?ooo`00B03oool00`3o0700oooo0?ooo`0h0?ooo`03003oi03oool0oooo0380oooo1P3o
n@0;0?ooo`030000003oool0oooo00T0oooo0P3on@0g0?ooo`03003oi03oool0oooo03P0oooo00<0
o`1`0?ooo`3oool0A03oool004P0oooo00<0o`1`0?ooo`3oool0>03oool00`00on@0oooo0?ooo`0_
0?ooo`L0ooT03@3oool00`000000oooo0?ooo`0;0?ooo`80ooT0=@3oool00`00on@0oooo0?ooo`0h
0?ooo`030?l0L03oool0oooo04@0oooo00180?ooo`030?l0L03oool0oooo03P0oooo00<00?oT0?oo
o`3oool0;P3oool60?oi00l0oooo0P00000>0?ooo`030?oi003oool0oooo0380oooo00<00?oT0?oo
o`3oool0>03oool00`3o0700oooo0?ooo`140?ooo`00B03oool00`3o0700oooo0?ooo`0h0?ooo`03
003oi03oool0oooo02d0oooo1`3on@0?0?ooo`030000003oool0oooo00h0oooo0P3on@0b0?ooo`03
003oi03oool0oooo03P0oooo00<0o`1`0?ooo`3oool0A03oool004P0oooo00<0o`1`0?ooo`3oool0
=`3oool00`00on@0oooo0?ooo`0^0?ooo`L0ooT03`3oool00`000000oooo0?ooo`0@0?ooo`030?oi
003oool0oooo0300oooo00<00?oT0?ooo`3oool0=`3oool00`3o0700oooo0?ooo`140?ooo`00A`3o
ool00`3o0700oooo0?ooo`0h0?ooo`03003oi03oool0oooo02h0oooo1`3on@0?0?ooo`030000003o
ool0oooo0140oooo00<0ooT00?ooo`3oool0;`3oool00`00on@0oooo0?ooo`0g0?ooo`030?l0L03o
ool0oooo04@0oooo00170?ooo`030?l0L03oool0oooo03P0oooo00<00?oT0?ooo`3oool0;`3oool5
0?oi0100oooo00<000000?ooo`3oool04@3oool00`3on@00oooo0?ooo`0_0?ooo`03003oi03oool0
oooo03L0oooo00<0o`1`0?ooo`3oool0A03oool004L0oooo00<0o`1`0?ooo`3oool0>03oool00`00
on@0oooo0?ooo`0`0?ooo`<0ooT04@3oool00`000000oooo0?ooo`0B0?ooo`030?oi003oool0oooo
02h0oooo00<00?oT0?ooo`3oool0>03oool00`3o0700oooo0?ooo`130?ooo`00A`3oool00`3o0700
oooo0?ooo`0g0?ooo`03003oi03oool0oooo04D0oooo00<000000?ooo`3oool04`3oool00`3on@00
oooo0?ooo`0^0?ooo`03003oi03oool0oooo03L0oooo00<0o`1`0?ooo`3oool0@`3oool000L0oooo
1@00000S0?ooo`800000103oool2000000D0oooo00<000000?ooo`3oool00P3oool2000000@0oooo
00<0o`1`0?ooo`3oool06@3oool2000000@0oooo0P0000040?ooo`800000403oool00`00on@0oooo
0?ooo`0=0?ooo`800000103oool2000000<0oooo100000030?ooo`800000903oool00`000000oooo
0?ooo`0C0?ooo`030?oi003oool0oooo00d0oooo0P0000040?ooo`8000000`3oool4000000<0oooo
0P00000=0?ooo`03003oi03oool0oooo0100oooo0P0000040?ooo`800000103oool2000001T0oooo
00<0o`1`0?ooo`3oool0103oool2000000@0oooo0P0000050?ooo`030000003oool0oooo0080oooo
0P00000U0?ooo`D000000@3oool000T0oooo00<000000?ooo`3oool08P3oool010000000oooo0?oo
o`00000:0?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0o`1`
01X0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`00000?0?ooo`03003oi03o
ool0oooo00`0oooo00@000000?ooo`3oool00000203oool00`000000oooo0?ooo`030?ooo`040000
003oool0oooo000002<0oooo00<000000?ooo`3oool0503oool00`3on@00oooo0?ooo`0;0?ooo`04
0000003oool0oooo000000P0oooo00<000000?ooo`3oool00`3oool010000000oooo0?ooo`00000<
0?ooo`03003oi03oool0oooo00l0oooo00@000000?ooo`3oool00000203oool010000000oooo0?oo
o`00000H0?ooo`030?l0L03oool0oooo00<0oooo00@000000?ooo`3oool000002P3oool01@000000
oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`010?oo
o`002@3oool00`000000oooo0?ooo`0R0?ooo`040000003oool0oooo000000X0oooo00<000000?oo
o`3oool0103oool01@000000oooo0?ooo`3oool0o`1`01X0oooo00@000000?ooo`3oool000002`3o
ool00`000000oooo0?ooo`0=0?ooo`03003oi03oool0oooo00`0oooo00@000000?ooo`3oool00000
2@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0240oooo00<000000?ooo`3oool0
503oool00`3on@00oooo0?ooo`0;0?ooo`040000003oool0oooo000000T0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`0:0?ooo`03003oi03oool0oooo00l0oooo00@000000?ooo`3o
ool000002`3oool00`000000oooo0?ooo`0F0?ooo`030?l0L03oool0oooo00<0oooo00@000000?oo
o`3oool000002P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo02@0oooo00<00000
0?ooo`3oool00@3oool000030?ooo`000000000000800000103oool00`000000oooo0?ooo`0L0?oo
o`@000000P3oool010000000oooo0?ooo`00000;0?ooo`040000003oool0oooo0?ooo`800000103o
ool00`3o0700oooo0?ooo`0B0?ooo`@000000P3oool010000000oooo0?ooo`0000090?ooo`800000
403oool00`00on@0oooo0?ooo`060?ooo`@000000P3oool010000000oooo0?ooo`00000:0?ooo`03
0000003oool0oooo0080oooo0P00000;0?ooo`030?oi003oool0oooo01H0oooo0P00000F0?ooo`03
0?oi003oool0oooo00X0oooo00@000000?ooo`3oool000002P3oool00`000000oooo0?ooo`020?oo
o`8000003@3oool00`00on@0oooo0?ooo`0?0?ooo`040000003oool0oooo000000T0oooo0P00000I
0?ooo`030?l0L03oool0oooo00<0oooo00@000000?ooo`3oool000002`3oool010000000oooo0?oo
o`3oool2000002L0oooo00<000000?ooo`3oool00@3oool000T0oooo00<000000?ooo`3oool08P3o
ool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3o
ool00P3oool00`3o0700oooo0?ooo`0I0?ooo`040000003oool0oooo000000T0oooo00<000000?oo
o`3oool03P3oool00`00on@0oooo0?ooo`0=0?ooo`040000003oool0oooo000000P0oooo00@00000
0?ooo`3oool000000`3oool00`000000oooo0?ooo`0:0?ooo`030?oi003oool0oooo01H0oooo00<0
00000?ooo`3oool05@3oool00`3on@00oooo0?ooo`0:0?ooo`040000003oool0oooo000000P0oooo
00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`0<0?ooo`03003oi03oool0oooo00l0
oooo00@000000?ooo`3oool000002@3oool00`000000oooo0?ooo`0H0?ooo`030?l0L03oool0oooo
00<0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`0000030?ooo`030000003o
ool0oooo02H0oooo00<000000?ooo`3oool00@3oool000P0oooo0P00000U0?ooo`8000002@3oool4
000000<0oooo0`0000020?ooo`030?l0L03oool0oooo01X0oooo0P00000:0?ooo`<000003P3oool0
0`00on@0oooo0?ooo`0>0?ooo`8000002P3oool2000000@0oooo0`0000090?ooo`80ooT0603oool0
0`000000oooo0?ooo`0E0?ooo`030?oi003oool0oooo00/0oooo0P00000:0?ooo`800000103oool3
000000`0oooo00<00?oT0?ooo`3oool0403oool2000000X0oooo0`00000I0?ooo`030?l0L03oool0
oooo00<0oooo0P0000090?ooo`@000000`3oool3000002D0oooo0P0000030?ooo`00AP3oool00`3o
0700oooo0?ooo`0g0?ooo`03003oi03oool0oooo02`0oooo00<0ooT00?ooo`3oool05`3oool00`00
0000oooo0?ooo`0F0?ooo`030?oi003oool0oooo02`0oooo00<00?oT0?ooo`3oool0=`3oool00`3o
0700oooo0?ooo`120?ooo`00AP3oool00`3o0700oooo0?ooo`0g0?ooo`03003oi03oool0oooo02`0
oooo00<0ooT00?ooo`3oool05`3oool00`000000oooo0?ooo`0F0?ooo`030?oi003oool0oooo02`0
oooo00<00?oT0?ooo`3oool0=`3oool00`3o0700oooo0?ooo`120?ooo`00AP3oool00`3o0700oooo
0?ooo`0g0?ooo`03003oi03oool0oooo02`0oooo00<0ooT00?ooo`3oool05`3oool00`000000oooo
0?ooo`0F0?ooo`030?oi003oool0oooo02`0oooo00<00?oT0?ooo`3oool0=`3oool00`3o0700oooo
0?ooo`120?ooo`00AP3oool00`3o0700oooo0?ooo`0g0?ooo`03003oi03oool0oooo02`0oooo00<0
ooT00?ooo`3oool05`3oool00`000000oooo0?ooo`0F0?ooo`030?oi003oool0oooo02`0oooo00<0
0?oT0?ooo`3oool0=`3oool00`3o0700oooo0?ooo`120?ooo`00AP3oool00`3o0700oooo0?ooo`0g
0?ooo`03003oi03oool0oooo02/0oooo00<0ooT00?ooo`3oool0603oool00`000000oooo0?ooo`0F
0?ooo`030?oi003oool0oooo02`0oooo00<00?oT0?ooo`3oool0=`3oool00`3o0700oooo0?ooo`12
0?ooo`00AP3oool00`3o0700oooo0?ooo`0g0?ooo`03003oi03oool0oooo02/0oooo00<0ooT00?oo
o`3oool0603oool00`000000oooo0?ooo`0G0?ooo`030?oi003oool0oooo02/0oooo00<00?oT0?oo
o`3oool0=`3oool00`3o0700oooo0?ooo`120?ooo`00AP3oool00`3o0700oooo0?ooo`0g0?ooo`03
003oi03oool0oooo02/0oooo00<0ooT00?ooo`3oool0603oool00`000000oooo0?ooo`0G0?ooo`03
0?oi003oool0oooo02/0oooo00<00?oT0?ooo`3oool0=`3oool00`3o0700oooo0?ooo`120?ooo`00
1P3ooom0000000030?l0L0000000000003L0000000<00?oT000000000000:`0000000`3on@000000
0000000b000000030?oi00000000000002/0000000<00?oT000000000000=`0000000`3o07000000
0000000o000000<0oooo00060?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3o
ool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01P3o
ool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00<0oooo00D0o`1`0?ooo`3oool0oooo
000000090?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool00P3oool01@00on@0oooo
0?ooo`3oool0000000T0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`03
0000003oool0oooo00H0oooo00@000000?ooo`3oool0ooT01P3oool00`000000oooo0?ooo`070?oo
o`030000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`070?oo
o`030000003oool0oooo00@0oooo00@0ooT00?ooo`3oool000002@3oool00`000000oooo0?ooo`06
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool01@000000oooo0?ooo`3o
ool00?oT00D0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`050000003o
ool0oooo0?ooo`3o07001@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`010?ooo`001P3oool00`000000oooo0?oo
o`0]0?ooo`030000003oool0oooo00d0oooo00<0o`1`0?ooo`3oool07P3oool00`000000oooo0?oo
o`0F0?ooo`03003oi03oool0oooo01D0oooo00<000000?ooo`3oool04`3oool00`3on@00oooo0?oo
o`0H0?ooo`030000003oool0oooo01H0oooo00<0ooT00?ooo`3oool0503oool00`000000oooo0?oo
o`0E0?ooo`03003oi03oool0oooo01H0oooo00<000000?ooo`3oool07P3oool00`3o0700oooo0?oo
o`0=0?ooo`030000003oool0oooo02h0oooo00<000000?ooo`3oool00@3oool004L0oooo00<0o`1`
0?ooo`3oool0=P3oool00`00on@0oooo0?ooo`0/0?ooo`030?oi003oool0oooo01L0oooo00<00000
0?ooo`3oool05P3oool00`3on@00oooo0?ooo`0/0?ooo`03003oi03oool0oooo03L0oooo00<0o`1`
0?ooo`3oool0@P3oool004L0oooo00<0o`1`0?ooo`3oool0=P3oool00`00on@0oooo0?ooo`0/0?oo
o`030?oi003oool0oooo01L0oooo00<000000?ooo`3oool05P3oool00`3on@00oooo0?ooo`0/0?oo
o`03003oi03oool0oooo03L0oooo00<0o`1`0?ooo`3oool0@P3oool004L0oooo00<0o`1`0?ooo`3o
ool0=P3oool00`00on@0oooo0?ooo`0/0?ooo`030?oi003oool0oooo01L0oooo00<000000?ooo`3o
ool05P3oool00`3on@00oooo0?ooo`0/0?ooo`03003oi03oool0oooo03L0oooo00<0o`1`0?ooo`3o
ool0@P3oool004L0oooo00<0o`1`0?ooo`3oool0=P3oool00`00on@0oooo0?ooo`0/0?ooo`030?oi
003oool0oooo01L0oooo00<000000?ooo`3oool05@3oool00`3on@00oooo0?ooo`0]0?ooo`03003o
i03oool0oooo03L0oooo00<0o`1`0?ooo`3oool0@P3oool004L0oooo00<0o`1`0?ooo`3oool0=P3o
ool00`00on@0oooo0?ooo`0/0?ooo`030?oi003oool0oooo01L0oooo00<000000?ooo`3oool05@3o
ool00`3on@00oooo0?ooo`0]0?ooo`03003oi03oool0oooo03L0oooo00<0o`1`0?ooo`3oool0@P3o
ool004L0oooo00<0o`1`0?ooo`3oool0=P3oool00`00on@0oooo0?ooo`0/0?ooo`030?oi003oool0
oooo01L0oooo00<000000?ooo`3oool05@3oool00`3on@00oooo0?ooo`0]0?ooo`03003oi03oool0
oooo03L0oooo00<0o`1`0?ooo`3oool0@P3oool004L0oooo00<0o`1`0?ooo`3oool0=P3oool00`00
on@0oooo0?ooo`0]0?ooo`030?oi003oool0oooo01H0oooo00<000000?ooo`3oool05@3oool00`3o
n@00oooo0?ooo`0]0?ooo`03003oi03oool0oooo03L0oooo00<0o`1`0?ooo`3oool0@P3oool004L0
oooo00<0o`1`0?ooo`3oool0=`3oool00`00on@0oooo0?ooo`0/0?ooo`030?oi003oool0oooo01H0
oooo0P00000E0?ooo`030?oi003oool0oooo02h0oooo00<00?oT0?ooo`3oool0=`3oool00`3o0700
oooo0?ooo`120?ooo`00A`3oool00`3o0700oooo0?ooo`0g0?ooo`03003oi03oool0oooo02d0oooo
00<0ooT00?ooo`3oool05@3oool00`000000oooo0?ooo`0D0?ooo`030?oi003oool0oooo02d0oooo
00<00?oT0?ooo`3oool0>03oool00`3o0700oooo0?ooo`120?ooo`00A`3oool00`3o0700oooo0?oo
o`0g0?ooo`03003oi03oool0oooo02d0oooo00<0ooT00?ooo`3oool05@3oool00`000000oooo0?oo
o`0C0?ooo`030?oi003oool0oooo02h0oooo00<00?oT0?ooo`3oool0=`3oool00`3o0700oooo0?oo
o`130?ooo`00A`3oool00`3o0700oooo0?ooo`0g0?ooo`03003oi03oool0oooo02h0oooo00<0ooT0
0?ooo`3oool0503oool00`000000oooo0?ooo`0C0?ooo`030?oi003oool0oooo02h0oooo00<00?oT
0?ooo`3oool0=`3oool00`3o0700oooo0?ooo`130?ooo`00A`3oool00`3o0700oooo0?ooo`0g0?oo
o`03003oi03oool0oooo02h0oooo00<0ooT00?ooo`3oool0503oool00`000000oooo0?ooo`0B0?oo
o`030?oi003oool0oooo02l0oooo00<00?oT0?ooo`3oool0=`3oool00`3o0700oooo0?ooo`130?oo
o`00B03oool00`3o0700oooo0?ooo`0f0?ooo`03003oi03oool0oooo02l0oooo00<0ooT00?ooo`3o
ool04`3oool00`000000oooo0?ooo`0B0?ooo`030?oi003oool0oooo02l0oooo00<00?oT0?ooo`3o
ool0=`3oool00`3o0700oooo0?ooo`130?ooo`00B03oool00`3o0700oooo0?ooo`0g0?ooo`03003o
i03oool0oooo02l0oooo00<0ooT00?ooo`3oool04P3oool00`000000oooo0?ooo`0A0?ooo`030?oi
003oool0oooo02l0oooo00<00?oT0?ooo`3oool0>03oool00`3o0700oooo0?ooo`130?ooo`00B03o
ool00`3o0700oooo0?ooo`0g0?ooo`03003oi03oool0oooo02l0oooo00<0ooT00?ooo`3oool04P3o
ool00`000000oooo0?ooo`0@0?ooo`030?oi003oool0oooo0300oooo00<00?oT0?ooo`3oool0>03o
ool00`3o0700oooo0?ooo`130?ooo`00B03oool00`3o0700oooo0?ooo`0g0?ooo`03003oi03oool0
oooo0300oooo00<0ooT00?ooo`3oool04@3oool00`000000oooo0?ooo`0?0?ooo`030?oi003oool0
oooo0340oooo00<00?oT0?ooo`3oool0>03oool00`3o0700oooo0?ooo`130?ooo`00B03oool00`3o
0700oooo0?ooo`0g0?ooo`03003oi03oool0oooo0340oooo00<0ooT00?ooo`3oool0403oool20000
0100oooo00<0ooT00?ooo`3oool0<@3oool00`00on@0oooo0?ooo`0g0?ooo`030?l0L03oool0oooo
04@0oooo00180?ooo`030?l0L03oool0oooo03P0oooo00<00?oT0?ooo`3oool0<@3oool20?oi0100
oooo00<000000?ooo`3oool03P3oool00`3on@00oooo0?ooo`0a0?ooo`03003oi03oool0oooo03P0
oooo00<0o`1`0?ooo`3oool0A03oool004P0oooo00<0o`1`0?ooo`3oool0>03oool00`00on@0oooo
0?ooo`0c0?ooo`030?oi003oool0oooo00d0oooo00<000000?ooo`3oool0303oool20?oi03@0oooo
00<00?oT0?ooo`3oool0>03oool00`3o0700oooo0?ooo`140?ooo`00B03oool00`3o0700oooo0?oo
o`0h0?ooo`03003oi03oool0oooo03@0oooo0P3on@0=0?ooo`030000003oool0oooo00X0oooo0P3o
n@0e0?ooo`03003oi03oool0oooo03T0oooo00<0o`1`0?ooo`3oool0A03oool004T0oooo00<0o`1`
0?ooo`3oool0=`3oool00`00on@0oooo0?ooo`0f0?ooo`80ooT02`3oool00`000000oooo0?ooo`09
0?ooo`030?oi003oool0oooo03D0oooo00<00?oT0?ooo`3oool0>@3oool00`3o0700oooo0?ooo`14
0?ooo`00B@3oool00`3o0700oooo0?ooo`0h0?ooo`03003oi03oool0oooo03L0oooo0P3on@090?oo
o`030000003oool0oooo00L0oooo0P3on@0h0?ooo`03003oi03oool0oooo03T0oooo00<0o`1`0?oo
o`3oool0A03oool004T0oooo00<0o`1`0?ooo`3oool0>03oool00`00on@0oooo0?ooo`0i0?ooo`<0
ooT01P3oool00`000000oooo0?ooo`040?ooo`<0ooT0>@3oool00`00on@0oooo0?ooo`0i0?ooo`03
0?l0L03oool0oooo04D0oooo00190?ooo`030?l0L03oool0oooo03P0oooo00<00?oT0?ooo`3oool0
?03oool=0?oi03`0oooo00<00?oT0?ooo`3oool0>@3oool00`3o0700oooo0?ooo`150?ooo`00B@3o
ool00`3o0700oooo0?ooo`0i0?ooo`03003oi03oool0oooo0440oooo00<000000?ooo`3oool0?`3o
ool00`00on@0oooo0?ooo`0j0?ooo`030?l0L03oool0oooo04D0oooo00190?ooo`030?l0L03oool0
oooo03T0oooo00<00?oT0?ooo`3oool0@@3oool00`000000oooo0?ooo`0o0?ooo`03003oi03oool0
oooo03X0oooo00<0o`1`0?ooo`3oool0A@3oool004X0oooo00<0o`1`0?ooo`3oool0>@3oool00`00
on@0oooo0?ooo`100?ooo`800000?`3oool00`00on@0oooo0?ooo`0j0?ooo`030?l0L03oool0oooo
04H0oooo001:0?ooo`030?l0L03oool0oooo03T0oooo00<00?oT0?ooo`3oool0@03oool00`000000
oooo0?ooo`0n0?ooo`03003oi03oool0oooo03X0oooo00<0o`1`0?ooo`3oool0AP3oool004X0oooo
00<0o`1`0?ooo`3oool0>P3oool00`00on@0oooo0?ooo`0o0?ooo`030000003oool0oooo03d0oooo
00<00?oT0?ooo`3oool0>`3oool00`3o0700oooo0?ooo`160?ooo`00BP3oool00`3o0700oooo0?oo
o`0j0?ooo`03003oi03oool0oooo03l0oooo00<000000?ooo`3oool0?@3oool00`00on@0oooo0?oo
o`0k0?ooo`030?l0L03oool0oooo04H0oooo001;0?ooo`030?l0L03oool0oooo03X0oooo00<00?oT
0?ooo`3oool0?P3oool00`000000oooo0?ooo`0l0?ooo`03003oi03oool0oooo03`0oooo00<0o`1`
0?ooo`3oool0@P3oool00`00>?l0oooo0?ooo`010?ooo`001P3oool00`00>?l0oooo0?ooo`120?oo
o`030?l0L03oool0oooo03X0oooo00<00?oT0?ooo`3oool0?P3oool00`000000oooo0?ooo`0l0?oo
o`03003oi03oool0oooo03/0oooo00<0o`1`0?ooo`3oool0@`3oool00`00>?l0oooo0?ooo`010?oo
o`001P3oool00`00>?l0oooo0?ooo`120?ooo`030?l0L03oool0oooo03/0oooo00<00?oT0?ooo`3o
ool0?@3oool00`000000oooo0?ooo`0k0?ooo`03003oi03oool0oooo03`0oooo00<0o`1`0?ooo`3o
ool0@`3oool00`00>?l0oooo0?ooo`010?ooo`001P3oool00`00>?l0oooo0?ooo`120?ooo`030?l0
L03oool0oooo03`0oooo00<00?oT0?ooo`3oool0?03oool00`000000oooo0?ooo`0k0?ooo`03003o
i03oool0oooo03`0oooo00<0o`1`0?ooo`3oool0@`3oool00`00>?l0oooo0?ooo`010?ooo`001P3o
ool00`00>?l0oooo0?ooo`130?ooo`030?l0L03oool0oooo03/0oooo00<00?oT0?ooo`3oool0?03o
ool00`000000oooo0?ooo`0j0?ooo`03003oi03oool0oooo03`0oooo00<0o`1`0?ooo`3oool0@`3o
ool00`00>?l0oooo0?ooo`020?ooo`001`3oool00`00>?l0oooo0?ooo`120?ooo`030?l0L03oool0
oooo03`0oooo00<00?oT0?ooo`3oool0>`3oool00`000000oooo0?ooo`0j0?ooo`03003oi03oool0
oooo03`0oooo00<0o`1`0?ooo`3oool0@`3oool00`00>?l0oooo0?ooo`020?ooo`001`3oool00`00
>?l0oooo0?ooo`120?ooo`030?l0L03oool0oooo03d0oooo00<00?oT0?ooo`3oool0>P3oool20000
03X0oooo00<00?oT0?ooo`3oool0?@3oool00`3o0700oooo0?ooo`130?ooo`03000ho`3oool0oooo
0080oooo00070?ooo`03000ho`3oool0oooo0480oooo00<0o`1`0?ooo`3oool0?@3oool00`00on@0
oooo0?ooo`0j0?ooo`030000003oool0oooo03P0oooo00<00?oT0?ooo`3oool0?@3oool00`3o0700
oooo0?ooo`140?ooo`03000ho`3oool0oooo0080oooo00070?ooo`03000ho`3oool0oooo04<0oooo
00<0o`1`0?ooo`3oool0?@3oool00`00on@0oooo0?ooo`0i0?ooo`030000003oool0oooo03P0oooo
00<00?oT0?ooo`3oool0?@3oool00`3o0700oooo0?ooo`140?ooo`03000ho`3oool0oooo0080oooo
00070?ooo`03000ho`3oool0oooo04<0oooo00<0o`1`0?ooo`3oool0?P3oool00`00on@0oooo0?oo
o`0h0?ooo`030000003oool0oooo03L0oooo00<00?oT0?ooo`3oool0?@3oool00`3o0700oooo0?oo
o`150?ooo`03000ho`3oool0oooo0080oooo00070?ooo`03000ho`3oool0oooo04<0oooo00<0o`1`
0?ooo`3oool0?P3oool00`00on@0oooo0?ooo`0h0?ooo`030000003oool0oooo03H0oooo00<00?oT
0?ooo`3oool0?P3oool00`3o0700oooo0?ooo`140?ooo`03000ho`3oool0oooo00<0oooo00070?oo
o`03000ho`3oool0oooo04@0oooo00<0o`1`0?ooo`3oool0?P3oool00`00on@0oooo0?ooo`0g0?oo
o`030000003oool0oooo03D0oooo00<00?oT0?ooo`3oool0?`3oool00`3o0700oooo0?ooo`140?oo
o`03000ho`3oool0oooo00<0oooo00080?ooo`03000ho`3oool0oooo04<0oooo00<0o`1`0?ooo`3o
ool0?`3oool00`00on@0oooo0?ooo`0f0?ooo`030000003oool0oooo03D0oooo00<00?oT0?ooo`3o
ool0?`3oool00`3o0700oooo0?ooo`140?ooo`03000ho`3oool0oooo00<0oooo00080?ooo`03000h
o`3oool0oooo04@0oooo00<0o`1`0?ooo`3oool0?`3oool00`00on@0oooo0?ooo`0e0?ooo`030000
003oool0oooo03@0oooo00<00?oT0?ooo`3oool0@03oool00`3o0700oooo0?ooo`140?ooo`03000h
o`3oool0oooo00<0oooo00080?ooo`03000ho`3oool0oooo04@0oooo00<0o`1`0?ooo`3oool0@03o
ool00`00on@0oooo0?ooo`0I0?ooo`800000103oool2000000<0oooo100000030?ooo`8000001`3o
ool00`000000oooo0?ooo`0c0?ooo`03003oi03oool0oooo08L0oooo00<003So0?ooo`3oool0103o
ool000P0oooo00<003So0?ooo`3oool0A@3oool00`3o0700oooo0?ooo`0o0?ooo`03003oi03oool0
oooo01P0oooo00@000000?ooo`3oool00000203oool00`000000oooo0?ooo`030?ooo`040000003o
ool0oooo000000H0oooo00<000000?ooo`3oool0<P3oool00`00on@0oooo0?ooo`280?ooo`03000h
o`3oool0oooo00@0oooo00080?ooo`03000ho`3oool0oooo04D0oooo00<0o`1`0?ooo`3oool0@03o
ool00`00on@0oooo0?ooo`0G0?ooo`040000003oool0oooo000000T0oooo00<000000?ooo`3oool0
1@3oool00`000000oooo0?ooo`040?ooo`<00000<@3oool00`00on@0oooo0?ooo`290?ooo`03000h
o`3oool0oooo00@0oooo00090?ooo`03000ho`3oool0oooo04@0oooo00<0o`1`0?ooo`3oool0@@3o
ool00`00on@0oooo0?ooo`0F0?ooo`040000003oool0oooo000000X0oooo00<000000?ooo`3oool0
0P3oool2000000L0oooo00<000000?ooo`3oool0<03oool00`00on@0oooo0?ooo`290?ooo`03000h
o`3oool0oooo00D0oooo00090?ooo`03000ho`3oool0oooo04D0oooo00<0o`1`0?ooo`3oool0@@3o
ool00`00on@0oooo0?ooo`0E0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool0
00000`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0300oooo00<00?oT0?ooo`3o
ool0R@3oool00`00>?l0oooo0?ooo`050?ooo`002@3oool00`00>?l0oooo0?ooo`150?ooo`030?l0
L03oool0oooo0480oooo00<00?oT0?ooo`3oool05@3oool2000000X0oooo0P0000040?ooo`<00000
1P3oool00`000000oooo0?ooo`0_0?ooo`03003oi03oool0oooo08X0oooo00<003So0?ooo`3oool0
1@3oool000X0oooo00<003So0?ooo`3oool0A@3oool00`3o0700oooo0?ooo`120?ooo`03003oi03o
ool0oooo02l0oooo00<000000?ooo`3oool0;P3oool00`00on@0oooo0?ooo`2:0?ooo`03000ho`3o
ool0oooo00H0oooo000:0?ooo`03000ho`3oool0oooo04D0oooo00<0o`1`0?ooo`3oool0@`3oool2
003oi2l0oooo00<000000?ooo`3oool0;@3oool00`00on@0oooo0?ooo`2;0?ooo`03000ho`3oool0
oooo00H0oooo000:0?ooo`03000ho`3oool0oooo04H0oooo00<0o`1`0?ooo`3oool0A03oool00`00
on@0oooo0?ooo`0/0?ooo`030000003oool0oooo02`0oooo00<00?oT0?ooo`3oool0S03oool00`00
>?l0oooo0?ooo`060?ooo`002`3oool00`00>?l0oooo0?ooo`150?ooo`030?l0L03oool0oooo04D0
oooo00<00?oT0?ooo`3oool0:`3oool00`000000oooo0?ooo`0Z0?ooo`800?oTS`3oool00`00>?l0
oooo0?ooo`060?ooo`002`3oool00`00>?l0oooo0?ooo`160?ooo`030?l0L03oool0oooo04D0oooo
0P00on@[0?ooo`030000003oool0oooo02T0oooo00<00?oT0?ooo`3oool0SP3oool00`00>?l0oooo
0?ooo`070?ooo`002`3oool00`00>?l0oooo0?ooo`160?ooo`030?l0L03oool0oooo04L0oooo00<0
0?oT0?ooo`3oool0:03oool2000002T0oooo00<00?oT0?ooo`3oool0S`3oool00`00>?l0oooo0?oo
o`070?ooo`00303oool00`00>?l0oooo0?ooo`160?ooo`030?l0L03oool0oooo04L0oooo00<00?oT
0?ooo`3oool09`3oool00`000000oooo0?ooo`0V0?ooo`800?oTTP3oool00`00>?l0oooo0?ooo`07
0?ooo`00303oool00`00>?l0oooo0?ooo`160?ooo`030?l0L03oool0oooo04P0oooo0P00on@W0?oo
o`030000003oool0oooo02D0oooo00<00?oT0?ooo`3oool0T@3oool00`00>?l0oooo0?ooo`080?oo
o`003@3oool00`00>?l0oooo0?ooo`160?ooo`030?l0L03oool0oooo04T0oooo00<00?oT0?ooo`3o
ool0903oool00`000000oooo0?ooo`0T0?ooo`03003oi03oool0oooo0980oooo00<003So0?ooo`3o
ool0203oool000d0oooo00<003So0?ooo`3oool0AP3oool00`3o0700oooo0?ooo`1:0?ooo`800?oT
903oool00`000000oooo0?ooo`0R0?ooo`800?oTU@3oool00`00>?l0oooo0?ooo`080?ooo`003@3o
ool00`00>?l0oooo0?ooo`170?ooo`030?l0L03oool0oooo04/0oooo00<00?oT0?ooo`3oool08@3o
ool00`000000oooo0?ooo`0P0?ooo`800?oTU`3oool00`00>?l0oooo0?ooo`080?ooo`003P3oool0
0`00>?l0oooo0?ooo`170?ooo`030?l0L03oool0oooo04/0oooo0P00on@Q0?ooo`030000003oool0
oooo01h0oooo0P00onBH0?ooo`03000ho`3oool0oooo00T0oooo000>0?ooo`03000ho`3oool0oooo
04L0oooo00<0o`1`0?ooo`3oool0C@3oool2003oi1l0oooo00<000000?ooo`3oool0703oool2003o
i9X0oooo00<003So0?ooo`3oool02@3oool000h0oooo00<003So0?ooo`3oool0B03oool00`3o0700
oooo0?ooo`1>0?ooo`800?oT7@3oool00`000000oooo0?ooo`0J0?ooo`800?oTW03oool00`00>?l0
oooo0?ooo`090?ooo`003`3oool00`00>?l0oooo0?ooo`170?ooo`030?l0L03oool0oooo0500oooo
0`00on@J0?ooo`030000003oool0oooo01P0oooo0P00onBM0?ooo`03000ho`3oool0oooo00X0oooo
000?0?ooo`03000ho`3oool0oooo04P0oooo00<0o`1`0?ooo`3oool0DP3oool2003oi1P0oooo0P00
000F0?ooo`<00?oTW`3oool00`00>?l0oooo0?ooo`0:0?ooo`003`3oool00`00>?l0oooo0?ooo`18
0?ooo`030?l0L03oool0oooo05@0oooo1000on@D0?ooo`030000003oool0oooo01<0oooo0P00onBQ
0?ooo`03000ho`3oool0oooo00/0oooo000@0?ooo`03000ho`3oool0oooo04P0oooo00<0o`1`0?oo
o`3oool0E`3oool6003oi0h0oooo00<000000?ooo`3oool03`3oool4003oi:<0oooo00<003So0?oo
o`3oool02`3oool00100oooo00<003So0?ooo`3oool0B@3oool00`3o0700oooo0?ooo`1L0?ooo`L0
0?oT1`3oool00`000000oooo0?ooo`090?ooo`H00?oTY`3oool00`00>?l0oooo0?ooo`0;0?ooo`00
403oool00`00>?l0oooo0?ooo`190?ooo`030?l0L03oool0oooo06<0oooo4`00onB/0?ooo`03000h
o`3oool0oooo00`0oooo000A0?ooo`03000ho`3oool0oooo04T0oooo00<0o`1`0?ooo`3oool0J@3o
ool00`000000oooo0?ooo`2e0?ooo`03000ho`3oool0oooo00`0oooo000A0?ooo`03000ho`3oool0
oooo04X0oooo00<0o`1`0?ooo`3oool0J03oool00`000000oooo0?ooo`2d0?ooo`03000ho`3oool0
oooo00d0oooo000B0?ooo`03000ho`3oool0oooo04T0oooo00<0o`1`0?ooo`3oool0J03oool00`00
0000oooo0?ooo`2d0?ooo`03000ho`3oool0oooo00d0oooo000B0?ooo`03000ho`3oool0oooo04X0
oooo00<0o`1`0?ooo`3oool0I`3oool00`000000oooo0?ooo`2c0?ooo`03000ho`3oool0oooo00h0
oooo000C0?ooo`03000ho`3oool0oooo04X0oooo00<0o`1`0?ooo`3oool0IP3oool00`000000oooo
0?ooo`2c0?ooo`03000ho`3oool0oooo00h0oooo000C0?ooo`03000ho`3oool0oooo04/0oooo00<0
o`1`0?ooo`3oool0I@3oool200000;@0oooo00<003So0?ooo`3oool03P3oool001<0oooo00<003So
0?ooo`3oool0B`3oool00`3o0700oooo0?ooo`1U0?ooo`030000003oool0oooo0;80oooo00<003So
0?ooo`3oool03`3oool001@0oooo00<003So0?ooo`3oool0B`3oool00`3o0700oooo0?ooo`1T0?oo
o`030000003oool0oooo0;80oooo00<003So0?ooo`3oool03`3oool001@0oooo00<003So0?ooo`3o
ool0C03oool00`3o0700oooo0?ooo`1S0?ooo`030000003oool0oooo0;40oooo00<003So0?ooo`3o
ool0403oool001D0oooo00<003So0?ooo`3oool0B`3oool00`3o0700oooo0?ooo`1S0?ooo`030000
003oool0oooo0;40oooo00<003So0?ooo`3oool0403oool001D0oooo00<003So0?ooo`3oool0C03o
ool00`3o0700oooo0?ooo`1R0?ooo`030000003oool0oooo0;40oooo00<003So0?ooo`3oool0403o
ool001H0oooo00<003So0?ooo`3oool0C03oool00`3o0700oooo0?ooo`1Q0?ooo`030000003oool0
oooo0;00oooo00<003So0?ooo`3oool04@3oool001H0oooo00<003So0?ooo`3oool0C@3oool00`3o
0700oooo0?ooo`1P0?ooo`030000003oool0oooo0;00oooo00<003So0?ooo`3oool04@3oool001L0
oooo00<003So0?ooo`3oool0C@3oool00`3o0700oooo0?ooo`1O0?ooo`030000003oool0oooo0:l0
oooo00<003So0?ooo`3oool04P3oool001L0oooo00<003So0?ooo`3oool0CP3oool00`3o0700oooo
0?ooo`1N0?ooo`030000003oool0oooo0:l0oooo00<003So0?ooo`3oool04P3oool001L0oooo00<0
03So0?ooo`3oool0C`3oool00`3o0700oooo0?ooo`1M0?ooo`800000FP3oool30?l0L580oooo00<0
03So0?ooo`3oool04`3oool001P0oooo00<003So0?ooo`3oool0CP3oool00`3o0700oooo0?ooo`1M
0?ooo`030000003oool0oooo05P0oooo1@3o071A0?ooo`03000ho`3oool0oooo01<0oooo000H0?oo
o`03000ho`3oool0oooo04l0oooo00<0o`1`0?ooo`3oool0G03oool00`000000oooo0?ooo`1G0?oo
o`L0o`1`C`3oool00`00>?l0oooo0?ooo`0D0?ooo`006@3oool00`00>?l0oooo0?ooo`1?0?ooo`03
0?l0L03oool0oooo05/0oooo00<000000?ooo`3oool0E`3oool70?l0L4l0oooo00<003So0?ooo`3o
ool0503oool001T0oooo00<003So0?ooo`3oool0D03oool00`3o0700oooo0?ooo`1J0?ooo`030000
003oool0oooo05L0oooo1`3o071>0?ooo`03000ho`3oool0oooo01D0oooo000J0?ooo`03000ho`3o
ool0oooo0500oooo00<0o`1`0?ooo`3oool0F@3oool00`000000oooo0?ooo`1F0?ooo`L0o`1`C`3o
ool00`00>?l0oooo0?ooo`0E0?ooo`006P3oool00`00>?l0oooo0?ooo`1A0?ooo`030?l0L03oool0
oooo05P0oooo00<000000?ooo`3oool0E03oool80?l0L4l0oooo00<003So0?ooo`3oool05P3oool0
01/0oooo00<003So0?ooo`3oool0D@3oool00`3o0700oooo0?ooo`120?ooo`800000103oool20000
00@0oooo0P0000070?ooo`030000003oool0oooo0580oooo1P3o071B0?ooo`03000ho`3oool0oooo
01L0oooo000K0?ooo`03000ho`3oool0oooo0580oooo00<0o`1`0?ooo`3oool0@03oool010000000
oooo0?ooo`0000080?ooo`040000003oool0oooo000000H0oooo00<000000?ooo`3oool0D03oool8
0?l0L580oooo00<003So0?ooo`3oool05`3oool001`0oooo00<003So0?ooo`3oool0DP3oool20?l0
L400oooo00@000000?ooo`3oool000002`3oool00`000000oooo0?ooo`040?ooo`<00000CP3oool9
0?l0L580oooo00<003So0?ooo`3oool0603oool001`0oooo00<003So0?ooo`3oool0E03oool00`3o
0700oooo0?ooo`0m0?ooo`040000003oool0oooo000000T0oooo0P0000070?ooo`030000003oool0
oooo04`0oooo2P3o071C0?ooo`03000ho`3oool0oooo01P0oooo000M0?ooo`03000ho`3oool0oooo
05@0oooo00<0o`1`0?ooo`3oool0?03oool010000000oooo0?ooo`0000090?ooo`030000003oool0
oooo00H0oooo00<000000?ooo`3oool0BP3oool<0?l0L580oooo00<003So0?ooo`3oool06@3oool0
01h0oooo00<003So0?ooo`3oool0E03oool20?l0L3d0oooo0P00000:0?ooo`<000001P3oool00`00
0000oooo0?ooo`180?ooo`d0o`1`D`3oool00`00>?l0oooo0?ooo`0I0?ooo`007P3oool00`00>?l0
oooo0?ooo`1F0?ooo`030?l0L03oool0oooo04l0oooo00<000000?ooo`3oool0C`3oool60?l0L580
oooo00<003So0?ooo`3oool06P3oool001l0oooo00<003So0?ooo`3oool0EP3oool00`3o0700oooo
0?ooo`1>0?ooo`030000003oool0oooo04d0oooo0P3o07000`3oool0o`1`0?l0L0020?l0L580oooo
00<003So0?ooo`3oool06`3oool001l0oooo00<003So0?ooo`3oool0E`3oool20?l0L4h0oooo00<0
00000?ooo`3oool0C03oool0103o0700oooo0?ooo`3oool30?l0L5<0oooo00<003So0?ooo`3oool0
6`3oool00200oooo00<003So0?ooo`3oool0F03oool00`3o0700oooo0?ooo`1;0?ooo`030000003o
ool0oooo04X0oooo0P3o07030?ooo`@0o`1`DP3oool00`00>?l0oooo0?ooo`0L0?ooo`00803oool0
0`00>?l0oooo0?ooo`1I0?ooo`030?l0L03oool0oooo04X0oooo00<000000?ooo`3oool0B@3oool0
0`3o0700oooo0?ooo`030?ooo`<0o`1`D`3oool00`00>?l0oooo0?ooo`0L0?ooo`008@3oool00`00
>?l0oooo0?ooo`1I0?ooo`80o`1`BP3oool00`000000oooo0?ooo`170?ooo`80o`1`1P3oool20?l0
L5<0oooo00<003So0?ooo`3oool07@3oool00280oooo00<003So0?ooo`3oool0FP3oool00`3o0700
oooo0?ooo`170?ooo`800000A`3oool00`3o0700oooo0?ooo`060?ooo`80o`1`D`3oool00`00>?l0
oooo0?ooo`0M0?ooo`008P3oool00`00>?l0oooo0?ooo`1K0?ooo`80o`1`A`3oool00`000000oooo
0?ooo`140?ooo`80o`1`2@3oool00`3o0700oooo0?ooo`1A0?ooo`03000ho`3oool0oooo01h0oooo
000S0?ooo`03000ho`3oool0oooo05`0oooo00<0o`1`0?ooo`3oool0A03oool00`000000oooo0?oo
o`130?ooo`030?l0L03oool0oooo05`0oooo00<003So0?ooo`3oool07`3oool002<0oooo00<003So
0?ooo`3oool0G@3oool00`3o0700oooo0?ooo`130?ooo`030000003oool0oooo0440oooo0P3o071N
0?ooo`03000ho`3oool0oooo0200oooo000T0?ooo`03000ho`3oool0oooo05d0oooo0P3o07130?oo
o`030000003oool0oooo03l0oooo0P3o071P0?ooo`03000ho`3oool0oooo0200oooo000U0?ooo`03
000ho`3oool0oooo05h0oooo00<0o`1`0?ooo`3oool0@03oool00`000000oooo0?ooo`0m0?ooo`80
o`1`H@3oool00`00>?l0oooo0?ooo`0Q0?ooo`009P3oool00`00>?l0oooo0?ooo`020?ooo`03000h
o`3oool0oooo05T0oooo0P3o07100?ooo`030000003oool0oooo03`0oooo00<0o`1`0?ooo`3oool0
H03oool00`00>?l0oooo0?ooo`0R0?ooo`009P3oool00`00>?l0oooo0?ooo`020?ooo`03000ho`3o
ool0oooo05/0oooo0P3o070n0?ooo`030000003oool0oooo03X0oooo0P3o071R0?ooo`03000ho`3o
ool0oooo02<0oooo000W0?ooo`04000ho`3oool0oooo0?ooo`8003SoGP3oool20?l0L3`0oooo00<0
00000?ooo`3oool0>03oool20?l0L6@0oooo00<003So0?ooo`3oool08`3oool002P0oooo00<003So
0?ooo`3oool00P00>?mP0?ooo`80o`1`>P3oool00`000000oooo0?ooo`0f0?ooo`80o`1`I@3oool0
0`00>?l0oooo0?ooo`0T0?ooo`00:@3oool00`00>?l0oooo000ho`02000hof40oooo0P3o070h0?oo
o`800000=@3oool20?l0L6H0oooo00<003So0?ooo`3oool09@3oool002X0oooo1000>?mS0?ooo`80
o`1`=P3oool00`000000oooo0?ooo`0b0?ooo`80o`1`I`3oool00`00>?l0oooo0?ooo`0V0?ooo`00
8`3oool4000ho`<0oooo1@00>?mT0?ooo`80o`1`=03oool00`000000oooo0?ooo`0`0?ooo`80o`1`
J@3oool00`00>?l0oooo0?ooo`0V0?ooo`00903oool;000hofH0oooo0P3o070b0?ooo`030000003o
ool0oooo02d0oooo0`3o071Z0?ooo`03000ho`3oool0oooo02L0oooo000U0?ooo`/003SoI`3oool3
0?l0L2l0oooo00<000000?ooo`3oool0:`3oool20?l0L6`0oooo00<003So0?ooo`3oool0:03oool0
02L0oooo2@00>?mZ0?ooo`<0o`1`;03oool00`000000oooo0?ooo`0Y0?ooo`80o`1`K@3oool00`00
>?l0oooo0?ooo`0Y0?ooo`00:03oool8000hofd0oooo0`3o070Y0?ooo`030000003oool0oooo02H0
oooo0`3o071_0?ooo`03000ho`3oool0oooo02T0oooo000Y0?ooo`P003SoK`3oool30?l0L2H0oooo
00<000000?ooo`3oool0903oool20?l0L740oooo00<003So0?ooo`3oool0:P3oool002/0oooo1P00
>?mb0?ooo`<0o`1`8`3oool00`000000oooo0?ooo`0P0?ooo`@0o`1`LP3oool00`00>?l0oooo0?oo
o`0[0?ooo`00;03oool6000hog@0oooo103o070O0?ooo`030000003oool0oooo01`0oooo103o071e
0?ooo`03000ho`3oool0oooo02`0oooo000]0?ooo`D003SoN03oool50?l0L1X0oooo0P00000H0?oo
o`D0o`1`N@3oool00`00>?l0oooo0?ooo`0/0?ooo`00;`3oool6000hogX0oooo1P3o070D0?ooo`03
0000003oool0oooo01<0oooo103o071m0?ooo`03000ho`3oool0oooo02d0oooo000`0?ooo`H003So
O`3oool;0?l0L0T0oooo00<000000?ooo`3oool01`3oool<0?l0L800oooo00<003So0?ooo`3oool0
;P3oool00300oooo1`00>?n90?oooa<0o`1`R`3oool00`00>?l0oooo0?ooo`0_0?ooo`00<03oool7
000hoi80oooo00<000000?ooo`3oool0T@3oool00`00>?l0oooo0?ooo`0`0?ooo`00<03oool7000h
oi80oooo00<000000?ooo`3oool0T03oool00`00>?l0oooo0?ooo`0a0?ooo`00<@3oool5000hoi<0
oooo00<000000?ooo`3oool0S`3oool00`00>?l0oooo0?ooo`0b0?ooo`00<P3oool3000hoi@0oooo
00<000000?ooo`3oool0SP3oool00`00>?l0oooo0?ooo`0c0?ooo`00b@3oool00`000000oooo0?oo
o`2=0?ooo`03000ho`3oool0oooo03@0oooo00390?ooo`800000S@3oool00`00>?l0oooo0?ooo`0e
0?ooo`00b@3oool00`000000oooo0?ooo`2;0?ooo`03000ho`3oool0oooo03H0oooo00390?ooo`03
0000003oool0oooo08X0oooo00<003So0?ooo`3oool0=`3oool00<T0oooo00<000000?ooo`3oool0
R@3oool00`00>?l0oooo0?ooo`0h0?ooo`00b@3oool00`000000oooo0?ooo`280?ooo`03000ho`3o
ool0oooo03T0oooo00390?ooo`030000003oool0oooo08L0oooo00<003So0?ooo`3oool0>P3oool0
0<T0oooo00<000000?ooo`3oool0QP3oool00`00>?l0oooo0?ooo`0k0?ooo`00b@3oool00`000000
oooo0?ooo`250?ooo`03000ho`3oool0oooo03`0oooo002^0?ooo`800000103oool2000000D0oooo
00<000000?ooo`3oool00P3oool2000000L0oooo00<000000?ooo`3oool0Q03oool00`00>?l0oooo
0?ooo`0m0?ooo`00[@3oool010000000oooo0?ooo`00000:0?ooo`050000003oool0oooo0?ooo`00
00000P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo08<0oooo00<003So0?ooo`3o
ool0?P3oool00:d0oooo00@000000?ooo`3oool000002P3oool00`000000oooo0?ooo`040?ooo`03
0000003oool0oooo00@0oooo0`0000220?ooo`03000ho`3oool0oooo03l0oooo002]0?ooo`040000
003oool0oooo000000/0oooo00@000000?ooo`3oool0oooo0P0000070?ooo`030000003oool0oooo
0840oooo00<003So0?ooo`3oool0@03oool00:d0oooo00@000000?ooo`3oool00000203oool01000
0000oooo0?ooo`0000030?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0O`3oool2
000hod<0oooo002^0?ooo`8000002@3oool4000000<0oooo0`0000060?ooo`030000003oool0oooo
07h0oooo00<003So0?ooo`3oool0@`3oool00<T0oooo00<000000?ooo`3oool0O@3oool00`00>?l0
oooo0?ooo`140?ooo`00b@3oool00`000000oooo0?ooo`1l0?ooo`03000ho`3oool0oooo04D0oooo
00390?ooo`030000003oool0oooo07/0oooo00<003So0?ooo`3oool0AP3oool00<T0oooo00<00000
0?ooo`3oool0N@3oool2000hodT0oooo00390?ooo`030000003oool0oooo07P0oooo00<003So0?oo
o`3oool0B@3oool00<T0oooo00<000000?ooo`3oool0M`3oool00`00>?l0oooo0?ooo`1:0?ooo`00
b@3oool2000007L0oooo00<003So0?ooo`3oool0B`3oool00<T0oooo00<000000?ooo`3oool0M@3o
ool00`00>?l0oooo0?ooo`1<0?ooo`00b@3oool00`000000oooo0?ooo`1c0?ooo`8003SoC`3oool0
0<T0oooo00<000000?ooo`3oool0LP3oool00`00>?l0oooo0?ooo`1?0?ooo`00b@3oool00`000000
oooo0?ooo`1a0?ooo`03000ho`3oool0oooo0500oooo00390?ooo`030000003oool0oooo0700oooo
00<003So0?ooo`3oool0D@3oool00<T0oooo00<000000?ooo`3oool0KP3oool2000hoe@0oooo0039
0?ooo`030000003oool0oooo06d0oooo00<003So0?ooo`3oool0E03oool00<T0oooo00<000000?oo
o`3oool0J`3oool2000hoeL0oooo00390?ooo`030000003oool0oooo06X0oooo00<003So0?ooo`3o
ool0E`3oool00<T0oooo0P00001Y0?ooo`8003SoFP3oool00<T0oooo00<000000?ooo`3oool0I`3o
ool00`00>?l0oooo0?ooo`1J0?ooo`00b@3oool00`000000oooo0?ooo`1U0?ooo`8003SoG@3oool0
0<T0oooo00<000000?ooo`3oool0H`3oool2000hoel0oooo00390?ooo`030000003oool0oooo0680
oooo00<003So0?ooo`3oool0G`3oool00<T0oooo00<000000?ooo`3oool0H03oool2000hof80oooo
00390?ooo`030000003oool0oooo05l0oooo00<003So0?ooo`3oool0HP3oool00<T0oooo00<00000
0?ooo`3oool0G@3oool2000hofD0oooo00390?ooo`030000003oool0oooo05/0oooo0P00>?mW0?oo
o`00b@3oool2000005X0oooo0P00>?mY0?ooo`00b@3oool00`000000oooo0?ooo`1G0?ooo`8003So
J`3oool00<T0oooo00<000000?ooo`3oool0E@3oool2000hofd0oooo00390?ooo`030000003oool0
oooo05<0oooo0P00>?m_0?ooo`00b@3oool00`000000oooo0?ooo`1@0?ooo`<003SoL@3oool007H0
oooo00<003So0?ooo`3oool0D03oool00`000000oooo0?ooo`1>0?ooo`8003SoM03oool007L0oooo
0P00>?m@0?ooo`030000003oool0oooo04`0oooo0P00>?mf0?ooo`00N@3oool3000hodd0oooo00<0
00000?ooo`3oool0BP3oool2000hogP0oooo001l0?ooo`8003SoB`3oool00`000000oooo0?ooo`18
0?ooo`8003SoNP3oool007h0oooo0`00>?m80?ooo`030000003oool0oooo04D0oooo0`00>?ml0?oo
o`00P@3oool2000hodH0oooo0P0000130?ooo`<003SoO`3oool008<0oooo0`00>?m30?ooo`030000
003oool0oooo0400oooo0P00>?n20?ooo`00QP3oool3000hod00oooo00<000000?ooo`3oool0?@3o
ool3000hoh@0oooo00290?ooo`<003So?@3oool00`000000oooo0?ooo`0j0?ooo`<003SoQ`3oool0
08`0oooo1000>?li0?ooo`030000003oool0oooo03P0oooo0P00>?n:0?ooo`00T03oool4000hocD0
oooo00<000000?ooo`3oool0=@3oool3000hoh`0oooo002D0?ooo`@003So<@3oool00`000000oooo
0?ooo`0a0?ooo`@003SoS`3oool009P0oooo1000>?l]0?ooo`030000003oool0oooo02`0oooo1@00
>?nC0?ooo`00W03oool4000hoal0oooo1@0000050?ooo`030000003oool0oooo02P0oooo1000>?nH
0?ooo`00X03oool4000hoad0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0S0?oo
o`D003SoW03oool00:@0oooo0`00>?lJ0?ooo`030000003oool0oooo00D0oooo0`00000P0?ooo`<0
03SoX@3oool00<40oooo00<000000?ooo`3oool0c03oool00<40oooo00<000000?ooo`3oool0c03o
ool00<00oooo0P00003>0?ooo`00o`3ooonA0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 399}, {399, 0}} -> {-1.03078, -1.02309, 0.00512826, \
0.00512826}},
  CellTags->"EquationTrekker"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        InterpretationBox[
          RowBox[{"EquationTrekkerState", "[", 
            
            RowBox[{"\<\"\\!\\({y[x] +  \\(\\*SuperscriptBox[\\(y\\),  \\(\
\[Prime]\[Prime]\\), MultilineFunction->None]\\)[x] \[Equal] 0, y, {x, \
\[Pi]\\/8, 2 \[Pi]}}\\)\"\>", ",", "\<\"\\!\\({}\\)\"\>", ",", 
              TagBox[
                TagBox[GridBox[{
                      {
                        InterpretationBox[
                          StyleBox[
                            RowBox[{"TrekData", "[", 
                              
                              RowBox[{"\<\"\\!\\({y[0.`] \[Equal] \
\\(-0.09499999999999997`\\),  \\(\\*SuperscriptBox[\\(y\\),  \\(\[Prime]\\), \
MultilineFunction->None]\\)[0.`] \[Equal] \
\\(-0.09499999999999997`\\)}\\)\"\>", ",", " ", "\<\"<>\"\>"}], "]"}],
                            FontColor->RGBColor[1, 0.976471, 0]],
                          TrekData[ {
                            Equal[ 
                              y[ 0.`], -0.09499999999999997`], 
                            Equal[ 
                              Derivative[ 1][ y][ 
                              0.`], -0.09499999999999997`]}, \
{-0.09499999999999997`, -0.09499999999999997`}, {0.`, {0.39269908169872414`, 
                            6.283185307179586`}}, {
                            RGBColor[ 1.`, 0.9764705896377563`, 0.`], 
                            "Line"}]]},
                      {
                        InterpretationBox[
                          StyleBox[
                            RowBox[{"TrekData", "[", 
                              
                              RowBox[{"\<\"\\!\\({y[0.`] \[Equal] \
\\(-0.765`\\),  \\(\\*SuperscriptBox[\\(y\\),  \\(\[Prime]\\), \
MultilineFunction->None]\\)[0.`] \[Equal] 0.6699999999999999`}\\)\"\>", ",", 
                                " ", "\<\"<>\"\>"}], "]"}],
                            FontColor->RGBColor[0, 0.219608, 1]],
                          TrekData[ {
                            Equal[ 
                              y[ 0.`], -0.765`], 
                            Equal[ 
                              Derivative[ 1][ y][ 0.`], 
                              0.6699999999999999`]}, {-0.765`, 
                            0.6699999999999999`}, {0.`, {0.39269908169872414`,
                             6.283185307179586`}}, {
                            RGBColor[ 0.`, 0.21960784494876862`, 1.`], 
                            "Line"}]]},
                      {
                        InterpretationBox[
                          StyleBox[
                            RowBox[{"TrekData", "[", 
                              
                              RowBox[{"\<\"\\!\\({y[0.`] \[Equal] 0.48`,  \\(\
\\*SuperscriptBox[\\(y\\),  \\(\[Prime]\\), MultilineFunction->None]\\)[0.`] \
\[Equal] 0.46499999999999997`}\\)\"\>", ",", " ", "\<\"<>\"\>"}], "]"}],
                            FontColor->RGBColor[1, 0, 0.439216]],
                          TrekData[ {
                            Equal[ 
                              y[ 0.`], 0.48`], 
                            Equal[ 
                              Derivative[ 1][ y][ 0.`], 
                              0.46499999999999997`]}, {0.48`, 
                            0.46499999999999997`}, {0.`, {
                            0.39269908169872414`, 6.283185307179586`}}, {
                            RGBColor[ 1.`, 0.`, 0.43921568989753723`], 
                            "Line"}]]},
                      {
                        InterpretationBox[
                          StyleBox[
                            RowBox[{"TrekData", "[", 
                              
                              RowBox[{"\<\"\\!\\({y[0.`] \[Equal] 0.25`,  \\(\
\\*SuperscriptBox[\\(y\\),  \\(\[Prime]\\), MultilineFunction->None]\\)[0.`] \
\[Equal] \\(-0.2749999999999999`\\)}\\)\"\>", ",", " ", "\<\"<>\"\>"}], "]"}],
                            
                            FontColor->RGBColor[0, 1, 0.894118]],
                          TrekData[ {
                            Equal[ 
                              y[ 0.`], 0.25`], 
                            Equal[ 
                              Derivative[ 1][ y][ 
                              0.`], -0.2749999999999999`]}, {
                            0.25`, -0.2749999999999999`}, {0.`, {
                            0.39269908169872414`, 6.283185307179586`}}, {
                            RGBColor[ 0.`, 1.`, 0.8941176533699036`], 
                            "Line"}]]}
                      },
                    RowSpacings->1,
                    ColumnAlignments->{Left}],
                  Column],
                Function[ BoxForm`e$, 
                  MatrixForm[ BoxForm`e$]]], ",", "\<\" <>\"\>"}], "]"}],
          EquationTrekkerState[ {
            Equal[ 
              Plus[ 
                y[ x], 
                Derivative[ 2][ y][ x]], 0], y, {x, 
            Times[ 
              Rational[ 1, 8], Pi], 
            Times[ 2, Pi]}}, {}, {
            TrekData[ {
              Equal[ 
                y[ 0.0], -.094999999999999973], 
              Equal[ 
                Derivative[ 1][ y][ 
                0.0], -.094999999999999973]}, {-.094999999999999973, \
-.094999999999999973}, {0.0, {.39269908169872414, 6.2831853071795862}}, {
              RGBColor[ 1.0, .97647058963775635, 0.0], "Line"}], 
            TrekData[ {
              Equal[ 
                y[ 0.0], -.76500000000000001], 
              Equal[ 
                Derivative[ 1][ y][ 
                0.0], .66999999999999993]}, {-.76500000000000001, \
.66999999999999993}, {0.0, {.39269908169872414, 6.2831853071795862}}, {
              RGBColor[ 0.0, .21960784494876862, 1.0], "Line"}], 
            TrekData[ {
              Equal[ 
                y[ 0.0], .47999999999999998], 
              Equal[ 
                Derivative[ 1][ y][ 
                0.0], .46499999999999997]}, {.47999999999999998, \
.46499999999999997}, {0.0, {.39269908169872414, 6.2831853071795862}}, {
              RGBColor[ 1.0, 0.0, .43921568989753723], "Line"}], 
            TrekData[ {
              Equal[ 
                y[ 0.0], .25], 
              Equal[ 
                Derivative[ 1][ y][ 
                0.0], -.27499999999999991]}, {.25, -.27499999999999991}, {
              0.0, {.39269908169872414, 6.2831853071795862}}, {
              RGBColor[ 0.0, 1.0, .89411765336990356], "Line"}]}, {
            TrekParameters -> {}, PlotRange -> {{-1.0, 1.0}, {-1.0, 1.0}}, 
            "CanvasSize" -> {400, 400}}]], ",", 
        TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
          False,
          Editable->False]}], "}"}]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"EquationTrekker"]
}, Open  ]],

Cell[TextData[{
  "The returned list has two elements, an ",
  StyleBox["EquationTrekkerState", "MR"],
  " object and a ",
  StyleBox["Graphics", "MR"],
  " object.  The ",
  StyleBox["Graphics", "MR"],
  " object is shown in the plot that displays the treks that were generated \
while the window was open.  The ",
  StyleBox["EquationTrekkerState", "MR"],
  "  object contains all of the information required to reopen the window \
with the same treks as it had when it was closed, allowing you to save \
interesting cases to be explored later. Its output forms are abbreviated, \
showing the equations, variables, and a list of the treks generated, each of \
which displays only its initial condition.  "
}], "Text",
  CellTags->"EquationTrekker"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["EquationTrekkerState",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["eqns",
                  "TI"], 
                StyleBox[",",
                  "TI"], 
                StyleBox[" ",
                  "TI"], 
                StyleBox["y",
                  "TI"], 
                StyleBox[",",
                  "TI"], 
                StyleBox[" ",
                  "TI"], 
                StyleBox[\({x, \ xmin, \ xmax}\),
                  "TI"], 
                StyleBox[",",
                  "TI"], 
                StyleBox[" ",
                  "TI"], 
                StyleBox["treks",
                  "TI"], 
                StyleBox[",",
                  "TI"], 
                StyleBox[" ",
                  "MR"], 
                RowBox[{
                  StyleBox["<",
                    "MR"], 
                  StyleBox["data",
                    "TI"], 
                  StyleBox[">",
                    "MR"]}]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
            "A", " ", "data", " ", "object", " ", "which", " ", "can", " ", 
              "be", " ", "reused", " ", "to", " ", "open", " ", "an", " ", 
              "EquationTrekker", " ", "window", " ", "with", " ", "a", " ", 
              "list", " ", 
              StyleBox["treks",
                "TI"], " ", "representing", " ", "treks", " ", "that", " ", 
              "were", " ", 
              RowBox[{"generated", ".", Cell[TextData[StyleBox["",
                  GridBoxOptions->{RowSpacings->1.5,
                  ColumnSpacings->1,
                  ColumnWidths->{0.4, 0.6},
                  ColumnAlignments->{Left}}]], "Text",
                  GridBoxOptions->{RowSpacings->1.5,
                  ColumnSpacings->1,
                  ColumnWidths->{0.4, 0.6},
                  ColumnAlignments->{Left}}]}], "  ", "The", " ", "data", " ",
               "is", " ", "not", " ", "shown", " ", "in", " ", "output", " ", 
              "forms", " ", "by", " ", \(\(default\)\(.\)\)}]},
          {
            RowBox[{
              StyleBox["Trek",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["condition",
                  "TI"], 
                StyleBox[",",
                  "MR"], 
                StyleBox[" ",
                  "MR"], 
                RowBox[{
                  StyleBox["<",
                    "MR"], 
                  StyleBox["data",
                    "TI"], 
                  StyleBox[">",
                    "MR"]}]}], 
              StyleBox["]",
                "MR"]}], Cell[TextData[{
              StyleBox[
              "A data object which represents a single trek.  In output \
forms, only the ",
                GridBoxOptions->{RowSpacings->1.5,
                ColumnSpacings->1,
                ColumnWidths->{0.4, 0.6},
                ColumnAlignments->{Left}}],
              StyleBox["condition", "TI",
                GridBoxOptions->{RowSpacings->1.5,
                ColumnSpacings->1,
                ColumnWidths->{0.4, 0.6},
                ColumnAlignments->{Left}}],
              StyleBox["s which were chosen to generate the trek are shown.",
                GridBoxOptions->{RowSpacings->1.5,
                ColumnSpacings->1,
                ColumnWidths->{0.4, 0.6},
                ColumnAlignments->{Left}}]
            }], "Text",
              GridBoxOptions->{RowSpacings->1.5,
              ColumnSpacings->1,
              ColumnWidths->{0.4, 0.6},
              ColumnAlignments->{Left}}]},
          {
            RowBox[{
              StyleBox["EquationTrekker",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["state",
                "TI"], 
              StyleBox["]",
                "MR"]}], Cell[TextData[{
              StyleBox[
              "Open up an equation trekker window with the treks saved in the \
",
                GridBoxOptions->{RowSpacings->1.5,
                ColumnSpacings->1,
                ColumnWidths->{0.4, 0.6},
                ColumnAlignments->{Left}}],
              StyleBox["EquationTrekkerState", "MR",
                GridBoxOptions->{RowSpacings->1.5,
                ColumnSpacings->1,
                ColumnWidths->{0.4, 0.6},
                ColumnAlignments->{Left}}],
              StyleBox[" object ",
                GridBoxOptions->{RowSpacings->1.5,
                ColumnSpacings->1,
                ColumnWidths->{0.4, 0.6},
                ColumnAlignments->{Left}}],
              StyleBox["state", "TI",
                GridBoxOptions->{RowSpacings->1.5,
                ColumnSpacings->1,
                ColumnWidths->{0.4, 0.6},
                ColumnAlignments->{Left}}],
              StyleBox[".",
                GridBoxOptions->{RowSpacings->1.5,
                ColumnSpacings->1,
                ColumnWidths->{0.4, 0.6},
                ColumnAlignments->{Left}}]
            }], "Text",
              GridBoxOptions->{RowSpacings->1.5,
              ColumnSpacings->1,
              ColumnWidths->{0.4, 0.6},
              ColumnAlignments->{Left}}]}
          }], TextForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.4, 0.6},
  ColumnAlignments->{Left}},
  CellTags->"EquationTrekker"],

Cell["EquationTrekker state objects.", "Caption",
  CellTags->"EquationTrekker"],

Cell["\<\
This reopens the EquationTrekker window in the state it had been in when the \
window was closed to generate the above results.\
\>", "MathCaption",
  CellTags->"EquationTrekker"],

Cell[CellGroupData[{

Cell[BoxData[
    \(EquationTrekker[First[%]]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"EquationTrekker"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
%%ImageSize: 400 400 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.5 0.5 0.5 [
[0 .4875 -6 -9 ]
[0 .4875 6 0 ]
[.125 .4875 -15 -9 ]
[.125 .4875 15 0 ]
[.25 .4875 -12 -9 ]
[.25 .4875 12 0 ]
[.375 .4875 -15 -9 ]
[.375 .4875 15 0 ]
[.625 .4875 -12 -9 ]
[.625 .4875 12 0 ]
[.75 .4875 -9 -9 ]
[.75 .4875 9 0 ]
[.875 .4875 -12 -9 ]
[.875 .4875 12 0 ]
[1 .4875 -3 -9 ]
[1 .4875 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .125 -30 -4.5 ]
[.4875 .125 0 4.5 ]
[.4875 .25 -24 -4.5 ]
[.4875 .25 0 4.5 ]
[.4875 .375 -30 -4.5 ]
[.4875 .375 0 4.5 ]
[.4875 .625 -24 -4.5 ]
[.4875 .625 0 4.5 ]
[.4875 .75 -18 -4.5 ]
[.4875 .75 0 4.5 ]
[.4875 .875 -24 -4.5 ]
[.4875 .875 0 4.5 ]
[.4875 1 -6 -4.5 ]
[.4875 1 0 4.5 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .5 m
0 .50625 L
s
[(-1)] 0 .4875 0 1 Mshowa
.125 .5 m
.125 .50625 L
s
[(-0.75)] .125 .4875 0 1 Mshowa
.25 .5 m
.25 .50625 L
s
[(-0.5)] .25 .4875 0 1 Mshowa
.375 .5 m
.375 .50625 L
s
[(-0.25)] .375 .4875 0 1 Mshowa
.625 .5 m
.625 .50625 L
s
[(0.25)] .625 .4875 0 1 Mshowa
.75 .5 m
.75 .50625 L
s
[(0.5)] .75 .4875 0 1 Mshowa
.875 .5 m
.875 .50625 L
s
[(0.75)] .875 .4875 0 1 Mshowa
1 .5 m
1 .50625 L
s
[(1)] 1 .4875 0 1 Mshowa
.125 Mabswid
.025 .5 m
.025 .50375 L
s
.05 .5 m
.05 .50375 L
s
.075 .5 m
.075 .50375 L
s
.1 .5 m
.1 .50375 L
s
.15 .5 m
.15 .50375 L
s
.175 .5 m
.175 .50375 L
s
.2 .5 m
.2 .50375 L
s
.225 .5 m
.225 .50375 L
s
.275 .5 m
.275 .50375 L
s
.3 .5 m
.3 .50375 L
s
.325 .5 m
.325 .50375 L
s
.35 .5 m
.35 .50375 L
s
.4 .5 m
.4 .50375 L
s
.425 .5 m
.425 .50375 L
s
.45 .5 m
.45 .50375 L
s
.475 .5 m
.475 .50375 L
s
.525 .5 m
.525 .50375 L
s
.55 .5 m
.55 .50375 L
s
.575 .5 m
.575 .50375 L
s
.6 .5 m
.6 .50375 L
s
.65 .5 m
.65 .50375 L
s
.675 .5 m
.675 .50375 L
s
.7 .5 m
.7 .50375 L
s
.725 .5 m
.725 .50375 L
s
.775 .5 m
.775 .50375 L
s
.8 .5 m
.8 .50375 L
s
.825 .5 m
.825 .50375 L
s
.85 .5 m
.85 .50375 L
s
.9 .5 m
.9 .50375 L
s
.925 .5 m
.925 .50375 L
s
.95 .5 m
.95 .50375 L
s
.975 .5 m
.975 .50375 L
s
.25 Mabswid
0 .5 m
1 .5 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .125 m
.50625 .125 L
s
[(-0.75)] .4875 .125 1 0 Mshowa
.5 .25 m
.50625 .25 L
s
[(-0.5)] .4875 .25 1 0 Mshowa
.5 .375 m
.50625 .375 L
s
[(-0.25)] .4875 .375 1 0 Mshowa
.5 .625 m
.50625 .625 L
s
[(0.25)] .4875 .625 1 0 Mshowa
.5 .75 m
.50625 .75 L
s
[(0.5)] .4875 .75 1 0 Mshowa
.5 .875 m
.50625 .875 L
s
[(0.75)] .4875 .875 1 0 Mshowa
.5 1 m
.50625 1 L
s
[(1)] .4875 1 1 0 Mshowa
.125 Mabswid
.5 .025 m
.50375 .025 L
s
.5 .05 m
.50375 .05 L
s
.5 .075 m
.50375 .075 L
s
.5 .1 m
.50375 .1 L
s
.5 .15 m
.50375 .15 L
s
.5 .175 m
.50375 .175 L
s
.5 .2 m
.50375 .2 L
s
.5 .225 m
.50375 .225 L
s
.5 .275 m
.50375 .275 L
s
.5 .3 m
.50375 .3 L
s
.5 .325 m
.50375 .325 L
s
.5 .35 m
.50375 .35 L
s
.5 .4 m
.50375 .4 L
s
.5 .425 m
.50375 .425 L
s
.5 .45 m
.50375 .45 L
s
.5 .475 m
.50375 .475 L
s
.5 .525 m
.50375 .525 L
s
.5 .55 m
.50375 .55 L
s
.5 .575 m
.50375 .575 L
s
.5 .6 m
.50375 .6 L
s
.5 .65 m
.50375 .65 L
s
.5 .675 m
.50375 .675 L
s
.5 .7 m
.50375 .7 L
s
.5 .725 m
.50375 .725 L
s
.5 .775 m
.50375 .775 L
s
.5 .8 m
.50375 .8 L
s
.5 .825 m
.50375 .825 L
s
.5 .85 m
.50375 .85 L
s
.5 .9 m
.50375 .9 L
s
.5 .925 m
.50375 .925 L
s
.5 .95 m
.50375 .95 L
s
.5 .975 m
.50375 .975 L
s
.25 Mabswid
.5 0 m
.5 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of user PostScript
/mathtops {
gsave
MBeginOrig
moveto
MEndOrig
currentpoint
grestore
} bind def
/MAtocoords {
mathtops 4 2 roll mathtops
4 copy pop pop
3 -1 roll sub
/arry exch def
exch sub
/arrx exch def
arrx dup mul
arry dup mul
add sqrt
/arrl exch def
translate
} bind def
/MAarrowhead1 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto
-0.035 0 lineto fill
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto
-0.035 0 lineto
-0.05 0.0125 lineto stroke
} ifelse
grestore
} def
% End of user PostScript
1 .976 0 r
.5 Mabswid
.43743 .47557 m
.43694 .47685 L
.43648 .47815 L
.43605 .47945 L
.43564 .48076 L
.43393 .48786 L
.433 .49511 L
.43287 .50241 L
.43353 .50969 L
.43497 .51685 L
.43718 .52381 L
.44014 .53049 L
.44578 .53966 L
.45282 .54782 L
.46107 .55474 L
.47032 .56026 L
.48033 .56423 L
.49085 .56655 L
.50161 .56716 L
.51232 .56604 L
.52375 .56284 L
.53444 .55768 L
.54405 .55072 L
.55228 .54218 L
.55889 .53232 L
.56366 .52145 L
.56644 .50991 L
.56715 .49807 L
.56572 .48608 L
.56216 .47453 L
.5566 .46381 L
.5492 .45426 L
.54022 .44619 L
.52993 .43986 L
.51868 .43547 L
.50682 .43317 L
.49495 .43302 L
.48323 .43495 L
.47204 .43892 L
.46172 .4448 L
.45694 .44844 L
.4525 .4525 L
s
.02 w
.4525 .4525 Mdot
.5 Mabswid
.45694 .44844 m
.4525 .4525 L
s
% Start of user PostScript
-0.086123861 -0.10311495 -0.095000022 -0.095000042 MAarrowhead1
% End of user PostScript
1 0 .439 r
.81308 .61677 m
.81534 .61054 L
.81747 .60427 L
.81947 .59795 L
.82135 .59159 L
.82926 .55698 L
.83344 .52172 L
.83387 .48621 L
.83052 .45086 L
.82344 .41607 L
.8127 .38222 L
.79844 .3497 L
.77562 .31109 L
.74784 .27587 L
.71559 .2447 L
.67945 .21813 L
.64009 .19663 L
.5982 .1806 L
.55454 .17033 L
.50989 .166 L
.46529 .16766 L
.4213 .17525 L
.37872 .18863 L
.33831 .20758 L
.30078 .23174 L
.2668 .26068 L
.23698 .2939 L
.21186 .33079 L
.19337 .3672 L
.17946 .40559 L
.17034 .44539 L
.16614 .48601 L
.16693 .52683 L
.17269 .56726 L
.18334 .60668 L
.19871 .6445 L
.21877 .68046 L
.24309 .71367 L
.27132 .74364 L
.30301 .76991 L
.3377 .79209 L
.37485 .80983 L
.4139 .82287 L
.45425 .831 L
.50171 .83415 L
.54913 .83052 L
.59556 .82019 L
.64005 .80338 L
.6817 .78043 L
.71221 .75812 L
Mistroke
.74 .7325 L
Mfstroke
.02 w
.74 .7325 Mdot
.5 Mabswid
.71221 .75812 m
.74 .7325 L
s
% Start of user PostScript
0.42441871 0.51623037 0.48000002 0.46500002 MAarrowhead1
% End of user PostScript
0 .22 1 r
.28727 .96182 m
.29987 .96742 L
.31263 .97268 L
.32552 .97759 L
.33854 .98214 L
.38759 .99588 L
s
.38759 .99588 m
.4112 1 L
s
.59186 1 m
.63963 .98891 L
.68785 .97249 L
.7444 .94587 L
.79725 .91252 L
.84561 .87294 L
.88875 .82772 L
.92602 .77756 L
.95685 .7232 L
.98078 .66547 L
.99745 .60524 L
s
.99745 .60524 m
1 .5854 L
s
1 .41598 m
.98931 .36177 L
.96077 .285 L
.92026 .2138 L
.86886 .15004 L
.80788 .09535 L
.73891 .05116 L
.66374 .01863 L
s
.66374 .01863 m
.58994 0 L
s
.41306 0 m
.35982 .01124 L
.29191 .03607 L
.22821 .07028 L
.17 .11317 L
.11847 .16389 L
.07465 .22141 L
.03944 .28456 L
.01354 .35207 L
s
.01354 .35207 m
0 .41147 L
s
0 .58669 m
.00637 .62191 L
.02567 .68314 L
.05253 .74145 L
.07893 .78501 L
.09744 .81061 L
.1175 .835 L
s
.02 w
.1175 .835 Mdot
.5 Mabswid
.09744 .81061 m
.1175 .835 L
s
% Start of user PostScript
-0.80512196 0.62121157 -0.76500009 0.67000004 MAarrowhead1
% End of user PostScript
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[3]:=",
  ImageSize->{400, 400},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006@0001T2000`400?l00000o`00003oo`3ooonA
0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00_`3oool500000<`0oooo00310?ooo`030000003o
ool0oooo0<`0oooo002U0?ooo`<003So6@3oool00`000000oooo0?ooo`050?ooo`<00000803oool2
000hoj80oooo002P0?ooo`D003So503oool4000000@0oooo00<000000?ooo`3oool01@3oool00`00
0000oooo0?ooo`0R0?ooo`@003SoWP3oool009X0oooo1P00>?lQ0?ooo`030000003oool0oooo00D0
oooo00<000000?ooo`3oool09P3oool4000hoiX0oooo002E0?ooo`D003So9P3oool2000000L0oooo
00<000000?ooo`3oool0:P3oool4000hoiH0oooo002A0?ooo`@003So=03oool00`000000oooo0?oo
o`0^0?ooo`@003SoTP3oool008h0oooo0`00>?lh0?ooo`030000003oool0oooo0380oooo1000>?n>
0?ooo`00S03oool2000hoc/0oooo00<000000?ooo`3oool0=P3oool4000hohX0oooo00290?ooo`<0
03So?@3oool00`000000oooo0?ooo`0j0?ooo`@003SoQP3oool008H0oooo0`00>?m00?ooo`030000
003oool0oooo03h0oooo0P00>?n40?ooo`00Q03oool2000hod<0oooo00<000000?ooo`3oool0@03o
ool2000hoh80oooo00210?ooo`<003SoA@3oool2000004<0oooo0`00>?mo0?ooo`00OP3oool3000h
odP0oooo00<000000?ooo`3oool0A@3oool2000hogd0oooo001l0?ooo`8003SoB`3oool00`000000
oooo0?ooo`170?ooo`8003SoN`3oool007T0oooo0`00>?m=0?ooo`030000003oool0oooo04T0oooo
0P00>?mi0?ooo`00M`3oool2000hoe00oooo00<000000?ooo`3oool0B`3oool3000hogH0oooo001e
0?ooo`8003SoDP3oool00`000000oooo0?ooo`1>0?ooo`8003SoM03oool007<0oooo0P00>?mD0?oo
o`030000003oool0oooo0500oooo0P00>?mb0?ooo`00L@3oool2000hoeH0oooo00<000000?ooo`3o
ool0DP3oool3000hofl0oooo001_0?ooo`8003SoF03oool00`000000oooo0?ooo`1E0?ooo`8003So
K@3oool006d0oooo0P00>?mJ0?ooo`800000F03oool2000hof/0oooo001/0?ooo`03000ho`3oool0
oooo05X0oooo00<000000?ooo`3oool0F@3oool2000hofT0oooo001Z0?ooo`8003SoG@3oool00`00
0000oooo0?ooo`1K0?ooo`8003SoI`3oool006P0oooo0P00>?mO0?ooo`030000003oool0oooo05d0
oooo00<003So0?ooo`3oool0I03oool006H0oooo0P00>?mQ0?ooo`030000003oool0oooo05h0oooo
0P00>?mT0?ooo`00I03oool2000hof<0oooo00<000000?ooo`3oool0H03oool2000hof80oooo001R
0?ooo`8003SoI@3oool00`000000oooo0?ooo`1R0?ooo`03000ho`3oool0oooo05l0oooo001P0?oo
o`8003SoI`3oool00`000000oooo0?ooo`1S0?ooo`8003SoG`3oool005l0oooo00<003So0?ooo`3o
ool0I`3oool00`000000oooo0?ooo`1U0?ooo`03000ho`3oool0oooo05`0oooo001M0?ooo`8003So
JP3oool00`000000oooo0?ooo`1V0?ooo`8003SoG03oool005`0oooo00<003So0?ooo`3oool0JP3o
ool2000006T0oooo0P00>?mJ0?ooo`00F`3oool00`00>?l0oooo0?ooo`1[0?ooo`030000003oool0
oooo06X0oooo00<003So0?ooo`3oool0E`3oool005T0oooo0P00>?m^0?ooo`030000003oool0oooo
06/0oooo0P00>?mG0?ooo`00F03oool00`00>?l0oooo0?ooo`1^0?ooo`030000003oool0oooo06d0
oooo00<003So0?ooo`3oool0E03oool005L0oooo00<003So0?ooo`3oool0K`3oool00`000000oooo
0?ooo`1^0?ooo`8003SoE03oool005D0oooo0P00>?mb0?ooo`030000003oool0oooo0700oooo0P00
>?mB0?ooo`00E03oool00`00>?l0oooo0?ooo`1b0?ooo`030000003oool0oooo0780oooo00<003So
0?ooo`3oool0C`3oool005<0oooo00<003So0?ooo`3oool0L`3oool00`000000oooo0?ooo`1c0?oo
o`8003SoC`3oool00540oooo0P00>?mf0?ooo`030000003oool0oooo07D0oooo00<003So0?ooo`3o
ool0C03oool00500oooo00<003So0?ooo`3oool0MP3oool00`000000oooo0?ooo`1f0?ooo`03000h
o`3oool0oooo04/0oooo001?0?ooo`03000ho`3oool0oooo07L0oooo0P00001h0?ooo`03000ho`3o
ool0oooo04X0oooo001=0?ooo`8003SoNP3oool00`000000oooo0?ooo`1h0?ooo`03000ho`3oool0
oooo04T0oooo001<0?ooo`03000ho`3oool0oooo07X0oooo00<000000?ooo`3oool0N@3oool00`00
>?l0oooo0?ooo`180?ooo`00B`3oool00`00>?l0oooo0?ooo`1k0?ooo`030000003oool0oooo07X0
oooo00<003So0?ooo`3oool0A`3oool004T0oooo0P00>?mn0?ooo`030000003oool0oooo07/0oooo
00<003So0?ooo`3oool0AP3oool004P0oooo00<003So0?ooo`3oool0OP3oool00`000000oooo0?oo
o`1l0?ooo`03000ho`3oool0oooo04D0oooo00170?ooo`03000ho`3oool0oooo07l0oooo00<00000
0?ooo`3oool0O@3oool00`00>?l0oooo0?ooo`140?ooo`00AP3oool00`00>?l0oooo0?ooo`200?oo
o`030000003oool0oooo07h0oooo00<003So0?ooo`3oool0@`3oool004D0oooo00<003So0?ooo`3o
ool0IP3oool2000000@0oooo0P0000050?ooo`030000003oool0oooo0080oooo0P0000070?ooo`03
0000003oool0oooo07l0oooo00<003So0?ooo`3oool0@P3oool004@0oooo00<003So0?ooo`3oool0
IP3oool010000000oooo0?ooo`00000:0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo0800oooo0P00>?m20?ooo`00@`3oool00`00>?l0
oooo0?ooo`1W0?ooo`040000003oool0oooo000000X0oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`040?ooo`<00000PP3oool00`00>?l0oooo0?ooo`0o0?ooo`00@P3oool00`00>?l0
oooo0?ooo`1R0?ooo`@000000P3oool010000000oooo0?ooo`00000;0?ooo`040000003oool0oooo
0?ooo`8000001`3oool00`000000oooo0?ooo`230?ooo`03000ho`3oool0oooo03h0oooo00110?oo
o`03000ho`3oool0oooo06T0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`00
00030?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0Q03oool00`00>?l0oooo0?oo
o`0m0?ooo`00@03oool00`00>?l0oooo0?ooo`1[0?ooo`8000002@3oool4000000<0oooo0`000006
0?ooo`030000003oool0oooo08D0oooo00<003So0?ooo`3oool0?03oool003l0oooo00<003So0?oo
o`3oool0Q`3oool00`000000oooo0?ooo`260?ooo`03000ho`3oool0oooo03/0oooo000n0?ooo`03
000ho`3oool0oooo08P0oooo00<000000?ooo`3oool0Q`3oool00`00>?l0oooo0?ooo`0j0?ooo`00
?@3oool00`00>?l0oooo0?ooo`290?ooo`030000003oool0oooo08P0oooo00<003So0?ooo`3oool0
>@3oool003`0oooo00<003So0?ooo`3oool0RP3oool00`000000oooo0?ooo`290?ooo`03000ho`3o
ool0oooo03P0oooo000k0?ooo`03000ho`3oool0oooo08/0oooo00<000000?ooo`3oool0RP3oool0
0`00>?l0oooo0?ooo`0g0?ooo`00>P3oool00`00>?l0oooo0?ooo`2<0?ooo`800000S03oool00`00
>?l0oooo0?ooo`0f0?ooo`00>@3oool00`00>?l0oooo0?ooo`2=0?ooo`030000003oool0oooo08`0
oooo00<003So0?ooo`3oool0=@3oool003P0oooo00<003So0?ooo`3oool0SP3oool00`000000oooo
0?ooo`2=0?ooo`03000ho`3oool0oooo03@0oooo000g0?ooo`03000ho`3oool0oooo08l0oooo00<0
00000?ooo`3oool0SP3oool00`00>?l0oooo0?ooo`0c0?ooo`00=P3oool00`00>?l0oooo0?ooo`2@
0?ooo`030000003oool0oooo08h0oooo00<003So0?ooo`3oool0<`3oool003D0oooo00<003So0?oo
o`3oool0T@3oool00`000000oooo0?ooo`2?0?ooo`03000ho`3oool0oooo0380oooo000d0?ooo`03
000ho`3oool0oooo0980oooo00<000000?ooo`3oool0T03oool00`00>?l0oooo0?ooo`0a0?ooo`00
<`3oool00`00>?l0oooo0?ooo`230?oooa`0o`1`R03oool00`00>?l0oooo0?ooo`0`0?ooo`00<P3o
ool00`00>?l0oooo0?ooo`1n0?ooo`H0o`1`403oool00`000000oooo0?ooo`090?ooo``0o`1`O@3o
ool00`00>?l0oooo0?ooo`0_0?ooo`00<P3oool00`00>?l0oooo0?ooo`1h0?ooo`H0o`1`5P3oool0
0`000000oooo0?ooo`0E0?ooo`@0o`1`NP3oool00`00>?l0oooo0?ooo`0^0?ooo`00<@3oool00`00
>?l0oooo0?ooo`1e0?ooo`@0o`1`703oool2000001X0oooo103o071f0?ooo`03000ho`3oool0oooo
02h0oooo000`0?ooo`03000ho`3oool0oooo07<0oooo0`3o070P0?ooo`030000003oool0oooo01d0
oooo103o071c0?ooo`03000ho`3oool0oooo02d0oooo000_0?ooo`03000ho`3oool0oooo0740oooo
0`3o070S0?ooo`030000003oool0oooo0240oooo103o071`0?ooo`03000ho`3oool0oooo02`0oooo
000_0?ooo`03000ho`3oool0oooo06l0oooo0P3o070V0?ooo`030000003oool0oooo02D0oooo0P3o
071_0?ooo`03000ho`3oool0oooo02/0oooo000^0?ooo`03000ho`3oool0oooo06d0oooo0`3o070X
0?ooo`030000003oool0oooo02L0oooo0P3o071^0?ooo`03000ho`3oool0oooo02X0oooo000]0?oo
o`03000ho`3oool0oooo06/0oooo0`3o070[0?ooo`030000003oool0oooo02T0oooo0P3o071]0?oo
o`03000ho`3oool0oooo02T0oooo000/0?ooo`03000ho`3oool0oooo06T0oooo0`3o070^0?ooo`03
0000003oool0oooo02/0oooo0`3o071Z0?ooo`03000ho`3oool0oooo02T0oooo000[0?ooo`03000h
o`3oool0oooo06P0oooo0P3o070a0?ooo`030000003oool0oooo02h0oooo0P3o071Y0?ooo`03000h
o`3oool0oooo02P0oooo000[0?ooo`03000ho`3oool0oooo06H0oooo0P3o070c0?ooo`030000003o
ool0oooo0300oooo0P3o071X0?ooo`03000ho`3oool0oooo02L0oooo000Z0?ooo`03000ho`3oool0
oooo06D0oooo0P3o070e0?ooo`030000003oool0oooo0380oooo0P3o071W0?ooo`03000ho`3oool0
oooo02H0oooo000Y0?ooo`03000ho`3oool0oooo06<0oooo0`3o070g0?ooo`800000=@3oool20?l0
L6H0oooo00<003So0?ooo`3oool09@3oool002P0oooo00<003So0?ooo`3oool0HP3oool20?l0L3X0
oooo00<000000?ooo`3oool0=P3oool20?l0L6D0oooo00<003So0?ooo`3oool0903oool002P0oooo
00<003So0?ooo`3oool0H03oool20?l0L3`0oooo00<000000?ooo`3oool0>03oool20?l0L6<0oooo
00<003So0?ooo`3oool0903oool002L0oooo00<003So0?ooo`3oool0G`3oool20?l0L3h0oooo00<0
00000?ooo`3oool0>P3oool20?l0L680oooo00<003So0?ooo`3oool08`3oool002H0oooo00<003So
0?ooo`3oool0GP3oool20?l0L400oooo00<000000?ooo`3oool0?03oool20?l0L640oooo00<003So
0?ooo`3oool08P3oool002D0oooo00<003So0?ooo`3oool0GP3oool00`3o0700oooo0?ooo`100?oo
o`030000003oool0oooo03h0oooo0P3o071P0?ooo`03000ho`3oool0oooo0240oooo000U0?ooo`03
000ho`3oool0oooo05`0oooo0P3o07130?ooo`030000003oool0oooo0400oooo0P3o071O0?ooo`03
000ho`3oool0oooo0200oooo000T0?ooo`03000ho`3oool0oooo05`0oooo00<0o`1`0?ooo`3oool0
@`3oool00`000000oooo0?ooo`120?ooo`030?l0L03oool0oooo05`0oooo00<003So0?ooo`3oool0
803oool002<0oooo00<003So0?ooo`3oool0F`3oool20?l0L4H0oooo00<000000?ooo`3oool0@`3o
ool20?l0L5d0oooo00<003So0?ooo`3oool07`3oool00280oooo00<003So0?ooo`3oool0FP3oool2
0?l0L4P0oooo00<000000?ooo`3oool0A@3oool00`3o0700oooo0?ooo`1J0?ooo`03000ho`3oool0
oooo01l0oooo000R0?ooo`03000ho`3oool0oooo05T0oooo00<0o`1`0?ooo`3oool0B03oool20000
04L0oooo0P3o071K0?ooo`03000ho`3oool0oooo01h0oooo000Q0?ooo`03000ho`3oool0oooo05P0
oooo0P3o071;0?ooo`030000003oool0oooo04P0oooo00<0o`1`0?ooo`3oool0F03oool00`00>?l0
oooo0?ooo`0N0?ooo`008@3oool00`00>?l0oooo0?ooo`1G0?ooo`030?l0L03oool0oooo04/0oooo
00<000000?ooo`3oool0B@3oool20?l0L5T0oooo00<003So0?ooo`3oool07@3oool00200oooo00<0
03So0?ooo`3oool0E`3oool00`3o0700oooo0?ooo`1<0?ooo`030000003oool0oooo04/0oooo00<0
o`1`0?ooo`3oool0E`3oool00`00>?l0oooo0?ooo`0L0?ooo`00803oool00`00>?l0oooo0?ooo`1F
0?ooo`030?l0L03oool0oooo04d0oooo00<000000?ooo`3oool0C03oool20?l0L5L0oooo00<003So
0?ooo`3oool0703oool001l0oooo00<003So0?ooo`3oool0EP3oool00`3o0700oooo0?ooo`1>0?oo
o`030000003oool0oooo04h0oooo00<0o`1`0?ooo`3oool0E@3oool00`00>?l0oooo0?ooo`0K0?oo
o`007`3oool00`00>?l0oooo0?ooo`1E0?ooo`030?l0L03oool0oooo04l0oooo00<000000?ooo`3o
ool0C`3oool20?l0L5D0oooo00<003So0?ooo`3oool06`3oool001h0oooo00<003So0?ooo`3oool0
E@3oool00`3o0700oooo0?ooo`0k0?ooo`800000103oool2000000@0oooo0P0000070?ooo`030000
003oool0oooo0540oooo00<0o`1`0?ooo`3oool0D`3oool00`00>?l0oooo0?ooo`0J0?ooo`007@3o
ool00`00>?l0oooo0?ooo`1D0?ooo`80o`1`?@3oool010000000oooo0?ooo`0000080?ooo`040000
003oool0oooo000000H0oooo00<000000?ooo`3oool0DP3oool00`3o0700oooo0?ooo`1B0?ooo`03
000ho`3oool0oooo01X0oooo000M0?ooo`03000ho`3oool0oooo05<0oooo00<0o`1`0?ooo`3oool0
?@3oool010000000oooo0?ooo`00000;0?ooo`030000003oool0oooo00@0oooo0`00001C0?ooo`03
0?l0L03oool0oooo0580oooo00<003So0?ooo`3oool06@3oool001`0oooo00<003So0?ooo`3oool0
D`3oool00`3o0700oooo0?ooo`0h0?ooo`@000000P3oool010000000oooo0?ooo`0000090?ooo`80
00001`3oool00`000000oooo0?ooo`1D0?ooo`030?l0L03oool0oooo0580oooo00<003So0?ooo`3o
ool0603oool001`0oooo00<003So0?ooo`3oool0DP3oool00`3o0700oooo0?ooo`0o0?ooo`040000
003oool0oooo000000T0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`1E0?ooo`03
0?l0L03oool0oooo0540oooo00<003So0?ooo`3oool0603oool001/0oooo00<003So0?ooo`3oool0
DP3oool00`3o0700oooo0?ooo`110?ooo`8000002P3oool3000000H0oooo00<000000?ooo`3oool0
EP3oool00`3o0700oooo0?ooo`1A0?ooo`03000ho`3oool0oooo01L0oooo000K0?ooo`03000ho`3o
ool0oooo0540oooo00<0o`1`0?ooo`3oool0E`3oool00`000000oooo0?ooo`1G0?ooo`030?l0L03o
ool0oooo0500oooo00<003So0?ooo`3oool05`3oool001X0oooo00<003So0?ooo`3oool0D@3oool0
0`3o0700oooo0?ooo`1H0?ooo`030000003oool0oooo05L0oooo00<0o`1`0?ooo`3oool0D@3oool0
0`00>?l0oooo0?ooo`0F0?ooo`006@3oool00`00>?l0oooo0?ooo`1A0?ooo`030?l0L03oool0oooo
05T0oooo00<000000?ooo`3oool0F03oool00`3o0700oooo0?ooo`1@0?ooo`03000ho`3oool0oooo
01H0oooo000I0?ooo`03000ho`3oool0oooo0500oooo00<0o`1`0?ooo`3oool0FP3oool00`000000
oooo0?ooo`1I0?ooo`030?l0L03oool0oooo0500oooo00<003So0?ooo`3oool05@3oool001P0oooo
00<003So0?ooo`3oool0D03oool00`3o0700oooo0?ooo`1K0?ooo`030000003oool0oooo05X0oooo
00<0o`1`0?ooo`3oool0D03oool00`00>?l0oooo0?ooo`0D0?ooo`00603oool00`00>?l0oooo0?oo
o`1?0?ooo`030?l0L03oool0oooo05`0oooo00<000000?ooo`3oool0F`3oool00`3o0700oooo0?oo
o`1?0?ooo`03000ho`3oool0oooo01@0oooo000G0?ooo`03000ho`3oool0oooo04l0oooo00<0o`1`
0?ooo`3oool0G@3oool2000005d0oooo00<0o`1`0?ooo`3oool0C`3oool00`00>?l0oooo0?ooo`0C
0?ooo`005`3oool00`00>?l0oooo0?ooo`1>0?ooo`030?l0L03oool0oooo05h0oooo00<000000?oo
o`3oool0G@3oool00`3o0700oooo0?ooo`1>0?ooo`03000ho`3oool0oooo01<0oooo000F0?ooo`03
000ho`3oool0oooo04l0oooo00<0o`1`0?ooo`3oool0GP3oool00`000000oooo0?ooo`1N0?ooo`03
0?l0L03oool0oooo04h0oooo00<003So0?ooo`3oool04P3oool001H0oooo00<003So0?ooo`3oool0
CP3oool00`3o0700oooo0?ooo`1O0?ooo`030000003oool0oooo05l0oooo00<0o`1`0?ooo`3oool0
C@3oool00`00>?l0oooo0?ooo`0B0?ooo`005@3oool00`00>?l0oooo0?ooo`1>0?ooo`030?l0L03o
ool0oooo0600oooo00<000000?ooo`3oool0H03oool00`3o0700oooo0?ooo`1=0?ooo`03000ho`3o
ool0oooo0140oooo000E0?ooo`03000ho`3oool0oooo04d0oooo00<0o`1`0?ooo`3oool0H@3oool0
0`000000oooo0?ooo`1P0?ooo`030?l0L03oool0oooo04d0oooo00<003So0?ooo`3oool04@3oool0
01@0oooo00<003So0?ooo`3oool0C@3oool00`3o0700oooo0?ooo`1R0?ooo`030000003oool0oooo
0640oooo00<0o`1`0?ooo`3oool0C@3oool00`00>?l0oooo0?ooo`0@0?ooo`00503oool00`00>?l0
oooo0?ooo`1<0?ooo`030?l0L03oool0oooo06<0oooo00<000000?ooo`3oool0HP3oool00`3o0700
oooo0?ooo`1<0?ooo`03000ho`3oool0oooo0100oooo000C0?ooo`03000ho`3oool0oooo04`0oooo
00<0o`1`0?ooo`3oool0I03oool00`000000oooo0?ooo`1S0?ooo`030?l0L03oool0oooo04/0oooo
00<003So0?ooo`3oool0403oool001<0oooo00<003So0?ooo`3oool0B`3oool00`3o0700oooo0?oo
o`1U0?ooo`030000003oool0oooo06@0oooo00<0o`1`0?ooo`3oool0B`3oool00`00>?l0oooo0?oo
o`0?0?ooo`004`3oool00`00>?l0oooo0?ooo`1;0?ooo`030?l0L03oool0oooo06D0oooo0P00001V
0?ooo`030?l0L03oool0oooo04X0oooo00<003So0?ooo`3oool03`3oool00180oooo00<003So0?oo
o`3oool0B`3oool00`3o0700oooo0?ooo`1V0?ooo`030000003oool0oooo06D0oooo00<0o`1`0?oo
o`3oool0B`3oool00`00>?l0oooo0?ooo`0>0?ooo`004P3oool00`00>?l0oooo0?ooo`1:0?ooo`03
0?l0L03oool0oooo06L0oooo00<000000?ooo`3oool0IP3oool00`3o0700oooo0?ooo`1:0?ooo`03
000ho`3oool0oooo00h0oooo000B0?ooo`03000ho`3oool0oooo04T0oooo00<0o`1`0?ooo`3oool0
J03oool00`000000oooo0?ooo`1W0?ooo`030?l0L03oool0oooo04T0oooo00<003So0?ooo`3oool0
3P3oool00140oooo00<003So0?ooo`3oool0BP3oool00`3o0700oooo0?ooo`1X0?ooo`030000003o
ool0oooo06P0oooo00<0o`1`0?ooo`3oool0B@3oool00`00>?l0oooo0?ooo`0=0?ooo`004@3oool0
0`00>?l0oooo0?ooo`190?ooo`030?l0L03oool0oooo06T0oooo00<000000?ooo`3oool0J@3oool0
0`3o0700oooo0?ooo`180?ooo`03000ho`3oool0oooo00d0oooo000@0?ooo`03000ho`3oool0oooo
04T0oooo00<0o`1`0?ooo`3oool0JP3oool00`000000oooo0?ooo`1Y0?ooo`030?l0L03oool0oooo
04P0oooo00<003So0?ooo`3oool03@3oool00100oooo00<003So0?ooo`3oool0B@3oool00`3o0700
oooo0?ooo`1Z0?ooo`030000003oool0oooo06X0oooo00<0o`1`0?ooo`3oool0B03oool00`00>?l0
oooo0?ooo`0<0?ooo`00403oool00`00>?l0oooo0?ooo`180?ooo`030?l0L03oool0oooo06/0oooo
00<000000?ooo`3oool0JP3oool00`3o0700oooo0?ooo`180?ooo`03000ho`3oool0oooo00`0oooo
000?0?ooo`03000ho`3oool0oooo04P0oooo00<0o`1`0?ooo`3oool0K03oool00`000000oooo0?oo
o`1[0?ooo`030?l0L03oool0oooo04L0oooo00<003So0?ooo`3oool0303oool000l0oooo00<003So
0?ooo`3oool0A`3oool00`3o0700oooo0?ooo`1]0?ooo`800000K@3oool00`3o0700oooo0?ooo`17
0?ooo`03000ho`3oool0oooo00/0oooo000>0?ooo`03000ho`3oool0oooo04P0oooo00<0o`1`0?oo
o`3oool0K@3oool00`000000oooo0?ooo`1/0?ooo`030?l0L03oool0oooo04L0oooo00<003So0?oo
o`3oool02`3oool000h0oooo00<003So0?ooo`3oool0A`3oool00`3o0700oooo0?ooo`1^0?ooo`03
0000003oool0oooo06d0oooo00<0o`1`0?ooo`3oool0A`3oool00`00>?l0oooo0?ooo`0:0?ooo`00
3P3oool00`00>?l0oooo0?ooo`160?ooo`030?l0L03oool0oooo06l0oooo00<000000?ooo`3oool0
K@3oool00`3o0700oooo0?ooo`170?ooo`03000ho`3oool0oooo00X0oooo000=0?ooo`03000ho`3o
ool0oooo04L0oooo00<0o`1`0?ooo`3oool0K`3oool00`000000oooo0?ooo`1^0?ooo`030?l0L03o
ool0oooo04H0oooo00<003So0?ooo`3oool02P3oool000d0oooo00<003So0?ooo`3oool0AP3oool0
0`3o0700oooo0?ooo`1`0?ooo`030000003oool0oooo06l0oooo00<0o`1`0?ooo`3oool0AP3oool0
0`00>?l0oooo0?ooo`090?ooo`003@3oool00`00>?l0oooo0?ooo`160?ooo`030?l0L03oool0oooo
0700oooo00<000000?ooo`3oool0K`3oool00`3o0700oooo0?ooo`160?ooo`03000ho`3oool0oooo
00T0oooo000<0?ooo`03000ho`3oool0oooo04H0oooo00<0o`1`0?ooo`3oool0L@3oool00`000000
oooo0?ooo`1`0?ooo`030?l0L03oool0oooo04D0oooo00<003So0?ooo`3oool02@3oool000`0oooo
00<003So0?ooo`3oool0AP3oool00`3o0700oooo0?ooo`1a0?ooo`030000003oool0oooo0700oooo
00<0o`1`0?ooo`3oool0AP3oool00`00>?l0oooo0?ooo`080?ooo`002`3oool00`00>?l0oooo0?oo
o`160?ooo`030?l0L03oool0oooo0780oooo0P00001b0?ooo`030?l0L03oool0oooo04D0oooo00<0
03So0?ooo`3oool0203oool000/0oooo00<003So0?ooo`3oool0AP3oool00`3o0700oooo0?ooo`1b
0?ooo`030000003oool0oooo0740oooo00<0o`1`0?ooo`3oool0AP3oool00`00>?l0oooo0?ooo`07
0?ooo`002`3oool00`00>?l0oooo0?ooo`150?ooo`030?l0L03oool0oooo07<0oooo00<000000?oo
o`3oool0LP3oool00`3o0700oooo0?ooo`150?ooo`03000ho`3oool0oooo00L0oooo000;0?ooo`03
000ho`3oool0oooo04D0oooo00<0o`1`0?ooo`3oool0L`3oool00`000000oooo0?ooo`1b0?ooo`03
0?l0L03oool0oooo04D0oooo00<003So0?ooo`3oool01`3oool000X0oooo00<003So0?ooo`3oool0
A@3oool00`3o0700oooo0?ooo`1d0?ooo`030000003oool0oooo07<0oooo00<0o`1`0?ooo`3oool0
A@3oool00`00>?l0oooo0?ooo`060?ooo`002P3oool00`00>?l0oooo0?ooo`150?ooo`030?l0L03o
ool0oooo07@0oooo00<000000?ooo`3oool0L`3oool00`3o0700oooo0?ooo`150?ooo`03000ho`3o
ool0oooo00H0oooo000:0?ooo`03000ho`3oool0oooo04@0oooo00<0o`1`0?ooo`3oool0M@3oool0
0`000000oooo0?ooo`1c0?ooo`030?l0L03oool0oooo04D0oooo00<003So0?ooo`3oool01P3oool0
00X0oooo00<003So0?ooo`3oool0A03oool00`3o0700oooo0?ooo`1e0?ooo`030000003oool0oooo
07@0oooo00<0o`1`0?ooo`3oool0A03oool00`00>?l0oooo0?ooo`060?ooo`002@3oool00`00>?l0
oooo0?ooo`150?ooo`030?l0L03oool0oooo05X0oooo0P0000040?ooo`8000000`3oool4000000<0
oooo0P0000070?ooo`030000003oool0oooo07@0oooo00<0o`1`0?ooo`3oool0A@3oool00`00>?l0
oooo0?ooo`050?ooo`002@3oool00`00>?l0oooo0?ooo`140?ooo`030?l0L03oool0oooo05X0oooo
00@000000?ooo`3oool00000203oool00`000000oooo0?ooo`030?ooo`040000003oool0oooo0000
00H0oooo00<000000?ooo`3oool0M03oool00`3o0700oooo0?ooo`150?ooo`03000ho`3oool0oooo
00D0oooo00090?ooo`03000ho`3oool0oooo04@0oooo00<0o`1`0?ooo`3oool0FP3oool010000000
oooo0?ooo`0000090?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0103oool30000
07D0oooo00<0o`1`0?ooo`3oool0A03oool00`00>?l0oooo0?ooo`050?ooo`002@3oool00`00>?l0
oooo0?ooo`130?ooo`030?l0L03oool0oooo05D0oooo100000020?ooo`040000003oool0oooo0000
00X0oooo00<000000?ooo`3oool00P3oool2000000L0oooo00<000000?ooo`3oool0M@3oool00`3o
0700oooo0?ooo`140?ooo`03000ho`3oool0oooo00D0oooo00090?ooo`03000ho`3oool0oooo04<0
oooo00<0o`1`0?ooo`3oool0F`3oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo
000000<0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`1f0?ooo`030?l0L03oool0
oooo04@0oooo00<003So0?ooo`3oool0103oool000P0oooo00<003So0?ooo`3oool0A03oool00`3o
0700oooo0?ooo`1L0?ooo`8000002P3oool2000000@0oooo0`0000060?ooo`030000003oool0oooo
07H0oooo00<0o`1`0?ooo`3oool0A03oool00`00>?l0oooo0?ooo`040?ooo`00203oool00`00>?l0
oooo0?ooo`130?ooo`030?l0L03oool0oooo07P0oooo00<000000?ooo`3oool0MP3oool00`3o0700
oooo0?ooo`140?ooo`03000ho`3oool0oooo00@0oooo00080?ooo`03000ho`3oool0oooo04<0oooo
00<0o`1`0?ooo`3oool0N03oool00`000000oooo0?ooo`1g0?ooo`030?l0L03oool0oooo04<0oooo
00<003So0?ooo`3oool0103oool000P0oooo00<003So0?ooo`3oool0@P3oool00`3o0700oooo0?oo
o`1i0?ooo`030000003oool0oooo07L0oooo00<0o`1`0?ooo`3oool0A03oool00`00>?l0oooo0?oo
o`030?ooo`00203oool00`00>?l0oooo0?ooo`120?ooo`030?l0L03oool0oooo07T0oooo00<00000
0?ooo`3oool0N03oool00`3o0700oooo0?ooo`130?ooo`03000ho`3oool0oooo00<0oooo00070?oo
o`03000ho`3oool0oooo04<0oooo00<0o`1`0?ooo`3oool0N@3oool00`000000oooo0?ooo`1h0?oo
o`030?l0L03oool0oooo04<0oooo00<003So0?ooo`3oool00`3oool000L0oooo00<003So0?ooo`3o
ool0@P3oool00`3o0700oooo0?ooo`1j0?ooo`030000003oool0oooo07P0oooo00<0o`1`0?ooo`3o
ool0@`3oool00`00>?l0oooo0?ooo`030?ooo`001`3oool00`00>?l0oooo0?ooo`120?ooo`030?l0
L03oool0oooo07X0oooo0P00001j0?ooo`030?l0L03oool0oooo04<0oooo00<003So0?ooo`3oool0
0P3oool000L0oooo00<003So0?ooo`3oool0@@3oool00`3o0700oooo0?ooo`1k0?ooo`030000003o
ool0oooo07T0oooo00<0o`1`0?ooo`3oool0@`3oool00`00>?l0oooo0?ooo`020?ooo`001P3oool0
0`00>?l0oooo0?ooo`120?ooo`030?l0L03oool0oooo07/0oooo00<000000?ooo`3oool0N@3oool0
0`3o0700oooo0?ooo`130?ooo`03000ho`3oool0oooo0080oooo00060?ooo`03000ho`3oool0oooo
0480oooo00<0o`1`0?ooo`3oool0N`3oool00`000000oooo0?ooo`1j0?ooo`030?l0L03oool0oooo
0480oooo00<003So0?ooo`3oool00P3oool000H0oooo00<003So0?ooo`3oool0@P3oool00`3o0700
oooo0?ooo`1c0?ooo`030?oi003oool0oooo00D0oooo00<000000?ooo`3oool0NP3oool00`3o0700
oooo0?ooo`130?ooo`03000ho`3oool0oooo0040oooo001:0?ooo`030?l0L03oool0oooo07<0oooo
0P3on@070?ooo`030000003oool0oooo07/0oooo00<0o`1`0?ooo`3oool0@P3oool00`00>?l0oooo
0?ooo`010?ooo`00BP3oool00`3o0700oooo0?ooo`1c0?ooo`80ooT01`3oool00`000000oooo0?oo
o`1k0?ooo`030?l0L03oool0oooo0480oooo00<003So0?ooo`3oool00@3oool004X0oooo00<0o`1`
0?ooo`3oool0LP3oool30?oi00L0oooo00<000000?ooo`3oool0N`3oool00`3o0700oooo0?ooo`16
0?ooo`00BP3oool00`3o0700oooo0?ooo`1a0?ooo`<0ooT0203oool00`000000oooo0?ooo`1k0?oo
o`030?l0L03oool0oooo04H0oooo001:0?ooo`030?l0L03oool0oooo0740oooo0`3on@080?ooo`03
0000003oool0oooo07/0oooo00<0o`1`0?ooo`3oool0AP3oool004T0oooo00<0o`1`0?ooo`3oool0
L@3oool40?oi00P0oooo0P00001m0?ooo`030?l0L03oool0oooo04D0oooo00190?ooo`030?l0L03o
ool0oooo0700oooo3@3on@000`000000oooo0?ooo`1l0?ooo`030?l0L03oool0oooo04D0oooo0019
0?ooo`030?l0L03oool0oooo06l0oooo3@3on@000`3oool000000?ooo`1m0?ooo`030?l0L03oool0
oooo04D0oooo00190?ooo`030?l0L03oool0oooo06l0oooo4`3on@1j0?ooo`030?l0L03oool0oooo
04D0oooo00190?ooo`030?l0L03oool0oooo06h0oooo2`3on@040?ooo`030000003oool0oooo0080
oooo0`3on@1g0?ooo`030?l0L03oool0oooo04D0oooo00190?ooo`030?l0L03oool0oooo06d0oooo
2@3on@070?ooo`030000003oool0oooo00D0oooo0P3on@1e0?ooo`030?l0L03oool0oooo04D0oooo
00180?ooo`030?l0L03oool0oooo06h0oooo1`3on@090?ooo`030000003oool0oooo00L0oooo0P3o
n@1c0?ooo`030?l0L03oool0oooo04D0oooo00180?ooo`030?l0L03oool0oooo06d0oooo1P3on@0;
0?ooo`030000003oool0oooo00T0oooo0P3on@1b0?ooo`030?l0L03oool0oooo04@0oooo00180?oo
o`030?l0L03oool0oooo06X0oooo1`3on@0=0?ooo`030000003oool0oooo00/0oooo0P3on@1`0?oo
o`030?l0L03oool0oooo04@0oooo00180?ooo`030?l0L03oool0oooo06T0oooo1P3on@0?0?ooo`80
00003P3oool00`3on@00oooo0?ooo`1]0?ooo`030?l0L03oool0oooo04@0oooo00180?ooo`030?l0
L03oool0oooo06P0oooo1`3on@0?0?ooo`030000003oool0oooo00h0oooo0P3on@1]0?ooo`030?l0
L03oool0oooo04@0oooo00180?ooo`030?l0L03oool0oooo06P0oooo1`3on@0?0?ooo`030000003o
ool0oooo0100oooo00<0ooT00?ooo`3oool0JP3oool00`3o0700oooo0?ooo`140?ooo`00A`3oool0
0`3o0700oooo0?ooo`1Y0?ooo`L0ooT03`3oool00`000000oooo0?ooo`0A0?ooo`030?oi003oool0
oooo06T0oooo00<0o`1`0?ooo`3oool0A03oool004L0oooo00<0o`1`0?ooo`3oool0JP3oool50?oi
0100oooo00<000000?ooo`3oool04@3oool00`3on@00oooo0?ooo`1Y0?ooo`030?l0L03oool0oooo
04@0oooo00170?ooo`030?l0L03oool0oooo06/0oooo0`3on@0A0?ooo`030000003oool0oooo0180
oooo00<0ooT00?ooo`3oool0J@3oool00`3o0700oooo0?ooo`130?ooo`00A`3oool00`3o0700oooo
0?ooo`1o0?ooo`030000003oool0oooo01<0oooo00<0ooT00?ooo`3oool0J03oool00`3o0700oooo
0?ooo`130?ooo`001`3oool5000002<0oooo0P0000040?ooo`8000001@3oool00`000000oooo0?oo
o`020?ooo`800000103oool00`3o0700oooo0?ooo`0I0?ooo`800000103oool2000000@0oooo0P00
000P0?ooo`800000103oool2000000<0oooo100000030?ooo`800000903oool00`000000oooo0?oo
o`0C0?ooo`030?oi003oool0oooo00d0oooo0P0000040?ooo`8000000`3oool4000000<0oooo0P00
000P0?ooo`800000103oool2000000@0oooo0P00000I0?ooo`030?l0L03oool0oooo00@0oooo0P00
00040?ooo`8000001@3oool00`000000oooo0?ooo`020?ooo`8000009@3oool500000040oooo0009
0?ooo`030000003oool0oooo0280oooo00@000000?ooo`3oool000002P3oool01@000000oooo0?oo
o`3oool000000080oooo00D000000?ooo`3oool0oooo0?l0L00J0?ooo`040000003oool0oooo0000
00P0oooo00@000000?ooo`3oool000007P3oool010000000oooo0?ooo`0000080?ooo`030000003o
ool0oooo00<0oooo00@000000?ooo`3oool000008`3oool00`000000oooo0?ooo`0D0?ooo`030?oi
003oool0oooo00/0oooo00@000000?ooo`3oool00000203oool00`000000oooo0?ooo`030?ooo`04
0000003oool0oooo000001h0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`00
000H0?ooo`030?l0L03oool0oooo00<0oooo00@000000?ooo`3oool000002P3oool01@000000oooo
0?ooo`3oool000000080oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`010?ooo`00
2@3oool00`000000oooo0?ooo`0R0?ooo`040000003oool0oooo000000X0oooo00<000000?ooo`3o
ool0103oool01@000000oooo0?ooo`3oool0o`1`01X0oooo00@000000?ooo`3oool000002`3oool0
0`000000oooo0?ooo`0L0?ooo`040000003oool0oooo000000T0oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo01@0oooo00<0ooT00?ooo`3oool02`3o
ool010000000oooo0?ooo`0000090?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
703oool010000000oooo0?ooo`00000;0?ooo`030000003oool0oooo01H0oooo00<0o`1`0?ooo`3o
ool00`3oool010000000oooo0?ooo`00000:0?ooo`030000003oool0oooo00@0oooo00<000000?oo
o`3oool0903oool00`000000oooo0?ooo`010?ooo`0000<0oooo0000000000000P0000040?ooo`03
0000003oool0oooo01`0oooo100000020?ooo`040000003oool0oooo000000/0oooo00@000000?oo
o`3oool0oooo0P0000040?ooo`030?l0L03oool0oooo0180oooo100000020?ooo`040000003oool0
oooo000000T0oooo0P00000I0?ooo`@000000P3oool010000000oooo0?ooo`00000:0?ooo`030000
003oool0oooo0080oooo0P00000;0?ooo`030?oi003oool0oooo01H0oooo0P00000F0?ooo`030?oi
003oool0oooo00X0oooo00@000000?ooo`3oool000002P3oool00`000000oooo0?ooo`020?ooo`80
00007`3oool010000000oooo0?ooo`0000090?ooo`8000006@3oool00`3o0700oooo0?ooo`030?oo
o`040000003oool0oooo000000/0oooo00@000000?ooo`3oool0oooo0P00000W0?ooo`030000003o
ool0oooo0040oooo00090?ooo`030000003oool0oooo0280oooo00@000000?ooo`3oool00000203o
ool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo0080oooo00<0o`1`0?ooo`3oool0
6@3oool010000000oooo0?ooo`0000090?ooo`030000003oool0oooo01h0oooo00@000000?ooo`3o
ool00000203oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo00X0oooo00<0ooT0
0?ooo`3oool05P3oool00`000000oooo0?ooo`0E0?ooo`030?oi003oool0oooo00X0oooo00@00000
0?ooo`3oool00000203oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo01h0oooo
00@000000?ooo`3oool000002@3oool00`000000oooo0?ooo`0H0?ooo`030?l0L03oool0oooo00<0
oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`0000030?ooo`030000003oool0
oooo02H0oooo00<000000?ooo`3oool00@3oool000P0oooo0P00000U0?ooo`8000002@3oool40000
00<0oooo0`0000020?ooo`030?l0L03oool0oooo01X0oooo0P00000:0?ooo`<000007`3oool20000
00X0oooo0P0000040?ooo`<000002@3oool20?oi01P0oooo00<000000?ooo`3oool05@3oool00`3o
n@00oooo0?ooo`0;0?ooo`8000002P3oool2000000@0oooo0`00000O0?ooo`8000002P3oool30000
01T0oooo00<0o`1`0?ooo`3oool00`3oool2000000T0oooo100000030?ooo`<000009@3oool20000
00<0oooo00160?ooo`030?l0L03oool0oooo06H0oooo00<0ooT00?ooo`3oool05`3oool00`000000
oooo0?ooo`0F0?ooo`030?oi003oool0oooo06H0oooo00<0o`1`0?ooo`3oool0@P3oool004H0oooo
00<0o`1`0?ooo`3oool0IP3oool00`3on@00oooo0?ooo`0G0?ooo`030000003oool0oooo01H0oooo
00<0ooT00?ooo`3oool0IP3oool00`3o0700oooo0?ooo`120?ooo`00AP3oool00`3o0700oooo0?oo
o`1V0?ooo`030?oi003oool0oooo01L0oooo00<000000?ooo`3oool05P3oool00`3on@00oooo0?oo
o`1V0?ooo`030?l0L03oool0oooo0480oooo00160?ooo`030?l0L03oool0oooo06H0oooo00<0ooT0
0?ooo`3oool05`3oool00`000000oooo0?ooo`0F0?ooo`030?oi003oool0oooo06H0oooo00<0o`1`
0?ooo`3oool0@P3oool004H0oooo00<0o`1`0?ooo`3oool0I@3oool00`3on@00oooo0?ooo`0H0?oo
o`030000003oool0oooo01H0oooo00<0ooT00?ooo`3oool0IP3oool00`3o0700oooo0?ooo`120?oo
o`00AP3oool00`3o0700oooo0?ooo`1U0?ooo`030?oi003oool0oooo01P0oooo00<000000?ooo`3o
ool05`3oool00`3on@00oooo0?ooo`1U0?ooo`030?l0L03oool0oooo0480oooo00160?ooo`030?l0
L03oool0oooo06D0oooo00<0ooT00?ooo`3oool0603oool00`000000oooo0?ooo`0G0?ooo`030?oi
003oool0oooo06D0oooo00<0o`1`0?ooo`3oool0@P3oool000H0oooo@00000000`3o070000000000
001U000000030?oi0000000000000380000000<0ooT0000000000000I@0000000`3o070000000000
000o000000<0oooo00060?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool0
0`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool0
0`000000oooo0?ooo`070?ooo`030000003oool0oooo00<0oooo00D0o`1`0?ooo`3oool0oooo0000
00090?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`060?ooo`040000003oool0oooo0?oi00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo
0?ooo`040?ooo`040?oi003oool0oooo000000T0oooo00<000000?ooo`3oool01P3oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00D000000?ooo`3oool0oooo0?l0L0050?oo
o`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`060?oo
o`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`070?oo
o`030000003oool0oooo0040oooo00060?ooo`030000003oool0oooo02d0oooo00<000000?ooo`3o
ool03@3oool00`3o0700oooo0?ooo`0N0?ooo`030000003oool0oooo02h0oooo00<000000?ooo`3o
ool04`3oool00`3on@00oooo0?ooo`0H0?ooo`030000003oool0oooo01H0oooo00<0ooT00?ooo`3o
ool0503oool00`000000oooo0?ooo`0^0?ooo`030000003oool0oooo01h0oooo00<0o`1`0?ooo`3o
ool03@3oool00`000000oooo0?ooo`0^0?ooo`030000003oool0oooo0040oooo00170?ooo`030?l0
L03oool0oooo06D0oooo00<0ooT00?ooo`3oool05`3oool00`000000oooo0?ooo`0F0?ooo`030?oi
003oool0oooo06H0oooo00<0o`1`0?ooo`3oool0@P3oool004L0oooo00<0o`1`0?ooo`3oool0I@3o
ool00`3on@00oooo0?ooo`0G0?ooo`030000003oool0oooo01H0oooo00<0ooT00?ooo`3oool0IP3o
ool00`3o0700oooo0?ooo`120?ooo`00A`3oool00`3o0700oooo0?ooo`1U0?ooo`030?oi003oool0
oooo01L0oooo00<000000?ooo`3oool05P3oool00`3on@00oooo0?ooo`1V0?ooo`030?l0L03oool0
oooo0480oooo00170?ooo`030?l0L03oool0oooo06D0oooo00<0ooT00?ooo`3oool05`3oool00`00
0000oooo0?ooo`0E0?ooo`030?oi003oool0oooo06L0oooo00<0o`1`0?ooo`3oool0@P3oool004L0
oooo00<0o`1`0?ooo`3oool0I@3oool00`3on@00oooo0?ooo`0G0?ooo`030000003oool0oooo01D0
oooo00<0ooT00?ooo`3oool0I`3oool00`3o0700oooo0?ooo`120?ooo`00A`3oool00`3o0700oooo
0?ooo`1U0?ooo`030?oi003oool0oooo01L0oooo00<000000?ooo`3oool05@3oool00`3on@00oooo
0?ooo`1W0?ooo`030?l0L03oool0oooo0480oooo00170?ooo`030?l0L03oool0oooo06H0oooo00<0
ooT00?ooo`3oool05P3oool00`000000oooo0?ooo`0E0?ooo`030?oi003oool0oooo06L0oooo00<0
o`1`0?ooo`3oool0@P3oool004L0oooo00<0o`1`0?ooo`3oool0IP3oool00`3on@00oooo0?ooo`0F
0?ooo`8000005@3oool00`3on@00oooo0?ooo`1X0?ooo`030?l0L03oool0oooo0480oooo00170?oo
o`030?l0L03oool0oooo06L0oooo00<0ooT00?ooo`3oool05@3oool00`000000oooo0?ooo`0D0?oo
o`030?oi003oool0oooo06P0oooo00<0o`1`0?ooo`3oool0@P3oool004L0oooo00<0o`1`0?ooo`3o
ool0I`3oool00`3on@00oooo0?ooo`0E0?ooo`030000003oool0oooo01<0oooo00<0ooT00?ooo`3o
ool0J03oool00`3o0700oooo0?ooo`130?ooo`00A`3oool00`3o0700oooo0?ooo`1X0?ooo`030?oi
003oool0oooo01@0oooo00<000000?ooo`3oool04`3oool00`3on@00oooo0?ooo`1X0?ooo`030?l0
L03oool0oooo04<0oooo00170?ooo`030?l0L03oool0oooo06P0oooo00<0ooT00?ooo`3oool0503o
ool00`000000oooo0?ooo`0B0?ooo`030?oi003oool0oooo06T0oooo00<0o`1`0?ooo`3oool0@`3o
ool004P0oooo00<0o`1`0?ooo`3oool0J03oool00`3on@00oooo0?ooo`0C0?ooo`030000003oool0
oooo0180oooo00<0ooT00?ooo`3oool0J@3oool00`3o0700oooo0?ooo`130?ooo`00B03oool00`3o
0700oooo0?ooo`1Y0?ooo`030?oi003oool0oooo0180oooo00<000000?ooo`3oool04@3oool00`3o
n@00oooo0?ooo`1Z0?ooo`030?l0L03oool0oooo04<0oooo00180?ooo`030?l0L03oool0oooo06T0
oooo00<0ooT00?ooo`3oool04P3oool00`000000oooo0?ooo`0@0?ooo`030?oi003oool0oooo06/0
oooo00<0o`1`0?ooo`3oool0@`3oool004P0oooo00<0o`1`0?ooo`3oool0JP3oool00`3on@00oooo
0?ooo`0A0?ooo`030000003oool0oooo00l0oooo00<0ooT00?ooo`3oool0K03oool00`3o0700oooo
0?ooo`130?ooo`00B03oool00`3o0700oooo0?ooo`1[0?ooo`030?oi003oool0oooo0100oooo0P00
000@0?ooo`030?oi003oool0oooo06/0oooo00<0o`1`0?ooo`3oool0A03oool004P0oooo00<0o`1`
0?ooo`3oool0K03oool20?oi0100oooo00<000000?ooo`3oool03P3oool00`3on@00oooo0?ooo`1/
0?ooo`030?l0L03oool0oooo04@0oooo00180?ooo`030?l0L03oool0oooo06h0oooo00<0ooT00?oo
o`3oool03@3oool00`000000oooo0?ooo`0<0?ooo`80ooT0K`3oool00`3o0700oooo0?ooo`140?oo
o`00B03oool00`3o0700oooo0?ooo`1_0?ooo`80ooT03@3oool00`000000oooo0?ooo`0:0?ooo`80
ooT0L@3oool00`3o0700oooo0?ooo`140?ooo`00B@3oool00`3o0700oooo0?ooo`1`0?ooo`80ooT0
2`3oool00`000000oooo0?ooo`090?ooo`030?oi003oool0oooo0740oooo00<0o`1`0?ooo`3oool0
A03oool004T0oooo00<0o`1`0?ooo`3oool0LP3oool20?oi00T0oooo00<000000?ooo`3oool01`3o
ool20?oi07@0oooo00<0o`1`0?ooo`3oool0A03oool004T0oooo00<0o`1`0?ooo`3oool0M03oool3
0?oi00H0oooo00<000000?ooo`3oool0103oool30?oi07D0oooo00<0o`1`0?ooo`3oool0A@3oool0
04T0oooo00<0o`1`0?ooo`3oool0M`3oool=0?oi07P0oooo00<0o`1`0?ooo`3oool0A@3oool004T0
oooo00<0o`1`0?ooo`3oool0O@3oool00`000000oooo0?ooo`1l0?ooo`030?l0L03oool0oooo04D0
oooo00190?ooo`030?l0L03oool0oooo07d0oooo00<000000?ooo`3oool0O03oool00`3o0700oooo
0?ooo`150?ooo`00BP3oool00`3o0700oooo0?ooo`1l0?ooo`800000O03oool00`3o0700oooo0?oo
o`160?ooo`00BP3oool00`3o0700oooo0?ooo`1l0?ooo`030000003oool0oooo07/0oooo00<0o`1`
0?ooo`3oool0AP3oool004X0oooo00<0o`1`0?ooo`3oool0O03oool00`000000oooo0?ooo`1k0?oo
o`030?l0L03oool0oooo04H0oooo001:0?ooo`030?l0L03oool0oooo07`0oooo00<000000?ooo`3o
ool0N`3oool00`3o0700oooo0?ooo`160?ooo`00B`3oool00`3o0700oooo0?ooo`1k0?ooo`030000
003oool0oooo07/0oooo00<0o`1`0?ooo`3oool0@P3oool00`00>?l0oooo0?ooo`010?ooo`001P3o
ool00`00>?l0oooo0?ooo`120?ooo`030?l0L03oool0oooo07/0oooo00<000000?ooo`3oool0NP3o
ool00`3o0700oooo0?ooo`130?ooo`03000ho`3oool0oooo0040oooo00060?ooo`03000ho`3oool0
oooo0480oooo00<0o`1`0?ooo`3oool0N`3oool00`000000oooo0?ooo`1j0?ooo`030?l0L03oool0
oooo04<0oooo00<003So0?ooo`3oool00@3oool000H0oooo00<003So0?ooo`3oool0@P3oool00`3o
0700oooo0?ooo`1k0?ooo`030000003oool0oooo07X0oooo00<0o`1`0?ooo`3oool0@`3oool00`00
>?l0oooo0?ooo`010?ooo`001P3oool00`00>?l0oooo0?ooo`130?ooo`030?l0L03oool0oooo07X0
oooo00<000000?ooo`3oool0N@3oool00`3o0700oooo0?ooo`130?ooo`03000ho`3oool0oooo0080
oooo00070?ooo`03000ho`3oool0oooo0480oooo00<0o`1`0?ooo`3oool0NP3oool00`000000oooo
0?ooo`1i0?ooo`030?l0L03oool0oooo04<0oooo00<003So0?ooo`3oool00P3oool000L0oooo00<0
03So0?ooo`3oool0@P3oool00`3o0700oooo0?ooo`1j0?ooo`800000NP3oool00`3o0700oooo0?oo
o`130?ooo`03000ho`3oool0oooo0080oooo00070?ooo`03000ho`3oool0oooo0480oooo00<0o`1`
0?ooo`3oool0NP3oool00`000000oooo0?ooo`1h0?ooo`030?l0L03oool0oooo04@0oooo00<003So
0?ooo`3oool00P3oool000L0oooo00<003So0?ooo`3oool0@`3oool00`3o0700oooo0?ooo`1i0?oo
o`030000003oool0oooo07P0oooo00<0o`1`0?ooo`3oool0A03oool00`00>?l0oooo0?ooo`020?oo
o`001`3oool00`00>?l0oooo0?ooo`130?ooo`030?l0L03oool0oooo07T0oooo00<000000?ooo`3o
ool0M`3oool00`3o0700oooo0?ooo`150?ooo`03000ho`3oool0oooo0080oooo00070?ooo`03000h
o`3oool0oooo04<0oooo00<0o`1`0?ooo`3oool0N@3oool00`000000oooo0?ooo`1g0?ooo`030?l0
L03oool0oooo04@0oooo00<003So0?ooo`3oool00`3oool000L0oooo00<003So0?ooo`3oool0A03o
ool00`3o0700oooo0?ooo`1h0?ooo`030000003oool0oooo07L0oooo00<0o`1`0?ooo`3oool0A03o
ool00`00>?l0oooo0?ooo`030?ooo`00203oool00`00>?l0oooo0?ooo`130?ooo`030?l0L03oool0
oooo07P0oooo00<000000?ooo`3oool0M`3oool00`3o0700oooo0?ooo`140?ooo`03000ho`3oool0
oooo00<0oooo00080?ooo`03000ho`3oool0oooo04@0oooo00<0o`1`0?ooo`3oool0M`3oool00`00
0000oooo0?ooo`1g0?ooo`030?l0L03oool0oooo04@0oooo00<003So0?ooo`3oool00`3oool000P0
oooo00<003So0?ooo`3oool0A03oool00`3o0700oooo0?ooo`1L0?ooo`800000103oool2000000<0
oooo100000030?ooo`8000001`3oool00`000000oooo0?ooo`2m0?ooo`03000ho`3oool0oooo00@0
oooo00080?ooo`03000ho`3oool0oooo04D0oooo00<0o`1`0?ooo`3oool0FP3oool010000000oooo
0?ooo`0000080?ooo`030000003oool0oooo00<0oooo00@000000?ooo`3oool000001P3oool00`00
0000oooo0?ooo`2m0?ooo`03000ho`3oool0oooo00@0oooo00080?ooo`03000ho`3oool0oooo04D0
oooo00<0o`1`0?ooo`3oool0FP3oool010000000oooo0?ooo`0000090?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`3oool0103oool300000;d0oooo00<003So0?ooo`3oool0103oool000T0
oooo00<003So0?ooo`3oool0A03oool00`3o0700oooo0?ooo`1J0?ooo`040000003oool0oooo0000
00X0oooo00<000000?ooo`3oool00P3oool2000000L0oooo00<000000?ooo`3oool0_03oool00`00
>?l0oooo0?ooo`050?ooo`002@3oool00`00>?l0oooo0?ooo`150?ooo`030?l0L03oool0oooo05T0
oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`0000030?ooo`030000003oool0
oooo00H0oooo00<000000?ooo`3oool0_03oool00`00>?l0oooo0?ooo`050?ooo`002@3oool00`00
>?l0oooo0?ooo`150?ooo`030?l0L03oool0oooo05X0oooo0P00000:0?ooo`800000103oool30000
00H0oooo00<000000?ooo`3oool0_03oool00`00>?l0oooo0?ooo`050?ooo`002P3oool00`00>?l0
oooo0?ooo`150?ooo`030?l0L03oool0oooo07@0oooo00<000000?ooo`3oool0^`3oool00`00>?l0
oooo0?ooo`060?ooo`002P3oool00`00>?l0oooo0?ooo`150?ooo`030?l0L03oool0oooo07@0oooo
00<000000?ooo`3oool0^`3oool00`00>?l0oooo0?ooo`060?ooo`002P3oool00`00>?l0oooo0?oo
o`160?ooo`030?l0L03oool0oooo07<0oooo00<000000?ooo`3oool0^`3oool00`00>?l0oooo0?oo
o`060?ooo`002`3oool00`00>?l0oooo0?ooo`150?ooo`030?l0L03oool0oooo07<0oooo00<00000
0?ooo`3oool0^`3oool00`00>?l0oooo0?ooo`060?ooo`002`3oool00`00>?l0oooo0?ooo`160?oo
o`030?l0L03oool0oooo0780oooo00<000000?ooo`3oool0^P3oool00`00>?l0oooo0?ooo`070?oo
o`002`3oool00`00>?l0oooo0?ooo`160?ooo`030?l0L03oool0oooo0780oooo0P00002k0?ooo`03
000ho`3oool0oooo00L0oooo000<0?ooo`03000ho`3oool0oooo04H0oooo00<0o`1`0?ooo`3oool0
L@3oool00`000000oooo0?ooo`2j0?ooo`03000ho`3oool0oooo00L0oooo000<0?ooo`03000ho`3o
ool0oooo04H0oooo00<0o`1`0?ooo`3oool0L@3oool00`000000oooo0?ooo`2i0?ooo`03000ho`3o
ool0oooo00P0oooo000=0?ooo`03000ho`3oool0oooo04H0oooo00<0o`1`0?ooo`3oool0L03oool0
0`000000oooo0?ooo`2i0?ooo`03000ho`3oool0oooo00P0oooo000=0?ooo`03000ho`3oool0oooo
04H0oooo00<0o`1`0?ooo`3oool0L03oool00`000000oooo0?ooo`2i0?ooo`03000ho`3oool0oooo
00P0oooo000=0?ooo`03000ho`3oool0oooo04L0oooo00<0o`1`0?ooo`3oool0K`3oool00`000000
oooo0?ooo`2i0?ooo`03000ho`3oool0oooo00P0oooo000>0?ooo`03000ho`3oool0oooo04L0oooo
00<0o`1`0?ooo`3oool0KP3oool00`000000oooo0?ooo`2h0?ooo`03000ho`3oool0oooo00T0oooo
000>0?ooo`03000ho`3oool0oooo04L0oooo00<0o`1`0?ooo`3oool0KP3oool00`000000oooo0?oo
o`2h0?ooo`03000ho`3oool0oooo00T0oooo000>0?ooo`03000ho`3oool0oooo04P0oooo00<0o`1`
0?ooo`3oool0K@3oool00`000000oooo0?ooo`2h0?ooo`03000ho`3oool0oooo00T0oooo000?0?oo
o`03000ho`3oool0oooo04L0oooo00<0o`1`0?ooo`3oool0K@3oool00`000000oooo0?ooo`2g0?oo
o`03000ho`3oool0oooo00X0oooo000?0?ooo`03000ho`3oool0oooo04P0oooo00<0o`1`0?ooo`3o
ool0K03oool200000;P0oooo00<003So0?ooo`3oool02P3oool000l0oooo00<003So0?ooo`3oool0
B03oool00`3o0700oooo0?ooo`1/0?ooo`030000003oool0oooo0;H0oooo00<003So0?ooo`3oool0
2`3oool00100oooo00<003So0?ooo`3oool0B03oool00`3o0700oooo0?ooo`1[0?ooo`030000003o
ool0oooo0;H0oooo00<003So0?ooo`3oool02`3oool00100oooo00<003So0?ooo`3oool0B@3oool0
0`3o0700oooo0?ooo`1Z0?ooo`030000003oool0oooo0;H0oooo00<003So0?ooo`3oool02`3oool0
0100oooo00<003So0?ooo`3oool0B@3oool00`3o0700oooo0?ooo`1Z0?ooo`030000003oool0oooo
0;D0oooo00<003So0?ooo`3oool0303oool00140oooo00<003So0?ooo`3oool0B@3oool00`3o0700
oooo0?ooo`1Y0?ooo`030000003oool0oooo0;D0oooo00<003So0?ooo`3oool0303oool00140oooo
00<003So0?ooo`3oool0BP3oool00`3o0700oooo0?ooo`1X0?ooo`030000003oool0oooo0;@0oooo
00<003So0?ooo`3oool03@3oool00180oooo00<003So0?ooo`3oool0B@3oool00`3o0700oooo0?oo
o`1X0?ooo`030000003oool0oooo0;@0oooo00<003So0?ooo`3oool03@3oool00180oooo00<003So
0?ooo`3oool0BP3oool00`3o0700oooo0?ooo`1W0?ooo`030000003oool0oooo0;<0oooo00<003So
0?ooo`3oool03P3oool001<0oooo00<003So0?ooo`3oool0BP3oool00`3o0700oooo0?ooo`1V0?oo
o`030000003oool0oooo0;<0oooo00<003So0?ooo`3oool03P3oool001<0oooo00<003So0?ooo`3o
ool0B`3oool00`3o0700oooo0?ooo`1U0?ooo`800000]03oool00`00>?l0oooo0?ooo`0>0?ooo`00
4`3oool00`00>?l0oooo0?ooo`1;0?ooo`030?l0L03oool0oooo06D0oooo00<000000?ooo`3oool0
/P3oool00`00>?l0oooo0?ooo`0?0?ooo`00503oool00`00>?l0oooo0?ooo`1;0?ooo`030?l0L03o
ool0oooo06@0oooo00<000000?ooo`3oool0/P3oool00`00>?l0oooo0?ooo`0?0?ooo`00503oool0
0`00>?l0oooo0?ooo`1<0?ooo`030?l0L03oool0oooo06<0oooo00<000000?ooo`3oool0/@3oool0
0`00>?l0oooo0?ooo`0@0?ooo`005@3oool00`00>?l0oooo0?ooo`1;0?ooo`030?l0L03oool0oooo
06<0oooo00<000000?ooo`3oool0/@3oool00`00>?l0oooo0?ooo`0@0?ooo`005@3oool00`00>?l0
oooo0?ooo`1<0?ooo`030?l0L03oool0oooo0680oooo00<000000?ooo`3oool0/@3oool00`00>?l0
oooo0?ooo`0@0?ooo`005P3oool00`00>?l0oooo0?ooo`1<0?ooo`030?l0L03oool0oooo0640oooo
00<000000?ooo`3oool0/03oool00`00>?l0oooo0?ooo`0A0?ooo`005P3oool00`00>?l0oooo0?oo
o`1=0?ooo`030?l0L03oool0oooo0600oooo00<000000?ooo`3oool0/03oool00`00>?l0oooo0?oo
o`0A0?ooo`005`3oool00`00>?l0oooo0?ooo`1=0?ooo`030?l0L03oool0oooo05l0oooo00<00000
0?ooo`3oool0[`3oool00`00>?l0oooo0?ooo`0B0?ooo`005`3oool00`00>?l0oooo0?ooo`1>0?oo
o`030?l0L03oool0oooo05h0oooo00<000000?ooo`3oool0[`3oool00`00>?l0oooo0?ooo`0B0?oo
o`005`3oool00`00>?l0oooo0?ooo`1?0?ooo`030?l0L03oool0oooo05d0oooo0P00001J0?ooo`<0
o`1`DP3oool00`00>?l0oooo0?ooo`0C0?ooo`00603oool00`00>?l0oooo0?ooo`1>0?ooo`030?l0
L03oool0oooo05d0oooo00<000000?ooo`3oool0F03oool50?l0L540oooo00<003So0?ooo`3oool0
4`3oool001P0oooo00<003So0?ooo`3oool0C`3oool00`3o0700oooo0?ooo`1L0?ooo`030000003o
ool0oooo05L0oooo1`3o071?0?ooo`03000ho`3oool0oooo01@0oooo000I0?ooo`03000ho`3oool0
oooo04l0oooo00<0o`1`0?ooo`3oool0F`3oool00`000000oooo0?ooo`1G0?ooo`L0o`1`C`3oool0
0`00>?l0oooo0?ooo`0D0?ooo`006@3oool00`00>?l0oooo0?ooo`1@0?ooo`030?l0L03oool0oooo
05X0oooo00<000000?ooo`3oool0E`3oool70?l0L4h0oooo00<003So0?ooo`3oool05@3oool001X0
oooo00<003So0?ooo`3oool0D03oool00`3o0700oooo0?ooo`1I0?ooo`030000003oool0oooo05H0
oooo1`3o071?0?ooo`03000ho`3oool0oooo01D0oooo000J0?ooo`03000ho`3oool0oooo0540oooo
00<0o`1`0?ooo`3oool0F03oool00`000000oooo0?ooo`1D0?ooo`P0o`1`C`3oool00`00>?l0oooo
0?ooo`0F0?ooo`006`3oool00`00>?l0oooo0?ooo`1A0?ooo`030?l0L03oool0oooo0480oooo0P00
00040?ooo`800000103oool2000000L0oooo00<000000?ooo`3oool0DP3oool60?l0L580oooo00<0
03So0?ooo`3oool05`3oool001/0oooo00<003So0?ooo`3oool0DP3oool00`3o0700oooo0?ooo`10
0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool000001P3oool00`000000oooo
0?ooo`1@0?ooo`P0o`1`DP3oool00`00>?l0oooo0?ooo`0G0?ooo`00703oool00`00>?l0oooo0?oo
o`1B0?ooo`80o`1`@03oool010000000oooo0?ooo`00000;0?ooo`030000003oool0oooo00@0oooo
0`00001>0?ooo`T0o`1`DP3oool00`00>?l0oooo0?ooo`0H0?ooo`00703oool00`00>?l0oooo0?oo
o`1D0?ooo`030?l0L03oool0oooo03d0oooo00@000000?ooo`3oool000002@3oool2000000L0oooo
00<000000?ooo`3oool0C03oool:0?l0L5<0oooo00<003So0?ooo`3oool0603oool001d0oooo00<0
03So0?ooo`3oool0E03oool00`3o0700oooo0?ooo`0l0?ooo`040000003oool0oooo000000T0oooo
00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`1:0?ooo``0o`1`DP3oool00`00>?l0oooo
0?ooo`0I0?ooo`007P3oool00`00>?l0oooo0?ooo`1D0?ooo`80o`1`?@3oool2000000X0oooo0`00
00060?ooo`030000003oool0oooo04P0oooo3@3o071C0?ooo`03000ho`3oool0oooo01T0oooo000N
0?ooo`03000ho`3oool0oooo05H0oooo00<0o`1`0?ooo`3oool0C`3oool00`000000oooo0?ooo`1?
0?ooo`H0o`1`DP3oool00`00>?l0oooo0?ooo`0J0?ooo`007`3oool00`00>?l0oooo0?ooo`1F0?oo
o`030?l0L03oool0oooo04h0oooo00<000000?ooo`3oool0C@3oool20?l0L0030?ooo`3o0700o`1`
0080o`1`DP3oool00`00>?l0oooo0?ooo`0K0?ooo`007`3oool00`00>?l0oooo0?ooo`1G0?ooo`80
o`1`CP3oool00`000000oooo0?ooo`1<0?ooo`040?l0L03oool0oooo0?ooo`<0o`1`D`3oool00`00
>?l0oooo0?ooo`0K0?ooo`00803oool00`00>?l0oooo0?ooo`1H0?ooo`030?l0L03oool0oooo04/0
oooo00<000000?ooo`3oool0BP3oool20?l0L0<0oooo103o071B0?ooo`03000ho`3oool0oooo01`0
oooo000P0?ooo`03000ho`3oool0oooo05T0oooo00<0o`1`0?ooo`3oool0BP3oool00`000000oooo
0?ooo`190?ooo`030?l0L03oool0oooo00<0oooo0`3o071C0?ooo`03000ho`3oool0oooo01`0oooo
000Q0?ooo`03000ho`3oool0oooo05T0oooo0P3o071:0?ooo`030000003oool0oooo04L0oooo0P3o
07060?ooo`80o`1`D`3oool00`00>?l0oooo0?ooo`0M0?ooo`008P3oool00`00>?l0oooo0?ooo`1J
0?ooo`030?l0L03oool0oooo04L0oooo0P0000170?ooo`030?l0L03oool0oooo00H0oooo0P3o071C
0?ooo`03000ho`3oool0oooo01d0oooo000R0?ooo`03000ho`3oool0oooo05/0oooo0P3o07170?oo
o`030000003oool0oooo04@0oooo0P3o07090?ooo`030?l0L03oool0oooo0540oooo00<003So0?oo
o`3oool07P3oool002<0oooo00<003So0?ooo`3oool0G03oool00`3o0700oooo0?ooo`140?ooo`03
0000003oool0oooo04<0oooo00<0o`1`0?ooo`3oool0G03oool00`00>?l0oooo0?ooo`0O0?ooo`00
8`3oool00`00>?l0oooo0?ooo`1M0?ooo`030?l0L03oool0oooo04<0oooo00<000000?ooo`3oool0
@@3oool20?l0L5h0oooo00<003So0?ooo`3oool0803oool002@0oooo00<003So0?ooo`3oool0G@3o
ool20?l0L4<0oooo00<000000?ooo`3oool0?`3oool20?l0L600oooo00<003So0?ooo`3oool0803o
ool002D0oooo00<003So0?ooo`3oool0GP3oool00`3o0700oooo0?ooo`100?ooo`030000003oool0
oooo03d0oooo0P3o071Q0?ooo`03000ho`3oool0oooo0240oooo000V0?ooo`03000ho`3oool0oooo
0080oooo00<003So0?ooo`3oool0F@3oool20?l0L400oooo00<000000?ooo`3oool0?03oool00`3o
0700oooo0?ooo`1P0?ooo`03000ho`3oool0oooo0280oooo000V0?ooo`03000ho`3oool0oooo0080
oooo00<003So0?ooo`3oool0F`3oool20?l0L3h0oooo00<000000?ooo`3oool0>P3oool20?l0L680
oooo00<003So0?ooo`3oool08`3oool002L0oooo00@003So0?ooo`3oool0oooo0P00>?mN0?ooo`80
o`1`?03oool00`000000oooo0?ooo`0h0?ooo`80o`1`I03oool00`00>?l0oooo0?ooo`0S0?ooo`00
:03oool00`00>?l0oooo0?ooo`02000hof00oooo0P3o070j0?ooo`030000003oool0oooo03H0oooo
0P3o071U0?ooo`03000ho`3oool0oooo02@0oooo000Y0?ooo`03000ho`3oool003So008003SoH@3o
ool20?l0L3P0oooo0P00000e0?ooo`80o`1`IP3oool00`00>?l0oooo0?ooo`0U0?ooo`00:P3oool4
000hof<0oooo0P3o070f0?ooo`030000003oool0oooo0380oooo0P3o071W0?ooo`03000ho`3oool0
oooo02H0oooo000S0?ooo`@003So0`3oool5000hof@0oooo0P3o070d0?ooo`030000003oool0oooo
0300oooo0P3o071Y0?ooo`03000ho`3oool0oooo02H0oooo000T0?ooo`/003SoIP3oool20?l0L380
oooo00<000000?ooo`3oool0;@3oool30?l0L6X0oooo00<003So0?ooo`3oool09`3oool002D0oooo
2`00>?mW0?ooo`<0o`1`;`3oool00`000000oooo0?ooo`0[0?ooo`80o`1`K03oool00`00>?l0oooo
0?ooo`0X0?ooo`009`3oool9000hofX0oooo0`3o070/0?ooo`030000003oool0oooo02T0oooo0P3o
071]0?ooo`03000ho`3oool0oooo02T0oooo000X0?ooo`P003SoK@3oool30?l0L2T0oooo00<00000
0?ooo`3oool09P3oool30?l0L6l0oooo00<003So0?ooo`3oool0:@3oool002T0oooo2000>?m_0?oo
o`<0o`1`9P3oool00`000000oooo0?ooo`0T0?ooo`80o`1`L@3oool00`00>?l0oooo0?ooo`0Z0?oo
o`00:`3oool6000hog80oooo0`3o070S0?ooo`030000003oool0oooo0200oooo103o071b0?ooo`03
000ho`3oool0oooo02/0oooo000/0?ooo`H003SoM03oool40?l0L1l0oooo00<000000?ooo`3oool0
703oool40?l0L7D0oooo00<003So0?ooo`3oool0;03oool002d0oooo1@00>?mh0?ooo`D0o`1`6P3o
ool2000001P0oooo1@3o071i0?ooo`03000ho`3oool0oooo02`0oooo000_0?ooo`H003SoNP3oool6
0?l0L1@0oooo00<000000?ooo`3oool04`3oool40?l0L7d0oooo00<003So0?ooo`3oool0;@3oool0
0300oooo1P00>?mo0?ooo`/0o`1`2@3oool00`000000oooo0?ooo`070?ooo``0o`1`P03oool00`00
>?l0oooo0?ooo`0^0?ooo`00<03oool7000hohT0oooo4`3o072;0?ooo`03000ho`3oool0oooo02l0
oooo000`0?ooo`L003SoTP3oool00`000000oooo0?ooo`2A0?ooo`03000ho`3oool0oooo0300oooo
000`0?ooo`L003SoTP3oool00`000000oooo0?ooo`2@0?ooo`03000ho`3oool0oooo0340oooo000a
0?ooo`D003SoT`3oool00`000000oooo0?ooo`2?0?ooo`03000ho`3oool0oooo0380oooo000b0?oo
o`<003SoU03oool00`000000oooo0?ooo`2>0?ooo`03000ho`3oool0oooo03<0oooo00390?ooo`03
0000003oool0oooo08d0oooo00<003So0?ooo`3oool0=03oool00<T0oooo0P00002=0?ooo`03000h
o`3oool0oooo03D0oooo00390?ooo`030000003oool0oooo08/0oooo00<003So0?ooo`3oool0=P3o
ool00<T0oooo00<000000?ooo`3oool0RP3oool00`00>?l0oooo0?ooo`0g0?ooo`00b@3oool00`00
0000oooo0?ooo`290?ooo`03000ho`3oool0oooo03P0oooo00390?ooo`030000003oool0oooo08P0
oooo00<003So0?ooo`3oool0>@3oool00<T0oooo00<000000?ooo`3oool0Q`3oool00`00>?l0oooo
0?ooo`0j0?ooo`00b@3oool00`000000oooo0?ooo`260?ooo`03000ho`3oool0oooo03/0oooo0039
0?ooo`030000003oool0oooo08D0oooo00<003So0?ooo`3oool0?03oool00:h0oooo0P0000040?oo
o`8000001@3oool00`000000oooo0?ooo`020?ooo`8000001`3oool00`000000oooo0?ooo`240?oo
o`03000ho`3oool0oooo03d0oooo002]0?ooo`040000003oool0oooo000000X0oooo00D000000?oo
o`3oool0oooo000000020?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0P`3oool0
0`00>?l0oooo0?ooo`0n0?ooo`00[@3oool010000000oooo0?ooo`00000:0?ooo`030000003oool0
oooo00@0oooo00<000000?ooo`3oool0103oool300000880oooo00<003So0?ooo`3oool0?`3oool0
0:d0oooo00@000000?ooo`3oool000002`3oool010000000oooo0?ooo`3oool2000000L0oooo00<0
00000?ooo`3oool0P@3oool00`00>?l0oooo0?ooo`100?ooo`00[@3oool010000000oooo0?ooo`00
00080?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3oool01P3oool00`000000oooo
0?ooo`1o0?ooo`8003So@`3oool00:h0oooo0P0000090?ooo`@000000`3oool3000000H0oooo00<0
00000?ooo`3oool0OP3oool00`00>?l0oooo0?ooo`130?ooo`00b@3oool00`000000oooo0?ooo`1m
0?ooo`03000ho`3oool0oooo04@0oooo00390?ooo`030000003oool0oooo07`0oooo00<003So0?oo
o`3oool0A@3oool00<T0oooo00<000000?ooo`3oool0N`3oool00`00>?l0oooo0?ooo`160?ooo`00
b@3oool00`000000oooo0?ooo`1i0?ooo`8003SoB@3oool00<T0oooo00<000000?ooo`3oool0N03o
ool00`00>?l0oooo0?ooo`190?ooo`00b@3oool00`000000oooo0?ooo`1g0?ooo`03000ho`3oool0
oooo04X0oooo00390?ooo`800000M`3oool00`00>?l0oooo0?ooo`1;0?ooo`00b@3oool00`000000
oooo0?ooo`1e0?ooo`03000ho`3oool0oooo04`0oooo00390?ooo`030000003oool0oooo07<0oooo
0P00>?m?0?ooo`00b@3oool00`000000oooo0?ooo`1b0?ooo`03000ho`3oool0oooo04l0oooo0039
0?ooo`030000003oool0oooo0740oooo00<003So0?ooo`3oool0D03oool00<T0oooo00<000000?oo
o`3oool0L03oool00`00>?l0oooo0?ooo`1A0?ooo`00b@3oool00`000000oooo0?ooo`1^0?ooo`80
03SoE03oool00<T0oooo00<000000?ooo`3oool0K@3oool00`00>?l0oooo0?ooo`1D0?ooo`00b@3o
ool00`000000oooo0?ooo`1[0?ooo`8003SoE`3oool00<T0oooo00<000000?ooo`3oool0JP3oool0
0`00>?l0oooo0?ooo`1G0?ooo`00b@3oool2000006T0oooo0P00>?mJ0?ooo`00b@3oool00`000000
oooo0?ooo`1W0?ooo`03000ho`3oool0oooo05X0oooo00390?ooo`030000003oool0oooo06D0oooo
0P00>?mM0?ooo`00b@3oool00`000000oooo0?ooo`1S0?ooo`8003SoG`3oool00<T0oooo00<00000
0?ooo`3oool0HP3oool00`00>?l0oooo0?ooo`1O0?ooo`00b@3oool00`000000oooo0?ooo`1P0?oo
o`8003SoHP3oool00<T0oooo00<000000?ooo`3oool0G`3oool00`00>?l0oooo0?ooo`1R0?ooo`00
b@3oool00`000000oooo0?ooo`1M0?ooo`8003SoI@3oool00<T0oooo00<000000?ooo`3oool0F`3o
ool2000hofL0oooo00390?ooo`800000FP3oool2000hofT0oooo00390?ooo`030000003oool0oooo
05L0oooo0P00>?m[0?ooo`00b@3oool00`000000oooo0?ooo`1E0?ooo`8003SoK@3oool00<T0oooo
00<000000?ooo`3oool0D`3oool2000hofl0oooo00390?ooo`030000003oool0oooo0500oooo0`00
>?ma0?ooo`00MP3oool00`00>?l0oooo0?ooo`1@0?ooo`030000003oool0oooo04h0oooo0P00>?md
0?ooo`00M`3oool2000hoe00oooo00<000000?ooo`3oool0C03oool2000hogH0oooo001i0?ooo`<0
03SoC@3oool00`000000oooo0?ooo`1:0?ooo`8003SoN03oool007`0oooo0P00>?m;0?ooo`030000
003oool0oooo04P0oooo0P00>?mj0?ooo`00OP3oool3000hodP0oooo00<000000?ooo`3oool0A@3o
ool3000hog`0oooo00210?ooo`8003SoAP3oool2000004<0oooo0`00>?mo0?ooo`00P`3oool3000h
od<0oooo00<000000?ooo`3oool0@03oool2000hoh80oooo00260?ooo`<003So@03oool00`000000
oooo0?ooo`0m0?ooo`<003SoQ03oool008T0oooo0`00>?lm0?ooo`030000003oool0oooo03X0oooo
0`00>?n70?ooo`00S03oool4000hocT0oooo00<000000?ooo`3oool0>03oool2000hohX0oooo002@
0?ooo`@003So=@3oool00`000000oooo0?ooo`0e0?ooo`<003SoS03oool009@0oooo1000>?la0?oo
o`030000003oool0oooo0340oooo1000>?n?0?ooo`00V03oool4000hobd0oooo00<000000?ooo`3o
ool0;03oool5000hoi<0oooo002L0?ooo`@003So7`3oool5000000D0oooo00<000000?ooo`3oool0
:03oool4000hoiP0oooo002P0?ooo`@003So7@3oool00`000000oooo0?ooo`050?ooo`030000003o
ool0oooo02<0oooo1@00>?nL0?ooo`00Y03oool3000hoaX0oooo00<000000?ooo`3oool01@3oool3
00000200oooo0`00>?nQ0?ooo`00`@3oool00`000000oooo0?ooo`3<0?ooo`00`@3oool00`000000
oooo0?ooo`3<0?ooo`00`03oool200000<h0oooo003o0?oooi40oooo0000\
\>"],
  ImageRangeCache->{{{0, 399}, {399, 0}} -> {-1.03078, -1.02309, 0.00512826, \
0.00512826}},
  CellTags->"EquationTrekker"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        InterpretationBox[
          RowBox[{"EquationTrekkerState", "[", 
            
            RowBox[{"\<\"\\!\\({y[x] +  \\(\\*SuperscriptBox[\\(y\\),  \\(\
\[Prime]\[Prime]\\), MultilineFunction->None]\\)[x] \[Equal] 0, y, {x, \
\[Pi]\\/8, 2 \[Pi]}}\\)\"\>", ",", "\<\"\\!\\({}\\)\"\>", ",", 
              TagBox[
                TagBox[GridBox[{
                      {
                        InterpretationBox[
                          StyleBox[
                            RowBox[{"TrekData", "[", 
                              
                              RowBox[{"\<\"\\!\\({y[0.`] \[Equal] \
\\(-0.09499999999999997`\\),  \\(\\*SuperscriptBox[\\(y\\),  \\(\[Prime]\\), \
MultilineFunction->None]\\)[0.`] \[Equal] \
\\(-0.09499999999999997`\\)}\\)\"\>", ",", " ", "\<\"<>\"\>"}], "]"}],
                            FontColor->RGBColor[1, 0.976471, 0]],
                          TrekData[ {
                            Equal[ 
                              y[ 0.`], -0.09499999999999997`], 
                            Equal[ 
                              Derivative[ 1][ y][ 
                              0.`], -0.09499999999999997`]}, \
{-0.09499999999999997`, -0.09499999999999997`}, {0.`, {0.39269908169872414`, 
                            6.283185307179586`}}, {
                            RGBColor[ 1.`, 0.9764705896377563`, 0.`], 
                            "Line"}]]},
                      {
                        InterpretationBox[
                          StyleBox[
                            RowBox[{"TrekData", "[", 
                              
                              RowBox[{"\<\"\\!\\({y[0.`] \[Equal] 0.48`,  \\(\
\\*SuperscriptBox[\\(y\\),  \\(\[Prime]\\), MultilineFunction->None]\\)[0.`] \
\[Equal] 0.46499999999999997`}\\)\"\>", ",", " ", "\<\"<>\"\>"}], "]"}],
                            FontColor->RGBColor[1, 0, 0.439216]],
                          TrekData[ {
                            Equal[ 
                              y[ 0.`], 0.48`], 
                            Equal[ 
                              Derivative[ 1][ y][ 0.`], 
                              0.46499999999999997`]}, {0.48`, 
                            0.46499999999999997`}, {0.`, {
                            0.39269908169872414`, 6.283185307179586`}}, {
                            RGBColor[ 1.`, 0.`, 0.43921568989753723`], 
                            "Line"}]]},
                      {
                        InterpretationBox[
                          StyleBox[
                            RowBox[{"TrekData", "[", 
                              
                              RowBox[{"\<\"\\!\\({y[0.`] \[Equal] \
\\(-0.765`\\),  \\(\\*SuperscriptBox[\\(y\\),  \\(\[Prime]\\), \
MultilineFunction->None]\\)[0.`] \[Equal] 0.6699999999999999`}\\)\"\>", ",", 
                                " ", "\<\"<>\"\>"}], "]"}],
                            FontColor->RGBColor[0, 0.219608, 1]],
                          TrekData[ {
                            Equal[ 
                              y[ 0.`], -0.765`], 
                            Equal[ 
                              Derivative[ 1][ y][ 0.`], 
                              0.6699999999999999`]}, {-0.765`, 
                            0.6699999999999999`}, {0.`, {0.39269908169872414`,
                             6.283185307179586`}}, {
                            RGBColor[ 0.`, 0.21960784494876862`, 1.`], 
                            "Line"}]]}
                      },
                    RowSpacings->1,
                    ColumnAlignments->{Left}],
                  Column],
                Function[ BoxForm`e$, 
                  MatrixForm[ BoxForm`e$]]], ",", "\<\" <>\"\>"}], "]"}],
          EquationTrekkerState[ {
            Equal[ 
              Plus[ 
                y[ x], 
                Derivative[ 2][ y][ x]], 0], y, {x, 
            Times[ 
              Rational[ 1, 8], Pi], 
            Times[ 2, Pi]}}, {}, {
            TrekData[ {
              Equal[ 
                y[ 0.0], -.094999999999999973], 
              Equal[ 
                Derivative[ 1][ y][ 
                
                0.0], -.094999999999999973]}, {-.094999999999999973, \
-.094999999999999973}, {0.0, {.39269908169872414, 6.2831853071795862}}, {
              RGBColor[ 1.0, .97647058963775635, 0.0], "Line"}], 
            TrekData[ {
              Equal[ 
                y[ 0.0], .47999999999999998], 
              Equal[ 
                Derivative[ 1][ y][ 
                0.0], .46499999999999997]}, {.47999999999999998, \
.46499999999999997}, {0.0, {.39269908169872414, 6.2831853071795862}}, {
              RGBColor[ 1.0, 0.0, .43921568989753723], "Line"}], 
            TrekData[ {
              Equal[ 
                y[ 0.0], -.76500000000000001], 
              Equal[ 
                Derivative[ 1][ y][ 
                0.0], .66999999999999993]}, {-.76500000000000001, \
.66999999999999993}, {0.0, {.39269908169872414, 6.2831853071795862}}, {
              RGBColor[ 0.0, .21960784494876862, 1.0], "Line"}]}, {
            TrekParameters -> {}, PlotRange -> {{-1.0, 1.0}, {-1.0, 1.0}}, 
            "CanvasSize" -> {400, 400}}]], ",", 
        TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
          False,
          Editable->False]}], "}"}]], "Output",
  CellLabel->"Out[3]=",
  CellTags->"EquationTrekker"]
}, Open  ]],

Cell["\<\
To get the result shown just above, once the window was opened, the delete \
key was pressed, deleting the selected trek, and then the window was closed, \
generating a new state.  \
\>", "Text",
  CellTags->"EquationTrekker"],

Cell["\<\
Because of the need to choose conditions in two dimensions, the \
EquationTrekker is limited to one or two first order equations or a single \
second order equation.  A system of two first order equations looks very much \
like the example above; in fact second order equations are converted to first \
order equations.  A single first order equation is somewhat different in that \
when you click on a point, you are in effect choosing the starting value of \
the independent variable, whereas with two equations, the value of the \
independent variable is taken to be zero (this can be modified through the \
graphical interface).  For example, when the EquationTrekker is invoked \
with\
\>", "Text",
  CellTags->"EquationTrekker"],

Cell[BoxData[
    \(EquationTrekker[\(z'\)[t]\ \[NonBreakingSpace] + 
          1/\((15\ z[t]^2\ \[NonBreakingSpace] - \ 
                t)\)\ \[NonBreakingSpace] \[Equal] 0, \ 
      z, \ {t, 0, 10}]\)], "Input",
  CellLabel->"In[22]:=",
  CellTags->"EquationTrekker"],

Cell["\<\
a window looking like the screen shot below can be generated.\
\>", "Text",
  CellTags->"EquationTrekker"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008g0001cb000`400?l0
0000o`00003oo`3ooooo0?ooocT0oooo00000`1VIWh0nocm0?_lo@3o0?_l
oOl0nocm=@3ko?d10?ooo`0000<0IVIn0?_lo@2XZK/0o`2XZK_o0:RY^c@0
Z:Vk0@3ko?d10?ooo`0000<0IVIn0?_lo@2XZK/0o`1VIWko06IVOS<0IVIn
0@2XZK/10?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT0?l0lNoR
TP3akn830>3Oh`03075_I03akn80lNoR09L0lNoR00<0IVIn0:RY^`3ko?d0
0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0SP3oool00`3o_K/0ogml
0?ne/`0_0?ooo`040>koa`3Cof`0g_nC0?Wojbl0oooo00<0fOnc0;SoL03S
olL0A`3oool00`3knol0L7So0<_>o`0g0?ooo`0308ooH037ojl0oooo01H0
oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I02H0>3Oh`040?7_hP1VIWh0Z:Vk
0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT08`0oooo00<0ojf[
0?m_K03o/Jl0;`3oool0103ion/0e?m`0=goS`3noo/_0?ooo`030=GoZ`2b
of@0fong04P0oooo00<0no_o08nEo`3cm?l0=`3oool00`3:ok<0a?n[0?oo
o`0G0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@0V03Pgn<0103akn80IVIn
0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I0290?ooo`04
0?oXi`3oTXl0ofm/0?o1_c00oooo00<0h?nG0=?oK03honL0;`3oool00`3K
okL0_omo0=Wo/`180?ooo`040=oQo`2;TOl0OhKo0??docL0oooo00<0b_nc
09;oI03loo/0603oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oSU03o
ool20>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY
^`1VIWh0LFmT08H0oooo00D0ooOg0?na[`3oKf`0oh9o0?oHe`0`0?ooo`03
0>KoZ`3@of@0kOo302l0oooo00<0ioo?0;;oI03Gojl0B@3oool00`1XL?l0
Qhko0=oQo`0g0?ooo`040?con`2Mog@0a?n[0?conaT0oooo00D0lNoR0>3O
h`3Pgn<0h=oS075_I0020>3Ohi<0W9bN00L0oooo0>3Oh`3Pgn<0lNoR06IV
OP2XZK/0nocm0040oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT08@0oooo
00D0om3?0?mkN03oLg00okVg0?okn`0`0?ooo`030>Wo]`3Hogl0j?nc02l0
oooo00@0oOok0<?oQ`31oh<0oOokB@3oool00`2g^ol0^koo0?ooo`0g0?oo
o`030?con`2`ohl0mooc01/0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I002
0>3Oh`0309bLWP3oool0h=oS08l0h=oS00P0W9bN0?ooo`3Pgn<0h=oS0?7_
hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT00D0
oooo00<0WinO0?ooo`3oool0NP3oool0103o[J/0ofAP0?nIU`3oknla0?oo
o`030>So/`3Dog00k_o70300oooo00<0fOnc0;;oI03Woll0BP3oool00`2c
]ol0I6go0?ooo`0g0?ooo`030?con`2`ohl0mooc01`0oooo00D0lNoR0>3O
h`3Pgn<0h=oS075_I0020>3Oh`0309bLWP3oool0h=oS08l0h=oS00P0W9bN
0?ooo`3Pgn<0h=oS0?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm
0:RY^`1VIWh0LFmT00D0oooo00<0Ogmo0?ooo`3oool0N03oool00`3o^KL0
ofm/0?nm^`0b0?ooo`030>koa`3?of00jOng0300oooo00@0fOnc0;;oI03E
oj/0oOokB@3oool0103knol0M7co0:^`o`3knolg0?ooo`030?con`2`ohl0
mooc01d0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0309bLWP3o
ool0h=oS01P0h=oSH@2U[;801@3Qh>@0i^GX0>c[kP3`l?80l_;d00D0lo?d
0`3hmoP20??cm0050??cm@3dm?D0mOGf0?Ccm@3Ui>P00P3Pgn<0202LW9h0
oooo0>3Oh`3Pgn<0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0
Z:Vk06IVOP1aKf@01@3oool00`1oOgl0oooo0?ooo`1f0?ooo`030?nm^`3o
Og`0olC30380oooo00@0nOo[0=CoL03Mohl0o_ok;`3oool0103kooL0^_md
0=GoZ`3moo]:0?ooo`030?_ko`2?UOl0loCo03T0oooo00<0X?mh0?Ool`3o
ool07@3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00<0W9bN0?oo
o`3Pgn<0603Pgn<00`2U[;80oooo0?ooo`1M0?ooo`050:F//P3Ng=l0i>;P
07^G[@0UEhD03000?7@0100GCGh0Jh^V0?;akP3blO<20>3Oh`0809bLWP3o
ool0h=oS0>3Oh`3akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2X
ZK/0IVIn075_I0050?ooo`0307moO`3oool0oooo07@0oooo00<0ojf[0?mc
L03o^KL0<`3oool00`3PoiL0dom/0?Soi`0`0?ooo`030?gon`37ohl0noog
04/0oooo00<0/kOo07b3o`3cm?l0>@3oool00`3:ok<0a?n[0?ooo`0N0?oo
o`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<00`2LW9h0oooo0>3Oh`0H
0>3Oh`030:F//P3oool0oooo05d0oooo00D0YJbb0=[Hf@1VQJ40BW6C0;:m
``0<000000040<36a@18KY00JXZT0>o_l@80h=oS00P0W9bN0?ooo`3Pgn<0
h=oS0?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0
LFmT00D0oooo00<0Ogmo0?ooo`3oool0L@3oool0103oh=l0ohj;0?m_K03o
]K<c0?ooo`030>So/`3@of@0kOo30340oooo00<0noog0<OoS`3ioo<0BP3o
ool0103knol0M7co0:^`o`3knoli0?ooo`030<[o/`2Bof@0o?ok01l0oooo
00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0309bLWP3oool0h=oS01P0
h=oS00<0YJbb0?ooo`3oool0G@3oool01@2U[;80f=GF01M=OP2oalX0a/GG
00`0000000@0a/GG0;Jm_@0GCGh0jn[]0P3Pgn<0202LW9h0oooo0>3Oh`3P
gn<0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1a
Kf@01@3oool00`1oOgl0oooo0?ooo`1^0?ooo`050?oPg`3oSX/0ofm/0?n:
Q`3oh=l0<`3oool0103Xok<0d?mT0>KoZ`3noo/a0?ooo`030=Wo/`2nog`0
noog04X0oooo00<0no_o08nEo`3cm?l0>P3oool00`2EofP0a?n[0?con`0P
0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<00`2LW9h0oooo0>3O
h`060>3Oh`L0000000<0h=oS0000000000000P0000000`3Pgn<000000000
00030>3Oh`030:F//P3oool0oooo05d0oooo00@0YJbb0=WEe@00?7@0oooo
1P3=c=l2000000H0cLcO00<0oooo000lM03XinX00P3Pgn<0202LW9h0oooo
0>3Oh`3Pgn<0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk
06IVOP1aKf@01@3oool00`1oOgl0oooo0?ooo`1/0?ooo`040?o8a`3oJ6@0
ohZ70?oPgc<0oooo00D0nooc0>;oW`3@of@0i_n[0?kon`0a0?ooo`040=Wo
/`2bof@0eOn[0?gondX0oooo00<0_l?o07b3o`3cm?l0>P3oool00`3loo/0
YOmo0?ooo`0Q0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<00`2L
W9h0oooo0>3Oh`070>3Oh`0=0000003Pgn<000000>3Oh`000000h=oS0000
003Pgn<000000>3Oh`000000h=oS000000040>3Oh`030:F//P3oool0oooo
05d0oooo00@0YJbb0=WEe@00?7@0oooo1@3BdN@4000000D0d]7T00<0oooo
000lM03Wi^T00P3Pgn<0202LW9h0oooo0>3Oh`3Pgn<0lNoR06IVOP2XZK/0
nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@01@3oool00`1oOgl0
oooo0?ooo`1Z0?ooo`040?o[j`3oLg00oi:?0?oknc<0oooo00@0lOo?0=Go
M03Cof`0koo;<P3oool0103_oml0/_mT0=GoZ`3moo];0?ooo`0306A]o`2c
]ol0no_o03X0oooo00<0o?ok0;3oS`3goo<08P3oool01@3akn80h=oS0>3O
h`3Pgn<0LFmT0080h=oS00<0W9bN0?ooo`3Pgn<00`3Pgn<200000080h=oS
00T000000>3Oh`000000h=oS0000003Pgn<000000>3Oh`0000000P3Pgn<0
0`000000h=oS0>3Oh`030>3Oh`030:F//P3oool0oooo04h0oooo00<00000
0?ooo`3oool00P3oool3000000L0oooo00@0YJbb0=WEe@00?7@0oooo103F
enL6000000@0e]OW00<0oooo000lM03Wi^T00P3Pgn<0202LW9h0oooo0>3O
h`3Pgn<0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IV
OP1aKf@01@3oool00`1oOgl0oooo0?ooo`1Y0?ooo`030?nIU`3oKf`0onSW
03<0oooo00@0mooS0=3oI03PoiL0nooc<`3oool00`3?oil0bOnC0?gon`1<
0?ooo`030;>go`2[/?l0oooo03X0oooo00<0o?ok0;3oS`3goo<08`3oool0
1@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00<0W9bN0?ooo`3Pgn<00`3P
gn<02@000000h=oS0>3Oh`3Pgn<000000>3Oh`000000h=oS000000020>3O
h`80000000@0h=oS0000003Pgn<00000103Pgn<00`2U[;80oooo0?ooo`1>
0?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?oo
o`040?ooo`040:F//P3IeMD003ad0?ooo`<0fM[W200000030=WJi`030?oo
o`00?7@0inKY0080h=oS00P0W9bN0?ooo`3Pgn<0h=oS0?7_hP1VIWh0Z:Vk
0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT00D0oooo00<0Ogmo
0?ooo`3oool0I`3oool00`3o]K<0ofQT0?o4``0d0?ooo`030>go``3Mohl0
o_ok03<0oooo00<0fOnc0;CoJ03Woll0C@3oool00`2c]ol0I6go0?_ko`0j
0?ooo`030?con`2`ohl0mooc02@0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_
I0020>3Oh`0309bLWP3oool0h=oS00<0h=oS00<000000>3Oh`3Pgn<01@00
00020>3Oh`80000000@0h=oS000000000000h=oS0P0000030>3Oh`030:F/
/P3oool0oooo04h0oooo00D000000?ooo`3oool0oooo000000030?ooo`03
0000003oool0oooo00@0oooo00@0YJbb0=WEe@00?7@0oooo1P3If^L20000
00H0fM[W00<0oooo000lM03Wi^T00P3Pgn<0202LW9h0oooo0>3Oh`3Pgn<0
lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0
1@3oool00`1oOgl0oooo0?ooo`1U0?ooo`040?ne/`3oJ6@0ojf[0?oknc<0
oooo00<0oOog0=OoO03YokL0<`3oool0103Woll0/?mP0=GoZ`3moo]<0?oo
o`040?_ko`1dO?l0Zk3o0?_kocX0oooo00<0o?ok0;3oS`3goo<09@3oool0
1@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00<0W9bN0?ooo`3Pgn<0103P
gn<00`000000h=oS0>3Oh`0A0>3Oh`030:F//P3oool0oooo04h0oooo00D0
00000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo00@0oooo
00@0YJbb0=WEe@00?7@0oooo1P3SiO02000000H0hnG`00<0oooo000lM03W
i^T00P3Pgn<0202LW9h0oooo0>3Oh`3Pgn<0lNoR06IVOP2XZK/0nocm0@3o
ool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@01@3oool00`1oOgl0oooo0?oo
o`1S0?ooo`040?ne/`3oJ6@0ojf[0?oknc@0oooo00<0j?nc0=3oI03eoml0
<P3oool0103moo/0`on70<7oP`3moo]=0?ooo`030?_ko`2?UOl0loCo03`0
oooo00<0Z?n30?Ool`3oool09@3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT
0080h=oS00<0W9bN0?ooo`3Pgn<0103Pgn<00`000000h=oS0>3Oh`0A0>3O
h`030:F//P3oool0oooo04h0oooo00D000000?ooo`3oool0oooo00000003
0?ooo`030000003oool0oooo00@0oooo00@0YJbb0=WEe@00?7@0oooo1P3`
lO`2000000H0l?7l00<0oooo000lM03Wi^T00P3Pgn<0202LW9h0oooo0>3O
h`3Pgn<0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IV
OP1aKf@01@3oool00`1oOgl0oooo0?ooo`1Q0?ooo`040?ne/`3oJ6@0ojf[
0?oknc@0oooo00@0j?nc0=3oI03Voj/0o_ok<P3oool00`3Woll0/?mP0>Oo
c`1>0?ooo`030?_ko`2?UOl0loCo03`0oooo0P2Kog0W0?ooo`050?7_hP3P
gn<0h=oS0>3Oh`1aKf@00P3Pgn<00`2LW9h0oooo0>3Oh`030>3Oh`<00000
4P3Pgn<00`2U[;80oooo0?ooo`1<0?ooo`030000003oool0000000<0oooo
00D000000?ooo`3oool0oooo000000060?ooo`040:F//P3IeMD003ad0?oo
o`H0m_Om0P0000060?Kgo@030?ooo`00?7@0inKY0080h=oS00P0W9bN0?oo
o`3Pgn<0h=oS0?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY
^`1VIWh0LFmT00D0oooo00<0Ogmo0?ooo`3oool0G`3oool0103o]K<0ofQT
0?n]Z`3ono/d0?ooo`040?Cof`3?of00i_n[0?konc80oooo00@0oOok0<?o
Q`31oh<0oOokCP3oool00`3knol0SiGo0??do`0l0?ooo`030?con`2Uogl0
oooo02L0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0309bLWP3o
ool0h=oS00@0h=oS00<000000>3Oh`3Pgn<04@3Pgn<00`2U[;80oooo0?oo
o`1=0?ooo`8000000`3oool01@000000oooo0?ooo`3oool0000000H0oooo
00@0YJbb0=WEe@00?7@0oooo1P3ho?d2000000H0n?cm00<0oooo000lM03W
i^T00P3Pgn<0202LW9h0oooo0>3Oh`3Pgn<0lNoR06IVOP2XZK/0nocm0@3o
ool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@01@3oool00`1oOgl0oooo0?oo
o`1M0?ooo`040?ne/`3oJ6@0ojf[0?okncD0oooo00<0i_n[0=GoM03koo<0
<`3oool00`3Woll0/?mP0>Ooc`1?0?ooo`030?_ko`2?UOl0loCo03`0oooo
00<0o?ok0;3oS`3goo<0:03oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080
h=oS00<0W9bN0?ooo`3Pgn<01@3Pgn<00`000000h=oS0>3Oh`0@0>3Oh`03
0:F//P3oool0oooo04h0oooo00<000000?ooo`3oool00P3oool3000000L0
oooo00@0YJbb0=WEe@00?7@0oooo1P3moOd2000000H0oOgm00<0oooo000l
M03Wi^T00P3Pgn<0202LW9h0oooo0>3Oh`3Pgn<0lNoR06IVOP2XZK/0nocm
0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@01@3oool00`1oOgl0oooo
0?ooo`1K0?ooo`040?n]Z`3oK6P0ojf[0?okncD0oooo00<0o_ok0=KoN03T
ojL0<`3oool0103moo/0`on70<7oP`3moo]?0?ooo`030?_ko`2?UOl0loCo
03d0oooo00<0Z?n30?Ool`3oool0:03oool01@3akn80h=oS0>3Oh`3Pgn<0
LFmT0080h=oS00<0W9bN0?ooo`3Pgn<0603Pgn<00`2U[;80oooo0?ooo`1M
0?ooo`040:F//P3IeMD003ad0?ooo`H0oOgm0P0000060?gmo@030?ooo`00
?7@0i^KY0080h=oS00P0W9bN0?ooo`3Pgn<0h=oS0?7_hP1VIWh0Z:Vk0?_l
o@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT00D0oooo00<0Ogmo0?oo
o`3oool0F@3oool00`3o]K<0og=`0?nm^`0f0?ooo`040?_ol`3Roil0d?mT
0??oec<0oooo00<0oOok0;[oM03Woll0D03oool00`3knol0SiGo0??do`0m
0?ooo`030?con`2Uogl0oooo02T0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_
I0020>3Oh`0309bLWP3oool0h=oS01P0h=oS00<0YJbb0?ooo`3oool0G@3o
ool0102U[;80f=CD000lM03oool60?gmo@8000001P3moOd00`3oool003ad
0>GUj0020>3Oh`0809bLWP3oool0h=oS0>3Oh`3akn80IVIn0:RY^`3ko?d1
0?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I0050?ooo`0307moO`3oool0
oooo05L0oooo00<0okfk0?mkN03o`Kl0=P3oool0103aoll0eOmd0=?oK03_
ol/d0?ooo`030?gon`37ohl0nOoc0500oooo00<0no_o08nEo`3cm?l0?@3o
ool00`3loo/0Z?n30?Ool`0Z0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@0
0P3Pgn<00`2LW9h0oooo0>3Oh`0H0>3Oh`030:F//P3oool0oooo05d0oooo
00@0YJbb0=WEe@0UEhD0_lkL1P3oool2000000H0oooo00<0_lkK02EGQ@3Q
hN@00P3Pgn<0202LW9h0oooo0>3Oh`3Pgn<0lNoR06IVOP2XZK/0nocm0@3o
ool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@01@3oool00`1oOgl0oooo0?oo
o`1E0?ooo`030?o8a`3oJ6@0ok6_03H0oooo00@0lOo?0<ooH03PoiL0nooc
=@3oool00`3moo/0aon?0?Wol`1@0?ooo`030?_ko`2?UOl0loCo03h0oooo
00<0Z?n30?Ool`3oool0:P3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080
h=oS00<0W9bN0?ooo`3Pgn<0603Pgn<00`2U[;80oooo0?ooo`1M0?ooo`05
0:F//P3IeMD0NIBY05EmXP30cmd01@3oool2000000D0oooo00@0eMoX05Em
XP1iUJ/0gmgP0P3Pgn<0202LW9h0oooo0>3Oh`3Pgn<0lNoR06IVOP2XZK/0
nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@01@3oool00`1oOgl0
oooo0?ooo`1C0?ooo`040?o[j`3oLg00oi:?0?okncD0oooo00@0o_ok0=_o
Q`3Joh<0o_ok=P3oool00`3moo/0aon?0?Wol`1A0?ooo`0307Qoo`3cm?l0
oooo03d0oooo00<0o?ok09_oL03oool0:`3oool01@3akn80h=oS0>3Oh`3P
gn<0LFmT0080h=oS00<0W9bN0?ooo`3Pgn<0603Pgn<00`2U[;80oooo0?oo
o`1M0?ooo`050:F//P3JemT0gmcH07VDZ@0UEhD03000?7@0100GCGh0IXJQ
0>3NfP3Lfmd20>3Oh`0809bLWP3oool0h=oS0>3Oh`3akn80IVIn0:RY^`3k
o?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I0050?ooo`0307moO`3o
ool0oooo0580oooo00<0oiVG0?m_K03oj>L0=P3oool00`3aoll0comP0?7o
c`0g0?ooo`030=Wo/`2nog`0nOoc0540oooo00<0/kOo0:^`o`3oool0?P3o
ool00`2Xoh<0mooc0?ooo`0[0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@0
0P3Pgn<00`2LW9h0oooo0>3Oh`0H0>3Ohf40YJbb00<0gmgP0=[Gf@3He=@0
1`3Gdm@30=?>c0<0em?D00@0f=CD0=WEe@3JemT0gmgP0P3Pgn<0202LW9h0
oooo0>3Oh`3Pgn<0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0
Z:Vk06IVOP1aKf@01@3oool00`1oOgl0oooo0?ooo`1@0?ooo`030?n]Z`3o
J6@0olC303H0oooo00@0o_ok0=_oQ`3Joh<0o_ok=P3oool0103moo/0^_md
0=GoZ`3moo]A0?ooo`030?_ko`1hOol0no_o03h0oooo0P2Kog0]0?ooo`05
0?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<00`2LW9h0oooo0>3Oh`2?0>3O
h`0809bLWP3oool0h=oS0>3Oh`3akn80IVIn0:RY^`3ko?d10?ooo`0000D0
IVIn0?_lo@2XZK/0IVIn075_I0050?ooo`0307moO`3oool0oooo04h0oooo
00<0okVg0?n2O`3o]K<0=`3oool00`3mooL0eOmd0?7oc`0g0?ooo`030?go
n`37ohl0nOoc0580oooo00<0no_o08nEo`3cm?l0?`3oool00`2Uogl0oooo
0?ooo`0/0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<00`2LW9h0
oooo0>3Oh`2?0>3Oh`0809bLWP3oool0h=oS0>3Oh`3akn80IVIn0:RY^`3k
o?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I0050?ooo`0307moO`3o
ool0oooo04/0oooo00@0on3O0?n>R`3oKf`0ok6_>03oool00`3noo/0gOn?
0?gom`0g0?ooo`030>Ooc`2logP0nOoc0580oooo00<0no_o08nEo`3cm?l0
?`3oool209_oL2h0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`03
09bLWP3oool0h=oS08l0h=oS00P0W9bN0?ooo`3Pgn<0h=oS0?7_hP1VIWh0
Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT00D0oooo00<0
Ogmo0?ooo`3oool0B@3oool0103od<l0ofQT0?n:Q`3oh=li0?ooo`030?go
m`3Mohl0nooc03H0oooo00@0oOok0<?oQ`31oh<0oOokDP3oool00`3knol0
SiGo0??do`100?ooo`030:GoO`3oool0oooo02d0oooo00D0lNoR0>3Oh`3P
gn<0h=oS075_I0020>3Oh`0309bLWP3oool0h=oS08l0h=oS00P0W9bN0?oo
o`3Pgn<0h=oS0?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY
^`1VIWh0LFmT00D0oooo00<0Ogmo0?ooo`3oool0A`3oool0103ono/0ohZ7
0?n6P`3ono/j0?ooo`030>So/`3Gog`0oOog03H0oooo00<0fOnc0;;oI03W
oll0D`3oool00`3knol0SiGo0??do`100?ooo`030?con`2Kog00oooo02h0
oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0309bLWP3oool0h=oS
01P0h=oSH@2U[;801@3Qh>@0i^GX0>c[kP3`l?80l_;d00D0lo?d0`3hmoP2
0??cm0050??cm@3dm?D0mOGf0?Ccm@3Ui>P00P3Pgn<0202LW9h0oooo0>3O
h`3Pgn<0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IV
OP1aKf@01@3oool00`1oOgl0oooo0?ooo`160?ooo`030?ne/`3oJ6@0om3?
03X0oooo00@0j?nc0=3oI03Voj/0o_ok=@3oool0103moo/0^_md0=GoZ`3m
oo]D0?ooo`0308>:o`3cm?l0oooo0400oooo00<0WOmd0?Ool`3oool0;P3o
ool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00<0W9bN0?ooo`3Pgn<0
603Pgn<00`2U[;80oooo0?ooo`1M0?ooo`050:F//P3Ng=l0i>;P07^G[@0U
EhD03000?7@0100GCGh0Jh^V0?;akP3blO<20>3Oh`0809bLWP3oool0h=oS
0>3Oh`3akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn
075_I0050?ooo`0307moO`3oool0oooo04@0oooo00@0okFc0?mXI03o[J/0
oo_k>@3oool0103aoll0comP0>KoZ`3noo/f0?ooo`030?gon`37ohl0nOoc
05D0oooo00<0no_o07n6o`3oool0@@3oool00`2?of00oooo0?ooo`0^0?oo
o`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<00`2LW9h0oooo0>3Oh`0H
0>3Oh`030:F//P3oool0oooo05d0oooo00D0YJbb0=[Hf@1VQJ40BW6C0;:m
``0<000000040<36a@18KY00JXZT0>o_l@80h=oS00P0W9bN0?ooo`3Pgn<0
h=oS0?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0
LFmT00D0oooo00<0Ogmo0?ooo`3oool0@P3oool0103od<l0ofAP0?n]Z`3o
no/i0?ooo`040?kon`3KohL0f_n30?koncL0oooo00<0oOok0<OoS`3ioo<0
E@3oool00`3knol0SiGo0??do`110?ooo`80Vom`<03oool01@3akn80h=oS
0>3Oh`3Pgn<0LFmT0080h=oS00<0W9bN0?ooo`3Pgn<01P3Pgn<<00000003
0>3Oh`000000000000<0h=oS00<0YJbb0?ooo`3oool0G@3oool01@2U[;80
f=GF01M=OP2oalX0a/GG00`0000000@0a/GG0;Jm_@0GCGh0jn[]0P3Pgn<0
202LW9h0oooo0>3Oh`3Pgn<0lNoR06IVOP2XZK/0nocm0@3oool0000506IV
OP3ko?d0Z:Vk06IVOP1aKf@01@3oool00`1oOgl0oooo0?ooo`100?ooo`04
0?okn`3oRXL0ohJ30?okncX0oooo00<0lOo?0<ooH03aoll0>03oool00`3i
oo<0`on70?Wol`1E0?ooo`030?_ko`23R_l0loCo0480oooo00<0SomP0?oo
o`3oool0;`3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00<0W9bN
0?ooo`3Pgn<01`3Pgn<01@000000h=oS0000003Pgn<000000080h=oS00<0
00000>3Oh`0000000P3Pgn<00`000000h=oS0>3Oh`020>3Oh`030:F//P3o
ool0oooo05d0oooo00@0YJbb0=WEe@00?7@0oooo1P3=c=l2000000H0cLcO
00<0oooo000lM03XinX00P3Pgn<0202LW9h0oooo0>3Oh`3Pgn<0lNoR06IV
OP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@01@3oool0
0`1oOgl0oooo0?ooo`0o0?ooo`030?ne/`3oJ6@0om3?03X0oooo00@0oOog
0=[oP`3Noi<0o_ok>03oool00`3ioo<0^_md0?Ook`1F0?ooo`0308>:o`3c
m?l0oooo0480oooo00<0SomP0?ooo`3oool0;`3oool01@3akn80h=oS0>3O
h`3Pgn<0LFmT0080h=oS00<0W9bN0?ooo`3Pgn<00`3Pgn<200000080h=oS
00D000000>3Oh`000000h=oS000000020>3Oh`030000003Pgn<000000080
h=oS00<000000>3Oh`3Pgn<00P3Pgn<00`2U[;80oooo0?ooo`1M0?ooo`04
0:F//P3IeMD003ad0?ooo`D0d]7T100000050=;Ai0030?ooo`00?7@0inKY
0080h=oS00P0W9bN0?ooo`3Pgn<0h=oS0?7_hP1VIWh0Z:Vk0?_lo@40oooo
00001@1VIWh0nocm0:RY^`1VIWh0LFmT00D0oooo00<0Ogmo0?ooo`3oool0
?@3oool0103ono/0ogMd0?n]Z`3ono/j0?ooo`030??oe`3?of00koo;03T0
oooo00<0oOok0<GoR`3kooL0EP3oool00`3knol0OhKo0?ooo`120?ooo`80
Vom`<@3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00<0W9bN0?oo
o`3Pgn<00`3Pgn<02@000000h=oS0>3Oh`3Pgn<000000>3Oh`000000h=oS
000000020>3Oh`060000003Pgn<000000000003Pgn<00000103Pgn<00`2U
[;80oooo0?ooo`1C0?ooo`<000001`3oool0102U[;80fMGE000lM03oool4
0=KGi`H00000103FenL00`3oool003ad0>OVj@020>3Oh`0809bLWP3oool0
h=oS0>3Oh`3akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0
IVIn075_I0050?ooo`0307moO`3oool0oooo03`0oooo00<0okFc0?moO03o
lo<0>P3oool0103noo/0f_n30=[oP`3noo/i0?ooo`030?Wol`31oh<0nOoc
05L0oooo00<0Ph[o0??do`3oool0@P3oool00`2?of00oooo0?ooo`0`0?oo
o`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<00`2LW9h0oooo0>3Oh`03
0>3Oh`030000003Pgn<0h=oS00D000000P3Pgn<4000000030>3Oh`000000
h=oS00@0h=oS00<0YJbb0?ooo`3oool0DP3oool01@000000oooo0?ooo`3o
ool0000000H0oooo00@0YJbb0=WEe@00?7@0oooo0`3If^L8000000<0fM[W
00<0oooo000lM03Wi^T00P3Pgn<0202LW9h0oooo0>3Oh`3Pgn<0lNoR06IV
OP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@01@3oool0
0`1oOgl0oooo0?ooo`0j0?ooo`040?okn`3oMg@0ojf[0?okncX0oooo00<0
o_ok0=GoM03dom/0>P3oool00`3kooL0^_md0?Ook`1G0?ooo`80L7SoA03o
ool00`2?of00oooo0?ooo`0`0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@0
0P3Pgn<00`2LW9h0oooo0>3Oh`040>3Oh`030000003Pgn<0h=oS0140h=oS
00<0YJbb0?ooo`3oool0DP3oool01@000000oooo0?ooo`3oool0000000H0
oooo00@0YJbb0=WEe@00?7@0oooo1P3If^L2000000H0fM[W00<0oooo000l
M03Wi^T00P3Pgn<0202LW9h0oooo0>3Oh`3Pgn<0lNoR06IVOP2XZK/0nocm
0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@01@3oool00`1oOgl0oooo
0?ooo`0c0?ooo`090?okn`3oNgP0oa8<0?l>203oLg00oo?c0?ne/`3oOg`0
oo?c03/0oooo00<0o_ok0=goS`3koo<0>P3oool00`3Iok<0_?mh0?Ook`1D
0?ooo`060?_ko`1hOol031Wo00PFo`0a?Ol0loCoA03oool00`2?of00oooo
0?ooo`0`0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<00`2LW9h0
oooo0>3Oh`040>3Oh`030000003Pgn<0h=oS00L0h=oS00<000000>3Oh`3P
gn<01`3Pgn<00`2U[;80oooo0?ooo`1B0?ooo`050000003oool0oooo0?oo
o`0000001P3oool0102U[;80fMGE000lM03oool60>?Ul08000001P3SiO00
0`3oool003ad0>OVj@020>3Oh`0809bLWP3oool0h=oS0>3Oh`3akn80IVIn
0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I0050?ooo`03
07moO`3oool0oooo00D0oooo00h0lo?c04A4A014A4@0<30`0;>c/`3oool0
Zj^[05QHF03oool0hn?S03`l?010@400=3@d09NGUb00oooo00<0og]h0?l6
003o1P000P3o1P000`3o<Rh0ojf[0?okn`0k0?ooo`030?7oc`3FogP0nooc
03X0oooo00<0[_mL0=GoZ`3moo/0E@3oool00`1hOol000ko000>o`02000>
o`03071ho`3oool0oooo0440oooo0P2Kog0b0?ooo`050?7_hP3Pgn<0h=oS
0>3Oh`1aKf@00P3Pgn<00`2LW9h0oooo0>3Oh`030>3Oh`<000004P3Pgn<0
0`2U[;80oooo0?ooo`1B0?ooo`050000003oool0oooo0?ooo`0000001P3o
ool0102U[;80fMGE000lM03oool60?3ao08000001P3`lO`00`3oool003ad
0>OVj@020>3Oh`0809bLWP3oool0h=oS0>3Oh`3akn80IVIn0:RY^`3ko?d1
0?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I0050?ooo`0307moO`3oool0
oooo00D0oooo00l0O7al071`L03oool0emOG01`L703kno/0inOW0<o?c`3o
ool0D51@0:>SX`3oool0kno_020P803Kfm/07`3oool00`3o4P`0o`H00?l6
00020?l600030?l=1`3oool0oooo03T0oooo00@0o_ok0=_oQ`3Joh<0o_ok
>P3oool00`3Iok<0eOn[0?ooo`1F0?ooo`0300`Io`003_l000ko008000ko
00<021Ko0?ooo`3oool0@@3oool00`2?of00oooo0?ooo`0a0?ooo`050?7_
hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<00`2LW9h0oooo0>3Oh`040>3Oh`03
0000003Pgn<0h=oS0140h=oS00<0YJbb0?ooo`3oool0DP3oool01@000000
oooo0?ooo`3oool0000000H0oooo00@0YJbb0=WEe@00?7@0oooo1P3fmod2
000000H0m_Om00<0oooo000lM03Wi^T00P3Pgn<0202LW9h0oooo0>3Oh`3P
gn<0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1a
Kf@01@3oool0101oOgl0oooo0?ooo`3oool307moO`030?ooo`10@400]kNg
0080oooo00<0820P0<o?c`3oool00P3oool01P0P8200gmoO0?ooo`3oool0
@4100;no_al0oooo00<0oa8<0?l6003o1P000P3o1P000`3o3PP0oooo0?oo
o`0h0?ooo`030?kon`3Eog@0lOo?03/0oooo00<0oOok0;coN03moo/0E`3o
ool00`0<6Ol000ko000>o`02000>o`0300PFo`3oool0oooo0440oooo00<0
SomP0?ooo`3oool0<@3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS
00<0W9bN0?ooo`3Pgn<01@3Pgn<00`000000h=oS0>3Oh`0@0>3Oh`030:F/
/P3oool0oooo0580oooo00D000000?ooo`3oool0oooo000000060?ooo`04
0:F//P3IeMD003ad0?ooo`H0n?cm0P0000060?Slo@030?ooo`00?7@0inKY
0080h=oS00P0W9bN0?ooo`3Pgn<0h=oS0?7_hP1VIWh0Z:Vk0?_lo@40oooo
00001@1VIWh0nocm0:RY^`1VIWh0LFmT00D0oooo00@0Ogmo0?ooo`3oool0
oooo0`2OWil00`3oool0820P0=_Kf`020?ooo`030410@02o_kl0oooo0080
oooo00H0K6a/07QhN03oool0clo?02@T903[jn/O0?ooo`030?mHE03o1P00
o`H00080o`H000<0og=`0?ooo`3oool0=`3oool00`3noo/0gOn?0?_ol`0k
0?ooo`030?gon`37ohl0nOoc05P0oooo00<0N7oo000>o`003_l00P003_l0
0`1`N?l0oooo0?ooo`110?ooo`0308ooH03oool0oooo0340oooo00D0lNoR
0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0309bLWP3oool0h=oS01P0h=oS00<0
YJbb0?ooo`3oool0D`3oool3000000L0oooo00@0YJbb0=WEe@00?7@0oooo
1P3moOd2000000H0oOgm00<0oooo000lM03Wi^T00P3Pgn<0202LW9h0oooo
0>3Oh`3Pgn<0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk
06IVOP1aKf@01@3oool00`1oOgl0oooo0?ooo`050?ooo`0602@T903Kfm/0
oooo0?ooo`10@400_kno0`3oool01@3_knl0:2PX03`l?00H61P0Xj>S01h0
oooo00P0okFc0?mXI03oZZP0ogUf0?lB303o3PP0og=`0?oclcP0oooo00<0
lOo?0=KoN03koo<0>`3oool00`3moo/0aon?0?Wol`1I0?ooo`060?_ko`0n
B?l02aSo00PFo`1`N?l0loCo@`3oool00`2?of00oooo0?ooo`0a0?ooo`05
0?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<00`2LW9h0oooo0>3Oh`0H0>3O
h`030:F//P3oool0oooo05d0oooo00@0YJbb0=WEe@00?7@0oooo1P3moOd2
000000H0oOgm00<0oooo000lM03Vi^T00P3Pgn<0202LW9h0oooo0>3Oh`3P
gn<0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1a
Kf@00`3oool01@2OWil0Ogmo03lo?`1oOgl0WinO00D0oooo00H0A4A40;Ng
]`3oool0oooo01`L703GemL30?ooo`0507AdM01lO7`0oooo0>?Sh`0@4100
703oool0103ono/0ogMd0?n]Z`3ono/l0?ooo`040?kon`3KohL0f_n30?ko
nc/0oooo00<0oOok0<OoS`3ioo<0FP3oool00`3knol0L7So0?ooo`130?oo
o`060?con`2PogP0E?l<04ko0`2Kog00mooc<@3oool01@3akn80h=oS0>3O
h`3Pgn<0LFmT0080h=oS00<0W9bN0?ooo`3Pgn<0603Pgn<00`2U[;80oooo
0?ooo`1M0?ooo`040:F//P3He=@003ad0?ooo`H0oOgm0P0000060?gmo@03
0?ooo`00?7@0iNGX0080h=oS00P0W9bN0?ooo`3Pgn<0h=oS0?7_hP1VIWh0
Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT00D0oooo00<0
Ogmo0?ooo`3oool01@3oool01P1oOgl0K6a/0?ooo`3?cll092@T0?_kn`<0
oooo00D0I6AT07alO03oool0hn?S00P8200K0?ooo`030?okn`3oTXl0oo?c
03d0oooo00<0o_ok0=GoM03aoll0?03oool00`3moo/0aon?0?Wol`1K0?oo
o`0308>:o`3cm?l0oooo04<0oooo00<0X?mh04co001<o`000P1<o`000`2K
og00oooo0?ooo`0_0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<0
0`2LW9h0oooo0>3Oh`0H0>3Oh`030:F//P3oool0oooo05d0oooo00@0YJbb
0=WEe@0UEhD0_lkL1P3oool2000000H0oooo00<0_lkK02EGQ@3QhN@00P3P
gn<0202LW9h0oooo0>3Oh`3Pgn<0lNoR06IVOP2XZK/0nocm0@3oool00005
06IVOP3ko?d0Z:Vk06IVOP1aKf@01@3oool00`1oOgl0oooo0?ooo`050?oo
o`050??cl`1DE5@0@4100410@033`l<0103oool01@3[jn/0D51@0410@00d
=3@0^k^k01X0oooo00<0okFc0?moO03olo<0?@3oool00`3noo/0gOn?0?_o
l`0l0?ooo`030?gon`37ohl0nOoc05/0oooo00<0no_o071ho`3oool0A03o
ool00`1Do``0C?l004co000204co000305;o203oool0oooo02l0oooo00D0
lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0309bLWP3oool0h=oS01P0h=oS
00<0YJbb0?ooo`3oool0G@3oool01@2U[;80fMGE07VDZ@1EOJ80`<oM00D0
oooo0P0000050?ooo`040=GOj01EOJ80NIF[0=oMh080h=oS00P0W9bN0?oo
o`3Pgn<0h=oS0?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY
^`1VIWh0LFmT00D0oooo00<0Ogmo0?ooo`3oool0:`3oool0103o]K<0ofQT
0?n]Z`3ono/m0?ooo`030?kon`3Mohl0nooc03d0oooo00<0_?mh0?Wol`3o
ool0F`3oool00`23R_l0loCo0?ooo`140?ooo`0305Co301<o`00C?l00080
C?l000<0D_l80?ooo`3oool0;`3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT
0080h=oS00<0W9bN0?ooo`3Pgn<0603Pgn<00`2U[;80oooo0?ooo`1M0?oo
o`050:F//P3JemT0gmcH07VDZ@0UEhD03000?7@0100GCGh0IXJQ0>3NfP3L
fmd20>3Oh`0809bLWP3oool0h=oS0>3Oh`3akn80IVIn0:RY^`3ko?d10?oo
o`0000D0IVIn0?_lo@2XZK/0IVIn075_I0050?ooo`0307moO`3oool0oooo
02T0oooo00@0okFc0?mXI03o[J/0oo_k?P3oool00`3noo/0gOn?0?_ol`0m
0?ooo`030=Wo/`3Eoj/0oooo05`0oooo00<0H6Wo0?ooo`3oool0A03oool0
0`2PogP0C?l004co000204co000309_oL03oool0oooo02l0oooo00D0lNoR
0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0309bLWP3oool0h=oS01P0h=oSH@2U
[;800`3OgN00f]OI0=SDe0070=OCe0<0dlk<0`3Gdm@0103He=@0fMGE0=[G
f@3OgN020>3Oh`0809bLWP3oool0h=oS0>3Oh`3akn80IVIn0:RY^`3ko?d1
0?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I0050?ooo`0307moO`3oool0
oooo02L0oooo00@0om3?0?mTH03o[J/0oo_k?`3oool00`3Xok<0eoml0?_o
l`0m0?ooo`030?gon`2logP0oOok05d0oooo00<0OhKo0?ooo`3oool0A03o
ool01P3loo/0X?mh05Co301Bo`P0Vom`0?Oolc40oooo00D0lNoR0>3Oh`3P
gn<0h=oS075_I0020>3Oh`0309bLWP3oool0h=oS08l0h=oS00P0W9bN0?oo
o`3Pgn<0h=oS0?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY
^`1VIWh0LFmT00D0oooo00<0Ogmo0?ooo`3oool09@3oool0103ono/0ohZ7
0?n6P`3ono/o0?ooo`040?kon`3Eog@0i_n[0?koncd0oooo00<0oOok0<Oo
S`3ioo<0G@3oool2071hogd0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I002
0>3Oh`0309bLWP3oool0h=oS08l0h=oS00P0W9bN0?ooo`3Pgn<0h=oS0?7_
hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT00D0
oooo00<0Ogmo0?ooo`3oool0903oool00`3omoL0ogMd0?o@c`100?ooo`03
0?kon`3Mohl0nooc03h0oooo00<0oOok0<OoS`3ioo<0GP3oool00`1PJOl0
oooo0?ooo`1l0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<00`2L
W9h0oooo0>3Oh`2?0>3Oh`0809bLWP3oool0h=oS0>3Oh`3akn80IVIn0:RY
^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I0050?ooo`0307mo
O`3oool0oooo02<0oooo00<0oo_k0?nBS`3omoL0@03oool00`3noo/0gOn?
0?_ol`0n0?ooo`030?gon`37ohl0nOoc05l0oooo00<0OhKo0?ooo`3oool0
O03oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00<0W9bN0?ooo`3P
gn<0S`3Pgn<0202LW9h0oooo0>3Oh`3Pgn<0lNoR06IVOP2XZK/0nocm0@3o
ool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@01@3oool00`1oOgl0oooo0?oo
o`0R0?ooo`030?ogm`3oTXl0oo?c0400oooo00<0o_ok0=goS`3koo<0?P3o
ool00`3moo/0aon?0?Wol`1O0?ooo`030?_ko`1`N?l0oooo07d0oooo00D0
lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0309bLWP3oool0h=oS08l0h=oS
00P0W9bN0?ooo`3Pgn<0h=oS0?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1V
IWh0nocm0:RY^`1VIWh0LFmT00D0oooo00<0Ogmo0?ooo`3oool08@3oool0
0`3od<l0og]h0?ogm`100?ooo`030?kon`3Mohl0nooc03l0oooo00<0`On3
0?Wol`3oool0G`3oool00`1dO?l0loCo0?ooo`1m0?ooo`050?7_hP3Pgn<0
h=oS0>3Oh`1aKf@00P3Pgn<00`2LW9h0oooo0>3Oh`2?0>3Oh`0809bLWP3o
ool0h=oS0>3Oh`3akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2X
ZK/0IVIn075_I0050?ooo`0307moO`3oool0oooo01l0oooo00@0oo_k0?n:
Q`3oQX<0oo_k@03oool00`3noo/0gOn?0?_ol`100?ooo`030;ooO`3oool0
oooo05l0oooo00<0H6Wo0?ooo`3oool0O@3oool01@3akn80h=oS0>3Oh`3P
gn<0LFmT0080h=oS00<0W9bN0?ooo`3Pgn<0603Pgn<00`000000h=oS0>3O
h`0j0>3Oh`@00000=P3Pgn<0202LW9h0oooo0>3Oh`3Pgn<0lNoR06IVOP2X
ZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@01@3oool00`1o
Ogl0oooo0?ooo`0N0?ooo`030?ne/`3oJ6@0om3?0440oooo00<0j?nc0=Oo
O03koo<0?`3oool00`3moo/0_omo0;SoL01Q0?ooo`03061Yo`3oool0oooo
07d0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0309bLWP3oool0
h=oS01P0h=oS00<000000>3Oh`3Pgn<0?P3Pgn<00`000000h=oS0>3Oh`0c
0>3Oh`0809bLWP3oool0h=oS0>3Oh`3akn80IVIn0:RY^`3ko?d10?ooo`00
00D0IVIn0?_lo@2XZK/0IVIn075_I0050?ooo`0307moO`3oool0oooo01`0
oooo00@0okFc0?mXI03o[J/0oo_k@@3oool00`3>oe`0i_n[0?kon`100?oo
o`030<7oP`3ioo<0oooo0600oooo00<0no_o071ho`3oool0OP3oool01@3a
kn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00<0W9bN0?ooo`3Pgn<0103Pgn<0
0`000000h=oS000000030>3Oh`030000003Pgn<0h=oS0080000000@0h=oS
0000003Pgn<0h=oS0`0000020>3Oh`040000003Pgn<00000000000<0h=oS
0`0000020>3Oh`050000003Pgn<0h=oS0>3Oh`0000000P3Pgn<200000004
0>3Oh`000000h=oS0>3Oh`<000000P3Pgn<01P000000h=oS0>3Oh`3Pgn<0
00000>3Oh`800000103Pgn<00`000000h=oS0>3Oh`020>3Oh`030000003P
gn<0h=oS0080000000@0h=oS0000003Pgn<000000`3Pgn<00`000000h=oS
0>3Oh`02000000040>3Oh`000000h=oS0>3Oh`<00000<03Pgn<0202LW9h0
oooo0>3Oh`3Pgn<0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0
Z:Vk06IVOP1aKf@01@3oool00`1oOgl0oooo0?ooo`0J0?ooo`040?oLf`3o
J6@0ojf[0?oknd80oooo00<0j?nc0>KoZ`3oool0@03oool00`3moo/0_omo
0?ooo`1Q0?ooo`0307Alo`3cm?l0oooo07h0oooo00D0lNoR0>3Oh`3Pgn<0
h=oS075_I0020>3Oh`0309bLWP3oool0h=oS00@0h=oS00<000000>3Oh`00
00000`3Pgn<00`000000h=oS000000020>3Oh`80000000<0h=oS0000003P
gn<00P3Pgn<010000000h=oS0000000000020>3Oh`030000003Pgn<00000
00<0h=oS00<000000>3Oh`0000000`3Pgn<00`000000h=oS000000020>3O
h`80000000<0h=oS0000003Pgn<00P3Pgn<00`000000h=oS000000030>3O
h`030000003Pgn<0000000D0h=oS00D000000>3Oh`3Pgn<0h=oS00000002
0>3Oh`030000003Pgn<0h=oS0080000000<0h=oS0000003Pgn<00P3Pgn<0
0`000000h=oS000000020>3Oh`80000000<0h=oS0000003Pgn<00P3Pgn<0
0`000000h=oS0>3Oh`0]0>3Oh`0809bLWP3oool0h=oS0>3Oh`3akn80IVIn
0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I0050?ooo`03
07moO`3oool0oooo01T0oooo00<0okFc0?mgM03omoL0@`3oool00`3/okl0
d?mT0?kon`110?ooo`030<7oP`3ioo<0oooo0640oooo00<0H6Wo0?ooo`3o
ool0OP3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00<0W9bN0?oo
o`3Pgn<0103Pgn<00`000000h=oS000000030>3Oh`030000003Pgn<00000
00<0h=oS00<000000>3Oh`0000001@3Pgn<01`000000h=oS0>3Oh`3Pgn<0
00000>3Oh`0000001@3Pgn<01`000000h=oS0>3Oh`3Pgn<000000>3Oh`00
00000`3Pgn<00`000000h=oS000000050>3Oh`070000003Pgn<0h=oS0>3O
h`000000h=oS000000050>3Oh`050000003Pgn<0h=oS0>3Oh`0000000P3P
gn<01`000000h=oS0>3Oh`3Pgn<000000>3Oh`0000000`3Pgn<00`000000
h=oS000000030>3Oh`030000003Pgn<0000003<0h=oS00P0W9bN0?ooo`3P
gn<0h=oS0?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1V
IWh0LFmT00D0oooo00<0Ogmo0?ooo`3oool0603oool00`3oSX/0okfk0?oo
o`130?ooo`030=3oI03Xok<0o_ok0440oooo00<0oOok0;ooO`3oool0HP3o
ool00`1PJOl0oooo0?ooo`0G0?ooo`0308o?o`3oool0oooo06@0oooo00D0
lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0309bLWP3oool0oooo00<0oooo
00@0h=oS0000003Pgn<000000`3Pgn<00`000000h=oS000000030>3Oh`03
0000003Pgn<0000000@0000000<0h=oS0000003Pgn<00P3Pgn<00`000000
h=oS00000004000000030>3Oh`000000h=oS0080h=oS00<000000>3Oh`00
00000`3Pgn<00`000000h=oS00000004000000030>3Oh`000000h=oS0080
h=oS00<000000>3Oh`0000001@3Pgn<010000000h=oS0>3Oh`0000040>3O
h`@0000000<0h=oS0000003Pgn<00P3Pgn<00`000000h=oS000000030>3O
h`030000003Pgn<0000000@000000P3Pgn<]0?ooo`0809bLWP3oool0h=oS
0>3Oh`3akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn
075_I0050?ooo`0307moO`3oool0oooo01H0oooo00<0oo_k0?moO03oi><0
A03oool00`3Xok<0i_n[0?ooo`120?ooo`030<7oP`3ioo<0oooo0680oooo
00<0H6Wo0?ooo`3oool05`3oool00`1P^_l0oooo0?ooo`1T0?ooo`050?7_
hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<609bLWP030>3Oh`000000h=oS0080
00000P3Pgn<00`000000h=oS000000020>3Oh`80000000<0h=oS0000003P
gn<00P3Pgn<010000000h=oS0000000000020>3Oh`030000003Pgn<00000
00<0h=oS00@000000>3Oh`00000000000P3Pgn<00`000000h=oS00000002
0>3Oh`80000000<0h=oS0000003Pgn<00P3Pgn<010000000h=oS00000000
00020>3Oh`030000003Pgn<0000000D0h=oS1@0000020>3Oh`060000003P
gn<0h=oS0>3Oh`000000h=oS0P0000020>3Oh`030000003Pgn<000000080
h=oS0P0000000`3Pgn<000000>3Oh`020>3Oh`030000003Pgn<0h=oS02h0
W9bN00L0oooo0>3Oh`3Pgn<0lNoR06IVOP2XZK/0nocm0040oooo00001@1V
IWh0nocm0:RY^`1VIWh0LFmT00D0oooo00<0Ogmo0?ooo`3oool05@3oool0
0`3ono/0oi:?0?ocl`150?ooo`030=3oI03noo/0oooo0440oooo0P2hog1T
0?ooo`03061Yo`3oool0oooo01L0oooo00<0H;[o0?ooo`3oool0I03oool0
1@3akn80h=oS0>3Oh`3Pgn<0LFmT00T0h=oS00@000000>3Oh`000000h=oS
0P0000030>3Oh`80000000@0h=oS0000003Pgn<0h=oS0`0000020>3Oh`04
0000003Pgn<00000000000<0h=oS0`0000020>3Oh`040000003Pgn<00000
000000<0h=oS0P000000103Pgn<000000>3Oh`3Pgn<300000080h=oS00D0
00000>3Oh`00000000000>3Oh`03000000@0h=oS00<000000>3Oh`3Pgn<0
0P3Pgn<00`000000h=oS0>3Oh`0300000080h=oS00@000000>3Oh`000000
00000`3Pgn<2000000040>3Oh`000000h=oS0>3Oh`<00000=03Pgn<0103a
kn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I005
0?ooo`0307moO`3oool0oooo01@0oooo00<0oo_k0?nBS`3olo<0A@3oool0
0`3Xok<0i_n[0?ooo`0n0?ooo`060?gon`2logP0Q_l<08Co202LocP0nOoc
I03oool00`1PJOl0oooo0?ooo`0G0?ooo`03062jo`3oool0oooo06@0oooo
00D0lNoR0>3Oh`3Pgn<0h=oS075_I0090>3Oh`030000003Pgn<0h=oS00T0
h=oS00<000000>3Oh`3Pgn<06`3Pgn<00`000000h=oS0>3Oh`0;0>3Oh`03
0000003Pgn<0h=oS00<0h=oS00<000000>3Oh`3Pgn<00P3Pgn<00`000000
h=oS0>3Oh`190>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0
nocm0:RY^`1VIWh0LFmT00D0oooo00<0Ogmo0?ooo`3oool04`3oool00`3o
no/0oi:?0?ocl`150?ooo`030>So/`3@of@0o_ok03l0oooo00<0_?mh083o
0020o`000P20o`000`2hog00oooo0?ooo`1R0?ooo`03061Yo`3oool0oooo
01L0oooo0P1``OmU0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@02@3Pgn<0
0`000000h=oS0>3Oh`090>3Oh`030000003Pgn<0h=oS01/0h=oS00<00000
0>3Oh`3Pgn<02`3Pgn<00`000000h=oS0>3Oh`030>3Oh`D00000C03Pgn<0
103akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_
I0050?ooo`0307moO`3oool0oooo0180oooo00<0omcK0?mkN03olo<0A@3o
ool00`3>oe`0i_n[0?kon`100?ooo`0308Ko3020o`00P?l00080P?l000<0
Q?l80?ooo`3oool0HP3oool00`1PJOl0oooo0?ooo`0H0?ooo`03062jo`3o
ool0oooo06<0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I02H0>3Oh`040?7_
hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT00D0
oooo00<0Ogmo0?ooo`3oool04@3oool00`3o[J/0ogMd0?ocl`150?ooo`03
0>So/`3Voj/0oooo0440oooo00<0Q_l<083o0020o`000P20o`000`24o`P0
oooo0?ooo`1R0?ooo`0308nEo`3oool0oooo01P0oooo00<0H;[o0?ooo`3o
ool0H`3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT09P0h=oS00@0lNoR06IV
OP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@01@3oool0
0`1oOgl0oooo0?ooo`0?0?ooo`030?okn`3oNgP0ojVW04H0oooo00<0nooc
0=CoL03noo/0@P3oool00`2logP0P?l0083o0002083o00030;SoL03oool0
oooo07d0oooo00<0H;[o0?ooo`3oool0H`3oool01@3akn80h=oS0>3Oh`3P
gn<0LFmT09P0h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3k
o?d0Z:Vk06IVOP1aKf@01@3oool00`1oOgl0oooo0?ooo`0>0?ooo`030?oL
f`3oI600omSG04H0oooo00<0o_ok0=[oP`3jonl0@`3oool01P3moo/0Woln
08Ko2`24o`P0^?m`0?Wolgl0oooo00<0H;[o0?ooo`3oool0H`3oool01@3a
kn80h=oS0>3Oh`3Pgn<0LFmT09P0h=oS00@0lNoR06IVOP2XZK/0nocm0@3o
ool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@01@3oool00`1oOgl0oooo0?oo
o`0=0?ooo`030?n]Z`3oMg@0oo?c04L0oooo00<0e_mh0?_ol`3oool0@`3o
ool00`3moo/0_omo0?ooo`220?ooo`03062jo`3oool0oooo06<0oooo00D0
lNoR0>3Oh`3Pgn<0h=oS075_I02H0>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40
oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT00D0oooo00<0Ogmo0?ooo`3o
ool02`3oool00`3ono/0og]h0?nYY`180?ooo`030>So/`3Voj/0oooo04@0
oooo00<0`On30?Wol`3oool0PP3oool00`1d`ol0lo[o0?ooo`1S0?ooo`05
0?7_hP3Pgn<0h=oS0>3Oh`1aKf@0V03Pgn<0103akn80IVIn0:RY^`3ko?d1
0?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I0050?ooo`0307moO`3oool0
oooo00X0oooo00<0oo_k0?mgM03of=L0B03oool00`3noo/0e_mh0?kon`14
0?ooo`030?gon`2hog00oooo08<0oooo00<0nogo07o8o`3oool0H`3oool0
1@3akn80h=oS0>3Oh`3Pgn<0LFmT09P0h=oS00@0lNoR06IVOP2XZK/0nocm
0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@01@3oool00`1oOgl0oooo
0?ooo`090?ooo`030?okn`3oTXl0oo?c04P0oooo00<0o_ok0=goS`3koo<0
A@3oool00`31oh<0nOoc0?ooo`240?ooo`03062jo`3oool0oooo0680oooo
00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Ohi@0oooo0P3Pgn<0103akn80
IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I0050?oo
o`0307moO`3oool0oooo00P0oooo00<0oo_k0?nBS`3olo<0B03oool00`3n
oo/0gOn?0?_ol`160?ooo`030;ooO`3oool0oooo08@0oooo00<0OlSo0?oo
o`3oool0HP3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oST`2LW9h0
1`3oool0h=oS0>3Oh`3akn80IVIn0:RY^`3ko?d00@3oool0000506IVOP3k
o?d0Z:Vk06IVOP1aKf@01@3oool00`1oOgl0oooo0?ooo`070?ooo`030?ok
n`3oTXl0oo?c04P0oooo00<0o_ok0=goS`3koo<0AP3oool00`3moo/0_omo
0?ooo`250?ooo`80L<7oH`3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080
h=oS00<0W9bN0?ooo`3Pgn<0S`3Pgn<0202LW9h0oooo0>3Oh`3Pgn<0lNoR
06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@01@3o
ool00`1oOgl0oooo0?ooo`060?ooo`030?oLf`3oNgP0oo?c04P0oooo00<0
o_ok0=goS`3koo<0A`3oool00`31oh<0nOoc0?ooo`260?ooo`0307o8o`3o
ool0oooo0640oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0309bL
WP3oool0h=oS08l0h=oS00P0W9bN0?ooo`3Pgn<0h=oS0?7_hP1VIWh0Z:Vk
0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT00D0oooo00<0Ogmo
0?ooo`3oool01@3oool00`3o[J/0ogMd0?ocl`190?ooo`030=[oP`3koo<0
oooo04L0oooo00<0_omo0?ooo`3oool0QP3oool00`1ob?l0oooo0?ooo`1Q
0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<00`2LW9h0oooo0>3O
h`2?0>3Oh`0809bLWP3oool0h=oS0>3Oh`3akn80IVIn0:RY^`3ko?d10?oo
o`0000D0IVIn0?_lo@2XZK/0IVIn075_I0050?ooo`0307moO`3oool0oooo
00<0oooo00<0oo_k0?mkN03oZJL0BP3oool00`3noo/0f?mo0?ooo`170?oo
o`030?gon`2oogl0oooo0400oooo00<0Ton?0?ooo`3oool0A03oool00`23
b_l0lo[o0?ooo`1Q0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<0
0`2LW9h0oooo0>3Oh`2?0>3Oh`0809bLWP3oool0h=oS0>3Oh`3akn80IVIn
0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I0050?ooo`03
07moO`3oool0oooo0080oooo00<0oo_k0?mgM03of=L0A`3oool01P3noo/0
e_mh0;Ko302do`P0aOlo0?Ooj4P0oooo00<0`On30?Wol`3oool0@03oool0
0`1Uof00oooo0?ooo`140?ooo`030?_mo`1ob?l0oooo0640oooo00D0lNoR
0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0309bLWP3oool0h=oS08l0h=oS00P0
W9bN0?ooo`3Pgn<0h=oS0?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0
nocm0:RY^`1VIWh0LFmT00D0oooo00L0Ogmo0?ooo`3oool0oooo0?okn`3o
TXl0oo?c04P0oooo00<0e_mh0;;o002bo`000P2bo`000`3Dog00oooo0?oo
o`160?ooo`030;3oH03oool0oooo0400oooo00<0IOmP0?ooo`3oool0A@3o
ool00`1ob?l0oooo0?ooo`1P0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@0
0P3Pgn<00`2LW9h0oooo0>3Oh`2?0>3Oh`0809bLWP3oool0h=oS0>3Oh`3a
kn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I005
0?ooo`0607moO`3oool0oooo0?okn`3oTXl0oo?cB@3oool00`2fo``0/_l0
0;;o00020;;o00030;Co203oool0oooo04D0oooo00<0oOok0;ooO`3oool0
@@3oool00`1Uof00oooo0?ooo`150?ooo`0308?:o`3cn_l0oooo0600oooo
00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0309bLWP3oool0h=oS08l0
h=oS00P0W9bN0?ooo`3Pgn<0h=oS0?7_hP1VIWh0Z:Vk0?_lo@40oooo0000
1@1VIWh0nocm0:RY^`1VIWh0LFmT00D0oooo00D0Ogmo0?ooo`3ono/0oi:?
0?ocl`1:0?ooo`030;Ko302bo`00/_l00080/_l000<0]?l80?ooo`3oool0
A@3oool00`31oh<0nOoc0?ooo`110?ooo`0306GoH03oool0oooo04D0oooo
00<0nogo07o8o`3oool0H03oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080
h=oS00<0W9bN0?ooo`3Pgn<0S`3Pgn<0202LW9h0oooo0>3Oh`3Pgn<0lNoR
06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@01@3o
ool0101oOgl0oo_k0?mkN03olo=;0?ooo`030=KoN02bo`00/_l00080/_l0
00<0e?m`0?ooo`3oool0A@3oool00`2oogl0oooo0?ooo`110?ooo`0306Go
H03oool0oooo04H0oooo00<0Pl[o0??jo`3oool0G`3oool01@3akn80h=oS
0>3Oh`3Pgn<0LFmT0080h=oS00<0W9bN0?ooo`3Pgn<0S`3Pgn<0202LW9h0
oooo0>3Oh`3Pgn<0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0
Z:Vk06IVOP1aKf@01@3oool00`1oOgl0og]h0?oHe`1<0?ooo`060?kon`34
oc`0]_l<0;Co203Dog00noocA`3oool00`2`of00oooo0?ooo`110?ooo`03
06GoH03oool0oooo04H0oooo00<0nogo07o8o`3oool0G`3oool01@3akn80
h=oS0>3Oh`3Pgn<0LFmT0080h=oS00<0W9bN0?ooo`3Pgn<0S`3Pgn<0202L
W9h0oooo0>3Oh`3Pgn<0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3k
o?d0Z:Vk06IVOP1aKf@01@3oool00`2YEeD0ojFS0?ooo`1<0?ooo`030?ko
n`3Hogl0oooo04X0oooo00<0_omo0?ooo`3oool0@@3oool00`1Uof00oooo
0?ooo`170?ooo`0308?:o`3cn_l0oooo05h0oooo00D0lNoR0>3Oh`3Pgn<0
h=oS075_I0020>3Oh`0309bLWP3oool0h=oS08l0h=oS00P0W9bN0?ooo`3P
gn<0h=oS0?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1V
IWh0LFmT00@0oooo00<0omcK0<Dm>P3oool0C03oool00`3noo/0gOn?0?_o
l`1:0?ooo`80^?m`@`3oool00`1Uof00oooo0?ooo`170?ooo`030?_mo`2?
col0lo[o05h0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0309bL
WP3oool0h=oS08l0h=oS00P0W9bN0?ooo`3Pgn<0h=oS0?7_hP1VIWh0Z:Vk
0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT00<0oooo00<0oo_k
0?mgM025NGT0C@3oool00`3Joh<0nooc0?ooo`1:0?ooo`030;ooO`3oool0
oooo0480oooo00<0IOmP0?ooo`3oool0B03oool00`3koOl0OlSo0?ooo`1M
0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<00`2LW9h0oooo0>3O
h`2?0>3Oh`0809bLWP3oool0h=oS0>3Oh`3akn80IVIn0:RY^`3ko?d10?oo
o`0000D0IVIn0?_lo@2XZK/0IVIn075_I0020?ooo`040?okn`3oTXl0oo?c
07moOd`0oooo00<0o_ok0=SoO`3oool0B`3oool00`2`of00oooo0?ooo`12
0?ooo`80M?m`BP3oool00`1``Ol0nogo0?ooo`1L0?ooo`050?7_hP3Pgn<0
h=oS0>3Oh`1aKf@00P3Pgn<00`2LW9h0oooo0>3Oh`2?0>3Oh`0809bLWP3o
ool0h=oS0>3Oh`3akn80IVIn0:RY^`3ko?d10?ooo`0000/0IVIn0?_lo@2X
ZK/0IVIn075_I03oool0oo_k0?nBS`3olo<0oooo07moO`1<0?ooo`030=[o
P`3koo<0oooo04/0oooo00<0/?mP0?ooo`3oool0@`3oool00`1Uof00oooo
0?ooo`180?ooo`030;?No`2[fol0oooo05`0oooo00D0lNoR0>3Oh`3Pgn<0
h=oS075_I0020>3Oh`0309bLWP3oool0h=oS08l0h=oS00P0W9bN0?ooo`3P
gn<0h=oS0?7_hP1VIWh0Z:Vk0?_lo@40oooo0000201VIWh0nocm0:RY^`1V
IWh0LFmT0?okn`3oTXl0oo?c0P3oool00`1oOgl0oooo0?ooo`190?ooo`03
0?kon`3Hogl0oooo04`0oooo00<0/?mP0?ooo`3oool0@`3oool00`23ogl0
oooo0?ooo`190?ooo`0307S5o`3cn_l0oooo05/0oooo00D0lNoR0>3Oh`3P
gn<0h=oS075_I0020>3Oh`0309bLWP3oool0h=oS08l0h=oS00P0W9bN0?oo
o`3Pgn<0h=oS0?7_hP1VIWh0Z:Vk0?_lo@40oooo00001`1VIWh0nocm0:RY
^`1VIWh0LFmT0?n]Z`3olo<00`3oool00`1oOgl0oooo0?ooo`190?ooo`03
0=KoN03koo<0oooo04`0oooo00<0/?mP0?ooo`3oool05@3oool00`2?om`0
oooo0?ooo`0[0?ooo`0306GoH03oool0oooo04T0oooo00<0nogo08o?o`3c
n_l0F`3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00<0W9bN0?oo
o`3Pgn<0S`3Pgn<0202LW9h0oooo0>3Oh`3Pgn<0lNoR06IVOP2XZK/0nocm
0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@01@3oool00`1oOgl0oooo
0?ooo`180?ooo`030>So/`3Voj/0oooo04d0oooo00<0/?mP0?ooo`3oool0
5@3oool00`1Polh0oooo0?ooo`0[0?ooo`0308OoP`3coo<0oooo04X0oooo
00<0nogo07S5o`3koOl0FP3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080
h=oS00<0W9bN0?ooo`3Pgn<0S`3Pgn<0202LW9h0oooo0>3Oh`3Pgn<0lNoR
06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@01@3o
ool00`1oOgl0oooo0?ooo`170?ooo`030?kon`3FogP0o_ok04d0oooo0P2h
og0G0?ooo`03063ocP3oool0oooo02/0oooo00<0nook08?oO`3oool0B`3o
ool00`2cg_l0Zm_o0?ooo`1I0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@0
0P3Pgn<00`2LW9h0oooo0>3Oh`2?0>3Oh`0809bLWP3oool0h=oS0>3Oh`3a
kn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I005
0?ooo`0307moO`3oool0oooo04L0oooo00<0f_n30?_ol`3oool0C@3oool0
0`2`of00oooo0?ooo`0F0?ooo`03063ocP3oool0oooo02`0oooo00<0IOmP
0?ooo`3oool0B`3oool00`1T_?l0nogo0?ooo`1H0?ooo`050?7_hP3Pgn<0
h=oS0>3Oh`1aKf@00P3Pgn<00`2LW9h0oooo0>3Oh`2?0>3Oh`0809bLWP3o
ool0h=oS0>3Oh`3akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2X
ZK/0IVIn075_I0050?ooo`0307moO`3oool0oooo04L0oooo00<0f?mo0?oo
o`3oool0C@3oool00`2`of00oooo0?ooo`0F0?ooo`03063ocP3oool0oooo
02`0oooo00<0Qon30??ol`3oool0B`3oool00`2cg_l0Zm_o0?ooo`1H0?oo
o`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<00`2LW9h0oooo0>3Oh`2?
0>3Oh`0809bLWP3oool0h=oS0>3Oh`3akn80IVIn0:RY^`3ko?d10?ooo`00
00D0IVIn0?_lo@2XZK/0IVIn075_I0050?ooo`0307moO`3oool0oooo04H0
oooo00<0o_ok0=SoO`3oool0CP3oool00`2`of00oooo0?ooo`0F0?ooo`03
063ocP3oool0oooo02`0oooo00<0nook08?oO`3oool0C03oool00`1haOl0
lo[o0?ooo`1G0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<00`2L
W9h0oooo0>3Oh`2?0>3Oh`0809bLWP3oool0h=oS0>3Oh`3akn80IVIn0:RY
^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I0050?ooo`0307mo
O`3oool0oooo04H0oooo00<0f_n30?_ol`3oool0CP3oool00`2`of00oooo
0?ooo`0F0?ooo`0307Coe03coo/0oooo02d0oooo00<0Pomo0?ooo`3oool0
B`3oool00`3koOl0N<Go0?_mo`1G0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1a
Kf@00P3Pgn<00`2LW9h0oooo0>3Oh`2?0>3Oh`0809bLWP3oool0h=oS0>3O
h`3akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_
I0050?ooo`0307moO`3oool0oooo04H0oooo00<0f?mo0?ooo`3oool0CP3o
ool00`37ohl0oooo0?ooo`0F0?ooo`030?_ooP1`om<0oooo02d0oooo00<0
Qon30??ol`3oool0C03oool00`2cg_l0Zm_o0?ooo`1F0?ooo`050?7_hP3P
gn<0h=oS0>3Oh`1aKf@00P3Pgn<00`2LW9h0oooo0>3Oh`2?0>3Oh`0809bL
WP3oool0h=oS0>3Oh`3akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_l
o@2XZK/0IVIn075_I0050?ooo`0307moO`3oool0oooo04D0oooo00<0o_ok
0=SoO`3oool0J@3oool00`1Polh0oooo0?ooo`0/0?ooo`030?_on`23ogl0
oooo04d0oooo00<0H;[o0:oLo`3oool0E@3oool01@3akn80h=oS0>3Oh`3P
gn<0LFmT0080h=oS00<0W9bN0?ooo`3Pgn<0S`3Pgn<0202LW9h0oooo0>3O
h`3Pgn<0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IV
OP1aKf@01@3oool00`1oOgl0oooo0?ooo`140?ooo`030?_ol`3KohL0nooc
06X0oooo00<0H?o>0?ooo`3oool0;@3oool00`23ogl0oooo0?ooo`1=0?oo
o`030;oSo`1/`?l0nogo05@0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I002
0>3Oh`0309bLWP3oool0h=oS08l0h=oS00P0W9bN0?ooo`3Pgn<0h=oS0?7_
hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT00D0
oooo00<0Ogmo0?ooo`3oool0A03oool00`3FogP0n_o_0?ooo`1Z0?ooo`03
063ocP3oool0oooo02d0oooo00<0O?mh0?3ok`3oool0CP3oool00`2cg_l0
Zm_o0?ooo`1C0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<00`2L
W9h0oooo0>3Oh`0K0>3Ohg80YJbb0P3Pgn<0202LW9h0oooo0>3Oh`3Pgn<0
lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0
1@3oool00`1oOgl0oooo0?ooo`140?ooo`030=SoO`3oool0oooo06X0oooo
00<0H?o>0?ooo`3oool0;@3oool00`3coo<0O?mh0?ooo`1?0?ooo`0307S5
o`3cn_l0oooo0580oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`03
09bLWP3oool0h=oS01/0h=oS00<0YJbb0?ooo`3oool0KP3oool01@2U[;80
h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool0
000506IVOP3ko?d0Z:Vk06IVOP1aKf@01@3oool00`1oOgl0oooo0?ooo`14
0?ooo`030=SoO`3oool0oooo06X0oooo00<0PooI0??on`3oool0;P3oool0
0`27oh<0looc0?ooo`1>0?ooo`030?_mo`2?col0lo[o0580oooo00D0lNoR
0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0309bLWP3oool0h=oS01/0h=oS00<0
YJbb0?ooo`3oool0KP3oool01@2U[;80h=oS0>3Oh`2LW9h0oooo0080h=oS
00@0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1a
Kf@01@3oool00`1oOgl0oooo0?ooo`130?ooo`030?kon`3Hogl0oooo0440
oooo00<0ohnE0?ooo`3oool09`3oool00`3kooh0L?oC0?ooo`0^0?ooo`03
0?_on`1logP0nook04l0oooo00<0nogo07S5o`3koOl0D@3oool01@3akn80
h=oS0>3Oh`3Pgn<0LFmT0080h=oS00<0W9bN0?ooo`3Pgn<02`3Pgn<00`00
0000h=oS0>3Oh`020>3Oh`8000000P3Pgn<00`000000h=oS0>3Oh`040>3O
h`030:F//P3oool0oooo06h0oooo00D0YJbb0>3Oh`3Pgn<0W9bN0?ooo`02
0>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1V
IWh0LFmT00D0oooo00<0Ogmo0?ooo`3oool0@`3oool00`3Joh<0nooc0?oo
o`110?ooo`030?mPJ03oool0oooo02P0oooo00<0OooG0?ooo`3oool0;P3o
ool00`2eok<0[_n[0?ooo`1?0?ooo`030;?No`2[fol0oooo0500oooo00D0
lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0309bLWP3oool0h=oS00X0h=oS
00<000000>3Oh`3Pgn<00P3Pgn<010000000h=oS0>3Oh`0000020>3Oh`03
0000003Pgn<0h=oS00<0h=oS00<0YJbb0?ooo`3oool0KP3oool01@2U[;80
h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool0
000506IVOP3ko?d0Z:Vk06IVOP1aKf@01@3oool00`1oOgl0oooo0?ooo`13
0?ooo`030=SoO`3oool0oooo0440oooo00<0of1X0?ooo`3oool0:03oool0
0`1oomL0oooo0?ooo`0_0?ooo`03077oK03oool0oooo04l0oooo00<0N<Go
0??jo`3oool0C`3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00<0
W9bN0?ooo`3Pgn<00`3Pgn<400000080h=oS00<000000>3Oh`3Pgn<00P00
00001@3Pgn<000000>3Oh`3Pgn<0000000<0h=oS00<000000>3Oh`3Pgn<0
0P3Pgn<00`2U[;80oooo0?ooo`1^0?ooo`050:F//P3Pgn<0h=oS09bLWP3o
ool00P3Pgn<0103akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2X
ZK/0IVIn075_I0050?ooo`0307moO`3oool0oooo0480oooo00<0o_ok0=So
O`3oool0@P3oool00`3oH6P0oooo0?ooo`0X0?ooo`0307ooe`3oool0oooo
02l0oooo00<0Qon30??ol`3oool0C`3oool00`3koOl0Sloo0??jo`1?0?oo
o`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<00`2LW9h0oooo0>3Oh`03
0>3Oh`040000003Pgn<0h=oS00000080h=oS00@000000>3Oh`3Pgn<00000
0P3Pgn<010000000h=oS0>3Oh`0000030>3Oh`030000003Pgn<0h=oS0080
h=oS00<0YJbb0?ooo`3oool0C`3oool3000000<0oooo00<000000?ooo`3o
ool00`0000030?ooo`<000000`3oool3000000L0oooo00D0YJbb0>3Oh`3P
gn<0W9bN0?ooo`020>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1V
IWh0nocm0:RY^`1VIWh0LFmT00D0oooo00<0Ogmo0?ooo`3oool0@P3oool0
0`3Joh<0nooc0?ooo`120?ooo`030?mPJ03oool0oooo02P0oooo0P1`om<`
0?ooo`030?_on`1logP0nook0500oooo00<0nogo08o?o`3cn_l0CP3oool0
1@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00<0W9bN0?ooo`3Pgn<0103P
gn<00`000000h=oS0>3Oh`020>3Oh`040000003Pgn<0h=oS00000080h=oS
00@000000>3Oh`3Pgn<000000`3Pgn<00`000000h=oS0>3Oh`020>3Oh`03
0:F//P3oool0oooo04h0oooo00D000000?ooo`3oool0oooo000000040?oo
o`070000003oool0oooo0?ooo`000000oooo000000030?ooo`030000003o
ool0000000<0oooo00<000000?ooo`3oool0103oool01@2U[;80h=oS0>3O
h`2LW9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool0000506IV
OP3ko?d0Z:Vk06IVOP1aKf@01@3oool00`1oOgl0oooo0?ooo`120?ooo`03
0=SoO`3oool0oooo0480oooo00<0of1X0?ooo`3oool0:@3oool00`1oomL0
oooo0?ooo`0_0?ooo`030;Go/`2^oj/0oooo0500oooo00<0nogo08o?o`3c
n_l0C@3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00<0W9bN0?oo
o`3Pgn<01@3Pgn<01@000000h=oS0>3Oh`3Pgn<0000000<0h=oS00<00000
0>3Oh`0000000P3Pgn<01@000000h=oS0>3Oh`3Pgn<0000000@0h=oS00<0
YJbb0?ooo`3oool0BP3oool3000000030?ooo`000000oooo0080oooo00<0
00000?ooo`3oool01P3oool00`000000oooo0?ooo`030?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool0103oool01@2U[;80h=oS0>3O
h`2LW9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool0000506IV
OP3ko?d0Z:Vk06IVOP1aKf@01@3oool00`1oOgl0oooo0?ooo`120?ooo`03
0=SoO`3oool0oooo0480oooo0P3oL7LZ0?ooo`0308?of@3coo/0oooo0300
oooo00<0O?mh0??ol`3oool0D03oool00`3koOl0Sloo0??jo`1<0?ooo`05
0?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<00`2LW9h0oooo0>3Oh`040>3O
h`030000003Pgn<000000080h=oS00D000000>3Oh`3Pgn<0h=oS00000002
0>3Oh`800000103Pgn<00`000000h=oS0>3Oh`020>3Oh`030:F//P3oool0
oooo04h0oooo00D000000?ooo`3oool0oooo000000080?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?oo
o`040?ooo`050:F//P3Pgn<0h=oS09bLWP3oool00P3Pgn<0103akn80IVIn
0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I0050?ooo`03
07moO`3oool0oooo0440oooo0P3Dog150?ooo`030?mPJ03oool0oooo02P0
oooo00<0noon07ooe`3oool0<03oool00`3koo/0Pomo0?ooo`1A0?ooo`03
0?_mo`2?col0lo[o04/0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3O
h`0309bLWP3oool0h=oS00@0h=oS0`0000020>3Oh`030000003Pgn<0h=oS
00<000001`3Pgn<00`000000h=oS0>3Oh`020>3Oh`030:F//P3oool0oooo
04h0oooo00D000000?ooo`3oool0oooo000000060?ooo`800000103oool2
00000080oooo100000070?ooo`050:F//P3Pgn<0h=oS09bLWP3oool00P3P
gn<0103akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn
075_I0050?ooo`0307moO`3oool0oooo0440oooo00<0f?mo0?ooo`3oool0
A03oool00`3oH6P0oooo0?ooo`0Y0?ooo`0307ooe`3oool0oooo0300oooo
00<0Pomo0?ooo`3oool0D@3oool00`3koOl0Sloo0??jo`1:0?ooo`050?7_
hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<00`2LW9h0oooo0>3Oh`090>3Oh`05
0000003Pgn<0h=oS0>3Oh`000000203Pgn<00`000000h=oS0>3Oh`020>3O
h`030:F//P3oool0oooo04h0oooo00D000000?ooo`3oool0oooo00000008
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`0000002P3oool0
1@2U[;80h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0nocm
0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@01@3oool00`1oOgl0oooo
0?ooo`110?ooo`030=SoO`3oool0oooo04@0oooo00<0of1X0?ooo`3oool0
:@3oool00`23omT0look0?ooo`0`0?ooo`0308OoP`3coo<0oooo0580oooo
00<0nogo08o?o`3cn_l0B@3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080
h=oS00<0W9bN0?ooo`3Pgn<02P3Pgn<01@000000h=oS0>3Oh`3Pgn<00000
00H0h=oS00<000000>3Oh`3Pgn<00`3Pgn<00`2U[;80oooo0?ooo`1>0?oo
o`050000003oool0oooo0?ooo`000000103oool01`000000oooo0?ooo`3o
ool000000?ooo`0000000`3oool010000000oooo0?ooo`0000090?ooo`05
0:F//P3Pgn<0h=oS09bLWP3oool00P3Pgn<0103akn80IVIn0:RY^`3ko?d1
0?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I0050?ooo`0307moO`3oool0
oooo0440oooo00<0f?mo0?ooo`3oool0A03oool00`3oOhH0oooo0?ooo`0Y
0?ooo`030?_ooP1oomL0oooo0300oooo00<0nook09?oS`3coo<0D`3oool0
0`3koOl0Sloo0??jo`180?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3P
gn<00`2LW9h0oooo0>3Oh`0;0>3Oh`030000003Pgn<0h=oS00H0h=oS00<0
00000>3Oh`3Pgn<0103Pgn<00`2U[;80oooo0?ooo`1?0?ooo`<000001P3o
ool3000000<0oooo0`0000030?ooo`@000001P3oool01@2U[;80h=oS0>3O
h`2LW9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool0000506IV
OP3ko?d0Z:Vk06IVOP1aKf@01@3oool00`1oOgl0oooo0?ooo`110?ooo`03
0=SoO`3oool0oooo02<0oooo00<0Soo`0?ooo`3oool07P3oool00`3oH6P0
oooo0?ooo`0Z0?ooo`03073od`3kooh0oooo0300oooo00<0nook09?oS`3c
oo<0D`3oool00`3koOl0Sloo0??jo`170?ooo`050?7_hP3Pgn<0h=oS0>3O
h`1aKf@00P3Pgn<00`2LW9h0oooo0>3Oh`0K0>3Oh`030:F//P3oool0oooo
06h0oooo00D0YJbb0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`040?7_hP1VIWh0
Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT00D0oooo00<0
Ogmo0?ooo`3oool0@03oool00`3noo/0f?mo0?ooo`0T0?ooo`03063ojP3o
ool0oooo01h0oooo00<0ogn60?ooo`3oool0:P3oool00`2conL0ZooU0?oo
o`0a0?ooo`030?_on`1logP0nook05<0oooo00<0nogo08O;o`3[m_l0AP3o
ool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00<0W9bN0?ooo`3Pgn<0
6`3Pgn<00`2U[;80oooo0?ooo`1^0?ooo`050:F//P3Pgn<0h=oS09bLWP3o
ool00P3Pgn<0103akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2X
ZK/0IVIn075_I0050?ooo`0307moO`3oool0oooo0400oooo00<0eOmd0?_o
l`3oool0903oool00`1PonX0oooo0?ooo`0N0?ooo`80og1g;03oool00`1/
om40oooo0?ooo`0a0?ooo`030;Go/`2^oj/0oooo05<0oooo00<0lo[o06c0
o`3_n?l0A@3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00<0W9bN
0?ooo`3Pgn<06`3Pgn<00`2U[;80oooo0?ooo`1^0?ooo`050:F//P3Pgn<0
h=oS09bLWP3oool00P3Pgn<0103akn80IVIn0:RY^`3ko?d10?ooo`0000D0
IVIn0?_lo@2XZK/0IVIn075_I0050?ooo`0307moO`3oool0oooo00D0oooo
00P0lo?c04A4A014A4@0<30`0;>c/`3oool0Zj^[05QHF0@0oooo00<0F5QH
0>?Sh`3oool0;03oool00`3Hogl0oooo0?ooo`0T0?ooo`03063ojP3oool0
oooo01l0oooo00<0ogn60?ooo`3oool0:P3oool00`23omT0look0?ooo`0b
0?ooo`0307coN03coo<0oooo05<0oooo00<0moco0731o`3?j_l0A03oool0
1@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00<0W9bN0?ooo`3Pgn<06`3P
gn<00`2U[;80oooo0?ooo`1^0?ooo`050:F//P3Pgn<0h=oS09bLWP3oool0
0P3Pgn<0103akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0
IVIn075_I0050?ooo`0307moO`3oool0oooo00D0oooo00P0O7al071`L03o
ool0emOG01`L703kno/0inOW0<o?c`@0oooo00<0@4100=oOg`3oool0;03o
ool00`3?of00oooo0?ooo`0T0?ooo`03063ojP3oool0oooo01l0oooo00<0
ogn60?ooo`3oool0:P3oool00`3kooh0OooG0?ooo`0b0?ooo`030?_on`1l
ogP0nook05@0oooo00@0nogo08O;o`23b_l0moco@P3oool01@3akn80h=oS
0>3Oh`3Pgn<0LFmT0080h=oS00<0W9bN0?ooo`3Pgn<06`3Pgn<00`2U[;80
oooo0?ooo`1^0?ooo`050:F//P3Pgn<0h=oS09bLWP3oool00P3Pgn<0103a
kn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I005
0?ooo`0407moO`3oool0oooo0?ooo`<0Ogmo00<0oooo0410@02g]kL00P3o
ool01P0P8200clo?0?ooo`3oool0`l?300@41080820P00<020P801`L7037
alL0;03oool00`3Hogl0oooo0?ooo`0T0?ooo`03063ojP3oool0oooo01l0
oooo00<0of1X0?ooo`3oool0:`3oool00`1oomL0oooo0?ooo`0b0?ooo`03
0;Go/`2^oj/0oooo05D0oooo00<0cn[o07S5o`3cn_l0@@3oool01@3akn80
h=oS0>3Oh`3Pgn<0LFmT0080h=oS00<0W9bN0?ooo`3Pgn<06`3Pgn=b0:F/
/P80h=oS00P0W9bN0?ooo`3Pgn<0h=oS0?7_hP1VIWh0Z:Vk0?_lo@40oooo
00001@1VIWh0nocm0:RY^`1VIWh0LFmT00D0oooo00@0Ogmo0?ooo`3oool0
oooo0`2OWil00`3oool0820P0=_Kf`020?ooo`030410@02o_kl0oooo0080
oooo00D0A4A40<?3``3oool0@4100=oOg`0]0?ooo`030<ooH03oool0oooo
02@0oooo00<0H?oZ0?ooo`3oool07`3oool00`3oPhT0oo?d0?ooo`0[0?oo
o`0308?of@3coo/0oooo03<0oooo00<0JOmT0?_on`3oool0E@3oool00`3k
oOl0Sloo0??jo`100?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<0
0`2LW9h0oooo0>3Oh`2?0>3Oh`0809bLWP3oool0h=oS0>3Oh`3akn80IVIn
0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I0050?ooo`03
07moO`3oool0oooo00D0oooo00H092@T0=_Kf`3oool0oooo0410@02o_kl3
0?ooo`050=oOg`0d=3@0kno_0410@03Ogml0;@3oool00`3?of00oooo0?oo
o`0T0?ooo`80L?o/803oool00`3ono/0ogn60?ooo`0[0?ooo`030?_ooP2?
om`0look03<0oooo00<0]Onc0:koZ`3oool0EP3oool00`3koOl0Sloo0??j
o`0o0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<00`2LW9h0oooo
0>3Oh`2?0>3Oh`0809bLWP3oool0h=oS0>3Oh`3akn80IVIn0:RY^`3ko?d1
0?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I0030?ooo`0509nOW`1oOgl0
?clo07moO`2OWil01@3oool01P14A4@0]kNg0?ooo`3oool071`L0=OGe`@0
oooo00@0[jn_05aLG010@400gmoO;03oool20=CoL2L0oooo00<0H?oZ0?oo
o`3oool07`3oool00`3oOhH0oooo0?ooo`0[0?ooo`030?_ooP1oomL0oooo
03<0oooo00<0HOmL0:koZ`3koo/0EP3oool0103koOl0M<?o0:_Ko`3koOlm
0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<00`2LW9h0oooo0>3O
h`2?0>3Oh`0809bLWP3oool0h=oS0>3Oh`3akn80IVIn0:RY^`3ko?d10?oo
o`0000D0IVIn0?_lo@2XZK/0IVIn075_I0050?ooo`0307moO`3oool0oooo
00D0oooo00H0Ogmo06a/K03oool0clo?02@T903kno/50?ooo`03051@D008
20P0gmoO02`0oooo00<0comP0?ooo`3oool09P3oool00`1PonX0oooo0?oo
o`0O0?ooo`030?moQP3oool0oooo02`0oooo00<0OooG0?ooo`3oool0<`3o
ool00`2eok<0JOmT0?_on`1G0?ooo`030;?No`1la_l0lo[o03`0oooo00D0
lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0309bLWP3oool0h=oS08l0h=oS
00P0W9bN0?ooo`3Pgn<0h=oS0?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1V
IWh0nocm0:RY^`1VIWh0LFmT00D0oooo00<0Ogmo0?ooo`3oool01@3oool0
1@3clo<0E5AD0410@010@400`l?300H0oooo00<0jn_[01PH603Ogml0;03o
ool00`3?of00oooo0?ooo`0V0?ooo`03063ojP3oool0oooo01l0oooo00<0
oh>90?ocm03oool0;03oool00`1`om<0noon0?ooo`0d0?ooo`030;Go/`2^
oj/0oooo05L0oooo00<0nogo08o?o`3cn_l0>`3oool01@3akn80h=oS0>3O
h`3Pgn<0LFmT0080h=oS00<0W9bN0?ooo`3Pgn<06`3Pgn=b0:F//P80h=oS
00P0W9bN0?ooo`3Pgn<0h=oS0?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1V
IWh0nocm0:RY^`1VIWh0LFmT00D0oooo00<0Ogmo0?ooo`3oool0?`3oool0
0`3?of00oooo0?ooo`0V0?ooo`03063ojP3oool0oooo01l0oooo00<0oo_k
0?moQP3oool0;03oool00`2conL0ZooU0?ooo`0e0?ooo`0307coN03coo<0
oooo05L0oooo00@0nogo07C3o`2[fol0nogo>@3oool01@3akn80h=oS0>3O
h`3Pgn<0LFmT0080h=oS00<0W9bN0?ooo`3Pgn<06`3Pgn<00`2U[;80oooo
0?ooo`1^0?ooo`050:F//P3Pgn<0h=oS09bLWP3oool00P3Pgn<0103akn80
IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I0050?oo
o`0307moO`3oool0oooo03l0oooo00<0comP0?ooo`3oool02@3oool00`3o
jhl0oooo0?ooo`0J0?ooo`03063ojP3oool0oooo0200oooo00<0ogn60?oo
o`3oool0;03oool00`1homD0look0?ooo`0d0?ooo`030?_on`2Cohl0looc
05T0oooo00<0/mko07c6o`3cn_l0>03oool01@3akn80h=oS0>3Oh`3Pgn<0
LFmT0080h=oS00<0W9bN0?ooo`3Pgn<06`3Pgn<00`2U[;80oooo0?ooo`1^
0?ooo`050:F//P3Pgn<0h=oS09bLWP3oool00P3Pgn<0103akn80IVIn0:RY
^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I0050?ooo`0307mo
O`3oool0oooo03l0oooo00<0comP0?ooo`3oool02@3oool00`3ohf00oooo
0?ooo`0J0?ooo`03063ojP3oool0oooo0200oooo00<0oh>90?ocm03oool0
;03oool00`3kooh0N?oE0?_ooP0e0?ooo`030?_on`1logP0nook05T0oooo
00<0nogo08o?o`3cn_l0=`3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080
h=oS00<0W9bN0?ooo`3Pgn<03P3Pgn<2000000/0h=oS00<0YJbb0?ooo`3o
ool0KP3oool01@2U[;80h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IV
OP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@01@3oool0
0`1oOgl0oooo0?ooo`0o0?ooo`030<ooH03oool0oooo00T0oooo00<0on=P
0?ooo`3oool0603oool0203oooL0oonG0>?o<03oo`@0ool00?oo:03ooh/0
oooc7@3oool00`3ono/0ogn60?ooo`0]0?ooo`030;?oi`2[onD0oooo03D0
oooo00<0]Onc0:koZ`3oool0F@3oool0203koOl0Sloo0>oho`1haOl039Ko
00RDo`1``Ol0lo[o<@3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS
00<0W9bN0?ooo`3Pgn<03@3Pgn<010000000h=oS0>3Oh`00000:0>3Oh`03
0:F//P3oool0oooo06h0oooo00D0YJbb0>3Oh`3Pgn<0W9bN0?ooo`020>3O
h`040?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0
LFmT00D0oooo00<0Ogmo0?ooo`3oool0?`3oool00`3?of00oooo0?ooo`09
0?ooo`030?oSH03oool0oooo01L0oooo00<0oooO0?oo:03oo`001@3oo`00
0`3oob@0oooO0?ooo`0L0?ooo`030?m`M`3ono/0oooo02d0oooo00<0J?o@
0?ooo`3oool0=@3oool00`1logP0looc0?ooo`1I0?ooo`030?_mo`13[_l0
097o00<0097o00<0L<7o0?ooo`3oool0;`3oool01@3akn80h=oS0>3Oh`3P
gn<0LFmT0080h=oS00<0W9bN0?ooo`3Pgn<02P3Pgn<2000000050>3Oh`00
0000h=oS0>3Oh`0000002P3Pgn<00`2U[;80oooo0?ooo`1^0?ooo`050:F/
/P3Pgn<0h=oS09bLWP3oool00P3Pgn<0103akn80IVIn0:RY^`3ko?d10?oo
o`0000D0IVIn0?_lo@2XZK/0IVIn075_I0050?ooo`0307moO`3oool0oooo
03l0oooo00<0comP0?ooo`3oool02@3oool00`3ohf00oooo0?ooo`0F0?oo
o`030?oom`3oobP0ool000L0ool000<0oolT0?ool`3oool06`3oool00`3o
/kL0oj^_0?ooo`0]0?ooo`030;ooj`2_onH0oooo03D0oooo00L0nook097o
S@1fog805?l<013o201dog00looc05H0oooo00<039Ko002Ao`00TOl00P00
TOl00`08U?l0oooo0?ooo`0_0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@0
0P3Pgn<00`2LW9h0oooo0>3Oh`0:0>3Oh`040000003Pgn<0h=oS00000080
h=oS00<000000>3Oh`3Pgn<0203Pgn<00`2U[;80oooo0?ooo`1D0?ooo`D0
00000P3oool00`000000oooo0?ooo`03000000<0oooo0`0000070?ooo`05
0:F//P3Pgn<0h=oS09bLWP3oool00P3Pgn<0103akn80IVIn0:RY^`3ko?d1
0?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I0050?ooo`0307moO`3oool0
oooo03l0oooo00<0gOn?0?ooo`3oool02@3oool00`3ohf00oooo0?ooo`0F
0?ooo`090?ooU`3oo`00ool00?_o0`1hogD03?oC00SoeP1`og`0lol:0080
ool000<0oon?0?ooo`3oool06`3oool00`3oK7<0oooo0?ooo`0]0?ooo`03
07ooe`3coo/0oooo03D0oooo00<0N_mf00So0008o`000P08o`000`1dog00
oooo0?ooo`1D0?ooo`0300bFo`00TOl0097o0080097o00<029Co0?ooo`3o
ool0;`3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00<0W9bN0?oo
o`3Pgn<02P3Pgn<010000000h=oS0>3Oh`0000020>3Oh`030000003Pgn<0
h=oS00P0h=oS00<0YJbb0?ooo`3oool0E@3oool00`000000oooo0?ooo`05
0?ooo`070000003oool0oooo0?ooo`000000oooo000000030?ooo`030000
003oool0oooo00@0oooo00D0YJbb0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`04
0?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT
00D0oooo00<0Ogmo0?ooo`3oool0B`3oool00`3ohf00oooo0?ooo`0F0?oo
o`040?oo=03oo`00ool007SoM@@00?oM00@0L?ml0?oo003oo`00ool/7@3o
ool00`3oPhT0oo?d0?ooo`0]0?ooo`030?_ooP2?om`0look03D0oooo00<0
5?l<00So0008o`000P08o`000`0@o`P0oooo0?ooo`1D0?ooo`0307S5o`00
TOl0097o0080097o00<0?jco0??jo`3oool0;`3oool01@3akn80h=oS0>3O
h`3Pgn<0LFmT0080h=oS00<0W9bN0?ooo`3Pgn<02`3Pgn<00`000000h=oS
000000020>3Oh`030000003Pgn<0h=oS00P0h=oS00<0YJbb0?ooo`3oool0
EP3oool00`000000oooo0?ooo`040?ooo`050000003oool0oooo0?ooo`00
00001@3oool00`000000oooo0?ooo`040?ooo`050:F//P3Pgn<0h=oS09bL
WP3oool00P3Pgn<0103akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_l
o@2XZK/0IVIn075_I0050?ooo`0307moO`3oool0oooo04/0oooo00<0on=P
0?ooo`3oool05P3oool0103oo`@0ool00?oo000<om<4003og@0400SoeP3o
o`00ool00?oo01d0oooo00<0oo_k0?moQP3oool0;P3oool00`3kooh0SooL
0??on`0d0?ooo`0301Co3008o`002?l000802?l000<04?l80?ooo`3oool0
E03oool0203koOl0N<Go00bFo`08U?l0L<7o0>oho`2?col0lo[o;`3oool0
1@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00<0W9bN0?ooo`3Pgn<02`3P
gn<00`000000h=oS0>3Oh`02000000/0h=oS00<0YJbb0?ooo`3oool0E`3o
ool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`000000
1@3oool00`000000oooo0?ooo`040?ooo`050:F//P3Pgn<0h=oS09bLWP3o
ool00P3Pgn<0103akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2X
ZK/0IVIn075_I0050?ooo`0307moO`3oool0oooo04/0oooo00<0on=P0?oo
o`3oool05P3oool0103oo`@0ool00?oo000<om<4003og@0400SoeP3oo`00
ool00?oo01h0oooo00<0ogn60?ooo`3oool0;P3oool00`3kooh0N?oE0?_o
oP0c0?ooo`0307coN008o`002?l000802?l000<0Kom[0?ooo`3oool0FP3o
ool0103koOl0OlSo08?:o`3cn_l]0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1a
Kf@00P3Pgn<00`2LW9h0oooo0>3Oh`0:0>3Oh`<000003P3Pgn<00`2U[;80
oooo0?ooo`1H0?ooo`030000003oool0oooo00<0oooo0`0000020?ooo`@0
00001`3oool01@2U[;80h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IV
OP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@01@3oool0
0`1oOgl0oooo0?ooo`1;0?ooo`030?oSH03oool0oooo01H0oooo00@0oold
0?oo003oo`00N?me1000omd0101`og`0ool00?oo003oob`N0?ooo`030?n3
R@3olo@0oooo02l0oooo00<0/ooW0:_oi@3oool0<P3oool01`3koo/0O?mh
01Co300@o`P0L_m^08coR03coo<0G@3oool0103koOl0M<?o0:_Ko`3koOl[
0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<00`2LW9h0oooo0>3O
h`0;0>3Oh`030000003Pgn<0h=oS00d0h=oS00<0YJbb0?ooo`3oool0F03o
ool00`000000oooo0?ooo`020?ooo`070000003oool0oooo0?ooo`000000
oooo0000000:0?ooo`050:F//P3Pgn<0h=oS09bLWP3oool00P3Pgn<0103a
kn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I005
0?ooo`0307moO`3oool0oooo04/0oooo00<0on=P0?ooo`3oool05P3oool0
2@3ooiL0ool00?oo003ko`<0N?me00cod`08omH0L?ml0??o2P020?oo0003
0?ooS`3oool0oooo01`0oooo00<0oo_k0?moQP3oool0<03oool00`1Toll0
noon0?ooo`0f0?ooo`030?_on`2Cohl0looc05h0oooo00<0/mko07c6o`3c
n_l0:P3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00<0W9bN0?oo
o`3Pgn<0303Pgn<00`000000h=oS0>3Oh`0<0>3Oh`030:F//P3oool0oooo
05@0oooo00D000000?ooo`3oool0oooo000000040?ooo`050000003oool0
oooo0?ooo`0000000P3oool00`000000oooo0?ooo`070?ooo`050:F//P3P
gn<0h=oS09bLWP3oool00P3Pgn<0103akn80IVIn0:RY^`3ko?d10?ooo`00
00D0IVIn0?_lo@2XZK/0IVIn075_I0050?ooo`0307moO`3oool0oooo04/0
oooo0P3oiW0G0?ooo`030?oom`3oobP0ool000L0ool000<0oolT0?ool`3o
ool07P3oool00`3oPhT0oo?d0?ooo`0_0?ooo`030;?oi`2[onD0oooo03L0
oooo00<0nook08_oQ`3`onl0GP3oool00`3koOl0Sloo0??jo`0Y0?ooo`05
0?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<00`2LW9h0oooo0>3Oh`0K0>3O
h`030:F//P3oool0oooo05D0oooo0`0000060?ooo`<000000`3oool40000
00H0oooo00D0YJbb0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`040?7_hP1VIWh0
Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT00D0oooo00<0
Ogmo0?ooo`3oool0C03oool00`3oj7l0oooo0?ooo`0F0?ooo`030?oog`3o
obP0ool000D0ool000<0oolT0?oog`3oool07`3oool00`3ono/0ogn60?oo
o`0`0?ooo`0307Soe@3coo/0oooo03L0oooo00<0looc077oK03koo/0GP3o
ool0103koOl0M<?o0:_Ko`3koOlW0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1a
Kf@00P3Pgn<00`2LW9h0oooo0>3Oh`0K0>3Oh`030:F//P3oool0oooo06h0
oooo00D0YJbb0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`040?7_hP1VIWh0Z:Vk
0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT00D0oooo00<0Ogmo
0?ooo`3oool0C03oool00`3ohf00oooo0?ooo`0G0?ooo`080?oom`3ooiL0
oolh0?oo203oo`00i?lX0?ooS`3ooo<Q0?ooo`060?okn`3o=d40o`/G0?l8
5@3oL7L0oo?d;@3oool00`3kooh0SooL0??on`0h0?ooo`030;Go/`2^oj/0
oooo05l0oooo00@0/mko06c0o`2cg_l0nogo9@3oool01@3akn80h=oS0>3O
h`3Pgn<0LFmT0080h=oS00<0W9bN0?ooo`3Pgn<06`3Pgn<00`2U[;80oooo
0?ooo`1^0?ooo`050:F//P3Pgn<0h=oS09bLWP3oool00P3Pgn<0103akn80
IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I0050?oo
o`0307moO`3oool0oooo04`0oooo00<0onQo0?ooo`3oool0703oool00`1d
on`0loom0?ooo`0Q0?ooo`030?mhO`3o00d0o`0=0080o`0=00<0og1g0?oo
o`3oool0;03oool00`3kooh0N?oE0?_ooP0h0?ooo`03067oG02^oj/0nook
0600oooo00<0_n?o07o8o`3cn_l0903oool01@3akn80h=oS0>3Oh`3Pgn<0
LFmT0080h=oS00<0W9bN0?ooo`3Pgn<06`3Pgn<00`2U[;80oooo0?ooo`1^
0?ooo`050:F//P3Pgn<0h=oS09bLWP3oool00P3Pgn<0103akn80IVIn0:RY
^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I0050?ooo`0307mo
O`3oool0oooo04`0oooo00<0on=P0?ooo`3oool0703oool00`3kooh0Ooo^
0?ooo`0Q0?ooo`030?l<603o00d0o`0=0080o`0=00<0o`PE0?ooo`3oool0
;@3oool00`2conL0ZooU0?ooo`0h0?ooo`030;Go/`20og`0looc0600oooo
00@0nogo07C3o`2[fol0nogo8P3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT
0080h=oS00<0W9bN0?ooo`3Pgn<06`3Pgn<00`2U[;80oooo0?ooo`1^0?oo
o`050:F//P3Pgn<0h=oS09bLWP3oool00P3Pgn<0103akn80IVIn0:RY^`3k
o?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I0050?ooo`0307moO`3o
ool0oooo04`0oooo00<0onQo0?ooo`3oool07@3oool00`1oonh0oooo0?oo
o`0P0?ooo`030?l<603o00d0o`0=0080o`0=00<0o`PE0?ooo`3oool0;P3o
ool00`1homD0look0?ooo`0h0?ooo`030?_on`2Cohl0looc0640oooo00@0
/mko06Blo`2[fol0nogo803oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080
h=oS00<0W9bN0?ooo`3Pgn<06`3Pgn<00`2U[;80oooo0?ooo`1^0?ooo`05
0:F//P3Pgn<0h=oS09bLWP3oool00P3Pgn<0103akn80IVIn0:RY^`3ko?d1
0?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I0050?ooo`0307moO`3oool0
oooo04`0oooo00<0onV30?oml`3oool07@3oool00`1oonh0oooo0?ooo`0P
0?ooo`030?mhO`3o00d0o`0=0080o`0=00<0og1g0?ooo`3oool0;P3oool0
0`3kooh0SooL0??on`0i0?ooo`030?_on`2Cohl0looc0680oooo00<0/mko
06Blo`3?j_l07`3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00<0
W9bN0?ooo`3Pgn<06`3Pgn=b0:F//P80h=oS00P0W9bN0?ooo`3Pgn<0h=oS
0?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT
00D0oooo00<0Ogmo0?ooo`3oool0C03oool00`3oo_/0onQo0?ooo`0M0?oo
o`80L?o/8@3oool01P3ono/0ogQo0?l<603o21D0oc4k0?ocm340oooo00<0
noon07Coe03good0>@3oool00`3koo/0Ton?0??ol`1R0?ooo`040?_mo`27
bol0Pl[o0?Oload0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`03
09bLWP3oool0h=oS08l0h=oS00P0W9bN0?ooo`3Pgn<0h=oS0?7_hP1VIWh0
Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT00D0oooo00<0
Ogmo0?ooo`3oool0C@3oool00`3oj7l0oooo0?ooo`0M0?ooo`0307ookP3o
ool0oooo02<0oooo00<0oh>90?ocm03oool0<@3oool00`3?oo00PooI0?oo
o`0i0?ooo`030?_on`2Cohl0looc06<0oooo00<0cn[o062jo`3?j_l0703o
ool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00<0W9bN0?ooo`3Pgn<0
S`3Pgn<0202LW9h0oooo0>3Oh`3Pgn<0lNoR06IVOP2XZK/0nocm0@3oool0
000506IVOP3ko?d0Z:Vk06IVOP1aKf@01@3oool00`1oOgl0oooo0?ooo`1=
0?ooo`030?oXO`3oool0oooo01d0oooo00<0Poo^0??oo@3oool08`3oool0
0`3ono/0ogn60?ooo`0b0?ooo`0308OofP3?oo00oooo03T0oooo00@0nook
07SoM02^oj/0nookHP3oool0103koOl0Ql_o08?:o`3go?lJ0?ooo`050?7_
hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<00`2LW9h0oooo0>3Oh`2?0>3Oh`08
09bLWP3oool0h=oS0>3Oh`3akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn
0?_lo@2XZK/0IVIn075_I0050?ooo`0307moO`3oool0oooo04d0oooo00<0
onQo0?ooo`3oool07@3oool00`3kooh0Ooo^0?ooo`0T0?ooo`030?n3R@3o
lo@0oooo0340oooo00<0noon07Soe@3coo/0>`3oool00`2eok<0JOmT0?_o
n`1S0?ooo`030<oZo`1P^_l0cn[o01T0oooo00D0lNoR0>3Oh`3Pgn<0h=oS
075_I0020>3Oh`0309bLWP3oool0h=oS08l0h=oS00P0W9bN0?ooo`3Pgn<0
h=oS0?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0
LFmT00D0oooo00<0Ogmo0?ooo`3oool0C@3oool00`3ojH<0oogc0?ooo`0N
0?ooo`0307ookP3oool0oooo02<0oooo00<0oo_k0?n?U@3olo@0<P3oool0
0`3kooh0SooL0??on`0k0?ooo`030;Go/`2^oj/0oooo06<0oooo00@0nogo
08O;o`23b_l0moco5`3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS
00<0W9bN0?ooo`3Pgn<0S`3Pgn<0202LW9h0oooo0>3Oh`3Pgn<0lNoR06IV
OP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@01@3oool0
0`1oOgl0oooo0?ooo`1=0?ooo`030?onn`3oj7l0oooo01h0oooo00<0Poo^
0??oo@3oool0903oool00`3ono/0ogn60?ooo`0b0?ooo`030?_ooP2?om`0
look03/0oooo00<0HOmL0=7oc`3oool0I03oool00`3?j_l0H;[o0<oZo`0F
0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<00`2LW9h0oooo0>3O
h`2?0>3Oh`0809bLWP3oool0h=oS0>3Oh`3akn80IVIn0:RY^`3ko?d10?oo
o`0000D0IVIn0?_lo@2XZK/0IVIn075_I0050?ooo`0307moO`3oool0oooo
04h0oooo00<0onQo0?ooo`3oool07@3oool00`3kooh0Ooo^0?ooo`0U0?oo
o`030?n3R@3olo@0oooo0380oooo00<0noon08oog03coo/0>P3oool0103k
oo/0Ron708OoP`3gooMT0?ooo`040?_mo`27bol0Pl[o0?Oloa@0oooo00D0
lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0309bLWP3oool0h=oS08l0h=oS
00P0W9bN0?ooo`3Pgn<0h=oS0?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1V
IWh0nocm0:RY^`1VIWh0LFmT00D0oooo00<0Ogmo0?ooo`3oool0CP3oool0
0`3oj7l0oooo0?ooo`0N0?ooo`0308?okP3cood0oooo02@0oooo00<0oo_k
0?mhO`3ono/0<`3oool00`3kooh0M?oD0?Ooo@0k0?ooo`030=7oc`1logP0
looc06D0oooo00<0cn[o062jo`3?j_l01`3oool00`33iOl0joKo0?ooo`09
0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<00`2LW9h0oooo0>3O
h`2?0>3Oh`0809bLWP3oool0h=oS0>3Oh`3akn80IVIn0:RY^`3ko?d10?oo
o`0000D0IVIn0?_lo@2XZK/0IVIn075_I0050?ooo`0307moO`3oool0oooo
04h0oooo00<0onV30?oml`3oool07P3oool00`3kooh0Ooo^0?ooo`0U0?oo
o`030?nc]`3oZjl0oooo03<0oooo00<0coo`08?of@3oool0>`3oool00`3k
oo/0Ton?0??ol`1U0?ooo`040?_mo`27bol0Pl[o0?Olo`D0oooo00<0^n;o
032Vo`3[m_l02@3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00<0
W9bN0?ooo`3Pgn<01P3Pgn<3000000<0h=oS0`0000020>3Oh`050000003P
gn<0h=oS0>3Oh`0000000P3Pgn<2000000050>3Oh`000000h=oS0000003P
gn<00P000000103Pgn<000000>3Oh`3Pgn<300000080h=oS00D000000>3O
h`3Pgn<0h=oS000000020>3Oh`<00000F`3Pgn<0202LW9h0oooo0>3Oh`3P
gn<0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1a
Kf@01@3oool00`1oOgl0oooo0?ooo`1>0?ooo`030?onn`3oj7l0oooo01l0
oooo00<0Ooo^0?ooo`3oool09@3oool00`3oK7<0oooo0?ooo`0c0?ooo`03
08OofP3?oo00oooo03/0oooo00<0nook07SoM03Aoll0IP3oool0103?j_l0
H;[o09?@o`3_n?l30?ooo`040>_fo`00TOl0<:Ko0>_fo`P0oooo00D0lNoR
0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0309bLWP3oool0h=oS00D0h=oS00L0
00000>3Oh`3Pgn<0h=oS0000003Pgn<0000000<0h=oS00<000000>3Oh`00
00000`3Pgn<00`000000h=oS000000020>3Oh`80000000@0h=oS0000003P
gn<000000P3Pgn<00`000000h=oS000000030>3Oh`030000003Pgn<00000
00<0h=oS00<000000>3Oh`0000000`3Pgn<00`000000h=oS0>3Oh`1H0>3O
h`0809bLWP3oool0h=oS0>3Oh`3akn80IVIn0:RY^`3ko?d10?ooo`0000D0
IVIn0?_lo@2XZK/0IVIn075_I0050?ooo`0307moO`3oool0oooo04l0oooo
00<0onQo0?ooo`3oool07P3oool00`23onh0loom0?ooo`0U0?ooo`030?n3
R@3olo@0oooo03<0oooo00<0noon063ocP37onh0?03oool0103koo/0Ron7
08OoP`3gooMV0?ooo`040<oZo`1haOl0K<3o0<OWo`80oooo00@019?o002A
o`0`Y_l0joKo1`3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00<0
W9bN0?ooo`3Pgn<0103Pgn<00`000000h=oS0>3Oh`040>3Oh`070000003P
gn<0h=oS0>3Oh`000000h=oS000000030>3Oh`030000003Pgn<0000000<0
h=oS00D000000>3Oh`000000h=oS000000020>3Oh`030000003Pgn<00000
00<0h=oS00<000000>3Oh`0000000`3Pgn<00`000000h=oS0>3Oh`020>3O
h`030000003Pgn<0h=oS05T0h=oS00P0W9bN0?ooo`3Pgn<0h=oS0?7_hP1V
IWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT00D0oooo
00<0Ogmo0?ooo`3oool0C`3oool00`3oj7l0oooo0?ooo`0N0?ooo`030?_o
oP1oonh0oooo02D0oooo00<0oo_k0?mlP`3oool0=@3oool00`2Goml0PooI
0??on`0l0?ooo`040=7oc`1Uof00[_n[0?_onfH0oooo00D0lo[o09oFo`1X
__l0enko01bMo`02002Ao`03032Vo`3_n?l0oooo00D0oooo00D0lNoR0>3O
h`3Pgn<0h=oS075_I0020>3Oh`0309bLWP3oool0oooo00<0oooo00<0h=oS
0000003Pgn<01@3Pgn<01`000000h=oS0>3Oh`3Pgn<000000>3Oh`000000
0`3Pgn<00`000000h=oS000000030>3Oh`050000003Pgn<000000>3Oh`00
00000P3Pgn<00`000000h=oS000000030>3Oh`030000003Pgn<0000000<0
h=oS00<000000>3Oh`3Pgn<00P0000040>3OheP0oooo00P0W9bN0?ooo`3P
gn<0h=oS0?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1V
IWh0LFmT00D0oooo00<0Ogmo0?ooo`3oool0C`3oool00`3ojH<0oogc0?oo
o`0O0?ooo`0308?okP3cood0oooo02D0oooo00<0oko20?n_/`3oool0=@3o
ool00`3Coo40G?o=0?Ooo@0m0?ooo`030;Go/`20og`0looc06L0oooo00<0
nogo07S5o`0bYol00`00TOl00`0lZol0ioGo0?ooo`040?ooo`050?7_hP3P
gn<0h=oS0>3Oh`1aKf@00P3Pgn<609bLWP030>3Oh`000000h=oS00D0h=oS
00H000000>3Oh`3Pgn<0h=oS0000003Pgn<200000080h=oS00<000000>3O
h`0000000P3Pgn<2000000040>3Oh`000000h=oS00000080h=oS00<00000
0>3Oh`0000000`3Pgn<010000000h=oS0000000000020>3Oh`030000003P
gn<0000000<0h=oS00<000000>3Oh`3Pgn<0F@2LW9h01`3oool0h=oS0>3O
h`3akn80IVIn0:RY^`3ko?d00@3oool0000506IVOP3ko?d0Z:Vk06IVOP1a
Kf@01@3oool00`1oOgl0oooo0?ooo`1>0?ooo`060?onn`3oigH0om<60?oC
203oiW00oogc7@3oool00`3kooh0Soo`0??oo@0V0?ooo`030?moQP3olo@0
oooo03D0oooo00<0coo`08?of@3oool0?@3oool00`3koo/0Ton?0??ol`1V
0?ooo`030>_fo`23b_l03IOo00@0097o00<0<:Ko0>_fo`3oool00`3oool0
1@3akn80h=oS0>3Oh`3Pgn<0LFmT00T0h=oS00<000000>3Oh`3Pgn<01@3P
gn<300000080h=oS00@000000>3Oh`00000000000`3Pgn<2000000030>3O
h`000000h=oS00@0000000@0h=oS0000003Pgn<0h=oS0`0000020>3Oh`04
0000003Pgn<00000000000<0h=oS0`00001O0>3Oh`040?7_hP1VIWh0Z:Vk
0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT00D0oooo00<0Ogmo
0?ooo`3oool04`3oool00`2UojD0oooo0?ooo`0h0?ooo`030?oWN03odP00
om800080om8000<0onI`0?ooo`3oool0703oool00`3kooh0Ooo^0?ooo`0U
0?ooo`030?okn`3oN7l0oo_k03H0oooo00<0QooJ0<ool03oool0?@3oool0
0`3koo/0N?md0=7oc`1S0?ooo`030>?co`1d`ol039Ko00L0097o00<0<:Ko
0>oho`3oool00P3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT00X0h=oS00D0
00000>3Oh`3Pgn<0h=oS0000000A0>3Oh`050000003Pgn<0h=oS0>3Oh`00
0000L`3Pgn<0103akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2X
ZK/0IVIn075_I0050?ooo`0307moO`3oool0oooo01<0oooo00<0P?n00?oo
o`3oool0>03oool00`3oe0`0om800?oB00020?oB00030?oC203oool0oooo
01d0oooo00<0Ooo^0?ooo`3oool09@3oool00`3o/kL0oj^_0?ooo`0e0?oo
o`030?_ooP1homD0look03h0oooo00@0nook08_oQ`27oh<0moogH03oool0
0`2Ke?l089oo002Ao`09002Ao`0504B^o`3cn_l0oooo0?ooo`3akn800`3P
gn<00`1aKf@0h=oS0>3Oh`090>3Oh`<000004P3Pgn<01@000000h=oS0000
003Pgn<000000080h=oS00<000000>3Oh`3Pgn<0KP3Pgn<0103akn80IVIn
0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I0050?ooo`03
07moO`3oool0oooo01<0oooo00<0P?n00?ooo`3oool0>03oool00`3oe0`0
om800?oB00020?oB00030?oC203oool0oooo01d0oooo00<0Poo^0??oo@3o
ool09P3oool00`3oN7l0oo?d0?ooo`0e0?ooo`030?_ooP2?om`0look03l0
oooo00<0dOo?06GoH03Aoll0H@3oool01@3OlOl0]n3o07o8o`18/?l089oo
00H0097o00@0?jco0>oho`3oool0lNoR0`3Pgn<00`1aKf@0h=oS0>3Oh`2F
0>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1V
IWh0LFmT00D0oooo00<0Ogmo0?ooo`3oool04`3oool00`20oh00oooo0?oo
o`0h0?ooo`030?oWN03odP00om800080om8000<0onI`0?ooo`3oool07@3o
ool00`3kooh0Ooo^0?ooo`0V0?ooo`030?okn`3oSiD0oo?d03H0oooo00<0
noon08?of@3_ooX0?`3oool0103koo/0Ron708OoP`3gooMT0?ooo`050>Oe
o`2ohol0OlSo05Rgo`0PWol00P00TOl00`0HVol0/mko0?7_hP030>3Oh`03
075_I03Pgn<0h=oS09H0h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool00005
06IVOP3ko?d0Z:Vk06IVOP1aKf@01@3oool00`1oOgl0oooo0?ooo`0C0?oo
o`03083oP03oool0oooo03P0oooo00H0ookk0?oWN03oe0`0om840?oUJ`3o
oO<P0?ooo`0307Sok@3_ood0oooo02H0oooo00<0oo_k0?n?U@3olo@0=P3o
ool00`3coo/0N?oE0>_on@100?ooo`030=7oc`1hog@0k?o[06P0oooo00D0
ioGo0;oSo`23bOl0Hkco0?7_hP030>3Oh`03075_I03Pgn<0h=oS09H0h=oS
00@0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1a
Kf@01@3oool00`1oOgl0oooo0?ooo`0C0?ooo`03083oP03oool0oooo03/0
oooo00<0ookk0?oXO`3oool0803oool00`3cood0L?o/0?_ooP0W0?ooo`03
0?okn`3oSiD0oo?d03H0oooo00<0moom07Soe@3[ooT0@03oool00`3gooL0
O?mh0>coj`1[0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@0V03Pgn<0103a
kn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I005
0?ooo`0307moO`3oool0oooo01<0oooo00<0P?n00?ooo`3oool0?03oool0
0`3oiW@0oogc0?ooo`0P0?ooo`030;?om@2[oo@0oooo02L0oooo00<0oo_k
0?mhO`3ono/0=P3oool00`3good0RooK0??on`100?ooo`030?Oom`1dog00
k?o[06X0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I02H0>3Oh`040?7_hP1V
IWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT00D0oooo
00<0Ogmo0?ooo`3oool04`3oool00`20oh00oooo0?ooo`0l0?ooo`030?on
n`3oj7l0oooo0240oooo00<0K?o[0?ooo`3oool09`3oool00`3o/kL0oj^_
0?ooo`0f0?ooo`030?_ooP2?om`0look0400oooo00<0l?o_06goJ03Aoll0
J@3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT09P0h=oS00@0lNoR06IVOP2X
ZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@01@3oool00`1o
Ogl0oooo0?ooo`0C0?ooo`03083oP03oool0oooo03d0oooo00<0onQo0?oo
o`3oool0803oool00`1`on`0noon0?ooo`0X0?ooo`030?mhO`3olo@0oooo
03H0oooo00<0noon08oog03coo/0@03oool0103koo/0Ron708OoP`3gooMW
0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@0V03Pgn<0103akn80IVIn0:RY
^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I0050?ooo`0307mo
O`3oool0oooo01<0oooo00<0P?n00?ooo`3oool0?@3oool00`3ojH<0oogc
0?ooo`0P0?ooo`030;?om@2[oo@0oooo02P0oooo00<0oo_k0?n?U@3olo@0
=`3oool00`3kooh0SooL0??on`110?ooo`030=7oc`1Uof00dOo?06H0oooo
00D0lNoR0>3Oh`3Pgn<0h=oS075_I02H0>3Oh`040?7_hP1VIWh0Z:Vk0?_l
o@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT00D0oooo00<0Ogmo0?oo
o`3oool04`3oool00`20oh00oooo0?ooo`0m0?ooo`030?onn`3oj7l0oooo
0240oooo00<0N?o]0??oo@3oool0:03oool00`3ono/0ohnE0?ocm00g0?oo
o`030?_ooP2?om`0look0440oooo00@0nook08_oQ`27oh<0moogI03oool0
1@3akn80h=oS0>3Oh`3Pgn<0LFmT09P0h=oS00@0lNoR06IVOP2XZK/0nocm
0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@01@3oool00`1oOgl0oooo
0?ooo`0C0?ooo`03083oP03oool0oooo03h0oooo00<0onQo0?ooo`3oool0
803oool00`3kooh0Soo`0??oo@0Y0?ooo`030?okn`3oN7l0oo_k03L0oooo
00<0noon08oog03coo/0@P3oool00`3Aoll0IOmP0=7oc`1S0?ooo`050?7_
hP3Pgn<0h=oS0>3Oh`1aKf@0V03Pgn<0103akn80IVIn0:RY^`3ko?d10?oo
o`0000D0IVIn0?_lo@2XZK/0IVIn075_I0050?ooo`0307moO`3oool0oooo
01<0oooo00<0VOnI0?ooo`3oool0?P3oool00`3oiW00ookk0?ooo`0Q0?oo
o`030?_ooP1hond0noon02T0oooo00<0ok>g0?n[[`3oool0=`3oool00`3k
ooh0SooL0??on`120?ooo`040?_on`2;ohL0Qon30?Oomf40oooo00D0lNoR
0>3Oh`3Pgn<0h=oS075_I0020>3Ohi@0oooo0P3Pgn<0103akn80IVIn0:RY
^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I0050?ooo`0307mo
O`3oool0oooo01<0oooo00<0P?n00?ooo`3oool0?P3oool00`3ol[<0oo2[
0?ooo`0R0?ooo`030;?om@2[oo@0oooo02T0oooo00<0ogQo0?ocm03oool0
=`3oool00`3kooh0SooL0??on`130?ooo`030=7oc`1Uof00dOo?0600oooo
00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Ohi<0W9bN00L0oooo0>3Oh`3P
gn<0lNoR06IVOP2XZK/0nocm0040oooo00001@1VIWh0nocm0:RY^`1VIWh0
LFmT00D0oooo00<0Ogmo0?ooo`3oool04`3oool00`2Loi`0mOoe0?ooo`0o
0?ooo`030?oUK03oo>l0oooo0280oooo00<0N?o]0??oo@3oool0:03oool0
0`3ono/0ohN=0?o[k00h0?ooo`040?_ooP1dom@0ZooU0?_ooT80oooo00@0
nook08_oQ`27oh<0moogGP3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080
h=oS00<0W9bN0?ooo`3Pgn<0S`3Pgn<0202LW9h0oooo0>3Oh`3Pgn<0lNoR
06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@01@3o
ool00`1oOgl0oooo0?ooo`0C0?ooo`030?coo02=ohd0oooo03l0oooo00<0
oogc0?oWN03oool08P3oool00`3kooh0N?o]0?_ooP0Y0?ooo`030?ocm03o
K7<0ono`03T0oooo00<0/ooW07coeP3coo/0@`3oool00`3Aoll0IOmP0=So
e`1M0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<00`2LW9h0oooo
0>3Oh`2?0>3Oh`0809bLWP3oool0h=oS0>3Oh`3akn80IVIn0:RY^`3ko?d1
0?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I0050?ooo`0307moO`3oool0
oooo01@0oooo00<0VOnI0?ooo`3oool0?`3oool00`3oj7l0oooo0?ooo`0R
0?ooo`030;?om@2[oo@0oooo02T0oooo00<0ooOg0?mdN`3ono/0>@3oool0
0`3kooh0SooL0??on`130?ooo`030?_on`1logP0Z_nW05`0oooo00D0lNoR
0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0409bLWP3oool0h=oS0>3Ohh`0Oifi
0P3Pgn<0202LW9h0oooo0>3Oh`3Pgn<0lNoR06IVOP2XZK/0nocm0@3oool0
000506IVOP3ko?d0Z:Vk06IVOP1aKf@01@3oool00`1oOgl0oooo0?ooo`0D
0?ooo`0309WoV@3oool0oooo03l0oooo00<0onV30?oml`3oool08`3oool0
0`1TonX0noon0?ooo`0Y0?ooo`030?nc]`3oZjl0oooo03T0oooo00@0noon
07Coe02[onD0noon@`3oool00`2^oj/0N?md0??ol`1J0?ooo`050?7_hP3P
gn<0h=oS0>3Oh`1aKf@00P3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08X0
h=oS00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`040?7_hP1VIWh0Z:Vk
0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT00D0oooo00<0Ogmo
0?ooo`3oool0503oool00`2IoiT0oooo0?ooo`0o0?ooo`030?onn`3oj7l0
oooo02<0oooo00<0/ooe0:_om03oool0:P3oool00`3oN7l0oo?d0?ooo`0j
0?ooo`030;?oi`1lomH0look04<0oooo00@0g?oK06GoH02^oj/0nookF03o
ool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00D0W9bN0?ooo`3Pgn<0
h=oS07nM^@2:0>3Oh`0507nM^@3Pgn<0h=oS09bLWP3oool00P3Pgn<0103a
kn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I005
0?ooo`0307moO`3oool0oooo01@0oooo00<0VOnI0?ooo`3oool0@03oool0
0`3ojH<0oogc0?ooo`0S0?ooo`0307Sok@3cood0oooo02T0oooo00<0oo_k
0?n?U@3olo@0>`3oool00`3kooh0SooL0??on`140?ooo`040;Go/`1Yof@0
[_n[0?_oneH0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0509bL
WP3oool0h=oS0>3Oh`1oWKT0RP3Pgn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo
0080h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk
06IVOP1aKf@01@3oool00`1oOgl0oooo0?ooo`0D0?ooo`0309WoV@3oool0
oooo0400oooo00<0ookk0?oWN03oo_/08`3oool00`3kooh0N?o]0?_ooP0Z
0?ooo`030?okn`3oSiD0oo?d03/0oooo00L0noon08gog01bom<03?nd00So
/P1`om<0look0440oooo00<0]Onc06WoI03HomL0E@3oool01@3akn80h=oS
0>3Oh`3Pgn<0LFmT0080h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2:0>3O
h`0507nM^@3Pgn<0h=oS09bLWP3oool00P3Pgn<0103akn80IVIn0:RY^`3k
o?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I0050?ooo`0307moO`3o
ool0oooo01@0oooo00<0VOnI0?ooo`3oool0@@3oool00`3ol[<0oo2[0?oo
o`0S0?ooo`030;?om@2[oo@0oooo02X0oooo00<0oo_k0?n?U@3olo@0>`3o
ool00`1fomD00?n`003o/002003o/003073od`3oool0oooo0400oooo00<0
nook07coN02ZojL0E03oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS
00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2:0>3Oh`0507nM^@3Pgn<0h=oS09bL
WP3oool00P3Pgn<0103akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_l
o@2XZK/0IVIn075_I0050?ooo`0307moO`3oool0oooo01@0oooo00<0VOnI
0?ooo`3oool0@P3oool00`3oiF`0oooo0?ooo`0S0?ooo`0306CojP3kooh0
oooo02X0oooo00<0oo_k0?mhO`3ono/0>P3oool00`0<ok@00?n`003o/002
003o/00300So/P3oool0oooo0480oooo00<0[_n[07SoM03coo<0DP3oool0
1@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00D0W9bN0?ooo`3Pgn<0h=oS
07nM^@2:0>3Oh`0507nM^@3Pgn<0h=oS09bLWP3oool00P3Pgn<0103akn80
IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I0050?oo
o`0307moO`3oool0oooo01@0oooo00<0W?nL0?Gom@3oool0@P3oool00`3o
j7l0oooo0?ooo`0S0?ooo`030;?om@2[oo@0oooo02/0oooo00<0ok>g0?n[
[`3oool0>@3oool00`0<ok@00?n`003o/002003o/00300So/P3oool0oooo
04<0oooo00<0g?oK06GoH03HomL0D@3oool01@3akn80h=oS0>3Oh`3Pgn<0
LFmT0080h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2:0>3Oh`0507nM^@3P
gn<0h=oS09bLWP3oool00P3Pgn<0103akn80IVIn0:RY^`3ko?d10?ooo`00
00D0IVIn0?_lo@2XZK/0IVIn075_I0050?ooo`0307moO`3oool0oooo01@0
oooo00<0o?ol09WoV@3oool0@P3oool00`3ojH<0oogc0?ooo`0T0?ooo`03
07Sok@3cood0oooo02/0oooo00<0ogQo0?ocm03oool0>03oool00`1homD0
0?n`003o/002003o/00306_od@3oool0oooo04@0oooo00<0nook07coN02Z
ojL0D03oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00D0W9bN0?oo
o`3Pgn<0h=oS07nM^@2:0>3Oh`0507nM^@3Pgn<0h=oS09bLWP3oool00P3P
gn<0103akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn
075_I0050?ooo`0307moO`3oool0oooo01D0oooo00<0VOnI0?ooo`3oool0
@@3oool00`3oo_/0onMh0?onn`0T0?ooo`030?_ooP1hond0noon02/0oooo
00<0oo_k0?n?U@3olo@0>03oool0203kooh0N?oE00co]008ok80K_oC07Wo
e@1lomH0koojAP3oool00`2^oj/0N?md0??ol`1>0?ooo`050?7_hP3Pgn<0
h=oS0>3Oh`1aKf@00P3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08X0h=oS
00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`040?7_hP1VIWh0Z:Vk0?_l
o@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT00D0oooo00<0Ogmo0?oo
o`3oool05@3oool00`2IoiT0oooo0?ooo`120?ooo`030?ob/`3ol:/0oooo
02@0oooo00<0/ooe0:_om03oool0:`3oool00`3ono/0ohnE0?ocm00m0?oo
o`030??on`23omT0look04H0oooo00@0g?oK067oG02Roil0nookC03oool0
1@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00D0W9bN0?ooo`3Pgn<0h=oS
07nM^@2:0>3Oh`0507nM^@3Pgn<0h=oS09bLWP3oool00P3Pgn<0103akn80
IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I0050?oo
o`0307moO`3oool0oooo01D0oooo00<0VOnI0?ooo`3oool0@`3oool00`3o
iF`0oooo0?ooo`0T0?ooo`0307Sok@3cood0oooo02/0oooo00<0oo_k0?n?
U@3olo@0?@3oool00`3kooh0SooL0??on`170?ooo`030<Go``1]ofP0^Ong
04/0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0509bLWP3oool0
h=oS0>3Oh`1oWKT0RP3Pgn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo0080h=oS
00@0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1a
Kf@01@3oool00`1oOgl0oooo0?ooo`0E0?ooo`0309WoV@3oool0oooo01X0
oooo00/0`l?30=_Kf`3oool0oooo0;Ng]`3Kfm/0oooo0?_kn`2OWil0Ogmo
0;no_`0N0?ooo`030?oVL03oo_/0oooo0180oooo00@0/k>c07moO`2WYjL0
no_k3P3oool00`3kooh0Soo`0??oo@0S0?ooo`060??cl`2[Zj/0oooo0?oo
o`33`l<0clo?0P3oool0102OWil0PGem0>5JH@3omoLa0?ooo`040<o?c`23
Ph<0UiNG0?Ogm`P0oooo00<0noon08oog03coo/09`3oool00`3Kfm/0^k^k
0?ooo`030?ooo`0409nOW`3clo<0oooo0>OWi`80QhN700<0hn?S0?ooo`3o
ool04P3oool01035ol<0KOmX0:koZ`3koo/J0?ooo`0309NGU`1oOgl0]kNg
02/0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0509bLWP3oool0
h=oS0>3Oh`1oWKT0RP3Pgn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo0080h=oS
00@0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1a
Kf@01@3oool00`1oOgl0oooo0?ooo`0E0?ooo`0309WoV@3oool0oooo01X0
oooo00`0H61P09nOW`3oool0oooo071`L02g]kL0oooo03Ph>027QhL0_kno
04Q8B02OWilM0?ooo`030?ob/`3ol:/0oooo0140oooo00D0Ph>305aLG02o
_kl0J6QX06ATI00?0?ooo`030?_ooP1hond0noon0280oooo00`0gmoO020P
803oool0oooo08N7Q`2OWil0oooo04a<C01dM7@0_kno05lo@@38G68`0?oo
o`060:n_[`0h>3P0/k>c07moO`0h>3P0no_k203oool00`3kooh0SooL0??o
n`0V0?ooo`030;Ng]`0l?3`0oooo00<0oooo00P0@4100>OWi`3Kfm/0820P
0:^[Z`2_[jl0;2`/0>OWiaD0oooo00@0]Onc06WoI02^oj/0nook5`3oool0
1@1oOgl0G5aL0;no_`1<C4`0Ogmo02X0oooo00D0lNoR0>3Oh`3Pgn<0h=oS
075_I0020>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0RP3Pgn<01@1oWKT0
h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool0
000506IVOP3ko?d0Z:Vk06IVOP1aKf@01@3oool00`1oOgl0oooo0?ooo`0E
0?ooo`0309WoV@3oool0oooo01X0oooo00<0H61P09nOW`3oool00`3oool0
1P3WinL0M7Ad0?ooo`3oool0lo?c01@D51h0oooo00<0onAT0?onn`3oool0
403oool01P1<C4`0kno_0?ooo`3oool071`L0>OWi`l0oooo00<0/ooe0:_o
m03oool07P3oool01P2o_kl0Ogmo07moO`1`L700410@07moO`<0oooo00L0
kno_061PH03oool0oooo0??cl`1/3140oloA02l0oooo00H0?3`l0;no_`3o
ool0oooo03Ph>037alL90?ooo`040?_ooP1dom@0ZooU0?_ooR@0oooo00<0
kno_01@D503kno/01@3oool01P2c/k<0Vi^K0?ooo`3oool0Ti>C07AdM1L0
oooo00<0]Onc083oO03gooL05P3oool01P2GUiL0inOW0?ooo`3clo<071`L
0?_knbT0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0509bLWP3o
ool0h=oS0>3Oh`1oWKT0RP3Pgn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo0080
h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IV
OP1aKf@01@3oool00`1oOgl0oooo0?ooo`0E0?ooo`0309coW03eooD0oooo
01X0oooo00<0H61P09nOW`3oool0203oool00`000000oooo0?ooo`0L0?oo
o`030?ob/`3ol:/0oooo01<0oooo00<0moOg01PH603WinL0403oool00`1d
on`0koom0?ooo`0M0?ooo`060:NWY`0d=3@0WinO08^;R`0D51@0WinO203o
ool00`000000of1X0?o?d@0^0?ooo`0600P8203Kfm/0oooo0?ooo`10@400
`l?32`3oool00`2conL0O?oF0??on`0T0?ooo`0304A4A02_[jl0oooo00P0
oooo00<0WinO061PH03oool05`3oool00`3gooL0Ton?0??ol`0E0?ooo`06
0>o_k`1XJ6P0@4100:NWY`0h>3P0dm?C:@3oool01@3akn80h=oS0>3Oh`3P
gn<0LFmT0080h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2:0>3Oh`0507nM
^@3Pgn<0h=oS09bLWP3oool00P3Pgn<0103akn80IVIn0:RY^`3ko?d10?oo
o`0000D0IVIn0?_lo@2XZK/0IVIn075_I0050?ooo`0307moO`3oool0oooo
01D0oooo00<0o?ol09WoV@3oool06P3oool00`1PH600WinO0?ooo`030?oo
o`060?Ogm`1@D500clo?0?ooo`1oOgl0A4A47`3oool00`3oigP0oogc0?oo
o`0@0?ooo`040??cl`1hN7P0A4A407alO140oooo00<0moon07Cok03_ood0
7P3oool0101DE5@0^k^k0=oOg`0P82050?ooo`09061PH02k^k/0oooo08N7
Q`10@400oo_k0?n7S@3oPhT0ooOg02`0oooo00H0000005QHF03Ogml0WinO
02@T903clo<<0?ooo`030?_ooP2?om`0look02<0oooo00<0YjNW05QHF03o
ool0103oool01P3Cdm<0H61P0>?Sh`3gmoL0<30`09nOWaT0oooo00<0nook
09?oS`3gooL0503oool01P1DE5@0J6QX0=oOg`27QhL020P80;no_bT0oooo
00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0509bLWP3oool0h=oS0>3O
h`1oWKT0RP3Pgn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR
06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@01@3o
ool00`1oOgl0oooo0?ooo`0F0?ooo`0309WoV@3oool0oooo01L0oooo00@0
emOG0??cl`1PH600WinO1@3oool01@0/;2`0@410020P801HF5P0jn_[01l0
oooo00<0ookk0?oWN03oo_/04@3oool00`3GemL0D51@08>3P`0B0?ooo`03
0??oo@1/on/0noon01d0oooo00@0lo?c0410@03Cdm<0820P1@3oool01@10
@400?3`l020P801<C4`0fm_K0080oooo00<0oloA0?mhO`3olo@0:`3oool0
1@0@4100Zj^[04a<C01LG5`0gmoO00h0oooo00@0noon07Coe02[onD0noon
8@3oool00`3kno/092@T0=OGe`040?ooo`060=oOg`0D51@0>3Ph02@T901l
O7`0no_k6P3oool0103gooL0N?md0:koZ`3koo/B0?ooo`0600P8203kno/0
oooo0?ooo`0P8200alO7:@3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080
h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2:0>3Oh`0507nM^@3Pgn<0h=oS
09bLWP3oool00P3Pgn<0103akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn
0?_lo@2XZK/0IVIn075_I0050?ooo`0307moO`3oool0oooo01H0oooo00<0
VOnI0?ooo`3oool05`3oool0102c/k<0?3`l03@d=02OWil50?ooo`03061P
H02g]kL0oooo0280oooo00<0oo:c0?o`Z`3oool03P3oool01@1oOgl0jn_[
0?ooo`2o_kl0@41001<0oooo00<0/ooe0:_om03oool07@3oool00`2g]kL0
D51@020P80050?ooo`0306a/K02SXj<0oooo00D0oooo00<0oo_k0?n?U@3o
lo@0:P3oool01P1LG5`0]kNg0?ooo`3oool0Rh^;0>o_k`l0oooo00<0/ooW
07Soe@3[ooT08@3oool00`2WYjL0@4100?_kn`030?ooo`030?_kn`0D51@0
oooo01l0oooo00@0]Onc06WoI02^oj/0nook403oool01P0@4100kno_0?oo
o`3oool092@T0?OgmbT0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3O
h`0509bLWP3oool0h=oS0>3Oh`1oWKT0RP3Pgn<01@1oWKT0h=oS0>3Oh`2L
W9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3k
o?d0Z:Vk06IVOP1aKf@01@3oool00`1oOgl0oooo0?ooo`0F0?ooo`0309Wo
V@3oool0oooo01P0oooo00<0emOG01`L702OWil01@3oool01@2;Rh/0B4Q8
07moO`1oOgl0[jn_0240oooo00<0onAT0?onn`3oool03@3oool01@1oOgl0
G5aL0;no_`1<C4`0Ogmo01@0oooo00<0I?oZ0?_ooP3oool07@3oool00`1/
K6`0820P0?ooo`040?ooo`0509nOW`18B4P0Ogmo07moO`2_[jl0103oool0
0`3ono/0ohnE0?ocm00Y0?ooo`060<O7a`0`<300/k>c08^;R`0X:2P0moOg
403oool00`3good0K?oA0>_on@0M0?ooo`060;no_`1oOgl0Ogmo07moO`0H
61P0Rh^;103oool01@10@400N7Qh07moO`1oOgl0gmoO01h0oooo00@0]Onc
06WoI02^oj/0nook3P3oool01@2?Shl0A4A40;no_`1XJ6P0K6a/02X0oooo
00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0509bLWP3oool0h=oS0>3O
h`1oWKT0RP3Pgn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR
06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@01@3o
ool00`1oOgl0oooo0?ooo`0D0?ooo`060?coo02Coi<0>?lh03Wo>@2=ohd0
mOoe603oool20<o?c`D0oooo00D0hn?S09nOW`2OWil0WinO0<?3``0Q0?oo
o`030?ob/`3ol:/0oooo00h0oooo00@0/k>c07moO`2[Zj/0no_k503oool0
0`2oooH0/ooe0?ooo`0M0?ooo`030??cl`2CTi<0oooo00@0oooo00D0hn?S
09nOW`2OWil0WinO0<?3``050?ooo`030?okn`3oSiD0oo?d02T0oooo00@0
fm_K08>3P`23Ph<0kno_4P3oool00`3coo/0K?oA0=Ool`0L0?ooo`030<o?
c`2OWil0WinO0080WinO00<0`l?30?ooo`3oool00P3oool01@2o_kl0WinO
09nOW`2OWil0inOW0200oooo00@0]Onc06WoI02eok<0nook3@3oool00`2o
_kl0Ogmo0:NWY`0[0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<0
1@2LW9h0oooo0>3Oh`3Pgn<0Oifi08X0h=oS00D0Oifi0>3Oh`3Pgn<0W9bN
0?ooo`020>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm
0:RY^`1VIWh0LFmT00D0oooo00<0Ogmo0?ooo`3oool0503oool00`2Coi<0
<olc03?o<`0203?o<`0308goS@3oool0oooo04@0oooo00<0onAT0?onn`3o
ool09P3oool00`1Xon/0moon0?ooo`0^0?ooo`030?okn`3oM7/0ooOg03l0
oooo00<0noon07Soe@2Won@0C03oool00`2ZojL0KOmX0>3og`0j0?ooo`05
0?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0
Oifi08X0h=oS00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`040?7_hP1V
IWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT00D0oooo
00<0Ogmo0?ooo`3oool0503oool00`0mocd0<olc03?o<`0203?o<`0303Wo
>@3oool0oooo04@0oooo00<0oo:c0?o`Z`3oool09P3oool00`3?ooT0Poo^
0?ooo`0_0?ooo`030?o?d@3oPhT0oooo0400oooo00<0ZooU07Coe03coo/0
B`3oool0103gooL0Son;07coN03`onlh0?ooo`050?7_hP3Pgn<0h=oS0>3O
h`1aKf@00P3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08X0h=oS00D0Oifi
0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo
00001@1VIWh0nocm0:RY^`1VIWh0LFmT00D0oooo00<0Ogmo0?ooo`3oool0
503oool00`0mocd0<olc03?o<`0203?o<`0303Wo>@3oool0oooo04D0oooo
00<0onAT0?onn`3oool09P3oool00`27onl0cooi0?ooo`0_0?ooo`030?n7
S@3ocm40oooo0400oooo00<0food063ocP3?oo00C03oool0103XonL0O?mh
09[oU`3`onlf0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<01@2L
W9h0oooo0>3Oh`3Pgn<0Oifi08X0h=oS00D0Oifi0>3Oh`3Pgn<0W9bN0?oo
o`020>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY
^`1VIWh0LFmT00D0oooo00<0Ogmo0?ooo`3oool0503oool00`2Coi<0<olc
03?o<`0203?o<`0308goS@3oool0oooo04D0oooo00<0oo:c0?o`Z`3oool0
9P3oool00`3kooh0N?o]0??oo@0_0?ooo`030?okn`3oG6@0oloA0440oooo
00@0noon08OofP23omT0moomC03oool0103=ol/0HOmL0:koZ`3koo/d0?oo
o`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<01@2LW9h0oooo0>3Oh`3P
gn<0Oifi08X0h=oS00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`040?7_
hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT00D0
oooo00<0Ogmo0?ooo`3oool0503oool01P3loo`0TonC03go?@0eocD0SOn=
0?GomAd0oooo00<0WinO0?ooo`3oool0:03oool00`3oi6@0ookk0?ooo`0=
0?ooo`0309nOW`3oool0oooo01H0oooo00<0noon08ool03cood07P3oool0
0`2OWil0oooo0?ooo`0>0?ooo`040?okn`3oQhd0oh>90?ogmbH0oooo00<0
WinO0?ooo`3oool0603oool00`3?oo00N?oE0?Ooo@0L0?ooo`0309nOW`3o
ool0oooo02h0oooo00@0]Onc06WoI02^oj/0nook1P3oool00`2OWil0oooo
0?ooo`0Y0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<01@2LW9h0
oooo0>3Oh`3Pgn<0Oifi08X0h=oS00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`02
0>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1V
IWh0LFmT00D0oooo00<0Ogmo0?ooo`3oool05`3oool00`2IoiT0oooo0?oo
o`0M0?ooo`0307moO`3oool0oooo02P0oooo00<0oo:c0?o`Z`3oool03@3o
ool00`1oOgl0oooo0?ooo`0G0?ooo`030?_ooP1don`0moon01d0oooo00<0
Ogmo0?ooo`3oool0403oool00`3ocm40oeaT0?ogm`0U0?ooo`0307moO`3o
ool0oooo01T0oooo00<0moom08oog03coo/06`3oool00`1oOgl0oooo0?oo
o`0`0?ooo`040;Go/`1Yof@0[_n[0?_on`@0oooo00<0Ogmo0?ooo`3oool0
:@3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00D0W9bN0?ooo`3P
gn<0h=oS07nM^@2:0>3Oh`0507nM^@3Pgn<0h=oS09bLWP3oool00P3Pgn<0
103akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_
I0050?ooo`0304m?C`1oOgl0Ogmo01L0Ogmo00<0FKmI07moO`1oOgl07@1o
Ogl00`0o?cl0Ogmo07moO`0Y07moO`030<fb<P21P7d0Ogmo00`0Ogmo00<0
?clo07moO`1oOgl0601oOgl00`1WUi40@Kf/07moO`0L07moO`0303lo?`1o
Ogl0Ogmo0140Ogmo00<0UfMY0;e1A`1oOgl0901oOgl00`0o?cl0Ogmo07mo
O`0J07moO`0307f1P017]i@0Nh>101X0Ogmo00<0?clo07moO`1oOgl0<P1o
Ogl00`1KYET0=ldb06bCJ`0307moO`0303lo?`1oOgl0Ogmo02<0Ogmo00<0
WinO0?ooo`3oool00`3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS
00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2:0>3Oh`0507nM^@3Pgn<0h=oS09bL
WP3oool00P3Pgn<0103akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_l
o@2XZK/0IVIn075_I0050?ooo`0307moO`3oool0oooo01L0oooo00<0VOnI
0?ooo`3oool07@3oool00`1oOgl0oooo0?ooo`0Y0?ooo`030?ob/`3ol:/0
oooo00`0oooo00<0Ogmo0?ooo`3oool06@3oool00`27onl0cooi0?ooo`0K
0?ooo`0307moO`3oool0oooo0180oooo00<0ohN=0?o?d@3oool08`3oool0
0`1oOgl0oooo0?ooo`0K0?ooo`040?Ooo@1dom@0ZooU0?_ooQP0oooo00<0
Ogmo0?ooo`3oool0<`3oool01P3koo/0Ton?08ooR`3coo<0oooo07moOb/0
oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0509bLWP3oool0h=oS
0>3Oh`1oWKT0RP3Pgn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo0080h=oS00@0
lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0
1@3oool00`1oOgl0oooo0?ooo`0G0?ooo`0309coW03eooD0oooo01d0oooo
00<0WinO0?ooo`3oool0:P3oool00`3oi6@0oooo0?ooo`0;0?ooo`0309nO
W`3oool0oooo01T0oooo00<0noon06CojP3kooh06`3oool00`2OWil0oooo
0?ooo`0B0?ooo`030?okn`3oN7l0ooOg02<0oooo00<0WinO0?ooo`3oool0
7@3oool0102conL0I?o?0:_oi@3koohF0?ooo`0309nOW`3oool0oooo03D0
oooo00@0g?oK06GoH03HomL0WinO:`3oool01@3akn80h=oS0>3Oh`3Pgn<0
LFmT0080h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2:0>3Oh`0507nM^@3P
gn<0h=oS09bLWP3oool00P3Pgn<0103akn80IVIn0:RY^`3ko?d10?ooo`00
00D0IVIn0?_lo@2XZK/0IVIn075_I0050?ooo`0307moO`3oool0oooo01L0
oooo00<0o?ol09WoV@3oool0BP3oool00`3okIL0oo[S0?ooo`0X0?ooo`03
0;?om@2[oo@0oooo0300oooo00<0ooOg0?n?U@3olo@0A03oool00`2conL0
I?o?0<ool01>0?ooo`040?_on`2JoiL0Qon30?_onbX0oooo00D0lNoR0>3O
h`3Pgn<0h=oS075_I0020>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0RP3P
gn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0
nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@01@3oool00`1oOgl0
oooo0?ooo`0H0?ooo`0309WoV@3oool0oooo04T0oooo00<0oo_W0?o[S`3o
ool0:@3oool00`1hond0loom0?ooo`0`0?ooo`030?okn`3oSiD0ooOg04@0
oooo00@0noon08OofP23omT0moomCP3oool0103Aoll0IOmP0:koZ`3koo/X
0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<01@2LW9h0oooo0>3O
h`3Pgn<0Oifi08X0h=oS00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`04
0?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT
00D0oooo00<0Ogmo0?ooo`3oool0603oool00`2IoiT0oooo0?ooo`1:0?oo
o`030?oXO`3ooO<0oooo02P0oooo00<0noon08ool03cood0<@3oool00`3o
moL0ogQo0?o?d@150?ooo`030<ool01dom@0jooi04l0oooo00@0]Onc06Wo
I02^oj/0nook9P3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00D0
W9bN0?ooo`3Pgn<0h=oS07nM^@2:0>3Oh`0507nM^@3Pgn<0h=oS09bLWP3o
ool00P3Pgn<0103akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2X
ZK/0IVIn075_I0050?ooo`0307moO`3oool0oooo01P0oooo00<0VOnI0?oo
o`3oool0BP3oool00`3oo_/0on^?0?oml`0Y0?ooo`030?_ooP2?oo00loom
0380oooo00<0oinT0?nCV@3omoL0A03oool00`3good0N?oE0>_on@1@0?oo
o`040;Go/`1Yof@0[_n[0?_onb@0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_
I0020>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0RP3Pgn<01@1oWKT0h=oS
0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool00005
06IVOP3ko?d0Z:Vk06IVOP1aKf@01@3oool00`1oOgl0oooo0?ooo`0H0?oo
o`0308goS@3loo`0oooo04/0oooo00<0ookk0?oWN03oo_/0:@3oool00`3k
ooh0Soo`0??oo@0b0?ooo`030?oOh@3oOhH0ooOg04@0oooo00<0moom07So
e@3_ooX0D@3oool00`2eok<0JOmT0=7oc`0S0?ooo`050?7_hP3Pgn<0h=oS
0>3Oh`1aKf@00P3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08X0h=oS00D0
Oifi0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40
oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT00D0oooo00<0Ogmo0?ooo`3o
ool0603oool00`32ol80_?nl0?ooo`1<0?ooo`030?ob/`3ol:/0oooo02T0
oooo00<0noon07Cok03gooh0<P3oool00`3omoL0ohnE0?ocm0140?ooo`03
0??on`1Xom00_oo[0540oooo00@0nook08_oQ`27oh<0moog8@3oool01@3a
kn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM
^@2:0>3Oh`0507nM^@3Pgn<0h=oS09bLWP3oool00P3Pgn<0103akn80IVIn
0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I0050?ooo`03
07moO`3oool0oooo01T0oooo00<0ROn90?ooo`3oool0C03oool00`3oi6@0
ookk0?ooo`0Y0?ooo`030<oon@23onh0oooo0380oooo00<0oo_k0?n?U@3o
moL0A@3oool00`2Goml0K?oA0>?omP1A0?ooo`030=7oc`1Uof00dOo?0200
oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0509bLWP3oool0h=oS
0>3Oh`1oWKT0RP3Pgn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo0080h=oS00@0
lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0
1@3oool00`1oOgl0oooo0?ooo`0I0?ooo`0309WoV@3oool0oooo04`0oooo
00<0oo:c0?o`Z`3oool0:P3oool00`27onl0cooi0?ooo`0b0?ooo`030?og
m`3oM7/0ooOg04D0oooo00@0jooi07Coe02?om`0noonD03oool0103koo/0
Ron708OoP`3gooLN0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<0
1@2LW9h0oooo0>3Oh`3Pgn<0Oifi08X0h=oS00D0Oifi0>3Oh`3Pgn<0W9bN
0?ooo`020>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm
0:RY^`1VIWh0LFmT00D0oooo00<0Ogmo0?ooo`3oool06@3oool00`2IoiT0
oooo0?ooo`1=0?ooo`030?oSH03ooO<0oooo02T0oooo00<0noon07Sok@3g
ooh0<`3oool00`3ocm40oh>90?ooo`160?ooo`030<OokP1Toll0food0540
oooo00@0dOo?06GoH02^oj/0nook703oool01@3akn80h=oS0>3Oh`3Pgn<0
LFmT0080h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2:0>3Oh`0507nM^@3P
gn<0h=oS09bLWP3oool00P3Pgn<0103akn80IVIn0:RY^`3ko?d10?ooo`00
00D0IVIn0?_lo@2XZK/0IVIn075_I0050?ooo`0307moO`3oool0oooo01T0
oooo00<0VOnI0?ooo`3oool0C@3oool00`3onMl0onQo0?ooo`0Z0?ooo`03
0?OooP2?oo00loom03<0oooo00<0ohN=0?o?d@3oool0AP3oool00`3good0
K?oA0;Ooj@1B0?ooo`040;Go/`1Yof@0[_n[0?_onaX0oooo00D0lNoR0>3O
h`3Pgn<0h=oS075_I0020>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0RP3P
gn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0
nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@01@3oool00`1oOgl0
oooo0?ooo`0I0?ooo`0309WoV@3oool0oooo04h0oooo00<0on^?0?oea`3o
ool0:P3oool00`3kooh0Soo`0?OooP0b0?ooo`030?okn`3oG6@0oloA04P0
oooo0P2?om`00`3kooh0oooo0?ooo`1@0?ooo`040;Go/`1Yof@0[_n[0?_o
naP0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0509bLWP3oool0
h=oS0>3Oh`1oWKT0RP3Pgn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo0080h=oS
00@0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1a
Kf@01@3oool00`1oOgl0oooo0?ooo`0I0?ooo`0308goS@3loo`0oooo04h0
oooo00<0ookk0?oSH03oool0:`3oool00`3gooh0M?o/0?OooP0b0?ooo`04
0?okn`3oQhd0oh>90?ogmdL0oooo00<0_oo[07Coe03coo/0D`3oool0102e
ok<0JOmT0:koZ`3koo/F0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3P
gn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08X0h=oS00D0Oifi0>3Oh`3Pgn<0
W9bN0?ooo`020>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0
nocm0:RY^`1VIWh0LFmT00D0oooo00<0Ogmo0?ooo`3oool06@3oool00`32
ol80_?nl0?ooo`1?0?ooo`030?o[S`3onM/0oooo02/0oooo00<0cooi08?o
kP3oool0<`3oool00`3ocm40ogQo0?ocm0170?ooo`030>?omP1Toll0_oo[
05@0oooo00@0]Onc06WoI02^oj/0nook503oool01@3akn80h=oS0>3Oh`3P
gn<0LFmT0080h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2:0>3Oh`0507nM
^@3Pgn<0h=oS09bLWP3oool00P3Pgn<0103akn80IVIn0:RY^`3ko?d10?oo
o`0000D0IVIn0?_lo@2XZK/0IVIn075_I0050?ooo`0307moO`3oool0oooo
01X0oooo00<0ROn90?ooo`3oool0CP3oool00`3onMl0on^;0?ooo`0/0?oo
o`0308Ook`3?ooT0oooo03<0oooo00<0ooOg0?moQP3olo@0B03oool00`2G
oml0K?oA0>?omP1D0?ooo`040;Go/`1Yof@0[_n[0?_on`H0oooo00<0W_nK
0=Soe`3oool02@3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00D0
W9bN0?ooo`3Pgn<0h=oS07nM^@2:0>3Oh`0507nM^@3Pgn<0h=oS09bLWP3o
ool00P3Pgn<0103akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2X
ZK/0IVIn075_I0050?ooo`0307moO`3oool0oooo01X0oooo00<0VOnI0?oo
o`3oool0C`3oool00`3oi6@0ookg0?ooo`0[0?ooo`030?_ooP1PonX0moon
03@0oooo00<0ooOg0?mhO`3ojn`0B03oool0103[ooT0M?oD08oog03kooiD
0?ooo`040;Go/`1Yof@0[_n[0?_on`@0oooo00<0[_n[01Oo403Dom<02@3o
ool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00D0W9bN0?ooo`3Pgn<0
h=oS07nM^@2:0>3Oh`0507nM^@3Pgn<0h=oS09bLWP3oool00P3Pgn<0103a
kn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I005
0?ooo`0307moO`3oool0oooo01X0oooo00<0VOnI0?ooo`3oool0C`3oool0
0`3omll0onV30?ooo`0/0?ooo`030<oon@23onh0oooo03@0oooo00<0oo_k
0?mXL03ojn`0B@3oool00`37onh0I?o?0;ooj`1E0?ooo`040;Go/`1Yof@0
/_n_0?_on`80oooo00@0f?oG00So000Wob00g?oK203oool01@3akn80h=oS
0>3Oh`3Pgn<0LFmT0080h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2:0>3O
h`0507nM^@3Pgn<0h=oS09bLWP3oool00P3Pgn<0103akn80IVIn0:RY^`3k
o?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I0050?ooo`0307moO`3o
ool0oooo01X0oooo00<0VOnI0?ooo`3oool0D03oool00`3ojXL0ooO?0?oo
o`0/0?ooo`0308Ook`3?ooT0oooo03@0oooo00<0oo?d0?m/L`3ofmd0BP3o
ool00`2Goml0K?oA0>?omP1E0?ooo`090;go^`1aof`0/_n_0?ooo`3koo/0
4?l800So000Koa@0cOo;00L0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I002
0>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0RP3Pgn<01@1oWKT0h=oS0>3O
h`2LW9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool0000506IV
OP3ko?d0Z:Vk06IVOP1aKf@01@3oool00`1oOgl0oooo0?ooo`0J0?ooo`03
08goS@3loo`0oooo0500oooo00<0ookk0?oSH03oo_L0;03oool00`3kooh0
N?o]0?OooP0e0?ooo`030?ogm`3oK7<0okNk04X0oooo00@0jooi07Coe02?
om`0noonE@3oool0102mok/0Pomo0;Go/`0cob`200So000301Oo403=ol/0
oooo00D0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0509bLWP3o
ool0h=oS0>3Oh`1oWKT0RP3Pgn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo0080
h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IV
OP1aKf@01@3oool00`1oOgl0oooo0?ooo`0J0?ooo`030<;o`P2lok`0oooo
0540oooo00<0ooO?0?oYP`3oool0;03oool00`3gooh0Soo`0??oo@0f0?oo
o`80ohnE00<0oo_k0?ooo`3oool0B03oool00`37onh0I?o?0=_om01F0?oo
o`030<Go``0[ob@02?l000802?l000<05?l<0;Wo]`3oool0103oool01@3a
kn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM
^@2:0>3Oh`0507nM^@3Pgn<0h=oS09bLWP3oool00P3Pgn<0103akn80IVIn
0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I0050?ooo`03
07moO`3oool0oooo01/0oooo00<0ROn90?ooo`3oool0D@3oool00`3ojXL0
ooO?0?ooo`0/0?ooo`030?_ooP2?oo00moon03H0oooo00<0oko20?mdN`3o
lo@0BP3oool00`3kooh0K?oA0:ooiP1C0?ooo`030?_on`2^oj/0>_ld00D0
2?l000<05?l<0<gob`3oool00`3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT
0080h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2:0>3Oh`0507nM^@3Pgn<0
h=oS09bLWP3oool00P3Pgn<0103akn80IVIn0:RY^`3ko?d10?ooo`0000D0
IVIn0?_lo@2XZK/0IVIn075_I0050?ooo`0307moO`3oool0oooo01/0oooo
00<0VOnI0?ooo`3oool0D@3oool00`3oo_/0onAT0?ooo`0]0?ooo`030?Oo
oP1`on`0loom03H0oooo00<0on?T0?mlP`3olo@0B`3oool00`2Oon40VooP
0?_ooP1?0?ooo`030?_on`2Roil09olP00P02?l000<05ol@0<Woa`3oool0
0P3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00D0W9bN0?ooo`3P
gn<0h=oS07nM^@2:0>3Oh`0507nM^@3Pgn<0h=oS09bLWP3oool00P3Pgn<0
103akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_
I0050?ooo`0307moO`3oool0oooo01/0oooo00<0VOnI0?ooo`3oool0DP3o
ool00`3ojhl0ooWK0?ooo`0]0?ooo`030=?on@23onh0oooo03H0oooo00<0
oo_k0?n?U@3olo@0B`3oool00`3?oo00M?oD0?Ooo@1>0?ooo`040:KoX`1Q
oe`0;olX013o20P02?l000D04?l80;Go/`3oool0oooo0?7_hP030>3Oh`05
075_I03Pgn<0h=oS09bLWP3oool00P3Pgn<00`1oWKT0h=oS0>3Oh`280>3O
h`0507nM^@3Pgn<0h=oS09bLWP3oool00P3Pgn<0103akn80IVIn0:RY^`3k
o?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I0050?ooo`0307moO`3o
ool0oooo01/0oooo00<0VOnI0?ooo`3oool0DP3oool00`3onMl0on^;0?oo
o`0^0?ooo`0309Ool@37ooP0oooo03H0oooo00<0oo_k0?n?U@3olo@0B`3o
ool00`3WooP0J?o@0=Ool`1@0?ooo`060??ol`3Dom<0W_nK07SoM01>odP0
9olP1008o`00100<o`@0`Ono0?ooo`3akn830>3Oh`05075_I03Pgn<0h=oS
09bLWP3oool00P3Pgn<00`1oWKT0h=oS0>3Oh`280>3Oh`0507nM^@3Pgn<0
h=oS09bLWP3oool00P3Pgn<0103akn80IVIn0:RY^`3ko?d10?ooo`0000D0
IVIn0?_lo@2XZK/0IVIn075_I0050?ooo`0307moO`3oool0oooo01/0oooo
00<0VOnI0?ooo`3oool0D`3oool00`3oi6@0ookg0?ooo`0^0?ooo`0306Co
jP3cood0oooo03H0oooo00<0oo_k0?n?U@3olo@0B`3oool00`3kooh0N?oE
0:Ooi01E0?ooo`080>Soi`31okl0Ron704ooB@0QoaX04?l908WoQP3akn83
0>3Oh`05075_I03Pgn<0h=oS09bLWP3oool00P3Pgn<00`1oWKT0h=oS0>3O
h`280>3Oh`0507nM^@3Pgn<0h=oS09bLWP3oool00P3Pgn<0103akn80IVIn
0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I0050?ooo`03
07moO`3oool0oooo01/0oooo00<0VOnI0?ooo`3oool0D`3oool00`3omll0
onV30?ooo`0^0?ooo`030=_onP1don`0oooo03L0oooo00<0oo_k0?n?U@3o
lo@0C03oool00`2[onD0M?oD0??on`1H0?ooo`030>ook`28oh@0lNoR00<0
h=oS00D0LFmT0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`0307nM^@3Pgn<0h=oS
08P0h=oS00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`040?7_hP1VIWh0
Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT00D0oooo00<0
Ogmo0?ooo`3oool06`3oool00`2Loi`0mOoe0?ooo`1D0?ooo`030?oZQ`3o
mll0oooo02h0oooo00<0Zood0:?ol`3oool0=`3oool00`3ono/0ohnE0?oc
m01<0?ooo`030=_om01Polh0_oo[05T0oooo00D0lNoR0>3Oh`3Pgn<0h=oS
075_I0020>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0RP3Pgn<01@1oWKT0
h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool0
000506IVOP3ko?d0Z:Vk06IVOP1aKf@01@3oool00`1oOgl0oooo0?ooo`0K
0?ooo`030?coo02IoiT0oooo05@0oooo00<0ookk0?oSH03oo_L0;`3oool0
0`1hond0eooj0?ooo`0g0?ooo`030?okn`3oSiD0oo?d04d0oooo00<0WooQ
08_of`3_ooX0E`3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00D0
W9bN0?ooo`3Pgn<0h=oS07nM^@2:0>3Oh`0507nM^@3Pgn<0h=oS09bLWP3o
ool00P3Pgn<0103akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2X
ZK/0IVIn075_I0050?ooo`0307moO`3oool0oooo01`0oooo00<0VOnI0?oo
o`3oool0E03oool00`3omll0onV30?ooo`0^0?ooo`030?_ooP1hond0koom
03P0oooo00<0oo_k0?n?U@3olo@0C@3oool0103coo/0RooK09Oog`3kooiE
0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<01@2LW9h0oooo0>3O
h`3Pgn<0Oifi08X0h=oS00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`04
0?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT
00D0oooo00<0Ogmo0?ooo`3oool0703oool00`2IoiT0oooo0?ooo`1E0?oo
o`030?oZQ`3omll0oooo02h0oooo00<0moon07Cok03[oo`0>03oool00`3o
no/0ogAk0?oKg@1>0?ooo`030<_ok`1Toll0_oo[05@0oooo00D0lNoR0>3O
h`3Pgn<0h=oS075_I0020>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0RP3P
gn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0
nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@01@3oool00`1oOgl0
oooo0?ooo`0L0?ooo`0309WoV@3oool0oooo05D0oooo00<0ookk0?oSH03o
o_L0;`3oool00`3cood0L?o/0>_oo00h0?ooo`030?ogm`3oK7<0okNk04l0
oooo00<0UooO073od`3WooP0DP3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT
0080h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2:0>3Oh`0507nM^@3Pgn<0
h=oS09bLWP3oool00P3Pgn<0103akn80IVIn0:RY^`3ko?d10?ooo`0000D0
IVIn0?_lo@2XZK/0IVIn075_I0050?ooo`0307moO`3oool0oooo01`0oooo
00<0VOnI0?ooo`3oool0EP3oool00`3omll0onV30?ooo`0_0?ooo`030?Oo
oP1hond0koom03T0oooo0P3oSiD00`3ono/0oooo0?ooo`1<0?ooo`040>Oo
n01/om40XooR0?_ooU00oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3O
h`0509bLWP3oool0h=oS0>3Oh`1oWKT0RP3Pgn<01@1oWKT0h=oS0>3Oh`2L
W9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3k
o?d0Z:Vk06IVOP1aKf@01@3oool00`1oOgl0oooo0?ooo`0H0?ooo`050=Go
e@3UonD0oooo0?ooo`2IoiT0103oool00`39olT0o?ol0?ooo`1B0?ooo`03
0?oZQ`3omll0oooo02l0oooo00<0moon073ok03gooh0>@3oool00`3o_l80
ogAk0?ocm01?0?ooo`030;Ooj@1Toll0eooc04l0oooo00D0lNoR0>3Oh`3P
gn<0h=oS075_I0020>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0RP3Pgn<0
1@1oWKT0h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0nocm
0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@01@3oool00`1oOgl0oooo
0?ooo`0H0?ooo`050>Goi@13od<0c?o<0?ooo`20oh000P3oool00`3loo`0
SOn=06?oH`1D0?ooo`030?onn`3oiF`0oooo0300oooo00<0aooh09?ol@3o
ool0>@3oool00`3ohn@0ogAk0?o[k01?0?ooo`040?Ooo@1oomL0QooJ0??o
ndd0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0509bLWP3oool0
h=oS0>3Oh`1oWKT0RP3Pgn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo0080h=oS
00@0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1a
Kf@01@3oool00`1oOgl0oooo0?ooo`0I0?ooo`0905goG@0coc<0U_nF09So
V03oool0k?o/06?oH`0coc<0X_nR05D0oooo00<0onfG0?oig`3oool0<03o
ool00`1`on`0hook0?ooo`0i0?ooo`030?ocm03oJ700on_/0500oooo00<0
dooa063ocP3Coo40C03oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS
00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2:0>3Oh`0507nM^@3Pgn<0h=oS09bL
WP3oool00P3Pgn<0103akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_l
o@2XZK/0IVIn075_I0050?ooo`0307moO`3oool0oooo01T0oooo00T0VOnI
03?o<`0coc<0BOm90;;o/P13od<0<olc03Ko=P3YonT0E@3oool00`3onn/0
onZ70?ooo`0`0?ooo`030>_oo01don`0oooo03X0oooo00<0oo_k0?mhO`3o
ko00D03oool0103kooh0OooG08oog03kooi:0?ooo`050?7_hP3Pgn<0h=oS
0>3Oh`1aKf@00P3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08X0h=oS00D0
Oifi0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40
oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT00D0oooo00<0Ogmo0?ooo`3o
ool06@3oool00`3Ron80<olc03?o<`0403?o<`0305goG@3oool0oooo05D0
oooo00<0on=P0?onm`3oool0<03oool00`2Goo40_oof0?ooo`0j0?ooo`03
0?ogm`3oOhH0oo?d0540oooo00<0^ooZ06Coc`3WooP0B@3oool01@3akn80
h=oS0>3Oh`3Pgn<0LFmT0080h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2:
0>3Oh`0507nM^@3Pgn<0h=oS09bLWP3oool00P3Pgn<0103akn80IVIn0:RY
^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I0050?ooo`0307mo
O`3oool0oooo01X0oooo00<0BOm903?o<`0coc<00`0coc<00`2Coi<0oooo
0?ooo`1E0?ooo`030?ogc`3ojH<0oooo0340oooo00<0H?oZ0??oo@3oool0
>P3oool00`3omoL0ohnE0?ocm01A0?ooo`030>oonP1/om40]ooY04P0oooo
00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0509bLWP3oool0h=oS0>3O
h`1oWKT0RP3Pgn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR
06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@01@3o
ool00`1oOgl0oooo0?ooo`0J0?ooo`03083oP00coc<0<olc00<0<olc00<0
g?oL0?ooo`3oool0EP3oool00`3ojXL0ooO?0?ooo`0`0?ooo`030=_onP1d
on`0oooo03/0oooo00<0oo_k0?n?U@3olo@0DP3oool00`2Kon00N?oE0??o
n`160?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<01@2LW9h0oooo
0>3Oh`3Pgn<0Oifi08X0h=oS00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`020>3O
h`040?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0
LFmT00D0oooo00<0Ogmo0?ooo`3oool06P3oool00`39olT0<olc03?o<`02
03?o<`0304KoAP3loo`0oooo05L0oooo00<0ookk0?oTI03oool0<@3oool0
0`2[oo@0Xooc0?ooo`0k0?ooo`030?okn`3oSiD0oo?d0580oooo00<0food
06Coc`2oon/0A@3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00D0
W9bN0?ooo`3Pgn<0h=oS07nM^@2:0>3Oh`0507nM^@3Pgn<0h=oS09bLWP3o
ool00P3Pgn<0103akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2X
ZK/0IVIn075_I0050?ooo`0307moO`3oool0oooo01X0oooo00<0nOoi03Wo
>@0coc<00P0coc<00`2Coi<0oooo0?ooo`1H0?ooo`030?o[S`3onM/0oooo
0340oooo00<0N?o]0=OonP3oool0>`3oool00`3ono/0ohnE0?ocm01C0?oo
o`0309Oog`1`om<0iooh04<0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I002
0>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0RP3Pgn<01@1oWKT0h=oS0>3O
h`2LW9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool0000506IV
OP3ko?d0Z:Vk06IVOP1aKf@01@3oool00`1oOgl0oooo0?ooo`0K0?ooo`05
07WoN@0coc<0<olc03?o<`3<ol`0FP3oool00`3onMl0on^;0?ooo`0a0?oo
o`030?_ooP1lonh0moon03`0oooo00<0oo_k0?mdN`3ogn40D`3oool0103W
ooP0K?oA0:?ohP3kooi10?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3P
gn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08X0h=oS00D0Oifi0>3Oh`3Pgn<0
W9bN0?ooo`020>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0
nocm0:RY^`1VIWh0LFmT00D0oooo00<0Ogmo0?ooo`3oool06`3oool01@2b
ok80<olc03?o<`19odT0o?ol05/0oooo00<0onAX0?onn`3oool0<@3oool0
0`3gooh0Soo`0??oo@0l0?ooo`030?ocm03oJ700olO:05@0oooo00<0]ooY
06Coc`3Goo<0@03oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00D0
W9bN0?ooo`3Pgn<0h=oS07nM^@2:0>3Oh`0507nM^@3Pgn<0h=oS09bLWP3o
ool00P3Pgn<0103akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2X
ZK/0IVIn075_I0050?ooo`0307moO`3oool0oooo01/0oooo00@0jOoY03Ko
=P0coc<0P?n0G03oool00`3ol[<0oo2[0?ooo`0b0?ooo`030?_ooP2?oo00
moon03d0oooo00<0ogb30?n_/`3oool0D`3oool0103good0OooG08OofP3c
oo/n0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<01@2LW9h0oooo
0>3Oh`3Pgn<0Oifi08X0h=oS00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`020>3O
h`040?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0
LFmT00D0oooo00<0Ogmo0?ooo`3oool0703oool00`1VofH0<olc0;Wo^@1M
0?ooo`030?oTI03oool0oooo0380oooo00<0moon07Cok03cood0?@3oool0
0`3oTiT0oiNL0?ooo`1D0?ooo`030=?ol@1Polh0gooe03d0oooo00D0lNoR
0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0
RP3Pgn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IVOP2X
ZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@01@3oool00`1o
Ogl0oooo0?ooo`0L0?ooo`030:;oXP0gocL0nOoi05d0oooo00<0on^?0?oi
f`3oool0<`3oool00`3KooX0M?o/0?ooo`0m0?ooo`030?ng^`3oO8<0ooOg
05@0oooo00<0noon08?of@2Goml0?03oool01@3akn80h=oS0>3Oh`3Pgn<0
LFmT0080h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2:0>3Oh`0507nM^@3P
gn<0h=oS09bLWP3oool00P3Pgn<0103akn80IVIn0:RY^`3ko?d10?ooo`00
00D0IVIn0?_lo@2XZK/0IVIn075_I0050?ooo`0307moO`3oool0oooo01`0
oooo00<0g?oL04coC03oool0G@3oool00`3onMl0on^;0?ooo`0d0?ooo`03
0:_om02Soo<0oooo03d0oooo00<0om?E0?mXL03oko00E@3oool00`33on`0
K?oA0>?omP0j0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<01@2L
W9h0oooo0>3Oh`3Pgn<0Oifi08X0h=oS00D0Oifi0>3Oh`3Pgn<0W9bN0?oo
o`020>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY
^`1VIWh0LFmT00D0oooo00<0Ogmo0?ooo`3oool07@3oool00`2=ohd0oooo
0?ooo`1M0?ooo`030?oXO03ooO<0oooo03@0oooo00<0N?o]0=OonP3oool0
?@3oool00`3oinP0ogQo0?o[k01E0?ooo`030??on`1Toll0aoo^03T0oooo
00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0509bLWP3oool0h=oS0>3O
h`1oWKT0RP3Pgn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR
06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@01@3o
ool00`1oOgl0oooo0?ooo`1m0?ooo`030?onn`3ojhl0oogc03@0oooo00<0
noon06CojP3gooh0?P3oool00`3omoL0ofac0?o[k01F0?ooo`030:?ohP1o
omL0noon03L0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0509bL
WP3oool0h=oS0>3Oh`1oWKT0RP3Pgn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo
0080h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk
06IVOP1aKf@01@3oool00`1oOgl0oooo0?ooo`1n0?ooo`030?onn`3oigP0
ookk03@0oooo00<0cooi08?okP3oool0?P3oool00`3oko00ofQ`0?o[k01F
0?ooo`030=?ol@1Polh0_oo[03H0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_
I0020>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0RP3Pgn<01@1oWKT0h=oS
0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool00005
06IVOP3ko?d0Z:Vk06IVOP1aKf@01@3oool00`1oOgl0oooo0?ooo`1o0?oo
o`030?ob/`3ol:/0oooo03@0oooo00<0Qoo_0<oon@3oool0?P3oool00`3o
no/0ofac0?o[k01G0?ooo`0309Oog`1`om<0iooh03@0oooo00D0lNoR0>3O
h`3Pgn<0h=oS075_I0020>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0RP3P
gn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0
nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@01@3oool00`1oOgl0
oooo0?ooo`200?ooo`030?oTI03oo_/0oooo03<0oooo00<0noon063ojP3g
ooh0?`3oool00`3omoL0oh>90?ocm01G0?ooo`040>Oon01/om40XooR0?_o
oS80oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0509bLWP3oool0
h=oS0>3Oh`1oWKT0RP3Pgn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo0080h=oS
00@0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1a
Kf@01@3oool00`1oOgl0oooo0?ooo`200?ooo`030?ob/`3ol:/0oooo03@0
oooo00<0cooi08?okP3oool0?`3oool00`3omoL0ogb30?ocm01H0?ooo`03
0;Ooj@1Toll0eooc0340oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3O
h`0509bLWP3oool0h=oS0>3Oh`1oWKT0RP3Pgn<01@1oWKT0h=oS0>3Oh`2L
W9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3k
o?d0Z:Vk06IVOP1aKf@01@3oool00`1oOgl0oooo0?ooo`210?ooo`030?oU
K03oool0oooo03@0oooo00<0Qoo_0<oon@3oool0?`3oool00`3omoL0ohnE
0?ogm`1H0?ooo`040?Ooo@1oomL0QooJ0??onbl0oooo00D0lNoR0>3Oh`3P
gn<0h=oS075_I0020>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0RP3Pgn<0
1@1oWKT0h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0nocm
0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@01@3oool00`1oOgl0oooo
0?ooo`210?ooo`030?oXO`3oool0oooo03@0oooo00<0noon06CojP3gooh0
@03oool00`3omoL0ohnE0?ocm01I0?ooo`030=?ol@1Polh0eooc02h0oooo
00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0509bLWP3oool0h=oS0>3O
h`1oWKT0RP3Pgn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR
06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@01@3o
ool00`1oOgl0oooo0?ooo`210?ooo`030?oVL03oo_/0oooo03D0oooo00<0
gook09?ol@3oool0@03oool00`3ono/0ohnE0?ogm`1I0?ooo`040?_ooP27
omX0UooO0?_ooR`0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`05
09bLWP3oool0h=oS0>3Oh`1oWKT0RP3Pgn<01@1oWKT0h=oS0>3Oh`2LW9h0
oooo0080h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0
Z:Vk06IVOP1aKf@01@3oool00`1oOgl0oooo0?ooo`210?ooo`030?ob/`3o
l:/0oooo03H0oooo00<0Woob0<oon@3oool0@03oool00`3omoL0ohnE0?og
m`1J0?ooo`030<_ok`1homD0jooi02/0oooo00D0lNoR0>3Oh`3Pgn<0h=oS
075_I0020>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0RP3Pgn<01@1oWKT0
h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool0
000506IVOP3ko?d0Z:Vk06IVOP1aKf@01@3oool00`1oOgl0oooo0?ooo`22
0?ooo`030?oTI03oo_/0oooo03H0oooo00<0I?oZ0?OooP3oool0@03oool0
0`3omoL0ohnE0?ocm01J0?ooo`030??on`1/om40/ooW02X0oooo00D0lNoR
0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0
RP3Pgn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IVOP2X
ZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@01@3oool00`1o
Ogl0oooo0?ooo`220?ooo`030?ob/`3ol:/0oooo03H0oooo00<0cooi08?o
kP3oool0@@3oool00`3ono/0ohnE0?ogm`1K0?ooo`030:Ooi01lomH0moom
02P0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0509bLWP3oool0
h=oS0>3Oh`1oWKT0RP3Pgn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo0080h=oS
00@0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1a
Kf@01@3oool00`1oOgl0oooo0?ooo`230?ooo`030?oTI03oo_/0oooo03H0
oooo00<0Qoo_0<oon@3oool0@@3oool00`3omoL0ogQo0?o[k01K0?ooo`03
0=_om01Xom00]ooY02L0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3O
h`0509bLWP3oool0h=oS0>3Oh`1oWKT0RP3Pgn<01@1oWKT0h=oS0>3Oh`2L
W9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3k
o?d0Z:Vk06IVOP1aKf@01@3oool00`1oOgl0oooo0?ooo`230?ooo`030?ob
/`3ol:/0oooo03H0oooo00<0noon063ojP3gooh0@P3oool00`3omoL0og1g
0?o;cP1L0?ooo`0309ooh@1/om40eooc02D0oooo00D0lNoR0>3Oh`3Pgn<0
h=oS075_I0020>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0RP3Pgn<01@1o
WKT0h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0nocm0@3o
ool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@01@3oool00`1oOgl0oooo0?oo
o`240?ooo`030?oUK03oool0oooo03H0oooo00<0cooi08?okP3oool0@`3o
ool00`3oSiD0ojN[0?ooo`1K0?ooo`040??on`1lomH0OooG0>oonR<0oooo
00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0509bLWP3oool0h=oS0>3O
h`1oWKT0RP3Pgn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR
06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@01@3o
ool00`1oOgl0oooo0?ooo`0e0?ooo`030?n6W`3ojnl0oooo04`0oooo00<0
onI`0?onn`3oool0=`3oool00`27onl0cooi0?ooo`130?ooo`030?nSZ03o
Wj@0oooo05`0oooo00@0gooe06cod@2Kon00noon8@3oool01@3akn80h=oS
0>3Oh`3Pgn<0LFmT0080h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2:0>3O
h`0507nM^@3Pgn<0h=oS09bLWP3oool00P3Pgn<0103akn80IVIn0:RY^`3k
o?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I0050?ooo`0307moO`3o
ool0oooo03D0oooo00<0oceU0?nK[`3oool0C03oool00`3ol[<0oo2[0?oo
o`0g0?ooo`030?_ooP1hond0loom04@0oooo00<0ol_>0?mhO`3ono/0G@3o
ool00`33on`0H?o>0<_ok`0P0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@0
0P3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08X0h=oS00D0Oifi0>3Oh`3P
gn<0W9bN0?ooo`020>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1V
IWh0nocm0:RY^`1VIWh0LFmT00D0oooo00<0Ogmo0?ooo`3oool0=@3oool0
0`3o84d0odaa0?ooo`1=0?ooo`030?oTI03oo_/0oooo03L0oooo00<0noon
08ool03cood0A03oool00`3ofmd0ofA/0?o[k01N0?ooo`0308OofP2?om`0
noon01h0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0509bLWP3o
ool0h=oS0>3Oh`1oWKT0RP3Pgn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo0080
h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IV
OP1aKf@01@3oool00`1oOgl0oooo0?ooo`0d0?ooo`040?oko03o1ST0o``n
0?ocmDd0oooo00<0ooBo0?ob/`3oool0>03oool00`3kooh0M?o/0?OooP14
0?ooo`030?o_l03oO8<0ooOg05h0oooo00<0aoo^07Coe03SooH07@3oool0
1@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00D0W9bN0?ooo`3Pgn<0h=oS
07nM^@2:0>3Oh`0507nM^@3Pgn<0h=oS09bLWP3oool00P3Pgn<0103akn80
IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I0050?oo
o`0307moO`3oool0oooo03@0oooo00@0okO60?l0=03o03@0oj>fCP3oool0
0`3oiW@0oooo0?ooo`0h0?ooo`030<oon@23onh0oooo04@0oooo00<0ooOg
0?n?U@3omoL0GP3oool00`3coo/0K?oA0:?ohP0L0?ooo`050?7_hP3Pgn<0
h=oS0>3Oh`1aKf@00P3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08X0h=oS
00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`040?7_hP1VIWh0Z:Vk0?_l
o@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT00D0oooo00<0Ogmo0?oo
o`3oool0=03oool0103oK8X0o`0d0?l0=03oI8A>0?ooo`030?oVL03oo_/0
oooo03T0oooo00<0Qoo_0<oon@3oool0A03oool00`3omoL0ohnE0?ocm01O
0?ooo`030;?oi`1/om40jooi01X0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_
I0020>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0RP3Pgn<01@1oWKT0h=oS
0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool00005
06IVOP3ko?d0Z:Vk06IVOP1aKf@01@3oool00`1oOgl0oooo0?ooo`0d0?oo
o`050?lXE03o03@0o`0d0?lTD@3ono`0C@3oool00`3ol[<0oo2[0?ooo`0i
0?ooo`030?_ooP1TonX0noon04D0oooo00<0oo_k0?n?U@3omoL0G`3oool0
0`3SooH0O?oF0;ooj`0I0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3P
gn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08X0h=oS00D0Oifi0>3Oh`3Pgn<0
W9bN0?ooo`020>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0
nocm0:RY^`1VIWh0LFmT00D0oooo00<0Ogmo0?ooo`3oool0<`3oool00`3o
bmH0o`0d0?l0=0020?l0=0030?o3c`3oool0oooo04`0oooo00<0onE/0?oo
o`3oool0>@3oool00`2cooD0Zood0?ooo`150?ooo`030?ogm`3oSiD0ooOg
0600oooo0P2Comh00`3kooh0oooo0?ooo`0E0?ooo`050?7_hP3Pgn<0h=oS
0>3Oh`1aKf@00P3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08X0h=oS00D0
Oifi0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40
oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT00D0oooo00`0Ogmo0?ooo`3o
ool0oooo0>o_k`1PH600A4A403Ph>037alL0oooo08n?S`1dM7@40?ooo`03
03`l?03Shn<0oooo02<0oooo00<0ognI0?l0=03o03@00P3o03@00`3oOiT0
oooo0?ooo`1<0?ooo`030?oYP`3ooO<0oooo03X0oooo00<0I?oZ0?_ooP3o
ool0A@3oool00`3omoL0ohnE0?ogm`1P0?ooo`030<ool01Polh0aoo^01H0
oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0509bLWP3oool0h=oS
0>3Oh`1oWKT0RP3Pgn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo0080h=oS00@0
lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0
1@3oool0301oOgl0oooo0?ooo`3oool0J6QX08^;R`3oool0alO7030`<03o
ool0gmoO0=OGe`@0oooo00<0820P0=oOg`3oool08`3oool00`3o:5@0o`0d
0?l0=0020?l0=0030?lXE03oool0oooo04`0oooo00<0ookk0?oXO`3oool0
>P3oool00`2cooD0Zood0?ooo`160?ooo`030?ogm`3oSiD0ooOg0640oooo
00<0RooK07ooe`3coo/0503oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080
h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2:0>3Oh`0507nM^@3Pgn<0h=oS
09bLWP3oool00P3Pgn<0103akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn
0?_lo@2XZK/0IVIn075_I0050?ooo`0607moO`3oool0oooo0?ooo`0T92@0
emOG0P3oool01P0@4100kno_0?ooo`3oool0`l?300P82080820P00<010@4
01`L703Shn<08P3oool00`3ognH0o`0d0?l0=0040?l0=0030?oOiP3oool0
oooo04`0oooo00<0onQo0?ooo`3oool0>P3oool00`1don`0koom0?ooo`16
0?ooo`030?ogm`3oSiD0oo?d0640oooo00<0eooc063ocP37onh04`3oool0
1@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00D0W9bN0?ooo`3Pgn<0h=oS
07nM^@2:0>3Oh`0507nM^@3Pgn<0h=oS09bLWP3oool00P3Pgn<0103akn80
IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I0050?oo
o`0607moO`3oool0oooo0?ooo`000000no_k0P3oool00`0P8200gmoO0?oo
o`020?ooo`0504a<C03Kfm/0oooo020P803Ogml08`3oool00`3oWk<0o`0d
0?l0=0040?l0=0030?nG[03oool0oooo04`0oooo00<0onQo0?ooo`3oool0
>P3oool00`3gooh0M?o/0>ooo@170?ooo`030?okn`3oSiD0ooOg0640oooo
00@0noon08oog01oomL0moom1`3oool00`3_ooX0oooo0?ooo`070?ooo`05
0?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0
Oifi08X0h=oS00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`040?7_hP1V
IWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT00D0oooo
00H0Ogmo0?ooo`3oool0oooo00@4103kno/20?ooo`03020P803Ogml0oooo
0080oooo00D0gmoO04Q8B03gmoL0820P0=oOg`0S0?ooo`080?m8K@3o03@0
o`0d0?lQCP3oH800o`@g0?l0=03o@6M>0?ooo`030?oYP`3ooO<0oooo03/0
oooo00<0loom06coj`3kooh0A`3oool00`3omoL0ohnE0?ogm`1R0?ooo`03
0=Ool`1Polh0aoo^00H0oooo00<0B?o60?_ooP3oool01`3oool01@3akn80
h=oS0>3Oh`3Pgn<0LFmT0080h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2:
0>3Oh`0507nM^@3Pgn<0h=oS09bLWP3oool00P3Pgn<0103akn80IVIn0:RY
^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I0030?ooo`0809nO
W`1oOgl0?clo07moO`2OWil0oooo02@T903GemL20?ooo`03010@403gmoL0
oooo00<0oooo00@0Vi^K08>3P`0P8200gmoO8P3oool02P3oloD0o`Pj0?l8
>P3o@FL0ofj<0?ooo`3oXkH0oa110?l4=`3oko9=0?ooo`030?onn`3oj7l0
oooo03`0oooo00<0/ooe0:_om03oool0A`3oool00`3omoL0ohnE0?ocm01R
0?ooo`040?_ooP2;om/0OooG0??on`@0oooo00<01?na08OofP3oool01`3o
ool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00D0W9bN0?ooo`3Pgn<0
h=oS07nM^@2:0>3Oh`0507nM^@3Pgn<0h=oS09bLWP3oool00P3Pgn<0103a
kn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I005
0?ooo`0907moO`3oool0oooo0?ooo`1PH600Shn?0?ooo`3;bl/0>3Ph00H0
oooo00<0A4A400`<303Ogml08P3oool0103o[kl0ob1=0?oGg`3oOiT30?oo
o`030?oGg`3o:5@0ojNi04h0oooo00<0onQo0?ooo`3oool0?03oool00`1T
onX0noon0?ooo`170?ooo`030?okn`3oSiD0oo?d06<0oooo00<0eooc063o
cP3Coo400`3oool00`0HokL00?n`0;_ojP070?ooo`050?7_hP3Pgn<0h=oS
0>3Oh`1aKf@00P3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08X0h=oS00D0
Oifi0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40
oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT00D0oooo00T0Ogmo0?ooo`3o
ool0oooo0>?Sh`0l?3`0@41004A4A03Cdm<01P3oool00`3WinL0410@0=oO
g`0R0?ooo`040?n[_03ojnl0oooo0?moV@@0oooo00<0oo?e0?n[_03oool0
C@3oool00`3oj7l0oooo0?ooo`0l0?ooo`030;?om@2[oo@0oooo04P0oooo
00<0oo_k0?n?U@3olo@0H`3oool02@3kooh0OooG08oog03kooh0oooo023o
^P00ok006?ng0=oom@060?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3P
gn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08X0h=oS00D0Oifi0>3Oh`3Pgn<0
W9bN0?ooo`020>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0
nocm0:RY^`1VIWh0LFmT00D0oooo00<0Ogmo0?ooo`3oool0=03oool00`3o
H800oooo0?ooo`1B0?ooo`030?oYP`3ooO<0oooo03d0oooo00<0I?oZ0?_o
oP3oool0B03oool00`3ono/0ohnE0?ocm01T0?ooo`040;_ojP1Toll0iooh
023o^P800?n`00<0??o30?Ooo@3oool0103oool01@3akn80h=oS0>3Oh`3P
gn<0LFmT0080h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2:0>3Oh`0507nM
^@3Pgn<0h=oS09bLWP3oool00P3Pgn<0103akn80IVIn0:RY^`3ko?d10?oo
o`0000D0IVIn0?_lo@2XZK/0IVIn075_I0050?ooo`0307moO`3oool0oooo
03@0oooo00<0ognI0?ooo`3oool0DP3oool00`3oo_/0onQo0?ooo`0m0?oo
o`030;?om@2[oo@0oooo04T0oooo00<0oo_k0?n;T@3ojn`0I03oool00`3_
ooX0Foo<00ko]003003o/00306Sod03oool0oooo00<0oooo00D0lNoR0>3O
h`3Pgn<0h=oS075_I0020>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0RP3P
gn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0
nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@01@3oool00`1oOgl0
oooo0?ooo`0d0?ooo`030?moV@3oool0oooo05<0oooo00<0onQo0?ooo`3o
ool0?@3oool00`1TonX0noon0?ooo`190?ooo`030?ogm`3oK7<0on_/0640
oooo00<0boo_07ooe`0hol401P00ok000`2Oon40oooo0?ooo`020?ooo`05
0?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0
Oifi08X0h=oS00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`040?7_hP1V
IWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT00D0oooo
00<0Ogmo0?ooo`3oool0<`3oool00`3ono`0ognI0?ooo`1D0?ooo`030?oS
H03oool0oooo00@0oooo00<0ookk0?ooo`3oool0=P3oool00`2cooD0Zood
0?ooo`1:0?ooo`030?ocm03oN7l0on_/05h0oooo00<0kooj063ocP00ok00
2000ok000`08ok80aoo^0?ooo`020?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1a
Kf@00P3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08X0h=oS00D0Oifi0>3O
h`3Pgn<0W9bN0?ooo`020>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo0000
1@1VIWh0nocm0:RY^`1VIWh0LFmT00D0oooo00<0Ogmo0?ooo`3oool0<`3o
ool00`3oPi`0oo?e0?ooo`1A0?ooo`040?ob]`3ojhl0ookk0?oXO`@0oooo
00<0ookg0?oUK03oo_L0>@3oool00`1TonX0noon0?ooo`1:0?ooo`030?og
m`3oN7l0on_/05l0oooo00@0gooe08oog00lol<02?nb1P00ok001@0Tok/0
kooj0?ooo`3oool0lNoR00<0h=oS00D0LFmT0>3Oh`3Pgn<0W9bN0?ooo`02
0>3Oh`0307nM^@3Pgn<0h=oS08P0h=oS00D0Oifi0>3Oh`3Pgn<0W9bN0?oo
o`020>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY
^`1VIWh0LFmT00D0oooo00<0Ogmo0?ooo`3oool0<`3oool00`3oH800oooo
0?ooo`1A0?ooo`050?onm`3oeA00omm<0?oVLP3oo>l00P3oool00`3omll0
omX`0?oSH00j0?ooo`030;?om@2[oo@0oooo04/0oooo00<0ooOg0?m`M`3o
lo@0H@3oool0103WooP0VooP04Coa@04ok44003o/004053ob@3kooh0oooo
0?7_hP<0h=oS00D0LFmT0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`0307nM^@3P
gn<0h=oS08P0h=oS00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`040?7_
hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT00D0
oooo00<0Ogmo0?ooo`3oool0<P3oool00`3ono`0ognI0?ooo`1C0?ooo`09
0?oPD03odP00omTV0?oQD03oool0oo6_0?oD303odP00onnS03/0oooo00<0
N?o]0??oo@3oool0B`3oool00`3ofmd0ogAk0?ooo`1S0?ooo`040>oonP2S
on80D?o900co]0800?n`00<0O?oF0?ooo`3akn800`3Pgn<01@1aKf@0h=oS
0>3Oh`2LW9h0oooo0080h=oS00<0Oifi0>3Oh`3Pgn<0R03Pgn<01@1oWKT0
h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool0
000506IVOP3ko?d0Z:Vk06IVOP1aKf@01@3oool00`1oOgl0oooo0?ooo`0b
0?ooo`030?n3W03oloD0oooo05<0oooo00D0oo6_0?oB003odP00om<20?oN
A0020?oB00030?oC103onn/0oooo03X0oooo00<0noon07ookP3oool0C03o
ool00`3oZjl0oj>X0?ooo`1U0?ooo`060>_on@2[onD0EOo:00[o/`1]om40
lNoR0`3Pgn<01@1aKf@0h=oS0>3Oh`2LW9h0oooo0080h=oS00<0Oifi0>3O
h`3Pgn<0R03Pgn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR
06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@01@3o
ool00`1oOgl0oooo0?ooo`0b0?ooo`030?moV@3oool0oooo05<0oooo00<0
ooc_0?oC103odP00103odP000`3ogd`0oooo0?ooo`0k0?ooo`0307ookP3o
ool0oooo04`0oooo00<0ogQo0?oGf@3oool0I`3oool00`3good0UOoN0?7_
hP030>3Oh`05075_I03Pgn<0h=oS09bLWP3oool00P3Pgn<00`1oWKT0h=oS
0>3Oh`280>3Oh`0507nM^@3Pgn<0h=oS09bLWP3oool00P3Pgn<0103akn80
IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I0050?oo
o`0307moO`3oool0oooo0340oooo00<0oo_l0?moV@3oool0E@3oool00`3o
gT@0om800?oB00030?oB00030?o[R`3oool0oooo03/0oooo00<0N?o]0>oo
o@3oool0C03oool00`3ono/0ofA/0?ocm01Y0?ooo`050?7_hP3Pgn<0h=oS
0>3Oh`1aKf@00P3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08X0h=oS00D0
Oifi0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40
oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT00D0oooo00<0Ogmo0?ooo`3o
ool0<@3oool00`3oPi`0oo?e0?ooo`1E0?ooo`030?o/T`3odP00om8000<0
om8000<0ooWK0?ooo`3oool0>`3oool00`3cood0L?o/0?_ooP1=0?ooo`03
0?oKg@3oM7/0oooo06P0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3O
h`0509bLWP3oool0h=oS0>3Oh`1oWKT0RP3Pgn<01@1oWKT0h=oS0>3Oh`2L
W9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3k
o?d0Z:Vk06IVOP1aKf@01@3oool00`1oOgl0oooo0?ooo`0a0?ooo`030?mo
V@3oool0oooo05D0oooo00<0oo[S0?oC203odP000P3odP000`3ofS00oooo
0?ooo`0m0?ooo`030;?om@2[oo@0oooo04d0oooo00<0oj^_0?nSZ03oool0
I`3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00D0W9bN0?ooo`3P
gn<0h=oS07nM^@2:0>3Oh`0507nM^@3Pgn<0h=oS09bLWP3oool00P3Pgn<0
103akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_
I0050?ooo`0307moO`3oool0oooo0340oooo00<0ognI0?ooo`3oool0EP3o
ool01@3ogC`0om800?oB003odP00onMh0400oooo00<0K?o[0?ooo`3oool0
C@3oool00`3oN7l0omOI0?ooo`1V0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1a
Kf@00P3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08X0h=oS00D0Oifi0>3O
h`3Pgn<0W9bN0?ooo`020>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo0000
1@1VIWh0nocm0:RY^`1VIWh0LFmT00D0oooo00<0Ogmo0?ooo`3oool0<03o
ool00`3ono`0ognI0?ooo`1G0?ooo`050?oXO`3odP00om800?oB003omm<0
@03oool00`1`on`0noon0?ooo`1=0?ooo`030?okn`3oO8<0ooOg06H0oooo
00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0509bLWP3oool0h=oS0>3O
h`1oWKT0RP3Pgn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR
06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@01@3o
ool00`1oOgl0oooo0?ooo`0`0?ooo`030?n3W03oloD0oooo05L0oooo00D0
ooWK0?oB003odP00omHH0?onn`100?ooo`030;?om@2[oo@0oooo04h0oooo
00<0ooOg0?n?U@3olo@0I@3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080
h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2:0>3Oh`0507nM^@3Pgn<0h=oS
09bLWP3oool00P3Pgn<0103akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn
0?_lo@2XZK/0IVIn075_I0050?ooo`0307moO`3oool0oooo0300oooo00<0
ofb:0?ooo`3oool0F03oool00`3oea`0om800?oRF0120?ooo`0307Sok@3c
ood0oooo04h0oooo00<0oo_k0?n?U@3omoL0I03oool01@3akn80h=oS0>3O
h`3Pgn<0LFmT0080h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2:0>3Oh`05
07nM^@3Pgn<0h=oS09bLWP3oool00P3Pgn<0103akn80IVIn0:RY^`3ko?d1
0?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I0050?ooo`0307moO`3oool0
oooo02l0oooo00<0ok?20?n[_03oool0F@3oool00`3oiW00om800?ob/`12
0?ooo`030?_ooP1oonh0oooo04l0oooo00<0ooOg0?mdN`3omoL0H`3oool0
1@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00D0W9bN0?ooo`3Pgn<0h=oS
07nM^@2:0>3Oh`0507nM^@3Pgn<0h=oS09bLWP3oool00P3Pgn<0103akn80
IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I0050?oo
o`0307moO`3oool0oooo02l0oooo00<0og2=0?oko03oool0D`3oool00`2U
Jol0oooo0?ooo`030?ooo`030?od_`3odP<0ookg04<0oooo00<0Ooo^0?oo
o`3oool0C`3oool00`3ocm40oh>90?ooo`1R0?ooo`050?7_hP3Pgn<0h=oS
0>3Oh`1aKf@00P3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08X0h=oS00D0
Oifi0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40
oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT00D0oooo00<0Ogmo0?ooo`3o
ool0;P3oool00`3ono`0ognI0?ooo`1C0?ooo`030=g7o`1e6ol0oooo00@0
oooo00<0ookk0?oI;03oool0@`3oool00`23onh0loom0?ooo`1@0?ooo`03
0?n7S@3ocm40oooo0640oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3O
h`0509bLWP3oool0h=oS0>3Oh`1oWKT0RP3Pgn<01@1oWKT0h=oS0>3Oh`2L
W9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3k
o?d0Z:Vk06IVOP1aKf@01@3oool00`1oOgl0oooo0?ooo`0^0?ooo`030?mh
U03oloD0oooo05<0oooo00<0/Goo06H3o`3ekol01@3oool00`3ojHH0oooo
0?ooo`120?ooo`030?_ooP1oonh0oooo0500oooo00<0oo_k0?mPJ03olo@0
H@3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00D0W9bN0?ooo`3P
gn<0h=oS07nM^@2:0>3Oh`0507nM^@3Pgn<0h=oS09bLWP3oool00P3Pgn<0
103akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_
I0050?ooo`0307moO`3oool0oooo02d0oooo00<0ok?20?n[_03oool0E03o
ool00`28??l0I03o0<2Go`1;0?ooo`0307ookP3oool0oooo0500oooo00<0
omoQ0?moQP3oool0H03oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS
00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2:0>3Oh`0507nM^@3Pgn<0h=oS09bL
WP3oool00P3Pgn<0103akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_l
o@2XZK/0IVIn075_I0050?ooo`0307moO`3oool0oooo02d0oooo00<0og2=
0?oko03oool0D`3oool0103Yfol0IPCo06@0o`2GE?m;0?ooo`0307ookP3o
ool0oooo0540oooo00<0ohnE0?o7bP3oool0G`3oool01@3akn80h=oS0>3O
h`3Pgn<0LFmT0080h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2:0>3Oh`05
07nM^@3Pgn<0h=oS09bLWP3oool00P3Pgn<0103akn80IVIn0:RY^`3ko?d1
0?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I0050?ooo`0307moO`3oool0
oooo02d0oooo00<0ofb:0?ooo`3oool0D`3oool01@32Vol0I03o06@0o`1`
5?l0n??o04X0oooo00<0Poo^0??oo@3oool0D@3oool00`3ono/0oeaT0?og
m`1O0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<01@2LW9h0oooo
0>3Oh`3Pgn<0Oifi08X0h=oS00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`020>3O
h`040?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0
LFmT00D0oooo00<0Ogmo0?ooo`3oool0;03oool00`3o/l80oj^l0?ooo`1D
0?ooo`0509E@o`1T0?l0I03o06@0o`3A/ol0BP3oool00`3kooh0L?o/0?oo
o`1B0?ooo`030?o?d@3oPhT0oooo05h0oooo00D0lNoR0>3Oh`3Pgn<0h=oS
075_I0020>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0RP3Pgn<01@1oWKT0
h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool0
000506IVOP3ko?d0Z:Vk06IVOP1aKf@01@3oool00`1oOgl0oooo0?ooo`0[
0?ooo`030?oko03oN9@0oo_l05@0oooo00<0n??o06T8o`1T0?l00P1T0?l0
0`2QI?l0oooo0?ooo`190?ooo`0308?okP3cood0oooo0580oooo00<0ohN=
0?o?d@3oool0G@3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00D0
W9bN0?ooo`3Pgn<0h=oS07nM^@2:0>3Oh`0507nM^@3Pgn<0h=oS09bLWP3o
ool00P3Pgn<0103akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2X
ZK/0IVIn075_I0050?ooo`0307moO`3oool0oooo02X0oooo00<0oo_l0?n?
YP3oloD0E@3oool00`3>[ol0I03o06@0o`0206@0o`0306h@o`3mnol0oooo
04T0oooo00<0noon07ookP3oool0DP3oool00`3ono/0ogQo0?ocm01M0?oo
o`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<01@2LW9h0oooo0>3Oh`3P
gn<0Oifi08X0h=oS00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`040?7_
hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT00D0
oooo00<0Ogmo0?ooo`3oool0:P3oool00`3oN9@0oo?e0?ooo`1E0?ooo`03
09MDo`1T0?l0I03o00<0I03o00<0gl_o0?ooo`3oool0AP3oool0102gooD0
gook0?ooo`1oonh50?ooo`0309oolP3oool0oooo04`0oooo00<0oo_k0?n?
U@3olo@0G03oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00D0W9bN
0?ooo`3Pgn<0h=oS07nM^@2:0>3Oh`0507nM^@3Pgn<0h=oS09bLWP3oool0
0P3Pgn<0103akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0
IVIn075_I0050?ooo`0307moO`3oool0oooo02T0oooo00<0ok?20?n[_03o
ool0EP3oool00`1`5?l0I03o06@0o`0306@0o`030:Q`o`3oool0oooo04H0
oooo00@0cooi00cog`2Ooo80Ooo^0`3oool00`3[oo`0C?oW06Soj`1?0?oo
o`030?okn`3oM7/0ooOg05/0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I002
0>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0RP3Pgn<01@1oWKT0h=oS0>3O
h`2LW9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool0000506IV
OP3ko?d0Z:Vk06IVOP1aKf@01@3oool00`1oOgl0oooo0?ooo`0Y0?ooo`03
0?mTQ03ono`0oooo05D0oooo00<0h/oo06@0o`1T0?l0101T0?l00`1o;?l0
oooo0?ooo`170?ooo`0901coh@00omd0;?oR0?_ooP3oool0cooi01Soh000
omd0/ooe0500oooo00<0oloA0?n3R@3oool0FP3oool01@3akn80h=oS0>3O
h`3Pgn<0LFmT0080h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2:0>3Oh`05
07nM^@3Pgn<0h=oS09bLWP3oool00P3Pgn<0103akn80IVIn0:RY^`3ko?d1
0?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I0050?ooo`0307moO`3oool0
oooo02P0oooo00<0ok?20?n[_03oool0EP3oool01P2[M?l0I03o06@0o`20
;_l0fl?o07l/o`80I03o00<0jM_o0?ooo`3oool0AP3oool02@1hond00?oM
003og@0^on<0Ooo^00SogP00omd02?oN0?OooP1A0?ooo`030?n7S@3ocm40
oooo05T0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0509bLWP3o
ool0h=oS0>3Oh`1oWKT0RP3Pgn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo0080
h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IV
OP1aKf@01@3oool00`1oOgl0oooo0?ooo`0W0?ooo`030?oko03oN9@0oo_l
05L0oooo00T0Obco06h@o`2GE?l0n??o0?ooo`3hlol0YVco06@0o`2dPol0
B03oool00`2oooH00?oM003og@04003og@0305Soj@3oool0oooo0500oooo
00<0oo_k0?mTK03ono/0F@3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080
h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2:0>3Oh`0507nM^@3Pgn<0h=oS
09bLWP3oool00P3Pgn<0103akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn
0?_lo@2XZK/0IVIn075_I0050?ooo`0307moO`3oool0oooo02L0oooo00<0
ogRD0?ocm@3oool0EP3oool0103Tdol0O2So0>WKo`2NH?l40?ooo`030;^?
o`28??l0oooo04L0oooo00<0moon013og`00omd01000omd00`2Ooo80oooo
0?ooo`1A0?ooo`030?nc]`3oZjl0oooo05P0oooo00D0lNoR0>3Oh`3Pgn<0
h=oS075_I0020>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0RP3Pgn<01@1o
WKT0h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0nocm0@3o
ool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@01@3oool00`1oOgl0oooo0?oo
o`0V0?ooo`030?nc`P3oZk`0oooo05L0oooo00@0imOo0?Sco`3oool0/Goo
1@3oool00`3Weol0oooo0?ooo`170?ooo`03063ojP00omd00?oM00800?oM
00<01?oN0>?on`3oool0D`3oool00`3oI6`0oo_k0?ooo`1G0?ooo`050?7_
hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi
08X0h=oS00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`040?7_hP1VIWh0
Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT00D0oooo00<0
Ogmo0?ooo`3oool09@3oool00`3ono`0ogRD0?oko01J0?ooo`030?gko`2a
Ool0oooo04h0oooo00<0[ood003og@00omd00P00omd00`10onH0oooo0?oo
o`1C0?ooo`030?nc]`3oZjl0oooo05L0oooo00D0lNoR0>3Oh`3Pgn<0h=oS
075_I0020>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0RP3Pgn<01@1oWKT0
h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool0
000506IVOP3ko?d0Z:Vk06IVOP1aKf@01@3oool00`1oOgl0oooo0?ooo`0T
0?ooo`030?oko03oSjH0oo?e05/0oooo00<0]8?o0?Sco`3oool0CP3oool0
0`3kooh04?oO003og@02003og@0308?okP3oool0oooo05@0oooo00<0ofac
0?o_l03oool0EP3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00D0
W9bN0?ooo`3Pgn<0h=oS07nM^@2:0>3Oh`0507nM^@3Pgn<0h=oS09bLWP3o
ool00P3Pgn<0103akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2X
ZK/0IVIn075_I0050?ooo`0307moO`3oool0oooo02<0oooo00<0oo_l0?n?
YP3oloD0G03oool00`2NH?l0oooo0?ooo`1?0?ooo`0504coi`00omd00?oM
003og@3Ooo/0EP3oool00`3olo@0ogQo0?o_l01F0?ooo`050?7_hP3Pgn<0
h=oS0>3Oh`1aKf@00P3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08X0h=oS
00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`040?7_hP1VIWh0Z:Vk0?_l
o@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT00D0oooo00<0Ogmo0?oo
o`3oool08P3oool00`3ono`0ohnV0?ocm@1L0?ooo`030?gko`2aOol0oooo
0500oooo00@0Yooc003og@00omd09?oRF03oool00`3omoL0ogAk0?okn`1E
0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<01@2LW9h0oooo0>3O
h`3Pgn<0Oifi08X0h=oS00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`04
0?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT
00D0oooo00<0Ogmo0?ooo`3oool08@3oool00`3ono`0ohnV0?ocm@1M0?oo
o`030;B3o`3hlol0oooo0500oooo00@0iool00CogP00omd0I?oZF@3oool0
0`3o/kL0oj^_0?ooo`1D0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3P
gn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08X0h=oS00D0Oifi0>3Oh`3Pgn<0
W9bN0?ooo`020>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0
nocm0:RY^`1VIWh0LFmT00D0oooo00<0Ogmo0?ooo`3oool07@3oool01P3o
no`0ogRD0?l<?P3o23X0ocYR0?oXjeh0oooo00<0/Goo0?ooo`3oool0D@3o
ool00`0hon@00?oM0;oomP1J0?ooo`030?m/L`3oool0oooo05<0oooo00D0
lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0509bLWP3oool0h=oS0>3Oh`1o
WKT0RP3Pgn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IV
OP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@01@3oool0
0`1oOgl0oooo0?ooo`0M0?ooo`030?mhU03o03@0o`0d0080o`0d00<0og2=
0?ooo`3oool0F`3oool00`3mnol0/Goo0?ooo`1B0?ooo`0309?ol@06omh0
noon05X0oooo00<0ogn60?ooo`3oool0D`3oool01@3akn80h=oS0>3Oh`3P
gn<0LFmT0080h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2:0>3Oh`0507nM
^@3Pgn<0h=oS09bLWP3oool00P3Pgn<0103akn80IVIn0:RY^`3ko?d10?oo
o`0000D0IVIn0?_lo@2XZK/0IVIn075_I0050?ooo`0307moO`3oool0oooo
01d0oooo00<0o``n0?l0=03o03@00P3o03@00`3o23X0oooo0?ooo`1K0?oo
o`030;B3o`3hlol0oooo0580oooo00<0gook02CohP3oool0FP3oool00`3o
L7L0oo_k0?ooo`1C0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<0
1@2LW9h0oooo0>3Oh`3Pgn<0Oifi08X0h=oS00D0Oifi0>3Oh`3Pgn<0W9bN
0?ooo`020>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm
0:RY^`1VIWh0LFmT00D0oooo00<0Ogmo0?ooo`3oool07@3oool00`3o33h0
o`0d0?l0=0020?l0=0030?l8>P3oool0oooo05X0oooo00<0oO_o0;5oo`3o
ool0E03oool00`1kond0oooo0?ooo`1I0?ooo`030?nc]`3oZjl0oooo05<0
oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0509bLWP3oool0h=oS
0>3Oh`1oWKT0RP3Pgn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo0080h=oS00@0
lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0
1@3oool00`1oOgl0oooo0?ooo`0M0?ooo`030?mfT`3o03@0o`0d0080o`0d
00<0og2=0?ooo`3oool0FP3oool00`2dPol0n??o0?ooo`2a0?ooo`030?mT
K03ono/0oooo0580oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`05
09bLWP3oool0h=oS0>3Oh`1oWKT0RP3Pgn<01@1oWKT0h=oS0>3Oh`2LW9h0
oooo0080h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0
Z:Vk06IVOP1aKf@01@3oool00`1oOgl0oooo0?ooo`0L0?ooo`070?oko03o
PI/0og:?0?l<?P3o23X0og2=0?ocm@1L0?ooo`030:I/o`3oool0oooo05`0
oooo00<0olN?0?ooo`3oool0DP3oool00`3o/kL0oj^_0?ooo`1B0?ooo`05
0?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0
Oifi08X0h=oS00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`040?7_hP1V
IWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT00D0oooo
00<0Ogmo0?ooo`3oool06`3oool00`3ono`0ohnV0?ocm@1P0?ooo`030=6c
o`3<Zol0oooo05d0oooo00<0ojA80?ooo`3oool0D`3oool00`3oN7l0oo?d
0?ooo`1A0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<01@2LW9h0
oooo0>3Oh`3Pgn<0Oifi08X0h=oS00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`02
0>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1V
IWh0LFmT00D0oooo00<0Ogmo0?ooo`3oool06P3oool00`3ono`0ohnV0?oc
m@1Q0?ooo`030:Q`o`3mnol0oooo05`0oooo00<0oo_g0?n6303onoL0E03o
ool00`3ono/0ogn60?ooo`1A0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@0
0P3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08X0h=oS00D0Oifi0>3Oh`3P
gn<0W9bN0?ooo`020>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1V
IWh0nocm0:RY^`1VIWh0LFmT00D0oooo00<0Ogmo0?ooo`3oool06@3oool0
0`3ono`0ohnV0?ocm@1Q0?ooo`030?gko`2aOol0oooo05d0oooo00<0omno
0?n0003ofkL0E@3oool00`3oOhH0oooo0?ooo`1@0?ooo`050?7_hP3Pgn<0
h=oS0>3Oh`1aKf@00P3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08X0h=oS
00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`040?7_hP1VIWh0Z:Vk0?_l
o@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT00D0oooo00<0Ogmo0?oo
o`3oool0603oool00`3ono`0ohnV0?ocm@1Q0?ooo`030?gko`2kSol0n??o
05h0oooo00<0okil0?n0003o[5P0E@3oool00`3oPhT0oo?d0?ooo`1@0?oo
o`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<01@2LW9h0oooo0>3Oh`3P
gn<0Oifi08X0h=oS00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`040?7_
hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT00D0
oooo00<0Ogmo0?ooo`3oool05`3oool00`3o^lT0ognI0?ocm@1R0?ooo`03
0:eho`3hlol0oooo05h0oooo00@0oi0P0?n0003oS1P0oogkE03oool00`3o
no/0ogn60?ooo`1@0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<0
1@2LW9h0oooo0>3Oh`3Pgn<0Oifi08X0h=oS00D0Oifi0>3Oh`3Pgn<0W9bN
0?ooo`020>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm
0:RY^`1VIWh0LFmT00D0oooo00<0Ogmo0?ooo`3oool05P3oool00`3oH800
ojno0?ooo`1R0?ooo`030=6co`3<Zol0oooo05h0oooo00D0ongK0?n0003o
P000oh000?oSa`1E0?ooo`030?n3R@3olo@0oooo04l0oooo00D0lNoR0>3O
h`3Pgn<0h=oS075_I0020>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0RP3P
gn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0
nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@01@3oool00`1oOgl0
oooo0?ooo`0E0?ooo`030?nc`P3oZk`0oooo06<0oooo00<0Z73o0?gko`3o
ool0GP3oool01@3oahl0oh000?n0003oP000okYd05<0oooo00@0ooOg0?ok
n`3ono/0ogn61P3oool00`3omoL0oooo0?ooo`170?ooo`050?7_hP3Pgn<0
h=oS0>3Oh`1aKf@00P3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08X0h=oS
00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`040?7_hP1VIWh0Z:Vk0?_l
o@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT00D0oooo00<0Ogmo0?oo
o`3oool0503oool00`3ono`0ogRD0?oko01T0?ooo`030:I/o`3oool0oooo
05h0oooo00H0oihl0?n0003oP000oh000?nD:03ooO]B0?ooo`040?o_l03o
D5T0on_/0?moQP@0oooo00<0oo?d0?mXL03ocm40B@3oool01@3akn80h=oS
0>3Oh`3Pgn<0LFmT0080h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2:0>3O
h`0507nM^@3Pgn<0h=oS09bLWP3oool00P3Pgn<0103akn80IVIn0:RY^`3k
o?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I0050?ooo`0307moO`3o
ool0oooo01<0oooo00<0ok?20?mlU`3oloD0I03oool00`3A/ol0c:_o0?oo
o`1N0?ooo`030?oej`3oPP@0oh0000<0oh0000<0onG;0?ooo`3oool0D@3o
ool00`3oD5T0ob0[0?mQJ@030?ooo`030?oGf@3o;3L0ob`g04X0oooo00D0
lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0509bLWP3oool0h=oS0>3Oh`1o
WKT0RP3Pgn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IV
OP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@01@3oool0
0`1oOgl0oooo0?ooo`0A0?ooo`040?oko03oM900oj^l0?oko6@0oooo00<0
oO_o0:eho`3mnol0G`3oool00`3obI<0oh000?n000030?n000030?o5R`3o
ool0oooo0540oooo00T0oi^P0?l03@3o0Pl0ohnE0?okn`3oYj/0oa0L0?l0
3@3oM7/0BP3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00D0W9bN
0?ooo`3Pgn<0h=oS07nM^@2:0>3Oh`0507nM^@3Pgn<0h=oS09bLWP3oool0
0P3Pgn<0103akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0
IVIn075_I0050?ooo`0307moO`3oool0oooo0100oooo00<0oo_l0?n?YP3o
loD0I@3oool00`3mnol0^hoo0?Sco`1P0?ooo`030?nZE03oP000oh0000<0
oh0000<0oiP`0?ooo`3oool0D@3oool01@3oinP0o`PE0?l03@3o00d0ob`g
00<0o`0=00<0om?E0?ooo`3oool0B03oool01@3akn80h=oS0>3Oh`3Pgn<0
LFmT0080h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2:0>3Oh`0507nM^@3P
gn<0h=oS09bLWP3oool00P3Pgn<0103akn80IVIn0:RY^`3ko?d10?ooo`00
00D0IVIn0?_lo@2XZK/0IVIn075_I0050?ooo`0307moO`3oool0oooo00l0
oooo00<0oo_l0?n?YP3oloD0I@3oool00`3ekol0]8?o0?Sco`1P0?ooo`03
0?omn`3oRQ@0oh0000D0oh0000<0ooG[0?ooo`3oool0D@3oool00`3o?4H0
o`0=0?l03@030?l03@030?lH903ono/0oooo04T0oooo00D0lNoR0>3Oh`3P
gn<0h=oS075_I0020>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0RP3Pgn<0
1@1oWKT0h=oS0>3Oh`2LW9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0nocm
0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@01@3oool00`1oOgl0oooo
0?ooo`0>0?ooo`030?nc`P3oO9L0oo?e06D0oooo00<0n??o0:5To`3cjol0
H@3oool01P3ofK<0oh000?n0003oVS@0onO?0?nXD080oh0000<0olfK0?oo
o`3oool0D@3oool00`3oO8<0o`0=0?l03@030?l03@030?mXL03oool0oooo
04T0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0509bLWP3oool0
h=oS0>3Oh`1oWKT0RP3Pgn<01@1oWKT0h=oS0>3Oh`2LW9h0oooo0080h=oS
00@0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1a
Kf@01@3oool00`1oOgl0oooo0?ooo`0<0?ooo`040?oko03oM900oj^l0?ok
o6H0oooo00<0Z73o0?G_o`3oool0H@3oool0103o]V`0oh000?nG;@3onoL2
0?ooo`030?o;U`3oQ0P0oj9405<0oooo00<0oloA0?l03@3o00d00`3o00d0
0`3o/kL0oooo0?ooo`190?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3P
gn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08X0h=oS00D0Oifi0>3Oh`3Pgn<0
W9bN0?ooo`020>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0
nocm0:RY^`1VIWh0LFmT00D0oooo00<0Ogmo0?ooo`3oool02`3oool00`3o
no`0ohnV0?ocm@1W0?ooo`030=6co`3<Zol0oooo0640oooo00@0oogk0?nD
:03ofK<0okmo103oool00`3ogkl0oi@X0?oci`1C0?ooo`060?lP:`3o00d0
o`0=0?l03@3o41`0ono`B`3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080
h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2:0>3Oh`0507nM^@3Pgn<0h=oS
09bLWP3oool00P3Pgn<0103akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn
0?_lo@2XZK/0IVIn075_I0050?ooo`0307moO`3oool0oooo00X0oooo00<0
ok?20?mlU`3oloD0I`3oool00`3mnol0[GSo0?gko`1R0?ooo`040?oej`3o
kml0oogk0?noO`D0oooo00<0ooWc0?oah`3oool0DP3oool01@3oJ700o`0=
0?l03@3o00d0of1X04`0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3O
h`0509bLWP3oool0h=oS0>3Oh`1oWKT0RP3Pgn<01@1oWKT0h=oS0>3Oh`2L
W9h0oooo0080h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3k
o?d0Z:Vk06IVOP1aKf@01@3oool00`1oOgl0oooo0?ooo`080?ooo`040?ok
o03oM900oj^l0?oko6P0oooo00<0[GSo0?Sco`3oool0I03oool00`3o^W@0
ooWc0?ooo`1I0?ooo`050?no`P3o00d0o`0=0?l03@3oYj/0C03oool01@3a
kn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM
^@2:0>3Oh`0507nM^@3Pgn<0h=oS09bLWP3oool00P3Pgn<0103akn80IVIn
0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I0050?ooo`03
07moO`3oool0oooo00L0oooo00<0oo_l0?n?YP3oloD0J@3oool00`3A/ol0
c:_o0?ooo`1U0?ooo`030?noO`3oool0oooo05T0oooo00D0ooOg0?l85@3o
00d0o`PE0?ogm`1<0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<0
1@2LW9h0oooo0>3Oh`3Pgn<0Oifi08X0h=oS00D0Oifi0>3Oh`3Pgn<0W9bN
0?ooo`020>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm
0:RY^`1VIWh0LFmT00D0oooo00<0Ogmo0?ooo`3oool01P3oool00`3o/l80
ogbG0?ocm@1Y0?ooo`030=6co`2QI?l0oO_o06D0oooo00<0oogk0?noO`3o
ool0F`3oool00`3oF640o`0=0?m0BP1=0?ooo`050?7_hP3Pgn<0h=oS0>3O
h`1aKf@00P3Pgn<0102LW9h0oooo0>3Oh`3Pgn><07nM^@80h=oS00P0W9bN
0?ooo`3Pgn<0h=oS0?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm
0:RY^`1VIWh0LFmT00D0oooo00<0Ogmo0?ooo`3oool0103oool0103ono`0
ogB@0?n[_03onoaX0?ooo`040?gko`2[M?l0c:_o0?gkofH0oooo00<0ol63
0?oil`3oool0F`3oool00`3oYj/0o`0=0?nGW01=0?ooo`050?7_hP3Pgn<0
h=oS0>3Oh`1aKf@00P3Pgn<00`2LW9h0oooo0>3Oh`2?0>3Oh`0809bLWP3o
ool0h=oS0>3Oh`3akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2X
ZK/0IVIn075_I0050?ooo`0307moO`3oool0oooo00<0oooo00<0oo_l0?n?
YP3oloD0J@3oool00`3mnol0^hoo0?Sco`1W0?ooo`030?omn`3o_gl0oooo
05`0oooo00<0onOX0?l23`3ohn@0C@3oool01@3akn80h=oS0>3Oh`3Pgn<0
LFmT0080h=oS00<0W9bN0?ooo`3Pgn<0S`3Pgn<0202LW9h0oooo0>3Oh`3P
gn<0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1a
Kf@01@3oool0201oOgl0oooo0?ooo`3oool0omoV0?n;X`3oOiT0oo?eJ@3o
ool00`3mnol0^hoo0?Sco`1X0?ooo`030?o1P`3onO<0oooo05d0oooo00<0
oc<m0?ooo`3oool0C03oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS
00<0W9bN0?ooo`3Pgn<0S`3Pgn<0202LW9h0oooo0>3Oh`3Pgn<0lNoR06IV
OP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@01@3oool0
1P1oOgl0oooo0?o?f@3oI8@0ohNO0?oOiVX0oooo00<0oO_o0;^?o`3hlol0
J03oool00`3ooO/0okmo0?ooo`1N0?ooo`030?n8S`3oool0oooo04`0oooo
00D0lNoR0>3Oh`3Pgn<0h=oS075_I0020>3Oh`0309bLWP3oool0h=oS08l0
h=oS00P0W9bN0?ooo`3Pgn<0h=oS0?7_hP1VIWh0Z:Vk0?_lo@40oooo0000
1@1VIWh0nocm0:RY^`1VIWh0LFmT00D0oooo00@0PGen0?n7W`3oPi`0oo_l
I`3oool01`3mnol0[GSo06/<o`1Y2?l0Yfko0;N8o`3hlol0J@3oool00`3o
`H<0ooWc0?ooo`2]0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<0
0`2LW9h0oooo0>3Oh`2?0>3Oh`0809bLWP3oool0h=oS0>3Oh`3akn80IVIn
0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I0040?ooo`03
0?o?f@3?<500oloI06T0oooo00<0[GSo06@0o`1T0?l00P1T0?l00`2UJol0
oooo0?ooo`1W0?ooo`030?oil`3o^W@0oooo0:h0oooo00D0lNoR0>3Oh`3P
gn<0h=oS075_I0020>3Oh`0309bLWP3oool0h=oS08l0h=oS00P0W9bN0?oo
o`3Pgn<0h=oS0?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY
^`1VIWh0LFmT0080oooo00@0oo_l0?n7W`3oPi`0PGenJP3oool00`1[3?l0
I03o06@0o`0206@0o`0306T8o`3oool0oooo06L0oooo00<0okil0?ogk`3o
ool0[P3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00<0W9bN0?oo
o`3Pgn<0S`3Pgn<0202LW9h0oooo0>3Oh`3Pgn<0lNoR06IVOP2XZK/0nocm
0@3oool0000;06IVOP3ko?d0Z:Vk06IVOP1aKf@0oooo0?oko03oM900oloI
0?ooo`1oOgl00`3oool03P3_knl0H61P04A4A00h>3P0alO70?ooo`2?Shl0
M7Ad0?ooo`3Ogml0=3@d0410@00d=3@0Xj>SF@3oool00`1[3?l0I03o06@0
o`0206@0o`0306T8o`3oool0oooo06H0oooo0P3o^72`0?ooo`050?7_hP3P
gn<0h=oS0>3Oh`1aKf@00P3Pgn<00`2LW9h0oooo0>3Oh`2?0>3Oh`0809bL
WP3oool0h=oS0>3Oh`3akn80IVIn0:RY^`3ko?d10?ooo`0000P0IVIn0?_l
o@2XZK/0IVIn075_I03oWk<0oh>L0?ocm@80oooo01<0Ogmo0?ooo`3oool0
oooo06QXJ02;Rh/0oooo0;no_`0`<300oooo0=oOg`3GemL0oooo03`l?02k
^k/0oooo0>?Sh`0P8200fm_K05P0oooo00<0Q3Go06@0o`1T0?l00P1T0?l0
0`2XL?l0oooo0?ooo`1R0?ooo`060?omn`3o_7P0ohH<0?n4203oW3P0ooWc
/03oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT0080h=oS00<0W9bN0?ooo`3P
gn<0103Pgn<00`000000h=oS0>3Oh`040>3Oh`80000000@0h=oS0000003P
gn<00000103Pgn<2000000040>3Oh`000000h=oS00000080h=oS00@00000
0>3Oh`3Pgn<000000P3Pgn<300000080h=oS0P0000020>3Oh`<000000P3P
gn<00`000000h=oS0>3Oh`020>3Oh`<00000EP3Pgn<0202LW9h0oooo0>3O
h`3Pgn<0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IV
OP1aKf@01@3oool01P1oOgl0oooo0?ooo`3oool092@T0=OGe`80oooo00<0
410@0>o_k`3oool00P3oool01P000000oooo0?ooo`3oool0@4100;no_eH0
oooo00P0oO_o0;5oo`2WK_l0[GSo06/<o`1Y2?l0Z73o0?Scof@0oooo00<0
okah0?n0003oP0000P3oP0000`3o^700oooo0?ooo`2^0?ooo`050?7_hP3P
gn<0h=oS0>3Oh`1aKf@00P3Pgn<00`2LW9h0oooo0>3Oh`040>3Oh`030000
003Pgn<0h=oS00<0h=oS00<000000>3Oh`3Pgn<00P0000000`3Pgn<00000
0>3Oh`020>3Oh`030000003Pgn<0h=oS0080000000D0h=oS0000003Pgn<0
h=oS000000020>3Oh`030000003Pgn<0000000<0h=oS00<000000>3Oh`00
00000P3Pgn<01`000000h=oS0>3Oh`3Pgn<000000>3Oh`0000000`3Pgn<0
1@000000h=oS0>3Oh`3Pgn<0000005D0h=oS00P0W9bN0?ooo`3Pgn<0h=oS
0?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT
00D0oooo00H0Ogmo0?ooo`3oool0oooo0000003kno/20?ooo`03020P803O
gml0oooo0080oooo00H0@41008n?S`3oool0^k^k03`l?03_knmE0?ooo`03
0?gko`2kSol0n??o06X0oooo00<0ohH<0?n0003oP0000P3oP0000`3oQ0P0
oooo0?ooo`2^0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@00P3Pgn<00`2L
W9h0oooo0>3Oh`040>3Oh`030000003Pgn<0h=oS00<0h=oS00L000000>3O
h`3Pgn<0h=oS0000003Pgn<0000000<0h=oS00L000000>3Oh`3Pgn<0h=oS
0000003Pgn<000000080h=oS00H000000>3Oh`3Pgn<000000>3Oh`000005
0>3Oh`040000003Pgn<0h=oS000000D0h=oS00<000000>3Oh`3Pgn<0103P
gn<00`000000h=oS0>3Oh`1D0>3Oh`0809bLWP3oool0h=oS0>3Oh`3akn80
IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I0050?oo
o`0607moO`3oool0oooo0?ooo`0410@0no_k0P3oool00`0P8200gmoO0?oo
o`020?ooo`050=?Cd`0L71`0@41001@D502g]kL0E@3oool00`3A/ol0[gco
0?Sco`1[0?ooo`030?n6303oP000oh000080oh0000<0oh@80?ooo`3oool0
P@3oool00`3o^6/0oooo0?ooo`0Z0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1a
Kf@00P3Pgn<00`2LW9h0oooo0?ooo`030?ooo`030>3Oh`00000000000080
00000`3Pgn<4000000030>3Oh`000000h=oS00<0h=oS100000001@3Pgn<0
00000>3Oh`3Pgn<000000080h=oS00<000000>3Oh`00000010000000103P
gn<000000>3Oh`3Pgn<5000000030>3Oh`000000h=oS00<0h=oS0P000004
0>3Ohe<0oooo00P0W9bN0?ooo`3Pgn<0h=oS0?7_hP1VIWh0Z:Vk0?_lo@40
oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT00<0oooo00P0WinO07moO`0o
?cl0Ogmo09nOW`3oool092@T0=OGe`80oooo00<0410@0?Ogm`3oool00P3o
ool01@1`L700Vi^K0?ooo`33`l<0;2`/05<0oooo00@0oO_o0:]do`3<Zol0
oO_oK03oool00`3o_7P0oh000?n000020?n000030?nhL03oool0oooo0840
oooo00<0oi0K0?oTa`3oool0:P3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT
0080h=oS1P2LW9h00`3Pgn<000000>3Oh`020>3Oh`030000003Pgn<00000
00<0h=oS00@000000>3Oh`00000000000P3Pgn<01P000000h=oS0>3Oh`3P
gn<000000>3Oh`80000000L0h=oS000000000000h=oS0000003Pgn<00000
00<0h=oS00<000000>3Oh`0000000P3Pgn<01P000000h=oS0>3Oh`3Pgn<0
00000>3Oh`8000000P3Pgn<01@000000h=oS0>3Oh`3Pgn<000000080h=oS
E02LW9h01`3oool0h=oS0>3Oh`3akn80IVIn0:RY^`3ko?d00@3oool00005
06IVOP3ko?d0Z:Vk06IVOP1aKf@01@3oool02@1oOgl0oooo0?ooo`3oool0
H61P08n?S`3oool0bl_;03Ph>0040?ooo`0506ATI02KVi/0oooo0<?3``0P
8200DP3oool00`3mnol0^hoo0?Sco`1^0?ooo`060?ngKP3oVcD0ohH<0?n4
203o^700ooWcPP3oool00`3onoL0ohD30?nmN00[0?ooo`050?7_hP3Pgn<0
h=oS0>3Oh`1aKf@02@3Pgn<01@000000h=oS0>3Oh`3Pgn<000000080h=oS
0`0000020>3Oh`030000003Pgn<000000080h=oS0`0000020>3Oh`030000
003Pgn<000000080h=oS00@000000>3Oh`3Pgn<0h=oS0`000000103Pgn<0
00000000000000020>3Oh`<000000P3Pgn<00`000000h=oS000000020>3O
h`<00000FP3Pgn<0103akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_l
o@2XZK/0IVIn075_I0050?ooo`0907moO`3oool0oooo0?ooo`3Shn<0?3`l
0410@014A4@0dm?C00@0oooo00D0emOG03`l?014A4@0;2`/0;^k^`1A0?oo
o`030?gko`2kSol0n??o06h0oooo00<0oogk0?noO`3oool0QP3oool0103o
g[/0oh<00?nH;03ooO/Z0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@02@3P
gn<01@000000h=oS0>3Oh`3Pgn<0000001l0h=oS00<000000>3Oh`3Pgn<0
J03Pgn<0103akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0
IVIn075_I0050?ooo`0307moO`3oool0oooo05l0oooo00<0oO_o0;^?o`3h
lol0K`3oool00`3o`H<0ooWc0?ooo`260?ooo`040?nbH03oP`00oh<00?oZ
dbX0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I0090>3Oh`@00000803Pgn<0
0`000000h=oS0>3Oh`1X0>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo0000
1@1VIWh0nocm0:RY^`1VIWh0LFmT00D0oooo00<0Ogmo0?ooo`3oool0GP3o
ool00`3A/ol0[gco0?Sco`1^0?ooo`030?omn`3o_gl0okQ`08H0oooo00<0
oogk0?nmN03oQ0400P3oP`000`3oah`0oooo0?ooo`0X0?ooo`050?7_hP3P
gn<0h=oS0>3Oh`1aKf@0V03Pgn<0103akn80IVIn0:RY^`3ko?d10?ooo`00
00D0IVIn0?_lo@2XZK/0IVIn075_I0050?ooo`0307moO`3oool0oooo05`0
oooo00@0oO_o0:]do`3<Zol0oO_oK`3oool00`3o`H<0ooWc0?ooo`260?oo
o`030?nmN03oP`00oh<00080oh<000<0oi8P0?ooo`3oool0:03oool01@3a
kn80h=oS0>3Oh`3Pgn<0LFmT09P0h=oS00@0lNoR06IVOP2XZK/0nocm0@3o
ool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@01@3oool00`1oOgl0oooo0?oo
o`1K0?ooo`030=6co`2_O?l0n??o0700oooo00<0oogk0?noO`3oool0Q`3o
ool00`3oR@`0oh<00?n300030?n300030?oej`3oool0oooo02L0oooo00D0
lNoR0>3Oh`3Pgn<0h=oS075_I02H0>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40
oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT00D0oooo00<0Ogmo0?ooo`3o
ool0F@3oool0103mnol0ZgCo0<b[o`3mnom`0?ooo`030?omn`3oahl0ooWc
08P0oooo00<0ohT<0?n3003oP`000`3oP`000`3oeZ/0oooo0?ooo`0W0?oo
o`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@0V03Pgn<0103akn80IVIn0:RY^`3k
o?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I0050?ooo`0307moO`3o
ool0oooo05P0oooo00<0oO_o0;^?o`3hlol0L@3oool00`3ooO/0olN?0?oi
l`290?ooo`030?ncH`3oP`00oh<000<0oh<000<0ojY@0?ooo`3oool09`3o
ool01@3akn80h=oS0>3Oh`3Pgn<0LFmT09P0h=oS00@0lNoR06IVOP2XZK/0
nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@01@3oool00`1oOgl0
oooo0?ooo`1G0?ooo`030=Jko`2aOol0n??o0740oooo00<0oogk0?o7S`3o
nO<0RP3oool00`3obI40oh<00?n300030?n300030?n;403ooO/0oooo02L0
oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I02H0>3Oh`040?7_hP1VIWh0Z:Vk
0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT00D0oooo00<0Ogmo
0?ooo`3oool0E@3oool00`3A/ol0XfSo0<j_o`1b0?ooo`030?omn`3oahl0
ooWc08/0oooo00<0ojY@0?n3003oP`00103oP`000`3og[/0oooo0?ooo`0V
0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@0V03Pgn<0103akn80IVIn0:RY
^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I0050?ooo`0307mo
O`3oool0oooo05<0oooo00@0h/oo0:5To`3<Zol0oO_oLP3oool00`3ooO/0
olN?0?oil`2;0?ooo`090?ogk`3oQ@@0oh<00?n>5`3oh;l0okeh0?n5103o
P`00okQ/02P0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I02H0>3Oh`040?7_
hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT00D0
oooo00<0Ogmo0?ooo`3oool0D@3oool0103mnol0[gco0;R;o`3mnomc0?oo
o`030?oil`3o`hL0ooWc08`0oooo00@0omJ[0?n3003oTAd0oo?W0P3oool0
0`3of:l0ohlH0?nE900X0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@0V03P
gn<0103akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn
075_I0050?ooo`0307moO`3oool0oooo04l0oooo00@0k=oo0;R;o`2QI?l0
gl_oM03oool00`3ooO/0ol630?ogk`2=0?ooo`030?n^F03o`7d0okU`00@0
oooo00<0oo7S0?nN>03oj<l09`3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT
09P0h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk
06IVOP1aKf@01@3oool00`1oOgl0oooo0?ooo`1=0?ooo`040?gko`2]N?l0
]XOo0>cOogD0oooo00<0oogk0?o7S`3onO<0SP3oool00`3oj<l0ok]d0?oi
l`050?ooo`030?omn`3ok=L0oooo02H0oooo00D0lNoR0>3Oh`3Pgn<0h=oS
075_I02H0>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm
0:RY^`1VIWh0LFmT00D0oooo00<0Ogmo0?ooo`3oool0C03oool00`3mnol0
^hoo0?Sco`1f0?ooo`030?oI/`3o_W`0ooWc08l0oooo00<0ooWc0?ndI03o
ool0;P3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT09P0h=oS00@0lNoR06IV
OP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@01@3oool0
0`1oOgl0oooo0?ooo`1:0?ooo`040>cOo`2hRol0/Goo0?ScogD0oooo00@0
oogk0?njM03oeJ/0oogkT03oool00`3o_g`0ooO_0?ooo`0^0?ooo`050?7_
hP3Pgn<0h=oS0>3Oh`1aKf@0CP3Pgn<01@000000h=oS0>3Oh`3Pgn<00000
04D0h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk
06IVOP1aKf@01@3oool00`1oOgl0oooo0?ooo`180?ooo`040>;?o`2QI?l0
]XOo0>cOogH0oooo00<0omVc0?nnO03onO<0TP3oool00`3o/V00oooo0?oo
o`0^0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@0C@3Pgn<00`000000h=oS
0>3Oh`030>3Oh`030000003Pgn<0h=oS0480h=oS00@0lNoR06IVOP2XZK/0
nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@01@3oool00`1oOgl0
oooo0?ooo`160?ooo`040?gko`2fQol0]8?o0?gkogL0oooo00<0ojiL0?oE
Z`3ooO/0TP3oool00`3ooO/0okU`0?ooo`0_0?ooo`050?7_hP3Pgn<0h=oS
0>3Oh`1aKf@0?03Pgn<3000000040>3Oh`0000000000000000@0h=oS1000
00020>3Oh`040000003Pgn<0000000000080h=oS00<000000>3Oh`3Pgn<0
2P3Pgn<2000003H0h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool0000506IV
OP3ko?d0Z:Vk06IVOP1aKf@01@3oool00`1oOgl0oooo0?ooo`150?ooo`03
0>;?o`2NH?l0h/oo07P0oooo00<0omVc0?oEZ`3oool0T`3oool00`3o^g@0
ooWc0?ooo`0_0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@0?@3Pgn<00`00
0000h=oS0>3Oh`030>3Oh`030000003Pgn<0h=oS0080h=oS00<000000>3O
h`0000000P3Pgn<00`000000h=oS000000030>3Oh`030000003Pgn<0h=oS
00X0h=oS00<000000>3Oh`3Pgn<0=@3Pgn<0103akn80IVIn0:RY^`3ko?d1
0?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I0050?ooo`0307moO`3oool0
oooo04<0oooo00@0oO_o0;J7o`2dPol0oO_oN03oool00`3ooO/0okah0?om
n`2C0?ooo`80okU`<@3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT03d0h=oS
00<000000>3Oh`3Pgn<00`3Pgn<00`000000h=oS0>3Oh`030>3Oh`050000
003Pgn<0h=oS0>3Oh`0000000P3Pgn<010000000h=oS0>3Oh`0000070>3O
h`@000000P3Pgn<00`000000h=oS0>3Oh`0d0>3Oh`040?7_hP1VIWh0Z:Vk
0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT00D0oooo00<0Ogmo
0?ooo`3oool0@03oool01@3jmol0f;oo0;J7o`2VK?l0h/oo07T0oooo00<0
omVc0?nnO03onO<0U03oool00`3o`Gl0oooo0?ooo`0`0?ooo`050?7_hP3P
gn<0h=oS0>3Oh`1aKf@0?@3Pgn<00`000000h=oS0>3Oh`030>3Oh`030000
003Pgn<0h=oS0080h=oS00<000000>3Oh`0000000P3Pgn<010000000h=oS
0>3Oh`0000020>3Oh`030000003Pgn<0000000<00000203Pgn<00`000000
h=oS0>3Oh`0d0>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0
nocm0:RY^`1VIWh0LFmT00D0oooo00<0Ogmo0?ooo`3oool0?P3oool01@3R
col0YVco0;J7o`3H_ol0n_Oo07T0oooo00@0omVc0?nbI03oeJ/0oogkU03o
ool20?niL380oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I00m0>3Oh`040000
003Pgn<0h=oS0>3Oh`8000001@3Pgn<4000000030>3Oh`000000h=oS00<0
000000L0h=oS0000003Pgn<0h=oS0000003Pgn<0000000L0h=oS0`00000e
0>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1V
IWh0LFmT00D0oooo00<0Ogmo0?ooo`3oool0?03oool0103mnol0]XOo0;B3
o`3mnomj0?ooo`040?omn`3o^W@0omF[0?omniD0oooo00<0oogk0?o1O`3o
ool0<P3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT03d0h=oS00D000000>3O
h`3Pgn<0h=oS0000000;0>3Oh`040000003Pgn<0h=oS00000080h=oS00D0
00000>3Oh`3Pgn<0h=oS000000090>3Oh`030000003Pgn<0h=oS03@0h=oS
00@0lNoR06IVOP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1a
Kf@01@3oool00`1oOgl0oooo0?ooo`0k0?ooo`030>;?o`2NH?l0h/oo07/0
oooo00<0oogk0?o7S`3onO<0UP3oool00`3ooO/0ol>30?oil`0c0?ooo`05
0?7_hP3Pgn<0h=oS0>3Oh`1aKf@08P3Pgn<01@000000h=oS0>3Oh`3Pgn<0
000001D0h=oS0P0000040>3Oh`8000002P3Pgn<01@000000h=oS0>3Oh`3P
gn<0000000D0h=oS00<000000>3Oh`3Pgn<0?@3Pgn<0103akn80IVIn0:RY
^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I0050?ooo`0307mo
O`3oool0oooo03T0oooo00@0oO_o0;J7o`2dPol0oO_oN`3oool00`3ogkl0
okil0?oil`2G0?ooo`030?o3P`3onO<0oooo03<0oooo00D0lNoR0>3Oh`3P
gn<0h=oS075_I00Q0>3Oh`030000003Pgn<0h=oS00<0h=oS00<000000>3O
h`3Pgn<0;P3Pgn<00`000000h=oS0>3Oh`0m0>3Oh`040?7_hP1VIWh0Z:Vk
0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT00D0oooo00<0Ogmo
0?ooo`3oool0=P3oool01@3hlol0e[_o0;B3o`2VK?l0h/oo07/0oooo00@0
omVc0?nfK03ofK<0oogkU`3oool20?niL3D0oooo00D0lNoR0>3Oh`3Pgn<0
h=oS075_I00G0>3Oh`@000001@3Pgn<00`000000h=oS0>3Oh`02000000<0
h=oS00<000000>3Oh`3Pgn<01P3Pgn<00`000000h=oS0>3Oh`0Q0>3Oh`04
0000003Pgn<0h=oS000001l0h=oS0`00000M0>3Oh`040?7_hP1VIWh0Z:Vk
0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT00D0oooo00<0Ogmo
0?ooo`3oool0=03oool01@3Rcol0YVco0;^?o`3K`ol0n_Oo07/0oooo00@0
oogk0?njM03oeJ/0oogkV03oool00`3ooO/0ol5o0?ooo`0e0?ooo`050?7_
hP3Pgn<0h=oS0>3Oh`1aKf@05`3Pgn<010000000h=oS0>3Oh`0000050>3O
h`040000003Pgn<0h=oS000000@0h=oS00<000000>3Oh`3Pgn<01P3Pgn<0
0`000000h=oS0>3Oh`0R0>3Oh`8000004`3Pgn<8000000@0h=oS00D00000
0>3Oh`3Pgn<0h=oS0000000L0>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo
00001@1VIWh0nocm0:RY^`1VIWh0LFmT00D0oooo00<0Ogmo0?ooo`3oool0
<P3oool0103mnol0]XOo0;B3o`3mnomm0?ooo`030?oWc`3o_7P0ooWc09T0
oooo00<0oogk0?o9S`3onO<0=P3oool01@3akn80h=oS0>3Oh`3Pgn<0LFmT
01P0h=oS00<000000>3Oh`3Pgn<01@3Pgn<010000000h=oS0>3Oh`000004
0>3Oh`030000003Pgn<0h=oS00H0h=oS00<000000>3Oh`3Pgn<0@`3Pgn<0
1@000000h=oS0>3Oh`3Pgn<0000001`0h=oS00@0lNoR06IVOP2XZK/0nocm
0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@01@3oool00`1oOgl0oooo
0?ooo`0`0?ooo`040?Sco`35Wol0XFCo0>;?ogd0oooo00@0oogk0?o3Q`3o
`H<0oogkVP3oool00`3o`h<0ooWc0?ooo`0f0?ooo`050?7_hP3Pgn<0h=oS
0>3Oh`1aKf@06@3Pgn<00`000000h=oS0>3Oh`040>3Oh`050000003Pgn<0
h=oS0>3Oh`0000000`3Pgn<00`000000h=oS0>3Oh`030>3Oh`L00000103P
gn<[000001<0h=oS00D000000>3Oh`3Pgn<0h=oS0000000L0>3Oh`040?7_
hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT00D0
oooo00<0Ogmo0?ooo`3oool0;P3oool0103Rcol0ZgCo0:I/o`3Obomn0?oo
o`030?oI/`3o/V@0onO?09X0oooo00<0oogk0?o1O`3o^G00>03oool01@3a
kn80h=oS0>3Oh`3Pgn<0LFmT01P0h=oS00<000000>3Oh`0000001@3Pgn<0
1@000000h=oS0>3Oh`3Pgn<0000000<0h=oS00<000000>3Oh`3Pgn<01P3P
gn<00`000000h=oS0>3Oh`0g0>3Oh`P00000103Pgn<01@000000h=oS0>3O
h`3Pgn<0000001`0h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool0000506IV
OP3ko?d0Z:Vk06IVOP1aKf@01@3oool00`1oOgl0oooo0?ooo`0/0?ooo`04
0=6co`2QI?l0`9Oo0?Scogh0oooo00@0onO?0?n`H03oeJ/0oogkVP3oool0
0`3ooO/0olV?0?oil`0i0?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@0603P
gn<3000000030>3Oh`000000h=oS0080h=oS00<000000>3Oh`3Pgn<00`00
00020>3Oh`030000003Pgn<0h=oS00H0h=oS00<000000>3Oh`3Pgn<0@`3P
gn<01@000000h=oS0>3Oh`3Pgn<0000001`0h=oS00@0lNoR06IVOP2XZK/0
nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@01@3oool00`1oOgl0
oooo0?ooo`0Z0?ooo`040=6co`2QI?l0c:_o0?gkogh0oooo00@0oogk0?o3
Q`3o`H<0oogkW03oool00`3o`h<0ooWc0?ooo`0i0?ooo`050?7_hP3Pgn<0
h=oS0>3Oh`1aKf@0703Pgn<01@000000h=oS0>3Oh`3Pgn<0000000<0h=oS
00D000000>3Oh`3Pgn<0h=oS000000080>3Oh`030000003Pgn<0h=oS01X0
h=oS0`00000V0>3Oh`050000003Pgn<0h=oS0>3Oh`000000703Pgn<0103a
kn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I005
0?ooo`0307moO`3oool0oooo02L0oooo00D0n??o0<FOo`2QI?l0c:_o0?gk
o`1o0?ooo`030?oI/`3o/V@0onO?09d0oooo00<0oogk0?o1O`3oool0>P3o
ool01@3akn80h=oS0>3Oh`3Pgn<0LFmT01d0h=oS00D000000>3Oh`3Pgn<0
h=oS000000030>3Oh`030000003Pgn<0000002L0h=oS00<000000>3Oh`3P
gn<09@3Pgn<01@000000h=oS0>3Oh`3Pgn<0000001`0h=oS00@0lNoR06IV
OP2XZK/0nocm0@3oool0000506IVOP3ko?d0Z:Vk06IVOP1aKf@01@3oool0
0`1oOgl0oooo0?ooo`0U0?ooo`040>;?o`2[M?l0YVco0=o;ogl0oooo00D0
onoO0?o5R`3o]6P0omF[0?omn`2M0?ooo`030?omn`3obHl0ooWc03/0oooo
00D0lNoR0>3Oh`3Pgn<0h=oS075_I00M0>3Oh`030000003Pgn<0h=oS0080
h=oS00D000000>3Oh`3Pgn<0h=oS0000000X0>3Oh`030000003Pgn<0h=oS
02H0h=oS0`00000M0>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1V
IWh0nocm0:RY^`1VIWh0LFmT00D0oooo00<0Ogmo0?ooo`3oool08@3oool0
1P3jmol0f;oo0;J7o`2VK?l0`9Oo0?Scogl0oooo00@0oogk0?nlN03o`hL0
onoOW`3oool00`3ooO/0olV?0?oil`0l0?ooo`050?7_hP3Pgn<0h=oS0>3O
h`1aKf@0C`3Pgn<00`000000h=oS0>3Oh`160>3Oh`040?7_hP1VIWh0Z:Vk
0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT00D0oooo00<0Ogmo
0?ooo`3oool07P3oool01P3hlol0aIoo0:Q`o`2fQol0f;oo0?[goh40oooo
00<0oogk0?o7S`3onO<0X03oool00`3ooO/0olV?0?oil`0m0?ooo`050?7_
hP3Pgn<0h=oS0>3Oh`1aKf@0C`3Pgn<00`000000h=oS0>3Oh`160>3Oh`04
0?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT
00D0oooo00<0Ogmo0?ooo`3oool0703oool0103Rcol0ZgCo0:I/o`3Obon3
0?ooo`040?o_g`3oaH/0okmo0?oilj00oooo00<0oogk0?o9S`3onO<0?P3o
ool01@3akn80h=oS0>3Oh`3Pgn<0LFmT04l0h=oS00<000000>3Oh`3Pgn<0
AP3Pgn<0103akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0
IVIn075_I0050?ooo`0307moO`3oool0oooo01X0oooo00@0c:_o09iPo`30
Uol0n??oP`3oool0103ofK<0okAX0?o3Q`3okmnQ0?ooo`030?omn`3obHl0
ooWc03l0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I01>0>3Oh`800000B03P
gn<0103akn80IVIn0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn
075_I0050?ooo`0309nOW`3oool0oooo01P0oooo00<0dkOo0:I/o`3F^ol0
Q03oool0103ofK<0ok9T0?oEZ`3ooO^R0?ooo`030?oJ/`3o_g`0ooWc0400
oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I02H0>3Oh`040?7_hP1VIWh0Z:Vk
0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0LFmT01d0oooo00@0k=oo
0;R;o`2XL?l0fl?oQ03oool0103oill0ok1P0?oEZ`3ooO^R0?ooo`040?om
n`3o^g@0omJ[0?omnd40oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_I02H0>3O
h`040?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY^`1VIWh0
LFmT01X0oooo00D0k=oo0;R;o`2VK?l0]XOo0>cOo`240?ooo`040?omn`3o
`hL0ol630?omnj<0oooo00<0oogk0?o9S`3onO<0@`3oool01@3akn80h=oS
0>3Oh`3Pgn<0LFmT09P0h=oS00@0lNoR06IVOP2XZK/0nocm0@3oool00005
06IVOP3ko?d0Z:Vk06IVOP1aKf@05`3oool01@3/gol0^8_o0:I/o`2fQol0
k=oo08D0oooo00@0onoO0?o5R`3o]6P0onO?Y03oool00`3ooO/0olV?0?oi
l`140?ooo`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@0V03Pgn<0103akn80IVIn
0:RY^`3ko?d10?ooo`0000D0IVIn0?_lo@2XZK/0IVIn075_I00D0?ooo`05
0>cOo`2hRol0YVco0;J7o`3/gol0QP3oool0103ogkl0okI/0?o3Q`3okmnU
0?ooo`030?oJ/`3o_g`0ooWc04D0oooo00D0lNoR0>3Oh`3Pgn<0h=oS075_
I02H0>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40oooo00001@1VIWh0nocm0:RY
^`1VIWh0LFmT0140oooo00D0k=oo0;R;o`2VK?l0]XOo0>cOo`270?ooo`03
0?oO_`3o_gl0omno0:H0oooo00@0ooWc0?nhK03oeZ/0oogkAP3oool01@3a
kn80h=oS0>3Oh`3Pgn<0LFmT09P0h=oS00@0lNoR06IVOP2XZK/0nocm0@3o
ool0000406IVOP3ko?d0Z:Vk06IVO_l0LFmTT`1aKf@30>3OhiT0LFmT00@0
lNoR06IVOP2XZK/0nocm0@3oool0000406IVOP3ko?d0Z:Vk06IVO_l0h=oS
o`3Pgn<a0>3Oh`0306IVOP2XZK/0nocm0040oooo0000101VIWh0nocm0:RY
^`1VIWh:0>3Oh`030<_EeP2L[KT0PYJV0100PYJV00<0U:Jc0<7>d@3Pgn<0
o`3Pgn?o0>3Oha40h=oS00<0IVIn0:RY^`3ko?d00@3oool0000406IVOP3k
o?d0Z:Vk06IVOP<0h=oS00<0/k2S08f8NP3oool00`3Pgn<00`2jbLh0[;W4
0=oUj@0A0?ooo`030>[]l02/^L@0^/W>04P0h=oS00<0_ko50>3Oh`3Pgn<0
o`3Pgn?50>3Oh`0306IVOP2XZK/0nocm0040oooo0000101VIWh0nocm0:RY
^`1VIWh30>3Oh`030=K?aP2c/:/0kn_W00<0h=oS00<0SZ2^0?3cm@3oool0
4P3oool00`3`loD0SZ2^0>3Oh`170>3Oh`030;noa@3Pgn<0h=oS00D0h=oS
502U[;;o0>3Ohj`0h=oS00<0IVIn0:RY^`3ko?d00@3oool0000406IVOP3k
o?d0Z:Vk06IVOPT0h=oS00<0PYJV0?ooo`3oool04`3oool00`22UZH0h=oS
0>3Oh`160>3Oh`030;noa@3Pgn<0h=oS00D0h=oS00<0YJbb003og@00omd0
4000omd00`2U[;80h=oS0>3Oh`3o0>3OhjX0h=oS00<0IVIn0:RY^`3ko?d0
0@3oool0000406IVOP3ko?d0Z:Vk06IVOP<0h=oS00<0inOW0?ooo`3onol0
0`3Pgn<00`22UZH0oooo0?ooo`04000000<0oooo0`0000030?ooo`<00000
0`3oool00`22UZH0h=oS0>3Oh`020>3Oh`040000003Pgn<0h=oS0>3Oh`80
00001P3Pgn<00`000000h=oS0>3Oh`0D0>3Oh`030000003Pgn<0h=oS01h0
h=oS00<0_ko50>3Oh`3Pgn<01@3Pgn<00`2U[;800?oM003og@0@003og@03
0:F//P3Pgn<0h=oS00@0h=oS00@000000>3Oh`3Pgn<0h=oS0P0000060>3O
h`030000003Pgn<0h=oS0?l0h=oSU`3Pgn<00`1VIWh0Z:Vk0?_lo@010?oo
o`0000@0IVIn0?_lo@2XZK/0IVIn0`3Pgn<00`2c/:<0SHQj0?ooo`030>3O
h`0408:FYP3oool0oooo000000h0oooo00D000000?ooo`3oool0oooo08:F
YP040>3Oh`8000000`3Pgn<2000000@0h=oS0`00000D0>3Oh`<000007`3P
gn<00`2o_lD0h=oS0>3Oh`050>3Oh`030:F//P00omd00?oM01000?oM00<0
YJbb0>3Oh`3Pgn<0103Pgn<2000000<0h=oS0P0000040>3Oh`<00000o`3P
gn>H0>3Oh`0306IVOP2XZK/0nocm0040oooo0000101VIWh0nocm0:RY^`1V
IWh30>3Oh`030=K?aP2c/:/0kn_W00<0h=oS00@0PYJV0?ooo`3oool00000
3P3oool01@000000oooo0?ooo`3oool0PYJV00@0h=oS0`0000030>3Oh`80
00000P3Pgn<500000180h=oS1@00000>0>3Oh`030000003Pgn<0h=oS00d0
h=oS00<0_ko50>3Oh`3Pgn<01@3Pgn<00`2U[;800?oM003og@0@003og@03
0:F//P3Pgn<0h=oS00@0h=oS0`0000030>3Oh`8000000P3Pgn<500000?l0
h=oSU`3Pgn<00`1VIWh0Z:Vk0?_lo@010?ooo`0000@0IVIn0?_lo@2XZK/0
IVIn2@3Pgn<01022UZH0oooo0?ooo`00000>0?ooo`050000003oool0oooo
0?ooo`22UZH0103Pgn<4000000<0h=oS0P00000Z0>3Oh`<000003P3Pgn<0
0`2o_lD0h=oS0>3Oh`050>3Oh`030:F//P00omd00?oM01000?oM00<0YJbb
0>3Oh`3Pgn<0103Pgn<4000000<0h=oS0P00003o0>3Ohid0h=oS00<0IVIn
0:RY^`3ko?d00@3oool0000406IVOP3ko?d0Z:Vk06IVOP<0h=oS00<0inOW
0?ooo`3onol00`3Pgn<00`22UZH0oooo0?ooo`0C0?ooo`0308:FYP3Pgn<0
h=oS0080h=oS1@0000030>3Oh`8000005P3Pgn<200000100h=oS1@00000=
0>3Oh`030;noa@3Pgn<0h=oS00D0h=oS00<0YJbb003og@00omd04000omd0
0`2U[;80h=oS0>3Oh`040>3Oh`D000000`3Pgn<200000?l0h=oSW03Pgn<0
0`1VIWh0Z:Vk0?_lo@010?ooo`0000@0IVIn0?_lo@2XZK/0IVIn0`3Pgn<0
0`2c/:<0SHQj0?ooo`030>3Oh`0308:FYP3oool0oooo01<0oooo00<0PYJV
0>3Oh`3Pgn<00P3Pgn<200000080h=oS00<000000>3Oh`3Pgn<00P3Pgn<2
000001@0h=oS0`00000B0>3Oh`030000003Pgn<0h=oS00d0h=oS00<0_ko5
0>3Oh`3Pgn<01@3Pgn<00`2U[;800?oM003og@0@003og@030:F//P3Pgn<0
h=oS00@0h=oS0P0000020>3Oh`030000003Pgn<0h=oS0080h=oS0P00003o
0>3Ohi/0h=oS00<0IVIn0:RY^`3ko?d00@3oool0000406IVOP3ko?d0Z:Vk
06IVOP<0h=oS00<0e/o60;>`Z`3_jnL00`3Pgn<00`22UZH0oooo0?ooo`0C
0?ooo`0308:FYP3Pgn<0h=oS0080h=oS00<000000>3Oh`3Pgn<00P3Pgn<0
0`000000h=oS0>3Oh`020>3Oh`8000003@3Pgn<4000000040>3Oh`000000
0000000000l0h=oS00D000000>3Oh`3Pgn<0h=oS000000030>3Oh`030000
003Pgn<0h=oS00T0h=oS00<0_ko50>3Oh`3Pgn<01@3Pgn<00`2U[;800?oM
003og@0@003og@030:F//P3Pgn<0h=oS00@0h=oS00<000000>3Oh`3Pgn<0
0P3Pgn<00`000000h=oS0>3Oh`020>3Oh`800000o`3Pgn>J0>3Oh`0306IV
OP2XZK/0nocm0040oooo0000101VIWh0nocm0:RY^`1VIWh90>3Oh`0408:F
YP3oool0oooo000000h0oooo00D000000?ooo`3oool0oooo08:FYP050>3O
h`050000003Pgn<0h=oS0>3Oh`0000001@3Pgn<00`000000h=oS0>3Oh`09
0>3Oh`800000103Pgn<3000000l0h=oS0P0000030>3Oh`040000003Pgn<0
h=oS0>3Oh`8000002P3Pgn<00`2o_lD0h=oS0>3Oh`050>3Oh`030:F//P00
omd00?oM01000?oM00<0YJbb0>3Oh`3Pgn<01@3Pgn<01@000000h=oS0>3O
h`3Pgn<0000000D0h=oS00<000000>3Oh`3Pgn<0o`3Pgn>H0>3Oh`0306IV
OP2XZK/0nocm0040oooo0000101VIWh0nocm0:RY^`1VIWh30>3Oh`030>OW
i`3oool0oo_o00<0h=oS00@0PYJV0?ooo`3oool000003P3oool01@000000
oooo0?ooo`3oool0PYJV00D0h=oS00<000000>3Oh`3Pgn<00P3Pgn<00`00
0000h=oS0>3Oh`0>0>3Oh`030000003Pgn<0h=oS00@0h=oS00<000000>3O
h`3Pgn<03@3Pgn<=000000T0h=oS00<0_ko50>3Oh`3Pgn<01@3Pgn<00`2U
[;800?oM003og@0@003og@030:F//P3Pgn<0h=oS00D0h=oS00<000000>3O
h`3Pgn<00P3Pgn<00`000000h=oS0>3Oh`3o0>3Ohid0h=oS00<0IVIn0:RY
^`3ko?d00@3oool0000406IVOP3ko?d0Z:Vk06IVOP<0h=oS00<0/k2S08f8
NP3oool00`3Pgn<01022UZH0oooo0?ooo`00000>0?ooo`050000003oool0
oooo0?ooo`22UZH01P3Pgn<01@000000h=oS0>3Oh`3Pgn<0000000l0h=oS
00<000000>3Oh`3Pgn<01P3Pgn<00`000000h=oS0>3Oh`0=0>3Oh`800000
0`3Pgn<010000000h=oS0>3Oh`3Pgn<2000000X0h=oS00<0_ko50>3Oh`3P
gn<01@3Pgn<00`2U[;800?oM003og@0@003og@030:F//P3Pgn<0h=oS00H0
h=oS00D000000>3Oh`3Pgn<0h=oS0000003o0>3Ohil0h=oS00<0IVIn0:RY
^`3ko?d00@3oool0000406IVOP3ko?d0Z:Vk06IVOP<0h=oS00<0e/o60;>`
Z`3_jnL00`3Pgn<00`22UZH0oooo0?ooo`0C0?ooo`0308:FYP3Pgn<0h=oS
00@0h=oS00<000000>3Oh`3Pgn<00P3Pgn<00`000000h=oS0>3Oh`0<0>3O
h`030000003Pgn<0h=oS00H0h=oS00<000000>3Oh`3Pgn<03P3Pgn<01@00
0000h=oS0>3Oh`3Pgn<0000000<0h=oS00<000000>3Oh`3Pgn<02@3Pgn<0
0`2o_lD0h=oS0>3Oh`050>3Oh`030:F//P00omd00?oM01000?oM00<0YJbb
0>3Oh`3Pgn<01P3Pgn<00`000000h=oS0>3Oh`020>3Oh`030000003Pgn<0
h=oS0?l0h=oSW03Pgn<00`1VIWh0Z:Vk0?_lo@010?ooo`0000@0IVIn0?_l
o@2XZK/0IVIn2@3Pgn<00`22UZH0oooo0?ooo`0C0?ooo`0308:FYP3Pgn<0
h=oS00D0h=oS00<000000>3Oh`3Pgn<00P00000>0>3Oh`030000003Pgn<0
h=oS00H0h=oS00<000000>3Oh`3Pgn<04P3Pgn<00`000000h=oS0>3Oh`0=
0>3Oh`030;noa@3Pgn<0h=oS00D0h=oS00<0YJbb003og@00omd04000omd0
0`2U[;80h=oS0>3Oh`070>3Oh`030000003Pgn<0h=oS00800000o`3Pgn>N
0>3Oh`0306IVOP2XZK/0nocm0040oooo0000101VIWh0nocm0:RY^`1VIWh3
0>3Oh`030>OWi`3oool0oo_o00<0h=oS00@0PYJV0?ooo`3oool000003P3o
ool01@000000oooo0?ooo`3oool0PYJV00L0h=oS00<000000>3Oh`000000
0P3Pgn<00`000000h=oS0>3Oh`0;0>3Oh`030000003Pgn<0h=oS00H0h=oS
00<000000>3Oh`3Pgn<0403Pgn<5000000d0h=oS00<0_ko50>3Oh`3Pgn<0
1@3Pgn<00`2U[;800?oM003og@0@003og@030:F//P3Pgn<0h=oS00L0h=oS
00<000000>3Oh`0000000P3Pgn<00`000000h=oS0>3Oh`3o0>3Ohi/0h=oS
00<0IVIn0:RY^`3ko?d00@3oool0000406IVOP3ko?d0Z:Vk06IVOP<0h=oS
00<0/k2S08f8NP3oool00`3Pgn<01022UZH0oooo0?ooo`00000>0?ooo`05
0000003oool0oooo0?ooo`22UZH0203Pgn<01@000000h=oS0>3Oh`3Pgn<0
000000h0h=oS00<000000>3Oh`3Pgn<0103Pgn<00`000000h=oS0>3Oh`0B
0>3Oh`<000003P3Pgn<00`2o_lD0h=oS0>3Oh`050>3Oh`030:F//P00omd0
0?oM01000?oM00<0YJbb0>3Oh`3Pgn<0203Pgn<01@000000h=oS0>3Oh`3P
gn<000000?l0h=oSW@3Pgn<00`1VIWh0Z:Vk0?_lo@010?ooo`0000@0IVIn
0?_lo@2XZK/0IVIn0`3Pgn<00`3FclH0/k2[0>o[i`030>3Oh`0408:FYP3o
ool0oooo000000h0oooo00D000000?ooo`3oool0oooo08:FYP080>3Oh`05
0000003Pgn<0h=oS0>3Oh`0000003P3Pgn<2000000@0h=oS0P00000E0>3O
h`030000003Pgn<0h=oS00d0h=oS00<0_ko50>3Oh`3Pgn<01@3Pgn<00`2U
[;800?oM003og@0@003og@030:F//P3Pgn<0h=oS00P0h=oS00D000000>3O
h`3Pgn<0h=oS0000003o0>3Ohid0h=oS00<0IVIn0:RY^`3ko?d00@3oool0
000406IVOP3ko?d0Z:Vk06IVOPT0h=oS00<0PYJV0?ooo`3oool010000003
0?ooo`<000000`3oool3000000<0oooo00<0PYJV0>3Oh`3Pgn<01`3Pgn<3
00000140h=oS1000000W0>3Oh`030;noa@3Pgn<0h=oS00D0h=oS00<0YJbb
003og@00omd04000omd00`2U[;80h=oS0>3Oh`090>3Oh`<00000o`3Pgn>N
0>3Oh`0306IVOP2XZK/0nocm0040oooo0000101VIWh0nocm0:RY^`1VIWh9
0>3Oh`0309BV/`3ZkO00oooo0180oooo00<0j^g`09BV/`3Pgn<0A`3Pgn<0
0`2o_lD0h=oS0>3Oh`050>3Oh`030:F//P00omd00?oM01000?oM00<0YJbb
0>3Oh`3Pgn<0o`3Pgn>Z0>3Oh`0306IVOP2XZK/0nocm0040oooo0000101V
IWh0nocm0:RY^`1VIWh90>3Oh`030<7>d@2/^L@0gnGY0140oooo00<0j^g`
0:bia031c]40D03Pgn<D0:F//_l0h=oS[03Pgn<00`1VIWh0Z:Vk0?_lo@01
0?ooo`0000@0IVIn0?_lo@2XZK/0IVIn2P3Pgn<00`3;eMH0W:fi08:FYP0@
08:FYP0309BV/`31c]40h=oS0?l0h=oSo`3Pgn<A0>3Oh`0306IVOP2XZK/0
nocm0040oooo0000101VIWh0nocm0:RY^`1VIWko0>3Ohol0h=oS<@3Pgn<0
0`1VIWh0Z:Vk0?_lo@010?ooo`0000<0IVIn0?Ogn@2HV:L0o`1gMi;o07Mg
TS<0MgNB0@2HV:L10?Ogn@40oooo00000`1VIWh0moOi0;bmc@3o0;bmcOl0
_;g==02l_Ld10?Ogn@40oooo00000`1VIWh0moOi0>CSh`3o0>CShol0i>?S
=03Thn<10?Ogn@40oooo00000`1VIWh0l?7d0?ooo`3o0?ooon`0oooo00<0
i>?S09bT^@1[MHl00`1[MHl0101/MY00JgF?06afT01/MY0906]eS`0609bT
^@3Thn<0oooo0?ooo`3Thn<0W:Bi101[MHl0101/MY00JgF?06afT01/MY09
06]eS`0609bT^@3Thn<0oooo0?ooo`3/j^X0W:Bi102V>D@0102W>T@0YSU4
0:LjA02W>T@90:HiA00309bT^@3/j^X0oooo00<0oooo0@3`lO@10?ooo`00
01H0IVIn0>;QhP3ko?`0no_l0?_lo@3lnod0no_m0?_lo@3ko?`0o?cm0?cl
o03lnod0o?cl0?cko03lo?`0nocl0?clo03ko?d0o?_l0?clo@3knod0nocl
0P3lo?`0103lo?d0o?cl0?_ko@3lo?d;0?cko080al;AV`3lnobX0?_lo880
nocm00<0W:Bi06]eS`25RK004025RK001P1[MHl0W:Bi0?_lo@3ko?d0W:Bi
06]eSa40QHV`00H0JgF?09bT^@3ko?`0no_l09bT^@2V>D@A0:XlE@070:Hi
A02LY;T0nocl0?clo03lnod0nocm0>;QhP010?ooo`0000@0IVIn0>3Ph@3f
moT0moOi0P3fmoT02`3fmoP0moOi0?Ogn03fmoP0m_Oi0?Ogn03gmoT0moKh
0?Kgn@3gmoT0m_Oi0080moOi00@0moKh0?Kgn03fmoT0moOi0`3fmoT00`3f
moP0moOi0?Ogn@090?Ogn@803Q0@00<0al;A0?Ogn@3gmoT0V@3gmoVX0?Kg
nH80moOi00<0JgF?08F9/02LW[h0402LW[h01P25RK00JgF?0?Ogn@3gmoT0
JgF?08F9/140W9jn00P0QHV`06]eS`3fmoP0moOh0:HiA02Z?5D0`U9K0<ID
FPd0aUEL00T0aUAJ0<9BF`2Z?5D0YSU40?Ogn03gmoT0moOh0?Ogn@3Ph>40
0@3oool0000606IVOP3NgN40lO7d0?7am03`lO@0l?;d3`1JDU801`3al_@0
lO7d0?3bm@3alO@0lO;d0?3bm03alO@02P3`lOD200h@40030<O2d@3`lOD0
l?7e0?l0l?7e@P3`lOF20?3am00306]eS`2b]M00YjS20100YjS200H0/[G@
06]eS`3`lO@0l?7d06]eS`2b]M0A0:NX`P050;:ed01[MHl0l?7e0?7bm02V
>D@00P32DU/00`3;E5T0cEUN0<eIGP0;0<eIGP040<]DF@32DU/0`U9K0:Hi
A080l?7d00<0lO7d0?3bm03NgN400@3oool0000706IVOP3Lfn00j^_`0>[[
l03Zk?00jN__05YBDP020>OWi`80g]kN0P3WinL00`3W_H@0inOW0>OWi`03
0>OWi`80kno_00@0j^c_0>[[l03Zjo00j^__0P3Zjo000`3Zjnl0al;A0<O2
d@030<O2d@80j^_`00<0inO]0=SEh037`]400P0>41001`37`]40j^_`0>[[
l03ShnX0dLkJ0<O2d@3Lf^<00P37`]420>[[l0080=gLi@37`]40gmkV0=gL
i@37`]40i>C[0>[[l03ShnX20<O2d@80j^_`0P37`]420>[[l0040=gLi@37
`]40al;A0=oNiP<0j^_`0P37`]420>[[l080al;A103Zjo020<O2d@@0j^_`
0P37`]440>[[l0060>3Pj03Ac]X0al;A0=GBg@3Wind0j^_`0P37`]420>[[
l0030>CTj`37`]40g=[S0080al;A0P3Zjo002@3Ti>/0al;A0=cJh`3Zjo00
h>3X0=7>fP37`]40eM;M0>OWk@020>[[l080al;AAP3Zjo2X0>[/l880j^__
00@0JgF?0;Jid@2][/H0[Jk6203oool00`2][/H0[:k60:f^aP030:f^aP03
0:b^aP2f^M40JgF?0080j^__00@0JgF?0;Jid@2][/H0[Jk6303oool20:f^
aP030:b^aP2f^M40JgF?0080j^_`00D0YSU40<eIGP3;E5T0cEIK0<iIG`0;
0=1JG`070<iIG`3=EU/0beAI0<eIGP2V>D@0j^__0>[[l0020>[[k`40g=_P
0@3oool0000406IVOP3IfMl0hnGZ0>?TjP80hnG[00D0FU9B08b<S03Ng]h0
inOW0=kNgP020>OWi`030<IS003WinL0inOW0080inOW00L0knoW0>o_k`3_
knl0hnGZ0>?TjP3Si>/0hnGZ0080hnCZ1@0>41020>?Uj`040=3Bf01]KG80
3Q0@069SI`803Q0@00H0al;A0>?Uj`2l_/80BDY=00h@402=Si<200h@400:
0<O2d@3SiN/0Ti>I00h@402QXjL0UIJK00h@402[Yk@0h>;X0;bn`P803Q0@
0P3SiN/200h@40030<O2d@3SiN/0TiBJ00803Q0@00@0WYnU0<O2d@3Jf^<0
hnG[0P0>41001@37`]40hnG[00h@400>4100al;A00<0hnG[0P0>41001037
`]40hnG[0>?Uj`3SiN/200h@400:0<O2d@3SiN/0hnG[0>?Uj`2VYZd0ATI:
00h@401RHfL0_[_60=[Jh`803Q0@00D0al;A0>?Uj`33aLX03Q0@08>2R@02
00h@400=0<O2d@3SiN/0`lG:00h@4023PXT0hN?Y0:JV[@16ATX03Q0@069S
I`2n^lH0f][S0>?Uj`0200h@40030<O2d@3SiN/0hnG[04@0hnG[Z03Si>Z2
0>?UjP0506]eS`2l_]@0/[;:0;:bbP3oool01P1^KHl00`0U9CH0/[;:0;:b
bP050;:bbP060;bne01[MHl0hnGZ0>?UjP1[MHl0_;kD0P2b//X00`3oool0
9BDf02DU=P0902DU=P<0/[;:00D0_;kD06]eS`3Si>/0hnC[0:HiA0020<eI
GP040=1KH03DG5l0oooo0?ooo`L0e5aO0P3oool02P3DG5l0d5]P0<eIGP3=
FEh0YSU40>?TjP3SiNX0hnCZ0>?Uj`3IfMl10?ooo`0000<0IVIn0=OHgP3L
g^H00`3Lg^H01@1JDU80inOW0>OWi`3WinL0imK>0080inOW00D0cW/00>nD
403WinL0imk60>n<40030>o_k`060=cMiP3Lg^H0g=kU0=cNi@3Lg^H0g=kU
0P0>41000`37`]40g=kU0=cNi@020=cNi@04065SIP0>4100WY^V0=cNi@80
3Q0@00H0al;A0=cNi@1RI6L03Q0@0;Nb`02m_lD200h@40050<O2d@2EUi/0
3Q0@0;Nb`02^/;H00P0>41001@2g//00g=kU04a>D00>4100al;A0080g=kU
0P0>41002@37`]40WZ2U00h@402UXJd0[[2f00h@402?S9L0cL[G0=cNi@02
00h@40050<O2d@3Lg^D03Q0@00h@4037`]400`3Lg^D200h@40040<O2d@3L
g^D0g=kU0=cNi@803Q0@00X0al;A0=cNi@3Lg^D0YZR^00h@402GU9l0[[2f
04a>D02NX:D0g=kU0P0>41001@37`]40f]_S04U;CP16ATX0bl_D00803Q0@
00/0al;A0=[Kh`19Bdh0ATI:0<_;e02VZ:h03Q0@09NDW`2^/;H0C4i@09jP
Y@020=cNi@803Q0@00<0al;A0=cNi@3Lg^D0o`3Lg^E_0=cNi@0506]eS`2o
`MH0^;W>0;RicP3oool01P1^KHl00`0U9CH0^;W>0;RicP050;RicP060;o1
eP1[MHl0g=kU0=cNi@1[MHl0_l7F0P2h^Lh00`3oool09BDf0;RicP070;Ri
cP030?ooo`0U9CH0^;W>0080^;W>00T0_l7F06]eS`3Lg^H0g=kU0:HiA03=
FEh0dEYN0=AMH@1C9B000`3oool50=IOH`<0oooo00D0DbDP0=AMH@3AFUh0
cEUN0:HiA0020=cNi@030=cNiP3Lg^D0emSN0040oooo0000101VIWh0eMKM
0=GHh03Ff>420=GHh00905YBDP2<S8`0inOW0>OWi`3W]H@0eUX00=J4003o
cP00cV<00080gV/000D0kkF<0>o_k`3_knl0kno_0=GHh0020=GHh@030=GG
h03Ff>00e]SQ00803Q0@00D0al;A0=KGh03Fen00e]OP0<C6cP0200h@4006
0<O2d@3Fen003Q0@00h@4037`]40e]OP0P0>41001@37`]40e]OP00h@400>
4100al;A00803Q0@00H0al;A0=?Cg@0>41003Q0@0<O2d@3Fen0200h@4003
0<O2d@3Fen00e]OP00803Q0@00T0al;A04Y<C`0>4100al;A0=KGh00>4100
ATI:0<O2d@3Fen000P0>41001@37`]40e]OP00h@400>4100al;A00<0e]OP
0P0>41001037`]40e]OP0=KGh03Fen0200h@40050<O2d@3Fen00e]OP04Y<
C`0>41001@37`]4200h@40050;Nb`020OhL03Q0@0:BS[@3Fen000P0>4100
1`2g//00P7n700h@402TXjd0e]OP04Y<C`0>41001@37`]40103Fen003Q0@
00h@4037`]560=KGh:P0e]SPPP3Ef>401@1[MHl0`lGI0;bmd@2l_M40oooo
00L09BDf1`2l_M401P33aMT0JgF?0=GHh@3Ef>40JgF?0<?5f@80_;gA00<0
oooo02DU=P2l_M401`2l_M400`3oool09BDf0;bmd@020;bmd@050<?5f@1[
MHl0e]OP0=GGh@2V>D@00P3EGF000`3HH640fF5R04HN6P030?ooo`<0fF5R
0`3oool00`167QX0fF5R0=QPH@020=EMH0060:HiA03Ff>00eMSQ0=GGh03E
f>40eMKM0@3oool0000706IVOP3Be=d0cm;L0=3Bg03@d]d0d=;L05YBDP03
0>OWi`0;0>ONcP36BP00mlh00>n]003_]@00cV/00<IJ0036J`00gXa:0>NU
003_ilh0103@d]`01@3?d]`0d=;L00h@400>4100al;A00<0d=;L00D0^K_4
00h@400>4100al;A0=3Bg00200h@40060<O2d@3@d]`03Q0@00h@4037`]40
d=;L0P0>41001@37`]40NG^000h@402YZK<0bLKD00803Q0@00D0al;A0=3B
g00>41003Q0@0<O2d@020=3Bg0803Q0@00D0al;A00h@400>4100al;A0=3B
g00200h@40060<W6e03@d]`03Q0@00h@4037`]40d=;L0P0>41001037`]40
d=;L0=3Bg03@d]`200h@40040<O2d@3@d]`0d=;L0=3Bg0803Q0@00<0al;A
0=3Bg03@d]`01P0>41002039a]@03Q0@00h@4016ATX03Q0@07AbNP3=cMT0
d=;L0P0>41001@16ATX03Q0@07AbNP3=cMT0d=;L00H03Q0@00D0bLKD0=3B
g00>41003Q0@0<O2d@160=3Bg:P0cm;MPP3@d]`00`1[MHl0b<WK0<?4eP0@
0<?4eP060<S9f`1[MHl0d=;L0=3Bg01[MHl0b<WK0P33a=H00`3oool09BDf
0<?4eP070<?4eP030?ooo`0U9CH0`lCF0080`lCF00L0b<WK06]eS`3?d]`0
cm;L0:HiA03GGel0fF5R00<0g6EU00D0AQhJ0?ooo`3oool0oooo0=aUI@03
0?ooo`0804HN6P3LIFD0g6EU0=aUI@3IHF80eemO0:HiA03@d]d20=3Bg040
cm;L0@3Be=d10?ooo`0001/0IVIn0=3Bf`3;cMP0b/gI0<_>f03:cMP0FU9B
0>O6[@3WaX`0mlhH0>nm003gaP00kjd00>N]003WY@00eX`00<i[003WaP00
omH00>o_i`3_knl0b/kI0<_=f03;cMT0b/gI0<_>f03:cMP00P0>41030<O2
d@060<_=f@2j_<L03Q0@00h@4037`]40bL[F0P0>41001P37`]40blgI00h@
400>4100al;A0<_=f@803Q0@00@0al;A0<_=f@2:S9<0AdU=0`0>41001@38
am@0blgI00h@400>4100al;A0080blgI0P0>41002@37`]40AdU=00h@4037
`]40b/[G00h@4016ATX0bLWF0<_=f@0200h@40050<O2d@3:c=P03Q0@00h@
4039b=D00`3;cMT200h@40040<O2d@3;cMT0blgI0<_=f@803Q0@00X0al;A
0<[:e`3:bmL0AdU=00h@4037`]40b/[G00h@4016ATX0bLWF0P0>41001@1X
IVh03Q0@09RIX`37`]40b/[G00803Q0@00d0J6I^00h@402HVJ<0al;A0<[:
e`17BDd03Q0@0<O2d@3:b]L03Q0@04I6BP39bMH0blgI00803Q0@00<0al;A
0<[:e`3:bmL0A03;cMVX0<_>fH80blgH00<0JgF?0<_<gP38b]T02038b]T0
0`38bMT0b<[I0<S:f@030<S:f@040<S9f@38b]T0blcN06]eS`80blgH00H0
JgF?0<_<gP38b]T0b<[I0?ooo`0U9CH50<S:f@0A0<S9f@38b]T0b<[I0?oo
o`0U9CH0b<[I0<S9f@38b]T0blcN06]eS`3;c]P0b/gH0:HiA03GGel0ffAT
0>1WI@3PIVD00P3NIfL00`167QX0oooo0?ooo`030?ooo`0:04HN6P3NIfL0
gVMW0>1VI@3PIfD0ffAT0=MOG`2V>D@0b/kH0<[>f@80blgI0@3@d]/10?oo
o`0000<0IVIn0<o?fP35b=@00`35b=@01P1JDU80a/K60>ONeP3>N`00ijd0
0>ne0080ijD000<0eY@00<ic003FU0000P3gaP020?Ogm`040<G7e035b=@0
aLOD0<G7e080aLOE100>41030<C7e@0406IYL00>4100UYJP0<O2d@803Q0@
00H0al;A0<C7e@0>41003Q0@0<O2d@34amD200h@40090<O2d@34amD0a<OE
0<K4dP2g//003Q0@06MWK`35a]@0a<OE00803Q0@0P37`]402P34amD03Q0@
00h@4037`]40SI2J00h@402TXjl0ZjNd00h@402?SYP20<C7e@803Q0@00D0
][G20;2^^`0>4100Lg=k0<G6e0030<C7e@803Q0@00@0al;A0<C7e@34amD0
a<OE0P0>41002P2UXJd0ZZZf0<K4dP25R9403Q0@09fMZ02[Yk@03Q0@08J6
T034amD200h@40050<O2d@25R9403Q0@0:BS[`37`]400P0>41002`37`]40
QHRA00h@402TXjl0al;A08J7T00>4100WIfX0:^W]00>4100QXJ@0080a<OE
0P0>41000`2UXJd0ZZZf0<K4dP140<C7eJP0a<SDPP34am@00`1[MHl0d=7P
0<_;g00@0<_;g0060=3Ah01[MHl0a<OD0<C7e01[MHl0d=7P0P3;bm`00`3o
ool09BDf0<_;g0070<_;g0030?ooo`0U9CH0bl_L0080bl_L00L0d=7P06]e
S`35am@0a<OD0:HiA03KI6@0gfET00D0h6YX00D0AQhJ0?ooo`3oool0oooo
04HN6P050>1ZJ0040=mUI03KI6@0YSU40<C8e@80a<SD0@35amD10<o?fP40
oooo0000101VIWh0c<kJ0<;4dP31a=420<74dP0605YBDP3WinL0inOW0>OW
i`3FQ000kkD00P3WY@00203FQ000cV/00>N]003g]@00mkd00>o_k`3gmoL0
`/CB0`31a=801@32a=40`LCB00h@400>4100al;A00@0`LCA00H0/KC007Ym
Q@0>41003Q0@071cNP0>41020<74d@803Q0@0P31a=4200h@4080`LCA00H0
EeUO00h@400>4100L7=j0;6d`031a=4400h@40040<74d@0>41003Q0@00h@
4080`LCA00@0PhJ>00h@400>4100PhJ>0`31a=401P0>4100NWf504A6BP0>
4100L7=j0;6d`0@0`LCA0P0>41001037`]40`LCA0<74d@31a=4200h@4005
08>6SP1GFEl0`LCA0<74d@23QXh00P0>41000`23QXh0`LCA0<74d@0200h@
40050<O2d@31a=40PhJ>00h@402PXjd00P0>41001`37`]40`LCA08>6SP0>
4100X:>]0<74d@23QXh00P0>41001023QXh0`LCA0<74d@31a=4200h@4003
08>6SP1GFEl0`LCA04@0`LCAZ031a=:20<;4dP0306]eS`3Cdn80cm3M0100
cm3M00H0dm?R06]eS`32a=80`/CB06]eS`3Cdn820<o@g@030?ooo`0U9CH0
cm3M00L0cm3M00<0oooo02DU=P3?d=d00P3?d=d01`3Cdn80JgF?0<;4dP31
a=40YSU40=]TI03QJFD01@3PK6T50?ooo`D0h6aY00P0hFUU0=]TI02V>D@0
`LCB0<;4d@31a=40`LCB0<c>fP40oooo0000101VIWh0b/cH0;k0c`2m`<l2
0;k0cP0505YBDP2LW9`0inOW0>ONeP3FS0000P3NU000103FN`00aV<00;e2
003_Y@020?N]00080?Ne003ocTX0_/3?0;k0cP2n`<l0_/3>0;k0c`2m`<h2
00h@40030<O2d@2n`<h0_/3>01T0_/3>0P0>41001036`M00_/3>0;k0cP2n
`<h20<K1d180_/3>0P0>41000`37`]40_/3>0;k0cP0=0;k0cP803Q0@00<0
al;A0;k0cP2n`<h00P2n`<h200h@40030<O2d@2n`<h0_/3>05<0_/3>Z02m
`<j20;k0cP0306]eS`3Fe^@0dm?P0100dm?P00H0e]KT06]eS`2n`<h0_/3>
06]eS`3Fe^@20=?Ch0030?ooo`0U9CH0oooo00P0oooo00/09BDf0=?Ch03C
dn00dm?P0=KFi01[MHl0_/3?0;k0cP2V>D@0h6IU0>5ZJP040>=/K0<0oooo
00@0AQhJ0?ooo`3oool0oooo103SK6`0103QJVX0h6IU0:HiA02m`<l20;k0
c`40_/3>0@3:c=P10?ooo`0000L0IVIn0<W:f02f^<P0^Kc;0;Zlb`2j_<`0
FU9B0080kno_00`0eY`00=J<003NU000eX@00>nU003NS000_EX00=Ic003_
W000mnoW0?Ogm`3oool20;Vlc0040;Zkc02i_</0^[c;0;Vlc0803Q0@1037
`]4H0;Vlc00308F8T`1DEUd0^Kc<0080^Kc<00<0HF=[06MVK@35`M00402i
_<`20<O2d@803Q0@1037`]4<0;Vlc0803Q0@00<0a/7@0;Vlc02i_<`00P2i
_<`200h@40030<K1d02i_<`0^Kc<05<0^Kc<Z02j_<b20;Zlb`0306]eS`3H
f>D0dm?Q0100dm?Q00H0f=SU06]eS`2j_</0^[c;06]eS`3Hf>D20=?Ch@03
0?ooo`1^KHl0KVf?00P0KVf?00h09BDf0=?Ch@3Cdn40dm?Q0=SHi@1[MHl0
^[c;0;Zlc02V>D@0h6UX0>5]K03TLFd0i75_0>A`KP<0oooo00<0AQhJ0>A`
KP167QX00`3oool20>A`KP090>AaK@3QKF`0h6UX0:HiA02j_<`0^[_<0;Vl
b`2f^<P0bL[H0040oooo00002@1VIWh0alWG0;Bfa`2f^<P0][S90;Jib@1J
DU80Q8B40>OWgP020>o_k`070<I[003gaP00kkD00>nL003NS000cV/00>NL
00030?Ogm`060;Jhb@2f^LT0]kS90;Jib@2g^LT0][S91@0>410N0;Nhb@80
H65Z402g^<T800h@40d0]kS900<0Jfaf0453B02g^<T0102g^<T00`1[K7H0
@D=80;Nhb@1E0;NhbJP0][S9PP2g^<T0101[MHl0e]KT0=SHi@3Hf>H30=SH
i@D0f=SV0`3Hf>D20=SHiP80f=SU00T0e]KT06]eS`2g^<T0]kS906]eS`3F
e^@0f=SU0=SHiP3oool02P1^KHl03@0U9CH0f=SV0=SHi@3Hf>D0e]KT06]e
S`2g^<T0]kW90:HiA03TKVd0i7A_0>MaK`3TM6l00`3oool01@167QX0i7A_
0>AdK`3TM6l0AQhJ00<0oooo00X0i7A_0>MaK`3TM6l0i6i]0:HiA02f^LT0
][S90;Jib@2d]/L0alWG0@3oool0000306IVOP36b=L0];K700<0];K700<0
FU9B0>o_k`3_knl00P3_knl02P3W[@00mlH80>NU003WU000ih`00>oWeP3N
U3T0kmJe0?ogm`3ooooo0;BfamX0];K700D0JgF?0=GEh`3LfnL0g=_W0=gK
i`0>0=cKi`060=GEh`1[MHl0];K70;Bfa`1[MHl0eMGS0P3LfnL00`3MfnL0
9BDf02DU=P0902DU=P<0g=_W00T0eMGS06]eS`2d]/L0];K70:HiA03WLfl0
igEb0>YfL`3ZN7H00P3oool00`167QX0jGih0>UnN0030>UnN00804HN6P3o
ool0oooo0>YhMP3ZMW<0igEb0>McK`2V>D@40;Bfa`40a/SG0@3oool00003
06IVOP36b=L0];K700<0];K700H0FU9B08b<S03_knl0kno_0>O>N`3_knl2
0?Ogm`070>ND003gilh0moOg0?Ogm`3_imH0moOg0?ooo`3o0;BfamX0];K7
00<0JgF?0=GDh`3PgnX0403PgnX01P3Ee><0JgF?0;Bfa`2d]/L0JgF?0=GD
ha40h=oZ00T0eMCS06]eS`2d]/L0];K70:HiA03ZNG<0jGah0>n1NP3bRH40
0P167QX01`3[V8/0jY^<0>fGRP3[V8/0jY^<0>fGRP3[V8/00P167QX01@3b
RH40kh5j0>UlN03ZNG<0YSU400@0];K70@36b=L10?ooo`0000<0IVIn0<K8
e`2a/lP00`2a/lP01P1JDU80kno_0>o_k`3_knl0moO_0>o_k`80moOg00<0
mnO60?Ogm`3oool00`3gmoL00`3oool0/K?80;6cb03o0;6cb=P0/K?800<0
JgF?0>g[l`3Yj?40403Yj?401P3]jo<0JgF?0;6cb02a/lP0JgF?0>g[la40
jNSa01T0kN_c06]eS`2a/lP0/K?80:HiA03aP7D0l8Al0?F<Q03gWHh0lZ^F
0?6bV`3]]9/0k;FL0?6bV`3]]9/0k;FL0?6bV`3]]9/0k;FL0?:[UP3gWHh0
mHb40?24O03aP7D0YSU400@0/K?80@36b=L10?ooo`0000<0IVIn0<K8e`2h
]ll00`2_[/L01@1JDU80[Jf]0?Ogk`3gmoL0kno_00H0moOg0P3omoL20?oo
ool0[jk7fP2_[/L00`1[MHl0d]7S0?;am`0@0?;am`060=;Ah`1[MHl0[jk7
0:n^a`1[MHl0d]7S4@3blOL01P3BdN<0JgF?0:n^a`2_[/L0YSU40?B:O@80
mI253@3b^9h20?F@Q@030?B:O@2V>D@0[jk70080[jk70@2h]ll10<K8e`40
oooo00000`1VIWh0`<7A0<O7e03o0:b[a>`0[:_400@0Q8bR06]eS`3<bmd0
no_l3@3oool0103kno`0c<_M06]eS`24S:820:b[a00408B<XP1[MHl0c<_M
0?_ko0d0oooo00@0no_l0<c;g@1[MHl0Q8bR0P2/Zl@01`2AV:X0YSU40?nO
S@3n_j@0n]bg0?[[]`3jjKH00P3ijKH0103jjKH0nNVf0?WY]P3jjKH20?WY
]P060?[[]`3jg;L0o[nT0?nOS@2V>D@0TIRZ0`2/Zl@10<O7e040`<7A0@3o
ool0000406IVOP30`M40d];O0;FdbOl0Y:>nk02TXkh00`24S:80JgF?06]e
S`0?06]eS`0308B<XP2TXkh0Y:>n0080Y:>n00<0Q8bR06]eS`1[MHl03`1[
MHl00`24S:80Y:>n0:BS_P020:BS_P0308B<XP2V>D@0YSU400l0YSU400L0
Q8bR0:BS_P2TXkh0Y:>n0;Fdb@3Bd]l0`<7A0040oooo00001P1VIWh0Z:No
0>KVk@3Bd^00_;c?0;6`a?l0Z:Noo`2XYkl]0:RW_`050;6`a02l_<l0d];P
0>KVk@2XYkl00@3oool000070?ooo`27Qi/0emSR0?clo03ThnP0d=3P0<[:
fP3o0;blcol0_;c?:`2l_<l01P3:b]X0d=3P0>CSj03lo?`0emSR08N7V`40
oooo0000203oool0IVIn09FDZ`3Gf>80o?cl0?;al`3/jnh0hN;[o`3Gf>;o
0=OHhRT0emSR00L0hN;[0>c[kP3blO<0o?cl0=OHhP2EU:/0IVIn0040oooo
00020?ooo`0306IVOP2EU:/0dM7N0080o?clo`3ooooo0?ooob/0oooo0P3l
o?`0103AdMh0UIB[06IVOP3Zg;810?ooo`000`3oool206IVOP0308R7W@2E
U:/0Z:No0?l0Z:Noo`2XYklZ0:RW_`0609FDZ`28Qid0IVIn06IVOP3ollP0
elRN0@3oool000D0ooooo`1VIWko06IVORl0IVIn00@0m]ih0?WVV03mlLH0
_Zj60@3oool00001\
\>"], "Graphics",
  CellLabel->"From In[8]:=",
  Evaluatable->False,
  ImageSize->{567, 463},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Parameters", "SubsectionIcon",
  CellTags->"EquationTrekker"],

Cell[TextData[{
  "The ability to specify multiple initial conditions is remarkably useful, \
but the ",
  StyleBox["EquationTrekker", "MR"],
  " goes a step further in allowing you to investigate the solutions of \
differential equations.  Using the ",
  StyleBox["TrekParameters", "MR"],
  " option, you can give the equation with symbolic parameters, which are \
controlled through the EquationTrekker window interface."
}], "Text",
  CellTags->"EquationTrekker"],

Cell["\<\
Including a nonlinear term makes a somewhat more interesting equation to \
investigate than the simple harmonic oscillator.\
\>", "Text",
  CellTags->"EquationTrekker"],

Cell["\<\
This opens an EquationTrekker window for a nonlinear perturbation of the \
simple harmonic oscillator.  Sliders are included in the window, which allow \
you to control the values of \[Alpha] and \[Omega].\
\>", "MathCaption",
  CellTags->"EquationTrekker"],

Cell[CellGroupData[{

Cell[BoxData[
    \(EquationTrekker[\(x''\)[t]\  + \ 
          x[t]\  \[Equal] \ \[Alpha]\ Cos[\[Omega]\ x[t]], 
      x, {t, \(-10\), 10}, \ 
      PlotRange \[Rule] {{\(-10\), 10}, {\(-10\), 10}}, 
      TrekParameters \[Rule] {\[Alpha] \[Rule] 3, \ \[Omega] \[Rule] 
            1}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"EquationTrekker"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
%%ImageSize: 400 400 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.05 0.5 0.05 [
[0 .4875 -9 -9 ]
[0 .4875 9 0 ]
[.125 .4875 -12 -9 ]
[.125 .4875 12 0 ]
[.25 .4875 -6 -9 ]
[.25 .4875 6 0 ]
[.375 .4875 -12 -9 ]
[.375 .4875 12 0 ]
[.625 .4875 -9 -9 ]
[.625 .4875 9 0 ]
[.75 .4875 -3 -9 ]
[.75 .4875 3 0 ]
[.875 .4875 -9 -9 ]
[.875 .4875 9 0 ]
[1 .4875 -6 -9 ]
[1 .4875 6 0 ]
[.4875 0 -18 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .125 -24 -4.5 ]
[.4875 .125 0 4.5 ]
[.4875 .25 -12 -4.5 ]
[.4875 .25 0 4.5 ]
[.4875 .375 -24 -4.5 ]
[.4875 .375 0 4.5 ]
[.4875 .625 -18 -4.5 ]
[.4875 .625 0 4.5 ]
[.4875 .75 -6 -4.5 ]
[.4875 .75 0 4.5 ]
[.4875 .875 -18 -4.5 ]
[.4875 .875 0 4.5 ]
[.4875 1 -12 -4.5 ]
[.4875 1 0 4.5 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .5 m
0 .50625 L
s
[(-10)] 0 .4875 0 1 Mshowa
.125 .5 m
.125 .50625 L
s
[(-7.5)] .125 .4875 0 1 Mshowa
.25 .5 m
.25 .50625 L
s
[(-5)] .25 .4875 0 1 Mshowa
.375 .5 m
.375 .50625 L
s
[(-2.5)] .375 .4875 0 1 Mshowa
.625 .5 m
.625 .50625 L
s
[(2.5)] .625 .4875 0 1 Mshowa
.75 .5 m
.75 .50625 L
s
[(5)] .75 .4875 0 1 Mshowa
.875 .5 m
.875 .50625 L
s
[(7.5)] .875 .4875 0 1 Mshowa
1 .5 m
1 .50625 L
s
[(10)] 1 .4875 0 1 Mshowa
.125 Mabswid
.025 .5 m
.025 .50375 L
s
.05 .5 m
.05 .50375 L
s
.075 .5 m
.075 .50375 L
s
.1 .5 m
.1 .50375 L
s
.15 .5 m
.15 .50375 L
s
.175 .5 m
.175 .50375 L
s
.2 .5 m
.2 .50375 L
s
.225 .5 m
.225 .50375 L
s
.275 .5 m
.275 .50375 L
s
.3 .5 m
.3 .50375 L
s
.325 .5 m
.325 .50375 L
s
.35 .5 m
.35 .50375 L
s
.4 .5 m
.4 .50375 L
s
.425 .5 m
.425 .50375 L
s
.45 .5 m
.45 .50375 L
s
.475 .5 m
.475 .50375 L
s
.525 .5 m
.525 .50375 L
s
.55 .5 m
.55 .50375 L
s
.575 .5 m
.575 .50375 L
s
.6 .5 m
.6 .50375 L
s
.65 .5 m
.65 .50375 L
s
.675 .5 m
.675 .50375 L
s
.7 .5 m
.7 .50375 L
s
.725 .5 m
.725 .50375 L
s
.775 .5 m
.775 .50375 L
s
.8 .5 m
.8 .50375 L
s
.825 .5 m
.825 .50375 L
s
.85 .5 m
.85 .50375 L
s
.9 .5 m
.9 .50375 L
s
.925 .5 m
.925 .50375 L
s
.95 .5 m
.95 .50375 L
s
.975 .5 m
.975 .50375 L
s
.25 Mabswid
0 .5 m
1 .5 L
s
.5 0 m
.50625 0 L
s
[(-10)] .4875 0 1 0 Mshowa
.5 .125 m
.50625 .125 L
s
[(-7.5)] .4875 .125 1 0 Mshowa
.5 .25 m
.50625 .25 L
s
[(-5)] .4875 .25 1 0 Mshowa
.5 .375 m
.50625 .375 L
s
[(-2.5)] .4875 .375 1 0 Mshowa
.5 .625 m
.50625 .625 L
s
[(2.5)] .4875 .625 1 0 Mshowa
.5 .75 m
.50625 .75 L
s
[(5)] .4875 .75 1 0 Mshowa
.5 .875 m
.50625 .875 L
s
[(7.5)] .4875 .875 1 0 Mshowa
.5 1 m
.50625 1 L
s
[(10)] .4875 1 1 0 Mshowa
.125 Mabswid
.5 .025 m
.50375 .025 L
s
.5 .05 m
.50375 .05 L
s
.5 .075 m
.50375 .075 L
s
.5 .1 m
.50375 .1 L
s
.5 .15 m
.50375 .15 L
s
.5 .175 m
.50375 .175 L
s
.5 .2 m
.50375 .2 L
s
.5 .225 m
.50375 .225 L
s
.5 .275 m
.50375 .275 L
s
.5 .3 m
.50375 .3 L
s
.5 .325 m
.50375 .325 L
s
.5 .35 m
.50375 .35 L
s
.5 .4 m
.50375 .4 L
s
.5 .425 m
.50375 .425 L
s
.5 .45 m
.50375 .45 L
s
.5 .475 m
.50375 .475 L
s
.5 .525 m
.50375 .525 L
s
.5 .55 m
.50375 .55 L
s
.5 .575 m
.50375 .575 L
s
.5 .6 m
.50375 .6 L
s
.5 .65 m
.50375 .65 L
s
.5 .675 m
.50375 .675 L
s
.5 .7 m
.50375 .7 L
s
.5 .725 m
.50375 .725 L
s
.5 .775 m
.50375 .775 L
s
.5 .8 m
.50375 .8 L
s
.5 .825 m
.50375 .825 L
s
.5 .85 m
.50375 .85 L
s
.5 .9 m
.50375 .9 L
s
.5 .925 m
.50375 .925 L
s
.5 .95 m
.50375 .95 L
s
.5 .975 m
.50375 .975 L
s
.25 Mabswid
.5 0 m
.5 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of user PostScript
/mathtops {
gsave
MBeginOrig
moveto
MEndOrig
currentpoint
grestore
} bind def
/MAtocoords {
mathtops 4 2 roll mathtops
4 copy pop pop
3 -1 roll sub
/arry exch def
exch sub
/arrx exch def
arrx dup mul
arry dup mul
add sqrt
/arrl exch def
translate
} bind def
/MAarrowhead1 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto
-0.035 0 lineto fill
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto
-0.035 0 lineto
-0.05 0.0125 lineto stroke
} ifelse
grestore
} def
% End of user PostScript
.592 1 0 r
.5 Mabswid
.37672 .46946 m
.37412 .4699 L
.37154 .47018 L
.36892 .47032 L
.3663 .47035 L
.36368 .4703 L
.36105 .47019 L
.35841 .47008 L
.35576 .46998 L
.35311 .46994 L
.35046 .46999 L
.34781 .47017 L
.34519 .47052 L
.34288 .47099 L
.34062 .47165 L
.33841 .4725 L
.33628 .47358 L
.33425 .47488 L
.33232 .47642 L
.33053 .4782 L
.32889 .48022 L
.32741 .48246 L
.32613 .4849 L
.32504 .48754 L
.32425 .49003 L
.32363 .49261 L
.32321 .49528 L
.32297 .498 L
.32293 .50074 L
.32307 .50347 L
.32341 .50616 L
.32394 .50879 L
.32465 .51132 L
.32553 .51375 L
.32658 .51603 L
.32779 .51816 L
.32913 .52011 L
.33061 .52189 L
.33221 .52348 L
.33392 .52488 L
.33571 .52608 L
.33758 .52711 L
.33952 .52796 L
.34209 .5288 L
.34473 .5294 L
.34807 .52985 L
.35145 .53004 L
.35484 .53004 L
.35822 .52993 L
.36158 .52978 L
Mistroke
.36493 .52967 L
.36827 .52966 L
.37042 .52975 L
.37258 .52992 L
.37475 .53019 L
.37694 .53059 L
.37917 .53113 L
.38144 .53183 L
.38377 .53272 L
.38617 .5338 L
.3882 .53485 L
.39029 .53607 L
.39246 .53747 L
.39472 .53907 L
.39708 .54088 L
.39955 .54293 L
.40215 .54524 L
.4049 .54782 L
.40781 .55072 L
.41089 .55394 L
.41418 .55753 L
.41672 .5604 L
.41939 .56349 L
.4222 .56682 L
.42516 .5704 L
.42828 .57423 L
.43156 .57834 L
.43504 .58274 L
.4387 .58742 L
.44211 .59179 L
.44568 .59639 L
.44944 .60123 L
.45338 .60629 L
.45752 .61156 L
.46186 .61704 L
.46642 .62269 L
.47119 .6285 L
.47553 .63366 L
.48004 .63888 L
.48473 .64413 L
.48959 .64935 L
.49462 .65452 L
.49982 .65957 L
.50518 .66444 L
.51071 .66908 L
.51638 .67342 L
.52219 .67738 L
.52812 .6809 L
.53416 .6839 L
.54029 .68632 L
Mistroke
.54649 .68809 L
.55274 .68916 L
.55901 .68948 L
.56451 .68912 L
.56999 .68814 L
.57544 .68654 L
.58083 .6843 L
.58614 .68145 L
.59136 .67798 L
.59648 .67394 L
.60266 .66813 L
.60861 .66152 L
.61431 .65418 L
.61974 .64618 L
.62486 .6376 L
.62967 .62852 L
.63414 .61901 L
.63826 .60914 L
.64202 .59897 L
.64541 .58855 L
.64842 .57794 L
.65104 .56717 L
.65327 .55629 L
.6551 .54531 L
.65654 .53426 L
.65758 .52317 L
.65821 .51205 L
.65844 .50236 L
.65836 .49267 L
.65798 .48298 L
.65729 .47331 L
.6563 .46366 L
.65501 .45406 L
.65341 .4445 L
.65152 .43501 L
.64933 .42561 L
.64684 .41631 L
.64329 .40477 L
.63929 .39351 L
.6356 .38435 L
.63161 .37547 L
.62734 .36693 L
.62279 .35879 L
.61797 .3511 L
.61291 .34392 L
.60761 .33731 L
.60211 .33132 L
.59643 .32602 L
.59057 .32145 L
.58458 .31765 L
Mistroke
.57848 .31464 L
.57229 .31245 L
.56604 .31109 L
.55975 .31053 L
.55347 .31076 L
.5472 .31175 L
.54098 .31345 L
.53483 .31581 L
.52876 .31876 L
.5228 .32223 L
.51696 .32616 L
.51127 .33047 L
.50571 .33509 L
.50032 .33996 L
.49509 .34501 L
.49003 .35018 L
.48515 .35541 L
.47945 .3618 L
.474 .36814 L
.46881 .37437 L
.46387 .38046 L
.45917 .38635 L
.4547 .39202 L
.45046 .39746 L
.44643 .40264 L
.44325 .40674 L
.44021 .41065 L
.4373 .41438 L
.4345 .41794 L
.43182 .42133 L
.42925 .42455 L
.42628 .42823 L
.42345 .43168 L
.42076 .4349 L
.41819 .43791 L
.41573 .44073 L
.41339 .44334 L
.41061 .44636 L
.40798 .44911 L
.40547 .45162 L
.40309 .4539 L
.40082 .45596 L
.39864 .45784 L
.39746 .45881 L
.39631 .45972 L
.39518 .46058 L
.39408 .4614 L
.393 .46216 L
.39288 .46224 L
.39277 .46232 L
Mistroke
.39266 .46239 L
.39255 .46247 L
.39253 .46248 L
.39252 .46248 L
.39251 .46249 L
.39251 .4625 L
.3925 .4625 L
.39249 .4625 L
.39249 .46251 L
.39248 .46252 L
.39247 .46252 L
.39245 .46253 L
.39234 .46261 L
.39223 .46268 L
.39212 .46276 L
.39201 .46283 L
.3909 .46355 L
.38981 .46422 L
.38875 .46484 L
.3877 .46542 L
.38667 .46595 L
.38495 .46678 L
.38327 .46749 L
.38162 .46811 L
.38001 .46863 L
.37842 .46907 L
.37684 .46943 L
.37443 .46986 L
.37204 .47014 L
.36967 .47029 L
.36731 .47035 L
.36495 .47033 L
.36258 .47026 L
.36021 .47016 L
.35758 .47004 L
.35493 .46996 L
.35228 .46995 L
.34964 .47003 L
.347 .47026 L
.3444 .47066 L
.34184 .47127 L
.33934 .47212 L
.33693 .47322 L
.33463 .47462 L
.33246 .4763 L
.33046 .47828 L
.32864 .48056 L
.32704 .48311 L
.32567 .48592 L
.32456 .48895 L
Mistroke
.32373 .49215 L
.32318 .49549 L
.32294 .4989 L
.32299 .50232 L
.32334 .50571 L
.32399 .50901 L
.32493 .51215 L
.32533 .51324 L
.32577 .5143 L
.32624 .51533 L
.32674 .51634 L
.32728 .5173 L
.32784 .51824 L
.32843 .51914 L
.32931 .52034 L
.33023 .52146 L
.33121 .52252 L
.33223 .52349 L
.33329 .52439 L
.33439 .52522 L
.33596 .52623 L
.33758 .52711 L
.33926 .52785 L
.34097 .52847 L
.34272 .52897 L
.3445 .52936 L
.3463 .52965 L
.34898 .52993 L
.35169 .53005 L
.3544 .53005 L
.35711 .52997 L
.35981 .52986 L
.3625 .52975 L
.36518 .52967 L
.36785 .52966 L
.37083 .52977 L
.37384 .53006 L
.37688 .53058 L
.37998 .53136 L
.38319 .53248 L
.38652 .53397 L
.39002 .53591 L
.39374 .53836 L
.39774 .54142 L
.40121 .54438 L
.40493 .54786 L
.40896 .5519 L
.41334 .5566 L
.4171 .56083 L
.42115 .56556 L
Mistroke
.42551 .57083 L
.43024 .57668 L
.43535 .58314 L
.4409 .59024 L
.44693 .598 L
.45348 .60641 L
.45916 .61364 L
.46523 .62123 L
.47067 .62788 L
.47641 .63469 L
.4812 .64019 L
.48618 .64571 L
.49135 .65119 L
.49671 .65659 L
.50226 .66183 L
.50798 .66684 L
.51388 .67156 L
.51993 .6759 L
.52613 .67978 L
.53245 .68311 L
.53888 .68582 L
.54539 .68782 L
.5508 .68891 L
.55624 .68944 L
.56169 .68938 L
.56713 .68874 L
.57254 .68747 L
.5779 .6856 L
.5832 .68311 L
.58944 .67933 L
.59554 .67473 L
.60147 .66932 L
.6062 .66431 L
.61079 .65884 L
.61521 .65292 L
.61946 .64661 L
.62353 .63994 L
.6274 .63294 L
.63107 .62566 L
.63492 .61725 L
.63849 .60857 L
.64178 .59966 L
.64479 .59056 L
.64751 .58131 L
.64993 .57192 L
.65206 .56244 L
.65448 .54928 L
.65601 .53868 L
.65696 .53022 L
.65768 .52173 L
Mistroke
.65816 .51324 L
.65841 .50473 L
.65842 .49622 L
.6582 .48771 L
.65775 .47921 L
.65705 .47072 L
.65526 .45574 L
.65273 .44088 L
.64947 .4262 L
.64551 .41178 L
.64171 .40013 L
.63744 .38879 L
.63273 .37785 L
.62758 .36738 L
.62201 .3575 L
.61607 .34829 L
.60976 .33988 L
.60314 .33237 L
.59623 .32585 L
.58907 .32042 L
.58173 .31614 L
.57423 .31305 L
.56663 .31118 L
.55898 .31052 L
.55261 .31086 L
.54626 .31197 L
.53995 .3138 L
.53373 .3163 L
.52759 .31939 L
.52157 .32302 L
.51568 .32709 L
.50993 .33154 L
.50434 .3363 L
.49891 .34129 L
.49366 .34645 L
.48857 .35172 L
.48367 .35704 L
.47895 .36237 L
.47377 .36841 L
.46883 .37436 L
.46411 .38016 L
.45961 .3858 L
.45532 .39124 L
.45124 .39646 L
.44735 .40145 L
.44366 .40622 L
.43971 .41129 L
.43598 .41607 L
.43244 .42055 L
.4291 .42474 L
Mistroke
.42593 .42866 L
.42292 .43231 L
.42007 .43571 L
.41736 .43887 L
.41584 .44061 L
.41509 .44145 L
.41435 .44228 L
Mfstroke
.02 w
.3925 .4625 Mdot
.5 Mabswid
.41509 .44145 m
.41435 .44228 L
s
% Start of user PostScript
-1.6981995 -1.1709569 -1.7129005 -1.1544884 MAarrowhead1
% End of user PostScript
.502 0 1 r
.53561 .3333 m
.5294 .33657 L
.52333 .34045 L
.51664 .34547 L
.50846 .35266 L
.50068 .3605 L
.49335 .36878 L
.48646 .37728 L
.48005 .38586 L
.47409 .39439 L
.4686 .40277 L
.46246 .41275 L
.45698 .42233 L
.45212 .43148 L
.44786 .44019 L
.44468 .44725 L
.44189 .45404 L
.43948 .46056 L
.43743 .46686 L
.43573 .47297 L
.43437 .47891 L
.43335 .48472 L
.43265 .49044 L
.43231 .49519 L
.43219 .49991 L
.4323 .50463 L
.43263 .50937 L
.43318 .51415 L
.43397 .51899 L
.43498 .52391 L
.43623 .52894 L
.43772 .53408 L
.43946 .53937 L
.44145 .54481 L
.4437 .55043 L
.44622 .55624 L
.44851 .5612 L
.451 .5663 L
.45369 .57155 L
.45659 .57696 L
.4597 .58251 L
.46304 .58821 L
.46659 .59405 L
.47038 .60001 L
.47392 .60535 L
.47764 .61075 L
.48154 .6162 L
.48564 .62165 L
.48992 .62708 L
.49439 .63245 L
Mistroke
.49904 .63771 L
.50387 .64282 L
.50887 .64772 L
.51403 .65236 L
.51935 .65666 L
.52482 .66056 L
.5304 .66401 L
.5361 .66693 L
.54189 .66925 L
.54775 .67093 L
.55294 .67184 L
.55815 .67217 L
.56337 .67191 L
.56856 .67104 L
.57372 .66956 L
.57883 .66745 L
.58386 .66473 L
.58881 .66141 L
.59364 .6575 L
.59834 .65304 L
.60398 .64677 L
.60937 .63974 L
.61563 .63016 L
.62142 .61968 L
.62671 .60843 L
.63147 .59656 L
.63565 .58417 L
.63926 .57137 L
.64226 .55826 L
.64466 .54491 L
.64643 .5314 L
.64756 .51777 L
.64807 .50409 L
.64794 .49039 L
.64718 .47672 L
.64579 .46313 L
.64428 .45269 L
.64239 .44236 L
.64014 .43217 L
.63752 .42215 L
.63455 .41235 L
.63123 .40281 L
.62758 .39358 L
.62359 .38472 L
.61825 .37437 L
.61246 .36478 L
.60718 .35726 L
.60162 .35048 L
.59582 .34448 L
.58981 .33935 L
Mistroke
.58362 .33512 L
.57729 .33185 L
.57085 .32954 L
.56434 .32821 L
.5578 .32783 L
.55126 .32839 L
.54477 .32984 L
.53834 .3321 L
.53201 .33511 L
.52581 .33878 L
.51839 .34409 L
.51123 .3501 L
.50437 .35667 L
.49782 .36363 L
.49161 .37086 L
.48574 .37823 L
.48021 .38564 L
.47503 .39301 L
.4702 .40028 L
.46477 .40892 L
.45982 .41728 L
.45534 .42534 L
.45132 .43307 L
.44772 .44048 L
.44454 .44759 L
.44165 .45467 L
.43917 .46147 L
.43709 .46802 L
.43538 .47437 L
.43405 .48055 L
.43308 .4866 L
.43247 .49257 L
.4322 .49848 L
.43226 .50369 L
.43259 .50893 L
.43319 .51422 L
.43408 .51958 L
.43524 .52504 L
.4367 .53063 L
.43845 .53638 L
.44051 .54231 L
.44253 .54757 L
.44479 .55301 L
.4473 .55862 L
.45007 .56442 L
.4531 .57043 L
.45641 .57663 L
.46 .58304 L
.46389 .58963 L
.46808 .59641 L
Mistroke
.47257 .60334 L
.47738 .61039 L
.48168 .61638 L
.48621 .62239 L
.49097 .62836 L
.49595 .63425 L
.50115 .64 L
.50657 .64552 L
.51219 .65075 L
.51801 .65561 L
.524 .66001 L
.53014 .66386 L
.53642 .66707 L
.54281 .66956 L
.54928 .67126 L
.5558 .67209 L
.56233 .67201 L
.56884 .67098 L
.57529 .66898 L
.58165 .66601 L
.58787 .66208 L
.59394 .65724 L
.5998 .65152 L
.60542 .64499 L
.61079 .63772 L
.61697 .62789 L
.62267 .61719 L
.62785 .60576 L
.63196 .59521 L
.63562 .58427 L
.63884 .57301 L
.64158 .5615 L
.64386 .5498 L
.64565 .53795 L
.64695 .52598 L
.64777 .51395 L
.64809 .50189 L
.64792 .48982 L
.64726 .47777 L
.64577 .463 L
.64354 .44839 L
.64182 .43959 L
.63983 .4309 L
.63758 .42235 L
.63506 .41395 L
.6323 .40573 L
.62928 .39773 L
.62602 .38999 L
.62253 .38252 L
.6179 .37374 L
Mistroke
.61295 .36552 L
.60825 .35871 L
.60334 .35246 L
.59822 .34683 L
.59292 .34188 L
.58747 .33763 L
.58188 .33412 L
.57619 .33138 L
.57041 .32942 L
.56459 .32824 L
.55873 .32783 L
.55288 .32817 L
.54705 .32923 L
.54127 .33097 L
.53555 .33333 L
.52993 .33626 L
.52442 .3397 L
.51903 .34359 L
.51378 .34787 L
.50868 .35246 L
.50374 .35731 L
.49897 .36236 L
.49437 .36757 L
.48906 .374 L
.484 .3805 L
.47922 .38701 L
.47471 .39349 L
.47045 .39988 L
.46646 .40616 L
.46273 .4123 L
.46038 .41631 L
.45815 .42024 L
.45602 .4241 L
.45399 .42788 L
.45207 .43159 L
.45024 .43522 L
.44907 .43762 L
.44795 .43999 L
.44687 .44233 L
.44582 .44464 L
.44483 .44691 L
.44434 .44804 L
.44387 .44916 L
.44341 .45027 L
.44295 .45137 L
.4428 .45174 L
.44266 .45211 L
.44251 .45248 L
.4425 .45249 L
.4425 .4525 L
Mistroke
.4425 .45251 L
.44249 .45252 L
.44235 .45289 L
.4422 .45325 L
.44206 .45362 L
.44165 .45466 L
.44126 .45569 L
.44087 .45671 L
.44049 .45773 L
.43977 .45975 L
.43907 .46175 L
.43842 .46373 L
.43779 .46568 L
.43721 .46762 L
.43632 .47072 L
.43553 .47379 L
.43482 .47681 L
.4342 .47979 L
.43366 .48275 L
.43321 .48567 L
.43272 .48967 L
.43239 .49364 L
.43222 .49759 L
.4322 .50152 L
.43234 .50547 L
.43263 .50943 L
.43309 .51342 L
.43409 .51963 L
.43547 .52598 L
.43724 .53251 L
.43942 .53926 L
.44201 .54627 L
.44504 .55358 L
.44852 .56122 L
.45248 .56921 L
.45742 .57846 L
.46299 .58814 L
.46778 .59595 L
.47299 .60396 L
.47765 .61078 L
.48262 .61765 L
.48691 .62329 L
.4914 .62889 L
.49609 .63441 L
.50097 .6398 L
.50605 .64501 L
.5113 .64996 L
.51673 .65459 L
.52231 .65884 L
.52804 .66262 L
Mistroke
.53389 .66587 L
.53985 .66851 L
.54589 .67048 L
.55199 .67171 L
.55707 .67215 L
.56216 .67202 L
.56724 .67132 L
.57229 .67003 L
.5773 .66815 L
.58224 .66568 L
.58709 .66263 L
.59292 .65813 L
.59856 .65282 L
.60303 .6479 L
.60736 .6425 L
.61151 .63666 L
.61548 .63041 L
.61927 .62378 L
.62285 .61683 L
.62622 .60957 L
.62937 .60205 L
.63229 .59429 L
.63498 .58633 L
.63818 .57547 L
.64095 .56435 L
.64289 .55512 L
.64452 .54578 L
.64585 .53636 L
.64687 .52688 L
.64759 .51735 L
.648 .50779 L
.64809 .49822 L
.64788 .48865 L
.64736 .4791 L
.64653 .46959 L
.64484 .4563 L
.64255 .44317 L
.63967 .43026 L
.63621 .41764 L
.63218 .4054 L
.6276 .39364 L
.6225 .38247 L
.61691 .37201 L
.61086 .36238 L
.60551 .35511 L
.5999 .34859 L
.59406 .34287 L
.58802 .33802 L
.58181 .33408 L
.57547 .33109 L
Mistroke
.56903 .32907 L
.56254 .32801 L
.55603 .3279 L
.54952 .32869 L
.54307 .33035 L
.53669 .33281 L
.53042 .33598 L
.52428 .33979 L
.5183 .34416 L
.51249 .34898 L
.50687 .35418 L
.50146 .35968 L
.49625 .3654 L
.49127 .37127 L
.48651 .37722 L
.48198 .38322 L
.47767 .3892 L
.47288 .39619 L
.4684 .40307 L
.46423 .4098 L
.46035 .41636 L
.45676 .42273 L
.45345 .4289 L
.45042 .43488 L
.44764 .44065 L
.44512 .44624 L
.44284 .45165 L
.4408 .4569 L
.43872 .4628 L
.43694 .46853 L
.43545 .47409 L
.43425 .47953 L
.43333 .48486 L
.43268 .49011 L
.4323 .49531 L
.43219 .50049 L
.4324 .50639 L
.43295 .51235 L
.43386 .51838 L
.43513 .52454 L
.43676 .53086 L
.43878 .53738 L
.44119 .54414 L
.44401 .55117 L
.44725 .55851 L
.45262 .56948 L
.45772 .579 L
.4635 .58899 L
.46869 .59739 L
.47436 .60601 L
Mistroke
.47924 .61301 L
.48443 .62006 L
.48993 .62709 L
.49574 .63402 L
.50186 .64074 L
.50827 .64716 L
.51496 .65314 L
.5219 .65854 L
.52907 .66324 L
.53642 .66707 L
.5426 .66949 L
.54886 .67117 L
.55516 .67205 L
.56147 .67207 L
.56777 .67121 L
.57403 .66945 L
.5802 .66677 L
.58626 .6632 L
.59217 .65876 L
.5979 .65349 L
.60342 .64744 L
.60871 .64066 L
.61374 .63323 L
.61849 .62521 L
.62292 .61667 L
.62704 .60767 L
.63082 .59828 L
.63493 .58646 L
.63851 .57424 L
.64154 .56172 L
.6436 .55125 L
.64528 .54065 L
.64658 .52996 L
.64747 .51921 L
.64798 .50842 L
.64809 .49761 L
.6478 .4868 L
.64713 .47602 L
.64605 .4653 L
.6447 .45538 L
.64301 .44555 L
.64099 .43583 L
.63864 .42626 L
.63597 .41687 L
.63299 .40769 L
.62969 .39877 L
.62609 .39015 L
.61999 .37757 L
.61325 .366 L
.6078 .3581 L
Mistroke
.60206 .35097 L
.59605 .3447 L
.58981 .33935 L
.58338 .33498 L
.57679 .33163 L
.5701 .32933 L
.56333 .32809 L
.55654 .32787 L
.54976 .32865 L
.54302 .33037 L
.53638 .33295 L
.52984 .33631 L
.52346 .34036 L
.51725 .34499 L
.51123 .35011 L
.50542 .35561 L
.49983 .36142 L
.49448 .36744 L
.48937 .37361 L
.4845 .37984 L
.47988 .38609 L
.47551 .39231 L
.4707 .3995 L
.46622 .40655 L
.46207 .41342 L
.45822 .4201 L
.45468 .42658 L
.45144 .43283 L
.44847 .43888 L
.44579 .44472 L
.44336 .45037 L
.4412 .45584 L
.43928 .46114 L
.43732 .46723 L
.43569 .47313 L
.43438 .47889 L
.43338 .48452 L
.43268 .49007 L
.43229 .49556 L
.4322 .50102 L
.4324 .50649 L
.43298 .5126 L
.43393 .5188 L
.43527 .52514 L
.43699 .53165 L
.43886 .5376 L
.44105 .54376 L
Mfstroke
.02 w
.4425 .4525 Mdot
.5 Mabswid
.43886 .5376 m
.44105 .54376 L
s
% Start of user PostScript
-1.2228909 0.752056 -1.1790799 0.87511332 MAarrowhead1
% End of user PostScript
1 0 1 r
.59477 .30723 m
.58853 .30305 L
.58216 .29966 L
.57518 .29692 L
.56812 .29516 L
.56102 .29435 L
.55391 .29448 L
.54681 .29551 L
.53977 .29738 L
.5328 .3 L
.52594 .3033 L
.51759 .30821 L
.50946 .31384 L
.50158 .32 L
.49398 .32654 L
.48667 .33328 L
.47965 .34008 L
.47292 .34684 L
.46647 .35344 L
.46031 .3598 L
.45252 .36781 L
.44517 .3752 L
.43667 .38336 L
.42871 .39044 L
.42122 .39646 L
.41411 .40146 L
.40854 .40482 L
.40315 .40758 L
.3979 .4098 L
.39277 .41151 L
.38772 .41278 L
.38273 .41367 L
.37778 .41422 L
.37286 .41452 L
.36794 .41462 L
.36369 .4146 L
.35944 .41454 L
.35518 .41449 L
.35092 .41449 L
.34666 .4146 L
.34241 .41488 L
.33819 .41538 L
.33399 .41614 L
.33069 .41697 L
.32744 .41803 L
.32423 .41933 L
.32107 .42089 L
.31798 .42273 L
.31497 .42486 L
.31205 .4273 L
Mistroke
.30797 .43143 L
.30414 .43622 L
.30061 .44168 L
.29741 .44777 L
.29458 .45444 L
.29215 .46165 L
.29016 .4693 L
.28861 .47733 L
.28764 .48469 L
.28704 .49221 L
.28684 .4998 L
.28702 .50739 L
.28759 .51491 L
.28855 .52229 L
.28988 .52945 L
.29157 .53633 L
.29361 .54287 L
.29541 .54766 L
.29739 .55219 L
.29955 .55645 L
.30187 .56041 L
.30435 .56406 L
.30696 .56741 L
.3097 .57044 L
.31255 .57315 L
.31551 .57555 L
.32153 .57936 L
.32781 .58211 L
.33427 .58392 L
.33977 .58484 L
.34532 .58533 L
.35089 .58551 L
.35646 .5855 L
.36203 .58542 L
.36759 .58538 L
.37316 .58549 L
.37874 .58586 L
.38436 .58659 L
.38839 .58737 L
.39247 .5884 L
.39659 .58973 L
.40079 .59136 L
.40507 .59335 L
.40945 .5957 L
.41395 .59844 L
.41859 .6016 L
.4226 .60459 L
.42674 .6079 L
.43102 .61154 L
.43544 .6155 L
Mistroke
.44003 .6198 L
.44478 .62442 L
.44973 .62936 L
.45487 .6346 L
.46022 .64011 L
.4658 .64587 L
.4716 .65182 L
.47653 .65681 L
.48163 .66186 L
.48688 .66693 L
.4923 .67195 L
.49788 .67688 L
.50361 .68165 L
.5095 .68619 L
.51552 .69044 L
.52167 .69431 L
.52794 .69773 L
.53431 .70063 L
.54077 .70294 L
.54729 .70458 L
.55385 .70551 L
.56183 .70561 L
.56979 .70452 L
.57769 .70221 L
.58547 .69869 L
.5931 .69398 L
.60052 .68814 L
.60769 .68125 L
.61457 .67341 L
.62114 .66471 L
.62735 .65528 L
.63318 .64522 L
.63862 .63463 L
.64363 .62363 L
.64821 .61229 L
.65234 .60069 L
.65672 .58643 L
.66043 .57198 L
.66346 .55741 L
.66581 .54275 L
.66747 .52805 L
.66819 .5182 L
.66861 .50834 L
.66872 .49848 L
.66851 .48863 L
.668 .47877 L
.66718 .46892 L
.66606 .45909 L
.66462 .44927 L
.66235 .43682 L
Mistroke
.65958 .42445 L
.65708 .41483 L
.65427 .40529 L
.65117 .39586 L
.64777 .38657 L
.64409 .37746 L
.64013 .36855 L
.63589 .3599 L
.63198 .3526 L
.62787 .34557 L
.62358 .33885 L
.6191 .33246 L
.61446 .32646 L
.60966 .32087 L
.60472 .31574 L
.59853 .31017 L
.59216 .30537 L
.58565 .30141 L
.58014 .29876 L
.57456 .29673 L
.56894 .29531 L
.56329 .2945 L
.55762 .2943 L
.55195 .29468 L
.5463 .29562 L
.53955 .29745 L
.53287 .29997 L
.52629 .30311 L
.51982 .3068 L
.51348 .31095 L
.50728 .31547 L
.50124 .32028 L
.49537 .32531 L
.48966 .33048 L
.48412 .33571 L
.47876 .34096 L
.47357 .34617 L
.46737 .35252 L
.46142 .35866 L
.45462 .36567 L
.44815 .37223 L
.44028 .37996 L
.43288 .38682 L
.42588 .3928 L
.41924 .39792 L
.4129 .40223 L
.40681 .40576 L
.40091 .40858 L
.39518 .41076 L
.38956 .41236 L
Mistroke
.38403 .41347 L
.37985 .41403 L
.37569 .41438 L
.37155 .41456 L
.36741 .41462 L
.36327 .4146 L
.35913 .41454 L
.35498 .41449 L
.35083 .41449 L
.3458 .41465 L
.34079 .41504 L
.33721 .41553 L
.33366 .41622 L
.33014 .41713 L
.32667 .41831 L
.32325 .41977 L
.31991 .42154 L
.31664 .42364 L
.31347 .42607 L
.3104 .42886 L
.30747 .432 L
.30549 .43442 L
.30358 .43702 L
.30175 .43979 L
.30001 .44273 L
.29836 .44583 L
.2968 .44909 L
.29489 .45363 L
.29317 .45841 L
.29273 .45978 L
.2923 .46116 L
.29189 .46255 L
.29149 .46396 L
.29111 .46539 L
.29092 .46611 L
.29074 .46683 L
.29056 .46756 L
.29039 .46829 L
.29019 .46917 L
.29012 .46944 L
.29006 .46971 L
.29 .46998 L
.29 .46999 L
.29 .47 L
.29 .47001 L
.29 .47002 L
.28994 .47029 L
.28988 .47056 L
.28982 .47083 L
.28964 .47171 L
Mistroke
.28946 .47259 L
.28929 .47347 L
.28912 .47436 L
.28881 .47614 L
.28851 .47794 L
.28825 .47975 L
.288 .48157 L
.28778 .48341 L
.2873 .48834 L
.28699 .49332 L
.28686 .49717 L
.28684 .50102 L
.28692 .50487 L
.28709 .5087 L
.28737 .51252 L
.28774 .5163 L
.28812 .51936 L
.28856 .52237 L
.28907 .52536 L
.28964 .5283 L
.29027 .53119 L
.29096 .53404 L
.29182 .53721 L
.29275 .54031 L
.29376 .54332 L
.29484 .54624 L
.29599 .54907 L
.29721 .55181 L
.29917 .55574 L
.30126 .55942 L
.30349 .56285 L
.30583 .56602 L
.30829 .56893 L
.31085 .57157 L
.3139 .57429 L
.31707 .57666 L
.32033 .5787 L
.32366 .58042 L
.32707 .58184 L
.33052 .58298 L
.33402 .58386 L
.33807 .5846 L
.34215 .58509 L
.34625 .58538 L
.35036 .5855 L
.35448 .58552 L
.35859 .58547 L
.3627 .58541 L
.3668 .58538 L
.37176 .58544 L
Mistroke
.37672 .58569 L
.3817 .58619 L
.38672 .58701 L
.3918 .58821 L
.39696 .58986 L
.40223 .592 L
.40764 .59469 L
.41322 .59798 L
.4203 .60285 L
.42776 .60875 L
.43567 .61571 L
.44411 .62375 L
.4514 .63105 L
.45913 .63898 L
.46528 .64534 L
.47172 .65194 L
.47844 .65872 L
.48546 .66558 L
.49278 .67238 L
.50039 .67901 L
.50828 .68528 L
.51643 .69104 L
.52481 .69609 L
.53169 .69951 L
.53868 .70226 L
.54575 .70426 L
.55287 .70542 L
.56002 .70569 L
.56716 .70501 L
.57426 .70336 L
.58129 .70074 L
.58821 .69714 L
.59499 .69261 L
.60159 .68719 L
.608 .68093 L
.61417 .67391 L
.62008 .6662 L
.62667 .65638 L
.63284 .64585 L
.63751 .63689 L
.64189 .6276 L
.64595 .61805 L
.64969 .60828 L
.65311 .59835 L
.6562 .58828 L
.65895 .5781 L
.66136 .56786 L
.66389 .55505 L
.66589 .54219 L
.66735 .5293 L
Mistroke
.66829 .51638 L
.6687 .50346 L
.66858 .49053 L
.66792 .47761 L
.66674 .46471 L
.66502 .45182 L
.66278 .43899 L
.66001 .42622 L
.65672 .41355 L
.65291 .40104 L
.64859 .38873 L
.64377 .37671 L
.63847 .36506 L
.63269 .35389 L
.62647 .34332 L
.61983 .33346 L
.6128 .32446 L
.60542 .31644 L
.59914 .31068 L
.59268 .30573 L
.58606 .30163 L
.57932 .29842 L
.57249 .29613 L
.5656 .29476 L
.55867 .29429 L
.55174 .29471 L
.54485 .29595 L
.538 .29797 L
.53124 .30069 L
.52458 .30403 L
.51804 .30791 L
.51165 .31224 L
.5054 .31693 L
.49931 .3219 L
.4934 .32706 L
.48766 .33234 L
.4821 .33767 L
.47672 .34299 L
.47152 .34825 L
.4665 .35341 L
.46165 .35842 L
.45567 .36458 L
.44996 .37041 L
.44449 .37587 L
.43924 .38095 L
.43421 .38562 L
.42937 .38989 L
.4247 .39376 L
.42019 .39723 L
.41583 .40032 L
Mistroke
.41159 .40304 L
.40746 .40541 L
.40222 .40801 L
.39712 .41009 L
.39212 .4117 L
.3872 .41289 L
.38233 .41372 L
.3775 .41425 L
.3727 .41452 L
.3679 .41462 L
.36231 .41459 L
.35671 .4145 L
.3511 .41449 L
.3455 .41466 L
.33992 .41515 L
.33438 .41606 L
.32967 .41728 L
.32505 .41897 L
.32148 .42067 L
.318 .42272 L
.31461 .42514 L
.31134 .42795 L
.30821 .43115 L
.30523 .43475 L
.30241 .43875 L
.29941 .44382 L
.29667 .44937 L
.29423 .45537 L
.29211 .46178 L
.29033 .46855 L
.2889 .47561 L
.28784 .4829 L
.28715 .49036 L
.28685 .49791 L
.28694 .50548 L
.28741 .51299 L
.28827 .52039 L
.28949 .52758 L
.29108 .53452 L
.29302 .54113 L
.29529 .54736 L
.29786 .55317 L
.30072 .55851 L
.30384 .56336 L
.30719 .56768 L
.31076 .57149 L
.3145 .57477 L
.3184 .57754 L
.32243 .57982 L
.32656 .58165 L
Mistroke
.33078 .58305 L
.33506 .58408 L
.33938 .58479 L
.34373 .58522 L
.3481 .58545 L
.35247 .58552 L
.35685 .5855 L
.36122 .58543 L
.36559 .58538 L
.37084 .58542 L
.3761 .58565 L
.38042 .58604 L
.38477 .58665 L
.38916 .58754 L
.39359 .58873 L
.3981 .59028 L
.40269 .5922 L
.40739 .59455 L
.41222 .59735 L
.4172 .60062 L
.42236 .60441 L
.42772 .60872 L
.43332 .61358 L
.43917 .61898 L
.44531 .62494 L
.45176 .63142 L
.45855 .63838 L
.46413 .64415 L
.46994 .65013 L
.47599 .65627 L
.48228 .6625 L
.48756 .66756 L
.49299 .67257 L
.49859 .67749 L
.50434 .68223 L
.50786 .68496 L
.50964 .6863 L
.51143 .6876 L
Mfstroke
.02 w
.29 .47 Mdot
.5 Mabswid
.50964 .6863 m
.51143 .6876 L
s
% Start of user PostScript
0.19270275 3.7259207 0.22852476 3.7520084 MAarrowhead1
% End of user PostScript
.533 0 1 r
.83688 .63969 m
.84017 .63474 L
.84335 .6296 L
.84853 .62026 L
.85331 .61032 L
.85766 .5998 L
.86157 .58871 L
.86501 .5771 L
.86795 .56502 L
.87039 .55253 L
.8723 .53971 L
.87368 .52664 L
.87451 .51339 L
.87479 .50005 L
.87448 .48587 L
.87354 .4718 L
.87199 .45794 L
.86984 .44437 L
.8671 .43121 L
.86379 .41853 L
.85993 .4064 L
.85555 .39489 L
.85068 .38403 L
.84534 .37384 L
.83957 .36432 L
.83339 .35545 L
.82524 .34529 L
.81655 .33589 L
.80953 .32906 L
.80223 .32244 L
.79466 .31591 L
.78681 .30933 L
.77868 .30256 L
.77026 .29547 L
.76154 .2879 L
.75249 .27974 L
.74308 .27088 L
.73625 .2642 L
.72923 .25711 L
.72199 .24962 L
.71452 .24171 L
.70682 .23342 L
.69887 .22479 L
.69066 .21586 L
.68218 .20673 L
.67343 .19748 L
.66442 .18825 L
.65513 .17916 L
.64558 .17039 L
.63578 .1621 L
Mistroke
.62575 .15446 L
.6155 .14763 L
.60877 .14373 L
.60196 .14027 L
.5951 .13729 L
.58819 .13481 L
.58123 .13285 L
.57424 .13142 L
.56723 .13052 L
.5602 .13014 L
.55317 .13027 L
.54008 .13178 L
.52706 .13474 L
.51417 .13888 L
.50145 .14384 L
.4889 .1493 L
.47656 .15491 L
.46441 .16036 L
.45245 .16542 L
.44066 .16987 L
.42902 .17358 L
.41748 .1765 L
.40602 .17861 L
.39463 .17997 L
.38328 .18069 L
.37194 .18095 L
.3606 .18095 L
.34927 .18094 L
.33794 .18118 L
.32662 .18194 L
.31535 .18349 L
.30415 .18606 L
.29306 .18985 L
.28213 .19502 L
.27141 .20165 L
.26095 .20977 L
.2508 .21934 L
.23931 .23239 L
.22841 .24714 L
.21815 .26334 L
.2086 .28069 L
.19979 .29895 L
.19176 .31785 L
.18454 .33718 L
.17813 .35678 L
.17254 .37653 L
.16779 .39632 L
.16478 .41106 L
.16223 .42579 L
.16014 .44049 L
Mistroke
.15852 .45516 L
.15735 .46981 L
.15663 .48445 L
.15637 .49907 L
.15657 .51369 L
.15723 .52832 L
.15862 .54591 L
.16067 .56353 L
.16289 .57831 L
.16558 .59311 L
.16874 .60794 L
.17236 .62276 L
.17644 .63756 L
.18099 .65229 L
.18599 .66692 L
.19146 .68139 L
.19737 .69561 L
.20373 .70951 L
.21052 .72298 L
.21772 .73592 L
.22531 .74822 L
.23328 .75975 L
.2416 .7704 L
.25024 .78007 L
.25916 .78867 L
.26834 .79615 L
.27773 .80246 L
.28731 .80762 L
.29702 .81166 L
.30685 .81467 L
.31676 .81676 L
.32672 .81807 L
.33671 .81877 L
.34672 .81903 L
.35884 .81905 L
.36829 .81903 L
.37774 .81914 L
.3872 .8195 L
.39668 .82023 L
.40619 .82142 L
.41573 .82313 L
.42534 .8254 L
.43503 .82824 L
.44376 .83124 L
.45258 .83463 L
.46149 .83836 L
.4705 .84235 L
.47963 .84649 L
.48886 .85068 L
.4982 .85479 L
Mistroke
.50765 .85867 L
.51568 .86166 L
.52377 .8643 L
.53191 .86652 L
.54009 .86822 L
.54831 .86936 L
.55655 .86985 L
.56479 .86967 L
.57301 .86877 L
.57981 .86748 L
.58658 .86569 L
.5933 .8634 L
.59999 .86064 L
.60661 .85742 L
.61318 .85377 L
.61967 .84972 L
.62767 .84415 L
.63553 .8381 L
.64141 .83323 L
.6472 .82817 L
.6529 .82294 L
.6585 .8176 L
.66401 .81216 L
.66943 .80666 L
.67592 .79991 L
.68227 .79318 L
.68848 .7865 L
.69454 .77992 L
.7017 .77213 L
.70984 .76331 L
.71772 .75488 L
.72709 .74508 L
.7361 .73595 L
.74479 .72748 L
.75317 .71963 L
.76126 .71234 L
.76909 .70553 L
.77856 .69753 L
.78767 .68996 L
.79642 .68259 L
.80483 .67525 L
.81289 .66774 L
.8191 .66147 L
.82506 .65491 L
.83077 .64799 L
.83621 .64065 L
.84136 .63286 L
.84622 .62459 L
.85075 .61583 L
.85494 .60657 L
Mistroke
.85877 .59683 L
.86223 .58663 L
.8653 .57601 L
.86796 .565 L
.87019 .55366 L
.872 .54204 L
.87336 .53019 L
.87427 .51818 L
.87473 .50608 L
.87473 .49394 L
.87427 .48183 L
.87382 .47516 L
.87323 .46852 L
.87251 .46194 L
.87164 .45542 L
.87064 .44897 L
.86951 .44261 L
.86825 .43634 L
.86514 .42339 L
.86147 .41098 L
.85726 .39917 L
.85255 .388 L
.84736 .37751 L
.84171 .3677 L
.83565 .35856 L
.8292 .35004 L
.82361 .34344 L
.81779 .33717 L
.81175 .33116 L
.80549 .32535 L
.79902 .31964 L
.79235 .31396 L
.78547 .30821 L
.77837 .30231 L
.77193 .29689 L
.76532 .29121 L
.75851 .28522 L
.75151 .27884 L
.7443 .27205 L
.73686 .2648 L
.72918 .25707 L
.72124 .24884 L
.714 .24115 L
.70652 .2331 L
.69882 .22474 L
.69087 .2161 L
.68268 .20726 L
.67423 .19831 L
.66552 .18936 L
.65657 .18054 L
Mistroke
.64736 .17198 L
.63792 .16384 L
.62826 .15628 L
.61839 .14945 L
.60833 .1435 L
.59813 .13854 L
.58779 .13469 L
.57737 .132 L
.56688 .13049 L
.55637 .13015 L
.54586 .13092 L
.5354 .13269 L
.52499 .13533 L
.51467 .1387 L
.50445 .14261 L
.4928 .14756 L
.48131 .15274 L
.46999 .15788 L
.45884 .16277 L
.44785 .16723 L
.43698 .17112 L
.42624 .17435 L
.41559 .1769 L
.40502 .17875 L
.39449 .17998 L
.384 .18066 L
.37352 .18094 L
.36304 .18096 L
.35256 .18093 L
.34454 .181 L
.33651 .18124 L
.3285 .18177 L
.3205 .18267 L
.31253 .18403 L
.3046 .18593 L
.29673 .18844 L
.28893 .19163 L
.27941 .19655 L
.27006 .2026 L
.26401 .20721 L
.25806 .21232 L
.25221 .21791 L
.24649 .22396 L
.24089 .23045 L
.23544 .23736 L
.23012 .24466 L
.22393 .25391 L
.21798 .26363 L
.21334 .27179 L
.20886 .28019 L
Mistroke
.20455 .28879 L
.20042 .29757 L
.19646 .30649 L
.19269 .31555 L
.1883 .3268 L
.18419 .33817 L
.18037 .34962 L
.1758 .36467 L
.17306 .37457 L
.17053 .38448 L
.16821 .3944 L
.1661 .40432 L
.16419 .41423 L
.1625 .42413 L
.16166 .4295 L
.16089 .43487 L
.16018 .44023 L
.15953 .44559 L
.15894 .45095 L
.15861 .45419 L
.15831 .45743 L
.15802 .46067 L
.15776 .46391 L
.15767 .4651 L
.15759 .46629 L
.1575 .46748 L
.1575 .46749 L
.1575 .4675 L
.1575 .46751 L
.1575 .46752 L
.15742 .46871 L
.15734 .4699 L
.15727 .47108 L
.15707 .47437 L
.15691 .47765 L
.15676 .48093 L
.15664 .48422 L
.1565 .48931 L
.15641 .49439 L
.15637 .49948 L
.1564 .50457 L
.15647 .50966 L
.15675 .51881 L
.15721 .52797 L
.15784 .53714 L
.15866 .54632 L
.15966 .55551 L
.16083 .5647 L
.16273 .5773 L
.16496 .58991 L
Mistroke
.16754 .60254 L
.17045 .61517 L
.17369 .6278 L
.17728 .64039 L
.1812 .65294 L
.18545 .66541 L
.19004 .67777 L
.19496 .68996 L
.20019 .70194 L
.20575 .71366 L
.21161 .72504 L
.21868 .73756 L
.22612 .74945 L
.23391 .7606 L
.24203 .77091 L
.25045 .78029 L
.25914 .78865 L
.26806 .79594 L
.2772 .80214 L
.28745 .80769 L
.29786 .81196 L
.30631 .81453 L
.31482 .81641 L
.32337 .8177 L
.33195 .8185 L
.34054 .81891 L
.34914 .81906 L
.35774 .81906 L
.36635 .81903 L
.37495 .81908 L
.38356 .81932 L
.39217 .81983 L
.40182 .82081 L
.41151 .82231 L
.42125 .82437 L
.43106 .82702 L
.44096 .83024 L
.45097 .83399 L
.4611 .83819 L
.47136 .84273 L
.48175 .84746 L
.49226 .8522 L
.50291 .85676 L
.51369 .86095 L
.52459 .86455 L
.53558 .86735 L
.54665 .86918 L
.55775 .86987 L
.56885 .86932 L
.57992 .86746 L
Mistroke
.58945 .86477 L
.59889 .86112 L
.60823 .85656 L
.61744 .85115 L
.6265 .84501 L
.63538 .83822 L
.64409 .83092 L
.6526 .82322 L
.6609 .81525 L
.669 .80711 L
.67688 .7989 L
.68576 .78943 L
.69436 .78012 L
.70268 .77107 L
.71073 .76236 L
.71852 .75403 L
.72607 .74613 L
.73339 .73867 L
.74049 .73163 L
.74738 .72502 L
.75576 .71726 L
.76387 .71005 L
.7717 .70331 L
.77929 .69693 L
.78665 .69081 L
.79377 .68484 L
.80067 .67893 L
.80734 .67297 L
.81379 .66686 L
.82263 .65766 L
.83095 .64775 L
.83733 .63903 L
.84331 .62967 L
.84885 .61963 L
.85393 .60891 L
.85853 .5975 L
.8626 .58546 L
.86612 .57283 L
.86906 .55969 L
.87142 .54612 L
.87316 .5322 L
.87428 .51805 L
.87476 .50376 L
.87461 .48944 L
.87383 .4752 L
.87241 .46115 L
.87038 .44738 L
.86774 .434 L
.86451 .4211 L
.86073 .40874 L
Mistroke
.85641 .397 L
.85158 .38591 L
.84561 .37432 L
.83909 .36359 L
.83206 .35368 L
.82455 .3445 L
.8166 .33595 L
.80824 .32786 L
.79948 .32004 L
.79034 .31227 L
.78081 .30434 L
.77087 .29598 L
.7605 .28699 L
.74967 .27713 L
.73653 .26448 L
.7263 .25411 L
.71562 .24288 L
.7156 .24286 L
.71558 .24284 L
.71556 .24282 L
.71554 .2428 L
.71552 .24278 L
.71548 .24273 L
.71544 .24269 L
.7154 .24265 L
.71501 .24224 L
.71462 .24182 L
.71423 .2414 L
.71384 .24099 L
.71073 .23765 L
.70758 .23424 L
.70438 .23078 L
.70115 .22727 L
.69787 .2237 L
.69281 .2182 L
.68766 .21262 L
.6824 .20696 L
.67704 .20127 L
.67158 .19555 L
.66601 .18985 L
.65969 .18357 L
.65325 .17739 L
.64668 .17137 L
.63999 .16557 L
.63319 .16004 L
.62628 .15484 L
.61927 .15002 L
.61138 .14519 L
.6034 .14096 L
.59532 .13738 L
Mistroke
.58717 .13449 L
.57897 .13233 L
.57073 .1309 L
.56246 .13021 L
.55418 .13022 L
.54592 .13091 L
.53767 .13222 L
.52946 .1341 L
.5213 .13646 L
.5132 .13923 L
.50516 .14232 L
.49719 .14565 L
.4893 .14912 L
.48149 .15266 L
.47376 .15618 L
.4661 .15962 L
.45776 .16323 L
.44951 .16658 L
.44133 .16963 L
.43322 .17232 L
.42518 .17464 L
.41719 .17656 L
.40924 .17809 L
.40132 .17925 L
.39343 .18007 L
.38556 .18059 L
.37498 .18092 L
.3644 .18097 L
.35383 .18093 L
.34326 .18102 L
.33269 .18145 L
.3243 .18219 L
.31593 .18339 L
.30759 .18514 L
.29932 .18755 L
.29111 .19066 L
.283 .19455 L
.275 .19924 L
.26713 .20476 L
.25942 .21109 L
.25189 .21823 L
.24456 .22613 L
.23745 .23475 L
.23057 .24403 L
.22394 .2539 L
.21759 .2643 L
.21151 .27515 L
.20572 .2864 L
.20024 .29796 L
.19506 .30979 L
Mistroke
.18893 .32513 L
.18441 .33754 L
.18023 .35005 L
.17638 .36263 L
.17288 .37526 L
.1697 .38791 L
.16687 .40056 L
.16438 .41321 L
.16222 .42584 L
.16041 .43845 L
.15893 .45104 L
.15779 .46361 L
.15698 .47617 L
.15651 .48872 L
.15639 .50361 L
.15674 .5185 L
.15756 .5334 L
.15886 .54833 L
.16064 .56328 L
.16289 .57826 L
.16561 .59326 L
.16882 .60828 L
.1725 .6233 L
.17666 .6383 L
.18129 .65323 L
.1864 .66804 L
.19093 .68005 L
.19578 .69191 L
.20093 .70355 L
.20638 .71494 L
.21213 .726 L
.21816 .73668 L
.22446 .74691 L
.23218 .75824 L
.24024 .76875 L
.24697 .77658 L
.2539 .78376 L
.26099 .79027 L
.26823 .79607 L
.27561 .80114 L
.2831 .8055 L
.29069 .80916 L
.29837 .81213 L
.30611 .81448 L
.3139 .81624 L
.32173 .8175 L
.32958 .81832 L
.33745 .8188 L
.34533 .81902 L
.35321 .81907 L
Mistroke
.36109 .81904 L
.36897 .81903 L
.37685 .81912 L
.38474 .81937 L
.3941 .81999 L
.4035 .82103 L
.41292 .82257 L
.42241 .82465 L
.43196 .82729 L
.44159 .83046 L
.45133 .83413 L
.46118 .83823 L
.47116 .84264 L
.48126 .84724 L
.49151 .85186 L
.49998 .85554 L
.50855 .85902 L
.51719 .86218 L
.5259 .86493 L
.53467 .86716 L
.54349 .86877 L
.55234 .86968 L
.56121 .86984 L
.57006 .86918 L
.57889 .86768 L
.58768 .86535 L
.5964 .86218 L
.60503 .85823 L
.61356 .85354 L
.62197 .84818 L
.63025 .84223 L
.63837 .83579 L
.64634 .82894 L
.65413 .82178 L
.66176 .8144 L
.6692 .8069 L
.67647 .79934 L
.68459 .79069 L
.69249 .78215 L
.70014 .77382 L
.70758 .76576 L
.71479 .758 L
.7218 .75058 L
.7286 .74353 L
.73522 .73683 L
.74166 .7305 L
.74792 .7245 L
.75403 .71884 L
.75999 .71347 L
.7658 .70837 L
Mistroke
.77437 .70105 L
.78264 .69414 L
.78908 .68878 L
.79533 .68352 L
.80141 .67828 L
.80731 .673 L
.81304 .6676 L
.81857 .66202 L
.82392 .65621 L
.83017 .64875 L
.83611 .6408 L
.8417 .63232 L
.84694 .62326 L
.8518 .61363 L
.85624 .60341 L
.85959 .59457 L
.86262 .58537 L
.86535 .57583 L
.86774 .56598 L
.8698 .55586 L
.87151 .5455 L
.87287 .53496 L
.87387 .52426 L
.8745 .51346 L
.87478 .5026 L
.87468 .49172 L
.87422 .48089 L
.87339 .47013 L
.87201 .45807 L
.87018 .44624 L
.86789 .43471 L
.86517 .42352 L
.86203 .41273 L
.85848 .40238 L
.85638 .39693 L
.85416 .39162 L
Mfstroke
.02 w
.1575 .4675 Mdot
.5 Mabswid
.85638 .39693 m
.85416 .39162 L
s
% Start of user PostScript
7.1275873 -2.0614642 7.0832516 -2.1676373 MAarrowhead1
% End of user PostScript
.976 1 0 r
.50791 .74986 m
.50985 .75093 L
.51181 .75199 L
.51575 .75402 L
.52285 .75734 L
.53004 .7602 L
.5373 .76252 L
.54462 .76423 L
.55198 .76525 L
.55935 .76555 L
.56598 .76515 L
.57259 .76411 L
.57917 .76241 L
.5857 .76006 L
.59216 .75707 L
.59853 .75345 L
.60481 .74924 L
.61227 .74339 L
.61954 .73679 L
.6266 .72954 L
.63343 .72172 L
.64002 .71341 L
.64635 .70471 L
.65241 .69571 L
.65819 .68647 L
.66369 .67707 L
.66891 .66758 L
.67384 .65804 L
.67848 .64849 L
.68385 .63665 L
.68878 .62491 L
.6943 .61051 L
.69727 .60204 L
.7 .59367 L
.70251 .58539 L
.70478 .57719 L
.70682 .56909 L
.70864 .56107 L
.71023 .55312 L
.71212 .54194 L
.71357 .53087 L
.71457 .51988 L
.71515 .50895 L
.71529 .49805 L
.71499 .48713 L
.71426 .47619 L
.7131 .46517 L
.71175 .45566 L
.71008 .44607 L
.70808 .43638 L
Mistroke
.70575 .42657 L
.70308 .41663 L
.70008 .40656 L
.69673 .39636 L
.69302 .38602 L
.68784 .37278 L
.68209 .35937 L
.67785 .35019 L
.67334 .34098 L
.66856 .33178 L
.66352 .32262 L
.6582 .31355 L
.65263 .30464 L
.6468 .29593 L
.64071 .28751 L
.63439 .27945 L
.62784 .27182 L
.62107 .2647 L
.615 .25898 L
.6088 .25377 L
.60247 .24911 L
.59603 .24505 L
.58949 .24162 L
.58288 .23884 L
.5762 .23674 L
.56948 .23532 L
.56273 .23458 L
.55597 .23449 L
.54921 .23505 L
.54248 .2362 L
.53579 .23791 L
.52733 .24081 L
.51897 .24441 L
.51074 .24858 L
.50266 .25318 L
.49473 .25809 L
.48696 .26317 L
.47935 .2683 L
.47192 .27339 L
.46464 .27834 L
.45753 .28307 L
.45056 .28751 L
.44211 .29254 L
.43289 .29748 L
.42387 .30163 L
.41502 .30498 L
.40631 .30756 L
.39863 .30924 L
.391 .31041 L
.38342 .31113 L
Mistroke
.37586 .31149 L
.3683 .31161 L
.36075 .31158 L
.35319 .31154 L
.34564 .31162 L
.33809 .31196 L
.33057 .31268 L
.32308 .31392 L
.31566 .31581 L
.30832 .31845 L
.30111 .32195 L
.29406 .32636 L
.2872 .33175 L
.28058 .33813 L
.27423 .34551 L
.26821 .35386 L
.26253 .36316 L
.25724 .37333 L
.25238 .38431 L
.24798 .39601 L
.24405 .40836 L
.24064 .42126 L
.23775 .43463 L
.23608 .44403 L
.23467 .45358 L
.23352 .46325 L
.23264 .47302 L
.23204 .48285 L
.2317 .49274 L
.23164 .50264 L
.23193 .51472 L
.23263 .52675 L
.23373 .53868 L
.23523 .55046 L
.23712 .56203 L
.2394 .57336 L
.24205 .58438 L
.24507 .59505 L
.24844 .60531 L
.25215 .61512 L
.25618 .62441 L
.26051 .63315 L
.26513 .64129 L
.27001 .64879 L
.27513 .65562 L
.28047 .66176 L
.28601 .66719 L
.29171 .67193 L
.29756 .67597 L
.30354 .67934 L
Mistroke
.30962 .68208 L
.31578 .68423 L
.32201 .68585 L
.32828 .687 L
.33645 .68792 L
.34292 .68829 L
.3494 .68844 L
.35589 .68845 L
.36237 .68841 L
.36885 .6884 L
.37533 .68849 L
.38182 .68877 L
.38971 .68944 L
.39764 .69058 L
.40393 .69186 L
.41026 .69352 L
.41666 .69558 L
.42313 .69806 L
.42969 .70097 L
.43635 .7043 L
.44313 .70804 L
.45004 .71217 L
.45603 .71597 L
.46214 .71998 L
.46835 .72417 L
.47469 .7285 L
.48115 .73292 L
.48773 .73735 L
.49443 .74173 L
.50126 .74598 L
.5082 .75002 L
.51526 .75377 L
.52241 .75715 L
.52965 .76006 L
.53696 .76243 L
.54434 .76417 L
.55175 .76523 L
.55918 .76555 L
.56571 .76518 L
.57223 .76418 L
.57871 .76255 L
.58514 .76028 L
.59152 .75739 L
.59781 .75389 L
.60401 .74981 L
.61153 .74401 L
.61886 .73745 L
.62737 .7287 L
.63554 .71913 L
.64336 .70891 L
Mistroke
.65078 .69818 L
.65781 .68709 L
.66443 .67576 L
.67064 .6643 L
.67642 .65279 L
.68179 .6413 L
.68772 .62752 L
.69305 .61392 L
.69778 .60053 L
.70193 .58737 L
.7055 .57443 L
.708 .56401 L
.71012 .55371 L
.71188 .54353 L
.71327 .53344 L
.7143 .52343 L
.71496 .51347 L
.71527 .50354 L
.71522 .49362 L
.71483 .48409 L
.71412 .47453 L
.71307 .46491 L
.71168 .45523 L
.70996 .44545 L
.7079 .43557 L
.7055 .42557 L
.70314 .41683 L
.70052 .40798 L
.69763 .39903 L
.69448 .38998 L
.69105 .38082 L
.68734 .37156 L
.68336 .36223 L
.6791 .35284 L
.67455 .3434 L
.66973 .33397 L
.66462 .32457 L
.65923 .31526 L
.65357 .3061 L
.64823 .29801 L
.64267 .29015 L
.63691 .28257 L
.63094 .27534 L
.62479 .26852 L
.61846 .26217 L
.61196 .25635 L
.60532 .25113 L
.59854 .24655 L
.59165 .24267 L
.58466 .23952 L
Mistroke
.5776 .23712 L
.57048 .23549 L
.56333 .23462 L
.55617 .23449 L
.54902 .23507 L
.54188 .23633 L
.53479 .23821 L
.52776 .24064 L
.51941 .24421 L
.51117 .24835 L
.50308 .25293 L
.49515 .25782 L
.48737 .26289 L
.47976 .26802 L
.47232 .27312 L
.46504 .27807 L
.45792 .28281 L
.45095 .28727 L
.44239 .29238 L
.43404 .2969 L
.42693 .3003 L
.41994 .30321 L
.41305 .30563 L
.40623 .30758 L
.39947 .30908 L
.39276 .31018 L
.38608 .31092 L
.37803 .31142 L
.37174 .31158 L
.36544 .31161 L
.35915 .31157 L
.35285 .31154 L
.34655 .3116 L
.34026 .31183 L
.33398 .31229 L
.32772 .31308 L
.3215 .31427 L
.31532 .31592 L
.3106 .31754 L
.30593 .31951 L
.30131 .32184 L
.29676 .32454 L
.29228 .32765 L
.28789 .33115 L
.28359 .33507 L
.28023 .3385 L
.27694 .34219 L
.27374 .34615 L
.27061 .35036 L
.26757 .35482 L
Mistroke
.26463 .35953 L
.2625 .3632 L
.26043 .367 L
.25842 .37092 L
.25647 .37496 L
.25458 .37912 L
.25238 .38431 L
.25028 .38965 L
.24828 .39513 L
.24639 .40076 L
.2446 .40651 L
.24292 .41239 L
.24134 .41838 L
.23949 .42624 L
.23782 .43426 L
.23634 .44241 L
.23548 .44783 L
.2347 .4533 L
.23401 .4588 L
.23341 .46435 L
.23289 .46992 L
.23283 .4707 L
.23276 .47148 L
.2327 .47227 L
.23264 .47305 L
.23264 .47313 L
.23263 .4732 L
.23262 .47328 L
.23262 .47332 L
.23262 .47336 L
.23262 .4734 L
.23261 .47344 L
.23261 .47348 L
.23257 .47398 L
.23254 .47448 L
.2325 .47498 L
.2325 .47499 L
.2325 .475 L
.2325 .47501 L
.2325 .47502 L
.23246 .47552 L
.23243 .47602 L
.2324 .47652 L
.23239 .47656 L
.23239 .4766 L
.23239 .47664 L
.23239 .47668 L
.23238 .47672 L
.23238 .4768 L
.23237 .47688 L
Mistroke
.23237 .47695 L
.23232 .47774 L
.23227 .47853 L
.23222 .47932 L
.23218 .4801 L
.23193 .48526 L
.23176 .49042 L
.23165 .49559 L
.23163 .50077 L
.23168 .50594 L
.23188 .51339 L
.23223 .52082 L
.23274 .52822 L
.2334 .53558 L
.23422 .54288 L
.23518 .55012 L
.23658 .55899 L
.23821 .56772 L
.24006 .57629 L
.24213 .58468 L
.24441 .59285 L
.2469 .6008 L
.24959 .60849 L
.25268 .61641 L
.25598 .62399 L
.25949 .63119 L
.26319 .638 L
.26707 .64439 L
.27112 .65035 L
.27532 .65586 L
.28062 .66192 L
.28611 .66728 L
.29176 .67196 L
.29756 .67596 L
.30348 .67931 L
.3095 .68203 L
.3156 .68417 L
.32177 .6858 L
.32886 .68709 L
.33598 .68789 L
.34313 .6883 L
.35029 .68845 L
.35745 .68844 L
.36461 .6884 L
.37177 .68842 L
.37894 .68862 L
.38611 .68908 L
.39473 .6901 L
.40341 .69174 L
.41218 .6941 L
Mistroke
.42107 .69723 L
.43012 .70117 L
.43938 .70593 L
.44886 .71145 L
.45861 .71764 L
.46866 .72438 L
.47902 .73147 L
.48971 .73866 L
.50072 .74565 L
.5089 .75041 L
.51724 .75476 L
.5257 .75854 L
.53429 .76163 L
.54296 .7639 L
.55169 .76523 L
.56045 .76552 L
.5692 .76472 L
.5779 .76279 L
.58652 .75971 L
.59503 .75552 L
.60337 .75026 L
.61153 .74401 L
.61946 .73687 L
.62715 .72894 L
.63456 .72034 L
.64168 .71119 L
.64849 .7016 L
.65498 .69168 L
.66113 .68152 L
.66695 .67121 L
.67243 .66082 L
.67756 .65042 L
.68235 .64004 L
.6868 .62973 L
.69092 .61952 L
.69469 .60943 L
.69814 .59945 L
.70126 .58961 L
.70436 .57875 L
.70707 .56804 L
.70939 .55748 L
.71131 .54704 L
.71286 .5367 L
.71402 .52645 L
.71481 .51626 L
.71522 .50611 L
.71526 .49597 L
.71464 .48108 L
.71321 .46608 L
.71097 .45092 L
Mistroke
.70789 .43552 L
.70398 .41983 L
.6992 .40381 L
.69355 .38744 L
.68861 .37467 L
.68314 .36172 L
.67789 .35027 L
.67222 .33877 L
.66727 .32938 L
.66303 .32177 L
.65861 .31423 L
.65401 .30679 L
.64922 .29948 L
.64511 .29353 L
.64087 .28772 L
.63652 .28208 L
.63205 .27664 L
.62748 .27142 L
.6228 .26645 L
.61671 .26053 L
.61046 .25511 L
.60409 .25024 L
.5976 .24598 L
.591 .24235 L
.58433 .23939 L
.57758 .23712 L
.5697 .23536 L
.56178 .23453 L
.55385 .2346 L
.54593 .23554 L
.53806 .23727 L
.53024 .23972 L
.52251 .2428 L
.51488 .24641 L
.50737 .25045 L
.49998 .2548 L
.49272 .25938 L
.48561 .26407 L
.47863 .2688 L
.47179 .27348 L
.46509 .27803 L
.45853 .28241 L
.45209 .28655 L
.44428 .29129 L
.43663 .29556 L
.42912 .2993 L
.42175 .3025 L
.41449 .30516 L
.40731 .3073 L
.4002 .30894 L
Mistroke
.39315 .31013 L
.38613 .31091 L
.37914 .31137 L
.37216 .31157 L
.36403 .3116 L
.3559 .31155 L
.34777 .31158 L
.33964 .31186 L
.33154 .31256 L
.32348 .31384 L
.31549 .31586 L
.3076 .31876 L
.29986 .32265 L
.29231 .32762 L
.28501 .33372 L
.27919 .33963 L
.2736 .34632 L
.26827 .35377 L
.26321 .36197 L
.25845 .37086 L
.25403 .3804 L
.24995 .39053 L
.24624 .40121 L
.24293 .41236 L
.24001 .42392 L
.23752 .43583 L
.235 .45111 L
.23318 .46673 L
.2322 .47968 L
.2317 .49272 L
.23167 .50579 L
.23212 .51884 L
.23304 .5318 L
.23443 .54462 L
.23628 .55724 L
.23859 .56958 L
.24134 .5816 L
.24294 .5877 L
.24466 .59369 L
.24649 .59956 L
.24843 .60528 L
.25048 .61086 L
.25263 .61629 L
.25488 .62155 L
.25723 .62664 L
.26238 .63658 L
.2679 .64567 L
.27376 .65388 L
.27992 .66117 L
.28635 .6675 L
Mistroke
.29301 .67289 L
.29985 .67734 L
.30686 .68091 L
.31399 .68366 L
.32197 .68584 L
.33002 .68725 L
.33812 .68805 L
.34624 .68839 L
.35437 .68846 L
.36251 .68841 L
.37064 .68841 L
.37877 .68861 L
.38692 .68916 L
.3951 .69016 L
.40334 .69173 L
.41166 .69394 L
.42119 .69727 L
.4309 .70154 L
.44084 .70674 L
.45106 .7128 L
.46159 .71962 L
.47247 .72699 L
.48371 .73466 L
.49533 .7423 L
.50732 .74952 L
.51964 .7559 L
.52686 .759 L
.53416 .76159 L
.54153 .76359 L
.54894 .76492 L
.55639 .76552 L
.56383 .76535 L
.57127 .76437 L
.57866 .76257 L
.58599 .75994 L
.59469 .75571 L
.60324 .75036 L
.61158 .74397 L
.61969 .73665 L
.62754 .72851 L
.63511 .71967 L
.64236 .71027 L
.64929 .70042 L
.65589 .69023 L
.66355 .67732 L
.67068 .66422 L
.67612 .6534 L
.6812 .6426 L
.68591 .63187 L
.69025 .62123 L
Mistroke
.69423 .61071 L
.69785 .60033 L
.70111 .59008 L
.70403 .57998 L
.7066 .57 L
.70917 .55855 L
.71128 .54725 L
.71294 .53607 L
.71416 .52498 L
.71494 .51397 L
.71528 .50299 L
.71518 .49203 L
.71464 .48104 L
.71366 .47 L
.7109 .45053 L
.70676 .43067 L
.70123 .4103 L
.69595 .39411 L
.68978 .37758 L
.68424 .36424 L
.67812 .35075 L
.67142 .33721 L
.66414 .32372 L
.65628 .31042 L
.64786 .29748 L
.6389 .28513 L
.62942 .2736 L
.62123 .26486 L
.61273 .25701 L
.60398 .25017 L
.59501 .24447 L
.58585 .24 L
.57656 .23684 L
.56717 .23499 L
.55775 .23445 L
.5508 .23486 L
.54386 .23592 L
Mfstroke
.02 w
.2325 .475 Mdot
.5 Mabswid
.5508 .23486 m
.54386 .23592 L
s
% Start of user PostScript
1.0159397 -5.3027444 0.87724281 -5.2816377 MAarrowhead1
% End of user PostScript
1 0 .957 r
.58101 .48185 m
.58042 .47924 L
.57976 .4767 L
.57884 .47367 L
.57781 .47079 L
.57668 .46807 L
.57441 .46365 L
.57187 .45987 L
.56911 .45678 L
.56616 .45445 L
.56308 .45289 L
.55993 .45214 L
.55675 .45218 L
.5536 .453 L
.55054 .45457 L
.54826 .45627 L
.54607 .45836 L
.54401 .46082 L
.54208 .46361 L
.5403 .46672 L
.53868 .4701 L
.53725 .47372 L
.536 .47754 L
.53476 .48239 L
.53383 .48744 L
.53322 .49262 L
.53293 .49789 L
.53296 .50317 L
.53332 .50842 L
.53399 .51358 L
.53499 .51859 L
.53628 .5234 L
.53787 .52794 L
.53972 .53215 L
.54182 .53598 L
.54415 .53937 L
.54667 .54226 L
.54882 .54419 L
.55105 .54575 L
.55336 .5469 L
.55571 .54764 L
.55809 .54794 L
.56047 .54779 L
.56283 .5472 L
.56515 .54615 L
.56804 .54417 L
.57077 .54147 L
.57332 .53811 L
.57562 .53413 L
.57766 .5296 L
Mistroke
.57939 .52459 L
.58079 .51918 L
.58183 .51345 L
.58234 .50931 L
.58266 .50509 L
.58279 .50083 L
.58273 .49656 L
.58249 .49233 L
.58205 .48815 L
.58143 .48406 L
.58056 .47982 L
.57949 .47576 L
.57824 .47192 L
.5768 .46835 L
.5752 .46506 L
.57345 .4621 L
.57157 .45948 L
.56957 .45723 L
.56747 .45538 L
.56529 .45392 L
.56305 .45288 L
.56019 .45217 L
.55731 .45211 L
.55445 .4527 L
.55164 .45392 L
.54892 .45573 L
.54632 .4581 L
.54389 .46098 L
.54164 .46433 L
.5396 .46809 L
.53781 .47222 L
.53627 .47665 L
.53522 .48044 L
.53436 .48436 L
.5337 .48839 L
.53323 .4925 L
.53296 .49666 L
.5329 .50085 L
.53305 .50503 L
.53352 .51024 L
.5343 .51534 L
.5354 .52028 L
.53644 .52389 L
.53764 .52735 L
.539 .53062 L
.54051 .53368 L
.54215 .53651 L
.54393 .53908 L
.54581 .54136 L
.54822 .5437 L
Mistroke
.55074 .54556 L
.55335 .5469 L
.55602 .5477 L
.55872 .54794 L
.56116 .54766 L
.56356 .54692 L
.56592 .5457 L
.56821 .54402 L
.5704 .5419 L
.57246 .53934 L
.57439 .53638 L
.57654 .53223 L
.57824 .52806 L
.5797 .52354 L
.58089 .51872 L
.5818 .51366 L
.58242 .50843 L
.58275 .50309 L
.58277 .49771 L
.5826 .49384 L
.58227 .49 L
.58178 .48624 L
.58115 .48256 L
.58036 .479 L
.57944 .47558 L
.57838 .47232 L
.57696 .46871 L
.57538 .4654 L
.57365 .4624 L
.57178 .45974 L
.56979 .45746 L
.5677 .45556 L
.56553 .45406 L
.5633 .45297 L
.5603 .45218 L
.55728 .45212 L
.55427 .45276 L
.55133 .45409 L
.54849 .45607 L
.54579 .45866 L
.54328 .46181 L
.54098 .46545 L
.53893 .46953 L
.53715 .47399 L
.53565 .47877 L
.53447 .48379 L
.53361 .48901 L
.53309 .49434 L
.5329 .49921 L
.533 .50408 L
Mistroke
.53337 .50891 L
.53401 .51366 L
.53491 .51828 L
.53608 .52273 L
.53749 .52696 L
.53914 .53093 L
.541 .53458 L
.54306 .53788 L
.5453 .54078 L
.54706 .54265 L
.5489 .54426 L
.5508 .54559 L
.55274 .54664 L
.55473 .54738 L
.55674 .54782 L
.55877 .54794 L
.56065 .54776 L
.56253 .5473 L
.56438 .54655 L
.56619 .54553 L
.56796 .54423 L
.56968 .54266 L
.57168 .54038 L
.57356 .53773 L
.57487 .53555 L
.57609 .53319 L
.57723 .53067 L
.57827 .52798 L
.57922 .52516 L
.58006 .52221 L
.58076 .51932 L
.58136 .51634 L
.58185 .51329 L
.58225 .51018 L
.58254 .50702 L
.58272 .50384 L
.58279 .50084 L
.58277 .49784 L
.58266 .49485 L
.58245 .49188 L
.58215 .48894 L
.58175 .48605 L
.5811 .4823 L
.58029 .47868 L
.57997 .47746 L
.57964 .47625 L
.57929 .47507 L
.57892 .4739 L
.57853 .47276 L
.57833 .47219 L
Mistroke
.57813 .47163 L
.57792 .47108 L
.57771 .47054 L
.57764 .47036 L
.57758 .47019 L
.57751 .47002 L
.5775 .47001 L
.5775 .47 L
.5775 .46999 L
.57749 .46998 L
.57742 .46981 L
.57735 .46964 L
.57728 .46947 L
.57705 .46893 L
.57682 .46839 L
.57659 .46786 L
.57635 .46734 L
.57585 .46632 L
.57535 .46533 L
.57482 .46437 L
.57429 .46344 L
.57374 .46255 L
.5722 .4603 L
.57058 .4583 L
.56922 .4569 L
.56783 .45566 L
.56639 .4546 L
.56493 .45373 L
.56344 .45303 L
.56193 .45252 L
.55946 .45209 L
.55697 .45215 L
.55497 .45255 L
.55298 .45326 L
.55103 .45426 L
.54913 .45556 L
.5473 .45713 L
.54553 .45896 L
.54384 .46104 L
.54171 .46421 L
.53976 .46776 L
.53803 .47165 L
.53653 .47581 L
.53528 .48021 L
.53428 .4848 L
.53354 .48954 L
.53308 .49437 L
.5329 .49926 L
.533 .50415 L
.53338 .50901 L
Mistroke
.53416 .51456 L
.53531 .51993 L
.53681 .52504 L
.53864 .52982 L
.54078 .53418 L
.54319 .53806 L
.54584 .54139 L
.54869 .5441 L
.5517 .54612 L
.55483 .54741 L
.55801 .54793 L
.5612 .54766 L
.56434 .54657 L
.56739 .54469 L
.56947 .54287 L
.57145 .54067 L
.57332 .5381 L
.57506 .5352 L
.57666 .53198 L
.57809 .52847 L
.57936 .5247 L
.58043 .52072 L
.5812 .51717 L
.58182 .51351 L
.58229 .50976 L
.58261 .50595 L
.58277 .5021 L
.58278 .49823 L
.58263 .49438 L
.58233 .49064 L
.58189 .48696 L
.5813 .48337 L
.58057 .47987 L
.57971 .4765 L
.57871 .47328 L
.57705 .46891 L
.57514 .46495 L
.57363 .46238 L
.57203 .46007 L
.57033 .45803 L
.56855 .45627 L
.5667 .45481 L
.5648 .45366 L
.56286 .45281 L
.56089 .45228 L
.55891 .45206 L
.55692 .45216 L
.55493 .45256 L
.55297 .45326 L
.55105 .45425 L
Mistroke
.54917 .45553 L
.54735 .45708 L
.5456 .45888 L
.54325 .46185 L
.54109 .46526 L
.53914 .46906 L
.53743 .4732 L
.53598 .47762 L
.53479 .48228 L
.53388 .48712 L
.53327 .49209 L
.53295 .49714 L
.53293 .50222 L
.53321 .50727 L
.53379 .51225 L
.53466 .51711 L
.53581 .5218 L
.53702 .52565 L
.53842 .5293 L
.54 .53271 L
.54175 .53586 L
.54365 .5387 L
.54569 .54122 L
.54784 .54337 L
.5501 .54514 L
.55319 .54683 L
.55637 .54776 L
.55958 .5479 L
.56278 .54721 L
.5659 .54571 L
.5689 .54341 L
.57171 .54034 L
.5743 .53654 L
.57661 .53209 L
.57775 .52937 L
.57879 .52649 L
.57972 .52346 L
.58053 .5203 L
.58123 .51702 L
.5818 .51366 L
.58224 .51022 L
.58256 .50672 L
.58279 .5008 L
.58266 .49487 L
.58216 .48902 L
.5813 .48334 L
.58009 .47792 L
.57856 .47284 L
.57672 .46817 L
.57511 .46489 L
Mistroke
.57334 .46193 L
.57144 .45932 L
.56943 .45709 L
.56731 .45526 L
.56512 .45383 L
.56287 .45282 L
.56033 .45219 L
.55777 .45208 L
.55522 .45248 L
.5527 .45338 L
.55024 .45476 L
.54787 .4566 L
.54562 .45886 L
.54349 .46152 L
.54135 .46481 L
.53942 .46848 L
.53771 .47247 L
.53624 .47675 L
.53502 .48127 L
.53407 .48596 L
.5334 .49079 L
.53301 .49572 L
.5329 .50068 L
.53308 .50563 L
.53355 .51054 L
.53447 .51621 L
.53577 .52166 L
.53744 .52681 L
.53944 .53158 L
.54176 .53588 L
.54436 .53963 L
.54719 .54277 L
.55021 .54522 L
.5525 .54652 L
.55484 .54742 L
.55722 .54788 L
.5596 .5479 L
.56198 .54746 L
.56433 .54658 L
.56662 .54525 L
.56883 .54348 L
.57117 .541 L
.57337 .53803 L
.57538 .5346 L
.5772 .53073 L
.57879 .52649 L
.58013 .52193 L
.58121 .51709 L
.58202 .51205 L
.58255 .50685 L
Mistroke
.58278 .50158 L
.58267 .49508 L
.58227 .49002 L
.5816 .48507 L
.58067 .48029 L
.57949 .47574 L
.57807 .47146 L
.57643 .46752 L
.57459 .46395 L
.57354 .46223 L
.57245 .46064 L
Mfstroke
.02 w
.5775 .47 Mdot
.5 Mabswid
.57354 .46223 m
.57245 .46064 L
s
% Start of user PostScript
1.4708209 -0.75532938 1.4490042 -0.78723487 MAarrowhead1
% End of user PostScript
1 .612 0 r
.34084 .50507 m
.34115 .5056 L
.34149 .50611 L
.34223 .50703 L
.34307 .50786 L
.34399 .50859 L
.345 .50922 L
.34606 .50974 L
.34718 .51017 L
.34835 .5105 L
.34992 .5108 L
.35152 .51096 L
.35367 .51101 L
.3558 .5109 L
.35679 .51081 L
.35777 .51071 L
.35874 .51059 L
.3597 .51047 L
.36065 .51035 L
.36159 .51023 L
.36252 .51012 L
.36343 .51003 L
.36482 .50991 L
.3662 .50985 L
.36757 .50985 L
.36895 .50993 L
.37035 .51011 L
.37178 .5104 L
.37325 .51082 L
.3748 .51139 L
.37644 .51213 L
.37751 .51269 L
.37863 .51334 L
.37981 .51408 L
.38106 .51493 L
.38238 .51589 L
.3838 .51699 L
.38532 .51824 L
.38695 .51966 L
.38871 .52128 L
.39005 .52255 L
.39147 .52394 L
.39298 .52547 L
.39459 .52714 L
.3963 .52897 L
.39813 .53098 L
.40009 .53318 L
.40219 .5356 L
.40444 .53825 L
.40655 .54077 L
Mistroke
.40879 .54351 L
.41118 .54648 L
.41374 .54971 L
.41647 .55321 L
.4194 .55701 L
.42254 .56114 L
.42591 .56561 L
.42893 .56964 L
.43213 .57395 L
.43554 .57854 L
.43915 .58343 L
.44299 .58861 L
.44707 .59411 L
.45139 .5999 L
.45599 .60599 L
.46086 .61235 L
.46602 .61897 L
.47149 .62579 L
.47614 .63144 L
.48101 .63716 L
.48608 .64289 L
.49136 .6486 L
.49685 .6542 L
.50253 .65965 L
.50841 .66485 L
.51448 .66972 L
.52071 .67419 L
.52709 .67814 L
.53361 .68151 L
.54023 .68419 L
.54694 .6861 L
.55371 .68718 L
.5605 .68737 L
.56727 .68662 L
.57401 .68492 L
.58066 .68225 L
.5872 .67862 L
.59359 .67407 L
.5998 .66863 L
.6058 .66237 L
.61156 .65535 L
.61839 .64561 L
.62475 .63493 L
.63061 .62348 L
.63594 .61139 L
.64071 .59878 L
.6449 .58578 L
.64849 .57247 L
.65147 .55893 L
.65445 .54086 L
Mistroke
.65576 .52951 L
.65664 .51812 L
.6571 .5067 L
.65714 .49527 L
.65675 .48385 L
.65594 .47246 L
.6547 .4611 L
.65305 .4498 L
.65118 .43962 L
.64897 .42953 L
.64642 .41956 L
.64353 .40973 L
.64032 .4001 L
.63678 .39069 L
.63293 .38156 L
.6295 .3742 L
.62586 .3671 L
.62202 .36028 L
.618 .3538 L
.6138 .34767 L
.60943 .34194 L
.60491 .33663 L
.59928 .33087 L
.59347 .32584 L
.5875 .32157 L
.5814 .31811 L
.5752 .31548 L
.56892 .3137 L
.56259 .31276 L
.55625 .31264 L
.54992 .31332 L
.54362 .31475 L
.53738 .31687 L
.53123 .31964 L
.52518 .32298 L
.51925 .32681 L
.51346 .33106 L
.50781 .33566 L
.50233 .34054 L
.49702 .34563 L
.49188 .35086 L
.48692 .35618 L
.48215 .36154 L
.4766 .36801 L
.47133 .37441 L
.46631 .38067 L
.46154 .38677 L
.45702 .39265 L
.45274 .39831 L
.44868 .40372 L
Mistroke
.4453 .40827 L
.44208 .41262 L
.439 .41677 L
.43608 .42073 L
.43329 .42449 L
.43064 .42806 L
.42811 .43146 L
.4257 .43468 L
.4234 .43773 L
.42073 .44125 L
.41821 .44455 L
.41582 .44763 L
.41357 .4505 L
.41144 .45319 L
.40898 .45625 L
.40668 .45906 L
.40453 .46165 L
.40251 .46403 L
.40061 .46622 L
.39883 .46824 L
.39716 .4701 L
.39558 .47181 L
.39409 .47338 L
.3933 .4742 L
.39253 .47499 L
.39179 .47574 L
.39106 .47646 L
.39036 .47715 L
.39028 .47723 L
.3902 .47731 L
.39011 .47739 L
.39003 .47747 L
.39002 .47748 L
.39002 .47748 L
.39001 .47749 L
.39 .4775 L
.39 .4775 L
.39 .4775 L
.38999 .47751 L
.38998 .47752 L
.38998 .47752 L
.38997 .47753 L
.38989 .47761 L
.3898 .47769 L
.38972 .47777 L
.38964 .47784 L
.38889 .47856 L
.38815 .47924 L
.38744 .47989 L
.38676 .48051 L
Mistroke
.38609 .48109 L
.38508 .48196 L
.38412 .48275 L
.38319 .48349 L
.38231 .48416 L
.38146 .48479 L
.38065 .48536 L
.37951 .48612 L
.37842 .48678 L
.37739 .48737 L
.3764 .48788 L
.37545 .48833 L
.37454 .48872 L
.37365 .48905 L
.37256 .48939 L
.37151 .48966 L
.37048 .48987 L
.36946 .49001 L
.36846 .49011 L
.36746 .49015 L
.36647 .49016 L
.36526 .49012 L
.36404 .49003 L
.3628 .48991 L
.36155 .48976 L
.36028 .4896 L
.35899 .48944 L
.35768 .48928 L
.35636 .48915 L
.35502 .48905 L
.35366 .48899 L
.35211 .48901 L
.35057 .48912 L
.34905 .48935 L
.34757 .48971 L
.34616 .49022 L
.34482 .49088 L
.34359 .49171 L
.34249 .49269 L
.34174 .49355 L
.34109 .4945 L
.34054 .49552 L
.34011 .4966 L
.3398 .49773 L
.33961 .49889 L
.33956 .50006 L
.33963 .50124 L
.33976 .50207 L
.33995 .50288 L
.34021 .50368 L
Mistroke
.34053 .50445 L
.3409 .50518 L
.34133 .50588 L
.34182 .50655 L
.34235 .50717 L
.34294 .50774 L
.34356 .50827 L
.34417 .50871 L
.34481 .50911 L
.34548 .50947 L
.34617 .50979 L
.34688 .51007 L
.34762 .5103 L
.34836 .5105 L
.34971 .51077 L
.35108 .51093 L
.35247 .511 L
.35386 .511 L
.35525 .51094 L
.35662 .51083 L
.35798 .51068 L
.35932 .51052 L
.36064 .51035 L
.36194 .51019 L
.36322 .51005 L
.36491 .5099 L
.3666 .50984 L
.36827 .50988 L
.36997 .51005 L
.37171 .51039 L
.37352 .51091 L
.37509 .51151 L
.37676 .51229 L
.37855 .51329 L
.3805 .51454 L
.38265 .51609 L
.38504 .51801 L
.38773 .52037 L
.39079 .52327 L
.39272 .52521 L
.39383 .52635 L
.39499 .52757 L
Mfstroke
.02 w
.39 .4775 Mdot
.5 Mabswid
.39383 .52635 m
.39499 .52757 L
s
% Start of user PostScript
-2.1233569 0.52700456 -2.1001775 0.5513751 MAarrowhead1
% End of user PostScript
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[2]:=",
  ImageSize->{400, 400},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006@0001T2000`400?l00000o`00003oo`3ooonA
0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA
0?ooo`00^@3oool500000080oooo0P00003>0?ooo`00^`3oool01@000000oooo0?ooo`3oool00000
0080oooo00<000000?ooo`3oool0b`3oool00;/0oooo00D000000?ooo`3oool0oooo000000020?oo
o`030000003oool0oooo00@0oooo0`0000340?ooo`00/`3oool4000000@0oooo00D000000?ooo`3o
ool0oooo000000020?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0a03oool00;/0
oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00@0oooo00<000000?oo
o`3oool0a03oool00;X0oooo0P0000040?ooo`8000001`3oool00`000000oooo0?ooo`340?ooo`00
b@3oool00`000000oooo0?ooo`340?ooo`00b@3oool00`000000oooo0?ooo`340?ooo`00b@3oool0
0`000000oooo0?ooo`340?ooo`00b@3oool00`000000oooo0?ooo`340?ooo`00b@3oool00`000000
oooo0?ooo`340?ooo`00b@3oool00`000000oooo0?ooo`340?ooo`00b@3oool200000<D0oooo0039
0?ooo`030000003oool0oooo0<@0oooo00390?ooo`030000003oool0oooo0<@0oooo00390?ooo`03
0000003oool0oooo0<@0oooo00390?ooo`030000003oool0oooo0<@0oooo00390?ooo`030000003o
ool0oooo0<@0oooo00390?ooo`030000003oool0oooo0<@0oooo00390?ooo`030000003oool0oooo
0<@0oooo00390?ooo`030000003oool0oooo0<@0oooo00390?ooo`800000a@3oool00<T0oooo00<0
00000?ooo`3oool0a03oool00<T0oooo00<000000?ooo`3oool0a03oool00<T0oooo00<000000?oo
o`3oool0a03oool00<T0oooo00<000000?ooo`3oool0a03oool00<T0oooo00<000000?ooo`3oool0
a03oool00<T0oooo00<000000?ooo`3oool0a03oool00<T0oooo00<000000?ooo`3oool0a03oool0
0<T0oooo00<000000?ooo`3oool0a03oool00<T0oooo00<000000?ooo`3oool0a03oool00<T0oooo
0P0000350?ooo`00b@3oool00`000000oooo0?ooo`340?ooo`00b@3oool00`000000oooo0?ooo`34
0?ooo`00b@3oool00`000000oooo0?ooo`340?ooo`00b@3oool00`000000oooo0?ooo`340?ooo`00
b@3oool00`000000oooo0?ooo`340?ooo`00b@3oool00`000000oooo0?ooo`340?ooo`00b@3oool0
0`000000oooo0?ooo`340?ooo`00b@3oool00`000000oooo0?ooo`340?ooo`00b@3oool200000<D0
oooo00390?ooo`030000003oool0oooo0<@0oooo00390?ooo`030000003oool0oooo0<@0oooo0039
0?ooo`030000003oool0oooo0<@0oooo00390?ooo`030000003oool0oooo0<@0oooo00390?ooo`03
0000003oool0oooo0<@0oooo00390?ooo`030000003oool0oooo0<@0oooo00390?ooo`030000003o
ool0oooo0<@0oooo002e0?ooo`030000003oool0oooo0080oooo0P0000040?ooo`8000001`3oool0
0`000000oooo0?ooo`340?ooo`00]@3oool00`000000oooo0?ooo`070?ooo`040000003oool0oooo
000000H0oooo00<000000?ooo`3oool0a03oool00;D0oooo00<000000?ooo`3oool02P3oool00`00
0000oooo0?ooo`040?ooo`<00000a03oool00:d0oooo100000050?ooo`030000003oool0oooo00L0
oooo0P0000070?ooo`030000003oool0oooo0<@0oooo002c0?ooo`040000003oool0oooo000000T0
oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0=0?ooo`h0R03oZ@3oool00;<0oooo
100000090?ooo`<000001P3oool00`000000oooo0?ooo`070?ooo`P0R03o2@3oool508P0ojL0oooo
00390?ooo`030000003oool0oooo00@0oooo1P280?lB0?ooo`@0R03oY03oool00<T0oooo00@00000
0?ooo`3oool0oooo10280?lK0?ooo`<0R03oX@3oool00<T0oooo00<000000?ooo`280?l00P280?lQ
0?ooo`80R03oW`3oool00<P0oooo10280?lU0?ooo`80R03oW@3oool00<H0oooo10280?lY0?ooo`80
R03oV`3oool00<@0oooo10280?l00`3oool000000?ooo`0Y0?ooo`<0R03oV@3oool00<80oooo0`28
0?l40?ooo`800000:`3oool208P0oiP0oooo00300?ooo`<0R03o1P3oool00`000000oooo0?ooo`0/
0?ooo`80R03oUP3oool00;d0oooo10280?l80?ooo`030000003oool0oooo02h0oooo0P280?nD0?oo
o`00^`3oool408P0o`X0oooo00<000000?ooo`3oool0;`3oool208P0oi<0oooo002i0?ooo`@0R03o
303oool00`000000oooo0?ooo`0`0?ooo`80R03oTP3oool00;L0oooo10280?l>0?ooo`030000003o
ool0oooo0340oooo0P280?nA0?ooo`00]03oool408P0oa40oooo00<000000?ooo`3oool0<P3oool2
08P0oi00oooo002a0?ooo`@0R03o503oool00`000000oooo0?ooo`0c0?ooo`80R03oS`3oool00:h0
oooo10280?lG0?ooo`030000003oool0oooo03D0oooo00<0R03o0?ooo`3oool0S03oool00:/0oooo
10280?lJ0?ooo`800000=`3oool00`280?l0oooo0?ooo`2;0?ooo`00Y@3oool708P0oad0oooo00<0
00000?ooo`3oool0=`3oool208P0oh/0oooo002=0?oooaX0R03o8P3oool00`000000oooo0?ooo`0h
0?ooo`80R03oRP3oool00800oooo3`280?lj0?ooo`030000003oool0oooo03T0oooo0P280?n90?oo
o`00O03oool708P0odH0oooo00<000000?ooo`3oool0>P3oool208P0ohP0oooo001j0?ooo`@0R03o
B`3oool00`000000oooo0?ooo`0k0?ooo`80R03oQ`3oool007P0oooo0`280?m>0?ooo`030000003o
ool0oooo03`0oooo0P280?n60?ooo`00MP3oool308P0oe00oooo00<000000?ooo`3oool0?@3oool0
0`280?l0oooo0?ooo`240?ooo`00M03oool308P0oe80oooo00<000000?ooo`3oool0?P3oool00`28
0?l0oooo0?ooo`230?ooo`00L`3oool208P0oe@0oooo00<000000?ooo`3oool0?`3oool00`280?l0
oooo0?ooo`220?ooo`00L@3oool208P0oeH0oooo0P0000110?ooo`0308P0o`3oool0oooo0840oooo
001`0?ooo`80R03oE`3oool00`000000oooo0?ooo`110?ooo`80R03oP@3oool006l0oooo00<0R03o
0?ooo`3oool0E`3oool00`000000oooo0?ooo`120?ooo`80R03oP03oool006d0oooo0P280?mJ0?oo
o`030000003oool0oooo04<0oooo0P280?mo0?ooo`00K03oool208P0oe/0oooo00<000000?ooo`3o
ool0A03oool00`280?l0oooo0?ooo`1m0?ooo`00J`3oool208P0oe`0oooo00<000000?ooo`3oool0
A@3oool00`280?l0oooo0?ooo`1l0?ooo`00JP3oool208P0oed0oooo00<000000?ooo`3oool07P3o
ool20?Wo02H0oooo00<0R03o0?ooo`3oool0N`3oool006T0oooo00<0R03o0?ooo`3oool0G@3oool0
0`000000oooo0?ooo`0L0?ooo`<0nOl0:03oool00`280?l0oooo0?ooo`1j0?ooo`00J03oool00`28
0?l0oooo0?ooo`1N0?ooo`030000003oool0oooo01X0oooo103io`0Y0?ooo`80R03oN`3oool006L0
oooo00<0R03o0?ooo`3oool0G`3oool2000001T0oooo1P3io`0Z0?ooo`80R03oNP3oool006H0oooo
00<0R03o0?ooo`3oool0H03oool00`000000oooo0?ooo`0E0?ooo`P0nOl0;03oool208P0ogT0oooo
001U0?ooo`0308P0o`3oool0oooo0640oooo00<000000?ooo`3oool04`3oool90?Wo02h0oooo00<0
R03o0?ooo`3oool0M`3oool006@0oooo0P280?mS0?ooo`030000003oool0oooo0140oooo3@3io`0]
0?ooo`0308P0o`3oool0oooo07H0oooo001S0?ooo`80R03oI03oool00`000000oooo0?ooo`0=0?oo
oa80nOl0;@3oool00`280?l0oooo0?ooo`1e0?ooo`00H`3oool00`280?l0oooo0?ooo`1S0?ooo`03
0000003oool0oooo00T0oooo603io`0/0?ooo`0308P0o`3oool0oooo07@0oooo001R0?ooo`0308P0
o`3oool0oooo06@0oooo00<000000?ooo`3oool01`3oool30?Wo00d0oooo2`3io`0/0?ooo`0308P0
o`3oool0oooo07<0oooo001Q0?ooo`80R03oIP3oool00`000000oooo0?ooo`050?ooo`80nOl05`3o
ool30?Wo02h0oooo0P280?mc0?ooo`00H@3oool00`280?l0oooo0?ooo`1L0?ooo`8000001`3oool0
0`000000oooo0?ooo`030?ooo`80nOl06`3oool30?Wo02d0oooo00<0R03o0?ooo`3oool0L@3oool0
0600oooo00<0R03o0?ooo`3oool0G03oool010000000oooo0?ooo`0000060?ooo`040000003oool0
oooo0?ooo`80nOl07`3oool20?Wo02`0oooo0P280?mb0?ooo`00G`3oool00`280?l0oooo0?ooo`1P
0?ooo`030000003oool0oooo00@0oooo0P0000020?Wo02<0oooo0P3io`0[0?ooo`80R03oL@3oool0
05h0oooo0P280?mI0?ooo`@000000`3oool2000000L0oooo0P3io`0V0?ooo`80nOl0:`3oool208P0
og00oooo001M0?ooo`80R03oH@3oool00`000000oooo0?ooo`050?ooo`80nOl0:03oool30?Wo02X0
oooo0P280?m_0?ooo`00G@3oool00`280?l0oooo0?ooo`1P0?ooo`<000000`3oool20?Wo00030?oo
o`000000oooo02T0oooo0P3io`0Z0?ooo`80R03oKP3oool005`0oooo0P280?mV0?ooo`<0nOl00P3o
ool00`000000oooo0?ooo`0Y0?ooo`80nOl0:P3oool208P0ofd0oooo001L0?ooo`0308P0o`3oool0
oooo06@0oooo0P3io`040?ooo`030000003oool0oooo02X0oooo0P3io`0Z0?ooo`80R03oK03oool0
05/0oooo0P280?mT0?ooo`<0nOl01@3oool00`000000oooo0?ooo`0[0?ooo`80nOl0:P3oool208P0
of/0oooo001K0?ooo`0308P0o`3oool0oooo0680oooo0P3io`070?ooo`030000003oool0oooo02`0
oooo0P3io`0Z0?ooo`80R03oJP3oool005X0oooo0P280?mS0?ooo`80nOl0203oool00`000000oooo
0?ooo`0]0?ooo`80nOl0:P3oool208P0ofT0oooo001J0?ooo`0308P0o`3oool0oooo0640oooo00<0
nOl00?ooo`3oool0203oool00`000000oooo0?ooo`0^0?ooo`80nOl0:`3oool00`280?l0oooo0?oo
o`1V0?ooo`00F@3oool208P0of40oooo0P3io`0;0?ooo`800000<03oool00`3io`00oooo0?ooo`0Z
0?ooo`0308P0o`3oool0oooo06D0oooo001I0?ooo`0308P0o`3oool0oooo05l0oooo00<0nOl00?oo
o`3oool02`3oool00`000000oooo0?ooo`0`0?ooo`030?Wo003oool0oooo02X0oooo00<0R03o0?oo
o`3oool0I03oool005P0oooo0P280?mO0?ooo`80nOl03P3oool00`000000oooo0?ooo`0`0?ooo`80
nOl0;03oool208P0of@0oooo001H0?ooo`0308P0o`3oool0oooo05`0oooo0P3io`0@0?ooo`030000
003oool0oooo0340oooo0P3io`0/0?ooo`80R03oH`3oool005L0oooo0P280?mM0?ooo`80nOl04@3o
ool00`000000oooo0?ooo`0b0?ooo`80nOl0;03oool208P0of80oooo001F0?ooo`80R03oG03oool2
0?Wo01<0oooo00<000000?ooo`3oool0<`3oool00`3io`00oooo0?ooo`0[0?ooo`80R03oH@3oool0
05H0oooo0P280?mJ0?ooo`80nOl05@3oool00`000000oooo0?ooo`0d0?ooo`030?Wo003oool0oooo
02/0oooo0P280?mP0?ooo`00E@3oool208P0oeT0oooo0P3io`0G0?ooo`030000003oool0oooo00h0
oooo2P3o0?lL0?ooo`030?Wo003oool0oooo02`0oooo0P280?mO0?ooo`00E@3oool208P0oeL0oooo
0P3io`0I0?ooo`030000003oool0oooo00X0oooo1P3o0?l70?ooo`@0o`3o6P3oool00`3io`00oooo
0?ooo`0]0?ooo`0308P0o`3oool0oooo05`0oooo001E0?ooo`0308P0o`3oool0oooo05@0oooo0`3i
o`0J0?ooo`8000002@3oool30?l0o`l0oooo0`3o0?lH0?ooo`80nOl0;`3oool208P0oe`0oooo001D
0?ooo`80R03oD`3oool40?Wo01`0oooo00<000000?ooo`3oool01P3oool30?l0oa<0oooo0`3o0?lG
0?ooo`80nOl0;`3oool208P0oe/0oooo001D0?ooo`0308P0o`3oool0oooo04l0oooo103io`0O0?oo
o`030000003oool0oooo00@0oooo0`3o0?lH0?ooo`80o`3o5@3oool20?Wo0300oooo0P280?mJ0?oo
o`00D`3oool208P0odl0oooo0`3io`0R0?ooo`030000003oool0oooo00<0oooo0P3o0?lL0?ooo`80
o`3o503oool20?Wo0300oooo0P280?mI0?ooo`00D`3oool00`280?l0oooo0?ooo`150?ooo`T0nOl0
9@3oool00`000000oooo0?ooo`020?ooo`80o`3o303oool809Oo00X0oooo0P3o0?lD0?ooo`80nOl0
<03oool208P0oeP0oooo001C0?ooo`0308P0o`3oool0oooo0300oooo5P3io`0]0?ooo`030000003o
ool0oooo0080o`3o2@3oool409Oo00T0oi`00`2Go`080?ooo`80o`3o503oool20?Wo0340oooo0P28
0?mF0?ooo`00DP3oool00`280?l0oooo0?ooo`0/0?ooo`H0nOl0@P3oool010000000oooo0?l0o`3o
0?l80?ooo`<0Uol000<0oooo0?nL003oW0002@3oool30?nL0080Uol01`3oool20?l0oa<0oooo0P3i
o`0b0?ooo`80R03oE@3oool00580oooo00<0R03o0?ooo`3oool0:P3oool30?Wo04L0oooo00<00000
0?l0o`3o0?l0203oool209Oo00<0oi`03P3oool20?nL0080Uol01P3oool20?l0oa<0oooo0P3io`0b
0?ooo`80R03oE03oool00540oooo0P280?lZ0?ooo`<0nOl0B@3oool20?l0o`L0oooo0P2Go`020?nL
01<0oooo0P3oW0000`2Go`00oooo0?ooo`040?ooo`80o`3o4P3oool20?Wo03<0oooo0P280?mC0?oo
o`00D@3oool00`280?l0oooo0?ooo`0W0?ooo`<0nOl0B@3oool20?l0o`030000003oool0oooo00D0
oooo00<0Uol00?nL003oW0005`3oool00`3oW000Uol009Oo00050?ooo`030?l0o`3oool0oooo0140
oooo0P3io`0c0?ooo`80R03oDP3oool00540oooo00<0R03o0?ooo`3oool09@3oool30?Wo04X0oooo
0P3o0?l00`3oool00000000000040?ooo`0309Oo003oW000oi`001X0oooo00<0oi`009Oo002Go`00
1@3oool00`3o0?l0oooo0?ooo`0A0?ooo`030?Wo003oool0oooo03<0oooo00<0R03o0?ooo`3oool0
C`3oool00500oooo0P280?lV0?ooo`80nOl0B`3oool20?l0o`80oooo00<000000?ooo`3oool00P3o
ool00`2Go`00oi`00?ooo`090?ooo`/0P03o203oool20?nL000309Oo003oool0oooo00<0oooo00<0
o`3o0?ooo`3oool0403oool20?Wo03D0oooo00<0R03o0?ooo`3oool0CP3oool00500oooo00<0R03o
0?ooo`3oool0903oool20?Wo04/0oooo0P3o0?l30?ooo`030000003oool0oooo0080Uol000<0oi`0
0?ooo`3oool01`3oool40800o`L0oooo10200?l80?ooo`030?nL002Go`00oooo00<0oooo0P3o0?lB
0?ooo`030?Wo003oool0oooo03@0oooo00<0R03o0?ooo`3oool0C@3oool004l0oooo0P280?lU0?oo
o`030?Wo003oool0oooo04X0oooo0P3o0?l40?ooo`050000003oool0Uol009Oo003oW000203oool3
0800o`h0oooo0P200?l70?ooo`030?nL002Go`00oooo00<0oooo0P3o0?lA0?ooo`80nOl0=P3oool2
08P0odd0oooo001?0?ooo`0308P0o`3oool0oooo02<0oooo00<0nOl00?ooo`3oool0BP3oool20?l0
o`D0oooo00@0000009Oo002Go`00oi`01`3oool30800oa80oooo00<0P03o0?ooo`3oool01@3oool0
0`3oW000oooo0?ooo`030?ooo`030?l0o`3oool0oooo0100oooo00<0nOl00?ooo`3oool0=@3oool2
08P0od`0oooo001?0?ooo`0308P0o`3oool0oooo0280oooo00<0nOl00?ooo`3oool0BP3oool20?l0
o`H0oooo00<0Uol00?nL003oW0001P3oool20800oaH0oooo0P200?l60?ooo`030?nL003oool0oooo
00<0oooo00<0o`3o0?ooo`3oool03`3oool20?Wo03L0oooo0P280?m;0?ooo`00CP3oool208P0ob<0
oooo00<0nOl00?ooo`3oool0BP3oool20?l0o`H0oooo00<0Uol00?nL003oool01P3oool20800oaP0
oooo0P200?l60?ooo`030?nL003oool0oooo0080oooo0P3o0?lA0?ooo`030?Wo003oool0oooo03D0
oooo0P280?m;0?ooo`00CP3oool00`280?l0oooo0?ooo`0Q0?ooo`80nOl0B`3oool20?l0o`H0oooo
00<0Uol00?nL000000001@3oool20800oa`0oooo00<0P03o0?ooo`3oool00`3oool00`3oW000Uol0
0?ooo`030?ooo`030?l0o`3oool0oooo00l0oooo0P3io`0g0?ooo`80R03oBP3oool004h0oooo00<0
R03o0?ooo`3oool08@3oool00`3io`00oooo0?ooo`190?ooo`80o`3o1P3oool0102Go`00oi`00?oo
o`0000040?ooo`80P03o7P3oool00`200?l0oooo0?ooo`030?ooo`030?nL002Go`00oooo0080oooo
0P3o0?lA0?ooo`030?Wo003oool0oooo03H0oooo0P280?m90?ooo`00CP3oool00`280?l0oooo0?oo
o`0P0?ooo`030?Wo003oool0oooo04T0oooo0P3o0?l60?ooo`0409Oo003oW000oooo0?ooo`800000
0P3oool20800ob00oooo00<0P03o0?ooo`3oool00P3oool00`3oW000Uol00?ooo`030?ooo`030?l0
o`3oool0oooo00l0oooo0P3io`0h0?ooo`80R03oB03oool004d0oooo0P280?lQ0?ooo`80nOl0BP3o
ool20?l0o`H0oooo00<0Uol00?nL003oool00P3oool00`000000oooo0?ooo`020800ob80oooo00<0
P03o0?ooo`3oool00P3oool00`3oW000Uol00?ooo`020?ooo`80o`3o4@3oool00`3io`00oooo0?oo
o`0g0?ooo`80R03oA`3oool004d0oooo00<0R03o0?ooo`3oool07`3oool20?Wo04X0oooo0P3o0?l6
0?ooo`0309Oo003oW000oooo00<0oooo00@000000?ooo`200?l0P03o903oool00`200?l0oooo0?oo
o`020?ooo`030?nL002Go`00oooo0080oooo0P3o0?l@0?ooo`030?Wo003oool0oooo03P0oooo0P28
0?m60?ooo`00C@3oool00`280?l0oooo0?ooo`0N0?ooo`80nOl0BP3oool20?l0o`H0oooo00<0Uol0
0?nL003oool0103oool00`000000P03o0800o`0U0?ooo`80P03o0`3oool00`3oW000Uol00?ooo`03
0?ooo`030?l0o`3oool0oooo00l0oooo00<0nOl00?ooo`3oool0=`3oool208P0odH0oooo001<0?oo
o`80R03o803oool20?Wo04T0oooo0P3o0?l60?ooo`0309Oo003oW000oooo00D0oooo0P200?lW0?oo
o`80P03o0`3oool00`3oW000Uol00?ooo`020?ooo`80o`3o403oool00`3io`00oooo0?ooo`0h0?oo
o`80R03oA@3oool004`0oooo00<0R03o0?ooo`3oool07P3oool20?Wo04T0oooo0P3o0?l60?ooo`80
Uol000<0oi`00?ooo`3oool00`3oool20800obT0oooo00<0P03o0?ooo`3oool00P3oool00`3oW000
oooo0?ooo`020?ooo`030?l0o`3oool0oooo00l0oooo00<0nOl00?ooo`3oool0>03oool00`280?l0
oooo0?ooo`130?ooo`00C03oool00`280?l0oooo0?ooo`0M0?ooo`80nOl0B@3oool00`3o0?l0oooo
0?ooo`050?ooo`80Uol000<0oi`00?ooo`3oool00`3oool20800o`030000003oool0oooo02L0oooo
0P200?l30?ooo`030?nL002Go`00oooo0080oooo0P3o0?l@0?ooo`030?Wo003oool0oooo03T0oooo
00<0R03o0?ooo`3oool0@P3oool004`0oooo00<0R03o0?ooo`3oool07@3oool20?Wo04P0oooo00<0
o`3o0?ooo`3oool01@3oool209Oo00030?nL003oool0oooo00<0oooo0P200?l00`3oool000000?oo
o`0Y0?ooo`030800o`3oool0oooo0080oooo00<0oi`00?ooo`3oool00P3oool00`3o0?l0oooo0?oo
o`0>0?ooo`80nOl0>P3oool208P0od<0oooo001;0?ooo`80R03o7P3oool20?Wo04H0oooo0P000002
0?l0o`<0oooo0P0000020?ooo`0409Oo003oW0000000000000<0oooo0P200?l20?ooo`030000003o
ool0oooo02P0oooo0P200?l30?ooo`030?nL002Go`00oooo0080oooo0P3o0?l@0?ooo`030?Wo003o
ool0oooo03T0oooo00<0R03o0?ooo`3oool0@@3oool004/0oooo00<0R03o0?ooo`3oool07@3oool0
0`3io`00oooo0?ooo`150?ooo`030000003o0?l0o`3o00L0oooo00<0Uol00?nL000000000P3oool0
10000000oooo0800o`200?l30?ooo`030000003oool0oooo02T0oooo00<0P03o0?ooo`3oool00P3o
ool00`3oW000oooo0?ooo`020?ooo`030?l0o`3oool0oooo00h0oooo0P3io`0j0?ooo`80R03o@P3o
ool004/0oooo00<0R03o0?ooo`3oool07@3oool00`3io`00oooo0?ooo`150?ooo`80o`3o203oool0
0`3oW000oooo0?ooo`020?ooo`030000003oool0P03o00@0oooo0`00000Z0?ooo`060800o`3oool0
oooo0?ooo`3oW000Uol00`3oool20?l0oa00oooo00<0nOl00?ooo`3oool0>@3oool00`280?l0oooo
0?ooo`100?ooo`00B`3oool00`280?l0oooo0?ooo`0L0?ooo`030?Wo003oool0oooo0400oooo1000
00001@3oool0o`3o0?l0o`3oool0000000H0oooo00@0oi`00?ooo`3oool0oooo0P0000000`3oool0
P03o0?ooo`040?ooo`030000003oool0oooo02X0oooo0P200?l30?ooo`030?nL003oool0oooo0080
oooo00<0o`3o0?ooo`3oool03P3oool20?Wo03/0oooo00<0R03o0?ooo`3oool0?`3oool004X0oooo
0P280?lN0?ooo`030?Wo003oool0oooo04@0oooo0P3o0?l010000000oooo0?ooo`0000040?ooo`03
09Oo003oW000oooo0080oooo00@000000?ooo`200?l0P03o1@3oool00`000000oooo0?ooo`0[0?oo
o`060800o`3oool0oooo0?ooo`3oW000Uol00`3oool00`3o0?l0oooo0?ooo`0>0?ooo`80nOl0>`3o
ool00`280?l0oooo0?ooo`0o0?ooo`00BP3oool00`280?l0oooo0?ooo`0L0?ooo`030?Wo003oool0
oooo04@0oooo0P3o0?l20?ooo`800000103oool00`2Go`00oi`00?ooo`030?ooo`80000000<0P03o
0?ooo`3oool0103oool00`000000oooo0?ooo`0[0?ooo`80P03o0`3oool00`3oW000oooo0?ooo`02
0?ooo`030?l0o`3oool0oooo00h0oooo0P3io`0k0?ooo`0308P0o`3oool0oooo03h0oooo001:0?oo
o`0308P0o`3oool0oooo01`0oooo00<0nOl00?ooo`3oool0@`3oool20?l0o`P0oooo00<0Uol00?oo
o`3oW0001@3oool00`200?l0oooo0?ooo`050?ooo`030000003oool0oooo02`0oooo00H0P03o0?oo
o`3oool0oooo0?nL002Go`030?ooo`030?l0o`3oool0oooo00h0oooo0P3io`0k0?ooo`80R03o?`3o
ool004X0oooo00<0R03o0?ooo`3oool06`3oool20?Wo04@0oooo0P3o0?l80?ooo`0309Oo003oool0
oi`000D0oooo0P200?l70?ooo`030000003oool0oooo02`0oooo0P200?l30?ooo`040?nL003oool0
oooo0?ooo`80o`3o403oool00`3io`00oooo0?ooo`0j0?ooo`0308P0o`3oool0oooo03d0oooo0019
0?ooo`80R03o7@3oool20?Wo04<0oooo0P3o0?l80?ooo`80Uol000<0oi`00?ooo`3oool00`3oool2
0800o`P0oooo00<000000?ooo`3oool0;@3oool01P200?l0oooo0?ooo`3oool0oi`009Oo00<0oooo
00<0o`3o0?ooo`3oool03P3oool00`3io`00oooo0?ooo`0j0?ooo`0308P0o`3oool0oooo03d0oooo
00190?ooo`80R03o7@3oool00`3io`00oooo0?ooo`100?ooo`80o`3o2@3oool209Oo00030?nL003o
ool0oooo00@0oooo00<0P03o0?ooo`3oool01`3oool00`000000oooo0?ooo`0]0?ooo`060800o`3o
ool0oooo0?ooo`3oW000Uol00`3oool00`3o0?l0oooo0?ooo`0>0?ooo`80nOl0>`3oool208P0och0
oooo00190?ooo`0308P0o`3oool0oooo01/0oooo0P3io`110?ooo`80o`3o2P3oool00`2Go`00oi`0
0?ooo`050?ooo`030800o`3oool0oooo00P0oooo00<000000?ooo`3oool0;@3oool20800o`80oooo
00<0oi`009Oo003oool00`3oool00`3o0?l0oooo0?ooo`0>0?ooo`030?Wo003oool0oooo03T0oooo
0`280?lm0?ooo`00B03oool208P0oad0oooo0P3io`100?ooo`80o`3o1`3oool01@2Go`00oooo0?oo
o`2Go`00oi`000H0oooo0P200?l:0?ooo`030000003oool0oooo02h0oooo00H0P03o0?ooo`3oool0
oooo0?nL002Go`030?ooo`030?l0o`3oool0oooo00h0oooo0P3io`0k0?ooo`80R03o?@3oool004P0
oooo0P280?lM0?ooo`030?Wo003oool0oooo03d0oooo0`3o0?l70?ooo`80Uol000<0oooo09Oo003o
W0001`3oool00`200?l0oooo0?ooo`090?ooo`800000;`3oool01P200?l0oooo0?ooo`3oool0oi`0
09Oo00<0oooo00<0o`3o0?ooo`3oool03P3oool20?Wo03/0oooo0`280?ll0?ooo`00B03oool208P0
oa`0oooo0P3io`0m0?ooo`<0o`3o2@3oool409Oo00030?nL003oool0oooo00@0oooo00<0P03o0?oo
o`3oool02P3oool00`000000oooo0?ooo`0_0?ooo`060800o`3oool0oooo0?ooo`3oW000Uol00P3o
ool20?l0oa00oooo00<0nOl00?ooo`3oool0>@3oool408P0oc/0oooo00180?ooo`80R03o703oool0
0`3io`00oooo0?ooo`0k0?ooo`<0o`3o2@3oool409Oo00030?nL003oool0oooo00@0oooo0P200?l<
0?ooo`030000003oool0oooo02l0oooo00H0P03o0?ooo`3oool0oooo0?nL002Go`030?ooo`030?l0
o`3oool0oooo00h0oooo00<0nOl00?ooo`3oool0>@3oool508P0ocX0oooo00180?ooo`0308P0o`3o
ool0oooo01/0oooo00<0nOl00?ooo`3oool0>03oool40?l0o`/0oooo0`2Go`000`3oW000oooo0?oo
o`050?ooo`030800o`3oool0oooo00/0oooo00<000000?ooo`3oool0;`3oool20800o`<0oooo00D0
oi`00?ooo`3oool0oooo0?l0o`0@0?ooo`80nOl0>P3oool608P0ocT0oooo00180?ooo`0308P0o`3o
ool0oooo01/0oooo00<0nOl00?ooo`3oool0=@3oool40?l0o`d0oooo0`2Go`000`3oW000oooo0?oo
o`050?ooo`80P03o3@3oool00`000000oooo0?ooo`0`0?ooo`060800o`3oool0oooo0?ooo`3oW000
Uol00`3oool00`3o0?l0oooo0?ooo`0=0?ooo`80nOl0>`3oool508P0ocT0oooo00180?ooo`0308P0
o`3oool0oooo01/0oooo00<0nOl00?ooo`3oool08P3ooolD0?l0o`l0oooo0`2Go`000`3oW000oooo
0?ooo`050?ooo`80P03o3P3oool00`000000oooo0?ooo`0`0?ooo`80P03o0P3oool00`3oW000Uol0
0?ooo`020?ooo`030?l0o`3oool0oooo00h0oooo0P3io`0j0?ooo`H0R03o>03oool004P0oooo00<0
R03o0?ooo`3oool06P3oool20?Wo0200oooo1@3o0?lR0?ooo`<0Uol000<0oi`009Oo002Go`001@2G
o`000`200?l0oooo0?ooo`0=0?ooo`030000003oool0oooo0300oooo0P200?l30?ooo`050?nL003o
ool0oooo0?ooo`3o0?l0403oool20?Wo03X0oooo1`280?lg0?ooo`00A`3oool208P0oa`0oooo00<0
nOl00?ooo`3oool07@3oool20?l0obH0oooo0`2Go`000`3oW000Uol009Oo000509Oo00030800o`3o
ool0oooo00h0oooo00<000000?ooo`3oool0<@3oool01@200?l0oooo0?ooo`3oool0oi`000<0oooo
00<0o`3o0?ooo`3oool03P3oool20?Wo03X0oooo20280?lf0?ooo`00A`3oool00`280?l0oooo0?oo
o`0K0?ooo`030?Wo003oool0oooo01/0oooo0P3o0?lX0?ooo`<0Uol000<0oi`009Oo002Go`00102G
o`000`3oool0P03o0?ooo`0?0?ooo`030000003oool0oooo0340oooo00H0P03o0?ooo`3oool0oooo
0?nL002Go`030?ooo`030?l0o`3oool0oooo00h0oooo00<0nOl00?ooo`3oool0>03oool908P0ocD0
oooo00170?ooo`0308P0o`3oool0oooo01X0oooo0P3io`0K0?ooo`80o`3o:@3oool309Oo00030?nL
002Go`00Uol000<0Uol00P3oool20800oa00oooo0P00000b0?ooo`80P03o0P3oool00`3oW000Uol0
0?ooo`020?ooo`030?l0o`3oool0oooo00h0oooo00<0nOl00?ooo`3oool0>@3oool908P0oc@0oooo
00170?ooo`0308P0o`3oool0oooo01X0oooo0P3io`0J0?ooo`80o`3o:P3oool209Oo00030?nL002G
o`00Uol000<0Uol00`3oool00`200?l0oooo0?ooo`0?0?ooo`030000003oool0oooo0340oooo0P20
0?l30?ooo`050?nL003oool0oooo0?ooo`3o0?l0403oool20?Wo03X0oooo10280?l00`3oool0R03o
08P0o`0208P0oc@0oooo00170?ooo`0308P0o`3oool0oooo01X0oooo00<0nOl00?ooo`3oool0603o
ool20?l0obX0oooo0P2Go`000`3oW000Uol009Oo000209Oo00@0oooo0P200?lA0?ooo`030000003o
ool0oooo0380oooo00D0P03o0?ooo`3oool0oooo0?nL00030?ooo`030?l0o`3oool0oooo00h0oooo
0P3io`0j0?ooo`<0R03o103oool308P0oc<0oooo00160?ooo`80R03o703oool00`3io`00oooo0?oo
o`0H0?ooo`030?l0o`3oool0oooo02P0oooo0`2Go`000`3oW000Uol009Oo00060?ooo`030800o`3o
ool0oooo0100oooo00<000000?ooo`3oool0<P3oool20800o`80oooo00@0oi`009Oo003oool0oooo
0P3o0?l@0?ooo`030?Wo003oool0oooo03P0oooo10280?l50?ooo`80R03o<P3oool004H0oooo00<0
R03o0?ooo`3oool06`3oool00`3io`00oooo0?ooo`0G0?ooo`030?l0o`3oool0oooo02T0oooo0P2G
o`000`3oW000Uol00?ooo`060?ooo`80P03o4P3oool00`000000oooo0?ooo`0b0?ooo`80P03o0P3o
ool00`3oW000Uol00?ooo`020?ooo`030?l0o`3oool0oooo00h0oooo00<0nOl00?ooo`3oool0>03o
ool408P0ocT0oooo00160?ooo`0308P0o`3oool0oooo01/0oooo00<0nOl00?ooo`3oool05P3oool0
0`3o0?l0oooo0?ooo`0Y0?ooo`80Uol000<0oi`009Oo003oool01P3oool20800oa<0oooo00<00000
0?ooo`3oool0<P3oool20800o`<0oooo00D0oi`00?ooo`3oool0oooo0?l0o`0@0?ooo`030?Wo003o
ool0oooo03T0oooo0`280?li0?ooo`00AP3oool00`280?l0oooo0?ooo`0J0?ooo`80nOl05`3oool0
0`3o0?l0oooo0?ooo`0Y0?ooo`80Uol000<0oi`00?ooo`3oool01`3oool20800oa<0oooo00<00000
0?ooo`3oool0<`3oool01@200?l0oooo0?ooo`3oool0oi`000<0oooo00<0o`3o0?ooo`3oool03P3o
ool20?Wo03X0oooo00<0R03o0?ooo`280?l0>@3oool004H0oooo00<0R03o0?ooo`3oool06P3oool0
0`3io`00oooo0?ooo`0E0?ooo`80o`3o:P3oool209Oo00030?nL003oool0oooo00L0oooo0P200?lD
0?ooo`030000003oool0oooo03<0oooo00D0P03o0?ooo`3oool0oooo0?nL00030?ooo`030?l0o`3o
ool0oooo00l0oooo00<0nOl00?ooo`3oool0>03oool010280?l0oooo08P0o`280?lh0?ooo`00AP3o
ool00`280?l0oooo0?ooo`0J0?ooo`030?Wo003oool0oooo01D0oooo00<0o`3o0?ooo`3oool0:03o
ool0102Go`00oooo0?ooo`3oW0070?ooo`@0P03o503oool00`000000oooo0?ooo`0c0?ooo`80P03o
0P3oool0103oW000oooo0?ooo`3oool20?l0oa00oooo00<0nOl00?ooo`3oool0>P3oool208P0ocP0
oooo00150?ooo`80R03o703oool00`3io`00oooo0?ooo`0D0?ooo`80o`3o:@3oool0102Go`00oooo
0?ooo`3oW0070?ooo`D0P03o503oool00`000000oooo0?ooo`0c0?ooo`80P03o0P3oool00`3oW000
oooo0?ooo`020?ooo`030?l0o`3oool0oooo00h0oooo0P3io`0l0?ooo`0308P0o`3oool0oooo03H0
oooo00150?ooo`80R03o703oool00`3io`00oooo0?ooo`0D0?ooo`80o`3o:03oool0102Go`00oooo
0?ooo`3oW0070?ooo`L0P03o4`3oool2000003@0oooo0P200?l20?ooo`030?nL002Go`00oooo0080
oooo00<0o`3o0?ooo`3oool03P3oool20?Wo03`0oooo00<0R03o0?ooo`3oool0=P3oool004D0oooo
0P280?lL0?ooo`030?Wo003oool0oooo01<0oooo0P3o0?lX0?ooo`0409Oo003oool0oooo0?nL00P0
oooo1`200?lC0?ooo`030000003oool0oooo0100oooo1`3o0?@M0?ooo`050800o`3oool0oooo0?nL
002Go`000`3oool00`3o0?l0oooo0?ooo`0>0?ooo`80nOl0?03oool00`280?l0oooo0?ooo`0f0?oo
o`00A@3oool208P0oa/0oooo0P3io`0E0?ooo`80o`3o8`3oool309Oo00030?ooo`2Go`00oooo0080
oooo00<0oi`00?ooo`3oool01P3oool70800oa<0oooo00<000000?ooo`3oool03`3oool20?l0m0D0
oooo0P3o0?@L0?ooo`050800o`3oool0oooo0?nL002Go`000`3oool00`3o0?l0oooo0?ooo`0?0?oo
o`030?Wo003oool0oooo03X0oooo0P280?lg0?ooo`00A@3oool00`280?l0oooo0?ooo`0J0?ooo`03
0?Wo003oool0oooo01@0oooo00<0o`3o0?ooo`3oool08@3oool609Oo0080oooo00<0oi`00?ooo`3o
ool0203oool50800oa@0oooo00<000000?ooo`3oool03P3oool20?l0m0L0oooo0P3o0?@K0?ooo`05
0800o`3oool0oooo0?ooo`3oW0000`3oool20?l0oa00oooo00<0nOl00?ooo`3oool0>P3oool208P0
ocL0oooo00140?ooo`<0R03o6`3oool00`3io`00oooo0?ooo`0D0?ooo`030?l0o`3oool0oooo0200
oooo1`2Go`000`3oool0oi`00?ooo`0;0?ooo`<0P03o5@3oool00`000000oooo0?ooo`0=0?ooo`03
0?l0m03oool0oooo00P0oooo0P3o0?@J0?ooo`060800o`3oool0oooo0?ooo`3oW000Uol00P3oool2
0?l0oa00oooo00<0nOl00?ooo`3oool0>P3oool208P0ocL0oooo00130?ooo`D0R03o6P3oool00`3i
o`00oooo0?ooo`0B0?ooo`<0o`3o8P3oool709Oo00030?nL003oool0oooo00X0oooo0P200?lG0?oo
o`030000003oool0oooo00`0oooo0P3o0?@:0?ooo`@0o`3d603oool20800o`80oooo00@0oi`009Oo
003oool0oooo0P3o0?l@0?ooo`030?Wo003oool0oooo03X0oooo0P280?lg0?ooo`001`3oool50000
0080oooo0P00000V0?ooo`030000003oool0oooo0080oooo0P0000040?ooo`03000000280?l0R03o
00D0R03o6@3oool00`3io`00oooo0?ooo`060?ooo`8000002@3oool50?l0oaT0oooo100000030?oo
o`030000002Go`00Uol000@0Uol000<0oi`00?ooo`3oool02`3oool20800oaL0oooo00<000000?oo
o`3oool0303oool00`3o0?@0oooo0?ooo`090?ooo`D0o`3d203oool4000000<0oooo0P0000040?oo
o`8000000P200?l20?ooo`030?nL002Go`00oooo0080oooo00<0o`3o0?ooo`3oool03P3oool20?Wo
00`0oooo0P00000Y0?ooo`030000003oool0oooo0080oooo00<0R03o0000003oool00`3oool20000
02@0oooo1@0000020?ooo`8000000`3oool000T0oooo00D000000?ooo`3oool0oooo000000020?oo
o`030000003oool0oooo02<0oooo00<000000?ooo`3oool01`3oool00`000000oooo08P0o`0608P0
oaL0oooo0`3io`070?ooo`040000003oool0oooo000000L0oooo1`3o0?lC0?ooo`@0Uol000<0oooo
0000003oool00P3oool:09Oo00030?nL00000000oooo00/0oooo00<0P03o0?ooo`3oool05P3oool0
0`000000oooo0?ooo`0;0?ooo`80o`3d2P3oool70?l0m0L0oooo00<000000?ooo`3oool02@3oool0
0`000000oooo0?ooo`020800o`80oooo00<0oi`009Oo003oool00P3oool00`3o0?l0oooo0?ooo`0>
0?ooo`80nOl02`3oool010000000oooo0?ooo`00000X0?ooo`030000003oool0oooo0080oooo00<0
R03o0?ooo`3oool00P3oool010000000oooo0?ooo`00000U0?ooo`050000003oool0oooo0?ooo`00
00000P3oool100000040oooo0@3oool000T0oooo00D000000?ooo`3oool0oooo000000020?ooo`03
0000003oool0oooo02<0oooo00<000000?ooo`3oool02@3oool708P0oaH0oooo1@3io`090?ooo`03
0000003oool0oooo00D0oooo1`3o0?l>0?ooo`D0Uol00`3oool609Oo00D0oooo1@3oW0000`3oool0
00000?ooo`0;0?ooo`030800o`3oool0oooo01H0oooo00<000000?ooo`3oool02`3oool00`3o0?@0
oooo0?ooo`090?ooo`L0o`3d203oool00`000000oooo0?ooo`0;0?ooo`06000000200?l0oooo0?oo
o`3oW000Uol00`3oool00`3o0?l0oooo0?ooo`0>0?ooo`80nOl03P3oool00`000000oooo0?ooo`0V
0?ooo`030000003oool0oooo0080oooo00<0R03o0?ooo`3oool01@3oool00`000000oooo0?ooo`0S
0?ooo`050000003oool0oooo0?ooo`0000000P3oool100000040oooo0@3oool000030?ooo`000000
000000800000103oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool06`3o
ool4000000D0oooo00<000000?ooo`3oool01`3oool2000000D0R03o5P3oool70?Wo00<000000`3o
ool2000000P0oooo1`3o0?l=0?ooo`80Uol00`3oool4000000@0oooo00<000000?ooo`3oool00`3o
ool50?nL008000003@3oool00`200?l0oooo0?ooo`0F0?ooo`8000002`3oool20?l0m0/0oooo203o
0?@80?ooo`030000003oool0oooo00P0oooo0P0000001P3oool0P03o0?ooo`3oool0oi`009Oo00<0
oooo00<0o`3o0?ooo`3oool03P3oool20?Wo00`0oooo0P00000Z0?ooo`050000003oool0oooo0?oo
o`280?l01@3oool2000002H0oooo00D000000?ooo`3oool0oooo000000020?ooo`4000000@3oool1
0?ooo`002@3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool08@3oool0
10000000oooo0?ooo`0000090?ooo`030000003oool0oooo00<0R03o5`3oool70?Wo00H0oooo00<0
00000?ooo`3oool0203oool50?l0o`d0oooo00<0Uol00?ooo`3oool02@3oool010000000oooo0?oo
o`0000030?ooo`L0oi`03@3oool20800oaP0oooo00<000000?ooo`3oool02P3oool20?l0m0`0oooo
203o0?@50?ooo`040000003oool0oooo000000T0oooo00@000000?ooo`3oool0P03o0P3oool00`3o
W000Uol00?ooo`020?ooo`030?l0o`3oool0oooo00l0oooo00<0nOl00?ooo`3oool02P3oool00`00
0000oooo0?ooo`0V0?ooo`040000003oool0oooo000000<0oooo00<0R03o0?ooo`3oool00`3oool0
0`000000oooo0?ooo`0U0?ooo`050000003oool0oooo0?ooo`0000000P3oool100000040oooo0@3o
ool000P0oooo0P0000040?ooo`800000903oool4000000T0oooo0`0000000`3oool0R03o0?ooo`0G
0?ooo`L0nOl01P3oool3000000T0oooo0`3o0?l=0?ooo`0309Oo003oool0oooo00/0oooo0P000004
0?ooo`L0oi`00P00000;0?ooo`030800o`3oool0oooo01L0oooo00<000000?ooo`3oool02P3oool0
0`3o0?@0oooo0?ooo`0<0?ooo`P0o`3d1@3oool2000000X0oooo0`0000001@200?l0oooo0?ooo`3o
ool0oi`000<0oooo00<0o`3o0?ooo`3oool03`3oool00`3io`00oooo0?ooo`0:0?ooo`<000009P3o
ool4000000<0oooo00<0R03o0?ooo`3oool00`3oool3000002@0oooo0P0000040?ooo`8000000`3o
ool004D0oooo00<0R03o0?ooo`3oool05`3oool50?Wo01<0oooo00<0o`3o0?ooo`3oool0303oool2
09Oo00l0oooo00@0oi`00?ooo`3oool0oooo1`3oW00=0?ooo`030800o`3oool0oooo01L0oooo00<0
00000?ooo`3oool02P3oool00`3o0?@0oooo0?ooo`0>0?ooo`L0o`3d4`3oool01@200?l0oooo0?oo
o`3oool0oi`000<0oooo00<0o`3o0?ooo`3oool03`3oool00`3io`00oooo0?ooo`0j0?ooo`0308P0
o`3oool0oooo03D0oooo00150?ooo`0308P0o`3oool0oooo01P0oooo0`3io`0D0?ooo`030?l0o`3o
ool0oooo00`0oooo00<0Uol00?ooo`3oool03P3oool0103oW000oooo0?ooo`3oool60?nL00h0oooo
00<0P03o0?ooo`3oool05`3oool00`000000oooo0?ooo`090?ooo`80o`3d403oool80?l0m180oooo
00D0P03o0?ooo`3oool0oooo0?nL00030?ooo`030?l0o`3oool0oooo00l0oooo00<0nOl00?ooo`3o
ool0>P3oool00`280?l0oooo0?ooo`0e0?ooo`00A@3oool00`280?l0oooo0?ooo`0I0?ooo`030?Wo
003oool0oooo01<0oooo00<0o`3o0?ooo`3oool02`3oool209Oo0100oooo103oW0020?ooo`<0oi`0
3`3oool00`200?l0oooo0?ooo`0G0?ooo`030000003oool0oooo00T0oooo0P3o0?@A0?ooo`T0o`3d
403oool01@200?l0oooo0?ooo`3oool0oi`000<0oooo00<0o`3o0?ooo`3oool03`3oool00`3io`00
oooo0?ooo`0j0?ooo`0308P0o`3oool0oooo03D0oooo00150?ooo`0308P0o`3oool0oooo01T0oooo
00<0nOl00?ooo`3oool04`3oool00`3o0?l0oooo0?ooo`0;0?ooo`0309Oo003oool0oooo00D0oooo
3@3oW00E0?ooo`030800o`3oool0oooo01L0oooo00<000000?ooo`3oool02@3oool00`3o0?@0oooo
0?ooo`0@0?ooo`X0o`3d3`3oool01@200?l0oooo0?ooo`3oool0oi`000<0oooo00<0o`3o0?ooo`3o
ool03`3oool00`3io`00oooo0?ooo`0j0?ooo`0308P0o`3oool0oooo03D0oooo00150?ooo`0308P0
o`3oool0oooo01T0oooo00<0nOl00?ooo`3oool04`3oool00`3o0?l0oooo0?ooo`0;0?ooo`0309Oo
003oool0oooo00@0oooo00<0oi`00?ooo`3oool0203oool30?nL01D0oooo0P200?lH0?ooo`030000
003oool0oooo00T0oooo00<0o`3d0?ooo`3oool0403oool50?l0m0030?ooo`3o0?@0o`3d00<0o`3d
3P3oool01@200?l0oooo0?ooo`3oool0oi`000<0oooo00<0o`3o0?ooo`3oool03`3oool00`3io`00
oooo0?ooo`0j0?ooo`0308P0o`3oool0oooo03D0oooo00150?ooo`0308P0o`3oool0oooo01T0oooo
00<0nOl00?ooo`3oool04`3oool00`3o0?l0oooo0?ooo`0;0?ooo`0309Oo003oool0oooo00<0oooo
0P3oW00:0?ooo`<0oi`0503oool30800oaP0oooo00<000000?ooo`3oool02@3oool00`3o0?@0oooo
0?ooo`0@0?ooo`D0o`3d1@3oool20?l0m0d0oooo00D0P03o0?ooo`3oool0oooo0?nL00030?ooo`03
0?l0o`3oool0oooo00l0oooo00<0nOl00?ooo`3oool0>P3oool00`280?l0oooo0?ooo`0e0?ooo`00
A@3oool00`280?l0oooo0?ooo`0I0?ooo`030?Wo003oool0oooo01<0oooo00<0o`3o0?ooo`3oool0
2`3oool00`2Go`00oooo0?ooo`030?ooo`030?nL003oool0oooo0080oooo0P3oW0050?ooo`@0oi`0
4`3oool30800oaP0oooo00<000000?ooo`3oool02@3oool00`3o0?@0oooo0?ooo`0@0?ooo`D0o`3d
503oool01@200?l0oooo0?ooo`3oool0oi`000<0oooo00<0o`3o0?ooo`3oool03`3oool00`3io`00
oooo0?ooo`0j0?ooo`0308P0o`3oool0oooo03D0oooo00090?oooc`0000000<0R03o000000000000
6@0000000`3io`0000000000000C000000030?l0o`000000000000/0000000<0Uol0000000000000
0`0000000`3oW000000000000003000000D0oi`000<000000?nL003oW0000P3oW00<000000030800
o`000000000000@000000`200?lT000000030?l0m000000000000100000000@0o`3d0000003o0?@0
o`3d5@0000001@200?l00000000000000000oi`000<0000000<0o`3o0000000000003`0000000`3i
o`0000000000000j0000000308P0o`000000000002l000001P3oool000T0oooo00<000000?ooo`3o
ool01P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3o
ool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00@000000?ooo`3o
ool0R03o1P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo00<000000?oo
o`3io`001`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0080oooo00<0o`3o0?oo
o`3oool00P3oool00`000000oooo0?ooo`060?ooo`0309Oo003oool0oooo00<0oooo00D0oi`00?oo
o`3oool0oooo000000020?ooo`X0oi`01P3oool00`000000oooo0?ooo`030?ooo`80P03o0P3oool0
0`000000oooo0800o`020800o`@0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00H0oooo00@000000?ooo`3oool0o`3d1P3oool00`000000oooo0?oo
o`060?ooo`050000003oool0oooo0?l0m03oool00P3o0?@30?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool01@3oool01@200?l000000?ooo`3oool0oi`000<0oooo00@0o`3o0?ooo`3o
ool00000203oool00`000000oooo0?ooo`030?ooo`050?Wo003oool0oooo0?ooo`0000002@3oool0
0`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool0
0`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<0R03o0000003oool01`3oool0
0`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool0
0`000000oooo0?ooo`070?ooo`030000003oool0oooo00@0oooo00090?ooo`030000003oool0oooo
02d0oooo00<000000?ooo`3oool02@3oool00`280?l0oooo0?ooo`0I0?ooo`030?Wo003oool0oooo
00D0oooo00<000000?ooo`3oool02`3oool00`3o0?l0oooo0?ooo`0;0?ooo`0309Oo003oool0oooo
00<0oooo0P3oW0070?ooo`P0oi`0303oool30800o`<0oooo0`200?lH0?ooo`030000003oool0oooo
00T0oooo00<0o`3d0?ooo`3oool0403oool0103o0?@0oooo0?l0m03o0?@=0?ooo`030000003oool0
oooo00D0oooo00D0P03o0?ooo`3oool0oooo0?nL00030?ooo`030?l0o`3oool0oooo00l0oooo00<0
nOl00?ooo`3oool02`3oool00`000000oooo0?ooo`0/0?ooo`0308P0o`000000oooo02h0oooo00<0
00000?ooo`3oool0103oool004D0oooo00<0R03o0?ooo`3oool06@3oool00`3io`00oooo0?ooo`0C
0?ooo`030?l0o`3oool0oooo00/0oooo00<0Uol00?ooo`3oool0103oool20?nL00L0oooo203oW00<
0?ooo`T0P03o5`3oool00`000000oooo0?ooo`090?ooo`030?l0m03oool0oooo0100oooo00@0o`3d
0?ooo`3oool0o`3d5@3oool01@200?l0oooo0?ooo`3oool0oi`000<0oooo00<0o`3o0?ooo`3oool0
3`3oool00`3io`00oooo0?ooo`0j0?ooo`0308P0o`3oool0oooo03D0oooo00150?ooo`0308P0o`3o
ool0oooo01T0oooo0P3io`0D0?ooo`030?l0o`3oool0oooo00/0oooo00<0Uol00?ooo`3oool01@3o
ool@0?nL00d0oooo20200?lG0?ooo`030000003oool0oooo00T0oooo00<0o`3d0?ooo`3oool0403o
ool0103o0?@0oooo0?ooo`3o0?@E0?ooo`050800o`3oool0oooo0?ooo`3oW0000`3oool00`3o0?l0
oooo0?ooo`0?0?ooo`030?Wo003oool0oooo03X0oooo00<0R03o0?ooo`3oool0=@3oool004D0oooo
00<0R03o0?ooo`3oool06P3oool00`3io`00oooo0?ooo`0B0?ooo`030?l0o`3oool0oooo00/0oooo
0P2Go`0A0?ooo`H0oi`0303oool80800oaL0oooo00<000000?ooo`3oool02@3oool20?l0m140oooo
00<0o`3d0?ooo`3oool05P3oool01@200?l0oooo0?ooo`3oool0oi`000<0oooo00<0o`3o0?ooo`3o
ool03`3oool00`3io`00oooo0?ooo`0j0?ooo`0308P0o`3oool0oooo03D0oooo00150?ooo`0308P0
o`3oool0oooo01X0oooo00<0nOl00?ooo`3oool04P3oool00`3o0?l0oooo0?ooo`0<0?ooo`0309Oo
003oool0oooo0100oooo1@3oW00=0?ooo`L0P03o5`3oool00`000000oooo0?ooo`090?ooo`80o`3d
4@3oool00`3o0?@0oooo0?ooo`0F0?ooo`050800o`3oool0oooo0?ooo`3oW0000`3oool00`3o0?l0
oooo0?ooo`0?0?ooo`030?Wo003oool0oooo03X0oooo00<0R03o0?ooo`3oool0=@3oool004D0oooo
00<0R03o0?ooo`3oool06P3oool00`3io`00oooo0?ooo`0B0?ooo`030?l0o`3oool0oooo00`0oooo
0P2Go`0B0?ooo`D0oi`03@3oool60800oaL0oooo00<000000?ooo`3oool02P3oool00`3o0?@0oooo
0?ooo`0?0?ooo`030?l0m03oool0oooo01H0oooo00D0P03o0?ooo`3oool0oooo0?nL00030?ooo`03
0?l0o`3oool0oooo00l0oooo00<0nOl00?ooo`3oool0>P3oool00`280?l0oooo0?ooo`0e0?ooo`00
A@3oool00`280?l0oooo0?ooo`0J0?ooo`030?Wo003oool0oooo0180oooo00<0o`3o0?ooo`3oool0
3@3oool00`2Go`00oooo0?ooo`0B0?ooo`<0oi`03@3oool60800oaL0oooo00<000000?ooo`3oool0
2P3oool00`3o0?@0oooo0?ooo`0>0?ooo`030?l0m03oool0oooo01L0oooo00D0P03o0?ooo`3oool0
oooo0?nL00030?ooo`030?l0o`3oool0oooo00l0oooo00<0nOl00?ooo`3oool0>P3oool00`280?l0
oooo0?ooo`0e0?ooo`00A@3oool00`280?l0oooo0?ooo`0J0?ooo`030?Wo003oool0oooo0180oooo
00<0o`3o0?ooo`3oool03P3oool00`2Go`00oooo0?ooo`0B0?ooo`<0oi`03@3oool50800oaL0oooo
00<000000?ooo`3oool02P3oool00`3o0?@0oooo0?ooo`0>0?ooo`030?l0m03oool0oooo01L0oooo
00D0P03o0?ooo`3oool0oi`009Oo00030?ooo`030?l0o`3oool0oooo00l0oooo00<0nOl00?ooo`3o
ool0>P3oool00`280?l0oooo0?ooo`0e0?ooo`00A@3oool00`280?l0oooo0?ooo`0J0?ooo`030?Wo
003oool0oooo0180oooo0P3o0?l@0?ooo`80Uol04`3oool30?nL00`0oooo1@200?lG0?ooo`800000
2`3oool20?l0m0h0oooo0P3o0?@I0?ooo`050800o`3oool0oooo0?nL002Go`000`3oool00`3o0?l0
oooo0?ooo`0?0?ooo`030?Wo003oool0oooo03X0oooo00<0R03o0?ooo`3oool0=@3oool004D0oooo
00<0R03o0?ooo`3oool06P3oool00`3io`00oooo0?ooo`0C0?ooo`030?l0o`3oool0oooo0100oooo
1@2Go`020?ooo`L0Uol01`3oool20?nL00`0oooo10200?lG0?ooo`030000003oool0oooo00/0oooo
00<0o`3d0?ooo`3oool0303oool20?l0m1T0oooo00D0P03o0?ooo`3oool0oi`009Oo00030?ooo`03
0?l0o`3oool0oooo00h0oooo0P3io`0l0?ooo`0308P0o`3oool0oooo03D0oooo00150?ooo`0308P0
o`3oool0oooo01X0oooo00<0nOl00?ooo`3oool04`3oool00`3o0?l0oooo0?ooo`0D0?ooo`@0Uol0
1@3oool509Oo00@0oooo00<0oi`00?ooo`3oool02`3oool30800oaL0oooo00<000000?ooo`3oool0
2`3oool20?l0m0d0oooo00<0o`3d0?ooo`3oool0603oool01@200?l0oooo0?ooo`3oW000Uol000<0
oooo00<0o`3o0?ooo`3oool03P3oool20?Wo03`0oooo00<0R03o0?ooo`3oool0=@3oool004D0oooo
00<0R03o0?ooo`3oool06P3oool00`3io`00oooo0?ooo`0C0?ooo`030?l0o`3oool0oooo0240oooo
0`2Go`030?ooo`030?nL003oool0oooo00X0oooo10200?lF0?ooo`030000003oool0oooo00`0oooo
00<0o`3d0?ooo`3oool02P3oool20?l0m1T0oooo0P200?l20?ooo`030?nL002Go`00oooo0080oooo
00<0o`3o0?ooo`3oool03P3oool20?Wo03/0oooo0P280?lg0?ooo`00A@3oool00`280?l0oooo0?oo
o`0J0?ooo`030?Wo003oool0oooo01<0oooo0P3o0?lT0?ooo`80Uol00`3oool00`3oW000oooo0?oo
o`0:0?ooo`<0P03o5P3oool00`000000oooo0?ooo`0<0?ooo`80o`3d2`3oool00`3o0?@0oooo0?oo
o`0H0?ooo`80P03o0P3oool01@3oW000Uol00?ooo`3oool0o`3o0140oooo00<0nOl00?ooo`3oool0
>P3oool208P0ocL0oooo00150?ooo`0308P0o`3oool0oooo01X0oooo0P3io`0D0?ooo`80o`3o9@3o
ool209Oo00<0oooo00<0oi`00?ooo`3oool02P3oool20800oaH0oooo00<000000?ooo`3oool03@3o
ool20?l0m0T0oooo0P3o0?@J0?ooo`80P03o0P3oool01@3oW000oooo0?ooo`3oool0o`3o0140oooo
00<0nOl00?ooo`3oool0>P3oool00`280?l0oooo0?ooo`0f0?ooo`00A@3oool00`280?l0oooo0?oo
o`0J0?ooo`80nOl05@3oool00`3o0?l0oooo0?ooo`0U0?ooo`80Uol00P3oool00`3oW000oooo0?oo
o`090?ooo`80P03o5P3oool00`000000oooo0?ooo`0>0?ooo`80o`3d1`3oool20?l0m1/0oooo00D0
P03o0?ooo`3oool0oooo0?nL00030?ooo`030?l0o`3oool0oooo00l0oooo00<0nOl00?ooo`3oool0
>P3oool00`280?l0oooo0?ooo`0f0?ooo`00A@3oool208P0oa/0oooo0P3io`0E0?ooo`030?l0o`3o
ool0oooo02H0oooo0P2Go`000`3oool0oi`00?ooo`0;0?ooo`030800o`3oool0oooo01@0oooo00<0
00000?ooo`3oool03`3oool20?l0m0D0oooo0P3o0?@L0?ooo`050800o`3oool0oooo0?ooo`3oW000
0`3oool00`3o0?l0oooo0?ooo`0?0?ooo`030?Wo003oool0oooo03X0oooo00<0R03o0?ooo`3oool0
=P3oool004D0oooo0P280?lL0?ooo`030?Wo003oool0oooo01@0oooo00<0o`3o0?ooo`3oool09`3o
ool00`2Go`00oooo0?nL000;0?ooo`030800o`3oool0oooo01@0oooo00<000000?ooo`3oool0403o
ool70?l0m1d0oooo00D0P03o0?ooo`3oool0oooo0?nL00030?ooo`030?l0o`3oool0oooo00h0oooo
0P3io`0l0?ooo`0308P0o`3oool0oooo03H0oooo00150?ooo`80R03o703oool00`3io`00oooo0?oo
o`0D0?ooo`030?l0o`3oool0oooo02P0oooo00<0Uol00?ooo`3oW0002P3oool20800oaD0oooo0P00
000e0?ooo`050800o`3oool0oooo0?ooo`3oW0000P3oool00`3o0?l0oooo0?ooo`0?0?ooo`80nOl0
?03oool00`280?l0oooo0?ooo`0f0?ooo`00A@3oool208P0oa`0oooo00<0nOl00?ooo`3oool05@3o
ool00`3o0?l0oooo0?ooo`0W0?ooo`80Uol000<0oooo0?nL003oool02@3oool00`200?l0oooo0?oo
o`0C0?ooo`030000003oool0oooo03<0oooo0P200?l20?ooo`050?nL002Go`00oooo0?ooo`3o0?l0
4@3oool00`3io`00oooo0?ooo`0k0?ooo`0308P0o`3oool0oooo03H0oooo00150?ooo`80R03o703o
ool00`3io`00oooo0?ooo`0E0?ooo`030?l0o`3oool0oooo02P0oooo00@0Uol00?ooo`3oool0oi`0
2@3oool20800oa@0oooo00<000000?ooo`3oool0<`3oool20800o`80oooo00D0oi`009Oo003oool0
oooo0?l0o`0A0?ooo`030?Wo003oool0oooo03X0oooo0P280?lh0?ooo`00AP3oool00`280?l0oooo
0?ooo`0J0?ooo`80nOl05P3oool20?l0obX0oooo0P2Go`000`3oool0oi`00?ooo`080?ooo`030800
o`3oool0oooo0180oooo00<000000?ooo`3oool0<`3oool01@200?l0oooo0?ooo`3oool0oi`000<0
oooo00<0o`3o0?ooo`3oool03`3oool00`3io`00oooo0?ooo`0j0?ooo`80R03o>03oool004H0oooo
00<0R03o0?ooo`3oool06P3oool20?Wo01L0oooo00<0o`3o0?ooo`3oool0:@3oool209Oo00030?oo
o`3oW000oooo00L0oooo0P200?lC0?ooo`030000003oool0oooo03<0oooo00D0P03o0?ooo`3oool0
oooo0?nL00030?ooo`030?l0o`3oool0oooo00h0oooo0P3io`0l0?ooo`0308P0o`3oool0oooo03L0
oooo00160?ooo`0308P0o`3oool0oooo01X0oooo0P3io`0G0?ooo`80o`3o:`3oool209Oo00030?nL
003oool0oooo00H0oooo0P200?lC0?ooo`030000003oool0oooo03<0oooo00D0P03o0?ooo`3oool0
oooo0?nL00020?ooo`80o`3o403oool20?Wo03`0oooo00<0R03o0?ooo`3oool0=`3oool004H0oooo
00<0R03o0?ooo`3oool06`3oool00`3io`00oooo0?ooo`0F0?ooo`80o`3o:`3oool00`2Go`00oooo
0?nL00080?ooo`80P03o4P3oool00`000000oooo0?ooo`0b0?ooo`80P03o0`3oool0103oW000oooo
0?ooo`3o0?lA0?ooo`030?Wo003oool0oooo03/0oooo00<0R03o0?ooo`3oool0=`3oool004H0oooo
00<0R03o0?ooo`3oool06`3oool00`3io`00oooo0?ooo`0G0?ooo`80o`3o:`3oool00`2Go`00oi`0
0?ooo`070?ooo`80P03o4P3oool00`000000oooo0?ooo`0b0?ooo`80P03o0P3oool01@3oW000Uol0
0?ooo`3oool0o`3o0140oooo00<0nOl00?ooo`3oool0>P3oool208P0ocT0oooo00160?ooo`0308P0
o`3oool0oooo01/0oooo00<0nOl00?ooo`3oool0603oool20?l0ob/0oooo00<0Uol00?nL003oool0
1`3oool20800oa40oooo00<000000?ooo`3oool0<P3oool01@200?l0oooo0?ooo`3oool0oi`000<0
oooo00<0o`3o0?ooo`3oool03P3oool20?Wo03`0oooo0P280?li0?ooo`00A`3oool00`280?l0oooo
0?ooo`0J0?ooo`80nOl06P3oool20?l0obX0oooo0P2Go`000`3oW000oooo0?ooo`060?ooo`030800
o`3oool0oooo00l0oooo00<000000?ooo`3oool0<P3oool01@200?l0oooo0?ooo`3oool0oi`000<0
oooo00<0o`3o0?ooo`3oool03P3oool20?Wo03`0oooo00<0R03o0?ooo`3oool0>03oool004L0oooo
00<0R03o0?ooo`3oool06P3oool20?Wo01/0oooo0P3o0?lZ0?ooo`80Uol000<0oi`00?ooo`3oool0
1@3oool20800oa00oooo0P00000c0?ooo`050800o`3oool0oooo09Oo003oW0000`3oool00`3o0?l0
oooo0?ooo`0>0?ooo`030?Wo003oool0oooo03/0oooo00<0R03o0?ooo`3oool0>03oool004L0oooo
00<0R03o0?ooo`3oool06P3oool20?Wo01`0oooo0`3o0?lY0?ooo`80Uol000<0oi`00?ooo`3oool0
1@3oool00`200?l0oooo0?ooo`0>0?ooo`030000003oool0oooo0340oooo00D0P03o0?ooo`3oool0
oooo0?nL00040?ooo`030?l0o`3oool0oooo00h0oooo00<0nOl00?ooo`3oool0>`3oool00`280?l0
oooo0?ooo`0h0?ooo`00A`3oool00`280?l0oooo0?ooo`0K0?ooo`030?Wo003oool0oooo01`0oooo
0`3o0?lX0?ooo`0309Oo003oW000oooo00H0oooo0P200?l?0?ooo`030000003oool0oooo0340oooo
00D0P03o0?ooo`3oool0oooo0?nL00030?ooo`030?l0o`3oool0oooo00l0oooo00<0nOl00?ooo`3o
ool0>P3oool00`280?l0oooo0?ooo`0i0?ooo`00A`3oool00`280?l0oooo0?ooo`0K0?ooo`030?Wo
003oool0oooo01h0oooo1@3o0?lU0?ooo`0309Oo003oW000oooo00H0oooo00<0P03o0?ooo`3oool0
3@3oool00`000000oooo0?ooo`0`0?ooo`80P03o0P3oool00`3oW000Uol00?ooo`020?ooo`030?l0
o`3oool0oooo00h0oooo0P3io`0l0?ooo`0308P0o`3oool0oooo03T0oooo00170?ooo`80R03o703o
ool20?Wo02<0oooo503o0?lB0?ooo`80Uol000<0oi`00?ooo`3oool0103oool20800o`h0oooo00<0
00000?ooo`3oool0<03oool20800o`80oooo00@0oi`00?ooo`3oool0oooo0P3o0?l@0?ooo`030?Wo
003oool0oooo03X0oooo0P280?lk0?ooo`00B03oool00`280?l0oooo0?ooo`0J0?ooo`80nOl0=P3o
ool50?l0o`l0oooo00<0Uol00?ooo`3oW0001P3oool20800o`d0oooo00<000000?ooo`3oool0<03o
ool01@200?l0oooo0?ooo`3oool0oi`000<0oooo0P3o0?l@0?ooo`030?Wo003oool0oooo03X0oooo
0P280?lk0?ooo`00B03oool00`280?l0oooo0?ooo`0K0?ooo`030?Wo003oool0oooo03L0oooo103o
0?l>0?ooo`0309Oo003oW000oooo00H0oooo00<0P03o0?ooo`3oool02`3oool00`000000oooo0?oo
o`0_0?ooo`80P03o0`3oool01@3oW000oooo0?ooo`3oool0o`3o0100oooo0P3io`0l0?ooo`0308P0
o`3oool0oooo03X0oooo00180?ooo`0308P0o`3oool0oooo01/0oooo0P3io`0k0?ooo`<0o`3o3@3o
ool00`2Go`00oi`00?ooo`050?ooo`80P03o303oool00`000000oooo0?ooo`0_0?ooo`060800o`3o
ool0oooo0?ooo`3oW000Uol00P3oool20?l0oa00oooo00<0nOl00?ooo`3oool0>P3oool208P0oc`0
oooo00180?ooo`0308P0o`3oool0oooo01/0oooo0P3io`0m0?ooo`<0o`3o2`3oool209Oo00030?nL
003oool0oooo00@0oooo00<0P03o0?ooo`3oool02P3oool00`000000oooo0?ooo`0_0?ooo`050800
o`3oool0oooo0?ooo`3oW0000`3oool20?l0oa00oooo00<0nOl00?ooo`3oool0>P3oool00`280?l0
oooo0?ooo`0k0?ooo`00B03oool208P0oad0oooo00<0nOl00?ooo`3oool0?@3oool20?l0o`/0oooo
00<0Uol00?ooo`3oW0001P3oool00`200?l0oooo0?ooo`090?ooo`800000;`3oool20800o`<0oooo
00D0oi`00?ooo`3oool0oooo0?l0o`0@0?ooo`80nOl0?03oool00`280?l0oooo0?ooo`0k0?ooo`00
B03oool208P0oad0oooo0P3io`0o0?ooo`<0o`3o2P3oool00`2Go`00oooo0?nL00050?ooo`030800
o`3oool0oooo00T0oooo00<000000?ooo`3oool0;P3oool00`200?l0oooo0?ooo`020?ooo`050?nL
003oool0oooo0?ooo`3o0?l0403oool00`3io`00oooo0?ooo`0j0?ooo`0308P0o`3oool0oooo03`0
oooo00190?ooo`0308P0o`3oool0oooo01/0oooo0P3io`110?ooo`80o`3o2P3oool00`2Go`00oi`0
0?ooo`050?ooo`030800o`3oool0oooo00P0oooo00<000000?ooo`3oool0;P3oool01@200?l0oooo
0?ooo`3oool0oi`000<0oooo00<0o`3o0?ooo`3oool03`3oool00`3io`00oooo0?ooo`0j0?ooo`03
08P0o`3oool0oooo03`0oooo00190?ooo`0308P0o`3oool0oooo01`0oooo00<0nOl00?ooo`3oool0
@@3oool00`3o0?l0oooo0?ooo`080?ooo`0309Oo003oW000oooo00D0oooo00<0P03o0?ooo`3oool0
1`3oool00`000000oooo0?ooo`0]0?ooo`80P03o0`3oool01@3oW000oooo0?ooo`3oool0o`3o0100
oooo0P3io`0k0?ooo`80R03o?P3oool004T0oooo0P280?lM0?ooo`80nOl0@`3oool00`3o0?l0oooo
0?ooo`070?ooo`0309Oo003oW000oooo00D0oooo0P200?l80?ooo`030000003oool0oooo02d0oooo
00H0P03o0?ooo`3oool0oooo0?nL002Go`020?ooo`80o`3o403oool00`3io`00oooo0?ooo`0j0?oo
o`0308P0o`3oool0oooo03d0oooo00190?ooo`80R03o7P3oool00`3io`00oooo0?ooo`120?ooo`80
o`3o203oool00`2Go`00oi`00?ooo`050?ooo`80P03o1`3oool00`000000oooo0?ooo`0/0?ooo`80
P03o0`3oool0103oW000oooo0?ooo`3oool20?l0oa00oooo00<0nOl00?ooo`3oool0>@3oool208P0
ocl0oooo001:0?ooo`0308P0o`3oool0oooo01`0oooo00<0nOl00?ooo`3oool0@`3oool20?l0o`P0
oooo00<0Uol00?nL003oool0103oool30800o`H0oooo00<000000?ooo`3oool0;03oool01P200?l0
oooo0?ooo`3oool0oi`009Oo00<0oooo00<0o`3o0?ooo`3oool03P3oool20?Wo03/0oooo0P280?lo
0?ooo`00BP3oool00`280?l0oooo0?ooo`0L0?ooo`80nOl0A@3oool20?l0o`P0oooo00<0oi`00?oo
o`3oool0103oool20800o`H0oooo00<000000?ooo`3oool0:`3oool20800o`<0oooo00@0oi`00?oo
o`3oool0oooo0P3o0?l@0?ooo`80nOl0>P3oool208P0od00oooo001:0?ooo`80R03o7P3oool00`3i
o`00oooo0?ooo`140?ooo`030?l0o`3oool0000000<000000`3oool00`2Go`00oi`00?ooo`030?oo
o`8000000P200?l50?ooo`030000003oool0oooo02/0oooo00H0P03o0?ooo`3oool0oooo0?nL002G
o`030?ooo`030?l0o`3oool0oooo00l0oooo00<0nOl00?ooo`3oool0>@3oool208P0od00oooo001;
0?ooo`0308P0o`3oool0oooo01`0oooo0P3io`160?ooo`80o`3o1`3oool01@2Go`00oi`00?nL003o
ool000000080oooo00<000000800o`200?l0103oool00`000000oooo0?ooo`0Z0?ooo`80P03o0`3o
ool00`3oW000oooo0?ooo`020?ooo`030?l0o`3oool0oooo00h0oooo0P3io`0j0?ooo`80R03o@@3o
ool004/0oooo00<0R03o0?ooo`3oool0703oool20?Wo04L0oooo0P3o0?l70?ooo`0309Oo003oool0
oi`000<0oooo00<000000?ooo`200?l0103oool3000002X0oooo00H0P03o0?ooo`3oool0oooo0?nL
002Go`030?ooo`80o`3o403oool00`3io`00oooo0?ooo`0i0?ooo`0308P0o`3oool0oooo0400oooo
001;0?ooo`0308P0o`3oool0oooo01d0oooo0P3io`170?ooo`80o`3o1`3oool00`2Go`00oi`00?oo
o`02000000<0oooo00D0P03o0?ooo`3oool0oooo0000000[0?ooo`030800o`3oool0oooo0080oooo
00<0oi`00?ooo`3oool00P3oool00`3o0?l0oooo0?ooo`0>0?ooo`80nOl0>P3oool208P0od80oooo
001;0?ooo`0308P0o`3oool0oooo01h0oooo00<0nOl00?ooo`3oool0A03oool010000000oooo0?l0
o`3o0?l70?ooo`0309Oo003oW000000000@0oooo0P200?l20?ooo`030000003oool0oooo02P0oooo
0P200?l30?ooo`030?nL002Go`00oooo0080oooo0P3o0?l@0?ooo`030?Wo003oool0oooo03T0oooo
00<0R03o0?ooo`3oool0@@3oool004`0oooo00<0R03o0?ooo`3oool07@3oool20?Wo04H0oooo0P00
00020?l0o`H0oooo0P2Go`000`3oW0000000000000030?ooo`80P03o00<0oooo0000003oool0:@3o
ool00`200?l0oooo0?ooo`020?ooo`030?nL003oool0oooo0080oooo00<0o`3o0?ooo`3oool03P3o
ool20?Wo03X0oooo0P280?m30?ooo`00C03oool00`280?l0oooo0?ooo`0N0?ooo`030?Wo003oool0
oooo04L0oooo0P3o0?l60?ooo`0309Oo003oW000oooo00D0oooo0P200?l00`000000oooo0?ooo`0W
0?ooo`030800o`3oool0oooo0080oooo00<0oi`009Oo003oool00P3oool20?l0oa00oooo00<0nOl0
0?ooo`3oool0>@3oool00`280?l0oooo0?ooo`120?ooo`00C03oool208P0oal0oooo0P3io`190?oo
o`80o`3o1P3oool00`2Go`00oi`00?ooo`050?ooo`030800o`000000oooo02P0oooo00H0P03o0?oo
o`3oool0oooo0?nL002Go`040?ooo`030?l0o`3oool0oooo00l0oooo00<0nOl00?ooo`3oool0>03o
ool208P0od@0oooo001<0?ooo`80R03o803oool00`3io`00oooo0?ooo`180?ooo`80o`3o1P3oool0
0`2Go`00oi`00?ooo`050?ooo`030800o`3oool0oooo02H0oooo00<0P03o0?ooo`3oool00P3oool0
0`3oW000Uol00?ooo`030?ooo`030?l0o`3oool0oooo00h0oooo0P3io`0i0?ooo`80R03oA@3oool0
04d0oooo00<0R03o0?ooo`3oool07P3oool20?Wo04X0oooo0P3o0?l60?ooo`0309Oo003oW000oooo
00@0oooo00<000000800o`3oool09@3oool20800o`<0oooo00<0oi`009Oo003oool00`3oool00`3o
0?l0oooo0?ooo`0?0?ooo`030?Wo003oool0oooo03P0oooo00<0R03o0?ooo`3oool0A03oool004d0
oooo00<0R03o0?ooo`3oool07`3oool20?Wo04X0oooo0P3o0?l60?ooo`0309Oo003oW000oooo00<0
oooo00<000000?ooo`200?l0903oool20800o`@0oooo00<0oi`00?ooo`3oool00`3oool00`3o0?l0
oooo0?ooo`0>0?ooo`80nOl0>@3oool208P0odH0oooo001=0?ooo`80R03o8@3oool00`3io`00oooo
0?ooo`190?ooo`80o`3o0P3oool01P3o0?l0oooo0?ooo`3oool0Uol00?nL00<0oooo00@000000?oo
o`3oool0P03o8P3oool20800o`@0oooo00<0oi`009Oo003oool00`3oool00`3o0?l0oooo0?ooo`0?
0?ooo`030?Wo003oool0oooo03L0oooo0P280?m70?ooo`00CP3oool00`280?l0oooo0?ooo`0P0?oo
o`030?Wo003oool0oooo04T0oooo0P3o0?l00`3oool0o`3o0?l0o`030?ooo`0409Oo003oW000oooo
0?ooo`8000000P3oool00`200?l0oooo0?ooo`0O0?ooo`030800o`3oool0oooo0080oooo00<0oi`0
09Oo003oool00`3oool00`3o0?l0oooo0?ooo`0?0?ooo`80nOl0>03oool208P0odP0oooo001>0?oo
o`0308P0o`3oool0oooo0200oooo0P3io`1;0?ooo`80o`3o00<0oooo0?l0o`3o0?l00`3oool0102G
o`00oi`00?ooo`0000040?ooo`80P03o7P3oool00`200?l0oooo0?ooo`030?ooo`030?nL002Go`00
oooo00<0oooo00<0o`3o0?ooo`3oool03`3oool00`3io`00oooo0?ooo`0f0?ooo`80R03oB@3oool0
04h0oooo0P280?lR0?ooo`80nOl0B`3oool00`3o0?l0oooo0?l0o`020?l0o`<0oooo00<0Uol00?nL
000000001@3oool20800oa/0oooo0P200?l50?ooo`030?nL002Go`00oooo00<0oooo00<0o`3o0?oo
o`3oool03`3oool20?Wo03L0oooo0P280?m:0?ooo`00C`3oool00`280?l0oooo0?ooo`0Q0?ooo`03
0?Wo003oool0oooo04X0oooo103o0?l40?ooo`0309Oo003oW000oooo00H0oooo0P200?lH0?ooo`80
P03o1@3oool00`3oW000Uol00?ooo`030?ooo`030?l0o`3oool0oooo0100oooo00<0nOl00?ooo`3o
ool0=P3oool00`280?l0oooo0?ooo`190?ooo`00C`3oool00`280?l0oooo0?ooo`0R0?ooo`030?Wo
003oool0oooo04X0oooo103o0?l40?ooo`0309Oo003oW000oi`000H0oooo0P200?lF0?ooo`80P03o
1@3oool00`3oW000Uol00?ooo`040?ooo`030?l0o`3oool0oooo00l0oooo0P3io`0g0?ooo`0308P0
o`3oool0oooo04X0oooo001?0?ooo`80R03o903oool00`3io`00oooo0?ooo`1:0?ooo`@0o`3o0`3o
ool010000000Uol009Oo003oW0060?ooo`<0P03o4`3oool20800o`D0oooo00<0oi`009Oo003oool0
103oool00`3o0?l0oooo0?ooo`0@0?ooo`030?Wo003oool0oooo03D0oooo00<0R03o0?ooo`3oool0
B`3oool00500oooo00<0R03o0?ooo`3oool08`3oool00`3io`00oooo0?ooo`160?ooo`P0o`3o0P3o
ool01@000000oooo09Oo002Go`00oi`000L0oooo0`200?l?0?ooo`80P03o1`3oool00`3oW000Uol0
0?ooo`030?ooo`80o`3o4@3oool20?Wo03H0oooo00<0R03o0?ooo`3oool0C03oool00500oooo00<0
R03o0?ooo`3oool0903oool20?Wo0480oooo3@3o0?l00`3oool000000?ooo`020?ooo`0309Oo003o
W000oooo00L0oooo10200?l90?ooo`@0P03o1`3oool00`3oW000Uol00?ooo`030?ooo`80o`3o4@3o
ool20?Wo03H0oooo00<0R03o0?ooo`3oool0C@3oool00500oooo0P280?lW0?ooo`030?Wo003oool0
oooo0440oooo303o0?l00`000000oooo0?ooo`020?ooo`0309Oo003oW000oooo00T0oooo2`200?l8
0?ooo`80oi`000<0Uol00?ooo`3oool00`3oool00`3o0?l0oooo0?ooo`0@0?ooo`80nOl0=@3oool0
0`280?l0oooo0?ooo`1>0?ooo`00D@3oool00`280?l0oooo0?ooo`0V0?ooo`80nOl0@`3oool;0?l0
o`030000003oool0oooo0080oooo00<0Uol00?nL003oW0006P3oool00`3oW000Uol009Oo00050?oo
o`030?l0o`3oool0oooo0100oooo0P3io`0d0?ooo`80R03oD@3oool00540oooo00<0R03o0?ooo`3o
ool09`3oool20?Wo04D0oooo2@3o0?l50?ooo`80Uol00P3oW00G0?ooo`030?nL002Go`00Uol000D0
oooo00<0o`3o0?ooo`3oool04@3oool00`3io`00oooo0?ooo`0b0?ooo`80R03oDP3oool00540oooo
0P280?lY0?ooo`<0nOl0A@3oool70?l0o`L0oooo0P2Go`000`3oW000oooo0?ooo`0B0?ooo`80oi`0
00<0Uol00?ooo`3oool0103oool20?l0oa80oooo0P3io`0c0?ooo`80R03oD`3oool00580oooo00<0
R03o0?ooo`3oool0:@3oool30?Wo04H0oooo1@3o0?l80?ooo`0309Oo003oW000oi`00100oooo0P3o
W00209Oo00H0oooo0P3o0?lC0?ooo`030?Wo003oool0oooo0340oooo0P280?mD0?ooo`00DP3oool2
08P0obd0oooo1@3io`130?ooo`040000003o0?l0o`3o0?l0o`T0oooo00<0Uol00?nL003oW0000`3o
W0080?ooo`<0oi`00`2Go`060?ooo`80o`3o4`3oool20?Wo0380oooo00<0R03o0?ooo`3oool0E03o
ool005<0oooo00<0R03o0?ooo`3oool0<03ooolG0?Wo02`0oooo00<000000?ooo`3oool00`3o0?l8
0?ooo`D0Uol0203oW00309Oo00P0oooo0P3o0?lD0?ooo`030?Wo003oool0oooo0300oooo00<0R03o
0?ooo`3oool0E@3oool005<0oooo0P280?m70?ooo`L0nOl09P3oool00`000000oooo0?ooo`020?oo
o`80o`3o2`3oool809Oo00X0oooo0`3o0?lD0?ooo`030?Wo003oool0oooo0300oooo00<0R03o0?oo
o`3oool0EP3oool005<0oooo0P280?m=0?ooo`H0nOl08@3oool00`000000oooo0?ooo`030?ooo`<0
o`3o6P3oool20?l0oaD0oooo0P3io`0a0?ooo`0308P0o`3oool0oooo05L0oooo001D0?ooo`0308P0
o`3oool0oooo04h0oooo1@3io`0O0?ooo`030000003oool0oooo00D0oooo0P3o0?lG0?ooo`<0o`3o
5P3oool00`3io`00oooo0?ooo`0^0?ooo`80R03oFP3oool005@0oooo0P280?mC0?ooo`@0nOl0703o
ool00`000000oooo0?ooo`060?ooo`<0o`3o503oool20?l0oaL0oooo0P3io`0_0?ooo`80R03oF`3o
ool005D0oooo00<0R03o0?ooo`3oool0E03oool30?Wo01X0oooo0P00000:0?ooo`80o`3o403oool3
0?l0oaL0oooo0P3io`0_0?ooo`80R03oG03oool005D0oooo0P280?mH0?ooo`80nOl0603oool00`00
0000oooo0?ooo`0:0?ooo`H0o`3o203oool30?l0oaX0oooo00<0nOl00?ooo`3oool0;@3oool00`28
0?l0oooo0?ooo`1L0?ooo`00EP3oool00`280?l0oooo0?ooo`1H0?ooo`80nOl05P3oool00`000000
oooo0?ooo`0>0?ooo`/0o`3o6`3oool20?Wo02h0oooo00<0R03o0?ooo`3oool0G@3oool005H0oooo
0P280?mJ0?ooo`80nOl05@3oool00`000000oooo0?ooo`0d0?ooo`030?Wo003oool0oooo02`0oooo
00<0R03o0?ooo`3oool0GP3oool005L0oooo00<0R03o0?ooo`3oool0FP3oool20?Wo01<0oooo00<0
00000?ooo`3oool0<`3oool00`3io`00oooo0?ooo`0[0?ooo`80R03oH@3oool005P0oooo00<0R03o
0?ooo`3oool0F`3oool20?Wo0140oooo00<000000?ooo`3oool0<P3oool00`3io`00oooo0?ooo`0[
0?ooo`80R03oHP3oool005P0oooo00<0R03o0?ooo`3oool0G03oool20?Wo0100oooo00<000000?oo
o`3oool0<@3oool20?Wo02`0oooo0P280?mS0?ooo`00F03oool208P0oel0oooo0P3io`0>0?ooo`03
0000003oool0oooo0300oooo0P3io`0/0?ooo`0308P0o`3oool0oooo06<0oooo001I0?ooo`0308P0
o`3oool0oooo05h0oooo0P3io`0=0?ooo`030000003oool0oooo02l0oooo0P3io`0[0?ooo`80R03o
IP3oool005T0oooo0P280?mQ0?ooo`80nOl02`3oool2000002l0oooo0P3io`0[0?ooo`80R03oI`3o
ool005X0oooo00<0R03o0?ooo`3oool0H03oool20?Wo00X0oooo00<000000?ooo`3oool0;P3oool0
0`3io`00oooo0?ooo`0Y0?ooo`80R03oJ03oool005X0oooo0P280?mR0?ooo`80nOl02@3oool00`00
0000oooo0?ooo`0]0?ooo`030?Wo003oool0oooo02X0oooo00<0R03o0?ooo`3oool0I`3oool005/0
oooo00<0R03o0?ooo`3oool0HP3oool20?Wo00L0oooo00<000000?ooo`3oool0;03oool00`3io`00
oooo0?ooo`0Z0?ooo`0308P0o`3oool0oooo06P0oooo001K0?ooo`80R03oI03oool30?Wo00D0oooo
00<000000?ooo`3oool0:`3oool00`3io`00oooo0?ooo`0Z0?ooo`0308P0o`3oool0oooo06T0oooo
001L0?ooo`0308P0o`3oool0oooo06@0oooo0P3io`040?ooo`030000003oool0oooo02X0oooo00<0
nOl00?ooo`3oool0:P3oool00`280?l0oooo0?ooo`1Z0?ooo`00G@3oool00`280?l0oooo0?ooo`1U
0?ooo`80nOl00P3oool00`000000oooo0?ooo`0Y0?ooo`030?Wo003oool0oooo02X0oooo00<0R03o
0?ooo`3oool0J`3oool005d0oooo00<0R03o0?ooo`3oool0IP3oool20?Wo00030?ooo`000000oooo
02T0oooo00<0nOl00?ooo`3oool0:P3oool00`280?l0oooo0?ooo`1/0?ooo`00GP3oool00`280?l0
oooo0?ooo`1O0?ooo`8000001P3oool20?Wo02T0oooo00<0nOl00?ooo`3oool0:P3oool00`280?l0
oooo0?ooo`1]0?ooo`00GP3oool208P0oel0oooo00@000000?ooo`3oool000001P3oool30?Wo02D0
oooo0P3io`0/0?ooo`0308P0o`3oool0oooo06h0oooo001O0?ooo`80R03oH@3oool00`000000oooo
0?ooo`040?ooo`8000000P3io`0S0?ooo`80nOl0;03oool00`280?l0oooo0?ooo`1_0?ooo`00H03o
ool00`280?l0oooo0?ooo`1M0?ooo`8000001`3oool010000000oooo0?ooo`3oool20?Wo01l0oooo
0P3io`0]0?ooo`0308P0o`3oool0oooo0700oooo001P0?ooo`80R03oGP3oool00`000000oooo0?oo
o`060?ooo`030000003oool0oooo0080oooo103io`0K0?ooo`030?Wo003oool0oooo02`0oooo00<0
R03o0?ooo`3oool0L@3oool00640oooo0P280?mM0?ooo`<000001P3oool00`000000oooo0?ooo`04
0?ooo`D0nOl05P3oool20?Wo02h0oooo00<0R03o0?ooo`3oool0LP3oool00680oooo0P280?mU0?oo
o`030000003oool0oooo00L0oooo1@3io`0A0?ooo`80nOl0;`3oool00`280?l0oooo0?ooo`1c0?oo
o`00H`3oool00`280?l0oooo0?ooo`1S0?ooo`030000003oool0oooo00X0oooo1@3io`090?ooo`D0
nOl0<03oool00`280?l0oooo0?ooo`1d0?ooo`00H`3oool208P0of@0oooo00<000000?ooo`3oool0
3P3oool<0?Wo0380oooo00<0R03o0?ooo`3oool0M@3oool006@0oooo0P280?mS0?ooo`030000003o
ool0oooo04/0oooo00<0R03o0?ooo`3oool0MP3oool006D0oooo0P280?mR0?ooo`030000003oool0
oooo04X0oooo00<0R03o0?ooo`3oool0M`3oool006H0oooo00<0R03o0?ooo`3oool0H03oool00`00
0000oooo0?ooo`190?ooo`0308P0o`3oool0oooo07P0oooo001W0?ooo`0308P0o`3oool0oooo05l0
oooo0P0000190?ooo`0308P0o`3oool0oooo07T0oooo001X0?ooo`0308P0o`3oool0oooo05h0oooo
00<000000?ooo`3oool0A`3oool208P0og/0oooo001Y0?ooo`0308P0o`3oool0oooo05d0oooo00<0
00000?ooo`3oool0AP3oool208P0og`0oooo001Z0?ooo`0308P0o`3oool0oooo05`0oooo00<00000
0?ooo`3oool0A@3oool208P0ogd0oooo001[0?ooo`80R03oG03oool00`000000oooo0?ooo`140?oo
o`80R03oOP3oool006`0oooo0P280?mK0?ooo`030000003oool0oooo04@0oooo00<0R03o0?ooo`3o
ool0O@3oool006d0oooo0P280?mJ0?ooo`030000003oool0oooo04<0oooo00<0R03o0?ooo`3oool0
OP3oool006h0oooo0P280?mI0?ooo`030000003oool0oooo0480oooo00<0R03o0?ooo`3oool0O`3o
ool006l0oooo0P280?mH0?ooo`030000003oool0oooo0440oooo00<0R03o0?ooo`3oool0P03oool0
0700oooo0`280?mF0?ooo`800000@@3oool00`280?l0oooo0?ooo`210?ooo`00LP3oool208P0oeD0
oooo00<000000?ooo`3oool0?`3oool00`280?l0oooo0?ooo`220?ooo`00M03oool208P0oe<0oooo
00<000000?ooo`3oool0?P3oool208P0oh@0oooo001f0?ooo`80R03oD@3oool00`000000oooo0?oo
o`0m0?ooo`80R03oQ@3oool007P0oooo0P280?m?0?ooo`030000003oool0oooo03`0oooo0P280?n6
0?ooo`00NP3oool308P0od`0oooo00<000000?ooo`3oool0>`3oool208P0ohL0oooo001m0?ooo`H0
R03oAP3oool00`000000oooo0?ooo`0j0?ooo`80R03oR03oool00800oooo3@280?ll0?ooo`030000
003oool0oooo03T0oooo0P280?n90?ooo`00S03ooolJ08P0ob<0oooo00<000000?ooo`3oool0>03o
ool208P0ohX0oooo002U0?ooo`D0R03o7`3oool00`000000oooo0?ooo`0g0?ooo`80R03oR`3oool0
0:T0oooo1@280?lK0?ooo`800000=`3oool208P0oh`0oooo002/0?ooo`H0R03o5`3oool00`000000
oooo0?ooo`0e0?ooo`0308P0o`3oool0oooo08`0oooo002`0?ooo`D0R03o503oool00`000000oooo
0?ooo`0d0?ooo`0308P0o`3oool0oooo08d0oooo002d0?ooo`<0R03o4P3oool00`000000oooo0?oo
o`0c0?ooo`0308P0o`3oool0oooo08h0oooo002g0?ooo`80R03o403oool00`000000oooo0?ooo`0a
0?ooo`80R03oT@3oool00;T0oooo0`280?l=0?ooo`030000003oool0oooo0300oooo0P280?nB0?oo
o`00^`3oool308P0o`/0oooo00<000000?ooo`3oool0;P3oool308P0oi<0oooo002m0?ooo`<0R03o
2@3oool00`000000oooo0?ooo`0]0?ooo`80R03oU@3oool00;l0oooo10280?l60?ooo`030000003o
ool0oooo02`0oooo0P280?nF0?ooo`00`P3oool308P0o`@0oooo0P00000[0?ooo`80R03oV03oool0
0<@0oooo0`280?l20?ooo`030000003oool0oooo02T0oooo0P280?nI0?ooo`00aP3oool308P0o`03
0000003oool0oooo02L0oooo0`280?nJ0?ooo`00b03oool308P0obH0oooo0`280?nL0?ooo`00b@3o
ool00`000000R03o08P0o`0208P0ob40oooo0`280?nN0?ooo`00b@3oool010000000oooo0?ooo`3o
ool408P0oa`0oooo0`280?nP0?ooo`00b@3oool00`000000oooo0?ooo`040?ooo`@0R03o5@3oool4
08P0oj<0oooo00390?ooo`030000003oool0oooo00P0oooo1P280?l<0?ooo`@0R03oYP3oool00;D0
oooo00<000000?ooo`3oool00P3oool2000000@0oooo0P0000070?ooo`030000003oool0oooo00`0
oooo3`280?nY0?ooo`00]@3oool00`000000oooo0?ooo`070?ooo`040000003oool0oooo000000H0
oooo00<000000?ooo`3oool0a03oool00;D0oooo00<000000?ooo`3oool02P3oool00`000000oooo
0?ooo`040?ooo`<00000a03oool00;H0oooo00<000000?ooo`3oool01`3oool2000000L0oooo00<0
00000?ooo`3oool0a03oool00;<0oooo00@000000?ooo`3oool000002@3oool00`000000oooo0?oo
o`060?ooo`030000003oool0oooo0<@0oooo002c0?ooo`@000002@3oool3000000H0oooo00<00000
0?ooo`3oool0a03oool00<T0oooo00<000000?ooo`3oool0a03oool00<T0oooo00<000000?ooo`3o
ool0a03oool00<T0oooo00<000000?ooo`3oool0a03oool00<T0oooo00<000000?ooo`3oool0a03o
ool00<T0oooo00<000000?ooo`3oool0a03oool00<T0oooo00<000000?ooo`3oool0a03oool00<T0
oooo0P0000350?ooo`00b@3oool00`000000oooo0?ooo`340?ooo`00b@3oool00`000000oooo0?oo
o`340?ooo`00b@3oool00`000000oooo0?ooo`340?ooo`00b@3oool00`000000oooo0?ooo`340?oo
o`00b@3oool00`000000oooo0?ooo`340?ooo`00b@3oool00`000000oooo0?ooo`340?ooo`00b@3o
ool00`000000oooo0?ooo`340?ooo`00b@3oool00`000000oooo0?ooo`340?ooo`00b@3oool20000
0<D0oooo00390?ooo`030000003oool0oooo0<@0oooo00390?ooo`030000003oool0oooo0<@0oooo
00390?ooo`030000003oool0oooo0<@0oooo00390?ooo`030000003oool0oooo0<@0oooo00390?oo
o`030000003oool0oooo0<@0oooo00390?ooo`030000003oool0oooo0<@0oooo00390?ooo`030000
003oool0oooo0<@0oooo00390?ooo`030000003oool0oooo0<@0oooo00390?ooo`030000003oool0
oooo0<@0oooo00390?ooo`800000a@3oool00<T0oooo00<000000?ooo`3oool0a03oool00<T0oooo
00<000000?ooo`3oool0a03oool00<T0oooo00<000000?ooo`3oool0a03oool00<T0oooo00<00000
0?ooo`3oool0a03oool00<T0oooo00<000000?ooo`3oool0a03oool00<T0oooo00<000000?ooo`3o
ool0a03oool00<T0oooo00<000000?ooo`3oool0a03oool00<T0oooo00<000000?ooo`3oool0a03o
ool00<T0oooo0P0000350?ooo`00b@3oool00`000000oooo0?ooo`340?ooo`00b@3oool00`000000
oooo0?ooo`340?ooo`00b@3oool00`000000oooo0?ooo`340?ooo`00b@3oool00`000000oooo0?oo
o`340?ooo`00b@3oool00`000000oooo0?ooo`340?ooo`00b@3oool00`000000oooo0?ooo`340?oo
o`00b@3oool00`000000oooo0?ooo`340?ooo`00^@3oool500000080oooo0P0000070?ooo`030000
003oool0oooo0<@0oooo002k0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo0<@0oooo002k0?ooo`050000003oool0oooo0?ooo`000000
0P3oool00`000000oooo0?ooo`040?ooo`<00000a03oool00;/0oooo00D000000?ooo`3oool0oooo
000000020?ooo`030000003oool0oooo0</0oooo002k0?ooo`050000003oool0oooo0?ooo`000000
0P3oool00`000000oooo0?ooo`3;0?ooo`00^P3oool2000000@0oooo0P00003>0?ooo`00o`3ooonA
0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 399}, {399, 0}} -> {-10.4689, -10.3907, 0.0520839, \
0.0520839}},
  CellTags->"EquationTrekker"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        InterpretationBox[
          RowBox[{"EquationTrekkerState", "[", 
            
            RowBox[{"\<\"\\!\\({x[t] +  \\(\\*SuperscriptBox[\\(x\\),  \\(\
\[Prime]\[Prime]\\), MultilineFunction->None]\\)[t] \[Equal] \[Alpha] Cos[\
\[Omega] x[t]], x, {t, \\(-10\\), 10}}\\)\"\>", 
              ",", "\<\"\\!\\({\[Alpha] \[Rule] 3.`, \[Omega] \[Rule] 1.`}\\)\
\"\>", ",", 
              TagBox[
                TagBox[GridBox[{
                      {
                        InterpretationBox[
                          StyleBox[
                            RowBox[{"TrekData", "[", 
                              
                              RowBox[{"\<\"\\!\\({x[0.`] \[Equal] \
\\(-2.1500000000000004`\\),  \\(\\*SuperscriptBox[\\(x\\),  \\(\[Prime]\\), \
MultilineFunction->None]\\)[0.`] \[Equal] \\(-0.75`\\)}\\)\"\>", ",", 
                                " ", "\<\"<>\"\>"}], "]"}],
                            FontColor->RGBColor[0.592157, 1, 0]],
                          TrekData[ {
                            Equal[ 
                              x[ 0.`], -2.1500000000000004`], 
                            Equal[ 
                              Derivative[ 1][ x][ 
                              0.`], -0.75`]}, {-2.1500000000000004`, -0.75`}, \
{0.`, {-10.`, 10.`}}, {
                            RGBColor[ 0.5921568870544434`, 1.`, 0.`], 
                            "Line"}]]},
                      {
                        InterpretationBox[
                          StyleBox[
                            RowBox[{"TrekData", "[", 
                              
                              RowBox[{"\<\"\\!\\({x[0.`] \[Equal] \
\\(-1.1500000000000004`\\),  \\(\\*SuperscriptBox[\\(x\\),  \\(\[Prime]\\), \
MultilineFunction->None]\\)[0.`] \[Equal] \\(-0.9499999999999993`\\)}\\)\"\>",
                                 ",", " ", "\<\"<>\"\>"}], "]"}],
                            FontColor->RGBColor[0.501961, 0, 1]],
                          TrekData[ {
                            Equal[ 
                              x[ 0.`], -1.1500000000000004`], 
                            Equal[ 
                              Derivative[ 1][ x][ 
                              0.`], -0.9499999999999993`]}, \
{-1.1500000000000004`, -0.9499999999999993`}, {0.`, {-10.`, 10.`}}, {
                            RGBColor[ 0.501960813999176`, 0.`, 1.`], 
                            "Line"}]]},
                      {
                        InterpretationBox[
                          StyleBox[
                            RowBox[{"TrekData", "[", 
                              
                              RowBox[{"\<\"\\!\\({x[0.`] \[Equal] \
\\(-4.2`\\),  \\(\\*SuperscriptBox[\\(x\\),  \\(\[Prime]\\), \
MultilineFunction->None]\\)[0.`] \[Equal] \\(-0.5999999999999996`\\)}\\)\"\>",
                                 ",", " ", "\<\"<>\"\>"}], "]"}],
                            FontColor->RGBColor[1, 0, 1]],
                          TrekData[ {
                            Equal[ 
                              x[ 0.`], -4.2`], 
                            Equal[ 
                              Derivative[ 1][ x][ 
                              0.`], -0.5999999999999996`]}, {-4.2`, \
-0.5999999999999996`}, {0.`, {-10.`, 10.`}}, {
                            RGBColor[ 1.`, 0.`, 1.`], "Line"}]]},
                      {
                        InterpretationBox[
                          StyleBox[
                            RowBox[{"TrekData", "[", 
                              
                              RowBox[{"\<\"\\!\\({x[0.`] \[Equal] \
\\(-6.85`\\),  \\(\\*SuperscriptBox[\\(x\\),  \\(\[Prime]\\), \
MultilineFunction->None]\\)[0.`] \[Equal] \\(-0.6500000000000004`\\)}\\)\"\>",
                                 ",", " ", "\<\"<>\"\>"}], "]"}],
                            FontColor->RGBColor[0.533333, 0, 1]],
                          TrekData[ {
                            Equal[ 
                              x[ 0.`], -6.85`], 
                            Equal[ 
                              Derivative[ 1][ x][ 
                              0.`], -0.6500000000000004`]}, {-6.85`, \
-0.6500000000000004`}, {0.`, {-10.`, 10.`}}, {
                            RGBColor[ 0.5333333611488342`, 0.`, 1.`], 
                            "Line"}]]},
                      {
                        InterpretationBox[
                          StyleBox[
                            RowBox[{"TrekData", "[", 
                              
                              RowBox[{"\<\"\\!\\({x[0.`] \[Equal] \
\\(-5.35`\\),  \\(\\*SuperscriptBox[\\(x\\),  \\(\[Prime]\\), \
MultilineFunction->None]\\)[0.`] \[Equal] \\(-0.5`\\)}\\)\"\>", ",", 
                                " ", "\<\"<>\"\>"}], "]"}],
                            FontColor->RGBColor[0.976471, 1, 0]],
                          TrekData[ {
                            Equal[ 
                              x[ 0.`], -5.35`], 
                            Equal[ 
                              Derivative[ 1][ x][ 
                              0.`], -0.5`]}, {-5.35`, -0.5`}, {0.`, {-10.`, 
                            10.`}}, {
                            RGBColor[ 0.9764705896377563`, 1.`, 0.`], 
                            "Line"}]]},
                      {
                        InterpretationBox[
                          StyleBox[
                            RowBox[{"TrekData", "[", 
                              
                              RowBox[{"\<\"\\!\\({x[0.`] \[Equal] \
1.5500000000000007`,  \\(\\*SuperscriptBox[\\(x\\),  \\(\[Prime]\\), \
MultilineFunction->None]\\)[0.`] \[Equal] \\(-0.5999999999999996`\\)}\\)\"\>",
                                 ",", " ", "\<\"<>\"\>"}], "]"}],
                            FontColor->RGBColor[1, 0, 0.956863]],
                          TrekData[ {
                            Equal[ 
                              x[ 0.`], 1.5500000000000007`], 
                            Equal[ 
                              Derivative[ 1][ x][ 
                              0.`], -0.5999999999999996`]}, {
                            1.5500000000000007`, -0.5999999999999996`}, {
                            0.`, {-10.`, 10.`}}, {
                            RGBColor[ 1.`, 0.`, 0.95686274766922`], 
                            "Line"}]]},
                      {
                        InterpretationBox[
                          StyleBox[
                            RowBox[{"TrekData", "[", 
                              
                              RowBox[{"\<\"\\!\\({x[0.`] \[Equal] \
\\(-2.2`\\),  \\(\\*SuperscriptBox[\\(x\\),  \\(\[Prime]\\), \
MultilineFunction->None]\\)[0.`] \[Equal] \\(-0.4499999999999993`\\)}\\)\"\>",
                                 ",", " ", "\<\"<>\"\>"}], "]"}],
                            FontColor->RGBColor[1, 0.611765, 0]],
                          TrekData[ {
                            Equal[ 
                              x[ 0.`], -2.2`], 
                            Equal[ 
                              Derivative[ 1][ x][ 
                              0.`], -0.4499999999999993`]}, {-2.2`, \
-0.4499999999999993`}, {0.`, {-10.`, 10.`}}, {
                            RGBColor[ 1.`, 0.6117647290229797`, 0.`], 
                            "Line"}]]}
                      },
                    RowSpacings->1,
                    ColumnAlignments->{Left}],
                  Column],
                Function[ BoxForm`e$, 
                  MatrixForm[ BoxForm`e$]]], ",", "\<\" <>\"\>"}], "]"}],
          EquationTrekkerState[ {
            Equal[ 
              Plus[ 
                x[ t], 
                Derivative[ 2][ x][ t]], 
              Times[ \[Alpha], 
                Cos[ 
                  Times[ \[Omega], 
                    x[ t]]]]], x, {t, -10, 10}}, {\[Alpha] -> 3.0, \[Omega] -> 
            1.0}, {
            TrekData[ {
              Equal[ 
                x[ 0.0], -2.1500000000000004], 
              Equal[ 
                Derivative[ 1][ x][ 
                0.0], -.75]}, {-2.1500000000000004, -.75}, {
              0.0, {-.1*^2, .1*^2}}, {
              RGBColor[ .59215688705444336, 1.0, 0.0], "Line"}], 
            TrekData[ {
              Equal[ 
                x[ 0.0], -1.1500000000000004], 
              Equal[ 
                Derivative[ 1][ x][ 
                0.0], -.94999999999999929]}, {-1.1500000000000004, \
-.94999999999999929}, {0.0, {-.1*^2, .1*^2}}, {
              RGBColor[ .50196081399917603, 0.0, 1.0], "Line"}], 
            TrekData[ {
              Equal[ 
                x[ 0.0], -4.2000000000000002], 
              Equal[ 
                Derivative[ 1][ x][ 
                0.0], -.59999999999999964]}, {-4.2000000000000002, \
-.59999999999999964}, {0.0, {-.1*^2, .1*^2}}, {
              RGBColor[ 1.0, 0.0, 1.0], "Line"}], 
            TrekData[ {
              Equal[ 
                x[ 0.0], -6.8499999999999996], 
              Equal[ 
                Derivative[ 1][ x][ 
                0.0], -.65000000000000036]}, {-6.8499999999999996, \
-.65000000000000036}, {0.0, {-.1*^2, .1*^2}}, {
              RGBColor[ .53333336114883423, 0.0, 1.0], "Line"}], 
            TrekData[ {
              Equal[ 
                x[ 0.0], -5.3499999999999996], 
              Equal[ 
                Derivative[ 1][ x][ 0.0], -.5]}, {-5.3499999999999996, -.5}, {
              0.0, {-.1*^2, .1*^2}}, {
              RGBColor[ .97647058963775635, 1.0, 0.0], "Line"}], 
            TrekData[ {
              Equal[ 
                x[ 0.0], 1.5500000000000007], 
              Equal[ 
                Derivative[ 1][ x][ 0.0], -.59999999999999964]}, {
              1.5500000000000007, -.59999999999999964}, {
              0.0, {-.1*^2, .1*^2}}, {
              RGBColor[ 1.0, 0.0, .95686274766921997], "Line"}], 
            TrekData[ {
              Equal[ 
                x[ 0.0], -2.2000000000000002], 
              Equal[ 
                Derivative[ 1][ x][ 
                0.0], -.44999999999999929]}, {-2.2000000000000002, \
-.44999999999999929}, {0.0, {-.1*^2, .1*^2}}, {
              RGBColor[ 1.0, .61176472902297974, 0.0], "Line"}]}, {
            TrekParameters -> {\[Alpha] -> 3.0, \[Omega] -> 1.0}, 
            PlotRange -> {{-.1*^2, .1*^2}, {-.1*^2, .1*^2}}, "CanvasSize" -> {
            400, 400}}]], ",", 
        TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
          False,
          Editable->False]}], "}"}]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"EquationTrekker"]
}, Open  ]],

Cell["\<\
When you move the sliders (or modify the text values and press Enter), the \
new solutions are calculated immediately and the window is updated, allowing \
you to rapidly get an idea of how the parameters affect the solutions of the \
equation.\
\>", "Text",
  CellTags->"EquationTrekker"],

Cell["\<\
This opens up the same window.  The results shown are arrived at by changing \
the parameter values in the window to \[Alpha] = 5 and \[Omega] = 1.5.  It is \
apparent that a new separatrix has formed.\
\>", "MathCaption",
  CellTags->"EquationTrekker"],

Cell[CellGroupData[{

Cell[BoxData[
    \(EquationTrekker[First[%]]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"EquationTrekker"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
%%ImageSize: 400 400 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.05 0.5 0.05 [
[0 .4875 -9 -9 ]
[0 .4875 9 0 ]
[.125 .4875 -12 -9 ]
[.125 .4875 12 0 ]
[.25 .4875 -6 -9 ]
[.25 .4875 6 0 ]
[.375 .4875 -12 -9 ]
[.375 .4875 12 0 ]
[.625 .4875 -9 -9 ]
[.625 .4875 9 0 ]
[.75 .4875 -3 -9 ]
[.75 .4875 3 0 ]
[.875 .4875 -9 -9 ]
[.875 .4875 9 0 ]
[1 .4875 -6 -9 ]
[1 .4875 6 0 ]
[.4875 0 -18 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .125 -24 -4.5 ]
[.4875 .125 0 4.5 ]
[.4875 .25 -12 -4.5 ]
[.4875 .25 0 4.5 ]
[.4875 .375 -24 -4.5 ]
[.4875 .375 0 4.5 ]
[.4875 .625 -18 -4.5 ]
[.4875 .625 0 4.5 ]
[.4875 .75 -6 -4.5 ]
[.4875 .75 0 4.5 ]
[.4875 .875 -18 -4.5 ]
[.4875 .875 0 4.5 ]
[.4875 1 -12 -4.5 ]
[.4875 1 0 4.5 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .5 m
0 .50625 L
s
[(-10)] 0 .4875 0 1 Mshowa
.125 .5 m
.125 .50625 L
s
[(-7.5)] .125 .4875 0 1 Mshowa
.25 .5 m
.25 .50625 L
s
[(-5)] .25 .4875 0 1 Mshowa
.375 .5 m
.375 .50625 L
s
[(-2.5)] .375 .4875 0 1 Mshowa
.625 .5 m
.625 .50625 L
s
[(2.5)] .625 .4875 0 1 Mshowa
.75 .5 m
.75 .50625 L
s
[(5)] .75 .4875 0 1 Mshowa
.875 .5 m
.875 .50625 L
s
[(7.5)] .875 .4875 0 1 Mshowa
1 .5 m
1 .50625 L
s
[(10)] 1 .4875 0 1 Mshowa
.125 Mabswid
.025 .5 m
.025 .50375 L
s
.05 .5 m
.05 .50375 L
s
.075 .5 m
.075 .50375 L
s
.1 .5 m
.1 .50375 L
s
.15 .5 m
.15 .50375 L
s
.175 .5 m
.175 .50375 L
s
.2 .5 m
.2 .50375 L
s
.225 .5 m
.225 .50375 L
s
.275 .5 m
.275 .50375 L
s
.3 .5 m
.3 .50375 L
s
.325 .5 m
.325 .50375 L
s
.35 .5 m
.35 .50375 L
s
.4 .5 m
.4 .50375 L
s
.425 .5 m
.425 .50375 L
s
.45 .5 m
.45 .50375 L
s
.475 .5 m
.475 .50375 L
s
.525 .5 m
.525 .50375 L
s
.55 .5 m
.55 .50375 L
s
.575 .5 m
.575 .50375 L
s
.6 .5 m
.6 .50375 L
s
.65 .5 m
.65 .50375 L
s
.675 .5 m
.675 .50375 L
s
.7 .5 m
.7 .50375 L
s
.725 .5 m
.725 .50375 L
s
.775 .5 m
.775 .50375 L
s
.8 .5 m
.8 .50375 L
s
.825 .5 m
.825 .50375 L
s
.85 .5 m
.85 .50375 L
s
.9 .5 m
.9 .50375 L
s
.925 .5 m
.925 .50375 L
s
.95 .5 m
.95 .50375 L
s
.975 .5 m
.975 .50375 L
s
.25 Mabswid
0 .5 m
1 .5 L
s
.5 0 m
.50625 0 L
s
[(-10)] .4875 0 1 0 Mshowa
.5 .125 m
.50625 .125 L
s
[(-7.5)] .4875 .125 1 0 Mshowa
.5 .25 m
.50625 .25 L
s
[(-5)] .4875 .25 1 0 Mshowa
.5 .375 m
.50625 .375 L
s
[(-2.5)] .4875 .375 1 0 Mshowa
.5 .625 m
.50625 .625 L
s
[(2.5)] .4875 .625 1 0 Mshowa
.5 .75 m
.50625 .75 L
s
[(5)] .4875 .75 1 0 Mshowa
.5 .875 m
.50625 .875 L
s
[(7.5)] .4875 .875 1 0 Mshowa
.5 1 m
.50625 1 L
s
[(10)] .4875 1 1 0 Mshowa
.125 Mabswid
.5 .025 m
.50375 .025 L
s
.5 .05 m
.50375 .05 L
s
.5 .075 m
.50375 .075 L
s
.5 .1 m
.50375 .1 L
s
.5 .15 m
.50375 .15 L
s
.5 .175 m
.50375 .175 L
s
.5 .2 m
.50375 .2 L
s
.5 .225 m
.50375 .225 L
s
.5 .275 m
.50375 .275 L
s
.5 .3 m
.50375 .3 L
s
.5 .325 m
.50375 .325 L
s
.5 .35 m
.50375 .35 L
s
.5 .4 m
.50375 .4 L
s
.5 .425 m
.50375 .425 L
s
.5 .45 m
.50375 .45 L
s
.5 .475 m
.50375 .475 L
s
.5 .525 m
.50375 .525 L
s
.5 .55 m
.50375 .55 L
s
.5 .575 m
.50375 .575 L
s
.5 .6 m
.50375 .6 L
s
.5 .65 m
.50375 .65 L
s
.5 .675 m
.50375 .675 L
s
.5 .7 m
.50375 .7 L
s
.5 .725 m
.50375 .725 L
s
.5 .775 m
.50375 .775 L
s
.5 .8 m
.50375 .8 L
s
.5 .825 m
.50375 .825 L
s
.5 .85 m
.50375 .85 L
s
.5 .9 m
.50375 .9 L
s
.5 .925 m
.50375 .925 L
s
.5 .95 m
.50375 .95 L
s
.5 .975 m
.50375 .975 L
s
.25 Mabswid
.5 0 m
.5 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of user PostScript
/mathtops {
gsave
MBeginOrig
moveto
MEndOrig
currentpoint
grestore
} bind def
/MAtocoords {
mathtops 4 2 roll mathtops
4 copy pop pop
3 -1 roll sub
/arry exch def
exch sub
/arrx exch def
arrx dup mul
arry dup mul
add sqrt
/arrl exch def
translate
} bind def
/MAarrowhead1 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto
-0.035 0 lineto fill
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto
-0.035 0 lineto
-0.05 0.0125 lineto stroke
} ifelse
grestore
} def
% End of user PostScript
.976 1 0 r
.5 Mabswid
.63567 .73585 m
.64143 .73047 L
.64706 .72551 L
.6549 .71923 L
.66254 .7139 L
.67 .70947 L
.67732 .70587 L
.68453 .70295 L
.69164 .70055 L
.69868 .69847 L
.70564 .69649 L
.71253 .6944 L
.71935 .69197 L
.72607 .68898 L
.73267 .68525 L
.73912 .68064 L
.7454 .67501 L
.75145 .66831 L
.75726 .66051 L
.76276 .65162 L
.76794 .64169 L
.77274 .63081 L
.77715 .61908 L
.78113 .6066 L
.78466 .59349 L
.78772 .57985 L
.79029 .5658 L
.79236 .55143 L
.79392 .53681 L
.79486 .52371 L
.7954 .51053 L
.79552 .49732 L
.79523 .48411 L
.79453 .47096 L
.79342 .4579 L
.7919 .445 L
.78998 .4323 L
.78766 .41986 L
.78529 .4091 L
.78262 .39864 L
.77967 .38855 L
.77644 .37888 L
.77294 .36968 L
.7692 .36101 L
.76523 .35291 L
.76104 .34544 L
.75666 .33862 L
.75209 .33247 L
.74736 .32701 L
.74087 .32081 L
Mistroke
.73533 .31652 L
.72967 .31294 L
.7239 .30998 L
.71806 .30754 L
.71215 .30548 L
.70618 .30366 L
.70016 .30195 L
.69408 .3002 L
.68867 .2985 L
.68322 .29656 L
.6777 .2943 L
.67212 .29165 L
.66647 .28853 L
.66072 .28491 L
.65487 .28074 L
.64889 .27602 L
.64419 .272 L
.6394 .26767 L
.63451 .26305 L
.62953 .25817 L
.62444 .25308 L
.61925 .24782 L
.61394 .24247 L
.60853 .2371 L
.60181 .23067 L
.59494 .22448 L
.58928 .21976 L
.58352 .2154 L
.57768 .21147 L
.57177 .20805 L
.56579 .2052 L
.55976 .20298 L
.55369 .20143 L
.54759 .20055 L
.54149 .20036 L
.53538 .20081 L
.5293 .20188 L
.52324 .20349 L
.51722 .20559 L
.51124 .20808 L
.50414 .21146 L
.49713 .2151 L
.48833 .21988 L
.47967 .22451 L
.47282 .22794 L
.46605 .23098 L
.45935 .23355 L
.45271 .23559 L
.44611 .23705 L
.43954 .23794 L
Mistroke
.43299 .23828 L
.42644 .23812 L
.41988 .23753 L
.4149 .23686 L
.40991 .23605 L
.40491 .23515 L
.39988 .23423 L
.39484 .23334 L
.38979 .23255 L
.38472 .23193 L
.37964 .23154 L
.37529 .23144 L
.37093 .23158 L
.36659 .23201 L
.36225 .23274 L
.35793 .23382 L
.35362 .23524 L
.34935 .23703 L
.34583 .23879 L
.34234 .24082 L
.33887 .2431 L
.33544 .24563 L
.33204 .24841 L
.32868 .25143 L
.32671 .25333 L
.32475 .25531 L
.32281 .25736 L
.32088 .25949 L
.31897 .26169 L
.31873 .26197 L
.3185 .26225 L
.31826 .26253 L
.31802 .26281 L
.318 .26284 L
.31798 .26287 L
.31795 .2629 L
.31794 .26291 L
.31793 .26293 L
.31792 .26294 L
.31791 .26295 L
.31789 .26297 L
.31146 .27119 L
.30526 .28005 L
.29931 .28939 L
.29363 .29909 L
.28822 .309 L
.28308 .31902 L
.27822 .32903 L
.27363 .33897 L
.26932 .34876 L
Mistroke
.26405 .36135 L
.25923 .37354 L
.25395 .38779 L
.24929 .40138 L
.24521 .41435 L
.24169 .42674 L
.23871 .43864 L
.23625 .45011 L
.23429 .46125 L
.23281 .47211 L
.23182 .48279 L
.23129 .49336 L
.23123 .50388 L
.23163 .51443 L
.23251 .52507 L
.23337 .53241 L
.23446 .53984 L
.23578 .54741 L
.23732 .55512 L
.2391 .56301 L
.24112 .5711 L
.24339 .57941 L
.24591 .58797 L
.24869 .5968 L
.25134 .60474 L
.2542 .61291 L
.25728 .62131 L
.26058 .62995 L
.26412 .63881 L
.26788 .64788 L
.27189 .65713 L
.27615 .66654 L
.28065 .67605 L
.28676 .68822 L
.29199 .69798 L
.29748 .70757 L
.30323 .71686 L
.30923 .72573 L
.31545 .73403 L
.3219 .74164 L
.32854 .74843 L
.33534 .7543 L
.3423 .75916 L
.34937 .76298 L
.35654 .76576 L
.36376 .76755 L
.37102 .76842 L
.37829 .76852 L
.38556 .76798 L
.3928 .767 L
Mistroke
.40002 .76575 L
.4072 .76443 L
.41582 .763 L
.4244 .76202 L
.43039 .76172 L
.43638 .76183 L
.44238 .76237 L
.4484 .76339 L
.45445 .76489 L
.46053 .76686 L
.46667 .76928 L
.47286 .77208 L
.47913 .77521 L
.48488 .77825 L
.4907 .78142 L
.49658 .78461 L
.50253 .78773 L
.50855 .79069 L
.51462 .79337 L
.52074 .79569 L
.52691 .79755 L
.53311 .79886 L
.53934 .79956 L
.54557 .79959 L
.55179 .79892 L
.55799 .79754 L
.56416 .79546 L
.57027 .79272 L
.57632 .78937 L
.5823 .78547 L
.58968 .77992 L
.59691 .7738 L
.60477 .76654 L
.61242 .75905 L
.62143 .74997 L
.63012 .74125 L
.63851 .73315 L
.64663 .72588 L
.65451 .71952 L
.66218 .71412 L
.66968 .70964 L
.67703 .70599 L
.68427 .70304 L
.69141 .70062 L
.69847 .69853 L
.70546 .69655 L
.71238 .69445 L
.71922 .69202 L
.72596 .68903 L
.73259 .6853 L
Mistroke
.73907 .68068 L
.74537 .67504 L
.75145 .66832 L
.75727 .66049 L
.76279 .65156 L
.76798 .64159 L
.7728 .63067 L
.77722 .61888 L
.78121 .60635 L
.78474 .59318 L
.7878 .57948 L
.79036 .56537 L
.79242 .55094 L
.79396 .53626 L
.7949 .52307 L
.79542 .50979 L
.79551 .49647 L
.79519 .48317 L
.79446 .46993 L
.7933 .45679 L
.79174 .44381 L
.78976 .43104 L
.78739 .41855 L
.78505 .40808 L
.78242 .39791 L
.77952 .38809 L
.77636 .37868 L
.77296 .36971 L
.76931 .36124 L
.76545 .35332 L
.76137 .34599 L
.75711 .33928 L
.75268 .33321 L
.74809 .32779 L
.74207 .32185 L
.73642 .3173 L
.73064 .31351 L
.72476 .31038 L
.71878 .30781 L
.71274 .30566 L
.70662 .30379 L
.70046 .30204 L
.69424 .30024 L
.68903 .29862 L
.68378 .29678 L
.67849 .29465 L
.67313 .29216 L
.6677 .28925 L
.66219 .28588 L
.65658 .28201 L
Mistroke
.65087 .27764 L
.64623 .27377 L
.6415 .26959 L
.63668 .26512 L
.63176 .26037 L
.62675 .25539 L
.62163 .25023 L
.6164 .24494 L
.61106 .23959 L
.60439 .2331 L
.59756 .22678 L
.59149 .22156 L
.58531 .2167 L
.57902 .21232 L
.57264 .20852 L
.56619 .20537 L
.55968 .20296 L
.55312 .20132 L
.54653 .20047 L
.53994 .20041 L
.53335 .2011 L
.52678 .20248 L
.52025 .20448 L
.51377 .20698 L
.50735 .20988 L
.49962 .21378 L
.49199 .21788 L
.48448 .22196 L
.47707 .22585 L
.46976 .22936 L
.46254 .23239 L
.45539 .23483 L
.44831 .23663 L
.44125 .23776 L
.43612 .23819 L
.43099 .23828 L
.42586 .23809 L
.42072 .23763 L
.41557 .23696 L
.41041 .23614 L
.40523 .23521 L
.40122 .23447 L
.39721 .23375 L
.39318 .23306 L
.38914 .23246 L
.3851 .23197 L
.38105 .23162 L
.37699 .23145 L
.37192 .23152 L
.36685 .23197 L
Mistroke
.363 .23259 L
.35915 .23348 L
.35532 .23463 L
.35151 .23608 L
.34772 .23781 L
.34396 .23984 L
.33919 .24288 L
.33448 .24639 L
.32902 .25111 L
.32368 .25643 L
.31845 .2623 L
.31336 .26865 L
.30842 .27542 L
.30362 .28254 L
.29898 .28994 L
.2945 .29755 L
.29019 .3053 L
.28605 .31315 L
.28208 .32103 L
.27828 .32889 L
.27466 .33671 L
.2712 .34445 L
.2679 .35208 L
.26477 .35958 L
.26249 .36522 L
.2603 .37077 L
.25821 .37623 L
.2562 .3816 L
.25428 .38687 L
.25245 .39206 L
.25103 .39617 L
.24967 .40022 L
.24836 .40421 L
.24711 .40815 L
.24591 .41203 L
.24452 .41667 L
.2432 .42124 L
.24196 .42573 L
.24079 .43016 L
.2397 .43452 L
.23867 .43882 L
.23749 .4441 L
.23641 .44929 L
.23556 .45377 L
.23478 .4582 L
.23408 .46258 L
.23346 .46693 L
.23292 .47124 L
.23285 .47181 L
.23278 .47238 L
Mistroke
.23272 .47294 L
.23266 .47351 L
.23265 .47357 L
.23265 .47362 L
.23264 .47368 L
.23264 .47371 L
.23263 .47374 L
.23263 .47377 L
.23263 .47379 L
.23262 .47382 L
.23258 .47421 L
.23254 .4746 L
.2325 .47498 L
.2325 .47499 L
.2325 .475 L
.2325 .47501 L
.2325 .47502 L
.23246 .4754 L
.23242 .47579 L
.23238 .47618 L
.23238 .4762 L
.23238 .47623 L
.23237 .47626 L
.23237 .47629 L
.23237 .47632 L
.23236 .47637 L
.23236 .47643 L
.23235 .47649 L
.2323 .47705 L
.23224 .47762 L
.23219 .47819 L
.23214 .47875 L
.23182 .48276 L
.23156 .48676 L
.23138 .49074 L
.23126 .49471 L
.2312 .49868 L
.23123 .50392 L
.23137 .50916 L
.23163 .51443 L
.23201 .51971 L
.2325 .52503 L
.23311 .5304 L
.23397 .53663 L
.23497 .54294 L
.23615 .54935 L
.23748 .55587 L
.23898 .56251 L
.24065 .5693 L
.24216 .57499 L
Mistroke
.24378 .58078 L
.24552 .5867 L
.24739 .59275 L
.24939 .59893 L
.25152 .60525 L
.25418 .61285 L
.25703 .62064 L
.26007 .62863 L
.26331 .63682 L
.26676 .6452 L
.27041 .65375 L
.27427 .66243 L
.27834 .67122 L
.28263 .68008 L
.28714 .68894 L
.29186 .69774 L
.29679 .7064 L
.30194 .71483 L
.30728 .72294 L
.31282 .73063 L
.31854 .7378 L
.32443 .74436 L
.32916 .74902 L
.33397 .75321 L
.33886 .7569 L
.34382 .76008 L
.34883 .76273 L
.35389 .76486 L
.35898 .76648 L
.3641 .76761 L
.36924 .76829 L
.37439 .76856 L
.37953 .76846 L
.38468 .76807 L
.38981 .76745 L
.39559 .76654 L
.40134 .76551 L
.40708 .76445 L
.41279 .76347 L
.41848 .76264 L
.42416 .76204 L
.42982 .76174 L
.43549 .76178 L
.44202 .76233 L
.44857 .76343 L
.45516 .7651 L
.46179 .76733 L
.46849 .77007 L
.47526 .77325 L
.48212 .77678 L
Mistroke
.48906 .78052 L
.4961 .78435 L
.50324 .78809 L
.51047 .79157 L
.51777 .79462 L
.52515 .79707 L
.53258 .79877 L
.54004 .79959 L
.54751 .79945 L
.55496 .7983 L
.56113 .79657 L
.56726 .79416 L
.57333 .79111 L
.57933 .78748 L
.58525 .78334 L
.59108 .77878 L
.59681 .77388 L
.60244 .76874 L
.60796 .76345 L
.61337 .7581 L
.61867 .75276 L
.62497 .74639 L
.63111 .74027 L
.6371 .73448 L
.64295 .72909 L
.64867 .72416 L
.65428 .7197 L
.65977 .71573 L
.66517 .71224 L
.67049 .7092 L
.67726 .70589 L
.68392 .70317 L
.69051 .70091 L
.69702 .69894 L
.70348 .69711 L
.70987 .69524 L
.71621 .69315 L
.72246 .69067 L
.72863 .68764 L
.73575 .68318 L
.74134 .67879 L
.74678 .6736 L
.75205 .66758 L
.75712 .66071 L
.76196 .65301 L
.76655 .64451 L
.77087 .63526 L
.77489 .62533 L
.7786 .61478 L
.78197 .60368 L
Mistroke
.785 .59213 L
.78766 .58018 L
.79054 .56428 L
.79237 .55131 L
.7938 .53816 L
.7948 .52486 L
.79537 .51148 L
.79553 .49806 L
.79525 .48465 L
.79455 .47129 L
.79343 .45803 L
.79189 .44492 L
.79039 .43478 L
.78864 .42481 L
.78664 .41502 L
.7844 .40546 L
.78193 .39617 L
.77923 .38718 L
.77631 .37853 L
.77318 .37027 L
.7688 .36014 L
.76513 .35273 L
.76128 .34584 L
.75726 .3395 L
.75309 .33374 L
.74877 .32856 L
.74433 .32395 L
.73979 .3199 L
.73514 .31639 L
.73041 .31337 L
.72561 .31079 L
.72013 .30835 L
.71562 .30664 L
.71107 .30513 L
.70648 .30375 L
.70186 .30243 L
.69721 .30111 L
.69253 .29973 L
.68781 .29821 L
.6822 .29617 L
.67651 .29377 L
.67076 .29094 L
.66492 .28761 L
.65899 .28372 L
.65293 .27926 L
.64675 .27422 L
.64024 .26844 L
.6349 .26342 L
.62944 .25808 L
.62385 .25248 L
Mistroke
.61814 .2467 L
.61229 .24082 L
.6063 .23493 L
.60019 .22916 L
.59394 .22362 L
.58757 .21842 L
.58109 .2137 L
.57579 .21031 L
.57044 .20736 L
.56503 .20489 L
.55959 .20293 L
.55411 .20151 L
.54861 .20065 L
.5431 .20034 L
.53759 .20057 L
.53209 .20131 L
.52661 .20253 L
.52115 .20417 L
.51573 .20617 L
.51035 .20848 L
.50501 .21102 L
.49972 .21373 L
.49448 .21653 L
.48929 .21935 L
.48416 .22214 L
.47907 .22482 L
.47328 .22772 L
.46755 .23034 L
.46187 .23264 L
.45624 .23457 L
.45064 .23611 L
.44507 .23723 L
.43952 .23795 L
.43398 .23827 L
.42844 .23822 L
.4229 .23785 L
.41612 .23704 L
.40932 .23595 L
.40249 .23471 L
.39562 .23347 L
.38873 .23241 L
.38181 .23167 L
.37639 .23144 L
.37097 .23158 L
.36555 .23215 L
.36016 .23322 L
.35479 .23482 L
.34945 .23698 L
.34417 .23972 L
.33895 .24304 L
Mistroke
.3338 .24694 L
.32873 .25138 L
.32377 .25634 L
.3189 .26177 L
.31415 .26763 L
.30952 .27386 L
.30502 .2804 L
.30066 .28721 L
.29643 .29422 L
.29235 .30137 L
.28841 .30863 L
.28363 .31791 L
.27909 .32719 L
.27558 .33469 L
.27222 .34213 L
.26902 .34947 L
.26596 .3567 L
.26306 .3638 L
.2603 .37077 L
.25769 .3776 L
.25471 .38568 L
.2524 .39218 L
.25023 .39853 L
.24819 .40474 L
.24628 .41082 L
.24449 .41677 L
.24282 .42259 L
.24094 .42961 L
.23922 .43647 L
.23798 .44187 L
.23684 .44719 L
.23581 .45243 L
.23488 .4576 L
.23406 .46271 L
.23335 .46776 L
.23274 .47277 L
.23208 .47948 L
.2316 .48614 L
.23131 .49276 L
.2312 .49936 L
.23127 .50596 L
.23153 .51258 L
.23197 .51922 L
.2326 .52592 L
.23376 .53519 L
.23527 .54463 L
.23714 .55429 L
.23939 .56423 L
.24202 .57449 L
.24505 .58512 L
Mistroke
.24848 .59616 L
.25235 .60767 L
.25718 .62105 L
.26149 .63226 L
.26619 .64384 L
.27069 .65439 L
.27456 .66307 L
.27864 .67186 L
.28294 .68071 L
.28746 .68955 L
.29219 .69833 L
.29713 .70697 L
.30228 .71537 L
.30763 .72345 L
.31318 .7311 L
.3189 .73823 L
.32479 .74473 L
.32951 .74934 L
.33432 .75348 L
.33919 .75713 L
.34414 .76026 L
.34914 .76287 L
.35418 .76497 L
.35926 .76655 L
.36436 .76765 L
.36948 .76831 L
.37461 .76856 L
.37974 .76845 L
.38487 .76805 L
.38998 .76742 L
.3958 .7665 L
.4016 .76546 L
.40738 .7644 L
.41313 .76341 L
.41886 .76259 L
.42458 .762 L
.43029 .76173 L
.43599 .76181 L
.44256 .7624 L
.44915 .76355 L
.45577 .76528 L
.46245 .76757 L
.46919 .77038 L
.476 .77362 L
.4829 .77719 L
.48989 .78098 L
.49698 .78482 L
.50416 .78856 L
.51144 .79201 L
.51879 .795 L
Mistroke
.52622 .79737 L
.53369 .79895 L
.54119 .79964 L
.5487 .79934 L
.55618 .79802 L
.56229 .79617 L
.56835 .79366 L
.57435 .79053 L
.58028 .78685 L
.58614 .78268 L
.5919 .77811 L
.59756 .77322 L
.60312 .7681 L
.60858 .76285 L
.61392 .75755 L
.61916 .75226 L
.62543 .74593 L
.63153 .73985 L
.63749 .73411 L
.64331 .72877 L
.649 .72389 L
.65458 .71947 L
.66005 .71554 L
.66542 .71209 L
.67072 .70908 L
.67742 .70582 L
.68403 .70313 L
.69056 .70089 L
.69702 .69894 L
.70342 .69713 L
.70977 .69527 L
.71605 .69321 L
.72225 .69076 L
.72837 .68778 L
.73557 .68331 L
.74119 .67892 L
.74666 .67373 L
.75195 .6677 L
.75704 .66082 L
.76191 .65309 L
.76653 .64456 L
.77087 .63527 L
.77491 .62529 L
.77863 .61469 L
.78201 .60354 L
.78504 .59193 L
.78771 .57992 L
.79058 .56398 L
.79241 .55103 L
.79382 .53789 L
Mistroke
.79467 .52686 L
.79524 .51576 L
.7955 .50463 L
.79548 .49348 L
.79516 .48235 L
.79455 .47126 L
.79365 .46025 L
.79245 .44933 L
.79097 .43854 L
.79016 .4334 L
.78928 .4283 L
.78834 .42325 L
.78733 .41826 L
.78626 .41331 L
.78513 .40843 L
.78394 .40362 L
.78268 .39887 L
.77949 .38801 L
.77599 .37763 L
.77218 .36782 L
.76809 .35863 L
.76373 .35012 L
.75913 .34235 L
.75431 .33535 L
.74929 .32914 L
.7441 .32372 L
.73876 .31907 L
.73328 .31514 L
.7277 .31186 L
.72204 .30915 L
.71629 .30688 L
.71049 .30495 L
.70463 .30322 L
.69872 .30154 L
.69276 .2998 L
.68699 .29793 L
.68116 .29576 L
Mfstroke
.02 w
.2325 .475 Mdot
.5 Mabswid
.68699 .29793 m
.68116 .29576 L
s
% Start of user PostScript
3.7397384 -4.0414544 3.6231461 -4.0848361 MAarrowhead1
% End of user PostScript
.533 0 1 r
.78467 .69377 m
.78613 .69087 L
.78756 .68793 L
.78905 .68477 L
.79051 .68157 L
.79195 .67831 L
.79209 .67799 L
.79223 .67766 L
.79237 .67733 L
.79252 .677 L
.79253 .67697 L
.79254 .67694 L
.79256 .6769 L
.79256 .67689 L
.79257 .67687 L
.79258 .67685 L
.79259 .67684 L
.79259 .67682 L
.79684 .66643 L
.80174 .6531 L
.80744 .63541 L
.81364 .61241 L
.81675 .59871 L
.81945 .58496 L
.82175 .57119 L
.82364 .55741 L
.82513 .54365 L
.82621 .52991 L
.82689 .51618 L
.82717 .50246 L
.82704 .48874 L
.82633 .47203 L
.82503 .45529 L
.82362 .44242 L
.82186 .42953 L
.81974 .41665 L
.81727 .40378 L
.81444 .39095 L
.81126 .37821 L
.80773 .36559 L
.80386 .35317 L
.79965 .34101 L
.7951 .3292 L
.79024 .31783 L
.78507 .30702 L
.77961 .29685 L
.77389 .28744 L
.76791 .27886 L
.76171 .27119 L
.75532 .26447 L
Mistroke
.74875 .25872 L
.74203 .25391 L
.7352 .24998 L
.72827 .24683 L
.72126 .24433 L
.71419 .24233 L
.70707 .24065 L
.6999 .23911 L
.69269 .23751 L
.68544 .23568 L
.67921 .23381 L
.67293 .23157 L
.66659 .22889 L
.66019 .22572 L
.65371 .22202 L
.64713 .21779 L
.64044 .21304 L
.63364 .20784 L
.62672 .20224 L
.61965 .19636 L
.61245 .19032 L
.60511 .18427 L
.59762 .17839 L
.59 .17286 L
.58226 .16785 L
.57538 .16403 L
.56844 .16085 L
.56143 .15838 L
.55438 .15667 L
.54731 .15577 L
.54022 .15565 L
.53314 .15629 L
.52609 .15763 L
.51906 .15956 L
.51084 .16247 L
.50269 .16586 L
.49463 .16952 L
.48666 .17324 L
.47878 .17681 L
.47098 .18006 L
.46326 .18286 L
.45559 .1851 L
.44798 .18672 L
.44039 .1877 L
.43282 .18806 L
.42525 .18786 L
.41889 .18733 L
.41252 .18655 L
.40612 .18561 L
.39971 .18462 L
Mistroke
.39328 .18368 L
.38683 .18291 L
.38036 .18241 L
.37389 .1823 L
.36742 .18268 L
.36097 .18363 L
.35454 .18522 L
.34815 .18748 L
.34182 .19045 L
.33555 .19412 L
.32936 .19848 L
.32327 .20347 L
.31729 .20905 L
.31012 .21657 L
.30316 .2247 L
.2964 .23329 L
.28986 .24217 L
.28354 .2512 L
.27745 .26024 L
.27158 .26917 L
.26593 .2779 L
.2605 .28635 L
.25382 .29672 L
.24747 .30645 L
.23999 .31764 L
.23293 .32782 L
.22626 .33707 L
.21994 .34548 L
.21394 .3532 L
.20823 .36037 L
.20281 .36714 L
.19764 .37366 L
.19274 .38007 L
.18809 .38648 L
.1837 .39303 L
.17957 .39979 L
.17572 .40684 L
.17215 .41423 L
.16889 .42201 L
.16594 .43018 L
.16435 .43522 L
.16288 .4404 L
.16153 .4457 L
.1603 .45113 L
.15921 .45667 L
.15825 .46232 L
.15743 .46805 L
.15674 .47386 L
.15619 .47974 L
.1555 .49199 L
Mistroke
.15541 .50433 L
.15592 .51662 L
.15703 .52873 L
.15872 .54054 L
.16098 .55194 L
.16378 .56284 L
.1671 .57318 L
.17091 .58293 L
.17518 .5921 L
.17838 .59812 L
.18178 .60392 L
.18537 .60954 L
.18915 .61502 L
.19312 .62044 L
.19726 .62585 L
.20159 .63133 L
.2061 .63697 L
.21081 .64286 L
.21572 .64908 L
.22 .6546 L
.22444 .66048 L
.22905 .66676 L
.23384 .67347 L
.23883 .68066 L
.24403 .68836 L
.24945 .69656 L
.25511 .70527 L
.26102 .71445 L
.2672 .72406 L
.27365 .734 L
.28039 .74416 L
.28741 .75438 L
.29472 .76449 L
.30231 .77426 L
.31017 .78348 L
.31828 .79192 L
.32661 .79935 L
.33514 .80561 L
.34268 .81 L
.35032 .81337 L
.35802 .81572 L
.36578 .81713 L
.37355 .81769 L
.38133 .81754 L
.3891 .81685 L
.39685 .81581 L
.40457 .81463 L
.41226 .81349 L
.41993 .81257 L
.42758 .81203 L
Mistroke
.43522 .81199 L
.44355 .81263 L
.4519 .81403 L
.4603 .81621 L
.46877 .81909 L
.47733 .82256 L
.48598 .82645 L
.49475 .83053 L
.50361 .83454 L
.51259 .8382 L
.52165 .84121 L
.53078 .84333 L
.53995 .84434 L
.54914 .84407 L
.55829 .84248 L
.56739 .83957 L
.5764 .83544 L
.58528 .83028 L
.59401 .8243 L
.60257 .81776 L
.61095 .81093 L
.61916 .80406 L
.62717 .79738 L
.63502 .79108 L
.64271 .7853 L
.65025 .78015 L
.6568 .77616 L
.66326 .7727 L
.66965 .76976 L
.67598 .76729 L
.68225 .76524 L
.68848 .76352 L
.69467 .76204 L
.70083 .76069 L
.70696 .75937 L
.71439 .75761 L
.72176 .75551 L
.72816 .75321 L
.7345 .75038 L
.74076 .74689 L
.74692 .74269 L
.75296 .73771 L
.75888 .73193 L
.76463 .72535 L
.77021 .71799 L
.7756 .70988 L
.78077 .7011 L
.78571 .69171 L
.79177 .67872 L
.79712 .66571 L
Mistroke
.80206 .65218 L
.80657 .63827 L
.81065 .62409 L
.81428 .60973 L
.81746 .59527 L
.8202 .58075 L
.82248 .56622 L
.82474 .5477 L
.82591 .53437 L
.8267 .52105 L
.82711 .50774 L
.82714 .49444 L
.82679 .48114 L
.82606 .46782 L
.82495 .45449 L
.82346 .44114 L
.82159 .42778 L
.81963 .41604 L
.81738 .40432 L
.81483 .39263 L
.81199 .381 L
.80886 .36946 L
.80544 .35807 L
.80173 .34688 L
.79775 .33594 L
.7935 .32532 L
.78899 .3151 L
.78422 .30536 L
.77922 .29617 L
.77281 .2858 L
.76704 .2777 L
.76106 .27045 L
.7549 .26407 L
.74858 .25859 L
.74213 .25397 L
.73557 .25017 L
.72892 .24709 L
.72219 .24463 L
.71541 .24265 L
.70858 .24099 L
.70171 .23949 L
.69479 .23799 L
.68604 .23584 L
.67721 .23314 L
.67102 .23081 L
.66478 .22804 L
.65847 .22478 L
.65208 .22102 L
.6456 .21674 L
.63901 .21198 L
Mistroke
.63231 .20678 L
.62548 .20122 L
.61852 .1954 L
.61209 .19001 L
.60554 .18463 L
.59889 .17936 L
.59212 .17435 L
.58526 .16971 L
.5783 .16558 L
.57127 .16206 L
.56416 .15925 L
.55701 .15722 L
.54982 .156 L
.54261 .15561 L
.53541 .15601 L
.52758 .15729 L
.51978 .15934 L
.51204 .16201 L
.50437 .16513 L
.49677 .16853 L
.48925 .17203 L
.48181 .17546 L
.47445 .17866 L
.46716 .18151 L
.4606 .18371 L
.45408 .18547 L
.4476 .18679 L
.44114 .18763 L
.43469 .18803 L
.42825 .188 L
.4218 .18761 L
.41534 .18692 L
.40748 .18582 L
.3996 .1846 L
.39369 .18374 L
.38778 .183 L
.38185 .18249 L
.37591 .18229 L
.36997 .18247 L
.36404 .18311 L
.35813 .18425 L
.35224 .18595 L
.34639 .18823 L
.34059 .19111 L
.33485 .19458 L
.32991 .19806 L
.32504 .20196 L
.32022 .20623 L
.31549 .21086 L
.31083 .21579 L
Mistroke
.30625 .22099 L
.30176 .22642 L
.29774 .23152 L
.29381 .23674 L
.28995 .24204 L
.28617 .24739 L
.28247 .25277 L
.27884 .25814 L
.2746 .26455 L
.27047 .27088 L
.26646 .27709 L
.26173 .28444 L
.25614 .29314 L
.25076 .30143 L
.24456 .31085 L
.23864 .31961 L
.233 .32772 L
.2276 .33523 L
.22244 .34219 L
.21749 .34866 L
.21274 .35472 L
.20818 .36044 L
.20273 .36724 L
.19754 .37379 L
.19261 .38023 L
.18795 .38669 L
.18492 .39114 L
.18202 .39569 L
.17924 .40035 L
.1766 .40515 L
.17408 .41011 L
.17171 .41523 L
.16947 .42054 L
.16772 .4251 L
.16607 .4298 L
.16453 .43462 L
.1631 .43956 L
.16179 .44463 L
.16059 .4498 L
.1601 .45211 L
.15963 .45444 L
.15919 .45678 L
.15877 .45914 L
.15838 .46153 L
.15819 .46272 L
.15801 .46392 L
.15783 .46513 L
.15766 .46633 L
.15761 .46672 L
.15755 .4671 L
Mistroke
.1575 .46748 L
.1575 .46749 L
.1575 .4675 L
.1575 .46751 L
.1575 .46752 L
.15745 .4679 L
.1574 .46828 L
.15735 .46867 L
.1572 .46985 L
.15706 .47103 L
.15692 .47221 L
.15679 .4734 L
.15654 .47578 L
.15632 .47817 L
.15612 .48057 L
.15595 .48298 L
.1558 .4854 L
.15554 .49087 L
.1554 .49636 L
.15537 .50074 L
.15542 .50512 L
.15555 .50949 L
.15575 .51385 L
.15603 .51819 L
.15638 .52251 L
.15717 .5299 L
.15817 .53717 L
.15939 .5443 L
.16082 .55126 L
.16246 .55804 L
.1643 .56461 L
.16607 .57021 L
.16799 .57563 L
.17005 .58089 L
.17224 .58597 L
.17457 .59089 L
.17702 .59565 L
.1796 .60027 L
.1823 .60476 L
.18511 .60914 L
.18867 .61434 L
.19239 .61947 L
.19628 .62459 L
.20033 .62975 L
.20455 .63504 L
.20894 .64051 L
.21351 .64625 L
.21826 .65234 L
.22322 .65885 L
.22839 .66584 L
Mistroke
.23379 .6734 L
.23944 .68156 L
.24536 .69036 L
.25158 .69982 L
.25685 .70798 L
.26235 .71652 L
.26236 .71654 L
.26237 .71655 L
.26238 .71657 L
.26239 .71658 L
.2624 .7166 L
.26242 .71663 L
.26244 .71666 L
.26246 .71669 L
.26265 .717 L
.26285 .7173 L
.26305 .71761 L
.26325 .71792 L
.26524 .72101 L
.26725 .72415 L
.2693 .72731 L
.27138 .73051 L
.27348 .73374 L
.27676 .73872 L
.28011 .74375 L
.28353 .74879 L
.28702 .75382 L
.28985 .75782 L
.29273 .76179 L
.29565 .76573 L
.29861 .7696 L
.30162 .77341 L
.30413 .77648 L
.30666 .77949 L
.30923 .78243 L
.31182 .78529 L
.31443 .78806 L
.3175 .79115 L
.3206 .79411 L
.32373 .79692 L
.32688 .79957 L
.33007 .80206 L
.33328 .80436 L
.33781 .80728 L
.34237 .80984 L
.34697 .81202 L
.3516 .81383 L
.35626 .81527 L
.36093 .81636 L
.36542 .81709 L
Mistroke
.36992 .81753 L
.37443 .8177 L
.37893 .81765 L
.38343 .8174 L
.38793 .81698 L
.39242 .81644 L
.39909 .81548 L
.40574 .81445 L
.41237 .81347 L
.41898 .81266 L
.42558 .81212 L
.43216 .81194 L
.43875 .81217 L
.44535 .81287 L
.45316 .81431 L
.46101 .81642 L
.46892 .81914 L
.47691 .82238 L
.48498 .82599 L
.49314 .82979 L
.5014 .83357 L
.50975 .8371 L
.51652 .8396 L
.52333 .84168 L
.53018 .84323 L
.53706 .84415 L
.54394 .84438 L
.55082 .84388 L
.55769 .84263 L
.56452 .84063 L
.57131 .83792 L
.57803 .83457 L
.58469 .83065 L
.59125 .82627 L
.59773 .82152 L
.60411 .81653 L
.61104 .81086 L
.61785 .80516 L
.62453 .79957 L
.63109 .7942 L
.63754 .78914 L
.64387 .78447 L
.65011 .78024 L
.65626 .77647 L
.66408 .7723 L
.67037 .76945 L
.67661 .76707 L
.68279 .76508 L
.68893 .7634 L
.69503 .76196 L
Mistroke
.70111 .76063 L
.70715 .75933 L
.71316 .75792 L
.71913 .75631 L
.72507 .75438 L
.73095 .75204 L
.73678 .74919 L
.74253 .74577 L
.7482 .74171 L
.75434 .73645 L
.76035 .73035 L
.76618 .72341 L
.77182 .71567 L
.77726 .70717 L
.78247 .69799 L
.78743 .6882 L
.79214 .67788 L
.79657 .66712 L
.80073 .656 L
.80459 .64459 L
.80816 .63296 L
.81142 .62118 L
.81438 .60928 L
.81704 .59732 L
.81939 .58531 L
.82143 .57329 L
.82315 .56126 L
.82457 .54925 L
.82569 .53724 L
.82658 .52361 L
.82707 .50998 L
.82716 .49637 L
.82685 .48275 L
.82615 .46912 L
.82505 .45547 L
.82355 .44181 L
.82165 .42814 L
.81935 .41447 L
.8161 .39828 L
.81229 .38218 L
.80793 .36626 L
.80302 .35064 L
.79757 .33546 L
.79161 .32091 L
.78516 .30719 L
.77825 .29449 L
.77092 .28302 L
.76321 .27293 L
.75518 .26434 L
.74786 .25803 L
Mistroke
.74037 .25287 L
.73417 .24946 L
.72789 .24668 L
.72156 .24443 L
.71517 .24259 L
.70874 .24103 L
.70227 .23961 L
.69577 .23821 L
.68923 .23667 L
.68265 .23488 L
.6749 .23232 L
.66708 .22911 L
.65915 .22516 L
.65109 .22039 L
.64289 .21483 L
.63451 .20852 L
.62594 .2016 L
.61716 .19426 L
.60816 .18676 L
.60055 .18065 L
.59279 .17482 L
.58489 .16948 L
.57688 .16481 L
.56876 .16098 L
.56056 .15812 L
.5523 .15633 L
.54402 .15562 L
.53573 .15598 L
.52746 .15732 L
.51924 .15951 L
.51107 .16238 L
.50298 .16574 L
.49498 .16936 L
.48706 .17305 L
.48033 .17612 L
.47366 .17899 L
.46705 .18155 L
.46049 .18374 L
.45397 .1855 L
.44748 .18681 L
.44101 .18765 L
.43455 .18803 L
.4281 .18799 L
.42028 .18747 L
.41244 .18654 L
.40458 .18537 L
.39668 .18416 L
.38876 .18311 L
.38081 .18243 L
.37286 .18233 L
Mistroke
.36491 .18298 L
.35699 .18454 L
.34911 .18709 L
.34132 .19071 L
.33363 .1954 L
.32607 .20109 L
.31867 .20771 L
.31144 .21512 L
.3044 .22319 L
.29758 .23174 L
.29097 .24062 L
.28459 .24968 L
.27843 .25876 L
.2725 .26776 L
.2668 .27657 L
.26131 .2851 L
.25603 .29331 L
.25095 .30114 L
.24606 .30858 L
.24136 .31561 L
.23601 .32342 L
.23089 .33069 L
.22597 .33745 L
.22125 .34376 L
.21671 .34966 L
.21234 .35522 L
.20812 .36051 L
.20407 .36557 L
.20016 .37047 L
.19574 .37612 L
.19152 .38171 L
.18749 .38734 L
.18366 .39308 L
.18004 .39898 L
.17662 .4051 L
.17342 .41148 L
.17045 .41814 L
.16772 .4251 L
.16477 .43385 L
.16219 .44302 L
.16 .45258 L
.15823 .46248 L
.15687 .47267 L
.15594 .48306 L
.15545 .49359 L
.15541 .50418 L
.1558 .51472 L
.1559 .5163 L
.15601 .51787 L
.15612 .51943 L
Mistroke
.15625 .521 L
.15639 .52256 L
.15653 .52411 L
.15669 .52566 L
.15686 .52721 L
.15756 .53293 L
.15839 .53857 L
.15936 .54412 L
.16045 .54957 L
.16167 .55491 L
.16302 .56013 L
.16448 .56522 L
.16669 .57203 L
.16912 .57857 L
.17175 .58486 L
.17458 .59091 L
.1776 .59671 L
.1808 .60231 L
.18418 .60773 L
.18774 .61301 L
.19146 .61821 L
.19535 .62338 L
.20111 .63073 L
.2072 .63834 L
.21192 .64425 L
.21683 .6505 L
.22101 .65593 L
.22534 .6617 L
.22984 .66785 L
.2345 .67442 L
.23936 .68144 L
.24441 .68892 L
.24967 .69689 L
.25655 .70751 L
.25656 .70752 L
.25657 .70754 L
.25658 .70755 L
.25659 .70757 L
.2566 .70758 L
.25662 .70761 L
.25664 .70764 L
.25666 .70767 L
.25686 .70798 L
.25705 .70829 L
.25725 .70859 L
.25745 .7089 L
.25945 .71201 L
.26147 .71516 L
.26353 .71836 L
.26562 .72161 L
Mistroke
.26774 .7249 L
.271 .72994 L
.27434 .73506 L
.27776 .74023 L
.28125 .74543 L
.28481 .75065 L
.28845 .75585 L
.29267 .76171 L
.29698 .76748 L
.30138 .77311 L
.30588 .77857 L
.31046 .78381 L
.31513 .78878 L
.31988 .79344 L
.32469 .79776 L
.32958 .80169 L
.33453 .80521 L
.34026 .8087 L
.34605 .81161 L
.35189 .81393 L
.35776 .81566 L
.36367 .81684 L
.36959 .8175 L
.37551 .81771 L
.38144 .81753 L
.38737 .81704 L
.39328 .81632 L
.39917 .81546 L
.40706 .81424 L
.41492 .81313 L
.42138 .81243 L
.42783 .81202 L
.43428 .81196 L
.44074 .81233 L
.4472 .81315 L
.45369 .81443 L
.4602 .81617 L
.46676 .81835 L
.47337 .82089 L
.48003 .82374 L
.48675 .82681 L
.49502 .83066 L
.50338 .83444 L
.51039 .83735 L
.51746 .83992 L
.52457 .842 L
.53173 .84349 L
.53891 .84428 L
.54609 .84431 L
.55327 .84352 L
Mistroke
.56042 .84192 L
.56753 .83951 L
.57459 .83637 L
.58157 .83256 L
.58846 .82819 L
.59526 .82338 L
.60196 .81825 L
.60933 .81228 L
.61656 .80624 L
.6224 .80134 L
.62815 .79659 L
.63381 .79204 L
.63938 .78775 L
.64487 .78377 L
.65029 .78012 L
.65565 .77682 L
.66094 .77389 L
.66735 .77077 L
.67368 .76814 L
.67997 .76594 L
.6862 .76412 L
.6924 .76256 L
.69856 .76118 L
.70468 .75987 L
.71078 .7585 L
.71752 .75678 L
.72307 .75508 L
.72859 .75304 L
.73405 .7506 L
.73946 .74768 L
.7448 .74423 L
.75006 .74022 L
.75522 .73562 L
.76028 .73042 L
.76522 .72462 L
.77003 .71825 L
.77469 .71132 L
.77919 .70388 L
.78353 .69597 L
.78752 .688 L
.79134 .67969 L
.79499 .67108 L
.79845 .66222 L
.80173 .65314 L
.80482 .64388 L
.80771 .63449 L
.8104 .62499 L
.81332 .61373 L
.81595 .60239 L
.81831 .59101 L
Mistroke
.82039 .57961 L
.8222 .56819 L
.82372 .55678 L
.82497 .54538 L
.82593 .53399 L
.82669 .52112 L
.8271 .50826 L
.82715 .49541 L
.82685 .48255 L
.82619 .46969 L
.82517 .45681 L
.82381 .44392 L
.82232 .43267 L
.82057 .42142 L
Mfstroke
.02 w
.1575 .4675 Mdot
.5 Mabswid
.82232 .43267 m
.82057 .42142 L
s
% Start of user PostScript
6.446428 -1.3465366 6.4113443 -1.5715375 MAarrowhead1
% End of user PostScript
1 0 1 r
.6993 .45047 m
.69821 .44926 L
.69711 .44803 L
.69481 .44552 L
.69198 .44246 L
.68898 .43922 L
.68582 .43572 L
.68247 .43191 L
.67892 .4277 L
.6765 .42473 L
.67398 .42153 L
.67135 .41808 L
.6686 .41436 L
.66572 .41034 L
.66271 .406 L
.65955 .40131 L
.65623 .39625 L
.65274 .3908 L
.64963 .38586 L
.64638 .38062 L
.64298 .37508 L
.63942 .36923 L
.6357 .3631 L
.6318 .35669 L
.62772 .35003 L
.62345 .34316 L
.61899 .33611 L
.61322 .32729 L
.60794 .31958 L
.60244 .31196 L
.59671 .30456 L
.59076 .29753 L
.58462 .291 L
.57828 .28514 L
.57178 .28008 L
.56515 .27595 L
.55841 .27286 L
.55159 .27086 L
.54473 .26999 L
.53785 .27021 L
.531 .27147 L
.52421 .27368 L
.51749 .27668 L
.51087 .28033 L
.50437 .28446 L
.49799 .2889 L
.48926 .29534 L
.48079 .30163 L
.47258 .30742 L
.46459 .31244 L
Mistroke
.4568 .31649 L
.44916 .31946 L
.44161 .32133 L
.43511 .32208 L
.42863 .32208 L
.42213 .32141 L
.4156 .32022 L
.40902 .31866 L
.40237 .3169 L
.39566 .31516 L
.3889 .31365 L
.38208 .3126 L
.37524 .31222 L
.3684 .31274 L
.36159 .3143 L
.35487 .31705 L
.34827 .32107 L
.34184 .32637 L
.33562 .33294 L
.32967 .34071 L
.32402 .34956 L
.31871 .35937 L
.31377 .37 L
.30924 .3813 L
.30512 .39313 L
.30145 .40538 L
.29822 .41794 L
.29547 .43072 L
.29317 .44366 L
.29136 .45669 L
.29002 .4698 L
.28927 .48065 L
.28885 .49151 L
.28876 .50238 L
.289 .51325 L
.28956 .52411 L
.29045 .53495 L
.29166 .54576 L
.2932 .55652 L
.29507 .56721 L
.29772 .57991 L
.30084 .5924 L
.3044 .60461 L
.30767 .61439 L
.31122 .62385 L
.31505 .6329 L
.31914 .64148 L
.32348 .64951 L
.32805 .65691 L
.33282 .6636 L
Mistroke
.33779 .66953 L
.34292 .67463 L
.3482 .67888 L
.35358 .68227 L
.35905 .68481 L
.36585 .68681 L
.37269 .6877 L
.37854 .68769 L
.38438 .68712 L
.3902 .68609 L
.39598 .68476 L
.40172 .68327 L
.4074 .68176 L
.41305 .68035 L
.41865 .67916 L
.42422 .67831 L
.42904 .6779 L
.43385 .67786 L
.43866 .67823 L
.44349 .67903 L
.44835 .68029 L
.45325 .682 L
.4582 .68417 L
.46322 .68678 L
.4674 .68924 L
.47165 .69196 L
.47596 .6949 L
.48034 .69804 L
.48479 .70132 L
.48931 .7047 L
.49391 .70812 L
.49858 .71152 L
.50333 .71484 L
.50816 .718 L
.51305 .72094 L
.518 .72357 L
.52301 .72584 L
.52806 .72768 L
.53315 .72903 L
.53826 .72983 L
.54339 .73006 L
.54851 .72967 L
.55362 .72866 L
.5587 .72703 L
.56373 .72479 L
.56871 .72196 L
.57362 .71859 L
.57845 .71472 L
.58318 .7104 L
.58782 .7057 L
Mistroke
.59235 .70067 L
.59676 .69537 L
.60105 .68988 L
.60522 .68425 L
.60926 .67853 L
.61397 .67158 L
.6185 .66465 L
.62283 .65783 L
.62699 .65115 L
.63097 .64467 L
.63478 .63842 L
.63842 .63242 L
.6419 .62669 L
.64524 .62124 L
.64843 .61607 L
.65114 .61173 L
.65375 .60761 L
.65626 .60371 L
.65868 .6 L
.66101 .5965 L
.66327 .59318 L
.66588 .58943 L
.66839 .58592 L
.6708 .58265 L
.67312 .57958 L
.67536 .5767 L
.67795 .57348 L
.68043 .57048 L
.68351 .56689 L
.68691 .56307 L
.69011 .55956 L
.69313 .55629 L
.69599 .5532 L
.69773 .55128 L
.69941 .54939 L
.70103 .54753 L
.70259 .54566 L
.70408 .5438 L
.70551 .54192 L
.70688 .54002 L
.70904 .53675 L
.71102 .53336 L
.7128 .52985 L
.71437 .52621 L
.71574 .52242 L
.7169 .51851 L
.71783 .51447 L
.71852 .51035 L
.719 .50595 L
.71922 .50152 L
Mistroke
.71918 .49707 L
.71888 .49264 L
.71832 .48827 L
.7175 .48399 L
.71644 .47982 L
.71513 .47579 L
.71318 .47097 L
.71088 .46639 L
.70935 .46375 L
.70769 .46117 L
.70593 .45865 L
.70406 .45617 L
.70208 .45372 L
.69999 .45127 L
.69779 .44879 L
.69549 .44626 L
.69307 .44364 L
.69108 .44149 L
.68901 .43925 L
.68687 .43689 L
.68464 .43439 L
.68232 .43174 L
.67991 .42889 L
.67739 .42583 L
.67476 .42254 L
.67288 .4201 L
.67093 .41753 L
.66892 .41481 L
.66684 .41193 L
.6647 .40888 L
.66247 .40565 L
.66017 .40224 L
.65766 .39844 L
.65505 .39442 L
.65233 .39016 L
.64951 .38566 L
.64656 .38092 L
.6435 .37592 L
.64069 .37133 L
.63779 .36654 L
.63477 .36158 L
.63165 .35644 L
.6284 .35114 L
.62504 .3457 L
.62156 .34015 L
.61707 .33313 L
.61238 .32604 L
.60846 .32032 L
.60441 .31463 L
.60023 .30905 L
Mistroke
.59594 .30361 L
.59152 .29838 L
.58699 .29343 L
.58236 .28881 L
.57762 .28458 L
.5728 .28081 L
.5679 .27754 L
.56356 .27513 L
.55918 .27316 L
.55476 .27165 L
.55032 .27062 L
.54586 .27005 L
.5414 .26996 L
.53694 .27032 L
.53156 .27134 L
.52621 .27294 L
.5209 .27506 L
.51565 .27763 L
.51046 .28058 L
.50535 .28381 L
.50031 .28725 L
.49536 .29081 L
.49049 .29442 L
.48571 .29799 L
.48101 .30147 L
.47638 .3048 L
.47075 .30864 L
.46522 .31207 L
.45978 .31505 L
.45442 .31753 L
.44913 .31947 L
.44388 .32088 L
.43867 .32177 L
.43348 .32215 L
.42829 .32206 L
.42309 .32155 L
.41788 .32069 L
.41375 .31981 L
.4096 .31881 L
.40543 .31772 L
.40124 .3166 L
.39701 .31549 L
.39277 .31447 L
.3885 .31357 L
.38421 .31286 L
.37991 .31239 L
.3756 .31222 L
.37013 .31251 L
.36467 .31345 L
.36059 .31463 L
Mistroke
.35653 .31625 L
.35252 .31833 L
.34855 .32087 L
.34465 .32387 L
.34082 .32735 L
.33706 .33128 L
.33257 .33673 L
.32823 .34281 L
.32407 .34947 L
.32097 .35499 L
.318 .3608 L
.31515 .36687 L
.31243 .37318 L
.30984 .37969 L
.30739 .38639 L
.30508 .39325 L
.30339 .39867 L
.30179 .40416 L
.30028 .40971 L
.29885 .41532 L
.29752 .42097 L
.29628 .42667 L
.29492 .43358 L
.29368 .44054 L
.29307 .44429 L
.29251 .44805 L
.29198 .45182 L
.29149 .45559 L
.29104 .45937 L
.29081 .46148 L
.29059 .46359 L
.29038 .4657 L
.29019 .46781 L
.29012 .46854 L
.29006 .46926 L
.29 .46998 L
.29 .46999 L
.29 .47 L
.29 .47001 L
.29 .47002 L
.28994 .47074 L
.28988 .47146 L
.28982 .47219 L
.28967 .47432 L
.28954 .47608 L
.28943 .47784 L
.28933 .4796 L
.28923 .48136 L
.28907 .48489 L
.28894 .48841 L
Mistroke
.28884 .49193 L
.28878 .49546 L
.28875 .49899 L
.28875 .499 L
.28875 .49901 L
.28875 .49902 L
.28875 .49904 L
.28875 .49905 L
.28875 .49908 L
.28875 .4991 L
.28875 .49913 L
.28875 .49938 L
.28875 .49964 L
.28875 .4999 L
.28875 .50016 L
.28876 .50274 L
.28879 .50531 L
.28884 .50789 L
.2889 .51047 L
.28902 .51393 L
.28917 .5174 L
.28936 .52086 L
.28957 .52433 L
.28982 .52779 L
.29041 .53461 L
.29113 .54142 L
.29183 .54705 L
.29261 .55267 L
.29348 .55827 L
.29444 .56385 L
.29549 .56941 L
.29662 .57494 L
.29835 .58257 L
.30023 .59012 L
.30228 .59757 L
.30449 .6049 L
.30686 .61209 L
.30939 .61912 L
.31207 .62595 L
.31571 .63437 L
.31959 .64236 L
.32368 .64986 L
.32797 .6568 L
.33245 .66311 L
.3371 .66875 L
.34189 .67368 L
.34681 .67786 L
.35184 .68128 L
.35695 .68394 L
.36213 .68586 L
Mistroke
.36735 .6871 L
.3726 .68769 L
.37786 .68773 L
.38311 .68728 L
.38834 .68646 L
.39354 .68535 L
.3998 .68378 L
.40491 .68242 L
.40999 .6811 L
.41503 .6799 L
.42004 .67892 L
.42503 .67822 L
.43 .67787 L
.43497 .67791 L
.43994 .6784 L
.44648 .67975 L
.45308 .68193 L
.45862 .68437 L
.46425 .68737 L
.46997 .69086 L
.47581 .6948 L
.48177 .69909 L
.48787 .70362 L
.4941 .70826 L
.50048 .71287 L
.50699 .71726 L
.51363 .72127 L
.51914 .72413 L
.52471 .72652 L
.53033 .72835 L
.53599 .72955 L
.54167 .73005 L
.54736 .72981 L
.55303 .72881 L
.55867 .72704 L
.56425 .72452 L
.56976 .72129 L
.57518 .7174 L
.5805 .71291 L
.58571 .7079 L
.59078 .70246 L
.59659 .69558 L
.60127 .68959 L
.60581 .68343 L
.61019 .67718 L
.61442 .6709 L
.6185 .66465 L
.62243 .65847 L
.62621 .65242 L
.62984 .64652 L
Mistroke
.63477 .63843 L
.63942 .63076 L
.64301 .62487 L
.64644 .61929 L
.64971 .61401 L
.65284 .60904 L
.65583 .60436 L
.6587 .59997 L
.66145 .59586 L
.66408 .59201 L
.66722 .58754 L
.67022 .58344 L
.67307 .57965 L
.6758 .57615 L
.6784 .57292 L
.6809 .56992 L
.6833 .56713 L
.68561 .56452 L
.68827 .56156 L
.69081 .55879 L
.69324 .55617 L
.69557 .55366 L
.69778 .55122 L
.6999 .54884 L
.70191 .54648 L
.70383 .54412 L
.70565 .54174 L
.70793 .53848 L
.71003 .53512 L
.71193 .53163 L
.71363 .52801 L
.71512 .52425 L
.71639 .52035 L
.71743 .51632 L
.71824 .51219 L
.71882 .50797 L
.71915 .50369 L
.71924 .49938 L
.71908 .49508 L
.71853 .48973 L
.71761 .48449 L
.71632 .47942 L
.71467 .47455 L
.71268 .4699 L
.71036 .46547 L
.70774 .46124 L
.70482 .45715 L
.70161 .45315 L
.69811 .44914 L
.69432 .44499 L
Mistroke
.69023 .44057 L
.6858 .4357 L
.681 .4302 L
.67579 .42383 L
.67007 .41637 L
.66489 .40915 L
.65924 .40084 L
.65306 .39131 L
.64758 .38256 L
.64166 .37291 L
.63597 .36355 L
.62987 .35353 L
.62471 .34517 L
.61926 .33653 L
.61351 .32773 L
.60745 .31888 L
.6011 .31018 L
.59445 .30181 L
.58752 .29399 L
.58159 .28808 L
.57549 .28284 L
.56925 .27838 L
.56291 .2748 L
.55647 .27218 L
.54997 .27055 L
.54344 .26995 L
.53691 .27032 L
.5304 .27163 L
.52394 .27378 L
.51756 .27665 L
.51126 .2801 L
.50507 .284 L
.49899 .28819 L
.49304 .29253 L
.4872 .29688 L
.48149 .30112 L
.4759 .30514 L
.47042 .30885 L
.46504 .31218 L
.45974 .31507 L
.45453 .31748 L
.44937 .31939 L
.44426 .3208 L
.43799 .32185 L
.43173 .32217 L
.42548 .32183 L
.41921 .32094 L
.41289 .31961 L
.40653 .31801 L
.4001 .3163 L
Mistroke
.39362 .31466 L
.38708 .31331 L
.38051 .31244 L
.37391 .31225 L
.36732 .31291 L
.36003 .31483 L
.35446 .31727 L
.34897 .32057 L
.34896 .32058 L
.34895 .32059 L
.34894 .3206 L
.34893 .3206 L
.34892 .32061 L
.3489 .32063 L
.34887 .32064 L
.34885 .32066 L
.34864 .32081 L
.34842 .32096 L
.3482 .32111 L
.34799 .32127 L
.34584 .3229 L
.34371 .32468 L
.3416 .3266 L
.33951 .32865 L
.33746 .33084 L
.33499 .33369 L
.33257 .33674 L
.33019 .33996 L
.32786 .34337 L
.32558 .34695 L
.32336 .35069 L
.31976 .3573 L
.31633 .36428 L
.31381 .36991 L
.31139 .37573 L
.30908 .38171 L
.30689 .38783 L
.30482 .39407 L
.30286 .40043 L
.30061 .40845 L
.29855 .41659 L
.29705 .42311 L
.29567 .42967 L
.29442 .43628 L
.29329 .44292 L
.29229 .44959 L
.29141 .45627 L
.29065 .46298 L
.28982 .47228 L
.28922 .4816 L
Mistroke
.28887 .49093 L
.28875 .50027 L
.28888 .5096 L
.28925 .51893 L
.28986 .52825 L
.29071 .53755 L
.29239 .55114 L
.29459 .56464 L
.29729 .57799 L
.29988 .58878 L
.30281 .59938 L
.30606 .60973 L
.30963 .61976 L
.31351 .62939 L
.31767 .63853 L
.32212 .64711 L
.32682 .65502 L
.33175 .66219 L
.3369 .66853 L
.34222 .67399 L
.34771 .67853 L
.35332 .68213 L
.35903 .6848 L
.3648 .68658 L
.3696 .68743 L
.37441 .68776 L
.37923 .68765 L
.38403 .68716 L
.38882 .68637 L
.39359 .68534 L
.39833 .68417 L
.40303 .68292 L
.40771 .68168 L
.41235 .68051 L
.41697 .67949 L
.42217 .67858 L
.42735 .67801 L
.43253 .67784 L
.4377 .67812 L
.44289 .67891 L
.44811 .68021 L
.45337 .68205 L
.4587 .68441 L
.4641 .68728 L
.47097 .69151 L
.47801 .69636 L
.48524 .70166 L
.49266 .7072 L
.50029 .71273 L
.50811 .71797 L
Mistroke
.51611 .72261 L
.52426 .72635 L
.53253 .72889 L
.53889 .72989 L
.54525 .72999 L
.55161 .72913 L
.55794 .72731 L
.5642 .72455 L
.57037 .72089 L
.57642 .71641 L
.58235 .7112 L
.58811 .70538 L
.59372 .69907 L
.59914 .69237 L
.60437 .68542 L
.60941 .67832 L
.61424 .67117 L
.61889 .66405 L
.62333 .65703 L
.62758 .65019 L
.63165 .64355 L
.63616 .63615 L
.64043 .62911 L
.64448 .62247 L
.64832 .61624 L
.65197 .6104 L
.65544 .60496 L
.65874 .59991 L
.66189 .59521 L
.66488 .59086 L
.66774 .58682 L
.67048 .58308 L
.67372 .57881 L
.67679 .57491 L
.67971 .57134 L
.6825 .56805 L
.68516 .56501 L
.68771 .56218 L
.689 .56077 L
.68963 .56008 L
.69026 .5594 L
Mfstroke
.02 w
.29 .47 Mdot
.5 Mabswid
.68963 .56008 m
.69026 .5594 L
s
% Start of user PostScript
3.7925808 1.2015922 3.8051078 1.1879872 MAarrowhead1
% End of user PostScript
.502 0 1 r
.55565 .64933 m
.55784 .6482 L
.56001 .6469 L
.56428 .64381 L
.56844 .64006 L
.57249 .63572 L
.57719 .62975 L
.58167 .62309 L
.5859 .61583 L
.58986 .60807 L
.59354 .59992 L
.59693 .59146 L
.60001 .58275 L
.60279 .57388 L
.60524 .5649 L
.60738 .55583 L
.60919 .54672 L
.61068 .53759 L
.61185 .52844 L
.6127 .5193 L
.61322 .51015 L
.6134 .50301 L
.61339 .49588 L
.61317 .48874 L
.61276 .4816 L
.61216 .47447 L
.61135 .46733 L
.61035 .46019 L
.60915 .45306 L
.60742 .44436 L
.60539 .43569 L
.60352 .42868 L
.60146 .42174 L
.59921 .41488 L
.59677 .40813 L
.59415 .40153 L
.59135 .39511 L
.58838 .38891 L
.58524 .38297 L
.58193 .37734 L
.57848 .37206 L
.57489 .3672 L
.57117 .36278 L
.56734 .35887 L
.5634 .3555 L
.55938 .3527 L
.55529 .35051 L
.55162 .34908 L
.54791 .34815 L
.54419 .34771 L
Mistroke
.54047 .34776 L
.53675 .34829 L
.53305 .34927 L
.52938 .35068 L
.52496 .35294 L
.52061 .35572 L
.51636 .35897 L
.5131 .36179 L
.50992 .3648 L
.50681 .36799 L
.50377 .37132 L
.50082 .37475 L
.49794 .37825 L
.49515 .38181 L
.49285 .38483 L
.49062 .38785 L
.48844 .39085 L
.48633 .39384 L
.48427 .3968 L
.48227 .39971 L
.47991 .40319 L
.47763 .40659 L
.47638 .40846 L
.47516 .4103 L
.47397 .4121 L
.47279 .41387 L
.47165 .4156 L
.47148 .41586 L
.4713 .41612 L
.47113 .41637 L
.47096 .41663 L
.47095 .41666 L
.47093 .41668 L
.47091 .41671 L
.4709 .41672 L
.4709 .41673 L
.47089 .41675 L
.47088 .41676 L
.47087 .41677 L
.46613 .42386 L
.46179 .4302 L
.45748 .43621 L
.45353 .44135 L
.44988 .44564 L
.44649 .44914 L
.4433 .4519 L
.44026 .45397 L
.43733 .45538 L
.43448 .45618 L
.43166 .4564 L
Mistroke
.42883 .45608 L
.42597 .45524 L
.42304 .45392 L
.42076 .45263 L
.41841 .4511 L
.41598 .44934 L
.41346 .4474 L
.41084 .44528 L
.40812 .44304 L
.40528 .4407 L
.40233 .43831 L
.39926 .43594 L
.39641 .43387 L
.39348 .4319 L
.39046 .4301 L
.38736 .42852 L
.38421 .42722 L
.381 .42626 L
.37776 .42571 L
.37451 .42562 L
.37126 .42605 L
.36804 .42704 L
.36488 .42863 L
.36181 .43083 L
.35884 .43367 L
.35601 .43715 L
.35492 .43872 L
.35386 .44039 L
.35283 .44215 L
.35183 .44401 L
.35086 .44597 L
.34993 .44801 L
.34904 .45014 L
.34767 .45377 L
.3464 .45761 L
.34525 .46163 L
.34422 .46583 L
.3433 .47018 L
.34252 .47466 L
.34186 .47926 L
.34133 .48395 L
.34082 .49067 L
.34059 .49746 L
.34062 .50428 L
.34093 .51106 L
.34151 .51774 L
.34235 .52427 L
.34345 .53058 L
.3448 .53662 L
.34639 .54234 L
Mistroke
.34868 .54897 L
.3513 .55493 L
.35387 .55962 L
.35663 .56368 L
.35956 .56709 L
.36263 .56983 L
.36581 .5719 L
.36906 .57334 L
.37237 .57415 L
.3757 .5744 L
.37902 .57412 L
.38233 .57339 L
.38559 .57225 L
.38957 .57038 L
.39344 .56812 L
.39717 .5656 L
.40075 .56293 L
.40419 .5602 L
.40747 .5575 L
.4106 .55491 L
.4136 .5525 L
.41646 .5503 L
.41921 .54836 L
.42186 .54672 L
.42443 .5454 L
.42693 .54442 L
.42912 .54386 L
.43128 .54361 L
.43344 .54367 L
.43561 .54407 L
.43781 .54481 L
.44005 .54591 L
.44236 .5474 L
.44475 .54929 L
.44656 .55093 L
.44844 .5528 L
.45038 .55492 L
.45241 .55728 L
.45452 .5599 L
.45674 .56279 L
.45906 .56595 L
.46151 .56939 L
.46382 .57274 L
.46625 .57631 L
.4688 .58012 L
.47148 .58414 L
.47429 .58839 L
.47724 .59283 L
.48034 .59745 L
.4836 .60222 L
Mistroke
.48644 .60632 L
.4894 .61048 L
.49247 .61467 L
.49566 .61885 L
.49896 .62301 L
.50237 .62708 L
.5059 .63103 L
.50952 .6348 L
.51325 .63835 L
.51707 .64161 L
.52098 .64453 L
.52496 .64707 L
.529 .64915 L
.5331 .65075 L
.53723 .65181 L
.54138 .6523 L
.5451 .65223 L
.54882 .65167 L
.55252 .65062 L
.55619 .64907 L
.55981 .64703 L
.56338 .64452 L
.56688 .64155 L
.57113 .63726 L
.57523 .63236 L
.57918 .62691 L
.58296 .62098 L
.58655 .61462 L
.58994 .60791 L
.59312 .60091 L
.59608 .59367 L
.59882 .58624 L
.60134 .57866 L
.60362 .57098 L
.60566 .56323 L
.60785 .5536 L
.60952 .54487 L
.61089 .53613 L
.61197 .52738 L
.61275 .51863 L
.61323 .50989 L
.61342 .50114 L
.61331 .49239 L
.61298 .48501 L
.61245 .47763 L
.61171 .47025 L
.61075 .46287 L
.60959 .4555 L
.60821 .44814 L
.60662 .4408 L
Mistroke
.60483 .4335 L
.60283 .42625 L
.60062 .41908 L
.59821 .41201 L
.59559 .40508 L
.59279 .39832 L
.59009 .39241 L
.58725 .3867 L
.58426 .38125 L
.58114 .37607 L
.57789 .37121 L
.57451 .36672 L
.57103 .36263 L
.56745 .35897 L
.56377 .35579 L
.56003 .35311 L
.55622 .35095 L
.55236 .34933 L
.54847 .34825 L
.54455 .34773 L
.54063 .34775 L
.53672 .34829 L
.53283 .34934 L
.52897 .35086 L
.52516 .35282 L
.52051 .3558 L
.51596 .3593 L
.51153 .36325 L
.50723 .36754 L
.50308 .37211 L
.49907 .37685 L
.49522 .38171 L
.49152 .38661 L
.48798 .3915 L
.4846 .39632 L
.48137 .40104 L
.47737 .40699 L
.47361 .41264 L
.47083 .41684 L
.46818 .42082 L
.46566 .42457 L
.46325 .4281 L
.46096 .43139 L
.45877 .43445 L
.45668 .43729 L
.45503 .43946 L
.45343 .44147 L
.45189 .44334 L
.45039 .44507 L
.44894 .44667 L
Mistroke
.44753 .44813 L
.44657 .44906 L
.44563 .44994 L
.4447 .45076 L
.44379 .45151 L
.44289 .45221 L
.4428 .45228 L
.44271 .45234 L
.44262 .45241 L
.44254 .45247 L
.44253 .45248 L
.44252 .45249 L
.44251 .45249 L
.4425 .4525 L
.4425 .4525 L
.4425 .4525 L
.44249 .45251 L
.44248 .45251 L
.44247 .45252 L
.44246 .45253 L
.44238 .45259 L
.44229 .45265 L
.4422 .45272 L
.44211 .45278 L
.44123 .45337 L
.44037 .4539 L
.43951 .45438 L
.43867 .45481 L
.43782 .45518 L
.43617 .45578 L
.43453 .45617 L
.4333 .45634 L
.43207 .4564 L
.43085 .45636 L
.42961 .45622 L
.42838 .45598 L
.42697 .45559 L
.42554 .45508 L
.42409 .45445 L
.42263 .45371 L
.42113 .45286 L
.41961 .4519 L
.4172 .45024 L
.41469 .44836 L
.41209 .4463 L
.40938 .44408 L
.40656 .44175 L
.40413 .43976 L
.40162 .43775 L
.39902 .43576 L
Mistroke
.39635 .43382 L
.39359 .43198 L
.39077 .43027 L
.38787 .42876 L
.38492 .42748 L
.38192 .4265 L
.37889 .42586 L
.37584 .4256 L
.37279 .42578 L
.37029 .42629 L
.3678 .42714 L
.36536 .42835 L
.36295 .42993 L
.36061 .43189 L
.35835 .43423 L
.35616 .43694 L
.35353 .44095 L
.35107 .44553 L
.34926 .44959 L
.34759 .45398 L
.34608 .45868 L
.34474 .46364 L
.34357 .46884 L
.34258 .47424 L
.34179 .47982 L
.34119 .48552 L
.34079 .49133 L
.34059 .49719 L
.34059 .50255 L
.34075 .50789 L
.34108 .5132 L
.34158 .51843 L
.34225 .52356 L
.34307 .52857 L
.34405 .53341 L
.34541 .53895 L
.34697 .54419 L
.34873 .54908 L
.35066 .5536 L
.35276 .55771 L
.355 .56139 L
.35737 .56462 L
.35985 .56738 L
.36243 .56967 L
.36509 .5715 L
.3678 .57286 L
.37056 .57378 L
.37335 .57428 L
.37615 .57439 L
.37894 .57414 L
Mistroke
.38172 .57356 L
.38447 .57268 L
.38719 .57156 L
.38985 .57023 L
.39247 .56873 L
.39502 .56709 L
.39751 .56535 L
.40032 .56326 L
.40303 .56113 L
.40565 .559 L
.40818 .55691 L
.41062 .5549 L
.41297 .55299 L
.41524 .55121 L
.41744 .54958 L
.41957 .54812 L
.42164 .54684 L
.42366 .54576 L
.42564 .54488 L
.42758 .54423 L
.42984 .54375 L
.43208 .5436 L
.43432 .54379 L
.43658 .54435 L
.43887 .54529 L
.44123 .54663 L
.44367 .54839 L
.44621 .55059 L
.44887 .55326 L
.45114 .55578 L
.45353 .55865 L
.45604 .56186 L
.45869 .56543 L
.4615 .56938 L
.46448 .5737 L
.46765 .5784 L
.47102 .58346 L
.47462 .58888 L
.47844 .59462 L
.48173 .5995 L
.48519 .60452 L
.48881 .60966 L
.49262 .61486 L
.49586 .61911 L
.49922 .62332 L
.50269 .62745 L
.50628 .63144 L
.50998 .63525 L
.51377 .63882 L
.51767 .64208 L
Mistroke
.52164 .64499 L
.5257 .64748 L
.52981 .64951 L
.53398 .65102 L
.53818 .65197 L
.5424 .65233 L
.54661 .65206 L
.55082 .65116 L
.55499 .64963 L
.5591 .64747 L
.56315 .64469 L
.56712 .64133 L
.57098 .63742 L
.57473 .63301 L
.57835 .62813 L
.58156 .62326 L
.58465 .61807 L
.5876 .61261 L
.59041 .60692 L
.59307 .60102 L
.59558 .59496 L
.59793 .58875 L
.60012 .58244 L
.60252 .57478 L
.60469 .56704 L
.60662 .55923 L
.60831 .55138 L
.60976 .5435 L
.61096 .53561 L
.61193 .52772 L
.61266 .51982 L
.6132 .51058 L
.61341 .50134 L
.6133 .4921 L
.61285 .48286 L
.61207 .47362 L
.61096 .46438 L
.60952 .45514 L
.60775 .44593 L
.60566 .43676 L
.60227 .42437 L
.59828 .41223 L
.59371 .40048 L
.58859 .38932 L
.58858 .3893 L
.58857 .38928 L
.58856 .38926 L
.58855 .38924 L
.58854 .38922 L
.58852 .38918 L
Mistroke
.5885 .38914 L
.58848 .3891 L
.58827 .3887 L
.58807 .3883 L
.58787 .38791 L
.58767 .38751 L
.58636 .38502 L
.58502 .38259 L
.58366 .3802 L
.58227 .37788 L
.58085 .37562 L
.57875 .37245 L
.5766 .36944 L
.5744 .36658 L
.57215 .36389 L
.56986 .36138 L
.56753 .35905 L
.56407 .35603 L
.56055 .35345 L
.55697 .35133 L
.55402 .34996 L
.55106 .34891 L
.54807 .34818 L
.54507 .34777 L
.54207 .34768 L
.53907 .3479 L
.53535 .34861 L
.53165 .34976 L
.52871 .35098 L
.52579 .35246 L
.52291 .35418 L
.52007 .35611 L
.51726 .35824 L
.5145 .36055 L
.51178 .36301 L
.50813 .36661 L
.50457 .37042 L
.50113 .37438 L
.49779 .37845 L
.49456 .38258 L
.49144 .38673 L
.48843 .39087 L
.48554 .39497 L
.48197 .40015 L
.47857 .40518 L
.47535 .41001 L
.4723 .41462 L
.4694 .41899 L
.46664 .42311 L
.46403 .42696 L
Mistroke
.46155 .43056 L
.45918 .43388 L
.45693 .43695 L
.45478 .43977 L
.45237 .44276 L
.45008 .44542 L
.44789 .44776 L
.44579 .44979 L
.44377 .45153 L
.44182 .45298 L
.43991 .45416 L
.43805 .45509 L
.43588 .45586 L
.43373 .45629 L
.4316 .4564 L
.42946 .4562 L
.42731 .45569 L
.42513 .45491 L
.4229 .45385 L
.42061 .45254 L
.41616 .44948 L
.41615 .44947 L
.41615 .44947 L
.41614 .44946 L
.41613 .44946 L
.41613 .44945 L
.41611 .44944 L
.4161 .44943 L
.41609 .44942 L
.41596 .44933 L
.41583 .44923 L
.4157 .44913 L
.41556 .44903 L
.4146 .44829 L
.41362 .44752 L
.41263 .44673 L
.41162 .44592 L
.4106 .44508 L
.40862 .44345 L
.40658 .44177 L
.40498 .44045 L
.40334 .43912 L
.40166 .43779 L
.39995 .43646 L
.3982 .43515 L
.39642 .43387 L
.39421 .43237 L
.39195 .43096 L
.38965 .42966 L
.38731 .42849 L
Mistroke
.38493 .42749 L
.38252 .42667 L
.38009 .42606 L
.3772 .42566 L
.3743 .42564 L
.37141 .42602 L
.36855 .42685 L
.36572 .42814 L
.36296 .42993 L
.36027 .43221 L
.35768 .435 L
.35521 .43829 L
.35288 .44206 L
.35071 .4463 L
.34871 .45097 L
.3469 .45605 L
.34529 .46149 L
.3439 .46725 L
.34274 .47329 L
.34182 .47955 L
.34115 .48597 L
.34073 .49252 L
.34062 .49583 L
.34057 .49915 L
.34058 .50247 L
.34067 .50579 L
.34081 .50909 L
.34102 .51238 L
.34136 .51632 L
.34179 .5202 L
.34231 .52403 L
.34293 .52778 L
.34363 .53144 L
.34441 .53501 L
.34581 .54039 L
.3474 .54546 L
.34917 .5502 L
.35112 .55456 L
.35321 .55852 L
.35545 .56205 L
.3578 .56514 L
.36027 .56779 L
.36224 .56952 L
.36325 .57029 L
.36427 .57098 L
Mfstroke
.02 w
.4425 .4525 Mdot
.5 Mabswid
.36325 .57029 m
.36427 .57098 L
s
% Start of user PostScript
-2.7350093 1.4057509 -2.7146849 1.4196964 MAarrowhead1
% End of user PostScript
.592 1 0 r
.36031 .53585 m
.36102 .53709 L
.36175 .53825 L
.36301 .54002 L
.36433 .54159 L
.36569 .54297 L
.36709 .54415 L
.36853 .54512 L
.37034 .54606 L
.37219 .54669 L
.37356 .54698 L
.37494 .54711 L
.37633 .54711 L
.37771 .54696 L
.37908 .54668 L
.38044 .54627 L
.38125 .54597 L
.38206 .54563 L
.38286 .54526 L
.38365 .54484 L
.38443 .5444 L
.38455 .54432 L
.38466 .54425 L
.38478 .54418 L
.3849 .54411 L
.38491 .5441 L
.38492 .54409 L
.38493 .54409 L
.38494 .54408 L
.38494 .54408 L
.38495 .54408 L
.38495 .54407 L
.38496 .54407 L
.38823 .54167 L
.39129 .5388 L
.3946 .535 L
.39754 .53088 L
.40012 .52659 L
.4023 .52222 L
.40409 .51784 L
.40549 .51348 L
.4065 .50916 L
.40713 .50488 L
.40738 .50061 L
.40731 .49746 L
.40704 .4943 L
.40656 .49113 L
.40587 .48794 L
.40496 .48473 L
.40384 .48149 L
Mistroke
.40251 .47825 L
.40096 .47501 L
.3992 .4718 L
.39723 .46865 L
.3954 .46605 L
.39342 .46356 L
.39131 .46121 L
.38907 .45906 L
.38671 .45714 L
.38426 .45551 L
.38172 .45422 L
.37913 .45333 L
.37649 .45291 L
.37385 .45298 L
.37122 .4536 L
.36865 .45481 L
.36616 .45661 L
.36404 .45872 L
.36205 .46131 L
.36019 .46436 L
.3585 .46784 L
.35699 .47172 L
.35568 .47596 L
.3546 .4805 L
.35374 .4853 L
.35313 .4903 L
.35278 .49542 L
.35268 .5006 L
.35284 .50577 L
.35325 .51087 L
.35392 .51583 L
.35483 .52057 L
.35619 .5258 L
.35784 .53058 L
.35976 .53482 L
.36191 .53848 L
.36425 .54151 L
.36675 .54388 L
.36937 .5456 L
.37208 .54666 L
.37482 .54711 L
.37758 .54698 L
.38031 .54632 L
.38299 .54519 L
.38626 .54319 L
.38937 .54067 L
.39271 .53726 L
.39575 .53347 L
.39845 .52946 L
.4008 .52531 L
Mistroke
.40279 .52111 L
.40442 .51692 L
.40547 .51356 L
.40629 .51022 L
.40688 .50691 L
.40725 .50361 L
.40738 .50032 L
.40729 .49704 L
.40697 .49374 L
.40643 .49043 L
.40565 .4871 L
.4049 .48453 L
.40401 .48194 L
.40298 .47934 L
.40182 .47675 L
.40052 .47416 L
.39908 .47159 L
.39751 .46907 L
.3958 .4666 L
.39442 .46478 L
.39295 .46301 L
.39142 .46133 L
.38982 .45975 L
.38816 .45828 L
.38645 .45694 L
.38468 .45576 L
.38286 .45475 L
.38149 .45412 L
.3801 .45361 L
.37869 .45323 L
.37727 .45298 L
.37585 .45288 L
.37443 .45292 L
.37301 .45312 L
.37125 .4536 L
.36908 .45456 L
.3678 .45535 L
.36654 .45629 L
.36531 .45738 L
.36412 .45864 L
.36296 .46004 L
.36185 .4616 L
.36078 .46331 L
.35977 .46516 L
.3588 .46715 L
.35829 .46833 L
.35779 .46955 L
.35731 .47081 L
.35686 .47211 L
.35642 .47344 L
Mistroke
.35637 .47361 L
.35632 .47378 L
.35627 .47394 L
.35621 .47411 L
.35621 .47413 L
.3562 .47414 L
.3562 .47416 L
.3562 .47417 L
.35619 .47418 L
.35619 .47419 L
.35619 .47419 L
.35619 .4742 L
.35458 .48059 L
.35381 .48484 L
.35324 .48926 L
.35286 .49378 L
.35269 .49837 L
.35272 .50297 L
.35295 .50755 L
.35339 .51204 L
.35402 .51642 L
.35456 .51934 L
.3552 .52216 L
.35592 .52488 L
.35672 .52748 L
.3576 .52995 L
.35855 .53228 L
.35957 .53445 L
.36065 .53647 L
.3618 .53832 L
.36299 .53999 L
.36512 .54243 L
.36736 .54435 L
.36969 .54576 L
.37208 .54666 L
.3745 .54709 L
.37693 .54706 L
.37935 .54661 L
.38173 .54578 L
.3846 .54429 L
.38735 .54238 L
.38997 .54011 L
.39244 .53757 L
.39474 .53481 L
.39686 .53191 L
.39879 .5289 L
.40053 .52583 L
.40207 .52272 L
.40341 .51961 L
.40456 .51651 L
Mistroke
.4057 .5127 L
.40655 .50892 L
.40696 .50635 L
.40723 .50379 L
.40737 .50123 L
.40736 .49868 L
.40722 .49612 L
.40695 .49356 L
.40653 .49099 L
.40621 .48942 L
.40584 .48784 L
.40542 .48625 L
.40494 .48467 L
.40442 .48307 L
.40384 .48148 L
.40332 .48015 L
.40276 .47881 L
.40216 .47748 L
.40153 .47615 L
.40087 .47483 L
.4 .4732 L
.39908 .47159 L
.3981 .46999 L
.39707 .46841 L
.39631 .46731 L
.39553 .46622 L
.39471 .46516 L
.39388 .46411 L
.39302 .46309 L
.3929 .46295 L
.39278 .46282 L
.39267 .46269 L
.39255 .46255 L
.39254 .46254 L
.39252 .46253 L
.39251 .46251 L
.39251 .46251 L
.3925 .4625 L
.39249 .46249 L
.39249 .46249 L
.39248 .46247 L
.39246 .46246 L
.39245 .46245 L
.39233 .46232 L
.39222 .46218 L
.3921 .46205 L
.39198 .46192 L
.39113 .46103 L
.39026 .46016 L
.38937 .45933 L
Mistroke
.38846 .45853 L
.38754 .45777 L
.38635 .45687 L
.38514 .45605 L
.38391 .4553 L
.38266 .45464 L
.38139 .45408 L
.3801 .45361 L
.37829 .45315 L
.37646 .4529 L
.37463 .4529 L
.3728 .45316 L
.37099 .45369 L
.3692 .4545 L
.36745 .45559 L
.36529 .4574 L
.36324 .45969 L
.36131 .46244 L
.35953 .46563 L
.35791 .46924 L
.35649 .47323 L
.35527 .47756 L
.35427 .48217 L
.35341 .48779 L
.35287 .49363 L
.35268 .49958 L
.35277 .50447 L
.3531 .50932 L
.35365 .51405 L
.35442 .51862 L
.3554 .52297 L
.35658 .52706 L
.35795 .53084 L
.35948 .53428 L
.36154 .53793 L
.36379 .54098 L
.3662 .54342 L
.36872 .54524 L
.37133 .54643 L
.374 .54704 L
.37668 .54708 L
.37935 .54661 L
.38198 .54567 L
.38345 .54495 L
.3849 .5441 L
.38633 .54315 L
.38772 .54209 L
.38907 .54094 L
.39038 .53972 L
.39166 .53842 L
Mistroke
.39289 .53706 L
.39478 .53476 L
.39654 .53236 L
.39818 .52989 L
.39969 .52736 L
.40106 .5248 L
.4023 .52223 L
.4034 .51965 L
.40436 .51708 L
.40519 .51452 L
.40589 .51197 L
.40645 .50943 L
.40688 .5069 L
.40718 .50439 L
.40737 .50093 L
.40732 .49748 L
.40708 .49466 L
.40669 .49184 L
.40612 .489 L
.40539 .48614 L
.40448 .48327 L
.40341 .48039 L
.40217 .4775 L
.40076 .47461 L
.39918 .47175 L
.39743 .46894 L
.39588 .4667 L
.39422 .46453 L
.39246 .46246 L
.39061 .46051 L
.38866 .4587 L
.38664 .45708 L
.38454 .45567 L
.38237 .45451 L
.38016 .45363 L
.37791 .45308 L
.37565 .45287 L
.37338 .45305 L
.37113 .45363 L
.36928 .45445 L
.36747 .45557 L
.36609 .45667 L
.36475 .45795 L
.36345 .45942 L
.36221 .46108 L
.36101 .46292 L
.35988 .46494 L
.3585 .46783 L
.35725 .47098 L
.35635 .47366 L
Mistroke
.35554 .47647 L
.35483 .47942 L
.35421 .48248 L
.3537 .48563 L
.35328 .48886 L
.35297 .49215 L
.35271 .4973 L
.35271 .50248 L
.35296 .50763 L
.35347 .51268 L
.35422 .51757 L
.35521 .52222 L
.35643 .52659 L
.35786 .53062 L
.35948 .53427 L
.36127 .53749 L
.36321 .54027 L
.36565 .54294 L
.36824 .54494 L
.37047 .54611 L
.37274 .54683 L
.37503 .54712 L
.37734 .54701 L
.37962 .54653 L
.38188 .54571 L
.38409 .5446 L
.38623 .54321 L
.3883 .54161 L
.39029 .5398 L
.39219 .53784 L
.39445 .53518 L
.39653 .53238 L
.39844 .52946 L
.40017 .52649 L
.40171 .52348 L
.40307 .52045 L
.40424 .51743 L
.40522 .51442 L
.40602 .51143 L
.40682 .50734 L
.40727 .50327 L
.40738 .49996 L
.40726 .49665 L
.40692 .49333 L
.40634 .48999 L
.40552 .48663 L
.40448 .48325 L
.4032 .47985 L
.40168 .47645 L
.39992 .47306 L
Mistroke
.39737 .46886 L
.39445 .46482 L
.3912 .4611 L
.38834 .45843 L
.38531 .45616 L
.38213 .4544 L
.37886 .45327 L
.37552 .45287 L
.37219 .45331 L
.36892 .45465 L
.3662 .45657 L
.36362 .45922 L
.36122 .46258 L
.35905 .46661 L
.35715 .47127 L
.35554 .47648 L
.35428 .48214 L
.35336 .48815 L
.35283 .49439 L
.35274 .49632 L
.35269 .49825 L
.35268 .50018 L
.3527 .50211 L
.35276 .50404 L
.35285 .50596 L
.35298 .50787 L
.35314 .50977 L
.35328 .51113 L
.35344 .51247 L
.35362 .5138 L
.35381 .51513 L
.35402 .51643 L
.35425 .51772 L
.3545 .519 L
.35539 .52294 L
.35645 .52666 L
.35767 .53013 L
.35902 .53333 L
.36051 .53622 L
.36211 .53878 L
.36382 .54102 L
.36611 .54335 L
.36851 .54511 L
.37051 .54612 L
.37254 .54678 L
.3746 .54709 L
.37666 .54708 L
.37872 .54676 L
.38076 .54616 L
.38276 .5453 L
Mistroke
.38472 .54422 L
.38642 .54308 L
.38808 .54179 L
.38968 .54039 L
.39122 .53887 L
.39264 .53735 L
.39332 .53656 L
.39399 .53575 L
Mfstroke
.02 w
.3925 .4625 Mdot
.5 Mabswid
.39332 .53656 m
.39399 .53575 L
s
% Start of user PostScript
-2.1335686 0.73112789 -2.1201662 0.7150109 MAarrowhead1
% End of user PostScript
1 .612 0 r
.37105 .46766 m
.36992 .46833 L
.36882 .46917 L
.36698 .47101 L
.36527 .47333 L
.36371 .4761 L
.36234 .47929 L
.36118 .48285 L
.36024 .48672 L
.35968 .48989 L
.35928 .49318 L
.35904 .49654 L
.35895 .49994 L
.35903 .50335 L
.35927 .50671 L
.35967 .51 L
.36022 .51318 L
.36092 .51621 L
.36176 .51906 L
.36233 .52069 L
.36295 .52223 L
.36361 .52369 L
.36431 .52505 L
.36505 .52632 L
.36582 .5275 L
.36662 .52857 L
.36843 .5305 L
.37034 .53195 L
.37233 .53291 L
.37436 .5334 L
.37641 .53343 L
.37844 .53304 L
.38044 .53226 L
.38238 .53112 L
.38473 .52923 L
.38708 .52671 L
.3892 .52379 L
.39106 .52057 L
.39265 .51713 L
.39393 .51351 L
.39491 .50979 L
.39557 .50599 L
.39592 .50215 L
.39593 .49829 L
.39573 .49536 L
.39534 .49243 L
.39476 .48954 L
.394 .4867 L
.39306 .48392 L
.39194 .48123 L
Mistroke
.39065 .47865 L
.3892 .47621 L
.3876 .47395 L
.38616 .47223 L
.38463 .47068 L
.38303 .46934 L
.38135 .46823 L
.37963 .46738 L
.37787 .4668 L
.37608 .46654 L
.37429 .46661 L
.37251 .46703 L
.37077 .46781 L
.36907 .46896 L
.36745 .47048 L
.36592 .47236 L
.3645 .47461 L
.36321 .47718 L
.36206 .48006 L
.36108 .48321 L
.3601 .48744 L
.35958 .49065 L
.35921 .49397 L
.359 .49736 L
.35896 .50078 L
.35908 .50419 L
.35936 .50756 L
.3598 .51083 L
.36039 .51399 L
.36113 .51699 L
.36201 .5198 L
.36256 .52129 L
.36315 .5227 L
.36378 .52403 L
.36444 .52529 L
.36513 .52646 L
.36586 .52755 L
.36661 .52855 L
.36838 .53045 L
.37025 .53189 L
.3722 .53286 L
.37419 .53338 L
.3762 .53345 L
.3782 .53311 L
.38016 .53239 L
.38208 .53132 L
.38429 .52962 L
.38637 .52754 L
.38828 .52514 L
.39001 .52248 L
Mistroke
.39154 .51962 L
.39285 .51661 L
.39395 .51347 L
.39465 .51091 L
.39521 .50831 L
.39561 .50569 L
.39587 .50304 L
.39596 .50039 L
.39591 .49773 L
.3957 .49508 L
.39534 .49245 L
.39491 .49019 L
.39436 .48796 L
.3937 .48576 L
.39294 .48361 L
.39206 .4815 L
.39109 .47947 L
.39001 .47752 L
.38884 .47566 L
.38758 .47392 L
.38623 .4723 L
.38497 .47101 L
.38366 .46984 L
.3823 .46883 L
.3809 .46798 L
.37947 .46731 L
.37801 .46684 L
.37653 .46658 L
.37555 .46653 L
.37458 .46658 L
.3736 .46673 L
.37263 .46699 L
.37167 .46736 L
.37072 .46783 L
.36978 .46842 L
.36763 .47029 L
.36562 .47279 L
.36382 .47589 L
.36225 .47954 L
.36095 .48367 L
.36005 .4877 L
.35941 .49197 L
.35904 .4964 L
.35896 .5009 L
.35916 .50538 L
.35963 .50976 L
.36038 .51394 L
.36138 .51786 L
.36262 .52143 L
.36372 .52392 L
Mistroke
.36493 .52614 L
.36625 .52808 L
.36765 .52973 L
.36912 .53108 L
.37065 .53213 L
.37223 .53287 L
.37383 .53332 L
.37529 .53347 L
.37675 .5334 L
.3782 .53311 L
.37964 .53262 L
.38105 .53194 L
.38242 .53109 L
.38376 .53008 L
.3849 .52907 L
.386 .52795 L
.38706 .52674 L
.38806 .52544 L
.38902 .52407 L
.38992 .52264 L
.39093 .52083 L
.39186 .51895 L
.3927 .51701 L
.39344 .51502 L
.39409 .51299 L
.39477 .51044 L
.39529 .50785 L
.39567 .50524 L
.39589 .50261 L
.39595 .50114 L
.39596 .49968 L
.39593 .49822 L
.39585 .49676 L
.39572 .4953 L
.39555 .49384 L
.39536 .49254 L
.39513 .49125 L
.39486 .48997 L
.39455 .48869 L
.39421 .48742 L
.39375 .4859 L
.39324 .48441 L
.39267 .48293 L
.39236 .48218 L
.39203 .48144 L
.39169 .4807 L
.39134 .47997 L
.39097 .47925 L
.39079 .4789 L
.3906 .47855 L
Mistroke
.3904 .4782 L
.3902 .47785 L
.39014 .47774 L
.39007 .47763 L
.39001 .47751 L
.39 .47751 L
.39 .4775 L
.39 .47749 L
.38999 .47749 L
.38993 .47737 L
.38986 .47726 L
.38979 .47715 L
.38959 .47683 L
.38939 .4765 L
.38918 .47618 L
.38898 .47586 L
.38855 .47524 L
.38812 .47463 L
.38767 .47404 L
.38721 .47346 L
.38675 .4729 L
.38589 .47194 L
.38501 .47104 L
.3841 .47021 L
.38316 .46945 L
.38221 .46876 L
.38123 .46816 L
.37966 .46739 L
.37806 .46685 L
.37644 .46657 L
.37482 .46655 L
.3732 .46682 L
.37159 .46739 L
.37003 .46826 L
.3683 .46962 L
.36666 .47139 L
.36513 .47355 L
.36373 .47607 L
.36247 .47894 L
.36139 .48212 L
.36049 .48556 L
.35979 .48922 L
.35929 .49305 L
.35902 .49698 L
.35896 .50096 L
.35912 .50492 L
.35951 .50881 L
.3601 .51256 L
.36043 .51418 L
.3608 .51575 L
Mistroke
.36121 .51727 L
.36166 .51874 L
.36214 .52016 L
.36265 .52152 L
.3632 .52282 L
.36431 .52507 L
.36552 .52707 L
.36682 .52881 L
.36819 .53027 L
.36962 .53146 L
.3711 .53237 L
.37262 .53301 L
.37416 .53337 L
.37571 .53347 L
.37726 .53332 L
.3788 .53293 L
.38031 .53232 L
.38179 .53151 L
.38351 .53028 L
.38515 .52882 L
.38671 .52715 L
.38817 .5253 L
.38952 .5233 L
.39075 .52117 L
.39187 .51893 L
.39285 .51661 L
.39381 .5139 L
.3946 .51112 L
.39521 .5083 L
.39564 .50544 L
.39589 .50257 L
.39596 .49968 L
.39585 .4968 L
.39556 .49392 L
.39501 .49065 L
.39421 .48743 L
.39319 .48428 L
.39195 .48124 L
.39048 .47835 L
.38882 .47563 L
.38697 .47316 L
.38495 .47098 L
.38279 .46917 L
.38051 .46777 L
.37861 .46701 L
.37668 .46659 L
.37474 .46656 L
.37281 .46693 L
.37091 .46773 L
.36907 .46896 L
Mistroke
.36731 .47063 L
.36566 .47273 L
.36493 .47387 L
.36423 .47509 L
.36356 .4764 L
.36294 .4778 L
.36235 .47927 L
.3618 .48082 L
.36129 .48244 L
.36054 .48532 L
.35993 .48836 L
.35946 .49152 L
.35915 .49477 L
.35898 .49808 L
.35897 .50141 L
.35911 .50473 L
.35945 .50836 L
.35997 .51188 L
.36068 .51524 L
.36155 .51841 L
.36258 .52133 L
.36376 .52399 L
.36506 .52635 L
.36648 .52838 L
.36735 .52942 L
.36825 .53033 L
.36918 .53113 L
.37013 .53181 L
.3711 .53237 L
.37208 .53282 L
.37308 .53314 L
.37408 .53336 L
.37509 .53346 L
.3761 .53346 L
.37778 .53322 L
.37943 .5327 L
.38106 .53194 L
.38264 .53094 L
.38416 .52974 L
.38562 .52835 L
.38701 .52679 L
.38831 .5251 L
.3899 .52267 L
.39132 .52007 L
.39257 .51733 L
.39362 .51448 L
.39449 .51156 L
.39516 .50858 L
.39563 .50556 L
.3959 .50251 L
Mistroke
.39596 .49946 L
.39569 .49497 L
.39514 .49134 L
.39431 .48777 L
.39319 .48428 L
.3918 .48093 L
.39015 .47775 L
.38825 .47481 L
.38613 .47219 L
.38381 .46997 L
.38134 .46822 L
.37961 .46737 L
.37785 .4668 L
.37606 .46654 L
.37427 .46661 L
.37249 .46703 L
.37074 .46782 L
.36905 .46898 L
.36742 .4705 L
.36652 .47156 L
.36565 .47274 L
.36482 .47404 L
.36404 .47546 L
.3633 .47698 L
.3626 .47861 L
.36196 .48034 L
.36111 .48309 L
.36039 .48602 L
.35981 .4891 L
.35937 .4923 L
.35909 .49558 L
.35896 .49891 L
.35899 .50225 L
.35917 .50556 L
.35951 .50882 L
.35999 .51198 L
.36099 .51649 L
.36197 .51969 L
.36312 .52263 L
.36442 .52525 L
.36585 .52753 L
.36739 .52946 L
.36903 .53101 L
.37074 .53218 L
.3725 .53297 L
.3743 .53339 L
.37611 .53346 L
.37791 .53318 L
.37969 .5326 L
.38143 .53172 L
Mistroke
.38312 .53059 L
.38474 .52922 L
.38628 .52764 L
.38772 .52589 L
.38933 .5236 L
.39078 .52112 L
.39206 .5185 L
.39317 .51578 L
.3941 .51296 L
.39485 .51008 L
.39534 .50756 L
.39569 .50502 L
Mfstroke
.02 w
.39 .4775 Mdot
.5 Mabswid
.39534 .50756 m
.39569 .50502 L
s
% Start of user PostScript
-2.0932133 0.1512759 -2.0861796 0.10039925 MAarrowhead1
% End of user PostScript
1 0 .957 r
.52114 .57139 m
.52193 .57247 L
.52274 .57353 L
.52439 .57552 L
.52685 .57816 L
.5294 .58046 L
.53201 .58239 L
.53468 .58392 L
.5374 .58502 L
.54014 .58569 L
.54289 .58589 L
.54626 .5855 L
.54961 .5844 L
.55232 .58295 L
.55499 .58101 L
.55758 .57861 L
.56009 .57576 L
.56249 .57248 L
.56479 .5688 L
.56696 .56474 L
.56969 .55866 L
.57214 .55201 L
.57428 .54488 L
.5761 .53735 L
.57758 .5295 L
.57871 .5214 L
.57947 .51313 L
.57987 .50475 L
.57992 .49779 L
.57971 .49084 L
.57925 .48395 L
.57853 .47714 L
.57758 .47046 L
.57637 .46394 L
.57494 .45764 L
.57328 .4516 L
.57095 .4446 L
.56832 .43814 L
.56582 .43305 L
.56313 .42847 L
.56027 .42446 L
.55727 .42107 L
.55415 .41832 L
.55093 .41625 L
.54765 .41487 L
.54433 .41419 L
.541 .4142 L
.53768 .41489 L
.5344 .41623 L
.53118 .41818 L
Mistroke
.52805 .4207 L
.52503 .42375 L
.52141 .42823 L
.51803 .43335 L
.51491 .439 L
.51208 .44508 L
.50955 .4515 L
.50734 .45818 L
.50546 .46507 L
.50393 .4721 L
.50274 .47923 L
.5019 .48643 L
.50141 .49367 L
.50128 .50093 L
.5015 .50818 L
.50208 .51541 L
.50301 .5226 L
.50404 .5285 L
.50532 .53432 L
.50682 .54005 L
.50856 .54566 L
.51052 .5511 L
.5127 .55634 L
.51508 .56133 L
.51766 .56603 L
.52042 .57037 L
.52335 .57429 L
.52643 .57774 L
.52964 .58066 L
.53296 .58298 L
.53636 .58465 L
.53981 .58563 L
.54328 .58588 L
.54675 .58539 L
.55019 .58413 L
.55356 .58212 L
.55683 .57936 L
.55998 .5759 L
.56297 .57177 L
.56578 .56701 L
.56839 .5617 L
.57077 .55588 L
.57291 .54961 L
.57479 .54297 L
.57639 .536 L
.5777 .52878 L
.57871 .52136 L
.57943 .51379 L
.57983 .50612 L
.57992 .49842 L
Mistroke
.5797 .49073 L
.57917 .48309 L
.57833 .47558 L
.5772 .46823 L
.57576 .46111 L
.57405 .45427 L
.57206 .44777 L
.56982 .44168 L
.56735 .43606 L
.56465 .43096 L
.56176 .42646 L
.5587 .4226 L
.5555 .41942 L
.55219 .41697 L
.54879 .41526 L
.54533 .41432 L
.54186 .41413 L
.53839 .41468 L
.53496 .41595 L
.53159 .4179 L
.52831 .42047 L
.52515 .42361 L
.52213 .42726 L
.51867 .43231 L
.51546 .43793 L
.51255 .44399 L
.50994 .45042 L
.50766 .45714 L
.50572 .46406 L
.50412 .47114 L
.50299 .47751 L
.50215 .48395 L
.50159 .49042 L
.50131 .49691 L
.50132 .50342 L
.50161 .50991 L
.50218 .51638 L
.50304 .52281 L
.50418 .52918 L
.5056 .53546 L
.50728 .54162 L
.50924 .54762 L
.51145 .55342 L
.51391 .55896 L
.5166 .56419 L
.51952 .56902 L
.52264 .57339 L
.52526 .5765 L
.52798 .57923 L
.53079 .58154 L
Mistroke
.53368 .58339 L
.53662 .58475 L
.5396 .58559 L
.5426 .58589 L
.5456 .58564 L
.54858 .58482 L
.55152 .58343 L
.5544 .58148 L
.55691 .57928 L
.55935 .57666 L
.5617 .57363 L
.56394 .57023 L
.56608 .56646 L
.56809 .56237 L
.56997 .55796 L
.57162 .55352 L
.57314 .54885 L
.57452 .54398 L
.57575 .53893 L
.57683 .53373 L
.57776 .52841 L
.57852 .52297 L
.57912 .51745 L
.57967 .5099 L
.57991 .50229 L
.57985 .49466 L
.57949 .48706 L
.57882 .47955 L
.57785 .47218 L
.57659 .465 L
.57504 .45806 L
.57323 .45143 L
.57115 .44516 L
.56883 .43931 L
.56641 .43418 L
.5638 .42955 L
.56103 .42545 L
.5581 .42194 L
.55506 .41904 L
.55191 .4168 L
.5487 .41523 L
.54543 .41433 L
.54215 .41412 L
.53887 .41456 L
.53562 .41565 L
.53242 .41735 L
.5293 .41962 L
.52627 .42242 L
.52269 .42653 L
.51932 .43128 L
Mistroke
.51619 .43656 L
.51332 .44229 L
.51073 .44837 L
.50843 .45473 L
.50644 .46131 L
.50477 .46806 L
.50313 .47662 L
.50226 .48292 L
.50167 .48926 L
.50134 .49563 L
.50129 .50201 L
.50152 .50838 L
.50201 .51473 L
.50278 .52105 L
.50382 .52731 L
.50512 .5335 L
.50669 .53958 L
.50852 .54553 L
.51059 .55129 L
.51292 .55683 L
.51547 .56208 L
.51824 .56699 L
.52121 .57149 L
.52437 .5755 L
.52727 .57856 L
.53027 .58115 L
.53336 .58321 L
.53652 .58472 L
.53973 .58562 L
.54296 .58589 L
.54618 .58552 L
.54938 .5845 L
.55202 .58314 L
.5546 .58133 L
.55713 .57907 L
.55957 .5764 L
.56192 .57331 L
.56417 .56984 L
.56631 .56602 L
.56832 .56185 L
.57019 .55739 L
.57192 .55264 L
.57323 .54857 L
.57443 .54433 L
.57552 .53997 L
.57649 .53549 L
.57735 .5309 L
.57808 .52623 L
.57881 .52049 L
.57936 .51468 L
Mistroke
.57963 .51065 L
.57981 .50659 L
.57991 .50253 L
.57992 .49845 L
.57985 .49439 L
.57968 .49033 L
.57947 .48677 L
.57918 .48324 L
.57884 .47973 L
.57842 .47625 L
.57794 .4728 L
.57788 .47238 L
.57782 .47196 L
.57775 .47155 L
.57768 .47113 L
.57768 .47109 L
.57767 .47104 L
.57766 .471 L
.57766 .47098 L
.57766 .47096 L
.57765 .47094 L
.57765 .47092 L
.57765 .4709 L
.5776 .4706 L
.57755 .47031 L
.5775 .47002 L
.5775 .47001 L
.5775 .47 L
.5775 .46999 L
.5775 .46998 L
.57745 .46969 L
.5774 .4694 L
.57735 .46911 L
.57735 .4691 L
.57735 .4691 L
.57735 .4691 L
.57735 .4691 L
.57735 .46909 L
.57735 .46909 L
.57735 .46909 L
.57734 .46908 L
.57734 .46904 L
.57733 .469 L
.57732 .46896 L
.57732 .46892 L
.57724 .46851 L
.57717 .4681 L
.5771 .46769 L
.57702 .46728 L
.57695 .46687 L
Mistroke
.57614 .46284 L
.57525 .45889 L
.57426 .45504 L
.57319 .4513 L
.57226 .44835 L
.57127 .44549 L
.57024 .44272 L
.56915 .44005 L
.56801 .43747 L
.56667 .43469 L
.56528 .43206 L
.56383 .42958 L
.56232 .42727 L
.56078 .42512 L
.55919 .42315 L
.55672 .42053 L
.55417 .41834 L
.55203 .41687 L
.54986 .41572 L
.54766 .41487 L
.54544 .41433 L
.54321 .41411 L
.54098 .4142 L
.53872 .4146 L
.53646 .41531 L
.53423 .41631 L
.53204 .4176 L
.52987 .41916 L
.52776 .42097 L
.52569 .42303 L
.52286 .42632 L
.52017 .43 L
.51762 .43404 L
.51523 .43838 L
.513 .44298 L
.51095 .4478 L
.50909 .4528 L
.50741 .45794 L
.50593 .46321 L
.50465 .46856 L
.50358 .47399 L
.50248 .48115 L
.50174 .48836 L
.50134 .49561 L
.50131 .50287 L
.50162 .51012 L
.50229 .51734 L
.50332 .52451 L
.50469 .53159 L
.5064 .53855 L
Mistroke
.50845 .54533 L
.51083 .55189 L
.51352 .55814 L
.5165 .56401 L
.51976 .56939 L
.52327 .5742 L
.52629 .5776 L
.52943 .58048 L
.53267 .5828 L
.53599 .5845 L
.53937 .58555 L
.54277 .58589 L
.54618 .58552 L
.54955 .58442 L
.55287 .58259 L
.5561 .58005 L
.55921 .57682 L
.56219 .57293 L
.565 .56844 L
.56761 .56338 L
.57002 .55783 L
.5722 .55183 L
.57413 .54544 L
.5758 .53873 L
.5772 .53174 L
.57832 .52454 L
.57915 .51718 L
.57968 .50971 L
.57992 .50217 L
.57985 .49462 L
.57949 .4871 L
.57883 .47967 L
.57788 .47237 L
.57664 .46525 L
.57512 .45838 L
.57334 .4518 L
.5713 .44557 L
.56902 .43975 L
.56652 .4344 L
.56382 .42958 L
.56094 .42534 L
.5579 .42172 L
.55474 .41878 L
.55147 .41654 L
.54812 .41502 L
.54473 .41423 L
.54132 .41417 L
.53793 .41481 L
.53457 .41614 L
.53128 .41811 L
Mistroke
.52808 .42068 L
.52499 .42379 L
.52203 .42739 L
.51895 .43186 L
.51608 .43677 L
.51343 .44206 L
.51101 .44765 L
.50885 .45349 L
.50695 .45952 L
.50531 .46571 L
.50395 .47201 L
.50286 .47839 L
.50206 .48483 L
.50153 .4913 L
.5013 .4978 L
.50134 .5043 L
.50167 .51079 L
.50228 .51725 L
.50318 .52368 L
.50436 .53003 L
.50598 .53696 L
.50793 .54373 L
.51021 .55028 L
.51279 .55656 L
.51568 .56248 L
.51884 .56796 L
.52225 .57289 L
.52526 .5765 L
.5284 .57961 L
.53166 .58215 L
.53502 .58407 L
.53843 .58533 L
.54188 .58587 L
.54534 .58568 L
.54877 .58474 L
.55216 .58305 L
.55546 .58062 L
.55864 .57747 L
.56169 .57364 L
.56457 .56918 L
.56726 .56413 L
.56973 .55856 L
.57197 .55252 L
.57396 .54607 L
.57568 .53928 L
.57712 .53221 L
.57827 .52491 L
.57912 .51745 L
.57967 .50986 L
.57992 .50221 L
Mistroke
.57985 .49455 L
.57948 .48692 L
.5788 .47938 L
.57782 .47198 L
.57654 .46477 L
.57498 .45781 L
.57315 .45116 L
.57105 .44488 L
.56871 .43903 L
.56614 .43367 L
.56337 .42886 L
.56042 .42466 L
.55731 .42111 L
.55407 .41826 L
.55074 .41614 L
.54733 .41477 L
.54388 .41415 L
.54042 .41427 L
.53698 .41512 L
.53359 .41666 L
.53027 .41885 L
.52706 .42164 L
.52397 .42497 L
.52102 .42878 L
.51823 .43302 L
.51563 .43761 L
.51321 .44252 L
.511 .44768 L
.509 .45305 L
.50722 .45859 L
.50566 .46427 L
.50434 .47004 L
.50325 .47589 L
.50225 .48306 L
.5016 .49028 L
.5013 .49753 L
.50136 .50478 L
.50177 .51203 L
.50253 .51923 L
.50364 .52638 L
.5051 .53343 L
.50691 .54034 L
.50904 .54707 L
.5115 .55355 L
.51426 .5597 L
.51732 .56545 L
.52065 .57069 L
.52422 .57533 L
.52723 .57853 L
.53036 .58122 L
Mistroke
.53359 .58334 L
.53689 .58485 L
.54023 .5857 L
.5436 .58587 L
.54695 .58534 L
.55028 .58409 L
.55353 .58213 L
.5567 .57949 L
.55976 .57617 L
.56267 .57223 L
.56541 .5677 L
.56796 .56263 L
.57031 .55709 L
.57243 .55111 L
.57431 .54477 L
.57594 .53811 L
.5773 .5312 L
.57838 .52408 L
.57918 .5168 L
.57969 .50941 L
.57992 .50197 L
.57985 .49452 L
.57949 .4871 L
.57884 .47976 L
.5779 .47255 L
.57669 .46551 L
.5752 .45871 L
.57346 .4522 L
.57146 .44602 L
.56923 .44024 L
.56678 .43491 L
.56414 .4301 L
.56131 .42584 L
.55833 .42219 L
.55522 .41918 L
.55201 .41686 L
.54872 .41523 L
.54537 .41432 L
.54201 .41412 L
.53865 .41462 L
.53533 .41578 L
.53206 .41758 L
.52888 .41998 L
.5258 .42292 L
.52284 .42635 L
.51971 .43069 L
.51677 .43551 L
.51406 .44072 L
.51158 .44625 L
.50935 .45205 L
Mistroke
.50738 .45805 L
.50579 .46377 L
.50443 .46959 L
Mfstroke
.02 w
.5775 .47 Mdot
.5 Mabswid
.50579 .46377 m
.50443 .46959 L
s
% Start of user PostScript
0.11579957 -0.72465892 0.088666766 -0.60811427 MAarrowhead1
% End of user PostScript
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[3]:=",
  ImageSize->{400, 400},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006@0001T2000`400?l00000o`00003oo`3ooonA
0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA
0?ooo`00^@3oool500000080oooo0P00003>0?ooo`00^`3oool01@000000oooo0?ooo`3oool00000
0080oooo00<000000?ooo`3oool0b`3oool00;/0oooo00D000000?ooo`3oool0oooo000000020?oo
o`030000003oool0oooo00@0oooo0`0000340?ooo`00/`3oool4000000@0oooo00D000000?ooo`3o
ool0oooo000000020?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0a03oool00;/0
oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00@0oooo00<000000?oo
o`3oool0a03oool00;X0oooo0P0000040?ooo`8000001`3oool00`000000oooo0?ooo`340?ooo`00
b@3oool00`000000oooo0?ooo`340?ooo`00b@3oool00`000000oooo0?ooo`340?ooo`00b@3oool0
0`000000oooo0?ooo`340?ooo`00b@3oool00`000000oooo0?ooo`340?ooo`00b@3oool00`000000
oooo0?ooo`340?ooo`00b@3oool00`000000oooo0?ooo`340?ooo`00b@3oool200000<D0oooo0039
0?ooo`030000003oool0oooo0<@0oooo00390?ooo`030000003oool0oooo0<@0oooo00390?ooo`03
0000003oool0oooo0<@0oooo00390?ooo`030000003oool0oooo0<@0oooo00390?ooo`030000003o
ool0oooo0<@0oooo00390?ooo`030000003oool0oooo0<@0oooo00390?ooo`030000003oool0oooo
0<@0oooo00390?ooo`030000003oool0oooo0<@0oooo00390?ooo`800000a@3oool00<T0oooo00<0
00000?ooo`3oool0a03oool00<T0oooo00<000000?ooo`3oool0a03oool00<T0oooo00<000000?oo
o`3oool0a03oool00<T0oooo00<000000?ooo`3oool0a03oool00<T0oooo00<000000?ooo`3oool0
a03oool00<T0oooo00<000000?ooo`3oool0a03oool00<T0oooo00<000000?ooo`3oool0a03oool0
0<T0oooo00<000000?ooo`3oool0a03oool00<T0oooo00<000000?ooo`3oool0a03oool00<T0oooo
0P0000350?ooo`00b@3oool00`000000oooo0?ooo`340?ooo`00b@3oool00`000000oooo0?ooo`34
0?ooo`00b@3oool00`000000oooo0?ooo`340?ooo`00b@3oool00`000000oooo0?ooo`340?ooo`00
b@3oool00`000000oooo0?ooo`340?ooo`00b@3oool00`000000oooo0?ooo`340?ooo`00b@3oool0
0`000000oooo0?ooo`340?ooo`00b@3oool00`000000oooo0?ooo`340?ooo`00b@3oool200000<D0
oooo00390?ooo`030000003oool0oooo0<@0oooo00390?ooo`030000003oool0oooo0<@0oooo0039
0?ooo`030000003oool0oooo0<@0oooo00390?ooo`030000003oool0oooo0<@0oooo00390?ooo`03
0000003oool0oooo0<@0oooo00390?ooo`030000003oool0oooo0<@0oooo00390?ooo`030000003o
ool0oooo0<@0oooo002e0?ooo`030000003oool0oooo0080oooo0P0000040?ooo`8000001`3oool0
0`000000oooo0?ooo`340?ooo`00]@3oool00`000000oooo0?ooo`070?ooo`040000003oool0oooo
000000H0oooo00<000000?ooo`3oool0a03oool00;D0oooo00<000000?ooo`3oool02P3oool00`00
0000oooo0?ooo`040?ooo`<00000a03oool00:d0oooo100000050?ooo`030000003oool0oooo00L0
oooo0P0000070?ooo`030000003oool0oooo0<@0oooo002c0?ooo`040000003oool0oooo000000T0
oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`340?ooo`00/`3oool4000000T0oooo
0`0000060?ooo`030000003oool0oooo0<@0oooo00390?ooo`030000003oool0oooo0<@0oooo0039
0?ooo`030000003oool0oooo0<@0oooo00390?ooo`030000003oool0oooo0<@0oooo00390?ooo`03
0000003oool0oooo0<@0oooo00390?ooo`030000003oool0oooo0<@0oooo00390?ooo`030000003o
ool0oooo0<@0oooo00390?ooo`800000a@3oool00<T0oooo00<000000?ooo`3oool0a03oool00<T0
oooo00<000000?ooo`3oool01P3oool>08P0ok00oooo00390?ooo`030000003oool0oooo00<0oooo
1P280?l:0?ooo`@0R03o[@3oool00<T0oooo00<000000?ooo`3oool00`280?lC0?ooo`<0R03oZ`3o
ool00<T0oooo00@0000008P0o`280?l0R03o5`3oool308P0ojT0oooo00380?ooo`<0R03o703oool2
08P0ojL0oooo00360?ooo`<0R03o00<000000?ooo`3oool0703oool308P0ojD0oooo00340?ooo`80
R03o0`3oool00`000000oooo0?ooo`0N0?ooo`80R03oY03oool00<80oooo0P280?l50?ooo`800000
8@3oool00`280?l0oooo0?ooo`2Q0?ooo`00_`3oool308P0o`L0oooo00<000000?ooo`3oool08@3o
ool208P0oj40oooo002l0?ooo`@0R03o2@3oool00`000000oooo0?ooo`0R0?ooo`80R03oX03oool0
09@0oooo30280?lI0?ooo`D0R03o2`3oool00`000000oooo0?ooo`0S0?ooo`80R03oW`3oool00900
oooo1@280?l:0?ooo`P0R03o3`3oool508P0o`h0oooo00<000000?ooo`3oool09@3oool00`280?l0
oooo0?ooo`2L0?ooo`00S@3oool408P0oaD0oooo4@280?lB0?ooo`030000003oool0oooo02H0oooo
0P280?nL0?ooo`00R`3oool308P0oc/0oooo00<000000?ooo`3oool09`3oool208P0oi/0oooo002:
0?ooo`80R03o?@3oool00`000000oooo0?ooo`0X0?ooo`80R03oVP3oool008T0oooo00<0R03o0?oo
o`3oool0?@3oool00`000000oooo0?ooo`0Y0?ooo`80R03oV@3oool008L0oooo0P280?m00?ooo`03
0000003oool0oooo02X0oooo0`280?nG0?ooo`00QP3oool00`280?l0oooo0?ooo`100?ooo`800000
2P3oool90?Wo01X0oooo0P280?nF0?ooo`00Q@3oool00`280?l0oooo0?ooo`110?ooo`030000003o
ool0oooo00D0oooo1@3io`080?ooo`<0nOl0603oool208P0oiD0oooo00230?ooo`80R03oA03oool0
0`000000oooo0?ooo`020?ooo`@0nOl03P3oool30?Wo01L0oooo0P280?nD0?ooo`00PP3oool208P0
odD0oooo00<000000?ooo`3oool00`3io`0D0?ooo`80nOl05`3oool208P0oi80oooo00210?ooo`80
R03oAP3oool00`000000nOl00?Wo000I0?ooo`80nOl05P3oool208P0oi40oooo00210?ooo`0308P0
o`3oool0oooo04@0oooo0P3io`0M0?ooo`80nOl05@3oool208P0oi00oooo00200?ooo`0308P0o`3o
ool0oooo04<0oooo0P3io`000`3oool000000?ooo`0M0?ooo`80nOl05@3oool208P0ohl0oooo001o
0?ooo`0308P0o`3oool0oooo0480oooo0P3io`030?ooo`030000003oool0oooo01h0oooo0P3io`0E
0?ooo`80R03oS@3oool007h0oooo00<0R03o0?ooo`3oool0@@3oool30?Wo00@0oooo00<000000?oo
o`3oool07`3oool20?Wo01H0oooo0P280?n;0?ooo`00O@3oool00`280?l0oooo0?ooo`100?ooo`<0
nOl01P3oool200000280oooo00<0nOl00?ooo`3oool0503oool308P0ohT0oooo001l0?ooo`0308P0
o`3oool0oooo03l0oooo0`3io`080?ooo`030000003oool0oooo0280oooo00<0nOl00?ooo`3oool0
5@3oool308P0ohL0oooo001k0?ooo`80R03o?`3oool30?Wo00X0oooo00<000000?ooo`3oool08`3o
ool00`3io`00oooo0?ooo`0E0?ooo`@0R03oQ@3oool007/0oooo00<0R03o0?ooo`3oool05P3oool<
0?Wo01T0oooo103io`0<0?ooo`030000003oool0oooo02@0oooo00<0nOl00?ooo`3oool05P3oool5
08P0oh80oooo001j0?ooo`0308P0o`3oool0oooo01<0oooo1@3io`0:0?ooo`H0nOl04@3oool50?Wo
00h0oooo00<000000?ooo`3oool09@3oool00`3io`00oooo0?ooo`0H0?ooo`@0R03oP03oool007T0
oooo00<0R03o0?ooo`3oool04P3oool30?Wo01@0oooo4`3io`0A0?ooo`030000003oool0oooo02H0
oooo0P3io`0K0?ooo`H0R03oN`3oool007P0oooo0P280?lB0?ooo`<0nOl0>P3oool00`000000oooo
0?ooo`0W0?ooo`80nOl07`3oool608P0ogH0oooo001g0?ooo`80R03o4P3oool20?Wo03`0oooo00<0
00000?ooo`3oool0:03oool20?Wo0280oooo1@280?mc0?ooo`00M`3oool00`280?l0oooo0?ooo`0?
0?ooo`80nOl0=@3oool2000000L0oooo00<000000?ooo`3oool0:@3oool00`3io`00oooo0?ooo`0T
0?ooo`<0R03oL@3oool007H0oooo00<0R03o0?ooo`3oool03`3oool20?Wo03D0oooo00@000000?oo
o`3oool000001P3oool00`000000oooo0?ooo`0Z0?ooo`030?Wo003oool0oooo02H0oooo0`280?m^
0?ooo`00M@3oool208P0oa00oooo0P3io`0i0?ooo`030000003oool0oooo00@0oooo0`00000[0?oo
o`030?Wo003oool0oooo02L0oooo0`280?m/0?ooo`00M03oool208P0oa00oooo0P3io`0a0?ooo`@0
00000`3oool2000000L0oooo00<000000?ooo`3oool0;03oool00`3io`00oooo0?ooo`0Y0?ooo`80
R03oJP3oool007@0oooo00<0R03o0?ooo`3oool03P3oool20?Wo03T0oooo00<000000?ooo`3oool0
1P3oool00`000000oooo0?ooo`0]0?ooo`030?Wo003oool0oooo02T0oooo0`280?mX0?ooo`00L`3o
ool208P0o`l0oooo00<0nOl00?ooo`3oool0>@3oool3000000H0oooo00<000000?ooo`3oool0;P3o
ool00`3io`00oooo0?ooo`0Z0?ooo`80R03oI`3oool00780oooo0P280?l?0?ooo`80nOl0A03oool0
0`000000oooo0?ooo`0_0?ooo`030?Wo003oool0oooo02/0oooo00<0R03o0?ooo`3oool0I03oool0
0780oooo0P280?l?0?ooo`030?Wo003oool0oooo04<0oooo00<000000?ooo`3oool0<03oool00`3i
o`00oooo0?ooo`0Z0?ooo`80R03oI@3oool00740oooo0P280?l?0?ooo`030?Wo003oool0oooo04@0
oooo00<000000?ooo`3oool0<@3oool00`3io`00oooo0?ooo`0Z0?ooo`80R03oI03oool00740oooo
00<0R03o0?ooo`3oool03@3oool00`3io`00oooo0?ooo`150?ooo`030000003oool0oooo0380oooo
00<0nOl00?ooo`3oool0:P3oool208P0of<0oooo001`0?ooo`0308P0o`3oool0oooo00d0oooo00<0
nOl00?ooo`3oool0AP3oool00`000000oooo0?ooo`080?ooo`/0o`3o803oool20?Wo02/0oooo0P28
0?mR0?ooo`00K`3oool208P0o`h0oooo0P3io`180?ooo`030000003oool0oooo00D0oooo103o0?l8
0?ooo`@0o`3o7`3oool20?Wo02`0oooo00<0R03o0?ooo`3oool0G`3oool006l0oooo00<0R03o0?oo
o`3oool03@3oool00`3io`00oooo0?ooo`170?ooo`800000103oool40?l0o`d0oooo0`3o0?lN0?oo
o`80nOl0:`3oool208P0of00oooo001^0?ooo`80R03o3P3oool00`3io`00oooo0?ooo`180?ooo`03
0000003oool0oooo0080oooo0`3o0?lA0?ooo`80o`3o7P3oool20?Wo02/0oooo00<0R03o0?ooo`3o
ool0GP3oool006h0oooo00<0R03o0?ooo`3oool0303oool20?Wo04X0oooo00<000000?ooo`3oool0
0`3o0?lE0?ooo`80o`3o7P3oool20?Wo02X0oooo00<0R03o0?ooo`3oool0G@3oool006d0oooo0P28
0?l=0?ooo`80nOl0B`3oool010000000o`3o0?l0o`3o0?lH0?ooo`<0o`3o7@3oool20?Wo02T0oooo
0P280?mN0?ooo`00K03oool208P0o`h0oooo00<0nOl00?ooo`3oool0BP3oool20?l0oa/0oooo0`3o
0?lN0?ooo`80nOl0:03oool208P0oed0oooo001/0?ooo`0308P0o`3oool0oooo00`0oooo00<0nOl0
0?ooo`3oool0BP3oool00`3o0?l000000?ooo`0M0?ooo`030?l0o`3oool0oooo01d0oooo0P3io`0X
0?ooo`0308P0o`3oool0oooo05/0oooo001[0?ooo`0308P0o`3oool0oooo00`0oooo0P3io`1:0?oo
o`80o`3o00<0oooo0000003oool07P3oool00`3o0?l0oooo0?ooo`0N0?ooo`80nOl09P3oool208P0
oe`0oooo001[0?ooo`0308P0o`3oool0oooo00`0oooo00<0nOl00?ooo`3oool0A`3oool30?l0o`80
oooo00<000000?ooo`3oool07P3oool00`3o0?l0oooo0?ooo`0N0?ooo`<0nOl09@3oool00`280?l0
oooo0?ooo`1J0?ooo`00JP3oool00`280?l0oooo0?ooo`0<0?ooo`80nOl0B03oool20?l0o`@0oooo
00<000000?ooo`3oool07`3oool00`3o0?l0oooo0?ooo`0O0?ooo`H0nOl08@3oool00`280?l0oooo
0?ooo`1I0?ooo`00J@3oool208P0o`h0oooo00<0nOl00?ooo`3oool0AP3oool20?l0o`D0oooo0P00
000Q0?ooo`030?l0o`3oool0oooo0200oooo3P3io`0G0?ooo`80R03oFP3oool006T0oooo00<0R03o
0?ooo`3oool0303oool20?Wo04L0oooo00<0o`3o0?ooo`3oool01@3oool00`000000oooo0?ooo`0P
0?ooo`80o`3o8`3ooolB0?Wo0180oooo00<0R03o0?ooo`3oool0F03oool006P0oooo00<0R03o0?oo
o`3oool03@3oool00`3io`00oooo0?ooo`140?ooo`80o`3o203oool00`000000oooo0?ooo`0Q0?oo
o`80o`3o8`3oool?0?Wo01@0oooo0P280?mI0?ooo`00I`3oool208P0o`h0oooo0P3io`150?ooo`03
0?l0o`3oool0oooo00P0oooo00<000000?ooo`3oool08P3oool20?l0ob@0oooo2P3io`0H0?ooo`03
08P0o`3oool0oooo05L0oooo001V0?ooo`80R03o3`3oool00`3io`00oooo0?ooo`120?ooo`80o`3o
2`3oool00`000000oooo0?ooo`0S0?ooo`030?l0o`3oool0oooo02<0oooo1`3io`00103oool0nOl0
0?Wo003io`0F0?ooo`0308P0o`3oool0oooo05L0oooo001U0?ooo`80R03o3`3oool00`3io`00oooo
0?ooo`0L0?ooo`X0o`3o703oool20?l0o``0oooo00<000000?ooo`3oool0903oool00`3o0?l0oooo
0?ooo`0S0?ooo`L0nOl00P3oool30?Wo01D0oooo00<0R03o0?ooo`3oool0EP3oool006D0oooo0P28
0?l?0?ooo`030?Wo003oool0oooo01P0oooo103o0?l:0?ooo`D0o`3o5@3oool20?l0o`h0oooo00<0
00000?ooo`3oool09@3oool00`3o0?l0oooo0?ooo`0T0?ooo`D0nOl0103oool30?Wo01<0oooo00<0
R03o0?ooo`3oool0EP3oool006@0oooo0P280?l?0?ooo`030?Wo003oool0oooo01P0oooo0`3o0?l?
0?ooo`D0o`3o403oool20?l0oa00oooo00<000000?ooo`3oool09@3oool20?l0obH0oooo1@3io`05
0?ooo`80nOl04P3oool208P0oeL0oooo001T0?ooo`0308P0o`3oool0oooo00h0oooo00<0nOl00?oo
o`3oool05P3oool30?l0oaD0oooo1P3o0?l60?ooo`D0o`3o4P3oool00`000000oooo0?ooo`0V0?oo
o`030?l0o`3oool0oooo02H0oooo0`3io`060?ooo`80nOl04P3oool00`280?l0oooo0?ooo`1E0?oo
o`00H`3oool00`280?l0oooo0?ooo`0>0?ooo`030?Wo003oool0oooo01H0oooo00<0o`3o0?ooo`3o
ool06`3oool80?l0oaH0oooo00<000000?ooo`3oool09`3oool00`3o0?l0oooo0?ooo`0V0?ooo`<0
nOl01P3oool20?Wo0140oooo0P280?mF0?ooo`00HP3oool208P0oa00oooo00<0nOl00?ooo`3oool0
5@3oool00`3o0?l0oooo0?ooo`0j0?ooo`800000:03oool20?l0obT0oooo00<0nOl00?ooo`3oool0
1@3oool20?Wo0140oooo00<0R03o0?ooo`3oool0E03oool00680oooo00<0R03o0?ooo`3oool03P3o
ool20?Wo01H0oooo00<0o`3o0?ooo`3oool0>`3oool00`000000oooo0?ooo`0X0?ooo`030?l0o`3o
ool0oooo0300oooo0P3io`0@0?ooo`80R03oE@3oool00640oooo00<0R03o0?ooo`3oool03`3oool0
0`3io`00oooo0?ooo`0D0?ooo`030?l0o`3oool0oooo03`0oooo00<000000?ooo`3oool0:@3oool0
0`3o0?l0oooo0?ooo`0`0?ooo`80nOl0403oool00`280?l0oooo0?ooo`1C0?ooo`00H03oool208P0
oa00oooo0P3io`0E0?ooo`030?l0o`3oool0oooo03d0oooo00<000000?ooo`3oool0:@3oool00`3o
0?l0oooo0?ooo`0a0?ooo`80nOl03`3oool208P0oe@0oooo001O0?ooo`80R03o4@3oool00`3io`00
oooo0?ooo`0C0?ooo`030?l0o`3oool0oooo03h0oooo00<000000?ooo`3oool0:P3oool00`3o0?l0
oooo0?ooo`0a0?ooo`030?Wo003oool0oooo00h0oooo00<0R03o0?ooo`3oool0DP3oool005h0oooo
0P280?lA0?ooo`80nOl0503oool20?l0od00oooo00<000000?ooo`3oool0:P3oool20?l0oc<0oooo
00<0nOl00?ooo`3oool03@3oool208P0oe<0oooo001N0?ooo`0308P0o`3oool0oooo0100oooo00<0
nOl00?ooo`3oool04`3oool00`3o0?l0oooo0?ooo`0o0?ooo`030000003oool0oooo02/0oooo00<0
o`3o0?ooo`3oool0<P3oool00`3io`00oooo0?ooo`0<0?ooo`80R03oD`3oool005d0oooo00<0R03o
0?ooo`3oool04@3oool00`3io`00oooo0?ooo`0B0?ooo`80o`3o@@3oool00`000000oooo0?ooo`0[
0?ooo`80o`3o<`3oool20?Wo00h0oooo00<0R03o0?ooo`3oool0D@3oool005`0oooo0P280?lB0?oo
o`030?Wo003oool0oooo01<0oooo00<0o`3o0?ooo`3oool0@03oool00`000000oooo0?ooo`0/0?oo
o`80o`3o<`3oool00`3io`00oooo0?ooo`0<0?ooo`0308P0o`3oool0oooo0540oooo001L0?ooo`03
08P0o`3oool0oooo0140oooo00<0nOl00?ooo`3oool04P3oool00`3o0?l0oooo0?ooo`110?ooo`80
00002P3oool90800oa/0oooo0P3o0?lb0?ooo`80nOl03@3oool208P0oe80oooo001K0?ooo`80R03o
4P3oool20?Wo01<0oooo0P3o0?m30?ooo`030000003oool0oooo00H0oooo0`200?l80?ooo`<0P03o
6@3oool20?l0oc<0oooo00<0nOl00?ooo`3oool0303oool00`280?l0oooo0?ooo`1@0?ooo`00FP3o
ool208P0oa<0oooo00<0nOl00?ooo`3oool04P3oool00`3o0?l0oooo0?ooo`120?ooo`030000003o
ool0oooo00D0oooo0`200?l;0?ooo`80P03o6@3oool20?l0oc80oooo0P3io`0=0?ooo`0308P0o`3o
ool0oooo0500oooo001I0?ooo`80R03o4`3oool20?Wo01<0oooo0P3o0?m40?ooo`030000003oool0
oooo00@0oooo0P200?l?0?ooo`030800o`3oool0oooo01L0oooo00<0o`3o0?ooo`3oool0<@3oool0
0`3io`00oooo0?ooo`0;0?ooo`80R03oD@3oool005P0oooo00<0R03o0?ooo`3oool04`3oool20?Wo
01<0oooo00<0o`3o0?ooo`3oool0@`3oool00`000000oooo0?ooo`020?ooo`80P03o4P3oool00`20
0?l0oooo0?ooo`0F0?ooo`80o`3o<P3oool20?Wo00d0oooo00<0R03o0?ooo`3oool0C`3oool005L0
oooo00<0R03o0?ooo`3oool04`3oool20?Wo01<0oooo0P3o0?m50?ooo`040000003oool0oooo0?oo
o`80P03o503oool20800oaL0oooo0P3o0?lb0?ooo`030?Wo003oool0oooo00/0oooo00<0R03o0?oo
o`3oool0C`3oool005L0oooo00<0R03o0?ooo`3oool04`3oool20?Wo01<0oooo00<0o`3o0?ooo`3o
ool0A03oool00`000000oooo0?ooo`020800oaH0oooo00<0P03o0?ooo`3oool05@3oool20?l0oc80
oooo00<0nOl00?ooo`3oool0303oool00`280?l0oooo0?ooo`1>0?ooo`00EP3oool00`280?l0oooo
0?ooo`0C0?ooo`80nOl04`3oool20?l0odH0oooo00@000000?ooo`200?l0P03o603oool00`200?l0
oooo0?ooo`0E0?ooo`80o`3o<P3oool00`3io`00oooo0?ooo`0;0?ooo`0308P0o`3oool0oooo04h0
oooo001E0?ooo`0308P0o`3oool0oooo01@0oooo00<0nOl00?ooo`3oool04P3oool00`3o0?l0oooo
0?ooo`0_0?ooo`@000000`3oool2000000@0oooo0P0000070?ooo`03000000200?l0P03o01T0oooo
0P200?lG0?ooo`030?l0o`3oool0oooo0300oooo00<0nOl00?ooo`3oool02`3oool00`280?l0oooo
0?ooo`1>0?ooo`00E03oool208P0oaH0oooo00<0nOl00?ooo`3oool04@3oool00`3o0?l0oooo0?oo
o`0`0?ooo`030000003oool0oooo00T0oooo00@000000?ooo`3oool000001P3oool20800oa/0oooo
0P200?lF0?ooo`80o`3o<@3oool20?Wo00`0oooo0P280?m?0?ooo`00E03oool00`280?l0oooo0?oo
o`0D0?ooo`80nOl04`3oool00`3o0?l0oooo0?ooo`0a0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool0103oool00`200?l000000000000K0?ooo`80P03o5P3oool20?l0oc40oooo00<0
nOl00?ooo`3oool02P3oool208P0odl0oooo001C0?ooo`0308P0o`3oool0oooo01D0oooo0P3io`0B
0?ooo`80o`3o;03oool4000000@0oooo00<000000?ooo`3oool0203oool2000000H0oooo00<0P03o
0000003oool07@3oool00`200?l0oooo0?ooo`0E0?ooo`030?l0o`3oool0oooo02l0oooo0P3io`0<
0?ooo`0308P0o`3oool0oooo04d0oooo001B0?ooo`80R03o5`3oool00`3io`00oooo0?ooo`0A0?oo
o`030?l0o`3oool0oooo0340oooo00@000000?ooo`3oool000002@3oool00`000000oooo0?ooo`04
0?ooo`030800o`3oool0000001h0oooo0P200?lF0?ooo`80o`3o<03oool20?Wo00`0oooo00<0R03o
0?ooo`3oool0C@3oool00540oooo0P280?lG0?ooo`80nOl04`3oool00`3o0?l0oooo0?ooo`0b0?oo
o`8000002P3oool3000000<0oooo0P200?l00`3oool000000?ooo`0N0?ooo`030800o`3oool0oooo
01D0oooo00<0o`3o0?ooo`3oool0;`3oool00`3io`00oooo0?ooo`0:0?ooo`0308P0o`3oool0oooo
04d0oooo001A0?ooo`0308P0o`3oool0oooo01H0oooo00<0nOl00?ooo`3oool04@3oool20?l0odD0
oooo0P200?l20?ooo`030000003oool0oooo01d0oooo0P200?lG0?ooo`030?l0o`3oool0oooo02h0
oooo0P3io`0;0?ooo`80R03oCP3oool00500oooo00<0R03o0?ooo`3oool05`3oool00`3io`00oooo
0?ooo`0A0?ooo`80o`3oA03oool20800o`<0oooo00<000000?ooo`3oool07P3oool20800oaH0oooo
00<0o`3o0?ooo`3oool0;`3oool00`3io`00oooo0?ooo`0:0?ooo`0308P0o`3oool0oooo04`0oooo
001?0?ooo`80R03o603oool20?Wo01<0oooo00<0o`3o0?ooo`3oool0@`3oool00`200?l0oooo0?oo
o`020?ooo`030000003oool0oooo01l0oooo00<0P03o0?ooo`3oool05@3oool00`3o0?l0oooo0?oo
o`0^0?ooo`030?Wo003oool0oooo00X0oooo00<0R03o0?ooo`3oool0C03oool004l0oooo00<0R03o
0?ooo`3oool05`3oool00`3io`00oooo0?ooo`0B0?ooo`030?l0o`3oool0oooo0480oooo00<0P03o
0?ooo`3oool00`3oool00`000000oooo0?ooo`0O0?ooo`030800o`3oool0oooo01D0oooo0P3o0?l_
0?ooo`80nOl02`3oool00`280?l0oooo0?ooo`1<0?ooo`00CP3oool00`280?l0oooo0?ooo`0H0?oo
o`030?Wo003oool0oooo0140oooo0P3o0?m30?ooo`80P03o1@3oool00`000000oooo0?ooo`0O0?oo
o`80P03o5`3oool00`3o0?l0oooo0?ooo`0^0?ooo`030?Wo003oool0oooo00T0oooo0P280?m=0?oo
o`00C@3oool208P0oaT0oooo0P3io`0C0?ooo`030?l0o`3oool0oooo0480oooo00<0P03o0?ooo`3o
ool0103oool00`000000oooo0?ooo`0P0?ooo`030800o`3oool0oooo01H0oooo00<0o`3o0?ooo`3o
ool0;@3oool00`3io`00oooo0?ooo`090?ooo`80R03oC@3oool004d0oooo00<0R03o0?ooo`3oool0
603oool00`3io`00oooo0?ooo`0A0?ooo`80o`3o@`3oool20800o`H0oooo0P00000Q0?ooo`80P03o
603oool00`3o0?l0oooo0?ooo`0/0?ooo`030?Wo003oool0oooo00X0oooo00<0R03o0?ooo`3oool0
B`3oool004`0oooo0P280?lJ0?ooo`030?Wo003oool0oooo0140oooo0P3o0?m20?ooo`80P03o1`3o
ool00`000000oooo0?ooo`0P0?ooo`80P03o603oool20?l0obd0oooo0P3io`0;0?ooo`0308P0o`3o
ool0oooo04/0oooo001<0?ooo`0308P0o`3oool0oooo01P0oooo0P3io`0C0?ooo`030?l0o`3oool0
oooo0440oooo00<0P03o0?ooo`3oool01P3oool00`000000oooo0?ooo`0Q0?ooo`80P03o603oool0
0`3o0?l0oooo0?ooo`0/0?ooo`030?Wo003oool0oooo00T0oooo00<0R03o0?ooo`3oool0B`3oool0
04/0oooo0P280?lJ0?ooo`030?Wo003oool0oooo0180oooo00<0o`3o0?ooo`3oool0@03oool00`20
0?l0oooo0?ooo`070?ooo`030000003oool0oooo0240oooo0P200?lH0?ooo`80o`3o;@3oool00`3i
o`00oooo0?ooo`090?ooo`80R03oC03oool004X0oooo0P280?lK0?ooo`030?Wo003oool0oooo0140
oooo0P3o0?m10?ooo`80P03o2@3oool00`000000oooo0?ooo`0R0?ooo`030800o`3oool0oooo01L0
oooo0P3o0?l/0?ooo`80nOl02`3oool00`280?l0oooo0?ooo`1:0?ooo`00BP3oool208P0oaX0oooo
0P3io`0C0?ooo`030?l0o`3oool0oooo03l0oooo0P200?l:0?ooo`030000003oool0oooo00/0oooo
1@3o0?@B0?ooo`80P03o6@3oool00`3o0?l0oooo0?ooo`0Z0?ooo`80nOl02`3oool00`280?l0oooo
0?ooo`1:0?ooo`00BP3oool00`280?l0oooo0?ooo`0I0?ooo`80nOl04`3oool00`3o0?l0oooo0?oo
o`0o0?ooo`80P03o2P3oool00`000000oooo0?ooo`090?ooo`80o`3d1@3oool20?l0m140oooo00<0
P03o0?ooo`3oool05`3oool20?l0ob/0oooo0P3io`0;0?ooo`0308P0o`3oool0oooo04X0oooo001:
0?ooo`0308P0o`3oool0oooo01T0oooo00<0nOl00?ooo`3oool04P3oool00`3o0?l0oooo0?ooo`0n
0?ooo`80P03o2`3oool00`000000o`3d0?ooo`070?ooo`<0o`3d1`3oool20?l0m100oooo00<0P03o
0?ooo`3oool0603oool20?l0ob/0oooo00<0nOl00?ooo`3oool02@3oool00`280?l0oooo0?ooo`1:
0?ooo`00B@3oool00`280?l0oooo0?ooo`0J0?ooo`030?Wo003oool0oooo0180oooo00<0o`3o0?oo
o`3oool0?P3oool00`200?l0oooo0?ooo`0:0?ooo`030000003o0?@0oooo00H0oooo0`3o0?@90?oo
o`80o`3d3`3oool20800oaX0oooo0P3o0?lZ0?ooo`030?Wo003oool0oooo00T0oooo0P280?m;0?oo
o`00B@3oool00`280?l0oooo0?ooo`0I0?ooo`80nOl04`3oool20?l0oa`0oooo0`200?lP0?ooo`03
0800o`3oool0oooo00/0oooo00<000000?l0m03o0?@01@3oool30?l0m0/0oooo0P3o0?@>0?ooo`80
P03o6`3oool00`3o0?l0oooo0?ooo`0X0?ooo`030?Wo003oool0oooo00X0oooo00<0R03o0?ooo`3o
ool0B@3oool004P0oooo0P280?lK0?ooo`030?Wo003oool0oooo0180oooo00<0o`3o0?ooo`3oool0
603oool30800o`80oooo0`200?lM0?ooo`80P03o3@3oool00`000000o`3d0?l0m0050?ooo`80o`3d
3@3oool00`3o0?@0oooo0?ooo`0=0?ooo`030800o`3oool0oooo01X0oooo00<0o`3o0?ooo`3oool0
9`3oool20?Wo00/0oooo0P280?m:0?ooo`00B03oool00`280?l0oooo0?ooo`0J0?ooo`030?Wo003o
ool0oooo0180oooo00<0o`3o0?ooo`3oool05P3oool30800o`L0oooo0`200?lJ0?ooo`030800o`3o
ool0oooo00`0oooo00@000000?l0m03o0?@0o`3d0`3oool30?l0m0h0oooo00<0o`3d0?ooo`3oool0
303oool00`200?l0oooo0?ooo`0K0?ooo`030?l0o`3oool0oooo02H0oooo0P3io`0;0?ooo`80R03o
BP3oool004P0oooo00<0R03o0?ooo`3oool06@3oool20?Wo01@0oooo00<0o`3o0?ooo`3oool05@3o
ool20800o`/0oooo0P200?lH0?ooo`80P03o3P3oool01@000000o`3d0?l0m03o0?@0oooo00@0o`3d
3`3oool20?l0m0d0oooo0P200?lM0?ooo`030?l0o`3oool0oooo02H0oooo00<0nOl00?ooo`3oool0
2@3oool308P0odT0oooo00180?ooo`0308P0o`3oool0oooo01T0oooo0P3io`0D0?ooo`030?l0o`3o
ool0oooo01D0oooo00<0P03o0?ooo`3oool0303oool20800oaH0oooo00<0P03o0?ooo`3oool03@3o
ool00`000000o`3d0?l0m0060?l0m100oooo00<0o`3d0?ooo`3oool0303oool00`200?l0oooo0?oo
o`0K0?ooo`80o`3o9`3oool00`3io`00oooo0?ooo`080?ooo`@0R03oB@3oool004L0oooo0P280?lK
0?ooo`030?Wo003oool0oooo0180oooo0P3o0?lF0?ooo`030800o`3oool0oooo00h0oooo0P200?lD
0?ooo`030800o`3oool0oooo00h0oooo00<000000?l0m03o0?@01@3o0?@A0?ooo`80o`3d3@3oool0
0`200?l0oooo0?ooo`0L0?ooo`80o`3o9P3oool00`3io`00oooo0?ooo`080?ooo`@0R03oB@3oool0
04L0oooo00<0R03o0?ooo`3oool06P3oool00`3io`00oooo0?ooo`0B0?ooo`030?l0o`3oool0oooo
01@0oooo00<0P03o0?ooo`3oool0403oool20800oa80oooo00<0P03o0?ooo`3oool03`3oool00`00
0000o`3d0?l0m0050?l0m180oooo00<0o`3d0?ooo`3oool02`3oool00`200?l0oooo0?ooo`0M0?oo
o`80o`3o9@3oool20?Wo00T0oooo1@280?m80?ooo`00A`3oool00`280?l0oooo0?ooo`0J0?ooo`03
0?Wo003oool0oooo0180oooo00<0o`3o0?ooo`3oool04`3oool20800oa@0oooo00<0P03o0?ooo`3o
ool03P3oool20800oa40oooo00<000000?l0m03o0?@0103o0?@C0?ooo`80o`3d303oool20800oal0
oooo0P3o0?lT0?ooo`80nOl02@3oool508P0odP0oooo00170?ooo`0308P0o`3oool0oooo01T0oooo
0P3io`0D0?ooo`030?l0o`3oool0oooo01<0oooo00<0P03o0?ooo`3oool0503oool20800o`T0oooo
0`200?l00`3oool0P03o0?ooo`0B0?ooo`030000003o0?@0o`3d00@0o`3d4`3oool20?l0m0d0oooo
00<0P03o0?ooo`3oool07P3oool20?l0ob@0oooo00<0nOl00?ooo`3oool01`3oool508P0odP0oooo
00160?ooo`0308P0o`3oool0oooo01X0oooo00<0nOl00?ooo`3oool04`3oool00`3o0?l0oooo0?oo
o`0B0?ooo`80P03o5`3oool30800o`H0oooo1P200?lC0?ooo`030000003o0?@0o`3d00<0o`3d5@3o
ool00`3o0?@0oooo0?ooo`0;0?ooo`030800o`3oool0oooo01l0oooo0P3o0?lS0?ooo`030?Wo003o
ool0oooo00L0oooo1P280?m70?ooo`00AP3oool00`280?l0oooo0?ooo`0J0?ooo`030?Wo003oool0
oooo0180oooo0P3o0?lD0?ooo`80P03o603oool20800o`D0oooo1`200?lC0?ooo`030000003o0?@0
o`3d00<0o`3d5@3oool20?l0m0`0oooo00<0P03o0?ooo`3oool0803oool00`3o0?l0oooo0?ooo`0Q
0?ooo`030?Wo003oool0oooo00L0oooo1P280?m70?ooo`00AP3oool00`280?l0oooo0?ooo`0J0?oo
o`030?Wo003oool0oooo0180oooo00<0o`3o0?ooo`3oool04`3oool00`200?l0oooo0?ooo`060?oo
o`D0Uol03@3oool30800o`<0oooo1`200?lC0?ooo`030000003o0?@0o`3d0080o`3d5`3oool00`3o
0?@0oooo0?ooo`0:0?ooo`80P03o8P3oool00`3o0?l0oooo0?ooo`0P0?ooo`030?Wo003oool0oooo
00L0oooo1`280?m60?ooo`00AP3oool00`280?l0oooo0?ooo`0I0?ooo`80nOl0503oool00`3o0?l0
oooo0?ooo`0B0?ooo`80P03o1P3oool209Oo00@0oooo1P2Go`0:0?ooo`/0P03o4`3oool00`000000
o`3d0?l0m0020?l0m1L0oooo00<0o`3d0?ooo`3oool02P3oool20800ob80oooo0P3o0?lQ0?ooo`03
0?Wo003oool0oooo00L0oooo1`280?m60?ooo`00A@3oool208P0oa/0oooo0P3io`0D0?ooo`030?l0
o`3oool0oooo0180oooo0P200?l50?ooo`80Uol01`3oool509Oo00h0oooo1@200?lD0?ooo`040000
003o0?@0o`3d0?l0m1P0oooo0P3o0?@<0?ooo`030800o`3oool0oooo0240oooo0P3o0?lP0?ooo`03
0?Wo003oool0oooo00L0oooo0`280?l0103oool0R03o08P0o`280?m60?ooo`00A03oool308P0oa/0
oooo00<0nOl00?ooo`3oool04`3oool00`3o0?l0oooo0?ooo`0B0?ooo`030800o`3oool0oooo00<0
oooo0P2Go`070?ooo`L0Uol03P3oool30800oaD0oooo00@000000?l0m03o0?@0o`3d603oool20?l0
m0`0oooo00<0P03o0?ooo`3oool08P3oool00`3o0?l0oooo0?ooo`0N0?ooo`030?Wo003oool0oooo
00H0oooo10280?l20?ooo`<0R03oA@3oool004<0oooo1@280?lJ0?ooo`030?Wo003oool0oooo0180
oooo0`3o0?lC0?ooo`030800o`3oool0oooo00<0oooo00<0Uol00?ooo`3oool01P3oool709Oo02H0
oooo00<000000?l0m03o0?@06@3oool30?l0m0/0oooo00<0P03o0?ooo`3oool08P3oool20?l0oal0
oooo0P3io`070?ooo`D0R03o0P3oool208P0odD0oooo00070?ooo`D000000P3oool2000002H0oooo
00<000000?ooo`3oool00P3oool2000000@0oooo00<0000008P0o`280?l01@280?lI0?ooo`030?Wo
003oool0oooo00H0oooo0P0000090?ooo`D0o`3o4@3oool20800o`@0oooo0P2Go`03000000@0oi`0
00<0000009Oo002Go`001@2Go`0V0?ooo`030000003o0?@0o`3d01P0oooo1@3o0?@80?ooo`800000
00<0P03o0000003oool00P3oool2000000@0oooo0P00000I0?ooo`030?l0o`3oool0oooo00`0oooo
0P00000?0?ooo`80nOl01`3oool308P0o`030?ooo`280?l0oooo0080oooo0P280?l70?ooo`030000
003oool0oooo0080oooo0P0000040?ooo`800000903oool500000080oooo0P0000030?ooo`002@3o
ool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool08`3oool00`000000oooo
0?ooo`070?ooo`030000003oool0R03o00H0R03o5`3oool30?Wo00L0oooo00@000000?ooo`3oool0
00001`3oool70?l0oa00oooo0P200?l40?ooo`0409Oo003oool000000?ooo`80oi`00`3oool20?nL
00D0Uol000<0oooo0000003oool0903oool00`000000o`3d0?ooo`0G0?ooo`L0o`3d1`3oool00`00
0000oooo0800o`090?ooo`040000003oool0oooo000001P0oooo0P3o0?l<0?ooo`040000003oool0
oooo000000l0oooo00<0nOl00?ooo`3oool01@3oool208P0o`80oooo00<0R03o0?ooo`3oool00P3o
ool00`280?l0oooo0?ooo`050?ooo`030000003oool0oooo00L0oooo00@000000?ooo`3oool00000
9@3oool01@000000oooo0?ooo`3oool000000080oooo0@0000010?ooo`40oooo00090?ooo`050000
003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo00T0
oooo1`280?lF0?ooo`D0nOl02@3oool00`000000oooo0?ooo`050?ooo`L0o`3o403oool00`200?l0
oooo0?ooo`020?ooo`80Uol00P3oool20?nL00D0oooo103oW00309Oo00030000003oool0oooo02<0
oooo00<000000?l0m03oool05`3oool70?l0m0P0oooo00<000000800o`200?l02`3oool00`000000
oooo0?ooo`0G0?ooo`030?l0o`3oool0oooo00d0oooo00<000000?ooo`3oool03@3oool00`3io`00
oooo0?ooo`050?ooo`80R03o0P3oool00`280?l0oooo0?ooo`0:0?ooo`030000003oool0oooo00X0
oooo00<000000?ooo`3oool08`3oool01@000000oooo0?ooo`3oool000000080oooo0@0000010?oo
o`40oooo00000`3oool0000000000002000000@0oooo00D000000?ooo`3oool0oooo000000020?oo
o`030000003oool0oooo01/0oooo100000050?ooo`030000003oool0oooo00L0oooo0P00000508P0
oaH0oooo1`3io`03000000<0oooo0P0000080?ooo`L0o`3o403oool00`200?l0oooo000000020000
0080Uol000@0oooo0?nL003oW00000001@3oool50?nL00030000002Go`00oooo02D0oooo00<00000
0?l0m03oool05`3oool70?l0m0T0oooo0P200?l90?ooo`8000006P3oool20?l0o``0oooo0P00000@
0?ooo`030?Wo003oool0oooo00D0oooo00D0R03o0?ooo`3oool0oooo08P0o`0=0?ooo`030000003o
ool0oooo00L0oooo0P00000V0?ooo`050000003oool0oooo0?ooo`0000000P3oool100000040oooo
0@3oool000T0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo0240oooo
00@000000?ooo`3oool000002@3oool00`000000oooo0?ooo`0308P0oaL0oooo1`3io`060?ooo`03
0000003oool0oooo00P0oooo1@3o0?lA0?ooo`030800o`3oool0oooo0080oooo00@0Uol00?ooo`3o
ool0oi`00P3oool010000000oooo0?ooo`3oool70?nL0080Uol09@3oool00`000000o`3d0?ooo`0H
0?ooo`D0o`3d203oool010000000oooo0?ooo`200?l90?ooo`030000003oool0oooo01X0oooo00<0
o`3o0?ooo`3oool02P3oool00`000000oooo0?ooo`0?0?ooo`030?Wo003oool0oooo00T0oooo00<0
R03o0?ooo`3oool0203oool010000000oooo0?ooo`0000090?ooo`030000003oool0oooo02D0oooo
00D000000?ooo`3oool0oooo000000020?ooo`4000000@3oool10?ooo`00203oool2000000@0oooo
0P00000T0?ooo`@000002@3oool300000080R03o603oool70?Wo00H0oooo0`0000090?ooo`<0o`3o
4P3oool00`200?l0oooo0?ooo`020?ooo`0409Oo003oool0oi`00?nL00800000103oool70?nL0003
0000002Go`00oooo02@0oooo0P3o0?@J0?ooo`<0o`3d2P3oool2000000030800o`3oool0oooo00L0
oooo0`00000K0?ooo`030?l0o`3oool0oooo00T0oooo0`00000?0?ooo`030?Wo003oool0oooo00T0
oooo00<0R03o0?ooo`3oool0203oool4000000T0oooo0`00000T0?ooo`800000103oool2000000<0
oooo00140?ooo`0308P0o`3oool0oooo01P0oooo1@3io`0D0?ooo`030?l0o`3oool0oooo0140oooo
00<0P03o0?ooo`3oool00P3oool00`2Go`00oooo0?nL00070?ooo`L0oi`000<0oooo09Oo002Go`00
903oool20?l0m1`0oooo00<0o`3d0?ooo`3oool02P3oool00`200?l0oooo0?ooo`0U0?ooo`030?l0
o`3oool0oooo01/0oooo00<0nOl00?ooo`3oool02@3oool00`280?l0oooo0?ooo`170?ooo`00A03o
ool00`280?l0oooo0?ooo`0I0?ooo`<0nOl05@3oool00`3o0?l0oooo0?ooo`0A0?ooo`050800o`3o
ool0oooo0?ooo`2Go`000P3oool00`3oW000oooo0?ooo`060?ooo`D0oi`00`3oool00`2Go`00oooo
0?ooo`0R0?ooo`030?l0m03oool0oooo01/0oooo00<0o`3d0?ooo`3oool02P3oool00`200?l0oooo
0?ooo`0U0?ooo`030?l0o`3oool0oooo01/0oooo00<0nOl00?ooo`3oool02@3oool00`280?l0oooo
0?ooo`170?ooo`00A03oool00`280?l0oooo0?ooo`0J0?ooo`030?Wo003oool0oooo01<0oooo00<0
o`3o0?ooo`3oool04@3oool20800o`<0oooo00@0Uol00?ooo`3oool0oi`02@3oool40?nL00<0oooo
00<0Uol00?ooo`3oool08P3oool00`3o0?@0oooo0?ooo`0K0?ooo`030?l0m03oool0oooo00X0oooo
00<0P03o0?ooo`3oool09@3oool00`3o0?l0oooo0?ooo`0K0?ooo`030?Wo003oool0oooo00T0oooo
00<0R03o0?ooo`3oool0A`3oool004@0oooo00<0R03o0?ooo`3oool06P3oool00`3io`00oooo0?oo
o`0C0?ooo`030?l0o`3oool0oooo0140oooo00<0P03o0?ooo`3oool00P3oool0102Go`00oooo0?oo
o`3oW00<0?ooo`040?nL003oool0oooo0?ooo`80Uol08`3oool00`3o0?@0oooo0?ooo`0K0?ooo`03
0?l0m03oool0oooo00X0oooo00<0P03o0?ooo`3oool09@3oool00`3o0?l0oooo0?ooo`0K0?ooo`03
0?Wo003oool0oooo00T0oooo00<0R03o0?ooo`3oool0A`3oool004@0oooo00<0R03o0?ooo`3oool0
6P3oool00`3io`00oooo0?ooo`0C0?ooo`030?l0o`3oool0oooo0140oooo00<0P03o0?ooo`3oool0
0P3oool0102Go`00oooo0?nL003oW00<0?ooo`030?nL003oool0oooo0080oooo00<0Uol00?ooo`3o
ool08@3oool00`3o0?@0oooo0?ooo`0K0?ooo`030?l0m03oool0oooo00X0oooo00<0P03o0?ooo`3o
ool09@3oool20?l0oa`0oooo00<0nOl00?ooo`3oool02@3oool00`280?l0oooo0?ooo`170?ooo`00
A03oool00`280?l0oooo0?ooo`0J0?ooo`030?Wo003oool0oooo01<0oooo00<0o`3o0?ooo`3oool0
4@3oool00`200?l0oooo0?ooo`020?ooo`0309Oo003oool0oi`000d0oooo00<0oi`00?ooo`3oool0
0P3oool00`2Go`00oooo0?ooo`0Q0?ooo`030?l0m03oool0oooo01/0oooo00<0o`3d0?ooo`3oool0
2P3oool00`200?l0oooo0?ooo`0V0?ooo`030?l0o`3oool0oooo01X0oooo00<0nOl00?ooo`3oool0
2@3oool00`280?l0oooo0?ooo`170?ooo`00A03oool00`280?l0oooo0?ooo`0J0?ooo`030?Wo003o
ool0oooo01<0oooo0P3o0?lB0?ooo`030800o`3oool0oooo0080oooo00<0Uol00?ooo`3oW0003@3o
ool20?nL00<0oooo00<0Uol00?ooo`3oool08@3oool00`3o0?@0oooo0?ooo`0K0?ooo`030?l0m03o
ool0oooo00X0oooo00<0P03o0?ooo`3oool09P3oool00`3o0?l0oooo0?ooo`0J0?ooo`030?Wo003o
ool0oooo00T0oooo00<0R03o0?ooo`3oool0A`3oool000T0oooo>`0000000`280?l000000000000J
000000030?Wo00000000000001<0000000<0o`3o0000000000004@0000000`200?l0000000000002
0000000309Oo00000000oi`000h0000000D0oi`0000000000000000009Oo000S000000030?l0m000
0000000001/0000000<0o`3d0000000000002P0000000`200?l000000000000V000000030?l0o`00
0000000001X0000000<0nOl00000000000002@0000000`280?l0000000000011000000H0oooo0009
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`06
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`06
0?ooo`030000003oool0R03o00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0nOl000L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`02
0?ooo`030?l0o`3oool0oooo0080oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`03
0?ooo`080800o`3oool0oooo0?ooo`000000Uol00?ooo`3oW0060?ooo`030000003oool0oooo00D0
oooo00D0oi`00000003oool0oooo09Oo00060?ooo`030000003oool0oooo00H0oooo00<000000?oo
o`3oool01`3oool00`000000oooo0?ooo`070?ooo`030?l0m03oool0oooo00H0oooo00<000000?oo
o`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0o`3d00L0oooo00<000000?oo
o`3oool00P3oool00`200?l0oooo0?ooo`020?ooo`030000003oool0oooo00H0oooo00<000000?oo
o`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00D0oooo00<0o`3o0?oo
o`0000002@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00D0oooo00<0nOl00?oo
o`000000203oool00`000000R03o0?ooo`070?ooo`030000003oool0oooo00L0oooo00<000000?oo
o`3oool01P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<000000?oo
o`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00@0oooo00090?ooo`03
0000003oool0oooo02d0oooo00<000000?ooo`3oool0203oool00`280?l0oooo0?ooo`0J0?ooo`03
0?Wo003oool0oooo00D0oooo00<000000?ooo`3oool02`3oool00`3o0?l0oooo0?ooo`0A0?ooo`03
0800o`3oool0oooo0080oooo00<0Uol00?ooo`3oW0001P3oool00`000000oooo0?ooo`040?ooo`03
0?nL003oool0oooo0080oooo00<0Uol00?ooo`3oool08@3oool00`3o0?@0oooo0?ooo`0K0?ooo`03
0?l0m03oool0oooo00X0oooo00<0P03o0?ooo`3oool00P3oool00`000000oooo0?ooo`0Q0?ooo`03
0?l0o`3oool0oooo00T0oooo00<000000?ooo`3oool03P3oool00`3io`00oooo0?ooo`090?ooo`03
08P0o`3oool0oooo0100oooo00<000000?ooo`3oool0;@3oool00`000000oooo0?ooo`040?ooo`00
A03oool00`280?l0oooo0?ooo`0J0?ooo`030?Wo003oool0oooo01<0oooo00<0o`3o0?ooo`3oool0
4@3oool00`200?l0oooo0?ooo`020?ooo`0409Oo003oool0oi`00?nL00`0oooo00<0oi`00?ooo`3o
ool00P3oool00`2Go`00oooo0?ooo`0Q0?ooo`030?l0m03oool0oooo01/0oooo00<0o`3d0?ooo`3o
ool02P3oool00`200?l0oooo0?ooo`0U0?ooo`80o`3o703oool00`3io`00oooo0?ooo`090?ooo`03
08P0o`3oool0oooo04L0oooo00140?ooo`0308P0o`3oool0oooo01X0oooo00<0nOl00?ooo`3oool0
4`3oool00`3o0?l0oooo0?ooo`0A0?ooo`030800o`3oool0oooo0080oooo00@0Uol00?ooo`3oool0
oi`02`3oool20?nL00<0oooo0P2Go`0S0?ooo`030?l0m03oool0oooo01/0oooo00<0o`3d0?ooo`3o
ool02P3oool00`200?l0oooo0?ooo`0U0?ooo`030?l0o`3oool0oooo01/0oooo00<0nOl00?ooo`3o
ool02@3oool00`280?l0oooo0?ooo`170?ooo`00A03oool00`280?l0oooo0?ooo`0J0?ooo`030?Wo
003oool0oooo01<0oooo00<0o`3o0?ooo`3oool04@3oool00`200?l0oooo0?ooo`020?ooo`0409Oo
003oool0oooo0?nL00/0oooo0P3oW0030?ooo`0309Oo003oool0oooo0280oooo00<0o`3d0?ooo`3o
ool06`3oool00`3o0?@0oooo0?ooo`0:0?ooo`030800o`3oool0oooo02D0oooo00<0o`3o0?ooo`3o
ool06`3oool00`3io`00oooo0?ooo`090?ooo`0308P0o`3oool0oooo04L0oooo00140?ooo`0308P0
o`3oool0oooo01X0oooo00<0nOl00?ooo`3oool04`3oool20?l0oa80oooo0P200?l30?ooo`0409Oo
003oool0oooo0?nL00X0oooo103oW0020?ooo`0309Oo003oool0oooo0280oooo00<0o`3d0?ooo`3o
ool06`3oool00`3o0?@0oooo0?ooo`0:0?ooo`030800o`3oool0oooo02D0oooo00<0o`3o0?ooo`3o
ool06`3oool00`3io`00oooo0?ooo`090?ooo`0308P0o`3oool0oooo04L0oooo00140?ooo`0308P0
o`3oool0oooo01X0oooo0P3io`0D0?ooo`80o`3o4`3oool010200?l0oooo0?ooo`3oool209Oo0003
0?ooo`3oW000oooo00T0oooo103oW0000`3oool0Uol009Oo000T0?ooo`030?l0m03oool0oooo01/0
oooo00<0o`3d0?ooo`3oool02P3oool00`200?l0oooo0?ooo`0U0?ooo`030?l0o`3oool0oooo01/0
oooo00<0nOl00?ooo`3oool02@3oool00`280?l0oooo0?ooo`170?ooo`00A03oool208P0oa/0oooo
0P3io`0E0?ooo`030?l0o`3oool0oooo0140oooo00<0P03o0?ooo`3oool00P3oool0102Go`00oooo
0?nL003oW0090?ooo`@0oi`000<0oooo09Oo003oool0903oool20?l0m1`0oooo00<0o`3d0?ooo`3o
ool02P3oool00`200?l0oooo0?ooo`0T0?ooo`80o`3o7@3oool00`3io`00oooo0?ooo`090?ooo`03
08P0o`3oool0oooo04L0oooo00150?ooo`0308P0o`3oool0oooo01X0oooo00<0nOl00?ooo`3oool0
4`3oool00`3o0?l0oooo0?ooo`0A0?ooo`030800o`3oool0oooo0080oooo00@0Uol00?ooo`3oool0
oi`0203oool50?nL0080Uol09@3oool00`000000o`3d0?ooo`0J0?ooo`80o`3d2`3oool20800obH0
oooo00<0o`3o0?ooo`3oool0703oool00`3io`00oooo0?ooo`090?ooo`0308P0o`3oool0oooo04L0
oooo00150?ooo`0308P0o`3oool0oooo01X0oooo00<0nOl00?ooo`3oool04`3oool00`3o0?l0oooo
0?ooo`0A0?ooo`030800o`3oool0oooo0080oooo00<0Uol00?ooo`3oool00P3oW0070?ooo`D0oi`0
0P2Go`0U0?ooo`030000003o0?@0oooo01X0oooo0P3o0?@;0?ooo`030800o`3oool0oooo02D0oooo
00<0o`3o0?ooo`3oool0703oool00`3io`00oooo0?ooo`090?ooo`0308P0o`3oool0oooo04L0oooo
00150?ooo`0308P0o`3oool0oooo01X0oooo00<0nOl00?ooo`3oool04`3oool00`3o0?l0oooo0?oo
o`0A0?ooo`030800o`3oool0oooo0080oooo0P2Go`020?ooo`80oi`01@3oool60?nL000309Oo003o
ool0oooo02@0oooo00<000000?l0m03oool06P3oool00`3o0?@0oooo0?ooo`0:0?ooo`030800o`3o
ool0oooo02@0oooo0P3o0?lN0?ooo`030?Wo003oool0oooo00T0oooo00<0R03o0?ooo`3oool0A`3o
ool004D0oooo00<0R03o0?ooo`3oool06P3oool00`3io`00oooo0?ooo`0C0?ooo`030?l0o`3oool0
oooo00d0oooo00D0P03o0?ooo`3oool0oooo0800o`050?ooo`0409Oo003oool0oooo0?ooo`80oi`0
0P3oool80?nL02L0oooo00<000000?l0m03oool06P3oool00`3o0?@0oooo0?ooo`0:0?ooo`030800
o`3oool0oooo02@0oooo00<0o`3o0?ooo`3oool0703oool20?Wo00/0oooo00<0R03o0?ooo`3oool0
A`3oool004D0oooo00<0R03o0?ooo`3oool06P3oool00`3io`00oooo0?ooo`0C0?ooo`030?l0o`3o
ool0oooo00d0oooo0P200?l20?ooo`80P03o103oool209Oo00<0oooo103oW0000`3oool0oi`00?nL
00050?nL02H0oooo00<000000?l0m03o0?@06P3oool00`3o0?@0oooo0?ooo`0:0?ooo`030800o`3o
ool0oooo02<0oooo0P3o0?lN0?ooo`030?Wo003oool0oooo00X0oooo00<0R03o0?ooo`3oool0A`3o
ool004D0oooo00<0R03o0?ooo`3oool06P3oool20?Wo01@0oooo00<0o`3o0?ooo`3oool03@3oool3
0800o`80oooo00<0P03o0?ooo`3oool00`3oool00`2Go`00oooo0?ooo`050?ooo`P0oi`09P3oool0
0`000000o`3d0?l0m00J0?ooo`030?l0m03oool0oooo00X0oooo00<0P03o0?ooo`3oool08P3oool2
0?l0oal0oooo00<0nOl00?ooo`3oool02@3oool208P0odT0oooo00150?ooo`0308P0o`3oool0oooo
01X0oooo0P3io`0D0?ooo`030?l0o`3oool0oooo00d0oooo0`200?l20?ooo`030800o`3oool0oooo
00<0oooo0P2Go`060?ooo`P0oi`09P3oool00`000000oooo0?l0m00I0?ooo`80o`3d303oool00`20
0?l0oooo0?ooo`0R0?ooo`030?l0o`3oool0oooo01h0oooo00<0nOl00?ooo`3oool02@3oool208P0
odT0oooo00150?ooo`80R03o703oool00`3io`00oooo0?ooo`0B0?ooo`80o`3o3`3oool30800o`03
0?ooo`200?l0P03o00D0oooo0P2Go`050?ooo`@0oi`000@0Uol00?nL003oW000oi`09P3oool01000
0000oooo0?l0m03o0?@H0?ooo`80o`3d2`3oool20800ob<0oooo00<0o`3o0?ooo`3oool07`3oool0
0`3io`00oooo0?ooo`090?ooo`80R03oB@3oool004D0oooo0P280?lL0?ooo`030?Wo003oool0oooo
0180oooo0P3o0?l?0?ooo`@0P03o00<0oooo0800o`3oool01@3oool209Oo00<0oooo103oW00209Oo
00<0oi`0203oool70800oaL0oooo00@000000?ooo`3o0?@0o`3d603oool00`3o0?@0oooo0?ooo`0:
0?ooo`80P03o8`3oool00`3o0?l0oooo0?ooo`0O0?ooo`030?Wo003oool0oooo00T0oooo00<0R03o
0?ooo`3oool0B03oool004D0oooo0P280?lL0?ooo`030?Wo003oool0oooo01<0oooo00<0o`3o0?oo
o`3oool03@3oool60800o`L0oooo102Go`030?nL0080Uol00P3oool20?nL00L0oooo0P200?l50?oo
o`80P03o5P3oool010000000oooo0?ooo`3o0?@G0?ooo`80o`3d303oool20800ob80oooo00<0o`3o
0?ooo`3oool0803oool00`3io`00oooo0?ooo`090?ooo`0308P0o`3oool0oooo04P0oooo00160?oo
o`0308P0o`3oool0oooo01X0oooo00<0nOl00?ooo`3oool04`3oool00`3o0?l0oooo0?ooo`0:0?oo
o`X0P03o2@3oool20?nL00@0Uol00P3oool30?nL00@0oooo0P200?l90?ooo`80P03o503oool20000
00030?ooo`3o0?@0o`3d01H0oooo0P3o0?@<0?ooo`030800o`3oool0oooo0200oooo00<0o`3o0?oo
o`3oool08@3oool00`3io`00oooo0?ooo`090?ooo`0308P0o`3oool0oooo04P0oooo00160?ooo`03
08P0o`3oool0oooo01X0oooo0P3io`0D0?ooo`030?l0o`3oool0oooo00H0oooo3P200?l80?ooo`03
09Oo003oW000Uol000<0Uol0103oool20?nL00<0oooo0P200?l;0?ooo`80P03o4`3oool00`000000
oooo0?ooo`020?l0m1H0oooo00<0o`3d0?ooo`3oool02`3oool00`200?l0oooo0?ooo`0O0?ooo`03
0?l0o`3oool0oooo0280oooo00<0nOl00?ooo`3oool02@3oool00`280?l0oooo0?ooo`180?ooo`00
AP3oool208P0oa`0oooo00<0nOl00?ooo`3oool04P3oool00`3o0?l0oooo0?ooo`080?ooo``0P03o
1`3oool709Oo00@0oooo0P3oW0020?ooo`030800o`3oool0oooo00`0oooo0P200?lB0?ooo`050000
003oool0oooo0?ooo`3o0?@05@3oool20?l0m0d0oooo00<0P03o0?ooo`3oool07P3oool20?l0ob@0
oooo00<0nOl00?ooo`3oool02@3oool00`280?l0oooo0?ooo`180?ooo`00AP3oool208P0oa`0oooo
00<0nOl00?ooo`3oool04P3oool00`3o0?l0oooo0?ooo`0:0?ooo`/0P03o103oool809Oo00H0oooo
00<0oi`00?ooo`200?l0403oool00`200?l0oooo0?ooo`0@0?ooo`040000003oool0oooo0?ooo`80
o`3d503oool20?l0m0`0oooo0P200?lP0?ooo`030?l0o`3oool0oooo02<0oooo00<0nOl00?ooo`3o
ool0203oool208P0odX0oooo00170?ooo`0308P0o`3oool0oooo01X0oooo00<0nOl00?ooo`3oool0
4P3oool20?l0o`h0oooo2@200?l20?ooo`T0Uol01P3oool20800oa80oooo00<0P03o0?ooo`3oool0
3`3oool010000000oooo0?ooo`3oool20?l0m1<0oooo0P3o0?@=0?ooo`030800o`3oool0oooo01d0
oooo0P3o0?lU0?ooo`030?Wo003oool0oooo00T0oooo0P280?m:0?ooo`00A`3oool208P0oa/0oooo
00<0nOl00?ooo`3oool04P3oool20?l0oa00oooo20200?l:09Oo00D0oooo0P200?lD0?ooo`030800
o`3oool0oooo00h0oooo00<000000?ooo`3oool00P3oool20?l0m180oooo0P3o0?@=0?ooo`030800
o`3oool0oooo01`0oooo0`3o0?lU0?ooo`030?Wo003oool0oooo00T0oooo0P280?m:0?ooo`00A`3o
ool208P0oa/0oooo00<0nOl00?ooo`3oool04`3oool00`3o0?l0oooo0?ooo`0A0?ooo`<0P03o1@2G
o`000`3oool0Uol009Oo000309Oo00D0oooo00<0P03o0?ooo`3oool05@3oool00`200?l0oooo0?oo
o`0=0?ooo`030000003oool0oooo00<0oooo00<0o`3d0?ooo`3oool03`3oool20?l0m0h0oooo00<0
P03o0?ooo`3oool06`3oool30?l0obH0oooo00<0nOl00?ooo`3oool02@3oool208P0odX0oooo0018
0?ooo`0308P0o`3oool0oooo01T0oooo0P3io`0D0?ooo`030?l0o`3oool0oooo01<0oooo0P2Go`02
0800o`<0oooo1@2Go`030?ooo`80P03o603oool00`200?l0oooo0?ooo`0=0?ooo`030000003oool0
oooo00<0oooo0P3o0?@@0?ooo`80o`3d3@3oool20800oad0oooo0`3o0?lV0?ooo`030?Wo003oool0
oooo00T0oooo00<0R03o0?ooo`3oool0B@3oool004P0oooo0P280?lJ0?ooo`80nOl0503oool00`3o
0?l0oooo0?ooo`0F0?ooo`<0P03o00<0oooo09Oo002Go`000P2Go`020?ooo`<0P03o6P3oool00`20
0?l0oooo0?ooo`0<0?ooo`030000003oool0oooo00@0oooo0P3o0?@>0?ooo`80o`3d3P3oool20800
oa`0oooo103o0?lV0?ooo`030?Wo003oool0oooo00T0oooo00<0R03o0?ooo`3oool0B@3oool004P0
oooo0P280?lK0?ooo`030?Wo003oool0oooo0180oooo0P3o0?lI0?ooo`80P03o102Go`030800oad0
oooo00<0P03o0?ooo`3oool02`3oool00`000000oooo0?ooo`040?ooo`80o`3d3P3oool20?l0m0h0
oooo00<0P03o0?ooo`3oool06P3oool40?l0obH0oooo00<0nOl00?ooo`3oool02@3oool208P0od/0
oooo00190?ooo`0308P0o`3oool0oooo01T0oooo0P3io`0C0?ooo`80o`3o703oool209Oo0240oooo
0P200?l<0?ooo`8000001P3oool20?l0m0`0oooo0P3o0?@>0?ooo`80P03o6`3oool50?l0obH0oooo
00<0nOl00?ooo`3oool02@3oool208P0od/0oooo00190?ooo`0308P0o`3oool0oooo01T0oooo0P3i
o`0C0?ooo`80o`3o703oool209Oo0280oooo00<0P03o0?ooo`3oool02P3oool00`000000oooo0?oo
o`060?ooo`80o`3d2P3oool20?l0m0l0oooo0P200?lJ0?ooo`H0o`3o9P3oool00`3io`00oooo0?oo
o`090?ooo`80R03oB`3oool004T0oooo0P280?lK0?ooo`030?Wo003oool0oooo0180oooo00<0o`3o
0?ooo`3oool06P3oool00`2Go`00oooo0?ooo`0Q0?ooo`80P03o2`3oool00`000000oooo0?ooo`07
0?ooo`80o`3d203oool20?l0m100oooo00<0P03o0?ooo`3oool0603oool60?l0obL0oooo00<0nOl0
0?ooo`3oool02@3oool208P0od/0oooo001:0?ooo`0308P0o`3oool0oooo01T0oooo00<0nOl00?oo
o`3oool04P3oool00`3o0?l0oooo0?ooo`0J0?ooo`0309Oo003oool0oooo0280oooo0P200?l:0?oo
o`030000003oool0oooo00P0oooo0`3o0?@40?ooo`<0o`3d403oool20800oaT0oooo1`3o0?lW0?oo
o`030?Wo003oool0oooo00T0oooo0P280?m;0?ooo`00BP3oool208P0oa/0oooo00<0nOl00?ooo`3o
ool04@3oool20?l0od40oooo00<0P03o0?ooo`3oool0203oool00`000000oooo0?ooo`0:0?ooo`L0
o`3d4@3oool20800oaP0oooo203o0?lV0?ooo`80nOl02`3oool00`280?l0oooo0?ooo`1:0?ooo`00
B`3oool00`280?l0oooo0?ooo`0I0?ooo`030?Wo003oool0oooo0180oooo00<0o`3o0?ooo`3oool0
@03oool00`200?l0oooo0?ooo`070?ooo`030000003oool0oooo0280oooo00<0P03o0?ooo`3oool0
5P3oool90?l0obH0oooo00<0nOl00?ooo`3oool02@3oool208P0od`0oooo001<0?ooo`0308P0o`3o
ool0oooo01P0oooo0P3io`0C0?ooo`030?l0o`3oool0oooo0400oooo00<0P03o0?ooo`3oool01`3o
ool00`000000oooo0?ooo`0Q0?ooo`80P03o5`3oool40?l0o`030?ooo`3o0?l0o`3o0080o`3o9`3o
ool00`3io`00oooo0?ooo`090?ooo`80R03oC03oool004`0oooo00<0R03o0?ooo`3oool06@3oool0
0`3io`00oooo0?ooo`0A0?ooo`030?l0o`3oool0oooo0440oooo00<0P03o0?ooo`3oool01P3oool0
0`000000oooo0?ooo`0Q0?ooo`030800o`3oool0oooo01D0oooo0`3o0?l30?ooo`@0o`3o9`3oool0
0`3io`00oooo0?ooo`090?ooo`80R03oC03oool004`0oooo0P280?lJ0?ooo`030?Wo003oool0oooo
0140oooo0P3o0?m20?ooo`80P03o1`3oool00`000000oooo0?ooo`0Q0?ooo`030800o`3oool0oooo
01@0oooo103o0?l30?ooo`@0o`3o9`3oool00`3io`00oooo0?ooo`090?ooo`0308P0o`3oool0oooo
04/0oooo001<0?ooo`80R03o6P3oool00`3io`00oooo0?ooo`0B0?ooo`030?l0o`3oool0oooo0440
oooo00<0P03o0?ooo`3oool01@3oool200000240oooo00<0P03o0?ooo`3oool05P3oool20?l0o`@0
oooo0`3o0?lW0?ooo`030?Wo003oool0oooo00X0oooo00<0R03o0?ooo`3oool0B`3oool004d0oooo
0P280?lI0?ooo`80nOl04`3oool00`3o0?l0oooo0?ooo`120?ooo`030800o`3oool0oooo00@0oooo
00<000000?ooo`3oool0803oool00`200?l0oooo0?ooo`0E0?ooo`80o`3o1P3oool20?l0obL0oooo
00<0nOl00?ooo`3oool02P3oool00`280?l0oooo0?ooo`1;0?ooo`00CP3oool208P0oaT0oooo00<0
nOl00?ooo`3oool04@3oool00`3o0?l0oooo0?ooo`120?ooo`80P03o1@3oool00`000000oooo0?oo
o`0O0?ooo`030800o`3oool0oooo01H0oooo0P3o0?l60?ooo`80o`3o9P3oool20?Wo00/0oooo0P28
0?m=0?ooo`00C`3oool00`280?l0oooo0?ooo`0G0?ooo`030?Wo003oool0oooo0140oooo0P3o0?m4
0?ooo`030800o`3oool0oooo00<0oooo00<000000?ooo`3oool07`3oool00`200?l0oooo0?ooo`0E
0?ooo`80o`3o1`3oool00`3o0?l0oooo0?ooo`0U0?ooo`030?Wo003oool0oooo00X0oooo0P280?m=
0?ooo`00D03oool00`280?l0oooo0?ooo`0F0?ooo`80nOl04`3oool00`3o0?l0oooo0?ooo`130?oo
o`030800o`3oool0oooo0080oooo00<000000?ooo`3oool07P3oool20800oaL0oooo00<0o`3o0?oo
o`3oool01P3oool00`3o0?l0oooo0?ooo`0U0?ooo`030?Wo003oool0oooo00X0oooo00<0R03o0?oo
o`3oool0C03oool00500oooo0P280?lH0?ooo`030?Wo003oool0oooo0140oooo00<0o`3o0?ooo`3o
ool0A03oool01@200?l0oooo0?ooo`3oool000000200oooo00<0P03o0?ooo`3oool05@3oool20?l0
obl0oooo0P3io`0<0?ooo`0308P0o`3oool0oooo04`0oooo001A0?ooo`0308P0o`3oool0oooo01H0
oooo00<0nOl00?ooo`3oool04@3oool20?l0odH0oooo00@0P03o0?ooo`3oool000007`3oool20800
oaL0oooo00<0o`3o0?ooo`3oool0;P3oool00`3io`00oooo0?ooo`0;0?ooo`0308P0o`3oool0oooo
04`0oooo001A0?ooo`80R03o5`3oool20?Wo01<0oooo00<0o`3o0?ooo`3oool0A03oool010200?l0
oooo0?ooo`00000O0?ooo`030800o`3oool0oooo01D0oooo00<0o`3o0?ooo`3oool0;`3oool00`3i
o`00oooo0?ooo`0:0?ooo`80R03oCP3oool00580oooo0P280?lG0?ooo`030?Wo003oool0oooo0140
oooo00<0o`3o0?ooo`3oool0<@3oool4000000<0oooo0P0000040?ooo`8000001@3oool00`200?l0
oooo0000000N0?ooo`030800o`3oool0oooo01D0oooo0P3o0?l`0?ooo`80nOl0303oool00`280?l0
oooo0?ooo`1=0?ooo`00D`3oool208P0oaH0oooo00<0nOl00?ooo`3oool04@3oool20?l0oc80oooo
00<000000?ooo`3oool02@3oool010000000oooo0?ooo`0000050?ooo`030800o`000000oooo01d0
oooo00<0P03o0?ooo`3oool05@3oool00`3o0?l0oooo0?ooo`0_0?ooo`030?Wo003oool0oooo00/0
oooo00<0R03o0?ooo`3oool0C@3oool005@0oooo0P280?lF0?ooo`030?Wo003oool0oooo0140oooo
00<0o`3o0?ooo`3oool0<@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00<0oooo
0P200?l2000001/0oooo00<0P03o0?ooo`3oool05@3oool00`3o0?l0oooo0?ooo`0`0?ooo`030?Wo
003oool0oooo00/0oooo00<0R03o0?ooo`3oool0C@3oool005@0oooo0P280?lF0?ooo`030?Wo003o
ool0oooo0140oooo00<0o`3o0?ooo`3oool0<P3oool00`000000oooo0?ooo`080?ooo`8000001`3o
ool20800oa`0oooo00<0P03o0?ooo`3oool0503oool20?l0oc40oooo0P3io`0<0?ooo`80R03oC`3o
ool005D0oooo0P280?lE0?ooo`80nOl04`3oool00`3o0?l0oooo0?ooo`0_0?ooo`040000003oool0
oooo000000T0oooo00<000000?ooo`3oool01P3oool00`000000P03o0800o`0J0?ooo`030800o`3o
ool0oooo01D0oooo00<0o`3o0?ooo`3oool0<03oool00`3io`00oooo0?ooo`0;0?ooo`0308P0o`3o
ool0oooo04h0oooo001F0?ooo`80R03o5@3oool00`3io`00oooo0?ooo`0A0?ooo`030?l0o`3oool0
oooo0300oooo0P00000:0?ooo`<000001P3oool00`000000oooo0800o`0I0?ooo`030800o`3oool0
oooo01D0oooo0P3o0?la0?ooo`80nOl03@3oool00`280?l0oooo0?ooo`1>0?ooo`00E`3oool00`28
0?l0oooo0?ooo`0C0?ooo`80nOl04`3oool00`3o0?l0oooo0?ooo`140?ooo`040000003oool0oooo
0800oaL0oooo00<0P03o0?ooo`3oool05P3oool00`3o0?l0oooo0?ooo`0`0?ooo`80nOl0303oool2
08P0oe00oooo001H0?ooo`0308P0o`3oool0oooo01<0oooo00<0nOl00?ooo`3oool04@3oool00`3o
0?l0oooo0?ooo`140?ooo`040000003oool0oooo0?ooo`80P03o503oool20800oaL0oooo00<0o`3o
0?ooo`3oool0<03oool20?Wo00d0oooo0P280?m@0?ooo`00F03oool208P0oa@0oooo00<0nOl00?oo
o`3oool04P3oool00`3o0?l0oooo0?ooo`130?ooo`030000003oool0oooo0080oooo0P200?lB0?oo
o`80P03o5`3oool20?l0oc80oooo0P3io`0=0?ooo`0308P0o`3oool0oooo04l0oooo001I0?ooo`80
R03o4`3oool20?Wo01<0oooo0P3o0?m40?ooo`030000003oool0oooo00<0oooo0`200?l?0?ooo`80
P03o603oool00`3o0?l0oooo0?ooo`0`0?ooo`80nOl03@3oool208P0oe40oooo001J0?ooo`80R03o
4`3oool00`3io`00oooo0?ooo`0B0?ooo`030?l0o`3oool0oooo0480oooo00<000000?ooo`3oool0
103oool30800o``0oooo0`200?lH0?ooo`80o`3o<P3oool20?Wo00d0oooo00<0R03o0?ooo`3oool0
D03oool005/0oooo00<0R03o0?ooo`3oool04@3oool00`3io`00oooo0?ooo`0B0?ooo`80o`3o@`3o
ool00`000000oooo0?ooo`060?ooo`<0P03o2@3oool30800oaT0oooo00<0o`3o0?ooo`3oool0<03o
ool20?Wo00d0oooo0P280?mB0?ooo`00G03oool00`280?l0oooo0?ooo`0A0?ooo`030?Wo003oool0
oooo0180oooo00<0o`3o0?ooo`3oool0@@3oool2000000X0oooo2@200?lK0?ooo`030?l0o`3oool0
oooo0340oooo0P3io`0=0?ooo`0308P0o`3oool0oooo0540oooo001L0?ooo`80R03o4P3oool00`3i
o`00oooo0?ooo`0B0?ooo`80o`3o@P3oool00`000000oooo0?ooo`0/0?ooo`80o`3o<P3oool20?Wo
00h0oooo00<0R03o0?ooo`3oool0D@3oool005d0oooo0P280?lA0?ooo`80nOl0503oool00`3o0?l0
oooo0?ooo`100?ooo`030000003oool0oooo02`0oooo00<0o`3o0?ooo`3oool0<@3oool00`3io`00
oooo0?ooo`0=0?ooo`0308P0o`3oool0oooo0540oooo001N0?ooo`0308P0o`3oool0oooo0100oooo
00<0nOl00?ooo`3oool04`3oool00`3o0?l0oooo0?ooo`0o0?ooo`030000003oool0oooo02/0oooo
0P3o0?lb0?ooo`80nOl03P3oool00`280?l0oooo0?ooo`1B0?ooo`00G`3oool00`280?l0oooo0?oo
o`0?0?ooo`80nOl0503oool20?l0od00oooo00<000000?ooo`3oool0:`3oool00`3o0?l0oooo0?oo
o`0a0?ooo`030?Wo003oool0oooo00d0oooo00<0R03o0?ooo`3oool0DP3oool005l0oooo0P280?lA
0?ooo`030?Wo003oool0oooo01<0oooo0P3o0?lo0?ooo`030000003oool0oooo02X0oooo00<0o`3o
0?ooo`3oool0<@3oool00`3io`00oooo0?ooo`0=0?ooo`80R03oE03oool00600oooo0P280?l@0?oo
o`80nOl05@3oool00`3o0?l0oooo0?ooo`0m0?ooo`030000003oool0oooo02T0oooo00<0o`3o0?oo
o`3oool0<@3oool20?Wo00l0oooo0P280?mD0?ooo`00H@3oool208P0oa00oooo00<0nOl00?ooo`3o
ool0503oool00`3o0?l0oooo0?ooo`0l0?ooo`030000003oool0oooo02T0oooo00<0o`3o0?ooo`3o
ool0<03oool20?Wo0100oooo0P280?mD0?ooo`00H@3oool208P0oa00oooo0P3io`0F0?ooo`030?l0
o`3oool0oooo03/0oooo00<000000?ooo`3oool0:03oool00`3o0?l0oooo0?ooo`0a0?ooo`030?Wo
003oool0oooo00h0oooo0P280?mE0?ooo`00HP3oool208P0oa00oooo00<0nOl00?ooo`3oool05@3o
ool00`3o0?l0oooo0?ooo`0j0?ooo`800000:03oool00`3o0?l0oooo0?ooo`0a0?ooo`030?Wo003o
ool0oooo00l0oooo0P280?mE0?ooo`00H`3oool00`280?l0oooo0?ooo`0>0?ooo`80nOl05`3oool2
0?l0oa`0oooo1`3o0?lG0?ooo`030000003oool0oooo02L0oooo00<0o`3o0?ooo`3oool0;`3oool2
0?Wo0180oooo00<0R03o0?ooo`3oool0E03oool006<0oooo0P280?l@0?ooo`030?Wo003oool0oooo
01H0oooo0P3o0?lG0?ooo`H0o`3o103oool50?l0oa<0oooo00<000000?ooo`3oool09P3oool00`3o
0?l0oooo0?ooo`0_0?ooo`80nOl04P3oool208P0oeH0oooo001T0?ooo`80R03o3`3oool00`3io`00
oooo0?ooo`0G0?ooo`80o`3o4P3oool50?l0o`d0oooo0`3o0?lA0?ooo`030000003oool0oooo02D0
oooo0P3o0?l`0?ooo`80nOl04`3oool00`280?l0oooo0?ooo`1E0?ooo`00I@3oool00`280?l0oooo
0?ooo`0>0?ooo`030?Wo003oool0oooo01P0oooo103o0?l90?ooo`H0o`3o503oool20?l0o`l0oooo
00<000000?ooo`3oool0903oool20?l0obl0oooo0P3io`0D0?ooo`80R03oE`3oool006D0oooo0P28
0?l?0?ooo`80nOl0703oool<0?l0oaT0oooo0`3o0?l=0?ooo`030000003oool0oooo02@0oooo00<0
o`3o0?ooo`3oool0;@3oool20?Wo01D0oooo00<0R03o0?ooo`3oool0EP3oool006H0oooo0P280?l?
0?ooo`030?Wo003oool0oooo0440oooo0`3o0?l;0?ooo`030000003oool0oooo02<0oooo0P3o0?l/
0?ooo`<0nOl05P3oool208P0oeP0oooo001W0?ooo`0308P0o`3oool0oooo00h0oooo00<0nOl00?oo
o`3oool0@P3oool20?l0o`X0oooo00<000000?ooo`3oool08P3oool20?l0ob/0oooo103io`0G0?oo
o`0308P0o`3oool0oooo05L0oooo001W0?ooo`80R03o3`3oool00`3io`00oooo0?ooo`140?ooo`80
o`3o203oool00`000000oooo0?ooo`0Q0?ooo`80o`3o:03oool50?Wo01T0oooo00<0R03o0?ooo`3o
ool0F03oool006P0oooo00<0R03o0?ooo`3oool03P3oool00`3io`00oooo0?ooo`140?ooo`<0o`3o
1P3oool00`000000oooo0?ooo`0P0?ooo`80o`3o9P3oool50?Wo01`0oooo00<0R03o0?ooo`3oool0
F03oool006T0oooo00<0R03o0?ooo`3oool03@3oool20?Wo04L0oooo0P3o0?l50?ooo`800000803o
ool20?l0ob@0oooo0`3io`0P0?ooo`0308P0o`3oool0oooo05T0oooo001Y0?ooo`80R03o3`3oool0
0`3io`00oooo0?ooo`160?ooo`80o`3o103oool00`000000oooo0?ooo`0O0?ooo`030?l0o`3oool0
oooo0200oooo0`3io`0R0?ooo`80R03oF`3oool006X0oooo0P280?l>0?ooo`80nOl0B03oool20?l0
o`<0oooo00<000000?ooo`3oool07P3oool00`3o0?l0oooo0?ooo`0O0?ooo`<0nOl0903oool00`28
0?l0oooo0?ooo`1J0?ooo`00J`3oool00`280?l0oooo0?ooo`0=0?ooo`030?Wo003oool0oooo04L0
oooo0P3o0?l20?ooo`030000003oool0oooo01d0oooo00<0o`3o0?ooo`3oool07P3oool20?Wo02H0
oooo0P280?mL0?ooo`00K03oool00`280?l0oooo0?ooo`0<0?ooo`80nOl0BP3oool20?l0o`030000
003oool0oooo01`0oooo00<0o`3o0?ooo`3oool07@3oool20?Wo02P0oooo00<0R03o0?ooo`3oool0
F`3oool006`0oooo0P280?l>0?ooo`030?Wo003oool0oooo04X0oooo0P3o0?lL0?ooo`030?l0o`3o
ool0oooo01d0oooo00<0nOl00?ooo`3oool09`3oool208P0oed0oooo001]0?ooo`80R03o3@3oool2
0?Wo04/0oooo00<000000?l0o`3o0?l06@3oool20?l0oah0oooo0P3io`0Z0?ooo`0308P0o`3oool0
oooo05`0oooo001^0?ooo`0308P0o`3oool0oooo00`0oooo0P3io`1:0?ooo`030000003oool0oooo
0080o`3o5P3oool20?l0oah0oooo0P3io`0Z0?ooo`0308P0o`3oool0oooo05d0oooo001^0?ooo`80
R03o3@3oool20?Wo04X0oooo00@000000?ooo`3oool0oooo0`3o0?lC0?ooo`80o`3o7P3oool00`3i
o`00oooo0?ooo`0Y0?ooo`80R03oG`3oool006l0oooo00<0R03o0?ooo`3oool0303oool20?Wo04T0
oooo0P0000040?ooo`<0o`3o3`3oool20?l0oal0oooo00<0nOl00?ooo`3oool0:@3oool208P0of00
oooo001`0?ooo`0308P0o`3oool0oooo00`0oooo0P3io`180?ooo`030000003oool0oooo00@0oooo
103o0?l:0?ooo`<0o`3o7`3oool20?Wo02/0oooo0P280?mQ0?ooo`00L03oool208P0o`h0oooo00<0
nOl00?ooo`3oool0AP3oool00`000000oooo0?ooo`070?ooo``0o`3o803oool20?Wo02/0oooo0P28
0?mR0?ooo`00L@3oool00`280?l0oooo0?ooo`0=0?ooo`030?Wo003oool0oooo04D0oooo00<00000
0?ooo`3oool0<P3oool20?Wo02/0oooo0P280?mS0?ooo`00LP3oool00`280?l0oooo0?ooo`0=0?oo
o`030?Wo003oool0oooo04@0oooo00<000000?ooo`3oool0<@3oool20?Wo02`0oooo00<0R03o0?oo
o`3oool0HP3oool00780oooo00<0R03o0?ooo`3oool03P3oool00`3io`00oooo0?ooo`130?ooo`03
0000003oool0oooo0300oooo0P3io`0/0?ooo`0308P0o`3oool0oooo06<0oooo001c0?ooo`0308P0
o`3oool0oooo00d0oooo0P3io`140?ooo`030000003oool0oooo02l0oooo0P3io`0[0?ooo`80R03o
IP3oool007<0oooo0P280?l?0?ooo`030?Wo003oool0oooo0480oooo00<000000?ooo`3oool0;P3o
ool00`3io`00oooo0?ooo`0Z0?ooo`80R03oI`3oool007@0oooo0P280?l?0?ooo`80nOl0>@3oool2
000000L0oooo00<000000?ooo`3oool0;@3oool00`3io`00oooo0?ooo`0Z0?ooo`80R03oJ03oool0
07@0oooo0P280?l@0?ooo`80nOl0=`3oool010000000oooo0?ooo`0000060?ooo`030000003oool0
oooo02`0oooo00<0nOl00?ooo`3oool0:@3oool208P0ofX0oooo001e0?ooo`80R03o403oool20?Wo
03T0oooo00<000000?ooo`3oool0103oool3000002/0oooo00<0nOl00?ooo`3oool0:03oool308P0
of/0oooo001f0?ooo`80R03o403oool20?Wo03H0oooo0P0000070?ooo`030000003oool0oooo02X0
oooo00<0nOl00?ooo`3oool09`3oool308P0ofd0oooo001g0?ooo`0308P0o`3oool0oooo00l0oooo
0P3io`0e0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0:@3oool00`3io`00oooo
0?ooo`0T0?ooo`D0R03oK`3oool007P0oooo00<0R03o0?ooo`3oool03`3oool20?Wo03@0oooo0`00
00060?ooo`030000003oool0oooo02P0oooo00<0nOl00?ooo`3oool08P3oool508P0og80oooo001h
0?ooo`80R03o4P3oool20?Wo01l0oooo0P3io`0J0?ooo`030000003oool0oooo02L0oooo00<0nOl0
0?ooo`3oool07P3oool608P0ogH0oooo001i0?ooo`80R03o4`3oool20?Wo01L0oooo403io`0B0?oo
o`030000003oool0oooo02H0oooo00<0nOl00?ooo`3oool06`3oool508P0og/0oooo001j0?ooo`03
08P0o`3oool0oooo0180oooo103io`0=0?ooo`L0nOl03`3oool50?Wo00h0oooo00<000000?ooo`3o
ool09@3oool00`3io`00oooo0?ooo`0I0?ooo`@0R03oO`3oool007X0oooo0P280?lG0?ooo`h0nOl0
603oool40?Wo00`0oooo00<000000?ooo`3oool0903oool00`3io`00oooo0?ooo`0G0?ooo`@0R03o
PP3oool007/0oooo0P280?ln0?ooo`@0nOl02P3oool00`000000oooo0?ooo`0S0?ooo`030?Wo003o
ool0oooo01H0oooo10280?n40?ooo`00O03oool208P0od00oooo0`3io`080?ooo`030000003oool0
oooo0280oooo00<0nOl00?ooo`3oool05@3oool308P0ohL0oooo001m0?ooo`80R03o@@3oool30?Wo
00H0oooo0P00000Q0?ooo`80nOl05P3oool308P0ohT0oooo001n0?ooo`0308P0o`3oool0oooo0440
oooo0`3io`040?ooo`030000003oool0oooo01l0oooo0P3io`0F0?ooo`80R03oR`3oool007l0oooo
00<0R03o0?ooo`3oool0@P3oool20?Wo00<0oooo00<000000?ooo`3oool07P3oool20?Wo01H0oooo
00<0R03o0?ooo`3oool0R`3oool007l0oooo0P280?m50?ooo`80nOl000<0oooo0000003oool07P3o
ool20?Wo01D0oooo0P280?n>0?ooo`00P03oool208P0odH0oooo0P3io`0M0?ooo`80nOl05@3oool2
08P0oi00oooo00210?ooo`80R03oAP3oool00`000000nOl00?Wo000I0?ooo`<0nOl05@3oool208P0
oi40oooo00220?ooo`80R03oA@3oool00`000000oooo0?ooo`030?Wo01@0oooo0`3io`0F0?ooo`03
08P0o`3oool0oooo0940oooo00230?ooo`80R03oA03oool010000000oooo0?ooo`3oool50?Wo00l0
oooo103io`0E0?ooo`80R03oU03oool008@0oooo0P280?m30?ooo`030000003oool0oooo00<0oooo
1@3io`090?ooo`D0nOl05`3oool208P0oiD0oooo00260?ooo`0308P0o`3oool0oooo0400oooo0P00
00090?ooo``0nOl0603oool208P0oiH0oooo00270?ooo`80R03o@03oool00`000000oooo0?ooo`0[
0?ooo`80R03oU`3oool008P0oooo0P280?lo0?ooo`030000003oool0oooo02X0oooo0P280?nH0?oo
o`00R@3oool308P0ocd0oooo00<000000?ooo`3oool0:03oool208P0oiX0oooo002;0?ooo`<0R03o
>`3oool00`000000oooo0?ooo`0W0?ooo`80R03oV`3oool008`0oooo1@280?lE0?oooa00R03o4`3o
ool00`000000oooo0?ooo`0V0?ooo`0308P0o`3oool0oooo09/0oooo002?0?ooo`D0R03o2`3oool8
08P0o`h0oooo1P280?l>0?ooo`030000003oool0oooo02D0oooo00<0R03o0?ooo`3oool0W03oool0
09<0oooo3P280?lH0?ooo`@0R03o303oool00`000000oooo0?ooo`0T0?ooo`0308P0o`3oool0oooo
09d0oooo002l0?ooo`@0R03o2@3oool00`000000oooo0?ooo`0R0?ooo`80R03oX03oool00;l0oooo
0`280?l70?ooo`030000003oool0oooo0240oooo0P280?nQ0?ooo`00`P3oool208P0o`D0oooo0P00
000P0?ooo`<0R03oXP3oool00<@0oooo0P280?l30?ooo`030000003oool0oooo01h0oooo0`280?nS
0?ooo`00aP3oool308P0o`030000003oool0oooo01`0oooo0`280?nU0?ooo`00b03oool308P0oa/0
oooo0`280?nW0?ooo`00b@3oool00`000000oooo08P0o`0208P0oaH0oooo0`280?nY0?ooo`00b@3o
ool00`000000oooo0?ooo`0408P0oa80oooo0`280?n[0?ooo`00b@3oool00`000000oooo0?ooo`02
0?ooo`H0R03o2`3oool408P0ojd0oooo00390?ooo`030000003oool0oooo00L0oooo3P280?n_0?oo
o`00b@3oool00`000000oooo0?ooo`340?ooo`00b@3oool200000<D0oooo00390?ooo`030000003o
ool0oooo0<@0oooo00390?ooo`030000003oool0oooo0<@0oooo00390?ooo`030000003oool0oooo
0<@0oooo00390?ooo`030000003oool0oooo0<@0oooo00390?ooo`030000003oool0oooo0<@0oooo
00390?ooo`030000003oool0oooo0<@0oooo00390?ooo`030000003oool0oooo0<@0oooo002e0?oo
o`030000003oool0oooo0080oooo0P0000040?ooo`8000001`3oool00`000000oooo0?ooo`340?oo
o`00]@3oool00`000000oooo0?ooo`070?ooo`040000003oool0oooo000000H0oooo00<000000?oo
o`3oool0a03oool00;D0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`040?ooo`<0
0000a03oool00;H0oooo00<000000?ooo`3oool01`3oool2000000L0oooo00<000000?ooo`3oool0
a03oool00;<0oooo00@000000?ooo`3oool000002@3oool00`000000oooo0?ooo`060?ooo`030000
003oool0oooo0<@0oooo002c0?ooo`@000002@3oool3000000H0oooo00<000000?ooo`3oool0a03o
ool00<T0oooo00<000000?ooo`3oool0a03oool00<T0oooo00<000000?ooo`3oool0a03oool00<T0
oooo00<000000?ooo`3oool0a03oool00<T0oooo00<000000?ooo`3oool0a03oool00<T0oooo00<0
00000?ooo`3oool0a03oool00<T0oooo00<000000?ooo`3oool0a03oool00<T0oooo0P0000350?oo
o`00b@3oool00`000000oooo0?ooo`340?ooo`00b@3oool00`000000oooo0?ooo`340?ooo`00b@3o
ool00`000000oooo0?ooo`340?ooo`00b@3oool00`000000oooo0?ooo`340?ooo`00b@3oool00`00
0000oooo0?ooo`340?ooo`00b@3oool00`000000oooo0?ooo`340?ooo`00b@3oool00`000000oooo
0?ooo`340?ooo`00b@3oool00`000000oooo0?ooo`340?ooo`00b@3oool200000<D0oooo00390?oo
o`030000003oool0oooo0<@0oooo00390?ooo`030000003oool0oooo0<@0oooo00390?ooo`030000
003oool0oooo0<@0oooo00390?ooo`030000003oool0oooo0<@0oooo00390?ooo`030000003oool0
oooo0<@0oooo00390?ooo`030000003oool0oooo0<@0oooo00390?ooo`030000003oool0oooo0<@0
oooo00390?ooo`030000003oool0oooo0<@0oooo00390?ooo`030000003oool0oooo0<@0oooo0039
0?ooo`800000a@3oool00<T0oooo00<000000?ooo`3oool0a03oool00<T0oooo00<000000?ooo`3o
ool0a03oool00<T0oooo00<000000?ooo`3oool0a03oool00<T0oooo00<000000?ooo`3oool0a03o
ool00<T0oooo00<000000?ooo`3oool0a03oool00<T0oooo00<000000?ooo`3oool0a03oool00<T0
oooo00<000000?ooo`3oool0a03oool00<T0oooo00<000000?ooo`3oool0a03oool00<T0oooo0P00
00350?ooo`00b@3oool00`000000oooo0?ooo`340?ooo`00b@3oool00`000000oooo0?ooo`340?oo
o`00b@3oool00`000000oooo0?ooo`340?ooo`00b@3oool00`000000oooo0?ooo`340?ooo`00b@3o
ool00`000000oooo0?ooo`340?ooo`00b@3oool00`000000oooo0?ooo`340?ooo`00b@3oool00`00
0000oooo0?ooo`340?ooo`00^@3oool500000080oooo0P0000070?ooo`030000003oool0oooo0<@0
oooo002k0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`040?ooo`03
0000003oool0oooo0<@0oooo002k0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000
oooo0?ooo`040?ooo`<00000a03oool00;/0oooo00D000000?ooo`3oool0oooo000000020?ooo`03
0000003oool0oooo0</0oooo002k0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000
oooo0?ooo`3;0?ooo`00^P3oool2000000@0oooo0P00003>0?ooo`00o`3ooonA0?ooo`00o`3ooonA
0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 399}, {399, 0}} -> {-10.4689, -10.3907, 0.0520839, \
0.0520839}},
  CellTags->"EquationTrekker"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        InterpretationBox[
          RowBox[{"EquationTrekkerState", "[", 
            
            RowBox[{"\<\"\\!\\({x[t] +  \\(\\*SuperscriptBox[\\(x\\),  \\(\
\[Prime]\[Prime]\\), MultilineFunction->None]\\)[t] \[Equal] \[Alpha] Cos[\
\[Omega] x[t]], x, {t, \\(-10\\), 10}}\\)\"\>", 
              ",", "\<\"\\!\\({\[Alpha] \[Rule] 3.`, \[Omega] \[Rule] \
1.5`}\\)\"\>", ",", 
              TagBox[
                TagBox[GridBox[{
                      {
                        InterpretationBox[
                          StyleBox[
                            RowBox[{"TrekData", "[", 
                              
                              RowBox[{"\<\"\\!\\({x[0.`] \[Equal] \
\\(-5.35`\\),  \\(\\*SuperscriptBox[\\(x\\),  \\(\[Prime]\\), \
MultilineFunction->None]\\)[0.`] \[Equal] \\(-0.5`\\)}\\)\"\>", ",", 
                                " ", "\<\"<>\"\>"}], "]"}],
                            FontColor->RGBColor[0.976471, 1, 0]],
                          TrekData[ {
                            Equal[ 
                              x[ 0.`], -5.35`], 
                            Equal[ 
                              Derivative[ 1][ x][ 
                              0.`], -0.5`]}, {-5.35`, -0.5`}, {0.`, {-10.`, 
                            10.`}}, {
                            RGBColor[ 0.9764705896377563`, 1.`, 0.`], 
                            "Line"}]]},
                      {
                        InterpretationBox[
                          StyleBox[
                            RowBox[{"TrekData", "[", 
                              
                              RowBox[{"\<\"\\!\\({x[0.`] \[Equal] \
\\(-6.85`\\),  \\(\\*SuperscriptBox[\\(x\\),  \\(\[Prime]\\), \
MultilineFunction->None]\\)[0.`] \[Equal] \\(-0.6500000000000004`\\)}\\)\"\>",
                                 ",", " ", "\<\"<>\"\>"}], "]"}],
                            FontColor->RGBColor[0.533333, 0, 1]],
                          TrekData[ {
                            Equal[ 
                              x[ 0.`], -6.85`], 
                            Equal[ 
                              Derivative[ 1][ x][ 
                              0.`], -0.6500000000000004`]}, {-6.85`, \
-0.6500000000000004`}, {0.`, {-10.`, 10.`}}, {
                            RGBColor[ 0.5333333611488342`, 0.`, 1.`], 
                            "Line"}]]},
                      {
                        InterpretationBox[
                          StyleBox[
                            RowBox[{"TrekData", "[", 
                              
                              RowBox[{"\<\"\\!\\({x[0.`] \[Equal] \
\\(-4.2`\\),  \\(\\*SuperscriptBox[\\(x\\),  \\(\[Prime]\\), \
MultilineFunction->None]\\)[0.`] \[Equal] \\(-0.5999999999999996`\\)}\\)\"\>",
                                 ",", " ", "\<\"<>\"\>"}], "]"}],
                            FontColor->RGBColor[1, 0, 1]],
                          TrekData[ {
                            Equal[ 
                              x[ 0.`], -4.2`], 
                            Equal[ 
                              Derivative[ 1][ x][ 
                              0.`], -0.5999999999999996`]}, {-4.2`, \
-0.5999999999999996`}, {0.`, {-10.`, 10.`}}, {
                            RGBColor[ 1.`, 0.`, 1.`], "Line"}]]},
                      {
                        InterpretationBox[
                          StyleBox[
                            RowBox[{"TrekData", "[", 
                              
                              RowBox[{"\<\"\\!\\({x[0.`] \[Equal] \
\\(-1.1500000000000004`\\),  \\(\\*SuperscriptBox[\\(x\\),  \\(\[Prime]\\), \
MultilineFunction->None]\\)[0.`] \[Equal] \\(-0.9499999999999993`\\)}\\)\"\>",
                                 ",", " ", "\<\"<>\"\>"}], "]"}],
                            FontColor->RGBColor[0.501961, 0, 1]],
                          TrekData[ {
                            Equal[ 
                              x[ 0.`], -1.1500000000000004`], 
                            Equal[ 
                              Derivative[ 1][ x][ 
                              0.`], -0.9499999999999993`]}, \
{-1.1500000000000004`, -0.9499999999999993`}, {0.`, {-10.`, 10.`}}, {
                            RGBColor[ 0.501960813999176`, 0.`, 1.`], 
                            "Line"}]]},
                      {
                        InterpretationBox[
                          StyleBox[
                            RowBox[{"TrekData", "[", 
                              
                              RowBox[{"\<\"\\!\\({x[0.`] \[Equal] \
\\(-2.1500000000000004`\\),  \\(\\*SuperscriptBox[\\(x\\),  \\(\[Prime]\\), \
MultilineFunction->None]\\)[0.`] \[Equal] \\(-0.75`\\)}\\)\"\>", ",", 
                                " ", "\<\"<>\"\>"}], "]"}],
                            FontColor->RGBColor[0.592157, 1, 0]],
                          TrekData[ {
                            Equal[ 
                              x[ 0.`], -2.1500000000000004`], 
                            Equal[ 
                              Derivative[ 1][ x][ 
                              0.`], -0.75`]}, {-2.1500000000000004`, -0.75`}, \
{0.`, {-10.`, 10.`}}, {
                            RGBColor[ 0.5921568870544434`, 1.`, 0.`], 
                            "Line"}]]},
                      {
                        InterpretationBox[
                          StyleBox[
                            RowBox[{"TrekData", "[", 
                              
                              RowBox[{"\<\"\\!\\({x[0.`] \[Equal] \
\\(-2.2`\\),  \\(\\*SuperscriptBox[\\(x\\),  \\(\[Prime]\\), \
MultilineFunction->None]\\)[0.`] \[Equal] \\(-0.4499999999999993`\\)}\\)\"\>",
                                 ",", " ", "\<\"<>\"\>"}], "]"}],
                            FontColor->RGBColor[1, 0.611765, 0]],
                          TrekData[ {
                            Equal[ 
                              x[ 0.`], -2.2`], 
                            Equal[ 
                              Derivative[ 1][ x][ 
                              0.`], -0.4499999999999993`]}, {-2.2`, \
-0.4499999999999993`}, {0.`, {-10.`, 10.`}}, {
                            RGBColor[ 1.`, 0.6117647290229797`, 0.`], 
                            "Line"}]]},
                      {
                        InterpretationBox[
                          StyleBox[
                            RowBox[{"TrekData", "[", 
                              
                              RowBox[{"\<\"\\!\\({x[0.`] \[Equal] \
1.5500000000000007`,  \\(\\*SuperscriptBox[\\(x\\),  \\(\[Prime]\\), \
MultilineFunction->None]\\)[0.`] \[Equal] \\(-0.5999999999999996`\\)}\\)\"\>",
                                 ",", " ", "\<\"<>\"\>"}], "]"}],
                            FontColor->RGBColor[1, 0, 0.956863]],
                          TrekData[ {
                            Equal[ 
                              x[ 0.`], 1.5500000000000007`], 
                            Equal[ 
                              Derivative[ 1][ x][ 
                              0.`], -0.5999999999999996`]}, {
                            1.5500000000000007`, -0.5999999999999996`}, {
                            0.`, {-10.`, 10.`}}, {
                            RGBColor[ 1.`, 0.`, 0.95686274766922`], 
                            "Line"}]]}
                      },
                    RowSpacings->1,
                    ColumnAlignments->{Left}],
                  Column],
                Function[ BoxForm`e$, 
                  MatrixForm[ BoxForm`e$]]], ",", "\<\" <>\"\>"}], "]"}],
          EquationTrekkerState[ {
            Equal[ 
              Plus[ 
                x[ t], 
                Derivative[ 2][ x][ t]], 
              Times[ \[Alpha], 
                Cos[ 
                  Times[ \[Omega], 
                    x[ t]]]]], x, {t, -10, 10}}, {\[Alpha] -> 3.0, \[Omega] -> 
            1.5}, {
            TrekData[ {
              Equal[ 
                x[ 0.0], -5.3499999999999996], 
              Equal[ 
                Derivative[ 1][ x][ 0.0], -.5]}, {-5.3499999999999996, -.5}, {
              0.0, {-.1*^2, .1*^2}}, {
              RGBColor[ .97647058963775635, 1.0, 0.0], "Line"}], 
            TrekData[ {
              Equal[ 
                x[ 0.0], -6.8499999999999996], 
              Equal[ 
                Derivative[ 1][ x][ 
                0.0], -.65000000000000036]}, {-6.8499999999999996, \
-.65000000000000036}, {0.0, {-.1*^2, .1*^2}}, {
              RGBColor[ .53333336114883423, 0.0, 1.0], "Line"}], 
            TrekData[ {
              Equal[ 
                x[ 0.0], -4.2000000000000002], 
              Equal[ 
                Derivative[ 1][ x][ 
                0.0], -.59999999999999964]}, {-4.2000000000000002, \
-.59999999999999964}, {0.0, {-.1*^2, .1*^2}}, {
              RGBColor[ 1.0, 0.0, 1.0], "Line"}], 
            TrekData[ {
              Equal[ 
                x[ 0.0], -1.1500000000000004], 
              Equal[ 
                Derivative[ 1][ x][ 
                0.0], -.94999999999999929]}, {-1.1500000000000004, \
-.94999999999999929}, {0.0, {-.1*^2, .1*^2}}, {
              RGBColor[ .50196081399917603, 0.0, 1.0], "Line"}], 
            TrekData[ {
              Equal[ 
                x[ 0.0], -2.1500000000000004], 
              Equal[ 
                Derivative[ 1][ x][ 
                0.0], -.75]}, {-2.1500000000000004, -.75}, {
              0.0, {-.1*^2, .1*^2}}, {
              RGBColor[ .59215688705444336, 1.0, 0.0], "Line"}], 
            TrekData[ {
              Equal[ 
                x[ 0.0], -2.2000000000000002], 
              Equal[ 
                Derivative[ 1][ x][ 
                0.0], -.44999999999999929]}, {-2.2000000000000002, \
-.44999999999999929}, {0.0, {-.1*^2, .1*^2}}, {
              RGBColor[ 1.0, .61176472902297974, 0.0], "Line"}], 
            TrekData[ {
              Equal[ 
                x[ 0.0], 1.5500000000000007], 
              Equal[ 
                Derivative[ 1][ x][ 0.0], -.59999999999999964]}, {
              1.5500000000000007, -.59999999999999964}, {
              0.0, {-.1*^2, .1*^2}}, {
              RGBColor[ 1.0, 0.0, .95686274766921997], "Line"}]}, {
            TrekParameters -> {\[Alpha] -> 3.0, \[Omega] -> 1.5}, 
            PlotRange -> {{-.1*^2, .1*^2}, {-.1*^2, .1*^2}}, "CanvasSize" -> {
            400, 400}}]], ",", 
        TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
          False,
          Editable->False]}], "}"}]], "Output",
  CellLabel->"Out[3]=",
  CellTags->"EquationTrekker"]
}, Open  ]],

Cell["\<\
You can specify the range of possible values as well as the starting value \
when you specify a parameter.\
\>", "Text",
  CellTags->"EquationTrekker"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox[\(name -> value\),
              "MR"], Cell[TextData[StyleBox[
            "Parameter name will start with value and have range [0, 2 value] \
(or [-1,1] if value is 0).",
              GridBoxOptions->{RowSpacings->1.5,
              ColumnSpacings->1,
              ColumnWidths->{0.4, 0.6},
              ColumnAlignments->{Left}}]], "Text",
              GridBoxOptions->{RowSpacings->1.5,
              ColumnSpacings->1,
              ColumnWidths->{0.4, 0.6},
              ColumnAlignments->{Left}}]},
          {
            StyleBox[\(name -> {value, \ {vmin, \ vmax}}\),
              
              "MR"], \(\(Parameter\)\(\ \)\(name\)\(\ \)\(will\)\(\ \)\(start\
\)\(\ \)\(with\)\(\ \)\(value\)\(\ \)\(and\)\(\ \)\(have\)\(\ \)\(range\ [
                vmin, \ vmax]\)\(\ \)\)}
          }], TextForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.4, 0.6},
  ColumnAlignments->{Left}},
  CellTags->"EquationTrekker"],

Cell["Parameter specifications.", "Caption",
  CellTags->"EquationTrekker"],

Cell["\<\
This allows the parameter \[Omega] to be specified in the range [0, 20].  For \
higher frequencies, a somewhat complicated set of orbits and separatrices \
exist.  The result shown below was chosen by choosing \[Omega] = 13.\
\>", "MathCaption",
  CellTags->"EquationTrekker"],

Cell[CellGroupData[{

Cell[BoxData[
    \(EquationTrekker[\(x''\)[t]\  + \ 
          x[t]\  \[Equal] \ \[Alpha]\ Cos[\[Omega]\ x[t]], 
      x, {t, \(-10\), 10}, \ PlotRange \[Rule] {{\(-4\), 4}, {\(-4\), 4}}, 
      TrekParameters \[Rule] {\[Alpha] \[Rule] 
            3, \ \ \[Omega] \[Rule] {1, {0, 20}}}]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"EquationTrekker"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
%%ImageSize: 400 400 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.125 0.5 0.125 [
[0 .4875 -6 -9 ]
[0 .4875 6 0 ]
[.125 .4875 -6 -9 ]
[.125 .4875 6 0 ]
[.25 .4875 -6 -9 ]
[.25 .4875 6 0 ]
[.375 .4875 -6 -9 ]
[.375 .4875 6 0 ]
[.625 .4875 -3 -9 ]
[.625 .4875 3 0 ]
[.75 .4875 -3 -9 ]
[.75 .4875 3 0 ]
[.875 .4875 -3 -9 ]
[.875 .4875 3 0 ]
[1 .4875 -3 -9 ]
[1 .4875 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .125 -12 -4.5 ]
[.4875 .125 0 4.5 ]
[.4875 .25 -12 -4.5 ]
[.4875 .25 0 4.5 ]
[.4875 .375 -12 -4.5 ]
[.4875 .375 0 4.5 ]
[.4875 .625 -6 -4.5 ]
[.4875 .625 0 4.5 ]
[.4875 .75 -6 -4.5 ]
[.4875 .75 0 4.5 ]
[.4875 .875 -6 -4.5 ]
[.4875 .875 0 4.5 ]
[.4875 1 -6 -4.5 ]
[.4875 1 0 4.5 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .5 m
0 .50625 L
s
[(-4)] 0 .4875 0 1 Mshowa
.125 .5 m
.125 .50625 L
s
[(-3)] .125 .4875 0 1 Mshowa
.25 .5 m
.25 .50625 L
s
[(-2)] .25 .4875 0 1 Mshowa
.375 .5 m
.375 .50625 L
s
[(-1)] .375 .4875 0 1 Mshowa
.625 .5 m
.625 .50625 L
s
[(1)] .625 .4875 0 1 Mshowa
.75 .5 m
.75 .50625 L
s
[(2)] .75 .4875 0 1 Mshowa
.875 .5 m
.875 .50625 L
s
[(3)] .875 .4875 0 1 Mshowa
1 .5 m
1 .50625 L
s
[(4)] 1 .4875 0 1 Mshowa
.125 Mabswid
.025 .5 m
.025 .50375 L
s
.05 .5 m
.05 .50375 L
s
.075 .5 m
.075 .50375 L
s
.1 .5 m
.1 .50375 L
s
.15 .5 m
.15 .50375 L
s
.175 .5 m
.175 .50375 L
s
.2 .5 m
.2 .50375 L
s
.225 .5 m
.225 .50375 L
s
.275 .5 m
.275 .50375 L
s
.3 .5 m
.3 .50375 L
s
.325 .5 m
.325 .50375 L
s
.35 .5 m
.35 .50375 L
s
.4 .5 m
.4 .50375 L
s
.425 .5 m
.425 .50375 L
s
.45 .5 m
.45 .50375 L
s
.475 .5 m
.475 .50375 L
s
.525 .5 m
.525 .50375 L
s
.55 .5 m
.55 .50375 L
s
.575 .5 m
.575 .50375 L
s
.6 .5 m
.6 .50375 L
s
.65 .5 m
.65 .50375 L
s
.675 .5 m
.675 .50375 L
s
.7 .5 m
.7 .50375 L
s
.725 .5 m
.725 .50375 L
s
.775 .5 m
.775 .50375 L
s
.8 .5 m
.8 .50375 L
s
.825 .5 m
.825 .50375 L
s
.85 .5 m
.85 .50375 L
s
.9 .5 m
.9 .50375 L
s
.925 .5 m
.925 .50375 L
s
.95 .5 m
.95 .50375 L
s
.975 .5 m
.975 .50375 L
s
.25 Mabswid
0 .5 m
1 .5 L
s
.5 0 m
.50625 0 L
s
[(-4)] .4875 0 1 0 Mshowa
.5 .125 m
.50625 .125 L
s
[(-3)] .4875 .125 1 0 Mshowa
.5 .25 m
.50625 .25 L
s
[(-2)] .4875 .25 1 0 Mshowa
.5 .375 m
.50625 .375 L
s
[(-1)] .4875 .375 1 0 Mshowa
.5 .625 m
.50625 .625 L
s
[(1)] .4875 .625 1 0 Mshowa
.5 .75 m
.50625 .75 L
s
[(2)] .4875 .75 1 0 Mshowa
.5 .875 m
.50625 .875 L
s
[(3)] .4875 .875 1 0 Mshowa
.5 1 m
.50625 1 L
s
[(4)] .4875 1 1 0 Mshowa
.125 Mabswid
.5 .025 m
.50375 .025 L
s
.5 .05 m
.50375 .05 L
s
.5 .075 m
.50375 .075 L
s
.5 .1 m
.50375 .1 L
s
.5 .15 m
.50375 .15 L
s
.5 .175 m
.50375 .175 L
s
.5 .2 m
.50375 .2 L
s
.5 .225 m
.50375 .225 L
s
.5 .275 m
.50375 .275 L
s
.5 .3 m
.50375 .3 L
s
.5 .325 m
.50375 .325 L
s
.5 .35 m
.50375 .35 L
s
.5 .4 m
.50375 .4 L
s
.5 .425 m
.50375 .425 L
s
.5 .45 m
.50375 .45 L
s
.5 .475 m
.50375 .475 L
s
.5 .525 m
.50375 .525 L
s
.5 .55 m
.50375 .55 L
s
.5 .575 m
.50375 .575 L
s
.5 .6 m
.50375 .6 L
s
.5 .65 m
.50375 .65 L
s
.5 .675 m
.50375 .675 L
s
.5 .7 m
.50375 .7 L
s
.5 .725 m
.50375 .725 L
s
.5 .775 m
.50375 .775 L
s
.5 .8 m
.50375 .8 L
s
.5 .825 m
.50375 .825 L
s
.5 .85 m
.50375 .85 L
s
.5 .9 m
.50375 .9 L
s
.5 .925 m
.50375 .925 L
s
.5 .95 m
.50375 .95 L
s
.5 .975 m
.50375 .975 L
s
.25 Mabswid
.5 0 m
.5 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of user PostScript
/mathtops {
gsave
MBeginOrig
moveto
MEndOrig
currentpoint
grestore
} bind def
/MAtocoords {
mathtops 4 2 roll mathtops
4 copy pop pop
3 -1 roll sub
/arry exch def
exch sub
/arrx exch def
arrx dup mul
arry dup mul
add sqrt
/arrl exch def
translate
} bind def
/MAarrowhead1 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto
-0.035 0 lineto fill
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto
-0.035 0 lineto
-0.05 0.0125 lineto stroke
} ifelse
grestore
} def
% End of user PostScript
1 .843 0 r
.5 Mabswid
.51234 .43707 m
.51185 .43787 L
.51137 .43883 L
.51063 .44059 L
.50992 .44267 L
.50923 .44505 L
.50857 .44769 L
.50795 .45058 L
.50737 .45369 L
.50682 .45699 L
.5062 .46137 L
.50564 .46596 L
.50516 .47073 L
.50475 .47565 L
.50441 .48068 L
.50416 .4858 L
.50398 .49097 L
.50388 .49617 L
.50386 .50139 L
.50392 .50661 L
.50406 .5118 L
.50428 .51694 L
.50458 .52201 L
.50496 .52699 L
.50535 .53127 L
.5058 .53543 L
.50631 .53944 L
.50686 .54327 L
.50747 .54689 L
.50813 .55027 L
.50883 .55338 L
.50957 .55617 L
.51014 .55803 L
.51073 .55968 L
.51134 .56112 L
.51196 .56232 L
.51259 .56329 L
.51323 .56401 L
.51387 .56448 L
.51499 .56469 L
.51611 .56411 L
.51721 .56278 L
.51828 .56071 L
.51931 .55795 L
.52028 .55457 L
.52119 .55062 L
.52203 .54617 L
.52279 .54131 L
.52346 .5361 L
.52404 .53061 L
Mistroke
.52443 .52604 L
.52476 .52137 L
.52502 .5166 L
.52522 .51176 L
.52535 .50688 L
.52541 .50197 L
.5254 .49706 L
.52533 .49216 L
.52518 .48728 L
.52498 .48246 L
.52461 .47646 L
.52415 .47063 L
.52375 .46654 L
.5233 .46259 L
.5228 .45879 L
.52226 .45519 L
.52167 .4518 L
.52104 .44865 L
.52037 .44577 L
.51966 .44319 L
.51917 .44164 L
.51867 .44024 L
.51815 .43901 L
.51763 .43794 L
.51709 .43705 L
.51655 .43633 L
.51601 .4358 L
.51493 .43531 L
.51386 .43553 L
.51279 .43646 L
.51174 .43807 L
.51073 .44033 L
.50976 .44319 L
.50884 .44659 L
.50798 .45046 L
.50704 .45565 L
.5062 .46132 L
.50549 .46737 L
.5049 .4737 L
.50444 .48026 L
.50418 .48525 L
.504 .4903 L
.50389 .49539 L
.50386 .50049 L
.5039 .5056 L
.50403 .51068 L
.50422 .51572 L
.5045 .5207 L
.50472 .52401 L
.50498 .52727 L
Mistroke
.50527 .53047 L
.50559 .53361 L
.50595 .53667 L
.50633 .53964 L
.50675 .54252 L
.50737 .54633 L
.50805 .54989 L
.50877 .55315 L
.50954 .55608 L
.51035 .55864 L
.51119 .56078 L
.51205 .56249 L
.51294 .56372 L
.51406 .56457 L
.51518 .56464 L
.5163 .56393 L
.5174 .56246 L
.51847 .56025 L
.5195 .55736 L
.52046 .55384 L
.52137 .54977 L
.52219 .54522 L
.52294 .54025 L
.52359 .53495 L
.52415 .52938 L
.52461 .52359 L
.52497 .51764 L
.52518 .51286 L
.52532 .50803 L
.5254 .50317 L
.52541 .4983 L
.52535 .49344 L
.52523 .4886 L
.52504 .4838 L
.52471 .47788 L
.52428 .4721 L
.52391 .4681 L
.5235 .46421 L
.52303 .46047 L
.52253 .45689 L
.52197 .4535 L
.52138 .45032 L
.52076 .44738 L
.52009 .44471 L
.5194 .44233 L
.51868 .44026 L
.51816 .43903 L
.51764 .43796 L
.5171 .43706 L
.51656 .43634 L
Mistroke
.51602 .43581 L
.51547 .43546 L
.51492 .4353 L
.51383 .43554 L
.51275 .43651 L
.51169 .43817 L
.51066 .4405 L
.50968 .44343 L
.50876 .44692 L
.50789 .45088 L
.5071 .45526 L
.50638 .45998 L
.50575 .46499 L
.5052 .47023 L
.50479 .47513 L
.50444 .48016 L
.50418 .48526 L
.50399 .49043 L
.50389 .49563 L
.50386 .50086 L
.50391 .50607 L
.50405 .51127 L
.50426 .51642 L
.50455 .5215 L
.50492 .52649 L
.50531 .53084 L
.50576 .53508 L
.50627 .53916 L
.50683 .54306 L
.50744 .54674 L
.50811 .55018 L
.50882 .55333 L
.50957 .55617 L
.51004 .55773 L
.51053 .55915 L
.51103 .56043 L
.51155 .56155 L
.51207 .5625 L
.51259 .5633 L
.51313 .56391 L
.51412 .56459 L
.51512 .56466 L
.51611 .56411 L
.5171 .56295 L
.51806 .5612 L
.51899 .5589 L
.51988 .55608 L
.52072 .55278 L
.5215 .54907 L
.52223 .54498 L
Mistroke
.52289 .54057 L
.52348 .53589 L
.524 .53099 L
.52444 .5259 L
.52488 .5194 L
.5251 .51491 L
.52526 .51038 L
.52537 .50581 L
.52541 .50122 L
.5254 .49663 L
.52532 .49205 L
.52519 .48749 L
.52506 .48413 L
.52489 .48079 L
.52468 .47749 L
.52445 .47424 L
.52419 .47104 L
.52389 .46791 L
.52357 .46485 L
.52326 .46223 L
.52293 .45968 L
.52257 .45721 L
.5222 .45483 L
.52181 .45255 L
.52139 .45037 L
.52096 .44831 L
.5202 .4451 L
.51939 .44229 L
.51854 .43991 L
.51766 .438 L
.51676 .43658 L
.51584 .43567 L
.51491 .4353 L
.51398 .43547 L
.51312 .43609 L
.51228 .43716 L
.51145 .43865 L
.51064 .44056 L
.50986 .44284 L
.50912 .44547 L
.50841 .44841 L
.50759 .45246 L
.50684 .45687 L
.50617 .4616 L
.50557 .46659 L
.50506 .47178 L
.50464 .47713 L
.50431 .4826 L
.50406 .48816 L
.50389 .49519 L
Mistroke
.50386 .49884 L
.50387 .50249 L
.50391 .50614 L
.504 .50978 L
.50412 .51339 L
.50429 .51699 L
.50449 .52054 L
.50478 .52478 L
.50513 .52893 L
.50545 .53223 L
.5058 .53546 L
.50619 .53859 L
.50661 .54162 L
.50706 .54453 L
.50755 .5473 L
.50818 .55051 L
.50885 .55346 L
.50933 .55532 L
.50983 .55704 L
.51034 .55861 L
.51086 .56002 L
.5114 .56125 L
.51195 .56231 L
.51251 .56318 L
.5133 .56408 L
.5141 .56459 L
.51491 .5647 L
.51572 .5644 L
.51652 .56371 L
.5173 .56263 L
.51808 .56116 L
.51883 .55933 L
.51956 .55716 L
.52025 .55468 L
.52092 .55189 L
.52155 .54884 L
.52214 .54555 L
.52268 .54205 L
.52319 .53836 L
.52364 .53451 L
.52418 .52904 L
.52463 .52337 L
.52498 .51755 L
.52522 .51162 L
.52537 .50562 L
.52541 .49959 L
.52536 .49356 L
.5252 .48757 L
.52496 .48225 L
.52465 .47702 L
Mistroke
.52426 .47192 L
.5238 .46696 L
.52326 .4622 L
.52264 .45768 L
.52196 .45344 L
.52122 .44953 L
.52063 .44684 L
.52 .44438 L
.51935 .44219 L
.51868 .44026 L
.51798 .43864 L
.51727 .43732 L
.51654 .43632 L
.51581 .43565 L
.51489 .4353 L
.51377 .43557 L
.51303 .43618 L
.5123 .43713 L
.51158 .43839 L
.51087 .43996 L
.51019 .44183 L
.50953 .44396 L
.50889 .44635 L
.50791 .45079 L
.50702 .45577 L
.50622 .46118 L
.50564 .46597 L
.50514 .47096 L
.50471 .4761 L
.50437 .48136 L
.50412 .4867 L
.50395 .49211 L
.50387 .49755 L
.50387 .503 L
.50393 .50712 L
.50404 .51122 L
.5042 .5153 L
.50441 .51934 L
.50467 .52332 L
.50498 .52724 L
.50533 .53108 L
.50568 .53441 L
.50607 .53765 L
.50649 .54079 L
.50695 .5438 L
.50743 .54668 L
.50795 .54941 L
.5085 .55197 L
.50921 .55487 L
.50995 .55745 L
Mistroke
.51073 .55968 L
.51154 .56154 L
.51237 .56298 L
.51321 .564 L
.51407 .56457 L
.51493 .5647 L
.51579 .56436 L
.51664 .56357 L
.51747 .56234 L
.51807 .56117 L
.51866 .55979 L
.51923 .55819 L
.51978 .5564 L
.52032 .55442 L
.52084 .55226 L
.52133 .54994 L
.52216 .54541 L
.52291 .54046 L
.52357 .53518 L
.52413 .52962 L
.52459 .52385 L
.52496 .51791 L
.52522 .51186 L
.52537 .50573 L
.52541 .49957 L
.52535 .49341 L
.52519 .4873 L
.52497 .48231 L
.52468 .47739 L
.52432 .47258 L
.52389 .4679 L
.5234 .46339 L
.52284 .45907 L
.52223 .45499 L
.52155 .45119 L
.52097 .44835 L
.52036 .44574 L
.51972 .44338 L
.51905 .44129 L
.51836 .43948 L
.51765 .43798 L
.51693 .43681 L
.5159 .43572 L
.51487 .4353 L
.51383 .43554 L
.5128 .43644 L
.51179 .43798 L
.51081 .44012 L
.50987 .44281 L
.50898 .44601 L
Mistroke
.50814 .44967 L
.50736 .45371 L
.50666 .45809 L
.50599 .46299 L
.50541 .46814 L
.50492 .47349 L
.50452 .47899 L
.50421 .4846 L
.504 .49029 L
.50388 .49602 L
.50386 .50178 L
.50394 .50752 L
.50412 .51323 L
.50439 .51888 L
.50468 .52337 L
.50502 .52777 L
.50543 .53207 L
.5059 .53624 L
.50642 .54026 L
.50699 .54408 L
.50762 .54769 L
.50829 .55104 L
.50878 .55317 L
.50928 .55515 L
.50981 .55697 L
.51034 .55863 L
.5109 .5601 L
.51147 .56138 L
.51204 .56247 L
.51291 .56369 L
.51379 .56444 L
.51468 .56471 L
.51557 .56449 L
.51645 .56379 L
.51732 .56261 L
.51816 .56097 L
.51899 .55889 L
.51978 .55641 L
.52054 .55355 L
.52109 .55109 L
.52162 .54844 L
.52213 .54561 L
.5226 .54264 L
.52303 .53952 L
.52344 .53628 L
.52381 .53293 L
.52432 .52735 L
.52474 .52159 L
.52506 .51568 L
.52528 .50968 L
Mistroke
.5254 .50362 L
.52541 .49754 L
.52531 .49147 L
.52511 .48546 L
.52489 .48079 L
.5246 .4762 L
.52425 .4717 L
.52383 .46733 L
.52337 .46311 L
.52284 .45906 L
.52226 .45522 L
.52164 .45162 L
.5211 .44895 L
.52054 .44647 L
.51995 .44419 L
.51934 .44215 L
.51871 .44034 L
.51806 .4388 L
.51739 .43752 L
.51664 .43644 L
.51588 .43571 L
.51511 .43534 L
.51434 .43534 L
.51358 .4357 L
.51281 .43642 L
.51206 .4375 L
.51133 .43891 L
.51061 .44064 L
.50992 .44267 L
.50903 .44581 L
.5082 .4494 L
.50742 .45338 L
.50672 .45769 L
.50608 .46229 L
.50552 .46711 L
.50503 .47211 L
.50463 .47726 L
.50431 .4826 L
.50407 .48802 L
.50392 .49349 L
.50386 .499 L
.50389 .5045 L
.50401 .50999 L
.50421 .51543 L
.5045 .5208 L
.50484 .52555 L
.50524 .53019 L
.50571 .53469 L
.50625 .53903 L
.50685 .54316 L
Mistroke
.5075 .54705 L
.50821 .55066 L
.50897 .55395 L
.50969 .55659 L
.51045 .55891 L
.51123 .56087 L
.51203 .56245 L
.51286 .56363 L
.51369 .56438 L
.51454 .5647 L
.51538 .56457 L
.51622 .56401 L
.51705 .56302 L
.51787 .5616 L
.51866 .55978 L
.51943 .55758 L
.52004 .5555 L
.52062 .55319 L
.52118 .55068 L
.52171 .54797 L
.52221 .5451 L
.52268 .54206 L
.52312 .53889 L
.52352 .5356 L
.52388 .53219 L
.52421 .5287 L
.52452 .52485 L
.52479 .52092 L
.52501 .51694 L
.52518 .5129 L
.5253 .50883 L
.52538 .50474 L
.52541 .50063 L
.52538 .49544 L
.52528 .49026 L
.5251 .48512 L
.52484 .48005 L
.52452 .47508 L
.52411 .47023 L
.52364 .46553 L
.52311 .46102 L
.52235 .45578 L
.52151 .45097 L
.52083 .44771 L
.52011 .44477 L
.51935 .44217 L
.51855 .43995 L
.51774 .43814 L
.51689 .43676 L
.51604 .43583 L
Mistroke
.51517 .43535 L
.5143 .43535 L
.51344 .43581 L
.51258 .43672 L
.51186 .43786 L
.51115 .4393 L
.51046 .44105 L
.50979 .44307 L
.50915 .44535 L
.50853 .44787 L
.50795 .45061 L
.50706 .45551 L
.50627 .46084 L
.50558 .46652 L
.505 .47247 L
.50454 .47861 L
.50419 .48491 L
.50397 .4913 L
.50387 .49774 L
.50386 .50133 L
.50389 .50492 L
.50396 .50851 L
.50407 .51207 L
.50422 .51562 L
.5044 .51913 L
.50462 .52261 L
.50488 .52603 L
.50529 .53069 L
.50577 .53521 L
.50632 .53956 L
.50693 .54369 L
.5076 .54758 L
.50832 .55117 L
.50909 .55443 L
.50991 .55731 L
.51077 .55977 L
.51157 .5616 L
.5124 .56303 L
.51324 .56403 L
.5141 .56459 L
.51496 .56469 L
.51581 .56434 L
.51666 .56354 L
.5175 .5623 L
.5181 .56112 L
.51868 .55973 L
.51925 .55812 L
.51981 .55632 L
.52034 .55433 L
.52086 .55216 L
Mistroke
.52135 .54983 L
.52218 .54529 L
.52293 .54033 L
.52358 .53504 L
.52414 .52947 L
.5246 .52368 L
.52497 .51774 L
.52522 .51168 L
.52537 .50555 L
.52541 .49938 L
.52535 .49322 L
.52518 .4871 L
.52496 .48218 L
.52467 .47733 L
.52432 .47258 L
.5239 .46797 L
.52341 .46351 L
.52287 .45924 L
.52226 .4552 L
.5216 .45143 L
.52103 .44864 L
.52044 .44606 L
.51982 .44371 L
.51917 .44162 L
.5185 .43981 L
.51781 .43828 L
.5171 .43705 L
.51643 .4362 L
.51575 .43562 L
.51507 .43533 L
.51439 .43533 L
.51371 .43561 L
.51303 .43618 L
.51219 .43728 L
.51147 .4386 L
.51077 .44022 L
.51009 .44213 L
.50943 .44431 L
.5088 .44674 L
.5082 .4494 L
.50763 .45227 L
.50669 .45787 L
.50587 .46394 L
.50519 .47038 L
.50464 .4771 L
.50424 .484 L
.50398 .49103 L
.50386 .49812 L
.5039 .50523 L
.50402 .51045 L
Mistroke
.50422 .51564 L
.5045 .52076 L
.50486 .52578 L
.50529 .53069 L
.5058 .53544 L
.50638 .54 L
.50703 .54432 L
.50774 .54835 L
.50852 .55205 L
.50934 .55537 L
.51013 .55799 L
.51095 .56022 L
.5118 .56203 L
.51266 .56339 L
.51355 .56428 L
.51444 .56468 L
.51534 .56459 L
.51623 .564 L
.51678 .56339 L
.51732 .56259 L
.51786 .56161 L
.51839 .56046 L
.5189 .55913 L
.51941 .55764 L
.5199 .556 L
.52081 .55237 L
.52166 .54824 L
.52266 .54221 L
.52352 .53559 L
.52423 .52852 L
.52477 .52111 L
.52508 .5154 L
.52528 .50959 L
.52539 .50374 L
.52541 .49786 L
.52532 .49199 L
.52514 .48617 L
.52487 .48043 L
.52449 .4748 L
.52403 .46933 L
.52357 .46482 L
.52304 .46049 L
.52245 .45638 L
.5218 .45253 L
.52111 .44897 L
.52036 .44574 L
.51957 .44289 L
.51875 .44044 L
.51789 .43844 L
.51701 .43692 L
Mistroke
.51611 .43588 L
.51519 .43536 L
.51428 .43535 L
.51337 .43586 L
.51256 .43675 L
.51177 .43802 L
.511 .43966 L
.51025 .44166 L
.50952 .44399 L
.50883 .44661 L
.50817 .44951 L
.50766 .4521 L
.50717 .45485 L
.50671 .45773 L
.50628 .46074 L
.50588 .46385 L
.50552 .46706 L
.50512 .47111 L
.50478 .47526 L
.50448 .47949 L
.50425 .48378 L
.50404 .489 L
.50391 .49426 L
.50387 .49756 L
.50386 .50086 L
.50388 .50417 L
.50394 .50746 L
.50403 .51074 L
.50415 .51401 L
.50423 .51584 L
.50432 .51766 L
.50442 .51947 L
.50453 .52127 L
.50465 .52305 L
.50472 .52394 L
.50478 .52483 L
.50485 .52571 L
.50492 .52659 L
.50495 .52688 L
.50497 .52718 L
.505 .52747 L
.505 .52748 L
.505 .5275 L
.505 .52752 L
.505 .52753 L
.50503 .52782 L
.50505 .52812 L
.50508 .52841 L
.50515 .52924 L
.50523 .53007 L
Mistroke
.50531 .53089 L
.50539 .53171 L
.50556 .53333 L
.50574 .53493 L
.50593 .53651 L
.50612 .53807 L
.50633 .5396 L
.50669 .54217 L
.50709 .54465 L
.5075 .54704 L
.50784 .54887 L
.5082 .55063 L
.50858 .55232 L
.50896 .55391 L
.50936 .55542 L
.50986 .55714 L
.51037 .55871 L
.5109 .56011 L
.51144 .56134 L
.512 .56239 L
.51256 .56325 L
.51327 .56405 L
.514 .56454 L
.51473 .56471 L
.51533 .56459 L
.51593 .56426 L
.51653 .56369 L
.51712 .56291 L
.51771 .56191 L
.51828 .56071 L
.51893 .55905 L
.51956 .55714 L
.52017 .55498 L
.52076 .5526 L
.52132 .55002 L
.52185 .54724 L
.52234 .54429 L
.52289 .54056 L
.5234 .53664 L
.52385 .53256 L
.52424 .52834 L
.52458 .524 L
.52487 .51958 L
.52509 .51508 L
.52526 .51053 L
.52539 .50377 L
.5254 .49699 L
.52528 .49022 L
.52503 .48353 L
.52465 .47697 L
Mistroke
.52415 .4706 L
.52353 .46448 L
.52279 .4587 L
.52238 .45596 L
.52195 .45334 L
.52149 .45085 L
.52101 .4485 L
.5205 .44631 L
.51998 .44429 L
.51943 .44244 L
.51868 .44027 L
.5179 .43846 L
.5171 .43705 L
.51628 .43604 L
.51545 .43546 L
.51462 .4353 L
.51379 .43556 L
.51296 .43626 L
.51215 .43736 L
.51135 .43886 L
.5106 .44065 L
.50988 .44278 L
.50919 .4452 L
.50853 .4479 L
.5079 .45086 L
.50731 .45403 L
.50676 .4574 L
.50625 .46094 L
.50579 .46463 L
.50538 .46845 L
.50496 .47293 L
.50461 .47752 L
.50433 .48219 L
.50411 .48693 L
.50396 .49171 L
.50388 .49652 L
.50386 .50135 L
.50393 .50676 L
.50408 .51216 L
.50431 .51749 L
.50463 .52275 L
.50503 .5279 L
.50552 .5329 L
.50608 .53772 L
.50672 .54231 L
.50724 .54557 L
.5078 .54864 L
.5084 .55152 L
.50902 .55417 L
.50968 .55657 L
Mistroke
.51037 .5587 L
.51108 .56054 L
.51181 .56206 L
.51256 .56325 L
.51331 .56409 L
.51429 .56465 L
.51527 .56462 L
.51625 .56399 L
.51721 .56277 L
.51815 .561 L
.51906 .55869 L
.51993 .55588 L
.52075 .55262 L
.52153 .54895 L
.52224 .54493 L
.52289 .5406 L
.52327 .53771 L
.52361 .53473 L
.52393 .53167 L
.52422 .52853 L
.52448 .52533 L
.52471 .52208 L
.52491 .51878 L
.52514 .5138 L
.52531 .50876 L
.5254 .50368 L
.52541 .49859 L
.52535 .4935 L
.52523 .48845 L
.52502 .48343 L
.52475 .4785 L
.5245 .47484 L
.52421 .47125 L
.52388 .46774 L
.52351 .46433 L
.52311 .46102 L
.52267 .45784 L
.52219 .4548 L
.52149 .45084 L
.52072 .44723 L
.5199 .44402 L
.51904 .44125 L
.51814 .43897 L
.51747 .43765 L
.51678 .43661 L
.51609 .43587 L
.51539 .43543 L
.51469 .43529 L
.51398 .43546 L
.51328 .43594 L
Mistroke
.51259 .43671 L
.51191 .43777 L
.51124 .43911 L
.51058 .44072 L
.50995 .44257 L
.50933 .44467 L
.50874 .44697 L
.50818 .44948 L
.50757 .45255 L
.50701 .45581 L
.50658 .45862 L
.50618 .46154 L
.5058 .46455 L
.50546 .46764 L
.50515 .47081 L
.50487 .47403 L
.50458 .47803 L
.50433 .48209 L
.50414 .48619 L
.504 .49033 L
.5039 .4945 L
.50386 .49868 L
.50387 .50286 L
.50397 .50871 L
.50417 .51451 L
.50447 .52023 L
.50486 .52585 L
.50535 .53131 L
.50594 .53658 L
.50661 .54159 L
.50736 .54628 L
.50819 .55059 L
.5091 .55445 L
.51006 .55778 L
.51108 .56053 L
.51214 .56262 L
.51322 .56401 L
.51433 .56466 L
.51544 .56455 L
.51654 .56368 L
.51743 .56241 L
.5183 .56066 L
.51914 .55844 L
.51995 .5558 L
.52072 .55277 L
.52144 .54938 L
.52212 .54568 L
.52273 .5417 L
.5232 .53821 L
.52363 .53458 L
Mistroke
.52402 .53083 L
.52436 .52697 L
.52465 .52303 L
.5249 .51901 L
.5251 .51494 L
.52525 .51083 L
.5254 .50358 L
.5254 .49631 L
.52525 .48907 L
.52495 .48192 L
.5245 .47493 L
.52392 .46818 L
.5232 .46177 L
.52236 .45579 L
.52193 .45324 L
.52148 .45081 L
.52101 .44852 L
.52052 .44638 L
.52001 .44439 L
.51948 .44258 L
.51893 .44095 L
.51818 .43906 L
.5174 .43754 L
.51661 .4364 L
.51581 .43565 L
.515 .43532 L
.51419 .43538 L
.51338 .43586 L
.51258 .43673 L
.51157 .4384 L
.51078 .4402 L
.51002 .44236 L
.50928 .44486 L
.50858 .44766 L
.50792 .45075 L
.5073 .45408 L
.50672 .45763 L
.5062 .46137 L
.50572 .46527 L
.50529 .4693 L
.50489 .47385 L
.50455 .4785 L
.50427 .48324 L
.50407 .48804 L
.50393 .49288 L
.50387 .49774 L
.50387 .50261 L
.50395 .50802 L
.50412 .5134 L
.50438 .51871 L
Mistroke
.50472 .52395 L
.50514 .52906 L
.50564 .53402 L
.50622 .53879 L
.50687 .54331 L
.5074 .54648 L
.50796 .54946 L
.50856 .55224 L
.50919 .5548 L
.50985 .55711 L
.51053 .55914 L
.51124 .56089 L
.51196 .56232 L
.5127 .56343 L
.51345 .5642 L
.51449 .56469 L
.51553 .56451 L
.51637 .56386 L
.5172 .56279 L
.51801 .5613 L
.5188 .55941 L
.51956 .55715 L
.52029 .55453 L
.52098 .5516 L
.52164 .54838 L
.52239 .54399 L
.52307 .53925 L
.52367 .53423 L
.52419 .52898 L
.52461 .52354 L
.52495 .51797 L
.5252 .51229 L
.52535 .50654 L
.52541 .4999 L
.52535 .49326 L
.52516 .48666 L
.52485 .48017 L
.52442 .47382 L
.52387 .46769 L
.52321 .46184 L
.52244 .45635 L
.52194 .4533 L
.5214 .45042 L
.52084 .44774 L
.52024 .44528 L
.51962 .44304 L
.51897 .44107 L
.51831 .43936 L
.51752 .43775 L
.51672 .43653 L
Mistroke
.51591 .43573 L
.51509 .43533 L
.51426 .43536 L
.51344 .4358 L
.51263 .43666 L
.51183 .43792 L
.51071 .44038 L
.50965 .44356 L
.50865 .44738 L
.50791 .4508 L
.50722 .45452 L
.50659 .45851 L
.50602 .46272 L
.50552 .46712 L
.50507 .47167 L
.5047 .47634 L
.50439 .48111 L
.50415 .48595 L
.50397 .49144 L
.50387 .49696 L
.50387 .5025 L
.50395 .50803 L
.50413 .51352 L
.50439 .51896 L
.50474 .5243 L
.50518 .52951 L
.5057 .53456 L
.5063 .53941 L
.50698 .54399 L
.50773 .54827 L
.50854 .55217 L
.50942 .55565 L
.51035 .55863 L
.51132 .56107 L
.51233 .56292 L
.51336 .56413 L
.5144 .56468 L
.51545 .56454 L
.51638 .56386 L
.51729 .56265 L
.51818 .56094 L
.51904 .55874 L
.51987 .5561 L
.52066 .55305 L
.52139 .54962 L
.52208 .54587 L
.52251 .54322 L
.52291 .54045 L
.52328 .53758 L
.52363 .53462 L
Mistroke
.52394 .53157 L
.52423 .52846 L
.52449 .52528 L
.52482 .52035 L
.52508 .51533 L
.52527 .51024 L
.52538 .50511 L
.52541 .49995 L
.52538 .4948 L
.52526 .48967 L
.52503 .48361 L
.5247 .47766 L
.52426 .47185 L
.52372 .46625 L
.52309 .4609 L
.52237 .45588 L
.52156 .45124 L
.52068 .44707 L
.51973 .44343 L
.51873 .44039 L
.51767 .43802 L
.51658 .43636 L
.51547 .43546 L
.51435 .43534 L
.51323 .43598 L
.51233 .43707 L
.51145 .43864 L
.5106 .44067 L
.50978 .44312 L
.50899 .44597 L
.50825 .44916 L
.50755 .45266 L
.50691 .45644 L
.5064 .4599 L
.50593 .46352 L
.5055 .46727 L
.50512 .47112 L
.50479 .47507 L
.50451 .47909 L
.50428 .48317 L
.5041 .48729 L
.50396 .49163 L
.50388 .49599 L
.50386 .50037 L
.50389 .50474 L
.50398 .5091 L
.50412 .51344 L
.50432 .51773 L
.50458 .52198 L
.50501 .52759 L
Mistroke
.50553 .53302 L
.50615 .53824 L
.50685 .54319 L
.50764 .54779 L
.5085 .55198 L
.50943 .55568 L
.51042 .55884 L
.51112 .56063 L
.51184 .56211 L
.51258 .56328 L
.51333 .5641 L
.51408 .56458 L
.51484 .5647 L
.5156 .56447 L
.51636 .56388 L
.5171 .56295 L
.51783 .56167 L
.51855 .56006 L
.51924 .55815 L
.51991 .55594 L
.52063 .55316 L
.5213 .55007 L
.52194 .54671 L
.52253 .5431 L
.52307 .53927 L
.52356 .53526 L
.52399 .53109 L
.52437 .5268 L
.52475 .52153 L
.52504 .51615 L
.52525 .51069 L
.52538 .50517 L
.52541 .49963 L
.52536 .49409 L
.52523 .48857 L
.52498 .48253 L
.52462 .47659 L
.52417 .47081 L
.52361 .46525 L
.52296 .45995 L
.52223 .45498 L
.5214 .45042 L
.52051 .44634 L
.51955 .4428 L
.51853 .43988 L
.51746 .43764 L
.51621 .43598 L
.51494 .43531 L
.5145 .43531 L
.51407 .43542 L
Mistroke
.51364 .43566 L
.51321 .436 L
.51278 .43646 L
.51236 .43703 L
.51194 .43771 L
.51153 .43849 L
.51078 .4402 L
.51005 .44224 L
.50935 .44459 L
.50868 .44722 L
.50805 .4501 L
.50745 .45321 L
.5069 .45652 L
.50638 .46001 L
.50591 .46365 L
.50548 .46742 L
.50506 .47182 L
.5047 .47633 L
.5044 .48093 L
.50416 .4856 L
.504 .49032 L
.50389 .49507 L
.50386 .49984 L
.5039 .50528 L
.50403 .5107 L
.50424 .51608 L
.50454 .52138 L
.50492 .52658 L
.50539 .53165 L
.50593 .53653 L
.50655 .5412 L
.50725 .5456 L
.50801 .54968 L
.50883 .55338 L
.50971 .55665 L
.51063 .55943 L
.5116 .56166 L
.5127 .56344 L
.51383 .56446 L
.51497 .56469 L
.5161 .56412 L
.51722 .56276 L
.51831 .56064 L
.51935 .55782 L
.52034 .55434 L
.52126 .55028 L
.52161 .54849 L
.52195 .54662 L
.52228 .54468 L
.52259 .54266 L
Mistroke
.52289 .54059 L
.52317 .53846 L
.52344 .53627 L
.52369 .53404 L
.52423 .52852 L
.52467 .52281 L
.52501 .51694 L
.52521 .51214 L
.52534 .5073 L
.52541 .50243 L
.52541 .49755 L
.52534 .49268 L
.5252 .48784 L
.525 .48304 L
.52459 .47616 L
.52418 .47098 L
.52378 .46682 L
.52333 .4628 L
.52283 .45895 L
.52227 .45529 L
.52168 .45184 L
.52104 .44865 L
.52036 .44573 L
.51964 .44312 L
.51876 .44049 L
.51785 .43836 L
.5169 .43677 L
.51594 .43575 L
.51496 .43531 L
.51398 .43546 L
.51301 .4362 L
.51206 .43751 L
.51113 .43936 L
.51023 .44172 L
.50937 .44454 L
.50855 .44779 L
.50779 .45141 L
.50708 .45536 L
.50644 .45958 L
.50586 .46404 L
.50535 .46869 L
.50492 .47349 L
.50455 .47842 L
.50426 .48344 L
.50403 .48915 L
.5039 .49492 L
.50386 .50071 L
.50392 .5065 L
.50408 .51226 L
.50434 .51796 L
Mistroke
.50469 .52356 L
.50514 .52904 L
.50567 .53433 L
.5063 .53941 L
.50701 .5442 L
.50754 .54728 L
.50811 .55017 L
.5087 .55287 L
.50933 .55534 L
.50999 .55756 L
.51067 .55951 L
.51137 .56118 L
.51209 .56254 L
.51282 .56358 L
.51356 .56429 L
.51467 .56471 L
.51558 .56448 L
.51631 .56393 L
.51704 .56304 L
.51775 .56184 L
.51844 .56033 L
.51912 .55852 L
.51977 .55644 L
.5204 .55409 L
.521 .55151 L
.52178 .54762 L
.52249 .54336 L
.52313 .5388 L
.5237 .53399 L
.52419 .52896 L
.5246 .52376 L
.52493 .51843 L
.52517 .51301 L
.52533 .50752 L
.52541 .502 L
.5254 .49646 L
.52533 .4925 L
.52523 .48855 L
.52508 .48463 L
.52488 .48076 L
.52465 .47693 L
.52437 .47317 L
.52405 .46949 L
.52346 .46386 L
.52277 .45854 L
.52199 .45358 L
.52113 .44907 L
.52019 .44507 L
.51918 .44168 L
.51813 .43895 L
Mistroke
.51703 .43694 L
.5159 .43572 L
.51475 .43529 L
.51361 .43568 L
.51307 .43614 L
.51254 .43678 L
.51201 .43759 L
.51149 .43857 L
.51098 .43971 L
.51048 .441 L
.50999 .44245 L
.50929 .44483 L
.50862 .4475 L
.50799 .45042 L
.50739 .45357 L
.50683 .45692 L
.50632 .46045 L
.50585 .46412 L
.50543 .46793 L
.50493 .47339 L
.50451 .47901 L
.50425 .48365 L
.50406 .48836 L
.50393 .4931 L
.50387 .49786 L
.50387 .50263 L
.50394 .50739 L
.50408 .51213 L
.50436 .51837 L
.50476 .5245 L
.50527 .53046 L
.50589 .5362 L
.50662 .54164 L
.50744 .54671 L
.50835 .55132 L
.50935 .55539 L
.51002 .55767 L
.51072 .55966 L
.51145 .56135 L
.51219 .56271 L
.51294 .56373 L
.51371 .56439 L
.51448 .56469 L
.51543 .56455 L
.51637 .56387 L
.5173 .56264 L
.5182 .56089 L
.51908 .55864 L
.51992 .55593 L
.52071 .5528 L
Mistroke
.52146 .54929 L
.52192 .5468 L
.52236 .54418 L
.52277 .54144 L
.52315 .5386 L
.52351 .53565 L
.52384 .53263 L
.52414 .52952 L
.52441 .52624 L
.52466 .5229 L
.52487 .51951 L
.52505 .51607 L
.52519 .51261 L
.5253 .50911 L
.52537 .5056 L
.52541 .4994 L
.52535 .4932 L
.52518 .48705 L
.5249 .48097 L
.52451 .47502 L
.52402 .46925 L
.52344 .46371 L
.52276 .45845 L
.52234 .45572 L
.52191 .4531 L
.52144 .45062 L
.52096 .44828 L
.52045 .4461 L
.51992 .44409 L
.51938 .44226 L
.51862 .44012 L
.51784 .43835 L
.51704 .43697 L
.51623 .43599 L
.5154 .43543 L
.51457 .4353 L
.51375 .43559 L
.51292 .4363 L
.51211 .43742 L
.51132 .43893 L
.51055 .44081 L
.5098 .44304 L
.50909 .44558 L
.50834 .44875 L
.50763 .45224 L
.50698 .45601 L
.50638 .46002 L
.50584 .46423 L
.50536 .46861 L
.50495 .47313 L
Mistroke
.5046 .47776 L
.50428 .48303 L
.50406 .48838 L
.50392 .49378 L
.50386 .49921 L
.50389 .50464 L
.50401 .51005 L
.50421 .51541 L
.5045 .52071 L
.50495 .52689 L
.50551 .53286 L
.50619 .53858 L
.50697 .54396 L
.50785 .54891 L
.50882 .55335 L
.50961 .55633 L
.51045 .55892 L
.51131 .56106 L
.51221 .56274 L
.51313 .56391 L
.5139 .5645 L
.51467 .56471 L
.51545 .56454 L
.51622 .56401 L
.51699 .56311 L
.51774 .56185 L
.51847 .56025 L
.51919 .55832 L
.51987 .55608 L
.52053 .55355 L
.52128 .55018 L
.52171 .54799 L
.52211 .5457 L
Mfstroke
.02 w
.505 .5275 Mdot
.5 Mabswid
.52171 .54799 m
.52211 .5457 L
s
% Start of user PostScript
0.17365799 0.38395756 0.17690015 0.36556766 MAarrowhead1
% End of user PostScript
1 0 .973 r
.46784 .52298 m
.46796 .52121 L
.46807 .51943 L
.46825 .51586 L
.46847 .51036 L
.46858 .50565 L
.46862 .50095 L
.4686 .49624 L
.46852 .49153 L
.46837 .48684 L
.46815 .48216 L
.46787 .4775 L
.46753 .47289 L
.46713 .46833 L
.46666 .46384 L
.46601 .45853 L
.46547 .45473 L
.46489 .45104 L
.46426 .44751 L
.46359 .44416 L
.46288 .44101 L
.46214 .43811 L
.46135 .43548 L
.46054 .43315 L
.4597 .43116 L
.45884 .42954 L
.45775 .42807 L
.45688 .42737 L
.45601 .42708 L
.45514 .4272 L
.45427 .42773 L
.45341 .42868 L
.45256 .43004 L
.45173 .43179 L
.45093 .43391 L
.45037 .43563 L
.44983 .43752 L
.44931 .43957 L
.44881 .44176 L
.44832 .4441 L
.44785 .44656 L
.44741 .44914 L
.44669 .45387 L
.44605 .45888 L
.44548 .4641 L
.44499 .46952 L
.44458 .47508 L
.44426 .48074 L
.44402 .48649 L
.44386 .4923 L
Mistroke
.44379 .49935 L
.44384 .50641 L
.44401 .51344 L
.44414 .51665 L
.44429 .51985 L
.44446 .52302 L
.44467 .52616 L
.4449 .52926 L
.44515 .53232 L
.44543 .53533 L
.44591 .53987 L
.44644 .54424 L
.44703 .54843 L
.44767 .5524 L
.44836 .55611 L
.4491 .55953 L
.44987 .56263 L
.45069 .56537 L
.4511 .56657 L
.45151 .56767 L
.45193 .56868 L
.45236 .56958 L
.4528 .57038 L
.45324 .57108 L
.45368 .57166 L
.45413 .57214 L
.45537 .57288 L
.45662 .57276 L
.45786 .57181 L
.45908 .57006 L
.46026 .56756 L
.46139 .5644 L
.46246 .56066 L
.46347 .55642 L
.4644 .55176 L
.46526 .54664 L
.46604 .54125 L
.46671 .53566 L
.46729 .52991 L
.46777 .52407 L
.46814 .51816 L
.4684 .5122 L
.46857 .50622 L
.46862 .50022 L
.46859 .49528 L
.46849 .49035 L
.46831 .48542 L
.46806 .48052 L
.46775 .47566 L
.46736 .47084 L
Mistroke
.4669 .46608 L
.46637 .46142 L
.46587 .45751 L
.46532 .4537 L
.46472 .45003 L
.46407 .44652 L
.46339 .4432 L
.46266 .4401 L
.46189 .43725 L
.4611 .4347 L
.46061 .43333 L
.46011 .43208 L
.4596 .43095 L
.45909 .42996 L
.45857 .42911 L
.45804 .4284 L
.45751 .42784 L
.45639 .42715 L
.45526 .42715 L
.45414 .42785 L
.45303 .42923 L
.45195 .43128 L
.45091 .43395 L
.44992 .43721 L
.44897 .441 L
.44809 .44526 L
.44728 .44992 L
.44655 .45494 L
.44612 .45832 L
.44572 .46181 L
.44536 .46539 L
.44503 .46905 L
.44474 .47278 L
.44449 .47656 L
.44428 .48039 L
.44403 .48615 L
.44387 .49197 L
.44379 .49781 L
.4438 .50367 L
.4439 .50951 L
.44408 .51532 L
.44435 .52106 L
.44471 .52671 L
.44508 .53152 L
.44552 .53622 L
.44601 .54078 L
.44656 .54517 L
.44717 .54935 L
.44783 .55331 L
.44854 .55699 L
Mistroke
.44929 .56037 L
.45001 .56312 L
.45075 .56557 L
.45152 .56769 L
.45231 .56948 L
.45312 .57091 L
.45395 .57196 L
.45478 .57264 L
.45533 .57287 L
.45587 .57293 L
.45642 .57284 L
.45696 .57258 L
.4575 .57217 L
.45804 .5716 L
.45869 .5707 L
.45934 .56958 L
.45969 .56887 L
.46004 .56809 L
.46038 .56726 L
.46072 .56637 L
.46106 .56542 L
.4611 .56529 L
.46114 .56516 L
.46119 .56503 L
.46123 .5649 L
.46124 .56488 L
.46124 .56487 L
.46125 .56486 L
.46125 .56485 L
.46125 .56484 L
.46125 .56484 L
.46125 .56483 L
.46126 .56482 L
.46235 .5611 L
.46337 .55686 L
.46432 .55219 L
.46518 .54717 L
.46595 .54189 L
.46663 .5364 L
.46721 .53075 L
.4677 .52501 L
.46808 .51919 L
.46836 .51333 L
.46854 .50743 L
.46862 .50217 L
.46861 .49691 L
.46852 .49165 L
.46835 .4864 L
.4681 .48118 L
.46777 .47599 L
Mistroke
.46736 .47085 L
.46687 .46579 L
.46645 .46201 L
.46598 .45831 L
.46547 .4547 L
.46491 .4512 L
.46432 .44783 L
.46369 .44462 L
.46302 .4416 L
.46232 .43879 L
.46179 .43688 L
.46124 .43512 L
.46067 .4335 L
.4601 .43205 L
.45951 .43076 L
.45891 .42965 L
.4583 .42873 L
.45753 .42785 L
.4565 .42719 L
.45594 .42707 L
.45538 .42712 L
.45482 .42734 L
.45426 .42774 L
.45371 .4283 L
.45316 .42903 L
.45244 .43026 L
.45174 .43177 L
.4514 .43262 L
.45106 .43353 L
.45073 .4345 L
.4504 .43554 L
.45008 .43663 L
.45004 .43675 L
.45001 .43687 L
.44998 .437 L
.44994 .43712 L
.44994 .43713 L
.44993 .43714 L
.44993 .43716 L
.44993 .43716 L
.44993 .43717 L
.44993 .43718 L
.44992 .43718 L
.44992 .43719 L
.449 .4409 L
.44813 .44507 L
.4469 .45246 L
.44585 .46063 L
.44528 .46617 L
.44481 .47189 L
Mistroke
.44442 .47775 L
.44412 .48372 L
.44392 .48976 L
.44381 .49585 L
.44379 .50195 L
.44387 .50805 L
.44396 .51178 L
.44409 .5155 L
.44425 .51919 L
.44445 .52285 L
.44469 .52646 L
.44496 .53003 L
.44526 .53354 L
.44554 .53644 L
.44584 .53928 L
.44616 .54207 L
.44651 .54478 L
.44688 .54742 L
.44727 .54998 L
.44768 .55244 L
.44833 .55596 L
.44903 .55923 L
.44976 .56221 L
.45052 .56487 L
.45132 .56718 L
.45214 .56913 L
.45299 .5707 L
.45385 .57185 L
.45503 .57276 L
.45622 .57289 L
.45741 .57225 L
.45859 .57086 L
.45973 .56878 L
.46084 .56605 L
.46189 .56275 L
.46307 .55817 L
.46416 .55301 L
.46515 .54739 L
.46594 .54201 L
.46663 .53641 L
.46722 .53066 L
.46771 .5248 L
.4681 .51886 L
.46838 .51288 L
.46855 .50687 L
.46862 .50085 L
.46858 .49483 L
.46844 .48881 L
.46819 .48282 L
.46791 .47808 L
Mistroke
.46757 .47337 L
.46716 .46872 L
.46669 .46414 L
.46615 .45965 L
.46555 .45529 L
.4649 .45108 L
.46418 .44707 L
.46323 .44251 L
.46221 .43839 L
.46135 .43547 L
.46045 .43291 L
.45952 .43078 L
.45856 .4291 L
.45758 .42791 L
.45659 .42723 L
.4556 .42708 L
.4546 .42748 L
.45365 .42837 L
.45271 .42976 L
.4518 .43163 L
.45091 .43396 L
.45006 .43671 L
.44924 .43985 L
.44847 .44335 L
.44782 .44673 L
.44722 .45033 L
.44666 .45412 L
.44615 .45809 L
.44568 .4622 L
.44526 .46644 L
.44489 .47078 L
.44447 .47686 L
.44415 .48306 L
.44393 .48933 L
.44381 .49566 L
.44379 .50201 L
.44387 .50835 L
.44406 .51465 L
.44434 .52088 L
.44463 .52556 L
.44497 .53016 L
.44536 .53467 L
.44581 .53905 L
.44632 .5433 L
.44687 .54737 L
.44747 .55125 L
.44812 .5549 L
.44881 .55827 L
.44954 .56136 L
.4503 .56414 L
Mistroke
.4511 .56658 L
.45192 .56865 L
.45277 .57033 L
.45363 .57161 L
.45451 .57246 L
.45557 .57292 L
.45664 .57275 L
.45748 .57219 L
.4583 .57127 L
.45912 .56999 L
.45991 .56838 L
.46069 .56645 L
.46144 .56424 L
.46217 .56177 L
.46333 .55704 L
.4644 .55176 L
.46536 .54604 L
.4662 .54 L
.46692 .53372 L
.46752 .52728 L
.46799 .52073 L
.46833 .51412 L
.46854 .50746 L
.46862 .50079 L
.46857 .49412 L
.46839 .48746 L
.46808 .48084 L
.46777 .47596 L
.46738 .47114 L
.46693 .46638 L
.46641 .46171 L
.46582 .45715 L
.46517 .45275 L
.46445 .44854 L
.46368 .44455 L
.46293 .4412 L
.46214 .43811 L
.46131 .43533 L
.46044 .4329 L
.45955 .43084 L
.45863 .42921 L
.4577 .42802 L
.45675 .4273 L
.45569 .42707 L
.45463 .42746 L
.45358 .42846 L
.45255 .43006 L
.45155 .43224 L
.45058 .43497 L
.44965 .43819 L
Mistroke
.44878 .44187 L
.44796 .44596 L
.44721 .4504 L
.44652 .45514 L
.4459 .46014 L
.44536 .46535 L
.4449 .47072 L
.44448 .47666 L
.44417 .48272 L
.44394 .48885 L
.44382 .49503 L
.44379 .50124 L
.44385 .50744 L
.44402 .51361 L
.44428 .51971 L
.44458 .52483 L
.44494 .52985 L
.44537 .53477 L
.44587 .53953 L
.44642 .54413 L
.44704 .54852 L
.44772 .55266 L
.44844 .55652 L
.4494 .56081 L
.4499 .56272 L
.45041 .5645 L
.45094 .56612 L
.45148 .56759 L
.45203 .56889 L
.45259 .57001 L
.45316 .57096 L
.45373 .57172 L
.45431 .57231 L
.4549 .5727 L
.4559 .57293 L
.45691 .57261 L
.45791 .57176 L
.45889 .57038 L
.45985 .56852 L
.46078 .56621 L
.46168 .56348 L
.46253 .56039 L
.46375 .55507 L
.46486 .54916 L
.46583 .5428 L
.46666 .53613 L
.46735 .52923 L
.46789 .52219 L
.46829 .51507 L
.46853 .5079 L
Mistroke
.46862 .5007 L
.46859 .4955 L
.46848 .49031 L
.4683 .48513 L
.46803 .47997 L
.46769 .47486 L
.46726 .46979 L
.46676 .46481 L
.46619 .45994 L
.46554 .45521 L
.46497 .45153 L
.46435 .44799 L
.46369 .44463 L
.46299 .44147 L
.46225 .43855 L
.46148 .43588 L
.46068 .43352 L
.45985 .43148 L
.45932 .43038 L
.45877 .42943 L
.45822 .42863 L
.45767 .42799 L
.45711 .42752 L
.45655 .42721 L
.45599 .42707 L
.45542 .42711 L
.45486 .42732 L
.4543 .42771 L
.45328 .42885 L
.45229 .43056 L
.45132 .43281 L
.45039 .43557 L
.4495 .43879 L
.44866 .44243 L
.44788 .44644 L
.44715 .45079 L
.44664 .45429 L
.44616 .45794 L
.44573 .46171 L
.44534 .46559 L
.44499 .46956 L
.44468 .47361 L
.44442 .47772 L
.44413 .48363 L
.44392 .48961 L
.44381 .49563 L
.44379 .50166 L
.44386 .5077 L
.44402 .5137 L
.44428 .51964 L
Mistroke
.44462 .52549 L
.44494 .52985 L
.44531 .53413 L
.44573 .53831 L
.4462 .54236 L
.44671 .54626 L
.44727 .54999 L
.44787 .55353 L
.44851 .55685 L
.44901 .55915 L
.44952 .5613 L
.45006 .5633 L
.45061 .56513 L
.45118 .56679 L
.45175 .56827 L
.45235 .56955 L
.45311 .57088 L
.45412 .57213 L
.45467 .57257 L
.45522 .57283 L
.45578 .57293 L
.45633 .57286 L
.45689 .57263 L
.45744 .57223 L
.45816 .57146 L
.45887 .57041 L
.45922 .56979 L
.45958 .5691 L
.45992 .56835 L
.46027 .56754 L
.46061 .56667 L
.46065 .56655 L
.4607 .56643 L
.46074 .56631 L
.46079 .56618 L
.46079 .56617 L
.4608 .56616 L
.4608 .56614 L
.4608 .56614 L
.46081 .56613 L
.46081 .56613 L
.46081 .56612 L
.46081 .56611 L
.46196 .56252 L
.46303 .55835 L
.46403 .55369 L
.46494 .54865 L
.46576 .54329 L
.46648 .53771 L
.4671 .53195 L
Mistroke
.46761 .52608 L
.46803 .52012 L
.46833 .51411 L
.46853 .50807 L
.46862 .50202 L
.4686 .49596 L
.46847 .48991 L
.46824 .48387 L
.46797 .47893 L
.46762 .47402 L
.46721 .46917 L
.46672 .46439 L
.46616 .45972 L
.46554 .45517 L
.46485 .4508 L
.4641 .44665 L
.46329 .44275 L
.46242 .43917 L
.4615 .43595 L
.46094 .43424 L
.46036 .43269 L
.45977 .43131 L
.45917 .43011 L
.45856 .4291 L
.45794 .42828 L
.45731 .42767 L
.45623 .42711 L
.45514 .42719 L
.45406 .42792 L
.453 .42928 L
.45196 .43126 L
.45095 .43383 L
.44999 .43694 L
.44908 .44055 L
.44822 .4446 L
.44743 .44904 L
.4467 .45381 L
.44626 .45714 L
.44585 .46058 L
.44548 .46412 L
.44514 .46774 L
.44484 .47143 L
.44458 .47518 L
.44435 .47898 L
.44408 .48477 L
.4439 .49062 L
.4438 .49651 L
.44379 .50241 L
.44387 .50831 L
.44404 .51417 L
Mistroke
.44429 .51997 L
.44463 .52568 L
.445 .53057 L
.44543 .53535 L
.44592 .53998 L
.44647 .54445 L
.44707 .54872 L
.44773 .55275 L
.44844 .55652 L
.4492 .55998 L
.44992 .56279 L
.45066 .5653 L
.45144 .56749 L
.45224 .56933 L
.45305 .5708 L
.45389 .5719 L
.45473 .5726 L
.45527 .57285 L
.45582 .57293 L
.45636 .57285 L
.45691 .57261 L
.45745 .57222 L
.45799 .57166 L
.45864 .57078 L
.45928 .56968 L
.45964 .56898 L
.45999 .56821 L
.46033 .56739 L
.46067 .56651 L
.46101 .56557 L
.46105 .56544 L
.46109 .56531 L
.46114 .56518 L
.46118 .56504 L
.46119 .56503 L
.46119 .56502 L
.4612 .565 L
.4612 .565 L
.4612 .56499 L
.4612 .56498 L
.46121 .56498 L
.46121 .56497 L
.4623 .56127 L
.46333 .55704 L
.46428 .55238 L
.46515 .54737 L
.46593 .54208 L
.46661 .53659 L
.4672 .53094 L
.46768 .52519 L
Mistroke
.46807 .51936 L
.46836 .51349 L
.46854 .50759 L
.46861 .50232 L
.46861 .49705 L
.46852 .49179 L
.46836 .48653 L
.46811 .4813 L
.46778 .4761 L
.46737 .47096 L
.46688 .46589 L
.46646 .46211 L
.46599 .4584 L
.46548 .45478 L
.46493 .45128 L
.46434 .44791 L
.4637 .44469 L
.46304 .44167 L
.46234 .43885 L
.4618 .43694 L
.46125 .43517 L
.46069 .43355 L
.46011 .43209 L
.45953 .43079 L
.45893 .42968 L
.45832 .42876 L
.45754 .42787 L
.45651 .4272 L
.45596 .42707 L
.4554 .42712 L
.45484 .42733 L
.45429 .42772 L
.45374 .42827 L
.45319 .42899 L
.45248 .43019 L
.45178 .43168 L
.45144 .43252 L
.4511 .43342 L
.45077 .43439 L
.45044 .43541 L
.45011 .4365 L
.45008 .43663 L
.45004 .43676 L
.45001 .43689 L
.44997 .43702 L
.44997 .43703 L
.44996 .43704 L
.44996 .43706 L
.44996 .43706 L
.44995 .43707 L
Mistroke
.44995 .43708 L
.44995 .43708 L
.44995 .43709 L
.44899 .44093 L
.4481 .44525 L
.44687 .45265 L
.44583 .46082 L
.44526 .46639 L
.44479 .47214 L
.4444 .47803 L
.44411 .48402 L
.44391 .49009 L
.4438 .4962 L
.44379 .50233 L
.44387 .50844 L
.44397 .51216 L
.4441 .51586 L
.44427 .51954 L
.44447 .52318 L
.44471 .52678 L
.44498 .53032 L
.44528 .53381 L
.44558 .53688 L
.44591 .53989 L
.44626 .54282 L
.44663 .54568 L
.44703 .54844 L
.44745 .55111 L
.4479 .55367 L
.44877 .55806 L
.4497 .56198 L
.45069 .56538 L
.45173 .56821 L
.45281 .5704 L
.45392 .57193 L
.45504 .57277 L
.45618 .5729 L
.45731 .57234 L
.45842 .5711 L
.45951 .56923 L
.46057 .56677 L
.46159 .56378 L
.46255 .56032 L
.46366 .55553 L
.46467 .55024 L
.46557 .54458 L
.46637 .53863 L
.46705 .53248 L
.46761 .52618 L
.46805 .51978 L
Mistroke
.46836 .51333 L
.46853 .50806 L
.46861 .50278 L
.46861 .49749 L
.46853 .49221 L
.46837 .48694 L
.46813 .48169 L
.4678 .47647 L
.4674 .47131 L
.46707 .46775 L
.4667 .46424 L
.4663 .46078 L
.46585 .45739 L
.46538 .45408 L
.46486 .45088 L
.46431 .44779 L
.46359 .44417 L
.46283 .44079 L
.46202 .43769 L
.46117 .43492 L
.46029 .43251 L
.45938 .4305 L
.45844 .42892 L
.45749 .42782 L
.45632 .42713 L
.45514 .42719 L
.45398 .42801 L
.45301 .42927 L
.45206 .43104 L
.45114 .4333 L
.45026 .43601 L
.44941 .43915 L
.44861 .44267 L
.44786 .44653 L
.44716 .4507 L
.44639 .4561 L
.44572 .46183 L
.44514 .4678 L
.44466 .47397 L
.44428 .48028 L
.44401 .4867 L
.44384 .49319 L
.44378 .4997 L
.44383 .50622 L
.44399 .51271 L
.44425 .51914 L
.44452 .52394 L
.44485 .52866 L
.44523 .53328 L
.44568 .53779 L
Mistroke
.44618 .54216 L
.44673 .54636 L
.44733 .55036 L
.44798 .55413 L
.44851 .55684 L
.44906 .55939 L
.44964 .56175 L
.45024 .56392 L
.45086 .56588 L
.45149 .56762 L
.45214 .56913 L
.45283 .57044 L
.45353 .57148 L
.45424 .57224 L
.45495 .57273 L
.45567 .57293 L
.45639 .57285 L
.4571 .57249 L
.45766 .57202 L
.4582 .5714 L
.45875 .57061 L
.45928 .56968 L
.45981 .56861 L
.46033 .56739 L
.46075 .56628 L
.46117 .56508 L
.46158 .5638 L
.46198 .56244 L
.46237 .56101 L
.46284 .55915 L
.4633 .5572 L
.46373 .55517 L
.46416 .55305 L
.46456 .55086 L
.46507 .54783 L
.46556 .5447 L
.46601 .54149 L
.46623 .53976 L
.46644 .53801 L
.46665 .53625 L
.46684 .53447 L
.46703 .53268 L
.46713 .53166 L
.46722 .53063 L
.46732 .52959 L
.46741 .52856 L
.46744 .52822 L
.46747 .52787 L
.4675 .52753 L
.4675 .52752 L
Mistroke
.4675 .5275 L
.4675 .52748 L
.4675 .52747 L
.46753 .52713 L
.46756 .52678 L
.46759 .52644 L
.46767 .52539 L
.46773 .52453 L
.46779 .52366 L
.46785 .5228 L
.46791 .52194 L
.46802 .5202 L
.46812 .51846 L
.46821 .51672 L
.46829 .51497 L
.46837 .51323 L
.46849 .50952 L
.46857 .5058 L
.46862 .50208 L
.46862 .49836 L
.46858 .49464 L
.4685 .49092 L
.4683 .48527 L
.46801 .47964 L
.46763 .47407 L
.46727 .46986 L
.46686 .46571 L
.4664 .46163 L
.46589 .45765 L
.46544 .45451 L
.46496 .45146 L
.46445 .44851 L
.4639 .44567 L
.46334 .44297 L
.46274 .44042 L
.46204 .43775 L
.46131 .43533 L
.46055 .43317 L
.45977 .4313 L
.45897 .42975 L
.45815 .42853 L
.45732 .42767 L
.45637 .42715 L
.45541 .42711 L
.45446 .42758 L
.45351 .42854 L
.45258 .43 L
.45168 .43192 L
.4508 .43429 L
.44995 .43708 L
Mistroke
.44915 .44025 L
.44839 .44376 L
.44767 .44759 L
.44725 .45013 L
.44685 .45276 L
.44647 .45549 L
.44612 .4583 L
.44579 .46117 L
.44548 .46412 L
.4452 .46712 L
.4449 .47065 L
.44464 .47424 L
.44441 .47788 L
.44422 .48156 L
.44406 .48528 L
.44394 .48901 L
.44385 .49277 L
.44379 .49883 L
.44381 .50489 L
.44394 .51093 L
.44415 .51693 L
.44445 .52285 L
.44485 .52866 L
.44533 .53433 L
.4459 .53981 L
.44681 .54694 L
.44786 .55349 L
.44856 .55709 L
.4493 .5604 L
.45008 .56338 L
.4509 .56601 L
.45174 .56824 L
.45262 .57006 L
.45351 .57145 L
.45442 .57239 L
.45502 .57276 L
.45563 .57292 L
.45624 .57289 L
.45684 .57265 L
.45745 .57222 L
.45805 .57159 L
.45864 .57078 L
.4595 .56925 L
.46035 .56735 L
.46116 .56511 L
.46195 .56255 L
.4627 .55972 L
.46342 .55664 L
.4641 .55334 L
.46474 .54986 L
Mistroke
.46533 .54622 L
.46587 .54246 L
.46652 .53732 L
.46709 .53204 L
.46749 .52766 L
.46783 .52323 L
.4681 .51876 L
.46832 .51426 L
.46848 .50975 L
.46858 .50523 L
.46862 .5007 L
.4686 .49567 L
.46849 .49066 L
.46832 .48565 L
.46807 .48067 L
.46775 .47572 L
.46736 .47082 L
.46689 .46599 L
.46635 .46125 L
.46575 .45663 L
.46508 .45218 L
.46434 .44793 L
.46354 .44392 L
.46269 .44022 L
.46178 .43687 L
.46083 .43393 L
.45984 .43145 L
.459 .4298 L
.45814 .42852 L
.45727 .42763 L
.45639 .42715 L
.4555 .42709 L
.45462 .42746 L
.45375 .42826 L
.45289 .42947 L
.45204 .43108 L
.45122 .43309 L
.45057 .43499 L
.44994 .43711 L
.44934 .43945 L
.44876 .44198 L
.4482 .4447 L
.44767 .44759 L
.44717 .45063 L
.4466 .45457 L
.44607 .45869 L
.4456 .46297 L
.44517 .46738 L
.44481 .4719 L
.44449 .4765 L
Mistroke
.44424 .48118 L
.44401 .48673 L
.44386 .49234 L
.44379 .49798 L
.4438 .50362 L
.44389 .50925 L
.44406 .51485 L
.44432 .52039 L
.44465 .52585 L
.44492 .5296 L
.44523 .53328 L
.44558 .53689 L
.44597 .54042 L
.44639 .54384 L
.44684 .54715 L
.44732 .55033 L
.44806 .55458 L
.44886 .55849 L
.44971 .56202 L
.45061 .56512 L
.45154 .56775 L
.45232 .5695 L
.45312 .5709 L
.45393 .57195 L
.45475 .57262 L
.45558 .57292 L
.45641 .57284 L
.45723 .5724 L
.45824 .57135 L
.45923 .56977 L
.4602 .56771 L
.46097 .56567 L
.46171 .56336 L
.46243 .56079 L
.46312 .558 L
.46377 .55501 L
.46438 .55184 L
.46496 .54852 L
.46559 .54447 L
.46616 .54028 L
.46668 .53598 L
.46713 .53159 L
.46753 .52713 L
.46787 .52262 L
.46814 .51808 L
.46835 .51351 L
.46851 .50892 L
.4686 .50432 L
.46862 .49972 L
.46859 .49512 L
Mistroke
.46849 .49052 L
.46829 .48503 L
.46801 .47957 L
.46763 .47415 L
.46717 .4688 L
.46662 .46354 L
.46599 .45842 L
.46541 .45428 L
.46476 .4503 L
.46407 .4465 L
.46332 .44292 L
.46253 .43961 L
.4617 .4366 L
.46083 .43393 L
.4602 .43228 L
.45955 .43084 L
.45888 .42961 L
.45821 .42861 L
.45753 .42786 L
.45684 .42735 L
.45615 .4271 L
.45517 .42718 L
.45419 .4278 L
.45322 .42895 L
.45227 .4306 L
.45135 .43275 L
.45045 .43536 L
.4496 .4384 L
.44879 .44183 L
.44788 .44641 L
.44705 .45144 L
.4463 .45683 L
.44565 .46251 L
.44508 .46844 L
.44462 .47455 L
.44426 .4808 L
.44399 .48715 L
.44384 .49356 L
.44378 .5 L
.44384 .50644 L
.44399 .51267 L
.44424 .51884 L
.44458 .52491 L
.44502 .53086 L
.44556 .53665 L
.44618 .54221 L
.44689 .5475 L
.44768 .55246 L
.44813 .55494 L
.4486 .55729 L
Mistroke
.44909 .55952 L
.4496 .5616 L
.45013 .56354 L
.45067 .56531 L
.45122 .56692 L
.45204 .56891 L
.45287 .57051 L
.45373 .57172 L
.4546 .57252 L
.45547 .5729 L
.45634 .57286 L
.45722 .57241 L
.45808 .57155 L
.45919 .56985 L
.46005 .56806 L
.46088 .56592 L
.46169 .56345 L
.46246 .56068 L
.46319 .55765 L
.46389 .5544 L
.46455 .55094 L
.46516 .54732 L
.46572 .54356 L
.46624 .53968 L
.46682 .53468 L
.46732 .52957 L
.46774 .52438 L
.46808 .51914 L
.46834 .51386 L
.46852 .50855 L
.46861 .50323 L
.46862 .49791 L
.46854 .49259 L
.46839 .48728 L
.46815 .482 L
.46782 .47674 L
.46742 .47154 L
.46693 .46641 L
.46637 .46138 L
.46573 .4565 L
.46501 .45179 L
.46422 .44731 L
.46337 .44312 L
.46245 .43928 L
.46147 .43586 L
.46045 .43291 L
.45982 .43141 L
.45917 .43011 L
.45852 .42904 L
.45785 .42818 L
Mistroke
.45718 .42757 L
.4565 .42719 L
.45583 .42707 L
.45516 .42719 L
.4545 .42754 L
.45385 .42814 L
.4532 .42898 L
.45256 .43004 L
.45193 .43134 L
.45131 .43284 L
.45071 .43456 L
.45012 .43648 L
.44955 .43858 L
.44867 .4424 L
.44784 .44663 L
.44708 .45122 L
.44651 .45525 L
.44598 .45947 L
.44551 .46383 L
.44509 .46833 L
.44473 .47293 L
.44443 .47762 L
.44418 .48237 L
.44399 .48718 L
.44388 .49143 L
.44381 .49569 L
.44378 .49997 L
.44381 .50424 L
.44388 .50851 L
.44399 .51276 L
.44415 .51698 L
.44449 .52343 L
.44493 .52976 L
.44548 .5359 L
.44613 .54181 L
.44688 .54742 L
.44772 .55266 L
.44864 .55745 L
.44963 .56173 L
.4507 .5654 L
.45181 .56841 L
.45298 .57068 L
.45417 .57218 L
.45539 .57288 L
.4566 .57277 L
.45713 .57247 L
.45765 .57203 L
.45817 .57144 L
.45869 .57071 L
.45919 .56985 L
Mistroke
.4597 .56885 L
.46019 .56773 L
.46095 .56572 L
.46169 .56344 L
.4624 .5609 L
.46308 .55814 L
.46373 .55518 L
.46434 .55205 L
.46492 .54877 L
.46546 .54537 L
.4661 .54073 L
.46668 .53595 L
.46718 .53106 L
.46761 .52609 L
.46797 .52107 L
.46825 .516 L
.46845 .5109 L
.46857 .5058 L
.46862 .50068 L
.46856 .49322 L
.46833 .48579 L
.46793 .4784 L
.46738 .4711 L
.46667 .46395 L
.46581 .45704 L
.46479 .45047 L
.46364 .44439 L
.46262 .43994 L
.46152 .436 L
.46036 .43267 L
.45914 .43005 L
.45788 .42822 L
.4566 .42723 L
.45531 .42714 L
.45403 .42795 L
.45277 .42967 L
.45231 .43052 L
.45186 .43148 L
.45142 .43256 L
.45099 .43374 L
.45056 .43503 L
.45014 .43641 L
.44973 .4379 L
.44933 .43947 L
.44859 .44278 L
.44789 .44638 L
.44723 .45024 L
.44663 .45434 L
.44608 .45863 L
.44559 .46308 L
Mistroke
.44515 .46768 L
.44477 .4724 L
.4444 .47799 L
.44412 .48368 L
.44393 .48944 L
.44381 .49524 L
.44379 .50105 L
.44384 .50686 L
.44399 .51265 L
.44422 .51838 L
.4445 .52355 L
.44485 .52863 L
.44526 .53361 L
.44575 .53844 L
.44629 .54311 L
.4469 .54758 L
.44757 .55181 L
.44829 .55575 L
.44915 .55976 L
.45007 .56333 L
.45103 .56639 L
.45204 .56891 L
.45308 .57084 L
.45414 .57216 L
.45522 .57283 L
.45631 .57287 L
.4571 .57249 L
.45789 .57177 L
.45868 .57073 L
.45944 .56937 L
.46019 .56772 L
.46093 .5658 L
.46164 .56362 L
.46232 .56121 L
.46328 .5573 L
.46416 .553 L
.46498 .5484 L
.46572 .54355 L
.46638 .5385 L
.46696 .53331 L
.46746 .52801 L
.46787 .52264 L
.46822 .51662 L
.46846 .51056 L
.46859 .50447 L
.46862 .49838 L
.46854 .4923 L
.46834 .48622 L
.46804 .48018 L
.46764 .47419 L
Mistroke
.46712 .46828 L
.4665 .46249 L
.46578 .45687 L
.46496 .45148 L
.46405 .4464 L
.46305 .44171 L
.46197 .43751 L
.46102 .43447 L
.46003 .43188 L
.459 .4298 L
.45795 .42829 L
.45687 .42737 L
.45579 .42707 L
.45471 .4274 L
.45364 .42838 L
.45312 .4291 L
.45259 .42998 L
.45208 .431 L
.45157 .43217 L
.45108 .43348 L
.45059 .43492 L
.45012 .4365 L
.44936 .43937 L
.44864 .44255 L
.44796 .44601 L
.44732 .44971 L
.44673 .45364 L
.44619 .45775 L
.4457 .46203 L
.44526 .46644 L
.44474 .47276 L
.4444 .47813 L
.44413 .48358 L
.44394 .4891 L
.44382 .49466 L
.44378 .50024 L
.44383 .50581 L
.44395 .51137 L
.44418 .51768 L
.44452 .52391 L
.44495 .53002 L
.44549 .53595 L
.44612 .54166 L
.44683 .5471 L
.44763 .55219 L
.44852 .55688 L
.44903 .55923 L
.44956 .56143 L
.45011 .56347 L
.45067 .56533 L
Mistroke
.45125 .56701 L
.45185 .56849 L
.45246 .56977 L
.45335 .57123 L
.45425 .57225 L
.45517 .57282 L
.45609 .57291 L
.457 .57256 L
.45791 .57175 L
.45881 .57051 L
.45969 .56887 L
.46064 .56658 L
.46156 .56386 L
.46244 .56076 L
.46327 .55732 L
.46405 .55359 L
.46478 .54962 L
.46545 .54545 L
.46606 .54111 L
.4666 .53665 L
.46716 .53128 L
.46764 .52581 L
.46802 .52027 L
.46831 .51469 L
.4685 .50908 L
.46861 .50345 L
.46862 .49782 L
.46853 .49219 L
.46836 .48657 L
.46804 .48021 L
.46761 .4739 L
.46706 .46769 L
.4664 .46161 L
.46562 .45573 L
.46473 .45013 L
.46374 .44489 L
.46266 .44011 L
.46149 .43592 L
.46025 .43242 L
.45896 .42973 L
.45762 .42794 L
.45703 .42746 L
.45644 .42717 L
.45585 .42707 L
.45527 .42715 L
.45468 .42743 L
.45409 .42789 L
.45351 .42854 L
.45294 .42938 L
.45243 .43029 L
Mistroke
.45193 .43134 L
.45143 .43253 L
.45095 .43385 L
.45047 .4353 L
.45001 .43688 L
.44956 .43858 L
.44858 .44279 L
.44784 .44665 L
.44714 .45081 L
.44651 .45522 L
.44594 .45986 L
.44543 .46467 L
.44498 .46964 L
.44461 .47472 L
.4443 .4799 L
.44403 .48598 L
.44386 .49212 L
.44379 .49829 L
.44381 .50447 L
.44393 .51063 L
.44414 .51675 L
.44445 .52278 L
.44485 .52871 L
.44535 .53449 L
.44593 .54007 L
.4466 .54541 L
.44728 .55002 L
.44802 .55434 L
.44882 .55831 L
.44968 .5619 L
.45058 .56505 L
.45153 .56772 L
.45251 .56986 L
.45351 .57146 L
.45454 .57248 L
.45558 .57292 L
.45661 .57276 L
.45759 .57208 L
.45856 .5709 L
.45951 .56924 L
.46043 .56714 L
.46132 .56463 L
.46217 .56176 L
.46299 .55856 L
.46375 .55507 L
.46447 .55135 L
.46514 .54743 L
.46575 .54334 L
.46639 .53844 L
.46695 .53341 L
Mistroke
.46743 .52827 L
.46784 .52307 L
.46816 .51781 L
.46839 .51252 L
.46855 .50721 L
.46862 .50189 L
.46861 .49656 L
.46847 .48972 L
.46819 .48291 L
.46778 .47614 L
.46723 .46947 L
.46655 .46293 L
.46575 .45661 L
.46481 .45059 L
.46376 .44497 L
.4626 .43988 L
.46135 .43546 L
.46025 .43242 L
.45911 .43 L
.45793 .42827 L
.45673 .42729 L
.45552 .42709 L
.45431 .4277 L
.45312 .42909 L
.45196 .43126 L
.45084 .43416 L
.45045 .43539 L
.45006 .43671 L
.44968 .4381 L
.44931 .43958 L
.44894 .44113 L
.44859 .44276 L
.44825 .44445 L
.44792 .44621 L
.44715 .45079 L
.44645 .45568 L
.44583 .46084 L
.44528 .46621 L
.44482 .47176 L
.44444 .47744 L
.44414 .48322 L
.44394 .48907 L
.4438 .49638 L
.4438 .50372 L
.44394 .51103 L
.44421 .51828 L
.44462 .5254 L
.44515 .53235 L
.44581 .53905 L
.4466 .54541 L
Mistroke
.44705 .54857 L
.44754 .55161 L
.44805 .55449 L
.44859 .55723 L
.44915 .55978 L
.44974 .56215 L
.45036 .56432 L
.45099 .56627 L
.45164 .56798 L
.4523 .56946 L
.45319 .57101 L
.4541 .57211 L
.45501 .57275 L
.45593 .57293 L
.45685 .57264 L
.45777 .57191 L
.45867 .57073 L
.45956 .56914 L
.46053 .56689 L
.46146 .56419 L
.46235 .56108 L
.4632 .55763 L
.464 .55387 L
.46473 .54987 L
.46542 .54565 L
.46604 .54126 L
.46659 .53674 L
.46716 .53136 L
.46763 .52588 L
.46801 .52033 L
.4683 .51473 L
.4685 .5091 L
.46861 .50346 L
.46862 .49781 L
.46853 .49216 L
.46836 .48653 L
.46804 .48016 L
.46761 .47386 L
.46706 .46764 L
.46639 .46157 L
.46561 .45569 L
.46473 .45009 L
.46374 .44485 L
.46265 .44008 L
.46149 .43589 L
.46024 .4324 L
.45895 .42971 L
.4576 .42793 L
.45706 .42748 L
.45652 .4272 L
Mistroke
.45597 .42707 L
.45542 .42711 L
.45488 .42731 L
.45433 .42768 L
.45379 .4282 L
.45326 .42889 L
.45258 .43 L
.45191 .43137 L
.45126 .43297 L
.45063 .43481 L
.45001 .43687 L
.44942 .43913 L
.44884 .44159 L
.44803 .44561 L
.44727 .44999 L
.44659 .45466 L
.44597 .45959 L
.44542 .46473 L
.44495 .47004 L
.44456 .47549 L
.44424 .48104 L
.44401 .48666 L
.44386 .49234 L
.44379 .49805 L
.44379 .5023 L
.44384 .50656 L
.44393 .5108 L
.44407 .51501 L
.44426 .5192 L
.44448 .52334 L
.44476 .52743 L
.44523 .53319 L
.44578 .53877 L
.44642 .54413 L
.44715 .5492 L
.44795 .55394 L
.44881 .55828 L
.44975 .56216 L
.45073 .56552 L
.45177 .5683 L
.45284 .57046 L
.45395 .57196 L
.45507 .57278 L
.4562 .5729 L
.45732 .57233 L
.45784 .57183 L
.45835 .5712 L
.45886 .57042 L
.45937 .56952 L
.45987 .56848 L
Mistroke
.46035 .56733 L
.46084 .56605 L
.46162 .56367 L
.46237 .56101 L
.46309 .55809 L
.46378 .55496 L
.46442 .55163 L
.46502 .54814 L
.46558 .54451 L
.4661 .54077 L
.46663 .53642 L
.46687 .5342 L
.4671 .53197 L
Mfstroke
.02 w
.4675 .5275 Mdot
.5 Mabswid
.46687 .5342 m
.4671 .53197 L
s
% Start of user PostScript
-0.26503796 0.27362914 -0.26322562 0.25576776 MAarrowhead1
% End of user PostScript
1 .149 0 r
.47494 .39257 m
.47413 .39027 L
.47329 .38788 L
.47197 .38404 L
.47094 .38107 L
.46989 .37806 L
.46882 .37506 L
.46771 .37211 L
.46658 .36925 L
.46543 .36652 L
.46425 .36398 L
.46306 .36167 L
.46184 .35964 L
.46061 .35792 L
.45959 .35678 L
.45857 .35589 L
.45754 .35528 L
.4565 .35494 L
.45547 .35489 L
.45444 .35514 L
.45341 .35568 L
.45258 .35633 L
.45175 .35717 L
.45093 .35819 L
.45011 .35939 L
.44931 .36075 L
.44851 .36227 L
.44789 .36354 L
.44729 .3649 L
.44669 .36634 L
.44609 .36785 L
.44551 .36943 L
.44481 .37142 L
.44412 .37348 L
.44344 .37562 L
.44278 .37782 L
.44213 .38006 L
.44149 .38234 L
.44069 .38527 L
.43992 .38822 L
.43897 .39199 L
.43844 .39416 L
.43791 .39632 L
.4374 .39847 L
.4369 .4006 L
.43641 .4027 L
.43636 .40291 L
.43631 .40312 L
.43626 .40332 L
.43621 .40353 L
Mistroke
.43621 .40355 L
.4362 .40357 L
.4362 .40359 L
.4362 .4036 L
.4362 .40361 L
.43619 .40363 L
.43619 .40364 L
.43619 .40365 L
.435 .40883 L
.43387 .41376 L
.4328 .4184 L
.43179 .42272 L
.43083 .4267 L
.43024 .42907 L
.42967 .43129 L
.42912 .43337 L
.42859 .43529 L
.42807 .43707 L
.42756 .43869 L
.42654 .44163 L
.42556 .44393 L
.42462 .44562 L
.4237 .4467 L
.42279 .44719 L
.42189 .4471 L
.42098 .44644 L
.42016 .44539 L
.41932 .44392 L
.41845 .44202 L
.41755 .43971 L
.41661 .437 L
.41563 .43393 L
.4146 .43051 L
.41352 .42678 L
.41262 .42363 L
.41167 .42035 L
.41069 .41698 L
.40967 .41356 L
.4086 .41013 L
.4075 .40676 L
.40635 .4035 L
.40517 .40043 L
.40395 .39761 L
.4027 .39512 L
.40142 .39303 L
.40012 .3914 L
.3988 .39029 L
.39747 .38975 L
.39614 .38982 L
.39481 .39052 L
Mistroke
.3935 .39185 L
.39248 .39334 L
.39147 .39522 L
.39048 .39746 L
.38952 .40004 L
.38858 .40294 L
.38767 .40613 L
.38679 .40959 L
.38595 .41329 L
.38514 .41719 L
.38438 .42127 L
.38377 .42474 L
.3832 .4283 L
.38265 .43193 L
.38213 .43563 L
.38164 .43938 L
.38118 .44316 L
.38088 .44583 L
.38059 .4485 L
.38031 .45119 L
.38005 .45389 L
.37981 .45659 L
.37978 .45688 L
.37976 .45716 L
.37973 .45745 L
.37971 .45774 L
.37971 .45777 L
.3797 .45779 L
.3797 .45782 L
.3797 .45784 L
.3797 .45785 L
.3797 .45787 L
.3797 .45788 L
.3797 .45789 L
.37895 .46784 L
.37858 .47419 L
.37829 .48052 L
.37808 .48685 L
.37795 .49318 L
.37791 .4995 L
.37794 .50581 L
.37806 .51214 L
.37825 .51847 L
.37859 .52609 L
.37906 .53373 L
.37982 .54355 L
.38029 .54859 L
.38081 .5536 L
.38139 .55857 L
.38201 .56348 L
Mistroke
.38268 .5683 L
.38341 .57302 L
.38418 .5776 L
.38499 .58202 L
.38564 .58527 L
.38632 .58839 L
.38702 .59135 L
.38775 .59416 L
.3885 .59678 L
.38926 .59921 L
.39005 .60142 L
.39102 .60382 L
.39202 .60587 L
.39284 .60723 L
.39366 .60835 L
.39449 .60922 L
.39533 .60983 L
.39617 .61019 L
.39701 .6103 L
.39805 .61009 L
.39908 .60952 L
.39984 .60888 L
.4006 .60805 L
.40136 .60706 L
.40211 .60591 L
.40284 .60461 L
.40357 .60318 L
.40405 .60218 L
.40452 .60113 L
.40498 .60003 L
.40544 .5989 L
.40589 .59773 L
.40595 .59758 L
.40601 .59743 L
.40607 .59727 L
.40612 .59712 L
.40613 .5971 L
.40614 .59709 L
.40614 .59707 L
.40614 .59706 L
.40615 .59706 L
.40615 .59705 L
.40615 .59704 L
.40616 .59703 L
.40808 .59151 L
.40988 .58575 L
.41157 .58001 L
.41314 .57454 L
.4146 .56949 L
.41597 .56498 L
Mistroke
.41726 .56112 L
.41847 .55794 L
.41962 .5555 L
.42073 .55383 L
.42182 .55293 L
.42289 .55284 L
.42355 .55319 L
.42422 .55384 L
.42489 .55481 L
.42558 .55611 L
.42629 .55773 L
.42702 .55969 L
.42777 .56198 L
.42856 .56462 L
.42938 .5676 L
.43015 .57055 L
.43095 .57378 L
.43179 .57727 L
.43267 .58103 L
.43359 .58503 L
.43456 .58926 L
.43557 .59369 L
.43664 .59829 L
.43764 .60252 L
.43868 .60682 L
.43976 .61115 L
.44089 .61546 L
.44206 .61969 L
.44327 .6238 L
.44452 .62772 L
.44581 .63138 L
.447 .63442 L
.44822 .63715 L
.44946 .63953 L
.45072 .64153 L
.452 .64311 L
.45329 .64424 L
.45459 .64492 L
.4559 .64512 L
.4572 .64487 L
.4585 .64416 L
.45979 .64302 L
.46107 .64149 L
.46233 .63959 L
.46388 .63678 L
.46555 .6332 L
.46718 .62926 L
.46876 .6251 L
.47028 .62083 L
.47176 .61658 L
Mistroke
.47318 .61245 L
.47455 .60854 L
.47587 .60492 L
.47715 .60165 L
.47839 .59879 L
.4796 .59638 L
.48079 .59444 L
.48195 .593 L
.4831 .59209 L
.48424 .5917 L
.48537 .59184 L
.48652 .59252 L
.48754 .59357 L
.48858 .59503 L
.48963 .59689 L
.49071 .59915 L
.49181 .60178 L
.49295 .60476 L
.49412 .60805 L
.49533 .61162 L
.49645 .61506 L
.49761 .61864 L
.49881 .62232 L
.50005 .62604 L
.50132 .62976 L
.50263 .63339 L
.50397 .63686 L
.50535 .64011 L
.50657 .6427 L
.50782 .64501 L
.50908 .647 L
.51035 .64864 L
.51164 .64988 L
.51294 .65071 L
.51424 .6511 L
.51555 .65104 L
.51685 .65053 L
.51815 .64958 L
.51943 .64821 L
.52071 .64644 L
.52196 .6443 L
.5235 .64117 L
.52486 .63798 L
.52619 .63451 L
.52748 .63082 L
.52874 .62698 L
.52995 .62306 L
.53113 .61912 L
.53227 .61521 L
.53338 .61137 L
Mistroke
.53444 .60766 L
.53547 .6041 L
.53647 .60074 L
.53744 .59759 L
.53837 .59468 L
.53934 .59187 L
.54028 .58935 L
.54119 .58715 L
.54208 .58527 L
.54296 .58372 L
.54382 .5825 L
.54467 .58161 L
.5455 .58106 L
.54632 .58083 L
.54714 .58092 L
.54797 .58131 L
.5488 .58202 L
.54964 .58302 L
.55069 .58467 L
.55158 .58637 L
.5525 .58835 L
.55343 .59059 L
.55439 .59308 L
.55538 .59579 L
.55639 .5987 L
.55744 .60176 L
.5588 .60578 L
.55989 .60894 L
.561 .61212 L
.56215 .61526 L
.56333 .6183 L
.56454 .62119 L
.56578 .62387 L
.56705 .62627 L
.56833 .62834 L
.56964 .63002 L
.57096 .63127 L
.57229 .63204 L
.5739 .63228 L
.57552 .63176 L
.57712 .63045 L
.5787 .62837 L
.58025 .62557 L
.58176 .62212 L
.58322 .61808 L
.58464 .61354 L
.58599 .60861 L
.58729 .60336 L
.58838 .59854 L
.58941 .5936 L
Mistroke
.5904 .58859 L
.59133 .58357 L
.5922 .57856 L
.59302 .5736 L
.59379 .56872 L
.59474 .56233 L
.59559 .55614 L
.59608 .5524 L
.59653 .54873 L
.59695 .54515 L
.59734 .54165 L
.5977 .53824 L
.59803 .5349 L
.59825 .53258 L
.59845 .5303 L
.59863 .52805 L
.5988 .52583 L
.59896 .52365 L
.5991 .52149 L
.59923 .51935 L
.5995 .51421 L
.59968 .50916 L
.59978 .50418 L
.59981 .49924 L
.59976 .49429 L
.59963 .48929 L
.59942 .48422 L
.59914 .47903 L
.59885 .47478 L
.59851 .47042 L
.59811 .46594 L
.59766 .46131 L
.59714 .45653 L
.59657 .4516 L
.59594 .4465 L
.59524 .44124 L
.59447 .43583 L
.59363 .43027 L
.59273 .4246 L
.59187 .41953 L
.59096 .41442 L
.58999 .40931 L
.58897 .40424 L
.58789 .39926 L
.58676 .39442 L
.58557 .38979 L
.58434 .38544 L
.58358 .383 L
.58281 .38071 L
.58202 .37856 L
Mistroke
.58122 .37658 L
.58041 .37477 L
.57959 .37314 L
.57875 .37172 L
.57771 .37024 L
.57638 .36885 L
.57563 .36831 L
.57488 .36794 L
.57413 .36774 L
.57338 .36771 L
.57262 .36785 L
.57187 .36815 L
.5709 .36878 L
.56993 .36966 L
.56943 .37022 L
.56893 .37084 L
.56843 .37152 L
.56793 .37226 L
.56744 .37305 L
.56738 .37316 L
.56732 .37326 L
.56726 .37337 L
.56719 .37347 L
.56719 .37348 L
.56718 .37349 L
.56717 .37351 L
.56717 .37351 L
.56717 .37352 L
.56717 .37352 L
.56716 .37353 L
.56716 .37353 L
.56554 .37663 L
.56396 .38017 L
.56243 .384 L
.56096 .38802 L
.55953 .39209 L
.55816 .39612 L
.55684 .40001 L
.5553 .40443 L
.55383 .4084 L
.55241 .41184 L
.55105 .41468 L
.54973 .41685 L
.54843 .41833 L
.54715 .41908 L
.54613 .41914 L
.54511 .41872 L
.54408 .41781 L
.54303 .4164 L
.54197 .4145 L
Mistroke
.54087 .41212 L
.53975 .40926 L
.53858 .40594 L
.53737 .4022 L
.53611 .39806 L
.5348 .39357 L
.53398 .39074 L
.53314 .38782 L
.53228 .38484 L
.5314 .3818 L
.5305 .37874 L
.52957 .37568 L
.52862 .37265 L
.52764 .36967 L
.52641 .36611 L
.52488 .36205 L
.52369 .35925 L
.52249 .35671 L
.52126 .35447 L
.52002 .35256 L
.51876 .35102 L
.5175 .34989 L
.51622 .34917 L
.51494 .34888 L
.51366 .34902 L
.51238 .34959 L
.51111 .35058 L
.50985 .35196 L
.5086 .35371 L
.50704 .3564 L
.5055 .35955 L
.50401 .36305 L
.50255 .36683 L
.50114 .37077 L
.49976 .37481 L
.49843 .37884 L
.49715 .3828 L
.49591 .38662 L
.4947 .39024 L
.49354 .39361 L
.49241 .39669 L
.49131 .39946 L
.49024 .40188 L
.48919 .40393 L
.48816 .4056 L
.487 .40703 L
.48585 .40794 L
.48472 .40831 L
.48358 .40814 L
.48243 .40745 L
Mistroke
.48128 .40623 L
.48011 .4045 L
.47891 .40229 L
.47743 .39901 L
.47589 .39514 L
.47497 .39263 L
.47402 .38997 L
.47305 .38717 L
.47205 .38428 L
.47103 .38131 L
.46998 .37831 L
.46891 .37531 L
.4678 .37235 L
.46641 .36883 L
.46498 .36552 L
.46373 .36294 L
.46246 .36063 L
.46117 .35865 L
.45986 .35705 L
.45854 .35587 L
.45721 .35514 L
.45587 .35488 L
.45454 .3551 L
.45321 .35582 L
.45189 .35702 L
.45058 .35868 L
.44929 .36078 L
.44802 .36328 L
.44634 .36722 L
.44498 .37093 L
.44366 .37494 L
.44238 .37918 L
.44115 .38358 L
.43996 .38807 L
.43882 .39259 L
.43773 .39709 L
.43668 .40152 L
.43583 .40518 L
.43501 .40874 L
.43423 .41218 L
.43347 .41549 L
.43274 .41865 L
.43204 .42166 L
.43136 .42451 L
.42998 .4301 L
.4287 .43488 L
.4275 .43887 L
.42637 .44205 L
.4253 .44446 L
.42426 .44611 L
Mistroke
.42324 .44701 L
.42224 .4472 L
.4215 .44688 L
.42074 .44619 L
.41998 .44512 L
.4192 .44368 L
.4184 .44189 L
.41756 .43974 L
.4167 .43726 L
.4158 .43446 L
.41485 .43136 L
.41387 .42799 L
.41283 .42438 L
.41197 .42139 L
.41108 .4183 L
.41015 .41516 L
.40919 .41199 L
.40819 .40885 L
.40716 .40577 L
.4061 .40281 L
.405 .40001 L
.40407 .39787 L
.40312 .39591 L
.40215 .39417 L
.40117 .39268 L
.40018 .39146 L
.39917 .39055 L
.39816 .38996 L
.39722 .38971 L
.39628 .38978 L
.39534 .39016 L
.3944 .39086 L
.39347 .39188 L
.39256 .39321 L
.39179 .39457 L
.39104 .39614 L
.3903 .39791 L
.38958 .39987 L
.38887 .40202 L
.38817 .40434 L
.38775 .40585 L
.38734 .40741 L
.38693 .40904 L
.38653 .41071 L
.38614 .41243 L
.38608 .41269 L
.38602 .41295 L
.38597 .41322 L
.38591 .41348 L
.3859 .41351 L
Mistroke
.3859 .41353 L
.38589 .41356 L
.38589 .41357 L
.38589 .41358 L
.38588 .4136 L
.38588 .41361 L
.38588 .41362 L
.38443 .42097 L
.38299 .42967 L
.38171 .4388 L
.38062 .44818 L
.37971 .45771 L
.37899 .46728 L
.37845 .47687 L
.37816 .48412 L
.37798 .49135 L
.37791 .49859 L
.37794 .50582 L
.37808 .51305 L
.37832 .5203 L
.37867 .52755 L
.37913 .53481 L
.37969 .54206 L
.38036 .54929 L
.38114 .55645 L
.38201 .5635 L
.38285 .56943 L
.38376 .57518 L
.38474 .58071 L
.38579 .58596 L
.3869 .59085 L
.38807 .59532 L
.3893 .59931 L
.39057 .60276 L
.39188 .60559 L
.39322 .60779 L
.39459 .6093 L
.39597 .61013 L
.39768 .61021 L
.39938 .60929 L
.40107 .60747 L
.40271 .60485 L
.40432 .60158 L
.40586 .59781 L
.40735 .59369 L
.40906 .58844 L
.41066 .58311 L
.41217 .57791 L
.41359 .57298 L
.41491 .56845 L
Mistroke
.41616 .5644 L
.41733 .5609 L
.41844 .55799 L
.41951 .55571 L
.42054 .55407 L
.42154 .55309 L
.42231 .55279 L
.42308 .55291 L
.42385 .55344 L
.42463 .5544 L
.42543 .5558 L
.42625 .55764 L
.4271 .55993 L
.42799 .56269 L
.42892 .56591 L
.42978 .56913 L
.43069 .5727 L
.43164 .57663 L
.43264 .58091 L
.4337 .58551 L
.43482 .5904 L
.436 .59556 L
.43725 .60091 L
.43857 .6064 L
.43976 .61114 L
.44099 .61586 L
.44228 .62048 L
.44362 .62494 L
.445 .62914 L
.44643 .63301 L
.4479 .63646 L
.4494 .63942 L
.45093 .64181 L
.45248 .64358 L
.45406 .64469 L
.45563 .64512 L
.45754 .64472 L
.45944 .64337 L
.46131 .64115 L
.46314 .63817 L
.46494 .63457 L
.46668 .63051 L
.46837 .62615 L
.47032 .62072 L
.47219 .61533 L
.47397 .61018 L
.47567 .60545 L
.4773 .60128 L
.47888 .59778 L
.4804 .59502 L
Mistroke
.48159 .5934 L
.48276 .5923 L
.48392 .59175 L
.48508 .59175 L
.48624 .59231 L
.48741 .59342 L
.4886 .59507 L
.48982 .59726 L
.49106 .59996 L
.49234 .60314 L
.49367 .60676 L
.49483 .61013 L
.49603 .61375 L
.49726 .61756 L
.49854 .62149 L
.49987 .6255 L
.50123 .6295 L
.50264 .63341 L
.50409 .63714 L
.50542 .64026 L
.50677 .64309 L
.50816 .64559 L
.50956 .64767 L
.51099 .6493 L
.51243 .65043 L
.51387 .65103 L
.51532 .65108 L
.51662 .65065 L
.51792 .64978 L
.51921 .64848 L
.52048 .64678 L
.52174 .6447 L
.52298 .64229 L
.5242 .63958 L
.52516 .63722 L
.52611 .63473 L
.52704 .63212 L
.52795 .62942 L
.52884 .62666 L
.52971 .62386 L
.53075 .62042 L
.53175 .61699 L
.53273 .61361 L
.53369 .61029 L
.53487 .60617 L
.53614 .60185 L
.53735 .59786 L
.53881 .59339 L
.54004 .58996 L
.54124 .58705 L
Mistroke
.54239 .58469 L
.54352 .58288 L
.54463 .58164 L
.54573 .58096 L
.54682 .58085 L
.54791 .58128 L
.54882 .58204 L
.54974 .58317 L
.55068 .58465 L
.55163 .58646 L
.55261 .5886 L
.55361 .59103 L
.55464 .59374 L
.5557 .5967 L
.55661 .59932 L
.55754 .60206 L
.5585 .60489 L
.55949 .60778 L
.5605 .6107 L
.56154 .6136 L
.56261 .61645 L
.56345 .61859 L
.5643 .62064 L
.56518 .6226 L
.56606 .62443 L
.56696 .62611 L
.56787 .62764 L
.56879 .62897 L
.56993 .63034 L
.57109 .63137 L
.57201 .63192 L
.57293 .63223 L
.57385 .63229 L
.57477 .6321 L
.57569 .63165 L
.57661 .63095 L
.57771 .62976 L
.5788 .62821 L
.57987 .62632 L
.58093 .6241 L
.58197 .62158 L
.58298 .61879 L
.58397 .61575 L
.58494 .6125 L
.58587 .60907 L
.58678 .60549 L
.58765 .60178 L
.5885 .59798 L
.58931 .59412 L
.59009 .59021 L
Mistroke
.59083 .58628 L
.59174 .58122 L
.5926 .57619 L
.59358 .57005 L
.59403 .56714 L
.59446 .56426 L
.59486 .56142 L
.59525 .55862 L
.59563 .55586 L
.59598 .55315 L
.59632 .55048 L
.597 .54473 L
.59761 .53919 L
.59813 .53385 L
.59858 .52869 L
.59896 .5237 L
.59926 .51885 L
.5995 .51412 L
.59967 .50947 L
.59974 .50681 L
.59978 .50416 L
.59981 .50152 L
.59981 .49889 L
.59979 .49625 L
.59975 .49361 L
.59968 .49095 L
.59952 .48646 L
.5993 .48188 L
.59902 .4772 L
.59867 .4724 L
.59825 .46744 L
.59776 .46232 L
.5972 .45701 L
.59656 .4515 L
.59584 .44579 L
.59505 .43988 L
.59417 .43378 L
.59343 .42895 L
.59264 .42404 L
.59179 .41907 L
.59089 .41406 L
.58994 .40905 L
.58894 .40409 L
.58788 .39921 L
.58677 .39447 L
.58523 .38854 L
.58394 .38416 L
.58261 .38015 L
.58124 .37661 L
.57982 .37359 L
Mistroke
.57838 .37115 L
.57691 .36934 L
.57543 .36819 L
.57393 .36772 L
.57244 .36791 L
.57095 .36874 L
.56947 .37017 L
.56801 .37214 L
.56658 .37457 L
.56518 .3774 L
.56351 .38125 L
.56191 .38541 L
.56035 .38972 L
.55886 .39404 L
.55743 .39826 L
.55606 .40227 L
.55473 .40599 L
.55346 .40933 L
.55223 .41225 L
.55125 .41431 L
.55028 .41602 L
.54933 .41737 L
.5484 .41836 L
.54747 .41896 L
.54655 .41918 L
.54563 .419 L
.54486 .41854 L
.54408 .41781 L
.54329 .41679 L
.5425 .4155 L
.54169 .41393 L
.54086 .41208 L
.53979 .40937 L
.53888 .40682 L
.53794 .40399 L
.53697 .40091 L
.53597 .39759 L
.53494 .39406 L
.53387 .39035 L
.53276 .38649 L
.53138 .38172 L
.53036 .37828 L
.52931 .37485 L
.52823 .37145 L
.52713 .36815 L
.526 .36496 L
.52484 .36195 L
.52365 .35916 L
.52244 .35662 L
.52139 .35468 L
Mistroke
.52033 .35299 L
.51925 .35157 L
.51816 .35043 L
.51707 .3496 L
.51597 .34908 L
.51487 .34887 L
.51395 .34895 L
.51303 .34925 L
.51212 .34976 L
.5112 .35049 L
.5103 .35143 L
.5094 .35255 L
.50887 .35331 L
.50834 .35413 L
.50781 .355 L
.50729 .35594 L
.50677 .35692 L
.5067 .35705 L
.50663 .35718 L
.50657 .35732 L
.5065 .35745 L
.50649 .35746 L
.50649 .35748 L
.50648 .35749 L
.50648 .3575 L
.50647 .3575 L
.50647 .35751 L
.50647 .35752 L
.50646 .35752 L
.5047 .36138 L
.50299 .36567 L
.50133 .37022 L
.49973 .37491 L
.49819 .3796 L
.4967 .38417 L
.49528 .38852 L
.49391 .39256 L
.49231 .39694 L
.49078 .40068 L
.4893 .40372 L
.48786 .40602 L
.48674 .40729 L
.48563 .40805 L
.48453 .40832 L
.48342 .40808 L
.48231 .40734 L
.48119 .40611 L
.48005 .40441 L
.47889 .40224 L
.4777 .39965 L
Mistroke
.47647 .39665 L
.47521 .3933 L
.47414 .39031 L
.47304 .38714 L
.4719 .38385 L
.47074 .38047 L
.46954 .37706 L
.4683 .37367 L
.46704 .37037 L
.46574 .36723 L
.46468 .36488 L
.46361 .3627 L
.46252 .36073 L
.46141 .359 L
.4603 .35754 L
.45917 .35638 L
.45803 .35554 L
.45699 .35506 L
.45595 .35488 L
.45491 .35499 L
.45387 .3554 L
.45283 .35611 L
.4518 .35712 L
.45057 .35869 L
.44973 .36001 L
.44889 .36151 L
.44807 .36317 L
.44725 .36498 L
.44645 .36694 L
.44566 .36902 L
.44501 .37085 L
.44436 .37275 L
.44373 .37471 L
.44311 .37673 L
.44249 .37879 L
.44174 .38141 L
.44101 .38408 L
.4403 .38678 L
.43943 .39016 L
.43859 .39354 L
.43807 .39566 L
.43757 .39777 L
.43707 .39986 L
.43659 .40193 L
.43611 .40398 L
.43606 .40418 L
.43602 .40438 L
.43597 .40458 L
.43592 .40478 L
.43592 .4048 L
Mistroke
.43592 .40482 L
.43591 .40484 L
.43591 .40486 L
.43591 .40487 L
.4359 .40488 L
.4359 .40489 L
.4359 .4049 L
.43472 .41003 L
.4336 .41491 L
.43255 .41949 L
.43155 .42374 L
.4306 .42765 L
.42999 .43007 L
.4294 .43233 L
.42883 .43443 L
.42828 .43636 L
.42774 .43813 L
.42722 .43973 L
.42679 .44094 L
.42638 .44204 L
.42597 .44303 L
.42557 .44392 L
.42517 .44469 L
.42513 .44476 L
.42509 .44483 L
.42505 .4449 L
.42502 .44497 L
.42501 .44498 L
.42501 .44499 L
.425 .44499 L
.425 .445 L
.425 .445 L
.425 .445 L
.425 .44501 L
.42499 .44501 L
.42499 .44502 L
.42498 .44503 L
.42495 .44509 L
.42491 .44516 L
.42487 .44522 L
.42483 .44529 L
.42444 .44587 L
.42406 .44634 L
.42368 .44671 L
.4233 .44698 L
.42284 .44717 L
.42238 .44722 L
.42192 .44711 L
.42146 .44686 L
.42099 .44646 L
Mistroke
.42053 .44592 L
.42005 .44523 L
.41957 .44441 L
.41908 .44344 L
.41867 .44254 L
.41825 .44153 L
.41782 .44044 L
.41739 .43926 L
.41694 .43798 L
.41636 .43622 L
.41576 .43433 L
.41514 .4323 L
.4145 .43015 L
.41384 .42788 L
.41315 .42552 L
.41204 .42162 L
.41118 .41866 L
.41029 .41564 L
.40954 .41314 L
.40877 .41064 L
.40797 .40817 L
.40715 .40575 L
.40631 .4034 L
.40546 .40114 L
.40441 .39863 L
.40334 .39634 L
.40243 .39464 L
.4015 .39315 L
.40057 .3919 L
.39962 .39091 L
.39867 .39021 L
.39771 .3898 L
.39675 .38971 L
.39527 .3902 L
.39381 .39148 L
.39269 .393 L
.39158 .39499 L
.3905 .39741 L
.38945 .40025 L
.38842 .40346 L
.38744 .40702 L
.38649 .41089 L
.38558 .41503 L
.38494 .41822 L
.38433 .42153 L
.38374 .42493 L
.38318 .42842 L
.38264 .43197 L
.38214 .43559 L
.38166 .43925 L
Mistroke
.381 .44471 L
.38041 .45022 L
.37988 .45578 L
.37941 .46135 L
.37901 .46694 L
.37867 .47252 L
.37839 .47811 L
.37818 .48369 L
.37802 .48926 L
.37793 .49483 L
.37791 .50178 L
.37798 .50874 L
.37816 .5157 L
.37843 .52267 L
.37879 .52965 L
.37926 .53664 L
.3799 .54444 L
.38046 .55029 L
.3811 .5561 L
.38164 .56063 L
.38223 .56511 L
.38286 .5695 L
.38353 .57381 L
.38424 .57799 L
.38499 .58203 L
.38578 .58591 L
.3866 .58959 L
.38746 .59305 L
.38835 .59628 L
.38927 .59922 L
.39021 .60186 L
.39118 .60417 L
.39217 .60613 L
.39317 .60772 L
.39419 .60894 L
.39564 .60999 L
.39709 .61029 L
.39822 .61002 L
.39934 .60932 L
.40046 .60823 L
.40156 .60677 L
.40264 .60498 L
.40371 .60291 L
.40475 .60059 L
.40576 .59807 L
.40665 .59569 L
.40751 .59321 L
.40835 .59068 L
.40916 .5881 L
.40995 .5855 L
Mistroke
.41072 .58292 L
.41146 .58037 L
.41219 .57786 L
.41324 .57418 L
.41425 .5707 L
.41521 .56747 L
.41612 .56451 L
.417 .56185 L
.41784 .55951 L
.41866 .5575 L
.41944 .55584 L
.42021 .55453 L
.42096 .55358 L
.4217 .55299 L
.42263 .55279 L
.42357 .5532 L
.42451 .55423 L
.42549 .55591 L
.42649 .55825 L
.42755 .56126 L
.42812 .5631 L
.42871 .56513 L
.42931 .56734 L
.42994 .56974 L
.43059 .57233 L
.43127 .57511 L
.4323 .57945 L
.43339 .58417 L
.43429 .58809 L
.43523 .5922 L
.43621 .59647 L
.43724 .60087 L
.43832 .60536 L
.43944 .6099 L
.44061 .61443 L
.44183 .6189 L
.4431 .62324 L
.4444 .62737 L
.44575 .63124 L
.44714 .63475 L
.44856 .63785 L
.45002 .64046 L
.4512 .64217 L
.45239 .6435 L
.4536 .64444 L
.45481 .64498 L
.45602 .64512 L
.45723 .64485 L
.45844 .6442 L
.46011 .64267 L
Mistroke
.46141 .641 L
.4627 .63896 L
.46397 .63659 L
.46522 .63396 L
.46643 .63112 L
.46763 .62811 L
.46879 .625 L
.46993 .62184 L
.47103 .61867 L
.47211 .61555 L
.47344 .6117 L
.47451 .60865 L
.47555 .60578 L
.47656 .60312 L
.47755 .60069 L
.47852 .59852 L
.47947 .59663 L
.4804 .59503 L
.48141 .59361 L
.48241 .59257 L
.4834 .59193 L
.48421 .5917 L
.48501 .59174 L
.48582 .59204 L
.48663 .59262 L
.48745 .59346 L
.48827 .59457 L
.48933 .59633 L
.49041 .59849 L
.49151 .60103 L
.49264 .60393 L
.49381 .60716 L
.49501 .61069 L
.49626 .61446 L
.49755 .61843 L
.49888 .62252 L
.50026 .62666 L
.50168 .63077 L
.50315 .63476 L
.50466 .63852 L
.50621 .64196 L
.5078 .64498 L
.50908 .64701 L
.51038 .64866 L
.51169 .64992 L
.51301 .65074 L
.51433 .65111 L
.51566 .65101 L
.51698 .65046 L
.5183 .64944 L
Mistroke
.5196 .648 L
.52089 .64614 L
.52217 .64392 L
.52342 .64136 L
.52465 .63851 L
.52602 .63498 L
.52735 .63121 L
.52864 .62728 L
.5299 .62325 L
.53111 .6192 L
.53228 .61517 L
.53342 .61123 L
.53451 .60743 L
.53568 .60341 L
.5368 .59965 L
.53788 .59618 L
.53893 .59303 L
.53994 .59021 L
.54093 .58775 L
.54189 .58565 L
.54283 .58393 L
.54386 .58245 L
.54487 .58145 L
.54587 .58092 L
.54688 .58085 L
.54788 .58126 L
.54889 .58211 L
.54991 .58342 L
.55095 .58515 L
.55249 .58833 L
.55409 .59228 L
.55542 .59592 L
.5568 .5999 L
.55825 .60414 L
.55975 .60855 L
.56132 .61299 L
.56295 .61733 L
.56463 .6214 L
.56606 .62443 L
.56752 .62709 L
.56901 .62927 L
.57053 .63091 L
.57205 .63194 L
.57359 .6323 L
.57512 .63196 L
.57665 .63091 L
.57816 .62916 L
.57965 .62674 L
.5811 .6237 L
.58252 .6201 L
Mistroke
.58389 .61601 L
.58522 .61151 L
.58637 .60712 L
.58748 .60252 L
.58854 .59777 L
.58955 .59291 L
.59051 .588 L
.59142 .58307 L
.59227 .57816 L
.59307 .5733 L
.59402 .56719 L
.59489 .56123 L
.59568 .55544 L
.5964 .54985 L
.59703 .54445 L
.5976 .53923 L
.5981 .5342 L
.59853 .52933 L
.59895 .52384 L
.59928 .51852 L
.59953 .51333 L
.5997 .50825 L
.59979 .50323 L
.59981 .49824 L
.59974 .49323 L
.59959 .48817 L
.59936 .48302 L
.59905 .47774 L
.59858 .47135 L
.59799 .46468 L
.59727 .4577 L
.59642 .45038 L
.59543 .4427 L
.59451 .4361 L
.59348 .42929 L
.59235 .4223 L
.59111 .41521 L
.59 .40932 L
.58881 .40348 L
.58755 .39777 L
.58622 .39228 L
.58483 .3871 L
.58336 .38235 L
.58185 .37811 L
.58028 .3745 L
.57867 .37159 L
.57703 .36946 L
.57537 .36816 L
.5737 .3677 L
.57202 .36808 L
Mistroke
.5707 .36894 L
.56938 .37027 L
.56808 .37204 L
.5668 .37417 L
.56554 .37663 L
.56431 .37935 L
.56311 .38227 L
.56193 .38533 L
.56079 .38847 L
.55968 .39164 L
.55861 .3948 L
.5573 .39865 L
.55625 .40171 L
.55524 .4046 L
.55425 .40729 L
.55329 .40976 L
.55236 .41197 L
.55144 .41392 L
.55055 .41558 L
.54957 .41707 L
.54861 .41817 L
.54783 .41877 L
.54705 .41911 L
.54628 .41917 L
.5455 .41894 L
.54473 .41844 L
.54394 .41765 L
.54289 .41617 L
.54182 .4142 L
.54092 .41222 L
.54 .40993 L
.53905 .40731 L
.53807 .4044 L
.53707 .40121 L
.53602 .39776 L
.53494 .39407 L
.53365 .38958 L
.53268 .3862 L
.53168 .38274 L
.53065 .37924 L
.52972 .37618 L
.529 .37386 L
.52827 .37157 L
.52753 .36932 L
.52677 .36711 L
.52615 .36538 L
.52552 .36369 L
.52488 .36207 L
.52424 .3605 L
.52358 .35901 L
Mistroke
.52272 .35717 L
.52184 .35548 L
.52096 .35396 L
.52006 .35261 L
.51916 .35146 L
.51825 .35051 L
.51717 .34966 L
.51608 .34911 L
.515 .34888 L
.51391 .34896 L
.51282 .34935 L
.51174 .35004 L
.51061 .35108 L
.50948 .35243 L
.50837 .35407 L
.50727 .35596 L
.50619 .35808 L
.50512 .3604 L
.50407 .36289 L
.5028 .36617 L
.50155 .36959 L
.50034 .3731 L
.49916 .37663 L
.49801 .38014 L
.4969 .38358 L
.49581 .38689 L
.49476 .39006 L
.4935 .39372 L
.49227 .39705 L
.49108 .39999 L
.48993 .40252 L
.4888 .40461 L
.48769 .40624 L
.4866 .40741 L
.48552 .4081 L
.48445 .40832 L
.48337 .40806 L
.48229 .40732 L
.4809 .40572 L
.47947 .40338 L
.47801 .40036 L
.47679 .39745 L
.47553 .39417 L
.47423 .39057 L
.47289 .3867 L
.47176 .38344 L
.47061 .3801 L
.46942 .37673 L
.4682 .37339 L
.46694 .37014 L
Mistroke
.46566 .36705 L
.46435 .36417 L
.46252 .36073 L
.4612 .35869 L
.45986 .35705 L
.45874 .35602 L
.45761 .35531 L
.45649 .35494 L
.45536 .35491 L
.45423 .35523 L
.4531 .3559 L
.45199 .35691 L
.45031 .35908 L
.449 .36131 L
.44771 .36394 L
.44645 .36694 L
.44522 .37024 L
.44402 .3738 L
.44285 .37757 L
.44172 .38148 L
.44063 .3855 L
.43958 .38957 L
.43856 .39365 L
.43734 .39871 L
.43638 .4028 L
.43546 .40678 L
.43458 .41063 L
.43374 .41433 L
.43293 .41785 L
.43215 .4212 L
.4314 .42435 L
.43048 .42813 L
.42978 .43091 L
.4291 .43346 L
.42844 .43579 L
.42781 .43789 L
.4272 .43978 L
.42661 .44144 L
.42591 .44318 L
.42522 .4446 L
.42455 .44571 L
.4239 .44651 L
.42325 .44701 L
.42261 .44721 L
.42196 .44713 L
.42113 .4466 L
.42029 .4456 L
.41944 .44415 L
.41855 .44226 L
.41763 .43993 L
Mistroke
.41668 .43719 L
.41567 .43406 L
.41504 .43199 L
.4144 .42981 L
.41373 .42751 L
.41304 .42511 L
.41233 .42263 L
.41159 .42007 L
.41075 .41718 L
.40988 .41425 L
.40898 .41131 L
.40898 .41131 L
.40897 .4113 L
.40897 .41129 L
.40897 .41129 L
.40897 .41128 L
.40897 .41127 L
.40896 .41126 L
.40896 .41125 L
.40893 .41114 L
.40889 .41104 L
.40886 .41093 L
.40882 .41082 L
.40849 .40976 L
.40814 .4087 L
.4078 .40765 L
.40745 .4066 L
.40709 .40557 L
.40645 .40376 L
.40579 .40199 L
.40512 .4003 L
.40444 .39869 L
.40374 .39717 L
.40304 .39576 L
.40206 .39401 L
.40106 .39252 L
.40005 .39132 L
.39903 .39044 L
.398 .38989 L
.39697 .3897 L
.39594 .38988 L
.39471 .39059 L
.3935 .39184 L
.39231 .39363 L
.39114 .39593 L
.38999 .39872 L
.38888 .40196 L
.38781 .40562 L
.38678 .40964 L
.3858 .41399 L
Mistroke
.38487 .41861 L
.38399 .42346 L
.38317 .4285 L
.3824 .43369 L
.38169 .43899 L
.38104 .44438 L
.38045 .44983 L
.37992 .45531 L
.3793 .46291 L
.37878 .47052 L
.37839 .47812 L
.37811 .48572 L
.37795 .4933 L
.37791 .50088 L
.37798 .50846 L
.37817 .51604 L
.37847 .52364 L
.37889 .53125 L
.37943 .53886 L
.38009 .54644 L
.38086 .55398 L
.38174 .56141 L
.38274 .56868 L
.38385 .57571 L
.38506 .58238 L
.38637 .58861 L
.38778 .59426 L
.38894 .59821 L
.39014 .60168 L
.39139 .60462 L
.39267 .60697 L
.39397 .6087 L
.39529 .60981 L
.39661 .61028 L
.39794 .61013 L
.39927 .60938 L
.40058 .60808 L
.40187 .60628 L
.40314 .60404 L
.40438 .60143 L
.40559 .59852 L
.4069 .59497 L
.40817 .59123 L
.40938 .58739 L
.41054 .58353 L
.41165 .57973 L
.41271 .57605 L
.41372 .57253 L
.41468 .56924 L
.41584 .56539 L
Mistroke
.41675 .5626 L
.41761 .56013 L
.41844 .558 L
.41925 .55622 L
.42003 .5548 L
.42079 .55376 L
.42155 .55308 L
.42229 .55279 L
.42326 .553 L
.42424 .55387 L
.42524 .55544 L
.42628 .55772 L
.42737 .56072 L
.42851 .56446 L
.42974 .56895 L
.43105 .57419 L
.43204 .57832 L
.43308 .5828 L
.43418 .58761 L
.43535 .5927 L
.43658 .59804 L
.43788 .60355 L
.43926 .60916 L
.44071 .61478 L
.44223 .62029 L
.44382 .62557 L
.44547 .63047 L
.44688 .63414 L
.44833 .63737 L
.44981 .64012 L
.45131 .64231 L
.45283 .64389 L
.45437 .64483 L
.45592 .64512 L
.45746 .64476 L
.459 .64377 L
.46052 .64219 L
.46202 .64008 L
.4635 .63751 L
.46495 .63455 L
.46636 .63129 L
.46806 .62698 L
.46934 .62349 L
.47059 .61995 L
.4718 .61644 L
.47298 .61302 L
.47412 .60974 L
.47523 .60664 L
.47631 .60376 L
.47736 .60114 L
Mistroke
.47874 .59807 L
.48007 .59555 L
.48138 .59364 L
.48267 .59237 L
.48394 .59175 L
.48521 .59178 L
.48648 .59249 L
.48777 .59385 L
.48908 .59587 L
.49042 .59851 L
.4918 .60175 L
.49323 .60554 L
.49472 .60982 L
.49627 .6145 L
.49789 .61948 L
.49958 .62463 L
.50133 .6298 L
.50316 .6348 L
.50506 .63945 L
.50655 .64265 L
.50807 .64544 L
.50962 .64775 L
.51119 .6495 L
.51278 .65063 L
.51438 .65111 L
.51597 .65092 L
.51757 .65006 L
.51914 .64856 L
.5207 .64644 L
.52224 .64378 L
.52374 .64064 L
.52521 .6371 L
.52664 .63326 L
.5282 .62864 L
.52945 .6247 L
.53066 .62071 L
.53183 .61673 L
.53296 .61281 L
.53406 .609 L
.53511 .60534 L
.53613 .60187 L
.53712 .5986 L
.5384 .59461 L
.53962 .59108 L
.5408 .58805 L
.54195 .58553 L
.54306 .58355 L
.54416 .58211 L
.54524 .5812 L
.5463 .58083 L
Mistroke
.54759 .58109 L
.54888 .58211 L
.5502 .58385 L
.55154 .58629 L
.55294 .58938 L
.55409 .59228 L
.55528 .59552 L
.55651 .59905 L
.5578 .60281 L
.55887 .60597 L
.55997 .60918 L
.56111 .61241 L
.56228 .61559 L
.56348 .61866 L
.56471 .62157 L
.56597 .62425 L
.56777 .62749 L
.56777 .62749 L
.56778 .6275 L
.56778 .6275 L
.56778 .6275 L
.56779 .62751 L
.56779 .62752 L
.5678 .62752 L
.5678 .62753 L
.56785 .62761 L
.5679 .62769 L
.56795 .62777 L
.568 .62785 L
.5685 .62858 L
.569 .62925 L
.5695 .62986 L
.57 .63041 L
.5705 .63089 L
.5714 .63158 L
.5723 .63204 L
.57304 .63225 L
.57378 .63229 L
.57452 .63218 L
.57526 .6319 L
.57599 .63145 L
.57672 .63084 L
.57791 .6295 L
.57909 .62773 L
.58003 .626 L
.58097 .62402 L
.58188 .6218 L
.58278 .61937 L
.58366 .61674 L
.58452 .61394 L
Mistroke
.58536 .61099 L
.58641 .60698 L
.58742 .6028 L
.58839 .59849 L
.58931 .59409 L
.5902 .58963 L
.59104 .58515 L
.59184 .58068 L
.59259 .57623 L
.59354 .57032 L
.59442 .56453 L
.59522 .55889 L
.59595 .55342 L
.59661 .54812 L
.5972 .543 L
.59772 .53805 L
.59818 .53326 L
.59859 .52862 L
.59893 .52411 L
.59921 .51972 L
.59948 .51451 L
.59967 .50941 L
.59978 .50437 L
.59981 .49938 L
.59976 .49437 L
.59963 .48932 L
.59942 .4842 L
.59913 .47895 L
.59893 .47596 L
.59871 .47292 L
.59846 .46981 L
.59818 .46664 L
.59787 .46341 L
.59753 .4601 L
.59716 .45671 L
.59648 .45088 L
.59572 .44482 L
.59486 .43853 L
.59391 .43204 L
.59286 .42537 L
.59171 .41858 L
.59046 .41173 L
.58911 .40491 L
.58766 .39824 L
.58611 .39185 L
.58448 .38591 L
.58313 .38164 L
.58173 .37782 L
.5803 .37453 L
.57882 .37183 L
Mistroke
.57733 .36978 L
.57581 .36842 L
.57428 .36777 L
.57274 .36782 L
.57121 .36855 L
.5697 .36991 L
.5682 .37186 L
.56673 .3743 L
.56529 .37717 L
.56388 .38036 L
.5622 .38463 L
.56097 .38797 L
.55978 .39136 L
.55863 .39473 L
.55751 .39803 L
.55643 .4012 L
.55538 .4042 L
.55436 .40699 L
.55337 .40955 L
.55211 .41252 L
.55089 .41498 L
.54969 .4169 L
.54852 .41825 L
.54737 .41901 L
.54622 .41916 L
.54507 .41869 L
.5439 .4176 L
.54253 .41556 L
.54111 .41267 L
.53964 .40898 L
.53811 .4045 L
.53649 .39932 L
.53516 .39482 L
.53377 .38999 L
.53231 .38493 L
.53079 .37973 L
.5292 .3745 L
.52755 .36938 L
.52583 .36452 L
.52405 .36006 L
.5226 .35693 L
.52112 .35423 L
.51962 .35203 L
.5181 .35037 L
.51656 .34932 L
.51502 .34888 L
.51348 .34908 L
.51194 .34989 L
.51041 .3513 L
.5089 .35326 L
Mistroke
.50741 .35571 L
.50595 .35859 L
.50452 .36181 L
.50312 .36531 L
.50161 .36941 L
.50016 .37364 L
.49874 .37789 L
.49738 .38208 L
.49606 .38613 L
.49479 .38997 L
.49356 .39354 L
.49237 .39678 L
.49084 .40054 L
.48965 .40306 L
.48849 .40511 L
.48735 .40666 L
.48622 .40771 L
.48511 .40824 L
.48399 .40827 L
.48288 .40778 L
.48175 .40679 L
.48035 .4049 L
.47892 .4023 L
.47744 .39904 L
.47624 .39604 L
.475 .39271 L
.47372 .38911 L
.47239 .38528 L
.47127 .38201 L
.47011 .37868 L
.46892 .37536 L
.4677 .37208 L
.46645 .36892 L
.46517 .36594 L
.46386 .36319 L
.46226 .3603 L
.46099 .35841 L
.45971 .3569 L
.45841 .35578 L
.45711 .3551 L
.4558 .35488 L
.4545 .35512 L
.45319 .35583 L
.4519 .357 L
.45062 .35862 L
.44935 .36066 L
.44811 .36308 L
.44689 .36585 L
.44569 .36893 L
.44438 .37269 L
Mistroke
.44311 .3767 L
.44189 .38091 L
.4407 .38524 L
.43956 .38964 L
.43846 .39404 L
.43741 .39841 L
.43641 .40271 L
.43534 .40733 L
.43432 .41177 L
.43335 .41599 L
.43243 .41998 L
.43156 .42371 L
.43072 .42717 L
.42992 .43036 L
.42915 .43326 L
.42834 .43616 L
.42756 .4387 L
.42681 .4409 L
.42608 .44277 L
.42538 .4443 L
.42469 .4455 L
.42402 .44638 L
.42335 .44695 L
.42304 .44711 L
.42272 .4472 L
.42241 .44722 L
.42209 .44717 L
.42178 .44705 L
.42146 .44686 L
.42115 .44661 L
.42066 .44609 L
.42018 .44543 L
.41969 .44462 L
.41919 .44365 L
.41868 .44255 L
.41816 .4413 L
.41722 .43878 L
.41624 .43586 L
.41541 .43319 L
.41454 .43028 L
.41363 .42715 L
.41268 .42385 L
.41168 .42039 L
.41064 .41682 L
.40956 .4132 L
.40843 .40958 L
.40725 .40604 L
.40603 .40264 L
.40477 .39947 L
.40347 .39661 L
Mistroke
.40213 .39414 L
.401 .39245 L
.39985 .39113 L
.39869 .39022 L
.39753 .38976 L
.39636 .38976 L
.39519 .39025 L
.39403 .39123 L
.39289 .39269 L
.39176 .39464 L
.39065 .39704 L
.38959 .39984 L
.38861 .40284 L
.38766 .40617 L
Mfstroke
.02 w
.425 .445 Mdot
.5 Mabswid
.38861 .40284 m
.38766 .40617 L
s
% Start of user PostScript
-0.89112627 -0.77724601 -0.89870904 -0.75062648 MAarrowhead1
% End of user PostScript
1 0 .757 r
.36653 .56218 m
.36695 .56373 L
.36737 .56537 L
.36824 .56891 L
.36915 .57286 L
.37012 .57719 L
.37115 .58193 L
.37224 .58704 L
.3734 .59251 L
.37432 .59685 L
.37529 .60135 L
.3763 .60598 L
.37735 .61072 L
.37846 .61553 L
.3796 .62036 L
.3808 .62515 L
.38204 .62986 L
.38368 .63557 L
.38509 .64005 L
.38654 .64417 L
.38804 .64788 L
.38957 .65108 L
.39113 .65373 L
.39272 .65576 L
.39432 .65716 L
.39593 .65789 L
.39755 .65797 L
.39917 .65743 L
.40077 .65632 L
.40237 .65469 L
.40394 .65262 L
.40549 .6502 L
.40744 .64674 L
.40934 .64305 L
.41094 .63984 L
.41251 .63672 L
.41404 .6338 L
.41555 .63117 L
.41702 .62893 L
.41847 .62712 L
.4199 .62582 L
.42133 .62505 L
.42274 .62487 L
.424 .62521 L
.42526 .62602 L
.42653 .62732 L
.42782 .62909 L
.42913 .63133 L
.43046 .63401 L
.43183 .63711 L
Mistroke
.43322 .64058 L
.43447 .64388 L
.43575 .64739 L
.43706 .65106 L
.4384 .65483 L
.43977 .65865 L
.44118 .66244 L
.44262 .66614 L
.4441 .66968 L
.4454 .67256 L
.44673 .67521 L
.44808 .67758 L
.44945 .67963 L
.45083 .68132 L
.45222 .68261 L
.45362 .6835 L
.45503 .68396 L
.45644 .68398 L
.45784 .68359 L
.45924 .68279 L
.46064 .68161 L
.46202 .68008 L
.46375 .6777 L
.46546 .67493 L
.46715 .67186 L
.4688 .6686 L
.47042 .66527 L
.472 .66195 L
.47356 .65876 L
.47508 .65577 L
.47658 .65306 L
.47805 .65071 L
.4795 .64876 L
.48094 .64725 L
.48236 .64622 L
.48378 .6457 L
.48497 .64566 L
.48617 .646 L
.48737 .6467 L
.48858 .64777 L
.48981 .64919 L
.49104 .65095 L
.49229 .65301 L
.49381 .65586 L
.49537 .65904 L
.49668 .66187 L
.498 .66482 L
.49936 .66785 L
.50074 .6709 L
.50214 .6739 L
Mistroke
.50356 .67679 L
.50501 .67951 L
.50649 .68198 L
.50797 .68415 L
.50948 .68595 L
.51141 .68765 L
.51268 .68836 L
.51396 .68873 L
.51524 .68877 L
.51651 .68846 L
.51779 .68781 L
.51906 .68682 L
.52032 .68553 L
.52183 .68357 L
.52332 .68123 L
.52538 .67742 L
.52688 .67429 L
.52835 .67098 L
.52979 .66757 L
.53121 .66412 L
.53259 .6607 L
.53394 .65739 L
.53527 .65423 L
.53684 .6507 L
.53837 .64755 L
.53987 .64483 L
.54166 .6422 L
.54308 .64065 L
.54448 .63961 L
.54587 .63911 L
.54726 .63913 L
.54865 .63967 L
.55005 .6407 L
.55147 .64221 L
.5529 .64414 L
.55435 .64645 L
.55583 .64908 L
.55705 .65142 L
.55829 .65388 L
.55956 .65641 L
.56084 .65897 L
.56215 .6615 L
.56347 .66395 L
.56482 .66625 L
.56618 .66836 L
.56756 .6702 L
.56895 .67174 L
.5708 .67321 L
.5721 .67383 L
.57341 .67408 L
Mistroke
.57472 .67395 L
.57603 .67343 L
.57733 .67251 L
.57862 .67121 L
.5799 .66955 L
.58151 .66693 L
.5831 .66381 L
.58493 .65959 L
.58671 .6549 L
.58843 .64988 L
.5901 .64468 L
.5917 .63941 L
.59325 .63421 L
.59474 .62916 L
.59618 .62437 L
.59784 .619 L
.59944 .61421 L
.60097 .61005 L
.60246 .60658 L
.6039 .60382 L
.6053 .60179 L
.60669 .60049 L
.60806 .59989 L
.60943 .59998 L
.6108 .60074 L
.61219 .6021 L
.6133 .60358 L
.61442 .60537 L
.61557 .60745 L
.61673 .60976 L
.61793 .61227 L
.61915 .61491 L
.6204 .61764 L
.62168 .62037 L
.62346 .62394 L
.62493 .62662 L
.62644 .629 L
.62797 .63098 L
.62952 .63246 L
.63109 .63336 L
.63266 .63362 L
.63423 .63318 L
.63579 .63201 L
.63734 .63011 L
.63885 .6275 L
.64034 .62422 L
.64178 .62032 L
.64317 .61587 L
.6445 .61094 L
.64611 .60412 L
Mistroke
.64762 .59683 L
.64901 .58921 L
.65029 .58142 L
.65145 .57355 L
.65249 .56568 L
.65342 .55789 L
.65423 .5502 L
.65492 .54265 L
.65551 .53523 L
.65598 .52795 L
.65634 .52077 L
.6566 .51369 L
.65675 .50667 L
.6568 .49968 L
.65676 .49368 L
.65664 .48766 L
.65644 .48161 L
.65617 .47549 L
.65581 .46929 L
.65538 .46301 L
.65486 .45663 L
.65426 .45015 L
.65358 .44358 L
.65281 .43692 L
.65196 .43019 L
.65126 .42512 L
.65052 .42005 L
.64972 .415 L
.64888 .41001 L
.64798 .40509 L
.64705 .40029 L
.64606 .39565 L
.64503 .3912 L
.64421 .38794 L
.64337 .38483 L
.6425 .38191 L
.64161 .3792 L
.6407 .3767 L
.63977 .37445 L
.63883 .37246 L
.63766 .37038 L
.63646 .36872 L
.63572 .36792 L
.63498 .36729 L
.63424 .36683 L
.63349 .36653 L
.63275 .36639 L
.632 .36641 L
.63107 .36664 L
.63015 .36711 L
Mistroke
.62963 .36746 L
.62912 .36787 L
.62861 .36835 L
.6281 .36888 L
.62759 .36946 L
.62754 .36954 L
.62748 .36961 L
.62742 .36968 L
.62736 .36976 L
.62735 .36976 L
.62735 .36977 L
.62734 .36978 L
.62734 .36978 L
.62733 .36979 L
.62733 .36979 L
.62733 .36979 L
.62733 .3698 L
.62558 .37231 L
.62388 .37528 L
.62197 .37903 L
.62013 .38296 L
.61835 .38683 L
.61663 .39046 L
.61495 .39369 L
.61333 .39637 L
.61204 .39807 L
.61077 .39929 L
.60951 .39999 L
.60825 .40014 L
.607 .39971 L
.60573 .39869 L
.60445 .39706 L
.60314 .39482 L
.6018 .39197 L
.60043 .38853 L
.599 .38452 L
.5977 .38056 L
.59636 .37624 L
.59497 .3716 L
.59352 .36671 L
.59202 .36164 L
.59046 .3565 L
.58885 .3514 L
.58718 .34643 L
.58546 .34175 L
.58368 .33747 L
.58187 .33372 L
.58001 .33061 L
.57846 .32861 L
.57689 .32714 L
Mistroke
.57531 .32624 L
.57373 .32591 L
.57215 .32615 L
.57057 .32693 L
.569 .32821 L
.56744 .32994 L
.56591 .33204 L
.564 .33511 L
.56214 .3385 L
.56032 .34207 L
.55853 .34564 L
.55679 .34908 L
.55509 .35227 L
.55342 .35507 L
.55177 .35741 L
.55016 .3592 L
.54846 .36043 L
.54678 .36093 L
.5451 .36068 L
.54342 .35965 L
.54171 .35786 L
.53998 .35535 L
.53822 .35215 L
.53641 .34836 L
.53455 .34408 L
.53287 .33999 L
.53114 .33573 L
.52937 .33142 L
.52755 .32719 L
.52569 .32319 L
.52378 .31957 L
.52184 .31645 L
.51987 .31398 L
.51788 .31226 L
.51588 .31134 L
.51387 .31128 L
.51186 .31207 L
.50986 .31365 L
.50789 .31597 L
.50594 .31889 L
.50403 .32231 L
.50216 .32606 L
.50033 .33 L
.49804 .3351 L
.49582 .33999 L
.49391 .34396 L
.49203 .34743 L
.4902 .35028 L
.48839 .35242 L
.48661 .35379 L
Mistroke
.48484 .35435 L
.48307 .3541 L
.48129 .35305 L
.47974 .35152 L
.47816 .34945 L
.47656 .3469 L
.47493 .34394 L
.47327 .34065 L
.47157 .33714 L
.46983 .33352 L
.46806 .32991 L
.46625 .32646 L
.4644 .3233 L
.46252 .32056 L
.46062 .31837 L
.45869 .31685 L
.45676 .31607 L
.45482 .31609 L
.45288 .31692 L
.45096 .31855 L
.44906 .32092 L
.44744 .32351 L
.44585 .32653 L
.44428 .3299 L
.44275 .33354 L
.44125 .33737 L
.43979 .3413 L
.43837 .34526 L
.43698 .34917 L
.43562 .35296 L
.4343 .35658 L
.43301 .35996 L
.43158 .36348 L
.42989 .36718 L
.42779 .37096 L
.42632 .37294 L
.42486 .37429 L
.42342 .37501 L
.42199 .3751 L
.42055 .3746 L
.4191 .37351 L
.41764 .37189 L
.41615 .36979 L
.41524 .36831 L
.41431 .36669 L
.41337 .36495 L
.41243 .36311 L
.41146 .36121 L
.41049 .35925 L
.4095 .35726 L
Mistroke
.40849 .35528 L
.40748 .35334 L
.40622 .35105 L
.40495 .34891 L
.40333 .34654 L
.40135 .34422 L
.39984 .34297 L
.39833 .34221 L
.3968 .34198 L
.39528 .34233 L
.39377 .34325 L
.39226 .34475 L
.39077 .34682 L
.38931 .34942 L
.38787 .3525 L
.38647 .35602 L
.3851 .35992 L
.38377 .36411 L
.38248 .36855 L
.38124 .37316 L
.38066 .3754 L
.38009 .37765 L
.37954 .37992 L
.37899 .38219 L
.37846 .38447 L
.37793 .38674 L
.37742 .38899 L
.37716 .39012 L
.37691 .39124 L
.37667 .39236 L
.37642 .39347 L
.37618 .39457 L
.37594 .39567 L
.37477 .40106 L
.37367 .40624 L
.37231 .41266 L
.37104 .41859 L
.36986 .42401 L
.36875 .42889 L
.36772 .43323 L
.36674 .43705 L
.36582 .44034 L
.36494 .44313 L
.36411 .44544 L
.36313 .44761 L
.36219 .44912 L
.36127 .45 L
.36036 .45027 L
.35953 .45001 L
.3587 .44928 L
Mistroke
.35784 .44811 L
.35697 .4465 L
.35607 .44449 L
.35512 .44208 L
.35414 .43933 L
.35311 .43625 L
.3522 .43346 L
.35125 .4305 L
.35026 .42744 L
.34922 .42432 L
.34814 .4212 L
.34702 .41815 L
.34585 .41524 L
.34465 .41255 L
.34341 .41017 L
.34214 .40817 L
.34085 .40665 L
.33954 .40568 L
.33822 .40532 L
.33689 .40563 L
.33538 .40685 L
.33389 .40904 L
.33244 .41218 L
.33105 .41623 L
.32973 .42111 L
.3285 .42675 L
.32737 .43303 L
.32634 .43987 L
.32543 .44717 L
.32463 .45482 L
.32408 .46126 L
.32361 .46785 L
.32323 .47456 L
.32294 .48134 L
.32274 .48819 L
.32263 .49506 L
.32261 .50195 L
.32268 .50884 L
.32279 .51391 L
.32295 .51895 L
.32316 .52396 L
.32342 .52894 L
.32372 .53385 L
.32408 .53871 L
.32448 .54348 L
.32492 .54814 L
.32541 .55269 L
.32594 .55711 L
.32652 .56138 L
.32713 .56549 L
Mistroke
.32778 .5694 L
.32863 .5739 L
.32912 .57623 L
.32963 .57844 L
.33015 .58054 L
.33068 .5825 L
.33122 .58433 L
.33178 .58602 L
.33277 .58862 L
.33378 .59076 L
.33482 .59244 L
.33587 .59365 L
.33693 .59439 L
.338 .59468 L
.33907 .59452 L
.34013 .59395 L
.34119 .593 L
.34224 .5917 L
.34326 .59009 L
.34427 .58823 L
.34526 .58614 L
.34606 .58426 L
.34685 .58229 L
.34762 .58025 L
.34836 .57816 L
.34909 .57605 L
.3498 .57393 L
.35064 .57139 L
.35144 .5689 L
.35252 .56554 L
.35335 .56301 L
.35415 .56064 L
.35492 .55847 L
.35566 .55651 L
.35638 .55478 L
.35707 .55329 L
.35775 .55204 L
.35795 .55173 L
.35814 .55144 L
.35833 .55117 L
.35852 .55092 L
.35871 .5507 L
.3589 .5505 L
.35909 .55032 L
.35928 .55017 L
.35998 .54979 L
.36069 .54976 L
.3614 .55009 L
.36212 .55079 L
.36284 .55186 L
Mistroke
.36359 .55334 L
.36436 .55522 L
.36516 .55752 L
.366 .56026 L
.36673 .56292 L
.3675 .56591 L
.36831 .56923 L
.36916 .57289 L
.37006 .57689 L
.371 .58123 L
.372 .5859 L
.37306 .59088 L
.37417 .59614 L
.37536 .60166 L
.37661 .60738 L
.37793 .61324 L
.37913 .6184 L
.38039 .62355 L
.38171 .62863 L
.38308 .63354 L
.38449 .63822 L
.38596 .64257 L
.38746 .64652 L
.38901 .64998 L
.39059 .65288 L
.3922 .65517 L
.39382 .6568 L
.39546 .65775 L
.3975 .65798 L
.39953 .65723 L
.40154 .65559 L
.40353 .6532 L
.40548 .65021 L
.40739 .64682 L
.40926 .64321 L
.41108 .63956 L
.41286 .63605 L
.41459 .63282 L
.41628 .63001 L
.41794 .62774 L
.41936 .62625 L
.42077 .62528 L
.42218 .62487 L
.42358 .62504 L
.42499 .62581 L
.42641 .62717 L
.42785 .62913 L
.42931 .63168 L
.43053 .63416 L
.43177 .63698 L
Mistroke
.43304 .64012 L
.43434 .64353 L
.43567 .64717 L
.43703 .651 L
.43843 .65493 L
.43987 .65892 L
.44135 .66287 L
.44285 .66672 L
.4444 .67037 L
.44574 .67325 L
.4471 .67589 L
.44848 .67822 L
.44988 .6802 L
.45129 .68179 L
.45271 .68297 L
.45414 .68372 L
.45558 .68402 L
.45701 .68387 L
.45844 .68329 L
.45987 .6823 L
.46129 .68093 L
.46269 .67921 L
.46438 .67674 L
.46604 .67392 L
.46767 .67085 L
.46927 .66764 L
.47084 .66438 L
.47238 .66117 L
.47389 .65809 L
.47537 .65522 L
.47683 .65264 L
.47826 .6504 L
.48004 .64814 L
.48179 .64658 L
.48302 .64592 L
.48425 .64564 L
.48548 .64576 L
.48672 .64627 L
.48795 .64717 L
.4892 .64845 L
.49046 .65009 L
.49174 .65207 L
.49303 .65436 L
.49435 .65692 L
.49599 .66037 L
.49741 .66349 L
.49886 .66673 L
.50033 .67001 L
.50184 .67327 L
.50337 .67641 L
Mistroke
.50493 .67936 L
.50652 .68203 L
.50812 .68434 L
.50975 .68623 L
.51139 .68763 L
.51303 .6885 L
.51469 .6888 L
.51634 .68852 L
.51799 .68767 L
.51963 .68627 L
.52126 .68436 L
.52286 .68199 L
.52477 .67863 L
.52663 .67484 L
.52845 .67075 L
.53023 .66651 L
.53196 .66225 L
.53365 .6581 L
.53529 .65417 L
.5369 .65056 L
.53879 .64674 L
.54064 .64362 L
.54246 .64127 L
.54425 .63975 L
.54602 .63909 L
.54779 .63928 L
.54957 .6403 L
.55089 .64154 L
.55221 .64316 L
.55355 .64514 L
.55492 .64743 L
.5563 .64998 L
.55771 .65272 L
.55915 .65559 L
.56061 .65851 L
.56251 .66219 L
.56409 .66504 L
.56571 .66766 L
.56734 .66993 L
.569 .67178 L
.57067 .67313 L
.57235 .67391 L
.57404 .67407 L
.57572 .67358 L
.5774 .67245 L
.57906 .67068 L
.58071 .66831 L
.58233 .6654 L
.58391 .66201 L
.58546 .65823 L
Mistroke
.58731 .6532 L
.58909 .64787 L
.5908 .64239 L
.59245 .63691 L
.59404 .63154 L
.59556 .6264 L
.59703 .62159 L
.59844 .61716 L
.5998 .61318 L
.60112 .60969 L
.6024 .60671 L
.60364 .60426 L
.60486 .60235 L
.60607 .60099 L
.60709 .60024 L
.60812 .59988 L
.60914 .59991 L
.61016 .60031 L
.61119 .60106 L
.61223 .60215 L
.61328 .60355 L
.61434 .60525 L
.61543 .60719 L
.61654 .60936 L
.61795 .61231 L
.61907 .61474 L
.62022 .61723 L
.62139 .61975 L
.62259 .62222 L
.62381 .6246 L
.62505 .62682 L
.62632 .62882 L
.6276 .63054 L
.6289 .63193 L
.63021 .63293 L
.63153 .6335 L
.63285 .6336 L
.63417 .63321 L
.63548 .6323 L
.63679 .63087 L
.63807 .62894 L
.63934 .62651 L
.64057 .62362 L
.64178 .6203 L
.64295 .61659 L
.64409 .61254 L
.64518 .60819 L
.64623 .6036 L
.64723 .5988 L
.64818 .59385 L
Mistroke
.64926 .58775 L
.65027 .58154 L
.6512 .57528 L
.65206 .56902 L
.65285 .56279 L
.65373 .55505 L
.65445 .5479 L
.65507 .54087 L
.6556 .53396 L
.65602 .52717 L
.65636 .52046 L
.6566 .51384 L
.65674 .50727 L
.6568 .50074 L
.65677 .4942 L
.65664 .48764 L
.65645 .48191 L
.6562 .47612 L
.65587 .47027 L
.65548 .46434 L
.65501 .45833 L
.65446 .45222 L
.65384 .44603 L
.65315 .43975 L
.65252 .4345 L
.65183 .42922 L
.65109 .42392 L
.6503 .41863 L
.64945 .41337 L
.64855 .40818 L
.6476 .40309 L
.6466 .39814 L
.64555 .39339 L
.64445 .38887 L
.64331 .38464 L
.64213 .38075 L
.64091 .37726 L
.63966 .37419 L
.63838 .3716 L
.63707 .36951 L
.63589 .36809 L
.6347 .3671 L
.6335 .36653 L
.63229 .36638 L
.63109 .36664 L
.62989 .36727 L
.6287 .36826 L
.62722 .36993 L
.62577 .37201 L
.62434 .37442 L
Mistroke
.62294 .37707 L
.62158 .37986 L
.62024 .38272 L
.61893 .38556 L
.61766 .3883 L
.61642 .39088 L
.6152 .39323 L
.61401 .3953 L
.61285 .39706 L
.6117 .39845 L
.61056 .39944 L
.60943 .40002 L
.60831 .40014 L
.60718 .39981 L
.60605 .399 L
.60491 .3977 L
.60399 .39633 L
.60306 .39465 L
.60211 .39267 L
.60115 .39039 L
.60016 .38782 L
.59915 .38497 L
.59812 .38185 L
.59705 .37848 L
.59595 .3749 L
.59482 .37111 L
.59329 .36593 L
.59197 .36148 L
.5906 .35696 L
.58919 .35247 L
.58774 .34806 L
.58625 .34384 L
.58471 .33988 L
.58314 .33628 L
.58154 .33311 L
.5799 .33045 L
.57825 .32837 L
.57657 .32691 L
.57489 .3261 L
.5732 .32593 L
.57151 .3264 L
.57006 .32729 L
.56862 .3286 L
.56719 .33026 L
.56577 .33224 L
.56437 .33448 L
.563 .33691 L
.56164 .33947 L
.5603 .34209 L
.55838 .34595 L
Mistroke
.55651 .34963 L
.55467 .35299 L
.55288 .35589 L
.55112 .3582 L
.54938 .35985 L
.54766 .36077 L
.54595 .3609 L
.54423 .36024 L
.54274 .35902 L
.54123 .35723 L
.5397 .35487 L
.53814 .352 L
.53655 .34867 L
.53492 .34495 L
.53325 .34092 L
.53154 .3367 L
.52978 .33239 L
.52797 .32814 L
.52612 .32409 L
.52423 .32037 L
.5223 .31713 L
.52034 .31451 L
.51836 .3126 L
.51636 .31149 L
.51435 .31122 L
.51235 .3118 L
.51035 .31319 L
.50838 .31533 L
.50643 .31811 L
.50451 .32141 L
.50263 .32508 L
.50079 .32898 L
.49853 .33401 L
.49633 .3389 L
.49461 .34255 L
.49293 .34584 L
.49128 .34867 L
.48966 .35099 L
.48806 .35273 L
.48648 .35385 L
.48491 .35434 L
.48334 .35419 L
.48144 .35317 L
.47978 .35157 L
.4781 .34937 L
.47639 .34662 L
.47465 .34341 L
.47287 .33985 L
.47105 .33606 L
.46919 .33219 L
Mistroke
.46728 .3284 L
.46533 .32484 L
.46334 .32169 L
.46132 .31911 L
.45928 .31724 L
.45722 .31618 L
.45515 .31603 L
.45308 .31679 L
.45103 .31847 L
.44901 .32099 L
.44701 .32427 L
.44506 .32818 L
.44315 .33256 L
.44129 .33726 L
.43901 .34345 L
.43682 .34961 L
.43471 .35546 L
.43268 .36078 L
.43073 .36541 L
.42883 .36921 L
.42699 .37211 L
.4257 .37359 L
.42442 .37458 L
.42315 .37507 L
.42188 .37509 L
.42061 .37463 L
.41933 .37373 L
.41805 .3724 L
.41674 .37068 L
.41563 .36897 L
.41451 .36705 L
.41337 .36495 L
.41221 .3627 L
.41104 .36035 L
.40984 .35794 L
.40862 .35553 L
.40767 .3537 L
.40671 .35191 L
.40573 .35021 L
.40475 .3486 L
.40375 .34711 L
.40275 .34577 L
.40173 .34461 L
.40047 .34343 L
.39919 .34258 L
.39818 .34217 L
.39717 .34199 L
.39616 .34206 L
.39515 .34238 L
.39415 .34296 L
Mistroke
.39315 .3438 L
.39191 .3452 L
.39068 .34698 L
.3898 .34849 L
.38893 .35018 L
.38807 .35204 L
.38723 .35406 L
.38639 .35623 L
.38557 .35852 L
.38491 .3605 L
.38425 .36255 L
.38361 .36466 L
.38297 .36683 L
.38234 .36904 L
.3816 .3718 L
.38086 .3746 L
.38015 .37744 L
.3792 .38133 L
.37828 .38523 L
.37783 .38718 L
.37739 .38911 L
.37696 .39104 L
.37653 .39296 L
.37612 .39485 L
.37589 .39589 L
.37566 .39692 L
.37544 .39795 L
.37522 .39897 L
.37515 .3993 L
.37508 .39963 L
.37501 .39995 L
.375 .39998 L
.375 .4 L
.375 .40002 L
.37499 .40005 L
.37492 .40037 L
.37485 .4007 L
.37478 .40103 L
.37457 .40203 L
.37439 .40284 L
.37422 .40364 L
.37405 .40444 L
.37388 .40523 L
.37355 .4068 L
.37322 .40835 L
.3729 .40987 L
.37258 .41136 L
.37227 .41283 L
.37145 .41669 L
.37066 .42034 L
Mistroke
.37009 .42293 L
.36955 .4254 L
.36901 .42775 L
.3685 .42997 L
.368 .43207 L
.36752 .43404 L
.36664 .43744 L
.36596 .43987 L
.36542 .44166 L
.3649 .44327 L
.36439 .4447 L
.3639 .44595 L
.36341 .44704 L
.36294 .44797 L
.36247 .44873 L
.36176 .4496 L
.36106 .45011 L
.36037 .45027 L
.35967 .45009 L
.35897 .44957 L
.35826 .44874 L
.35754 .44759 L
.35682 .44619 L
.35607 .44451 L
.35531 .44257 L
.35451 .44039 L
.35368 .43798 L
.35282 .43537 L
.35192 .4326 L
.35134 .4308 L
.35075 .42896 L
.35014 .42709 L
.34952 .4252 L
.34887 .42331 L
.34822 .42142 L
.34741 .41919 L
.34658 .41702 L
.34573 .41494 L
.34486 .41298 L
.34397 .41118 L
.34306 .40956 L
.34213 .40816 L
.34105 .40685 L
.33995 .40592 L
.33884 .40541 L
.33774 .40535 L
.33663 .40577 L
.33553 .40669 L
.33444 .40811 L
.33338 .41004 L
Mistroke
.33233 .41245 L
.33132 .41535 L
.33035 .41869 L
.32942 .42245 L
.32853 .42659 L
.3277 .43108 L
.32692 .43587 L
.3262 .44093 L
.32554 .44622 L
.32494 .45171 L
.3244 .45735 L
.32394 .46313 L
.32354 .46902 L
.32321 .47499 L
.32295 .48102 L
.32277 .4871 L
.32265 .49321 L
.32261 .50014 L
.32266 .50708 L
.3228 .51399 L
.32303 .52086 L
.32335 .52766 L
.32376 .53438 L
.32426 .54096 L
.32485 .54739 L
.32576 .55568 L
.32682 .56349 L
.32802 .5707 L
.32836 .57254 L
.32872 .57432 L
.32908 .57605 L
.32945 .5777 L
.32983 .5793 L
.33022 .58082 L
.33062 .58228 L
.33102 .58366 L
.33184 .5862 L
.33268 .58842 L
.33355 .59031 L
.33443 .59187 L
.33532 .59308 L
.33623 .59395 L
.33714 .59448 L
.33806 .59468 L
.33852 .59466 L
.33898 .59455 L
.33944 .59437 L
.3399 .59411 L
.34036 .59378 L
.34082 .59338 L
Mistroke
.34128 .59291 L
.34231 .59159 L
.34333 .58997 L
.34433 .5881 L
.34531 .58602 L
.34627 .58376 L
.34719 .58139 L
.34809 .57893 L
.34897 .57642 L
.35 .57333 L
.351 .57028 L
.35195 .56732 L
.35286 .56451 L
.35373 .56187 L
.35457 .55944 L
.35538 .55724 L
.35616 .5553 L
.35691 .55363 L
.35795 .55173 L
.35895 .55045 L
.35994 .5498 L
.36092 .54983 L
.36191 .55054 L
.36291 .55199 L
.36396 .55419 L
.36506 .5572 L
.36622 .56104 L
.36747 .56576 L
.36882 .57139 L
.37029 .57794 L
.37163 .58415 L
.37308 .59097 L
.37338 .59241 L
.37369 .59386 L
.374 .59533 L
.37432 .59683 L
.37464 .59834 L
.37497 .59987 L
.37531 .60142 L
.37599 .60456 L
.37669 .60776 L
.37742 .611 L
.37816 .61427 L
.37893 .61755 L
.37972 .62084 L
.38053 .6241 L
.38216 .63029 L
.38387 .6362 L
.38532 .64074 L
.38682 .64489 L
Mistroke
.38836 .64859 L
.38993 .65175 L
.39154 .65431 L
.39317 .65622 L
.39481 .65745 L
.39647 .65799 L
.39812 .65785 L
.39977 .65708 L
.40141 .65572 L
.40304 .65385 L
.40464 .65157 L
.40622 .64896 L
.40776 .64612 L
.40928 .64317 L
.41077 .64019 L
.41222 .63729 L
.41365 .63454 L
.41504 .63202 L
.41642 .6298 L
.41777 .62794 L
.4191 .62649 L
.42042 .62547 L
.42173 .62494 L
.42304 .62491 L
.42462 .62555 L
.42621 .62694 L
.42782 .62909 L
.42946 .63196 L
.43114 .63552 L
.43287 .63969 L
.43466 .6444 L
.43651 .64952 L
.43843 .65491 L
.44063 .66098 L
.44249 .66581 L
.4444 .67038 L
.44637 .67451 L
.44837 .67805 L
.45042 .68085 L
.45249 .68281 L
.45458 .68386 L
.45667 .68395 L
.45876 .68311 L
.46083 .68141 L
.46289 .67895 L
.46491 .67588 L
.46689 .67235 L
.46851 .66919 L
.47009 .66594 L
.47165 .66269 L
Mistroke
.47318 .65953 L
.47467 .65655 L
.47614 .65382 L
.47759 .65141 L
.47901 .64937 L
.48042 .64774 L
.48232 .64625 L
.48421 .64565 L
.48577 .64584 L
.48733 .64667 L
.4889 .64811 L
.49049 .65013 L
.49211 .6527 L
.49375 .65574 L
.49543 .65918 L
.49715 .66292 L
.49915 .66738 L
.5012 .6719 L
.5033 .67628 L
.50546 .68029 L
.50766 .68372 L
.5099 .68638 L
.51216 .6881 L
.51444 .68879 L
.51624 .68855 L
.51803 .68764 L
.51981 .68608 L
.52157 .68393 L
.52331 .68125 L
.52503 .67813 L
.52671 .67467 L
.52835 .67098 L
.52997 .66715 L
.53154 .66329 L
.53308 .6595 L
.53458 .65586 L
.53627 .65195 L
.53792 .64843 L
.53954 .64541 L
.54112 .64292 L
.54268 .64103 L
.54422 .63976 L
.54575 .63913 L
.54728 .63914 L
.54882 .63976 L
.55075 .64139 L
.55271 .64386 L
.55471 .64707 L
.55676 .65085 L
.55886 .65502 L
Mistroke
.56103 .65934 L
.56325 .66355 L
.56512 .66675 L
.56703 .66954 L
.56861 .67139 L
.57019 .6728 L
.57019 .6728 L
.5702 .67281 L
.5702 .67281 L
.5702 .67281 L
.57021 .67281 L
.57021 .67282 L
.57022 .67282 L
.57022 .67283 L
.57028 .67287 L
.57033 .67291 L
.57039 .67295 L
.57045 .67298 L
.57101 .67334 L
.57157 .67362 L
.57214 .67384 L
.5727 .67399 L
.57327 .67407 L
.57415 .67406 L
.57502 .67386 L
.5759 .6735 L
.57677 .67295 L
.57764 .67224 L
.5785 .67135 L
.5798 .6697 L
.58108 .66769 L
.58213 .66578 L
.58317 .66367 L
.58419 .66137 L
.5852 .65891 L
.58619 .65631 L
.58717 .6536 L
.58813 .6508 L
.58931 .64717 L
.59047 .64347 L
.5916 .63976 L
.5927 .63608 L
.59377 .63246 L
.59481 .62893 L
.59582 .62553 L
.59681 .62229 L
.59831 .61756 L
.59975 .61332 L
.60114 .60963 L
.60249 .60651 L
Mistroke
.6038 .60398 L
.60509 .60206 L
.60635 .60073 L
.60761 .60001 L
.60885 .59986 L
.6101 .60027 L
.61136 .60122 L
.6128 .60288 L
.61426 .60511 L
.61576 .60783 L
.6173 .61094 L
.61889 .61434 L
.62053 .6179 L
.62221 .62146 L
.62395 .62485 L
.62573 .62792 L
.62715 .62997 L
.62859 .63163 L
.63005 .63283 L
.63151 .6335 L
.63298 .63359 L
.63445 .63305 L
.63591 .63189 L
.63736 .63008 L
.63878 .62765 L
.64017 .62463 L
.64152 .62106 L
.64283 .617 L
.6441 .61251 L
.64531 .60765 L
.64659 .60192 L
.6478 .5959 L
.64893 .58969 L
.64999 .58335 L
.65096 .57694 L
.65186 .57052 L
.65269 .56412 L
.65343 .55777 L
.65426 .54983 L
.65485 .54351 L
.65535 .53728 L
.65578 .53115 L
.65614 .5251 L
.65641 .51913 L
.65662 .51321 L
.65674 .50734 L
.6568 .50149 L
.65677 .49461 L
.65664 .4877 L
.65641 .48074 L
Mistroke
.65607 .47369 L
.65563 .46654 L
.65508 .45927 L
.65443 .45187 L
.65366 .44433 L
.65299 .43836 L
.65224 .43234 L
.65143 .42628 L
.65054 .42021 L
.64959 .41418 L
.64856 .40823 L
.64747 .40241 L
.64631 .39679 L
.64509 .39144 L
.64381 .38643 L
.64247 .38183 L
.64109 .37773 L
.63994 .37483 L
.63877 .37233 L
.63758 .37025 L
.63637 .36861 L
.63514 .36742 L
.63391 .36668 L
.63267 .36638 L
.63144 .36652 L
.6302 .36707 L
.62898 .368 L
.62776 .36927 L
.62655 .37084 L
.62537 .37266 L
.62401 .37502 L
.62269 .37758 L
.62139 .38026 L
.62012 .38298 L
.61888 .38568 L
.61767 .38829 L
.61648 .39075 L
.61532 .39301 L
.61407 .39521 L
.61284 .39706 L
.61163 .39851 L
.61044 .39952 L
.60925 .40007 L
.60807 .40011 L
.60689 .39965 L
.6057 .39865 L
.6043 .39682 L
.60287 .39427 L
.6014 .391 L
.59988 .38703 L
Mistroke
.5983 .38241 L
.59665 .37719 L
.59522 .37246 L
.59374 .36744 L
.5922 .36224 L
.59059 .35693 L
.58893 .35165 L
.58721 .34652 L
.58543 .34168 L
.5836 .33727 L
.58322 .33646 L
.58285 .33567 L
.58247 .3349 L
.5821 .33416 L
.58172 .33344 L
.58134 .33275 L
.58095 .3321 L
.58018 .33087 L
.57941 .32977 L
.57863 .3288 L
.57785 .32796 L
.57706 .32727 L
.57627 .32672 L
.57548 .32631 L
.57412 .32594 L
.57275 .326 L
.57139 .32646 L
.57003 .32732 L
.56868 .32853 L
.56735 .33006 L
.56602 .33187 L
.56471 .33391 L
.56342 .33614 L
.56215 .33849 L
.56089 .34093 L
.55965 .34339 L
.55844 .34584 L
.55706 .34857 L
.5557 .35115 L
.55437 .35352 L
.55305 .35563 L
.55176 .35744 L
.55047 .3589 L
.5492 .35998 L
.54778 .36073 L
.54637 .36094 L
.54495 .36062 L
.54353 .35974 L
.54209 .35833 L
.54064 .35638 L
Mistroke
.53917 .35395 L
.53767 .35105 L
.53593 .34728 L
.53414 .34309 L
.5323 .33859 L
.53041 .33394 L
.52847 .32929 L
.52647 .32483 L
.52443 .32073 L
.52234 .31718 L
.52021 .31435 L
.51805 .31237 L
.51588 .31134 L
.51408 .31125 L
.51229 .31183 L
.5105 .31306 L
.50873 .3149 L
.50698 .31727 L
.50525 .32008 L
.50355 .32324 L
.50188 .32664 L
.50025 .33017 L
.49865 .33374 L
.49708 .33724 L
.49555 .34058 L
.49377 .34423 L
.49204 .34743 L
.49033 .35009 L
.48865 .35215 L
.487 .35356 L
.48535 .35427 L
.48371 .35428 L
.48206 .3536 L
.48041 .35225 L
.47873 .35026 L
.47703 .34769 L
.4753 .34464 L
.47357 .34128 L
.47181 .33765 L
.47001 .33389 L
.46816 .33013 L
.46628 .32652 L
.46436 .32323 L
.4624 .3204 L
.46042 .31818 L
.45841 .31669 L
.45639 .31601 L
.45437 .3162 L
.45236 .31728 L
.45036 .31921 L
Mistroke
.44839 .32192 L
.44646 .32532 L
.44456 .32927 L
.44271 .33364 L
.44091 .33828 L
.43916 .34305 L
.43746 .3478 L
.43582 .35241 L
.43403 .35729 L
.4323 .36173 L
.43063 .36563 L
.42899 .36892 L
.4274 .37154 L
.42583 .37346 L
.42428 .37465 L
.42274 .37513 L
.4212 .3749 L
.42037 .37449 L
.41953 .3739 L
.41869 .37311 L
.41785 .37216 L
.41699 .37104 L
.41613 .36976 L
.41526 .36835 L
.41438 .36681 L
.41279 .36382 L
.41115 .36058 L
.40948 .35723 L
.40777 .35388 L
.40602 .3507 L
.40423 .34781 L
.40255 .34554 L
.40122 .34409 L
.39988 .343 L
.39853 .34228 L
.39718 .34199 L
.39583 .34214 L
.39448 .34274 L
.39313 .34381 L
.3918 .34533 L
.39048 .34729 L
.38918 .34967 L
.38791 .35242 L
.38666 .35552 L
.38543 .35893 L
.38407 .36312 L
.38276 .36757 L
.38148 .37222 L
.38026 .377 L
.37908 .38184 L
Mistroke
.37794 .38668 L
.37686 .39149 L
.37582 .3962 L
.37473 .40126 L
.37369 .40614 L
.3727 .41079 L
.37177 .4152 L
.37087 .41936 L
.37002 .42325 L
.36922 .42686 L
.36845 .4302 L
.36763 .43357 L
.36686 .4366 L
.36612 .43931 L
.36541 .4417 L
.36473 .44377 L
.36407 .44554 L
.36343 .44702 L
.3628 .44821 L
.36256 .44859 L
.36233 .44894 L
.3621 .44924 L
.36186 .4495 L
.36163 .44972 L
.3614 .44991 L
.36117 .45005 L
.36041 .45027 L
.35965 .45007 L
.35888 .44948 L
.3581 .4485 L
.3573 .44715 L
.35648 .44544 L
.35563 .4434 L
.35512 .44208 L
.35461 .44066 L
.35408 .43915 L
.35354 .43755 L
.35298 .43587 L
.35241 .43412 L
.35149 .43125 L
.35069 .42878 L
.34987 .42627 L
.34902 .42373 L
.3483 .42165 L
.34756 .4196 L
.34681 .4176 L
.34603 .41567 L
.34524 .41382 L
.34443 .4121 L
.34346 .41025 L
Mistroke
.34246 .40863 L
.34145 .4073 L
.34043 .40628 L
.3394 .40561 L
.33836 .40533 L
.33732 .40545 L
.33609 .40616 L
.33487 .40749 L
.33388 .40906 L
.33291 .41105 L
.33196 .41345 L
.33104 .41625 L
.33016 .41942 L
.32931 .42294 L
.3285 .42677 L
.32773 .4309 L
.32682 .43654 L
.32599 .44253 L
.32524 .44882 L
.32458 .45536 L
.32402 .4621 L
.32354 .46899 L
.32316 .476 L
.32288 .48308 L
.32268 .49159 L
.32261 .50013 L
.32268 .50867 L
.32289 .51717 L
.32324 .52559 L
.32373 .53389 L
.32435 .542 L
.3251 .54986 L
.32598 .55738 L
.32697 .56448 L
.32808 .57105 L
.32871 .57427 L
.32936 .57729 L
.33004 .58011 L
.33074 .5827 L
.33146 .58507 L
.3322 .58719 L
.33296 .58906 L
.33398 .59113 L
.33503 .59272 L
.33609 .59384 L
.33716 .59449 L
.33823 .59468 L
.33931 .59443 L
.34037 .59377 L
.34143 .59273 L
Mistroke
.34248 .59135 L
.34351 .58966 L
.34452 .58773 L
.34591 .58462 L
.34702 .58186 L
.34808 .57897 L
.34911 .57601 L
.35009 .57305 L
.35104 .57014 L
.35195 .56731 L
.35282 .56462 L
.35366 .56208 L
.35478 .55885 L
.35585 .55605 L
.35668 .55412 L
.35748 .55252 L
.35826 .55126 L
.35903 .55038 L
.35978 .54986 L
.36053 .54974 L
.36129 .55001 L
.36204 .5507 L
.36303 .5522 L
.36406 .55443 L
.36491 .55675 L
.3658 .55958 L
.36673 .56293 L
.36773 .56682 L
.36879 .57126 L
.36991 .57626 L
.37113 .58181 L
.37242 .5879 L
.37382 .59448 L
.37493 .59965 L
.37609 .60502 L
.37609 .60503 L
.37609 .60504 L
.3761 .60505 L
.3761 .60506 L
.3761 .60507 L
.3761 .6051 L
.37611 .60512 L
.37611 .60514 L
.37616 .60535 L
.37621 .60556 L
.37625 .60578 L
.3763 .60599 L
.37677 .60813 L
.37726 .6103 L
.37775 .61247 L
Mistroke
.37825 .61466 L
.37877 .61685 L
.37981 .62121 L
.38057 .62425 L
.38135 .62727 L
.38199 .62968 L
.38265 .63205 L
.38332 .63438 L
.384 .63664 L
.38469 .63884 L
.38548 .64122 L
.38629 .64349 L
.38711 .64563 L
.38793 .64764 L
.38877 .64949 L
.38962 .65119 L
.39121 .65384 L
.39238 .65538 L
.39356 .65658 L
.39453 .65729 L
.3955 .65776 L
.39648 .65799 L
.39746 .65799 L
.39844 .65775 L
.39941 .6573 L
.40064 .65643 L
.40185 .65526 L
.40306 .65382 L
.40426 .65215 L
.40544 .65029 L
.4066 .64827 L
.40775 .64615 L
.40901 .64371 L
.41024 .64125 L
.41145 .63881 L
.41265 .63645 L
.41382 .63422 L
.41497 .63214 L
.41611 .63027 L
.41723 .62864 L
.41882 .62676 L
.42039 .62549 L
.42195 .6249 L
.42351 .62502 L
.42507 .62586 L
.42664 .62745 L
.42825 .62977 L
.42988 .63279 L
.43144 .6362 L
.43304 .64013 L
Mistroke
.43434 .64355 L
.43568 .6472 L
.43705 .65103 L
.43845 .65498 L
.43989 .65897 L
.44137 .66293 L
.44288 .66678 L
.44443 .67043 L
.44601 .6738 L
.44762 .6768 L
.44925 .67935 L
.45058 .68104 L
.45192 .68237 L
.45327 .68332 L
.45463 .68387 L
.45599 .68402 L
.45735 .68378 L
.4587 .68314 L
.46052 .68172 L
.46199 .68012 L
.46344 .67816 L
.46488 .67592 L
.4663 .67344 L
.4677 .67079 L
.46907 .66804 L
.47043 .66524 L
.47176 .66246 L
.47306 .65976 L
.47435 .65718 L
.47594 .65418 L
.47751 .65154 L
.47876 .6497 L
.48 .64818 L
.48123 .647 L
.48246 .64617 L
.48367 .64572 L
.48489 .64565 L
.4861 .64597 L
.48754 .64683 L
.48898 .6482 L
.49044 .65006 L
.49192 .65238 L
.49343 .6551 L
.49496 .65818 L
.49653 .66154 L
.49813 .66509 L
.49976 .66874 L
.50143 .6724 L
.50314 .67594 L
.50487 .67926 L
Mistroke
.50664 .68223 L
.5081 .68431 L
.50957 .68605 L
.51105 .68739 L
.51255 .6883 L
.51404 .68875 L
.51554 .68873 L
.51704 .68823 L
.51853 .68727 L
.52001 .68587 L
.52148 .68406 L
.52293 .68188 L
.52437 .67938 L
.52578 .67662 L
.52731 .67334 L
.52882 .6699 L
.53029 .66637 L
.53173 .66283 L
.53314 .65936 L
.53452 .65601 L
.53587 .65286 L
.53719 .64994 L
.53865 .64702 L
.54007 .6445 L
.54148 .64244 L
.54287 .64085 L
.54424 .63975 L
.54561 .63916 L
.54697 .63908 L
.54834 .6395 L
.54998 .64064 L
.55165 .64243 L
.55334 .6448 L
.55506 .64768 L
.55681 .65096 L
.55861 .65451 L
.56045 .6582 L
.56233 .66186 L
.56426 .66532 L
.56622 .66842 L
.56822 .67097 L
.57024 .67284 L
.57228 .67389 L
.57433 .67403 L
.57637 .67322 L
.5784 .67146 L
.58041 .66879 L
.58237 .66531 L
.58429 .66113 L
.58616 .65639 L
Mistroke
.58766 .65216 L
.58913 .64775 L
.59054 .64323 L
.59192 .6387 L
.59325 .63422 L
.59453 .62986 L
.59578 .62568 L
.59699 .62173 L
.59815 .61804 L
.5998 .61319 L
.60109 .60976 L
.60234 .60682 L
.60357 .60439 L
.60477 .60248 L
.60595 .6011 L
.60711 .60022 L
.60827 .59986 L
.60943 .59998 L
.61077 .60071 L
.61211 .60202 L
.61348 .60386 L
.61488 .60618 L
.61631 .6089 L
.61778 .61194 L
.61929 .61521 L
.62084 .61858 L
.62244 .62192 L
.62408 .62511 L
.62577 .62798 L
.62718 .63001 L
.62861 .63165 L
.63005 .63283 L
.63151 .6335 L
.63297 .63359 L
.63442 .63307 L
.63587 .63193 L
.6373 .63016 L
.63843 .62831 L
.63953 .6261 L
.64061 .62352 L
.64167 .62062 L
.6427 .61742 L
.64371 .61395 L
.64468 .61024 L
.64577 .60566 L
.64681 .60086 L
.6478 .59588 L
.64874 .59077 L
.64963 .58556 L
.65046 .58029 L
Mistroke
.65125 .57499 L
.65197 .56969 L
.65281 .56308 L
.65357 .55653 L
.65424 .55006 L
.65483 .54369 L
.65535 .53741 L
.65578 .53122 L
.65613 .52513 L
.65641 .5191 L
.65662 .51314 L
.65675 .50722 L
.6568 .50132 L
.65677 .49437 L
.65663 .4874 L
.65639 .48036 L
.65605 .47325 L
.65559 .46602 L
.65503 .45867 L
.65436 .45118 L
.65358 .44356 L
.65284 .43711 L
.65201 .4306 L
.65111 .42406 L
.65013 .41753 L
.64926 .41226 L
.64835 .40706 L
.64738 .40197 L
.64637 .39704 L
.6453 .39231 L
.64419 .38784 L
.64303 .38367 L
.64145 .37875 L
.64027 .37562 L
.63905 .3729 L
.63782 .37063 L
.63656 .36884 L
.63528 .36753 L
.634 .36671 L
.63271 .36639 L
.63189 .36642 L
.63106 .36665 L
.63023 .36705 L
.62941 .36763 L
.6286 .36836 L
.62778 .36924 L
.62698 .37025 L
.62557 .37233 L
.62418 .37471 L
.62283 .3773 L
Mistroke
.6215 .38002 L
.6202 .3828 L
.61894 .38556 L
.6177 .38822 L
.61649 .39074 L
.61531 .39304 L
.61415 .39509 L
.61301 .39683 L
.61211 .39799 L
.61121 .39892 L
.61033 .39959 L
.60945 .40001 L
.60857 .40015 L
.60769 .40002 L
.60681 .3996 L
.60563 .39857 L
.60442 .39702 L
.60382 .39604 L
.6032 .39493 L
Mfstroke
.02 w
.375 .4 Mdot
.5 Mabswid
.60382 .39604 m
.6032 .39493 L
s
% Start of user PostScript
0.83052546 -0.83168339 0.8256041 -0.84059462 MAarrowhead1
% End of user PostScript
.486 0 1 r
.39017 .45229 m
.38996 .45351 L
.38975 .45476 L
.38952 .45626 L
.38929 .4578 L
.38907 .45937 L
.38845 .46451 L
.38792 .46996 L
.38747 .47566 L
.38712 .48156 L
.38687 .4876 L
.38672 .49374 L
.38667 .49993 L
.38672 .50612 L
.38684 .51126 L
.38702 .51634 L
.38728 .52133 L
.38761 .5262 L
.38799 .53092 L
.38845 .53545 L
.38896 .53977 L
.38953 .54384 L
.38996 .54649 L
.39041 .549 L
.39089 .55134 L
.39138 .55351 L
.3919 .5555 L
.39243 .55729 L
.39298 .55888 L
.39384 .56089 L
.39473 .5624 L
.39563 .5634 L
.39654 .56389 L
.39746 .56386 L
.39837 .56334 L
.39927 .56234 L
.40016 .56089 L
.40102 .55904 L
.40185 .5568 L
.40264 .55424 L
.4034 .55139 L
.40412 .54828 L
.40479 .54496 L
.40541 .54147 L
.40597 .53784 L
.40659 .53332 L
.40712 .52869 L
.40758 .52397 L
.40795 .51919 L
.40824 .51437 L
Mistroke
.40844 .50952 L
.40856 .50467 L
.4086 .50069 L
.40858 .49671 L
.40851 .49274 L
.40838 .48878 L
.40819 .48482 L
.40795 .48088 L
.40766 .47697 L
.4073 .4731 L
.4069 .46927 L
.40644 .46551 L
.40593 .46184 L
.40536 .45828 L
.40475 .45486 L
.4042 .45211 L
.40361 .44949 L
.403 .44704 L
.40236 .44478 L
.40169 .44273 L
.401 .44091 L
.40028 .43935 L
.39991 .43866 L
.39954 .43805 L
.39916 .43751 L
.39878 .43706 L
.3984 .43669 L
.39801 .4364 L
.39763 .4362 L
.39659 .4361 L
.39555 .43667 L
.39453 .43789 L
.39353 .43978 L
.39257 .4423 L
.39165 .44542 L
.39079 .4491 L
.39 .45329 L
.38927 .45793 L
.38863 .46295 L
.38807 .46831 L
.38768 .47277 L
.38736 .47737 L
.3871 .48209 L
.3869 .4869 L
.38676 .49177 L
.38668 .49668 L
.38667 .50161 L
.38674 .50752 L
.38691 .51339 L
.38716 .51915 L
Mistroke
.38743 .52374 L
.38776 .52821 L
.38815 .53254 L
.38859 .5367 L
.38908 .54066 L
.38962 .5444 L
.3902 .54788 L
.39083 .55109 L
.3915 .55398 L
.3922 .55654 L
.39281 .55841 L
.39344 .56003 L
.39409 .56137 L
.39475 .56243 L
.39541 .56321 L
.39609 .56371 L
.39677 .56393 L
.39724 .56391 L
.39771 .56376 L
.39819 .56348 L
.39865 .56307 L
.39912 .56254 L
.39958 .56189 L
.39981 .56152 L
.40003 .56112 L
.40026 .5607 L
.40048 .56024 L
.4007 .55976 L
.40092 .55926 L
.40114 .55873 L
.4022 .55572 L
.4032 .55219 L
.40413 .54823 L
.40498 .54392 L
.40575 .53933 L
.40643 .53453 L
.40703 .52958 L
.40753 .52453 L
.40793 .5194 L
.40821 .51478 L
.40842 .51013 L
.40855 .50547 L
.4086 .5008 L
.40858 .49613 L
.40847 .49146 L
.40829 .48681 L
.40804 .48218 L
.4077 .47757 L
.4073 .47302 L
.40681 .46853 L
Mistroke
.40626 .46415 L
.40563 .45989 L
.40509 .45672 L
.40452 .45367 L
.40391 .45077 L
.40326 .44806 L
.40258 .44554 L
.40187 .44326 L
.40113 .44125 L
.40037 .43953 L
.39976 .4384 L
.39913 .43748 L
.3985 .43678 L
.39786 .43631 L
.39722 .43609 L
.39658 .4361 L
.39594 .43637 L
.39488 .43739 L
.39383 .43912 L
.39283 .44155 L
.39186 .44463 L
.39096 .44831 L
.39012 .45256 L
.38936 .45729 L
.38869 .46245 L
.3881 .46797 L
.38761 .47379 L
.38721 .47983 L
.38693 .48605 L
.38674 .49238 L
.38667 .49878 L
.38668 .50238 L
.38672 .50598 L
.38679 .50956 L
.3869 .51311 L
.38704 .51663 L
.38721 .52011 L
.38742 .52353 L
.38773 .52788 L
.3881 .5321 L
.38853 .53616 L
.38899 .54004 L
.38951 .54371 L
.39007 .54714 L
.39067 .55032 L
.39131 .55321 L
.39198 .55579 L
.39268 .55805 L
.39302 .55899 L
.39337 .55985 L
Mistroke
.39372 .56063 L
.39407 .56133 L
.39443 .56195 L
.39479 .56249 L
.39515 .56294 L
.39606 .56369 L
.39697 .56394 L
.39789 .56367 L
.3988 .56292 L
.39969 .56171 L
.40057 .56006 L
.40141 .55803 L
.40223 .55563 L
.40328 .55186 L
.40426 .5476 L
.40515 .54296 L
.40595 .53803 L
.40664 .53288 L
.40724 .52759 L
.40772 .52218 L
.40804 .51784 L
.40828 .51347 L
.40846 .50908 L
.40856 .50468 L
.4086 .50027 L
.40857 .49587 L
.40847 .49147 L
.40831 .48708 L
.40811 .48334 L
.40786 .47962 L
.40757 .47593 L
.40722 .47227 L
.40683 .46866 L
.40639 .46511 L
.4059 .46165 L
.40555 .45939 L
.40518 .45718 L
.40478 .45503 L
.40438 .45295 L
.40395 .45094 L
.4035 .44902 L
.40291 .4467 L
.40229 .44455 L
.40164 .4426 L
.40097 .44086 L
.40029 .43937 L
.39959 .43813 L
.39888 .43717 L
.39827 .43658 L
.39766 .43621 L
Mistroke
.39704 .43607 L
.39643 .43615 L
.39582 .43645 L
.39521 .437 L
.39446 .43799 L
.39373 .43933 L
.39302 .44101 L
.39262 .44214 L
.39222 .44338 L
.39184 .44472 L
.39146 .44616 L
.3911 .4477 L
.39074 .44933 L
.39008 .45279 L
.38947 .45657 L
.38891 .46062 L
.38841 .46492 L
.38796 .46944 L
.38758 .47413 L
.38726 .47896 L
.38701 .48391 L
.38683 .48895 L
.38671 .49405 L
.38667 .49918 L
.38669 .50431 L
.38679 .50942 L
.387 .51589 L
.38733 .52222 L
.38769 .5273 L
.38811 .53219 L
.38861 .53688 L
.38917 .54132 L
.38979 .54546 L
.39046 .54927 L
.39119 .55271 L
.39197 .55574 L
.39278 .55833 L
.39363 .56045 L
.39451 .56208 L
.3954 .5632 L
.39631 .56381 L
.39722 .56391 L
.39813 .56352 L
.39903 .56265 L
.39992 .56133 L
.40078 .55958 L
.40162 .55746 L
.40242 .555 L
.40319 .55223 L
.40391 .54921 L
Mistroke
.40459 .54596 L
.40523 .54253 L
.40581 .53895 L
.40644 .53445 L
.407 .52981 L
.40748 .52507 L
.40787 .52027 L
.40818 .51543 L
.4084 .51056 L
.40855 .50568 L
.4086 .50152 L
.40859 .49736 L
.40852 .49321 L
.40839 .48906 L
.4082 .48493 L
.40795 .48081 L
.40763 .47672 L
.40726 .47267 L
.40683 .46868 L
.40634 .46477 L
.40598 .46223 L
.4056 .45975 L
.4052 .45732 L
.40477 .45497 L
.40432 .45269 L
.40385 .45051 L
.40336 .44844 L
.40266 .4458 L
.40192 .44341 L
.40116 .44131 L
.40036 .43952 L
.39955 .43807 L
.39872 .437 L
.39788 .43632 L
.39703 .43607 L
.39593 .43638 L
.39484 .43744 L
.39411 .43859 L
.39339 .44009 L
.39269 .44193 L
.39202 .44408 L
.39137 .44654 L
.39075 .44929 L
.39017 .4523 L
.38963 .45553 L
.38912 .45899 L
.38866 .46263 L
.38825 .46646 L
.38788 .47043 L
.38755 .47453 L
Mistroke
.38728 .47875 L
.38705 .48305 L
.38688 .48742 L
.38676 .49184 L
.38669 .49629 L
.38667 .50076 L
.38668 .50356 L
.38672 .50636 L
.38678 .50915 L
.38686 .51193 L
.38695 .51469 L
.38707 .51742 L
.38733 .52207 L
.38764 .52661 L
.388 .53102 L
.38843 .53526 L
.3889 .53932 L
.38943 .54316 L
.39 .54675 L
.39062 .55006 L
.39128 .55308 L
.39197 .55576 L
.39297 .55884 L
.39387 .56095 L
.3948 .5625 L
.39574 .56349 L
.3967 .56392 L
.39766 .56378 L
.39862 .56311 L
.39956 .56192 L
.40047 .56026 L
.40155 .55766 L
.40257 .5545 L
.40353 .55087 L
.40442 .54684 L
.40523 .5425 L
.40596 .53791 L
.40673 .53213 L
.40737 .52617 L
.40788 .52009 L
.40826 .51395 L
.40843 .50976 L
.40855 .50556 L
.4086 .50135 L
.40859 .49714 L
.40851 .49294 L
.40838 .48874 L
.40818 .48456 L
.40792 .4804 L
.4076 .47626 L
Mistroke
.40721 .47217 L
.40677 .46814 L
.40626 .46419 L
.4057 .46035 L
.40546 .45888 L
.40522 .45744 L
.40497 .45602 L
.40471 .45462 L
.40444 .45326 L
.40416 .45193 L
.40388 .45063 L
.40314 .44756 L
.40235 .44477 L
.40153 .44229 L
.40067 .44017 L
.39979 .43845 L
.39888 .43717 L
.39796 .43637 L
.39703 .43607 L
.39589 .4364 L
.39477 .43754 L
.39386 .43907 L
.39298 .44112 L
.39213 .44368 L
.39133 .44672 L
.39057 .45019 L
.38986 .45407 L
.38922 .4583 L
.38864 .46284 L
.38802 .46879 L
.38751 .47506 L
.38721 .47994 L
.38697 .48493 L
.3868 .49 L
.3867 .49512 L
.38667 .50027 L
.38671 .50541 L
.38681 .51053 L
.38696 .51472 L
.38714 .51885 L
.38738 .52292 L
.38766 .52689 L
.38798 .53077 L
.38835 .53451 L
.38875 .53812 L
.38908 .54067 L
.38942 .54313 L
.38979 .54548 L
.39017 .54773 L
.39058 .54985 L
Mistroke
.391 .55185 L
.39137 .55344 L
.39175 .55494 L
.39214 .55633 L
.39254 .55761 L
.39294 .55878 L
.39345 .56004 L
.39396 .56114 L
.39443 .56197 L
.39491 .56265 L
.39539 .56319 L
.39587 .56358 L
.39636 .56383 L
.39672 .56392 L
.39707 .56393 L
.39743 .56387 L
.39778 .56373 L
.39814 .56352 L
.39817 .56349 L
.39821 .56346 L
.39825 .56343 L
.39829 .5634 L
.39829 .5634 L
.39829 .5634 L
.3983 .5634 L
.3983 .56339 L
.3983 .56339 L
.3983 .56339 L
.3983 .56339 L
.39831 .56339 L
.39924 .56239 L
.40015 .56091 L
.40103 .55899 L
.40189 .55668 L
.40271 .55402 L
.40348 .55105 L
.40421 .54782 L
.4049 .54437 L
.40553 .54074 L
.4061 .53697 L
.40662 .53309 L
.40717 .52827 L
.40763 .52336 L
.408 .51838 L
.40829 .51337 L
.40848 .50834 L
.40857 .50413 L
.4086 .49992 L
.40857 .49571 L
.40847 .49151 L
Mistroke
.40832 .48731 L
.4081 .48312 L
.40781 .47896 L
.40747 .47484 L
.40706 .47076 L
.4066 .46675 L
.40593 .46184 L
.40542 .45864 L
.40488 .45554 L
.4043 .45258 L
.40368 .44978 L
.40303 .44716 L
.40235 .44475 L
.40163 .44258 L
.4009 .44068 L
.40013 .43907 L
.39936 .43778 L
.39882 .43711 L
.39829 .4366 L
.39775 .43625 L
.39721 .43608 L
.39666 .43609 L
.39612 .43627 L
.39558 .43663 L
.39454 .43787 L
.39352 .4398 L
.39254 .44238 L
.39161 .4456 L
.39073 .44939 L
.38992 .45371 L
.38919 .45849 L
.38854 .46367 L
.38799 .46919 L
.38752 .47497 L
.38715 .48097 L
.38693 .48603 L
.38677 .49116 L
.38669 .49633 L
.38667 .50153 L
.38673 .50672 L
.38685 .51187 L
.38705 .51696 L
.38732 .52195 L
.38765 .52682 L
.38805 .53153 L
.38845 .53547 L
.38889 .53925 L
.38938 .54284 L
.38991 .54621 L
.39048 .54935 L
Mistroke
.39108 .55223 L
.39172 .55483 L
.39207 .55611 L
.39243 .55729 L
.3928 .55838 L
.39318 .55938 L
.39356 .56029 L
.39394 .56109 L
.39433 .5618 L
.39535 .56316 L
.39639 .56384 L
.39743 .56387 L
.39847 .56325 L
.3995 .56202 L
.40049 .56022 L
.40146 .55791 L
.40238 .55514 L
.40348 .55105 L
.4045 .54645 L
.40541 .54145 L
.40622 .53615 L
.40691 .53063 L
.40749 .52497 L
.40794 .51922 L
.40821 .51496 L
.4084 .51068 L
.40853 .50639 L
.40859 .5021 L
.40859 .4978 L
.40853 .4935 L
.4084 .48922 L
.4082 .48494 L
.40801 .48172 L
.40778 .47851 L
.40751 .47532 L
.40721 .47216 L
.40687 .46904 L
.4065 .46596 L
.40609 .46294 L
.40564 .45995 L
.40515 .45704 L
.40463 .45423 L
.40408 .45155 L
.4035 .449 L
.40289 .44663 L
.40225 .44443 L
.40159 .44245 L
.4009 .44069 L
.40045 .43969 L
.39999 .4388 L
Mistroke
.39952 .43803 L
.39905 .43738 L
.39858 .43685 L
.3981 .43646 L
.39763 .4362 L
.39715 .43608 L
.39668 .43609 L
.3962 .43623 L
.39573 .43652 L
.39526 .43694 L
.3948 .4375 L
.39388 .43904 L
.39298 .44112 L
.39212 .44372 L
.39131 .4468 L
.39054 .45034 L
.38983 .45429 L
.38918 .4586 L
.38859 .46323 L
.38815 .46747 L
.38775 .47189 L
.38742 .47645 L
.38714 .48114 L
.38693 .48592 L
.38678 .49077 L
.38669 .49566 L
.38667 .50156 L
.38674 .50744 L
.3869 .51328 L
.38715 .51902 L
.38744 .52388 L
.38779 .52862 L
.38821 .53319 L
.38869 .53756 L
.38922 .54171 L
.38981 .54559 L
.39045 .54918 L
.39113 .55244 L
.39185 .55534 L
.39262 .55785 L
.39341 .55995 L
.39456 .56216 L
.39575 .5635 L
.39695 .56394 L
.39816 .5635 L
.39934 .56224 L
.4005 .5602 L
.40161 .55748 L
.40267 .55417 L
.40365 .55035 L
Mistroke
.40478 .54498 L
.40578 .53913 L
.40664 .53294 L
.40734 .52652 L
.40789 .51997 L
.40829 .51334 L
.40852 .50666 L
.4086 .49997 L
.40856 .49499 L
.40843 .49002 L
.40821 .48507 L
.4079 .48014 L
.40751 .47525 L
.40703 .47043 L
.40646 .46571 L
.40582 .46112 L
.40509 .45672 L
.40429 .45256 L
.40342 .4487 L
.40249 .44522 L
.40149 .44219 L
.40045 .43969 L
.39937 .4378 L
.39845 .43673 L
.39751 .43616 L
.39658 .43611 L
.39564 .43659 L
.39472 .43761 L
.39381 .43917 L
.39293 .44125 L
.39209 .44383 L
.39129 .44689 L
.39053 .45038 L
.38983 .45427 L
.38919 .45851 L
.38861 .46307 L
.38811 .46788 L
.38767 .47293 L
.38731 .47815 L
.38703 .48352 L
.38679 .49028 L
.3867 .49514 L
.38667 .50002 L
.3867 .50491 L
.38679 .50977 L
.38695 .51458 L
.38717 .51932 L
.38745 .52397 L
.38778 .5285 L
.38818 .53287 L
Mistroke
.38863 .53707 L
.38903 .54034 L
.38947 .54346 L
.38994 .54641 L
.39044 .54917 L
.39097 .55174 L
.39153 .55409 L
.3921 .55621 L
.39285 .55851 L
.39362 .56042 L
.39441 .56192 L
.39522 .56301 L
.39604 .56368 L
.39686 .56393 L
.39769 .56377 L
.39851 .56321 L
.39933 .56226 L
.40012 .56095 L
.40107 .55891 L
.40197 .55643 L
.40284 .55355 L
.40366 .55033 L
.40442 .54683 L
.40513 .5431 L
.40577 .53917 L
.40636 .5351 L
.40688 .53091 L
.40733 .52664 L
.40771 .52231 L
.40803 .51794 L
.40828 .51353 L
.40846 .50911 L
.40856 .50468 L
.4086 .50024 L
.40857 .4958 L
.4085 .49225 L
.40838 .4887 L
.40821 .48516 L
.408 .48163 L
.40775 .47813 L
.40745 .47465 L
.40711 .4712 L
.40672 .46779 L
.40629 .46443 L
.40582 .46115 L
.40531 .45797 L
.40476 .4549 L
.40417 .45196 L
.40354 .44919 L
.40299 .44702 L
Mistroke
.40242 .445 L
.40183 .44315 L
.40122 .44148 L
.4006 .44 L
.39995 .43874 L
.3993 .4377 L
.39843 .43672 L
.39756 .43617 L
.39701 .43606 L
.39647 .43613 L
.39592 .43638 L
.39538 .43682 L
.39485 .43743 L
.39432 .43823 L
.39398 .43883 L
.39365 .43951 L
.39332 .44026 L
.39299 .44108 L
.39267 .44198 L
.39263 .44209 L
.3926 .44221 L
.39256 .44233 L
.39252 .44245 L
.39251 .44246 L
.39251 .44248 L
.3925 .44249 L
.3925 .44249 L
.3925 .4425 L
.3925 .44251 L
.3925 .44251 L
.39249 .44252 L
.39249 .44254 L
.39248 .44255 L
.39244 .44267 L
.39241 .44279 L
.39237 .44292 L
.39233 .44304 L
.39199 .44418 L
.39166 .44539 L
.39134 .44668 L
.39102 .44805 L
.39071 .44948 L
.39024 .4519 L
.3898 .45447 L
.38945 .45672 L
.38912 .45906 L
.3888 .46149 L
.38851 .46399 L
.38823 .46658 L
.38798 .46923 L
Mistroke
.38755 .47459 L
.38727 .4789 L
.38708 .48248 L
.38692 .4861 L
.38681 .48977 L
.38672 .49346 L
.38668 .49718 L
.38667 .5009 L
.3867 .50461 L
.38679 .50949 L
.38694 .51432 L
.38716 .51908 L
.38743 .52374 L
.38777 .52828 L
.38816 .53268 L
.38861 .5369 L
.38911 .54092 L
.38982 .54564 L
.39059 .54993 L
.39144 .55374 L
.39234 .557 L
.39329 .55966 L
.39428 .5617 L
.39529 .56309 L
.39633 .56382 L
.39736 .56389 L
.39839 .56332 L
.3994 .56216 L
.40039 .56043 L
.40135 .5582 L
.40227 .55551 L
.40314 .55242 L
.40396 .549 L
.40472 .5453 L
.40542 .54138 L
.40606 .53727 L
.40662 .53303 L
.40712 .52868 L
.40755 .52425 L
.40794 .51931 L
.40824 .51433 L
.40845 .50931 L
.40857 .50429 L
.4086 .49926 L
.40854 .49423 L
.4084 .48921 L
.40816 .4842 L
.40775 .47819 L
.40722 .47226 L
.40656 .46645 L
Mistroke
.40577 .46083 L
.40487 .4555 L
.40386 .45055 L
.40274 .44611 L
.4018 .44307 L
.40082 .44049 L
.39979 .43845 L
.39873 .43701 L
.39766 .43621 L
.39658 .43611 L
.3955 .43671 L
.39444 .43803 L
.3934 .44006 L
.39258 .44227 L
.39178 .44492 L
.39103 .44799 L
.39033 .45145 L
.38967 .45525 L
.38907 .45938 L
.38853 .46377 L
.38806 .46841 L
.38768 .47276 L
.38737 .47726 L
.38711 .48186 L
.38691 .48655 L
.38677 .4913 L
.38669 .49609 L
.38667 .5009 L
.38671 .50571 L
.3869 .51311 L
.38723 .52037 L
.3877 .52738 L
.3883 .53407 L
.38903 .54032 L
.38988 .54604 L
.39011 .54737 L
.39035 .54866 L
.39059 .5499 L
.39083 .5511 L
.39109 .55225 L
.39135 .55336 L
.39161 .55442 L
.39215 .55638 L
.39271 .55813 L
.39329 .55967 L
.39388 .56097 L
.39448 .56204 L
.39509 .56288 L
.39571 .56347 L
.39634 .56382 L
Mistroke
.39696 .56394 L
.39774 .56375 L
.39852 .5632 L
.39929 .56232 L
.40004 .56111 L
.40078 .55959 L
.4015 .5578 L
.40219 .55575 L
.40304 .55278 L
.40385 .5495 L
.40447 .54656 L
.40506 .54348 L
.4056 .54025 L
.40611 .53692 L
.40656 .53351 L
.40698 .53002 L
.40734 .52648 L
.40767 .5229 L
.40804 .51777 L
.40832 .5126 L
.40851 .50741 L
.40859 .5022 L
.40859 .49699 L
.40848 .49179 L
.40828 .4866 L
.40799 .48144 L
.40737 .47373 L
.40736 .47372 L
.40736 .47371 L
.40736 .4737 L
.40736 .47369 L
.40736 .47368 L
.40736 .47365 L
.40736 .47363 L
.40735 .47361 L
.40733 .47339 L
.40731 .47318 L
.40729 .47296 L
.40727 .47274 L
.40707 .47078 L
.40685 .46884 L
.40662 .46692 L
.40637 .46502 L
.40612 .46314 L
.40574 .46059 L
.40534 .45811 L
.40491 .4557 L
.40446 .45336 L
.40407 .45152 L
.40368 .44975 L
Mistroke
.40326 .44806 L
.40284 .44644 L
.4024 .44492 L
.40195 .44349 L
.40157 .4424 L
.40119 .44138 L
.40079 .44044 L
.4004 .43958 L
.39999 .43881 L
.39946 .43793 L
.39892 .43722 L
.39837 .43667 L
.39782 .43629 L
.39727 .43609 L
.39672 .43608 L
.39603 .43632 L
.39535 .43685 L
.39468 .43766 L
.39402 .43876 L
.39337 .44015 L
.39274 .4418 L
.39212 .44372 L
.39143 .44631 L
.39077 .44922 L
.39015 .45243 L
.38957 .45593 L
.38903 .45967 L
.38855 .46363 L
.38812 .46778 L
.38774 .47211 L
.38741 .47657 L
.38714 .48114 L
.38695 .48553 L
.3868 .48999 L
.38671 .49448 L
.38667 .499 L
.38668 .50352 L
.38675 .50802 L
.38688 .5125 L
.38721 .52001 L
.38755 .52543 L
.38788 .52962 L
.38826 .53367 L
.38869 .53757 L
.38916 .54128 L
.38968 .54479 L
.39024 .54807 L
.39083 .55109 L
.39146 .55384 L
.39202 .55593 L
Mistroke
.3926 .5578 L
.39319 .55943 L
.3938 .56082 L
.39443 .56195 L
.39506 .56284 L
.3957 .56346 L
.39653 .56388 L
.39737 .56388 L
.3982 .56347 L
.39902 .56266 L
.39983 .56148 L
.40062 .55994 L
.40139 .55808 L
.40214 .55592 L
.40293 .5532 L
.40369 .55019 L
.4044 .54693 L
.40506 .54347 L
.40567 .53985 L
.40622 .53609 L
.40672 .53222 L
.40716 .52828 L
.4076 .52367 L
.40796 .519 L
.40824 .5143 L
.40844 .50958 L
.40856 .50484 L
.4086 .5001 L
.40856 .49536 L
.40845 .49062 L
.40821 .48519 L
.40788 .4798 L
.40743 .47446 L
.40689 .4692 L
.40625 .46408 L
.4055 .45913 L
.40467 .45443 L
.40375 .45006 L
.40271 .44598 L
.40179 .44302 L
.40082 .4405 L
.39982 .4385 L
.39879 .43707 L
.39774 .43625 L
.39668 .43609 L
.39562 .4366 L
.39458 .43781 L
.39357 .43969 L
.39259 .44224 L
.39165 .44541 L
Mistroke
.39078 .44915 L
.38997 .45342 L
.38924 .45815 L
.38902 .45974 L
.38882 .46136 L
.38862 .46302 L
.38843 .46471 L
.38825 .46644 L
.38808 .46819 L
.38791 .46998 L
.38769 .47269 L
.38749 .47547 L
.3873 .47828 L
.38714 .48114 L
.38701 .48403 L
.38689 .48696 L
.38677 .4913 L
.38669 .49567 L
.38667 .50006 L
.38669 .50445 L
.38677 .50883 L
.3869 .51317 L
.38708 .51746 L
.38743 .52378 L
.3879 .52988 L
.38847 .5357 L
.38914 .54116 L
.38991 .54618 L
.39075 .5507 L
.39167 .55464 L
.39265 .55795 L
.39368 .56056 L
.39476 .56244 L
.39585 .56357 L
.39618 .56376 L
.39651 .56388 L
.39684 .56393 L
.39717 .56392 L
.3975 .56385 L
.39783 .56371 L
.39816 .5635 L
.39898 .56272 L
.39978 .56156 L
.40057 .56005 L
.40134 .55822 L
.40208 .55609 L
.4028 .5537 L
.40348 .55108 L
.40412 .54826 L
.40473 .54526 L
Mistroke
.4053 .54212 L
.40591 .53827 L
.40646 .53429 L
.40696 .5302 L
.40739 .52604 L
.40775 .52183 L
.40805 .51758 L
.40829 .5133 L
.40844 .50967 L
.40854 .50604 L
.40859 .50241 L
.4086 .49877 L
.40856 .49513 L
.40847 .49149 L
.40834 .48787 L
.40798 .48127 L
.40756 .47584 L
.40703 .47049 L
.4064 .46525 L
.40567 .46019 L
.40485 .45537 L
.40393 .45087 L
.40293 .44678 L
.40185 .44321 L
.40094 .44079 L
.4 .43881 L
.39903 .43734 L
.39804 .43642 L
.39703 .43607 L
.39603 .43632 L
.39504 .43719 L
.39407 .43867 L
.39333 .44024 L
.39261 .44217 L
.39192 .44443 L
.39125 .44702 L
.39063 .44991 L
.39003 .45307 L
.38948 .45649 L
.38888 .46086 L
.38834 .46551 L
.38788 .4704 L
.38748 .47549 L
.38717 .48074 L
.38692 .48611 L
.38676 .49156 L
.38668 .49707 L
.38668 .5034 L
.38679 .50971 L
.38701 .51594 L
Mistroke
.38732 .52204 L
.38774 .52795 L
.38825 .53362 L
.38886 .53898 L
.38955 .54397 L
.38977 .54536 L
.39 .54671 L
.39023 .54802 L
.39047 .54928 L
.39071 .55051 L
.39096 .55168 L
.39122 .55281 L
.39188 .55543 L
.39257 .55772 L
.39329 .55967 L
.39403 .56126 L
.39479 .56249 L
.39556 .56334 L
.39634 .56382 L
.39712 .56393 L
.3979 .56367 L
.39868 .56305 L
.39963 .56182 L
.40055 .5601 L
.40128 .55839 L
.40198 .55641 L
.40266 .55419 L
.40331 .55176 L
.40393 .54915 L
.40451 .54637 L
.40506 .54345 L
.40568 .5398 L
.40623 .53601 L
.40674 .53211 L
.40718 .52814 L
.40756 .5241 L
.40789 .52002 L
.40815 .51592 L
.40836 .51178 L
.4085 .50764 L
.40858 .50349 L
.4086 .49934 L
.40856 .49518 L
.40846 .49103 L
.40825 .48596 L
.40795 .48091 L
.40756 .47591 L
.40709 .47097 L
.40652 .46613 L
.40599 .46228 L
Mistroke
.40541 .45855 L
.40477 .45497 L
.40409 .45157 L
.40335 .4484 L
.40257 .4455 L
.40175 .44291 L
.40089 .44067 L
.40001 .43883 L
.3991 .43743 L
.39817 .43651 L
.39817 .4365 L
.39817 .4365 L
.39816 .4365 L
.39816 .4365 L
.39816 .4365 L
.39816 .4365 L
.39815 .43649 L
.39815 .43649 L
.39811 .43647 L
.39807 .43644 L
.39804 .43642 L
.398 .43639 L
.39764 .43621 L
.39729 .4361 L
.39693 .43606 L
.39657 .43611 L
.39621 .43623 L
.39572 .43653 L
.39523 .43698 L
.39474 .43758 L
.39425 .43833 L
.39378 .43924 L
.39331 .44029 L
.39285 .44148 L
.3924 .44282 L
.39196 .44429 L
.39153 .44589 L
.39112 .44762 L
.39072 .44947 L
.39033 .45143 L
.38996 .4535 L
.38961 .45567 L
.38927 .45794 L
.38895 .4603 L
.38854 .46373 L
.38816 .4673 L
.38783 .47101 L
.38753 .47482 L
.38728 .47872 L
.38707 .4827 L
Mistroke
.3869 .48673 L
.38675 .49193 L
.38668 .49717 L
.38668 .50242 L
.38675 .50766 L
.38689 .51285 L
.3871 .51798 L
.38738 .52301 L
.38789 .52971 L
.38838 .53483 L
.38884 .5388 L
.38934 .54257 L
.38989 .54611 L
.39049 .54939 L
.39112 .55239 L
.39179 .55509 L
.39249 .55746 L
.39321 .55947 L
.39407 .56134 L
.39496 .56271 L
.39586 .56358 L
.39677 .56393 L
.39768 .56378 L
.39859 .56314 L
.39948 .56203 L
.40036 .5605 L
.40121 .55856 L
.40203 .55627 L
.40281 .55365 L
.40377 .54982 L
.40451 .54637 L
.4052 .54271 L
.40582 .53886 L
.40639 .53488 L
.40689 .53079 L
.40733 .52662 L
.40771 .5224 L
.40802 .51813 L
.40826 .51383 L
.40844 .50952 L
.40855 .5052 L
.4086 .49857 L
.40849 .49196 L
.40822 .48536 L
.4079 .48018 L
.40749 .47506 L
.40698 .47 L
.40638 .46506 L
.40569 .46027 L
.40491 .4557 L
Mistroke
.40405 .45141 L
.40311 .44748 L
.40211 .44399 L
.40104 .44103 L
.39993 .43869 L
.39878 .43706 L
.3976 .43619 L
.39642 .43615 L
.39525 .43696 L
.39409 .43862 L
.39298 .44113 L
.39192 .44443 L
.39093 .44847 L
.39002 .45317 L
.3892 .45846 L
.38848 .46424 L
.38788 .47042 L
.38739 .47693 L
.38702 .48368 L
.38678 .49059 L
.38668 .4976 L
.3867 .50463 L
.38685 .51161 L
.38713 .51848 L
.38753 .52516 L
.38805 .53157 L
.3887 .53764 L
.38945 .54327 L
.39029 .54838 L
.39123 .55288 L
.39225 .5567 L
.39333 .55975 L
.39445 .562 L
.39487 .56259 L
.39528 .56308 L
.3957 .56346 L
.39612 .56373 L
.39654 .56388 L
.39696 .56394 L
.39738 .56388 L
.3978 .56372 L
.39815 .5635 L
.3985 .56322 L
.39885 .56286 L
.3992 .56243 L
.39955 .56194 L
.39989 .56138 L
.40023 .56076 L
.40109 .55885 L
.40192 .55658 L
Mistroke
.40272 .55397 L
.40348 .55107 L
.4042 .54791 L
.40486 .54455 L
.40548 .54102 L
.40605 .53734 L
.40633 .5353 L
.4066 .53322 L
.40685 .53111 L
.40709 .52899 L
.40731 .52685 L
.40751 .52469 L
.4077 .52252 L
.40803 .51786 L
.40829 .51318 L
.40848 .50848 L
.40858 .50376 L
.4086 .49904 L
.40855 .49432 L
.40841 .48961 L
.4082 .48491 L
.40776 .47831 L
.40717 .4718 L
.4066 .46676 L
.40593 .46187 L
.40517 .45717 L
.40433 .45274 L
.40341 .44864 L
.40241 .44497 L
.40135 .44182 L
.40087 .44062 L
.40038 .43954 L
.39987 .4386 L
.39936 .43779 L
.39885 .43713 L
.39833 .43663 L
.3978 .43628 L
.39697 .43606 L
.39613 .43627 L
.3953 .43689 L
.39449 .43795 L
.39368 .43943 L
.3929 .44133 L
.39215 .44362 L
.39143 .44629 L
.39067 .44967 L
.38997 .45344 L
.38932 .45756 L
.38874 .462 L
.38822 .46672 L
Mistroke
.38777 .47165 L
.3874 .47678 L
.3871 .48206 L
.38688 .48745 L
.38673 .49291 L
.38667 .49842 L
.3867 .50482 L
.38683 .51118 L
.38708 .51745 L
.38742 .52357 L
.38787 .52949 L
.38841 .53514 L
.38905 .54046 L
.38977 .54539 L
.39 .54674 L
.39023 .54805 L
.39047 .54932 L
.39072 .55054 L
.39097 .55172 L
.39122 .55285 L
.39149 .55394 L
.39215 .55638 L
.39285 .55851 L
.39356 .5603 L
.3943 .56174 L
.39505 .56283 L
.39581 .56354 L
.39658 .5639 L
.39736 .56389 L
.39812 .56353 L
.39889 .56282 L
.39938 .56219 L
.39987 .56142 L
.40034 .56052 L
.40082 .55951 L
.40128 .55837 L
.40174 .55713 L
.4023 .55542 L
.40284 .55355 L
.40336 .55155 L
.40386 .54943 L
.40434 .5472 L
.4048 .54488 L
.40536 .54176 L
.40587 .53853 L
.40634 .5352 L
.40677 .5318 L
.40716 .52834 L
.4075 .52483 L
.40779 .52128 L
Mistroke
.4082 .51496 L
.40821 .51496 L
.40821 .51495 L
.40821 .51494 L
.40821 .51493 L
.40821 .51492 L
.40821 .5149 L
.40821 .51488 L
.40821 .51486 L
.40822 .51468 L
.40823 .51449 L
.40824 .5143 L
.40825 .51412 L
.40833 .5123 L
.40841 .51047 L
.40847 .50864 L
.40852 .50681 L
.40856 .50498 L
.4086 .502 L
.4086 .49902 L
.40857 .49604 L
.40852 .49306 L
.40843 .49009 L
.40831 .48712 L
.40803 .48209 L
.40767 .4771 L
.40732 .47324 L
.40692 .46944 L
.40646 .4657 L
.40605 .46269 L
.4056 .45975 L
.40512 .45689 L
.40461 .45414 L
.40407 .4515 L
.4035 .449 L
.40282 .4464 L
.40212 .44401 L
.40138 .44189 L
.40062 .44006 L
.39984 .43854 L
.39904 .43736 L
.39823 .43655 L
.39741 .43613 L
.39658 .4361 L
.39576 .43649 L
.39495 .4373 L
.39415 .43852 L
.39337 .44015 L
.39295 .44122 L
.39253 .4424 L
Mistroke
.39213 .4437 L
.39173 .44511 L
.39135 .44663 L
.39098 .44824 L
.39036 .45125 L
.38979 .45452 L
.38926 .45803 L
.38877 .46176 L
.38833 .46569 L
.38805 .46845 L
.3878 .47129 L
.38758 .47418 L
.38737 .47714 L
.3872 .48014 L
.38705 .48318 L
.38687 .48758 L
.38675 .49203 L
.38668 .49651 L
.38667 .501 L
.38671 .50549 L
.3868 .50996 L
.38694 .51439 L
.38723 .52048 L
.38762 .5264 L
.38811 .5321 L
.38868 .53752 L
.38935 .54259 L
.39009 .54725 L
.39091 .55144 L
.39179 .5551 L
.39273 .55818 L
.39371 .56062 L
.39473 .56241 L
.39577 .56351 L
.39683 .56393 L
.39789 .56367 L
.39821 .56346 L
.39854 .56318 L
.39886 .56285 L
.39919 .56245 L
.39951 .562 L
.39983 .56149 L
.40014 .56092 L
.40084 .55944 L
.40153 .55771 L
.40219 .55574 L
.40283 .55357 L
.40345 .55121 L
.40403 .54868 L
.40458 .54601 L
Mistroke
.4052 .5427 L
.40576 .53925 L
.40628 .53568 L
.40675 .53203 L
.40716 .5283 L
.40753 .52452 L
.40784 .5207 L
.40818 .51537 L
.40843 .51 L
.40855 .50568 L
.4086 .50136 L
.40859 .49704 L
.40851 .49272 L
.40836 .48841 L
.40815 .48411 L
.40788 .47984 L
.40754 .4756 L
.40703 .47043 L
.40642 .46538 L
.40572 .46048 L
.40493 .45581 L
.40405 .45142 L
.4031 .44741 L
.40207 .44386 L
.40098 .44087 L
.40098 .44087 L
.40097 .44086 L
.40097 .44086 L
.40097 .44085 L
.40097 .44085 L
.40096 .44084 L
.40096 .44083 L
.40095 .44082 L
.40091 .44071 L
.40087 .44061 L
.40082 .44051 L
.40078 .44041 L
.40046 .43971 L
.40013 .43906 L
.3998 .43848 L
.39947 .43795 L
.39914 .43748 L
.39846 .43674 L
.39778 .43627 L
.39726 .43609 L
.39674 .43608 L
.39623 .43622 L
.39571 .43653 L
.39544 .43676 L
.39517 .43704 L
Mistroke
Mfstroke
.02 w
.3925 .4425 Mdot
.5 Mabswid
.39544 .43676 m
.39517 .43704 L
s
% Start of user PostScript
-0.83648496 -0.50589523 -0.83866018 -0.5036682 MAarrowhead1
% End of user PostScript
0 1 .341 r
.32673 .51309 m
.32677 .51454 L
.32683 .51598 L
.32694 .51886 L
.32724 .52443 L
.3276 .52987 L
.32804 .53513 L
.32854 .54019 L
.32911 .545 L
.32974 .54952 L
.33025 .55262 L
.33077 .55553 L
.33133 .55824 L
.33191 .56074 L
.33252 .563 L
.33315 .56503 L
.33379 .56681 L
.33464 .5687 L
.3355 .57017 L
.33639 .57121 L
.33728 .57182 L
.33818 .57202 L
.33907 .57181 L
.33996 .57121 L
.34085 .57026 L
.34172 .56898 L
.34257 .5674 L
.34324 .56593 L
.34389 .56431 L
.34453 .56256 L
.34515 .56069 L
.34575 .55872 L
.34633 .55667 L
.34702 .55404 L
.34767 .55135 L
.34829 .54861 L
.34888 .54583 L
.3496 .54217 L
.35026 .53853 L
.35077 .53552 L
.35123 .53255 L
.35165 .52962 L
.35204 .52676 L
.35239 .52394 L
.35269 .52119 L
.35302 .51794 L
.35328 .51476 L
.3535 .51165 L
.35367 .50859 L
.35378 .50557 L
Mistroke
.35385 .50258 L
.35387 .49997 L
.35385 .49737 L
.35379 .49476 L
.3537 .49212 L
.35357 .48946 L
.3534 .48676 L
.35319 .48402 L
.35294 .48123 L
.35265 .47837 L
.35223 .47474 L
.35186 .47189 L
.35146 .46898 L
.35101 .46602 L
.35052 .46302 L
.35 .45998 L
.34943 .45691 L
.34881 .45384 L
.34798 .44999 L
.34709 .44622 L
.34645 .44376 L
.34578 .44138 L
.34508 .4391 L
.34436 .43697 L
.34362 .43499 L
.34285 .4332 L
.34207 .43164 L
.34126 .43031 L
.34045 .42926 L
.33962 .42851 L
.33927 .42829 L
.33892 .42813 L
.33857 .42803 L
.33822 .42798 L
.33787 .428 L
.33753 .42808 L
.33718 .42822 L
.33607 .42911 L
.33498 .43066 L
.33392 .43288 L
.3329 .43574 L
.33193 .43922 L
.33101 .44327 L
.33017 .44784 L
.3294 .45288 L
.32871 .45833 L
.3281 .46413 L
.32759 .47021 L
.32718 .47652 L
.32687 .48301 L
Mistroke
.32665 .48962 L
.32656 .49472 L
.32653 .49983 L
.32656 .50495 L
.32664 .51004 L
.32679 .51509 L
.327 .52008 L
.32727 .52499 L
.32768 .53091 L
.32787 .53321 L
.32807 .53547 L
.32828 .53769 L
.32851 .53986 L
.32874 .542 L
.32899 .54408 L
.32962 .5487 L
.33031 .55299 L
.33105 .55693 L
.33185 .56046 L
.33269 .56357 L
.33356 .56621 L
.33447 .56837 L
.33532 .56989 L
.33618 .57101 L
.33705 .57171 L
.33793 .57201 L
.3388 .57191 L
.33968 .57144 L
.34055 .57062 L
.34159 .56919 L
.3426 .56732 L
.34359 .56508 L
.34454 .56253 L
.34545 .55972 L
.34632 .55671 L
.34714 .55356 L
.34791 .55031 L
.34864 .547 L
.34931 .54366 L
.34994 .54033 L
.35052 .53703 L
.35104 .53377 L
.3514 .53137 L
.35174 .52902 L
.35205 .52669 L
.35233 .52441 L
.35259 .52216 L
.35282 .51995 L
.35296 .51854 L
.35309 .51714 L
Mistroke
.3532 .51576 L
.35331 .51439 L
.35341 .51303 L
.3535 .51169 L
.35358 .51035 L
.35373 .50706 L
.35383 .5038 L
.35387 .50057 L
.35385 .49735 L
.35377 .4941 L
.35364 .49083 L
.35345 .4875 L
.35319 .48411 L
.35293 .48112 L
.35261 .47806 L
.35225 .47493 L
.35184 .47173 L
.35138 .46846 L
.35087 .46512 L
.3503 .46173 L
.34969 .4583 L
.34915 .45549 L
.34857 .45268 L
.34796 .44989 L
.34731 .44714 L
.34663 .44446 L
.34592 .44186 L
.34517 .43939 L
.34455 .43749 L
.3439 .43571 L
.34323 .43406 L
.34255 .43258 L
.34186 .43127 L
.34115 .43015 L
.34043 .42925 L
.3398 .42865 L
.33916 .42824 L
.33852 .42802 L
.33788 .428 L
.33724 .42819 L
.3366 .4286 L
.33584 .42938 L
.33509 .43047 L
.33435 .43189 L
.33363 .43361 L
.33293 .43564 L
.33225 .43797 L
.3316 .44057 L
.33111 .44277 L
.33065 .44513 L
Mistroke
.3302 .44763 L
.32978 .45026 L
.32938 .45302 L
.329 .45589 L
.32877 .45781 L
.32854 .45977 L
.32833 .46177 L
.32813 .46381 L
.32794 .46589 L
.32777 .46799 L
.3276 .47013 L
.32725 .4754 L
.32696 .4808 L
.32675 .4863 L
.3266 .49187 L
.32654 .49748 L
.32654 .5031 L
.32662 .5087 L
.32677 .51426 L
.32691 .51802 L
.32708 .52173 L
.32729 .52539 L
.32753 .52899 L
.32781 .53251 L
.32811 .53595 L
.32844 .5393 L
.32902 .54427 L
.32966 .54895 L
.33036 .55329 L
.33112 .55726 L
.33193 .56081 L
.33279 .56392 L
.33369 .56654 L
.33462 .56866 L
.33581 .57059 L
.33704 .5717 L
.3381 .57202 L
.33916 .57177 L
.34021 .57098 L
.34125 .56971 L
.34226 .568 L
.34325 .56591 L
.3442 .56349 L
.34511 .5608 L
.34599 .5579 L
.34682 .55483 L
.3476 .55165 L
.34834 .5484 L
.34903 .54511 L
.34967 .54181 L
Mistroke
.35005 .53972 L
.35041 .53764 L
.35076 .53557 L
.35108 .53352 L
.35139 .5315 L
.35167 .52949 L
.35194 .52752 L
.35246 .52331 L
.35289 .51922 L
.35325 .51524 L
.35352 .51137 L
.35371 .50758 L
.35383 .50384 L
.35387 .50013 L
.35383 .49643 L
.35374 .49313 L
.35359 .4898 L
.35337 .4864 L
.35309 .48294 L
.35275 .47939 L
.35235 .47575 L
.35188 .47201 L
.35134 .46817 L
.35054 .46311 L
.34993 .45964 L
.34928 .45613 L
.34856 .45263 L
.34779 .44916 L
.34697 .44576 L
.34609 .44248 L
.34517 .43937 L
.3442 .43651 L
.34318 .43394 L
.34213 .43176 L
.34105 .43001 L
.33994 .42877 L
.33882 .42809 L
.33769 .42803 L
.33657 .42862 L
.33546 .42989 L
.33438 .43182 L
.33333 .43443 L
.33233 .43767 L
.33138 .44152 L
.3305 .44592 L
.32969 .45082 L
.32896 .45616 L
.32832 .46188 L
.32777 .46791 L
.32732 .4742 L
Mistroke
.327 .47997 L
.32676 .48585 L
.32661 .49182 L
.32653 .49784 L
.32655 .50387 L
.32664 .50988 L
.32682 .51583 L
.32719 .52364 L
.32751 .52869 L
.3279 .5336 L
.32834 .53834 L
.32885 .54288 L
.32941 .54719 L
.33002 .55124 L
.33067 .555 L
.33138 .55844 L
.33182 .56037 L
.33228 .56216 L
.33276 .56381 L
.33325 .56532 L
.33374 .56668 L
.33425 .56789 L
.33476 .56895 L
.33577 .57053 L
.33679 .57154 L
.33783 .57199 L
.33886 .57189 L
.33989 .57127 L
.34091 .57018 L
.34191 .56864 L
.34288 .56673 L
.34383 .56448 L
.34474 .56195 L
.34561 .55919 L
.34644 .55626 L
.34723 .5532 L
.34797 .55005 L
.34833 .54845 L
.34867 .54685 L
.349 .54524 L
.34932 .54363 L
.34963 .54202 L
.34993 .54041 L
.35021 .53881 L
.35103 .53382 L
.35175 .52896 L
.35235 .52425 L
.35285 .51969 L
.35324 .51528 L
.35354 .51099 L
Mistroke
.35374 .5068 L
.35384 .50336 L
.35387 .49994 L
.35384 .49652 L
.35374 .49308 L
.35357 .48959 L
.35334 .48604 L
.35305 .48242 L
.35268 .47869 L
.35224 .47487 L
.35173 .47094 L
.35115 .4669 L
.35029 .46167 L
.34977 .45876 L
.34921 .45582 L
.34862 .45289 L
.34798 .44998 L
.3473 .44711 L
.34659 .44431 L
.34585 .44161 L
.34506 .43904 L
.34446 .43724 L
.34384 .43556 L
.34321 .434 L
.34256 .43258 L
.34189 .43133 L
.34122 .43025 L
.34054 .42936 L
.33965 .42854 L
.33876 .42807 L
.33807 .42798 L
.33737 .42813 L
.33668 .42853 L
.336 .42919 L
.33532 .4301 L
.33466 .43126 L
.33385 .43305 L
.33307 .43521 L
.33231 .43774 L
.33207 .43863 L
.33184 .43956 L
.33161 .44052 L
.33139 .44151 L
.33116 .44254 L
.33095 .4436 L
.33073 .44469 L
.32981 .45003 L
.32899 .45592 L
.32828 .46228 L
.32768 .46903 L
Mistroke
.32721 .47608 L
.32685 .48336 L
.32663 .49078 L
.32653 .49829 L
.32654 .5037 L
.32662 .50909 L
.32677 .51444 L
.32698 .51971 L
.32726 .5249 L
.32761 .52996 L
.32801 .53488 L
.32848 .53961 L
.32914 .54518 L
.32988 .55036 L
.33044 .55376 L
.33105 .55691 L
.33169 .5598 L
.33235 .56241 L
.33305 .56473 L
.33377 .56674 L
.3345 .56843 L
.33516 .56964 L
.33582 .5706 L
.33649 .57131 L
.33717 .57177 L
.33785 .572 L
.33853 .57198 L
.33921 .57174 L
.33988 .57128 L
.34055 .57062 L
.34158 .5692 L
.34258 .56737 L
.34356 .56517 L
.34449 .56266 L
.34539 .55991 L
.34625 .55696 L
.34706 .55387 L
.34783 .55067 L
.34855 .54741 L
.34922 .54413 L
.34985 .54085 L
.35042 .53758 L
.35095 .53436 L
.35132 .53194 L
.35166 .52955 L
.35198 .5272 L
.35227 .52488 L
.35254 .52261 L
.35278 .52037 L
.35292 .51895 L
Mistroke
.35305 .51754 L
.35317 .51614 L
.35328 .51476 L
.35339 .51339 L
.35348 .51203 L
.35356 .51069 L
.35372 .50738 L
.35382 .50412 L
.35387 .50088 L
.35385 .49765 L
.35378 .4944 L
.35365 .49112 L
.35347 .48779 L
.35322 .4844 L
.35295 .48139 L
.35264 .47832 L
.35228 .47517 L
.35187 .47195 L
.35141 .46867 L
.3509 .46531 L
.35033 .4619 L
.34972 .45845 L
.34918 .45563 L
.3486 .45282 L
.34799 .45002 L
.34734 .44726 L
.34666 .44457 L
.34595 .44196 L
.3452 .43948 L
.34458 .43757 L
.34393 .43579 L
.34327 .43414 L
.34259 .43265 L
.3419 .43133 L
.34119 .43021 L
.34048 .4293 L
.33984 .42868 L
.33921 .42826 L
.33857 .42803 L
.33792 .42799 L
.33728 .42817 L
.33665 .42856 L
.33588 .42933 L
.33512 .43041 L
.33438 .43182 L
.33366 .43354 L
.33295 .43557 L
.33227 .4379 L
.33161 .44051 L
.33114 .44264 L
Mistroke
.33069 .44491 L
.33026 .44732 L
.32984 .44986 L
.32945 .45251 L
.32908 .45528 L
.3288 .45749 L
.32855 .45975 L
.3283 .46207 L
.32808 .46443 L
.32786 .46685 L
.32784 .46709 L
.32782 .46733 L
.3278 .46758 L
.32778 .46782 L
.32778 .46785 L
.32778 .46787 L
.32777 .4679 L
.32777 .46791 L
.32777 .46792 L
.32777 .46793 L
.32777 .46795 L
.32777 .46796 L
.32717 .47678 L
.32697 .48066 L
.3268 .4846 L
.32668 .48857 L
.32659 .49258 L
.32654 .49661 L
.32653 .50064 L
.32655 .50467 L
.32664 .50998 L
.3268 .51524 L
.32702 .52043 L
.3273 .52552 L
.32765 .5305 L
.32805 .53532 L
.32852 .53997 L
.32894 .54363 L
.3294 .54713 L
.32989 .55046 L
.33042 .5536 L
.33097 .55654 L
.33156 .55925 L
.33217 .56173 L
.33273 .56371 L
.3333 .56549 L
.33389 .56706 L
.3345 .56842 L
.33511 .56956 L
.33573 .57049 L
Mistroke
.3365 .57132 L
.33727 .57182 L
.33805 .57202 L
.33883 .5719 L
.33977 .57138 L
.34057 .57059 L
.34137 .56952 L
.34216 .5682 L
.34293 .56664 L
.34367 .56487 L
.3444 .56292 L
.34511 .56082 L
.34579 .5586 L
.34644 .55626 L
.34707 .55385 L
.34767 .55138 L
.34824 .54886 L
.34894 .54552 L
.3496 .54217 L
.35034 .53805 L
.35063 .53634 L
.35091 .53464 L
.35117 .53296 L
.35142 .53129 L
.35165 .52964 L
.35187 .52801 L
.35209 .5264 L
.35258 .52221 L
.353 .51814 L
.35333 .51419 L
.35358 .51033 L
.35375 .50654 L
.35385 .50281 L
.35387 .49909 L
.35381 .49537 L
.3537 .49218 L
.35354 .48895 L
.35332 .48566 L
.35304 .48231 L
.3527 .47887 L
.3523 .47535 L
.35184 .47173 L
.35132 .46802 L
.35072 .46423 L
.35007 .46038 L
.34934 .45649 L
.34884 .45398 L
.34831 .45147 L
.34775 .44899 L
.34717 .44655 L
Mistroke
.34656 .44416 L
.34592 .44185 L
.34525 .43963 L
.34456 .43754 L
.34377 .43537 L
.34295 .43341 L
.3421 .4317 L
.34124 .43028 L
.34036 .42917 L
.33947 .42841 L
.33857 .42803 L
.33767 .42804 L
.33653 .42866 L
.3354 .42998 L
.3343 .43199 L
.33379 .43321 L
.33328 .43458 L
.33278 .43611 L
.3323 .43779 L
.33183 .43961 L
.33137 .44157 L
.33093 .44366 L
.33072 .44475 L
.33051 .44588 L
.33031 .44703 L
.3301 .44822 L
.32991 .44943 L
.32972 .45067 L
.32953 .45193 L
.32868 .45858 L
.32796 .46575 L
.32738 .47332 L
.32694 .4812 L
.32666 .48929 L
.32655 .49539 L
.32653 .50152 L
.3266 .50763 L
.32675 .51371 L
.32698 .5197 L
.3273 .52557 L
.32771 .53128 L
.32819 .53678 L
.32875 .54204 L
.32938 .54701 L
.33008 .55163 L
.3307 .55515 L
.33136 .55838 L
.33206 .56131 L
.33279 .56391 L
.33355 .56617 L
Mistroke
.33433 .56806 L
.33513 .56959 L
.33575 .57051 L
.33638 .5712 L
.33701 .57169 L
.33765 .57195 L
.33828 .57201 L
.33892 .57187 L
.33929 .5717 L
.33966 .57146 L
.34002 .57116 L
.34039 .5708 L
.34075 .57038 L
.34079 .57033 L
.34083 .57028 L
.34087 .57023 L
.34091 .57018 L
.34091 .57018 L
.34091 .57017 L
.34092 .57017 L
.34092 .57016 L
.34092 .57016 L
.34092 .57016 L
.34093 .57016 L
.34093 .57015 L
.34192 .56863 L
.34289 .56672 L
.34416 .56359 L
.34537 .55998 L
.34651 .55602 L
.34698 .5542 L
.34744 .55233 L
.34789 .55044 L
.34831 .54853 L
.34872 .5466 L
.34912 .54467 L
.34949 .54273 L
.34968 .54177 L
.34985 .5408 L
.35003 .53984 L
.3502 .53888 L
.35036 .53792 L
.35053 .53697 L
.35068 .53602 L
.35141 .53133 L
.35204 .52678 L
.35268 .52134 L
.35318 .5161 L
.35354 .51104 L
.35374 .50699 L
Mistroke
.35384 .503 L
.35387 .49903 L
.3538 .49505 L
.35365 .49104 L
.35341 .48694 L
.35308 .48275 L
.35265 .47843 L
.35213 .47397 L
.35169 .47064 L
.3512 .46723 L
.35065 .46376 L
.35004 .46023 L
.34938 .45668 L
.34866 .45311 L
.34789 .44957 L
.34706 .4461 L
.34617 .44275 L
.34546 .4403 L
.34472 .43799 L
.34395 .43584 L
.34316 .43388 L
.34234 .43215 L
.3415 .43068 L
.34065 .4295 L
.33979 .42864 L
.33941 .42838 L
.33904 .42818 L
.33866 .42805 L
.33829 .42799 L
.33791 .428 L
.33753 .42808 L
.33716 .42823 L
.33693 .42836 L
.3367 .42853 L
.33647 .42872 L
.33624 .42893 L
.33601 .42918 L
.33578 .42946 L
.33555 .42976 L
.33532 .4301 L
.33403 .43262 L
.33279 .43609 L
.33162 .44047 L
.33055 .44567 L
.32958 .4516 L
.32873 .45815 L
.328 .46521 L
.32754 .47088 L
.32717 .47674 L
.32688 .48275 L
Mistroke
.32667 .48887 L
.32656 .49506 L
.32653 .50127 L
.32659 .50748 L
.32674 .51364 L
.32698 .51972 L
.32727 .52494 L
.32761 .53003 L
.32802 .53497 L
.32849 .53972 L
.32902 .54426 L
.3296 .54856 L
.33024 .55258 L
.33092 .55629 L
.33129 .55806 L
.33167 .55974 L
.33206 .56132 L
.33246 .5628 L
.33287 .56418 L
.33329 .56545 L
.33372 .56662 L
.33415 .56767 L
.33538 .56999 L
.33664 .57143 L
.33791 .572 L
.33919 .57175 L
.34046 .57072 L
.34171 .56899 L
.34292 .56666 L
.34408 .56382 L
.34519 .56058 L
.34647 .55614 L
.34766 .55141 L
.34847 .54782 L
.34921 .54419 L
.3499 .54057 L
.35053 .53697 L
.3511 .53342 L
.35161 .52994 L
.35207 .52654 L
.35247 .52321 L
.35282 .51996 L
.35312 .51679 L
.35336 .51368 L
.3536 .50997 L
.35379 .50526 L
.35386 .50222 L
.35387 .4992 L
.35383 .49617 L
.35374 .49312 L
Mistroke
.3536 .49004 L
.35341 .48691 L
.35316 .48372 L
.35296 .48149 L
.35274 .47923 L
.35249 .47692 L
.35221 .47458 L
.3519 .4722 L
.35157 .46977 L
.35139 .46855 L
.35121 .46731 L
.35102 .46607 L
.35082 .46482 L
.35061 .46356 L
.3505 .46287 L
.35038 .46217 L
.35026 .46147 L
.35014 .46077 L
.35009 .46052 L
.35005 .46028 L
.35001 .46003 L
.35 .46002 L
.35 .46 L
.35 .45998 L
.34999 .45997 L
.34995 .45972 L
.34991 .45948 L
.34986 .45923 L
.34973 .45853 L
.3496 .45783 L
.34947 .45712 L
.34933 .45642 L
.34908 .45515 L
.34882 .45387 L
.34856 .4526 L
.34828 .45134 L
.348 .45008 L
.34746 .44775 L
.34689 .44545 L
.3463 .44322 L
.34583 .44153 L
.34534 .4399 L
.34483 .43833 L
.34432 .43683 L
.34389 .43568 L
.34345 .43458 L
.34301 .43355 L
.34256 .43259 L
.3421 .4317 L
.3415 .43067 L
Mistroke
.34088 .42978 L
.34026 .42906 L
.33963 .42852 L
.339 .42816 L
.33836 .42799 L
.33761 .42806 L
.33686 .42841 L
.33612 .42906 L
.33538 .43 L
.33466 .43125 L
.33395 .4328 L
.33318 .43486 L
.33244 .43726 L
.33185 .43951 L
.33129 .44197 L
.33074 .44463 L
.33023 .44749 L
.32974 .45053 L
.32928 .45373 L
.32885 .45709 L
.32832 .46187 L
.32786 .46688 L
.32746 .47207 L
.32713 .47741 L
.32687 .48287 L
.32668 .48842 L
.32657 .49403 L
.32653 .49967 L
.32658 .50686 L
.32676 .51399 L
.32705 .52101 L
.32745 .52785 L
.32797 .53445 L
.3286 .54073 L
.32933 .54662 L
.33015 .55205 L
.33035 .55324 L
.33056 .5544 L
.33077 .55553 L
.33099 .55662 L
.33121 .55769 L
.33144 .55872 L
.33167 .55971 L
.33239 .56255 L
.33315 .56504 L
.33394 .56717 L
.33475 .56891 L
.33541 .57004 L
.33608 .57091 L
.33676 .57153 L
Mistroke
.33745 .57189 L
.33814 .57202 L
.33883 .5719 L
.3397 .57143 L
.34057 .5706 L
.34125 .56971 L
.34192 .56863 L
.34258 .56737 L
.34323 .56595 L
.34386 .5644 L
.34448 .56271 L
.34508 .56092 L
.34585 .55838 L
.34659 .55572 L
.34729 .55295 L
.34796 .55012 L
.34859 .54724 L
.34918 .54434 L
.34974 .54145 L
.35025 .53856 L
.35113 .53319 L
.35173 .52911 L
.35224 .52513 L
.35268 .52127 L
.35305 .51751 L
.35335 .51384 L
.35358 .51026 L
.35374 .50674 L
.35384 .50326 L
.35387 .4998 L
.35383 .49634 L
.35373 .49286 L
.35353 .4889 L
.35325 .48486 L
.35289 .4807 L
.35243 .47642 L
.35188 .47201 L
.35123 .46745 L
.35048 .46278 L
.34964 .45802 L
.34933 .45641 L
.34901 .45479 L
.34868 .45317 L
.34833 .45156 L
.34798 .44996 L
.34761 .44837 L
.34723 .4468 L
.34638 .44351 L
.34548 .44037 L
.34453 .43745 L
Mistroke
.34354 .4348 L
.34251 .4325 L
.34145 .4306 L
.34037 .42918 L
.33926 .42829 L
.33778 .42802 L
.3363 .42887 L
.33629 .42887 L
.33629 .42888 L
.33629 .42888 L
.33629 .42888 L
.33629 .42888 L
.33628 .42889 L
.33628 .42889 L
.33627 .4289 L
.33623 .42894 L
.33619 .42898 L
.33614 .42903 L
.3361 .42907 L
.33568 .42959 L
.33526 .4302 L
.33484 .43092 L
.33442 .43173 L
.33402 .43264 L
.33351 .43394 L
.333 .4354 L
.33252 .43701 L
.33204 .43877 L
.33158 .44067 L
.33113 .4427 L
.33052 .44584 L
.32994 .44922 L
.3294 .45283 L
.32891 .45664 L
.32845 .46063 L
.32804 .46478 L
.32768 .46908 L
.32736 .47349 L
.3271 .47801 L
.32689 .48249 L
.32672 .48703 L
.32661 .49161 L
.32654 .49622 L
.32653 .50085 L
.32656 .50547 L
.32665 .51008 L
.32693 .51846 L
.32693 .51847 L
.32693 .51849 L
.32693 .5185 L
Mistroke
.32693 .51851 L
.32693 .51852 L
.32693 .51855 L
.32693 .51857 L
.32693 .51859 L
.32694 .51884 L
.32696 .51908 L
.32697 .51932 L
.32698 .51957 L
.3271 .52198 L
.32723 .52437 L
.32738 .52674 L
.32754 .52907 L
.32772 .53138 L
.32795 .53419 L
.32821 .53695 L
.32848 .53964 L
.32877 .54226 L
.32909 .5448 L
.32946 .54757 L
.32986 .55023 L
.33027 .55277 L
.33071 .55518 L
.33116 .55745 L
.33164 .55958 L
.33229 .56219 L
.33298 .56452 L
.33369 .56654 L
.33442 .56825 L
.33516 .56965 L
.33592 .57072 L
.33669 .57147 L
.33733 .57185 L
.33797 .57201 L
.33861 .57197 L
.33925 .57172 L
.33989 .57128 L
.34052 .57066 L
.34123 .56973 L
.34194 .5686 L
.34263 .56727 L
.3433 .56578 L
.34396 .56413 L
.34461 .56234 L
.34523 .56043 L
.34598 .55794 L
.34669 .55532 L
.34737 .55262 L
.34802 .54985 L
.34863 .54705 L
Mistroke
.3492 .54422 L
.34974 .5414 L
.35036 .53793 L
.35093 .53449 L
.35144 .53112 L
.3519 .52781 L
.35231 .52458 L
.35267 .52142 L
.35298 .51833 L
.35324 .5153 L
.35348 .51191 L
.35367 .50858 L
.35379 .5053 L
.35386 .50204 L
.35387 .4988 L
.35382 .49555 L
.35371 .49228 L
.35354 .48896 L
.35345 .48761 L
.35336 .48623 L
.35325 .48485 L
.35314 .48346 L
.35301 .48205 L
.35288 .48063 L
.35273 .47919 L
.35249 .47692 L
.35221 .47462 L
.35191 .47227 L
.35159 .46989 L
.35123 .46747 L
.35085 .46502 L
.35031 .46177 L
.34972 .45848 L
.34909 .45518 L
.3484 .45188 L
.34783 .44931 L
.34723 .44678 L
.34659 .44431 L
.34594 .44192 L
.34525 .43963 L
.34454 .43746 L
.3438 .43545 L
.34304 .43363 L
.34227 .43201 L
.34147 .43063 L
.34066 .42951 L
.33984 .42868 L
.33901 .42816 L
.33818 .42798 L
.33734 .42815 L
Mistroke
.33667 .42855 L
.336 .42918 L
.33534 .43007 L
.33469 .43119 L
.33405 .43255 L
.33343 .43416 L
.33269 .43642 L
.33198 .43902 L
.33129 .44193 L
.33065 .44514 L
.33004 .44861 L
.32947 .45234 L
.32895 .45629 L
.32841 .46101 L
.32794 .46595 L
.32753 .47108 L
.32719 .47637 L
.32692 .48178 L
.32672 .48729 L
.32659 .49286 L
.32653 .49846 L
.32656 .50557 L
.32671 .51264 L
.32698 .5196 L
.32736 .52641 L
.32785 .53298 L
.32844 .53927 L
.32914 .5452 L
.32993 .55069 L
.33013 .55191 L
.33033 .5531 L
.33053 .55426 L
.33075 .55539 L
.33096 .55648 L
.33118 .55755 L
.33141 .55858 L
.33208 .5614 L
.33279 .5639 L
.33352 .56609 L
.33427 .56795 L
.33505 .56945 L
.33583 .57062 L
.33663 .57143 L
.33744 .57189 L
.33825 .57202 L
.33906 .57181 L
.34013 .57107 L
.34099 .57007 L
.34185 .56875 L
.34269 .56715 L
Mistroke
.3435 .5653 L
.34429 .56323 L
.34506 .56098 L
.34579 .55857 L
.3465 .55605 L
.34717 .55343 L
.34782 .55074 L
.3486 .54719 L
.34933 .5436 L
.35 .54002 L
.35051 .53707 L
.35098 .53416 L
.35142 .53128 L
.35181 .52846 L
.35217 .52568 L
.3525 .52296 L
.35279 .5203 L
.35309 .51708 L
.35335 .51392 L
.35355 .51083 L
.3537 .50779 L
.35381 .50479 L
.35386 .5018 L
.35387 .49883 L
.35382 .49585 L
.35373 .49285 L
.35359 .48982 L
.35324 .48466 L
.35289 .48071 L
.35255 .47751 L
.35216 .47424 L
.35172 .47088 L
.35123 .46745 L
.35068 .46396 L
.35007 .46041 L
.34941 .45682 L
.34869 .45323 L
.34791 .44966 L
.34707 .44616 L
.34618 .44278 L
.3451 .43916 L
.34396 .43587 L
.34276 .43301 L
.34208 .43166 L
.34139 .4305 L
.34068 .42954 L
.33997 .42879 L
.33925 .42828 L
.33853 .42802 L
.3378 .42801 L
Mistroke
.33675 .42849 L
.3357 .42955 L
.33468 .43121 L
.33368 .43347 L
.33273 .4363 L
.33181 .43967 L
.33095 .44356 L
.33016 .44791 L
.32942 .45268 L
.32877 .45781 L
.32819 .46326 L
.32804 .46486 L
.32789 .46649 L
.32776 .46813 L
.32763 .46978 L
.3275 .47146 L
.32739 .47315 L
.32728 .47486 L
.32699 .48017 L
.32677 .48558 L
.32662 .49107 L
.32654 .49659 L
.32653 .50214 L
.3266 .50767 L
.32673 .51317 L
.32704 .52078 L
.32737 .5266 L
.32771 .53125 L
.32809 .53576 L
.32853 .54011 L
.32902 .54428 L
.32956 .54824 L
.33014 .55197 L
.33076 .55544 L
.33142 .55863 L
.33196 .5609 L
.33251 .56299 L
.33309 .56486 L
.33368 .56653 L
.33429 .56798 L
.33491 .56921 L
.33554 .57022 L
.33645 .57127 L
.33737 .57186 L
.3383 .57201 L
.33923 .57173 L
.34015 .57104 L
.34106 .56998 L
.34195 .56858 L
.34282 .56686 L
Mistroke
.34389 .56431 L
.34492 .56141 L
.34589 .55824 L
.34681 .55485 L
.34768 .55133 L
.34849 .54772 L
.34923 .54407 L
.34992 .54042 L
.35055 .53681 L
.35112 .53324 L
.35164 .52975 L
.35209 .52633 L
.3525 .52299 L
.35284 .51973 L
.35317 .5162 L
.35343 .51275 L
.35363 .50938 L
.35377 .50605 L
.35385 .50276 L
.35387 .49949 L
.35383 .49622 L
.35373 .49292 L
.35357 .48958 L
.35319 .484 L
.35263 .47821 L
.35204 .47326 L
.35133 .46813 L
.35067 .46391 L
.34993 .45961 L
.34911 .45527 L
.3482 .45094 L
.3472 .44669 L
.34613 .4426 L
.34498 .43878 L
.34376 .43534 L
.34271 .4329 L
.34163 .43088 L
.34051 .42934 L
.33938 .42836 L
.33824 .42798 L
.33709 .42827 L
.33596 .42923 L
.33485 .4309 L
.33377 .43326 L
.33273 .43629 L
.33174 .43997 L
.33082 .44423 L
.32997 .44903 L
.3292 .45431 L
.32898 .45605 L
Mistroke
.32876 .45783 L
.32856 .45965 L
.32836 .4615 L
.32817 .46338 L
.328 .46529 L
.32783 .46723 L
.32756 .47066 L
.32732 .47415 L
.32711 .47771 L
.32694 .48132 L
.32679 .48497 L
.32668 .48865 L
.32658 .49334 L
.32653 .49806 L
.32654 .50278 L
.32659 .50749 L
.3267 .51217 L
.32686 .51681 L
.32707 .52139 L
.32751 .5286 L
.32796 .53427 L
.32849 .53972 L
.3291 .54488 L
.32978 .54972 L
.33052 .55418 L
.33133 .55822 L
.33219 .5618 L
.3331 .56488 L
.33415 .56768 L
.33525 .56979 L
.33637 .5712 L
.33751 .57191 L
.33865 .57196 L
.33979 .57136 L
.34092 .57017 L
.34202 .56844 L
.34309 .56626 L
.34345 .56542 L
.3438 .56454 L
.34415 .56362 L
.34449 .56266 L
.34483 .56167 L
.34516 .56064 L
.34549 .55959 L
.34581 .55851 L
.3466 .55567 L
.34735 .55271 L
.34806 .54967 L
.34872 .54659 L
.34935 .54349 L
Mistroke
.34993 .5404 L
.35047 .53733 L
.35112 .53325 L
.35161 .52992 L
.35198 .52723 L
.35231 .5246 L
.3526 .52202 L
.35287 .51948 L
.3531 .51699 L
.3533 .51455 L
.35347 .51214 L
.35361 .50976 L
.35368 .50826 L
.35374 .50678 L
.35379 .5053 L
.35383 .50383 L
.35385 .50236 L
.35387 .5009 L
.35387 .49943 L
.35385 .49703 L
.35379 .49462 L
.3537 .49219 L
.35358 .48974 L
.35343 .48725 L
.35324 .48473 L
.35299 .48179 L
.35269 .47878 L
.35234 .47571 L
.35195 .47257 L
.35151 .46936 L
.35102 .46608 L
.35048 .46275 L
.34981 .45897 L
.34908 .45516 L
.34829 .45136 L
.34759 .4483 L
.34686 .44531 L
.34608 .44241 L
.34526 .43966 L
.34441 .43708 L
.34352 .43474 L
.3426 .43267 L
.34165 .43092 L
.34068 .42954 L
.3397 .42857 L
.33871 .42806 L
.33771 .42803 L
.33671 .42851 L
.33572 .42952 L
.33475 .43107 L
Mistroke
.33381 .43315 L
.3329 .43574 L
.33203 .43882 L
.3312 .44238 L
.33042 .44636 L
.32971 .45072 L
.32906 .45544 L
.32847 .46046 L
.32796 .46574 L
.32752 .47124 L
.32716 .47691 L
.32688 .48273 L
.32668 .48864 L
.32656 .49462 L
.32653 .50063 L
.3266 .50776 L
.32678 .51483 L
.32709 .52178 L
.3275 .52854 L
.32803 .53506 L
.32866 .54126 L
.32939 .54707 L
.33021 .55242 L
.33041 .55359 L
.33062 .55472 L
.33083 .55582 L
.33105 .5569 L
.33127 .55794 L
.33149 .55895 L
.33172 .55992 L
.33247 .56282 L
.33325 .56534 L
.33407 .56748 L
.33476 .56894 L
.33546 .57012 L
.33618 .57101 L
.3369 .57162 L
.33763 .57195 L
.33836 .57201 L
.3392 .57175 L
.34003 .57115 L
.34071 .57043 L
.34139 .5695 L
.34205 .56839 L
.34271 .56711 L
.34335 .56567 L
.34397 .5641 L
.34458 .56241 L
.34538 .55997 L
.34614 .55737 L
Mistroke
.34686 .55466 L
.34756 .55185 L
.34821 .54899 L
.34883 .5461 L
.34941 .54319 L
.34995 .54029 L
.35069 .536 L
.35134 .53179 L
.35192 .52767 L
.35242 .52367 L
.35284 .51979 L
.35318 .516 L
.35346 .51231 L
.35366 .5087 L
.35381 .50461 L
.35387 .50126 L
.35386 .49791 L
.35379 .49456 L
.35366 .49117 L
.35346 .48773 L
.3532 .48421 L
.35288 .48062 L
.35243 .47641 L
.35188 .47206 L
.35125 .46758 L
.35052 .46299 L
.34969 .45831 L
.34876 .4536 L
.34793 .44976 L
.34703 .446 L
.34607 .44238 L
.34505 .43898 L
.34397 .43588 L
.34284 .43317 L
.34166 .43094 L
.34046 .42928 L
.33944 .42839 L
.33841 .428 L
.33738 .42813 L
.33636 .42881 L
.33535 .43005 L
.33436 .43186 L
.3334 .43422 L
.33248 .43712 L
.33161 .44053 L
.33079 .44441 L
.33002 .44873 L
.32925 .45398 L
.32856 .45965 L
.32796 .46567 L
Mistroke
.32747 .47197 L
.32707 .4785 L
.32678 .4852 L
.3266 .49201 L
.32653 .49888 L
.32657 .50576 L
.32671 .51259 L
.32697 .51933 L
.32714 .52282 L
.32735 .52627 L
.32758 .52965 L
.32785 .53297 L
.32814 .53621 L
.32845 .53937 L
.3288 .54244 L
.32903 .54439 L
.32928 .54629 L
.32954 .54815 L
.32981 .54995 L
.33009 .5517 L
.33038 .55339 L
.33099 .5566 L
.33163 .55955 L
.3323 .56221 L
.333 .56458 L
.33372 .56663 L
.33447 .56836 L
.33523 .56976 L
.33635 .57118 L
.33748 .57191 L
.33839 .572 L
.33929 .5717 L
.34019 .571 L
.34108 .56995 L
.34195 .56857 L
.3428 .5669 L
.34363 .56497 L
.34444 .56282 L
.34488 .56154 L
.3453 .5602 L
.34572 .55882 L
.34613 .55739 L
.34653 .55593 L
.34692 .55444 L
.3473 .55293 L
.34806 .54969 L
.34877 .54639 L
.34943 .54307 L
.35004 .53976 L
.35061 .53649 L
Mistroke
.35112 .53325 L
.35159 .53007 L
.35201 .52696 L
.35239 .52391 L
.35272 .52092 L
.35301 .518 L
.35325 .51514 L
.35346 .51233 L
.35358 .51029 L
.35368 .50828 L
.35376 .50628 L
.35382 .50429 L
.35385 .50231 L
.35387 .50034 L
.35385 .49749 L
.35379 .49463 L
.35368 .49175 L
.35353 .48883 L
.35333 .48587 L
.35309 .48284 L
.35279 .47976 L
.35245 .4766 L
.35206 .47337 L
.35161 .47007 L
.35111 .4667 L
.35056 .46326 L
.34996 .45977 L
.3493 .45626 L
.34858 .45274 L
.34801 .45009 L
.3474 .44748 L
.34676 .44492 L
.34609 .44245 L
.34539 .44007 L
.34479 .43821 L
.34418 .43645 L
.34354 .43481 L
.3429 .4333 L
.34224 .43195 L
.34156 .43078 L
.34079 .42967 L
.34001 .42883 L
.33922 .42827 L
.33843 .428 L
.33763 .42805 L
.33684 .42842 L
.33605 .42913 L
.33516 .43035 L
.33429 .43201 L
.33345 .4341 L
Mistroke
.33263 .43661 L
.33185 .43952 L
.33111 .44281 L
.33041 .44644 L
.32976 .4504 L
.32944 .45256 L
.32914 .4548 L
.32885 .45711 L
.32858 .45948 L
.32832 .46191 L
.32808 .4644 L
.32785 .46694 L
.3274 .47292 L
.32704 .4791 L
.32678 .48542 L
.3266 .49184 L
.32653 .49832 L
.32654 .5027 L
.32659 .50707 L
.32668 .51141 L
.32682 .51572 L
.327 .51999 L
.32722 .52419 L
.32749 .52831 L
.32807 .53547 L
.32864 .54108 L
.32929 .54637 L
.33002 .55129 L
.33082 .55579 L
.33169 .55981 L
.33261 .56332 L
.33358 .56626 L
.33459 .56861 L
.33563 .57035 L
.33669 .57147 L
.33776 .57198 L
.33849 .57199 L
.33922 .57173 L
.33994 .57123 L
.34066 .57049 L
.34137 .56953 L
.34207 .56836 L
.34275 .56701 L
.34385 .56442 L
.3447 .56206 L
.34537 .55998 L
.34602 .55779 L
Mfstroke
.02 w
.35 .46 Mdot
.5 Mabswid
.34537 .55998 m
.34602 .55779 L
s
% Start of user PostScript
-1.2370348 0.47987168 -1.2318515 0.46233947 MAarrowhead1
% End of user PostScript
0 1 .776 r
.70193 .61492 m
.70254 .61268 L
.70314 .61034 L
.70429 .60537 L
.70592 .59732 L
.70742 .5887 L
.70877 .5797 L
.70998 .57045 L
.71103 .56107 L
.71194 .55165 L
.71255 .54416 L
.71307 .53668 L
.71349 .52925 L
.71382 .52184 L
.71405 .51447 L
.71419 .50711 L
.71423 .49977 L
.71418 .49243 L
.71404 .48508 L
.71384 .47881 L
.71358 .47252 L
.71325 .46621 L
.71284 .45988 L
.71237 .45352 L
.71183 .44715 L
.71122 .44077 L
.71055 .43441 L
.71002 .42991 L
.70946 .42544 L
.70887 .421 L
.70824 .41662 L
.70758 .41231 L
.70689 .40808 L
.70616 .40396 L
.70516 .39873 L
.7041 .39375 L
.70299 .38909 L
.70184 .38478 L
.70065 .38087 L
.69942 .37741 L
.69816 .37443 L
.69687 .37196 L
.69523 .36962 L
.69357 .36811 L
.69189 .36741 L
.6902 .36748 L
.68853 .36823 L
.68686 .36957 L
.68522 .37138 L
.6836 .37354 L
Mistroke
.68201 .37591 L
.68045 .37837 L
.67893 .38078 L
.67743 .38303 L
.67596 .38502 L
.67451 .38665 L
.67308 .38784 L
.67166 .38852 L
.67043 .38865 L
.6692 .38831 L
.66796 .38749 L
.6667 .38615 L
.66543 .38428 L
.66414 .38188 L
.66282 .37894 L
.66146 .37547 L
.66006 .37149 L
.65862 .36704 L
.65712 .36215 L
.65619 .35903 L
.65524 .35579 L
.65427 .35246 L
.65328 .34904 L
.65227 .34557 L
.65123 .34208 L
.65017 .33859 L
.64908 .33513 L
.64771 .33094 L
.646 .32609 L
.64467 .32263 L
.64331 .31943 L
.64193 .31652 L
.64053 .31397 L
.63911 .31179 L
.63767 .31002 L
.63623 .30868 L
.63477 .30778 L
.63331 .30732 L
.63185 .30729 L
.63039 .30766 L
.62893 .3084 L
.62748 .30947 L
.62565 .31124 L
.62384 .31336 L
.62205 .31569 L
.62029 .31814 L
.61854 .32056 L
.61682 .32284 L
.61512 .32488 L
.61344 .32659 L
Mistroke
.61178 .32787 L
.6104 .32857 L
.60902 .3289 L
.60765 .32884 L
.60627 .32836 L
.60488 .32747 L
.60349 .32615 L
.60209 .32442 L
.60067 .32229 L
.59923 .31978 L
.59777 .31694 L
.59629 .31379 L
.59478 .31039 L
.59324 .30681 L
.59197 .30381 L
.59068 .30077 L
.58936 .29774 L
.58803 .29477 L
.58668 .29189 L
.58532 .28916 L
.58393 .28662 L
.58221 .28383 L
.58046 .28147 L
.5787 .2796 L
.57714 .27839 L
.57557 .27762 L
.574 .27729 L
.57243 .27741 L
.57086 .27794 L
.56929 .27886 L
.56773 .28014 L
.56582 .28213 L
.56367 .28484 L
.56155 .28784 L
.55946 .29096 L
.55739 .29402 L
.55569 .29642 L
.554 .29857 L
.55233 .3004 L
.55067 .30185 L
.54903 .30285 L
.54739 .30337 L
.54575 .30339 L
.54411 .30289 L
.54262 .302 L
.54112 .30069 L
.53961 .299 L
.53809 .29695 L
.53655 .29458 L
.53499 .29195 L
Mistroke
.53341 .28911 L
.53181 .28613 L
.53019 .28308 L
.52854 .28004 L
.52687 .27711 L
.52518 .27435 L
.52347 .27185 L
.52174 .2697 L
.52 .26794 L
.51824 .26665 L
.51674 .26595 L
.51523 .26563 L
.51372 .26569 L
.51221 .26614 L
.51071 .26696 L
.50921 .26812 L
.50773 .2696 L
.50587 .27185 L
.50404 .27444 L
.50183 .27793 L
.49966 .28161 L
.49752 .28527 L
.49542 .28875 L
.49335 .29189 L
.49131 .29455 L
.48929 .29661 L
.48729 .298 L
.4853 .29868 L
.48332 .29861 L
.48133 .2978 L
.47976 .29669 L
.47819 .29518 L
.4766 .29332 L
.47499 .29116 L
.47337 .28876 L
.47173 .2862 L
.47007 .28355 L
.46838 .2809 L
.46733 .27929 L
.46626 .27773 L
.46519 .27626 L
.46411 .27488 L
.46303 .27361 L
.46194 .27249 L
.46084 .27152 L
.45945 .27054 L
.45762 .26971 L
.45668 .26949 L
.45573 .26943 L
.45479 .26952 L
Mistroke
.45384 .26977 L
.4529 .27017 L
.45195 .27073 L
.45082 .2716 L
.44969 .27267 L
.44903 .27339 L
.44838 .27416 L
.44773 .275 L
.44709 .27589 L
.44644 .27684 L
.44588 .27771 L
.44531 .27862 L
.44475 .27956 L
.44419 .28054 L
.44349 .28182 L
.44278 .28313 L
.44208 .28448 L
.44139 .28585 L
.44129 .28604 L
.4412 .28622 L
.44111 .28641 L
.44101 .2866 L
.441 .28662 L
.441 .28664 L
.44099 .28665 L
.44098 .28666 L
.44098 .28667 L
.44097 .28668 L
.44097 .28669 L
.44096 .2867 L
.43844 .29189 L
.43598 .29698 L
.43358 .30169 L
.43124 .30578 L
.4293 .30862 L
.42738 .31081 L
.42549 .31231 L
.42361 .31309 L
.42173 .31316 L
.41985 .31255 L
.41795 .3113 L
.41605 .30949 L
.41412 .30723 L
.41217 .30462 L
.41019 .30181 L
.40818 .29896 L
.40615 .29623 L
.40408 .29378 L
.402 .29178 L
.3999 .29037 L
Mistroke
.39778 .28967 L
.39567 .28976 L
.39356 .29068 L
.39146 .29245 L
.38939 .29502 L
.38734 .29832 L
.38533 .30223 L
.38336 .30663 L
.38144 .31136 L
.37957 .3163 L
.37775 .32128 L
.37561 .32716 L
.37355 .33271 L
.37155 .33777 L
.36961 .34218 L
.36772 .34586 L
.36587 .34875 L
.36405 .35081 L
.36225 .35204 L
.36046 .35245 L
.35866 .3521 L
.35728 .35136 L
.35588 .35024 L
.35448 .3488 L
.35306 .34709 L
.35162 .34518 L
.35016 .34314 L
.34868 .34105 L
.34719 .33899 L
.34567 .33705 L
.34379 .33494 L
.34189 .33329 L
.34029 .33236 L
.33868 .33192 L
.33707 .33202 L
.33546 .3327 L
.33386 .33398 L
.33228 .33587 L
.33072 .33836 L
.32919 .34141 L
.32768 .34497 L
.32622 .34899 L
.32479 .35341 L
.32341 .35814 L
.32207 .36313 L
.32079 .36829 L
.32018 .37084 L
.31959 .3734 L
.31901 .37597 L
.31844 .37855 L
Mistroke
.31788 .38113 L
.31733 .3837 L
.3168 .38626 L
.31654 .38754 L
.31628 .38881 L
.31602 .39007 L
.31577 .39133 L
.31552 .39258 L
.31527 .39383 L
.31408 .39994 L
.31295 .40581 L
.3116 .41299 L
.31049 .41894 L
.30945 .42448 L
.30848 .42961 L
.30758 .43434 L
.30674 .43866 L
.30596 .4426 L
.30522 .44616 L
.30436 .45013 L
.30357 .45358 L
.30282 .45654 L
.30213 .45905 L
.30127 .4617 L
.30047 .46368 L
.2997 .46506 L
.29896 .46588 L
.29823 .46616 L
.29749 .46594 L
.2969 .46541 L
.29629 .46458 L
.29566 .46346 L
.29501 .46206 L
.29434 .46039 L
.29363 .45846 L
.29289 .45631 L
.29211 .45394 L
.29131 .45147 L
.29047 .44886 L
.28959 .44616 L
.28866 .44341 L
.28768 .44066 L
.28666 .438 L
.28559 .43548 L
.28449 .4332 L
.28361 .43166 L
.28271 .43035 L
.28179 .42931 L
.28087 .42859 L
.27993 .42822 L
Mistroke
.279 .42823 L
.27807 .42865 L
.27714 .4295 L
.27623 .43079 L
.27534 .43253 L
.27448 .43472 L
.27356 .43765 L
.27269 .44109 L
.27187 .44502 L
.27111 .4494 L
.27041 .45418 L
.26979 .45933 L
.26925 .46478 L
.26878 .47051 L
.26833 .47771 L
.26811 .48242 L
.26794 .4872 L
.26783 .49203 L
.26777 .4969 L
.26776 .50178 L
.2678 .50665 L
.2679 .51149 L
.26801 .51508 L
.26815 .51863 L
.26832 .52213 L
.26852 .52559 L
.26874 .52898 L
.269 .53231 L
.26917 .53434 L
.26935 .53634 L
.26954 .53831 L
.26974 .54024 L
.26996 .54213 L
.27018 .54398 L
.27041 .54578 L
.27103 .55012 L
.27171 .55412 L
.27243 .55778 L
.27321 .56104 L
.27402 .56389 L
.27486 .56632 L
.27574 .5683 L
.27663 .56984 L
.27744 .57082 L
.27825 .57147 L
.27907 .57179 L
.27989 .57179 L
.28071 .5715 L
.28152 .57094 L
.28232 .57012 L
Mistroke
.28302 .56923 L
.2837 .56818 L
.28438 .567 L
.28504 .5657 L
.28569 .56431 L
.28632 .56284 L
.28707 .56095 L
.2878 .55901 L
.28851 .55703 L
.28919 .55504 L
.28985 .55306 L
.29048 .55112 L
.29109 .54923 L
.29168 .5474 L
.29224 .54566 L
.29279 .544 L
.29365 .54148 L
.29447 .53928 L
.29524 .53742 L
.29598 .53593 L
.2967 .53483 L
.2974 .53413 L
.29808 .53385 L
.2985 .53389 L
.29891 .53409 L
.29933 .53447 L
.29976 .53502 L
.30019 .53576 L
.30064 .53669 L
.30109 .53782 L
.30143 .53875 L
.30177 .53979 L
.30212 .54094 L
.30248 .5422 L
.30286 .54359 L
.30325 .54511 L
.30381 .54743 L
.3044 .55002 L
.30502 .55288 L
.30568 .55604 L
.30638 .5595 L
.30712 .56329 L
.30792 .5674 L
.30858 .57088 L
.30927 .57457 L
.31 .57847 L
.31077 .58259 L
.31158 .58692 L
.31243 .59145 L
.31333 .59617 L
Mistroke
.31427 .60106 L
.31526 .60611 L
.3163 .61128 L
.31739 .61654 L
.31852 .62184 L
.31971 .62715 L
.32069 .63132 L
.32171 .63543 L
.32275 .63944 L
.32382 .64331 L
.32492 .64702 L
.32605 .65052 L
.3272 .65377 L
.32862 .65733 L
.33007 .66043 L
.33155 .66304 L
.33282 .66484 L
.33411 .66626 L
.33541 .66727 L
.33671 .66788 L
.33802 .66811 L
.33932 .66797 L
.34063 .66748 L
.34221 .66647 L
.34378 .66507 L
.34534 .66335 L
.34688 .66141 L
.3484 .65934 L
.34991 .65722 L
.35139 .65513 L
.35285 .65317 L
.35429 .65141 L
.35572 .64991 L
.35714 .64874 L
.3589 .64781 L
.36066 .64755 L
.36188 .64781 L
.3631 .64844 L
.36433 .64946 L
.36558 .65086 L
.36683 .65265 L
.3681 .65482 L
.36939 .65736 L
.37071 .66024 L
.37205 .66344 L
.37341 .66692 L
.37535 .67212 L
.37667 .67574 L
.37801 .67945 L
.37938 .6832 L
Mistroke
.38078 .68693 L
.38221 .69058 L
.38367 .69408 L
.38515 .69738 L
.38665 .70042 L
.38818 .70312 L
.38972 .70545 L
.39129 .70736 L
.39286 .70882 L
.39445 .70981 L
.39604 .71032 L
.39763 .71035 L
.39922 .70994 L
.4008 .7091 L
.40238 .70789 L
.40395 .70636 L
.40582 .70419 L
.40766 .70176 L
.40949 .69919 L
.41129 .69662 L
.41306 .69416 L
.41482 .69191 L
.41656 .68998 L
.41828 .68845 L
.42036 .68722 L
.42174 .68683 L
.42312 .68682 L
.42451 .68719 L
.4259 .68796 L
.42729 .68911 L
.4287 .69063 L
.43012 .69252 L
.43185 .69522 L
.4336 .69834 L
.43503 .70109 L
.43647 .70402 L
.43794 .70706 L
.43943 .71017 L
.44095 .71327 L
.44248 .7163 L
.44404 .71919 L
.44562 .72188 L
.44721 .72429 L
.44883 .72637 L
.45088 .72845 L
.45237 .72953 L
.45387 .73024 L
.45537 .73055 L
.45687 .73047 L
.45837 .73002 L
Mistroke
.45987 .7292 L
.46136 .72804 L
.46314 .72626 L
.46491 .72412 L
.46666 .7217 L
.46838 .7191 L
.47009 .71641 L
.47178 .71372 L
.47344 .71113 L
.47509 .70871 L
.47671 .70653 L
.47877 .70422 L
.4808 .70252 L
.48236 .70169 L
.48391 .70129 L
.48546 .70135 L
.48701 .70186 L
.48857 .7028 L
.49014 .70418 L
.49171 .70594 L
.49363 .70851 L
.49519 .71089 L
.49678 .71347 L
.49838 .71619 L
.5 .71897 L
.50164 .72175 L
.5033 .72443 L
.50498 .72693 L
.50668 .72918 L
.50839 .7311 L
.51012 .73263 L
.51186 .7337 L
.51403 .73435 L
.5162 .73421 L
.51837 .73327 L
.52052 .73158 L
.52265 .72921 L
.52476 .72629 L
.52685 .72294 L
.52889 .71931 L
.53091 .71557 L
.53289 .71186 L
.53484 .70833 L
.53675 .7051 L
.53864 .70228 L
.5405 .69996 L
.54234 .69821 L
.54418 .69708 L
.546 .69658 L
.54782 .69672 L
Mistroke
.54965 .69747 L
.55128 .69864 L
.55293 .70022 L
.55459 .70215 L
.55627 .70438 L
.55797 .70683 L
.55969 .70939 L
.56143 .71199 L
.56319 .71451 L
.56473 .71654 L
.56628 .71838 L
.56784 .71996 L
.56942 .72122 L
.571 .72213 L
.57258 .72262 L
.57417 .72269 L
.57576 .72231 L
.57734 .72148 L
.57891 .72021 L
.58048 .71852 L
.58203 .71644 L
.58356 .71401 L
.58552 .71044 L
.58714 .70716 L
.58873 .70368 L
.5903 .7001 L
.59184 .6965 L
.59335 .69293 L
.59483 .68949 L
.59628 .68621 L
.59805 .68251 L
.59977 .67923 L
.60147 .67646 L
.60314 .67424 L
.6048 .6726 L
.60644 .67155 L
.60808 .6711 L
.60971 .67121 L
.61135 .67187 L
.613 .67302 L
.61466 .67461 L
.61604 .67619 L
.61744 .67796 L
.61885 .67987 L
.62028 .68186 L
.62172 .68386 L
.62318 .68581 L
.62465 .68763 L
.62614 .68927 L
.62764 .69066 L
Mistroke
.62915 .69173 L
.63104 .69256 L
.63246 .69275 L
.63389 .69255 L
.63531 .69194 L
.63672 .69091 L
.63813 .68947 L
.63952 .68762 L
.6409 .6854 L
.64226 .68282 L
.6436 .67992 L
.64492 .67675 L
.64598 .67395 L
.64703 .67103 L
.64807 .668 L
.64908 .66488 L
.65007 .66172 L
.65105 .65852 L
.65221 .65462 L
.65334 .65075 L
.65445 .64695 L
.65553 .64324 L
.6569 .63858 L
.65823 .63419 L
.65918 .6312 L
.6601 .6284 L
.661 .6258 L
.66189 .6234 L
.66276 .62121 L
.66361 .61925 L
.66445 .6175 L
.66528 .61598 L
.6661 .61468 L
.66691 .6136 L
.66816 .61234 L
.6694 .6116 L
.67063 .61134 L
.67186 .61155 L
.67309 .61217 L
.67434 .61319 L
.67559 .61454 L
.67687 .61618 L
.678 .61781 L
.67915 .61958 L
.68032 .62142 L
.68151 .6233 L
.68271 .62515 L
.68393 .62692 L
.68517 .62855 L
.68642 .62999 L
Mistroke
.68746 .63097 L
.68851 .63176 L
.68956 .63231 L
.69062 .63261 L
.69167 .63262 L
.69273 .63234 L
.69378 .63174 L
.69472 .63094 L
.69565 .62986 L
.69658 .62853 L
.69749 .62693 L
.69839 .62507 L
.69928 .62296 L
.70004 .62093 L
.70079 .61871 L
.70152 .61634 L
.70224 .6138 L
.70294 .61113 L
.70363 .60831 L
.70409 .60631 L
.70454 .60425 L
.70498 .60214 L
.70541 .59998 L
.70584 .59777 L
.7059 .59744 L
.70596 .59711 L
.70602 .59678 L
.70609 .59644 L
.70609 .59641 L
.7061 .59637 L
.7061 .59634 L
.70611 .59632 L
.70611 .59631 L
.70611 .59629 L
.70612 .59627 L
.70612 .59626 L
.70782 .58614 L
.70933 .57557 L
.71064 .56473 L
.71175 .5538 L
.71265 .54286 L
.71335 .53198 L
.71384 .52117 L
.71414 .51042 L
.71423 .50295 L
.71422 .49549 L
.71411 .48802 L
.7139 .48052 L
.7136 .473 L
.7132 .46545 L
Mistroke
.7127 .45786 L
.7121 .45024 L
.71141 .44261 L
.71061 .43499 L
.70987 .42864 L
.70905 .42235 L
.70817 .41616 L
.70722 .41011 L
.70621 .40425 L
.70514 .39863 L
.704 .39331 L
.70281 .38835 L
.70156 .38381 L
.70027 .37975 L
.69894 .37621 L
.69757 .37324 L
.69618 .37086 L
.69476 .3691 L
.69332 .36796 L
.69157 .36737 L
.68982 .36759 L
.68826 .36841 L
.6867 .36973 L
.68517 .37145 L
.68366 .37346 L
.68217 .37567 L
.68071 .37796 L
.67928 .38023 L
.67787 .38238 L
.67666 .3841 L
.67547 .38561 L
.67429 .38686 L
.67312 .38781 L
.67196 .38842 L
.67081 .38865 L
.66965 .38849 L
.66872 .38805 L
.66777 .38732 L
.66683 .3863 L
.66587 .38497 L
.66489 .38333 L
.66391 .38139 L
.6626 .37841 L
.66156 .37573 L
.66049 .37276 L
.6594 .3695 L
.65828 .36597 L
.65713 .36219 L
.65595 .3582 L
.65473 .35402 L
Mistroke
.6532 .34875 L
.65196 .34454 L
.65069 .34031 L
.64939 .3361 L
.64805 .33197 L
.64668 .32798 L
.64528 .32419 L
.64385 .32067 L
.6424 .31746 L
.64091 .31463 L
.63941 .31222 L
.63789 .31026 L
.63619 .30865 L
.63448 .30765 L
.63224 .30726 L
.63001 .30782 L
.62808 .30899 L
.62616 .3107 L
.62427 .31283 L
.6224 .31523 L
.62055 .31777 L
.61873 .3203 L
.61693 .32271 L
.61515 .32485 L
.61379 .32627 L
.61244 .32742 L
.61109 .32827 L
.60975 .32878 L
.60841 .32892 L
.60707 .32869 L
.60573 .32807 L
.60438 .32704 L
.603 .32559 L
.6016 .32373 L
.60019 .32149 L
.59876 .31889 L
.59731 .31597 L
.59583 .31277 L
.59432 .30935 L
.59279 .30576 L
.59091 .30132 L
.58898 .29687 L
.58725 .29309 L
.5855 .28951 L
.58371 .28624 L
.5819 .28338 L
.58007 .281 L
.57822 .27918 L
.57636 .27795 L
.57448 .27735 L
Mistroke
.57261 .27737 L
.57074 .27799 L
.56888 .27917 L
.56703 .28083 L
.56519 .28289 L
.56337 .28525 L
.56118 .28838 L
.55902 .29161 L
.55689 .29474 L
.55479 .29759 L
.55272 .3 L
.55068 .30184 L
.54864 .30301 L
.54662 .30345 L
.5446 .3031 L
.5428 .30213 L
.54098 .30055 L
.53915 .29842 L
.5373 .29577 L
.53543 .2927 L
.53352 .2893 L
.53158 .28569 L
.52961 .28199 L
.52779 .2787 L
.52595 .27557 L
.52408 .27271 L
.52219 .27022 L
.52029 .2682 L
.51837 .26673 L
.51643 .26585 L
.5145 .26561 L
.51256 .266 L
.51063 .26701 L
.50871 .26858 L
.50681 .27066 L
.50493 .27315 L
.50306 .27594 L
.50065 .27991 L
.49852 .28357 L
.49642 .28712 L
.49436 .29041 L
.49233 .29329 L
.49032 .29564 L
.48834 .29736 L
.48636 .29841 L
.4844 .29874 L
.4828 .29847 L
.48121 .29773 L
.4796 .29656 L
.47799 .29497 L
Mistroke
.47636 .29302 L
.47471 .29076 L
.47305 .28827 L
.47137 .28562 L
.46924 .28223 L
.4674 .27939 L
.46553 .27672 L
.46365 .27432 L
.46174 .27231 L
.45982 .27077 L
.45789 .2698 L
.45596 .26943 L
.45402 .26971 L
.45209 .27064 L
.45017 .27218 L
.44827 .2743 L
.44638 .27693 L
.44452 .27996 L
.44269 .28331 L
.44046 .28773 L
.43827 .29225 L
.43613 .29667 L
.43404 .30082 L
.43199 .30454 L
.42997 .30769 L
.42799 .31019 L
.42602 .31196 L
.42407 .31297 L
.42213 .31321 L
.42018 .31271 L
.41878 .31192 L
.41737 .3108 L
.41594 .30938 L
.41451 .30771 L
.41306 .30584 L
.4116 .30383 L
.41013 .30172 L
.40863 .2996 L
.40747 .29798 L
.40629 .29642 L
.40511 .29495 L
.40392 .29361 L
.40272 .29241 L
.40152 .2914 L
.40031 .29059 L
.39876 .2899 L
.39721 .28961 L
.39618 .28966 L
.39515 .2899 L
.39412 .29035 L
Mistroke
.39309 .291 L
.39207 .29185 L
.39105 .2929 L
.39042 .29364 L
.38979 .29446 L
.38917 .29534 L
.38854 .29629 L
.38792 .2973 L
.38747 .29809 L
.38701 .29891 L
.38656 .29977 L
.3861 .30065 L
.38556 .30175 L
.38502 .30288 L
.38449 .30405 L
.38375 .30571 L
.38303 .30743 L
.38295 .3076 L
.38288 .30777 L
.38281 .30795 L
.38274 .30812 L
.38273 .30814 L
.38272 .30816 L
.38272 .30818 L
.38271 .30819 L
.38271 .30819 L
.3827 .3082 L
.3827 .30821 L
.3827 .30822 L
.3802 .31459 L
.3783 .31974 L
.37646 .32484 L
.37466 .32975 L
.37292 .33436 L
.37122 .33857 L
.36956 .34229 L
.36794 .34548 L
.36635 .34808 L
.36478 .35008 L
.36323 .35147 L
.36169 .35225 L
.36016 .35245 L
.35862 .35209 L
.35708 .35122 L
.35569 .35006 L
.3543 .34859 L
.35288 .34687 L
.35145 .34496 L
.35001 .34293 L
.34854 .34085 L
Mistroke
.34705 .33881 L
.34555 .33689 L
.34417 .33533 L
.34277 .33399 L
.34137 .33294 L
.33995 .33223 L
.33854 .3319 L
.33712 .332 L
.33571 .33255 L
.3343 .33357 L
.3329 .33506 L
.33152 .33701 L
.33015 .33942 L
.32881 .34225 L
.32749 .34547 L
.3259 .34994 L
.32435 .35487 L
.32286 .36016 L
.32142 .36571 L
.32004 .37143 L
.31873 .37724 L
.31747 .38306 L
.31628 .38883 L
.31514 .39449 L
.31406 .4 L
.31272 .40703 L
.31147 .41366 L
.31031 .41986 L
.30924 .42561 L
.30824 .43091 L
.30731 .43576 L
.30645 .44017 L
.30564 .44415 L
.30489 .44773 L
.30418 .45093 L
.30336 .45442 L
.3026 .45739 L
.30188 .45987 L
.3012 .4619 L
.30055 .4635 L
.29993 .46471 L
.29932 .46554 L
.29873 .46602 L
.29814 .46616 L
.29755 .46597 L
.29695 .46547 L
.29632 .46462 L
.29566 .46346 L
.29498 .46198 L
.29428 .46022 L
Mistroke
.29353 .45818 L
.29275 .45588 L
.29192 .45336 L
.29105 .45064 L
.29036 .44852 L
.28965 .44633 L
.2889 .44411 L
.28813 .44189 L
.28732 .43969 L
.28649 .43757 L
.28562 .43555 L
.28473 .43368 L
.28395 .43224 L
.28315 .43097 L
.28234 .4299 L
.28152 .42907 L
.28069 .42849 L
.27986 .4282 L
.27902 .42822 L
.27827 .42852 L
.27753 .42909 L
.27679 .42994 L
.27606 .43108 L
.27535 .43251 L
.27465 .43424 L
.27408 .43591 L
.27352 .43779 L
.27298 .43985 L
.27246 .44211 L
.27196 .44454 L
.27148 .44715 L
.27119 .44886 L
.27092 .45062 L
.27065 .45245 L
.27039 .45433 L
.27015 .45626 L
.27011 .45654 L
.27008 .45682 L
.27005 .4571 L
.27001 .45739 L
.27001 .45742 L
.27001 .45744 L
.27 .45747 L
.27 .45749 L
.27 .4575 L
.27 .45751 L
.27 .45753 L
.26999 .45756 L
.26999 .45759 L
.26999 .45761 L
Mistroke
.26995 .4579 L
.26992 .45818 L
.26989 .45847 L
.26986 .45876 L
.26962 .46095 L
.26939 .4632 L
.26918 .4655 L
.26898 .46784 L
.2688 .47022 L
.26862 .47281 L
.26846 .47545 L
.26831 .47811 L
.26818 .48081 L
.26807 .48354 L
.26791 .48815 L
.26781 .49282 L
.26777 .49643 L
.26775 .50006 L
.26777 .50368 L
.26781 .5073 L
.26789 .5109 L
.26802 .51524 L
.26819 .51953 L
.26841 .52375 L
.26867 .52788 L
.26897 .53193 L
.2693 .53585 L
.26974 .54019 L
.27022 .54434 L
.27075 .54827 L
.27133 .55195 L
.27194 .55537 L
.27259 .5585 L
.27328 .56133 L
.274 .56383 L
.27474 .566 L
.27551 .56783 L
.27658 .56976 L
.27768 .57105 L
.27858 .57163 L
.27948 .57183 L
.28039 .57165 L
.28129 .57112 L
.28218 .57029 L
.28306 .56917 L
.28392 .56781 L
.28477 .56625 L
.28578 .5641 L
.28676 .56176 L
.28769 .5593 L
Mistroke
.2886 .55678 L
.28946 .55424 L
.29028 .55174 L
.29106 .54932 L
.29181 .547 L
.29278 .54403 L
.29369 .54138 L
.29439 .53948 L
.29506 .53783 L
.29571 .53645 L
.29633 .53535 L
.29694 .53454 L
.29753 .53404 L
.29812 .53384 L
.29871 .53397 L
.29887 .53406 L
.29902 .53417 L
.29917 .53431 L
.29933 .53446 L
.29948 .53464 L
.29964 .53485 L
.2998 .53508 L
.30055 .5365 L
.30135 .53852 L
.30219 .54117 L
.3031 .54452 L
.30408 .54863 L
.30495 .55254 L
.30588 .55702 L
.3069 .56212 L
.30801 .56787 L
.30922 .57429 L
.31055 .5814 L
.312 .58918 L
.31323 .59565 L
.31454 .60247 L
.3157 .60833 L
.31693 .61435 L
.31822 .62045 L
.31958 .62656 L
.32101 .63261 L
.3225 .6385 L
.32405 .64412 L
.32567 .64937 L
.32734 .65413 L
.32906 .65831 L
.33082 .66182 L
.33292 .66496 L
.33504 .66703 L
.33666 .66787 L
Mistroke
.33828 .66811 L
.33969 .66786 L
.3411 .66723 L
.34249 .66625 L
.34388 .66497 L
.34525 .66346 L
.34662 .66176 L
.34796 .65995 L
.3493 .65808 L
.35078 .65597 L
.35225 .65395 L
.35371 .6521 L
.35514 .65049 L
.35656 .64918 L
.35797 .64822 L
.35937 .64767 L
.36077 .64756 L
.36274 .64822 L
.36472 .64986 L
.36637 .65196 L
.36805 .65472 L
.36976 .65813 L
.37151 .66213 L
.3733 .66664 L
.37515 .67158 L
.37706 .67682 L
.37902 .68222 L
.38104 .6876 L
.38312 .6928 L
.38485 .69674 L
.38661 .70034 L
.3884 .70348 L
.39022 .70611 L
.39206 .70814 L
.39391 .70953 L
.39577 .71027 L
.39764 .71035 L
.3995 .70982 L
.40136 .70872 L
.4032 .70713 L
.40503 .70514 L
.40684 .70286 L
.40863 .70041 L
.41079 .69732 L
.41244 .695 L
.41408 .69283 L
.41569 .6909 L
.41729 .68927 L
.41888 .68801 L
.42046 .68718 L
Mistroke
.42203 .6868 L
.4236 .68691 L
.42555 .68773 L
.42751 .68931 L
.42949 .69163 L
.43149 .69463 L
.43353 .69822 L
.43561 .70227 L
.43774 .70664 L
.43991 .71115 L
.44243 .7162 L
.44433 .71969 L
.44624 .72286 L
.44663 .72345 L
.44702 .72401 L
.44741 .72456 L
.4478 .72509 L
.44819 .7256 L
.44858 .72608 L
.44898 .72655 L
.44976 .72741 L
.45055 .72817 L
.45135 .72883 L
.45214 .72939 L
.45294 .72985 L
.45374 .73019 L
.45454 .73043 L
.45611 .73056 L
.45768 .73027 L
.45926 .72958 L
.46082 .7285 L
.46238 .72708 L
.46392 .72536 L
.46545 .72339 L
.46697 .72124 L
.46848 .71896 L
.46996 .71661 L
.47143 .71427 L
.47289 .71198 L
.47433 .7098 L
.47603 .70741 L
.47772 .70533 L
.47939 .70364 L
.48104 .70237 L
.48269 .70157 L
.48434 .70126 L
.48598 .70147 L
.48763 .70218 L
.48928 .70338 L
.49095 .70504 L
Mistroke
.49284 .7074 L
.49476 .71021 L
.49634 .71275 L
.49795 .71545 L
.49957 .71824 L
.50121 .72104 L
.50288 .72376 L
.50456 .72633 L
.50626 .72866 L
.50798 .73067 L
.50971 .73231 L
.51146 .7335 L
.51321 .7342 L
.51496 .73439 L
.51671 .73406 L
.51846 .73321 L
.5202 .73187 L
.52193 .73009 L
.52365 .72791 L
.52534 .7254 L
.52702 .72264 L
.52867 .71972 L
.53031 .7167 L
.53192 .71368 L
.5335 .71073 L
.53507 .70791 L
.53662 .70531 L
.53854 .70241 L
.54005 .70047 L
.54156 .69889 L
.54305 .6977 L
.54453 .69693 L
.54602 .69658 L
.54749 .69665 L
.54898 .69713 L
.551 .6984 L
.55303 .70032 L
.55446 .70199 L
.5559 .70388 L
.5571 .70556 L
.55831 .70733 L
.55953 .70916 L
.56076 .711 L
.562 .71282 L
.56326 .71459 L
.56501 .71689 L
.56678 .71892 L
.56811 .7202 L
.56945 .72125 L
.57079 .72203 L
Mistroke
.57214 .72253 L
.57349 .72272 L
.57484 .72259 L
.57619 .72213 L
.57773 .7212 L
.57927 .71986 L
.58079 .71813 L
.5823 .71603 L
.58379 .71362 L
.58527 .71093 L
.58673 .70802 L
.58849 .70424 L
.59021 .70031 L
.59159 .69708 L
.59295 .69387 L
.59428 .69075 L
.5956 .68774 L
.59689 .6849 L
.59817 .68227 L
.59942 .67986 L
.60066 .67772 L
.6027 .67478 L
.60471 .67268 L
.60669 .67144 L
.6083 .67108 L
.60991 .67127 L
.61152 .67197 L
.61314 .67315 L
.61477 .67473 L
.61642 .67666 L
.61809 .67883 L
.61978 .68116 L
.62244 .68483 L
.62244 .68483 L
.62244 .68484 L
.62245 .68484 L
.62245 .68485 L
.62246 .68485 L
.62246 .68486 L
.62247 .68487 L
.62248 .68488 L
.62255 .68498 L
.62263 .68508 L
.62271 .68518 L
.62278 .68528 L
.6235 .68621 L
.62421 .6871 L
.62481 .68781 L
.6254 .68849 L
.62589 .68902 L
Mistroke
.62639 .68952 L
.62688 .69 L
.62738 .69044 L
.62799 .69094 L
.6286 .69138 L
.62921 .69177 L
.62983 .6921 L
.63044 .69236 L
.63147 .69265 L
.6325 .69275 L
.63353 .69264 L
.63457 .69231 L
.63559 .69176 L
.63662 .691 L
.63799 .68963 L
.63935 .68787 L
.64047 .68613 L
.64157 .68416 L
.64267 .68197 L
.64375 .67957 L
.64482 .677 L
.64587 .67427 L
.6469 .67141 L
.64828 .66734 L
.64964 .66313 L
.65095 .65884 L
.65223 .65454 L
.65348 .65029 L
.65469 .64612 L
.65587 .64208 L
.65701 .63821 L
.6584 .63367 L
.65974 .62949 L
.66103 .62571 L
.6623 .62235 L
.66353 .61944 L
.66473 .61697 L
.66591 .61497 L
.66707 .61341 L
.66794 .61253 L
.6688 .6119 L
.66966 .6115 L
.67052 .61135 L
.67138 .61141 L
.67223 .61169 L
.6731 .61218 L
.67439 .61324 L
.6757 .61467 L
.67703 .61641 L
.67839 .61839 L
Mistroke
.67976 .62054 L
.68116 .62276 L
.68259 .62497 L
.68404 .62707 L
.68551 .62897 L
.68701 .63057 L
.68852 .63176 L
.69004 .63248 L
.69157 .63263 L
.69309 .63217 L
.69461 .63105 L
.69611 .62924 L
.69758 .62675 L
.69902 .6236 L
.70042 .61982 L
.70178 .61545 L
.70308 .61057 L
.70432 .60524 L
.7055 .59952 L
.70652 .59402 L
.70748 .58831 L
.70838 .58243 L
.70922 .57644 L
.70999 .57035 L
.7107 .56422 L
.71134 .55805 L
.71192 .55187 L
.7127 .54218 L
.71321 .53448 L
.71361 .52682 L
.71391 .51919 L
.71412 .51159 L
.71422 .504 L
.71422 .49643 L
.71413 .48885 L
.71393 .48125 L
.71357 .47239 L
.71308 .46347 L
.71245 .45452 L
.71169 .44553 L
.71078 .43654 L
.71003 .42997 L
.7092 .42346 L
.7083 .41704 L
.70733 .41077 L
.70629 .4047 L
.70519 .39888 L
.70401 .39337 L
.70278 .38825 L
.7012 .38261 L
Mistroke
.70004 .37909 L
.69885 .37599 L
.69784 .37376 L
.69681 .37186 L
.69577 .37029 L
.69471 .36906 L
.69365 .36816 L
.69258 .3676 L
.69151 .36736 L
.6899 .36756 L
.68859 .36819 L
.68728 .36918 L
.68598 .37049 L
.6847 .37204 L
.68344 .37378 L
.68219 .37564 L
.68096 .37756 L
.67975 .37948 L
.67856 .38134 L
.67739 .38309 L
.67598 .38499 L
.67482 .38633 L
.67367 .3874 L
.67253 .38816 L
.6714 .38858 L
.67027 .38863 L
.66914 .38829 L
.66801 .38753 L
.66673 .38618 L
.66544 .38428 L
.66412 .38183 L
.66277 .37882 L
.66138 .37526 L
.65995 .37117 L
.65848 .36659 L
.65694 .36156 L
.65535 .35616 L
.6537 .35047 L
.65198 .3446 L
.65019 .33867 L
.64834 .33284 L
.64642 .32725 L
.64479 .32294 L
.64312 .31901 L
.64141 .31554 L
.63968 .31261 L
.63792 .31029 L
.63614 .30862 L
.63435 .3076 L
.63255 .30725 L
Mistroke
.63075 .30753 L
.62896 .30838 L
.62718 .30974 L
.62541 .3115 L
.62366 .31358 L
.62193 .31585 L
.61967 .31899 L
.61805 .32122 L
.61645 .32331 L
.61515 .32486 L
.61385 .32621 L
.61257 .32732 L
.61129 .32816 L
.61002 .3287 L
.60875 .32892 L
.60748 .3288 L
.6062 .32833 L
.60433 .32699 L
.60244 .32489 L
.60052 .32205 L
.59857 .31852 L
.59657 .31441 L
.59453 .30982 L
.59243 .30492 L
.59029 .29987 L
.58808 .29487 L
.58583 .29015 L
.58352 .28592 L
.58117 .28237 L
.57879 .27968 L
.57638 .27796 L
.57465 .27738 L
.57292 .27732 L
.57119 .27779 L
.56946 .27874 L
.56774 .28013 L
.56604 .28189 L
.56435 .28395 L
.56267 .28622 L
.5606 .28925 L
.55855 .29231 L
.55689 .29474 L
.55524 .29701 L
.55362 .29902 L
.552 .30072 L
.5504 .30204 L
.54881 .30295 L
.54722 .3034 L
.54564 .30337 L
.54371 .30269 L
Mistroke
.54177 .30131 L
.53982 .29925 L
.53784 .29659 L
.53584 .2934 L
.5338 .28981 L
.53172 .28596 L
.52961 .282 L
.52709 .27748 L
.52522 .2744 L
.52331 .27164 L
.52293 .27114 L
.52255 .27065 L
.52216 .27018 L
.52178 .26974 L
.52139 .26931 L
.521 .2689 L
.52062 .26851 L
.51984 .26781 L
.51906 .26719 L
.51828 .26668 L
.5175 .26626 L
.51671 .26594 L
.51593 .26573 L
.51514 .26562 L
.51353 .26573 L
.51192 .26627 L
.51031 .26723 L
.50871 .26859 L
.50712 .27028 L
.50555 .27228 L
.50399 .27452 L
.50244 .27693 L
.50092 .27946 L
.49941 .28204 L
.49792 .2846 L
.49644 .28709 L
.49498 .28945 L
.49316 .29216 L
.49136 .29449 L
.48958 .29636 L
.48781 .29771 L
.48605 .29851 L
.4843 .29873 L
.48254 .29838 L
.48079 .29746 L
.47901 .29602 L
.47723 .2941 L
.47543 .29177 L
.4736 .28911 L
.47175 .28624 L
Mistroke
.46988 .28325 L
.46798 .28027 L
.46605 .27743 L
.46383 .27453 L
.4622 .27274 L
.46055 .27129 L
.4589 .27023 L
.45725 .2696 L
.45559 .26944 L
.45393 .26974 L
.45227 .27053 L
.45062 .27177 L
.44898 .27344 L
.44736 .27551 L
.44575 .27791 L
.44416 .28059 L
.44259 .28349 L
.44102 .28659 L
.43946 .28977 L
.43793 .29296 L
.43642 .29608 L
.43494 .29908 L
.43348 .30189 L
.43203 .30447 L
.43061 .30676 L
.4289 .30912 L
.42722 .31097 L
.42554 .31228 L
.42388 .31302 L
.42222 .31321 L
.42056 .31286 L
.41889 .31199 L
.41722 .31066 L
.41524 .30859 L
.41324 .30608 L
.41121 .30327 L
.40915 .30033 L
.40706 .29743 L
.40494 .29475 L
.4028 .29248 L
.40063 .29079 L
.39845 .28981 L
.39627 .28965 L
.39408 .29037 L
.39191 .292 L
.38976 .29449 L
.38764 .29778 L
.38556 .30174 L
.38353 .30624 L
.38154 .31111 L
Mistroke
.3796 .3162 L
.37772 .32135 L
.37589 .3264 L
.37411 .33123 L
.37238 .33572 L
.3707 .33979 L
.36905 .34335 L
.36744 .34635 L
.36586 .34877 L
.36429 .35058 L
.36253 .3519 L
.36077 .35244 L
.35901 .35223 L
.35725 .35134 L
.35547 .34985 L
.35367 .34786 L
.35185 .3455 L
.35 .34291 L
.34811 .34026 L
.34721 .33903 L
.34631 .33784 L
.34539 .33671 L
.34447 .33566 L
.34355 .3347 L
.34262 .33386 L
.34168 .33315 L
.34074 .33258 L
.3391 .33198 L
.33746 .33194 L
.33582 .33249 L
.33419 .33367 L
.33257 .33548 L
.33098 .33791 L
.32941 .34093 L
.32787 .3445 L
.32687 .34715 L
.32588 .34999 L
.32492 .353 L
.32397 .35616 L
.32305 .35946 L
.32214 .36286 L
.32126 .36634 L
.32014 .37101 L
.31906 .37574 L
.31802 .38049 L
.31702 .38523 L
.31606 .38992 L
.31513 .39452 L
.31425 .39903 L
.31308 .40513 L
Mistroke
.31216 .40997 L
.31144 .41384 L
.31074 .41756 L
.31008 .42112 L
.30944 .42452 L
.30883 .42776 L
.30825 .43084 L
.30769 .43377 L
.30716 .43654 L
.30629 .44097 L
.30547 .44496 L
.30471 .44854 L
.304 .45172 L
.30334 .45453 L
.30271 .45699 L
.30211 .45911 L
.30154 .46093 L
.30099 .46245 L
.30047 .46369 L
.29996 .46466 L
.29946 .46539 L
.29897 .46587 L
.2984 .46614 L
.29784 .4661 L
.29728 .46578 L
.29671 .46518 L
.29613 .46431 L
.29553 .46318 L
.29491 .4618 L
.29426 .46018 L
.29359 .45833 L
.29288 .45627 L
.29218 .45416 L
.29145 .4519 L
.29069 .44952 L
.28988 .44705 L
.28904 .44453 L
.28816 .44199 L
.28724 .43949 L
.28628 .43707 L
.28529 .43482 L
.28426 .43278 L
.2832 .43103 L
.28212 .42964 L
.28102 .42868 L
.28013 .42827 L
.27924 .42819 L
.27836 .42847 L
.27748 .42914 L
.27661 .4302 L
Mistroke
.27575 .43166 L
.27492 .43354 L
.27402 .43609 L
.27317 .43912 L
.27235 .44261 L
.27159 .44653 L
.27089 .45084 L
.27024 .45552 L
.26966 .46051 L
.26948 .46232 L
.2693 .46416 L
.26914 .46603 L
.26898 .46793 L
.26883 .46986 L
.26869 .47181 L
.26833 .47777 L
.26805 .48389 L
.26787 .49013 L
.26778 .49521 L
.26775 .50031 L
.26779 .50541 L
.26788 .51049 L
.26803 .51551 L
.26824 .52047 L
.2685 .52534 L
.26906 .53313 L
.2696 .53886 L
.27008 .54321 L
.27062 .54732 L
.2712 .55119 L
.27183 .55477 L
.2725 .55806 L
.2732 .56102 L
.27394 .56364 L
.2747 .5659 L
.27492 .56646 L
.27513 .56699 L
.27535 .56749 L
.27557 .56797 L
.27579 .56842 L
.27602 .56884 L
.27624 .56923 L
.27714 .5705 L
.27804 .57134 L
.27896 .57176 L
.27988 .57179 L
.2808 .57145 L
.28171 .57077 L
.28261 .56978 L
.28349 .56852 L
Mistroke
.28436 .56703 L
.28521 .56535 L
.28603 .56351 L
.28683 .56156 L
.28761 .55953 L
.28847 .55713 L
.2893 .55471 L
.29009 .55231 L
.29085 .54998 L
.29157 .54773 L
.29226 .5456 L
.29292 .54361 L
.29355 .54177 L
.29416 .5401 L
.29474 .5386 L
.2953 .5373 L
.29584 .53619 L
.29637 .53529 L
.29707 .53441 L
.29776 .53393 L
.29844 .53387 L
.29912 .53426 L
.29982 .53511 L
.30054 .53646 L
.30129 .53834 L
.30151 .539 L
.30174 .5397 L
.30198 .54045 L
.30221 .54125 L
.30246 .54211 L
.30271 .54302 L
.30324 .54509 L
.3038 .54742 L
.3044 .55002 L
.30502 .5529 L
.30569 .55607 L
.30639 .55955 L
.30714 .56335 L
.30786 .56709 L
.30862 .57111 L
.30943 .57542 L
.31029 .58001 L
.3112 .58489 L
.31217 .59004 L
.31319 .59546 L
.31428 .60111 L
.31543 .60696 L
.31664 .61297 L
.3177 .61803 L
.31881 .62313 L
Mistroke
.31996 .62821 L
.32116 .63323 L
.3224 .63812 L
.32369 .64284 L
.32501 .64732 L
.32668 .65234 L
.32807 .65599 L
.32948 .65922 L
.33092 .66199 L
.33239 .66427 L
.33387 .66602 L
.33536 .66724 L
.33687 .66793 L
.33838 .66811 L
.33988 .6678 L
.34139 .66705 L
.34269 .66608 L
.34399 .66486 L
.34528 .66343 L
.34655 .66184 L
.34782 .66015 L
.34907 .65841 L
.3503 .65666 L
.35152 .65495 L
.35273 .65332 L
.35393 .65183 L
.3555 .65013 L
.35705 .6488 L
.35859 .64793 L
.36012 .64756 L
.36166 .64774 L
.3632 .64851 L
.36475 .64988 L
.36631 .65187 L
.3679 .65446 L
.36952 .65763 L
.37118 .66134 L
.37288 .66554 L
.37288 .66554 L
.37288 .66555 L
.37289 .66556 L
.37289 .66557 L
.37289 .66558 L
.3729 .66559 L
.37291 .66561 L
.37291 .66563 L
.37298 .66579 L
.37304 .66596 L
.37311 .66613 L
.37317 .66629 L
Mistroke
.37382 .668 L
.37448 .66976 L
.37515 .67156 L
.37582 .6734 L
.3765 .67527 L
.37745 .67792 L
.37843 .6806 L
.37923 .68278 L
.38003 .68496 L
.38085 .68712 L
.38168 .68925 L
.38252 .69134 L
.38345 .69359 L
.3844 .69575 L
.38535 .69782 L
.38631 .69977 L
.38729 .70159 L
.38827 .70327 L
.38999 .7058 L
.39136 .70745 L
.39275 .70874 L
.39388 .70951 L
.39501 .71005 L
.39615 .71034 L
.39729 .71039 L
.39842 .7102 L
.39956 .70979 L
.40101 .70896 L
.40246 .70782 L
.40362 .70671 L
.40477 .70544 L
.40592 .70406 L
.40706 .70258 L
.40819 .70103 L
.40931 .69945 L
.41042 .69786 L
.41186 .69581 L
.41329 .69386 L
.4147 .69205 L
.4161 .69045 L
.41749 .68909 L
.41888 .68802 L
.42025 .68726 L
.42195 .68681 L
.42366 .68692 L
.42536 .68762 L
.42708 .6889 L
.42881 .69076 L
.43056 .69316 L
.43233 .69604 L
Mistroke
.43413 .69935 L
.43642 .70392 L
.43877 .70879 L
.44076 .71289 L
.44278 .71687 L
.44485 .72059 L
.44694 .7239 L
.44906 .72665 L
.45121 .72873 L
.45337 .73005 L
.45555 .73056 L
.45772 .73026 L
.45988 .72919 L
.46204 .72742 L
.46417 .72506 L
.46628 .72225 L
.46836 .71914 L
.47041 .71591 L
.4727 .71228 L
.47495 .7089 L
.47678 .70645 L
.4786 .70439 L
.4804 .70281 L
.48218 .70176 L
.48396 .70129 L
.48574 .70141 L
.48753 .70212 L
.48932 .70341 L
.49112 .70524 L
.49295 .70754 L
.49573 .71174 L
.49806 .71564 L
.50044 .71973 L
.50256 .72325 L
.50471 .72655 L
.50471 .72655 L
.50472 .72656 L
.50472 .72656 L
.50473 .72657 L
.50473 .72657 L
.50474 .72658 L
.50474 .72659 L
.50475 .72661 L
.50483 .72671 L
.5049 .72682 L
.50498 .72693 L
.50506 .72704 L
.5057 .72793 L
.50635 .72877 L
.507 .72957 L
Mistroke
.50766 .73032 L
.50831 .73102 L
.50961 .73222 L
.51091 .73317 L
.51189 .73371 L
.51286 .7341 L
.51385 .73433 L
.51483 .73439 L
.51581 .7343 L
.51679 .73403 L
.51837 .73327 L
.51995 .7321 L
.52123 .73087 L
.5225 .72941 L
.52376 .72775 L
.52501 .72592 L
.52625 .72394 L
.52748 .72185 L
.52869 .71968 L
.53025 .7168 L
.53179 .71391 L
.53331 .71108 L
.53481 .70837 L
.53629 .70584 L
.53776 .70354 L
.53921 .70152 L
.54064 .69981 L
.54252 .69808 L
.54439 .69699 L
.54625 .69656 L
.54811 .6968 L
.54997 .69767 L
.55185 .69914 L
.55374 .70112 L
.55565 .70354 L
.55759 .70627 L
.55956 .70919 L
.56155 .71216 L
.56357 .71502 L
.56561 .71762 L
.56768 .71981 L
.56977 .72146 L
.57187 .72245 L
.57397 .72271 L
.57608 .72218 L
.57817 .72086 L
.57986 .71924 L
.58153 .71715 L
.58318 .71465 L
.58481 .71179 L
Mistroke
.58642 .70865 L
.58801 .70529 L
.58956 .7018 L
.59109 .69824 L
.5926 .6947 L
.59407 .69123 L
.59553 .6879 L
.59742 .68378 L
.59887 .68089 L
.6003 .67832 L
.60171 .67612 L
.6031 .67429 L
.60448 .67287 L
.60585 .67186 L
.60721 .67127 L
.60857 .67107 L
.60993 .67127 L
.61129 .67184 L
.61304 .67306 L
.61479 .67475 L
.61636 .67657 L
.61759 .67816 L
.61884 .67985 L
.6201 .68161 L
.62137 .68338 L
.62266 .68512 L
.62395 .68679 L
.62538 .68846 L
.62682 .68994 L
.62827 .69115 L
.62972 .69205 L
.63119 .69259 L
.63265 .69275 L
.63412 .69248 L
.63583 .69161 L
.63754 .69012 L
.63894 .68844 L
.64033 .68636 L
.64171 .68391 L
.64306 .68113 L
.64439 .67805 L
.6457 .67471 L
.64698 .67117 L
.64824 .66747 L
.64973 .66283 L
.65117 .65811 L
.65258 .65337 L
.65394 .64871 L
.65526 .64417 L
.65654 .63981 L
Mistroke
.65778 .63568 L
.65898 .63181 L
.66015 .62824 L
.66129 .62499 L
.66241 .62207 L
.66373 .61899 L
.66502 .61644 L
.66628 .61441 L
.66753 .61291 L
.66876 .61192 L
.66999 .61142 L
.67121 .61138 L
.67243 .61179 L
.67366 .61259 L
.67547 .6144 L
.67732 .61681 L
.6792 .61966 L
.68114 .62272 L
.68312 .62576 L
.68312 .62576 L
.68312 .62577 L
.68313 .62577 L
.68313 .62578 L
.68314 .62579 L
.68314 .6258 L
.68315 .62581 L
.68316 .62582 L
.68323 .62593 L
.68331 .62604 L
.68339 .62615 L
.68346 .62626 L
.68403 .62705 L
.68459 .62782 L
.68516 .62854 L
.68573 .62923 L
.68619 .62974 L
.68664 .63021 L
.6871 .63066 L
.68756 .63106 L
.68808 .63147 L
.6886 .63182 L
.68912 .63211 L
.68964 .63234 L
.69017 .63251 L
.69109 .63265 L
.69201 .63257 L
.69275 .63233 L
.69349 .63194 L
.69423 .63139 L
.69497 .63067 L
Mistroke
.6957 .6298 L
.69643 .62876 L
.69761 .6267 L
.69877 .62421 L
.69969 .62189 L
.70059 .61932 L
.70147 .6165 L
.70233 .61346 L
.70317 .61021 L
.70398 .60678 L
.70477 .60317 L
.70574 .5983 L
.70666 .59322 L
.70754 .58797 L
.70836 .58259 L
.70913 .5771 L
.70984 .57154 L
.71051 .56593 L
.71112 .56029 L
.71186 .55261 L
.71249 .54493 L
.71303 .53728 L
.71347 .52966 L
.71381 .52208 L
.71405 .51453 L
.71419 .507 L
.71423 .50287 L
.71423 .49873 L
Mfstroke
.02 w
.27 .4575 Mdot
.5 Mabswid
.71423 .50287 m
.71423 .49873 L
s
% Start of user PostScript
1.7138099 0.022947473 1.7138561 -0.01012524 MAarrowhead1
% End of user PostScript
.161 1 0 r
.57248 .76424 m
.57423 .76431 L
.57597 .76392 L
.57804 .76287 L
.58009 .7612 L
.58212 .75896 L
.58414 .75622 L
.58613 .75309 L
.58809 .74968 L
.59051 .74518 L
.59289 .74065 L
.59522 .7363 L
.59752 .73233 L
.59977 .72891 L
.602 .72615 L
.6042 .72416 L
.60638 .72296 L
.60788 .72261 L
.60938 .72263 L
.61088 .723 L
.61238 .7237 L
.61388 .72469 L
.6154 .72594 L
.61692 .72738 L
.61846 .72898 L
.62042 .73112 L
.6224 .73327 L
.62404 .73495 L
.62569 .73647 L
.62736 .73776 L
.62903 .73876 L
.63071 .7394 L
.63239 .73963 L
.63407 .73943 L
.63574 .73876 L
.63741 .73763 L
.63907 .73604 L
.64072 .734 L
.64236 .73156 L
.64397 .72877 L
.6462 .72434 L
.64788 .72064 L
.64953 .71676 L
.65116 .7128 L
.65275 .70883 L
.65432 .70493 L
.65585 .70117 L
.65736 .69762 L
.65919 .69358 L
.66099 .69001 L
Mistroke
.66254 .68733 L
.66408 .68509 L
.66559 .68331 L
.66709 .68201 L
.66859 .68117 L
.67008 .68078 L
.67156 .68082 L
.67344 .68141 L
.67532 .68253 L
.67668 .68361 L
.67806 .68485 L
.67944 .68622 L
.68083 .68765 L
.68224 .68909 L
.68365 .69048 L
.68508 .69175 L
.68651 .69286 L
.68774 .69361 L
.68897 .69418 L
.6902 .69451 L
.69143 .69459 L
.69266 .6944 L
.6939 .69392 L
.69512 .69314 L
.69616 .69224 L
.6972 .69111 L
.69822 .68975 L
.69924 .68818 L
.70026 .68641 L
.70126 .68443 L
.70184 .68318 L
.70242 .68187 L
.70299 .68049 L
.70356 .67907 L
.70412 .67759 L
.7042 .67739 L
.70427 .6772 L
.70434 .677 L
.70441 .6768 L
.70442 .67678 L
.70443 .67677 L
.70444 .67675 L
.70444 .67674 L
.70444 .67673 L
.70445 .67672 L
.70445 .67671 L
.70445 .6767 L
.70634 .67117 L
.70817 .66523 L
.70993 .65902 L
Mistroke
.71163 .65266 L
.71325 .64631 L
.71481 .64006 L
.7163 .63401 L
.71772 .62824 L
.7194 .62157 L
.721 .61551 L
.72252 .61011 L
.72397 .6054 L
.72566 .60059 L
.72729 .59682 L
.72886 .59403 L
.72935 .59335 L
.72984 .59275 L
.73032 .59225 L
.7308 .59184 L
.73128 .59151 L
.73176 .59127 L
.73224 .59111 L
.73334 .59103 L
.73443 .59133 L
.73553 .59196 L
.73665 .5929 L
.73777 .59408 L
.73891 .59545 L
.74007 .59696 L
.74124 .59855 L
.74271 .60051 L
.74422 .60236 L
.74537 .60359 L
.74654 .60463 L
.74772 .6054 L
.74891 .60585 L
.7501 .60593 L
.75128 .6056 L
.75247 .60482 L
.75364 .60357 L
.75456 .60221 L
.75547 .60053 L
.75636 .59853 L
.75723 .59622 L
.75808 .5936 L
.75891 .59068 L
.75971 .58748 L
.76073 .58275 L
.7617 .57758 L
.76233 .5738 L
.76292 .56985 L
.76348 .56574 L
.76401 .56149 L
Mistroke
.7645 .55712 L
.76496 .55265 L
.76546 .54705 L
.76591 .54133 L
.7663 .5355 L
.76662 .5296 L
.76689 .52364 L
.76704 .51971 L
.76715 .51577 L
.76725 .51181 L
.76731 .50784 L
.76735 .50387 L
.76736 .49989 L
.76735 .49696 L
.76733 .49403 L
.7673 .49111 L
.76725 .48819 L
.76718 .48527 L
.7671 .48236 L
.76701 .47946 L
.76677 .47336 L
.76646 .46732 L
.76609 .46136 L
.76567 .45549 L
.76518 .44974 L
.76463 .44412 L
.76403 .43867 L
.76337 .43341 L
.76247 .42711 L
.76149 .42122 L
.76062 .41671 L
.75971 .41254 L
.75876 .40876 L
.75777 .40538 L
.75674 .40243 L
.75569 .39993 L
.75461 .39787 L
.75351 .39627 L
.7524 .39512 L
.75127 .39439 L
.75014 .39407 L
.74901 .39413 L
.74789 .39452 L
.74641 .39548 L
.74495 .39683 L
.74352 .39848 L
.74292 .39923 L
.74233 .4 L
.74174 .40078 L
.74115 .40157 L
Mistroke
.74057 .40235 L
.74 .40313 L
.73943 .40388 L
.73816 .40547 L
.73692 .40683 L
.73569 .40792 L
.73448 .40865 L
.73327 .40898 L
.73206 .40884 L
.73085 .4082 L
.72963 .407 L
.72864 .40564 L
.72765 .4039 L
.72663 .40176 L
.72559 .3992 L
.72452 .39623 L
.72341 .39284 L
.72227 .38902 L
.72108 .38479 L
.71985 .38016 L
.71857 .37515 L
.71723 .36979 L
.71638 .36632 L
.7155 .36276 L
.7146 .35911 L
.71368 .35539 L
.71273 .35162 L
.71176 .34783 L
.71076 .34404 L
.70974 .34027 L
.70869 .33655 L
.70739 .33217 L
.70606 .32796 L
.7044 .32315 L
.70269 .31877 L
.70046 .31399 L
.69819 .3102 L
.69618 .30779 L
.69416 .30622 L
.69212 .30548 L
.69008 .30551 L
.68805 .30623 L
.68602 .3075 L
.68401 .30919 L
.68202 .31113 L
.68005 .31316 L
.67769 .31549 L
.67536 .31743 L
.67306 .31876 L
.67076 .31925 L
Mistroke
.66908 .31901 L
.6674 .3182 L
.6657 .3168 L
.66399 .3148 L
.66226 .31222 L
.66051 .30907 L
.65872 .3054 L
.65689 .30129 L
.65503 .29681 L
.65312 .29208 L
.65116 .28721 L
.64917 .28235 L
.64712 .27766 L
.64504 .27328 L
.64291 .26936 L
.64076 .26604 L
.63857 .26343 L
.63637 .2616 L
.63415 .26059 L
.63192 .26039 L
.6297 .26094 L
.62749 .26215 L
.62529 .26388 L
.6231 .26599 L
.62094 .26831 L
.6188 .27065 L
.61668 .27286 L
.61493 .27448 L
.61318 .2758 L
.61145 .27677 L
.60972 .27732 L
.60799 .2774 L
.60627 .27699 L
.60453 .27608 L
.60279 .27466 L
.60104 .27274 L
.59882 .26972 L
.59657 .26608 L
.59465 .26266 L
.59271 .259 L
.59073 .25523 L
.58872 .25147 L
.58668 .24785 L
.58462 .2445 L
.58253 .24156 L
.58041 .23913 L
.57828 .2373 L
.57614 .23614 L
.57399 .23567 L
.57184 .23589 L
Mistroke
.56969 .23676 L
.56755 .2382 L
.56543 .24012 L
.56333 .24239 L
.56124 .24487 L
.55917 .24743 L
.55713 .24991 L
.5551 .2522 L
.55309 .25418 L
.5511 .25573 L
.54912 .25678 L
.54656 .2573 L
.544 .2568 L
.5425 .25605 L
.541 .25496 L
.53948 .25355 L
.53796 .25185 L
.53643 .2499 L
.53488 .24774 L
.53332 .24541 L
.53175 .24297 L
.52983 .23997 L
.52789 .23701 L
.52624 .23462 L
.52457 .2324 L
.52289 .23042 L
.5212 .22874 L
.5195 .22739 L
.5178 .22643 L
.51608 .22588 L
.51437 .22576 L
.51265 .22606 L
.51094 .22678 L
.50924 .22788 L
.50754 .22933 L
.50585 .23109 L
.50383 .23353 L
.50183 .23621 L
.49985 .23902 L
.49789 .24183 L
.49595 .24454 L
.49403 .24703 L
.49213 .24921 L
.48981 .25134 L
.48792 .25257 L
.48604 .25328 L
.48416 .25346 L
.48228 .25309 L
.4804 .2522 L
.4785 .25083 L
Mistroke
.4766 .24903 L
.47486 .24708 L
.4731 .24491 L
.47132 .24259 L
.46953 .24021 L
.46773 .23786 L
.4659 .23562 L
.46407 .23358 L
.46222 .23184 L
.46036 .23047 L
.45849 .22952 L
.45684 .22909 L
.4552 .22904 L
.45356 .22939 L
.45192 .23013 L
.45029 .23126 L
.44866 .23274 L
.44705 .23453 L
.44511 .23707 L
.4432 .23991 L
.44131 .24297 L
.43944 .24614 L
.43759 .24931 L
.43577 .25239 L
.43397 .25528 L
.43218 .25791 L
.43042 .2602 L
.42867 .26209 L
.42694 .26355 L
.42521 .26454 L
.42349 .26506 L
.42177 .2651 L
.41965 .26453 L
.41752 .26332 L
.41583 .26198 L
.41414 .26036 L
.41243 .25853 L
.4107 .25657 L
.40896 .25455 L
.40721 .25256 L
.40544 .2507 L
.40366 .24904 L
.40187 .24767 L
.40007 .24667 L
.39827 .24609 L
.39601 .24602 L
.39376 .24675 L
.39151 .24827 L
.38928 .25055 L
.38707 .25351 L
Mistroke
.3849 .25705 L
.38276 .26103 L
.38065 .2653 L
.37858 .26969 L
.37655 .27406 L
.37456 .27827 L
.37261 .28217 L
.37069 .28568 L
.3688 .28869 L
.36693 .29114 L
.36466 .29333 L
.36242 .2946 L
.36098 .29493 L
.35955 .2949 L
.35811 .29452 L
.35667 .29384 L
.35522 .29289 L
.35376 .29171 L
.3523 .29034 L
.35082 .28885 L
.34902 .28696 L
.3472 .28508 L
.34557 .28351 L
.34392 .28211 L
.34226 .28098 L
.3406 .28017 L
.33893 .27975 L
.33726 .27976 L
.33559 .28026 L
.33392 .28124 L
.33227 .28274 L
.33063 .28472 L
.329 .28717 L
.3274 .29005 L
.32582 .29331 L
.32426 .2969 L
.32274 .30074 L
.32124 .30477 L
.31978 .30893 L
.31834 .31314 L
.31694 .31735 L
.31528 .32236 L
.31367 .32718 L
.3121 .33173 L
.31057 .33593 L
.30863 .34083 L
.30674 .34498 L
.30489 .34832 L
.30309 .35084 L
.3013 .35253 L
Mistroke
.29954 .35345 L
.29794 .35365 L
.29635 .3533 L
.29475 .35249 L
.29314 .35128 L
.29151 .34977 L
.28987 .34808 L
.28821 .3463 L
.28653 .34457 L
.28483 .34301 L
.28311 .34174 L
.28139 .34088 L
.27965 .34053 L
.27792 .34079 L
.27619 .34172 L
.27448 .34337 L
.27279 .34575 L
.27112 .34886 L
.2695 .35266 L
.26792 .35711 L
.26639 .36212 L
.26492 .36762 L
.26352 .37352 L
.26217 .37974 L
.26062 .38767 L
.25994 .39139 L
.25929 .39514 L
.25866 .39892 L
.25805 .4027 L
.25747 .40648 L
.2569 .41025 L
.25636 .414 L
.2561 .41587 L
.25585 .41773 L
.2556 .41959 L
.25536 .42144 L
.25512 .42328 L
.25489 .42511 L
.25466 .42693 L
.25361 .4359 L
.25269 .44461 L
.25191 .45306 L
.25125 .46124 L
.25072 .4692 L
.25031 .47697 L
.25001 .48459 L
.24987 .48992 L
.24979 .49523 L
.24977 .50051 L
.2498 .5058 L
Mistroke
.2499 .51111 L
.25005 .51645 L
.25025 .52185 L
.25048 .52654 L
.25075 .53129 L
.25106 .53612 L
.25142 .54102 L
.25183 .54601 L
.25228 .5511 L
.25294 .55788 L
.25351 .56324 L
.25413 .5687 L
.25481 .57425 L
.25553 .57989 L
.25631 .5856 L
.25714 .59136 L
.25803 .59716 L
.25923 .60448 L
.26014 .60971 L
.2611 .61488 L
.26211 .61994 L
.26316 .62487 L
.26424 .62961 L
.26537 .63413 L
.26654 .63839 L
.26774 .64234 L
.26897 .64594 L
.27024 .64916 L
.27153 .65196 L
.27284 .65433 L
.27416 .65625 L
.27529 .65751 L
.27643 .65845 L
.27756 .65908 L
.27871 .65941 L
.27985 .65946 L
.281 .65925 L
.28214 .6588 L
.28353 .65798 L
.28491 .65691 L
.28605 .65589 L
.28717 .65478 L
.28828 .65362 L
.28939 .65243 L
.29049 .65127 L
.29158 .65016 L
.29294 .64889 L
.29429 .64782 L
.29589 .64689 L
.29748 .6464 L
Mistroke
.29907 .64643 L
.30066 .64704 L
.30183 .64789 L
.30302 .64909 L
.30421 .65064 L
.30542 .65256 L
.30665 .65484 L
.30789 .65748 L
.30916 .66046 L
.31046 .66376 L
.31178 .66736 L
.31313 .67123 L
.31479 .67617 L
.31616 .68029 L
.31756 .68451 L
.31899 .68877 L
.32045 .69301 L
.32195 .69716 L
.32347 .70115 L
.32503 .70491 L
.32661 .70838 L
.32822 .71148 L
.32985 .71417 L
.3315 .7164 L
.33353 .71845 L
.33557 .71974 L
.33762 .72028 L
.33967 .72012 L
.34171 .71933 L
.34375 .71802 L
.34577 .71631 L
.34777 .71434 L
.34976 .71226 L
.35172 .71023 L
.35333 .70868 L
.35493 .70733 L
.35652 .70624 L
.3581 .70548 L
.35967 .70509 L
.36125 .7051 L
.36282 .70556 L
.36418 .70631 L
.36553 .7074 L
.3669 .70882 L
.36828 .71057 L
.36966 .71263 L
.37107 .71498 L
.37249 .71759 L
.37371 .72 L
.37495 .72254 L
Mistroke
.37621 .72519 L
.37748 .72792 L
.37876 .73069 L
.38006 .73347 L
.38109 .73562 L
.38213 .73774 L
.38318 .7398 L
.38424 .74178 L
.38531 .74366 L
.38639 .74543 L
.3873 .74682 L
.38822 .74811 L
.38915 .74929 L
.39008 .75035 L
.39101 .75129 L
.39194 .75209 L
.39288 .75276 L
.39382 .75329 L
.39392 .75333 L
.39401 .75338 L
.39411 .75342 L
.3942 .75346 L
.39421 .75346 L
.39422 .75347 L
.39423 .75347 L
.39423 .75347 L
.39424 .75348 L
.39424 .75348 L
.39425 .75348 L
.39425 .75348 L
.39669 .75404 L
.39912 .7537 L
.40155 .75254 L
.40396 .7507 L
.40636 .74836 L
.40872 .74573 L
.41107 .74301 L
.41339 .74042 L
.41618 .73772 L
.41825 .7362 L
.42032 .73522 L
.42237 .73486 L
.42443 .73516 L
.42649 .73615 L
.42856 .7378 L
.43065 .74007 L
.43276 .7429 L
.4349 .74619 L
.43707 .74979 L
.43927 .75357 L
Mistroke
.4415 .75735 L
.44377 .76096 L
.44606 .76423 L
.44839 .76698 L
.45073 .76908 L
.45309 .77044 L
.45546 .77098 L
.45783 .7707 L
.46019 .76963 L
.46254 .76788 L
.46488 .76555 L
.46719 .76283 L
.46947 .75987 L
.47173 .75687 L
.47397 .754 L
.47618 .75142 L
.47807 .74955 L
.47995 .74808 L
.48182 .74708 L
.48369 .74658 L
.48555 .74662 L
.48742 .74719 L
.48929 .74827 L
.49118 .74984 L
.49307 .75183 L
.49498 .75418 L
.49692 .75679 L
.49887 .75957 L
.50084 .7624 L
.50284 .76516 L
.50465 .7675 L
.50649 .7696 L
.50833 .77139 L
.51019 .77278 L
.51206 .77374 L
.51393 .7742 L
.5158 .77417 L
.51767 .77362 L
.51874 .77308 L
.51981 .77239 L
.52088 .77155 L
.52194 .77057 L
.523 .76946 L
.52406 .76824 L
.52511 .76691 L
.52563 .76622 L
.52615 .7655 L
.52667 .76477 L
.52719 .76403 L
.52771 .76327 L
Mistroke
.52823 .7625 L
.52874 .76172 L
.52925 .76093 L
.53179 .75696 L
.5343 .75313 L
.53736 .74889 L
.53938 .74656 L
.54139 .74473 L
.54338 .74347 L
.54537 .74281 L
.54735 .74276 L
.54933 .74331 L
.55133 .74443 L
.55333 .74604 L
.55535 .74806 L
.55739 .75039 L
.55944 .75291 L
.56152 .75547 L
.56362 .75794 L
.56573 .76018 L
.56787 .76204 L
.56977 .76328 L
.57168 .76407 L
.57359 .76434 L
.57551 .76407 L
.57742 .76325 L
.57932 .76189 L
.58121 .76003 L
.58308 .75771 L
.58531 .75442 L
.58751 .75072 L
.58967 .74677 L
.5916 .74311 L
.59349 .7395 L
.59536 .73605 L
.59721 .73284 L
.59902 .72998 L
.60082 .72752 L
.6026 .72553 L
.60437 .72404 L
.60626 .72301 L
.60815 .72258 L
.61004 .72275 L
.61194 .72346 L
.61384 .72466 L
.61575 .72625 L
.61768 .72815 L
.61962 .73024 L
.62159 .73239 L
.62357 .73448 L
Mistroke
.62556 .73636 L
.62758 .73791 L
.6296 .73902 L
.63163 .73958 L
.63367 .73952 L
.63569 .73879 L
.63772 .73737 L
.6395 .73555 L
.64128 .73322 L
.64303 .73044 L
.64476 .72726 L
.64647 .72377 L
.64815 .72003 L
.64979 .71614 L
.65141 .71217 L
.65236 .70982 L
.65329 .7075 L
.65421 .7052 L
.65512 .70296 L
.65602 .70077 L
.65691 .69866 L
.6578 .69663 L
.65824 .69565 L
.65867 .69469 L
.6591 .69377 L
.65954 .69286 L
.65997 .69199 L
.66039 .69115 L
.66082 .69033 L
.66292 .68673 L
.66499 .68396 L
.66704 .68205 L
.66869 .68113 L
.67033 .68076 L
.67197 .6809 L
.67362 .6815 L
.67528 .6825 L
.67694 .68383 L
.67862 .6854 L
.68031 .68712 L
.68247 .68933 L
.68418 .69097 L
.68591 .69241 L
.68764 .69356 L
.68939 .69432 L
.69114 .6946 L
.69289 .69434 L
.69464 .69349 L
.69637 .69203 L
.69761 .69059 L
Mistroke
.69883 .68884 L
.70005 .68679 L
.70125 .68444 L
.70243 .68183 L
.7036 .67897 L
.70474 .67589 L
.70611 .67189 L
.70744 .66767 L
.70856 .6639 L
.70965 .66005 L
.71072 .65613 L
.71175 .65218 L
.71276 .64824 L
.71375 .64433 L
.71471 .64046 L
.71564 .63668 L
.71655 .63299 L
.71711 .63071 L
.71766 .62848 L
.71821 .6263 L
.71874 .62417 L
.71927 .62211 L
.71933 .62185 L
.7194 .6216 L
.71946 .62135 L
.71952 .6211 L
.71953 .62108 L
.71954 .62105 L
.71954 .62103 L
.71955 .62102 L
.71955 .62101 L
.71955 .62099 L
.71956 .62098 L
.71956 .62097 L
.72121 .61475 L
.72277 .60925 L
.72427 .6045 L
.7257 .6005 L
.72708 .59724 L
.72843 .59471 L
.72974 .59287 L
.7308 .59184 L
.73185 .59123 L
.7329 .59101 L
.73395 .59115 L
.73501 .59162 L
.73607 .59238 L
.73714 .59339 L
.73844 .59487 L
.7395 .59621 L
Mistroke
.74057 .59764 L
.74166 .59911 L
.74276 .60057 L
.74388 .60196 L
.74501 .60323 L
.74616 .60431 L
.74731 .60517 L
.74848 .60573 L
.74965 .60595 L
.75106 .6057 L
.75206 .60515 L
.75305 .60426 L
.75404 .60302 L
.755 .60143 L
.75596 .59948 L
.75689 .59717 L
.7578 .59452 L
.75815 .59336 L
.75851 .59215 L
.75885 .5909 L
.75919 .58958 L
.75953 .58822 L
.75986 .58682 L
.76019 .58536 L
.76125 .58011 L
.76223 .5744 L
.76314 .56827 L
.76398 .56179 L
.76472 .55501 L
.76538 .54798 L
.76595 .54075 L
.76642 .53337 L
.76687 .52433 L
.76711 .51744 L
.76727 .51051 L
.76735 .50354 L
.76735 .49657 L
.76727 .48961 L
.76711 .48267 L
.76687 .47578 L
.76655 .46896 L
.76615 .46222 L
.76568 .4556 L
.76542 .4525 L
.76515 .44944 L
.76486 .44642 L
.76456 .44344 L
.76424 .44051 L
.76391 .43763 L
.76355 .4348 L
Mistroke
.76277 .42909 L
.76192 .42369 L
.76101 .41864 L
.76004 .41398 L
.75902 .40975 L
.75796 .40599 L
.75685 .40273 L
.75571 .39998 L
.75426 .39732 L
.75278 .39546 L
.75127 .39439 L
.74976 .39405 L
.74825 .39436 L
.74674 .39522 L
.74525 .39653 L
.74378 .39816 L
.74234 .39998 L
.74092 .40189 L
.73953 .40375 L
.73816 .40547 L
.73682 .40693 L
.7355 .40806 L
.73376 .4089 L
.7332 .40898 L
.73265 .40897 L
.73209 .40885 L
.73153 .40863 L
.73097 .40829 L
.73041 .407