(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     26165,        875]*)
(*NotebookOutlinePosition[     32500,       1070]*)
(*  CellTagsIndexPosition[     31872,       1041]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "NumberTheory",
 StyleBox["`", "MB"],
 "FactorIntegerECM",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.68.1", "1.1"}],

Cell[TextData[{
 "This package implements Lenstra\[CloseCurlyQuote]s Elliptic Curve method of \
factorization. The package is designed to find prime factors of up to about \
18 digits in reasonable time (up to three hours on a workstation). This \
extends ",
 StyleBox["Mathematica", "TI"],
 "\[CloseCurlyQuote]s integer factoring to all numbers of 40 digits or less. \
The program in the package is a fairly direct implementation of the algorithm \
described in P.\[NonBreakingSpace]L.\[NonBreakingSpace]Montgomery\
\[CloseCurlyQuote]s, \[OpenCurlyDoubleQuote]Speeding up the Pollard and \
Elliptic Curve Methods of Factorization,\[CloseCurlyDoubleQuote] ",
 StyleBox["Mathematics of Computation", "TI"],
 " 48 (1987), pages 243\[Dash]264. "
}], "Text",
 CellTags->{"S5.68.1", "1.2"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["FactorIntegerECM[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give a single factor of the composite number ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" using Lenstra\[CloseCurlyQuote]s elliptic curve method ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.68.1"],

Cell[TextData[{
 "Using ",
 StyleBox["FactorIntegerECM", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 ". "
}], "Caption",
 CellTags->"S5.68.1"],

Cell[TextData[{
 "The algorithm returns a single factor (not necessarily a prime). To obtain \
a complete factorization, you should use ",
 StyleBox["FactorIntegerECM", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 " or the built\[Hyphen]in ",
 StyleBox["FactorInteger", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 " on the factor and cofactor. The algorithm is probabilistic, so there could \
be a large variance in running times, even for similar inputs. ",
 StyleBox["SeedRandom[101]", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 " is used to generate pseudorandom numbers for the algorithm, so the program \
will always run exactly the same on the same input. "
}], "Text",
 CellTags->{"S5.68.1", "1.3"}],

Cell[TextData[{
 StyleBox["FactorIntegerECM", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 " should be used as an enhancement to the built\[Hyphen]in functions ",
 StyleBox["PrimeQ", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 " and ",
 StyleBox["FactorInteger", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 ". The algorithm will always fail if the input is a prime. A prime number \
should never be given as input to ",
 StyleBox["FactorIntegerECM", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 ". Before using ",
 StyleBox["FactorIntegerECM", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 ", you should always use ",
 StyleBox["PrimeQ", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 " to make sure that your number is not prime. "
}], "Text",
 CellTags->{"S5.68.1", "1.4"}],

Cell[TextData[{
 "The algorithm is designed with the assumption that the number given was not \
factored by ",
 StyleBox["FactorInteger", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 ", and so its smallest prime factor is at least ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["10", "12"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". The algorithm is optimized to find factors of ",
 Cell[BoxData[
  FormBox["17", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " digits or less, so it should factor most numbers of ",
 Cell[BoxData[
  FormBox["40", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " digits or less (and such numbers will probably only have two prime factors \
if they are hard to factor). "
}], "Text",
 CellTags->{"S5.68.1", "1.5"}],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.68.1", "1.6"}],

Cell["<<NumberTheory`FactorIntegerECM`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.68.1"],

Cell[TextData[{
 StyleBox["FactorIntegerECM", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 " returns only one factor. "
}], "MathCaption",
 CellTags->{"S5.68.1", "1.7"}],

Cell[CellGroupData[{

Cell["FactorIntegerECM[91]", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.68.1"],

Cell[BoxData["13"], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.68.1"]
}, Open  ]],

Cell[TextData[{
 "In general, the hardest numbers to factor in a given range are those with \
two unequal prime factors of about the same size. These numbers can be \
generated using the built\[Hyphen]in function ",
 StyleBox["Prime", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.68.1", "1.8"}],

Cell[CellGroupData[{

Cell["Prime[10^7] Prime[10^7+1]", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.68.1"],

Cell[BoxData["32193216510801043"], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.68.1"]
}, Open  ]],

Cell["This gives a factor of the previous number. ", "MathCaption",
 CellTags->{"S5.68.1", "1.9"}],

Cell[CellGroupData[{

Cell["FactorIntegerECM[%]", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.68.1"],

Cell[BoxData["179424673"], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.68.1"]
}, Open  ]],

Cell["Here is a fairly large integer. ", "MathCaption",
 CellTags->{"S5.68.1", "1.10"}],

Cell[CellGroupData[{

Cell["(2^58 - 27) * (2^127 - 1)", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.68.1"],

Cell[BoxData["49039857307708438873655151436140637119954221204852703259"], \
"Output",
 CellLabel->"Out[5]= ",
 CellTags->"S5.68.1"]
}, Open  ]],

Cell[TextData[{
 "This result was found significantly faster than the corresponding call to \
",
 StyleBox["FactorInteger", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.68.1", "1.11"}],

Cell[CellGroupData[{

Cell["FactorIntegerECM[%]", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.68.1"],

Cell["288230376151711717", "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S5.68.1"]
}, Open  ]],

Cell[TextData[{
 "The ECM method was discovered and analyzed by H.\[NonBreakingSpace]W.\
\[NonBreakingSpace]Lenstra. It first appeared as an announcement, \
\[OpenCurlyDoubleQuote]Elliptic Curve Factorization,\[CloseCurlyDoubleQuote] \
dated February\[NonBreakingSpace]14, 1985, and published in H.\
\[NonBreakingSpace]W.\[NonBreakingSpace]Lenstra, \
\[OpenCurlyDoubleQuote]Factoring Integers with Elliptic Curves,\
\[CloseCurlyDoubleQuote] ",
 StyleBox["Annals of Mathematics", "TI"],
 " 126 (1987). "
}], "Text",
 CellTags->{"S5.68.1", "1.12"}],

Cell[TextData[{
 "This method is a generalization of the ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["p",
     "TI"], "-", "1"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " factoring algorithm of J.\[NonBreakingSpace]Pollard. The idea is to factor \
the composite number ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " by generating a random point ",
 Cell[BoxData[
  FormBox[
   StyleBox["P",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " on a random elliptic curve ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["E",
     "TI"], " ", "mod", " ", 
    StyleBox["n",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", and then use the fact that ",
 Cell[BoxData[
  FormBox[
   StyleBox["E",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " has an algebraic group structure to compute ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["k",
     "TI"], 
    RowBox[{"!", " "}], 
    StyleBox["P",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", where ",
 Cell[BoxData[
  FormBox[
   StyleBox["k",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is a relatively small integer chosen during the algorithm. If ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["k",
     "TI"], 
    RowBox[{"!", " "}], 
    StyleBox["P",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is the identity on the group ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["E",
     "TI"], " ", "mod", " ", 
    StyleBox["p",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", where ",
 Cell[BoxData[
  FormBox[
   StyleBox["p",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is a prime factor of ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", then a factorization of ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is achieved (one has to think of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["k",
     "TI"], 
    RowBox[{"!", " "}], 
    StyleBox["P",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " as being reduced ",
 Cell[BoxData[
  FormBox[
   RowBox[{"mod", " ", 
    StyleBox["p",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "). This can be detected algorithmically, since an illegal inversion ",
 Cell[BoxData[
  FormBox[
   RowBox[{"mod", " ", 
    StyleBox["n",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " must occur (",
 StyleBox["i.e.", "TI"],
 ", an illegal use of ",
 StyleBox["PowerMod[", "MR"],
 StyleBox["a", "TI"],
 StyleBox[", -1, ", "MR"],
 StyleBox["n", "TI"],
 StyleBox["]", "MR"],
 " will occur). This happens exactly when the order of the group ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["E",
     "TI"], " ", "mod", " ", 
    StyleBox["p",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", where ",
 Cell[BoxData[
  FormBox[
   StyleBox["p",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is a prime divisor of ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", is divisible only by primes less than ",
 Cell[BoxData[
  FormBox[
   StyleBox["k",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". This happens in reasonable time because one can choose many curves ",
 Cell[BoxData[
  FormBox[
   StyleBox["E",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and the order of the group ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["E",
     "TI"], " ", "mod", " ", 
    StyleBox["p",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " as ",
 Cell[BoxData[
  FormBox[
   StyleBox["E",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " varies is well distributed around ",
 Cell[BoxData[
  FormBox[
   StyleBox["p",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". This means that it will eventually hit a value that is divisible only by \
small primes (here ",
 Cell[BoxData[
  FormBox[
   StyleBox["p",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is a fixed prime divisor of ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "). "
}], "Text",
 CellTags->{"S5.68.1", "1.13"}],

Cell[TextData[{
 "The original algorithm of Lenstra was mostly of theoretical interest. Many \
of the implementation ideas are given in Montgomery\[CloseCurlyQuote]s paper. \
The most important point, first suggested by Pollard as an improvement to his \
",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["p",
     "TI"], "-", "1"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " method, is to introduce a second stage to the algorithm. The idea is that \
instead of looking just for numbers with only small factors, one looks for \
numbers that have all small factors, except for a single large factor. The \
second stage of the algorithm, therefore, takes the point ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["Q",
     "TI"], "=", 
    StyleBox["k",
     "TI"], 
    RowBox[{"!", " "}], 
    StyleBox["P",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " computed in the first stage and looks to see if any of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     StyleBox["p",
      "TI"], "1"], 
    StyleBox["Q",
     "TI"], ",", 
    SubscriptBox[
     StyleBox["p",
      "TI"], "2"], 
    StyleBox["Q",
     "TI"], ",", "\[Ellipsis]", ",", 
    SubscriptBox[
     StyleBox["p",
      "TI"], 
     StyleBox["k",
      "TI"]], 
    StyleBox["Q",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " generate a factorization of ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". Here ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["k",
     "TI"], "<", 
    SubscriptBox[
     StyleBox["p",
      "TI"], "1"], "<", 
    SubscriptBox[
     StyleBox["p",
      "TI"], "2"], "<", "\[Ellipsis]", "<", 
    SubscriptBox[
     StyleBox["p",
      "TI"], 
     StyleBox["k",
      "TI"]]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " are the primes in an interval between ",
 Cell[BoxData[
  FormBox[
   StyleBox["k",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"B", "k"}],
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " (",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["B",
     "TI"], "=", "25", 
    StyleBox["k",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " in the program). Using the second stage represents an important practical \
improvement. "
}], "Text",
 CellTags->{"S5.68.1", "1.14"}],

Cell[TextData[{
 "Montgomery and others discovered many ways to implement the above \
efficiently, and the program in the package reflects some of these ideas. An \
introductory text to this material is D.\[NonBreakingSpace]Bressoud, ",
 StyleBox["Factorization and Primality Testing", "TI"],
 ", Springer\[Hyphen]Verlag, 1989. "
}], "Text",
 CellTags->{"S5.68.1", "1.15"}],

Cell[TextData[{
 "Since the algorithm is quite involved, it is inefficient to use it on \
numbers that have small factors. These factors can be found more effectively \
using other techniques, for example, trial division. For this reason, the \
function ",
 StyleBox["FactorIntegerECM[", "MR"],
 StyleBox["n", "TI"],
 StyleBox["]", "MR"],
 " does not perform a complete factorization of ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " but instead returns only a single factor. "
}], "Text",
 CellTags->{"S5.68.1", "1.16"}],

Cell[TextData[{
 "The package should therefore be used as a method to find factors of numbers \
not factored directly by ",
 StyleBox["FactorInteger", "MR"],
 " or when only one factor at a time is required, as in the function ",
 StyleBox["SquareFreeQ", "MR"],
 " from the package ",
 StyleBox["NumberTheory`NumberTheoryFunctions`", "MR"],
 ". "
}], "Text",
 CellTags->{"S5.68.1", "1.17"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["FactorIntegerECM[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", FactorSize -> ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["q", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["optimize the algorithm to find factors of size at most ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["q", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["FactorIntegerECM[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", CurveNumber -> ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["b", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["use ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["b", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" curves at a time for each iteration of the algorithm",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["FactorIntegerECM[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", CurveCountLimit -> ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["c", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["use a total of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["c", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" curves in the algorithm ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.68.1"],

Cell[TextData[{
 "Options for ",
 StyleBox["FactorIntegerECM", "MR"],
 ". "
}], "Caption",
 CellTags->"S5.68.1"],

Cell[TextData[{
 "The options to ",
 StyleBox["FactorIntegerECM", "MR"],
 " allow you to vary parameters in the algorithms and to limit to the number \
of total steps in the algorithm. This allows one to search large numbers for \
small factors without having to achieve a complete factorization. "
}], "Text",
 CellTags->{"S5.68.1", "1.18"}],

Cell[TextData[{
 "The option ",
 StyleBox["FactorSize", "MR"],
 " specifies what size of factor you are looking for. When doing general \
purpose factoring, you usually only want to find any factor of the number ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". The default is therefore to let ",
 StyleBox["FactorSize", "MR"],
 " be about ",
 Cell[BoxData[
  FormBox[
   SqrtBox[
    StyleBox["n",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "Text",
 CellTags->{"S5.68.1", "1.19"}],

Cell[TextData[{
 "The algorithm uses a number of curves in parallel according to the size of \
the input ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". The option ",
 StyleBox["CurveNumber", "MR"],
 " allows the user to specify how many curves in parallel are used. A value \
for this option must be a power of 2. The default value of ",
 StyleBox["CurveNumber", "MR"],
 " depends on the size of the given number ",
 StyleBox["n", "MR"],
 ". For ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["n",
     "TI"], ">", 
    SuperscriptBox["10", "30"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", it is ",
 Cell[BoxData[
  FormBox["8", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". For ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["10", "20"], "<", 
    StyleBox["n",
     "TI"], "\[LessEqual]", 
    SuperscriptBox["10", "30"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", it is ",
 Cell[BoxData[
  FormBox["4", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". And for ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["n",
     "TI"], "\[LessEqual]", 
    SuperscriptBox["10", "20"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", it is ",
 Cell[BoxData[
  FormBox["2", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "Text",
 CellTags->{"S5.68.1", "1.20"}],

Cell[TextData[{
 "The advantage of using more curves in parallel is that fewer ",
 StyleBox["GCD", "MR"],
 "s are used in stage one of the algorithm and less interpretation overhead \
occurs in stage two. The disadvantage is that a nontrivial factor found on \
one curve may have to wait until the algorithm has completed all the curves. \
The number therefore depends on how many curves one expects to need in total. \
"
}], "Text",
 CellTags->{"S5.68.1", "1.21"}],

Cell[TextData[{
 "The option ",
 StyleBox["CurveCountLimit", "MR"],
 " gives an upper bound to the number of curves used in the algorithm. This \
allows the user to terminate the algorithm before a factor is found. The \
default is ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["10", "4"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " curves (essentially an infinite number). "
}], "Text",
 CellTags->{"S5.68.1", "1.22"}],

Cell[TextData[{
 "The program has modest memory requirements. A table of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"10", ",", "000"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " binary digits is set up, as well as a table of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"30", ",", "000"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " primes. "
}], "Text",
 CellTags->{"S5.68.1", "1.23"}]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.68.1"->{
    Cell[1776, 53, 145, 6, 36, "Subsection",
      CellTags->{"S5.68.1", "1.1"}],
    Cell[1924, 61, 785, 14, 104, "Text",
      CellTags->{"S5.68.1", "1.2"}],
    Cell[2712, 77, 1129, 34, 64, "DefinitionBox",
      CellTags->"S5.68.1"],
    Cell[3844, 113, 163, 7, 15, "Caption",
      CellTags->"S5.68.1"],
    Cell[4010, 122, 769, 18, 88, "Text",
      CellTags->{"S5.68.1", "1.3"}],
    Cell[4782, 142, 894, 27, 72, "Text",
      CellTags->{"S5.68.1", "1.4"}],
    Cell[5679, 171, 883, 22, 72, "Text",
      CellTags->{"S5.68.1", "1.5"}],
    Cell[6565, 195, 78, 1, 40, "MathCaption",
      CellTags->{"S5.68.1", "1.6"}],
    Cell[6646, 198, 95, 2, 28, "Input",
      CellTags->"S5.68.1"],
    Cell[6744, 202, 189, 6, 40, "MathCaption",
      CellTags->{"S5.68.1", "1.7"}],
    Cell[6958, 212, 83, 2, 28, "Input",
      CellTags->"S5.68.1"],
    Cell[7044, 216, 75, 2, 25, "Output",
      CellTags->"S5.68.1"],
    Cell[7134, 221, 297, 7, 72, "MathCaption",
      CellTags->{"S5.68.1", "1.8"}],
    Cell[7456, 232, 88, 2, 70, "Input",
      CellTags->"S5.68.1"],
    Cell[7547, 236, 90, 2, 70, "Output",
      CellTags->"S5.68.1"],
    Cell[7652, 241, 98, 1, 70, "MathCaption",
      CellTags->{"S5.68.1", "1.9"}],
    Cell[7775, 246, 82, 2, 70, "Input",
      CellTags->"S5.68.1"],
    Cell[7860, 250, 82, 2, 70, "Output",
      CellTags->"S5.68.1"],
    Cell[7957, 255, 87, 1, 70, "MathCaption",
      CellTags->{"S5.68.1", "1.10"}],
    Cell[8069, 260, 88, 2, 70, "Input",
      CellTags->"S5.68.1"],
    Cell[8160, 264, 131, 3, 70, "Output",
      CellTags->"S5.68.1"],
    Cell[8306, 270, 187, 6, 70, "MathCaption",
      CellTags->{"S5.68.1", "1.11"}],
    Cell[8518, 280, 82, 2, 70, "Input",
      CellTags->"S5.68.1"],
    Cell[8603, 284, 82, 2, 70, "Output",
      CellTags->"S5.68.1"],
    Cell[8700, 289, 546, 11, 70, "Text",
      CellTags->{"S5.68.1", "1.12"}],
    Cell[9249, 302, 5278, 190, 70, "Text",
      CellTags->{"S5.68.1", "1.13"}],
    Cell[14530, 494, 2714, 97, 70, "Text",
      CellTags->{"S5.68.1", "1.14"}],
    Cell[17247, 593, 373, 7, 70, "Text",
      CellTags->{"S5.68.1", "1.15"}],
    Cell[17623, 602, 616, 16, 70, "Text",
      CellTags->{"S5.68.1", "1.16"}],
    Cell[18242, 620, 390, 10, 70, "Text",
      CellTags->{"S5.68.1", "1.17"}],
    Cell[18635, 632, 3388, 105, 70, "DefinitionBox",
      CellTags->"S5.68.1"],
    Cell[22026, 739, 112, 5, 70, "Caption",
      CellTags->"S5.68.1"],
    Cell[22141, 746, 342, 7, 70, "Text",
      CellTags->{"S5.68.1", "1.18"}],
    Cell[22486, 755, 636, 21, 70, "Text",
      CellTags->{"S5.68.1", "1.19"}],
    Cell[23125, 778, 1625, 54, 70, "Text",
      CellTags->{"S5.68.1", "1.20"}],
    Cell[24753, 834, 465, 9, 70, "Text",
      CellTags->{"S5.68.1", "1.21"}],
    Cell[25221, 845, 462, 12, 70, "Text",
      CellTags->{"S5.68.1", "1.22"}],
    Cell[25686, 859, 463, 13, 70, "Text",
      CellTags->{"S5.68.1", "1.23"}]},
  "1.1"->{
    Cell[1776, 53, 145, 6, 36, "Subsection",
      CellTags->{"S5.68.1", "1.1"}]},
  "1.2"->{
    Cell[1924, 61, 785, 14, 104, "Text",
      CellTags->{"S5.68.1", "1.2"}]},
  "1.3"->{
    Cell[4010, 122, 769, 18, 88, "Text",
      CellTags->{"S5.68.1", "1.3"}]},
  "1.4"->{
    Cell[4782, 142, 894, 27, 72, "Text",
      CellTags->{"S5.68.1", "1.4"}]},
  "1.5"->{
    Cell[5679, 171, 883, 22, 72, "Text",
      CellTags->{"S5.68.1", "1.5"}]},
  "1.6"->{
    Cell[6565, 195, 78, 1, 40, "MathCaption",
      CellTags->{"S5.68.1", "1.6"}]},
  "1.7"->{
    Cell[6744, 202, 189, 6, 40, "MathCaption",
      CellTags->{"S5.68.1", "1.7"}]},
  "1.8"->{
    Cell[7134, 221, 297, 7, 72, "MathCaption",
      CellTags->{"S5.68.1", "1.8"}]},
  "1.9"->{
    Cell[7652, 241, 98, 1, 70, "MathCaption",
      CellTags->{"S5.68.1", "1.9"}]},
  "1.10"->{
    Cell[7957, 255, 87, 1, 70, "MathCaption",
      CellTags->{"S5.68.1", "1.10"}]},
  "1.11"->{
    Cell[8306, 270, 187, 6, 70, "MathCaption",
      CellTags->{"S5.68.1", "1.11"}]},
  "1.12"->{
    Cell[8700, 289, 546, 11, 70, "Text",
      CellTags->{"S5.68.1", "1.12"}]},
  "1.13"->{
    Cell[9249, 302, 5278, 190, 70, "Text",
      CellTags->{"S5.68.1", "1.13"}]},
  "1.14"->{
    Cell[14530, 494, 2714, 97, 70, "Text",
      CellTags->{"S5.68.1", "1.14"}]},
  "1.15"->{
    Cell[17247, 593, 373, 7, 70, "Text",
      CellTags->{"S5.68.1", "1.15"}]},
  "1.16"->{
    Cell[17623, 602, 616, 16, 70, "Text",
      CellTags->{"S5.68.1", "1.16"}]},
  "1.17"->{
    Cell[18242, 620, 390, 10, 70, "Text",
      CellTags->{"S5.68.1", "1.17"}]},
  "1.18"->{
    Cell[22141, 746, 342, 7, 70, "Text",
      CellTags->{"S5.68.1", "1.18"}]},
  "1.19"->{
    Cell[22486, 755, 636, 21, 70, "Text",
      CellTags->{"S5.68.1", "1.19"}]},
  "1.20"->{
    Cell[23125, 778, 1625, 54, 70, "Text",
      CellTags->{"S5.68.1", "1.20"}]},
  "1.21"->{
    Cell[24753, 834, 465, 9, 70, "Text",
      CellTags->{"S5.68.1", "1.21"}]},
  "1.22"->{
    Cell[25221, 845, 462, 12, 70, "Text",
      CellTags->{"S5.68.1", "1.22"}]},
  "1.23"->{
    Cell[25686, 859, 463, 13, 70, "Text",
      CellTags->{"S5.68.1", "1.23"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.68.1", 26788, 891},
  {"1.1", 29712, 968},
  {"1.2", 29806, 971},
  {"1.3", 29896, 974},
  {"1.4", 29986, 977},
  {"1.5", 30076, 980},
  {"1.6", 30166, 983},
  {"1.7", 30261, 986},
  {"1.8", 30357, 989},
  {"1.9", 30453, 992},
  {"1.10", 30549, 995},
  {"1.11", 30646, 998},
  {"1.12", 30744, 1001},
  {"1.13", 30836, 1004},
  {"1.14", 30930, 1007},
  {"1.15", 31024, 1010},
  {"1.16", 31116, 1013},
  {"1.17", 31209, 1016},
  {"1.18", 31302, 1019},
  {"1.19", 31394, 1022},
  {"1.20", 31487, 1025},
  {"1.21", 31581, 1028},
  {"1.22", 31673, 1031},
  {"1.23", 31766, 1034}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 145, 6, 36, "Subsection",
  CellTags->{"S5.68.1", "1.1"}],
Cell[1924, 61, 785, 14, 104, "Text",
  CellTags->{"S5.68.1", "1.2"}],
Cell[2712, 77, 1129, 34, 64, "DefinitionBox",
  CellTags->"S5.68.1"],
Cell[3844, 113, 163, 7, 15, "Caption",
  CellTags->"S5.68.1"],
Cell[4010, 122, 769, 18, 88, "Text",
  CellTags->{"S5.68.1", "1.3"}],
Cell[4782, 142, 894, 27, 72, "Text",
  CellTags->{"S5.68.1", "1.4"}],
Cell[5679, 171, 883, 22, 72, "Text",
  CellTags->{"S5.68.1", "1.5"}],
Cell[6565, 195, 78, 1, 40, "MathCaption",
  CellTags->{"S5.68.1", "1.6"}],
Cell[6646, 198, 95, 2, 28, "Input",
  CellTags->"S5.68.1"],
Cell[6744, 202, 189, 6, 40, "MathCaption",
  CellTags->{"S5.68.1", "1.7"}],

Cell[CellGroupData[{
Cell[6958, 212, 83, 2, 28, "Input",
  CellTags->"S5.68.1"],
Cell[7044, 216, 75, 2, 25, "Output",
  CellTags->"S5.68.1"]
}, Open  ]],
Cell[7134, 221, 297, 7, 72, "MathCaption",
  CellTags->{"S5.68.1", "1.8"}],

Cell[CellGroupData[{
Cell[7456, 232, 88, 2, 70, "Input",
  CellTags->"S5.68.1"],
Cell[7547, 236, 90, 2, 70, "Output",
  CellTags->"S5.68.1"]
}, Open  ]],
Cell[7652, 241, 98, 1, 70, "MathCaption",
  CellTags->{"S5.68.1", "1.9"}],

Cell[CellGroupData[{
Cell[7775, 246, 82, 2, 70, "Input",
  CellTags->"S5.68.1"],
Cell[7860, 250, 82, 2, 70, "Output",
  CellTags->"S5.68.1"]
}, Open  ]],
Cell[7957, 255, 87, 1, 70, "MathCaption",
  CellTags->{"S5.68.1", "1.10"}],

Cell[CellGroupData[{
Cell[8069, 260, 88, 2, 70, "Input",
  CellTags->"S5.68.1"],
Cell[8160, 264, 131, 3, 70, "Output",
  CellTags->"S5.68.1"]
}, Open  ]],
Cell[8306, 270, 187, 6, 70, "MathCaption",
  CellTags->{"S5.68.1", "1.11"}],

Cell[CellGroupData[{
Cell[8518, 280, 82, 2, 70, "Input",
  CellTags->"S5.68.1"],
Cell[8603, 284, 82, 2, 70, "Output",
  CellTags->"S5.68.1"]
}, Open  ]],
Cell[8700, 289, 546, 11, 70, "Text",
  CellTags->{"S5.68.1", "1.12"}],
Cell[9249, 302, 5278, 190, 70, "Text",
  CellTags->{"S5.68.1", "1.13"}],
Cell[14530, 494, 2714, 97, 70, "Text",
  CellTags->{"S5.68.1", "1.14"}],
Cell[17247, 593, 373, 7, 70, "Text",
  CellTags->{"S5.68.1", "1.15"}],
Cell[17623, 602, 616, 16, 70, "Text",
  CellTags->{"S5.68.1", "1.16"}],
Cell[18242, 620, 390, 10, 70, "Text",
  CellTags->{"S5.68.1", "1.17"}],
Cell[18635, 632, 3388, 105, 70, "DefinitionBox",
  CellTags->"S5.68.1"],
Cell[22026, 739, 112, 5, 70, "Caption",
  CellTags->"S5.68.1"],
Cell[22141, 746, 342, 7, 70, "Text",
  CellTags->{"S5.68.1", "1.18"}],
Cell[22486, 755, 636, 21, 70, "Text",
  CellTags->{"S5.68.1", "1.19"}],
Cell[23125, 778, 1625, 54, 70, "Text",
  CellTags->{"S5.68.1", "1.20"}],
Cell[24753, 834, 465, 9, 70, "Text",
  CellTags->{"S5.68.1", "1.21"}],
Cell[25221, 845, 462, 12, 70, "Text",
  CellTags->{"S5.68.1", "1.22"}],
Cell[25686, 859, 463, 13, 70, "Text",
  CellTags->{"S5.68.1", "1.23"}]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

