(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     13326,        740]*)
(*NotebookOutlinePosition[     15816,        819]*)
(*  CellTagsIndexPosition[     15605,        807]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Utilities",
 StyleBox["`", "MB"],
 "FilterOptions",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S6.12.1", "1.1"}],

Cell[TextData[{
 "The function ",
 StyleBox["FilterOptions", "MR"],
 " is used to select valid options when passing options from one function to \
another. "
}], "Text",
 CellTags->{"S6.12.1", "1.2"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["FilterOptions[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["symbol", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["opt",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["opt",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] ]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["return a sequence of options from ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["opt",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["opt",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" that are valid options for ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["symbol", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S6.12.1"],

Cell["A utility function for passing options. ", "Caption",
 CellTags->"S6.12.1"],

Cell[TextData[{
 "As an application of ",
 StyleBox["FilterOptions", "MR"],
 ", consider writing a new function ",
 StyleBox["PlotIntegrate", "MR"],
 " that calls the functions ",
 StyleBox["Plot", "MR"],
 " and ",
 StyleBox["Integrate", "MR"],
 " and plots the integral of a function. Although the function ",
 StyleBox["PlotIntegrate", "MR"],
 " does not use options directly, it passes options along to ",
 StyleBox["Plot", "MR"],
 " and ",
 StyleBox["Integrate", "MR"],
 ". Options that are valid for ",
 StyleBox["Integrate", "MR"],
 ", however, are not valid for ",
 StyleBox["Plot", "MR"],
 ", and options that are valid for ",
 StyleBox["Plot", "MR"],
 " are not valid for ",
 StyleBox["Integrate", "MR"],
 ". The function ",
 StyleBox["FilterOptions", "MR"],
 " is used to select a valid set of options for each function. "
}], "Text",
 CellTags->{"S6.12.1", "1.3"}],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S6.12.1", "1.4"}],

Cell["<< Utilities`FilterOptions`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S6.12.1"],

Cell[TextData[{
 "Here is a simple program that uses the ",
 StyleBox["FilterOptions", "MR"],
 " function. Valid options are selected using ",
 StyleBox["FilterOptions", "MR"],
 " before passing the option sequence to ",
 StyleBox["Plot", "MR"],
 " or ",
 StyleBox["Integrate", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S6.12.1", "1.5"}],

Cell["\<\
PlotIntegrate[f_, {x_, a_, b_}, opts___] :=
   With[{
     optPlot = FilterOptions[Plot, opts],
     optInt = FilterOptions[Integrate, opts]},
       Plot[
         Integrate[f, {x, a, t}, optInt],
         {t, a, b}, optPlot] ]\
\>", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S6.12.1"],

Cell[TextData[{
 "In this example, the ",
 StyleBox["Frame", "MR"],
 " ",
 StyleBox["->", "MR"],
 " ",
 StyleBox["True", "MR"],
 " and ",
 StyleBox["GridLines", "MR"],
 " ",
 StyleBox["->", "MR"],
 " ",
 StyleBox["Automatic", "MR"],
 " options are passed to ",
 StyleBox["Plot", "MR"],
 " but not to ",
 StyleBox["Integrate", "MR"],
 ". An error would occur if these options were passed to both functions. "
}], "MathCaption",
 CellTags->{"S6.12.1", "1.6"}],

Cell[CellGroupData[{

Cell["\<\
PlotIntegrate[Sin[x], {x, 0, 3},
   Frame -> True, GridLines -> Automatic]\
\>", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S6.12.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.31746 0.0147151 0.295782 [
[.02381 -0.0125 -3 -9 ]
[.02381 -0.0125 3 0 ]
[.18254 -0.0125 -9 -9 ]
[.18254 -0.0125 9 0 ]
[.34127 -0.0125 -3 -9 ]
[.34127 -0.0125 3 0 ]
[.5 -0.0125 -9 -9 ]
[.5 -0.0125 9 0 ]
[.65873 -0.0125 -3 -9 ]
[.65873 -0.0125 3 0 ]
[.81746 -0.0125 -9 -9 ]
[.81746 -0.0125 9 0 ]
[.97619 -0.0125 -3 -9 ]
[.97619 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01472 -6 -4.5 ]
[-0.0125 .01472 0 4.5 ]
[-0.0125 .16261 -18 -4.5 ]
[-0.0125 .16261 0 4.5 ]
[-0.0125 .3105 -6 -4.5 ]
[-0.0125 .3105 0 4.5 ]
[-0.0125 .45839 -18 -4.5 ]
[-0.0125 .45839 0 4.5 ]
[-0.0125 .60628 -6 -4.5 ]
[-0.0125 .60628 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 .61803 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 .5 r
.25 Mabswid
[ ] 0 setdash
.18254 0 m
.18254 .61803 L
s
.34127 0 m
.34127 .61803 L
s
.5 0 m
.5 .61803 L
s
.65873 0 m
.65873 .61803 L
s
.81746 0 m
.81746 .61803 L
s
0 .16261 m
1 .16261 L
s
0 .3105 m
1 .3105 L
s
0 .45839 m
1 .45839 L
s
0 g
.02381 0 m
.02381 .00625 L
s
[(0)] .02381 -0.0125 0 1 Mshowa
.18254 0 m
.18254 .00625 L
s
[(0.5)] .18254 -0.0125 0 1 Mshowa
.34127 0 m
.34127 .00625 L
s
[(1)] .34127 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(1.5)] .5 -0.0125 0 1 Mshowa
.65873 0 m
.65873 .00625 L
s
[(2)] .65873 -0.0125 0 1 Mshowa
.81746 0 m
.81746 .00625 L
s
[(2.5)] .81746 -0.0125 0 1 Mshowa
.97619 0 m
.97619 .00625 L
s
[(3)] .97619 -0.0125 0 1 Mshowa
.125 Mabswid
.05556 0 m
.05556 .00375 L
s
.0873 0 m
.0873 .00375 L
s
.11905 0 m
.11905 .00375 L
s
.15079 0 m
.15079 .00375 L
s
.21429 0 m
.21429 .00375 L
s
.24603 0 m
.24603 .00375 L
s
.27778 0 m
.27778 .00375 L
s
.30952 0 m
.30952 .00375 L
s
.37302 0 m
.37302 .00375 L
s
.40476 0 m
.40476 .00375 L
s
.43651 0 m
.43651 .00375 L
s
.46825 0 m
.46825 .00375 L
s
.53175 0 m
.53175 .00375 L
s
.56349 0 m
.56349 .00375 L
s
.59524 0 m
.59524 .00375 L
s
.62698 0 m
.62698 .00375 L
s
.69048 0 m
.69048 .00375 L
s
.72222 0 m
.72222 .00375 L
s
.75397 0 m
.75397 .00375 L
s
.78571 0 m
.78571 .00375 L
s
.84921 0 m
.84921 .00375 L
s
.88095 0 m
.88095 .00375 L
s
.9127 0 m
.9127 .00375 L
s
.94444 0 m
.94444 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01472 m
.00625 .01472 L
s
[(0)] -0.0125 .01472 1 0 Mshowa
0 .16261 m
.00625 .16261 L
s
[(0.5)] -0.0125 .16261 1 0 Mshowa
0 .3105 m
.00625 .3105 L
s
[(1)] -0.0125 .3105 1 0 Mshowa
0 .45839 m
.00625 .45839 L
s
[(1.5)] -0.0125 .45839 1 0 Mshowa
0 .60628 m
.00625 .60628 L
s
[(2)] -0.0125 .60628 1 0 Mshowa
.125 Mabswid
0 .04429 m
.00375 .04429 L
s
0 .07387 m
.00375 .07387 L
s
0 .10345 m
.00375 .10345 L
s
0 .13303 m
.00375 .13303 L
s
0 .19218 m
.00375 .19218 L
s
0 .22176 m
.00375 .22176 L
s
0 .25134 m
.00375 .25134 L
s
0 .28092 m
.00375 .28092 L
s
0 .34008 m
.00375 .34008 L
s
0 .36965 m
.00375 .36965 L
s
0 .39923 m
.00375 .39923 L
s
0 .42881 m
.00375 .42881 L
s
0 .48797 m
.00375 .48797 L
s
0 .51754 m
.00375 .51754 L
s
0 .54712 m
.00375 .54712 L
s
0 .5767 m
.00375 .5767 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
.02381 .61178 m
.02381 .61803 L
s
.18254 .61178 m
.18254 .61803 L
s
.34127 .61178 m
.34127 .61803 L
s
.5 .61178 m
.5 .61803 L
s
.65873 .61178 m
.65873 .61803 L
s
.81746 .61178 m
.81746 .61803 L
s
.97619 .61178 m
.97619 .61803 L
s
.125 Mabswid
.05556 .61428 m
.05556 .61803 L
s
.0873 .61428 m
.0873 .61803 L
s
.11905 .61428 m
.11905 .61803 L
s
.15079 .61428 m
.15079 .61803 L
s
.21429 .61428 m
.21429 .61803 L
s
.24603 .61428 m
.24603 .61803 L
s
.27778 .61428 m
.27778 .61803 L
s
.30952 .61428 m
.30952 .61803 L
s
.37302 .61428 m
.37302 .61803 L
s
.40476 .61428 m
.40476 .61803 L
s
.43651 .61428 m
.43651 .61803 L
s
.46825 .61428 m
.46825 .61803 L
s
.53175 .61428 m
.53175 .61803 L
s
.56349 .61428 m
.56349 .61803 L
s
.59524 .61428 m
.59524 .61803 L
s
.62698 .61428 m
.62698 .61803 L
s
.69048 .61428 m
.69048 .61803 L
s
.72222 .61428 m
.72222 .61803 L
s
.75397 .61428 m
.75397 .61803 L
s
.78571 .61428 m
.78571 .61803 L
s
.84921 .61428 m
.84921 .61803 L
s
.88095 .61428 m
.88095 .61803 L
s
.9127 .61428 m
.9127 .61803 L
s
.94444 .61428 m
.94444 .61803 L
s
.25 Mabswid
0 .61803 m
1 .61803 L
s
.99375 .01472 m
1 .01472 L
s
.99375 .16261 m
1 .16261 L
s
.99375 .3105 m
1 .3105 L
s
.99375 .45839 m
1 .45839 L
s
.99375 .60628 m
1 .60628 L
s
.125 Mabswid
.99625 .04429 m
1 .04429 L
s
.99625 .07387 m
1 .07387 L
s
.99625 .10345 m
1 .10345 L
s
.99625 .13303 m
1 .13303 L
s
.99625 .19218 m
1 .19218 L
s
.99625 .22176 m
1 .22176 L
s
.99625 .25134 m
1 .25134 L
s
.99625 .28092 m
1 .28092 L
s
.99625 .34008 m
1 .34008 L
s
.99625 .36965 m
1 .36965 L
s
.99625 .39923 m
1 .39923 L
s
.99625 .42881 m
1 .42881 L
s
.99625 .48797 m
1 .48797 L
s
.99625 .51754 m
1 .51754 L
s
.99625 .54712 m
1 .54712 L
s
.99625 .5767 m
1 .5767 L
s
.25 Mabswid
1 0 m
1 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .01472 m
.02499 .01472 L
.02605 .01472 L
.02729 .01473 L
.02846 .01475 L
.03053 .01478 L
.03279 .01483 L
.03527 .01491 L
.0379 .01501 L
.04262 .01523 L
.04749 .01554 L
.05205 .01588 L
.06244 .0169 L
.07305 .01827 L
.08274 .0198 L
.10458 .02424 L
.12357 .0292 L
.14429 .03576 L
.18493 .052 L
.22406 .07164 L
.26565 .09647 L
.30571 .12387 L
.34426 .15304 L
.38527 .1866 L
.42475 .22088 L
.46273 .25516 L
.50315 .2925 L
.54206 .32873 L
.58342 .36693 L
.62326 .40283 L
.66159 .43601 L
.70238 .46929 L
.74164 .49886 L
.77939 .52458 L
.8196 .54865 L
.85828 .5682 L
.89942 .5848 L
.91995 .59138 L
.93905 .59644 L
.95701 .60026 L
.97619 .60332 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S6.12.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S6.12.1"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S6.12.1"->{
    Cell[1776, 53, 139, 6, 36, "Subsection",
      CellTags->{"S6.12.1", "1.1"}],
    Cell[1918, 61, 200, 6, 40, "Text",
      CellTags->{"S6.12.1", "1.2"}],
    Cell[2121, 69, 2671, 81, 64, "DefinitionBox",
      CellTags->"S6.12.1"],
    Cell[4795, 152, 81, 1, 15, "Caption",
      CellTags->"S6.12.1"],
    Cell[4879, 155, 875, 27, 104, "Text",
      CellTags->{"S6.12.1", "1.3"}],
    Cell[5757, 184, 78, 1, 40, "MathCaption",
      CellTags->{"S6.12.1", "1.4"}],
    Cell[5838, 187, 90, 2, 28, "Input",
      CellTags->"S6.12.1"],
    Cell[5931, 191, 340, 11, 56, "MathCaption",
      CellTags->{"S6.12.1", "1.5"}],
    Cell[6274, 204, 299, 10, 130, "Input",
      CellTags->"S6.12.1"],
    Cell[6576, 216, 457, 19, 72, "MathCaption",
      CellTags->{"S6.12.1", "1.6"}],
    Cell[7058, 239, 145, 5, 45, "Input",
      CellTags->"S6.12.1"],
    Cell[7206, 246, 5909, 482, 70, 5838, 479, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S6.12.1"],
    Cell[13118, 730, 180, 6, 70, "Output",
      CellTags->"S6.12.1"]},
  "1.1"->{
    Cell[1776, 53, 139, 6, 36, "Subsection",
      CellTags->{"S6.12.1", "1.1"}]},
  "1.2"->{
    Cell[1918, 61, 200, 6, 40, "Text",
      CellTags->{"S6.12.1", "1.2"}]},
  "1.3"->{
    Cell[4879, 155, 875, 27, 104, "Text",
      CellTags->{"S6.12.1", "1.3"}]},
  "1.4"->{
    Cell[5757, 184, 78, 1, 40, "MathCaption",
      CellTags->{"S6.12.1", "1.4"}]},
  "1.5"->{
    Cell[5931, 191, 340, 11, 56, "MathCaption",
      CellTags->{"S6.12.1", "1.5"}]},
  "1.6"->{
    Cell[6576, 216, 457, 19, 72, "MathCaption",
      CellTags->{"S6.12.1", "1.6"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S6.12.1", 13949, 756},
  {"1.1", 15029, 785},
  {"1.2", 15123, 788},
  {"1.3", 15211, 791},
  {"1.4", 15302, 794},
  {"1.5", 15397, 797},
  {"1.6", 15494, 800}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 139, 6, 36, "Subsection",
  CellTags->{"S6.12.1", "1.1"}],
Cell[1918, 61, 200, 6, 40, "Text",
  CellTags->{"S6.12.1", "1.2"}],
Cell[2121, 69, 2671, 81, 64, "DefinitionBox",
  CellTags->"S6.12.1"],
Cell[4795, 152, 81, 1, 15, "Caption",
  CellTags->"S6.12.1"],
Cell[4879, 155, 875, 27, 104, "Text",
  CellTags->{"S6.12.1", "1.3"}],
Cell[5757, 184, 78, 1, 40, "MathCaption",
  CellTags->{"S6.12.1", "1.4"}],
Cell[5838, 187, 90, 2, 28, "Input",
  CellTags->"S6.12.1"],
Cell[5931, 191, 340, 11, 56, "MathCaption",
  CellTags->{"S6.12.1", "1.5"}],
Cell[6274, 204, 299, 10, 130, "Input",
  CellTags->"S6.12.1"],
Cell[6576, 216, 457, 19, 72, "MathCaption",
  CellTags->{"S6.12.1", "1.6"}],

Cell[CellGroupData[{
Cell[7058, 239, 145, 5, 45, "Input",
  CellTags->"S6.12.1"],
Cell[7206, 246, 5909, 482, 70, 5838, 479, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S6.12.1"],
Cell[13118, 730, 180, 6, 70, "Output",
  CellTags->"S6.12.1"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

