(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     76800,       2709]*)
(*NotebookOutlinePosition[     96224,       3278]*)
(*  CellTagsIndexPosition[     94610,       3210]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Algebra",
 StyleBox["`", "MB"],
 "FiniteFields",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.2.1", "1.1"}],

Cell[TextData[{
 "A field is an algebraic structure obeying the rules of ordinary arithmetic. \
In particular, a field has binary operations of addition and multiplication, \
both of which are commutative and associative. A field has two special \
elements, the additive identity ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", and multiplicative identity ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". This package adds rules to ",
 StyleBox["Plus", "MR"],
 ", ",
 StyleBox["Times", "MR"],
 ", and ",
 StyleBox["Power", "MR"],
 " so that arithmetic on field elements will be defined properly. It also \
provides low\[Hyphen]level utilities for working with finite fields and for \
formatting finite field elements. "
}], "Text",
 CellTags->{"S5.2.1", "1.2"}],

Cell[TextData[{
 "For any finite field there is a fixed prime number ",
 Cell[BoxData[
  FormBox[
   StyleBox["p",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", called the characteristic of the field, such that the sum of ",
 Cell[BoxData[
  FormBox[
   StyleBox["p",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " of the ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " field elements gives the ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " field element. A finite field of characteristic ",
 Cell[BoxData[
  FormBox[
   StyleBox["p",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " has ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["p",
     "TI"], 
    StyleBox["d",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " elements for some positive integer ",
 Cell[BoxData[
  FormBox[
   StyleBox["d",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", which we will loosely call the extension degree. This package represents \
field elements as polynomials in a single variable. The polynomials have \
degree at most ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["d",
     "TI"], "-", "1"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and their coefficients are integers reduced mod ",
 Cell[BoxData[
  FormBox[
   StyleBox["p",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "Text",
 CellTags->{"S5.2.1", "1.3"}],

Cell[TextData[{
 "The internal form of a finite field element is ",
 StyleBox["GF[", "MR"],
 StyleBox["p", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["ilist", "TI"],
 StyleBox["][", "MR"],
 StyleBox["elist", "TI"],
 StyleBox["]", "MR"],
 " where ",
 StyleBox["GF", "MR"],
 " stands for ",
 StyleBox["Galois field", "TI"],
 ", ",
 Cell[BoxData[
  FormBox[
   StyleBox["p",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is the prime characteristic of the field, ",
 StyleBox["ilist", "TI"],
 " is the coefficient list of the irreducible polynomial which defines \
multiplication in the field, and ",
 StyleBox["elist", "TI"],
 " is the coefficient list of the polynomial representing the particular \
element. Because this form can be a bit clumsy, the package provides several \
shortcuts for entering finite field elements. "
}], "Text",
 CellTags->{"S5.2.1", "1.4"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["GF[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["][{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["k", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["the integer ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["k",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" in the field of integers mod ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["p",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["GF[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", 1][{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["k", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["another way of expressing the integer ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["k",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" in the field of integers mod ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["p",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["GF[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {0,1}][{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["k", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["the full form of the integer ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["k",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" in the field of integers mod ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["p",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["GF[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["d", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["a field that is a degree ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["d",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" extension of a prime field isomorphic to ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["Z",
          "TI"], 
         StyleBox["p",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" (the integers mod ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["p",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["); an irreducible polynomial is selected automatically",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["GF[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ilist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["][", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["elist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["the full form of a finite field element, where ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ilist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is a list of integers of length ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["d",
          "TI"], "+", "1"}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[
      " representing the coefficients of an irreducible polynomial, and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["elist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is a list of integers of length ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["d",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[
      " giving the coefficients of the polynomial representation of the \
element",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.2.1"],

Cell["Ways to enter finite field elements. ", "Caption",
 CellTags->"S5.2.1"],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.2.1", "1.5"}],

Cell["<<Algebra`FiniteFields`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.2.1"],

Cell["Add 4 and 5 mod 7. The default output form is subscripted. ", \
"MathCaption",
 CellTags->{"S5.2.1", "1.6"}],

Cell[CellGroupData[{

Cell["GF[7][{4}] + GF[7][{5}]", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.2.1"],

Cell[BoxData[
 InterpretationBox[
  SubscriptBox[
   RowBox[{"{", "2", "}"}], "7"],
  Subscripted[
   {2}[7]],
  Editable->False]], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.2.1"]
}, Open  ]],

Cell[TextData[{
 "Here is the ",
 StyleBox["FullForm", "MR"],
 " of the expression. Note the automatic choice of irreducible polynomial. "
}], "MathCaption",
 CellTags->{"S5.2.1", "1.7"}],

Cell[CellGroupData[{

Cell["FullForm[%]", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.2.1"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{
    RowBox[{"GF", "[", 
     RowBox[{"7", ",", 
      RowBox[{"List", "[", 
       RowBox[{"0", ",", "1"}], "]"}]}], "]"}], "[", 
    RowBox[{"List", "[", "2", "]"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 CellLabel->"Out[3]//FullForm= ",
 CellTags->"S5.2.1"]
}, Open  ]],

Cell[TextData[{
 "Here is multiplication in the field of ",
 StyleBox["3^4", "MR"],
 " ",
 StyleBox["==", "MR"],
 " ",
 StyleBox["81", "MR"],
 " elements. "
}], "MathCaption",
 CellTags->{"S5.2.1", "1.8"}],

Cell[CellGroupData[{

Cell["GF[3,4][{1,2,1}] GF[3,4][{2,2,2,0}]", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.2.1"],

Cell[BoxData[
 InterpretationBox[
  SubscriptBox[
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "2", ",", "0"}], "}"}], "3"],
  Subscripted[
   {1, 1, 2, 0}[3]],
  Editable->False]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.2.1"]
}, Open  ]],

Cell["\<\
Field objects are automatically reduced to a canonical form. \
\>", "MathCaption",
 CellTags->{"S5.2.1", "1.9"}],

Cell[CellGroupData[{

Cell["GF[3,4][{1,2,3,4,5}]", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.2.1"],

Cell[BoxData[
 InterpretationBox[
  SubscriptBox[
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1"}], "}"}], "3"],
  Subscripted[
   {0, 0, 0, 1}[3]],
  Editable->False]], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S5.2.1"]
}, Open  ]],

Cell[TextData[{
 "Since ",
 StyleBox["Mathematica", "TI"],
 " lists polynomials with the constant term first, the same is done for \
finite field elements. In this example, the left\[Hyphen]hand zero is \
essential to give the constant term, but the right\[Hyphen]hand zero in the \
input is unnecessary. "
}], "MathCaption",
 CellTags->{"S5.2.1", "1.10"}],

Cell[CellGroupData[{

Cell["GF[3,4][{0,1,0}]", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.2.1"],

Cell[BoxData[
 InterpretationBox[
  SubscriptBox[
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}], "3"],
  Subscripted[
   {0, 1, 0, 0}[3]],
  Editable->False]], "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S5.2.1"]
}, Open  ]],

Cell["\<\
It is nonsense to add elements of different finite fields, so this expression \
does not evaluate. \
\>", "MathCaption",
 CellTags->{"S5.2.1", "1.11"}],

Cell[CellGroupData[{

Cell["GF[5,1][{1}] + GF[3,4][{1,1,1}]", "Input",
 CellLabel->"In[7]:= ",
 CellTags->"S5.2.1"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   SubscriptBox[
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", "1", ",", "0"}], "}"}], "3"],
   Subscripted[
    {1, 1, 1, 0}[3]],
   Editable->False], "+", 
  InterpretationBox[
   SubscriptBox[
    RowBox[{"{", "1", "}"}], "5"],
   Subscripted[
    {1}[5]],
   Editable->False]}]], "Output",
 CellLabel->"Out[7]= ",
 CellTags->"S5.2.1"]
}, Open  ]],

Cell["Integers are imported into finite fields. ", "MathCaption",
 CellTags->{"S5.2.1", "1.12"}],

Cell[CellGroupData[{

Cell["1 + GF[3,4][{1,1}]", "Input",
 CellLabel->"In[8]:= ",
 CellTags->"S5.2.1"],

Cell[BoxData[
 InterpretationBox[
  SubscriptBox[
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "0", ",", "0"}], "}"}], "3"],
  Subscripted[
   {2, 1, 0, 0}[3]],
  Editable->False]], "Output",
 CellLabel->"Out[8]= ",
 CellTags->"S5.2.1"]
}, Open  ]],

Cell[TextData[{
 "Zero is special. This package makes the assumption that zero is zero, \
regardless of the field it is in. The main consequence of this is that a \
field zero is simplified to the integer ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " automatically. Many functions in ",
 StyleBox["Mathematica", "TI"],
 " work better with this assumption. The assumption is not rigorously \
correct, but will not produce nonsensical output unless nonsensical input is \
given. "
}], "Text",
 CellTags->{"S5.2.1", "1.13"}],

Cell[TextData[{
 "Field zeros are simplified to the integer ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " after arithmetic. "
}], "MathCaption",
 CellTags->{"S5.2.1", "1.14"}],

Cell[CellGroupData[{

Cell["{GF[7][{1}] + GF[7][{6}], GF[3,4][{0,0,0}]}", "Input",
 CellLabel->"In[9]:= ",
 CellTags->"S5.2.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0"}], "}"}]], "Output",
 CellLabel->"Out[9]= ",
 CellTags->"S5.2.1"]
}, Open  ]],

Cell[TextData[{
 "The sum of the field zeros from different fields also simplifies to ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.2.1", "1.15"}],

Cell[CellGroupData[{

Cell["GF[7][{0}] + GF[3,4][{0,0,0}]", "Input",
 CellLabel->"In[10]:= ",
 CellTags->"S5.2.1"],

Cell[BoxData[
 InterpretationBox[
  SubscriptBox[
   RowBox[{"{", "0", "}"}], "7"],
  Subscripted[
   {0}[7]],
  Editable->False]], "Output",
 CellLabel->"Out[10]= ",
 CellTags->"S5.2.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["SetFieldFormat[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", FormatType -> Subscripted]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["set the field ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["f",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" to have a ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["Subscripted", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" output (default)",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["SetFieldFormat[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", FormatType -> FullForm]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["set the field ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["f",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" to have a ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["FullForm", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" output",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["SetFieldFormat[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", FormatType -> FunctionOfCoefficients[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["g", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["set the field ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["f",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" to input and output a field element using ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["g",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[
      " as the function name, with the arguments given by the coefficients of \
the polynomial representation of the field element",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["SetFieldFormat[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", FormatType -> FunctionOfCode[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["g", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["set the field ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["f",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" to input and output a field element using ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["g",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[
      " as the function name, with the argument given by the integer code \
specifying the field element",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.2.1"],

Cell["Field element formatting. ", "Caption",
 CellTags->"S5.2.1"],

Cell[TextData[{
 "One may always input or output the ",
 StyleBox["FullForm", "MR"],
 " of a finite field element, however the package provides some shortcuts. \
The elements of a prime field may be written ",
 StyleBox["GF[", "MR"],
 StyleBox["p", "TI"],
 StyleBox["][{", "MR"],
 StyleBox["k", "TI"],
 StyleBox["}]", "MR"],
 " or ",
 StyleBox["GF[", "MR"],
 StyleBox["p", "TI"],
 StyleBox[", 1][{", "MR"],
 StyleBox["k", "TI"],
 StyleBox["}]", "MR"],
 ", both of which are interpreted as ",
 StyleBox["GF[", "MR"],
 StyleBox["p", "TI"],
 StyleBox[", {0,1}][{", "MR"],
 StyleBox["k", "TI"],
 StyleBox["}]", "MR"],
 ". In general if ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["s",
     "TI"], "=", "=", 
    SuperscriptBox[
     StyleBox["p",
      "TI"], 
     StyleBox["d",
      "TI"]]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " with ",
 Cell[BoxData[
  FormBox[
   StyleBox["p",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " prime and ",
 Cell[BoxData[
  FormBox[
   StyleBox["d",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " a positive integer, then ",
 StyleBox["GF[", "MR"],
 StyleBox["s", "TI"],
 StyleBox["]", "MR"],
 " is interpreted as ",
 StyleBox["GF[", "MR"],
 StyleBox["p", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["d", "TI"],
 StyleBox["]", "MR"],
 ". The expression ",
 StyleBox["GF[3,", "MR"],
 " ",
 StyleBox["4]", "MR"],
 " stands for a degree 4 extension of the integers mod 3, that is, a field \
with 81 elements. When this form is used, the package automatically selects \
an irreducible polynomial, with coefficients given by ",
 StyleBox["ilist", "TI"],
 " and with the property that ",
 StyleBox["GF[", "MR"],
 StyleBox["p", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["ilist", "TI"],
 StyleBox["][{0,1}]", "MR"],
 " is a ",
 StyleBox["primitive element", "TI"],
 " of the field. It is possible to provide your own irreducible polynomial by \
giving it explicitly, as in ",
 StyleBox["GF[3,", "MR"],
 " ",
 StyleBox["{1,", "MR"],
 " ",
 StyleBox["1,", "MR"],
 " ",
 StyleBox["1,", "MR"],
 " ",
 StyleBox["1,", "MR"],
 " ",
 StyleBox["2,", "MR"],
 " ",
 StyleBox["1}]", "MR"],
 ". "
}], "Text",
 CellTags->{"S5.2.1", "1.16"}],

Cell[TextData[{
 "The default ",
 StyleBox["OutputForm", "MR"],
 " of a finite field element is a list of integers subscripted by the \
characteristic of the field. The length of the list is the degree of the \
field extension over the prime field. If you are working with only one \
representation of any field, then this will be sufficient to distinguish \
which field contains a given element. "
}], "Text",
 CellTags->{"S5.2.1", "1.17"}],

Cell[TextData[{
 "Since it is possible to have fields of the same size using different \
irreducible polynomials, it is useful to be able distinguish elements from \
these fields. It is also convenient to have a more compact way to type finite \
field elements. The function ",
 StyleBox["SetFieldFormat", "MR"],
 " establishes the input and output formats of field elements. You may always \
input field elements in the ways already described, or ask explicitly for the \
",
 StyleBox["FullForm", "MR"],
 " of the output. "
}], "Text",
 CellTags->{"S5.2.1", "1.18"}],

Cell[TextData[{
 "Note that a field head, such as ",
 StyleBox["GF[2,", "MR"],
 " ",
 StyleBox["3]", "MR"],
 " may be assigned to a symbol. The assignment ",
 StyleBox["f8", "MR"],
 " ",
 StyleBox["=", "MR"],
 " ",
 StyleBox["GF[2,", "MR"],
 " ",
 StyleBox["3]", "MR"],
 " allows you to refer to a specific field element using ",
 StyleBox["f8[{1,0,1}]", "MR"],
 ". "
}], "Text",
 CellTags->{"S5.2.1", "1.19"}],

Cell["Give a field with 9 elements a functional format. ", "MathCaption",
 CellTags->{"S5.2.1", "1.20"}],

Cell["\<\
SetFieldFormat[GF[9],
               FormatType -> FunctionOfCoefficients[f9]]\
\>", "Input",
 CellLabel->"In[11]:= ",
 CellTags->"S5.2.1"],

Cell["Here is some arithmetic with elements from this field. ", "MathCaption",
 CellTags->{"S5.2.1", "1.21"}],

Cell[CellGroupData[{

Cell["\<\
example = {f9[1,2] + f9[2], f9[1,2]^3, 2 f9[2],
      f9[2]/f9[2,2]}\
\>", "Input",
 CellLabel->"In[12]:= ",
 CellTags->"S5.2.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"f9", "[", 
     RowBox[{"0", ",", "2"}], "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"f9", "[", 
     RowBox[{"2", ",", "1"}], "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"f9", "[", "1", "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"f9", "[", 
     RowBox[{"0", ",", "1"}], "]"}],
    HoldForm]}], "}"}]], "Output",
 CellLabel->"Out[12]= ",
 CellTags->"S5.2.1"]
}, Open  ]],

Cell["\<\
Represent each element as an integer in the range 0 to 8, rather than as a \
sequence of polynomial coefficients. \
\>", "MathCaption",
 CellTags->{"S5.2.1", "1.22"}],

Cell["SetFieldFormat[GF[9], FormatType -> FunctionOfCode[f9]]", "Input",
 CellLabel->"In[13]:= ",
 CellTags->"S5.2.1"],

Cell["Here the arithmetic results are encoded. ", "MathCaption",
 CellTags->{"S5.2.1", "1.23"}],

Cell[CellGroupData[{

Cell["example", "Input",
 CellLabel->"In[14]:= ",
 CellTags->"S5.2.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"f9", "[", "6", "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"f9", "[", "5", "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"f9", "[", "1", "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"f9", "[", "3", "]"}],
    HoldForm]}], "}"}]], "Output",
 CellLabel->"Out[14]= ",
 CellTags->"S5.2.1"]
}, Open  ]],

Cell["This restores the default formatting for this field. ", "MathCaption",
 CellTags->{"S5.2.1", "1.24"}],

Cell["SetFieldFormat[GF[9]]", "Input",
 CellLabel->"In[15]:= ",
 CellTags->"S5.2.1"],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["Characteristic[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the characteristic of field ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["f",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ExtensionDegree[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the degree of the extension of field ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["f",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" over its base field",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["FieldSize[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the number of elements in field ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["f",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["FieldIrreducible[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["s", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "give the irreducible polynomial which defines multiplication in the \
field ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["f",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", expressed in terms of the symbol ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["s",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["IrreduciblePolynomial[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["s", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["d", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["find an irreducible polynomial of degree ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["d",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" over the integers mod prime ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["p",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", expressed in terms of the symbol ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["s",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.2.1"],

Cell["Field parameter functions. ", "Caption",
 CellTags->"S5.2.1"],

Cell[TextData[{
 "The functions ",
 StyleBox["Characteristic", "MR"],
 ", ",
 StyleBox["ExtensionDegree", "MR"],
 ", ",
 StyleBox["FieldSize", "MR"],
 ", ",
 StyleBox["FieldIrreducible", "MR"],
 ", and ",
 StyleBox["IrreduciblePolynomial", "MR"],
 " give important parameters about a finite field. "
}], "Text",
 CellTags->{"S5.2.1", "1.25"}],

Cell[TextData[{
 StyleBox["Characteristic", "MR"],
 " gives the prime characteristic of the field. "
}], "MathCaption",
 CellTags->{"S5.2.1", "1.26"}],

Cell[CellGroupData[{

Cell["(fld = GF[81]; Characteristic[fld])", "Input",
 CellLabel->"In[16]:= ",
 CellTags->"S5.2.1"],

Cell[BoxData["3"], "Output",
 CellLabel->"Out[16]= ",
 CellTags->"S5.2.1"]
}, Open  ]],

Cell[TextData[{
 "A field extension is a vector space over the base field. ",
 StyleBox["ExtensionDegree", "MR"],
 " gives the dimension of this vector space. "
}], "MathCaption",
 CellTags->{"S5.2.1", "1.27"}],

Cell[CellGroupData[{

Cell["ExtensionDegree[fld]", "Input",
 CellLabel->"In[17]:= ",
 CellTags->"S5.2.1"],

Cell[BoxData["4"], "Output",
 CellLabel->"Out[17]= ",
 CellTags->"S5.2.1"]
}, Open  ]],

Cell[TextData[{
 StyleBox["FieldSize", "MR"],
 " gives the number of elements in the field. "
}], "MathCaption",
 CellTags->{"S5.2.1", "1.28"}],

Cell[CellGroupData[{

Cell["FieldSize[fld]", "Input",
 CellLabel->"In[18]:= ",
 CellTags->"S5.2.1"],

Cell[BoxData["81"], "Output",
 CellLabel->"Out[18]= ",
 CellTags->"S5.2.1"]
}, Open  ]],

Cell["Here is an identity. ", "MathCaption",
 CellTags->{"S5.2.1", "1.29"}],

Cell[CellGroupData[{

Cell["FieldSize[fld] == Characteristic[fld]^ExtensionDegree[fld]", "Input",
 CellLabel->"In[19]:= ",
 CellTags->"S5.2.1"],

Cell[BoxData["True"], "Output",
 CellLabel->"Out[19]= ",
 CellTags->"S5.2.1"]
}, Open  ]],

Cell["\<\
This gives the irreducible polynomial associated with a field. \
\>", "MathCaption",
 CellTags->{"S5.2.1", "1.30"}],

Cell[CellGroupData[{

Cell["FieldIrreducible[fld, x]", "Input",
 CellLabel->"In[20]:= ",
 CellTags->"S5.2.1"],

Cell[BoxData[
 RowBox[{"2", "+", "x", "+", 
  SuperscriptBox["x", "4"]}]], "Output",
 CellLabel->"Out[20]= ",
 CellTags->"S5.2.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["Successor[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["elem", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "give the next element in a canonical ordering of the field elements \
(this function does not wrap, so the largest element has no successor)",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ReduceElement[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["elem", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "give a field element in reduced form",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ToElementCode[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["elem", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "give a nonnegative integer less than the field size that encodes the \
field element",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["FromElementCode[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["code", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the field element of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["f",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" corresponding to ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["code", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", a nonnegative integer less than the field size",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["PolynomialToElement[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["poly", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the field element of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["f",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" corresponding to ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["poly", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[
      ", a polynomial in one variable with integer\[Hyphen]valued \
coefficients",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ElementToPolynomial[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["elem", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["s", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give a polynomial in the symbol ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["s",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" corresponding to the field element ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["elem", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.2.1"],

Cell["Field element manipulation functions. ", "Caption",
 CellTags->"S5.2.1"],

Cell[TextData[{
 "The functions ",
 StyleBox["Successor", "MR"],
 ", ",
 StyleBox["ReduceElement", "MR"],
 ", ",
 StyleBox["ToElementCode", "MR"],
 ", ",
 StyleBox["FromElementCode", "MR"],
 ", ",
 StyleBox["PolynomialToElement", "MR"],
 ", and ",
 StyleBox["ElementToPolynomial", "MR"],
 " are for working with finite field elements. "
}], "Text",
 CellTags->{"S5.2.1", "1.31"}],

Cell["This gives the element as a polynomial. ", "MathCaption",
 CellTags->{"S5.2.1", "1.32"}],

Cell[CellGroupData[{

Cell["ElementToPolynomial[fld[{1,2,1,2}], x]", "Input",
 CellLabel->"In[21]:= ",
 CellTags->"S5.2.1"],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"2", " ", "x"}], "+", 
  SuperscriptBox["x", "2"], "+", 
  RowBox[{"2", " ", 
   SuperscriptBox["x", "3"]}]}]], "Output",
 CellLabel->"Out[21]= ",
 CellTags->"S5.2.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["PowerListQ[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["True", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[
      " if a list representing the powers of a primitive element of the field \
is used to do field arithmetic, ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["False", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" otherwise",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["FieldExp[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "give the value of the discrete exponential function associated with \
the field ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["f",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" for integer ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["n",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["FieldInd[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["elem", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "give the value of the discrete logarithm function associated with the \
field for element ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["elem", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["PowerList[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "give a list of the data parts of the nonzero elements of the field ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["f",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[
      ", generated by raising a primitive element of the field to integer \
powers 0, 1, 2, ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"\[Ellipsis]", " "}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["FieldSize[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]-1", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["PowerListToField[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["list", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "give the field associated with the specified list of element data \
parts, where the elements are generated by successive powers of a primitive \
element",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.2.1"],

Cell["Functions to support fast multiplication and division. ", "Caption",
 CellTags->"S5.2.1"],

Cell[TextData[{
 "A finite field must have a prime power number of elements. If it has ",
 Cell[BoxData[
  FormBox[
   StyleBox["p",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " elements, where ",
 Cell[BoxData[
  FormBox[
   StyleBox["p",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is a prime, then it is isomorphic to the integers mod ",
 Cell[BoxData[
  FormBox[
   StyleBox["p",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". In this case the package does addition, subtraction, multiplication, and \
positive powers as usual over the integers and reduces the results using ",
 StyleBox["Mod", "MR"],
 ". For negative powers the package uses ",
 StyleBox["PowerMod", "MR"],
 ". "
}], "Text",
 CellTags->{"S5.2.1", "1.33"}],

Cell[TextData[{
 "If the field has ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["p",
     "TI"], 
    StyleBox["d",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " elements, where ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["d",
     "TI"], ">", "1"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", then it is isomorphic to the set of polynomials in some variable having \
degree less than ",
 Cell[BoxData[
  FormBox[
   StyleBox["d",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and with coefficients in the integers mod ",
 Cell[BoxData[
  FormBox[
   StyleBox["p",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". Addition is polynomial addition except that the coefficients are reduced \
modulo ",
 Cell[BoxData[
  FormBox[
   StyleBox["p",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". For multiplication the product is also reduced modulo an irreducible \
(nonfactorable) polynomial over the integers modulo ",
 Cell[BoxData[
  FormBox[
   StyleBox["p",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "Text",
 CellTags->{"S5.2.1", "1.34"}],

Cell[TextData[{
 "Taking multiplicative inverses is equivalent to finding the extended \
greatest common divisor modulo ",
 Cell[BoxData[
  FormBox[
   StyleBox["p",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " with the irreducible polynomial. In other words, given the field element \
",
 StyleBox["elem", "TI"],
 " and the field\[CloseCurlyQuote]s irreducible polynomial ",
 StyleBox["irred", "TI"],
 ", find polynomials ",
 Cell[BoxData[
  FormBox[
   StyleBox["a",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox["b",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " such that ",
 StyleBox["PolynomialGCD[", "MR"],
 StyleBox["elem", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["irred", "TI"],
 StyleBox[", Modulus", "MR"],
 " ",
 StyleBox["-> ", "MR"],
 StyleBox["p", "TI"],
 StyleBox["]", "MR"],
 " equals ",
 StyleBox["PolynomialMod[", "MR"],
 StyleBox["a", "TI"],
 StyleBox[" ", "MR"],
 StyleBox["elem", "TI"],
 StyleBox[" + ", "MR"],
 StyleBox["b", "TI"],
 StyleBox[" ", "MR"],
 StyleBox["irred", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["p", "TI"],
 StyleBox["]", "MR"],
 ". If the result of ",
 StyleBox["PolynomialGCD", "MR"],
 " is unity, then ",
 Cell[BoxData[
  FormBox[
   StyleBox["a",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is the inverse of ",
 StyleBox["elem", "TI"],
 ". "
}], "Text",
 CellTags->{"S5.2.1", "1.35"}],

Cell["\<\
There is a faster way to do multiplication and compute inverses, based on the \
fact that the multiplicative group of any finite field is cyclic. If you have \
a generator of the group along with a list of the positive powers of the \
generator in sequence, then multiplication and division can be reduced to \
adding and subtracting indices of the elements in the list. \
\>", "Text",
 CellTags->{"S5.2.1", "1.36"}],

Cell[TextData[{
 "The package supports this method of arithmetic by allowing you to either \
generate a field object from a list representing the powers of a primitive \
element (",
 StyleBox["PowerListToField", "MR"],
 "), or generate a list representing the powers of a primitive element from a \
field object (",
 StyleBox["PowerList", "MR"],
 "). Setting ",
 StyleBox["PowerListQ", "MR"],
 " to ",
 StyleBox["True", "MR"],
 " causes field arithmetic to use a list of primitive element powers, by \
defining the discrete exponential function ",
 StyleBox["FieldExp", "MR"],
 " and the discrete logarithm function ",
 StyleBox["FieldInd", "MR"],
 ". The ",
 StyleBox["FieldInd", "MR"],
 " function is often called the index function for the field. The list of \
powers will depend on the choice of primitive element and on which \
irreducible polynomial is used for the field representation. Any element of \
the field for which ",
 StyleBox["FieldInd[", "MR"],
 StyleBox["elem", "TI"],
 StyleBox["]", "MR"],
 " is relatively prime to ",
 StyleBox["FieldSize[", "MR"],
 StyleBox["f", "TI"],
 StyleBox["]-1", "MR"],
 " is also a primitive element of the field. "
}], "Text",
 CellTags->{"S5.2.1", "1.37"}],

Cell[TextData[{
 "Field arithmetic using a list of primitive element powers has two \
disadvantages. It takes time to enter or compute the list, and the list can \
take considerable memory. In general, if you are doing only a few arithmetic \
operations, or if you are working in a large field, it is better not to \
create the list. Note that setting ",
 StyleBox["PowerListQ", "MR"],
 " to ",
 StyleBox["False", "MR"],
 " disables this method of doing arithmetic in a particular field, but it \
does not destroy the computed values of ",
 StyleBox["FieldExp", "MR"],
 " and ",
 StyleBox["FieldInd", "MR"],
 ". "
}], "Text",
 CellTags->{"S5.2.1", "1.38"}],

Cell[TextData[{
 "This shows that 3 is a primitive element of the integers mod 7. The other \
primitive element is 5. Since ",
 StyleBox["GF[7,1]", "MR"],
 " is a prime field, it is inefficient to use a list of primitive element \
powers for multiplication. "
}], "MathCaption",
 CellTags->{"S5.2.1", "1.39"}],

Cell[CellGroupData[{

Cell["PowerList[GF[7,1]]", "Input",
 CellLabel->"In[22]:= ",
 CellTags->"S5.2.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"{", "3", "}"}], ",", 
   RowBox[{"{", "2", "}"}], ",", 
   RowBox[{"{", "6", "}"}], ",", 
   RowBox[{"{", "4", "}"}], ",", 
   RowBox[{"{", "5", "}"}]}], "}"}]], "Output",
 CellLabel->"Out[22]= ",
 CellTags->"S5.2.1"]
}, Open  ]],

Cell[TextData[{
 "Although using a list of primitive element powers is an inefficient way to \
do ",
 StyleBox["GF[7,1]", "MR"],
 " arithmetic, this enables the method anyway. "
}], "MathCaption",
 CellTags->{"S5.2.1", "1.40"}],

Cell["PowerListQ[GF[7,1]] = True", "Input",
 CellLabel->"In[23]:= ",
 CellTags->"S5.2.1"],

Cell[TextData[{
 "The position of ",
 StyleBox["{6}", "MR"],
 " in ",
 StyleBox["PowerList", "MR"],
 " is one greater than the index given by ",
 StyleBox["FieldInd", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.2.1", "1.41"}],

Cell[CellGroupData[{

Cell["FieldInd[GF[7,1][{6}]]", "Input",
 CellLabel->"In[24]:= ",
 CellTags->"S5.2.1"],

Cell[BoxData["3"], "Output",
 CellLabel->"Out[24]= ",
 CellTags->"S5.2.1"]
}, Open  ]],

Cell[TextData[{
 StyleBox["FieldExp", "MR"],
 " and ",
 StyleBox["FieldInd", "MR"],
 " are inverses. "
}], "MathCaption",
 CellTags->{"S5.2.1", "1.42"}],

Cell[CellGroupData[{

Cell["FieldExp[GF[7,1], 3]", "Input",
 CellLabel->"In[25]:= ",
 CellTags->"S5.2.1"],

Cell[BoxData[
 InterpretationBox[
  SubscriptBox[
   RowBox[{"{", "6", "}"}], "7"],
  Subscripted[
   {6}[7]],
  Editable->False]], "Output",
 CellLabel->"Out[25]= ",
 CellTags->"S5.2.1"]
}, Open  ]],

Cell["\<\
These definitions for field index and field exponent are not part of the \
conventional definitions, but may be useful in some applications. \
\>", "MathCaption",
 CellTags->{"S5.2.1", "1.43"}],

Cell[CellGroupData[{

Cell["{FieldInd[0], FieldExp[GF[7,1], -Infinity]}", "Input",
 CellLabel->"In[26]:= ",
 CellTags->"S5.2.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}]], "Output",
 CellLabel->"Out[26]= ",
 CellTags->"S5.2.1"]
}, Open  ]],

Cell[TextData[{
 "Some books contain tables equivalent to the list given by ",
 StyleBox["PowerList", "MR"],
 ". The function ",
 StyleBox["PowerListToField", "MR"],
 " allows such a list to be used to define a field. The argument of ",
 StyleBox["PowerListToField", "MR"],
 " is a list of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     StyleBox["p",
      "TI"], 
     StyleBox["d",
      "TI"]], "-", "1"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " ",
 Cell[BoxData[
  FormBox[
   StyleBox["d",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "\[Hyphen]tuples of integers. The first ",
 Cell[BoxData[
  FormBox[
   StyleBox["d",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "\[Hyphen]tuple is assumed to give the coefficients of the polynomial \
representation of the ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " element of the field. This is used to determine whether the coefficients \
are listed constant\[Hyphen]term\[Hyphen]first or constant\[Hyphen]term\
\[Hyphen]last. The second ",
 Cell[BoxData[
  FormBox[
   StyleBox["d",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "\[Hyphen]tuple is assumed to represent a primitive element of the field. \
The succeeding ",
 Cell[BoxData[
  FormBox[
   StyleBox["d",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "\[Hyphen]tuples are assumed to represent successive powers of the second \
element. ",
 StyleBox["PowerListToField", "MR"],
 " does some elementary error checking to verify that the input list is \
valid. If so, ",
 StyleBox["PowerListToField", "MR"],
 " computes parameters of the field such as the characteristic and the \
irreducible polynomial. "
}], "Text",
 CellTags->{"S5.2.1", "1.44"}],

Cell["Here is a field of order 9. ", "MathCaption",
 CellTags->{"S5.2.1", "1.45"}],

Cell[CellGroupData[{

Cell["\<\
g9 = PowerListToField[{{1, 0}, {0, 1},
 {1, 2}, {2, 2}, {2, 0}, {0, 2}, {2, 1}, {1, 1}}]\
\>", "Input",
 CellLabel->"In[27]:= ",
 CellTags->"S5.2.1"],

Cell[BoxData[
 RowBox[{"GF", "[", 
  RowBox[{"3", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "1"}], "}"}]}], "]"}]], "Output",
 CellLabel->"Out[27]= ",
 CellTags->"S5.2.1"]
}, Open  ]],

Cell[TextData[{
 "Arithmetic works on fields defined using ",
 StyleBox["PowerListToField", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.2.1", "1.46"}],

Cell[CellGroupData[{

Cell["\<\
{g9[{1}] + g9[{1,1}], g9[{1,2}] * g9[{2,2}], 1/g9[{0,2}], g9[{2,2}]^2}\
\>", "Input",
 CellLabel->"In[28]:= ",
 CellTags->"S5.2.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    SubscriptBox[
     RowBox[{"{", 
      RowBox[{"2", ",", "1"}], "}"}], "3"],
    Subscripted[
     {2, 1}[3]],
    Editable->False], ",", 
   InterpretationBox[
    SubscriptBox[
     RowBox[{"{", 
      RowBox[{"0", ",", "2"}], "}"}], "3"],
    Subscripted[
     {0, 2}[3]],
    Editable->False], ",", 
   InterpretationBox[
    SubscriptBox[
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}], "3"],
    Subscripted[
     {2, 2}[3]],
    Editable->False], ",", 
   InterpretationBox[
    SubscriptBox[
     RowBox[{"{", 
      RowBox[{"2", ",", "1"}], "}"}], "3"],
    Subscripted[
     {2, 1}[3]],
    Editable->False]}], "}"}]], "Output",
 CellLabel->"Out[28]= ",
 CellTags->"S5.2.1"]
}, Open  ]],

Cell["The field parameters are computed automatically. ", "MathCaption",
 CellTags->{"S5.2.1", "1.47"}],

Cell[CellGroupData[{

Cell["\<\
{Characteristic[g9], ExtensionDegree[g9],
       FieldIrreducible[g9,z]}\
\>", "Input",
 CellLabel->"In[29]:= ",
 CellTags->"S5.2.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "2", ",", 
   RowBox[{"2", "+", "z", "+", 
    SuperscriptBox["z", "2"]}]}], "}"}]], "Output",
 CellLabel->"Out[29]= ",
 CellTags->"S5.2.1"]
}, Open  ]],

Cell[TextData[{
 StyleBox["FieldExp", "MR"],
 " may be used to generate the list of elements corresponding to the original \
list. "
}], "MathCaption",
 CellTags->{"S5.2.1", "1.48"}],

Cell[CellGroupData[{

Cell["Table[FieldExp[g9, i], {i, 0, 7}]", "Input",
 CellLabel->"In[30]:= ",
 CellTags->"S5.2.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    SubscriptBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], "3"],
    Subscripted[
     {1, 0}[3]],
    Editable->False], ",", 
   InterpretationBox[
    SubscriptBox[
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], "3"],
    Subscripted[
     {0, 1}[3]],
    Editable->False], ",", 
   InterpretationBox[
    SubscriptBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], "3"],
    Subscripted[
     {1, 2}[3]],
    Editable->False], ",", 
   InterpretationBox[
    SubscriptBox[
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}], "3"],
    Subscripted[
     {2, 2}[3]],
    Editable->False], ",", 
   InterpretationBox[
    SubscriptBox[
     RowBox[{"{", 
      RowBox[{"2", ",", "0"}], "}"}], "3"],
    Subscripted[
     {2, 0}[3]],
    Editable->False], ",", 
   InterpretationBox[
    SubscriptBox[
     RowBox[{"{", 
      RowBox[{"0", ",", "2"}], "}"}], "3"],
    Subscripted[
     {0, 2}[3]],
    Editable->False], ",", 
   InterpretationBox[
    SubscriptBox[
     RowBox[{"{", 
      RowBox[{"2", ",", "1"}], "}"}], "3"],
    Subscripted[
     {2, 1}[3]],
    Editable->False], ",", 
   InterpretationBox[
    SubscriptBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], "3"],
    Subscripted[
     {1, 1}[3]],
    Editable->False]}], "}"}]], "Output",
 CellLabel->"Out[30]= ",
 CellTags->"S5.2.1"]
}, Open  ]],

Cell["\<\
This gives the original list consisting of the data parts of the elements. \
\>", "MathCaption",
 CellTags->{"S5.2.1", "1.49"}],

Cell[CellGroupData[{

Cell["PowerList[g9]", "Input",
 CellLabel->"In[31]:= ",
 CellTags->"S5.2.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[31]= ",
 CellTags->"S5.2.1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Compatibility with Other ",
 StyleBox["Mathematica", "SBO"],
 " Functions"
}], "Subsubsection",
 CellTags->{"S5.2.1", "1.50"}],

Cell[TextData[{
 "Most ",
 StyleBox["Mathematica", "TI"],
 " functions are not, indeed cannot be, designed to work over arbitrary \
fields. For instance, it is nonsensical to integrate an expression containing \
a finite field object. At best, such functions will not do anything when \
given such an expression. "
}], "Text",
 CellTags->{"S5.2.1", "1.51"}],

Cell["\<\
You can generally expect these functions to treat the field object as an \
unknown symbol. Before using a function on an expression with finite field \
objects, it is wise to try some test cases first. The types of functions that \
might reasonably be expected to work are linear algebra and polynomial \
functions. \
\>", "Text",
 CellTags->{"S5.2.1", "1.52"}],

Cell[TextData[{
 "Set the format for ",
 StyleBox["GF[9]", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.2.1", "1.53"}],

Cell["SetFieldFormat[GF[9], FormatType -> FunctionOfCode[f9]]", "Input",
 CellLabel->"In[32]:= ",
 CellTags->"S5.2.1"],

Cell["Fractional powers do not work. ", "MathCaption",
 CellTags->{"S5.2.1", "1.54"}],

Cell[CellGroupData[{

Cell["Power[f9[1], 1/2]", "Input",
 CellLabel->"In[33]:= ",
 CellTags->"S5.2.1"],

Cell[BoxData[
 SqrtBox[
  TagBox[
   RowBox[{"f9", "[", "1", "]"}],
   HoldForm]]], "Output",
 CellLabel->"Out[33]= ",
 CellTags->"S5.2.1"]
}, Open  ]],

Cell[TextData[{
 StyleBox["Factor", "MR"],
 " fails because it makes the assumption that it is working over the \
rationals. "
}], "MathCaption",
 CellTags->{"S5.2.1", "1.55"}],

Cell[CellGroupData[{

Cell["Factor[Expand[(x + f9[2])(x - f9[2])]]", "Input",
 CellLabel->"In[34]:= ",
 CellTags->"S5.2.1"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["x", "2"], "+", 
  TagBox[
   RowBox[{"f9", "[", "2", "]"}],
   HoldForm]}]], "Output",
 CellLabel->"Out[34]= ",
 CellTags->"S5.2.1"]
}, Open  ]],

Cell[TextData[{
 StyleBox["PolynomialGCD", "MR"],
 " doesn\[CloseCurlyQuote]t work either. Use ",
 StyleBox["PolynomialExtendedGCD", "MR"],
 " defined in the package instead. "
}], "MathCaption",
 CellTags->{"S5.2.1", "1.56"}],

Cell[CellGroupData[{

Cell["PolynomialGCD[x + f9[1], f9[2] x + f9[2]]", "Input",
 CellLabel->"In[35]:= ",
 CellTags->"S5.2.1"],

Cell[BoxData["1"], "Output",
 CellLabel->"Out[35]= ",
 CellTags->"S5.2.1"]
}, Open  ]],

Cell[TextData[{
 "Set the format for ",
 StyleBox["GF[3, 4]", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.2.1", "1.57"}],

Cell["\<\
SetFieldFormat[GF[3,4],
               FormatType -> FunctionOfCoefficients[f81]]\
\>", "Input",
 CellLabel->"In[36]:= ",
 CellTags->"S5.2.1"],

Cell[TextData[{
 StyleBox["PolynomialQuotient", "MR"],
 " and ",
 StyleBox["PolynomialRemainder", "MR"],
 " accept polynomials over a field. "
}], "MathCaption",
 CellTags->{"S5.2.1", "1.58"}],

Cell[CellGroupData[{

Cell["\<\
{PolynomialQuotient[f81[2,2] x^4 + f81[1] x^2 +
 f81[1,1,1], f81[2] x^2 + f81[1,1,1,1], x],
 PolynomialRemainder[f81[2,2] x^4 + f81[1] x^2 +
 f81[1,1,1], f81[2] x^2 + f81[1,1,1,1], x]}\
\>", "Input",
 CellLabel->"In[37]:= ",
 CellTags->"S5.2.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], " ", 
     TagBox[
      RowBox[{"f81", "[", 
       RowBox[{"1", ",", "1"}], "]"}],
      HoldForm]}], "+", 
    TagBox[
     RowBox[{"f81", "[", 
      RowBox[{"1", ",", "1", ",", "2", ",", "2"}], "]"}],
     HoldForm]}], ",", 
   TagBox[
    RowBox[{"f81", "[", 
     RowBox[{"1", ",", "0", ",", "2", ",", "2"}], "]"}],
    HoldForm]}], "}"}]], "Output",
 CellLabel->"Out[37]= ",
 CellTags->"S5.2.1"]
}, Open  ]],

Cell[TextData[{
 StyleBox["PolynomialMod", "MR"],
 " works on polynomials over the integers, not polynomials over a field. Also \
note that a polynomial over a field is not automatically sorted from lower \
power to higher power, because ",
 StyleBox["Mathematica", "TI"],
 " does not treat ",
 StyleBox["GF", "MR"],
 " objects as numbers. "
}], "MathCaption",
 CellTags->{"S5.2.1", "1.59"}],

Cell[CellGroupData[{

Cell["\<\
PolynomialMod[f81[2,2] x^4 + f81[1] x^2 + f81[1,1,1],
 f81[2] x^2 + f81[1,1,1,1]]\
\>", "Input",
 CellLabel->"In[38]:= ",
 CellTags->"S5.2.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["x", "2"], " ", 
   TagBox[
    RowBox[{"f81", "[", "1", "]"}],
    HoldForm]}], "+", 
  TagBox[
   RowBox[{"f81", "[", 
    RowBox[{"1", ",", "1", ",", "1"}], "]"}],
   HoldForm], "+", 
  RowBox[{
   SuperscriptBox["x", "4"], " ", 
   TagBox[
    RowBox[{"f81", "[", 
     RowBox[{"2", ",", "2"}], "]"}],
    HoldForm]}]}]], "Output",
 CellLabel->"Out[38]= ",
 CellTags->"S5.2.1"]
}, Open  ]],

Cell[TextData[{
 StyleBox["Det", "MR"],
 " works on matrices of field elements. "
}], "MathCaption",
 CellTags->{"S5.2.1", "1.60"}],

Cell[CellGroupData[{

Cell["\<\
(ffmatrix = {{f81[2,1,2], f81[1,1,1]},
 {f81[1,2,1,2], f81[2]}};
 Det[ffmatrix])\
\>", "Input",
 CellLabel->"In[39]:= ",
 CellTags->"S5.2.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"f81", "[", 
   RowBox[{"0", ",", "0", ",", "2", ",", "1"}], "]"}],
  HoldForm]], "Output",
 CellLabel->"Out[39]= ",
 CellTags->"S5.2.1"]
}, Open  ]],

Cell[TextData[{
 StyleBox["RowReduce", "MR"],
 " works except that the 1 should be in the field. "
}], "MathCaption",
 CellTags->{"S5.2.1", "1.61"}],

Cell[CellGroupData[{

Cell["RowReduce[ffmatrix]", "Input",
 CellLabel->"In[40]:= ",
 CellTags->"S5.2.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[40]= ",
 CellTags->"S5.2.1"]
}, Open  ]],

Cell[TextData[{
 StyleBox["Inverse", "MR"],
 " and ",
 StyleBox["Dot", "MR"],
 " also work with matrices of field elements. "
}], "MathCaption",
 CellTags->{"S5.2.1", "1.62"}],

Cell[CellGroupData[{

Cell["Inverse[ffmatrix] . ffmatrix", "Input",
 CellLabel->"In[41]:= ",
 CellTags->"S5.2.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"f81", "[", "1", "]"}],
      HoldForm], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     TagBox[
      RowBox[{"f81", "[", "1", "]"}],
      HoldForm]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[41]= ",
 CellTags->"S5.2.1"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.2.1"->{
    Cell[1776, 53, 135, 6, 36, "Subsection",
      CellTags->{"S5.2.1", "1.1"}],
    Cell[1914, 61, 902, 22, 88, "Text",
      CellTags->{"S5.2.1", "1.2"}],
    Cell[2819, 85, 1817, 59, 88, "Text",
      CellTags->{"S5.2.1", "1.3"}],
    Cell[4639, 146, 914, 28, 88, "Text",
      CellTags->{"S5.2.1", "1.4"}],
    Cell[5556, 176, 8926, 272, 256, "DefinitionBox",
      CellTags->"S5.2.1"],
    Cell[14485, 450, 77, 1, 15, "Caption",
      CellTags->"S5.2.1"],
    Cell[14565, 453, 77, 1, 40, "MathCaption",
      CellTags->{"S5.2.1", "1.5"}],
    Cell[14645, 456, 85, 2, 28, "Input",
      CellTags->"S5.2.1"],
    Cell[14733, 460, 114, 2, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.6"}],
    Cell[14872, 466, 85, 2, 70, "Input",
      CellTags->"S5.2.1"],
    Cell[14960, 470, 186, 8, 70, "Output",
      CellTags->"S5.2.1"],
    Cell[15161, 481, 187, 5, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.7"}],
    Cell[15373, 490, 73, 2, 70, "Input",
      CellTags->"S5.2.1"],
    Cell[15449, 494, 386, 14, 70, "Output",
      CellTags->"S5.2.1"],
    Cell[15850, 511, 205, 9, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.8"}],
    Cell[16080, 524, 97, 2, 70, "Input",
      CellTags->"S5.2.1"],
    Cell[16180, 528, 240, 9, 70, "Output",
      CellTags->"S5.2.1"],
    Cell[16435, 540, 122, 3, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.9"}],
    Cell[16582, 547, 82, 2, 70, "Input",
      CellTags->"S5.2.1"],
    Cell[16667, 551, 240, 9, 70, "Output",
      CellTags->"S5.2.1"],
    Cell[16922, 563, 356, 8, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.10"}],
    Cell[17303, 575, 78, 2, 70, "Input",
      CellTags->"S5.2.1"],
    Cell[17384, 579, 240, 9, 70, "Output",
      CellTags->"S5.2.1"],
    Cell[17639, 591, 161, 4, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.11"}],
    Cell[17825, 599, 93, 2, 70, "Input",
      CellTags->"S5.2.1"],
    Cell[17921, 603, 388, 16, 70, "Output",
      CellTags->"S5.2.1"],
    Cell[18324, 622, 96, 1, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.12"}],
    Cell[18445, 627, 80, 2, 70, "Input",
      CellTags->"S5.2.1"],
    Cell[18528, 631, 240, 9, 70, "Output",
      CellTags->"S5.2.1"],
    Cell[18783, 643, 593, 13, 70, "Text",
      CellTags->{"S5.2.1", "1.13"}],
    Cell[19379, 658, 247, 7, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.14"}],
    Cell[19651, 669, 105, 2, 70, "Input",
      CellTags->"S5.2.1"],
    Cell[19759, 673, 118, 4, 70, "Output",
      CellTags->"S5.2.1"],
    Cell[19892, 680, 256, 7, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.15"}],
    Cell[20173, 691, 92, 2, 70, "Input",
      CellTags->"S5.2.1"],
    Cell[20268, 695, 187, 8, 70, "Output",
      CellTags->"S5.2.1"],
    Cell[20470, 706, 6063, 182, 70, "DefinitionBox",
      CellTags->"S5.2.1"],
    Cell[26536, 890, 66, 1, 70, "Caption",
      CellTags->"S5.2.1"],
    Cell[26605, 893, 2301, 89, 70, "Text",
      CellTags->{"S5.2.1", "1.16"}],
    Cell[28909, 984, 441, 9, 70, "Text",
      CellTags->{"S5.2.1", "1.17"}],
    Cell[29353, 995, 567, 12, 70, "Text",
      CellTags->{"S5.2.1", "1.18"}],
    Cell[29923, 1009, 410, 17, 70, "Text",
      CellTags->{"S5.2.1", "1.19"}],
    Cell[30336, 1028, 104, 1, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.20"}],
    Cell[30443, 1031, 149, 5, 70, "Input",
      CellTags->"S5.2.1"],
    Cell[30595, 1038, 109, 1, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.21"}],
    Cell[30729, 1043, 139, 5, 70, "Input",
      CellTags->"S5.2.1"],
    Cell[30871, 1050, 445, 19, 70, "Output",
      CellTags->"S5.2.1"],
    Cell[31331, 1072, 176, 4, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.22"}],
    Cell[31510, 1078, 118, 2, 70, "Input",
      CellTags->"S5.2.1"],
    Cell[31631, 1082, 95, 1, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.23"}],
    Cell[31751, 1087, 70, 2, 70, "Input",
      CellTags->"S5.2.1"],
    Cell[31824, 1091, 367, 16, 70, "Output",
      CellTags->"S5.2.1"],
    Cell[32206, 1110, 107, 1, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.24"}],
    Cell[32316, 1113, 84, 2, 70, "Input",
      CellTags->"S5.2.1"],
    Cell[32403, 1117, 6651, 204, 70, "DefinitionBox",
      CellTags->"S5.2.1"],
    Cell[39057, 1323, 67, 1, 70, "Caption",
      CellTags->"S5.2.1"],
    Cell[39127, 1326, 342, 13, 70, "Text",
      CellTags->{"S5.2.1", "1.25"}],
    Cell[39472, 1341, 150, 4, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.26"}],
    Cell[39647, 1349, 98, 2, 70, "Input",
      CellTags->"S5.2.1"],
    Cell[39748, 1353, 74, 2, 70, "Output",
      CellTags->"S5.2.1"],
    Cell[39837, 1358, 210, 5, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.27"}],
    Cell[40072, 1367, 83, 2, 70, "Input",
      CellTags->"S5.2.1"],
    Cell[40158, 1371, 74, 2, 70, "Output",
      CellTags->"S5.2.1"],
    Cell[40247, 1376, 143, 4, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.28"}],
    Cell[40415, 1384, 77, 2, 70, "Input",
      CellTags->"S5.2.1"],
    Cell[40495, 1388, 75, 2, 70, "Output",
      CellTags->"S5.2.1"],
    Cell[40585, 1393, 75, 1, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.29"}],
    Cell[40685, 1398, 121, 2, 70, "Input",
      CellTags->"S5.2.1"],
    Cell[40809, 1402, 77, 2, 70, "Output",
      CellTags->"S5.2.1"],
    Cell[40901, 1407, 125, 3, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.30"}],
    Cell[41051, 1414, 87, 2, 70, "Input",
      CellTags->"S5.2.1"],
    Cell[41141, 1418, 130, 4, 70, "Output",
      CellTags->"S5.2.1"],
    Cell[41286, 1425, 6669, 202, 70, "DefinitionBox",
      CellTags->"S5.2.1"],
    Cell[47958, 1629, 78, 1, 70, "Caption",
      CellTags->"S5.2.1"],
    Cell[48039, 1632, 379, 15, 70, "Text",
      CellTags->{"S5.2.1", "1.31"}],
    Cell[48421, 1649, 94, 1, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.32"}],
    Cell[48540, 1654, 101, 2, 70, "Input",
      CellTags->"S5.2.1"],
    Cell[48644, 1658, 211, 7, 70, "Output",
      CellTags->"S5.2.1"],
    Cell[48870, 1668, 6254, 192, 70, "DefinitionBox",
      CellTags->"S5.2.1"],
    Cell[55127, 1862, 95, 1, 70, "Caption",
      CellTags->"S5.2.1"],
    Cell[55225, 1865, 880, 26, 70, "Text",
      CellTags->{"S5.2.1", "1.33"}],
    Cell[56108, 1893, 1368, 46, 70, "Text",
      CellTags->{"S5.2.1", "1.34"}],
    Cell[57479, 1941, 1578, 59, 70, "Text",
      CellTags->{"S5.2.1", "1.35"}],
    Cell[59060, 2002, 426, 7, 70, "Text",
      CellTags->{"S5.2.1", "1.36"}],
    Cell[59489, 2011, 1206, 32, 70, "Text",
      CellTags->{"S5.2.1", "1.37"}],
    Cell[60698, 2045, 656, 16, 70, "Text",
      CellTags->{"S5.2.1", "1.38"}],
    Cell[61357, 2063, 309, 7, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.39"}],
    Cell[61691, 2074, 81, 2, 70, "Input",
      CellTags->"S5.2.1"],
    Cell[61775, 2078, 303, 10, 70, "Output",
      CellTags->"S5.2.1"],
    Cell[62093, 2091, 227, 6, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.40"}],
    Cell[62323, 2099, 89, 2, 70, "Input",
      CellTags->"S5.2.1"],
    Cell[62415, 2103, 229, 9, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.41"}],
    Cell[62669, 2116, 85, 2, 70, "Input",
      CellTags->"S5.2.1"],
    Cell[62757, 2120, 74, 2, 70, "Output",
      CellTags->"S5.2.1"],
    Cell[62846, 2125, 152, 6, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.42"}],
    Cell[63023, 2135, 83, 2, 70, "Input",
      CellTags->"S5.2.1"],
    Cell[63109, 2139, 187, 8, 70, "Output",
      CellTags->"S5.2.1"],
    Cell[63311, 2150, 203, 4, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.43"}],
    Cell[63539, 2158, 106, 2, 70, "Input",
      CellTags->"S5.2.1"],
    Cell[63648, 2162, 148, 5, 70, "Output",
      CellTags->"S5.2.1"],
    Cell[63811, 2170, 1985, 58, 70, "Text",
      CellTags->{"S5.2.1", "1.44"}],
    Cell[65799, 2230, 82, 1, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.45"}],
    Cell[65906, 2235, 159, 5, 70, "Input",
      CellTags->"S5.2.1"],
    Cell[66068, 2242, 184, 6, 70, "Output",
      CellTags->"S5.2.1"],
    Cell[66267, 2251, 154, 5, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.46"}],
    Cell[66446, 2260, 141, 4, 70, "Input",
      CellTags->"S5.2.1"],
    Cell[66590, 2266, 759, 32, 70, "Output",
      CellTags->"S5.2.1"],
    Cell[67364, 2301, 103, 1, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.47"}],
    Cell[67492, 2306, 143, 5, 70, "Input",
      CellTags->"S5.2.1"],
    Cell[67638, 2313, 189, 6, 70, "Output",
      CellTags->"S5.2.1"],
    Cell[67842, 2322, 182, 5, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.48"}],
    Cell[68049, 2331, 96, 2, 70, "Input",
      CellTags->"S5.2.1"],
    Cell[68148, 2335, 1419, 60, 70, "Output",
      CellTags->"S5.2.1"],
    Cell[69582, 2398, 137, 3, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.49"}],
    Cell[69744, 2405, 76, 2, 70, "Input",
      CellTags->"S5.2.1"],
    Cell[69823, 2409, 571, 20, 70, "Output",
      CellTags->"S5.2.1"],
    Cell[70431, 2434, 144, 5, 70, "Subsubsection",
      CellTags->{"S5.2.1", "1.50"}],
    Cell[70578, 2441, 357, 8, 70, "Text",
      CellTags->{"S5.2.1", "1.51"}],
    Cell[70938, 2451, 371, 7, 70, "Text",
      CellTags->{"S5.2.1", "1.52"}],
    Cell[71312, 2460, 121, 5, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.53"}],
    Cell[71436, 2467, 118, 2, 70, "Input",
      CellTags->"S5.2.1"],
    Cell[71557, 2471, 85, 1, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.54"}],
    Cell[71667, 2476, 80, 2, 70, "Input",
      CellTags->"S5.2.1"],
    Cell[71750, 2480, 139, 6, 70, "Output",
      CellTags->"S5.2.1"],
    Cell[71904, 2489, 176, 5, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.55"}],
    Cell[72105, 2498, 101, 2, 70, "Input",
      CellTags->"S5.2.1"],
    Cell[72209, 2502, 174, 7, 70, "Output",
      CellTags->"S5.2.1"],
    Cell[72398, 2512, 226, 6, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.56"}],
    Cell[72649, 2522, 104, 2, 70, "Input",
      CellTags->"S5.2.1"],
    Cell[72756, 2526, 74, 2, 70, "Output",
      CellTags->"S5.2.1"],
    Cell[72845, 2531, 124, 5, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.57"}],
    Cell[72972, 2538, 152, 5, 70, "Input",
      CellTags->"S5.2.1"],
    Cell[73127, 2545, 192, 6, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.58"}],
    Cell[73344, 2555, 255, 7, 70, "Input",
      CellTags->"S5.2.1"],
    Cell[73602, 2564, 499, 19, 70, "Output",
      CellTags->"S5.2.1"],
    Cell[74116, 2586, 391, 10, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.59"}],
    Cell[74532, 2600, 152, 5, 70, "Input",
      CellTags->"S5.2.1"],
    Cell[74687, 2607, 434, 18, 70, "Output",
      CellTags->"S5.2.1"],
    Cell[75136, 2628, 131, 4, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.60"}],
    Cell[75292, 2636, 151, 6, 70, "Input",
      CellTags->"S5.2.1"],
    Cell[75446, 2644, 170, 6, 70, "Output",
      CellTags->"S5.2.1"],
    Cell[75631, 2653, 148, 4, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.61"}],
    Cell[75804, 2661, 82, 2, 70, "Input",
      CellTags->"S5.2.1"],
    Cell[75889, 2665, 217, 8, 70, "Output",
      CellTags->"S5.2.1"],
    Cell[76121, 2676, 175, 6, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.62"}],
    Cell[76321, 2686, 91, 2, 70, "Input",
      CellTags->"S5.2.1"],
    Cell[76415, 2690, 345, 14, 70, "Output",
      CellTags->"S5.2.1"]},
  "1.1"->{
    Cell[1776, 53, 135, 6, 36, "Subsection",
      CellTags->{"S5.2.1", "1.1"}]},
  "1.2"->{
    Cell[1914, 61, 902, 22, 88, "Text",
      CellTags->{"S5.2.1", "1.2"}]},
  "1.3"->{
    Cell[2819, 85, 1817, 59, 88, "Text",
      CellTags->{"S5.2.1", "1.3"}]},
  "1.4"->{
    Cell[4639, 146, 914, 28, 88, "Text",
      CellTags->{"S5.2.1", "1.4"}]},
  "1.5"->{
    Cell[14565, 453, 77, 1, 40, "MathCaption",
      CellTags->{"S5.2.1", "1.5"}]},
  "1.6"->{
    Cell[14733, 460, 114, 2, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.6"}]},
  "1.7"->{
    Cell[15161, 481, 187, 5, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.7"}]},
  "1.8"->{
    Cell[15850, 511, 205, 9, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.8"}]},
  "1.9"->{
    Cell[16435, 540, 122, 3, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.9"}]},
  "1.10"->{
    Cell[16922, 563, 356, 8, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.10"}]},
  "1.11"->{
    Cell[17639, 591, 161, 4, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.11"}]},
  "1.12"->{
    Cell[18324, 622, 96, 1, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.12"}]},
  "1.13"->{
    Cell[18783, 643, 593, 13, 70, "Text",
      CellTags->{"S5.2.1", "1.13"}]},
  "1.14"->{
    Cell[19379, 658, 247, 7, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.14"}]},
  "1.15"->{
    Cell[19892, 680, 256, 7, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.15"}]},
  "1.16"->{
    Cell[26605, 893, 2301, 89, 70, "Text",
      CellTags->{"S5.2.1", "1.16"}]},
  "1.17"->{
    Cell[28909, 984, 441, 9, 70, "Text",
      CellTags->{"S5.2.1", "1.17"}]},
  "1.18"->{
    Cell[29353, 995, 567, 12, 70, "Text",
      CellTags->{"S5.2.1", "1.18"}]},
  "1.19"->{
    Cell[29923, 1009, 410, 17, 70, "Text",
      CellTags->{"S5.2.1", "1.19"}]},
  "1.20"->{
    Cell[30336, 1028, 104, 1, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.20"}]},
  "1.21"->{
    Cell[30595, 1038, 109, 1, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.21"}]},
  "1.22"->{
    Cell[31331, 1072, 176, 4, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.22"}]},
  "1.23"->{
    Cell[31631, 1082, 95, 1, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.23"}]},
  "1.24"->{
    Cell[32206, 1110, 107, 1, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.24"}]},
  "1.25"->{
    Cell[39127, 1326, 342, 13, 70, "Text",
      CellTags->{"S5.2.1", "1.25"}]},
  "1.26"->{
    Cell[39472, 1341, 150, 4, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.26"}]},
  "1.27"->{
    Cell[39837, 1358, 210, 5, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.27"}]},
  "1.28"->{
    Cell[40247, 1376, 143, 4, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.28"}]},
  "1.29"->{
    Cell[40585, 1393, 75, 1, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.29"}]},
  "1.30"->{
    Cell[40901, 1407, 125, 3, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.30"}]},
  "1.31"->{
    Cell[48039, 1632, 379, 15, 70, "Text",
      CellTags->{"S5.2.1", "1.31"}]},
  "1.32"->{
    Cell[48421, 1649, 94, 1, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.32"}]},
  "1.33"->{
    Cell[55225, 1865, 880, 26, 70, "Text",
      CellTags->{"S5.2.1", "1.33"}]},
  "1.34"->{
    Cell[56108, 1893, 1368, 46, 70, "Text",
      CellTags->{"S5.2.1", "1.34"}]},
  "1.35"->{
    Cell[57479, 1941, 1578, 59, 70, "Text",
      CellTags->{"S5.2.1", "1.35"}]},
  "1.36"->{
    Cell[59060, 2002, 426, 7, 70, "Text",
      CellTags->{"S5.2.1", "1.36"}]},
  "1.37"->{
    Cell[59489, 2011, 1206, 32, 70, "Text",
      CellTags->{"S5.2.1", "1.37"}]},
  "1.38"->{
    Cell[60698, 2045, 656, 16, 70, "Text",
      CellTags->{"S5.2.1", "1.38"}]},
  "1.39"->{
    Cell[61357, 2063, 309, 7, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.39"}]},
  "1.40"->{
    Cell[62093, 2091, 227, 6, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.40"}]},
  "1.41"->{
    Cell[62415, 2103, 229, 9, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.41"}]},
  "1.42"->{
    Cell[62846, 2125, 152, 6, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.42"}]},
  "1.43"->{
    Cell[63311, 2150, 203, 4, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.43"}]},
  "1.44"->{
    Cell[63811, 2170, 1985, 58, 70, "Text",
      CellTags->{"S5.2.1", "1.44"}]},
  "1.45"->{
    Cell[65799, 2230, 82, 1, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.45"}]},
  "1.46"->{
    Cell[66267, 2251, 154, 5, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.46"}]},
  "1.47"->{
    Cell[67364, 2301, 103, 1, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.47"}]},
  "1.48"->{
    Cell[67842, 2322, 182, 5, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.48"}]},
  "1.49"->{
    Cell[69582, 2398, 137, 3, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.49"}]},
  "1.50"->{
    Cell[70431, 2434, 144, 5, 70, "Subsubsection",
      CellTags->{"S5.2.1", "1.50"}]},
  "1.51"->{
    Cell[70578, 2441, 357, 8, 70, "Text",
      CellTags->{"S5.2.1", "1.51"}]},
  "1.52"->{
    Cell[70938, 2451, 371, 7, 70, "Text",
      CellTags->{"S5.2.1", "1.52"}]},
  "1.53"->{
    Cell[71312, 2460, 121, 5, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.53"}]},
  "1.54"->{
    Cell[71557, 2471, 85, 1, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.54"}]},
  "1.55"->{
    Cell[71904, 2489, 176, 5, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.55"}]},
  "1.56"->{
    Cell[72398, 2512, 226, 6, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.56"}]},
  "1.57"->{
    Cell[72845, 2531, 124, 5, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.57"}]},
  "1.58"->{
    Cell[73127, 2545, 192, 6, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.58"}]},
  "1.59"->{
    Cell[74116, 2586, 391, 10, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.59"}]},
  "1.60"->{
    Cell[75136, 2628, 131, 4, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.60"}]},
  "1.61"->{
    Cell[75631, 2653, 148, 4, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.61"}]},
  "1.62"->{
    Cell[76121, 2676, 175, 6, 70, "MathCaption",
      CellTags->{"S5.2.1", "1.62"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.2.1", 77422, 2725},
  {"1.1", 88618, 3020},
  {"1.2", 88711, 3023},
  {"1.3", 88799, 3026},
  {"1.4", 88888, 3029},
  {"1.5", 88977, 3032},
  {"1.6", 89072, 3035},
  {"1.7", 89168, 3038},
  {"1.8", 89264, 3041},
  {"1.9", 89360, 3044},
  {"1.10", 89457, 3047},
  {"1.11", 89555, 3050},
  {"1.12", 89653, 3053},
  {"1.13", 89750, 3056},
  {"1.14", 89842, 3059},
  {"1.15", 89940, 3062},
  {"1.16", 90038, 3065},
  {"1.17", 90131, 3068},
  {"1.18", 90222, 3071},
  {"1.19", 90314, 3074},
  {"1.20", 90407, 3077},
  {"1.21", 90506, 3080},
  {"1.22", 90605, 3083},
  {"1.23", 90704, 3086},
  {"1.24", 90802, 3089},
  {"1.25", 90901, 3092},
  {"1.26", 90994, 3095},
  {"1.27", 91093, 3098},
  {"1.28", 91192, 3101},
  {"1.29", 91291, 3104},
  {"1.30", 91389, 3107},
  {"1.31", 91488, 3110},
  {"1.32", 91581, 3113},
  {"1.33", 91679, 3116},
  {"1.34", 91772, 3119},
  {"1.35", 91866, 3122},
  {"1.36", 91960, 3125},
  {"1.37", 92052, 3128},
  {"1.38", 92146, 3131},
  {"1.39", 92239, 3134},
  {"1.40", 92338, 3137},
  {"1.41", 92437, 3140},
  {"1.42", 92536, 3143},
  {"1.43", 92635, 3146},
  {"1.44", 92734, 3149},
  {"1.45", 92828, 3152},
  {"1.46", 92926, 3155},
  {"1.47", 93025, 3158},
  {"1.48", 93124, 3161},
  {"1.49", 93223, 3164},
  {"1.50", 93322, 3167},
  {"1.51", 93423, 3170},
  {"1.52", 93515, 3173},
  {"1.53", 93607, 3176},
  {"1.54", 93706, 3179},
  {"1.55", 93804, 3182},
  {"1.56", 93903, 3185},
  {"1.57", 94002, 3188},
  {"1.58", 94101, 3191},
  {"1.59", 94200, 3194},
  {"1.60", 94300, 3197},
  {"1.61", 94399, 3200},
  {"1.62", 94498, 3203}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 135, 6, 36, "Subsection",
  CellTags->{"S5.2.1", "1.1"}],
Cell[1914, 61, 902, 22, 88, "Text",
  CellTags->{"S5.2.1", "1.2"}],
Cell[2819, 85, 1817, 59, 88, "Text",
  CellTags->{"S5.2.1", "1.3"}],
Cell[4639, 146, 914, 28, 88, "Text",
  CellTags->{"S5.2.1", "1.4"}],
Cell[5556, 176, 8926, 272, 256, "DefinitionBox",
  CellTags->"S5.2.1"],
Cell[14485, 450, 77, 1, 15, "Caption",
  CellTags->"S5.2.1"],
Cell[14565, 453, 77, 1, 40, "MathCaption",
  CellTags->{"S5.2.1", "1.5"}],
Cell[14645, 456, 85, 2, 28, "Input",
  CellTags->"S5.2.1"],
Cell[14733, 460, 114, 2, 70, "MathCaption",
  CellTags->{"S5.2.1", "1.6"}],

Cell[CellGroupData[{
Cell[14872, 466, 85, 2, 70, "Input",
  CellTags->"S5.2.1"],
Cell[14960, 470, 186, 8, 70, "Output",
  CellTags->"S5.2.1"]
}, Open  ]],
Cell[15161, 481, 187, 5, 70, "MathCaption",
  CellTags->{"S5.2.1", "1.7"}],

Cell[CellGroupData[{
Cell[15373, 490, 73, 2, 70, "Input",
  CellTags->"S5.2.1"],
Cell[15449, 494, 386, 14, 70, "Output",
  CellTags->"S5.2.1"]
}, Open  ]],
Cell[15850, 511, 205, 9, 70, "MathCaption",
  CellTags->{"S5.2.1", "1.8"}],

Cell[CellGroupData[{
Cell[16080, 524, 97, 2, 70, "Input",
  CellTags->"S5.2.1"],
Cell[16180, 528, 240, 9, 70, "Output",
  CellTags->"S5.2.1"]
}, Open  ]],
Cell[16435, 540, 122, 3, 70, "MathCaption",
  CellTags->{"S5.2.1", "1.9"}],

Cell[CellGroupData[{
Cell[16582, 547, 82, 2, 70, "Input",
  CellTags->"S5.2.1"],
Cell[16667, 551, 240, 9, 70, "Output",
  CellTags->"S5.2.1"]
}, Open  ]],
Cell[16922, 563, 356, 8, 70, "MathCaption",
  CellTags->{"S5.2.1", "1.10"}],

Cell[CellGroupData[{
Cell[17303, 575, 78, 2, 70, "Input",
  CellTags->"S5.2.1"],
Cell[17384, 579, 240, 9, 70, "Output",
  CellTags->"S5.2.1"]
}, Open  ]],
Cell[17639, 591, 161, 4, 70, "MathCaption",
  CellTags->{"S5.2.1", "1.11"}],

Cell[CellGroupData[{
Cell[17825, 599, 93, 2, 70, "Input",
  CellTags->"S5.2.1"],
Cell[17921, 603, 388, 16, 70, "Output",
  CellTags->"S5.2.1"]
}, Open  ]],
Cell[18324, 622, 96, 1, 70, "MathCaption",
  CellTags->{"S5.2.1", "1.12"}],

Cell[CellGroupData[{
Cell[18445, 627, 80, 2, 70, "Input",
  CellTags->"S5.2.1"],
Cell[18528, 631, 240, 9, 70, "Output",
  CellTags->"S5.2.1"]
}, Open  ]],
Cell[18783, 643, 593, 13, 70, "Text",
  CellTags->{"S5.2.1", "1.13"}],
Cell[19379, 658, 247, 7, 70, "MathCaption",
  CellTags->{"S5.2.1", "1.14"}],

Cell[CellGroupData[{
Cell[19651, 669, 105, 2, 70, "Input",
  CellTags->"S5.2.1"],
Cell[19759, 673, 118, 4, 70, "Output",
  CellTags->"S5.2.1"]
}, Open  ]],
Cell[19892, 680, 256, 7, 70, "MathCaption",
  CellTags->{"S5.2.1", "1.15"}],

Cell[CellGroupData[{
Cell[20173, 691, 92, 2, 70, "Input",
  CellTags->"S5.2.1"],
Cell[20268, 695, 187, 8, 70, "Output",
  CellTags->"S5.2.1"]
}, Open  ]],
Cell[20470, 706, 6063, 182, 70, "DefinitionBox",
  CellTags->"S5.2.1"],
Cell[26536, 890, 66, 1, 70, "Caption",
  CellTags->"S5.2.1"],
Cell[26605, 893, 2301, 89, 70, "Text",
  CellTags->{"S5.2.1", "1.16"}],
Cell[28909, 984, 441, 9, 70, "Text",
  CellTags->{"S5.2.1", "1.17"}],
Cell[29353, 995, 567, 12, 70, "Text",
  CellTags->{"S5.2.1", "1.18"}],
Cell[29923, 1009, 410, 17, 70, "Text",
  CellTags->{"S5.2.1", "1.19"}],
Cell[30336, 1028, 104, 1, 70, "MathCaption",
  CellTags->{"S5.2.1", "1.20"}],
Cell[30443, 1031, 149, 5, 70, "Input",
  CellTags->"S5.2.1"],
Cell[30595, 1038, 109, 1, 70, "MathCaption",
  CellTags->{"S5.2.1", "1.21"}],

Cell[CellGroupData[{
Cell[30729, 1043, 139, 5, 70, "Input",
  CellTags->"S5.2.1"],
Cell[30871, 1050, 445, 19, 70, "Output",
  CellTags->"S5.2.1"]
}, Open  ]],
Cell[31331, 1072, 176, 4, 70, "MathCaption",
  CellTags->{"S5.2.1", "1.22"}],
Cell[31510, 1078, 118, 2, 70, "Input",
  CellTags->"S5.2.1"],
Cell[31631, 1082, 95, 1, 70, "MathCaption",
  CellTags->{"S5.2.1", "1.23"}],

Cell[CellGroupData[{
Cell[31751, 1087, 70, 2, 70, "Input",
  CellTags->"S5.2.1"],
Cell[31824, 1091, 367, 16, 70, "Output",
  CellTags->"S5.2.1"]
}, Open  ]],
Cell[32206, 1110, 107, 1, 70, "MathCaption",
  CellTags->{"S5.2.1", "1.24"}],
Cell[32316, 1113, 84, 2, 70, "Input",
  CellTags->"S5.2.1"],
Cell[32403, 1117, 6651, 204, 70, "DefinitionBox",
  CellTags->"S5.2.1"],
Cell[39057, 1323, 67, 1, 70, "Caption",
  CellTags->"S5.2.1"],
Cell[39127, 1326, 342, 13, 70, "Text",
  CellTags->{"S5.2.1", "1.25"}],
Cell[39472, 1341, 150, 4, 70, "MathCaption",
  CellTags->{"S5.2.1", "1.26"}],

Cell[CellGroupData[{
Cell[39647, 1349, 98, 2, 70, "Input",
  CellTags->"S5.2.1"],
Cell[39748, 1353, 74, 2, 70, "Output",
  CellTags->"S5.2.1"]
}, Open  ]],
Cell[39837, 1358, 210, 5, 70, "MathCaption",
  CellTags->{"S5.2.1", "1.27"}],

Cell[CellGroupData[{
Cell[40072, 1367, 83, 2, 70, "Input",
  CellTags->"S5.2.1"],
Cell[40158, 1371, 74, 2, 70, "Output",
  CellTags->"S5.2.1"]
}, Open  ]],
Cell[40247, 1376, 143, 4, 70, "MathCaption",
  CellTags->{"S5.2.1", "1.28"}],

Cell[CellGroupData[{
Cell[40415, 1384, 77, 2, 70, "Input",
  CellTags->"S5.2.1"],
Cell[40495, 1388, 75, 2, 70, "Output",
  CellTags->"S5.2.1"]
}, Open  ]],
Cell[40585, 1393, 75, 1, 70, "MathCaption",
  CellTags->{"S5.2.1", "1.29"}],

Cell[CellGroupData[{
Cell[40685, 1398, 121, 2, 70, "Input",
  CellTags->"S5.2.1"],
Cell[40809, 1402, 77, 2, 70, "Output",
  CellTags->"S5.2.1"]
}, Open  ]],
Cell[40901, 1407, 125, 3, 70, "MathCaption",
  CellTags->{"S5.2.1", "1.30"}],

Cell[CellGroupData[{
Cell[41051, 1414, 87, 2, 70, "Input",
  CellTags->"S5.2.1"],
Cell[41141, 1418, 130, 4, 70, "Output",
  CellTags->"S5.2.1"]
}, Open  ]],
Cell[41286, 1425, 6669, 202, 70, "DefinitionBox",
  CellTags->"S5.2.1"],
Cell[47958, 1629, 78, 1, 70, "Caption",
  CellTags->"S5.2.1"],
Cell[48039, 1632, 379, 15, 70, "Text",
  CellTags->{"S5.2.1", "1.31"}],
Cell[48421, 1649, 94, 1, 70, "MathCaption",
  CellTags->{"S5.2.1", "1.32"}],

Cell[CellGroupData[{
Cell[48540, 1654, 101, 2, 70, "Input",
  CellTags->"S5.2.1"],
Cell[48644, 1658, 211, 7, 70, "Output",
  CellTags->"S5.2.1"]
}, Open  ]],
Cell[48870, 1668, 6254, 192, 70, "DefinitionBox",
  CellTags->"S5.2.1"],
Cell[55127, 1862, 95, 1, 70, "Caption",
  CellTags->"S5.2.1"],
Cell[55225, 1865, 880, 26, 70, "Text",
  CellTags->{"S5.2.1", "1.33"}],
Cell[56108, 1893, 1368, 46, 70, "Text",
  CellTags->{"S5.2.1", "1.34"}],
Cell[57479, 1941, 1578, 59, 70, "Text",
  CellTags->{"S5.2.1", "1.35"}],
Cell[59060, 2002, 426, 7, 70, "Text",
  CellTags->{"S5.2.1", "1.36"}],
Cell[59489, 2011, 1206, 32, 70, "Text",
  CellTags->{"S5.2.1", "1.37"}],
Cell[60698, 2045, 656, 16, 70, "Text",
  CellTags->{"S5.2.1", "1.38"}],
Cell[61357, 2063, 309, 7, 70, "MathCaption",
  CellTags->{"S5.2.1", "1.39"}],

Cell[CellGroupData[{
Cell[61691, 2074, 81, 2, 70, "Input",
  CellTags->"S5.2.1"],
Cell[61775, 2078, 303, 10, 70, "Output",
  CellTags->"S5.2.1"]
}, Open  ]],
Cell[62093, 2091, 227, 6, 70, "MathCaption",
  CellTags->{"S5.2.1", "1.40"}],
Cell[62323, 2099, 89, 2, 70, "Input",
  CellTags->"S5.2.1"],
Cell[62415, 2103, 229, 9, 70, "MathCaption",
  CellTags->{"S5.2.1", "1.41"}],

Cell[CellGroupData[{
Cell[62669, 2116, 85, 2, 70, "Input",
  CellTags->"S5.2.1"],
Cell[62757, 2120, 74, 2, 70, "Output",
  CellTags->"S5.2.1"]
}, Open  ]],
Cell[62846, 2125, 152, 6, 70, "MathCaption",
  CellTags->{"S5.2.1", "1.42"}],

Cell[CellGroupData[{
Cell[63023, 2135, 83, 2, 70, "Input",
  CellTags->"S5.2.1"],
Cell[63109, 2139, 187, 8, 70, "Output",
  CellTags->"S5.2.1"]
}, Open  ]],
Cell[63311, 2150, 203, 4, 70, "MathCaption",
  CellTags->{"S5.2.1", "1.43"}],

Cell[CellGroupData[{
Cell[63539, 2158, 106, 2, 70, "Input",
  CellTags->"S5.2.1"],
Cell[63648, 2162, 148, 5, 70, "Output",
  CellTags->"S5.2.1"]
}, Open  ]],
Cell[63811, 2170, 1985, 58, 70, "Text",
  CellTags->{"S5.2.1", "1.44"}],
Cell[65799, 2230, 82, 1, 70, "MathCaption",
  CellTags->{"S5.2.1", "1.45"}],

Cell[CellGroupData[{
Cell[65906, 2235, 159, 5, 70, "Input",
  CellTags->"S5.2.1"],
Cell[66068, 2242, 184, 6, 70, "Output",
  CellTags->"S5.2.1"]
}, Open  ]],
Cell[66267, 2251, 154, 5, 70, "MathCaption",
  CellTags->{"S5.2.1", "1.46"}],

Cell[CellGroupData[{
Cell[66446, 2260, 141, 4, 70, "Input",
  CellTags->"S5.2.1"],
Cell[66590, 2266, 759, 32, 70, "Output",
  CellTags->"S5.2.1"]
}, Open  ]],
Cell[67364, 2301, 103, 1, 70, "MathCaption",
  CellTags->{"S5.2.1", "1.47"}],

Cell[CellGroupData[{
Cell[67492, 2306, 143, 5, 70, "Input",
  CellTags->"S5.2.1"],
Cell[67638, 2313, 189, 6, 70, "Output",
  CellTags->"S5.2.1"]
}, Open  ]],
Cell[67842, 2322, 182, 5, 70, "MathCaption",
  CellTags->{"S5.2.1", "1.48"}],

Cell[CellGroupData[{
Cell[68049, 2331, 96, 2, 70, "Input",
  CellTags->"S5.2.1"],
Cell[68148, 2335, 1419, 60, 70, "Output",
  CellTags->"S5.2.1"]
}, Open  ]],
Cell[69582, 2398, 137, 3, 70, "MathCaption",
  CellTags->{"S5.2.1", "1.49"}],

Cell[CellGroupData[{
Cell[69744, 2405, 76, 2, 70, "Input",
  CellTags->"S5.2.1"],
Cell[69823, 2409, 571, 20, 70, "Output",
  CellTags->"S5.2.1"]
}, Open  ]],

Cell[CellGroupData[{
Cell[70431, 2434, 144, 5, 70, "Subsubsection",
  CellTags->{"S5.2.1", "1.50"}],
Cell[70578, 2441, 357, 8, 70, "Text",
  CellTags->{"S5.2.1", "1.51"}],
Cell[70938, 2451, 371, 7, 70, "Text",
  CellTags->{"S5.2.1", "1.52"}],
Cell[71312, 2460, 121, 5, 70, "MathCaption",
  CellTags->{"S5.2.1", "1.53"}],
Cell[71436, 2467, 118, 2, 70, "Input",
  CellTags->"S5.2.1"],
Cell[71557, 2471, 85, 1, 70, "MathCaption",
  CellTags->{"S5.2.1", "1.54"}],

Cell[CellGroupData[{
Cell[71667, 2476, 80, 2, 70, "Input",
  CellTags->"S5.2.1"],
Cell[71750, 2480, 139, 6, 70, "Output",
  CellTags->"S5.2.1"]
}, Open  ]],
Cell[71904, 2489, 176, 5, 70, "MathCaption",
  CellTags->{"S5.2.1", "1.55"}],

Cell[CellGroupData[{
Cell[72105, 2498, 101, 2, 70, "Input",
  CellTags->"S5.2.1"],
Cell[72209, 2502, 174, 7, 70, "Output",
  CellTags->"S5.2.1"]
}, Open  ]],
Cell[72398, 2512, 226, 6, 70, "MathCaption",
  CellTags->{"S5.2.1", "1.56"}],

Cell[CellGroupData[{
Cell[72649, 2522, 104, 2, 70, "Input",
  CellTags->"S5.2.1"],
Cell[72756, 2526, 74, 2, 70, "Output",
  CellTags->"S5.2.1"]
}, Open  ]],
Cell[72845, 2531, 124, 5, 70, "MathCaption",
  CellTags->{"S5.2.1", "1.57"}],
Cell[72972, 2538, 152, 5, 70, "Input",
  CellTags->"S5.2.1"],
Cell[73127, 2545, 192, 6, 70, "MathCaption",
  CellTags->{"S5.2.1", "1.58"}],

Cell[CellGroupData[{
Cell[73344, 2555, 255, 7, 70, "Input",
  CellTags->"S5.2.1"],
Cell[73602, 2564, 499, 19, 70, "Output",
  CellTags->"S5.2.1"]
}, Open  ]],
Cell[74116, 2586, 391, 10, 70, "MathCaption",
  CellTags->{"S5.2.1", "1.59"}],

Cell[CellGroupData[{
Cell[74532, 2600, 152, 5, 70, "Input",
  CellTags->"S5.2.1"],
Cell[74687, 2607, 434, 18, 70, "Output",
  CellTags->"S5.2.1"]
}, Open  ]],
Cell[75136, 2628, 131, 4, 70, "MathCaption",
  CellTags->{"S5.2.1", "1.60"}],

Cell[CellGroupData[{
Cell[75292, 2636, 151, 6, 70, "Input",
  CellTags->"S5.2.1"],
Cell[75446, 2644, 170, 6, 70, "Output",
  CellTags->"S5.2.1"]
}, Open  ]],
Cell[75631, 2653, 148, 4, 70, "MathCaption",
  CellTags->{"S5.2.1", "1.61"}],

Cell[CellGroupData[{
Cell[75804, 2661, 82, 2, 70, "Input",
  CellTags->"S5.2.1"],
Cell[75889, 2665, 217, 8, 70, "Output",
  CellTags->"S5.2.1"]
}, Open  ]],
Cell[76121, 2676, 175, 6, 70, "MathCaption",
  CellTags->{"S5.2.1", "1.62"}],

Cell[CellGroupData[{
Cell[76321, 2686, 91, 2, 70, "Input",
  CellTags->"S5.2.1"],
Cell[76415, 2690, 345, 14, 70, "Output",
  CellTags->"S5.2.1"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

