(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    186040,       7622]*)
(*NotebookOutlinePosition[    196722,       7923]*)
(*  CellTagsIndexPosition[    196084,       7895]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Calculus",
 StyleBox["`", "MB"],
 "FourierTransform",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.12.1", "1.1"}],

Cell[TextData[{
 "The ",
 StyleBox["Mathematica", "TI"],
 " kernel provides the functions ",
 StyleBox["FourierTransform", "MR"],
 " and ",
 StyleBox["InverseFourierTransform", "MR"],
 " for computing the symbolic Fourier exponential transform and inverse \
transform. It also provides the functions ",
 StyleBox["FourierSinTransform", "MR"],
 ", ",
 StyleBox["InverseFourierSinTransform", "MR"],
 ", ",
 StyleBox["FourierCosTransform", "MR"],
 ", and ",
 StyleBox["InverseFourierCosTransform", "MR"],
 " for computing the symbolic Fourier sine and cosine transforms and their \
inverses. This package provides functions giving numerical approximations to \
these Fourier transforms. It also provides functions for Fourier series, \
Fourier coefficients, discrete\[Hyphen]time Fourier transforms, and their \
numerical counterparts. The numerical approximations use ",
 StyleBox["Mathematica", "TI"],
 "\[CloseCurlyQuote]s numerical integration and summation directly without \
first trying for an exact solution. "
}], "Text",
 CellTags->{"S5.12.1", "1.2"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["NFourierTransform[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["t", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["\[Omega]", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["find a numerical approximation to the Fourier transform of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" evaluated at the numerical value ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["\[Omega]", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", where ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is treated as a function of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["t", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["NInverseFourierTransform[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["\[Omega]", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["t", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "find a numerical approximation to the inverse Fourier transform of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" evaluated at the numerical value ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["t", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", where ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is treated as a function of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["\[Omega]", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["NFourierSinTransform[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["t", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["\[Omega]", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "find a numerical approximation to the Fourier sine transform of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" evaluated at the numerical value ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["\[Omega]", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", where ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is treated as a function of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["t", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["NInverseFourierSinTransform[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["\[Omega]", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["t", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "find a numerical approximation to the inverse Fourier cosine transform \
of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" evaluated at the numerical value ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["t", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", where ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is treated as a function of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["\[Omega]", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["NFourierCosTransform[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["t", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["\[Omega]", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "find a numerical approximation to the Fourier cosine transform of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" evaluated at the numerical value ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["\[Omega]", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", where ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is treated as a function of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["t", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["NInverseFourierCosTransform[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["\[Omega]", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["t", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "find a numerical approximation to the inverse Fourier cosine transform \
of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" evaluated at the numerical value ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["t", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", where ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is treated as a function of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["\[Omega]", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.12.1"],

Cell["Finding numerical approximations to Fourier transforms. ", "Caption",
 CellTags->"S5.12.1"],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.12.1", "1.3"}],

Cell["<<Calculus`FourierTransform`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.12.1"],

Cell[TextData[{
 "This gives a numerical approximation to the Fourier transform of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"exp", 
    RowBox[{"(", 
     RowBox[{"-", 
      SuperscriptBox[
       StyleBox["t",
        "TI"], "2"]}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{"1", "+", "\[LeftBracketingBar]", 
      StyleBox["t",
       "TI"], "\[RightBracketingBar]"}], ")"}]}], TraditionalForm]], 
  "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " with respect to ",
 Cell[BoxData[
  FormBox["\[Omega]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Omega]", "=", "1"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.12.1", "1.4"}],

Cell[CellGroupData[{

Cell["NFourierTransform[Exp[-t^2]/(1 + Abs[t]), t, 1]", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.12.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"0.4040240755957998`", "\[InvisibleSpace]"}], "+", 
  RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.12.1"]
}, Open  ]],

Cell[TextData[{
 "In addition to supporting the ",
 StyleBox["NIntegrate", "MR"],
 " options, the numerical Fourier transform functions support the option ",
 StyleBox["FourierParameters", "MR"],
 ". This option allows you to choose among the various conventions used for \
defining Fourier transforms. "
}], "Text",
 CellTags->{"S5.12.1", "1.5"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["case", "SO10",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["value", "SO10",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Fourier transform and inverse", "SO10",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Mathematica", "TI",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" default ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["{0,", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["1}", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         FractionBox["1", 
          SqrtBox[
           RowBox[{"2", "\[Pi]"}]]], 
         SubsuperscriptBox["\[Integral]", 
          RowBox[{"-", "\[Infinity]"}], "\[Infinity]"], 
         StyleBox["f",
          "TI"], 
         RowBox[{"(", 
          StyleBox["t",
           "TI"], ")"}], " ", 
         SuperscriptBox[
          StyleBox["e",
           "TI"], 
          RowBox[{
           StyleBox["i",
            "TI"], "\[Omega]", 
           StyleBox["t",
            "TI"]}]], "\[DifferentialD]", 
         StyleBox["t",
          "TI"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox["",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         FractionBox["1", 
          SqrtBox[
           RowBox[{"2", "\[Pi]"}]]], 
         SubsuperscriptBox["\[Integral]", 
          RowBox[{"-", "\[Infinity]"}], "\[Infinity]"], 
         StyleBox["F",
          "TI"], 
         RowBox[{"(", "\[Omega]", ")"}], " ", 
         SuperscriptBox[
          StyleBox["e",
           "TI"], 
          RowBox[{"-", 
           StyleBox["i",
            "TI"], "\[Omega]", 
           StyleBox["t",
            "TI"]}]], "\[DifferentialD]", "\[Omega]"}], TraditionalForm]], 
       "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["general case ",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["{", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["a", "TI",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["b", "TI",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["}", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         SqrtBox[
          FractionBox[
           RowBox[{"\[LeftBracketingBar]", 
            StyleBox["b",
             "TI"], "\[RightBracketingBar]"}], 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"2", "\[Pi]"}], ")"}], 
            RowBox[{"1", "-", 
             StyleBox["a",
              "TI"]}]]]], 
         SubsuperscriptBox["\[Integral]", 
          RowBox[{"-", "\[Infinity]"}], "\[Infinity]"], 
         StyleBox["f",
          "TI"], 
         RowBox[{"(", 
          StyleBox["t",
           "TI"], ")"}], " ", 
         SuperscriptBox[
          StyleBox["e",
           "TI"], 
          RowBox[{
           StyleBox["i",
            "TI"], 
           StyleBox["b",
            "TI"], "\[Omega]", 
           StyleBox["t",
            "TI"]}]], "\[DifferentialD]", 
         StyleBox["t",
          "TI"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox["",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         SqrtBox[
          FractionBox[
           RowBox[{"\[LeftBracketingBar]", 
            StyleBox["b",
             "TI"], "\[RightBracketingBar]"}], 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"2", "\[Pi]"}], ")"}], 
            RowBox[{"1", "+", 
             StyleBox["a",
              "TI"]}]]]], 
         SubsuperscriptBox["\[Integral]", 
          RowBox[{"-", "\[Infinity]"}], "\[Infinity]"], 
         StyleBox["F",
          "TI"], 
         RowBox[{"(", "\[Omega]", ")"}], " ", 
         SuperscriptBox[
          StyleBox["e",
           "TI"], 
          RowBox[{"-", 
           StyleBox["i",
            "TI"], 
           StyleBox["b",
            "TI"], "\[Omega]", 
           StyleBox["t",
            "TI"]}]], "\[DifferentialD]", "\[Omega]"}], TraditionalForm]], 
       "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
 GridBoxOptions->{RowLines->{True, False},
 RowSpacings->0.4},
 CellTags->"S5.12.1"],

Cell[TextData[{
 "Effect of ",
 StyleBox["FourierParameters", "MR"],
 " setting on Fourier transform."
}], "Caption",
 CellTags->"S5.12.1"],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["setting", "SO10",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Fourier sine transform", "SO10",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["inverse Fourier sine transform", "SO10",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["{0,", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["1}", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         SqrtBox[
          FractionBox["2", "\[Pi]"]], 
         SubsuperscriptBox["\[Integral]", "0", "\[Infinity]"], 
         StyleBox["f",
          "TI"], 
         RowBox[{"(", 
          StyleBox["t",
           "TI"], ")"}], " ", "sin", 
         RowBox[{"(", 
          RowBox[{"\[Omega]", 
           StyleBox["t",
            "TI"]}], ")"}], "\[DifferentialD]", 
         StyleBox["t",
          "TI"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         SqrtBox[
          FractionBox["2", "\[Pi]"]], 
         SubsuperscriptBox["\[Integral]", "0", "\[Infinity]"], 
         StyleBox["F",
          "TI"], 
         RowBox[{"(", "\[Omega]", ")"}], " ", "sin", 
         RowBox[{"(", 
          RowBox[{"\[Omega]", 
           StyleBox["t",
            "TI"]}], ")"}], "\[DifferentialD]", "\[Omega]"}], 
        TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["{", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["a", "TI",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["b", "TI",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["}", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"2", 
         SqrtBox[
          FractionBox[
           RowBox[{"\[LeftBracketingBar]", 
            StyleBox["b",
             "TI"], "\[RightBracketingBar]"}], 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"2", "\[Pi]"}], ")"}], 
            RowBox[{"1", "-", 
             StyleBox["a",
              "TI"]}]]]], 
         SubsuperscriptBox["\[Integral]", "0", "\[Infinity]"], 
         StyleBox["f",
          "TI"], 
         RowBox[{"(", 
          StyleBox["t",
           "TI"], ")"}], " ", "sin", 
         RowBox[{"(", 
          RowBox[{
           StyleBox["b",
            "TI"], "\[Omega]", 
           StyleBox["t",
            "TI"]}], ")"}], "\[DifferentialD]", 
         StyleBox["t",
          "TI"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"2", 
         SqrtBox[
          FractionBox[
           RowBox[{"\[LeftBracketingBar]", 
            StyleBox["b",
             "TI"], "\[RightBracketingBar]"}], 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"2", "\[Pi]"}], ")"}], 
            RowBox[{"1", "+", 
             StyleBox["a",
              "TI"]}]]]], 
         SubsuperscriptBox["\[Integral]", "0", "\[Infinity]"], 
         StyleBox["F",
          "TI"], 
         RowBox[{"(", "\[Omega]", ")"}], " ", "sin", 
         RowBox[{"(", 
          RowBox[{
           StyleBox["b",
            "TI"], "\[Omega]", 
           StyleBox["t",
            "TI"]}], ")"}], "\[DifferentialD]", "\[Omega]"}], 
        TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
 GridBoxOptions->{RowLines->{True, False},
 RowSpacings->0.4},
 CellTags->"S5.12.1"],

Cell[TextData[{
 "Effect of ",
 StyleBox["FourierParameters", "MR"],
 " setting on Fourier sine transform."
}], "Caption",
 CellTags->"S5.12.1"],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["setting", "SO10",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Fourier cosine transform", "SO10",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["inverse Fourier cosine transform", "SO10",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["{0,", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["1}", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         SqrtBox[
          FractionBox["2", "\[Pi]"]], 
         SubsuperscriptBox["\[Integral]", "0", "\[Infinity]"], 
         StyleBox["f",
          "TI"], 
         RowBox[{"(", 
          StyleBox["t",
           "TI"], ")"}], " ", "cos", 
         RowBox[{"(", 
          RowBox[{"\[Omega]", 
           StyleBox["t",
            "TI"]}], ")"}], "\[DifferentialD]", 
         StyleBox["t",
          "TI"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         SqrtBox[
          FractionBox["2", "\[Pi]"]], 
         SubsuperscriptBox["\[Integral]", "0", "\[Infinity]"], 
         StyleBox["F",
          "TI"], 
         RowBox[{"(", "\[Omega]", ")"}], " ", "cos", 
         RowBox[{"(", 
          RowBox[{"\[Omega]", 
           StyleBox["t",
            "TI"]}], ")"}], "\[DifferentialD]", "\[Omega]"}], 
        TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["{", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["a", "TI",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["b", "TI",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["}", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"2", 
         SqrtBox[
          FractionBox[
           RowBox[{"\[LeftBracketingBar]", 
            StyleBox["b",
             "TI"], "\[RightBracketingBar]"}], 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"2", "\[Pi]"}], ")"}], 
            RowBox[{"1", "-", 
             StyleBox["a",
              "TI"]}]]]], 
         SubsuperscriptBox["\[Integral]", "0", "\[Infinity]"], 
         StyleBox["f",
          "TI"], 
         RowBox[{"(", 
          StyleBox["t",
           "TI"], ")"}], " ", "cos", 
         RowBox[{"(", 
          RowBox[{
           StyleBox["b",
            "TI"], "\[Omega]", 
           StyleBox["t",
            "TI"]}], ")"}], "\[DifferentialD]", 
         StyleBox["t",
          "TI"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"2", 
         SqrtBox[
          FractionBox[
           RowBox[{"\[LeftBracketingBar]", 
            StyleBox["b",
             "TI"], "\[RightBracketingBar]"}], 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"2", "\[Pi]"}], ")"}], 
            RowBox[{"1", "+", 
             StyleBox["a",
              "TI"]}]]]], 
         SubsuperscriptBox["\[Integral]", "0", "\[Infinity]"], 
         StyleBox["F",
          "TI"], 
         RowBox[{"(", "\[Omega]", ")"}], " ", "cos", 
         RowBox[{"(", 
          RowBox[{
           StyleBox["b",
            "TI"], "\[Omega]", 
           StyleBox["t",
            "TI"]}], ")"}], "\[DifferentialD]", "\[Omega]"}], 
        TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
 GridBoxOptions->{RowLines->{True, False},
 RowSpacings->0.4},
 CellTags->"S5.12.1"],

Cell[TextData[{
 "Effect of ",
 StyleBox["FourierParameters", "MR"],
 " setting on Fourier cosine transform."
}], "Caption",
 CellTags->"S5.12.1"],

Cell[TextData[{
 "The Fourier transform is commonly used to transform a problem from the \
continuous \[OpenCurlyDoubleQuote]time domain\[CloseCurlyDoubleQuote] into \
the continuous \[OpenCurlyDoubleQuote]frequency domain.\
\[CloseCurlyDoubleQuote] The Fourier transform may be viewed as the \
continuous analog of the Fourier series decomposition, which expresses a \
periodic function as a superposition of exponential or trigonometric \
functions. Fourier exponential and trigonometric series decompositions may be \
computed using the functions ",
 StyleBox["FourierSeries", "MR"],
 " and ",
 StyleBox["FourierTrigSeries", "MR"],
 ". The coefficients of the exponential series are found using ",
 StyleBox["FourierCoefficient", "MR"],
 " and the coefficients of the trigonometric series are found using ",
 StyleBox["FourierSinCoefficient", "MR"],
 " and ",
 StyleBox["FourierCosCoefficient", "MR"],
 ". If the option setting ",
 StyleBox["FourierParameters -> {", "MR"],
 StyleBox["a", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["b", "TI"],
 StyleBox["}", "MR"],
 " is specified, the continuous function of ",
 Cell[BoxData[
  FormBox[
   StyleBox["t",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is treated as having a period of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "/", "\[LeftBracketingBar]", 
    StyleBox["b",
     "TI"], "\[RightBracketingBar]"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", instead of the default period of ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "Text",
 CellTags->{"S5.12.1", "1.6"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["FourierCoefficient[", "MR",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox["t", "TI",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, False, True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the ",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SuperscriptBox[
         StyleBox["n",
          "TI"], "th"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[
      " coefficient in the exponential series expansion of the periodic \
function of ",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox["t", "TI",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[" equal to ",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[" on the interval ",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["t",
          "TI"], "=", "-", 
         FractionBox["1", "2"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[" to ",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["t",
          "TI"], "=", 
         FractionBox["1", "2"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, False, True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["FourierSinCoefficient[", "MR",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox["t", "TI",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, False, True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the ",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SuperscriptBox[
         StyleBox["n",
          "TI"], "th"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[" coefficient in the sine series expansion",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, False, True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["FourierCosCoefficient[", "MR",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox["t", "TI",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, False, True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the ",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SuperscriptBox[
         StyleBox["n",
          "TI"], "th"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[" coefficient in the cosine series expansion",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, False, True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["FourierSeries[", "MR",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox["t", "TI",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox["k", "TI",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, False, True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the exponential series expansion to order ",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox["k", "TI",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[" of the periodic function of ",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox["t", "TI",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[" equal to ",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[" on the interval ",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["t",
          "TI"], "=", "-", 
         FractionBox["1", "2"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[" to ",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["t",
          "TI"], "=", 
         FractionBox["1", "2"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, False, True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["FourierTrigSeries[", "MR",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox["t", "TI",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox["k", "TI",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, False, True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the trigonometric series expansion to order ",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox["k", "TI",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, False, True, False},
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->{False, False, True, False},
 RowSpacings->0.4},
 CellTags->"S5.12.1"],

Cell["Computing Fourier coefficients and series. ", "Caption",
 CellTags->"S5.12.1"],

Cell[TextData[{
 "Here is a plot of the difference between ",
 Cell[BoxData[
  FormBox[
   StyleBox["t",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and the integer closest to ",
 Cell[BoxData[
  FormBox[
   StyleBox["t",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". It is a periodic function with fundamental interval from ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", 
    FractionBox["1", "2"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " to ",
 Cell[BoxData[
  FormBox[
   FractionBox["1", "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.12.1", "1.7"}],

Cell[CellGroupData[{

Cell["rndplt = Plot[t - Round[t], {t, -1.5, 1.5}]", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.12.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.31746 0.309017 0.588604 [
[.02381 .29652 -12 -9 ]
[.02381 .29652 12 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -12 -9 ]
[.34127 .29652 12 0 ]
[.65873 .29652 -9 -9 ]
[.65873 .29652 9 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -9 -9 ]
[.97619 .29652 9 0 ]
[.4875 .07358 -24 -4.5 ]
[.4875 .07358 0 4.5 ]
[.4875 .1913 -24 -4.5 ]
[.4875 .1913 0 4.5 ]
[.4875 .42674 -18 -4.5 ]
[.4875 .42674 0 4.5 ]
[.4875 .54446 -18 -4.5 ]
[.4875 .54446 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-1.5)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-1)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-0.5)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(0.5)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(1)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(1.5)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 .07358 m
.50625 .07358 L
s
[(-0.4)] .4875 .07358 1 0 Mshowa
.5 .1913 m
.50625 .1913 L
s
[(-0.2)] .4875 .1913 1 0 Mshowa
.5 .42674 m
.50625 .42674 L
s
[(0.2)] .4875 .42674 1 0 Mshowa
.5 .54446 m
.50625 .54446 L
s
[(0.4)] .4875 .54446 1 0 Mshowa
.125 Mabswid
.5 .10301 m
.50375 .10301 L
s
.5 .13244 m
.50375 .13244 L
s
.5 .16187 m
.50375 .16187 L
s
.5 .22073 m
.50375 .22073 L
s
.5 .25016 m
.50375 .25016 L
s
.5 .27959 m
.50375 .27959 L
s
.5 .33845 m
.50375 .33845 L
s
.5 .36788 m
.50375 .36788 L
s
.5 .39731 m
.50375 .39731 L
s
.5 .45617 m
.50375 .45617 L
s
.5 .4856 m
.50375 .4856 L
s
.5 .51503 m
.50375 .51503 L
s
.5 .04415 m
.50375 .04415 L
s
.5 .01472 m
.50375 .01472 L
s
.5 .57389 m
.50375 .57389 L
s
.5 .60332 m
.50375 .60332 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .01472 m
.06244 .08635 L
.10458 .16447 L
.14415 .23784 L
.18221 .3084 L
.22272 .38351 L
.26171 .45581 L
.28158 .49265 L
.30316 .53265 L
.31323 .55134 L
.32392 .57115 L
.33304 .58806 L
.33554 .59269 L
.33823 .59767 L
.33953 .60009 L
.34076 .60238 L
.34187 .01583 L
.34309 .01808 L
.38373 .09344 L
.42286 .16599 L
.46444 .24309 L
.50451 .31738 L
.54306 .38885 L
.58406 .46488 L
.60448 .50274 L
.62355 .53809 L
.64188 .57207 L
.64715 .58185 L
.65215 .59112 L
.65433 .59516 L
.65664 .59944 L
.65785 .60168 L
.65853 .60295 L
.65918 .01554 L
.66031 .01763 L
.66152 .01989 L
.70266 .09617 L
.74229 .16964 L
.78039 .24029 L
.82096 .3155 L
.86 .38789 L
.9015 .46483 L
.94148 .53896 L
.97619 .60332 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.12.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.12.1"]
}, Open  ]],

Cell["\<\
This gives a piece of the Fourier trigonometric series of the difference \
function. The difference function is odd so its trigonometric series contains \
only sines. \
\>", "MathCaption",
 CellTags->{"S5.12.1", "1.8"}],

Cell[CellGroupData[{

Cell["FourierTrigSeries[t, t, 3]", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.12.1"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"Sin", "[", 
    RowBox[{"2", " ", "\[Pi]", " ", "t"}], "]"}], "\[Pi]"], "-", 
  FractionBox[
   RowBox[{"Sin", "[", 
    RowBox[{"4", " ", "\[Pi]", " ", "t"}], "]"}], 
   RowBox[{"2", " ", "\[Pi]"}]], "+", 
  FractionBox[
   RowBox[{"Sin", "[", 
    RowBox[{"6", " ", "\[Pi]", " ", "t"}], "]"}], 
   RowBox[{"3", " ", "\[Pi]"}]]}]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.12.1"]
}, Open  ]],

Cell["\<\
The plot of the truncated series is similar to that of the function. \
\>", "MathCaption",
 CellTags->{"S5.12.1", "1.9"}],

Cell[CellGroupData[{

Cell["Plot[%, {t, -1.5, 1.5}]", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.12.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.31746 0.309008 0.640836 [
[.02381 .29651 -12 -9 ]
[.02381 .29651 12 0 ]
[.18254 .29651 -6 -9 ]
[.18254 .29651 6 0 ]
[.34127 .29651 -12 -9 ]
[.34127 .29651 12 0 ]
[.65873 .29651 -9 -9 ]
[.65873 .29651 9 0 ]
[.81746 .29651 -3 -9 ]
[.81746 .29651 3 0 ]
[.97619 .29651 -9 -9 ]
[.97619 .29651 9 0 ]
[.4875 .05267 -24 -4.5 ]
[.4875 .05267 0 4.5 ]
[.4875 .18084 -24 -4.5 ]
[.4875 .18084 0 4.5 ]
[.4875 .43718 -18 -4.5 ]
[.4875 .43718 0 4.5 ]
[.4875 .56534 -18 -4.5 ]
[.4875 .56534 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30901 m
.02381 .31526 L
s
[(-1.5)] .02381 .29651 0 1 Mshowa
.18254 .30901 m
.18254 .31526 L
s
[(-1)] .18254 .29651 0 1 Mshowa
.34127 .30901 m
.34127 .31526 L
s
[(-0.5)] .34127 .29651 0 1 Mshowa
.65873 .30901 m
.65873 .31526 L
s
[(0.5)] .65873 .29651 0 1 Mshowa
.81746 .30901 m
.81746 .31526 L
s
[(1)] .81746 .29651 0 1 Mshowa
.97619 .30901 m
.97619 .31526 L
s
[(1.5)] .97619 .29651 0 1 Mshowa
.125 Mabswid
.05556 .30901 m
.05556 .31276 L
s
.0873 .30901 m
.0873 .31276 L
s
.11905 .30901 m
.11905 .31276 L
s
.15079 .30901 m
.15079 .31276 L
s
.21429 .30901 m
.21429 .31276 L
s
.24603 .30901 m
.24603 .31276 L
s
.27778 .30901 m
.27778 .31276 L
s
.30952 .30901 m
.30952 .31276 L
s
.37302 .30901 m
.37302 .31276 L
s
.40476 .30901 m
.40476 .31276 L
s
.43651 .30901 m
.43651 .31276 L
s
.46825 .30901 m
.46825 .31276 L
s
.53175 .30901 m
.53175 .31276 L
s
.56349 .30901 m
.56349 .31276 L
s
.59524 .30901 m
.59524 .31276 L
s
.62698 .30901 m
.62698 .31276 L
s
.69048 .30901 m
.69048 .31276 L
s
.72222 .30901 m
.72222 .31276 L
s
.75397 .30901 m
.75397 .31276 L
s
.78571 .30901 m
.78571 .31276 L
s
.84921 .30901 m
.84921 .31276 L
s
.88095 .30901 m
.88095 .31276 L
s
.9127 .30901 m
.9127 .31276 L
s
.94444 .30901 m
.94444 .31276 L
s
.25 Mabswid
0 .30901 m
1 .30901 L
s
.5 .05267 m
.50625 .05267 L
s
[(-0.4)] .4875 .05267 1 0 Mshowa
.5 .18084 m
.50625 .18084 L
s
[(-0.2)] .4875 .18084 1 0 Mshowa
.5 .43718 m
.50625 .43718 L
s
[(0.2)] .4875 .43718 1 0 Mshowa
.5 .56534 m
.50625 .56534 L
s
[(0.4)] .4875 .56534 1 0 Mshowa
.125 Mabswid
.5 .08472 m
.50375 .08472 L
s
.5 .11676 m
.50375 .11676 L
s
.5 .1488 m
.50375 .1488 L
s
.5 .21288 m
.50375 .21288 L
s
.5 .24492 m
.50375 .24492 L
s
.5 .27697 m
.50375 .27697 L
s
.5 .34105 m
.50375 .34105 L
s
.5 .37309 m
.50375 .37309 L
s
.5 .40513 m
.50375 .40513 L
s
.5 .46922 m
.50375 .46922 L
s
.5 .50126 m
.50375 .50126 L
s
.5 .5333 m
.50375 .5333 L
s
.5 .02063 m
.50375 .02063 L
s
.5 .59738 m
.50375 .59738 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30901 m
.03279 .20293 L
.04262 .1046 L
.04758 .06701 L
.0503 .05048 L
.05288 .0377 L
.05528 .02835 L
.05655 .02441 L
.05789 .02098 L
.05902 .01868 L
.06026 .01676 L
.06139 .01557 L
.06244 .01491 L
.0631 .01473 L
.06379 .01472 L
.06504 .01516 L
.06581 .01571 L
.06653 .01643 L
.06788 .01827 L
.06917 .02061 L
.07036 .02324 L
.07305 .03073 L
.07776 .04834 L
.08274 .0715 L
.09328 .1266 L
.09908 .15525 L
.10458 .17853 L
.1095 .19515 L
.11209 .20214 L
.11485 .20823 L
.11716 .21229 L
.11972 .21572 L
.12083 .2169 L
.12204 .21797 L
.12309 .21874 L
.12422 .2194 L
.12537 .21992 L
.12644 .22027 L
.12772 .22054 L
.12888 .22066 L
.13009 .22067 L
.1314 .22058 L
.13264 .22041 L
.13378 .22021 L
.13613 .2197 L
.13836 .21921 L
.13933 .21903 L
.14037 .21886 L
.1415 .21874 L
.14255 .21869 L
Mistroke
.14382 .21871 L
.145 .21885 L
.14607 .21907 L
.14722 .21943 L
.1485 .21999 L
.14984 .22076 L
.15225 .22269 L
.15448 .22516 L
.15657 .22809 L
.16131 .23703 L
.16653 .25052 L
.17128 .26576 L
.18195 .30665 L
.19123 .34308 L
.19631 .36065 L
.20108 .3745 L
.20621 .38601 L
.20894 .39059 L
.21188 .39435 L
.21441 .39667 L
.21569 .39754 L
.21708 .39827 L
.21828 .39873 L
.21956 .39907 L
.22076 .39926 L
.22185 .39933 L
.22305 .39931 L
.22417 .39922 L
.2254 .39905 L
.22672 .39881 L
.22936 .39823 L
.23066 .39794 L
.23186 .3977 L
.23298 .39752 L
.23417 .39739 L
.23536 .39734 L
.23668 .39739 L
.23777 .39754 L
.23895 .39783 L
.24006 .39823 L
.24108 .39873 L
.24229 .39948 L
.24358 .4005 L
.24591 .40295 L
.24869 .40698 L
.25121 .4118 L
.2567 .42627 L
.26189 .44492 L
.28018 .53557 L
.28519 .56025 L
Mistroke
.28796 .57234 L
.29058 .58242 L
.29301 .59026 L
.2943 .59375 L
.29567 .59691 L
.29693 .59931 L
.29808 .60102 L
.29923 .60227 L
.30032 .60301 L
.30147 .60332 L
.30274 .60306 L
.30406 .60212 L
.30529 .60061 L
.30644 .59862 L
.3075 .59632 L
.30986 .58946 L
.3124 .57943 L
.31516 .56542 L
.32017 .53193 L
.3311 .42835 L
.34121 .30977 L
.3502 .20347 L
.35989 .10624 L
.36543 .06442 L
.36786 .04994 L
.37052 .03694 L
.37304 .02738 L
.37538 .02091 L
.37667 .01833 L
.37785 .01659 L
.3785 .01587 L
.37921 .01529 L
.38049 .01474 L
.38173 .01481 L
.38285 .01538 L
.38415 .01662 L
.38539 .01835 L
.38758 .02267 L
.38997 .02906 L
.39537 .04899 L
.40038 .07239 L
.41123 .12912 L
.41655 .15527 L
.42143 .17618 L
.42615 .19272 L
.43133 .20621 L
.43402 .21131 L
.43653 .21495 L
.43918 .21771 L
.44066 .21881 L
Mistroke
.44201 .21957 L
.44317 .22005 L
.4444 .2204 L
.44544 .22058 L
.4466 .22067 L
.44784 .22066 L
.44853 .22061 L
.44917 .22055 L
.45041 .22036 L
.45158 .22014 L
.45382 .21965 L
.45624 .21913 L
.45735 .21893 L
.45853 .21878 L
.45953 .2187 L
.46063 .21869 L
.46189 .21877 L
.46259 .21887 L
.46323 .219 L
.46448 .21936 L
.46566 .21984 L
.46679 .22044 L
.46784 .22113 L
.47021 .2232 L
.47257 .22597 L
.47517 .22993 L
.48043 .24091 L
.48499 .25351 L
.48991 .26986 L
.49881 .30422 L
.50919 .3449 L
.51885 .37529 L
.52372 .38608 L
.52644 .39065 L
.52892 .39389 L
.53164 .39649 L
.53317 .39755 L
.53459 .39829 L
.53583 .39876 L
.53653 .39896 L
.53719 .39911 L
.53788 .39922 L
.53852 .39929 L
.53925 .39933 L
.53994 .39933 L
.5411 .39927 L
.54232 .39913 L
.54296 .39903 L
.54366 .39891 L
.54489 .39866 L
Mistroke
.54714 .39815 L
.54955 .39766 L
.55029 .39754 L
.551 .39745 L
.55164 .39739 L
.55233 .39735 L
.55298 .39734 L
.55367 .39736 L
.55492 .39749 L
.55611 .39775 L
.55723 .39812 L
.55846 .39868 L
.55978 .3995 L
.56201 .40142 L
.56446 .40437 L
.56701 .4085 L
.56938 .41336 L
.57363 .42465 L
.57817 .44031 L
.59812 .53802 L
.60358 .56446 L
.60657 .57695 L
.60936 .58685 L
.61174 .59369 L
.61296 .59655 L
.61429 .59913 L
.61505 .60033 L
.61575 .60127 L
.6164 .602 L
.61713 .60262 L
.61838 .60323 L
.61907 .60332 L
.61971 .60323 L
.62092 .60263 L
.62204 .60155 L
.62328 .59976 L
.6246 .59716 L
.62598 .59363 L
.6273 .58954 L
.62975 .57991 L
.63417 .55615 L
.63896 .52142 L
.64976 .41499 L
.65973 .29685 L
.66876 .19121 L
.67847 .09687 L
.68132 .0751 L
.68403 .05736 L
.68667 .04298 L
.68912 .03228 L
Mistroke
.69143 .02453 L
.69272 .02119 L
.69389 .01877 L
.69517 .01677 L
.6959 .01594 L
.69657 .01536 L
.6978 .01477 L
.69909 .01479 L
.70031 .01538 L
.701 .01596 L
.70164 .01665 L
.70281 .01829 L
.70405 .02053 L
.7062 .02557 L
.70857 .0327 L
.71382 .05327 L
.71874 .07689 L
.72749 .12291 L
.73707 .1688 L
.74217 .18807 L
.74691 .20188 L
.74953 .20775 L
.75191 .21202 L
.75323 .21396 L
.75466 .21575 L
.75601 .21714 L
.75726 .21821 L
.75842 .219 L
.75949 .21958 L
.76067 .22006 L
.76194 .22041 L
.76315 .22061 L
.76384 .22066 L
.76448 .22068 L
.76565 .22064 L
.76689 .22051 L
.76804 .22033 L
.76929 .22009 L
.77155 .21959 L
.77376 .21912 L
.77472 .21895 L
.77577 .2188 L
.77699 .2187 L
.77815 .21869 L
.77879 .21872 L
.77948 .21878 L
.7807 .219 L
.78183 .21932 L
.78289 .21973 L
.78405 .22033 L
Mistroke
.7853 .22113 L
.7881 .22364 L
.79076 .22699 L
.79314 .23083 L
.79575 .23597 L
.80104 .24931 L
.80668 .26741 L
.81683 .30646 L
.8271 .34655 L
.83251 .36463 L
.83822 .37994 L
.84323 .38962 L
.84607 .39352 L
.84743 .39501 L
.84872 .39619 L
.84989 .39707 L
.85116 .39785 L
.85232 .3984 L
.85339 .39879 L
.85454 .39908 L
.85581 .39927 L
.85645 .39932 L
.85714 .39933 L
.85839 .39929 L
.85964 .39915 L
.86078 .39897 L
.86334 .39844 L
.86574 .39791 L
.86679 .3977 L
.86795 .39751 L
.8692 .39738 L
.86989 .39734 L
.87053 .39734 L
.87123 .39736 L
.87188 .39742 L
.87262 .39753 L
.87333 .39768 L
.87459 .39808 L
.87576 .3986 L
.87704 .39936 L
.87841 .40042 L
.88115 .40334 L
.88269 .40551 L
.88411 .40785 L
.88948 .41996 L
.89435 .43552 L
.8995 .45636 L
.90972 .50718 L
.91939 .55686 L
.9236 .57526 L
Mistroke
.92807 .59064 L
.9304 .5965 L
.93172 .59909 L
.93297 .60097 L
.93411 .60223 L
.93515 .60297 L
.9363 .60331 L
.9375 .60313 L
.93867 .6024 L
.93974 .60126 L
.94097 .59937 L
.94213 .597 L
.94419 .59139 L
.94643 .58326 L
.94889 .57182 L
.9515 .55693 L
.95618 .52337 L
.96571 .43173 L
.97619 .30901 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.12.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S5.12.1"]
}, Open  ]],

Cell["Here are the two plots on the same axes. ", "MathCaption",
 CellTags->{"S5.12.1", "1.10"}],

Cell[CellGroupData[{

Cell["Show[rndplt, %]", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.12.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.31746 0.309017 0.588604 [
[.02381 .29652 -12 -9 ]
[.02381 .29652 12 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -12 -9 ]
[.34127 .29652 12 0 ]
[.65873 .29652 -9 -9 ]
[.65873 .29652 9 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -9 -9 ]
[.97619 .29652 9 0 ]
[.4875 .07358 -24 -4.5 ]
[.4875 .07358 0 4.5 ]
[.4875 .1913 -24 -4.5 ]
[.4875 .1913 0 4.5 ]
[.4875 .42674 -18 -4.5 ]
[.4875 .42674 0 4.5 ]
[.4875 .54446 -18 -4.5 ]
[.4875 .54446 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-1.5)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-1)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-0.5)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(0.5)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(1)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(1.5)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 .07358 m
.50625 .07358 L
s
[(-0.4)] .4875 .07358 1 0 Mshowa
.5 .1913 m
.50625 .1913 L
s
[(-0.2)] .4875 .1913 1 0 Mshowa
.5 .42674 m
.50625 .42674 L
s
[(0.2)] .4875 .42674 1 0 Mshowa
.5 .54446 m
.50625 .54446 L
s
[(0.4)] .4875 .54446 1 0 Mshowa
.125 Mabswid
.5 .10301 m
.50375 .10301 L
s
.5 .13244 m
.50375 .13244 L
s
.5 .16187 m
.50375 .16187 L
s
.5 .22073 m
.50375 .22073 L
s
.5 .25016 m
.50375 .25016 L
s
.5 .27959 m
.50375 .27959 L
s
.5 .33845 m
.50375 .33845 L
s
.5 .36788 m
.50375 .36788 L
s
.5 .39731 m
.50375 .39731 L
s
.5 .45617 m
.50375 .45617 L
s
.5 .4856 m
.50375 .4856 L
s
.5 .51503 m
.50375 .51503 L
s
.5 .04415 m
.50375 .04415 L
s
.5 .01472 m
.50375 .01472 L
s
.5 .57389 m
.50375 .57389 L
s
.5 .60332 m
.50375 .60332 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .01472 m
.06244 .08635 L
.10458 .16447 L
.14415 .23784 L
.18221 .3084 L
.22272 .38351 L
.26171 .45581 L
.28158 .49265 L
.30316 .53265 L
.31323 .55134 L
.32392 .57115 L
.33304 .58806 L
.33554 .59269 L
.33823 .59767 L
.33953 .60009 L
.34076 .60238 L
.34187 .01583 L
.34309 .01808 L
.38373 .09344 L
.42286 .16599 L
.46444 .24309 L
.50451 .31738 L
.54306 .38885 L
.58406 .46488 L
.60448 .50274 L
.62355 .53809 L
.64188 .57207 L
.64715 .58185 L
.65215 .59112 L
.65433 .59516 L
.65664 .59944 L
.65785 .60168 L
.65853 .60295 L
.65918 .01554 L
.66031 .01763 L
.66152 .01989 L
.70266 .09617 L
.74229 .16964 L
.78039 .24029 L
.82096 .3155 L
.86 .38789 L
.9015 .46483 L
.94148 .53896 L
.97619 .60332 L
s
.02381 .30902 m
.03279 .21159 L
.04262 .12127 L
.04758 .08674 L
.0503 .07156 L
.05288 .05982 L
.05528 .05123 L
.05655 .04762 L
.05789 .04446 L
.05902 .04235 L
.06026 .04059 L
.06139 .03949 L
.06244 .03889 L
.0631 .03872 L
.06379 .03871 L
.06504 .03912 L
.06581 .03963 L
.06653 .04029 L
.06788 .04198 L
.06917 .04413 L
.07036 .04654 L
.07305 .05342 L
.07776 .0696 L
.08274 .09087 L
.09328 .14147 L
.09908 .16779 L
.10458 .18917 L
.1095 .20444 L
.11209 .21086 L
.11485 .21645 L
.11716 .22018 L
.11972 .22334 L
.12083 .22442 L
.12204 .2254 L
.12309 .22611 L
.12422 .22672 L
.12537 .22719 L
.12644 .22752 L
.12772 .22776 L
.12888 .22787 L
.13009 .22788 L
.1314 .2278 L
.13264 .22764 L
.13378 .22745 L
.13613 .22699 L
.13836 .22654 L
.13933 .22637 L
.14037 .22622 L
.1415 .22611 L
.14255 .22606 L
Mistroke
.14382 .22608 L
.145 .22621 L
.14607 .22641 L
.14722 .22674 L
.1485 .22725 L
.14984 .22796 L
.15225 .22974 L
.15448 .23201 L
.15657 .23469 L
.16131 .24291 L
.16653 .2553 L
.17128 .26929 L
.18195 .30685 L
.19123 .34032 L
.19631 .35645 L
.20108 .36917 L
.20621 .37974 L
.20894 .38395 L
.21188 .3874 L
.21441 .38954 L
.21569 .39033 L
.21708 .391 L
.21828 .39143 L
.21956 .39174 L
.22076 .39191 L
.22185 .39198 L
.22305 .39196 L
.22417 .39188 L
.2254 .39172 L
.22672 .3915 L
.22936 .39096 L
.23066 .3907 L
.23186 .39048 L
.23298 .39032 L
.23417 .39019 L
.23536 .39015 L
.23668 .3902 L
.23777 .39034 L
.23895 .3906 L
.24006 .39097 L
.24108 .39142 L
.24229 .39211 L
.24358 .39305 L
.24591 .3953 L
.24869 .39901 L
.25121 .40343 L
.2567 .41672 L
.26189 .43385 L
.28018 .51711 L
.28519 .53978 L
Mistroke
.28796 .55089 L
.29058 .56014 L
.29301 .56735 L
.2943 .57055 L
.29567 .57345 L
.29693 .57566 L
.29808 .57723 L
.29923 .57838 L
.30032 .57906 L
.30147 .57934 L
.30274 .5791 L
.30406 .57824 L
.30529 .57685 L
.30644 .57502 L
.3075 .57291 L
.30986 .56661 L
.3124 .55739 L
.31516 .54453 L
.32017 .51377 L
.3311 .41863 L
.34121 .30972 L
.3502 .21208 L
.35989 .12278 L
.36543 .08436 L
.36786 .07107 L
.37052 .05912 L
.37304 .05034 L
.37538 .0444 L
.37667 .04203 L
.37785 .04044 L
.3785 .03978 L
.37921 .03924 L
.38049 .03873 L
.38173 .0388 L
.38285 .03933 L
.38415 .04046 L
.38539 .04205 L
.38758 .04602 L
.38997 .05189 L
.39537 .07019 L
.40038 .09169 L
.41123 .14379 L
.41655 .16781 L
.42143 .18702 L
.42615 .20221 L
.43133 .2146 L
.43402 .21928 L
.43653 .22262 L
.43918 .22516 L
.44066 .22617 L
Mistroke
.44201 .22687 L
.44317 .22731 L
.4444 .22763 L
.44544 .2278 L
.4466 .22788 L
.44784 .22787 L
.44853 .22783 L
.44917 .22777 L
.45041 .2276 L
.45158 .22739 L
.45382 .22694 L
.45624 .22646 L
.45735 .22628 L
.45853 .22614 L
.45953 .22607 L
.46063 .22606 L
.46189 .22613 L
.46259 .22623 L
.46323 .22634 L
.46448 .22667 L
.46566 .22712 L
.46679 .22767 L
.46784 .2283 L
.47021 .2302 L
.47257 .23275 L
.47517 .23639 L
.48043 .24647 L
.48499 .25804 L
.48991 .27306 L
.49881 .30462 L
.50919 .34199 L
.51885 .3699 L
.52372 .37981 L
.52644 .384 L
.52892 .38698 L
.53164 .38937 L
.53317 .39034 L
.53459 .39102 L
.53583 .39145 L
.53653 .39164 L
.53719 .39177 L
.53788 .39187 L
.53852 .39194 L
.53925 .39198 L
.53994 .39198 L
.5411 .39192 L
.54232 .3918 L
.54296 .3917 L
.54366 .39159 L
.54489 .39136 L
Mistroke
.54714 .3909 L
.54955 .39044 L
.55029 .39033 L
.551 .39025 L
.55164 .39019 L
.55233 .39016 L
.55298 .39015 L
.55367 .39016 L
.55492 .39029 L
.55611 .39052 L
.55723 .39086 L
.55846 .39138 L
.55978 .39213 L
.56201 .3939 L
.56446 .39661 L
.56701 .4004 L
.56938 .40486 L
.57363 .41523 L
.57817 .42961 L
.59812 .51936 L
.60358 .54364 L
.60657 .55512 L
.60936 .56422 L
.61174 .57049 L
.61296 .57313 L
.61429 .57549 L
.61505 .5766 L
.61575 .57746 L
.6164 .57813 L
.61713 .57869 L
.61838 .57926 L
.61907 .57934 L
.61971 .57926 L
.62092 .57871 L
.62204 .57771 L
.62328 .57608 L
.6246 .57368 L
.62598 .57044 L
.6273 .56668 L
.62975 .55784 L
.63417 .53602 L
.63896 .50412 L
.64976 .40636 L
.65973 .29785 L
.66876 .20082 L
.67847 .11417 L
.68132 .09417 L
.68403 .07788 L
.68667 .06467 L
.68912 .05484 L
Mistroke
.69143 .04773 L
.69272 .04466 L
.69389 .04244 L
.69517 .0406 L
.6959 .03983 L
.69657 .03931 L
.6978 .03876 L
.69909 .03878 L
.70031 .03932 L
.701 .03986 L
.70164 .04049 L
.70281 .04199 L
.70405 .04405 L
.7062 .04868 L
.70857 .05523 L
.71382 .07412 L
.71874 .09582 L
.72749 .13808 L
.73707 .18024 L
.74217 .19794 L
.74691 .21062 L
.74953 .21601 L
.75191 .21993 L
.75323 .22172 L
.75466 .22336 L
.75601 .22464 L
.75726 .22562 L
.75842 .22635 L
.75949 .22688 L
.76067 .22732 L
.76194 .22764 L
.76315 .22782 L
.76384 .22787 L
.76448 .22789 L
.76565 .22785 L
.76689 .22773 L
.76804 .22757 L
.76929 .22734 L
.77155 .22688 L
.77376 .22645 L
.77472 .2263 L
.77577 .22616 L
.77699 .22607 L
.77815 .22606 L
.77879 .22609 L
.77948 .22615 L
.7807 .22635 L
.78183 .22664 L
.78289 .22702 L
.78405 .22756 L
Mistroke
.7853 .22831 L
.7881 .23061 L
.79076 .23368 L
.79314 .23721 L
.79575 .24193 L
.80104 .25419 L
.80668 .27081 L
.81683 .30668 L
.8271 .3435 L
.83251 .3601 L
.83822 .37417 L
.84323 .38305 L
.84607 .38664 L
.84743 .38801 L
.84872 .38909 L
.84989 .3899 L
.85116 .39062 L
.85232 .39113 L
.85339 .39148 L
.85454 .39175 L
.85581 .39192 L
.85645 .39197 L
.85714 .39198 L
.85839 .39194 L
.85964 .39181 L
.86078 .39165 L
.86334 .39116 L
.86574 .39067 L
.86679 .39048 L
.86795 .39031 L
.8692 .39019 L
.86989 .39015 L
.87053 .39015 L
.87123 .39017 L
.87188 .39022 L
.87262 .39032 L
.87333 .39046 L
.87459 .39083 L
.87576 .39131 L
.87704 .39201 L
.87841 .39298 L
.88115 .39566 L
.88269 .39765 L
.88411 .3998 L
.88948 .41093 L
.89435 .42522 L
.8995 .44436 L
.90972 .49103 L
.91939 .53667 L
.9236 .55356 L
Mistroke
.92807 .56769 L
.9304 .57308 L
.93172 .57545 L
.93297 .57719 L
.93411 .57834 L
.93515 .57902 L
.9363 .57933 L
.9375 .57916 L
.93867 .57849 L
.93974 .57745 L
.94097 .57571 L
.94213 .57354 L
.94419 .56838 L
.94643 .56092 L
.94889 .55041 L
.9515 .53673 L
.95618 .50591 L
.96571 .42174 L
.97619 .30902 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.12.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S5.12.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["setting", "SO10",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Fourier coefficient", "SO10",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["{0,", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["1}", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         SubsuperscriptBox["\[Integral]", 
          RowBox[{
           RowBox[{"-", "1"}], "/", "2"}], 
          RowBox[{"1", "/", "2"}]], 
         StyleBox["f",
          "TI"], 
         RowBox[{"(", 
          StyleBox["t",
           "TI"], ")"}], " ", 
         SuperscriptBox[
          StyleBox["e",
           "TI"], 
          RowBox[{"2", "\[Pi]", 
           StyleBox["i",
            "TI"], 
           StyleBox["n",
            "TI"], 
           StyleBox["t",
            "TI"]}]], "\[DifferentialD]", 
         StyleBox["t",
          "TI"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["{", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["a", "TI",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["b", "TI",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["}", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"\[LeftBracketingBar]", 
           StyleBox["b",
            "TI"], "\[RightBracketingBar]"}], 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", 
             StyleBox["a",
              "TI"]}], ")"}], "/", "2"}]], 
         SubsuperscriptBox["\[Integral]", 
          RowBox[{
           RowBox[{"-", "1"}], "/", 
           RowBox[{"(", 
            RowBox[{"2", "\[LeftBracketingBar]", 
             StyleBox["b",
              "TI"], "\[RightBracketingBar]"}], ")"}]}], 
          RowBox[{"1", "/", 
           RowBox[{"(", 
            RowBox[{"2", "\[LeftBracketingBar]", 
             StyleBox["b",
              "TI"], "\[RightBracketingBar]"}], ")"}]}]], 
         StyleBox["f",
          "TI"], 
         RowBox[{"(", 
          StyleBox["t",
           "TI"], ")"}], " ", 
         SuperscriptBox[
          StyleBox["e",
           "TI"], 
          RowBox[{"2", "\[Pi]", 
           StyleBox["i",
            "TI"], 
           StyleBox["b",
            "TI"], 
           StyleBox["n",
            "TI"], 
           StyleBox["t",
            "TI"]}]], "\[DifferentialD]", 
         StyleBox["t",
          "TI"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->{True, False},
 RowSpacings->0.4},
 CellTags->"S5.12.1"],

Cell[TextData[{
 "Effect of ",
 StyleBox["FourierParameters", "MR"],
 " setting on Fourier exponential coefficients."
}], "Caption",
 CellTags->"S5.12.1"],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["setting", "SO10",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Fourier series", "SO10",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], "\[Null]"},
    {Cell[TextData[{
      StyleBox["{0,", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["1}", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         UnderoverscriptBox["\[Sum]", 
          RowBox[{
           StyleBox["n",
            "TI"], "=", "-", 
           StyleBox["k",
            "TI"]}], 
          StyleBox["k",
           "TI"],
          LimitsPositioning->True], 
         SubscriptBox[
          StyleBox["F",
           "TI"], 
          StyleBox["n",
           "TI"]], " ", 
         SuperscriptBox[
          StyleBox["e",
           "TI"], 
          RowBox[{
           RowBox[{"-", "2"}], "\[Pi]", 
           StyleBox["i",
            "TI"], 
           StyleBox["n",
            "TI"], 
           StyleBox["t",
            "TI"]}]]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], "\[Null]"},
    {Cell[TextData[{
      StyleBox["{", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["a", "TI",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["b", "TI",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["}", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"\[LeftBracketingBar]", 
           StyleBox["b",
            "TI"], "\[RightBracketingBar]"}], 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", 
             StyleBox["a",
              "TI"]}], ")"}], "/", "2"}]], 
         UnderoverscriptBox["\[Sum]", 
          RowBox[{
           StyleBox["n",
            "TI"], "=", "-", 
           StyleBox["k",
            "TI"]}], 
          StyleBox["k",
           "TI"],
          LimitsPositioning->True], 
         SubscriptBox[
          StyleBox["F",
           "TI"], 
          StyleBox["n",
           "TI"]], " ", 
         SuperscriptBox[
          StyleBox["e",
           "TI"], 
          RowBox[{
           RowBox[{"-", "2"}], "\[Pi]", 
           StyleBox["i",
            "TI"], 
           StyleBox["b",
            "TI"], 
           StyleBox["n",
            "TI"], 
           StyleBox["t",
            "TI"]}]]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], "\[Null]"}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
 GridBoxOptions->{RowLines->{True, False},
 RowSpacings->0.4},
 CellTags->"S5.12.1"],

Cell[TextData[{
 "Effect of ",
 StyleBox["FourierParameters", "MR"],
 " setting on Fourier exponential series."
}], "Caption",
 CellTags->"S5.12.1"],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["setting", "SO10",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["c",
          "TI"], "0"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["c",
          "TI"], 
         StyleBox["n",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["{0,", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["1}", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         SubsuperscriptBox["\[Integral]", 
          RowBox[{
           RowBox[{"-", "1"}], "/", "2"}], 
          RowBox[{"1", "/", "2"}]], 
         StyleBox["f",
          "TI"], 
         RowBox[{"(", 
          StyleBox["t",
           "TI"], ")"}], "\[DifferentialD]", 
         StyleBox["t",
          "TI"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"2", 
         SubsuperscriptBox["\[Integral]", 
          RowBox[{
           RowBox[{"-", "1"}], "/", "2"}], 
          RowBox[{"1", "/", "2"}]], 
         StyleBox["f",
          "TI"], 
         RowBox[{"(", 
          StyleBox["t",
           "TI"], ")"}], " ", "cos", 
         RowBox[{"(", 
          RowBox[{"2", "\[Pi]", 
           StyleBox["n",
            "TI"], 
           StyleBox["t",
            "TI"]}], ")"}], "\[DifferentialD]", 
         StyleBox["t",
          "TI"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["{", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["a", "TI",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["b", "TI",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["}", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"\[LeftBracketingBar]", 
           StyleBox["b",
            "TI"], "\[RightBracketingBar]"}], 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", 
             StyleBox["a",
              "TI"]}], ")"}], "/", "2"}]], 
         SubsuperscriptBox["\[Integral]", 
          RowBox[{
           RowBox[{"-", "1"}], "/", 
           RowBox[{"(", 
            RowBox[{"2", "\[LeftBracketingBar]", 
             StyleBox["b",
              "TI"], "\[RightBracketingBar]"}], ")"}]}], 
          RowBox[{"1", "/", 
           RowBox[{"(", 
            RowBox[{"2", "\[LeftBracketingBar]", 
             StyleBox["b",
              "TI"], "\[RightBracketingBar]"}], ")"}]}]], 
         StyleBox["f",
          "TI"], 
         RowBox[{"(", 
          StyleBox["t",
           "TI"], ")"}], "\[DifferentialD]", 
         StyleBox["t",
          "TI"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"2", 
         SuperscriptBox[
          RowBox[{"\[LeftBracketingBar]", 
           StyleBox["b",
            "TI"], "\[RightBracketingBar]"}], 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", 
             StyleBox["a",
              "TI"]}], ")"}], "/", "2"}]], 
         SubsuperscriptBox["\[Integral]", 
          RowBox[{
           RowBox[{"-", "1"}], "/", 
           RowBox[{"(", 
            RowBox[{"2", "\[LeftBracketingBar]", 
             StyleBox["b",
              "TI"], "\[RightBracketingBar]"}], ")"}]}], 
          RowBox[{"1", "/", 
           RowBox[{"(", 
            RowBox[{"2", "\[LeftBracketingBar]", 
             StyleBox["b",
              "TI"], "\[RightBracketingBar]"}], ")"}]}]], 
         StyleBox["f",
          "TI"], 
         RowBox[{"(", 
          StyleBox["t",
           "TI"], ")"}], " ", "cos", 
         RowBox[{"(", 
          RowBox[{"2", "\[Pi]", 
           StyleBox["b",
            "TI"], 
           StyleBox["n",
            "TI"], 
           StyleBox["t",
            "TI"]}], ")"}], "\[DifferentialD]", 
         StyleBox["t",
          "TI"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
 GridBoxOptions->{RowLines->{True, False},
 RowSpacings->0.4},
 CellTags->"S5.12.1"],

Cell[TextData[{
 "Effect of ",
 StyleBox["FourierParameters", "MR"],
 " setting on Fourier cosine coefficients."
}], "Caption",
 CellTags->"S5.12.1"],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["setting", "SO10",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["d",
          "TI"], 
         StyleBox["n",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["{0,", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["1}", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"2", 
         SubsuperscriptBox["\[Integral]", 
          RowBox[{
           RowBox[{"-", "1"}], "/", "2"}], 
          RowBox[{"1", "/", "2"}]], 
         StyleBox["f",
          "TI"], 
         RowBox[{"(", 
          StyleBox["t",
           "TI"], ")"}], " ", "sin", 
         RowBox[{"(", 
          RowBox[{"2", "\[Pi]", 
           StyleBox["n",
            "TI"], 
           StyleBox["t",
            "TI"]}], ")"}], "\[DifferentialD]", 
         StyleBox["t",
          "TI"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["{", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["a", "TI",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["b", "TI",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["}", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"2", 
         SuperscriptBox[
          RowBox[{"\[LeftBracketingBar]", 
           StyleBox["b",
            "TI"], "\[RightBracketingBar]"}], 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", 
             StyleBox["a",
              "TI"]}], ")"}], "/", "2"}]], 
         SubsuperscriptBox["\[Integral]", 
          RowBox[{
           RowBox[{"-", "1"}], "/", 
           RowBox[{"(", 
            RowBox[{"2", "\[LeftBracketingBar]", 
             StyleBox["b",
              "TI"], "\[RightBracketingBar]"}], ")"}]}], 
          RowBox[{"1", "/", 
           RowBox[{"(", 
            RowBox[{"2", "\[LeftBracketingBar]", 
             StyleBox["b",
              "TI"], "\[RightBracketingBar]"}], ")"}]}]], 
         StyleBox["f",
          "TI"], 
         RowBox[{"(", 
          StyleBox["t",
           "TI"], ")"}], " ", "sin", 
         RowBox[{"(", 
          RowBox[{"2", "\[Pi]", 
           StyleBox["b",
            "TI"], 
           StyleBox["n",
            "TI"], 
           StyleBox["t",
            "TI"]}], ")"}], "\[DifferentialD]", 
         StyleBox["t",
          "TI"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->{True, False},
 RowSpacings->0.4},
 CellTags->"S5.12.1"],

Cell[TextData[{
 "Effect of ",
 StyleBox["FourierParameters", "MR"],
 " setting on Fourier sine coefficients."
}], "Caption",
 CellTags->"S5.12.1"],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["setting", "SO10",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Fourier trigonometric series", "SO10",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["{0,", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["1}", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         SubscriptBox[
          StyleBox["c",
           "TI"], "0"], "+", 
         UnderoverscriptBox["\[Sum]", 
          RowBox[{
           StyleBox["n",
            "TI"], "=", "1"}], 
          StyleBox["k",
           "TI"],
          LimitsPositioning->True], 
         SubscriptBox[
          StyleBox["c",
           "TI"], 
          StyleBox["n",
           "TI"]], "cos", 
         RowBox[{"(", 
          RowBox[{"2", "\[Pi]", 
           StyleBox["n",
            "TI"], 
           StyleBox["t",
            "TI"]}], ")"}], "+", 
         SubscriptBox[
          StyleBox["d",
           "TI"], 
          StyleBox["n",
           "TI"]], "sin", 
         RowBox[{"(", 
          RowBox[{"2", "\[Pi]", 
           StyleBox["n",
            "TI"], 
           StyleBox["t",
            "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["{", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["a", "TI",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["b", "TI",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["}", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"\[LeftBracketingBar]", 
           StyleBox["b",
            "TI"], "\[RightBracketingBar]"}], 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", 
             StyleBox["a",
              "TI"]}], ")"}], "/", "2"}]], 
         RowBox[{"(", 
          RowBox[{
           SubscriptBox[
            StyleBox["c",
             "TI"], "0"], "+", 
           UnderoverscriptBox["\[Sum]", 
            RowBox[{
             StyleBox["n",
              "TI"], "=", "1"}], 
            StyleBox["k",
             "TI"],
            LimitsPositioning->True], 
           SubscriptBox[
            StyleBox["c",
             "TI"], 
            StyleBox["n",
             "TI"]], "cos", 
           RowBox[{"(", 
            RowBox[{"2", "\[Pi]", 
             StyleBox["b",
              "TI"], 
             StyleBox["n",
              "TI"], 
             StyleBox["t",
              "TI"]}], ")"}], "+", 
           SubscriptBox[
            StyleBox["d",
             "TI"], 
            StyleBox["n",
             "TI"]], "sin", 
           RowBox[{"(", 
            RowBox[{"2", "\[Pi]", 
             StyleBox["b",
              "TI"], 
             StyleBox["n",
              "TI"], 
             StyleBox["t",
              "TI"]}], ")"}]}], ")"}]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->{True, False},
 RowSpacings->0.4},
 CellTags->"S5.12.1"],

Cell[TextData[{
 "Effect of ",
 StyleBox["FourierParameters", "MR"],
 " setting on Fourier trigonometric series."
}], "Caption",
 CellTags->"S5.12.1"],

Cell[TextData[{
 "In certain circumstances you will not want exact or symbolic coefficients, \
but numerical approximations to the coefficients. In these cases you can use \
the numerical versions of the Fourier series functions. The numerical \
approximation functions accept the ",
 StyleBox["FourierParameters", "MR"],
 " option, allowing you to specify the period. "
}], "Text",
 CellTags->{"S5.12.1", "1.11"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["NFourierCoefficient[", "MR",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox["t", "TI",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, False, True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["find a numerical approximation to the ",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SuperscriptBox[
         StyleBox["n",
          "TI"], "th"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[" coefficient in the exponential series expansion ",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, False, True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["NFourierSinCoefficient[", "MR",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox["t", "TI",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, False, True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["find a numerical approximation to the ",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SuperscriptBox[
         StyleBox["n",
          "TI"], "th"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[" coefficient in the sine series expansion",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, False, True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["NFourierCosCoefficient[", "MR",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox["t", "TI",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, False, True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["find a numerical approximation to the ",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SuperscriptBox[
         StyleBox["n",
          "TI"], "th"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[" coefficient in the cosine series expansion",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, False, True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["NFourierSeries[", "MR",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox["t", "TI",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox["k", "TI",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, False, True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["find the exponential series expansion to order ",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox["k", "TI",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[" using numerical approximations for the coefficients",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, False, True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["NFourierTrigSeries[", "MR",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox["t", "TI",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox["k", "TI",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, False, True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["find the trigonometric series expansion to order ",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox["k", "TI",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[" using numerical approximations for the coefficients",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, False, True, False},
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->{False, False, True, False},
 RowSpacings->0.4},
 CellTags->"S5.12.1"],

Cell["\<\
Finding approximate numerical values for Fourier coefficients and series. \
\>", "Caption",
 CellTags->"S5.12.1"],

Cell[TextData[{
 "Here is a piece of the trigonometric series of a function that looks like \
",
 Cell[BoxData[
  FormBox[
   RowBox[{"sin", 
    RowBox[{"(", 
     RowBox[{"cos", 
      RowBox[{"(", 
       RowBox[{
        StyleBox["t",
         "TI"], "+", 
        FractionBox["1", "2"]}], ")"}]}], ")"}]}], TraditionalForm]], 
  "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " on the interval from ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", 
    FractionBox["1", "2"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " to ",
 Cell[BoxData[
  FormBox[
   FractionBox["1", "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". The function elsewhere is obtained by repeating this with period ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.12.1", "1.12"}],

Cell[CellGroupData[{

Cell["NFourierTrigSeries[Sin[Cos[t + 1/2]], t, 3]", "Input",
 CellLabel->"In[7]:= ",
 CellTags->"S5.12.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"0.7386429980368903`", "\[InvisibleSpace]"}], "+", 
  RowBox[{"0.037078333227460306`", " ", 
   RowBox[{"Cos", "[", 
    RowBox[{"2", " ", "\[Pi]", " ", "t"}], "]"}]}], "-", 
  RowBox[{"0.009180560815768166`", " ", 
   RowBox[{"Cos", "[", 
    RowBox[{"4", " ", "\[Pi]", " ", "t"}], "]"}]}], "+", 
  RowBox[{"0.004070198115637032`", " ", 
   RowBox[{"Cos", "[", 
    RowBox[{"6", " ", "\[Pi]", " ", "t"}], "]"}]}], "-", 
  RowBox[{"0.10033761858804796`", " ", 
   RowBox[{"Sin", "[", 
    RowBox[{"2", " ", "\[Pi]", " ", "t"}], "]"}]}], "+", 
  RowBox[{"0.05172778998316849`", " ", 
   RowBox[{"Sin", "[", 
    RowBox[{"4", " ", "\[Pi]", " ", "t"}], "]"}]}], "-", 
  RowBox[{"0.03461313084639003`", " ", 
   RowBox[{"Sin", "[", 
    RowBox[{"6", " ", "\[Pi]", " ", "t"}], "]"}]}]}]], "Output",
 CellLabel->"Out[7]= ",
 CellTags->"S5.12.1"]
}, Open  ]],

Cell["\<\
Here is a plot of the trigonometric polynomial over three periods. \
\>", "MathCaption",
 CellTags->{"S5.12.1", "1.13"}],

Cell[CellGroupData[{

Cell["Plot[%, {t, -1.5, 1.5}]", "Input",
 CellLabel->"In[8]:= ",
 CellTags->"S5.12.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.31746 -1.09437 1.96234 [
[.02381 .07053 -12 -9 ]
[.02381 .07053 12 0 ]
[.18254 .07053 -6 -9 ]
[.18254 .07053 6 0 ]
[.34127 .07053 -12 -9 ]
[.34127 .07053 12 0 ]
[.65873 .07053 -9 -9 ]
[.65873 .07053 9 0 ]
[.81746 .07053 -3 -9 ]
[.81746 .07053 3 0 ]
[.97619 .07053 -9 -9 ]
[.97619 .07053 9 0 ]
[.4875 .18115 -24 -4.5 ]
[.4875 .18115 0 4.5 ]
[.4875 .27927 -18 -4.5 ]
[.4875 .27927 0 4.5 ]
[.4875 .37739 -24 -4.5 ]
[.4875 .37739 0 4.5 ]
[.4875 .4755 -18 -4.5 ]
[.4875 .4755 0 4.5 ]
[.4875 .57362 -24 -4.5 ]
[.4875 .57362 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .08303 m
.02381 .08928 L
s
[(-1.5)] .02381 .07053 0 1 Mshowa
.18254 .08303 m
.18254 .08928 L
s
[(-1)] .18254 .07053 0 1 Mshowa
.34127 .08303 m
.34127 .08928 L
s
[(-0.5)] .34127 .07053 0 1 Mshowa
.65873 .08303 m
.65873 .08928 L
s
[(0.5)] .65873 .07053 0 1 Mshowa
.81746 .08303 m
.81746 .08928 L
s
[(1)] .81746 .07053 0 1 Mshowa
.97619 .08303 m
.97619 .08928 L
s
[(1.5)] .97619 .07053 0 1 Mshowa
.125 Mabswid
.05556 .08303 m
.05556 .08678 L
s
.0873 .08303 m
.0873 .08678 L
s
.11905 .08303 m
.11905 .08678 L
s
.15079 .08303 m
.15079 .08678 L
s
.21429 .08303 m
.21429 .08678 L
s
.24603 .08303 m
.24603 .08678 L
s
.27778 .08303 m
.27778 .08678 L
s
.30952 .08303 m
.30952 .08678 L
s
.37302 .08303 m
.37302 .08678 L
s
.40476 .08303 m
.40476 .08678 L
s
.43651 .08303 m
.43651 .08678 L
s
.46825 .08303 m
.46825 .08678 L
s
.53175 .08303 m
.53175 .08678 L
s
.56349 .08303 m
.56349 .08678 L
s
.59524 .08303 m
.59524 .08678 L
s
.62698 .08303 m
.62698 .08678 L
s
.69048 .08303 m
.69048 .08678 L
s
.72222 .08303 m
.72222 .08678 L
s
.75397 .08303 m
.75397 .08678 L
s
.78571 .08303 m
.78571 .08678 L
s
.84921 .08303 m
.84921 .08678 L
s
.88095 .08303 m
.88095 .08678 L
s
.9127 .08303 m
.9127 .08678 L
s
.94444 .08303 m
.94444 .08678 L
s
.25 Mabswid
0 .08303 m
1 .08303 L
s
.5 .18115 m
.50625 .18115 L
s
[(0.65)] .4875 .18115 1 0 Mshowa
.5 .27927 m
.50625 .27927 L
s
[(0.7)] .4875 .27927 1 0 Mshowa
.5 .37739 m
.50625 .37739 L
s
[(0.75)] .4875 .37739 1 0 Mshowa
.5 .4755 m
.50625 .4755 L
s
[(0.8)] .4875 .4755 1 0 Mshowa
.5 .57362 m
.50625 .57362 L
s
[(0.85)] .4875 .57362 1 0 Mshowa
.125 Mabswid
.5 .10266 m
.50375 .10266 L
s
.5 .12228 m
.50375 .12228 L
s
.5 .1419 m
.50375 .1419 L
s
.5 .16153 m
.50375 .16153 L
s
.5 .20077 m
.50375 .20077 L
s
.5 .2204 m
.50375 .2204 L
s
.5 .24002 m
.50375 .24002 L
s
.5 .25965 m
.50375 .25965 L
s
.5 .29889 m
.50375 .29889 L
s
.5 .31852 m
.50375 .31852 L
s
.5 .33814 m
.50375 .33814 L
s
.5 .35776 m
.50375 .35776 L
s
.5 .39701 m
.50375 .39701 L
s
.5 .41663 m
.50375 .41663 L
s
.5 .43626 m
.50375 .43626 L
s
.5 .45588 m
.50375 .45588 L
s
.5 .49513 m
.50375 .49513 L
s
.5 .51475 m
.50375 .51475 L
s
.5 .53437 m
.50375 .53437 L
s
.5 .554 m
.50375 .554 L
s
.5 .06341 m
.50375 .06341 L
s
.5 .04379 m
.50375 .04379 L
s
.5 .02416 m
.50375 .02416 L
s
.5 .00454 m
.50375 .00454 L
s
.5 .59324 m
.50375 .59324 L
s
.5 .61287 m
.50375 .61287 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .25634 m
.03279 .36433 L
.04262 .472 L
.04758 .51668 L
.05288 .55488 L
.05546 .56949 L
.05789 .58087 L
.06007 .58905 L
.06244 .59579 L
.0637 .59847 L
.0644 .59969 L
.06506 .60068 L
.06634 .60214 L
.06751 .60296 L
.06817 .60322 L
.06889 .60332 L
.07017 .60307 L
.07096 .60266 L
.0717 .60209 L
.07308 .60059 L
.07445 .59857 L
.0759 .59589 L
.07849 .58983 L
.08435 .57151 L
.09412 .53412 L
.09949 .51418 L
.10458 .49794 L
.1095 .48572 L
.11228 .48056 L
.11485 .47694 L
.11701 .47475 L
.11824 .47384 L
.11939 .4732 L
.1206 .47274 L
.12171 .4725 L
.12293 .47244 L
.12422 .47258 L
.12537 .47287 L
.12641 .47326 L
.12762 .47385 L
.12875 .47452 L
.13297 .4778 L
.13792 .48242 L
.14015 .48445 L
.14255 .48642 L
.14493 .48802 L
.1461 .48864 L
.14718 .4891 L
.14845 .48949 L
.14913 .48962 L
Mistroke
.14984 .48971 L
.15112 .4897 L
.15227 .48951 L
.15292 .48933 L
.1536 .48907 L
.15482 .48844 L
.15614 .48753 L
.15758 .48622 L
.16016 .48308 L
.16257 .4792 L
.16723 .46917 L
.17148 .45733 L
.18102 .42375 L
.19108 .38437 L
.19659 .36435 L
.20175 .34808 L
.20651 .33586 L
.21087 .32723 L
.21571 .32043 L
.21825 .31791 L
.22092 .31592 L
.22333 .31459 L
.22552 .31366 L
.23042 .31201 L
.23261 .31122 L
.23497 .31015 L
.2372 .3088 L
.23926 .30717 L
.24166 .30466 L
.2439 .30162 L
.24636 .29741 L
.249 .29172 L
.25438 .27598 L
.2593 .25648 L
.26919 .20318 L
.27836 .14269 L
.28906 .07317 L
.2943 .04563 L
.2966 .03584 L
.29911 .02704 L
.3002 .02389 L
.30137 .02101 L
.30238 .01894 L
.30348 .01714 L
.30472 .0157 L
.30589 .01492 L
.30703 .01472 L
.30808 .01504 L
.30923 .01594 L
.31031 .01733 L
Mistroke
.3115 .01946 L
.31277 .02246 L
.31537 .03087 L
.31775 .04124 L
.3228 .07151 L
.32831 .11627 L
.33834 .22184 L
.34933 .35348 L
.35968 .46806 L
.3642 .50967 L
.36897 .546 L
.37146 .56156 L
.3742 .57578 L
.3765 .58543 L
.37901 .5935 L
.38037 .59686 L
.38164 .59932 L
.38284 .60111 L
.38412 .60242 L
.38527 .6031 L
.38634 .60332 L
.38752 .60312 L
.38879 .6024 L
.39006 .60118 L
.39145 .59931 L
.39425 .59398 L
.39685 .58741 L
.39926 .58015 L
.41816 .51004 L
.42321 .49468 L
.42588 .48809 L
.42869 .48235 L
.43116 .47843 L
.43246 .47676 L
.43387 .47529 L
.43515 .47421 L
.43633 .47346 L
.43751 .47292 L
.43863 .4726 L
.43981 .47245 L
.44087 .47247 L
.4421 .47267 L
.44325 .47301 L
.44432 .47346 L
.44531 .47397 L
.44753 .47543 L
.45722 .48411 L
.45965 .48614 L
.46194 .48775 L
.46321 .48847 L
Mistroke
.46388 .48879 L
.46459 .48908 L
.46584 .48947 L
.467 .48968 L
.46807 .48973 L
.46923 .48961 L
.47033 .48934 L
.47133 .48895 L
.4725 .48831 L
.47377 .48738 L
.4761 .48505 L
.47882 .48125 L
.48129 .47681 L
.48683 .46352 L
.49678 .43021 L
.50693 .39058 L
.51247 .36987 L
.51764 .35273 L
.52243 .33952 L
.52679 .32999 L
.53164 .32227 L
.53431 .31921 L
.53684 .31699 L
.53905 .31551 L
.54149 .31427 L
.54642 .31248 L
.54868 .31174 L
.55105 .31081 L
.55308 .3098 L
.55529 .30834 L
.55788 .30605 L
.56028 .30318 L
.56287 .29914 L
.56565 .2936 L
.57075 .27966 L
.57538 .26246 L
.58535 .21112 L
.59455 .15132 L
.60529 .08045 L
.61055 .05142 L
.61284 .04082 L
.61535 .03106 L
.61775 .02365 L
.61892 .02081 L
.61998 .01868 L
.62108 .01694 L
.62212 .01576 L
.62321 .01498 L
.62439 .01472 L
.62556 .01505 L
Mistroke
.62685 .01611 L
.6275 .01693 L
.62819 .01801 L
.62945 .02052 L
.63188 .02743 L
.6341 .03608 L
.63918 .06412 L
.6447 .10672 L
.65474 .20953 L
.67415 .43728 L
.67947 .49035 L
.6852 .53745 L
.68783 .55507 L
.69061 .57067 L
.6932 .58248 L
.69556 .59086 L
.69672 .59418 L
.69798 .59718 L
.69907 .59928 L
.70027 .60107 L
.70154 .60239 L
.70223 .60286 L
.70288 .60315 L
.70405 .60331 L
.70529 .60298 L
.70646 .60223 L
.70772 .60094 L
.70892 .5993 L
.71002 .59743 L
.71434 .58732 L
.71907 .57225 L
.72429 .5527 L
.73487 .5126 L
.73977 .49718 L
.74244 .49017 L
.74494 .48467 L
.74725 .48049 L
.74935 .47746 L
.75168 .47496 L
.75297 .47397 L
.75418 .47326 L
.75538 .47278 L
.7567 .47249 L
.75737 .47244 L
.75808 .47245 L
.75938 .47263 L
.76066 .473 L
.76188 .47351 L
.76418 .47485 L
.76936 .47913 L
Mistroke
.77502 .48441 L
.77758 .4865 L
.77892 .48745 L
.78034 .4883 L
.78158 .4889 L
.78224 .48915 L
.78295 .48938 L
.78419 .48964 L
.78535 .48973 L
.78655 .48964 L
.78786 .48932 L
.7891 .4888 L
.79024 .48813 L
.7924 .48631 L
.7947 .4836 L
.79718 .47975 L
.79985 .47453 L
.80467 .46242 L
.81568 .42475 L
.82518 .38751 L
.83533 .35204 L
.84117 .33648 L
.84647 .3261 L
.84902 .32237 L
.85179 .31919 L
.85441 .31691 L
.85682 .31533 L
.86162 .31323 L
.86426 .31236 L
.86677 .31151 L
.8691 .31054 L
.87163 .30913 L
.87394 .30738 L
.87608 .30524 L
.87854 .30204 L
.88078 .29835 L
.88578 .28692 L
.88843 .27894 L
.89128 .26873 L
.89646 .24597 L
.91605 .12386 L
.92642 .05955 L
.9294 .04479 L
.93223 .03313 L
.93476 .02488 L
.93619 .02125 L
.93752 .01855 L
.93868 .01677 L
.93992 .01546 L
.94063 .015 L
Mistroke
.9413 .01476 L
.94257 .01485 L
.94321 .01516 L
.94389 .01569 L
.94513 .01717 L
.94588 .01841 L
.94659 .01982 L
.94792 .02307 L
.95033 .03099 L
.95254 .04059 L
.95753 .07018 L
.96186 .10404 L
.9666 .14883 L
.97619 .25634 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.12.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[8]= ",
 CellTags->"S5.12.1"]
}, Open  ]],

Cell[TextData[{
 "The function ",
 StyleBox["FourierCoefficient", "MR"],
 ", giving the coefficients of the Fourier exponential series, can be thought \
of as a transform from the continuous time domain into the discrete frequency \
domain. Likewise, the (infinite sum) Fourier exponential series can be \
thought of as an inverse transform from the discrete frequency domain into \
the continuous time domain. This transform pair is given by ",
 StyleBox["FourierCoefficient", "MR"],
 " and ",
 StyleBox["InverseFourierCoefficient", "MR"],
 ", and the numerical counterparts are given by ",
 StyleBox["NFourierCoefficient", "MR"],
 " and ",
 StyleBox["NInverseFourierCoefficient", "MR"],
 ". If the option setting ",
 StyleBox["FourierParameters -> {", "MR"],
 StyleBox["a", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["b", "TI"],
 StyleBox["}", "MR"],
 " is specified, the period of the original function is taken to be ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "/", "\[LeftBracketingBar]", 
    StyleBox["b",
     "TI"], "\[RightBracketingBar]"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", instead of the default period of ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "Text",
 CellTags->{"S5.12.1", "1.14"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["FourierCoefficient[", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["t", "TI",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["F",
          "TI"], 
         StyleBox["n",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[", a function of integer ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[" and the ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SuperscriptBox[
         StyleBox["n",
          "TI"], "th"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[
      " coefficient in the exponential series expansion of the periodic \
function ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["f",
          "TI"], 
         RowBox[{"(", 
          StyleBox["t",
           "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[", equal to ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[" on the interval ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["t",
          "TI"], "=", "-", 
         FractionBox["1", "2"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[" to ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["t",
          "TI"], "=", 
         FractionBox["1", "2"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["InverseFourierCoefficient[", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["t", "TI",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["f",
          "TI"], 
         RowBox[{"(", 
          StyleBox["t",
           "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[", a periodic function of ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["t", "TI",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[
      ", represented by the Fourier exponential series coefficients ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[", where ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[" is treated as a function of integer ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["n",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["NFourierCoefficient[", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["t", "TI",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["find a numerical approximation to the function ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["F",
          "TI"], 
         StyleBox["n",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["NInverseFourierCoefficient[", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["t", "TI",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["find a numerical approximation to the function ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["f",
          "TI"], 
         RowBox[{"(", 
          StyleBox["t",
           "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, True, False},
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->{False, True, False},
 RowSpacings->0.4},
 CellTags->"S5.12.1"],

Cell["\<\
Continuous\[Hyphen]time and discrete\[Hyphen]frequency transform pairs: exact \
and numerical approximations. \
\>", "Caption",
 CellTags->"S5.12.1"],

Cell[TextData[{
 "Here is a plot of a periodic function of ",
 Cell[BoxData[
  FormBox[
   StyleBox["t",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", with a period of ",
 Cell[BoxData[
  FormBox[
   FractionBox["2", "3"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.12.1", "1.15"}],

Cell[CellGroupData[{

Cell["\<\
(f = 1 + 2 Cos[3 Pi t] + 2 Cos[6 Pi t];
Plot[f, {t, -1, 1}])\
\>", "Input",
 CellLabel->"In[9]:= ",
 CellTags->"S5.12.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.476191 0.132439 0.0941793 [
[.02381 .11994 -6 -9 ]
[.02381 .11994 6 0 ]
[.2619 .11994 -12 -9 ]
[.2619 .11994 12 0 ]
[.7381 .11994 -9 -9 ]
[.7381 .11994 9 0 ]
[.97619 .11994 -3 -9 ]
[.97619 .11994 3 0 ]
[.4875 .03826 -12 -4.5 ]
[.4875 .03826 0 4.5 ]
[.4875 .22662 -6 -4.5 ]
[.4875 .22662 0 4.5 ]
[.4875 .3208 -6 -4.5 ]
[.4875 .3208 0 4.5 ]
[.4875 .41498 -6 -4.5 ]
[.4875 .41498 0 4.5 ]
[.4875 .50916 -6 -4.5 ]
[.4875 .50916 0 4.5 ]
[.4875 .60334 -6 -4.5 ]
[.4875 .60334 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .13244 m
.02381 .13869 L
s
[(-1)] .02381 .11994 0 1 Mshowa
.2619 .13244 m
.2619 .13869 L
s
[(-0.5)] .2619 .11994 0 1 Mshowa
.7381 .13244 m
.7381 .13869 L
s
[(0.5)] .7381 .11994 0 1 Mshowa
.97619 .13244 m
.97619 .13869 L
s
[(1)] .97619 .11994 0 1 Mshowa
.125 Mabswid
.07143 .13244 m
.07143 .13619 L
s
.11905 .13244 m
.11905 .13619 L
s
.16667 .13244 m
.16667 .13619 L
s
.21429 .13244 m
.21429 .13619 L
s
.30952 .13244 m
.30952 .13619 L
s
.35714 .13244 m
.35714 .13619 L
s
.40476 .13244 m
.40476 .13619 L
s
.45238 .13244 m
.45238 .13619 L
s
.54762 .13244 m
.54762 .13619 L
s
.59524 .13244 m
.59524 .13619 L
s
.64286 .13244 m
.64286 .13619 L
s
.69048 .13244 m
.69048 .13619 L
s
.78571 .13244 m
.78571 .13619 L
s
.83333 .13244 m
.83333 .13619 L
s
.88095 .13244 m
.88095 .13619 L
s
.92857 .13244 m
.92857 .13619 L
s
.25 Mabswid
0 .13244 m
1 .13244 L
s
.5 .03826 m
.50625 .03826 L
s
[(-1)] .4875 .03826 1 0 Mshowa
.5 .22662 m
.50625 .22662 L
s
[(1)] .4875 .22662 1 0 Mshowa
.5 .3208 m
.50625 .3208 L
s
[(2)] .4875 .3208 1 0 Mshowa
.5 .41498 m
.50625 .41498 L
s
[(3)] .4875 .41498 1 0 Mshowa
.5 .50916 m
.50625 .50916 L
s
[(4)] .4875 .50916 1 0 Mshowa
.5 .60334 m
.50625 .60334 L
s
[(5)] .4875 .60334 1 0 Mshowa
.125 Mabswid
.5 .0571 m
.50375 .0571 L
s
.5 .07593 m
.50375 .07593 L
s
.5 .09477 m
.50375 .09477 L
s
.5 .1136 m
.50375 .1136 L
s
.5 .15127 m
.50375 .15127 L
s
.5 .17011 m
.50375 .17011 L
s
.5 .18895 m
.50375 .18895 L
s
.5 .20778 m
.50375 .20778 L
s
.5 .24545 m
.50375 .24545 L
s
.5 .26429 m
.50375 .26429 L
s
.5 .28313 m
.50375 .28313 L
s
.5 .30196 m
.50375 .30196 L
s
.5 .33963 m
.50375 .33963 L
s
.5 .35847 m
.50375 .35847 L
s
.5 .37731 m
.50375 .37731 L
s
.5 .39614 m
.50375 .39614 L
s
.5 .43381 m
.50375 .43381 L
s
.5 .45265 m
.50375 .45265 L
s
.5 .47148 m
.50375 .47148 L
s
.5 .49032 m
.50375 .49032 L
s
.5 .52799 m
.50375 .52799 L
s
.5 .54683 m
.50375 .54683 L
s
.5 .56566 m
.50375 .56566 L
s
.5 .5845 m
.50375 .5845 L
s
.5 .01942 m
.50375 .01942 L
s
.5 .00059 m
.50375 .00059 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .22662 m
.02499 .22647 L
.02605 .22606 L
.02729 .22528 L
.02846 .22424 L
.03053 .22165 L
.03279 .21782 L
.03527 .2124 L
.0379 .20536 L
.04262 .18969 L
.06244 .0985 L
.0721 .05498 L
.07753 .0357 L
.08011 .02844 L
.0825 .02296 L
.08396 .02025 L
.08529 .01823 L
.08677 .01651 L
.08758 .01581 L
.08834 .0153 L
.08902 .01498 L
.08973 .01478 L
.09101 .01477 L
.09172 .01496 L
.09239 .01526 L
.09312 .01574 L
.0939 .01643 L
.09527 .01806 L
.09677 .02046 L
.09949 .02652 L
.10213 .03453 L
.10458 .04379 L
.10921 .06607 L
.11421 .09674 L
.12324 .16751 L
.14385 .36976 L
.15423 .46812 L
.16389 .54159 L
.16876 .56903 L
.17126 .58018 L
.17396 .58988 L
.17551 .59427 L
.17693 .59756 L
.1783 .60002 L
.17899 .60102 L
.17974 .60189 L
.18103 .60292 L
.18224 .60332 L
.18297 .6033 L
.18367 .6031 L
Mistroke
.18499 .60223 L
.18624 .60082 L
.18759 .59865 L
.18886 .596 L
.19003 .59305 L
.1946 .57694 L
.19697 .56579 L
.19958 .55149 L
.20483 .51661 L
.22323 .3496 L
.23412 .23962 L
.24442 .14552 L
.25366 .07878 L
.25888 .05086 L
.26121 .04093 L
.26371 .03202 L
.26613 .02515 L
.26719 .0227 L
.26835 .0204 L
.26937 .01869 L
.27047 .0172 L
.27163 .01602 L
.2727 .01526 L
.27398 .01478 L
.27471 .01472 L
.27537 .01478 L
.2766 .01522 L
.2779 .01613 L
.27906 .01731 L
.28014 .01873 L
.28261 .02302 L
.28521 .02905 L
.28767 .03608 L
.29229 .05227 L
.30267 .09867 L
.31142 .14167 L
.32086 .1836 L
.32627 .20262 L
.32864 .20941 L
.33123 .21564 L
.33368 .22031 L
.33597 .22352 L
.33723 .22482 L
.33838 .2257 L
.33902 .22606 L
.33971 .22635 L
.34097 .22661 L
.34219 .22652 L
.34334 .22614 L
.3446 .22539 L
Mistroke
.34531 .22482 L
.34595 .2242 L
.34866 .22062 L
.35124 .2158 L
.35577 .20414 L
.36072 .1873 L
.38172 .08977 L
.38659 .06741 L
.39186 .04624 L
.39427 .03795 L
.39683 .03038 L
.39904 .02492 L
.4014 .02028 L
.40282 .01813 L
.40412 .01662 L
.40542 .01553 L
.40665 .01492 L
.40735 .01475 L
.40808 .01472 L
.40871 .01481 L
.40941 .01505 L
.41015 .01545 L
.41096 .01605 L
.41171 .0168 L
.41241 .01763 L
.41473 .02142 L
.41604 .02427 L
.41727 .02739 L
.41993 .0357 L
.42238 .04522 L
.42744 .07033 L
.43291 .1054 L
.44285 .18672 L
.46145 .37116 L
.4705 .45766 L
.48022 .53426 L
.4858 .56697 L
.48844 .57906 L
.49089 .58818 L
.49334 .5952 L
.49464 .59804 L
.49601 .60041 L
.49733 .60202 L
.49856 .60295 L
.49967 .60332 L
.50087 .6032 L
.50212 .60251 L
.50325 .60138 L
.50457 .5995 L
.50581 .59714 L
Mistroke
.50801 .59157 L
.51041 .58359 L
.51584 .55831 L
.52086 .52685 L
.53109 .44323 L
.54194 .33687 L
.55207 .23482 L
.56169 .14704 L
.57033 .08366 L
.57522 .0562 L
.57977 .03678 L
.5823 .02859 L
.58469 .02261 L
.58683 .01869 L
.58804 .01707 L
.58916 .01596 L
.59036 .01516 L
.59148 .01477 L
.5927 .01476 L
.59402 .0152 L
.59468 .0156 L
.5954 .01617 L
.59671 .01754 L
.59799 .0193 L
.59917 .02128 L
.60398 .03263 L
.60672 .04122 L
.60929 .0505 L
.62004 .09825 L
.62897 .14209 L
.63851 .18432 L
.64399 .20342 L
.64898 .21625 L
.65138 .22069 L
.65265 .22255 L
.65399 .22414 L
.65516 .22521 L
.65645 .22604 L
.65762 .22648 L
.65872 .22662 L
.65996 .22645 L
.66066 .22621 L
.66131 .22589 L
.66249 .22505 L
.66376 .22383 L
.66618 .22053 L
.66837 .21648 L
.67372 .20266 L
.67875 .1851 L
.69985 .08658 L
Mistroke
.70963 .04512 L
.71455 .02967 L
.71735 .0231 L
.7186 .02073 L
.71995 .01859 L
.7212 .01702 L
.72235 .01592 L
.72345 .0152 L
.72462 .01478 L
.72567 .01473 L
.72665 .01496 L
.72772 .01552 L
.72888 .01649 L
.73004 .01785 L
.73131 .01979 L
.73387 .02515 L
.73623 .03184 L
.73844 .03955 L
.7435 .06265 L
.74898 .09574 L
.75892 .1742 L
.77752 .35721 L
.78781 .45631 L
.79743 .53253 L
.80226 .56182 L
.80475 .57407 L
.80746 .58508 L
.80899 .59021 L
.81041 .59423 L
.81175 .59734 L
.81322 .60002 L
.81453 .60176 L
.81577 .60281 L
.81707 .60331 L
.81781 .60331 L
.81848 .60314 L
.81975 .60237 L
.82095 .60109 L
.82203 .59949 L
.82321 .59727 L
.82583 .5905 L
.82826 .5821 L
.83268 .56168 L
.83737 .53336 L
.84722 .45537 L
.85806 .35054 L
.86885 .24148 L
.8791 .14746 L
.88831 .08046 L
.89352 .05219 L
Mistroke
.89835 .03291 L
.90079 .02581 L
.90207 .02278 L
.90342 .02012 L
.90461 .01822 L
.90591 .01662 L
.9071 .01559 L
.9082 .01498 L
.90936 .01472 L
.91045 .01482 L
.91144 .01518 L
.91251 .01587 L
.91367 .01696 L
.91491 .0185 L
.91713 .02221 L
.91949 .02742 L
.92203 .03438 L
.92664 .05008 L
.93713 .09645 L
.97619 .22662 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.12.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[9]= ",
 CellTags->"S5.12.1"]
}, Open  ]],

Cell[TextData[{
 "You can use the ",
 StyleBox["FourierParameters", "MR"],
 " option to specify the period of the function. "
}], "MathCaption",
 CellTags->{"S5.12.1", "1.16"}],

Cell[CellGroupData[{

Cell["\<\
Chop[Table[
NFourierCoefficient[f, t, n,
        FourierParameters -> {0, 3/2},
        AccuracyGoal->8, PrecisionGoal->8],
        {n, -10, 10}]]\
\>", "Input",
 CellLabel->"In[10]:= ",
 CellTags->"S5.12.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0.8164965809277258`", ",", "0.8164965809277261`", ",", 
   "0.816496580927726`", ",", "0.8164965809277261`", ",", 
   "0.8164965809277258`", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "0", ",", "0"}], "}"}]], "Output",
 CellLabel->"Out[10]= ",
 CellTags->"S5.12.1"]
}, Open  ]],

Cell["\<\
The inverse of the Fourier coefficients gives the original periodic function. \
\
\>", "MathCaption",
 CellTags->{"S5.12.1", "1.17"}],

Cell[CellGroupData[{

Cell["\<\
(nifc = Chop[Table[
{t, NInverseFourierCoefficient[If[-2 <= n <= 2, 0.816497, 0],
        n, t, FourierParameters -> {0, 3/2}]},
        {t, -1, 1, 1/30}]];
ListPlot[nifc, PlotJoined->True])\
\>", "Input",
 CellLabel->"In[11]:= ",
 CellTags->"S5.12.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.47619 0.131384 0.094387 [
[.02381 .11888 -6 -9 ]
[.02381 .11888 6 0 ]
[.2619 .11888 -12 -9 ]
[.2619 .11888 12 0 ]
[.7381 .11888 -9 -9 ]
[.7381 .11888 9 0 ]
[.97619 .11888 -3 -9 ]
[.97619 .11888 3 0 ]
[.4875 .037 -12 -4.5 ]
[.4875 .037 0 4.5 ]
[.4875 .22577 -6 -4.5 ]
[.4875 .22577 0 4.5 ]
[.4875 .32016 -6 -4.5 ]
[.4875 .32016 0 4.5 ]
[.4875 .41454 -6 -4.5 ]
[.4875 .41454 0 4.5 ]
[.4875 .50893 -6 -4.5 ]
[.4875 .50893 0 4.5 ]
[.4875 .60332 -6 -4.5 ]
[.4875 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .13138 m
.02381 .13763 L
s
[(-1)] .02381 .11888 0 1 Mshowa
.2619 .13138 m
.2619 .13763 L
s
[(-0.5)] .2619 .11888 0 1 Mshowa
.7381 .13138 m
.7381 .13763 L
s
[(0.5)] .7381 .11888 0 1 Mshowa
.97619 .13138 m
.97619 .13763 L
s
[(1)] .97619 .11888 0 1 Mshowa
.125 Mabswid
.07143 .13138 m
.07143 .13513 L
s
.11905 .13138 m
.11905 .13513 L
s
.16667 .13138 m
.16667 .13513 L
s
.21429 .13138 m
.21429 .13513 L
s
.30952 .13138 m
.30952 .13513 L
s
.35714 .13138 m
.35714 .13513 L
s
.40476 .13138 m
.40476 .13513 L
s
.45238 .13138 m
.45238 .13513 L
s
.54762 .13138 m
.54762 .13513 L
s
.59524 .13138 m
.59524 .13513 L
s
.64286 .13138 m
.64286 .13513 L
s
.69048 .13138 m
.69048 .13513 L
s
.78571 .13138 m
.78571 .13513 L
s
.83333 .13138 m
.83333 .13513 L
s
.88095 .13138 m
.88095 .13513 L
s
.92857 .13138 m
.92857 .13513 L
s
.25 Mabswid
0 .13138 m
1 .13138 L
s
.5 .037 m
.50625 .037 L
s
[(-1)] .4875 .037 1 0 Mshowa
.5 .22577 m
.50625 .22577 L
s
[(1)] .4875 .22577 1 0 Mshowa
.5 .32016 m
.50625 .32016 L
s
[(2)] .4875 .32016 1 0 Mshowa
.5 .41454 m
.50625 .41454 L
s
[(3)] .4875 .41454 1 0 Mshowa
.5 .50893 m
.50625 .50893 L
s
[(4)] .4875 .50893 1 0 Mshowa
.5 .60332 m
.50625 .60332 L
s
[(5)] .4875 .60332 1 0 Mshowa
.125 Mabswid
.5 .05587 m
.50375 .05587 L
s
.5 .07475 m
.50375 .07475 L
s
.5 .09363 m
.50375 .09363 L
s
.5 .11251 m
.50375 .11251 L
s
.5 .15026 m
.50375 .15026 L
s
.5 .16914 m
.50375 .16914 L
s
.5 .18802 m
.50375 .18802 L
s
.5 .20689 m
.50375 .20689 L
s
.5 .24465 m
.50375 .24465 L
s
.5 .26353 m
.50375 .26353 L
s
.5 .2824 m
.50375 .2824 L
s
.5 .30128 m
.50375 .30128 L
s
.5 .33904 m
.50375 .33904 L
s
.5 .35791 m
.50375 .35791 L
s
.5 .37679 m
.50375 .37679 L
s
.5 .39567 m
.50375 .39567 L
s
.5 .43342 m
.50375 .43342 L
s
.5 .4523 m
.50375 .4523 L
s
.5 .47118 m
.50375 .47118 L
s
.5 .49005 m
.50375 .49005 L
s
.5 .52781 m
.50375 .52781 L
s
.5 .54669 m
.50375 .54669 L
s
.5 .56556 m
.50375 .56556 L
s
.5 .58444 m
.50375 .58444 L
s
.5 .01812 m
.50375 .01812 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .22577 m
.03968 .19896 L
.05556 .13138 L
.07143 .05648 L
.0873 .01472 L
.10317 .037 L
.11905 .13138 L
.13492 .2784 L
.15079 .43683 L
.16667 .55803 L
.18254 .60332 L
.19841 .55803 L
.21429 .43683 L
.23016 .2784 L
.24603 .13138 L
.2619 .037 L
.27778 .01472 L
.29365 .05648 L
.30952 .13138 L
.3254 .19896 L
.34127 .22577 L
.35714 .19896 L
.37302 .13138 L
.38889 .05648 L
.40476 .01472 L
.42063 .037 L
.43651 .13138 L
.45238 .2784 L
.46825 .43683 L
.48413 .55803 L
.5 .60332 L
.51587 .55803 L
.53175 .43683 L
.54762 .2784 L
.56349 .13138 L
.57937 .037 L
.59524 .01472 L
.61111 .05648 L
.62698 .13138 L
.64286 .19896 L
.65873 .22577 L
.6746 .19896 L
.69048 .13138 L
.70635 .05648 L
.72222 .01472 L
.7381 .037 L
.75397 .13138 L
.76984 .2784 L
.78571 .43683 L
.80159 .55803 L
Mistroke
.81746 .60332 L
.83333 .55803 L
.84921 .43683 L
.86508 .2784 L
.88095 .13138 L
.89683 .037 L
.9127 .01472 L
.92857 .05648 L
.94444 .13138 L
.96032 .19896 L
.97619 .22577 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.12.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[11]= ",
 CellTags->"S5.12.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["setting", "SO10",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Fourier coefficient", "SO10",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["inverse Fourier coefficient", "SO10",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["{0,", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["1}", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         SubsuperscriptBox["\[Integral]", 
          RowBox[{
           RowBox[{"-", "1"}], "/", "2"}], 
          RowBox[{"1", "/", "2"}]], 
         StyleBox["f",
          "TI"], 
         RowBox[{"(", 
          StyleBox["t",
           "TI"], ")"}], " ", 
         SuperscriptBox[
          StyleBox["e",
           "TI"], 
          RowBox[{"2", "\[Pi]", 
           StyleBox["i",
            "TI"], 
           StyleBox["n",
            "TI"], 
           StyleBox["t",
            "TI"]}]], "\[DifferentialD]", 
         StyleBox["t",
          "TI"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         UnderoverscriptBox["\[Sum]", 
          RowBox[{
           StyleBox["n",
            "TI"], "=", "-", "\[Infinity]"}], "\[Infinity]",
          LimitsPositioning->True], 
         SubscriptBox[
          StyleBox["F",
           "TI"], 
          StyleBox["n",
           "TI"]], " ", 
         SuperscriptBox[
          StyleBox["e",
           "TI"], 
          RowBox[{
           RowBox[{"-", "2"}], "\[Pi]", 
           StyleBox["i",
            "TI"], 
           StyleBox["n",
            "TI"], 
           StyleBox["t",
            "TI"]}]]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["{", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["a", "TI",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["b", "TI",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["}", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"\[LeftBracketingBar]", 
           StyleBox["b",
            "TI"], "\[RightBracketingBar]"}], 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", 
             StyleBox["a",
              "TI"]}], ")"}], "/", "2"}]], 
         SubsuperscriptBox["\[Integral]", 
          RowBox[{
           RowBox[{"-", "1"}], "/", 
           RowBox[{"(", 
            RowBox[{"2", "\[LeftBracketingBar]", 
             StyleBox["b",
              "TI"], "\[RightBracketingBar]"}], ")"}]}], 
          RowBox[{"1", "/", 
           RowBox[{"(", 
            RowBox[{"2", "\[LeftBracketingBar]", 
             StyleBox["b",
              "TI"], "\[RightBracketingBar]"}], ")"}]}]], 
         StyleBox["f",
          "TI"], 
         RowBox[{"(", 
          StyleBox["t",
           "TI"], ")"}], " ", 
         SuperscriptBox[
          StyleBox["e",
           "TI"], 
          RowBox[{"2", "\[Pi]", 
           StyleBox["i",
            "TI"], 
           StyleBox["b",
            "TI"], 
           StyleBox["n",
            "TI"], 
           StyleBox["t",
            "TI"]}]], "\[DifferentialD]", 
         StyleBox["t",
          "TI"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"\[LeftBracketingBar]", 
           StyleBox["b",
            "TI"], "\[RightBracketingBar]"}], 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", 
             StyleBox["a",
              "TI"]}], ")"}], "/", "2"}]], 
         UnderoverscriptBox["\[Sum]", 
          RowBox[{
           StyleBox["n",
            "TI"], "=", "-", "\[Infinity]"}], "\[Infinity]",
          LimitsPositioning->True], 
         SubscriptBox[
          StyleBox["F",
           "TI"], 
          StyleBox["n",
           "TI"]], " ", 
         SuperscriptBox[
          StyleBox["e",
           "TI"], 
          RowBox[{
           RowBox[{"-", "2"}], "\[Pi]", 
           StyleBox["i",
            "TI"], 
           StyleBox["b",
            "TI"], 
           StyleBox["n",
            "TI"], 
           StyleBox["t",
            "TI"]}]]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
 GridBoxOptions->{RowLines->{True, False},
 RowSpacings->0.4},
 CellTags->"S5.12.1"],

Cell[TextData[{
 "Effect of ",
 StyleBox["FourierParameters", "MR"],
 " setting on Fourier coefficient."
}], "Caption",
 CellTags->"S5.12.1"],

Cell[TextData[{
 "The Fourier transform from the discrete time domain into the continuous \
frequency domain is usually termed the discrete\[Hyphen]time Fourier \
transform, or ",
 StyleBox["DTFourierTransform", "MR"],
 ". The inverse transform from the continuous frequency domain into the \
discrete time domain is given by ",
 StyleBox["InverseDTFourierTransform", "MR"],
 ". Just as the Z transform is the discrete analog of the Laplace transform, \
the discrete\[Hyphen]time Fourier transform is the discrete analog of the \
continuous\[Hyphen]time Fourier transform. If the option setting ",
 StyleBox["FourierParameters -> {", "MR"],
 StyleBox["a", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["b", "TI"],
 StyleBox["}", "MR"],
 " is specified, the period of the discrete\[Hyphen]time Fourier transform is \
taken to be ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "/", "\[LeftBracketingBar]", 
    StyleBox["b",
     "TI"], "\[RightBracketingBar]"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", instead of the default period of ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "Text",
 CellTags->{"S5.12.1", "1.18"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["DTFourierTransform[", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["omega", "TI",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["F",
          "TI"], 
         RowBox[{"(", "\[Omega]", ")"}]}], TraditionalForm]], "InlineFormula",
       
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[", a periodic function of ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["\[Omega]", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[", equal to the Fourier sum of ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[", where ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[" is treated as a function of integer ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["n",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["InverseDTFourierTransform[", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["omega", "TI",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["f",
          "TI"], 
         StyleBox["n",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[", a function of integer ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["n",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[" and the inverse Fourier sum of the periodic function ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["F",
          "TI"], 
         RowBox[{"(", "\[Omega]", ")"}]}], TraditionalForm]], "InlineFormula",
       
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[", where ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["F",
          "TI"], 
         RowBox[{"(", "\[Omega]", ")"}]}], TraditionalForm]], "InlineFormula",
       
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[" is equal to ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[" on the interval ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"\[Omega]", "=", 
         FractionBox[
          RowBox[{"-", "1"}], "2"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[" to ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"\[Omega]", "=", 
         FractionBox["1", "2"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["NDTFourierTransform[", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["omega", "TI",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["find a numerical approximation to the function ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["F",
          "TI"], 
         RowBox[{"(", "\[Omega]", ")"}]}], TraditionalForm]], "InlineFormula",
       
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["NInverseDTFourierTransform[", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["omega", "TI",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["find a numerical approximation to the function ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["f",
          "TI"], 
         StyleBox["n",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, True, False},
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->{False, True, False},
 RowSpacings->0.4},
 CellTags->"S5.12.1"],

Cell["\<\
Discrete\[Hyphen]time and continuous\[Hyphen]frequency transform pairs: exact \
and numerical approximations. \
\>", "Caption",
 CellTags->"S5.12.1"],

Cell[TextData[{
 "This computes the Fourier transform of a discrete\[Hyphen]time rectangular \
function centered at ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["n",
     "TI"], "=", "0"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.12.1", "1.19"}],

Cell[CellGroupData[{

Cell["\<\
dtft = DTFourierTransform[
        Sum[DiscreteDelta[n+j], {j, -1, 1}],
         n, \[Omega]]\
\>", "Input",
 CellLabel->"In[12]:= ",
 CellTags->"S5.12.1"],

Cell[BoxData[
 RowBox[{"1", "+", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
    "\[Omega]"}]], "+", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
   "2", " ", "\[ImaginaryI]", " ", "\[Pi]", " ", "\[Omega]"}]]}]], "Output",
 CellLabel->"Out[12]= ",
 CellTags->"S5.12.1"]
}, Open  ]],

Cell["\<\
Here is a plot of the amplitude spectrum over three periods. \
\>", "MathCaption",
 CellTags->{"S5.12.1", "1.20"}],

Cell[CellGroupData[{

Cell["\<\
Plot[Abs[dtft], {\[Omega], -1.5, 1.5}]\
\>", "Input",
 CellLabel->"In[13]:= ",
 CellTags->"S5.12.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.31746 0.0147151 0.196201 [
[.02381 .00222 -12 -9 ]
[.02381 .00222 12 0 ]
[.18254 .00222 -6 -9 ]
[.18254 .00222 6 0 ]
[.34127 .00222 -12 -9 ]
[.34127 .00222 12 0 ]
[.65873 .00222 -9 -9 ]
[.65873 .00222 9 0 ]
[.81746 .00222 -3 -9 ]
[.81746 .00222 3 0 ]
[.97619 .00222 -9 -9 ]
[.97619 .00222 9 0 ]
[.4875 .11282 -18 -4.5 ]
[.4875 .11282 0 4.5 ]
[.4875 .21092 -6 -4.5 ]
[.4875 .21092 0 4.5 ]
[.4875 .30902 -18 -4.5 ]
[.4875 .30902 0 4.5 ]
[.4875 .40712 -6 -4.5 ]
[.4875 .40712 0 4.5 ]
[.4875 .50522 -18 -4.5 ]
[.4875 .50522 0 4.5 ]
[.4875 .60332 -6 -4.5 ]
[.4875 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .01472 m
.02381 .02097 L
s
[(-1.5)] .02381 .00222 0 1 Mshowa
.18254 .01472 m
.18254 .02097 L
s
[(-1)] .18254 .00222 0 1 Mshowa
.34127 .01472 m
.34127 .02097 L
s
[(-0.5)] .34127 .00222 0 1 Mshowa
.65873 .01472 m
.65873 .02097 L
s
[(0.5)] .65873 .00222 0 1 Mshowa
.81746 .01472 m
.81746 .02097 L
s
[(1)] .81746 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(1.5)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.05556 .01472 m
.05556 .01847 L
s
.0873 .01472 m
.0873 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.15079 .01472 m
.15079 .01847 L
s
.21429 .01472 m
.21429 .01847 L
s
.24603 .01472 m
.24603 .01847 L
s
.27778 .01472 m
.27778 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.37302 .01472 m
.37302 .01847 L
s
.40476 .01472 m
.40476 .01847 L
s
.43651 .01472 m
.43651 .01847 L
s
.46825 .01472 m
.46825 .01847 L
s
.53175 .01472 m
.53175 .01847 L
s
.56349 .01472 m
.56349 .01847 L
s
.59524 .01472 m
.59524 .01847 L
s
.62698 .01472 m
.62698 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.72222 .01472 m
.72222 .01847 L
s
.75397 .01472 m
.75397 .01847 L
s
.78571 .01472 m
.78571 .01847 L
s
.84921 .01472 m
.84921 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.9127 .01472 m
.9127 .01847 L
s
.94444 .01472 m
.94444 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.5 .11282 m
.50625 .11282 L
s
[(0.5)] .4875 .11282 1 0 Mshowa
.5 .21092 m
.50625 .21092 L
s
[(1)] .4875 .21092 1 0 Mshowa
.5 .30902 m
.50625 .30902 L
s
[(1.5)] .4875 .30902 1 0 Mshowa
.5 .40712 m
.50625 .40712 L
s
[(2)] .4875 .40712 1 0 Mshowa
.5 .50522 m
.50625 .50522 L
s
[(2.5)] .4875 .50522 1 0 Mshowa
.5 .60332 m
.50625 .60332 L
s
[(3)] .4875 .60332 1 0 Mshowa
.125 Mabswid
.5 .03434 m
.50375 .03434 L
s
.5 .05396 m
.50375 .05396 L
s
.5 .07358 m
.50375 .07358 L
s
.5 .0932 m
.50375 .0932 L
s
.5 .13244 m
.50375 .13244 L
s
.5 .15206 m
.50375 .15206 L
s
.5 .17168 m
.50375 .17168 L
s
.5 .1913 m
.50375 .1913 L
s
.5 .23054 m
.50375 .23054 L
s
.5 .25016 m
.50375 .25016 L
s
.5 .26978 m
.50375 .26978 L
s
.5 .2894 m
.50375 .2894 L
s
.5 .32864 m
.50375 .32864 L
s
.5 .34826 m
.50375 .34826 L
s
.5 .36788 m
.50375 .36788 L
s
.5 .3875 m
.50375 .3875 L
s
.5 .42674 m
.50375 .42674 L
s
.5 .44636 m
.50375 .44636 L
s
.5 .46598 m
.50375 .46598 L
s
.5 .4856 m
.50375 .4856 L
s
.5 .52484 m
.50375 .52484 L
s
.5 .54446 m
.50375 .54446 L
s
.5 .56408 m
.50375 .56408 L
s
.5 .5837 m
.50375 .5837 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .21092 m
.02499 .21081 L
.02605 .21053 L
.02729 .20999 L
.02846 .20926 L
.03053 .20745 L
.03279 .20474 L
.03527 .20087 L
.0379 .19576 L
.04262 .18404 L
.05205 .15119 L
.06244 .10168 L
.06782 .07124 L
.07293 .03966 L
.07429 .03084 L
.07574 .02126 L
.07658 .01568 L
.07733 .01886 L
.0781 .02404 L
.07881 .02896 L
.0842 .06699 L
.10458 .22183 L
.12296 .36067 L
.13339 .43185 L
.14313 .48988 L
.15356 .54052 L
.16307 .57454 L
.16829 .58782 L
.17069 .59257 L
.17324 .59668 L
.17452 .59839 L
.17595 .59998 L
.17726 .60118 L
.17846 .60204 L
.17913 .60243 L
.17986 .60277 L
.1806 .60303 L
.18138 .60322 L
.18207 .6033 L
.18281 .60331 L
.1835 .60325 L
.18413 .60312 L
.18533 .60272 L
.18644 .60215 L
.18767 .6013 L
.18898 .60013 L
.19166 .59694 L
.19412 .59307 L
.19884 .58308 L
.20332 .5706 L
Mistroke
.21327 .53295 L
.22412 .4778 L
.24547 .33629 L
.26481 .18834 L
.27452 .11397 L
.27962 .07614 L
.2824 .05604 L
.285 .03772 L
.28617 .0296 L
.28728 .02201 L
.28856 .01606 L
.28972 .02382 L
.2949 .05694 L
.304 .10889 L
.31367 .15383 L
.31898 .17333 L
.32394 .18807 L
.32817 .19779 L
.33034 .20177 L
.33271 .2053 L
.33517 .20806 L
.33651 .20918 L
.33776 .20997 L
.33893 .2105 L
.33999 .21079 L
.34122 .21092 L
.34238 .21082 L
.34354 .21052 L
.34478 .20997 L
.34595 .20923 L
.34702 .20838 L
.34964 .20554 L
.35212 .2019 L
.35706 .19191 L
.36243 .177 L
.37202 .14047 L
.3809 .0963 L
.38552 .06981 L
.38795 .05504 L
.39051 .03888 L
.39275 .02422 L
.39403 .01573 L
.39522 .02172 L
.39954 .05178 L
.42013 .20699 L
.43884 .34928 L
.45914 .48186 L
.47023 .53716 L
.4751 .55663 L
.48046 .57435 L
Mistroke
.48551 .5873 L
.48794 .59219 L
.49024 .59603 L
.49285 .5994 L
.49401 .60056 L
.49524 .60158 L
.49594 .60205 L
.49657 .60242 L
.49781 .60295 L
.4985 .60315 L
.49925 .60328 L
.49996 .60332 L
.50061 .60329 L
.50187 .60305 L
.50307 .6026 L
.50414 .602 L
.50531 .60115 L
.50793 .59849 L
.51035 .59511 L
.51476 .58669 L
.51945 .57461 L
.52927 .53928 L
.54012 .486 L
.55948 .36142 L
.58034 .20336 L
.59073 .12339 L
.60039 .05227 L
.6029 .03465 L
.60413 .02616 L
.60527 .01843 L
.60658 .0198 L
.60727 .02437 L
.608 .02918 L
.61048 .04515 L
.6215 .10911 L
.63094 .15306 L
.63615 .17237 L
.64109 .18724 L
.64567 .19788 L
.64826 .20252 L
.65066 .20592 L
.65181 .20724 L
.65289 .20829 L
.65386 .2091 L
.6549 .20979 L
.65603 .21036 L
.65707 .2107 L
.65818 .21089 L
.65941 .21088 L
.66072 .21061 L
Mistroke
.66193 .21013 L
.66256 .20979 L
.66326 .20934 L
.66467 .20821 L
.66724 .20536 L
.66965 .20179 L
.67414 .19281 L
.67897 .17986 L
.6899 .13859 L
.6999 .08769 L
.70466 .05962 L
.70728 .04329 L
.70856 .03505 L
.70974 .02735 L
.71086 .01994 L
.71204 .01743 L
.71323 .0255 L
.71453 .03448 L
.71888 .06524 L
.7396 .22259 L
.76073 .38091 L
.78001 .50037 L
.78957 .54506 L
.79462 .5639 L
.79998 .58007 L
.80465 .59078 L
.80731 .59543 L
.80981 .59883 L
.81092 .60004 L
.81209 .60111 L
.81311 .60186 L
.81419 .6025 L
.81535 .60298 L
.81644 .60324 L
.81773 .60331 L
.81891 .60316 L
.8201 .60278 L
.82121 .60224 L
.82244 .60142 L
.82375 .60028 L
.82643 .59715 L
.82888 .59334 L
.8336 .58347 L
.83808 .57109 L
.84803 .53366 L
.85888 .47871 L
.88022 .33754 L
.89956 .18968 L
.90926 .11532 L
.91436 .07746 L
Mistroke
.91714 .05734 L
.91974 .03899 L
.92202 .02326 L
.9233 .01483 L
.92446 .0226 L
.92964 .0558 L
.93873 .10792 L
.94744 .14908 L
.95668 .18203 L
.9615 .19446 L
.96406 .19967 L
.96682 .20419 L
.96805 .20583 L
.96934 .20732 L
.97054 .20847 L
.97166 .20934 L
.9727 .20998 L
.97382 .21049 L
.97506 .21082 L
.97619 .21092 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.12.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[13]= ",
 CellTags->"S5.12.1"]
}, Open  ]],

Cell[TextData[{
 "Here is a numerical approximation to the inverse discrete\[Hyphen]time \
Fourier transform, for ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["n",
     "TI"], "=", 
    RowBox[{"-", "5"}], ",", "\[Ellipsis]", ",", "5"}], TraditionalForm]], 
  "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.12.1", "1.21"}],

Cell[CellGroupData[{

Cell["\<\
Chop[Table[
NInverseDTFourierTransform[dtft, \[Omega], n,
        AccuracyGoal->8, PrecisionGoal->8],
        {n, -5, 5}]]\
\>", "Input",
 CellLabel->"In[14]:= ",
 CellTags->"S5.12.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "0", ",", "0", ",", "0.9999999999999999`", ",", 
   "1.0000000000000002`", ",", "0.9999999999999999`", ",", "0", ",", "0", ",",
    "0", ",", "0"}], "}"}]], "Output",
 CellLabel->"Out[14]= ",
 CellTags->"S5.12.1"]
}, Open  ]],

Cell["\<\
The Fourier exponential series and discrete\[Hyphen]time Fourier transforms \
are mathematically equivalent, if one exchanges the roles of time and \
frequency. \
\>", "Text",
 CellTags->{"S5.12.1", "1.22"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["setting", "SO10",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["discrete-time Fourier transform", "SO10",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["inverse discrete-time Fourier coefficient", "SO10",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["{0,", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["1}", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         UnderoverscriptBox["\[Sum]", 
          RowBox[{
           StyleBox["n",
            "TI"], "=", "-", "\[Infinity]"}], "\[Infinity]",
          LimitsPositioning->True], 
         SubscriptBox[
          StyleBox["f",
           "TI"], 
          StyleBox["n",
           "TI"]], " ", 
         SuperscriptBox[
          StyleBox["e",
           "TI"], 
          RowBox[{"2", "\[Pi]", 
           StyleBox["i",
            "TI"], 
           StyleBox["n",
            "TI"], "\[Omega]"}]]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         SubsuperscriptBox["\[Integral]", 
          RowBox[{
           RowBox[{"-", "1"}], "/", "2"}], 
          RowBox[{"1", "/", "2"}]], 
         StyleBox["F",
          "TI"], 
         RowBox[{"(", "\[Omega]", ")"}], " ", 
         SuperscriptBox[
          StyleBox["e",
           "TI"], 
          RowBox[{
           RowBox[{"-", "2"}], "\[Pi]", 
           StyleBox["i",
            "TI"], 
           StyleBox["n",
            "TI"], "\[Omega]"}]], "\[DifferentialD]", "\[Omega]"}], 
        TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["{", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["a", "TI",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["b", "TI",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["}", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"\[LeftBracketingBar]", 
           StyleBox["b",
            "TI"], "\[RightBracketingBar]"}], 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", 
             StyleBox["a",
              "TI"]}], ")"}], "/", "2"}]], 
         UnderoverscriptBox["\[Sum]", 
          RowBox[{
           StyleBox["n",
            "TI"], "=", "-", "\[Infinity]"}], "\[Infinity]",
          LimitsPositioning->True], 
         SubscriptBox[
          StyleBox["f",
           "TI"], 
          StyleBox["n",
           "TI"]], " ", 
         SuperscriptBox[
          StyleBox["e",
           "TI"], 
          RowBox[{"2", "\[Pi]", 
           StyleBox["i",
            "TI"], 
           StyleBox["b",
            "TI"], 
           StyleBox["n",
            "TI"], "\[Omega]"}]]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"\[LeftBracketingBar]", 
           StyleBox["b",
            "TI"], "\[RightBracketingBar]"}], 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", 
             StyleBox["a",
              "TI"]}], ")"}], "/", "2"}]], 
         SubsuperscriptBox["\[Integral]", 
          RowBox[{
           RowBox[{"-", "1"}], "/", 
           RowBox[{"(", 
            RowBox[{"2", "\[LeftBracketingBar]", 
             StyleBox["b",
              "TI"], "\[RightBracketingBar]"}], ")"}]}], 
          RowBox[{"1", "/", 
           RowBox[{"(", 
            RowBox[{"2", "\[LeftBracketingBar]", 
             StyleBox["b",
              "TI"], "\[RightBracketingBar]"}], ")"}]}]], 
         StyleBox["F",
          "TI"], 
         RowBox[{"(", "\[Omega]", ")"}], " ", 
         SuperscriptBox[
          StyleBox["e",
           "TI"], 
          RowBox[{
           RowBox[{"-", "2"}], "\[Pi]", 
           StyleBox["i",
            "TI"], 
           StyleBox["b",
            "TI"], 
           StyleBox["n",
            "TI"], "\[Omega]"}]], "\[DifferentialD]", "\[Omega]"}], 
        TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
 GridBoxOptions->{RowLines->{True, False},
 RowSpacings->0.4},
 CellTags->"S5.12.1"],

Cell[TextData[{
 "Effect of ",
 StyleBox["FourierParameters", "MR"],
 " setting on discrete\[Hyphen]time Fourier transform."
}], "Caption",
 CellTags->"S5.12.1"]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.12.1"->{
    Cell[1776, 53, 141, 6, 36, "Subsection",
      CellTags->{"S5.12.1", "1.1"}],
    Cell[1920, 61, 1058, 25, 152, "Text",
      CellTags->{"S5.12.1", "1.2"}],
    Cell[2981, 88, 13648, 403, 366, "DefinitionBox",
      CellTags->"S5.12.1"],
    Cell[16632, 493, 97, 1, 15, "Caption",
      CellTags->"S5.12.1"],
    Cell[16732, 496, 78, 1, 38, "MathCaption",
      CellTags->{"S5.12.1", "1.3"}],
    Cell[16813, 499, 91, 2, 28, "Input",
      CellTags->"S5.12.1"],
    Cell[16907, 503, 816, 27, 70, "MathCaption",
      CellTags->{"S5.12.1", "1.4"}],
    Cell[17748, 534, 110, 2, 70, "Input",
      CellTags->"S5.12.1"],
    Cell[17861, 538, 185, 5, 70, "Output",
      CellTags->"S5.12.1"],
    Cell[18061, 546, 347, 8, 70, "Text",
      CellTags->{"S5.12.1", "1.5"}],
    Cell[18411, 556, 7977, 245, 70, "DefinitionBox3Col",
      CellTags->"S5.12.1"],
    Cell[26391, 803, 139, 5, 70, "Caption",
      CellTags->"S5.12.1"],
    Cell[26533, 810, 6275, 192, 70, "DefinitionBox3Col",
      CellTags->"S5.12.1"],
    Cell[32811, 1004, 144, 5, 70, "Caption",
      CellTags->"S5.12.1"],
    Cell[32958, 1011, 6279, 192, 70, "DefinitionBox3Col",
      CellTags->"S5.12.1"],
    Cell[39240, 1205, 146, 5, 70, "Caption",
      CellTags->"S5.12.1"],
    Cell[39389, 1212, 1699, 43, 70, "Text",
      CellTags->{"S5.12.1", "1.6"}],
    Cell[41091, 1257, 10971, 286, 70, "DefinitionBox",
      CellTags->"S5.12.1"],
    Cell[52065, 1545, 84, 1, 70, "Caption",
      CellTags->"S5.12.1"],
    Cell[52152, 1548, 783, 26, 70, "MathCaption",
      CellTags->{"S5.12.1", "1.7"}],
    Cell[52960, 1578, 106, 2, 70, "Input",
      CellTags->"S5.12.1"],
    Cell[53069, 1582, 3889, 278, 70, 3818, 275, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.12.1"],
    Cell[56961, 1862, 180, 6, 70, "Output",
      CellTags->"S5.12.1"],
    Cell[57156, 1871, 229, 5, 70, "MathCaption",
      CellTags->{"S5.12.1", "1.8"}],
    Cell[57410, 1880, 89, 2, 70, "Input",
      CellTags->"S5.12.1"],
    Cell[57502, 1884, 439, 14, 70, "Output",
      CellTags->"S5.12.1"],
    Cell[57956, 1901, 131, 3, 70, "MathCaption",
      CellTags->{"S5.12.1", "1.9"}],
    Cell[58112, 1908, 86, 2, 70, "Input",
      CellTags->"S5.12.1"],
    Cell[58201, 1912, 9031, 604, 70, 8960, 601, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.12.1"],
    Cell[67235, 2518, 180, 6, 70, "Output",
      CellTags->"S5.12.1"],
    Cell[67430, 2527, 96, 1, 70, "MathCaption",
      CellTags->{"S5.12.1", "1.10"}],
    Cell[67551, 2532, 78, 2, 70, "Input",
      CellTags->"S5.12.1"],
    Cell[67632, 2536, 9790, 655, 70, 9719, 652, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.12.1"],
    Cell[77425, 3193, 180, 6, 70, "Output",
      CellTags->"S5.12.1"],
    Cell[77620, 3202, 4637, 148, 70, "DefinitionBox",
      CellTags->"S5.12.1"],
    Cell[82260, 3352, 154, 5, 70, "Caption",
      CellTags->"S5.12.1"],
    Cell[82417, 3359, 4472, 148, 70, "DefinitionBox3Col",
      CellTags->"S5.12.1"],
    Cell[86892, 3509, 148, 5, 70, "Caption",
      CellTags->"S5.12.1"],
    Cell[87043, 3516, 7218, 224, 70, "DefinitionBox3Col",
      CellTags->"S5.12.1"],
    Cell[94264, 3742, 149, 5, 70, "Caption",
      CellTags->"S5.12.1"],
    Cell[94416, 3749, 4683, 147, 70, "DefinitionBox",
      CellTags->"S5.12.1"],
    Cell[99102, 3898, 147, 5, 70, "Caption",
      CellTags->"S5.12.1"],
    Cell[99252, 3905, 5024, 166, 70, "DefinitionBox",
      CellTags->"S5.12.1"],
    Cell[104279, 4073, 150, 5, 70, "Caption",
      CellTags->"S5.12.1"],
    Cell[104432, 4080, 414, 8, 70, "Text",
      CellTags->{"S5.12.1", "1.11"}],
    Cell[104849, 4090, 8738, 221, 70, "DefinitionBox",
      CellTags->"S5.12.1"],
    Cell[113590, 4313, 123, 3, 70, "Caption",
      CellTags->"S5.12.1"],
    Cell[113716, 4318, 961, 32, 70, "MathCaption",
      CellTags->{"S5.12.1", "1.12"}],
    Cell[114702, 4354, 106, 2, 70, "Input",
      CellTags->"S5.12.1"],
    Cell[114811, 4358, 873, 22, 70, "Output",
      CellTags->"S5.12.1"],
    Cell[115699, 4383, 130, 3, 70, "MathCaption",
      CellTags->{"S5.12.1", "1.13"}],
    Cell[115854, 4390, 86, 2, 70, "Input",
      CellTags->"S5.12.1"],
    Cell[115943, 4394, 8609, 590, 70, 8538, 587, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.12.1"],
    Cell[124555, 4986, 180, 6, 70, "Output",
      CellTags->"S5.12.1"],
    Cell[124750, 4995, 1333, 34, 70, "Text",
      CellTags->{"S5.12.1", "1.14"}],
    Cell[126086, 5031, 10064, 282, 70, "DefinitionBox",
      CellTags->"S5.12.1"],
    Cell[136153, 5315, 159, 4, 70, "Caption",
      CellTags->"S5.12.1"],
    Cell[136315, 5321, 412, 14, 70, "MathCaption",
      CellTags->{"S5.12.1", "1.15"}],
    Cell[136752, 5339, 131, 5, 70, "Input",
      CellTags->"S5.12.1"],
    Cell[136886, 5346, 7501, 515, 70, 7430, 512, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.12.1"],
    Cell[144390, 5863, 180, 6, 70, "Output",
      CellTags->"S5.12.1"],
    Cell[144585, 5872, 176, 5, 70, "MathCaption",
      CellTags->{"S5.12.1", "1.16"}],
    Cell[144786, 5881, 218, 8, 70, "Input",
      CellTags->"S5.12.1"],
    Cell[145007, 5891, 418, 9, 70, "Output",
      CellTags->"S5.12.1"],
    Cell[145440, 5903, 143, 4, 70, "MathCaption",
      CellTags->{"S5.12.1", "1.17"}],
    Cell[145608, 5911, 262, 8, 70, "Input",
      CellTags->"S5.12.1"],
    Cell[145873, 5921, 4115, 299, 70, 4044, 296, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.12.1"],
    Cell[149991, 6222, 181, 6, 70, "Output",
      CellTags->"S5.12.1"],
    Cell[150187, 6231, 7253, 234, 70, "DefinitionBox3Col",
      CellTags->"S5.12.1"],
    Cell[157443, 6467, 141, 5, 70, "Caption",
      CellTags->"S5.12.1"],
    Cell[157587, 6474, 1237, 30, 70, "Text",
      CellTags->{"S5.12.1", "1.18"}],
    Cell[158827, 6506, 10207, 281, 70, "DefinitionBox",
      CellTags->"S5.12.1"],
    Cell[169037, 6789, 159, 4, 70, "Caption",
      CellTags->"S5.12.1"],
    Cell[169199, 6795, 337, 11, 70, "MathCaption",
      CellTags->{"S5.12.1", "1.19"}],
    Cell[169561, 6810, 165, 6, 70, "Input",
      CellTags->"S5.12.1"],
    Cell[169729, 6818, 346, 10, 70, "Output",
      CellTags->"S5.12.1"],
    Cell[170090, 6831, 124, 3, 70, "MathCaption",
      CellTags->{"S5.12.1", "1.20"}],
    Cell[170239, 6838, 110, 4, 70, "Input",
      CellTags->"S5.12.1"],
    Cell[170352, 6844, 7144, 494, 70, 7073, 491, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.12.1"],
    Cell[177499, 7340, 181, 6, 70, "Output",
      CellTags->"S5.12.1"],
    Cell[177695, 7349, 388, 13, 70, "MathCaption",
      CellTags->{"S5.12.1", "1.21"}],
    Cell[178108, 7366, 194, 7, 70, "Input",
      CellTags->"S5.12.1"],
    Cell[178305, 7375, 275, 7, 70, "Output",
      CellTags->"S5.12.1"],
    Cell[178595, 7385, 217, 5, 70, "Text",
      CellTags->{"S5.12.1", "1.22"}],
    Cell[178815, 7392, 7045, 220, 70, "DefinitionBox3Col",
      CellTags->"S5.12.1"],
    Cell[185863, 7614, 161, 5, 70, "Caption",
      CellTags->"S5.12.1"]},
  "1.1"->{
    Cell[1776, 53, 141, 6, 36, "Subsection",
      CellTags->{"S5.12.1", "1.1"}]},
  "1.2"->{
    Cell[1920, 61, 1058, 25, 152, "Text",
      CellTags->{"S5.12.1", "1.2"}]},
  "1.3"->{
    Cell[16732, 496, 78, 1, 38, "MathCaption",
      CellTags->{"S5.12.1", "1.3"}]},
  "1.4"->{
    Cell[16907, 503, 816, 27, 70, "MathCaption",
      CellTags->{"S5.12.1", "1.4"}]},
  "1.5"->{
    Cell[18061, 546, 347, 8, 70, "Text",
      CellTags->{"S5.12.1", "1.5"}]},
  "1.6"->{
    Cell[39389, 1212, 1699, 43, 70, "Text",
      CellTags->{"S5.12.1", "1.6"}]},
  "1.7"->{
    Cell[52152, 1548, 783, 26, 70, "MathCaption",
      CellTags->{"S5.12.1", "1.7"}]},
  "1.8"->{
    Cell[57156, 1871, 229, 5, 70, "MathCaption",
      CellTags->{"S5.12.1", "1.8"}]},
  "1.9"->{
    Cell[57956, 1901, 131, 3, 70, "MathCaption",
      CellTags->{"S5.12.1", "1.9"}]},
  "1.10"->{
    Cell[67430, 2527, 96, 1, 70, "MathCaption",
      CellTags->{"S5.12.1", "1.10"}]},
  "1.11"->{
    Cell[104432, 4080, 414, 8, 70, "Text",
      CellTags->{"S5.12.1", "1.11"}]},
  "1.12"->{
    Cell[113716, 4318, 961, 32, 70, "MathCaption",
      CellTags->{"S5.12.1", "1.12"}]},
  "1.13"->{
    Cell[115699, 4383, 130, 3, 70, "MathCaption",
      CellTags->{"S5.12.1", "1.13"}]},
  "1.14"->{
    Cell[124750, 4995, 1333, 34, 70, "Text",
      CellTags->{"S5.12.1", "1.14"}]},
  "1.15"->{
    Cell[136315, 5321, 412, 14, 70, "MathCaption",
      CellTags->{"S5.12.1", "1.15"}]},
  "1.16"->{
    Cell[144585, 5872, 176, 5, 70, "MathCaption",
      CellTags->{"S5.12.1", "1.16"}]},
  "1.17"->{
    Cell[145440, 5903, 143, 4, 70, "MathCaption",
      CellTags->{"S5.12.1", "1.17"}]},
  "1.18"->{
    Cell[157587, 6474, 1237, 30, 70, "Text",
      CellTags->{"S5.12.1", "1.18"}]},
  "1.19"->{
    Cell[169199, 6795, 337, 11, 70, "MathCaption",
      CellTags->{"S5.12.1", "1.19"}]},
  "1.20"->{
    Cell[170090, 6831, 124, 3, 70, "MathCaption",
      CellTags->{"S5.12.1", "1.20"}]},
  "1.21"->{
    Cell[177695, 7349, 388, 13, 70, "MathCaption",
      CellTags->{"S5.12.1", "1.21"}]},
  "1.22"->{
    Cell[178595, 7385, 217, 5, 70, "Text",
      CellTags->{"S5.12.1", "1.22"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.12.1", 186663, 7638},
  {"1.1", 193922, 7825},
  {"1.2", 194016, 7828},
  {"1.3", 194107, 7831},
  {"1.4", 194203, 7834},
  {"1.5", 194301, 7837},
  {"1.6", 194391, 7840},
  {"1.7", 194484, 7843},
  {"1.8", 194583, 7846},
  {"1.9", 194681, 7849},
  {"1.10", 194780, 7852},
  {"1.11", 194879, 7855},
  {"1.12", 194973, 7858},
  {"1.13", 195075, 7861},
  {"1.14", 195176, 7864},
  {"1.15", 195272, 7867},
  {"1.16", 195374, 7870},
  {"1.17", 195475, 7873},
  {"1.18", 195576, 7876},
  {"1.19", 195672, 7879},
  {"1.20", 195774, 7882},
  {"1.21", 195875, 7885},
  {"1.22", 195977, 7888}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 141, 6, 36, "Subsection",
  CellTags->{"S5.12.1", "1.1"}],
Cell[1920, 61, 1058, 25, 152, "Text",
  CellTags->{"S5.12.1", "1.2"}],
Cell[2981, 88, 13648, 403, 366, "DefinitionBox",
  CellTags->"S5.12.1"],
Cell[16632, 493, 97, 1, 15, "Caption",
  CellTags->"S5.12.1"],
Cell[16732, 496, 78, 1, 38, "MathCaption",
  CellTags->{"S5.12.1", "1.3"}],
Cell[16813, 499, 91, 2, 28, "Input",
  CellTags->"S5.12.1"],
Cell[16907, 503, 816, 27, 70, "MathCaption",
  CellTags->{"S5.12.1", "1.4"}],

Cell[CellGroupData[{
Cell[17748, 534, 110, 2, 70, "Input",
  CellTags->"S5.12.1"],
Cell[17861, 538, 185, 5, 70, "Output",
  CellTags->"S5.12.1"]
}, Open  ]],
Cell[18061, 546, 347, 8, 70, "Text",
  CellTags->{"S5.12.1", "1.5"}],
Cell[18411, 556, 7977, 245, 70, "DefinitionBox3Col",
  CellTags->"S5.12.1"],
Cell[26391, 803, 139, 5, 70, "Caption",
  CellTags->"S5.12.1"],
Cell[26533, 810, 6275, 192, 70, "DefinitionBox3Col",
  CellTags->"S5.12.1"],
Cell[32811, 1004, 144, 5, 70, "Caption",
  CellTags->"S5.12.1"],
Cell[32958, 1011, 6279, 192, 70, "DefinitionBox3Col",
  CellTags->"S5.12.1"],
Cell[39240, 1205, 146, 5, 70, "Caption",
  CellTags->"S5.12.1"],
Cell[39389, 1212, 1699, 43, 70, "Text",
  CellTags->{"S5.12.1", "1.6"}],
Cell[41091, 1257, 10971, 286, 70, "DefinitionBox",
  CellTags->"S5.12.1"],
Cell[52065, 1545, 84, 1, 70, "Caption",
  CellTags->"S5.12.1"],
Cell[52152, 1548, 783, 26, 70, "MathCaption",
  CellTags->{"S5.12.1", "1.7"}],

Cell[CellGroupData[{
Cell[52960, 1578, 106, 2, 70, "Input",
  CellTags->"S5.12.1"],
Cell[53069, 1582, 3889, 278, 70, 3818, 275, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.12.1"],
Cell[56961, 1862, 180, 6, 70, "Output",
  CellTags->"S5.12.1"]
}, Open  ]],
Cell[57156, 1871, 229, 5, 70, "MathCaption",
  CellTags->{"S5.12.1", "1.8"}],

Cell[CellGroupData[{
Cell[57410, 1880, 89, 2, 70, "Input",
  CellTags->"S5.12.1"],
Cell[57502, 1884, 439, 14, 70, "Output",
  CellTags->"S5.12.1"]
}, Open  ]],
Cell[57956, 1901, 131, 3, 70, "MathCaption",
  CellTags->{"S5.12.1", "1.9"}],

Cell[CellGroupData[{
Cell[58112, 1908, 86, 2, 70, "Input",
  CellTags->"S5.12.1"],
Cell[58201, 1912, 9031, 604, 70, 8960, 601, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.12.1"],
Cell[67235, 2518, 180, 6, 70, "Output",
  CellTags->"S5.12.1"]
}, Open  ]],
Cell[67430, 2527, 96, 1, 70, "MathCaption",
  CellTags->{"S5.12.1", "1.10"}],

Cell[CellGroupData[{
Cell[67551, 2532, 78, 2, 70, "Input",
  CellTags->"S5.12.1"],
Cell[67632, 2536, 9790, 655, 70, 9719, 652, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.12.1"],
Cell[77425, 3193, 180, 6, 70, "Output",
  CellTags->"S5.12.1"]
}, Open  ]],
Cell[77620, 3202, 4637, 148, 70, "DefinitionBox",
  CellTags->"S5.12.1"],
Cell[82260, 3352, 154, 5, 70, "Caption",
  CellTags->"S5.12.1"],
Cell[82417, 3359, 4472, 148, 70, "DefinitionBox3Col",
  CellTags->"S5.12.1"],
Cell[86892, 3509, 148, 5, 70, "Caption",
  CellTags->"S5.12.1"],
Cell[87043, 3516, 7218, 224, 70, "DefinitionBox3Col",
  CellTags->"S5.12.1"],
Cell[94264, 3742, 149, 5, 70, "Caption",
  CellTags->"S5.12.1"],
Cell[94416, 3749, 4683, 147, 70, "DefinitionBox",
  CellTags->"S5.12.1"],
Cell[99102, 3898, 147, 5, 70, "Caption",
  CellTags->"S5.12.1"],
Cell[99252, 3905, 5024, 166, 70, "DefinitionBox",
  CellTags->"S5.12.1"],
Cell[104279, 4073, 150, 5, 70, "Caption",
  CellTags->"S5.12.1"],
Cell[104432, 4080, 414, 8, 70, "Text",
  CellTags->{"S5.12.1", "1.11"}],
Cell[104849, 4090, 8738, 221, 70, "DefinitionBox",
  CellTags->"S5.12.1"],
Cell[113590, 4313, 123, 3, 70, "Caption",
  CellTags->"S5.12.1"],
Cell[113716, 4318, 961, 32, 70, "MathCaption",
  CellTags->{"S5.12.1", "1.12"}],

Cell[CellGroupData[{
Cell[114702, 4354, 106, 2, 70, "Input",
  CellTags->"S5.12.1"],
Cell[114811, 4358, 873, 22, 70, "Output",
  CellTags->"S5.12.1"]
}, Open  ]],
Cell[115699, 4383, 130, 3, 70, "MathCaption",
  CellTags->{"S5.12.1", "1.13"}],

Cell[CellGroupData[{
Cell[115854, 4390, 86, 2, 70, "Input",
  CellTags->"S5.12.1"],
Cell[115943, 4394, 8609, 590, 70, 8538, 587, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.12.1"],
Cell[124555, 4986, 180, 6, 70, "Output",
  CellTags->"S5.12.1"]
}, Open  ]],
Cell[124750, 4995, 1333, 34, 70, "Text",
  CellTags->{"S5.12.1", "1.14"}],
Cell[126086, 5031, 10064, 282, 70, "DefinitionBox",
  CellTags->"S5.12.1"],
Cell[136153, 5315, 159, 4, 70, "Caption",
  CellTags->"S5.12.1"],
Cell[136315, 5321, 412, 14, 70, "MathCaption",
  CellTags->{"S5.12.1", "1.15"}],

Cell[CellGroupData[{
Cell[136752, 5339, 131, 5, 70, "Input",
  CellTags->"S5.12.1"],
Cell[136886, 5346, 7501, 515, 70, 7430, 512, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.12.1"],
Cell[144390, 5863, 180, 6, 70, "Output",
  CellTags->"S5.12.1"]
}, Open  ]],
Cell[144585, 5872, 176, 5, 70, "MathCaption",
  CellTags->{"S5.12.1", "1.16"}],

Cell[CellGroupData[{
Cell[144786, 5881, 218, 8, 70, "Input",
  CellTags->"S5.12.1"],
Cell[145007, 5891, 418, 9, 70, "Output",
  CellTags->"S5.12.1"]
}, Open  ]],
Cell[145440, 5903, 143, 4, 70, "MathCaption",
  CellTags->{"S5.12.1", "1.17"}],

Cell[CellGroupData[{
Cell[145608, 5911, 262, 8, 70, "Input",
  CellTags->"S5.12.1"],
Cell[145873, 5921, 4115, 299, 70, 4044, 296, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.12.1"],
Cell[149991, 6222, 181, 6, 70, "Output",
  CellTags->"S5.12.1"]
}, Open  ]],
Cell[150187, 6231, 7253, 234, 70, "DefinitionBox3Col",
  CellTags->"S5.12.1"],
Cell[157443, 6467, 141, 5, 70, "Caption",
  CellTags->"S5.12.1"],
Cell[157587, 6474, 1237, 30, 70, "Text",
  CellTags->{"S5.12.1", "1.18"}],
Cell[158827, 6506, 10207, 281, 70, "DefinitionBox",
  CellTags->"S5.12.1"],
Cell[169037, 6789, 159, 4, 70, "Caption",
  CellTags->"S5.12.1"],
Cell[169199, 6795, 337, 11, 70, "MathCaption",
  CellTags->{"S5.12.1", "1.19"}],

Cell[CellGroupData[{
Cell[169561, 6810, 165, 6, 70, "Input",
  CellTags->"S5.12.1"],
Cell[169729, 6818, 346, 10, 70, "Output",
  CellTags->"S5.12.1"]
}, Open  ]],
Cell[170090, 6831, 124, 3, 70, "MathCaption",
  CellTags->{"S5.12.1", "1.20"}],

Cell[CellGroupData[{
Cell[170239, 6838, 110, 4, 70, "Input",
  CellTags->"S5.12.1"],
Cell[170352, 6844, 7144, 494, 70, 7073, 491, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.12.1"],
Cell[177499, 7340, 181, 6, 70, "Output",
  CellTags->"S5.12.1"]
}, Open  ]],
Cell[177695, 7349, 388, 13, 70, "MathCaption",
  CellTags->{"S5.12.1", "1.21"}],

Cell[CellGroupData[{
Cell[178108, 7366, 194, 7, 70, "Input",
  CellTags->"S5.12.1"],
Cell[178305, 7375, 275, 7, 70, "Output",
  CellTags->"S5.12.1"]
}, Open  ]],
Cell[178595, 7385, 217, 5, 70, "Text",
  CellTags->{"S5.12.1", "1.22"}],
Cell[178815, 7392, 7045, 220, 70, "DefinitionBox3Col",
  CellTags->"S5.12.1"],
Cell[185863, 7614, 161, 5, 70, "Caption",
  CellTags->"S5.12.1"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

