(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     11342,        407]*)
(*NotebookOutlinePosition[     15284,        530]*)
(*  CellTagsIndexPosition[     14908,        511]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "LinearAlgebra",
 StyleBox["`", "MB"],
 "FourierTrig",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.47.1", "1.1"}],

Cell["\<\
The discrete sine and cosine transforms are real variants of the discrete \
Fourier transform which are widely applicable from signal processing to the \
numerical solution of partial differential equations. \
\>", "Text",
 CellTags->{"S5.47.1", "1.2"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["FourierCos[{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["a",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["a",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] , ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["a",
          "TI"], 
         RowBox[{
          StyleBox["n",
           "TI"], "+", "1"}]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["discrete cosine transform",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["FourierSin[{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["a",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["a",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] , ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["a",
          "TI"], 
         RowBox[{
          StyleBox["n",
           "TI"], "+", "1"}]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["discrete sine transform",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.47.1"],

Cell["Discrete transforms. ", "Caption",
 CellTags->"S5.47.1"],

Cell[TextData[{
 "There are several different conventions used to define these. In ",
 StyleBox["Mathematica", "TI",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 ", the discrete cosine transform of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["b",
     "TI"], 
    StyleBox["s",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " of a list ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["a",
     "TI"], 
    StyleBox["r",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " of length ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["n",
     "TI"], "+", "1"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is taken to be "
}], "Text",
 CellTags->{"S5.47.1", "1.3"}],

Cell["", "Text",
 CellTags->{"S5.47.1", "1.4"}],

Cell[BoxData[
 FormBox[
  RowBox[{
   SqrtBox[
    FractionBox["2", 
     StyleBox["n",
      "TI"]]], 
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      SubscriptBox[
       StyleBox["a",
        "TI"], "1"], "2"], "+", 
     FractionBox["1", "2"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], 
      RowBox[{
       StyleBox["s",
        "TI"], "-", "1"}]], 
     SubscriptBox[
      StyleBox["a",
       "TI"], 
      RowBox[{
       StyleBox["n",
        "TI"], "+", "1"}]], "+", 
     UnderoverscriptBox["\[Sum]", 
      RowBox[{
       StyleBox["j",
        "TI"], "=", "2"}], 
      StyleBox["n",
       "TI"],
      LimitsPositioning->False], 
     FractionBox[
      RowBox[{"cos", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           StyleBox["j",
            "TI"], "-", "1"}], ")"}], 
         RowBox[{"(", 
          RowBox[{
           StyleBox["s",
            "TI"], "-", "1"}], ")"}], "\[Pi]"}], ")"}]}], 
      StyleBox["n",
       "TI"]], 
     SubscriptBox[
      StyleBox["a",
       "TI"], 
      StyleBox["j",
       "TI"]]}], ")"}]}], TraditionalForm]], "DisplayFormula",
 UnderoverscriptBoxOptions->{LimitsPositioning->True},
 GridBoxOptions->{ColumnWidths->Automatic},
 CellTags->{"S5.47.1", "1.5"}],

Cell[TextData[{
 "and the discrete sine transform of a list ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["a",
     "TI"], 
    StyleBox["r",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " of length ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["n",
     "TI"], "-", "1"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is taken to be "
}], "Text",
 CellTags->{"S5.47.1", "1.6"}],

Cell["", "Text",
 CellTags->{"S5.47.1", "1.7"}],

Cell[BoxData[
 FormBox[
  RowBox[{
   SqrtBox[
    FractionBox["2", 
     StyleBox["n",
      "TI"]]], 
   UnderoverscriptBox["\[Sum]", 
    RowBox[{
     StyleBox["j",
      "TI"], "=", "1"}], 
    RowBox[{
     StyleBox["n",
      "TI"], "-", "1"}],
    LimitsPositioning->False], "sin", 
   RowBox[{"(", 
    FractionBox[
     RowBox[{
      StyleBox["j",
       "TI"], 
      StyleBox["s",
       "TI"], "\[Pi]"}], 
     StyleBox["n",
      "TI"]], ")"}], 
   SubscriptBox[
    StyleBox["a",
     "TI"], 
    StyleBox["j",
     "TI"]], "."}], TraditionalForm]], "DisplayFormula",
 UnderoverscriptBoxOptions->{LimitsPositioning->True},
 GridBoxOptions->{ColumnWidths->Automatic},
 CellTags->{"S5.47.1", "1.8"}],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.47.1", "1.9"}],

Cell["<< LinearAlgebra`FourierTrig`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.47.1"],

Cell["Here is some example data. ", "MathCaption",
 CellTags->{"S5.47.1", "1.10"}],

Cell[CellGroupData[{

Cell["Table[1 - 2 Abs[x - .5], {x, .1, .9, .1}]", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.47.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.19999999999999996`", ",", "0.4`", ",", "0.6000000000000001`", ",", 
   "0.8`", ",", "1.`", ",", "0.7999999999999998`", ",", "0.5999999999999999`",
    ",", "0.3999999999999999`", ",", "0.19999999999999996`"}], 
  "}"}]], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.47.1"]
}, Open  ]],

Cell["Here is the discrete sine transform of the data. ", "MathCaption",
 CellTags->{"S5.47.1", "1.11"}],

Cell[CellGroupData[{

Cell["Chop[FourierSin[%]]", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.47.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.8274694061292347`", ",", "0", ",", 
   RowBox[{"-", "0.21698088095444054`"}], ",", "0", ",", 
   "0.08944271909999156`", ",", "0", ",", 
   RowBox[{"-", "0.056331748245458654`"}], ",", "0", ",", 
   "0.04584322307066426`"}], "}"}]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.47.1"]
}, Open  ]],

Cell["\<\
If this were the initial profile of, for example, a plucked string attached \
at both ends, this shows that only the odd modes (harmonics) are excited. \
\>", "Text",
 CellTags->{"S5.47.1", "1.12"}],

Cell[TextData[{
 StyleBox["Mathematica", "TI"],
 " has normalized the discrete sine and cosine transforms so that they are \
each their own inverses. "
}], "MathCaption",
 CellTags->{"S5.47.1", "1.13"}],

Cell[CellGroupData[{

Cell["FourierSin[%]", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.47.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.19999999999999993`", ",", "0.39999999999999986`", ",", "0.6`", ",", 
   "0.7999999999999997`", ",", "1.`", ",", "0.7999999999999997`", ",", "0.6`",
    ",", "0.39999999999999986`", ",", "0.19999999999999993`"}], 
  "}"}]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.47.1"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.47.1"->{
    Cell[1776, 53, 141, 6, 36, "Subsection",
      CellTags->{"S5.47.1", "1.1"}],
    Cell[1920, 61, 263, 5, 40, "Text",
      CellTags->{"S5.47.1", "1.2"}],
    Cell[2186, 68, 3476, 106, 102, "DefinitionBox",
      CellTags->"S5.47.1"],
    Cell[5665, 176, 62, 1, 15, "Caption",
      CellTags->"S5.47.1"],
    Cell[5730, 179, 845, 32, 40, "Text",
      CellTags->{"S5.47.1", "1.3"}],
    Cell[6578, 213, 47, 1, 24, "Text",
      CellTags->{"S5.47.1", "1.4"}],
    Cell[6628, 216, 1299, 54, 58, "DisplayFormula",
      CellTags->{"S5.47.1", "1.5"}],
    Cell[7930, 272, 490, 19, 24, "Text",
      CellTags->{"S5.47.1", "1.6"}],
    Cell[8423, 293, 47, 1, 24, "Text",
      CellTags->{"S5.47.1", "1.7"}],
    Cell[8473, 296, 713, 31, 66, "DisplayFormula",
      CellTags->{"S5.47.1", "1.8"}],
    Cell[9189, 329, 78, 1, 40, "MathCaption",
      CellTags->{"S5.47.1", "1.9"}],
    Cell[9270, 332, 92, 2, 28, "Input",
      CellTags->"S5.47.1"],
    Cell[9365, 336, 82, 1, 40, "MathCaption",
      CellTags->{"S5.47.1", "1.10"}],
    Cell[9472, 341, 104, 2, 28, "Input",
      CellTags->"S5.47.1"],
    Cell[9579, 345, 321, 8, 25, "Output",
      CellTags->"S5.47.1"],
    Cell[9915, 356, 104, 1, 40, "MathCaption",
      CellTags->{"S5.47.1", "1.11"}],
    Cell[10044, 361, 82, 2, 70, "Input",
      CellTags->"S5.47.1"],
    Cell[10129, 365, 330, 8, 70, "Output",
      CellTags->"S5.47.1"],
    Cell[10474, 376, 208, 4, 70, "Text",
      CellTags->{"S5.47.1", "1.12"}],
    Cell[10685, 382, 202, 5, 70, "MathCaption",
      CellTags->{"S5.47.1", "1.13"}],
    Cell[10912, 391, 76, 2, 70, "Input",
      CellTags->"S5.47.1"],
    Cell[10991, 395, 323, 8, 70, "Output",
      CellTags->"S5.47.1"]},
  "1.1"->{
    Cell[1776, 53, 141, 6, 36, "Subsection",
      CellTags->{"S5.47.1", "1.1"}]},
  "1.2"->{
    Cell[1920, 61, 263, 5, 40, "Text",
      CellTags->{"S5.47.1", "1.2"}]},
  "1.3"->{
    Cell[5730, 179, 845, 32, 40, "Text",
      CellTags->{"S5.47.1", "1.3"}]},
  "1.4"->{
    Cell[6578, 213, 47, 1, 24, "Text",
      CellTags->{"S5.47.1", "1.4"}]},
  "1.5"->{
    Cell[6628, 216, 1299, 54, 58, "DisplayFormula",
      CellTags->{"S5.47.1", "1.5"}]},
  "1.6"->{
    Cell[7930, 272, 490, 19, 24, "Text",
      CellTags->{"S5.47.1", "1.6"}]},
  "1.7"->{
    Cell[8423, 293, 47, 1, 24, "Text",
      CellTags->{"S5.47.1", "1.7"}]},
  "1.8"->{
    Cell[8473, 296, 713, 31, 66, "DisplayFormula",
      CellTags->{"S5.47.1", "1.8"}]},
  "1.9"->{
    Cell[9189, 329, 78, 1, 40, "MathCaption",
      CellTags->{"S5.47.1", "1.9"}]},
  "1.10"->{
    Cell[9365, 336, 82, 1, 40, "MathCaption",
      CellTags->{"S5.47.1", "1.10"}]},
  "1.11"->{
    Cell[9915, 356, 104, 1, 40, "MathCaption",
      CellTags->{"S5.47.1", "1.11"}]},
  "1.12"->{
    Cell[10474, 376, 208, 4, 70, "Text",
      CellTags->{"S5.47.1", "1.12"}]},
  "1.13"->{
    Cell[10685, 382, 202, 5, 70, "MathCaption",
      CellTags->{"S5.47.1", "1.13"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.47.1", 11965, 423},
  {"1.1", 13674, 468},
  {"1.2", 13768, 471},
  {"1.3", 13856, 474},
  {"1.4", 13946, 477},
  {"1.5", 14034, 480},
  {"1.6", 14135, 483},
  {"1.7", 14225, 486},
  {"1.8", 14313, 489},
  {"1.9", 14413, 492},
  {"1.10", 14509, 495},
  {"1.11", 14606, 498},
  {"1.12", 14704, 501},
  {"1.13", 14796, 504}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 141, 6, 36, "Subsection",
  CellTags->{"S5.47.1", "1.1"}],
Cell[1920, 61, 263, 5, 40, "Text",
  CellTags->{"S5.47.1", "1.2"}],
Cell[2186, 68, 3476, 106, 102, "DefinitionBox",
  CellTags->"S5.47.1"],
Cell[5665, 176, 62, 1, 15, "Caption",
  CellTags->"S5.47.1"],
Cell[5730, 179, 845, 32, 40, "Text",
  CellTags->{"S5.47.1", "1.3"}],
Cell[6578, 213, 47, 1, 24, "Text",
  CellTags->{"S5.47.1", "1.4"}],
Cell[6628, 216, 1299, 54, 58, "DisplayFormula",
  CellTags->{"S5.47.1", "1.5"}],
Cell[7930, 272, 490, 19, 24, "Text",
  CellTags->{"S5.47.1", "1.6"}],
Cell[8423, 293, 47, 1, 24, "Text",
  CellTags->{"S5.47.1", "1.7"}],
Cell[8473, 296, 713, 31, 66, "DisplayFormula",
  CellTags->{"S5.47.1", "1.8"}],
Cell[9189, 329, 78, 1, 40, "MathCaption",
  CellTags->{"S5.47.1", "1.9"}],
Cell[9270, 332, 92, 2, 28, "Input",
  CellTags->"S5.47.1"],
Cell[9365, 336, 82, 1, 40, "MathCaption",
  CellTags->{"S5.47.1", "1.10"}],

Cell[CellGroupData[{
Cell[9472, 341, 104, 2, 28, "Input",
  CellTags->"S5.47.1"],
Cell[9579, 345, 321, 8, 25, "Output",
  CellTags->"S5.47.1"]
}, Open  ]],
Cell[9915, 356, 104, 1, 40, "MathCaption",
  CellTags->{"S5.47.1", "1.11"}],

Cell[CellGroupData[{
Cell[10044, 361, 82, 2, 70, "Input",
  CellTags->"S5.47.1"],
Cell[10129, 365, 330, 8, 70, "Output",
  CellTags->"S5.47.1"]
}, Open  ]],
Cell[10474, 376, 208, 4, 70, "Text",
  CellTags->{"S5.47.1", "1.12"}],
Cell[10685, 382, 202, 5, 70, "MathCaption",
  CellTags->{"S5.47.1", "1.13"}],

Cell[CellGroupData[{
Cell[10912, 391, 76, 2, 70, "Input",
  CellTags->"S5.47.1"],
Cell[10991, 395, 323, 8, 70, "Output",
  CellTags->"S5.47.1"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

