(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     10705,        353]*)
(*NotebookOutlinePosition[     11379,        376]*)
(*  CellTagsIndexPosition[     11335,        372]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["NumberTheory`Frobenius`", "Section"],

Cell["\<\
This package provides functions for solving Frobenius equations and \
computing Frobenius numbers.\
\>", "Text"],

Cell[TextData[{
  "A ",
  StyleBox["Frobenius equation",
    FontSlant->"Italic"],
  " is an equation of the form"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`\(\(\(\(\(\(a\_1\) x\_1\)\(+\)\) ... \) + \(a\_n\) 
          x\_n \[Equal] \ m\)\(,\)\)\)], "DisplayFormula"],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`a\_1,  ... , \ a\_n\)]],
  " are positive integers, ",
  StyleBox["m",
    FontSlant->"Italic"],
  " is an integer, and the coordinates ",
  Cell[BoxData[
      \(TraditionalForm\`x\_1,  ... , \ x\_n\)]],
  " of solutions are required to be nonnegative integers."
}], "Text"],

Cell[TextData[{
  "The ",
  StyleBox["Frobenius number ",
    FontSlant->"Italic"],
  "of ",
  Cell[BoxData[
      \(TraditionalForm\`a\_1,  ... , \ a\_n\)]],
  " is the largest integer ",
  StyleBox["m ",
    FontSlant->"Italic"],
  "for which the Frobenius equation ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\(\(a\_1\) x\_1\)\(+\)\) ... \) + \(a\_n\) 
            x\_n \[Equal] \ m\)]],
  " has no solutions."
}], "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["FrobeniusInstance",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                RowBox[{
                  StyleBox["{",
                    "TI",
                    FontSlant->"Italic"], 
                  StyleBox[
                    RowBox[{
                      SubscriptBox[
                        StyleBox["a",
                          "TI"], "1"], ",", "...", ",", \(a\_n\)}],
                    FontSlant->"Italic"], 
                  StyleBox["}",
                    FontSlant->"Italic"]}], 
                StyleBox[",",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  FontSlant->"Italic"], 
                StyleBox["m",
                  FontSlant->"Italic"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                RowBox[{
                  RowBox[{
                    RowBox[{
                    "give", " ", "a", " ", "solution", " ", "of", " ", "the", 
                      " ", "Frobenius", " ", "equation", " ", 
                      StyleBox[\(a\_1\),
                        FontSlant->"Italic"], 
                      StyleBox[\(x\_1\),
                        FontSlant->"Italic"]}], 
                    StyleBox["+",
                      FontSlant->"Italic"]}], 
                  StyleBox["...",
                    FontSlant->"Italic"]}], 
                StyleBox["+",
                  FontSlant->"Italic"], 
                StyleBox[\(\(a\_n\) x\_n\),
                  FontSlant->"Italic"]}], 
              StyleBox["\[Equal]",
                FontSlant->"Italic"], 
              StyleBox[" ",
                FontSlant->"Italic"], 
              RowBox[{
                StyleBox["m",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  FontSlant->"Italic"], 
                StyleBox["or",
                  FontSlant->"Plain"], 
                StyleBox[" ",
                  FontSlant->"Plain"], \({}\), 
                StyleBox[" ",
                  FontSlant->"Plain"], 
                StyleBox["if",
                  FontSlant->"Plain"], 
                StyleBox[" ",
                  FontSlant->"Plain"], 
                StyleBox["there",
                  FontSlant->"Plain"], 
                StyleBox[" ",
                  FontSlant->"Plain"], 
                StyleBox["are",
                  FontSlant->"Plain"], 
                StyleBox[" ",
                  FontSlant->"Plain"], 
                StyleBox["no",
                  FontSlant->"Plain"], 
                StyleBox[" ",
                  FontSlant->"Plain"], 
                StyleBox["solutions",
                  FontSlant->"Plain"]}]}]},
          {
            RowBox[{
              StyleBox["FrobeniusSolve",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                RowBox[{
                  StyleBox["{",
                    "TI",
                    FontSlant->"Italic"], 
                  StyleBox[
                    RowBox[{
                      SubscriptBox[
                        StyleBox["a",
                          "TI"], "1"], ",", "...", ",", \(a\_n\)}],
                    FontSlant->"Italic"], 
                  StyleBox["}",
                    FontSlant->"Italic"]}], 
                StyleBox[",",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  FontSlant->"Italic"], 
                StyleBox["m",
                  FontSlant->"Italic"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                RowBox[{
                  RowBox[{
                    RowBox[{
                    "give", " ", "a", " ", "list", " ", "of", " ", "all", " ",
                       "solutions", " ", "of", " ", "the", " ", "Frobenius", 
                      " ", "equation", " ", 
                      StyleBox[\(a\_1\),
                        FontSlant->"Italic"], 
                      StyleBox[\(x\_1\),
                        FontSlant->"Italic"]}], 
                    StyleBox["+",
                      FontSlant->"Italic"]}], 
                  StyleBox["...",
                    FontSlant->"Italic"]}], 
                StyleBox["+",
                  FontSlant->"Italic"], 
                StyleBox[\(\(a\_n\) x\_n\),
                  FontSlant->"Italic"]}], 
              StyleBox["\[Equal]",
                FontSlant->"Italic"], 
              StyleBox[" ",
                FontSlant->"Italic"], 
              StyleBox["m",
                FontSlant->"Italic"], 
              StyleBox[" ",
                FontSlant->"Italic"]}]},
          {
            RowBox[{
              StyleBox["FrobeniusF",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["{",
                  "TI",
                  FontSlant->"Italic"], 
                StyleBox[
                  RowBox[{
                    SubscriptBox[
                      StyleBox["a",
                        "TI"], "1"], ",", "...", ",", \(a\_n\)}],
                  FontSlant->"Italic"], 
                StyleBox["}",
                  FontSlant->"Italic"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
            "give", " ", "the", " ", "Frobenius", " ", "number", " ", "of", 
              " ", 
              FormBox[\(a\_1,  ... , \ a\_n\),
                "TraditionalForm"]}]}
          }], TextForm]], "DefinitionBox"],

Cell["\<\
Functions for solving Frobenius equations and computing Frobenius \
numbers.\
\>", "Caption"],

Cell["This loads the package. ", "MathCaption"],

Cell[BoxData[
    \(<< NumberTheory`Frobenius`\)], "Input",
  CellLabel->"In[1]:="],

Cell[TextData[{
  "Here is a solution of the Frobenius equation ",
  StyleBox["12 x+16 y+20 z+27 t == 123.",
    FontSlant->"Italic"]
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FrobeniusInstance[{12, 16, 20, 27}, 123]\)], "Input",
  CellLabel->"In[2]:="],

Cell[BoxData[
    \({8, 0, 0, 1}\)], "Output",
  CellLabel->"Out[2]="]
}, Open  ]],

Cell[TextData[{
  "This gives all solutions of the Frobenius equation ",
  StyleBox["12 x+16 y+20 z+27 t == 123.",
    FontSlant->"Italic"]
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FrobeniusSolve[{12, 16, 20, 27}, 123]\)], "Input",
  CellLabel->"In[3]:="],

Cell[BoxData[
    \({{0, 1, 4, 1}, {0, 6, 0, 1}, {1, 4, 1, 1}, {2, 2, 2, 1}, {3, 0, 3, 
        1}, {4, 3, 0, 1}, {5, 1, 1, 1}, {8, 0, 0, 1}}\)], "Output",
  CellLabel->"Out[3]="]
}, Open  ]],

Cell[TextData[{
  "Here is the Frobenius number of ",
  StyleBox["{12, 16, 20, 27}",
    FontSlant->"Italic"],
  ", that is the largest ",
  StyleBox["m",
    FontSlant->"Italic"],
  " for which the Frobenius equation ",
  StyleBox["12 x+16 y+20 z+27 t == m",
    FontSlant->"Italic"],
  " has no solutions."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FrobeniusF[{12, 16, 20, 27}]\)], "Input",
  CellLabel->"In[4]:="],

Cell[BoxData[
    \(89\)], "Output",
  CellLabel->"Out[4]="]
}, Open  ]],

Cell[TextData[{
  "This shows that indeed, the Frobenius equation ",
  StyleBox["12 x+16 y+20 z+27 t == 89",
    FontSlant->"Italic"],
  " has no solutions."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FrobeniusInstance[{12, 16, 20, 27}, 89]\)], "Input",
  CellLabel->"In[5]:="],

Cell[BoxData[
    \({}\)], "Output",
  CellLabel->"Out[5]="]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 938}},
WindowSize->{520, 600},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 42, 0, 61, "Section"],
Cell[1821, 55, 122, 3, 40, "Text"],
Cell[1946, 60, 126, 5, 24, "Text"],
Cell[2075, 67, 147, 2, 30, "DisplayFormula"],
Cell[2225, 71, 344, 11, 40, "Text"],
Cell[2572, 84, 429, 15, 40, "Text"],
Cell[3004, 101, 5717, 161, 114, "DefinitionBox"],
Cell[8724, 264, 103, 3, 15, "Caption"],
Cell[8830, 269, 47, 0, 40, "MathCaption"],
Cell[8880, 271, 83, 2, 26, "Input"],
Cell[8966, 275, 152, 4, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[9143, 283, 97, 2, 26, "Input"],
Cell[9243, 287, 70, 2, 25, "Output"]
}, Open  ]],
Cell[9328, 292, 158, 4, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[9511, 300, 94, 2, 26, "Input"],
Cell[9608, 304, 179, 3, 41, "Output"]
}, Open  ]],
Cell[9802, 310, 327, 11, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[10154, 325, 85, 2, 26, "Input"],
Cell[10242, 329, 60, 2, 25, "Output"]
}, Open  ]],
Cell[10317, 334, 176, 5, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[10518, 343, 96, 2, 26, "Input"],
Cell[10617, 347, 60, 2, 25, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

