(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     11679,        369]*)
(*NotebookOutlinePosition[     16631,        530]*)
(*  CellTagsIndexPosition[     15963,        499]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 StyleBox["6.17 ", "HeadingNumber"],
 "*"
}], "Section",
 CellTags->{"S6.17.0", "0.1"}],

Cell["Appendix: Functions Moved to the Kernel ", "Text",
 CellTags->{"S6.17.0", "0.2"}],

Cell[CellGroupData[{

Cell["Functions Moved to the Kernel", "Subsection",
 CellTags->{"S6.17.1", "1.1"}],

Cell[TextData[{
  "As ",
  StyleBox["Mathematica", "TI"],
  " continues to be enhanced, it is sometimes useful to move functionality \
previously implemented as add\[Hyphen]on packages to the kernel. This allows \
a function to take advantage of internal features of the kernel. In Versions \
5 and 5.1, several packages and functions became kernel functions. "
}], "Text",
  CellTags->{"S6.17.1", "1.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox[\(\(DiscreteMath`DiscreteStep`\)\(\ \)\),
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], 
            StyleBox[\(\(DiscreteMath`RSolve`\)\(\ \)\),
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[{
              StyleBox["LinearAlgebra",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              "`",
              StyleBox["Cholesky",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              "`"
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[{
              StyleBox["LinearAlgebra",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              "`",
              StyleBox["MatrixManipulation",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              "`",
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[{
              StyleBox["NumericalMath",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              "`",
              StyleBox["NMinimize",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              "`"
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[{
              StyleBox["Statistics",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              "`",
              StyleBox["DescriptiveStatistics",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              "`",
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[{
              StyleBox["Statistics",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              "`",
              StyleBox["NonlinearFit",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              "`"
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[{
              StyleBox["Utilities`BinaryFiles",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              "`"
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S6.17.1"],

Cell["Packages with functionality moved into the kernel.", "Caption",
 CellTags->"S6.17.1"],

Cell[TextData[{
  "The following is a summary of the changes involved. Detailed information \
about the use of the kernel versions of these functions can be found in ",
  StyleBox["The Mathematica Book", "TI"],
  ". "
}], "Text",
  CellTags->{"S6.17.1", "1.3"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "From the ",
 StyleBox["DiscreteMath", "MB"],
 " Directory"
}], "Subsection",
 CellTags->{"S6.17.2", "2.1"}],

Cell[TextData[{
  StyleBox["RSolve", "MR"],
  " has been removed from the ",
  StyleBox["RSolve.m", "MR"],
  " package and implemented completely in the kernel with new and more \
powerful algorithms. The basic syntax remains the same, however the options \
are completely different, with the various method selection options removed. \
Note that the ",
  StyleBox["RSolve.m", "MR"],
  " package remains for some of the auxilliary functionality such as ",
  StyleBox["SeriesTerm", "MR"],
  " which has not yet been moved to the kernel."
}], "Text",
  CellTags->{"S6.17.2", "2.2"}],

Cell[TextData[{
  "The ",
  StyleBox["DiscreteStep.m", "MR"],
  " package was removed completely, as its functionality is better handled by \
use of kernel ",
  StyleBox["Piecewise", "MR"],
  " functions."
}], "Text",
  CellTags->{"S6.17.2", "2.3"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "From the ",
 StyleBox["LinearAlgebra", "MB"],
 " Directory"
}], "Subsection",
 CellTags->{"S6.17.3", "3.1"}],

Cell[TextData[{
  "The function ",
  StyleBox["CholeskyDecomposition", "MR"],
  " from the package ",
  StyleBox["Cholesky.m", "MR"],
  " has been moved entirely to the kernel. The syntax of the function is \
entirely the same. Note that the version ",
  Cell[BoxData[
      FormBox[
        RowBox[{"4.", 
          StyleBox["x",
            "TI"]}], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " function ",
  StyleBox["Experimental`CholeskyDecomposition", "MR"],
  ", which returned the result in a transposed form, has been removed. "
}], "Text",
  CellTags->{"S6.17.3", "3.2"}],

Cell[TextData[{
  "The functions ",
  StyleBox["VectorNorm", "MR"],
  " and ",
  StyleBox["MatrixNorm", "MR"],
  " from the ",
  StyleBox["MatrixManipulation.m", "MR"],
  " package have been superseded by the kernel function ",
  StyleBox["Norm", "MR"],
  ". The package functions will continue to work for the time being for \
compatability purposes, calling the kernel function when appropriate. \
However, uses of these functions should be transitioned to ",
  StyleBox["Norm", "MR"],
  " as soon as is convenient. "
}], "Text",
  CellTags->{"S6.17.3", "3.3"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "From the ",
 StyleBox["Statistics", "MB"],
 " Directory"
}], "Subsection",
 CellTags->{"S6.17.4", "4.1"}],

Cell[TextData[{
 "The descriptive statistics functions ",
 StyleBox["Mean", "MR"],
 ", ",
 StyleBox["Median", "MR"],
 ", ",
 StyleBox["Quantile", "MR"],
 ", ",
 StyleBox["Variance", "MR"],
 ", and ",
 StyleBox["StandardDeviation", "MR"],
 " have been implemented in the kernel for operations on lists and matrices \
of data. This means that the statistics packages ",
 StyleBox["DiscreteDistributions.m", "MR"],
 " or ",
 StyleBox["MultiDiscreteDistributions.m", "MR"],
 " no longer need to be loaded to use these functions for data. The syntax \
otherwise stays the same as the package functions. The implementations for \
distributions still remain in the ",
 StyleBox["Statistics`", "MR"],
 " packages, as do the other data functions from these packages. "
}], "Text",
 CellTags->{"S6.17.4", "4.2"}],

Cell[TextData[{
 "Nonlinear curve fitting is now handled in the kernel via the function ",
 StyleBox["FindFit", "MR"],
 ". The function ",
 StyleBox["NonlinearFit", "MR"],
 " still exists in the ",
 StyleBox["NonlinearFit.m", "MR"],
 " package for compatability, but it is just a shell for ",
 StyleBox["FindFit", "MR"],
 ". ",
 StyleBox["FindFit", "MR"],
 " should instead be used directly, as ",
 StyleBox["NonlinearFit", "MR"],
 " will be removed completely at some point in the future. Note that there \
are a number of syntactic differences between ",
 StyleBox["FindFit", "MR"],
 " and ",
 StyleBox["NonlinearFit", "MR"],
 ", most significant of which are a different order for the parameter and \
variable arguments, and the return value consisting of a list of rules (in \
common with other numerics functions) instead of the model with parameters \
substituted. See the main documentation for more details. "
}], "Text",
 CellTags->{"S6.17.4", "4.3"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Additional Changes", "Subsection",
 CellTags->{"S6.17.5", "5.1"}],

Cell[TextData[{
  "The ",
  StyleBox["NMinimize", "MR"],
  " functionality, which was new in Version 4.2, has been moved to the kernel \
and expanded upon. "
}], "Text",
  CellTags->{"S6.17.5", "5.2"}],

Cell[TextData[{
  StyleBox["BinaryFiles.m", "MR"],
  " functionality has been replaced by kernel functions such as ",
  StyleBox["BinaryRead", "MR"],
  " and ",
  StyleBox["BinaryWrite", "MR"],
  ". The package still exists and attempts to map the old functions to new \
functions, but there may be some minor changes in behavior."
}], "Text",
  CellTags->{"S6.17.5", "5.3"}],

Cell["\<\
A number of packages had been made obsolete in Version 4, but remained as a \
stub package warning of the change. Those stub packages have now been removed \
completely. \
\>", "Text",
  CellTags->{"S6.17.5", "5.4"}],

Cell[TextData[{
  "Similarly, the ",
  StyleBox["Master.m", "MR"],
  " packages have been removed, as they were superseded by ",
  StyleBox["Kernel/init.m", "MR"],
  " files in Version 3."
}], "Text",
  CellTags->{"S6.17.5", "5.5"}],

Cell[TextData[{
  "The ",
  StyleBox["Cholesky", "MR"],
  " and ",
  StyleBox["NMinimize", "MR"],
  " packages described above, as well as the ",
  StyleBox["DiscreteMath`Permutations`", "MR"],
  " package, now exist only as stubs to emit a warning that the file is \
obsolete. "
}], "Text",
  CellTags->{"S6.17.5", "5.6"}]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.1 for Microsoft Windows",
ScreenRectangle->{{0, 1280}, {0, 971}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S6.17.0"->{
    Cell[1776, 53, 103, 4, 65, "Section",
      CellTags->{"S6.17.0", "0.1"}],
    Cell[1882, 59, 87, 1, 25, "Text",
      CellTags->{"S6.17.0", "0.2"}]},
  "0.1"->{
    Cell[1776, 53, 103, 4, 65, "Section",
      CellTags->{"S6.17.0", "0.1"}]},
  "0.2"->{
    Cell[1882, 59, 87, 1, 25, "Text",
      CellTags->{"S6.17.0", "0.2"}]},
  "S6.17.1"->{
    Cell[1994, 64, 82, 1, 39, "Subsection",
      CellTags->{"S6.17.1", "1.1"}],
    Cell[2079, 67, 405, 8, 76, "Text",
      CellTags->{"S6.17.1", "1.2"}],
    Cell[2487, 77, 3045, 84, 106, "DefinitionBox",
      CellTags->"S6.17.1"],
    Cell[5535, 163, 91, 1, 17, "Caption",
      CellTags->"S6.17.1"],
    Cell[5629, 166, 261, 6, 42, "Text",
      CellTags->{"S6.17.1", "1.3"}]},
  "1.1"->{
    Cell[1994, 64, 82, 1, 39, "Subsection",
      CellTags->{"S6.17.1", "1.1"}]},
  "1.2"->{
    Cell[2079, 67, 405, 8, 76, "Text",
      CellTags->{"S6.17.1", "1.2"}]},
  "1.3"->{
    Cell[5629, 166, 261, 6, 42, "Text",
      CellTags->{"S6.17.1", "1.3"}]},
  "S6.17.2"->{
    Cell[5927, 177, 125, 5, 40, "Subsection",
      CellTags->{"S6.17.2", "2.1"}],
    Cell[6055, 184, 580, 13, 93, "Text",
      CellTags->{"S6.17.2", "2.2"}],
    Cell[6638, 199, 249, 8, 42, "Text",
      CellTags->{"S6.17.2", "2.3"}]},
  "2.1"->{
    Cell[5927, 177, 125, 5, 40, "Subsection",
      CellTags->{"S6.17.2", "2.1"}]},
  "2.2"->{
    Cell[6055, 184, 580, 13, 93, "Text",
      CellTags->{"S6.17.2", "2.2"}]},
  "2.3"->{
    Cell[6638, 199, 249, 8, 42, "Text",
      CellTags->{"S6.17.2", "2.3"}]},
  "S6.17.3"->{
    Cell[6924, 212, 126, 5, 40, "Subsection",
      CellTags->{"S6.17.3", "3.1"}],
    Cell[7053, 219, 624, 17, 76, "Text",
      CellTags->{"S6.17.3", "3.2"}],
    Cell[7680, 238, 563, 15, 76, "Text",
      CellTags->{"S6.17.3", "3.3"}]},
  "3.1"->{
    Cell[6924, 212, 126, 5, 40, "Subsection",
      CellTags->{"S6.17.3", "3.1"}]},
  "3.2"->{
    Cell[7053, 219, 624, 17, 76, "Text",
      CellTags->{"S6.17.3", "3.2"}]},
  "3.3"->{
    Cell[7680, 238, 563, 15, 76, "Text",
      CellTags->{"S6.17.3", "3.3"}]},
  "S6.17.4"->{
    Cell[8280, 258, 123, 5, 40, "Subsection",
      CellTags->{"S6.17.4", "4.1"}],
    Cell[8406, 265, 802, 22, 110, "Text",
      CellTags->{"S6.17.4", "4.2"}],
    Cell[9211, 289, 960, 23, 144, "Text",
      CellTags->{"S6.17.4", "4.3"}]},
  "4.1"->{
    Cell[8280, 258, 123, 5, 40, "Subsection",
      CellTags->{"S6.17.4", "4.1"}]},
  "4.2"->{
    Cell[8406, 265, 802, 22, 110, "Text",
      CellTags->{"S6.17.4", "4.2"}]},
  "4.3"->{
    Cell[9211, 289, 960, 23, 144, "Text",
      CellTags->{"S6.17.4", "4.3"}]},
  "S6.17.5"->{
    Cell[10208, 317, 71, 1, 39, "Subsection",
      CellTags->{"S6.17.5", "5.1"}],
    Cell[10282, 320, 201, 6, 42, "Text",
      CellTags->{"S6.17.5", "5.2"}],
    Cell[10486, 328, 375, 9, 59, "Text",
      CellTags->{"S6.17.5", "5.3"}],
    Cell[10864, 339, 226, 5, 42, "Text",
      CellTags->{"S6.17.5", "5.4"}],
    Cell[11093, 346, 232, 7, 42, "Text",
      CellTags->{"S6.17.5", "5.5"}],
    Cell[11328, 355, 323, 10, 42, "Text",
      CellTags->{"S6.17.5", "5.6"}]},
  "5.1"->{
    Cell[10208, 317, 71, 1, 39, "Subsection",
      CellTags->{"S6.17.5", "5.1"}]},
  "5.2"->{
    Cell[10282, 320, 201, 6, 42, "Text",
      CellTags->{"S6.17.5", "5.2"}]},
  "5.3"->{
    Cell[10486, 328, 375, 9, 59, "Text",
      CellTags->{"S6.17.5", "5.3"}]},
  "5.4"->{
    Cell[10864, 339, 226, 5, 42, "Text",
      CellTags->{"S6.17.5", "5.4"}]},
  "5.5"->{
    Cell[11093, 346, 232, 7, 42, "Text",
      CellTags->{"S6.17.5", "5.5"}]},
  "5.6"->{
    Cell[11328, 355, 323, 10, 42, "Text",
      CellTags->{"S6.17.5", "5.6"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S6.17.0", 12308, 385},
  {"0.1", 12474, 390},
  {"0.2", 12565, 393},
  {"S6.17.1", 12656, 396},
  {"1.1", 13051, 407},
  {"1.2", 13144, 410},
  {"1.3", 13232, 413},
  {"S6.17.2", 13325, 416},
  {"2.1", 13575, 423},
  {"2.2", 13670, 426},
  {"2.3", 13760, 429},
  {"S6.17.3", 13853, 432},
  {"3.1", 14104, 439},
  {"3.2", 14199, 442},
  {"3.3", 14289, 445},
  {"S6.17.4", 14383, 448},
  {"4.1", 14636, 455},
  {"4.2", 14731, 458},
  {"4.3", 14822, 461},
  {"S6.17.5", 14917, 464},
  {"5.1", 15403, 477},
  {"5.2", 15498, 480},
  {"5.3", 15588, 483},
  {"5.4", 15678, 486},
  {"5.5", 15768, 489},
  {"5.6", 15858, 492}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 103, 4, 65, "Section",
  CellTags->{"S6.17.0", "0.1"}],
Cell[1882, 59, 87, 1, 25, "Text",
  CellTags->{"S6.17.0", "0.2"}],

Cell[CellGroupData[{
Cell[1994, 64, 82, 1, 39, "Subsection",
  CellTags->{"S6.17.1", "1.1"}],
Cell[2079, 67, 405, 8, 76, "Text",
  CellTags->{"S6.17.1", "1.2"}],
Cell[2487, 77, 3045, 84, 106, "DefinitionBox",
  CellTags->"S6.17.1"],
Cell[5535, 163, 91, 1, 17, "Caption",
  CellTags->"S6.17.1"],
Cell[5629, 166, 261, 6, 42, "Text",
  CellTags->{"S6.17.1", "1.3"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[5927, 177, 125, 5, 40, "Subsection",
  CellTags->{"S6.17.2", "2.1"}],
Cell[6055, 184, 580, 13, 93, "Text",
  CellTags->{"S6.17.2", "2.2"}],
Cell[6638, 199, 249, 8, 42, "Text",
  CellTags->{"S6.17.2", "2.3"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[6924, 212, 126, 5, 40, "Subsection",
  CellTags->{"S6.17.3", "3.1"}],
Cell[7053, 219, 624, 17, 76, "Text",
  CellTags->{"S6.17.3", "3.2"}],
Cell[7680, 238, 563, 15, 76, "Text",
  CellTags->{"S6.17.3", "3.3"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[8280, 258, 123, 5, 40, "Subsection",
  CellTags->{"S6.17.4", "4.1"}],
Cell[8406, 265, 802, 22, 110, "Text",
  CellTags->{"S6.17.4", "4.2"}],
Cell[9211, 289, 960, 23, 144, "Text",
  CellTags->{"S6.17.4", "4.3"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[10208, 317, 71, 1, 39, "Subsection",
  CellTags->{"S6.17.5", "5.1"}],
Cell[10282, 320, 201, 6, 42, "Text",
  CellTags->{"S6.17.5", "5.2"}],
Cell[10486, 328, 375, 9, 59, "Text",
  CellTags->{"S6.17.5", "5.3"}],
Cell[10864, 339, 226, 5, 42, "Text",
  CellTags->{"S6.17.5", "5.4"}],
Cell[11093, 346, 232, 7, 42, "Text",
  CellTags->{"S6.17.5", "5.5"}],
Cell[11328, 355, 323, 10, 42, "Text",
  CellTags->{"S6.17.5", "5.6"}]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

