(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     14227,        488]*)
(*NotebookOutlinePosition[     17390,        587]*)
(*  CellTagsIndexPosition[     17110,        572]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "NumericalMath",
 StyleBox["`", "MB"],
 "GaussianQuadrature",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.81.1", "1.1"}],

Cell[TextData[{
 "As one of its methods, the ",
 StyleBox["Mathematica", "TI"],
 " function ",
 StyleBox["NIntegrate", "MR"],
 " uses a fairly sophisticated Gauss\[Hyphen]Kronrod\[Hyphen]based algorithm. \
The package ",
 StyleBox["NumericalMath`GaussianQuadrature`", "MR"],
 " allows you to easily study some of the theory behind ordinary Gaussian \
quadrature which is a little less sophisticated. "
}], "Text",
 CellTags->{"S5.81.1", "1.2"}],

Cell["\<\
The basic idea behind Gaussian quadrature is to approximate the value if an \
integral as a linear combination of values of the integrand evaluated at \
specific points: \
\>", "Text",
 CellTags->{"S5.81.1", "1.3"}],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubsuperscriptBox["\[Integral]", 
    StyleBox["a",
     "TI"], 
    StyleBox["b",
     "TI"]], 
   StyleBox["f",
    "TI"], 
   RowBox[{"(", 
    StyleBox["x",
     "TI"], ")"}], "\[DifferentialD]", 
   StyleBox["x",
    "TI"], "=", 
   UnderoverscriptBox["\[Sum]", 
    RowBox[{
     StyleBox["i",
      "TI"], "=", "1"}], 
    StyleBox["n",
     "TI"],
    LimitsPositioning->False], 
   SubscriptBox[
    StyleBox["w",
     "TI"], 
    StyleBox["i",
     "TI"]], 
   StyleBox["f",
    "TI"], 
   RowBox[{"(", 
    SubscriptBox[
     StyleBox["x",
      "TI"], 
     StyleBox["i",
      "TI"]], ")"}]}], TraditionalForm]], "DisplayFormula",
 UnderoverscriptBoxOptions->{LimitsPositioning->True},
 GridBoxOptions->{ColumnWidths->Automatic},
 CellTags->{"S5.81.1", "1.4"}],

Cell[TextData[{
 "Since there are ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", 
    StyleBox["n",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " free parameters to be chosen (both the abscissas ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["x",
     "TI"], 
    StyleBox["i",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and the weights ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["w",
     "TI"], 
    StyleBox["i",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ") and since both integration and the sum are linear operations, you can \
expect to be able to make the formula correct for all polynomials of degree \
less than about ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", 
    StyleBox["n",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". In addition to knowing what the optimal abscissas and weights are, it is \
often desirable to know how large the error in the approximation will be. \
This package allows you to answer both of these questions. "
}], "Text",
 CellTags->{"S5.81.1", "1.5"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["GaussianQuadratureWeights[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["a", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["b", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give a list of the pairs ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"(", 
         RowBox[{
          SubscriptBox[
           StyleBox["x",
            "TI"], 
           StyleBox["i",
            "TI"]], ",", 
          SubscriptBox[
           StyleBox["w",
            "TI"], 
           StyleBox["i",
            "TI"]]}], ")"}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" to machine precision for quadrature on the interval ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["a", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" to ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["b", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["GaussianQuadratureError[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["a", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["b", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "give the error to machine precision",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["GaussianQuadratureWeights[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["a", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["b", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["prec", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give a list of the pairs ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"(", 
         RowBox[{
          SubscriptBox[
           StyleBox["x",
            "TI"], 
           StyleBox["i",
            "TI"]], ",", 
          SubscriptBox[
           StyleBox["w",
            "TI"], 
           StyleBox["i",
            "TI"]]}], ")"}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" to precision ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["prec", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["GaussianQuadratureError[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["a", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["b", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["prec", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the error to precision ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["prec", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.81.1"],

Cell["Finding formulas for Gaussian quadrature. ", "Caption",
 CellTags->"S5.81.1"],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.81.1", "1.6"}],

Cell["<<NumericalMath`GaussianQuadrature`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.81.1"],

Cell[TextData[{
 "This gives the abscissas and weights for the five\[Hyphen]point Gaussian \
quadrature formula on the interval (",
 Cell[BoxData[
  FormBox["-", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "3, 7). "
}], "MathCaption",
 CellTags->{"S5.81.1", "1.7"}],

Cell[CellGroupData[{

Cell["GaussianQuadratureWeights[5, -3, 7]", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.81.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2.53089922969332`"}], ",", "1.1846344252809455`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.6923465505284154`"}], ",", "2.393143352496832`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"2.`", ",", "2.844444444444444`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.692346550528415`", ",", "2.393143352496832`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6.53089922969332`", ",", "1.1846344252809455`"}], "}"}]}], 
  "}"}]], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.81.1"]
}, Open  ]],

Cell[TextData[{
 "Here is the error in that formula. Unfortunately it involves the tenth \
derivative of ",
 Cell[BoxData[
  FormBox[
   StyleBox["f",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " at an unknown point so you don\[CloseCurlyQuote]t really know what the \
error itself is. "
}], "MathCaption",
 CellTags->{"S5.81.1", "1.8"}],

Cell[CellGroupData[{

Cell["GaussianQuadratureError[5, f, -3, 7]", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.81.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.03944965417208696`"}], " ", 
  SuperscriptBox["f", 
   TagBox[
    RowBox[{"(", "10", ")"}],
    Derivative],
   MultilineFunction->None]}]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.81.1"]
}, Open  ]],

Cell["\<\
You can see that the error decreases rapidly with the length of the interval. \
\
\>", "MathCaption",
 CellTags->{"S5.81.1", "1.9"}],

Cell[CellGroupData[{

Cell["GaussianQuadratureError[5, f, a, a+h]", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.81.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "3.944965417208696`*^-13"}], " ", 
  SuperscriptBox["h", "11"], " ", 
  SuperscriptBox["f", 
   TagBox[
    RowBox[{"(", "10", ")"}],
    Derivative],
   MultilineFunction->None]}]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.81.1"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.81.1"->{
    Cell[1776, 53, 148, 6, 36, "Subsection",
      CellTags->{"S5.81.1", "1.1"}],
    Cell[1927, 61, 444, 11, 72, "Text",
      CellTags->{"S5.81.1", "1.2"}],
    Cell[2374, 74, 225, 5, 40, "Text",
      CellTags->{"S5.81.1", "1.3"}],
    Cell[2602, 81, 811, 37, 52, "DisplayFormula",
      CellTags->{"S5.81.1", "1.4"}],
    Cell[3416, 120, 1233, 39, 88, "Text",
      CellTags->{"S5.81.1", "1.5"}],
    Cell[4652, 161, 6912, 220, 180, "DefinitionBox",
      CellTags->"S5.81.1"],
    Cell[11567, 383, 83, 1, 15, "Caption",
      CellTags->"S5.81.1"],
    Cell[11653, 386, 78, 1, 40, "MathCaption",
      CellTags->{"S5.81.1", "1.6"}],
    Cell[11734, 389, 98, 2, 28, "Input",
      CellTags->"S5.81.1"],
    Cell[11835, 393, 304, 8, 56, "MathCaption",
      CellTags->{"S5.81.1", "1.7"}],
    Cell[12164, 405, 98, 2, 28, "Input",
      CellTags->"S5.81.1"],
    Cell[12265, 409, 603, 19, 70, "Output",
      CellTags->"S5.81.1"],
    Cell[12883, 431, 388, 11, 70, "MathCaption",
      CellTags->{"S5.81.1", "1.8"}],
    Cell[13296, 446, 99, 2, 70, "Input",
      CellTags->"S5.81.1"],
    Cell[13398, 450, 239, 9, 70, "Output",
      CellTags->"S5.81.1"],
    Cell[13652, 462, 142, 4, 70, "MathCaption",
      CellTags->{"S5.81.1", "1.9"}],
    Cell[13819, 470, 100, 2, 70, "Input",
      CellTags->"S5.81.1"],
    Cell[13922, 474, 277, 10, 70, "Output",
      CellTags->"S5.81.1"]},
  "1.1"->{
    Cell[1776, 53, 148, 6, 36, "Subsection",
      CellTags->{"S5.81.1", "1.1"}]},
  "1.2"->{
    Cell[1927, 61, 444, 11, 72, "Text",
      CellTags->{"S5.81.1", "1.2"}]},
  "1.3"->{
    Cell[2374, 74, 225, 5, 40, "Text",
      CellTags->{"S5.81.1", "1.3"}]},
  "1.4"->{
    Cell[2602, 81, 811, 37, 52, "DisplayFormula",
      CellTags->{"S5.81.1", "1.4"}]},
  "1.5"->{
    Cell[3416, 120, 1233, 39, 88, "Text",
      CellTags->{"S5.81.1", "1.5"}]},
  "1.6"->{
    Cell[11653, 386, 78, 1, 40, "MathCaption",
      CellTags->{"S5.81.1", "1.6"}]},
  "1.7"->{
    Cell[11835, 393, 304, 8, 56, "MathCaption",
      CellTags->{"S5.81.1", "1.7"}]},
  "1.8"->{
    Cell[12883, 431, 388, 11, 70, "MathCaption",
      CellTags->{"S5.81.1", "1.8"}]},
  "1.9"->{
    Cell[13652, 462, 142, 4, 70, "MathCaption",
      CellTags->{"S5.81.1", "1.9"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.81.1", 14850, 504},
  {"1.1", 16247, 541},
  {"1.2", 16341, 544},
  {"1.3", 16430, 547},
  {"1.4", 16518, 550},
  {"1.5", 16617, 553},
  {"1.6", 16708, 556},
  {"1.7", 16804, 559},
  {"1.8", 16901, 562},
  {"1.9", 16999, 565}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 148, 6, 36, "Subsection",
  CellTags->{"S5.81.1", "1.1"}],
Cell[1927, 61, 444, 11, 72, "Text",
  CellTags->{"S5.81.1", "1.2"}],
Cell[2374, 74, 225, 5, 40, "Text",
  CellTags->{"S5.81.1", "1.3"}],
Cell[2602, 81, 811, 37, 52, "DisplayFormula",
  CellTags->{"S5.81.1", "1.4"}],
Cell[3416, 120, 1233, 39, 88, "Text",
  CellTags->{"S5.81.1", "1.5"}],
Cell[4652, 161, 6912, 220, 180, "DefinitionBox",
  CellTags->"S5.81.1"],
Cell[11567, 383, 83, 1, 15, "Caption",
  CellTags->"S5.81.1"],
Cell[11653, 386, 78, 1, 40, "MathCaption",
  CellTags->{"S5.81.1", "1.6"}],
Cell[11734, 389, 98, 2, 28, "Input",
  CellTags->"S5.81.1"],
Cell[11835, 393, 304, 8, 56, "MathCaption",
  CellTags->{"S5.81.1", "1.7"}],

Cell[CellGroupData[{
Cell[12164, 405, 98, 2, 28, "Input",
  CellTags->"S5.81.1"],
Cell[12265, 409, 603, 19, 70, "Output",
  CellTags->"S5.81.1"]
}, Open  ]],
Cell[12883, 431, 388, 11, 70, "MathCaption",
  CellTags->{"S5.81.1", "1.8"}],

Cell[CellGroupData[{
Cell[13296, 446, 99, 2, 70, "Input",
  CellTags->"S5.81.1"],
Cell[13398, 450, 239, 9, 70, "Output",
  CellTags->"S5.81.1"]
}, Open  ]],
Cell[13652, 462, 142, 4, 70, "MathCaption",
  CellTags->{"S5.81.1", "1.9"}],

Cell[CellGroupData[{
Cell[13819, 470, 100, 2, 70, "Input",
  CellTags->"S5.81.1"],
Cell[13922, 474, 277, 10, 70, "Output",
  CellTags->"S5.81.1"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

