(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     18063,        596]*)
(*NotebookOutlinePosition[     22378,        729]*)
(*  CellTagsIndexPosition[     22026,        711]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Miscellaneous",
 StyleBox["`", "MB"],
 "Geodesy",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.56.1", "1.1"}],

Cell["\<\
Geodesy is the branch of science that deals with such topics as determining \
positions and areas over large parts of the Earth, the shape and size of the \
Earth, and the variations in the Earth\[CloseCurlyQuote]s gravitational and \
magnetic fields. The primary functions in this package are used for \
determining the distance between two points. \
\>", "Text",
 CellTags->{"S5.56.1", "1.2"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["SphericalDistance[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["pos",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["pos",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["calculate the distance between the ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["pos",
          "TI"], 
         StyleBox["i",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" using a spherical model",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["SpheroidalDistance[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["pos",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["pos",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["calculate the distance between the ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["pos",
          "TI"], 
         StyleBox["i",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" using a spheroidal model",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.56.1"],

Cell["Finding the distance between two points on a sphere. ", "Caption",
 CellTags->"S5.56.1"],

Cell[TextData[{
 "Each position can be given in degrees as a latitude\[Hyphen]longitude pair. \
A coordinate can also be expressed in the form ",
 StyleBox["{", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 StyleBox["degrees", "TI",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 StyleBox[", ", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 StyleBox["minutes", "TI",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 StyleBox[", ", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 StyleBox["seconds", "TI",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 StyleBox["}", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 ". A negative value for a coordinate indicates that the coordinate is South \
latitude or West longitude. Distances are returned in kilometers as the \
default. "
}], "Text",
 CellTags->{"S5.56.1", "1.3"}],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.56.1", "1.4"}],

Cell["<< Miscellaneous`Geodesy`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.56.1"],

Cell[TextData[{
 "This gives the distance between ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " lat., ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " long., and ",
 Cell[BoxData[
  FormBox["45", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " N. lat., ",
 Cell[BoxData[
  FormBox["45", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " E. long., using a spherical model. "
}], "MathCaption",
 CellTags->{"S5.56.1", "1.5"}],

Cell[CellGroupData[{

Cell["SphericalDistance[{0, 0}, {45, 45}] //N", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.56.1"],

Cell[BoxData["6671.702929056382`"], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.56.1"]
}, Open  ]],

Cell["\<\
Here is the distance between the same points using a spheroidal model. \
\>", "MathCaption",
 CellTags->{"S5.56.1", "1.6"}],

Cell[CellGroupData[{

Cell["SpheroidalDistance[{0, 0}, {45, 45}] //N", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.56.1"],

Cell[BoxData["6662.472787675837`"], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.56.1"]
}, Open  ]],

Cell["This is the difference between the two models. ", "MathCaption",
 CellTags->{"S5.56.1", "1.7"}],

Cell[CellGroupData[{

Cell["% - %%", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.56.1"],

Cell[BoxData[
 RowBox[{"-", "9.23014138054532`"}]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.56.1"]
}, Open  ]],

Cell[TextData[{
 "The spherical model is based on an exact formula, while the spheroidal \
model is an approximation algorithm that is fairly good for distances of less \
than 10,000 kilometers. Because of the nature of this approximation, all \
computation with ",
 StyleBox["SpheroidalDistance", "MR"],
 " is done with machine\[Hyphen]precision numbers. "
}], "Text",
 CellTags->{"S5.56.1", "1.8"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["Radius -> ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["radius", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "specify the radius of the sphere in the spherical model",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["SemimajorAxis -> ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["length", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "specify the length of the semimajor axis in the spheroidal model",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Eccentricity -> ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["value", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "specify the value of the eccentricity in the spheroidal model",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.56.1"],

Cell["Options to control the size of the shape in the models. ", "Caption",
 CellTags->"S5.56.1"],

Cell[TextData[{
 "The distances between points can be modified by using different values for \
the radius of the sphere, or the length of the semimajor axis and the \
eccentricity of the spheroid using the options ",
 StyleBox["Radius", "MR"],
 ", ",
 StyleBox["SemimajorAxis", "MR"],
 ", and ",
 StyleBox["Eccentricity", "MR"],
 ", respectively. The default values for these options are those for the \
Earth from the WGS\[Hyphen]84 standard, in kilometers. "
}], "Text",
 CellTags->{"S5.56.1", "1.9"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["ToAuthalicRadius[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["semimajor", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["eccentricity", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "compute radius of authalic sphere given spheroid\[CloseCurlyQuote]s \
semimajor axis and eccentricity",
      GridBoxOptions->{RowLines->{False, True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{False, True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["GeodeticToAuthalic[{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["lat", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["long", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["eccentricity", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "compute coordinates of corresponding point on authalic sphere given \
latitude and longitude of point on spheroid with specified eccentricity",
      GridBoxOptions->{RowLines->{False, True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{False, True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ToDegrees[{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["deg", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["min", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["sec", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "convert coordinate in degree\[Hyphen]minute\[Hyphen]second format to \
degrees",
      GridBoxOptions->{RowLines->{False, True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{False, True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ToDMS[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["deg", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "convert coordinate in degrees to degree\[Hyphen]minute\[Hyphen]second \
format",
      GridBoxOptions->{RowLines->{False, True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{False, True, False},
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->{False, True, False},
 RowSpacings->0.4},
 CellTags->"S5.56.1"],

Cell["Conversions between models and coordinate systems. ", "Caption",
 CellTags->"S5.56.1"],

Cell["\<\
The simplest way to convert to the sphere from the spheroid is to use the \
authalic sphere. This sphere has the same surface area as the reference \
spheroid. \
\>", "Text",
 CellTags->{"S5.56.1", "1.10"}],

Cell["\<\
Here is a comparison of the two shapes, with an ellipse whose eccentricity is \
much larger than the Earth, for effect. \
\>", "MathCaption",
 CellTags->{"S5.56.1", "1.11"}],

Cell[CellGroupData[{

Cell["\<\
Show[Graphics[{
 Circle[{0, 0}, ToAuthalicRadius[1, .6]],
     Dashing[{.03}],
 Circle[{0, 0}, {1, Sqrt[1 - (.6)^2]} ]}],
                AspectRatio -> Automatic]\
\>", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.56.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .93257 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.47619 0.466283 0.47619 [
[ 0 0 0 0 ]
[ 1 .93257 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .93257 L
0 .93257 L
closepath
clip
newpath
0 g
.5 Mabswid
[ ] 0 setdash
newpath
.5 .46628 .44408 0 365.73 arc
s
[ .03 ] 0 setdash
newpath
matrix currentmatrix
0.47619 0.380952 scale
1.05 1.22399 1 0 365.73 arc
setmatrix s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.56.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S5.56.1"]
}, Open  ]],

Cell["\<\
Note that the eccentricity used in the above diagram was .6. The actual \
eccentricity of the Earth\[CloseCurlyQuote]s spheroid is approximately .081. \
\
\>", "Text",
 CellTags->{"S5.56.1", "1.12"}]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.56.1"->{
    Cell[1776, 53, 137, 6, 36, "Subsection",
      CellTags->{"S5.56.1", "1.1"}],
    Cell[1916, 61, 405, 7, 72, "Text",
      CellTags->{"S5.56.1", "1.2"}],
    Cell[2324, 70, 3496, 108, 102, "DefinitionBox",
      CellTags->"S5.56.1"],
    Cell[5823, 180, 94, 1, 15, "Caption",
      CellTags->"S5.56.1"],
    Cell[5920, 183, 925, 28, 56, "Text",
      CellTags->{"S5.56.1", "1.3"}],
    Cell[6848, 213, 78, 1, 40, "MathCaption",
      CellTags->{"S5.56.1", "1.4"}],
    Cell[6929, 216, 88, 2, 28, "Input",
      CellTags->"S5.56.1"],
    Cell[7020, 220, 636, 19, 56, "MathCaption",
      CellTags->{"S5.56.1", "1.5"}],
    Cell[7681, 243, 102, 2, 28, "Input",
      CellTags->"S5.56.1"],
    Cell[7786, 247, 91, 2, 25, "Output",
      CellTags->"S5.56.1"],
    Cell[7892, 252, 133, 3, 40, "MathCaption",
      CellTags->{"S5.56.1", "1.6"}],
    Cell[8050, 259, 103, 2, 28, "Input",
      CellTags->"S5.56.1"],
    Cell[8156, 263, 91, 2, 22, "Output",
      CellTags->"S5.56.1"],
    Cell[8262, 268, 101, 1, 40, "MathCaption",
      CellTags->{"S5.56.1", "1.7"}],
    Cell[8388, 273, 69, 2, 28, "Input",
      CellTags->"S5.56.1"],
    Cell[8460, 277, 107, 3, 25, "Output",
      CellTags->"S5.56.1"],
    Cell[8582, 283, 400, 8, 70, "Text",
      CellTags->{"S5.56.1", "1.8"}],
    Cell[8985, 293, 2036, 60, 70, "DefinitionBox",
      CellTags->"S5.56.1"],
    Cell[11024, 355, 97, 1, 70, "Caption",
      CellTags->"S5.56.1"],
    Cell[11124, 358, 503, 12, 70, "Text",
      CellTags->{"S5.56.1", "1.9"}],
    Cell[11630, 372, 4409, 124, 70, "DefinitionBox",
      CellTags->"S5.56.1"],
    Cell[16042, 498, 92, 1, 70, "Caption",
      CellTags->"S5.56.1"],
    Cell[16137, 501, 216, 5, 70, "Text",
      CellTags->{"S5.56.1", "1.10"}],
    Cell[16356, 508, 183, 4, 70, "MathCaption",
      CellTags->{"S5.56.1", "1.11"}],
    Cell[16564, 516, 234, 8, 70, "Input",
      CellTags->"S5.56.1"],
    Cell[16801, 526, 839, 51, 70, 768, 48, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.56.1"],
    Cell[17643, 579, 180, 6, 70, "Output",
      CellTags->"S5.56.1"],
    Cell[17838, 588, 209, 5, 70, "Text",
      CellTags->{"S5.56.1", "1.12"}]},
  "1.1"->{
    Cell[1776, 53, 137, 6, 36, "Subsection",
      CellTags->{"S5.56.1", "1.1"}]},
  "1.2"->{
    Cell[1916, 61, 405, 7, 72, "Text",
      CellTags->{"S5.56.1", "1.2"}]},
  "1.3"->{
    Cell[5920, 183, 925, 28, 56, "Text",
      CellTags->{"S5.56.1", "1.3"}]},
  "1.4"->{
    Cell[6848, 213, 78, 1, 40, "MathCaption",
      CellTags->{"S5.56.1", "1.4"}]},
  "1.5"->{
    Cell[7020, 220, 636, 19, 56, "MathCaption",
      CellTags->{"S5.56.1", "1.5"}]},
  "1.6"->{
    Cell[7892, 252, 133, 3, 40, "MathCaption",
      CellTags->{"S5.56.1", "1.6"}]},
  "1.7"->{
    Cell[8262, 268, 101, 1, 40, "MathCaption",
      CellTags->{"S5.56.1", "1.7"}]},
  "1.8"->{
    Cell[8582, 283, 400, 8, 70, "Text",
      CellTags->{"S5.56.1", "1.8"}]},
  "1.9"->{
    Cell[11124, 358, 503, 12, 70, "Text",
      CellTags->{"S5.56.1", "1.9"}]},
  "1.10"->{
    Cell[16137, 501, 216, 5, 70, "Text",
      CellTags->{"S5.56.1", "1.10"}]},
  "1.11"->{
    Cell[16356, 508, 183, 4, 70, "MathCaption",
      CellTags->{"S5.56.1", "1.11"}]},
  "1.12"->{
    Cell[17838, 588, 209, 5, 70, "Text",
      CellTags->{"S5.56.1", "1.12"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.56.1", 18686, 612},
  {"1.1", 20893, 671},
  {"1.2", 20987, 674},
  {"1.3", 21075, 677},
  {"1.4", 21165, 680},
  {"1.5", 21260, 683},
  {"1.6", 21357, 686},
  {"1.7", 21453, 689},
  {"1.8", 21549, 692},
  {"1.9", 21638, 695},
  {"1.10", 21730, 698},
  {"1.11", 21822, 701},
  {"1.12", 21921, 704}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 137, 6, 36, "Subsection",
  CellTags->{"S5.56.1", "1.1"}],
Cell[1916, 61, 405, 7, 72, "Text",
  CellTags->{"S5.56.1", "1.2"}],
Cell[2324, 70, 3496, 108, 102, "DefinitionBox",
  CellTags->"S5.56.1"],
Cell[5823, 180, 94, 1, 15, "Caption",
  CellTags->"S5.56.1"],
Cell[5920, 183, 925, 28, 56, "Text",
  CellTags->{"S5.56.1", "1.3"}],
Cell[6848, 213, 78, 1, 40, "MathCaption",
  CellTags->{"S5.56.1", "1.4"}],
Cell[6929, 216, 88, 2, 28, "Input",
  CellTags->"S5.56.1"],
Cell[7020, 220, 636, 19, 56, "MathCaption",
  CellTags->{"S5.56.1", "1.5"}],

Cell[CellGroupData[{
Cell[7681, 243, 102, 2, 28, "Input",
  CellTags->"S5.56.1"],
Cell[7786, 247, 91, 2, 25, "Output",
  CellTags->"S5.56.1"]
}, Open  ]],
Cell[7892, 252, 133, 3, 40, "MathCaption",
  CellTags->{"S5.56.1", "1.6"}],

Cell[CellGroupData[{
Cell[8050, 259, 103, 2, 28, "Input",
  CellTags->"S5.56.1"],
Cell[8156, 263, 91, 2, 22, "Output",
  CellTags->"S5.56.1"]
}, Open  ]],
Cell[8262, 268, 101, 1, 40, "MathCaption",
  CellTags->{"S5.56.1", "1.7"}],

Cell[CellGroupData[{
Cell[8388, 273, 69, 2, 28, "Input",
  CellTags->"S5.56.1"],
Cell[8460, 277, 107, 3, 25, "Output",
  CellTags->"S5.56.1"]
}, Open  ]],
Cell[8582, 283, 400, 8, 70, "Text",
  CellTags->{"S5.56.1", "1.8"}],
Cell[8985, 293, 2036, 60, 70, "DefinitionBox",
  CellTags->"S5.56.1"],
Cell[11024, 355, 97, 1, 70, "Caption",
  CellTags->"S5.56.1"],
Cell[11124, 358, 503, 12, 70, "Text",
  CellTags->{"S5.56.1", "1.9"}],
Cell[11630, 372, 4409, 124, 70, "DefinitionBox",
  CellTags->"S5.56.1"],
Cell[16042, 498, 92, 1, 70, "Caption",
  CellTags->"S5.56.1"],
Cell[16137, 501, 216, 5, 70, "Text",
  CellTags->{"S5.56.1", "1.10"}],
Cell[16356, 508, 183, 4, 70, "MathCaption",
  CellTags->{"S5.56.1", "1.11"}],

Cell[CellGroupData[{
Cell[16564, 516, 234, 8, 70, "Input",
  CellTags->"S5.56.1"],
Cell[16801, 526, 839, 51, 70, 768, 48, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.56.1"],
Cell[17643, 579, 180, 6, 70, "Output",
  CellTags->"S5.56.1"]
}, Open  ]],
Cell[17838, 588, 209, 5, 70, "Text",
  CellTags->{"S5.56.1", "1.12"}]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

