(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    634554,      26939]*)
(*NotebookOutlinePosition[    637593,      27030]*)
(*  CellTagsIndexPosition[    637241,      27014]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["DiscreteMath`GraphPlot", "Section",
  CellTags->"i:1"],

Cell[TextData[{
  StyleBox["DiscreteMath`GraphPlot",
    FontFamily->"Courier"],
  " provides functions for aesthetic straight-line drawing of graphs. The \
package also contains a number of functions useful for graph theory \
applications. The functions are designed to work efficiently for very large \
graphs. "
}], "Text"],

Cell[TextData[{
  "In this package, a graph is represented by its adjacency matrix. Graphs \
from the ",
  StyleBox["Combinatorica",
    FontSlant->"Italic"],
  " package are also supported, as are graphs specified by a rule list."
}], "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["GraphPlot",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox[\(g, \ options\),
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            Cell["\<\
calculates a visually appealing two-dimensional layout \
and plots the graph using this layout\
\>", "Text"]},
          {
            RowBox[{
              RowBox[{
                StyleBox["GraphPlot3D",
                  "MR"], 
                StyleBox["[",
                  "MR"], 
                RowBox[{
                  StyleBox["g",
                    "TI"], ",", " ", 
                  StyleBox["options",
                    FontSlant->"Italic"]}], 
                StyleBox["]",
                  "MR"]}], " "}], 
            Cell["\<\
calculates a visually appealing three-dimensional \
layout and plots the graph using this layout\
\>", "Text"]}
          }], TextForm]], "DefinitionBox",
  CellTags->"i:2"],

Cell["Graph drawing functions.", "Caption"],

Cell["This loads the package.", "MathCaption"],

Cell[BoxData[
    \(\(<< DiscreteMath`GraphPlot`;\)\)], "Input",
  CellLabel->"In[1]:="],

Cell["This plots a graph specified by a rule list.", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(GraphPlot[{1 \[Rule] 2, 2 \[Rule] 3, 3 \[Rule] 4, 4 \[Rule] 5, 
          5 \[Rule] 6, 6 \[Rule] 7, 7 \[Rule] 8, 8 \[Rule] 1, 1 \[Rule] 9, 
          2 \[Rule] 9, 3 \[Rule] 10, 4 \[Rule] 10, 6 \[Rule] 11, 
          5 \[Rule] 11, 7 \[Rule] 12, 8 \[Rule] 12}, 
        EdgeStyleFunction \[Rule] \((Arrow[{#1, #2}] &)\)];\)\)], "Input",
  CellLabel->"In[2]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.00049 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.500059 0.476618 0.500046 0.476618 [
[ 0 0 0 0 ]
[ 1 1.00049 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
% Start of user PostScript
/mathtops {
gsave
MBeginOrig
moveto
MEndOrig
currentpoint
grestore
} bind def
/MAtocoords {
mathtops 4 2 roll mathtops
4 copy pop pop
3 -1 roll sub
/arry exch def
exch sub
/arrx exch def
arrx dup mul
arry dup mul
add sqrt
/arrl exch def
translate
} bind def
/MAarrowhead1 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto fill
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto
-0.05 0.0125 lineto stroke
} ifelse
grestore
} def
% End of user PostScript
0 g
.5 Mabswid
[ ] 0 setdash
.70632 .92693 m
.93547 .68776 L
s
% Start of user PostScript
0.43276074 0.89565406 0.91353952 0.39383861 MAarrowhead1
% End of user PostScript
.70632 .92693 m
.97619 .95607 L
s
% Start of user PostScript
0.43276074 0.89565406 0.99897837 0.95678822 MAarrowhead1
% End of user PostScript
.93547 .68776 m
.9269 .29357 L
s
% Start of user PostScript
0.91353952 0.39383861 0.89556412 -0.43320108 MAarrowhead1
% End of user PostScript
.93547 .68776 m
.97619 .95607 L
s
% Start of user PostScript
0.91353952 0.39383861 0.99897837 0.95678822 MAarrowhead1
% End of user PostScript
.9269 .29357 m
.68778 .06455 L
s
% Start of user PostScript
0.89556412 -0.43320108 0.39386647 -0.91373048 MAarrowhead1
% End of user PostScript
.9269 .29357 m
.95591 .02382 L
s
% Start of user PostScript
0.89556412 -0.43320108 0.95641763 -0.99917576 MAarrowhead1
% End of user PostScript
.68778 .06455 m
.29361 .07314 L
s
% Start of user PostScript
0.39386647 -0.91373048 -0.4331522 -0.89569758 MAarrowhead1
% End of user PostScript
.68778 .06455 m
.95591 .02382 L
s
% Start of user PostScript
0.39386647 -0.91373048 0.95641763 -0.99917576 MAarrowhead1
% End of user PostScript
.29361 .07314 m
.06471 .31249 L
s
% Start of user PostScript
-0.4331522 -0.89569758 -0.9134131 -0.3935224 MAarrowhead1
% End of user PostScript
.29361 .07314 m
.02381 .04421 L
s
% Start of user PostScript
-0.4331522 -0.89569758 -0.99922716 -0.95639843 MAarrowhead1
% End of user PostScript
.06471 .31249 m
.07317 .70683 L
s
% Start of user PostScript
-0.9134131 -0.3935224 -0.89566944 0.43385747 MAarrowhead1
% End of user PostScript
.06471 .31249 m
.02381 .04421 L
s
% Start of user PostScript
-0.9134131 -0.3935224 -0.99922716 -0.95639843 MAarrowhead1
% End of user PostScript
.07317 .70683 m
.31245 .93564 L
s
% Start of user PostScript
-0.89566944 0.43385747 -0.39361762 0.91393475 MAarrowhead1
% End of user PostScript
.07317 .70683 m
.04425 .97666 L
s
% Start of user PostScript
-0.89566944 0.43385747 -0.95634635 1. MAarrowhead1
% End of user PostScript
.31245 .93564 m
.70632 .92693 L
s
% Start of user PostScript
-0.39361762 0.91393475 0.43276074 0.89565406 MAarrowhead1
% End of user PostScript
.31245 .93564 m
.04425 .97666 L
s
% Start of user PostScript
-0.39361762 0.91393475 -0.95634635 1. MAarrowhead1
% End of user PostScript
.008 w
.70632 .92693 Mdot
.93547 .68776 Mdot
.9269 .29357 Mdot
.68778 .06455 Mdot
.29361 .07314 Mdot
.06471 .31249 Mdot
.07317 .70683 Mdot
.31245 .93564 Mdot
.97619 .95607 Mdot
.95591 .02382 Mdot
.02381 .04421 Mdot
.04425 .97666 Mdot
0 0 m
1 0 L
1 1.00049 L
0 1.00049 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[2]:=",
  ImageSize->{287.813, 287.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004O00017b000`400?l00000o`00003oo`3ooolP
0?ooo`00o`3ooolP0?ooo`00o`3ooolP0?ooo`00o`3ooolP0?ooo`00o`3ooolP0?ooo`00o`3oool4
0?ooo`P00000503oool00?l0oooo103oool@000000`0oooo003o0?ooo`@0oooo4000000<0?ooo`00
o`3oool30?ooo`d000000P3oool2000000`0oooo003l0?ooo`H000000P3oool9000000@0oooo0P00
000<0?ooo`004P3oool400000>00oooo1P0000080?ooo`H000001`3oool3000000/0oooo000:0?oo
o``00000f@3oool7000000h0oooo100000080?ooo`@000002`3oool000H0oooo4000003C0?ooo`H0
00005@3oool2000000X0oooo1000000;0?ooo`001P3oool00`000000oooo0000000=00000<`0oooo
1`00000V0?ooo`D000002`3oool000H0oooo0P0000030?oooa400000`03oool6000002d0oooo1@00
000;0?ooo`001P3oool2000000D0oooo200000070?ooo`T00000/@3oool6000003<0oooo1@00000;
0?ooo`001P3oool3000000L0oooo1@00000@0?ooo`P00000XP3oool7000003P0oooo1P00000;0?oo
o`001P3oool3000000X0oooo0P00000H0?ooo`T00000:`3oool2000006H0oooo1P00000o0?ooo`H0
00002`3oool000H0oooo1000000/0?ooo`T000007P3oool600000500oooo5P0000150?ooo`L00000
2P3oool000H0oooo1000000e0?ooo`P000004`3oool9000002X0oooo9P00000A0?ooo`040000003o
ool00000000004D0oooo2000000:0?ooo`001@3oool5000003d0oooo2@0000030?ooo`030000003o
ool0oooo00d00000103ooolV000003T0oooo100000130?ooo`P000002P3oool000D0oooo1P000015
0?oooaL00000H03oool5000004@0oooo1@00000:0?ooo`001@3oool6000004P0oooo00@000000?oo
o`3oool0oooo3000001T0?ooo`L00000@P3oool00`000000oooo0?ooo`0<0?ooo`001@3oool70000
04H0oooo00<000000?ooo`3oool01P3oool8000006D0oooo200000100?ooo`030000003oool0oooo
00`0oooo00050?ooo`L00000A@3oool00`000000oooo0?ooo`0<0?ooo`<00000IP3oool9000003h0
oooo00<000000?ooo`3oool0303oool000D0oooo200000130?ooo`030000003oool0oooo07H0oooo
2P00000m0?ooo`030000003oool0oooo00`0oooo00050?ooo`P00000@P3oool00`000000oooo0?oo
o`1h0?ooo`P00000?P3oool00`000000oooo0?ooo`0<0?ooo`001@3oool4000004D0oooo00<00000
0?ooo`3oool0NP3oool6000003l0oooo00<000000?ooo`3oool0303oool000P0oooo00<000000?oo
o`3oool0@P3oool00`000000oooo0?ooo`1k0?ooo`D00000?`3oool00`000000oooo0?ooo`0=0?oo
o`002@3oool00`000000oooo0?ooo`100?ooo`030000003oool0oooo07d0oooo1@00000n0?ooo`03
0000003oool0oooo00d0oooo00090?ooo`030000003oool0oooo03l0oooo00<000000?ooo`3oool0
OP3oool300000080oooo00<000000?ooo`3oool0>`3oool00`000000oooo0?ooo`0=0?ooo`002@3o
ool00`000000oooo0?ooo`0n0?ooo`030000003oool0oooo0800oooo00<000000?ooo`3oool00P3o
ool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo00d0oooo00090?ooo`030000003oool0
oooo03d0oooo00<000000?ooo`3oool0Q`3oool00`000000oooo0?ooo`0i0?ooo`030000003oool0
oooo00d0oooo00090?ooo`030000003oool0oooo03`0oooo00<000000?ooo`3oool0R@3oool00`00
0000oooo0?ooo`0h0?ooo`030000003oool0oooo00d0oooo00090?ooo`030000003oool0oooo03/0
oooo00<000000?ooo`3oool0R`3oool00`000000oooo0?ooo`0g0?ooo`030000003oool0oooo00d0
oooo000:0?ooo`030000003oool0oooo03T0oooo00<000000?ooo`3oool0S@3oool2000003L0oooo
00<000000?ooo`3oool03@3oool000X0oooo00<000000?ooo`3oool0>03oool00`000000oooo0?oo
o`2@0?ooo`030000003oool0oooo03@0oooo00<000000?ooo`3oool03@3oool000X0oooo00<00000
0?ooo`3oool0=`3oool00`000000oooo0?ooo`2B0?ooo`030000003oool0oooo0380oooo00<00000
0?ooo`3oool03P3oool000X0oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`2D0?oo
o`030000003oool0oooo0340oooo00<000000?ooo`3oool03P3oool000X0oooo00<000000?ooo`3o
ool0=P3oool00`000000oooo0?ooo`2E0?ooo`030000003oool0oooo0300oooo00<000000?ooo`3o
ool03P3oool000X0oooo00<000000?ooo`3oool0=@3oool00`000000oooo0?ooo`2G0?ooo`030000
003oool0oooo02l0oooo00<000000?ooo`3oool03P3oool000/0oooo00<000000?ooo`3oool0<`3o
ool00`000000oooo0?ooo`2I0?ooo`030000003oool0oooo02h0oooo00<000000?ooo`3oool03P3o
ool000/0oooo00<000000?ooo`3oool0<P3oool00`000000oooo0?ooo`2K0?ooo`030000003oool0
oooo02d0oooo00<000000?ooo`3oool03P3oool000/0oooo00<000000?ooo`3oool0<@3oool00`00
0000oooo0?ooo`2M0?ooo`030000003oool0oooo02`0oooo00<000000?ooo`3oool03P3oool000/0
oooo00<000000?ooo`3oool0<03oool00`000000oooo0?ooo`2O0?ooo`030000003oool0oooo02/0
oooo00<000000?ooo`3oool03P3oool000/0oooo00<000000?ooo`3oool0;`3oool00`000000oooo
0?ooo`2Q0?ooo`030000003oool0oooo02T0oooo00<000000?ooo`3oool03`3oool000/0oooo00<0
00000?ooo`3oool0;P3oool00`000000oooo0?ooo`2S0?ooo`030000003oool0oooo02P0oooo00<0
00000?ooo`3oool03`3oool000/0oooo00<000000?ooo`3oool0;@3oool00`000000oooo0?ooo`2U
0?ooo`030000003oool0oooo02L0oooo00<000000?ooo`3oool03`3oool000`0oooo00<000000?oo
o`3oool0:`3oool00`000000oooo0?ooo`2W0?ooo`030000003oool0oooo02H0oooo00<000000?oo
o`3oool03`3oool000`0oooo00<000000?ooo`3oool0:P3oool00`000000oooo0?ooo`2Y0?ooo`03
0000003oool0oooo02D0oooo00<000000?ooo`3oool03`3oool000`0oooo00<000000?ooo`3oool0
:@3oool00`000000oooo0?ooo`2[0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool0
3`3oool000`0oooo00<000000?ooo`3oool0:03oool00`000000oooo0?ooo`2]0?ooo`030000003o
ool0oooo02<0oooo00<000000?ooo`3oool03`3oool000`0oooo00<000000?ooo`3oool09`3oool0
0`000000oooo0?ooo`2_0?ooo`030000003oool0oooo0280oooo00<000000?ooo`3oool03`3oool0
00`0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`2a0?ooo`030000003oool0oooo
0240oooo00<000000?ooo`3oool03`3oool000d0oooo00<000000?ooo`3oool0903oool00`000000
oooo0?ooo`2c0?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3oool0403oool000d0oooo
00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`2e0?ooo`030000003oool0oooo01h0oooo
00<000000?ooo`3oool0403oool000d0oooo00<000000?ooo`3oool08P3oool00`000000oooo0?oo
o`2g0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool0403oool000d0oooo00<00000
0?ooo`3oool08@3oool00`000000oooo0?ooo`2i0?ooo`030000003oool0oooo01`0oooo00<00000
0?ooo`3oool0403oool000d0oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`2k0?oo
o`030000003oool0oooo01/0oooo00<000000?ooo`3oool0403oool000d0oooo00<000000?ooo`3o
ool07`3oool00`000000oooo0?ooo`2m0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3o
ool0403oool000d0oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`2o0?ooo`030000
003oool0oooo01T0oooo00<000000?ooo`3oool0403oool000h0oooo00<000000?ooo`3oool0703o
ool00`000000oooo0?ooo`310?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0403o
ool000h0oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`330?ooo`030000003oool0
oooo01L0oooo00<000000?ooo`3oool0403oool000h0oooo00<000000?ooo`3oool06P3oool00`00
0000oooo0?ooo`350?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool04@3oool000h0
oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`370?ooo`030000003oool0oooo01@0
oooo00<000000?ooo`3oool04@3oool000h0oooo00<000000?ooo`3oool0603oool00`000000oooo
0?ooo`390?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool04@3oool000h0oooo00<0
00000?ooo`3oool05`3oool00`000000oooo0?ooo`3;0?ooo`030000003oool0oooo0180oooo00<0
00000?ooo`3oool04@3oool000l0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`3=
0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool04@3oool000l0oooo00<000000?oo
o`3oool0503oool00`000000oooo0?ooo`3?0?ooo`8000004@3oool00`000000oooo0?ooo`0A0?oo
o`003`3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo0=80oooo00<000000?ooo`3o
ool03P3oool00`000000oooo0?ooo`0A0?ooo`003`3oool00`000000oooo0?ooo`0B0?ooo`030000
003oool0oooo0=@0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0A0?ooo`003`3o
ool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0=H0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0B0?ooo`003`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0
oooo0=P0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0B0?ooo`00403oool00`00
0000oooo0?ooo`0?0?ooo`030000003oool0oooo0=T0oooo00<000000?ooo`3oool02@3oool00`00
0000oooo0?ooo`0B0?ooo`00403oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo0=/0
oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0B0?ooo`00403oool00`000000oooo
0?ooo`0=0?ooo`030000003oool0oooo0=d0oooo00<000000?ooo`3oool01`3oool00`000000oooo
0?ooo`0B0?ooo`00403oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`3oool0g`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0180oooo000@
0?ooo`030000003oool0oooo00D0oooo0`0000030?ooo`030000003oool0oooo0>40oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`0B0?ooo`00403oool00`000000oooo0?ooo`050?oo
o`@0000000<0oooo0000003oool0i03oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo
0180oooo000@0?ooo`030000003oool0oooo00@0oooo1`00003V0?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`3oool04P3oool00140oooo00<000000?ooo`3oool00`3oool800000>H0oooo
00D000000?ooo`3oool0oooo0000000E0?ooo`004@3oool00`000000oooo0?ooo`020?ooo`X00000
iP3oool010000000oooo0?ooo`00000E0?ooo`004@3oool00`000000oooo0?ooo`020?ooo`T00000
j03oool00`000000oooo0000000E0?ooo`004@3oool010000000oooo0?ooo`3oool800000>/0oooo
0P00000E0?ooo`004@3oool010000000oooo0?ooo`3oool600000>h0oooo00<000000?ooo`3oool0
4`3oool00140oooo00<000000?ooo`3oool01P00003_0?ooo`030000003oool0oooo01<0oooo000B
0?ooo`030000003oool0000000<00000l@3oool2000001@0oooo000B0?ooo`D00000l@3oool30000
01@0oooo000B0?ooo`<00000l`3oool3000001@0oooo000A0?ooo`800000m@3oool3000001@0oooo
000A0?ooo`800000m@3oool4000001<0oooo000B0?ooo`030000003oool0oooo0?80oooo1@00000C
0?ooo`004P3oool00`000000oooo0?ooo`3b0?ooo`D000004`3oool00180oooo00<000000?ooo`3o
ool0lP3oool600000180oooo000B0?ooo`030000003oool0oooo0?80oooo1P00000B0?ooo`004P3o
ool00`000000oooo0?ooo`3b0?ooo`H000004P3oool00180oooo00<000000?ooo`3oool0l@3oool7
00000180oooo000B0?ooo`030000003oool0oooo0?40oooo2000000A0?ooo`004P3oool00`000000
oooo0?ooo`3a0?ooo`P000004@3oool00180oooo00<000000?ooo`3oool0m03oool00`000000oooo
0?ooo`0C0?ooo`004P3oool00`000000oooo0?ooo`3d0?ooo`030000003oool0oooo01<0oooo000B
0?ooo`030000003oool0oooo0?@0oooo00<000000?ooo`3oool04`3oool00180oooo00<000000?oo
o`3oool0m03oool00`000000oooo0?ooo`0C0?ooo`004P3oool00`000000oooo0?ooo`3e0?ooo`03
0000003oool0oooo0180oooo000B0?ooo`030000003oool0oooo0?D0oooo00<000000?ooo`3oool0
4P3oool00180oooo00<000000?ooo`3oool0m@3oool00`000000oooo0?ooo`0B0?ooo`004P3oool0
0`000000oooo0?ooo`3e0?ooo`030000003oool0oooo0180oooo000B0?ooo`030000003oool0oooo
0?D0oooo00<000000?ooo`3oool04P3oool00180oooo00<000000?ooo`3oool0m@3oool00`000000
oooo0?ooo`0B0?ooo`004P3oool00`000000oooo0?ooo`3e0?ooo`030000003oool0oooo0180oooo
000B0?ooo`030000003oool0oooo0?D0oooo00<000000?ooo`3oool04P3oool00180oooo00<00000
0?ooo`3oool0m@3oool00`000000oooo0?ooo`0B0?ooo`004P3oool00`000000oooo0?ooo`3e0?oo
o`030000003oool0oooo0180oooo000B0?ooo`030000003oool0oooo0?D0oooo00<000000?ooo`3o
ool04P3oool00180oooo00<000000?ooo`3oool0m@3oool00`000000oooo0?ooo`0B0?ooo`004P3o
ool00`000000oooo0?ooo`3e0?ooo`030000003oool0oooo0180oooo000B0?ooo`030000003oool0
oooo0?D0oooo00<000000?ooo`3oool04P3oool00180oooo00<000000?ooo`3oool0m@3oool00`00
0000oooo0?ooo`0B0?ooo`004`3oool00`000000oooo0?ooo`3d0?ooo`030000003oool0oooo0180
oooo000C0?ooo`030000003oool0oooo0?@0oooo00<000000?ooo`3oool04P3oool001<0oooo00<0
00000?ooo`3oool0m03oool00`000000oooo0?ooo`0B0?ooo`004`3oool00`000000oooo0?ooo`3d
0?ooo`030000003oool0oooo0180oooo000C0?ooo`030000003oool0oooo0?@0oooo00<000000?oo
o`3oool04P3oool001<0oooo00<000000?ooo`3oool0m03oool00`000000oooo0?ooo`0B0?ooo`00
4`3oool00`000000oooo0?ooo`3d0?ooo`030000003oool0oooo0180oooo000C0?ooo`030000003o
ool0oooo0?@0oooo00<000000?ooo`3oool04P3oool001<0oooo00<000000?ooo`3oool0m03oool0
0`000000oooo0?ooo`0B0?ooo`004`3oool00`000000oooo0?ooo`3d0?ooo`030000003oool0oooo
0180oooo000C0?ooo`030000003oool0oooo0?@0oooo00<000000?ooo`3oool04P3oool001<0oooo
00<000000?ooo`3oool0m03oool00`000000oooo0?ooo`0B0?ooo`004`3oool00`000000oooo0?oo
o`3d0?ooo`030000003oool0oooo0180oooo000C0?ooo`030000003oool0oooo0?@0oooo00<00000
0?ooo`3oool04P3oool001<0oooo00<000000?ooo`3oool0m03oool00`000000oooo0?ooo`0B0?oo
o`004`3oool00`000000oooo0?ooo`3d0?ooo`030000003oool0oooo0180oooo000C0?ooo`030000
003oool0oooo0?@0oooo00<000000?ooo`3oool04P3oool001<0oooo00<000000?ooo`3oool0m03o
ool00`000000oooo0?ooo`0B0?ooo`004`3oool00`000000oooo0?ooo`3d0?ooo`030000003oool0
oooo0180oooo000C0?ooo`030000003oool0oooo0?@0oooo00<000000?ooo`3oool04P3oool001<0
oooo00<000000?ooo`3oool0m03oool00`000000oooo0?ooo`0B0?ooo`004`3oool00`000000oooo
0?ooo`3d0?ooo`030000003oool0oooo0180oooo000C0?ooo`030000003oool0oooo0?@0oooo00<0
00000?ooo`3oool04P3oool001<0oooo00<000000?ooo`3oool0m@3oool00`000000oooo0?ooo`0A
0?ooo`004`3oool00`000000oooo0?ooo`3e0?ooo`030000003oool0oooo0140oooo000C0?ooo`03
0000003oool0oooo0?D0oooo00<000000?ooo`3oool04@3oool001<0oooo00<000000?ooo`3oool0
m@3oool00`000000oooo0?ooo`0A0?ooo`004`3oool00`000000oooo0?ooo`3e0?ooo`030000003o
ool0oooo0140oooo000C0?ooo`030000003oool0oooo0?D0oooo00<000000?ooo`3oool04@3oool0
01<0oooo00<000000?ooo`3oool0m@3oool00`000000oooo0?ooo`0A0?ooo`004`3oool00`000000
oooo0?ooo`3e0?ooo`030000003oool0oooo0140oooo000C0?ooo`030000003oool0oooo0?D0oooo
00<000000?ooo`3oool04@3oool001<0oooo00<000000?ooo`3oool0m@3oool00`000000oooo0?oo
o`0A0?ooo`004`3oool00`000000oooo0?ooo`3e0?ooo`030000003oool0oooo0140oooo000C0?oo
o`030000003oool0oooo0?D0oooo00<000000?ooo`3oool04@3oool001<0oooo00<000000?ooo`3o
ool0m@3oool00`000000oooo0?ooo`0A0?ooo`004`3oool00`000000oooo0?ooo`3e0?ooo`030000
003oool0oooo0140oooo000C0?ooo`030000003oool0oooo0?D0oooo00<000000?ooo`3oool04@3o
ool001<0oooo00<000000?ooo`3oool0m@3oool00`000000oooo0?ooo`0A0?ooo`004`3oool00`00
0000oooo0?ooo`3e0?ooo`030000003oool0oooo0140oooo000C0?ooo`030000003oool0oooo0?D0
oooo00<000000?ooo`3oool04@3oool001<0oooo00<000000?ooo`3oool0m@3oool00`000000oooo
0?ooo`0A0?ooo`004`3oool00`000000oooo0?ooo`3e0?ooo`030000003oool0oooo0140oooo000C
0?ooo`030000003oool0oooo0?D0oooo00<000000?ooo`3oool04@3oool001<0oooo00<000000?oo
o`3oool0m@3oool00`000000oooo0?ooo`0A0?ooo`004`3oool00`000000oooo0?ooo`3e0?ooo`03
0000003oool0oooo0140oooo000C0?ooo`030000003oool0oooo0?D0oooo00<000000?ooo`3oool0
4@3oool001<0oooo00<000000?ooo`3oool0m@3oool00`000000oooo0?ooo`0A0?ooo`004`3oool0
0`000000oooo0?ooo`3e0?ooo`030000003oool0oooo0140oooo000C0?ooo`030000003oool0oooo
0?D0oooo00<000000?ooo`3oool04@3oool001<0oooo00<000000?ooo`3oool0m@3oool00`000000
oooo0?ooo`0A0?ooo`004`3oool00`000000oooo0?ooo`3e0?ooo`030000003oool0oooo0140oooo
000C0?ooo`030000003oool0oooo0?D0oooo00<000000?ooo`3oool04@3oool001<0oooo00<00000
0?ooo`3oool0m@3oool00`000000oooo0?ooo`0A0?ooo`004`3oool00`000000oooo0?ooo`3e0?oo
o`030000003oool0oooo0140oooo000C0?ooo`030000003oool0oooo0?D0oooo00<000000?ooo`3o
ool04@3oool001@0oooo00<000000?ooo`3oool0m03oool00`000000oooo0?ooo`0A0?ooo`00503o
ool00`000000oooo0?ooo`3d0?ooo`030000003oool0oooo0140oooo000D0?ooo`030000003oool0
oooo0?@0oooo00<000000?ooo`3oool04@3oool001@0oooo00<000000?ooo`3oool0m03oool00`00
0000oooo0?ooo`0A0?ooo`00503oool00`000000oooo0?ooo`3d0?ooo`030000003oool0oooo0140
oooo000D0?ooo`030000003oool0oooo0?D0oooo00<000000?ooo`3oool0403oool001@0oooo00<0
00000?ooo`3oool0m@3oool00`000000oooo0?ooo`0@0?ooo`00503oool00`000000oooo0?ooo`3e
0?ooo`030000003oool0oooo0100oooo000D0?ooo`030000003oool0oooo0?D0oooo00<000000?oo
o`3oool0403oool001@0oooo00<000000?ooo`3oool0m@3oool00`000000oooo0?ooo`0@0?ooo`00
503oool00`000000oooo0?ooo`3e0?ooo`030000003oool0oooo0100oooo000D0?ooo`030000003o
ool0oooo0?D0oooo00<000000?ooo`3oool0403oool001@0oooo00<000000?ooo`3oool0m@3oool0
0`000000oooo0?ooo`0@0?ooo`00503oool00`000000oooo0?ooo`3e0?ooo`030000003oool0oooo
0100oooo000A0?ooo`P00000l`3oool00`000000oooo0?ooo`0@0?ooo`004@3oool800000?<0oooo
00<000000?ooo`3oool0403oool00140oooo1`00003d0?ooo`030000003oool0oooo0100oooo000B
0?ooo`H00000m03oool00`000000oooo0?ooo`0@0?ooo`004P3oool600000?@0oooo00<000000?oo
o`3oool0403oool00180oooo1P00003d0?ooo`030000003oool0oooo0100oooo000B0?ooo`D00000
m@3oool00`000000oooo0?ooo`0@0?ooo`004P3oool500000?D0oooo00<000000?ooo`3oool0403o
ool001<0oooo1000003d0?ooo`8000004P3oool001<0oooo0`00003e0?ooo`8000004P3oool001<0
oooo0`00003d0?ooo`<000004P3oool001<0oooo0`00003b0?ooo`D000004P3oool001@0oooo0P00
003a0?ooo`@0000000<0oooo0000003oool04@3oool001@0oooo00<000000?ooo`3oool0kP3oool6
00000080oooo00<000000?ooo`3oool03`3oool001@0oooo00<000000?ooo`3oool0k@3oool60000
00<0oooo00<000000?ooo`3oool03`3oool001@0oooo0P00003/0?ooo`L00000103oool00`000000
oooo0?ooo`0?0?ooo`00503oool00`000000oooo0000003Y0?ooo`T00000103oool00`000000oooo
0?ooo`0?0?ooo`00503oool010000000oooo0?ooo`00003W0?ooo`T000001@3oool00`000000oooo
0?ooo`0?0?ooo`00503oool01@000000oooo0?ooo`3oool000000>L0oooo1`0000060?ooo`030000
003oool0oooo00l0oooo000C0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0i@3o
ool6000000H0oooo00<000000?ooo`3oool03`3oool001<0oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`3T0?ooo`D00000203oool00`000000oooo0?ooo`0>0?ooo`004`3oool00`00
0000oooo0?ooo`050?ooo`030000003oool0oooo0>80oooo00<000000?ooo`3oool00`0000080?oo
o`030000003oool0oooo00h0oooo000C0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3o
ool0h03oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3o
ool03P3oool001<0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`3N0?ooo`030000
003oool0oooo00d0oooo00<000000?ooo`3oool03P3oool001<0oooo00<000000?ooo`3oool0203o
ool00`000000oooo0?ooo`3L0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3o
ool001<0oooo00<000000?ooo`3oool02@3oool200000=/0oooo00<000000?ooo`3oool03`3oool0
0`000000oooo0?ooo`0>0?ooo`004`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
0=L0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0>0?ooo`004`3oool00`000000
oooo0?ooo`0<0?ooo`030000003oool0oooo0=H0oooo00<000000?ooo`3oool04@3oool00`000000
oooo0?ooo`0=0?ooo`004`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo0=@0oooo
00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0=0?ooo`004P3oool00`000000oooo0?oo
o`0?0?ooo`030000003oool0oooo0=80oooo00<000000?ooo`3oool04`3oool00`000000oooo0?oo
o`0=0?ooo`004P3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0=00oooo00<00000
0?ooo`3oool0503oool00`000000oooo0?ooo`0=0?ooo`004P3oool00`000000oooo0?ooo`0A0?oo
o`030000003oool0oooo0<h0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0=0?oo
o`004P3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo0<`0oooo00<000000?ooo`3o
ool05P3oool00`000000oooo0?ooo`0=0?ooo`004P3oool00`000000oooo0?ooo`0C0?ooo`030000
003oool0oooo0<X0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0=0?ooo`004P3o
ool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo0<P0oooo00<000000?ooo`3oool06@3o
ool00`000000oooo0?ooo`0<0?ooo`004P3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0
oooo0<H0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`0<0?ooo`004P3oool00`00
0000oooo0?ooo`0F0?ooo`030000003oool0oooo0<@0oooo00<000000?ooo`3oool06`3oool00`00
0000oooo0?ooo`0<0?ooo`004P3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo0<80
oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`0<0?ooo`004P3oool00`000000oooo
0?ooo`0H0?ooo`030000003oool0oooo0<00oooo00<000000?ooo`3oool07@3oool00`000000oooo
0?ooo`0<0?ooo`004@3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo0;h0oooo00<0
00000?ooo`3oool07P3oool00`000000oooo0?ooo`0<0?ooo`004@3oool00`000000oooo0?ooo`0K
0?ooo`030000003oool0oooo0;`0oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`0<
0?ooo`004@3oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo0;X0oooo00<000000?oo
o`3oool08@3oool00`000000oooo0?ooo`0;0?ooo`004@3oool00`000000oooo0?ooo`0M0?ooo`03
0000003oool0oooo0;P0oooo00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`0;0?ooo`00
4@3oool00`000000oooo0?ooo`0N0?ooo`030000003oool0oooo0;H0oooo00<000000?ooo`3oool0
8`3oool00`000000oooo0?ooo`0;0?ooo`004@3oool00`000000oooo0?ooo`0O0?ooo`030000003o
ool0oooo0;@0oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`0;0?ooo`004@3oool0
0`000000oooo0?ooo`0P0?ooo`030000003oool0oooo0;80oooo00<000000?ooo`3oool09@3oool0
0`000000oooo0?ooo`0;0?ooo`004@3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo
0;00oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0;0?ooo`004@3oool00`000000
oooo0?ooo`0R0?ooo`800000[`3oool00`000000oooo0?ooo`0W0?ooo`030000003oool0oooo00/0
oooo000A0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool0Z`3oool00`000000oooo
0?ooo`0Y0?ooo`030000003oool0oooo00X0oooo000@0?ooo`030000003oool0oooo02H0oooo00<0
00000?ooo`3oool0Z@3oool00`000000oooo0?ooo`0Z0?ooo`030000003oool0oooo00X0oooo000@
0?ooo`030000003oool0oooo02L0oooo00<000000?ooo`3oool0Y`3oool00`000000oooo0?ooo`0[
0?ooo`030000003oool0oooo00X0oooo000@0?ooo`030000003oool0oooo02P0oooo00<000000?oo
o`3oool0Y@3oool00`000000oooo0?ooo`0/0?ooo`030000003oool0oooo00X0oooo000@0?ooo`03
0000003oool0oooo02T0oooo00<000000?ooo`3oool0X`3oool00`000000oooo0?ooo`0]0?ooo`03
0000003oool0oooo00X0oooo000@0?ooo`030000003oool0oooo02X0oooo00<000000?ooo`3oool0
X@3oool00`000000oooo0?ooo`0^0?ooo`030000003oool0oooo00X0oooo000@0?ooo`030000003o
ool0oooo02/0oooo00<000000?ooo`3oool0W`3oool00`000000oooo0?ooo`0_0?ooo`030000003o
ool0oooo00X0oooo000@0?ooo`030000003oool0oooo02`0oooo00<000000?ooo`3oool0W@3oool0
0`000000oooo0?ooo`0a0?ooo`030000003oool0oooo00T0oooo000@0?ooo`030000003oool0oooo
02d0oooo00<000000?ooo`3oool0V`3oool00`000000oooo0?ooo`0b0?ooo`030000003oool0oooo
00T0oooo000@0?ooo`030000003oool0oooo02h0oooo00<000000?ooo`3oool0V@3oool00`000000
oooo0?ooo`0c0?ooo`030000003oool0oooo00T0oooo000?0?ooo`030000003oool0oooo0300oooo
00<000000?ooo`3oool0U`3oool00`000000oooo0?ooo`0d0?ooo`030000003oool0oooo00T0oooo
000?0?ooo`030000003oool0oooo0340oooo00<000000?ooo`3oool0U@3oool00`000000oooo0?oo
o`0e0?ooo`030000003oool0oooo00T0oooo000?0?ooo`030000003oool0oooo0380oooo00<00000
0?ooo`3oool0T`3oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo00T0oooo000?0?oo
o`030000003oool0oooo03<0oooo00<000000?ooo`3oool0TP3oool00`000000oooo0?ooo`0f0?oo
o`030000003oool0oooo00T0oooo000?0?ooo`030000003oool0oooo03@0oooo00<000000?ooo`3o
ool0T03oool00`000000oooo0?ooo`0h0?ooo`030000003oool0oooo00P0oooo000?0?ooo`030000
003oool0oooo03D0oooo00<000000?ooo`3oool0SP3oool00`000000oooo0?ooo`0i0?ooo`030000
003oool0oooo00P0oooo000?0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool0S03o
ool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo00P0oooo000?0?ooo`030000003oool0
oooo03L0oooo00<000000?ooo`3oool0RP3oool00`000000oooo0?ooo`0k0?ooo`030000003oool0
oooo00P0oooo000?0?ooo`030000003oool0oooo03P0oooo00<000000?ooo`3oool0R03oool00`00
0000oooo0?ooo`0l0?ooo`030000003oool0oooo00P0oooo000?0?ooo`030000003oool0oooo03T0
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`200?ooo`030000003oool0oooo03d0
oooo00<000000?ooo`3oool0203oool000h0oooo00<000000?ooo`3oool0>`3oool010000000oooo
0?ooo`3oool300000800oooo00<000000?ooo`3oool0?P3oool00`000000oooo0?ooo`080?ooo`00
3P3oool00`000000oooo0?ooo`0l0?ooo`H00000O`3oool00`000000oooo0?ooo`100?ooo`030000
003oool0oooo00L0oooo000>0?ooo`030000003oool0oooo03d0oooo1P00001m0?ooo`030000003o
ool0oooo0440oooo00<000000?ooo`3oool01`3oool000h0oooo00<000000?ooo`3oool0?@3oool6
000007`0oooo00<000000?ooo`3oool0@P3oool5000000D0oooo000>0?ooo`030000003oool0oooo
03`0oooo2000001j0?ooo`030000003oool0oooo0400oooo200000050?ooo`003P3oool00`000000
oooo0?ooo`0k0?ooo`X00000N03oool00`000000oooo0?ooo`110?ooo`P000001@3oool000h0oooo
00<000000?ooo`3oool0?03oool9000006H0oooo0`00000>0?ooo`030000003oool0oooo04<0oooo
1`0000050?ooo`003P3oool00`000000oooo0?ooo`0n0?ooo`P00000I@3oool7000000T0oooo00<0
00000?ooo`3oool0A03oool6000000H0oooo000>0?ooo`030000003oool0oooo0400oooo1`00001T
0?ooo``000000`3oool00`000000oooo0?ooo`150?ooo`H000001P3oool000X0oooo1@0000140?oo
o`D00000H03ooolG000004D0oooo1@0000060?ooo`002P3oool8000004<0oooo1000000i0?ooobH0
0000103oool>000000D0oooo2000000m0?ooo`D000001P3oool000X0oooo200000150?ooo`800000
4`3ooolV000002X0oooo2@00000B0?ooo`T00000=03oool5000000H0oooo000:0?ooo`L00000A@3o
oolF00000500oooo1P00000N0?ooo`P00000;@3oool4000000H0oooo000;0?ooo`H00000?`3oool6
00000080oooo00<000000?ooo`3oool0H@3oool2000002X0oooo2@00000I0?ooo`8000002@3oool4
000000H0oooo000;0?ooo`H00000>03oool700000:40oooo2@00000@0?ooo`@00000203oool30000
00H0oooo000;0?ooo`D00000<`3oool600000;40oooo200000080?ooo`L000001@3oool2000000L0
oooo000;0?ooo`D00000;@3oool600000;l0oooo4P0000020?ooo`8000001`3oool000/0oooo1000
000W0?ooo`L00000c03oool=000000030?ooo`000000oooo00H0oooo000;0?ooo`@000002P3oool2
000001D0oooo1P00003C0?ooo`l000001`3oool000/0oooo100000080?ooo`@000003P3oool70000
0=T0oooo2`00000;0?ooo`002`3oool3000000L0oooo1P0000080?ooo`H00000h03oool400000180
oooo000<0?ooo`800000103oool900000080oooo1P00003l0?ooo`00303oool200000080oooo3@00
003o0?ooo`<0oooo000<0?ooo`030000003oool0000000d00000o`3oool40?ooo`00303oool@0000
0?l0oooo103oool001@0oooo2000003o0?ooo`@0oooo003o0?ooob00oooo003o0?ooob00oooo003o
0?ooob00oooo003o0?ooob00oooo003o0?ooob00oooo0000\
\>"],
  ImageRangeCache->{{{0, 286.813}, {286.938, 0}} -> {-1.04925, -1.04917, \
0.00731576, 0.00731576}}]
}, Open  ]],

Cell[TextData[{
  StyleBox["GraphPlot", "MR"],
  " and ",
  StyleBox["GraphPlot3D", "MR"],
  " work with disconnected graphs. The individual components are laid out in \
a visually appealing way."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(n = 129;\)\), "\[IndentingNewLine]", 
    \(\(GraphPlot[Table[i \[Rule] Mod[i^2, n], {i, 0, n - 1}]];\)\)}], "Input",\

  CellLabel->"In[3]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .69642 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.138357 0.0233826 -0.178404 0.0233826 [
[ 0 0 0 0 ]
[ 1 .69642 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.39235 .24519 m
.39132 .29301 L
s
.39132 .29301 m
.3616 .34212 L
s
.05737 .32725 m
.09385 .32672 L
s
.09385 .32672 m
.11558 .2879 L
s
.3616 .34212 m
.41898 .3433 L
s
.08436 .47802 m
.10527 .51663 L
s
.10527 .51663 m
.17545 .52041 L
s
.6546 .07387 m
.63122 .07387 L
s
.63122 .07387 m
.6546 .07387 L
s
.63258 .36553 m
.64911 .33689 L
s
.64911 .33689 m
.63258 .30825 L
s
.57017 .57337 m
.6144 .56149 L
s
.6144 .56149 m
.67183 .56219 L
s
.11558 .2879 m
.16007 .28733 L
s
.31974 .58137 m
.35731 .6401 L
s
.35731 .6401 m
.42753 .63655 L
s
.60936 .64318 m
.6425 .61157 L
s
.6425 .61157 m
.6144 .56149 L
s
.97619 .5776 m
.9397 .57796 L
s
.9397 .57796 m
.91785 .61673 L
s
.20922 .58162 m
.17147 .64026 L
s
.17147 .64026 m
.10125 .63641 L
s
.45101 .67334 m
.42753 .63655 L
s
.42753 .63655 m
.46153 .57546 L
s
.91785 .61673 m
.87335 .61722 L
s
.41898 .3433 m
.39132 .29301 L
s
.44498 .47822 m
.42394 .51674 L
s
.42394 .51674 m
.35374 .52033 L
s
.21933 .32502 m
.18287 .32558 L
s
.18287 .32558 m
.16115 .36442 L
s
.49583 .59617 m
.46153 .57546 L
s
.46153 .57546 m
.42394 .51674 L
s
.24359 .56105 m
.20922 .58162 L
s
.91293 .31616 m
.89499 .34654 L
s
.89499 .34654 m
.87761 .31577 L
s
.71581 .57515 m
.67183 .56219 L
s
.67183 .56219 m
.6425 .61157 L
s
.24158 .60555 m
.20922 .58162 L
s
.85068 .5789 m
.87254 .5401 L
s
.87254 .5401 m
.91703 .53963 L
s
.17545 .52041 m
.20922 .58162 L
s
.45847 .49769 m
.42394 .51674 L
s
.18828 .10206 m
.15612 .08392 L
s
.15612 .08392 m
.12082 .08423 L
s
.28545 .5607 m
.31974 .58137 L
s
.42692 .67551 m
.42753 .63655 L
s
.09882 .39684 m
.11662 .36498 L
s
.11662 .36498 m
.09385 .32672 L
s
.35374 .52033 m
.31974 .58137 L
s
.64191 .65945 m
.6425 .61157 L
s
.85543 .64901 m
.87335 .61722 L
s
.87335 .61722 m
.85068 .5789 L
s
.02381 .5731 m
.06747 .57523 L
s
.06747 .57523 m
.10527 .51663 L
s
.60362 .51697 m
.6144 .56149 L
s
.58298 .33689 m
.63258 .30825 L
s
.63258 .30825 m
.64911 .33689 L
s
.10856 .47706 m
.10527 .51663 L
s
.1378 .01658 m
.13818 .0535 L
s
.13818 .0535 m
.15612 .08392 L
s
.10125 .63641 m
.06747 .57523 L
s
.35924 .26035 m
.39132 .29301 L
s
.97479 .13694 m
.94172 .13694 L
s
.35013 .09726 m
.39063 .07387 L
s
.08894 .10294 m
.12082 .08423 L
s
.12082 .08423 m
.13818 .0535 L
s
.07761 .67314 m
.10125 .63641 L
s
.31779 .32883 m
.3616 .34212 L
s
.1779 .2555 m
.16007 .28733 L
s
.16007 .28733 m
.18287 .32558 L
s
.68218 .33689 m
.64911 .33689 L
s
.94512 .29803 m
.91293 .31616 L
s
.36046 .67969 m
.35731 .6401 L
s
.87761 .31577 m
.91293 .31616 L
s
.35438 .48138 m
.35374 .52033 L
s
.16818 .67984 m
.17147 .64026 L
s
.4633 .33189 m
.41898 .3433 L
s
.91703 .53963 m
.9397 .57796 L
s
.21105 .50482 m
.17545 .52041 L
s
.49397 .55157 m
.46153 .57546 L
s
.1798 .39571 m
.16115 .36442 L
s
.16115 .36442 m
.11662 .36498 L
s
.6837 .51796 m
.67183 .56219 L
s
.1991 .48368 m
.17545 .52041 L
s
.93495 .50782 m
.91703 .53963 L
s
.42934 .38786 m
.41898 .3433 L
s
.27609 .58339 m
.31974 .58137 L
s
.8142 .57931 m
.85068 .5789 L
s
.19236 .67888 m
.17147 .64026 L
s
.31822 .5046 m
.35374 .52033 L
s
.84581 .29696 m
.87761 .31577 L
s
.32277 .65914 m
.35731 .6401 L
s
.03513 .5513 m
.06747 .57523 L
s
.61604 .27961 m
.63258 .30825 L
s
.34938 .38621 m
.3616 .34212 L
s
.10173 .67538 m
.10125 .63641 L
s
.39063 .02711 m
.39063 .07387 L
s
.81558 .13694 m
.84865 .13694 L
s
.42475 .26174 m
.39132 .29301 L
s
.06565 .652 m
.10125 .63641 L
s
.07079 .49747 m
.10527 .51663 L
s
.68218 .27961 m
.63258 .30825 L
s
.67799 .07387 m
.6546 .07387 L
s
.57319 .53704 m
.6144 .56149 L
s
.0331 .59579 m
.06747 .57523 L
s
.33025 .48352 m
.35374 .52033 L
s
.28731 .60528 m
.31974 .58137 L
s
.17497 .48143 m
.17545 .52041 L
s
.85393 .50871 m
.87254 .5401 L
s
.2529 .58378 m
.20922 .58162 L
s
.71358 .53877 m
.67183 .56219 L
s
.89468 .38345 m
.89499 .34654 L
s
.50516 .57344 m
.46153 .57546 L
s
.4208 .47715 m
.42394 .51674 L
s
.4599 .36811 m
.41898 .3433 L
s
.93641 .64813 m
.91785 .61673 L
s
.46307 .65226 m
.42753 .63655 L
s
.20594 .65942 m
.17147 .64026 L
s
.67487 .64397 m
.6425 .61157 L
s
.33629 .67864 m
.35731 .6401 L
s
.09692 .25654 m
.11558 .2879 L
s
.66565 .36553 m
.64911 .33689 L
s
.60784 .07387 m
.63122 .07387 L
s
.31967 .36518 m
.3616 .34212 L
s
.43113 .09726 m
.39063 .07387 L
s
.008 w
.76905 .07387 Mdot
.39063 .07387 Mdot
.39235 .24519 Mdot
.39132 .29301 Mdot
.05737 .32725 Mdot
.09385 .32672 Mdot
.3616 .34212 Mdot
.08436 .47802 Mdot
.10527 .51663 Mdot
.6546 .07387 Mdot
.63122 .07387 Mdot
.63258 .36553 Mdot
.64911 .33689 Mdot
.57017 .57337 Mdot
.6144 .56149 Mdot
.11558 .2879 Mdot
.31974 .58137 Mdot
.35731 .6401 Mdot
.60936 .64318 Mdot
.6425 .61157 Mdot
.97619 .5776 Mdot
.9397 .57796 Mdot
.20922 .58162 Mdot
.17147 .64026 Mdot
.45101 .67334 Mdot
.42753 .63655 Mdot
.91785 .61673 Mdot
.41898 .3433 Mdot
.44498 .47822 Mdot
.42394 .51674 Mdot
.21933 .32502 Mdot
.18287 .32558 Mdot
.49583 .59617 Mdot
.46153 .57546 Mdot
.24359 .56105 Mdot
.91293 .31616 Mdot
.89499 .34654 Mdot
.71581 .57515 Mdot
.67183 .56219 Mdot
.24158 .60555 Mdot
.85068 .5789 Mdot
.87254 .5401 Mdot
.17545 .52041 Mdot
.45847 .49769 Mdot
.18828 .10206 Mdot
.15612 .08392 Mdot
.28545 .5607 Mdot
.42692 .67551 Mdot
.09882 .39684 Mdot
.11662 .36498 Mdot
.35374 .52033 Mdot
.64191 .65945 Mdot
.85543 .64901 Mdot
.87335 .61722 Mdot
.02381 .5731 Mdot
.06747 .57523 Mdot
.60362 .51697 Mdot
.58298 .33689 Mdot
.63258 .30825 Mdot
.10856 .47706 Mdot
.1378 .01658 Mdot
.13818 .0535 Mdot
.10125 .63641 Mdot
.35924 .26035 Mdot
.97479 .13694 Mdot
.94172 .13694 Mdot
.84865 .13694 Mdot
.35013 .09726 Mdot
.08894 .10294 Mdot
.12082 .08423 Mdot
.07761 .67314 Mdot
.31779 .32883 Mdot
.1779 .2555 Mdot
.16007 .28733 Mdot
.68218 .33689 Mdot
.94512 .29803 Mdot
.36046 .67969 Mdot
.87761 .31577 Mdot
.35438 .48138 Mdot
.16818 .67984 Mdot
.4633 .33189 Mdot
.91703 .53963 Mdot
.21105 .50482 Mdot
.49397 .55157 Mdot
.1798 .39571 Mdot
.16115 .36442 Mdot
.6837 .51796 Mdot
.1991 .48368 Mdot
.93495 .50782 Mdot
.42934 .38786 Mdot
.27609 .58339 Mdot
.8142 .57931 Mdot
.19236 .67888 Mdot
.31822 .5046 Mdot
.84581 .29696 Mdot
.32277 .65914 Mdot
.03513 .5513 Mdot
.61604 .27961 Mdot
.34938 .38621 Mdot
.10173 .67538 Mdot
.39063 .02711 Mdot
.81558 .13694 Mdot
.42475 .26174 Mdot
.06565 .652 Mdot
.07079 .49747 Mdot
.68218 .27961 Mdot
.67799 .07387 Mdot
.57319 .53704 Mdot
.0331 .59579 Mdot
.33025 .48352 Mdot
.28731 .60528 Mdot
.17497 .48143 Mdot
.85393 .50871 Mdot
.2529 .58378 Mdot
.71358 .53877 Mdot
.89468 .38345 Mdot
.50516 .57344 Mdot
.4208 .47715 Mdot
.4599 .36811 Mdot
.93641 .64813 Mdot
.46307 .65226 Mdot
.20594 .65942 Mdot
.67487 .64397 Mdot
.33629 .67864 Mdot
.09692 .25654 Mdot
.66565 .36553 Mdot
.60784 .07387 Mdot
.31967 .36518 Mdot
.43113 .09726 Mdot
0 0 m
1 0 L
1 .69642 L
0 .69642 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[3]:=",
  ImageSize->{288, 200.563},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000b2000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`009`3oool00`000000oooo0?oo
o`3f0?ooo`009`3oool00`000000oooo0?ooo`3f0?ooo`009`3oool00`000000oooo0?ooo`3f0?oo
o`009`3oool00`000000oooo0?ooo`150?ooo`030000003oool0oooo0:h0oooo000W0?ooo`030000
003oool0oooo04D0oooo0P00002_0?ooo`009`3oool00`000000oooo0?ooo`160?ooo`030000003o
ool0oooo0:d0oooo000W0?ooo`030000003oool0oooo04H0oooo00<000000?ooo`3oool0[@3oool0
02L0oooo00<000000?ooo`3oool0AP3oool00`000000oooo0?ooo`2]0?ooo`009`3oool00`000000
oooo0?ooo`160?ooo`030000003oool0oooo0:d0oooo000W0?ooo`030000003oool0oooo04H0oooo
00<000000?ooo`3oool0[@3oool002L0oooo00<000000?ooo`3oool0AP3oool00`000000oooo0?oo
o`2]0?ooo`009`3oool00`000000oooo0?ooo`160?ooo`030000003oool0oooo0:d0oooo000V0?oo
o`<00000A`3oool00`000000oooo0?ooo`2]0?ooo`009P3oool00`000000oooo000000170?ooo`03
0000003oool0oooo0:d0oooo000U0?ooo`050000003oool0oooo0?ooo`000000AP3oool00`000000
oooo0?ooo`2]0?ooo`009@3oool01@000000oooo0?ooo`3oool0000004H0oooo00<000000?ooo`3o
ool0[@3oool002@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`130?ooo`030000
003oool0oooo0:d0oooo000T0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0@P3o
ool2000003`0oooo5P00000H0?ooo`030000003oool0oooo0480oooo000S0?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool0@03oool2000000030?ooo`000000000003X0oooo00<00000
0?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`3oool05`3oool00`000000oooo0?ooo`120?ooo`008`3oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo03h0oooo0P0000050?ooo`030000003oool0oooo0:X0oooo000R0?ooo`/0
0000?P3oool00`000000oooo0?ooo`060?ooo`800000ZP3oool00200oooo0`0000090?ooo`<00000
>P3oool2000000/0oooo0P00002X0?ooo`007P3oool2000000l0oooo0P00000f0?ooo`8000003`3o
ool00`000000oooo0?ooo`2U0?ooo`00703oool2000001<0oooo0P00000`0?ooo`040000003oool0
000000000180oooo0`00002T0?ooo`006P3oool2000001L0oooo0P00000^0?ooo`8000005P3oool0
0`000000oooo0?ooo`2R0?ooo`006@3oool00`000000oooo0?ooo`0I0?ooo`800000j@3oool001T0
oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`3X0?ooo`00o`3ooolQ0?ooo`00o`3o
oolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3o
oolQ0?ooo`00o`3ooolQ0?ooo`00j@3oool;000001T0oooo2`0000080?ooo`00j@3oool00`000000
oooo0?ooo`060?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool01P3oool00`000000
oooo0?ooo`070?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?oo
o`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?oo
o`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?oo
o`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?oo
o`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?oo
o`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?oo
o`00L03oool00`000000oooo0?ooo`2]0?ooo`00L03oool00`000000oooo0?ooo`2]0?ooo`00L03o
ool00`000000oooo0?ooo`2]0?ooo`006`3oool00`000000oooo0?ooo`0D0?ooo`800000?03oool0
0`000000oooo0?ooo`2]0?ooo`006`3oool2000001D0oooo00<000000?ooo`3oool0<@3oool00`00
0000oooo0?ooo`070?ooo`030000003oool0oooo0:d0oooo000L0?ooo`030000003oool0oooo01<0
oooo00<000000?ooo`3oool0<@3oool2000000P0oooo00<000000?ooo`3oool01P3oool00`000000
oooo0?ooo`2T0?ooo`007@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo03@0oooo
00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`800000YP3oool001h0oooo00<0
00000?ooo`3oool0403oool00`000000oooo0?ooo`0e0?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`2V0?ooo`007P3oool00`000000oooo0?ooo`0?
0?ooo`030000003oool0oooo03L0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo0:L0oooo000O0?ooo`030000003oool0oooo00h0oooo00<000000?oo
o`3oool0>03oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo00<000000?oo
o`3oool0Z03oool00200oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0j0?ooo`05
0000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`0i0?ooo`030000003oool0oooo
0100oooo00<000000?ooo`3oool0FP3oool00200oooo00<000000?ooo`3oool0303oool00`000000
oooo0?ooo`0k0?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool0>P3oool20000
00l0oooo0`00001L0?ooo`00803oool?000003l0oooo00D000000?ooo`000000oooo0000000n0?oo
o`030000003oool0oooo00/0oooo0P00001O0?ooo`00803oool00`000000oooo0?ooo`0:0?ooo`03
0000003oool0000003l0oooo0`0000100?ooo`030000003oool0oooo00P0oooo0P00001Q0?ooo`00
803oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo03d0oooo0P0000110?ooo`030000
003oool0oooo00L0oooo00<000000?ooo`3oool0H@3oool001l0oooo00<000000?ooo`3oool03P3o
ool00`000000oooo0?ooo`0l0?ooo`030000003oool000000440oooo00<000000?ooo`3oool0103o
ool2000003D0oooo0P00000K0?ooo`800000403oool001l0oooo00<000000?ooo`3oool03P3oool0
0`000000oooo0?ooo`0l0?ooo`030000003oool000000480oooo00@000000?ooo`3oool0oooo0P00
000g0?ooo`040000003oool00000000001P0oooo0P00000A0?ooo`007P3oool00`000000oooo0?oo
o`0@0?ooo`030000003oool0oooo03X0oooo00D000000?ooo`3oool0oooo000000110?ooo`040000
003oool00000000003d0oooo0P00000D0?ooo`8000004`3oool001h0oooo00<000000?ooo`3oool0
403oool00`000000oooo0?ooo`0i0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0
?`3oool200000440oooo0P00000A0?ooo`030000003oool0oooo01<0oooo000M0?ooo`030000003o
ool0oooo0180oooo00<000000?ooo`3oool0>03oool00`000000oooo0?ooo`030?ooo`030000003o
ool0oooo03d0oooo0P0000000`3oool000000?ooo`110?ooo`8000003@3oool2000001H0oooo000M
0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool0=`3oool00`000000oooo0?ooo`04
0?ooo`030000003oool0oooo03/0oooo0P0000030?ooo`030000003oool0oooo0480oooo1@000005
0?ooo`<00000603oool001`0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0e0?oo
o`030000003oool0oooo00H0oooo00<000000?ooo`3oool0>03oool2000000H0oooo00<000000?oo
o`3oool0@@3oool2000000<0oooo1P00000J0?ooo`00703oool00`000000oooo0?ooo`0D0?ooo`03
0000003oool0oooo03D0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0f0?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`3oool0@P3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo01T0oooo000@0?ooo`030000003oool0oooo00L0oooo0P00000H0?ooo``00000
:P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo03@0oooo0P00000:0?ooo`030000
003oool0oooo0480oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0I0?ooo`00403o
ool<000001L0oooo0P0000090?ooo`030000003oool0oooo01T0oooo0`00000=0?ooo`030000003o
ool0oooo00T0oooo00<000000?ooo`3oool0<@3oool2000000d0oooo00<000000?ooo`3oool0@@3o
ool00`000000oooo0?ooo`030?ooo`030000003oool0oooo01X0oooo000L0?ooo`030000003oool0
oooo01@0oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`03000000T0oooo00<00000
0?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?ooo`8000008`3oool2000000l0oooo00<00000
0?ooo`3oool0@P3oool01@000000oooo0?ooo`3oool0000001d0oooo000L0?ooo`030000003oool0
oooo01<0oooo00<000000?ooo`3oool0:`3oool3000000D0oooo00<000000?ooo`3oool0303oool0
0`000000oooo0?ooo`050?ooo`@0000000<0oooo0000003oool0803oool200000140oooo2`00000j
0?ooo`050000003oool0oooo0?ooo`0000007@3oool001d0oooo00<000000?ooo`3oool04P3oool0
0`000000oooo0?ooo`0^0?ooo`<000000P3oool00`000000oooo0?ooo`0<0?ooo`040000003oool0
oooo0?ooo`@000009`3oool00`000000oooo0?ooo`0@0?ooo`800000203oool00`000000oooo0?oo
o`0i0?ooo`030000003oool0000001h0oooo000M0?ooo`030000003oool0oooo0140oooo00<00000
0?ooo`3oool0<P3ooolE000003h0oooo00<000000?ooo`000000@`3oool00`000000oooo0000000N
0?ooo`007P3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0340oooo0`00000?0?oo
o`@00000?@3oool010000000oooo0?ooo`0000140?ooo`030000003oool0oooo01d0oooo000N0?oo
o`030000003oool0oooo00l0oooo00<000000?ooo`3oool0<03oool200000080oooo00<000000?oo
o`3oool03P3oool00`000000oooo0?ooo`02000003/0oooo00D000000?ooo`3oool0oooo00000013
0?ooo`030000003oool0oooo01d0oooo000O0?ooo`030000003oool0oooo00h0oooo00<000000?oo
o`3oool0;`3oool01@000000oooo0?ooo`3oool000000180oooo00D000000?ooo`3oool0oooo0000
000i0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0@@3oool00`000000oooo0?oo
o`0M0?ooo`007`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo02h0oooo0P000004
0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool00P3oool2000003L0oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`100?ooo`030000003oool0oooo01d0oooo000P0?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`3oool0;03oool2000000H0oooo00<000000?oo
o`3oool0403oool00`000000oooo0?ooo`040?ooo`800000=03oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo0400oooo00<000000?ooo`3oool07@3oool00200oooo0P0000060?ooo`L0
0000;03oool3000000P0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`060?ooo`80
0000<03oool00`000000oooo000000070?ooo`030000003oool0oooo03l0oooo00<000000?ooo`3o
ool07@3oool00240oooo1`0000050?ooo`030000003oool0000002/0oooo00<000000?ooo`3oool0
1`3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo00H0oooo0P00000_0?ooo`800000
203oool00`000000oooo0?ooo`0o0?ooo`030000003oool0oooo01d0oooo000P0?ooo`030000003o
ool0oooo00`0oooo00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`0B0?ooo`030000003o
ool0oooo00H0oooo00<000000?ooo`3oool0NP3oool00`000000oooo0?ooo`0M0?ooo`00803oool0
0`000000oooo0?ooo`0=0?ooo`030000003oool0oooo0380oooo00<000000?ooo`3oool04P3oool0
0`000000oooo0?ooo`230?ooo`030000003oool0oooo01d0oooo000O0?ooo`030000003oool0oooo
00h0oooo00<000000?ooo`3oool0<P3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo
08<0oooo00<000000?ooo`3oool07@3oool001l0oooo00<000000?ooo`3oool03`3oool00`000000
oooo0?ooo`0`0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool0P@3oool2000001l0
oooo000N0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0;`3oool2000001H0oooo
00<000000?ooo`3oool0P@3oool2000001l0oooo000N0?ooo`030000003oool0oooo0140oooo00<0
00000?ooo`3oool0;P3oool2000001D0oooo0P00002T0?ooo`007@3oool00`000000oooo0?ooo`0B
0?ooo`030000003oool0oooo04D0oooo00<000000?ooo`3oool0X`3oool001/0oooo00<000000?oo
o`0000005@3oool00`000000oooo0?ooo`3Z0?ooo`006`3oool2000001H0oooo00<000000?ooo`3o
ool0jP3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0
oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0
oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0
oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0
oooo8@3oool00?l0oooo8@3oool001h0oooo00<000000?ooo`3oool0E`3oool00`000000oooo0?oo
o`2U0?ooo`005`3oool2000000D0oooo0P00001H0?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`3oool0WP3oool001L0oooo00<000000?ooo`0000001@3oool00`000000oooo0?ooo`0?0?oo
o`8000001@3oool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo00@0oooo00<000000?oo
o`3oool0403oool00`000000oooo0?ooo`030?ooo`800000X03oool001T0oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`0?0?ooo`8000001@3oool2000002@0oooo0P0000050?ooo`03
0000003oool0oooo0100oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`2O0?ooo`00
6P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0
0`3oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0
403oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0:00oooo000J0?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`030?ooo`030000003o
ool0oooo02D0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0@0?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`3oool0X03oool001<0oooo0P0000060?ooo`050000003oool0
oooo0?ooo`0000004P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo02L0oooo00D0
00000?ooo`3oool0oooo0000000B0?ooo`050000003oool0oooo0?ooo`0000001@3oool00`000000
oooo0?ooo`2K0?ooo`004`3oool010000000oooo0000000000040?ooo`040000003oool0oooo0000
01<0oooo00D000000?ooo`3oool0oooo0000000Z0?ooo`050000003oool0oooo0?ooo`0000004`3o
ool010000000oooo0?ooo`0000050?ooo`800000W03oool001L0oooo0P0000030?ooo`030000003o
ool0000001<0oooo00@000000?ooo`3oool000001P3oool00`000000oooo0?ooo`0K0?ooo`030000
003oool0oooo00D0oooo00@000000?ooo`3oool000004`3oool00`000000oooo000000050?ooo`80
0000W@3oool001T0oooo00H000000?ooo`3oool000000?ooo`00000C0?ooo`040000003oool0oooo
000000D0oooo0P00000M0?ooo`<000001@3oool010000000oooo0?ooo`00000C0?ooo`030000003o
ool0000000<0oooo0P00001c0?ooo`030000003oool0oooo01@0oooo0P00000C0?ooo`006P3oool2
000000030?ooo`000000000001<0oooo00<000000?ooo`000000103oool200000280oooo0P000004
0?ooo`030000003oool0000001<0oooo0P0000020?ooo`800000M@3oool00`000000oooo0?ooo`0D
0?ooo`030000003oool0oooo0180oooo000L0?ooo`<000004`3oool200000080oooo0`00000V0?oo
o`<000000P3oool2000001<0oooo1000001h0?ooo`030000003oool0oooo01<0oooo00<000000?oo
o`3oool04P3oool001d0oooo2`00000:0?ooo`@00000;03oool4000000X0oooo2`00000a0?ooo`80
00005@3oool200000300oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0C0?ooo`00
7@3oool00`000000oooo0?ooo`080?ooo``00000<03oool<000000T0oooo0P00000a0?ooo`800000
5@3oool200000340oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0C0?ooo`007@3o
ool00`000000oooo0?ooo`0A0?ooo`030000003oool000000300oooo00<000000?ooo`3oool04`3o
ool00`000000oooo0?ooo`0`0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0<@3o
ool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo01@0oooo000L0?ooo`030000003oool0
oooo01@0oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0
oooo0300oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0a0?ooo`030000003oool0
oooo00l0oooo00<000000?ooo`3oool0503oool001/0oooo00<000000?ooo`3oool05P3oool00`00
0000oooo0?ooo`0/0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool0;`3oool00`00
0000oooo0?ooo`0B0?ooo`030000003oool0oooo0380oooo00<000000?ooo`3oool03@3oool00`00
0000oooo0?ooo`0E0?ooo`006`3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo02`0
oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo00P0
oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0d0?ooo`030000003oool0oooo00`0
oooo00<000000?ooo`3oool05@3oool001X0oooo00<000000?ooo`3oool0603oool00`000000oooo
0?ooo`0Z0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool08`3oool2000000T0oooo
00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo02X0oooo
00<000000?ooo`3oool02P3oool2000001P0oooo000I0?ooo`030000003oool0oooo01T0oooo00<0
00000?ooo`3oool0:P3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo02@0oooo0P00
00080?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool01@3oool3000002`0oooo3`00
000H0?ooo`006@3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo02P0oooo00<00000
0?ooo`3oool06P3oool00`000000oooo0?ooo`0V0?ooo`8000001P3oool00`000000oooo0?ooo`0@
0?ooo`030000003oool0oooo00<0oooo0P00000_0?ooo`030000003oool0oooo00`0oooo00<00000
0?ooo`3oool05@3oool001P0oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`0X0?oo
o`030000003oool0oooo01/0oooo00<000000?ooo`3oool09`3oool00`000000oooo0?ooo`030?oo
o`030000003oool0oooo00l0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0_0?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`3oool05@3oool000T0oooo0P00000=0?ooo`03
0000003oool0oooo01`0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0L0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool06P3oool2000000<0oooo00<000000?ooo`3o
ool03`3oool010000000oooo0?ooo`3oool200000340oooo00<000000?ooo`3oool03P3oool00`00
0000oooo0?ooo`0D0?ooo`002@3oool00`000000oooo0000000;0?ooo`030000003oool0oooo01h0
oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`0N0?ooo`030000003oool0oooo00T0
oooo0P00000N0?ooo`8000000P3oool00`000000oooo0?ooo`0>0?ooo`040000003oool000000000
0380oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0D0?ooo`00303oool2000000P0
oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00T0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0O0?ooo`030000003oool0oooo00H0
oooo0P00000R0?ooo`<000003`3oool3000003@0oooo00<000000?ooo`3oool0403oool00`000000
oooo0?ooo`0C0?ooo`003P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0200oooo
00<000000?ooo`3oool02@3oool2000000X0oooo0P00000;0?ooo`030000003oool0oooo0200oooo
00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0R0?oooa@00000=03oool00`000000oooo
0?ooo`0A0?ooo`030000003oool0oooo01<0oooo000?0?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`3oool08@3oool00`000000oooo0?ooo`080?ooo`8000003@3oool2000000T0oooo00<0
00000?ooo`3oool08@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo01l0oooo1000
00030?ooo`030000003oool0oooo00/0oooo0P000000103oool0000000000000000a0?ooo`030000
003oool0oooo0180oooo00<000000?ooo`3oool04P3oool00100oooo0P0000020?ooo`030000003o
ool0oooo02<0oooo00<000000?ooo`3oool01@3oool200000140oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo008000007P3oool4000000L0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`030?ooo`@00000;03oool00`000000oooo0?oo
o`0C0?ooo`030000003oool0oooo0180oooo00060?ooo`L000001@3oool00`000000oooo0000000U
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool04P3oool2000000D0oooo00<00000
0?ooo`3oool08`3oool00`000000oooo000000050?ooo`H000004@3oool4000000`0oooo00<00000
0?ooo`3oool02@3oool00`000000oooo0?ooo`080?ooo`@000009`3oool00`000000oooo0?ooo`0E
0?ooo`030000003oool0oooo0140oooo00060?ooo`030000003oool0oooo00@0oooo1`00000W0?oo
o`040000003oool0oooo0?ooo`8000005`3oool01@000000oooo0?ooo`3oool0000002H0oooo2000
00050?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?oo
o`090?ooo`030000003oool0oooo00/0oooo0P00000U0?ooo`8000005`3oool00`000000oooo0?oo
o`040?ooo`D00000203oool00140oooo0P0000000`3oool000000?ooo`0U0?ooo`040000003oool0
0000000001X0oooo1000000V0?ooo`040000003oool00000000002`0oooo00<000000?ooo`3oool0
1`3oool00`000000oooo0?ooo`0X0?ooo``00000603oool7000000@0oooo00<000000?ooo`3oool0
1P3oool000l0oooo0P0000030?ooo`030000003oool0oooo02@0oooo3P0000050?ooo`h000009`3o
ool010000000oooo0?ooo`3oool2000002X0oooo00<000000?ooo`3oool01`3oool00`000000oooo
0?ooo`0X0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool05@3oool00`000000oooo
0?ooo`0A0?ooo`003P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo02<0oooo00@0
00000?ooo`00000000002@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00P0oooo
0P0000000`3oool000000?ooo`0T0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0
:03oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo03D0oooo00<000000?ooo`3oool0
5@3oool00`000000oooo0?ooo`0A0?ooo`00303oool2000000L0oooo00<000000?ooo`3oool08`3o
ool01@000000oooo0?ooo`3oool0000001P0oooo00D000000?ooo`3oool0oooo0000000U0?ooo`03
0000003oool0oooo00D0oooo0P00000Y0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool0=`3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo0180oooo00090?ooo`<00000
2P3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo00<0oooo0P00000D0?ooo`800000
1@3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo00P0oooo0P00000W0?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool0>03oool00`000000oooo0?ooo`0B0?ooo`030000
003oool0oooo0180oooo00090?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool07`3o
ool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool01P3o
ool00`000000oooo0?ooo`0O0?ooo`030000003oool0oooo00X0oooo0P00000W0?ooo`050000003o
ool0oooo0?ooo`000000>`3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo01<0oooo
000G0?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3oool01`3oool2000000h0oooo0P00
00090?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3oool0<`3oool01@000000oooo0?oo
o`3oool0000003`0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0C0?ooo`00603o
ool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo00T0oooo0P00000;0?ooo`800000303o
ool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo03D0oooo00<000000?ooo`000000?@3o
ool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo01@0oooo000H0?ooo`030000003oool0
oooo01`0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo00`0oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`0e0?ooo`030000003oool0
000003h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0D0?ooo`006@3oool00`00
0000oooo0?ooo`0J0?ooo`030000003oool0oooo02L0oooo00<000000?ooo`3oool06`3oool00`00
0000oooo0?ooo`0f0?ooo`800000@03oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo
01D0oooo000I0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0:03oool00`000000
oooo0?ooo`0J0?ooo`030000003oool0oooo03H0oooo0`00000o0?ooo`030000003oool0oooo00X0
oooo00<000000?ooo`0000005`3oool001X0oooo00<000000?ooo`3oool0603oool00`000000oooo
0?ooo`0Z0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0=P3oool01@000000oooo
0000003oool0000003h0oooo3`00000H0?ooo`006`3oool00`000000oooo0?ooo`0F0?ooo`030000
003oool0oooo02`0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0f0?ooo`040000
003oool0oooo00000080oooo00<000000?ooo`3oool0>`3oool00`000000oooo0?ooo`0<0?ooo`03
0000003oool0oooo01D0oooo000K0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool0
;03oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo03D0oooo00D000000?ooo`3oool0
oooo000000030?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool0303oool00`000000
oooo0?ooo`0E0?ooo`00703oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo02h0oooo
00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0d0?ooo`800000103oool00`000000oooo
0?ooo`020?ooo`030000003oool0oooo03P0oooo00<000000?ooo`3oool03P3oool00`000000oooo
0?ooo`0D0?ooo`00703oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo0300oooo00<0
00000?ooo`3oool04`3oool00`000000oooo0?ooo`0c0?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool00`3oool00`000000oooo0?ooo`0g0?ooo`030000003oool0oooo00h0oooo00<0
00000?ooo`3oool0503oool001`0oooo2`00000;0?ooo`030000003oool0oooo0300oooo00<00000
0?ooo`3oool02@3oool:000003D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`04
0?ooo`030000003oool0oooo03D0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0C
0?ooo`006`3oool3000000T0oooo2`00000c0?ooo``000002@3oool300000380oooo00<000000?oo
o`3oool01P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo03@0oooo00<000000?oo
o`3oool0403oool00`000000oooo0?ooo`0C0?ooo`006@3oool2000000030?ooo`00000000000180
oooo1000000`0?ooo`<000004`3oool2000000030?ooo`000000000002l0oooo00<000000?ooo`3o
ool01`3oool00`000000oooo0?ooo`050?ooo`800000=03oool00`000000oooo0?ooo`0B0?ooo`03
0000003oool0oooo0180oooo000G0?ooo`8000000P3oool00`000000oooo0000000C0?ooo`800000
00<0oooo000000000000;03oool2000000030?ooo`000000000001<0oooo00<000000?ooo`000000
0P3oool2000002d0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo03<0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0B0?ooo`004P3o
ool00`000000oooo0?ooo`02000000<0oooo00@000000?ooo`3oool000004`3oool00`000000oooo
000000020?ooo`030000003oool0oooo02P0oooo00H000000?ooo`3oool000000?ooo`00000C0?oo
o`040000003oool0oooo000000<0oooo0P0000000`3oool000000?ooo`0b0?ooo`030000003oool0
oooo03T0oooo0P00000E0?ooo`8000004`3oool00180oooo0`0000050?ooo`040000003oool0oooo
000001<0oooo00<000000?ooo`0000000`3oool2000002H0oooo0P0000030?ooo`030000003oool0
000001<0oooo00@000000?ooo`3oool000001@3oool2000003<0oooo00<000000?ooo`3oool0>@3o
ool00`000000oooo0?ooo`0Y0?ooo`006@3oool01@000000oooo0?ooo`3oool0000001<0oooo00@0
00000?ooo`3oool00000103oool200000240oooo0`0000040?ooo`040000003oool0oooo000001<0
oooo00D000000?ooo`3oool0oooo0000000i0?ooo`030000003oool0oooo06D0oooo000I0?ooo`05
0000003oool0oooo0?ooo`0000004P3oool01@000000oooo0?ooo`3oool0000000D0oooo0P00000P
0?ooo`030000003oool0oooo00@0oooo00@000000?ooo`3oool000004`3oool01@000000oooo0?oo
o`3oool0000003P0oooo0P00001W0?ooo`00603oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo0100oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo02D0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0@0?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`3oool0=@3oool00`000000oooo0?ooo`1V0?ooo`005`3oool0
0`000000oooo0?ooo`030?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool00P3oool0
0`000000oooo0?ooo`0Z0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0403oool0
0`000000oooo0?ooo`030?ooo`030000003oool0oooo09d0oooo000E0?ooo`030000003oool00000
00D0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo
02P0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`3oool0W@3oool001D0oooo0P0000050?ooo`8000004P3oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3oool00`3oool00`000000
oooo0?ooo`0?0?ooo`8000001@3oool2000009h0oooo000L0?ooo`030000003oool0oooo0100oooo
0P0000050?ooo`8000009`3oool2000000D0oooo0P00000A0?ooo`8000001@3oool00`000000oooo
0?ooo`2M0?ooo`00;`3oool2000000D0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?oo
o`040?ooo`800000^03oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo
8@3oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {199.563, 0}} -> {-5.95031, 7.62978, 0.149245, \
0.149245}}]
}, Open  ]],

Cell[TextData[{
  StyleBox["GraphPlot", "MR"],
  " and ",
  StyleBox["GraphPlot3D", "MR"],
  " are designed to work with very large graphs. This plots a graph of 1005 \
vertices defined by a matrix from a structural engineering application."
}], "MathCaption"],

Cell[BoxData[
    \(\(a = 
        Import["\<LinearAlgebraExamples/Data/dwt_1005.psa\>", \
"\<HarwellBoeing\>"];\)\)], "Input",
  CellLabel->"In[5]:="],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(GraphPlot3D[a];\)\)], "Input",
  CellLabel->"In[6]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .68907 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
1.63335e-016 1.04725 -0.128805 1.04725 [
[ 0 0 0 0 ]
[ 1 .68907 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01534 .25847 m
0 .35595 L
s
0 .35595 m
.39331 .68907 L
s
.39331 .68907 m
.39645 .60071 L
s
.39645 .60071 m
.01534 .25847 L
s
.69848 0 m
.98727 .42924 L
s
.98727 .42924 m
1 .52261 L
s
1 .52261 m
.70449 .10201 L
s
.70449 .10201 m
.69848 0 L
s
.01534 .25847 m
0 .35595 L
s
0 .35595 m
.70449 .10201 L
s
.70449 .10201 m
.69848 0 L
s
.69848 0 m
.01534 .25847 L
s
.39645 .60071 m
.98727 .42924 L
s
.98727 .42924 m
1 .52261 L
s
1 .52261 m
.39331 .68907 L
s
.39331 .68907 m
.39645 .60071 L
s
0 0 m
1 0 L
1 .68907 L
0 .68907 L
closepath
clip
newpath
.01 w
.30169 .57657 Mdot
.5 Mabswid
.30169 .57657 m
.30601 .57832 L
s
.30169 .57657 m
.30043 .57555 L
s
.30169 .57657 m
.30422 .58002 L
s
.30757 .57288 m
.30169 .57657 L
s
.30682 .5675 m
.30169 .57657 L
s
.01 w
.30682 .5675 Mdot
.5 Mabswid
.30682 .5675 m
.30757 .57288 L
s
.31372 .56272 m
.30682 .5675 L
s
.31402 .55667 m
.30682 .5675 L
s
.01 w
.30601 .57832 Mdot
.5 Mabswid
.30601 .57832 m
.31449 .57342 L
s
.30757 .57288 m
.30601 .57832 L
s
.01 w
.31402 .55667 Mdot
.5 Mabswid
.31402 .55667 m
.31372 .56272 L
s
.32087 .55171 m
.31402 .55667 L
s
.32298 .54515 m
.31402 .55667 L
s
.01 w
.30043 .57555 Mdot
.5 Mabswid
.30043 .57555 m
.30834 .5705 L
s
.30757 .57288 m
.30043 .57555 L
s
.01 w
.32298 .54515 Mdot
.5 Mabswid
.32298 .54515 m
.32087 .55171 L
s
.32844 .54129 m
.32298 .54515 L
s
.33419 .5339 m
.32298 .54515 L
s
.01 w
.30757 .57288 Mdot
.5 Mabswid
.30757 .57288 m
.31449 .57342 L
s
.30757 .57288 m
.30834 .5705 L
s
.30757 .57288 m
.30422 .58002 L
s
.30757 .57288 m
.30978 .57573 L
s
.31657 .56743 m
.30757 .57288 L
s
.31372 .56272 m
.30757 .57288 L
s
.01 w
.31372 .56272 Mdot
.5 Mabswid
.31372 .56272 m
.31657 .56743 L
s
.32298 .55656 m
.31372 .56272 L
s
.32087 .55171 m
.31372 .56272 L
s
.01 w
.30422 .58002 Mdot
.5 Mabswid
.30422 .58002 m
.31086 .57856 L
s
.30978 .57573 m
.30422 .58002 L
s
.01 w
.32087 .55171 Mdot
.5 Mabswid
.32087 .55171 m
.32298 .55656 L
s
.3305 .54447 m
.32087 .55171 L
s
.32844 .54129 m
.32087 .55171 L
s
.01 w
.31449 .57342 Mdot
.5 Mabswid
.31449 .57342 m
.32714 .56714 L
s
.31657 .56743 m
.31449 .57342 L
s
.01 w
.32844 .54129 Mdot
.5 Mabswid
.32844 .54129 m
.3305 .54447 L
s
.33919 .53229 m
.32844 .54129 L
s
.33419 .5339 m
.32844 .54129 L
s
.01 w
.30978 .57573 Mdot
.5 Mabswid
.30978 .57573 m
.31086 .57856 L
s
.31801 .57113 m
.30978 .57573 L
s
.31657 .56743 m
.30978 .57573 L
s
.01 w
.30834 .5705 Mdot
.5 Mabswid
.30834 .5705 m
.31846 .56314 L
s
.31657 .56743 m
.30834 .5705 L
s
.01 w
.33419 .5339 Mdot
.5 Mabswid
.33419 .5339 m
.33919 .53229 L
s
.34791 .52186 m
.33419 .5339 L
s
.01 w
.31657 .56743 Mdot
.5 Mabswid
.31657 .56743 m
.32714 .56714 L
s
.31657 .56743 m
.31846 .56314 L
s
.31657 .56743 m
.31801 .57113 L
s
.32792 .56052 m
.31657 .56743 L
s
.32298 .55656 m
.31657 .56743 L
s
.01 w
.31086 .57856 Mdot
.5 Mabswid
.31954 .57408 m
.31086 .57856 L
s
.31801 .57113 m
.31086 .57856 L
s
.01 w
.32298 .55656 Mdot
.5 Mabswid
.32298 .55656 m
.32792 .56052 L
s
.33358 .54887 m
.32298 .55656 L
s
.3305 .54447 m
.32298 .55656 L
s
.01 w
.3305 .54447 Mdot
.5 Mabswid
.3305 .54447 m
.33358 .54887 L
s
.34204 .53531 m
.3305 .54447 L
s
.33919 .53229 m
.3305 .54447 L
s
.01 w
.33919 .53229 Mdot
.5 Mabswid
.33919 .53229 m
.34204 .53531 L
s
.35318 .52088 m
.33919 .53229 L
s
.34791 .52186 m
.33919 .53229 L
s
.01 w
.32714 .56714 Mdot
.5 Mabswid
.32714 .56714 m
.34539 .55995 L
s
.32792 .56052 m
.32714 .56714 L
s
.01 w
.31801 .57113 Mdot
.5 Mabswid
.31801 .57113 m
.31954 .57408 L
s
.32773 .56543 m
.31801 .57113 L
s
.32792 .56052 m
.31801 .57113 L
s
.01 w
.34791 .52186 Mdot
.5 Mabswid
.34791 .52186 m
.35318 .52088 L
s
.36497 .50711 m
.34791 .52186 L
s
.01 w
.31954 .57408 Mdot
.5 Mabswid
.32884 .56926 m
.31954 .57408 L
s
.32773 .56543 m
.31954 .57408 L
s
.01 w
.31846 .56314 Mdot
.5 Mabswid
.31846 .56314 m
.32945 .55272 L
s
.32792 .56052 m
.31846 .56314 L
s
.01 w
.33358 .54887 Mdot
.5 Mabswid
.33358 .54887 m
.32792 .56052 L
s
.33358 .54887 m
.33978 .55243 L
s
.34375 .54052 m
.33358 .54887 L
s
.34204 .53531 m
.33358 .54887 L
s
.01 w
.32792 .56052 Mdot
.5 Mabswid
.32792 .56052 m
.34539 .55995 L
s
.32792 .56052 m
.32945 .55272 L
s
.32792 .56052 m
.32773 .56543 L
s
.33978 .55243 m
.32792 .56052 L
s
.01 w
.34204 .53531 Mdot
.5 Mabswid
.34204 .53531 m
.34375 .54052 L
s
.35445 .5265 m
.34204 .53531 L
s
.35318 .52088 m
.34204 .53531 L
s
.01 w
.77535 .54375 Mdot
.5 Mabswid
.77535 .54375 m
.78137 .55192 L
s
.77535 .54375 m
.77456 .54931 L
s
.76755 .54003 m
.77535 .54375 L
s
.76691 .53384 m
.77535 .54375 L
s
.01 w
.78137 .55192 Mdot
.5 Mabswid
.78137 .55192 m
.78096 .55118 L
s
.78137 .55192 m
.77665 .55317 L
s
.78137 .55192 m
.77944 .55571 L
s
.77456 .54931 m
.78137 .55192 L
s
.01 w
.76691 .53384 Mdot
.5 Mabswid
.76691 .53384 m
.76755 .54003 L
s
.7593 .52997 m
.76691 .53384 L
s
.75704 .52369 m
.76691 .53384 L
s
.01 w
.32773 .56543 Mdot
.5 Mabswid
.32773 .56543 m
.32884 .56926 L
s
.33674 .5608 m
.32773 .56543 L
s
.33978 .55243 m
.32773 .56543 L
s
.01 w
.77665 .55317 Mdot
.5 Mabswid
.77665 .55317 m
.76718 .55056 L
s
.77456 .54931 m
.77665 .55317 L
s
.01 w
.35318 .52088 Mdot
.5 Mabswid
.35318 .52088 m
.35445 .5265 L
s
.36987 .50778 m
.35318 .52088 L
s
.36497 .50711 m
.35318 .52088 L
s
.01 w
.75704 .52369 Mdot
.5 Mabswid
.75704 .52369 m
.7593 .52997 L
s
.75068 .52056 m
.75704 .52369 L
s
.74401 .51404 m
.75704 .52369 L
s
.01 w
.34539 .55995 Mdot
.5 Mabswid
.34539 .55995 m
.35746 .55284 L
s
.34539 .55995 m
.37039 .55629 L
s
.33978 .55243 m
.34539 .55995 L
s
.01 w
.78096 .55118 Mdot
.5 Mabswid
.78096 .55118 m
.77256 .54744 L
s
.77456 .54931 m
.78096 .55118 L
s
.01 w
.34375 .54052 Mdot
.5 Mabswid
.34375 .54052 m
.33978 .55243 L
s
.35278 .53789 m
.34375 .54052 L
s
.35445 .5265 m
.34375 .54052 L
s
.01 w
.77456 .54931 Mdot
.5 Mabswid
.77456 .54931 m
.77256 .54744 L
s
.77456 .54931 m
.76718 .55056 L
s
.77456 .54931 m
.77944 .55571 L
s
.77456 .54931 m
.77292 .55299 L
s
.7645 .54561 m
.77456 .54931 L
s
.76755 .54003 m
.77456 .54931 L
s
.01 w
.76755 .54003 Mdot
.5 Mabswid
.76755 .54003 m
.7645 .54561 L
s
.75703 .53546 m
.76755 .54003 L
s
.7593 .52997 m
.76755 .54003 L
s
.01 w
.32884 .56926 Mdot
.5 Mabswid
.33877 .56374 m
.32884 .56926 L
s
.33674 .5608 m
.32884 .56926 L
s
.01 w
.77944 .55571 Mdot
.5 Mabswid
.77944 .55571 m
.77244 .55635 L
s
.77292 .55299 m
.77944 .55571 L
s
.01 w
.7593 .52997 Mdot
.5 Mabswid
.7593 .52997 m
.75703 .53546 L
s
.74782 .52414 m
.7593 .52997 L
s
.75068 .52056 m
.7593 .52997 L
s
.01 w
.76718 .55056 Mdot
.5 Mabswid
.76718 .55056 m
.75329 .54674 L
s
.7645 .54561 m
.76718 .55056 L
s
.01 w
.75068 .52056 Mdot
.5 Mabswid
.75068 .52056 m
.74782 .52414 L
s
.73804 .51309 m
.75068 .52056 L
s
.74401 .51404 m
.75068 .52056 L
s
.01 w
.33978 .55243 Mdot
.5 Mabswid
.33978 .55243 m
.35746 .55284 L
s
.33978 .55243 m
.34074 .54523 L
s
.33978 .55243 m
.32945 .55272 L
s
.33978 .55243 m
.33674 .5608 L
s
.34628 .5504 m
.33978 .55243 L
s
.35278 .53789 m
.33978 .55243 L
s
.01 w
.36497 .50711 Mdot
.5 Mabswid
.36497 .50711 m
.36987 .50778 L
s
.38681 .48699 m
.36497 .50711 L
s
.01 w
.35445 .5265 Mdot
.5 Mabswid
.35445 .5265 m
.35278 .53789 L
s
.36521 .52114 m
.35445 .5265 L
s
.36987 .50778 m
.35445 .5265 L
s
.01 w
.74401 .51404 Mdot
.5 Mabswid
.74401 .51404 m
.73804 .51309 L
s
.72828 .50391 m
.74401 .51404 L
s
.01 w
.77292 .55299 Mdot
.5 Mabswid
.77292 .55299 m
.77244 .55635 L
s
.76372 .55003 m
.77292 .55299 L
s
.7645 .54561 m
.77292 .55299 L
s
.01 w
.33674 .5608 Mdot
.5 Mabswid
.33674 .5608 m
.33877 .56374 L
s
.34676 .55519 m
.33674 .5608 L
s
.34628 .5504 m
.33674 .5608 L
s
.01 w
.77256 .54744 Mdot
.5 Mabswid
.77256 .54744 m
.76131 .5421 L
s
.7645 .54561 m
.77256 .54744 L
s
.01 w
.75703 .53546 Mdot
.5 Mabswid
.75703 .53546 m
.7645 .54561 L
s
.75703 .53546 m
.75157 .54073 L
s
.74491 .52958 m
.75703 .53546 L
s
.74782 .52414 m
.75703 .53546 L
s
.01 w
.7645 .54561 Mdot
.5 Mabswid
.7645 .54561 m
.76131 .5421 L
s
.7645 .54561 m
.75329 .54674 L
s
.7645 .54561 m
.76372 .55003 L
s
.75157 .54073 m
.7645 .54561 L
s
.01 w
.32945 .55272 Mdot
.5 Mabswid
.32945 .55272 m
.34074 .54523 L
s
.32945 .55272 m
.33422 .53981 L
s
.01 w
.37039 .55629 Mdot
.5 Mabswid
.37039 .55629 m
.38088 .54823 L
s
.37039 .55629 m
.35746 .55284 L
s
.37039 .55629 m
.39723 .55458 L
s
.01 w
.74782 .52414 Mdot
.5 Mabswid
.74782 .52414 m
.74491 .52958 L
s
.73492 .51685 m
.74782 .52414 L
s
.73804 .51309 m
.74782 .52414 L
s
.01 w
.77244 .55635 Mdot
.5 Mabswid
.76252 .55356 m
.77244 .55635 L
s
.76372 .55003 m
.77244 .55635 L
s
.01 w
.35746 .55284 Mdot
.5 Mabswid
.35746 .55284 m
.38088 .54823 L
s
.34628 .5504 m
.35746 .55284 L
s
.35692 .54352 m
.35746 .55284 L
s
.01 w
.73804 .51309 Mdot
.5 Mabswid
.73804 .51309 m
.73492 .51685 L
s
.72188 .50363 m
.73804 .51309 L
s
.72828 .50391 m
.73804 .51309 L
s
.01 w
.33877 .56374 Mdot
.5 Mabswid
.34922 .55727 m
.33877 .56374 L
s
.34676 .55519 m
.33877 .56374 L
s
.01 w
.35278 .53789 Mdot
.5 Mabswid
.35278 .53789 m
.34628 .5504 L
s
.35278 .53789 m
.35692 .54352 L
s
.36586 .53024 m
.35278 .53789 L
s
.36521 .52114 m
.35278 .53789 L
s
.01 w
.75329 .54674 Mdot
.5 Mabswid
.75329 .54674 m
.73319 .54231 L
s
.75157 .54073 m
.75329 .54674 L
s
.01 w
.47892 .56183 Mdot
.5 Mabswid
.47892 .56183 m
.50708 .56281 L
s
.45203 .55937 m
.47892 .56183 L
s
.49067 .55904 m
.47892 .56183 L
s
.46565 .55643 m
.47892 .56183 L
s
.01 w
.50708 .56281 Mdot
.5 Mabswid
.53856 .56175 m
.50708 .56281 L
s
.51582 .56018 m
.50708 .56281 L
s
.49067 .55904 m
.50708 .56281 L
s
.01 w
.34628 .5504 Mdot
.5 Mabswid
.34628 .5504 m
.34074 .54523 L
s
.34628 .5504 m
.34676 .55519 L
s
.35692 .54352 m
.34628 .5504 L
s
.01 w
.36987 .50778 Mdot
.5 Mabswid
.36987 .50778 m
.36521 .52114 L
s
.37891 .50537 m
.36987 .50778 L
s
.38681 .48699 m
.36987 .50778 L
s
.38663 .49205 m
.36987 .50778 L
s
.01 w
.51397 .56604 Mdot
.5 Mabswid
.51397 .56604 m
.53848 .56591 L
s
.51397 .56604 m
.53838 .56357 L
s
.51414 .56358 m
.51397 .56604 L
s
.48928 .56494 m
.51397 .56604 L
s
.4898 .56243 m
.51397 .56604 L
s
.01 w
.76372 .55003 Mdot
.5 Mabswid
.76372 .55003 m
.76252 .55356 L
s
.75249 .54594 m
.76372 .55003 L
s
.75157 .54073 m
.76372 .55003 L
s
.01 w
.45203 .55937 Mdot
.5 Mabswid
.42508 .55632 m
.45203 .55937 L
s
.46565 .55643 m
.45203 .55937 L
s
.44085 .55271 m
.45203 .55937 L
s
.01 w
.48928 .56494 Mdot
.5 Mabswid
.48928 .56494 m
.51414 .56358 L
s
.4898 .56243 m
.48928 .56494 L
s
.46452 .56262 m
.48928 .56494 L
s
.46498 .56007 m
.48928 .56494 L
s
.01 w
.53856 .56175 Mdot
.5 Mabswid
.57012 .56038 m
.53856 .56175 L
s
.56067 .55846 m
.53856 .56175 L
s
.53822 .55971 m
.53856 .56175 L
s
.51582 .56018 m
.53856 .56175 L
s
.01 w
.51414 .56358 Mdot
.5 Mabswid
.51414 .56358 m
.53848 .56591 L
s
.51414 .56358 m
.53838 .56357 L
s
.51414 .56358 m
.53822 .55971 L
s
.51582 .56018 m
.51414 .56358 L
s
.4898 .56243 m
.51414 .56358 L
s
.49067 .55904 m
.51414 .56358 L
s
.01 w
.39723 .55458 Mdot
.5 Mabswid
.39723 .55458 m
.38088 .54823 L
s
.39723 .55458 m
.42508 .55632 L
s
.41386 .54841 m
.39723 .55458 L
s
.01 w
.4898 .56243 Mdot
.5 Mabswid
.4898 .56243 m
.51582 .56018 L
s
.49067 .55904 m
.4898 .56243 L
s
.46452 .56262 m
.4898 .56243 L
s
.46498 .56007 m
.4898 .56243 L
s
.46565 .55643 m
.4898 .56243 L
s
.01 w
.53848 .56591 Mdot
.5 Mabswid
.53848 .56591 m
.56294 .56423 L
s
.53848 .56591 m
.56251 .56171 L
s
.53838 .56357 m
.53848 .56591 L
s
.01 w
.72828 .50391 Mdot
.5 Mabswid
.72828 .50391 m
.72188 .50363 L
s
.70844 .49112 m
.72828 .50391 L
s
.01 w
.51582 .56018 Mdot
.5 Mabswid
.51582 .56018 m
.53838 .56357 L
s
.51582 .56018 m
.53822 .55971 L
s
.51582 .56018 m
.53805 .55545 L
s
.51443 .55552 m
.51582 .56018 L
s
.49067 .55904 m
.51582 .56018 L
s
.49078 .55378 m
.51582 .56018 L
s
.01 w
.49067 .55904 Mdot
.5 Mabswid
.49067 .55904 m
.51443 .55552 L
s
.49078 .55378 m
.49067 .55904 L
s
.46498 .56007 m
.49067 .55904 L
s
.46565 .55643 m
.49067 .55904 L
s
.46688 .55032 m
.49067 .55904 L
s
.01 w
.42508 .55632 Mdot
.5 Mabswid
.44085 .55271 m
.42508 .55632 L
s
.41386 .54841 m
.42508 .55632 L
s
.01 w
.53838 .56357 Mdot
.5 Mabswid
.53838 .56357 m
.56294 .56423 L
s
.53838 .56357 m
.56251 .56171 L
s
.53838 .56357 m
.56067 .55846 L
s
.53822 .55971 m
.53838 .56357 L
s
.01 w
.46452 .56262 Mdot
.5 Mabswid
.46498 .56007 m
.46452 .56262 L
s
.44013 .55921 m
.46452 .56262 L
s
.44005 .55658 m
.46452 .56262 L
s
.01 w
.46498 .56007 Mdot
.5 Mabswid
.46565 .55643 m
.46498 .56007 L
s
.44013 .55921 m
.46498 .56007 L
s
.44005 .55658 m
.46498 .56007 L
s
.44085 .55271 m
.46498 .56007 L
s
.01 w
.53822 .55971 Mdot
.5 Mabswid
.53822 .55971 m
.56251 .56171 L
s
.53822 .55971 m
.56067 .55846 L
s
.53822 .55971 m
.56153 .55362 L
s
.53805 .55545 m
.53822 .55971 L
s
.51443 .55552 m
.53822 .55971 L
s
.01 w
.51443 .55552 Mdot
.5 Mabswid
.51443 .55552 m
.53805 .55545 L
s
.51443 .55552 m
.53785 .55128 L
s
.51452 .55106 m
.51443 .55552 L
s
.49078 .55378 m
.51443 .55552 L
s
.49125 .54844 m
.51443 .55552 L
s
.01 w
.46565 .55643 Mdot
.5 Mabswid
.46565 .55643 m
.49078 .55378 L
s
.46688 .55032 m
.46565 .55643 L
s
.44005 .55658 m
.46565 .55643 L
s
.44085 .55271 m
.46565 .55643 L
s
.44307 .54558 m
.46565 .55643 L
s
.01 w
.49078 .55378 Mdot
.5 Mabswid
.49078 .55378 m
.51452 .55106 L
s
.49125 .54844 m
.49078 .55378 L
s
.46688 .55032 m
.49078 .55378 L
s
.46841 .5438 m
.49078 .55378 L
s
.01 w
.57012 .56038 Mdot
.5 Mabswid
.59804 .55712 m
.57012 .56038 L
s
.58559 .5553 m
.57012 .56038 L
s
.56067 .55846 m
.57012 .56038 L
s
.01 w
.56294 .56423 Mdot
.5 Mabswid
.56294 .56423 m
.58742 .56111 L
s
.56294 .56423 m
.58667 .55865 L
s
.56251 .56171 m
.56294 .56423 L
s
.01 w
.34676 .55519 Mdot
.5 Mabswid
.34676 .55519 m
.34922 .55727 L
s
.35804 .54809 m
.34676 .55519 L
s
.35692 .54352 m
.34676 .55519 L
s
.01 w
.74491 .52958 Mdot
.5 Mabswid
.74491 .52958 m
.75157 .54073 L
s
.74491 .52958 m
.73786 .53457 L
s
.73313 .52279 m
.74491 .52958 L
s
.73492 .51685 m
.74491 .52958 L
s
.01 w
.53805 .55545 Mdot
.5 Mabswid
.53805 .55545 m
.56067 .55846 L
s
.53805 .55545 m
.56153 .55362 L
s
.53805 .55545 m
.56095 .54917 L
s
.53785 .55128 m
.53805 .55545 L
s
.51452 .55106 m
.53805 .55545 L
s
.01 w
.36521 .52114 Mdot
.5 Mabswid
.36521 .52114 m
.36586 .53024 L
s
.37564 .51719 m
.36521 .52114 L
s
.37891 .50537 m
.36521 .52114 L
s
.01 w
.51452 .55106 Mdot
.5 Mabswid
.51452 .55106 m
.53785 .55128 L
s
.51452 .55106 m
.53768 .54787 L
s
.51476 .54744 m
.51452 .55106 L
s
.49125 .54844 m
.51452 .55106 L
s
.492 .54409 m
.51452 .55106 L
s
.01 w
.56251 .56171 Mdot
.5 Mabswid
.56251 .56171 m
.58742 .56111 L
s
.56251 .56171 m
.58667 .55865 L
s
.56251 .56171 m
.58559 .5553 L
s
.56067 .55846 m
.56251 .56171 L
s
.01 w
.73492 .51685 Mdot
.5 Mabswid
.73492 .51685 m
.73313 .52279 L
s
.72053 .50989 m
.73492 .51685 L
s
.72188 .50363 m
.73492 .51685 L
s
.01 w
.51496 .54546 Mdot
.5 Mabswid
.51496 .54546 m
.53768 .54787 L
s
.51496 .54546 m
.53769 .54602 L
s
.51496 .54546 m
.51476 .54744 L
s
.492 .54409 m
.51496 .54546 L
s
.49247 .54176 m
.51496 .54546 L
s
.01 w
.56067 .55846 Mdot
.5 Mabswid
.56067 .55846 m
.58667 .55865 L
s
.56067 .55846 m
.58559 .5553 L
s
.56067 .55846 m
.58483 .55004 L
s
.56153 .55362 m
.56067 .55846 L
s
.01 w
.76252 .55356 Mdot
.5 Mabswid
.75164 .55022 m
.76252 .55356 L
s
.75249 .54594 m
.76252 .55356 L
s
.01 w
.51476 .54744 Mdot
.5 Mabswid
.51476 .54744 m
.53785 .55128 L
s
.51476 .54744 m
.53768 .54787 L
s
.51476 .54744 m
.53769 .54602 L
s
.49125 .54844 m
.51476 .54744 L
s
.492 .54409 m
.51476 .54744 L
s
.49247 .54176 m
.51476 .54744 L
s
.01 w
.53785 .55128 Mdot
.5 Mabswid
.53785 .55128 m
.56153 .55362 L
s
.53785 .55128 m
.56095 .54917 L
s
.53785 .55128 m
.56041 .5456 L
s
.53768 .54787 m
.53785 .55128 L
s
.01 w
.49125 .54844 Mdot
.5 Mabswid
.492 .54409 m
.49125 .54844 L
s
.46688 .55032 m
.49125 .54844 L
s
.46841 .5438 m
.49125 .54844 L
s
.4699 .53741 m
.49125 .54844 L
s
.01 w
.76131 .5421 Mdot
.5 Mabswid
.76131 .5421 m
.74779 .5339 L
s
.75157 .54073 m
.76131 .5421 L
s
.01 w
.46688 .55032 Mdot
.5 Mabswid
.46841 .5438 m
.46688 .55032 L
s
.44085 .55271 m
.46688 .55032 L
s
.44307 .54558 m
.46688 .55032 L
s
.44647 .53736 m
.46688 .55032 L
s
.01 w
.53769 .54602 Mdot
.5 Mabswid
.53769 .54602 m
.56041 .5456 L
s
.53769 .54602 m
.56013 .54365 L
s
.53769 .54602 m
.53768 .54787 L
s
.01 w
.75157 .54073 Mdot
.5 Mabswid
.75157 .54073 m
.74779 .5339 L
s
.75157 .54073 m
.73319 .54231 L
s
.75157 .54073 m
.75249 .54594 L
s
.73786 .53457 m
.75157 .54073 L
s
.01 w
.44013 .55921 Mdot
.5 Mabswid
.44005 .55658 m
.44013 .55921 L
s
.4157 .55467 m
.44013 .55921 L
s
.41691 .55226 m
.44013 .55921 L
s
.01 w
.44085 .55271 Mdot
.5 Mabswid
.44085 .55271 m
.44005 .55658 L
s
.44307 .54558 m
.44085 .55271 L
s
.41691 .55226 m
.44085 .55271 L
s
.41386 .54841 m
.44085 .55271 L
s
.42149 .53947 m
.44085 .55271 L
s
.01 w
.53768 .54787 Mdot
.5 Mabswid
.53768 .54787 m
.56095 .54917 L
s
.53768 .54787 m
.56041 .5456 L
s
.53768 .54787 m
.56013 .54365 L
s
.01 w
.44005 .55658 Mdot
.5 Mabswid
.4157 .55467 m
.44005 .55658 L
s
.41691 .55226 m
.44005 .55658 L
s
.41386 .54841 m
.44005 .55658 L
s
.01 w
.492 .54409 Mdot
.5 Mabswid
.49247 .54176 m
.492 .54409 L
s
.46841 .5438 m
.492 .54409 L
s
.4699 .53741 m
.492 .54409 L
s
.47079 .53427 m
.492 .54409 L
s
.01 w
.49247 .54176 Mdot
.5 Mabswid
.4699 .53741 m
.49247 .54176 L
s
.47079 .53427 m
.49247 .54176 L
s
.01 w
.56153 .55362 Mdot
.5 Mabswid
.56153 .55362 m
.58559 .5553 L
s
.56153 .55362 m
.58483 .55004 L
s
.56153 .55362 m
.58376 .54474 L
s
.56095 .54917 m
.56153 .55362 L
s
.01 w
.38088 .54823 Mdot
.5 Mabswid
.35692 .54352 m
.38088 .54823 L
s
.37071 .5349 m
.38088 .54823 L
s
.41386 .54841 m
.38088 .54823 L
s
.39801 .54353 m
.38088 .54823 L
s
.01 w
.59804 .55712 Mdot
.5 Mabswid
.62443 .55247 m
.59804 .55712 L
s
.61009 .55072 m
.59804 .55712 L
s
.58559 .5553 m
.59804 .55712 L
s
.01 w
.46841 .5438 Mdot
.5 Mabswid
.4699 .53741 m
.46841 .5438 L
s
.44307 .54558 m
.46841 .5438 L
s
.44647 .53736 m
.46841 .5438 L
s
.44923 .52903 m
.46841 .5438 L
s
.01 w
.58742 .56111 Mdot
.5 Mabswid
.58742 .56111 m
.61169 .55687 L
s
.58742 .56111 m
.61102 .55434 L
s
.58667 .55865 m
.58742 .56111 L
s
.01 w
.56095 .54917 Mdot
.5 Mabswid
.56095 .54917 m
.58483 .55004 L
s
.56095 .54917 m
.58376 .54474 L
s
.56095 .54917 m
.58256 .54045 L
s
.56041 .5456 m
.56095 .54917 L
s
.01 w
.34074 .54523 Mdot
.5 Mabswid
.34074 .54523 m
.34635 .53242 L
s
.33422 .53981 m
.34074 .54523 L
s
.35692 .54352 m
.34074 .54523 L
s
.01 w
.58667 .55865 Mdot
.5 Mabswid
.58667 .55865 m
.61169 .55687 L
s
.58667 .55865 m
.61102 .55434 L
s
.58667 .55865 m
.61009 .55072 L
s
.58559 .5553 m
.58667 .55865 L
s
.01 w
.56013 .54365 Mdot
.5 Mabswid
.56013 .54365 m
.58256 .54045 L
s
.56013 .54365 m
.58192 .53819 L
s
.56013 .54365 m
.56041 .5456 L
s
.01 w
.56041 .5456 Mdot
.5 Mabswid
.56041 .5456 m
.58376 .54474 L
s
.56041 .5456 m
.58256 .54045 L
s
.56041 .5456 m
.58192 .53819 L
s
.01 w
.58559 .5553 Mdot
.5 Mabswid
.58559 .5553 m
.61102 .55434 L
s
.58559 .5553 m
.61009 .55072 L
s
.58559 .5553 m
.60818 .54471 L
s
.58483 .55004 m
.58559 .5553 L
s
.01 w
.44307 .54558 Mdot
.5 Mabswid
.44647 .53736 m
.44307 .54558 L
s
.41386 .54841 m
.44307 .54558 L
s
.42149 .53947 m
.44307 .54558 L
s
.42539 .53 m
.44307 .54558 L
s
.01 w
.72188 .50363 Mdot
.5 Mabswid
.72188 .50363 m
.72053 .50989 L
s
.70266 .4927 m
.72188 .50363 L
s
.70844 .49112 m
.72188 .50363 L
s
.01 w
.38681 .48699 Mdot
.5 Mabswid
.38663 .49205 m
.38681 .48699 L
s
.40953 .46211 m
.38681 .48699 L
s
.405 .47215 m
.38681 .48699 L
s
.01 w
.41386 .54841 Mdot
.5 Mabswid
.41386 .54841 m
.41691 .55226 L
s
.42149 .53947 m
.41386 .54841 L
s
.39246 .54644 m
.41386 .54841 L
s
.39801 .54353 m
.41386 .54841 L
s
.39926 .5322 m
.41386 .54841 L
s
.01 w
.75249 .54594 Mdot
.5 Mabswid
.75249 .54594 m
.75164 .55022 L
s
.74191 .54284 m
.75249 .54594 L
s
.73786 .53457 m
.75249 .54594 L
s
.01 w
.34922 .55727 Mdot
.5 Mabswid
.35984 .55032 m
.34922 .55727 L
s
.35804 .54809 m
.34922 .55727 L
s
.01 w
.4699 .53741 Mdot
.5 Mabswid
.47079 .53427 m
.4699 .53741 L
s
.44647 .53736 m
.4699 .53741 L
s
.44923 .52903 m
.4699 .53741 L
s
.45075 .52003 m
.4699 .53741 L
s
.01 w
.73319 .54231 Mdot
.5 Mabswid
.73319 .54231 m
.71924 .53713 L
s
.73319 .54231 m
.70665 .54172 L
s
.73786 .53457 m
.73319 .54231 L
s
.01 w
.47079 .53427 Mdot
.5 Mabswid
.44923 .52903 m
.47079 .53427 L
s
.45075 .52003 m
.47079 .53427 L
s
.01 w
.58483 .55004 Mdot
.5 Mabswid
.58483 .55004 m
.61009 .55072 L
s
.58483 .55004 m
.60818 .54471 L
s
.58483 .55004 m
.60587 .53831 L
s
.58376 .54474 m
.58483 .55004 L
s
.01 w
.35692 .54352 Mdot
.5 Mabswid
.35692 .54352 m
.34635 .53242 L
s
.35692 .54352 m
.35804 .54809 L
s
.37071 .5349 m
.35692 .54352 L
s
.36586 .53024 m
.35692 .54352 L
s
.01 w
.41691 .55226 Mdot
.5 Mabswid
.41691 .55226 m
.4157 .55467 L
s
.39233 .54931 m
.41691 .55226 L
s
.39246 .54644 m
.41691 .55226 L
s
.39801 .54353 m
.41691 .55226 L
s
.01 w
.4157 .55467 Mdot
.5 Mabswid
.39233 .54931 m
.4157 .55467 L
s
.39246 .54644 m
.4157 .55467 L
s
.01 w
.44647 .53736 Mdot
.5 Mabswid
.44923 .52903 m
.44647 .53736 L
s
.42149 .53947 m
.44647 .53736 L
s
.42539 .53 m
.44647 .53736 L
s
.42987 .51948 m
.44647 .53736 L
s
.01 w
.58376 .54474 Mdot
.5 Mabswid
.58376 .54474 m
.60818 .54471 L
s
.58376 .54474 m
.60587 .53831 L
s
.58376 .54474 m
.60368 .53211 L
s
.58256 .54045 m
.58376 .54474 L
s
.01 w
.73313 .52279 Mdot
.5 Mabswid
.73313 .52279 m
.73786 .53457 L
s
.72255 .52164 m
.73313 .52279 L
s
.72053 .50989 m
.73313 .52279 L
s
.01 w
.62443 .55247 Mdot
.5 Mabswid
.65097 .54714 m
.62443 .55247 L
s
.63433 .54502 m
.62443 .55247 L
s
.61009 .55072 m
.62443 .55247 L
s
.01 w
.37891 .50537 Mdot
.5 Mabswid
.37891 .50537 m
.37564 .51719 L
s
.38535 .50558 m
.37891 .50537 L
s
.38663 .49205 m
.37891 .50537 L
s
.39483 .49046 m
.37891 .50537 L
s
.01 w
.61169 .55687 Mdot
.5 Mabswid
.61169 .55687 m
.63541 .55159 L
s
.61169 .55687 m
.63535 .54887 L
s
.61102 .55434 m
.61169 .55687 L
s
.01 w
.58256 .54045 Mdot
.5 Mabswid
.58256 .54045 m
.60587 .53831 L
s
.58256 .54045 m
.60368 .53211 L
s
.58256 .54045 m
.60248 .52905 L
s
.58192 .53819 m
.58256 .54045 L
s
.01 w
.58192 .53819 Mdot
.5 Mabswid
.58192 .53819 m
.60368 .53211 L
s
.58192 .53819 m
.60248 .52905 L
s
.01 w
.38663 .49205 Mdot
.5 Mabswid
.39483 .49046 m
.38663 .49205 L
s
.405 .47215 m
.38663 .49205 L
s
.01 w
.61102 .55434 Mdot
.5 Mabswid
.61102 .55434 m
.63541 .55159 L
s
.61102 .55434 m
.63535 .54887 L
s
.61102 .55434 m
.63433 .54502 L
s
.61009 .55072 m
.61102 .55434 L
s
.01 w
.36586 .53024 Mdot
.5 Mabswid
.36586 .53024 m
.37071 .5349 L
s
.37966 .5219 m
.36586 .53024 L
s
.37564 .51719 m
.36586 .53024 L
s
.01 w
.61009 .55072 Mdot
.5 Mabswid
.61009 .55072 m
.63535 .54887 L
s
.61009 .55072 m
.63433 .54502 L
s
.61009 .55072 m
.63125 .53808 L
s
.60818 .54471 m
.61009 .55072 L
s
.01 w
.42149 .53947 Mdot
.5 Mabswid
.42539 .53 m
.42149 .53947 L
s
.39801 .54353 m
.42149 .53947 L
s
.39926 .5322 m
.42149 .53947 L
s
.40571 .52177 m
.42149 .53947 L
s
.01 w
.70844 .49112 Mdot
.5 Mabswid
.70844 .49112 m
.70266 .4927 L
s
.68331 .47346 m
.70844 .49112 L
s
.01 w
.75164 .55022 Mdot
.5 Mabswid
.73981 .54643 m
.75164 .55022 L
s
.74191 .54284 m
.75164 .55022 L
s
.01 w
.39801 .54353 Mdot
.5 Mabswid
.39801 .54353 m
.37071 .5349 L
s
.39801 .54353 m
.39246 .54644 L
s
.39926 .5322 m
.39801 .54353 L
s
.01 w
.44923 .52903 Mdot
.5 Mabswid
.45075 .52003 m
.44923 .52903 L
s
.42539 .53 m
.44923 .52903 L
s
.42987 .51948 m
.44923 .52903 L
s
.43433 .50824 m
.44923 .52903 L
s
.01 w
.60818 .54471 Mdot
.5 Mabswid
.60818 .54471 m
.63433 .54502 L
s
.60818 .54471 m
.63125 .53808 L
s
.60818 .54471 m
.6269 .5302 L
s
.60587 .53831 m
.60818 .54471 L
s
.01 w
.72053 .50989 Mdot
.5 Mabswid
.72053 .50989 m
.72255 .52164 L
s
.70793 .50615 m
.72053 .50989 L
s
.70266 .4927 m
.72053 .50989 L
s
.01 w
.35804 .54809 Mdot
.5 Mabswid
.35804 .54809 m
.35984 .55032 L
s
.36878 .54204 m
.35804 .54809 L
s
.37071 .5349 m
.35804 .54809 L
s
.01 w
.73786 .53457 Mdot
.5 Mabswid
.73786 .53457 m
.7345 .52834 L
s
.73786 .53457 m
.74779 .5339 L
s
.73786 .53457 m
.71924 .53713 L
s
.73786 .53457 m
.74191 .54284 L
s
.73027 .53375 m
.73786 .53457 L
s
.72255 .52164 m
.73786 .53457 L
s
.01 w
.65097 .54714 Mdot
.5 Mabswid
.67886 .54285 m
.65097 .54714 L
s
.66073 .5385 m
.65097 .54714 L
s
.63433 .54502 m
.65097 .54714 L
s
.01 w
.70665 .54172 Mdot
.5 Mabswid
.70665 .54172 m
.69413 .53521 L
s
.70665 .54172 m
.71924 .53713 L
s
.70665 .54172 m
.67886 .54285 L
s
.01 w
.42539 .53 Mdot
.5 Mabswid
.42987 .51948 m
.42539 .53 L
s
.39926 .5322 m
.42539 .53 L
s
.40571 .52177 m
.42539 .53 L
s
.41181 .51087 m
.42539 .53 L
s
.01 w
.60587 .53831 Mdot
.5 Mabswid
.60587 .53831 m
.63125 .53808 L
s
.60587 .53831 m
.6269 .5302 L
s
.60587 .53831 m
.62318 .52214 L
s
.60368 .53211 m
.60587 .53831 L
s
.01 w
.37564 .51719 Mdot
.5 Mabswid
.37564 .51719 m
.37966 .5219 L
s
.38656 .51357 m
.37564 .51719 L
s
.38535 .50558 m
.37564 .51719 L
s
.01 w
.45075 .52003 Mdot
.5 Mabswid
.45075 .52003 m
.4431 .4945 L
s
.42987 .51948 m
.45075 .52003 L
s
.43433 .50824 m
.45075 .52003 L
s
.01 w
.39246 .54644 Mdot
.5 Mabswid
.39246 .54644 m
.37026 .5418 L
s
.39246 .54644 m
.36878 .54204 L
s
.39246 .54644 m
.37071 .5349 L
s
.39246 .54644 m
.39233 .54931 L
s
.01 w
.74191 .54284 Mdot
.5 Mabswid
.74191 .54284 m
.73981 .54643 L
s
.72989 .53896 m
.74191 .54284 L
s
.73027 .53375 m
.74191 .54284 L
s
.01 w
.33422 .53981 Mdot
.5 Mabswid
.33422 .53981 m
.34635 .53242 L
s
.33422 .53981 m
.33399 .5256 L
s
.01 w
.60368 .53211 Mdot
.5 Mabswid
.60368 .53211 m
.6269 .5302 L
s
.60368 .53211 m
.62318 .52214 L
s
.60368 .53211 m
.62073 .51332 L
s
.60248 .52905 m
.60368 .53211 L
s
.01 w
.63433 .54502 Mdot
.5 Mabswid
.63433 .54502 m
.6577 .54276 L
s
.63433 .54502 m
.66073 .5385 L
s
.63433 .54502 m
.65191 .53028 L
s
.63433 .54502 m
.63535 .54887 L
s
.63125 .53808 m
.63433 .54502 L
s
.01 w
.63535 .54887 Mdot
.5 Mabswid
.63535 .54887 m
.65901 .54513 L
s
.63535 .54887 m
.6577 .54276 L
s
.63535 .54887 m
.66073 .5385 L
s
.63535 .54887 m
.63541 .55159 L
s
.01 w
.63541 .55159 Mdot
.5 Mabswid
.63541 .55159 m
.65901 .54513 L
s
.63541 .55159 m
.6577 .54276 L
s
.01 w
.39233 .54931 Mdot
.5 Mabswid
.39233 .54931 m
.37026 .5418 L
s
.39233 .54931 m
.36878 .54204 L
s
.01 w
.60248 .52905 Mdot
.5 Mabswid
.60248 .52905 m
.62318 .52214 L
s
.60248 .52905 m
.62073 .51332 L
s
.01 w
.67886 .54285 Mdot
.5 Mabswid
.67886 .54285 m
.69413 .53521 L
s
.66073 .5385 m
.67886 .54285 L
s
.01 w
.39926 .5322 Mdot
.5 Mabswid
.39926 .5322 m
.37071 .5349 L
s
.39926 .5322 m
.37966 .5219 L
s
.39926 .5322 m
.38656 .51357 L
s
.40571 .52177 m
.39926 .5322 L
s
.01 w
.71924 .53713 Mdot
.5 Mabswid
.71924 .53713 m
.69413 .53521 L
s
.73027 .53375 m
.71924 .53713 L
s
.71766 .52839 m
.71924 .53713 L
s
.01 w
.42987 .51948 Mdot
.5 Mabswid
.43433 .50824 m
.42987 .51948 L
s
.40571 .52177 m
.42987 .51948 L
s
.41181 .51087 m
.42987 .51948 L
s
.41873 .49663 m
.42987 .51948 L
s
.01 w
.35984 .55032 Mdot
.5 Mabswid
.37026 .5418 m
.35984 .55032 L
s
.36878 .54204 m
.35984 .55032 L
s
.01 w
.63125 .53808 Mdot
.5 Mabswid
.63125 .53808 m
.66073 .5385 L
s
.63125 .53808 m
.65191 .53028 L
s
.63125 .53808 m
.64689 .52119 L
s
.6269 .5302 m
.63125 .53808 L
s
.01 w
.70266 .4927 Mdot
.5 Mabswid
.70266 .4927 m
.70793 .50615 L
s
.69208 .49178 m
.70266 .4927 L
s
.68331 .47346 m
.70266 .4927 L
s
.68336 .47885 m
.70266 .4927 L
s
.01 w
.74779 .5339 Mdot
.5 Mabswid
.74779 .5339 m
.7345 .52834 L
s
.74779 .5339 m
.73965 .52271 L
s
.01 w
.72255 .52164 Mdot
.5 Mabswid
.72255 .52164 m
.73027 .53375 L
s
.72255 .52164 m
.71766 .52839 L
s
.70724 .51587 m
.72255 .52164 L
s
.70793 .50615 m
.72255 .52164 L
s
.01 w
.38535 .50558 Mdot
.5 Mabswid
.38535 .50558 m
.38656 .51357 L
s
.39466 .50216 m
.38535 .50558 L
s
.39483 .49046 m
.38535 .50558 L
s
.01 w
.40953 .46211 Mdot
.5 Mabswid
.405 .47215 m
.40953 .46211 L
s
.42952 .43983 m
.40953 .46211 L
s
.4244 .44893 m
.40953 .46211 L
s
.01 w
.40571 .52177 Mdot
.5 Mabswid
.40571 .52177 m
.37966 .5219 L
s
.40571 .52177 m
.38656 .51357 L
s
.40571 .52177 m
.39466 .50216 L
s
.41181 .51087 m
.40571 .52177 L
s
.01 w
.73027 .53375 Mdot
.5 Mabswid
.73027 .53375 m
.7345 .52834 L
s
.73027 .53375 m
.72989 .53896 L
s
.71766 .52839 m
.73027 .53375 L
s
.01 w
.73981 .54643 Mdot
.5 Mabswid
.72712 .54168 m
.73981 .54643 L
s
.72989 .53896 m
.73981 .54643 L
s
.01 w
.6269 .5302 Mdot
.5 Mabswid
.6269 .5302 m
.65191 .53028 L
s
.6269 .5302 m
.64689 .52119 L
s
.6269 .5302 m
.64124 .5111 L
s
.62318 .52214 m
.6269 .5302 L
s
.01 w
.43433 .50824 Mdot
.5 Mabswid
.43433 .50824 m
.4431 .4945 L
s
.43433 .50824 m
.43455 .4842 L
s
.41181 .51087 m
.43433 .50824 L
s
.41873 .49663 m
.43433 .50824 L
s
.01 w
.39483 .49046 Mdot
.5 Mabswid
.39483 .49046 m
.39466 .50216 L
s
.40231 .49084 m
.39483 .49046 L
s
.405 .47215 m
.39483 .49046 L
s
.41198 .47216 m
.39483 .49046 L
s
.01 w
.37071 .5349 Mdot
.5 Mabswid
.37071 .5349 m
.34635 .53242 L
s
.37071 .5349 m
.36878 .54204 L
s
.37966 .5219 m
.37071 .5349 L
s
.35376 .52866 m
.37071 .5349 L
s
.35129 .52199 m
.37071 .5349 L
s
.36288 .51532 m
.37071 .5349 L
s
.01 w
.405 .47215 Mdot
.5 Mabswid
.41198 .47216 m
.405 .47215 L
s
.4244 .44893 m
.405 .47215 L
s
.42501 .45405 m
.405 .47215 L
s
.01 w
.66073 .5385 Mdot
.5 Mabswid
.66073 .5385 m
.69413 .53521 L
s
.66073 .5385 m
.68113 .53509 L
s
.66073 .5385 m
.67574 .53242 L
s
.66073 .5385 m
.67303 .52126 L
s
.66073 .5385 m
.6577 .54276 L
s
.65191 .53028 m
.66073 .5385 L
s
.01 w
.62318 .52214 Mdot
.5 Mabswid
.62318 .52214 m
.64689 .52119 L
s
.62318 .52214 m
.64124 .5111 L
s
.62318 .52214 m
.63564 .50025 L
s
.62073 .51332 m
.62318 .52214 L
s
.01 w
.70793 .50615 Mdot
.5 Mabswid
.70793 .50615 m
.70724 .51587 L
s
.69575 .50377 m
.70793 .50615 L
s
.69208 .49178 m
.70793 .50615 L
s
.01 w
.6577 .54276 Mdot
.5 Mabswid
.6577 .54276 m
.68134 .53806 L
s
.6577 .54276 m
.68113 .53509 L
s
.6577 .54276 m
.67574 .53242 L
s
.6577 .54276 m
.65901 .54513 L
s
.01 w
.41181 .51087 Mdot
.5 Mabswid
.41181 .51087 m
.38656 .51357 L
s
.41181 .51087 m
.39466 .50216 L
s
.41181 .51087 m
.40231 .49084 L
s
.41873 .49663 m
.41181 .51087 L
s
.01 w
.69413 .53521 Mdot
.5 Mabswid
.71766 .52839 m
.69413 .53521 L
s
.70151 .52166 m
.69413 .53521 L
s
.67574 .53242 m
.69413 .53521 L
s
.01 w
.36878 .54204 Mdot
.5 Mabswid
.36878 .54204 m
.37026 .5418 L
s
.35271 .53116 m
.36878 .54204 L
s
.35376 .52866 m
.36878 .54204 L
s
.01 w
.65901 .54513 Mdot
.5 Mabswid
.65901 .54513 m
.68134 .53806 L
s
.65901 .54513 m
.68113 .53509 L
s
.01 w
.37966 .5219 Mdot
.5 Mabswid
.38656 .51357 m
.37966 .5219 L
s
.36288 .51532 m
.37966 .5219 L
s
.37115 .50562 m
.37966 .5219 L
s
.01 w
.68331 .47346 Mdot
.5 Mabswid
.68336 .47885 m
.68331 .47346 L
s
.65742 .4508 m
.68331 .47346 L
s
.66242 .46072 m
.68331 .47346 L
s
.01 w
.72989 .53896 Mdot
.5 Mabswid
.72989 .53896 m
.72712 .54168 L
s
.71643 .53354 m
.72989 .53896 L
s
.71766 .52839 m
.72989 .53896 L
s
.01 w
.4431 .4945 Mdot
.5 Mabswid
.43455 .4842 m
.4431 .4945 L
s
.44527 .46603 m
.4431 .4945 L
s
.01 w
.65191 .53028 Mdot
.5 Mabswid
.65191 .53028 m
.67574 .53242 L
s
.65191 .53028 m
.67303 .52126 L
s
.65191 .53028 m
.66534 .51138 L
s
.64689 .52119 m
.65191 .53028 L
s
.01 w
.62073 .51332 Mdot
.5 Mabswid
.62073 .51332 m
.62552 .48723 L
s
.62073 .51332 m
.64124 .5111 L
s
.62073 .51332 m
.63564 .50025 L
s
.01 w
.34635 .53242 Mdot
.5 Mabswid
.33399 .5256 m
.34635 .53242 L
s
.35129 .52199 m
.34635 .53242 L
s
.34062 .5146 m
.34635 .53242 L
s
.01 w
.37026 .5418 Mdot
.5 Mabswid
.35271 .53116 m
.37026 .5418 L
s
.35376 .52866 m
.37026 .5418 L
s
.01 w
.64689 .52119 Mdot
.5 Mabswid
.64689 .52119 m
.67303 .52126 L
s
.64689 .52119 m
.66534 .51138 L
s
.64689 .52119 m
.65808 .501 L
s
.64124 .5111 m
.64689 .52119 L
s
.01 w
.38656 .51357 Mdot
.5 Mabswid
.39466 .50216 m
.38656 .51357 L
s
.36288 .51532 m
.38656 .51357 L
s
.37115 .50562 m
.38656 .51357 L
s
.37976 .49578 m
.38656 .51357 L
s
.01 w
.41873 .49663 Mdot
.5 Mabswid
.41873 .49663 m
.43455 .4842 L
s
.41873 .49663 m
.42635 .47865 L
s
.41873 .49663 m
.39466 .50216 L
s
.41873 .49663 m
.40231 .49084 L
s
.41873 .49663 m
.4162 .47359 L
s
.01 w
.67574 .53242 Mdot
.5 Mabswid
.67574 .53242 m
.70151 .52166 L
s
.67574 .53242 m
.68113 .53509 L
s
.67303 .52126 m
.67574 .53242 L
s
.01 w
.68336 .47885 Mdot
.5 Mabswid
.68336 .47885 m
.69208 .49178 L
s
.67379 .47853 m
.68336 .47885 L
s
.66242 .46072 m
.68336 .47885 L
s
.01 w
.7345 .52834 Mdot
.5 Mabswid
.7345 .52834 m
.72554 .51703 L
s
.73965 .52271 m
.7345 .52834 L
s
.71766 .52839 m
.7345 .52834 L
s
.01 w
.69208 .49178 Mdot
.5 Mabswid
.69208 .49178 m
.69575 .50377 L
s
.68456 .49303 m
.69208 .49178 L
s
.67379 .47853 m
.69208 .49178 L
s
.01 w
.71766 .52839 Mdot
.5 Mabswid
.71766 .52839 m
.72554 .51703 L
s
.71766 .52839 m
.71643 .53354 L
s
.70151 .52166 m
.71766 .52839 L
s
.70724 .51587 m
.71766 .52839 L
s
.01 w
.72712 .54168 Mdot
.5 Mabswid
.71435 .53625 m
.72712 .54168 L
s
.71643 .53354 m
.72712 .54168 L
s
.01 w
.43455 .4842 Mdot
.5 Mabswid
.42635 .47865 m
.43455 .4842 L
s
.44527 .46603 m
.43455 .4842 L
s
.43752 .46035 m
.43455 .4842 L
s
.01 w
.64124 .5111 Mdot
.5 Mabswid
.64124 .5111 m
.66534 .51138 L
s
.64124 .5111 m
.65808 .501 L
s
.64124 .5111 m
.64969 .48739 L
s
.63564 .50025 m
.64124 .5111 L
s
.01 w
.39466 .50216 Mdot
.5 Mabswid
.40231 .49084 m
.39466 .50216 L
s
.37115 .50562 m
.39466 .50216 L
s
.37976 .49578 m
.39466 .50216 L
s
.39145 .48365 m
.39466 .50216 L
s
.01 w
.70724 .51587 Mdot
.5 Mabswid
.70724 .51587 m
.70151 .52166 L
s
.69107 .50938 m
.70724 .51587 L
s
.69575 .50377 m
.70724 .51587 L
s
.01 w
.4244 .44893 Mdot
.5 Mabswid
.4244 .44893 m
.42952 .43983 L
s
.42501 .45405 m
.4244 .44893 L
s
.44282 .42835 m
.4244 .44893 L
s
.44173 .43446 m
.4244 .44893 L
s
.01 w
.42952 .43983 Mdot
.5 Mabswid
.4475 .42021 m
.42952 .43983 L
s
.44282 .42835 m
.42952 .43983 L
s
.01 w
.41198 .47216 Mdot
.5 Mabswid
.41198 .47216 m
.40231 .49084 L
s
.4162 .47359 m
.41198 .47216 L
s
.42501 .45405 m
.41198 .47216 L
s
.43023 .45394 m
.41198 .47216 L
s
.01 w
.68113 .53509 Mdot
.5 Mabswid
.68113 .53509 m
.702 .52893 L
s
.68113 .53509 m
.70369 .52896 L
s
.68113 .53509 m
.70151 .52166 L
s
.68113 .53509 m
.68134 .53806 L
s
.01 w
.40231 .49084 Mdot
.5 Mabswid
.4162 .47359 m
.40231 .49084 L
s
.37976 .49578 m
.40231 .49084 L
s
.39145 .48365 m
.40231 .49084 L
s
.01 w
.67303 .52126 Mdot
.5 Mabswid
.67303 .52126 m
.70151 .52166 L
s
.67303 .52126 m
.69107 .50938 L
s
.67303 .52126 m
.68314 .50164 L
s
.66534 .51138 m
.67303 .52126 L
s
.01 w
.63564 .50025 Mdot
.5 Mabswid
.63564 .50025 m
.62552 .48723 L
s
.63564 .50025 m
.63277 .47623 L
s
.63564 .50025 m
.65808 .501 L
s
.63564 .50025 m
.64969 .48739 L
s
.01 w
.42635 .47865 Mdot
.5 Mabswid
.43752 .46035 m
.42635 .47865 L
s
.4162 .47359 m
.42635 .47865 L
s
.01 w
.68134 .53806 Mdot
.5 Mabswid
.68134 .53806 m
.702 .52893 L
s
.68134 .53806 m
.70369 .52896 L
s
.01 w
.69575 .50377 Mdot
.5 Mabswid
.69575 .50377 m
.69107 .50938 L
s
.68314 .50164 m
.69575 .50377 L
s
.68456 .49303 m
.69575 .50377 L
s
.01 w
.71643 .53354 Mdot
.5 Mabswid
.71643 .53354 m
.71435 .53625 L
s
.70369 .52896 m
.71643 .53354 L
s
.70151 .52166 m
.71643 .53354 L
s
.01 w
.65742 .4508 Mdot
.5 Mabswid
.66242 .46072 m
.65742 .4508 L
s
.63475 .43037 m
.65742 .4508 L
s
.64043 .43918 m
.65742 .4508 L
s
.01 w
.66534 .51138 Mdot
.5 Mabswid
.66534 .51138 m
.69107 .50938 L
s
.66534 .51138 m
.68314 .50164 L
s
.66534 .51138 m
.67388 .49086 L
s
.65808 .501 m
.66534 .51138 L
s
.01 w
.42501 .45405 Mdot
.5 Mabswid
.43023 .45394 m
.42501 .45405 L
s
.44173 .43446 m
.42501 .45405 L
s
.44334 .43875 m
.42501 .45405 L
s
.01 w
.62552 .48723 Mdot
.5 Mabswid
.63277 .47623 m
.62552 .48723 L
s
.62005 .4589 m
.62552 .48723 L
s
.01 w
.66242 .46072 Mdot
.5 Mabswid
.66242 .46072 m
.67379 .47853 L
s
.65431 .46189 m
.66242 .46072 L
s
.64043 .43918 m
.66242 .46072 L
s
.63958 .44469 m
.66242 .46072 L
s
.01 w
.44527 .46603 Mdot
.5 Mabswid
.43752 .46035 m
.44527 .46603 L
s
.45468 .44317 m
.44527 .46603 L
s
.45119 .44123 m
.44527 .46603 L
s
.01 w
.33399 .5256 Mdot
.5 Mabswid
.33399 .5256 m
.32721 .51118 L
s
.34062 .5146 m
.33399 .5256 L
s
.01 w
.68456 .49303 Mdot
.5 Mabswid
.68456 .49303 m
.68314 .50164 L
s
.67388 .49086 m
.68456 .49303 L
s
.67379 .47853 m
.68456 .49303 L
s
.01 w
.67379 .47853 Mdot
.5 Mabswid
.67379 .47853 m
.67388 .49086 L
s
.66519 .48017 m
.67379 .47853 L
s
.65431 .46189 m
.67379 .47853 L
s
.01 w
.71435 .53625 Mdot
.5 Mabswid
.702 .52893 m
.71435 .53625 L
s
.70369 .52896 m
.71435 .53625 L
s
.01 w
.65808 .501 Mdot
.5 Mabswid
.65808 .501 m
.68314 .50164 L
s
.65808 .501 m
.67388 .49086 L
s
.65808 .501 m
.66519 .48017 L
s
.64969 .48739 m
.65808 .501 L
s
.01 w
.35376 .52866 Mdot
.5 Mabswid
.35376 .52866 m
.35271 .53116 L
s
.35129 .52199 m
.35376 .52866 L
s
.33807 .51891 m
.35376 .52866 L
s
.33895 .5163 m
.35376 .52866 L
s
.34062 .5146 m
.35376 .52866 L
s
.01 w
.36288 .51532 Mdot
.5 Mabswid
.36288 .51532 m
.35129 .52199 L
s
.37115 .50562 m
.36288 .51532 L
s
.34062 .5146 m
.36288 .51532 L
s
.34825 .50541 m
.36288 .51532 L
s
.35655 .49777 m
.36288 .51532 L
s
.01 w
.73965 .52271 Mdot
.5 Mabswid
.73965 .52271 m
.72554 .51703 L
s
.73965 .52271 m
.73647 .50951 L
s
.01 w
.4162 .47359 Mdot
.5 Mabswid
.4162 .47359 m
.43752 .46035 L
s
.4162 .47359 m
.4064 .46902 L
s
.4162 .47359 m
.42243 .45297 L
s
.43023 .45394 m
.4162 .47359 L
s
.39145 .48365 m
.4162 .47359 L
s
.01 w
.35129 .52199 Mdot
.5 Mabswid
.33895 .5163 m
.35129 .52199 L
s
.34062 .5146 m
.35129 .52199 L
s
.34825 .50541 m
.35129 .52199 L
s
.01 w
.35271 .53116 Mdot
.5 Mabswid
.33807 .51891 m
.35271 .53116 L
s
.33895 .5163 m
.35271 .53116 L
s
.01 w
.70151 .52166 Mdot
.5 Mabswid
.70151 .52166 m
.72554 .51703 L
s
.70151 .52166 m
.70369 .52896 L
s
.69107 .50938 m
.70151 .52166 L
s
.71637 .51471 m
.70151 .52166 L
s
.71825 .50766 m
.70151 .52166 L
s
.70612 .5018 m
.70151 .52166 L
s
.01 w
.43752 .46035 Mdot
.5 Mabswid
.45468 .44317 m
.43752 .46035 L
s
.45119 .44123 m
.43752 .46035 L
s
.43023 .45394 m
.43752 .46035 L
s
.44334 .43875 m
.43752 .46035 L
s
.01 w
.44282 .42835 Mdot
.5 Mabswid
.44282 .42835 m
.4475 .42021 L
s
.44173 .43446 m
.44282 .42835 L
s
.45979 .41045 m
.44282 .42835 L
s
.45947 .41543 m
.44282 .42835 L
s
.01 w
.37115 .50562 Mdot
.5 Mabswid
.37976 .49578 m
.37115 .50562 L
s
.34825 .50541 m
.37115 .50562 L
s
.35655 .49777 m
.37115 .50562 L
s
.36539 .48908 m
.37115 .50562 L
s
.01 w
.4475 .42021 Mdot
.5 Mabswid
.46376 .40322 m
.4475 .42021 L
s
.45979 .41045 m
.4475 .42021 L
s
.01 w
.64969 .48739 Mdot
.5 Mabswid
.64969 .48739 m
.63277 .47623 L
s
.64969 .48739 m
.64022 .46999 L
s
.64969 .48739 m
.67388 .49086 L
s
.64969 .48739 m
.66519 .48017 L
s
.64969 .48739 m
.64946 .46408 L
s
.01 w
.63277 .47623 Mdot
.5 Mabswid
.64022 .46999 m
.63277 .47623 L
s
.62005 .4589 m
.63277 .47623 L
s
.62701 .45255 m
.63277 .47623 L
s
.01 w
.69107 .50938 Mdot
.5 Mabswid
.68314 .50164 m
.69107 .50938 L
s
.70612 .5018 m
.69107 .50938 L
s
.69678 .49274 m
.69107 .50938 L
s
.01 w
.37976 .49578 Mdot
.5 Mabswid
.39145 .48365 m
.37976 .49578 L
s
.35655 .49777 m
.37976 .49578 L
s
.36539 .48908 m
.37976 .49578 L
s
.37481 .47997 m
.37976 .49578 L
s
.01 w
.63475 .43037 Mdot
.5 Mabswid
.64043 .43918 m
.63475 .43037 L
s
.61431 .41242 m
.63475 .43037 L
s
.61954 .42024 m
.63475 .43037 L
s
.01 w
.70369 .52896 Mdot
.5 Mabswid
.70369 .52896 m
.702 .52893 L
s
.71735 .51731 m
.70369 .52896 L
s
.71637 .51471 m
.70369 .52896 L
s
.01 w
.43023 .45394 Mdot
.5 Mabswid
.43023 .45394 m
.45119 .44123 L
s
.43023 .45394 m
.42243 .45297 L
s
.43023 .45394 m
.43905 .43522 L
s
.44334 .43875 m
.43023 .45394 L
s
.01 w
.64043 .43918 Mdot
.5 Mabswid
.63958 .44469 m
.64043 .43918 L
s
.61954 .42024 m
.64043 .43918 L
s
.62059 .42653 m
.64043 .43918 L
s
.01 w
.44173 .43446 Mdot
.5 Mabswid
.44334 .43875 m
.44173 .43446 L
s
.45947 .41543 m
.44173 .43446 L
s
.45994 .42018 m
.44173 .43446 L
s
.01 w
.39145 .48365 Mdot
.5 Mabswid
.39145 .48365 m
.39854 .46686 L
s
.39145 .48365 m
.4064 .46902 L
s
.36539 .48908 m
.39145 .48365 L
s
.37481 .47997 m
.39145 .48365 L
s
.01 w
.68314 .50164 Mdot
.5 Mabswid
.67388 .49086 m
.68314 .50164 L
s
.70612 .5018 m
.68314 .50164 L
s
.69678 .49274 m
.68314 .50164 L
s
.68718 .48352 m
.68314 .50164 L
s
.01 w
.702 .52893 Mdot
.5 Mabswid
.71735 .51731 m
.702 .52893 L
s
.71637 .51471 m
.702 .52893 L
s
.01 w
.4064 .46902 Mdot
.5 Mabswid
.4064 .46902 m
.39854 .46686 L
s
.42243 .45297 m
.4064 .46902 L
s
.01 w
.65431 .46189 Mdot
.5 Mabswid
.65431 .46189 m
.66519 .48017 L
s
.64946 .46408 m
.65431 .46189 L
s
.63958 .44469 m
.65431 .46189 L
s
.63352 .44544 m
.65431 .46189 L
s
.01 w
.64022 .46999 Mdot
.5 Mabswid
.62701 .45255 m
.64022 .46999 L
s
.64946 .46408 m
.64022 .46999 L
s
.01 w
.67388 .49086 Mdot
.5 Mabswid
.66519 .48017 m
.67388 .49086 L
s
.69678 .49274 m
.67388 .49086 L
s
.68718 .48352 m
.67388 .49086 L
s
.67446 .47226 m
.67388 .49086 L
s
.01 w
.45468 .44317 Mdot
.5 Mabswid
.45119 .44123 m
.45468 .44317 L
s
.47004 .42334 m
.45468 .44317 L
s
.46681 .42176 m
.45468 .44317 L
s
.01 w
.72554 .51703 Mdot
.5 Mabswid
.73647 .50951 m
.72554 .51703 L
s
.72742 .49962 m
.72554 .51703 L
s
.71825 .50766 m
.72554 .51703 L
s
.01 w
.62005 .4589 Mdot
.5 Mabswid
.62701 .45255 m
.62005 .4589 L
s
.6079 .43682 m
.62005 .4589 L
s
.61113 .43456 m
.62005 .4589 L
s
.01 w
.66519 .48017 Mdot
.5 Mabswid
.64946 .46408 m
.66519 .48017 L
s
.68718 .48352 m
.66519 .48017 L
s
.67446 .47226 m
.66519 .48017 L
s
.01 w
.45119 .44123 Mdot
.5 Mabswid
.47004 .42334 m
.45119 .44123 L
s
.46681 .42176 m
.45119 .44123 L
s
.44334 .43875 m
.45119 .44123 L
s
.45994 .42018 m
.45119 .44123 L
s
.01 w
.63958 .44469 Mdot
.5 Mabswid
.63352 .44544 m
.63958 .44469 L
s
.62059 .42653 m
.63958 .44469 L
s
.61864 .43134 m
.63958 .44469 L
s
.01 w
.42243 .45297 Mdot
.5 Mabswid
.42243 .45297 m
.39854 .46686 L
s
.42243 .45297 m
.41426 .45089 L
s
.4361 .43394 m
.42243 .45297 L
s
.43905 .43522 m
.42243 .45297 L
s
.44334 .43875 m
.42243 .45297 L
s
.01 w
.44334 .43875 Mdot
.5 Mabswid
.44334 .43875 m
.46681 .42176 L
s
.44334 .43875 m
.43905 .43522 L
s
.44334 .43875 m
.45694 .41679 L
s
.45994 .42018 m
.44334 .43875 L
s
.01 w
.34062 .5146 Mdot
.5 Mabswid
.34062 .5146 m
.32721 .51118 L
s
.34062 .5146 m
.33895 .5163 L
s
.34825 .50541 m
.34062 .5146 L
s
.32701 .50419 m
.34062 .5146 L
s
.3294 .50095 m
.34062 .5146 L
s
.33583 .49553 m
.34062 .5146 L
s
.01 w
.61431 .41242 Mdot
.5 Mabswid
.61954 .42024 m
.61431 .41242 L
s
.59567 .39706 m
.61431 .41242 L
s
.6002 .40394 m
.61431 .41242 L
s
.01 w
.45979 .41045 Mdot
.5 Mabswid
.45979 .41045 m
.46376 .40322 L
s
.45947 .41543 m
.45979 .41045 L
s
.47579 .39522 m
.45979 .41045 L
s
.47526 .39964 m
.45979 .41045 L
s
.01 w
.61954 .42024 Mdot
.5 Mabswid
.62059 .42653 m
.61954 .42024 L
s
.6002 .40394 m
.61954 .42024 L
s
.60044 .4091 m
.61954 .42024 L
s
.01 w
.46376 .40322 Mdot
.5 Mabswid
.47833 .38902 m
.46376 .40322 L
s
.47579 .39522 m
.46376 .40322 L
s
.01 w
.62701 .45255 Mdot
.5 Mabswid
.6079 .43682 m
.62701 .45255 L
s
.61113 .43456 m
.62701 .45255 L
s
.64946 .46408 m
.62701 .45255 L
s
.63352 .44544 m
.62701 .45255 L
s
.61864 .43134 m
.62701 .45255 L
s
.01 w
.39854 .46686 Mdot
.5 Mabswid
.39854 .46686 m
.38559 .46693 L
s
.41426 .45089 m
.39854 .46686 L
s
.37481 .47997 m
.39854 .46686 L
s
.01 w
.64946 .46408 Mdot
.5 Mabswid
.64946 .46408 m
.65833 .45875 L
s
.64946 .46408 m
.64068 .44393 L
s
.63352 .44544 m
.64946 .46408 L
s
.67446 .47226 m
.64946 .46408 L
s
.01 w
.45947 .41543 Mdot
.5 Mabswid
.45994 .42018 m
.45947 .41543 L
s
.47526 .39964 m
.45947 .41543 L
s
.47996 .39936 m
.45947 .41543 L
s
.01 w
.62059 .42653 Mdot
.5 Mabswid
.61864 .43134 m
.62059 .42653 L
s
.60044 .4091 m
.62059 .42653 L
s
.59976 .41421 m
.62059 .42653 L
s
.01 w
.34825 .50541 Mdot
.5 Mabswid
.35655 .49777 m
.34825 .50541 L
s
.3294 .50095 m
.34825 .50541 L
s
.33583 .49553 m
.34825 .50541 L
s
.343 .48882 m
.34825 .50541 L
s
.01 w
.33895 .5163 Mdot
.5 Mabswid
.33895 .5163 m
.33807 .51891 L
s
.32516 .50603 m
.33895 .5163 L
s
.32701 .50419 m
.33895 .5163 L
s
.3294 .50095 m
.33895 .5163 L
s
.01 w
.63352 .44544 Mdot
.5 Mabswid
.63352 .44544 m
.64068 .44393 L
s
.63352 .44544 m
.62213 .42751 L
s
.63352 .44544 m
.61113 .43456 L
s
.61864 .43134 m
.63352 .44544 L
s
.01 w
.33807 .51891 Mdot
.5 Mabswid
.32516 .50603 m
.33807 .51891 L
s
.32701 .50419 m
.33807 .51891 L
s
.01 w
.35655 .49777 Mdot
.5 Mabswid
.36539 .48908 m
.35655 .49777 L
s
.33583 .49553 m
.35655 .49777 L
s
.343 .48882 m
.35655 .49777 L
s
.3502 .48233 m
.35655 .49777 L
s
.01 w
.41426 .45089 Mdot
.5 Mabswid
.41426 .45089 m
.38559 .46693 L
s
.4361 .43394 m
.41426 .45089 L
s
.43905 .43522 m
.41426 .45089 L
s
.01 w
.43905 .43522 Mdot
.5 Mabswid
.43905 .43522 m
.4361 .43394 L
s
.45421 .41537 m
.43905 .43522 L
s
.45694 .41679 m
.43905 .43522 L
s
.45994 .42018 m
.43905 .43522 L
s
.01 w
.6079 .43682 Mdot
.5 Mabswid
.61113 .43456 m
.6079 .43682 L
s
.59011 .41831 m
.6079 .43682 L
s
.59307 .41645 m
.6079 .43682 L
s
.01 w
.47004 .42334 Mdot
.5 Mabswid
.46681 .42176 m
.47004 .42334 L
s
.49055 .40451 m
.47004 .42334 L
s
.4841 .40338 m
.47004 .42334 L
s
.01 w
.36539 .48908 Mdot
.5 Mabswid
.37481 .47997 m
.36539 .48908 L
s
.343 .48882 m
.36539 .48908 L
s
.3502 .48233 m
.36539 .48908 L
s
.35835 .47623 m
.36539 .48908 L
s
.01 w
.37481 .47997 Mdot
.5 Mabswid
.37481 .47997 m
.38559 .46693 L
s
.3502 .48233 m
.37481 .47997 L
s
.35835 .47623 m
.37481 .47997 L
s
.01 w
.61113 .43456 Mdot
.5 Mabswid
.59011 .41831 m
.61113 .43456 L
s
.59307 .41645 m
.61113 .43456 L
s
.61864 .43134 m
.61113 .43456 L
s
.59976 .41421 m
.61113 .43456 L
s
.01 w
.46681 .42176 Mdot
.5 Mabswid
.49055 .40451 m
.46681 .42176 L
s
.4841 .40338 m
.46681 .42176 L
s
.45994 .42018 m
.46681 .42176 L
s
.47996 .39936 m
.46681 .42176 L
s
.01 w
.70612 .5018 Mdot
.5 Mabswid
.70612 .5018 m
.72742 .49962 L
s
.70612 .5018 m
.7186 .49106 L
s
.70612 .5018 m
.70957 .48395 L
s
.70612 .5018 m
.71825 .50766 L
s
.69678 .49274 m
.70612 .5018 L
s
.01 w
.4361 .43394 Mdot
.5 Mabswid
.45421 .41537 m
.4361 .43394 L
s
.45694 .41679 m
.4361 .43394 L
s
.01 w
.59567 .39706 Mdot
.5 Mabswid
.6002 .40394 m
.59567 .39706 L
s
.57901 .38435 m
.59567 .39706 L
s
.58187 .39036 m
.59567 .39706 L
s
.01 w
.32721 .51118 Mdot
.5 Mabswid
.32721 .51118 m
.31804 .4972 L
s
.3294 .50095 m
.32721 .51118 L
s
.01 w
.45994 .42018 Mdot
.5 Mabswid
.45994 .42018 m
.4841 .40338 L
s
.45994 .42018 m
.45694 .41679 L
s
.45994 .42018 m
.47399 .39822 L
s
.47996 .39936 m
.45994 .42018 L
s
.01 w
.71637 .51471 Mdot
.5 Mabswid
.71637 .51471 m
.72968 .50426 L
s
.71637 .51471 m
.72878 .50156 L
s
.71637 .51471 m
.72742 .49962 L
s
.71637 .51471 m
.71735 .51731 L
s
.71825 .50766 m
.71637 .51471 L
s
.01 w
.6002 .40394 Mdot
.5 Mabswid
.60044 .4091 m
.6002 .40394 L
s
.58187 .39036 m
.6002 .40394 L
s
.58242 .39483 m
.6002 .40394 L
s
.01 w
.69678 .49274 Mdot
.5 Mabswid
.69678 .49274 m
.7186 .49106 L
s
.69678 .49274 m
.70957 .48395 L
s
.69678 .49274 m
.69992 .47589 L
s
.68718 .48352 m
.69678 .49274 L
s
.01 w
.73647 .50951 Mdot
.5 Mabswid
.73647 .50951 m
.74006 .49526 L
s
.72742 .49962 m
.73647 .50951 L
s
.01 w
.38559 .46693 Mdot
.5 Mabswid
.35835 .47623 m
.38559 .46693 L
s
.01 w
.65833 .45875 Mdot
.5 Mabswid
.65833 .45875 m
.66542 .45599 L
s
.64068 .44393 m
.65833 .45875 L
s
.67446 .47226 m
.65833 .45875 L
s
.01 w
.71825 .50766 Mdot
.5 Mabswid
.71825 .50766 m
.72878 .50156 L
s
.71825 .50766 m
.72742 .49962 L
s
.71825 .50766 m
.7186 .49106 L
s
.01 w
.61864 .43134 Mdot
.5 Mabswid
.61864 .43134 m
.64068 .44393 L
s
.61864 .43134 m
.62213 .42751 L
s
.61864 .43134 m
.60201 .41063 L
s
.61864 .43134 m
.59307 .41645 L
s
.59976 .41421 m
.61864 .43134 L
s
.01 w
.68718 .48352 Mdot
.5 Mabswid
.68718 .48352 m
.70957 .48395 L
s
.68718 .48352 m
.69992 .47589 L
s
.68718 .48352 m
.68974 .4674 L
s
.67446 .47226 m
.68718 .48352 L
s
.01 w
.71735 .51731 Mdot
.5 Mabswid
.71735 .51731 m
.72968 .50426 L
s
.71735 .51731 m
.72878 .50156 L
s
.01 w
.67446 .47226 Mdot
.5 Mabswid
.67446 .47226 m
.66542 .45599 L
s
.67446 .47226 m
.69992 .47589 L
s
.67446 .47226 m
.68974 .4674 L
s
.01 w
.47833 .38902 Mdot
.5 Mabswid
.47579 .39522 m
.47833 .38902 L
s
.49175 .37751 m
.47833 .38902 L
s
.48907 .38344 m
.47833 .38902 L
s
.01 w
.47579 .39522 Mdot
.5 Mabswid
.47526 .39964 m
.47579 .39522 L
s
.48907 .38344 m
.47579 .39522 L
s
.49298 .38528 m
.47579 .39522 L
s
.01 w
.64068 .44393 Mdot
.5 Mabswid
.64068 .44393 m
.66542 .45599 L
s
.64068 .44393 m
.64813 .44124 L
s
.62475 .42601 m
.64068 .44393 L
s
.62213 .42751 m
.64068 .44393 L
s
.01 w
.60044 .4091 Mdot
.5 Mabswid
.59976 .41421 m
.60044 .4091 L
s
.58242 .39483 m
.60044 .4091 L
s
.57695 .3952 m
.60044 .4091 L
s
.01 w
.59011 .41831 Mdot
.5 Mabswid
.59307 .41645 m
.59011 .41831 L
s
.56722 .40132 m
.59011 .41831 L
s
.57343 .39961 m
.59011 .41831 L
s
.01 w
.45694 .41679 Mdot
.5 Mabswid
.45694 .41679 m
.45421 .41537 L
s
.47104 .39453 m
.45694 .41679 L
s
.47399 .39822 m
.45694 .41679 L
s
.47996 .39936 m
.45694 .41679 L
s
.01 w
.47526 .39964 Mdot
.5 Mabswid
.47996 .39936 m
.47526 .39964 L
s
.49298 .38528 m
.47526 .39964 L
s
.49065 .38814 m
.47526 .39964 L
s
.01 w
.59307 .41645 Mdot
.5 Mabswid
.56722 .40132 m
.59307 .41645 L
s
.57343 .39961 m
.59307 .41645 L
s
.59976 .41421 m
.59307 .41645 L
s
.57695 .3952 m
.59307 .41645 L
s
.01 w
.49055 .40451 Mdot
.5 Mabswid
.49055 .40451 m
.50684 .38713 L
s
.49055 .40451 m
.51315 .39301 L
s
.4841 .40338 m
.49055 .40451 L
s
.50748 .38876 m
.49055 .40451 L
s
.01 w
.45421 .41537 Mdot
.5 Mabswid
.47104 .39453 m
.45421 .41537 L
s
.47399 .39822 m
.45421 .41537 L
s
.01 w
.57901 .38435 Mdot
.5 Mabswid
.58187 .39036 m
.57901 .38435 L
s
.5636 .37435 m
.57901 .38435 L
s
.56667 .37999 m
.57901 .38435 L
s
.01 w
.62213 .42751 Mdot
.5 Mabswid
.62213 .42751 m
.64813 .44124 L
s
.62213 .42751 m
.62475 .42601 L
s
.60445 .40896 m
.62213 .42751 L
s
.60201 .41063 m
.62213 .42751 L
s
.59976 .41421 m
.62213 .42751 L
s
.01 w
.59976 .41421 Mdot
.5 Mabswid
.59976 .41421 m
.60201 .41063 L
s
.59976 .41421 m
.58254 .3936 L
s
.59976 .41421 m
.57343 .39961 L
s
.57695 .3952 m
.59976 .41421 L
s
.01 w
.66542 .45599 Mdot
.5 Mabswid
.66542 .45599 m
.67771 .45511 L
s
.64813 .44124 m
.66542 .45599 L
s
.68974 .4674 m
.66542 .45599 L
s
.01 w
.4841 .40338 Mdot
.5 Mabswid
.4841 .40338 m
.50684 .38713 L
s
.50748 .38876 m
.4841 .40338 L
s
.47996 .39936 m
.4841 .40338 L
s
.49298 .38528 m
.4841 .40338 L
s
.49065 .38814 m
.4841 .40338 L
s
.01 w
.58187 .39036 Mdot
.5 Mabswid
.58242 .39483 m
.58187 .39036 L
s
.56667 .37999 m
.58187 .39036 L
s
.56215 .38231 m
.58187 .39036 L
s
.01 w
.64813 .44124 Mdot
.5 Mabswid
.64813 .44124 m
.67771 .45511 L
s
.62475 .42601 m
.64813 .44124 L
s
.01 w
.62475 .42601 Mdot
.5 Mabswid
.60445 .40896 m
.62475 .42601 L
s
.60201 .41063 m
.62475 .42601 L
s
.01 w
.56722 .40132 Mdot
.5 Mabswid
.56722 .40132 m
.54859 .38535 L
s
.56722 .40132 m
.54334 .39177 L
s
.57343 .39961 m
.56722 .40132 L
s
.54822 .38703 m
.56722 .40132 L
s
.01 w
.58242 .39483 Mdot
.5 Mabswid
.57695 .3952 m
.58242 .39483 L
s
.56215 .38231 m
.58242 .39483 L
s
.56477 .38498 m
.58242 .39483 L
s
.01 w
.35835 .47623 Mdot
.5 Mabswid
.35835 .47623 m
.3502 .48233 L
s
.33633 .47436 m
.35835 .47623 L
s
.33875 .47187 m
.35835 .47623 L
s
.01 w
.3294 .50095 Mdot
.5 Mabswid
.3294 .50095 m
.31804 .4972 L
s
.3294 .50095 m
.32701 .50419 L
s
.33583 .49553 m
.3294 .50095 L
s
.31661 .49092 m
.3294 .50095 L
s
.31927 .48807 m
.3294 .50095 L
s
.32493 .48375 m
.3294 .50095 L
s
.01 w
.47996 .39936 Mdot
.5 Mabswid
.47996 .39936 m
.50684 .38713 L
s
.47996 .39936 m
.48882 .37776 L
s
.47996 .39936 m
.50748 .38876 L
s
.47996 .39936 m
.47399 .39822 L
s
.47996 .39936 m
.4866 .37791 L
s
.49298 .38528 m
.47996 .39936 L
s
.49065 .38814 m
.47996 .39936 L
s
.01 w
.33583 .49553 Mdot
.5 Mabswid
.343 .48882 m
.33583 .49553 L
s
.31927 .48807 m
.33583 .49553 L
s
.32493 .48375 m
.33583 .49553 L
s
.33076 .47901 m
.33583 .49553 L
s
.01 w
.49175 .37751 Mdot
.5 Mabswid
.48907 .38344 m
.49175 .37751 L
s
.50403 .3686 m
.49175 .37751 L
s
.50248 .3747 m
.49175 .37751 L
s
.01 w
.51315 .39301 Mdot
.5 Mabswid
.51315 .39301 m
.50684 .38713 L
s
.51315 .39301 m
.52762 .38431 L
s
.50748 .38876 m
.51315 .39301 L
s
.52791 .38769 m
.51315 .39301 L
s
.52814 .39051 m
.51315 .39301 L
s
.01 w
.48907 .38344 Mdot
.5 Mabswid
.49298 .38528 m
.48907 .38344 L
s
.50248 .3747 m
.48907 .38344 L
s
.50205 .37721 m
.48907 .38344 L
s
.01 w
.343 .48882 Mdot
.5 Mabswid
.3502 .48233 m
.343 .48882 L
s
.32493 .48375 m
.343 .48882 L
s
.33076 .47901 m
.343 .48882 L
s
.33633 .47436 m
.343 .48882 L
s
.01 w
.3502 .48233 Mdot
.5 Mabswid
.33076 .47901 m
.3502 .48233 L
s
.33633 .47436 m
.3502 .48233 L
s
.33875 .47187 m
.3502 .48233 L
s
.01 w
.32701 .50419 Mdot
.5 Mabswid
.32701 .50419 m
.32516 .50603 L
s
.31453 .49276 m
.32701 .50419 L
s
.31661 .49092 m
.32701 .50419 L
s
.31927 .48807 m
.32701 .50419 L
s
.01 w
.72742 .49962 Mdot
.5 Mabswid
.72742 .49962 m
.74006 .49526 L
s
.72742 .49962 m
.73848 .48882 L
s
.72742 .49962 m
.73591 .48558 L
s
.72742 .49962 m
.72899 .48051 L
s
.72742 .49962 m
.72878 .50156 L
s
.7186 .49106 m
.72742 .49962 L
s
.01 w
.60201 .41063 Mdot
.5 Mabswid
.60201 .41063 m
.60445 .40896 L
s
.58481 .3897 m
.60201 .41063 L
s
.58254 .3936 m
.60201 .41063 L
s
.57695 .3952 m
.60201 .41063 L
s
.01 w
.57343 .39961 Mdot
.5 Mabswid
.57343 .39961 m
.54859 .38535 L
s
.54822 .38703 m
.57343 .39961 L
s
.57695 .3952 m
.57343 .39961 L
s
.56215 .38231 m
.57343 .39961 L
s
.56477 .38498 m
.57343 .39961 L
s
.01 w
.52814 .39051 Mdot
.5 Mabswid
.52814 .39051 m
.52762 .38431 L
s
.52814 .39051 m
.50748 .38876 L
s
.52814 .39051 m
.54334 .39177 L
s
.52814 .39051 m
.52791 .38769 L
s
.52814 .39051 m
.54822 .38703 L
s
.01 w
.52806 .38772 Mdot
.5 Mabswid
.52806 .38772 m
.50983 .38725 L
s
.52806 .38772 m
.50748 .38876 L
s
.54605 .38574 m
.52806 .38772 L
s
.52791 .38769 m
.52806 .38772 L
s
.54822 .38703 m
.52806 .38772 L
s
.01 w
.32516 .50603 Mdot
.5 Mabswid
.31453 .49276 m
.32516 .50603 L
s
.31661 .49092 m
.32516 .50603 L
s
.01 w
.54334 .39177 Mdot
.5 Mabswid
.54334 .39177 m
.52762 .38431 L
s
.54334 .39177 m
.54859 .38535 L
s
.52791 .38769 m
.54334 .39177 L
s
.54822 .38703 m
.54334 .39177 L
s
.01 w
.50983 .38725 Mdot
.5 Mabswid
.50748 .38876 m
.50983 .38725 L
s
.49505 .38277 m
.50983 .38725 L
s
.52791 .38769 m
.50983 .38725 L
s
.49065 .38814 m
.50983 .38725 L
s
.01 w
.47399 .39822 Mdot
.5 Mabswid
.47399 .39822 m
.48882 .37776 L
s
.47399 .39822 m
.47104 .39453 L
s
.4866 .37791 m
.47399 .39822 L
s
.49298 .38528 m
.47399 .39822 L
s
.49065 .38814 m
.47399 .39822 L
s
.01 w
.68974 .4674 Mdot
.5 Mabswid
.68974 .4674 m
.67771 .45511 L
s
.68974 .4674 m
.71341 .46817 L
s
.68974 .4674 m
.70483 .46257 L
s
.68974 .4674 m
.69992 .47589 L
s
.01 w
.5636 .37435 Mdot
.5 Mabswid
.56667 .37999 m
.5636 .37435 L
s
.54957 .36655 m
.5636 .37435 L
s
.55138 .3726 m
.5636 .37435 L
s
.01 w
.60445 .40896 Mdot
.5 Mabswid
.58481 .3897 m
.60445 .40896 L
s
.58254 .3936 m
.60445 .40896 L
s
.01 w
.69992 .47589 Mdot
.5 Mabswid
.69992 .47589 m
.72117 .47425 L
s
.69992 .47589 m
.71341 .46817 L
s
.69992 .47589 m
.70483 .46257 L
s
.69992 .47589 m
.70957 .48395 L
s
.01 w
.70957 .48395 Mdot
.5 Mabswid
.70957 .48395 m
.72899 .48051 L
s
.70957 .48395 m
.72117 .47425 L
s
.70957 .48395 m
.71341 .46817 L
s
.70957 .48395 m
.7186 .49106 L
s
.01 w
.7186 .49106 Mdot
.5 Mabswid
.7186 .49106 m
.73591 .48558 L
s
.7186 .49106 m
.72899 .48051 L
s
.7186 .49106 m
.72117 .47425 L
s
.01 w
.52791 .38769 Mdot
.5 Mabswid
.52791 .38769 m
.50684 .38713 L
s
.52791 .38769 m
.52762 .38431 L
s
.52791 .38769 m
.54859 .38535 L
s
.52791 .38769 m
.52729 .3803 L
s
.52791 .38769 m
.50748 .38876 L
s
.52791 .38769 m
.54605 .38574 L
s
.54822 .38703 m
.52791 .38769 L
s
.52741 .38196 m
.52791 .38769 L
s
.01 w
.54605 .38574 Mdot
.5 Mabswid
.55977 .38009 m
.54605 .38574 L
s
.54822 .38703 m
.54605 .38574 L
s
.56477 .38498 m
.54605 .38574 L
s
.01 w
.50748 .38876 Mdot
.5 Mabswid
.50748 .38876 m
.50684 .38713 L
s
.50748 .38876 m
.51433 .3774 L
s
.50748 .38876 m
.52762 .38431 L
s
.50748 .38876 m
.52729 .3803 L
s
.51507 .37828 m
.50748 .38876 L
s
.49505 .38277 m
.50748 .38876 L
s
.52741 .38196 m
.50748 .38876 L
s
.49298 .38528 m
.50748 .38876 L
s
.49065 .38814 m
.50748 .38876 L
s
.50205 .37721 m
.50748 .38876 L
s
.50165 .37865 m
.50748 .38876 L
s
.01 w
.56667 .37999 Mdot
.5 Mabswid
.56215 .38231 m
.56667 .37999 L
s
.55138 .3726 m
.56667 .37999 L
s
.55187 .37509 m
.56667 .37999 L
s
.01 w
.67771 .45511 Mdot
.5 Mabswid
.70483 .46257 m
.67771 .45511 L
s
.01 w
.57695 .3952 Mdot
.5 Mabswid
.57695 .3952 m
.56471 .37455 L
s
.57695 .3952 m
.54859 .38535 L
s
.57695 .3952 m
.58254 .3936 L
s
.57695 .3952 m
.56689 .37452 L
s
.57695 .3952 m
.54822 .38703 L
s
.56215 .38231 m
.57695 .3952 L
s
.56477 .38498 m
.57695 .3952 L
s
.01 w
.72878 .50156 Mdot
.5 Mabswid
.72878 .50156 m
.74033 .49067 L
s
.72878 .50156 m
.73848 .48882 L
s
.72878 .50156 m
.73591 .48558 L
s
.72878 .50156 m
.72968 .50426 L
s
.01 w
.50684 .38713 Mdot
.5 Mabswid
.51483 .37529 m
.50684 .38713 L
s
.51433 .3774 m
.50684 .38713 L
s
.52762 .38431 m
.50684 .38713 L
s
.52713 .37756 m
.50684 .38713 L
s
.52729 .3803 m
.50684 .38713 L
s
.51507 .37828 m
.50684 .38713 L
s
.52741 .38196 m
.50684 .38713 L
s
.49298 .38528 m
.50684 .38713 L
s
.49065 .38814 m
.50684 .38713 L
s
.50248 .3747 m
.50684 .38713 L
s
.50205 .37721 m
.50684 .38713 L
s
.50165 .37865 m
.50684 .38713 L
s
.01 w
.72968 .50426 Mdot
.5 Mabswid
.72968 .50426 m
.74033 .49067 L
s
.72968 .50426 m
.73848 .48882 L
s
.01 w
.49065 .38814 Mdot
.5 Mabswid
.49065 .38814 m
.48882 .37776 L
s
.49065 .38814 m
.4852 .37445 L
s
.49065 .38814 m
.49505 .38277 L
s
.49065 .38814 m
.4866 .37791 L
s
.49065 .38814 m
.49298 .38528 L
s
.50205 .37721 m
.49065 .38814 L
s
.50165 .37865 m
.49065 .38814 L
s
.01 w
.54822 .38703 Mdot
.5 Mabswid
.54822 .38703 m
.52762 .38431 L
s
.54822 .38703 m
.54859 .38535 L
s
.54822 .38703 m
.52729 .3803 L
s
.54822 .38703 m
.53973 .37632 L
s
.54822 .38703 m
.55977 .38009 L
s
.52741 .38196 m
.54822 .38703 L
s
.53902 .37726 m
.54822 .38703 L
s
.56215 .38231 m
.54822 .38703 L
s
.56477 .38498 m
.54822 .38703 L
s
.55187 .37509 m
.54822 .38703 L
s
.55232 .37651 m
.54822 .38703 L
s
.01 w
.52762 .38431 Mdot
.5 Mabswid
.52762 .38431 m
.51483 .37529 L
s
.52762 .38431 m
.51433 .3774 L
s
.54859 .38535 m
.52762 .38431 L
s
.52713 .37756 m
.52762 .38431 L
s
.52729 .3803 m
.52762 .38431 L
s
.539 .37427 m
.52762 .38431 L
s
.53973 .37632 m
.52762 .38431 L
s
.52741 .38196 m
.52762 .38431 L
s
.01 w
.49298 .38528 Mdot
.5 Mabswid
.49298 .38528 m
.51483 .37529 L
s
.49298 .38528 m
.51433 .3774 L
s
.49298 .38528 m
.48882 .37776 L
s
.49298 .38528 m
.50137 .36825 L
s
.49298 .38528 m
.49957 .36968 L
s
.49298 .38528 m
.4866 .37791 L
s
.50248 .3747 m
.49298 .38528 L
s
.50205 .37721 m
.49298 .38528 L
s
.50165 .37865 m
.49298 .38528 L
s
.01 w
.47104 .39453 Mdot
.5 Mabswid
.47104 .39453 m
.48882 .37776 L
s
.47104 .39453 m
.47929 .37543 L
s
.4866 .37791 m
.47104 .39453 L
s
.01 w
.54859 .38535 Mdot
.5 Mabswid
.52713 .37756 m
.54859 .38535 L
s
.52729 .3803 m
.54859 .38535 L
s
.539 .37427 m
.54859 .38535 L
s
.53973 .37632 m
.54859 .38535 L
s
.52741 .38196 m
.54859 .38535 L
s
.53902 .37726 m
.54859 .38535 L
s
.56215 .38231 m
.54859 .38535 L
s
.56477 .38498 m
.54859 .38535 L
s
.55138 .3726 m
.54859 .38535 L
s
.55187 .37509 m
.54859 .38535 L
s
.55232 .37651 m
.54859 .38535 L
s
.01 w
.49505 .38277 Mdot
.5 Mabswid
.49505 .38277 m
.4852 .37445 L
s
.4866 .37791 m
.49505 .38277 L
s
.01 w
.31804 .4972 Mdot
.5 Mabswid
.31804 .4972 m
.30942 .48265 L
s
.31927 .48807 m
.31804 .4972 L
s
.01 w
.58254 .3936 Mdot
.5 Mabswid
.58254 .3936 m
.56471 .37455 L
s
.58254 .3936 m
.58481 .3897 L
s
.56689 .37452 m
.58254 .3936 L
s
.56215 .38231 m
.58254 .3936 L
s
.56477 .38498 m
.58254 .3936 L
s
.01 w
.52741 .38196 Mdot
.5 Mabswid
.52741 .38196 m
.51433 .3774 L
s
.52741 .38196 m
.52729 .3803 L
s
.52741 .38196 m
.53973 .37632 L
s
.52741 .38196 m
.52651 .37075 L
s
.52741 .38196 m
.51507 .37828 L
s
.53902 .37726 m
.52741 .38196 L
s
.52657 .37201 m
.52741 .38196 L
s
.01 w
.74006 .49526 Mdot
.5 Mabswid
.74006 .49526 m
.74637 .48109 L
s
.73591 .48558 m
.74006 .49526 L
s
.01 w
.50403 .3686 Mdot
.5 Mabswid
.50248 .3747 m
.50403 .3686 L
s
.515 .36406 m
.50403 .3686 L
s
.51375 .36651 m
.50403 .3686 L
s
.01 w
.56477 .38498 Mdot
.5 Mabswid
.56477 .38498 m
.56471 .37455 L
s
.56477 .38498 m
.56802 .37097 L
s
.56477 .38498 m
.56689 .37452 L
s
.56477 .38498 m
.55977 .38009 L
s
.56477 .38498 m
.56215 .38231 L
s
.55187 .37509 m
.56477 .38498 L
s
.55232 .37651 m
.56477 .38498 L
s
.01 w
.52729 .3803 Mdot
.5 Mabswid
.52729 .3803 m
.51483 .37529 L
s
.52729 .3803 m
.51433 .3774 L
s
.52729 .3803 m
.52713 .37756 L
s
.539 .37427 m
.52729 .3803 L
s
.53973 .37632 m
.52729 .3803 L
s
.5264 .36856 m
.52729 .3803 L
s
.52651 .37075 m
.52729 .3803 L
s
.51507 .37828 m
.52729 .3803 L
s
.53902 .37726 m
.52729 .3803 L
s
.52657 .37201 m
.52729 .3803 L
s
.01 w
.56215 .38231 Mdot
.5 Mabswid
.56215 .38231 m
.56471 .37455 L
s
.56215 .38231 m
.55103 .36614 L
s
.56215 .38231 m
.55293 .36741 L
s
.56215 .38231 m
.539 .37427 L
s
.56215 .38231 m
.53973 .37632 L
s
.56215 .38231 m
.56689 .37452 L
s
.55138 .3726 m
.56215 .38231 L
s
.55187 .37509 m
.56215 .38231 L
s
.55232 .37651 m
.56215 .38231 L
s
.01 w
.55977 .38009 Mdot
.5 Mabswid
.55977 .38009 m
.56802 .37097 L
s
.55977 .38009 m
.56689 .37452 L
s
.01 w
.52713 .37756 Mdot
.5 Mabswid
.52713 .37756 m
.51483 .37529 L
s
.52713 .37756 m
.51433 .3774 L
s
.539 .37427 m
.52713 .37756 L
s
.53973 .37632 m
.52713 .37756 L
s
.52626 .36563 m
.52713 .37756 L
s
.5264 .36856 m
.52713 .37756 L
s
.52651 .37075 m
.52713 .37756 L
s
.01 w
.50248 .3747 Mdot
.5 Mabswid
.50248 .3747 m
.51483 .37529 L
s
.50248 .3747 m
.51433 .3774 L
s
.50248 .3747 m
.48882 .37776 L
s
.50248 .3747 m
.50137 .36825 L
s
.50248 .3747 m
.49957 .36968 L
s
.50205 .37721 m
.50248 .3747 L
s
.515 .36406 m
.50248 .3747 L
s
.51375 .36651 m
.50248 .3747 L
s
.51302 .36853 m
.50248 .3747 L
s
.01 w
.54957 .36655 Mdot
.5 Mabswid
.55138 .3726 m
.54957 .36655 L
s
.53724 .36312 m
.54957 .36655 L
s
.53865 .36544 m
.54957 .36655 L
s
.01 w
.51433 .3774 Mdot
.5 Mabswid
.51433 .3774 m
.51483 .37529 L
s
.5264 .36856 m
.51433 .3774 L
s
.52651 .37075 m
.51433 .3774 L
s
.51507 .37828 m
.51433 .3774 L
s
.52657 .37201 m
.51433 .3774 L
s
.50205 .37721 m
.51433 .3774 L
s
.50165 .37865 m
.51433 .3774 L
s
.51375 .36651 m
.51433 .3774 L
s
.51302 .36853 m
.51433 .3774 L
s
.51266 .36968 m
.51433 .3774 L
s
.01 w
.51507 .37828 Mdot
.5 Mabswid
.51507 .37828 m
.52651 .37075 L
s
.52657 .37201 m
.51507 .37828 L
s
.50205 .37721 m
.51507 .37828 L
s
.50165 .37865 m
.51507 .37828 L
s
.51302 .36853 m
.51507 .37828 L
s
.51266 .36968 m
.51507 .37828 L
s
.01 w
.51483 .37529 Mdot
.5 Mabswid
.52626 .36563 m
.51483 .37529 L
s
.5264 .36856 m
.51483 .37529 L
s
.52651 .37075 m
.51483 .37529 L
s
.50205 .37721 m
.51483 .37529 L
s
.515 .36406 m
.51483 .37529 L
s
.51375 .36651 m
.51483 .37529 L
s
.51302 .36853 m
.51483 .37529 L
s
.01 w
.50205 .37721 Mdot
.5 Mabswid
.50205 .37721 m
.48882 .37776 L
s
.50205 .37721 m
.50137 .36825 L
s
.50205 .37721 m
.49957 .36968 L
s
.50205 .37721 m
.4866 .37791 L
s
.50205 .37721 m
.49926 .37002 L
s
.50165 .37865 m
.50205 .37721 L
s
.51375 .36651 m
.50205 .37721 L
s
.51302 .36853 m
.50205 .37721 L
s
.51266 .36968 m
.50205 .37721 L
s
.01 w
.58481 .3897 Mdot
.5 Mabswid
.58481 .3897 m
.56471 .37455 L
s
.58481 .3897 m
.57366 .3715 L
s
.56689 .37452 m
.58481 .3897 L
s
.01 w
.50165 .37865 Mdot
.5 Mabswid
.50165 .37865 m
.48882 .37776 L
s
.50165 .37865 m
.49957 .36968 L
s
.50165 .37865 m
.4866 .37791 L
s
.50165 .37865 m
.49926 .37002 L
s
.51302 .36853 m
.50165 .37865 L
s
.51266 .36968 m
.50165 .37865 L
s
.01 w
.53973 .37632 Mdot
.5 Mabswid
.53973 .37632 m
.539 .37427 L
s
.5264 .36856 m
.53973 .37632 L
s
.52651 .37075 m
.53973 .37632 L
s
.53902 .37726 m
.53973 .37632 L
s
.52657 .37201 m
.53973 .37632 L
s
.55138 .3726 m
.53973 .37632 L
s
.55187 .37509 m
.53973 .37632 L
s
.55232 .37651 m
.53973 .37632 L
s
.53865 .36544 m
.53973 .37632 L
s
.53948 .3674 m
.53973 .37632 L
s
.53991 .36851 m
.53973 .37632 L
s
.01 w
.53902 .37726 Mdot
.5 Mabswid
.53902 .37726 m
.52651 .37075 L
s
.52657 .37201 m
.53902 .37726 L
s
.55187 .37509 m
.53902 .37726 L
s
.55232 .37651 m
.53902 .37726 L
s
.53948 .3674 m
.53902 .37726 L
s
.53991 .36851 m
.53902 .37726 L
s
.01 w
.539 .37427 Mdot
.5 Mabswid
.52626 .36563 m
.539 .37427 L
s
.5264 .36856 m
.539 .37427 L
s
.52651 .37075 m
.539 .37427 L
s
.55138 .3726 m
.539 .37427 L
s
.55187 .37509 m
.539 .37427 L
s
.53724 .36312 m
.539 .37427 L
s
.53865 .36544 m
.539 .37427 L
s
.53948 .3674 m
.539 .37427 L
s
.01 w
.55138 .3726 Mdot
.5 Mabswid
.55138 .3726 m
.56471 .37455 L
s
.55138 .3726 m
.55103 .36614 L
s
.55138 .3726 m
.55293 .36741 L
s
.55187 .37509 m
.55138 .3726 L
s
.53724 .36312 m
.55138 .3726 L
s
.53865 .36544 m
.55138 .3726 L
s
.53948 .3674 m
.55138 .3726 L
s
.01 w
.55187 .37509 Mdot
.5 Mabswid
.55187 .37509 m
.56471 .37455 L
s
.55187 .37509 m
.55103 .36614 L
s
.55187 .37509 m
.55293 .36741 L
s
.55187 .37509 m
.56689 .37452 L
s
.55187 .37509 m
.55312 .36776 L
s
.55232 .37651 m
.55187 .37509 L
s
.53865 .36544 m
.55187 .37509 L
s
.53948 .3674 m
.55187 .37509 L
s
.53991 .36851 m
.55187 .37509 L
s
.01 w
.55232 .37651 Mdot
.5 Mabswid
.55232 .37651 m
.56471 .37455 L
s
.55232 .37651 m
.55293 .36741 L
s
.55232 .37651 m
.56689 .37452 L
s
.55232 .37651 m
.55312 .36776 L
s
.53948 .3674 m
.55232 .37651 L
s
.53991 .36851 m
.55232 .37651 L
s
.01 w
.33875 .47187 Mdot
.5 Mabswid
.33875 .47187 m
.33633 .47436 L
s
.32439 .46457 m
.33875 .47187 L
s
.32577 .46313 m
.33875 .47187 L
s
.01 w
.33633 .47436 Mdot
.5 Mabswid
.33633 .47436 m
.33076 .47901 L
s
.3207 .46773 m
.33633 .47436 L
s
.32439 .46457 m
.33633 .47436 L
s
.32577 .46313 m
.33633 .47436 L
s
.01 w
.48882 .37776 Mdot
.5 Mabswid
.50137 .36825 m
.48882 .37776 L
s
.49957 .36968 m
.48882 .37776 L
s
.48859 .36386 m
.48882 .37776 L
s
.49689 .36167 m
.48882 .37776 L
s
.49424 .36296 m
.48882 .37776 L
s
.47929 .37543 m
.48882 .37776 L
s
.4866 .37791 m
.48882 .37776 L
s
.49926 .37002 m
.48882 .37776 L
s
.48397 .36472 m
.48882 .37776 L
s
.49236 .36353 m
.48882 .37776 L
s
.01 w
.33076 .47901 Mdot
.5 Mabswid
.33076 .47901 m
.32493 .48375 L
s
.31576 .47128 m
.33076 .47901 L
s
.3207 .46773 m
.33076 .47901 L
s
.32439 .46457 m
.33076 .47901 L
s
.01 w
.4866 .37791 Mdot
.5 Mabswid
.4866 .37791 m
.49957 .36968 L
s
.4866 .37791 m
.48859 .36386 L
s
.4866 .37791 m
.49424 .36296 L
s
.4866 .37791 m
.47929 .37543 L
s
.4866 .37791 m
.4852 .37445 L
s
.49926 .37002 m
.4866 .37791 L
s
.48181 .36357 m
.4866 .37791 L
s
.48397 .36472 m
.4866 .37791 L
s
.49236 .36353 m
.4866 .37791 L
s
.48007 .36542 m
.4866 .37791 L
s
.01 w
.4852 .37445 Mdot
.5 Mabswid
.48181 .36357 m
.4852 .37445 L
s
.48397 .36472 m
.4852 .37445 L
s
.01 w
.32493 .48375 Mdot
.5 Mabswid
.32493 .48375 m
.31927 .48807 L
s
.31068 .47453 m
.32493 .48375 L
s
.31576 .47128 m
.32493 .48375 L
s
.3207 .46773 m
.32493 .48375 L
s
.01 w
.70483 .46257 Mdot
.5 Mabswid
.70483 .46257 m
.72543 .45938 L
s
.70483 .46257 m
.72283 .45702 L
s
.70483 .46257 m
.71341 .46817 L
s
.01 w
.31927 .48807 Mdot
.5 Mabswid
.31927 .48807 m
.30942 .48265 L
s
.31927 .48807 m
.31661 .49092 L
s
.30801 .47726 m
.31927 .48807 L
s
.31068 .47453 m
.31927 .48807 L
s
.31576 .47128 m
.31927 .48807 L
s
.01 w
.52657 .37201 Mdot
.5 Mabswid
.52657 .37201 m
.52651 .37075 L
s
.51302 .36853 m
.52657 .37201 L
s
.51266 .36968 m
.52657 .37201 L
s
.53948 .3674 m
.52657 .37201 L
s
.53991 .36851 m
.52657 .37201 L
s
.52551 .35978 m
.52657 .37201 L
s
.52551 .36061 m
.52657 .37201 L
s
.01 w
.52651 .37075 Mdot
.5 Mabswid
.52651 .37075 m
.5264 .36856 L
s
.51375 .36651 m
.52651 .37075 L
s
.51302 .36853 m
.52651 .37075 L
s
.51266 .36968 m
.52651 .37075 L
s
.53865 .36544 m
.52651 .37075 L
s
.53948 .3674 m
.52651 .37075 L
s
.53991 .36851 m
.52651 .37075 L
s
.5255 .3585 m
.52651 .37075 L
s
.52551 .35978 m
.52651 .37075 L
s
.52551 .36061 m
.52651 .37075 L
s
.01 w
.31661 .49092 Mdot
.5 Mabswid
.31661 .49092 m
.31453 .49276 L
s
.30577 .47906 m
.31661 .49092 L
s
.30801 .47726 m
.31661 .49092 L
s
.31068 .47453 m
.31661 .49092 L
s
.01 w
.5264 .36856 Mdot
.5 Mabswid
.5264 .36856 m
.52626 .36563 L
s
.515 .36406 m
.5264 .36856 L
s
.51375 .36651 m
.5264 .36856 L
s
.51302 .36853 m
.5264 .36856 L
s
.53724 .36312 m
.5264 .36856 L
s
.53865 .36544 m
.5264 .36856 L
s
.53948 .3674 m
.5264 .36856 L
s
.52549 .35734 m
.5264 .36856 L
s
.5255 .3585 m
.5264 .36856 L
s
.52551 .35978 m
.5264 .36856 L
s
.01 w
.31453 .49276 Mdot
.5 Mabswid
.30577 .47906 m
.31453 .49276 L
s
.30801 .47726 m
.31453 .49276 L
s
.01 w
.71341 .46817 Mdot
.5 Mabswid
.71341 .46817 m
.73139 .46378 L
s
.71341 .46817 m
.72543 .45938 L
s
.71341 .46817 m
.72283 .45702 L
s
.71341 .46817 m
.72117 .47425 L
s
.01 w
.52626 .36563 Mdot
.5 Mabswid
.52548 .35552 m
.52626 .36563 L
s
.515 .36406 m
.52626 .36563 L
s
.51375 .36651 m
.52626 .36563 L
s
.53724 .36312 m
.52626 .36563 L
s
.53865 .36544 m
.52626 .36563 L
s
.52549 .35734 m
.52626 .36563 L
s
.5255 .3585 m
.52626 .36563 L
s
.01 w
.72117 .47425 Mdot
.5 Mabswid
.72117 .47425 m
.73759 .46825 L
s
.72117 .47425 m
.73139 .46378 L
s
.72117 .47425 m
.72543 .45938 L
s
.72117 .47425 m
.72899 .48051 L
s
.01 w
.72899 .48051 Mdot
.5 Mabswid
.72899 .48051 m
.74357 .47232 L
s
.72899 .48051 m
.73759 .46825 L
s
.72899 .48051 m
.73139 .46378 L
s
.72899 .48051 m
.73591 .48558 L
s
.01 w
.56471 .37455 Mdot
.5 Mabswid
.56471 .37455 m
.56253 .36079 L
s
.55414 .35931 m
.56471 .37455 L
s
.55684 .36034 m
.56471 .37455 L
s
.55103 .36614 m
.56471 .37455 L
s
.55293 .36741 m
.56471 .37455 L
s
.57366 .3715 m
.56471 .37455 L
s
.56719 .36126 m
.56471 .37455 L
s
.56689 .37452 m
.56471 .37455 L
s
.55874 .36079 m
.56471 .37455 L
s
.55312 .36776 m
.56471 .37455 L
s
.01 w
.515 .36406 Mdot
.5 Mabswid
.515 .36406 m
.50137 .36825 L
s
.515 .36406 m
.51179 .35798 L
s
.515 .36406 m
.50939 .35959 L
s
.515 .36406 m
.52548 .35552 L
s
.51375 .36651 m
.515 .36406 L
s
.52549 .35734 m
.515 .36406 L
s
.5255 .3585 m
.515 .36406 L
s
.01 w
.51375 .36651 Mdot
.5 Mabswid
.51375 .36651 m
.50137 .36825 L
s
.51375 .36651 m
.49957 .36968 L
s
.51375 .36651 m
.51179 .35798 L
s
.51375 .36651 m
.50939 .35959 L
s
.51375 .36651 m
.50761 .3608 L
s
.51302 .36853 m
.51375 .36651 L
s
.52549 .35734 m
.51375 .36651 L
s
.5255 .3585 m
.51375 .36651 L
s
.52551 .35978 m
.51375 .36651 L
s
.01 w
.73591 .48558 Mdot
.5 Mabswid
.73591 .48558 m
.74637 .48109 L
s
.73591 .48558 m
.74641 .47507 L
s
.73591 .48558 m
.74357 .47232 L
s
.73591 .48558 m
.73759 .46825 L
s
.73591 .48558 m
.73848 .48882 L
s
.01 w
.47929 .37543 Mdot
.5 Mabswid
.47929 .37543 m
.48859 .36386 L
s
.48397 .36472 m
.47929 .37543 L
s
.48007 .36542 m
.47929 .37543 L
s
.01 w
.51302 .36853 Mdot
.5 Mabswid
.51302 .36853 m
.50137 .36825 L
s
.51302 .36853 m
.49957 .36968 L
s
.51302 .36853 m
.50939 .35959 L
s
.51302 .36853 m
.50761 .3608 L
s
.51302 .36853 m
.49926 .37002 L
s
.51302 .36853 m
.5068 .36161 L
s
.51266 .36968 m
.51302 .36853 L
s
.5255 .3585 m
.51302 .36853 L
s
.52551 .35978 m
.51302 .36853 L
s
.52551 .36061 m
.51302 .36853 L
s
.01 w
.56689 .37452 Mdot
.5 Mabswid
.56689 .37452 m
.56253 .36079 L
s
.56689 .37452 m
.55684 .36034 L
s
.56689 .37452 m
.55293 .36741 L
s
.56689 .37452 m
.57366 .3715 L
s
.56689 .37452 m
.56937 .3599 L
s
.56689 .37452 m
.56802 .37097 L
s
.56689 .37452 m
.56719 .36126 L
s
.55874 .36079 m
.56689 .37452 L
s
.55312 .36776 m
.56689 .37452 L
s
.57113 .36165 m
.56689 .37452 L
s
.01 w
.50137 .36825 Mdot
.5 Mabswid
.49957 .36968 m
.50137 .36825 L
s
.48859 .36386 m
.50137 .36825 L
s
.49689 .36167 m
.50137 .36825 L
s
.49424 .36296 m
.50137 .36825 L
s
.51179 .35798 m
.50137 .36825 L
s
.50939 .35959 m
.50137 .36825 L
s
.50761 .3608 m
.50137 .36825 L
s
.01 w
.56802 .37097 Mdot
.5 Mabswid
.56802 .37097 m
.56937 .3599 L
s
.56719 .36126 m
.56802 .37097 L
s
.01 w
.51266 .36968 Mdot
.5 Mabswid
.51266 .36968 m
.49957 .36968 L
s
.51266 .36968 m
.50761 .3608 L
s
.51266 .36968 m
.49926 .37002 L
s
.51266 .36968 m
.5068 .36161 L
s
.52551 .35978 m
.51266 .36968 L
s
.52551 .36061 m
.51266 .36968 L
s
.01 w
.49957 .36968 Mdot
.5 Mabswid
.48859 .36386 m
.49957 .36968 L
s
.49689 .36167 m
.49957 .36968 L
s
.49424 .36296 m
.49957 .36968 L
s
.50939 .35959 m
.49957 .36968 L
s
.50761 .3608 m
.49957 .36968 L
s
.49926 .37002 m
.49957 .36968 L
s
.49236 .36353 m
.49957 .36968 L
s
.5068 .36161 m
.49957 .36968 L
s
.01 w
.53724 .36312 Mdot
.5 Mabswid
.53724 .36312 m
.55103 .36614 L
s
.53724 .36312 m
.53919 .35687 L
s
.53724 .36312 m
.54161 .35825 L
s
.53724 .36312 m
.52548 .35552 L
s
.53865 .36544 m
.53724 .36312 L
s
.52549 .35734 m
.53724 .36312 L
s
.5255 .3585 m
.53724 .36312 L
s
.01 w
.53865 .36544 Mdot
.5 Mabswid
.53865 .36544 m
.55103 .36614 L
s
.53865 .36544 m
.55293 .36741 L
s
.53865 .36544 m
.53919 .35687 L
s
.53865 .36544 m
.54161 .35825 L
s
.53865 .36544 m
.54342 .3593 L
s
.53948 .3674 m
.53865 .36544 L
s
.52549 .35734 m
.53865 .36544 L
s
.5255 .3585 m
.53865 .36544 L
s
.52551 .35978 m
.53865 .36544 L
s
.01 w
.73848 .48882 Mdot
.5 Mabswid
.73848 .48882 m
.74865 .47685 L
s
.73848 .48882 m
.74641 .47507 L
s
.73848 .48882 m
.74357 .47232 L
s
.73848 .48882 m
.74033 .49067 L
s
.01 w
.53948 .3674 Mdot
.5 Mabswid
.53948 .3674 m
.55103 .36614 L
s
.53948 .3674 m
.55293 .36741 L
s
.53948 .3674 m
.54161 .35825 L
s
.53948 .3674 m
.54342 .3593 L
s
.53948 .3674 m
.55312 .36776 L
s
.53948 .3674 m
.5442 .36005 L
s
.53991 .36851 m
.53948 .3674 L
s
.5255 .3585 m
.53948 .3674 L
s
.52551 .35978 m
.53948 .3674 L
s
.52551 .36061 m
.53948 .3674 L
s
.01 w
.49926 .37002 Mdot
.5 Mabswid
.49926 .37002 m
.49424 .36296 L
s
.49926 .37002 m
.50761 .3608 L
s
.49236 .36353 m
.49926 .37002 L
s
.5068 .36161 m
.49926 .37002 L
s
.01 w
.53991 .36851 Mdot
.5 Mabswid
.53991 .36851 m
.55293 .36741 L
s
.53991 .36851 m
.54342 .3593 L
s
.53991 .36851 m
.55312 .36776 L
s
.53991 .36851 m
.5442 .36005 L
s
.52551 .35978 m
.53991 .36851 L
s
.52551 .36061 m
.53991 .36851 L
s
.01 w
.74033 .49067 Mdot
.5 Mabswid
.74033 .49067 m
.74865 .47685 L
s
.74033 .49067 m
.74641 .47507 L
s
.01 w
.55103 .36614 Mdot
.5 Mabswid
.55103 .36614 m
.56253 .36079 L
s
.55103 .36614 m
.55414 .35931 L
s
.55103 .36614 m
.55684 .36034 L
s
.55293 .36741 m
.55103 .36614 L
s
.53919 .35687 m
.55103 .36614 L
s
.54161 .35825 m
.55103 .36614 L
s
.54342 .3593 m
.55103 .36614 L
s
.01 w
.55293 .36741 Mdot
.5 Mabswid
.55293 .36741 m
.56253 .36079 L
s
.55293 .36741 m
.55414 .35931 L
s
.55293 .36741 m
.55684 .36034 L
s
.54161 .35825 m
.55293 .36741 L
s
.54342 .3593 m
.55293 .36741 L
s
.55874 .36079 m
.55293 .36741 L
s
.55312 .36776 m
.55293 .36741 L
s
.5442 .36005 m
.55293 .36741 L
s
.01 w
.55312 .36776 Mdot
.5 Mabswid
.55312 .36776 m
.55684 .36034 L
s
.55312 .36776 m
.54342 .3593 L
s
.55312 .36776 m
.55874 .36079 L
s
.5442 .36005 m
.55312 .36776 L
s
.01 w
.57366 .3715 Mdot
.5 Mabswid
.57366 .3715 m
.56253 .36079 L
s
.56719 .36126 m
.57366 .3715 L
s
.57113 .36165 m
.57366 .3715 L
s
.01 w
.30942 .48265 Mdot
.5 Mabswid
.30942 .48265 m
.30241 .46651 L
s
.31068 .47453 m
.30942 .48265 L
s
.01 w
.52548 .35552 Mdot
.5 Mabswid
.52548 .35552 m
.51179 .35798 L
s
.52548 .35552 m
.52473 .34913 L
s
.52548 .35552 m
.53919 .35687 L
s
.51366 .35059 m
.52548 .35552 L
s
.53609 .34966 m
.52548 .35552 L
s
.52549 .35734 m
.52548 .35552 L
s
.01 w
.51179 .35798 Mdot
.5 Mabswid
.51179 .35798 m
.49689 .36167 L
s
.51179 .35798 m
.49984 .35355 L
s
.50939 .35959 m
.51179 .35798 L
s
.51366 .35059 m
.51179 .35798 L
s
.51227 .35145 m
.51179 .35798 L
s
.52549 .35734 m
.51179 .35798 L
s
.5255 .3585 m
.51179 .35798 L
s
.01 w
.52549 .35734 Mdot
.5 Mabswid
.52549 .35734 m
.50939 .35959 L
s
.52549 .35734 m
.52473 .34913 L
s
.52549 .35734 m
.52462 .34916 L
s
.52549 .35734 m
.53919 .35687 L
s
.52549 .35734 m
.54161 .35825 L
s
.52549 .35734 m
.51366 .35059 L
s
.52549 .35734 m
.51227 .35145 L
s
.52549 .35734 m
.53609 .34966 L
s
.52549 .35734 m
.53736 .35043 L
s
.5255 .3585 m
.52549 .35734 L
s
.01 w
.50939 .35959 Mdot
.5 Mabswid
.50939 .35959 m
.49689 .36167 L
s
.50939 .35959 m
.49424 .36296 L
s
.50939 .35959 m
.49984 .35355 L
s
.50939 .35959 m
.49794 .35427 L
s
.50761 .3608 m
.50939 .35959 L
s
.51366 .35059 m
.50939 .35959 L
s
.51227 .35145 m
.50939 .35959 L
s
.51144 .35253 m
.50939 .35959 L
s
.5255 .3585 m
.50939 .35959 L
s
.52551 .35978 m
.50939 .35959 L
s
.01 w
.74637 .48109 Mdot
.5 Mabswid
.74637 .48109 m
.75228 .46635 L
s
.74357 .47232 m
.74637 .48109 L
s
.01 w
.53919 .35687 Mdot
.5 Mabswid
.53919 .35687 m
.54989 .35155 L
s
.53919 .35687 m
.55414 .35931 L
s
.54161 .35825 m
.53919 .35687 L
s
.53609 .34966 m
.53919 .35687 L
s
.53736 .35043 m
.53919 .35687 L
s
.5255 .3585 m
.53919 .35687 L
s
.01 w
.5255 .3585 Mdot
.5 Mabswid
.5255 .3585 m
.50761 .3608 L
s
.5255 .3585 m
.52473 .34913 L
s
.5255 .3585 m
.52462 .34916 L
s
.5255 .3585 m
.52452 .34922 L
s
.5255 .3585 m
.54161 .35825 L
s
.5255 .3585 m
.54342 .3593 L
s
.5255 .3585 m
.51366 .35059 L
s
.5255 .3585 m
.51227 .35145 L
s
.5255 .3585 m
.51144 .35253 L
s
.5255 .3585 m
.53609 .34966 L
s
.5255 .3585 m
.53736 .35043 L
s
.5255 .3585 m
.53811 .35146 L
s
.52551 .35978 m
.5255 .3585 L
s
.01 w
.49689 .36167 Mdot
.5 Mabswid
.49689 .36167 m
.48859 .36386 L
s
.49689 .36167 m
.48599 .35237 L
s
.49424 .36296 m
.49689 .36167 L
s
.49984 .35355 m
.49689 .36167 L
s
.49794 .35427 m
.49689 .36167 L
s
.50761 .3608 m
.49689 .36167 L
s
.01 w
.50761 .3608 Mdot
.5 Mabswid
.50761 .3608 m
.49424 .36296 L
s
.50761 .3608 m
.49984 .35355 L
s
.50761 .3608 m
.49794 .35427 L
s
.49236 .36353 m
.50761 .3608 L
s
.49777 .3555 m
.50761 .3608 L
s
.5068 .36161 m
.50761 .3608 L
s
.51227 .35145 m
.50761 .3608 L
s
.51144 .35253 m
.50761 .3608 L
s
.51101 .3532 m
.50761 .3608 L
s
.52551 .35978 m
.50761 .3608 L
s
.52551 .36061 m
.50761 .3608 L
s
.01 w
.48181 .36357 Mdot
.5 Mabswid
.48268 .35247 m
.48181 .36357 L
s
.48397 .36472 m
.48181 .36357 L
s
.4838 .35313 m
.48181 .36357 L
s
.01 w
.49424 .36296 Mdot
.5 Mabswid
.49424 .36296 m
.48859 .36386 L
s
.49424 .36296 m
.48599 .35237 L
s
.49984 .35355 m
.49424 .36296 L
s
.49794 .35427 m
.49424 .36296 L
s
.48397 .36472 m
.49424 .36296 L
s
.4838 .35313 m
.49424 .36296 L
s
.49236 .36353 m
.49424 .36296 L
s
.49777 .3555 m
.49424 .36296 L
s
.5068 .36161 m
.49424 .36296 L
s
.01 w
.5068 .36161 Mdot
.5 Mabswid
.5068 .36161 m
.49794 .35427 L
s
.5068 .36161 m
.49236 .36353 L
s
.5068 .36161 m
.49777 .3555 L
s
.51144 .35253 m
.5068 .36161 L
s
.51101 .3532 m
.5068 .36161 L
s
.52551 .35978 m
.5068 .36161 L
s
.52551 .36061 m
.5068 .36161 L
s
.01 w
.52551 .35978 Mdot
.5 Mabswid
.52551 .35978 m
.52462 .34916 L
s
.52551 .35978 m
.52452 .34922 L
s
.52551 .35978 m
.54161 .35825 L
s
.52551 .35978 m
.54342 .3593 L
s
.52551 .35978 m
.52447 .34953 L
s
.52551 .35978 m
.5442 .36005 L
s
.52551 .35978 m
.51227 .35145 L
s
.52551 .35978 m
.51144 .35253 L
s
.52551 .35978 m
.51101 .3532 L
s
.52551 .35978 m
.53736 .35043 L
s
.52551 .35978 m
.53811 .35146 L
s
.52551 .35978 m
.53848 .35212 L
s
.52551 .36061 m
.52551 .35978 L
s
.01 w
.48859 .36386 Mdot
.5 Mabswid
.48599 .35237 m
.48859 .36386 L
s
.49984 .35355 m
.48859 .36386 L
s
.49794 .35427 m
.48859 .36386 L
s
.47713 .35703 m
.48859 .36386 L
s
.48397 .36472 m
.48859 .36386 L
s
.4838 .35313 m
.48859 .36386 L
s
.49236 .36353 m
.48859 .36386 L
s
.48007 .36542 m
.48859 .36386 L
s
.01 w
.49236 .36353 Mdot
.5 Mabswid
.49236 .36353 m
.48599 .35237 L
s
.49236 .36353 m
.49794 .35427 L
s
.49236 .36353 m
.48397 .36472 L
s
.49236 .36353 m
.4838 .35313 L
s
.49777 .3555 m
.49236 .36353 L
s
.01 w
.54161 .35825 Mdot
.5 Mabswid
.54161 .35825 m
.54989 .35155 L
s
.54161 .35825 m
.55173 .35208 L
s
.54161 .35825 m
.55414 .35931 L
s
.54161 .35825 m
.55684 .36034 L
s
.54342 .3593 m
.54161 .35825 L
s
.53609 .34966 m
.54161 .35825 L
s
.53736 .35043 m
.54161 .35825 L
s
.53811 .35146 m
.54161 .35825 L
s
.01 w
.48397 .36472 Mdot
.5 Mabswid
.48397 .36472 m
.48599 .35237 L
s
.48397 .36472 m
.47713 .35703 L
s
.48397 .36472 m
.48268 .35247 L
s
.4838 .35313 m
.48397 .36472 L
s
.48007 .36542 m
.48397 .36472 L
s
.01 w
.48007 .36542 Mdot
.5 Mabswid
.48007 .36542 m
.47713 .35703 L
s
.48007 .36542 m
.4838 .35313 L
s
.01 w
.52551 .36061 Mdot
.5 Mabswid
.52551 .36061 m
.52452 .34922 L
s
.52551 .36061 m
.54342 .3593 L
s
.52551 .36061 m
.52447 .34953 L
s
.52551 .36061 m
.5442 .36005 L
s
.52551 .36061 m
.51144 .35253 L
s
.52551 .36061 m
.51101 .3532 L
s
.52551 .36061 m
.53811 .35146 L
s
.52551 .36061 m
.53848 .35212 L
s
.01 w
.54342 .3593 Mdot
.5 Mabswid
.54342 .3593 m
.54989 .35155 L
s
.54342 .3593 m
.55173 .35208 L
s
.54342 .3593 m
.55414 .35931 L
s
.54342 .3593 m
.55684 .36034 L
s
.55201 .35331 m
.54342 .3593 L
s
.55874 .36079 m
.54342 .3593 L
s
.5442 .36005 m
.54342 .3593 L
s
.53736 .35043 m
.54342 .3593 L
s
.53811 .35146 m
.54342 .3593 L
s
.53848 .35212 m
.54342 .3593 L
s
.01 w
.5442 .36005 Mdot
.5 Mabswid
.5442 .36005 m
.55173 .35208 L
s
.5442 .36005 m
.55684 .36034 L
s
.5442 .36005 m
.55201 .35331 L
s
.5442 .36005 m
.55874 .36079 L
s
.53811 .35146 m
.5442 .36005 L
s
.53848 .35212 m
.5442 .36005 L
s
.01 w
.55414 .35931 Mdot
.5 Mabswid
.55414 .35931 m
.56286 .34927 L
s
.55414 .35931 m
.54989 .35155 L
s
.55414 .35931 m
.55173 .35208 L
s
.55414 .35931 m
.56253 .36079 L
s
.55684 .36034 m
.55414 .35931 L
s
.01 w
.55684 .36034 Mdot
.5 Mabswid
.55684 .36034 m
.56286 .34927 L
s
.55684 .36034 m
.54989 .35155 L
s
.55684 .36034 m
.55173 .35208 L
s
.55684 .36034 m
.56253 .36079 L
s
.56512 .34984 m
.55684 .36034 L
s
.55201 .35331 m
.55684 .36034 L
s
.56719 .36126 m
.55684 .36034 L
s
.55874 .36079 m
.55684 .36034 L
s
.01 w
.32577 .46313 Mdot
.5 Mabswid
.32577 .46313 m
.32439 .46457 L
s
.31601 .45292 m
.32577 .46313 L
s
.31715 .45135 m
.32577 .46313 L
s
.01 w
.32439 .46457 Mdot
.5 Mabswid
.32439 .46457 m
.3207 .46773 L
s
.31298 .4553 m
.32439 .46457 L
s
.31601 .45292 m
.32439 .46457 L
s
.31715 .45135 m
.32439 .46457 L
s
.01 w
.55874 .36079 Mdot
.5 Mabswid
.55874 .36079 m
.56286 .34927 L
s
.55874 .36079 m
.55173 .35208 L
s
.55874 .36079 m
.56253 .36079 L
s
.55874 .36079 m
.56512 .34984 L
s
.55874 .36079 m
.55201 .35331 L
s
.55874 .36079 m
.56719 .36126 L
s
.01 w
.56937 .3599 Mdot
.5 Mabswid
.56937 .3599 m
.56642 .34897 L
s
.56937 .3599 m
.56512 .34984 L
s
.56719 .36126 m
.56937 .3599 L
s
.01 w
.56253 .36079 Mdot
.5 Mabswid
.56253 .36079 m
.56286 .34927 L
s
.56253 .36079 m
.54989 .35155 L
s
.56253 .36079 m
.55173 .35208 L
s
.57239 .35316 m
.56253 .36079 L
s
.56512 .34984 m
.56253 .36079 L
s
.56719 .36126 m
.56253 .36079 L
s
.57113 .36165 m
.56253 .36079 L
s
.01 w
.3207 .46773 Mdot
.5 Mabswid
.3207 .46773 m
.31576 .47128 L
s
.30893 .45813 m
.3207 .46773 L
s
.31298 .4553 m
.3207 .46773 L
s
.31601 .45292 m
.3207 .46773 L
s
.01 w
.56719 .36126 Mdot
.5 Mabswid
.56719 .36126 m
.56286 .34927 L
s
.56719 .36126 m
.57239 .35316 L
s
.56719 .36126 m
.56642 .34897 L
s
.56719 .36126 m
.56512 .34984 L
s
.57113 .36165 m
.56719 .36126 L
s
.01 w
.57113 .36165 Mdot
.5 Mabswid
.57113 .36165 m
.57239 .35316 L
s
.57113 .36165 m
.56512 .34984 L
s
.01 w
.31576 .47128 Mdot
.5 Mabswid
.31576 .47128 m
.31068 .47453 L
s
.30414 .46016 m
.31576 .47128 L
s
.30893 .45813 m
.31576 .47128 L
s
.31298 .4553 m
.31576 .47128 L
s
.01 w
.72283 .45702 Mdot
.5 Mabswid
.72283 .45702 m
.7354 .44905 L
s
.72283 .45702 m
.73367 .44732 L
s
.72283 .45702 m
.72543 .45938 L
s
.01 w
.72543 .45938 Mdot
.5 Mabswid
.72543 .45938 m
.73932 .45204 L
s
.72543 .45938 m
.7354 .44905 L
s
.72543 .45938 m
.73367 .44732 L
s
.72543 .45938 m
.73139 .46378 L
s
.01 w
.51366 .35059 Mdot
.5 Mabswid
.51366 .35059 m
.49984 .35355 L
s
.51366 .35059 m
.51188 .34529 L
s
.51366 .35059 m
.52473 .34913 L
s
.51366 .35059 m
.52462 .34916 L
s
.51366 .35059 m
.50113 .34079 L
s
.51366 .35059 m
.49936 .34502 L
s
.51227 .35145 m
.51366 .35059 L
s
.01 w
.31068 .47453 Mdot
.5 Mabswid
.31068 .47453 m
.30241 .46651 L
s
.31068 .47453 m
.30801 .47726 L
s
.30147 .46332 m
.31068 .47453 L
s
.30414 .46016 m
.31068 .47453 L
s
.30893 .45813 m
.31068 .47453 L
s
.01 w
.30801 .47726 Mdot
.5 Mabswid
.30801 .47726 m
.30577 .47906 L
s
.29903 .46489 m
.30801 .47726 L
s
.30147 .46332 m
.30801 .47726 L
s
.30414 .46016 m
.30801 .47726 L
s
.01 w
.73139 .46378 Mdot
.5 Mabswid
.73139 .46378 m
.74441 .45533 L
s
.73139 .46378 m
.73932 .45204 L
s
.73139 .46378 m
.7354 .44905 L
s
.73139 .46378 m
.73759 .46825 L
s
.01 w
.30577 .47906 Mdot
.5 Mabswid
.29903 .46489 m
.30577 .47906 L
s
.30147 .46332 m
.30577 .47906 L
s
.01 w
.53609 .34966 Mdot
.5 Mabswid
.53609 .34966 m
.53641 .34432 L
s
.53609 .34966 m
.52473 .34913 L
s
.53609 .34966 m
.52462 .34916 L
s
.53609 .34966 m
.54989 .35155 L
s
.53609 .34966 m
.54745 .33892 L
s
.53609 .34966 m
.54902 .34303 L
s
.53736 .35043 m
.53609 .34966 L
s
.01 w
.73759 .46825 Mdot
.5 Mabswid
.73759 .46825 m
.74962 .45839 L
s
.73759 .46825 m
.74441 .45533 L
s
.73759 .46825 m
.73932 .45204 L
s
.73759 .46825 m
.74357 .47232 L
s
.01 w
.51227 .35145 Mdot
.5 Mabswid
.51227 .35145 m
.49984 .35355 L
s
.51227 .35145 m
.49794 .35427 L
s
.51227 .35145 m
.51188 .34529 L
s
.51227 .35145 m
.51115 .34519 L
s
.51227 .35145 m
.52473 .34913 L
s
.51227 .35145 m
.52462 .34916 L
s
.51227 .35145 m
.52452 .34922 L
s
.51227 .35145 m
.50113 .34079 L
s
.51227 .35145 m
.49936 .34502 L
s
.51227 .35145 m
.49888 .34702 L
s
.51144 .35253 m
.51227 .35145 L
s
.01 w
.49984 .35355 Mdot
.5 Mabswid
.49984 .35355 m
.48599 .35237 L
s
.49794 .35427 m
.49984 .35355 L
s
.48834 .34325 m
.49984 .35355 L
s
.49936 .34502 m
.49984 .35355 L
s
.49888 .34702 m
.49984 .35355 L
s
.51144 .35253 m
.49984 .35355 L
s
.01 w
.52473 .34913 Mdot
.5 Mabswid
.52473 .34913 m
.51188 .34529 L
s
.52473 .34913 m
.52396 .34318 L
s
.52473 .34913 m
.53641 .34432 L
s
.52462 .34916 m
.52473 .34913 L
s
.53736 .35043 m
.52473 .34913 L
s
.01 w
.74357 .47232 Mdot
.5 Mabswid
.74357 .47232 m
.75228 .46635 L
s
.74357 .47232 m
.75253 .46098 L
s
.74357 .47232 m
.74962 .45839 L
s
.74357 .47232 m
.74441 .45533 L
s
.74357 .47232 m
.74641 .47507 L
s
.01 w
.53736 .35043 Mdot
.5 Mabswid
.53736 .35043 m
.53641 .34432 L
s
.53736 .35043 m
.53697 .3442 L
s
.53736 .35043 m
.52462 .34916 L
s
.53736 .35043 m
.52452 .34922 L
s
.53736 .35043 m
.54989 .35155 L
s
.53736 .35043 m
.55173 .35208 L
s
.53736 .35043 m
.54745 .33892 L
s
.53736 .35043 m
.54902 .34303 L
s
.53736 .35043 m
.54946 .345 L
s
.53811 .35146 m
.53736 .35043 L
s
.01 w
.49777 .3555 Mdot
.5 Mabswid
.49777 .3555 m
.48599 .35237 L
s
.49777 .3555 m
.49794 .35427 L
s
.49777 .3555 m
.4838 .35313 L
s
.49888 .34702 m
.49777 .3555 L
s
.49843 .34799 m
.49777 .3555 L
s
.51144 .35253 m
.49777 .3555 L
s
.51101 .3532 m
.49777 .3555 L
s
.01 w
.49794 .35427 Mdot
.5 Mabswid
.49794 .35427 m
.48599 .35237 L
s
.4838 .35313 m
.49794 .35427 L
s
.48834 .34325 m
.49794 .35427 L
s
.49936 .34502 m
.49794 .35427 L
s
.49888 .34702 m
.49794 .35427 L
s
.49843 .34799 m
.49794 .35427 L
s
.51144 .35253 m
.49794 .35427 L
s
.51101 .3532 m
.49794 .35427 L
s
.01 w
.51144 .35253 Mdot
.5 Mabswid
.51144 .35253 m
.51188 .34529 L
s
.51144 .35253 m
.51115 .34519 L
s
.51144 .35253 m
.52462 .34916 L
s
.51144 .35253 m
.52452 .34922 L
s
.51144 .35253 m
.51186 .34581 L
s
.51144 .35253 m
.52447 .34953 L
s
.51144 .35253 m
.49936 .34502 L
s
.51144 .35253 m
.49888 .34702 L
s
.51144 .35253 m
.49843 .34799 L
s
.51101 .3532 m
.51144 .35253 L
s
.01 w
.74641 .47507 Mdot
.5 Mabswid
.74641 .47507 m
.75488 .46273 L
s
.74641 .47507 m
.75253 .46098 L
s
.74641 .47507 m
.74962 .45839 L
s
.74641 .47507 m
.74865 .47685 L
s
.01 w
.54989 .35155 Mdot
.5 Mabswid
.54989 .35155 m
.56286 .34927 L
s
.55173 .35208 m
.54989 .35155 L
s
.55906 .3405 m
.54989 .35155 L
s
.54902 .34303 m
.54989 .35155 L
s
.54946 .345 m
.54989 .35155 L
s
.53811 .35146 m
.54989 .35155 L
s
.01 w
.51101 .3532 Mdot
.5 Mabswid
.51101 .3532 m
.51115 .34519 L
s
.51101 .3532 m
.52452 .34922 L
s
.51101 .3532 m
.51186 .34581 L
s
.51101 .3532 m
.52447 .34953 L
s
.51101 .3532 m
.49888 .34702 L
s
.51101 .3532 m
.49843 .34799 L
s
.01 w
.74865 .47685 Mdot
.5 Mabswid
.74865 .47685 m
.75488 .46273 L
s
.74865 .47685 m
.75253 .46098 L
s
.01 w
.53811 .35146 Mdot
.5 Mabswid
.53811 .35146 m
.53641 .34432 L
s
.53811 .35146 m
.53697 .3442 L
s
.53811 .35146 m
.52462 .34916 L
s
.53811 .35146 m
.52452 .34922 L
s
.53811 .35146 m
.55173 .35208 L
s
.53811 .35146 m
.53612 .34481 L
s
.53811 .35146 m
.52447 .34953 L
s
.53811 .35146 m
.55201 .35331 L
s
.53811 .35146 m
.54902 .34303 L
s
.53811 .35146 m
.54946 .345 L
s
.53811 .35146 m
.54986 .34593 L
s
.53848 .35212 m
.53811 .35146 L
s
.01 w
.55173 .35208 Mdot
.5 Mabswid
.55173 .35208 m
.56286 .34927 L
s
.56512 .34984 m
.55173 .35208 L
s
.55201 .35331 m
.55173 .35208 L
s
.55906 .3405 m
.55173 .35208 L
s
.54902 .34303 m
.55173 .35208 L
s
.54946 .345 m
.55173 .35208 L
s
.54986 .34593 m
.55173 .35208 L
s
.53848 .35212 m
.55173 .35208 L
s
.01 w
.52462 .34916 Mdot
.5 Mabswid
.52462 .34916 m
.51188 .34529 L
s
.52462 .34916 m
.51115 .34519 L
s
.52462 .34916 m
.52396 .34318 L
s
.52462 .34916 m
.52382 .34271 L
s
.52462 .34916 m
.53641 .34432 L
s
.52462 .34916 m
.53697 .3442 L
s
.52452 .34922 m
.52462 .34916 L
s
.01 w
.55201 .35331 Mdot
.5 Mabswid
.55201 .35331 m
.56286 .34927 L
s
.55201 .35331 m
.56512 .34984 L
s
.54946 .345 m
.55201 .35331 L
s
.54986 .34593 m
.55201 .35331 L
s
.53848 .35212 m
.55201 .35331 L
s
.01 w
.53848 .35212 Mdot
.5 Mabswid
.53848 .35212 m
.53697 .3442 L
s
.53848 .35212 m
.52452 .34922 L
s
.53848 .35212 m
.53612 .34481 L
s
.53848 .35212 m
.52447 .34953 L
s
.53848 .35212 m
.54946 .345 L
s
.53848 .35212 m
.54986 .34593 L
s
.01 w
.50113 .34079 Mdot
.5 Mabswid
.50113 .34079 m
.48674 .33356 L
s
.49936 .34502 m
.50113 .34079 L
s
.01 w
.47713 .35703 Mdot
.5 Mabswid
.47713 .35703 m
.48599 .35237 L
s
.46533 .34774 m
.47713 .35703 L
s
.4838 .35313 m
.47713 .35703 L
s
.01 w
.48268 .35247 Mdot
.5 Mabswid
.4838 .35313 m
.48268 .35247 L
s
.4908 .34375 m
.48268 .35247 L
s
.48564 .34316 m
.48268 .35247 L
s
.01 w
.52452 .34922 Mdot
.5 Mabswid
.52452 .34922 m
.51188 .34529 L
s
.52452 .34922 m
.51115 .34519 L
s
.52452 .34922 m
.52396 .34318 L
s
.52452 .34922 m
.52382 .34271 L
s
.52452 .34922 m
.53641 .34432 L
s
.52452 .34922 m
.53697 .3442 L
s
.51186 .34581 m
.52452 .34922 L
s
.52371 .34211 m
.52452 .34922 L
s
.53612 .34481 m
.52452 .34922 L
s
.52447 .34953 m
.52452 .34922 L
s
.01 w
.54745 .33892 Mdot
.5 Mabswid
.54745 .33892 m
.56048 .33067 L
s
.54902 .34303 m
.54745 .33892 L
s
.01 w
.52447 .34953 Mdot
.5 Mabswid
.52447 .34953 m
.51115 .34519 L
s
.52447 .34953 m
.52382 .34271 L
s
.52447 .34953 m
.53697 .3442 L
s
.52447 .34953 m
.51186 .34581 L
s
.52447 .34953 m
.52371 .34211 L
s
.52447 .34953 m
.53612 .34481 L
s
.01 w
.4838 .35313 Mdot
.5 Mabswid
.4838 .35313 m
.48599 .35237 L
s
.4838 .35313 m
.46533 .34774 L
s
.4838 .35313 m
.46741 .34376 L
s
.4908 .34375 m
.4838 .35313 L
s
.47299 .3403 m
.4838 .35313 L
s
.48834 .34325 m
.4838 .35313 L
s
.48564 .34316 m
.4838 .35313 L
s
.49888 .34702 m
.4838 .35313 L
s
.49843 .34799 m
.4838 .35313 L
s
.01 w
.57239 .35316 Mdot
.5 Mabswid
.57239 .35316 m
.56286 .34927 L
s
.58181 .34322 m
.57239 .35316 L
s
.56512 .34984 m
.57239 .35316 L
s
.01 w
.48599 .35237 Mdot
.5 Mabswid
.46533 .34774 m
.48599 .35237 L
s
.46741 .34376 m
.48599 .35237 L
s
.47299 .3403 m
.48599 .35237 L
s
.48834 .34325 m
.48599 .35237 L
s
.48564 .34316 m
.48599 .35237 L
s
.49936 .34502 m
.48599 .35237 L
s
.49888 .34702 m
.48599 .35237 L
s
.49843 .34799 m
.48599 .35237 L
s
.01 w
.49936 .34502 Mdot
.5 Mabswid
.49936 .34502 m
.5021 .34128 L
s
.49936 .34502 m
.51188 .34529 L
s
.49936 .34502 m
.51115 .34519 L
s
.49936 .34502 m
.48674 .33356 L
s
.49936 .34502 m
.48361 .33593 L
s
.49936 .34502 m
.48834 .34325 L
s
.49888 .34702 m
.49936 .34502 L
s
.01 w
.56642 .34897 Mdot
.5 Mabswid
.55669 .341 m
.56642 .34897 L
s
.56512 .34984 m
.56642 .34897 L
s
.56148 .34014 m
.56642 .34897 L
s
.01 w
.51188 .34529 Mdot
.5 Mabswid
.51188 .34529 m
.5021 .34128 L
s
.51115 .34519 m
.51188 .34529 L
s
.52352 .33999 m
.51188 .34529 L
s
.52396 .34318 m
.51188 .34529 L
s
.52382 .34271 m
.51188 .34529 L
s
.48834 .34325 m
.51188 .34529 L
s
.49888 .34702 m
.51188 .34529 L
s
.01 w
.49888 .34702 Mdot
.5 Mabswid
.49888 .34702 m
.5021 .34128 L
s
.49888 .34702 m
.51115 .34519 L
s
.49888 .34702 m
.50249 .34032 L
s
.49888 .34702 m
.51186 .34581 L
s
.49888 .34702 m
.48361 .33593 L
s
.49888 .34702 m
.48834 .34325 L
s
.49888 .34702 m
.48564 .34316 L
s
.49843 .34799 m
.49888 .34702 L
s
.01 w
.54902 .34303 Mdot
.5 Mabswid
.54902 .34303 m
.54486 .33961 L
s
.54902 .34303 m
.53641 .34432 L
s
.54902 .34303 m
.53697 .3442 L
s
.54902 .34303 m
.56286 .34927 L
s
.54902 .34303 m
.56048 .33067 L
s
.54902 .34303 m
.56335 .33286 L
s
.54902 .34303 m
.55906 .3405 L
s
.54946 .345 m
.54902 .34303 L
s
.01 w
.30241 .46651 Mdot
.5 Mabswid
.29753 .44709 m
.30241 .46651 L
s
.30414 .46016 m
.30241 .46651 L
s
.01 w
.53641 .34432 Mdot
.5 Mabswid
.53641 .34432 m
.52352 .33999 L
s
.53641 .34432 m
.54486 .33961 L
s
.53641 .34432 m
.52396 .34318 L
s
.53641 .34432 m
.52382 .34271 L
s
.53697 .3442 m
.53641 .34432 L
s
.55906 .3405 m
.53641 .34432 L
s
.54946 .345 m
.53641 .34432 L
s
.01 w
.49843 .34799 Mdot
.5 Mabswid
.49843 .34799 m
.5021 .34128 L
s
.49843 .34799 m
.51115 .34519 L
s
.49843 .34799 m
.50249 .34032 L
s
.49843 .34799 m
.51186 .34581 L
s
.49843 .34799 m
.48834 .34325 L
s
.49843 .34799 m
.48564 .34316 L
s
.01 w
.56286 .34927 Mdot
.5 Mabswid
.58181 .34322 m
.56286 .34927 L
s
.57902 .33947 m
.56286 .34927 L
s
.56512 .34984 m
.56286 .34927 L
s
.57301 .33647 m
.56286 .34927 L
s
.55906 .3405 m
.56286 .34927 L
s
.56148 .34014 m
.56286 .34927 L
s
.54946 .345 m
.56286 .34927 L
s
.54986 .34593 m
.56286 .34927 L
s
.01 w
.56512 .34984 Mdot
.5 Mabswid
.56512 .34984 m
.58181 .34322 L
s
.56512 .34984 m
.57902 .33947 L
s
.56512 .34984 m
.55669 .341 L
s
.57301 .33647 m
.56512 .34984 L
s
.55906 .3405 m
.56512 .34984 L
s
.56148 .34014 m
.56512 .34984 L
s
.54946 .345 m
.56512 .34984 L
s
.54986 .34593 m
.56512 .34984 L
s
.01 w
.75228 .46635 Mdot
.5 Mabswid
.75228 .46635 m
.75627 .44991 L
s
.74962 .45839 m
.75228 .46635 L
s
.01 w
.51115 .34519 Mdot
.5 Mabswid
.51115 .34519 m
.5021 .34128 L
s
.52352 .33999 m
.51115 .34519 L
s
.52396 .34318 m
.51115 .34519 L
s
.52382 .34271 m
.51115 .34519 L
s
.50249 .34032 m
.51115 .34519 L
s
.51186 .34581 m
.51115 .34519 L
s
.52371 .34211 m
.51115 .34519 L
s
.48834 .34325 m
.51115 .34519 L
s
.01 w
.54946 .345 Mdot
.5 Mabswid
.54946 .345 m
.54486 .33961 L
s
.54946 .345 m
.53697 .3442 L
s
.54946 .345 m
.54426 .33867 L
s
.54946 .345 m
.53612 .34481 L
s
.54946 .345 m
.56335 .33286 L
s
.54946 .345 m
.55906 .3405 L
s
.54946 .345 m
.56148 .34014 L
s
.54986 .34593 m
.54946 .345 L
s
.01 w
.31715 .45135 Mdot
.5 Mabswid
.31715 .45135 m
.31601 .45292 L
s
.31128 .43947 m
.31715 .45135 L
s
.3123 .43801 m
.31715 .45135 L
s
.01 w
.51186 .34581 Mdot
.5 Mabswid
.51186 .34581 m
.5021 .34128 L
s
.51186 .34581 m
.52382 .34271 L
s
.51186 .34581 m
.50249 .34032 L
s
.52371 .34211 m
.51186 .34581 L
s
.01 w
.53697 .3442 Mdot
.5 Mabswid
.53697 .3442 m
.52352 .33999 L
s
.53697 .3442 m
.54486 .33961 L
s
.53697 .3442 m
.52396 .34318 L
s
.53697 .3442 m
.52382 .34271 L
s
.54426 .33867 m
.53697 .3442 L
s
.52371 .34211 m
.53697 .3442 L
s
.53612 .34481 m
.53697 .3442 L
s
.55906 .3405 m
.53697 .3442 L
s
.54986 .34593 m
.53697 .3442 L
s
.01 w
.31601 .45292 Mdot
.5 Mabswid
.31601 .45292 m
.31298 .4553 L
s
.30836 .44156 m
.31601 .45292 L
s
.31128 .43947 m
.31601 .45292 L
s
.3123 .43801 m
.31601 .45292 L
s
.01 w
.54986 .34593 Mdot
.5 Mabswid
.54986 .34593 m
.54486 .33961 L
s
.54986 .34593 m
.54426 .33867 L
s
.54986 .34593 m
.53612 .34481 L
s
.54986 .34593 m
.55906 .3405 L
s
.54986 .34593 m
.56148 .34014 L
s
.01 w
.53612 .34481 Mdot
.5 Mabswid
.53612 .34481 m
.54486 .33961 L
s
.53612 .34481 m
.52382 .34271 L
s
.53612 .34481 m
.54426 .33867 L
s
.53612 .34481 m
.52371 .34211 L
s
.01 w
.52396 .34318 Mdot
.5 Mabswid
.52396 .34318 m
.5021 .34128 L
s
.52396 .34318 m
.52352 .33999 L
s
.52396 .34318 m
.54486 .33961 L
s
.52382 .34271 m
.52396 .34318 L
s
.01 w
.48674 .33356 Mdot
.5 Mabswid
.48674 .33356 m
.47069 .32681 L
s
.48361 .33593 m
.48674 .33356 L
s
.01 w
.31298 .4553 Mdot
.5 Mabswid
.31298 .4553 m
.30893 .45813 L
s
.30453 .44402 m
.31298 .4553 L
s
.30836 .44156 m
.31298 .4553 L
s
.31128 .43947 m
.31298 .4553 L
s
.01 w
.73367 .44732 Mdot
.5 Mabswid
.73367 .44732 m
.74138 .43683 L
s
.73367 .44732 m
.74017 .43524 L
s
.73367 .44732 m
.7354 .44905 L
s
.01 w
.30893 .45813 Mdot
.5 Mabswid
.30893 .45813 m
.30414 .46016 L
s
.30058 .44654 m
.30893 .45813 L
s
.30453 .44402 m
.30893 .45813 L
s
.30836 .44156 m
.30893 .45813 L
s
.01 w
.7354 .44905 Mdot
.5 Mabswid
.7354 .44905 m
.74456 .4392 L
s
.7354 .44905 m
.74138 .43683 L
s
.7354 .44905 m
.74017 .43524 L
s
.7354 .44905 m
.73932 .45204 L
s
.01 w
.4908 .34375 Mdot
.5 Mabswid
.4908 .34375 m
.50473 .33745 L
s
.50249 .34032 m
.4908 .34375 L
s
.48564 .34316 m
.4908 .34375 L
s
.01 w
.56048 .33067 Mdot
.5 Mabswid
.56048 .33067 m
.57511 .32295 L
s
.56335 .33286 m
.56048 .33067 L
s
.01 w
.52382 .34271 Mdot
.5 Mabswid
.52382 .34271 m
.5021 .34128 L
s
.52382 .34271 m
.52352 .33999 L
s
.52382 .34271 m
.54486 .33961 L
s
.50249 .34032 m
.52382 .34271 L
s
.5233 .33789 m
.52382 .34271 L
s
.54426 .33867 m
.52382 .34271 L
s
.52371 .34211 m
.52382 .34271 L
s
.01 w
.73932 .45204 Mdot
.5 Mabswid
.73932 .45204 m
.74876 .44181 L
s
.73932 .45204 m
.74456 .4392 L
s
.73932 .45204 m
.74138 .43683 L
s
.73932 .45204 m
.74441 .45533 L
s
.01 w
.30147 .46332 Mdot
.5 Mabswid
.30147 .46332 m
.29903 .46489 L
s
.30414 .46016 m
.30147 .46332 L
s
.29454 .45014 m
.30147 .46332 L
s
.29695 .44888 m
.30147 .46332 L
s
.30058 .44654 m
.30147 .46332 L
s
.01 w
.30414 .46016 Mdot
.5 Mabswid
.30414 .46016 m
.29753 .44709 L
s
.29695 .44888 m
.30414 .46016 L
s
.30058 .44654 m
.30414 .46016 L
s
.30453 .44402 m
.30414 .46016 L
s
.01 w
.29903 .46489 Mdot
.5 Mabswid
.29454 .45014 m
.29903 .46489 L
s
.29695 .44888 m
.29903 .46489 L
s
.01 w
.52371 .34211 Mdot
.5 Mabswid
.52371 .34211 m
.5021 .34128 L
s
.52371 .34211 m
.52352 .33999 L
s
.52371 .34211 m
.54486 .33961 L
s
.52371 .34211 m
.50249 .34032 L
s
.52371 .34211 m
.5233 .33789 L
s
.52371 .34211 m
.54426 .33867 L
s
.01 w
.48361 .33593 Mdot
.5 Mabswid
.48361 .33593 m
.47069 .32681 L
s
.48361 .33593 m
.46771 .32987 L
s
.48834 .34325 m
.48361 .33593 L
s
.01 w
.48834 .34325 Mdot
.5 Mabswid
.48834 .34325 m
.5021 .34128 L
s
.48834 .34325 m
.46741 .34376 L
s
.48834 .34325 m
.47647 .33751 L
s
.48834 .34325 m
.50249 .34032 L
s
.48834 .34325 m
.46771 .32987 L
s
.48834 .34325 m
.46719 .33395 L
s
.48834 .34325 m
.47299 .3403 L
s
.48564 .34316 m
.48834 .34325 L
s
.01 w
.74441 .45533 Mdot
.5 Mabswid
.74441 .45533 m
.75351 .44366 L
s
.74441 .45533 m
.74876 .44181 L
s
.74441 .45533 m
.74456 .4392 L
s
.74441 .45533 m
.74962 .45839 L
s
.01 w
.55669 .341 Mdot
.5 Mabswid
.55669 .341 m
.54183 .33589 L
s
.55669 .341 m
.54426 .33867 L
s
.56148 .34014 m
.55669 .341 L
s
.01 w
.74962 .45839 Mdot
.5 Mabswid
.74962 .45839 m
.75627 .44991 L
s
.74962 .45839 m
.75649 .44671 L
s
.74962 .45839 m
.75351 .44366 L
s
.74962 .45839 m
.74876 .44181 L
s
.74962 .45839 m
.75253 .46098 L
s
.01 w
.52352 .33999 Mdot
.5 Mabswid
.52352 .33999 m
.5021 .34128 L
s
.54486 .33961 m
.52352 .33999 L
s
.50746 .33628 m
.52352 .33999 L
s
.50249 .34032 m
.52352 .33999 L
s
.53852 .33505 m
.52352 .33999 L
s
.5233 .33789 m
.52352 .33999 L
s
.54426 .33867 m
.52352 .33999 L
s
.5231 .33607 m
.52352 .33999 L
s
.01 w
.75253 .46098 Mdot
.5 Mabswid
.75253 .46098 m
.75904 .44823 L
s
.75253 .46098 m
.75649 .44671 L
s
.75253 .46098 m
.75351 .44366 L
s
.75253 .46098 m
.75488 .46273 L
s
.01 w
.48564 .34316 Mdot
.5 Mabswid
.48564 .34316 m
.5021 .34128 L
s
.48564 .34316 m
.46741 .34376 L
s
.48564 .34316 m
.47647 .33751 L
s
.48564 .34316 m
.50473 .33745 L
s
.48564 .34316 m
.50249 .34032 L
s
.48564 .34316 m
.46719 .33395 L
s
.48564 .34316 m
.47299 .3403 L
s
.01 w
.55906 .3405 Mdot
.5 Mabswid
.55906 .3405 m
.54486 .33961 L
s
.55906 .3405 m
.56891 .33397 L
s
.55906 .3405 m
.54426 .33867 L
s
.55906 .3405 m
.57902 .33947 L
s
.55906 .3405 m
.57783 .32581 L
s
.55906 .3405 m
.57831 .32977 L
s
.55906 .3405 m
.57301 .33647 L
s
.55906 .3405 m
.56335 .33286 L
s
.56148 .34014 m
.55906 .3405 L
s
.01 w
.56335 .33286 Mdot
.5 Mabswid
.56335 .33286 m
.57511 .32295 L
s
.56335 .33286 m
.57783 .32581 L
s
.01 w
.75488 .46273 Mdot
.5 Mabswid
.75488 .46273 m
.75904 .44823 L
s
.75488 .46273 m
.75649 .44671 L
s
.01 w
.5021 .34128 Mdot
.5 Mabswid
.50746 .33628 m
.5021 .34128 L
s
.48283 .3357 m
.5021 .34128 L
s
.47647 .33751 m
.5021 .34128 L
s
.50249 .34032 m
.5021 .34128 L
s
.5233 .33789 m
.5021 .34128 L
s
.47299 .3403 m
.5021 .34128 L
s
.01 w
.50473 .33745 Mdot
.5 Mabswid
.50249 .34032 m
.50473 .33745 L
s
.52316 .33535 m
.50473 .33745 L
s
.5233 .33789 m
.50473 .33745 L
s
.01 w
.54486 .33961 Mdot
.5 Mabswid
.53852 .33505 m
.54486 .33961 L
s
.56226 .33264 m
.54486 .33961 L
s
.56891 .33397 m
.54486 .33961 L
s
.5233 .33789 m
.54486 .33961 L
s
.54426 .33867 m
.54486 .33961 L
s
.57301 .33647 m
.54486 .33961 L
s
.56148 .34014 m
.54486 .33961 L
s
.01 w
.50249 .34032 Mdot
.5 Mabswid
.50249 .34032 m
.50746 .33628 L
s
.50249 .34032 m
.48283 .3357 L
s
.50249 .34032 m
.47647 .33751 L
s
.52316 .33535 m
.50249 .34032 L
s
.5233 .33789 m
.50249 .34032 L
s
.5231 .33607 m
.50249 .34032 L
s
.47299 .3403 m
.50249 .34032 L
s
.01 w
.56148 .34014 Mdot
.5 Mabswid
.56148 .34014 m
.56891 .33397 L
s
.56148 .34014 m
.54183 .33589 L
s
.56148 .34014 m
.54426 .33867 L
s
.56148 .34014 m
.57902 .33947 L
s
.56148 .34014 m
.57831 .32977 L
s
.56148 .34014 m
.57301 .33647 L
s
.01 w
.46533 .34774 Mdot
.5 Mabswid
.46533 .34774 m
.44447 .34189 L
s
.46533 .34774 m
.44682 .33966 L
s
.46741 .34376 m
.46533 .34774 L
s
.01 w
.5233 .33789 Mdot
.5 Mabswid
.5233 .33789 m
.50746 .33628 L
s
.5233 .33789 m
.53852 .33505 L
s
.5233 .33789 m
.52316 .33535 L
s
.5233 .33789 m
.54183 .33589 L
s
.54426 .33867 m
.5233 .33789 L
s
.5231 .33607 m
.5233 .33789 L
s
.01 w
.54183 .33589 Mdot
.5 Mabswid
.54183 .33589 m
.52316 .33535 L
s
.54426 .33867 m
.54183 .33589 L
s
.01 w
.54426 .33867 Mdot
.5 Mabswid
.54426 .33867 m
.53852 .33505 L
s
.54426 .33867 m
.56226 .33264 L
s
.54426 .33867 m
.56891 .33397 L
s
.54426 .33867 m
.52316 .33535 L
s
.5231 .33607 m
.54426 .33867 L
s
.57301 .33647 m
.54426 .33867 L
s
.01 w
.47069 .32681 Mdot
.5 Mabswid
.47069 .32681 m
.45299 .32139 L
s
.46771 .32987 m
.47069 .32681 L
s
.01 w
.52316 .33535 Mdot
.5231 .33607 Mdot
.5 Mabswid
.5231 .33607 m
.50746 .33628 L
s
.5231 .33607 m
.53852 .33505 L
s
.01 w
.57511 .32295 Mdot
.5 Mabswid
.57511 .32295 m
.59119 .31655 L
s
.57783 .32581 m
.57511 .32295 L
s
.01 w
.58181 .34322 Mdot
.5 Mabswid
.58181 .34322 m
.60041 .33605 L
s
.58181 .34322 m
.59772 .334 L
s
.57902 .33947 m
.58181 .34322 L
s
.01 w
.50746 .33628 Mdot
.5 Mabswid
.48283 .3357 m
.50746 .33628 L
s
.01 w
.46741 .34376 Mdot
.5 Mabswid
.46741 .34376 m
.44447 .34189 L
s
.46741 .34376 m
.44682 .33966 L
s
.44879 .33479 m
.46741 .34376 L
s
.47299 .3403 m
.46741 .34376 L
s
.01 w
.46771 .32987 Mdot
.5 Mabswid
.46771 .32987 m
.45299 .32139 L
s
.46771 .32987 m
.44815 .32356 L
s
.46719 .33395 m
.46771 .32987 L
s
.01 w
.3123 .43801 Mdot
.5 Mabswid
.3123 .43801 m
.31128 .43947 L
s
.31017 .42468 m
.3123 .43801 L
s
.31138 .42335 m
.3123 .43801 L
s
.01 w
.53852 .33505 Mdot
.5 Mabswid
.56226 .33264 m
.53852 .33505 L
s
.01 w
.31128 .43947 Mdot
.5 Mabswid
.31128 .43947 m
.30836 .44156 L
s
.30696 .42667 m
.31128 .43947 L
s
.31017 .42468 m
.31128 .43947 L
s
.31138 .42335 m
.31128 .43947 L
s
.01 w
.47299 .3403 Mdot
.5 Mabswid
.47299 .3403 m
.44682 .33966 L
s
.47299 .3403 m
.45565 .33355 L
s
.47299 .3403 m
.47647 .33751 L
s
.47299 .3403 m
.44794 .32868 L
s
.47299 .3403 m
.44879 .33479 L
s
.47299 .3403 m
.46719 .33395 L
s
.01 w
.30836 .44156 Mdot
.5 Mabswid
.30836 .44156 m
.30453 .44402 L
s
.30274 .42905 m
.30836 .44156 L
s
.30696 .42667 m
.30836 .44156 L
s
.31017 .42468 m
.30836 .44156 L
s
.01 w
.74017 .43524 Mdot
.5 Mabswid
.74017 .43524 m
.74355 .42319 L
s
.74017 .43524 m
.74249 .42172 L
s
.74017 .43524 m
.74138 .43683 L
s
.01 w
.75627 .44991 Mdot
.5 Mabswid
.75627 .44991 m
.75754 .4304 L
s
.75351 .44366 m
.75627 .44991 L
s
.01 w
.46719 .33395 Mdot
.5 Mabswid
.46719 .33395 m
.44815 .32356 L
s
.46719 .33395 m
.44794 .32868 L
s
.01 w
.57902 .33947 Mdot
.5 Mabswid
.57902 .33947 m
.60041 .33605 L
s
.57902 .33947 m
.59772 .334 L
s
.59503 .32938 m
.57902 .33947 L
s
.57301 .33647 m
.57902 .33947 L
s
.01 w
.30453 .44402 Mdot
.5 Mabswid
.30453 .44402 m
.30058 .44654 L
s
.29819 .43244 m
.30453 .44402 L
s
.30274 .42905 m
.30453 .44402 L
s
.30696 .42667 m
.30453 .44402 L
s
.01 w
.74138 .43683 Mdot
.5 Mabswid
.74138 .43683 m
.74651 .42523 L
s
.74138 .43683 m
.74355 .42319 L
s
.74138 .43683 m
.74249 .42172 L
s
.74138 .43683 m
.74456 .4392 L
s
.01 w
.57783 .32581 Mdot
.5 Mabswid
.57783 .32581 m
.59119 .31655 L
s
.57783 .32581 m
.59562 .31827 L
s
.57831 .32977 m
.57783 .32581 L
s
.01 w
.30058 .44654 Mdot
.5 Mabswid
.30058 .44654 m
.29753 .44709 L
s
.30058 .44654 m
.29695 .44888 L
s
.29501 .43341 m
.30058 .44654 L
s
.29819 .43244 m
.30058 .44654 L
s
.30274 .42905 m
.30058 .44654 L
s
.01 w
.74456 .4392 Mdot
.5 Mabswid
.74456 .4392 m
.75052 .4275 L
s
.74456 .4392 m
.74651 .42523 L
s
.74456 .4392 m
.74355 .42319 L
s
.74456 .4392 m
.74876 .44181 L
s
.01 w
.29753 .44709 Mdot
.5 Mabswid
.29397 .42743 m
.29753 .44709 L
s
.29819 .43244 m
.29753 .44709 L
s
.01 w
.57301 .33647 Mdot
.5 Mabswid
.57301 .33647 m
.58785 .32859 L
s
.57301 .33647 m
.56891 .33397 L
s
.57301 .33647 m
.59772 .334 L
s
.57301 .33647 m
.59581 .32328 L
s
.57301 .33647 m
.59503 .32938 L
s
.57301 .33647 m
.57831 .32977 L
s
.01 w
.29695 .44888 Mdot
.5 Mabswid
.29695 .44888 m
.29454 .45014 L
s
.29242 .43461 m
.29695 .44888 L
s
.29501 .43341 m
.29695 .44888 L
s
.29819 .43244 m
.29695 .44888 L
s
.01 w
.47647 .33751 Mdot
.5 Mabswid
.47647 .33751 m
.45865 .33212 L
s
.47647 .33751 m
.45565 .33355 L
s
.47647 .33751 m
.48283 .3357 L
s
.44879 .33479 m
.47647 .33751 L
s
.01 w
.74876 .44181 Mdot
.5 Mabswid
.74876 .44181 m
.75459 .42992 L
s
.74876 .44181 m
.75052 .4275 L
s
.74876 .44181 m
.74651 .42523 L
s
.74876 .44181 m
.75351 .44366 L
s
.01 w
.29454 .45014 Mdot
.5 Mabswid
.29242 .43461 m
.29454 .45014 L
s
.29501 .43341 m
.29454 .45014 L
s
.01 w
.57831 .32977 Mdot
.5 Mabswid
.57831 .32977 m
.59562 .31827 L
s
.57831 .32977 m
.59581 .32328 L
s
.01 w
.48283 .3357 Mdot
.5 Mabswid
.48283 .3357 m
.45865 .33212 L
s
.48283 .3357 m
.45565 .33355 L
s
.01 w
.45299 .32139 Mdot
.5 Mabswid
.45299 .32139 m
.4327 .31647 L
s
.44815 .32356 m
.45299 .32139 L
s
.01 w
.75351 .44366 Mdot
.5 Mabswid
.75351 .44366 m
.75754 .4304 L
s
.75351 .44366 m
.75831 .43213 L
s
.75351 .44366 m
.75459 .42992 L
s
.75351 .44366 m
.75052 .4275 L
s
.75351 .44366 m
.75649 .44671 L
s
.01 w
.75649 .44671 Mdot
.5 Mabswid
.75649 .44671 m
.76084 .43323 L
s
.75649 .44671 m
.75831 .43213 L
s
.75649 .44671 m
.75459 .42992 L
s
.75649 .44671 m
.75904 .44823 L
s
.01 w
.56891 .33397 Mdot
.5 Mabswid
.56891 .33397 m
.58458 .32737 L
s
.56891 .33397 m
.58785 .32859 L
s
.56891 .33397 m
.56226 .33264 L
s
.59503 .32938 m
.56891 .33397 L
s
.01 w
.75904 .44823 Mdot
.5 Mabswid
.75904 .44823 m
.76084 .43323 L
s
.75904 .44823 m
.75831 .43213 L
s
.01 w
.56226 .33264 Mdot
.5 Mabswid
.56226 .33264 m
.58458 .32737 L
s
.56226 .33264 m
.58785 .32859 L
s
.01 w
.59119 .31655 Mdot
.5 Mabswid
.59119 .31655 m
.60968 .31023 L
s
.59562 .31827 m
.59119 .31655 L
s
.01 w
.44447 .34189 Mdot
.5 Mabswid
.44447 .34189 m
.42263 .3402 L
s
.44447 .34189 m
.42515 .33742 L
s
.44682 .33966 m
.44447 .34189 L
s
.01 w
.44815 .32356 Mdot
.5 Mabswid
.44815 .32356 m
.4327 .31647 L
s
.44815 .32356 m
.42692 .31875 L
s
.44794 .32868 m
.44815 .32356 L
s
.01 w
.44682 .33966 Mdot
.5 Mabswid
.44682 .33966 m
.42263 .3402 L
s
.44682 .33966 m
.42515 .33742 L
s
.42827 .33164 m
.44682 .33966 L
s
.44879 .33479 m
.44682 .33966 L
s
.01 w
.31138 .42335 Mdot
.5 Mabswid
.31138 .42335 m
.31017 .42468 L
s
.31295 .40876 m
.31138 .42335 L
s
.31468 .40749 m
.31138 .42335 L
s
.01 w
.31017 .42468 Mdot
.5 Mabswid
.31017 .42468 m
.30696 .42667 L
s
.30884 .41073 m
.31017 .42468 L
s
.31295 .40876 m
.31017 .42468 L
s
.31468 .40749 m
.31017 .42468 L
s
.01 w
.44794 .32868 Mdot
.5 Mabswid
.44794 .32868 m
.42692 .31875 L
s
.44794 .32868 m
.42589 .32423 L
s
.44879 .33479 m
.44794 .32868 L
s
.01 w
.30696 .42667 Mdot
.5 Mabswid
.30696 .42667 m
.30274 .42905 L
s
.30363 .41326 m
.30696 .42667 L
s
.30884 .41073 m
.30696 .42667 L
s
.31295 .40876 m
.30696 .42667 L
s
.01 w
.59562 .31827 Mdot
.5 Mabswid
.59562 .31827 m
.60968 .31023 L
s
.59562 .31827 m
.61494 .31208 L
s
.59581 .32328 m
.59562 .31827 L
s
.01 w
.60041 .33605 Mdot
.5 Mabswid
.60041 .33605 m
.62049 .33287 L
s
.60041 .33605 m
.61766 .33033 L
s
.59772 .334 m
.60041 .33605 L
s
.01 w
.74249 .42172 Mdot
.5 Mabswid
.74249 .42172 m
.74191 .40854 L
s
.74249 .42172 m
.74071 .40718 L
s
.74249 .42172 m
.74355 .42319 L
s
.01 w
.74355 .42319 Mdot
.5 Mabswid
.74355 .42319 m
.7452 .41034 L
s
.74355 .42319 m
.74191 .40854 L
s
.74355 .42319 m
.74071 .40718 L
s
.74355 .42319 m
.74651 .42523 L
s
.01 w
.44879 .33479 Mdot
.5 Mabswid
.44879 .33479 m
.42515 .33742 L
s
.44879 .33479 m
.436 .32987 L
s
.44879 .33479 m
.45565 .33355 L
s
.44879 .33479 m
.42589 .32423 L
s
.44879 .33479 m
.42827 .33164 L
s
.01 w
.30274 .42905 Mdot
.5 Mabswid
.30274 .42905 m
.29819 .43244 L
s
.29825 .41592 m
.30274 .42905 L
s
.30363 .41326 m
.30274 .42905 L
s
.30884 .41073 m
.30274 .42905 L
s
.01 w
.29819 .43244 Mdot
.5 Mabswid
.29819 .43244 m
.29397 .42743 L
s
.29819 .43244 m
.29501 .43341 L
s
.29519 .41745 m
.29819 .43244 L
s
.29825 .41592 m
.29819 .43244 L
s
.30363 .41326 m
.29819 .43244 L
s
.01 w
.59772 .334 Mdot
.5 Mabswid
.59772 .334 m
.62049 .33287 L
s
.59772 .334 m
.61766 .33033 L
s
.61369 .32485 m
.59772 .334 L
s
.59503 .32938 m
.59772 .334 L
s
.01 w
.74651 .42523 Mdot
.5 Mabswid
.74651 .42523 m
.7495 .41262 L
s
.74651 .42523 m
.7452 .41034 L
s
.74651 .42523 m
.74191 .40854 L
s
.74651 .42523 m
.75052 .4275 L
s
.01 w
.59581 .32328 Mdot
.5 Mabswid
.59581 .32328 m
.61494 .31208 L
s
.59581 .32328 m
.61589 .3174 L
s
.59503 .32938 m
.59581 .32328 L
s
.01 w
.45565 .33355 Mdot
.5 Mabswid
.45565 .33355 m
.43931 .32866 L
s
.45565 .33355 m
.436 .32987 L
s
.45565 .33355 m
.45865 .33212 L
s
.42827 .33164 m
.45565 .33355 L
s
.01 w
.75052 .4275 Mdot
.5 Mabswid
.75052 .4275 m
.75433 .4158 L
s
.75052 .4275 m
.7495 .41262 L
s
.75052 .4275 m
.7452 .41034 L
s
.75052 .4275 m
.75459 .42992 L
s
.01 w
.29501 .43341 Mdot
.5 Mabswid
.29501 .43341 m
.29242 .43461 L
s
.29273 .41847 m
.29501 .43341 L
s
.29519 .41745 m
.29501 .43341 L
s
.29825 .41592 m
.29501 .43341 L
s
.01 w
.4327 .31647 Mdot
.5 Mabswid
.4327 .31647 m
.40985 .31197 L
s
.42692 .31875 m
.4327 .31647 L
s
.01 w
.29242 .43461 Mdot
.5 Mabswid
.29273 .41847 m
.29242 .43461 L
s
.29519 .41745 m
.29242 .43461 L
s
.01 w
.45865 .33212 Mdot
.5 Mabswid
.45865 .33212 m
.43931 .32866 L
s
.45865 .33212 m
.436 .32987 L
s
.01 w
.75459 .42992 Mdot
.5 Mabswid
.75459 .42992 m
.75754 .4304 L
s
.75459 .42992 m
.75745 .41669 L
s
.75459 .42992 m
.75433 .4158 L
s
.75459 .42992 m
.7495 .41262 L
s
.75459 .42992 m
.75831 .43213 L
s
.01 w
.59503 .32938 Mdot
.5 Mabswid
.59503 .32938 m
.60552 .32362 L
s
.59503 .32938 m
.58785 .32859 L
s
.59503 .32938 m
.61766 .33033 L
s
.59503 .32938 m
.61589 .3174 L
s
.59503 .32938 m
.61369 .32485 L
s
.01 w
.75754 .4304 Mdot
.5 Mabswid
.75754 .4304 m
.75748 .41067 L
s
.75433 .4158 m
.75754 .4304 L
s
.01 w
.75831 .43213 Mdot
.5 Mabswid
.75831 .43213 m
.76002 .41781 L
s
.75831 .43213 m
.75745 .41669 L
s
.75831 .43213 m
.75433 .4158 L
s
.75831 .43213 m
.76084 .43323 L
s
.01 w
.58785 .32859 Mdot
.5 Mabswid
.58785 .32859 m
.60194 .32263 L
s
.58785 .32859 m
.60552 .32362 L
s
.58785 .32859 m
.58458 .32737 L
s
.61369 .32485 m
.58785 .32859 L
s
.01 w
.76084 .43323 Mdot
.5 Mabswid
.76084 .43323 m
.76002 .41781 L
s
.76084 .43323 m
.75745 .41669 L
s
.01 w
.29397 .42743 Mdot
.5 Mabswid
.29369 .40897 m
.29397 .42743 L
s
.29825 .41592 m
.29397 .42743 L
s
.01 w
.58458 .32737 Mdot
.5 Mabswid
.58458 .32737 m
.60194 .32263 L
s
.58458 .32737 m
.60552 .32362 L
s
.01 w
.42263 .3402 Mdot
.5 Mabswid
.42263 .3402 m
.39757 .34384 L
s
.42263 .3402 m
.40478 .3371 L
s
.42515 .33742 m
.42263 .3402 L
s
.01 w
.60968 .31023 Mdot
.5 Mabswid
.60968 .31023 m
.63055 .30427 L
s
.61494 .31208 m
.60968 .31023 L
s
.01 w
.42692 .31875 Mdot
.5 Mabswid
.42692 .31875 m
.40985 .31197 L
s
.42692 .31875 m
.40348 .31476 L
s
.42589 .32423 m
.42692 .31875 L
s
.01 w
.31468 .40749 Mdot
.5 Mabswid
.31468 .40749 m
.31295 .40876 L
s
.32006 .39184 m
.31468 .40749 L
s
.32285 .39054 m
.31468 .40749 L
s
.01 w
.42515 .33742 Mdot
.5 Mabswid
.42515 .33742 m
.39757 .34384 L
s
.42515 .33742 m
.40478 .3371 L
s
.41172 .32965 m
.42515 .33742 L
s
.42827 .33164 m
.42515 .33742 L
s
.01 w
.31295 .40876 Mdot
.5 Mabswid
.31295 .40876 m
.30884 .41073 L
s
.31369 .39424 m
.31295 .40876 L
s
.32006 .39184 m
.31295 .40876 L
s
.32285 .39054 m
.31295 .40876 L
s
.01 w
.74071 .40718 Mdot
.5 Mabswid
.74071 .40718 m
.73633 .39293 L
s
.74071 .40718 m
.73455 .39178 L
s
.74071 .40718 m
.74191 .40854 L
s
.01 w
.42589 .32423 Mdot
.5 Mabswid
.42589 .32423 m
.40348 .31476 L
s
.42589 .32423 m
.40464 .32173 L
s
.42827 .33164 m
.42589 .32423 L
s
.01 w
.30884 .41073 Mdot
.5 Mabswid
.30884 .41073 m
.30363 .41326 L
s
.30702 .39663 m
.30884 .41073 L
s
.31369 .39424 m
.30884 .41073 L
s
.32006 .39184 m
.30884 .41073 L
s
.01 w
.74191 .40854 Mdot
.5 Mabswid
.74191 .40854 m
.74039 .39487 L
s
.74191 .40854 m
.73633 .39293 L
s
.74191 .40854 m
.73455 .39178 L
s
.74191 .40854 m
.7452 .41034 L
s
.01 w
.62049 .33287 Mdot
.5 Mabswid
.62049 .33287 m
.64458 .33472 L
s
.62049 .33287 m
.63648 .3286 L
s
.61766 .33033 m
.62049 .33287 L
s
.01 w
.61494 .31208 Mdot
.5 Mabswid
.61494 .31208 m
.63055 .30427 L
s
.61494 .31208 m
.63642 .30658 L
s
.61589 .3174 m
.61494 .31208 L
s
.01 w
.42827 .33164 Mdot
.5 Mabswid
.42827 .33164 m
.40478 .3371 L
s
.42827 .33164 m
.41827 .32769 L
s
.42827 .33164 m
.436 .32987 L
s
.42827 .33164 m
.40464 .32173 L
s
.42827 .33164 m
.41172 .32965 L
s
.01 w
.30363 .41326 Mdot
.5 Mabswid
.30363 .41326 m
.29825 .41592 L
s
.3006 .39895 m
.30363 .41326 L
s
.30702 .39663 m
.30363 .41326 L
s
.31369 .39424 m
.30363 .41326 L
s
.01 w
.7452 .41034 Mdot
.5 Mabswid
.7452 .41034 m
.74576 .39706 L
s
.7452 .41034 m
.74039 .39487 L
s
.7452 .41034 m
.73633 .39293 L
s
.7452 .41034 m
.7495 .41262 L
s
.01 w
.61766 .33033 Mdot
.5 Mabswid
.61766 .33033 m
.64458 .33472 L
s
.61766 .33033 m
.63648 .3286 L
s
.62878 .32174 m
.61766 .33033 L
s
.61369 .32485 m
.61766 .33033 L
s
.01 w
.29825 .41592 Mdot
.5 Mabswid
.29825 .41592 m
.29369 .40897 L
s
.29825 .41592 m
.29519 .41745 L
s
.29758 .40087 m
.29825 .41592 L
s
.3006 .39895 m
.29825 .41592 L
s
.30702 .39663 m
.29825 .41592 L
s
.01 w
.7495 .41262 Mdot
.5 Mabswid
.7495 .41262 m
.7512 .39967 L
s
.7495 .41262 m
.74576 .39706 L
s
.7495 .41262 m
.74039 .39487 L
s
.7495 .41262 m
.75433 .4158 L
s
.01 w
.436 .32987 Mdot
.5 Mabswid
.436 .32987 m
.42528 .3245 L
s
.436 .32987 m
.41827 .32769 L
s
.436 .32987 m
.43931 .32866 L
s
.41172 .32965 m
.436 .32987 L
s
.01 w
.75433 .4158 Mdot
.5 Mabswid
.75433 .4158 m
.75748 .41067 L
s
.75433 .4158 m
.7543 .40086 L
s
.75433 .4158 m
.7512 .39967 L
s
.75433 .4158 m
.74576 .39706 L
s
.75433 .4158 m
.75745 .41669 L
s
.01 w
.29519 .41745 Mdot
.5 Mabswid
.29519 .41745 m
.29273 .41847 L
s
.29517 .40202 m
.29519 .41745 L
s
.29758 .40087 m
.29519 .41745 L
s
.3006 .39895 m
.29519 .41745 L
s
.01 w
.61589 .3174 Mdot
.5 Mabswid
.61589 .3174 m
.63642 .30658 L
s
.61589 .3174 m
.63531 .31349 L
s
.61369 .32485 m
.61589 .3174 L
s
.01 w
.29273 .41847 Mdot
.5 Mabswid
.29517 .40202 m
.29273 .41847 L
s
.29758 .40087 m
.29273 .41847 L
s
.01 w
.40985 .31197 Mdot
.5 Mabswid
.40985 .31197 m
.38387 .30733 L
s
.40348 .31476 m
.40985 .31197 L
s
.01 w
.43931 .32866 Mdot
.5 Mabswid
.43931 .32866 m
.42528 .3245 L
s
.43931 .32866 m
.41827 .32769 L
s
.01 w
.39757 .34384 Mdot
.5 Mabswid
.39757 .34384 m
.36639 .35493 L
s
.39757 .34384 m
.37849 .34543 L
s
.40478 .3371 m
.39757 .34384 L
s
.01 w
.61369 .32485 Mdot
.5 Mabswid
.61369 .32485 m
.62143 .32021 L
s
.61369 .32485 m
.60552 .32362 L
s
.61369 .32485 m
.63648 .3286 L
s
.61369 .32485 m
.63531 .31349 L
s
.61369 .32485 m
.62878 .32174 L
s
.01 w
.75745 .41669 Mdot
.5 Mabswid
.75745 .41669 m
.75683 .40172 L
s
.75745 .41669 m
.7543 .40086 L
s
.75745 .41669 m
.7512 .39967 L
s
.75745 .41669 m
.76002 .41781 L
s
.01 w
.76002 .41781 Mdot
.5 Mabswid
.76002 .41781 m
.75683 .40172 L
s
.76002 .41781 m
.7543 .40086 L
s
.01 w
.32285 .39054 Mdot
.5 Mabswid
.32285 .39054 m
.32006 .39184 L
s
.32976 .37523 m
.32285 .39054 L
s
.33892 .37162 m
.32285 .39054 L
s
.01 w
.60552 .32362 Mdot
.5 Mabswid
.60552 .32362 m
.61361 .31756 L
s
.60552 .32362 m
.62143 .32021 L
s
.60552 .32362 m
.60194 .32263 L
s
.62878 .32174 m
.60552 .32362 L
s
.01 w
.32006 .39184 Mdot
.5 Mabswid
.32006 .39184 m
.31369 .39424 L
s
.32129 .37778 m
.32006 .39184 L
s
.32976 .37523 m
.32006 .39184 L
s
.33892 .37162 m
.32006 .39184 L
s
.01 w
.40478 .3371 Mdot
.5 Mabswid
.40478 .3371 m
.37849 .34543 L
s
.40478 .3371 m
.38521 .33821 L
s
.39383 .33135 m
.40478 .3371 L
s
.41172 .32965 m
.40478 .3371 L
s
.01 w
.75748 .41067 Mdot
.5 Mabswid
.75434 .39241 m
.75748 .41067 L
s
.7512 .39967 m
.75748 .41067 L
s
.01 w
.60194 .32263 Mdot
.5 Mabswid
.60194 .32263 m
.61361 .31756 L
s
.60194 .32263 m
.62143 .32021 L
s
.01 w
.29369 .40897 Mdot
.5 Mabswid
.29555 .39058 m
.29369 .40897 L
s
.3006 .39895 m
.29369 .40897 L
s
.01 w
.73455 .39178 Mdot
.5 Mabswid
.73455 .39178 m
.72633 .37679 L
s
.73455 .39178 m
.72356 .37559 L
s
.73455 .39178 m
.73633 .39293 L
s
.01 w
.63055 .30427 Mdot
.5 Mabswid
.63055 .30427 m
.65451 .29799 L
s
.63642 .30658 m
.63055 .30427 L
s
.01 w
.40348 .31476 Mdot
.5 Mabswid
.40348 .31476 m
.38387 .30733 L
s
.40348 .31476 m
.37818 .31211 L
s
.40464 .32173 m
.40348 .31476 L
s
.01 w
.31369 .39424 Mdot
.5 Mabswid
.31369 .39424 m
.30702 .39663 L
s
.31254 .37961 m
.31369 .39424 L
s
.32129 .37778 m
.31369 .39424 L
s
.32976 .37523 m
.31369 .39424 L
s
.01 w
.73633 .39293 Mdot
.5 Mabswid
.73633 .39293 m
.73269 .37884 L
s
.73633 .39293 m
.72633 .37679 L
s
.73633 .39293 m
.72356 .37559 L
s
.73633 .39293 m
.74039 .39487 L
s
.01 w
.41172 .32965 Mdot
.5 Mabswid
.41172 .32965 m
.41827 .32769 L
s
.41172 .32965 m
.38793 .32311 L
s
.41172 .32965 m
.39383 .33135 L
s
.41172 .32965 m
.40464 .32173 L
s
.01 w
.64458 .33472 Mdot
.5 Mabswid
.64458 .33472 m
.67577 .3435 L
s
.64458 .33472 m
.66256 .33499 L
s
.63648 .3286 m
.64458 .33472 L
s
.01 w
.40464 .32173 Mdot
.5 Mabswid
.40464 .32173 m
.37818 .31211 L
s
.40464 .32173 m
.38793 .32311 L
s
.01 w
.74039 .39487 Mdot
.5 Mabswid
.74039 .39487 m
.73934 .38091 L
s
.74039 .39487 m
.73269 .37884 L
s
.74039 .39487 m
.72633 .37679 L
s
.74039 .39487 m
.74576 .39706 L
s
.01 w
.36639 .35493 Mdot
.5 Mabswid
.37849 .34543 m
.36639 .35493 L
s
.33892 .37162 m
.36639 .35493 L
s
.35289 .35643 m
.36639 .35493 L
s
.01 w
.30702 .39663 Mdot
.5 Mabswid
.30702 .39663 m
.3006 .39895 L
s
.3049 .38171 m
.30702 .39663 L
s
.31254 .37961 m
.30702 .39663 L
s
.32129 .37778 m
.30702 .39663 L
s
.01 w
.63648 .3286 Mdot
.5 Mabswid
.63648 .3286 m
.66256 .33499 L
s
.63648 .3286 m
.65486 .32833 L
s
.64519 .32219 m
.63648 .3286 L
s
.62878 .32174 m
.63648 .3286 L
s
.01 w
.74576 .39706 Mdot
.5 Mabswid
.74576 .39706 m
.74575 .38287 L
s
.74576 .39706 m
.73934 .38091 L
s
.74576 .39706 m
.73269 .37884 L
s
.74576 .39706 m
.7512 .39967 L
s
.01 w
.33892 .37162 Mdot
.5 Mabswid
.33892 .37162 m
.32976 .37523 L
s
.34153 .35931 m
.33892 .37162 L
s
.35289 .35643 m
.33892 .37162 L
s
.01 w
.37849 .34543 Mdot
.5 Mabswid
.38521 .33821 m
.37849 .34543 L
s
.35289 .35643 m
.37849 .34543 L
s
.36746 .34235 m
.37849 .34543 L
s
.01 w
.3006 .39895 Mdot
.5 Mabswid
.3006 .39895 m
.29555 .39058 L
s
.3006 .39895 m
.29758 .40087 L
s
.30208 .38392 m
.3006 .39895 L
s
.3049 .38171 m
.3006 .39895 L
s
.31254 .37961 m
.3006 .39895 L
s
.01 w
.63642 .30658 Mdot
.5 Mabswid
.63642 .30658 m
.65451 .29799 L
s
.63642 .30658 m
.65976 .30233 L
s
.63531 .31349 m
.63642 .30658 L
s
.01 w
.41827 .32769 Mdot
.5 Mabswid
.41827 .32769 m
.41059 .32286 L
s
.41827 .32769 m
.40301 .32567 L
s
.41827 .32769 m
.42528 .3245 L
s
.39383 .33135 m
.41827 .32769 L
s
.01 w
.7512 .39967 Mdot
.5 Mabswid
.7512 .39967 m
.75434 .39241 L
s
.7512 .39967 m
.74882 .38464 L
s
.7512 .39967 m
.74575 .38287 L
s
.7512 .39967 m
.73934 .38091 L
s
.7512 .39967 m
.7543 .40086 L
s
.01 w
.62878 .32174 Mdot
.5 Mabswid
.62878 .32174 m
.62143 .32021 L
s
.62878 .32174 m
.65058 .31367 L
s
.62878 .32174 m
.64519 .32219 L
s
.62878 .32174 m
.63531 .31349 L
s
.01 w
.29758 .40087 Mdot
.5 Mabswid
.29758 .40087 m
.29517 .40202 L
s
.30011 .38582 m
.29758 .40087 L
s
.30208 .38392 m
.29758 .40087 L
s
.3049 .38171 m
.29758 .40087 L
s
.01 w
.32976 .37523 Mdot
.5 Mabswid
.32976 .37523 m
.32129 .37778 L
s
.33071 .36175 m
.32976 .37523 L
s
.34153 .35931 m
.32976 .37523 L
s
.35289 .35643 m
.32976 .37523 L
s
.01 w
.29517 .40202 Mdot
.5 Mabswid
.30011 .38582 m
.29517 .40202 L
s
.30208 .38392 m
.29517 .40202 L
s
.01 w
.7543 .40086 Mdot
.5 Mabswid
.7543 .40086 m
.75122 .38566 L
s
.7543 .40086 m
.74882 .38464 L
s
.7543 .40086 m
.74575 .38287 L
s
.7543 .40086 m
.75683 .40172 L
s
.01 w
.63531 .31349 Mdot
.5 Mabswid
.63531 .31349 m
.65976 .30233 L
s
.63531 .31349 m
.65058 .31367 L
s
.01 w
.38521 .33821 Mdot
.5 Mabswid
.39383 .33135 m
.38521 .33821 L
s
.36746 .34235 m
.38521 .33821 L
s
.01 w
.72356 .37559 Mdot
.5 Mabswid
.72356 .37559 m
.71389 .36106 L
s
.72356 .37559 m
.70466 .35808 L
s
.72356 .37559 m
.72633 .37679 L
s
.01 w
.75683 .40172 Mdot
.5 Mabswid
.75683 .40172 m
.75122 .38566 L
s
.75683 .40172 m
.74882 .38464 L
s
.01 w
.72633 .37679 Mdot
.5 Mabswid
.72633 .37679 m
.72227 .36312 L
s
.72633 .37679 m
.71389 .36106 L
s
.72633 .37679 m
.70466 .35808 L
s
.72633 .37679 m
.73269 .37884 L
s
.01 w
.38387 .30733 Mdot
.5 Mabswid
.38387 .30733 m
.35321 .30086 L
s
.37818 .31211 m
.38387 .30733 L
s
.01 w
.35289 .35643 Mdot
.5 Mabswid
.35289 .35643 m
.34153 .35931 L
s
.35304 .34502 m
.35289 .35643 L
s
.36746 .34235 m
.35289 .35643 L
s
.01 w
.42528 .3245 Mdot
.5 Mabswid
.42528 .3245 m
.41767 .31892 L
s
.42528 .3245 m
.41059 .32286 L
s
.01 w
.62143 .32021 Mdot
.5 Mabswid
.62143 .32021 m
.62658 .31492 L
s
.62143 .32021 m
.63488 .31706 L
s
.62143 .32021 m
.61361 .31756 L
s
.64519 .32219 m
.62143 .32021 L
s
.01 w
.67577 .3435 Mdot
.5 Mabswid
.66256 .33499 m
.67577 .3435 L
s
.68856 .34407 m
.67577 .3435 L
s
.70466 .35808 m
.67577 .3435 L
s
.01 w
.32129 .37778 Mdot
.5 Mabswid
.32129 .37778 m
.31254 .37961 L
s
.32053 .36382 m
.32129 .37778 L
s
.33071 .36175 m
.32129 .37778 L
s
.34153 .35931 m
.32129 .37778 L
s
.01 w
.66256 .33499 Mdot
.5 Mabswid
.65486 .32833 m
.66256 .33499 L
s
.67208 .33123 m
.66256 .33499 L
s
.68856 .34407 m
.66256 .33499 L
s
.01 w
.73269 .37884 Mdot
.5 Mabswid
.73269 .37884 m
.73081 .36446 L
s
.73269 .37884 m
.72227 .36312 L
s
.73269 .37884 m
.71389 .36106 L
s
.73269 .37884 m
.73934 .38091 L
s
.01 w
.75434 .39241 Mdot
.5 Mabswid
.74919 .37444 m
.75434 .39241 L
s
.74575 .38287 m
.75434 .39241 L
s
.01 w
.29555 .39058 Mdot
.5 Mabswid
.29806 .37154 m
.29555 .39058 L
s
.3049 .38171 m
.29555 .39058 L
s
.01 w
.39383 .33135 Mdot
.5 Mabswid
.39383 .33135 m
.40301 .32567 L
s
.39383 .33135 m
.37574 .33032 L
s
.39383 .33135 m
.38793 .32311 L
s
.36746 .34235 m
.39383 .33135 L
s
.39172 .32518 m
.39383 .33135 L
s
.01 w
.38793 .32311 Mdot
.5 Mabswid
.38793 .32311 m
.36508 .318 L
s
.38793 .32311 m
.37574 .33032 L
s
.38793 .32311 m
.37818 .31211 L
s
.01 w
.70466 .35808 Mdot
.5 Mabswid
.70466 .35808 m
.69961 .3462 L
s
.70466 .35808 m
.68856 .34407 L
s
.70466 .35808 m
.71389 .36106 L
s
.01 w
.31254 .37961 Mdot
.5 Mabswid
.31254 .37961 m
.3049 .38171 L
s
.30992 .36264 m
.31254 .37961 L
s
.32053 .36382 m
.31254 .37961 L
s
.33071 .36175 m
.31254 .37961 L
s
.01 w
.65486 .32833 Mdot
.5 Mabswid
.64519 .32219 m
.65486 .32833 L
s
.67208 .33123 m
.65486 .32833 L
s
.01 w
.61361 .31756 Mdot
.5 Mabswid
.61361 .31756 m
.61814 .31158 L
s
.61361 .31756 m
.62658 .31492 L
s
.01 w
.37818 .31211 Mdot
.5 Mabswid
.37818 .31211 m
.35321 .30086 L
s
.37818 .31211 m
.35335 .30682 L
s
.37818 .31211 m
.36508 .318 L
s
.01 w
.73934 .38091 Mdot
.5 Mabswid
.73934 .38091 m
.73837 .36614 L
s
.73934 .38091 m
.73081 .36446 L
s
.73934 .38091 m
.72227 .36312 L
s
.73934 .38091 m
.74575 .38287 L
s
.01 w
.34153 .35931 Mdot
.5 Mabswid
.34153 .35931 m
.33071 .36175 L
s
.34197 .34666 m
.34153 .35931 L
s
.35304 .34502 m
.34153 .35931 L
s
.36746 .34235 m
.34153 .35931 L
s
.01 w
.65451 .29799 Mdot
.5 Mabswid
.65451 .29799 m
.68312 .28979 L
s
.65976 .30233 m
.65451 .29799 L
s
.01 w
.36746 .34235 Mdot
.5 Mabswid
.36746 .34235 m
.36552 .33175 L
s
.36746 .34235 m
.37574 .33032 L
s
.36746 .34235 m
.35304 .34502 L
s
.01 w
.3049 .38171 Mdot
.5 Mabswid
.3049 .38171 m
.29806 .37154 L
s
.3049 .38171 m
.30208 .38392 L
s
.30901 .36847 m
.3049 .38171 L
s
.30992 .36264 m
.3049 .38171 L
s
.32053 .36382 m
.3049 .38171 L
s
.01 w
.71389 .36106 Mdot
.5 Mabswid
.71389 .36106 m
.71015 .34794 L
s
.71389 .36106 m
.69961 .3462 L
s
.71389 .36106 m
.68856 .34407 L
s
.71389 .36106 m
.72227 .36312 L
s
.01 w
.40301 .32567 Mdot
.5 Mabswid
.40301 .32567 m
.41059 .32286 L
s
.39172 .32518 m
.40301 .32567 L
s
.01 w
.74575 .38287 Mdot
.5 Mabswid
.74575 .38287 m
.74919 .37444 L
s
.74575 .38287 m
.74123 .36823 L
s
.74575 .38287 m
.73837 .36614 L
s
.74575 .38287 m
.73081 .36446 L
s
.74575 .38287 m
.74882 .38464 L
s
.01 w
.64519 .32219 Mdot
.5 Mabswid
.64519 .32219 m
.63488 .31706 L
s
.64519 .32219 m
.66189 .31998 L
s
.64519 .32219 m
.65058 .31367 L
s
.6447 .31607 m
.64519 .32219 L
s
.67208 .33123 m
.64519 .32219 L
s
.01 w
.30208 .38392 Mdot
.5 Mabswid
.30208 .38392 m
.30011 .38582 L
s
.30778 .3696 m
.30208 .38392 L
s
.30901 .36847 m
.30208 .38392 L
s
.30992 .36264 m
.30208 .38392 L
s
.01 w
.68856 .34407 Mdot
.5 Mabswid
.68856 .34407 m
.68592 .33291 L
s
.68856 .34407 m
.67208 .33123 L
s
.68856 .34407 m
.69961 .3462 L
s
.01 w
.74882 .38464 Mdot
.5 Mabswid
.74882 .38464 m
.74327 .37009 L
s
.74882 .38464 m
.74123 .36823 L
s
.74882 .38464 m
.73837 .36614 L
s
.74882 .38464 m
.75122 .38566 L
s
.01 w
.65058 .31367 Mdot
.5 Mabswid
.65058 .31367 m
.67179 .30726 L
s
.65058 .31367 m
.66189 .31998 L
s
.65058 .31367 m
.65976 .30233 L
s
.01 w
.30011 .38582 Mdot
.5 Mabswid
.30778 .3696 m
.30011 .38582 L
s
.30901 .36847 m
.30011 .38582 L
s
.01 w
.33071 .36175 Mdot
.5 Mabswid
.33071 .36175 m
.32053 .36382 L
s
.33105 .34761 m
.33071 .36175 L
s
.34197 .34666 m
.33071 .36175 L
s
.35304 .34502 m
.33071 .36175 L
s
.01 w
.75122 .38566 Mdot
.5 Mabswid
.75122 .38566 m
.74327 .37009 L
s
.75122 .38566 m
.74123 .36823 L
s
.01 w
.65976 .30233 Mdot
.5 Mabswid
.65976 .30233 m
.68312 .28979 L
s
.65976 .30233 m
.68282 .29559 L
s
.65976 .30233 m
.67179 .30726 L
s
.01 w
.72227 .36312 Mdot
.5 Mabswid
.72227 .36312 m
.72007 .3494 L
s
.72227 .36312 m
.71015 .34794 L
s
.72227 .36312 m
.69961 .3462 L
s
.72227 .36312 m
.73081 .36446 L
s
.01 w
.41059 .32286 Mdot
.5 Mabswid
.41059 .32286 m
.41767 .31892 L
s
.39172 .32518 m
.41059 .32286 L
s
.40592 .31906 m
.41059 .32286 L
s
.01 w
.63488 .31706 Mdot
.5 Mabswid
.63488 .31706 m
.62658 .31492 L
s
.6447 .31607 m
.63488 .31706 L
s
.01 w
.35304 .34502 Mdot
.5 Mabswid
.35304 .34502 m
.35454 .33256 L
s
.35304 .34502 m
.36552 .33175 L
s
.35304 .34502 m
.37574 .33032 L
s
.35304 .34502 m
.34197 .34666 L
s
.01 w
.67208 .33123 Mdot
.5 Mabswid
.67208 .33123 m
.67135 .32078 L
s
.67208 .33123 m
.66189 .31998 L
s
.67208 .33123 m
.68592 .33291 L
s
.69961 .3462 m
.67208 .33123 L
s
.01 w
.37574 .33032 Mdot
.5 Mabswid
.37574 .33032 m
.36552 .33175 L
s
.37574 .33032 m
.36508 .318 L
s
.38152 .32477 m
.37574 .33032 L
s
.39172 .32518 m
.37574 .33032 L
s
.01 w
.32053 .36382 Mdot
.5 Mabswid
.32053 .36382 m
.30992 .36264 L
s
.31765 .35154 m
.32053 .36382 L
s
.33105 .34761 m
.32053 .36382 L
s
.34197 .34666 m
.32053 .36382 L
s
.01 w
.69961 .3462 Mdot
.5 Mabswid
.69961 .3462 m
.69644 .33383 L
s
.69961 .3462 m
.68592 .33291 L
s
.69961 .3462 m
.71015 .34794 L
s
.01 w
.74919 .37444 Mdot
.5 Mabswid
.74337 .35584 m
.74919 .37444 L
s
.73837 .36614 m
.74919 .37444 L
s
.01 w
.36508 .318 Mdot
.5 Mabswid
.36508 .318 m
.34308 .31051 L
s
.36508 .318 m
.35242 .32105 L
s
.36508 .318 m
.36552 .33175 L
s
.36508 .318 m
.35335 .30682 L
s
.01 w
.73081 .36446 Mdot
.5 Mabswid
.73081 .36446 m
.72994 .34773 L
s
.73081 .36446 m
.72007 .3494 L
s
.73081 .36446 m
.71015 .34794 L
s
.73081 .36446 m
.73837 .36614 L
s
.01 w
.29806 .37154 Mdot
.5 Mabswid
.29767 .35128 m
.29806 .37154 L
s
.30992 .36264 m
.29806 .37154 L
s
.01 w
.35321 .30086 Mdot
.5 Mabswid
.35321 .30086 m
.32983 .2986 L
s
.35321 .30086 m
.32226 .28972 L
s
.35335 .30682 m
.35321 .30086 L
s
.01 w
.62658 .31492 Mdot
.5 Mabswid
.62658 .31492 m
.61814 .31158 L
s
.62869 .31105 m
.62658 .31492 L
s
.6447 .31607 m
.62658 .31492 L
s
.01 w
.35335 .30682 Mdot
.5 Mabswid
.35335 .30682 m
.32983 .2986 L
s
.35335 .30682 m
.34308 .31051 L
s
.01 w
.34197 .34666 Mdot
.5 Mabswid
.34197 .34666 m
.34499 .33162 L
s
.34197 .34666 m
.35454 .33256 L
s
.34197 .34666 m
.36552 .33175 L
s
.34197 .34666 m
.33105 .34761 L
s
.01 w
.73837 .36614 Mdot
.5 Mabswid
.73837 .36614 m
.74337 .35584 L
s
.73837 .36614 m
.73139 .35346 L
s
.73837 .36614 m
.72994 .34773 L
s
.73837 .36614 m
.72007 .3494 L
s
.73837 .36614 m
.74123 .36823 L
s
.01 w
.39172 .32518 Mdot
.5 Mabswid
.39172 .32518 m
.36552 .33175 L
s
.39172 .32518 m
.38152 .32477 L
s
.39897 .31871 m
.39172 .32518 L
s
.40592 .31906 m
.39172 .32518 L
s
.01 w
.71015 .34794 Mdot
.5 Mabswid
.71015 .34794 m
.70677 .3342 L
s
.71015 .34794 m
.69644 .33383 L
s
.71015 .34794 m
.68592 .33291 L
s
.71015 .34794 m
.72007 .3494 L
s
.01 w
.41767 .31892 Mdot
.5 Mabswid
.40592 .31906 m
.41767 .31892 L
s
.42138 .31372 m
.41767 .31892 L
s
.01 w
.30901 .36847 Mdot
.5 Mabswid
.30901 .36847 m
.30778 .3696 L
s
.30992 .36264 m
.30901 .36847 L
s
.31791 .3547 m
.30901 .36847 L
s
.31907 .3522 m
.30901 .36847 L
s
.31765 .35154 m
.30901 .36847 L
s
.01 w
.66189 .31998 Mdot
.5 Mabswid
.66189 .31998 m
.67135 .32078 L
s
.66189 .31998 m
.67179 .30726 L
s
.65364 .31512 m
.66189 .31998 L
s
.6447 .31607 m
.66189 .31998 L
s
.68592 .33291 m
.66189 .31998 L
s
.01 w
.30992 .36264 Mdot
.5 Mabswid
.30992 .36264 m
.30715 .33915 L
s
.30992 .36264 m
.29767 .35128 L
s
.31907 .3522 m
.30992 .36264 L
s
.31765 .35154 m
.30992 .36264 L
s
.33105 .34761 m
.30992 .36264 L
s
.01 w
.36552 .33175 Mdot
.5 Mabswid
.36552 .33175 m
.35454 .33256 L
s
.36552 .33175 m
.35242 .32105 L
s
.3727 .32474 m
.36552 .33175 L
s
.38152 .32477 m
.36552 .33175 L
s
.01 w
.74123 .36823 Mdot
.5 Mabswid
.74123 .36823 m
.73256 .35472 L
s
.74123 .36823 m
.73139 .35346 L
s
.74123 .36823 m
.72994 .34773 L
s
.74123 .36823 m
.74327 .37009 L
s
.01 w
.68592 .33291 Mdot
.5 Mabswid
.68592 .33291 m
.6815 .32095 L
s
.68592 .33291 m
.67135 .32078 L
s
.68592 .33291 m
.69644 .33383 L
s
.01 w
.30778 .3696 Mdot
.5 Mabswid
.31791 .3547 m
.30778 .3696 L
s
.31907 .3522 m
.30778 .3696 L
s
.01 w
.74327 .37009 Mdot
.5 Mabswid
.74327 .37009 m
.73256 .35472 L
s
.74327 .37009 m
.73139 .35346 L
s
.01 w
.67179 .30726 Mdot
.5 Mabswid
.67179 .30726 m
.69226 .29863 L
s
.67179 .30726 m
.68343 .30955 L
s
.67179 .30726 m
.67135 .32078 L
s
.67179 .30726 m
.68282 .29559 L
s
.01 w
.68312 .28979 Mdot
.5 Mabswid
.68312 .28979 m
.7049 .2862 L
s
.68312 .28979 m
.71228 .27709 L
s
.68282 .29559 m
.68312 .28979 L
s
.01 w
.61814 .31158 Mdot
.5 Mabswid
.61146 .30695 m
.61814 .31158 L
s
.62869 .31105 m
.61814 .31158 L
s
.01 w
.35242 .32105 Mdot
.5 Mabswid
.35242 .32105 m
.33894 .31951 L
s
.35242 .32105 m
.35454 .33256 L
s
.35242 .32105 m
.34308 .31051 L
s
.01 w
.33105 .34761 Mdot
.5 Mabswid
.33105 .34761 m
.33251 .33289 L
s
.33105 .34761 m
.34499 .33162 L
s
.33105 .34761 m
.35454 .33256 L
s
.33105 .34761 m
.31765 .35154 L
s
.01 w
.72007 .3494 Mdot
.5 Mabswid
.72007 .3494 m
.72019 .33728 L
s
.72007 .3494 m
.70677 .3342 L
s
.72007 .3494 m
.69644 .33383 L
s
.72007 .3494 m
.72994 .34773 L
s
.01 w
.6447 .31607 Mdot
.5 Mabswid
.6447 .31607 m
.67135 .32078 L
s
.6447 .31607 m
.63456 .31042 L
s
.6447 .31607 m
.62869 .31105 L
s
.6447 .31607 m
.65364 .31512 L
s
.01 w
.68282 .29559 Mdot
.5 Mabswid
.68282 .29559 m
.7049 .2862 L
s
.68282 .29559 m
.69226 .29863 L
s
.01 w
.34308 .31051 Mdot
.5 Mabswid
.34308 .31051 m
.32384 .3074 L
s
.34308 .31051 m
.33894 .31951 L
s
.34308 .31051 m
.32983 .2986 L
s
.01 w
.74337 .35584 Mdot
.5 Mabswid
.7404 .33603 m
.74337 .35584 L
s
.72994 .34773 m
.74337 .35584 L
s
.01 w
.35454 .33256 Mdot
.5 Mabswid
.35454 .33256 m
.34499 .33162 L
s
.35454 .33256 m
.33894 .31951 L
s
.36338 .32452 m
.35454 .33256 L
s
.3727 .32474 m
.35454 .33256 L
s
.38152 .32477 m
.35454 .33256 L
s
.01 w
.69644 .33383 Mdot
.5 Mabswid
.69644 .33383 m
.69031 .31943 L
s
.69644 .33383 m
.6815 .32095 L
s
.69644 .33383 m
.67135 .32078 L
s
.69644 .33383 m
.70677 .3342 L
s
.01 w
.67135 .32078 Mdot
.5 Mabswid
.67135 .32078 m
.6815 .32095 L
s
.67135 .32078 m
.68343 .30955 L
s
.66153 .31465 m
.67135 .32078 L
s
.65364 .31512 m
.67135 .32078 L
s
.01 w
.31765 .35154 Mdot
.5 Mabswid
.31765 .35154 m
.30715 .33915 L
s
.31765 .35154 m
.33251 .33289 L
s
.31765 .35154 m
.31907 .3522 L
s
.01 w
.38152 .32477 Mdot
.5 Mabswid
.38152 .32477 m
.3727 .32474 L
s
.39203 .31833 m
.38152 .32477 L
s
.39897 .31871 m
.38152 .32477 L
s
.40592 .31906 m
.38152 .32477 L
s
.01 w
.40592 .31906 Mdot
.5 Mabswid
.40592 .31906 m
.39897 .31871 L
s
.41812 .31312 m
.40592 .31906 L
s
.42138 .31372 m
.40592 .31906 L
s
.01 w
.29767 .35128 Mdot
.5 Mabswid
.29767 .35128 m
.30715 .33915 L
s
.29 .33078 m
.29767 .35128 L
s
.01 w
.32983 .2986 Mdot
.5 Mabswid
.32983 .2986 m
.30798 .29617 L
s
.32983 .2986 m
.32384 .3074 L
s
.32983 .2986 m
.30545 .28707 L
s
.32226 .28972 m
.32983 .2986 L
s
.01 w
.72994 .34773 Mdot
.5 Mabswid
.72994 .34773 m
.72873 .32462 L
s
.72994 .34773 m
.7404 .33603 L
s
.72994 .34773 m
.71822 .33812 L
s
.72994 .34773 m
.72019 .33728 L
s
.72994 .34773 m
.70677 .3342 L
s
.72994 .34773 m
.73139 .35346 L
s
.01 w
.73139 .35346 Mdot
.5 Mabswid
.73139 .35346 m
.71943 .34055 L
s
.73139 .35346 m
.71822 .33812 L
s
.73139 .35346 m
.72019 .33728 L
s
.73139 .35346 m
.73256 .35472 L
s
.01 w
.32226 .28972 Mdot
.5 Mabswid
.32226 .28972 m
.30545 .28707 L
s
.32226 .28972 m
.29697 .27947 L
s
.01 w
.68343 .30955 Mdot
.5 Mabswid
.68343 .30955 m
.69594 .30716 L
s
.68343 .30955 m
.6815 .32095 L
s
.68343 .30955 m
.69226 .29863 L
s
.01 w
.33894 .31951 Mdot
.5 Mabswid
.33894 .31951 m
.32529 .31951 L
s
.33894 .31951 m
.34499 .33162 L
s
.33894 .31951 m
.32384 .3074 L
s
.01 w
.31907 .3522 Mdot
.5 Mabswid
.31907 .3522 m
.33206 .34032 L
s
.31907 .3522 m
.32994 .33832 L
s
.31907 .3522 m
.33251 .33289 L
s
.31907 .3522 m
.31791 .3547 L
s
.01 w
.73256 .35472 Mdot
.5 Mabswid
.73256 .35472 m
.71943 .34055 L
s
.73256 .35472 m
.71822 .33812 L
s
.01 w
.34499 .33162 Mdot
.5 Mabswid
.34499 .33162 m
.33251 .33289 L
s
.34499 .33162 m
.32529 .31951 L
s
.36338 .32452 m
.34499 .33162 L
s
.3727 .32474 m
.34499 .33162 L
s
.01 w
.31791 .3547 Mdot
.5 Mabswid
.31791 .3547 m
.33206 .34032 L
s
.31791 .3547 m
.32994 .33832 L
s
.01 w
.62869 .31105 Mdot
.5 Mabswid
.62869 .31105 m
.61379 .30621 L
s
.62869 .31105 m
.61146 .30695 L
s
.62869 .31105 m
.63456 .31042 L
s
.65364 .31512 m
.62869 .31105 L
s
.01 w
.69226 .29863 Mdot
.5 Mabswid
.69226 .29863 m
.7102 .29445 L
s
.69226 .29863 m
.69594 .30716 L
s
.69226 .29863 m
.7049 .2862 L
s
.01 w
.70677 .3342 Mdot
.5 Mabswid
.70677 .3342 m
.70188 .32004 L
s
.70677 .3342 m
.69031 .31943 L
s
.70677 .3342 m
.6815 .32095 L
s
.70677 .3342 m
.72019 .33728 L
s
.01 w
.65364 .31512 Mdot
.5 Mabswid
.65364 .31512 m
.6815 .32095 L
s
.65364 .31512 m
.64053 .30965 L
s
.65364 .31512 m
.63456 .31042 L
s
.65364 .31512 m
.66153 .31465 L
s
.01 w
.6815 .32095 Mdot
.5 Mabswid
.6815 .32095 m
.69031 .31943 L
s
.6815 .32095 m
.69594 .30716 L
s
.66994 .3139 m
.6815 .32095 L
s
.66153 .31465 m
.6815 .32095 L
s
.01 w
.3727 .32474 Mdot
.5 Mabswid
.3727 .32474 m
.36338 .32452 L
s
.38573 .31756 m
.3727 .32474 L
s
.39203 .31833 m
.3727 .32474 L
s
.39897 .31871 m
.3727 .32474 L
s
.01 w
.39897 .31871 Mdot
.5 Mabswid
.39897 .31871 m
.39203 .31833 L
s
.41353 .31273 m
.39897 .31871 L
s
.41812 .31312 m
.39897 .31871 L
s
.42138 .31372 m
.39897 .31871 L
s
.01 w
.32384 .3074 Mdot
.5 Mabswid
.32384 .3074 m
.30621 .30749 L
s
.32384 .3074 m
.32529 .31951 L
s
.32384 .3074 m
.30798 .29617 L
s
.01 w
.30715 .33915 Mdot
.5 Mabswid
.29373 .32044 m
.30715 .33915 L
s
.29 .33078 m
.30715 .33915 L
s
.31266 .32112 m
.30715 .33915 L
s
.33251 .33289 m
.30715 .33915 L
s
.01 w
.7049 .2862 Mdot
.5 Mabswid
.7049 .2862 m
.72529 .2826 L
s
.7049 .2862 m
.7102 .29445 L
s
.7049 .2862 m
.72808 .27359 L
s
.71228 .27709 m
.7049 .2862 L
s
.01 w
.72019 .33728 Mdot
.5 Mabswid
.72019 .33728 m
.72873 .32462 L
s
.72019 .33728 m
.70188 .32004 L
s
.72019 .33728 m
.71822 .33812 L
s
.01 w
.42138 .31372 Mdot
.5 Mabswid
.42138 .31372 m
.41812 .31312 L
s
.43941 .30841 m
.42138 .31372 L
s
.44087 .30815 m
.42138 .31372 L
s
.01 w
.71228 .27709 Mdot
.5 Mabswid
.71228 .27709 m
.72808 .27359 L
s
.71228 .27709 m
.73634 .26578 L
s
.01 w
.69594 .30716 Mdot
.5 Mabswid
.69594 .30716 m
.70867 .30638 L
s
.69594 .30716 m
.69031 .31943 L
s
.69594 .30716 m
.7102 .29445 L
s
.01 w
.32529 .31951 Mdot
.5 Mabswid
.32529 .31951 m
.31266 .32112 L
s
.32529 .31951 m
.33251 .33289 L
s
.32529 .31951 m
.30621 .30749 L
s
.01 w
.7404 .33603 Mdot
.5 Mabswid
.7404 .33603 m
.72873 .32462 L
s
.74502 .31561 m
.7404 .33603 L
s
.01 w
.30545 .28707 Mdot
.5 Mabswid
.30545 .28707 m
.28937 .28622 L
s
.30545 .28707 m
.30798 .29617 L
s
.30545 .28707 m
.2844 .27758 L
s
.29697 .27947 m
.30545 .28707 L
s
.01 w
.33251 .33289 Mdot
.5 Mabswid
.33251 .33289 m
.33791 .31711 L
s
.33251 .33289 m
.31452 .32838 L
s
.33251 .33289 m
.32994 .33832 L
s
.33251 .33289 m
.31266 .32112 L
s
.35345 .3276 m
.33251 .33289 L
s
.35919 .32184 m
.33251 .33289 L
s
.36338 .32452 m
.33251 .33289 L
s
.01 w
.69031 .31943 Mdot
.5 Mabswid
.69031 .31943 m
.70188 .32004 L
s
.69031 .31943 m
.70867 .30638 L
s
.66994 .3139 m
.69031 .31943 L
s
.66153 .31465 m
.69031 .31943 L
s
.01 w
.63456 .31042 Mdot
.5 Mabswid
.63456 .31042 m
.61756 .3057 L
s
.63456 .31042 m
.61379 .30621 L
s
.63456 .31042 m
.61146 .30695 L
s
.63456 .31042 m
.64053 .30965 L
s
.66153 .31465 m
.63456 .31042 L
s
.01 w
.66153 .31465 Mdot
.5 Mabswid
.66153 .31465 m
.6459 .3086 L
s
.66153 .31465 m
.64053 .30965 L
s
.66153 .31465 m
.66994 .3139 L
s
.01 w
.36338 .32452 Mdot
.5 Mabswid
.36338 .32452 m
.35919 .32184 L
s
.37516 .31629 m
.36338 .32452 L
s
.38573 .31756 m
.36338 .32452 L
s
.39203 .31833 m
.36338 .32452 L
s
.01 w
.61146 .30695 Mdot
.5 Mabswid
.61146 .30695 m
.5911 .30313 L
s
.61146 .30695 m
.58991 .30286 L
s
.61146 .30695 m
.61379 .30621 L
s
.01 w
.71822 .33812 Mdot
.5 Mabswid
.71822 .33812 m
.70234 .32746 L
s
.71822 .33812 m
.70424 .32529 L
s
.71822 .33812 m
.70188 .32004 L
s
.71822 .33812 m
.71943 .34055 L
s
.01 w
.30798 .29617 Mdot
.5 Mabswid
.30798 .29617 m
.29261 .29573 L
s
.30798 .29617 m
.30621 .30749 L
s
.30798 .29617 m
.28937 .28622 L
s
.01 w
.39203 .31833 Mdot
.5 Mabswid
.39203 .31833 m
.38573 .31756 L
s
.40816 .31213 m
.39203 .31833 L
s
.41353 .31273 m
.39203 .31833 L
s
.41812 .31312 m
.39203 .31833 L
s
.01 w
.29697 .27947 Mdot
.5 Mabswid
.29697 .27947 m
.2844 .27758 L
s
.29697 .27947 m
.2762 .27109 L
s
.01 w
.29 .33078 Mdot
.5 Mabswid
.29 .33078 m
.29373 .32044 L
s
.27667 .31008 m
.29 .33078 L
s
.01 w
.71943 .34055 Mdot
.5 Mabswid
.71943 .34055 m
.70234 .32746 L
s
.71943 .34055 m
.70424 .32529 L
s
.01 w
.33206 .34032 Mdot
.5 Mabswid
.33206 .34032 m
.31723 .33399 L
s
.32994 .33832 m
.33206 .34032 L
s
.35309 .32956 m
.33206 .34032 L
s
.35345 .3276 m
.33206 .34032 L
s
.01 w
.41812 .31312 Mdot
.5 Mabswid
.41812 .31312 m
.41353 .31273 L
s
.43666 .30814 m
.41812 .31312 L
s
.43941 .30841 m
.41812 .31312 L
s
.44087 .30815 m
.41812 .31312 L
s
.01 w
.32994 .33832 Mdot
.5 Mabswid
.32994 .33832 m
.31723 .33399 L
s
.32994 .33832 m
.31452 .32838 L
s
.35309 .32956 m
.32994 .33832 L
s
.35345 .3276 m
.32994 .33832 L
s
.01 w
.7102 .29445 Mdot
.5 Mabswid
.7102 .29445 m
.72661 .29351 L
s
.7102 .29445 m
.70867 .30638 L
s
.7102 .29445 m
.72529 .2826 L
s
.01 w
.72873 .32462 Mdot
.5 Mabswid
.73957 .3056 m
.72873 .32462 L
s
.74502 .31561 m
.72873 .32462 L
s
.7203 .30724 m
.72873 .32462 L
s
.70188 .32004 m
.72873 .32462 L
s
.01 w
.30621 .30749 Mdot
.5 Mabswid
.30621 .30749 m
.28716 .30387 L
s
.30621 .30749 m
.29699 .31201 L
s
.30621 .30749 m
.31266 .32112 L
s
.30621 .30749 m
.29261 .29573 L
s
.01 w
.64053 .30965 Mdot
.5 Mabswid
.64053 .30965 m
.62212 .30487 L
s
.64053 .30965 m
.61756 .3057 L
s
.64053 .30965 m
.61379 .30621 L
s
.64053 .30965 m
.6459 .3086 L
s
.66994 .3139 m
.64053 .30965 L
s
.01 w
.61379 .30621 Mdot
.5 Mabswid
.61379 .30621 m
.59321 .3028 L
s
.61379 .30621 m
.5911 .30313 L
s
.61379 .30621 m
.58991 .30286 L
s
.61379 .30621 m
.61756 .3057 L
s
.01 w
.31266 .32112 Mdot
.5 Mabswid
.31266 .32112 m
.29373 .32044 L
s
.31266 .32112 m
.33791 .31711 L
s
.31266 .32112 m
.30867 .3097 L
s
.31266 .32112 m
.29788 .31853 L
s
.31266 .32112 m
.31452 .32838 L
s
.31266 .32112 m
.29699 .31201 L
s
.01 w
.72808 .27359 Mdot
.5 Mabswid
.72808 .27359 m
.74304 .2719 L
s
.72808 .27359 m
.72529 .2826 L
s
.72808 .27359 m
.74814 .26332 L
s
.73634 .26578 m
.72808 .27359 L
s
.01 w
.66994 .3139 Mdot
.5 Mabswid
.66994 .3139 m
.70188 .32004 L
s
.66994 .3139 m
.65561 .30671 L
s
.66994 .3139 m
.6459 .3086 L
s
.66994 .3139 m
.67278 .31122 L
s
.01 w
.70867 .30638 Mdot
.5 Mabswid
.70867 .30638 m
.7203 .30724 L
s
.70867 .30638 m
.70188 .32004 L
s
.70867 .30638 m
.72661 .29351 L
s
.01 w
.38573 .31756 Mdot
.5 Mabswid
.38573 .31756 m
.35919 .32184 L
s
.38573 .31756 m
.37516 .31629 L
s
.40426 .31154 m
.38573 .31756 L
s
.40816 .31213 m
.38573 .31756 L
s
.41353 .31273 m
.38573 .31756 L
s
.01 w
.29373 .32044 Mdot
.5 Mabswid
.27667 .31008 m
.29373 .32044 L
s
.28716 .30387 m
.29373 .32044 L
s
.29699 .31201 m
.29373 .32044 L
s
.01 w
.44087 .30815 Mdot
.5 Mabswid
.44087 .30815 m
.43941 .30841 L
s
.46298 .30445 m
.44087 .30815 L
s
.46375 .30402 m
.44087 .30815 L
s
.01 w
.70188 .32004 Mdot
.5 Mabswid
.70188 .32004 m
.69364 .30499 L
s
.70188 .32004 m
.71839 .31445 L
s
.70188 .32004 m
.70424 .32529 L
s
.70188 .32004 m
.7203 .30724 L
s
.67883 .31656 m
.70188 .32004 L
s
.67278 .31122 m
.70188 .32004 L
s
.01 w
.41353 .31273 Mdot
.5 Mabswid
.41353 .31273 m
.40816 .31213 L
s
.43383 .30777 m
.41353 .31273 L
s
.43666 .30814 m
.41353 .31273 L
s
.43941 .30841 m
.41353 .31273 L
s
.01 w
.2844 .27758 Mdot
.5 Mabswid
.2844 .27758 m
.2718 .27814 L
s
.2844 .27758 m
.28937 .28622 L
s
.2844 .27758 m
.26799 .2705 L
s
.2762 .27109 m
.2844 .27758 L
s
.01 w
.28937 .28622 Mdot
.5 Mabswid
.28937 .28622 m
.2772 .28907 L
s
.28937 .28622 m
.29261 .29573 L
s
.28937 .28622 m
.2718 .27814 L
s
.01 w
.35919 .32184 Mdot
.5 Mabswid
.35919 .32184 m
.33791 .31711 L
s
.35919 .32184 m
.35345 .3276 L
s
.3784 .31918 m
.35919 .32184 L
s
.37516 .31629 m
.35919 .32184 L
s
.01 w
.31452 .32838 Mdot
.5 Mabswid
.31452 .32838 m
.30162 .32506 L
s
.31452 .32838 m
.31723 .33399 L
s
.31452 .32838 m
.29788 .31853 L
s
.01 w
.31723 .33399 Mdot
.5 Mabswid
.31723 .33399 m
.30162 .32506 L
s
.01 w
.35345 .3276 Mdot
.5 Mabswid
.35345 .3276 m
.35309 .32956 L
s
.37683 .32059 m
.35345 .3276 L
s
.3784 .31918 m
.35345 .3276 L
s
.37516 .31629 m
.35345 .3276 L
s
.01 w
.72529 .2826 Mdot
.5 Mabswid
.72529 .2826 m
.73964 .28125 L
s
.72529 .2826 m
.72661 .29351 L
s
.72529 .2826 m
.74304 .2719 L
s
.01 w
.73634 .26578 Mdot
.5 Mabswid
.73634 .26578 m
.74814 .26332 L
s
.73634 .26578 m
.75618 .25673 L
s
.01 w
.29261 .29573 Mdot
.5 Mabswid
.29261 .29573 m
.28716 .30387 L
s
.29261 .29573 m
.2772 .28907 L
s
.01 w
.43941 .30841 Mdot
.5 Mabswid
.43941 .30841 m
.43666 .30814 L
s
.46154 .30453 m
.43941 .30841 L
s
.46298 .30445 m
.43941 .30841 L
s
.46375 .30402 m
.43941 .30841 L
s
.01 w
.35309 .32956 Mdot
.5 Mabswid
.37683 .32059 m
.35309 .32956 L
s
.3784 .31918 m
.35309 .32956 L
s
.01 w
.2762 .27109 Mdot
.5 Mabswid
.2762 .27109 m
.25932 .266 L
s
.2762 .27109 m
.26799 .2705 L
s
.01 w
.58991 .30286 Mdot
.5 Mabswid
.58991 .30286 m
.56638 .30107 L
s
.58991 .30286 m
.56575 .30063 L
s
.58991 .30286 m
.5911 .30313 L
s
.01 w
.70234 .32746 Mdot
.5 Mabswid
.70234 .32746 m
.71579 .32009 L
s
.70424 .32529 m
.70234 .32746 L
s
.67904 .31859 m
.70234 .32746 L
s
.67883 .31656 m
.70234 .32746 L
s
.01 w
.33791 .31711 Mdot
.5 Mabswid
.30867 .3097 m
.33791 .31711 L
s
.354 .31104 m
.33791 .31711 L
s
.32223 .30762 m
.33791 .31711 L
s
.37516 .31629 m
.33791 .31711 L
s
.01 w
.70424 .32529 Mdot
.5 Mabswid
.70424 .32529 m
.71579 .32009 L
s
.70424 .32529 m
.71839 .31445 L
s
.67904 .31859 m
.70424 .32529 L
s
.67883 .31656 m
.70424 .32529 L
s
.01 w
.74502 .31561 Mdot
.5 Mabswid
.74502 .31561 m
.73957 .3056 L
s
.75578 .2946 m
.74502 .31561 L
s
.01 w
.61756 .3057 Mdot
.5 Mabswid
.61756 .3057 m
.5954 .30236 L
s
.61756 .3057 m
.59321 .3028 L
s
.61756 .3057 m
.5911 .30313 L
s
.61756 .3057 m
.62212 .30487 L
s
.6459 .3086 m
.61756 .3057 L
s
.01 w
.29699 .31201 Mdot
.5 Mabswid
.29699 .31201 m
.30867 .3097 L
s
.29699 .31201 m
.28285 .3088 L
s
.29699 .31201 m
.29788 .31853 L
s
.29699 .31201 m
.28716 .30387 L
s
.01 w
.5911 .30313 Mdot
.5 Mabswid
.5911 .30313 m
.56743 .30113 L
s
.5911 .30313 m
.56638 .30107 L
s
.5911 .30313 m
.56575 .30063 L
s
.5911 .30313 m
.59321 .3028 L
s
.01 w
.6459 .3086 Mdot
.5 Mabswid
.6459 .3086 m
.62528 .30418 L
s
.6459 .3086 m
.62212 .30487 L
s
.6459 .3086 m
.65561 .30671 L
s
.67278 .31122 m
.6459 .3086 L
s
.01 w
.37516 .31629 Mdot
.5 Mabswid
.37516 .31629 m
.38522 .30961 L
s
.37516 .31629 m
.354 .31104 L
s
.37516 .31629 m
.3784 .31918 L
s
.40288 .31279 m
.37516 .31629 L
s
.40426 .31154 m
.37516 .31629 L
s
.40816 .31213 m
.37516 .31629 L
s
.01 w
.40816 .31213 Mdot
.5 Mabswid
.40816 .31213 m
.40426 .31154 L
s
.43134 .30723 m
.40816 .31213 L
s
.43383 .30777 m
.40816 .31213 L
s
.43666 .30814 m
.40816 .31213 L
s
.01 w
.43666 .30814 Mdot
.5 Mabswid
.43666 .30814 m
.43383 .30777 L
s
.46017 .30431 m
.43666 .30814 L
s
.46154 .30453 m
.43666 .30814 L
s
.46298 .30445 m
.43666 .30814 L
s
.01 w
.27667 .31008 Mdot
.5 Mabswid
.25746 .29452 m
.27667 .31008 L
s
.26915 .29435 m
.27667 .31008 L
s
.28716 .30387 m
.27667 .31008 L
s
.01 w
.29788 .31853 Mdot
.5 Mabswid
.29788 .31853 m
.28598 .31549 L
s
.29788 .31853 m
.30162 .32506 L
s
.29788 .31853 m
.28285 .3088 L
s
.01 w
.46375 .30402 Mdot
.5 Mabswid
.46375 .30402 m
.46298 .30445 L
s
.4882 .30181 m
.46375 .30402 L
s
.48856 .30108 m
.46375 .30402 L
s
.01 w
.30162 .32506 Mdot
.5 Mabswid
.30162 .32506 m
.28598 .31549 L
s
.01 w
.72661 .29351 Mdot
.5 Mabswid
.72661 .29351 m
.74437 .28895 L
s
.72661 .29351 m
.73484 .2974 L
s
.72661 .29351 m
.7203 .30724 L
s
.72661 .29351 m
.73964 .28125 L
s
.01 w
.26799 .2705 Mdot
.5 Mabswid
.26799 .2705 m
.25685 .27084 L
s
.26799 .2705 m
.2718 .27814 L
s
.26799 .2705 m
.25932 .266 L
s
.01 w
.3784 .31918 Mdot
.5 Mabswid
.3784 .31918 m
.37683 .32059 L
s
.40262 .31354 m
.3784 .31918 L
s
.40288 .31279 m
.3784 .31918 L
s
.40426 .31154 m
.3784 .31918 L
s
.01 w
.67278 .31122 Mdot
.5 Mabswid
.67278 .31122 m
.69364 .30499 L
s
.67278 .31122 m
.65213 .31001 L
s
.67278 .31122 m
.65561 .30671 L
s
.67278 .31122 m
.67883 .31656 L
s
.01 w
.30867 .3097 Mdot
.5 Mabswid
.32223 .30762 m
.30867 .3097 L
s
.29085 .29973 m
.30867 .3097 L
s
.28716 .30387 m
.30867 .3097 L
s
.01 w
.28716 .30387 Mdot
.5 Mabswid
.28716 .30387 m
.29085 .29973 L
s
.28716 .30387 m
.26913 .2998 L
s
.28716 .30387 m
.28285 .3088 L
s
.28716 .30387 m
.26915 .29435 L
s
.2772 .28907 m
.28716 .30387 L
s
.01 w
.2718 .27814 Mdot
.5 Mabswid
.2718 .27814 m
.26089 .28086 L
s
.2718 .27814 m
.2772 .28907 L
s
.2718 .27814 m
.25685 .27084 L
s
.01 w
.46298 .30445 Mdot
.5 Mabswid
.46298 .30445 m
.46154 .30453 L
s
.48753 .30203 m
.46298 .30445 L
s
.4882 .30181 m
.46298 .30445 L
s
.48856 .30108 m
.46298 .30445 L
s
.01 w
.7203 .30724 Mdot
.5 Mabswid
.7203 .30724 m
.69364 .30499 L
s
.7203 .30724 m
.72259 .29589 L
s
.7203 .30724 m
.73957 .3056 L
s
.7203 .30724 m
.73377 .3038 L
s
.7203 .30724 m
.71839 .31445 L
s
.7203 .30724 m
.73484 .2974 L
s
.01 w
.67883 .31656 Mdot
.5 Mabswid
.67883 .31656 m
.65357 .31138 L
s
.67883 .31656 m
.65213 .31001 L
s
.67883 .31656 m
.65561 .30671 L
s
.67883 .31656 m
.67904 .31859 L
s
.01 w
.2772 .28907 Mdot
.5 Mabswid
.2772 .28907 m
.26915 .29435 L
s
.2772 .28907 m
.26089 .28086 L
s
.01 w
.37683 .32059 Mdot
.5 Mabswid
.40262 .31354 m
.37683 .32059 L
s
.40288 .31279 m
.37683 .32059 L
s
.01 w
.56575 .30063 Mdot
.5 Mabswid
.56575 .30063 m
.54052 .3001 L
s
.56575 .30063 m
.54026 .29938 L
s
.56575 .30063 m
.56638 .30107 L
s
.01 w
.74814 .26332 Mdot
.5 Mabswid
.74814 .26332 m
.75976 .26316 L
s
.74814 .26332 m
.74304 .2719 L
s
.74814 .26332 m
.76369 .25554 L
s
.75618 .25673 m
.74814 .26332 L
s
.01 w
.74304 .2719 Mdot
.5 Mabswid
.74304 .2719 m
.75425 .274 L
s
.74304 .2719 m
.73964 .28125 L
s
.74304 .2719 m
.75976 .26316 L
s
.01 w
.59321 .3028 Mdot
.5 Mabswid
.59321 .3028 m
.56823 .30078 L
s
.59321 .3028 m
.56743 .30113 L
s
.59321 .3028 m
.56638 .30107 L
s
.59321 .3028 m
.5954 .30236 L
s
.62212 .30487 m
.59321 .3028 L
s
.01 w
.73957 .3056 Mdot
.5 Mabswid
.75578 .2946 m
.73957 .3056 L
s
.74437 .28895 m
.73957 .3056 L
s
.73484 .2974 m
.73957 .3056 L
s
.01 w
.71839 .31445 Mdot
.5 Mabswid
.71839 .31445 m
.73004 .31027 L
s
.71839 .31445 m
.71579 .32009 L
s
.71839 .31445 m
.73377 .3038 L
s
.01 w
.354 .31104 Mdot
.5 Mabswid
.354 .31104 m
.38522 .30961 L
s
.32223 .30762 m
.354 .31104 L
s
.01 w
.67904 .31859 Mdot
.5 Mabswid
.67904 .31859 m
.65357 .31138 L
s
.67904 .31859 m
.65213 .31001 L
s
.01 w
.62212 .30487 Mdot
.5 Mabswid
.62212 .30487 m
.59723 .30182 L
s
.62212 .30487 m
.5954 .30236 L
s
.62212 .30487 m
.62528 .30418 L
s
.65561 .30671 m
.62212 .30487 L
s
.01 w
.56638 .30107 Mdot
.5 Mabswid
.56638 .30107 m
.54087 .30031 L
s
.56638 .30107 m
.54052 .3001 L
s
.56638 .30107 m
.54026 .29938 L
s
.56638 .30107 m
.56743 .30113 L
s
.01 w
.71579 .32009 Mdot
.5 Mabswid
.71579 .32009 m
.73004 .31027 L
s
.01 w
.40426 .31154 Mdot
.5 Mabswid
.40426 .31154 m
.41502 .30627 L
s
.40426 .31154 m
.38522 .30961 L
s
.40426 .31154 m
.40288 .31279 L
s
.43013 .30802 m
.40426 .31154 L
s
.43134 .30723 m
.40426 .31154 L
s
.43383 .30777 m
.40426 .31154 L
s
.01 w
.43383 .30777 Mdot
.5 Mabswid
.43383 .30777 m
.43134 .30723 L
s
.45918 .3039 m
.43383 .30777 L
s
.46017 .30431 m
.43383 .30777 L
s
.46154 .30453 m
.43383 .30777 L
s
.01 w
.48856 .30108 Mdot
.5 Mabswid
.48856 .30108 m
.4882 .30181 L
s
.51425 .30036 m
.48856 .30108 L
s
.5143 .29963 m
.48856 .30108 L
s
.01 w
.32223 .30762 Mdot
.5 Mabswid
.29085 .29973 m
.32223 .30762 L
s
.01 w
.25932 .266 Mdot
.5 Mabswid
.25932 .266 m
.24609 .26534 L
s
.25932 .266 m
.25685 .27084 L
s
.01 w
.46154 .30453 Mdot
.5 Mabswid
.46154 .30453 m
.46017 .30431 L
s
.48683 .30192 m
.46154 .30453 L
s
.48753 .30203 m
.46154 .30453 L
s
.4882 .30181 m
.46154 .30453 L
s
.01 w
.73964 .28125 Mdot
.5 Mabswid
.73964 .28125 m
.74437 .28895 L
s
.73964 .28125 m
.75425 .274 L
s
.01 w
.75618 .25673 Mdot
.5 Mabswid
.75618 .25673 m
.77208 .25083 L
s
.75618 .25673 m
.76369 .25554 L
s
.01 w
.54026 .29938 Mdot
.5 Mabswid
.54026 .29938 m
.51425 .30036 L
s
.54026 .29938 m
.5143 .29963 L
s
.54026 .29938 m
.54052 .3001 L
s
.01 w
.65561 .30671 Mdot
.5 Mabswid
.65561 .30671 m
.69364 .30499 L
s
.65561 .30671 m
.64398 .30084 L
s
.65561 .30671 m
.6761 .30017 L
s
.65561 .30671 m
.62637 .30538 L
s
.65561 .30671 m
.62528 .30418 L
s
.65561 .30671 m
.65213 .31001 L
s
.01 w
.69364 .30499 Mdot
.5 Mabswid
.72259 .29589 m
.69364 .30499 L
s
.6761 .30017 m
.69364 .30499 L
s
.70824 .29484 m
.69364 .30499 L
s
.01 w
.4882 .30181 Mdot
.5 Mabswid
.4882 .30181 m
.48753 .30203 L
s
.5141 .30057 m
.4882 .30181 L
s
.51425 .30036 m
.4882 .30181 L
s
.5143 .29963 m
.4882 .30181 L
s
.01 w
.28285 .3088 Mdot
.5 Mabswid
.28285 .3088 m
.27099 .30605 L
s
.28285 .3088 m
.28598 .31549 L
s
.28285 .3088 m
.26913 .2998 L
s
.01 w
.5143 .29963 Mdot
.5 Mabswid
.5143 .29963 m
.51425 .30036 L
s
.54052 .3001 m
.5143 .29963 L
s
.01 w
.38522 .30961 Mdot
.5 Mabswid
.38522 .30961 m
.41502 .30627 L
s
.01 w
.40288 .31279 Mdot
.5 Mabswid
.40288 .31279 m
.40262 .31354 L
s
.42921 .30814 m
.40288 .31279 L
s
.43013 .30802 m
.40288 .31279 L
s
.43134 .30723 m
.40288 .31279 L
s
.01 w
.28598 .31549 Mdot
.5 Mabswid
.28598 .31549 m
.27099 .30605 L
s
.01 w
.54052 .3001 Mdot
.5 Mabswid
.54052 .3001 m
.5141 .30057 L
s
.54052 .3001 m
.51425 .30036 L
s
.54052 .3001 m
.54087 .30031 L
s
.56743 .30113 m
.54052 .3001 L
s
.01 w
.56743 .30113 Mdot
.5 Mabswid
.56743 .30113 m
.54111 .30019 L
s
.56743 .30113 m
.54087 .30031 L
s
.56743 .30113 m
.56823 .30078 L
s
.5954 .30236 m
.56743 .30113 L
s
.01 w
.51425 .30036 Mdot
.5 Mabswid
.51425 .30036 m
.48753 .30203 L
s
.51425 .30036 m
.5141 .30057 L
s
.54087 .30031 m
.51425 .30036 L
s
.01 w
.65213 .31001 Mdot
.5 Mabswid
.65213 .31001 m
.62639 .30617 L
s
.65213 .31001 m
.62637 .30538 L
s
.65213 .31001 m
.62528 .30418 L
s
.65213 .31001 m
.65357 .31138 L
s
.01 w
.5954 .30236 Mdot
.5 Mabswid
.5954 .30236 m
.56865 .30035 L
s
.5954 .30236 m
.56823 .30078 L
s
.5954 .30236 m
.59723 .30182 L
s
.62528 .30418 m
.5954 .30236 L
s
.01 w
.29085 .29973 Mdot
.5 Mabswid
.26526 .28877 m
.29085 .29973 L
s
.26915 .29435 m
.29085 .29973 L
s
.01 w
.25685 .27084 Mdot
.5 Mabswid
.25685 .27084 m
.24634 .27282 L
s
.25685 .27084 m
.26089 .28086 L
s
.25685 .27084 m
.24609 .26534 L
s
.01 w
.48753 .30203 Mdot
.5 Mabswid
.48753 .30203 m
.46017 .30431 L
s
.48753 .30203 m
.48683 .30192 L
s
.51389 .30055 m
.48753 .30203 L
s
.5141 .30057 m
.48753 .30203 L
s
.01 w
.40262 .31354 Mdot
.5 Mabswid
.42921 .30814 m
.40262 .31354 L
s
.43013 .30802 m
.40262 .31354 L
s
.01 w
.46017 .30431 Mdot
.5 Mabswid
.46017 .30431 m
.43134 .30723 L
s
.46017 .30431 m
.45918 .3039 L
s
.48776 .30159 m
.46017 .30431 L
s
.48683 .30192 m
.46017 .30431 L
s
.01 w
.73484 .2974 Mdot
.5 Mabswid
.73484 .2974 m
.72259 .29589 L
s
.73484 .2974 m
.74793 .29344 L
s
.73484 .2974 m
.73377 .3038 L
s
.73484 .2974 m
.74437 .28895 L
s
.01 w
.43134 .30723 Mdot
.5 Mabswid
.43134 .30723 m
.44495 .303 L
s
.43134 .30723 m
.41502 .30627 L
s
.43134 .30723 m
.43013 .30802 L
s
.45779 .30436 m
.43134 .30723 L
s
.45918 .3039 m
.43134 .30723 L
s
.01 w
.65357 .31138 Mdot
.5 Mabswid
.65357 .31138 m
.62639 .30617 L
s
.65357 .31138 m
.62637 .30538 L
s
.01 w
.26915 .29435 Mdot
.5 Mabswid
.26915 .29435 m
.25746 .29452 L
s
.26915 .29435 m
.26526 .28877 L
s
.26915 .29435 m
.25405 .2909 L
s
.26915 .29435 m
.26913 .2998 L
s
.26915 .29435 m
.2515 .28398 L
s
.26089 .28086 m
.26915 .29435 L
s
.01 w
.62528 .30418 Mdot
.5 Mabswid
.62528 .30418 m
.61326 .29973 L
s
.62528 .30418 m
.64398 .30084 L
s
.62528 .30418 m
.59814 .30259 L
s
.62528 .30418 m
.59723 .30182 L
s
.62528 .30418 m
.62637 .30538 L
s
.01 w
.26089 .28086 Mdot
.5 Mabswid
.26089 .28086 m
.2515 .28398 L
s
.26089 .28086 m
.24634 .27282 L
s
.01 w
.54087 .30031 Mdot
.5 Mabswid
.54087 .30031 m
.51389 .30055 L
s
.54087 .30031 m
.5141 .30057 L
s
.54087 .30031 m
.54111 .30019 L
s
.56823 .30078 m
.54087 .30031 L
s
.01 w
.5141 .30057 Mdot
.5 Mabswid
.5141 .30057 m
.48683 .30192 L
s
.5141 .30057 m
.51389 .30055 L
s
.54111 .30019 m
.5141 .30057 L
s
.01 w
.41502 .30627 Mdot
.5 Mabswid
.41502 .30627 m
.44495 .303 L
s
.01 w
.76369 .25554 Mdot
.5 Mabswid
.76369 .25554 m
.77406 .25536 L
s
.76369 .25554 m
.75976 .26316 L
s
.76369 .25554 m
.77208 .25083 L
s
.01 w
.25746 .29452 Mdot
.5 Mabswid
.24083 .28325 m
.25746 .29452 L
s
.2515 .28398 m
.25746 .29452 L
s
.01 w
.73377 .3038 Mdot
.5 Mabswid
.73377 .3038 m
.74475 .30009 L
s
.73377 .3038 m
.73004 .31027 L
s
.73377 .3038 m
.74793 .29344 L
s
.01 w
.72259 .29589 Mdot
.5 Mabswid
.70824 .29484 m
.72259 .29589 L
s
.73958 .28521 m
.72259 .29589 L
s
.74437 .28895 m
.72259 .29589 L
s
.01 w
.73004 .31027 Mdot
.5 Mabswid
.73004 .31027 m
.74475 .30009 L
s
.01 w
.56823 .30078 Mdot
.5 Mabswid
.56823 .30078 m
.53964 .29988 L
s
.56823 .30078 m
.54111 .30019 L
s
.56823 .30078 m
.56865 .30035 L
s
.59723 .30182 m
.56823 .30078 L
s
.01 w
.75578 .2946 Mdot
.5 Mabswid
.77348 .27857 m
.75578 .2946 L
s
.76156 .27873 m
.75578 .2946 L
s
.74437 .28895 m
.75578 .2946 L
s
.01 w
.43013 .30802 Mdot
.5 Mabswid
.43013 .30802 m
.42921 .30814 L
s
.45681 .3044 m
.43013 .30802 L
s
.45779 .30436 m
.43013 .30802 L
s
.45918 .3039 m
.43013 .30802 L
s
.01 w
.6761 .30017 Mdot
.5 Mabswid
.6761 .30017 m
.64398 .30084 L
s
.70824 .29484 m
.6761 .30017 L
s
.01 w
.26913 .2998 Mdot
.5 Mabswid
.26913 .2998 m
.25666 .29692 L
s
.26913 .2998 m
.27099 .30605 L
s
.26913 .2998 m
.25405 .2909 L
s
.01 w
.75976 .26316 Mdot
.5 Mabswid
.75976 .26316 m
.76982 .26521 L
s
.75976 .26316 m
.75425 .274 L
s
.75976 .26316 m
.77406 .25536 L
s
.01 w
.48683 .30192 Mdot
.5 Mabswid
.48683 .30192 m
.45918 .3039 L
s
.48683 .30192 m
.48776 .30159 L
s
.51366 .30055 m
.48683 .30192 L
s
.51389 .30055 m
.48683 .30192 L
s
.01 w
.62637 .30538 Mdot
.5 Mabswid
.62637 .30538 m
.5988 .30262 L
s
.62637 .30538 m
.59814 .30259 L
s
.62637 .30538 m
.59723 .30182 L
s
.62637 .30538 m
.62639 .30617 L
s
.01 w
.74437 .28895 Mdot
.5 Mabswid
.74437 .28895 m
.73958 .28521 L
s
.74437 .28895 m
.76099 .28384 L
s
.74437 .28895 m
.74793 .29344 L
s
.74437 .28895 m
.76156 .27873 L
s
.75425 .274 m
.74437 .28895 L
s
.01 w
.75425 .274 Mdot
.5 Mabswid
.75425 .274 m
.76156 .27873 L
s
.75425 .274 m
.76982 .26521 L
s
.01 w
.64398 .30084 Mdot
.5 Mabswid
.64398 .30084 m
.61326 .29973 L
s
.01 w
.45918 .3039 Mdot
.5 Mabswid
.45918 .3039 m
.47691 .30042 L
s
.45918 .3039 m
.44495 .303 L
s
.45918 .3039 m
.45779 .30436 L
s
.4855 .30198 m
.45918 .3039 L
s
.48776 .30159 m
.45918 .3039 L
s
.01 w
.27099 .30605 Mdot
.5 Mabswid
.27099 .30605 m
.25666 .29692 L
s
.01 w
.59723 .30182 Mdot
.5 Mabswid
.59723 .30182 m
.58255 .29858 L
s
.59723 .30182 m
.61326 .29973 L
s
.59723 .30182 m
.56972 .3008 L
s
.59723 .30182 m
.56865 .30035 L
s
.59723 .30182 m
.59814 .30259 L
s
.01 w
.54111 .30019 Mdot
.5 Mabswid
.54111 .30019 m
.51366 .30055 L
s
.54111 .30019 m
.51389 .30055 L
s
.54111 .30019 m
.53964 .29988 L
s
.56865 .30035 m
.54111 .30019 L
s
.01 w
.24609 .26534 Mdot
.5 Mabswid
.24609 .26534 m
.23543 .26707 L
s
.24609 .26534 m
.24634 .27282 L
s
.01 w
.51389 .30055 Mdot
.5 Mabswid
.51389 .30055 m
.48776 .30159 L
s
.51389 .30055 m
.51366 .30055 L
s
.53964 .29988 m
.51389 .30055 L
s
.01 w
.42921 .30814 Mdot
.5 Mabswid
.45681 .3044 m
.42921 .30814 L
s
.45779 .30436 m
.42921 .30814 L
s
.01 w
.62639 .30617 Mdot
.5 Mabswid
.62639 .30617 m
.5988 .30262 L
s
.62639 .30617 m
.59814 .30259 L
s
.01 w
.70824 .29484 Mdot
.5 Mabswid
.73958 .28521 m
.70824 .29484 L
s
.01 w
.44495 .303 Mdot
.5 Mabswid
.44495 .303 m
.47691 .30042 L
s
.01 w
.77208 .25083 Mdot
.5 Mabswid
.77208 .25083 m
.78438 .24948 L
s
.77208 .25083 m
.77406 .25536 L
s
.01 w
.45779 .30436 Mdot
.5 Mabswid
.45779 .30436 m
.45681 .3044 L
s
.48496 .30184 m
.45779 .30436 L
s
.4855 .30198 m
.45779 .30436 L
s
.48776 .30159 m
.45779 .30436 L
s
.01 w
.56865 .30035 Mdot
.5 Mabswid
.56865 .30035 m
.55009 .2981 L
s
.56865 .30035 m
.58255 .29858 L
s
.56865 .30035 m
.5416 .30021 L
s
.56865 .30035 m
.53964 .29988 L
s
.56865 .30035 m
.56972 .3008 L
s
.59814 .30259 m
.56865 .30035 L
s
.01 w
.61326 .29973 Mdot
.5 Mabswid
.61326 .29973 m
.58255 .29858 L
s
.01 w
.48776 .30159 Mdot
.5 Mabswid
.48776 .30159 m
.47691 .30042 L
s
.48776 .30159 m
.51345 .29879 L
s
.48776 .30159 m
.4855 .30198 L
s
.51347 .30066 m
.48776 .30159 L
s
.51366 .30055 m
.48776 .30159 L
s
.01 w
.59814 .30259 Mdot
.5 Mabswid
.59814 .30259 m
.57045 .30065 L
s
.59814 .30259 m
.56972 .3008 L
s
.59814 .30259 m
.5988 .30262 L
s
.01 w
.26526 .28877 Mdot
.5 Mabswid
.24637 .27918 m
.26526 .28877 L
s
.2515 .28398 m
.26526 .28877 L
s
.01 w
.24634 .27282 Mdot
.5 Mabswid
.24634 .27282 m
.2373 .2757 L
s
.24634 .27282 m
.2515 .28398 L
s
.24634 .27282 m
.23543 .26707 L
s
.01 w
.51366 .30055 Mdot
.5 Mabswid
.51366 .30055 m
.51345 .29879 L
s
.51366 .30055 m
.4855 .30198 L
s
.51366 .30055 m
.51347 .30066 L
s
.5416 .30021 m
.51366 .30055 L
s
.53964 .29988 m
.51366 .30055 L
s
.01 w
.53964 .29988 Mdot
.5 Mabswid
.53964 .29988 m
.51345 .29879 L
s
.53964 .29988 m
.55009 .2981 L
s
.53964 .29988 m
.51347 .30066 L
s
.53964 .29988 m
.5416 .30021 L
s
.56972 .3008 m
.53964 .29988 L
s
.01 w
.2515 .28398 Mdot
.5 Mabswid
.2515 .28398 m
.24083 .28325 L
s
.2515 .28398 m
.24637 .27918 L
s
.2515 .28398 m
.24104 .28299 L
s
.2515 .28398 m
.25405 .2909 L
s
.2515 .28398 m
.2373 .2757 L
s
.01 w
.45681 .3044 Mdot
.5 Mabswid
.48496 .30184 m
.45681 .3044 L
s
.4855 .30198 m
.45681 .3044 L
s
.01 w
.47691 .30042 Mdot
.5 Mabswid
.51345 .29879 m
.47691 .30042 L
s
.01 w
.5988 .30262 Mdot
.5 Mabswid
.5988 .30262 m
.57045 .30065 L
s
.5988 .30262 m
.56972 .3008 L
s
.01 w
.74793 .29344 Mdot
.5 Mabswid
.74793 .29344 m
.75881 .28993 L
s
.74793 .29344 m
.74475 .30009 L
s
.74793 .29344 m
.76099 .28384 L
s
.01 w
.58255 .29858 Mdot
.5 Mabswid
.58255 .29858 m
.55009 .2981 L
s
.01 w
.25405 .2909 Mdot
.5 Mabswid
.25405 .2909 m
.24301 .28819 L
s
.25405 .2909 m
.25666 .29692 L
s
.25405 .2909 m
.24104 .28299 L
s
.01 w
.56972 .3008 Mdot
.5 Mabswid
.56972 .3008 m
.54187 .29996 L
s
.56972 .3008 m
.5416 .30021 L
s
.56972 .3008 m
.57045 .30065 L
s
.01 w
.4855 .30198 Mdot
.5 Mabswid
.4855 .30198 m
.48496 .30184 L
s
.51335 .30044 m
.4855 .30198 L
s
.51347 .30066 m
.4855 .30198 L
s
.01 w
.74475 .30009 Mdot
.5 Mabswid
.74475 .30009 m
.75881 .28993 L
s
.01 w
.51345 .29879 Mdot
.5 Mabswid
.55009 .2981 m
.51345 .29879 L
s
.01 w
.25666 .29692 Mdot
.5 Mabswid
.25666 .29692 m
.24301 .28819 L
s
.01 w
.73958 .28521 Mdot
.5 Mabswid
.7646 .27316 m
.73958 .28521 L
s
.76156 .27873 m
.73958 .28521 L
s
.01 w
.77406 .25536 Mdot
.5 Mabswid
.77406 .25536 m
.78377 .25681 L
s
.77406 .25536 m
.76982 .26521 L
s
.77406 .25536 m
.78438 .24948 L
s
.01 w
.55009 .2981 Mdot
.24083 .28325 Mdot
.5 Mabswid
.22823 .27576 m
.24083 .28325 L
s
.2373 .2757 m
.24083 .28325 L
s
.01 w
.5416 .30021 Mdot
.5 Mabswid
.5416 .30021 m
.51335 .30044 L
s
.5416 .30021 m
.51347 .30066 L
s
.5416 .30021 m
.54187 .29996 L
s
.57045 .30065 m
.5416 .30021 L
s
.01 w
.51347 .30066 Mdot
.5 Mabswid
.51347 .30066 m
.48496 .30184 L
s
.51347 .30066 m
.51335 .30044 L
s
.54187 .29996 m
.51347 .30066 L
s
.01 w
.57045 .30065 Mdot
.5 Mabswid
.57045 .30065 m
.54187 .29996 L
s
.01 w
.48496 .30184 Mdot
.5 Mabswid
.51335 .30044 m
.48496 .30184 L
s
.01 w
.76982 .26521 Mdot
.5 Mabswid
.76982 .26521 m
.77845 .26779 L
s
.76982 .26521 m
.76156 .27873 L
s
.76982 .26521 m
.78377 .25681 L
s
.01 w
.76156 .27873 Mdot
.5 Mabswid
.76156 .27873 m
.7646 .27316 L
s
.76156 .27873 m
.77348 .27857 L
s
.76156 .27873 m
.7754 .27436 L
s
.76156 .27873 m
.76099 .28384 L
s
.76156 .27873 m
.77845 .26779 L
s
.01 w
.23543 .26707 Mdot
.5 Mabswid
.23543 .26707 m
.22791 .27031 L
s
.23543 .26707 m
.2373 .2757 L
s
.01 w
.54187 .29996 Mdot
.5 Mabswid
.54187 .29996 m
.51335 .30044 L
s
.01 w
.51335 .30044 Mdot
.24637 .27918 Mdot
.5 Mabswid
.23309 .27213 m
.24637 .27918 L
s
.2373 .2757 m
.24637 .27918 L
s
.01 w
.2373 .2757 Mdot
.5 Mabswid
.2373 .2757 m
.22823 .27576 L
s
.2373 .2757 m
.23309 .27213 L
s
.2373 .2757 m
.23224 .2789 L
s
.2373 .2757 m
.24104 .28299 L
s
.2373 .2757 m
.22791 .27031 L
s
.01 w
.77348 .27857 Mdot
.5 Mabswid
.78923 .26691 m
.77348 .27857 L
s
.77845 .26779 m
.77348 .27857 L
s
.01 w
.24104 .28299 Mdot
.5 Mabswid
.24104 .28299 m
.24301 .28819 L
s
.24104 .28299 m
.23224 .2789 L
s
.01 w
.76099 .28384 Mdot
.5 Mabswid
.76099 .28384 m
.7724 .28011 L
s
.76099 .28384 m
.75881 .28993 L
s
.76099 .28384 m
.7754 .27436 L
s
.01 w
.24301 .28819 Mdot
.5 Mabswid
.23224 .2789 m
.24301 .28819 L
s
.01 w
.78438 .24948 Mdot
.5 Mabswid
.78438 .24948 m
.79421 .2509 L
s
.78438 .24948 m
.78377 .25681 L
s
.01 w
.75881 .28993 Mdot
.5 Mabswid
.75881 .28993 m
.7724 .28011 L
s
.01 w
.22823 .27576 Mdot
.5 Mabswid
.22791 .27031 m
.22823 .27576 L
s
.01 w
.22791 .27031 Mdot
.5 Mabswid
.22791 .27031 m
.23309 .27213 L
s
.22791 .27031 m
.23224 .2789 L
s
.01 w
.7646 .27316 Mdot
.5 Mabswid
.783 .2628 m
.7646 .27316 L
s
.77845 .26779 m
.7646 .27316 L
s
.01 w
.78377 .25681 Mdot
.5 Mabswid
.78377 .25681 m
.79207 .2591 L
s
.78377 .25681 m
.77845 .26779 L
s
.78377 .25681 m
.79421 .2509 L
s
.01 w
.23224 .2789 Mdot
.23309 .27213 Mdot
.77845 .26779 Mdot
.5 Mabswid
.77845 .26779 m
.783 .2628 L
s
.77845 .26779 m
.78923 .26691 L
s
.77845 .26779 m
.78783 .26593 L
s
.77845 .26779 m
.7754 .27436 L
s
.77845 .26779 m
.79207 .2591 L
s
.01 w
.7754 .27436 Mdot
.5 Mabswid
.7754 .27436 m
.78544 .27084 L
s
.7754 .27436 m
.7724 .28011 L
s
.7754 .27436 m
.78783 .26593 L
s
.01 w
.7724 .28011 Mdot
.5 Mabswid
.7724 .28011 m
.78544 .27084 L
s
.01 w
.78923 .26691 Mdot
.5 Mabswid
.80118 .25908 m
.78923 .26691 L
s
.79207 .2591 m
.78923 .26691 L
s
.01 w
.79421 .2509 Mdot
.5 Mabswid
.79421 .2509 m
.80096 .25343 L
s
.79421 .2509 m
.79207 .2591 L
s
.01 w
.783 .2628 Mdot
.5 Mabswid
.79584 .25542 m
.783 .2628 L
s
.79207 .2591 m
.783 .2628 L
s
.01 w
.79207 .2591 Mdot
.5 Mabswid
.79207 .2591 m
.79584 .25542 L
s
.79207 .2591 m
.80118 .25908 L
s
.79207 .2591 m
.79605 .26154 L
s
.79207 .2591 m
.78783 .26593 L
s
.79207 .2591 m
.80096 .25343 L
s
.01 w
.78783 .26593 Mdot
.5 Mabswid
.78783 .26593 m
.78544 .27084 L
s
.78783 .26593 m
.79605 .26154 L
s
.01 w
.78544 .27084 Mdot
.5 Mabswid
.79605 .26154 m
.78544 .27084 L
s
.01 w
.80118 .25908 Mdot
.5 Mabswid
.80096 .25343 m
.80118 .25908 L
s
.01 w
.80096 .25343 Mdot
.5 Mabswid
.80096 .25343 m
.79584 .25542 L
s
.80096 .25343 m
.79605 .26154 L
s
.01 w
.79584 .25542 Mdot
.79605 .26154 Mdot
.25 Mabswid
.69848 0 m
.98727 .42924 L
s
.98727 .42924 m
1 .52261 L
s
1 .52261 m
.70449 .10201 L
s
.70449 .10201 m
.69848 0 L
s
.01534 .25847 m
0 .35595 L
s
0 .35595 m
.70449 .10201 L
s
.70449 .10201 m
.69848 0 L
s
.69848 0 m
.01534 .25847 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[6]:=",
  ImageSize->{288, 198.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000aR000`400?l00000o`00003oa`3oool2
000005L0oooo00350?ooo`80000000<0oooo000000000000EP3oool00<80oooo0`0000030?ooo`80
0000EP3oool00;l0oooo0`0000060?ooo`030000003oool0000005D0oooo002m0?ooo`8000002@3o
ool010000000oooo0?ooo`00001D0?ooo`00^P3oool3000000/0oooo00@000000?ooo`3oool00000
E03oool00;L0oooo0`00000>0?ooo`050000003oool0oooo0?ooo`000000D`3oool00;D0oooo0P00
000A0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0D03oool00;80oooo0`00000D
0?ooo`050000003oool0oooo0?ooo`000000DP3oool00:l0oooo0`00000G0?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool0C`3oool00:d0oooo0P00000J0?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`3oool0CP3oool00:X0oooo0`00000L0?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`3oool0CP3oool00:L0oooo0`00000O0?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`3oool0C@3oool00:D0oooo0P00000R0?ooo`030000003oool0oooo00D0oooo00<0
00000?ooo`3oool0C03oool00:80oooo0`00000T0?ooo`030000003oool0oooo00D0oooo00<00000
0?ooo`3oool0C03oool009l0oooo0`00000W0?ooo`030000003oool0oooo00H0oooo00<000000?oo
o`3oool0B`3oool009d0oooo0P00000Z0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3o
ool0BP3oool009X0oooo0`00000/0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0
BP3oool009P0oooo0P00000_0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0B@3o
ool009D0oooo0`00000a0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0B03oool0
0980oooo0`00000d0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0B03oool00900
oooo0P00000g0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0A`3oool008d0oooo
0`00000j0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0AP3oool008X0oooo0`00
000m0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0A@3oool008P0oooo0P000010
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0A@3oool008D0oooo0`0000120?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`3oool0A03oool00880oooo0`0000150?ooo`03
0000003oool0oooo00d0oooo00<000000?ooo`3oool0@`3oool00800oooo0P0000180?ooo`030000
003oool0oooo00d0oooo00<000000?ooo`3oool0@`3oool007d0oooo0`00001:0?ooo`030000003o
ool0oooo00h0oooo00<000000?ooo`3oool0@P3oool007X0oooo0`00001<0?ooo`8000004@3oool0
0`000000oooo0?ooo`110?ooo`00N03oool2000004`0oooo0`0000020?ooo`030000003oool0oooo
00h0oooo00<000000?ooo`3oool0@@3oool007D0oooo0`00001<0?ooo`8000001@3oool00`000000
oooo0?ooo`0?0?ooo`030000003oool0oooo0400oooo001b0?ooo`<00000C03oool3000000P0oooo
00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0o0?ooo`00L03oool2000004`0oooo0`00
000<0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0?`3oool006d0oooo0`00001;
0?ooo`<000003`3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo03h0oooo001Z0?oo
o`<00000C03oool2000001<0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0m0?oo
o`00J03oool2000004`0oooo0`00000F0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3o
ool0?@3oool006D0oooo0`00001;0?ooo`<000006P3oool00`000000oooo0?ooo`0>0?ooo`030000
003oool0oooo03`0oooo001S0?ooo`800000B`3oool3000001d0oooo00<000000?ooo`3oool03`3o
ool00`000000oooo0?ooo`0k0?ooo`00H03oool3000004X0oooo0`00000Q0?ooo`030000003oool0
oooo00h0oooo00<000000?ooo`3oool0>`3oool005d0oooo0`00001;0?ooo`8000009@3oool00`00
0000oooo0?ooo`0>0?ooo`030000003oool0oooo03X0oooo001K0?ooo`800000B`3oool3000002L0
oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0i0?ooo`00F03oool3000004X0oooo
0`00000[0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0>@3oool005D0oooo0`00
001:0?ooo`<00000;`3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo03P0oooo001C
0?ooo`800000B`3oool200000380oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0g
0?ooo`00D03oool3000004X0oooo0`00000e0?ooo`030000003oool0oooo00h0oooo00<000000?oo
o`3oool0=`3oool004d0oooo0`00001:0?ooo`<00000>@3oool00`000000oooo0?ooo`0>0?ooo`03
0000003oool0oooo03H0oooo001;0?ooo`800000BP3oool3000003`0oooo00<000000?ooo`3oool0
3`3oool00`000000oooo0?ooo`0e0?ooo`00B03oool3000004X0oooo0P0000100?ooo`030000003o
ool0oooo00h0oooo00<000000?ooo`3oool0=@3oool004D0oooo0`00001:0?ooo`<00000@`3oool0
0`000000oooo0?ooo`0>0?ooo`030000003oool0oooo03@0oooo00130?ooo`800000BP3oool30000
04L0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0c0?ooo`00@03oool3000004T0
oooo0`00001:0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0<`3oool003d0oooo
0`0000190?ooo`<00000CP3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo0380oooo
000k0?ooo`800000BP3oool200000580oooo00<000000?ooo`3oool03P3oool00`000000oooo0?oo
o`0a0?ooo`00>03oool3000004T0oooo0`00001D0?ooo`030000003oool0oooo00h0oooo00<00000
0?ooo`3oool0<@3oool003H0oooo0P0000190?ooo`<00000F03oool00`000000oooo0?ooo`0>0?oo
o`030000003oool0oooo0300oooo000c0?ooo`<00000B03oool3000005`0oooo00<000000?ooo`3o
ool03P3oool00`000000oooo0?ooo`0_0?ooo`00<03oool3000004T0oooo0P00001O0?ooo`030000
003oool0oooo00h0oooo00<000000?ooo`3oool0;`3oool002h0oooo0P0000190?ooo`<00000HP3o
ool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo02h0oooo000[0?ooo`<00000B03oool3
000006H0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0]0?ooo`00:03oool30000
04P0oooo0`00001Z0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0;@3oool002H0
oooo0P0000190?ooo`800000K@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo02`0
oooo000S0?ooo`<00000B03oool300000700oooo00<000000?ooo`3oool03P3oool00`000000oooo
0?ooo`0[0?ooo`00803oool3000004P0oooo0`00001d0?ooo`030000003oool0oooo00h0oooo00<0
00000?ooo`3oool0:P3oool001h0oooo0P0000180?ooo`<00000M`3oool00`000000oooo0?ooo`0>
0?ooo`030000003oool0oooo02X0oooo000K0?ooo`<00000B03oool2000007/0oooo00<000000?oo
o`3oool03P3oool00`000000oooo0?ooo`0Y0?ooo`00603oool3000004P0oooo0`00001n0?ooo`03
0000003oool0oooo00h0oooo00<000000?ooo`3oool0:03oool001H0oooo0P0000180?ooo`<00000
P@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo02P0oooo000C0?ooo`<00000A`3o
ool3000008D0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0W0?ooo`00403oool3
000004L0oooo0`0000290?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool09P3oool0
00h0oooo0P0000180?ooo`800000S03oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo
02H0oooo000;0?ooo`<00000A`3oool3000008P0oooo00<000000?ooo`3oool0103oool00`000000
oooo0?ooo`0>0?ooo`030000003oool0oooo02D0oooo00080?ooo`<00000A`3oool3000008L0oooo
200000040?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0903oool000H0oooo0P00
00170?ooo`<00000QP3oool00`000000oooo0000000;000000<0oooo00<000000?ooo`3oool03@3o
ool00`000000oooo0?ooo`0T0?ooo`00103oool2000004L0oooo0P0000280?ooo`L0000000<0oooo
0000000000001@0000030?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool08`3oool0
00@0oooo0P0000140?ooo`<00000R03oool600000080oooo200000050?ooo`030000003oool0oooo
00h0oooo00<000000?ooo`3oool08P3oool000@0oooo00<000000?ooo`000000>`3oool00`000000
oooo0?ooo`07000008H0oooo200000000`3oool0000000000007000000L0oooo00<000000?ooo`3o
ool03@3oool00`000000oooo0?ooo`0R0?ooo`00103oool010000000oooo0?ooo`00000h0?ooo`03
0000003oool0000000L0000000@0oooo0000000000000000PP3oool900000080oooo200000080?oo
o`030000003oool0oooo00h0oooo00<000000?ooo`3oool08@3oool000<0oooo00<000000?ooo`3o
ool00P3oool2000003H0oooo100000000`3oool000000000000:000007d0oooo5000000:0?ooo`03
0000003oool0oooo00h0oooo00<000000?ooo`3oool0803oool000<0oooo00<000000?ooo`3oool0
103oool00`000000oooo0?ooo`0b0?ooo`L0000000D0oooo00000000000000000?ooo`09000007L0
oooo1P0000020?ooo`<0000000<0oooo0000000000002000000<0?ooo`030000003oool0oooo00d0
oooo00<000000?ooo`3oool0803oool000<0oooo00<000000?ooo`3oool01@3oool00`000000oooo
0?ooo`0^0?ooo`<0000000<0oooo0000000000002@0000020?ooo`X00000LP3oool3000000040?oo
o`000000oooo0?ooo`<0000000<0oooo0000003oool02@00000>0?ooo`030000003oool0oooo00h0
oooo00<000000?ooo`3oool07`3oool000<0oooo00<000000?ooo`3oool01P3oool00`000000oooo
0?ooo`0Z0?ooo`<000001@3oool00`000000oooo0000000;000000030?ooo`000000000000L00000
KP3oool200000080oooo0P0000000`3oool000000000000=00000140oooo00<000000?ooo`3oool0
3P3oool00`000000oooo0?ooo`0N0?ooo`000`3oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo02H0oooo0`00000;0?ooo`X0000000@0oooo0000003oool0oooo2@00001Z0?ooo``00000
0P3oool9000001<0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0N0?ooo`000`3o
ool00`000000oooo0?ooo`080?ooo`030000003oool0oooo02<0oooo0P00000>0?oooaX00000I03o
ool9000000030?ooo`00000000000080oooo2P00000E0?ooo`030000003oool0oooo00h0oooo00<0
00000?ooo`3oool07@3oool000<0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0O
0?ooo`<00000403oool00`000000oooo0000000<000000030?ooo`000000oooo00<0000000@0oooo
000000000000oooo1000001M0?ooo`H0000000H0oooo000000000000oooo0000003oool?000001L0
oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0L0?ooo`000P3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo01/0oooo0`00000G0?ooo`X0000000<0oooo000000000000
1P0000000`3oool00000000000030?ooo`<00000=@3oool9000000@0oooo00<000000?ooo`3oool0
4@3oool400000080oooo00<000000?ooo`0000000P0000020?oooa4000006@3oool00`000000oooo
0?ooo`0=0?ooo`030000003oool0oooo01`0oooo00020?ooo`030000003oool0oooo00`0oooo00<0
00000?ooo`3oool05`3oool3000001X0oooo00<000000?ooo`0000002`0000000`3oool000000000
000?000001`0ooooC00000000`3oool0000000000005000001X0oooo00<000000?ooo`3oool03@3o
ool00`000000oooo0?ooo`0K0?ooo`000P3oool00`000000oooo0?ooo`0=0?ooo`8000005@3oool2
00000200oooo100000000`3oool0000000000008000000050?ooo`00000000000000003oool01`00
00000`3oool000000000000300000100oooo500000020?ooo`030000003oool0oooo00@0oooo0P00
00060?ooo`8000000`3ooolJ000000030?ooo`000000000000L0000000@0oooo000000000000oooo
2@00000K0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool06P3oool00080oooo00<0
00000?ooo`3oool03`3oool00`000000oooo0?ooo`0?0?ooo`<00000903ooolE00000080oooo1`00
00000`3oool0000000000004000000030?ooo`0000000000010000008`3oool3000000030?ooo`00
0000000001@0000000<0oooo000000000000400000000`3oool000000?ooo`0K0?ooo`030000003o
ool0oooo00d0oooo00<000000?ooo`3oool06P3oool00080oooo00<000000?ooo`3oool0403oool0
0`000000oooo0?ooo`0;0?ooo`<000009`3ooolB000000030?ooo`000000000001`00000;`3ooolK
00000080oooo00<000000?ooo`3oool01@000000103oool0000000000000000N0?ooo`030000003o
ool0oooo00d0oooo00<000000?ooo`3oool06@3oool00080oooo00<000000?ooo`3oool04@3oool0
0`000000oooo0?ooo`070?ooo`<00000:`3oool00`000000oooo00000008000000030?ooo`000000
000001l00000<03oool6000000030?ooo`000000000001<0000000<0oooo0000000000001`000002
0?ooo`<000007P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo01P0oooo00020?oo
o`030000003oool0oooo0180oooo00<000000?ooo`3oool0103oool200000300oooo2P0000000`3o
ool000000000000R000002T0oooo100000000`3oool000000?ooo`0R000000030?ooo`000000oooo
008000007`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo01P0oooo00000`3oool0
00000?ooo`0E0?ooo`030000003oool0oooo00<00000<`3oool00`000000oooo0000000`00000200
oooo00<000000?ooo`3oool09`0000020?ooo`060000003oool000000000003oool00000803oool0
0`000000oooo0?ooo`0=0?ooo`030000003oool0oooo01L0oooo00000`3oool000000?ooo`0E0?oo
o`<00000=`3oool:00000080oooo0`0000000`3oool000000?ooo`0N000000040?ooo`0000000000
000001h0oooo400000000`3oool000000?ooo`02000000030?ooo`000000000001H000000P3oool0
0`000000oooo0?ooo`0O0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool05P3oool0
00030?ooo`000000oooo0180oooo0`0000020?ooo`030000003oool0oooo03D0oooo0P0000000`3o
ool000000000000a000001X0oooo3`0000000`3oool000000000000H000000@0oooo0`0000000`3o
ool000000?ooo`0Q0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool05P3oool00003
0?ooo`000000oooo00l0oooo0`0000060?ooo`030000003oool0oooo03@0oooo0`0000000`3oool0
00000?ooo`04000000030?ooo`000000000002/00000503oool=000000030?ooo`000000000000P0
000000<0oooo000000000000500000020?ooo`040000003oool000000?ooo`8000008`3oool00`00
0000oooo0?ooo`0=0?ooo`030000003oool0oooo01D0oooo00000`3oool000000?ooo`0=0?ooo`80
00002P3oool2000003@0oooo0P0000000`3oool0000000000002000000030?ooo`00000000000100
00000P3oool3000000040?ooo`00000000000?ooo`@0000000<0oooo0000003oool0=P0000030?oo
o`/0000000<0oooo0000000000002`0000001@3oool000000?ooo`000000oooo00800000903oool0
0`000000oooo0?ooo`0=0?ooo`030000003oool0oooo01@0oooo00000`3oool000000?ooo`0:0?oo
o`<000003P3oool00`000000oooo0?ooo`0c0?ooo`030000003oool0oooo00@0000000<0oooo0000
000000001P000000103oool000000000003ooom4000000`0oooo00<000000?ooo`3oool02P000000
0`3oool000000000000700000080oooo00@000000?ooo`0000000000903oool00`000000oooo0?oo
o`0=0?ooo`030000003oool0oooo01@0oooo00000`3oool000000?ooo`070?ooo`<000004P3oool0
0`000000oooo0?ooo`0b0?ooo`030000003oool0oooo00<000000`3oool3000000030?ooo`000000
000000T0000000<0oooo0000003oool01@0000000`3oool000000000000a000001L0oooo4@000000
1@3oool000000000003oool0000002D0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?oo
o`0C0?ooo`0000<000000?ooo`3oool0103oool3000001H0oooo00<000000?ooo`3oool0<@3oool0
10000000oooo0000003oool200000080oooo3@0000020?ooo`/00000203oool00`000000oooo0?oo
o`0F000000030?ooo`000000000000d000006@3oool00`000000oooo0000000@000000030?ooo`00
0000oooo02D0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0B0?ooo`0000<00000
0?ooo`3oool00P3oool2000001X0oooo00<000000?ooo`3oool0<@3oool2000000050?ooo`000000
oooo0000003oool030000000103oool000000000000000020?ooo`<000004`3oool?000000030?oo
o`000000000000h0000000<0oooo0000003oool07@3oool>000000<0oooo00<000000?ooo`3oool0
8`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo0180oooo00000`000000oooo0000
0002000001d0oooo00<000000?ooo`3oool0;`3oool2000000<0oooo20000000103oool000000000
003oool4000000030?ooo`0000000000008000005P3oool00`000000oooo0000000N00000240oooo
3P0000000`3oool000000?ooo`0U0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0
4@3oool0008000008@3oool00`000000oooo0?ooo`0^0?ooo`<000000P3ooolB000001d0oooo7@00
000S0?ooo`/0000000<0oooo0000000000009`3oool00`000000oooo0?ooo`0=0?ooo`030000003o
ool0oooo0100oooo00000`3oool000000?ooo`0Q0?ooo`030000003oool0oooo02h0oooo00<00000
0?ooo`0000003@0000020?ooo`8000007`3ooolL000002D0oooo3@00000W0?ooo`030000003oool0
oooo00h0oooo00<000000?ooo`3oool03`3oool00080oooo00<000000?ooo`3oool0803oool00`00
0000oooo0?ooo`0]0?ooo`030000003oool0oooo00`000000P3oool00`000000oooo0?ooo`0P0?oo
oa/000009@3oool00`000000oooo0000000:000002P0oooo00<000000?ooo`3oool03@3oool00`00
0000oooo0?ooo`0?0?ooo`000`3oool200000240oooo0P00000]0?ooo`030000003oool0oooo0080
000000<0oooo0000000000000P0000000`3oool000000000000400000280oooo5`0000000`3oool0
000000000002000002P0oooo2@0000000`3oool000000?ooo`0W0?ooo`030000003oool0oooo00d0
oooo00<000000?ooo`3oool03P3oool000D0oooo00<000000?ooo`3oool0803oool00`000000oooo
0?ooo`0Y0?oooa000000903ooolM000002P0oooo2P00000X0?ooo`030000003oool0oooo00h0oooo
00<000000?ooo`3oool03@3oool000H0oooo00<000000?ooo`3oool0803oool00`000000oooo0?oo
o`0X0?ooo`80000000<0oooo0000000000002@00000W0?oooa`00000:@3oool9000002T0oooo00<0
00000?ooo`3oool03@3oool00`000000oooo0?ooo`0=0?ooo`001`3oool00`000000oooo0?ooo`0P
0?ooo`030000003oool0oooo02P0oooo3000000W0?oooa`0000000<0oooo0000003oool09`3oool9
000002X0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0<0?ooo`00203oool00`00
0000oooo0?ooo`0P0?ooo`030000003oool0oooo02L0oooo2@0000000`3oool000000?ooo`0W0?oo
o`/0000000<0oooo0000000000004000000X0?ooo`X00000:P3oool00`000000oooo0?ooo`0=0?oo
o`030000003oool0oooo00/0oooo00090?ooo`8000008@3oool00`000000oooo0?ooo`0U0?ooo`H0
000000<0oooo0000000000000P00000Y0?oooal00000:@3oool8000002X0oooo00<000000?ooo`3o
ool03@3oool00`000000oooo0?ooo`0;0?ooo`002`3oool00`000000oooo0?ooo`0O0?ooo`030000
003oool0oooo02@0oooo2P00000Z0?ooob000000:@3oool8000002X0oooo00<000000?ooo`3oool0
3@3oool00`000000oooo0?ooo`0:0?ooo`00303oool00`000000oooo0?ooo`0O0?ooo`030000003o
ool0oooo02<0oooo2@00000Z0?ooo`H0000000<0oooo0000000000000`0000000`3oool000000000
0007000000030?ooo`000000000000T00000:03oool8000002/0oooo00<000000?ooo`3oool03@3o
ool00`000000oooo0?ooo`090?ooo`003@3oool00`000000oooo0?ooo`0O0?ooo`030000003oool0
oooo0280oooo2@00000Y0?ooo`X000000P3oool5000000@0oooo00<000000?ooo`00000010000000
0`3oool0000000000005000002L0oooo2000000[0?ooo`030000003oool0oooo00d0oooo00<00000
0?ooo`3oool02@3oool000h0oooo00<000000?ooo`3oool07`3oool200000280oooo2000000Z0?oo
o`H0000000@0oooo000000000000oooo0`00000<0?ooo`H0000000<0oooo0000000000000`00000W
0?ooo`L00000;03oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00P0oooo000?0?oo
o`030000003oool0oooo0200oooo00<000000?ooo`3oool07P3oool9000002P0oooo3000000A0?oo
o`@000000P3oool6000002H0oooo1`00000/0?ooo`030000003oool0oooo00d0oooo00<000000?oo
o`3oool01`3oool00100oooo0P00000Q0?ooo`030000003oool0oooo01d0oooo2000000Y0?ooo`D0
000000<0oooo0000000000000P00000C0?ooo`030000003oool0000000X000009P3oool6000002`0
oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`070?ooo`004P3oool00`000000oooo
0?ooo`0O0?ooo`030000003oool0oooo01`0oooo2000000Y0?ooo`P000006@3oool4000000030?oo
o`000000000000@000008`3oool7000002d0oooo00<000000?ooo`3oool03@3oool00`000000oooo
0?ooo`060?ooo`004`3oool00`000000oooo0?ooo`0O0?ooo`030000003oool0oooo01/0oooo2000
000W0?ooo`T000006`3oool;00000280oooo2000000]0?ooo`030000003oool0oooo00d0oooo00<0
00000?ooo`3oool01@3oool001@0oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`0K
0?ooo`L000009P3oool3000000030?ooo`000000000000<000007@3oool;00000280oooo1`00000]
0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?oo
o`3oool07`3oool00`000000oooo0?ooo`0I0?ooo`L000009@3oool6000000030?ooo`0000000000
0200oooo0P0000000`3oool000000000000600000240oooo1`00000^0?ooo`030000003oool0oooo
00d0oooo00<000000?ooo`3oool0103oool001H0oooo00<000000?ooo`3oool07`3oool00`000000
oooo0?ooo`0H0?ooo`L000009@3oool5000000030?ooo`00000000000240oooo00<000000?ooo`00
00002P00000O0?ooo`L00000;`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00<0
oooo000G0?ooo`800000803oool00`000000oooo0?ooo`0G0?ooo`L00000903oool9000002@0oooo
2`00000N0?ooo`L00000<03oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00<0oooo
000I0?ooo`030000003oool0oooo01h0oooo0P00000G0?ooo`L000008`3oool9000002H0oooo2`00
000M0?ooo`L00000<03oool00`000000oooo0?ooo`0<0?ooo`800000103oool001X0oooo00<00000
0?ooo`3oool07`3oool00`000000oooo0?ooo`0D0?ooo`@0000000<0oooo0000000000008P3oool9
000002P0oooo0P000000103oool000000000003oool5000001`0oooo1`00000a0?ooo`030000003o
ool0oooo00L0oooo100000000`3oool000000?ooo`030?ooo`006`3oool00`000000oooo0?ooo`0O
0?ooo`030000003oool0oooo01<0oooo1`00000Q0?ooo`@0000000<0oooo0000000000000P00000Y
0?ooo``000006P3oool800000380oooo00<000000?ooo`3oool00`3oool3000000D0oooo00<00000
0?ooo`3oool00P3oool001`0oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`0C0?oo
o`H00000803oool:000002T0oooo3P00000H0?ooo`@0000000<0oooo000000000000<`3oool00`00
0000oooo00000003000000P0oooo00<000000?ooo`3oool00P3oool001d0oooo0P00000P0?ooo`03
0000003oool0oooo0180oooo1`00000N0?ooo`X00000;03oool6000000030?ooo`000000000000D0
00005P3oool700000380oooo0`00000<0?ooo`030000003oool0oooo0080oooo000O0?ooo`030000
003oool0oooo01h0oooo00<000000?ooo`3oool04@3oool7000001`0oooo20000000103oool00000
00000000000/0?ooo`@0000000<0oooo0000000000001P0000000`3oool000000000000B0?ooo`T0
0000;P3oool4000000<0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`010?ooo`00
803oool00`000000oooo0?ooo`0N0?ooo`030000003oool0oooo00l0oooo2@00000J0?ooo``00000
;P3oool00`000000oooo00000002000000030?ooo`000000000000D000000P3oool200000100oooo
2@00000[0?ooo`<000001`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo0040oooo
000Q0?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3oool03P3oool9000001P0oooo2000
00020?ooo`@00000;P3oool00`000000oooo0?ooo`0200000080oooo1`0000030?ooo`<00000303o
ool:000002L0oooo1000000;0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool00@3o
ool00280oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`0>0?ooo`T000005P3oool2
000000030?ooo`000000000000<0000000H0oooo00000000000000000?ooo`00000`0?ooo`H00000
00<0oooo00000000000020000000103oool000000000000000080?ooo`/000009@3oool300000100
oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`010?ooo`008`3oool00`000000oooo
0?ooo`0N0?ooo`8000003`3oool8000001@0oooo0P0000000`3oool0000000000005000000040?oo
o`00000000000?ooo`800000<03oool00`000000oooo0?ooo`02000000030?ooo`000000000000T0
000000@0oooo0000003oool0oooo100000020?ooo`d000008P3oool3000001@0oooo00<000000?oo
o`3oool01`3oool00`000000oooo0?ooo`010?ooo`00903oool200000200oooo00<000000?ooo`3o
ool0303oool900000140oooo0P0000020?ooo`L0000000<0oooo0000000000000`00000a0?ooo`80
000000<0oooo0000000000000`3oool<000000<0oooo4@00000N0?ooo`@000005`3oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo0040oooo000V0?ooo`030000003oool0oooo01h0oooo
00<000000?ooo`3oool02`3oool;000000d0oooo2@0000001P3oool000000000003oool000000?oo
o`@00000<@3oool01`000000oooo000000000000oooo0000003oool02`0000000`3oool000000000
000>000000040?ooo`0000000000000001`0oooo0`00000L0?ooo`030000003oool0oooo00H0oooo
00<000000?ooo`3oool00@3oool002L0oooo00<000000?ooo`3oool07P3oool00`000000oooo0?oo
o`0;0?ooo`d00000203oool300000080oooo2P0000000`3oool000000?ooo`0300000380oooo0`00
00000`3oool00000000000020?ooo`040000003oool000000?ooo`X0000000<0oooo000000000000
3@00000H0?ooo`@00000803oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0040oooo
000X0?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3oool02P3oool?000000030?ooo`00
0000oooo00<0000000<0oooo0000003oool00P0000001@3oool00000000000000000oooo00@00000
0P3oool2000000030?ooo`00000000000380oooo00<000000?ooo`0000000P0000001@3oool00000
0?ooo`000000oooo008000000P3oool@000000030?ooo`000000000000@000005P3oool3000002@0
oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`010?ooo`00:@3oool00`000000oooo
0?ooo`0N0?ooo`030000003oool0oooo00T0oooo1P0000000`3oool000000000000:000000030?oo
o`000000oooo008000000`3oool7000000040?ooo`00000000000?ooo`80000000<0oooo0000003o
ool0<@3oool010000000oooo0000000000020?ooo`030000003oool000000080oooo00<000000?oo
o`0000002P0000000`3oool000000?ooo`0:00000180oooo1000000X0?ooo`030000003oool0oooo
00D0oooo0@0000010?ooo`40oooo000Z0?ooo`8000007`3oool00`000000oooo0?ooo`080?oooaP0
00000P3oool6000000030?ooo`000000oooo00D0000000<0oooo0000003oool0<@3oool00`000000
oooo00000003000000030?ooo`00000000000080oooo300000001@3oool00000000000000000oooo
00@0000000<0oooo0000000000000P00000?0?ooo`<00000;@3oool00`000000oooo0?ooo`040?oo
o`4000000@3oool10?ooo`00;03oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo00T0
oooo200000000`3oool000000?ooo`05000000050?ooo`00000000000000003oool02@0000001@3o
ool000000?ooo`000000oooo008000000P3oool00`000000oooo0?ooo`0a0?ooo`<000000P3oool3
000000030?ooo`00000000000080000000<0oooo000000000000300000000`3oool0000000000004
000000`0oooo1000000`0?ooo`030000003oool0oooo00@0oooo0@0000010?ooo`40oooo000]0?oo
o`030000003oool0oooo01d0oooo00<000000?ooo`3oool02@3oool6000000030?ooo`0000000000
00/0000000<0oooo0000000000001@0000030?ooo`80000000H0oooo00000000000000000?ooo`00
000b0?ooo`80000000<0oooo0000003oool00P3oool500000080oooo0P0000000`3oool000000000
000A000000T0oooo0`00000e0?ooo`030000003oool0oooo00<0oooo0@0000010?ooo`40oooo000^
0?ooo`030000003oool0oooo01d0oooo0P0000090?ooo`/0000000<0oooo0000003oool00P000000
0`3oool000000000000:00000080oooo0`0000000`3oool000000?ooo`0200000380oooo0`000000
103oool000000?ooo`3oool200000080oooo600000060?ooo`@00000>@3oool00`000000oooo0?oo
o`020?ooo`4000000@3oool10?ooo`00;`3oool00`000000oooo0?ooo`0N0?ooo`030000003oool0
oooo00H0oooo100000000`3oool0000000000008000000030?ooo`000000000000P0000000<0oooo
0000003oool00`0000030?ooo`040000003oool00000000003<0oooo00<000000?ooo`0000001000
00001@3oool000000?ooo`000000oooo0080000000<0oooo0000000000004@0000030?ooo`<00000
?@3oool00`000000oooo0?ooo`020?ooo`4000000@3oool10?ooo`00<03oool00`000000oooo0?oo
o`0N0?ooo`030000003oool0oooo00H0oooo200000000`3oool0000000000005000000030?ooo`00
0000000000<0000000<0oooo0000000000001`0000020?ooo`040000003oool00000000003<0oooo
00<000000?ooo`000000100000000`3oool0000000000002000000030?ooo`000000oooo01H00000
@@3oool01@000000oooo0?ooo`3oool000000080oooo000a0?ooo`8000007`3oool00`000000oooo
0?ooo`060?ooo`H0000000<0oooo0000000000003`0000020?ooo`040000003oool000000?ooo`80
000000<0oooo0000000000000P3oool00`000000oooo0?ooo`0_0?ooo`030000003oool0oooo0080
000000<0oooo0000000000006P0000160?ooo`040000003oool0oooo00000080oooo000c0?ooo`03
0000003oool0oooo01d0oooo00<000000?ooo`3oool01P3ooolF000000030?ooo`00000000000080
00000P3oool00`000000oooo0000000200000080oooo00<000000?ooo`3oool0;`3oool00`000000
oooo00000002000000030?ooo`000000oooo0080000000D0oooo0000003oool000000?ooo`060000
00030?ooo`000000000000X00000A`3oool00`000000oooo000000020?ooo`00=03oool00`000000
oooo0?ooo`0M0?ooo`030000003oool0oooo00D0oooo100000000`3oool000000?ooo`0300000003
0?ooo`000000oooo00L000000P3oool;000000<0oooo00<000000?ooo`3oool0;`3oool300000080
oooo0`0000000`3oool000000?ooo`04000000030?ooo`000000000000D0000000<0oooo00000000
00002@0000160?ooo`040000003oool0oooo00000040oooo000e0?ooo`030000003oool0oooo01d0
oooo00<000000?ooo`3oool01@3oool6000000030?ooo`000000oooo00d000000P3oool01@000000
oooo000000000000oooo00D0000000<0oooo0000003oool0;`3ooolB000000040?ooo`0000000000
0?ooo`@0000000<0oooo000000000000200000160?ooo`030000003oool000000040oooo000f0?oo
o`030000003oool0oooo01d0oooo00<000000?ooo`3oool0103oool00`000000oooo0000000=0000
00040?ooo`000000000000000080oooo00H000000?ooo`000000oooo0000003oool3000000030?oo
o`000000oooo00<00000;`3oool3000000060?ooo`00000000000?ooo`000000oooo100000000`3o
ool0000000000007000000030?ooo`000000000000`00000AP3oool200000040oooo000g0?ooo`03
0000003oool0oooo01d0oooo00<000000?ooo`3oool0103oool00`000000oooo0000000=00000003
0?ooo`000000oooo00@000000`3oool:000002h0oooo00<000000?ooo`0000004P0000030?ooo`P0
000000<0oooo0000000000001P0000140?ooo`8000000@3oool003P0oooo0P00000N0?ooo`800000
103oool010000000oooo0000003oool9000000030?ooo`000000000000X0000000<0oooo00000000
00000`0000000`3oool0000000000003000002X0oooo0P0000000`3oool000000000000300000006
0?ooo`00000000000?ooo`000000oooo1P0000030?ooo`P0000000<0oooo0000000000001`000000
0`3oool00000000000130?ooo`8000000@3oool003X0oooo00<000000?ooo`3oool07@3oool00`00
0000oooo0?ooo`020?ooo`030000003oool0oooo00H0000000<0oooo0000003oool00P000000203o
ool000000000003oool000000?ooo`000000oooo1P0000020?ooo`@000000P3oool2000002P0oooo
1P0000000`3oool0000000000002000000030?ooo`000000000000D0000000<0oooo0000003oool0
0`3oool@000000030?ooo`000000000000800000?P3oool4000000<0oooo000k0?ooo`030000003o
ool0oooo01d0oooo00@000000?ooo`3oool0oooo3@0000040?ooo`80000000@0oooo0000003oool0
oooo4@00000T0?oooa<0000000D0oooo00000000000000000?ooo`0D000000040?ooo`0000000000
000003X0oooo100000070?ooo`00?03oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo
01T0000000<0oooo0000000000003P00000O0?ooo`d0000000<0oooo0000000000000`0000000`3o
ool000000?ooo`0N000003H0oooo0`00000;0?ooo`00?@3oool00`000000oooo0?ooo`0M0?ooo`d0
000000@0oooo0000000000000000103oool800000080oooo4000000I0?ooob80000000@0oooo0000
00000000oooo3P000000103oool0000000000000000a0?ooo`@000003P3oool003h0oooo0P00000M
0?ooo`T0000000<0oooo0000000000000`0000000`3oool0000000000002000000050?ooo`000000
oooo0000003oool01`000000103oool000000000003oool?00000180oooo300000000`3oool00000
0000000D00000080oooo5`00000/0?ooo`@000004P3oool00400oooo00<000000?ooo`3oool0603o
ool?000000030?ooo`000000000000T0000000@0oooo000000000000oooo7@0000020?ooo`030000
003oool0oooo0080oooo:@0000020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`000000
3@00000W0?ooo`@000005P3oool00440oooo00<000000?ooo`3oool05`3oool<000000030?ooo`00
0000oooo0140000000D0oooo00000000000000000?ooo`0_000000030?ooo`000000000000d00000
503oool=000002<0oooo0`00000J0?ooo`00@P3oool00`000000oooo0?ooo`0F0?ooo`l0000000<0
oooo0000000000000P3oool2000000030?ooo`000000000001L0000000<0oooo0000003oool04@00
00000`3oool000000000000F000000030?ooo`000000oooo01P0oooo00<000000?ooo`3oool02`00
000N0?ooo`@000007@3oool004<0oooo00<000000?ooo`3oool04`3oool6000000030?ooo`000000
00000080000000@0oooo000000000000ooooCP00000P0?ooo`030000003oool0oooo00L000006`3o
ool400000240oooo00140?ooo`030000003oool0oooo0180oooo100000000`3oool000000000000:
000000L0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`000000oooo01T000000P3o
oolK000002P0oooo00H000000?ooo`3oool000000?ooo`00000I0?ooo`<000009@3oool004D0oooo
0P00000B0?ooo`d000005`3oool01@000000oooo0?ooo`000000oooo02X00000B03oool4000002P0
oooo00170?ooo`030000003oool0oooo00l0oooo2@0000040?ooo`030000003oool0oooo01/0oooo
00@000000?ooo`3oool0oooo7@0000020?ooo`030000003oool0oooo04H0oooo1000000/0?ooo`00
B03oool00`000000oooo0?ooo`0<0?ooo`T000001`3oool00`000000oooo0?ooo`0Q0?ooo`040000
003oool0oooo0?ooo`@000001P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo04X0
oooo0`00000`0?ooo`00B@3oool00`000000oooo0?ooo`0;0?ooo`L000002P3oool00`000000oooo
0?ooo`0Q0?ooo`<00000FP3oool4000003<0oooo001:0?ooo`030000003oool0oooo00P0oooo1`00
000=0?ooo`030000003oool0oooo01`0oooo1000001I0?ooo`@00000=`3oool004/0oooo0P000008
0?ooo`H000003`3oool00`000000oooo0?ooo`0H0?ooo`<00000F@3oool4000003/0oooo001=0?oo
o`030000003oool0oooo00H0oooo0`00000B0?ooo`030000003oool0oooo01<0oooo1000001I0?oo
o`<00000?`3oool004h0oooo00<000000?ooo`3oool06`3oool200000100oooo0`00001I0?ooo`@0
0000@P3oool004l0oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`090?ooo`@00000
F03oool4000004H0oooo001@0?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool01@3o
ool3000005T0oooo0`00001:0?ooo`00D@3oool00`000000oooo0?ooo`0L0?ooo`030000003oool0
oooo00@00000F03oool4000004d0oooo001B0?ooo`8000007@3oool2000005P0oooo1000001A0?oo
o`00E03oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo05@0oooo0`00001E0?ooo`00
E@3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo0500oooo1000001H0?ooo`00EP3o
ool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo04`0oooo1000001L0?ooo`00E`3oool0
0`000000oooo0?ooo`0G0?ooo`030000003oool0oooo04P0oooo1000001P0?ooo`00F03oool20000
01L0oooo00<000000?ooo`3oool0A@3oool3000006@0oooo001J0?ooo`030000003oool0oooo01@0
oooo00<000000?ooo`3oool0@@3oool4000006L0oooo001K0?ooo`030000003oool0oooo01<0oooo
00<000000?ooo`3oool0?@3oool4000006/0oooo001L0?ooo`030000003oool0oooo0180oooo00<0
00000?ooo`3oool0>P3oool3000006l0oooo001M0?ooo`030000003oool0oooo0140oooo00<00000
0?ooo`3oool0=P3oool400000780oooo001N0?ooo`030000003oool0oooo0100oooo00<000000?oo
o`3oool0<P3oool4000007H0oooo001O0?ooo`800000403oool00`000000oooo0?ooo`0^0?ooo`@0
0000NP3oool00640oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0[0?ooo`<00000
OP3oool00680oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0X0?ooo`@00000P@3o
ool006<0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0T0?ooo`@00000Q@3oool0
06@0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0Q0?ooo`<00000R@3oool006D0
oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0M0?ooo`@00000S03oool006H0oooo
0P0000080?ooo`030000003oool0oooo01T0oooo1000002@0?ooo`00J03oool00`000000oooo0?oo
o`050?ooo`030000003oool0oooo01H0oooo0`00002D0?ooo`00J@3oool00`000000oooo0?ooo`04
0?ooo`030000003oool0oooo0180oooo1000002G0?ooo`00JP3oool00`000000oooo0?ooo`030?oo
o`030000003oool0oooo00h0oooo1000002K0?ooo`00J`3oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo00X0oooo1000002O0?ooo`00K03oool200000080oooo00<000000?ooo`3oool0
1`3oool300000:<0oooo001^0?ooo`030000003oool0000000D0oooo1000002V0?ooo`00K`3oool2
000000030?ooo`000000000000800000ZP3oool00700oooo0P00002^0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {197.438, 0}} -> {-0.00079212, 0.12299, \
0.00333263, 0.00333263}}]
}, Open  ]],

Cell[TextData[{
  StyleBox["GraphPlot", "MR"],
  StyleBox[" and ", "TR"],
  StyleBox["GraphPlot3D", "MR"],
  StyleBox[" accept the following options, as well as options for ", "TR"],
  StyleBox["Graphics", "MR"],
  StyleBox[" and", "TR"],
  StyleBox[" ", ""],
  StyleBox["Graphics3D", "MR"],
  "."
}], "Text"],

Cell[BoxData[GridBox[{
        {
          StyleBox[\(option\ name\),
            "TI"], 
          StyleBox[\(default\ value\),
            "TI"], " "},
        {"Method", "Automatic", 
          StyleBox[\(method\ used\ to\ lay\ out\ the\ graph\),
            "TR"]},
        {"VertexStyleFunction", "None", 
          StyleBox[\(describes\ how\ vertices\ are\ drawn\),
            "TR"]},
        {"EdgeStyleFunction", "None", 
          StyleBox[\(describes\ how\ edges\ are\ drawn\),
            "TR"]},
        {"PlotStyle", "Automatic", 
          StyleBox[\(sets\ style\ in\ which\ objects\ are\ drawn\),
            "TR"]},
        {"RandomSeed", "Automatic", 
          RowBox[{
            
            StyleBox[\(used\ for\ initial\ vertex\ placement\ in\ the\ spring\
\ model\ and\ the\ spring\[Hyphen]electrical\ model\),
              "TR"], 
            StyleBox[",",
              "TR"], 
            StyleBox[" ",
              "TR"], 
            RowBox[{
              StyleBox["and",
                "TR"], 
              StyleBox[" ",
                "TR"], 
              StyleBox["for",
                "TR"], 
              StyleBox[" ",
                "TR"], 
              StyleBox["selecting",
                "TR"], 
              StyleBox[" ",
                "TR"], 
              StyleBox["the",
                "TR"], 
              StyleBox[" ",
                "TR"], 
              StyleBox["first",
                "TR"], 
              StyleBox[" ",
                "TR"], 
              StyleBox["of",
                "TR"], 
              StyleBox[" ",
                "TR"], 
              StyleBox["the",
                "TR"], 
              StyleBox[" ",
                "TR"], 
              StyleBox["k",
                "TI",
                FontSlant->"Italic"], 
              StyleBox[" ",
                "TR",
                FontSlant->"Italic"], 
              StyleBox["centers",
                "TR"], 
              StyleBox[" ",
                "TR"], 
              StyleBox["in",
                "TR"], 
              StyleBox[" ",
                "TR"], 
              StyleBox["the",
                "TR"], 
              StyleBox[" ",
                "TR"], 
              StyleBox["high\[Hyphen]dimensional",
                "TR"], 
              StyleBox[" ",
                "TR"], 
              StyleBox["embedding",
                "TR"], 
              StyleBox[" ",
                "TR"], 
              StyleBox["method",
                "TR"]}]}]},
        {"VertexCoordinates", "None", 
          StyleBox[\(user\[Hyphen]supplied\ vertex\ coordinates\),
            FontFamily->"Times"]}
        }]], "DefinitionBox3Col",
  ShowStringCharacters->True,
  GridBoxOptions->{RowLines->{0.5, False}}],

Cell[TextData[{
  "Options for ",
  StyleBox["GraphPlot", "MR"],
  " and ",
  StyleBox["GraphPlot3D", "MR"],
  "."
}], "Caption"],

Cell["\<\
This imports a data set and draws the graph in blue, using the \
spring model method.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(a = 
        Import["\<LinearAlgebraExamples/Data/nos6.mtx\>"];\)\), "\
\[IndentingNewLine]", 
    \(\(GraphPlot[a, \ Method -> "\<SpringModel\>", 
        PlotStyle \[Rule] {Blue, \ PointSize[0.014]}];\)\)}], "Input",
  CellLabel->"In[7]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .72536 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.500023 0.476213 0.402966 0.476213 [
[ 0 0 0 0 ]
[ 1 .72536 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 1 r
.5 Mabswid
[ ] 0 setdash
.49999 .01727 m
.48227 .03274 L
s
.49999 .01727 m
.51772 .03274 L
s
.48227 .03274 m
.46474 .04815 L
s
.48227 .03274 m
.5 .04899 L
s
.46474 .04815 m
.44833 .06347 L
s
.46474 .04815 m
.48249 .0651 L
s
.44833 .06347 m
.43242 .07883 L
s
.44833 .06347 m
.466 .08091 L
s
.43242 .07883 m
.41608 .09491 L
s
.43242 .07883 m
.45001 .09641 L
s
.41608 .09491 m
.39993 .11093 L
s
.41608 .09491 m
.43367 .11251 L
s
.39993 .11093 m
.38386 .12693 L
s
.39993 .11093 m
.41751 .12855 L
s
.38386 .12693 m
.36779 .14295 L
s
.38386 .12693 m
.40142 .14459 L
s
.36779 .14295 m
.35171 .15897 L
s
.36779 .14295 m
.38533 .16067 L
s
.35171 .15897 m
.33564 .17492 L
s
.35171 .15897 m
.36924 .17673 L
s
.33564 .17492 m
.31954 .1908 L
s
.33564 .17492 m
.35314 .19274 L
s
.31954 .1908 m
.3034 .20659 L
s
.31954 .1908 m
.337 .20869 L
s
.3034 .20659 m
.28718 .22229 L
s
.3034 .20659 m
.32081 .22455 L
s
.28718 .22229 m
.27088 .2379 L
s
.28718 .22229 m
.30453 .24032 L
s
.27088 .2379 m
.25449 .25344 L
s
.27088 .2379 m
.28816 .25599 L
s
.25449 .25344 m
.23801 .26892 L
s
.25449 .25344 m
.2717 .27158 L
s
.23801 .26892 m
.22146 .28436 L
s
.23801 .26892 m
.25516 .28709 L
s
.22146 .28436 m
.20485 .29978 L
s
.22146 .28436 m
.23854 .30257 L
s
.20485 .29978 m
.18819 .3152 L
s
.20485 .29978 m
.22187 .31801 L
s
.18819 .3152 m
.17149 .33062 L
s
.18819 .3152 m
.20517 .33344 L
s
.17149 .33062 m
.15476 .34606 L
s
.17149 .33062 m
.18844 .34887 L
s
.15476 .34606 m
.13806 .36152 L
s
.15476 .34606 m
.17169 .36432 L
s
.13806 .36152 m
.12139 .37698 L
s
.13806 .36152 m
.15495 .37979 L
s
.12139 .37698 m
.10473 .39252 L
s
.12139 .37698 m
.13827 .39527 L
s
.10473 .39252 m
.08801 .40823 L
s
.10473 .39252 m
.12161 .41081 L
s
.08801 .40823 m
.07204 .42354 L
s
.08801 .40823 m
.10487 .42654 L
s
.07204 .42354 m
.05607 .43934 L
s
.07204 .42354 m
.08876 .44193 L
s
.05607 .43934 m
.03999 .45624 L
s
.05607 .43934 m
.07231 .45779 L
s
.03999 .45624 m
.02381 .47329 L
s
.03999 .45624 m
.05553 .47465 L
s
.02381 .47329 m
.03858 .49168 L
s
.51772 .03274 m
.5 .04899 L
s
.51772 .03274 m
.53525 .04814 L
s
.5 .04899 m
.48249 .0651 L
s
.5 .04899 m
.5175 .06509 L
s
.48249 .0651 m
.466 .08091 L
s
.48249 .0651 m
.5 .08222 L
s
.466 .08091 m
.45001 .09641 L
s
.466 .08091 m
.48356 .09805 L
s
.45001 .09641 m
.43367 .11251 L
s
.45001 .09641 m
.46754 .11368 L
s
.43367 .11251 m
.41751 .12855 L
s
.43367 .11251 m
.45113 .12988 L
s
.41751 .12855 m
.40142 .14459 L
s
.41751 .12855 m
.43493 .14599 L
s
.40142 .14459 m
.38533 .16067 L
s
.40142 .14459 m
.41881 .16209 L
s
.38533 .16067 m
.36924 .17673 L
s
.38533 .16067 m
.40269 .17822 L
s
.36924 .17673 m
.35314 .19274 L
s
.36924 .17673 m
.38656 .19433 L
s
.35314 .19274 m
.337 .20869 L
s
.35314 .19274 m
.37043 .21039 L
s
.337 .20869 m
.32081 .22455 L
s
.337 .20869 m
.35425 .22639 L
s
.32081 .22455 m
.30453 .24032 L
s
.32081 .22455 m
.33801 .24231 L
s
.30453 .24032 m
.28816 .25599 L
s
.30453 .24032 m
.32168 .25814 L
s
.28816 .25599 m
.2717 .27158 L
s
.28816 .25599 m
.30526 .27386 L
s
.2717 .27158 m
.25516 .28709 L
s
.2717 .27158 m
.28875 .28949 L
s
.25516 .28709 m
.23854 .30257 L
s
.25516 .28709 m
.27215 .30505 L
s
.23854 .30257 m
.22187 .31801 L
s
.23854 .30257 m
.25548 .32056 L
s
.22187 .31801 m
.20517 .33344 L
s
.22187 .31801 m
.23877 .33603 L
s
.20517 .33344 m
.18844 .34887 L
s
.20517 .33344 m
.22202 .3515 L
s
.18844 .34887 m
.17169 .36432 L
s
.18844 .34887 m
.20525 .36695 L
s
.17169 .36432 m
.15495 .37979 L
s
.17169 .36432 m
.18847 .38242 L
s
.15495 .37979 m
.13827 .39527 L
s
.15495 .37979 m
.1717 .39791 L
s
.13827 .39527 m
.12161 .41081 L
s
.13827 .39527 m
.15498 .41341 L
s
.12161 .41081 m
.10487 .42654 L
s
.12161 .41081 m
.13825 .429 L
s
.10487 .42654 m
.08876 .44193 L
s
.10487 .42654 m
.12143 .44478 L
s
.08876 .44193 m
.07231 .45779 L
s
.08876 .44193 m
.10519 .46019 L
s
.07231 .45779 m
.05553 .47465 L
s
.07231 .45779 m
.08873 .47601 L
s
.05553 .47465 m
.03858 .49168 L
s
.05553 .47465 m
.07093 .49282 L
s
.03858 .49168 m
.05329 .50986 L
s
.53525 .04814 m
.5175 .06509 L
s
.53525 .04814 m
.55166 .06346 L
s
.5175 .06509 m
.5 .08222 L
s
.5175 .06509 m
.53399 .0809 L
s
.5 .08222 m
.48356 .09805 L
s
.5 .08222 m
.51644 .09805 L
s
.48356 .09805 m
.46754 .11368 L
s
.48356 .09805 m
.5 .11404 L
s
.46754 .11368 m
.45113 .12988 L
s
.46754 .11368 m
.48394 .12984 L
s
.45113 .12988 m
.43493 .14599 L
s
.45113 .12988 m
.46749 .14616 L
s
.43493 .14599 m
.41881 .16209 L
s
.43493 .14599 m
.45127 .16234 L
s
.41881 .16209 m
.40269 .17822 L
s
.41881 .16209 m
.43511 .17851 L
s
.40269 .17822 m
.38656 .19433 L
s
.40269 .17822 m
.41896 .1947 L
s
.38656 .19433 m
.37043 .21039 L
s
.38656 .19433 m
.4028 .21087 L
s
.37043 .21039 m
.35425 .22639 L
s
.37043 .21039 m
.38663 .22698 L
s
.35425 .22639 m
.33801 .24231 L
s
.35425 .22639 m
.37042 .24304 L
s
.33801 .24231 m
.32168 .25814 L
s
.33801 .24231 m
.35415 .259 L
s
.32168 .25814 m
.30526 .27386 L
s
.32168 .25814 m
.33779 .27487 L
s
.30526 .27386 m
.28875 .28949 L
s
.30526 .27386 m
.32133 .29063 L
s
.28875 .28949 m
.27215 .30505 L
s
.28875 .28949 m
.30477 .30629 L
s
.27215 .30505 m
.25548 .32056 L
s
.27215 .30505 m
.28812 .32188 L
s
.25548 .32056 m
.23877 .33603 L
s
.25548 .32056 m
.27141 .33742 L
s
.23877 .33603 m
.22202 .3515 L
s
.23877 .33603 m
.25466 .35293 L
s
.22202 .3515 m
.20525 .36695 L
s
.22202 .3515 m
.23787 .36842 L
s
.20525 .36695 m
.18847 .38242 L
s
.20525 .36695 m
.22106 .3839 L
s
.18847 .38242 m
.1717 .39791 L
s
.18847 .38242 m
.20424 .3994 L
s
.1717 .39791 m
.15498 .41341 L
s
.1717 .39791 m
.18742 .41492 L
s
.15498 .41341 m
.13825 .429 L
s
.15498 .41341 m
.17064 .43044 L
s
.13825 .429 m
.12143 .44478 L
s
.13825 .429 m
.15385 .44604 L
s
.12143 .44478 m
.10519 .46019 L
s
.12143 .44478 m
.13691 .46186 L
s
.10519 .46019 m
.08873 .47601 L
s
.10519 .46019 m
.12052 .4773 L
s
.08873 .47601 m
.07093 .49282 L
s
.08873 .47601 m
.1039 .49311 L
s
.07093 .49282 m
.05329 .50986 L
s
.07093 .49282 m
.08608 .50998 L
s
.05329 .50986 m
.06798 .52692 L
s
.55166 .06346 m
.53399 .0809 L
s
.55166 .06346 m
.56758 .07882 L
s
.53399 .0809 m
.51644 .09805 L
s
.53399 .0809 m
.54999 .0964 L
s
.51644 .09805 m
.5 .11404 L
s
.51644 .09805 m
.53247 .11368 L
s
.5 .11404 m
.48394 .12984 L
s
.5 .11404 m
.51607 .12984 L
s
.48394 .12984 m
.46749 .14616 L
s
.48394 .12984 m
.5 .14577 L
s
.46749 .14616 m
.45127 .16234 L
s
.46749 .14616 m
.48354 .16218 L
s
.45127 .16234 m
.43511 .17851 L
s
.45127 .16234 m
.4673 .17844 L
s
.43511 .17851 m
.41896 .1947 L
s
.43511 .17851 m
.45113 .19468 L
s
.41896 .1947 m
.4028 .21087 L
s
.41896 .1947 m
.43495 .21094 L
s
.4028 .21087 m
.38663 .22698 L
s
.4028 .21087 m
.41877 .22716 L
s
.38663 .22698 m
.37042 .24304 L
s
.38663 .22698 m
.40258 .24334 L
s
.37042 .24304 m
.35415 .259 L
s
.37042 .24304 m
.38635 .25944 L
s
.35415 .259 m
.33779 .27487 L
s
.35415 .259 m
.37005 .27546 L
s
.33779 .27487 m
.32133 .29063 L
s
.33779 .27487 m
.35367 .29137 L
s
.32133 .29063 m
.30477 .30629 L
s
.32133 .29063 m
.33718 .30715 L
s
.30477 .30629 m
.28812 .32188 L
s
.30477 .30629 m
.32057 .32283 L
s
.28812 .32188 m
.27141 .33742 L
s
.28812 .32188 m
.30388 .33844 L
s
.27141 .33742 m
.25466 .35293 L
s
.27141 .33742 m
.28712 .354 L
s
.25466 .35293 m
.23787 .36842 L
s
.25466 .35293 m
.27032 .36953 L
s
.23787 .36842 m
.22106 .3839 L
s
.23787 .36842 m
.25349 .38505 L
s
.22106 .3839 m
.20424 .3994 L
s
.22106 .3839 m
.23665 .40056 L
s
.20424 .3994 m
.18742 .41492 L
s
.20424 .3994 m
.21978 .41608 L
s
.18742 .41492 m
.17064 .43044 L
s
.18742 .41492 m
.20291 .43161 L
s
.17064 .43044 m
.15385 .44604 L
s
.17064 .43044 m
.18607 .44716 L
s
.15385 .44604 m
.13691 .46186 L
s
.15385 .44604 m
.16921 .46277 L
s
.13691 .46186 m
.12052 .4773 L
s
.13691 .46186 m
.1522 .47859 L
s
.12052 .4773 m
.1039 .49311 L
s
.12052 .4773 m
.13567 .49403 L
s
.1039 .49311 m
.08608 .50998 L
s
.1039 .49311 m
.1189 .50979 L
s
.08608 .50998 m
.06798 .52692 L
s
.08608 .50998 m
.10097 .52663 L
s
.06798 .52692 m
.08274 .54349 L
s
.56758 .07882 m
.54999 .0964 L
s
.56758 .07882 m
.58392 .09489 L
s
.54999 .0964 m
.53247 .11368 L
s
.54999 .0964 m
.56634 .1125 L
s
.53247 .11368 m
.51607 .12984 L
s
.53247 .11368 m
.54887 .12988 L
s
.51607 .12984 m
.5 .14577 L
s
.51607 .12984 m
.53252 .14616 L
s
.5 .14577 m
.48354 .16218 L
s
.5 .14577 m
.51647 .16218 L
s
.48354 .16218 m
.4673 .17844 L
s
.48354 .16218 m
.50001 .17867 L
s
.4673 .17844 m
.45113 .19468 L
s
.4673 .17844 m
.48376 .19501 L
s
.45113 .19468 m
.43495 .21094 L
s
.45113 .19468 m
.46757 .21133 L
s
.43495 .21094 m
.41877 .22716 L
s
.43495 .21094 m
.45137 .22765 L
s
.41877 .22716 m
.40258 .24334 L
s
.41877 .22716 m
.43518 .24395 L
s
.40258 .24334 m
.38635 .25944 L
s
.40258 .24334 m
.41898 .26018 L
s
.38635 .25944 m
.37005 .27546 L
s
.38635 .25944 m
.40274 .27635 L
s
.37005 .27546 m
.35367 .29137 L
s
.37005 .27546 m
.38643 .29242 L
s
.35367 .29137 m
.33718 .30715 L
s
.35367 .29137 m
.37003 .30836 L
s
.33718 .30715 m
.32057 .32283 L
s
.33718 .30715 m
.3535 .32417 L
s
.32057 .32283 m
.30388 .33844 L
s
.32057 .32283 m
.33685 .33986 L
s
.30388 .33844 m
.28712 .354 L
s
.30388 .33844 m
.32011 .35548 L
s
.28712 .354 m
.27032 .36953 L
s
.28712 .354 m
.3033 .37106 L
s
.27032 .36953 m
.25349 .38505 L
s
.27032 .36953 m
.28646 .38661 L
s
.25349 .38505 m
.23665 .40056 L
s
.25349 .38505 m
.26958 .40214 L
s
.23665 .40056 m
.21978 .41608 L
s
.23665 .40056 m
.25269 .41767 L
s
.21978 .41608 m
.20291 .43161 L
s
.21978 .41608 m
.23578 .43321 L
s
.20291 .43161 m
.18607 .44716 L
s
.20291 .43161 m
.21886 .44876 L
s
.18607 .44716 m
.16921 .46277 L
s
.18607 .44716 m
.20197 .46431 L
s
.16921 .46277 m
.1522 .47859 L
s
.16921 .46277 m
.18504 .47992 L
s
.1522 .47859 m
.13567 .49403 L
s
.1522 .47859 m
.16796 .49574 L
s
.13567 .49403 m
.1189 .50979 L
s
.13567 .49403 m
.15136 .51116 L
s
.1189 .50979 m
.10097 .52663 L
s
.1189 .50979 m
.13448 .52687 L
s
.10097 .52663 m
.08274 .54349 L
s
.10097 .52663 m
.11647 .54365 L
s
.08274 .54349 m
.09824 .56051 L
s
.58392 .09489 m
.56634 .1125 L
s
.58392 .09489 m
.60007 .11091 L
s
.56634 .1125 m
.54887 .12988 L
s
.56634 .1125 m
.5825 .12853 L
s
.54887 .12988 m
.53252 .14616 L
s
.54887 .12988 m
.56508 .14598 L
s
.53252 .14616 m
.51647 .16218 L
s
.53252 .14616 m
.54875 .16233 L
s
.51647 .16218 m
.50001 .17867 L
s
.51647 .16218 m
.53271 .17843 L
s
.50001 .17867 m
.48376 .19501 L
s
.50001 .17867 m
.51626 .19501 L
s
.48376 .19501 m
.46757 .21133 L
s
.48376 .19501 m
.50001 .21143 L
s
.46757 .21133 m
.45137 .22765 L
s
.46757 .21133 m
.48382 .22781 L
s
.45137 .22765 m
.43518 .24395 L
s
.45137 .22765 m
.46761 .24421 L
s
.43518 .24395 m
.41898 .26018 L
s
.43518 .24395 m
.45142 .26057 L
s
.41898 .26018 m
.40274 .27635 L
s
.41898 .26018 m
.43521 .27687 L
s
.40274 .27635 m
.38643 .29242 L
s
.40274 .27635 m
.41896 .2931 L
s
.38643 .29242 m
.37003 .30836 L
s
.38643 .29242 m
.40265 .30922 L
s
.37003 .30836 m
.3535 .32417 L
s
.37003 .30836 m
.38624 .32521 L
s
.3535 .32417 m
.33685 .33986 L
s
.3535 .32417 m
.36969 .34104 L
s
.33685 .33986 m
.32011 .35548 L
s
.33685 .33986 m
.35299 .35673 L
s
.32011 .35548 m
.3033 .37106 L
s
.32011 .35548 m
.33619 .37235 L
s
.3033 .37106 m
.28646 .38661 L
s
.3033 .37106 m
.31933 .38794 L
s
.28646 .38661 m
.26958 .40214 L
s
.28646 .38661 m
.30244 .40351 L
s
.26958 .40214 m
.25269 .41767 L
s
.26958 .40214 m
.28553 .41906 L
s
.25269 .41767 m
.23578 .43321 L
s
.25269 .41767 m
.2686 .4346 L
s
.23578 .43321 m
.21886 .44876 L
s
.23578 .43321 m
.25165 .45015 L
s
.21886 .44876 m
.20197 .46431 L
s
.21886 .44876 m
.23469 .46571 L
s
.20197 .46431 m
.18504 .47992 L
s
.20197 .46431 m
.21774 .48126 L
s
.18504 .47992 m
.16796 .49574 L
s
.18504 .47992 m
.20077 .49686 L
s
.16796 .49574 m
.15136 .51116 L
s
.16796 .49574 m
.18362 .51266 L
s
.15136 .51116 m
.13448 .52687 L
s
.15136 .51116 m
.16695 .52805 L
s
.13448 .52687 m
.11647 .54365 L
s
.13448 .52687 m
.15001 .54374 L
s
.11647 .54365 m
.09824 .56051 L
s
.11647 .54365 m
.13194 .56047 L
s
.09824 .56051 m
.11373 .57734 L
s
.60007 .11091 m
.5825 .12853 L
s
.60007 .11091 m
.61615 .12691 L
s
.5825 .12853 m
.56508 .14598 L
s
.5825 .12853 m
.5986 .14457 L
s
.56508 .14598 m
.54875 .16233 L
s
.56508 .14598 m
.58121 .16207 L
s
.54875 .16233 m
.53271 .17843 L
s
.54875 .16233 m
.5649 .1785 L
s
.53271 .17843 m
.51626 .19501 L
s
.53271 .17843 m
.54889 .19467 L
s
.51626 .19501 m
.50001 .21143 L
s
.51626 .19501 m
.53245 .21132 L
s
.50001 .21143 m
.48382 .22781 L
s
.50001 .21143 m
.51621 .22781 L
s
.48382 .22781 m
.46761 .24421 L
s
.48382 .22781 m
.50002 .24427 L
s
.46761 .24421 m
.45142 .26057 L
s
.46761 .24421 m
.48381 .26073 L
s
.45142 .26057 m
.43521 .27687 L
s
.45142 .26057 m
.46761 .27717 L
s
.43521 .27687 m
.41896 .2931 L
s
.43521 .27687 m
.4514 .29354 L
s
.41896 .2931 m
.40265 .30922 L
s
.41896 .2931 m
.43516 .30984 L
s
.40265 .30922 m
.38624 .32521 L
s
.40265 .30922 m
.41885 .32603 L
s
.38624 .32521 m
.36969 .34104 L
s
.38624 .32521 m
.40244 .34207 L
s
.36969 .34104 m
.35299 .35673 L
s
.36969 .34104 m
.38588 .35791 L
s
.35299 .35673 m
.33619 .37235 L
s
.35299 .35673 m
.36911 .37357 L
s
.33619 .37235 m
.31933 .38794 L
s
.33619 .37235 m
.35225 .38919 L
s
.31933 .38794 m
.30244 .40351 L
s
.31933 .38794 m
.33534 .40479 L
s
.30244 .40351 m
.28553 .41906 L
s
.30244 .40351 m
.3184 .42037 L
s
.28553 .41906 m
.2686 .4346 L
s
.28553 .41906 m
.30145 .43593 L
s
.2686 .4346 m
.25165 .45015 L
s
.2686 .4346 m
.28448 .45148 L
s
.25165 .45015 m
.23469 .46571 L
s
.25165 .45015 m
.2675 .46704 L
s
.23469 .46571 m
.21774 .48126 L
s
.23469 .46571 m
.2505 .4826 L
s
.21774 .48126 m
.20077 .49686 L
s
.21774 .48126 m
.23352 .49814 L
s
.20077 .49686 m
.18362 .51266 L
s
.20077 .49686 m
.2165 .51373 L
s
.18362 .51266 m
.16695 .52805 L
s
.18362 .51266 m
.1993 .5295 L
s
.16695 .52805 m
.15001 .54374 L
s
.16695 .52805 m
.18257 .54485 L
s
.15001 .54374 m
.13194 .56047 L
s
.15001 .54374 m
.16557 .5605 L
s
.13194 .56047 m
.11373 .57734 L
s
.13194 .56047 m
.14746 .57721 L
s
.11373 .57734 m
.12923 .59406 L
s
.61615 .12691 m
.5986 .14457 L
s
.61615 .12691 m
.63223 .14293 L
s
.5986 .14457 m
.58121 .16207 L
s
.5986 .14457 m
.61469 .16065 L
s
.58121 .16207 m
.5649 .1785 L
s
.58121 .16207 m
.59733 .1782 L
s
.5649 .1785 m
.54889 .19467 L
s
.5649 .1785 m
.58107 .19468 L
s
.54889 .19467 m
.53245 .21132 L
s
.54889 .19467 m
.56508 .21092 L
s
.53245 .21132 m
.51621 .22781 L
s
.53245 .21132 m
.54865 .22764 L
s
.51621 .22781 m
.50002 .24427 L
s
.51621 .22781 m
.53242 .2442 L
s
.50002 .24427 m
.48381 .26073 L
s
.50002 .24427 m
.51622 .26073 L
s
.48381 .26073 m
.46761 .27717 L
s
.48381 .26073 m
.50002 .27727 L
s
.46761 .27717 m
.4514 .29354 L
s
.46761 .27717 m
.48382 .29378 L
s
.4514 .29354 m
.43516 .30984 L
s
.4514 .29354 m
.46761 .31024 L
s
.43516 .30984 m
.41885 .32603 L
s
.43516 .30984 m
.45138 .32662 L
s
.41885 .32603 m
.40244 .34207 L
s
.41885 .32603 m
.43509 .34289 L
s
.40244 .34207 m
.38588 .35791 L
s
.40244 .34207 m
.41869 .35899 L
s
.38588 .35791 m
.36911 .37357 L
s
.38588 .35791 m
.4021 .37484 L
s
.36911 .37357 m
.35225 .38919 L
s
.36911 .37357 m
.38523 .39044 L
s
.35225 .38919 m
.33534 .40479 L
s
.35225 .38919 m
.36829 .40604 L
s
.33534 .40479 m
.3184 .42037 L
s
.33534 .40479 m
.35133 .42164 L
s
.3184 .42037 m
.30145 .43593 L
s
.3184 .42037 m
.33435 .43722 L
s
.30145 .43593 m
.28448 .45148 L
s
.30145 .43593 m
.31737 .4528 L
s
.28448 .45148 m
.2675 .46704 L
s
.28448 .45148 m
.30037 .46836 L
s
.2675 .46704 m
.2505 .4826 L
s
.2675 .46704 m
.28335 .48392 L
s
.2505 .4826 m
.23352 .49814 L
s
.2505 .4826 m
.26633 .49947 L
s
.23352 .49814 m
.2165 .51373 L
s
.23352 .49814 m
.24931 .515 L
s
.2165 .51373 m
.1993 .5295 L
s
.2165 .51373 m
.23226 .53056 L
s
.1993 .5295 m
.18257 .54485 L
s
.1993 .5295 m
.21502 .54629 L
s
.18257 .54485 m
.16557 .5605 L
s
.18257 .54485 m
.19825 .56159 L
s
.16557 .5605 m
.14746 .57721 L
s
.16557 .5605 m
.1812 .57719 L
s
.14746 .57721 m
.12923 .59406 L
s
.14746 .57721 m
.16306 .59386 L
s
.12923 .59406 m
.1448 .61071 L
s
.63223 .14293 m
.61469 .16065 L
s
.63223 .14293 m
.64831 .15894 L
s
.61469 .16065 m
.59733 .1782 L
s
.61469 .16065 m
.63078 .17671 L
s
.59733 .1782 m
.58107 .19468 L
s
.59733 .1782 m
.61346 .19431 L
s
.58107 .19468 m
.56508 .21092 L
s
.58107 .19468 m
.59722 .21085 L
s
.56508 .21092 m
.54865 .22764 L
s
.56508 .21092 m
.58126 .22715 L
s
.54865 .22764 m
.53242 .2442 L
s
.54865 .22764 m
.56485 .24393 L
s
.53242 .2442 m
.51622 .26073 L
s
.53242 .2442 m
.54862 .26056 L
s
.51622 .26073 m
.50002 .27727 L
s
.51622 .26073 m
.53243 .27716 L
s
.50002 .27727 m
.48382 .29378 L
s
.50002 .27727 m
.51622 .29378 L
s
.48382 .29378 m
.46761 .31024 L
s
.48382 .29378 m
.50002 .31037 L
s
.46761 .31024 m
.45138 .32662 L
s
.46761 .31024 m
.48382 .32692 L
s
.45138 .32662 m
.43509 .34289 L
s
.45138 .32662 m
.4676 .34341 L
s
.43509 .34289 m
.41869 .35899 L
s
.43509 .34289 m
.45133 .35978 L
s
.41869 .35899 m
.4021 .37484 L
s
.41869 .35899 m
.43496 .37596 L
s
.4021 .37484 m
.38523 .39044 L
s
.4021 .37484 m
.41836 .39181 L
s
.38523 .39044 m
.36829 .40604 L
s
.38523 .39044 m
.40139 .40734 L
s
.36829 .40604 m
.35133 .42164 L
s
.36829 .40604 m
.38433 .42291 L
s
.35133 .42164 m
.33435 .43722 L
s
.35133 .42164 m
.36731 .43852 L
s
.33435 .43722 m
.31737 .4528 L
s
.33435 .43722 m
.3503 .45412 L
s
.31737 .4528 m
.30037 .46836 L
s
.31737 .4528 m
.33328 .4697 L
s
.30037 .46836 m
.28335 .48392 L
s
.30037 .46836 m
.31626 .48526 L
s
.28335 .48392 m
.26633 .49947 L
s
.28335 .48392 m
.29923 .50082 L
s
.26633 .49947 m
.24931 .515 L
s
.26633 .49947 m
.28218 .51636 L
s
.24931 .515 m
.23226 .53056 L
s
.24931 .515 m
.26515 .53187 L
s
.23226 .53056 m
.21502 .54629 L
s
.23226 .53056 m
.24807 .54739 L
s
.21502 .54629 m
.19825 .56159 L
s
.21502 .54629 m
.2308 .56308 L
s
.19825 .56159 m
.1812 .57719 L
s
.19825 .56159 m
.214 .57832 L
s
.1812 .57719 m
.16306 .59386 L
s
.1812 .57719 m
.19692 .59385 L
s
.16306 .59386 m
.1448 .61071 L
s
.16306 .59386 m
.17873 .61047 L
s
.1448 .61071 m
.16046 .62734 L
s
.64831 .15894 m
.63078 .17671 L
s
.64831 .15894 m
.66438 .17489 L
s
.63078 .17671 m
.61346 .19431 L
s
.63078 .17671 m
.64689 .19271 L
s
.61346 .19431 m
.59722 .21085 L
s
.61346 .19431 m
.6296 .21037 L
s
.59722 .21085 m
.58126 .22715 L
s
.59722 .21085 m
.6134 .22696 L
s
.58126 .22715 m
.56485 .24393 L
s
.58126 .22715 m
.59745 .24332 L
s
.56485 .24393 m
.54862 .26056 L
s
.56485 .24393 m
.58106 .26017 L
s
.54862 .26056 m
.53243 .27716 L
s
.54862 .26056 m
.56483 .27686 L
s
.53243 .27716 m
.51622 .29378 L
s
.53243 .27716 m
.54864 .29353 L
s
.51622 .29378 m
.50002 .31037 L
s
.51622 .29378 m
.53243 .31023 L
s
.50002 .31037 m
.48382 .32692 L
s
.50002 .31037 m
.51623 .32692 L
s
.48382 .32692 m
.4676 .34341 L
s
.48382 .32692 m
.50003 .34358 L
s
.4676 .34341 m
.45133 .35978 L
s
.4676 .34341 m
.48382 .36018 L
s
.45133 .35978 m
.43496 .37596 L
s
.45133 .35978 m
.46758 .3767 L
s
.43496 .37596 m
.41836 .39181 L
s
.43496 .37596 m
.45127 .393 L
s
.41836 .39181 m
.40139 .40734 L
s
.41836 .39181 m
.43469 .40889 L
s
.40139 .40734 m
.38433 .42291 L
s
.40139 .40734 m
.41762 .42437 L
s
.38433 .42291 m
.36731 .43852 L
s
.38433 .42291 m
.40046 .43993 L
s
.36731 .43852 m
.3503 .45412 L
s
.36731 .43852 m
.38338 .45557 L
s
.3503 .45412 m
.33328 .4697 L
s
.3503 .45412 m
.36635 .47119 L
s
.33328 .4697 m
.31626 .48526 L
s
.33328 .4697 m
.34931 .48677 L
s
.31626 .48526 m
.29923 .50082 L
s
.31626 .48526 m
.33227 .50234 L
s
.29923 .50082 m
.28218 .51636 L
s
.29923 .50082 m
.31523 .51789 L
s
.28218 .51636 m
.26515 .53187 L
s
.28218 .51636 m
.29818 .53341 L
s
.26515 .53187 m
.24807 .54739 L
s
.26515 .53187 m
.28114 .54889 L
s
.24807 .54739 m
.2308 .56308 L
s
.24807 .54739 m
.26405 .56438 L
s
.2308 .56308 m
.214 .57832 L
s
.2308 .56308 m
.24677 .58 L
s
.214 .57832 m
.19692 .59385 L
s
.214 .57832 m
.22994 .59518 L
s
.19692 .59385 m
.17873 .61047 L
s
.19692 .59385 m
.21281 .6106 L
s
.17873 .61047 m
.16046 .62734 L
s
.17873 .61047 m
.19456 .62713 L
s
.16046 .62734 m
.17626 .644 L
s
.66438 .17489 m
.64689 .19271 L
s
.66438 .17489 m
.68049 .19077 L
s
.64689 .19271 m
.6296 .21037 L
s
.64689 .19271 m
.66303 .20866 L
s
.6296 .21037 m
.6134 .22696 L
s
.6296 .21037 m
.64578 .22637 L
s
.6134 .22696 m
.59745 .24332 L
s
.6134 .22696 m
.62961 .24301 L
s
.59745 .24332 m
.58106 .26017 L
s
.59745 .24332 m
.61369 .25942 L
s
.58106 .26017 m
.56483 .27686 L
s
.58106 .26017 m
.5973 .27633 L
s
.56483 .27686 m
.54864 .29353 L
s
.56483 .27686 m
.58108 .29308 L
s
.54864 .29353 m
.53243 .31023 L
s
.54864 .29353 m
.56489 .30983 L
s
.53243 .31023 m
.51623 .32692 L
s
.53243 .31023 m
.54867 .32661 L
s
.51623 .32692 m
.50003 .34358 L
s
.51623 .32692 m
.53245 .3434 L
s
.50003 .34358 m
.48382 .36018 L
s
.50003 .34358 m
.51624 .36017 L
s
.48382 .36018 m
.46758 .3767 L
s
.48382 .36018 m
.50003 .37694 L
s
.46758 .3767 m
.45127 .393 L
s
.46758 .3767 m
.48383 .39366 L
s
.45127 .393 m
.43469 .40889 L
s
.45127 .393 m
.46756 .41014 L
s
.43469 .40889 m
.41762 .42437 L
s
.43469 .40889 m
.45099 .4261 L
s
.41762 .42437 m
.40046 .43993 L
s
.41762 .42437 m
.43328 .441 L
s
.40046 .43993 m
.38338 .45557 L
s
.40046 .43993 m
.41602 .45654 L
s
.38338 .45557 m
.36635 .47119 L
s
.38338 .45557 m
.39889 .47218 L
s
.36635 .47119 m
.34931 .48677 L
s
.36635 .47119 m
.38186 .48782 L
s
.34931 .48677 m
.33227 .50234 L
s
.34931 .48677 m
.36483 .5034 L
s
.33227 .50234 m
.31523 .51789 L
s
.33227 .50234 m
.34779 .51897 L
s
.31523 .51789 m
.29818 .53341 L
s
.31523 .51789 m
.33075 .5345 L
s
.29818 .53341 m
.28114 .54889 L
s
.29818 .53341 m
.31371 .55001 L
s
.28114 .54889 m
.26405 .56438 L
s
.28114 .54889 m
.29668 .56545 L
s
.26405 .56438 m
.24677 .58 L
s
.26405 .56438 m
.2796 .58088 L
s
.24677 .58 m
.22994 .59518 L
s
.24677 .58 m
.26231 .59645 L
s
.22994 .59518 m
.21281 .6106 L
s
.22994 .59518 m
.24548 .61151 L
s
.21281 .6106 m
.19456 .62713 L
s
.21281 .6106 m
.22831 .62678 L
s
.19456 .62713 m
.17626 .644 L
s
.19456 .62713 m
.21003 .64318 L
s
.17626 .644 m
.19164 .65991 L
s
.68049 .19077 m
.66303 .20866 L
s
.68049 .19077 m
.69664 .20656 L
s
.66303 .20866 m
.64578 .22637 L
s
.66303 .20866 m
.67923 .22452 L
s
.64578 .22637 m
.62961 .24301 L
s
.64578 .22637 m
.66203 .24229 L
s
.62961 .24301 m
.61369 .25942 L
s
.62961 .24301 m
.64589 .25898 L
s
.61369 .25942 m
.5973 .27633 L
s
.61369 .25942 m
.62999 .27544 L
s
.5973 .27633 m
.58108 .29308 L
s
.5973 .27633 m
.61362 .29239 L
s
.58108 .29308 m
.56489 .30983 L
s
.58108 .29308 m
.5974 .30921 L
s
.56489 .30983 m
.54867 .32661 L
s
.56489 .30983 m
.5812 .32602 L
s
.54867 .32661 m
.53245 .3434 L
s
.54867 .32661 m
.56497 .34288 L
s
.53245 .3434 m
.51624 .36017 L
s
.53245 .3434 m
.54873 .35977 L
s
.51624 .36017 m
.50003 .37694 L
s
.51624 .36017 m
.53248 .37669 L
s
.50003 .37694 m
.48383 .39366 L
s
.50003 .37694 m
.51624 .39366 L
s
.48383 .39366 m
.46756 .41014 L
s
.48383 .39366 m
.50004 .41063 L
s
.46756 .41014 m
.45099 .4261 L
s
.46756 .41014 m
.48378 .42734 L
s
.45099 .4261 m
.43328 .441 L
s
.45099 .4261 m
.46729 .44367 L
s
.43328 .441 m
.41602 .45654 L
s
.43328 .441 m
.44898 .45802 L
s
.41602 .45654 m
.39889 .47218 L
s
.41602 .45654 m
.43171 .47356 L
s
.39889 .47218 m
.38186 .48782 L
s
.39889 .47218 m
.41454 .48919 L
s
.38186 .48782 m
.36483 .5034 L
s
.38186 .48782 m
.39752 .50481 L
s
.36483 .5034 m
.34779 .51897 L
s
.36483 .5034 m
.38052 .52039 L
s
.34779 .51897 m
.33075 .5345 L
s
.34779 .51897 m
.36351 .53593 L
s
.33075 .5345 m
.31371 .55001 L
s
.33075 .5345 m
.34648 .55145 L
s
.31371 .55001 m
.29668 .56545 L
s
.31371 .55001 m
.32946 .56693 L
s
.29668 .56545 m
.2796 .58088 L
s
.29668 .56545 m
.31245 .58233 L
s
.2796 .58088 m
.26231 .59645 L
s
.2796 .58088 m
.29538 .59772 L
s
.26231 .59645 m
.24548 .61151 L
s
.26231 .59645 m
.27814 .61318 L
s
.24548 .61151 m
.22831 .62678 L
s
.24548 .61151 m
.26135 .62809 L
s
.22831 .62678 m
.21003 .64318 L
s
.22831 .62678 m
.24417 .6432 L
s
.21003 .64318 m
.19164 .65991 L
s
.21003 .64318 m
.22593 .65959 L
s
.19164 .65991 m
.20747 .67583 L
s
.69664 .20656 m
.67923 .22452 L
s
.69664 .20656 m
.71286 .22226 L
s
.67923 .22452 m
.66203 .24229 L
s
.67923 .22452 m
.69551 .24029 L
s
.66203 .24229 m
.64589 .25898 L
s
.66203 .24229 m
.67836 .25811 L
s
.64589 .25898 m
.62999 .27544 L
s
.64589 .25898 m
.66225 .27484 L
s
.62999 .27544 m
.61362 .29239 L
s
.62999 .27544 m
.64638 .29134 L
s
.61362 .29239 m
.5974 .30921 L
s
.61362 .29239 m
.63002 .30834 L
s
.5974 .30921 m
.5812 .32602 L
s
.5974 .30921 m
.61382 .32519 L
s
.5812 .32602 m
.56497 .34288 L
s
.5812 .32602 m
.59761 .34205 L
s
.56497 .34288 m
.54873 .35977 L
s
.56497 .34288 m
.58137 .35897 L
s
.54873 .35977 m
.53248 .37669 L
s
.54873 .35977 m
.5651 .37594 L
s
.53248 .37669 m
.51624 .39366 L
s
.53248 .37669 m
.5488 .39299 L
s
.51624 .39366 m
.50004 .41063 L
s
.51624 .39366 m
.53251 .41014 L
s
.50004 .41063 m
.48378 .42734 L
s
.50004 .41063 m
.5163 .42733 L
s
.48378 .42734 m
.46729 .44367 L
s
.48378 .42734 m
.50004 .44498 L
s
.46729 .44367 m
.44898 .45802 L
s
.46729 .44367 m
.48368 .46203 L
s
.44898 .45802 m
.43171 .47356 L
s
.44898 .45802 m
.46496 .47603 L
s
.43171 .47356 m
.41454 .48919 L
s
.43171 .47356 m
.44781 .49164 L
s
.41454 .48919 m
.39752 .50481 L
s
.41454 .48919 m
.43115 .50736 L
s
.39752 .50481 m
.38052 .52039 L
s
.39752 .50481 m
.41413 .52297 L
s
.38052 .52039 m
.36351 .53593 L
s
.38052 .52039 m
.39714 .53852 L
s
.36351 .53593 m
.34648 .55145 L
s
.36351 .53593 m
.38016 .55405 L
s
.34648 .55145 m
.32946 .56693 L
s
.34648 .55145 m
.36316 .56955 L
s
.32946 .56693 m
.31245 .58233 L
s
.32946 .56693 m
.34616 .58502 L
s
.31245 .58233 m
.29538 .59772 L
s
.31245 .58233 m
.32916 .60039 L
s
.29538 .59772 m
.27814 .61318 L
s
.29538 .59772 m
.31214 .61573 L
s
.27814 .61318 m
.26135 .62809 L
s
.27814 .61318 m
.29496 .63111 L
s
.26135 .62809 m
.24417 .6432 L
s
.26135 .62809 m
.2782 .64591 L
s
.24417 .6432 m
.22593 .65959 L
s
.24417 .6432 m
.26098 .661 L
s
.22593 .65959 m
.20747 .67583 L
s
.22593 .65959 m
.24278 .67637 L
s
.20747 .67583 m
.22436 .69189 L
s
.71286 .22226 m
.69551 .24029 L
s
.71286 .22226 m
.72916 .23787 L
s
.69551 .24029 m
.67836 .25811 L
s
.69551 .24029 m
.71188 .25596 L
s
.67836 .25811 m
.66225 .27484 L
s
.67836 .25811 m
.69478 .27383 L
s
.66225 .27484 m
.64638 .29134 L
s
.66225 .27484 m
.67872 .2906 L
s
.64638 .29134 m
.63002 .30834 L
s
.64638 .29134 m
.66287 .30712 L
s
.63002 .30834 m
.61382 .32519 L
s
.63002 .30834 m
.64655 .32414 L
s
.61382 .32519 m
.59761 .34205 L
s
.61382 .32519 m
.63037 .34101 L
s
.59761 .34205 m
.58137 .35897 L
s
.59761 .34205 m
.61418 .35789 L
s
.58137 .35897 m
.5651 .37594 L
s
.58137 .35897 m
.59796 .37482 L
s
.5651 .37594 m
.5488 .39299 L
s
.5651 .37594 m
.58171 .39179 L
s
.5488 .39299 m
.53251 .41014 L
s
.5488 .39299 m
.56539 .40887 L
s
.53251 .41014 m
.5163 .42733 L
s
.53251 .41014 m
.54908 .42609 L
s
.5163 .42733 m
.50004 .44498 L
s
.5163 .42733 m
.53279 .44366 L
s
.50004 .44498 m
.48368 .46203 L
s
.50004 .44498 m
.51641 .46203 L
s
.48368 .46203 m
.46496 .47603 L
s
.48368 .46203 m
.50005 .4801 L
s
.46496 .47603 m
.44781 .49164 L
s
.46496 .47603 m
.48123 .4941 L
s
.44781 .49164 m
.43115 .50736 L
s
.44781 .49164 m
.46428 .50986 L
s
.43115 .50736 m
.41413 .52297 L
s
.43115 .50736 m
.44782 .52559 L
s
.41413 .52297 m
.39714 .53852 L
s
.41413 .52297 m
.43085 .5412 L
s
.39714 .53852 m
.38016 .55405 L
s
.39714 .53852 m
.41384 .55675 L
s
.38016 .55405 m
.36316 .56955 L
s
.38016 .55405 m
.39686 .57229 L
s
.36316 .56955 m
.34616 .58502 L
s
.36316 .56955 m
.37988 .5878 L
s
.34616 .58502 m
.32916 .60039 L
s
.34616 .58502 m
.36289 .60326 L
s
.32916 .60039 m
.31214 .61573 L
s
.32916 .60039 m
.34592 .61864 L
s
.31214 .61573 m
.29496 .63111 L
s
.31214 .61573 m
.32891 .634 L
s
.29496 .63111 m
.2782 .64591 L
s
.29496 .63111 m
.31175 .64938 L
s
.2782 .64591 m
.26098 .661 L
s
.2782 .64591 m
.2951 .66405 L
s
.26098 .661 m
.24278 .67637 L
s
.26098 .661 m
.27799 .67866 L
s
.24278 .67637 m
.22436 .69189 L
s
.24278 .67637 m
.25979 .69333 L
s
.22436 .69189 m
.24138 .70807 L
s
.72916 .23787 m
.71188 .25596 L
s
.72916 .23787 m
.74556 .25341 L
s
.71188 .25596 m
.69478 .27383 L
s
.71188 .25596 m
.72834 .27154 L
s
.69478 .27383 m
.67872 .2906 L
s
.69478 .27383 m
.7113 .28946 L
s
.67872 .2906 m
.66287 .30712 L
s
.67872 .2906 m
.69528 .30626 L
s
.66287 .30712 m
.64655 .32414 L
s
.66287 .30712 m
.67948 .3228 L
s
.64655 .32414 m
.63037 .34101 L
s
.64655 .32414 m
.66321 .33983 L
s
.63037 .34101 m
.61418 .35789 L
s
.63037 .34101 m
.64707 .3567 L
s
.61418 .35789 m
.59796 .37482 L
s
.61418 .35789 m
.63096 .37355 L
s
.59796 .37482 m
.58171 .39179 L
s
.59796 .37482 m
.61483 .39042 L
s
.58171 .39179 m
.56539 .40887 L
s
.58171 .39179 m
.59868 .40732 L
s
.56539 .40887 m
.54908 .42609 L
s
.56539 .40887 m
.58245 .42435 L
s
.54908 .42609 m
.53279 .44366 L
s
.54908 .42609 m
.5668 .44098 L
s
.53279 .44366 m
.51641 .46203 L
s
.53279 .44366 m
.55111 .45801 L
s
.51641 .46203 m
.50005 .4801 L
s
.51641 .46203 m
.53513 .47602 L
s
.50005 .4801 m
.48123 .4941 L
s
.50005 .4801 m
.51887 .49409 L
s
.48123 .4941 m
.46428 .50986 L
s
.46428 .50986 m
.44782 .52559 L
s
.44782 .52559 m
.43085 .5412 L
s
.43085 .5412 m
.41384 .55675 L
s
.41384 .55675 m
.39686 .57229 L
s
.39686 .57229 m
.37988 .5878 L
s
.37988 .5878 m
.36289 .60326 L
s
.36289 .60326 m
.34592 .61864 L
s
.34592 .61864 m
.32891 .634 L
s
.32891 .634 m
.31175 .64938 L
s
.31175 .64938 m
.2951 .66405 L
s
.2951 .66405 m
.27799 .67866 L
s
.27799 .67866 m
.25979 .69333 L
s
.25979 .69333 m
.24138 .70807 L
s
.74556 .25341 m
.72834 .27154 L
s
.74556 .25341 m
.76204 .26888 L
s
.72834 .27154 m
.7113 .28946 L
s
.72834 .27154 m
.74489 .28706 L
s
.7113 .28946 m
.69528 .30626 L
s
.7113 .28946 m
.72791 .30501 L
s
.69528 .30626 m
.67948 .3228 L
s
.69528 .30626 m
.71193 .32185 L
s
.67948 .3228 m
.66321 .33983 L
s
.67948 .3228 m
.69618 .33841 L
s
.66321 .33983 m
.64707 .3567 L
s
.66321 .33983 m
.67995 .35545 L
s
.64707 .3567 m
.63096 .37355 L
s
.64707 .3567 m
.66387 .37232 L
s
.63096 .37355 m
.61483 .39042 L
s
.63096 .37355 m
.64782 .38917 L
s
.61483 .39042 m
.59868 .40732 L
s
.61483 .39042 m
.63178 .40602 L
s
.59868 .40732 m
.58245 .42435 L
s
.59868 .40732 m
.61574 .42289 L
s
.58245 .42435 m
.5668 .44098 L
s
.58245 .42435 m
.59962 .43991 L
s
.5668 .44098 m
.55111 .45801 L
s
.5668 .44098 m
.58406 .45652 L
s
.55111 .45801 m
.53513 .47602 L
s
.55111 .45801 m
.56838 .47355 L
s
.53513 .47602 m
.51887 .49409 L
s
.53513 .47602 m
.55228 .49163 L
s
.51887 .49409 m
.53582 .50986 L
s
.76204 .26888 m
.74489 .28706 L
s
.76204 .26888 m
.77859 .28433 L
s
.74489 .28706 m
.72791 .30501 L
s
.74489 .28706 m
.76151 .30253 L
s
.72791 .30501 m
.71193 .32185 L
s
.72791 .30501 m
.74457 .32052 L
s
.71193 .32185 m
.69618 .33841 L
s
.71193 .32185 m
.72864 .33739 L
s
.69618 .33841 m
.67995 .35545 L
s
.69618 .33841 m
.71293 .35397 L
s
.67995 .35545 m
.66387 .37232 L
s
.67995 .35545 m
.69676 .37103 L
s
.66387 .37232 m
.64782 .38917 L
s
.66387 .37232 m
.68073 .38791 L
s
.64782 .38917 m
.63178 .40602 L
s
.64782 .38917 m
.66473 .40476 L
s
.63178 .40602 m
.61574 .42289 L
s
.63178 .40602 m
.64874 .42161 L
s
.61574 .42289 m
.59962 .43991 L
s
.61574 .42289 m
.63276 .4385 L
s
.59962 .43991 m
.58406 .45652 L
s
.59962 .43991 m
.6167 .45555 L
s
.58406 .45652 m
.56838 .47355 L
s
.58406 .45652 m
.60119 .47217 L
s
.56838 .47355 m
.55228 .49163 L
s
.56838 .47355 m
.58554 .48917 L
s
.55228 .49163 m
.53582 .50986 L
s
.55228 .49163 m
.56894 .50734 L
s
.53582 .50986 m
.55227 .52558 L
s
.77859 .28433 m
.76151 .30253 L
s
.77859 .28433 m
.79521 .29975 L
s
.76151 .30253 m
.74457 .32052 L
s
.76151 .30253 m
.77818 .31798 L
s
.74457 .32052 m
.72864 .33739 L
s
.74457 .32052 m
.76129 .336 L
s
.72864 .33739 m
.71293 .35397 L
s
.72864 .33739 m
.7454 .3529 L
s
.71293 .35397 m
.69676 .37103 L
s
.71293 .35397 m
.72973 .36951 L
s
.69676 .37103 m
.68073 .38791 L
s
.69676 .37103 m
.7136 .38658 L
s
.68073 .38791 m
.66473 .40476 L
s
.68073 .38791 m
.69762 .40348 L
s
.66473 .40476 m
.64874 .42161 L
s
.66473 .40476 m
.68166 .42034 L
s
.64874 .42161 m
.63276 .4385 L
s
.64874 .42161 m
.66572 .4372 L
s
.63276 .4385 m
.6167 .45555 L
s
.63276 .4385 m
.64977 .4541 L
s
.6167 .45555 m
.60119 .47217 L
s
.6167 .45555 m
.63373 .47117 L
s
.60119 .47217 m
.58554 .48917 L
s
.60119 .47217 m
.61822 .4878 L
s
.58554 .48917 m
.56894 .50734 L
s
.58554 .48917 m
.60256 .5048 L
s
.56894 .50734 m
.55227 .52558 L
s
.56894 .50734 m
.58596 .52295 L
s
.55227 .52558 m
.56925 .54119 L
s
.79521 .29975 m
.77818 .31798 L
s
.79521 .29975 m
.81187 .31517 L
s
.77818 .31798 m
.76129 .336 L
s
.77818 .31798 m
.79489 .33342 L
s
.76129 .336 m
.7454 .3529 L
s
.76129 .336 m
.77803 .35147 L
s
.7454 .3529 m
.72973 .36951 L
s
.7454 .3529 m
.76218 .36839 L
s
.72973 .36951 m
.7136 .38658 L
s
.72973 .36951 m
.74656 .38502 L
s
.7136 .38658 m
.69762 .40348 L
s
.7136 .38658 m
.73048 .40212 L
s
.69762 .40348 m
.68166 .42034 L
s
.69762 .40348 m
.71453 .41903 L
s
.68166 .42034 m
.66572 .4372 L
s
.68166 .42034 m
.69861 .43591 L
s
.66572 .4372 m
.64977 .4541 L
s
.66572 .4372 m
.6827 .45278 L
s
.64977 .4541 m
.63373 .47117 L
s
.64977 .4541 m
.66679 .46968 L
s
.63373 .47117 m
.61822 .4878 L
s
.63373 .47117 m
.65077 .48675 L
s
.61822 .4878 m
.60256 .5048 L
s
.61822 .4878 m
.63525 .50339 L
s
.60256 .5048 m
.58596 .52295 L
s
.60256 .5048 m
.61956 .52037 L
s
.58596 .52295 m
.56925 .54119 L
s
.58596 .52295 m
.60295 .5385 L
s
.56925 .54119 m
.58626 .55674 L
s
.81187 .31517 m
.79489 .33342 L
s
.81187 .31517 m
.82856 .3306 L
s
.79489 .33342 m
.77803 .35147 L
s
.79489 .33342 m
.81161 .34885 L
s
.77803 .35147 m
.76218 .36839 L
s
.77803 .35147 m
.7948 .36693 L
s
.76218 .36839 m
.74656 .38502 L
s
.76218 .36839 m
.77899 .38388 L
s
.74656 .38502 m
.73048 .40212 L
s
.74656 .38502 m
.76341 .40053 L
s
.73048 .40212 m
.71453 .41903 L
s
.73048 .40212 m
.74736 .41765 L
s
.71453 .41903 m
.69861 .43591 L
s
.71453 .41903 m
.73146 .43458 L
s
.69861 .43591 m
.6827 .45278 L
s
.69861 .43591 m
.71558 .45146 L
s
.6827 .45278 m
.66679 .46968 L
s
.6827 .45278 m
.6997 .46834 L
s
.66679 .46968 m
.65077 .48675 L
s
.66679 .46968 m
.68381 .48524 L
s
.65077 .48675 m
.63525 .50339 L
s
.65077 .48675 m
.6678 .50232 L
s
.63525 .50339 m
.61956 .52037 L
s
.63525 .50339 m
.65229 .51895 L
s
.61956 .52037 m
.60295 .5385 L
s
.61956 .52037 m
.63657 .53592 L
s
.60295 .5385 m
.58626 .55674 L
s
.60295 .5385 m
.61992 .55403 L
s
.58626 .55674 m
.60323 .57228 L
s
.82856 .3306 m
.81161 .34885 L
s
.82856 .3306 m
.84529 .34605 L
s
.81161 .34885 m
.7948 .36693 L
s
.81161 .34885 m
.82836 .3643 L
s
.7948 .36693 m
.77899 .38388 L
s
.7948 .36693 m
.81157 .3824 L
s
.77899 .38388 m
.76341 .40053 L
s
.77899 .38388 m
.79581 .39938 L
s
.76341 .40053 m
.74736 .41765 L
s
.76341 .40053 m
.78027 .41606 L
s
.74736 .41765 m
.73146 .43458 L
s
.74736 .41765 m
.76427 .43319 L
s
.73146 .43458 m
.71558 .45146 L
s
.73146 .43458 m
.74841 .45013 L
s
.71558 .45146 m
.6997 .46834 L
s
.71558 .45146 m
.73256 .46702 L
s
.6997 .46834 m
.68381 .48524 L
s
.6997 .46834 m
.71671 .4839 L
s
.68381 .48524 m
.6678 .50232 L
s
.68381 .48524 m
.70084 .5008 L
s
.6678 .50232 m
.65229 .51895 L
s
.6678 .50232 m
.68484 .51787 L
s
.65229 .51895 m
.63657 .53592 L
s
.65229 .51895 m
.66932 .53449 L
s
.63657 .53592 m
.61992 .55403 L
s
.63657 .53592 m
.65359 .55144 L
s
.61992 .55403 m
.60323 .57228 L
s
.61992 .55403 m
.63692 .56954 L
s
.60323 .57228 m
.62021 .58779 L
s
.84529 .34605 m
.82836 .3643 L
s
.84529 .34605 m
.86199 .36151 L
s
.82836 .3643 m
.81157 .3824 L
s
.82836 .3643 m
.8451 .37978 L
s
.81157 .3824 m
.79581 .39938 L
s
.81157 .3824 m
.82834 .3979 L
s
.79581 .39938 m
.78027 .41606 L
s
.79581 .39938 m
.81262 .4149 L
s
.78027 .41606 m
.76427 .43319 L
s
.78027 .41606 m
.79714 .4316 L
s
.76427 .43319 m
.74841 .45013 L
s
.76427 .43319 m
.78119 .44874 L
s
.74841 .45013 m
.73256 .46702 L
s
.74841 .45013 m
.76537 .46569 L
s
.73256 .46702 m
.71671 .4839 L
s
.73256 .46702 m
.74956 .48258 L
s
.71671 .4839 m
.70084 .5008 L
s
.71671 .4839 m
.73373 .49945 L
s
.70084 .5008 m
.68484 .51787 L
s
.70084 .5008 m
.71788 .51634 L
s
.68484 .51787 m
.66932 .53449 L
s
.68484 .51787 m
.70189 .5334 L
s
.66932 .53449 m
.65359 .55144 L
s
.66932 .53449 m
.68636 .54999 L
s
.65359 .55144 m
.63692 .56954 L
s
.65359 .55144 m
.67061 .56692 L
s
.63692 .56954 m
.62021 .58779 L
s
.63692 .56954 m
.65392 .58501 L
s
.62021 .58779 m
.6372 .60325 L
s
.86199 .36151 m
.8451 .37978 L
s
.86199 .36151 m
.87865 .37698 L
s
.8451 .37978 m
.82834 .3979 L
s
.8451 .37978 m
.86177 .39526 L
s
.82834 .3979 m
.81262 .4149 L
s
.82834 .3979 m
.84506 .4134 L
s
.81262 .4149 m
.79714 .4316 L
s
.81262 .4149 m
.8294 .43043 L
s
.79714 .4316 m
.78119 .44874 L
s
.79714 .4316 m
.81398 .44715 L
s
.78119 .44874 m
.76537 .46569 L
s
.78119 .44874 m
.79808 .4643 L
s
.76537 .46569 m
.74956 .48258 L
s
.76537 .46569 m
.78231 .48125 L
s
.74956 .48258 m
.73373 .49945 L
s
.74956 .48258 m
.76653 .49813 L
s
.73373 .49945 m
.71788 .51634 L
s
.73373 .49945 m
.75074 .51499 L
s
.71788 .51634 m
.70189 .5334 L
s
.71788 .51634 m
.73491 .53185 L
s
.70189 .5334 m
.68636 .54999 L
s
.70189 .5334 m
.71892 .54888 L
s
.68636 .54999 m
.67061 .56692 L
s
.68636 .54999 m
.70338 .56544 L
s
.67061 .56692 m
.65392 .58501 L
s
.67061 .56692 m
.68762 .58232 L
s
.65392 .58501 m
.6372 .60325 L
s
.65392 .58501 m
.67091 .60038 L
s
.6372 .60325 m
.65416 .61863 L
s
.87865 .37698 m
.86177 .39526 L
s
.87865 .37698 m
.89531 .39252 L
s
.86177 .39526 m
.84506 .4134 L
s
.86177 .39526 m
.87843 .41081 L
s
.84506 .4134 m
.8294 .43043 L
s
.84506 .4134 m
.86178 .42899 L
s
.8294 .43043 m
.81398 .44715 L
s
.8294 .43043 m
.84618 .44603 L
s
.81398 .44715 m
.79808 .4643 L
s
.81398 .44715 m
.83083 .46276 L
s
.79808 .4643 m
.78231 .48125 L
s
.79808 .4643 m
.815 .47992 L
s
.78231 .48125 m
.76653 .49813 L
s
.78231 .48125 m
.79928 .49686 L
s
.76653 .49813 m
.75074 .51499 L
s
.76653 .49813 m
.78355 .51372 L
s
.75074 .51499 m
.73491 .53185 L
s
.75074 .51499 m
.76779 .53055 L
s
.73491 .53185 m
.71892 .54888 L
s
.73491 .53185 m
.75198 .54739 L
s
.71892 .54888 m
.70338 .56544 L
s
.71892 .54888 m
.736 .56437 L
s
.70338 .56544 m
.68762 .58232 L
s
.70338 .56544 m
.72046 .58088 L
s
.68762 .58232 m
.67091 .60038 L
s
.68762 .58232 m
.70468 .59771 L
s
.67091 .60038 m
.65416 .61863 L
s
.67091 .60038 m
.68793 .61572 L
s
.65416 .61863 m
.67117 .63399 L
s
.89531 .39252 m
.87843 .41081 L
s
.89531 .39252 m
.91202 .40824 L
s
.87843 .41081 m
.86178 .42899 L
s
.87843 .41081 m
.89515 .42654 L
s
.86178 .42899 m
.84618 .44603 L
s
.86178 .42899 m
.8786 .44478 L
s
.84618 .44603 m
.83083 .46276 L
s
.84618 .44603 m
.86312 .46186 L
s
.83083 .46276 m
.815 .47992 L
s
.83083 .46276 m
.84783 .47859 L
s
.815 .47992 m
.79928 .49686 L
s
.815 .47992 m
.83207 .49574 L
s
.79928 .49686 m
.78355 .51372 L
s
.79928 .49686 m
.81642 .51266 L
s
.78355 .51372 m
.76779 .53055 L
s
.78355 .51372 m
.80074 .5295 L
s
.76779 .53055 m
.75198 .54739 L
s
.76779 .53055 m
.78502 .54629 L
s
.75198 .54739 m
.736 .56437 L
s
.75198 .54739 m
.76924 .56307 L
s
.736 .56437 m
.72046 .58088 L
s
.736 .56437 m
.75328 .57999 L
s
.72046 .58088 m
.70468 .59771 L
s
.72046 .58088 m
.73774 .59645 L
s
.70468 .59771 m
.68793 .61572 L
s
.70468 .59771 m
.72192 .61318 L
s
.68793 .61572 m
.67117 .63399 L
s
.68793 .61572 m
.7051 .63111 L
s
.67117 .63399 m
.68831 .64938 L
s
.91202 .40824 m
.89515 .42654 L
s
.91202 .40824 m
.92799 .42356 L
s
.89515 .42654 m
.8786 .44478 L
s
.89515 .42654 m
.91126 .44194 L
s
.8786 .44478 m
.86312 .46186 L
s
.8786 .44478 m
.89483 .4602 L
s
.86312 .46186 m
.84783 .47859 L
s
.86312 .46186 m
.8795 .47731 L
s
.84783 .47859 m
.83207 .49574 L
s
.84783 .47859 m
.86435 .49403 L
s
.83207 .49574 m
.81642 .51266 L
s
.83207 .49574 m
.84866 .51116 L
s
.81642 .51266 m
.80074 .5295 L
s
.81642 .51266 m
.83308 .52805 L
s
.80074 .5295 m
.78502 .54629 L
s
.80074 .5295 m
.81746 .54485 L
s
.78502 .54629 m
.76924 .56307 L
s
.78502 .54629 m
.80179 .5616 L
s
.76924 .56307 m
.75328 .57999 L
s
.76924 .56307 m
.78604 .57832 L
s
.75328 .57999 m
.73774 .59645 L
s
.75328 .57999 m
.7701 .59518 L
s
.73774 .59645 m
.72192 .61318 L
s
.73774 .59645 m
.75456 .61151 L
s
.72192 .61318 m
.7051 .63111 L
s
.72192 .61318 m
.7387 .62809 L
s
.7051 .63111 m
.68831 .64938 L
s
.7051 .63111 m
.72185 .64591 L
s
.68831 .64938 m
.70496 .66405 L
s
.92799 .42356 m
.91126 .44194 L
s
.92799 .42356 m
.94394 .43936 L
s
.91126 .44194 m
.89483 .4602 L
s
.91126 .44194 m
.9277 .45781 L
s
.89483 .4602 m
.8795 .47731 L
s
.89483 .4602 m
.91129 .47602 L
s
.8795 .47731 m
.86435 .49403 L
s
.8795 .47731 m
.89611 .49312 L
s
.86435 .49403 m
.84866 .51116 L
s
.86435 .49403 m
.88112 .5098 L
s
.84866 .51116 m
.83308 .52805 L
s
.84866 .51116 m
.86554 .52688 L
s
.83308 .52805 m
.81746 .54485 L
s
.83308 .52805 m
.85002 .54375 L
s
.81746 .54485 m
.80179 .5616 L
s
.81746 .54485 m
.83445 .5605 L
s
.80179 .5616 m
.78604 .57832 L
s
.80179 .5616 m
.81883 .57719 L
s
.78604 .57832 m
.7701 .59518 L
s
.78604 .57832 m
.80311 .59386 L
s
.7701 .59518 m
.75456 .61151 L
s
.7701 .59518 m
.78722 .61061 L
s
.75456 .61151 m
.7387 .62809 L
s
.75456 .61151 m
.77173 .62678 L
s
.7387 .62809 m
.72185 .64591 L
s
.7387 .62809 m
.75587 .64321 L
s
.72185 .64591 m
.70496 .66405 L
s
.72185 .64591 m
.73906 .66101 L
s
.70496 .66405 m
.72206 .67867 L
s
.94394 .43936 m
.9277 .45781 L
s
.94394 .43936 m
.96002 .45627 L
s
.9277 .45781 m
.91129 .47602 L
s
.9277 .45781 m
.94448 .47467 L
s
.91129 .47602 m
.89611 .49312 L
s
.91129 .47602 m
.92908 .49284 L
s
.89611 .49312 m
.88112 .5098 L
s
.89611 .49312 m
.91393 .50999 L
s
.88112 .5098 m
.86554 .52688 L
s
.88112 .5098 m
.89904 .52664 L
s
.86554 .52688 m
.85002 .54375 L
s
.86554 .52688 m
.88355 .54367 L
s
.85002 .54375 m
.83445 .5605 L
s
.85002 .54375 m
.86808 .56049 L
s
.83445 .5605 m
.81883 .57719 L
s
.83445 .5605 m
.85256 .57722 L
s
.81883 .57719 m
.80311 .59386 L
s
.81883 .57719 m
.83696 .59387 L
s
.80311 .59386 m
.78722 .61061 L
s
.80311 .59386 m
.82129 .61048 L
s
.78722 .61061 m
.77173 .62678 L
s
.78722 .61061 m
.80547 .62714 L
s
.77173 .62678 m
.75587 .64321 L
s
.77173 .62678 m
.79 .64319 L
s
.75587 .64321 m
.73906 .66101 L
s
.75587 .64321 m
.7741 .6596 L
s
.73906 .66101 m
.72206 .67867 L
s
.73906 .66101 m
.75725 .67638 L
s
.72206 .67867 m
.74026 .69334 L
s
.96002 .45627 m
.94448 .47467 L
s
.96002 .45627 m
.97619 .47332 L
s
.94448 .47467 m
.92908 .49284 L
s
.94448 .47467 m
.96142 .49171 L
s
.92908 .49284 m
.91393 .50999 L
s
.92908 .49284 m
.9467 .50989 L
s
.91393 .50999 m
.89904 .52664 L
s
.91393 .50999 m
.93201 .52695 L
s
.89904 .52664 m
.88355 .54367 L
s
.89904 .52664 m
.91726 .54351 L
s
.88355 .54367 m
.86808 .56049 L
s
.88355 .54367 m
.90176 .56053 L
s
.86808 .56049 m
.85256 .57722 L
s
.86808 .56049 m
.88627 .57736 L
s
.85256 .57722 m
.83696 .59387 L
s
.85256 .57722 m
.87077 .59408 L
s
.83696 .59387 m
.82129 .61048 L
s
.83696 .59387 m
.8552 .61073 L
s
.82129 .61048 m
.80547 .62714 L
s
.82129 .61048 m
.83955 .62736 L
s
.80547 .62714 m
.79 .64319 L
s
.80547 .62714 m
.82375 .64401 L
s
.79 .64319 m
.7741 .6596 L
s
.79 .64319 m
.80837 .65993 L
s
.7741 .6596 m
.75725 .67638 L
s
.7741 .6596 m
.79255 .67584 L
s
.75725 .67638 m
.74026 .69334 L
s
.75725 .67638 m
.77566 .69191 L
s
.74026 .69334 m
.75865 .70809 L
s
.97619 .47332 m
.96142 .49171 L
s
.96142 .49171 m
.9467 .50989 L
s
.9467 .50989 m
.93201 .52695 L
s
.93201 .52695 m
.91726 .54351 L
s
.91726 .54351 m
.90176 .56053 L
s
.90176 .56053 m
.88627 .57736 L
s
.88627 .57736 m
.87077 .59408 L
s
.87077 .59408 m
.8552 .61073 L
s
.8552 .61073 m
.83955 .62736 L
s
.83955 .62736 m
.82375 .64401 L
s
.82375 .64401 m
.80837 .65993 L
s
.80837 .65993 m
.79255 .67584 L
s
.79255 .67584 m
.77566 .69191 L
s
.77566 .69191 m
.75865 .70809 L
s
.014 w
.49999 .01727 Mdot
.48227 .03274 Mdot
.46474 .04815 Mdot
.44833 .06347 Mdot
.43242 .07883 Mdot
.41608 .09491 Mdot
.39993 .11093 Mdot
.38386 .12693 Mdot
.36779 .14295 Mdot
.35171 .15897 Mdot
.33564 .17492 Mdot
.31954 .1908 Mdot
.3034 .20659 Mdot
.28718 .22229 Mdot
.27088 .2379 Mdot
.25449 .25344 Mdot
.23801 .26892 Mdot
.22146 .28436 Mdot
.20485 .29978 Mdot
.18819 .3152 Mdot
.17149 .33062 Mdot
.15476 .34606 Mdot
.13806 .36152 Mdot
.12139 .37698 Mdot
.10473 .39252 Mdot
.08801 .40823 Mdot
.07204 .42354 Mdot
.05607 .43934 Mdot
.03999 .45624 Mdot
.02381 .47329 Mdot
.51772 .03274 Mdot
.5 .04899 Mdot
.48249 .0651 Mdot
.466 .08091 Mdot
.45001 .09641 Mdot
.43367 .11251 Mdot
.41751 .12855 Mdot
.40142 .14459 Mdot
.38533 .16067 Mdot
.36924 .17673 Mdot
.35314 .19274 Mdot
.337 .20869 Mdot
.32081 .22455 Mdot
.30453 .24032 Mdot
.28816 .25599 Mdot
.2717 .27158 Mdot
.25516 .28709 Mdot
.23854 .30257 Mdot
.22187 .31801 Mdot
.20517 .33344 Mdot
.18844 .34887 Mdot
.17169 .36432 Mdot
.15495 .37979 Mdot
.13827 .39527 Mdot
.12161 .41081 Mdot
.10487 .42654 Mdot
.08876 .44193 Mdot
.07231 .45779 Mdot
.05553 .47465 Mdot
.03858 .49168 Mdot
.53525 .04814 Mdot
.5175 .06509 Mdot
.5 .08222 Mdot
.48356 .09805 Mdot
.46754 .11368 Mdot
.45113 .12988 Mdot
.43493 .14599 Mdot
.41881 .16209 Mdot
.40269 .17822 Mdot
.38656 .19433 Mdot
.37043 .21039 Mdot
.35425 .22639 Mdot
.33801 .24231 Mdot
.32168 .25814 Mdot
.30526 .27386 Mdot
.28875 .28949 Mdot
.27215 .30505 Mdot
.25548 .32056 Mdot
.23877 .33603 Mdot
.22202 .3515 Mdot
.20525 .36695 Mdot
.18847 .38242 Mdot
.1717 .39791 Mdot
.15498 .41341 Mdot
.13825 .429 Mdot
.12143 .44478 Mdot
.10519 .46019 Mdot
.08873 .47601 Mdot
.07093 .49282 Mdot
.05329 .50986 Mdot
.55166 .06346 Mdot
.53399 .0809 Mdot
.51644 .09805 Mdot
.5 .11404 Mdot
.48394 .12984 Mdot
.46749 .14616 Mdot
.45127 .16234 Mdot
.43511 .17851 Mdot
.41896 .1947 Mdot
.4028 .21087 Mdot
.38663 .22698 Mdot
.37042 .24304 Mdot
.35415 .259 Mdot
.33779 .27487 Mdot
.32133 .29063 Mdot
.30477 .30629 Mdot
.28812 .32188 Mdot
.27141 .33742 Mdot
.25466 .35293 Mdot
.23787 .36842 Mdot
.22106 .3839 Mdot
.20424 .3994 Mdot
.18742 .41492 Mdot
.17064 .43044 Mdot
.15385 .44604 Mdot
.13691 .46186 Mdot
.12052 .4773 Mdot
.1039 .49311 Mdot
.08608 .50998 Mdot
.06798 .52692 Mdot
.56758 .07882 Mdot
.54999 .0964 Mdot
.53247 .11368 Mdot
.51607 .12984 Mdot
.5 .14577 Mdot
.48354 .16218 Mdot
.4673 .17844 Mdot
.45113 .19468 Mdot
.43495 .21094 Mdot
.41877 .22716 Mdot
.40258 .24334 Mdot
.38635 .25944 Mdot
.37005 .27546 Mdot
.35367 .29137 Mdot
.33718 .30715 Mdot
.32057 .32283 Mdot
.30388 .33844 Mdot
.28712 .354 Mdot
.27032 .36953 Mdot
.25349 .38505 Mdot
.23665 .40056 Mdot
.21978 .41608 Mdot
.20291 .43161 Mdot
.18607 .44716 Mdot
.16921 .46277 Mdot
.1522 .47859 Mdot
.13567 .49403 Mdot
.1189 .50979 Mdot
.10097 .52663 Mdot
.08274 .54349 Mdot
.58392 .09489 Mdot
.56634 .1125 Mdot
.54887 .12988 Mdot
.53252 .14616 Mdot
.51647 .16218 Mdot
.50001 .17867 Mdot
.48376 .19501 Mdot
.46757 .21133 Mdot
.45137 .22765 Mdot
.43518 .24395 Mdot
.41898 .26018 Mdot
.40274 .27635 Mdot
.38643 .29242 Mdot
.37003 .30836 Mdot
.3535 .32417 Mdot
.33685 .33986 Mdot
.32011 .35548 Mdot
.3033 .37106 Mdot
.28646 .38661 Mdot
.26958 .40214 Mdot
.25269 .41767 Mdot
.23578 .43321 Mdot
.21886 .44876 Mdot
.20197 .46431 Mdot
.18504 .47992 Mdot
.16796 .49574 Mdot
.15136 .51116 Mdot
.13448 .52687 Mdot
.11647 .54365 Mdot
.09824 .56051 Mdot
.60007 .11091 Mdot
.5825 .12853 Mdot
.56508 .14598 Mdot
.54875 .16233 Mdot
.53271 .17843 Mdot
.51626 .19501 Mdot
.50001 .21143 Mdot
.48382 .22781 Mdot
.46761 .24421 Mdot
.45142 .26057 Mdot
.43521 .27687 Mdot
.41896 .2931 Mdot
.40265 .30922 Mdot
.38624 .32521 Mdot
.36969 .34104 Mdot
.35299 .35673 Mdot
.33619 .37235 Mdot
.31933 .38794 Mdot
.30244 .40351 Mdot
.28553 .41906 Mdot
.2686 .4346 Mdot
.25165 .45015 Mdot
.23469 .46571 Mdot
.21774 .48126 Mdot
.20077 .49686 Mdot
.18362 .51266 Mdot
.16695 .52805 Mdot
.15001 .54374 Mdot
.13194 .56047 Mdot
.11373 .57734 Mdot
.61615 .12691 Mdot
.5986 .14457 Mdot
.58121 .16207 Mdot
.5649 .1785 Mdot
.54889 .19467 Mdot
.53245 .21132 Mdot
.51621 .22781 Mdot
.50002 .24427 Mdot
.48381 .26073 Mdot
.46761 .27717 Mdot
.4514 .29354 Mdot
.43516 .30984 Mdot
.41885 .32603 Mdot
.40244 .34207 Mdot
.38588 .35791 Mdot
.36911 .37357 Mdot
.35225 .38919 Mdot
.33534 .40479 Mdot
.3184 .42037 Mdot
.30145 .43593 Mdot
.28448 .45148 Mdot
.2675 .46704 Mdot
.2505 .4826 Mdot
.23352 .49814 Mdot
.2165 .51373 Mdot
.1993 .5295 Mdot
.18257 .54485 Mdot
.16557 .5605 Mdot
.14746 .57721 Mdot
.12923 .59406 Mdot
.63223 .14293 Mdot
.61469 .16065 Mdot
.59733 .1782 Mdot
.58107 .19468 Mdot
.56508 .21092 Mdot
.54865 .22764 Mdot
.53242 .2442 Mdot
.51622 .26073 Mdot
.50002 .27727 Mdot
.48382 .29378 Mdot
.46761 .31024 Mdot
.45138 .32662 Mdot
.43509 .34289 Mdot
.41869 .35899 Mdot
.4021 .37484 Mdot
.38523 .39044 Mdot
.36829 .40604 Mdot
.35133 .42164 Mdot
.33435 .43722 Mdot
.31737 .4528 Mdot
.30037 .46836 Mdot
.28335 .48392 Mdot
.26633 .49947 Mdot
.24931 .515 Mdot
.23226 .53056 Mdot
.21502 .54629 Mdot
.19825 .56159 Mdot
.1812 .57719 Mdot
.16306 .59386 Mdot
.1448 .61071 Mdot
.64831 .15894 Mdot
.63078 .17671 Mdot
.61346 .19431 Mdot
.59722 .21085 Mdot
.58126 .22715 Mdot
.56485 .24393 Mdot
.54862 .26056 Mdot
.53243 .27716 Mdot
.51622 .29378 Mdot
.50002 .31037 Mdot
.48382 .32692 Mdot
.4676 .34341 Mdot
.45133 .35978 Mdot
.43496 .37596 Mdot
.41836 .39181 Mdot
.40139 .40734 Mdot
.38433 .42291 Mdot
.36731 .43852 Mdot
.3503 .45412 Mdot
.33328 .4697 Mdot
.31626 .48526 Mdot
.29923 .50082 Mdot
.28218 .51636 Mdot
.26515 .53187 Mdot
.24807 .54739 Mdot
.2308 .56308 Mdot
.214 .57832 Mdot
.19692 .59385 Mdot
.17873 .61047 Mdot
.16046 .62734 Mdot
.66438 .17489 Mdot
.64689 .19271 Mdot
.6296 .21037 Mdot
.6134 .22696 Mdot
.59745 .24332 Mdot
.58106 .26017 Mdot
.56483 .27686 Mdot
.54864 .29353 Mdot
.53243 .31023 Mdot
.51623 .32692 Mdot
.50003 .34358 Mdot
.48382 .36018 Mdot
.46758 .3767 Mdot
.45127 .393 Mdot
.43469 .40889 Mdot
.41762 .42437 Mdot
.40046 .43993 Mdot
.38338 .45557 Mdot
.36635 .47119 Mdot
.34931 .48677 Mdot
.33227 .50234 Mdot
.31523 .51789 Mdot
.29818 .53341 Mdot
.28114 .54889 Mdot
.26405 .56438 Mdot
.24677 .58 Mdot
.22994 .59518 Mdot
.21281 .6106 Mdot
.19456 .62713 Mdot
.17626 .644 Mdot
.68049 .19077 Mdot
.66303 .20866 Mdot
.64578 .22637 Mdot
.62961 .24301 Mdot
.61369 .25942 Mdot
.5973 .27633 Mdot
.58108 .29308 Mdot
.56489 .30983 Mdot
.54867 .32661 Mdot
.53245 .3434 Mdot
.51624 .36017 Mdot
.50003 .37694 Mdot
.48383 .39366 Mdot
.46756 .41014 Mdot
.45099 .4261 Mdot
.43328 .441 Mdot
.41602 .45654 Mdot
.39889 .47218 Mdot
.38186 .48782 Mdot
.36483 .5034 Mdot
.34779 .51897 Mdot
.33075 .5345 Mdot
.31371 .55001 Mdot
.29668 .56545 Mdot
.2796 .58088 Mdot
.26231 .59645 Mdot
.24548 .61151 Mdot
.22831 .62678 Mdot
.21003 .64318 Mdot
.19164 .65991 Mdot
.69664 .20656 Mdot
.67923 .22452 Mdot
.66203 .24229 Mdot
.64589 .25898 Mdot
.62999 .27544 Mdot
.61362 .29239 Mdot
.5974 .30921 Mdot
.5812 .32602 Mdot
.56497 .34288 Mdot
.54873 .35977 Mdot
.53248 .37669 Mdot
.51624 .39366 Mdot
.50004 .41063 Mdot
.48378 .42734 Mdot
.46729 .44367 Mdot
.44898 .45802 Mdot
.43171 .47356 Mdot
.41454 .48919 Mdot
.39752 .50481 Mdot
.38052 .52039 Mdot
.36351 .53593 Mdot
.34648 .55145 Mdot
.32946 .56693 Mdot
.31245 .58233 Mdot
.29538 .59772 Mdot
.27814 .61318 Mdot
.26135 .62809 Mdot
.24417 .6432 Mdot
.22593 .65959 Mdot
.20747 .67583 Mdot
.71286 .22226 Mdot
.69551 .24029 Mdot
.67836 .25811 Mdot
.66225 .27484 Mdot
.64638 .29134 Mdot
.63002 .30834 Mdot
.61382 .32519 Mdot
.59761 .34205 Mdot
.58137 .35897 Mdot
.5651 .37594 Mdot
.5488 .39299 Mdot
.53251 .41014 Mdot
.5163 .42733 Mdot
.50004 .44498 Mdot
.48368 .46203 Mdot
.46496 .47603 Mdot
.44781 .49164 Mdot
.43115 .50736 Mdot
.41413 .52297 Mdot
.39714 .53852 Mdot
.38016 .55405 Mdot
.36316 .56955 Mdot
.34616 .58502 Mdot
.32916 .60039 Mdot
.31214 .61573 Mdot
.29496 .63111 Mdot
.2782 .64591 Mdot
.26098 .661 Mdot
.24278 .67637 Mdot
.22436 .69189 Mdot
.72916 .23787 Mdot
.71188 .25596 Mdot
.69478 .27383 Mdot
.67872 .2906 Mdot
.66287 .30712 Mdot
.64655 .32414 Mdot
.63037 .34101 Mdot
.61418 .35789 Mdot
.59796 .37482 Mdot
.58171 .39179 Mdot
.56539 .40887 Mdot
.54908 .42609 Mdot
.53279 .44366 Mdot
.51641 .46203 Mdot
.50005 .4801 Mdot
.48123 .4941 Mdot
.46428 .50986 Mdot
.44782 .52559 Mdot
.43085 .5412 Mdot
.41384 .55675 Mdot
.39686 .57229 Mdot
.37988 .5878 Mdot
.36289 .60326 Mdot
.34592 .61864 Mdot
.32891 .634 Mdot
.31175 .64938 Mdot
.2951 .66405 Mdot
.27799 .67866 Mdot
.25979 .69333 Mdot
.24138 .70807 Mdot
.74556 .25341 Mdot
.72834 .27154 Mdot
.7113 .28946 Mdot
.69528 .30626 Mdot
.67948 .3228 Mdot
.66321 .33983 Mdot
.64707 .3567 Mdot
.63096 .37355 Mdot
.61483 .39042 Mdot
.59868 .40732 Mdot
.58245 .42435 Mdot
.5668 .44098 Mdot
.55111 .45801 Mdot
.53513 .47602 Mdot
.51887 .49409 Mdot
.76204 .26888 Mdot
.74489 .28706 Mdot
.72791 .30501 Mdot
.71193 .32185 Mdot
.69618 .33841 Mdot
.67995 .35545 Mdot
.66387 .37232 Mdot
.64782 .38917 Mdot
.63178 .40602 Mdot
.61574 .42289 Mdot
.59962 .43991 Mdot
.58406 .45652 Mdot
.56838 .47355 Mdot
.55228 .49163 Mdot
.53582 .50986 Mdot
.77859 .28433 Mdot
.76151 .30253 Mdot
.74457 .32052 Mdot
.72864 .33739 Mdot
.71293 .35397 Mdot
.69676 .37103 Mdot
.68073 .38791 Mdot
.66473 .40476 Mdot
.64874 .42161 Mdot
.63276 .4385 Mdot
.6167 .45555 Mdot
.60119 .47217 Mdot
.58554 .48917 Mdot
.56894 .50734 Mdot
.55227 .52558 Mdot
.79521 .29975 Mdot
.77818 .31798 Mdot
.76129 .336 Mdot
.7454 .3529 Mdot
.72973 .36951 Mdot
.7136 .38658 Mdot
.69762 .40348 Mdot
.68166 .42034 Mdot
.66572 .4372 Mdot
.64977 .4541 Mdot
.63373 .47117 Mdot
.61822 .4878 Mdot
.60256 .5048 Mdot
.58596 .52295 Mdot
.56925 .54119 Mdot
.81187 .31517 Mdot
.79489 .33342 Mdot
.77803 .35147 Mdot
.76218 .36839 Mdot
.74656 .38502 Mdot
.73048 .40212 Mdot
.71453 .41903 Mdot
.69861 .43591 Mdot
.6827 .45278 Mdot
.66679 .46968 Mdot
.65077 .48675 Mdot
.63525 .50339 Mdot
.61956 .52037 Mdot
.60295 .5385 Mdot
.58626 .55674 Mdot
.82856 .3306 Mdot
.81161 .34885 Mdot
.7948 .36693 Mdot
.77899 .38388 Mdot
.76341 .40053 Mdot
.74736 .41765 Mdot
.73146 .43458 Mdot
.71558 .45146 Mdot
.6997 .46834 Mdot
.68381 .48524 Mdot
.6678 .50232 Mdot
.65229 .51895 Mdot
.63657 .53592 Mdot
.61992 .55403 Mdot
.60323 .57228 Mdot
.84529 .34605 Mdot
.82836 .3643 Mdot
.81157 .3824 Mdot
.79581 .39938 Mdot
.78027 .41606 Mdot
.76427 .43319 Mdot
.74841 .45013 Mdot
.73256 .46702 Mdot
.71671 .4839 Mdot
.70084 .5008 Mdot
.68484 .51787 Mdot
.66932 .53449 Mdot
.65359 .55144 Mdot
.63692 .56954 Mdot
.62021 .58779 Mdot
.86199 .36151 Mdot
.8451 .37978 Mdot
.82834 .3979 Mdot
.81262 .4149 Mdot
.79714 .4316 Mdot
.78119 .44874 Mdot
.76537 .46569 Mdot
.74956 .48258 Mdot
.73373 .49945 Mdot
.71788 .51634 Mdot
.70189 .5334 Mdot
.68636 .54999 Mdot
.67061 .56692 Mdot
.65392 .58501 Mdot
.6372 .60325 Mdot
.87865 .37698 Mdot
.86177 .39526 Mdot
.84506 .4134 Mdot
.8294 .43043 Mdot
.81398 .44715 Mdot
.79808 .4643 Mdot
.78231 .48125 Mdot
.76653 .49813 Mdot
.75074 .51499 Mdot
.73491 .53185 Mdot
.71892 .54888 Mdot
.70338 .56544 Mdot
.68762 .58232 Mdot
.67091 .60038 Mdot
.65416 .61863 Mdot
.89531 .39252 Mdot
.87843 .41081 Mdot
.86178 .42899 Mdot
.84618 .44603 Mdot
.83083 .46276 Mdot
.815 .47992 Mdot
.79928 .49686 Mdot
.78355 .51372 Mdot
.76779 .53055 Mdot
.75198 .54739 Mdot
.736 .56437 Mdot
.72046 .58088 Mdot
.70468 .59771 Mdot
.68793 .61572 Mdot
.67117 .63399 Mdot
.91202 .40824 Mdot
.89515 .42654 Mdot
.8786 .44478 Mdot
.86312 .46186 Mdot
.84783 .47859 Mdot
.83207 .49574 Mdot
.81642 .51266 Mdot
.80074 .5295 Mdot
.78502 .54629 Mdot
.76924 .56307 Mdot
.75328 .57999 Mdot
.73774 .59645 Mdot
.72192 .61318 Mdot
.7051 .63111 Mdot
.68831 .64938 Mdot
.92799 .42356 Mdot
.91126 .44194 Mdot
.89483 .4602 Mdot
.8795 .47731 Mdot
.86435 .49403 Mdot
.84866 .51116 Mdot
.83308 .52805 Mdot
.81746 .54485 Mdot
.80179 .5616 Mdot
.78604 .57832 Mdot
.7701 .59518 Mdot
.75456 .61151 Mdot
.7387 .62809 Mdot
.72185 .64591 Mdot
.70496 .66405 Mdot
.94394 .43936 Mdot
.9277 .45781 Mdot
.91129 .47602 Mdot
.89611 .49312 Mdot
.88112 .5098 Mdot
.86554 .52688 Mdot
.85002 .54375 Mdot
.83445 .5605 Mdot
.81883 .57719 Mdot
.80311 .59386 Mdot
.78722 .61061 Mdot
.77173 .62678 Mdot
.75587 .64321 Mdot
.73906 .66101 Mdot
.72206 .67867 Mdot
.96002 .45627 Mdot
.94448 .47467 Mdot
.92908 .49284 Mdot
.91393 .50999 Mdot
.89904 .52664 Mdot
.88355 .54367 Mdot
.86808 .56049 Mdot
.85256 .57722 Mdot
.83696 .59387 Mdot
.82129 .61048 Mdot
.80547 .62714 Mdot
.79 .64319 Mdot
.7741 .6596 Mdot
.75725 .67638 Mdot
.74026 .69334 Mdot
.97619 .47332 Mdot
.96142 .49171 Mdot
.9467 .50989 Mdot
.93201 .52695 Mdot
.91726 .54351 Mdot
.90176 .56053 Mdot
.88627 .57736 Mdot
.87077 .59408 Mdot
.8552 .61073 Mdot
.83955 .62736 Mdot
.82375 .64401 Mdot
.80837 .65993 Mdot
.79255 .67584 Mdot
.77566 .69191 Mdot
.75865 .70809 Mdot
0 0 m
1 0 L
1 .72536 L
0 .72536 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[7]:=",
  ImageSize->{288, 208.875},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000d2000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00SP3oool20000oi00oooo002=0?ooo`@0003oS`3o
ool008d0oooo10000?n?0?ooo`00SP3oool30000ohl0oooo002<0?ooo`80003o0`3oool20000ohd0
oooo00290?ooo`<0003o1`3oool30000ohX0oooo00280?ooo`@0003o1`3oool40000ohT0oooo0028
0?ooo`@0003o1`3oool40000ohT0oooo00270?ooo`@0003o00<0oooo0000o`3oool0103oool00`00
0?l0oooo0000o`030000ohP0oooo00240?ooo`<0003o1P3oool00`000?l0oooo0000o`020000o`H0
oooo0`000?n50?ooo`00P`3oool40000o`L0oooo10000?l60?ooo`@0003oQ03oool008<0oooo1000
0?l70?ooo`@0003o1P3oool40000oh@0oooo00230?ooo`<0003o00<0oooo0000o`3oool01@3oool3
0000o`H0oooo00<0003o0?ooo`000?l00P000?n40?ooo`00P03oool30000o`D0oooo00@0003o0?oo
o`3oool0oooo0P000?l30?ooo`80003o0`3oool00`000?l0oooo0?ooo`030?ooo`<0003oP@3oool0
07l0oooo10000?l60?ooo`<0003o1`3oool30000o`H0oooo10000?n00?ooo`00O`3oool40000o`D0
oooo10000?l70?ooo`@0003o1@3oool40000oh00oooo001o0?ooo`<0003o1P3oool40000o`L0oooo
10000?l60?ooo`<0003oP03oool007h0oooo00D0003o0?ooo`3oool0oooo0000o`050?ooo`<0003o
00<0oooo0000o`3oool0103oool00`000?l0oooo0000o`020000o`D0oooo00D0003o0?ooo`3oool0
oooo0000o`1o0?ooo`00N`3oool30000o`D0oooo00<0003o0?ooo`000?l00P000?l50?ooo`050000
o`3oool0oooo0?ooo`000?l01@3oool30000o`030?ooo`000?l0oooo00@0oooo0`000?ml0?ooo`00
NP3oool40000o`H0oooo10000?l60?ooo`<0003o1P3oool40000o`H0oooo10000?mk0?ooo`00NP3o
ool40000o`H0oooo10000?l60?ooo`@0003o1@3oool40000o`H0oooo10000?mk0?ooo`00NP3oool3
0000o`030?ooo`000?l0oooo00@0oooo0`000?l70?ooo`@0003o1P3oool30000o`D0oooo00<0003o
0?ooo`000?l00P000?mk0?ooo`00MP3oool20000o`030?ooo`000?l0oooo00@0oooo00D0003o0?oo
o`3oool0oooo0000o`030?ooo`030000o`3oool0oooo00<0oooo00<0003o0?ooo`000?l00P000?l5
0?ooo`050000o`3oool0oooo0?ooo`000?l00`3oool00`000?l0oooo0?ooo`030?ooo`040000o`3o
ool0003o0000ogL0oooo001e0?ooo`@0003o1`3oool30000o`D0oooo00<0003o0?ooo`000?l00P00
0?l50?ooo`<0003o00<0oooo0000o`3oool0103oool30000o`L0oooo10000?mf0?ooo`00M@3oool4
0000o`H0oooo10000?l60?ooo`@0003o1@3oool40000o`H0oooo10000?l60?ooo`@0003oMP3oool0
07H0oooo0`000?l60?ooo`@0003o1P3oool40000o`D0oooo10000?l60?ooo`@0003o1P3oool30000
ogL0oooo001d0?ooo`80003o0`3oool00`000?l0oooo0?ooo`030?ooo`<0003o00<0oooo0000o`3o
ool0103oool30000o`L0oooo0`000?l50?ooo`030000o`3oool0003o0080003o1@3oool010000?l0
oooo0?ooo`3oool20000ogD0oooo001b0?ooo`80003o1P3oool30000o`030?ooo`000?l0oooo00@0
oooo00D0003o0?ooo`3oool0oooo0000o`030?ooo`80003o0`3oool20000o`<0oooo00D0003o0?oo
o`3oool0oooo0000o`050?ooo`030000o`3oool0003o0080003o1P3oool20000og<0oooo001a0?oo
o`@0003o1@3oool40000o`L0oooo0`000?l60?ooo`<0003o1P3oool30000o`L0oooo10000?l50?oo
o`@0003oLP3oool00740oooo10000?l50?ooo`@0003o1P3oool40000o`H0oooo10000?l50?ooo`@0
003o1P3oool40000o`D0oooo10000?mb0?ooo`00L03oool00`000?l0oooo0000o`020000o`H0oooo
0`000?l60?ooo`@0003o1P3oool40000o`D0oooo10000?l60?ooo`<0003o1P3oool30000o`030?oo
o`000?l0oooo0700oooo001]0?ooo`80003o00<0oooo0000o`3oool00`3oool010000?l0oooo0?oo
o`3oool20000o`<0oooo00<0003o0?ooo`3oool00`3oool30000o`030?ooo`000?l0oooo00<0oooo
00<0003o0?ooo`000?l00P000?l40?ooo`030000o`3oool0003o0080003o1@3oool010000?l0oooo
0?ooo`3oool20000o`<0oooo00<0003o0?ooo`3oool00P3oool010000?l0oooo0000o`000?m^0?oo
o`00K03oool40000o`H0oooo0`000?l60?ooo`<0003o00<0oooo0000o`3oool00`3oool00`000?l0
oooo0000o`020000o`D0oooo0`000?l00`3oool0003o0?ooo`030?ooo`030000o`3oool0003o0080
003o1P3oool30000o`H0oooo10000?m]0?ooo`00K03oool40000o`H0oooo10000?l50?ooo`@0003o
1P3oool40000o`D0oooo10000?l60?ooo`@0003o1@3oool40000o`H0oooo10000?m]0?ooo`00K@3o
ool30000o`H0oooo10000?l50?ooo`@0003o1P3oool40000o`D0oooo10000?l60?ooo`@0003o1@3o
ool40000o`H0oooo0`000?m^0?ooo`00K03oool01@000?l0oooo0?ooo`3oool0003o00@0oooo00<0
003o0?ooo`000?l00P000?l60?ooo`<0003o1P3oool30000o`L0oooo0`000?l60?ooo`<0003o1P3o
ool30000o`030?ooo`000?l0oooo00<0oooo00D0003o0?ooo`3oool0oooo0000o`1]0?ooo`00J@3o
ool30000o`D0oooo00D0003o0?ooo`3oool0oooo0000o`040?ooo`040000o`3oool0oooo0?ooo`80
003o0`3oool00`000?l0oooo0?ooo`020?ooo`040000o`3oool0oooo0?ooo`80003o0`3oool20000
o`<0oooo00<0003o0?ooo`3oool00P3oool010000?l0oooo0?ooo`3oool20000o`<0oooo00<0003o
0?ooo`3oool00P3oool01@000?l0oooo0?ooo`3oool0003o00D0oooo0`000?mZ0?ooo`00J03oool4
0000o`H0oooo0`000?l60?ooo`<0003o1P3oool30000o`030?ooo`000?l0oooo00@0oooo0`000?l5
0?ooo`030000o`3oool0003o0080003o1P3oool30000o`H0oooo0`000?l60?ooo`@0003oJ@3oool0
06P0oooo10000?l50?ooo`@0003o1P3oool40000o`D0oooo10000?l60?ooo`@0003o1@3oool40000
o`D0oooo10000?l60?ooo`@0003o1@3oool40000ofT0oooo001X0?ooo`<0003o1P3oool40000o`H0
oooo10000?l50?ooo`@0003o1P3oool40000o`D0oooo10000?l50?ooo`@0003o1P3oool40000o`H0
oooo0`000?mY0?ooo`00I`3oool01@000?l0oooo0?ooo`3oool0003o00D0oooo0`000?l00`3oool0
003o0?ooo`030?ooo`030000o`3oool0003o0080003o1P3oool30000o`D0oooo00<0003o0?ooo`00
0?l00P000?l50?ooo`<0003o1P3oool30000o`030?ooo`000?l0oooo00<0oooo00<0003o0?ooo`00
0?l00P000?l50?ooo`040000o`3oool0oooo0?ooo`80003oI`3oool006@0oooo0`000?l50?ooo`03
0000o`3oool0003o0080003o1@3oool01@000?l0oooo0?ooo`3oool0003o00@0oooo00@0003o0?oo
o`3oool0oooo0P000?l30?ooo`050000o`3oool0oooo0?ooo`000?l01@3oool01@000?l0oooo0?oo
o`3oool0003o00<0oooo0P000?l30?ooo`030000o`3oool0oooo0080oooo00D0003o0?ooo`3oool0
oooo0000o`050?ooo`<0003o00<0oooo0000o`3oool01@3oool20000ofD0oooo001S0?ooo`@0003o
1P3oool40000o`H0oooo0`000?l60?ooo`<0003o1P3oool30000o`L0oooo0`000?l60?ooo`<0003o
1P3oool30000o`H0oooo10000?l60?ooo`@0003oI03oool006<0oooo10000?l60?ooo`@0003o1@3o
ool40000o`H0oooo10000?l50?ooo`@0003o1@3oool40000o`D0oooo10000?l60?ooo`@0003o1@3o
ool40000o`H0oooo10000?mT0?ooo`00H`3oool30000o`030?ooo`000?l0oooo00@0oooo0`000?l6
0?ooo`@0003o1P3oool40000o`D0oooo10000?l50?ooo`@0003o1@3oool40000o`H0oooo10000?l6
0?ooo`<0003o1P3oool30000o`030?ooo`000?l0oooo0680oooo001O0?ooo`80003o00<0oooo0000
o`3oool0103oool01@000?l0oooo0?ooo`3oool0003o00<0oooo00<0003o0?ooo`3oool00`3oool3
0000o`030?ooo`000?l0oooo00<0oooo00<0003o0?ooo`000?l00P000?l40?ooo`030000o`3oool0
003o0080003o1@3oool30000o`030?ooo`000?l0oooo00<0oooo0`000?l00`3oool0003o0?ooo`03
0?ooo`030000o`3oool0003o0080003o1@3oool01@000?l0oooo0?ooo`3oool0003o00<0oooo0P00
0?l40?ooo`040000o`3oool0003o0000of00oooo001N0?ooo`@0003o1`3oool30000o`D0oooo00<0
003o0?ooo`000?l00P000?l40?ooo`030000o`3oool0003o0080003o1@3oool30000o`030?ooo`00
0?l0oooo00<0oooo00<0003o0?ooo`000?l00P000?l40?ooo`030000o`3oool0003o0080003o1@3o
ool30000o`030?ooo`000?l0oooo00<0oooo0`000?l00`3oool0003o0?ooo`040?ooo`<0003o1`3o
ool40000oel0oooo001N0?ooo`@0003o1P3oool40000o`H0oooo10000?l50?ooo`@0003o1@3oool4
0000o`H0oooo10000?l50?ooo`@0003o1@3oool40000o`D0oooo10000?l60?ooo`@0003o1P3oool4
0000oel0oooo001O0?ooo`<0003o1P3oool40000o`H0oooo10000?l50?ooo`@0003o1@3oool40000
o`H0oooo10000?l50?ooo`@0003o1@3oool40000o`D0oooo10000?l60?ooo`@0003o1P3oool30000
of00oooo001M0?ooo`80003o0`3oool00`000?l0oooo0?ooo`030?ooo`<0003o00<0oooo0000o`3o
ool0103oool30000o`H0oooo0`000?l70?ooo`<0003o1P3oool30000o`H0oooo0`000?l70?ooo`<0
003o1P3oool30000o`D0oooo00<0003o0?ooo`000?l00P000?l50?ooo`040000o`3oool0oooo0?oo
o`80003oGP3oool005/0oooo0P000?l60?ooo`<0003o00<0oooo0000o`3oool00`3oool010000?l0
oooo0?ooo`3oool20000o`<0oooo0P000?l30?ooo`040000o`3oool0oooo0?ooo`80003o0`3oool2
0000o`<0oooo00<0003o0?ooo`3oool00P3oool01@000?l0oooo0?ooo`3oool0003o00@0oooo00@0
003o0?ooo`3oool0oooo0P000?l30?ooo`80003o0`3oool010000?l0oooo0?ooo`3oool20000o`<0
oooo0P000?l30?ooo`030000o`3oool0oooo0080oooo00<0003o0?ooo`000?l00P000?l60?ooo`80
003oG03oool005X0oooo10000?l50?ooo`@0003o1P3oool30000o`L0oooo0`000?l60?ooo`<0003o
1@3oool00`000?l0oooo0000o`020000o`D0oooo0`000?l00`3oool0003o0?ooo`040?ooo`<0003o
1P3oool30000o`L0oooo0`000?l60?ooo`@0003o1@3oool40000oe/0oooo001J0?ooo`@0003o1@3o
ool40000o`H0oooo10000?l50?ooo`@0003o1@3oool40000o`H0oooo10000?l50?ooo`@0003o1P3o
ool40000o`D0oooo10000?l50?ooo`@0003o1P3oool40000o`D0oooo10000?mK0?ooo`00F@3oool0
0`000?l0oooo0000o`020000o`H0oooo0`000?l60?ooo`@0003o1@3oool40000o`D0oooo10000?l6
0?ooo`@0003o1@3oool40000o`H0oooo10000?l50?ooo`@0003o1@3oool40000o`H0oooo0`000?l6
0?ooo`<0003o00<0oooo0000o`3oool0F@3oool005H0oooo0P000?l00`3oool0003o0?ooo`030?oo
o`040000o`3oool0oooo0?ooo`80003o0`3oool00`000?l0oooo0?ooo`020?ooo`030000o`3oool0
003o0080003o1@3oool30000o`030?ooo`000?l0oooo00<0oooo0`000?l00`3oool0003o0?ooo`04
0?ooo`<0003o1`3oool30000o`D0oooo00<0003o0?ooo`000?l00P000?l40?ooo`030000o`3oool0
003o0080003o1@3oool30000o`030?ooo`000?l0oooo00<0oooo00@0003o0?ooo`3oool0oooo0P00
0?l30?ooo`030000o`3oool0oooo0080oooo00@0003o0?ooo`000?l0003oE`3oool005D0oooo1000
0?l60?ooo`<0003o1P3oool30000o`030?ooo`000?l0oooo00<0oooo00D0003o0?ooo`3oool0oooo
0000o`040?ooo`050000o`3oool0oooo0?ooo`000?l01@3oool01@000?l0oooo0?ooo`3oool0003o
00<0oooo0P000?l30?ooo`80003o0`3oool01@000?l0oooo0?ooo`3oool0003o00D0oooo00D0003o
0?ooo`3oool0oooo0000o`040?ooo`050000o`3oool0oooo0?ooo`000?l0103oool00`000?l0oooo
0000o`020000o`H0oooo0`000?l60?ooo`@0003oEP3oool005D0oooo10000?l60?ooo`@0003o1@3o
ool40000o`H0oooo0`000?l60?ooo`<0003o1`3oool30000o`H0oooo0`000?l60?ooo`<0003o1`3o
ool30000o`H0oooo0`000?l60?ooo`@0003o1@3oool40000o`H0oooo10000?mF0?ooo`00EP3oool3
0000o`H0oooo10000?l50?ooo`@0003o1P3oool40000o`D0oooo10000?l50?ooo`@0003o1P3oool4
0000o`D0oooo10000?l50?ooo`@0003o1@3oool40000o`H0oooo10000?l50?ooo`@0003o1P3oool3
0000oeL0oooo001D0?ooo`80003o0`3oool00`000?l0oooo0?ooo`020?ooo`030000o`3oool0003o
0080003o1P3oool30000o`H0oooo10000?l50?ooo`@0003o1@3oool40000o`H0oooo10000?l50?oo
o`@0003o1@3oool40000o`D0oooo10000?l60?ooo`<0003o1P3oool30000o`030?ooo`000?l0oooo
00<0oooo00@0003o0?ooo`3oool0oooo0P000?mE0?ooo`00DP3oool20000o`H0oooo0`000?l00`3o
ool0003o0?ooo`020?ooo`030000o`3oool0oooo00<0oooo00D0003o0?ooo`3oool0oooo0000o`04
0?ooo`030000o`3oool0003o0080003o103oool00`000?l0oooo0000o`020000o`D0oooo0`000?l0
0`3oool0003o0?ooo`030?ooo`030000o`3oool0003o0080003o103oool00`000?l0oooo0000o`02
0000o`D0oooo0`000?l00`3oool0003o0?ooo`030?ooo`<0003o00<0oooo0000o`3oool00`3oool0
10000?l0oooo0?ooo`3oool20000o`<0oooo00<0003o0?ooo`3oool00P3oool00`000?l0oooo0000
o`020000o`H0oooo0`000?mB0?ooo`00D@3oool40000o`D0oooo10000?l50?ooo`030000o`3oool0
003o0080003o1@3oool30000o`030?ooo`000?l0oooo00<0oooo0`000?l00`3oool0003o0?ooo`03
0?ooo`030000o`3oool0003o0080003o103oool00`000?l0oooo0000o`020000o`D0oooo0`000?l0
0`3oool0003o0?ooo`030?ooo`<0003o00<0oooo0000o`3oool00`3oool00`000?l0oooo0000o`02
0000o`D0oooo0`000?l00`3oool0003o0?ooo`040?ooo`<0003o1P3oool40000o`H0oooo10000?mA
0?ooo`00D@3oool40000o`D0oooo10000?l60?ooo`@0003o1@3oool40000o`D0oooo10000?l60?oo
o`@0003o1@3oool40000o`D0oooo10000?l50?ooo`@0003o1P3oool40000o`D0oooo10000?l50?oo
o`@0003o1P3oool40000o`H0oooo10000?mA0?ooo`00D03oool00`000?l0oooo0000o`020000o`H0
oooo0`000?l60?ooo`@0003o1@3oool40000o`D0oooo10000?l60?ooo`@0003o1@3oool40000o`D0
oooo10000?l50?ooo`@0003o1P3oool40000o`D0oooo10000?l50?ooo`@0003o1P3oool30000o`H0
oooo00<0003o0?ooo`000?l00P000?mA0?ooo`00C@3oool30000o`D0oooo00@0003o0?ooo`3oool0
oooo0P000?l30?ooo`030000o`3oool0oooo00<0oooo0`000?l70?ooo`<0003o1P3oool30000o`H0
oooo0`000?l60?ooo`<0003o1`3oool30000o`H0oooo0`000?l60?ooo`<0003o1`3oool30000o`D0
oooo0`000?l00`3oool0003o0?ooo`030?ooo`040000o`3oool0oooo0?ooo`80003o0`3oool00`00
0?l0oooo0?ooo`030?ooo`<0003oCP3oool004`0oooo10000?l60?ooo`<0003o1P3oool01@000?l0
oooo0?ooo`3oool0003o00<0oooo0P000?l30?ooo`80003o0`3oool010000?l0oooo0?ooo`3oool2
0000o`<0oooo00<0003o0?ooo`3oool00P3oool01@000?l0oooo0?ooo`3oool0003o00@0oooo00D0
003o0?ooo`3oool0oooo0000o`050?ooo`050000o`3oool0oooo0?ooo`000?l0103oool01@000?l0
oooo0?ooo`3oool0003o00@0oooo00@0003o0?ooo`3oool0oooo0P000?l30?ooo`80003o0`3oool0
1@000?l0oooo0?ooo`3oool0003o00@0oooo00D0003o0?ooo`3oool0oooo0000o`060?ooo`<0003o
1P3oool40000odd0oooo001<0?ooo`@0003o1@3oool40000o`L0oooo0`000?l60?ooo`<0003o1P3o
ool30000o`D0oooo00<0003o0?ooo`000?l00P000?l50?ooo`<0003o00<0oooo0000o`3oool00`3o
ool00`000?l0oooo0000o`020000o`@0oooo00<0003o0?ooo`000?l00P000?l50?ooo`<0003o00<0
oooo0000o`3oool0103oool30000o`H0oooo0`000?l60?ooo`<0003o1`3oool40000o`D0oooo1000
0?m=0?ooo`00C03oool30000o`H0oooo10000?l60?ooo`@0003o1@3oool40000o`H0oooo10000?l5
0?ooo`@0003o1@3oool40000o`H0oooo10000?l50?ooo`@0003o1@3oool40000o`D0oooo10000?l6
0?ooo`@0003o1@3oool40000o`H0oooo10000?l60?ooo`<0003oC@3oool004/0oooo00D0003o0?oo
o`3oool0oooo0000o`050?ooo`<0003o00<0oooo0000o`3oool0103oool40000o`D0oooo10000?l6
0?ooo`@0003o1@3oool40000o`D0oooo10000?l60?ooo`@0003o1@3oool40000o`D0oooo10000?l5
0?ooo`@0003o1P3oool40000o`D0oooo10000?l50?ooo`030000o`3oool0003o0080003o1@3oool0
1@000?l0oooo0?ooo`3oool0003o04`0oooo00180?ooo`<0003o1@3oool00`000?l0oooo0000o`02
0000o`@0oooo00<0003o0?ooo`3oool00`3oool30000o`030?ooo`000?l0oooo00<0oooo0`000?l0
0`3oool0003o0?ooo`030?ooo`030000o`3oool0003o0080003o1@3oool30000o`L0oooo0`000?l6
0?ooo`<0003o1P3oool30000o`L0oooo0`000?l50?ooo`<0003o00<0oooo0000o`3oool00`3oool0
0`000?l0oooo0000o`020000o`@0oooo00<0003o0?ooo`000?l00P000?l40?ooo`030000o`3oool0
oooo00<0oooo0`000?l00`3oool0003o0?ooo`040?ooo`<0003oB@3oool004L0oooo10000?l60?oo
o`@0003o1@3oool30000o`030?ooo`000?l0oooo00<0oooo00<0003o0?ooo`000?l00P000?l40?oo
o`030000o`3oool0003o0080003o1@3oool01@000?l0oooo0?ooo`3oool0003o00<0oooo0P000?l3
0?ooo`80003o0`3oool010000?l0oooo0?ooo`3oool20000o`<0oooo0P000?l30?ooo`040000o`3o
ool0oooo0?ooo`80003o0`3oool20000o`<0oooo00D0003o0?ooo`3oool0oooo0000o`050?ooo`<0
003o00<0oooo0000o`3oool00`3oool30000o`030?ooo`000?l0oooo00<0oooo00<0003o0?ooo`00
0?l00P000?l50?ooo`@0003o1P3oool40000odP0oooo00170?ooo`@0003o1P3oool40000o`D0oooo
10000?l60?ooo`@0003o1@3oool40000o`H0oooo0`000?l60?ooo`<0003o1P3oool30000o`L0oooo
0`000?l60?ooo`<0003o1P3oool30000o`H0oooo10000?l50?ooo`@0003o1P3oool40000o`D0oooo
10000?l60?ooo`@0003oB03oool004L0oooo0`000?l00`3oool0003o0?ooo`040?ooo`<0003o1P3o
ool40000o`H0oooo10000?l50?ooo`@0003o1@3oool40000o`H0oooo10000?l50?ooo`@0003o1@3o
ool40000o`D0oooo10000?l60?ooo`@0003o1@3oool40000o`D0oooo10000?l60?ooo`@0003o1P3o
ool30000o`D0oooo00<0003o0?ooo`000?l00P000?m80?ooo`00@`3oool20000o`030?ooo`000?l0
oooo00@0oooo00D0003o0?ooo`3oool0oooo0000o`030?ooo`030000o`3oool0oooo00@0oooo0`00
0?l60?ooo`<0003o1P3oool30000o`H0oooo10000?l60?ooo`@0003o1@3oool40000o`D0oooo1000
0?l50?ooo`@0003o1P3oool40000o`H0oooo0`000?l60?ooo`<0003o1P3oool30000o`H0oooo00D0
003o0?ooo`3oool0oooo0000o`030?ooo`030000o`3oool0oooo00<0oooo00@0003o0?ooo`000?l0
003oA03oool00480oooo10000?l70?ooo`<0003o1@3oool010000?l0oooo0?ooo`3oool20000o`<0
oooo0P000?l30?ooo`050000o`3oool0oooo0?ooo`000?l0103oool01@000?l0oooo0?ooo`3oool0
003o00D0oooo0`000?l00`3oool0003o0?ooo`030?ooo`030000o`3oool0003o0080003o103oool0
0`000?l0oooo0000o`020000o`D0oooo0`000?l00`3oool0003o0?ooo`030?ooo`<0003o00<0oooo
0000o`3oool00`3oool00`000?l0oooo0000o`020000o`D0oooo00D0003o0?ooo`3oool0oooo0000
o`040?ooo`050000o`3oool0oooo0?ooo`000?l00`3oool20000o`<0oooo0P000?l30?ooo`030000
o`3oool0oooo00<0oooo0`000?l70?ooo`@0003o@`3oool00480oooo10000?l60?ooo`@0003o1P3o
ool30000o`L0oooo0`000?l50?ooo`<0003o00<0oooo0000o`3oool00`3oool00`000?l0oooo0000
o`020000o`@0oooo00<0003o0?ooo`000?l00P000?l50?ooo`050000o`3oool0oooo0?ooo`000?l0
103oool01@000?l0oooo0?ooo`3oool0003o00@0oooo00D0003o0?ooo`3oool0oooo0000o`050?oo
o`<0003o00<0oooo0000o`3oool00`3oool30000o`030?ooo`000?l0oooo00<0oooo00<0003o0?oo
o`000?l00P000?l50?ooo`<0003o1`3oool30000o`H0oooo10000?l60?ooo`@0003o@`3oool004<0
oooo0`000?l60?ooo`@0003o1P3oool40000o`D0oooo10000?l50?ooo`@0003o1P3oool40000o`D0
oooo10000?l60?ooo`<0003o1P3oool30000o`H0oooo0`000?l60?ooo`@0003o1@3oool40000o`H0
oooo10000?l50?ooo`@0003o1@3oool40000o`H0oooo10000?l60?ooo`<0003oA03oool00440oooo
0P000?l30?ooo`030000o`3oool0oooo00<0oooo10000?l60?ooo`@0003o1@3oool40000o`D0oooo
10000?l60?ooo`@0003o1@3oool40000o`D0oooo10000?l60?ooo`@0003o1@3oool40000o`D0oooo
10000?l50?ooo`@0003o1P3oool40000o`D0oooo10000?l50?ooo`@0003o1P3oool40000o`D0oooo
00@0003o0?ooo`3oool0oooo0P000?m20?ooo`00?`3oool20000o`H0oooo0`000?l00`3oool0003o
0?ooo`030?ooo`030000o`3oool0oooo0080oooo00<0003o0?ooo`000?l00P000?l50?ooo`<0003o
00<0oooo0000o`3oool0103oool30000o`H0oooo0`000?l60?ooo`<0003o1P3oool40000o`H0oooo
10000?l50?ooo`@0003o1P3oool30000o`H0oooo0`000?l60?ooo`<0003o1@3oool00`000?l0oooo
0000o`020000o`D0oooo0`000?l00`3oool0003o0?ooo`030?ooo`030000o`3oool0oooo0080oooo
00<0003o0?ooo`000?l00P000?l60?ooo`80003o@03oool003h0oooo10000?l50?ooo`@0003o1P3o
ool40000o`D0oooo0`000?l00`3oool0003o0?ooo`030?ooo`040000o`3oool0oooo0?ooo`80003o
0`3oool010000?l0oooo0?ooo`3oool20000o`<0oooo00<0003o0?ooo`3oool00P3oool01@000?l0
oooo0?ooo`3oool0003o00D0oooo0`000?l00`3oool0003o0?ooo`030?ooo`030000o`3oool0003o
0080003o103oool00`000?l0oooo0000o`020000o`D0oooo00D0003o0?ooo`3oool0oooo0000o`04
0?ooo`040000o`3oool0oooo0?ooo`80003o0`3oool010000?l0oooo0?ooo`3oool20000o`<0oooo
00<0003o0?ooo`3oool00P3oool00`000?l0oooo0000o`020000o`D0oooo10000?l60?ooo`@0003o
1@3oool40000ocl0oooo000n0?ooo`@0003o1@3oool40000o`H0oooo10000?l50?ooo`@0003o1P3o
ool30000o`H0oooo0`000?l60?ooo`<0003o00<0oooo0000o`3oool00`3oool00`000?l0oooo0000
o`020000o`@0oooo00<0003o0?ooo`000?l00P000?l50?ooo`<0003o00<0oooo0000o`3oool00`3o
ool30000o`030?ooo`000?l0oooo00<0oooo00<0003o0?ooo`000?l00P000?l60?ooo`<0003o1P3o
ool30000o`H0oooo10000?l50?ooo`@0003o1P3oool40000o`D0oooo10000?lo0?ooo`00?@3oool0
0`000?l0oooo0000o`020000o`H0oooo0`000?l60?ooo`@0003o1@3oool40000o`H0oooo10000?l5
0?ooo`@0003o1@3oool40000o`H0oooo10000?l50?ooo`@0003o1@3oool40000o`D0oooo10000?l6
0?ooo`@0003o1@3oool40000o`D0oooo10000?l60?ooo`@0003o1@3oool40000o`H0oooo0`000?l6
0?ooo`<0003o00<0oooo0000o`3oool0?@3oool003X0oooo0`000?l50?ooo`040000o`3oool0oooo
0?ooo`80003o0`3oool00`000?l0oooo0?ooo`030?ooo`<0003o1`3oool30000o`H0oooo10000?l5
0?ooo`@0003o1@3oool40000o`H0oooo10000?l50?ooo`@0003o1@3oool40000o`D0oooo10000?l6
0?ooo`@0003o1@3oool40000o`D0oooo10000?l60?ooo`<0003o1`3oool30000o`D0oooo00@0003o
0?ooo`3oool0oooo0P000?l30?ooo`030000o`3oool0oooo00<0oooo0`000?lk0?ooo`00>@3oool4
0000o`H0oooo0`000?l60?ooo`050000o`3oool0oooo0?ooo`000?l00`3oool20000o`<0oooo0P00
0?l30?ooo`030000o`3oool0oooo0080oooo00<0003o0?ooo`000?l00P000?l40?ooo`030000o`3o
ool0003o0080003o1P3oool30000o`H0oooo0`000?l60?ooo`<0003o1`3oool30000o`H0oooo0`00
0?l60?ooo`<0003o1P3oool30000o`030?ooo`000?l0oooo00<0oooo0`000?l00`3oool0003o0?oo
o`030?ooo`040000o`3oool0oooo0?ooo`80003o0`3oool20000o`<0oooo00D0003o0?ooo`3oool0
oooo0000o`060?ooo`<0003o1P3oool40000ocX0oooo000i0?ooo`@0003o1P3oool40000o`H0oooo
0`000?l60?ooo`<0003o1@3oool00`000?l0oooo0000o`020000o`D0oooo0`000?l00`3oool0003o
0?ooo`030?ooo`040000o`3oool0oooo0?ooo`80003o0`3oool010000?l0oooo0?ooo`3oool20000
o`<0oooo00<0003o0?ooo`3oool00P3oool01@000?l0oooo0?ooo`3oool0003o00D0oooo00D0003o
0?ooo`3oool0oooo0000o`040?ooo`040000o`3oool0oooo0?ooo`80003o0`3oool010000?l0oooo
0?ooo`3oool20000o`<0oooo00<0003o0?ooo`3oool00P3oool00`000?l0oooo0000o`020000o`D0
oooo0`000?l00`3oool0003o0?ooo`040?ooo`<0003o1P3oool30000o`H0oooo10000?l60?ooo`@0
003o>P3oool003T0oooo0`000?l70?ooo`@0003o1@3oool40000o`H0oooo10000?l50?ooo`@0003o
1@3oool40000o`H0oooo0`000?l60?ooo`<0003o1P3oool30000o`030?ooo`000?l0oooo00<0oooo
00<0003o0?ooo`000?l00P000?l40?ooo`030000o`3oool0003o0080003o1P3oool30000o`H0oooo
0`000?l60?ooo`@0003o1@3oool40000o`D0oooo10000?l60?ooo`@0003o1@3oool40000o`L0oooo
0`000?lj0?ooo`00=@3oool20000o`030?ooo`000?l0oooo0080oooo00<0003o0?ooo`3oool00`3o
ool00`000?l0oooo0000o`020000o`D0oooo10000?l60?ooo`@0003o1@3oool40000o`D0oooo1000
0?l60?ooo`@0003o1@3oool40000o`D0oooo10000?l60?ooo`@0003o1@3oool40000o`D0oooo1000
0?l50?ooo`@0003o1P3oool40000o`D0oooo10000?l50?ooo`@0003o1P3oool40000o`D0oooo0`00
0?l00`3oool0003o0?ooo`040?ooo`060000o`3oool0oooo0?ooo`000?l0oooo0P000?lf0?ooo`00
=03oool40000o`D0oooo00<0003o0?ooo`000?l00P000?l50?ooo`040000o`3oool0oooo0?ooo`@0
003o00<0oooo0000o`3oool00`3oool00`000?l0oooo0000o`020000o`D0oooo0`000?l70?ooo`<0
003o1P3oool40000o`D0oooo10000?l50?ooo`@0003o1P3oool40000o`D0oooo10000?l50?ooo`@0
003o1@3oool40000o`H0oooo0`000?l70?ooo`<0003o1@3oool30000o`030?ooo`000?l0oooo00<0
oooo00<0003o0?ooo`000?l00`000?l30?ooo`030000o`3oool0oooo00<0oooo0`000?l00`3oool0
003o0?ooo`040?ooo`@0003o=@3oool003@0oooo10000?l60?ooo`@0003o1P3oool30000o`D0oooo
00<0003o0?ooo`000?l00P000?l50?ooo`050000o`3oool0oooo0?ooo`000?l00`3oool00`000?l0
oooo0?ooo`030?ooo`050000o`3oool0oooo0?ooo`000?l0103oool00`000?l0oooo0000o`020000
o`@0oooo00<0003o0?ooo`000?l00P000?l60?ooo`<0003o1P3oool30000o`H0oooo0`000?l60?oo
o`<0003o00<0oooo0000o`3oool00`3oool30000o`030?ooo`000?l0oooo00<0oooo00D0003o0?oo
o`3oool0oooo0000o`050?ooo`050000o`3oool0oooo0?ooo`000?l00`3oool00`000?l0oooo0?oo
o`030?ooo`<0003o00<0oooo0000o`3oool0103oool30000o`H0oooo10000?l60?ooo`@0003o=@3o
ool003D0oooo0`000?l60?ooo`@0003o1@3oool40000o`H0oooo10000?l60?ooo`<0003o1@3oool0
0`000?l0oooo0000o`020000o`@0oooo00<0003o0?ooo`000?l00P000?l50?ooo`050000o`3oool0
oooo0?ooo`000?l0103oool010000?l0oooo0?ooo`3oool20000o`<0oooo00@0003o0?ooo`3oool0
oooo0P000?l30?ooo`80003o0`3oool010000?l0oooo0?ooo`3oool20000o`<0oooo00<0003o0?oo
o`3oool00P3oool01@000?l0oooo0?ooo`3oool0003o00D0oooo0`000?l00`3oool0003o0?ooo`03
0?ooo`030000o`3oool0003o0080003o1@3oool30000o`H0oooo10000?l60?ooo`@0003o1@3oool4
0000o`H0oooo0`000?lf0?ooo`00<`3oool20000o`<0oooo00<0003o0?ooo`3oool00`3oool30000
o`H0oooo10000?l60?ooo`@0003o1@3oool40000o`H0oooo10000?l50?ooo`@0003o1P3oool30000
o`H0oooo0`000?l60?ooo`<0003o1`3oool30000o`H0oooo0`000?l60?ooo`<0003o1P3oool40000
o`H0oooo10000?l50?ooo`@0003o1@3oool40000o`H0oooo10000?l60?ooo`<0003o1@3oool01000
0?l0oooo0?ooo`3oool20000oc@0oooo000`0?ooo`<0003o1P3oool01@000?l0oooo0?ooo`3oool0
003o00<0oooo00<0003o0?ooo`3oool00`3oool30000o`030?ooo`000?l0oooo00@0oooo0`000?l6
0?ooo`@0003o1P3oool40000o`D0oooo10000?l50?ooo`@0003o1P3oool40000o`D0oooo10000?l5
0?ooo`@0003o1@3oool40000o`H0oooo10000?l50?ooo`@0003o1P3oool40000o`D0oooo10000?l6
0?ooo`<0003o1@3oool00`000?l0oooo0000o`020000o`D0oooo00@0003o0?ooo`3oool0oooo0P00
0?l30?ooo`030000o`3oool0oooo00<0oooo0`000?la0?ooo`00;`3oool40000o`L0oooo0`000?l5
0?ooo`030000o`3oool0003o0080003o103oool010000?l0oooo0?ooo`3oool20000o`<0oooo00<0
003o0?ooo`3oool00`3oool30000o`030?ooo`000?l0oooo00@0oooo0`000?l60?ooo`<0003o1P3o
ool40000o`H0oooo10000?l50?ooo`@0003o1@3oool40000o`D0oooo10000?l60?ooo`@0003o1P3o
ool30000o`H0oooo0`000?l50?ooo`030000o`3oool0003o0080003o1@3oool010000?l0oooo0?oo
o`3oool20000o`<0oooo00<0003o0?ooo`3oool00P3oool30000o`030?ooo`000?l0oooo00D0oooo
0`000?l60?ooo`@0003o<03oool002l0oooo10000?l60?ooo`@0003o1P3oool40000o`D0oooo0`00
0?l60?ooo`<0003o00<0oooo0000o`3oool00`3oool010000?l0oooo0?ooo`3oool20000o`<0oooo
0P000?l30?ooo`050000o`3oool0oooo0?ooo`000?l01@3oool30000o`030?ooo`000?l0oooo00<0
oooo00<0003o0?ooo`000?l00P000?l40?ooo`030000o`3oool0003o0080003o1@3oool30000o`03
0?ooo`000?l0oooo00<0oooo0`000?l00`3oool0003o0?ooo`030?ooo`030000o`3oool0003o0080
003o1@3oool01@000?l0oooo0?ooo`3oool0003o00<0oooo0P000?l30?ooo`80003o0`3oool00`00
0?l0oooo0?ooo`020?ooo`030000o`3oool0003o0080003o1P3oool30000o`D0oooo10000?l60?oo
o`@0003o1P3oool40000oc00oooo000_0?ooo`<0003o00<0oooo0000o`3oool0103oool40000o`H0
oooo10000?l50?ooo`@0003o1@3oool40000o`H0oooo0`000?l70?ooo`<0003o1@3oool00`000?l0
oooo0000o`020000o`@0oooo00<0003o0?ooo`000?l00P000?l50?ooo`050000o`3oool0oooo0?oo
o`000?l0103oool01@000?l0oooo0?ooo`3oool0003o00@0oooo00D0003o0?ooo`3oool0oooo0000
o`050?ooo`<0003o00<0oooo0000o`3oool00`3oool30000o`030?ooo`000?l0oooo00@0oooo0`00
0?l70?ooo`<0003o1P3oool40000o`D0oooo10000?l50?ooo`@0003o1P3oool40000o`D0oooo00<0
003o0?ooo`000?l00P000?l`0?ooo`00;03oool30000o`@0oooo00<0003o0?ooo`3oool00`3oool3
0000o`030?ooo`000?l0oooo00@0oooo0`000?l60?ooo`@0003o1@3oool40000o`H0oooo10000?l5
0?ooo`@0003o1P3oool40000o`D0oooo10000?l60?ooo`<0003o1P3oool30000o`H0oooo0`000?l6
0?ooo`@0003o1@3oool40000o`H0oooo10000?l50?ooo`@0003o1P3oool40000o`D0oooo10000?l6
0?ooo`<0003o1P3oool30000o`030?ooo`000?l0oooo0080oooo00<0003o0?ooo`3oool00`3oool3
0000obd0oooo000[0?ooo`@0003o1@3oool30000o`030?ooo`000?l0oooo00<0oooo00@0003o0?oo
o`3oool0oooo0P000?l30?ooo`030000o`3oool0oooo0080oooo00<0003o0?ooo`000?l00P000?l6
0?ooo`<0003o1P3oool40000o`D0oooo10000?l60?ooo`@0003o1@3oool40000o`D0oooo10000?l6
0?ooo`@0003o1@3oool40000o`D0oooo10000?l50?ooo`@0003o1P3oool40000o`D0oooo10000?l6
0?ooo`<0003o1P3oool30000o`030?ooo`000?l0oooo00<0oooo00@0003o0?ooo`3oool0oooo0P00
0?l30?ooo`030000o`3oool0oooo0080oooo00<0003o0?ooo`000?l00P000?l50?ooo`@0003o;03o
ool002/0oooo10000?l50?ooo`@0003o1P3oool30000o`H0oooo0`000?l00`3oool0003o0?ooo`03
0?ooo`040000o`3oool0oooo0?ooo`80003o0`3oool010000?l0oooo0?ooo`3oool20000o`040?oo
o`000?l0003o0000o`D0oooo0`000?l00`3oool0003o0?ooo`040?ooo`<0003o1P3oool30000o`H0
oooo10000?l60?ooo`@0003o1@3oool40000o`H0oooo0`000?l60?ooo`<0003o1@3oool00`000?l0
oooo0000o`020000o`D0oooo0`000?l00`3oool0003o0000o`030?ooo`040000o`3oool0oooo0?oo
o`80003o0`3oool00`000?l0oooo0?ooo`020?ooo`030000o`3oool0003o0080003o1P3oool30000
o`H0oooo10000?l50?ooo`@0003o;03oool002/0oooo0`000?l60?ooo`@0003o1P3oool40000o`D0
oooo10000?l60?ooo`<0003o1P3oool30000o`H0oooo0`000?l00`3oool0003o0?ooo`030?ooo`04
0000o`3oool0oooo0?ooo`80003o0`3oool00`000?l0oooo0?ooo`020?ooo`050000o`3oool0oooo
0?ooo`000?l01@3oool30000o`030?ooo`000?l0oooo00<0oooo00<0003o0?ooo`000?l00P000?l4
0?ooo`030000o`3oool0003o0080003o1@3oool01@000?l0oooo0?ooo`3oool0003o00<0oooo0P00
0?l30?ooo`80003o0`3oool00`000?l0oooo0?ooo`020?ooo`030000o`3oool0003o0080003o1P3o
ool30000o`H0oooo0`000?l60?ooo`@0003o1@3oool40000o`H0oooo10000?l60?ooo`<0003o;03o
ool002T0oooo0P000?l30?ooo`030000o`3oool0oooo00@0oooo0`000?l60?ooo`@0003o1@3oool4
0000o`D0oooo10000?l60?ooo`@0003o1@3oool40000o`H0oooo0`000?l60?ooo`<0003o00<0oooo
0000o`3oool00`3oool00`000?l0oooo0000o`020000o`@0oooo00<0003o0?ooo`000?l00P000?l5
0?ooo`<0003o00<0oooo0000o`3oool00`3oool30000o`030?ooo`000?l0oooo00@0oooo0`000?l7
0?ooo`<0003o1P3oool40000o`D0oooo10000?l60?ooo`@0003o1@3oool40000o`D0oooo10000?l6
0?ooo`<0003o1P3oool010000?l0oooo0?ooo`3oool20000obX0oooo000W0?ooo`80003o1P3oool0
10000?l0oooo0?ooo`3oool20000o`<0oooo00<0003o0?ooo`3oool00P3oool00`000?l0oooo0000
o`020000o`H0oooo0`000?l50?ooo`@0003o1P3oool40000o`D0oooo10000?l60?ooo`@0003o1@3o
ool40000o`H0oooo10000?l50?ooo`@0003o1@3oool40000o`D0oooo10000?l60?ooo`@0003o1@3o
ool40000o`H0oooo10000?l50?ooo`@0003o1P3oool40000o`D0oooo0`000?l60?ooo`<0003o00<0
oooo0000o`3oool00`3oool010000?l0oooo0?ooo`3oool20000o`<0oooo00<0003o0?ooo`3oool0
103oool20000obP0oooo000V0?ooo`@0003o1P3oool30000o`H0oooo0`000?l00`3oool0003o0?oo
o`030?ooo`040000o`3oool0oooo0?ooo`80003o0`3oool00`000?l0oooo0?ooo`020?ooo`<0003o
00<0oooo0000o`3oool00`3oool00`000?l0oooo0000o`020000o`H0oooo0`000?l60?ooo`@0003o
1@3oool40000o`H0oooo10000?l50?ooo`@0003o1@3oool40000o`D0oooo10000?l60?ooo`@0003o
1@3oool40000o`H0oooo0`000?l60?ooo`<0003o00<0oooo0000o`3oool00`3oool00`000?l0oooo
0000o`020000o`@0oooo00@0003o0?ooo`3oool0oooo0P000?l30?ooo`030000o`3oool0oooo0080
oooo00<0003o0?ooo`000?l00P000?l60?ooo`<0003o1P3oool40000obL0oooo000V0?ooo`@0003o
1@3oool40000o`H0oooo10000?l60?ooo`<0003o1@3oool00`000?l0oooo0000o`020000o`D0oooo
0`000?l00`3oool0003o0?ooo`030?ooo`040000o`3oool0oooo0?ooo`80003o0`3oool00`000?l0
oooo0?ooo`020?ooo`030000o`3oool0003o0080003o1P3oool30000o`H0oooo0`000?l60?ooo`<0
003o1`3oool30000o`H0oooo0`000?l50?ooo`030000o`3oool0003o0080003o1@3oool30000o`03
0?ooo`000?l0oooo00<0oooo00@0003o0?ooo`3oool0oooo0P000?l30?ooo`030000o`3oool0oooo
0080oooo00<0003o0?ooo`000?l00P000?l50?ooo`<0003o00<0oooo0000o`3oool0103oool30000
o`H0oooo10000?l60?ooo`@0003o1@3oool40000obL0oooo000U0?ooo`030000o`3oool0003o0080
003o1@3oool40000o`H0oooo10000?l50?ooo`@0003o1P3oool40000o`D0oooo10000?l60?ooo`<0
003o1@3oool00`000?l0oooo0000o`020000o`D0oooo00@0003o0?ooo`3oool0oooo0P000?l30?oo
o`040000o`3oool0oooo0?ooo`80003o0`3oool00`000?l0oooo0?ooo`020?ooo`050000o`3oool0
oooo0?ooo`000?l01@3oool01@000?l0oooo0?ooo`3oool0003o00@0oooo00@0003o0?ooo`3oool0
oooo0P000?l30?ooo`030000o`3oool0oooo0080oooo00D0003o0?ooo`3oool0oooo0000o`050?oo
o`<0003o00<0oooo0000o`3oool0103oool30000o`H0oooo10000?l50?ooo`@0003o1P3oool40000
o`D0oooo10000?l60?ooo`@0003o1@3oool30000o`030?ooo`000?l0oooo02D0oooo000R0?ooo`<0
003o1@3oool010000?l0oooo0?ooo`3oool40000o`030?ooo`000?l0oooo00D0oooo0`000?l50?oo
o`@0003o1P3oool40000o`D0oooo10000?l60?ooo`@0003o1@3oool40000o`H0oooo0`000?l60?oo
o`<0003o1P3oool30000o`030?ooo`000?l0oooo00<0oooo00<0003o0?ooo`000?l00P000?l40?oo
o`030000o`3oool0003o0080003o1P3oool30000o`H0oooo0`000?l60?ooo`@0003o1@3oool40000
o`H0oooo10000?l50?ooo`@0003o1P3oool40000o`D0oooo0`000?l60?ooo`030000o`3oool0003o
00<0003o0`3oool00`000?l0oooo0?ooo`030?ooo`<0003o8`3oool00240oooo10000?l60?ooo`<0
003o1P3oool010000?l0oooo0?ooo`3oool20000o`<0oooo00<0003o0?ooo`3oool00P3oool30000
o`030?ooo`000?l0oooo00@0oooo0`000?l70?ooo`<0003o1P3oool40000o`D0oooo10000?l50?oo
o`@0003o1P3oool40000o`D0oooo10000?l60?ooo`@0003o1@3oool40000o`D0oooo10000?l60?oo
o`@0003o1@3oool40000o`D0oooo10000?l60?ooo`<0003o1`3oool30000o`D0oooo00<0003o0?oo
o`000?l00P000?l40?ooo`040000o`3oool0oooo0?ooo`80003o0`3oool00`000?l0oooo0?ooo`04
0?ooo`<0003o1P3oool40000ob80oooo000Q0?ooo`@0003o1P3oool40000o`H0oooo0`000?l50?oo
o`030000o`3oool0003o0080003o103oool00`000?l0oooo0000o`030000o`<0oooo0P000?l30?oo
o`80003o0`3oool00`000?l0oooo0?ooo`020?ooo`030000o`3oool0003o0080003o1@3oool30000
o`H0oooo10000?l60?ooo`@0003o1@3oool40000o`H0oooo10000?l50?ooo`@0003o1@3oool40000
o`H0oooo10000?l60?ooo`<0003o1@3oool30000o`030?ooo`000?l0oooo00<0oooo00@0003o0?oo
o`3oool0oooo0P000?l30?ooo`80003o0`3oool40000o`030?ooo`000?l0oooo00<0oooo0`000?l0
0`3oool0003o0?ooo`040?ooo`<0003o1P3oool40000o`H0oooo10000?lR0?ooo`008@3oool30000
o`L0oooo10000?l50?ooo`@0003o1P3oool40000o`D0oooo10000?l60?ooo`<0003o1@3oool00`00
0?l0oooo0000o`020000o`D0oooo00D0003o0?ooo`3oool0oooo0000o`030?ooo`030000o`3oool0
oooo00<0oooo0`000?l00`3oool0003o0?ooo`030?ooo`030000o`3oool0003o0080003o1P3oool3
0000o`H0oooo0`000?l60?ooo`<0003o1P3oool30000o`030?ooo`000?l0oooo00<0oooo00<0003o
0?ooo`000?l00P000?l50?ooo`050000o`3oool0oooo0?ooo`000?l00`3oool00`000?l0oooo0?oo
o`030?ooo`<0003o00<0oooo0000o`3oool0103oool30000o`H0oooo10000?l50?ooo`@0003o1P3o
ool40000o`D0oooo10000?l70?ooo`<0003o8P3oool00200oooo00D0003o0?ooo`3oool0oooo0000
o`050?ooo`030000o`3oool0003o0080003o1@3oool40000o`H0oooo10000?l50?ooo`@0003o1@3o
ool40000o`H0oooo10000?l60?ooo`<0003o1@3oool00`000?l0oooo0000o`020000o`D0oooo0`00
0?l00`3oool0003o0?ooo`030?ooo`040000o`3oool0oooo0?ooo`80003o0`3oool010000?l0oooo
0?ooo`3oool20000o`<0oooo0P000?l30?ooo`040000o`3oool0oooo0?ooo`80003o0`3oool00`00
0?l0oooo0?ooo`020?ooo`030000o`3oool0003o0080003o1@3oool30000o`030?ooo`000?l0oooo
00@0oooo0`000?l60?ooo`@0003o1P3oool40000o`D0oooo10000?l50?ooo`@0003o1P3oool40000
o`D0oooo0`000?l00`3oool0003o0?ooo`040?ooo`050000o`3oool0oooo0?ooo`000?l08@3oool0
01d0oooo0`000?l50?ooo`030000o`3oool0003o0080003o103oool00`000?l0oooo0?ooo`030?oo
o`<0003o00<0oooo0000o`3oool0103oool30000o`H0oooo0`000?l60?ooo`@0003o1P3oool40000
o`D0oooo10000?l60?ooo`@0003o1@3oool40000o`H0oooo0`000?l60?ooo`<0003o1`3oool30000
o`H0oooo0`000?l60?ooo`@0003o1@3oool40000o`H0oooo10000?l50?ooo`@0003o1P3oool40000
o`H0oooo0`000?l60?ooo`<0003o1@3oool00`000?l0oooo0000o`020000o`@0oooo00<0003o0?oo
o`3oool00`3oool30000o`030?ooo`000?l0oooo00@0oooo0`000?lN0?ooo`00703oool40000o`H0
oooo10000?l50?ooo`<0003o00<0oooo0000o`3oool00`3oool010000?l0oooo0?ooo`3oool20000
o`<0oooo0P000?l30?ooo`050000o`3oool0oooo0?ooo`000?l01@3oool30000o`030?ooo`000?l0
oooo00@0oooo0`000?l60?ooo`@0003o1P3oool40000o`D0oooo10000?l60?ooo`@0003o1@3oool4
0000o`D0oooo10000?l50?ooo`@0003o1P3oool40000o`D0oooo10000?l60?ooo`@0003o1P3oool3
0000o`D0oooo00<0003o0?ooo`000?l00P000?l50?ooo`050000o`3oool0oooo0?ooo`000?l00`3o
ool20000o`<0oooo0P000?l30?ooo`030000o`3oool0oooo0080oooo00<0003o0?ooo`000?l00P00
0?l50?ooo`@0003o1P3oool40000oad0oooo000L0?ooo`@0003o1P3oool40000o`D0oooo10000?l6
0?ooo`<0003o1`3oool30000o`D0oooo0`000?l00`3oool0003o0?ooo`030?ooo`040000o`3oool0
oooo0?ooo`80003o0`3oool00`000?l0oooo0?ooo`030?ooo`<0003o00<0oooo0000o`3oool0103o
ool30000o`L0oooo0`000?l60?ooo`@0003o1@3oool40000o`D0oooo10000?l50?ooo`@0003o1P3o
ool30000o`L0oooo0`000?l50?ooo`030000o`3oool0003o0080003o1@3oool010000?l0oooo0?oo
o`3oool20000o`<0oooo00<0003o0?ooo`3oool00P3oool00`000?l0oooo0000o`020000o`D0oooo
0`000?l70?ooo`<0003o1P3oool40000o`D0oooo10000?l60?ooo`@0003o7@3oool001`0oooo0`00
0?l00`3oool0003o0?ooo`040?ooo`<0003o1P3oool40000o`H0oooo10000?l50?ooo`@0003o1@3o
ool40000o`H0oooo0`000?l60?ooo`<0003o00<0oooo0000o`3oool00`3oool00`000?l0oooo0000
o`030000o`<0oooo0P000?l30?ooo`80003o0`3oool00`000?l0oooo0?ooo`020?ooo`030000o`3o
ool0003o0080003o103oool00`000?l0oooo0000o`020000o`D0oooo0`000?l00`3oool0003o0?oo
o`030?ooo`<0003o00<0oooo0000o`3oool00`3oool010000?l0oooo0?ooo`3oool20000o`<0oooo
0P000?l30?ooo`@0003o00<0oooo0000o`3oool00`3oool00`000?l0oooo0000o`020000o`H0oooo
0`000?l60?ooo`@0003o1@3oool40000o`D0oooo10000?l60?ooo`@0003o1P3oool30000o`D0oooo
00<0003o0?ooo`000?l00P000?lM0?ooo`00603oool20000o`030?ooo`000?l0oooo00@0oooo00D0
003o0?ooo`3oool0oooo0000o`030?ooo`030000o`3oool0oooo00@0oooo0`000?l60?ooo`@0003o
1@3oool40000o`D0oooo10000?l60?ooo`@0003o1@3oool40000o`H0oooo10000?l60?ooo`<0003o
1@3oool00`000?l0oooo0000o`020000o`D0oooo00D0003o0?ooo`3oool0oooo0000o`040?ooo`05
0000o`3oool0oooo0?ooo`000?l0103oool01@000?l0oooo0?ooo`3oool0003o00D0oooo0`000?l0
0`3oool0003o0?ooo`040?ooo`<0003o1P3oool40000o`H0oooo10000?l50?ooo`@0003o1P3oool4
0000o`D0oooo10000?l50?ooo`@0003o1P3oool30000o`H0oooo00D0003o0?ooo`3oool0oooo0000
o`030?ooo`030000o`3oool0oooo00<0oooo00@0003o0?ooo`000?l0003o6@3oool001L0oooo1000
0?l70?ooo`<0003o1@3oool010000?l0oooo0?ooo`3oool20000o`<0oooo00<0003o0?ooo`3oool0
0P3oool00`000?l0oooo0000o`020000o`D0oooo0`000?l00`3oool0003o0?ooo`040?ooo`<0003o
1P3oool40000o`D0oooo10000?l60?ooo`@0003o1@3oool40000o`H0oooo10000?l60?ooo`<0003o
1P3oool30000o`H0oooo0`000?l60?ooo`@0003o1P3oool40000o`D0oooo10000?l60?ooo`@0003o
1@3oool40000o`H0oooo0`000?l50?ooo`030000o`3oool0003o0080003o1@3oool30000o`030?oo
o`000?l0oooo00<0oooo00@0003o0?ooo`3oool0oooo0P000?l30?ooo`030000o`3oool0oooo00<0
oooo0`000?l70?ooo`@0003o603oool001L0oooo10000?l60?ooo`@0003o1P3oool30000o`D0oooo
00<0003o0?ooo`000?l00P000?l50?ooo`<0003o00<0oooo0000o`3oool00`3oool010000?l0oooo
0?ooo`3oool20000o`<0oooo00<0003o0?ooo`3oool00P3oool00`000?l0oooo0000o`020000o`H0
oooo0`000?l60?ooo`<0003o1P3oool40000o`H0oooo10000?l50?ooo`@0003o1P3oool40000o`D0
oooo10000?l50?ooo`@0003o1P3oool40000o`H0oooo0`000?l60?ooo`<0003o1P3oool30000o`03
0?ooo`000?l0oooo00<0oooo00@0003o0?ooo`3oool0oooo0P000?l30?ooo`030000o`3oool0oooo
0080oooo00<0003o0?ooo`000?l00P000?l50?ooo`<0003o00<0oooo0000o`3oool0103oool30000
o`H0oooo10000?l60?ooo`@0003o603oool001P0oooo0`000?l60?ooo`@0003o1P3oool40000o`D0
oooo10000?l50?ooo`@0003o1P3oool30000o`H0oooo0`000?l00`3oool0003o0?ooo`030?ooo`04
0000o`3oool0oooo0?ooo`80003o0`3oool010000?l0oooo0?ooo`3oool20000o`<0oooo00<0003o
0?ooo`3oool00`3oool30000o`030?ooo`000?l0oooo00@0oooo0`000?l60?ooo`@0003o1P3oool4
0000o`D0oooo10000?l60?ooo`<0003o1@3oool00`000?l0oooo0000o`020000o`D0oooo00@0003o
0?ooo`3oool0oooo0P000?l30?ooo`040000o`3oool0oooo0?ooo`80003o0`3oool00`000?l0oooo
0?ooo`020?ooo`030000o`3oool0003o0080003o1P3oool30000o`H0oooo10000?l50?ooo`@0003o
1@3oool40000o`H0oooo10000?l60?ooo`<0003o6@3oool001H0oooo0P000?l30?ooo`030000o`3o
ool0oooo00<0oooo10000?l60?ooo`@0003o1@3oool40000o`D0oooo10000?l60?ooo`@0003o1@3o
ool40000o`H0oooo0`000?l60?ooo`<0003o1P3oool30000o`030?ooo`000?l0oooo00<0oooo00@0
003o0?ooo`3oool0oooo0P000?l30?ooo`030000o`3oool0oooo00<0oooo0`000?l00`3oool0003o
0?ooo`030?ooo`030000o`3oool0003o0080003o103oool00`000?l0oooo0000o`020000o`D0oooo
00@0003o0?ooo`3oool0oooo0P000?l30?ooo`030000o`3oool0oooo0080oooo00<0003o0?ooo`00
0?l00P000?l60?ooo`<0003o1P3oool30000o`H0oooo10000?l50?ooo`@0003o1P3oool40000o`D0
oooo10000?l50?ooo`@0003o1P3oool40000o`D0oooo00@0003o0?ooo`3oool0oooo0P000?lG0?oo
o`00503oool20000o`H0oooo0`000?l00`3oool0003o0?ooo`030?ooo`030000o`3oool0oooo0080
oooo00<0003o0?ooo`000?l00P000?l50?ooo`<0003o1`3oool30000o`H0oooo10000?l50?ooo`@0
003o1@3oool40000o`H0oooo10000?l50?ooo`@0003o1P3oool30000o`H0oooo0`000?l00`3oool0
003o0?ooo`030?ooo`050000o`3oool0oooo0?ooo`000?l01@3oool01@000?l0oooo0?ooo`3oool0
003o00@0oooo00<0003o0?ooo`000?l00P000?l60?ooo`<0003o1P3oool40000o`D0oooo10000?l6
0?ooo`@0003o1@3oool40000o`D0oooo10000?l60?ooo`<0003o1`3oool30000o`D0oooo0`000?l0
0`3oool0003o0?ooo`030?ooo`030000o`3oool0oooo0080oooo00<0003o0?ooo`000?l00P000?l6
0?ooo`80003o5@3oool001<0oooo10000?l50?ooo`@0003o1P3oool40000o`D0oooo0`000?l00`3o
ool0003o0?ooo`020?ooo`80003o0`3oool20000o`<0oooo00<0003o0?ooo`3oool00P3oool00`00
0?l0oooo0000o`020000o`H0oooo0`000?l50?ooo`@0003o1P3oool40000o`D0oooo10000?l60?oo
o`@0003o1@3oool40000o`H0oooo0`000?l70?ooo`<0003o1P3oool40000o`D0oooo10000?l60?oo
o`@0003o1@3oool40000o`H0oooo10000?l50?ooo`<0003o1P3oool30000o`030?ooo`000?l0oooo
00<0oooo00@0003o0?ooo`3oool0oooo0P000?l30?ooo`80003o0`3oool00`000?l0oooo0000o`02
0000o`D0oooo10000?l60?ooo`@0003o1@3oool40000oa@0oooo000C0?ooo`@0003o1@3oool40000
o`H0oooo10000?l50?ooo`@0003o1P3oool30000o`D0oooo00<0003o0?ooo`000?l00P000?l50?oo
o`040000o`3oool0oooo0?ooo`80003o0`3oool00`000?l0oooo0?ooo`020?ooo`<0003o00<0oooo
0000o`3oool00`3oool00`000?l0oooo0000o`020000o`H0oooo0`000?l60?ooo`@0003o1@3oool4
0000o`H0oooo10000?l50?ooo`@0003o1P3oool40000o`D0oooo10000?l60?ooo`<0003o1P3oool3
0000o`030?ooo`000?l0oooo00<0oooo00<0003o0?ooo`000?l00P000?l40?ooo`040000o`3oool0
oooo0?ooo`80003o0`3oool00`000?l0oooo0?ooo`030?ooo`<0003o00<0oooo0000o`3oool0103o
ool30000o`H0oooo10000?l50?ooo`@0003o1P3oool40000o`D0oooo10000?lD0?ooo`004P3oool0
0`000?l0oooo0000o`020000o`H0oooo0`000?l60?ooo`@0003o1@3oool40000o`D0oooo10000?l6
0?ooo`@0003o1P3oool30000o`D0oooo00<0003o0?ooo`000?l00P000?l50?ooo`<0003o00<0oooo
0000o`3oool00`3oool010000?l0oooo0?ooo`3oool20000o`<0oooo00<0003o0?ooo`3oool00P3o
ool00`000?l0oooo0000o`020000o`H0oooo0`000?l60?ooo`@0003o1@3oool40000o`H0oooo0`00
0?l60?ooo`<0003o00<0oooo0000o`3oool00`3oool010000?l0oooo0?ooo`3oool20000o`<0oooo
00<0003o0?ooo`3oool00P3oool00`000?l0oooo0000o`020000o`D0oooo0`000?l00`3oool0003o
0?ooo`040?ooo`<0003o1P3oool40000o`H0oooo10000?l50?ooo`@0003o1@3oool40000o`H0oooo
0`000?l60?ooo`<0003o00<0oooo0000o`3oool04P3oool000l0oooo0P000?l00`3oool0003o0?oo
o`030?ooo`040000o`3oool0oooo0?ooo`80003o0`3oool00`000?l0oooo0?ooo`030?ooo`<0003o
1`3oool30000o`D0oooo10000?l60?ooo`@0003o1@3oool40000o`H0oooo10000?l50?ooo`@0003o
1P3oool30000o`D0oooo00<0003o0?ooo`000?l00P000?l50?ooo`040000o`3oool0oooo0?ooo`80
003o0`3oool00`000?l0oooo0?ooo`020?ooo`030000o`3oool0003o0080003o1@3oool30000o`03
0?ooo`000?l0oooo00<0oooo00@0003o0?ooo`3oool0oooo0P000?l0103oool0003o0000o`000?l5
0?ooo`<0003o00<0oooo0000o`3oool0103oool30000o`H0oooo10000?l50?ooo`@0003o1P3oool4
0000o`D0oooo10000?l60?ooo`@0003o1@3oool30000o`L0oooo0`000?l50?ooo`040000o`3oool0
oooo0?ooo`80003o0`3oool00`000?l0oooo0?ooo`020?ooo`040000o`3oool0003o0000oa00oooo
000>0?ooo`@0003o1P3oool30000o`H0oooo00D0003o0?ooo`3oool0oooo0000o`030?ooo`80003o
0`3oool20000o`<0oooo00<0003o0?ooo`3oool00P3oool30000o`030?ooo`000?l0oooo00@0oooo
0`000?l60?ooo`@0003o1P3oool40000o`D0oooo10000?l50?ooo`@0003o1P3oool40000o`H0oooo
0`000?l60?ooo`<0003o00<0oooo0000o`3oool00`3oool01@000?l0oooo0?ooo`3oool0003o00@0
oooo00<0003o0?ooo`000?l00P000?l60?ooo`@0003o1@3oool40000o`H0oooo10000?l50?ooo`@0
003o1@3oool40000o`H0oooo10000?l60?ooo`<0003o1@3oool00`000?l0oooo0000o`020000o`@0
oooo00@0003o0?ooo`3oool0oooo0P000?l30?ooo`80003o0`3oool20000o`<0oooo00<0003o0?oo
o`3oool00`3oool30000o`H0oooo10000?l?0?ooo`003P3oool40000o`H0oooo10000?l60?ooo`<0
003o1P3oool30000o`D0oooo00<0003o0?ooo`000?l00P000?l40?ooo`040000o`3oool0oooo0?oo
o`80003o0`3oool00`000?l0oooo0?ooo`030?ooo`<0003o00<0oooo0000o`3oool0103oool30000
o`L0oooo0`000?l50?ooo`@0003o1P3oool40000o`D0oooo10000?l60?ooo`@0003o1P3oool30000
o`H0oooo10000?l60?ooo`@0003o1@3oool40000o`H0oooo10000?l50?ooo`<0003o1`3oool30000
o`D0oooo00<0003o0?ooo`000?l00P000?l50?ooo`040000o`3oool0oooo0?ooo`80003o0`3oool0
0`000?l0oooo0?ooo`020?ooo`<0003o00<0oooo0000o`3oool0103oool30000o`L0oooo0`000?l5
0?ooo`@0003o1P3oool40000o`l0oooo000?0?ooo`<0003o1P3oool40000o`D0oooo10000?l50?oo
o`@0003o1P3oool40000o`D0oooo0`000?l60?ooo`<0003o00<0oooo0000o`3oool00`3oool01000
0?l0oooo0?ooo`3oool20000o`<0oooo0P000?l30?ooo`80003o0`3oool00`000?l0oooo0?ooo`02
0?ooo`<0003o00<0oooo0000o`3oool0103oool30000o`H0oooo10000?l60?ooo`@0003o1P3oool4
0000o`D0oooo10000?l60?ooo`<0003o1`3oool30000o`D0oooo00<0003o0?ooo`000?l00P000?l4
0?ooo`040000o`3oool0oooo0?ooo`80003o0`3oool20000o`<0oooo0P000?l30?ooo`030000o`3o
ool0oooo0080oooo00<0003o0?ooo`000?l00P000?l60?ooo`<0003o1@3oool40000o`H0oooo1000
0?l50?ooo`@0003o1@3oool40000o`H0oooo0`000?l@0?ooo`003@3oool20000o`<0oooo00<0003o
0?ooo`3oool00P3oool00`000?l0oooo0000o`020000o`D0oooo10000?l50?ooo`@0003o1P3oool4
0000o`D0oooo10000?l50?ooo`@0003o1P3oool30000o`L0oooo0`000?l50?ooo`030000o`3oool0
003o0080003o1@3oool01@000?l0oooo0?ooo`3oool0003o00<0oooo0P000?l30?ooo`@0003o00<0
oooo0000o`3oool0103oool40000o`H0oooo10000?l50?ooo`@0003o1@3oool010000?l0oooo0?oo
o`3oool20000o`<0oooo0P000?l30?ooo`050000o`3oool0oooo0?ooo`000?l01@3oool30000o`03
0?ooo`000?l0oooo00@0oooo0`000?l70?ooo`<0003o1P3oool40000o`D0oooo10000?l50?ooo`@0
003o1P3oool40000o`D0oooo10000?l50?ooo`<0003o00<0oooo0000o`3oool00`3oool010000?l0
oooo0?ooo`3oool20000o`h0oooo000;0?ooo`80003o1@3oool00`000?l0oooo0000o`020000o`@0
oooo00<0003o0?ooo`3oool00`3oool30000o`030?ooo`000?l0oooo00<0oooo0`000?l00`3oool0
003o0?ooo`040?ooo`<0003o1P3oool40000o`D0oooo10000?l60?ooo`@0003o1@3oool40000o`H0
oooo10000?l60?ooo`<0003o1P3oool30000o`D0oooo00H0003o0?ooo`000?l0003o0?ooo`000?l4
0?ooo`030000o`3oool0oooo0080oooo00<0003o0?ooo`000?l00P000?l40?ooo`030000o`3oool0
oooo0080oooo00H0003o0?ooo`000?l0003o0?ooo`000?l50?ooo`<0003o1P3oool30000o`H0oooo
10000?l60?ooo`@0003o1@3oool40000o`H0oooo10000?l50?ooo`@0003o1P3oool30000o`D0oooo
00<0003o0?ooo`000?l00P000?l50?ooo`<0003o00<0oooo0000o`3oool00P3oool00`000?l0oooo
0?ooo`030?ooo`<0003o00<0oooo0000o`3oool0103oool20000o``0oooo000:0?ooo`@0003o1@3o
ool40000o`D0oooo0`000?l00`3oool0003o0?ooo`030?ooo`<0003o00<0oooo0000o`3oool00`3o
ool010000?l0oooo0?ooo`3oool20000o`<0oooo00<0003o0?ooo`3oool00P3oool00`000?l0oooo
0000o`020000o`H0oooo0`000?l60?ooo`@0003o1@3oool40000o`H0oooo10000?l50?ooo`@0003o
1@3oool40000o`H0oooo10000?l50?ooo`050000o`3oool0oooo0?ooo`000?l01@3oool01@000?l0
oooo0?ooo`3oool0003o00D0oooo10000?l60?ooo`@0003o1@3oool40000o`D0oooo10000?l60?oo
o`@0003o1@3oool40000o`H0oooo0`000?l60?ooo`<0003o00<0oooo0000o`3oool00`3oool01000
0?l0oooo0?ooo`3oool20000o`<0oooo00<0003o0?ooo`3oool00P3oool00`000?l0oooo0000o`02
0000o`@0oooo00<0003o0?ooo`000?l00P000?l50?ooo`@0003o1@3oool40000o`/0oooo000:0?oo
o`@0003o1@3oool40000o`D0oooo10000?l50?ooo`@0003o1P3oool30000o`H0oooo0`000?l00`3o
ool0003o0?ooo`030?ooo`040000o`3oool0oooo0?ooo`80003o0`3oool010000?l0oooo0?ooo`3o
ool20000o`040?ooo`000?l0003o0000o`D0oooo0`000?l00`3oool0003o0?ooo`040?ooo`<0003o
1P3oool40000o`D0oooo10000?l60?ooo`@0003o1P3oool30000o`L0oooo0`000?l60?ooo`@0003o
1P3oool40000o`D0oooo10000?l60?ooo`<0003o1@3oool00`000?l0oooo0000o`020000o`D0oooo
0`000?l00`3oool0003o0000o`030?ooo`040000o`3oool0oooo0?ooo`80003o0`3oool00`000?l0
oooo0?ooo`020?ooo`030000o`3oool0003o0080003o1P3oool30000o`H0oooo10000?l50?ooo`@0
003o1@3oool40000o`D0oooo10000?l;0?ooo`002@3oool00`000?l0oooo0000o`020000o`D0oooo
0`000?l60?ooo`@0003o1@3oool40000o`H0oooo10000?l50?ooo`@0003o1P3oool30000o`H0oooo
0`000?l60?ooo`<0003o00<0oooo0000o`3oool00`3oool010000?l0oooo0?ooo`3oool20000o`<0
oooo00<0003o0?ooo`3oool00`3oool30000o`030?ooo`000?l0oooo00<0oooo0`000?l00`3oool0
003o0?ooo`040?ooo`<0003o1`3oool40000o`D0oooo10000?l70?ooo`<0003o1@3oool00`000?l0
oooo0000o`020000o`@0oooo00<0003o0?ooo`000?l00P000?l50?ooo`040000o`3oool0oooo0?oo
o`80003o0`3oool00`000?l0oooo0?ooo`020?ooo`030000o`3oool0003o0080003o1P3oool30000
o`H0oooo0`000?l60?ooo`@0003o1@3oool40000o`H0oooo10000?l50?ooo`@0003o1P3oool30000
o`D0oooo0`000?l00`3oool0003o0?ooo`090?ooo`002@3oool01@000?l0oooo0?ooo`3oool0003o
00@0oooo00D0003o0?ooo`3oool0oooo0000o`060?ooo`<0003o1P3oool30000o`H0oooo10000?l5
0?ooo`@0003o1@3oool40000o`H0oooo10000?l50?ooo`@0003o1P3oool30000o`H0oooo0`000?l0
0`3oool0003o0?ooo`030?ooo`030000o`3oool0003o0080003o103oool010000?l0oooo0?ooo`3o
ool20000o`<0oooo00<0003o0?ooo`3oool0103oool40000o`D0oooo10000?l60?ooo`040000o`3o
ool0oooo0?ooo`80003o0`3oool00`000?l0oooo0?ooo`020?ooo`030000o`3oool0003o0080003o
103oool00`000?l0oooo0000o`020000o`H0oooo0`000?l60?ooo`@0003o1@3oool40000o`H0oooo
10000?l50?ooo`@0003o1@3oool40000o`H0oooo0`000?l60?ooo`<0003o1P3oool01@000?l0oooo
0?ooo`3oool0003o00<0oooo00<0003o0?ooo`3oool00P3oool00`000?l0oooo0?ooo`080?ooo`00
1P3oool30000o`D0oooo0`000?l00`3oool0003o0?ooo`030?ooo`040000o`3oool0oooo0?ooo`80
003o0`3oool010000?l0oooo0?ooo`3oool20000o`<0oooo00<0003o0?ooo`3oool00P3oool00`00
0?l0oooo0000o`020000o`H0oooo0`000?l50?ooo`@0003o1P3oool40000o`D0oooo10000?l60?oo
o`@0003o1@3oool40000o`H0oooo10000?l50?ooo`<0003o1P3oool010000?l0oooo0?ooo`3oool2
0000o`040?ooo`000?l0003o0000o`D0oooo0`000?l00`3oool0003o0000o`030?ooo`030000o`3o
ool0oooo00@0oooo0`000?l60?ooo`@0003o1@3oool40000o`D0oooo10000?l60?ooo`@0003o1@3o
ool40000o`H0oooo10000?l50?ooo`<0003o1P3oool30000o`030?ooo`000?l0oooo00<0oooo00@0
003o0?ooo`3oool0oooo0P000?l30?ooo`040000o`3oool0oooo0?ooo`80003o0`3oool00`000?l0
oooo0?ooo`020?ooo`030000o`3oool0003o0080003o1@3oool30000o`L0oooo00050?ooo`@0003o
1@3oool40000o`H0oooo0`000?l60?ooo`<0003o1@3oool00`000?l0oooo0000o`020000o`D0oooo
00@0003o0?ooo`3oool0oooo0P000?l30?ooo`030000o`3oool0oooo0080oooo0`000?l00`3oool0
003o0?ooo`030?ooo`030000o`3oool0003o0080003o1P3oool30000o`H0oooo10000?l50?ooo`@0
003o1P3oool40000o`D0oooo10000?l60?ooo`<0003o1P3oool01@000?l0oooo0?ooo`3oool0003o
00H0oooo0`000?l60?ooo`@0003o1P3oool40000o`D0oooo10000?l50?ooo`@0003o1P3oool30000
o`H0oooo0`000?l00`3oool0003o0?ooo`030?ooo`030000o`3oool0003o0080003o103oool01000
0?l0oooo0?ooo`3oool20000o`<0oooo00<0003o0?ooo`3oool00`3oool30000o`030?ooo`000?l0
oooo00@0oooo0`000?l60?ooo`<0003o1P3oool40000o`D0oooo10000?l60?ooo`001@3oool40000
o`D0oooo10000?l60?ooo`@0003o1@3oool40000o`D0oooo10000?l60?ooo`<0003o1@3oool00`00
0?l0oooo0000o`020000o`@0oooo00<0003o0?ooo`000?l00P000?l50?ooo`040000o`3oool0oooo
0?ooo`80003o0`3oool00`000?l0oooo0?ooo`020?ooo`030000o`3oool0003o0080003o1P3oool3
0000o`H0oooo0`000?l60?ooo`@0003o1@3oool40000o`L0oooo0`000?l70?ooo`@0003o1@3oool4
0000o`H0oooo0`000?l60?ooo`<0003o1P3oool30000o`030?ooo`000?l0oooo00<0oooo00@0003o
0?ooo`3oool0oooo0P000?l30?ooo`030000o`3oool0oooo00<0oooo0`000?l00`3oool0003o0?oo
o`030?ooo`<0003o00<0oooo0000o`3oool0103oool30000o`H0oooo10000?l50?ooo`@0003o1@3o
ool40000o`H0oooo10000?l50?ooo`@0003o1P3oool000H0oooo0`000?l60?ooo`<0003o1P3oool4
0000o`D0oooo10000?l50?ooo`@0003o1@3oool40000o`H0oooo10000?l50?ooo`@0003o1P3oool3
0000o`D0oooo00<0003o0?ooo`000?l00P000?l50?ooo`040000o`3oool0oooo0?ooo`80003o0`3o
ool010000?l0oooo0?ooo`3oool20000o`<0oooo00<0003o0?ooo`3oool00P3oool00`000?l0oooo
0000o`020000o`D0oooo10000?l70?ooo`@0003o1P3oool40000o`D0oooo0`000?l00`3oool0003o
0?ooo`030?ooo`040000o`3oool0oooo0?ooo`80003o0`3oool010000?l0oooo0?ooo`3oool20000
o`<0oooo00<0003o0?ooo`3oool00`3oool30000o`030?ooo`000?l0oooo00@0oooo0`000?l60?oo
o`@0003o1@3oool40000o`H0oooo10000?l50?ooo`@0003o1@3oool40000o`D0oooo10000?l60?oo
o`<0003o1P3oool30000o`L0oooo00090?ooo`030000o`3oool0oooo0080oooo00D0003o0?ooo`3o
ool0oooo0000o`040?ooo`030000o`3oool0003o0080003o103oool00`000?l0oooo0000o`020000
o`D0oooo0`000?l60?ooo`@0003o1P3oool40000o`D0oooo10000?l50?ooo`@0003o1P3oool40000
o`H0oooo0`000?l60?ooo`<0003o1P3oool30000o`030?ooo`000?l0oooo0080oooo00<0003o0?oo
o`3oool00`3oool30000o`030?ooo`000?l0oooo00D0oooo10000?l50?ooo`030000o`3oool0003o
0080003o103oool00`000?l0oooo0?ooo`030?ooo`<0003o00<0oooo0000o`3oool0103oool30000
o`H0oooo0`000?l60?ooo`@0003o1P3oool40000o`D0oooo10000?l50?ooo`@0003o1P3oool40000
o`H0oooo0`000?l50?ooo`<0003o00<0oooo0000o`3oool00`3oool30000o`030?ooo`000?l0oooo
00<0oooo00D0003o0?ooo`3oool0oooo0000o`040?ooo`030000o`3oool0oooo00P0oooo000:0?oo
o`80003o00<0oooo0000o`3oool00`3oool00`000?l0oooo0000o`020000o`@0oooo00<0003o0?oo
o`000?l00P000?l50?ooo`050000o`3oool0oooo0?ooo`000?l00`3oool00`000?l0oooo0?ooo`03
0?ooo`<0003o00<0oooo0000o`3oool0103oool30000o`H0oooo0`000?l60?ooo`@0003o1P3oool4
0000o`D0oooo10000?l60?ooo`@0003o1@3oool40000o`D0oooo00<0003o0?ooo`000?l00P000?l5
0?ooo`040000o`3oool0oooo0?ooo`80003o00<0oooo0000o`000?l00P000?l30?ooo`030000o`3o
ool0oooo00<0oooo0`000?l00`3oool0003o0?ooo`040?ooo`@0003o1@3oool40000o`H0oooo1000
0?l50?ooo`@0003o1P3oool40000o`H0oooo0`000?l60?ooo`<0003o1@3oool00`000?l0oooo0000
o`020000o`D0oooo00D0003o0?ooo`3oool0oooo0000o`030?ooo`030000o`3oool0oooo00<0oooo
0`000?l00`3oool0003o0?ooo`030?ooo`<0003o00<0oooo0000o`3oool00`3oool010000?l0oooo
0000o`000?l;0?ooo`002@3oool40000o`H0oooo10000?l50?ooo`@0003o1P3oool30000o`D0oooo
0`000?l00`3oool0003o0?ooo`030?ooo`040000o`3oool0oooo0?ooo`80003o0`3oool20000o`<0
oooo00D0003o0?ooo`3oool0oooo0000o`050?ooo`<0003o00<0oooo0000o`3oool0103oool30000
o`H0oooo10000?l60?ooo`@0003o1@3oool40000o`H0oooo10000?l60?ooo`<0003o1`3oool30000
o`H0oooo10000?l60?ooo`@0003o1@3oool40000o`H0oooo10000?l60?ooo`<0003o1@3oool00`00
0?l0oooo0000o`020000o`D0oooo00D0003o0?ooo`3oool0oooo0000o`030?ooo`80003o0`3oool2
0000o`<0oooo00<0003o0?ooo`3oool00P3oool00`000?l0oooo0000o`020000o`D0oooo0`000?l6
0?ooo`@0003o1@3oool40000o`H0oooo10000?l:0?ooo`002@3oool40000o`H0oooo10000?l50?oo
o`@0003o1@3oool40000o`D0oooo10000?l60?ooo`<0003o1`3oool30000o`D0oooo00<0003o0?oo
o`000?l00P000?l40?ooo`040000o`3oool0oooo0?ooo`80003o0`3oool00`000?l0oooo0?ooo`03
0?ooo`<0003o00<0oooo0000o`3oool00`3oool00`000?l0oooo0000o`020000o`H0oooo0`000?l6
0?ooo`@0003o1@3oool40000o`L0oooo10000?l50?ooo`@0003o1`3oool30000o`D0oooo0`000?l0
0`3oool0003o0?ooo`030?ooo`030000o`3oool0003o0080003o1@3oool010000?l0oooo0?ooo`3o
ool20000o`<0oooo00<0003o0?ooo`3oool00P3oool30000o`030?ooo`000?l0oooo00@0oooo0`00
0?l70?ooo`<0003o1P3oool40000o`D0oooo10000?l50?ooo`@0003o1@3oool40000o`H0oooo1000
0?l:0?ooo`002P3oool30000o`H0oooo0`000?l60?ooo`<0003o1P3oool40000o`D0oooo10000?l6
0?ooo`@0003o1@3oool40000o`H0oooo10000?l50?ooo`<0003o1P3oool30000o`030?ooo`000?l0
oooo00<0oooo00<0003o0?ooo`000?l00P000?l50?ooo`040000o`3oool0oooo0?ooo`80003o0`3o
ool00`000?l0oooo0?ooo`030?ooo`<0003o1P3oool40000o`L0oooo10000?l60?ooo`<0003o1P3o
ool01@000?l0oooo0?ooo`3oool0003o00<0oooo00<0003o0?ooo`3oool00`3oool30000o`030?oo
o`000?l0oooo00<0oooo00<0003o0?ooo`000?l00P000?l60?ooo`<0003o1@3oool40000o`H0oooo
10000?l50?ooo`@0003o1P3oool40000o`D0oooo10000?l60?ooo`<0003o1P3oool30000o`H0oooo
0`000?l;0?ooo`003@3oool00`000?l0oooo0?ooo`020?ooo`050000o`3oool0oooo0?ooo`000?l0
103oool01@000?l0oooo0?ooo`3oool0003o00D0oooo0`000?l00`3oool0003o0?ooo`040?ooo`<0
003o1P3oool40000o`D0oooo10000?l60?ooo`@0003o1@3oool40000o`D0oooo10000?l60?ooo`@0
003o1P3oool30000o`D0oooo00@0003o0?ooo`3oool0oooo0P000?l30?ooo`030000o`3oool0oooo
00<0oooo0`000?l90?ooo`<0003o1@3oool010000?l0oooo0?ooo`3oool20000o`<0oooo00<0003o
0?ooo`3oool00`3oool30000o`H0oooo10000?l60?ooo`@0003o1@3oool40000o`D0oooo10000?l6
0?ooo`@0003o1@3oool40000o`H0oooo0`000?l50?ooo`030000o`3oool0003o0080003o1@3oool0
1@000?l0oooo0?ooo`3oool0003o00@0oooo00D0003o0?ooo`3oool0oooo0000o`040?ooo`030000
o`3oool0oooo00`0oooo000=0?ooo`<0003o00<0oooo0000o`3oool00`3oool00`000?l0oooo0000
o`020000o`D0oooo0`000?l00`3oool0003o0?ooo`030?ooo`040000o`3oool0oooo0?ooo`80003o
0`3oool00`000?l0oooo0?ooo`020?ooo`030000o`3oool0003o0080003o1@3oool30000o`030?oo
o`000?l0oooo00@0oooo0`000?l60?ooo`@0003o1@3oool40000o`H0oooo10000?l50?ooo`@0003o
1P3oool30000o`H0oooo0`000?l00`3oool0003o0?ooo`0>0?ooo`030000o`3oool0003o0080003o
1P3oool30000o`H0oooo10000?l50?ooo`@0003o1P3oool40000o`D0oooo10000?l60?ooo`<0003o
1@3oool00`000?l0oooo0000o`020000o`D0oooo0`000?l00`3oool0003o0?ooo`030?ooo`040000
o`3oool0oooo0?ooo`80003o0`3oool00`000?l0oooo0?ooo`020?ooo`030000o`3oool0003o0080
003o1@3oool30000o`030?ooo`000?l0oooo00<0oooo00<0003o0?ooo`000?l00P000?l>0?ooo`00
3@3oool40000o`H0oooo10000?l50?ooo`@0003o1P3oool30000o`D0oooo00<0003o0?ooo`000?l0
0P000?l50?ooo`<0003o00<0oooo0000o`3oool00`3oool010000?l0oooo0?ooo`3oool20000o`<0
oooo00<0003o0?ooo`3oool00P3oool00`000?l0oooo0000o`020000o`H0oooo0`000?l60?ooo`<0
003o1P3oool40000o`H0oooo10000?l50?ooo`@0003o4@3oool40000o`D0oooo10000?l60?ooo`@0
003o1P3oool30000o`H0oooo0`000?l60?ooo`<0003o00<0oooo0000o`3oool00`3oool010000?l0
oooo0?ooo`3oool20000o`<0oooo00<0003o0?ooo`3oool00P3oool00`000?l0oooo0000o`020000
o`D0oooo0`000?l00`3oool0003o0?ooo`040?ooo`<0003o1P3oool40000o`D0oooo10000?l60?oo
o`@0003o3P3oool000d0oooo10000?l60?ooo`@0003o1@3oool40000o`H0oooo10000?l50?ooo`@0
003o1@3oool40000o`H0oooo0`000?l60?ooo`<0003o00<0oooo0000o`3oool00`3oool010000?l0
oooo0?ooo`3oool20000o`<0oooo00@0003o0?ooo`3oool0oooo0P000?l30?ooo`030000o`3oool0
oooo00<0oooo0`000?l00`3oool0003o0?ooo`040?ooo`@0003o1@3oool40000oa40oooo10000?l5
0?ooo`@0003o1@3oool00`000?l0oooo0000o`020000o`D0oooo00@0003o0?ooo`3oool0oooo0P00
0?l30?ooo`040000o`3oool0oooo0?ooo`80003o0`3oool00`000?l0oooo0?ooo`020?ooo`030000
o`3oool0003o0080003o1P3oool30000o`H0oooo10000?l50?ooo`@0003o1@3oool40000o`H0oooo
10000?l50?ooo`@0003o1P3oool40000o`h0oooo000>0?ooo`<0003o1P3oool30000o`L0oooo0`00
0?l60?ooo`@0003o1@3oool40000o`D0oooo10000?l60?ooo`@0003o1@3oool40000o`H0oooo0`00
0?l60?ooo`<0003o1P3oool30000o`030?ooo`000?l0oooo00<0oooo00@0003o0?ooo`3oool0oooo
0P000?l0103oool0003o0000o`000?l60?ooo`80003o4`3oool20000o`H0oooo0`000?l00`3oool0
003o0000o`030?ooo`030000o`3oool0oooo0080oooo00<0003o0?ooo`000?l00P000?l60?ooo`<0
003o1P3oool30000o`H0oooo10000?l50?ooo`@0003o1P3oool40000o`D0oooo10000?l50?ooo`@0
003o1P3oool30000o`L0oooo0`000?l60?ooo`<0003o3`3oool00140oooo00<0003o0?ooo`3oool0
0P3oool01@000?l0oooo0?ooo`3oool0003o00D0oooo00D0003o0?ooo`3oool0oooo0000o`040?oo
o`030000o`3oool0003o0080003o1@3oool30000o`L0oooo0`000?l60?ooo`@0003o1@3oool40000
o`H0oooo10000?l50?ooo`@0003o1@3oool40000o`H0oooo0`000?l60?ooo`040000o`3oool0oooo
0?ooo`80003o5`3oool20000o`<0oooo00<0003o0?ooo`3oool0103oool30000o`H0oooo10000?l5
0?ooo`@0003o1@3oool40000o`H0oooo10000?l50?ooo`@0003o1P3oool30000o`L0oooo0`000?l5
0?ooo`<0003o00<0oooo0000o`3oool00`3oool01@000?l0oooo0?ooo`3oool0003o00D0oooo00D0
003o0?ooo`3oool0oooo0000o`040?ooo`030000o`3oool0oooo0100oooo000A0?ooo`030000o`3o
ool0003o0080003o1@3oool30000o`030?ooo`000?l0oooo00<0oooo00<0003o0?ooo`000?l00P00
0?l50?ooo`<0003o00<0oooo0000o`3oool00P3oool20000o`<0oooo0P000?l30?ooo`030000o`3o
ool0oooo0080oooo00<0003o0?ooo`000?l00P000?l60?ooo`<0003o1P3oool40000o`D0oooo1000
0?l50?ooo`@0003o1P3oool40000o`H0oooo0`000?lK0?ooo`<0003o1P3oool40000o`H0oooo1000
0?l50?ooo`@0003o1@3oool40000o`H0oooo0`000?l60?ooo`<0003o00<0oooo0000o`3oool00`3o
ool010000?l0oooo0?ooo`3oool20000o`<0oooo0P000?l30?ooo`030000o`3oool0003o0080003o
1@3oool30000o`030?ooo`000?l0oooo00<0oooo00<0003o0?ooo`000?l00P000?l50?ooo`<0003o
00<0oooo0000o`3oool04@3oool00180oooo10000?l50?ooo`@0003o1P3oool40000o`D0oooo1000
0?l60?ooo`<0003o1@3oool00`000?l0oooo0000o`020000o`D0oooo00@0003o0?ooo`3oool0oooo
0P000?l30?ooo`040000o`3oool0oooo0?ooo`80003o00@0oooo0000o`000?l0003o103oool00`00
0?l0oooo0000o`020000o`H0oooo0`000?l60?ooo`@0003o1P3oool40000oaT0oooo10000?l60?oo
o`@0003o1P3oool30000o`H0oooo0`000?l00`3oool0003o0?ooo`030?ooo`<0003o00<0oooo0000
o`000?l00`3oool010000?l0oooo0?ooo`3oool20000o`<0oooo00<0003o0?ooo`3oool00`3oool3
0000o`030?ooo`000?l0oooo00@0oooo0`000?l60?ooo`@0003o1@3oool40000o`H0oooo10000?l5
0?ooo`@0003o4`3oool00180oooo10000?l50?ooo`@0003o1P3oool40000o`D0oooo10000?l50?oo
o`@0003o1P3oool40000o`H0oooo0`000?l60?ooo`<0003o1@3oool00`000?l0oooo0000o`020000
o`D0oooo00@0003o0?ooo`3oool0oooo0P000?l30?ooo`030000o`3oool0oooo0080oooo00<0003o
0?ooo`000?l00P000?l60?ooo`@0003o6@3oool40000o`H0oooo0`000?l00`3oool0003o0?ooo`03
0?ooo`040000o`3oool0oooo0?ooo`80003o0`3oool00`000?l0oooo0?ooo`030?ooo`<0003o00<0
oooo0000o`3oool0103oool30000o`H0oooo0`000?l60?ooo`@0003o1P3oool40000o`D0oooo1000
0?l50?ooo`@0003o1P3oool40000o`D0oooo10000?lC0?ooo`004`3oool20000o`H0oooo10000?l6
0?ooo`<0003o1`3oool30000o`D0oooo10000?l60?ooo`@0003o1@3oool40000o`H0oooo10000?l5
0?ooo`@0003o1P3oool30000o`H0oooo0`000?l00`3oool0003o0?ooo`020?ooo`030000o`3oool0
oooo00<0oooo00@0003o0?ooo`000?l0003o6`3oool20000o`030?ooo`000?l0oooo00<0oooo00<0
003o0?ooo`3oool00`3oool30000o`030?ooo`000?l0oooo00@0oooo0`000?l60?ooo`@0003o1@3o
ool40000o`H0oooo10000?l50?ooo`@0003o1P3oool40000o`D0oooo0`000?l70?ooo`<0003o1P3o
ool40000o`H0oooo0P000?lD0?ooo`005@3oool00`000?l0oooo0?ooo`020?ooo`030000o`3oool0
oooo0080oooo00@0003o0?ooo`3oool0oooo0P000?l30?ooo`80003o0`3oool20000o`<0oooo00<0
003o0?ooo`3oool00P3oool30000o`030?ooo`000?l0oooo00@0oooo0`000?l60?ooo`@0003o1P3o
ool40000o`D0oooo10000?l50?ooo`@0003o1P3oool40000o`D0oooo00<0003o0?ooo`000?l00P00
0?lS0?ooo`<0003o00<0oooo0000o`3oool0103oool40000o`H0oooo10000?l50?ooo`@0003o1@3o
ool40000o`H0oooo10000?l60?ooo`<0003o1@3oool00`000?l0oooo0000o`020000o`@0oooo00@0
003o0?ooo`3oool0oooo0P000?l30?ooo`80003o0`3oool20000o`<0oooo00<0003o0?ooo`3oool0
0P3oool00`000?l0oooo0?ooo`020?ooo`030000o`3oool0oooo01@0oooo000F0?ooo`@0003o1P3o
ool30000o`L0oooo0`000?l50?ooo`030000o`3oool0003o0080003o103oool010000?l0oooo0?oo
o`3oool20000o`<0oooo0P000?l30?ooo`@0003o00<0oooo0000o`3oool00`3oool00`000?l0oooo
0000o`020000o`D0oooo0`000?l60?ooo`@0003o1P3oool40000o`H0oooo10000?lS0?ooo`@0003o
1P3oool40000o`H0oooo10000?l60?ooo`<0003o1@3oool30000o`030?ooo`000?l0oooo00<0oooo
00<0003o0?ooo`000?l00`000?l30?ooo`80003o0`3oool20000o`<0oooo00<0003o0?ooo`3oool0
0P3oool30000o`030?ooo`000?l0oooo00@0oooo0`000?l70?ooo`<0003o1P3oool40000oaL0oooo
000F0?ooo`@0003o1P3oool40000o`D0oooo10000?l60?ooo`@0003o1@3oool30000o`L0oooo0`00
0?l50?ooo`030000o`3oool0003o0080003o1@3oool01@000?l0oooo0?ooo`3oool0003o00<0oooo
00<0003o0?ooo`3oool00`3oool30000o`030?ooo`000?l0oooo00D0oooo0`000?l60?ooo`@0003o
8`3oool40000o`L0oooo0`000?l50?ooo`030000o`3oool0003o0080003o1@3oool01@000?l0oooo
0?ooo`3oool0003o00<0oooo00<0003o0?ooo`3oool00`3oool30000o`030?ooo`000?l0oooo00@0
oooo0`000?l70?ooo`<0003o1@3oool40000o`H0oooo10000?l50?ooo`@0003o1P3oool40000oaL0
oooo000F0?ooo`@0003o1P3oool40000o`D0oooo10000?l60?ooo`@0003o1@3oool40000o`D0oooo
10000?l60?ooo`@0003o1P3oool30000o`D0oooo00<0003o0?ooo`000?l00P000?l50?ooo`040000
o`3oool0oooo0?ooo`80003o0`3oool00`000?l0oooo0?ooo`030?ooo`<0003o9@3oool30000o`H0
oooo00D0003o0?ooo`3oool0oooo0000o`030?ooo`030000o`3oool0oooo00<0oooo00<0003o0?oo
o`000?l00P000?l50?ooo`<0003o1P3oool40000o`H0oooo10000?l50?ooo`@0003o1@3oool40000
o`H0oooo10000?l50?ooo`@0003o1P3oool40000oaL0oooo000G0?ooo`<0003o1@3oool00`000?l0
oooo0000o`020000o`D0oooo0`000?l00`3oool0003o0?ooo`040?ooo`<0003o1P3oool40000o`D0
oooo10000?l60?ooo`@0003o1@3oool40000o`H0oooo10000?l60?ooo`<0003o1@3oool010000?l0
oooo0?ooo`3oool20000ob/0oooo0P000?l30?ooo`030000o`3oool0oooo00<0oooo0`000?l70?oo
o`@0003o1@3oool40000o`D0oooo10000?l60?ooo`@0003o1@3oool40000o`H0oooo0`000?l50?oo
o`030000o`3oool0003o0080003o1@3oool30000o`030?ooo`000?l0oooo00@0oooo0`000?lH0?oo
o`006P3oool01@000?l0oooo0?ooo`3oool0003o00D0oooo00D0003o0?ooo`3oool0oooo0000o`04
0?ooo`040000o`3oool0oooo0?ooo`80003o0`3oool00`000?l0oooo0?ooo`020?ooo`030000o`3o
ool0003o0080003o1@3oool30000o`030?ooo`000?l0oooo00@0oooo0`000?l60?ooo`@0003o1P3o
ool40000o`D0oooo10000?l60?ooo`<0003o;`3oool30000o`H0oooo10000?l60?ooo`@0003o1@3o
ool40000o`H0oooo0`000?l50?ooo`030000o`3oool0003o0080003o1@3oool30000o`030?ooo`00
0?l0oooo00<0oooo00@0003o0?ooo`3oool0oooo0P000?l30?ooo`030000o`3oool0oooo0080oooo
00D0003o0?ooo`3oool0oooo0000o`050?ooo`050000o`3oool0oooo0?ooo`000?l06`3oool001/0
oooo0`000?l70?ooo`<0003o1P3oool30000o`H0oooo0`000?l00`3oool0003o0?ooo`030?ooo`<0
003o00<0oooo0000o`3oool00`3oool010000?l0oooo0?ooo`3oool20000o`<0oooo00<0003o0?oo
o`3oool00`3oool30000o`030?ooo`000?l0oooo00@0oooo0`000?l60?ooo`@0003o1P3oool40000
obd0oooo10000?l60?ooo`@0003o1P3oool30000o`D0oooo00<0003o0?ooo`000?l00P000?l50?oo
o`040000o`3oool0oooo0?ooo`80003o0`3oool00`000?l0oooo0?ooo`020?ooo`030000o`3oool0
003o0080003o103oool00`000?l0oooo0000o`020000o`H0oooo0`000?l60?ooo`<0003o1`3oool3
0000oa`0oooo000J0?ooo`@0003o1P3oool40000o`H0oooo10000?l50?ooo`@0003o1@3oool40000
o`H0oooo0`000?l60?ooo`<0003o00<0oooo0000o`3oool00`3oool010000?l0oooo0?ooo`3oool2
0000o`<0oooo00<0003o0?ooo`3oool00`3oool40000o`H0oooo10000?l]0?ooo`@0003o1P3oool4
0000o`D0oooo00@0003o0?ooo`3oool0oooo0P000?l30?ooo`030000o`3oool0oooo0080oooo00<0
003o0?ooo`000?l00P000?l60?ooo`<0003o1P3oool40000o`D0oooo10000?l50?ooo`@0003o1P3o
ool40000o`H0oooo10000?lK0?ooo`006P3oool40000o`H0oooo10000?l60?ooo`@0003o1@3oool4
0000o`D0oooo10000?l60?ooo`@0003o1@3oool40000o`H0oooo0`000?l60?ooo`<0003o00<0oooo
0000o`3oool00`3oool00`000?l0oooo0?ooo`020?ooo`040000o`3oool0003o0000obl0oooo0P00
0?l00`3oool0003o0?ooo`030?ooo`030000o`3oool0oooo0080oooo00<0003o0?ooo`000?l00P00
0?l60?ooo`<0003o1P3oool40000o`D0oooo10000?l60?ooo`@0003o1@3oool40000o`D0oooo1000
0?l60?ooo`@0003o1P3oool40000oa/0oooo000K0?ooo`80003o00<0oooo0000o`3oool0103oool3
0000o`030?ooo`000?l0oooo00<0oooo00<0003o0?ooo`000?l00P000?l60?ooo`<0003o1P3oool3
0000o`H0oooo10000?l50?ooo`@0003o1P3oool40000o`D0oooo10000?l60?ooo`@0003o=`3oool4
0000o`H0oooo10000?l50?ooo`@0003o1P3oool40000o`D0oooo10000?l60?ooo`<0003o1P3oool3
0000o`H0oooo0`000?l00`3oool0003o0?ooo`030?ooo`030000o`3oool0003o0080003o1@3oool0
10000?l0oooo0000o`000?lL0?ooo`007P3oool010000?l0oooo0?ooo`3oool20000o`@0oooo00D0
003o0?ooo`3oool0oooo0000o`050?ooo`040000o`3oool0oooo0?ooo`80003o0`3oool010000?l0
oooo0?ooo`3oool20000o`<0oooo00<0003o0?ooo`3oool00P3oool00`000?l0oooo0000o`020000
o`H0oooo0`000?l60?ooo`@0003o1@3oool40000o`H0oooo10000?lg0?ooo`@0003o1P3oool40000
o`D0oooo10000?l60?ooo`<0003o1P3oool30000o`030?ooo`000?l0oooo00<0oooo00@0003o0?oo
o`3oool0oooo0P000?l30?ooo`040000o`3oool0oooo0?ooo`80003o0`3oool00`000?l0oooo0?oo
o`030?ooo`050000o`3oool0oooo0?ooo`000?l0103oool20000o`<0oooo00<0003o0?ooo`3oool0
7@3oool001l0oooo0`000?l70?ooo`<0003o1`3oool30000o`H0oooo0`000?l50?ooo`030000o`3o
ool0003o0080003o1@3oool010000?l0oooo0?ooo`3oool20000o`<0oooo00<0003o0?ooo`3oool0
0P3oool00`000?l0oooo0000o`020000o`H0oooo0`000?l60?ooo`@0003o=`3oool40000o`H0oooo
0`000?l60?ooo`<0003o00<0oooo0000o`3oool00`3oool010000?l0oooo0?ooo`3oool20000o`<0
oooo00<0003o0?ooo`3oool00`3oool30000o`030?ooo`000?l0oooo00@0oooo0`000?l60?ooo`<0
003o1`3oool30000o`L0oooo0`000?lP0?ooo`007`3oool40000o`D0oooo10000?l60?ooo`@0003o
1P3oool40000o`D0oooo10000?l60?ooo`<0003o1@3oool00`000?l0oooo0000o`020000o`D0oooo
00@0003o0?ooo`3oool0oooo0P000?l30?ooo`030000o`3oool0oooo00<0oooo0`000?li0?ooo`<0
003o1@3oool010000?l0oooo0?ooo`3oool20000o`<0oooo00<0003o0?ooo`3oool00`3oool30000
o`030?ooo`000?l0oooo00@0oooo0`000?l60?ooo`@0003o1@3oool40000o`H0oooo10000?l60?oo
o`@0003o1@3oool40000ob00oooo000O0?ooo`@0003o1@3oool40000o`H0oooo10000?l60?ooo`@0
003o1@3oool40000o`D0oooo10000?l60?ooo`@0003o1P3oool30000o`H0oooo00D0003o0?ooo`3o
ool0oooo0000o`0o0?ooo`050000o`3oool0oooo0?ooo`000?l01P3oool30000o`H0oooo10000?l6
0?ooo`@0003o1@3oool40000o`D0oooo10000?l60?ooo`@0003o1P3oool40000o`D0oooo10000?lP
0?ooo`00803oool30000o`D0oooo0`000?l00`3oool0003o0?ooo`040?ooo`<0003o00<0oooo0000
o`3oool00`3oool00`000?l0oooo0000o`020000o`D0oooo0`000?l60?ooo`@0003o1P3oool40000
o`D0oooo10000?l70?ooo`<0003o@@3oool30000o`L0oooo10000?l50?ooo`@0003o1P3oool40000
o`H0oooo0`000?l50?ooo`<0003o00<0oooo0000o`3oool00`3oool00`000?l0oooo0000o`020000
o`D0oooo00<0003o0?ooo`000?l00P000?l50?ooo`<0003o8@3oool002<0oooo0`000?l00`3oool0
003o0?ooo`030?ooo`030000o`3oool0003o00<0003o103oool00`000?l0oooo0000o`020000o`D0
oooo00D0003o0?ooo`3oool0oooo0000o`030?ooo`030000o`3oool0oooo00<0oooo0`000?l00`3o
ool0003o0?ooo`040?ooo`<0003o1P3oool40000o`H0oooo10000?m10?ooo`@0003o1P3oool40000
o`H0oooo0`000?l50?ooo`030000o`3oool0003o0080003o1@3oool01@000?l0oooo0?ooo`3oool0
003o00<0oooo00<0003o0?ooo`3oool00`3oool30000o`030?ooo`000?l0oooo00<0oooo10000?l0
0`3oool0003o0?ooo`030?ooo`030000o`3oool0003o0080003o903oool002<0oooo10000?l60?oo
o`@0003o1P3oool40000o`H0oooo0`000?l50?ooo`<0003o00<0oooo0000o`3oool00`3oool00`00
0?l0oooo0000o`030000o`<0oooo00<0003o0?ooo`3oool00`3oool30000o`030?ooo`000?l0oooo
00@0oooo10000?m10?ooo`@0003o1@3oool00`000?l0oooo0000o`020000o`D0oooo00@0003o0?oo
o`3oool0oooo10000?l00`3oool0003o0?ooo`030?ooo`030000o`3oool0003o0080003o1@3oool3
0000o`H0oooo10000?l60?ooo`@0003o1P3oool40000ob@0oooo000S0?ooo`@0003o1P3oool40000
o`H0oooo10000?l50?ooo`@0003o1@3oool40000o`H0oooo10000?l50?ooo`030000o`3oool0003o
0080003o103oool00`000?l0oooo0?ooo`030?ooo`<0003o@`3oool30000o`@0oooo00<0003o0?oo
o`3oool00`3oool30000o`030?ooo`000?l0oooo00@0oooo10000?l60?ooo`@0003o1@3oool40000
o`D0oooo10000?l60?ooo`@0003o1P3oool40000ob@0oooo000T0?ooo`<0003o1P3oool30000o`L0
oooo0`000?l60?ooo`@0003o1@3oool40000o`H0oooo10000?l60?ooo`@0003o1@3oool30000o`03
0?ooo`000?l0oooo04P0oooo00<0003o0?ooo`000?l00P000?l50?ooo`@0003o1P3oool40000o`H0
oooo10000?l50?ooo`@0003o1P3oool30000o`L0oooo0`000?l60?ooo`<0003o9@3oool002L0oooo
00<0003o0?ooo`3oool00P3oool01@000?l0oooo0?ooo`3oool0003o00D0oooo00D0003o0?ooo`3o
ool0oooo0000o`050?ooo`<0003o00<0oooo0000o`3oool0103oool30000o`H0oooo0`000?l70?oo
o`@0003o1@3oool40000od/0oooo10000?l50?ooo`@0003o1`3oool30000o`H0oooo0`000?l50?oo
o`030000o`3oool0003o0080003o1@3oool01@000?l0oooo0?ooo`3oool0003o00D0oooo00D0003o
0?ooo`3oool0oooo0000o`040?ooo`030000o`3oool0oooo02H0oooo000W0?ooo`030000o`3oool0
003o0080003o1@3oool30000o`030?ooo`000?l0oooo00@0oooo0`000?l00`3oool0003o0?ooo`03
0?ooo`030000o`3oool0003o00<0003o0`3oool010000?l0oooo0?ooo`3oool20000o`<0oooo00<0
003o0?ooo`3oool0103oool30000o`H0oooo10000?m;0?ooo`@0003o1P3oool30000o`H0oooo00@0
003o0?ooo`3oool0oooo0P000?l30?ooo`040000o`3oool0oooo0?ooo`@0003o00<0oooo0000o`3o
ool00`3oool00`000?l0oooo0000o`020000o`D0oooo00<0003o0?ooo`000?l00P000?l50?ooo`<0
003o00<0oooo0000o`3oool09`3oool002P0oooo10000?l50?ooo`@0003o1P3oool40000o`H0oooo
10000?l50?ooo`<0003o1P3oool010000?l0oooo0?ooo`3oool20000o`<0oooo00<0003o0?ooo`3o
ool0103oool20000odd0oooo0P000?l60?ooo`040000o`3oool0oooo0?ooo`80003o0`3oool00`00
0?l0oooo0?ooo`040?ooo`<0003o1@3oool40000o`H0oooo10000?l60?ooo`@0003o1@3oool40000
obT0oooo000X0?ooo`@0003o1@3oool40000o`H0oooo10000?l60?ooo`@0003o1@3oool40000o`H0
oooo0`000?l60?ooo`<0003o00<0oooo0000o`000?l0D@3oool20000o`040?ooo`000?l0003o0000
o`H0oooo0`000?l60?ooo`@0003o1@3oool40000o`H0oooo10000?l60?ooo`@0003o1@3oool40000
obT0oooo000Y0?ooo`80003o1`3oool30000o`H0oooo10000?l60?ooo`<0003o1P3oool40000o`H0
oooo10000?l50?ooo`@0003oE@3oool40000o`D0oooo10000?l60?ooo`@0003o1P3oool30000o`H0
oooo10000?l60?ooo`<0003o1`3oool20000obX0oooo000[0?ooo`80003o0`3oool20000o`<0oooo
00<0003o0?ooo`3oool00P3oool00`000?l0oooo0?ooo`020?ooo`040000o`3oool0oooo0?ooo`80
003o0`3oool00`000?l0oooo0?ooo`020?ooo`030000o`3oool0003o0080003o1P3oool40000o`D0
oooo10000?mE0?ooo`@0003o1@3oool40000o`H0oooo0`000?l00`3oool0003o0?ooo`030?ooo`04
0000o`3oool0oooo0?ooo`80003o0`3oool00`000?l0oooo0?ooo`020?ooo`030000o`3oool0oooo
0080oooo00@0003o0?ooo`3oool0oooo0P000?l30?ooo`80003o;03oool002d0oooo0`000?l60?oo
o`@0003o1P3oool30000o`H0oooo0`000?l00`3oool0003o0?ooo`030?ooo`040000o`3oool0oooo
0?ooo`80003o00@0oooo0000o`000?l0003o1P3oool20000oeL0oooo0P000?l60?ooo`<0003o00<0
oooo0000o`000?l00`3oool00`000?l0oooo0?ooo`020?ooo`030000o`3oool0003o0080003o1P3o
ool30000o`H0oooo10000?l60?ooo`<0003o;P3oool002`0oooo10000?l60?ooo`@0003o1P3oool4
0000o`D0oooo10000?l60?ooo`<0003o1P3oool010000?l0oooo0?ooo`3oool20000oe/0oooo0P00
0?l30?ooo`030000o`3oool0oooo00@0oooo0`000?l60?ooo`@0003o1@3oool40000o`H0oooo1000
0?l60?ooo`@0003o;@3oool002`0oooo10000?l60?ooo`@0003o1P3oool40000o`D0oooo10000?l6
0?ooo`@0003o1P3oool30000oel0oooo0`000?l60?ooo`@0003o1P3oool40000o`D0oooo10000?l6
0?ooo`@0003o1P3oool40000obd0oooo000]0?ooo`80003o00<0oooo0000o`3oool00`3oool00`00
0?l0oooo0000o`020000o`D0oooo00<0003o0?ooo`000?l00P000?l60?ooo`<0003o1P3oool40000
o`D0oooo10000?mO0?ooo`@0003o1@3oool40000o`H0oooo0`000?l60?ooo`<0003o00<0oooo0000
o`3oool0103oool30000o`030?ooo`000?l0oooo00<0oooo00@0003o0?ooo`000?l0003o;P3oool0
0300oooo00D0003o0?ooo`3oool0oooo0000o`050?ooo`<0003o00<0oooo0000o`3oool0103oool3
0000o`030?ooo`000?l0003o00<0oooo00<0003o0?ooo`3oool00P3oool00`000?l0oooo0000o`02
0000o`D0oooo10000?mO0?ooo`@0003o1@3oool30000o`030?ooo`000?l0oooo00<0oooo00@0003o
0?ooo`3oool0oooo0P000?l0103oool0003o0000o`000?l50?ooo`030000o`3oool0003o0080003o
1@3oool01@000?l0oooo0?ooo`3oool0003o0340oooo000a0?ooo`<0003o1P3oool40000o`H0oooo
10000?l50?ooo`030000o`3oool0003o0080003o103oool00`000?l0oooo0?ooo`030?ooo`<0003o
H@3oool30000o`@0oooo00<0003o0?ooo`3oool00`3oool30000o`030?ooo`000?l0oooo00@0oooo
10000?l60?ooo`@0003o1P3oool30000oc80oooo000a0?ooo`@0003o1@3oool40000o`H0oooo1000
0?l60?ooo`@0003o1@3oool00`000?l0oooo0000o`020000ofL0oooo0`000?l00`3oool0003o0?oo
o`040?ooo`@0003o1P3oool40000o`H0oooo10000?l50?ooo`@0003o<P3oool00340oooo10000?l6
0?ooo`<0003o1`3oool30000o`H0oooo10000?l60?ooo`@0003oI`3oool40000o`H0oooo10000?l6
0?ooo`<0003o1`3oool30000o`H0oooo10000?lb0?ooo`00<P3oool30000o`D0oooo00D0003o0?oo
o`3oool0oooo0000o`050?ooo`050000o`3oool0oooo0?ooo`000?l01@3oool30000o`L0oooo1000
0?mW0?ooo`@0003o1`3oool30000o`D0oooo00D0003o0?ooo`3oool0oooo0000o`050?ooo`050000
o`3oool0oooo0?ooo`000?l01@3oool30000oc<0oooo000e0?ooo`<0003o00<0oooo0000o`3oool0
0`3oool00`000?l0oooo0000o`030000o`D0oooo00D0003o0?ooo`3oool0oooo0000o`030?ooo`03
0000o`3oool0oooo00@0oooo0`000?mY0?ooo`<0003o1P3oool010000?l0oooo0?ooo`3oool20000
o`<0oooo00<0003o0?ooo`3oool00P3oool40000o`030?ooo`000?l0oooo00<0oooo00<0003o0?oo
o`000?l00P000?lf0?ooo`00=@3oool40000o`H0oooo10000?l70?ooo`<0003o1@3oool00`000?l0
oooo0000o`030000ofl0oooo10000?l00`3oool0003o0?ooo`050?ooo`<0003o1P3oool40000o`H0
oooo10000?lf0?ooo`00=@3oool40000o`H0oooo10000?l60?ooo`@0003o1P3oool40000og40oooo
10000?l60?ooo`@0003o1P3oool40000o`H0oooo10000?lf0?ooo`00=P3oool30000o`H0oooo0`00
0?l70?ooo`@0003o1P3oool40000og40oooo10000?l60?ooo`@0003o1`3oool30000o`H0oooo0`00
0?lg0?ooo`00>@3oool010000?l0oooo0?ooo`3oool20000o`<0oooo0P000?l40?ooo`060000o`3o
ool0003o0000o`3oool0003o1@3oool30000og<0oooo0`000?l60?ooo`<0003o00<0oooo0000o`00
0?l00`3oool20000o`<0oooo0P000?l30?ooo`030000o`3oool0oooo03P0oooo000j0?ooo`<0003o
1`3oool40000o`D0oooo00@0003o0?ooo`3oool0oooo0P000?mi0?ooo`80003o0`3oool00`000?l0
oooo0?ooo`040?ooo`<0003o1`3oool30000oc/0oooo000j0?ooo`@0003o1P3oool40000o`H0oooo
0`000?mm0?ooo`<0003o1P3oool40000o`H0oooo10000?lk0?ooo`00>P3oool40000o`H0oooo1000
0?l60?ooo`@0003oN`3oool40000o`H0oooo10000?l60?ooo`@0003o>`3oool003/0oooo0`000?l5
0?ooo`030000o`3oool0003o0080003o1P3oool40000og/0oooo10000?l60?ooo`<0003o00<0oooo
0000o`3oool0103oool30000oc`0oooo000n0?ooo`030000o`3oool0003o0080003o1@3oool01000
0?l0oooo0?ooo`3oool20000o`030?ooo`000?l0003o07d0oooo0P000?l00`3oool0003o0000o`03
0?ooo`030000o`3oool0oooo00<0oooo00<0003o0?ooo`000?l00P000?lo0?ooo`00?`3oool40000
o`H0oooo0`000?n70?ooo`<0003o1`3oool40000ocl0oooo000o0?ooo`@0003o1P3oool40000ohD0
oooo10000?l70?ooo`@0003o?`3oool00400oooo0P000?l70?ooo`@0003oQ@3oool40000o`L0oooo
0`000?m00?ooo`00@P3oool00`000?l0oooo0?ooo`030?ooo`040000o`3oool0003o0000ohL0oooo
0P000?l00`3oool0003o0?ooo`040?ooo`030000o`3oool0oooo0440oooo00130?ooo`<0003o00<0
oooo0000o`3oool0SP3oool00`000?l0oooo0000o`020000od@0oooo00130?ooo`@0003oT@3oool4
0000od@0oooo00130?ooo`@0003oT@3oool40000od@0oooo00140?ooo`80003oT`3oool20000odD0
oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {207.875, 0}} -> {-1.05153, -0.846189, \
0.0073274, 0.0073274}}]
}, Open  ]],

Cell[TextData[{
  "This draws a directed graph with labeled circles representing the vertices \
and arrows in the middle of the edges. ",
  StyleBox["GraphCoordinates", "MR"],
  " is first used to compute the coordinates of the vertices, which are then \
supplied to ",
  StyleBox["GraphPlot", "MR"],
  " using the option ",
  StyleBox["VertexCoordinates", "MR"],
  ". The vertex labels are calculated using ",
  StyleBox["VertexList", "MR"],
  ". More information about ",
  StyleBox["GraphCoordinates", "MR"],
  " is available ",
  ButtonBox["here",
    ButtonData:>"GraphCoordinates",
    ButtonStyle->"Hyperlink"],
  "; ",
  StyleBox["VertexList", "MR"],
  " is described ",
  ButtonBox["here",
    ButtonData:>"VertexList",
    ButtonStyle->"Hyperlink"],
  "."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(g = {1 \[Rule] 2, 2 \[Rule] 3, 3 \[Rule] 4, 4 \[Rule] 5, 5 \[Rule] 6, 
          6 \[Rule] 7, 7 \[Rule] 8, 8 \[Rule] 9, 9 \[Rule] 10, 10 \[Rule] 10, 
          10 \[Rule] 11, 11 \[Rule] 12, 12 \[Rule] 13, 13 \[Rule] 14, 
          15 \[Rule] 16, 16 \[Rule] 17, 17 \[Rule] 18, 18 \[Rule] 1, 
          14 \[Rule] 19, 13 \[Rule] 19, 19 \[Rule] 12, 12 \[Rule] 20, 
          11 \[Rule] 20, 20 \[Rule] 10, 10 \[Rule] 21, 21 \[Rule] 9, 
          9 \[Rule] 9, 21 \[Rule] 8, 8 \[Rule] 22, 22 \[Rule] 7, 
          22 \[Rule] 6, 6 \[Rule] 23, 23 \[Rule] 4, 23 \[Rule] 5, 
          4 \[Rule] 24, 24 \[Rule] 3, 24 \[Rule] 2, 2 \[Rule] 25, 
          25 \[Rule] 1, 25 \[Rule] 18, 18 \[Rule] 26, 26 \[Rule] 17, 
          16 \[Rule] 26, 16 \[Rule] 27, 15 \[Rule] 27, 14 \[Rule] 15, 
          14 \[Rule] 27, 9 \[Rule] 7, 7 \[Rule] 23, 23 \[Rule] 24, 
          1 \[Rule] 24, 17 \[Rule] 1, 15 \[Rule] 17, 13 \[Rule] 15, 
          13 \[Rule] 20, 20 \[Rule] 9};\)\), "\[IndentingNewLine]", 
    \(\(coord = GraphCoordinates[g];\)\), "\[IndentingNewLine]", 
    \(\(labels\  = \ VertexList[g];\)\), "\[IndentingNewLine]", 
    \(\(esf[i_, j_] := 
        Block[{}, {Blue, Line[{i, j}], 
            Arrow[coord[\([i]\)], \ 
              coord[\([i]\)] + 
                0.7 \((coord[\([j]\)] - 
                      coord[\([i]\)])\)]}];\)\), "\[IndentingNewLine]", 
    \(\(GraphPlot[g, EdgeStyleFunction \[Rule] esf, 
        VertexStyleFunction \[Rule] \(({White, Disk[#, 0.05], Black, 
                Circle[#, 0.05], Red, Text[labels[\([#]\)], #]} &)\), 
        VertexCoordinates \[Rule] coord];\)\)}], "Input",
  CellLabel->"In[9]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .97515 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.500291 0.455017 0.474163 0.455017 [
[.61996 .15211 -3 -4.5 ]
[.61996 .15211 3 4.5 ]
[.50204 .05607 -3 -4.5 ]
[.50204 .05607 3 4.5 ]
[.34433 .04597 -3 -4.5 ]
[.34433 .04597 3 4.5 ]
[.2308 .15338 -3 -4.5 ]
[.2308 .15338 3 4.5 ]
[.10426 .24551 -3 -4.5 ]
[.10426 .24551 3 4.5 ]
[.08388 .39983 -3 -4.5 ]
[.08388 .39983 3 4.5 ]
[.15786 .53213 -3 -4.5 ]
[.15786 .53213 3 4.5 ]
[.13336 .6808 -3 -4.5 ]
[.13336 .6808 3 4.5 ]
[.27616 .73605 -3 -4.5 ]
[.27616 .73605 3 4.5 ]
[.35364 .86694 -6 -4.5 ]
[.35364 .86694 6 4.5 ]
[.49851 .92918 -6 -4.5 ]
[.49851 .92918 6 4.5 ]
[.64377 .86779 -6 -4.5 ]
[.64377 .86779 6 4.5 ]
[.72219 .73741 -6 -4.5 ]
[.72219 .73741 6 4.5 ]
[.86538 .68312 -6 -4.5 ]
[.86538 .68312 6 4.5 ]
[.84218 .53459 -6 -4.5 ]
[.84218 .53459 6 4.5 ]
[.91731 .40342 -6 -4.5 ]
[.91731 .40342 6 4.5 ]
[.80146 .30417 -6 -4.5 ]
[.80146 .30417 6 4.5 ]
[.7724 .15615 -6 -4.5 ]
[.7724 .15615 6 4.5 ]
[.79449 .82302 -6 -4.5 ]
[.79449 .82302 6 4.5 ]
[.49888 .81763 -6 -4.5 ]
[.49888 .81763 6 4.5 ]
[.20326 .82121 -6 -4.5 ]
[.20326 .82121 6 4.5 ]
[.04656 .55312 -6 -4.5 ]
[.04656 .55312 6 4.5 ]
[.20045 .3016 -6 -4.5 ]
[.20045 .3016 6 4.5 ]
[.38326 .15124 -6 -4.5 ]
[.38326 .15124 6 4.5 ]
[.65987 .04773 -6 -4.5 ]
[.65987 .04773 6 4.5 ]
[.89816 .24952 -6 -4.5 ]
[.89816 .24952 6 4.5 ]
[.95344 .55662 -6 -4.5 ]
[.95344 .55662 6 4.5 ]
[ 0 0 0 0 ]
[ 1 .97515 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
% Start of user PostScript
/mathtops {
gsave
MBeginOrig
moveto
MEndOrig
currentpoint
grestore
} bind def
/MAtocoords {
mathtops 4 2 roll mathtops
4 copy pop pop
3 -1 roll sub
/arry exch def
exch sub
/arrx exch def
arrx dup mul
arry dup mul
add sqrt
/arrl exch def
translate
} bind def
/MAarrowhead1 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto fill
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto
-0.05 0.0125 lineto stroke
} ifelse
grestore
} def
% End of user PostScript
0 0 1 r
.5 Mabswid
[ ] 0 setdash
.61996 .15211 m
.50204 .05607 L
s
.61996 .15211 m
.53742 .08488 L
s
% Start of user PostScript
0.2629992 -0.70777837 0.081593985 -0.85553636 MAarrowhead1
% End of user PostScript
.61996 .15211 m
.38326 .15124 L
s
.61996 .15211 m
.45427 .1515 L
s
% Start of user PostScript
0.2629992 -0.70777837 -0.10114014 -0.70911333 MAarrowhead1
% End of user PostScript
.50204 .05607 m
.34433 .04597 L
s
.50204 .05607 m
.39164 .049 L
s
% Start of user PostScript
0.0038488921 -0.91886121 -0.23878098 -0.93439389 MAarrowhead1
% End of user PostScript
.50204 .05607 m
.65987 .04773 L
s
.50204 .05607 m
.61252 .05023 L
s
% Start of user PostScript
0.0038488921 -0.91886121 0.24665777 -0.93168298 MAarrowhead1
% End of user PostScript
.34433 .04597 m
.2308 .15338 L
s
.34433 .04597 m
.26486 .12116 L
s
% Start of user PostScript
-0.34276521 -0.94105075 -0.51741612 -0.77580452 MAarrowhead1
% End of user PostScript
.2308 .15338 m
.10426 .24551 L
s
.2308 .15338 m
.14222 .21787 L
s
% Start of user PostScript
-0.59226651 -0.70498471 -0.78693993 -0.56326021 MAarrowhead1
% End of user PostScript
.2308 .15338 m
.38326 .15124 L
s
.2308 .15338 m
.33752 .15189 L
s
% Start of user PostScript
-0.59226651 -0.70498471 -0.35771985 -0.70827523 MAarrowhead1
% End of user PostScript
.10426 .24551 m
.08388 .39983 L
s
.10426 .24551 m
.08999 .35354 L
s
% Start of user PostScript
-0.87037139 -0.50252114 -0.90172599 -0.26510345 MAarrowhead1
% End of user PostScript
.08388 .39983 m
.15786 .53213 L
s
.08388 .39983 m
.13567 .49244 L
s
% Start of user PostScript
-0.91516368 -0.16335301 -0.80134324 0.040177404 MAarrowhead1
% End of user PostScript
.08388 .39983 m
.20045 .3016 L
s
.08388 .39983 m
.16548 .33107 L
s
% Start of user PostScript
-0.91516368 -0.16335301 -0.73582036 -0.31447861 MAarrowhead1
% End of user PostScript
.15786 .53213 m
.13336 .6808 L
s
.15786 .53213 m
.14071 .6362 L
s
% Start of user PostScript
-0.75256306 0.12740472 -0.7902515 0.35610882 MAarrowhead1
% End of user PostScript
.15786 .53213 m
.20045 .3016 L
s
.15786 .53213 m
.18768 .37076 L
s
% Start of user PostScript
-0.75256306 0.12740472 -0.68704018 -0.2272513 MAarrowhead1
% End of user PostScript
.13336 .6808 m
.27616 .73605 L
s
.13336 .6808 m
.23332 .71948 L
s
% Start of user PostScript
-0.80640369 0.45412487 -0.586726 0.53912753 MAarrowhead1
% End of user PostScript
.13336 .6808 m
.04656 .55312 L
s
.13336 .6808 m
.0726 .59142 L
s
% Start of user PostScript
-0.80640369 0.45412487 -0.93994093 0.25770605 MAarrowhead1
% End of user PostScript
.27616 .73605 m
.35364 .86694 L
s
.27616 .73605 m
.3304 .82768 L
s
% Start of user PostScript
-0.49257842 0.57555724 -0.37337833 0.77692144 MAarrowhead1
% End of user PostScript
.27616 .73605 m
.15786 .53213 L
s
.27616 .73605 m
.19335 .59331 L
s
% Start of user PostScript
-0.49257842 0.57555724 -0.67456767 0.26185048 MAarrowhead1
% End of user PostScript
.35364 .86694 m
.49851 .92918 L
s
.35364 .86694 m
.45505 .91051 L
s
% Start of user PostScript
-0.32229258 0.86322038 -0.099423235 0.95896611 MAarrowhead1
% End of user PostScript
.35364 .86694 m
.20326 .82121 L
s
.35364 .86694 m
.24838 .83493 L
s
% Start of user PostScript
-0.32229258 0.86322038 -0.55363532 0.79285728 MAarrowhead1
% End of user PostScript
.49851 .92918 m
.64377 .86779 L
s
.49851 .92918 m
.6002 .88621 L
s
% Start of user PostScript
-0.0039078001 1. 0.21956354 0.90555689 MAarrowhead1
% End of user PostScript
.49851 .92918 m
.49888 .81763 L
s
.49851 .92918 m
.49877 .85109 L
s
% Start of user PostScript
-0.0039078001 1. -0.0033482669 0.82838239 MAarrowhead1
% End of user PostScript
.64377 .86779 m
.72219 .73741 L
s
.64377 .86779 m
.69867 .77653 L
s
% Start of user PostScript
0.31533697 0.86508128 0.43597357 0.66450636 MAarrowhead1
% End of user PostScript
.64377 .86779 m
.49888 .81763 L
s
.64377 .86779 m
.54235 .83267 L
s
% Start of user PostScript
0.31533697 0.86508128 0.092425163 0.78790677 MAarrowhead1
% End of user PostScript
.72219 .73741 m
.86538 .68312 L
s
.72219 .73741 m
.82242 .69941 L
s
% Start of user PostScript
0.48767497 0.57854568 0.707951 0.49502106 MAarrowhead1
% End of user PostScript
.72219 .73741 m
.79449 .82302 L
s
.72219 .73741 m
.7728 .79734 L
s
% Start of user PostScript
0.48767497 0.57854568 0.59890026 0.7102447 MAarrowhead1
% End of user PostScript
.72219 .73741 m
.84218 .53459 L
s
.72219 .73741 m
.80618 .59543 L
s
% Start of user PostScript
0.48767497 0.57854568 0.67226791 0.26651896 MAarrowhead1
% End of user PostScript
.72219 .73741 m
.49888 .81763 L
s
.72219 .73741 m
.56587 .79356 L
s
% Start of user PostScript
0.48767497 0.57854568 0.14412656 0.70194609 MAarrowhead1
% End of user PostScript
.86538 .68312 m
.79449 .82302 L
s
.86538 .68312 m
.81576 .78105 L
s
% Start of user PostScript
0.80235501 0.45922479 0.69330428 0.67444843 MAarrowhead1
% End of user PostScript
.86538 .68312 m
.84218 .53459 L
s
.86538 .68312 m
.84914 .57915 L
s
% Start of user PostScript
0.80235501 0.45922479 0.76667193 0.2307227 MAarrowhead1
% End of user PostScript
.86538 .68312 m
.95344 .55662 L
s
.86538 .68312 m
.92702 .59457 L
s
% Start of user PostScript
0.80235501 0.45922479 0.93783184 0.26461652 MAarrowhead1
% End of user PostScript
.84218 .53459 m
.91731 .40342 L
s
.84218 .53459 m
.89477 .44277 L
s
% Start of user PostScript
0.75137917 0.13279323 0.86695728 -0.068996727 MAarrowhead1
% End of user PostScript
.84218 .53459 m
.95344 .55662 L
s
.84218 .53459 m
.92006 .55001 L
s
% Start of user PostScript
0.75137917 0.13279323 0.92253909 0.16668705 MAarrowhead1
% End of user PostScript
.84218 .53459 m
.80146 .30417 L
s
.84218 .53459 m
.81368 .37329 L
s
% Start of user PostScript
0.75137917 0.13279323 0.68873713 -0.22168516 MAarrowhead1
% End of user PostScript
.91731 .40342 m
.80146 .30417 L
s
.91731 .40342 m
.83622 .33394 L
s
% Start of user PostScript
0.91649076 -0.15547814 0.73827061 -0.30816657 MAarrowhead1
% End of user PostScript
.91731 .40342 m
.89816 .24952 L
s
.91731 .40342 m
.90391 .29569 L
s
% Start of user PostScript
0.91649076 -0.15547814 0.88703584 -0.39222851 MAarrowhead1
% End of user PostScript
.91731 .40342 m
.95344 .55662 L
s
.91731 .40342 m
.9426 .51066 L
s
% Start of user PostScript
0.91649076 -0.15547814 0.97207256 0.080205641 MAarrowhead1
% End of user PostScript
.80146 .30417 m
.7724 .15615 L
s
.80146 .30417 m
.78112 .20056 L
s
% Start of user PostScript
0.66189054 -0.37360447 0.61718374 -0.60131266 MAarrowhead1
% End of user PostScript
.80146 .30417 m
.61996 .15211 L
s
.80146 .30417 m
.67441 .19773 L
s
% Start of user PostScript
0.66189054 -0.37360447 0.3826666 -0.6075262 MAarrowhead1
% End of user PostScript
.7724 .15615 m
.61996 .15211 L
s
.7724 .15615 m
.66569 .15332 L
s
% Start of user PostScript
0.59802368 -0.69890188 0.36350654 -0.70511543 MAarrowhead1
% End of user PostScript
.7724 .15615 m
.89816 .24952 L
s
.7724 .15615 m
.86044 .22151 L
s
% Start of user PostScript
0.59802368 -0.69890188 0.79149572 -0.55525563 MAarrowhead1
% End of user PostScript
.79449 .82302 m
.64377 .86779 L
s
.79449 .82302 m
.68899 .85436 L
s
% Start of user PostScript
0.64656825 0.76668714 0.41470635 0.83556304 MAarrowhead1
% End of user PostScript
.49888 .81763 m
.35364 .86694 L
s
.49888 .81763 m
.39721 .85215 L
s
% Start of user PostScript
-0.003108467 0.75483198 -0.22653735 0.83070386 MAarrowhead1
% End of user PostScript
.49888 .81763 m
.27616 .73605 L
s
.49888 .81763 m
.34297 .76052 L
s
% Start of user PostScript
-0.003108467 0.75483198 -0.34573743 0.62933966 MAarrowhead1
% End of user PostScript
.20326 .82121 m
.27616 .73605 L
s
.20326 .82121 m
.25429 .7616 L
s
% Start of user PostScript
-0.65278221 0.76270166 -0.54063955 0.63170057 MAarrowhead1
% End of user PostScript
.20326 .82121 m
.13336 .6808 L
s
.20326 .82121 m
.15433 .72292 L
s
% Start of user PostScript
-0.65278221 0.76270166 -0.76031725 0.5466979 MAarrowhead1
% End of user PostScript
.04656 .55312 m
.15786 .53213 L
s
.04656 .55312 m
.12447 .53843 L
s
% Start of user PostScript
-0.99717117 0.17352656 -0.82594549 0.14124127 MAarrowhead1
% End of user PostScript
.04656 .55312 m
.08388 .39983 L
s
.04656 .55312 m
.07268 .44582 L
s
% Start of user PostScript
-0.99717117 0.17352656 -0.93976592 -0.062289137 MAarrowhead1
% End of user PostScript
.20045 .3016 m
.2308 .15338 L
s
.20045 .3016 m
.2217 .19785 L
s
% Start of user PostScript
-0.65895894 -0.37924673 -0.61227424 -0.60726332 MAarrowhead1
% End of user PostScript
.20045 .3016 m
.10426 .24551 L
s
.20045 .3016 m
.13312 .26233 L
s
% Start of user PostScript
-0.65895894 -0.37924673 -0.80694766 -0.46553882 MAarrowhead1
% End of user PostScript
.20045 .3016 m
.38326 .15124 L
s
.20045 .3016 m
.32842 .19635 L
s
% Start of user PostScript
-0.65895894 -0.37924673 -0.37772758 -0.61055383 MAarrowhead1
% End of user PostScript
.38326 .15124 m
.34433 .04597 L
s
.38326 .15124 m
.35601 .07755 L
s
% Start of user PostScript
-0.25719986 -0.70968545 -0.3170956 -0.87164116 MAarrowhead1
% End of user PostScript
.38326 .15124 m
.50204 .05607 L
s
.38326 .15124 m
.46641 .08462 L
s
% Start of user PostScript
-0.25719986 -0.70968545 -0.074465732 -0.85610848 MAarrowhead1
% End of user PostScript
.65987 .04773 m
.61996 .15211 L
s
.65987 .04773 m
.63193 .1208 L
s
% Start of user PostScript
0.35071871 -0.93717802 0.28931505 -0.77659827 MAarrowhead1
% End of user PostScript
.65987 .04773 m
.7724 .15615 L
s
.65987 .04773 m
.73864 .12362 L
s
% Start of user PostScript
0.35071871 -0.93717802 0.52383219 -0.77038472 MAarrowhead1
% End of user PostScript
.89816 .24952 m
.80146 .30417 L
s
.89816 .24952 m
.83047 .28777 L
s
% Start of user PostScript
0.87441231 -0.49369295 0.72564707 -0.40963102 MAarrowhead1
% End of user PostScript
1 g
.61996 .15211 m
.61996 .15211 .02275 0 365.73 arc
F
0 g
newpath
.61996 .15211 .02275 0 365.73 arc
s
1 0 0 r
[(1)] .61996 .15211 0 0 Mshowa
1 g
.50204 .05607 m
.50204 .05607 .02275 0 365.73 arc
F
0 g
newpath
.50204 .05607 .02275 0 365.73 arc
s
1 0 0 r
[(2)] .50204 .05607 0 0 Mshowa
1 g
.34433 .04597 m
.34433 .04597 .02275 0 365.73 arc
F
0 g
newpath
.34433 .04597 .02275 0 365.73 arc
s
1 0 0 r
[(3)] .34433 .04597 0 0 Mshowa
1 g
.2308 .15338 m
.2308 .15338 .02275 0 365.73 arc
F
0 g
newpath
.2308 .15338 .02275 0 365.73 arc
s
1 0 0 r
[(4)] .2308 .15338 0 0 Mshowa
1 g
.10426 .24551 m
.10426 .24551 .02275 0 365.73 arc
F
0 g
newpath
.10426 .24551 .02275 0 365.73 arc
s
1 0 0 r
[(5)] .10426 .24551 0 0 Mshowa
1 g
.08388 .39983 m
.08388 .39983 .02275 0 365.73 arc
F
0 g
newpath
.08388 .39983 .02275 0 365.73 arc
s
1 0 0 r
[(6)] .08388 .39983 0 0 Mshowa
1 g
.15786 .53213 m
.15786 .53213 .02275 0 365.73 arc
F
0 g
newpath
.15786 .53213 .02275 0 365.73 arc
s
1 0 0 r
[(7)] .15786 .53213 0 0 Mshowa
1 g
.13336 .6808 m
.13336 .6808 .02275 0 365.73 arc
F
0 g
newpath
.13336 .6808 .02275 0 365.73 arc
s
1 0 0 r
[(8)] .13336 .6808 0 0 Mshowa
1 g
.27616 .73605 m
.27616 .73605 .02275 0 365.73 arc
F
0 g
newpath
.27616 .73605 .02275 0 365.73 arc
s
1 0 0 r
[(9)] .27616 .73605 0 0 Mshowa
1 g
.35364 .86694 m
.35364 .86694 .02275 0 365.73 arc
F
0 g
newpath
.35364 .86694 .02275 0 365.73 arc
s
1 0 0 r
[(10)] .35364 .86694 0 0 Mshowa
1 g
.49851 .92918 m
.49851 .92918 .02275 0 365.73 arc
F
0 g
newpath
.49851 .92918 .02275 0 365.73 arc
s
1 0 0 r
[(11)] .49851 .92918 0 0 Mshowa
1 g
.64377 .86779 m
.64377 .86779 .02275 0 365.73 arc
F
0 g
newpath
.64377 .86779 .02275 0 365.73 arc
s
1 0 0 r
[(12)] .64377 .86779 0 0 Mshowa
1 g
.72219 .73741 m
.72219 .73741 .02275 0 365.73 arc
F
0 g
newpath
.72219 .73741 .02275 0 365.73 arc
s
1 0 0 r
[(13)] .72219 .73741 0 0 Mshowa
1 g
.86538 .68312 m
.86538 .68312 .02275 0 365.73 arc
F
0 g
newpath
.86538 .68312 .02275 0 365.73 arc
s
1 0 0 r
[(14)] .86538 .68312 0 0 Mshowa
1 g
.84218 .53459 m
.84218 .53459 .02275 0 365.73 arc
F
0 g
newpath
.84218 .53459 .02275 0 365.73 arc
s
1 0 0 r
[(15)] .84218 .53459 0 0 Mshowa
1 g
.91731 .40342 m
.91731 .40342 .02275 0 365.73 arc
F
0 g
newpath
.91731 .40342 .02275 0 365.73 arc
s
1 0 0 r
[(16)] .91731 .40342 0 0 Mshowa
1 g
.80146 .30417 m
.80146 .30417 .02275 0 365.73 arc
F
0 g
newpath
.80146 .30417 .02275 0 365.73 arc
s
1 0 0 r
[(17)] .80146 .30417 0 0 Mshowa
1 g
.7724 .15615 m
.7724 .15615 .02275 0 365.73 arc
F
0 g
newpath
.7724 .15615 .02275 0 365.73 arc
s
1 0 0 r
[(18)] .7724 .15615 0 0 Mshowa
1 g
.79449 .82302 m
.79449 .82302 .02275 0 365.73 arc
F
0 g
newpath
.79449 .82302 .02275 0 365.73 arc
s
1 0 0 r
[(19)] .79449 .82302 0 0 Mshowa
1 g
.49888 .81763 m
.49888 .81763 .02275 0 365.73 arc
F
0 g
newpath
.49888 .81763 .02275 0 365.73 arc
s
1 0 0 r
[(20)] .49888 .81763 0 0 Mshowa
1 g
.20326 .82121 m
.20326 .82121 .02275 0 365.73 arc
F
0 g
newpath
.20326 .82121 .02275 0 365.73 arc
s
1 0 0 r
[(21)] .20326 .82121 0 0 Mshowa
1 g
.04656 .55312 m
.04656 .55312 .02275 0 365.73 arc
F
0 g
newpath
.04656 .55312 .02275 0 365.73 arc
s
1 0 0 r
[(22)] .04656 .55312 0 0 Mshowa
1 g
.20045 .3016 m
.20045 .3016 .02275 0 365.73 arc
F
0 g
newpath
.20045 .3016 .02275 0 365.73 arc
s
1 0 0 r
[(23)] .20045 .3016 0 0 Mshowa
1 g
.38326 .15124 m
.38326 .15124 .02275 0 365.73 arc
F
0 g
newpath
.38326 .15124 .02275 0 365.73 arc
s
1 0 0 r
[(24)] .38326 .15124 0 0 Mshowa
1 g
.65987 .04773 m
.65987 .04773 .02275 0 365.73 arc
F
0 g
newpath
.65987 .04773 .02275 0 365.73 arc
s
1 0 0 r
[(25)] .65987 .04773 0 0 Mshowa
1 g
.89816 .24952 m
.89816 .24952 .02275 0 365.73 arc
F
0 g
newpath
.89816 .24952 .02275 0 365.73 arc
s
1 0 0 r
[(26)] .89816 .24952 0 0 Mshowa
1 g
.95344 .55662 m
.95344 .55662 .02275 0 365.73 arc
F
0 g
newpath
.95344 .55662 .02275 0 365.73 arc
s
1 0 0 r
[(27)] .95344 .55662 0 0 Mshowa
0 0 m
1 0 L
1 .97515 L
0 .97515 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[9]:=",
  ImageSize->{288, 280.813},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000162000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00HP3oool200000;`0oooo001P0?ooo`8000000P3oool2000005D0oooo1000001Q0?ooo`00
GP3oool2000000H0oooo00<000000?ooo`3oool0D03oool2000000@0oooo0P00001O0?ooo`00G@3o
ool00`000000oooo0?ooo`070?ooo`030000003oool0oooo02H0oooo0P00000V0?ooo`030000003o
ool0oooo00H0oooo0P00001M0?ooo`00G03oool00`000000oooo0?ooo`090?ooo`030000003oool0
oooo0280oooo0`0000020?ooo`800000903oool00`000000oooo0?ooo`070?ooo`030000003oool0
oooo05/0oooo001L0?ooo`030000003oool0oooo0080oooo0P3o00060?ooo`030000003oool0oooo
0100oooo0`000?l<0?ooo`8000001`3oool00`000000oooo0?ooo`0:0?ooo`<0003o4`3oool00`00
0000o`000?l000020?l000<0oooo0P3o00020?ooo`030000003oool0oooo05X0oooo001L0?ooo`05
0000003oool0oooo0?ooo`3o00000P3oool00`3o0000oooo0?ooo`030?ooo`030000003oool0oooo
00`0oooo1`000?l;0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02@3oool70000
o`h0oooo00<000000?ooo`3o00001@3oool01P3o0000oooo0?ooo`3o0000oooo000005`0oooo001L
0?ooo`030000003oool0oooo00<0oooo00<0o`000?ooo`3oool0103oool00`000000oooo0?ooo`07
0?ooo``0003o2`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00T0oooo30000?l9
0?ooo`040000003oool0oooo0?l000L0oooo00<0o`000?ooo`000000G03oool005`0oooo00<00000
0?ooo`3oool0103oool00`3o0000oooo0?ooo`020?ooo`8000005@000?l:0?ooo`030000003oool0
oooo0080oooo103o00040?ooo`030000003oool0oooo00P0oooo5@000?l01@000000oooo0?ooo`3o
ool0o`0000@0oooo0P3o00020?ooo`030000003oool0oooo05X0oooo001L0?ooo`050000003oool0
oooo0?ooo`3o00000P3oool00`3o0000oooo0?ooo`020?ooo`030000003oool0oooo00L0oooo5`00
0?l00`000000oooo0?ooo`020?ooo`030?l0003oool0oooo00D0oooo00<000000?ooo`000?l05@00
0?l90?ooo`050000003o0000oooo0?ooo`3o00000`3oool01@3o0000oooo0?ooo`3oool0000005`0
oooo001M0?ooo`040000003oool0oooo0?ooo`80o`001@3oool00`000000oooo0?ooo`0;0?ooo`T0
003o2@3oool00`000?l000000?ooo`040?ooo`030?l0003oool0oooo00@0oooo00<000000000o`3o
ool0203oool90000o`d0oooo00@000000?ooo`3o0000o`00103oool30?l000030?ooo`000000oooo
05/0oooo001N0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool03`3oool60000o`X0
oooo00<000000?ooo`3oool0103oool00`3o0000oooo0?ooo`030?ooo`030000003oool0oooo00P0
oooo1P000?l@0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0F`3oool005d0oooo
00<0003o0?ooo`0000001`3oool00`000000oooo0?ooo`0C0?ooo`80003o2P3oool00`000000oooo
0?ooo`020?ooo`040?l0003oool0oooo0?l000@0oooo00<000000?ooo`3oool0203oool20000oaD0
oooo00<000000?ooo`3oool01P3oool00`000000003o0?ooo`1L0?ooo`00G03oool010000?l0oooo
0?ooo`3oool7000002<0oooo00<000000?ooo`3oool00P3oool20?l000@0oooo00<000000?ooo`3o
ool08@3oool3000000<0oooo0P0000020?ooo`030000o`3oool0oooo05X0oooo001K0?ooo`030000
o`3oool0oooo00L0oooo00<0003o0?ooo`3oool08`3oool00`000000oooo0?ooo`060?ooo`030000
00000?l0oooo0200oooo0P000?l00`3oool0003o0?ooo`03000000D0oooo00<0003o0?ooo`3oool0
F@3oool005X0oooo00<0003o0?ooo`3oool0203oool00`000?l0oooo0?ooo`0R0?ooo`030000o`3o
ool0000000H0oooo00@000000?ooo`3oool0003o803oool50000o`T0oooo00<0003o0?ooo`3oool0
F03oool005<0oooo00<0003o0?ooo`3oool00`3oool00`000?l0oooo0?ooo`0:0?ooo`030000o`3o
ool0oooo01l0oooo0P000?l30?ooo`H00000103oool00`000?l0oooo0?ooo`0M0?ooo`L0003o203o
ool00`000?l0oooo0?ooo`1G0?ooo`00DP3oool30000o`<0oooo00<0003o0?ooo`3oool02`3oool2
0000oal0oooo00<0003o0?ooo`3oool03P3oool20000oad0oooo1P000?l:0?ooo`030000o`3oool0
oooo0080oooo00<0003o0?ooo`3oool0D@3oool00580oooo1P000?l>0?ooo`80003o703oool30000
oa<0oooo0P000?lJ0?ooo`L0003o2`3oool00`000?l0oooo0?ooo`030000oe80oooo001A0?ooo`H0
003o3`3oool30000oaT0oooo10000?lE0?ooo`<0003o603oool60000o`d0oooo1@000?mB0?ooo`00
D@3oool70000o`h0oooo10000?lF0?ooo`D0003o5P3oool50000oaH0oooo1@000?l>0?ooo`H0003o
D@3oool00500oooo2@000?l=0?ooo`@0003o503oool60000oaP0oooo1P000?lD0?ooo`D0003o3@3o
ool70000oe40oooo001?0?ooo`T0003o3P3oool50000oa40oooo1`000?lJ0?ooo`L0003o4P3oool4
0000o`d0oooo2@000?m@0?ooo`00C`3oool70000oa00oooo1P000?l>0?ooo`P0003o703oool80000
oa00oooo0`000?l?0?ooo`P0003oD03oool004h0oooo1P000?lC0?ooo`D0003o303oool90000oad0
oooo2P000?l>0?ooo`<0003o4@3oool70000odl0oooo001>0?ooo`D0003o503oool60000o``0oooo
20000?lN0?ooo`P0003o3P3oool30000oa@0oooo1P000?m>0?ooo`00C@3oool40000oaH0oooo1`00
0?l;0?ooo`L0003o803oool70000o`h0oooo0P000?lF0?ooo`D0003oCP3oool004d0oooo0P000?lH
0?ooo`L0003o303oool50000ob80oooo1@000?l?0?ooo`80003o603oool40000odd0oooo001<0?oo
o`030000o`3oool0oooo01P0oooo20000?l:0?ooo`030000o`3oool0003o0080003o8`3oool40000
o`030?ooo`000?l0oooo00d0oooo00<0003o0?ooo`3oool06@3oool30000od`0oooo001;0?ooo`03
0000o`3oool0oooo01T0oooo1P000?l;0?ooo`030000o`3oool0oooo00<0003o903oool30000o`80
oooo00<0003o0?ooo`3oool02P3oool00`000?l0oooo0?ooo`0L0?ooo`80003oB`3oool004X0oooo
00<0003o0?ooo`3oool06P3oool50000o`X0oooo0P000?l40?ooo`030000o`3oool0oooo02@0oooo
00<0003o0?ooo`3oool00P3oool20000o`X0oooo00<0003o0?ooo`3oool07P3oool00`000?l0oooo
0?ooo`180?ooo`00@P3oool2000000D0oooo00<0003o0?ooo`3oool06`3oool20000o`80oooo1P00
00040?ooo`80003o<`3oool00`000?l0oooo0?ooo`020?ooo`@0000000<0003o0?ooo`3oool0803o
ool00`000?l0oooo0?ooo`170?ooo`00?`3oool300000080oooo0P0000020?ooo`030000o`3oool0
oooo01h0oooo0P0000060?ooo`80000000<0oooo0000o`3oool0=@3oool010000?l0oooo00000000
00040?ooo`8000008P3oool010000?l0oooo0?ooo`3oool400000440oooo000m0?ooo`8000001`3o
ool00`000000003o0?ooo`0O0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0=P3o
ool00`000?l000000?ooo`060?ooo`8000008@3oool00`000?l0oooo000000040?ooo`800000?`3o
ool003`0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`080?ooo`<0003o4`3oool0
0`000000oooo0?ooo`080?ooo`030000003oool0oooo01P0oooo0`000?lK0?ooo`030000003oool0
oooo00P0oooo00<000000?ooo`3oool04P3oool20000o`/0oooo00<000000?ooo`3oool01@3oool2
000003d0oooo000l0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0203oool70000
o`l0oooo00<000000?l0003o00000P3o00040?ooo`<0o`0000<000000?ooo`3oool04`3oool70000
oa/0oooo00<000000?ooo`3oool01@3o00040?ooo`030000003oool0oooo00d0oooo1P000?l:0?oo
o`030000003oool0oooo00L0oooo00<000000?ooo`3oool0>`3oool003/0oooo00<000000?ooo`3o
ool0103oool30?l000<0oooo00<000000?ooo`3oool01`3oool<0000o`T0oooo00<000000?ooo`3o
0000203oool00`3o0000oooo0000000@0?ooo``0003o6P3oool00`000000oooo0?ooo`030?ooo`03
0?l0003oool0oooo00@0oooo00<000000?ooo`3oool02P3oool90000o`T0oooo00<000000?l0003o
00000`3o00020?ooo`80o`000P3oool00`000000oooo0?ooo`0j0?ooo`00>`3oool00`000000oooo
0?ooo`050?ooo`030?l0003oool0oooo0080oooo00<000000?ooo`3oool01`3ooolE0000o`040000
003oool0oooo0?l000@0oooo1@3o00000`000000003o0000o`0d0000o`030000003oool0oooo00<0
oooo00<0o`000?ooo`3oool0103oool00`000000003o0000o`0C0000o`T0oooo00@000000?ooo`3o
ool0o`000`3oool01P3o0000oooo0?ooo`3o0000oooo000003`0oooo000k0?ooo`030000003oool0
oooo0080oooo1@3o00030?ooo`03000000000?l0003o01@0003o203oool01@000000oooo0?ooo`3o
ool0o`0000<0oooo00H0o`000?ooo`3oool0o`000?ooo`00000?0?ooo`d0003o6P3oool00`000000
oooo0?ooo`030?ooo`030?l0003oool0oooo00@0oooo00<000000?ooo`3oool0103ooolH0000o`04
0000003oool0oooo0?l000<0oooo00D0o`000?ooo`3oool0o`000?ooo`02000003/0oooo000l0?oo
o`050000003oool0oooo0?ooo`3o00000P3oool00`3o0000oooo0?ooo`020?ooo`030000003oool0
oooo00L0oooo2@000?l<0?ooo`030000003oool0o`000080oooo00T0o`000?ooo`3oool0oooo0?l0
003oool0o`000?ooo`0000004`3oool90000oaX0oooo00<000000?ooo`3oool00`3oool00`3o0000
oooo0?ooo`030?ooo`030000003oool0oooo00L0oooo3@000?l90?ooo`040000003oool0oooo0?l0
00@0oooo0P3o00030?ooo`030000003oool0oooo03T0oooo000l0?ooo`030000003oool0oooo0080
oooo00<0o`000?ooo`3o0000103oool00`000000oooo0?ooo`070?ooo`H0003o403oool010000000
oooo0?l0003o00050?ooo`80o`0000<0oooo0000003oool05@3oool60000oaX0oooo00<000000?oo
o`3oool00P3oool20?l000D0oooo00<000000?ooo`3oool02`3oool90000o`T0oooo00@000000?oo
o`3oool0o`000`3oool01P3o0000oooo0?ooo`3o0000oooo000003`0oooo000l0?ooo`030000003o
ool0oooo00<0oooo0P3o00030?ooo`030000003oool0oooo00P0oooo0P000?lD0?ooo`030000003o
ool0oooo00P0oooo00<000000?ooo`3oool06@3oool20000oa/0oooo00<000000?ooo`3oool01`3o
ool00`000000oooo0?ooo`0?0?ooo`H0003o2@3oool010000000oooo0?l0003o00040?ooo`80o`00
0P3oool00`000000oooo0?ooo`0j0?ooo`00?03oool00`000?l000000?ooo`070?ooo`030000003o
ool0oooo01l0oooo00<0003o0000003oool01`3oool00`000000oooo0?ooo`0h0?ooo`030000003o
ool0oooo00H0oooo00<000000000o`3oool04`3oool20000o`T0oooo00<000000?ooo`3oool0203o
ool00`000000oooo0?ooo`0k0?ooo`00>`3oool010000?l0oooo0?ooo`0000060?ooo`030000003o
ool0oooo01h0oooo0P000?l20?ooo`8000000`3oool3000003`0oooo0P0000030?ooo`<000000P3o
ool00`000?l0oooo0?ooo`0M0?ooo`030000003oool0oooo00L0oooo00<000000000o`000?l0>`3o
ool003T0oooo0P000?l40?ooo`H00000803oool00`000?l0oooo0?ooo`040?ooo`<00000@@3oool3
000000H0oooo0P000?lN0?ooo`<000001@3oool01@000000oooo0?ooo`3oool0003o03X0oooo000b
0?ooo`030000o`3oool0oooo00<0oooo00<0003o0?ooo`3oool01@3oool00`000?l0oooo0?ooo`0Q
0?ooo`030000o`3oool0oooo05@0oooo00<0003o0?ooo`3oool07P3oool5000000D0oooo00<0003o
0?ooo`3oool0=`3oool00340oooo0`000?l20?ooo`80003o203oool00`000?l0oooo0?ooo`0P0?oo
o`030000o`3oool0oooo05H0oooo00<0003o0?ooo`3oool0803oool00`000?l0oooo0?ooo`050?oo
o`80003o103oool00`000?l0oooo0?ooo`0`0?ooo`00<03oool40000o`030?ooo`000?l0oooo00T0
oooo00<0003o0?ooo`3oool07`3oool00`000?l0oooo0?ooo`1H0?ooo`030000o`3oool0oooo01l0
oooo00<0003o0?ooo`3oool01`3oool00`000?l0oooo0?ooo`030000oc40oooo000_0?ooo`H0003o
2`3oool00`000?l0oooo0?ooo`0M0?ooo`80003oG03oool00`000?l0oooo0?ooo`0N0?ooo`030000
o`3oool0oooo00P0oooo00<0003o0?ooo`000?l00`000?l`0?ooo`00;P3oool80000o`X0oooo00<0
003o0?ooo`3oool0703oool00`000?l0oooo0?ooo`1M0?ooo`80003o7P3oool00`000?l0oooo0?oo
o`090?ooo`D0003o<03oool002d0oooo2@000?l90?ooo`030000o`3oool0oooo01/0oooo0P000?mR
0?ooo`030000o`3oool0oooo01`0oooo00<0003o0?ooo`3oool01`3oool70000obl0oooo000]0?oo
o`X0003o203oool00`000?l0oooo0?ooo`0I0?ooo`<0003oI03oool20000oa`0oooo00<0003o0?oo
o`3oool01`3oool80000obh0oooo000/0?ooo`T0003o2@3oool20000oaT0oooo10000?mU0?ooo`@0
003o6P3oool00`000?l0oooo0?ooo`060?ooo`X0003o;@3oool002/0oooo1`000?l<0?ooo`80003o
5P3oool70000ofH0oooo1@000?lH0?ooo`80003o2@3oool90000ob`0oooo000Z0?ooo`H0003o3@3o
ool30000oa@0oooo20000?mX0?ooo`H0003o5P3oool20000o`/0oooo20000?l[0?ooo`00:@3oool4
0000oa00oooo0`000?lB0?ooo`T0003oJP3oool70000oa@0oooo0`000?l=0?ooo`D0003o:`3oool0
02P0oooo0P000?lB0?ooo`@0003o403oool:0000of/0oooo2@000?lB0?ooo`<0003o403oool30000
obX0oooo000W0?ooo`030000o`3oool0oooo0180oooo10000?lA0?ooo`T0003oK03oool90000oa40
oooo10000?lA0?ooo`80003o:@3oool001/0oooo1P0000040?ooo`80003o5@3oool50000oa40oooo
1`000?m^0?ooo`L0003o4P3oool40000oa<0oooo0P000?lW0?ooo`006@3oool2000000H0oooo00@0
00000?ooo`3oool0003o5P3oool60000oa40oooo1P000?m`0?ooo`D0003o4P3oool50000oaD0oooo
00<0003o0?ooo`3oool00`3oool6000001/0oooo000H0?ooo`030000003oool0oooo00L0oooo00<0
00000000o`3oool05P3oool60000oa40oooo1@000?ma0?ooo`H0003o4@3oool60000oaD0oooo00<0
003o0?ooo`3oool00P0000060?ooo`030000003oool0oooo01P0oooo000H0?ooo`030000003oool0
oooo00P0oooo00<000000?ooo`3oool0503oool70000o`l0oooo0P000?l20?ooo`<0003oLP3oool3
0000o`80oooo00<0003o0?ooo`3oool03P3oool60000oaH0oooo00<0003o0000003oool0203oool0
0`000000oooo0?ooo`0G0?ooo`00603oool010000000oooo0?ooo`3oool20?l000H0oooo00<00000
0?ooo`3oool04`3oool70000o`h0oooo00<0003o0?ooo`3oool00`3oool00`000?l0oooo0?ooo`1b
0?ooo`030000o`3oool0oooo0080oooo00<0003o0?ooo`3oool03@3oool70000oaD0oooo00<00000
0?ooo`3oool0203oool00`000000oooo0?ooo`0G0?ooo`005`3oool01@000000oooo0?ooo`3oool0
o`000080oooo00<0o`000?ooo`3oool00`3oool00`000000oooo0?ooo`0B0?ooo`P0003o3@3oool0
0`000?l0oooo0?ooo`1o0?ooo`80003o3@3oool70000oaD0oooo00<000000?l0003o00000P3o0002
0?ooo`<0o`000P3oool00`000000oooo0?ooo`0F0?ooo`005`3oool00`000000oooo0?ooo`040?oo
o`030?l0003oool0oooo00<0oooo00<000000?ooo`3oool04P3oool80000o``0oooo00<0003o0?oo
o`3oool0P@3oool20000o``0oooo20000?lD0?ooo`030000003o0000oooo00@0oooo00H0o`000?oo
o`3oool0o`000?ooo`00000H0?ooo`005`3oool00`000000oooo0?ooo`020?ooo`80o`001P3oool0
0`000000oooo0?ooo`0E0?ooo`D0003o2P3oool20000ohH0oooo00<0003o0?ooo`3oool02@3oool8
0000oa@0oooo00<000000?ooo`3o0000103oool0103o0000oooo0?ooo`3o00020?ooo`030000003o
ool0oooo01D0oooo000G0?ooo`030000003oool0oooo0080oooo00<0o`000?ooo`3oool0103oool0
0`000000oooo0?ooo`0F0?ooo`030000o`3oool0oooo00/0oooo00<0003o0?ooo`3oool0Q`3oool0
0`000?l0oooo0?ooo`080?ooo`D0003o5@3oool00`000?l0oooo000000020?ooo`040?l0003oool0
oooo0?ooo`<0o`000`3oool00`000000oooo0?ooo`0E0?ooo`00603oool010000000oooo0?ooo`3o
ool30?l000@0oooo00<000000?ooo`3oool05P3oool00`000?l0oooo0?ooo`0:0?ooo`030000o`3o
ool0oooo08T0oooo00<0003o0?ooo`3oool02`3oool00`000?l0oooo0?ooo`0B0?ooo`80003o00<0
oooo0000003o00000P3oool01@3o0000oooo0?ooo`3oool0o`0000<0oooo00<000000?ooo`3oool0
5P3oool001P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0000o`0F0?ooo`80003o2`3o
ool00`000?l0oooo0?ooo`2;0?ooo`80003o2`3oool00`000?l0oooo0?ooo`0A0?ooo`@0003o00@0
00000?ooo`3o0000o`00103oool30?l000030?ooo`000000oooo01L0oooo000I0?ooo`030000003o
ool0oooo00H0oooo00<000000?ooo`3oool00`000?lC0?ooo`030000o`3oool0oooo00P0oooo0P00
0?n?0?ooo`80003o2P3oool20000oa40oooo1@000?l00`000000oooo0?ooo`080?ooo`030000003o
ool0oooo01L0oooo000J0?ooo`8000000`3oool3000000D0oooo1@000?l?0?ooo`030000o`3oool0
oooo00L0oooo00<0003o0?ooo`3oool0T@3oool00`000?l0oooo0?ooo`080?ooo`030000o`3oool0
oooo00h0oooo1`000?l2000000P0oooo00<000000?ooo`3oool05`3oool001`0oooo0`0000090?oo
o`L0003o303oool00`000?l0oooo0?ooo`060?ooo`030000o`3oool0oooo09<0oooo00<0003o0?oo
o`3oool01`3oool00`000?l0oooo0?ooo`0<0?ooo`T0003o0P3oool2000000<0oooo0`00000J0?oo
o`00703oool00`000?l0oooo0?ooo`0:0?ooo`X0003o203oool00`000?l0oooo0?ooo`050?ooo`03
0000o`3oool0oooo09D0oooo00<0003o0?ooo`3oool01P3oool00`000?l0oooo0?ooo`0;0?ooo`/0
003o0`3oool3000001d0oooo000L0?ooo`030000o`3oool0oooo00/0oooo2`000?l50?ooo`030000
o`3oool0oooo00D0oooo00<0003o0?ooo`3oool0U`3oool20000o`H0oooo00<0003o0?ooo`3oool0
2P3oool:0000o`L0oooo00<0003o0?ooo`3oool06`3oool001`0oooo00<0003o0?ooo`3oool0303o
ool90000o`<0oooo1P0000030?ooo`80003oV`3oool20000o`H0oooo0P0000090?ooo`L0003o2`3o
ool00`000?l0oooo0?ooo`0K0?ooo`00703oool00`000?l0oooo0?ooo`0=0?ooo`P0003o00<0oooo
0000000000001P3oool00`000000oooo0000o`2O0?ooo`040000o`3oool0oooo0?ooo`8000000P3o
ool2000000H0oooo1@000?l>0?ooo`030000o`3oool0oooo01/0oooo000K0?ooo`80003o403oool6
0000o`030?ooo`000000oooo00P0oooo00<000000?ooo`3oool0W`3oool00`000?l0000000000006
0?ooo`8000000`3oool20000oa80oooo00<0003o0?ooo`3oool06`3oool001/0oooo0P000?lA0?oo
o`@0003o00<0oooo0000003oool02@3oool00`000000oooo0?ooo`2O0?ooo`030000003oool0oooo
00P0oooo00<000000000o`000?l05@3oool00`000?l0oooo0?ooo`0J0?ooo`006`3oool00`000?l0
oooo0?ooo`0A0?ooo`<0003o00<0oooo0000003o00000`3o00030?ooo`80o`000P3oool00`000000
oooo0?ooo`2N0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool05@3oool00`000?l0
oooo0?ooo`0J0?ooo`006`3oool00`000?l0oooo0?ooo`0B0?ooo`050000o`3oool0oooo0000003o
00001@3oool01P3o0000oooo0?ooo`3o0000oooo00000:00oooo00<000000?l0003o00000`3o0003
0?ooo`040?l0003oool0oooo000001H0oooo00<0003o0?ooo`3oool06P3oool001P0oooo10000?lG
0?ooo`030000003oool0o`0000H0oooo00D0o`000?ooo`3oool0oooo0000002N0?ooo`050000003o
ool0oooo0?ooo`3o00001@3oool0103o0000oooo0?ooo`00000F0?ooo`030000o`3oool0oooo01X0
oooo000H0?ooo`P0003o4`3oool010000000oooo0?ooo`3o00060?ooo`040?l0003oool0oooo0000
09h0oooo00D000000?ooo`3oool0oooo0?l000050?ooo`040?l0003oool0oooo000001H0oooo0P00
0?lK0?ooo`00603oool80000oa<0oooo00D000000?l0003oool0oooo0?l000020?ooo`060?l0003o
ool0oooo0?l0003oool00000W`3oool01@000000oooo0?ooo`3oool0o`0000H0oooo00<0o`000?oo
o`0000005P3oool20000oa/0oooo000H0?ooo`L0003o503oool010000000oooo0?l0003o00040?oo
o`80o`000P3oool00`000000oooo0?ooo`2M0?ooo`050000003oool0oooo0?ooo`3o00000`3oool0
1P3o0000oooo0?ooo`3o0000oooo000001D0oooo10000?lJ0?ooo`00603oool70000oaD0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`2O0?ooo`040000003oool0o`000?l000<0oooo
103o00000`3oool000000?ooo`0D0?ooo`@0003o6P3oool001P0oooo1P000?lE0?ooo`030000o`00
0000oooo00L0oooo0P00002R0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0503o
ool40000oaX0oooo000H0?ooo`H0003o503oool00`000?l0oooo0?ooo`03000000<0oooo0P00002U
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`000?l05@3oool50000oaT0oooo000H0?oo
o`D0003o503oool00`000?l0oooo0?ooo`040?ooo`<00000Z03oool7000000<0oooo00<0003o0?oo
o`3oool04P3oool50000oaT0oooo000I0?ooo`@0003o4P3oool20000o`L0oooo00<0003o0?ooo`3o
ool0[03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo0140oooo1@000?lI0?ooo`00
6@3oool40000oa40oooo0P000?l70?ooo`030000o`3oool0oooo0:d0oooo00<0003o0?ooo`3oool0
1@3oool20000oa40oooo1P000?lH0?ooo`006@3oool30000oa00oooo0`000?l80?ooo`030000o`3o
ool0oooo0:d0oooo00<0003o0?ooo`3oool01@3oool30000o`l0oooo1`000?lH0?ooo`006@3oool3
0000o`h0oooo10000?l90?ooo`030000o`3oool0oooo0:h0oooo00<0003o0?ooo`3oool01@3oool3
0000o`h0oooo20000?lG0?ooo`006@3oool20000o`d0oooo1P000?l90?ooo`030000o`3oool0oooo
0:h0oooo00<0003o0?ooo`3oool01@3oool50000o``0oooo20000?lG0?ooo`006@3oool20000o`/0
oooo1`000?l:0?ooo`030000o`3oool0oooo0:h0oooo00<0003o0?ooo`3oool01P3oool70000o`T0
oooo1@000?lJ0?ooo`006@3oool20000o`T0oooo20000?l:0?ooo`030000o`3oool0oooo0:l0oooo
00<0003o0?ooo`3oool01`3oool80000o`/0oooo00<0003o0?ooo`3oool0603oool001T0oooo00<0
003o0?ooo`3oool01P3oool90000o`/0oooo00<0003o0?ooo`3oool0[`3oool00`000?l0oooo0?oo
o`080?ooo`T0003o2@3oool00`000?l0oooo0?ooo`0H0?ooo`006@3oool00`000?l0oooo0?ooo`07
0?ooo`P0003o2`3oool00`000?l0oooo0?ooo`2_0?ooo`030000o`3oool0oooo00P0oooo2`000?l7
0?ooo`030000o`3oool0oooo01P0oooo000I0?ooo`030000o`3oool0oooo00L0oooo1`000?l<0?oo
o`030000o`3oool0oooo0;00oooo00<0003o0?ooo`3oool0203oool90000o`P0oooo00<0003o0?oo
o`3oool0603oool001T0oooo00<0003o0?ooo`3oool0203oool50000o`d0oooo00<0003o0?ooo`3o
ool0/03oool00`000?l0oooo0?ooo`090?ooo`L0003o2@3oool20000oaT0oooo000I0?ooo`030000
o`3oool0oooo00L0oooo00<0003o0?ooo`000?l00P000?l>0?ooo`030000o`3oool0oooo0;00oooo
00<0003o0?ooo`3oool02P3oool60000o`X0oooo00<0003o0?ooo`3oool05`3oool001T0oooo00<0
003o0?ooo`3oool01@3oool20000o`80oooo0`000?l=0?ooo`030000o`3oool0oooo0;40oooo00<0
003o0?ooo`3oool02P3oool70000o`T0oooo00<0003o0?ooo`3oool05`3oool001T0oooo00<0003o
0?ooo`3oool0103oool20000o`@0oooo00<0003o0?ooo`3oool0303oool00`000?l0oooo0?ooo`2a
0?ooo`030000o`3oool0oooo00/0oooo0`000?l30?ooo`80003o1`3oool00`000?l0oooo0?ooo`0G
0?ooo`005P3oool4000000D0oooo00<0003o0?ooo`3oool04P3oool20000ok<0oooo00<0003o0?oo
o`3oool0303oool00`000?l0oooo0?ooo`030?ooo`80003o1P3oool00`000?l0oooo0?ooo`0G0?oo
o`00503oool2000000@0oooo0P0000020?ooo`030000o`3oool0oooo01<0oooo0P000?nc0?ooo`80
003o503oool20000o`@0oooo1000000G0?ooo`004`3oool00`000000oooo0?ooo`060?ooo`800000
5@3oool30000ok<0oooo0P000?lF0?ooo`040000o`3oool00000000000@0oooo0P00000E0?ooo`00
4P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo01<0oooo0`000?nc0?ooo`<0003o
5P3oool00`000000oooo0?ooo`060?ooo`8000004`3oool00180oooo00@000000?ooo`3oool0oooo
0`3o00050?ooo`030000003oool0oooo0140oooo10000?nc0?ooo`<0003o5@3oool00`000000oooo
0?ooo`080?ooo`030000003oool0oooo0140oooo000A0?ooo`030000003oool0oooo0080oooo00@0
o`000?ooo`3oool0o`00103oool00`000000oooo0?ooo`0A0?ooo`@0003o/`3oool40000oa@0oooo
00<000000?l0003o00000`3o0000103oool0o`000?l0003o00020?ooo`030000003oool0oooo0100
oooo000A0?ooo`030000003oool0oooo0080oooo00@0o`000?ooo`3oool0o`00103oool00`000000
oooo0?ooo`0A0?ooo`D0003o/P3oool40000oa<0oooo00D000000?ooo`3oool0oooo0?l000030?oo
o`060?l0003oool0oooo0?l0003oool000004P3oool00140oooo00<000000?ooo`3oool00P3oool3
0?l000D0oooo00<000000?ooo`3oool0403oool60000ok40oooo1P000?lB0?ooo`050000003oool0
oooo0?ooo`3o00000`3oool01P3o0000oooo0?ooo`3o0000oooo00000180oooo000A0?ooo`030000
003oool0oooo00<0oooo00<0o`000?ooo`3oool0103oool00`000000oooo0?ooo`0@0?ooo`H0003o
/@3oool60000oa80oooo00D000000?ooo`3oool0oooo0?l000030?ooo`<0o`000P3oool00`000000
oooo0?ooo`0@0?ooo`004@3oool00`000000oooo0?ooo`030?ooo`<0o`00103oool00`000000oooo
0?ooo`0?0?ooo`L0003o/@3oool70000oa80oooo00@000000?ooo`3oool0o`00103oool01@3o0000
oooo0?ooo`3oool000000180oooo000B0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3o
ool0403oool70000ok40oooo1`000?lB0?ooo`040000003oool0o`000?l000@0oooo0`3o00000`3o
ool000000?ooo`0A0?ooo`004`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0100
oooo20000?na0?ooo`P0003o4@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo0140
oooo000D0?ooo`8000000`3oool3000001<0oooo20000?na0?ooo`P0003o4P3oool00`000000oooo
0?ooo`060?ooo`030000003oool0oooo0180oooo000F0?ooo`<000000`3oool00`000?l0oooo0?oo
o`0C0?ooo`D0003o/@3oool60000oaD0oooo0`0000040?ooo`030000003oool0oooo01<0oooo000F
0?ooo`030000o`3oool0oooo00<0oooo00<0003o0?ooo`3oool04`3oool00`000?l0oooo0?ooo`2c
0?ooo`80003o0P3oool00`000?l0oooo0?ooo`0D0?ooo`030000o`3oool0oooo00@000005P3oool0
01H0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`0B0?ooo`030000o`3oool0oooo
0;L0oooo00<0003o0?ooo`3oool04`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo
01@0oooo000E0?ooo`030000o`3oool0oooo00D0oooo0P000?lC0?ooo`030000o`3oool0oooo0;L0
oooo00<0003o0?ooo`3oool04`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo01@0
oooo000E0?ooo`030000o`3oool0oooo00H0oooo00<0003o0?ooo`3oool04@3oool00`000?l0oooo
0?ooo`2g0?ooo`030000o`3oool0oooo0180oooo00<0003o0?ooo`3oool01@3oool00`000?l0oooo
0?ooo`0D0?ooo`005@3oool00`000?l0oooo0?ooo`060?ooo`80003o4P3oool00`000?l0oooo0?oo
o`2g0?ooo`030000o`3oool0oooo0180oooo00<0003o0?ooo`3oool01@3oool00`000?l0oooo0?oo
o`0D0?ooo`005@3oool00`000?l0oooo0?ooo`070?ooo`030000o`3oool0oooo0080003o3@3oool2
0000okT0oooo0P000?lB0?ooo`030000o`3oool0oooo00L0oooo00<0003o0?ooo`3oool04`3oool0
01@0oooo00<0003o0?ooo`3oool0203oool50000o`d0oooo00<0003o0?ooo`3oool0^@3oool00`00
0?l0oooo0?ooo`0?0?ooo`80003o2@3oool00`000?l0oooo0?ooo`0C0?ooo`004`3oool20000o`T0
oooo1P000?l=0?ooo`030000o`3oool0oooo0;T0oooo00<0003o0?ooo`3oool03P3oool20000o`X0
oooo00<0003o0?ooo`3oool04`3oool001<0oooo0P000?l70?ooo`T0003o303oool00`000?l0oooo
0?ooo`2i0?ooo`030000o`3oool0oooo00d0oooo0`000?l:0?ooo`030000o`3oool0oooo01<0oooo
000B0?ooo`<0003o203oool80000o``0oooo00<0003o0?ooo`3oool0^@3oool00`000?l0oooo0?oo
o`0<0?ooo`@0003o2`3oool010000?l0oooo0000o`000?lA0?ooo`004P3oool30000o`T0oooo1`00
0?l;0?ooo`80003o^`3oool00`000?l0oooo0?ooo`0;0?ooo`D0003o2@3oool60000oa40oooo000A
0?ooo`@0003o2P3oool60000o`/0oooo00<0003o0?ooo`3oool0^`3oool00`000?l0oooo0?ooo`09
0?ooo`D0003o203oool80000oa40oooo000A0?ooo`@0003o2`3oool50000o`/0oooo00<0003o0?oo
o`3oool0^`3oool00`000?l0oooo0?ooo`080?ooo`H0003o2@3oool70000oa40oooo000@0?ooo`D0
003o303oool50000o`X0oooo00<0003o0?ooo`3oool0^`3oool00`000?l0oooo0?ooo`070?ooo`L0
003o2@3oool70000oa40oooo000@0?ooo`D0003o303oool50000o`X0oooo00<0003o0?ooo`3oool0
^`3oool00`000?l0oooo0?ooo`060?ooo`L0003o2`3oool60000oa40oooo000?0?ooo`H0003o3@3o
ool40000o`X0oooo00<0003o0?ooo`3oool0^`3oool00`000?l0oooo0?ooo`050?ooo`P0003o2`3o
ool60000oa40oooo000?0?ooo`H0003o3P3oool30000o`T0oooo0P000?nm0?ooo`030000o`3oool0
oooo00H0oooo1`000?l<0?ooo`D0003o4@3oool000h0oooo1`000?l?0?ooo`<0003o203oool00`00
0?l0oooo0?ooo`2m0?ooo`030000o`3oool0oooo00L0oooo1@000?l<0?ooo`D0003o4@3oool000h0
oooo1`000?l@0?ooo`80003o203oool00`000?l0oooo0?ooo`2m0?ooo`030000o`3oool0oooo00H0
oooo1@000?l>0?ooo`@0003o4@3oool000d0oooo20000?lA0?ooo`80003o1`3oool00`000?l0oooo
0?ooo`2m0?ooo`030000o`3oool0oooo00H0oooo00D0003o0?ooo`3oool0oooo0000o`0>0?ooo`@0
003o4@3oool00140oooo10000?lB0?ooo`030000o`3oool0oooo00D0oooo00<0003o0?ooo`3oool0
_@3oool00`000?l0oooo0?ooo`050?ooo`030000o`3oool0oooo0180oooo0`000?lA0?ooo`00403o
ool20000oaH0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`2m0?ooo`030000o`3o
ool0oooo00D0oooo00<0003o0?ooo`3oool04P3oool30000oa40oooo000@0?ooo`030000o`3oool0
oooo01H0oooo00<0003o0?ooo`3oool00P3oool00`000?l0oooo0?ooo`2n0?ooo`030000o`3oool0
oooo00@0oooo00<0003o0?ooo`3oool0503oool20000oa40oooo000@0?ooo`030000o`3oool0oooo
01H0oooo00<0003o0?ooo`3oool00P3oool00`000?l0oooo0?ooo`2o0?ooo`030000o`3oool0oooo
00<0oooo00<0003o0?ooo`3oool0503oool20000oa40oooo000@0?ooo`030000o`3oool0oooo01L0
oooo00<0003o0000000000000P0000310?ooo`030000o`3oool0oooo0080oooo00<0003o0?ooo`3o
ool05P3oool00`000?l0oooo0?ooo`0?0?ooo`00403oool00`000?l0oooo0?ooo`0F0?ooo`800000
103oool200000;h0oooo1P00000I0?ooo`030000o`3oool0oooo00l0oooo000?0?ooo`030000o`3o
ool0oooo01H0oooo00<000000?ooo`3oool01P3oool200000;X0oooo0P0000060?ooo`030000003o
ool0oooo01H0oooo00<0003o0?ooo`3oool03`3oool000l0oooo00<0003o0?ooo`3oool05P3oool0
0`000000oooo0?ooo`070?ooo`030000003oool0oooo0;L0oooo00<000000?ooo`3oool01`3oool0
0`000000oooo0?ooo`0F0?ooo`030000o`3oool0oooo00h0oooo000?0?ooo`030000o`3oool0oooo
01D0oooo00<000000?ooo`3oool00`3oool00`3o0000oooo0?ooo`030?ooo`030000003oool0oooo
0;D0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0F0?ooo`030000o`3oool0oooo
00h0oooo000?0?ooo`030000o`3oool0oooo01@0oooo00<000000?ooo`3oool0103oool00`3o0000
oooo0?ooo`030?ooo`030000003oool0oooo0;D0oooo00<000000?l0003o00000`3o00020?ooo`80
o`000P3oool010000000oooo0?ooo`000?lD0?ooo`030000o`3oool0oooo00h0oooo000;0?ooo`@0
00005`3oool00`000000oooo0?ooo`040?ooo`030?l0003oool0oooo00<0oooo00<000000?ooo`3o
ool0]@3oool010000000oooo0?ooo`3o00030?ooo`060?l0003oool0oooo0?l0003oool000000P3o
ool30000oa80oooo00<0003o0?ooo`3oool03P3oool000X0oooo00<000000?ooo`3oool00P3oool2
000000<0oooo20000?l:0?ooo`030000003oool0oooo00D0oooo00<0o`000?ooo`3oool00P3oool0
0`000000oooo0?ooo`2e0?ooo`040000003oool0oooo0?l000H0oooo00D0o`000?ooo`3oool00000
0?ooo`050000oa00oooo1000000=0?ooo`002@3oool00`000000oooo0?ooo`050?ooo`80000000<0
oooo0000o`000?l040000?l00`3oool000000?ooo`020?ooo`040?l0003oool0oooo0?l000@0oooo
00<000000?ooo`3oool0]@3oool010000000oooo0?ooo`3o00040?ooo`80o`000`3oool00`000000
oooo0000o`060000o`d0oooo00<000000?ooo`3oool00P3oool2000000/0oooo00080?ooo`030000
003oool0oooo00L0oooo00<000000?ooo`3oool03@000?l50?ooo`040000003oool0oooo0?ooo`@0
o`00103oool00`000000oooo0?ooo`2e0?ooo`040000003oool0oooo0?l000@0oooo00D0o`000?oo
o`3oool0oooo0000000;0000o`X0oooo00<000000?ooo`3oool01@3oool2000000T0oooo00070?oo
o`030000003o0000o`000080o`000P3oool40?l000030?ooo`000000oooo00/0003o1`3oool00`00
0000oooo0?ooo`080?ooo`030000003oool0oooo0;H0oooo00@000000?ooo`3o0000o`00103oool3
0?l000030?ooo`000000oooo00`0003o1`3oool00`000000oooo0?ooo`070?ooo`030000003oool0
oooo00L0oooo00060?ooo`030000003oool0o`0000D0oooo00<0o`000?ooo`3oool00P3oool00`00
0000003o0000o`080000o`X0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`2h0?oo
o`030000003oool0oooo00L0oooo00<000000?ooo`3oool040000?l20?ooo`030000003o0000o`00
0080o`00103oool0103o0000oooo0?ooo`0000080?ooo`001P3oool010000000oooo0?ooo`3o0005
0?ooo`060?l0003oool0oooo0?ooo`000000oooo1`000?l=0?ooo`<000000`3oool200000;/0oooo
0P0000080?ooo`030000003oool0oooo0180003o00<000000?l0003oool01P3oool0103o0000oooo
0?ooo`0000080?ooo`001P3oool01@000000oooo0?ooo`3oool0o`0000D0oooo00@0o`000?ooo`3o
ool000000P3oool40000oa80oooo0`0000020?ooo`030000o`3oool0oooo0;T0oooo00<0003o0000
000000000`3oool3000001D0oooo00<000000?ooo`3o00001P3oool01@3o0000oooo0?ooo`3oool0
000000L0oooo00070?ooo`050000003o0000oooo0?ooo`3o00000P3oool01P3o0000oooo0?ooo`3o
0000oooo00000080oooo0P000?lD0?ooo`030000o`3oool0oooo00<0oooo00<0003o0?ooo`3oool0
^03oool00`000?l0oooo0?ooo`03000001P0oooo00@000000?ooo`3oool0o`001P3oool0103o0000
oooo0?ooo`0000070?ooo`001`3oool010000000oooo0?l0003o00040?ooo`80o`000P3oool00`00
0000oooo0?ooo`0E0?ooo`80003o1@3oool00`000?l0oooo0?ooo`2g0?ooo`030000o`3oool0oooo
00<0oooo00<0003o0?ooo`3oool05P3oool01@000000o`000?ooo`3oool0o`000080oooo00H0o`00
0?ooo`3oool0o`000?ooo`0000080?ooo`001`3oool00`000000oooo0?ooo`080?ooo`030000003o
ool0oooo01H0oooo00<0003o0?ooo`3oool01@3oool00`000?l0oooo0?ooo`2f0?ooo`030000o`3o
ool0oooo00<0oooo00<0003o0?ooo`3oool05P3oool010000000oooo0?l0003o00030?ooo`@0o`00
00<0oooo0000003oool01`3oool000P0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?oo
o`0G0?ooo`030000o`3oool0oooo00D0oooo00<0003o0?ooo`3oool0]@3oool00`000?l0oooo0?oo
o`050?ooo`030000o`3oool0oooo01D0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`070?ooo`002@3oool3000000<0oooo0P0000000`000?l0oooo0?ooo`0G0?ooo`030000o`3oool0
oooo00H0oooo00<0003o0?ooo`3oool0]03oool00`000?l0oooo0?ooo`050?ooo`030000o`3oool0
oooo01H0oooo00<000000?ooo`3oool01P3oool2000000T0oooo000<0?ooo`<000000`3oool00`00
0?l0oooo0?ooo`0F0?ooo`030000o`3oool0oooo00H0oooo00<0003o0?ooo`3oool0/`3oool00`00
0?l0oooo0?ooo`060?ooo`030000o`3oool0oooo01L0oooo0`0000030?ooo`8000002`3oool00180
oooo00<0003o0?ooo`3oool05P3oool00`000?l0oooo0?ooo`070?ooo`030000o`3oool0oooo0;40
oooo00<0003o0?ooo`3oool01`3oool00`000?l0oooo0?ooo`0F0?ooo`040000o`3oool0oooo0?oo
o`<000003@3oool001<0oooo00<0003o0?ooo`3oool0503oool20000o`X0oooo00<0003o0?ooo`3o
ool0/03oool00`000?l0oooo0?ooo`070?ooo`030000o`3oool0oooo01H0oooo00<0003o0?ooo`3o
ool04@3oool001@0oooo00<0003o0?ooo`3oool0403oool40000o`/0oooo00<0003o0?ooo`3oool0
[`3oool00`000?l0oooo0?ooo`080?ooo`80003o5P3oool00`000?l0oooo0?ooo`0B0?ooo`00503o
ool00`000?l0oooo0?ooo`0@0?ooo`P0003o203oool00`000?l0oooo0?ooo`2^0?ooo`030000o`3o
ool0oooo00P0oooo0P000?lE0?ooo`030000o`3oool0oooo01<0oooo000D0?ooo`80003o4@3oool8
0000o`P0oooo00<0003o0?ooo`3oool0[@3oool00`000?l0oooo0?ooo`090?ooo`<0003o503oool0
0`000?l0oooo0?ooo`0C0?ooo`005@3oool20000oa00oooo1`000?l90?ooo`80003o[@3oool20000
o`/0oooo0`000?lC0?ooo`80003o5@3oool001D0oooo0`000?l?0?ooo`L0003o2P3oool20000oj`0
oooo0P000?l;0?ooo`@0003o4@3oool20000oaH0oooo000E0?ooo`@0003o3P3oool60000o`/0oooo
0`000?nZ0?ooo`80003o303oool40000o`l0oooo10000?lF0?ooo`005P3oool50000o``0oooo1P00
0?l;0?ooo`@0003oZ03oool30000o`/0oooo1P000?l=0?ooo`@0003o5`3oool001H0oooo1P000?l;
0?ooo`D0003o303oool50000ojH0oooo10000?l;0?ooo`H0003o303oool50000oaL0oooo000F0?oo
o`L0003o2`3oool40000o`d0oooo10000?nT0?ooo`H0003o2`3oool70000o`X0oooo1@000?lH0?oo
o`005`3oool70000o`X0oooo0`000?l>0?ooo`D0003oXP3oool60000o``0oooo1`000?l90?ooo`H0
003o603oool001L0oooo20000?l90?ooo`<0003o3P3oool60000oj00oooo1`000?l<0?ooo`P0003o
1P3oool80000oaP0oooo000H0?ooo`P0003o203oool20000oa00oooo1P000?nN0?ooo`P0003o303o
ool80000o`D0oooo20000?lI0?ooo`00603oool70000o`T0oooo0P000?l@0?ooo`L0003oW03oool8
0000o`d0oooo1P000?l60?ooo`T0003o6@3oool001P0oooo1P000?l:0?ooo`030000o`3oool0oooo
00l0oooo20000?nJ0?ooo`T0003o3@3oool20000o`030?ooo`000?l0003o00P0oooo1`000?lJ0?oo
o`006@3oool30000o`030?ooo`000?l0oooo00T0oooo00<0003o0?ooo`3oool03`3oool70000oi`0
oooo20000?lA0?ooo`030000o`3oool0oooo00P0oooo1@000?lJ0?ooo`006@3oool00`000?l0oooo
0?ooo`020?ooo`030000o`3oool0oooo00L0oooo00<0003o0?ooo`3oool0403oool50000oil0oooo
1P000?lA0?ooo`030000o`3oool0oooo00P0oooo10000?lK0?ooo`007P3oool20000o`P0oooo00<0
003o0?ooo`3oool0403oool20000o`80oooo00<0003o0?ooo`3oool0W@3oool00`000?l0oooo0000
o`020000oa80oooo00<0003o0?ooo`3oool01`3oool01@000?l0oooo0?ooo`3oool0003o01/0oooo
000O0?ooo`030000o`3oool0oooo00H0oooo00<0003o0?ooo`3oool05@3oool00`000?l0oooo0?oo
o`2K0?ooo`80003o0`3oool00`000?l0oooo0?ooo`0@0?ooo`030000o`3oool0oooo00H0oooo0P00
0?lO0?ooo`00803oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo01H0oooo0P000?nL
0?ooo`030000o`3oool0oooo01D0oooo00<0003o0?ooo`3oool01P3oool00`000?l0oooo0?ooo`0N
0?ooo`00803oool20000o`D0oooo00<0003o0?ooo`3oool05`3oool00`000?l0oooo0?ooo`2I0?oo
o`030000o`3oool0oooo01H0oooo0P000?l60?ooo`030000o`3oool0oooo01l0oooo000Q0?ooo`03
0000o`3oool0oooo00<0oooo00<0003o0?ooo`3oool0603oool00`000?l0oooo0?ooo`2G0?ooo`80
003o6@3oool00`000?l0oooo0?ooo`030?ooo`80003o8@3oool00280oooo00<0003o000000000000
1@00000H0?ooo`030000o`3oool0oooo09L0oooo00<0003o0?ooo`3oool0603oool00`000?l00000
000000030?ooo`030000o`3oool0oooo0200oooo000Q0?ooo`8000001`3oool00`000000oooo0?oo
o`0F0?ooo`030000o`3oool0oooo09D0oooo0P000?lI0?ooo`8000000P3oool2000000030000o`3o
ool0oooo0240oooo000P0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool05@3oool0
0`000?l0oooo0?ooo`2E0?ooo`030000o`3oool0oooo01H0oooo0P0000060?ooo`030000003oool0
oooo0240oooo000P0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool05P3oool00`00
0?l0oooo0?ooo`2C0?ooo`030000o`3oool0oooo01H0oooo00<000000?ooo`3oool01`3oool00`00
0000oooo0?ooo`0P0?ooo`00803oool00`000000oooo0?ooo`020?ooo`80o`001@3oool00`000000
oooo0?ooo`0E0?ooo`80003oU03oool00`000?l0oooo0?ooo`0E0?ooo`030000003oool0oooo00P0
oooo00<000000?ooo`3oool0803oool001l0oooo00<000000?ooo`3oool00P3oool0103o0000oooo
0?ooo`3o00040?ooo`030000003oool0oooo01H0oooo00<0003o0?ooo`3oool0T@3oool00`000?l0
oooo0?ooo`0E0?ooo`030000003oool0o`0000@0o`000`3oool30?l000030000003oool0oooo01l0
oooo000O0?ooo`030000003oool0oooo0080oooo00@0o`000?ooo`3oool0o`00103oool00`000000
oooo0?ooo`0G0?ooo`030000o`3oool0oooo08l0oooo0P000?lG0?ooo`050000003oool0oooo0?oo
o`3o00001P3oool00`3o0000oooo0000000Q0?ooo`007`3oool00`000000oooo0?ooo`030?ooo`80
o`001@3oool00`000000oooo0?ooo`0G0?ooo`030000o`3oool0oooo08l0oooo00<0003o0?ooo`3o
ool05P3oool01@000000oooo0?ooo`3oool0o`0000<0oooo1@3o00000`000000oooo0?ooo`0O0?oo
o`00803oool01@000000oooo0?ooo`3oool0o`000080oooo00<0o`000?ooo`3oool00P3oool00`00
0000oooo0?ooo`0H0?ooo`030000o`3oool0oooo08d0oooo00<0003o0?ooo`3oool0603oool01000
0000oooo0?ooo`3o00030?ooo`060?l0003oool0oooo0?l0003oool000008@3oool00200oooo00<0
00000?ooo`3oool00P3oool20?l000D0oooo00<000000000o`000?l01`3oool00`000?l0oooo0?oo
o`0>0?ooo`80003oSP3oool00`000?l0oooo0?ooo`0H0?ooo`040000003oool0oooo0?l000@0oooo
00D0o`000?ooo`3o0000oooo0000000Q0?ooo`008@3oool00`000000oooo0?ooo`070?ooo`040000
003oool0oooo0?ooo`<0003o103oool30000o`l0oooo00<0003o0?ooo`3oool0R`3oool00`000?l0
oooo0?ooo`0F0?ooo`<0003o00@000000?ooo`3o0000o`001@3oool20?l000030000003oool0oooo
0200oooo000R0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool80000o`l0
oooo00<0003o0?ooo`3oool0R@3oool20000oa80oooo1P000?l40?ooo`030000003oool0oooo00H0
oooo00<000000?ooo`3oool08@3oool002<0oooo0P0000030?ooo`8000002P3oool80000o`d0oooo
00<0003o0?ooo`3oool0R@3oool00`000?l0oooo0?ooo`090?ooo`/0003o203oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo0280oooo000U0?ooo`<0000000<0oooo0000o`3oool02P3o
ool80000o`d0oooo00<0003o0?ooo`3oool0Q`3oool00`000?l0oooo0?ooo`060?ooo`d0003o2`3o
ool6000002D0oooo000Z0?ooo`030000o`3oool0oooo00L0oooo2`000?l;0?ooo`030000o`3oool0
oooo08L0oooo00<0003o0?ooo`3oool01P3oool<0000o`/0oooo00<0003o0?ooo`3oool0:@3oool0
02X0oooo00<0003o0?ooo`3oool01`3oool<0000o`/0oooo00@0003o0?ooo`3oool0oooo0P000022
0?ooo`030000o`3oool0oooo00P0oooo2@000?l=0?ooo`030000o`3oool0oooo02T0oooo000[0?oo
o`030000o`3oool0oooo00X0oooo2P000?l90?ooo`040000o`000000000000000080oooo0P00001i
0?ooo`L0000000<0003o0?ooo`3oool0203oool80000o`d0oooo00<0003o0?ooo`3oool0:P3oool0
02/0oooo00<0003o0?ooo`3oool04@3oool50000o`H0oooo0P0000070?ooo`030000003oool0oooo
07@0oooo0P0000070?ooo`030000003oool0oooo00D0oooo2P000?l>0?ooo`030000o`3oool0oooo
02X0oooo000/0?ooo`030000o`3oool0oooo01D0oooo0`000?l20?ooo`030000003oool0oooo00P0
oooo00<000000?ooo`3oool0LP3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo0080
oooo0`000?l20?ooo`D0003o3`3oool00`000?l0oooo0?ooo`0[0?ooo`00;03oool20000oaT0oooo
0P000?l00`000000oooo0?ooo`080?ooo`030000003oool0oooo0780oooo00<000000?ooo`3oool0
203oool00`000000oooo0000o`020000o`H0oooo0`000?l@0?ooo`030000o`3oool0oooo02/0oooo
000/0?ooo`<0003o6P3oool010000000oooo0?ooo`3oool30?l000D0oooo00<000000?ooo`3oool0
L@3oool00`000000o`000?l000030?l00080oooo0P3o00020?ooo`030000003oool0oooo00L0oooo
00<0003o0?ooo`3oool02`3oool01@000?l0oooo0?ooo`3oool0003o02h0oooo000]0?ooo`80003o
6@3oool00`000000oooo0?ooo`040?ooo`030?l0003oool0oooo00<0oooo00<000000?ooo`3oool0
L03oool01@000000oooo0?ooo`3oool0o`0000<0oooo00H0o`000?ooo`3oool0o`000?ooo`00000G
0?ooo`<0003o00<0oooo0000o`3oool0;@3oool002d0oooo0`000?lH0?ooo`030000003oool0oooo
00<0oooo0`3o00040?ooo`030000003oool0oooo0700oooo00D000000?ooo`3oool0oooo0?l00005
0?ooo`040?l0003oool0oooo000001L0oooo10000?l_0?ooo`00;@3oool40000oaL0oooo00<00000
0?ooo`3oool00P3oool0103o0000oooo0?ooo`3o00040?ooo`030000003oool0oooo0700oooo00D0
00000?ooo`3oool0oooo0?l000060?ooo`030?l0003oool0000001H0oooo1`000?l]0?ooo`00;@3o
ool50000oaL0oooo00D000000?ooo`3oool0oooo0?l000020?ooo`030?l0003oool0oooo0080oooo
00<000000?ooo`3oool0L03oool01@000?l000000?ooo`3oool0o`0000<0oooo00H0o`000?ooo`3o
ool0o`000?ooo`00000F0?ooo`P0003o;03oool002d0oooo1P000?lF0?ooo`030000003oool0oooo
0080oooo0`3o00030?ooo`030000003oool0003o0080003oK@3oool30000o`040000003oool0o`00
0?l000@0oooo0P3o00020?ooo`030000003oool0oooo01@0oooo1`000?l]0?ooo`00;P3oool60000
oaH0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`020?ooo`<0003oI`3oool30000
o`<0oooo00<000000?ooo`3oool0203oool010000000oooo0?ooo`000?lD0?ooo`H0003o;P3oool0
02h0oooo1P000?lG0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01P3oool30000
of40oooo0`000?l70?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool00P000?lD0?oo
o`H0003o;P3oool002h0oooo1`000?lE0?ooo`030000o`3oool0000000H0000000<0003o0?ooo`3o
ool02@3oool30000oe/0oooo0`000?l;0?ooo`<000000`3oool2000000030?ooo`000?l0003o00<0
003o4P3oool60000obl0oooo000^0?ooo`P0003o4P3oool20000o`T0oooo00<0003o0?ooo`3oool0
303oool40000oe@0oooo0`000?l>0?ooo`030000o`3oool0oooo00<000000P3oool60000oa80oooo
1@000?l`0?ooo`00;P3oool70000oa80oooo0P000?l;0?ooo`030000o`3oool0oooo00`0oooo2`00
0?m00?ooo`030000o`3oool0oooo00L0oooo0`000?l?0?ooo`030000o`3oool0oooo00D0oooo2000
0?lA0?ooo`@0003o<@3oool002l0oooo10000?lB0?ooo`<0003o303oool00`000?l0oooo0?ooo`0>
0?ooo`d0003o>P3oool30000o`H0oooo0`000?lB0?ooo`030000o`3oool0oooo00@0oooo2@000?lA
0?ooo`<0003o<P3oool002l0oooo0`000?l00`3oool0003o0?ooo`0?0?ooo`@0003o3@3oool00`00
0?l0oooo0?ooo`0>0?ooo`/0003o>P3oool50000o`80oooo0`000?lD0?ooo`030000o`3oool0oooo
00H0oooo2@000?l@0?ooo`80003o<`3oool002l0oooo00D0003o0?ooo`3oool0oooo0000o`0?0?oo
o`@0003o3P3oool20000oa40oooo2@000?lh0?ooo`T0003o5P3oool00`000?l0oooo0?ooo`090?oo
o`L0003o3`3oool30000oc<0oooo000d0?ooo`030000o`3oool0oooo00X0oooo1P000?l?0?ooo`05
0000o`3oool0oooo0?ooo`000?l03P3oool90000ocH0oooo2@000?lG0?ooo`030000o`3oool0oooo
00X0oooo1`000?l>0?ooo`80003o=03oool003@0oooo00<0003o0?ooo`3oool02@3oool60000oa00
oooo1@000?l@0?ooo`D0003o0P3oool30000oc40oooo2`000?lF0?ooo`80003o3P3oool50000o`h0
oooo00<0003o0?ooo`3oool0<`3oool003D0oooo00<0003o0?ooo`3oool01`3oool70000oa40oooo
1@000?l@0?ooo`<0003o1P3oool30000obd0oooo3@000?lD0?ooo`80003o403oool50000o``0oooo
00<0003o0?ooo`3oool0=03oool003D0oooo00<0003o0?ooo`3oool01@3oool80000oa00oooo1`00
0?lB0?ooo`030000o`3oool0oooo00L0oooo0`000?lX0?ooo`l0003o4`3oool30000oa80oooo0`00
0?l<0?ooo`030000o`3oool0oooo03@0oooo000f0?ooo`030000o`3oool0oooo00<0oooo2@000?l?
0?ooo`P0003o7P3oool30000obD0oooo20000?lJ0?ooo`@0003o4`3oool30000o`X0oooo00<0003o
0?ooo`3oool0=@3oool003H0oooo00<0003o0?ooo`3oool0103oool70000oa40oooo1`000?lQ0?oo
o`<0003o303oool7000000`0oooo0`000?lQ0?ooo`D0003o5@3oool00`000?l0oooo0?ooo`080?oo
o`030000o`3oool0oooo03D0oooo000g0?ooo`030000o`0000000000008000000`3oool50000oa80
oooo1`000?lS0?ooo`<0003o1`3oool2000000L0oooo00<000000?ooo`3oool01P3oool30000ob<0
oooo1@000?lG0?ooo`030000o`3oool0oooo0080oooo0P0000020?ooo`030000o`3oool0oooo03H0
oooo000f0?ooo`800000103oool2000000030000o`3oool0003o0080003o503oool60000obH0oooo
0`000?l30?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool00P3oool30000obD0oooo
1P000?lH0?ooo`040000o`3oool0000000000080oooo0P0000000`000?l0oooo0?ooo`0f0?ooo`00
=@3oool00`000000oooo0?ooo`060?ooo`8000000P3oool00`000?l0oooo0?ooo`0C0?ooo`D0003o
:@3oool30000o`030000003oool0oooo00P0oooo00<000000?ooo`000?l00P000?lW0?ooo`L0003o
603oool2000000H0oooo0P00000g0?ooo`00=03oool00`000000oooo0?ooo`080?ooo`030000003o
ool0oooo01L0oooo1@000?lZ0?ooo`030000o`000000o`0000<0o`000`3oool20?l00080oooo00<0
00000?ooo`3oool09`3oool70000oaP0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`0d0?ooo`00=03oool00`000000o`000?l000020?l00080oooo1@3o00000`000000oooo0?ooo`0G
0?ooo`@0003o:P3oool00`000000oooo0?l000050?ooo`060?l0003oool0oooo0?l0003oool00000
:03oool80000oaP0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0d0?ooo`00<`3o
ool00`000000oooo0?l000070?ooo`040?l0003oool0oooo000001X0oooo0`000?lZ0?ooo`040000
003oool0oooo0?l000@0oooo00H0o`000?ooo`3oool0o`000?ooo`00000Y0?ooo`L0003o603oool0
0`000000o`000?l000030?l000040?ooo`3o0000o`000?l00080oooo00<000000?ooo`3oool0<`3o
ool003<0oooo00@000000?ooo`3oool0o`001P3oool0103o0000oooo0?ooo`00000K0?ooo`80003o
:P3oool01@000000oooo0?ooo`3oool0o`0000<0oooo00H0o`000?ooo`3oool0o`000?ooo`00000Z
0?ooo`H0003o5`3oool01@000000oooo0?ooo`3oool0o`0000D0oooo00@0o`000?ooo`3oool00000
=@3oool003<0oooo00D000000?ooo`3oool0oooo0?l000050?ooo`040?l0003oool0oooo000001`0
oooo0P000?lO0?ooo`030000o`3oool0oooo00L0oooo00<0003o0000003o00000P3oool0103o0000
oooo0?ooo`3o00020?ooo`030?l0003oool0000002X0oooo00<0003o0?ooo`000?l00P000?lH0?oo
o`050000003oool0oooo0?ooo`3o0000103oool30?l000030?ooo`000000oooo03@0oooo000d0?oo
o`050000003o0000oooo0?ooo`3o0000103oool0103o0000oooo0?ooo`0000020000oa/0oooo00<0
003o0?ooo`3oool06`3oool30000o`H0oooo0`000?l00`3oool000000?ooo`020?l000@0oooo0P3o
00020?ooo`04000000000?l0003o0000obH0oooo00<0003o0?ooo`3oool00P3oool00`000?l0oooo
0?ooo`0;0?ooo`030000o`3oool0oooo00P0oooo00D000000?ooo`3oool0oooo0?l000030?ooo`06
0?l0003oool0oooo0?l0003oool00000=@3oool003@0oooo00@000000?ooo`3o0000o`00103oool2
0?l00080oooo00<000000?ooo`3oool00`000?lI0?ooo`030000o`3oool0oooo01T0oooo1@000?l2
0?ooo`<0003o103oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo0080oooo0`000?lS
0?ooo`030000o`3oool0oooo00h0oooo0`000?l90?ooo`030000o`000000oooo0080oooo00D0o`00
0?ooo`3oool0oooo0?l000020?ooo`030?l0003oool0000003D0oooo000d0?ooo`030000003oool0
oooo00P0oooo00<000000?ooo`3oool0103oool90000oa40oooo00<0003o0?ooo`3oool05P3oool9
0000o`P0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`050?ooo`P0003o6`3oool0
0`000?l0oooo0?ooo`0=0?ooo`H0003o103oool40000o`80oooo00@000000?ooo`3o0000o`00103o
ool30?l000030000003oool0oooo03@0oooo000e0?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool01`3oool?0000o`T0oooo00<0003o0?ooo`3oool05@3oool80000o`/0oooo0`000003
0?ooo`8000002@3oool?0000oa80oooo0P000?l>0?ooo`L0003o00<0oooo0000o`000?l00P000?l6
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0=03oool003H0oooo0`0000030?oo
o`800000303oool=0000o`X0oooo00<0003o0?ooo`3oool04P3oool:0000o`h0oooo0`00000=0?oo
o`d0003o4P3oool00`000?l0oooo0?ooo`0;0?ooo`X0003o2`3oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo03D0oooo000i0?ooo`<000003`3oool;0000o`/0oooo00<0003o0?ooo`00
00000`00000>0?ooo``0003o3P3oool00`000?l0oooo0?ooo`0>0?ooo`X0003o3P3oool200000080
oooo00<0003o0?ooo`3oool02`3oool:0000o`d0oooo1`00000h0?ooo`00C@3oool:0000o`/0oooo
00<000000?ooo`3oool00P3oool2000000X0oooo3P000?l>0?ooo`030000o`3oool0oooo00l0oooo
2@000?l<0?ooo`8000000P3oool2000000030000o`3oool0oooo00T0oooo3@000?m;0?ooo`00CP3o
ool70000o`030?ooo`000?l0003o0080003o1`3oool00`000000oooo0?ooo`050?ooo`8000001@3o
ool:0000oaD0oooo00<0003o0?ooo`3oool04@3oool90000o`P0oooo0P0000060?ooo`800000203o
ool?0000od/0oooo001@0?ooo`D0003o1@3oool30000o`<0oooo00<000000?ooo`3oool01`3oool0
0`000000oooo0?ooo`030000oal0oooo00<0003o0?ooo`3oool04P3oool60000o`030?ooo`000?l0
003o0080003o103oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00@0oooo2@000?mC
0?ooo`00D@3oool30000o`T0oooo0P000?l00`000000o`000?l000030?l00080oooo0P3o00020?oo
o`03000000000?l0oooo0200oooo0P000?lF0?ooo`<0003o1@3oool40000o`030000003oool0oooo
00T0oooo00<000000?ooo`3oool00`000?mL0?ooo`00D`3oool00`000?l0oooo0?ooo`080?ooo`05
0000003oool0oooo0?ooo`3o00000`3oool01P3o0000oooo0?ooo`3o0000oooo00000280oooo0`00
0?lG0?ooo`030000o`3oool0oooo00H0oooo00<0003o0000003o0000103o00000`3oool0o`000?l0
00020?l000040?ooo`000000003o0000oel0oooo001N0?ooo`050000003oool0oooo0?ooo`3o0000
0`3oool01@3o0000oooo0?ooo`3o0000oooo008000008@3oool30000ob40oooo00@000000?ooo`3o
ool0o`000`3oool00`3o0000oooo0?ooo`020?ooo`030000003oool0oooo05l0oooo001N0?ooo`05
0000003oool0oooo0?ooo`3o00000`3oool0103o0000oooo0?ooo`3o00020?ooo`030000003oool0
oooo01l0oooo0`000?lQ0?ooo`040000003oool0oooo0?l000@0oooo00<0o`000?ooo`3oool00P3o
ool00`000000oooo0?ooo`1N0?ooo`00G`3oool010000000oooo0?ooo`3o00030?ooo`060?l0003o
ool0oooo0?l0003oool000008@3oool40000ob40oooo00@000000?ooo`3oool0o`001@3oool0103o
0000oooo0?ooo`00001Q0?ooo`00G`3oool010000000oooo0?l0003o00040?ooo`80o`000P3oool0
0`000000003o0000o`0O0?ooo`@0003o8@3oool010000000oooo0?ooo`3o00030?ooo`060?l0003o
ool0oooo0?l0003oool00000H@3oool005l0oooo00<000000?ooo`3oool0203oool00`000000oooo
0?ooo`030000o`H0oooo00<0003o0?ooo`3oool0503oool50000oah0oooo0P000?l010000000oooo
0?l0003o00040?ooo`80o`0000<0oooo0000003oool0H@3oool00600oooo00<000000?ooo`3oool0
1`3oool00`000000oooo0?ooo`030?ooo`80003o103oool20000oa@0oooo1P000?lL0?ooo`80003o
0`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo0600oooo001Q0?ooo`<00000103o
ool2000000P0oooo20000?lB0?ooo`H0003o5`3oool50000o`H0oooo0P0000060?ooo`030000003o
ool0oooo0640oooo001T0?ooo`@00000303oool70000oa40oooo1P000?l?0?ooo`/0003o2P3oool6
000006@0oooo001d0?ooo`P0003o403oool70000o`X0oooo3P000?me0?ooo`00M03oool:0000o`d0
oooo20000?l:0?ooo``0003oM`3oool007<0oooo30000?l<0?ooo`P0003o2`3oool:0000ogP0oooo
001c0?ooo`d0003o3`3oool00`000?l0oooo0?ooo`0<0?ooo`T0003oN@3oool007L0oooo30000?l9
0?ooo`L000002P3oool80000og/0oooo001o0?ooo`H0003o1@3oool2000000L0oooo00<000000?oo
o`3oool0103oool30000o`80oooo1@000?ml0?ooo`00Q@3oool20000o`80oooo00<000000?ooo`3o
ool0203oool010000000oooo0?ooo`3oool20000o`H0oooo0`000?mm0?ooo`00Q`3oool20000o`03
0000003oool0oooo00P0oooo00@000000?ooo`000?l0003o203oool00`000?l0oooo0?ooo`1m0?oo
o`00R@3oool00`000000o`000?l000030?l000030?ooo`3o0000o`0000<0o`0000<000000?ooo`3o
ool0R03oool008P0oooo00D000000?ooo`3oool0oooo0?l000050?ooo`040?l0003oool0oooo0000
08X0oooo00280?ooo`050000003oool0oooo0?ooo`3o00001@3oool0103o0000oooo0?ooo`00002:
0?ooo`00R03oool01@000000oooo0?ooo`3oool0o`0000D0oooo00@0o`000?ooo`3oool00000RP3o
ool008P0oooo00D000000?ooo`3oool0oooo0?l000050?ooo`040?l0003oool0oooo000008X0oooo
00280?ooo`030000003oool0oooo0080o`00103oool20?l00080oooo00<000000?ooo`3oool0R03o
ool008T0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`290?ooo`00RP3oool00`00
0000oooo0?ooo`060?ooo`030000003oool0oooo08X0oooo002;0?ooo`8000000`3oool3000008d0
oooo002=0?ooo`<00000T03oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0
oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {279.813, 0}} -> {-1.09973, -1.04209, \
0.00765916, 0.00765916}}]
}, Open  ]],

Cell["", "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["GraphCoordinates",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox[\(g, \ options\),
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            Cell["\<\
calculates a visually appealing two-dimensional layout \
and returns the coordinates of the vertices\
\>", "Text"]},
          {
            RowBox[{
              RowBox[{
                StyleBox["GraphCoordinates3D",
                  "MR"], 
                StyleBox["[",
                  "MR"], 
                RowBox[{
                  StyleBox["g",
                    "TI"], ",", " ", 
                  StyleBox["options",
                    FontSlant->"Italic"]}], 
                StyleBox["]",
                  "MR"]}], " "}], 
            Cell["\<\
calculates a visually appealing three-dimensional \
layout and returns the coordinates of the vertices\
\>", "Text"]}
          }], TextForm]], "DefinitionBox",
  CellTags->{"GraphCoordinates", "i:3"}],

Cell["Graph drawing functions that return coordinates.", "Caption"],

Cell["This plots a graph.", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(g = {1 \[Rule] 2, 2 \[Rule] 3, 3 \[Rule] 4, 4 \[Rule] 5, 5 \[Rule] 6, 
          6 \[Rule] 1, 7 \[Rule] 8, 8 \[Rule] 9, 9 \[Rule] 10, 10 \[Rule] 11, 
          11 \[Rule] 12, 12 \[Rule] 7, 1 \[Rule] 7, 2 \[Rule] 8, 3 \[Rule] 9, 
          4 \[Rule] 10, 5 \[Rule] 11, 6 \[Rule] 12, 7 \[Rule] 13, 
          9 \[Rule] 13, 11 \[Rule] 13};\)\), "\[IndentingNewLine]", 
    \(\(GraphPlot[g];\)\)}], "Input",
  CellLabel->"In[14]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .87873 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.454835 0.521355 0.385809 0.521355 [
[ 0 0 0 0 ]
[ 1 .87873 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.73101 .02092 m
.31402 .10103 L
s
.73101 .02092 m
.48413 .03522 L
s
.31402 .10103 m
.201 .52796 L
s
.31402 .10103 m
.09328 .03267 L
s
.201 .52796 m
.44304 .85781 L
s
.201 .52796 m
.02381 .40596 L
s
.44304 .85781 m
.81036 .7226 L
s
.44304 .85781 m
.20409 .75921 L
s
.81036 .7226 m
.97619 .35057 L
s
.81036 .7226 m
.55061 .58382 L
s
.97619 .35057 m
.73101 .02092 L
s
.97619 .35057 m
.75205 .28843 L
s
.48413 .03522 m
.09328 .03267 L
s
.48413 .03522 m
.32841 .3289 L
s
.09328 .03267 m
.02381 .40596 L
s
.02381 .40596 m
.20409 .75921 L
s
.02381 .40596 m
.32841 .3289 L
s
.20409 .75921 m
.55061 .58382 L
s
.55061 .58382 m
.75205 .28843 L
s
.55061 .58382 m
.32841 .3289 L
s
.75205 .28843 m
.48413 .03522 L
s
.008 w
.73101 .02092 Mdot
.31402 .10103 Mdot
.201 .52796 Mdot
.44304 .85781 Mdot
.81036 .7226 Mdot
.97619 .35057 Mdot
.48413 .03522 Mdot
.09328 .03267 Mdot
.02381 .40596 Mdot
.20409 .75921 Mdot
.55061 .58382 Mdot
.75205 .28843 Mdot
.32841 .3289 Mdot
0 0 m
1 0 L
1 .87873 L
0 .87873 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[14]:=",
  ImageSize->{288, 253.063},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000oB000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00bP3oool8000004h0oooo002l0?oooa<000000P3oool2000004d0oooo002^0?ooo`h00000
2@3oool5000000P0oooo00<000000?ooo`3oool0B`3oool001X0oooo00<000000?ooo`3oool0P`3o
ool>00000140oooo1P00000>0?ooo`030000003oool0oooo04X0oooo000J0?ooocP00000>03oool0
0`000000oooo0?ooo`050?ooo`h000006P3oool5000001D0oooo00<000000?ooo`3oool0B@3oool0
01X0oooo00<000000?ooo`0000000`00000b0?oood0000008`3oool5000001/0oooo00<000000?oo
o`3oool0B03oool001X0oooo00<000000?ooo`3oool00`3oool3000006H0oooo00<000000?ooo`00
0000903oool500000200oooo00<000000?ooo`3oool0B03oool001T0oooo00<000000?ooo`3oool0
1`3oool3000006<0oooo00@000000?ooo`3oool000007P3oool5000002H0oooo00<000000?ooo`3o
ool0A`3oool001T0oooo00<000000?ooo`3oool02P3oool4000005h0oooo00<000000?ooo`3oool0
0P3oool00`000000oooo0?ooo`0F0?ooo`D00000;03oool00`000000oooo0?ooo`160?ooo`006@3o
ool00`000000oooo0?ooo`0>0?ooo`<00000F`3oool00`000000oooo0?ooo`030?ooo`030000003o
ool0oooo00l0oooo1P00000b0?ooo`030000003oool0oooo04D0oooo000I0?ooo`030000003oool0
oooo0140oooo0`00001G0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool02@3oool5
000003P0oooo00<000000?ooo`3oool0A@3oool001T0oooo00<000000?ooo`3oool0503oool40000
05<0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`030?ooo`D00000?P3oool00`00
0000oooo0?ooo`140?ooo`006@3oool00`000000oooo0?ooo`0H0?ooo`<00000C`3oool00`000000
oooo0?ooo`080?ooo`D00000A03oool00`000000oooo0?ooo`130?ooo`00603oool00`000000oooo
0?ooo`0L0?ooo`<00000C03oool00`000000oooo0?ooo`030?ooo`D000000P3oool00`000000oooo
0?ooo`150?ooo`030000003oool0oooo0480oooo000H0?ooo`030000003oool0oooo01l0oooo1000
00170?ooo`L00000203oool00`000000oooo0?ooo`140?ooo`030000003oool0oooo0480oooo000H
0?ooo`030000003oool0oooo02<0oooo0`0000100?ooo`D000003`3oool00`000000oooo0?ooo`14
0?ooo`030000003oool0oooo0440oooo000H0?ooo`030000003oool0oooo02H0oooo1000000g0?oo
o`D000000`3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo04@0oooo00<000000?oo
o`3oool0@03oool001P0oooo00<000000?ooo`3oool0:P3oool3000002l0oooo1@0000080?ooo`03
0000003oool0oooo0100oooo00<000000?ooo`3oool0A03oool00`000000oooo0?ooo`0o0?ooo`00
5`3oool00`000000oooo0?ooo`0^0?ooo`<000009`3oool5000000`0oooo00<000000?ooo`3oool0
4P3oool00`000000oooo0?ooo`130?ooo`030000003oool0oooo03l0oooo000G0?ooo`030000003o
ool0oooo0340oooo1000000N0?ooo`D000004@3oool00`000000oooo0?ooo`0C0?ooo`030000003o
ool0oooo04<0oooo00<000000?ooo`3oool0?P3oool001L0oooo00<000000?ooo`3oool0=@3oool3
000001D0oooo1P00000E0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool0@`3oool0
0`000000oooo0?ooo`0m0?ooo`005`3oool00`000000oooo0?ooo`0h0?ooo`<000003@3oool50000
01/0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`130?ooo`030000003oool0oooo
03`0oooo000G0?ooo`030000003oool0oooo03/0oooo100000040?ooo`D000007`3oool00`000000
oooo0?ooo`0H0?ooo`030000003oool0oooo0480oooo00<000000?ooo`3oool0?03oool001H0oooo
00<000000?ooo`3oool0@03oool4000002@0oooo00<000000?ooo`3oool06@3oool00`000000oooo
0?ooo`120?ooo`030000003oool0oooo03/0oooo000F0?ooo`030000003oool0oooo0400oooo0P00
000U0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool0@P3oool00`000000oooo0?oo
o`0j0?ooo`005P3oool00`000000oooo0?ooo`100?ooo`030000003oool0oooo02@0oooo00<00000
0?ooo`3oool0703oool00`000000oooo0?ooo`120?ooo`030000003oool0oooo03T0oooo000F0?oo
o`030000003oool0oooo0400oooo00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`0N0?oo
o`030000003oool0oooo0440oooo00<000000?ooo`3oool0>@3oool001H0oooo00<000000?ooo`3o
ool0@03oool00`000000oooo0?ooo`0R0?ooo`030000003oool0oooo0200oooo0P0000120?ooo`03
0000003oool0oooo03P0oooo000F0?ooo`030000003oool0oooo0400oooo00<000000?ooo`3oool0
8P3oool00`000000oooo0?ooo`0R0?ooo`030000003oool0oooo0400oooo00<000000?ooo`3oool0
=`3oool001D0oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`0R0?ooo`030000003o
ool0oooo02@0oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`0f0?ooo`005@3oool0
0`000000oooo0?ooo`100?ooo`030000003oool0oooo0280oooo00<000000?ooo`3oool09@3oool0
0`000000oooo0?ooo`0o0?ooo`030000003oool0oooo03H0oooo000E0?ooo`030000003oool0oooo
0400oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`0W0?ooo`030000003oool0oooo
03l0oooo00<000000?ooo`3oool0=@3oool001D0oooo00<000000?ooo`3oool0@03oool00`000000
oooo0?ooo`0Q0?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3oool0?`3oool00`000000
oooo0?ooo`0d0?ooo`005@3oool00`000000oooo0?ooo`0o0?ooo`030000003oool0oooo0240oooo
00<000000?ooo`3oool0:P3oool00`000000oooo0?ooo`0o0?ooo`030000003oool0oooo03<0oooo
000D0?ooo`030000003oool0oooo0400oooo00<000000?ooo`3oool08@3oool00`000000oooo0?oo
o`0[0?ooo`030000003oool0oooo03h0oooo00<000000?ooo`3oool0<`3oool001@0oooo00<00000
0?ooo`3oool0@03oool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo02d0oooo00<00000
0?ooo`3oool0?P3oool00`000000oooo0?ooo`0b0?ooo`00503oool00`000000oooo0?ooo`100?oo
o`030000003oool0oooo0200oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`0n0?oo
o`030000003oool0oooo0340oooo000D0?ooo`030000003oool0oooo03l0oooo00<000000?ooo`3o
ool0803oool00`000000oooo0?ooo`0`0?ooo`030000003oool0oooo03h0oooo00<000000?ooo`3o
ool0<03oool001@0oooo00<000000?ooo`3oool0?`3oool00`000000oooo0?ooo`0P0?ooo`030000
003oool0oooo0340oooo00<000000?ooo`3oool0?@3oool00`000000oooo0?ooo`0`0?ooo`004`3o
ool00`000000oooo0?ooo`100?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3oool0<`3o
ool00`000000oooo0?ooo`0m0?ooo`030000003oool0oooo02l0oooo000C0?ooo`030000003oool0
oooo03l0oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`0d0?ooo`030000003oool0
oooo03d0oooo00<000000?ooo`3oool0;P3oool001<0oooo00<000000?ooo`3oool0?`3oool00`00
0000oooo0?ooo`0O0?ooo`030000003oool0oooo03H0oooo0P00000n0?ooo`030000003oool0oooo
02d0oooo000C0?ooo`030000003oool0oooo03l0oooo00<000000?ooo`3oool07`3oool00`000000
oooo0?ooo`0h0?ooo`030000003oool0oooo03/0oooo00<000000?ooo`3oool0;@3oool001<0oooo
00<000000?ooo`3oool0?`3oool00`000000oooo0?ooo`0N0?ooo`030000003oool0oooo03X0oooo
00<000000?ooo`3oool0>`3oool00`000000oooo0?ooo`0/0?ooo`004`3oool00`000000oooo0?oo
o`0n0?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3oool0>`3oool00`000000oooo0?oo
o`0k0?ooo`030000003oool0oooo02/0oooo000B0?ooo`030000003oool0oooo03l0oooo00<00000
0?ooo`3oool07P3oool00`000000oooo0?ooo`0m0?ooo`030000003oool0oooo03/0oooo00<00000
0?ooo`3oool0:P3oool00180oooo00<000000?ooo`3oool0?`3oool00`000000oooo0?ooo`0N0?oo
o`030000003oool0oooo03h0oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0Z0?oo
o`004P3oool00`000000oooo0?ooo`0o0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3o
ool0@03oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo02T0oooo000B0?ooo`030000
003oool0oooo03h0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`120?ooo`030000
003oool0oooo03X0oooo00<000000?ooo`3oool0:03oool00180oooo00<000000?ooo`3oool0?P3o
ool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo04<0oooo00<000000?ooo`3oool0>P3o
ool00`000000oooo0?ooo`0W0?ooo`004@3oool00`000000oooo0?ooo`0o0?ooo`030000003oool0
oooo01`0oooo00<000000?ooo`3oool0A@3oool00`000000oooo0?ooo`0i0?ooo`030000003oool0
oooo02L0oooo000A0?ooo`030000003oool0oooo03h0oooo00<000000?ooo`3oool07@3oool00`00
0000oooo0?ooo`160?ooo`030000003oool0oooo03T0oooo00<000000?ooo`3oool09P3oool00140
oooo00<000000?ooo`3oool0?P3oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo04P0
oooo00<000000?ooo`3oool0>@3oool00`000000oooo0?ooo`0U0?ooo`004@3oool00`000000oooo
0?ooo`0n0?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool0B@3oool00`000000oooo
0?ooo`0i0?ooo`030000003oool0oooo02@0oooo000A0?ooo`030000003oool0oooo03h0oooo00<0
00000?ooo`3oool06`3oool00`000000oooo0?ooo`1;0?ooo`030000003oool0oooo03P0oooo00<0
00000?ooo`3oool0903oool00100oooo00<000000?ooo`3oool0?P3oool00`000000oooo0?ooo`0L
0?ooo`030000003oool0oooo04`0oooo0P00000i0?ooo`030000003oool0oooo02<0oooo000@0?oo
o`030000003oool0oooo03h0oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`1?0?oo
o`030000003oool0oooo03L0oooo00<000000?ooo`3oool08P3oool00100oooo00<000000?ooo`3o
ool0?P3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo0500oooo00<000000?ooo`3o
ool0=`3oool00`000000oooo0?ooo`0Q0?ooo`00403oool00`000000oooo0?ooo`0n0?ooo`030000
003oool0oooo01X0oooo00<000000?ooo`3oool0DP3oool00`000000oooo0?ooo`0f0?ooo`030000
003oool0oooo0240oooo000@0?ooo`030000003oool0oooo03d0oooo00<000000?ooo`3oool06`3o
ool00`000000oooo0?ooo`1C0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool0803o
ool00100oooo00<000000?ooo`3oool0?@3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0
oooo05D0oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`0O0?ooo`003`3oool00`00
0000oooo0?ooo`0n0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0EP3oool00`00
0000oooo0?ooo`0f0?ooo`030000003oool0oooo01h0oooo000?0?ooo`030000003oool0oooo03h0
oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`1H0?ooo`030000003oool0oooo03D0
oooo00<000000?ooo`3oool07P3oool000l0oooo00<000000?ooo`3oool0?@3oool00`000000oooo
0?ooo`0J0?ooo`030000003oool0oooo05T0oooo00<000000?ooo`3oool0=@3oool00`000000oooo
0?ooo`0M0?ooo`003`3oool00`000000oooo0?ooo`0m0?ooo`030000003oool0oooo01T0oooo00<0
00000?ooo`3oool0F`3oool00`000000oooo0?ooo`0e0?ooo`030000003oool0oooo01`0oooo000?
0?ooo`030000003oool0oooo03d0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`1L
0?ooo`030000003oool0oooo03D0oooo00<000000?ooo`3oool06`3oool000h0oooo00<000000?oo
o`3oool0?@3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo05h0oooo00<000000?oo
o`3oool0=03oool00`000000oooo0?ooo`0K0?ooo`003P3oool00`000000oooo0?ooo`0m0?ooo`03
0000003oool0oooo01T0oooo00<000000?ooo`3oool0G`3oool00`000000oooo0?ooo`0d0?ooo`03
0000003oool0oooo01X0oooo000>0?ooo`030000003oool0oooo03d0oooo00<000000?ooo`3oool0
603oool00`000000oooo0?ooo`1Q0?ooo`030000003oool0oooo03@0oooo00<000000?ooo`3oool0
6@3oool000h0oooo00<000000?ooo`3oool0?@3oool00`000000oooo0?ooo`0G0?ooo`030000003o
ool0oooo06<0oooo00<000000?ooo`3oool0=03oool00`000000oooo0?ooo`0H0?ooo`003P3oool0
0`000000oooo0?ooo`0l0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0I03oool2
000003@0oooo00<000000?ooo`3oool0603oool000d0oooo00<000000?ooo`3oool0?@3oool00`00
0000oooo0?ooo`0G0?ooo`030000003oool0oooo06L0oooo00<000000?ooo`3oool0<P3oool00`00
0000oooo0?ooo`0G0?ooo`003@3oool00`000000oooo0?ooo`0m0?ooo`030000003oool0oooo01L0
oooo00<000000?ooo`3oool0J03oool00`000000oooo0?ooo`0b0?ooo`030000003oool0oooo01H0
oooo000=0?ooo`030000003oool0oooo03d0oooo00<000000?ooo`3oool05P3oool00`000000oooo
0?ooo`1Z0?ooo`030000003oool0oooo0380oooo00<000000?ooo`3oool05@3oool000d0oooo00<0
00000?ooo`3oool0?03oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo06/0oooo00<0
00000?ooo`3oool0<@3oool00`000000oooo0?ooo`0E0?ooo`003@3oool00`000000oooo0?ooo`0l
0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool0K@3oool00`000000oooo0?ooo`0a
0?ooo`030000003oool0oooo01@0oooo000=0?ooo`030000003oool0oooo03`0oooo00<000000?oo
o`3oool05P3oool00`000000oooo0?ooo`1^0?ooo`030000003oool0oooo0340oooo00<000000?oo
o`3oool04`3oool000`0oooo00<000000?ooo`3oool0?@3oool00`000000oooo0?ooo`0E0?ooo`03
0000003oool0oooo0700oooo0P00000b0?ooo`030000003oool0oooo0180oooo000<0?ooo`030000
003oool0oooo03`0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`1_0?ooo`800000
00<0oooo0000000000000P00000^0?ooo`030000003oool0oooo0180oooo000<0?ooo`030000003o
ool0oooo03`0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`1`0?ooo`030000003o
ool0oooo00@0oooo1000000[0?ooo`030000003oool0oooo0140oooo000<0?ooo`030000003oool0
oooo03`0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`1_0?ooo`030000003oool0
oooo00T0oooo0`00000Y0?ooo`030000003oool0oooo0100oooo000<0?ooo`030000003oool0oooo
03/0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`1_0?ooo`030000003oool0oooo
00d0oooo1000000V0?ooo`030000003oool0oooo00l0oooo000;0?ooo`030000003oool0oooo03`0
oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`1_0?ooo`030000003oool0oooo0140
oooo0`00000S0?ooo`030000003oool0oooo00l0oooo000;0?ooo`030000003oool0oooo03`0oooo
00<000000?ooo`3oool0503oool00`000000oooo0?ooo`1_0?ooo`030000003oool0oooo01D0oooo
1000000P0?ooo`030000003oool0oooo00h0oooo000;0?ooo`030000003oool0oooo03`0oooo00<0
00000?ooo`3oool0503oool00`000000oooo0?ooo`1^0?ooo`030000003oool0oooo01X0oooo1000
000M0?ooo`030000003oool0oooo00d0oooo000;0?ooo`030000003oool0oooo03/0oooo00<00000
0?ooo`3oool0503oool00`000000oooo0?ooo`1_0?ooo`030000003oool0oooo01h0oooo0`00000K
0?ooo`030000003oool0oooo00`0oooo000;0?ooo`030000003oool0oooo03/0oooo00<000000?oo
o`3oool0503oool00`000000oooo0?ooo`1^0?ooo`030000003oool0oooo0280oooo1000000G0?oo
o`030000003oool0oooo00`0oooo000:0?ooo`030000003oool0oooo03`0oooo00<000000?ooo`3o
ool04`3oool00`000000oooo0?ooo`1^0?ooo`030000003oool0oooo02L0oooo0`00000E0?ooo`03
0000003oool0oooo00/0oooo000:0?ooo`030000003oool0oooo03`0oooo00<000000?ooo`3oool0
4@3oool00`000000oooo0000001`0?ooo`030000003oool0oooo02X0oooo1000000B0?ooo`030000
003oool0oooo00X0oooo000:0?ooo`030000003oool0oooo03/0oooo00<000000?ooo`3oool04P3o
ool200000700oooo00<000000?ooo`3oool0;`3oool4000000l0oooo00<000000?ooo`3oool02@3o
ool000X0oooo00<000000?ooo`3oool0>`3oool00`000000oooo0?ooo`0>0?ooo`@000000P3oool0
0`000000oooo0?ooo`1/0?ooo`030000003oool0oooo03@0oooo0`00000<0?ooo`030000003oool0
oooo00T0oooo000:0?ooo`030000003oool0oooo03/0oooo00<000000?ooo`3oool02P3oool40000
00L0oooo00<000000?ooo`3oool0J`3oool00`000000oooo0?ooo`0g0?ooo`@000002@3oool00`00
0000oooo0?ooo`080?ooo`002P3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo00L0
oooo1000000<0?ooo`030000003oool0oooo06T0oooo00<000000?ooo`3oool0?03oool3000000L0
oooo00<000000?ooo`3oool01`3oool000T0oooo00<000000?ooo`3oool0>`3oool00`000000oooo
0?ooo`030?ooo`@000004@3oool00`000000oooo0?ooo`1W0?ooo`030000003oool0oooo0400oooo
100000040?ooo`030000003oool0oooo00H0oooo00090?ooo`030000003oool0oooo03/0oooo00<0
00000?ooo`0000000`00000E0?ooo`030000003oool0oooo06L0oooo00<000000?ooo`3oool0A03o
ool5000000P0oooo00090?ooo`030000003oool0oooo03T0oooo1000000J0?ooo`030000003oool0
oooo06D0oooo00<000000?ooo`3oool0B@3oool2000000L0oooo00090?ooo`030000003oool0oooo
03D0oooo100000000`3oool000000?ooo`0L0?ooo`030000003oool0oooo06<0oooo00<000000?oo
o`3oool0BP3oool2000000L0oooo00090?ooo`030000003oool0oooo0340oooo100000050?ooo`03
0000003oool0oooo01`0oooo00<000000?ooo`3oool0HP3oool00`000000oooo0?ooo`1:0?ooo`03
0000003oool0oooo00H0oooo00080?ooo`030000003oool0oooo02h0oooo100000090?ooo`030000
003oool0oooo01d0oooo00<000000?ooo`3oool0H03oool00`000000oooo0?ooo`1;0?ooo`030000
003oool0oooo00H0oooo00080?ooo`030000003oool0oooo02X0oooo1000000=0?ooo`030000003o
ool0oooo01h0oooo00<000000?ooo`3oool0GP3oool00`000000oooo0?ooo`1;0?ooo`030000003o
ool0oooo00L0oooo00080?ooo`030000003oool0oooo02H0oooo1000000@0?ooo`030000003oool0
oooo0200oooo00<000000?ooo`3oool0G@3oool00`000000oooo0?ooo`1;0?ooo`030000003oool0
oooo00L0oooo00080?ooo`030000003oool0oooo0280oooo1000000D0?ooo`030000003oool0oooo
0240oooo00<000000?ooo`3oool0F`3oool00`000000oooo0?ooo`1;0?ooo`030000003oool0oooo
00P0oooo00080?ooo`030000003oool0oooo01h0oooo1000000H0?ooo`030000003oool0oooo0240
oooo00<000000?ooo`3oool0FP3oool00`000000oooo0?ooo`1<0?ooo`030000003oool0oooo00P0
oooo00070?ooo`030000003oool0oooo01/0oooo1000000L0?ooo`030000003oool0oooo0280oooo
00<000000?ooo`3oool0F@3oool00`000000oooo0?ooo`1;0?ooo`030000003oool0oooo00T0oooo
00070?ooo`030000003oool0oooo01L0oooo1000000O0?ooo`030000003oool0oooo02@0oooo00<0
00000?ooo`3oool0E`3oool00`000000oooo0?ooo`1<0?ooo`030000003oool0oooo00T0oooo0007
0?ooo`030000003oool0oooo01<0oooo1000000S0?ooo`030000003oool0oooo02D0oooo00<00000
0?ooo`3oool0E@3oool00`000000oooo0?ooo`1=0?ooo`030000003oool0oooo00T0oooo00070?oo
o`030000003oool0oooo00l0oooo1000000W0?ooo`030000003oool0oooo02H0oooo00<000000?oo
o`3oool0E03oool00`000000oooo0?ooo`1<0?ooo`030000003oool0oooo00X0oooo00070?ooo`03
0000003oool0oooo00/0oooo1000000Z0?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3o
ool0DP3oool00`000000oooo0?ooo`1=0?ooo`030000003oool0oooo00X0oooo00070?ooo`030000
003oool0oooo00L0oooo1000000^0?ooo`030000003oool0oooo02T0oooo00<000000?ooo`3oool0
D03oool00`000000oooo0?ooo`1=0?ooo`030000003oool0oooo00/0oooo00060?ooo`030000003o
ool0oooo00@0oooo1000000b0?ooo`030000003oool0oooo02X0oooo00<000000?ooo`3oool0C`3o
ool00`000000oooo0?ooo`1=0?ooo`030000003oool0oooo00/0oooo00060?ooo`030000003oool0
oooo00@00000=P3oool00`000000oooo0?ooo`0Z0?ooo`030000003oool0oooo04h0oooo00<00000
0?ooo`3oool0C@3oool00`000000oooo0?ooo`0<0?ooo`001P3oool3000003T0oooo00<000000?oo
o`3oool0;03oool00`000000oooo0?ooo`1<0?ooo`030000003oool0oooo04h0oooo00<000000?oo
o`3oool0303oool000H0oooo0`00000i0?ooo`030000003oool0oooo02d0oooo00<000000?ooo`3o
ool0B`3oool00`000000oooo0?ooo`1=0?ooo`030000003oool0oooo00d0oooo00070?ooo`030000
003oool0000003P0oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`190?ooo`030000
003oool0oooo04h0oooo00<000000?ooo`3oool03@3oool000P0oooo00@000000?ooo`0000000000
=P3oool00`000000oooo0?ooo`0_0?ooo`030000003oool0oooo04L0oooo00<000000?ooo`3oool0
CP3oool00`000000oooo0?ooo`0>0?ooo`00203oool01@000000oooo0?ooo`3oool0000003@0oooo
00<000000?ooo`3oool0<@3oool00`000000oooo0?ooo`160?ooo`030000003oool0oooo04h0oooo
00<000000?ooo`3oool03P3oool000T0oooo00@000000?ooo`3oool0oooo0P00000b0?ooo`030000
003oool0oooo0380oooo00<000000?ooo`3oool0A03oool00`000000oooo0?ooo`1?0?ooo`030000
003oool0oooo00h0oooo00090?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0;`3o
ool00`000000oooo0?ooo`0c0?ooo`030000003oool0oooo0480oooo00<000000?ooo`3oool0C`3o
ool00`000000oooo0?ooo`0?0?ooo`002P3oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo02h0oooo00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`120?ooo`030000003oool0
oooo04l0oooo00<000000?ooo`3oool03`3oool000X0oooo00<000000?ooo`3oool0103oool20000
02d0oooo00<000000?ooo`3oool0=@3oool00`000000oooo0?ooo`100?ooo`030000003oool0oooo
04l0oooo00<000000?ooo`3oool0403oool000/0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`0Z0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool0?P3oool00`000000
oooo0?ooo`1@0?ooo`030000003oool0oooo0100oooo000;0?ooo`030000003oool0oooo00H0oooo
0P00000Z0?ooo`030000003oool0oooo03L0oooo00<000000?ooo`3oool0?03oool00`000000oooo
0?ooo`1@0?ooo`030000003oool0oooo0140oooo000<0?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool09P3oool00`000000oooo0?ooo`0i0?ooo`030000003oool0oooo03/0oooo00<0
00000?ooo`3oool0D03oool00`000000oooo0?ooo`0A0?ooo`00303oool00`000000oooo0?ooo`08
0?ooo`8000009P3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo03T0oooo00<00000
0?ooo`3oool0D03oool00`000000oooo0?ooo`0B0?ooo`003@3oool00`000000oooo0?ooo`090?oo
o`030000003oool0oooo02<0oooo00<000000?ooo`3oool0>`3oool00`000000oooo0?ooo`0g0?oo
o`030000003oool0oooo0540oooo00<000000?ooo`3oool04P3oool000d0oooo00<000000?ooo`3o
ool02P3oool2000002<0oooo00<000000?ooo`3oool0?03oool00`000000oooo0?ooo`0f0?ooo`03
0000003oool0oooo0540oooo00<000000?ooo`3oool04P3oool000h0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0O0?ooo`030000003oool0oooo03d0oooo00<000000?ooo`3oool0
=@3oool00`000000oooo0?ooo`1A0?ooo`030000003oool0oooo01<0oooo000>0?ooo`030000003o
ool0oooo00`0oooo0P00000O0?ooo`030000003oool0oooo03h0oooo00<000000?ooo`3oool0<`3o
ool00`000000oooo0?ooo`1B0?ooo`030000003oool0oooo01<0oooo000?0?ooo`030000003oool0
oooo00d0oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`0o0?ooo`030000003oool0
oooo0380oooo00<000000?ooo`3oool0D@3oool00`000000oooo0?ooo`0D0?ooo`003`3oool00`00
0000oooo0?ooo`0>0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool0@03oool00`00
0000oooo0?ooo`0`0?ooo`030000003oool0oooo0580oooo00<000000?ooo`3oool0503oool00100
oooo00<000000?ooo`3oool03P3oool2000001X0oooo00<000000?ooo`3oool0@P3oool00`000000
oooo0?ooo`0^0?ooo`030000003oool0oooo0580oooo00<000000?ooo`3oool05@3oool00100oooo
00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo04<0oooo
00<000000?ooo`3oool0;@3oool00`000000oooo0?ooo`1B0?ooo`030000003oool0oooo01D0oooo
000A0?ooo`030000003oool0oooo0100oooo0P00000G0?ooo`030000003oool0oooo04@0oooo00<0
00000?ooo`3oool0:`3oool00`000000oooo0?ooo`1B0?ooo`030000003oool0oooo01H0oooo000A
0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`16
0?ooo`030000003oool0oooo02T0oooo00<000000?ooo`3oool0D`3oool00`000000oooo0?ooo`0F
0?ooo`004P3oool00`000000oooo0?ooo`0B0?ooo`8000004`3oool00`000000oooo0?ooo`160?oo
o`030000003oool0oooo02T0oooo00<000000?ooo`3oool0D`3oool00`000000oooo0?ooo`0F0?oo
o`004P3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3o
ool0A`3oool00`000000oooo0?ooo`0W0?ooo`030000003oool0oooo05<0oooo00<000000?ooo`3o
ool05`3oool001<0oooo00<000000?ooo`3oool0503oool200000100oooo00<000000?ooo`3oool0
B03oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo05@0oooo00<000000?ooo`3oool0
5`3oool001<0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0<0?ooo`030000003o
ool0oooo04X0oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`1C0?ooo`030000003o
ool0oooo01P0oooo000D0?ooo`030000003oool0oooo01H0oooo0P00000<0?ooo`030000003oool0
oooo04/0oooo00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`1D0?ooo`030000003oool0
oooo01P0oooo000D0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool02@3oool00`00
0000oooo0?ooo`1<0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool0E03oool00`00
0000oooo0?ooo`0I0?ooo`005@3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo00P0
oooo00<000000?ooo`3oool0C@3oool00`000000oooo0?ooo`0O0?ooo`030000003oool0oooo05@0
oooo00<000000?ooo`3oool06@3oool001D0oooo00<000000?ooo`3oool06@3oool2000000L0oooo
00<000000?ooo`3oool0C`3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo05@0oooo
00<000000?ooo`3oool06P3oool001H0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?oo
o`040?ooo`030000003oool0oooo04l0oooo00<000000?ooo`3oool0703oool00`000000oooo0?oo
o`1E0?ooo`030000003oool0oooo01X0oooo000F0?ooo`030000003oool0oooo01/0oooo0P000004
0?ooo`030000003oool0oooo0500oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`1D
0?ooo`030000003oool0oooo01/0oooo000G0?ooo`030000003oool0oooo01`0oooo00D000000?oo
o`3oool0oooo0000001C0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0E@3oool0
0`000000oooo0?ooo`0K0?ooo`00603oool00`000000oooo0?ooo`0L0?ooo`<00000E@3oool00`00
0000oooo0?ooo`0G0?ooo`030000003oool0oooo05H0oooo00<000000?ooo`3oool06`3oool001P0
oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`1D0?ooo`030000003oool0oooo01H0
oooo00<000000?ooo`3oool0E@3oool00`000000oooo0?ooo`0L0?ooo`006@3oool00`000000oooo
0?ooo`0M0?ooo`800000EP3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo05H0oooo
00<000000?ooo`3oool0703oool001T0oooo00<000000?ooo`3oool07P3oool00`000000oooo0?oo
o`1E0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool0EP3oool00`000000oooo0?oo
o`0M0?ooo`006P3oool00`000000oooo0?ooo`0N0?ooo`030000003oool0oooo05D0oooo00<00000
0?ooo`3oool04@3oool00`000000oooo0?ooo`1F0?ooo`030000003oool0oooo01d0oooo000J0?oo
o`030000003oool0oooo01l0oooo00<000000?ooo`3oool0E03oool00`000000oooo0?ooo`0@0?oo
o`030000003oool0oooo05H0oooo00<000000?ooo`3oool07P3oool001/0oooo00<000000?ooo`3o
ool07`3oool00`000000oooo0?ooo`1D0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3o
ool0E`3oool00`000000oooo0?ooo`0N0?ooo`006`3oool00`000000oooo0?ooo`0O0?ooo`030000
003oool0oooo05D0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`1F0?ooo`030000
003oool0oooo01l0oooo000L0?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3oool0E@3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo05L0oooo00<000000?ooo`3oool07`3o
ool001`0oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`1E0?ooo`030000003oool0
oooo00T0oooo00<000000?ooo`3oool0F03oool00`000000oooo0?ooo`0O0?ooo`007@3oool00`00
0000oooo0?ooo`0P0?ooo`030000003oool0oooo05D0oooo00<000000?ooo`3oool0203oool00`00
0000oooo0?ooo`1G0?ooo`030000003oool0oooo0200oooo000M0?ooo`030000003oool0oooo0200
oooo00<000000?ooo`3oool0EP3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo05P0
oooo00<000000?ooo`3oool0803oool001h0oooo00<000000?ooo`3oool0803oool00`000000oooo
0?ooo`1F0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0F03oool00`000000oooo
0?ooo`0Q0?ooo`007P3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo05D0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`1H0?ooo`030000003oool0oooo0240oooo000O
0?ooo`030000003oool0oooo0240oooo00<000000?ooo`3oool0E@3oool00`000000oooo0?ooo`02
0?ooo`030000003oool0oooo05P0oooo00<000000?ooo`3oool08P3oool001l0oooo00<000000?oo
o`3oool08@3oool00`000000oooo0?ooo`1F0?ooo`040000003oool0oooo000005/0oooo00<00000
0?ooo`3oool08P3oool00200oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`1F0?oo
o`030000003oool0000005X0oooo00<000000?ooo`3oool08`3oool00200oooo00<000000?ooo`3o
ool08P3oool00`000000oooo0?ooo`1E0?ooo`800000F`3oool00`000000oooo0?ooo`0S0?ooo`00
8@3oool00`000000oooo0?ooo`0R0?ooo`030000003oool0oooo05<0oooo0P0000000`3oool00000
0000001H0?ooo`030000003oool0oooo02@0oooo000Q0?ooo`030000003oool0oooo0280oooo00<0
00000?ooo`3oool0D@3oool2000000D0oooo0P00001F0?ooo`030000003oool0oooo02@0oooo000R
0?ooo`030000003oool0oooo0280oooo00<000000?ooo`3oool0CP3oool2000000T0oooo0P00001D
0?ooo`030000003oool0oooo02@0oooo000R0?ooo`030000003oool0oooo02<0oooo00<000000?oo
o`3oool0B`3oool2000000d0oooo0P00001A0?ooo`030000003oool0oooo02D0oooo000S0?ooo`03
0000003oool0oooo02<0oooo00<000000?ooo`3oool0B03oool200000140oooo0P00001?0?ooo`03
0000003oool0oooo02D0oooo000S0?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool0
AP3oool2000001D0oooo0P00001<0?ooo`030000003oool0oooo02H0oooo000T0?ooo`030000003o
ool0oooo02<0oooo00<000000?ooo`3oool0@`3oool2000001T0oooo00<000000?ooo`3oool0B@3o
ool00`000000oooo0?ooo`0V0?ooo`00903oool00`000000oooo0?ooo`0T0?ooo`030000003oool0
oooo0400oooo0P00000L0?ooo`800000B03oool00`000000oooo0?ooo`0W0?ooo`009@3oool00`00
0000oooo0?ooo`0T0?ooo`030000003oool0oooo03d0oooo0P00000P0?ooo`800000AP3oool00`00
0000oooo0?ooo`0W0?ooo`009@3oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo03/0
oooo0P00000T0?ooo`800000@`3oool00`000000oooo0?ooo`0X0?ooo`009P3oool00`000000oooo
0?ooo`0T0?ooo`030000003oool0oooo03P0oooo0P00000X0?ooo`800000@@3oool00`000000oooo
0?ooo`0X0?ooo`009P3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo03D0oooo0P00
000/0?ooo`800000?`3oool00`000000oooo0?ooo`0X0?ooo`009`3oool00`000000oooo0?ooo`0U
0?ooo`030000003oool0oooo0380oooo0P00000`0?ooo`030000003oool0oooo03/0oooo00<00000
0?ooo`3oool0:@3oool002L0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0`0?oo
o`800000<`3oool2000003/0oooo00<000000?ooo`3oool0:@3oool002P0oooo00<000000?ooo`3o
ool09@3oool00`000000oooo0?ooo`0]0?ooo`800000=`3oool2000003P0oooo00<000000?ooo`3o
ool0:P3oool002P0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0Z0?ooo`800000
>`3oool2000003H0oooo00<000000?ooo`3oool0:P3oool002T0oooo00<000000?ooo`3oool09P3o
ool00`000000oooo0?ooo`0W0?ooo`800000?`3oool2000003<0oooo00<000000?ooo`3oool0:`3o
ool002X0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0U0?ooo`800000@`3oool2
00000340oooo00<000000?ooo`3oool0:`3oool002X0oooo00<000000?ooo`3oool09P3oool00`00
0000oooo0?ooo`0R0?ooo`800000A`3oool2000002h0oooo00<000000?ooo`3oool0;03oool002/0
oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0O0?ooo`800000B`3oool00`000000
oooo0?ooo`0[0?ooo`030000003oool0oooo02`0oooo000[0?ooo`030000003oool0oooo02L0oooo
00<000000?ooo`3oool0703oool2000004h0oooo0P00000[0?ooo`030000003oool0oooo02`0oooo
000/0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool06P3oool200000580oooo0P00
000X0?ooo`030000003oool0oooo02d0oooo000/0?ooo`030000003oool0oooo02L0oooo00<00000
0?ooo`3oool05`3oool2000005H0oooo0P00000V0?ooo`030000003oool0oooo02d0oooo000]0?oo
o`030000003oool0oooo02L0oooo00<000000?ooo`3oool0503oool2000005X0oooo0P00000S0?oo
o`030000003oool0oooo02h0oooo000]0?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3o
ool04@3oool2000005h0oooo0P00000Q0?ooo`030000003oool0oooo02h0oooo000^0?ooo`030000
003oool0oooo02L0oooo00<000000?ooo`3oool03`3oool200000680oooo0P00000N0?ooo`030000
003oool0oooo02l0oooo000^0?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3oool0303o
ool2000006H0oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`0_0?ooo`00;`3oool0
0`000000oooo0?ooo`0X0?ooo`030000003oool0oooo00T0oooo0P00001Y0?ooo`8000006P3oool0
0`000000oooo0?ooo`0`0?ooo`00;`3oool00`000000oooo0?ooo`0Y0?ooo`030000003oool0oooo
00H0oooo0P00001]0?ooo`800000603oool00`000000oooo0?ooo`0`0?ooo`00<03oool00`000000
oooo0?ooo`0X0?ooo`030000003oool0oooo00@0oooo0P00001a0?ooo`8000005@3oool00`000000
oooo0?ooo`0a0?ooo`00<03oool00`000000oooo0?ooo`0Y0?ooo`040000003oool0oooo0?ooo`80
0000M@3oool2000001<0oooo00<000000?ooo`3oool0<@3oool00340oooo00<000000?ooo`3oool0
:@3oool3000007T0oooo0P00000A0?ooo`030000003oool0oooo0340oooo000a0?ooo`030000003o
ool0oooo02P0oooo0P00001m0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0<P3o
ool00380oooo00<000000?ooo`3oool09@3oool200000080oooo00<000000?ooo`3oool0N`3oool2
000000d0oooo00<000000?ooo`3oool0<P3oool00380oooo00<000000?ooo`3oool08`3oool20000
00D0oooo00<000000?ooo`3oool0O03oool2000000X0oooo00<000000?ooo`3oool0<`3oool003<0
oooo00<000000?ooo`3oool0803oool2000000P0oooo00<000000?ooo`3oool0O@3oool2000000P0
oooo00<000000?ooo`3oool0<`3oool003<0oooo00<000000?ooo`3oool07P3oool2000000X0oooo
00<000000?ooo`3oool0O`3oool2000000D0oooo00<000000?ooo`3oool0=03oool003@0oooo00<0
00000?ooo`3oool06`3oool2000000d0oooo00<000000?ooo`3oool0P03oool2000000<0oooo00<0
00000?ooo`3oool0=03oool003@0oooo00<000000?ooo`3oool06@3oool200000100oooo00<00000
0?ooo`3oool0P@3oool3000003L0oooo000e0?ooo`030000003oool0oooo01H0oooo0P00000C0?oo
o`030000003oool0oooo0840oooo0P00000g0?ooo`00=@3oool00`000000oooo0?ooo`0D0?ooo`80
00005@3oool00`000000oooo0?ooo`1n0?ooo`<00000>@3oool003H0oooo00<000000?ooo`3oool0
4@3oool2000001P0oooo00<000000?ooo`3oool0N`3oool2000003`0oooo000f0?ooo`030000003o
ool0oooo00l0oooo0P00000K0?ooo`030000003oool0oooo07L0oooo0`00000n0?ooo`00=`3oool0
0`000000oooo0?ooo`0<0?ooo`8000007P3oool00`000000oooo0?ooo`1c0?ooo`<00000@@3oool0
03L0oooo00<000000?ooo`3oool02P3oool200000200oooo00<000000?ooo`3oool0L03oool30000
04@0oooo000h0?ooo`030000003oool0oooo00L0oooo0P00000S0?ooo`030000003oool0oooo06d0
oooo0P0000170?ooo`00>03oool00`000000oooo0?ooo`050?ooo`8000009P3oool00`000000oooo
0?ooo`1Y0?ooo`<00000B@3oool003T0oooo00<000000?ooo`3oool00P3oool2000002T0oooo00<0
00000?ooo`3oool0I@3oool3000004`0oooo000i0?ooo`030000003oool0oooo00800000:`3oool0
0`000000oooo0?ooo`1R0?ooo`<00000C`3oool003T0oooo0`00000^0?ooo`030000003oool0oooo
05h0oooo0`00001B0?ooo`00>@3oool00`000000oooo0?ooo`02000002d0oooo00<000000?ooo`3o
ool0F`3oool2000005D0oooo000n0?ooo`<00000:`3oool00`000000oooo0?ooo`1G0?ooo`<00000
E`3oool00440oooo0P00000Y0?ooo`030000003oool0oooo05@0oooo0`00001J0?ooo`00@`3oool3
000002L0oooo00<000000?ooo`3oool0D03oool3000005d0oooo00160?ooo`8000009P3oool00`00
0000oooo0?ooo`1=0?ooo`800000H03oool004P0oooo0`00000T0?ooo`030000003oool0oooo04T0
oooo0`00001R0?ooo`00B`3oool200000280oooo00<000000?ooo`3oool0AP3oool3000006D0oooo
001=0?ooo`8000008@3oool00`000000oooo0?ooo`120?ooo`<00000J03oool004l0oooo0`00000O
0?ooo`030000003oool0oooo03l0oooo0P00001[0?ooo`00DP3oool2000001h0oooo00<000000?oo
o`3oool0>`3oool3000006d0oooo001D0?ooo`<000006`3oool00`000000oooo0?ooo`0h0?ooo`<0
0000L03oool005L0oooo0P00000J0?ooo`030000003oool0oooo03@0oooo0`00001c0?ooo`00F@3o
ool3000001P0oooo00<000000?ooo`3oool0<@3oool2000007H0oooo001L0?ooo`8000005`3oool0
0`000000oooo0?ooo`0]0?ooo`<00000N03oool005h0oooo0`00000D0?ooo`030000003oool0oooo
02X0oooo0`00001k0?ooo`00H@3oool2000001<0oooo00<000000?ooo`3oool09P3oool3000007h0
oooo001S0?ooo`<000004@3oool00`000000oooo0?ooo`0S0?ooo`800000P@3oool006H0oooo0P00
000@0?ooo`030000003oool0oooo01l0oooo0`0000230?ooo`00J03oool3000000d0oooo00<00000
0?ooo`3oool0703oool3000008H0oooo001[0?ooo`800000303oool00`000000oooo0?ooo`0H0?oo
o`<00000R@3oool006d0oooo0P00000;0?ooo`030000003oool0oooo01@0oooo0`00002<0?ooo`00
K`3oool3000000T0oooo00<000000?ooo`3oool04@3oool2000008l0oooo001b0?ooo`8000001`3o
ool00`000000oooo0?ooo`0>0?ooo`<00000T@3oool007@0oooo0`0000050?ooo`030000003oool0
oooo00X0oooo0`00002D0?ooo`00M`3oool2000000@0oooo00<000000?ooo`3oool01P3oool30000
09L0oooo001i0?ooo`<000000P3oool00`000000oooo0?ooo`030?ooo`800000VP3oool007`0oooo
0`0000020?ooo`<00000W03oool007h0oooo0`00002O0?ooo`00OP3oool00`000000oooo0?ooo`2O
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {252.063, 0}} -> {-0.872925, -0.740021, \
0.0066868, 0.0066868}}]
}, Open  ]],

Cell["\<\
This gives the coordinates of the vertices in the previous drawing.\
\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(coord\  = \ GraphCoordinates[g]\)], "Input",
  CellLabel->"In[16]:="],

Cell[BoxData[
    \({{0.5297314917335092`, \(-0.6998818772283479`\)}, \
{\(-0.2700891504297753`\), \(-0.5462199591685698`\)}, {\(-0.4868690158614765`\
\), 0.2726635883688058`}, {\(-0.02262299006437765`\), 
        0.9053360584314006`}, {0.6819190734307986`, 
        0.6459983890337905`}, {1.`, \(-0.0675948630486042`\)}, \
{0.05618103261147668`, \(-0.6724614398916642`\)}, {\(-0.6934900869028511`\), \
\(-0.6773515084657928`\)}, {\(-0.8267412598198713`\), 
        0.03864459556131441`}, {\(-0.4809446609980007`\), 
        0.7162048685181905`}, {0.18369940871077428`, 
        0.3797937509722153`}, {0.5700809612746551`, \
\(-0.18677239189506464`\)}, {\(-0.2424919691414624`\), \
\(-0.10916130772375607`\)}}\)], "Output",
  CellLabel->"Out[16]="]
}, Open  ]],

Cell[TextData[{
  StyleBox["GraphCoordinates", "MR"],
  StyleBox[" and ", "TR"],
  StyleBox["GraphCoordinates3D", "MR"],
  " accept the following options. "
}], "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["option name", "TI"],
              StyleBox[" ", "TI"]
            }]], Cell[TextData[{
              StyleBox["default value", "TI"],
              StyleBox[" ", "TI"]
            }]], Cell[""]},
          {Cell[TextData[StyleBox["Method", "MR"]]], Cell[TextData[StyleBox[
            "Automatic ", "MR"]]], 
            StyleBox[\(method\ used\ to\ lay\ out\ the\ graph\),
              "TR"]},
          {Cell[TextData[{
              StyleBox["RandomSeed", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Automatic", "MR"],
              " "
            }]], Cell[TextData[{
              
              "used for initial vertex placement in the spring model and the \
spring\[Hyphen]electrical model, and for selecting the first of the ",
              StyleBox["k",
                FontSlant->"Italic"],
              " centers in the high\[Hyphen]dimensional embedding method"
            }]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  ShowStringCharacters->True,
  GridBoxOptions->{RowLines->{True, False}}],

Cell[TextData[{
  "Options for ",
  StyleBox["GraphCoordinates", "MR"],
  " and ",
  StyleBox["GraphCoordinates3D.", "MR"]
}], "Caption"],

Cell["This gives the coordinates using the spring model method.", \
"MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(coord\  = \ GraphCoordinates[g, Method \[Rule] SpringModel]\)], "Input",\

  CellLabel->"In[17]:="],

Cell[BoxData[
    \({{0.501672633866541`, 
        0.7726984860510946`}, {1.`, \(-0.08478908288103112`\)}, \
{0.44615756655173944`, \(-0.8242073787599086`\)}, {\(-0.48706616502217887`\), \
\(-0.8741462970218801`\)}, {\(-0.9222971641021591`\), \
\(-0.1318836458930432`\)}, {\(-0.6236208223568139`\), 
        0.7614056689095745`}, {0.30364405078997153`, 
        0.710032317639775`}, {0.8362847408993545`, 
        0.10184477129712838`}, {0.41322666810929654`, \
\(-0.5840292919830652`\)}, {\(-0.35898047365102864`\), \(-0.7139886759997784`\
\)}, {\(-0.7440420057085477`\), 
        0.04353987329779519`}, {\(-0.3769314916395933`\), 
        0.773723227174107`}, {0.011952462263418145`, 
        0.04980002816923158`}}\)], "Output",
  CellLabel->"Out[17]="]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["TreePlot",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox[\(g, \ options\),
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{"generates", " ", "a", " ", Cell[TextData[{
                "plot of the graph ",
                Cell[BoxData[
                    \(TraditionalForm\`g\)]],
                " as a tree            "
              }], "Text"]}]},
          {
            RowBox[{
              RowBox[{
                StyleBox["TreePlot",
                  "MR"], 
                StyleBox["[",
                  "MR"], 
                RowBox[{
                  StyleBox["g",
                    "TI"], ",", " ", 
                  StyleBox["r",
                    FontSlant->"Italic"], ",", " ", 
                  StyleBox["options",
                    FontSlant->"Italic"]}], 
                StyleBox["]",
                  "MR"]}], " "}], 
            RowBox[{
              RowBox[{Cell[TextData[Cell[BoxData[
                    StyleBox["generates",
                      FontFamily->"Times"]]]], "Text"], "a", " ", "plot", " ",
                 "of", " ", "the", " ", "graph", " ", "g", " ", "as", " ", 
                "a", " ", "tree"}], ",", " ", 
              RowBox[{"with", " ", "root", " ", Cell[TextData[Cell[BoxData[
                    \(TraditionalForm\`r\)]]]]}]}]}
          }], TextForm]], "DefinitionBox",
  CellTags->"i:4"],

Cell[TextData[{
  "The ",
  StyleBox["TreePlot", "MR"],
  " function."
}], "Caption"],

Cell["This plots a binary tree.", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(g = 
        Flatten[Table[{i \[Rule] \ 2*i, \ i \[Rule] 2*i + 1}, {i, 
              2^4 - 1}]];\)\ \), "\[IndentingNewLine]", 
    \(\(TreePlot[g];\)\)}], "Input",
  CellLabel->"In[18]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .5164 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.504103 1.84428 [
[ 0 0 0 0 ]
[ 1 .5164 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.5 .5041 m
.24603 .38115 L
s
.5 .5041 m
.75397 .38115 L
s
.24603 .38115 m
.11905 .2582 L
s
.24603 .38115 m
.37302 .2582 L
s
.75397 .38115 m
.62698 .2582 L
s
.75397 .38115 m
.88095 .2582 L
s
.11905 .2582 m
.05556 .13525 L
s
.11905 .2582 m
.18254 .13525 L
s
.37302 .2582 m
.30952 .13525 L
s
.37302 .2582 m
.43651 .13525 L
s
.62698 .2582 m
.56349 .13525 L
s
.62698 .2582 m
.69048 .13525 L
s
.88095 .2582 m
.81746 .13525 L
s
.88095 .2582 m
.94444 .13525 L
s
.05556 .13525 m
.02381 .0123 L
s
.05556 .13525 m
.0873 .0123 L
s
.18254 .13525 m
.15079 .0123 L
s
.18254 .13525 m
.21429 .0123 L
s
.30952 .13525 m
.27778 .0123 L
s
.30952 .13525 m
.34127 .0123 L
s
.43651 .13525 m
.40476 .0123 L
s
.43651 .13525 m
.46825 .0123 L
s
.56349 .13525 m
.53175 .0123 L
s
.56349 .13525 m
.59524 .0123 L
s
.69048 .13525 m
.65873 .0123 L
s
.69048 .13525 m
.72222 .0123 L
s
.81746 .13525 m
.78571 .0123 L
s
.81746 .13525 m
.84921 .0123 L
s
.94444 .13525 m
.9127 .0123 L
s
.94444 .13525 m
.97619 .0123 L
s
.008 w
.5 .5041 Mdot
.24603 .38115 Mdot
.75397 .38115 Mdot
.11905 .2582 Mdot
.37302 .2582 Mdot
.62698 .2582 Mdot
.88095 .2582 Mdot
.05556 .13525 Mdot
.18254 .13525 Mdot
.30952 .13525 Mdot
.43651 .13525 Mdot
.56349 .13525 Mdot
.69048 .13525 Mdot
.81746 .13525 Mdot
.94444 .13525 Mdot
.02381 .0123 Mdot
.0873 .0123 Mdot
.15079 .0123 Mdot
.21429 .0123 Mdot
.27778 .0123 Mdot
.34127 .0123 Mdot
.40476 .0123 Mdot
.46825 .0123 Mdot
.53175 .0123 Mdot
.59524 .0123 Mdot
.65873 .0123 Mdot
.72222 .0123 Mdot
.78571 .0123 Mdot
.84921 .0123 Mdot
.9127 .0123 Mdot
.97619 .0123 Mdot
0 0 m
1 0 L
1 .5164 L
0 .5164 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[18]:=",
  ImageSize->{288, 148.688},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000U2000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`001P3oool200000100oooo0P00000A0?ooo`030000
003oool0oooo00l0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0?0?ooo`800000
403oool200000100oooo0P00000@0?ooo`8000004@3oool00`000000oooo0?ooo`0?0?ooo`030000
003oool0oooo00l0oooo0P00000@0?ooo`800000403oool200000100oooo0P00000A0?ooo`030000
003oool0oooo00H0oooo00060?ooo`800000403oool200000140oooo00<000000?ooo`3oool03`3o
ool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00l0oooo0P00000@0?ooo`800000403o
ool200000100oooo0P00000A0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool03`3o
ool200000100oooo0P00000@0?ooo`800000403oool200000140oooo00<000000?ooo`3oool01P3o
ool000P0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0
oooo00d0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0
oooo0140oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0
oooo00d0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0
oooo0140oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0
oooo00d0oooo00<000000?ooo`3oool01`3oool000P0oooo00<000000?ooo`3oool03@3oool00`00
0000oooo0?ooo`0A0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool04@3oool00`00
0000oooo0?ooo`0>0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool03@3oool00`00
0000oooo0?ooo`0A0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool04@3oool00`00
0000oooo0?ooo`0>0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool03@3oool00`00
0000oooo0?ooo`0A0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool01`3oool000P0
oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo00d0
oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo0140
oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo00d0
oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo0140
oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo00d0
oooo00<000000?ooo`3oool01`3oool000P0oooo00<000000?ooo`3oool03@3oool00`000000oooo
0?ooo`0A0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool04@3oool00`000000oooo
0?ooo`0>0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool03@3oool00`000000oooo
0?ooo`0A0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool04@3oool00`000000oooo
0?ooo`0>0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool03@3oool00`000000oooo
0?ooo`0A0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool01`3oool000T0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool04`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo01<0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool04`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo01<0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool0203oool000T0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0C
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0<
0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0C
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0<
0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0C
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0203oool000T0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool04`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo01<0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool04`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo01<0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool0203oool000T0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0C0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo01<0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0C0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo01@0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0C0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool0203oool000X0oooo00<000000?ooo`3oool0
2@3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0
5@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool0
2@3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0
5@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool0
2@3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0
2@3oool000X0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0E0?ooo`030000003o
ool0oooo00T0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0:0?ooo`030000003o
ool0oooo01D0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0E0?ooo`030000003o
ool0oooo00T0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0:0?ooo`030000003o
ool0oooo01D0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0E0?ooo`030000003o
ool0oooo00T0oooo00<000000?ooo`3oool02@3oool000X0oooo00<000000?ooo`3oool02@3oool0
0`000000oooo0?ooo`0E0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool05@3oool0
0`000000oooo0?ooo`0:0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool02@3oool0
0`000000oooo0?ooo`0E0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool05@3oool0
0`000000oooo0?ooo`0:0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool02@3oool0
0`000000oooo0?ooo`0E0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool0
00X0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo
00T0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo
01D0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo
00T0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo
01H0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo
00T0oooo00<000000?ooo`3oool02@3oool000/0oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`0G0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool05`3oool00`000000
oooo0?ooo`080?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`0G0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool05`3oool00`000000
oooo0?ooo`080?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`0G0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool02P3oool000/0oooo
00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo01L0oooo
00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo01L0oooo
00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool02P3oool000/0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`0G0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0603oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`0G0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`0G0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool02P3oool000/0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool0603oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo01L0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool05`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo01P0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool02P3oool000`0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0I0?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`060?oo
o`030000003oool0oooo01T0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0I0?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`060?oo
o`030000003oool0oooo01T0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0I0?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool02`3oool000`0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool06@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool06@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool02`3oool000`0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0I0?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo01T0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0I0?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo01X0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0I0?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool02`3oool000`0oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool06P3o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool06@3o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool02`3o
ool000d0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`040?ooo`030000003oool0
oooo01/0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`040?ooo`030000003oool0
oooo01/0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool0303oool000d0oooo00<000000?ooo`3oool00`3oool00`00
0000oooo0?ooo`0K0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0703oool00`00
0000oooo0?ooo`030?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool00`3oool00`00
0000oooo0?ooo`0K0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool06`3oool00`00
0000oooo0?ooo`030?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool00`3oool00`00
0000oooo0?ooo`0K0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0303oool000d0
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo01/0
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo01`0
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`3oool0303oool000d0oooo00<000000?ooo`3oool00`3oool00`000000oooo
0?ooo`0K0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0703oool00`000000oooo
0?ooo`030?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool00`3oool00`000000oooo
0?ooo`0K0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool06`3oool00`000000oooo
0?ooo`030?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool00`3oool00`000000oooo
0?ooo`0K0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0303oool000h0oooo00D0
00000?ooo`3oool0oooo0000000O0?ooo`050000003oool0oooo0?ooo`0000007`3oool00`000000
oooo0?ooo`020?ooo`030000003oool0oooo01d0oooo00D000000?ooo`3oool0oooo0000000O0?oo
o`050000003oool0oooo0?ooo`0000007`3oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo01d0oooo00D000000?ooo`3oool0oooo0000000O0?ooo`050000003oool0oooo0?ooo`000000
3`3oool000h0oooo00D000000?ooo`3oool0oooo0000000O0?ooo`050000003oool0oooo0?ooo`00
0000803oool01@000000oooo0?ooo`3oool0000001l0oooo00D000000?ooo`3oool0oooo0000000O
0?ooo`050000003oool0oooo0?ooo`0000007`3oool01@000000oooo0?ooo`3oool000000200oooo
00D000000?ooo`3oool0oooo0000000O0?ooo`050000003oool0oooo0?ooo`0000003`3oool000h0
oooo00D000000?ooo`3oool0oooo0000000O0?ooo`050000003oool0oooo0?ooo`000000803oool0
1@000000oooo0?ooo`3oool0000001l0oooo00D000000?ooo`3oool0oooo0000000O0?ooo`050000
003oool0oooo0?ooo`0000007`3oool01@000000oooo0?ooo`3oool000000200oooo00D000000?oo
o`3oool0oooo0000000O0?ooo`050000003oool0oooo0?ooo`0000003`3oool000h0oooo00D00000
0?ooo`3oool0oooo0000000O0?ooo`050000003oool0oooo0?ooo`000000803oool01@000000oooo
0?ooo`3oool0000001l0oooo00D000000?ooo`3oool0oooo0000000O0?ooo`050000003oool0oooo
0?ooo`0000007`3oool01@000000oooo0?ooo`3oool000000200oooo00D000000?ooo`3oool0oooo
0000000O0?ooo`050000003oool0oooo0?ooo`0000003`3oool000l0oooo00<000000?ooo`000000
8@3oool00`000000oooo0000000R0?ooo`030000003oool000000240oooo00<000000?ooo`000000
8@3oool00`000000oooo0000000Q0?ooo`030000003oool000000280oooo00<000000?ooo`000000
8@3oool00`000000oooo0000000@0?ooo`003`3oool00`000000oooo0000000Q0?ooo`030000003o
ool000000280oooo00<000000?ooo`0000008@3oool00`000000oooo0000000Q0?ooo`030000003o
ool000000240oooo00<000000?ooo`0000008P3oool00`000000oooo0000000Q0?ooo`030000003o
ool000000100oooo000?0?ooo`030000003oool000000240oooo00<000000?ooo`0000008P3oool0
0`000000oooo0000000Q0?ooo`030000003oool000000240oooo00<000000?ooo`0000008@3oool0
0`000000oooo0000000R0?ooo`030000003oool000000240oooo00<000000?ooo`000000403oool0
00l0oooo00<000000?ooo`0000008@3oool00`000000oooo0000000R0?ooo`030000003oool00000
0240oooo00<000000?ooo`0000008@3oool00`000000oooo0000000Q0?ooo`030000003oool00000
0280oooo00<000000?ooo`0000008@3oool00`000000oooo0000000@0?ooo`00403oool00`000000
oooo0?ooo`0Q0?ooo`030000003oool0oooo0280oooo00<000000?ooo`3oool08@3oool00`000000
oooo0?ooo`0Q0?ooo`030000003oool0oooo0240oooo00<000000?ooo`3oool08P3oool00`000000
oooo0?ooo`0Q0?ooo`030000003oool0oooo00l0oooo000?0?ooo`8000008`3oool00`000000oooo
0?ooo`0Q0?ooo`8000008P3oool2000002<0oooo00<000000?ooo`3oool08@3oool00`000000oooo
0?ooo`0Q0?ooo`8000008P3oool200000140oooo000?0?ooo`8000008P3oool2000002<0oooo0P00
000R0?ooo`030000003oool0oooo0280oooo00<000000?ooo`3oool0803oool2000002<0oooo0P00
000R0?ooo`030000003oool0oooo0100oooo000A0?ooo`030000003oool0oooo01l0oooo00<00000
0?ooo`3oool0903oool00`000000oooo0?ooo`0O0?ooo`030000003oool0oooo02<0oooo00<00000
0?ooo`3oool07`3oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo01l0oooo00<00000
0?ooo`3oool0403oool00140oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`0U0?oo
o`030000003oool0oooo01h0oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`0N0?oo
o`030000003oool0oooo02D0oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`0A0?oo
o`004P3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3o
ool07@3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3o
ool09P3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo0140oooo000B0?ooo`030000
003oool0oooo01`0oooo00<000000?ooo`3oool09`3oool00`000000oooo0?ooo`0L0?ooo`030000
003oool0oooo02H0oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`0W0?ooo`030000
003oool0oooo01`0oooo00<000000?ooo`3oool04P3oool001<0oooo00<000000?ooo`3oool06`3o
ool00`000000oooo0?ooo`0X0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool09`3o
ool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3oool06`3o
ool00`000000oooo0?ooo`0B0?ooo`004`3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0
oooo02T0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`0X0?ooo`030000003oool0
oooo01X0oooo00<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0
oooo01<0oooo000D0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0:P3oool00`00
0000oooo0?ooo`0I0?ooo`030000003oool0oooo02T0oooo00<000000?ooo`3oool06@3oool00`00
0000oooo0?ooo`0Z0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool04`3oool001@0
oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0[0?ooo`030000003oool0oooo01P0
oooo00<000000?ooo`3oool0:P3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo02/0
oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0D0?ooo`005@3oool00`000000oooo
0?ooo`0G0?ooo`030000003oool0oooo02`0oooo00<000000?ooo`3oool05`3oool00`000000oooo
0?ooo`0[0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0;03oool00`000000oooo
0?ooo`0G0?ooo`030000003oool0oooo01@0oooo000E0?ooo`030000003oool0oooo01H0oooo00<0
00000?ooo`3oool0;@3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo02`0oooo00<0
00000?ooo`3oool05P3oool00`000000oooo0?ooo`0]0?ooo`030000003oool0oooo01H0oooo00<0
00000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0^
0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool0;@3oool00`000000oooo0?ooo`0E
0?ooo`030000003oool0oooo02h0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0E
0?ooo`005P3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo02l0oooo00<000000?oo
o`3oool0503oool00`000000oooo0?ooo`0^0?ooo`030000003oool0oooo01@0oooo00<000000?oo
o`3oool0;`3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo01H0oooo000G0?ooo`03
0000003oool0oooo01<0oooo00<000000?ooo`3oool0<03oool00`000000oooo0?ooo`0C0?ooo`03
0000003oool0oooo02l0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0`0?ooo`03
0000003oool0oooo01<0oooo00<000000?ooo`3oool05P3oool001L0oooo00<000000?ooo`3oool0
4P3oool00`000000oooo0?ooo`0a0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool0
<03oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo0340oooo00<000000?ooo`3oool0
4P3oool00`000000oooo0?ooo`0G0?ooo`00603oool00`000000oooo0?ooo`0A0?ooo`030000003o
ool0oooo0380oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0a0?ooo`030000003o
ool0oooo0140oooo00<000000?ooo`3oool0<P3oool00`000000oooo0?ooo`0A0?ooo`030000003o
ool0oooo01L0oooo000H0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0<`3oool0
0`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0380oooo00<000000?ooo`3oool0403oool0
0`000000oooo0?ooo`0c0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0603oool0
01T0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0d0?ooo`030000003oool0oooo
00l0oooo00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo
03@0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0H0?ooo`006@3oool00`000000
oooo0?ooo`0>0?ooo`030000003oool0oooo03D0oooo00<000000?ooo`3oool03P3oool00`000000
oooo0?ooo`0d0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0=@3oool00`000000
oooo0?ooo`0>0?ooo`030000003oool0oooo01T0oooo000J0?ooo`030000003oool0oooo00d0oooo
00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo03D0oooo
00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo00d0oooo
00<000000?ooo`3oool06@3oool001X0oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`0g0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?oo
o`0<0?ooo`030000003oool0oooo03L0oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`0J0?ooo`006`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo03P0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0g0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool0>03oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo01X0oooo000K0?oo
o`030000003oool0oooo00X0oooo00<000000?ooo`3oool0>@3oool00`000000oooo0?ooo`0:0?oo
o`030000003oool0oooo03P0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0i0?oo
o`030000003oool0oooo00X0oooo00<000000?ooo`3oool06`3oool001`0oooo00<000000?ooo`3o
ool02@3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3o
ool0>@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3o
ool02@3oool00`000000oooo0?ooo`0K0?ooo`00703oool00`000000oooo0?ooo`080?ooo`030000
003oool0oooo03/0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0j0?ooo`030000
003oool0oooo00P0oooo00<000000?ooo`3oool0>`3oool00`000000oooo0?ooo`080?ooo`030000
003oool0oooo01`0oooo000M0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0?03o
ool00`000000oooo0?ooo`070?ooo`030000003oool0oooo03/0oooo00<000000?ooo`3oool01`3o
ool00`000000oooo0?ooo`0l0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0703o
ool001d0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0m0?ooo`030000003oool0
oooo00H0oooo00<000000?ooo`3oool0?03oool00`000000oooo0?ooo`060?ooo`030000003oool0
oooo03d0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0M0?ooo`007P3oool00`00
0000oooo0?ooo`050?ooo`030000003oool0oooo03h0oooo00<000000?ooo`3oool01@3oool00`00
0000oooo0?ooo`0m0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0?P3oool00`00
0000oooo0?ooo`050?ooo`030000003oool0oooo01d0oooo000N0?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool0?`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo03h0
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0o0?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool07P3oool001l0oooo00<000000?ooo`3oool00`3oool00`000000oooo
0?ooo`100?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0?`3oool00`000000oooo
0?ooo`030?ooo`030000003oool0oooo0400oooo00<000000?ooo`3oool00`3oool00`000000oooo
0?ooo`0N0?ooo`007`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0440oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`100?ooo`030000003oool0oooo0080oooo00<0
00000?ooo`3oool0@@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo01l0oooo000P
0?ooo`050000003oool0oooo0?ooo`000000A03oool01@000000oooo0?ooo`3oool0000004<0oooo
00D000000?ooo`3oool0oooo000000140?ooo`050000003oool0oooo0?ooo`0000008@3oool00200
oooo00@000000?ooo`3oool00000A@3oool010000000oooo0?ooo`0000140?ooo`040000003oool0
oooo000004D0oooo00@000000?ooo`3oool000008P3oool00240oooo00<000000?ooo`000000AP3o
ool00`000000oooo000000150?ooo`030000003oool0000004H0oooo00<000000?ooo`0000008P3o
ool00240oooo0P0000170?ooo`800000AP3oool2000004L0oooo0P00000S0?ooo`008@3oool20000
04L0oooo0P0000170?ooo`030000003oool0oooo04D0oooo0P00000S0?ooo`008`3oool00`000000
oooo0?ooo`140?ooo`030000003oool0oooo04L0oooo00<000000?ooo`3oool0A03oool00`000000
oooo0?ooo`0R0?ooo`00903oool00`000000oooo0?ooo`120?ooo`030000003oool0oooo04T0oooo
00<000000?ooo`3oool0@P3oool00`000000oooo0?ooo`0S0?ooo`009@3oool00`000000oooo0?oo
o`100?ooo`030000003oool0oooo04/0oooo00<000000?ooo`3oool0@03oool00`000000oooo0?oo
o`0T0?ooo`009P3oool00`000000oooo0?ooo`0n0?ooo`030000003oool0oooo04d0oooo00<00000
0?ooo`3oool0?P3oool00`000000oooo0?ooo`0U0?ooo`009`3oool00`000000oooo0?ooo`0l0?oo
o`030000003oool0oooo04l0oooo00<000000?ooo`3oool0?03oool00`000000oooo0?ooo`0V0?oo
o`00:03oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo0540oooo00<000000?ooo`3o
ool0>P3oool00`000000oooo0?ooo`0W0?ooo`00:@3oool00`000000oooo0?ooo`0h0?ooo`030000
003oool0oooo05<0oooo00<000000?ooo`3oool0>03oool00`000000oooo0?ooo`0X0?ooo`00:P3o
ool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo05D0oooo00<000000?ooo`3oool0=P3o
ool00`000000oooo0?ooo`0Y0?ooo`00:`3oool00`000000oooo0?ooo`0c0?ooo`800000F@3oool2
000003D0oooo00<000000?ooo`3oool0:P3oool002`0oooo00<000000?ooo`3oool0<@3oool00`00
0000oooo0?ooo`1K0?ooo`030000003oool0oooo0340oooo00<000000?ooo`3oool0:`3oool002d0
oooo00<000000?ooo`3oool0;`3oool00`000000oooo0?ooo`1M0?ooo`030000003oool0oooo02l0
oooo00<000000?ooo`3oool0;03oool002h0oooo00<000000?ooo`3oool0;@3oool00`000000oooo
0?ooo`1O0?ooo`030000003oool0oooo02d0oooo00<000000?ooo`3oool0;@3oool002l0oooo00<0
00000?ooo`3oool0:`3oool00`000000oooo0?ooo`1Q0?ooo`030000003oool0oooo02/0oooo00<0
00000?ooo`3oool0;P3oool00300oooo00<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`1S
0?ooo`030000003oool0oooo02T0oooo00<000000?ooo`3oool0;`3oool00340oooo00<000000?oo
o`3oool09`3oool00`000000oooo0?ooo`1U0?ooo`030000003oool0oooo02L0oooo00<000000?oo
o`3oool0<03oool00380oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`1W0?ooo`03
0000003oool0oooo02D0oooo00<000000?ooo`3oool0<@3oool003<0oooo00<000000?ooo`3oool0
8`3oool00`000000oooo0?ooo`1Y0?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool0
<P3oool003@0oooo0P00000R0?ooo`030000003oool0oooo06/0oooo00<000000?ooo`3oool0803o
ool2000003D0oooo000f0?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3oool0K@3oool0
0`000000oooo0?ooo`0N0?ooo`030000003oool0oooo03D0oooo000g0?ooo`030000003oool0oooo
01`0oooo00<000000?ooo`3oool0K`3oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo
03H0oooo000h0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0L@3oool00`000000
oooo0?ooo`0J0?ooo`030000003oool0oooo03L0oooo000i0?ooo`030000003oool0oooo01P0oooo
00<000000?ooo`3oool0L`3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo03P0oooo
000j0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool0M@3oool00`000000oooo0?oo
o`0F0?ooo`030000003oool0oooo03T0oooo000k0?ooo`030000003oool0oooo01@0oooo00<00000
0?ooo`3oool0M`3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo03X0oooo000l0?oo
o`030000003oool0oooo0180oooo00<000000?ooo`3oool0N@3oool00`000000oooo0?ooo`0B0?oo
o`030000003oool0oooo03/0oooo000m0?ooo`030000003oool0oooo00l0oooo0P00001m0?ooo`80
00004@3oool00`000000oooo0?ooo`0l0?ooo`00?P3oool00`000000oooo0?ooo`0=0?ooo`030000
003oool0oooo07l0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0m0?ooo`00?`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo0840oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0n0?ooo`00@03oool00`000000oooo0?ooo`090?ooo`030000003oool0
oooo08<0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0o0?ooo`00@@3oool00`00
0000oooo0?ooo`070?ooo`030000003oool0oooo08D0oooo00<000000?ooo`3oool01`3oool00`00
0000oooo0?ooo`100?ooo`00@P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo08L0
oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`110?ooo`00@`3oool00`000000oooo
0?ooo`030?ooo`030000003oool0oooo08T0oooo00<000000?ooo`3oool00`3oool00`000000oooo
0?ooo`120?ooo`00A03oool01@000000oooo0?ooo`3oool0000008d0oooo00D000000?ooo`3oool0
oooo000000150?ooo`00A@3oool3000008l0oooo00<000000?ooo`000000AP3oool004H0oooo0P00
002?0?ooo`800000A`3oool004P0oooo0P00002;0?ooo`800000B@3oool004X0oooo0P0000270?oo
o`800000B`3oool004`0oooo0P0000230?ooo`800000C@3oool004h0oooo0P00001o0?ooo`800000
C`3oool00500oooo0P00001k0?ooo`800000D@3oool00580oooo0P00001g0?ooo`800000D`3oool0
05@0oooo0P00001c0?ooo`800000E@3oool005H0oooo0P00001_0?ooo`800000E`3oool005P0oooo
0P00001[0?ooo`800000F@3oool005X0oooo0P00001W0?ooo`800000F`3oool005`0oooo0P00001S
0?ooo`800000G@3oool005h0oooo0`00001M0?ooo`<00000G`3oool00640oooo0P00001I0?ooo`80
0000HP3oool006<0oooo0P00001E0?ooo`800000I03oool006D0oooo0P00001A0?ooo`800000IP3o
ool006L0oooo0P00001=0?ooo`800000J03oool006T0oooo0P0000190?ooo`800000JP3oool006/0
oooo0P0000150?ooo`800000K03oool006d0oooo0P0000110?ooo`800000KP3oool006l0oooo0P00
000m0?ooo`800000L03oool00740oooo0P00000i0?ooo`800000LP3oool007<0oooo0P00000e0?oo
o`800000M03oool007D0oooo0`00000_0?ooo`<00000MP3oool007P0oooo0P00000[0?ooo`800000
N@3oool007X0oooo0P00000W0?ooo`800000N`3oool007`0oooo0P00000S0?ooo`800000O@3oool0
07h0oooo0P00000O0?ooo`800000O`3oool00800oooo0P00000K0?ooo`800000P@3oool00880oooo
0P00000G0?ooo`800000P`3oool008@0oooo0P00000C0?ooo`800000Q@3oool008H0oooo0P00000?
0?ooo`800000Q`3oool008P0oooo0P00000;0?ooo`800000R@3oool008X0oooo0P0000070?ooo`80
0000R`3oool008`0oooo0P0000030?ooo`800000S@3oool008h0oooo0`00002?0?ooo`00SP3oool0
0`000000oooo0?ooo`2?0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {147.688, 0}} -> {-0.0268513, -0.273335, \
0.00367144, 0.00189592}}]
}, Open  ]],

Cell[TextData[{
  StyleBox["TreePlot", "MR"],
  StyleBox[" accepts the following options, as well as options for ", "TR"],
  StyleBox["Graphics", "MR"],
  "."
}], "Text"],

Cell[BoxData[GridBox[{
        {
          StyleBox[\(option\ name\),
            "TI"], 
          StyleBox[\(default\ value\),
            "TI"], " "},
        {"AspectRatio", "Automatic", 
          StyleBox[\(aspect\ ratio\ of\ the\ plot\),
            FontFamily->"Times"]},
        {"RootPosition", "Top", 
          StyleBox[\(position\ of\ the\ root\),
            "TR"]},
        {"TreeSizeFunction", \((1 &)\), 
          StyleBox[\(height\ of\ each\ level\ of\ the\ tree\),
            FontFamily->"Times"]}
        }]], "DefinitionBox3Col",
  ShowStringCharacters->True,
  GridBoxOptions->{RowLines->{0.5, False}}],

Cell[TextData[{
  "Options for ",
  StyleBox["TreePlot.", "MR"]
}], "Caption"],

Cell["\<\
This plots the previous tree but with the root in the center.\
\>", \
"MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(TreePlot[g, \ RootPosition \[Rule] Center];\)\)], "Input",
  CellLabel->"In[20]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.47619 0.5 0.47619 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.5 .5 m
.37862 .5 L
s
.5 .5 m
.62138 .5 L
s
.37862 .5 m
.32834 .67166 L
s
.37862 .5 m
.32834 .32834 L
s
.62138 .5 m
.67166 .32834 L
s
.62138 .5 m
.67166 .67166 L
s
.32834 .67166 m
.36065 .83642 L
s
.32834 .67166 m
.16358 .63935 L
s
.32834 .32834 m
.16358 .36065 L
s
.32834 .32834 m
.36065 .16358 L
s
.67166 .32834 m
.63935 .16358 L
s
.67166 .32834 m
.83642 .36065 L
s
.67166 .67166 m
.83642 .63935 L
s
.67166 .67166 m
.63935 .83642 L
s
.36065 .83642 m
.40528 .97619 L
s
.36065 .83642 m
.23026 .90369 L
s
.16358 .63935 m
.09631 .76974 L
s
.16358 .63935 m
.02381 .59472 L
s
.16358 .36065 m
.02381 .40528 L
s
.16358 .36065 m
.09631 .23026 L
s
.36065 .16358 m
.23026 .09631 L
s
.36065 .16358 m
.40528 .02381 L
s
.63935 .16358 m
.59472 .02381 L
s
.63935 .16358 m
.76974 .09631 L
s
.83642 .36065 m
.90369 .23026 L
s
.83642 .36065 m
.97619 .40528 L
s
.83642 .63935 m
.97619 .59472 L
s
.83642 .63935 m
.90369 .76974 L
s
.63935 .83642 m
.76974 .90369 L
s
.63935 .83642 m
.59472 .97619 L
s
.008 w
.5 .5 Mdot
.37862 .5 Mdot
.62138 .5 Mdot
.32834 .67166 Mdot
.32834 .32834 Mdot
.67166 .32834 Mdot
.67166 .67166 Mdot
.36065 .83642 Mdot
.16358 .63935 Mdot
.16358 .36065 Mdot
.36065 .16358 Mdot
.63935 .16358 Mdot
.83642 .36065 Mdot
.83642 .63935 Mdot
.63935 .83642 Mdot
.40528 .97619 Mdot
.23026 .90369 Mdot
.09631 .76974 Mdot
.02381 .59472 Mdot
.02381 .40528 Mdot
.09631 .23026 Mdot
.23026 .09631 Mdot
.40528 .02381 Mdot
.59472 .02381 Mdot
.76974 .09631 Mdot
.90369 .23026 Mdot
.97619 .40528 Mdot
.97619 .59472 Mdot
.90369 .76974 Mdot
.76974 .90369 Mdot
.59472 .97619 Mdot
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[20]:=",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000182000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00L`3oool2000003D0oooo00<000000?ooo`3oool0L`3oool007<0oooo
0P00000e0?ooo`030000003oool0oooo07<0oooo001c0?ooo`030000003oool0oooo03D0oooo00<0
00000?ooo`3oool0LP3oool007<0oooo00<000000?ooo`3oool0=@3oool00`000000oooo0?ooo`1b
0?ooo`00L`3oool00`000000oooo0?ooo`0e0?ooo`030000003oool0oooo0780oooo001b0?ooo`03
0000003oool0oooo03L0oooo00<000000?ooo`3oool0L@3oool00780oooo00<000000?ooo`3oool0
=`3oool00`000000oooo0?ooo`1a0?ooo`00LP3oool00`000000oooo0?ooo`0g0?ooo`030000003o
ool0oooo0740oooo001a0?ooo`030000003oool0oooo03T0oooo00<000000?ooo`3oool0L03oool0
0740oooo00<000000?ooo`3oool0>@3oool00`000000oooo0?ooo`1`0?ooo`00L@3oool00`000000
oooo0?ooo`0i0?ooo`030000003oool0oooo0700oooo001`0?ooo`030000003oool0oooo03/0oooo
00<000000?ooo`3oool0K`3oool00700oooo00<000000?ooo`3oool0>`3oool00`000000oooo0?oo
o`1_0?ooo`00L03oool00`000000oooo0?ooo`0k0?ooo`030000003oool0oooo06l0oooo001_0?oo
o`030000003oool0oooo03d0oooo00<000000?ooo`3oool0KP3oool006l0oooo00<000000?ooo`3o
ool0?@3oool00`000000oooo0?ooo`1^0?ooo`00K`3oool00`000000oooo0?ooo`0m0?ooo`030000
003oool0oooo06h0oooo001^0?ooo`030000003oool0oooo03l0oooo00<000000?ooo`3oool0K@3o
ool006h0oooo00<000000?ooo`3oool0?`3oool00`000000oooo0?ooo`1]0?ooo`00KP3oool00`00
0000oooo0?ooo`0o0?ooo`030000003oool0oooo06d0oooo001]0?ooo`030000003oool0oooo0400
oooo00<000000?ooo`3oool0K@3oool00440oooo0P00000Z0?ooo`030000003oool0oooo0440oooo
00<000000?ooo`3oool0:03oool00`000000oooo0?ooo`110?ooo`00@@3oool010000000oooo0000
0000000X0?ooo`030000003oool0oooo0440oooo00<000000?ooo`3oool09P3oool3000004<0oooo
00150?ooo`8000009P3oool00`000000oooo0?ooo`110?ooo`030000003oool0oooo02@0oooo0P00
00160?ooo`00A`3oool2000002<0oooo00<000000?ooo`3oool0@`3oool00`000000oooo0?ooo`0Q
0?ooo`800000B03oool004T0oooo0P00000Q0?ooo`030000003oool0oooo04<0oooo00<000000?oo
o`3oool07`3oool2000004X0oooo001;0?ooo`8000007`3oool00`000000oooo0?ooo`130?ooo`03
0000003oool0oooo01d0oooo0P00001<0?ooo`00C@3oool2000001`0oooo00<000000?ooo`3oool0
A@3oool00`000000oooo0?ooo`0J0?ooo`800000CP3oool004l0oooo0P00000J0?ooo`030000003o
ool0oooo04D0oooo00<000000?ooo`3oool0603oool200000500oooo001A0?ooo`800000603oool0
0`000000oooo0?ooo`150?ooo`030000003oool0oooo01H0oooo0P00001B0?ooo`00D`3oool20000
01D0oooo00<000000?ooo`3oool0A`3oool00`000000oooo0?ooo`0C0?ooo`800000E03oool005D0
oooo0P00000C0?ooo`030000003oool0oooo04L0oooo00<000000?ooo`3oool04@3oool2000005H0
oooo001G0?ooo`8000004@3oool00`000000oooo0?ooo`170?ooo`030000003oool0oooo00l0oooo
0P00001H0?ooo`00F@3oool2000000h0oooo00<000000?ooo`3oool0B@3oool00`000000oooo0?oo
o`0<0?ooo`800000FP3oool005/0oooo0P00000<0?ooo`030000003oool0oooo04T0oooo00<00000
0?ooo`3oool02P3oool2000005`0oooo001M0?ooo`8000002P3oool00`000000oooo0?ooo`190?oo
o`030000003oool0oooo00P0oooo0P00001N0?ooo`00G`3oool2000000L0oooo00<000000?ooo`3o
ool0B`3oool00`000000oooo0?ooo`050?ooo`800000H03oool00640oooo0P0000050?ooo`030000
003oool0oooo04/0oooo00<000000?ooo`3oool00`3oool200000680oooo001S0?ooo`8000000`3o
ool00`000000oooo0?ooo`1;0?ooo`040000003oool0oooo0?ooo`800000I03oool006D0oooo0`00
001?0?ooo`<00000IP3oool006H0oooo0P00001>0?ooo`800000J03oool006H0oooo0P00001>0?oo
o`800000J03oool006L0oooo00<000000?ooo`3oool0C@3oool00`000000oooo0?ooo`1V0?ooo`00
IP3oool00`000000oooo0?ooo`1?0?ooo`030000003oool0oooo06D0oooo001V0?ooo`030000003o
ool0oooo04l0oooo00<000000?ooo`3oool0I@3oool006H0oooo00<000000?ooo`3oool0C`3oool0
0`000000oooo0?ooo`1U0?ooo`00IP3oool00`000000oooo0?ooo`1?0?ooo`030000003oool0oooo
06D0oooo001V0?ooo`030000003oool0oooo04l0oooo00<000000?ooo`3oool0I@3oool006D0oooo
00<000000?ooo`3oool0D03oool00`000000oooo0?ooo`1U0?ooo`00I@3oool00`000000oooo0?oo
o`1A0?ooo`030000003oool0oooo06@0oooo001U0?ooo`030000003oool0oooo0540oooo00<00000
0?ooo`3oool0I03oool006D0oooo00<000000?ooo`3oool0D@3oool00`000000oooo0?ooo`1T0?oo
o`00I@3oool00`000000oooo0?ooo`1A0?ooo`030000003oool0oooo06@0oooo001U0?ooo`030000
003oool0oooo0540oooo00<000000?ooo`3oool0I03oool006@0oooo00<000000?ooo`3oool0D`3o
ool00`000000oooo0?ooo`1S0?ooo`00I03oool00`000000oooo0?ooo`1C0?ooo`030000003oool0
oooo06<0oooo001T0?ooo`030000003oool0oooo05<0oooo00<000000?ooo`3oool0H`3oool006@0
oooo00<000000?ooo`3oool0D`3oool00`000000oooo0?ooo`1S0?ooo`00I03oool00`000000oooo
0?ooo`1C0?ooo`030000003oool0oooo06<0oooo000K0?ooo`030000003oool0oooo04D0oooo00<0
00000?ooo`3oool0E@3oool00`000000oooo0?ooo`140?ooo`030000003oool0oooo01/0oooo000K
0?ooo`030000003oool0oooo04D0oooo00<000000?ooo`3oool0E@3oool00`000000oooo0?ooo`14
0?ooo`800000703oool001`0oooo00<000000?ooo`3oool0A03oool00`000000oooo0?ooo`1E0?oo
o`030000003oool0oooo04@0oooo00<000000?ooo`3oool06`3oool001`0oooo00<000000?ooo`3o
ool0A03oool00`000000oooo0?ooo`1E0?ooo`030000003oool0oooo04@0oooo00<000000?ooo`3o
ool06`3oool001d0oooo00<000000?ooo`3oool0@`3oool00`000000oooo0?ooo`1E0?ooo`030000
003oool0oooo04<0oooo00<000000?ooo`3oool0703oool001d0oooo00<000000?ooo`3oool0@P3o
ool00`000000oooo0?ooo`1F0?ooo`030000003oool0oooo04<0oooo00<000000?ooo`3oool0703o
ool001h0oooo00<000000?ooo`3oool0@@3oool00`000000oooo0?ooo`1G0?ooo`030000003oool0
oooo0440oooo00<000000?ooo`3oool07@3oool001h0oooo00<000000?ooo`3oool0@@3oool00`00
0000oooo0?ooo`1G0?ooo`030000003oool0oooo0440oooo00<000000?ooo`3oool07@3oool001l0
oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`1G0?ooo`030000003oool0oooo0400
oooo00<000000?ooo`3oool07P3oool001l0oooo00<000000?ooo`3oool0@03oool00`000000oooo
0?ooo`1G0?ooo`030000003oool0oooo0400oooo00<000000?ooo`3oool07P3oool00200oooo00<0
00000?ooo`3oool0?`3oool00`000000oooo0?ooo`1G0?ooo`030000003oool0oooo03l0oooo00<0
00000?ooo`3oool07`3oool00200oooo00<000000?ooo`3oool0?P3oool00`000000oooo0?ooo`1I
0?ooo`030000003oool0oooo03h0oooo00<000000?ooo`3oool07`3oool00240oooo00<000000?oo
o`3oool0?@3oool00`000000oooo0?ooo`1I0?ooo`030000003oool0oooo03d0oooo00<000000?oo
o`3oool0803oool00240oooo00<000000?ooo`3oool0?@3oool00`000000oooo0?ooo`1I0?ooo`03
0000003oool0oooo03d0oooo00<000000?ooo`3oool0803oool00280oooo00<000000?ooo`3oool0
?03oool00`000000oooo0?ooo`1I0?ooo`030000003oool0oooo03`0oooo00<000000?ooo`3oool0
8@3oool00280oooo00<000000?ooo`3oool0?03oool00`000000oooo0?ooo`1I0?ooo`030000003o
ool0oooo03`0oooo00<000000?ooo`3oool08@3oool002<0oooo00<000000?ooo`3oool0>P3oool0
0`000000oooo0?ooo`1K0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool08P3oool0
02<0oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`1K0?ooo`030000003oool0oooo
03X0oooo00<000000?ooo`3oool08P3oool002@0oooo00<000000?ooo`3oool0>@3oool00`000000
oooo0?ooo`1K0?ooo`030000003oool0oooo03T0oooo00<000000?ooo`3oool08`3oool002@0oooo
00<000000?ooo`3oool0>@3oool00`000000oooo0?ooo`1K0?ooo`030000003oool0oooo03T0oooo
00<000000?ooo`3oool08`3oool002D0oooo00<000000?ooo`3oool0>03oool00`000000oooo0?oo
o`1K0?ooo`030000003oool0oooo03P0oooo00<000000?ooo`3oool0903oool002D0oooo00<00000
0?ooo`3oool0=`3oool00`000000oooo0?ooo`1L0?ooo`030000003oool0oooo03P0oooo00<00000
0?ooo`3oool0903oool002H0oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`1M0?oo
o`030000003oool0oooo03H0oooo00<000000?ooo`3oool09@3oool002H0oooo00<000000?ooo`3o
ool0=P3oool00`000000oooo0?ooo`1M0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3o
ool09@3oool002L0oooo00<000000?ooo`3oool0=@3oool00`000000oooo0?ooo`1M0?ooo`030000
003oool0oooo03D0oooo00<000000?ooo`3oool09P3oool002L0oooo00<000000?ooo`3oool0=@3o
ool00`000000oooo0?ooo`1M0?ooo`030000003oool0oooo03D0oooo00<000000?ooo`3oool09P3o
ool002P0oooo00<000000?ooo`3oool0=03oool00`000000oooo0?ooo`1M0?ooo`030000003oool0
oooo03@0oooo00<000000?ooo`3oool09`3oool002P0oooo00<000000?ooo`3oool0<`3oool00`00
0000oooo0?ooo`1O0?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3oool09`3oool002T0
oooo00<000000?ooo`3oool0<@3oool200000640oooo00<000000?ooo`3oool0<P3oool00`000000
oooo0?ooo`0X0?ooo`00:@3oool00`000000oooo0?ooo`0`0?ooo`<00000H@3oool300000380oooo
00<000000?ooo`3oool0:03oool002X0oooo00<000000?ooo`3oool0:P3oool500000080oooo00<0
00000?ooo`3oool0G`3oool00`000000oooo0?ooo`05000002`0oooo00<000000?ooo`3oool0:@3o
ool002X0oooo00<000000?ooo`3oool0903oool6000000P0oooo00<000000?ooo`3oool0G@3oool0
0`000000oooo0?ooo`060?ooo`H000009P3oool00`000000oooo0?ooo`0Y0?ooo`00:`3oool00`00
0000oooo0?ooo`0N0?ooo`D000003P3oool00`000000oooo0?ooo`1M0?ooo`030000003oool0oooo
00`0oooo1@00000P0?ooo`030000003oool0oooo02X0oooo000[0?ooo`030000003oool0oooo01T0
oooo1@00000C0?ooo`030000003oool0oooo05d0oooo00<000000?ooo`3oool04@3oool5000001/0
oooo00<000000?ooo`3oool0:P3oool002`0oooo00<000000?ooo`3oool04P3oool6000001P0oooo
00<000000?ooo`3oool0G@3oool00`000000oooo0?ooo`0F0?ooo`H00000503oool00`000000oooo
0?ooo`0[0?ooo`00;03oool00`000000oooo0?ooo`0=0?ooo`D000007`3oool00`000000oooo0?oo
o`1K0?ooo`030000003oool0oooo01d0oooo1@00000?0?ooo`030000003oool0oooo02/0oooo000]
0?ooo`030000003oool0oooo00L0oooo1@00000T0?ooo`030000003oool0oooo05/0oooo00<00000
0?ooo`3oool08P3oool5000000T0oooo00<000000?ooo`3oool0;03oool002d0oooo00@000000?oo
o`3oool0oooo1P00000Y0?ooo`030000003oool0oooo05/0oooo00<000000?ooo`3oool09`3oool6
000000<0oooo00<000000?ooo`3oool0;03oool002d0oooo1000000`0?ooo`030000003oool0oooo
05T0oooo00<000000?ooo`3oool0;P3oool4000002h0oooo000Z0?ooo`<0000000<0oooo0000003o
ool0<@3oool00`000000oooo0?ooo`1I0?ooo`030000003oool0oooo02l0oooo00<000000?ooo`3o
ool00`00000[0?ooo`009`3oool3000003L0oooo00<000000?ooo`3oool0F@3oool00`000000oooo
0?ooo`0e0?ooo`<00000:03oool002@0oooo0`00000j0?ooo`030000003oool0oooo05T0oooo00<0
00000?ooo`3oool0>03oool3000002D0oooo000Q0?ooo`<00000?P3oool00`000000oooo0?ooo`1G
0?ooo`030000003oool0oooo03`0oooo0`00000R0?ooo`007P3oool300000440oooo00<000000?oo
o`3oool0E`3oool00`000000oooo0?ooo`0o0?ooo`<000007`3oool001/0oooo0`0000140?ooo`03
0000003oool0oooo05L0oooo00<000000?ooo`3oool0@P3oool3000001`0oooo000G0?ooo`@00000
B03oool00`000000oooo0?ooo`1E0?ooo`030000003oool0oooo04H0oooo1000000H0?ooo`00503o
ool3000004`0oooo00<000000?ooo`3oool0E@3oool00`000000oooo0?ooo`1:0?ooo`<000005@3o
ool00140oooo0`00001?0?ooo`030000003oool0oooo05D0oooo00<000000?ooo`3oool0C@3oool3
00000180oooo000>0?ooo`<00000DP3oool00`000000oooo0?ooo`1E0?ooo`030000003oool0oooo
0500oooo0`00000?0?ooo`002`3oool3000005H0oooo00<000000?ooo`3oool0D`3oool00`000000
oooo0?ooo`1D0?ooo`<00000303oool000H0oooo00<000000?ooo`0000000P00001I0?ooo`030000
003oool0oooo05<0oooo00<000000?ooo`3oool0E`3oool4000000P0oooo00060?ooo`800000G03o
ool00`000000oooo0?ooo`1C0?ooo`030000003oool0oooo05X0oooo0P0000070?ooo`00I@3oool0
0`000000oooo0?ooo`1A0?ooo`030000003oool0oooo06@0oooo001U0?ooo`030000003oool0oooo
0540oooo00<000000?ooo`3oool0I03oool006D0oooo00<000000?ooo`3oool0D@3oool00`000000
oooo0?ooo`1T0?ooo`00I@3oool00`000000oooo0?ooo`1A0?ooo`030000003oool0oooo06@0oooo
001V0?ooo`030000003oool0oooo04l0oooo00<000000?ooo`3oool0I@3oool006H0oooo00<00000
0?ooo`3oool0C`3oool00`000000oooo0?ooo`1U0?ooo`00IP3oool00`000000oooo0?ooo`1?0?oo
o`030000003oool0oooo06D0oooo001W0?ooo`030000003oool0oooo04d0oooo00<000000?ooo`3o
ool0IP3oool006L0oooo00<000000?ooo`3oool0C@3oool00`000000oooo0?ooo`1V0?ooo`00I`3o
ool00`000000oooo0?ooo`1=0?ooo`030000003oool0oooo06H0oooo001W0?ooo`030000003oool0
oooo04d0oooo00<000000?ooo`3oool0IP3oool006P0oooo00<000000?ooo`3oool0B`3oool00`00
0000oooo0?ooo`1W0?ooo`00J03oool00`000000oooo0?ooo`1;0?ooo`030000003oool0oooo06L0
oooo001X0?ooo`030000003oool0oooo04/0oooo00<000000?ooo`3oool0I`3oool006T0oooo00<0
00000?ooo`3oool0B@3oool00`000000oooo0?ooo`1X0?ooo`00J@3oool00`000000oooo0?ooo`19
0?ooo`030000003oool0oooo06P0oooo001Y0?ooo`030000003oool0oooo04T0oooo00<000000?oo
o`3oool0J03oool006T0oooo00<000000?ooo`3oool0B@3oool00`000000oooo0?ooo`1X0?ooo`00
JP3oool00`000000oooo0?ooo`170?ooo`030000003oool0oooo06T0oooo001Z0?ooo`030000003o
ool0oooo04L0oooo00<000000?ooo`3oool0J@3oool006X0oooo00<000000?ooo`3oool0A`3oool0
0`000000oooo0?ooo`1Y0?ooo`00J`3oool00`000000oooo0?ooo`150?ooo`030000003oool0oooo
06X0oooo001[0?ooo`030000003oool0oooo04D0oooo00<000000?ooo`3oool0JP3oool006/0oooo
00<000000?ooo`3oool0A@3oool00`000000oooo0?ooo`1Z0?ooo`00J`3oool00`000000oooo0?oo
o`150?ooo`030000003oool0oooo06X0oooo001/0?ooo`030000003oool0oooo04<0oooo00<00000
0?ooo`3oool0J`3oool006`0ooooA`00001]0?ooo`00K03oool00`000000oooo0?ooo`0O0?ooo`03
0000003oool0oooo0200oooo0P00001]0?ooo`00J`3oool00`000000oooo0?ooo`150?ooo`030000
003oool0oooo06X0oooo001[0?ooo`030000003oool0oooo04D0oooo00<000000?ooo`3oool0JP3o
ool006/0oooo00<000000?ooo`3oool0A@3oool00`000000oooo0?ooo`1Z0?ooo`00J`3oool00`00
0000oooo0?ooo`150?ooo`030000003oool0oooo06X0oooo001Z0?ooo`030000003oool0oooo04L0
oooo00<000000?ooo`3oool0J@3oool006X0oooo00<000000?ooo`3oool0A`3oool00`000000oooo
0?ooo`1Y0?ooo`00JP3oool00`000000oooo0?ooo`170?ooo`030000003oool0oooo06T0oooo001Y
0?ooo`030000003oool0oooo04T0oooo00<000000?ooo`3oool0J03oool006T0oooo00<000000?oo
o`3oool0B@3oool00`000000oooo0?ooo`1X0?ooo`00J@3oool00`000000oooo0?ooo`190?ooo`03
0000003oool0oooo06P0oooo001Y0?ooo`030000003oool0oooo04T0oooo00<000000?ooo`3oool0
J03oool006P0oooo00<000000?ooo`3oool0B`3oool00`000000oooo0?ooo`1W0?ooo`00J03oool0
0`000000oooo0?ooo`1;0?ooo`030000003oool0oooo06L0oooo001X0?ooo`030000003oool0oooo
04/0oooo00<000000?ooo`3oool0I`3oool006L0oooo00<000000?ooo`3oool0C@3oool00`000000
oooo0?ooo`1V0?ooo`00I`3oool00`000000oooo0?ooo`1=0?ooo`030000003oool0oooo06H0oooo
001W0?ooo`030000003oool0oooo04d0oooo00<000000?ooo`3oool0IP3oool006L0oooo00<00000
0?ooo`3oool0C@3oool00`000000oooo0?ooo`1V0?ooo`00IP3oool00`000000oooo0?ooo`1?0?oo
o`030000003oool0oooo06D0oooo001V0?ooo`030000003oool0oooo04l0oooo00<000000?ooo`3o
ool0I@3oool006H0oooo00<000000?ooo`3oool0C`3oool00`000000oooo0?ooo`1U0?ooo`00I@3o
ool00`000000oooo0?ooo`1A0?ooo`030000003oool0oooo06@0oooo001U0?ooo`030000003oool0
oooo0540oooo00<000000?ooo`3oool0I03oool006D0oooo00<000000?ooo`3oool0D@3oool00`00
0000oooo0?ooo`1T0?ooo`00I@3oool00`000000oooo0?ooo`1A0?ooo`030000003oool0oooo06@0
oooo00060?ooo`800000G03oool00`000000oooo0?ooo`1C0?ooo`030000003oool0oooo05X0oooo
0P0000070?ooo`001P3oool00`000000oooo00000002000005T0oooo00<000000?ooo`3oool0D`3o
ool00`000000oooo0?ooo`1G0?ooo`@00000203oool000/0oooo0`00001F0?ooo`030000003oool0
oooo05<0oooo00<000000?ooo`3oool0E03oool3000000`0oooo000>0?ooo`<00000DP3oool00`00
0000oooo0?ooo`1E0?ooo`030000003oool0oooo0500oooo0`00000?0?ooo`004@3oool3000004l0
oooo00<000000?ooo`3oool0E@3oool00`000000oooo0?ooo`1=0?ooo`<000004P3oool001@0oooo
0`00001<0?ooo`030000003oool0oooo05D0oooo00<000000?ooo`3oool0BP3oool3000001D0oooo
000G0?ooo`<00000B@3oool00`000000oooo0?ooo`1E0?ooo`030000003oool0oooo04L0oooo0`00
000H0?ooo`006P3oool4000004@0oooo00<000000?ooo`3oool0E`3oool00`000000oooo0?ooo`12
0?ooo`@000006`3oool001h0oooo0`0000110?ooo`030000003oool0oooo05L0oooo00<000000?oo
o`3oool0?`3oool3000001l0oooo000Q0?ooo`<00000?P3oool00`000000oooo0?ooo`1G0?ooo`03
0000003oool0oooo03`0oooo0`00000R0?ooo`00903oool3000003X0oooo00<000000?ooo`3oool0
F@3oool00`000000oooo0?ooo`0h0?ooo`<000009@3oool002L0oooo0`00000g0?ooo`030000003o
ool0oooo05T0oooo00<000000?ooo`3oool0=@3oool3000002P0oooo000Z0?ooo`<00000=03oool0
0`000000oooo0?ooo`1I0?ooo`030000003oool0oooo0380oooo0`00000[0?ooo`00;@3oool40000
0300oooo00<000000?ooo`3oool0F@3oool00`000000oooo0?ooo`0^0?ooo`@00000;P3oool002d0
oooo0P0000020?ooo`D00000:P3oool00`000000oooo0?ooo`1K0?ooo`030000003oool0oooo02P0
oooo1@000000103oool000000?ooo`00000^0?ooo`00;@3oool00`000000oooo0?ooo`060?ooo`H0
0000903oool00`000000oooo0?ooo`1K0?ooo`030000003oool0oooo0280oooo1P0000080?ooo`03
0000003oool0oooo02`0oooo000/0?ooo`030000003oool0oooo00d0oooo1@00000O0?ooo`030000
003oool0oooo05/0oooo00<000000?ooo`3oool07@3oool5000000l0oooo00<000000?ooo`3oool0
:`3oool002`0oooo00<000000?ooo`3oool04P3oool5000001T0oooo00<000000?ooo`3oool0G@3o
ool00`000000oooo0?ooo`0G0?ooo`D00000503oool00`000000oooo0?ooo`0[0?ooo`00:`3oool0
0`000000oooo0?ooo`0H0?ooo`H000004`3oool00`000000oooo0?ooo`1M0?ooo`030000003oool0
oooo0140oooo1P00000J0?ooo`030000003oool0oooo02X0oooo000[0?ooo`030000003oool0oooo
01h0oooo1@00000>0?ooo`030000003oool0oooo05d0oooo00<000000?ooo`3oool0303oool50000
0200oooo00<000000?ooo`3oool0:P3oool002X0oooo00<000000?ooo`3oool0903oool5000000T0
oooo00<000000?ooo`3oool0G@3oool00`000000oooo0?ooo`070?ooo`D000009P3oool00`000000
oooo0?ooo`0Y0?ooo`00:P3oool00`000000oooo0?ooo`0Y0?ooo`H000000P3oool00`000000oooo
0?ooo`1O0?ooo`030000003oool0oooo00H00000:`3oool00`000000oooo0?ooo`0Y0?ooo`00:@3o
ool00`000000oooo0?ooo`0`0?ooo`<00000H@3oool300000380oooo00<000000?ooo`3oool0:03o
ool002T0oooo00<000000?ooo`3oool0<@3oool200000640oooo00<000000?ooo`3oool0<P3oool0
0`000000oooo0?ooo`0X0?ooo`00:03oool00`000000oooo0?ooo`0c0?ooo`030000003oool0oooo
05l0oooo00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`0W0?ooo`00:03oool00`000000
oooo0?ooo`0d0?ooo`030000003oool0oooo05d0oooo00<000000?ooo`3oool0=03oool00`000000
oooo0?ooo`0W0?ooo`009`3oool00`000000oooo0?ooo`0e0?ooo`030000003oool0oooo05d0oooo
00<000000?ooo`3oool0=@3oool00`000000oooo0?ooo`0V0?ooo`009`3oool00`000000oooo0?oo
o`0e0?ooo`030000003oool0oooo05d0oooo00<000000?ooo`3oool0=@3oool00`000000oooo0?oo
o`0V0?ooo`009P3oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo05d0oooo00<00000
0?ooo`3oool0=P3oool00`000000oooo0?ooo`0U0?ooo`009P3oool00`000000oooo0?ooo`0f0?oo
o`030000003oool0oooo05d0oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`0U0?oo
o`009@3oool00`000000oooo0?ooo`0g0?ooo`030000003oool0oooo05`0oooo00<000000?ooo`3o
ool0>03oool00`000000oooo0?ooo`0T0?ooo`009@3oool00`000000oooo0?ooo`0h0?ooo`030000
003oool0oooo05/0oooo00<000000?ooo`3oool0>03oool00`000000oooo0?ooo`0T0?ooo`00903o
ool00`000000oooo0?ooo`0i0?ooo`030000003oool0oooo05/0oooo00<000000?ooo`3oool0>@3o
ool00`000000oooo0?ooo`0S0?ooo`00903oool00`000000oooo0?ooo`0i0?ooo`030000003oool0
oooo05/0oooo00<000000?ooo`3oool0>@3oool00`000000oooo0?ooo`0S0?ooo`008`3oool00`00
0000oooo0?ooo`0j0?ooo`030000003oool0oooo05/0oooo00<000000?ooo`3oool0>P3oool00`00
0000oooo0?ooo`0R0?ooo`008`3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo05/0
oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0R0?ooo`008P3oool00`000000oooo
0?ooo`0l0?ooo`030000003oool0oooo05T0oooo00<000000?ooo`3oool0?03oool00`000000oooo
0?ooo`0Q0?ooo`008P3oool00`000000oooo0?ooo`0l0?ooo`030000003oool0oooo05T0oooo00<0
00000?ooo`3oool0?03oool00`000000oooo0?ooo`0Q0?ooo`008@3oool00`000000oooo0?ooo`0m
0?ooo`030000003oool0oooo05T0oooo00<000000?ooo`3oool0?@3oool00`000000oooo0?ooo`0P
0?ooo`008@3oool00`000000oooo0?ooo`0m0?ooo`030000003oool0oooo05T0oooo00<000000?oo
o`3oool0?@3oool00`000000oooo0?ooo`0P0?ooo`00803oool00`000000oooo0?ooo`0n0?ooo`03
0000003oool0oooo05T0oooo00<000000?ooo`3oool0?P3oool00`000000oooo0?ooo`0O0?ooo`00
803oool00`000000oooo0?ooo`0o0?ooo`030000003oool0oooo05L0oooo00<000000?ooo`3oool0
?`3oool00`000000oooo0?ooo`0O0?ooo`007`3oool00`000000oooo0?ooo`100?ooo`030000003o
ool0oooo05L0oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`0N0?ooo`007`3oool0
0`000000oooo0?ooo`100?ooo`030000003oool0oooo05L0oooo00<000000?ooo`3oool0@03oool0
0`000000oooo0?ooo`0N0?ooo`007P3oool00`000000oooo0?ooo`110?ooo`030000003oool0oooo
05L0oooo00<000000?ooo`3oool0@@3oool00`000000oooo0?ooo`0M0?ooo`007P3oool00`000000
oooo0?ooo`110?ooo`030000003oool0oooo05L0oooo00<000000?ooo`3oool0@@3oool00`000000
oooo0?ooo`0M0?ooo`007@3oool00`000000oooo0?ooo`120?ooo`030000003oool0oooo05H0oooo
00<000000?ooo`3oool0@`3oool00`000000oooo0?ooo`0L0?ooo`007@3oool00`000000oooo0?oo
o`130?ooo`030000003oool0oooo05D0oooo00<000000?ooo`3oool0@`3oool00`000000oooo0?oo
o`0L0?ooo`00703oool00`000000oooo0?ooo`140?ooo`030000003oool0oooo05D0oooo00<00000
0?ooo`3oool0A03oool00`000000oooo0?ooo`0K0?ooo`00703oool00`000000oooo0?ooo`140?oo
o`030000003oool0oooo05D0oooo00<000000?ooo`3oool0A03oool00`000000oooo0?ooo`0K0?oo
o`006`3oool00`000000oooo0?ooo`150?ooo`030000003oool0oooo05D0oooo00<000000?ooo`3o
ool0A03oool2000001`0oooo000K0?ooo`030000003oool0oooo04D0oooo00<000000?ooo`3oool0
E@3oool00`000000oooo0?ooo`140?ooo`030000003oool0oooo01/0oooo001T0?ooo`030000003o
ool0oooo05<0oooo00<000000?ooo`3oool0H`3oool006@0oooo00<000000?ooo`3oool0D`3oool0
0`000000oooo0?ooo`1S0?ooo`00I03oool00`000000oooo0?ooo`1C0?ooo`030000003oool0oooo
06<0oooo001T0?ooo`030000003oool0oooo05<0oooo00<000000?ooo`3oool0H`3oool006@0oooo
00<000000?ooo`3oool0D`3oool00`000000oooo0?ooo`1S0?ooo`00I@3oool00`000000oooo0?oo
o`1A0?ooo`030000003oool0oooo06@0oooo001U0?ooo`030000003oool0oooo0540oooo00<00000
0?ooo`3oool0I03oool006D0oooo00<000000?ooo`3oool0D@3oool00`000000oooo0?ooo`1T0?oo
o`00I@3oool00`000000oooo0?ooo`1A0?ooo`030000003oool0oooo06@0oooo001U0?ooo`030000
003oool0oooo0540oooo00<000000?ooo`3oool0I03oool006D0oooo00<000000?ooo`3oool0D03o
ool00`000000oooo0?ooo`1U0?ooo`00IP3oool00`000000oooo0?ooo`1?0?ooo`030000003oool0
oooo06D0oooo001V0?ooo`030000003oool0oooo04l0oooo00<000000?ooo`3oool0I@3oool006H0
oooo00<000000?ooo`3oool0C`3oool00`000000oooo0?ooo`1U0?ooo`00IP3oool00`000000oooo
0?ooo`1?0?ooo`030000003oool0oooo06D0oooo001V0?ooo`030000003oool0oooo04l0oooo00<0
00000?ooo`3oool0I@3oool006L0oooo00<000000?ooo`3oool0C@3oool00`000000oooo0?ooo`1V
0?ooo`00IP3oool2000004h0oooo0P00001X0?ooo`00IP3oool2000004h0oooo0P00001X0?ooo`00
I@3oool3000004l0oooo0`00001V0?ooo`00H`3oool2000000<0oooo00<000000?ooo`3oool0B`3o
ool010000000oooo0?ooo`3oool2000006@0oooo001Q0?ooo`8000001@3oool00`000000oooo0?oo
o`1;0?ooo`030000003oool0oooo00<0oooo0P00001R0?ooo`00G`3oool2000000L0oooo00<00000
0?ooo`3oool0B`3oool00`000000oooo0?ooo`050?ooo`800000H03oool005d0oooo0P00000:0?oo
o`030000003oool0oooo04T0oooo00<000000?ooo`3oool0203oool2000005h0oooo001K0?ooo`80
0000303oool00`000000oooo0?ooo`190?ooo`030000003oool0oooo00X0oooo0P00001L0?ooo`00
F@3oool2000000h0oooo00<000000?ooo`3oool0B@3oool00`000000oooo0?ooo`0<0?ooo`800000
FP3oool005L0oooo0P00000A0?ooo`030000003oool0oooo04L0oooo00<000000?ooo`3oool03`3o
ool2000005P0oooo001E0?ooo`8000004`3oool00`000000oooo0?ooo`170?ooo`030000003oool0
oooo0140oooo0P00001F0?ooo`00D`3oool2000001D0oooo00<000000?ooo`3oool0A`3oool00`00
0000oooo0?ooo`0C0?ooo`800000E03oool00540oooo0P00000H0?ooo`030000003oool0oooo04D0
oooo00<000000?ooo`3oool05P3oool200000580oooo001?0?ooo`8000006P3oool00`000000oooo
0?ooo`150?ooo`030000003oool0oooo01P0oooo0P00001@0?ooo`00C@3oool2000001`0oooo00<0
00000?ooo`3oool0A@3oool00`000000oooo0?ooo`0J0?ooo`800000CP3oool004/0oooo0P00000O
0?ooo`030000003oool0oooo04<0oooo00<000000?ooo`3oool07@3oool2000004`0oooo00190?oo
o`8000008@3oool00`000000oooo0?ooo`130?ooo`030000003oool0oooo01l0oooo0P00001:0?oo
o`00A`3oool2000002<0oooo00<000000?ooo`3oool0@`3oool00`000000oooo0?ooo`0Q0?ooo`80
0000B03oool004D0oooo0P00000V0?ooo`030000003oool0oooo0440oooo00<000000?ooo`3oool0
903oool2000004H0oooo00110?ooo`040000003oool00000000002P0oooo00<000000?ooo`3oool0
@@3oool00`000000oooo0?ooo`0V0?ooo`<00000@`3oool00440oooo0P00000Z0?ooo`030000003o
ool0oooo0440oooo00<000000?ooo`3oool0:03oool00`000000oooo0?ooo`110?ooo`00K@3oool0
0`000000oooo0?ooo`100?ooo`030000003oool0oooo06d0oooo001^0?ooo`030000003oool0oooo
03l0oooo00<000000?ooo`3oool0K@3oool006h0oooo00<000000?ooo`3oool0?`3oool00`000000
oooo0?ooo`1]0?ooo`00KP3oool00`000000oooo0?ooo`0o0?ooo`030000003oool0oooo06d0oooo
001_0?ooo`030000003oool0oooo03d0oooo00<000000?ooo`3oool0KP3oool006l0oooo00<00000
0?ooo`3oool0?@3oool00`000000oooo0?ooo`1^0?ooo`00K`3oool00`000000oooo0?ooo`0m0?oo
o`030000003oool0oooo06h0oooo001`0?ooo`030000003oool0oooo03/0oooo00<000000?ooo`3o
ool0K`3oool00700oooo00<000000?ooo`3oool0>`3oool00`000000oooo0?ooo`1_0?ooo`00L03o
ool00`000000oooo0?ooo`0k0?ooo`030000003oool0oooo06l0oooo001a0?ooo`030000003oool0
oooo03T0oooo00<000000?ooo`3oool0L03oool00740oooo00<000000?ooo`3oool0>@3oool00`00
0000oooo0?ooo`1`0?ooo`00L@3oool00`000000oooo0?ooo`0i0?ooo`030000003oool0oooo0700
oooo001b0?ooo`030000003oool0oooo03L0oooo00<000000?ooo`3oool0L@3oool00780oooo00<0
00000?ooo`3oool0=`3oool00`000000oooo0?ooo`1a0?ooo`00LP3oool00`000000oooo0?ooo`0g
0?ooo`030000003oool0oooo0740oooo001c0?ooo`030000003oool0oooo03D0oooo00<000000?oo
o`3oool0LP3oool007<0oooo00<000000?ooo`3oool0=@3oool00`000000oooo0?ooo`1b0?ooo`00
L`3oool00`000000oooo0?ooo`0e0?ooo`030000003oool0oooo0780oooo001c0?ooo`800000=@3o
ool00`000000oooo0?ooo`1c0?ooo`00L`3oool2000003D0oooo00<000000?ooo`3oool0L`3oool0
0?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool0
0?l0oooo8@3oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-1.05001, -1.05001, 0.00731715, \
0.00731715}}]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["GraphDistance",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["g",
                  "TI"], 
                StyleBox[",",
                  "TI",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  "TI",
                  FontSlant->"Italic"], 
                StyleBox["i",
                  "TI",
                  FontSlant->"Italic"], 
                StyleBox[",",
                  "TI",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  "TI",
                  FontSlant->"Italic"], 
                StyleBox["j",
                  "TI",
                  FontSlant->"Italic"]}], 
              StyleBox["]",
                "MR"]}], Cell[TextData[{
              "calculates the graph distance between vertices ",
              StyleBox["i",
                FontSlant->"Italic"],
              " and ",
              StyleBox["j",
                FontSlant->"Italic"]
            }], "Text"]},
          {
            RowBox[{
              StyleBox["PseudoDiameter",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["g",
                FontSlant->"Italic"], 
              StyleBox["]",
                
                "MR"]}], \(gives\ the\ pseudo\[Hyphen]diameter\ of\ an\ \
undirected\ graph\)}
          }], TextForm]], "DefinitionBox",
  CellTags->"i:5"],

Cell["Calculating graph distance and diameter. ", "Caption"],

Cell["This plots a graph of 37 vertices.", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"GraphPlot", "[", 
        RowBox[{
          
          TagBox[\(g = {1 \[Rule] 2, 1 \[Rule] 6, 1 \[Rule] 7, 2 \[Rule] 3, 
                2 \[Rule] 7, 3 \[Rule] 30, 3 \[Rule] 26, 3 \[Rule] 4, 
                3 \[Rule] 32, 4 \[Rule] 5, 4 \[Rule] 9, 5 \[Rule] 9, 
                5 \[Rule] 10, 6 \[Rule] 7, 6 \[Rule] 11, 7 \[Rule] 8, 
                7 \[Rule] 30, 7 \[Rule] 12, 8 \[Rule] 9, 8 \[Rule] 26, 
                8 \[Rule] 13, 9 \[Rule] 10, 9 \[Rule] 32, 9 \[Rule] 14, 
                10 \[Rule] 15, 11 \[Rule] 16, 11 \[Rule] 27, 11 \[Rule] 30, 
                11 \[Rule] 35, 12 \[Rule] 13, 12 \[Rule] 17, 12 \[Rule] 27, 
                13 \[Rule] 31, 13 \[Rule] 33, 13 \[Rule] 14, 13 \[Rule] 36, 
                13 \[Rule] 18, 13 \[Rule] 34, 14 \[Rule] 28, 14 \[Rule] 19, 
                15 \[Rule] 32, 15 \[Rule] 28, 15 \[Rule] 37, 15 \[Rule] 20, 
                16 \[Rule] 17, 16 \[Rule] 21, 17 \[Rule] 21, 17 \[Rule] 22, 
                17 \[Rule] 35, 17 \[Rule] 18, 18 \[Rule] 19, 18 \[Rule] 29, 
                19 \[Rule] 37, 19 \[Rule] 20, 19 \[Rule] 24, 19 \[Rule] 25, 
                20 \[Rule] 25, 21 \[Rule] 22, 22 \[Rule] 23, 23 \[Rule] 24, 
                23 \[Rule] 29, 23 \[Rule] 35, 23 \[Rule] 37, 24 \[Rule] 25, 
                30 \[Rule] 31, 32 \[Rule] 33, 34 \[Rule] 35, 
                36 \[Rule] 37}\),
            (Short[ #, 1000]&)], 
          ",", \(VertexStyleFunction \[Rule] Automatic\)}], "]"}], 
      ";"}]], "Input",
  CellLabel->"In[21]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .99513 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.500237 0.476428 0.498418 0.476428 [
[.19438 .96009 -3 -4.5 ]
[.19438 .96009 3 4.5 ]
[.1194 .80713 -3 -4.5 ]
[.1194 .80713 3 4.5 ]
[.35948 .97143 -3 -4.5 ]
[.35948 .97143 3 4.5 ]
[.28926 .81398 -3 -4.5 ]
[.28926 .81398 3 4.5 ]
[.13435 .56861 -3 -4.5 ]
[.13435 .56861 3 4.5 ]
[.33267 .74284 -6 -4.5 ]
[.33267 .74284 6 4.5 ]
[.02711 .5986 -6 -4.5 ]
[.02711 .5986 6 4.5 ]
[.02381 .35984 -3 -4.5 ]
[.02381 .35984 3 4.5 ]
[.25194 .32854 -6 -4.5 ]
[.25194 .32854 6 4.5 ]
[.03541 .1924 -3 -4.5 ]
[.03541 .1924 3 4.5 ]
[.18212 .28696 -3 -4.5 ]
[.18212 .28696 3 4.5 ]
[.19054 .1159 -6 -4.5 ]
[.19054 .1159 6 4.5 ]
[.56904 .86344 -6 -4.5 ]
[.56904 .86344 6 4.5 ]
[.2384 .55063 -3 -4.5 ]
[.2384 .55063 3 4.5 ]
[.55111 .75912 -6 -4.5 ]
[.55111 .75912 6 4.5 ]
[.50048 .49726 -6 -4.5 ]
[.50048 .49726 6 4.5 ]
[.44839 .23549 -6 -4.5 ]
[.44839 .23549 6 4.5 ]
[.43027 .13177 -6 -4.5 ]
[.43027 .13177 6 4.5 ]
[.80639 .88196 -6 -4.5 ]
[.80639 .88196 6 4.5 ]
[.59642 .97093 -6 -4.5 ]
[.59642 .97093 6 4.5 ]
[.74563 .66636 -6 -4.5 ]
[.74563 .66636 6 4.5 ]
[.81541 .71126 -6 -4.5 ]
[.81541 .71126 6 4.5 ]
[.40829 .64049 -6 -4.5 ]
[.40829 .64049 6 4.5 ]
[.35567 .39917 -6 -4.5 ]
[.35567 .39917 6 4.5 ]
[.59808 .35323 -6 -4.5 ]
[.59808 .35323 6 4.5 ]
[.76402 .44743 -6 -4.5 ]
[.76402 .44743 6 4.5 ]
[.63963 .59837 -6 -4.5 ]
[.63963 .59837 6 4.5 ]
[.40363 .02369 -6 -4.5 ]
[.40363 .02369 6 4.5 ]
[.71344 .18205 -6 -4.5 ]
[.71344 .18205 6 4.5 ]
[.66963 .25133 -6 -4.5 ]
[.66963 .25133 6 4.5 ]
[.64246 .02505 -6 -4.5 ]
[.64246 .02505 6 4.5 ]
[.95989 .80821 -6 -4.5 ]
[.95989 .80821 6 4.5 ]
[.97374 .64129 -6 -4.5 ]
[.97374 .64129 6 4.5 ]
[.97619 .40177 -6 -4.5 ]
[.97619 .40177 6 4.5 ]
[.8841 .18992 -6 -4.5 ]
[.8841 .18992 6 4.5 ]
[.81029 .03737 -6 -4.5 ]
[.81029 .03737 6 4.5 ]
[.86735 .42892 -6 -4.5 ]
[.86735 .42892 6 4.5 ]
[ 0 0 0 0 ]
[ 1 .99513 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.19438 .96009 m
.1194 .80713 L
s
.19438 .96009 m
.35948 .97143 L
s
.19438 .96009 m
.28926 .81398 L
s
.1194 .80713 m
.13435 .56861 L
s
.1194 .80713 m
.28926 .81398 L
s
.35948 .97143 m
.28926 .81398 L
s
.35948 .97143 m
.56904 .86344 L
s
.28926 .81398 m
.2384 .55063 L
s
.28926 .81398 m
.33267 .74284 L
s
.28926 .81398 m
.55111 .75912 L
s
.13435 .56861 m
.33267 .74284 L
s
.13435 .56861 m
.02711 .5986 L
s
.13435 .56861 m
.02381 .35984 L
s
.13435 .56861 m
.25194 .32854 L
s
.33267 .74284 m
.40829 .64049 L
s
.02381 .35984 m
.03541 .1924 L
s
.02381 .35984 m
.18212 .28696 L
s
.25194 .32854 m
.35567 .39917 L
s
.03541 .1924 m
.18212 .28696 L
s
.03541 .1924 m
.19054 .1159 L
s
.18212 .28696 m
.19054 .1159 L
s
.18212 .28696 m
.25194 .32854 L
s
.18212 .28696 m
.44839 .23549 L
s
.19054 .1159 m
.43027 .13177 L
s
.56904 .86344 m
.80639 .88196 L
s
.56904 .86344 m
.59642 .97093 L
s
.56904 .86344 m
.33267 .74284 L
s
.56904 .86344 m
.74563 .66636 L
s
.2384 .55063 m
.18212 .28696 L
s
.2384 .55063 m
.02711 .5986 L
s
.2384 .55063 m
.50048 .49726 L
s
.55111 .75912 m
.50048 .49726 L
s
.55111 .75912 m
.81541 .71126 L
s
.55111 .75912 m
.59642 .97093 L
s
.50048 .49726 m
.40829 .64049 L
s
.50048 .49726 m
.35567 .39917 L
s
.50048 .49726 m
.44839 .23549 L
s
.50048 .49726 m
.59808 .35323 L
s
.50048 .49726 m
.76402 .44743 L
s
.50048 .49726 m
.63963 .59837 L
s
.44839 .23549 m
.40363 .02369 L
s
.44839 .23549 m
.71344 .18205 L
s
.43027 .13177 m
.25194 .32854 L
s
.43027 .13177 m
.40363 .02369 L
s
.43027 .13177 m
.66963 .25133 L
s
.43027 .13177 m
.64246 .02505 L
s
.80639 .88196 m
.81541 .71126 L
s
.80639 .88196 m
.95989 .80821 L
s
.81541 .71126 m
.95989 .80821 L
s
.81541 .71126 m
.97374 .64129 L
s
.81541 .71126 m
.74563 .66636 L
s
.81541 .71126 m
.76402 .44743 L
s
.59808 .35323 m
.66963 .25133 L
s
.76402 .44743 m
.71344 .18205 L
s
.76402 .44743 m
.97619 .40177 L
s
.63963 .59837 m
.74563 .66636 L
s
.71344 .18205 m
.66963 .25133 L
s
.71344 .18205 m
.64246 .02505 L
s
.71344 .18205 m
.8841 .18992 L
s
.71344 .18205 m
.81029 .03737 L
s
.64246 .02505 m
.81029 .03737 L
s
.95989 .80821 m
.97374 .64129 L
s
.97374 .64129 m
.86735 .42892 L
s
.8841 .18992 m
.81029 .03737 L
s
.86735 .42892 m
.8841 .18992 L
s
.86735 .42892 m
.97619 .40177 L
s
.86735 .42892 m
.74563 .66636 L
s
.86735 .42892 m
.66963 .25133 L
s
[(1)] .19438 .96009 0 0 Mshowa
[(2)] .1194 .80713 0 0 Mshowa
[(6)] .35948 .97143 0 0 Mshowa
[(7)] .28926 .81398 0 0 Mshowa
[(3)] .13435 .56861 0 0 Mshowa
[(30)] .33267 .74284 0 0 Mshowa
[(26)] .02711 .5986 0 0 Mshowa
[(4)] .02381 .35984 0 0 Mshowa
[(32)] .25194 .32854 0 0 Mshowa
[(5)] .03541 .1924 0 0 Mshowa
[(9)] .18212 .28696 0 0 Mshowa
[(10)] .19054 .1159 0 0 Mshowa
[(11)] .56904 .86344 0 0 Mshowa
[(8)] .2384 .55063 0 0 Mshowa
[(12)] .55111 .75912 0 0 Mshowa
[(13)] .50048 .49726 0 0 Mshowa
[(14)] .44839 .23549 0 0 Mshowa
[(15)] .43027 .13177 0 0 Mshowa
[(16)] .80639 .88196 0 0 Mshowa
[(27)] .59642 .97093 0 0 Mshowa
[(35)] .74563 .66636 0 0 Mshowa
[(17)] .81541 .71126 0 0 Mshowa
[(31)] .40829 .64049 0 0 Mshowa
[(33)] .35567 .39917 0 0 Mshowa
[(36)] .59808 .35323 0 0 Mshowa
[(18)] .76402 .44743 0 0 Mshowa
[(34)] .63963 .59837 0 0 Mshowa
[(28)] .40363 .02369 0 0 Mshowa
[(19)] .71344 .18205 0 0 Mshowa
[(37)] .66963 .25133 0 0 Mshowa
[(20)] .64246 .02505 0 0 Mshowa
[(21)] .95989 .80821 0 0 Mshowa
[(22)] .97374 .64129 0 0 Mshowa
[(29)] .97619 .40177 0 0 Mshowa
[(24)] .8841 .18992 0 0 Mshowa
[(25)] .81029 .03737 0 0 Mshowa
[(23)] .86735 .42892 0 0 Mshowa
0 0 m
1 0 L
1 .99513 L
0 .99513 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[21]:=",
  ImageSize->{287.688, 286.25},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004O00017R000`400?l00000o`00003oo`3ooolP
0?ooo`00o`3ooolP0?ooo`00o`3ooolP0?ooo`00o`3ooolP0?ooo`00o`3ooolP0?ooo`00KP3oool4
000000<0oooo0P00000l0?ooo`@000000`3oool2000006<0oooo001^0?ooo`030000003oool0oooo
00<0oooo00@000000?ooo`3oool00000>`3oool00`000000oooo0?ooo`030?ooo`040000003oool0
oooo00000680oooo001_0?ooo`040000003oool0oooo0?ooo`8000000P3oool00`000000oooo0?oo
o`0j0?ooo`040000003oool0oooo0?ooo`H00000H@3oool00700oooo00D000000?ooo`3oool00000
0?ooo`02000003h0oooo1@0000020?ooo`030000003oool0000000/00000E@3oool006h0oooo00D0
00000?ooo`3oool000000?ooo`0200000080oooo00<000000?ooo`3oool0>@3oool400000080oooo
00@000000?ooo`3oool000003@3oool<000000d0oooo100000030?ooo`800000<`3oool006l0oooo
0P0000030?ooo`<00000>`3oool4000000<0oooo0`00000J0?ooo``0000000<0oooo0000003oool0
103oool010000000oooo0?ooo`00000b0?ooo`00M03oool00`000000oooo0?ooo`0i0?ooo`800000
203oool00`000000oooo0?ooo`0U0?ooo`L000000`3oool00`000000oooo0?ooo`0`0?ooo`00M03o
ool00`000000oooo0?ooo`0g0?ooo`8000002P3oool00`000000oooo0?ooo`0X0?ooo`050000003o
ool000000000003oool00P00000c0?ooo`00M03oool2000003H0oooo0P00000=0?ooo`030000003o
ool0oooo02D0oooo00<000000?ooo`3oool00P0000000`3oool000000000000d0?ooo`00M03oool2
000003@0oooo0P00000?0?ooo`030000003oool0oooo02H0oooo0`0000020?ooo`@00000<P3oool0
07D0oooo00<000000?ooo`3oool0<03oool200000180oooo00<000000?ooo`3oool09P3oool00`00
0000oooo0?ooo`020?ooo`030000003oool0oooo0380oooo001e0?ooo`030000003oool0oooo02h0
oooo0P00000D0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool00P3oool00`000000
oooo0?ooo`0b0?ooo`00M@3oool2000002d0oooo0P00000F0?ooo`030000003oool0oooo02D0oooo
00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0a0?ooo`00M@3oool2000002/0oooo0P00
000I0?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?oo
o`0a0?ooo`00MP3oool00`000000oooo0?ooo`0W0?ooo`8000006`3oool00`000000oooo0?ooo`0S
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0<03oool007H0oooo00<000000?oo
o`3oool09@3oool2000001h0oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`070?oo
o`030000003oool0oooo0300oooo001f0?ooo`800000903oool200000200oooo00<000000?ooo`3o
ool0803oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo02l0oooo001f0?ooo`800000
8P3oool2000002<0oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`0:0?ooo`030000
003oool0oooo02l0oooo001f0?ooo`800000803oool2000002D0oooo00<000000?ooo`3oool07P3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo02h0oooo001g0?ooo`030000003oool0
oooo01`0oooo0P00000X0?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool0303oool0
0`000000oooo0?ooo`0^0?ooo`00M`3oool2000001/0oooo0P00000Z0?ooo`030000003oool0oooo
01/0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0]0?ooo`00M`3oool2000001T0
oooo0P00000/0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool03P3oool00`000000
oooo0?ooo`0]0?ooo`00M`3oool2000001L0oooo0P00000_0?ooo`030000003oool0oooo01T0oooo
00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0/0?ooo`00M`3oool2000001D0oooo0P00
000a0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?oo
o`0/0?ooo`00N03oool200000180oooo0P00000d0?ooo`030000003oool0oooo01L0oooo00<00000
0?ooo`3oool04P3oool00`000000oooo0?ooo`0[0?ooo`00N03oool200000100oooo0P00000f0?oo
o`030000003oool0oooo01H0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0[0?oo
o`00<@3oool500000080oooo0P00000n0?ooo`8000003P3oool2000003T0oooo00<000000?ooo`3o
ool0503oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo02X0oooo000c0?ooo`050000
003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`0k0?ooo`800000303oool2000003/0
oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo02X0
oooo000c0?ooo`030000003oool0oooo00L00000?03oool2000000T0oooo0P00000n0?ooo`030000
003oool0oooo0180oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0Z0?ooo`00<`3o
ool500000080oooo00<000000?ooo`3oool03P00000^0?ooo`8000001`3oool200000400oooo00<0
00000?ooo`3oool04@3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo02T0oooo000b
0?ooo`8000000P3oool200000080oooo00<000000?ooo`3oool03P3oool>00000200oooo0P000005
0?ooo`800000@P3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo01P0oooo00<00000
0?ooo`3oool0:@3oool00300oooo100000020?ooo`040000003oool00000000001l0oooo3P00000?
0?ooo`D000000P3oool3000004D0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0J
0?ooo`030000003oool0oooo02P0oooo000^0?ooo`8000001P3oool00`000000oooo0?ooo`0^0?oo
o`h000000`3oool2000000060?ooo`00000000000000003oool00000A@3oool00`000000oooo0?oo
o`0>0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool0:03oool002`0oooo0P000008
0?ooo`030000003oool0oooo03`0oooo1`0000030?ooo`030000003oool0oooo04@0oooo00<00000
0?ooo`3oool03@3oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo02L0oooo000Z0?oo
o`8000002P3oool00`000000oooo0?ooo`0o0?ooo`040000003oool000000?ooo`<00000A`3oool0
0`000000oooo0?ooo`0<0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool09`3oool0
02P0oooo0P00000<0?ooo`030000003oool0oooo03l0oooo0`0000020?ooo`<00000A`3oool00`00
0000oooo0?ooo`0:0?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3oool09P3oool002H0
oooo0P00000>0?ooo`030000003oool0oooo03h0oooo0P000000103oool000000?ooo`3oool50000
04D0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0O0?ooo`030000003oool0oooo
02H0oooo000T0?ooo`800000403oool00`000000oooo0?ooo`0n0?ooo`040000003oool0oooo0000
00L0oooo0P0000140?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool08@3oool00`00
0000oooo0?ooo`0U0?ooo`008P3oool200000180oooo00<000000?ooo`3oool0?@3oool00`000000
oooo0?ooo`020?ooo`030000003oool0oooo00H0oooo0P0000120?ooo`030000003oool0oooo00L0
oooo00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`0U0?ooo`00803oool2000001@0oooo
00<000000?ooo`3oool0?@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00P0oooo
0P0000100?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0903oool00`000000oooo
0?ooo`0T0?ooo`007P3oool2000001H0oooo00<000000?ooo`3oool0?03oool00`000000oooo0?oo
o`030?ooo`030000003oool0oooo00X0oooo0P00000o0?ooo`030000003oool0oooo00D0oooo00<0
00000?ooo`3oool0903oool00`000000oooo0?ooo`0T0?ooo`00703oool2000001L0oooo00<00000
0?ooo`3oool0?03oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00`0oooo0P00000m
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0S
0?ooo`006P3oool2000001T0oooo00<000000?ooo`3oool0>`3oool00`000000oooo0?ooo`060?oo
o`030000003oool0oooo00d0oooo0P00000l0?ooo`030000003oool0oooo0080oooo00<000000?oo
o`3oool09`3oool00`000000oooo0?ooo`0S0?ooo`00603oool2000001/0oooo00<000000?ooo`3o
ool0>P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00l0oooo0P00000j0?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3oool0:03oool00`000000oooo0?ooo`0R0?ooo`00
5P3oool2000001d0oooo00<000000?ooo`3oool0>@3oool00`000000oooo0?ooo`080?ooo`030000
003oool0oooo0140oooo0P00000i0?ooo`040000003oool0oooo000002/0oooo00<000000?ooo`3o
ool08P3oool001@0oooo0P00000O0?ooo`030000003oool0oooo03P0oooo00<000000?ooo`3oool0
2@3oool00`000000oooo0?ooo`0C0?ooo`800000<`3oool5000000040?ooo`0000000000000002/0
oooo00<000000?ooo`3oool08@3oool00180oooo0P00000Q0?ooo`030000003oool0oooo03L0oooo
00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0E0?ooo`800000<`3oool00`000000oooo
0?ooo`02000000030?ooo`000000oooo02X0oooo00<000000?ooo`3oool08@3oool00100oooo0P00
000S0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`0F0?ooo`800000<@3oool<000002L0oooo00<000000?ooo`3oool0803oool000T0oooo0P000003
0?ooo`8000009@3oool00`000000oooo0?ooo`0e0?ooo`030000003oool0oooo00d0oooo00<00000
0?ooo`3oool0603oool2000002/0oooo1@000000103oool000000000000000020?ooo`030000003o
ool0oooo0080oooo4000000C0?ooo`D000000`3oool3000001`0oooo00080?ooo`030000003oool0
oooo00<000009`3oool00`000000oooo0?ooo`0d0?ooo`030000003oool0oooo00h0oooo00<00000
0?ooo`3oool06P3oool2000002D0oooo100000040?ooo`030000003oool00000008000000P3oool0
0`000000oooo0?ooo`0B0?oooa0000000`3oool00`000000oooo0?ooo`020?ooo`050000003oool0
oooo0?ooo`0000007@3oool000X0oooo0P00000Y0?ooo`030000003oool0oooo03@0oooo00<00000
0?ooo`3oool03P3oool00`000000oooo0?ooo`0L0?ooo`8000007P3oool5000000L0oooo0`000002
0?ooo`@00000903oool>000001`0oooo00090?ooo`@00000:03oool00`000000oooo0?ooo`0c0?oo
o`030000003oool0oooo00l0oooo00<000000?ooo`3oool07P3oool2000001L0oooo1@00000=0?oo
o`050000003oool0oooo0?ooo`000000;03oool00`000000oooo0?ooo`0200000080oooo00<00000
0?ooo`3oool06`3oool000T0oooo0P0000020?ooo`030000003oool0oooo02D0oooo00<000000?oo
o`3oool0<P3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo01l0oooo0P00000@0?oo
o`D000004P3oool01@000000oooo0?ooo`3oool0000002X0oooo00X000000?ooo`3oool000000?oo
o`000000oooo0000003oool000007@3oool000T0oooo0`0000020?ooo`8000009@3oool00`000000
oooo0?ooo`0a0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool08@3oool2000000X0
oooo1000000F0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0:@3oool200000080
oooo00<000000?ooo`3oool00P00000M0?ooo`002P3oool00`000000oooo0?ooo`030?ooo`030000
003oool0oooo0280oooo00<000000?ooo`3oool0<03oool00`000000oooo0?ooo`0C0?ooo`030000
003oool0oooo02<0oooo0P0000030?ooo`D000006@3oool00`000000oooo0?ooo`030?ooo`030000
003oool0oooo02d0oooo00<000000?ooo`3oool07`3oool000X0oooo00<000000?ooo`3oool0103o
ool200000280oooo00<000000?ooo`3oool0;`3oool00`000000oooo0?ooo`0D0?ooo`030000003o
ool0oooo02<0oooo1@00000N0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0;03o
ool00`000000oooo0?ooo`0O0?ooo`002@3oool00`000000oooo0?ooo`070?ooo`030000003oool0
oooo01l0oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0
oooo01d0oooo1@0000040?ooo`800000703oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo02`0oooo00<000000?ooo`3oool07`3oool000T0oooo00<000000?ooo`3oool0203oool20000
01l0oooo00<000000?ooo`3oool0;@3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo
01T0oooo1000000;0?ooo`8000006@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo
02/0oooo00<000000?ooo`3oool0803oool000T0oooo00<000000?ooo`3oool02P3oool00`000000
oooo0?ooo`0L0?ooo`030000003oool0oooo02`0oooo00<000000?ooo`3oool0603oool00`000000
oooo0?ooo`0D0?ooo`D000004@3oool2000001L0oooo00<000000?ooo`3oool01P3oool00`000000
oooo0?ooo`0[0?ooo`030000003oool0oooo0200oooo00090?ooo`030000003oool0oooo00/0oooo
0P00000L0?ooo`030000003oool0oooo02/0oooo00<000000?ooo`3oool06@3oool00`000000oooo
0?ooo`0?0?ooo`D00000603oool2000001@0oooo00<000000?ooo`3oool01`3oool00`000000oooo
0?ooo`0[0?ooo`030000003oool0oooo0200oooo00090?ooo`030000003oool0oooo00d0oooo00<0
00000?ooo`3oool06@3oool00`000000oooo0?ooo`0Z0?ooo`030000003oool0oooo01X0oooo00<0
00000?ooo`3oool02P3oool5000001l0oooo0P00000B0?ooo`030000003oool0oooo00P0oooo00<0
00000?ooo`3oool0:P3oool00`000000oooo0?ooo`0P0?ooo`002@3oool00`000000oooo0?ooo`0>
0?ooo`8000006@3oool00`000000oooo0?ooo`0Y0?ooo`030000003oool0oooo01L0oooo1P000002
0?ooo`<000000P3oool4000002H0oooo0P00000?0?ooo`030000003oool0oooo00T0oooo00<00000
0?ooo`3oool0:P3oool00`000000oooo0?ooo`0P0?ooo`002@3oool00`000000oooo0?ooo`0@0?oo
o`030000003oool0oooo01H0oooo00<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`0I0?oo
o`040000003oool0oooo00000080oooo1@00000/0?ooo`800000303oool00`000000oooo0?ooo`0:
0?ooo`030000003oool0oooo02X0oooo00<000000?ooo`3oool0803oool000T0oooo00<000000?oo
o`3oool04@3oool2000001H0oooo00<000000?ooo`3oool0:03oool00`000000oooo0?ooo`0J0?oo
o`T00000<03oool2000000X0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0Z0?oo
o`030000003oool0oooo0200oooo00090?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3o
ool04`3oool00`000000oooo0?ooo`0W0?ooo`030000003oool0oooo01L0oooo1@0000020?ooo`80
00000P3oool00`000000oooo0?ooo`0a0?ooo`8000001`3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo02X0oooo00<000000?ooo`3oool0803oool000T0oooo00<000000?ooo`3oool0
503oool2000001<0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0C0?ooo`D00000
103oool020000000oooo0?ooo`000000oooo0000003oool00000=@3oool3000000<0oooo00<00000
0?ooo`0000003@3oool00`000000oooo0?ooo`0Y0?ooo`030000003oool0oooo0200oooo00090?oo
o`030000003oool0oooo01H0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0V0?oo
o`030000003oool0oooo00l0oooo1@0000080?ooo`8000000`3oool010000000oooo00000000000e
0?ooo`040000003oool0000000000080oooo00<000000?ooo`0000003@3oool00`000000oooo0?oo
o`0Y0?ooo`030000003oool0oooo0200oooo00090?ooo`030000003oool0oooo01L0oooo0P00000?
0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool02`3oool500000180oooo00<00000
0?ooo`3oool0>03oool010000000oooo0000000000020?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool0:@3oool00`000000oooo0?ooo`0P0?ooo`00203oool00`000000oooo0?ooo`0J
0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`07
0?ooo`D000005`3oool00`000000oooo0?ooo`0i0?ooo`80000000D0oooo0000003oool0oooo0000
000<0?ooo`030000003oool0oooo02T0oooo00<000000?ooo`3oool0803oool000P0oooo00<00000
0?ooo`3oool06`3oool2000000`0oooo00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`03
0?ooo`D00000703oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo0080000000D0oooo
000000000000oooo0000000<0?ooo`030000003oool0oooo02T0oooo00<000000?ooo`3oool0803o
ool000P0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`090?ooo`030000003oool0
oooo0280oooo00<000000?ooo`0000001000000Q0?ooo`030000003oool0oooo03L0oooo0`000002
0?ooo`@00000303oool00`000000oooo0?ooo`0Y0?ooo`030000003oool0oooo0200oooo00080?oo
o`030000003oool0oooo01h0oooo0P0000090?ooo`030000003oool0oooo01h0oooo1P00000W0?oo
o`030000003oool0oooo03L0oooo00<000000?ooo`3oool0103oool2000000`0oooo00<000000?oo
o`3oool09`3oool00`000000oooo0?ooo`0Q0?ooo`00203oool00`000000oooo0?ooo`0P0?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`3oool06@3oool500000080oooo00<000000?ooo`3o
ool0:03oool00`000000oooo0?ooo`0g0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3o
ool02@3oool00`000000oooo0?ooo`0W0?ooo`030000003oool0oooo0240oooo00080?ooo`030000
003oool0oooo0240oooo0P0000060?ooo`030000003oool0oooo01@0oooo1@0000070?ooo`030000
003oool0oooo02P0oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`080?ooo`030000
003oool0oooo00P0oooo00<000000?ooo`3oool09`3oool00`000000oooo0?ooo`0Q0?ooo`00203o
ool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool03`3o
ool5000000/0oooo00<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`0e0?ooo`030000003o
ool0oooo00X0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0W0?ooo`030000003o
ool0oooo0240oooo00080?ooo`030000003oool0oooo02@0oooo0P0000030?ooo`030000003oool0
oooo00X0oooo1@00000?0?ooo`030000003oool0oooo02X0oooo00<000000?ooo`3oool0=@3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool09`3oool0
0`000000oooo0?ooo`0Q0?ooo`00203oool00`000000oooo0?ooo`0V0?ooo`@000001`3oool50000
01<0oooo00<000000?ooo`3oool0;03oool00`000000oooo0?ooo`0c0?ooo`030000003oool0oooo
00d0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo
0240oooo00080?ooo`030000003oool0oooo02L0oooo0`0000020?ooo`D000005`3oool00`000000
oooo0?ooo`0]0?ooo`030000003oool0oooo0380oooo00<000000?ooo`3oool03`3oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool08@3oool000P0oooo
00<000000?ooo`3oool0:03oool4000001/0oooo00<000000?ooo`3oool0;P3oool00`000000oooo
0?ooo`0b0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0103oool00`000000oooo
0?ooo`0V0?ooo`030000003oool0oooo0240oooo00080?ooo`030000003oool0oooo02H0oooo0P00
0000103oool0000000000000000J0?ooo`030000003oool0oooo02l0oooo00<000000?ooo`3oool0
<@3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0
9P3oool00`000000oooo0?ooo`0Q0?ooo`001`3oool00`000000oooo0?ooo`0U0?ooo`80000000<0
oooo0000003oool00P0000000`3oool000000000000G0?ooo`030000003oool0oooo0300oooo00<0
00000?ooo`3oool0<03oool00`000000oooo0?ooo`0D0?ooo`8000000`3oool00`000000oooo0?oo
o`0V0?ooo`030000003oool0oooo0240oooo00070?ooo`030000003oool0oooo0280oooo0`000004
0?ooo`<000000`3oool2000001@0oooo00<000000?ooo`3oool0<P3oool00`000000oooo0?ooo`0_
0?ooo`030000003oool0oooo01H0oooo00D000000?ooo`3oool0oooo0000000W0?ooo`030000003o
ool0oooo0240oooo00070?ooo`030000003oool0oooo0200oooo0P0000090?ooo`030000003oool0
oooo00<0oooo0P00000A0?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3oool0;P3oool0
0`000000oooo0?ooo`0H0?ooo`040000003oool0oooo000002L0oooo00<000000?ooo`3oool08@3o
ool000L0oooo00<000000?ooo`3oool07P3oool2000000/0oooo00<000000?ooo`3oool01@3oool0
0`000000oooo0?ooo`0=0?ooo`030000003oool0oooo03@0oooo00<000000?ooo`3oool0;@3oool0
0`000000oooo0?ooo`0J0?ooo`030000003oool0000002L0oooo00<000000?ooo`3oool08@3oool0
00L0oooo00<000000?ooo`3oool0703oool2000000d0oooo00<000000?ooo`3oool01P3oool20000
00d0oooo00<000000?ooo`3oool0=03oool00`000000oooo0?ooo`0]0?ooo`030000003oool0oooo
01/0oooo0P00000V0?ooo`030000003oool0oooo0280oooo00070?ooo`030000003oool0oooo01T0
oooo0`00000?0?ooo`030000003oool0oooo00P0oooo0P00000:0?ooo`030000003oool0oooo03D0
oooo00<000000?ooo`3oool0;03oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo02@0
oooo00<000000?ooo`3oool08P3oool000L0oooo00<000000?ooo`3oool05`3oool2000001<0oooo
00<000000?ooo`3oool02@3oool2000000L0oooo00<000000?ooo`3oool0=`3oool00`000000oooo
0?ooo`0Z0?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3oool08`3oool00`000000oooo
0?ooo`0R0?ooo`001`3oool00`000000oooo0?ooo`0E0?ooo`8000005@3oool00`000000oooo0?oo
o`0;0?ooo`8000000`3oool4000003P0oooo00<000000?ooo`3oool0:P3oool00`000000oooo0?oo
o`0O0?ooo`800000903oool00`000000oooo0?ooo`0R0?ooo`001`3oool00`000000oooo0?ooo`0B
0?ooo`<000005`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo0080000000<0oooo
0000003oool0>P3oool00`000000oooo0?ooo`0Y0?ooo`030000003oool0oooo0200oooo00@00000
0?ooo`00000000008P3oool00`000000oooo0?ooo`0R0?ooo`001`3oool00`000000oooo0?ooo`0@
0?ooo`8000006P3oool00`000000oooo0?ooo`0<0?ooo`060000003oool0oooo0000003oool00000
>P3oool00`000000oooo0?ooo`0X0?ooo`030000003oool0oooo0240oooo00D000000?ooo`3oool0
oooo0000000Q0?ooo`030000003oool0oooo0280oooo00070?ooo`030000003oool0oooo00h0oooo
0P00000M0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`0000000`00000i0?ooo`030000
003oool0oooo02P0oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`020?ooo`030000
003oool0oooo01h0oooo00<000000?ooo`3oool08P3oool000L0oooo00<000000?ooo`3oool02`3o
ool3000001l0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`02000000030?ooo`00
0000oooo00800000>@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02<0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo0280oooo0006
0?ooo`030000003oool0oooo00X0oooo0P00000R0?ooo`030000003oool0oooo00X0oooo0P000000
103oool000000?ooo`3oool3000003T0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?oo
o`0T0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0703oool00`000000oooo0?oo
o`0R0?ooo`001P3oool00`000000oooo0?ooo`080?ooo`800000903oool00`000000oooo0?ooo`0<
0?ooo`030000003oool0oooo00@0oooo0P00000g0?ooo`030000003oool0oooo02D0oooo00<00000
0?ooo`3oool0903oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo01/0oooo00<00000
0?ooo`3oool08P3oool000H0oooo00<000000?ooo`3oool01P3oool2000002H0oooo00<000000?oo
o`3oool0303oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo03@0oooo00<000000?oo
o`3oool0903oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool06P3oool00`000000oooo0?ooo`0R0?ooo`001P3oool00`000000oooo0?ooo`030?ooo`<0
0000:@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3o
ool0<`3oool00`000000oooo0?ooo`0N0?ooo`8000000`3oool3000002H0oooo00<000000?ooo`3o
ool01P3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo0280oooo00060?ooo`<00000
00<0oooo000000000000;03oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00T0oooo
0P00000d0?ooo`030000003oool0oooo01`0oooo00@000000?ooo`3oool000000P3oool010000000
oooo0?ooo`00000V0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0603oool00`00
0000oooo0?ooo`0R0?ooo`001P3oool4000002h0oooo00<000000?ooo`3oool02@3oool00`000000
oooo0?ooo`0<0?ooo`030000003oool0oooo0340oooo00<000000?ooo`3oool07P3oool00`000000
oooo0?ooo`0200000080oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`070?ooo`80
0000603oool00`000000oooo0?ooo`0R0?ooo`00103oool5000002l0oooo00<000000?ooo`3oool0
2@3oool00`000000oooo0?ooo`0=0?ooo`800000<@3oool00`000000oooo0?ooo`0O0?ooo`800000
00@0oooo00000000000000009`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo01@0
oooo00<000000?ooo`3oool08`3oool000@0oooo00@000000?ooo`3oool00000<03oool00`000000
oooo0?ooo`080?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0;P3oool00`000000
oooo0?ooo`0L0?ooo`030000003oool0oooo008000000P3oool00`000000oooo0?ooo`0V0?ooo`03
0000003oool0oooo00X0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0S0?ooo`00
1@3oool00`000000oooo0000000a0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0
4@3oool00`000000oooo0?ooo`0]0?ooo`030000003oool0oooo01d0oooo0`0000030?ooo`<00000
9P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool0
8`3oool000H0oooo0`00000`0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool04`3o
ool2000002h0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0/0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0S0?ooo`00203oool0
0`000000oooo0?ooo`0^0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool05@3oool0
0`000000oooo0?ooo`0[0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool0;03oool0
0`000000oooo0?ooo`0<0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool08`3oool0
00T0oooo00<000000?ooo`3oool0;@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
01L0oooo0P00000[0?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool0;@3oool00`00
0000oooo0?ooo`0=0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool08`3oool000T0
oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo01T0
oooo00<000000?ooo`3oool0:03oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo02h0
oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo02<0
oooo000:0?ooo`030000003oool0oooo02d0oooo00<000000?ooo`3oool00`3oool00`000000oooo
0?ooo`0K0?ooo`030000003oool0oooo02L0oooo00<000000?ooo`3oool06`3oool00`000000oooo
0?ooo`0^0?ooo`030000003oool0oooo00l0oooo0P00000>0?ooo`030000003oool0oooo02<0oooo
000:0?ooo`030000003oool0oooo02d0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?oo
o`0L0?ooo`800000:03oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo02l0oooo00<0
00000?ooo`3oool04@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo02<0oooo000;
0?ooo`030000003oool0oooo02`0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0O
0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0a
0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0S
0?ooo`002`3oool00`000000oooo0?ooo`0/0?ooo`030000003oool0oooo0080oooo00<000000?oo
o`3oool07`3oool2000000@0oooo0P00000P0?ooo`030000003oool0oooo01L0oooo00<000000?oo
o`3oool0<P3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo00T0oooo00<000000?oo
o`3oool05P3oool400000080oooo0`0000040?ooo`00303oool00`000000oooo0?ooo`0/0?ooo`04
0000003oool0oooo00000240oooo00<000000?ooo`3oool00P0000001@3oool000000?ooo`3oool0
000001l0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0b0?ooo`030000003oool0
oooo01<0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0F0?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool00P3oool000`0oooo00<000000?ooo`3oool0;03oool01000
0000oooo0?ooo`00000S0?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool07P3o
ool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3oool0503o
ool00`000000oooo0?ooo`070?ooo`030000003oool0oooo01L0oooo00<000000?ooo`0000000P00
0000103oool000000000000000030?ooo`003@3oool00`000000oooo0?ooo`0[0?ooo`030000003o
ool0000002D0oooo00<000000?ooo`3oool00P0000000`3oool000000?ooo`0O0?ooo`030000003o
ool0oooo01@0oooo00<000000?ooo`3oool0=03oool00`000000oooo0?ooo`0E0?ooo`030000003o
ool0oooo00H0oooo00<000000?ooo`3oool05@3oool500000080oooo00@000000?ooo`3oool00000
0`3oool000d0oooo00<000000?ooo`3oool0:`3oool00`000000oooo0000000R0?ooo`040000003o
ool0oooo00000080oooo00@000000?ooo`0000000000803oool00`000000oooo0?ooo`0D0?ooo`03
0000003oool0oooo03D0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`040?ooo`03
0000003oool0oooo0180oooo1P0000020?ooo`040000003oool0oooo00000080oooo00<000000?oo
o`3oool00@3oool000h0oooo00<000000?ooo`3oool0:P3oool2000002@0oooo0P0000040?ooo`@0
00007`3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3o
ool05P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00h0oooo1@0000050?ooo`80
0000103oool3000000<0oooo000?0?ooo`030000003oool0oooo02X0oooo00<000000?ooo`3oool0
;03oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool0
=`3oool00`000000oooo0?ooo`0G0?ooo`8000000`3oool00`000000oooo0?ooo`090?ooo`H00000
5@3oool000l0oooo00<000000?ooo`3oool0:@3oool2000002l0oooo0P00000L0?ooo`030000003o
ool0oooo0180oooo00<000000?ooo`3oool0=`3oool00`000000oooo0?ooo`0I0?ooo`040000003o
ool0oooo000000L0oooo1P00000I0?ooo`00403oool00`000000oooo0?ooo`0X0?ooo`800000<@3o
ool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0>03o
ool00`000000oooo0?ooo`0G0?ooo`@0000000<0oooo0000003oool02000000M0?ooo`00403oool0
0`000000oooo0?ooo`0W0?ooo`030000003oool000000380oooo0P00000J0?ooo`030000003oool0
oooo00l0oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0F0?ooo`040000003oool0
oooo0?ooo`L000008@3oool00140oooo00<000000?ooo`3oool09P3oool010000000oooo0?ooo`00
000c0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?oo
o`0j0?ooo`030000003oool0oooo01H0oooo100000001@3oool000000000003oool0000002<0oooo
000A0?ooo`030000003oool0oooo02D0oooo00D000000?ooo`3oool0oooo0000000d0?ooo`800000
5`3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo03/0oooo00<000000?ooo`3oool0
4P3oool400000080oooo00D000000?ooo`000000oooo000000020?ooo`030000003oool0oooo0200
oooo000B0?ooo`030000003oool0oooo02@0oooo00D000000?ooo`3oool0oooo0000000f0?ooo`03
0000003oool0oooo01@0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0l0?ooo`03
0000003oool0oooo00h0oooo100000040?ooo`030000003oool0oooo0080000000D0oooo0000003o
ool0oooo0000000R0?ooo`004P3oool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool0=@3oool2000001D0oooo00<000000?ooo`3oool0303oool00`000000
oooo0?ooo`0l0?ooo`030000003oool0oooo00T0oooo1@0000090?ooo`<000000`3oool2000002<0
oooo000C0?ooo`030000003oool0oooo0280oooo00<000000?ooo`3oool00P3oool00`000000oooo
0?ooo`0g0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0i0?ooo`H0000000<0oooo0000000000000`3oool400000100oooo00D000000?ooo`3oool0
oooo0000000T0?ooo`004`3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`3oool0=`3oool200000180oooo00<000000?ooo`3oool02P3oool00`000000oooo
0?ooo`0l0?ooo`030000003oool0oooo0080000000<0oooo0000000000000P00000C0?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool08@3oool001@0oooo00<000000?ooo`3oool0803o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo03T0oooo00<000000?ooo`3oool03`3o
ool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo03`0oooo1P0000000`3oool000000?oo
o`0D0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool08@3oool001@0oooo00<00000
0?ooo`3oool07`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo03X0oooo0P00000?
0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0>03oool600000080oooo00@00000
0?ooo`00000000005@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0200oooo000E
0?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0l
0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0d
0?ooo`D000001@3oool00`000000oooo0?ooo`0200000080oooo00<000000?ooo`3oool04P3oool0
0`000000oooo0?ooo`050?ooo`030000003oool0oooo0200oooo000E0?ooo`030000003oool0oooo
01d0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0m0?ooo`8000003@3oool00`00
0000oooo0?ooo`070?ooo`030000003oool0oooo02l0oooo1@0000090?ooo`8000000`3oool30000
01@0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0O0?ooo`005P3oool00`000000
oooo0?ooo`0L0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0?P3oool00`000000
oooo0?ooo`0:0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0:P3oool6000001<0
oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo01l0
oooo000G0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0203oool00`000000oooo
0?ooo`0o0?ooo`8000002P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo02H0oooo
1@00000I0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool02@3oool00`000000oooo
0?ooo`0N0?ooo`005`3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo00P0oooo00<0
00000?ooo`3oool0@@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool08@3oool6000001h0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?oo
o`090?ooo`030000003oool0oooo01h0oooo000H0?ooo`030000003oool0oooo01P0oooo00<00000
0?ooo`3oool02@3oool00`000000oooo0?ooo`120?ooo`800000203oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo01`0oooo1@00000T0?ooo`030000003oool0oooo0180oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0M0?ooo`00603oool00`000000oooo0?ooo`0H0?oo
o`030000003oool0oooo00X0oooo00<000000?ooo`3oool0@`3oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo0080oooo00<000000?ooo`3oool05`3oool6000002T0oooo00<000000?oo
o`3oool04P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo01d0oooo000I0?ooo`03
0000003oool0oooo01H0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`140?ooo`80
00001@3oool01@000000oooo0?ooo`3oool0000001D0oooo1@00000`0?ooo`030000003oool0oooo
0100oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0L0?ooo`006@3oool00`000000
oooo0?ooo`0F0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0AP3oool00`000000
oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`000000403oool5000003D0oooo00<000000?oo
o`3oool0403oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo01`0oooo000J0?ooo`03
0000003oool0oooo01@0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`170?ooo`80
00000P3oool010000000oooo0?ooo`00000;0?ooo`H00000>P3oool00`000000oooo0?ooo`0?0?oo
o`030000003oool0oooo00l0oooo00<000000?ooo`3oool06`3oool001X0oooo00<000000?ooo`3o
ool0503oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo04L0oooo2@0000050?ooo`D0
0000@03oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3o
ool06`3oool001/0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0>0?ooo`030000
003oool0oooo04P0oooo1@0000000`3oool0000000000004000004D0oooo00<000000?ooo`3oool0
3P3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo01X0oooo000K0?ooo`030000003o
ool0oooo0180oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`180?ooo`L00000B`3o
ool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool06P3o
ool001`0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0?0?ooo`030000003oool0
oooo04@0oooo1@0000000`3oool0000000000002000000030?ooo`000000oooo04T0oooo00<00000
0?ooo`3oool0303oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo01T0oooo000L0?oo
o`030000003oool0oooo0100oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0o0?oo
o`D00000103oool00`000000oooo00000002000000030?ooo`000000000004X0oooo00<000000?oo
o`3oool0303oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo01T0oooo000M0?ooo`03
0000003oool0oooo00h0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0j0?ooo`D0
0000203oool300000080oooo1000001:0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool05@3oool00`000000oooo0?ooo`0H0?ooo`007@3oool00`000000oooo0?ooo`0>0?ooo`030000
003oool0oooo0140oooo00<000000?ooo`3oool0=03oool5000000h0oooo00D000000?ooo`3oool0
oooo000000030?ooo`800000B03oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo01D0
oooo00<000000?ooo`3oool0603oool001h0oooo00<000000?ooo`3oool0303oool00`000000oooo
0?ooo`0B0?ooo`030000003oool0oooo02l0oooo1@00000C0?ooo`050000003oool0oooo0?ooo`00
00001@3oool00`000000oooo0?ooo`160?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3o
ool05`3oool00`000000oooo0?ooo`0G0?ooo`007`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo0180oooo00<000000?ooo`3oool0:P3oool5000001L0oooo00<000000?ooo`3oool0
0P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo04D0oooo00<000000?ooo`3oool0
2@3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01L0oooo000O0?ooo`030000003o
ool0oooo00X0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0U0?ooo`D00000703o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00D0oooo0P0000150?ooo`030000003o
ool0oooo00P0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0F0?ooo`00803oool0
0`000000oooo0?ooo`090?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool07`3oool5
00000200oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`070?ooo`030000003oool0
oooo0480oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0I0?ooo`030000003oool0
oooo01H0oooo000P0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool05@3oool00`00
0000oooo0?ooo`0J0?ooo`D00000903oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
00L0oooo0P0000120?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool06`3oool00`00
0000oooo0?ooo`0E0?ooo`008@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo01D0
oooo00<000000?ooo`3oool05@3oool5000002T0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`090?ooo`030000003oool0oooo03l0oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`0K0?ooo`030000003oool0oooo01D0oooo000Q0?ooo`030000003oool0oooo00H0oooo
00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0@0?ooo`D00000;@3oool00`000000oooo
0?ooo`060?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0?`3oool00`000000oooo
0?ooo`050?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool0503oool00280oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo00/0oooo1@00
000a0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool02`3oool2000003l0oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo01@0oooo000R
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool05`3oool2000000L0oooo1@00000f
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0l
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`0C
0?ooo`008`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo01H0oooo00D000000?oo
o`00000000000?ooo`05000003X0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0=
0?ooo`030000003oool0oooo03/0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0P
0?ooo`030000003oool0oooo01<0oooo000S0?ooo`030000003oool0oooo0080oooo00<000000?oo
o`3oool05`3oool5000003h0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0>0?oo
o`800000>`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0240oooo00<000000?oo
o`3oool04P3oool002@0oooo00D000000?ooo`3oool0oooo0000000E0?ooo`@0000000<0oooo0000
00000000@03oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo0100oooo00<000000?oo
o`3oool0>@3oool01@000000oooo0?ooo`3oool0000002@0oooo00<000000?ooo`3oool04P3oool0
02@0oooo00@000000?ooo`3oool000004P3oool4000000@0oooo00@000000?ooo`0000000000?P3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo0140oooo0P00000i0?ooo`050000003o
ool0oooo0?ooo`0000009@3oool00`000000oooo0?ooo`0A0?ooo`009@3oool3000000d0oooo1@00
00090?ooo`<00000?P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo01<0oooo00<0
00000?ooo`3oool0=P3oool010000000oooo0?ooo`00000V0?ooo`030000003oool0oooo0140oooo
000T0?ooo`@000002@3oool400000100oooo00<000000?ooo`3oool0>`3oool00`000000oooo0?oo
o`0=0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0=@3oool010000000oooo0?oo
o`00000W0?ooo`030000003oool0oooo0100oooo000U0?ooo`8000001P3oool4000001@0oooo00<0
00000?ooo`3oool0>P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo01@0oooo0P00
000e0?ooo`030000003oool0000002P0oooo00<000000?ooo`3oool0403oool00240oooo10000000
0`3oool0000000000005000001P0oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0>
0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool0<`3oool2000002T0oooo00<00000
0?ooo`3oool03`3oool001h0oooo0`0000030?ooo`D00000703oool00`000000oooo0?ooo`0i0?oo
o`030000003oool0oooo00l0oooo00<000000?ooo`3oool05`3oool2000003<0oooo00<000000?oo
o`3oool0:03oool00`000000oooo0?ooo`0?0?ooo`006P3oool4000000030?ooo`000000000000<0
000000<0oooo0000000000000P3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo03P0
oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo0300
oooo00<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`0>0?ooo`005`3oool3000000030?oo
o`0000000000008000001`3oool010000000oooo0?ooo`3oool2000001X0oooo00<000000?ooo`3o
ool0=`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3o
ool0;P3oool2000002/0oooo00<000000?ooo`3oool03P3oool001@0oooo1`00000;0?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0f0?ooo`030000
003oool0oooo0180oooo00<000000?ooo`3oool06P3oool2000002h0oooo0P00000/0?ooo`030000
003oool0oooo00d0oooo000@0?ooo`L000003`3oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo01H0oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`0B0?ooo`030000003o
ool0oooo01`0oooo00<000000?ooo`3oool0:P3oool00`000000oooo0000000/0?ooo`030000003o
ool0oooo00d0oooo00020?ooo`@000000P3oool300000080oooo1@00000D0?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0e0?ooo`030000003oool0
oooo01<0oooo00<000000?ooo`3oool0703oool2000000D0oooo0`00000S0?ooo`040000003oool0
oooo000002`0oooo00<000000?ooo`3oool0303oool00080oooo00<000000?ooo`3oool00`3oool6
000001P0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0
oooo03@0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0K0?ooo`030000003oool0
oooo00800000103oool00`000000oooo0?ooo`0Q0?ooo`050000003oool0oooo0?ooo`000000;03o
ool00`000000oooo0?ooo`0<0?ooo`000`3oool010000000oooo0?ooo`3oool3000000030?ooo`00
0000oooo01P0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0D0?ooo`030000003o
ool0oooo03<0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0M0?ooo`030000003o
ool0oooo00H000008P3oool01@000000oooo0?ooo`3oool0000002d0oooo00<000000?ooo`3oool0
2`3oool000@0oooo00@000000?ooo`3oool0oooo0`00000J0?ooo`030000003oool0oooo00T0oooo
00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0b0?ooo`030000003oool0oooo01H0oooo
00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`02000000030?ooo`000000oooo0240oooo
00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0[0?ooo`030000003oool0oooo00/0oooo
00020?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3oool06@3oool00`000000oooo
0?ooo`0:0?ooo`8000004`3oool00`000000oooo0?ooo`0a0?ooo`030000003oool0oooo01L0oooo
00<000000?ooo`3oool06P3oool010000000oooo0?ooo`0000030?ooo`<000008P3oool00`000000
oooo0?ooo`020?ooo`030000003oool0oooo02`0oooo00<000000?ooo`3oool02P3oool000<0oooo
0P0000040?ooo`<000006@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo0100oooo
00<000000?ooo`3oool0<@3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01/0oooo
0P0000050?ooo`<00000803oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo02/0oooo
00<000000?ooo`3oool02P3oool002D0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?oo
o`0?0?ooo`030000003oool0oooo0300oooo00<000000?ooo`3oool0603oool00`000000oooo0?oo
o`0U0?ooo`8000007P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo02`0oooo00<0
00000?ooo`3oool02@3oool002D0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>
0?ooo`030000003oool0oooo02l0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0W
0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0/
0?ooo`030000003oool0oooo00T0oooo000U0?ooo`030000003oool0oooo00l0oooo00<000000?oo
o`3oool03P3oool00`000000oooo0?ooo`0^0?ooo`030000003oool0oooo01X0oooo00<000000?oo
o`3oool09`3oool2000001X0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0]0?oo
o`030000003oool0oooo00P0oooo000U0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3o
ool03@3oool00`000000oooo0?ooo`0]0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3o
ool0:@3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3o
ool0;@3oool00`000000oooo0?ooo`080?ooo`009@3oool00`000000oooo0?ooo`0A0?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool0;@3oool00`000000oooo0?ooo`0K0?ooo`030000
003oool0oooo02X0oooo0P00000F0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0
;@3oool00`000000oooo0?ooo`070?ooo`009@3oool00`000000oooo0?ooo`0B0?ooo`800000303o
ool00`000000oooo0?ooo`0/0?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool0;03o
ool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0;@3o
ool00`000000oooo0?ooo`070?ooo`009@3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0
oooo00T0oooo00<000000?ooo`3oool09P3oool2000000<0oooo1@00000K0?ooo`030000003oool0
oooo02d0oooo0P00000B0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0:P3oool5
000000030?ooo`0000000000008000000`3oool002D0oooo00<000000?ooo`3oool05@3oool00`00
0000oooo0?ooo`090?ooo`030000003oool0oooo02@0oooo00@000000?ooo`3oool000000P3oool0
0`000000oooo0000000M0?ooo`030000003oool0oooo02l0oooo0P00000?0?ooo`030000003oool0
oooo00T0oooo00<000000?ooo`3oool0:P3oool01`000000oooo0?ooo`3oool000000?ooo`000000
1P3oool002D0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`080?ooo`030000003o
ool0oooo02H0oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`0L0?ooo`030000
003oool0oooo0300oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`090?ooo`030000
003oool0oooo02/0oooo00<000000?ooo`3oool00P0000000`3oool000000?ooo`040?ooo`009@3o
ool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool09`3o
ool2000000<0oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`0a0?ooo`8000002`3o
ool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo02`0oooo0P0000001@3oool000000?oo
o`3oool0000000@0oooo000U0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool01P3o
ool00`000000oooo0?ooo`0T0?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool0
703oool00`000000oooo0?ooo`0c0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0Y0?ooo`80000000<0oooo0000003oool00P0000020?ooo`030000
003oool0oooo0040oooo000U0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`0U0?ooo`<000000`3oool2000001h0oooo00<000000?ooo`3oool0=03o
ool2000000L0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0V0?ooo`<0000000<0
oooo0000000000000P3oool010000000oooo0000000000040?ooo`009@3oool00`000000oooo0?oo
o`0J0?ooo`8000001P3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo0280oooo00<0
00000?ooo`3oool0=P3oool2000000D0oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`0T0?ooo`800000203oool00`000000oooo0?ooo`050?ooo`00903oool00`000000oooo0?ooo`0M
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`0T
0?ooo`030000003oool0oooo03H0oooo0P0000030?ooo`<000003@3oool00`000000oooo0?ooo`0R
0?ooo`8000002P3oool00`000000oooo0?ooo`050?ooo`00903oool00`000000oooo0?ooo`0N0?oo
o`030000003oool0oooo0080oooo00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`0U0?oo
o`030000003oool0oooo03D0oooo00<000000?ooo`3oool00P0000001@3oool000000?ooo`3oool0
000000`0oooo00<000000?ooo`3oool0803oool2000000/0oooo00<000000?ooo`3oool01P3oool0
02@0oooo00<000000?ooo`3oool07`3oool01@000000oooo0?ooo`3oool0000002D0oooo00<00000
0?ooo`3oool09@3oool00`000000oooo0?ooo`0g0?ooo`040000003oool0oooo000000<0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0L0?ooo`<000003@3oool00`000000oooo0?oo
o`060?ooo`00903oool00`000000oooo0?ooo`0P0?ooo`040000003oool0oooo000002@0oooo00<0
00000?ooo`3oool09P3oool00`000000oooo0?ooo`0h0?ooo`80000000@0oooo0000000000000000
3P3oool00`000000oooo0?ooo`0J0?ooo`800000403oool00`000000oooo0?ooo`060?ooo`00903o
ool00`000000oooo0?ooo`0Q0?ooo`030000003oool0000002<0oooo00<000000?ooo`3oool09`3o
ool00`000000oooo0?ooo`0e0?ooo`040000003oool0oooo000000<0oooo0P00000>0?ooo`030000
003oool0oooo01P0oooo0P00000B0?ooo`030000003oool0oooo00H0oooo000T0?ooo`030000003o
ool0oooo0280oooo00<000000?ooo`0000008@3oool00`000000oooo0?ooo`0Y0?ooo`030000003o
ool0oooo03D0oooo0P0000040?ooo`@00000303oool00`000000oooo0?ooo`0E0?ooo`<00000503o
ool00`000000oooo0?ooo`060?ooo`00903oool00`000000oooo0?ooo`0S0?ooo`8000008@3oool0
0`000000oooo0?ooo`0Y0?ooo`030000003oool0oooo03D0oooo00<000000?ooo`3oool01`3oool0
0`000000oooo0?ooo`090?ooo`030000003oool0oooo01<0oooo0P00000G0?ooo`030000003oool0
oooo00H0oooo000T0?ooo`030000003oool0oooo02@0oooo0P00000O0?ooo`030000003oool0oooo
02X0oooo00<000000?ooo`3oool0=@3oool00`000000oooo0?ooo`080?ooo`8000002P3oool00`00
0000oooo0?ooo`0@0?ooo`8000006@3oool00`000000oooo0?ooo`060?ooo`00903oool00`000000
oooo0?ooo`0T0?ooo`030000003oool0000001d0oooo00<000000?ooo`3oool0:`3oool00`000000
oooo0?ooo`0d0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`0=0?ooo`<000006`3oool00`000000oooo0?ooo`060?ooo`00903oool00`000000oooo
0?ooo`0T0?ooo`040000003oool0oooo000001/0oooo00<000000?ooo`3oool0;03oool00`000000
oooo0?ooo`0c0?ooo`030000003oool0oooo00d0oooo0P0000070?ooo`030000003oool0oooo00/0
oooo0P00000N0?ooo`030000003oool0oooo00H0oooo000T0?ooo`030000003oool0oooo02D0oooo
00@000000?ooo`3oool000006P3oool00`000000oooo0?ooo`0/0?ooo`030000003oool0oooo0380
oooo00<000000?ooo`3oool0403oool2000000D0oooo00<000000?ooo`3oool02@3oool200000200
oooo00<000000?ooo`3oool01P3oool002@0oooo00<000000?ooo`3oool09@3oool01@000000oooo
0?ooo`3oool0000001P0oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`0`0?ooo`03
0000003oool0oooo01<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`070?ooo`80
00008P3oool00`000000oooo0?ooo`060?ooo`00903oool00`000000oooo0?ooo`0U0?ooo`030000
003oool0oooo0080oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0_0?ooo`030000
003oool0oooo02l0oooo00<000000?ooo`3oool05@3oool200000080oooo00<000000?ooo`3oool0
103oool3000002@0oooo00<000000?ooo`3oool01P3oool002@0oooo00<000000?ooo`3oool09@3o
ool00`000000oooo0?ooo`030?ooo`8000004`3oool00`000000oooo0?ooo`0`0?ooo`030000003o
ool0oooo02h0oooo00<000000?ooo`3oool05P3oool600000080oooo0`00000V0?ooo`030000003o
ool0oooo00L0oooo000T0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool01@3oool0
0`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0300oooo00<000000?ooo`3oool0;@3oool0
0`000000oooo0?ooo`0I0?ooo`@0000000<0oooo000000000000:03oool00`000000oooo0?ooo`07
0?ooo`00903oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo00H0oooo00<000000?oo
o`3oool03P3oool00`000000oooo0?ooo`0a0?ooo`030000003oool0oooo02d0oooo00<000000?oo
o`3oool06@3oool5000000030?ooo`000000oooo02L0oooo00<000000?ooo`3oool01`3oool002@0
oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00`0
oooo00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`0[0?ooo`030000003oool0oooo01D0
oooo1P0000020?ooo`<0000000<0oooo0000003oool09P3oool00`000000oooo0?ooo`070?ooo`00
903oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0
2P3oool00`000000oooo0?ooo`0d0?ooo`030000003oool0oooo02X0oooo00<000000?ooo`3oool0
4@3oool5000000D0oooo00<000000?ooo`3oool00P0000000`3oool000000000000W0?ooo`030000
003oool0oooo00L0oooo000S0?ooo`030000003oool0oooo02L0oooo00<000000?ooo`3oool0203o
ool00`000000oooo0?ooo`090?ooo`030000003oool0oooo03@0oooo00<000000?ooo`3oool0:@3o
ool00`000000oooo0?ooo`0=0?ooo`D000002@3oool200000080oooo1P00000V0?ooo`030000003o
ool0oooo00L0oooo000S0?ooo`030000003oool0oooo02L0oooo00<000000?ooo`3oool02@3oool0
0`000000oooo0?ooo`070?ooo`030000003oool0oooo03D0oooo00<000000?ooo`3oool0:03oool0
0`000000oooo0?ooo`080?ooo`H000004P3oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo02<0oooo00<000000?ooo`3oool01`3oool002<0oooo00<000000?ooo`3oool09`3oool00`00
0000oooo0?ooo`0:0?ooo`8000001P3oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo
02L0oooo00<000000?ooo`3oool0103oool5000001P0oooo00<000000?ooo`3oool0103oool20000
02<0oooo00<000000?ooo`3oool01`3oool002<0oooo00<000000?ooo`3oool0:03oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0>03oool00`000000
oooo0?ooo`0U0?ooo`030000003oool0000000D000007@3oool00`000000oooo0?ooo`060?ooo`03
0000003oool0oooo0200oooo00<000000?ooo`3oool01`3oool002<0oooo00<000000?ooo`3oool0
:03oool00`000000oooo0?ooo`0:0?ooo`<000000`3oool2000003T0oooo00<000000?ooo`3oool0
8P3oool5000002<0oooo00<000000?ooo`3oool01`3oool200000200oooo00<000000?ooo`3oool0
1`3oool002<0oooo00<000000?ooo`3oool0:03oool00`000000oooo0?ooo`090?ooo`030000003o
ool0oooo0080000000D0oooo0000003oool0oooo0000000h0?ooo`030000003oool0oooo01`0oooo
1P0000020?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool02@3oool00`000000oooo
0?ooo`0M0?ooo`030000003oool0oooo00L0oooo000S0?ooo`030000003oool0oooo02P0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0200000080oooo00<000000?ooo`3oool0=P3o
ool00`000000oooo0?ooo`0G0?ooo`D000001`3oool00`000000oooo0?ooo`0T0?ooo`030000003o
ool0oooo00X0oooo0P00000M0?ooo`030000003oool0oooo00L0oooo000S0?ooo`030000003oool0
oooo02P0oooo00<000000?ooo`3oool0303oool2000000050?ooo`00000000000?ooo`000000>03o
ool00`000000oooo0?ooo`0B0?ooo`D000002`3oool00`000000oooo0?ooo`0U0?ooo`030000003o
ool0oooo00`0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`080?ooo`008`3oool0
0`000000oooo0?ooo`0X0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool00P000000
0`3oool000000?ooo`02000003P0oooo00<000000?ooo`3oool0303oool6000000l0oooo00<00000
0?ooo`3oool09P3oool00`000000oooo0?ooo`0=0?ooo`8000006@3oool00`000000oooo0?ooo`08
0?ooo`008`3oool00`000000oooo0?ooo`0Y0?ooo`030000003oool0oooo00T0oooo0`0000030?oo
o`80000000<0oooo000000000000<P3oool:000000@0oooo1@00000D0?ooo`030000003oool0oooo
02L0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo
00P0oooo000S0?ooo`030000003oool0oooo02T0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`060?ooo`800000<P3oool00`000000oooo0?ooo`02000000030?ooo`000000000000@0
0000603oool00`000000oooo0?ooo`0W0?ooo`030000003oool0oooo0140oooo0P00000F0?ooo`03
0000003oool0oooo00P0oooo000S0?ooo`030000003oool0oooo02T0oooo00<000000?ooo`3oool0
2P3oool00`000000oooo0?ooo`090?ooo`800000<03oool6000001d0oooo00<000000?ooo`3oool0
:03oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0
203oool002<0oooo00<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`090?ooo`030000003o
ool0oooo00`0oooo0P00000Z0?ooo`D000000P3oool010000000oooo0?ooo`00000K0?ooo`030000
003oool0oooo02T0oooo00<000000?ooo`3oool0503oool2000001<0oooo00<000000?ooo`3oool0
203oool002<0oooo00<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`090?ooo`030000003o
ool0oooo00h0oooo0P00000T0?ooo`@00000103oool00`000000oooo0?ooo`0200000080oooo00<0
00000?ooo`3oool0603oool00`000000oooo0?ooo`0Y0?ooo`030000003oool0oooo01H0oooo00<0
00000?ooo`3oool0403oool00`000000oooo0?ooo`080?ooo`008`3oool00`000000oooo0?ooo`0Z
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool04@3oool2000001d0oooo1@000007
0?ooo`8000000`3oool3000001X0oooo00<000000?ooo`3oool0:P3oool00`000000oooo0?ooo`0G
0?ooo`800000403oool00`000000oooo0?ooo`080?ooo`008`3oool00`000000oooo0?ooo`0Z0?oo
o`030000003oool0oooo00H0oooo00<000000?ooo`3oool0503oool2000001H0oooo1@00000A0?oo
o`030000003oool0oooo01T0oooo00<000000?ooo`3oool0:`3oool00`000000oooo0?ooo`0I0?oo
o`030000003oool0oooo00d0oooo00<000000?ooo`3oool0203oool002<0oooo00<000000?ooo`3o
ool0:P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo01H0oooo0P00000@0?ooo`@0
00005P3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo02`0oooo00<000000?ooo`3o
ool06P3oool2000000d0oooo00<000000?ooo`3oool0203oool00280oooo00<000000?ooo`3oool0
:`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo01T0oooo0P0000090?ooo`D00000
6P3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo02d0oooo00<000000?ooo`3oool0
703oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00P0oooo000R0?ooo`030000003o
ool0oooo02/0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0K0?ooo`8000000P3o
ool5000001l0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0^0?ooo`030000003o
ool0oooo01d0oooo0P00000:0?ooo`030000003oool0oooo00P0oooo000R0?ooo`030000003oool0
oooo02`0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0L0?ooo`@000009@3oool0
0`000000oooo0?ooo`0D0?ooo`030000003oool0oooo02l0oooo00<000000?ooo`3oool07`3oool0
0`000000oooo0?ooo`060?ooo`030000003oool0oooo00T0oooo000R0?ooo`030000003oool0oooo
02`0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0H0?ooo`D00000103oool20000
02<0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0`0?ooo`030000003oool0oooo
0200oooo0P0000060?ooo`030000003oool0oooo00T0oooo000R0?ooo`030000003oool0oooo02`0
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0C0?ooo`D000002`3oool200000240
oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0`0?ooo`030000003oool0oooo0280
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`090?ooo`008P3oool00`000000oooo
0?ooo`0/0?ooo`050000003oool0oooo0?ooo`0000004P3oool400000180oooo0P00000O0?ooo`03
0000003oool0oooo0180oooo00<000000?ooo`3oool0<@3oool00`000000oooo0?ooo`0S0?ooo`80
00000`3oool00`000000oooo0?ooo`090?ooo`00803oool4000002d0oooo00@000000?ooo`3oool0
00003P3oool5000001P0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0@0?ooo`03
0000003oool0oooo0380oooo00<000000?ooo`3oool08`3oool4000000030?ooo`000000000000@0
00001P3oool00200oooo00<000000?ooo`000000;P3oool010000000oooo0?ooo`0000090?ooo`D0
00007P3oool2000001d0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0c0?ooo`03
0000003oool0oooo02<0oooo00<000000?ooo`3oool00`0000020?ooo`030000003oool0oooo00H0
oooo000Q0?ooo`d00000903oool2000000H0oooo1000000U0?ooo`8000006`3oool00`000000oooo
0?ooo`0>0?ooo`030000003oool0oooo03@0oooo00<000000?ooo`3oool0903oool00`000000oooo
0?ooo`0200000080oooo00<000000?ooo`3oool01P3oool00280oooo00<000000?ooo`3oool02@3o
oolH000000`0oooo0P0000000`3oool0000000000003000002/0oooo0P00000I0?ooo`030000003o
ool0oooo00d0oooo00<000000?ooo`3oool0=@3oool00`000000oooo0?ooo`0U0?ooo`800000103o
ool00`000000oooo0?ooo`060?ooo`00803oool010000000oooo0?ooo`00000R0?ooo`l00000<P3o
ool2000001L0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0f0?ooo`030000003o
ool0oooo02<0oooo0P0000000`3oool000000?ooo`030?ooo`030000003oool0oooo00H0oooo000Q
0?ooo`<00000;@3oool3000003D0oooo0P00000F0?ooo`030000003oool0oooo00X0oooo00<00000
0?ooo`3oool0=`3oool00`000000oooo0?ooo`0Q0?ooo`80000000<0oooo000000000000103oool2
000000P0oooo000T0?ooo`030000003oool0oooo02T0oooo0P0000000`3oool000000?ooo`0f0?oo
o`800000503oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo03L0oooo00<000000?oo
o`3oool07`3oool2000001<0oooo000T0?ooo`030000003oool0oooo02T0oooo1000000i0?ooo`80
00004P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo03P0oooo00<000000?ooo`3o
ool07@3oool2000001D0oooo000U0?ooo`030000003oool0oooo02L0oooo00<000000?ooo`3oool0
0P3oool00`000000oooo0?ooo`0h0?ooo`800000403oool00`000000oooo0?ooo`080?ooo`030000
003oool0oooo03T0oooo00<000000?ooo`3oool06`3oool2000001L0oooo000U0?ooo`030000003o
ool0oooo02L0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0j0?ooo`8000003P3o
ool00`000000oooo0?ooo`070?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool06@3o
ool2000001T0oooo000V0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`0k0?ooo`8000003@3oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo03/0oooo00<000000?ooo`3oool05`3oool2000001/0oooo000V0?ooo`030000003oool0oooo
02@0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0m0?ooo`8000002`3oool00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo03/0oooo00<000000?ooo`3oool05P3oool20000
01d0oooo000W0?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool01P3oool00`000000
oooo0?ooo`0n0?ooo`8000002@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo03`0
oooo00<000000?ooo`3oool0503oool2000001l0oooo000W0?ooo`030000003oool0oooo0280oooo
00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`100?ooo`8000001`3oool00`000000oooo
0?ooo`020?ooo`030000003oool0oooo03d0oooo00<000000?ooo`3oool04@3oool300000240oooo
000X0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`110?ooo`8000001P3oool01@000000oooo0?ooo`3oool0000003l0oooo00<000000?ooo`3oool0
3`3oool2000002@0oooo000X0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool02@3o
ool00`000000oooo0?ooo`130?ooo`800000103oool010000000oooo0?ooo`0000100?ooo`030000
003oool0oooo00d0oooo0P00000V0?ooo`00:@3oool00`000000oooo0?ooo`0N0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool0@`3oool;000003h0oooo00<000000?ooo`3oool02`3o
ool2000002P0oooo000Y0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool0303oool0
0`000000oooo0?ooo`150?ooo`D0000000<0oooo0000003oool0?`3oool00`000000oooo0?ooo`09
0?ooo`800000:P3oool002X0oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`0=0?oo
o`030000003oool0oooo04@0oooo00<000000?ooo`3oool01`00000m0?ooo`030000003oool0oooo
00L0oooo0P00000/0?ooo`00:P3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo00h0
oooo00<000000?ooo`3oool0A03oool5000000030?ooo`000000oooo0080oooo3P00000_0?ooo`03
0000003oool0oooo00D0oooo0P00000^0?ooo`00:`3oool00`000000oooo0?ooo`0I0?ooo`030000
003oool0oooo00l0oooo00<000000?ooo`3oool0@`3oool200000080oooo0P0000000`3oool00000
0?ooo`0@0?ooo`d000008P3oool00`000000oooo0?ooo`030?ooo`800000<03oool002/0oooo00<0
00000?ooo`3oool06@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0400oooo1000
00030?ooo`<000007P3oool>000000l0oooo2`00000b0?ooo`00;03oool00`000000oooo0?ooo`0G
0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0?P3oool2000000L0oooo00<00000
0?ooo`3oool0;03oool>000000<0oooo00<000000?ooo`3oool01@00000c0?ooo`00;03oool00`00
0000oooo0?ooo`0F0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0>`3oool20000
00T0oooo00<000000?ooo`3oool0>P3oool800000080oooo00<000000?ooo`3oool0<@3oool002d0
oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo03T0
oooo0P00000;0?ooo`800000?P3oool010000000oooo0?ooo`3oool3000003@0oooo000]0?ooo`03
0000003oool0oooo01@0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0f0?ooo`80
00003P3oool00`000000oooo0?ooo`0l0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3o
ool0<`3oool002h0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0E0?ooo`030000
003oool0oooo03@0oooo0P00000@0?ooo`030000003oool0oooo03/0oooo0P0000040?ooo`<00000
<`3oool002h0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0G0?ooo`030000003o
ool0oooo0340oooo0P00000B0?ooo`030000003oool0oooo07L0oooo000_0?ooo`030000003oool0
oooo0100oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0_0?ooo`800000503oool2
000007P0oooo000_0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool06@3oool00`00
0000oooo0?ooo`0/0?ooo`8000005P3oool2000007P0oooo000`0?ooo`030000003oool0oooo00h0
oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`0Z0?ooo`8000006@3oool00`000000
oooo0?ooo`1f0?ooo`00<03oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo01`0oooo
00<000000?ooo`3oool09`3oool2000001/0oooo00<000000?ooo`3oool0MP3oool00340oooo00<0
00000?ooo`3oool0303oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo02D0oooo0P00
000M0?ooo`030000003oool0oooo07H0oooo000a0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool07P3oool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo01d0oooo0P00001g
0?ooo`00<P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo01l0oooo00<000000?oo
o`3oool08@3oool200000240oooo00<000000?ooo`3oool0M@3oool00380oooo00<000000?ooo`3o
ool02@3oool00`000000oooo0?ooo`0O0?ooo`030000003oool0oooo01l0oooo0P00000S0?ooo`03
0000003oool0oooo07D0oooo000c0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0
8@3oool00`000000oooo0?ooo`0L0?ooo`8000009@3oool00`000000oooo0?ooo`1e0?ooo`00<`3o
ool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0280oooo00<000000?ooo`3oool06P3o
ool2000002L0oooo00<000000?ooo`3oool0M@3oool003@0oooo00<000000?ooo`3oool01@3oool0
0`000000oooo0?ooo`0S0?ooo`030000003oool0oooo01L0oooo0P00000Z0?ooo`030000003oool0
oooo07@0oooo000d0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0903oool00`00
0000oooo0?ooo`0E0?ooo`800000;03oool00`000000oooo0?ooo`1d0?ooo`00=@3oool00`000000
oooo0?ooo`020?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool04P3oool2000002h0
oooo00<000000?ooo`3oool0M03oool003D0oooo00<000000?ooo`3oool00P3oool00`000000oooo
0?ooo`0V0?ooo`030000003oool0oooo0100oooo0P00000`0?ooo`030000003oool0oooo07@0oooo
000f0?ooo`040000003oool0oooo000002X0oooo00<000000?ooo`3oool03@3oool200000380oooo
0P00001e0?ooo`00=@3oool5000002X0oooo00<000000?ooo`3oool02`3oool2000003D0oooo00<0
00000?ooo`3oool0L`3oool003L0oooo0P00000/0?ooo`030000003oool0oooo00P0oooo0P00000g
0?ooo`030000003oool0oooo07<0oooo000g0?ooo`H00000:03oool00`000000oooo0?ooo`060?oo
o`800000>@3oool00`000000oooo0?ooo`1c0?ooo`00=`3oool00`000000oooo0?ooo`030?ooo``0
00007@3oool00`000000oooo0?ooo`030?ooo`800000>`3oool00`000000oooo0?ooo`1c0?ooo`00
=`3oool00`000000oooo0?ooo`0?0?ooo``00000403oool300000080oooo0P00000i0?ooo`@00000
00D0oooo0000003oool0oooo0000001a0?ooo`00=P3oool2000001d0oooo300000040?ooo`030000
003oool0000000800000>`3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo00000740
oooo001Q0?ooo`P00000?@3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3o
ool0K`3oool006D0oooo0`00000o0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0
KP3oool006H0oooo00<000000?ooo`3oool0?03oool010000000oooo0?ooo`0000020?ooo`040000
003oool0oooo00000700oooo001V0?ooo`<00000?@3oool2000000<0oooo1000001`0?ooo`00o`3o
oolP0?ooo`00o`3ooolP0?ooo`00o`3ooolP0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 286.688}, {285.25, 0}} -> {-1.05014, -1.04617, \
0.00732253, 0.00732253}}]
}, Open  ]],

Cell[TextData[{
  "This calculates the pseudo-diameter of the graph. T",
  StyleBox["he graph is first converted to an undirected graph, ", "TR"],
  "because ",
  StyleBox["PseudoDiameter", "MR"],
  StyleBox[" takes an undirected graph as input. The calculation finds that \
the diameter 6 is achieved between vertices 1 and 25. ", "TR"]
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(ug\  = \ Join[g, \ Reverse /@ g];\)\), "\n", 
    \(PseudoDiameter[ug]\)}], "Input",
  CellLabel->"In[22]:="],

Cell[BoxData[
    \({{6, {25, 1}}}\)], "Output",
  CellLabel->"Out[23]="]
}, Open  ]],

Cell["\<\
This confirms that the distance between vertices 1 and 25 is indeed \
6.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GraphDistance[ug, 1, 25]\)], "Input",
  CellLabel->"In[24]:="],

Cell[BoxData[
    \(6\)], "Output",
  CellLabel->"Out[24]="]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["MaximalBipartiteMatching[", "MR"],
              StyleBox["g", "TI",
                FontSlant->"Italic"],
              StyleBox["]", "MR"]
            }]], Cell["gives a maximal matching of a bipartite graph"]},
          {
            RowBox[{
              StyleBox["MaximalIndependentVertexSet",
                FontFamily->"Courier"], 
              StyleBox["[",
                "MR"], 
              StyleBox["g",
                FontSlant->"Italic"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{"gives", " ", 
              StyleBox["a",
                FontSlant->"Plain"], " ", "maximal", " ", "independent", " ", 
              "vertex", " ", "set", " ", "of", " ", "an", " ", "undirected", 
              " ", "graph"}]},
          {Cell[TextData[{
              StyleBox["MaximalIndependentVertexSet[", "MR"],
              StyleBox["g, vtxwgt", "TI"],
              StyleBox["]", "MR"]
            }]], Cell[TextData[{
              
              "gives a maximal independent vertex set of an undirected graph, \
with priority given to vertices with higher vertex weight as given by the \
vector ",
              StyleBox["vtxwgt",
                FontSlant->"Italic"]
            }]]},
          {
            RowBox[{
              StyleBox["MaximalIndependentEdgeSet",
                FontFamily->"Courier"], 
              StyleBox["[",
                "MR"], 
              StyleBox["g",
                FontSlant->"Italic"], 
              StyleBox["]",
                "MR"]}], 
            Cell["\<\
gives a maximal independent edge set (also known as a \
maximal matching) of an undirected graph\
\>"]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowLines->False},
  CellTags->"i:6"],

Cell["\<\
Finding a maximal matching, a maximal independent vertex set, and a \
maximal independent edge set.\
\>", "Caption"],

Cell[TextData[{
  "For a matrix of dimension ",
  Cell[BoxData[
      \(TraditionalForm\`m\[Times]n\)]],
  ", the bipartite graph consists of vertex sets ",
  Cell[BoxData[
      \(TraditionalForm\`R = {1, \ 2, \  ... , \ m}\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`C = {1, \ 2, \  ... , \ n}\)]],
  ", where two vertices ",
  Cell[BoxData[
      \(TraditionalForm\`i\  \[Element] \ R\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`j \[Element] C\)]],
  " are connected if the matrix element ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox["g", 
            StyleBox["ij",
              FontSlant->"Italic"]], " ", "\[NotEqual]", " ", "0"}], 
        TraditionalForm]]],
  "."
}], "Text"],

Cell["\<\
This shows that, for the following bipartite graph, row 1 is \
matched to column 2, row 3 is matched to column 2, and row 2 is matched to \
column 3.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MaximalBipartiteMatching[{{1, 0, 0}, {0, 0, 1}, {0, 1, 1}}]\)], "Input",\

  CellLabel->"In[25]:="],

Cell[BoxData[
    \({{1, 1}, {3, 2}, {2, 3}}\)], "Output",
  CellLabel->"Out[25]="]
}, Open  ]],

Cell["\<\
For an undirected graph, an independent vertex set is a set of \
vertices such that no two vertices in the set share an edge. A maximal \
independent vertex set is an independent set such that adding another vertex \
will make it no longer independent.\
\>", "Text"],

Cell["\<\
This shows that for an undirected graph of four vertices linked in \
a square, a maximal independent vertex set consists of two vertices at \
diagonally opposite corners.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MaximalIndependentVertexSet[
      g = {1 \[Rule] 2, 2 \[Rule] 1, 2 \[Rule] 3, 3 \[Rule] 2, 3 \[Rule] 4, 
          4 \[Rule] 3}]\)], "Input",
  CellLabel->"In[26]:="],

Cell[BoxData[
    \({1, 3}\)], "Output",
  CellLabel->"Out[26]="]
}, Open  ]],

Cell["\<\
A maximal independent edge set of this graph has two edges opposite \
one another.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MaximalIndependentEdgeSet[g]\)], "Input",
  CellLabel->"In[27]:="],

Cell[BoxData[
    \({{1, 2}, {3, 4}}\)], "Output",
  CellLabel->"Out[27]="]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["StrongComponents",
                FontFamily->"Courier"], 
              StyleBox["[",
                "MR"], 
              StyleBox["g",
                "TI"], 
              StyleBox["]",
                
                "MR"]}], \(returns\ a\ list\ of\ all\ strongly\ connected\ \
components\ in\ a\ directed\ graph\)}
          }], TextForm]], "DefinitionBox",
  CellTags->"i:7"],

Cell["Finding strongly connected components.", "Caption"],

Cell["\<\
A strongly connected component in a directed graph is a set of \
vertices such that there is a path between any two vertices in the set. \
\
\>", "Text"],

Cell["\<\
This shows that in a directed graph of three nodes ordered in a \
circular fashion, the strongly connected component contains all the vertices.\
\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(StrongComponents[{1 \[Rule] 2, \ 2 \[Rule] 3, \ 
        3 \[Rule] 1}]\)], "Input",
  CellLabel->"In[28]:="],

Cell[BoxData[
    \({{1, 2, 3}}\)], "Output",
  CellLabel->"Out[28]="]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["MinCut",
                FontFamily->"Courier"], 
              StyleBox["[",
                "MR"], 
              StyleBox[\(g, \ k\),
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{Cell[TextData[{
                "partitions an undirected graph into ",
                Cell[BoxData[
                    \(TraditionalForm\`k\)]],
                " parts"
              }], "Text"], "with", " ", "minimal", " ", "edge", " ", 
              "cuts"}]}
          }], TextForm]], "DefinitionBox",
  CellTags->"i:8"],

Cell["Finding a mincut.", "Caption"],

Cell["This shows a graph of 6 vertices.", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(GraphPlot[
        g = {1 \[Rule] 2, 2 \[Rule] 1, 1 -> 3, 3 \[Rule] 1, 2 \[Rule] 3, 
            3 \[Rule] 2, 2 \[Rule] 4, 4 \[Rule] 2, 4 \[Rule] 5, 5 \[Rule] 4, 
            5 \[Rule] 6, 6 \[Rule] 5, 4 \[Rule] 6, 6 \[Rule] 4}, 
        VertexStyleFunction \[Rule] Automatic];\)\)], "Input",
  CellLabel->"In[29]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .22739 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.499592 0.476598 0.113699 0.476598 [
[.97582 .00541 -3 -4.5 ]
[.97582 .00541 3 4.5 ]
[.69751 .11367 -3 -4.5 ]
[.69751 .11367 3 4.5 ]
[.97619 .22198 -3 -4.5 ]
[.97619 .22198 3 4.5 ]
[.30238 .11369 -3 -4.5 ]
[.30238 .11369 3 4.5 ]
[.02381 .00554 -3 -4.5 ]
[.02381 .00554 3 4.5 ]
[.02388 .22194 -3 -4.5 ]
[.02388 .22194 3 4.5 ]
[ 0 0 0 0 ]
[ 1 .22739 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.97582 .00541 m
.69751 .11367 L
s
.97582 .00541 m
.97619 .22198 L
s
.69751 .11367 m
.97619 .22198 L
s
.69751 .11367 m
.30238 .11369 L
s
.30238 .11369 m
.02381 .00554 L
s
.30238 .11369 m
.02388 .22194 L
s
.02381 .00554 m
.02388 .22194 L
s
[(1)] .97582 .00541 0 0 Mshowa
[(2)] .69751 .11367 0 0 Mshowa
[(3)] .97619 .22198 0 0 Mshowa
[(4)] .30238 .11369 0 0 Mshowa
[(5)] .02381 .00554 0 0 Mshowa
[(6)] .02388 .22194 0 0 Mshowa
0 0 m
1 0 L
1 .22739 L
0 .22739 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[29]:=",
  ImageSize->{288, 65.4375},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000@B000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00503oool200000?40oooo1@00000D0?ooo`004`3o
ool010000000oooo0?ooo`00003b0?ooo`030000003oool0oooo01@0oooo000E0?ooo`800000l@3o
ool2000001H0oooo000D0?ooo`80000000<0oooo000000000000k@3oool2000000030?ooo`000000
oooo01D0oooo000D0?ooo`8000000`3oool300000>L0oooo0`0000030?ooo`030000003oool0oooo
01@0oooo000D0?ooo`<000001@3oool300000>40oooo0`0000050?ooo`8000005P3oool001D0oooo
00<000000?ooo`3oool01`3oool200000=d0oooo0P0000090?ooo`030000003oool0oooo01@0oooo
000E0?ooo`030000003oool0oooo00T0oooo0`00003G0?ooo`<000002`3oool00`000000oooo0?oo
o`0D0?ooo`005@3oool00`000000oooo0?ooo`0<0?ooo`<00000d@3oool3000000h0oooo00<00000
0?ooo`3oool0503oool001D0oooo00<000000?ooo`3oool03`3oool200000<d0oooo0P00000A0?oo
o`030000003oool0oooo01@0oooo000E0?ooo`030000003oool0oooo0140oooo0`0000370?ooo`<0
00004`3oool00`000000oooo0?ooo`0D0?ooo`005@3oool00`000000oooo0?ooo`0D0?ooo`800000
``3oool2000001H0oooo00<000000?ooo`3oool0503oool001D0oooo00<000000?ooo`3oool05P3o
ool300000;d0oooo0`00000H0?ooo`030000003oool0oooo01@0oooo000E0?ooo`030000003oool0
oooo01T0oooo0`00002g0?ooo`<000006`3oool00`000000oooo0?ooo`0D0?ooo`005@3oool00`00
0000oooo0?ooo`0L0?ooo`800000/`3oool2000001h0oooo00<000000?ooo`3oool0503oool001D0
oooo00<000000?ooo`3oool07P3oool300000:d0oooo0`00000P0?ooo`030000003oool0oooo01@0
oooo000E0?ooo`030000003oool0oooo0240oooo0`00002W0?ooo`<000008`3oool00`000000oooo
0?ooo`0D0?ooo`005@3oool00`000000oooo0?ooo`0T0?ooo`800000X`3oool2000002H0oooo00<0
00000?ooo`3oool0503oool001D0oooo00<000000?ooo`3oool09P3oool3000009d0oooo0`00000X
0?ooo`030000003oool0oooo01@0oooo000E0?ooo`030000003oool0oooo02T0oooo0`00002G0?oo
o`<00000:`3oool00`000000oooo0?ooo`0D0?ooo`005@3oool00`000000oooo0?ooo`0/0?ooo`80
0000T`3oool2000002h0oooo00<000000?ooo`3oool0503oool001D0oooo00<000000?ooo`3oool0
;P3oool3000008d0oooo0`00000`0?ooo`030000003oool0oooo01@0oooo000E0?ooo`030000003o
ool0oooo0340oooo0P0000290?ooo`800000<`3oool00`000000oooo0?ooo`0D0?ooo`005@3oool0
0`000000oooo0?ooo`0c0?ooo`<00000P`3oool3000003D0oooo00<000000?ooo`3oool0503oool0
01D0oooo00<000000?ooo`3oool0=P3oool3000007d0oooo0`00000h0?ooo`030000003oool0oooo
01@0oooo000E0?ooo`030000003oool0oooo03T0oooo0P00001i0?ooo`800000>`3oool00`000000
oooo0?ooo`0D0?ooo`005@3oool00`000000oooo0?ooo`0k0?ooo`<00000L`3oool3000003d0oooo
00<000000?ooo`3oool0503oool001D0oooo00<000000?ooo`3oool0?P3oool3000000<0oooo0`00
001Q0?ooo`@000000P3oool300000400oooo00<000000?ooo`3oool0503oool001D0oooo00<00000
0?ooo`3oool0@@3oool200000080oooo00<000000?ooo`3oool0H03oool010000000oooo0?ooo`3o
ool2000004<0oooo00<000000?ooo`3oool0503oool001D0oooo00<000000?ooo`3oool0@P3ooomZ
000004D0oooo00<000000?ooo`3oool0503oool001D0oooo00<000000?ooo`3oool0@@3oool20000
0080oooo00<000000?ooo`3oool0HP3oool010000000oooo0000000000130?ooo`030000003oool0
oooo01@0oooo000E0?ooo`030000003oool0oooo03h0oooo0`0000020?ooo`030000003oool00000
0680oooo00@000000?ooo`3oool000000P3oool300000400oooo00<000000?ooo`3oool0503oool0
01D0oooo00<000000?ooo`3oool0?03oool2000000H0oooo0P00001S0?ooo`8000001P3oool20000
03h0oooo00<000000?ooo`3oool0503oool001D0oooo00<000000?ooo`3oool0>@3oool3000007L0
oooo0`00000k0?ooo`030000003oool0oooo01@0oooo000E0?ooo`030000003oool0oooo03L0oooo
0P00001m0?ooo`800000>@3oool00`000000oooo0?ooo`0D0?ooo`005@3oool00`000000oooo0?oo
o`0d0?ooo`<00000P@3oool3000003H0oooo00<000000?ooo`3oool0503oool001D0oooo00<00000
0?ooo`3oool0<@3oool3000008L0oooo0`00000c0?ooo`030000003oool0oooo01@0oooo000E0?oo
o`030000003oool0oooo02l0oooo0P00002=0?ooo`800000<@3oool00`000000oooo0?ooo`0D0?oo
o`005@3oool00`000000oooo0?ooo`0/0?ooo`<00000T@3oool3000002h0oooo00<000000?ooo`3o
ool0503oool001D0oooo00<000000?ooo`3oool0:P3oool2000009L0oooo0P00000/0?ooo`030000
003oool0oooo01@0oooo000E0?ooo`030000003oool0oooo02L0oooo0`00002K0?ooo`<00000:@3o
ool00`000000oooo0?ooo`0D0?ooo`005@3oool00`000000oooo0?ooo`0U0?ooo`800000X@3oool2
000002L0oooo00<000000?ooo`3oool0503oool001D0oooo00<000000?ooo`3oool08P3oool30000
0:D0oooo0`00000T0?ooo`030000003oool0oooo01@0oooo000E0?ooo`030000003oool0oooo0200
oooo0P00002[0?ooo`8000008P3oool00`000000oooo0?ooo`0D0?ooo`005@3oool00`000000oooo
0?ooo`0M0?ooo`<00000[`3oool3000001l0oooo00<000000?ooo`3oool0503oool001D0oooo00<0
00000?ooo`3oool06`3oool200000;D0oooo0P00000M0?ooo`030000003oool0oooo01@0oooo000E
0?ooo`030000003oool0oooo01P0oooo0`00002i0?ooo`<000006P3oool00`000000oooo0?ooo`0D
0?ooo`005@3oool00`000000oooo0?ooo`0F0?ooo`800000_`3oool2000001P0oooo00<000000?oo
o`3oool0503oool001D0oooo00<000000?ooo`3oool04`3oool300000<<0oooo0`00000E0?ooo`03
0000003oool0oooo01@0oooo000E0?ooo`030000003oool0oooo0140oooo0P0000390?ooo`800000
4`3oool00`000000oooo0?ooo`0D0?ooo`005@3oool00`000000oooo0?ooo`0>0?ooo`<00000c@3o
ool300000100oooo00<000000?ooo`3oool0503oool001D0oooo00<000000?ooo`3oool02`3oool3
00000=<0oooo0`00000=0?ooo`030000003oool0oooo01@0oooo000E0?ooo`030000003oool0oooo
00T0oooo0P00003I0?ooo`8000002`3oool00`000000oooo0?ooo`0D0?ooo`005@3oool00`000000
oooo0?ooo`060?ooo`<00000g@3oool3000000P0oooo00<000000?ooo`3oool0503oool001D0oooo
00<000000?ooo`3oool0103oool200000><0oooo0P0000060?ooo`030000003oool0oooo01@0oooo
000C0?ooo`<000000`3oool300000>L0oooo0`0000020?ooo`8000005P3oool001<0oooo00<00000
0?ooo`0000000`00003]0?ooo`80000000<0oooo0000000000005@3oool001<0oooo00@000000?oo
o`0000000000l@3oool2000001H0oooo000C0?ooo`<00000m03oool00`000000oooo0?ooo`0C0?oo
o`00503oool00`000000oooo0?ooo`3`0?ooo`040000003oool0oooo000001D0oooo000D0?ooo`<0
0000l@3oool2000001H0oooo003o0?ooob40oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {64.4375, 0}} -> {-1.17539, -0.264101, \
0.00819685, 0.00819685}}]
}, Open  ]],

Cell["\<\
This shows the best partitioning of the graph into two parts. This \
partitioning only cuts through one edge, between vertices 2 and 4.\
\>", \
"MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MinCut[g, 2]\)], "Input",
  CellLabel->"In[30]:="],

Cell[BoxData[
    \({{1, 2, 3}, {4, 5, 6}}\)], "Output",
  CellLabel->"Out[30]="]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["VertexList",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["g",
                "TI"], 
              StyleBox["]",
                "MR"]}], \(gives\ a\ list\ of\ all\ vertices\)}
          }], TextForm]], "DefinitionBox",
  CellTags->{"VertexList", "i:9"}],

Cell["Getting a list of all vertices.", "Caption"],

Cell["\<\
 This function is particularly useful for graphs specified using a \
rule list.\
\>", "Text"],

Cell["This specifies a graph using a rule list.", "MathCaption"],

Cell[BoxData[{
    \(\(Clear[a, b, d];\)\), "\[IndentingNewLine]", 
    \(\(g = {b \[Rule] a, b \[Rule] d, a \[Rule] b};\)\)}], "Input",
  CellLabel->"In[31]:="],

Cell["This gives the list of vertices.", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(VertexList[g]\)], "Input",
  CellLabel->"In[33]:="],

Cell[BoxData[
    \({b, a, d}\)], "Output",
  CellLabel->"Out[33]="]
}, Open  ]],

Cell[TextData[{
  "For further information, see the ",
  ButtonBox["Advanced Documentation",
    ButtonData:>{"Advanced Documentation: GraphPlot", None},
    ButtonStyle->"RefGuideLinkText"],
  " for ",
  StyleBox["GraphPlot", "MR"],
  "."
}], "Text"]
}, Open  ]]
},
FrontEndVersion->"5.1 for Microsoft Windows",
ScreenRectangle->{{0, 1152}, {0, 784}},
AutoGeneratedPackage->None,
ScreenStyleEnvironment->"Brackets",
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
ShowSelection->True,
TaggingRules:>{"NextIndexingNumber" -> 10, "IndexEntries" -> {{"i:1", {
  StyleBox[ "GraphPlot", "MR"], " package"}}, {"i:2", 
  StyleBox[ "GraphPlot", "MR"]}, {"i:2", 
  StyleBox[ "GraphPlot3D", "MR"]}, {"i:3", 
  StyleBox[ "GraphCoordinates", "MR"]}, {"i:3", 
  StyleBox[ "GraphCoordinates3D", "MR"]}, {"i:4", 
  StyleBox[ "TreePlot", "MR"]}, {"i:4", 
  StyleBox[ "TreePlot3D", "MR"]}, {"i:5", 
  StyleBox[ "GraphDistance", "MR"]}, {"i:5", 
  StyleBox[ "PseudoDiameter", "MR"]}, {"i:6", 
  StyleBox[ "MaximalBipartiteMatching", "MR"]}, {"i:7", 
  StyleBox[ "StrongComponents", "MR"]}, {"i:8", 
  StyleBox[ "MinCut", "MR"]}, {"i:9", 
  StyleBox[ "VertexList", "MR"]}, {"i:6", 
  StyleBox[ "MaximalIndependentEdgeSet", "MR"], "", ""}, {"i:6", 
  StyleBox[ "MaximalIndependentVertexSet", "MR"], "", ""}}},
Magnification->1,
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "i:1"->{
    Cell[1776, 53, 60, 1, 65, "Section",
      CellTags->"i:1"]},
  "i:2"->{
    Cell[2414, 73, 1049, 35, 104, "DefinitionBox",
      CellTags->"i:2"]},
  "GraphCoordinates"->{
    Cell[453503, 23534, 1097, 35, 104, "DefinitionBox",
      CellTags->{"GraphCoordinates", "i:3"}]},
  "i:3"->{
    Cell[453503, 23534, 1097, 35, 104, "DefinitionBox",
      CellTags->{"GraphCoordinates", "i:3"}]},
  "i:4"->{
    Cell[491810, 24200, 1555, 43, 68, "DefinitionBox",
      CellTags->"i:4"]},
  "i:5"->{
    Cell[550049, 25270, 1568, 51, 66, "DefinitionBox",
      CellTags->"i:5"]},
  "i:6"->{
    Cell[619274, 26487, 1885, 52, 222, "DefinitionBox",
      CellTags->"i:6"]},
  "i:7"->{
    Cell[623551, 26633, 478, 15, 58, "DefinitionBox",
      CellTags->"i:7"]},
  "i:8"->{
    Cell[624675, 26676, 656, 20, 60, "DefinitionBox",
      CellTags->"i:8"]},
  "VertexList"->{
    Cell[633254, 26886, 403, 13, 42, "DefinitionBox",
      CellTags->{"VertexList", "i:9"}]},
  "i:9"->{
    Cell[633254, 26886, 403, 13, 42, "DefinitionBox",
      CellTags->{"VertexList", "i:9"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"i:1", 636149, 26977},
  {"i:2", 636226, 26980},
  {"GraphCoordinates", 636326, 26983},
  {"i:3", 636440, 26986},
  {"i:4", 636554, 26989},
  {"i:5", 636645, 26992},
  {"i:6", 636736, 26995},
  {"i:7", 636828, 26998},
  {"i:8", 636918, 27001},
  {"VertexList", 637015, 27004},
  {"i:9", 637121, 27007}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 60, 1, 65, "Section",
  CellTags->"i:1"],
Cell[1839, 56, 326, 7, 59, "Text"],
Cell[2168, 65, 243, 6, 42, "Text"],
Cell[2414, 73, 1049, 35, 104, "DefinitionBox",
  CellTags->"i:2"],
Cell[3466, 110, 43, 0, 17, "Caption"],
Cell[3512, 112, 46, 0, 41, "MathCaption"],
Cell[3561, 114, 88, 2, 29, "Input"],
Cell[3652, 118, 67, 0, 41, "MathCaption"],

Cell[CellGroupData[{
Cell[3744, 122, 380, 6, 69, "Input"],
Cell[4127, 130, 27661, 491, 294, 3762, 191, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]],
Cell[31803, 624, 215, 6, 58, "MathCaption"],

Cell[CellGroupData[{
Cell[32043, 634, 166, 4, 49, "Input"],
Cell[32212, 640, 31256, 846, 207, 7244, 544, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]],
Cell[63483, 1489, 260, 6, 58, "MathCaption"],
Cell[63746, 1497, 151, 4, 49, "Input"],

Cell[CellGroupData[{
Cell[63922, 1505, 76, 2, 29, "Input"],
Cell[64001, 1509, 195596, 14920, 205, 165045, 14538, "GraphicsData", \
"PostScript", "Graphics"]
}, Open  ]],
Cell[259612, 16432, 309, 10, 42, "Text"],
Cell[259924, 16444, 2770, 90, 264, "DefinitionBox3Col"],
Cell[262697, 16536, 129, 6, 17, "Caption"],
Cell[262829, 16544, 116, 3, 41, "MathCaption"],

Cell[CellGroupData[{
Cell[262970, 16551, 265, 6, 69, "Input"],
Cell[263238, 16559, 126713, 5457, 215, 56483, 4585, "GraphicsData", \
"PostScript", "Graphics"]
}, Open  ]],
Cell[389966, 22019, 784, 24, 109, "MathCaption"],

Cell[CellGroupData[{
Cell[390775, 22047, 1655, 27, 329, "Input"],
Cell[392433, 22076, 61036, 1453, 287, 16004, 892, "GraphicsData", \
"PostScript", "Graphics"]
}, Open  ]],
Cell[453484, 23532, 16, 0, 25, "Text"],
Cell[453503, 23534, 1097, 35, 104, "DefinitionBox",
  CellTags->{"GraphCoordinates", "i:3"}],
Cell[454603, 23571, 67, 0, 17, "Caption"],
Cell[454673, 23573, 42, 0, 41, "MathCaption"],

Cell[CellGroupData[{
Cell[454740, 23577, 450, 7, 109, "Input"],
Cell[455193, 23586, 33124, 511, 260, 1577, 116, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]],
Cell[488332, 24100, 100, 3, 41, "MathCaption"],

Cell[CellGroupData[{
Cell[488457, 24107, 89, 2, 29, "Input"],
Cell[488549, 24111, 748, 13, 122, "Output"]
}, Open  ]],
Cell[489312, 24127, 168, 5, 25, "Text"],
Cell[489483, 24134, 1184, 30, 180, "DefinitionBox3Col"],
Cell[490670, 24166, 137, 5, 17, "Caption"],
Cell[490810, 24173, 82, 1, 41, "MathCaption"],

Cell[CellGroupData[{
Cell[490917, 24178, 119, 3, 29, "Input"],
Cell[491039, 24183, 756, 14, 122, "Output"]
}, Open  ]],
Cell[491810, 24200, 1555, 43, 68, "DefinitionBox",
  CellTags->"i:4"],
Cell[493368, 24245, 85, 4, 17, "Caption"],
Cell[493456, 24251, 48, 0, 41, "MathCaption"],

Cell[CellGroupData[{
Cell[493529, 24255, 213, 5, 49, "Input"],
Cell[493745, 24262, 28993, 497, 155, 2170, 161, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]],
Cell[522753, 24762, 170, 5, 25, "Text"],
Cell[522926, 24769, 626, 17, 104, "DefinitionBox3Col"],
Cell[523555, 24788, 78, 3, 17, "Caption"],
Cell[523636, 24793, 94, 3, 41, "MathCaption"],

Cell[CellGroupData[{
Cell[523755, 24800, 105, 2, 29, "Input"],
Cell[523863, 24804, 26171, 463, 294, 2153, 161, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]],
Cell[550049, 25270, 1568, 51, 66, "DefinitionBox",
  CellTags->"i:5"],
Cell[551620, 25323, 60, 0, 17, "Caption"],
Cell[551683, 25325, 57, 0, 41, "MathCaption"],

Cell[CellGroupData[{
Cell[551765, 25329, 1537, 26, 229, "Input"],
Cell[553305, 25357, 65062, 1090, 293, 5852, 354, "GraphicsData", \
"PostScript", "Graphics"]
}, Open  ]],
Cell[618382, 26450, 356, 7, 75, "MathCaption"],

Cell[CellGroupData[{
Cell[618763, 26461, 132, 3, 49, "Input"],
Cell[618898, 26466, 73, 2, 27, "Output"]
}, Open  ]],
Cell[618986, 26471, 103, 3, 41, "MathCaption"],

Cell[CellGroupData[{
Cell[619114, 26478, 82, 2, 29, "Input"],
Cell[619199, 26482, 60, 2, 27, "Output"]
}, Open  ]],
Cell[619274, 26487, 1885, 52, 222, "DefinitionBox",
  CellTags->"i:6"],
Cell[621162, 26541, 126, 3, 17, "Caption"],
Cell[621291, 26546, 740, 25, 60, "Text"],
Cell[622034, 26573, 180, 4, 58, "MathCaption"],

Cell[CellGroupData[{
Cell[622239, 26581, 119, 3, 29, "Input"],
Cell[622361, 26586, 83, 2, 27, "Output"]
}, Open  ]],
Cell[622459, 26591, 276, 5, 59, "Text"],
Cell[622738, 26598, 201, 4, 58, "MathCaption"],

Cell[CellGroupData[{
Cell[622964, 26606, 187, 4, 49, "Input"],
Cell[623154, 26612, 65, 2, 27, "Output"]
}, Open  ]],
Cell[623234, 26617, 113, 3, 41, "MathCaption"],

Cell[CellGroupData[{
Cell[623372, 26624, 86, 2, 29, "Input"],
Cell[623461, 26628, 75, 2, 27, "Output"]
}, Open  ]],
Cell[623551, 26633, 478, 15, 58, "DefinitionBox",
  CellTags->"i:7"],
Cell[624032, 26650, 57, 0, 17, "Caption"],
Cell[624092, 26652, 163, 4, 42, "Text"],
Cell[624258, 26658, 176, 4, 58, "MathCaption"],

Cell[CellGroupData[{
Cell[624459, 26666, 128, 3, 29, "Input"],
Cell[624590, 26671, 70, 2, 27, "Output"]
}, Open  ]],
Cell[624675, 26676, 656, 20, 60, "DefinitionBox",
  CellTags->"i:8"],
Cell[625334, 26698, 36, 0, 17, "Caption"],
Cell[625373, 26700, 56, 0, 41, "MathCaption"],

Cell[CellGroupData[{
Cell[625454, 26704, 338, 6, 69, "Input"],
Cell[625795, 26712, 7082, 154, 72, 1337, 78, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]],
Cell[632892, 26869, 168, 4, 58, "MathCaption"],

Cell[CellGroupData[{
Cell[633085, 26877, 70, 2, 29, "Input"],
Cell[633158, 26881, 81, 2, 27, "Output"]
}, Open  ]],
Cell[633254, 26886, 403, 13, 42, "DefinitionBox",
  CellTags->{"VertexList", "i:9"}],
Cell[633660, 26901, 50, 0, 17, "Caption"],
Cell[633713, 26903, 103, 3, 25, "Text"],
Cell[633819, 26908, 64, 0, 41, "MathCaption"],
Cell[633886, 26910, 161, 3, 49, "Input"],
Cell[634050, 26915, 55, 0, 41, "MathCaption"],

Cell[CellGroupData[{
Cell[634130, 26919, 71, 2, 29, "Input"],
Cell[634204, 26923, 68, 2, 27, "Output"]
}, Open  ]],
Cell[634287, 26928, 251, 8, 25, "Text"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

