(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   2079312,     103653]*)
(*NotebookOutlinePosition[   2096326,     104119]*)
(*  CellTagsIndexPosition[   2095184,     104076]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Graphics",
 StyleBox["`", "MB"],
 "Graphics3D",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.33.1", "1.1"}],

Cell[TextData[{
 "You can do most standard plots in three dimensions using the \
built\[Hyphen]in functions ",
 StyleBox["Plot3D", "MR"],
 ", ",
 StyleBox["ListPlot3D", "MR"],
 ", and ",
 StyleBox["ParametricPlot3D", "MR"],
 ". In certain situations, you may want to display your data in a more \
specialized format, such as a three\[Hyphen]dimensional bar chart or a \
scatter plot. You may also want special effects, such as shadows or \
projections. In these cases you can use the functions in this package to \
produce the appropriate plot. "
}], "Text",
 CellTags->{"S5.33.1", "1.2"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["BarChart3D[{{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["z",
          "TI"], "11"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["z",
          "TI"], "12"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] }, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["z",
          "TI"], "21"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["z",
          "TI"], "22"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] }, \[Ellipsis] }]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "make a three\[Hyphen]dimensional bar chart using the rectangular array \
of heights ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["z",
          "TI"], 
         StyleBox[
          RowBox[{"x", "y"}],
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["BarChart3D[{{{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["z",
          "TI"], "11"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["style",
          "TI"], "11"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["z",
          "TI"], "12"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["style",
          "TI"], "12"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, \[Ellipsis] }, \[Ellipsis] }]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["use the specified styles",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.33.1"],

Cell["\<\
Making three\[Hyphen]dimensional bar charts. \
\>", "Caption",
 CellTags->"S5.33.1"],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.33.1", "1.3"}],

Cell["<<Graphics`Graphics3D`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.33.1"],

Cell["\<\
This gives a bar chart made from a two\[Hyphen]by\[Hyphen]three array of bars \
with integer height. \
\>", "MathCaption",
 CellTags->{"S5.33.1", "1.4"}],

Cell[CellGroupData[{

Cell["BarChart3D[{{1, 2, 3}, {4, 5, 6}}]", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.33.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.0855 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0567234 1.16608 -4.6187e-17 1.16608 [
[.09072 .22988 -17.7473 -9 ]
[.09072 .22988 .25272 0 ]
[.21906 .17566 -5.65366 -9 ]
[.21906 .17566 .34634 0 ]
[.3545 .11847 -16.1747 -9 ]
[.3545 .11847 1.82534 0 ]
[.49765 .05807 -5.12945 -9 ]
[.49765 .05807 .87055 0 ]
[.64919 -0.00583 -14.602 -9 ]
[.64919 -0.00583 3.39797 0 ]
[.08508 .87939 -3.38969 0 ]
[.08508 .87939 2.61031 9 ]
[.22056 .97437 -3.26269 0 ]
[.22056 .97437 2.73731 9 ]
[.33861 1.05713 -3.15753 0 ]
[.33861 1.05713 2.84247 9 ]
[.07325 .26228 -6 -2.6177 ]
[.07325 .26228 0 6.3823 ]
[.04822 .41894 -6 -2.75702 ]
[.04822 .41894 0 6.24298 ]
[.0202 .59437 -6 -2.91482 ]
[.0202 .59437 0 6.08518 ]
[-0.01139 .79218 -6 -3.09501 ]
[-0.01139 .79218 0 5.90499 ]
[ 0 0 0 0 ]
[ 1 1.0855 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.08846 .24555 m
.67245 0 L
s
.10087 .24033 m
.10595 .24556 L
s
[(0.5)] .09072 .22988 .97192 1 Mshowa
.22871 .18658 m
.23354 .19204 L
s
[(1)] .21906 .17566 .88455 1 Mshowa
.36358 .12987 m
.36813 .13557 L
s
[(1.5)] .3545 .11847 .79718 1 Mshowa
.50609 .06995 m
.51031 .07589 L
s
[(2)] .49765 .05807 .70982 1 Mshowa
.65689 .00654 m
.66074 .01273 L
s
[(2.5)] .64919 -0.00583 .62245 1 Mshowa
.125 Mabswid
.12591 .22981 m
.12892 .23297 L
s
.1512 .21917 m
.15419 .22236 L
s
.17676 .20842 m
.17972 .21164 L
s
.2026 .19756 m
.20553 .20081 L
s
.25511 .17548 m
.25797 .17879 L
s
.28179 .16426 m
.28462 .1676 L
s
.30875 .15292 m
.31155 .15628 L
s
.33602 .14146 m
.33878 .14485 L
s
.39145 .11815 m
.39414 .1216 L
s
.41963 .1063 m
.42229 .10978 L
s
.44813 .09432 m
.45074 .09783 L
s
.47695 .0822 m
.47952 .08574 L
s
.53556 .05756 m
.53805 .06115 L
s
.56537 .04502 m
.56782 .04865 L
s
.59553 .03235 m
.59793 .036 L
s
.62603 .01952 m
.62839 .0232 L
s
.25 Mabswid
0 .80374 m
.40037 1.0855 L
s
.08695 .86493 m
.08789 .8577 L
s
[(1)] .08508 .87939 .1299 -1 Mshowa
.22183 .95985 m
.22246 .95259 L
s
[(2)] .22056 .97437 .08756 -1 Mshowa
.33938 1.04257 m
.33976 1.03529 L
s
[(3)] .33861 1.05713 .05251 -1 Mshowa
.125 Mabswid
.1155 .88502 m
.11602 .88068 L
s
.14322 .90453 m
.14371 .90018 L
s
.17016 .92349 m
.17061 .91914 L
s
.19636 .94192 m
.19677 .93757 L
s
.24661 .97729 m
.24696 .97293 L
s
.27073 .99426 m
.27105 .9899 L
s
.29422 1.01079 m
.29451 1.00643 L
s
.31709 1.02689 m
.31735 1.02252 L
s
.05756 .84424 m
.05816 .83991 L
s
.02727 .82293 m
.02791 .8186 L
s
.3611 1.05786 m
.3613 1.05349 L
s
.38228 1.07276 m
.38245 1.06839 L
s
.25 Mabswid
.08846 .24555 m
0 .80374 L
s
.0867 .25665 m
.09342 .25384 L
s
[(0)] .07325 .26228 1 -0.41829 Mshowa
.06181 .41367 m
.06861 .41104 L
s
[(2)] .04822 .41894 1 -0.38733 Mshowa
.03395 .58953 m
.04082 .58711 L
s
[(4)] .0202 .59437 1 -0.35226 Mshowa
.00252 .78784 m
.00948 .78567 L
s
[(6)] -0.01139 .79218 1 -0.31222 Mshowa
.125 Mabswid
.08073 .29431 m
.08477 .29265 L
s
.0746 .333 m
.07865 .33137 L
s
.0683 .37277 m
.07236 .37117 L
s
.05515 .45574 m
.05924 .45419 L
s
.04829 .49904 m
.05239 .49752 L
s
.04122 .54362 m
.04533 .54213 L
s
.02645 .63684 m
.03058 .63543 L
s
.01872 .68562 m
.02287 .68424 L
s
.01075 .73593 m
.01491 .73458 L
s
.25 Mabswid
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.40037 1.0855 L
s
.40037 1.0855 m
.41799 .58158 L
s
.41799 .58158 m
.08846 .24555 L
s
.67245 0 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.67245 0 m
.08846 .24555 L
s
.41799 .58158 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.40037 1.0855 L
s
.40037 1.0855 m
.41799 .58158 L
s
0 0 m
1 0 L
1 1.0855 L
0 1.0855 L
closepath
clip
newpath
.5 Mabswid
.672 .728 .891 r
.65504 .5055 m .42216 .58164 L .32951 .48692 L p F P
0 g
s
.573 .367 .563 r
.66477 .73412 m .65504 .5055 L .42216 .58164 L p F P
0 g
s
.573 .367 .563 r
.42216 .58164 m .41465 .80504 L .66477 .73412 L p F P
0 g
s
.938 .685 .528 r
.32951 .48692 m .42216 .58164 L .41465 .80504 L p F P
0 g
s
.672 .728 .891 r
.91022 .42206 m .65504 .5055 L .57178 .40165 L p F P
0 g
s
.573 .367 .563 r
.97657 .93008 m .91022 .42206 L .65504 .5055 L p F P
0 g
s
.573 .367 .563 r
.65504 .5055 m .6761 1.00015 L .97657 .93008 L p F P
0 g
s
.672 .728 .891 r
.32951 .48692 m .57178 .40165 L .65504 .5055 L p F P
0 g
s
.938 .685 .528 r
.41465 .80504 m .31445 .71675 L .32951 .48692 L p F P
0 g
s
.656 .751 .92 r
.66477 .73412 m .41465 .80504 L .31445 .71675 L p F P
0 g
s
.656 .751 .92 r
.31445 .71675 m .57544 .63664 L .66477 .73412 L p F P
0 g
s
.966 .687 .452 r
.57178 .40165 m .65504 .5055 L .6761 1.00015 L p F P
0 g
s
.966 .687 .452 r
.57178 .40165 m .65504 .5055 L .66477 .73412 L p F P
0 g
s
.555 .34 .543 r
.57544 .63664 m .57178 .40165 L .32951 .48692 L p F P
0 g
s
.555 .34 .543 r
.32951 .48692 m .31445 .71675 L .57544 .63664 L p F P
0 g
s
.672 .728 .891 r
.57178 .40165 m .32951 .48692 L .22569 .38079 L p F P
0 g
s
.555 .34 .543 r
.57416 .55422 m .57178 .40165 L .32951 .48692 L p F P
0 g
s
.555 .34 .543 r
.32951 .48692 m .31972 .63633 L .57416 .55422 L p F P
0 g
s
.938 .685 .528 r
.22569 .38079 m .32951 .48692 L .31972 .63633 L p F P
0 g
s
.672 .728 .891 r
.57178 .40165 m .83871 .30771 L .91022 .42206 L p F P
0 g
s
.973 .663 .31 r
.83871 .30771 m .91022 .42206 L .97657 .93008 L p F P
0 g
s
.555 .34 .543 r
.89671 .83222 m .83871 .30771 L .57178 .40165 L p F P
0 g
s
.966 .687 .452 r
.6761 1.00015 m .57974 .91277 L .57178 .40165 L p F P
0 g
s
.966 .687 .452 r
.66477 .73412 m .57544 .63664 L .57178 .40165 L p F P
0 g
s
.555 .34 .543 r
.57178 .40165 m .57974 .91277 L .89671 .83222 L p F P
0 g
s
.672 .728 .891 r
.83871 .30771 m .57178 .40165 L .47797 .28465 L p F P
0 g
s
.555 .34 .543 r
.88559 .73168 m .83871 .30771 L .57178 .40165 L p F P
0 g
s
.555 .34 .543 r
.57178 .40165 m .57823 .81551 L .88559 .73168 L p F P
0 g
s
.672 .728 .891 r
.22569 .38079 m .47797 .28465 L .57178 .40165 L p F P
0 g
s
.938 .685 .528 r
.31972 .63633 m .20979 .53407 L .22569 .38079 L p F P
0 g
s
.662 .743 .91 r
.57416 .55422 m .31972 .63633 L .20979 .53407 L p F P
0 g
s
.662 .743 .91 r
.20979 .53407 m .47527 .4409 L .57416 .55422 L p F P
0 g
s
.966 .687 .452 r
.47797 .28465 m .57178 .40165 L .57823 .81551 L p F P
0 g
s
.966 .687 .452 r
.47797 .28465 m .57178 .40165 L .57416 .55422 L p F P
0 g
s
.531 .306 .518 r
.47527 .4409 m .47797 .28465 L .22569 .38079 L p F P
0 g
s
.531 .306 .518 r
.22569 .38079 m .20979 .53407 L .47527 .4409 L p F P
0 g
s
.672 .728 .891 r
.47797 .28465 m .22569 .38079 L .10855 .26104 L p F P
0 g
s
.531 .306 .518 r
.47666 .36066 m .47797 .28465 L .22569 .38079 L p F P
0 g
s
.531 .306 .518 r
.22569 .38079 m .21795 .45546 L .47666 .36066 L p F P
0 g
s
.938 .685 .528 r
.10855 .26104 m .22569 .38079 L .21795 .45546 L p F P
0 g
s
.938 .685 .528 r
.21795 .45546 m .09708 .33734 L .10855 .26104 L p F P
0 g
s
.668 .735 .9 r
.47666 .36066 m .21795 .45546 L .09708 .33734 L p F P
0 g
s
.973 .663 .31 r
.97657 .93008 m .89671 .83222 L .83871 .30771 L p F P
0 g
s
.672 .728 .891 r
.47797 .28465 m .75764 .17807 L .83871 .30771 L p F P
0 g
s
.973 .663 .31 r
.75764 .17807 m .83871 .30771 L .88559 .73168 L p F P
0 g
s
.966 .687 .452 r
.57416 .55422 m .47527 .4409 L .47797 .28465 L p F P
0 g
s
.531 .306 .518 r
.79505 .614 m .75764 .17807 L .47797 .28465 L p F P
0 g
s
.966 .687 .452 r
.57823 .81551 m .47062 .71093 L .47797 .28465 L p F P
0 g
s
.531 .306 .518 r
.47797 .28465 m .47062 .71093 L .79505 .614 L p F P
0 g
s
.672 .728 .891 r
.75764 .17807 m .47797 .28465 L .37146 .15181 L p F P
0 g
s
.531 .306 .518 r
.78663 .51589 m .75764 .17807 L .47797 .28465 L p F P
0 g
s
.531 .306 .518 r
.47797 .28465 m .47226 .6156 L .78663 .51589 L p F P
0 g
s
.672 .728 .891 r
.10855 .26104 m .37146 .15181 L .47797 .28465 L p F P
0 g
s
.668 .735 .9 r
.09708 .33734 m .36697 .22926 L .47666 .36066 L p F P
0 g
s
.966 .687 .452 r
.37146 .15181 m .47797 .28465 L .47226 .6156 L p F P
0 g
s
.966 .687 .452 r
.37146 .15181 m .47797 .28465 L .47666 .36066 L p F P
0 g
s
.5 .261 .485 r
.36697 .22926 m .37146 .15181 L .10855 .26104 L p F P
0 g
s
.5 .261 .485 r
.10855 .26104 m .09708 .33734 L .36697 .22926 L p F P
0 g
s
.966 .687 .452 r
.47666 .36066 m .36697 .22926 L .37146 .15181 L p F P
0 g
s
.625 .78 .956 r
.97657 .93008 m .6761 1.00015 L .57974 .91277 L p F P
0 g
s
.973 .663 .31 r
.88559 .73168 m .79505 .614 L .75764 .17807 L p F P
0 g
s
.672 .728 .891 r
.37146 .15181 m .66497 .02988 L .75764 .17807 L p F P
0 g
s
.973 .663 .31 r
.66497 .02988 m .75764 .17807 L .78663 .51589 L p F P
0 g
s
.5 .261 .485 r
.68376 .37507 m .66497 .02988 L .37146 .15181 L p F P
0 g
s
.966 .687 .452 r
.47226 .6156 m .35178 .49112 L .37146 .15181 L p F P
0 g
s
.5 .261 .485 r
.37146 .15181 m .35178 .49112 L .68376 .37507 L p F P
0 g
s
.638 .77 .943 r
.88559 .73168 m .57823 .81551 L .47062 .71093 L p F P
0 g
s
.625 .78 .956 r
.57974 .91277 m .89671 .83222 L .97657 .93008 L p F P
0 g
s
.648 .761 .931 r
.78663 .51589 m .47226 .6156 L .35178 .49112 L p F P
0 g
s
.973 .663 .31 r
.78663 .51589 m .68376 .37507 L .66497 .02988 L p F P
0 g
s
.638 .77 .943 r
.47062 .71093 m .79505 .614 L .88559 .73168 L p F P
0 g
s
.648 .761 .931 r
.35178 .49112 m .68376 .37507 L .78663 .51589 L p F P
0 g
s
.25 Mabswid
.67245 0 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.67245 0 m
.08846 .24555 L
s
.08846 .24555 m
.67245 0 L
s
.10087 .24033 m
.10595 .24556 L
s
[(0.5)] .09072 .22988 .97192 1 Mshowa
.22871 .18658 m
.23354 .19204 L
s
[(1)] .21906 .17566 .88455 1 Mshowa
.36358 .12987 m
.36813 .13557 L
s
[(1.5)] .3545 .11847 .79718 1 Mshowa
.50609 .06995 m
.51031 .07589 L
s
[(2)] .49765 .05807 .70982 1 Mshowa
.65689 .00654 m
.66074 .01273 L
s
[(2.5)] .64919 -0.00583 .62245 1 Mshowa
.125 Mabswid
.12591 .22981 m
.12892 .23297 L
s
.1512 .21917 m
.15419 .22236 L
s
.17676 .20842 m
.17972 .21164 L
s
.2026 .19756 m
.20553 .20081 L
s
.25511 .17548 m
.25797 .17879 L
s
.28179 .16426 m
.28462 .1676 L
s
.30875 .15292 m
.31155 .15628 L
s
.33602 .14146 m
.33878 .14485 L
s
.39145 .11815 m
.39414 .1216 L
s
.41963 .1063 m
.42229 .10978 L
s
.44813 .09432 m
.45074 .09783 L
s
.47695 .0822 m
.47952 .08574 L
s
.53556 .05756 m
.53805 .06115 L
s
.56537 .04502 m
.56782 .04865 L
s
.59553 .03235 m
.59793 .036 L
s
.62603 .01952 m
.62839 .0232 L
s
.25 Mabswid
0 .80374 m
.40037 1.0855 L
s
.08695 .86493 m
.08789 .8577 L
s
[(1)] .08508 .87939 .1299 -1 Mshowa
.22183 .95985 m
.22246 .95259 L
s
[(2)] .22056 .97437 .08756 -1 Mshowa
.33938 1.04257 m
.33976 1.03529 L
s
[(3)] .33861 1.05713 .05251 -1 Mshowa
.125 Mabswid
.1155 .88502 m
.11602 .88068 L
s
.14322 .90453 m
.14371 .90018 L
s
.17016 .92349 m
.17061 .91914 L
s
.19636 .94192 m
.19677 .93757 L
s
.24661 .97729 m
.24696 .97293 L
s
.27073 .99426 m
.27105 .9899 L
s
.29422 1.01079 m
.29451 1.00643 L
s
.31709 1.02689 m
.31735 1.02252 L
s
.05756 .84424 m
.05816 .83991 L
s
.02727 .82293 m
.02791 .8186 L
s
.3611 1.05786 m
.3613 1.05349 L
s
.38228 1.07276 m
.38245 1.06839 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004/0000]2000`400?l00000o`00003oooooool]
ooooo`00XOooool5o`0000?ooooo00?o0000ooooooooool00_ooool3o`0007_ooooo002Rooooo`04
o`000?ooooooooooo`0000Oooooo00Go0000ooooooooooooooooo`00001jooooo`00Xoooool00ol0
003oooooooooo`0;ooooo`03o`000?oooooooooo07Sooooo002Tooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool0N?ooool00:7ooooo00Go0000ooooooooooooooooo`000007ooooo`Co
0000Noooool00:7ooooo00Go0000ooooooooooooooooo`000007ooooo`03o`000?oooooooooo07co
oooo002Rooooo`?o00002?ooool5o`0007[ooooo003oooooobgooooo003oooooobgooooo002boooo
o`;o0000N?ooool009?ooooo1Ol0000Hooooo`;o000000?oooooo`000?ooool0Moooool009Cooooo
00Co0000oooooooooooo00005Oooool3o`000003ooooool0003ooooo00;o0000Moooool009Gooooo
00?o0000ooooooooool04oooool2o`0000Kooooo00?o0000ooooool00000M_ooool009Kooooo00?o
0000ooooooooool04?ooool2o`000003ooooool0003ooooo00Gooooo00?o0000ooooool00000M_oo
ool009?ooooo00Go0000ooooooooooooooooo`00000>ooooo`?o00002?ooool3o`0000;ooooo00?o
0000ooooooooool0Loooool009?ooooo00Go0000ooooooooooooooooo`00000<ooooo`;o00000_oo
ool00ol0003oooooooooo`03ooooo`?o000000?oOd9lo`000?l000000_ooool00ol0003ooooooooo
o`1cooooo`00U?ooool3o`0000_ooooo0_l00008ooooo`;o00001?mo@W`2o`0000?ooooo00?o0000
ooooooooool0L_ooool009oooooo0ol000000ooooooo0000ooooo`04ooooo`?o00001_mo@W`3o`00
00?ooooo00?o0000ooooooooool0LOooool009gooooo0_l00008ooooo`;o00002Omo@W`3o`0000?o
oooo00?o0000ooooooooool0LOooool007Cooooo0ol00004ooooo`03o`000?oooooooooo00;ooooo
0ol0000Hooooo`;o00000_ooool00ol0003oooooooooo`02ooooo`?o00002omo@W`01?l0003onJU?
o`000?l00003ooooo`03o`000?oooooooooo073ooooo001eooooo`03o`000?oooooooooo00Oooooo
00Go0000ooooooooooooooooo`00000Dooooo`?o00001oooool2o`0000koOd9l00Go0000ooVYCol0
003onJU?o`000003ooooo`03o`000?oooooooooo06oooooo001eooooo`03o`000?oooooooooo00_o
oooo00?o0000ooooooooool04?ooool2o`0000;ooooo00?o0000ooooooooool00_ooool3o`00013o
Od9l00Go0000ooVYCol0003onJU?o`000003ooooo`03o`000?oooooooooo06oooooo001eooooo`03
o`000?oooooooooo00_ooooo00?o0000ooooooooool03_ooool3o`0000Kooooo0_l0000Cogm2O003
o`000?oiZDoo000000;onJU?00Go0000ooooooooooooooooo`00001`ooooo`00MOooool00ol0003o
ooooooooo`07ooooo`Co00003_ooool3o`0000Kooooo0ol0000Eogm2O003o`000?oiZDoo000000;o
nJU?00Go0000ooooooooooooooooo`00001`ooooo`00M?ooool2o`0000Wooooo00?o0000oooooooo
ool03Oooool3o`0000Kooooo0_l0000Iogm2O0;o00000ooiZDl01Ol0003ooooooooooooooooo0000
06oooooo001eooooo`03o`000?oooooooooo00Oooooo1Ol00009ooooo`;o00001_ooool3o`0001_o
Od9l0_l00004ooVYC`05o`000?ooooooooooooooool00000K_ooool008[ooooo1?l00005ooooo`;o
00007_mo@W`2o`0000ConJU?00Go0000ooooooooooooooooo`00001^ooooo`00R?ooool2o`0000Ko
oooo0ol0000Pogm2O0;o00001OoiZDl01Ol0003ooooooooooooooooo000006gooooo001Zooooo`?o
00006Oooool2o`000003ooooool0003ooooo00?ooooo0_l0000Sogm2O0;o00001_oiZDl01?l0003o
ooooooooool0001]ooooo`00Joooool00ol0003oooooooooo`0Fooooo`;o00001Oooool3o`0002Go
Od9l0_l00006ooVYC`05o`000?ooooooooooooooool00000K?ooool006_ooooo00?o0000oooooooo
ool04oooool3o`000003ooooool0003ooooo00;ooooo0_l0000Xogm2O0;o00001ooiZDl01Ol0003o
oooooooooooooooo000006_ooooo001[ooooo`03o`000?oooooooooo017ooooo0_l00005ooooo`?o
0000:_mo@W`2o`0000SonJU?00Co0000oooooooooooo0000Joooool006_ooooo00?o0000oooooooo
ool03oooool2o`0000Gooooo0_l0000]ogm2O0;o00002?oiZDl01Ol0003ooooooooooooooooo0000
06[ooooo001Zooooo`;o00003_ooool3o`0000Gooooo0_l000000omo@Wco0000ogm2O00/ogm2O0;o
00002OoiZDl01Ol0003ooooooooooooooooo000006Wooooo001[ooooo`03o`000?oooooooooo00[o
oooo0_l00005ooooo`?o00000omo@W`00ol0003oOd9logm2O00[ogm2O0;o00002OoiZDl01Ol0003o
oooooooooooooooo000006Wooooo001fooooo`?o00001?ooool2o`0000KoOd9l00?o0000ogm2O?mo
@W`0:omo@W`2o`0000[onJU?00Go0000ooooooooooooooooo`00001Xooooo`00Boooool2o`0000Co
oooo00?o0000ooooooooool00_ooool3o`0001[ooooo0ol00005ooooo`;o00002?mo@W`00ol0003o
Od9logm2O00[ogm2O0;o00002ooiZDl01?l0003oooooooooool0001Xooooo`00B_ooool01?l0003o
ooooooooool00007ooooo`05o`000?ooooooooooooooool000005oooool2o`0000Gooooo0ol0000:
ogm2O003o`000?mo@WcoOd9l02_oOd9l00?o0000ooVYCol000002_oiZDl01Ol0003ooooooooooooo
oooo000006Oooooo001:ooooo`04o`000?ooooooooooo`0000_ooooo00?o0000ooooooooool04ooo
ool3o`0000Cooooo0_l0000=ogm2O003o`000?mo@WcoOd9l02_oOd9l00?o0000ooVYCol000002_oi
ZDl2o`0000?ooooo00?o0000ooooooooool0I?ooool004[ooooo00Co0000oooooooooooo00002ooo
ool00ol0003oooooooooo`0@ooooo`?o00001Oooool2o`0000ooOd9l00?o0000ogm2O?mo@W`0:omo
@W`00ol0003onJU?o`00000:ooVYC`03o`000?oiZDoo000000;ooooo00?o0000ooooooooool0I?oo
ool004[ooooo00Co0000oooooooooooo00001oooool4o`00017ooooo0ol00004ooooo`?o00004Omo
@W`00ol0003oOd9logm2O00[ogm2O003o`000?oiZDoo000000[onJU?00?o0000ooVYCol000000ooo
ool00ol0003oooooooooo`1Sooooo`00B_ooool01?l0003oooooooooool00007ooooo`03o`000?oo
oooooooo013ooooo0_l00005ooooo`;o00005?mo@W`00ol0003oOd9logm2O00/ogm2O0;o00002_oi
ZDl01?l0003onJU?ooVYCol00003ooooo`03o`000?oooooooooo06;ooooo001;ooooo`;o00002?oo
ool5o`0000_ooooo0ol00005ooooo`;o00005Omo@W`00ol0003oOd9logm2O00]ogm2O0;o00002_oi
ZDl2o`000003ooVYCol0003ooooo00;ooooo00?o0000ooooooooool0H_ooool006?ooooo0_l00006
ooooo`;o00005omo@W`00ol0003oOd9logm2O00]ogm2O0;o00002ooiZDl01?l0003onJU?ooVYCol0
0003ooooo`03o`000?oooooooooo067ooooo001Pooooo`?o00001Oooool3o`0001WoOd9l00?o0000
ogm2O?mo@W`0;Omo@W`2o`0000_onJU?00Go0000ooVYCooiZDoonJU?o`000002ooooo`03o`000?oo
oooooooo067ooooo001Nooooo`Co00001?ooool2o`0001WoOd9l1?l0000_ogm2O0;o00002ooiZDl0
1Ol0003onJU?ooVYCooiZDoo000000?ooooo00?o0000ooooooooool0H?ooool005cooooo0_l00006
ooooo`;o00006Omo@W`2o`0000?oZkcV00?o0000ogm2O?mo@W`0;Omo@W`2o`0000_onJU?00?o0000
ooVYCooiZDl00_oiZDl01Ol0003ooooooooooooooooo0000067ooooo001Kooooo`03o`000?oooooo
000000?ooooo0ol0000Hogm2O0?o00001On[_>H00ol0003oOd9logm2O00]ogm2O0;o00002ooiZDl0
0ol0003onJU?ooVYC`02ooVYC`05o`000?ooooooooooooooool00000HOooool005[ooooo0_l00003
ooooo`;o00006?mo@W`3o`0000SoZkcV00?o0000ogm2O?mo@W`0;Omo@W`2o`0000_onJU?00?o0000
ooVYCooiZDl00ooiZDl01Ol0003ooooooooooooooooo0000063ooooo001Dooooo`;o00001Oooool2
o`000003ooooool0003oOd9l01OoOd9l0_l0000;oj^liP03o`000?mo@WcoOd9l02goOd9l0_l0000;
ooVYC`03o`000?oiZDoonJU?00ConJU?00Co0000oooooooooooo0000H?ooool005?ooooo00Co0000
oooooooooooo00001?ooool01?l0003oooooo`000?l0000Eogm2O0?o00003On[_>H00ol0003oOd9l
ogm2O00]ogm2O0;o00002ooiZDl00ol0003onJU?ooVYC`04ooVYC`05o`000?ooooooooooooooool0
0000Goooool005?ooooo00Co0000oooooooooooo00000oooool01Ol0003ooooooooooooooooo0000
01?oOd9l0_l0000@oj^liP03o`000?mo@WcoOd9l02goOd9l0_l0000;ooVYC`03o`000?oiZDoonJU?
00GonJU?00Go0000ooooooooooooooooo`00001Nooooo`00Doooool01?l0003oooooooooool00003
ooooo`05o`000?ooooooooooooooool000004?mo@W`3o`0001;oZkcV00?o0000ogm2O?mo@W`0;Omo
@W`2o`0000_onJU?00?o0000ooVYCooiZDl01OoiZDl01Ol0003ooooooooooooooooo000005kooooo
001Cooooo`04o`000?ooooooooooo`0000?ooooo00Co0000oooooooooooo00003omo@W`2o`0001Go
ZkcV00?o0000ogm2O?mo@W`0;Omo@W`2o`0000_onJU?0_l00007ooVYC`05o`000?oooooooooooooo
ool00000GOooool005?ooooo00Co0000oooooooooooo00000_ooool2o`0000;ooooo00?o0000ogm2
O?mo@W`02_mo@W`3o`0001OoZkcV00?o0000ogm2O?mo@W`0;Omo@W`00ol0003onJU?o`00000:ooVY
C`;o00002?oiZDl01Ol0003ooooooooooooooooo000005cooooo001Dooooo`;o00001?ooool01?l0
003oooooooooool0000:ogm2O0;o00006_n[_>H00ol0003oOd9logm2O00]ogm2O003o`000?oiZDoo
000000[onJU?0_l00008ooVYC`05o`000?ooooooooooooooool00000G?ooool005[ooooo00Co0000
oooooooooooo00001omo@W`3o`0001coZkcV00?o0000ogm2O?mo@W`0;Omo@W`00ol0003onJU?o`00
000;ooVYC`03o`000?oiZDoonJU?00OonJU?00Go0000ooooooooooooooooo`00001Kooooo`00FOoo
ool01Ol0003ooooooooooooooooo000000CoOd9l0ol0000Ooj^liP03o`000?mo@WcoOd9l02goOd9l
00?o0000ooVYCol000002ooiZDl00ol0003onJU?ooVYC`07ooVYC`05o`000?ooooooooooooooool0
0000Foooool005Wooooo00Co0000oooooooooooo00000omo@W`2o`0002;oZkcV00?o0000ogm2O?mo
@W`0;_mo@W`2o`0000_onJU?00?o0000ooVYCooiZDl01ooiZDl2o`0000?ooooo00?o0000oooooooo
ool0F?ooool005Wooooo00?o0000ooooooooool01?l0000Soj^liP03o`000?mo@WcoOd9l02ooOd9l
0_l0000;ooVYC`03o`000?oiZDoonJU?00OonJU?00?o0000ooVYCol000000oooool00ol0003ooooo
ooooo`1Gooooo`00F?ooool2o`0000;ooooo00?o0000oj^li_n[_>H09?n[_>H00ol0003oOd9logm2
O00_ogm2O0;o00002ooiZDl00ol0003onJU?ooVYC`07ooVYC`03o`000?oiZDoo000000?ooooo00?o
0000ooooooooool0Eoooool005Wooooo00Go0000ooooooooooooooooo`00000Uoj^liP03o`000?mo
@WcoOd9l02ooOd9l0_l0000;ooVYC`03o`000?oiZDoonJU?00OonJU?0_l000000ooiZDoo0000oooo
o`02ooooo`03o`000?oooooooooo05Kooooo001Iooooo`03o`000?oooooooooo00;ooooo00?o0000
oj^li_n[_>H08_n[_>H00ol0003oOd9logm2O00_ogm2O0;o00002ooiZDl00ol0003onJU?ooVYC`08
ooVYC`04o`000?oiZDoonJU?o`0000?ooooo00?o0000ooooooooool0EOooool005Sooooo00?o0000
ooooooooool01?ooool00ol0003oZkcVoj^liP0Qoj^liP03o`000?mo@WcoOd9l02ooOd9l0_l0000;
ooVYC`03o`000?oiZDoonJU?00SonJU?00Co0000ooVYCooiZDoo00000oooool00ol0003ooooooooo
o`1Eooooo`00F?ooool00ol0003oooooooooo`05ooooo`03o`000?n[_>KoZkcV023oZkcV00?o0000
ogm2O?mo@W`0;omo@W`2o`0000_onJU?0_l00009ooVYC`05o`000?oiZDoonJU?ooVYCol000000ooo
ool00ol0003oooooooooo`1Dooooo`00F?ooool00ol0003oooooooooo`06ooooo`03o`000?n[_>Ko
ZkcV01ooZkcV00?o0000ogm2O?mo@W`0;omo@W`2o`0000_onJU?0_l00009ooVYC`03o`000?oiZDoo
nJU?00;onJU?00Co0000oooooooooooo0000E_ooool005Oooooo0_l00009ooooo`03o`000?n[_>Ko
ZkcV01koZkcV00?o0000ogm2O?mo@W`0;_mo@W`3o`0000_onJU?0_l00009ooVYC`03o`000?oiZDoo
nJU?00;onJU?00Go0000ooooooooooooooooo`00001Eooooo`00F?ooool00ol0003oooooooooo`08
ooooo`03o`000?n[_>KoZkcV01goZkcV00?o0000ogm2O?mo@W`0:omo@W`3o`000003ojG2k_l0003o
000000_onJU?0_l00009ooVYC`03o`000?oiZDoonJU?00?onJU?00Go0000ooooooooooooooooo`00
001Dooooo`00F?ooool00ol0003oooooooooo`09ooooo`03o`000?n[_>KoZkcV01coZkcV00?o0000
ogm2O?mo@W`0:?mo@W`3o`0000GoYL;^00?o0000ooVYCooiZDl02OoiZDl2o`0000WonJU?00?o0000
ooVYCooiZDl00ooiZDl01Ol0003ooooooooooooooooo000005Cooooo001Gooooo`03o`000?oooooo
oooo00_ooooo00?o0000oj^li_n[_>H06on[_>H00ol0003oOd9logm2O00Uogm2O0?o00002?nU`^h2
o`0000_onJU?00?o0000ooVYCooiZDl01ooiZDl00ol0003onJU?ooVYC`04ooVYC`05o`000?oooooo
ooooooooool00000Doooool005Oooooo00?o0000ooooooooool03?ooool00ol0003oZkcVoj^liP0J
oj^liP03o`000?mo@WcoOd9l02;oOd9l0ol0000;ojG2kP;o00002ooiZDl00ol0003onJU?ooVYC`07
ooVYC`;o00001_oiZDl01?l0003oooooooooool0001Cooooo`00Eoooool00ol0003oooooooooo`0=
ooooo`03o`000?n[_>KoZkcV01KoZkcV1?l0000Qogm2O0?o00003_nU`^h00ol0003oYL;^o`00000:
ooVYC`03o`000?oiZDoonJU?00SonJU?00?o0000ooVYCooiZDl01?oiZDl01Ol0003ooooooooooooo
oooo000005;ooooo001Fooooo`?o00003oooool00ol0003oZkcVoj^liP0Boj^liP?o00000on7CX@0
0ol0003oOd9logm2O00Mogm2O0;o00004_nU`^h00ol0003oYL;^o`000009ooVYC`03o`000?oiZDoo
nJU?00SonJU?00?o0000ooVYCooiZDl01OoiZDl00ol0003oooooo`000002o`00057ooooo001>oooo
o`Go00001?ooool00ol0003oooooooooo`0?ooooo`03o`000?n[_>KoZkcV00ooZkcV0_l00006ohM>
Q003o`000?mo@WcoOd9l01[oOd9l0ol0000DojG2kP03o`000?nU`^ko000000WonJU?00?o0000ooVY
CooiZDl02?oiZDl00ol0003onJU?ooVYC`06ooVYC`04o`000?ooooooooooo`00057ooooo001?oooo
o`04o`000?ooooooooooo`0000Cooooo00?o0000ooooooooool04?ooool00ol0003oZkcVoj^liP0;
oj^liP?o00002?n7CX@00ol0003oOd9logm2O00Gogm2O0?o00005onU`^h01?l0003oYL;^ojG2k_l0
0008ooVYC`03o`000?oiZDoonJU?00SonJU?00?o0000ooVYCooiZDl01_oiZDl01?l0003ooooooooo
ool0001Aooooo`00D?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo01;ooooo00?o
0000oj^li_n[_>H01on[_>H3o`0000_oQdj400?o0000ogm2O?mo@W`05?mo@W`3o`0001[oYL;^00Go
0000ojG2k_nU`^koYL;^o`000007ooVYC`;o00002OoiZDl00ol0003onJU?ooVYC`06ooVYC`04o`00
0?ooooooooooo`00057ooooo001Aooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0
4oooool00ol0003oZkcVoj^liP03oj^liP?o00003On7CX@00ol0003oOd9logm2O00Bogm2O0?o0000
7OnU`^h01Ol0003oYL;^ojG2k_nU`^ko000000OonJU?0_l00009ooVYC`03o`000?oiZDoonJU?00Ko
nJU?00Co0000oooooooooooo0000DOooool004kooooo00Go0000ooooooooooooooooo`000003oooo
o`03o`000?oooooooooo01Cooooo00?o0000oj^li_l000000_l0000@ohM>Q003o`000?mo@WcoOd9l
00ooOd9l0ol0000PojG2kP03o`000?nU`^koYL;^00;oYL;^00?o0000ooVYCooiZDl01?oiZDl2o`00
00WonJU?00?o0000ooVYCooiZDl01_oiZDl01Ol0003ooooooooooooooooo0000053ooooo001>oooo
o`05o`000?ooooooooooooooool000000_ooool2o`0001Oooooo00?o0000ohM>Q?n7CX@04On7CX@0
0ol0003oOd9logm2O00=ogm2O0;o00008onU`^h00ol0003oYL;^ojG2kP03ojG2kP03o`000?oiZDoo
nJU?00?onJU?0_l00009ooVYC`03o`000?oiZDoonJU?00OonJU?00Co0000oooooooooooo0000D?oo
ool004oooooo0ol00004ooooo`03o`000?oooooooooo01Gooooo00?o0000ohM>Q?n7CX@04On7CX@0
0ol0003oOd9logm2O00:ogm2O0?o00009OnU`^h00ol0003oYL;^ojG2kP04ojG2kP03o`000?oiZDoo
nJU?00;onJU?0_l00009ooVYC`;o00002?oiZDl01?l0003oooooooooool0001@ooooo`00E_ooool0
0ol0003oooooooooo`0Eooooo`03o`000?n7CXCoQdj4017oQdj400?o0000ogm2O?mo@W`01omo@W`3
o`0002SoYL;^00?o0000ojG2k_nU`^h01?nU`^h00ol0003onJU?ooVYC`02ooVYC`;o00002_oiZDl0
0ol0003onJU?ooVYC`06ooVYC`04o`000?ooooooooooo`00053ooooo001Eooooo`03o`000?oooooo
oooo01Kooooo00?o0000ohM>Q?n7CX@04On7CX@00ol0003oOd9logm2O004ogm2O0?o0000:onU`^h0
0ol0003oYL;^ojG2kP05ojG2kP04o`000?oiZDoonJU?ooVYC`;o00002_oiZDl00ol0003onJU?ooVY
C`06ooVYC`04o`000?ooooooooooo`00053ooooo001Eooooo`03o`000?oooooooooo01Kooooo00?o
0000ohM>Q?n7CX@04On7CX@01?l0003oOd9logm2O?mo@W`3o`0002koYL;^00?o0000ojG2k_nU`^h0
1_nU`^h01Ol0003onJU?ooVYCooiZDoo000000[onJU?00?o0000ooVYCooiZDl01_oiZDl01?l0003o
ooooooooool0001@ooooo`00EOooool00ol0003oooooooooo`0Fooooo`03o`000?n7CXCoQdj400oo
Qdj41_l0000aojG2kP03o`000?nU`^koYL;^00KoYL;^00Go0000ooVYCooiZDoonJU?o`00000:ooVY
C`03o`000?oiZDoonJU?00KonJU?00Co0000oooooooooooo0000D?ooool005Gooooo00?o0000oooo
ooooool05_ooool00ol0003oQdj4ohM>Q00<ohM>Q0?o00000_nY_^P00ol0003oYL;^ojG2kP0bojG2
kP03o`000?nU`^koYL;^00OoYL;^00Co0000ooVYCooiZDoo00002_oiZDl00ol0003onJU?ooVYC`06
ooVYC`05o`000?ooooooooooooooool00000Coooool005Cooooo0_l0000Gooooo`03o`000?n7CXCo
Qdj400[oQdj40ol00006ojVnj003o`000?nU`^koYL;^037oYL;^00?o0000ojG2k_nU`^h02?nU`^h0
0ol0003onJU?o`00000:ooVYC`03o`000?oiZDoonJU?00KonJU?00Go0000ooooooooooooooooo`00
001?ooooo`00EOooool00ol0003oooooooooo`0Eooooo`03o`000?n7CXCoQdj400OoQdj40ol0000:
ojVnj003o`000?nU`^koYL;^033oYL;^00?o0000ojG2k_nU`^h02?nU`^h01?l0003onJU?o`000?l0
0009ooVYC`03o`000?oiZDoonJU?00OonJU?00Co0000oooooooooooo0000Coooool005Cooooo00?o
0000ooooooooool05_ooool00ol0003oQdj4ohM>Q004ohM>Q0?o00003_nY_^P00ol0003oYL;^ojG2
kP0_ojG2kP03o`000?nU`^koYL;^00WoYL;^0ol00009ooVYC`03o`000?oiZDoonJU?00OonJU?00Co
0000oooooooooooo0000Coooool005Cooooo00?o0000ooooooooool05_ooool01?l0003oQdj4ohM>
Q?n7CX@3o`0001;oZKkX00?o0000ojG2k_nU`^h0;_nU`^h00ol0003oYL;^ojG2kP0:ojG2kP;o0000
2OoiZDl2o`0000SonJU?00Co0000oooooooooooo0000Coooool005Cooooo00?o0000ooooooooool0
5_ooool4o`0001KoZKkX00?o0000ojG2k_nU`^h0;OnU`^h00ol0003oYL;^ojG2kP05ojG2kP?o0000
0on7CX@00ol0003onJU?ooVYC`08ooVYC`03o`000?oiZDoonJU?00KonJU?00Co0000oooooooooooo
0000Coooool005Cooooo00?o0000ooooooooool05_ooool00ol0003oZKkXojVnj00HojVnj003o`00
0?nU`^koYL;^02goYL;^00Co0000ojG2k_nU`^koYL;^0ol00006ohM>Q003o`000?oiZDoonJU?00So
nJU?00?o0000ooVYCooiZDl01_oiZDl01?l0003oooooooooool0001?ooooo`00E?ooool00ol0003o
ooooooooo`0Hooooo`03o`000?nY_^SoZKkX01OoZKkX00?o0000ojG2k_nU`^h0;?nU`^h4o`0000Wo
Qdj400?o0000ooVYCooiZDl02?oiZDl00ol0003onJU?ooVYC`06ooVYC`05o`000?oooooooooooooo
ool00000C_ooool005?ooooo0_l0000Kooooo`03o`000?nY_^SoZKkX01OoZKkX00?o0000ojG2k_nU
`^h0:OnU`^h3o`0000coQdj400?o0000ooVYCooiZDl02?oiZDl00ol0003onJU?ooVYC`06ooVYC`05
o`000?ooooooooooooooool00000C_ooool005?ooooo00?o0000ooooooooool06oooool00ol0003o
ZKkXojVnj00GojVnj003o`000?nU`^koYL;^02GoYL;^0ol00002ohM>Q003o`000?n7CXCoQdj400[o
Qdj400?o0000ooVYCooiZDl02?oiZDl00ol0003onJU?ooVYC`07ooVYC`04o`000?ooooooooooo`00
04kooooo001Cooooo`03o`000?oooooooooo01cooooo00?o0000ojVnj?nY_^P05onY_^P00ol0003o
YL;^ojG2kP0QojG2kP?o00001On7CX@00ol0003oQdj4ohM>Q00:ohM>Q003o`000?oiZDoonJU?00So
nJU?00?o0000ooVYCooiZDl01ooiZDl01?l0003oooooooooool0001>ooooo`00Doooool00ol0003o
ooooooooo`0Mooooo`03o`000?nY_^SoZKkX01OoZKkX00?o0000ojG2k_nU`^h07?nU`^h4o`0000So
Qdj400?o0000ohM>Q?n7CX@02_n7CX@00ol0003onJU?ooVYC`08ooVYC`03o`000?oiZDoonJU?00Oo
nJU?00Co0000oooooooooooo0000C_ooool005?ooooo00?o0000ooooooooool07_ooool00ol0003o
ZKkXojVnj00GojVnj003o`000?nU`^koYL;^01SoYL;^0ol0000<ohM>Q003o`000?n7CXCoQdj400[o
Qdj400?o0000ooVYCooiZDl02?oiZDl2o`0000SonJU?00Co0000oooooooooooo0000C_ooool005?o
oooo00?o0000ooooooooool07oooool00ol0003oZKkXojVnj00GojVnj003o`000?nU`^koYL;^01Co
YL;^0ol0000?ohM>Q003o`000?n7CXCoQdj400_oQdj400?o0000ooVYCooiZDl01ooiZDl2o`0000So
nJU?00Co0000oooooooooooo0000C_ooool005?ooooo00?o0000ooooooooool08?ooool00ol0003o
ZKkXojVnj00GojVnj003o`000?nU`^koYL;^013oYL;^0ol0000@ohM>Q0?o00003On7CX@00ol0003o
nJU?ooVYC`08ooVYC`03o`000?oiZDoonJU?00KonJU?00Co0000oooooooooooo0000C_ooool004co
oooo0ol00003ooooo`03o`000?oooooooooo02;ooooo00?o0000ojVnj?nY_^P05onY_^P00ol0003o
YL;^ojG2kP0<ojG2kP?o00004?n7CX@3o`0000;oQdj400?o0000ohM>Q?n7CX@02on7CX@00ol0003o
nJU?ooVYC`08ooVYC`03o`000?oiZDoonJU?00KonJU?00Go0000ooooooooooooooooo`00001=oooo
o`00COooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo02?ooooo00?o0000ojVnj?nY
_^P04onY_^P3o`000003ohiGRol0003oYL;^00WoYL;^0ol0000@ohM>Q0?o00001_n7CX@00ol0003o
Qdj4ohM>Q00:ohM>Q003o`000?oiZDoonJU?00SonJU?00?o0000ooVYCooiZDl01_oiZDl01Ol0003o
oooooooooooooooo000004gooooo001:ooooo`Go00000oooool00ol0003oooooooooo`0Tooooo`03
o`000?nY_^SoZKkX00ooZKkX0ol00005ohiGR`03o`000?nU`^koYL;^00CoYL;^0ol0000@ohM>Q0?o
00002_n7CX@00ol0003oQdj4ohM>Q009ohM>Q003o`000?oiZDoonJU?00SonJU?00?o0000ooVYCooi
ZDl01ooiZDl01?l0003oooooooooool0001=ooooo`00B_ooool01?l0003oooooooooool00004oooo
o`03o`000?oooooooooo02Gooooo00?o0000ojVnj?nY_^P02onY_^P3o`0000WoSUN;00?o0000ojG2
k_nU`^h00ol0000?ohM>Q0Co00003_n7CX@00ol0003oQdj4ohM>Q006ohM>Q0?o00002_oiZDl00ol0
003onJU?ooVYC`07ooVYC`04o`000?ooooooooooo`0004gooooo001;ooooo`03o`000?oooooo0000
00Cooooo00?o0000ooooooooool09_ooool00ol0003oZKkXojVnj007ojVnj0?o00003?n>Eh/3o`00
00ooQdj40ol0000CohM>Q003o`000?n7CXCoQdj400;oQdj40ol00002oj?5l@03o`000?oiZDoonJU?
00SonJU?00?o0000ooVYCooiZDl01ooiZDl01?l0003oooooooooool0001=ooooo`00C?ooool2o`00
00Cooooo00?o0000ooooooooool09oooool00ol0003oZKkXojVnj003ojVnj0?o00003on>Eh/00ol0
003oQdj4ohM>Q00<ohM>Q0?o00005on7CX@4o`0000KoXlGa00?o0000ooVYCooiZDl01ooiZDl00ol0
003onJU?ooVYC`07ooVYC`04o`000?ooooooooooo`0004gooooo001=ooooo`05o`000?oooooooooo
ooooool00000:oooool00ol0003oZKkXo`000002o`0001;oSUN;00?o0000ohM>Q?n7CX@02On7CX@3
o`0001OoQdj41?l0000:oj?5l@03o`000?oiZDoonJU?00KonJU?0_l00008ooVYC`04o`000?oooooo
ooooo`0004gooooo001Aooooo`;o0000:oooool00ol0003oSUN;ohiGR`0CohiGR`03o`000?n7CXCo
Qdj400GoQdj41?l0000GohM>Q0?o00001?nSaO400ol0003oXlGaoj?5l@08oj?5l@03o`000?oiZDoo
nJU?00GonJU?0_l00008ooVYC`05o`000?ooooooooooooooool00000C?ooool0057ooooo00?o0000
ooooooooool0:_ooool00ol0003oSUN;ohiGR`0CohiGR`03o`000?n7CXCoQdj400;oQdj40ol0000H
ohM>Q0?o00002?nSaO400ol0003oXlGaoj?5l@07oj?5l@03o`000?oiZDoonJU?00KonJU?00?o0000
ooVYCooiZDl01_oiZDl01Ol0003ooooooooooooooooo000004cooooo001Aooooo`03o`000?oooooo
oooo02[ooooo00?o0000ohiGRon>Eh/04on>Eh/00ol0003oQdj4o`000002o`0001OoQdj41?l0000<
oj?5l@03o`000?nSaO7oXlGa00OoXlGa00?o0000ooVYCooiZDl01OoiZDl00ol0003onJU?ooVYC`06
ooVYC`05o`000?ooooooooooooooool00000C?ooool0057ooooo00?o0000ooooooooool0:_ooool0
0ol0003oSUN;ohiGR`0BohiGR`?o00005on7CX@3o`00017oXlGa00?o0000oj?5lOnSaO401onSaO40
0ol0003onJU?ooVYC`04ooVYC`03o`000?oiZDoonJU?00OonJU?00Co0000oooooooooooo0000C?oo
ool0057ooooo00?o0000ooooooooool0:Oooool00ol0003oSUN;ohiGR`0?ohiGR`Co000000?oSUN;
o`000?n7CX@05?n7CX@3o`0001CoXlGa00?o0000oj?5lOnSaO401onSaO400ol0003onJU?ooVYC`04
ooVYC`03o`000?oiZDoonJU?00OonJU?00Co0000oooooooooooo0000C?ooool0053ooooo00?o0000
ooooooooool0:_ooool00ol0003oSUN;ohiGR`0<ohiGR`?o00000on>Eh/3o`00017oQdj41?l0000H
oj?5l@03o`000?nSaO7oXlGa00OoXlGa00?o0000ooVYCooiZDl00ooiZDl00ol0003onJU?ooVYC`07
ooVYC`04o`000?ooooooooooo`0004cooooo001@ooooo`03o`000?oooooooooo02[ooooo00?o0000
ohiGRon>Eh/02On>Eh/3o`0000?oSUN;0ol00002ojO0j`03o`000?n7CXCoQdj400coQdj40ol0000M
oj?5l@03o`000?nSaO7oXlGa00OoXlGa00?o0000ooVYCooiZDl00_oiZDl00ol0003onJU?ooVYC`07
ooVYC`04o`000?ooooooooooo`0004cooooo001@ooooo`;o0000:oooool00ol0003oSUN;ohiGR`06
ohiGR`?o00000on>Eh/3o`0000GoYl3[00?o0000ohM>Q?n7CX@02On7CX@3o`00027oXlGa00?o0000
oj?5lOnSaO401onSaO401Ol0003onJU?ooVYCooiZDoo000000WonJU?00Go0000oooooooooooooooo
o`00001;ooooo`00D?ooool00ol0003oooooooooo`0Zooooo`03o`000?n>Eh_oSUN;00;oSUN;1?l0
0002ohiGR`Co00002?nW`>/00ol0003oQdj4ohM>Q005ohM>Q0Co00009OnSaO400ol0003oXlGaoj?5
l@06oj?5l@04o`000?oiZDoonJU?ooVYC`;o00002?oiZDl01Ol0003ooooooooooooooooo000004_o
oooo001@ooooo`03o`000?oooooooooo02[ooooo00?o0000ohiGRol000000_l00003ohiGR`?o0000
3?nW`>/00ol0003oQdj4ohM>Q002ohM>Q0?o0000:_nSaO400ol0003oXlGaoj?5l@06oj?5l@03o`00
0?oiZDoonJU?00;o00002?oiZDl01Ol0003ooooooooooooooooo000004_ooooo001@ooooo`03o`00
0?oooooooooo02Wooooo0ol00003ohiGR`?o00003onW`>/00ol0003oQdj4o`000002o`0002goXlGa
00?o0000oj?5lOnSaO401onSaO401?l0003onJU?ooVYCol00009ooVYC`04o`000?ooooooooooo`00
04_ooooo001?ooooo`03o`000?oooooooooo02Oooooo0ol000000ooooooo0000ohiGR`03o`0001;o
Yl3[0_l0000aoj?5l@03o`000?nSaO7oXlGa00KoXlGa00Co0000ooVYCooiZDoo00002OoiZDl01?l0
003oooooooooool0001;ooooo`00Coooool00ol0003oooooooooo`0Tooooo`?o00001?ooool2o`00
01OoYl3[00?o0000oj?5lOnSaO40;onSaO400ol0003oXlGaoj?5l@06oj?5l@03o`000?oiZDoo0000
00WonJU?00Co0000oooooooooooo0000Boooool004oooooo00?o0000ooooooooool08?ooool4o`00
00Wooooo00?o0000ojO0jonW`>/05OnW`>/00ol0003oXlGaoj?5l@0_oj?5l@03o`000?nSaO7oXlGa
00KoXlGa0_l00009ooVYC`04o`000?ooooooooooo`0004_ooooo001?ooooo`03o`000?oooooooooo
01gooooo0ol0000>ooooo`03o`000?nW`>_oYl3[01GoYl3[00?o0000oj?5lOnSaO40;onSaO400ol0
003oXlGaoj?5l@06oj?5l@03o`000?oiZDoonJU?00OonJU?00Co0000oooooooooooo0000Boooool0
04oooooo00?o0000ooooooooool06_ooool3o`0001;ooooo00?o0000ojO0jonW`>/05OnW`>/00ol0
003oXlGaoj?5l@0^oj?5l@04o`000?nSaO7oXlGaoj?5l@?o00000_n>Eh/00ol0003onJU?ooVYC`07
ooVYC`05o`000?ooooooooooooooool00000B_ooool004oooooo00?o0000ooooooooool05oooool3
o`0001Kooooo00?o0000ojO0jonW`>/05OnW`>/00ol0003oXlGaoj?5l@0]oj?5l@Co00001On>Eh/0
0ol0003onJU?ooVYC`07ooVYC`05o`000?ooooooooooooooool00000B_ooool004kooooo00?o0000
ooooooooool05?ooool4o`0001[ooooo00?o0000ojO0jonW`>/05OnW`>/00ol0003oXlGaoj?5l@0Y
oj?5l@?o00000_n>Eh/00ol0003oSUN;ohiGR`05ohiGR`03o`000?oiZDoonJU?00KonJU?00Go0000
ooooooooooooooooo`00001:ooooo`00C_ooool00ol0003oooooooooo`0Aooooo`?o00007oooool2
o`0001KoYl3[00?o0000oj?5lOnSaO409?nSaO44o`0000KoSUN;00?o0000ohiGRon>Eh/01?n>Eh/0
0ol0003onJU?ooVYC`07ooVYC`04o`000?ooooooooooo`0004[ooooo001>ooooo`03o`000?oooooo
oooo00kooooo0ol0000Tooooo`03o`000?nW`>_oYl3[01CoYl3[00?o0000oj?5lOnSaO408?nSaO43
o`0000_oSUN;00?o0000ohiGRon>Eh/00on>Eh/00ol0003onJU?ooVYC`07ooVYC`04o`000?oooooo
ooooo`0004[ooooo001>ooooo`03o`000?oooooooooo00_ooooo0ol0000Xooooo`03o`000?nW`>_o
Yl3[01?oYl3[0_l0000Moj?5l@Co00003on>Eh/00ol0003oSUN;ohiGR`02ohiGR`03o`000?oiZDoo
nJU?00OonJU?00Co0000oooooooooooo0000B_ooool004kooooo00?o0000ooooooooool01oooool4
o`0002cooooo00?o0000ojO0jonW`>/03_nW`>/4o`0000;ooooo00?o0000oj?5lOnSaO405_nSaO44
o`0001?oSUN;00?o0000ohiGRon>Eh/00_n>Eh/00ol0003onJU?ooVYC`07ooVYC`04o`000?oooooo
ooooo`0004[ooooo001>ooooo`;o00001Oooool3o`00037ooooo00?o0000ojO0jonW`>/02OnW`>/4
o`0000Oooooo00?o0000oj?5lOnSaO404_nSaO43o`0001SoSUN;00Go0000ohiGRon>Eh_oSUN;o`00
0009ooVYC`05o`000?ooooooooooooooool00000BOooool004Kooooo0ol00004ooooo`;o00000ooo
ool3o`0003Gooooo00?o0000ojO0jonW`>/01OnW`>/3o`0000cooooo00?o0000oj?5lOnSaO403OnS
aO44o`0001coSUN;00Co0000ohiGRon>Eh_o00002OoiZDl01Ol0003ooooooooooooooooo000004Wo
oooo0015ooooo`05o`000?ooooooooooooooool000000oooool00ol0003oooooo`000002o`0003Wo
oooo00?o0000ojO0jonW`>/01?l0000@ooooo`03o`000?nSaO7oXlGa00WoXlGa0ol0000QohiGR`03
o`000?n>Eh_o000000WonJU?00Go0000ooooooooooooooooo`000019ooooo`00AOooool01Ol0003o
oooooooooooooooo000000?ooooo0_l0000looooo`?o00005Oooool00ol0003oXlGaoj?5l@04oj?5
l@Co00009On>Eh/2o`0000WonJU?00Go0000ooooooooooooooooo`000019ooooo`00AOooool4o`00
00Kooooo00?o0000ooooooooool0>Oooool00ol0003oooooooooo`0Fooooo`03o`000?nSaO7oXlGa
00?o0000:On>Eh/00ol0003oSUN;o`000009ooVYC`04o`000?ooooooooooo`0004Wooooo0015oooo
o`03o`000?oooooooooo00Sooooo0_l0000iooooo`03o`000?oooooooooo01Oooooo0_l0000]ohiG
R`;o00002OoiZDl01?l0003oooooooooool00019ooooo`00A_ooool00ol0003oooooooooo`08oooo
o`;o0000>?ooool00ol0003oooooooooo`0Gooooo`03o`000?n>Eh_oSUN;02goSUN;00?o0000ooVY
CooiZDl01ooiZDl01?l0003oooooooooool00019ooooo`00Aoooool2o`0000[ooooo00?o0000oooo
ooooool0=Oooool00ol0003oooooooooo`0Gooooo`03o`000?n>Eh_oSUN;02_oSUN;1?l00008ooVY
C`04o`000?ooooooooooo`0004Wooooo001Dooooo`;o0000=Oooool00ol0003oooooooooo`0Goooo
o`03o`000?n>Eh_oSUN;02OoSUN;1?l00002oio7m003o`000?oiZDoo000000OonJU?00Go0000oooo
ooooooooooooo`000018ooooo`00E_ooool00ol0003oooooooooo`0booooo`03o`000?oooooooooo
01Oooooo00?o0000ohiGRon>Eh/09?n>Eh/3o`0000OoWlOd00?o0000ooVYCol000001_oiZDl01Ol0
003ooooooooooooooooo000004Sooooo001Gooooo`;o0000<_ooool00ol0003oooooooooo`0Goooo
o`03o`000?n>Eh_oSUN;023oSUN;1?l0000;oio7m0;o00001_oiZDl01Ol0003ooooooooooooooooo
000004Sooooo001Iooooo`;o0000<?ooool00ol0003oooooooooo`0Gooooo`03o`000?n>Eh_oSUN;
01coSUN;1?l0000@oio7m0;o00001_oiZDl01?l0003oooooooooool00018ooooo`00F_ooool00ol0
003oooooooooo`0^ooooo`03o`000?oooooooooo01Oooooo00?o0000ohiGRon>Eh/06On>Eh/3o`00
01GoWlOd0_l00005ooVYC`04o`000?ooooooooooo`0004Sooooo001Kooooo`;o0000;_ooool00ol0
003oooooooooo`0Gooooo`03o`000?n>Eh_oSUN;01GoSUN;1?l0000Hoio7m003o`000?oiZDoo0000
00ConJU?00Co0000oooooooooooo0000B?ooool005gooooo00?o0000ooooooooool0:oooool00ol0
003oooooooooo`0Gooooo`03o`000?n>Eh_oSUN;017oSUN;1?l0000Moio7m003o`000?oiZDoo0000
00?onJU?00Co0000oooooooooooo0000B?ooool005kooooo0_l0000[ooooo`03o`000?oooooooooo
01Oooooo00?o0000ohiGRon>Eh/03_n>Eh/3o`0002;oWlOd0_l00003ooVYC`05o`000?oooooooooo
ooooool00000Aoooool0063ooooo00?o0000ooooooooool0:?ooool00ol0003oooooooooo`0Goooo
o`03o`000?n>Eh_oSUN;00[oSUN;1?l0000Voio7m0;o00000_oiZDl01Ol0003ooooooooooooooooo
000004Oooooo001Qooooo`;o0000:?ooool00ol0003oooooooooo`0Gooooo`03o`000?n>Eh_oSUN;
00KoSUN;1?l0000[oio7m0;o000000?onJU?o`000?ooool00_ooool00ol0003oooooooooo`15oooo
o`00F?ooool3o`0000Sooooo00?o0000ooooooooool09Oooool00ol0003oooooooooo`0Gooooo`03
o`000?n>Eh_oSUN;00?oSUN;0ol0000_oio7m004o`000?oiZDoo0000o`0000?ooooo00?o0000oooo
ooooool0AOooool005Wooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`0Tooooo`03
o`000?oooooooooo01Oooooo00?o0000ohiGRol000000ol0000coio7m004o`000?oiZDoo0000o`00
00;ooooo00?o0000ooooooooool0AOooool005Wooooo00?o0000ooooooooool02Oooool2o`0002Co
oooo00?o0000ooooooooool05oooool2o`0003SoWlOd00?o0000ooVYCol000000_ooool00ol0003o
ooooooooo`15ooooo`00FOooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo027ooooo
00?o0000ooooooooool06Oooool00ol0003oWlOdoio7m00foio7m0;o00000_ooool00ol0003ooooo
ooooo`15ooooo`00FOooool00ol0003oooooooooo`0<ooooo`;o00008Oooool00ol0003ooooooooo
o`0Jooooo`03o`000?nOaoCoWlOd03KoWlOd0_l00002ooooo`03o`000?oooooooooo04Cooooo001H
ooooo`;o00004?ooool2o`0001oooooo00?o0000ooooooooool06oooool00ol0003oWlOdoio7m00_
oio7m0Co00001?ooool00ol0003oooooo`000016ooooo`00FOooool00ol0003oooooooooo`0?oooo
o`;o00007_ooool00ol0003oooooooooo`0Looooo`03o`000?nOaoCoWlOd02[oWlOd1?l00009oooo
o`;o0000A_ooool006gooooo00?o0000ooooooooool06oooool00ol0003oooooooooo`0Mooooo`03
o`000?nOaoCoWlOd02GoWlOd1?l0000<ooooo`?o0000A_ooool006kooooo0_l0000Kooooo`03o`00
0?oooooooooo01kooooo0_l0000Qoio7m0Co00002oooool5o`0004Wooooo001_ooooo`;o00006_oo
ool00ol0003oooooooooo`0Pooooo`03o`000?nOaoCoWlOd01WoWlOd1Ol0000;ooooo`Co0000C_oo
ool0077ooooo00?o0000ooooooooool05_ooool00ol0003oooooooooo`0Rooooo`03o`000?nOaoCo
WlOd01CoWlOd1?l0000<ooooo`Co0000D_ooool007;ooooo0_l0000Fooooo`03o`000?oooooooooo
02?ooooo00?o0000oio7m?nOao@03onOao@4o`0000_ooooo1Ol0001Fooooo`00M?ooool00ol0003o
ooooooooo`0Cooooo`03o`000?oooooooooo02Cooooo00?o0000oio7m?nOao@02_nOao@4o`0000_o
oooo1?l0001Kooooo`00MOooool2o`0001?ooooo00?o0000ooooooooool09Oooool00ol0003oWlOd
oio7m005oio7m0Co00002oooool4o`0005oooooo001[ooooo`Go00001_ooool2o`0001;ooooo00?o
0000ooooooooool09_ooool00ol0003oWlOdoio7m004o`0000[ooooo1Ol0001Sooooo`00K?ooool0
1?l0003oooooooooool00008ooooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool09ooo
ool2o`0000[ooooo1?l0001Xooooo`00KOooool00ol0003oooooooooo`09ooooo`;o00003oooool0
0ol0003oooooooooo`0_ooooo`Co0000K?ooool006kooooo00?o0000ooooooooool02_ooool00ol0
003oooooooooo`0<ooooo`03o`000?oooooooooo02[ooooo1Ol0001`ooooo`00Joooool01Ol0003o
oooooooooooooooo000000cooooo0_l0000<ooooo`03o`000?oooooooooo02Kooooo1?l0001eoooo
o`00Joooool01Ol0003ooooooooooooooooo000000gooooo0_l0000;ooooo`03o`000?oooooooooo
02;ooooo1?l0001iooooo`00K?ooool3o`00013ooooo00?o0000ooooool000002?ooool00ol0003o
ooooooooo`0Mooooo`Go0000OOooool0083ooooo0_l00008ooooo`03o`000?oooooooooo01Wooooo
1?l00022ooooo`00P_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo01Gooooo1?l0
0026ooooo`00Poooool2o`0000Gooooo00?o0000ooooooooool04?ooool5o`0008[ooooo0024oooo
o`;o00001?ooool00ol0003oooooooooo`0<ooooo`Co0000Soooool008Kooooo0_l00002ooooo`03
o`000?oooooooooo00Sooooo1?l0002Cooooo`00O_ooool3o`0000Kooooo0_l000000ooooooo0000
ooooo`04ooooo`Go0000Uoooool007gooooo00Go0000ooooooooooooooooo`000007ooooo`;o0000
00?oooooo`000?l000000_l0002Looooo`00POooool00ol0003oooooooooo`06ooooo`;o0000X?oo
ool007oooooo0_l0002[ooooo`00POooool00ol0003oooooooooo`2Xooooo`00OOooool01Ol0003o
oooooooooooooooo00000:[ooooo001nooooo`?o0000Zoooool00001\
\>"],
 ImageRangeCache->{{{0, 299}, {179, 0}} -> {-0.390902, -0.0559619, \
0.00566196, 0.00566196}},
 CellTags->"S5.33.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics3D", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.33.1"]
}, Open  ]],

Cell[TextData[{
 "The plot can be redisplayed using any option that can be given for a ",
 StyleBox["Graphics3D", "MR"],
 " object. This turns off the simulated lighting model and removes the axes \
and bounding box. "
}], "MathCaption",
 CellTags->{"S5.33.1", "1.5"}],

Cell[CellGroupData[{

Cell["\<\
Show[%, Lighting->False,
        Boxed->False, Axes->False]\
\>", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.33.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.0855 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0567234 1.16608 -4.6187e-17 1.16608 [
[ 0 0 0 0 ]
[ 1 1.0855 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.0855 L
0 1.0855 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.5 g
.65504 .5055 m .42216 .58164 L .32951 .48692 L p F P
0 g
s
.5 g
.66477 .73412 m .65504 .5055 L .42216 .58164 L p F P
0 g
s
.5 g
.42216 .58164 m .41465 .80504 L .66477 .73412 L p F P
0 g
s
.5 g
.32951 .48692 m .42216 .58164 L .41465 .80504 L p F P
0 g
s
.5 g
.91022 .42206 m .65504 .5055 L .57178 .40165 L p F P
0 g
s
.5 g
.97657 .93008 m .91022 .42206 L .65504 .5055 L p F P
0 g
s
.5 g
.65504 .5055 m .6761 1.00015 L .97657 .93008 L p F P
0 g
s
.5 g
.32951 .48692 m .57178 .40165 L .65504 .5055 L p F P
0 g
s
.5 g
.41465 .80504 m .31445 .71675 L .32951 .48692 L p F P
0 g
s
.5 g
.66477 .73412 m .41465 .80504 L .31445 .71675 L p F P
0 g
s
.5 g
.31445 .71675 m .57544 .63664 L .66477 .73412 L p F P
0 g
s
.5 g
.57178 .40165 m .65504 .5055 L .6761 1.00015 L p F P
0 g
s
.5 g
.57178 .40165 m .65504 .5055 L .66477 .73412 L p F P
0 g
s
.5 g
.57544 .63664 m .57178 .40165 L .32951 .48692 L p F P
0 g
s
.5 g
.32951 .48692 m .31445 .71675 L .57544 .63664 L p F P
0 g
s
.5 g
.57178 .40165 m .32951 .48692 L .22569 .38079 L p F P
0 g
s
.5 g
.57416 .55422 m .57178 .40165 L .32951 .48692 L p F P
0 g
s
.5 g
.32951 .48692 m .31972 .63633 L .57416 .55422 L p F P
0 g
s
.5 g
.22569 .38079 m .32951 .48692 L .31972 .63633 L p F P
0 g
s
.5 g
.57178 .40165 m .83871 .30771 L .91022 .42206 L p F P
0 g
s
.5 g
.83871 .30771 m .91022 .42206 L .97657 .93008 L p F P
0 g
s
.5 g
.89671 .83222 m .83871 .30771 L .57178 .40165 L p F P
0 g
s
.5 g
.6761 1.00015 m .57974 .91277 L .57178 .40165 L p F P
0 g
s
.5 g
.66477 .73412 m .57544 .63664 L .57178 .40165 L p F P
0 g
s
.5 g
.57178 .40165 m .57974 .91277 L .89671 .83222 L p F P
0 g
s
.5 g
.83871 .30771 m .57178 .40165 L .47797 .28465 L p F P
0 g
s
.5 g
.88559 .73168 m .83871 .30771 L .57178 .40165 L p F P
0 g
s
.5 g
.57178 .40165 m .57823 .81551 L .88559 .73168 L p F P
0 g
s
.5 g
.22569 .38079 m .47797 .28465 L .57178 .40165 L p F P
0 g
s
.5 g
.31972 .63633 m .20979 .53407 L .22569 .38079 L p F P
0 g
s
.5 g
.57416 .55422 m .31972 .63633 L .20979 .53407 L p F P
0 g
s
.5 g
.20979 .53407 m .47527 .4409 L .57416 .55422 L p F P
0 g
s
.5 g
.47797 .28465 m .57178 .40165 L .57823 .81551 L p F P
0 g
s
.5 g
.47797 .28465 m .57178 .40165 L .57416 .55422 L p F P
0 g
s
.5 g
.47527 .4409 m .47797 .28465 L .22569 .38079 L p F P
0 g
s
.5 g
.22569 .38079 m .20979 .53407 L .47527 .4409 L p F P
0 g
s
.5 g
.47797 .28465 m .22569 .38079 L .10855 .26104 L p F P
0 g
s
.5 g
.47666 .36066 m .47797 .28465 L .22569 .38079 L p F P
0 g
s
.5 g
.22569 .38079 m .21795 .45546 L .47666 .36066 L p F P
0 g
s
.5 g
.10855 .26104 m .22569 .38079 L .21795 .45546 L p F P
0 g
s
.5 g
.21795 .45546 m .09708 .33734 L .10855 .26104 L p F P
0 g
s
.5 g
.47666 .36066 m .21795 .45546 L .09708 .33734 L p F P
0 g
s
.5 g
.97657 .93008 m .89671 .83222 L .83871 .30771 L p F P
0 g
s
.5 g
.47797 .28465 m .75764 .17807 L .83871 .30771 L p F P
0 g
s
.5 g
.75764 .17807 m .83871 .30771 L .88559 .73168 L p F P
0 g
s
.5 g
.57416 .55422 m .47527 .4409 L .47797 .28465 L p F P
0 g
s
.5 g
.79505 .614 m .75764 .17807 L .47797 .28465 L p F P
0 g
s
.5 g
.57823 .81551 m .47062 .71093 L .47797 .28465 L p F P
0 g
s
.5 g
.47797 .28465 m .47062 .71093 L .79505 .614 L p F P
0 g
s
.5 g
.75764 .17807 m .47797 .28465 L .37146 .15181 L p F P
0 g
s
.5 g
.78663 .51589 m .75764 .17807 L .47797 .28465 L p F P
0 g
s
.5 g
.47797 .28465 m .47226 .6156 L .78663 .51589 L p F P
0 g
s
.5 g
.10855 .26104 m .37146 .15181 L .47797 .28465 L p F P
0 g
s
.5 g
.09708 .33734 m .36697 .22926 L .47666 .36066 L p F P
0 g
s
.5 g
.37146 .15181 m .47797 .28465 L .47226 .6156 L p F P
0 g
s
.5 g
.37146 .15181 m .47797 .28465 L .47666 .36066 L p F P
0 g
s
.5 g
.36697 .22926 m .37146 .15181 L .10855 .26104 L p F P
0 g
s
.5 g
.10855 .26104 m .09708 .33734 L .36697 .22926 L p F P
0 g
s
.5 g
.47666 .36066 m .36697 .22926 L .37146 .15181 L p F P
0 g
s
.5 g
.97657 .93008 m .6761 1.00015 L .57974 .91277 L p F P
0 g
s
.5 g
.88559 .73168 m .79505 .614 L .75764 .17807 L p F P
0 g
s
.5 g
.37146 .15181 m .66497 .02988 L .75764 .17807 L p F P
0 g
s
.5 g
.66497 .02988 m .75764 .17807 L .78663 .51589 L p F P
0 g
s
.5 g
.68376 .37507 m .66497 .02988 L .37146 .15181 L p F P
0 g
s
.5 g
.47226 .6156 m .35178 .49112 L .37146 .15181 L p F P
0 g
s
.5 g
.37146 .15181 m .35178 .49112 L .68376 .37507 L p F P
0 g
s
.5 g
.88559 .73168 m .57823 .81551 L .47062 .71093 L p F P
0 g
s
.5 g
.57974 .91277 m .89671 .83222 L .97657 .93008 L p F P
0 g
s
.5 g
.78663 .51589 m .47226 .6156 L .35178 .49112 L p F P
0 g
s
.5 g
.78663 .51589 m .68376 .37507 L .66497 .02988 L p F P
0 g
s
.5 g
.47062 .71093 m .79505 .614 L .88559 .73168 L p F P
0 g
s
.5 g
.35178 .49112 m .68376 .37507 L .78663 .51589 L p F P
0 g
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.33.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics3D", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.33.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["option name", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["default value", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox["",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["XSpacing", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["0", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["space between bars in the ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["x",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4,
       ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" direction ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["YSpacing", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["0", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["space between bars in the ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["y",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4,
       ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" direction ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["SolidBarEdges", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["True", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "whether to draw the edges of bars",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["SolidBarEdgeStyle", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["GrayLevel[0]", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox["style for edges of bars ",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["SolidBarStyle", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["GrayLevel[0.5]", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox["style for faces of bars",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
 GridBoxOptions->{RowLines->{True, False},
 RowSpacings->0.4},
 CellTags->"S5.33.1"],

Cell[TextData[{
 "Options for ",
 StyleBox["BarChart3D", "MR"],
 "."
}], "Caption",
 CellTags->"S5.33.1"],

Cell[TextData[{
 StyleBox["BarChart3D", "MR"],
 " has the options ",
 StyleBox["XSpacing", "MR"],
 " and ",
 StyleBox["YSpacing", "MR"],
 ", which determine the amount of space between bars in the coordinate \
directions. This must be a number between ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4,
  ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4,
  ColumnWidths->Automatic}],
 "; the default value is ",
 StyleBox["0", "MR"],
 ". ",
 StyleBox["BarChart3D", "MR"],
 " returns a ",
 StyleBox["Graphics3D", "MR"],
 " object. This means you can give any option that can be specified for a ",
 StyleBox["Graphics3D", "MR"],
 " object. ",
 StyleBox["BarChart3D", "MR"],
 " has default option settings ",
 StyleBox["Axes", "MR"],
 " ",
 StyleBox["->", "MR"],
 " ",
 StyleBox["True", "MR"],
 " and ",
 StyleBox["BoxRatios", "MR"],
 " ",
 StyleBox["->", "MR"],
 " ",
 StyleBox["{1,", "MR"],
 " ",
 StyleBox["1,", "MR"],
 " ",
 StyleBox["1}", "MR"],
 ". "
}], "Text",
 CellTags->{"S5.33.1", "1.6"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["ScatterPlot3D[{{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4,
       ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4,
       ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["z",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4,
       ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4,
       ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4,
       ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["z",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4,
       ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, \[Ellipsis] }]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "generate a scatter plot in three dimensions",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ScatterPlot3D[{{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4,
       ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4,
       ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["z",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4,
       ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4,
       ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4,
       ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["z",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4,
       ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, \[Ellipsis] }, PlotJoined -> True]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "join the points with lines",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ListSurfacePlot3D[{{{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "11"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4,
       ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "11"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4,
       ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["z",
          "TI"], "11"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4,
       ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "12"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4,
       ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "12"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4,
       ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["z",
          "TI"], "12"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4,
       ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, \[Ellipsis] }, \[Ellipsis] }]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "use the array of points in three dimensions to generate vertices in a \
polygonal mesh",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.33.1"],

Cell["Plotting lists of points in three dimensions. ", "Caption",
 CellTags->"S5.33.1"],

Cell[TextData[{
 "The built\[Hyphen]in function ",
 StyleBox["ListPlot", "MR"],
 " will take a list of pairs of coordinates and plot them as points in the \
plane. To plot a list of triples in three dimensions, you can use ",
 StyleBox["ScatterPlot3D", "MR"],
 ". To specify a style for the points or curve being displayed, ",
 StyleBox["ScatterPlot3D", "MR"],
 " will also accept the ",
 StyleBox["PlotStyle", "MR"],
 " option. ",
 StyleBox["ListSurfacePlot3D", "MR"],
 " uses an array of points to generate the vertices of polyhedra. "
}], "Text",
 CellTags->{"S5.33.1", "1.7"}],

Cell["Here is a list of points in three dimensions. ", "MathCaption",
 CellTags->{"S5.33.1", "1.8"}],

Cell["\<\
lpts = Table[{ t Cos[t],  t Sin[t], t},
          {t, 0, 4Pi, Pi/20}];\
\>", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.33.1"],

Cell["\<\
This produces a scatter plot of the points. They lie on a conical helix. \
\>", "MathCaption",
 CellTags->{"S5.33.1", "1.9"}],

Cell[CellGroupData[{

Cell["ScatterPlot3D[lpts]", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.33.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .88341 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-5.47522e-17 1.03502 -0.0329612 1.03502 [
[.04176 .24898 -18 -8.81661 ]
[.04176 .24898 0 .18339 ]
[.17174 .1978 -11.7343 -9 ]
[.17174 .1978 .26572 0 ]
[.30835 .14402 -5.60683 -9 ]
[.30835 .14402 .39317 0 ]
[.45212 .08745 -5.34651 -9 ]
[.45212 .08745 .65349 0 ]
[.6036 .02788 -10.1724 -9 ]
[.6036 .02788 1.82761 0 ]
[.7431 .02936 0 -6.23132 ]
[.7431 .02936 18 2.76868 ]
[.81197 .13685 0 -6.13081 ]
[.81197 .13685 12 2.86919 ]
[.87464 .23466 0 -6.04133 ]
[.87464 .23466 6 2.95867 ]
[.93191 .32406 0 -5.96116 ]
[.93191 .32406 6 3.03884 ]
[.03758 .27022 -6 -2.74233 ]
[.03758 .27022 0 6.25767 ]
[.0194 .39303 -6 -2.84235 ]
[.0194 .39303 0 6.15765 ]
[-0.00024 .52572 -12 -2.9512 ]
[-0.00024 .52572 0 6.0488 ]
[ 0 0 0 0 ]
[ 1 .88341 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.05072 .25808 m
.70922 0 L
s
.05109 .25794 m
.05576 .26242 L
s
[(-10)] .04176 .24898 1 .95925 Mshowa
.18068 .20715 m
.18515 .21183 L
s
[(-5)] .17174 .1978 .95571 1 Mshowa
.31684 .15379 m
.32108 .15867 L
s
[(0)] .30835 .14402 .86894 1 Mshowa
.46009 .09764 m
.46407 .10274 L
s
[(5)] .45212 .08745 .78217 1 Mshowa
.61099 .0385 m
.61468 .04381 L
s
[(10)] .6036 .02788 .6954 1 Mshowa
.125 Mabswid
.07651 .24798 m
.07929 .25069 L
s
.10217 .23792 m
.10492 .24065 L
s
.12808 .22776 m
.13081 .23052 L
s
.15425 .21751 m
.15696 .22029 L
s
.20737 .19669 m
.21002 .19952 L
s
.23433 .18612 m
.23696 .18898 L
s
.26155 .17545 m
.26416 .17833 L
s
.28906 .16467 m
.29163 .16758 L
s
.3449 .14279 m
.34742 .14574 L
s
.37326 .13167 m
.37574 .13465 L
s
.4019 .12045 m
.40436 .12345 L
s
.43084 .1091 m
.43327 .11214 L
s
.48964 .08606 m
.49199 .08914 L
s
.5195 .07436 m
.52182 .07747 L
s
.54967 .06253 m
.55196 .06567 L
s
.58017 .05058 m
.58242 .05374 L
s
.64215 .02629 m
.64432 .0295 L
s
.67364 .01395 m
.67578 .01718 L
s
.70547 .00147 m
.70757 .00473 L
s
.25 Mabswid
.70922 0 m
.95561 .38421 L
s
.73103 .03401 m
.72499 .03633 L
s
[(-10)] .7431 .02936 -1 .38474 Mshowa
.79981 .14126 m
.79373 .14346 L
s
[(-5)] .81197 .13685 -1 .3624 Mshowa
.8624 .23886 m
.85628 .24095 L
s
[(0)] .87464 .23466 -1 .34252 Mshowa
.9196 .32805 m
.91345 .33005 L
s
[(5)] .93191 .32406 -1 .3247 Mshowa
.125 Mabswid
.74532 .0563 m
.7417 .05768 L
s
.75934 .07815 m
.75571 .07952 L
s
.77309 .09959 m
.76945 .10094 L
s
.78658 .12062 m
.78293 .12196 L
s
.81279 .1615 m
.80914 .16281 L
s
.82554 .18138 m
.82188 .18267 L
s
.83805 .20089 m
.83439 .20217 L
s
.85033 .22004 m
.84667 .22131 L
s
.87425 .25733 m
.87057 .25858 L
s
.88589 .27548 m
.88221 .27671 L
s
.89732 .29331 m
.89364 .29453 L
s
.90856 .31083 m
.90487 .31204 L
s
.71645 .01127 m
.71283 .01268 L
s
.93045 .34498 m
.92676 .34616 L
s
.94112 .36162 m
.93743 .36279 L
s
.95162 .37797 m
.94791 .37914 L
s
.25 Mabswid
.05072 .25808 m
0 .60307 L
s
.04963 .26551 m
.05566 .26316 L
s
[(0)] .03758 .27022 1 -0.39059 Mshowa
.03154 .38856 m
.03761 .38632 L
s
[(5)] .0194 .39303 1 -0.36837 Mshowa
.01199 .52151 m
.01811 .5194 L
s
[(10)] -0.00024 .52572 1 -0.34418 Mshowa
.125 Mabswid
.04612 .28938 m
.04974 .28798 L
s
.04256 .31361 m
.04618 .31223 L
s
.03894 .33822 m
.04257 .33685 L
s
.03527 .3632 m
.03891 .36184 L
s
.02775 .41432 m
.0314 .413 L
s
.0239 .44049 m
.02756 .43918 L
s
.02 .46707 m
.02366 .46577 L
s
.01603 .49407 m
.01969 .49279 L
s
.00789 .54939 m
.01157 .54815 L
s
.00373 .57773 m
.00741 .5765 L
s
.25 Mabswid
.05072 .25808 m
0 .60307 L
s
0 .60307 m
.3597 .88341 L
s
.3597 .88341 m
.37284 .567 L
s
.37284 .567 m
.05072 .25808 L
s
.70922 0 m
.95561 .38421 L
s
.95561 .38421 m
1 .71863 L
s
1 .71863 m
.733 .36174 L
s
.733 .36174 m
.70922 0 L
s
.05072 .25808 m
0 .60307 L
s
0 .60307 m
.733 .36174 L
s
.733 .36174 m
.70922 0 L
s
.70922 0 m
.05072 .25808 L
s
.37284 .567 m
.95561 .38421 L
s
.95561 .38421 m
1 .71863 L
s
1 .71863 m
.3597 .88341 L
s
.3597 .88341 m
.37284 .567 L
s
0 0 m
1 0 L
1 .88341 L
0 .88341 L
closepath
clip
newpath
.01 w
.5054 .71225 Mdot
.46674 .71749 Mdot
.54249 .70392 Mdot
.42727 .71952 Mdot
.57734 .69267 Mdot
.38774 .71828 Mdot
.60928 .67871 Mdot
.34896 .71372 Mdot
.49043 .46195 Mdot
.50052 .45577 Mdot
.47909 .46707 Mdot
.50911 .4487 Mdot
.63771 .66229 Mdot
.46681 .47097 Mdot
.51603 .44097 Mdot
.45393 .47351 Mdot
.52117 .43279 Mdot
.52449 .4244 Mdot
.49889 .37063 Mdot
.44085 .47462 Mdot
.52602 .41602 Mdot
.31178 .70587 Mdot
.50328 .3733 Mdot
.52588 .40789 Mdot
.52424 .40019 Mdot
.50807 .37687 Mdot
.66208 .64372 Mdot
.52133 .39312 Mdot
.51291 .38138 Mdot
.428 .47423 Mdot
.51744 .38682 Mdot
.41584 .47234 Mdot
.27707 .69479 Mdot
.68191 .62333 Mdot
.40482 .469 Mdot
.39544 .4643 Mdot
.6968 .60154 Mdot
.24576 .68062 Mdot
.38814 .45837 Mdot
.70645 .57877 Mdot
.38338 .45142 Mdot
.21877 .66357 Mdot
.38155 .44369 Mdot
.71068 .5555 Mdot
.383 .43547 Mdot
.70946 .53225 Mdot
.19706 .64391 Mdot
.38799 .42711 Mdot
.7029 .50952 Mdot
.39669 .41898 Mdot
.69125 .48782 Mdot
.40915 .4115 Mdot
.18159 .62202 Mdot
.4253 .40507 Mdot
.67496 .46765 Mdot
.44491 .40014 Mdot
.6546 .44945 Mdot
.46761 .39709 Mdot
.17326 .59839 Mdot
.6309 .4336 Mdot
.49287 .3963 Mdot
.60468 .4204 Mdot
.52004 .39805 Mdot
.57684 .41003 Mdot
.54832 .40259 Mdot
.17291 .57361 Mdot
.18122 .54838 Mdot
.19872 .52351 Mdot
.22563 .49991 Mdot
.88124 .58133 Mdot
.26187 .47857 Mdot
.84481 .54575 Mdot
.30695 .46047 Mdot
.79874 .51368 Mdot
.35995 .44659 Mdot
.74438 .48613 Mdot
.41951 .43779 Mdot
.68351 .46396 Mdot
.48385 .43478 Mdot
.61822 .44781 Mdot
.55087 .43805 Mdot
.25 Mabswid
.70922 0 m
.95561 .38421 L
s
.95561 .38421 m
1 .71863 L
s
1 .71863 m
.733 .36174 L
s
.733 .36174 m
.70922 0 L
s
.05072 .25808 m
0 .60307 L
s
0 .60307 m
.733 .36174 L
s
.733 .36174 m
.70922 0 L
s
.70922 0 m
.05072 .25808 L
s
.05072 .25808 m
.70922 0 L
s
.05109 .25794 m
.05576 .26242 L
s
[(-10)] .04176 .24898 1 .95925 Mshowa
.18068 .20715 m
.18515 .21183 L
s
[(-5)] .17174 .1978 .95571 1 Mshowa
.31684 .15379 m
.32108 .15867 L
s
[(0)] .30835 .14402 .86894 1 Mshowa
.46009 .09764 m
.46407 .10274 L
s
[(5)] .45212 .08745 .78217 1 Mshowa
.61099 .0385 m
.61468 .04381 L
s
[(10)] .6036 .02788 .6954 1 Mshowa
.125 Mabswid
.07651 .24798 m
.07929 .25069 L
s
.10217 .23792 m
.10492 .24065 L
s
.12808 .22776 m
.13081 .23052 L
s
.15425 .21751 m
.15696 .22029 L
s
.20737 .19669 m
.21002 .19952 L
s
.23433 .18612 m
.23696 .18898 L
s
.26155 .17545 m
.26416 .17833 L
s
.28906 .16467 m
.29163 .16758 L
s
.3449 .14279 m
.34742 .14574 L
s
.37326 .13167 m
.37574 .13465 L
s
.4019 .12045 m
.40436 .12345 L
s
.43084 .1091 m
.43327 .11214 L
s
.48964 .08606 m
.49199 .08914 L
s
.5195 .07436 m
.52182 .07747 L
s
.54967 .06253 m
.55196 .06567 L
s
.58017 .05058 m
.58242 .05374 L
s
.64215 .02629 m
.64432 .0295 L
s
.67364 .01395 m
.67578 .01718 L
s
.70547 .00147 m
.70757 .00473 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.33.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics3D", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S5.33.1"]
}, Open  ]],

Cell["This connects the points with a heavy line. ", "MathCaption",
 CellTags->{"S5.33.1", "1.10"}],

Cell[CellGroupData[{

Cell["\<\
ScatterPlot3D[lpts,
         PlotJoined -> True,
         PlotStyle -> Thickness[0.03]]\
\>", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.33.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .88341 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-5.47522e-17 1.03502 -0.0329612 1.03502 [
[.04176 .24898 -18 -8.81661 ]
[.04176 .24898 0 .18339 ]
[.17174 .1978 -11.7343 -9 ]
[.17174 .1978 .26572 0 ]
[.30835 .14402 -5.60683 -9 ]
[.30835 .14402 .39317 0 ]
[.45212 .08745 -5.34651 -9 ]
[.45212 .08745 .65349 0 ]
[.6036 .02788 -10.1724 -9 ]
[.6036 .02788 1.82761 0 ]
[.7431 .02936 0 -6.23132 ]
[.7431 .02936 18 2.76868 ]
[.81197 .13685 0 -6.13081 ]
[.81197 .13685 12 2.86919 ]
[.87464 .23466 0 -6.04133 ]
[.87464 .23466 6 2.95867 ]
[.93191 .32406 0 -5.96116 ]
[.93191 .32406 6 3.03884 ]
[.03758 .27022 -6 -2.74233 ]
[.03758 .27022 0 6.25767 ]
[.0194 .39303 -6 -2.84235 ]
[.0194 .39303 0 6.15765 ]
[-0.00024 .52572 -12 -2.9512 ]
[-0.00024 .52572 0 6.0488 ]
[ 0 0 0 0 ]
[ 1 .88341 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.05072 .25808 m
.70922 0 L
s
.05109 .25794 m
.05576 .26242 L
s
[(-10)] .04176 .24898 1 .95925 Mshowa
.18068 .20715 m
.18515 .21183 L
s
[(-5)] .17174 .1978 .95571 1 Mshowa
.31684 .15379 m
.32108 .15867 L
s
[(0)] .30835 .14402 .86894 1 Mshowa
.46009 .09764 m
.46407 .10274 L
s
[(5)] .45212 .08745 .78217 1 Mshowa
.61099 .0385 m
.61468 .04381 L
s
[(10)] .6036 .02788 .6954 1 Mshowa
.125 Mabswid
.07651 .24798 m
.07929 .25069 L
s
.10217 .23792 m
.10492 .24065 L
s
.12808 .22776 m
.13081 .23052 L
s
.15425 .21751 m
.15696 .22029 L
s
.20737 .19669 m
.21002 .19952 L
s
.23433 .18612 m
.23696 .18898 L
s
.26155 .17545 m
.26416 .17833 L
s
.28906 .16467 m
.29163 .16758 L
s
.3449 .14279 m
.34742 .14574 L
s
.37326 .13167 m
.37574 .13465 L
s
.4019 .12045 m
.40436 .12345 L
s
.43084 .1091 m
.43327 .11214 L
s
.48964 .08606 m
.49199 .08914 L
s
.5195 .07436 m
.52182 .07747 L
s
.54967 .06253 m
.55196 .06567 L
s
.58017 .05058 m
.58242 .05374 L
s
.64215 .02629 m
.64432 .0295 L
s
.67364 .01395 m
.67578 .01718 L
s
.70547 .00147 m
.70757 .00473 L
s
.25 Mabswid
.70922 0 m
.95561 .38421 L
s
.73103 .03401 m
.72499 .03633 L
s
[(-10)] .7431 .02936 -1 .38474 Mshowa
.79981 .14126 m
.79373 .14346 L
s
[(-5)] .81197 .13685 -1 .3624 Mshowa
.8624 .23886 m
.85628 .24095 L
s
[(0)] .87464 .23466 -1 .34252 Mshowa
.9196 .32805 m
.91345 .33005 L
s
[(5)] .93191 .32406 -1 .3247 Mshowa
.125 Mabswid
.74532 .0563 m
.7417 .05768 L
s
.75934 .07815 m
.75571 .07952 L
s
.77309 .09959 m
.76945 .10094 L
s
.78658 .12062 m
.78293 .12196 L
s
.81279 .1615 m
.80914 .16281 L
s
.82554 .18138 m
.82188 .18267 L
s
.83805 .20089 m
.83439 .20217 L
s
.85033 .22004 m
.84667 .22131 L
s
.87425 .25733 m
.87057 .25858 L
s
.88589 .27548 m
.88221 .27671 L
s
.89732 .29331 m
.89364 .29453 L
s
.90856 .31083 m
.90487 .31204 L
s
.71645 .01127 m
.71283 .01268 L
s
.93045 .34498 m
.92676 .34616 L
s
.94112 .36162 m
.93743 .36279 L
s
.95162 .37797 m
.94791 .37914 L
s
.25 Mabswid
.05072 .25808 m
0 .60307 L
s
.04963 .26551 m
.05566 .26316 L
s
[(0)] .03758 .27022 1 -0.39059 Mshowa
.03154 .38856 m
.03761 .38632 L
s
[(5)] .0194 .39303 1 -0.36837 Mshowa
.01199 .52151 m
.01811 .5194 L
s
[(10)] -0.00024 .52572 1 -0.34418 Mshowa
.125 Mabswid
.04612 .28938 m
.04974 .28798 L
s
.04256 .31361 m
.04618 .31223 L
s
.03894 .33822 m
.04257 .33685 L
s
.03527 .3632 m
.03891 .36184 L
s
.02775 .41432 m
.0314 .413 L
s
.0239 .44049 m
.02756 .43918 L
s
.02 .46707 m
.02366 .46577 L
s
.01603 .49407 m
.01969 .49279 L
s
.00789 .54939 m
.01157 .54815 L
s
.00373 .57773 m
.00741 .5765 L
s
.25 Mabswid
.05072 .25808 m
0 .60307 L
s
0 .60307 m
.3597 .88341 L
s
.3597 .88341 m
.37284 .567 L
s
.37284 .567 m
.05072 .25808 L
s
.70922 0 m
.95561 .38421 L
s
.95561 .38421 m
1 .71863 L
s
1 .71863 m
.733 .36174 L
s
.733 .36174 m
.70922 0 L
s
.05072 .25808 m
0 .60307 L
s
0 .60307 m
.733 .36174 L
s
.733 .36174 m
.70922 0 L
s
.70922 0 m
.05072 .25808 L
s
.37284 .567 m
.95561 .38421 L
s
.95561 .38421 m
1 .71863 L
s
1 .71863 m
.3597 .88341 L
s
.3597 .88341 m
.37284 .567 L
s
0 0 m
1 0 L
1 .88341 L
0 .88341 L
closepath
clip
newpath
.03 w
.5054 .71225 m
.46674 .71749 L
s
.54249 .70392 m
.5054 .71225 L
s
.46674 .71749 m
.42727 .71952 L
s
.57734 .69267 m
.54249 .70392 L
s
.42727 .71952 m
.38774 .71828 L
s
.60928 .67871 m
.57734 .69267 L
s
.38774 .71828 m
.34896 .71372 L
s
.63771 .66229 m
.60928 .67871 L
s
.34896 .71372 m
.31178 .70587 L
s
.49043 .46195 m
.47909 .46707 L
s
.50052 .45577 m
.49043 .46195 L
s
.50911 .4487 m
.50052 .45577 L
s
.47909 .46707 m
.46681 .47097 L
s
.51603 .44097 m
.50911 .4487 L
s
.66208 .64372 m
.63771 .66229 L
s
.46681 .47097 m
.45393 .47351 L
s
.52117 .43279 m
.51603 .44097 L
s
.45393 .47351 m
.44085 .47462 L
s
.52449 .4244 m
.52117 .43279 L
s
.52602 .41602 m
.52449 .4244 L
s
.49889 .37063 m
.50328 .3733 L
s
.44085 .47462 m
.428 .47423 L
s
.52588 .40789 m
.52602 .41602 L
s
.31178 .70587 m
.27707 .69479 L
s
.50328 .3733 m
.50807 .37687 L
s
.52424 .40019 m
.52588 .40789 L
s
.52133 .39312 m
.52424 .40019 L
s
.50807 .37687 m
.51291 .38138 L
s
.68191 .62333 m
.66208 .64372 L
s
.51744 .38682 m
.52133 .39312 L
s
.51291 .38138 m
.51744 .38682 L
s
.428 .47423 m
.41584 .47234 L
s
.41584 .47234 m
.40482 .469 L
s
.27707 .69479 m
.24576 .68062 L
s
.6968 .60154 m
.68191 .62333 L
s
.40482 .469 m
.39544 .4643 L
s
.39544 .4643 m
.38814 .45837 L
s
.70645 .57877 m
.6968 .60154 L
s
.24576 .68062 m
.21877 .66357 L
s
.38814 .45837 m
.38338 .45142 L
s
.71068 .5555 m
.70645 .57877 L
s
.38338 .45142 m
.38155 .44369 L
s
.21877 .66357 m
.19706 .64391 L
s
.38155 .44369 m
.383 .43547 L
s
.70946 .53225 m
.71068 .5555 L
s
.383 .43547 m
.38799 .42711 L
s
.7029 .50952 m
.70946 .53225 L
s
.19706 .64391 m
.18159 .62202 L
s
.38799 .42711 m
.39669 .41898 L
s
.69125 .48782 m
.7029 .50952 L
s
.39669 .41898 m
.40915 .4115 L
s
.67496 .46765 m
.69125 .48782 L
s
.40915 .4115 m
.4253 .40507 L
s
.18159 .62202 m
.17326 .59839 L
s
.4253 .40507 m
.44491 .40014 L
s
.6546 .44945 m
.67496 .46765 L
s
.44491 .40014 m
.46761 .39709 L
s
.6309 .4336 m
.6546 .44945 L
s
.46761 .39709 m
.49287 .3963 L
s
.17326 .59839 m
.17291 .57361 L
s
.60468 .4204 m
.6309 .4336 L
s
.49287 .3963 m
.52004 .39805 L
s
.57684 .41003 m
.60468 .4204 L
s
.52004 .39805 m
.54832 .40259 L
s
.54832 .40259 m
.57684 .41003 L
s
.17291 .57361 m
.18122 .54838 L
s
.18122 .54838 m
.19872 .52351 L
s
.19872 .52351 m
.22563 .49991 L
s
.22563 .49991 m
.26187 .47857 L
s
.84481 .54575 m
.88124 .58133 L
s
.26187 .47857 m
.30695 .46047 L
s
.79874 .51368 m
.84481 .54575 L
s
.30695 .46047 m
.35995 .44659 L
s
.74438 .48613 m
.79874 .51368 L
s
.35995 .44659 m
.41951 .43779 L
s
.68351 .46396 m
.74438 .48613 L
s
.41951 .43779 m
.48385 .43478 L
s
.61822 .44781 m
.68351 .46396 L
s
.48385 .43478 m
.55087 .43805 L
s
.55087 .43805 m
.61822 .44781 L
s
.25 Mabswid
.70922 0 m
.95561 .38421 L
s
.95561 .38421 m
1 .71863 L
s
1 .71863 m
.733 .36174 L
s
.733 .36174 m
.70922 0 L
s
.05072 .25808 m
0 .60307 L
s
0 .60307 m
.733 .36174 L
s
.733 .36174 m
.70922 0 L
s
.70922 0 m
.05072 .25808 L
s
.05072 .25808 m
.70922 0 L
s
.05109 .25794 m
.05576 .26242 L
s
[(-10)] .04176 .24898 1 .95925 Mshowa
.18068 .20715 m
.18515 .21183 L
s
[(-5)] .17174 .1978 .95571 1 Mshowa
.31684 .15379 m
.32108 .15867 L
s
[(0)] .30835 .14402 .86894 1 Mshowa
.46009 .09764 m
.46407 .10274 L
s
[(5)] .45212 .08745 .78217 1 Mshowa
.61099 .0385 m
.61468 .04381 L
s
[(10)] .6036 .02788 .6954 1 Mshowa
.125 Mabswid
.07651 .24798 m
.07929 .25069 L
s
.10217 .23792 m
.10492 .24065 L
s
.12808 .22776 m
.13081 .23052 L
s
.15425 .21751 m
.15696 .22029 L
s
.20737 .19669 m
.21002 .19952 L
s
.23433 .18612 m
.23696 .18898 L
s
.26155 .17545 m
.26416 .17833 L
s
.28906 .16467 m
.29163 .16758 L
s
.3449 .14279 m
.34742 .14574 L
s
.37326 .13167 m
.37574 .13465 L
s
.4019 .12045 m
.40436 .12345 L
s
.43084 .1091 m
.43327 .11214 L
s
.48964 .08606 m
.49199 .08914 L
s
.5195 .07436 m
.52182 .07747 L
s
.54967 .06253 m
.55196 .06567 L
s
.58017 .05058 m
.58242 .05374 L
s
.64215 .02629 m
.64432 .0295 L
s
.67364 .01395 m
.67578 .01718 L
s
.70547 .00147 m
.70757 .00473 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.33.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics3D", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S5.33.1"]
}, Open  ]],

Cell["Here is an array of points in three dimensions. ", "MathCaption",
 CellTags->{"S5.33.1", "1.11"}],

Cell["\<\
apts = Table[{Cos[t] Cos[u], Sin[t] Cos[u],
  Sin[u]}, {t, 0, Pi, Pi/5},
  {u, 0, Pi/2, Pi/10}];\
\>", "Input",
 CellLabel->"In[7]:= ",
 CellTags->"S5.33.1"],

Cell["\<\
The array of points is used to generate vertices in a polygonal mesh. It \
creates a piece of a sphere. \
\>", "MathCaption",
 CellTags->{"S5.33.1", "1.12"}],

Cell[CellGroupData[{

Cell["ListSurfacePlot3D[apts]", "Input",
 CellLabel->"In[8]:= ",
 CellTags->"S5.33.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .80917 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.00724804 1.00725 -0.0735757 1.00725 [
[ 0 0 0 0 ]
[ 1 .80917 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.04126 .2782 m
0 .62652 L
s
0 .62652 m
.23082 .80917 L
s
.23082 .80917 m
.25098 .47716 L
s
.25098 .47716 m
.04126 .2782 L
s
.79761 0 m
.95757 .2475 L
s
.95757 .2475 m
1 .59808 L
s
1 .59808 m
.82857 .36627 L
s
.82857 .36627 m
.79761 0 L
s
.04126 .2782 m
0 .62652 L
s
0 .62652 m
.82857 .36627 L
s
.82857 .36627 m
.79761 0 L
s
.79761 0 m
.04126 .2782 L
s
.25098 .47716 m
.95757 .2475 L
s
.95757 .2475 m
1 .59808 L
s
1 .59808 m
.23082 .80917 L
s
.23082 .80917 m
.25098 .47716 L
s
0 0 m
1 0 L
1 .80917 L
0 .80917 L
closepath
clip
newpath
.5 Mabswid
.716 .435 .499 r
.25034 .47098 m .2493 .38602 L .47953 .40428 L p F P
0 g
s
.716 .435 .499 r
.47953 .40428 m .47564 .48816 L .25034 .47098 L p F P
0 g
s
.529 .279 .481 r
.47564 .48816 m .47953 .40428 L .6877 .33666 L p F P
0 g
s
.869 .566 .472 r
.06724 .37616 m .06194 .2851 L .2493 .38602 L p F P
0 g
s
.869 .566 .472 r
.2493 .38602 m .25034 .47098 L .06724 .37616 L p F P
0 g
s
.673 .29 .313 r
.26585 .53222 m .25034 .47098 L .47564 .48816 L p F P
0 g
s
.673 .29 .313 r
.47564 .48816 m .46462 .54694 L .26585 .53222 L p F P
0 g
s
.416 .062 .254 r
.46462 .54694 m .47564 .48816 L .67911 .42458 L p F P
0 g
s
.529 .279 .481 r
.6877 .33666 m .67911 .42458 L .47564 .48816 L p F P
0 g
s
.099 0 .351 r
.67911 .42458 m .6877 .33666 L .80852 .19631 L p F P
0 g
s
.836 .405 .21 r
.10585 .45146 m .06724 .37616 L .25034 .47098 L p F P
0 g
s
.836 .405 .21 r
.25034 .47098 m .26585 .53222 L .10585 .45146 L p F P
0 g
s
.416 .062 .254 r
.67911 .42458 m .64329 .49259 L .46462 .54694 L p F P
0 g
s
0 0 0 r
.64329 .49259 m .67911 .42458 L .79658 .29289 L p F P
0 g
s
.099 0 .351 r
.80852 .19631 m .79658 .29289 L .67911 .42458 L p F P
0 g
s
.481 0 0 r
.29608 .5617 m .26585 .53222 L .46462 .54694 L p F P
0 g
s
.481 0 0 r
.46462 .54694 m .4466 .5727 L .29608 .5617 L p F P
0 g
s
.093 0 0 r
.4466 .5727 m .46462 .54694 L .64329 .49259 L p F P
0 g
s
.541 0 0 r
.17705 .50205 m .10585 .45146 L .26585 .53222 L p F P
0 g
s
.541 0 0 r
.26585 .53222 m .29608 .5617 L .17705 .50205 L p F P
0 g
s
.937 .773 .303 r
.79658 .29289 m .80852 .19631 L .78235 .02178 L p F P
0 g
s
.093 0 0 r
.64329 .49259 m .58082 .53229 L .4466 .5727 L p F P
0 g
s
0 0 0 r
.79658 .29289 m .74394 .38125 L .64329 .49259 L p F P
0 g
s
.683 .964 .742 r
.58082 .53229 m .64329 .49259 L .74394 .38125 L p F P
0 g
s
.173 .69 .887 r
.33986 .55249 m .29608 .5617 L .4466 .5727 L p F P
0 g
s
.173 .69 .887 r
.4466 .5727 m .42244 .55856 L .33986 .55249 L p F P
0 g
s
.456 .877 .929 r
.42244 .55856 m .4466 .5727 L .58082 .53229 L p F P
0 g
s
.174 .603 .94 r
.27618 .52008 m .17705 .50205 L .29608 .5617 L p F P
0 g
s
.174 .603 .94 r
.29608 .5617 m .33986 .55249 L .27618 .52008 L p F P
0 g
s
.98 .907 .658 r
.74394 .38125 m .79658 .29289 L .77021 .12965 L p F P
0 g
s
.937 .773 .303 r
.78235 .02178 m .77021 .12965 L .79658 .29289 L p F P
0 g
s
.456 .877 .929 r
.58082 .53229 m .49526 .5364 L .42244 .55856 L p F P
0 g
s
.741 .949 .947 r
.49526 .5364 m .58082 .53229 L .65316 .45109 L p F P
0 g
s
.683 .964 .742 r
.74394 .38125 m .65316 .45109 L .58082 .53229 L p F P
0 g
s
.906 .9 .809 r
.65316 .45109 m .74394 .38125 L .71787 .24546 L p F P
0 g
s
.98 .907 .658 r
.77021 .12965 m .71787 .24546 L .74394 .38125 L p F P
0 g
s
.577 .794 .981 r
.42244 .55856 m .39399 .50065 L .33986 .55249 L closepath p F P
0 g
s
.629 .824 .975 r
.49526 .5364 m .39399 .50065 L .42244 .55856 L closepath p F P
0 g
s
.555 .752 .969 r
.33986 .55249 m .39399 .50065 L .27618 .52008 L closepath p F P
0 g
s
.681 .826 .953 r
.53213 .49306 m .39399 .50065 L .49526 .5364 L closepath p F P
0 g
s
.741 .949 .947 r
.65316 .45109 m .53213 .49306 L .49526 .5364 L p F P
0 g
s
.812 .859 .883 r
.53213 .49306 m .65316 .45109 L .62996 .3549 L p F P
0 g
s
.906 .9 .809 r
.71787 .24546 m .62996 .3549 L .65316 .45109 L p F P
0 g
s
.706 .801 .924 r
.51711 .44367 m .39399 .50065 L .53213 .49306 L closepath p F P
0 g
s
.812 .859 .883 r
.62996 .3549 m .51711 .44367 L .53213 .49306 L p F P
0 g
s
.25 Mabswid
.79761 0 m
.95757 .2475 L
s
.95757 .2475 m
1 .59808 L
s
1 .59808 m
.82857 .36627 L
s
.82857 .36627 m
.79761 0 L
s
.04126 .2782 m
0 .62652 L
s
0 .62652 m
.82857 .36627 L
s
.82857 .36627 m
.79761 0 L
s
.79761 0 m
.04126 .2782 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.33.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics3D", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[8]= ",
 CellTags->"S5.33.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["ShadowPlot3D[", "MR",
       GridBoxOptions->{RowLines->{False, True},
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->{False, True},
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, True},
       RowSpacings->0.4}],
      StyleBox["xmin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, True},
       RowSpacings->0.4}],
      StyleBox["xmax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->{False, True},
       RowSpacings->0.4}],
      StyleBox["y", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, True},
       RowSpacings->0.4}],
      StyleBox["ymin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, True},
       RowSpacings->0.4}],
      StyleBox["ymax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->{False, True},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{False, True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, True},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["make a plot of ",
       GridBoxOptions->{RowLines->{False, True},
       RowSpacings->0.4}],
      StyleBox["f", "MR",
       GridBoxOptions->{RowLines->{False, True},
       RowSpacings->0.4}],
      StyleBox[" as a function of ",
       GridBoxOptions->{RowLines->{False, True},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["x",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4,
       ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, True},
       RowSpacings->0.4}],
      StyleBox[" and ",
       GridBoxOptions->{RowLines->{False, True},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["y",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4,
       ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, True},
       RowSpacings->0.4}],
      StyleBox[", and draw a shadow in the ",
       GridBoxOptions->{RowLines->{False, True},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["x",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4,
       ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, True},
       RowSpacings->0.4}],
      StyleBox["\[Hyphen]",
       GridBoxOptions->{RowLines->{False, True},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["y",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4,
       ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, True},
       RowSpacings->0.4}],
      StyleBox[" plane",
       GridBoxOptions->{RowLines->{False, True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, True},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ListShadowPlot3D[{{", "MR",
       GridBoxOptions->{RowLines->{False, True},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["z",
          "TI"], "11"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4,
       ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, True},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, True},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["z",
          "TI"], "12"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4,
       ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, True},
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] }, {", "MR",
       GridBoxOptions->{RowLines->{False, True},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["z",
          "TI"], "21"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4,
       ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, True},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, True},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["z",
          "TI"], "22"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4,
       ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, True},
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] }, \[Ellipsis] }]", "MR",
       GridBoxOptions->{RowLines->{False, True},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{False, True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, True},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "make a three\[Hyphen]dimensional plot of the array of heights ",
       GridBoxOptions->{RowLines->{False, True},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["z",
          "TI"], 
         StyleBox[
          RowBox[{"x", "y"}],
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4,
       ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, True},
       RowSpacings->0.4}],
      StyleBox[", and draw a shadow onto the ",
       GridBoxOptions->{RowLines->{False, True},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["x",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4,
       ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, True},
       RowSpacings->0.4}],
      StyleBox["\[Hyphen]",
       GridBoxOptions->{RowLines->{False, True},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["y",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4,
       ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, True},
       RowSpacings->0.4}],
      StyleBox[" plane",
       GridBoxOptions->{RowLines->{False, True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, True},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Shadow[", "MR",
       GridBoxOptions->{RowLines->{False, True},
       RowSpacings->0.4}],
      StyleBox["g", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->{False, True},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{False, True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, True},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "project shadows of the three\[Hyphen]dimensional graphics object ",
       GridBoxOptions->{RowLines->{False, True},
       RowSpacings->0.4}],
      StyleBox["g", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" onto the coordinate planes",
       GridBoxOptions->{RowLines->{False, True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, True},
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->{False, True},
 RowSpacings->0.4},
 CellTags->"S5.33.1"],

Cell["Plots with shadows. ", "Caption",
 CellTags->"S5.33.1"],

Cell[TextData[{
 StyleBox["ShadowPlot3D", "MR"],
 " and ",
 StyleBox["ListShadowPlot3D", "MR"],
 " work exactly like the built\[Hyphen]in ",
 StyleBox["Plot3D", "MR"],
 " and ",
 StyleBox["ListPlot3D", "MR"],
 ", except shadows are drawn. "
}], "Text",
 CellTags->{"S5.33.1", "1.13"}],

Cell[TextData[{
 "This puts the shadow in the ",
 Cell[BoxData[
  FormBox[
   StyleBox["x",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4,
  ColumnWidths->Automatic}],
 "\[Hyphen]",
 Cell[BoxData[
  FormBox[
   StyleBox["y",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4,
  ColumnWidths->Automatic}],
 " plane. "
}], "MathCaption",
 CellTags->{"S5.33.1", "1.14"}],

Cell[CellGroupData[{

Cell["ShadowPlot3D[Sin[x y], {x, 0, 3}, {y, 0, 3}]", "Input",
 CellLabel->"In[9]:= ",
 CellTags->"S5.33.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.0855 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0567234 1.16608 6.61905e-17 1.16608 [
[ 0 0 0 0 ]
[ 1 1.0855 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.40037 1.0855 L
s
.40037 1.0855 m
.41799 .58158 L
s
.41799 .58158 m
.08846 .24555 L
s
.67245 0 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.67245 0 m
.08846 .24555 L
s
.41799 .58158 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.40037 1.0855 L
s
.40037 1.0855 m
.41799 .58158 L
s
0 0 m
1 0 L
1 1.0855 L
0 1.0855 L
closepath
clip
newpath
.5 Mabswid
0 .179 1 r
.40443 .56352 m .42216 .58164 L .45203 .57187 L p F P
0 0 0 r
s
1 0 .804 r
.43452 .55354 m .45203 .57187 L .48225 .56199 L p F P
0 0 0 r
s
0 .179 1 r
.45203 .57187 m .43452 .55354 L .40443 .56352 L p F P
0 0 0 r
s
0 .229 1 r
.38632 .545 m .40443 .56352 L .43452 .55354 L p F P
0 0 0 r
s
1 0 .15 r
.46497 .54344 m .48225 .56199 L .51282 .552 L p F P
0 0 0 r
s
1 0 .804 r
.48225 .56199 m .46497 .54344 L .43452 .55354 L p F P
0 0 0 r
s
1 0 .907 r
.41663 .5348 m .43452 .55354 L .46497 .54344 L p F P
0 0 0 r
s
0 .229 1 r
.43452 .55354 m .41663 .5348 L .38632 .545 L p F P
0 0 0 r
s
1 0 .429 r
.49578 .53322 m .51282 .552 L .54377 .54188 L p F P
0 0 0 r
s
1 0 .15 r
.51282 .552 m .49578 .53322 L .46497 .54344 L p F P
0 0 0 r
s
0 .281 1 r
.36781 .52607 m .38632 .545 L .41663 .5348 L p F P
0 0 0 r
s
1 0 .183 r
.44731 .52448 m .46497 .54344 L .49578 .53322 L p F P
0 0 0 r
s
1 0 .907 r
.46497 .54344 m .44731 .52448 L .41663 .5348 L p F P
0 0 0 r
s
.452 0 1 r
.52697 .52288 m .54377 .54188 L .57508 .53164 L p F P
0 0 0 r
s
1 0 .429 r
.54377 .54188 m .52697 .52288 L .49578 .53322 L p F P
0 0 0 r
s
.98 0 1 r
.39835 .51564 m .41663 .5348 L .44731 .52448 L p F P
0 0 0 r
s
0 .281 1 r
.41663 .5348 m .39835 .51564 L .36781 .52607 L p F P
0 0 0 r
s
1 0 .261 r
.47836 .51403 m .49578 .53322 L .52697 .52288 L p F P
0 0 0 r
s
1 0 .183 r
.49578 .53322 m .47836 .51403 L .44731 .52448 L p F P
0 0 0 r
s
0 1 .862 r
.55853 .51241 m .57508 .53164 L .60677 .52128 L p F P
0 0 0 r
s
.452 0 1 r
.57508 .53164 m .55853 .51241 L .52697 .52288 L p F P
0 0 0 r
s
0 .335 1 r
.34887 .50672 m .36781 .52607 L .39835 .51564 L p F P
0 0 0 r
s
1 0 .245 r
.42926 .50509 m .44731 .52448 L .47836 .51403 L p F P
0 0 0 r
s
.98 0 1 r
.44731 .52448 m .42926 .50509 L .39835 .51564 L p F P
0 0 0 r
s
.881 0 1 r
.50979 .50345 m .52697 .52288 L .55853 .51241 L p F P
0 0 0 r
s
1 0 .261 r
.52697 .52288 m .50979 .50345 L .47836 .51403 L p F P
0 0 0 r
s
.676 1 0 r
.59048 .50181 m .60677 .52128 L .63885 .51079 L p F P
0 0 0 r
s
0 1 .862 r
.60677 .52128 m .59048 .50181 L .55853 .51241 L p F P
0 0 0 r
s
.858 0 1 r
.37964 .49605 m .39835 .51564 L .42926 .50509 L p F P
0 0 0 r
s
0 .335 1 r
.39835 .51564 m .37964 .49605 L .34887 .50672 L p F P
0 0 0 r
s
1 0 .147 r
.46055 .4944 m .47836 .51403 L .50979 .50345 L p F P
0 0 0 r
s
1 0 .245 r
.47836 .51403 m .46055 .4944 L .42926 .50509 L p F P
0 0 0 r
s
0 .509 1 r
.54161 .49274 m .55853 .51241 L .59048 .50181 L p F P
0 0 0 r
s
.881 0 1 r
.55853 .51241 m .54161 .49274 L .50979 .50345 L p F P
0 0 0 r
s
1 .341 0 r
.62282 .49109 m .63885 .51079 L .67132 .50017 L p F P
0 0 0 r
s
.676 1 0 r
.63885 .51079 m .62282 .49109 L .59048 .50181 L p F P
0 0 0 r
s
0 .389 1 r
.32951 .48692 m .34887 .50672 L .37964 .49605 L p F P
0 0 0 r
s
1 0 .337 r
.41079 .48525 m .42926 .50509 L .46055 .4944 L p F P
0 0 0 r
s
.858 0 1 r
.42926 .50509 m .41079 .48525 L .37964 .49605 L p F P
0 0 0 r
s
1 0 .747 r
.49223 .48358 m .50979 .50345 L .54161 .49274 L p F P
0 0 0 r
s
1 0 .147 r
.50979 .50345 m .49223 .48358 L .46055 .4944 L p F P
0 0 0 r
s
.032 1 0 r
.57382 .48191 m .59048 .50181 L .62282 .49109 L p F P
0 0 0 r
s
0 .509 1 r
.59048 .50181 m .57382 .48191 L .54161 .49274 L p F P
0 0 0 r
s
1 .232 0 r
.65556 .48023 m .67132 .50017 L .70419 .48942 L p F P
0 0 0 r
s
1 .341 0 r
.67132 .50017 m .65556 .48023 L .62282 .49109 L p F P
0 0 0 r
s
.727 0 1 r
.36051 .47601 m .37964 .49605 L .41079 .48525 L p F P
0 0 0 r
s
0 .389 1 r
.37964 .49605 m .36051 .47601 L .32951 .48692 L p F P
0 0 0 r
s
1 0 .088 r
.44233 .47432 m .46055 .4944 L .49223 .48358 L p F P
0 0 0 r
s
1 0 .337 r
.46055 .4944 m .44233 .47432 L .41079 .48525 L p F P
0 0 0 r
s
.103 0 1 r
.5243 .47263 m .54161 .49274 L .57382 .48191 L p F P
0 0 0 r
s
1 0 .747 r
.54161 .49274 m .5243 .47263 L .49223 .48358 L p F P
0 0 0 r
s
1 .745 0 r
.60643 .47093 m .62282 .49109 L .65556 .48023 L p F P
0 0 0 r
s
.032 1 0 r
.62282 .49109 m .60643 .47093 L .57382 .48191 L p F P
0 0 0 r
s
.974 1 0 r
.68871 .46923 m .70419 .48942 L .73747 .47854 L p F P
0 0 0 r
s
1 .232 0 r
.70419 .48942 m .68871 .46923 L .65556 .48023 L p F P
0 0 0 r
s
0 .444 1 r
.3097 .46667 m .32951 .48692 L .36051 .47601 L p F P
0 0 0 r
s
1 0 .458 r
.3919 .46497 m .41079 .48525 L .44233 .47432 L p F P
0 0 0 r
s
.727 0 1 r
.41079 .48525 m .3919 .46497 L .36051 .47601 L p F P
0 0 0 r
s
1 0 .446 r
.47426 .46325 m .49223 .48358 L .5243 .47263 L p F P
0 0 0 r
s
1 0 .088 r
.49223 .48358 m .47426 .46325 L .44233 .47432 L p F P
0 0 0 r
s
0 1 .688 r
.55677 .46154 m .57382 .48191 L .60643 .47093 L p F P
0 0 0 r
s
.103 0 1 r
.57382 .48191 m .55677 .46154 L .5243 .47263 L p F P
0 0 0 r
s
1 .17 0 r
.63944 .45982 m .65556 .48023 L .68871 .46923 L p F P
0 0 0 r
s
1 .745 0 r
.65556 .48023 m .63944 .45982 L .60643 .47093 L p F P
0 0 0 r
s
0 1 .458 r
.72228 .4581 m .73747 .47854 L .77116 .46753 L p F P
0 0 0 r
s
.974 1 0 r
.73747 .47854 m .72228 .4581 L .68871 .46923 L p F P
0 0 0 r
s
.589 0 1 r
.34094 .45551 m .36051 .47601 L .3919 .46497 L p F P
0 0 0 r
s
0 .444 1 r
.36051 .47601 m .34094 .45551 L .3097 .46667 L p F P
0 0 0 r
s
1 0 .088 r
.42368 .45378 m .44233 .47432 L .47426 .46325 L p F P
0 0 0 r
s
1 0 .458 r
.44233 .47432 m .42368 .45378 L .3919 .46497 L p F P
0 0 0 r
s
.667 0 1 r
.50659 .45205 m .5243 .47263 L .55677 .46154 L p F P
0 0 0 r
s
1 0 .446 r
.5243 .47263 m .50659 .45205 L .47426 .46325 L p F P
0 0 0 r
s
.643 1 0 r
.58965 .45031 m .60643 .47093 L .63944 .45982 L p F P
0 0 0 r
s
0 1 .688 r
.60643 .47093 m .58965 .45031 L .55677 .46154 L p F P
0 0 0 r
s
1 .403 0 r
.67288 .44857 m .68871 .46923 L .72228 .4581 L p F P
0 0 0 r
s
1 .17 0 r
.68871 .46923 m .67288 .44857 L .63944 .45982 L p F P
0 0 0 r
s
.054 0 1 r
.75626 .44683 m .77116 .46753 L .80527 .45637 L p F P
0 0 0 r
s
0 1 .458 r
.77116 .46753 m .75626 .44683 L .72228 .4581 L p F P
0 0 0 r
s
0 .5 1 r
.28943 .44595 m .3097 .46667 L .34094 .45551 L p F P
0 0 0 r
s
1 0 .607 r
.37257 .4442 m .3919 .46497 L .42368 .45378 L p F P
0 0 0 r
s
.589 0 1 r
.3919 .46497 m .37257 .4442 L .34094 .45551 L p F P
0 0 0 r
s
1 0 .225 r
.45586 .44245 m .47426 .46325 L .50659 .45205 L p F P
0 0 0 r
s
1 0 .088 r
.47426 .46325 m .45586 .44245 L .42368 .45378 L p F P
0 0 0 r
s
0 .562 1 r
.53932 .4407 m .55677 .46154 L .58965 .45031 L p F P
0 0 0 r
s
.667 0 1 r
.55677 .46154 m .53932 .4407 L .50659 .45205 L p F P
0 0 0 r
s
1 .435 0 r
.62295 .43894 m .63944 .45982 L .67288 .44857 L p F P
0 0 0 r
s
.643 1 0 r
.63944 .45982 m .62295 .43894 L .58965 .45031 L p F P
0 0 0 r
s
.63 1 0 r
.70673 .43718 m .72228 .4581 L .75626 .44683 L p F P
0 0 0 r
s
1 .403 0 r
.72228 .4581 m .70673 .43718 L .67288 .44857 L p F P
0 0 0 r
s
1 0 .709 r
.79068 .43541 m .80527 .45637 L .83981 .44508 L p F P
0 0 0 r
s
.054 0 1 r
.80527 .45637 m .79068 .43541 L .75626 .44683 L p F P
0 0 0 r
s
.442 0 1 r
.3209 .43453 m .34094 .45551 L .37257 .4442 L p F P
0 0 0 r
s
0 .5 1 r
.34094 .45551 m .3209 .43453 L .28943 .44595 L p F P
0 0 0 r
s
1 0 .146 r
.4046 .43276 m .42368 .45378 L .45586 .44245 L p F P
0 0 0 r
s
1 0 .607 r
.42368 .45378 m .4046 .43276 L .37257 .4442 L p F P
0 0 0 r
s
1 0 .845 r
.48846 .43098 m .50659 .45205 L .53932 .4407 L p F P
0 0 0 r
s
1 0 .225 r
.50659 .45205 m .48846 .43098 L .45586 .44245 L p F P
0 0 0 r
s
0 1 .123 r
.57248 .4292 m .58965 .45031 L .62295 .43894 L p F P
0 0 0 r
s
0 .562 1 r
.58965 .45031 m .57248 .4292 L .53932 .4407 L p F P
0 0 0 r
s
1 .146 0 r
.65667 .42742 m .67288 .44857 L .70673 .43718 L p F P
0 0 0 r
s
1 .435 0 r
.67288 .44857 m .65667 .42742 L .62295 .43894 L p F P
0 0 0 r
s
0 1 .792 r
.74102 .42564 m .75626 .44683 L .79068 .43541 L p F P
0 0 0 r
s
.63 1 0 r
.75626 .44683 m .74102 .42564 L .70673 .43718 L p F P
0 0 0 r
s
0 .557 1 r
.26868 .42474 m .28943 .44595 L .3209 .43453 L p F P
0 0 0 r
s
1 0 .23 r
.82554 .42385 m .83981 .44508 L .87479 .43364 L p F P
0 0 0 r
s
1 0 .709 r
.83981 .44508 m .82554 .42385 L .79068 .43541 L p F P
0 0 0 r
s
1 0 .782 r
.35278 .42295 m .37257 .4442 L .4046 .43276 L p F P
0 0 0 r
s
.442 0 1 r
.37257 .4442 m .35278 .42295 L .3209 .43453 L p F P
0 0 0 r
s
1 0 .094 r
.43704 .42116 m .45586 .44245 L .48846 .43098 L p F P
0 0 0 r
s
1 0 .146 r
.45586 .44245 m .43704 .42116 L .4046 .43276 L p F P
0 0 0 r
s
.164 0 1 r
.52147 .41936 m .53932 .4407 L .57248 .4292 L p F P
0 0 0 r
s
1 0 .845 r
.53932 .4407 m .52147 .41936 L .48846 .43098 L p F P
0 0 0 r
s
1 .999 0 r
.60606 .41756 m .62295 .43894 L .65667 .42742 L p F P
0 0 0 r
s
0 1 .123 r
.62295 .43894 m .60606 .41756 L .57248 .4292 L p F P
0 0 0 r
s
1 .556 0 r
.69082 .41576 m .70673 .43718 L .74102 .42564 L p F P
0 0 0 r
s
1 .146 0 r
.70673 .43718 m .69082 .41576 L .65667 .42742 L p F P
0 0 0 r
s
.259 0 1 r
.77575 .41395 m .79068 .43541 L .82554 .42385 L p F P
0 0 0 r
s
0 1 .792 r
.79068 .43541 m .77575 .41395 L .74102 .42564 L p F P
0 0 0 r
s
.289 0 1 r
.3004 .41305 m .3209 .43453 L .35278 .42295 L p F P
0 0 0 r
s
0 .557 1 r
.3209 .43453 m .3004 .41305 L .26868 .42474 L p F P
0 0 0 r
s
1 0 .659 r
.86084 .41214 m .87479 .43364 L .91022 .42206 L p F P
0 0 0 r
s
1 0 .23 r
.87479 .43364 m .86084 .41214 L .82554 .42385 L p F P
0 0 0 r
s
1 0 .262 r
.38506 .41123 m .4046 .43276 L .43704 .42116 L p F P
0 0 0 r
s
1 0 .782 r
.4046 .43276 m .38506 .41123 L .35278 .42295 L p F P
0 0 0 r
s
1 0 .457 r
.4699 .40942 m .48846 .43098 L .52147 .41936 L p F P
0 0 0 r
s
1 0 .094 r
.48846 .43098 m .4699 .40942 L .43704 .42116 L p F P
0 0 0 r
s
0 1 .976 r
.5549 .4076 m .57248 .4292 L .60606 .41756 L p F P
0 0 0 r
s
.164 0 1 r
.57248 .4292 m .5549 .4076 L .52147 .41936 L p F P
0 0 0 r
s
1 .297 0 r
.64007 .40577 m .65667 .42742 L .69082 .41576 L p F P
0 0 0 r
s
1 .999 0 r
.65667 .42742 m .64007 .40577 L .60606 .41756 L p F P
0 0 0 r
s
.441 1 0 r
.72541 .40394 m .74102 .42564 L .77575 .41395 L p F P
0 0 0 r
s
1 .556 0 r
.74102 .42564 m .72541 .40394 L .69082 .41576 L p F P
0 0 0 r
s
0 .615 1 r
.24744 .40303 m .26868 .42474 L .3004 .41305 L p F P
0 0 0 r
s
1 0 .646 r
.81092 .40211 m .82554 .42385 L .86084 .41214 L p F P
0 0 0 r
s
.259 0 1 r
.82554 .42385 m .81092 .40211 L .77575 .41395 L p F P
0 0 0 r
s
1 0 .981 r
.33252 .4012 m .35278 .42295 L .38506 .41123 L p F P
0 0 0 r
s
.289 0 1 r
.35278 .42295 m .33252 .4012 L .3004 .41305 L p F P
0 0 0 r
s
1 0 .659 r
.91022 .42206 m .8966 .40028 L .86084 .41214 L p F P
0 0 0 r
s
1 0 .058 r
.41777 .39936 m .43704 .42116 L .4699 .40942 L p F P
0 0 0 r
s
1 0 .262 r
.43704 .42116 m .41777 .39936 L .38506 .41123 L p F P
0 0 0 r
s
.818 0 1 r
.50318 .39752 m .52147 .41936 L .5549 .4076 L p F P
0 0 0 r
s
1 0 .457 r
.52147 .41936 m .50318 .39752 L .4699 .40942 L p F P
0 0 0 r
s
0 .179 1 r
.39229 .87053 m .4119 .8868 L .44231 .97581 L p F P
0 0 0 r
s
.201 1 0 r
.58877 .39568 m .60606 .41756 L .64007 .40577 L p F P
0 0 0 r
s
0 1 .976 r
.60606 .41756 m .58877 .39568 L .5549 .4076 L p F P
0 0 0 r
s
1 .161 0 r
.67452 .39383 m .69082 .41576 L .72541 .40394 L p F P
0 0 0 r
s
1 .297 0 r
.69082 .41576 m .67452 .39383 L .64007 .40577 L p F P
0 0 0 r
s
1 .341 0 r
.62913 .68762 m .64511 .67929 L .6785 .64957 L p F P
0 0 0 r
s
.676 1 0 r
.64511 .67929 m .62913 .68762 L .59635 .77781 L p F P
0 0 0 r
s
.676 1 0 r
.59635 .77781 m .61305 .7582 L .64511 .67929 L p F P
0 0 0 r
s
0 1 .904 r
.76045 .39198 m .77575 .41395 L .81092 .40211 L p F P
0 0 0 r
s
.441 1 0 r
.77575 .41395 m .76045 .39198 L .72541 .40394 L p F P
0 0 0 r
s
1 .232 0 r
.6622 .63404 m .6785 .64957 L .71515 .67468 L p F P
0 0 0 r
s
1 .341 0 r
.6785 .64957 m .6622 .63404 L .62913 .68762 L p F P
0 0 0 r
s
.13 0 1 r
.2794 .39105 m .3004 .41305 L .33252 .4012 L p F P
0 0 0 r
s
0 .615 1 r
.3004 .41305 m .2794 .39105 L .24744 .40303 L p F P
0 0 0 r
s
1 0 .23 r
.84655 .39012 m .86084 .41214 L .8966 .40028 L p F P
0 0 0 r
s
1 0 .646 r
.86084 .41214 m .84655 .39012 L .81092 .40211 L p F P
0 0 0 r
s
1 0 .433 r
.36506 .38919 m .38506 .41123 L .41777 .39936 L p F P
0 0 0 r
s
1 0 .981 r
.38506 .41123 m .36506 .38919 L .33252 .4012 L p F P
0 0 0 r
s
1 0 .192 r
.45089 .38733 m .4699 .40942 L .50318 .39752 L p F P
0 0 0 r
s
1 0 .058 r
.4699 .40942 m .45089 .38733 L .41777 .39936 L p F P
0 0 0 r
s
0 .162 1 r
.5369 .38547 m .5549 .4076 L .58877 .39568 L p F P
0 0 0 r
s
.818 0 1 r
.5549 .4076 m .5369 .38547 L .50318 .39752 L p F P
0 0 0 r
s
1 .838 0 r
.62308 .3836 m .64007 .40577 L .67452 .39383 L p F P
0 0 0 r
s
.201 1 0 r
.64007 .40577 m .62308 .3836 L .58877 .39568 L p F P
0 0 0 r
s
1 .615 0 r
.70943 .38173 m .72541 .40394 L .76045 .39198 L p F P
0 0 0 r
s
1 .161 0 r
.72541 .40394 m .70943 .38173 L .67452 .39383 L p F P
0 0 0 r
s
0 .673 1 r
.22569 .38079 m .24744 .40303 L .2794 .39105 L p F P
0 0 0 r
s
.259 0 1 r
.79595 .37985 m .81092 .40211 L .84655 .39012 L p F P
0 0 0 r
s
0 1 .904 r
.81092 .40211 m .79595 .37985 L .76045 .39198 L p F P
0 0 0 r
s
.798 0 1 r
.31177 .37891 m .33252 .4012 L .36506 .38919 L p F P
0 0 0 r
s
.13 0 1 r
.33252 .4012 m .31177 .37891 L .2794 .39105 L p F P
0 0 0 r
s
1 0 .23 r
.8966 .40028 m .88265 .37797 L .84655 .39012 L p F P
0 0 0 r
s
1 0 .118 r
.39803 .37703 m .41777 .39936 L .45089 .38733 L p F P
0 0 0 r
s
1 0 .433 r
.41777 .39936 m .39803 .37703 L .36506 .38919 L p F P
0 0 0 r
s
1 0 .647 r
.48446 .37515 m .50318 .39752 L .5369 .38547 L p F P
0 0 0 r
s
1 0 .192 r
.50318 .39752 m .48446 .37515 L .45089 .38733 L p F P
0 0 0 r
s
0 .179 1 r
.44231 .97581 m .42255 .95406 L .39229 .87053 L p F P
0 0 0 r
s
0 .229 1 r
.3722 .85386 m .39229 .87053 L .42255 .95406 L p F P
0 0 0 r
s
0 1 .744 r
.57106 .37326 m .58877 .39568 L .62308 .3836 L p F P
0 0 0 r
s
0 .162 1 r
.58877 .39568 m .57106 .37326 L .5369 .38547 L p F P
0 0 0 r
s
1 .26 0 r
.65784 .37137 m .67452 .39383 L .70943 .38173 L p F P
0 0 0 r
s
1 .838 0 r
.67452 .39383 m .65784 .37137 L .62308 .3836 L p F P
0 0 0 r
s
.441 1 0 r
.74479 .36947 m .76045 .39198 L .79595 .37985 L p F P
0 0 0 r
s
1 .615 0 r
.76045 .39198 m .74479 .36947 L .70943 .38173 L p F P
0 0 0 r
s
0 .035 1 r
.25789 .36852 m .2794 .39105 L .31177 .37891 L p F P
0 0 0 r
s
0 .673 1 r
.2794 .39105 m .25789 .36852 L .22569 .38079 L p F P
0 0 0 r
s
1 0 .709 r
.83192 .36757 m .84655 .39012 L .88265 .37797 L p F P
0 0 0 r
s
.259 0 1 r
.84655 .39012 m .83192 .36757 L .79595 .37985 L p F P
0 0 0 r
s
1 .232 0 r
.71515 .67468 m .69733 .62765 L .6622 .63404 L p F P
0 0 0 r
s
1 .17 0 r
.64606 .63388 m .6622 .63404 L .69733 .62765 L p F P
0 0 0 r
s
1 .745 0 r
.6622 .63404 m .64606 .63388 L .61271 .70536 L p F P
0 0 0 r
s
1 .745 0 r
.61271 .70536 m .62913 .68762 L .6622 .63404 L p F P
0 0 0 r
s
1 0 .658 r
.34457 .36662 m .36506 .38919 L .39803 .37703 L p F P
0 0 0 r
s
.798 0 1 r
.36506 .38919 m .34457 .36662 L .31177 .37891 L p F P
0 0 0 r
s
1 0 .061 r
.43143 .36471 m .45089 .38733 L .48446 .37515 L p F P
0 0 0 r
s
1 0 .118 r
.45089 .38733 m .43143 .36471 L .39803 .37703 L p F P
0 0 0 r
s
0 1 .862 r
.61305 .7582 m .59635 .77781 L .56247 .88311 L p F P
0 0 0 r
s
0 1 .862 r
.56247 .88311 m .58043 .8661 L .61305 .7582 L p F P
0 0 0 r
s
.631 0 1 r
.51846 .3628 m .5369 .38547 L .57106 .37326 L p F P
0 0 0 r
s
1 0 .647 r
.5369 .38547 m .51846 .3628 L .48446 .37515 L p F P
0 0 0 r
s
.306 1 0 r
.60567 .36089 m .62308 .3836 L .65784 .37137 L p F P
0 0 0 r
s
0 1 .744 r
.62308 .3836 m .60567 .36089 L .57106 .37326 L p F P
0 0 0 r
s
1 .161 0 r
.69306 .35897 m .70943 .38173 L .74479 .36947 L p F P
0 0 0 r
s
1 .26 0 r
.70943 .38173 m .69306 .35897 L .65784 .37137 L p F P
0 0 0 r
s
.974 1 0 r
.69733 .62765 m .71515 .67468 L .7563 .74575 L p F P
0 0 0 r
s
0 .732 1 r
.20341 .35801 m .22569 .38079 L .25789 .36852 L p F P
0 0 0 r
s
0 1 .792 r
.78062 .35705 m .79595 .37985 L .83192 .36757 L p F P
0 0 0 r
s
.441 1 0 r
.79595 .37985 m .78062 .35705 L .74479 .36947 L p F P
0 0 0 r
s
.556 0 1 r
.29052 .35609 m .31177 .37891 L .34457 .36662 L p F P
0 0 0 r
s
0 .035 1 r
.31177 .37891 m .29052 .35609 L .25789 .36852 L p F P
0 0 0 r
s
1 0 .709 r
.88265 .37797 m .86836 .35512 L .83192 .36757 L p F P
0 0 0 r
s
1 0 .272 r
.37781 .35416 m .39803 .37703 L .43143 .36471 L p F P
0 0 0 r
s
1 0 .658 r
.39803 .37703 m .37781 .35416 L .34457 .36662 L p F P
0 0 0 r
s
.032 1 0 r
.62913 .68762 m .61271 .70536 L .57886 .80054 L p F P
0 0 0 r
s
.032 1 0 r
.57886 .80054 m .59635 .77781 L .62913 .68762 L p F P
0 0 0 r
s
1 0 .267 r
.46527 .35223 m .48446 .37515 L .51846 .3628 L p F P
0 0 0 r
s
1 0 .061 r
.48446 .37515 m .46527 .35223 L .43143 .36471 L p F P
0 0 0 r
s
.974 1 0 r
.7563 .74575 m .7361 .66797 L .69733 .62765 L p F P
0 0 0 r
s
1 .403 0 r
.68033 .59945 m .69733 .62765 L .7361 .66797 L p F P
0 0 0 r
s
1 .17 0 r
.69733 .62765 m .68033 .59945 L .64606 .63388 L p F P
0 0 0 r
s
0 .229 1 r
.42255 .95406 m .40237 .93168 L .3722 .85386 L p F P
0 0 0 r
s
0 .281 1 r
.35162 .83678 m .3722 .85386 L .40237 .93168 L p F P
0 0 0 r
s
0 .274 1 r
.55292 .35029 m .57106 .37326 L .60567 .36089 L p F P
0 0 0 r
s
.631 0 1 r
.57106 .37326 m .55292 .35029 L .51846 .3628 L p F P
0 0 0 r
s
1 .838 0 r
.64074 .34835 m .65784 .37137 L .69306 .35897 L p F P
0 0 0 r
s
.306 1 0 r
.65784 .37137 m .64074 .34835 L .60567 .36089 L p F P
0 0 0 r
s
1 .556 0 r
.72874 .34641 m .74479 .36947 L .78062 .35705 L p F P
0 0 0 r
s
1 .161 0 r
.74479 .36947 m .72874 .34641 L .69306 .35897 L p F P
0 0 0 r
s
0 .204 1 r
.23585 .34544 m .25789 .36852 L .29052 .35609 L p F P
0 0 0 r
s
0 .732 1 r
.25789 .36852 m .23585 .34544 L .20341 .35801 L p F P
0 0 0 r
s
.054 0 1 r
.81693 .34446 m .83192 .36757 L .86836 .35512 L p F P
0 0 0 r
s
0 1 .792 r
.83192 .36757 m .81693 .34446 L .78062 .35705 L p F P
0 0 0 r
s
1 0 .93 r
.32358 .34349 m .34457 .36662 L .37781 .35416 L p F P
0 0 0 r
s
.556 0 1 r
.34457 .36662 m .32358 .34349 L .29052 .35609 L p F P
0 0 0 r
s
1 0 .073 r
.41148 .34153 m .43143 .36471 L .46527 .35223 L p F P
0 0 0 r
s
1 0 .272 r
.43143 .36471 m .41148 .34153 L .37781 .35416 L p F P
0 0 0 r
s
1 0 .718 r
.49957 .33958 m .51846 .3628 L .55292 .35029 L p F P
0 0 0 r
s
1 0 .267 r
.51846 .3628 m .49957 .33958 L .46527 .35223 L p F P
0 0 0 r
s
0 1 .744 r
.58783 .33762 m .60567 .36089 L .64074 .34835 L p F P
0 0 0 r
s
0 .274 1 r
.60567 .36089 m .58783 .33762 L .55292 .35029 L p F P
0 0 0 r
s
1 .297 0 r
.67628 .33565 m .69306 .35897 L .72874 .34641 L p F P
0 0 0 r
s
1 .838 0 r
.69306 .35897 m .67628 .33565 L .64074 .34835 L p F P
0 0 0 r
s
0 .791 1 r
.18057 .33467 m .20341 .35801 L .23585 .34544 L p F P
0 0 0 r
s
.63 1 0 r
.76491 .33368 m .78062 .35705 L .81693 .34446 L p F P
0 0 0 r
s
1 .556 0 r
.78062 .35705 m .76491 .33368 L .72874 .34641 L p F P
0 0 0 r
s
1 .403 0 r
.7361 .66797 m .7171 .60704 L .68033 .59945 L p F P
0 0 0 r
s
1 .146 0 r
.66391 .59116 m .68033 .59945 L .7171 .60704 L p F P
0 0 0 r
s
1 .435 0 r
.68033 .59945 m .66391 .59116 L .62978 .64791 L p F P
0 0 0 r
s
1 .435 0 r
.62978 .64791 m .64606 .63388 L .68033 .59945 L p F P
0 0 0 r
s
.297 0 1 r
.26874 .3327 m .29052 .35609 L .32358 .34349 L p F P
0 0 0 r
s
0 .204 1 r
.29052 .35609 m .26874 .3327 L .23585 .34544 L p F P
0 0 0 r
s
.643 1 0 r
.64606 .63388 m .62978 .64791 L .59563 .73035 L p F P
0 0 0 r
s
.643 1 0 r
.59563 .73035 m .61271 .70536 L .64606 .63388 L p F P
0 0 0 r
s
.054 0 1 r
.86836 .35512 m .85372 .33171 L .81693 .34446 L p F P
0 0 0 r
s
1 0 .517 r
.35708 .33072 m .37781 .35416 L .41148 .34153 L p F P
0 0 0 r
s
1 0 .93 r
.37781 .35416 m .35708 .33072 L .32358 .34349 L p F P
0 0 0 r
s
1 0 .804 r
.42255 .95406 m .44231 .97581 L .47549 1.03432 L p F P
0 0 0 r
s
1 0 .071 r
.44561 .32874 m .46527 .35223 L .49957 .33958 L p F P
0 0 0 r
s
1 0 .073 r
.46527 .35223 m .44561 .32874 L .41148 .34153 L p F P
0 0 0 r
s
0 .281 1 r
.40237 .93168 m .38176 .90868 L .35162 .83678 L p F P
0 0 0 r
s
0 .335 1 r
.33053 .81928 m .35162 .83678 L .38176 .90868 L p F P
0 0 0 r
s
.631 0 1 r
.53432 .32676 m .55292 .35029 L .58783 .33762 L p F P
0 0 0 r
s
1 0 .718 r
.55292 .35029 m .53432 .32676 L .49957 .33958 L p F P
0 0 0 r
s
.201 1 0 r
.62322 .32477 m .64074 .34835 L .67628 .33565 L p F P
0 0 0 r
s
0 1 .744 r
.64074 .34835 m .62322 .32477 L .58783 .33762 L p F P
0 0 0 r
s
1 .146 0 r
.7123 .32278 m .72874 .34641 L .76491 .33368 L p F P
0 0 0 r
s
1 .297 0 r
.72874 .34641 m .7123 .32278 L .67628 .33565 L p F P
0 0 0 r
s
0 .377 1 r
.21327 .32178 m .23585 .34544 L .26874 .3327 L p F P
0 0 0 r
s
0 .791 1 r
.23585 .34544 m .21327 .32178 L .18057 .33467 L p F P
0 0 0 r
s
0 1 .458 r
.80156 .32078 m .81693 .34446 L .85372 .33171 L p F P
0 0 0 r
s
.63 1 0 r
.81693 .34446 m .80156 .32078 L .76491 .33368 L p F P
0 0 0 r
s
.756 0 1 r
.30206 .31978 m .32358 .34349 L .35708 .33072 L p F P
0 0 0 r
s
.297 0 1 r
.32358 .34349 m .30206 .31978 L .26874 .3327 L p F P
0 0 0 r
s
.452 0 1 r
.58043 .8661 m .56247 .88311 L .52707 .97401 L p F P
0 0 0 r
s
.452 0 1 r
.52707 .97401 m .54621 .97012 L .58043 .8661 L p F P
0 0 0 r
s
0 .509 1 r
.59635 .77781 m .57886 .80054 L .54367 .89846 L p F P
0 0 0 r
s
0 .509 1 r
.54367 .89846 m .56247 .88311 L .59635 .77781 L p F P
0 0 0 r
s
1 0 .227 r
.39104 .31778 m .41148 .34153 L .44561 .32874 L p F P
0 0 0 r
s
1 0 .517 r
.41148 .34153 m .39104 .31778 L .35708 .33072 L p F P
0 0 0 r
s
1 0 .267 r
.4802 .31577 m .49957 .33958 L .53432 .32676 L p F P
0 0 0 r
s
1 0 .071 r
.49957 .33958 m .4802 .31577 L .44561 .32874 L p F P
0 0 0 r
s
0 .162 1 r
.56955 .31376 m .58783 .33762 L .62322 .32477 L p F P
0 0 0 r
s
.631 0 1 r
.58783 .33762 m .56955 .31376 L .53432 .32676 L p F P
0 0 0 r
s
1 .999 0 r
.65908 .31175 m .67628 .33565 L .7123 .32278 L p F P
0 0 0 r
s
.201 1 0 r
.67628 .33565 m .65908 .31175 L .62322 .32477 L p F P
0 0 0 r
s
0 .851 1 r
.15717 .31074 m .18057 .33467 L .21327 .32178 L p F P
0 0 0 r
s
1 .403 0 r
.7488 .30973 m .76491 .33368 L .80156 .32078 L p F P
0 0 0 r
s
1 .146 0 r
.76491 .33368 m .7488 .30973 L .7123 .32278 L p F P
0 0 0 r
s
.63 1 0 r
.77926 .74336 m .75764 .65348 L .7171 .60704 L p F P
0 0 0 r
s
.63 1 0 r
.7171 .60704 m .7361 .66797 L .77926 .74336 L p F P
0 0 0 r
s
1 .556 0 r
.69938 .56836 m .7171 .60704 L .75764 .65348 L p F P
0 0 0 r
s
1 .146 0 r
.7171 .60704 m .69938 .56836 L .66391 .59116 L p F P
0 0 0 r
s
.024 0 1 r
.24641 .30872 m .26874 .3327 L .30206 .31978 L p F P
0 0 0 r
s
0 .377 1 r
.26874 .3327 m .24641 .30872 L .21327 .32178 L p F P
0 0 0 r
s
1 0 .804 r
.47549 1.03432 m .45556 1.01291 L .42255 .95406 L p F P
0 0 0 r
s
1 0 .907 r
.40237 .93168 m .42255 .95406 L .45556 1.01291 L p F P
0 0 0 r
s
0 1 .458 r
.80164 .83912 m .77926 .74336 L .7361 .66797 L p F P
0 0 0 r
s
0 1 .458 r
.7361 .66797 m .7563 .74575 L .80164 .83912 L p F P
0 0 0 r
s
0 1 .458 r
.85372 .33171 m .83871 .30771 L .80156 .32078 L p F P
0 0 0 r
s
0 1 .688 r
.61271 .70536 m .59563 .73035 L .56048 .82423 L p F P
0 0 0 r
s
0 1 .688 r
.56048 .82423 m .57886 .80054 L .61271 .70536 L p F P
0 0 0 r
s
1 0 .845 r
.33584 .30669 m .35708 .33072 L .39104 .31778 L p F P
0 0 0 r
s
.756 0 1 r
.35708 .33072 m .33584 .30669 L .30206 .31978 L p F P
0 0 0 r
s
1 0 .073 r
.42546 .30466 m .44561 .32874 L .4802 .31577 L p F P
0 0 0 r
s
1 0 .227 r
.44561 .32874 m .42546 .30466 L .39104 .31778 L p F P
0 0 0 r
s
0 .335 1 r
.38176 .90868 m .36071 .88505 L .33053 .81928 L p F P
0 0 0 r
s
0 .389 1 r
.30891 .80134 m .33053 .81928 L .36071 .88505 L p F P
0 0 0 r
s
1 0 .647 r
.51526 .30263 m .53432 .32676 L .56955 .31376 L p F P
0 0 0 r
s
1 0 .267 r
.53432 .32676 m .51526 .30263 L .4802 .31577 L p F P
0 0 0 r
s
1 .999 0 r
.66391 .59116 m .64771 .60203 L .61302 .67373 L p F P
0 0 0 r
s
1 .999 0 r
.62978 .64791 m .66391 .59116 L p .638 .6332 L F P
0 0 0 r
s
1 .999 0 r
.61302 .67373 m .6233 .65788 L p .638 .6332 L F P
0 0 0 r
s
1 .999 0 r
.6233 .65788 m .62978 .64791 L p .638 .6332 L F P
0 0 0 r
s
1 .297 0 r
.64771 .60203 m .66391 .59116 L .67735 .58252 L p F P
0 0 0 r
s
1 .297 0 r
.67735 .58252 m .69938 .56836 L p .66767 .58902 L F P
0 0 0 r
s
1 .297 0 r
.64771 .60203 m .67735 .58252 L .66767 .58902 L F
1 .838 0 r
.6827 .55438 m .66664 .56474 L .64503 .60422 L p F P
0 0 0 r
s
1 .297 0 r
.6827 .55438 m .64771 .60203 L p .66217 .5926 L F P
0 0 0 r
s
1 .838 0 r
.64771 .60203 m .6827 .55438 L p .65412 .59605 L F P
0 0 0 r
s
.201 1 0 r
.64771 .60203 m .63127 .62935 L .59546 .70766 L p F P
0 0 0 r
s
.201 1 0 r
.61302 .67373 m .64771 .60203 L p .61845 .66118 L F P
0 0 0 r
s
.201 1 0 r
.59546 .70766 m .60614 .68703 L p .61845 .66118 L F P
0 0 0 r
s
.201 1 0 r
.60614 .68703 m .61302 .67373 L p .61845 .66118 L F P
0 0 0 r
s
1 .838 0 r
.63127 .62935 m .63933 .61596 L p .64416 .60945 L F P
0 0 0 r
s
1 .838 0 r
.64187 .61391 m .64416 .60945 L .65412 .59605 L F
.63127 .62935 m .64416 .60945 L .64187 .61391 L F
.63933 .61596 m .64771 .60203 L p .65412 .59605 L F P
0 0 0 r
s
1 .838 0 r
.63893 .61819 m .65149 .59988 L .64585 .60367 L F
.65149 .59988 m .6827 .55438 L .64503 .60422 L F
.64503 .60422 m .63127 .62935 L p .63893 .61819 L F P
0 0 0 r
s
1 .838 0 r
.63893 .61819 m .64585 .60367 L .64503 .60422 L F
.306 1 0 r
.63127 .62935 m .66664 .56474 L p .6346 .62803 L F P
0 0 0 r
s
.306 1 0 r
.61415 .66842 m .6222 .65004 L p .6346 .62803 L F P
0 0 0 r
s
.306 1 0 r
.6222 .65004 m .63127 .62935 L p .6346 .62803 L F P
0 0 0 r
s
.306 1 0 r
.66664 .56474 m .65063 .59611 L .63112 .63477 L p F P
0 0 0 r
s
.306 1 0 r
.6346 .62803 m .66664 .56474 L .63112 .63477 L F
1 .297 0 r
.68419 .55563 m .6827 .55438 L p .66217 .5926 L F P
0 0 0 r
s
1 .161 0 r
.6827 .55438 m .69938 .56836 L .73753 .58172 L p F P
0 0 0 r
s
1 .161 0 r
.73753 .58172 m .71918 .5362 L .6827 .55438 L p F P
0 0 0 r
s
1 .26 0 r
.66664 .56474 m .6827 .55438 L .6924 .54955 L p F P
0 0 0 r
s
1 .26 0 r
.6924 .54955 m .71918 .5362 L p .68464 .55496 L F P
0 0 0 r
s
1 .26 0 r
.66664 .56474 m .6924 .54955 L .68464 .55496 L F
.67827 .55045 m .66664 .56474 L p .6718 .56193 L F P
0 0 0 r
s
1 .26 0 r
.70243 .52076 m .67271 .56144 L p .68464 .55496 L F P
0 0 0 r
s
1 .838 0 r
.66664 .56474 m .70243 .52076 L p .671 .56647 L F P
0 0 0 r
s
1 .838 0 r
.65063 .59611 m .65694 .58375 L p .671 .56647 L F P
0 0 0 r
s
1 .838 0 r
.65694 .58375 m .66664 .56474 L p .671 .56647 L F P
0 0 0 r
s
1 .838 0 r
.70243 .52076 m .68718 .53461 L p .66997 .56519 L F P
0 0 0 r
s
1 .838 0 r
.67365 .56262 m .70243 .52076 L .66997 .56519 L F
.68718 .53461 m .68676 .535 L p .66131 .58058 L F P
0 0 0 r
s
1 .26 0 r
.70695 .52492 m .70243 .52076 L p .68464 .55496 L F P
0 0 0 r
s
1 .161 0 r
.70243 .52076 m .71918 .5362 L .75835 .54863 L p F P
0 0 0 r
s
1 .161 0 r
.75835 .54863 m .73969 .50135 L .70243 .52076 L p F P
0 0 0 r
s
1 .297 0 r
.68676 .535 m .70243 .52076 L .7057 .51905 L p F P
0 0 0 r
s
1 .297 0 r
.7057 .51905 m .73969 .50135 L p .70159 .52557 L F P
0 0 0 r
s
1 .297 0 r
.68676 .535 m .7057 .51905 L .70159 .52557 L F
.72327 .49031 m .68676 .535 L p .70722 .52199 L F P
0 0 0 r
s
1 .999 0 r
.68676 .535 m .72327 .49031 L p .68892 .54591 L F P
0 0 0 r
s
1 .999 0 r
.6714 .57428 m .67623 .56192 L p .68892 .54591 L F P
0 0 0 r
s
1 .999 0 r
.67623 .56192 m .68676 .535 L p .68892 .54591 L F P
0 0 0 r
s
1 .999 0 r
.72327 .49031 m .70839 .51423 L .69394 .53769 L p F P
0 0 0 r
s
1 .999 0 r
.69689 .53302 m .72327 .49031 L .69394 .53769 L F
1 .297 0 r
.72957 .49454 m .72327 .49031 L p .70722 .52199 L F P
0 0 0 r
s
1 .146 0 r
.72327 .49031 m .73969 .50135 L .77946 .50754 L p F P
0 0 0 r
s
1 .146 0 r
.77946 .50754 m .76104 .46525 L .72327 .49031 L p F P
0 0 0 r
s
1 .435 0 r
.72327 .49031 m .76104 .46525 L p .71865 .50468 L F P
0 0 0 r
s
1 .435 0 r
.70839 .51423 m .71705 .5003 L p .71865 .50468 L F P
0 0 0 r
s
1 .435 0 r
.71705 .5003 m .72327 .49031 L p .71865 .50468 L F P
0 0 0 r
s
1 .435 0 r
.76104 .46525 m .7525 .4657 L p .72988 .49424 L F P
0 0 0 r
s
1 .435 0 r
.7525 .4657 m .74558 .46606 L p .72988 .49424 L F P
0 0 0 r
s
1 .297 0 r
.73969 .50135 m .72957 .49454 L p .70722 .52199 L F P
0 0 0 r
s
.643 1 0 r
.74558 .46606 m .7321 .50601 L .72384 .51895 L p F P
0 0 0 r
s
1 .26 0 r
.71918 .5362 m .70695 .52492 L p .68464 .55496 L F P
0 0 0 r
s
1 .297 0 r
.69938 .56836 m .68419 .55563 L p .66217 .5926 L F P
0 0 0 r
s
.643 1 0 r
.72384 .51895 m .69403 .56567 L p .72151 .51256 L F P
0 0 0 r
s
.643 1 0 r
.72151 .51256 m .74558 .46606 L .72384 .51895 L F
1 .435 0 r
.74558 .46606 m .70839 .51423 L p .72988 .49424 L F P
0 0 0 r
s
1 .999 0 r
.69394 .53769 m .6714 .57428 L p .69689 .53302 L F P
0 0 0 r
s
1 .838 0 r
.66131 .58058 m .67365 .56262 L .66997 .56519 L F
.68676 .535 m .65063 .59611 L p .66131 .58058 L F P
0 0 0 r
s
.306 1 0 r
.63112 .63477 m .61415 .66842 L p .6346 .62803 L F P
0 0 0 r
s
0 1 .976 r
.60525 .30059 m .62322 .32477 L .65908 .31175 L p F P
0 0 0 r
s
0 .162 1 r
.62322 .32477 m .60525 .30059 L .56955 .31376 L p F P
0 0 0 r
s
1 .435 0 r
.69544 .29855 m .7123 .32278 L .7488 .30973 L p F P
0 0 0 r
s
1 .999 0 r
.7123 .32278 m .69544 .29855 L .65908 .31175 L p F P
0 0 0 r
s
0 .553 1 r
.19012 .29753 m .21327 .32178 L .24641 .30872 L p F P
0 0 0 r
s
0 .851 1 r
.21327 .32178 m .19012 .29753 L .15717 .31074 L p F P
0 0 0 r
s
.974 1 0 r
.78581 .2965 m .80156 .32078 L .83871 .30771 L p F P
0 0 0 r
s
1 .403 0 r
.80156 .32078 m .78581 .2965 L .7488 .30973 L p F P
0 0 0 r
s
1 .556 0 r
.75764 .65348 m .73753 .58172 L .69938 .56836 L p F P
0 0 0 r
s
.404 0 1 r
.28 .29548 m .30206 .31978 L .33584 .30669 L p F P
0 0 0 r
s
.024 0 1 r
.30206 .31978 m .28 .29548 L .24641 .30872 L p F P
0 0 0 r
s
1 0 .517 r
.37008 .29343 m .39104 .31778 L .42546 .30466 L p F P
0 0 0 r
s
1 0 .845 r
.39104 .31778 m .37008 .29343 L .33584 .30669 L p F P
0 0 0 r
s
1 0 .061 r
.46035 .29137 m .4802 .31577 L .51526 .30263 L p F P
0 0 0 r
s
1 0 .073 r
.4802 .31577 m .46035 .29137 L .42546 .30466 L p F P
0 0 0 r
s
.818 0 1 r
.5508 .28931 m .56955 .31376 L .60525 .30059 L p F P
0 0 0 r
s
1 0 .647 r
.56955 .31376 m .5508 .28931 L .51526 .30263 L p F P
0 0 0 r
s
1 0 .907 r
.45556 1.01291 m .43522 .98995 L .40237 .93168 L p F P
0 0 0 r
s
.98 0 1 r
.38176 .90868 m .40237 .93168 L .43522 .98995 L p F P
0 0 0 r
s
0 1 .123 r
.64145 .28724 m .65908 .31175 L .69544 .29855 L p F P
0 0 0 r
s
0 1 .976 r
.65908 .31175 m .64145 .28724 L .60525 .30059 L p F P
0 0 0 r
s
0 1 .123 r
.62978 .64791 m .61302 .67373 L .57766 .75972 L p F P
0 0 0 r
s
0 1 .123 r
.57766 .75972 m .59563 .73035 L .62978 .64791 L p F P
0 0 0 r
s
0 .911 1 r
.13317 .28621 m .15717 .31074 L .19012 .29753 L p F P
0 0 0 r
s
1 .17 0 r
.73229 .28517 m .7488 .30973 L .78581 .2965 L p F P
0 0 0 r
s
1 .435 0 r
.7488 .30973 m .73229 .28517 L .69544 .29855 L p F P
0 0 0 r
s
0 .26 1 r
.22352 .28413 m .24641 .30872 L .28 .29548 L p F P
0 0 0 r
s
0 .553 1 r
.24641 .30872 m .22352 .28413 L .19012 .29753 L p F P
0 0 0 r
s
.974 1 0 r
.83871 .30771 m .82332 .2831 L .78581 .2965 L p F P
0 0 0 r
s
.756 0 1 r
.31406 .28206 m .33584 .30669 L .37008 .29343 L p F P
0 0 0 r
s
.404 0 1 r
.33584 .30669 m .31406 .28206 L .28 .29548 L p F P
0 0 0 r
s
1 0 .272 r
.40479 .27998 m .42546 .30466 L .46035 .29137 L p F P
0 0 0 r
s
1 0 .517 r
.42546 .30466 m .40479 .27998 L .37008 .29343 L p F P
0 0 0 r
s
1 0 .15 r
.45556 1.01291 m .47549 1.03432 L .51071 1.03383 L p F P
0 0 0 r
s
1 0 .429 r
.54621 .97012 m .52707 .97401 L .49089 1.02208 L p F P
0 0 0 r
s
1 0 .429 r
.49089 1.02208 m .51071 1.03383 L .54621 .97012 L p F P
0 0 0 r
s
0 .389 1 r
.36071 .88505 m .3392 .86077 L .30891 .80134 L p F P
0 0 0 r
s
0 .444 1 r
.28674 .78294 m .30891 .80134 L .3392 .86077 L p F P
0 0 0 r
s
1 0 .192 r
.49572 .27789 m .51526 .30263 L .5508 .28931 L p F P
0 0 0 r
s
1 0 .061 r
.51526 .30263 m .49572 .27789 L .46035 .29137 L p F P
0 0 0 r
s
.164 0 1 r
.58683 .2758 m .60525 .30059 L .64145 .28724 L p F P
0 0 0 r
s
.818 0 1 r
.60525 .30059 m .58683 .2758 L .5508 .28931 L p F P
0 0 0 r
s
.881 0 1 r
.56247 .88311 m .54367 .89846 L .50722 .97426 L p F P
0 0 0 r
s
.881 0 1 r
.50722 .97426 m .52707 .97401 L .56247 .88311 L p F P
0 0 0 r
s
.643 1 0 r
.67814 .2737 m .69544 .29855 L .73229 .28517 L p F P
0 0 0 r
s
0 1 .123 r
.69544 .29855 m .67814 .2737 L .64145 .28724 L p F P
0 0 0 r
s
0 .731 1 r
.16637 .27266 m .19012 .29753 L .22352 .28413 L p F P
0 0 0 r
s
0 .911 1 r
.19012 .29753 m .16637 .27266 L .13317 .28621 L p F P
0 0 0 r
s
1 .232 0 r
.76965 .27161 m .78581 .2965 L .82332 .2831 L p F P
0 0 0 r
s
1 .17 0 r
.78581 .2965 m .76965 .27161 L .73229 .28517 L p F P
0 0 0 r
s
.024 0 1 r
.25738 .27055 m .28 .29548 L .31406 .28206 L p F P
0 0 0 r
s
0 .26 1 r
.28 .29548 m .25738 .27055 L .22352 .28413 L p F P
0 0 0 r
s
.103 0 1 r
.57886 .80054 m .56048 .82423 L .524 .91065 L p F P
0 0 0 r
s
.103 0 1 r
.524 .91065 m .54367 .89846 L .57886 .80054 L p F P
0 0 0 r
s
1 0 .93 r
.34859 .26845 m .37008 .29343 L .40479 .27998 L p F P
0 0 0 r
s
.756 0 1 r
.37008 .29343 m .34859 .26845 L .31406 .28206 L p F P
0 0 0 r
s
.441 1 0 r
.8024 .72716 m .77941 .62751 L .73753 .58172 L p F P
0 0 0 r
s
.441 1 0 r
.73753 .58172 m .75764 .65348 L .8024 .72716 L p F P
0 0 0 r
s
1 .615 0 r
.71918 .5362 m .73753 .58172 L .77941 .62751 L p F P
0 0 0 r
s
1 0 .118 r
.43998 .26634 m .46035 .29137 L .49572 .27789 L p F P
0 0 0 r
s
1 0 .272 r
.46035 .29137 m .43998 .26634 L .40479 .27998 L p F P
0 0 0 r
s
.98 0 1 r
.43522 .98995 m .41447 .96545 L .38176 .90868 L p F P
0 0 0 r
s
.858 0 1 r
.36071 .88505 m .38176 .90868 L .41447 .96545 L p F P
0 0 0 r
s
1 0 .457 r
.53158 .26422 m .5508 .28931 L .58683 .2758 L p F P
0 0 0 r
s
1 0 .192 r
.5508 .28931 m .53158 .26422 L .49572 .27789 L p F P
0 0 0 r
s
0 .562 1 r
.62337 .2621 m .64145 .28724 L .67814 .2737 L p F P
0 0 0 r
s
.164 0 1 r
.64145 .28724 m .62337 .2621 L .58683 .2758 L p F P
0 0 0 r
s
0 .971 1 r
.10855 .26104 m .13317 .28621 L .16637 .27266 L p F P
0 0 0 r
s
1 0 .15 r
.51071 1.03383 m .49089 1.02208 L .45556 1.01291 L p F P
0 0 0 r
s
1 .745 0 r
.71535 .25998 m .73229 .28517 L .76965 .27161 L p F P
0 0 0 r
s
.643 1 0 r
.73229 .28517 m .71535 .25998 L .67814 .2737 L p F P
0 0 0 r
s
0 1 .792 r
.8261 .83101 m .8024 .72716 L .75764 .65348 L p F P
0 0 0 r
s
0 1 .792 r
.75764 .65348 m .77926 .74336 L .8261 .83101 L p F P
0 0 0 r
s
0 .553 1 r
.20004 .25892 m .22352 .28413 L .25738 .27055 L p F P
0 0 0 r
s
0 .731 1 r
.22352 .28413 m .20004 .25892 L .16637 .27266 L p F P
0 0 0 r
s
1 .232 0 r
.82332 .2831 m .80753 .25785 L .76965 .27161 L p F P
0 0 0 r
s
1 .615 0 r
.77941 .62751 m .75835 .54863 L .71918 .5362 L p F P
0 0 0 r
s
.297 0 1 r
.29172 .25679 m .31406 .28206 L .34859 .26845 L p F P
0 0 0 r
s
.024 0 1 r
.31406 .28206 m .29172 .25679 L .25738 .27055 L p F P
0 0 0 r
s
1 0 .183 r
.43522 .98995 m .45556 1.01291 L .49089 1.02208 L p F P
0 0 0 r
s
0 .562 1 r
.59563 .73035 m .57766 .75972 L .54111 .8464 L p F P
0 0 0 r
s
0 .562 1 r
.54111 .8464 m .56048 .82423 L .59563 .73035 L p F P
0 0 0 r
s
1 0 .658 r
.38359 .25465 m .40479 .27998 L .43998 .26634 L p F P
0 0 0 r
s
1 0 .93 r
.40479 .27998 m .38359 .25465 L .34859 .26845 L p F P
0 0 0 r
s
0 .444 1 r
.3392 .86077 m .31722 .83583 L .28674 .78294 L p F P
0 0 0 r
s
0 .5 1 r
.264 .76407 m .28674 .78294 L .31722 .83583 L p F P
0 0 0 r
s
1 0 .058 r
.47567 .25251 m .49572 .27789 L .53158 .26422 L p F P
0 0 0 r
s
1 0 .118 r
.49572 .27789 m .47567 .25251 L .43998 .26634 L p F P
0 0 0 r
s
1 0 .845 r
.56794 .25037 m .58683 .2758 L .62337 .2621 L p F P
0 0 0 r
s
1 0 .457 r
.58683 .2758 m .56794 .25037 L .53158 .26422 L p F P
0 0 0 r
s
0 1 .688 r
.66041 .24822 m .67814 .2737 L .71535 .25998 L p F P
0 0 0 r
s
0 .562 1 r
.67814 .2737 m .66041 .24822 L .62337 .2621 L p F P
0 0 0 r
s
0 .911 1 r
.14201 .24714 m .16637 .27266 L .20004 .25892 L p F P
0 0 0 r
s
0 .971 1 r
.16637 .27266 m .14201 .24714 L .10855 .26104 L p F P
0 0 0 r
s
1 .341 0 r
.75308 .24606 m .76965 .27161 L .80753 .25785 L p F P
0 0 0 r
s
1 .745 0 r
.76965 .27161 m .75308 .24606 L .71535 .25998 L p F P
0 0 0 r
s
0 .377 1 r
.23418 .24499 m .25738 .27055 L .29172 .25679 L p F P
0 0 0 r
s
0 .553 1 r
.25738 .27055 m .23418 .24499 L .20004 .25892 L p F P
0 0 0 r
s
.858 0 1 r
.41447 .96545 m .39332 .93944 L .36071 .88505 L p F P
0 0 0 r
s
.727 0 1 r
.3392 .86077 m .36071 .88505 L .39332 .93944 L p F P
0 0 0 r
s
.556 0 1 r
.32653 .24282 m .34859 .26845 L .38359 .25465 L p F P
0 0 0 r
s
.297 0 1 r
.34859 .26845 m .32653 .24282 L .29172 .25679 L p F P
0 0 0 r
s
1 0 .261 r
.52707 .97401 m .50722 .97426 L .47056 1.00726 L p F P
0 0 0 r
s
1 0 .261 r
.47056 1.00726 m .49089 1.02208 L .52707 .97401 L p F P
0 0 0 r
s
.054 0 1 r
.84867 .91908 m .8261 .83101 L .77926 .74336 L p F P
0 0 0 r
s
.054 0 1 r
.77926 .74336 m .80164 .83912 L .84867 .91908 L p F P
0 0 0 r
s
1 0 .433 r
.41909 .24066 m .43998 .26634 L .47567 .25251 L p F P
0 0 0 r
s
1 0 .658 r
.43998 .26634 m .41909 .24066 L .38359 .25465 L p F P
0 0 0 r
s
1 0 .094 r
.51185 .23849 m .53158 .26422 L .56794 .25037 L p F P
0 0 0 r
s
1 0 .058 r
.53158 .26422 m .51185 .23849 L .47567 .25251 L p F P
0 0 0 r
s
.667 0 1 r
.60481 .23631 m .62337 .2621 L .66041 .24822 L p F P
0 0 0 r
s
1 0 .845 r
.62337 .2621 m .60481 .23631 L .56794 .25037 L p F P
0 0 0 r
s
1 0 .183 r
.49089 1.02208 m .47056 1.00726 L .43522 .98995 L p F P
0 0 0 r
s
1 0 .245 r
.41447 .96545 m .43522 .98995 L .47056 1.00726 L p F P
0 0 0 r
s
.032 1 0 r
.69797 .23414 m .71535 .25998 L .75308 .24606 L p F P
0 0 0 r
s
0 1 .688 r
.71535 .25998 m .69797 .23414 L .66041 .24822 L p F P
0 0 0 r
s
0 .851 1 r
.17595 .23304 m .20004 .25892 L .23418 .24499 L p F P
0 0 0 r
s
0 .911 1 r
.20004 .25892 m .17595 .23304 L .14201 .24714 L p F P
0 0 0 r
s
1 .341 0 r
.80753 .25785 m .79134 .23195 L .75308 .24606 L p F P
0 0 0 r
s
0 1 .976 r
.61302 .67373 m .59546 .70766 L .55864 .78991 L p F P
0 0 0 r
s
0 1 .976 r
.55864 .78991 m .57766 .75972 L .61302 .67373 L p F P
0 0 0 r
s
0 .204 1 r
.26879 .23086 m .29172 .25679 L .32653 .24282 L p F P
0 0 0 r
s
0 .377 1 r
.29172 .25679 m .26879 .23086 L .23418 .24499 L p F P
0 0 0 r
s
1 0 .747 r
.54367 .89846 m .524 .91065 L .4867 .97021 L p F P
0 0 0 r
s
1 0 .747 r
.4867 .97021 m .50722 .97426 L .54367 .89846 L p F P
0 0 0 r
s
.798 0 1 r
.36184 .22867 m .38359 .25465 L .41909 .24066 L p F P
0 0 0 r
s
.556 0 1 r
.38359 .25465 m .36184 .22867 L .32653 .24282 L p F P
0 0 0 r
s
.441 1 0 r
.82536 .6958 m .80111 .58864 L .75835 .54863 L p F P
0 0 0 r
s
.441 1 0 r
.75835 .54863 m .77941 .62751 L .82536 .6958 L p F P
0 0 0 r
s
1 .556 0 r
.73969 .50135 m .75835 .54863 L .80111 .58864 L p F P
0 0 0 r
s
0 .5 1 r
.31722 .83583 m .29476 .81024 L .264 .76407 L p F P
0 0 0 r
s
0 .557 1 r
.24067 .7447 m .264 .76407 L .29476 .81024 L p F P
0 0 0 r
s
1 0 .262 r
.45509 .22647 m .47567 .25251 L .51185 .23849 L p F P
0 0 0 r
s
1 0 .433 r
.47567 .25251 m .45509 .22647 L .41909 .24066 L p F P
0 0 0 r
s
1 0 .225 r
.54855 .22427 m .56794 .25037 L .60481 .23631 L p F P
0 0 0 r
s
1 0 .094 r
.56794 .25037 m .54855 .22427 L .51185 .23849 L p F P
0 0 0 r
s
.727 0 1 r
.39332 .93944 m .37175 .91194 L .3392 .86077 L p F P
0 0 0 r
s
.589 0 1 r
.31722 .83583 m .3392 .86077 L .37175 .91194 L p F P
0 0 0 r
s
.103 0 1 r
.64221 .22206 m .66041 .24822 L .69797 .23414 L p F P
0 0 0 r
s
.667 0 1 r
.66041 .24822 m .64221 .22206 L .60481 .23631 L p F P
0 0 0 r
s
.676 1 0 r
.73607 .21985 m .75308 .24606 L .79134 .23195 L p F P
0 0 0 r
s
.032 1 0 r
.75308 .24606 m .73607 .21985 L .69797 .23414 L p F P
0 0 0 r
s
0 .791 1 r
.21036 .21875 m .23418 .24499 L .26879 .23086 L p F P
0 0 0 r
s
0 .851 1 r
.23418 .24499 m .21036 .21875 L .17595 .23304 L p F P
0 0 0 r
s
.667 0 1 r
.56048 .82423 m .54111 .8464 L .50349 .91822 L p F P
0 0 0 r
s
.667 0 1 r
.50349 .91822 m .524 .91065 L .56048 .82423 L p F P
0 0 0 r
s
1 .556 0 r
.80111 .58864 m .77946 .50754 L .73969 .50135 L p F P
0 0 0 r
s
0 .035 1 r
.3039 .21653 m .32653 .24282 L .36184 .22867 L p F P
0 0 0 r
s
0 .204 1 r
.32653 .24282 m .3039 .21653 L .26879 .23086 L p F P
0 0 0 r
s
0 1 .904 r
.8505 .80816 m .82536 .6958 L .77941 .62751 L p F P
0 0 0 r
s
0 1 .904 r
.77941 .62751 m .8024 .72716 L .8505 .80816 L p F P
0 0 0 r
s
1 0 .981 r
.39765 .21431 m .41909 .24066 L .45509 .22647 L p F P
0 0 0 r
s
.798 0 1 r
.41909 .24066 m .39765 .21431 L .36184 .22867 L p F P
0 0 0 r
s
1 0 .245 r
.47056 1.00726 m .44974 .98926 L .41447 .96545 L p F P
0 0 0 r
s
1 0 .337 r
.39332 .93944 m .41447 .96545 L .44974 .98926 L p F P
0 0 0 r
s
1 0 .146 r
.49161 .21208 m .51185 .23849 L .54855 .22427 L p F P
0 0 0 r
s
1 0 .262 r
.51185 .23849 m .49161 .21208 L .45509 .22647 L p F P
0 0 0 r
s
1 0 .446 r
.58577 .20985 m .60481 .23631 L .64221 .22206 L p F P
0 0 0 r
s
1 0 .225 r
.60481 .23631 m .58577 .20985 L .54855 .22427 L p F P
0 0 0 r
s
0 .509 1 r
.68014 .20761 m .69797 .23414 L .73607 .21985 L p F P
0 0 0 r
s
.103 0 1 r
.69797 .23414 m .68014 .20761 L .64221 .22206 L p F P
0 0 0 r
s
1 0 .147 r
.44974 .98926 m .47056 1.00726 L .50722 .97426 L p F P
0 0 0 r
s
.676 1 0 r
.79134 .23195 m .77471 .20537 L .73607 .21985 L p F P
0 0 0 r
s
1 0 .147 r
.50722 .97426 m .4867 .97021 L .44974 .98926 L p F P
0 0 0 r
s
0 .732 1 r
.24527 .20424 m .26879 .23086 L .3039 .21653 L p F P
0 0 0 r
s
0 .791 1 r
.26879 .23086 m .24527 .20424 L .21036 .21875 L p F P
0 0 0 r
s
.13 0 1 r
.33952 .202 m .36184 .22867 L .39765 .21431 L p F P
0 0 0 r
s
0 .035 1 r
.36184 .22867 m .33952 .202 L .3039 .21653 L p F P
0 0 0 r
s
0 .557 1 r
.29476 .81024 m .2718 .78399 L .24067 .7447 L p F P
0 0 0 r
s
0 .615 1 r
.21672 .72483 m .24067 .7447 L .2718 .78399 L p F P
0 0 0 r
s
1 0 .782 r
.43398 .19974 m .45509 .22647 L .49161 .21208 L p F P
0 0 0 r
s
1 0 .981 r
.45509 .22647 m .43398 .19974 L .39765 .21431 L p F P
0 0 0 r
s
.589 0 1 r
.37175 .91194 m .34979 .883 L .31722 .83583 L p F P
0 0 0 r
s
.442 0 1 r
.29476 .81024 m .31722 .83583 L .34979 .883 L p F P
0 0 0 r
s
0 .162 1 r
.53847 .81687 m .55864 .78991 L .58943 .72113 L p F P
0 0 0 r
s
0 .162 1 r
.58943 .72113 m .59546 .70766 L p .58287 .73179 L F P
0 0 0 r
s
0 .162 1 r
.53847 .81687 m .58943 .72113 L .58287 .73179 L F
.57681 .74483 m .53847 .81687 L p .58287 .73179 L F P
0 0 0 r
s
0 .162 1 r
.59546 .70766 m .57681 .74483 L p .58287 .73179 L F P
0 0 0 r
s
.631 0 1 r
.53847 .81687 m .57681 .74483 L p .545 .79365 L F P
0 0 0 r
s
.631 0 1 r
.51717 .83637 m .52497 .82923 L p .545 .79365 L F P
0 0 0 r
s
.631 0 1 r
.52497 .82923 m .53847 .81687 L p .545 .79365 L F P
0 0 0 r
s
.631 0 1 r
.57681 .74483 m .55689 .77934 L .52859 .81997 L p F P
0 0 0 r
s
.631 0 1 r
.54122 .79946 m .57681 .74483 L .52859 .81997 L F
0 1 .744 r
.57681 .74483 m .59546 .70766 L .63127 .62935 L p F P
0 0 0 r
s
0 1 .744 r
.63127 .62935 m .61415 .66842 L .57681 .74483 L p F P
0 0 0 r
s
0 .274 1 r
.55689 .77934 m .57681 .74483 L .60623 .68461 L p F P
0 0 0 r
s
0 .274 1 r
.60623 .68461 m .61415 .66842 L p .59906 .69764 L F P
0 0 0 r
s
0 .274 1 r
.55689 .77934 m .60623 .68461 L .59906 .69764 L F
.59591 .7125 m .56794 .76042 L p .59906 .69764 L F P
0 0 0 r
s
0 .274 1 r
.56794 .76042 m .55689 .77934 L p .5856 .72373 L F P
0 0 0 r
s
0 .274 1 r
.5856 .72373 m .59906 .69764 L .56794 .76042 L F
.631 0 1 r
.52859 .81997 m .51717 .83637 L p .54122 .79946 L F P
0 0 0 r
s
1 0 .718 r
.49484 .84446 m .51717 .83637 L .53944 .8044 L p F P
0 0 0 r
s
1 0 .718 r
.53944 .8044 m .55689 .77934 L p .5276 .81008 L F P
0 0 0 r
s
1 0 .718 r
.49484 .84446 m .53944 .8044 L .5276 .81008 L F
.53567 .80484 m .49484 .84446 L p .5276 .81008 L F P
0 0 0 r
s
1 0 .718 r
.55689 .77934 m .53567 .80484 L p .5276 .81008 L F P
0 0 0 r
s
1 0 .267 r
.53567 .80484 m .51325 .81535 L .48824 .82897 L p F P
0 0 0 r
s
1 0 .267 r
.48824 .82897 m .4717 .83798 L p .49976 .82345 L F P
0 0 0 r
s
1 0 .267 r
.49976 .82345 m .53567 .80484 L .48824 .82897 L F
.631 0 1 r
.53567 .80484 m .55689 .77934 L .58003 .7397 L p F P
0 0 0 r
s
.631 0 1 r
.58003 .7397 m .59591 .7125 L p .56976 .75259 L F P
0 0 0 r
s
.631 0 1 r
.53567 .80484 m .58003 .7397 L .56976 .75259 L F
.59591 .7125 m .57626 .75322 L .55033 .7862 L p F P
0 0 0 r
s
.631 0 1 r
.55033 .7862 m .53567 .80484 L p .56379 .76173 L F P
0 0 0 r
s
.631 0 1 r
.56379 .76173 m .59591 .7125 L .55033 .7862 L F
1 0 .647 r
.53567 .80484 m .57626 .75322 L p .53525 .79366 L F P
0 0 0 r
s
1 0 .647 r
.51325 .81535 m .51913 .8126 L p .53525 .79366 L F P
0 0 0 r
s
1 0 .647 r
.51913 .8126 m .53567 .80484 L p .53525 .79366 L F P
0 0 0 r
s
1 0 .647 r
.57626 .75322 m .5551 .78147 L .5315 .80058 L p F P
0 0 0 r
s
1 0 .647 r
.5435 .78553 m .57626 .75322 L .5315 .80058 L F
0 .162 1 r
.63404 .64212 m .61625 .69332 L .57626 .75322 L p F P
0 0 0 r
s
0 .162 1 r
.57626 .75322 m .59591 .7125 L .63404 .64212 L p F P
0 0 0 r
s
.818 0 1 r
.5551 .78147 m .57626 .75322 L .59299 .72816 L p F P
0 0 0 r
s
.818 0 1 r
.59299 .72816 m .61625 .69332 L p .58388 .73998 L F P
0 0 0 r
s
.818 0 1 r
.5551 .78147 m .59299 .72816 L .58388 .73998 L F
.59684 .73787 m .5551 .78147 L p .5968 .72136 L F P
0 0 0 r
s
.164 0 1 r
.57766 .75972 m .55864 .78991 L .52073 .86445 L p F P
0 0 0 r
s
.164 0 1 r
.52073 .86445 m .54111 .8464 L .57766 .75972 L p F P
0 0 0 r
s
1 0 .457 r
.5551 .78147 m .59684 .73787 L p .55081 .77446 L F P
0 0 0 r
s
1 0 .457 r
.53257 .78897 m .53706 .78747 L p .55081 .77446 L F P
0 0 0 r
s
1 0 .457 r
.53706 .78747 m .5551 .78147 L p .55081 .77446 L F P
0 0 0 r
s
1 0 .457 r
.59684 .73787 m .57565 .76329 L .55765 .77402 L p F P
0 0 0 r
s
1 0 .457 r
.56758 .76114 m .59684 .73787 L .55765 .77402 L F
.818 0 1 r
.61163 .70395 m .59684 .73787 L p .5968 .72136 L F P
0 0 0 r
s
.164 0 1 r
.65549 .62939 m .63819 .68675 L .59684 .73787 L p F P
0 0 0 r
s
.164 0 1 r
.59684 .73787 m .61625 .69332 L .65549 .62939 L p F P
0 0 0 r
s
1 0 .845 r
.57565 .76329 m .59684 .73787 L .63819 .68675 L p F P
0 0 0 r
s
1 0 .845 r
.61888 .72986 m .57565 .76329 L p .62002 .70899 L F P
0 0 0 r
s
1 0 .845 r
.63819 .68675 m .63427 .69551 L p .62002 .70899 L F P
0 0 0 r
s
1 0 .845 r
.63427 .69551 m .61888 .72986 L p .62002 .70899 L F P
0 0 0 r
s
1 0 .457 r
.55765 .77402 m .53257 .78897 L p .56758 .76114 L F P
0 0 0 r
s
.818 0 1 r
.61625 .69332 m .61163 .70395 L p .5968 .72136 L F P
0 0 0 r
s
1 0 .647 r
.5315 .80058 m .51325 .81535 L p .5435 .78553 L F P
0 0 0 r
s
0 .274 1 r
.61415 .66842 m .61035 .6776 L p .59906 .69764 L F P
0 0 0 r
s
0 .274 1 r
.61035 .6776 m .59591 .7125 L p .59906 .69764 L F P
0 0 0 r
s
1 0 .088 r
.52865 .19748 m .54855 .22427 L .58577 .20985 L p F P
0 0 0 r
s
1 0 .146 r
.54855 .22427 m .52865 .19748 L .49161 .21208 L p F P
0 0 0 r
s
1 0 .747 r
.62352 .19522 m .64221 .22206 L .68014 .20761 L p F P
0 0 0 r
s
1 0 .446 r
.64221 .22206 m .62352 .19522 L .58577 .20985 L p F P
0 0 0 r
s
0 1 .862 r
.71861 .19295 m .73607 .21985 L .77471 .20537 L p F P
0 0 0 r
s
0 .509 1 r
.73607 .21985 m .71861 .19295 L .68014 .20761 L p F P
0 0 0 r
s
1 0 .337 r
.44974 .98926 m .42847 .96804 L .39332 .93944 L p F P
0 0 0 r
s
1 0 .458 r
.37175 .91194 m .39332 .93944 L .42847 .96804 L p F P
0 0 0 r
s
.259 0 1 r
.87398 .90008 m .8505 .80816 L .8024 .72716 L p F P
0 0 0 r
s
.259 0 1 r
.8024 .72716 m .8261 .83101 L .87398 .90008 L p F P
0 0 0 r
s
.63 1 0 r
.84783 .64876 m .82258 .5375 L .77946 .50754 L p F P
0 0 0 r
s
.63 1 0 r
.77946 .50754 m .80111 .58864 L .84783 .64876 L p F P
0 0 0 r
s
1 .403 0 r
.76104 .46525 m .77946 .50754 L .82258 .5375 L p F P
0 0 0 r
s
0 .673 1 r
.28067 .18953 m .3039 .21653 L .33952 .202 L p F P
0 0 0 r
s
0 .732 1 r
.3039 .21653 m .28067 .18953 L .24527 .20424 L p F P
0 0 0 r
s
.289 0 1 r
.37564 .18725 m .39765 .21431 L .43398 .19974 L p F P
0 0 0 r
s
.13 0 1 r
.39765 .21431 m .37564 .18725 L .33952 .202 L p F P
0 0 0 r
s
1 0 .446 r
.524 .91065 m .50349 .91822 L .46556 .96134 L p F P
0 0 0 r
s
1 0 .446 r
.46556 .96134 m .4867 .97021 L .524 .91065 L p F P
0 0 0 r
s
1 0 .607 r
.47083 .18497 m .49161 .21208 L .52865 .19748 L p F P
0 0 0 r
s
1 0 .782 r
.49161 .21208 m .47083 .18497 L .43398 .19974 L p F P
0 0 0 r
s
1 0 .088 r
.56622 .18267 m .58577 .20985 L .62352 .19522 L p F P
0 0 0 r
s
1 0 .088 r
.58577 .20985 m .56622 .18267 L .52865 .19748 L p F P
0 0 0 r
s
.881 0 1 r
.66182 .18038 m .68014 .20761 L .71861 .19295 L p F P
0 0 0 r
s
1 0 .747 r
.68014 .20761 m .66182 .18038 L .62352 .19522 L p F P
0 0 0 r
s
1 0 .088 r
.42847 .96804 m .44974 .98926 L .4867 .97021 L p F P
0 0 0 r
s
0 1 .862 r
.77471 .20537 m .75764 .17807 L .71861 .19295 L p F P
0 0 0 r
s
0 1 .792 r
.87461 .77057 m .84783 .64876 L .80111 .58864 L p F P
0 0 0 r
s
0 1 .792 r
.80111 .58864 m .82536 .6958 L .87461 .77057 L p F P
0 0 0 r
s
.442 0 1 r
.34979 .883 m .32742 .85267 L .29476 .81024 L p F P
0 0 0 r
s
.289 0 1 r
.2718 .78399 m .29476 .81024 L .32742 .85267 L p F P
0 0 0 r
s
1 .403 0 r
.82258 .5375 m .80098 .46111 L .76104 .46525 L p F P
0 0 0 r
s
1 .17 0 r
.74558 .46606 m .76104 .46525 L .80098 .46111 L p F P
0 0 0 r
s
.201 1 0 r
.68676 .535 m .6714 .57428 L .63404 .64212 L p F P
0 0 0 r
s
.201 1 0 r
.63404 .64212 m .65063 .59611 L .68676 .535 L p F P
0 0 0 r
s
0 .615 1 r
.3166 .17461 m .33952 .202 L .37564 .18725 L p F P
0 0 0 r
s
0 .673 1 r
.33952 .202 m .3166 .17461 L .28067 .18953 L p F P
0 0 0 r
s
0 .615 1 r
.2718 .78399 m .24833 .75705 L .21672 .72483 L p F P
0 0 0 r
s
0 .673 1 r
.19212 .70442 m .21672 .72483 L .24833 .75705 L p F P
0 0 0 r
s
.442 0 1 r
.4123 .1723 m .43398 .19974 L .47083 .18497 L p F P
0 0 0 r
s
.289 0 1 r
.43398 .19974 m .4123 .1723 L .37564 .18725 L p F P
0 0 0 r
s
1 0 .458 r
.42847 .96804 m .40676 .94358 L .37175 .91194 L p F P
0 0 0 r
s
1 0 .607 r
.34979 .883 m .37175 .91194 L .40676 .94358 L p F P
0 0 0 r
s
1 0 .088 r
.4867 .97021 m .46556 .96134 L .42847 .96804 L p F P
0 0 0 r
s
1 0 .458 r
.50821 .16997 m .52865 .19748 L .56622 .18267 L p F P
0 0 0 r
s
1 0 .607 r
.52865 .19748 m .50821 .16997 L .47083 .18497 L p F P
0 0 0 r
s
1 0 .147 r
.60434 .16765 m .62352 .19522 L .66182 .18038 L p F P
0 0 0 r
s
1 0 .088 r
.62352 .19522 m .60434 .16765 L .56622 .18267 L p F P
0 0 0 r
s
.452 0 1 r
.70068 .16532 m .71861 .19295 L .75764 .17807 L p F P
0 0 0 r
s
.881 0 1 r
.71861 .19295 m .70068 .16532 L .66182 .18038 L p F P
0 0 0 r
s
1 0 .845 r
.54111 .8464 m .52073 .86445 L .48218 .91977 L p F P
0 0 0 r
s
1 0 .845 r
.48218 .91977 m .50349 .91822 L .54111 .8464 L p F P
0 0 0 r
s
1 0 .709 r
.89316 .94925 m .87398 .90008 L .8261 .83101 L p F P
0 0 0 r
s
1 0 .709 r
.8261 .83101 m .84867 .91908 L .89316 .94925 L p F P
0 0 0 r
s
0 .557 1 r
.35304 .15947 m .37564 .18725 L .4123 .1723 L p F P
0 0 0 r
s
0 .615 1 r
.37564 .18725 m .35304 .15947 L .3166 .17461 L p F P
0 0 0 r
s
.589 0 1 r
.44948 .15712 m .47083 .18497 L .50821 .16997 L p F P
0 0 0 r
s
.442 0 1 r
.47083 .18497 m .44948 .15712 L .4123 .1723 L p F P
0 0 0 r
s
0 1 .744 r
.65063 .59611 m .63404 .64212 L .59591 .7125 L p F P
0 0 0 r
s
0 1 .744 r
.59591 .7125 m .61415 .66842 L .65063 .59611 L p F P
0 0 0 r
s
1 0 .337 r
.54614 .15476 m .56622 .18267 L .60434 .16765 L p F P
0 0 0 r
s
1 0 .458 r
.56622 .18267 m .54614 .15476 L .50821 .16997 L p F P
0 0 0 r
s
.974 1 0 r
.86953 .5864 m .84391 .47729 L .80098 .46111 L p F P
0 0 0 r
s
.974 1 0 r
.80098 .46111 m .82258 .5375 L .86953 .5864 L p F P
0 0 0 r
s
1 .232 0 r
.78369 .43259 m .80098 .46111 L .84391 .47729 L p F P
0 0 0 r
s
1 .17 0 r
.80098 .46111 m .78369 .43259 L .74558 .46606 L p F P
0 0 0 r
s
1 0 .088 r
.40676 .94358 m .42847 .96804 L .46556 .96134 L p F P
0 0 0 r
s
.289 0 1 r
.32742 .85267 m .30465 .82099 L .2718 .78399 L p F P
0 0 0 r
s
.13 0 1 r
.24833 .75705 m .2718 .78399 L .30465 .82099 L p F P
0 0 0 r
s
1 0 .261 r
.64302 .1524 m .66182 .18038 L .70068 .16532 L p F P
0 0 0 r
s
1 0 .147 r
.66182 .18038 m .64302 .1524 L .60434 .16765 L p F P
0 0 0 r
s
.452 0 1 r
.75764 .17807 m .74011 .15004 L .70068 .16532 L p F P
0 0 0 r
s
1 0 .607 r
.40676 .94358 m .38466 .91594 L .34979 .883 L p F P
0 0 0 r
s
1 0 .782 r
.32742 .85267 m .34979 .883 L .38466 .91594 L p F P
0 0 0 r
s
1 0 .23 r
.90306 .90582 m .90134 .91336 L .9312 .91137 L F
.90907 .93341 m .9312 .91137 L p .90134 .91336 L F P
0 0 0 r
s
1 0 .23 r
.87398 .90008 m .88375 .92512 L p .90306 .90582 L F P
0 0 0 r
s
1 0 .23 r
.88375 .92512 m .89316 .94925 L p .90306 .90582 L F P
0 0 0 r
s
1 0 .23 r
.91902 .92167 m .87398 .90008 L p .89806 .90483 L F P
0 0 0 r
s
1 0 .23 r
.9312 .91137 m .91902 .92167 L p .89806 .90483 L F P
0 0 0 r
s
1 0 .646 r
.91902 .92167 m .89952 .87104 L .87089 .83431 L p F P
0 0 0 r
s
1 0 .646 r
.87089 .83431 m .8505 .80816 L p .879 .85537 L F P
0 0 0 r
s
1 0 .646 r
.879 .85537 m .91902 .92167 L .87089 .83431 L F
1 0 .23 r
.89316 .94925 m .90907 .93341 L p .90134 .91336 L F P
0 0 0 r
s
1 0 .659 r
.91902 .92167 m .9312 .91137 L p .93213 .90851 L F P
0 0 0 r
s
1 0 .659 r
.94104 .86788 m .94437 .87082 L .96181 .81712 L p F P
0 0 0 r
s
1 0 .659 r
.95783 .88273 m .91902 .92167 L p .94104 .86788 L F P
0 0 0 r
s
1 0 .659 r
.96181 .81712 m .95987 .84906 L p .94104 .86788 L F P
0 0 0 r
s
1 0 .659 r
.95987 .84906 m .95783 .88273 L p .94104 .86788 L F P
0 0 0 r
s
.259 0 1 r
.89952 .87104 m .87461 .77057 L .82536 .6958 L p F P
0 0 0 r
s
.259 0 1 r
.82536 .6958 m .8505 .80816 L .89952 .87104 L p F P
0 0 0 r
s
0 1 .458 r
.89801 .71712 m .86953 .5864 L .82258 .5375 L p F P
0 0 0 r
s
0 1 .458 r
.82258 .5375 m .84783 .64876 L .89801 .71712 L p F P
0 0 0 r
s
0 .673 1 r
.24833 .75705 m .22432 .72943 L .19212 .70442 L p F P
0 0 0 r
s
0 .732 1 r
.16686 .68346 m .19212 .70442 L .22432 .72943 L p F P
0 0 0 r
s
0 .5 1 r
.39002 .1441 m .4123 .1723 L .44948 .15712 L p F P
0 0 0 r
s
0 .557 1 r
.4123 .1723 m .39002 .1441 L .35304 .15947 L p F P
0 0 0 r
s
1 0 .225 r
.50349 .91822 m .48218 .91977 L .44385 .94724 L p F P
0 0 0 r
s
1 0 .225 r
.44385 .94724 m .46556 .96134 L .50349 .91822 L p F P
0 0 0 r
s
.727 0 1 r
.48722 .14172 m .50821 .16997 L .54614 .15476 L p F P
0 0 0 r
s
.589 0 1 r
.50821 .16997 m .48722 .14172 L .44948 .15712 L p F P
0 0 0 r
s
1 0 .245 r
.58463 .13933 m .60434 .16765 L .64302 .1524 L p F P
0 0 0 r
s
1 0 .337 r
.60434 .16765 m .58463 .13933 L .54614 .15476 L p F P
0 0 0 r
s
.818 0 1 r
.55864 .78991 m .53847 .81687 L .49939 .87578 L p F P
0 0 0 r
s
.818 0 1 r
.49939 .87578 m .52073 .86445 L .55864 .78991 L p F P
0 0 0 r
s
1 0 .429 r
.68227 .13694 m .70068 .16532 L .74011 .15004 L p F P
0 0 0 r
s
1 0 .261 r
.70068 .16532 m .68227 .13694 L .64302 .1524 L p F P
0 0 0 r
s
1 0 .088 r
.46556 .96134 m .44385 .94724 L .40676 .94358 L p F P
0 0 0 r
s
1 .745 0 r
.7321 .50601 m .74558 .46606 L .78369 .43259 L p F P
0 0 0 r
s
.643 1 0 r
.69403 .56567 m .70839 .51423 L .74558 .46606 L p F P
0 0 0 r
s
1 0 .146 r
.38466 .91594 m .40676 .94358 L .44385 .94724 L p F P
0 0 0 r
s
1 .232 0 r
.84391 .47729 m .8235 .41539 L .78369 .43259 L p F P
0 0 0 r
s
.676 1 0 r
.79795 .46014 m .75867 .51484 L p .78889 .45205 L F P
0 0 0 r
s
1 .341 0 r
.78369 .43259 m .8235 .41539 L p .77862 .44756 L F P
0 0 0 r
s
1 .341 0 r
.77011 .45366 m .77505 .446 L p .77862 .44756 L F P
0 0 0 r
s
1 .341 0 r
.77505 .446 m .78369 .43259 L p .77862 .44756 L F P
0 0 0 r
s
1 .341 0 r
.8235 .41539 m .8086 .4111 L .77011 .45366 L p F P
0 0 0 r
s
.676 1 0 r
.8086 .4111 m .79877 .45637 L p .78889 .45205 L F P
0 0 0 r
s
.676 1 0 r
.79877 .45637 m .79795 .46014 L p .78889 .45205 L F P
0 0 0 r
s
1 .745 0 r
.78369 .43259 m .77011 .45366 L .7321 .50601 L p F P
0 0 0 r
s
.13 0 1 r
.30465 .82099 m .28147 .78805 L .24833 .75705 L p F P
0 0 0 r
s
0 .035 1 r
.22432 .72943 m .24833 .75705 L .28147 .78805 L p F P
0 0 0 r
s
0 .444 1 r
.42755 .12851 m .44948 .15712 L .48722 .14172 L p F P
0 0 0 r
s
0 .5 1 r
.44948 .15712 m .42755 .12851 L .39002 .1441 L p F P
0 0 0 r
s
1 0 .782 r
.38466 .91594 m .3622 .88522 L .32742 .85267 L p F P
0 0 0 r
s
1 0 .981 r
.30465 .82099 m .32742 .85267 L .3622 .88522 L p F P
0 0 0 r
s
.858 0 1 r
.52551 .12609 m .54614 .15476 L .58463 .13933 L p F P
0 0 0 r
s
.727 0 1 r
.54614 .15476 m .52551 .12609 L .48722 .14172 L p F P
0 0 0 r
s
1 0 .183 r
.62369 .12367 m .64302 .1524 L .68227 .13694 L p F P
0 0 0 r
s
1 0 .245 r
.64302 .1524 m .62369 .12367 L .58463 .13933 L p F P
0 0 0 r
s
1 0 .429 r
.74011 .15004 m .7221 .12124 L .68227 .13694 L p F P
0 0 0 r
s
0 1 .123 r
.70839 .51423 m .69403 .56567 L .65549 .62939 L p F P
0 0 0 r
s
0 1 .123 r
.65549 .62939 m .6714 .57428 L .70839 .51423 L p F P
0 0 0 r
s
1 0 .646 r
.8505 .80816 m .87398 .90008 L .91902 .92167 L p F P
0 0 0 r
s
0 .732 1 r
.22432 .72943 m .19977 .70111 L .16686 .68346 L p F P
0 0 0 r
s
0 .791 1 r
.1409 .66192 m .16686 .68346 L .19977 .70111 L p F P
0 0 0 r
s
1 0 .457 r
.52073 .86445 m .49939 .87578 L .46017 .91416 L p F P
0 0 0 r
s
1 0 .457 r
.46017 .91416 m .48218 .91977 L .52073 .86445 L p F P
0 0 0 r
s
.054 0 1 r
.92509 .83153 m .89801 .71712 L .84783 .64876 L p F P
0 0 0 r
s
.054 0 1 r
.84783 .64876 m .87461 .77057 L .92509 .83153 L p F P
0 0 0 r
s
0 .389 1 r
.46565 .11269 m .48722 .14172 L .52551 .12609 L p F P
0 0 0 r
s
0 .444 1 r
.48722 .14172 m .46565 .11269 L .42755 .12851 L p F P
0 0 0 r
s
.98 0 1 r
.56438 .11023 m .58463 .13933 L .62369 .12367 L p F P
0 0 0 r
s
.858 0 1 r
.58463 .13933 m .56438 .11023 L .52551 .12609 L p F P
0 0 0 r
s
1 0 .15 r
.66334 .10777 m .68227 .13694 L .7221 .12124 L p F P
0 0 0 r
s
1 0 .183 r
.68227 .13694 m .66334 .10777 L .62369 .12367 L p F P
0 0 0 r
s
1 0 .981 r
.3622 .88522 m .33941 .85156 L .30465 .82099 L p F P
0 0 0 r
s
.798 0 1 r
.28147 .78805 m .30465 .82099 L .33941 .85156 L p F P
0 0 0 r
s
1 0 .146 r
.44385 .94724 m .42165 .92763 L .38466 .91594 L p F P
0 0 0 r
s
1 0 .262 r
.3622 .88522 m .38466 .91594 L .42165 .92763 L p F P
0 0 0 r
s
1 0 .094 r
.42165 .92763 m .44385 .94724 L .48218 .91977 L p F P
0 0 0 r
s
0 .035 1 r
.28147 .78805 m .25787 .75389 L .22432 .72943 L p F P
0 0 0 r
s
0 .204 1 r
.19977 .70111 m .22432 .72943 L .25787 .75389 L p F P
0 0 0 r
s
0 1 .976 r
.6714 .57428 m .65549 .62939 L .61625 .69332 L p F P
0 0 0 r
s
0 1 .976 r
.61625 .69332 m .63404 .64212 L .6714 .57428 L p F P
0 0 0 r
s
1 0 .094 r
.48218 .91977 m .46017 .91416 L .42165 .92763 L p F P
0 0 0 r
s
0 .335 1 r
.50431 .09662 m .52551 .12609 L .56438 .11023 L p F P
0 0 0 r
s
0 .389 1 r
.52551 .12609 m .50431 .09662 L .46565 .11269 L p F P
0 0 0 r
s
1 0 .907 r
.60383 .09413 m .62369 .12367 L .66334 .10777 L p F P
0 0 0 r
s
.98 0 1 r
.62369 .12367 m .60383 .09413 L .56438 .11023 L p F P
0 0 0 r
s
1 0 .15 r
.7221 .12124 m .70359 .09163 L .66334 .10777 L p F P
0 0 0 r
s
0 .791 1 r
.19977 .70111 m .17465 .67208 L .1409 .66192 L p F P
0 0 0 r
s
0 .851 1 r
.11422 .63977 m .1409 .66192 L .17465 .67208 L p F P
0 0 0 r
s
.798 0 1 r
.33941 .85156 m .31631 .81516 L .28147 .78805 L p F P
0 0 0 r
s
.556 0 1 r
.25787 .75389 m .28147 .78805 L .31631 .81516 L p F P
0 0 0 r
s
1 0 .262 r
.42165 .92763 m .39904 .90244 L .3622 .88522 L p F P
0 0 0 r
s
1 0 .433 r
.33941 .85156 m .3622 .88522 L .39904 .90244 L p F P
0 0 0 r
s
0 .281 1 r
.54356 .08032 m .56438 .11023 L .60383 .09413 L p F P
0 0 0 r
s
0 .335 1 r
.56438 .11023 m .54356 .08032 L .50431 .09662 L p F P
0 0 0 r
s
0 .204 1 r
.25787 .75389 m .23386 .71858 L .19977 .70111 L p F P
0 0 0 r
s
0 .377 1 r
.17465 .67208 m .19977 .70111 L .23386 .71858 L p F P
0 0 0 r
s
1 0 .647 r
.53847 .81687 m .51717 .83637 L .47718 .87804 L p F P
0 0 0 r
s
1 0 .647 r
.47718 .87804 m .49939 .87578 L .53847 .81687 L p F P
0 0 0 r
s
1 0 .804 r
.64388 .07778 m .66334 .10777 L .70359 .09163 L p F P
0 0 0 r
s
1 0 .907 r
.66334 .10777 m .64388 .07778 L .60383 .09413 L p F P
0 0 0 r
s
1 0 .058 r
.39904 .90244 m .42165 .92763 L .46017 .91416 L p F P
0 0 0 r
s
1 0 .23 r
.89952 .87104 m .91902 .92167 L .9316 .90905 L p F P
0 0 0 r
s
1 0 .23 r
.9316 .90905 m .95783 .88273 L p .92162 .87547 L F P
0 0 0 r
s
1 0 .23 r
.89952 .87104 m .9316 .90905 L .92162 .87547 L F
.94595 .89232 m .89952 .87104 L p .92162 .87547 L F P
0 0 0 r
s
1 0 .23 r
.95783 .88273 m .94595 .89232 L p .92162 .87547 L F P
0 0 0 r
s
1 0 .709 r
.94595 .89232 m .92509 .83153 L .89934 .80043 L p F P
0 0 0 r
s
1 0 .709 r
.89934 .80043 m .87461 .77057 L p .90677 .82546 L F P
0 0 0 r
s
1 0 .709 r
.90677 .82546 m .94595 .89232 L .89934 .80043 L F
.87461 .77057 m .89952 .87104 L .94595 .89232 L p F P
0 0 0 r
s
.676 1 0 r
.75867 .51484 m .77011 .45366 L .8086 .4111 L p F P
0 0 0 r
s
.032 1 0 r
.77011 .45366 m .75867 .51484 L .71908 .57251 L p F P
0 0 0 r
s
.032 1 0 r
.71908 .57251 m .7321 .50601 L .77011 .45366 L p F P
0 0 0 r
s
.556 0 1 r
.31631 .81516 m .29291 .77625 L .25787 .75389 L p F P
0 0 0 r
s
.297 0 1 r
.23386 .71858 m .25787 .75389 L .29291 .77625 L p F P
0 0 0 r
s
0 .229 1 r
.58341 .06376 m .60383 .09413 L .64388 .07778 L p F P
0 0 0 r
s
0 .281 1 r
.60383 .09413 m .58341 .06376 L .54356 .08032 L p F P
0 0 0 r
s
1 0 .192 r
.49939 .87578 m .47718 .87804 L .43757 .90051 L p F P
0 0 0 r
s
1 0 .192 r
.43757 .90051 m .46017 .91416 L .49939 .87578 L p F P
0 0 0 r
s
1 0 .433 r
.39904 .90244 m .3761 .87174 L .33941 .85156 L p F P
0 0 0 r
s
1 0 .658 r
.31631 .81516 m .33941 .85156 L .3761 .87174 L p F P
0 0 0 r
s
1 0 .058 r
.46017 .91416 m .43757 .90051 L .39904 .90244 L p F P
0 0 0 r
s
1 0 .804 r
.70359 .09163 m .68455 .06119 L .64388 .07778 L p F P
0 0 0 r
s
0 .851 1 r
.17465 .67208 m .14894 .64233 L .11422 .63977 L p F P
0 0 0 r
s
0 .911 1 r
.08678 .617 m .11422 .63977 L .14894 .64233 L p F P
0 0 0 r
s
0 .377 1 r
.23386 .71858 m .20942 .68221 L .17465 .67208 L p F P
0 0 0 r
s
0 .553 1 r
.14894 .64233 m .17465 .67208 L .20942 .68221 L p F P
0 0 0 r
s
0 1 .688 r
.7321 .50601 m .71908 .57251 L .67895 .63071 L p F P
0 0 0 r
s
0 1 .688 r
.67895 .63071 m .69403 .56567 L .7321 .50601 L p F P
0 0 0 r
s
1 0 .118 r
.3761 .87174 m .39904 .90244 L .43757 .90051 L p F P
0 0 0 r
s
0 .179 1 r
.62387 .04695 m .64388 .07778 L .68455 .06119 L p F P
0 0 0 r
s
0 .229 1 r
.64388 .07778 m .62387 .04695 L .58341 .06376 L p F P
0 0 0 r
s
1 0 .658 r
.3761 .87174 m .3529 .83577 L .31631 .81516 L p F P
0 0 0 r
s
1 0 .93 r
.29291 .77625 m .31631 .81516 L .3529 .83577 L p F P
0 0 0 r
s
.297 0 1 r
.29291 .77625 m .26924 .7351 L .23386 .71858 L p F P
0 0 0 r
s
.024 0 1 r
.20942 .68221 m .23386 .71858 L .26924 .7351 L p F P
0 0 0 r
s
0 .562 1 r
.69403 .56567 m .67895 .63071 L .63819 .68675 L p F P
0 0 0 r
s
0 .562 1 r
.63819 .68675 m .65549 .62939 L .69403 .56567 L p F P
0 0 0 r
s
0 .179 1 r
.68455 .06119 m .66497 .02988 L .62387 .04695 L p F P
0 0 0 r
s
1 0 .061 r
.41452 .87833 m .43757 .90051 L .47718 .87804 L p F P
0 0 0 r
s
1 0 .118 r
.43757 .90051 m .41452 .87833 L .3761 .87174 L p F P
0 0 0 r
s
0 .553 1 r
.20942 .68221 m .18453 .64485 L .14894 .64233 L p F P
0 0 0 r
s
0 .731 1 r
.12262 .61184 m .14894 .64233 L .18453 .64485 L p F P
0 0 0 r
s
0 .911 1 r
.14894 .64233 m .12262 .61184 L .08678 .617 L p F P
0 0 0 r
s
1 0 .272 r
.3529 .83577 m .3761 .87174 L .41452 .87833 L p F P
0 0 0 r
s
1 0 .93 r
.3529 .83577 m .3295 .79496 L .29291 .77625 L p F P
0 0 0 r
s
.756 0 1 r
.26924 .7351 m .29291 .77625 L .3295 .79496 L p F P
0 0 0 r
s
0 .971 1 r
.05856 .59358 m .08678 .617 L .12262 .61184 L p F P
0 0 0 r
s
1 0 .267 r
.51717 .83637 m .49484 .84446 L .45427 .86937 L p F P
0 0 0 r
s
1 0 .267 r
.45427 .86937 m .47718 .87804 L .51717 .83637 L p F P
0 0 0 r
s
.024 0 1 r
.26924 .7351 m .24528 .69199 L .20942 .68221 L p F P
0 0 0 r
s
0 .26 1 r
.18453 .64485 m .20942 .68221 L .24528 .69199 L p F P
0 0 0 r
s
1 0 .061 r
.47718 .87804 m .45427 .86937 L .41452 .87833 L p F P
0 0 0 r
s
.756 0 1 r
.3295 .79496 m .30595 .74984 L .26924 .7351 L p F P
0 0 0 r
s
.404 0 1 r
.24528 .69199 m .26924 .7351 L .30595 .74984 L p F P
0 0 0 r
s
1 0 .272 r
.41452 .87833 m .39116 .84754 L .3529 .83577 L p F P
0 0 0 r
s
1 0 .517 r
.3295 .79496 m .3529 .83577 L .39116 .84754 L p F P
0 0 0 r
s
0 .731 1 r
.18453 .64485 m .15918 .60656 L .12262 .61184 L p F P
0 0 0 r
s
0 .911 1 r
.09566 .58061 m .12262 .61184 L .15918 .60656 L p F P
0 0 0 r
s
0 .971 1 r
.12262 .61184 m .09566 .58061 L .05856 .59358 L p F P
0 0 0 r
s
0 .26 1 r
.24528 .69199 m .22105 .64724 L .18453 .64485 L p F P
0 0 0 r
s
0 .553 1 r
.15918 .60656 m .18453 .64485 L .22105 .64724 L p F P
0 0 0 r
s
1 0 .073 r
.39116 .84754 m .41452 .87833 L .45427 .86937 L p F P
0 0 0 r
s
.404 0 1 r
.30595 .74984 m .28229 .70107 L .24528 .69199 L p F P
0 0 0 r
s
.024 0 1 r
.22105 .64724 m .24528 .69199 L .28229 .70107 L p F P
0 0 0 r
s
1 0 .517 r
.39116 .84754 m .36763 .8085 L .3295 .79496 L p F P
0 0 0 r
s
1 0 .845 r
.30595 .74984 m .3295 .79496 L .36763 .8085 L p F P
0 0 0 r
s
0 1 .862 r
.79795 .46014 m .78895 .54291 L .74711 .59465 L p F P
0 0 0 r
s
0 1 .862 r
.74711 .59465 m .75867 .51484 L .79795 .46014 L p F P
0 0 0 r
s
1 0 .071 r
.43087 .84864 m .45427 .86937 L .49484 .84446 L p F P
0 0 0 r
s
1 0 .073 r
.45427 .86937 m .43087 .84864 L .39116 .84754 L p F P
0 0 0 r
s
0 .553 1 r
.22105 .64724 m .19651 .60115 L .15918 .60656 L p F P
0 0 0 r
s
0 .851 1 r
.13335 .56744 m .15918 .60656 L .19651 .60115 L p F P
0 0 0 r
s
0 .911 1 r
.15918 .60656 m .13335 .56744 L .09566 .58061 L p F P
0 0 0 r
s
1 0 .227 r
.36763 .8085 m .39116 .84754 L .43087 .84864 L p F P
0 0 0 r
s
1 0 .267 r
.4717 .83798 m .49484 .84446 L .53567 .80484 L p F P
0 0 0 r
s
.024 0 1 r
.28229 .70107 m .25852 .64939 L .22105 .64724 L p F P
0 0 0 r
s
0 .377 1 r
.19651 .60115 m .22105 .64724 L .25852 .64939 L p F P
0 0 0 r
s
1 0 .071 r
.49484 .84446 m .4717 .83798 L .43087 .84864 L p F P
0 0 0 r
s
1 0 .845 r
.36763 .8085 m .34404 .76198 L .30595 .74984 L p F P
0 0 0 r
s
.756 0 1 r
.28229 .70107 m .30595 .74984 L .34404 .76198 L p F P
0 0 0 r
s
0 .509 1 r
.75867 .51484 m .74711 .59465 L .70478 .64412 L p F P
0 0 0 r
s
0 .509 1 r
.70478 .64412 m .71908 .57251 L .75867 .51484 L p F P
0 0 0 r
s
0 .851 1 r
.19651 .60115 m .17164 .55405 L .13335 .56744 L p F P
0 0 0 r
s
.756 0 1 r
.34404 .76198 m .32047 .70909 L .28229 .70107 L p F P
0 0 0 r
s
.297 0 1 r
.25852 .64939 m .28229 .70107 L .32047 .70909 L p F P
0 0 0 r
s
0 .377 1 r
.25852 .64939 m .23462 .59559 L .19651 .60115 L p F P
0 0 0 r
s
0 .791 1 r
.17164 .55405 m .19651 .60115 L .23462 .59559 L p F P
0 0 0 r
s
.103 0 1 r
.71908 .57251 m .70478 .64412 L .66199 .6897 L p F P
0 0 0 r
s
.103 0 1 r
.66199 .6897 m .67895 .63071 L .71908 .57251 L p F P
0 0 0 r
s
1 0 .227 r
.43087 .84864 m .4072 .81555 L .36763 .8085 L p F P
0 0 0 r
s
1 0 .517 r
.34404 .76198 m .36763 .8085 L .4072 .81555 L p F P
0 0 0 r
s
1 0 .073 r
.4072 .81555 m .43087 .84864 L .4717 .83798 L p F P
0 0 0 r
s
.297 0 1 r
.32047 .70909 m .29698 .65121 L .25852 .64939 L p F P
0 0 0 r
s
0 .204 1 r
.23462 .59559 m .25852 .64939 L .29698 .65121 L p F P
0 0 0 r
s
.667 0 1 r
.67895 .63071 m .66199 .6897 L .61888 .72986 L p F P
0 0 0 r
s
1 0 .446 r
.66199 .6897 m .64236 .72092 L .6359 .72409 L p F P
0 0 0 r
s
.667 0 1 r
.61888 .72986 m .63819 .68675 L .64435 .67828 L p F P
0 0 0 r
s
.667 0 1 r
.61888 .72986 m .64435 .67828 L .64182 .69199 L F
1 0 .225 r
.55289 .75938 m .57565 .76329 L .61888 .72986 L p F P
0 0 0 r
s
1 0 .225 r
.61888 .72986 m .59739 .74296 L .55289 .75938 L p F P
0 0 0 r
s
1 0 .446 r
.59739 .74296 m .61888 .72986 L .66199 .6897 L p F P
0 0 0 r
s
1 0 .446 r
.6359 .72409 m .59739 .74296 L p .63871 .7089 L F P
0 0 0 r
s
1 0 .446 r
.63871 .7089 m .66199 .6897 L .6359 .72409 L F
.667 0 1 r
.64435 .67828 m .67895 .63071 L p .64182 .69199 L F P
0 0 0 r
s
0 .791 1 r
.23462 .59559 m .21055 .54045 L .17164 .55405 L p F P
0 0 0 r
s
1 0 .517 r
.4072 .81555 m .38347 .77075 L .34404 .76198 L p F P
0 0 0 r
s
1 0 .93 r
.32047 .70909 m .34404 .76198 L .38347 .77075 L p F P
0 0 0 r
s
0 .204 1 r
.29698 .65121 m .27353 .58986 L .23462 .59559 L p F P
0 0 0 r
s
0 .732 1 r
.21055 .54045 m .23462 .59559 L .27353 .58986 L p F P
0 0 0 r
s
1 0 .061 r
.44805 .81505 m .4717 .83798 L .51325 .81535 L p F P
0 0 0 r
s
1 0 .073 r
.4717 .83798 m .44805 .81505 L .4072 .81555 L p F P
0 0 0 r
s
1 0 .93 r
.38347 .77075 m .35986 .71571 L .32047 .70909 L p F P
0 0 0 r
s
.556 0 1 r
.29698 .65121 m .32047 .70909 L .35986 .71571 L p F P
0 0 0 r
s
1 0 .272 r
.38347 .77075 m .4072 .81555 L .44805 .81505 L p F P
0 0 0 r
s
0 .732 1 r
.27353 .58986 m .25008 .52663 L .21055 .54045 L p F P
0 0 0 r
s
1 0 .192 r
.48993 .80628 m .51325 .81535 L .5551 .78147 L p F P
0 0 0 r
s
1 0 .061 r
.51325 .81535 m .48993 .80628 L .44805 .81505 L p F P
0 0 0 r
s
.556 0 1 r
.35986 .71571 m .33645 .65258 L .29698 .65121 L p F P
0 0 0 r
s
0 .035 1 r
.27353 .58986 m .29698 .65121 L .33645 .65258 L p F P
0 0 0 r
s
1 0 .192 r
.5551 .78147 m .53257 .78897 L .48993 .80628 L p F P
0 0 0 r
s
0 .035 1 r
.33645 .65258 m .31328 .58394 L .27353 .58986 L p F P
0 0 0 r
s
0 .673 1 r
.25008 .52663 m .27353 .58986 L .31328 .58394 L p F P
0 0 0 r
s
1 0 .272 r
.44805 .81505 m .4242 .77542 L .38347 .77075 L p F P
0 0 0 r
s
1 0 .658 r
.35986 .71571 m .38347 .77075 L .4242 .77542 L p F P
0 0 0 r
s
0 .673 1 r
.31328 .58394 m .29027 .51258 L .25008 .52663 L p F P
0 0 0 r
s
1 0 .118 r
.4242 .77542 m .44805 .81505 L .48993 .80628 L p F P
0 0 0 r
s
1 0 .658 r
.4242 .77542 m .40044 .72056 L .35986 .71571 L p F P
0 0 0 r
s
.798 0 1 r
.33645 .65258 m .35986 .71571 L .40044 .72056 L p F P
0 0 0 r
s
.798 0 1 r
.40044 .72056 m .37697 .65338 L .33645 .65258 L p F P
0 0 0 r
s
.13 0 1 r
.31328 .58394 m .33645 .65258 L .37697 .65338 L p F P
0 0 0 r
s
.13 0 1 r
.37697 .65338 m .35389 .57783 L .31328 .58394 L p F P
0 0 0 r
s
0 .615 1 r
.29027 .51258 m .31328 .58394 L .35389 .57783 L p F P
0 0 0 r
s
0 .615 1 r
.35389 .57783 m .33111 .4983 L .29027 .51258 L p F P
0 0 0 r
s
1 0 .058 r
.46611 .77538 m .48993 .80628 L .53257 .78897 L p F P
0 0 0 r
s
1 0 .118 r
.48993 .80628 m .46611 .77538 L .4242 .77542 L p F P
0 0 0 r
s
1 0 .433 r
.40044 .72056 m .4242 .77542 L .46611 .77538 L p F P
0 0 0 r
s
.452 0 1 r
.78895 .54291 m .77813 .62445 L .73291 .66117 L p F P
0 0 0 r
s
.452 0 1 r
.73291 .66117 m .74711 .59465 L .78895 .54291 L p F P
0 0 0 r
s
0 .557 1 r
.39537 .5715 m .37263 .48379 L .33111 .4983 L p F P
0 0 0 r
s
0 .557 1 r
.33111 .4983 m .35389 .57783 L .39537 .5715 L p F P
0 0 0 r
s
1 0 .433 r
.46611 .77538 m .4422 .72332 L .40044 .72056 L p F P
0 0 0 r
s
1 0 .981 r
.37697 .65338 m .40044 .72056 L .4422 .72332 L p F P
0 0 0 r
s
1 0 .094 r
.50906 .77014 m .53257 .78897 L .57565 .76329 L p F P
0 0 0 r
s
1 0 .058 r
.53257 .78897 m .50906 .77014 L .46611 .77538 L p F P
0 0 0 r
s
.289 0 1 r
.41856 .65352 m .39537 .5715 L .35389 .57783 L p F P
0 0 0 r
s
.289 0 1 r
.35389 .57783 m .37697 .65338 L .41856 .65352 L p F P
0 0 0 r
s
.881 0 1 r
.74711 .59465 m .73291 .66117 L .6876 .69352 L p F P
0 0 0 r
s
.881 0 1 r
.6876 .69352 m .70478 .64412 L .74711 .59465 L p F P
0 0 0 r
s
1 0 .981 r
.4422 .72332 m .41856 .65352 L .37697 .65338 L p F P
0 0 0 r
s
1 0 .747 r
.70478 .64412 m .6876 .69352 L .64236 .72092 L p F P
0 0 0 r
s
1 0 .747 r
.64236 .72092 m .66199 .6897 L .70478 .64412 L p F P
0 0 0 r
s
1 0 .094 r
.57565 .76329 m .55289 .75938 L .50906 .77014 L p F P
0 0 0 r
s
1 0 .262 r
.4422 .72332 m .46611 .77538 L .50906 .77014 L p F P
0 0 0 r
s
0 .5 1 r
.43777 .56492 m .41484 .46903 L .37263 .48379 L p F P
0 0 0 r
s
0 .5 1 r
.37263 .48379 m .39537 .5715 L .43777 .56492 L p F P
0 0 0 r
s
.442 0 1 r
.46122 .65287 m .43777 .56492 L .39537 .5715 L p F P
0 0 0 r
s
.442 0 1 r
.39537 .5715 m .41856 .65352 L .46122 .65287 L p F P
0 0 0 r
s
1 0 .262 r
.50906 .77014 m .4851 .72366 L .4422 .72332 L p F P
0 0 0 r
s
1 0 .782 r
.41856 .65352 m .4422 .72332 L .4851 .72366 L p F P
0 0 0 r
s
1 0 .782 r
.4851 .72366 m .46122 .65287 L .41856 .65352 L p F P
0 0 0 r
s
0 .444 1 r
.4811 .55809 m .45777 .45403 L .41484 .46903 L p F P
0 0 0 r
s
0 .444 1 r
.41484 .46903 m .43777 .56492 L .4811 .55809 L p F P
0 0 0 r
s
1 0 .146 r
.4851 .72366 m .50906 .77014 L .55289 .75938 L p F P
0 0 0 r
s
.589 0 1 r
.50497 .65132 m .4811 .55809 L .43777 .56492 L p F P
0 0 0 r
s
.589 0 1 r
.43777 .56492 m .46122 .65287 L .50497 .65132 L p F P
0 0 0 r
s
0 .389 1 r
.52538 .55098 m .50143 .43876 L .45777 .45403 L p F P
0 0 0 r
s
0 .389 1 r
.45777 .45403 m .4811 .55809 L .52538 .55098 L p F P
0 0 0 r
s
1 0 .146 r
.55289 .75938 m .5291 .72131 L .4851 .72366 L p F P
0 0 0 r
s
1 0 .607 r
.46122 .65287 m .4851 .72366 L .5291 .72131 L p F P
0 0 0 r
s
1 0 .088 r
.5291 .72131 m .55289 .75938 L .59739 .74296 L p F P
0 0 0 r
s
1 0 .607 r
.5291 .72131 m .50497 .65132 L .46122 .65287 L p F P
0 0 0 r
s
0 .335 1 r
.57066 .54357 m .54584 .42324 L .50143 .43876 L p F P
0 0 0 r
s
0 .335 1 r
.50143 .43876 m .52538 .55098 L .57066 .54357 L p F P
0 0 0 r
s
.727 0 1 r
.54981 .64876 m .52538 .55098 L .4811 .55809 L p F P
0 0 0 r
s
.727 0 1 r
.4811 .55809 m .50497 .65132 L .54981 .64876 L p F P
0 0 0 r
s
1 0 .088 r
.5741 .71601 m .59739 .74296 L .64236 .72092 L p F P
0 0 0 r
s
1 0 .088 r
.59739 .74296 m .5741 .71601 L .5291 .72131 L p F P
0 0 0 r
s
1 0 .458 r
.50497 .65132 m .5291 .72131 L .5741 .71601 L p F P
0 0 0 r
s
1 0 .458 r
.5741 .71601 m .54981 .64876 L .50497 .65132 L p F P
0 0 0 r
s
1 0 .147 r
.62003 .70757 m .64236 .72092 L .6876 .69352 L p F P
0 0 0 r
s
1 0 .088 r
.64236 .72092 m .62003 .70757 L .5741 .71601 L p F P
0 0 0 r
s
0 .281 1 r
.61694 .53585 m .59101 .40745 L .54584 .42324 L p F P
0 0 0 r
s
0 .281 1 r
.54584 .42324 m .57066 .54357 L .61694 .53585 L p F P
0 0 0 r
s
1 0 .261 r
.66677 .69585 m .6876 .69352 L .73291 .66117 L p F P
0 0 0 r
s
1 0 .147 r
.6876 .69352 m .66677 .69585 L .62003 .70757 L p F P
0 0 0 r
s
.858 0 1 r
.59573 .64509 m .57066 .54357 L .52538 .55098 L p F P
0 0 0 r
s
.858 0 1 r
.52538 .55098 m .54981 .64876 L .59573 .64509 L p F P
0 0 0 r
s
1 0 .429 r
.71422 .68074 m .73291 .66117 L .77813 .62445 L p F P
0 0 0 r
s
1 0 .261 r
.73291 .66117 m .71422 .68074 L .66677 .69585 L p F P
0 0 0 r
s
1 0 .429 r
.77813 .62445 m .76224 .66225 L .71422 .68074 L p F P
0 0 0 r
s
1 0 .337 r
.54981 .64876 m .5741 .71601 L .62003 .70757 L p F P
0 0 0 r
s
0 .229 1 r
.66427 .52778 m .63698 .39138 L .59101 .40745 L p F P
0 0 0 r
s
0 .229 1 r
.59101 .40745 m .61694 .53585 L .66427 .52778 L p F P
0 0 0 r
s
1 0 .337 r
.62003 .70757 m .59573 .64509 L .54981 .64876 L p F P
0 0 0 r
s
.98 0 1 r
.64274 .64019 m .61694 .53585 L .57066 .54357 L p F P
0 0 0 r
s
.98 0 1 r
.57066 .54357 m .59573 .64509 L .64274 .64019 L p F P
0 0 0 r
s
0 .179 1 r
.71266 .51935 m .68375 .37503 L .63698 .39138 L p F P
0 0 0 r
s
0 .179 1 r
.63698 .39138 m .66427 .52778 L .71266 .51935 L p F P
0 0 0 r
s
1 0 .245 r
.59573 .64509 m .62003 .70757 L .66677 .69585 L p F P
0 0 0 r
s
1 0 .245 r
.66677 .69585 m .64274 .64019 L .59573 .64509 L p F P
0 0 0 r
s
1 0 .907 r
.69081 .63398 m .66427 .52778 L .61694 .53585 L p F P
0 0 0 r
s
1 0 .907 r
.61694 .53585 m .64274 .64019 L .69081 .63398 L p F P
0 0 0 r
s
1 0 .183 r
.64274 .64019 m .66677 .69585 L .71422 .68074 L p F P
0 0 0 r
s
1 0 .183 r
.71422 .68074 m .69081 .63398 L .64274 .64019 L p F P
0 0 0 r
s
1 0 .15 r
.69081 .63398 m .71422 .68074 L .76224 .66225 L p F P
0 0 0 r
s
1 0 .804 r
.73992 .62635 m .71266 .51935 L .66427 .52778 L p F P
0 0 0 r
s
1 0 .804 r
.66427 .52778 m .69081 .63398 L .73992 .62635 L p F P
0 0 0 r
s
1 0 .15 r
.76224 .66225 m .73992 .62635 L .69081 .63398 L p F P
0 0 0 r
s
0 g
.25 Mabswid
.67245 0 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.67245 0 m
.08846 .24555 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.33.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics3D", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[9]= ",
 CellTags->"S5.33.1"]
}, Open  ]],

Cell["\<\
Here is another plot with the shadow moved to the top of the bounding box. \
\>", "MathCaption",
 CellTags->{"S5.33.1", "1.15"}],

Cell[CellGroupData[{

Cell["\<\
ShadowPlot3D[ Exp[-(x^2 + y^2)],
             {x, -2, 2}, {y, -2, 2},
               ShadowPosition -> 1]\
\>", "Input",
 CellLabel->"In[10]:= ",
 CellTags->"S5.33.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.0855 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0567234 1.16608 1.02999e-16 1.16608 [
[ 0 0 0 0 ]
[ 1 1.0855 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.40037 1.0855 L
s
.40037 1.0855 m
.41799 .58158 L
s
.41799 .58158 m
.08846 .24555 L
s
.67245 0 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.67245 0 m
.08846 .24555 L
s
.41799 .58158 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.40037 1.0855 L
s
.40037 1.0855 m
.41799 .58158 L
s
0 0 m
1 0 L
1 1.0855 L
0 1.0855 L
closepath
clip
newpath
.5 Mabswid
1 .005 0 r
.40442 .56378 m .42216 .58174 L .45202 .57214 L p F P
0 0 0 r
s
1 .015 0 r
.4345 .55425 m .45202 .57214 L .48224 .56261 L p F P
0 0 0 r
s
1 .005 0 r
.45202 .57214 m .4345 .55425 L .40442 .56378 L p F P
0 0 0 r
s
1 .015 0 r
.38629 .54562 m .40442 .56378 L .4345 .55425 L p F P
0 0 0 r
s
1 .035 0 r
.46494 .54512 m .48224 .56261 L .51282 .55326 L p F P
0 0 0 r
s
1 .015 0 r
.48224 .56261 m .46494 .54512 L .4345 .55425 L p F P
0 0 0 r
s
1 .041 0 r
.41657 .53648 m .4345 .55425 L .46494 .54512 L p F P
0 0 0 r
s
1 .015 0 r
.4345 .55425 m .41657 .53648 L .38629 .54562 L p F P
0 0 0 r
s
1 .067 0 r
.49575 .53665 m .51282 .55326 L .54378 .54411 L p F P
0 0 0 r
s
1 .035 0 r
.51282 .55326 m .49575 .53665 L .46494 .54512 L p F P
0 0 0 r
s
1 .035 0 r
.36774 .52734 m .38629 .54562 L .41657 .53648 L p F P
0 0 0 r
s
1 .089 0 r
.44721 .52844 m .46494 .54512 L .49575 .53665 L p F P
0 0 0 r
s
1 .041 0 r
.46494 .54512 m .44721 .52844 L .41657 .53648 L p F P
0 0 0 r
s
1 .11 0 r
.52697 .52896 m .54378 .54411 L .57514 .53507 L p F P
0 0 0 r
s
1 .067 0 r
.54378 .54411 m .52697 .52896 L .49575 .53665 L p F P
0 0 0 r
s
1 .089 0 r
.3982 .51909 m .41657 .53648 L .44721 .52844 L p F P
0 0 0 r
s
1 .035 0 r
.41657 .53648 m .3982 .51909 L .36774 .52734 L p F P
0 0 0 r
s
1 .167 0 r
.47824 .52213 m .49575 .53665 L .52697 .52896 L p F P
0 0 0 r
s
1 .089 0 r
.49575 .53665 m .47824 .52213 L .44721 .52844 L p F P
0 0 0 r
s
1 .156 0 r
.55863 .52176 m .57514 .53507 L .60689 .52585 L p F P
0 0 0 r
s
1 .11 0 r
.57514 .53507 m .55863 .52176 L .52697 .52896 L p F P
0 0 0 r
s
1 .067 0 r
.34874 .50897 m .36774 .52734 L .3982 .51909 L p F P
0 0 0 r
s
1 .192 0 r
.429 .51321 m .44721 .52844 L .47824 .52213 L p F P
0 0 0 r
s
1 .089 0 r
.44721 .52844 m .429 .51321 L .3982 .51909 L p F P
0 0 0 r
s
1 .271 0 r
.50972 .51783 m .52697 .52896 L .55863 .52176 L p F P
0 0 0 r
s
1 .167 0 r
.52697 .52896 m .50972 .51783 L .47824 .52213 L p F P
0 0 0 r
s
1 .192 0 r
.59075 .51428 m .60689 .52585 L .63905 .51607 L p F P
0 0 0 r
s
1 .156 0 r
.60689 .52585 m .59075 .51428 L .55863 .52176 L p F P
0 0 0 r
s
1 .167 0 r
.37934 .50217 m .3982 .51909 L .429 .51321 L p F P
0 0 0 r
s
1 .067 0 r
.3982 .51909 m .37934 .50217 L .34874 .50897 L p F P
0 0 0 r
s
1 .358 0 r
.46019 .51102 m .47824 .52213 L .50972 .51783 L p F P
0 0 0 r
s
1 .192 0 r
.47824 .52213 m .46019 .51102 L .429 .51321 L p F P
0 0 0 r
s
1 .205 0 r
.62329 .5055 m .63905 .51607 L .67158 .50547 L p F P
0 0 0 r
s
1 .192 0 r
.63905 .51607 m .62329 .5055 L .59075 .51428 L p F P
0 0 0 r
s
1 .383 0 r
.54172 .51488 m .55863 .52176 L .59075 .51428 L p F P
0 0 0 r
s
1 .383 0 r
.57429 .51148 m .54172 .51488 L p .55012 .51478 L F P
0 0 0 r
s
1 .383 0 r
.59075 .51428 m .57429 .51148 L p .55012 .51478 L F P
0 0 0 r
s
1 .471 0 r
.60734 .50516 m .57429 .51148 L p .58529 .51014 L F P
0 0 0 r
s
1 .471 0 r
.62329 .5055 m .60734 .50516 L p .58529 .51014 L F P
0 0 0 r
s
1 .505 0 r
.64075 .49414 m .60734 .50516 L p .61833 .50281 L F P
0 0 0 r
s
1 .505 0 r
.65619 .49468 m .64075 .49414 L p .61833 .50281 L F P
0 0 0 r
s
1 .471 0 r
.67435 .47837 m .64075 .49414 L p .64911 .49202 L F P
0 0 0 r
s
1 .471 0 r
.6894 .48179 m .67435 .47837 L p .64911 .49202 L F P
0 0 0 r
s
1 .383 0 r
.7229 .46757 m .7081 .4596 L .67435 .47837 L p F P
0 0 0 r
s
1 .818 0 r
.67435 .47837 m .7081 .4596 L p .69994 .46453 L F P
0 0 0 r
s
1 .383 0 r
.67435 .47837 m .6894 .48179 L .7229 .46757 L p F P
0 0 0 r
s
1 .818 0 r
.65939 .48904 m .67435 .47837 L p .69994 .46453 L F P
0 0 0 r
s
.994 1 0 r
.64075 .49414 m .67435 .47837 L p .66357 .48532 L F P
0 0 0 r
s
1 .205 0 r
.67158 .50547 m .65619 .49468 L .62329 .5055 L p F P
0 0 0 r
s
1 .505 0 r
.60734 .50516 m .62329 .5055 L .65619 .49468 L p F P
0 0 0 r
s
1 .471 0 r
.64075 .49414 m .65619 .49468 L .6894 .48179 L p F P
0 0 0 r
s
.994 1 0 r
.62527 .51001 m .64075 .49414 L p .66357 .48532 L F P
0 0 0 r
s
.923 1 0 r
.60734 .50516 m .64075 .49414 L p .62985 .50009 L F P
0 0 0 r
s
1 .471 0 r
.57429 .51148 m .59075 .51428 L .62329 .5055 L p F P
0 0 0 r
s
.923 1 0 r
.59116 .5212 m .60734 .50516 L p .62985 .50009 L F P
0 0 0 r
s
.994 1 0 r
.57429 .51148 m .60734 .50516 L p .59895 .50811 L F P
0 0 0 r
s
.994 1 0 r
.55739 .52268 m .57429 .51148 L p .59895 .50811 L F P
0 0 0 r
s
1 .818 0 r
.54172 .51488 m .57429 .51148 L p .5724 .51173 L F P
0 0 0 r
s
1 .271 0 r
.55863 .52176 m .54172 .51488 L p .51159 .51798 L F P
0 0 0 r
s
1 .818 0 r
.52427 .51828 m .54172 .51488 L p .5724 .51173 L F P
0 0 0 r
s
1 .271 0 r
.54172 .51488 m .50972 .51783 L p .51159 .51798 L F P
0 0 0 r
s
1 .11 0 r
.32928 .49039 m .34874 .50897 L .37934 .50217 L p F P
0 0 0 r
s
1 .358 0 r
.41024 .49969 m .429 .51321 L .46019 .51102 L p F P
0 0 0 r
s
1 .167 0 r
.429 .51321 m .41024 .49969 L .37934 .50217 L p F P
0 0 0 r
s
1 .192 0 r
.65619 .49468 m .67158 .50547 L .70446 .49403 L p F P
0 0 0 r
s
1 .58 0 r
.49189 .51314 m .50972 .51783 L .54172 .51488 L p F P
0 0 0 r
s
1 .358 0 r
.50972 .51783 m .49189 .51314 L .46019 .51102 L p F P
0 0 0 r
s
1 .271 0 r
.35999 .48544 m .37934 .50217 L .41024 .49969 L p F P
0 0 0 r
s
1 .11 0 r
.37934 .50217 m .35999 .48544 L .32928 .49039 L p F P
0 0 0 r
s
1 .156 0 r
.6894 .48179 m .70446 .49403 L .73771 .48202 L p F P
0 0 0 r
s
1 .192 0 r
.70446 .49403 m .6894 .48179 L .65619 .49468 L p F P
0 0 0 r
s
1 .156 0 r
.30936 .47131 m .32928 .49039 L .35999 .48544 L p F P
0 0 0 r
s
1 .666 0 r
.44149 .50395 m .46019 .51102 L .49189 .51314 L p F P
0 0 0 r
s
1 .358 0 r
.46019 .51102 m .44149 .50395 L .41024 .49969 L p F P
0 0 0 r
s
1 .58 0 r
.54172 .51488 m .52427 .51828 L .49189 .51314 L p F P
0 0 0 r
s
1 .58 0 r
.39089 .48725 m .41024 .49969 L .44149 .50395 L p F P
0 0 0 r
s
1 .271 0 r
.41024 .49969 m .39089 .48725 L .35999 .48544 L p F P
0 0 0 r
s
1 .11 0 r
.7229 .46757 m .73771 .48202 L .77134 .4698 L p F P
0 0 0 r
s
1 .156 0 r
.73771 .48202 m .7229 .46757 L .6894 .48179 L p F P
0 0 0 r
s
1 .383 0 r
.34015 .46811 m .35999 .48544 L .39089 .48725 L p F P
0 0 0 r
s
1 .156 0 r
.35999 .48544 m .34015 .46811 L .30936 .47131 L p F P
0 0 0 r
s
.922 1 0 r
.47333 .51612 m .49189 .51314 L .52427 .51828 L p F P
0 0 0 r
s
1 .666 0 r
.49189 .51314 m .47333 .51612 L .44149 .50395 L p F P
0 0 0 r
s
1 .067 0 r
.75674 .45301 m .77134 .4698 L .80539 .45766 L p F P
0 0 0 r
s
1 .11 0 r
.77134 .4698 m .75674 .45301 L .7229 .46757 L p F P
0 0 0 r
s
1 .818 0 r
.57429 .51148 m .55739 .52268 L .52427 .51828 L p F P
0 0 0 r
s
1 .192 0 r
.289 .45132 m .30936 .47131 L .34015 .46811 L p F P
0 0 0 r
s
.922 1 0 r
.4221 .49963 m .44149 .50395 L .47333 .51612 L p F P
0 0 0 r
s
1 .58 0 r
.44149 .50395 m .4221 .49963 L .39089 .48725 L p F P
0 0 0 r
s
1 .035 0 r
.79099 .43892 m .80539 .45766 L .83988 .44571 L p F P
0 0 0 r
s
1 .067 0 r
.80539 .45766 m .79099 .43892 L .75674 .45301 L p F P
0 0 0 r
s
1 .271 0 r
.7081 .4596 m .7229 .46757 L .75674 .45301 L p F P
0 0 0 r
s
1 .818 0 r
.37102 .47403 m .39089 .48725 L .4221 .49963 L p F P
0 0 0 r
s
1 .383 0 r
.39089 .48725 m .37102 .47403 L .34015 .46811 L p F P
0 0 0 r
s
.994 1 0 r
.60734 .50516 m .59116 .5212 L .55739 .52268 L p F P
0 0 0 r
s
1 .471 0 r
.31989 .44913 m .34015 .46811 L .37102 .47403 L p F P
0 0 0 r
s
1 .192 0 r
.34015 .46811 m .31989 .44913 L .289 .45132 L p F P
0 0 0 r
s
.48 1 0 r
.50604 .53403 m .52427 .51828 L .55739 .52268 L p F P
0 0 0 r
s
.922 1 0 r
.52427 .51828 m .50604 .53403 L .47333 .51612 L p F P
0 0 0 r
s
1 .015 0 r
.82571 .42558 m .83988 .44571 L .87482 .43391 L p F P
0 0 0 r
s
1 .035 0 r
.83988 .44571 m .82571 .42558 L .79099 .43892 L p F P
0 0 0 r
s
1 .167 0 r
.74209 .44027 m .75674 .45301 L .79099 .43892 L p F P
0 0 0 r
s
1 .271 0 r
.75674 .45301 m .74209 .44027 L .7081 .4596 L p F P
0 0 0 r
s
1 .205 0 r
.26821 .43014 m .289 .45132 L .31989 .44913 L p F P
0 0 0 r
s
.923 1 0 r
.64075 .49414 m .62527 .51001 L .59116 .5212 L p F P
0 0 0 r
s
1 .005 0 r
.86092 .41288 m .87482 .43391 L .91023 .42216 L p F P
0 0 0 r
s
1 .015 0 r
.87482 .43391 m .86092 .41288 L .82571 .42558 L p F P
0 0 0 r
s
1 .089 0 r
.77645 .42224 m .79099 .43892 L .82571 .42558 L p F P
0 0 0 r
s
1 .167 0 r
.79099 .43892 m .77645 .42224 L .74209 .44027 L p F P
0 0 0 r
s
.256 1 0 r
.45391 .52462 m .47333 .51612 L .50604 .53403 L p F P
0 0 0 r
s
.922 1 0 r
.47333 .51612 m .45391 .52462 L .4221 .49963 L p F P
0 0 0 r
s
.994 1 0 r
.67435 .47837 m .65939 .48904 L p .63866 .50138 L F P
0 0 0 r
s
1 .818 0 r
.69341 .462 m .65939 .48904 L p .66268 .48705 L F P
0 0 0 r
s
1 .818 0 r
.7081 .4596 m .69341 .462 L p .66268 .48705 L F P
0 0 0 r
s
1 .58 0 r
.74209 .44027 m .72746 .43403 L .69341 .462 L p F P
0 0 0 r
s
.922 1 0 r
.69341 .462 m .72746 .43403 L p .7243 .43682 L F P
0 0 0 r
s
.48 1 0 r
.65939 .48904 m .69341 .462 L p .68048 .47648 L F P
0 0 0 r
s
1 .58 0 r
.69341 .462 m .7081 .4596 L .74209 .44027 L p F P
0 0 0 r
s
.48 1 0 r
.6444 .51692 m .65939 .48904 L p .67833 .47776 L F P
0 0 0 r
s
.48 1 0 r
.67609 .4814 m .67833 .47776 L .68048 .47648 L F
.6444 .51692 m .67833 .47776 L .67609 .4814 L F
.69341 .462 m .67875 .47689 L p .67609 .4814 L F P
0 0 0 r
s
.922 1 0 r
.67875 .47689 m .69341 .462 L p .71968 .44058 L F P
0 0 0 r
s
.922 1 0 r
.71513 .44489 m .71968 .44058 L .7243 .43682 L F
.67875 .47689 m .71968 .44058 L .71513 .44489 L F
.71283 .43554 m .67875 .47689 L p .71513 .44489 L F P
0 0 0 r
s
.922 1 0 r
.72746 .43403 m .71283 .43554 L p .71513 .44489 L F P
0 0 0 r
s
.256 1 0 r
.67875 .47689 m .71283 .43554 L p .70533 .44558 L F P
0 0 0 r
s
.48 1 0 r
.65227 .5081 m .67609 .4814 L .67875 .47689 L F
.67875 .47689 m .6444 .51692 L p .65227 .5081 L F P
0 0 0 r
s
0 1 .458 r
.6289 .55829 m .6444 .51692 L .67875 .47689 L p F P
0 0 0 r
s
0 1 .458 r
.67875 .47689 m .66375 .50122 L .64329 .53472 L p F P
0 0 0 r
s
0 1 .458 r
.65317 .51866 m .67875 .47689 L .64329 .53472 L F
.256 1 0 r
.66375 .50122 m .67875 .47689 L p .70533 .44558 L F P
0 0 0 r
s
.256 1 0 r
.71283 .43554 m .6979 .44263 L .67382 .48394 L p F P
0 0 0 r
s
.256 1 0 r
.67382 .48394 m .66375 .50122 L p .68349 .4748 L F P
0 0 0 r
s
.256 1 0 r
.68349 .4748 m .71283 .43554 L .67382 .48394 L F
0 1 .458 r
.64329 .53472 m .6289 .55829 L p .65317 .51866 L F P
0 0 0 r
s
.994 1 0 r
.65939 .48904 m .62527 .51001 L p .63866 .50138 L F P
0 0 0 r
s
.48 1 0 r
.40206 .4943 m .4221 .49963 L .45391 .52462 L p F P
0 0 0 r
s
1 .818 0 r
.4221 .49963 m .40206 .4943 L .37102 .47403 L p F P
0 0 0 r
s
.994 1 0 r
.35074 .45756 m .37102 .47403 L .40206 .4943 L p F P
0 0 0 r
s
1 .471 0 r
.37102 .47403 m .35074 .45756 L p .35963 .46849 L F P
0 0 0 r
s
.994 1 0 r
.38162 .48275 m .35074 .45756 L p .38457 .48178 L F P
0 0 0 r
s
.994 1 0 r
.40206 .4943 m .38162 .48275 L p .38457 .48178 L F P
0 0 0 r
s
0 1 0 r
.38162 .48275 m .41296 .52843 L p .37856 .48375 L F P
0 0 0 r
s
.923 1 0 r
.35074 .45756 m .38162 .48275 L p .34161 .44633 L F P
0 0 0 r
s
.923 1 0 r
.36108 .46104 m .33021 .43596 L p .36406 .46677 L F P
0 0 0 r
s
.923 1 0 r
.38162 .48275 m .36108 .46104 L p .36406 .46677 L F P
0 0 0 r
s
0 1 0 r
.36108 .46104 m .38162 .48275 L p .37856 .48375 L F P
0 0 0 r
s
0 1 0 r
.39228 .50673 m .36108 .46104 L p .383 .48951 L F P
0 0 0 r
s
0 1 0 r
.41296 .52843 m .39228 .50673 L p .383 .48951 L F P
0 0 0 r
s
0 .765 1 r
.44562 .59042 m .42471 .56884 L .39228 .50673 L p F P
0 0 0 r
s
0 .98 1 r
.39228 .50673 m .42471 .56884 L p .40195 .52466 L F P
0 0 0 r
s
0 .765 1 r
.39228 .50673 m .41296 .52843 L .44562 .59042 L p F P
0 0 0 r
s
0 .98 1 r
.37199 .46652 m .39228 .50673 L p .40195 .52466 L F P
0 0 0 r
s
.133 1 0 r
.36108 .46104 m .39228 .50673 L p .358 .45514 L F P
0 0 0 r
s
.133 1 0 r
.34064 .42902 m .36108 .46104 L p .358 .45514 L F P
0 0 0 r
s
.923 1 0 r
.33021 .43596 m .35074 .45756 L p .34161 .44633 L F P
0 0 0 r
s
1 .471 0 r
.35074 .45756 m .31989 .44913 L p .35963 .46849 L F P
0 0 0 r
s
1 .505 0 r
.29927 .42772 m .31989 .44913 L .35074 .45756 L p F P
0 0 0 r
s
1 .205 0 r
.31989 .44913 m .29927 .42772 L .26821 .43014 L p F P
0 0 0 r
s
.133 1 0 r
.53981 .55096 m .55739 .52268 L .59116 .5212 L p F P
0 0 0 r
s
.48 1 0 r
.55739 .52268 m .53981 .55096 L .50604 .53403 L p F P
0 0 0 r
s
1 .041 0 r
.81132 .40619 m .82571 .42558 L .86092 .41288 L p F P
0 0 0 r
s
1 .089 0 r
.82571 .42558 m .81132 .40619 L .77645 .42224 L p F P
0 0 0 r
s
1 .005 0 r
.91023 .42216 m .89663 .40055 L .86092 .41288 L p F P
0 0 0 r
s
1 .192 0 r
.247 .40773 m .26821 .43014 L .29927 .42772 L p F P
0 0 0 r
s
1 .358 0 r
.72746 .43403 m .74209 .44027 L .77645 .42224 L p F P
0 0 0 r
s
1 .015 0 r
.84674 .39186 m .86092 .41288 L .89663 .40055 L p F P
0 0 0 r
s
1 .041 0 r
.86092 .41288 m .84674 .39186 L .81132 .40619 L p F P
0 0 0 r
s
1 .192 0 r
.76182 .40898 m .77645 .42224 L .81132 .40619 L p F P
0 0 0 r
s
1 .358 0 r
.77645 .42224 m .76182 .40898 L .72746 .43403 L p F P
0 0 0 r
s
0 1 0 r
.57449 .55739 m .59116 .5212 L .62527 .51001 L p F P
0 0 0 r
s
.133 1 0 r
.59116 .5212 m .57449 .55739 L .53981 .55096 L p F P
0 0 0 r
s
1 .505 0 r
.35074 .45756 m .33021 .43596 L .29927 .42772 L p F P
0 0 0 r
s
1 .471 0 r
.27831 .40382 m .29927 .42772 L .33021 .43596 L p F P
0 0 0 r
s
1 .192 0 r
.29927 .42772 m .27831 .40382 L .247 .40773 L p F P
0 0 0 r
s
0 1 .458 r
.48681 .55912 m .50604 .53403 L .53981 .55096 L p F P
0 0 0 r
s
.256 1 0 r
.50604 .53403 m .48681 .55912 L .45391 .52462 L p F P
0 0 0 r
s
1 .015 0 r
.89663 .40055 m .88273 .37862 L .84674 .39186 L p F P
0 0 0 r
s
1 .156 0 r
.22532 .38434 m .247 .40773 L .27831 .40382 L p F P
0 0 0 r
s
1 .089 0 r
.79673 .3882 m .81132 .40619 L .84674 .39186 L p F P
0 0 0 r
s
1 .192 0 r
.81132 .40619 m .79673 .3882 L .76182 .40898 L p F P
0 0 0 r
s
.133 1 0 r
.60955 .5461 m .62527 .51001 L .65939 .48904 L p F P
0 0 0 r
s
0 1 0 r
.62527 .51001 m .60955 .5461 L .57449 .55739 L p F P
0 0 0 r
s
.48 1 0 r
.45391 .52462 m .43368 .53192 L .40206 .4943 L p F P
0 0 0 r
s
.133 1 0 r
.38162 .48275 m .40206 .4943 L .43368 .53192 L p F P
0 0 0 r
s
0 1 .458 r
.43368 .53192 m .45391 .52462 L .48681 .55912 L p F P
0 0 0 r
s
.133 1 0 r
.65939 .48904 m .6444 .51692 L .60955 .5461 L p F P
0 0 0 r
s
1 .035 0 r
.8323 .37113 m .84674 .39186 L .88273 .37862 L p F P
0 0 0 r
s
1 .089 0 r
.84674 .39186 m .8323 .37113 L .79673 .3882 L p F P
0 0 0 r
s
1 .666 0 r
.71283 .43554 m .72746 .43403 L .76182 .40898 L p F P
0 0 0 r
s
1 .471 0 r
.33021 .43596 m .30953 .40915 L .27831 .40382 L p F P
0 0 0 r
s
1 .383 0 r
.25699 .37816 m .27831 .40382 L .30953 .40915 L p F P
0 0 0 r
s
1 .156 0 r
.27831 .40382 m .25699 .37816 L .22532 .38434 L p F P
0 0 0 r
s
1 .358 0 r
.74708 .39977 m .76182 .40898 L .79673 .3882 L p F P
0 0 0 r
s
1 .666 0 r
.76182 .40898 m .74708 .39977 L .71283 .43554 L p F P
0 0 0 r
s
.994 1 0 r
.30953 .40915 m .33021 .43596 L .36108 .46104 L p F P
0 0 0 r
s
1 .11 0 r
.20315 .36033 m .22532 .38434 L .25699 .37816 L p F P
0 0 0 r
s
1 .035 0 r
.88273 .37862 m .86852 .35644 L .8323 .37113 L p F P
0 0 0 r
s
1 .167 0 r
.78193 .37188 m .79673 .3882 L .8323 .37113 L p F P
0 0 0 r
s
1 .358 0 r
.79673 .3882 m .78193 .37188 L .74708 .39977 L p F P
0 0 0 r
s
0 .98 1 r
.52118 .59261 m .53981 .55096 L .57449 .55739 L p F P
0 0 0 r
s
0 1 .458 r
.53981 .55096 m .52118 .59261 L .48681 .55912 L p F P
0 0 0 r
s
.133 1 0 r
.43368 .53192 m .41296 .52843 L .38162 .48275 L p F P
0 0 0 r
s
1 .067 0 r
.81757 .35078 m .8323 .37113 L .86852 .35644 L p F P
0 0 0 r
s
1 .167 0 r
.8323 .37113 m .81757 .35078 L .78193 .37188 L p F P
0 0 0 r
s
1 .383 0 r
.30953 .40915 m .28865 .37888 L .25699 .37816 L p F P
0 0 0 r
s
1 .271 0 r
.23521 .35175 m .25699 .37816 L .28865 .37888 L p F P
0 0 0 r
s
1 .11 0 r
.25699 .37816 m .23521 .35175 L .20315 .36033 L p F P
0 0 0 r
s
.994 1 0 r
.36108 .46104 m .34064 .42902 L .30953 .40915 L p F P
0 0 0 r
s
1 .818 0 r
.28865 .37888 m .30953 .40915 L .34064 .42902 L p F P
0 0 0 r
s
1 .067 0 r
.18041 .33599 m .20315 .36033 L .23521 .35175 L p F P
0 0 0 r
s
1 .067 0 r
.86852 .35644 m .85399 .33404 L .81757 .35078 L p F P
0 0 0 r
s
0 1 .458 r
.48681 .55912 m .46655 .58308 L .43368 .53192 L p F P
0 0 0 r
s
0 .98 1 r
.41296 .52843 m .43368 .53192 L .46655 .58308 L p F P
0 0 0 r
s
0 .535 1 r
.46655 .58308 m .48681 .55912 L .52118 .59261 L p F P
0 0 0 r
s
0 .765 1 r
.55688 .60972 m .57449 .55739 L .60955 .5461 L p F P
0 0 0 r
s
0 .98 1 r
.57449 .55739 m .55688 .60972 L .52118 .59261 L p F P
0 0 0 r
s
1 .58 0 r
.73206 .39329 m .74708 .39977 L .78193 .37188 L p F P
0 0 0 r
s
.922 1 0 r
.74708 .39977 m .73206 .39329 L .6979 .44263 L p F P
0 0 0 r
s
.922 1 0 r
.6979 .44263 m .71283 .43554 L .74708 .39977 L p F P
0 0 0 r
s
1 .271 0 r
.76682 .35657 m .78193 .37188 L .81757 .35078 L p F P
0 0 0 r
s
1 .58 0 r
.78193 .37188 m .76682 .35657 L .73206 .39329 L p F P
0 0 0 r
s
1 .271 0 r
.28865 .37888 m .26739 .34759 L .23521 .35175 L p F P
0 0 0 r
s
1 .167 0 r
.21287 .32537 m .23521 .35175 L .26739 .34759 L p F P
0 0 0 r
s
1 .067 0 r
.23521 .35175 m .21287 .32537 L .18041 .33599 L p F P
0 0 0 r
s
1 .818 0 r
.34064 .42902 m .32025 .3904 L .28865 .37888 L p F P
0 0 0 r
s
1 .58 0 r
.26739 .34759 m .28865 .37888 L .32025 .3904 L p F P
0 0 0 r
s
1 .11 0 r
.8025 .33051 m .81757 .35078 L .85399 .33404 L p F P
0 0 0 r
s
1 .271 0 r
.81757 .35078 m .8025 .33051 L .76682 .35657 L p F P
0 0 0 r
s
0 .98 1 r
.59311 .59837 m .60955 .5461 L .6444 .51692 L p F P
0 0 0 r
s
0 .765 1 r
.60955 .5461 m .59311 .59837 L .55688 .60972 L p F P
0 0 0 r
s
0 .98 1 r
.6444 .51692 m .6289 .55829 L .59311 .59837 L p F P
0 0 0 r
s
1 .035 0 r
.15708 .31139 m .18041 .33599 L .21287 .32537 L p F P
0 0 0 r
s
1 .11 0 r
.85399 .33404 m .83911 .3113 L .8025 .33051 L p F P
0 0 0 r
s
.133 1 0 r
.39228 .50673 m .37199 .46652 L .34064 .42902 L p F P
0 0 0 r
s
.48 1 0 r
.32025 .3904 m .34064 .42902 L .37199 .46652 L p F P
0 0 0 r
s
1 .005 0 r
.38526 1.04824 m .40598 1.06315 L .44041 1.05512 L p F P
0 0 0 r
s
1 .58 0 r
.32025 .3904 m .29965 .35035 L .26739 .34759 L p F P
0 0 0 r
s
1 .358 0 r
.24557 .31717 m .26739 .34759 L .29965 .35035 L p F P
0 0 0 r
s
1 .167 0 r
.26739 .34759 m .24557 .31717 L .21287 .32537 L p F P
0 0 0 r
s
1 .089 0 r
.18991 .29929 m .21287 .32537 L .24557 .31717 L p F P
0 0 0 r
s
1 .035 0 r
.21287 .32537 m .18991 .29929 L .15708 .31139 L p F P
0 0 0 r
s
1 .383 0 r
.75121 .34035 m .76682 .35657 L .8025 .33051 L p F P
0 0 0 r
s
1 .818 0 r
.76682 .35657 m .75121 .34035 L .71642 .38569 L p F P
0 0 0 r
s
1 .818 0 r
.71642 .38569 m .73206 .39329 L .76682 .35657 L p F P
0 0 0 r
s
0 .98 1 r
.46655 .58308 m .44562 .59042 L .41296 .52843 L p F P
0 0 0 r
s
.48 1 0 r
.73206 .39329 m .71642 .38569 L .68221 .44842 L p F P
0 0 0 r
s
.48 1 0 r
.68221 .44842 m .6979 .44263 L .73206 .39329 L p F P
0 0 0 r
s
1 .156 0 r
.787 .3095 m .8025 .33051 L .83911 .3113 L p F P
0 0 0 r
s
1 .383 0 r
.8025 .33051 m .787 .3095 L .75121 .34035 L p F P
0 0 0 r
s
.48 1 0 r
.37199 .46652 m .35208 .41483 L .32025 .3904 L p F P
0 0 0 r
s
.922 1 0 r
.29965 .35035 m .32025 .3904 L .35208 .41483 L p F P
0 0 0 r
s
.257 0 1 r
.50131 .6336 m .52118 .59261 L .55688 .60972 L p F P
0 0 0 r
s
0 .535 1 r
.52118 .59261 m .50131 .6336 L .46655 .58308 L p F P
0 0 0 r
s
1 .015 0 r
.13313 .28648 m .15708 .31139 L .18991 .29929 L p F P
0 0 0 r
s
1 .015 0 r
.41998 1.04001 m .44041 1.05512 L .4753 1.04698 L p F P
0 0 0 r
s
1 .005 0 r
.44041 1.05512 m .41998 1.04001 L .38526 1.04824 L p F P
0 0 0 r
s
1 .156 0 r
.83911 .3113 m .82383 .28789 L .787 .3095 L p F P
0 0 0 r
s
0 1 .458 r
.6979 .44263 m .68221 .44842 L .64777 .52439 L p F P
0 0 0 r
s
0 1 .458 r
.64777 .52439 m .66375 .50122 L .6979 .44263 L p F P
0 0 0 r
s
1 .358 0 r
.29965 .35035 m .27849 .31277 L .24557 .31717 L p F P
0 0 0 r
s
1 .192 0 r
.22307 .28829 m .24557 .31717 L .27849 .31277 L p F P
0 0 0 r
s
1 .089 0 r
.24557 .31717 m .22307 .28829 L .18991 .29929 L p F P
0 0 0 r
s
.257 0 1 r
.44562 .59042 m .46655 .58308 L .50131 .6336 L p F P
0 0 0 r
s
.922 1 0 r
.35208 .41483 m .33216 .36126 L .29965 .35035 L p F P
0 0 0 r
s
1 .666 0 r
.27849 .31277 m .29965 .35035 L .33216 .36126 L p F P
0 0 0 r
s
1 .015 0 r
.36402 1.03295 m .38526 1.04824 L .41998 1.04001 L p F P
0 0 0 r
s
1 .035 0 r
.45519 1.03166 m .4753 1.04698 L .51068 1.03873 L p F P
0 0 0 r
s
1 .015 0 r
.4753 1.04698 m .45519 1.03166 L .41998 1.04001 L p F P
0 0 0 r
s
1 .041 0 r
.16628 .27341 m .18991 .29929 L .22307 .28829 L p F P
0 0 0 r
s
1 .015 0 r
.18991 .29929 m .16628 .27341 L .13313 .28648 L p F P
0 0 0 r
s
1 .471 0 r
.7349 .32067 m .75121 .34035 L .787 .3095 L p F P
0 0 0 r
s
.994 1 0 r
.75121 .34035 m .7349 .32067 L .69982 .37164 L p F P
0 0 0 r
s
.994 1 0 r
.69982 .37164 m .71642 .38569 L .75121 .34035 L p F P
0 0 0 r
s
1 .192 0 r
.77096 .28665 m .787 .3095 L .82383 .28789 L p F P
0 0 0 r
s
1 .471 0 r
.787 .3095 m .77096 .28665 L .7349 .32067 L p F P
0 0 0 r
s
0 .535 1 r
.61223 .599 m .6289 .55829 L .66375 .50122 L p F P
0 0 0 r
s
0 .535 1 r
.66375 .50122 m .64777 .52439 L .61223 .599 L p F P
0 0 0 r
s
1 .005 0 r
.10854 .26115 m .13313 .28648 L .16628 .27341 L p F P
0 0 0 r
s
1 .041 0 r
.39904 1.0245 m .41998 1.04001 L .45519 1.03166 L p F P
0 0 0 r
s
1 .015 0 r
.41998 1.04001 m .39904 1.0245 L .36402 1.03295 L p F P
0 0 0 r
s
1 .666 0 r
.33216 .36126 m .31173 .31282 L .27849 .31277 L p F P
0 0 0 r
s
1 .358 0 r
.25656 .27905 m .27849 .31277 L .31173 .31282 L p F P
0 0 0 r
s
1 .192 0 r
.27849 .31277 m .25656 .27905 L .22307 .28829 L p F P
0 0 0 r
s
1 .067 0 r
.49088 1.02319 m .51068 1.03873 L .54655 1.03036 L p F P
0 0 0 r
s
1 .035 0 r
.51068 1.03873 m .49088 1.02319 L .45519 1.03166 L p F P
0 0 0 r
s
1 .089 0 r
.19983 .26069 m .22307 .28829 L .25656 .27905 L p F P
0 0 0 r
s
1 .041 0 r
.22307 .28829 m .19983 .26069 L .16628 .27341 L p F P
0 0 0 r
s
.56 0 1 r
.53791 .66185 m .55688 .60972 L .59311 .59837 L p F P
0 0 0 r
s
.257 0 1 r
.55688 .60972 m .53791 .66185 L .50131 .6336 L p F P
0 0 0 r
s
.133 1 0 r
.71642 .38569 m .69982 .37164 L .66525 .44315 L p F P
0 0 0 r
s
.133 1 0 r
.66525 .44315 m .68221 .44842 L .71642 .38569 L p F P
0 0 0 r
s
0 .98 1 r
.42471 .56884 m .4044 .51782 L .37199 .46652 L p F P
0 0 0 r
s
0 1 .458 r
.35208 .41483 m .37199 .46652 L .4044 .51782 L p F P
0 0 0 r
s
1 .192 0 r
.82383 .28789 m .80809 .2634 L .77096 .28665 L p F P
0 0 0 r
s
0 1 .458 r
.4044 .51782 m .38478 .44903 L .35208 .41483 L p F P
0 0 0 r
s
.256 1 0 r
.33216 .36126 m .35208 .41483 L .38478 .44903 L p F P
0 0 0 r
s
1 .035 0 r
.34222 1.01727 m .36402 1.03295 L .39904 1.0245 L p F P
0 0 0 r
s
1 .015 0 r
.14198 .24742 m .16628 .27341 L .19983 .26069 L p F P
0 0 0 r
s
1 .005 0 r
.16628 .27341 m .14198 .24742 L .10854 .26115 L p F P
0 0 0 r
s
1 .089 0 r
.43455 1.01594 m .45519 1.03166 L .49088 1.02319 L p F P
0 0 0 r
s
1 .041 0 r
.45519 1.03166 m .43455 1.01594 L .39904 1.0245 L p F P
0 0 0 r
s
.257 0 1 r
.6289 .55829 m .61223 .599 L .57535 .65046 L p F P
0 0 0 r
s
.257 0 1 r
.57535 .65046 m .59311 .59837 L .6289 .55829 L p F P
0 0 0 r
s
1 .11 0 r
.52708 1.01461 m .54655 1.03036 L .58292 1.02188 L p F P
0 0 0 r
s
1 .067 0 r
.54655 1.03036 m .52708 1.01461 L .49088 1.02319 L p F P
0 0 0 r
s
.256 1 0 r
.38478 .44903 m .36537 .3781 L .33216 .36126 L p F P
0 0 0 r
s
.922 1 0 r
.31173 .31282 m .33216 .36126 L .36537 .3781 L p F P
0 0 0 r
s
.56 0 1 r
.59311 .59837 m .57535 .65046 L .53791 .66185 L p F P
0 0 0 r
s
1 .358 0 r
.31173 .31282 m .29044 .27187 L .25656 .27905 L p F P
0 0 0 r
s
1 .167 0 r
.23379 .24861 m .25656 .27905 L .29044 .27187 L p F P
0 0 0 r
s
1 .089 0 r
.25656 .27905 m .23379 .24861 L .19983 .26069 L p F P
0 0 0 r
s
1 .205 0 r
.75432 .26117 m .77096 .28665 L .80809 .2634 L p F P
0 0 0 r
s
1 .505 0 r
.77096 .28665 m .75432 .26117 L .71778 .29562 L p F P
0 0 0 r
s
1 .505 0 r
.71778 .29562 m .7349 .32067 L .77096 .28665 L p F P
0 0 0 r
s
.922 1 0 r
.36537 .3781 m .34555 .31596 L .31173 .31282 L p F P
0 0 0 r
s
1 .58 0 r
.29044 .27187 m .31173 .31282 L .34555 .31596 L p F P
0 0 0 r
s
.923 1 0 r
.7349 .32067 m .71778 .29562 L .68214 .3471 L p F P
0 0 0 r
s
.923 1 0 r
.68214 .3471 m .69982 .37164 L .7349 .32067 L p F P
0 0 0 r
s
0 .98 1 r
.68221 .44842 m .66525 .44315 L .63024 .53065 L p F P
0 0 0 r
s
0 .98 1 r
.63024 .53065 m .64777 .52439 L .68221 .44842 L p F P
0 0 0 r
s
1 .089 0 r
.37755 1.0086 m .39904 1.0245 L .43455 1.01594 L p F P
0 0 0 r
s
1 .035 0 r
.39904 1.0245 m .37755 1.0086 L .34222 1.01727 L p F P
0 0 0 r
s
1 .167 0 r
.47056 1.00726 m .49088 1.02319 L .52708 1.01461 L p F P
0 0 0 r
s
1 .089 0 r
.49088 1.02319 m .47056 1.00726 L .43455 1.01594 L p F P
0 0 0 r
s
1 .035 0 r
.17586 .2337 m .19983 .26069 L .23379 .24861 L p F P
0 0 0 r
s
1 .015 0 r
.19983 .26069 m .17586 .2337 L .14198 .24742 L p F P
0 0 0 r
s
.257 0 1 r
.50131 .6336 m .48045 .65222 L .44562 .59042 L p F P
0 0 0 r
s
.56 0 1 r
.42471 .56884 m .44562 .59042 L .48045 .65222 L p F P
0 0 0 r
s
1 .156 0 r
.56378 1.00591 m .58292 1.02188 L .6198 1.01328 L p F P
0 0 0 r
s
1 .11 0 r
.58292 1.02188 m .56378 1.00591 L .52708 1.01461 L p F P
0 0 0 r
s
1 .205 0 r
.80809 .2634 m .79187 .23752 L .75432 .26117 L p F P
0 0 0 r
s
1 .067 0 r
.31986 1.00117 m .34222 1.01727 L .37755 1.0086 L p F P
0 0 0 r
s
0 1 0 r
.69982 .37164 m .68214 .3471 L .64687 .41923 L p F P
0 0 0 r
s
0 1 0 r
.64687 .41923 m .66525 .44315 L .69982 .37164 L p F P
0 0 0 r
s
1 0 .769 r
.48045 .65222 m .50131 .6336 L .53791 .66185 L p F P
0 0 0 r
s
1 .192 0 r
.41337 .99981 m .43455 1.01594 L .47056 1.00726 L p F P
0 0 0 r
s
1 .089 0 r
.43455 1.01594 m .41337 .99981 L .37755 1.0086 L p F P
0 0 0 r
s
1 .58 0 r
.34555 .31596 m .32485 .26604 L .29044 .27187 L p F P
0 0 0 r
s
1 .271 0 r
.26819 .23728 m .29044 .27187 L .32485 .26604 L p F P
0 0 0 r
s
1 .167 0 r
.29044 .27187 m .26819 .23728 L .23379 .24861 L p F P
0 0 0 r
s
1 .271 0 r
.50709 .99845 m .52708 1.01461 L .56378 1.00591 L p F P
0 0 0 r
s
1 .167 0 r
.52708 1.01461 m .50709 .99845 L .47056 1.00726 L p F P
0 0 0 r
s
1 .067 0 r
.21021 .22009 m .23379 .24861 L .26819 .23728 L p F P
0 0 0 r
s
1 .035 0 r
.23379 .24861 m .21021 .22009 L .17586 .2337 L p F P
0 0 0 r
s
1 .192 0 r
.60101 .99708 m .6198 1.01328 L .6572 1.00456 L p F P
0 0 0 r
s
1 .156 0 r
.6198 1.01328 m .60101 .99708 L .56378 1.00591 L p F P
0 0 0 r
s
1 .192 0 r
.73708 .23299 m .75432 .26117 L .79187 .23752 L p F P
0 0 0 r
s
1 .471 0 r
.75432 .26117 m .73708 .23299 L .6999 .26511 L p F P
0 0 0 r
s
1 .471 0 r
.6999 .26511 m .71778 .29562 L .75432 .26117 L p F P
0 0 0 r
s
.48 1 0 r
.39984 .3939 m .38032 .31828 L .34555 .31596 L p F P
0 0 0 r
s
.48 1 0 r
.34555 .31596 m .36537 .3781 L .39984 .3939 L p F P
0 0 0 r
s
1 .818 0 r
.32485 .26604 m .34555 .31596 L .38032 .31828 L p F P
0 0 0 r
s
0 1 .458 r
.41911 .48225 m .39984 .3939 L .36537 .3781 L p F P
0 0 0 r
s
0 1 .458 r
.36537 .3781 m .38478 .44903 L .41911 .48225 L p F P
0 0 0 r
s
.994 1 0 r
.71778 .29562 m .6999 .26511 L .6635 .31191 L p F P
0 0 0 r
s
.994 1 0 r
.6635 .31191 m .68214 .3471 L .71778 .29562 L p F P
0 0 0 r
s
1 .167 0 r
.35549 .99228 m .37755 1.0086 L .41337 .99981 L p F P
0 0 0 r
s
1 .067 0 r
.37755 1.0086 m .35549 .99228 L .31986 1.00117 L p F P
0 0 0 r
s
1 .358 0 r
.44971 .9909 m .47056 1.00726 L .50709 .99845 L p F P
0 0 0 r
s
1 .192 0 r
.47056 1.00726 m .44971 .9909 L .41337 .99981 L p F P
0 0 0 r
s
.257 0 1 r
.64777 .52439 m .63024 .53065 L .59385 .61711 L p F P
0 0 0 r
s
.257 0 1 r
.59385 .61711 m .61223 .599 L .64777 .52439 L p F P
0 0 0 r
s
.56 0 1 r
.48045 .65222 m .45935 .6308 L .42471 .56884 L p F P
0 0 0 r
s
.257 0 1 r
.4044 .51782 m .42471 .56884 L .45935 .6308 L p F P
0 0 0 r
s
1 .383 0 r
.54413 .98951 m .56378 1.00591 L .60101 .99708 L p F P
0 0 0 r
s
1 .271 0 r
.56378 1.00591 m .54413 .98951 L .50709 .99845 L p F P
0 0 0 r
s
0 .535 1 r
.43881 .56854 m .41911 .48225 L .38478 .44903 L p F P
0 0 0 r
s
0 .535 1 r
.38478 .44903 m .4044 .51782 L .43881 .56854 L p F P
0 0 0 r
s
1 .192 0 r
.79187 .23752 m .77515 .21022 L .73708 .23299 L p F P
0 0 0 r
s
1 .205 0 r
.63877 .98813 m .6572 1.00456 L .69513 .99571 L p F P
0 0 0 r
s
1 .192 0 r
.6572 1.00456 m .63877 .98813 L .60101 .99708 L p F P
0 0 0 r
s
1 .271 0 r
.32485 .26604 m .3031 .22641 L .26819 .23728 L p F P
0 0 0 r
s
1 .11 0 r
.24502 .20662 m .26819 .23728 L .3031 .22641 L p F P
0 0 0 r
s
1 .067 0 r
.26819 .23728 m .24502 .20662 L .21021 .22009 L p F P
0 0 0 r
s
1 .818 0 r
.38032 .31828 m .35999 .25967 L .32485 .26604 L p F P
0 0 0 r
s
1 .383 0 r
.3031 .22641 m .32485 .26604 L .35999 .25967 L p F P
0 0 0 r
s
.257 0 1 r
.45935 .6308 m .43881 .56854 L .4044 .51782 L p F P
0 0 0 r
s
1 .11 0 r
.29691 .98465 m .31986 1.00117 L .35549 .99228 L p F P
0 0 0 r
s
0 .765 1 r
.66525 .44315 m .64687 .41923 L .61105 .50747 L p F P
0 0 0 r
s
0 .765 1 r
.61105 .50747 m .63024 .53065 L .66525 .44315 L p F P
0 0 0 r
s
.133 1 0 r
.68214 .3471 m .6635 .31191 L .62735 .37637 L p F P
0 0 0 r
s
.133 1 0 r
.62735 .37637 m .64687 .41923 L .68214 .3471 L p F P
0 0 0 r
s
1 .358 0 r
.39163 .98325 m .41337 .99981 L .44971 .9909 L p F P
0 0 0 r
s
1 .167 0 r
.41337 .99981 m .39163 .98325 L .35549 .99228 L p F P
0 0 0 r
s
1 .58 0 r
.48657 .98185 m .50709 .99845 L .54413 .98951 L p F P
0 0 0 r
s
1 .358 0 r
.50709 .99845 m .48657 .98185 L .44971 .9909 L p F P
0 0 0 r
s
1 .471 0 r
.58171 .98045 m .60101 .99708 L .63877 .98813 L p F P
0 0 0 r
s
1 .383 0 r
.60101 .99708 m .58171 .98045 L .54413 .98951 L p F P
0 0 0 r
s
1 .192 0 r
.67707 .97905 m .69513 .99571 L .73361 .98674 L p F P
0 0 0 r
s
1 .205 0 r
.69513 .99571 m .67707 .97905 L .63877 .98813 L p F P
0 0 0 r
s
1 .383 0 r
.68145 .23094 m .6999 .26511 L .73708 .23299 L p F P
0 0 0 r
s
1 .818 0 r
.6999 .26511 m .68145 .23094 L .64423 .26989 L p F P
0 0 0 r
s
1 .818 0 r
.64423 .26989 m .6635 .31191 L .6999 .26511 L p F P
0 0 0 r
s
1 .156 0 r
.71931 .20285 m .73708 .23299 L .77515 .21022 L p F P
0 0 0 r
s
1 .383 0 r
.73708 .23299 m .71931 .20285 L .68145 .23094 L p F P
0 0 0 r
s
1 .383 0 r
.35999 .25967 m .33861 .21516 L .3031 .22641 L p F P
0 0 0 r
s
1 .156 0 r
.28034 .19319 m .3031 .22641 L .33861 .21516 L p F P
0 0 0 r
s
1 .11 0 r
.3031 .22641 m .28034 .19319 L .24502 .20662 L p F P
0 0 0 r
s
.133 1 0 r
.43588 .39881 m .41623 .31443 L .38032 .31828 L p F P
0 0 0 r
s
.133 1 0 r
.38032 .31828 m .39984 .3939 L .43588 .39881 L p F P
0 0 0 r
s
.994 1 0 r
.35999 .25967 m .38032 .31828 L .41623 .31443 L p F P
0 0 0 r
s
1 0 .398 r
.51757 .68795 m .53791 .66185 L .57535 .65046 L p F P
0 0 0 r
s
1 0 .769 r
.53791 .66185 m .51757 .68795 L .48045 .65222 L p F P
0 0 0 r
s
1 .271 0 r
.33284 .97552 m .35549 .99228 L .39163 .98325 L p F P
0 0 0 r
s
1 .11 0 r
.35549 .99228 m .33284 .97552 L .29691 .98465 L p F P
0 0 0 r
s
.994 1 0 r
.41623 .31443 m .39596 .25018 L .35999 .25967 L p F P
0 0 0 r
s
1 .471 0 r
.33861 .21516 m .35999 .25967 L .39596 .25018 L p F P
0 0 0 r
s
1 .666 0 r
.4283 .9741 m .44971 .9909 L .48657 .98185 L p F P
0 0 0 r
s
1 .358 0 r
.44971 .9909 m .4283 .9741 L .39163 .98325 L p F P
0 0 0 r
s
1 0 .398 r
.57535 .65046 m .55594 .67643 L .51757 .68795 L p F P
0 0 0 r
s
1 0 .769 r
.61223 .599 m .59385 .61711 L .55594 .67643 L p F P
0 0 0 r
s
1 0 .769 r
.55594 .67643 m .57535 .65046 L .61223 .599 L p F P
0 0 0 r
s
1 .818 0 r
.52396 .97268 m .54413 .98951 L .58171 .98045 L p F P
0 0 0 r
s
1 .58 0 r
.54413 .98951 m .52396 .97268 L .48657 .98185 L p F P
0 0 0 r
s
.48 1 0 r
.6635 .31191 m .64423 .26989 L .60725 .32176 L p F P
0 0 0 r
s
.48 1 0 r
.60725 .32176 m .62735 .37637 L .6635 .31191 L p F P
0 0 0 r
s
1 .156 0 r
.77515 .21022 m .75796 .18173 L .71931 .20285 L p F P
0 0 0 r
s
1 .505 0 r
.61984 .97126 m .63877 .98813 L .67707 .97905 L p F P
0 0 0 r
s
1 .471 0 r
.63877 .98813 m .61984 .97126 L .58171 .98045 L p F P
0 0 0 r
s
0 .98 1 r
.45548 .49862 m .43588 .39881 L .39984 .3939 L p F P
0 0 0 r
s
0 .98 1 r
.39984 .3939 m .41911 .48225 L .45548 .49862 L p F P
0 0 0 r
s
1 .156 0 r
.71593 .96983 m .73361 .98674 L .77264 .97764 L p F P
0 0 0 r
s
1 .192 0 r
.73361 .98674 m .71593 .96983 L .67707 .97905 L p F P
0 0 0 r
s
1 0 .398 r
.45935 .6308 m .48045 .65222 L .51757 .68795 L p F P
0 0 0 r
s
1 .156 0 r
.27333 .96769 m .29691 .98465 L .33284 .97552 L p F P
0 0 0 r
s
0 .98 1 r
.64687 .41923 m .62735 .37637 L .5907 .45435 L p F P
0 0 0 r
s
0 .98 1 r
.5907 .45435 m .61105 .50747 L .64687 .41923 L p F P
0 0 0 r
s
1 .58 0 r
.36931 .96625 m .39163 .98325 L .4283 .9741 L p F P
0 0 0 r
s
1 .271 0 r
.39163 .98325 m .36931 .96625 L .33284 .97552 L p F P
0 0 0 r
s
1 .471 0 r
.39596 .25018 m .3748 .20247 L .33861 .21516 L p F P
0 0 0 r
s
1 .192 0 r
.31622 .17948 m .33861 .21516 L .3748 .20247 L p F P
0 0 0 r
s
1 .156 0 r
.33861 .21516 m .31622 .17948 L .28034 .19319 L p F P
0 0 0 r
s
.922 1 0 r
.4655 .96481 m .48657 .98185 L .52396 .97268 L p F P
0 0 0 r
s
1 .666 0 r
.48657 .98185 m .4655 .96481 L .4283 .9741 L p F P
0 0 0 r
s
1 .271 0 r
.66259 .19561 m .68145 .23094 L .71931 .20285 L p F P
0 0 0 r
s
1 .58 0 r
.68145 .23094 m .66259 .19561 L .62464 .22635 L p F P
0 0 0 r
s
1 .58 0 r
.62464 .22635 m .64423 .26989 L .68145 .23094 L p F P
0 0 0 r
s
.994 1 0 r
.5619 .96337 m .58171 .98045 L .61984 .97126 L p F P
0 0 0 r
s
1 .818 0 r
.58171 .98045 m .5619 .96337 L .52396 .97268 L p F P
0 0 0 r
s
.923 1 0 r
.45318 .30039 m .43276 .23568 L .39596 .25018 L p F P
0 0 0 r
s
.923 1 0 r
.39596 .25018 m .41623 .31443 L .45318 .30039 L p F P
0 0 0 r
s
1 .505 0 r
.3748 .20247 m .39596 .25018 L .43276 .23568 L p F P
0 0 0 r
s
0 1 0 r
.47324 .38528 m .45318 .30039 L .41623 .31443 L p F P
0 0 0 r
s
0 1 0 r
.41623 .31443 m .43588 .39881 L .47324 .38528 L p F P
0 0 0 r
s
.922 1 0 r
.64423 .26989 m .62464 .22635 L .58698 .26523 L p F P
0 0 0 r
s
.922 1 0 r
.58698 .26523 m .60725 .32176 L .64423 .26989 L p F P
0 0 0 r
s
1 .471 0 r
.65852 .96193 m .67707 .97905 L .71593 .96983 L p F P
0 0 0 r
s
1 .505 0 r
.67707 .97905 m .65852 .96193 L .61984 .97126 L p F P
0 0 0 r
s
.56 0 1 r
.63024 .53065 m .61105 .50747 L .57384 .59473 L p F P
0 0 0 r
s
.56 0 1 r
.57384 .59473 m .59385 .61711 L .63024 .53065 L p F P
0 0 0 r
s
1 .11 0 r
.7011 .1718 m .71931 .20285 L .75796 .18173 L p F P
0 0 0 r
s
1 .271 0 r
.71931 .20285 m .7011 .1718 L .66259 .19561 L p F P
0 0 0 r
s
1 .11 0 r
.75536 .96048 m .77264 .97764 L .81224 .9684 L p F P
0 0 0 r
s
1 .156 0 r
.77264 .97764 m .75536 .96048 L .71593 .96983 L p F P
0 0 0 r
s
.257 0 1 r
.47563 .59662 m .45548 .49862 L .41911 .48225 L p F P
0 0 0 r
s
.257 0 1 r
.41911 .48225 m .43881 .56854 L .47563 .59662 L p F P
0 0 0 r
s
0 1 .458 r
.62735 .37637 m .60725 .32176 L .56994 .38319 L p F P
0 0 0 r
s
0 1 .458 r
.56994 .38319 m .5907 .45435 L .62735 .37637 L p F P
0 0 0 r
s
1 .383 0 r
.30959 .9583 m .33284 .97552 L .36931 .96625 L p F P
0 0 0 r
s
1 .156 0 r
.33284 .97552 m .30959 .9583 L .27333 .96769 L p F P
0 0 0 r
s
.922 1 0 r
.4063 .95685 m .4283 .9741 L .4655 .96481 L p F P
0 0 0 r
s
1 .58 0 r
.4283 .9741 m .4063 .95685 L .36931 .96625 L p F P
0 0 0 r
s
.48 1 0 r
.50324 .95539 m .52396 .97268 L .5619 .96337 L p F P
0 0 0 r
s
.922 1 0 r
.52396 .97268 m .50324 .95539 L .4655 .96481 L p F P
0 0 0 r
s
1 .505 0 r
.43276 .23568 m .41165 .18754 L .3748 .20247 L p F P
0 0 0 r
s
1 .205 0 r
.35268 .16509 m .3748 .20247 L .41165 .18754 L p F P
0 0 0 r
s
1 .192 0 r
.3748 .20247 m .35268 .16509 L .31622 .17948 L p F P
0 0 0 r
s
1 .11 0 r
.75796 .18173 m .7403 .15243 L .7011 .1718 L p F P
0 0 0 r
s
.256 1 0 r
.60725 .32176 m .58698 .26523 L .54924 .30987 L p F P
0 0 0 r
s
.256 1 0 r
.54924 .30987 m .56994 .38319 L .60725 .32176 L p F P
0 0 0 r
s
.923 1 0 r
.6004 .95393 m .61984 .97126 L .65852 .96193 L p F P
0 0 0 r
s
.994 1 0 r
.61984 .97126 m .6004 .95393 L .5619 .96337 L p F P
0 0 0 r
s
.994 1 0 r
.49079 .2761 m .47019 .21614 L .43276 .23568 L p F P
0 0 0 r
s
.994 1 0 r
.43276 .23568 m .45318 .30039 L .49079 .2761 L p F P
0 0 0 r
s
1 .471 0 r
.41165 .18754 m .43276 .23568 L .47019 .21614 L p F P
0 0 0 r
s
0 .765 1 r
.49344 .48567 m .47324 .38528 L .43588 .39881 L p F P
0 0 0 r
s
0 .765 1 r
.43588 .39881 m .45548 .49862 L .49344 .48567 L p F P
0 0 0 r
s
.133 1 0 r
.51125 .35319 m .49079 .2761 L .45318 .30039 L p F P
0 0 0 r
s
.133 1 0 r
.45318 .30039 m .47324 .38528 L .51125 .35319 L p F P
0 0 0 r
s
1 .358 0 r
.60485 .18525 m .62464 .22635 L .66259 .19561 L p F P
0 0 0 r
s
1 .666 0 r
.62464 .22635 m .60485 .18525 L .56668 .21386 L p F P
0 0 0 r
s
1 .666 0 r
.56668 .21386 m .58698 .26523 L .62464 .22635 L p F P
0 0 0 r
s
1 .383 0 r
.69777 .95246 m .71593 .96983 L .75536 .96048 L p F P
0 0 0 r
s
1 .471 0 r
.71593 .96983 m .69777 .95246 L .65852 .96193 L p F P
0 0 0 r
s
1 .067 0 r
.79537 .95099 m .81224 .9684 L .85242 .95903 L p F P
0 0 0 r
s
1 .11 0 r
.81224 .9684 m .79537 .95099 L .75536 .96048 L p F P
0 0 0 r
s
1 .167 0 r
.64339 .16103 m .66259 .19561 L .7011 .1718 L p F P
0 0 0 r
s
1 .358 0 r
.66259 .19561 m .64339 .16103 L .60485 .18525 L p F P
0 0 0 r
s
.922 1 0 r
.58698 .26523 m .56668 .21386 L .52869 .24547 L p F P
0 0 0 r
s
.922 1 0 r
.52869 .24547 m .54924 .30987 L .58698 .26523 L p F P
0 0 0 r
s
1 0 .398 r
.51757 .68795 m .4965 .66654 L .45935 .6308 L p F P
0 0 0 r
s
1 0 .769 r
.43881 .56854 m .45935 .6308 L .4965 .66654 L p F P
0 0 0 r
s
1 .192 0 r
.24912 .95026 m .27333 .96769 L .30959 .9583 L p F P
0 0 0 r
s
1 0 .769 r
.4965 .66654 m .47563 .59662 L .43881 .56854 L p F P
0 0 0 r
s
1 .818 0 r
.34637 .94878 m .36931 .96625 L .4063 .95685 L p F P
0 0 0 r
s
1 .383 0 r
.36931 .96625 m .34637 .94878 L .30959 .9583 L p F P
0 0 0 r
s
.48 1 0 r
.54924 .30987 m .52869 .24547 L .49079 .2761 L p F P
0 0 0 r
s
.48 1 0 r
.49079 .2761 m .51125 .35319 L .54924 .30987 L p F P
0 0 0 r
s
1 .818 0 r
.47019 .21614 m .49079 .2761 L .52869 .24547 L p F P
0 0 0 r
s
.256 1 0 r
.44385 .94731 m .4655 .96481 L .50324 .95539 L p F P
0 0 0 r
s
.922 1 0 r
.4655 .96481 m .44385 .94731 L .4063 .95685 L p F P
0 0 0 r
s
1 .58 0 r
.50805 .19341 m .52869 .24547 L .56668 .21386 L p F P
0 0 0 r
s
1 .818 0 r
.52869 .24547 m .50805 .19341 L .47019 .21614 L p F P
0 0 0 r
s
1 .383 0 r
.4491 .17035 m .47019 .21614 L .50805 .19341 L p F P
0 0 0 r
s
1 .471 0 r
.47019 .21614 m .4491 .17035 L .41165 .18754 L p F P
0 0 0 r
s
0 1 .458 r
.56994 .38319 m .54924 .30987 L .51125 .35319 L p F P
0 0 0 r
s
.133 1 0 r
.54155 .94583 m .5619 .96337 L .6004 .95393 L p F P
0 0 0 r
s
.48 1 0 r
.5619 .96337 m .54155 .94583 L .50324 .95539 L p F P
0 0 0 r
s
1 .192 0 r
.38974 .14973 m .41165 .18754 L .4491 .17035 L p F P
0 0 0 r
s
1 .205 0 r
.41165 .18754 m .38974 .14973 L .35268 .16509 L p F P
0 0 0 r
s
1 .067 0 r
.68248 .14061 m .7011 .1718 L .7403 .15243 L p F P
0 0 0 r
s
1 .167 0 r
.7011 .1718 m .68248 .14061 L .64339 .16103 L p F P
0 0 0 r
s
1 .358 0 r
.54625 .17004 m .56668 .21386 L .60485 .18525 L p F P
0 0 0 r
s
1 .58 0 r
.56668 .21386 m .54625 .17004 L .50805 .19341 L p F P
0 0 0 r
s
.994 1 0 r
.63947 .94434 m .65852 .96193 L .69777 .95246 L p F P
0 0 0 r
s
.923 1 0 r
.65852 .96193 m .63947 .94434 L .6004 .95393 L p F P
0 0 0 r
s
.257 0 1 r
.61105 .50747 m .5907 .45435 L .55291 .53106 L p F P
0 0 0 r
s
.257 0 1 r
.55291 .53106 m .57384 .59473 L .61105 .50747 L p F P
0 0 0 r
s
0 .98 1 r
.53191 .44314 m .51125 .35319 L .47324 .38528 L p F P
0 0 0 r
s
0 .98 1 r
.47324 .38528 m .49344 .48567 L .53191 .44314 L p F P
0 0 0 r
s
1 .271 0 r
.73761 .94286 m .75536 .96048 L .79537 .95099 L p F P
0 0 0 r
s
1 .383 0 r
.75536 .96048 m .73761 .94286 L .69777 .95246 L p F P
0 0 0 r
s
0 1 .458 r
.51125 .35319 m .53191 .44314 L .56994 .38319 L p F P
0 0 0 r
s
0 .535 1 r
.5907 .45435 m .56994 .38319 L .53191 .44314 L p F P
0 0 0 r
s
1 .192 0 r
.58482 .14797 m .60485 .18525 L .64339 .16103 L p F P
0 0 0 r
s
1 .358 0 r
.60485 .18525 m .58482 .14797 L .54625 .17004 L p F P
0 0 0 r
s
1 .035 0 r
.83598 .94137 m .85242 .95903 L .89319 .94952 L p F P
0 0 0 r
s
1 .067 0 r
.85242 .95903 m .83598 .94137 L .79537 .95099 L p F P
0 0 0 r
s
1 .471 0 r
.28569 .94062 m .30959 .9583 L .34637 .94878 L p F P
0 0 0 r
s
1 .192 0 r
.30959 .9583 m .28569 .94062 L .24912 .95026 L p F P
0 0 0 r
s
1 .271 0 r
.48707 .15168 m .50805 .19341 L .54625 .17004 L p F P
0 0 0 r
s
1 .383 0 r
.50805 .19341 m .48707 .15168 L .4491 .17035 L p F P
0 0 0 r
s
1 0 .398 r
.59385 .61711 m .57384 .59473 L .53524 .65469 L p F P
0 0 0 r
s
1 0 .398 r
.53524 .65469 m .55594 .67643 L .59385 .61711 L p F P
0 0 0 r
s
.48 1 0 r
.38371 .93912 m .4063 .95685 L .44385 .94731 L p F P
0 0 0 r
s
1 .818 0 r
.4063 .95685 m .38371 .93912 L .34637 .94878 L p F P
0 0 0 r
s
1 0 0 r
.4965 .66654 m .51757 .68795 L .55594 .67643 L p F P
0 0 0 r
s
0 .535 1 r
.53191 .44314 m .55291 .53106 L .5907 .45435 L p F P
0 0 0 r
s
1 .067 0 r
.7403 .15243 m .7222 .12259 L .68248 .14061 L p F P
0 0 0 r
s
0 1 .458 r
.48195 .93762 m .50324 .95539 L .54155 .94583 L p F P
0 0 0 r
s
.256 1 0 r
.50324 .95539 m .48195 .93762 L .44385 .94731 L p F P
0 0 0 r
s
.56 0 1 r
.51416 .58427 m .49344 .48567 L .45548 .49862 L p F P
0 0 0 r
s
.56 0 1 r
.45548 .49862 m .47563 .59662 L .51416 .58427 L p F P
0 0 0 r
s
1 .156 0 r
.42737 .1334 m .4491 .17035 L .48707 .15168 L p F P
0 0 0 r
s
1 .192 0 r
.4491 .17035 m .42737 .1334 L .38974 .14973 L p F P
0 0 0 r
s
1 .089 0 r
.62385 .12791 m .64339 .16103 L .68248 .14061 L p F P
0 0 0 r
s
1 .192 0 r
.64339 .16103 m .62385 .12791 L .58482 .14797 L p F P
0 0 0 r
s
0 1 0 r
.58042 .93612 m .6004 .95393 L .63947 .94434 L p F P
0 0 0 r
s
.133 1 0 r
.6004 .95393 m .58042 .93612 L .54155 .94583 L p F P
0 0 0 r
s
1 .818 0 r
.67912 .93462 m .69777 .95246 L .73761 .94286 L p F P
0 0 0 r
s
.994 1 0 r
.69777 .95246 m .67912 .93462 L .63947 .94434 L p F P
0 0 0 r
s
1 .167 0 r
.52551 .1326 m .54625 .17004 L .58482 .14797 L p F P
0 0 0 r
s
1 .271 0 r
.54625 .17004 m .52551 .1326 L .48707 .15168 L p F P
0 0 0 r
s
1 .167 0 r
.77804 .93311 m .79537 .95099 L .83598 .94137 L p F P
0 0 0 r
s
1 .271 0 r
.79537 .95099 m .77804 .93311 L .73761 .94286 L p F P
0 0 0 r
s
1 .205 0 r
.22424 .93235 m .24912 .95026 L .28569 .94062 L p F P
0 0 0 r
s
1 .015 0 r
.87719 .93159 m .89319 .94952 L .93457 .93987 L p F P
0 0 0 r
s
1 .035 0 r
.89319 .94952 m .87719 .93159 L .83598 .94137 L p F P
0 0 0 r
s
.994 1 0 r
.32281 .93084 m .34637 .94878 L .38371 .93912 L p F P
0 0 0 r
s
1 .471 0 r
.34637 .94878 m .32281 .93084 L .28569 .94062 L p F P
0 0 0 r
s
.257 0 1 r
.55291 .53106 m .53191 .44314 L .49344 .48567 L p F P
0 0 0 r
s
0 1 .458 r
.4216 .92932 m .44385 .94731 L .48195 .93762 L p F P
0 0 0 r
s
.48 1 0 r
.44385 .94731 m .4216 .92932 L .38371 .93912 L p F P
0 0 0 r
s
1 0 0 r
.55594 .67643 m .53524 .65469 L .4965 .66654 L p F P
0 0 0 r
s
1 .035 0 r
.66343 .10958 m .68248 .14061 L .7222 .12259 L p F P
0 0 0 r
s
1 .089 0 r
.68248 .14061 m .66343 .10958 L .62385 .12791 L p F P
0 0 0 r
s
1 .11 0 r
.46556 .11637 m .48707 .15168 L .52551 .1326 L p F P
0 0 0 r
s
1 .156 0 r
.48707 .15168 m .46556 .11637 L .42737 .1334 L p F P
0 0 0 r
s
1 .089 0 r
.56443 .11391 m .58482 .14797 L .62385 .12791 L p F P
0 0 0 r
s
1 .167 0 r
.58482 .14797 m .56443 .11391 L .52551 .1326 L p F P
0 0 0 r
s
0 .98 1 r
.52063 .9278 m .54155 .94583 L .58042 .93612 L p F P
0 0 0 r
s
0 1 .458 r
.54155 .94583 m .52063 .9278 L .48195 .93762 L p F P
0 0 0 r
s
.257 0 1 r
.49344 .48567 m .51416 .58427 L .55291 .53106 L p F P
0 0 0 r
s
.133 1 0 r
.61988 .92627 m .63947 .94434 L .67912 .93462 L p F P
0 0 0 r
s
0 1 0 r
.63947 .94434 m .61988 .92627 L .58042 .93612 L p F P
0 0 0 r
s
1 .58 0 r
.71936 .92474 m .73761 .94286 L .77804 .93311 L p F P
0 0 0 r
s
1 .818 0 r
.73761 .94286 m .71936 .92474 L .67912 .93462 L p F P
0 0 0 r
s
1 .089 0 r
.81908 .92321 m .83598 .94137 L .87719 .93159 L p F P
0 0 0 r
s
1 .167 0 r
.83598 .94137 m .81908 .92321 L .77804 .93311 L p F P
0 0 0 r
s
1 0 .398 r
.53524 .65469 m .51416 .58427 L .47563 .59662 L p F P
0 0 0 r
s
1 0 .398 r
.47563 .59662 m .4965 .66654 L .53524 .65469 L p F P
0 0 0 r
s
1 .505 0 r
.26113 .92244 m .28569 .94062 L .32281 .93084 L p F P
0 0 0 r
s
1 .205 0 r
.28569 .94062 m .26113 .92244 L .22424 .93235 L p F P
0 0 0 r
s
1 .005 0 r
.91902 .92167 m .93457 .93987 L .97657 .93008 L p F P
0 0 0 r
s
1 .015 0 r
.93457 .93987 m .91902 .92167 L .87719 .93159 L p F P
0 0 0 r
s
1 0 .769 r
.57384 .59473 m .55291 .53106 L .51416 .58427 L p F P
0 0 0 r
s
1 0 .769 r
.51416 .58427 m .53524 .65469 L .57384 .59473 L p F P
0 0 0 r
s
.133 1 0 r
.36048 .9209 m .38371 .93912 L .4216 .92932 L p F P
0 0 0 r
s
.994 1 0 r
.38371 .93912 m .36048 .9209 L .32281 .93084 L p F P
0 0 0 r
s
1 .067 0 r
.50429 .09903 m .52551 .1326 L .56443 .11391 L p F P
0 0 0 r
s
1 .11 0 r
.52551 .1326 m .50429 .09903 L .46556 .11637 L p F P
0 0 0 r
s
1 .041 0 r
.60389 .09594 m .62385 .12791 L .66343 .10958 L p F P
0 0 0 r
s
1 .089 0 r
.62385 .12791 m .60389 .09594 L .56443 .11391 L p F P
0 0 0 r
s
1 .035 0 r
.7222 .12259 m .70363 .0923 L .66343 .10958 L p F P
0 0 0 r
s
0 .535 1 r
.46007 .91936 m .48195 .93762 L .52063 .9278 L p F P
0 0 0 r
s
0 1 .458 r
.48195 .93762 m .46007 .91936 L .4216 .92932 L p F P
0 0 0 r
s
0 .765 1 r
.55989 .91782 m .58042 .93612 L .61988 .92627 L p F P
0 0 0 r
s
0 .98 1 r
.58042 .93612 m .55989 .91782 L .52063 .9278 L p F P
0 0 0 r
s
.48 1 0 r
.65994 .91627 m .67912 .93462 L .71936 .92474 L p F P
0 0 0 r
s
.133 1 0 r
.67912 .93462 m .65994 .91627 L .61988 .92627 L p F P
0 0 0 r
s
1 .358 0 r
.76022 .91472 m .77804 .93311 L .81908 .92321 L p F P
0 0 0 r
s
1 .58 0 r
.77804 .93311 m .76022 .91472 L .71936 .92474 L p F P
0 0 0 r
s
1 .192 0 r
.19866 .91394 m .22424 .93235 L .26113 .92244 L p F P
0 0 0 r
s
1 .041 0 r
.86074 .91316 m .87719 .93159 L .91902 .92167 L p F P
0 0 0 r
s
1 .089 0 r
.87719 .93159 m .86074 .91316 L .81908 .92321 L p F P
0 0 0 r
s
.923 1 0 r
.29858 .91238 m .32281 .93084 L .36048 .9209 L p F P
0 0 0 r
s
1 .505 0 r
.32281 .93084 m .29858 .91238 L .26113 .92244 L p F P
0 0 0 r
s
1 .035 0 r
.54357 .08168 m .56443 .11391 L .60389 .09594 L p F P
0 0 0 r
s
1 .067 0 r
.56443 .11391 m .54357 .08168 L .50429 .09903 L p F P
0 0 0 r
s
1 .005 0 r
.97657 .93008 m .96149 .9116 L .91902 .92167 L p F P
0 0 0 r
s
1 .015 0 r
.64392 .07856 m .66343 .10958 L .70363 .0923 L p F P
0 0 0 r
s
1 .041 0 r
.66343 .10958 m .64392 .07856 L .60389 .09594 L p F P
0 0 0 r
s
0 .98 1 r
.39873 .91082 m .4216 .92932 L .46007 .91936 L p F P
0 0 0 r
s
.133 1 0 r
.4216 .92932 m .39873 .91082 L .36048 .9209 L p F P
0 0 0 r
s
.257 0 1 r
.49912 .90926 m .52063 .9278 L .55989 .91782 L p F P
0 0 0 r
s
0 .535 1 r
.52063 .9278 m .49912 .90926 L .46007 .91936 L p F P
0 0 0 r
s
0 .98 1 r
.59974 .90769 m .61988 .92627 L .65994 .91627 L p F P
0 0 0 r
s
0 .765 1 r
.61988 .92627 m .59974 .90769 L .55989 .91782 L p F P
0 0 0 r
s
.922 1 0 r
.7006 .90612 m .71936 .92474 L .76022 .91472 L p F P
0 0 0 r
s
.48 1 0 r
.71936 .92474 m .7006 .90612 L .65994 .91627 L p F P
0 0 0 r
s
1 .192 0 r
.8017 .90454 m .81908 .92321 L .86074 .91316 L p F P
0 0 0 r
s
1 .358 0 r
.81908 .92321 m .8017 .90454 L .76022 .91472 L p F P
0 0 0 r
s
1 .471 0 r
.23587 .90375 m .26113 .92244 L .29858 .91238 L p F P
0 0 0 r
s
1 .192 0 r
.26113 .92244 m .23587 .90375 L .19866 .91394 L p F P
0 0 0 r
s
1 .015 0 r
.90304 .90296 m .91902 .92167 L .96149 .9116 L p F P
0 0 0 r
s
1 .041 0 r
.91902 .92167 m .90304 .90296 L .86074 .91316 L p F P
0 0 0 r
s
1 .015 0 r
.58343 .06443 m .60389 .09594 L .64392 .07856 L p F P
0 0 0 r
s
1 .035 0 r
.60389 .09594 m .58343 .06443 L .54357 .08168 L p F P
0 0 0 r
s
0 1 0 r
.3366 .90217 m .36048 .9209 L .39873 .91082 L p F P
0 0 0 r
s
.923 1 0 r
.36048 .9209 m .3366 .90217 L .29858 .91238 L p F P
0 0 0 r
s
1 .015 0 r
.70363 .0923 m .68457 .06147 L .64392 .07856 L p F P
0 0 0 r
s
.257 0 1 r
.43757 .90059 m .46007 .91936 L .49912 .90926 L p F P
0 0 0 r
s
0 .98 1 r
.46007 .91936 m .43757 .90059 L .39873 .91082 L p F P
0 0 0 r
s
.56 0 1 r
.53877 .899 m .55989 .91782 L .59974 .90769 L p F P
0 0 0 r
s
.257 0 1 r
.55989 .91782 m .53877 .899 L .49912 .90926 L p F P
0 0 0 r
s
0 1 .458 r
.64021 .89741 m .65994 .91627 L .7006 .90612 L p F P
0 0 0 r
s
0 .98 1 r
.65994 .91627 m .64021 .89741 L .59974 .90769 L p F P
0 0 0 r
s
1 .666 0 r
.7419 .89581 m .76022 .91472 L .8017 .90454 L p F P
0 0 0 r
s
.922 1 0 r
.76022 .91472 m .7419 .89581 L .7006 .90612 L p F P
0 0 0 r
s
1 .156 0 r
.17235 .89501 m .19866 .91394 L .23587 .90375 L p F P
0 0 0 r
s
1 .089 0 r
.84382 .89421 m .86074 .91316 L .90304 .90296 L p F P
0 0 0 r
s
1 .192 0 r
.86074 .91316 m .84382 .89421 L .8017 .90454 L p F P
0 0 0 r
s
.994 1 0 r
.27366 .89341 m .29858 .91238 L .3366 .90217 L p F P
0 0 0 r
s
1 .471 0 r
.29858 .91238 m .27366 .89341 L .23587 .90375 L p F P
0 0 0 r
s
1 .005 0 r
.62389 .04723 m .64392 .07856 L .68457 .06147 L p F P
0 0 0 r
s
1 .015 0 r
.64392 .07856 m .62389 .04723 L .58343 .06443 L p F P
0 0 0 r
s
1 .015 0 r
.96149 .9116 m .94599 .89261 L .90304 .90296 L p F P
0 0 0 r
s
0 .765 1 r
.37521 .8918 m .39873 .91082 L .43757 .90059 L p F P
0 0 0 r
s
0 1 0 r
.39873 .91082 m .37521 .8918 L .3366 .90217 L p F P
0 0 0 r
s
1 0 .769 r
.477 .89019 m .49912 .90926 L .53877 .899 L p F P
0 0 0 r
s
.257 0 1 r
.49912 .90926 m .477 .89019 L .43757 .90059 L p F P
0 0 0 r
s
.257 0 1 r
.57903 .88858 m .59974 .90769 L .64021 .89741 L p F P
0 0 0 r
s
.56 0 1 r
.59974 .90769 m .57903 .88858 L .53877 .899 L p F P
0 0 0 r
s
.256 1 0 r
.68131 .88696 m .7006 .90612 L .7419 .89581 L p F P
0 0 0 r
s
0 1 .458 r
.7006 .90612 m .68131 .88696 L .64021 .89741 L p F P
0 0 0 r
s
1 .358 0 r
.78383 .88534 m .8017 .90454 L .84382 .89421 L p F P
0 0 0 r
s
1 .666 0 r
.8017 .90454 m .78383 .88534 L .7419 .89581 L p F P
0 0 0 r
s
1 .383 0 r
.2099 .88453 m .23587 .90375 L .27366 .89341 L p F P
0 0 0 r
s
1 .156 0 r
.23587 .90375 m .2099 .88453 L .17235 .89501 L p F P
0 0 0 r
s
1 .035 0 r
.88659 .88372 m .90304 .90296 L .94599 .89261 L p F P
0 0 0 r
s
1 .089 0 r
.90304 .90296 m .88659 .88372 L .84382 .89421 L p F P
0 0 0 r
s
.133 1 0 r
.31204 .8829 m .3366 .90217 L .37521 .8918 L p F P
0 0 0 r
s
.994 1 0 r
.3366 .90217 m .31204 .8829 L .27366 .89341 L p F P
0 0 0 r
s
1 .005 0 r
.68457 .06147 m .66497 .02998 L .62389 .04723 L p F P
0 0 0 r
s
.56 0 1 r
.41442 .88127 m .43757 .90059 L .477 .89019 L p F P
0 0 0 r
s
0 .765 1 r
.43757 .90059 m .41442 .88127 L .37521 .8918 L p F P
0 0 0 r
s
1 0 .398 r
.51705 .87964 m .53877 .899 L .57903 .88858 L p F P
0 0 0 r
s
1 0 .769 r
.53877 .899 m .51705 .87964 L .477 .89019 L p F P
0 0 0 r
s
0 .535 1 r
.61993 .878 m .64021 .89741 L .68131 .88696 L p F P
0 0 0 r
s
.257 0 1 r
.64021 .89741 m .61993 .878 L .57903 .88858 L p F P
0 0 0 r
s
.922 1 0 r
.72305 .87636 m .7419 .89581 L .78383 .88534 L p F P
0 0 0 r
s
.256 1 0 r
.7419 .89581 m .72305 .87636 L .68131 .88696 L p F P
0 0 0 r
s
1 .11 0 r
.14529 .87553 m .17235 .89501 L .2099 .88453 L p F P
0 0 0 r
s
1 .167 0 r
.82642 .87471 m .84382 .89421 L .88659 .88372 L p F P
0 0 0 r
s
1 .358 0 r
.84382 .89421 m .82642 .87471 L .78383 .88534 L p F P
0 0 0 r
s
1 .818 0 r
.24803 .87388 m .27366 .89341 L .31204 .8829 L p F P
0 0 0 r
s
1 .383 0 r
.27366 .89341 m .24803 .87388 L .2099 .88453 L p F P
0 0 0 r
s
1 .035 0 r
.94599 .89261 m .93003 .87306 L .88659 .88372 L p F P
0 0 0 r
s
0 .98 1 r
.35101 .87223 m .37521 .8918 L .41442 .88127 L p F P
0 0 0 r
s
.133 1 0 r
.37521 .8918 m .35101 .87223 L .31204 .8829 L p F P
0 0 0 r
s
1 0 .398 r
.45424 .87058 m .477 .89019 L .51705 .87964 L p F P
0 0 0 r
s
.56 0 1 r
.477 .89019 m .45424 .87058 L .41442 .88127 L p F P
0 0 0 r
s
1 0 .769 r
.55773 .86892 m .57903 .88858 L .61993 .878 L p F P
0 0 0 r
s
1 0 .398 r
.57903 .88858 m .55773 .86892 L .51705 .87964 L p F P
0 0 0 r
s
0 1 .458 r
.66146 .86725 m .68131 .88696 L .72305 .87636 L p F P
0 0 0 r
s
0 .535 1 r
.68131 .88696 m .66146 .86725 L .61993 .878 L p F P
0 0 0 r
s
1 .58 0 r
.76544 .86558 m .78383 .88534 L .82642 .87471 L p F P
0 0 0 r
s
.922 1 0 r
.78383 .88534 m .76544 .86558 L .72305 .87636 L p F P
0 0 0 r
s
1 .271 0 r
.18317 .86475 m .2099 .88453 L .24803 .87388 L p F P
0 0 0 r
s
1 .11 0 r
.2099 .88453 m .18317 .86475 L .14529 .87553 L p F P
0 0 0 r
s
1 .067 0 r
.86967 .86391 m .88659 .88372 L .93003 .87306 L p F P
0 0 0 r
s
1 .167 0 r
.88659 .88372 m .86967 .86391 L .82642 .87471 L p F P
0 0 0 r
s
.48 1 0 r
.28676 .86307 m .31204 .8829 L .35101 .87223 L p F P
0 0 0 r
s
1 .818 0 r
.31204 .8829 m .28676 .86307 L .24803 .87388 L p F P
0 0 0 r
s
.257 0 1 r
.3906 .86139 m .41442 .88127 L .45424 .87058 L p F P
0 0 0 r
s
0 .98 1 r
.41442 .88127 m .3906 .86139 L .35101 .87223 L p F P
0 0 0 r
s
1 0 0 r
.4947 .85971 m .51705 .87964 L .55773 .86892 L p F P
0 0 0 r
s
1 0 .398 r
.51705 .87964 m .4947 .85971 L .45424 .87058 L p F P
0 0 0 r
s
.257 0 1 r
.59904 .85802 m .61993 .878 L .66146 .86725 L p F P
0 0 0 r
s
1 0 .769 r
.61993 .878 m .59904 .85802 L .55773 .86892 L p F P
0 0 0 r
s
.48 1 0 r
.70365 .85633 m .72305 .87636 L .76544 .86558 L p F P
0 0 0 r
s
0 1 .458 r
.72305 .87636 m .70365 .85633 L .66146 .86725 L p F P
0 0 0 r
s
1 .067 0 r
.11744 .85549 m .14529 .87553 L .18317 .86475 L p F P
0 0 0 r
s
1 .271 0 r
.8085 .85464 m .82642 .87471 L .86967 .86391 L p F P
0 0 0 r
s
1 .58 0 r
.82642 .87471 m .8085 .85464 L .76544 .86558 L p F P
0 0 0 r
s
1 .58 0 r
.22164 .85379 m .24803 .87388 L .28676 .86307 L p F P
0 0 0 r
s
1 .271 0 r
.24803 .87388 m .22164 .85379 L .18317 .86475 L p F P
0 0 0 r
s
1 .067 0 r
.93003 .87306 m .91361 .85294 L .86967 .86391 L p F P
0 0 0 r
s
0 1 .458 r
.3261 .85209 m .35101 .87223 L .3906 .86139 L p F P
0 0 0 r
s
.48 1 0 r
.35101 .87223 m .3261 .85209 L .28676 .86307 L p F P
0 0 0 r
s
1 0 .769 r
.43082 .85038 m .45424 .87058 L .4947 .85971 L p F P
0 0 0 r
s
.257 0 1 r
.45424 .87058 m .43082 .85038 L .3906 .86139 L p F P
0 0 0 r
s
1 0 .398 r
.53579 .84867 m .55773 .86892 L .59904 .85802 L p F P
0 0 0 r
s
1 0 0 r
.55773 .86892 m .53579 .84867 L .4947 .85971 L p F P
0 0 0 r
s
0 .98 1 r
.64102 .84696 m .66146 .86725 L .70365 .85633 L p F P
0 0 0 r
s
.257 0 1 r
.66146 .86725 m .64102 .84696 L .59904 .85802 L p F P
0 0 0 r
s
1 .818 0 r
.74651 .84524 m .76544 .86558 L .8085 .85464 L p F P
0 0 0 r
s
.48 1 0 r
.76544 .86558 m .74651 .84524 L .70365 .85633 L p F P
0 0 0 r
s
1 .167 0 r
.15565 .84438 m .18317 .86475 L .22164 .85379 L p F P
0 0 0 r
s
1 .067 0 r
.18317 .86475 m .15565 .84438 L .11744 .85549 L p F P
0 0 0 r
s
1 .11 0 r
.85225 .84352 m .86967 .86391 L .91361 .85294 L p F P
0 0 0 r
s
1 .271 0 r
.86967 .86391 m .85225 .84352 L .8085 .85464 L p F P
0 0 0 r
s
.922 1 0 r
.26073 .84266 m .28676 .86307 L .3261 .85209 L p F P
0 0 0 r
s
1 .58 0 r
.28676 .86307 m .26073 .84266 L .22164 .85379 L p F P
0 0 0 r
s
0 .535 1 r
.36608 .84093 m .3906 .86139 L .43082 .85038 L p F P
0 0 0 r
s
0 1 .458 r
.3906 .86139 m .36608 .84093 L .3261 .85209 L p F P
0 0 0 r
s
1 0 .398 r
.47168 .8392 m .4947 .85971 L .53579 .84867 L p F P
0 0 0 r
s
1 0 .769 r
.4947 .85971 m .47168 .8392 L .43082 .85038 L p F P
0 0 0 r
s
.56 0 1 r
.57754 .83746 m .59904 .85802 L .64102 .84696 L p F P
0 0 0 r
s
1 0 .398 r
.59904 .85802 m .57754 .83746 L .53579 .84867 L p F P
0 0 0 r
s
.133 1 0 r
.68367 .83572 m .70365 .85633 L .74651 .84524 L p F P
0 0 0 r
s
0 .98 1 r
.70365 .85633 m .68367 .83572 L .64102 .84696 L p F P
0 0 0 r
s
1 .035 0 r
.08876 .83485 m .11744 .85549 L .15565 .84438 L p F P
0 0 0 r
s
1 .383 0 r
.79006 .83397 m .8085 .85464 L .85225 .84352 L p F P
0 0 0 r
s
1 .818 0 r
.8085 .85464 m .79006 .83397 L .74651 .84524 L p F P
0 0 0 r
s
1 .358 0 r
.19448 .8331 m .22164 .85379 L .26073 .84266 L p F P
0 0 0 r
s
1 .167 0 r
.22164 .85379 m .19448 .8331 L .15565 .84438 L p F P
0 0 0 r
s
1 .11 0 r
.91361 .85294 m .89671 .83222 L .85225 .84352 L p F P
0 0 0 r
s
.256 1 0 r
.30046 .83135 m .3261 .85209 L .36608 .84093 L p F P
0 0 0 r
s
.922 1 0 r
.3261 .85209 m .30046 .83135 L .26073 .84266 L p F P
0 0 0 r
s
.257 0 1 r
.4067 .82959 m .43082 .85038 L .47168 .8392 L p F P
0 0 0 r
s
0 .535 1 r
.43082 .85038 m .4067 .82959 L .36608 .84093 L p F P
0 0 0 r
s
1 0 .769 r
.5132 .82783 m .53579 .84867 L .57754 .83746 L p F P
0 0 0 r
s
1 0 .398 r
.53579 .84867 m .5132 .82783 L .47168 .8392 L p F P
0 0 0 r
s
0 .765 1 r
.61997 .82606 m .64102 .84696 L .68367 .83572 L p F P
0 0 0 r
s
.56 0 1 r
.64102 .84696 m .61997 .82606 L .57754 .83746 L p F P
0 0 0 r
s
.994 1 0 r
.72701 .8243 m .74651 .84524 L .79006 .83397 L p F P
0 0 0 r
s
.133 1 0 r
.74651 .84524 m .72701 .8243 L .68367 .83572 L p F P
0 0 0 r
s
1 .089 0 r
.12731 .82341 m .15565 .84438 L .19448 .8331 L p F P
0 0 0 r
s
1 .035 0 r
.15565 .84438 m .12731 .82341 L .08876 .83485 L p F P
0 0 0 r
s
1 .156 0 r
.83431 .82252 m .85225 .84352 L .89671 .83222 L p F P
0 0 0 r
s
1 .383 0 r
.85225 .84352 m .83431 .82252 L .79006 .83397 L p F P
0 0 0 r
s
1 .666 0 r
.23393 .82163 m .26073 .84266 L .30046 .83135 L p F P
0 0 0 r
s
1 .358 0 r
.26073 .84266 m .23393 .82163 L .19448 .8331 L p F P
0 0 0 r
s
0 1 .458 r
.34082 .81985 m .36608 .84093 L .4067 .82959 L p F P
0 0 0 r
s
.256 1 0 r
.36608 .84093 m .34082 .81985 L .30046 .83135 L p F P
0 0 0 r
s
.56 0 1 r
.44798 .81807 m .47168 .8392 L .5132 .82783 L p F P
0 0 0 r
s
.257 0 1 r
.47168 .8392 m .44798 .81807 L .4067 .82959 L p F P
0 0 0 r
s
.257 0 1 r
.5554 .81628 m .57754 .83746 L .61997 .82606 L p F P
0 0 0 r
s
1 0 .769 r
.57754 .83746 m .5554 .81628 L .5132 .82783 L p F P
0 0 0 r
s
0 1 0 r
.66309 .81448 m .68367 .83572 L .72701 .8243 L p F P
0 0 0 r
s
0 .765 1 r
.68367 .83572 m .66309 .81448 L .61997 .82606 L p F P
0 0 0 r
s
1 .015 0 r
.05922 .81358 m .08876 .83485 L .12731 .82341 L p F P
0 0 0 r
s
1 .471 0 r
.77106 .81269 m .79006 .83397 L .83431 .82252 L p F P
0 0 0 r
s
.994 1 0 r
.79006 .83397 m .77106 .81269 L .72701 .8243 L p F P
0 0 0 r
s
1 .192 0 r
.16649 .81178 m .19448 .8331 L .23393 .82163 L p F P
0 0 0 r
s
1 .089 0 r
.19448 .8331 m .16649 .81178 L .12731 .82341 L p F P
0 0 0 r
s
1 .156 0 r
.89671 .83222 m .87929 .81088 L .83431 .82252 L p F P
0 0 0 r
s
.922 1 0 r
.27403 .80998 m .30046 .83135 L .34082 .81985 L p F P
0 0 0 r
s
1 .666 0 r
.30046 .83135 m .27403 .80998 L .23393 .82163 L p F P
0 0 0 r
s
0 .98 1 r
.38185 .80817 m .4067 .82959 L .44798 .81807 L p F P
0 0 0 r
s
0 1 .458 r
.4067 .82959 m .38185 .80817 L .34082 .81985 L p F P
0 0 0 r
s
.257 0 1 r
.48993 .80635 m .5132 .82783 L .5554 .81628 L p F P
0 0 0 r
s
.56 0 1 r
.5132 .82783 m .48993 .80635 L .44798 .81807 L p F P
0 0 0 r
s
0 .98 1 r
.59829 .80454 m .61997 .82606 L .66309 .81448 L p F P
0 0 0 r
s
.257 0 1 r
.61997 .82606 m .59829 .80454 L .5554 .81628 L p F P
0 0 0 r
s
.923 1 0 r
.70692 .80271 m .72701 .8243 L .77106 .81269 L p F P
0 0 0 r
s
0 1 0 r
.72701 .8243 m .70692 .80271 L .66309 .81448 L p F P
0 0 0 r
s
1 .041 0 r
.09811 .8018 m .12731 .82341 L .16649 .81178 L p F P
0 0 0 r
s
1 .015 0 r
.12731 .82341 m .09811 .8018 L .05922 .81358 L p F P
0 0 0 r
s
1 .192 0 r
.81583 .80088 m .83431 .82252 L .87929 .81088 L p F P
0 0 0 r
s
1 .471 0 r
.83431 .82252 m .81583 .80088 L .77106 .81269 L p F P
0 0 0 r
s
1 .358 0 r
.20631 .79997 m .23393 .82163 L .27403 .80998 L p F P
0 0 0 r
s
1 .192 0 r
.23393 .82163 m .20631 .79997 L .16649 .81178 L p F P
0 0 0 r
s
.48 1 0 r
.31479 .79813 m .34082 .81985 L .38185 .80817 L p F P
0 0 0 r
s
.922 1 0 r
.34082 .81985 m .31479 .79813 L .27403 .80998 L p F P
0 0 0 r
s
0 .765 1 r
.42355 .79629 m .44798 .81807 L .48993 .80635 L p F P
0 0 0 r
s
0 .98 1 r
.44798 .81807 m .42355 .79629 L .38185 .80817 L p F P
0 0 0 r
s
0 .535 1 r
.53258 .79445 m .5554 .81628 L .59829 .80454 L p F P
0 0 0 r
s
.257 0 1 r
.5554 .81628 m .53258 .79445 L .48993 .80635 L p F P
0 0 0 r
s
.133 1 0 r
.64189 .7926 m .66309 .81448 L .70692 .80271 L p F P
0 0 0 r
s
0 .98 1 r
.66309 .81448 m .64189 .7926 L .59829 .80454 L p F P
0 0 0 r
s
1 .005 0 r
.02877 .79167 m .05922 .81358 L .09811 .8018 L p F P
0 0 0 r
s
1 .505 0 r
.75147 .79075 m .77106 .81269 L .81583 .80088 L p F P
0 0 0 r
s
.923 1 0 r
.77106 .81269 m .75147 .79075 L .70692 .80271 L p F P
0 0 0 r
s
1 .089 0 r
.13765 .78982 m .16649 .81178 L .20631 .79997 L p F P
0 0 0 r
s
1 .041 0 r
.16649 .81178 m .13765 .78982 L .09811 .8018 L p F P
0 0 0 r
s
1 .192 0 r
.87929 .81088 m .86134 .78889 L .81583 .80088 L p F P
0 0 0 r
s
1 .58 0 r
.2468 .78796 m .27403 .80998 L .31479 .79813 L p F P
0 0 0 r
s
1 .358 0 r
.27403 .80998 m .2468 .78796 L .20631 .79997 L p F P
0 0 0 r
s
.133 1 0 r
.35623 .78609 m .38185 .80817 L .42355 .79629 L p F P
0 0 0 r
s
.48 1 0 r
.38185 .80817 m .35623 .78609 L .31479 .79813 L p F P
0 0 0 r
s
0 .98 1 r
.46594 .78422 m .48993 .80635 L .53258 .79445 L p F P
0 0 0 r
s
0 .765 1 r
.48993 .80635 m .46594 .78422 L .42355 .79629 L p F P
0 0 0 r
s
0 1 .458 r
.57594 .78235 m .59829 .80454 L .64189 .7926 L p F P
0 0 0 r
s
0 .535 1 r
.59829 .80454 m .57594 .78235 L .53258 .79445 L p F P
0 0 0 r
s
.994 1 0 r
.68621 .78046 m .70692 .80271 L .75147 .79075 L p F P
0 0 0 r
s
.133 1 0 r
.70692 .80271 m .68621 .78046 L .64189 .7926 L p F P
0 0 0 r
s
1 .015 0 r
.06801 .77952 m .09811 .8018 L .13765 .78982 L p F P
0 0 0 r
s
1 .005 0 r
.09811 .8018 m .06801 .77952 L .02877 .79167 L p F P
0 0 0 r
s
1 .205 0 r
.79677 .77858 m .81583 .80088 L .86134 .78889 L p F P
0 0 0 r
s
1 .505 0 r
.81583 .80088 m .79677 .77858 L .75147 .79075 L p F P
0 0 0 r
s
1 .167 0 r
.17785 .77764 m .20631 .79997 L .2468 .78796 L p F P
0 0 0 r
s
1 .089 0 r
.20631 .79997 m .17785 .77764 L .13765 .78982 L p F P
0 0 0 r
s
1 .818 0 r
.28796 .77574 m .31479 .79813 L .35623 .78609 L p F P
0 0 0 r
s
1 .58 0 r
.31479 .79813 m .28796 .77574 L .2468 .78796 L p F P
0 0 0 r
s
0 1 0 r
.39837 .77385 m .42355 .79629 L .46594 .78422 L p F P
0 0 0 r
s
.133 1 0 r
.42355 .79629 m .39837 .77385 L .35623 .78609 L p F P
0 0 0 r
s
0 1 .458 r
.50905 .77194 m .53258 .79445 L .57594 .78235 L p F P
0 0 0 r
s
0 .98 1 r
.53258 .79445 m .50905 .77194 L .46594 .78422 L p F P
0 0 0 r
s
.48 1 0 r
.62002 .77004 m .64189 .7926 L .68621 .78046 L p F P
0 0 0 r
s
0 1 .458 r
.64189 .7926 m .62002 .77004 L .57594 .78235 L p F P
0 0 0 r
s
1 .471 0 r
.73128 .76813 m .75147 .79075 L .79677 .77858 L p F P
0 0 0 r
s
.994 1 0 r
.75147 .79075 m .73128 .76813 L .68621 .78046 L p F P
0 0 0 r
s
1 .035 0 r
.10791 .76717 m .13765 .78982 L .17785 .77764 L p F P
0 0 0 r
s
1 .015 0 r
.13765 .78982 m .10791 .76717 L .06801 .77952 L p F P
0 0 0 r
s
1 .205 0 r
.86134 .78889 m .84283 .76621 L .79677 .77858 L p F P
0 0 0 r
s
1 .271 0 r
.21872 .76525 m .2468 .78796 L .28796 .77574 L p F P
0 0 0 r
s
1 .167 0 r
.2468 .78796 m .21872 .76525 L .17785 .77764 L p F P
0 0 0 r
s
.994 1 0 r
.32982 .76332 m .35623 .78609 L .39837 .77385 L p F P
0 0 0 r
s
1 .818 0 r
.35623 .78609 m .32982 .76332 L .28796 .77574 L p F P
0 0 0 r
s
.133 1 0 r
.44121 .7614 m .46594 .78422 L .50905 .77194 L p F P
0 0 0 r
s
0 1 0 r
.46594 .78422 m .44121 .7614 L .39837 .77385 L p F P
0 0 0 r
s
.256 1 0 r
.55289 .75946 m .57594 .78235 L .62002 .77004 L p F P
0 0 0 r
s
0 1 .458 r
.57594 .78235 m .55289 .75946 L .50905 .77194 L p F P
0 0 0 r
s
1 .818 0 r
.66486 .75752 m .68621 .78046 L .73128 .76813 L p F P
0 0 0 r
s
.48 1 0 r
.68621 .78046 m .66486 .75752 L .62002 .77004 L p F P
0 0 0 r
s
1 .192 0 r
.77712 .75558 m .79677 .77858 L .84283 .76621 L p F P
0 0 0 r
s
1 .471 0 r
.79677 .77858 m .77712 .75558 L .73128 .76813 L p F P
0 0 0 r
s
1 .067 0 r
.14848 .7546 m .17785 .77764 L .21872 .76525 L p F P
0 0 0 r
s
1 .035 0 r
.17785 .77764 m .14848 .7546 L .10791 .76717 L p F P
0 0 0 r
s
1 .383 0 r
.26029 .75265 m .28796 .77574 L .32982 .76332 L p F P
0 0 0 r
s
1 .271 0 r
.28796 .77574 m .26029 .75265 L .21872 .76525 L p F P
0 0 0 r
s
.923 1 0 r
.37239 .75069 m .39837 .77385 L .44121 .7614 L p F P
0 0 0 r
s
.994 1 0 r
.39837 .77385 m .37239 .75069 L .32982 .76332 L p F P
0 0 0 r
s
.48 1 0 r
.48478 .74873 m .50905 .77194 L .55289 .75946 L p F P
0 0 0 r
s
.133 1 0 r
.50905 .77194 m .48478 .74873 L .44121 .7614 L p F P
0 0 0 r
s
.922 1 0 r
.59747 .74676 m .62002 .77004 L .66486 .75752 L p F P
0 0 0 r
s
.256 1 0 r
.62002 .77004 m .59747 .74676 L .55289 .75946 L p F P
0 0 0 r
s
1 .383 0 r
.71046 .74479 m .73128 .76813 L .77712 .75558 L p F P
0 0 0 r
s
1 .818 0 r
.73128 .76813 m .71046 .74479 L .66486 .75752 L p F P
0 0 0 r
s
1 .192 0 r
.84283 .76621 m .82374 .74281 L .77712 .75558 L p F P
0 0 0 r
s
1 .11 0 r
.18975 .74182 m .21872 .76525 L .26029 .75265 L p F P
0 0 0 r
s
1 .067 0 r
.21872 .76525 m .18975 .74182 L .14848 .7546 L p F P
0 0 0 r
s
1 .471 0 r
.30257 .73984 m .32982 .76332 L .37239 .75069 L p F P
0 0 0 r
s
1 .383 0 r
.32982 .76332 m .30257 .73984 L .26029 .75265 L p F P
0 0 0 r
s
.994 1 0 r
.41569 .73785 m .44121 .7614 L .48478 .74873 L p F P
0 0 0 r
s
.923 1 0 r
.44121 .7614 m .41569 .73785 L .37239 .75069 L p F P
0 0 0 r
s
.922 1 0 r
.52911 .73585 m .55289 .75946 L .59747 .74676 L p F P
0 0 0 r
s
.48 1 0 r
.55289 .75946 m .52911 .73585 L .48478 .74873 L p F P
0 0 0 r
s
1 .58 0 r
.64283 .73385 m .66486 .75752 L .71046 .74479 L p F P
0 0 0 r
s
.922 1 0 r
.66486 .75752 m .64283 .73385 L .59747 .74676 L p F P
0 0 0 r
s
1 .156 0 r
.75684 .73184 m .77712 .75558 L .82374 .74281 L p F P
0 0 0 r
s
1 .383 0 r
.77712 .75558 m .75684 .73184 L .71046 .74479 L p F P
0 0 0 r
s
1 .156 0 r
.23174 .72882 m .26029 .75265 L .30257 .73984 L p F P
0 0 0 r
s
1 .11 0 r
.26029 .75265 m .23174 .72882 L .18975 .74182 L p F P
0 0 0 r
s
1 .505 0 r
.34559 .7268 m .37239 .75069 L .41569 .73785 L p F P
0 0 0 r
s
1 .471 0 r
.37239 .75069 m .34559 .7268 L .30257 .73984 L p F P
0 0 0 r
s
1 .818 0 r
.45974 .72478 m .48478 .74873 L .52911 .73585 L p F P
0 0 0 r
s
.994 1 0 r
.48478 .74873 m .45974 .72478 L .41569 .73785 L p F P
0 0 0 r
s
1 .666 0 r
.5742 .72275 m .59747 .74676 L .64283 .73385 L p F P
0 0 0 r
s
.922 1 0 r
.59747 .74676 m .5742 .72275 L .52911 .73585 L p F P
0 0 0 r
s
1 .271 0 r
.68896 .72071 m .71046 .74479 L .75684 .73184 L p F P
0 0 0 r
s
1 .58 0 r
.71046 .74479 m .68896 .72071 L .64283 .73385 L p F P
0 0 0 r
s
1 .156 0 r
.82374 .74281 m .80404 .71867 L .75684 .73184 L p F P
0 0 0 r
s
1 .192 0 r
.27445 .7156 m .30257 .73984 L .34559 .7268 L p F P
0 0 0 r
s
1 .156 0 r
.30257 .73984 m .27445 .7156 L .23174 .72882 L p F P
0 0 0 r
s
1 .471 0 r
.38935 .71354 m .41569 .73785 L .45974 .72478 L p F P
0 0 0 r
s
1 .505 0 r
.41569 .73785 m .38935 .71354 L .34559 .7268 L p F P
0 0 0 r
s
1 .58 0 r
.50456 .71148 m .52911 .73585 L .5742 .72275 L p F P
0 0 0 r
s
1 .818 0 r
.52911 .73585 m .50456 .71148 L .45974 .72478 L p F P
0 0 0 r
s
1 .358 0 r
.62008 .70941 m .64283 .73385 L .68896 .72071 L p F P
0 0 0 r
s
1 .666 0 r
.64283 .73385 m .62008 .70941 L .5742 .72275 L p F P
0 0 0 r
s
1 .11 0 r
.73591 .70734 m .75684 .73184 L .80404 .71867 L p F P
0 0 0 r
s
1 .271 0 r
.75684 .73184 m .73591 .70734 L .68896 .72071 L p F P
0 0 0 r
s
1 .205 0 r
.31792 .70214 m .34559 .7268 L .38935 .71354 L p F P
0 0 0 r
s
1 .192 0 r
.34559 .7268 m .31792 .70214 L .27445 .7156 L p F P
0 0 0 r
s
1 .383 0 r
.43389 .70005 m .45974 .72478 L .50456 .71148 L p F P
0 0 0 r
s
1 .471 0 r
.45974 .72478 m .43389 .70005 L .38935 .71354 L p F P
0 0 0 r
s
1 .358 0 r
.55017 .69795 m .5742 .72275 L .62008 .70941 L p F P
0 0 0 r
s
1 .58 0 r
.5742 .72275 m .55017 .69795 L .50456 .71148 L p F P
0 0 0 r
s
1 .167 0 r
.66677 .69585 m .68896 .72071 L .73591 .70734 L p F P
0 0 0 r
s
1 .358 0 r
.68896 .72071 m .66677 .69585 L .62008 .70941 L p F P
0 0 0 r
s
1 .11 0 r
.80404 .71867 m .78369 .69374 L .73591 .70734 L p F P
0 0 0 r
s
1 .192 0 r
.36215 .68844 m .38935 .71354 L .43389 .70005 L p F P
0 0 0 r
s
1 .205 0 r
.38935 .71354 m .36215 .68844 L .31792 .70214 L p F P
0 0 0 r
s
1 .271 0 r
.47921 .68631 m .50456 .71148 L .55017 .69795 L p F P
0 0 0 r
s
1 .383 0 r
.50456 .71148 m .47921 .68631 L .43389 .70005 L p F P
0 0 0 r
s
1 .192 0 r
.59659 .68418 m .62008 .70941 L .66677 .69585 L p F P
0 0 0 r
s
1 .358 0 r
.62008 .70941 m .59659 .68418 L .55017 .69795 L p F P
0 0 0 r
s
1 .067 0 r
.71429 .68204 m .73591 .70734 L .78369 .69374 L p F P
0 0 0 r
s
1 .167 0 r
.73591 .70734 m .71429 .68204 L .66677 .69585 L p F P
0 0 0 r
s
1 .156 0 r
.40718 .6745 m .43389 .70005 L .47921 .68631 L p F P
0 0 0 r
s
1 .192 0 r
.43389 .70005 m .40718 .6745 L .36215 .68844 L p F P
0 0 0 r
s
1 .167 0 r
.52535 .67233 m .55017 .69795 L .59659 .68418 L p F P
0 0 0 r
s
1 .271 0 r
.55017 .69795 m .52535 .67233 L .47921 .68631 L p F P
0 0 0 r
s
1 .089 0 r
.64384 .67016 m .66677 .69585 L .71429 .68204 L p F P
0 0 0 r
s
1 .192 0 r
.66677 .69585 m .64384 .67016 L .59659 .68418 L p F P
0 0 0 r
s
1 .067 0 r
.78369 .69374 m .76267 .66798 L .71429 .68204 L p F P
0 0 0 r
s
1 .11 0 r
.45301 .6603 m .47921 .68631 L .52535 .67233 L p F P
0 0 0 r
s
1 .156 0 r
.47921 .68631 m .45301 .6603 L .40718 .6745 L p F P
0 0 0 r
s
1 .089 0 r
.57232 .6581 m .59659 .68418 L .64384 .67016 L p F P
0 0 0 r
s
1 .167 0 r
.59659 .68418 m .57232 .6581 L .52535 .67233 L p F P
0 0 0 r
s
1 .035 0 r
.69195 .65588 m .71429 .68204 L .76267 .66798 L p F P
0 0 0 r
s
1 .089 0 r
.71429 .68204 m .69195 .65588 L .64384 .67016 L p F P
0 0 0 r
s
1 .067 0 r
.49969 .64585 m .52535 .67233 L .57232 .6581 L p F P
0 0 0 r
s
1 .11 0 r
.52535 .67233 m .49969 .64585 L .45301 .6603 L p F P
0 0 0 r
s
1 .041 0 r
.62014 .6436 m .64384 .67016 L .69195 .65588 L p F P
0 0 0 r
s
1 .089 0 r
.64384 .67016 m .62014 .6436 L .57232 .6581 L p F P
0 0 0 r
s
1 .035 0 r
.76267 .66798 m .74093 .64135 L .69195 .65588 L p F P
0 0 0 r
s
1 .035 0 r
.54722 .63113 m .57232 .6581 L .62014 .6436 L p F P
0 0 0 r
s
1 .067 0 r
.57232 .6581 m .54722 .63113 L .49969 .64585 L p F P
0 0 0 r
s
1 .015 0 r
.66885 .62884 m .69195 .65588 L .74093 .64135 L p F P
0 0 0 r
s
1 .041 0 r
.69195 .65588 m .66885 .62884 L .62014 .6436 L p F P
0 0 0 r
s
1 .015 0 r
.59563 .61614 m .62014 .6436 L .66885 .62884 L p F P
0 0 0 r
s
1 .035 0 r
.62014 .6436 m .59563 .61614 L .54722 .63113 L p F P
0 0 0 r
s
1 .015 0 r
.74093 .64135 m .71846 .61381 L .66885 .62884 L p F P
0 0 0 r
s
1 .005 0 r
.64495 .60087 m .66885 .62884 L .71846 .61381 L p F P
0 0 0 r
s
1 .015 0 r
.66885 .62884 m .64495 .60087 L .59563 .61614 L p F P
0 0 0 r
s
1 .005 0 r
.71846 .61381 m .6952 .58531 L .64495 .60087 L p F P
0 0 0 r
s
0 g
.25 Mabswid
.67245 0 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.67245 0 m
.08846 .24555 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.33.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics3D", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[10]= ",
 CellTags->"S5.33.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["option name", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["default value", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox["",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ColorFunction", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Hue", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "function to determine color of surface based on height",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["SurfaceMesh", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["True", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "whether to draw a mesh on the surface",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["SurfaceMeshStyle", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["RGBColor[0,", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["0,", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["0]", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "graphics directives to specify the style for the mesh",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ShadowMesh", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["True", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "whether to draw a mesh on the projection",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ShadowMeshStyle", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["RGBColor[0,", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["0,", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["0]", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "graphics directives to specify the style for the projection",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ShadowPosition", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["-1", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "whether the projection is above or below the surface",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
 GridBoxOptions->{RowLines->{True, False},
 RowSpacings->0.4},
 CellTags->"S5.33.1"],

Cell[TextData[{
 "Options for ",
 StyleBox["ShadowPlot3D", "MR"],
 " and ",
 StyleBox["ListShadowPlot3D", "MR"],
 "."
}], "Caption",
 CellTags->"S5.33.1"],

Cell[TextData[{
 StyleBox["Shadow", "MR"],
 " has options that determine whether a shadow is drawn in a particular \
direction. These options are ",
 StyleBox["XShadow", "MR"],
 ", ",
 StyleBox["YShadow", "MR"],
 ", and ",
 StyleBox["ZShadow", "MR"],
 ". The default value for all these options is ",
 StyleBox["True", "MR"],
 ". The options ",
 StyleBox["XShadowPosition", "MR"],
 ", ",
 StyleBox["YShadowPosition", "MR"],
 ", and ",
 StyleBox["ZShadowPosition", "MR"],
 " determine whether the projection of the shadow is in the positive or \
negative coordinate direction. Their default value is ",
 StyleBox["-1", "MR"],
 ". "
}], "Text",
 CellTags->{"S5.33.1", "1.16"}],

Cell[TextData[{
 "This generates a three\[Hyphen]dimensional graphics object using the built\
\[Hyphen]in ",
 StyleBox["ParametricPlot3D", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.33.1", "1.17"}],

Cell[CellGroupData[{

Cell["\<\
dbell = ParametricPlot3D[
    {Sin[t], Sin[2t] Sin[u], Sin[2t] Cos[u]},
    {t, -Pi/2, Pi/2}, {u, 0, 2Pi},
    Ticks -> None]\
\>", "Input",
 CellLabel->"In[11]:= ",
 CellTags->"S5.33.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.08495 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0565041 1.1653 7.35631e-17 1.1653 [
[ 0 0 0 0 ]
[ 1 1.08495 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.08828 .24569 m
.67294 0 L
s
0 .80363 m
.39959 1.08495 L
s
.08828 .24569 m
0 .80363 L
s
.08828 .24569 m
0 .80363 L
s
0 .80363 m
.39959 1.08495 L
s
.39959 1.08495 m
.41727 .5811 L
s
.41727 .5811 m
.08828 .24569 L
s
.67294 0 m
.92718 .41421 L
s
.92718 .41421 m
1 .94731 L
s
1 .94731 m
.70701 .58522 L
s
.70701 .58522 m
.67294 0 L
s
.08828 .24569 m
0 .80363 L
s
0 .80363 m
.70701 .58522 L
s
.70701 .58522 m
.67294 0 L
s
.67294 0 m
.08828 .24569 L
s
.41727 .5811 m
.92718 .41421 L
s
.92718 .41421 m
1 .94731 L
s
1 .94731 m
.39959 1.08495 L
s
.39959 1.08495 m
.41727 .5811 L
s
0 0 m
1 0 L
1 1.08495 L
0 1.08495 L
closepath
clip
newpath
.5 Mabswid
.602 .538 .755 r
.44755 .54372 m .42988 .54893 L .4506 .60413 L p F P
0 g
s
.602 .538 .755 r
.4506 .60413 m .46807 .59856 L .44755 .54372 L p F P
0 g
s
.724 .603 .721 r
.43018 .61076 m .4506 .60413 L .42988 .54893 L p F P
0 g
s
.589 .492 .712 r
.46807 .59856 m .4506 .60413 L .46626 .66104 L p F P
0 g
s
.714 .567 .688 r
.4506 .60413 m .43018 .61076 L .44525 .66572 L p F P
0 g
s
.714 .567 .688 r
.44525 .66572 m .46626 .66104 L .4506 .60413 L p F P
0 g
s
.724 .603 .721 r
.42988 .54893 m .41012 .55748 L .43018 .61076 L p F P
0 g
s
.8 .639 .683 r
.40685 .61843 m .43018 .61076 L .41012 .55748 L p F P
0 g
s
.792 .612 .658 r
.43018 .61076 m .40685 .61843 L .42071 .66914 L p F P
0 g
s
.792 .612 .658 r
.42071 .66914 m .44525 .66572 L .43018 .61076 L p F P
0 g
s
.589 .492 .712 r
.46626 .66104 m .48367 .65506 L .46807 .59856 L p F P
0 g
s
.571 .441 .664 r
.48367 .65506 m .46626 .66104 L .47633 .71786 L p F P
0 g
s
.704 .531 .651 r
.46626 .66104 m .44525 .66572 L .45483 .7206 L p F P
0 g
s
.704 .531 .651 r
.45483 .7206 m .47633 .71786 L .46626 .66104 L p F P
0 g
s
.613 .583 .797 r
.42271 .49229 m .40472 .49719 L .42988 .54893 L p F P
0 g
s
.613 .583 .797 r
.42988 .54893 m .44755 .54372 L .42271 .49229 L p F P
0 g
s
.737 .64 .752 r
.41012 .55748 m .42988 .54893 L .40472 .49719 L p F P
0 g
s
.786 .586 .63 r
.44525 .66572 m .42071 .66914 L .42937 .71976 L p F P
0 g
s
.786 .586 .63 r
.42937 .71976 m .45483 .7206 L .44525 .66572 L p F P
0 g
s
.737 .64 .752 r
.40472 .49719 m .38569 .50761 L .41012 .55748 L p F P
0 g
s
.811 .668 .705 r
.38829 .56931 m .41012 .55748 L .38569 .50761 L p F P
0 g
s
.8 .639 .683 r
.41012 .55748 m .38829 .56931 L .40685 .61843 L p F P
0 g
s
.416 .429 .765 r
.46321 .54183 m .44755 .54372 L .46807 .59856 L p F P
0 g
s
.416 .429 .765 r
.46807 .59856 m .4827 .594 L .46321 .54183 L p F P
0 g
s
.399 .371 .712 r
.4827 .594 m .46807 .59856 L .48367 .65506 L p F P
0 g
s
.848 .659 .648 r
.38078 .62709 m .40685 .61843 L .38829 .56931 L p F P
0 g
s
.841 .639 .629 r
.40685 .61843 m .38078 .62709 L .39282 .67133 L p F P
0 g
s
.841 .639 .629 r
.39282 .67133 m .42071 .66914 L .40685 .61843 L p F P
0 g
s
.399 .371 .712 r
.48367 .65506 m .49757 .64774 L .4827 .594 L p F P
0 g
s
.366 .3 .649 r
.49757 .64774 m .48367 .65506 L .49381 .71144 L p F P
0 g
s
.571 .441 .664 r
.47633 .71786 m .49381 .71144 L .48367 .65506 L p F P
0 g
s
.418 .479 .816 r
.43971 .49292 m .42271 .49229 L .44755 .54372 L p F P
0 g
s
.418 .479 .816 r
.44755 .54372 m .46321 .54183 L .43971 .49292 L p F P
0 g
s
.838 .62 .607 r
.42071 .66914 m .39282 .67133 L .40021 .71545 L p F P
0 g
s
.838 .62 .607 r
.40021 .71545 m .42937 .71976 L .42071 .66914 L p F P
0 g
s
.811 .668 .705 r
.38569 .50761 m .36562 .52342 L .38829 .56931 L p F P
0 g
s
.856 .681 .663 r
.36454 .58426 m .38829 .56931 L .36562 .52342 L p F P
0 g
s
.848 .659 .648 r
.38829 .56931 m .36454 .58426 L .38078 .62709 L p F P
0 g
s
.547 .381 .608 r
.49381 .71144 m .47633 .71786 L .48037 .77275 L p F P
0 g
s
.695 .493 .609 r
.47633 .71786 m .45483 .7206 L .45847 .77359 L p F P
0 g
s
.695 .493 .609 r
.45847 .77359 m .48037 .77275 L .47633 .71786 L p F P
0 g
s
.783 .56 .597 r
.45483 .7206 m .42937 .71976 L .43244 .76855 L p F P
0 g
s
.783 .56 .597 r
.43244 .76855 m .45847 .77359 L .45483 .7206 L p F P
0 g
s
.62 .631 .839 r
.39425 .44605 m .37584 .45069 L .40472 .49719 L p F P
0 g
s
.62 .631 .839 r
.40472 .49719 m .42271 .49229 L .39425 .44605 L p F P
0 g
s
.751 .68 .782 r
.38569 .50761 m .40472 .49719 L .37584 .45069 L p F P
0 g
s
.751 .68 .782 r
.37584 .45069 m .35759 .46287 L .38569 .50761 L p F P
0 g
s
.825 .698 .724 r
.36562 .52342 m .38569 .50761 L .35759 .46287 L p F P
0 g
s
.366 .3 .649 r
.49381 .71144 m .5073 .7013 L .49757 .64774 L p F P
0 g
s
.31 .205 .57 r
.5073 .7013 m .49381 .71144 L .49803 .76587 L p F P
0 g
s
.547 .381 .608 r
.48037 .77275 m .49803 .76587 L .49381 .71144 L p F P
0 g
s
.172 .274 .728 r
.47706 .54319 m .46321 .54183 L .4827 .594 L p F P
0 g
s
.172 .274 .728 r
.4827 .594 m .49466 .59042 L .47706 .54319 L p F P
0 g
s
.153 .207 .666 r
.49466 .59042 m .4827 .594 L .49757 .64774 L p F P
0 g
s
.837 .602 .583 r
.42937 .71976 m .40021 .71545 L .40259 .75787 L p F P
0 g
s
.837 .602 .583 r
.40259 .75787 m .43244 .76855 L .42937 .71976 L p F P
0 g
s
.401 .523 .866 r
.41288 .44899 m .39425 .44605 L .42271 .49229 L p F P
0 g
s
.401 .523 .866 r
.42271 .49229 m .43971 .49292 L .41288 .44899 L p F P
0 g
s
.825 .698 .724 r
.35759 .46287 m .33951 .4824 L .36562 .52342 L p F P
0 g
s
.868 .703 .676 r
.34463 .54437 m .36562 .52342 L .33951 .4824 L p F P
0 g
s
.856 .681 .663 r
.36562 .52342 m .34463 .54437 L .36454 .58426 L p F P
0 g
s
.153 .207 .666 r
.49757 .64774 m .50814 .63904 L .49466 .59042 L p F P
0 g
s
.1 .113 .585 r
.50814 .63904 m .49757 .64774 L .5073 .7013 L p F P
0 g
s
.879 .671 .617 r
.35231 .63661 m .38078 .62709 L .36454 .58426 L p F P
0 g
s
.875 .656 .604 r
.38078 .62709 m .35231 .63661 L .36197 .67231 L p F P
0 g
s
.875 .656 .604 r
.36197 .67231 m .39282 .67133 L .38078 .62709 L p F P
0 g
s
.158 .32 .778 r
.45589 .49896 m .43971 .49292 L .46321 .54183 L p F P
0 g
s
.158 .32 .778 r
.46321 .54183 m .47706 .54319 L .45589 .49896 L p F P
0 g
s
.872 .642 .588 r
.39282 .67133 m .36197 .67231 L .36778 .70786 L p F P
0 g
s
.872 .642 .588 r
.36778 .70786 m .40021 .71545 L .39282 .67133 L p F P
0 g
s
.886 .686 .628 r
.33916 .60209 m .36454 .58426 L .34463 .54437 L p F P
0 g
s
.879 .671 .617 r
.36454 .58426 m .33916 .60209 L .35231 .63661 L p F P
0 g
s
.686 .449 .558 r
.48037 .77275 m .45847 .77359 L .45583 .8228 L p F P
0 g
s
.783 .533 .559 r
.45847 .77359 m .43244 .76855 L .42962 .81374 L p F P
0 g
s
.783 .533 .559 r
.42962 .81374 m .45583 .8228 L .45847 .77359 L p F P
0 g
s
.512 .304 .534 r
.49803 .76587 m .48037 .77275 L .47801 .82377 L p F P
0 g
s
.686 .449 .558 r
.45583 .8228 m .47801 .82377 L .48037 .77275 L p F P
0 g
s
.768 .724 .812 r
.34407 .41121 m .32665 .42501 L .35759 .46287 L p F P
0 g
s
.768 .724 .812 r
.35759 .46287 m .37584 .45069 L .34407 .41121 L p F P
0 g
s
.842 .731 .741 r
.33951 .4824 m .35759 .46287 L .32665 .42501 L p F P
0 g
s
.623 .683 .886 r
.36303 .40677 m .34407 .41121 L .37584 .45069 L p F P
0 g
s
.623 .683 .886 r
.37584 .45069 m .39425 .44605 L .36303 .40677 L p F P
0 g
s
.1 .113 .585 r
.5073 .7013 m .51702 .68743 L .50814 .63904 L p F P
0 g
s
.002 0 .474 r
.51702 .68743 m .5073 .7013 L .51148 .75291 L p F P
0 g
s
.31 .205 .57 r
.49803 .76587 m .51148 .75291 L .5073 .7013 L p F P
0 g
s
.104 .346 .814 r
.43184 .45934 m .41288 .44899 L .43971 .49292 L p F P
0 g
s
.104 .346 .814 r
.43971 .49292 m .45589 .49896 L .43184 .45934 L p F P
0 g
s
.872 .629 .569 r
.40021 .71545 m .36778 .70786 L .36945 .74191 L p F P
0 g
s
.872 .629 .569 r
.36945 .74191 m .40259 .75787 L .40021 .71545 L p F P
0 g
s
.868 .703 .676 r
.33951 .4824 m .32171 .50889 L .34463 .54437 L p F P
0 g
s
.894 .702 .636 r
.323 .57004 m .34463 .54437 L .32171 .50889 L p F P
0 g
s
.886 .686 .628 r
.34463 .54437 m .323 .57004 L .33916 .60209 L p F P
0 g
s
.839 .584 .554 r
.43244 .76855 m .40259 .75787 L .39976 .79698 L p F P
0 g
s
.839 .584 .554 r
.39976 .79698 m .42962 .81374 L .43244 .76855 L p F P
0 g
s
.217 .07 .457 r
.51148 .75291 m .49803 .76587 L .49598 .81641 L p F P
0 g
s
.512 .304 .534 r
.47801 .82377 m .49598 .81641 L .49803 .76587 L p F P
0 g
s
.842 .731 .741 r
.32665 .42501 m .31078 .44788 L .33951 .4824 L p F P
0 g
s
.882 .726 .684 r
.32171 .50889 m .33951 .4824 L .31078 .44788 L p F P
0 g
s
.356 .561 .913 r
.38354 .41174 m .36303 .40677 L .39425 .44605 L p F P
0 g
s
.356 .561 .913 r
.39425 .44605 m .41288 .44899 L .38354 .41174 L p F P
0 g
s
0 .105 .644 r
.48935 .54763 m .47706 .54319 L .49466 .59042 L p F P
0 g
s
0 .105 .644 r
.49466 .59042 m .50427 .58769 L .48935 .54763 L p F P
0 g
s
0 .034 .577 r
.50427 .58769 m .49466 .59042 L .50814 .63904 L p F P
0 g
s
0 .034 .577 r
.50814 .63904 m .51572 .62893 L .50427 .58769 L p F P
0 g
s
0 0 .481 r
.51572 .62893 m .50814 .63904 L .51702 .68743 L p F P
0 g
s
0 .144 .684 r
.47149 .51018 m .45589 .49896 L .47706 .54319 L p F P
0 g
s
0 .144 .684 r
.47706 .54319 m .48935 .54763 L .47149 .51018 L p F P
0 g
s
.901 .678 .59 r
.32197 .64682 m .35231 .63661 L .33916 .60209 L p F P
0 g
s
.898 .668 .581 r
.35231 .63661 m .32197 .64682 L .32878 .67209 L p F P
0 g
s
.898 .668 .581 r
.32878 .67209 m .36197 .67231 L .35231 .63661 L p F P
0 g
s
.874 .618 .548 r
.40259 .75787 m .36945 .74191 L .36683 .77311 L p F P
0 g
s
.874 .618 .548 r
.36683 .77311 m .39976 .79698 L .40259 .75787 L p F P
0 g
s
.897 .658 .57 r
.36197 .67231 m .32878 .67209 L .33277 .69721 L p F P
0 g
s
.897 .658 .57 r
.33277 .69721 m .36778 .70786 L .36197 .67231 L p F P
0 g
s
.906 .688 .597 r
.31263 .6224 m .33916 .60209 L .323 .57004 L p F P
0 g
s
.901 .678 .59 r
.33916 .60209 m .31263 .6224 L .32197 .64682 L p F P
0 g
s
.882 .726 .684 r
.31078 .44788 m .29652 .47926 L .32171 .50889 L p F P
0 g
s
.904 .718 .64 r
.30439 .54172 m .32171 .50889 L .29652 .47926 L p F P
0 g
s
.894 .702 .636 r
.32171 .50889 m .30439 .54172 L .323 .57004 L p F P
0 g
s
.002 0 .474 r
.51148 .75291 m .52089 .73391 L .51702 .68743 L p F P
0 g
s
0 0 .306 r
.52089 .73391 m .51148 .75291 L .50975 .80069 L p F P
0 g
s
.217 .07 .457 r
.49598 .81641 m .50975 .80069 L .51148 .75291 L p F P
0 g
s
0 .339 .82 r
.40565 .4259 m .38354 .41174 L .41288 .44899 L p F P
0 g
s
0 .339 .82 r
.41288 .44899 m .43184 .45934 L .40565 .4259 L p F P
0 g
s
.676 .397 .491 r
.47801 .82377 m .45583 .8228 L .4467 .86625 L p F P
0 g
s
.785 .505 .513 r
.45583 .8228 m .42962 .81374 L .42075 .85347 L p F P
0 g
s
.785 .505 .513 r
.42075 .85347 m .4467 .86625 L .45583 .8228 L p F P
0 g
s
.456 .195 .429 r
.49598 .81641 m .47801 .82377 L .469 .86888 L p F P
0 g
s
.676 .397 .491 r
.4467 .86625 m .469 .86888 L .47801 .82377 L p F P
0 g
s
0 0 .481 r
.51702 .68743 m .52328 .66988 L .51572 .62893 L p F P
0 g
s
0 0 .342 r
.52328 .66988 m .51702 .68743 L .52089 .73391 L p F P
0 g
s
.789 .777 .841 r
.31042 .38056 m .29387 .39576 L .32665 .42501 L p F P
0 g
s
.789 .777 .841 r
.32665 .42501 m .34407 .41121 L .31042 .38056 L p F P
0 g
s
.864 .767 .754 r
.31078 .44788 m .32665 .42501 L .29387 .39576 L p F P
0 g
s
.897 .649 .557 r
.36778 .70786 m .33277 .69721 L .33376 .72116 L p F P
0 g
s
.897 .649 .557 r
.33376 .72116 m .36945 .74191 L .36778 .70786 L p F P
0 g
s
0 .148 .691 r
.45129 .47678 m .43184 .45934 L .45589 .49896 L p F P
0 g
s
0 .148 .691 r
.45589 .49896 m .47149 .51018 L .45129 .47678 L p F P
0 g
s
.616 .744 .937 r
.33002 .37625 m .31042 .38056 L .34407 .41121 L p F P
0 g
s
.616 .744 .937 r
.34407 .41121 m .36303 .40677 L .33002 .37625 L p F P
0 g
s
.912 .699 .602 r
.30112 .59983 m .323 .57004 L .30439 .54172 L p F P
0 g
s
.906 .688 .597 r
.323 .57004 m .30112 .59983 L .31263 .6224 L p F P
0 g
s
.844 .568 .521 r
.42962 .81374 m .39976 .79698 L .39159 .83114 L p F P
0 g
s
.844 .568 .521 r
.39159 .83114 m .42075 .85347 L .42962 .81374 L p F P
0 g
s
.864 .767 .754 r
.29387 .39576 m .28038 .42145 L .31078 .44788 L p F P
0 g
s
.899 .75 .688 r
.29652 .47926 m .31078 .44788 L .28038 .42145 L p F P
0 g
s
.054 0 .274 r
.50975 .80069 m .49598 .81641 L .48742 .86105 L p F P
0 g
s
.456 .195 .429 r
.469 .86888 m .48742 .86105 L .49598 .81641 L p F P
0 g
s
.256 .58 .944 r
.35264 .38289 m .33002 .37625 L .36303 .40677 L p F P
0 g
s
.256 .58 .944 r
.36303 .40677 m .38354 .41174 L .35264 .38289 L p F P
0 g
s
.898 .642 .542 r
.36945 .74191 m .33376 .72116 L .33165 .74294 L p F P
0 g
s
.898 .642 .542 r
.33165 .74294 m .36683 .77311 L .36945 .74191 L p F P
0 g
s
.878 .607 .524 r
.39976 .79698 m .36683 .77311 L .35988 .80011 L p F P
0 g
s
.878 .607 .524 r
.35988 .80011 m .39159 .83114 L .39976 .79698 L p F P
0 g
s
.904 .718 .64 r
.29652 .47926 m .28401 .51832 L .30439 .54172 L p F P
0 g
s
.919 .709 .604 r
.28788 .58004 m .30439 .54172 L .28401 .51832 L p F P
0 g
s
.912 .699 .602 r
.30439 .54172 m .28788 .58004 L .30112 .59983 L p F P
0 g
s
.899 .75 .688 r
.28038 .42145 m .26996 .45688 L .29652 .47926 L p F P
0 g
s
.917 .734 .64 r
.28401 .51832 m .29652 .47926 L .26996 .45688 L p F P
0 g
s
0 0 .342 r
.52089 .73391 m .52661 .70904 L .52328 .66988 L p F P
0 g
s
0 0 .141 r
.52661 .70904 m .52089 .73391 L .51947 .77674 L p F P
0 g
s
0 0 .306 r
.50975 .80069 m .51947 .77674 L .52089 .73391 L p F P
0 g
s
0 .106 .641 r
.42943 .44877 m .40565 .4259 L .43184 .45934 L p F P
0 g
s
0 .106 .641 r
.43184 .45934 m .45129 .47678 L .42943 .44877 L p F P
0 g
s
0 0 .546 r
.50046 .5549 m .48935 .54763 L .50427 .58769 L p F P
0 g
s
0 0 .546 r
.50427 .58769 m .51191 .5857 L .50046 .5549 L p F P
0 g
s
0 0 .48 r
.51191 .5857 m .50427 .58769 L .51572 .62893 L p F P
0 g
s
0 0 .048 r
.51947 .77674 m .50975 .80069 L .50189 .84271 L p F P
0 g
s
.054 0 .274 r
.48742 .86105 m .50189 .84271 L .50975 .80069 L p F P
0 g
s
0 .272 .746 r
.37824 .40019 m .35264 .38289 L .38354 .41174 L p F P
0 g
s
0 .272 .746 r
.38354 .41174 m .40565 .4259 L .37824 .40019 L p F P
0 g
s
0 0 .48 r
.51572 .62893 m .52072 .6174 L .51191 .5857 L p F P
0 g
s
0 0 .376 r
.52072 .6174 m .51572 .62893 L .52328 .66988 L p F P
0 g
s
.918 .682 .566 r
.29055 .65744 m .32197 .64682 L .31263 .6224 L p F P
0 g
s
.916 .676 .56 r
.32197 .64682 m .29055 .65744 L .2941 .67069 L p F P
0 g
s
.916 .676 .56 r
.2941 .67069 m .32878 .67209 L .32197 .64682 L p F P
0 g
s
0 0 .576 r
.4868 .52619 m .47149 .51018 L .48935 .54763 L p F P
0 g
s
0 0 .576 r
.48935 .54763 m .50046 .5549 L .4868 .52619 L p F P
0 g
s
.915 .67 .553 r
.32878 .67209 m .2941 .67069 L .29613 .68383 L p F P
0 g
s
.915 .67 .553 r
.29613 .68383 m .33277 .69721 L .32878 .67209 L p F P
0 g
s
.921 .688 .57 r
.28564 .64466 m .31263 .6224 L .30112 .59983 L p F P
0 g
s
.918 .682 .566 r
.31263 .6224 m .28564 .64466 L .29055 .65744 L p F P
0 g
s
.662 .328 .398 r
.469 .86888 m .4467 .86625 L .43105 .90188 L p F P
0 g
s
.79 .475 .455 r
.4467 .86625 m .42075 .85347 L .40585 .88586 L p F P
0 g
s
.79 .475 .455 r
.40585 .88586 m .43105 .90188 L .4467 .86625 L p F P
0 g
s
.901 .635 .526 r
.36683 .77311 m .33165 .74294 L .32647 .76157 L p F P
0 g
s
.901 .635 .526 r
.32647 .76157 m .35988 .80011 L .36683 .77311 L p F P
0 g
s
.915 .665 .545 r
.33277 .69721 m .29613 .68383 L .29654 .69628 L p F P
0 g
s
.915 .665 .545 r
.29654 .69628 m .33376 .72116 L .33277 .69721 L p F P
0 g
s
.924 .694 .572 r
.27957 .6329 m .30112 .59983 L .28788 .58004 L p F P
0 g
s
.921 .688 .57 r
.30112 .59983 m .27957 .6329 L .28564 .64466 L p F P
0 g
s
.919 .709 .604 r
.28401 .51832 m .27343 .56388 L .28788 .58004 L p F P
0 g
s
.917 .734 .64 r
.26996 .45688 m .26262 .50094 L .28401 .51832 L p F P
0 g
s
.927 .719 .602 r
.27343 .56388 m .28401 .51832 L .26262 .50094 L p F P
0 g
s
0 0 .376 r
.52328 .66988 m .52655 .64879 L .52072 .6174 L p F P
0 g
s
0 0 .225 r
.52655 .64879 m .52328 .66988 L .52661 .70904 L p F P
0 g
s
.356 .022 .255 r
.48742 .86105 m .469 .86888 L .45328 .90596 L p F P
0 g
s
.662 .328 .398 r
.43105 .90188 m .45328 .90596 L .469 .86888 L p F P
0 g
s
.851 .552 .482 r
.42075 .85347 m .39159 .83114 L .37818 .85871 L p F P
0 g
s
.851 .552 .482 r
.37818 .85871 m .40585 .88586 L .42075 .85347 L p F P
0 g
s
0 0 .561 r
.47143 .50071 m .45129 .47678 L .47149 .51018 L p F P
0 g
s
0 0 .561 r
.47149 .51018 m .4868 .52619 L .47143 .50071 L p F P
0 g
s
.814 .84 .869 r
.27608 .36049 m .26043 .3768 L .29387 .39576 L p F P
0 g
s
.814 .84 .869 r
.29387 .39576 m .31042 .38056 L .27608 .36049 L p F P
0 g
s
.89 .807 .76 r
.28038 .42145 m .29387 .39576 L .26043 .3768 L p F P
0 g
s
.89 .807 .76 r
.26043 .3768 m .24944 .40463 L .28038 .42145 L p F P
0 g
s
.918 .775 .686 r
.26996 .45688 m .28038 .42145 L .24944 .40463 L p F P
0 g
s
.584 .813 .986 r
.29641 .35623 m .27608 .36049 L .31042 .38056 L p F P
0 g
s
.584 .813 .986 r
.31042 .38056 m .33002 .37625 L .29641 .35623 L p F P
0 g
s
.916 .66 .536 r
.33376 .72116 m .29654 .69628 L .2953 .70751 L p F P
0 g
s
.916 .66 .536 r
.2953 .70751 m .33165 .74294 L .33376 .72116 L p F P
0 g
s
.885 .599 .498 r
.39159 .83114 m .35988 .80011 L .34873 .82162 L p F P
0 g
s
.885 .599 .498 r
.34873 .82162 m .37818 .85871 L .39159 .83114 L p F P
0 g
s
0 0 0 r
.50189 .84271 m .48742 .86105 L .47225 .89766 L p F P
0 g
s
.356 .022 .255 r
.45328 .90596 m .47225 .89766 L .48742 .86105 L p F P
0 g
s
.928 .7 .572 r
.2726 .62268 m .28788 .58004 L .27343 .56388 L p F P
0 g
s
.924 .694 .572 r
.28788 .58004 m .2726 .62268 L .27957 .6329 L p F P
0 g
s
0 0 .141 r
.51947 .77674 m .52548 .74489 L .52661 .70904 L p F P
0 g
s
0 0 0 r
.52548 .74489 m .51947 .77674 L .51257 .81414 L p F P
0 g
s
0 0 .048 r
.50189 .84271 m .51257 .81414 L .51947 .77674 L p F P
0 g
s
.918 .775 .686 r
.24944 .40463 m .24304 .44301 L .26996 .45688 L p F P
0 g
s
.93 .749 .635 r
.26262 .50094 m .26996 .45688 L .24304 .44301 L p F P
0 g
s
.502 0 0 r
.40672 .42748 m .37824 .40019 L .40565 .4259 L p F P
0 g
s
.502 0 0 r
.40565 .4259 m .42943 .44877 L .40672 .42748 L p F P
0 g
s
.048 .532 .887 r
.32133 .36408 m .29641 .35623 L .33002 .37625 L p F P
0 g
s
.048 .532 .887 r
.33002 .37625 m .35264 .38289 L .32133 .36408 L p F P
0 g
s
.662 .553 .721 r
.80977 .45566 m .78768 .46325 L .80689 .52275 L p F P
0 g
s
.662 .553 .721 r
.80689 .52275 m .82925 .51602 L .80977 .45566 L p F P
0 g
s
.743 .598 .696 r
.77866 .5301 m .80689 .52275 L .78768 .46325 L p F P
0 g
s
.649 .51 .681 r
.82925 .51602 m .80689 .52275 L .82239 .58252 L p F P
0 g
s
.733 .562 .66 r
.80689 .52275 m .77866 .5301 L .79314 .58654 L p F P
0 g
s
.733 .562 .66 r
.79314 .58654 m .82239 .58252 L .80689 .52275 L p F P
0 g
s
.674 .595 .759 r
.78722 .39738 m .76533 .40584 L .78768 .46325 L p F P
0 g
s
.674 .595 .759 r
.78768 .46325 m .80977 .45566 L .78722 .39738 L p F P
0 g
s
.755 .636 .729 r
.76051 .47395 m .78768 .46325 L .76533 .40584 L p F P
0 g
s
.743 .598 .696 r
.78768 .46325 m .76051 .47395 L .77866 .5301 L p F P
0 g
s
0 0 .225 r
.52661 .70904 m .52913 .67865 L .52655 .64879 L p F P
0 g
s
0 0 .021 r
.52913 .67865 m .52661 .70904 L .52548 .74489 L p F P
0 g
s
0 0 .482 r
.45493 .47955 m .42943 .44877 L .45129 .47678 L p F P
0 g
s
0 0 .482 r
.45129 .47678 m .47143 .50071 L .45493 .47955 L p F P
0 g
s
.508 .462 .741 r
.8268 .45121 m .80977 .45566 L .82925 .51602 L p F P
0 g
s
.508 .462 .741 r
.82925 .51602 m .84574 .5099 L .8268 .45121 L p F P
0 g
s
.49 .411 .694 r
.84574 .5099 m .82925 .51602 L .84509 .57662 L p F P
0 g
s
.649 .51 .681 r
.82239 .58252 m .84509 .57662 L .82925 .51602 L p F P
0 g
s
.79 .623 .674 r
.74458 .53811 m .77866 .5301 L .76051 .47395 L p F P
0 g
s
.781 .59 .641 r
.77866 .5301 m .74458 .53811 L .75742 .58878 L p F P
0 g
s
.781 .59 .641 r
.75742 .58878 m .79314 .58654 L .77866 .5301 L p F P
0 g
s
.518 .509 .785 r
.80498 .39452 m .78722 .39738 L .80977 .45566 L p F P
0 g
s
.518 .509 .785 r
.80977 .45566 m .8268 .45121 L .80498 .39452 L p F P
0 g
s
.755 .636 .729 r
.76533 .40584 m .73928 .41985 L .76051 .47395 L p F P
0 g
s
.801 .657 .703 r
.72829 .48771 m .76051 .47395 L .73928 .41985 L p F P
0 g
s
.79 .623 .674 r
.76051 .47395 m .72829 .48771 L .74458 .53811 L p F P
0 g
s
.906 .63 .509 r
.35988 .80011 m .32647 .76157 L .31835 .77617 L p F P
0 g
s
.906 .63 .509 r
.31835 .77617 m .34873 .82162 L .35988 .80011 L p F P
0 g
s
.918 .657 .527 r
.33165 .74294 m .2953 .70751 L .29245 .71699 L p F P
0 g
s
.918 .657 .527 r
.29245 .71699 m .32647 .76157 L .33165 .74294 L p F P
0 g
s
0 0 0 r
.47225 .89766 m .48786 .87698 L .50189 .84271 L p F P
0 g
s
.696 .776 .292 r
.51257 .81414 m .50189 .84271 L .48786 .87698 L p F P
0 g
s
.928 .7 .572 r
.27343 .56388 m .26503 .61445 L .2726 .62268 L p F P
0 g
s
.927 .719 .602 r
.26262 .50094 m .25836 .55213 L .27343 .56388 L p F P
0 g
s
.933 .705 .571 r
.26503 .61445 m .27343 .56388 L .25836 .55213 L p F P
0 g
s
.93 .749 .635 r
.24304 .44301 m .24107 .49054 L .26262 .50094 L p F P
0 g
s
.935 .728 .598 r
.25836 .55213 m .26262 .50094 L .24107 .49054 L p F P
0 g
s
.634 .464 .635 r
.84509 .57662 m .82239 .58252 L .83362 .64071 L p F P
0 g
s
.724 .523 .618 r
.82239 .58252 m .79314 .58654 L .80344 .64145 L p F P
0 g
s
.724 .523 .618 r
.80344 .64145 m .83362 .64071 L .82239 .58252 L p F P
0 g
s
.686 .639 .797 r
.76226 .34302 m .74049 .35236 L .76533 .40584 L p F P
0 g
s
.686 .639 .797 r
.76533 .40584 m .78722 .39738 L .76226 .34302 L p F P
0 g
s
.77 .676 .759 r
.73928 .41985 m .76533 .40584 L .74049 .35236 L p F P
0 g
s
.447 0 0 r
.35064 .38365 m .32133 .36408 L .35264 .38289 L p F P
0 g
s
.447 0 0 r
.35264 .38289 m .37824 .40019 L .35064 .38365 L p F P
0 g
s
.775 .556 .603 r
.79314 .58654 m .75742 .58878 L .76634 .63802 L p F P
0 g
s
.775 .556 .603 r
.76634 .63802 m .80344 .64145 L .79314 .58654 L p F P
0 g
s
.49 .411 .694 r
.84509 .57662 m .86123 .56879 L .84574 .5099 L p F P
0 g
s
.462 .349 .639 r
.86123 .56879 m .84509 .57662 L .85673 .6356 L p F P
0 g
s
.634 .464 .635 r
.83362 .64071 m .85673 .6356 L .84509 .57662 L p F P
0 g
s
.77 .676 .759 r
.74049 .35236 m .71559 .36956 L .73928 .41985 L p F P
0 g
s
.816 .693 .729 r
.70909 .43924 m .73928 .41985 L .71559 .36956 L p F P
0 g
s
.801 .657 .703 r
.73928 .41985 m .70909 .43924 L .72829 .48771 L p F P
0 g
s
.521 .553 .829 r
.78091 .34166 m .76226 .34302 L .78722 .39738 L p F P
0 g
s
.521 .553 .829 r
.78722 .39738 m .80498 .39452 L .78091 .34166 L p F P
0 g
s
.817 .637 .658 r
.70479 .54681 m .74458 .53811 L .72829 .48771 L p F P
0 g
s
.81 .606 .627 r
.74458 .53811 m .70479 .54681 L .71543 .58941 L p F P
0 g
s
.81 .606 .627 r
.71543 .58941 m .75742 .58878 L .74458 .53811 L p F P
0 g
s
.932 .684 .541 r
.25912 .66814 m .29055 .65744 L .28564 .64466 L closepath p F P
0 g
s
.931 .682 .539 r
.25912 .66814 m .2941 .67069 L .29055 .65744 L closepath p F P
0 g
s
.213 .274 .71 r
.83879 .44988 m .8268 .45121 L .84574 .5099 L p F P
0 g
s
.213 .274 .71 r
.84574 .5099 m .85638 .50438 L .83879 .44988 L p F P
0 g
s
.185 .21 .654 r
.85638 .50438 m .84574 .5099 L .86123 .56879 L p F P
0 g
s
.828 .668 .684 r
.69109 .50443 m .72829 .48771 L .70909 .43924 L p F P
0 g
s
.817 .637 .658 r
.72829 .48771 m .69109 .50443 L .70479 .54681 L p F P
0 g
s
0 0 .468 r
.51082 .56463 m .50046 .5549 L .51191 .5857 L p F P
0 g
s
0 0 .468 r
.51191 .5857 m .51811 .58426 L .51082 .56463 L p F P
0 g
s
0 0 .404 r
.51811 .58426 m .51191 .5857 L .52072 .6174 L p F P
0 g
s
.216 .32 .756 r
.8186 .39725 m .80498 .39452 L .8268 .45121 L p F P
0 g
s
.216 .32 .756 r
.8268 .45121 m .83879 .44988 L .8186 .39725 L p F P
0 g
s
.931 .68 .537 r
.25912 .66814 m .29613 .68383 L .2941 .67069 L closepath p F P
0 g
s
.933 .686 .542 r
.25912 .66814 m .28564 .64466 L .27957 .6329 L closepath p F P
0 g
s
0 0 .404 r
.52072 .6174 m .52374 .60446 L .51811 .58426 L p F P
0 g
s
0 0 .298 r
.52374 .60446 m .52072 .6174 L .52655 .64879 L p F P
0 g
s
0 0 .491 r
.50216 .54638 m .4868 .52619 L .50046 .5549 L p F P
0 g
s
0 0 .491 r
.50046 .5549 m .51082 .56463 L .50216 .54638 L p F P
0 g
s
.931 .678 .534 r
.25912 .66814 m .29654 .69628 L .29613 .68383 L closepath p F P
0 g
s
.934 .688 .543 r
.25912 .66814 m .27957 .6329 L .2726 .62268 L closepath p F P
0 g
s
.921 .654 .517 r
.32647 .76157 m .29245 .71699 L .28809 .72427 L p F P
0 g
s
.921 .654 .517 r
.28809 .72427 m .31835 .77617 L .32647 .76157 L p F P
0 g
s
0 0 .021 r
.52548 .74489 m .52829 .70575 L .52913 .67865 L p F P
0 g
s
0 0 0 r
.51257 .81414 m .51976 .77591 L .52548 .74489 L p F P
0 g
s
.818 .74 .217 r
.52829 .70575 m .52548 .74489 L .51976 .77591 L p F P
0 g
s
.797 .44 .381 r
.43105 .90188 m .40585 .88586 L .38516 .90906 L p F P
0 g
s
.861 .538 .438 r
.40585 .88586 m .37818 .85871 L .35981 .87814 L p F P
0 g
s
.861 .538 .438 r
.35981 .87814 m .38516 .90906 L .40585 .88586 L p F P
0 g
s
.935 .728 .598 r
.24107 .49054 m .2433 .54542 L .25836 .55213 L p F P
0 g
s
.938 .71 .568 r
.2572 .60861 m .25836 .55213 L .2433 .54542 L p F P
0 g
s
.933 .705 .571 r
.25836 .55213 m .2572 .60861 L .26503 .61445 L p F P
0 g
s
.636 .23 .257 r
.45328 .90596 m .43105 .90188 L .40907 .92765 L p F P
0 g
s
.797 .44 .381 r
.38516 .90906 m .40907 .92765 L .43105 .90188 L p F P
0 g
s
.65 .144 0 r
.43794 .4637 m .40672 .42748 L .42943 .44877 L p F P
0 g
s
.65 .144 0 r
.42943 .44877 m .45493 .47955 L .43794 .4637 L p F P
0 g
s
.805 .576 .592 r
.75742 .58878 m .71543 .58941 L .72259 .63073 L p F P
0 g
s
.805 .576 .592 r
.72259 .63073 m .76634 .63802 L .75742 .58878 L p F P
0 g
s
.874 .853 .397 r
.51976 .77591 m .51257 .81414 L .50018 .84435 L p F P
0 g
s
.696 .776 .292 r
.48786 .87698 m .50018 .84435 L .51257 .81414 L p F P
0 g
s
.893 .592 .469 r
.37818 .85871 m .34873 .82162 L .33369 .83645 L p F P
0 g
s
.893 .592 .469 r
.33369 .83645 m .35981 .87814 L .37818 .85871 L p F P
0 g
s
.816 .693 .729 r
.71559 .36956 m .68757 .39436 L .70909 .43924 L p F P
0 g
s
.843 .702 .707 r
.67481 .46378 m .70909 .43924 L .68757 .39436 L p F P
0 g
s
.828 .668 .684 r
.70909 .43924 m .67481 .46378 L .69109 .50443 L p F P
0 g
s
.931 .677 .531 r
.25912 .66814 m .2953 .70751 L .29654 .69628 L closepath p F P
0 g
s
.92 .849 .756 r
.22769 .36968 m .21925 .39876 L .24944 .40463 L p F P
0 g
s
.92 .849 .756 r
.24944 .40463 m .26043 .3768 L .22769 .36968 L p F P
0 g
s
.94 .798 .676 r
.24304 .44301 m .24944 .40463 L .21925 .39876 L p F P
0 g
s
.185 .21 .654 r
.86123 .56879 m .87081 .55902 L .85638 .50438 L p F P
0 g
s
.13 .125 .583 r
.87081 .55902 m .86123 .56879 L .87271 .62603 L p F P
0 g
s
.462 .349 .639 r
.85673 .6356 m .87271 .62603 L .86123 .56879 L p F P
0 g
s
.935 .69 .543 r
.25912 .66814 m .2726 .62268 L .26503 .61445 L closepath p F P
0 g
s
0 0 .298 r
.52655 .64879 m .52745 .62441 L .52374 .60446 L p F P
0 g
s
0 0 .147 r
.52745 .62441 m .52655 .64879 L .52913 .67865 L p F P
0 g
s
.617 .41 .579 r
.85673 .6356 m .83362 .64071 L .84009 .69539 L p F P
0 g
s
.717 .481 .568 r
.83362 .64071 m .80344 .64145 L .80909 .69298 L p F P
0 g
s
.717 .481 .568 r
.80909 .69298 m .84009 .69539 L .83362 .64071 L p F P
0 g
s
.839 .915 .886 r
.24246 .35265 m .22769 .36968 L .26043 .3768 L p F P
0 g
s
.839 .915 .886 r
.26043 .3768 m .27608 .36049 L .24246 .35265 L p F P
0 g
s
.194 .353 .795 r
.79641 .34825 m .78091 .34166 L .80498 .39452 L p F P
0 g
s
.194 .353 .795 r
.80498 .39452 m .8186 .39725 L .79641 .34825 L p F P
0 g
s
.151 0 0 r
.47225 .89766 m .45328 .90596 L .43101 .93285 L p F P
0 g
s
.636 .23 .257 r
.40907 .92765 m .43101 .93285 L .45328 .90596 L p F P
0 g
s
0 0 .465 r
.49247 .5303 m .47143 .50071 L .4868 .52619 L p F P
0 g
s
0 0 .465 r
.4868 .52619 m .50216 .54638 L .49247 .5303 L p F P
0 g
s
.666 .126 0 r
.38406 .41408 m .35064 .38365 L .37824 .40019 L p F P
0 g
s
.666 .126 0 r
.37824 .40019 m .40672 .42748 L .38406 .41408 L p F P
0 g
s
.94 .798 .676 r
.21925 .39876 m .21692 .43873 L .24304 .44301 L p F P
0 g
s
.944 .762 .625 r
.24107 .49054 m .24304 .44301 L .21692 .43873 L p F P
0 g
s
.699 .687 .835 r
.73561 .29446 m .71388 .30467 L .74049 .35236 L p F P
0 g
s
.699 .687 .835 r
.74049 .35236 m .76226 .34302 L .73561 .29446 L p F P
0 g
s
.788 .72 .789 r
.71559 .36956 m .74049 .35236 L .71388 .30467 L p F P
0 g
s
.771 .521 .557 r
.80344 .64145 m .76634 .63802 L .77091 .68408 L p F P
0 g
s
.771 .521 .557 r
.77091 .68408 m .80909 .69298 L .80344 .64145 L p F P
0 g
s
.912 .627 .491 r
.34873 .82162 m .31835 .77617 L .30758 .78596 L p F P
0 g
s
.912 .627 .491 r
.30758 .78596 m .33369 .83645 L .34873 .82162 L p F P
0 g
s
.472 .855 .981 r
.26358 .34833 m .24246 .35265 L .27608 .36049 L p F P
0 g
s
.472 .855 .981 r
.27608 .36049 m .29641 .35623 L .26358 .34833 L p F P
0 g
s
.419 .27 .571 r
.87271 .62603 m .85673 .6356 L .86367 .69101 L p F P
0 g
s
.617 .41 .579 r
.84009 .69539 m .86367 .69101 L .85673 .6356 L p F P
0 g
s
.788 .72 .789 r
.71388 .30467 m .69014 .32489 L .71559 .36956 L p F P
0 g
s
.835 .733 .752 r
.68757 .39436 m .71559 .36956 L .69014 .32489 L p F P
0 g
s
.932 .676 .527 r
.25912 .66814 m .29245 .71699 L .2953 .70751 L closepath p F P
0 g
s
.937 .692 .542 r
.25912 .66814 m .26503 .61445 L .2572 .60861 L closepath p F P
0 g
s
.944 .762 .625 r
.21692 .43873 m .22032 .48791 L .24107 .49054 L p F P
0 g
s
.944 .735 .589 r
.2433 .54542 m .24107 .49054 L .22032 .48791 L p F P
0 g
s
.514 .597 .875 r
.75532 .29446 m .73561 .29446 L .76226 .34302 L p F P
0 g
s
.514 .597 .875 r
.76226 .34302 m .78091 .34166 L .75532 .29446 L p F P
0 g
s
.151 0 0 r
.43101 .93285 m .45065 .92413 L .47225 .89766 L p F P
0 g
s
.602 .843 .472 r
.48786 .87698 m .47225 .89766 L .45065 .92413 L p F P
0 g
s
.834 .645 .646 r
.65954 .55621 m .70479 .54681 L .69109 .50443 L p F P
0 g
s
.827 .616 .618 r
.70479 .54681 m .65954 .55621 L .6675 .58865 L p F P
0 g
s
.827 .616 .618 r
.6675 .58865 m .71543 .58941 L .70479 .54681 L p F P
0 g
s
.845 .674 .671 r
.6491 .52394 m .69109 .50443 L .67481 .46378 L p F P
0 g
s
.834 .645 .646 r
.69109 .50443 m .6491 .52394 L .65954 .55621 L p F P
0 g
s
0 0 .147 r
.52913 .67865 m .52909 .64326 L .52745 .62441 L p F P
0 g
s
.74 .616 .049 r
.52909 .64326 m .52913 .67865 L .52829 .70575 L p F P
0 g
s
.276 0 0 r
.29089 .35681 m .26358 .34833 L .29641 .35623 L p F P
0 g
s
.276 0 0 r
.29641 .35623 m .32133 .36408 L .29089 .35681 L p F P
0 g
s
0 0 .532 r
.84575 .45164 m .83879 .44988 L .85638 .50438 L p F P
0 g
s
0 0 .532 r
.85638 .50438 m .86119 .49949 L .84575 .45164 L p F P
0 g
s
0 0 .471 r
.86119 .49949 m .85638 .50438 L .87081 .55902 L p F P
0 g
s
.924 .653 .507 r
.31835 .77617 m .28809 .72427 L .2824 .729 L p F P
0 g
s
.924 .653 .507 r
.2824 .729 m .30758 .78596 L .31835 .77617 L p F P
0 g
s
0 0 .569 r
.82807 .40549 m .8186 .39725 L .83879 .44988 L p F P
0 g
s
0 0 .569 r
.83879 .44988 m .84575 .45164 L .82807 .40549 L p F P
0 g
s
.61 .151 0 r
.48216 .5171 m .45493 .47955 L .47143 .50071 L p F P
0 g
s
.61 .151 0 r
.47143 .50071 m .49247 .5303 L .48216 .5171 L p F P
0 g
s
.803 .545 .549 r
.76634 .63802 m .72259 .63073 L .72594 .66921 L p F P
0 g
s
.803 .545 .549 r
.72594 .66921 m .77091 .68408 L .76634 .63802 L p F P
0 g
s
.933 .675 .524 r
.25912 .66814 m .28809 .72427 L .29245 .71699 L closepath p F P
0 g
s
.944 .735 .589 r
.22032 .48791 m .22894 .54419 L .2433 .54542 L p F P
0 g
s
.943 .713 .562 r
.24944 .60545 m .2433 .54542 L .22894 .54419 L p F P
0 g
s
.938 .71 .568 r
.2433 .54542 m .24944 .60545 L .2572 .60861 L p F P
0 g
s
.938 .693 .541 r
.25912 .66814 m .2572 .60861 L .24944 .60545 L closepath p F P
0 g
s
.835 .733 .752 r
.69014 .32489 m .66443 .35473 L .68757 .39436 L p F P
0 g
s
.861 .738 .726 r
.65649 .42632 m .68757 .39436 L .66443 .35473 L p F P
0 g
s
.843 .702 .707 r
.68757 .39436 m .65649 .42632 L .67481 .46378 L p F P
0 g
s
.823 .588 .584 r
.71543 .58941 m .6675 .58865 L .67267 .62003 L p F P
0 g
s
.823 .588 .584 r
.67267 .62003 m .72259 .63073 L .71543 .58941 L p F P
0 g
s
.13 .125 .583 r
.87271 .62603 m .88155 .61203 L .87081 .55902 L p F P
0 g
s
.038 .005 .487 r
.88155 .61203 m .87271 .62603 L .8797 .67972 L p F P
0 g
s
.419 .27 .571 r
.86367 .69101 m .8797 .67972 L .87271 .62603 L p F P
0 g
s
.859 .706 .692 r
.63658 .49307 m .67481 .46378 L .65649 .42632 L p F P
0 g
s
.845 .674 .671 r
.67481 .46378 m .63658 .49307 L .6491 .52394 L p F P
0 g
s
.89 .944 .583 r
.50018 .84435 m .48786 .87698 L .46781 .90152 L p F P
0 g
s
.602 .843 .472 r
.45065 .92413 m .46781 .90152 L .48786 .87698 L p F P
0 g
s
.139 .368 .824 r
.77293 .30462 m .75532 .29446 L .78091 .34166 L p F P
0 g
s
.139 .368 .824 r
.78091 .34166 m .79641 .34825 L .77293 .30462 L p F P
0 g
s
0 0 .471 r
.87081 .55902 m .87387 .5474 L .86119 .49949 L p F P
0 g
s
0 0 .383 r
.87387 .5474 m .87081 .55902 L .88155 .61203 L p F P
0 g
s
.818 .74 .217 r
.51976 .77591 m .52396 .72892 L .52829 .70575 L p F P
0 g
s
.936 .863 .435 r
.52396 .72892 m .51976 .77591 L .50949 .80059 L p F P
0 g
s
.874 .853 .397 r
.50018 .84435 m .50949 .80059 L .51976 .77591 L p F P
0 g
s
0 .002 .579 r
.80872 .36262 m .79641 .34825 L .8186 .39725 L p F P
0 g
s
0 .002 .579 r
.8186 .39725 m .82807 .40549 L .80872 .36262 L p F P
0 g
s
.641 .08 0 r
.32403 .37757 m .29089 .35681 L .32133 .36408 L p F P
0 g
s
.641 .08 0 r
.32133 .36408 m .35064 .38365 L .32403 .37757 L p F P
0 g
s
.934 .675 .521 r
.25912 .66814 m .2824 .729 L .28809 .72427 L closepath p F P
0 g
s
.757 .246 0 r
.42118 .45402 m .38406 .41408 L .40672 .42748 L p F P
0 g
s
.757 .246 0 r
.40672 .42748 m .43794 .4637 L .42118 .45402 L p F P
0 g
s
.943 .713 .562 r
.22894 .54419 m .24212 .60516 L .24944 .60545 L p F P
0 g
s
.94 .694 .539 r
.25912 .66814 m .24944 .60545 L .24212 .60516 L closepath p F P
0 g
s
.593 .341 .504 r
.86367 .69101 m .84009 .69539 L .84136 .74452 L p F P
0 g
s
.709 .432 .505 r
.84009 .69539 m .80909 .69298 L .8097 .73916 L p F P
0 g
s
.709 .432 .505 r
.8097 .73916 m .84136 .74452 L .84009 .69539 L p F P
0 g
s
.74 .616 .049 r
.52829 .70575 m .52856 .6602 L .52909 .64326 L p F P
0 g
s
.874 .766 .263 r
.52856 .6602 m .52829 .70575 L .52396 .72892 L p F P
0 g
s
.769 .482 .5 r
.80909 .69298 m .77091 .68408 L .7708 .72518 L p F P
0 g
s
.769 .482 .5 r
.7708 .72518 m .8097 .73916 L .80909 .69298 L p F P
0 g
s
.72 .225 0 r
.47166 .50738 m .43794 .4637 L .45493 .47955 L p F P
0 g
s
.72 .225 0 r
.45493 .47955 m .48216 .5171 L .47166 .50738 L p F P
0 g
s
.712 .743 .876 r
.7081 .25366 m .68633 .26468 L .71388 .30467 L p F P
0 g
s
.712 .743 .876 r
.71388 .30467 m .73561 .29446 L .7081 .25366 L p F P
0 g
s
.81 .772 .817 r
.69014 .32489 m .71388 .30467 L .68633 .26468 L p F P
0 g
s
.822 .56 .543 r
.72259 .63073 m .67267 .62003 L .67479 .64909 L p F P
0 g
s
.822 .56 .543 r
.67479 .64909 m .72594 .66921 L .72259 .63073 L p F P
0 g
s
.81 .772 .817 r
.68633 .26468 m .66377 .28766 L .69014 .32489 L p F P
0 g
s
.858 .778 .772 r
.66443 .35473 m .69014 .32489 L .66377 .28766 L p F P
0 g
s
.919 .626 .473 r
.33369 .83645 m .30758 .78596 L .29457 .79033 L p F P
0 g
s
.928 .653 .497 r
.30758 .78596 m .2824 .729 L .27563 .73089 L p F P
0 g
s
.928 .653 .497 r
.27563 .73089 m .29457 .79033 L .30758 .78596 L p F P
0 g
s
.903 .587 .439 r
.35981 .87814 m .33369 .83645 L .31526 .8436 L p F P
0 g
s
.919 .626 .473 r
.29457 .79033 m .31526 .8436 L .33369 .83645 L p F P
0 g
s
.861 .738 .726 r
.66443 .35473 m .63676 .39351 L .65649 .42632 L p F P
0 g
s
.876 .74 .708 r
.62244 .4648 m .65649 .42632 L .63676 .39351 L p F P
0 g
s
.859 .706 .692 r
.65649 .42632 m .62244 .4648 L .63658 .49307 L p F P
0 g
s
.351 .16 .475 r
.8797 .67972 m .86367 .69101 L .86544 .7408 L p F P
0 g
s
.593 .341 .504 r
.84136 .74452 m .86544 .7408 L .86367 .69101 L p F P
0 g
s
.935 .675 .518 r
.25912 .66814 m .27563 .73089 L .2824 .729 L closepath p F P
0 g
s
.873 .524 .386 r
.38516 .90906 m .35981 .87814 L .33703 .88805 L p F P
0 g
s
.903 .587 .439 r
.31526 .8436 m .33703 .88805 L .35981 .87814 L p F P
0 g
s
.953 .74 .577 r
.20137 .49352 m .21595 .5487 L .22894 .54419 L p F P
0 g
s
.953 .74 .577 r
.22894 .54419 m .22032 .48791 L .20137 .49352 L p F P
0 g
s
.947 .716 .555 r
.24212 .60516 m .22894 .54419 L .21595 .5487 L p F P
0 g
s
.96 .927 .592 r
.50949 .80059 m .50018 .84435 L .48249 .8656 L p F P
0 g
s
.89 .944 .583 r
.46781 .90152 m .48249 .8656 L .50018 .84435 L p F P
0 g
s
.947 .716 .555 r
.21595 .5487 m .23558 .60781 L .24212 .60516 L p F P
0 g
s
.941 .695 .536 r
.25912 .66814 m .24212 .60516 L .23558 .60781 L closepath p F P
0 g
s
.959 .772 .607 r
.19284 .44482 m .20137 .49352 L .22032 .48791 L p F P
0 g
s
.959 .772 .607 r
.22032 .48791 m .21692 .43873 L .19284 .44482 L p F P
0 g
s
.49 .643 .924 r
.72901 .25485 m .7081 .25366 L .73561 .29446 L p F P
0 g
s
.49 .643 .924 r
.73561 .29446 m .75532 .29446 L .72901 .25485 L p F P
0 g
s
.937 .675 .516 r
.25912 .66814 m .26806 .72983 L .27563 .73089 L closepath p F P
0 g
s
.943 .695 .533 r
.25912 .66814 m .23558 .60781 L .23015 .61331 L closepath p F P
0 g
s
.938 .676 .514 r
.25912 .66814 m .26006 .7258 L .26806 .72983 L closepath p F P
0 g
s
.94 .678 .512 r
.25912 .66814 m .25201 .71896 L .26006 .7258 L closepath p F P
0 g
s
.945 .693 .527 r
.25912 .66814 m .22611 .62145 L .22367 .63188 L closepath p F P
0 g
s
.944 .694 .53 r
.25912 .66814 m .23015 .61331 L .22611 .62145 L closepath p F P
0 g
s
.941 .68 .512 r
.25912 .66814 m .24431 .70961 L .25201 .71896 L closepath p F P
0 g
s
.943 .682 .512 r
.25912 .66814 m .23734 .69819 L .24431 .70961 L closepath p F P
0 g
s
.944 .684 .513 r
.25912 .66814 m .23146 .68527 L .23734 .69819 L closepath p F P
0 g
s
.945 .686 .515 r
.25912 .66814 m .22697 .67147 L .23146 .68527 L closepath p F P
0 g
s
.945 .688 .517 r
.25912 .66814 m .2241 .65752 L .22697 .67147 L closepath p F P
0 g
s
.945 .69 .52 r
.25912 .66814 m .22299 .6441 L .2241 .65752 L closepath p F P
0 g
s
.945 .692 .523 r
.25912 .66814 m .22367 .63188 L .22299 .6441 L closepath p F P
0 g
s
.804 .399 .283 r
.40907 .92765 m .38516 .90906 L .35923 .92135 L p F P
0 g
s
.873 .524 .386 r
.33703 .88805 m .35923 .92135 L .38516 .90906 L p F P
0 g
s
.962 .817 .654 r
.19125 .4049 m .19284 .44482 L .21692 .43873 L p F P
0 g
s
.962 .817 .654 r
.21692 .43873 m .21925 .39876 L .19125 .4049 L p F P
0 g
s
.803 .512 .495 r
.77091 .68408 m .72594 .66921 L .72521 .70331 L p F P
0 g
s
.803 .512 .495 r
.72521 .70331 m .7708 .72518 L .77091 .68408 L p F P
0 g
s
.762 .253 0 r
.36244 .40956 m .32403 .37757 L .35064 .38365 L p F P
0 g
s
.762 .253 0 r
.35064 .38365 m .38406 .41408 L .36244 .40956 L p F P
0 g
s
0 0 .383 r
.88155 .61203 m .88331 .59375 L .87387 .5474 L p F P
0 g
s
0 0 .261 r
.88331 .59375 m .88155 .61203 L .88815 .66157 L p F P
0 g
s
.038 .005 .487 r
.8797 .67972 m .88815 .66157 L .88155 .61203 L p F P
0 g
s
.844 .65 .639 r
.60927 .5663 m .65954 .55621 L .6491 .52394 L p F P
0 g
s
.838 .622 .611 r
.65954 .55621 m .60927 .5663 L .6142 .58677 L p F P
0 g
s
.838 .622 .611 r
.6142 .58677 m .6675 .58865 L .65954 .55621 L p F P
0 g
s
.854 .678 .662 r
.60267 .54594 m .6491 .52394 L .63658 .49307 L p F P
0 g
s
.844 .65 .639 r
.6491 .52394 m .60267 .54594 L .60927 .5663 L p F P
0 g
s
.858 .778 .772 r
.66377 .28766 m .64043 .322 L .66443 .35473 L p F P
0 g
s
.884 .779 .74 r
.63676 .39351 m .66443 .35473 L .64043 .322 L p F P
0 g
s
0 0 .556 r
.78834 .32466 m .77293 .30462 L .79641 .34825 L p F P
0 g
s
0 0 .556 r
.79641 .34825 m .80872 .36262 L .78834 .32466 L p F P
0 g
s
.952 .89 .733 r
.19722 .37563 m .19125 .4049 L .21925 .39876 L p F P
0 g
s
.952 .89 .733 r
.21925 .39876 m .22769 .36968 L .19722 .37563 L p F P
0 g
s
.575 .073 .024 r
.43101 .93285 m .40907 .92765 L .38128 .94161 L p F P
0 g
s
.804 .399 .283 r
.35923 .92135 m .38128 .94161 L .40907 .92765 L p F P
0 g
s
0 0 .421 r
.52097 .57629 m .51082 .56463 L .51811 .58426 L p F P
0 g
s
0 0 .421 r
.51811 .58426 m .52351 .58315 L .52097 .57629 L p F P
0 g
s
0 0 .359 r
.52351 .58315 m .51811 .58426 L .52374 .60446 L p F P
0 g
s
.933 .654 .489 r
.29457 .79033 m .27563 .73089 L .26806 .72983 L p F P
0 g
s
0 0 .236 r
.84769 .45643 m .84575 .45164 L .86119 .49949 L p F P
0 g
s
0 0 .236 r
.86119 .49949 m .86022 .49525 L .84769 .45643 L p F P
0 g
s
0 0 .187 r
.86022 .49525 m .86119 .49949 L .87387 .5474 L p F P
0 g
s
0 0 .359 r
.52374 .60446 m .52548 .59022 L .52351 .58315 L p F P
0 g
s
0 0 .254 r
.52548 .59022 m .52374 .60446 L .52745 .62441 L p F P
0 g
s
0 0 .258 r
.83336 .41904 m .82807 .40549 L .84575 .45164 L p F P
0 g
s
0 0 .258 r
.84575 .45164 m .84769 .45643 L .83336 .41904 L p F P
0 g
s
.834 .596 .578 r
.6675 .58865 m .6142 .58677 L .61726 .60651 L p F P
0 g
s
.834 .596 .578 r
.61726 .60651 m .67267 .62003 L .6675 .58865 L p F P
0 g
s
0 0 .441 r
.51795 .56994 m .50216 .54638 L .51082 .56463 L p F P
0 g
s
0 0 .441 r
.51082 .56463 m .52097 .57629 L .51795 .56994 L p F P
0 g
s
.952 .716 .545 r
.20502 .55892 m .23015 .61331 L .23558 .60781 L p F P
0 g
s
.952 .716 .545 r
.23558 .60781 m .21595 .5487 L .20502 .55892 L p F P
0 g
s
.868 .708 .682 r
.59469 .52652 m .63658 .49307 L .62244 .4648 L p F P
0 g
s
.854 .678 .662 r
.63658 .49307 m .59469 .52652 L .60267 .54594 L p F P
0 g
s
0 0 .345 r
.88815 .66157 m .8797 .67972 L .88174 .72783 L p F P
0 g
s
.351 .16 .475 r
.86544 .7408 m .88174 .72783 L .8797 .67972 L p F P
0 g
s
.843 .987 .861 r
.21115 .35837 m .19722 .37563 L .22769 .36968 L p F P
0 g
s
.843 .987 .861 r
.22769 .36968 m .24246 .35265 L .21115 .35837 L p F P
0 g
s
0 0 0 r
.45065 .92413 m .43101 .93285 L .40269 .94753 L p F P
0 g
s
.575 .073 .024 r
.38128 .94161 m .40269 .94753 L .43101 .93285 L p F P
0 g
s
.034 .356 .83 r
.74892 .26816 m .72901 .25485 L .75532 .29446 L p F P
0 g
s
.034 .356 .83 r
.75532 .29446 m .77293 .30462 L .74892 .26816 L p F P
0 g
s
0 0 .254 r
.52745 .62441 m .52678 .59716 L .52548 .59022 L p F P
0 g
s
0 0 .104 r
.52678 .59716 m .52745 .62441 L .52909 .64326 L p F P
0 g
s
.874 .766 .263 r
.52396 .72892 m .52584 .67447 L .52856 .6602 L p F P
0 g
s
.96 .86 .45 r
.52584 .67447 m .52396 .72892 L .51623 .74703 L p F P
0 g
s
.936 .863 .435 r
.50949 .80059 m .51623 .74703 L .52396 .72892 L p F P
0 g
s
0 0 .411 r
.51461 .56439 m .49247 .5303 L .50216 .54638 L p F P
0 g
s
0 0 .411 r
.50216 .54638 m .51795 .56994 L .51461 .56439 L p F P
0 g
s
.824 .53 .492 r
.72594 .66921 m .67479 .64909 L .67369 .67462 L p F P
0 g
s
.824 .53 .492 r
.67369 .67462 m .72521 .70331 L .72594 .66921 L p F P
0 g
s
.798 .306 0 r
.46143 .50167 m .42118 .45402 L .43794 .4637 L p F P
0 g
s
.798 .306 0 r
.43794 .4637 m .47166 .50738 L .46143 .50167 L p F P
0 g
s
0 0 .187 r
.87387 .5474 m .87049 .53408 L .86022 .49525 L p F P
0 g
s
.722 .472 0 r
.87049 .53408 m .87387 .5474 L .88331 .59375 L p F P
0 g
s
.16 .697 .715 r
.23309 .3539 m .21115 .35837 L .24246 .35265 L p F P
0 g
s
.16 .697 .715 r
.24246 .35265 m .26358 .34833 L .23309 .3539 L p F P
0 g
s
.981 .906 .586 r
.51623 .74703 m .50949 .80059 L .49487 .81756 L p F P
0 g
s
.96 .927 .592 r
.48249 .8656 m .49487 .81756 L .50949 .80059 L p F P
0 g
s
.926 .627 .456 r
.31526 .8436 m .29457 .79033 L .27985 .78888 L p F P
0 g
s
.933 .654 .489 r
.26806 .72983 m .27985 .78888 L .29457 .79033 L p F P
0 g
s
.68 .321 0 r
.81774 .38444 m .80872 .36262 L .82807 .40549 L p F P
0 g
s
.68 .321 0 r
.82807 .40549 m .83336 .41904 L .81774 .38444 L p F P
0 g
s
.884 .779 .74 r
.64043 .322 m .61633 .36675 L .63676 .39351 L p F P
0 g
s
.898 .777 .719 r
.60721 .44028 m .63676 .39351 L .61633 .36675 L p F P
0 g
s
.876 .74 .708 r
.63676 .39351 m .60721 .44028 L .62244 .4648 L p F P
0 g
s
.938 .657 .482 r
.27985 .78888 m .26806 .72983 L .26006 .7258 L p F P
0 g
s
.961 .742 .561 r
.18521 .50751 m .20502 .55892 L .21595 .5487 L p F P
0 g
s
.961 .742 .561 r
.21595 .5487 m .20137 .49352 L .18521 .50751 L p F P
0 g
s
.833 .569 .539 r
.67267 .62003 m .61726 .60651 L .61829 .62466 L p F P
0 g
s
.833 .569 .539 r
.61829 .62466 m .67479 .64909 L .67267 .62003 L p F P
0 g
s
.955 .715 .535 r
.19675 .57452 m .22611 .62145 L .23015 .61331 L p F P
0 g
s
.955 .715 .535 r
.23015 .61331 m .20502 .55892 L .19675 .57452 L p F P
0 g
s
0 0 0 r
.40269 .94753 m .42309 .93845 L .45065 .92413 L p F P
0 g
s
.829 .998 .774 r
.46781 .90152 m .45065 .92413 L .42309 .93845 L p F P
0 g
s
.812 .334 .065 r
.40539 .45117 m .36244 .40956 L .38406 .41408 L p F P
0 g
s
.812 .334 .065 r
.38406 .41408 m .42118 .45402 L .40539 .45117 L p F P
0 g
s
.885 .74 .696 r
.58564 .50886 m .62244 .4648 L .60721 .44028 L p F P
0 g
s
.868 .708 .682 r
.62244 .4648 m .58564 .50886 L .59469 .52652 L p F P
0 g
s
0 0 .104 r
.52909 .64326 m .52735 .60368 L .52678 .59716 L p F P
0 g
s
.782 .642 .083 r
.52735 .60368 m .52909 .64326 L .52856 .6602 L p F P
0 g
s
.657 .198 0 r
.51109 .55988 m .48216 .5171 L .49247 .5303 L p F P
0 g
s
.657 .198 0 r
.49247 .5303 m .51461 .56439 L .51109 .55988 L p F P
0 g
s
.533 0 0 r
.2628 .36228 m .23309 .3539 L .26358 .34833 L p F P
0 g
s
.533 0 0 r
.26358 .34833 m .29089 .35681 L .2628 .36228 L p F P
0 g
s
.914 .586 .408 r
.33703 .88805 m .31526 .8436 L .29417 .84234 L p F P
0 g
s
.926 .627 .456 r
.27985 .78888 m .29417 .84234 L .31526 .8436 L p F P
0 g
s
.699 .37 .417 r
.84136 .74452 m .8097 .73916 L .80494 .77797 L p F P
0 g
s
.768 .436 .423 r
.8097 .73916 m .7708 .72518 L .76578 .75947 L p F P
0 g
s
.768 .436 .423 r
.76578 .75947 m .80494 .77797 L .8097 .73916 L p F P
0 g
s
.938 .657 .482 r
.26006 .7258 m .26411 .78149 L .27985 .78888 L p F P
0 g
s
.942 .661 .477 r
.26411 .78149 m .26006 .7258 L .25201 .71896 L p F P
0 g
s
.943 .959 .732 r
.48249 .8656 m .46781 .90152 L .44221 .91446 L p F P
0 g
s
.829 .998 .774 r
.42309 .93845 m .44221 .91446 L .46781 .90152 L p F P
0 g
s
.555 .245 .397 r
.86544 .7408 m .84136 .74452 L .83706 .78595 L p F P
0 g
s
.699 .37 .417 r
.80494 .77797 m .83706 .78595 L .84136 .74452 L p F P
0 g
s
.958 .712 .523 r
.19164 .59488 m .22367 .63188 L .22611 .62145 L p F P
0 g
s
.958 .712 .523 r
.22611 .62145 m .19675 .57452 L .19164 .59488 L p F P
0 g
s
.972 .777 .582 r
.17212 .46163 m .18521 .50751 L .20137 .49352 L p F P
0 g
s
.972 .777 .582 r
.20137 .49352 m .19284 .44482 L .17212 .46163 L p F P
0 g
s
0 0 .261 r
.88815 .66157 m .8891 .63685 L .88331 .59375 L p F P
0 g
s
0 0 .101 r
.8891 .63685 m .88815 .66157 L .89019 .70575 L p F P
0 g
s
0 0 .345 r
.88174 .72783 m .89019 .70575 L .88815 .66157 L p F P
0 g
s
.837 .833 .843 r
.65882 .23437 m .6374 .25971 L .66377 .28766 L p F P
0 g
s
.837 .833 .843 r
.66377 .28766 m .68633 .26468 L .65882 .23437 L p F P
0 g
s
.887 .83 .785 r
.64043 .322 m .66377 .28766 L .6374 .25971 L p F P
0 g
s
0 0 .486 r
.76765 .29318 m .74892 .26816 L .77293 .30462 L p F P
0 g
s
0 0 .486 r
.77293 .30462 m .78834 .32466 L .76765 .29318 L p F P
0 g
s
.722 .472 0 r
.88331 .59375 m .87811 .57151 L .87049 .53408 L p F P
0 g
s
.784 .55 0 r
.87811 .57151 m .88331 .59375 L .8891 .63685 L p F P
0 g
s
.722 .811 .92 r
.6807 .22261 m .65882 .23437 L .68633 .26468 L p F P
0 g
s
.722 .811 .92 r
.68633 .26468 m .7081 .25366 L .6807 .22261 L p F P
0 g
s
.782 .642 .083 r
.52856 .6602 m .52716 .60947 L .52735 .60368 L p F P
0 g
s
.898 .775 .283 r
.52716 .60947 m .52856 .6602 L .52584 .67447 L p F P
0 g
s
.806 .474 .426 r
.7708 .72518 m .72521 .70331 L .72027 .73149 L p F P
0 g
s
.806 .474 .426 r
.72027 .73149 m .76578 .75947 L .7708 .72518 L p F P
0 g
s
.73 .239 .074 r
.2997 .38294 m .2628 .36228 L .29089 .35681 L p F P
0 g
s
.73 .239 .074 r
.29089 .35681 m .32403 .37757 L .2997 .38294 L p F P
0 g
s
.752 .264 0 r
.50754 .55664 m .47166 .50738 L .48216 .5171 L p F P
0 g
s
.752 .264 0 r
.48216 .5171 m .51109 .55988 L .50754 .55664 L p F P
0 g
s
.723 .334 0 r
.80138 .35402 m .78834 .32466 L .80872 .36262 L p F P
0 g
s
.723 .334 0 r
.80872 .36262 m .81774 .38444 L .80138 .35402 L p F P
0 g
s
.835 .541 .49 r
.67479 .64909 m .61829 .62466 L .61723 .64045 L p F P
0 g
s
.835 .541 .49 r
.61723 .64045 m .67369 .67462 L .67479 .64909 L p F P
0 g
s
.234 0 .325 r
.88174 .72783 m .86544 .7408 L .86166 .78278 L p F P
0 g
s
.555 .245 .397 r
.83706 .78595 m .86166 .78278 L .86544 .7408 L p F P
0 g
s
.887 .83 .785 r
.6374 .25971 m .61647 .2978 L .64043 .322 L p F P
0 g
s
.911 .823 .747 r
.61633 .36675 m .64043 .322 L .61647 .2978 L p F P
0 g
s
.887 .513 .327 r
.35923 .92135 m .33703 .88805 L .31066 .88736 L p F P
0 g
s
.914 .586 .408 r
.29417 .84234 m .31066 .88736 L .33703 .88805 L p F P
0 g
s
.898 .777 .719 r
.61633 .36675 m .59147 .42059 L .60721 .44028 L p F P
0 g
s
.906 .775 .706 r
.57589 .49373 m .60721 .44028 L .59147 .42059 L p F P
0 g
s
.885 .74 .696 r
.60721 .44028 m .57589 .49373 L .58564 .50886 L p F P
0 g
s
.942 .661 .477 r
.25201 .71896 m .24811 .76837 L .26411 .78149 L p F P
0 g
s
.947 .666 .474 r
.24811 .76837 m .25201 .71896 L .24431 .70961 L p F P
0 g
s
.959 .708 .512 r
.19004 .61905 m .22299 .6441 L .22367 .63188 L p F P
0 g
s
.959 .708 .512 r
.22367 .63188 m .19164 .59488 L .19004 .61905 L p F P
0 g
s
.935 .63 .441 r
.29417 .84234 m .27985 .78888 L .26411 .78149 L p F P
0 g
s
.96 .86 .45 r
.51623 .74703 m .521 .68538 L .52584 .67447 L p F P
0 g
s
.989 .891 .58 r
.521 .68538 m .51623 .74703 L .50529 .75908 L p F P
0 g
s
.981 .906 .586 r
.49487 .81756 m .50529 .75908 L .51623 .74703 L p F P
0 g
s
.432 .685 .97 r
.70292 .22475 m .6807 .22261 L .7081 .25366 L p F P
0 g
s
.432 .685 .97 r
.7081 .25366 m .72901 .25485 L .70292 .22475 L p F P
0 g
s
.85 .652 .635 r
.55471 .57705 m .60927 .5663 L .60267 .54594 L p F P
0 g
s
.843 .625 .608 r
.60927 .5663 m .55471 .57705 L .55638 .58413 L p F P
0 g
s
.843 .625 .608 r
.55638 .58413 m .6142 .58677 L .60927 .5663 L p F P
0 g
s
.86 .68 .657 r
.55243 .57001 m .60267 .54594 L .59469 .52652 L p F P
0 g
s
.85 .652 .635 r
.60267 .54594 m .55243 .57001 L .55471 .57705 L p F P
0 g
s
.969 .92 .694 r
.49487 .81756 m .48249 .8656 L .45995 .87635 L p F P
0 g
s
.943 .959 .732 r
.44221 .91446 m .45995 .87635 L .48249 .8656 L p F P
0 g
s
.968 .74 .541 r
.17281 .52958 m .19675 .57452 L .20502 .55892 L p F P
0 g
s
.968 .74 .541 r
.20502 .55892 m .18521 .50751 L .17281 .52958 L p F P
0 g
s
.982 .83 .616 r
.16698 .4236 m .17212 .46163 L .19284 .44482 L p F P
0 g
s
.982 .83 .616 r
.19284 .44482 m .19125 .4049 L .16698 .4236 L p F P
0 g
s
.836 .376 .11 r
.45194 .50032 m .40539 .45117 L .42118 .45402 L p F P
0 g
s
.836 .376 .11 r
.42118 .45402 m .46143 .50167 L .45194 .50032 L p F P
0 g
s
.827 .496 .428 r
.72521 .70331 m .67369 .67462 L .66933 .69544 L p F P
0 g
s
.827 .496 .428 r
.66933 .69544 m .72027 .73149 L .72521 .70331 L p F P
0 g
s
.84 .6 .575 r
.6142 .58677 m .55638 .58413 L .55736 .59093 L p F P
0 g
s
.84 .6 .575 r
.55736 .59093 m .61726 .60651 L .6142 .58677 L p F P
0 g
s
.873 .709 .676 r
.54964 .56332 m .59469 .52652 L .58564 .50886 L p F P
0 g
s
.86 .68 .657 r
.59469 .52652 m .54964 .56332 L .55243 .57001 L p F P
0 g
s
.799 .349 .173 r
.34292 .41465 m .2997 .38294 L .32403 .37757 L p F P
0 g
s
.799 .349 .173 r
.32403 .37757 m .36244 .40956 L .34292 .41465 L p F P
0 g
s
.947 .666 .474 r
.24431 .70961 m .23268 .75003 L .24811 .76837 L p F P
0 g
s
.951 .673 .474 r
.23268 .75003 m .24431 .70961 L .23734 .69819 L p F P
0 g
s
.96 .702 .5 r
.19211 .64583 m .2241 .65752 L .22299 .6441 L p F P
0 g
s
.96 .702 .5 r
.22299 .6441 m .19004 .61905 L .19211 .64583 L p F P
0 g
s
.911 .823 .747 r
.61647 .2978 m .59599 .34738 L .61633 .36675 L p F P
0 g
s
.924 .817 .722 r
.59147 .42059 m .61633 .36675 L .59599 .34738 L p F P
0 g
s
.804 .347 .152 r
.38128 .94161 m .35923 .92135 L .32894 .92134 L p F P
0 g
s
.887 .513 .327 r
.31066 .88736 m .32894 .92134 L .35923 .92135 L p F P
0 g
s
.898 .775 .283 r
.52584 .67447 m .52622 .61426 L .52716 .60947 L p F P
0 g
s
.969 .857 .456 r
.52622 .61426 m .52584 .67447 L .521 .68538 L p F P
0 g
s
0 0 .128 r
.89019 .70575 m .88174 .72783 L .87846 .76826 L p F P
0 g
s
.234 0 .325 r
.86166 .78278 m .87846 .76826 L .88174 .72783 L p F P
0 g
s
.817 .334 0 r
.50413 .55482 m .46143 .50167 L .47166 .50738 L p F P
0 g
s
.817 .334 0 r
.47166 .50738 m .50754 .55664 L .50413 .55482 L p F P
0 g
s
.951 .673 .474 r
.23734 .69819 m .21865 .72735 L .23268 .75003 L p F P
0 g
s
.955 .68 .477 r
.21865 .72735 m .23734 .69819 L .23146 .68527 L p F P
0 g
s
.959 .695 .49 r
.19779 .67381 m .22697 .67147 L .2241 .65752 L p F P
0 g
s
.959 .695 .49 r
.2241 .65752 m .19211 .64583 L .19779 .67381 L p F P
0 g
s
.856 .53 .008 r
.84461 .46413 m .84769 .45643 L .86022 .49525 L p F P
0 g
s
.856 .53 .008 r
.86022 .49525 m .85352 .49175 L .84461 .46413 L p F P
0 g
s
.867 .558 .037 r
.85352 .49175 m .86022 .49525 L .87049 .53408 L p F P
0 g
s
.839 .574 .537 r
.61726 .60651 m .55736 .59093 L .55761 .59713 L p F P
0 g
s
.839 .574 .537 r
.55761 .59713 m .61829 .62466 L .61726 .60651 L p F P
0 g
s
.854 .511 0 r
.83442 .43757 m .83336 .41904 L .84769 .45643 L p F P
0 g
s
.854 .511 0 r
.84769 .45643 m .84461 .46413 L .83442 .43757 L p F P
0 g
s
.975 .918 .673 r
.17072 .3954 m .16698 .4236 L .19125 .4049 L p F P
0 g
s
.975 .918 .673 r
.19125 .4049 m .19722 .37563 L .17072 .3954 L p F P
0 g
s
.89 .74 .69 r
.54646 .55729 m .58564 .50886 L .57589 .49373 L p F P
0 g
s
.873 .709 .676 r
.58564 .50886 m .54646 .55729 L .54964 .56332 L p F P
0 g
s
0 .293 .775 r
.72527 .24066 m .70292 .22475 L .72901 .25485 L p F P
0 g
s
0 .293 .775 r
.72901 .25485 m .74892 .26816 L .72527 .24066 L p F P
0 g
s
.955 .68 .477 r
.23146 .68527 m .2068 .70149 L .21865 .72735 L p F P
0 g
s
.957 .687 .482 r
.2068 .70149 m .23146 .68527 L .22697 .67147 L p F P
0 g
s
.957 .687 .482 r
.22697 .67147 m .19779 .67381 L .2068 .70149 L p F P
0 g
s
.978 .895 .67 r
.50529 .75908 m .49487 .81756 L .47634 .82558 L p F P
0 g
s
.969 .92 .694 r
.45995 .87635 m .47634 .82558 L .49487 .81756 L p F P
0 g
s
.831 .402 .221 r
.39134 .45559 m .34292 .41465 L .36244 .40956 L p F P
0 g
s
.831 .402 .221 r
.36244 .40956 m .40539 .45117 L .39134 .45559 L p F P
0 g
s
.418 0 0 r
.40269 .94753 m .38128 .94161 L .34859 .94213 L p F P
0 g
s
.804 .347 .152 r
.32894 .92134 m .34859 .94213 L .38128 .94161 L p F P
0 g
s
.84 .51 .429 r
.67369 .67462 m .61723 .64045 L .61408 .65313 L p F P
0 g
s
.84 .51 .429 r
.61408 .65313 m .66933 .69544 L .67369 .67462 L p F P
0 g
s
.867 .558 .037 r
.87049 .53408 m .86081 .51935 L .85352 .49175 L p F P
0 g
s
.886 .593 .081 r
.86081 .51935 m .87049 .53408 L .87811 .57151 L p F P
0 g
s
.784 .55 0 r
.8891 .63685 m .88274 .60609 L .87811 .57151 L p F P
0 g
s
0 0 .101 r
.89019 .70575 m .8909 .67501 L .8891 .63685 L p F P
0 g
s
.852 .631 .091 r
.88274 .60609 m .8891 .63685 L .8909 .67501 L p F P
0 g
s
.86 .502 0 r
.82335 .41313 m .81774 .38444 L .83336 .41904 L p F P
0 g
s
.86 .502 0 r
.83336 .41904 m .83442 .43757 L .82335 .41313 L p F P
0 g
s
.926 .588 .378 r
.31066 .88736 m .29417 .84234 L .27136 .83234 L p F P
0 g
s
.935 .63 .441 r
.26411 .78149 m .27136 .83234 L .29417 .84234 L p F P
0 g
s
.943 .637 .429 r
.27136 .83234 m .26411 .78149 L .24811 .76837 L p F P
0 g
s
.924 .817 .722 r
.59599 .34738 m .57586 .40672 L .59147 .42059 L p F P
0 g
s
.931 .812 .706 r
.56585 .4818 m .59147 .42059 L .57586 .40672 L p F P
0 g
s
.906 .775 .706 r
.59147 .42059 m .56585 .4818 L .57589 .49373 L p F P
0 g
s
.776 .362 0 r
.7849 .32907 m .76765 .29318 L .78834 .32466 L p F P
0 g
s
.776 .362 0 r
.78834 .32466 m .80138 .35402 L .7849 .32907 L p F P
0 g
s
.973 .735 .519 r
.16499 .5589 m .19164 .59488 L .19675 .57452 L p F P
0 g
s
.973 .735 .519 r
.19675 .57452 m .17281 .52958 L .16499 .5589 L p F P
0 g
s
.842 .547 .49 r
.61829 .62466 m .55761 .59713 L .55711 .60247 L p F P
0 g
s
.842 .547 .49 r
.55711 .60247 m .61723 .64045 L .61829 .62466 L p F P
0 g
s
.744 .967 .693 r
.18391 .37851 m .17072 .3954 L .19722 .37563 L p F P
0 g
s
.744 .967 .693 r
.19722 .37563 m .21115 .35837 L .18391 .37851 L p F P
0 g
s
.982 .775 .549 r
.15604 .48893 m .17281 .52958 L .18521 .50751 L p F P
0 g
s
.982 .775 .549 r
.18521 .50751 m .17212 .46163 L .15604 .48893 L p F P
0 g
s
.91 .774 .698 r
.54304 .55218 m .57589 .49373 L .56585 .4818 L p F P
0 g
s
.89 .74 .69 r
.57589 .49373 m .54304 .55218 L .54646 .55729 L p F P
0 g
s
.969 .857 .456 r
.521 .68538 m .52456 .61784 L .52622 .61426 L p F P
0 g
s
.992 .883 .576 r
.52456 .61784 m .521 .68538 L .51422 .69236 L p F P
0 g
s
.989 .891 .58 r
.50529 .75908 m .51422 .69236 L .521 .68538 L p F P
0 g
s
.847 .396 .132 r
.50102 .55452 m .45194 .50032 L .46143 .50167 L p F P
0 g
s
.847 .396 .132 r
.46143 .50167 m .50413 .55482 L .50102 .55452 L p F P
0 g
s
.418 0 0 r
.34859 .94213 m .36921 .94823 L .40269 .94753 L p F P
0 g
s
.57 .931 .933 r
.42309 .93845 m .40269 .94753 L .36921 .94823 L p F P
0 g
s
0 0 .128 r
.87846 .76826 m .88735 .7426 L .89019 .70575 L p F P
0 g
s
.763 .649 .091 r
.8909 .67501 m .89019 .70575 L .88735 .7426 L p F P
0 g
s
.981 .88 .656 r
.51422 .69236 m .50529 .75908 L .49151 .76426 L p F P
0 g
s
.978 .895 .67 r
.47634 .82558 m .49151 .76426 L .50529 .75908 L p F P
0 g
s
.847 .431 .245 r
.44364 .5035 m .39134 .45559 L .40539 .45117 L p F P
0 g
s
.847 .431 .245 r
.40539 .45117 m .45194 .50032 L .44364 .5035 L p F P
0 g
s
.626 .155 0 r
.74743 .26973 m .72527 .24066 L .74892 .26816 L p F P
0 g
s
.626 .155 0 r
.74892 .26816 m .76765 .29318 L .74743 .26973 L p F P
0 g
s
.228 0 0 r
.20667 .37375 m .18391 .37851 L .21115 .35837 L p F P
0 g
s
.228 0 0 r
.21115 .35837 m .23309 .3539 L .20667 .37375 L p F P
0 g
s
0 0 .425 r
.51795 .56994 m .52097 .57629 L p .52548 .58274 L F P
0 g
s
0 0 .394 r
.51795 .56994 m .52602 .58261 L .52268 .57728 L F
.52602 .58261 m .5264 .58321 L .52614 .58265 L F
.538 .60143 m .52614 .58265 L p .5264 .58321 L F P
0 g
s
0 0 .394 r
.52614 .58265 m .51461 .56439 L p .52602 .58261 L F P
0 g
s
.671 .212 0 r
.51461 .56439 m .52614 .58265 L p .52599 .58194 L F P
0 g
s
0 0 .394 r
.52548 .58176 m .52604 .58262 L .52602 .58261 L F
.51795 .56994 m .52614 .58265 L p .52548 .58176 L F P
0 g
s
.671 .212 0 r
.53461 .59524 m .53049 .58922 L .54157 .60596 L F
.5285 .58581 m .53001 .58839 L .53461 .59524 L F
.53001 .58839 m .53049 .58922 L .53461 .59524 L F
0 0 .394 r
.51461 .56439 m .51795 .56994 L p .52268 .57728 L F P
0 g
s
0 0 .394 r
.52614 .58265 m .52635 .5831 L .52604 .58262 L F
.52614 .58265 m .52604 .58262 L .52548 .58176 L F
0 0 .425 r
.52614 .58265 m .51795 .56994 L p .52548 .58274 L F P
0 g
s
.671 .212 0 r
.51109 .55988 m .51461 .56439 L p .52599 .58194 L F P
0 g
s
.671 .212 0 r
.538 .60143 m .54157 .60596 L p .53049 .58922 L F P
0 g
s
.671 .212 0 r
.52636 .58253 m .52769 .5847 L .52637 .58252 L F
.52769 .5847 m .52771 .58472 L .52637 .58252 L F
.52788 .585 m .52798 .58514 L .52788 .58498 L F
.52779 .58486 m .52788 .58498 L .52637 .58252 L F
.52788 .585 m .52788 .58498 L .52779 .58486 L F
0 0 .394 r
.52789 .58555 m .52746 .58481 L .52813 .58593 L F
.671 .212 0 r
.52614 .58265 m .51109 .55988 L p .52599 .58194 L F P
0 g
s
.761 .275 0 r
.52019 .57365 m .52431 .57952 L .52614 .58265 L F
.52614 .58265 m .50754 .55664 L .51109 .55988 L p F P
0 g
s
.761 .275 0 r
.53636 .59649 m .53306 .59231 L .5451 .60915 L F
.52917 .58607 m .53186 .5904 L .53636 .59649 L F
.53186 .5904 m .53306 .59231 L .53636 .59649 L F
.822 .343 0 r
.50754 .55664 m .51776 .57019 L .52614 .58265 L F
.671 .212 0 r
.52667 .58299 m .52985 .58788 L .52614 .58265 L F
.52614 .58265 m .538 .60143 L p .52788 .585 L F P
0 g
s
.822 .343 0 r
.52614 .58265 m .50413 .55482 L .50754 .55664 L p F P
0 g
s
.822 .343 0 r
.50754 .55664 m .52614 .58265 L p .51776 .57019 L F P
0 g
s
.85 .402 .138 r
.52614 .58265 m .5225 .57731 L .51601 .56892 L F
.50413 .55482 m .52614 .58265 L p .51601 .56892 L F P
0 g
s
0 0 .425 r
.52097 .57629 m .52614 .58265 L p .52548 .58274 L F P
0 g
s
.671 .212 0 r
.52788 .585 m .538 .60143 L .52798 .58514 L F
.52614 .58265 m .52769 .5847 L .52752 .58441 L F
.52614 .58265 m .52742 .58427 L .52681 .58327 L F
.52614 .58265 m .52681 .58327 L .52599 .58194 L F
0 0 .394 r
.52604 .58262 m .5267 .58363 L .52602 .58261 L F
.5267 .58363 m .52674 .5837 L .52602 .58261 L F
.52743 .58475 m .52758 .58499 L .52734 .58464 L F
.671 .212 0 r
.52599 .58194 m .52667 .58299 L .52614 .58265 L F
.52599 .58194 m .52636 .58253 L .52637 .58252 L F
.761 .275 0 r
.52634 .58198 m .52614 .58265 L .52666 .58244 L F
.51109 .55988 m .52614 .58265 L p .52548 .58073 L F P
0 g
s
.761 .275 0 r
.52431 .57952 m .52605 .58199 L .52614 .58265 L F
.822 .343 0 r
.51776 .57019 m .52548 .58042 L .52614 .58265 L F
.761 .275 0 r
.52548 .58073 m .52614 .58265 L .52634 .58198 L F
.671 .212 0 r
.52614 .58265 m .52752 .58441 L .52742 .58427 L F
.52614 .58265 m .52788 .585 L .52769 .5847 L F
.52769 .5847 m .52788 .585 L .52771 .58472 L F
.52637 .58252 m .52788 .58498 L .5285 .58581 L F
.52788 .58498 m .53049 .58922 L .5285 .58581 L F
0 0 .394 r
.52719 .58439 m .52729 .58455 L .52716 .58435 L F
.52708 .58422 m .52716 .58435 L .5269 .58395 L F
.52685 .58387 m .5269 .58395 L .52602 .58261 L F
.52708 .58422 m .5269 .58395 L .52685 .58387 L F
.52719 .58439 m .52716 .58435 L .52708 .58422 L F
.52724 .58446 m .52734 .58464 L .52729 .58455 L F
.52724 .58446 m .52729 .58455 L .52719 .58439 L F
.52743 .58475 m .52734 .58464 L .52724 .58446 L F
.5267 .58363 m .52743 .58475 L .52674 .5837 L F
.52743 .58475 m .53459 .59576 L .52758 .58499 L F
.52668 .58365 m .52734 .58464 L .52789 .58555 L F
.52602 .58261 m .52661 .58351 L .52668 .58365 L F
.52661 .58351 m .52734 .58464 L .52668 .58365 L F
.52734 .58464 m .52746 .58481 L .52789 .58555 L F
.53459 .59576 m .538 .60143 L p .52813 .58593 L F P
0 g
s
0 0 .394 r
.52746 .58481 m .53459 .59576 L .52813 .58593 L F
.52614 .58265 m .53459 .59576 L p .52635 .5831 L F P
0 g
s
0 0 .425 r
.52746 .58558 m .52614 .58265 L .53459 .59576 L F
.761 .275 0 r
.52672 .58295 m .52811 .58493 L .52614 .58265 L F
.5451 .60915 m .52614 .58265 L p .52811 .58493 L F P
0 g
s
.761 .275 0 r
.52823 .58471 m .52614 .58265 L .52917 .58607 L F
.52666 .58244 m .52614 .58265 L .52823 .58471 L F
.671 .212 0 r
.52985 .58788 m .53228 .59164 L .52614 .58265 L F
.53228 .59164 m .53461 .59524 L .52614 .58265 L F
.54157 .60596 m .52614 .58265 L p .53461 .59524 L F P
0 g
s
.761 .275 0 r
.52614 .58265 m .54157 .60596 L p .52917 .58607 L F P
0 g
s
.822 .343 0 r
.52694 .58235 m .53018 .58664 L .52614 .58265 L F
.52588 .58175 m .5266 .58279 L .52548 .58042 L F
.5266 .58279 m .52668 .58289 L .52663 .58279 L F
.5266 .58279 m .52663 .58279 L .52548 .58042 L F
.52668 .58289 m .5269 .583 L .52548 .58042 L F
.52746 .584 m .52906 .58566 L .52756 .58346 L F
0 0 .406 r
.52614 .58265 m .52097 .57629 L .52351 .58315 L p F P
0 g
s
.857 .449 .261 r
.55145 .61098 m .55396 .60957 L p .54053 .5956 L F P
0 g
s
.822 .343 0 r
.52697 .58312 m .52756 .58346 L .5274 .58322 L F
.5269 .583 m .5274 .58322 L .52548 .58042 L F
.52697 .58312 m .5274 .58322 L .5269 .583 L F
.52746 .584 m .52756 .58346 L .52697 .58312 L F
.761 .275 0 r
.52605 .58199 m .52672 .58295 L .52614 .58265 L F
.822 .343 0 r
.52614 .58265 m .52652 .58267 L .52621 .58223 L F
.52614 .58265 m .52621 .58223 L .51776 .57019 L F
.52548 .58042 m .52694 .58235 L .52614 .58265 L F
.85 .402 .138 r
.52614 .58265 m .52653 .58251 L .5225 .57731 L F
.822 .343 0 r
.52746 .584 m .52936 .58671 L .52906 .58566 L F
.52936 .58671 m .5451 .60915 L .53245 .59062 L F
.52936 .58671 m .53245 .59062 L .52906 .58566 L F
.52614 .58265 m .52746 .584 L .52652 .58267 L F
.52668 .58289 m .52746 .584 L .5269 .583 L F
.53018 .58664 m .53798 .59697 L .52614 .58265 L F
.51776 .57019 m .52118 .57506 L .52366 .578 L F
.52118 .57506 m .52588 .58175 L .52366 .578 L F
.52366 .578 m .52588 .58175 L .52548 .58042 L F
.52548 .58042 m .52858 .58495 L .52972 .58603 L F
.5451 .60915 m .54845 .61084 L p .53798 .59697 L F P
0 g
s
.822 .343 0 r
.52972 .58603 m .53198 .58943 L .53445 .5923 L F
.52858 .58495 m .5451 .60915 L .52972 .58603 L F
.85 .402 .138 r
.52614 .58265 m .50102 .55452 L .50413 .55482 L p F P
0 g
s
.857 .449 .261 r
.52614 .58265 m .49836 .55576 L p .51437 .5684 L F P
0 g
s
.857 .449 .261 r
.50102 .55452 m .52614 .58265 L p .51437 .5684 L F P
0 g
s
.854 .488 .357 r
.49836 .55576 m .52614 .58265 L p .51786 .57302 L F P
0 g
s
.85 .402 .138 r
.52838 .58361 m .53324 .58937 L .52614 .58265 L F
.53324 .58937 m .5339 .59015 L .52614 .58265 L F
.50413 .55482 m .52548 .58017 L .52614 .58265 L F
.52548 .58017 m .52809 .58326 L .52614 .58265 L F
.52809 .58326 m .52838 .58361 L .52614 .58265 L F
.854 .488 .357 r
.49627 .5585 m .49836 .55576 L p .51293 .56866 L F P
0 g
s
.85 .402 .138 r
.52495 .57954 m .52662 .58263 L .52753 .58259 L F
.51601 .56892 m .52567 .5814 L .52495 .57954 L F
.52567 .5814 m .52662 .58263 L .52495 .57954 L F
.52753 .58259 m .5286 .58498 L .53324 .58937 L F
.52662 .58263 m .52831 .58482 L .52753 .58259 L F
.52831 .58482 m .52884 .5855 L .52871 .58522 L F
.52831 .58482 m .52871 .58522 L .52753 .58259 L F
.854 .488 .357 r
.51293 .56866 m .52345 .57979 L .49627 .5585 L F
.85 .402 .138 r
.53324 .58937 m .52884 .5855 L .53939 .59667 L F
.5286 .58498 m .52884 .5855 L .53324 .58937 L F
.52614 .58265 m .52662 .58263 L .52653 .58251 L F
.52614 .58265 m .52831 .58482 L .52662 .58263 L F
.857 .449 .261 r
.51437 .5684 m .5244 .57883 L .52614 .58265 L F
0 0 .425 r
.52717 .58515 m .52614 .58265 L .52746 .58558 L F
.52548 .58274 m .52614 .58265 L .52717 .58515 L F
.52608 .58359 m .52751 .58564 L .52614 .58265 L F
.52751 .58564 m .53459 .59576 L .52614 .58265 L F
0 0 .406 r
.52548 .58465 m .52614 .58265 L .5279 .58648 L F
0 0 .425 r
.52548 .58274 m .52608 .58359 L .52614 .58265 L F
0 0 .406 r
.52351 .58315 m .52614 .58265 L p .52548 .58465 L F P
0 g
s
.857 .449 .261 r
.52499 .57944 m .52858 .58318 L .52614 .58265 L F
.5244 .57883 m .52499 .57944 L .52614 .58265 L F
.85 .402 .138 r
.53939 .59667 m .5298 .58674 L .55145 .61098 L F
.52884 .5855 m .5298 .58674 L .53939 .59667 L F
.5339 .59015 m .53532 .59184 L .52614 .58265 L F
.822 .343 0 r
.52614 .58265 m .5451 .60915 L p .52746 .584 L F P
0 g
s
.85 .402 .138 r
.55145 .61098 m .52614 .58265 L p .53532 .59184 L F P
0 g
s
.822 .343 0 r
.53445 .5923 m .53295 .59089 L .53798 .59697 L F
.53198 .58943 m .53295 .59089 L .53445 .5923 L F
.53295 .59089 m .5451 .60915 L .53798 .59697 L F
.54845 .61084 m .52614 .58265 L p .53798 .59697 L F P
0 g
s
.85 .402 .138 r
.52614 .58265 m .54845 .61084 L p .52831 .58482 L F P
0 g
s
.857 .449 .261 r
.52614 .58265 m .55145 .61098 L p .53017 .58654 L F P
0 g
s
0 0 .406 r
.52351 .58315 m .52548 .58465 L .52614 .58265 L F
0 0 .425 r
.52614 .58265 m .5315 .58922 L .53459 .59576 L p F P
0 g
s
0 0 .406 r
.5315 .58922 m .52614 .58265 L p .52548 .58465 L F P
0 g
s
0 0 .344 r
.52351 .58315 m .52548 .59022 L p .5273 .58586 L F P
0 g
s
0 0 .344 r
.52614 .58265 m .52351 .58315 L p .52638 .58521 L F P
0 g
s
0 0 .344 r
.5273 .58586 m .52614 .58265 L .52638 .58521 L F
.857 .449 .261 r
.52614 .58265 m .52703 .58294 L .51437 .5684 L F
.854 .488 .357 r
.52614 .58265 m .49627 .5585 L p .52212 .57875 L F P
0 g
s
.854 .488 .357 r
.52594 .58174 m .52614 .58265 L .52212 .57875 L F
.857 .449 .261 r
.52614 .58265 m .52714 .58307 L .52703 .58294 L F
.52614 .58265 m .53017 .58654 L .52714 .58307 L F
.52858 .58318 m .52896 .58357 L .52614 .58265 L F
.55396 .60957 m .52614 .58265 L p .52896 .58357 L F P
0 g
s
.857 .449 .261 r
.51437 .5684 m .52611 .58188 L .53108 .58577 L F
.52611 .58188 m .52908 .58529 L .53108 .58577 L F
.53108 .58577 m .52908 .58529 L .54053 .5956 L F
0 0 .344 r
.52548 .59022 m .52614 .58265 L p .52734 .58577 L F P
0 g
s
0 0 .24 r
.52678 .59716 m .52614 .58265 L p .52681 .58457 L F P
0 g
s
0 0 .24 r
.52548 .59022 m .52678 .59716 L p .52681 .58489 L F P
0 g
s
0 0 .24 r
.52681 .58489 m .52655 .58404 L .52548 .59022 L F
0 0 .091 r
.52678 .59716 m .52735 .60368 L p .52639 .58516 L F P
0 g
s
.854 .488 .357 r
.54135 .59382 m .52614 .58265 L .52606 .58184 L F
.52606 .58184 m .52614 .58265 L .52594 .58174 L F
.51853 .57459 m .52607 .58185 L .52345 .57979 L F
.51293 .56866 m .52607 .58185 L .51853 .57459 L F
.51293 .56866 m .54135 .59382 L .52607 .58185 L F
.857 .449 .261 r
.52908 .58529 m .55145 .61098 L .54053 .5956 L F
.854 .488 .357 r
.55396 .60957 m .55587 .60668 L p .5339 .58723 L F P
0 g
s
.854 .488 .357 r
.51786 .57302 m .52908 .58438 L .5339 .58723 L F
.52908 .58438 m .55396 .60957 L .5339 .58723 L F
.848 .52 .431 r
.52614 .58265 m .49486 .56263 L p .51697 .57346 L F P
0 g
s
.848 .52 .431 r
.51175 .56968 m .52614 .58265 L .51697 .57346 L F
.844 .548 .489 r
.52614 .58265 m .49421 .56795 L p .51221 .57373 L F P
0 g
s
.848 .52 .431 r
.49627 .5585 m .52614 .58265 L p .51175 .56968 L F P
0 g
s
.844 .548 .489 r
.51905 .57593 m .52614 .58265 L .51221 .57373 L F
.854 .488 .357 r
.52614 .58265 m .55396 .60957 L p .52908 .58438 L F P
0 g
s
.854 .488 .357 r
.52614 .58265 m .52802 .58331 L .52779 .58307 L F
.52614 .58265 m .52779 .58307 L .51786 .57302 L F
.848 .52 .431 r
.51697 .57346 m .52588 .5799 L .52614 .58265 L F
.844 .548 .489 r
.49486 .56263 m .52614 .58265 L p .51905 .57593 L F P
0 g
s
.854 .488 .357 r
.52614 .58265 m .52908 .58438 L .52802 .58331 L F
.848 .52 .431 r
.55711 .60247 m .52614 .58265 L p .52588 .5799 L F P
0 g
s
.848 .52 .431 r
.51697 .57346 m .52614 .58265 L .52245 .57742 L F
.854 .488 .357 r
.55587 .60668 m .52614 .58265 L p .54135 .59382 L F P
0 g
s
.848 .52 .431 r
.55587 .60668 m .55711 .60247 L p .52245 .57742 L F P
0 g
s
.848 .52 .431 r
.52614 .58265 m .55587 .60668 L p .52594 .58047 L F P
0 g
s
.848 .52 .431 r
.52614 .58265 m .52594 .58047 L .52245 .57742 L F
.844 .548 .489 r
.52614 .58265 m .55711 .60247 L p .53363 .58609 L F P
0 g
s
.841 .575 .536 r
.52614 .58265 m .49435 .57422 L p .51639 .57719 L F P
0 g
s
.842 .601 .575 r
.49435 .57422 m .52614 .58265 L p .51027 .57676 L F P
0 g
s
.844 .548 .489 r
.52614 .58265 m .53038 .58383 L .52958 .58327 L F
.52614 .58265 m .529 .58287 L .51905 .57593 L F
.842 .601 .575 r
.52614 .58265 m .49527 .58113 L p .51478 .57963 L F P
0 g
s
.845 .626 .606 r
.52614 .58265 m .49694 .58837 L p .51512 .58211 L F P
0 g
s
.844 .548 .489 r
.51905 .57593 m .5338 .58404 L .52614 .58265 L F
.841 .575 .536 r
.51038 .57383 m .52614 .58265 L .52153 .57789 L F
.49421 .56795 m .52614 .58265 L p .51038 .57383 L F P
0 g
s
.841 .575 .536 r
.52153 .57789 m .52614 .58265 L .51639 .57719 L F
.842 .601 .575 r
.52032 .57921 m .52614 .58265 L .51478 .57963 L F
.845 .626 .606 r
.51918 .58071 m .52614 .58265 L .51512 .58211 L F
.844 .548 .489 r
.5338 .58404 m .53654 .58555 L .52614 .58265 L F
.55761 .59713 m .52614 .58265 L p .53654 .58555 L F P
0 g
s
.844 .548 .489 r
.52614 .58265 m .52958 .58327 L .529 .58287 L F
.52614 .58265 m .53157 .58466 L .53038 .58383 L F
.52614 .58265 m .53363 .58609 L .53157 .58466 L F
.51905 .57593 m .53363 .58609 L .55761 .59713 L F
.55711 .60247 m .55761 .59713 L p .53363 .58609 L F P
0 g
s
.841 .575 .536 r
.52614 .58265 m .55761 .59713 L p .52153 .57789 L F P
0 g
s
.841 .575 .536 r
.52153 .57789 m .52787 .58019 L .52614 .58265 L F
.842 .601 .575 r
.51027 .57676 m .52614 .58265 L .5228 .57876 L F
.841 .575 .536 r
.55761 .59713 m .55736 .59093 L p .52153 .57789 L F P
0 g
s
.842 .601 .575 r
.52388 .57894 m .52614 .58265 L .52032 .57921 L F
.845 .626 .606 r
.49527 .58113 m .52614 .58265 L p .52256 .57926 L F P
0 g
s
.851 .653 .633 r
.51845 .58125 m .52614 .58265 L .51968 .58085 L F
.841 .575 .536 r
.55736 .59093 m .52614 .58265 L p .52787 .58019 L F P
0 g
s
.842 .601 .575 r
.52614 .58265 m .55736 .59093 L p .5228 .57876 L F P
0 g
s
.845 .626 .606 r
.52359 .57919 m .52614 .58265 L .51918 .58071 L F
.52614 .58265 m .52378 .57944 L .52256 .57926 L F
.851 .653 .633 r
.52306 .57973 m .52614 .58265 L .52379 .57949 L F
.51968 .58085 m .52614 .58265 L .52306 .57973 L F
.49694 .58837 m .52614 .58265 L p .51845 .58125 L F P
0 g
s
.845 .626 .606 r
.49694 .58837 m .49527 .58113 L p .51568 .57973 L F P
0 g
s
.845 .626 .606 r
.51568 .57973 m .52359 .57919 L .51918 .58071 L F
.51568 .57973 m .51918 .58071 L .49694 .58837 L F
.851 .653 .633 r
.52614 .58265 m .49927 .59557 L p .52052 .58163 L F P
0 g
s
.851 .653 .633 r
.52379 .57949 m .52614 .58265 L .52052 .58163 L F
.861 .68 .656 r
.52016 .58219 m .52614 .58265 L .52396 .57976 L F
.49927 .59557 m .52614 .58265 L p .52016 .58219 L F P
0 g
s
.842 .601 .575 r
.55638 .58413 m .52614 .58265 L p .52701 .57944 L F P
0 g
s
.842 .601 .575 r
.52473 .57907 m .53589 .58313 L .55638 .58413 L F
.55736 .59093 m .55638 .58413 L p .53589 .58313 L F P
0 g
s
.842 .601 .575 r
.5249 .5795 m .55736 .59093 L .52473 .57907 L F
.52388 .57894 m .52542 .57918 L .52538 .58139 L F
.52542 .57918 m .52701 .57944 L .52538 .58139 L F
.52538 .58139 m .52701 .57944 L .52614 .58265 L F
.845 .626 .606 r
.52614 .58265 m .55638 .58413 L p .52378 .57944 L F P
0 g
s
0 0 .406 r
.52614 .58265 m .52886 .58212 L p .5279 .58648 L F P
0 g
s
0 0 .344 r
.52886 .58212 m .52614 .58265 L p .5273 .58586 L F P
0 g
s
0 0 .344 r
.52734 .58577 m .52614 .58265 L .52886 .58212 L F
0 0 .24 r
.52614 .58265 m .52548 .59022 L p .52647 .58309 L F P
0 g
s
0 0 .091 r
.52626 .58268 m .52625 .58268 L .52631 .58444 L F
0 0 .24 r
.52654 .58413 m .5264 .58361 L .52548 .59022 L F
0 0 .091 r
.52633 .58466 m .52631 .58444 L .52678 .59716 L F
.52626 .58268 m .52631 .58444 L .52633 .58466 L F
.841 .575 .536 r
.49421 .56795 m .52153 .57789 L .51342 .57679 L F
.49435 .57422 m .49421 .56795 L p .51342 .57679 L F P
0 g
s
.861 .68 .656 r
.52614 .58265 m .50216 .60238 L p .52244 .58134 L F P
0 g
s
.861 .68 .656 r
.52396 .57976 m .52614 .58265 L .52244 .58134 L F
.842 .601 .575 r
.5228 .57876 m .5249 .5795 L .52473 .57907 L F
.845 .626 .606 r
.55638 .58413 m .55471 .57705 L p .52312 .57922 L F P
0 g
s
.845 .626 .606 r
.52324 .57936 m .55638 .58413 L .52312 .57922 L F
.52654 .57899 m .55471 .57705 L .52614 .58265 L F
.851 .653 .633 r
.52379 .57949 m .52659 .57856 L .52614 .58265 L F
.55243 .57001 m .52614 .58265 L p .52659 .57856 L F P
0 g
s
.851 .653 .633 r
.55471 .57705 m .55243 .57001 L p .52379 .57949 L F P
0 g
s
.851 .653 .633 r
.52614 .58265 m .55471 .57705 L p .52379 .57949 L F P
0 g
s
.861 .68 .656 r
.54964 .56332 m .52614 .58265 L p .52396 .57976 L F P
0 g
s
.861 .68 .656 r
.52614 .58265 m .55243 .57001 L p .52396 .57976 L F P
0 g
s
.874 .709 .674 r
.52248 .5817 m .52614 .58265 L .52439 .57975 L F
.50216 .60238 m .52614 .58265 L p .52248 .5817 L F P
0 g
s
.842 .601 .575 r
.49435 .57422 m .51836 .57805 L .51201 .5789 L F
.49527 .58113 m .49435 .57422 L p .51201 .5789 L F P
0 g
s
.842 .601 .575 r
.51836 .57805 m .52388 .57894 L .52032 .57921 L F
.51836 .57805 m .52032 .57921 L .49527 .58113 L F
0 0 .091 r
.52639 .58516 m .52626 .58268 L .52633 .58453 L F
.52639 .58516 m .52633 .58453 L .52678 .59716 L F
.874 .709 .674 r
.52439 .57975 m .52614 .58265 L .52328 .58144 L F
.891 .74 .688 r
.52332 .58172 m .52614 .58265 L .52429 .58026 L F
.874 .709 .674 r
.52614 .58265 m .50546 .60847 L p .52328 .58144 L F P
0 g
s
.891 .74 .688 r
.50546 .60847 m .52614 .58265 L p .52332 .58172 L F P
0 g
s
.891 .74 .688 r
.52451 .57993 m .52614 .58265 L .52364 .58183 L F
.911 .773 .696 r
.5237 .58212 m .52614 .58265 L .52445 .58051 L F
.861 .68 .656 r
.55243 .57001 m .54964 .56332 L p .52396 .57976 L F P
0 g
s
.874 .709 .674 r
.52439 .57975 m .53542 .56853 L .52614 .58265 L F
.54646 .55729 m .52614 .58265 L p .53542 .56853 L F P
0 g
s
.874 .709 .674 r
.52439 .57975 m .5329 .57421 L .54646 .55729 L F
.54964 .56332 m .54646 .55729 L p .5329 .57421 L F P
0 g
s
.874 .709 .674 r
.52614 .58265 m .54964 .56332 L p .52439 .57975 L F P
0 g
s
.891 .74 .688 r
.54304 .55218 m .52614 .58265 L p .52451 .57993 L F P
0 g
s
.891 .74 .688 r
.52614 .58265 m .54646 .55729 L p .52429 .58026 L F P
0 g
s
.911 .773 .696 r
.52482 .57972 m .52614 .58265 L .52415 .58179 L F
.935 .808 .695 r
.52419 .58204 m .52614 .58265 L .52476 .58031 L F
.891 .74 .688 r
.52614 .58265 m .509 .61356 L p .52364 .58183 L F P
0 g
s
.911 .773 .696 r
.509 .61356 m .52614 .58265 L p .5237 .58212 L F P
0 g
s
.911 .773 .696 r
.52614 .58265 m .51262 .61739 L p .52415 .58179 L F P
0 g
s
.935 .808 .695 r
.52614 .58265 m .51615 .6198 L p .52433 .58161 L F P
0 g
s
.891 .74 .688 r
.52429 .58026 m .53176 .57252 L .54304 .55218 L F
.54646 .55729 m .54304 .55218 L p .53176 .57252 L F P
0 g
s
.911 .773 .696 r
.52482 .57972 m .52928 .57018 L .52614 .58265 L F
.53953 .54824 m .52614 .58265 L p .52928 .57018 L F P
0 g
s
.911 .773 .696 r
.54304 .55218 m .53953 .54824 L p .52445 .58051 L F P
0 g
s
.911 .773 .696 r
.52614 .58265 m .54304 .55218 L p .52445 .58051 L F P
0 g
s
.935 .808 .695 r
.51262 .61739 m .52614 .58265 L p .52419 .58204 L F P
0 g
s
.961 .842 .681 r
.52614 .58265 m .51941 .62069 L p .52457 .58193 L F P
0 g
s
.961 .842 .681 r
.51615 .6198 m .52614 .58265 L p .52457 .58193 L F P
0 g
s
.983 .87 .645 r
.52614 .58265 m .52226 .62002 L p .52493 .5827 L F P
0 g
s
.992 .88 .575 r
.52226 .62002 m .52614 .58265 L p .5241 .59546 L F P
0 g
s
.935 .808 .695 r
.52433 .58161 m .52652 .57492 L .52614 .58265 L F
.52652 .57492 m .52716 .57297 L .52614 .58265 L F
.5361 .54565 m .52614 .58265 L p .52716 .57297 L F P
0 g
s
.935 .808 .695 r
.52476 .58031 m .5296 .5698 L .5361 .54565 L F
.53953 .54824 m .5361 .54565 L p .5296 .5698 L F P
0 g
s
.935 .808 .695 r
.52614 .58265 m .53953 .54824 L p .52476 .58031 L F P
0 g
s
.992 .88 .575 r
.52614 .58265 m .52456 .61784 L p .52496 .59162 L F P
0 g
s
.983 .87 .645 r
.51941 .62069 m .52614 .58265 L p .52482 .58225 L F P
0 g
s
.961 .842 .681 r
.52457 .58193 m .52649 .57331 L .52614 .58265 L F
.52649 .57331 m .52866 .56356 L .52614 .58265 L F
.53289 .54455 m .52614 .58265 L p .52866 .56356 L F P
0 g
s
.961 .842 .681 r
.5361 .54565 m .53289 .54455 L p .52457 .58193 L F P
0 g
s
.961 .842 .681 r
.52614 .58265 m .5361 .54565 L p .52742 .57297 L F P
0 g
s
.961 .842 .681 r
.52614 .58265 m .52742 .57297 L .52457 .58193 L F
.992 .88 .575 r
.52456 .61784 m .52226 .62002 L p .52363 .60169 L F P
0 g
s
.983 .87 .645 r
.52614 .58265 m .53289 .54455 L p .52748 .56983 L F P
0 g
s
.983 .87 .645 r
.52614 .58265 m .52748 .56983 L .52482 .58225 L F
.52512 .58014 m .52614 .58265 L .52493 .5827 L F
.992 .88 .575 r
.52363 .60169 m .52511 .58211 L .52496 .59162 L F
.52363 .60169 m .52496 .59162 L .52456 .61784 L F
.52511 .58211 m .52614 .58265 L .52496 .59162 L F
.5241 .59546 m .52614 .58265 L .52504 .58304 L F
.972 .855 .457 r
.52614 .58265 m .52622 .61426 L p .52542 .58292 L F P
0 g
s
.904 .777 .289 r
.52614 .58265 m .52716 .60947 L p .52594 .58806 L F P
0 g
s
.972 .855 .457 r
.52456 .61784 m .52614 .58265 L p .52513 .59232 L F P
0 g
s
.992 .88 .575 r
.52507 .58259 m .52614 .58265 L .52519 .581 L F
.52504 .58304 m .52614 .58265 L .52507 .58259 L F
.983 .87 .645 r
.53289 .54455 m .53006 .54499 L p .52482 .58225 L F P
0 g
s
.983 .87 .645 r
.53006 .54499 m .52614 .58265 L p .52512 .58014 L F P
0 g
s
.992 .88 .575 r
.52775 .54697 m .52614 .58265 L p .52511 .58211 L F P
0 g
s
.972 .855 .457 r
.52513 .59232 m .52614 .58265 L .52536 .58192 L F
.904 .777 .289 r
.52561 .58231 m .52614 .58265 L .52594 .58806 L F
.52716 .60947 m .52622 .61426 L p .52577 .59037 L F P
0 g
s
.972 .855 .457 r
.52538 .58129 m .52614 .58265 L .52542 .58292 L F
.904 .777 .289 r
.52577 .59037 m .52561 .58231 L .52591 .58747 L F
.52577 .59037 m .52591 .58747 L .52716 .60947 L F
.992 .88 .575 r
.53006 .54499 m .52775 .54697 L p .52519 .581 L F P
0 g
s
.992 .88 .575 r
.52614 .58265 m .53006 .54499 L p .52519 .581 L F P
0 g
s
.972 .855 .457 r
.52775 .54697 m .52607 .55042 L p .52536 .58192 L F P
0 g
s
.972 .855 .457 r
.52614 .58265 m .52775 .54697 L p .52536 .58192 L F P
0 g
s
.972 .855 .457 r
.52607 .55042 m .52614 .58265 L p .52538 .58129 L F P
0 g
s
.904 .777 .289 r
.52607 .55042 m .5251 .55517 L p .5256 .58164 L F P
0 g
s
.904 .777 .289 r
.52614 .58265 m .52607 .55042 L p .5256 .58164 L F P
0 g
s
.904 .777 .289 r
.5251 .55517 m .52614 .58265 L p .52561 .58231 L F P
0 g
s
.793 .649 .094 r
.52614 .58265 m .5251 .55517 L p .52581 .57906 L F P
0 g
s
.793 .649 .094 r
.52614 .58265 m .52581 .57906 L .52592 .58277 L F
0 0 .344 r
.52614 .58265 m .52683 .57482 L .52886 .58212 L p F P
0 g
s
0 0 .24 r
.52614 .58265 m .52549 .56767 L p .52656 .58139 L F P
0 g
s
0 0 .24 r
.52614 .58265 m .52656 .58139 L .52681 .58457 L F
.85 .402 .138 r
.54845 .61084 m .55145 .61098 L p .5298 .58674 L F P
0 g
s
0 0 .406 r
.52886 .58212 m .5315 .58922 L p .5279 .58648 L F P
0 g
s
.848 .52 .431 r
.49486 .56263 m .49627 .5585 L p .51697 .57346 L F P
0 g
s
.983 .87 .645 r
.52301 .59514 m .52475 .5827 L .52445 .58937 L F
.52475 .5827 m .52512 .58014 L .52493 .5827 L F
.52475 .5827 m .52493 .5827 L .52445 .58937 L F
.844 .548 .489 r
.49421 .56795 m .49486 .56263 L p .51088 .57144 L F P
0 g
s
.844 .548 .489 r
.51088 .57144 m .51905 .57593 L .5154 .57475 L F
.51088 .57144 m .5154 .57475 L .49421 .56795 L F
.857 .449 .261 r
.49836 .55576 m .50102 .55452 L p .51437 .5684 L F P
0 g
s
0 0 .24 r
.52681 .58255 m .52654 .58259 L .5264 .58361 L F
.52681 .58255 m .5264 .58361 L .52654 .58413 L F
.904 .777 .289 r
.5257 .58674 m .52614 .58265 L .52563 .58286 L F
.52622 .61426 m .52614 .58265 L p .5257 .58674 L F P
0 g
s
0 0 .091 r
.52614 .58265 m .52678 .59716 L p .52627 .58322 L F P
0 g
s
.793 .649 .094 r
.52614 .58265 m .52735 .60368 L p .52599 .58361 L F P
0 g
s
.793 .649 .094 r
.52589 .58209 m .52614 .58265 L .52599 .58361 L F
.961 .842 .681 r
.51941 .62069 m .51615 .6198 L p .52457 .58193 L F P
0 g
s
.935 .808 .695 r
.51615 .6198 m .51262 .61739 L p .52433 .58161 L F P
0 g
s
.983 .87 .645 r
.52226 .62002 m .51941 .62069 L p .52301 .59514 L F P
0 g
s
.983 .87 .645 r
.52301 .59514 m .52445 .58937 L .52226 .62002 L F
.911 .773 .696 r
.51262 .61739 m .509 .61356 L p .52482 .57972 L F P
0 g
s
0 0 .24 r
.52549 .56767 m .52683 .57482 L p .52681 .58457 L F P
0 g
s
.793 .649 .094 r
.52735 .60368 m .52716 .60947 L p .52594 .58332 L F P
0 g
s
.793 .649 .094 r
.52594 .58332 m .52589 .58209 L .52596 .58325 L F
.52594 .58332 m .52596 .58325 L .52735 .60368 L F
.891 .74 .688 r
.509 .61356 m .50546 .60847 L p .52451 .57993 L F P
0 g
s
.874 .709 .674 r
.50546 .60847 m .50216 .60238 L p .52439 .57975 L F P
0 g
s
.972 .855 .457 r
.52622 .61426 m .52456 .61784 L p .52528 .58587 L F P
0 g
s
.972 .855 .457 r
.52528 .58587 m .52538 .58129 L .52548 .58512 L F
.52528 .58587 m .52548 .58512 L .52622 .61426 L F
.861 .68 .656 r
.50216 .60238 m .49927 .59557 L p .52396 .57976 L F P
0 g
s
.904 .777 .289 r
.52563 .58286 m .52614 .58265 L .5256 .58164 L F
.761 .275 0 r
.54157 .60596 m .5451 .60915 L p .53306 .59231 L F P
0 g
s
.845 .626 .606 r
.52256 .57926 m .52324 .57936 L .52312 .57922 L F
0 0 .24 r
.52681 .58489 m .52681 .58255 L .52655 .58404 L F
.845 .626 .606 r
.52497 .57909 m .52381 .57948 L p .52359 .57919 L F P
0 g
s
.851 .653 .633 r
.49927 .59557 m .49694 .58837 L p .52379 .57949 L F P
0 g
s
0 0 .091 r
.5263 .58336 m .52614 .58265 L .52626 .58268 L F
.52633 .58387 m .52614 .58265 L .5263 .58336 L F
.52735 .60368 m .52614 .58265 L p .52633 .58387 L F P
0 g
s
.793 .649 .094 r
.5251 .55517 m .5249 .56101 L p .52589 .58209 L F P
0 g
s
.793 .649 .094 r
.5259 .58211 m .5251 .55517 L .52589 .58209 L F
0 0 .24 r
.52682 .58061 m .52614 .58265 L .52654 .58259 L F
.52683 .57482 m .52614 .58265 L p .52682 .58061 L F P
0 g
s
0 0 .091 r
.5249 .56101 m .52549 .56767 L p .52626 .58268 L F P
0 g
s
0 0 .091 r
.52614 .58265 m .5249 .56101 L p .52626 .58268 L F P
0 g
s
.761 .275 0 r
.52291 .57701 m .51889 .57168 L p .51109 .55988 L F P
0 g
s
.793 .649 .094 r
.52592 .58277 m .5259 .58211 L .52589 .58209 L F
.52716 .60947 m .52614 .58265 L p .52592 .58277 L F P
0 g
s
0 0 .091 r
.52625 .58268 m .52614 .58265 L .52627 .58322 L F
.52621 .5817 m .52614 .58265 L .52625 .58268 L F
0 0 .24 r
.52654 .58259 m .52614 .58265 L .52647 .58309 L F
.793 .649 .094 r
.5249 .56101 m .52614 .58265 L p .52589 .58209 L F P
0 g
s
0 0 .091 r
.52626 .58268 m .52621 .5817 L .52625 .58268 L F
.52549 .56767 m .52614 .58265 L p .52621 .5817 L F P
0 g
s
0 0 .24 r
.52681 .58255 m .52682 .58061 L .52654 .58259 L F
.886 .593 .081 r
.87811 .57151 m .86617 .54582 L .86081 .51935 L p F P
0 g
s
.911 .631 .136 r
.86617 .54582 m .87811 .57151 L .88274 .60609 L p F P
0 g
s
.874 .502 .018 r
.81182 .39183 m .80138 .35402 L .81774 .38444 L p F P
0 g
s
.874 .502 .018 r
.81774 .38444 m .82335 .41313 L .81182 .39183 L p F P
0 g
s
.87 .956 .86 r
.44221 .91446 m .42309 .93845 L .39043 .93891 L p F P
0 g
s
.57 .931 .933 r
.36921 .94823 m .39043 .93891 L .42309 .93845 L p F P
0 g
s
.765 .376 .317 r
.80494 .77797 m .76578 .75947 L .75575 .78514 L p F P
0 g
s
.808 .427 .334 r
.76578 .75947 m .72027 .73149 L .71111 .75225 L p F P
0 g
s
.808 .427 .334 r
.71111 .75225 m .75575 .78514 L .76578 .75947 L p F P
0 g
s
.681 .283 .287 r
.83706 .78595 m .80494 .77797 L .79465 .80733 L p F P
0 g
s
.765 .376 .317 r
.75575 .78514 m .79465 .80733 L .80494 .77797 L p F P
0 g
s
.846 .517 .431 r
.61723 .64045 m .55711 .60247 L .55587 .60668 L p F P
0 g
s
.846 .517 .431 r
.55587 .60668 m .61408 .65313 L .61723 .64045 L p F P
0 g
s
.931 .812 .706 r
.57586 .40672 m .55595 .47366 L .56585 .4818 L p F P
0 g
s
.934 .809 .698 r
.53953 .54824 m .56585 .4818 L .55595 .47366 L p F P
0 g
s
.91 .774 .698 r
.56585 .4818 m .53953 .54824 L .54304 .55218 L p F P
0 g
s
.832 .457 .344 r
.72027 .73149 m .66933 .69544 L .66176 .71047 L p F P
0 g
s
.832 .457 .344 r
.66176 .71047 m .71111 .75225 L .72027 .73149 L p F P
0 g
s
.487 .095 .222 r
.86166 .78278 m .83706 .78595 L .82696 .81746 L p F P
0 g
s
.681 .283 .287 r
.79465 .80733 m .82696 .81746 L .83706 .78595 L p F P
0 g
s
.943 .637 .429 r
.24811 .76837 m .24795 .81373 L .27136 .83234 L p F P
0 g
s
.951 .646 .421 r
.24795 .81373 m .24811 .76837 L .23268 .75003 L p F P
0 g
s
.918 .887 .785 r
.6121 .24282 m .59353 .28366 L .61647 .2978 L p F P
0 g
s
.918 .887 .785 r
.61647 .2978 m .6374 .25971 L .6121 .24282 L p F P
0 g
s
.941 .87 .739 r
.59599 .34738 m .61647 .2978 L .59353 .28366 L p F P
0 g
s
.899 .505 .263 r
.32894 .92134 m .31066 .88736 L .28186 .87546 L p F P
0 g
s
.926 .588 .378 r
.27136 .83234 m .28186 .87546 L .31066 .88736 L p F P
0 g
s
.865 .905 .858 r
.63244 .21567 m .6121 .24282 L .6374 .25971 L p F P
0 g
s
.865 .905 .858 r
.6374 .25971 m .65882 .23437 L .63244 .21567 L p F P
0 g
s
.643 .187 .154 r
.23863 .38122 m .20667 .37375 L .23309 .3539 L p F P
0 g
s
.643 .187 .154 r
.23309 .3539 m .2628 .36228 L .23863 .38122 L p F P
0 g
s
.975 .726 .495 r
.16236 .59416 m .19004 .61905 L .19164 .59488 L p F P
0 g
s
.975 .726 .495 r
.19164 .59488 m .16499 .5589 L .16236 .59416 L p F P
0 g
s
.941 .87 .739 r
.59353 .28366 m .57659 .33659 L .59599 .34738 L p F P
0 g
s
.952 .857 .71 r
.57586 .40672 m .59599 .34738 L .57659 .33659 L p F P
0 g
s
.928 .91 .782 r
.45995 .87635 m .44221 .91446 L .4119 .91428 L p F P
0 g
s
.87 .956 .86 r
.39043 .93891 m .4119 .91428 L .44221 .91446 L p F P
0 g
s
.996 .83 .56 r
.148 .45478 m .15604 .48893 L .17212 .46163 L p F P
0 g
s
.996 .83 .56 r
.17212 .46163 m .16698 .4236 L .148 .45478 L p F P
0 g
s
.992 .883 .576 r
.51422 .69236 m .52226 .62002 L .52456 .61784 L p F P
0 g
s
.983 .872 .647 r
.52226 .62002 m .51422 .69236 L .50575 .69498 L p F P
0 g
s
.981 .88 .656 r
.49151 .76426 m .50575 .69498 L .51422 .69236 L p F P
0 g
s
.721 .893 .958 r
.6545 .20328 m .63244 .21567 L .65882 .23437 L p F P
0 g
s
.721 .893 .958 r
.65882 .23437 m .6807 .22261 L .6545 .20328 L p F P
0 g
s
.845 .475 .351 r
.66933 .69544 m .61408 .65313 L .60892 .66206 L p F P
0 g
s
.845 .475 .351 r
.60892 .66206 m .66176 .71047 L .66933 .69544 L p F P
0 g
s
.855 .445 .257 r
.49836 .55576 m .44364 .5035 L .45194 .50032 L p F P
0 g
s
.855 .445 .257 r
.45194 .50032 m .50102 .55452 L .49836 .55576 L p F P
0 g
s
.016 0 .06 r
.87846 .76826 m .86166 .78278 L .85207 .81471 L p F P
0 g
s
.487 .095 .222 r
.82696 .81746 m .85207 .81471 L .86166 .78278 L p F P
0 g
s
.952 .857 .71 r
.57659 .33659 m .56107 .39948 L .57586 .40672 L p F P
0 g
s
.957 .849 .693 r
.55595 .47366 m .57586 .40672 L .56107 .39948 L p F P
0 g
s
.76 .346 .265 r
.279 .40029 m .23863 .38122 L .2628 .36228 L p F P
0 g
s
.76 .346 .265 r
.2628 .36228 m .2997 .38294 L .279 .40029 L p F P
0 g
s
.946 .879 .736 r
.47634 .82558 m .45995 .87635 L .43334 .87531 L p F P
0 g
s
.928 .91 .782 r
.4119 .91428 m .43334 .87531 L .45995 .87635 L p F P
0 g
s
.937 .595 .352 r
.28186 .87546 m .27136 .83234 L .24795 .81373 L p F P
0 g
s
.293 .696 .974 r
.67812 .20607 m .6545 .20328 L .6807 .22261 L p F P
0 g
s
.293 .696 .974 r
.6807 .22261 m .70292 .22475 L .67812 .20607 L p F P
0 g
s
.852 .631 .091 r
.8909 .67501 m .8841 .63641 L .88274 .60609 L p F P
0 g
s
.915 .703 .206 r
.8841 .63641 m .8909 .67501 L .88844 .7065 L p F P
0 g
s
.763 .649 .091 r
.88735 .7426 m .88844 .7065 L .8909 .67501 L p F P
0 g
s
.852 .485 .355 r
.61408 .65313 m .55587 .60668 L .55396 .60957 L p F P
0 g
s
.852 .485 .355 r
.55396 .60957 m .60892 .66206 L .61408 .65313 L p F P
0 g
s
.808 .417 .313 r
.32657 .42963 m .279 .40029 L .2997 .38294 L p F P
0 g
s
.808 .417 .313 r
.2997 .38294 m .34292 .41465 L .32657 .42963 L p F P
0 g
s
.989 .767 .509 r
.14574 .52584 m .16499 .5589 L .17281 .52958 L p F P
0 g
s
.989 .767 .509 r
.17281 .52958 m .15604 .48893 L .14574 .52584 L p F P
0 g
s
.954 .86 .709 r
.49151 .76426 m .47634 .82558 L .45456 .82376 L p F P
0 g
s
.946 .879 .736 r
.43334 .87531 m .45456 .82376 L .47634 .82558 L p F P
0 g
s
.911 .631 .136 r
.88274 .60609 m .86936 .5701 L .86617 .54582 L p F P
0 g
s
.937 .669 .197 r
.86936 .5701 m .88274 .60609 L .8841 .63641 L p F P
0 g
s
.951 .646 .421 r
.23268 .75003 m .22521 .7872 L .24795 .81373 L p F P
0 g
s
.958 .657 .419 r
.22521 .7872 m .23268 .75003 L .21865 .72735 L p F P
0 g
s
.957 .849 .693 r
.56107 .39948 m .54663 .46977 L .55595 .47366 L p F P
0 g
s
.96 .843 .684 r
.5361 .54565 m .55595 .47366 L .54663 .46977 L p F P
0 g
s
.934 .809 .698 r
.55595 .47366 m .5361 .54565 L .53953 .54824 L p F P
0 g
s
.975 .714 .472 r
.16522 .63355 m .19211 .64583 L .19004 .61905 L p F P
0 g
s
.975 .714 .472 r
.19004 .61905 m .16236 .59416 L .16522 .63355 L p F P
0 g
s
.828 .401 0 r
.76895 .31083 m .74743 .26973 L .76765 .29318 L p F P
0 g
s
.828 .401 0 r
.76765 .29318 m .7849 .32907 L .76895 .31083 L p F P
0 g
s
.891 .51 .053 r
.8003 .37461 m .7849 .32907 L .80138 .35402 L p F P
0 g
s
.891 .51 .053 r
.80138 .35402 m .81182 .39183 L .8003 .37461 L p F P
0 g
s
.783 .282 0 r
.34859 .94213 m .32894 .92134 L .29557 .90814 L p F P
0 g
s
.899 .505 .263 r
.28186 .87546 m .29557 .90814 L .32894 .92134 L p F P
0 g
s
.832 .454 .337 r
.3798 .46737 m .32657 .42963 L .34292 .41465 L p F P
0 g
s
.832 .454 .337 r
.34292 .41465 m .39134 .45559 L .3798 .46737 L p F P
0 g
s
0 0 0 r
.88735 .7426 m .87846 .76826 L .8696 .79882 L p F P
0 g
s
.016 0 .06 r
.85207 .81471 m .8696 .79882 L .87846 .76826 L p F P
0 g
s
.958 .849 .692 r
.50575 .69498 m .49151 .76426 L .47545 .76204 L p F P
0 g
s
.954 .86 .709 r
.45456 .82376 m .47545 .76204 L .49151 .76426 L p F P
0 g
s
.983 .872 .647 r
.50575 .69498 m .51941 .62069 L .52226 .62002 L p F P
0 g
s
.845 .474 .349 r
.43698 .51118 m .3798 .46737 L .39134 .45559 L p F P
0 g
s
.845 .474 .349 r
.39134 .45559 m .44364 .5035 L .43698 .51118 L p F P
0 g
s
.967 .908 .553 r
.14992 .42904 m .148 .45478 L .16698 .4236 L p F P
0 g
s
.967 .908 .553 r
.16698 .4236 m .17072 .3954 L .14992 .42904 L p F P
0 g
s
.96 .844 .683 r
.51941 .62069 m .50575 .69498 L .49596 .69301 L p F P
0 g
s
.958 .849 .692 r
.47545 .76204 m .49596 .69301 L .50575 .69498 L p F P
0 g
s
0 .151 .598 r
.70297 .22385 m .67812 .20607 L .70292 .22475 L p F P
0 g
s
0 .151 .598 r
.70292 .22475 m .72527 .24066 L .70297 .22385 L p F P
0 g
s
.96 .843 .684 r
.54663 .46977 m .53289 .54455 L .5361 .54565 L p F P
0 g
s
.852 .485 .355 r
.49627 .5585 m .43698 .51118 L .44364 .5035 L p F P
0 g
s
.852 .485 .355 r
.44364 .5035 m .49836 .55576 L .49627 .5585 L p F P
0 g
s
.936 .611 .165 r
.83657 .47455 m .84461 .46413 L .85352 .49175 L p F P
0 g
s
.936 .611 .165 r
.85352 .49175 m .84126 .48909 L .83657 .47455 L p F P
0 g
s
.941 .625 .179 r
.84126 .48909 m .85352 .49175 L .86081 .51935 L p F P
0 g
s
.934 .601 .158 r
.8312 .4606 m .83442 .43757 L .84461 .46413 L p F P
0 g
s
.934 .601 .158 r
.84461 .46413 m .83657 .47455 L .8312 .4606 L p F P
0 g
s
.958 .657 .419 r
.21865 .72735 m .20444 .75398 L .22521 .7872 L p F P
0 g
s
.965 .671 .424 r
.20444 .75398 m .21865 .72735 L .2068 .70149 L p F P
0 g
s
.974 .7 .451 r
.17353 .6749 m .19779 .67381 L .19211 .64583 L p F P
0 g
s
.974 .7 .451 r
.19211 .64583 m .16522 .63355 L .17353 .6749 L p F P
0 g
s
.96 .844 .683 r
.49596 .69301 m .51615 .6198 L .51941 .62069 L p F P
0 g
s
.855 .445 .258 r
.60892 .66206 m .55396 .60957 L .55145 .61098 L p F P
0 g
s
.983 .872 .648 r
.53834 .47041 m .53006 .54499 L .53289 .54455 L p F P
0 g
s
.983 .872 .648 r
.53289 .54455 m .54663 .46977 L .53834 .47041 L p F P
0 g
s
.941 .625 .179 r
.86081 .51935 m .84508 .50359 L .84126 .48909 L p F P
0 g
s
.948 .641 .201 r
.84508 .50359 m .86081 .51935 L .86617 .54582 L p F P
0 g
s
.934 .594 .158 r
.82538 .44785 m .82335 .41313 L .83442 .43757 L p F P
0 g
s
.934 .594 .158 r
.83442 .43757 m .8312 .4606 L .82538 .44785 L p F P
0 g
s
.965 .671 .424 r
.2068 .70149 m .18686 .71583 L .20444 .75398 L p F P
0 g
s
.97 .685 .434 r
.18686 .71583 m .2068 .70149 L .19779 .67381 L p F P
0 g
s
.97 .685 .434 r
.19779 .67381 m .17353 .6749 L .18686 .71583 L p F P
0 g
s
.847 .432 .248 r
.66176 .71047 m .60892 .66206 L .60194 .66674 L p F P
0 g
s
.855 .445 .258 r
.55145 .61098 m .60194 .66674 L .60892 .66206 L p F P
0 g
s
.934 .809 .697 r
.51615 .6198 m .49596 .69301 L .48529 .68641 L p F P
0 g
s
.934 .809 .697 r
.48529 .68641 m .51262 .61739 L .51615 .6198 L p F P
0 g
s
.783 .282 0 r
.29557 .90814 m .31235 .92811 L .34859 .94213 L p F P
0 g
s
0 .447 .762 r
.36921 .94823 m .34859 .94213 L .31235 .92811 L p F P
0 g
s
.846 .517 .43 r
.43698 .51118 m .49627 .5585 L .49486 .56263 L p F P
0 g
s
.981 .879 .657 r
.54779 .39949 m .53834 .47041 L .54663 .46977 L p F P
0 g
s
.981 .879 .657 r
.54663 .46977 m .56107 .39948 L .54779 .39949 L p F P
0 g
s
0 0 0 r
.8696 .79882 m .87941 .77015 L .88735 .7426 L p F P
0 g
s
.893 .776 .283 r
.88844 .7065 m .88735 .7426 L .87941 .77015 L p F P
0 g
s
.832 .408 .232 r
.71111 .75225 m .66176 .71047 L .65119 .7188 L p F P
0 g
s
.847 .432 .248 r
.60194 .66674 m .65119 .7188 L .66176 .71047 L p F P
0 g
s
.847 .396 .132 r
.60194 .66674 m .55145 .61098 L .54845 .61084 L p F P
0 g
s
.992 .883 .576 r
.5315 .47567 m .52775 .54697 L .53006 .54499 L p F P
0 g
s
.992 .883 .576 r
.53006 .54499 m .53834 .47041 L .5315 .47567 L p F P
0 g
s
.976 .892 .674 r
.55907 .33535 m .54779 .39949 L .56107 .39948 L p F P
0 g
s
.976 .892 .674 r
.56107 .39948 m .57659 .33659 L .55907 .33535 L p F P
0 g
s
0 0 0 r
.16255 .41317 m .14992 .42904 L .17072 .3954 L p F P
0 g
s
0 0 0 r
.17072 .3954 m .18391 .37851 L .16255 .41317 L p F P
0 g
s
.804 .366 .205 r
.75575 .78514 m .71111 .75225 L .6979 .76425 L p F P
0 g
s
.832 .408 .232 r
.65119 .7188 m .6979 .76425 L .71111 .75225 L p F P
0 g
s
.745 .255 0 r
.72856 .25577 m .70297 .22385 L .72527 .24066 L p F P
0 g
s
.745 .255 0 r
.72527 .24066 m .74743 .26973 L .72856 .25577 L p F P
0 g
s
.91 .774 .698 r
.51262 .61739 m .48529 .68641 L .47425 .6754 L p F P
0 g
s
.91 .774 .698 r
.47425 .6754 m .509 .61356 L .51262 .61739 L p F P
0 g
s
.842 .547 .489 r
.43231 .5231 m .49486 .56263 L .49421 .56795 L p F P
0 g
s
.846 .517 .43 r
.49486 .56263 m .43231 .5231 L .43698 .51118 L p F P
0 g
s
.937 .595 .352 r
.24795 .81373 m .25205 .85234 L .28186 .87546 L p F P
0 g
s
.948 .606 .333 r
.25205 .85234 m .24795 .81373 L .22521 .7872 L p F P
0 g
s
.907 .501 .199 r
.29557 .90814 m .28186 .87546 L .25205 .85234 L p F P
0 g
s
.948 .641 .201 r
.86617 .54582 m .84785 .51744 L .84508 .50359 L p F P
0 g
s
.956 .657 .227 r
.84785 .51744 m .86617 .54582 L .86936 .5701 L p F P
0 g
s
.931 .813 .706 r
.49596 .69301 m .47545 .76204 L .4578 .7522 L p F P
0 g
s
.931 .813 .706 r
.4578 .7522 m .48529 .68641 L .49596 .69301 L p F P
0 g
s
.937 .591 .167 r
.81937 .43684 m .81182 .39183 L .82335 .41313 L p F P
0 g
s
.937 .591 .167 r
.82335 .41313 m .82538 .44785 L .81937 .43684 L p F P
0 g
s
.991 .75 .464 r
.1421 .57071 m .16236 .59416 L .16499 .5589 L p F P
0 g
s
.991 .75 .464 r
.16499 .5589 m .14574 .52584 L .1421 .57071 L p F P
0 g
s
.967 .912 .704 r
.5727 .28089 m .55907 .33535 L .57659 .33659 L p F P
0 g
s
.967 .912 .704 r
.57659 .33659 m .59353 .28366 L .5727 .28089 L p F P
0 g
s
.937 .669 .197 r
.8841 .63641 m .8702 .59114 L .86936 .5701 L p F P
0 g
s
.96 .702 .26 r
.8702 .59114 m .8841 .63641 L .88202 .66108 L p F P
0 g
s
.915 .703 .206 r
.88844 .7065 m .88202 .66108 L .8841 .63641 L p F P
0 g
s
.847 .396 .132 r
.54845 .61084 m .59343 .66684 L .60194 .66674 L p F P
0 g
s
.817 .335 0 r
.59343 .66684 m .54845 .61084 L .5451 .60915 L p F P
0 g
s
.969 .857 .456 r
.52647 .48543 m .52607 .55042 L .52775 .54697 L p F P
0 g
s
.969 .857 .456 r
.52775 .54697 m .5315 .47567 L .52647 .48543 L p F P
0 g
s
.751 .292 .161 r
.79465 .80733 m .75575 .78514 L .74082 .80047 L p F P
0 g
s
.804 .366 .205 r
.6979 .76425 m .74082 .80047 L .75575 .78514 L p F P
0 g
s
.84 .51 .428 r
.3798 .46737 m .43698 .51118 L .43231 .5231 L p F P
0 g
s
.89 .74 .69 r
.509 .61356 m .47425 .6754 L .4634 .66046 L p F P
0 g
s
.89 .74 .69 r
.4634 .66046 m .50546 .60847 L .509 .61356 L p F P
0 g
s
1 .812 .482 r
.13573 .49753 m .14574 .52584 L .15604 .48893 L p F P
0 g
s
1 .812 .482 r
.15604 .48893 m .148 .45478 L .13573 .49753 L p F P
0 g
s
.839 .574 .537 r
.42992 .53877 m .49421 .56795 L .49435 .57422 L p F P
0 g
s
.842 .547 .489 r
.49421 .56795 m .42992 .53877 L .43231 .5231 L p F P
0 g
s
.679 .885 .974 r
.39043 .93891 m .36921 .94823 L .33194 .93377 L p F P
0 g
s
0 .447 .762 r
.31235 .92811 m .33194 .93377 L .36921 .94823 L p F P
0 g
s
.908 .524 .098 r
.78929 .36231 m .76895 .31083 L .7849 .32907 L p F P
0 g
s
.908 .524 .098 r
.7849 .32907 m .8003 .37461 L .78929 .36231 L p F P
0 g
s
.944 .941 .754 r
.58909 .23858 m .5727 .28089 L .59353 .28366 L p F P
0 g
s
.944 .941 .754 r
.59353 .28366 m .6121 .24282 L .58909 .23858 L p F P
0 g
s
.873 .709 .676 r
.50546 .60847 m .4634 .66046 L .45329 .6423 L p F P
0 g
s
.873 .709 .676 r
.45329 .6423 m .50216 .60238 L .50546 .60847 L p F P
0 g
s
.84 .6 .575 r
.42997 .55747 m .49435 .57422 L .49527 .58113 L p F P
0 g
s
.839 .574 .537 r
.49435 .57422 m .42997 .55747 L .42992 .53877 L p F P
0 g
s
.817 .335 0 r
.5451 .60915 m .58375 .66222 L .59343 .66684 L p F P
0 g
s
.752 .264 0 r
.58375 .66222 m .5451 .60915 L .54157 .60596 L p F P
0 g
s
.898 .775 .284 r
.52355 .49932 m .5251 .55517 L .52607 .55042 L p F P
0 g
s
.898 .775 .284 r
.52607 .55042 m .52647 .48543 L .52355 .49932 L p F P
0 g
s
.636 .149 .079 r
.82696 .81746 m .79465 .80733 L .77884 .82523 L p F P
0 g
s
.751 .292 .161 r
.74082 .80047 m .77884 .82523 L .79465 .80733 L p F P
0 g
s
.926 .819 .721 r
.47545 .76204 m .45456 .82376 L .43048 .81164 L p F P
0 g
s
.926 .819 .721 r
.43048 .81164 m .4578 .7522 L .47545 .76204 L p F P
0 g
s
.436 .047 .201 r
.18606 .40801 m .16255 .41317 L .18391 .37851 L p F P
0 g
s
.436 .047 .201 r
.18391 .37851 m .20667 .37375 L .18606 .40801 L p F P
0 g
s
.86 .68 .657 r
.50216 .60238 m .45329 .6423 L .44448 .62182 L p F P
0 g
s
.86 .68 .657 r
.44448 .62182 m .49927 .59557 L .50216 .60238 L p F P
0 g
s
.843 .625 .608 r
.43251 .57826 m .49527 .58113 L .49694 .58837 L p F P
0 g
s
.84 .6 .575 r
.49527 .58113 m .43251 .57826 L .42997 .55747 L p F P
0 g
s
.837 .378 .115 r
.65119 .7188 m .60194 .66674 L .59343 .66684 L p F P
0 g
s
.84 .51 .428 r
.43231 .5231 m .37145 .48622 L .3798 .46737 L p F P
0 g
s
.828 .494 .423 r
.32657 .42963 m .3798 .46737 L .37145 .48622 L p F P
0 g
s
.85 .652 .635 r
.49927 .59557 m .44448 .62182 L .43743 .6001 L p F P
0 g
s
.85 .652 .635 r
.43743 .6001 m .49694 .58837 L .49927 .59557 L p F P
0 g
s
.843 .625 .608 r
.49694 .58837 m .43743 .6001 L .43251 .57826 L p F P
0 g
s
.851 .876 .858 r
.4119 .91428 m .39043 .93891 L .35401 .92433 L p F P
0 g
s
.679 .885 .974 r
.33194 .93377 m .35401 .92433 L .39043 .93891 L p F P
0 g
s
.989 .891 .582 r
.53674 .40705 m .5315 .47567 L .53834 .47041 L p F P
0 g
s
.989 .891 .582 r
.53834 .47041 m .54779 .39949 L .53674 .40705 L p F P
0 g
s
.962 .758 .313 r
.88202 .66108 m .88844 .7065 L .88157 .72963 L p F P
0 g
s
.893 .776 .283 r
.87941 .77015 m .88157 .72963 L .88844 .7065 L p F P
0 g
s
.752 .264 0 r
.54157 .60596 m .57335 .653 L .58375 .66222 L p F P
0 g
s
.658 .199 0 r
.57335 .653 m .54157 .60596 L .538 .60143 L p F P
0 g
s
.88 .976 .837 r
.60845 .21036 m .58909 .23858 L .6121 .24282 L p F P
0 g
s
.88 .976 .837 r
.6121 .24282 m .63244 .21567 L .60845 .21036 L p F P
0 g
s
.782 .642 .084 r
.52294 .51672 m .5249 .56101 L .5251 .55517 L p F P
0 g
s
.782 .642 .084 r
.5251 .55517 m .52355 .49932 L .52294 .51672 L p F P
0 g
s
.917 .831 .746 r
.45456 .82376 m .43334 .87531 L .40376 .86174 L p F P
0 g
s
.917 .831 .746 r
.40376 .86174 m .43048 .81164 L .45456 .82376 L p F P
0 g
s
.956 .657 .227 r
.86936 .5701 m .84945 .53003 L .84785 .51744 L p F P
0 g
s
.965 .674 .257 r
.84945 .53003 m .86936 .5701 L .8702 .59114 L p F P
0 g
s
.337 0 0 r
.85207 .81471 m .82696 .81746 L .81101 .83686 L p F P
0 g
s
.636 .149 .079 r
.77884 .82523 m .81101 .83686 L .82696 .81746 L p F P
0 g
s
.898 .849 .787 r
.43334 .87531 m .4119 .91428 L .37811 .89995 L p F P
0 g
s
.851 .876 .858 r
.35401 .92433 m .37811 .89995 L .4119 .91428 L p F P
0 g
s
.871 .443 .026 r
.75426 .30038 m .72856 .25577 L .74743 .26973 L p F P
0 g
s
.871 .443 .026 r
.74743 .26973 m .76895 .31083 L .75426 .30038 L p F P
0 g
s
.898 .849 .787 r
.37811 .89995 m .40376 .86174 L .43334 .87531 L p F P
0 g
s
.941 .592 .182 r
.81341 .4281 m .8003 .37461 L .81182 .39183 L p F P
0 g
s
.941 .592 .182 r
.81182 .39183 m .81937 .43684 L .81341 .4281 L p F P
0 g
s
.685 .317 .344 r
.21999 .41366 m .18606 .40801 L .20667 .37375 L p F P
0 g
s
.685 .317 .344 r
.20667 .37375 m .23863 .38122 L .21999 .41366 L p F P
0 g
s
.828 .494 .423 r
.37145 .48622 m .31441 .45431 L .32657 .42963 L p F P
0 g
s
.807 .467 .413 r
.279 .40029 m .32657 .42963 L .31441 .45431 L p F P
0 g
s
.658 .199 0 r
.538 .60143 m .56273 .63953 L .57335 .653 L p F P
0 g
s
0 0 .41 r
.56273 .63953 m .538 .60143 L .53459 .59576 L p F P
0 g
s
0 0 .104 r
.52471 .53681 m .52549 .56767 L .5249 .56101 L p F P
0 g
s
0 0 .104 r
.5249 .56101 m .52294 .51672 L .52471 .53681 L p F P
0 g
s
.907 .776 .705 r
.48529 .68641 m .4578 .7522 L .43942 .73496 L p F P
0 g
s
.907 .776 .705 r
.43942 .73496 m .47425 .6754 L .48529 .68641 L p F P
0 g
s
.836 .54 .489 r
.37145 .48622 m .43231 .5231 L .42992 .53877 L p F P
0 g
s
.769 .418 .392 r
.26329 .42952 m .21999 .41366 L .23863 .38122 L p F P
0 g
s
.769 .418 .392 r
.23863 .38122 m .279 .40029 L .26329 .42952 L p F P
0 g
s
.807 .467 .413 r
.31441 .45431 m .26329 .42952 L .279 .40029 L p F P
0 g
s
.659 .959 .939 r
.63076 .19752 m .60845 .21036 L .63244 .21567 L p F P
0 g
s
.659 .959 .939 r
.63244 .21567 m .6545 .20328 L .63076 .19752 L p F P
0 g
s
0 0 .41 r
.53459 .59576 m .55246 .62243 L .56273 .63953 L p F P
0 g
s
0 0 .44 r
.55246 .62243 m .53459 .59576 L .5315 .58922 L p F P
0 g
s
0 0 .253 r
.5288 .55857 m .52683 .57482 L .52549 .56767 L p F P
0 g
s
0 0 .253 r
.52549 .56767 m .52471 .53681 L .5288 .55857 L p F P
0 g
s
.948 .606 .333 r
.22521 .7872 m .22289 .81877 L .25205 .85234 L p F P
0 g
s
.958 .623 .324 r
.22289 .81877 m .22521 .7872 L .20444 .75398 L p F P
0 g
s
.989 .727 .419 r
.1456 .62122 m .16522 .63355 L .16236 .59416 L p F P
0 g
s
.989 .727 .419 r
.16236 .59416 m .1421 .57071 L .1456 .62122 L p F P
0 g
s
0 0 .44 r
.5315 .58922 m .54305 .60254 L .55246 .62243 L p F P
0 g
s
0 0 .421 r
.54305 .60254 m .5315 .58922 L .52886 .58212 L p F P
0 g
s
0 0 .358 r
.53502 .58087 m .52886 .58212 L .52683 .57482 L p F P
0 g
s
0 0 .358 r
.52683 .57482 m .5288 .55857 L .53502 .58087 L p F P
0 g
s
0 0 .421 r
.52886 .58212 m .53502 .58087 L .54305 .60254 L p F P
0 g
s
0 0 0 r
.8696 .79882 m .85207 .81471 L .8366 .83435 L p F P
0 g
s
.337 0 0 r
.81101 .83686 m .8366 .83435 L .85207 .81471 L p F P
0 g
s
.721 .206 0 r
.31235 .92811 m .29557 .90814 L .26078 .8816 L p F P
0 g
s
.907 .501 .199 r
.25205 .85234 m .26078 .8816 L .29557 .90814 L p F P
0 g
s
.817 .343 .082 r
.6979 .76425 m .65119 .7188 L .638 .71972 L p F P
0 g
s
.837 .378 .115 r
.59343 .66684 m .638 .71972 L .65119 .7188 L p F P
0 g
s
.983 .906 .595 r
.54436 .34429 m .53674 .40705 L .54779 .39949 L p F P
0 g
s
.983 .906 .595 r
.54779 .39949 m .55907 .33535 L .54436 .34429 L p F P
0 g
s
.9 .825 .357 r
.13643 .47565 m .13573 .49753 L .148 .45478 L p F P
0 g
s
.9 .825 .357 r
.148 .45478 m .14992 .42904 L .13643 .47565 L p F P
0 g
s
0 .563 .783 r
.6558 .20057 m .63076 .19752 L .6545 .20328 L p F P
0 g
s
0 .563 .783 r
.6545 .20328 m .67812 .20607 L .6558 .20057 L p F P
0 g
s
.8 .309 0 r
.638 .71972 m .59343 .66684 L .58375 .66222 L p F P
0 g
s
.961 .861 .454 r
.52854 .42215 m .52647 .48543 L .5315 .47567 L p F P
0 g
s
.961 .861 .454 r
.5315 .47567 m .53674 .40705 L .52854 .42215 L p F P
0 g
s
.886 .741 .696 r
.47425 .6754 m .43942 .73496 L .42128 .71099 L p F P
0 g
s
.886 .741 .696 r
.42128 .71099 m .4634 .66046 L .47425 .6754 L p F P
0 g
s
.96 .702 .26 r
.88202 .66108 m .86859 .60796 L .8702 .59114 L p F P
0 g
s
.978 .728 .319 r
.86859 .60796 m .88202 .66108 L .87643 .67878 L p F P
0 g
s
.962 .758 .313 r
.88157 .72963 m .87643 .67878 L .88202 .66108 L p F P
0 g
s
0 0 0 r
.8366 .83435 m .85512 .8174 L .8696 .79882 L p F P
0 g
s
.855 .895 .474 r
.87941 .77015 m .8696 .79882 L .85512 .8174 L p F P
0 g
s
.834 .569 .538 r
.36685 .51144 m .42992 .53877 L .42997 .55747 L p F P
0 g
s
.836 .54 .489 r
.42992 .53877 m .36685 .51144 L .37145 .48622 L p F P
0 g
s
.965 .674 .257 r
.8702 .59114 m .84979 .54079 L .84945 .53003 L p F P
0 g
s
.973 .689 .288 r
.84979 .54079 m .8702 .59114 L .86859 .60796 L p F P
0 g
s
.91 .505 .144 r
.26078 .8816 m .25205 .85234 L .22289 .81877 L p F P
0 g
s
.9 .779 .719 r
.4578 .7522 m .43048 .81164 L .40528 .78931 L p F P
0 g
s
.9 .779 .719 r
.40528 .78931 m .43942 .73496 L .4578 .7522 L p F P
0 g
s
.946 .595 .203 r
.80779 .42203 m .78929 .36231 L .8003 .37461 L p F P
0 g
s
.946 .595 .203 r
.8003 .37461 m .81341 .4281 L .80779 .42203 L p F P
0 g
s
.924 .541 .149 r
.77928 .35563 m .75426 .30038 L .76895 .31083 L p F P
0 g
s
.924 .541 .149 r
.76895 .31083 m .78929 .36231 L .77928 .35563 L p F P
0 g
s
.958 .623 .324 r
.20444 .75398 m .19611 .7763 L .22289 .81877 L p F P
0 g
s
.967 .645 .328 r
.19611 .7763 m .20444 .75398 L .18686 .71583 L p F P
0 g
s
.99 .774 .388 r
.13128 .55001 m .1421 .57071 L .14574 .52584 L p F P
0 g
s
.99 .774 .388 r
.14574 .52584 m .13573 .49753 L .13128 .55001 L p F P
0 g
s
.984 .7 .378 r
.15622 .67447 m .17353 .6749 L .16522 .63355 L p F P
0 g
s
.984 .7 .378 r
.16522 .63355 m .1456 .62122 L .15622 .67447 L p F P
0 g
s
.825 .529 .489 r
.31441 .45431 m .37145 .48622 L .36685 .51144 L p F P
0 g
s
.615 .05 0 r
.6831 .21925 m .6558 .20057 L .67812 .20607 L p F P
0 g
s
.615 .05 0 r
.67812 .20607 m .70297 .22385 L .6831 .21925 L p F P
0 g
s
.778 .282 .026 r
.74082 .80047 m .6979 .76425 L .68102 .76641 L p F P
0 g
s
.817 .343 .082 r
.638 .71972 m .68102 .76641 L .6979 .76425 L p F P
0 g
s
.969 .928 .616 r
.55513 .29045 m .54436 .34429 L .55907 .33535 L p F P
0 g
s
.969 .928 .616 r
.55907 .33535 m .5727 .28089 L .55513 .29045 L p F P
0 g
s
.967 .651 .269 r
.84126 .48909 m .82369 .48739 L .83657 .47455 L closepath p F P
0 g
s
.968 .655 .273 r
.84508 .50359 m .82369 .48739 L .84126 .48909 L closepath p F P
0 g
s
.966 .648 .267 r
.83657 .47455 m .82369 .48739 L .8312 .4606 L closepath p F P
0 g
s
.721 .206 0 r
.26078 .8816 m .27435 .89928 L .31235 .92811 L p F P
0 g
s
.154 .559 .929 r
.33194 .93377 m .31235 .92811 L .27435 .89928 L p F P
0 g
s
.868 .708 .681 r
.4634 .66046 m .42128 .71099 L .40438 .68142 L p F P
0 g
s
.868 .708 .681 r
.40438 .68142 m .45329 .6423 L .4634 .66046 L p F P
0 g
s
.969 .847 .439 r
.88157 .72963 m .87941 .77015 L .86634 .78648 L p F P
0 g
s
.855 .895 .474 r
.85512 .8174 m .86634 .78648 L .87941 .77015 L p F P
0 g
s
.967 .645 .328 r
.18686 .71583 m .17341 .72723 L .19611 .7763 L p F P
0 g
s
.976 .671 .347 r
.17341 .72723 m .18686 .71583 L .17353 .6749 L p F P
0 g
s
.834 .596 .578 r
.36637 .54189 m .42997 .55747 L .43251 .57826 L p F P
0 g
s
.834 .569 .538 r
.42997 .55747 m .36637 .54189 L .36685 .51144 L p F P
0 g
s
.976 .671 .347 r
.17353 .6749 m .15622 .67447 L .17341 .72723 L p F P
0 g
s
.97 .659 .279 r
.84785 .51744 m .82369 .48739 L .84508 .50359 L closepath p F P
0 g
s
.965 .645 .267 r
.8312 .4606 m .82369 .48739 L .82538 .44785 L closepath p F P
0 g
s
.8 .309 0 r
.58375 .66222 m .62271 .71288 L .638 .71972 L p F P
0 g
s
.724 .229 0 r
.62271 .71288 m .58375 .66222 L .57335 .653 L p F P
0 g
s
0 0 .139 r
.14874 .46148 m .13643 .47565 L .14992 .42904 L p F P
0 g
s
0 0 .139 r
.14992 .42904 m .16255 .41317 L .14874 .46148 L p F P
0 g
s
.878 .769 .268 r
.52374 .4443 m .52355 .49932 L .52647 .48543 L p F P
0 g
s
.878 .769 .268 r
.52647 .48543 m .52854 .42215 L .52374 .4443 L p F P
0 g
s
.824 .348 0 r
.71197 .25252 m .6831 .21925 L .70297 .22385 L p F P
0 g
s
.824 .348 0 r
.70297 .22385 m .72856 .25577 L .71197 .25252 L p F P
0 g
s
.889 .785 .74 r
.43048 .81164 m .40376 .86174 L .37267 .83559 L p F P
0 g
s
.889 .785 .74 r
.37267 .83559 m .40528 .78931 L .43048 .81164 L p F P
0 g
s
.971 .664 .287 r
.84945 .53003 m .82369 .48739 L .84785 .51744 L closepath p F P
0 g
s
.965 .644 .269 r
.82538 .44785 m .82369 .48739 L .81937 .43684 L closepath p F P
0 g
s
.7 .169 0 r
.77884 .82523 m .74082 .80047 L .72134 .80397 L p F P
0 g
s
.778 .282 .026 r
.68102 .76641 m .72134 .80397 L .74082 .80047 L p F P
0 g
s
.855 .678 .662 r
.45329 .6423 m .40438 .68142 L .38969 .64781 L p F P
0 g
s
.855 .678 .662 r
.38969 .64781 m .44448 .62182 L .45329 .6423 L p F P
0 g
s
.838 .622 .611 r
.37015 .57603 m .43251 .57826 L .43743 .6001 L p F P
0 g
s
.834 .596 .578 r
.43251 .57826 m .37015 .57603 L .36637 .54189 L p F P
0 g
s
.825 .529 .489 r
.36685 .51144 m .30733 .48784 L .31441 .45431 L p F P
0 g
s
.805 .508 .486 r
.26329 .42952 m .31441 .45431 L .30733 .48784 L p F P
0 g
s
.767 .259 0 r
.68102 .76641 m .638 .71972 L .62271 .71288 L p F P
0 g
s
.99 .789 .402 r
.87643 .67878 m .88157 .72963 L .87033 .74283 L p F P
0 g
s
.969 .847 .439 r
.86634 .78648 m .87033 .74283 L .88157 .72963 L p F P
0 g
s
.973 .689 .288 r
.86859 .60796 m .84884 .54922 L .84979 .54079 L p F P
0 g
s
.98 .701 .318 r
.84884 .54922 m .86859 .60796 L .86453 .61968 L p F P
0 g
s
.978 .728 .319 r
.87643 .67878 m .86453 .61968 L .86859 .60796 L p F P
0 g
s
.932 .96 .652 r
.56964 .24825 m .55513 .29045 L .5727 .28089 L p F P
0 g
s
.932 .96 .652 r
.5727 .28089 m .58909 .23858 L .56964 .24825 L p F P
0 g
s
.845 .65 .639 r
.44448 .62182 m .38969 .64781 L .37806 .612 L p F P
0 g
s
.845 .65 .639 r
.37806 .612 m .43743 .6001 L .44448 .62182 L p F P
0 g
s
.838 .622 .611 r
.43743 .6001 m .37806 .612 L .37015 .57603 L p F P
0 g
s
.695 .796 .927 r
.35401 .92433 m .33194 .93377 L .29272 .90379 L p F P
0 g
s
.154 .559 .929 r
.27435 .89928 m .29272 .90379 L .33194 .93377 L p F P
0 g
s
.944 .868 .45 r
.53338 .36358 m .52854 .42215 L .53674 .40705 L p F P
0 g
s
.944 .868 .45 r
.53674 .40705 m .54436 .34429 L .53338 .36358 L p F P
0 g
s
.951 .601 .227 r
.80275 .41897 m .77928 .35563 L .78929 .36231 L p F P
0 g
s
.951 .601 .227 r
.78929 .36231 m .80779 .42203 L .80275 .41897 L p F P
0 g
s
.973 .668 .295 r
.84979 .54079 m .82369 .48739 L .84945 .53003 L closepath p F P
0 g
s
.966 .643 .273 r
.81937 .43684 m .82369 .48739 L .81341 .4281 L closepath p F P
0 g
s
.878 .742 .708 r
.43942 .73496 m .40528 .78931 L .3803 .75756 L p F P
0 g
s
.878 .742 .708 r
.3803 .75756 m .42128 .71099 L .43942 .73496 L p F P
0 g
s
.9 .484 .124 r
.74153 .2986 m .71197 .25252 L .72856 .25577 L p F P
0 g
s
.9 .484 .124 r
.72856 .25577 m .75426 .30038 L .74153 .2986 L p F P
0 g
s
.868 .793 .775 r
.40376 .86174 m .37811 .89995 L .3425 .87128 L p F P
0 g
s
.868 .793 .775 r
.3425 .87128 m .37267 .83559 L .40376 .86174 L p F P
0 g
s
.53 .232 .406 r
.17289 .45579 m .14874 .46148 L .16255 .41317 L p F P
0 g
s
.53 .232 .406 r
.16255 .41317 m .18606 .40801 L .17289 .45579 L p F P
0 g
s
.823 .559 .54 r
.30733 .48784 m .36685 .51144 L .36637 .54189 L p F P
0 g
s
.91 .505 .144 r
.22289 .81877 m .22654 .84249 L .26078 .8816 L p F P
0 g
s
.911 .521 .109 r
.22654 .84249 m .22289 .81877 L .19611 .7763 L p F P
0 g
s
.616 .156 0 r
.60602 .69829 m .57335 .653 L .56273 .63953 L p F P
0 g
s
.724 .229 0 r
.57335 .653 m .60602 .69829 L .62271 .71288 L p F P
0 g
s
.515 0 0 r
.81101 .83686 m .77884 .82523 L .75782 .82988 L p F P
0 g
s
.7 .169 0 r
.72134 .80397 m .75782 .82988 L .77884 .82523 L p F P
0 g
s
.805 .508 .486 r
.30733 .48784 m .25374 .46976 L .26329 .42952 L p F P
0 g
s
.772 .472 .48 r
.21999 .41366 m .26329 .42952 L .25374 .46976 L p F P
0 g
s
.746 .621 .055 r
.52272 .4726 m .52294 .51672 L .52355 .49932 L p F P
0 g
s
.746 .621 .055 r
.52355 .49932 m .52374 .4443 L .52272 .4726 L p F P
0 g
s
.823 .803 .832 r
.37811 .89995 m .35401 .92433 L .31561 .89439 L p F P
0 g
s
.695 .796 .927 r
.29272 .90379 m .31561 .89439 L .35401 .92433 L p F P
0 g
s
.969 .718 .289 r
.13529 .60944 m .1456 .62122 L .1421 .57071 L p F P
0 g
s
.969 .718 .289 r
.1421 .57071 m .13128 .55001 L .13529 .60944 L p F P
0 g
s
.62 .139 0 r
.27435 .89928 m .26078 .8816 L .22654 .84249 L p F P
0 g
s
.823 .803 .832 r
.31561 .89439 m .3425 .87128 L .37811 .89995 L p F P
0 g
s
.767 .664 .111 r
.13152 .53325 m .13128 .55001 L .13573 .49753 L p F P
0 g
s
.767 .664 .111 r
.13573 .49753 m .13643 .47565 L .13152 .53325 L p F P
0 g
s
.99 .745 .371 r
.86453 .61968 m .87643 .67878 L .86739 .68836 L p F P
0 g
s
.99 .789 .402 r
.87033 .74283 m .86739 .68836 L .87643 .67878 L p F P
0 g
s
.975 .672 .304 r
.84884 .54922 m .82369 .48739 L .84979 .54079 L closepath p F P
0 g
s
.704 .402 .463 r
.20831 .45872 m .17289 .45579 L .18606 .40801 L p F P
0 g
s
.704 .402 .463 r
.18606 .40801 m .21999 .41366 L .20831 .45872 L p F P
0 g
s
.816 .982 .7 r
.58821 .21988 m .56964 .24825 L .58909 .23858 L p F P
0 g
s
.816 .982 .7 r
.58909 .23858 m .60845 .21036 L .58821 .21988 L p F P
0 g
s
.966 .644 .278 r
.81341 .4281 m .82369 .48739 L .80779 .42203 L closepath p F P
0 g
s
.772 .472 .48 r
.25374 .46976 m .20831 .45872 L .21999 .41366 L p F P
0 g
s
.935 .559 .202 r
.77077 .35509 m .74153 .2986 L .75426 .30038 L p F P
0 g
s
.935 .559 .202 r
.75426 .30038 m .77928 .35563 L .77077 .35509 L p F P
0 g
s
.015 0 0 r
.8366 .83435 m .81101 .83686 L .78947 .84218 L p F P
0 g
s
.515 0 0 r
.75782 .82988 m .78947 .84218 L .81101 .83686 L p F P
0 g
s
.616 .156 0 r
.56273 .63953 m .58877 .67643 L .60602 .69829 L p F P
0 g
s
0 0 .459 r
.58877 .67643 m .56273 .63953 L .55246 .62243 L p F P
0 g
s
0 0 .141 r
.52567 .5057 m .52471 .53681 L .52294 .51672 L p F P
0 g
s
0 0 .141 r
.52294 .51672 m .52272 .4726 L .52567 .5057 L p F P
0 g
s
.86 .707 .691 r
.42128 .71099 m .3803 .75756 L .35702 .71788 L p F P
0 g
s
.86 .707 .691 r
.35702 .71788 m .40438 .68142 L .42128 .71099 L p F P
0 g
s
.703 .168 0 r
.72134 .80397 m .68102 .76641 L .66111 .75802 L p F P
0 g
s
.767 .259 0 r
.62271 .71288 m .66111 .75802 L .68102 .76641 L p F P
0 g
s
.401 .829 .67 r
.61084 .20681 m .58821 .21988 L .60845 .21036 L p F P
0 g
s
.401 .829 .67 r
.60845 .21036 m .63076 .19752 L .61084 .20681 L p F P
0 g
s
.976 .676 .314 r
.84663 .5549 m .82369 .48739 L .84884 .54922 L closepath p F P
0 g
s
.98 .701 .318 r
.86453 .61968 m .84663 .5549 L .84884 .54922 L p F P
0 g
s
.824 .588 .582 r
.30595 .52876 m .36637 .54189 L .37015 .57603 L p F P
0 g
s
.823 .559 .54 r
.36637 .54189 m .30595 .52876 L .30733 .48784 L p F P
0 g
s
.985 .71 .346 r
.84663 .5549 m .86453 .61968 L .8581 .6256 L p F P
0 g
s
.99 .745 .371 r
.86739 .68836 m .8581 .6256 L .86453 .61968 L p F P
0 g
s
.967 .645 .285 r
.80779 .42203 m .82369 .48739 L .80275 .41897 L closepath p F P
0 g
s
.865 .743 .726 r
.40528 .78931 m .37267 .83559 L .34179 .79767 L p F P
0 g
s
.865 .743 .726 r
.34179 .79767 m .3803 .75756 L .40528 .78931 L p F P
0 g
s
.911 .521 .109 r
.19611 .7763 m .19496 .79259 L .22654 .84249 L p F P
0 g
s
.914 .551 .105 r
.19496 .79259 m .19611 .7763 L .17341 .72723 L p F P
0 g
s
.955 .609 .254 r
.79854 .41909 m .77077 .35509 L .77928 .35563 L p F P
0 g
s
.955 .609 .254 r
.77928 .35563 m .80275 .41897 L .79854 .41909 L p F P
0 g
s
.906 .875 .443 r
.54197 .31275 m .53338 .36358 L .54436 .34429 L p F P
0 g
s
.906 .875 .443 r
.54436 .34429 m .55513 .29045 L .54197 .31275 L p F P
0 g
s
.015 0 0 r
.78947 .84218 m .81546 .83968 L .8366 .83435 L p F P
0 g
s
.702 .978 .785 r
.85512 .8174 m .8366 .83435 L .81546 .83968 L p F P
0 g
s
.944 .656 .2 r
.14779 .67232 m .15622 .67447 L .1456 .62122 L p F P
0 g
s
.944 .656 .2 r
.1456 .62122 m .13529 .60944 L .14779 .67232 L p F P
0 g
s
.668 .161 0 r
.66111 .75802 m .62271 .71288 L .60602 .69829 L p F P
0 g
s
.805 .543 .543 r
.25374 .46976 m .30733 .48784 L .30595 .52876 L p F P
0 g
s
0 0 .459 r
.55246 .62243 m .57187 .64826 L .58877 .67643 L p F P
0 g
s
0 0 .486 r
.57187 .64826 m .55246 .62243 L .54305 .60254 L p F P
0 g
s
.836 .754 .238 r
.52692 .39276 m .52374 .4443 L .52854 .42215 L p F P
0 g
s
.836 .754 .238 r
.52854 .42215 m .53338 .36358 L .52692 .39276 L p F P
0 g
s
0 0 .293 r
.53251 .54185 m .5288 .55857 L .52471 .53681 L p F P
0 g
s
0 0 .293 r
.52471 .53681 m .52567 .5057 L .53251 .54185 L p F P
0 g
s
.62 .139 0 r
.22654 .84249 m .23676 .85639 L .27435 .89928 L p F P
0 g
s
.296 .549 .921 r
.29272 .90379 m .27435 .89928 L .23676 .85639 L p F P
0 g
s
.362 0 0 r
.63725 .20965 m .61084 .20681 L .63076 .19752 L p F P
0 g
s
.362 0 0 r
.63076 .19752 m .6558 .20057 L .63725 .20965 L p F P
0 g
s
.951 .951 .659 r
.86634 .78648 m .85512 .8174 L .8352 .82207 L p F P
0 g
s
.702 .978 .785 r
.81546 .83968 m .8352 .82207 L .85512 .8174 L p F P
0 g
s
.138 0 .4 r
.14384 .52141 m .13152 .53325 L .13643 .47565 L p F P
0 g
s
.138 0 .4 r
.13643 .47565 m .14874 .46148 L .14384 .52141 L p F P
0 g
s
.846 .675 .67 r
.40438 .68142 m .35702 .71788 L .33685 .67241 L p F P
0 g
s
.846 .675 .67 r
.33685 .67241 m .38969 .64781 L .40438 .68142 L p F P
0 g
s
.978 .679 .322 r
.84323 .55751 m .82369 .48739 L .84663 .5549 L closepath p F P
0 g
s
.985 .71 .346 r
.8581 .6256 m .84323 .55751 L .84663 .5549 L p F P
0 g
s
0 0 .486 r
.54305 .60254 m .55628 .61521 L .57187 .64826 L p F P
0 g
s
0 0 .463 r
.55628 .61521 m .54305 .60254 L .53502 .58087 L p F P
0 g
s
.828 .617 .616 r
.31057 .57495 m .37015 .57603 L .37806 .612 L p F P
0 g
s
.824 .588 .582 r
.37015 .57603 m .31057 .57495 L .30595 .52876 L p F P
0 g
s
.914 .551 .105 r
.17341 .72723 m .16811 .73469 L .19496 .79259 L p F P
0 g
s
.924 .597 .136 r
.16811 .73469 m .17341 .72723 L .15622 .67447 L p F P
0 g
s
0 0 .399 r
.5429 .57906 m .53502 .58087 L .5288 .55857 L p F P
0 g
s
0 0 .399 r
.5288 .55857 m .53251 .54185 L .5429 .57906 L p F P
0 g
s
.924 .597 .136 r
.15622 .67447 m .14779 .67232 L .16811 .73469 L p F P
0 g
s
.968 .647 .293 r
.80275 .41897 m .82369 .48739 L .79854 .41909 L closepath p F P
0 g
s
0 0 .463 r
.53502 .58087 m .5429 .57906 L .55628 .61521 L p F P
0 g
s
.74 .229 0 r
.66681 .22808 m .63725 .20965 L .6558 .20057 L p F P
0 g
s
.74 .229 0 r
.6558 .20057 m .6831 .21925 L .66681 .22808 L p F P
0 g
s
.995 .865 .544 r
.87033 .74283 m .86634 .78648 L .84836 .78995 L p F P
0 g
s
.951 .951 .659 r
.8352 .82207 m .84836 .78995 L .86634 .78648 L p F P
0 g
s
0 0 .458 r
.23676 .85639 m .22654 .84249 L .19496 .79259 L p F P
0 g
s
.843 .744 .754 r
.37267 .83559 m .3425 .87128 L .30709 .82904 L p F P
0 g
s
.843 .744 .754 r
.30709 .82904 m .34179 .79767 L .37267 .83559 L p F P
0 g
s
.836 .645 .646 r
.38969 .64781 m .33685 .67241 L .32105 .62379 L p F P
0 g
s
.836 .645 .646 r
.32105 .62379 m .37806 .612 L .38969 .64781 L p F P
0 g
s
.828 .617 .616 r
.37806 .612 m .32105 .62379 L .31057 .57495 L p F P
0 g
s
0 0 .12 r
.13596 .59879 m .13529 .60944 L .13128 .55001 L p F P
0 g
s
0 0 .12 r
.13128 .55001 m .13152 .53325 L .13596 .59879 L p F P
0 g
s
.568 0 0 r
.75782 .82988 m .72134 .80397 L .69796 .79461 L p F P
0 g
s
.703 .168 0 r
.66111 .75802 m .69796 .79461 L .72134 .80397 L p F P
0 g
s
.805 .543 .543 r
.30595 .52876 m .25127 .51928 L .25374 .46976 L p F P
0 g
s
.774 .516 .545 r
.20831 .45872 m .25374 .46976 L .25127 .51928 L p F P
0 g
s
.999 .8 .468 r
.86739 .68836 m .87033 .74283 L .85493 .74482 L p F P
0 g
s
.995 .865 .544 r
.84836 .78995 m .85493 .74482 L .87033 .74283 L p F P
0 g
s
.865 .423 .142 r
.6986 .26088 m .66681 .22808 L .6831 .21925 L p F P
0 g
s
.865 .423 .142 r
.6831 .21925 m .71197 .25252 L .6986 .26088 L p F P
0 g
s
.979 .681 .347 r
.82129 .53605 m .82369 .48739 L .82755 .54594 L closepath p F P
0 g
s
.978 .679 .349 r
.81501 .52377 m .82369 .48739 L .82129 .53605 L closepath p F P
0 g
s
.97 .652 .311 r
.79538 .42247 m .82369 .48739 L .79344 .42899 L closepath p F P
0 g
s
.969 .649 .302 r
.79854 .41909 m .82369 .48739 L .79538 .42247 L closepath p F P
0 g
s
.978 .681 .33 r
.83878 .55689 m .82369 .48739 L .84323 .55751 L closepath p F P
0 g
s
.979 .682 .337 r
.83347 .55299 m .82369 .48739 L .83878 .55689 L closepath p F P
0 g
s
.979 .682 .343 r
.82755 .54594 m .82369 .48739 L .83347 .55299 L closepath p F P
0 g
s
.978 .677 .349 r
.80903 .5097 m .82369 .48739 L .81501 .52377 L closepath p F P
0 g
s
.977 .674 .348 r
.80364 .49455 m .82369 .48739 L .80903 .5097 L closepath p F P
0 g
s
.976 .671 .345 r
.79913 .47907 m .82369 .48739 L .80364 .49455 L closepath p F P
0 g
s
.975 .667 .34 r
.79573 .46406 m .82369 .48739 L .79913 .47907 L closepath p F P
0 g
s
.974 .663 .334 r
.79359 .45028 m .82369 .48739 L .79573 .46406 L closepath p F P
0 g
s
.972 .659 .327 r
.79282 .4384 m .82369 .48739 L .79359 .45028 L closepath p F P
0 g
s
.971 .656 .319 r
.79344 .42899 m .82369 .48739 L .79282 .4384 L closepath p F P
0 g
s
.689 .72 .873 r
.31561 .89439 m .29272 .90379 L .25378 .85906 L p F P
0 g
s
.296 .549 .921 r
.23676 .85639 m .25378 .85906 L .29272 .90379 L p F P
0 g
s
.995 .753 .414 r
.8581 .6256 m .86739 .68836 L .85516 .68895 L p F P
0 g
s
.999 .8 .468 r
.85493 .74482 m .85516 .68895 L .86739 .68836 L p F P
0 g
s
.987 .715 .37 r
.84323 .55751 m .8581 .6256 L .84954 .62522 L p F P
0 g
s
.987 .715 .37 r
.84954 .62522 m .83878 .55689 L .84323 .55751 L p F P
0 g
s
.814 .866 .422 r
.55507 .27247 m .54197 .31275 L .55513 .29045 L p F P
0 g
s
.814 .866 .422 r
.55513 .29045 m .56964 .24825 L .55507 .27247 L p F P
0 g
s
.995 .753 .414 r
.85516 .68895 m .84954 .62522 L .8581 .6256 L p F P
0 g
s
.916 .52 .213 r
.73149 .30605 m .6986 .26088 L .71197 .25252 L p F P
0 g
s
.916 .52 .213 r
.71197 .25252 m .74153 .2986 L .73149 .30605 L p F P
0 g
s
.958 .618 .282 r
.77077 .35509 m .79854 .41909 L .79538 .42247 L p F P
0 g
s
.579 .346 .527 r
.16846 .5151 m .14384 .52141 L .14874 .46148 L p F P
0 g
s
.579 .346 .527 r
.14874 .46148 m .17289 .45579 L .16846 .5151 L p F P
0 g
s
.846 .705 .707 r
.3803 .75756 m .34179 .79767 L .31299 .74973 L p F P
0 g
s
.846 .705 .707 r
.31299 .74973 m .35702 .71788 L .3803 .75756 L p F P
0 g
s
.943 .578 .255 r
.7642 .36093 m .73149 .30605 L .74153 .2986 L p F P
0 g
s
.943 .578 .255 r
.74153 .2986 m .77077 .35509 L .7642 .36093 L p F P
0 g
s
.958 .618 .282 r
.79538 .42247 m .7642 .36093 L .77077 .35509 L p F P
0 g
s
.799 .742 .8 r
.3425 .87128 m .31561 .89439 L .27743 .84987 L p F P
0 g
s
.799 .742 .8 r
.27743 .84987 m .30709 .82904 L .3425 .87128 L p F P
0 g
s
.807 .576 .588 r
.25127 .51928 m .30595 .52876 L .31057 .57495 L p F P
0 g
s
.689 .72 .873 r
.25378 .85906 m .27743 .84987 L .31561 .89439 L p F P
0 g
s
.668 .161 0 r
.60602 .69829 m .63904 .73893 L .66111 .75802 L p F P
0 g
s
0 0 .459 r
.63904 .73893 m .60602 .69829 L .58877 .67643 L p F P
0 g
s
.774 .516 .545 r
.25127 .51928 m .20475 .51449 L .20831 .45872 L p F P
0 g
s
.716 .464 .544 r
.17289 .45579 m .20831 .45872 L .20475 .51449 L p F P
0 g
s
0 0 0 r
.52558 .43075 m .52272 .4726 L .52374 .4443 L p F P
0 g
s
0 0 0 r
.52374 .4443 m .52692 .39276 L .52558 .43075 L p F P
0 g
s
.716 .464 .544 r
.20475 .51449 m .16846 .5151 L .17289 .45579 L p F P
0 g
s
.988 .717 .39 r
.83878 .55689 m .84954 .62522 L .83917 .61832 L p F P
0 g
s
.988 .717 .39 r
.83917 .61832 m .83347 .55299 L .83878 .55689 L p F P
0 g
s
.56 .041 0 r
.69796 .79461 m .66111 .75802 L .63904 .73893 L p F P
0 g
s
.961 .627 .309 r
.7642 .36093 m .79538 .42247 L .79344 .42899 L p F P
0 g
s
.568 0 0 r
.69796 .79461 m .73224 .81993 L .75782 .82988 L p F P
0 g
s
0 .329 .659 r
.78947 .84218 m .75782 .82988 L .73224 .81993 L p F P
0 g
s
0 0 .458 r
.19496 .79259 m .20195 .80138 L .23676 .85639 L p F P
0 g
s
0 0 .467 r
.20195 .80138 m .19496 .79259 L .16811 .73469 L p F P
0 g
s
.75 .718 .186 r
.53423 .34748 m .52692 .39276 L .53338 .36358 L p F P
0 g
s
.75 .718 .186 r
.53338 .36358 m .54197 .31275 L .53423 .34748 L p F P
0 g
s
0 0 .296 r
.1498 .66831 m .14779 .67232 L .13529 .60944 L p F P
0 g
s
0 0 .296 r
.13529 .60944 m .13596 .59879 L .1498 .66831 L p F P
0 g
s
.356 .502 .867 r
.25378 .85906 m .23676 .85639 L .20195 .80138 L p F P
0 g
s
0 0 0 r
.57311 .24504 m .55507 .27247 L .56964 .24825 L p F P
0 g
s
0 0 0 r
.56964 .24825 m .58821 .21988 L .57311 .24504 L p F P
0 g
s
.831 .67 .683 r
.35702 .71788 m .31299 .74973 L .28813 .69443 L p F P
0 g
s
.831 .67 .683 r
.28813 .69443 m .33685 .67241 L .35702 .71788 L p F P
0 g
s
.26 .166 .554 r
.14864 .58978 m .13596 .59879 L .13152 .53325 L p F P
0 g
s
.26 .166 .554 r
.13152 .53325 m .14384 .52141 L .14864 .58978 L p F P
0 g
s
.812 .607 .625 r
.25633 .5755 m .31057 .57495 L .32105 .62379 L p F P
0 g
s
.807 .576 .588 r
.31057 .57495 m .25633 .5755 L .25127 .51928 L p F P
0 g
s
.823 .701 .73 r
.34179 .79767 m .30709 .82904 L .27408 .77518 L p F P
0 g
s
.823 .701 .73 r
.27408 .77518 m .31299 .74973 L .34179 .79767 L p F P
0 g
s
.987 .715 .405 r
.83347 .55299 m .83917 .61832 L .82746 .60502 L p F P
0 g
s
.987 .715 .405 r
.82746 .60502 m .82755 .54594 L .83347 .55299 L p F P
0 g
s
.994 .753 .446 r
.84954 .62522 m .85516 .68895 L .84015 .68001 L p F P
0 g
s
.994 .753 .446 r
.84015 .68001 m .83917 .61832 L .84954 .62522 L p F P
0 g
s
.964 .638 .334 r
.75999 .37311 m .79344 .42899 L .79282 .4384 L p F P
0 g
s
.961 .627 .309 r
.79344 .42899 m .75999 .37311 L .7642 .36093 L p F P
0 g
s
.779 .554 .595 r
.20475 .51449 m .25127 .51928 L .25633 .5755 L p F P
0 g
s
0 0 .459 r
.58877 .67643 m .61592 .70962 L .63904 .73893 L p F P
0 g
s
0 0 .543 r
.61592 .70962 m .58877 .67643 L .57187 .64826 L p F P
0 g
s
0 0 .467 r
.16811 .73469 m .17229 .73735 L .20195 .80138 L p F P
0 g
s
0 0 .41 r
.17229 .73735 m .16811 .73469 L .14779 .67232 L p F P
0 g
s
.947 .596 .303 r
.73149 .30605 m .7642 .36093 L .75999 .37311 L p F P
0 g
s
0 0 .41 r
.14779 .67232 m .1498 .66831 L .17229 .73735 L p F P
0 g
s
.345 .792 .956 r
.81546 .83968 m .78947 .84218 L .76296 .83187 L p F P
0 g
s
0 .329 .659 r
.73224 .81993 m .76296 .83187 L .78947 .84218 L p F P
0 g
s
0 0 .205 r
.52966 .47571 m .52567 .5057 L .52272 .4726 L p F P
0 g
s
0 0 .205 r
.52272 .4726 m .52558 .43075 L .52966 .47571 L p F P
0 g
s
.82 .638 .656 r
.33685 .67241 m .28813 .69443 L .26884 .63511 L p F P
0 g
s
.82 .638 .656 r
.26884 .63511 m .32105 .62379 L .33685 .67241 L p F P
0 g
s
.812 .607 .625 r
.32105 .62379 m .26884 .63511 L .25633 .5755 L p F P
0 g
s
.012 0 0 r
.59614 .23203 m .57311 .24504 L .58821 .21988 L p F P
0 g
s
.012 0 0 r
.58821 .21988 m .61084 .20681 L .59614 .23203 L p F P
0 g
s
.677 .656 .822 r
.27743 .84987 m .25378 .85906 L .21762 .80158 L p F P
0 g
s
.356 .502 .867 r
.20195 .80138 m .21762 .80158 L .25378 .85906 L p F P
0 g
s
.997 .796 .514 r
.85516 .68895 m .85493 .74482 L .83588 .7347 L p F P
0 g
s
.997 .796 .514 r
.83588 .7347 m .84015 .68001 L .85516 .68895 L p F P
0 g
s
.984 .711 .414 r
.82755 .54594 m .82746 .60502 L .81497 .58581 L p F P
0 g
s
.984 .711 .414 r
.81497 .58581 m .82129 .53605 L .82755 .54594 L p F P
0 g
s
.966 .648 .357 r
.75841 .39123 m .79282 .4384 L .79359 .45028 L p F P
0 g
s
.964 .638 .334 r
.79282 .4384 m .75841 .39123 L .75999 .37311 L p F P
0 g
s
.778 .69 .766 r
.30709 .82904 m .27743 .84987 L .24189 .79277 L p F P
0 g
s
.778 .69 .766 r
.24189 .79277 m .27408 .77518 L .30709 .82904 L p F P
0 g
s
.609 .426 .609 r
.17353 .5828 m .14864 .58978 L .14384 .52141 L p F P
0 g
s
.609 .426 .609 r
.14384 .52141 m .16846 .5151 L .17353 .5828 L p F P
0 g
s
.81 .966 .906 r
.8352 .82207 m .81546 .83968 L .78924 .82912 L p F P
0 g
s
.345 .792 .956 r
.76296 .83187 m .78924 .82912 L .81546 .83968 L p F P
0 g
s
.947 .596 .303 r
.75999 .37311 m .72478 .32284 L .73149 .30605 L p F P
0 g
s
.924 .552 .291 r
.6986 .26088 m .73149 .30605 L .72478 .32284 L p F P
0 g
s
.779 .554 .595 r
.25633 .5755 m .20993 .57804 L .20475 .51449 L p F P
0 g
s
.726 .515 .604 r
.16846 .5151 m .20475 .51449 L .20993 .57804 L p F P
0 g
s
.677 .656 .822 r
.21762 .80158 m .24189 .79277 L .27743 .84987 L p F P
0 g
s
.991 .851 .604 r
.85493 .74482 m .84836 .78995 L .826 .77932 L p F P
0 g
s
.991 .851 .604 r
.826 .77932 m .83588 .7347 L .85493 .74482 L p F P
0 g
s
.56 .041 0 r
.63904 .73893 m .67169 .77198 L .69796 .79461 L p F P
0 g
s
0 .167 .635 r
.73224 .81993 m .69796 .79461 L .67169 .77198 L p F P
0 g
s
0 0 .543 r
.57187 .64826 m .59304 .67135 L .61592 .70962 L p F P
0 g
s
0 0 .561 r
.59304 .67135 m .57187 .64826 L .55628 .61521 L p F P
0 g
s
.553 .084 .096 r
.62377 .23411 m .59614 .23203 L .61084 .20681 L p F P
0 g
s
.553 .084 .096 r
.61084 .20681 m .63725 .20965 L .62377 .23411 L p F P
0 g
s
.373 .442 .804 r
.21762 .80158 m .20195 .80138 L .17229 .73735 L p F P
0 g
s
.956 .918 .733 r
.84836 .78995 m .8352 .82207 L .8104 .81136 L p F P
0 g
s
.81 .966 .906 r
.78924 .82912 m .8104 .81136 L .8352 .82207 L p F P
0 g
s
.726 .515 .604 r
.20993 .57804 m .17353 .5828 L .16846 .5151 L p F P
0 g
s
0 0 .359 r
.53908 .52522 m .53251 .54185 L .52567 .5057 L p F P
0 g
s
0 0 .359 r
.52567 .5057 m .52966 .47571 L .53908 .52522 L p F P
0 g
s
.982 .705 .419 r
.82129 .53605 m .81497 .58581 L .80235 .56156 L p F P
0 g
s
.982 .705 .419 r
.80235 .56156 m .81501 .52377 L .82129 .53605 L p F P
0 g
s
.328 .285 .657 r
.16319 .66243 m .1498 .66831 L .13596 .59879 L p F P
0 g
s
.328 .285 .657 r
.13596 .59879 m .14864 .58978 L .16319 .66243 L p F P
0 g
s
.956 .918 .733 r
.8104 .81136 m .826 .77932 L .84836 .78995 L p F P
0 g
s
.968 .659 .377 r
.75965 .41453 m .79359 .45028 L .79573 .46406 L p F P
0 g
s
.966 .648 .357 r
.79359 .45028 m .75965 .41453 L .75841 .39123 L p F P
0 g
s
.807 .662 .702 r
.31299 .74973 m .27408 .77518 L .24568 .71272 L p F P
0 g
s
.807 .662 .702 r
.24568 .71272 m .28813 .69443 L .31299 .74973 L p F P
0 g
s
.924 .552 .291 r
.72478 .32284 m .68936 .28122 L .6986 .26088 L p F P
0 g
s
.881 .481 .267 r
.66681 .22808 m .6986 .26088 L .68936 .28122 L p F P
0 g
s
0 0 0 r
.54656 .31107 m .53423 .34748 L .54197 .31275 L p F P
0 g
s
0 0 0 r
.54197 .31275 m .55507 .27247 L .54656 .31107 L p F P
0 g
s
.785 .59 .636 r
.20993 .57804 m .25633 .5755 L .26884 .63511 L p F P
0 g
s
0 .059 .592 r
.67169 .77198 m .63904 .73893 L .61592 .70962 L p F P
0 g
s
.787 .352 .215 r
.65523 .25094 m .62377 .23411 L .63725 .20965 L p F P
0 g
s
.787 .352 .215 r
.63725 .20965 m .66681 .22808 L .65523 .25094 L p F P
0 g
s
.99 .748 .469 r
.83917 .61832 m .84015 .68001 L .82303 .66152 L p F P
0 g
s
.99 .748 .469 r
.82303 .66152 m .82746 .60502 L .83917 .61832 L p F P
0 g
s
.881 .481 .267 r
.68936 .28122 m .65523 .25094 L .66681 .22808 L p F P
0 g
s
0 0 .083 r
.53271 .39341 m .52558 .43075 L .52692 .39276 L p F P
0 g
s
0 0 .083 r
.52692 .39276 m .53423 .34748 L .53271 .39341 L p F P
0 g
s
.95 .614 .346 r
.72478 .32284 m .75999 .37311 L .75841 .39123 L p F P
0 g
s
.978 .697 .419 r
.81501 .52377 m .80235 .56156 L .79027 .53347 L p F P
0 g
s
.978 .697 .419 r
.79027 .53347 m .80903 .5097 L .81501 .52377 L p F P
0 g
s
.97 .669 .393 r
.7637 .44191 m .79573 .46406 L .79913 .47907 L p F P
0 g
s
.968 .659 .377 r
.79573 .46406 m .7637 .44191 L .75965 .41453 L p F P
0 g
s
0 0 .561 r
.55628 .61521 m .57176 .62607 L .59304 .67135 L p F P
0 g
s
0 0 .532 r
.57176 .62607 m .55628 .61521 L .5429 .57906 L p F P
0 g
s
0 0 .465 r
.55339 .57637 m .5429 .57906 L .53251 .54185 L p F P
0 g
s
0 0 .465 r
.53251 .54185 m .53908 .52522 L .55339 .57637 L p F P
0 g
s
.975 .689 .415 r
.80903 .5097 m .79027 .53347 L .77943 .50305 L p F P
0 g
s
.975 .689 .415 r
.77943 .50305 m .80364 .49455 L .80903 .5097 L p F P
0 g
s
.972 .679 .406 r
.7704 .47196 m .79913 .47907 L .80364 .49455 L p F P
0 g
s
.97 .669 .393 r
.79913 .47907 m .7704 .47196 L .7637 .44191 L p F P
0 g
s
.373 .442 .804 r
.17229 .73735 m .1867 .73463 L .21762 .80158 L p F P
0 g
s
.363 .372 .736 r
.1867 .73463 m .17229 .73735 L .1498 .66831 L p F P
0 g
s
0 0 .532 r
.5429 .57906 m .55339 .57637 L .57176 .62607 L p F P
0 g
s
.795 .625 .672 r
.28813 .69443 m .24568 .71272 L .22383 .64556 L p F P
0 g
s
.795 .625 .672 r
.22383 .64556 m .26884 .63511 L .28813 .69443 L p F P
0 g
s
.363 .372 .736 r
.1498 .66831 m .16319 .66243 L .1867 .73463 L p F P
0 g
s
.972 .679 .406 r
.80364 .49455 m .77943 .50305 L .7704 .47196 L p F P
0 g
s
.785 .59 .636 r
.26884 .63511 m .22383 .64556 L .20993 .57804 L p F P
0 g
s
.663 .6 .774 r
.24189 .79277 m .21762 .80158 L .1867 .73463 L p F P
0 g
s
.762 .644 .731 r
.27408 .77518 m .24189 .79277 L .21141 .72634 L p F P
0 g
s
.762 .644 .731 r
.21141 .72634 m .24568 .71272 L .27408 .77518 L p F P
0 g
s
.631 .49 .672 r
.1881 .65477 m .16319 .66243 L .14864 .58978 L p F P
0 g
s
.631 .49 .672 r
.14864 .58978 m .17353 .5828 L .1881 .65477 L p F P
0 g
s
.736 .559 .653 r
.17353 .5828 m .20993 .57804 L .22383 .64556 L p F P
0 g
s
.035 .486 .882 r
.76296 .83187 m .73224 .81993 L .70314 .79477 L p F P
0 g
s
0 .167 .635 r
.67169 .77198 m .70314 .79477 L .73224 .81993 L p F P
0 g
s
.663 .6 .774 r
.1867 .73463 m .21141 .72634 L .24189 .79277 L p F P
0 g
s
.736 .559 .653 r
.22383 .64556 m .1881 .65477 L .17353 .5828 L p F P
0 g
s
.987 .783 .541 r
.84015 .68001 m .83588 .7347 L .81396 .71223 L p F P
0 g
s
.987 .783 .541 r
.81396 .71223 m .82303 .66152 L .84015 .68001 L p F P
0 g
s
.984 .738 .482 r
.82746 .60502 m .82303 .66152 L .80461 .63404 L p F P
0 g
s
.984 .738 .482 r
.80461 .63404 m .81497 .58581 L .82746 .60502 L p F P
0 g
s
0 0 .063 r
.56445 .28578 m .54656 .31107 L .55507 .27247 L p F P
0 g
s
0 0 .063 r
.55507 .27247 m .57311 .24504 L .56445 .28578 L p F P
0 g
s
.952 .631 .384 r
.72193 .34859 m .75841 .39123 L .75965 .41453 L p F P
0 g
s
.95 .614 .346 r
.75841 .39123 m .72193 .34859 L .72478 .32284 L p F P
0 g
s
.927 .58 .356 r
.68936 .28122 m .72478 .32284 L .72193 .34859 L p F P
0 g
s
.748 .601 .694 r
.24568 .71272 m .21141 .72634 L .1881 .65477 L p F P
0 g
s
.748 .601 .694 r
.1881 .65477 m .22383 .64556 L .24568 .71272 L p F P
0 g
s
.648 .546 .725 r
.21141 .72634 m .1867 .73463 L .16319 .66243 L p F P
0 g
s
.648 .546 .725 r
.16319 .66243 m .1881 .65477 L .21141 .72634 L p F P
0 g
s
0 .059 .592 r
.61592 .70962 m .64384 .73653 L .67169 .77198 L p F P
0 g
s
0 .106 .658 r
.64384 .73653 m .61592 .70962 L .59304 .67135 L p F P
0 g
s
0 0 .297 r
.53784 .44838 m .52966 .47571 L .52558 .43075 L p F P
0 g
s
0 0 .297 r
.52558 .43075 m .53271 .39341 L .53784 .44838 L p F P
0 g
s
.511 .779 .993 r
.78924 .82912 m .76296 .83187 L .73252 .80517 L p F P
0 g
s
.035 .486 .882 r
.70314 .79477 m .73252 .80517 L .76296 .83187 L p F P
0 g
s
0 .263 .764 r
.70314 .79477 m .67169 .77198 L .64384 .73653 L p F P
0 g
s
.973 .822 .632 r
.83588 .7347 m .826 .77932 L .80015 .7541 L p F P
0 g
s
.973 .822 .632 r
.80015 .7541 m .81396 .71223 L .83588 .7347 L p F P
0 g
s
0 0 .205 r
.54508 .3628 m .53271 .39341 L .53423 .34748 L p F P
0 g
s
0 0 .205 r
.53423 .34748 m .54656 .31107 L .54508 .3628 L p F P
0 g
s
.977 .726 .487 r
.81497 .58581 m .80461 .63404 L .78589 .59877 L p F P
0 g
s
.977 .726 .487 r
.78589 .59877 m .80235 .56156 L .81497 .58581 L p F P
0 g
s
.277 0 .235 r
.58793 .27316 m .56445 .28578 L .57311 .24504 L p F P
0 g
s
.277 0 .235 r
.57311 .24504 m .59614 .23203 L .58793 .27316 L p F P
0 g
s
.927 .58 .356 r
.72193 .34859 m .68502 .31322 L .68936 .28122 L p F P
0 g
s
.885 .527 .362 r
.65523 .25094 m .68936 .28122 L .68502 .31322 L p F P
0 g
s
.954 .648 .415 r
.72327 .38229 m .75965 .41453 L .7637 .44191 L p F P
0 g
s
.952 .631 .384 r
.75965 .41453 m .72327 .38229 L .72193 .34859 L p F P
0 g
s
.81 .876 .894 r
.8104 .81136 m .78924 .82912 L .75896 .80186 L p F P
0 g
s
.511 .779 .993 r
.73252 .80517 m .75896 .80186 L .78924 .82912 L p F P
0 g
s
.93 .861 .75 r
.826 .77932 m .8104 .81136 L .78169 .78458 L p F P
0 g
s
.93 .861 .75 r
.78169 .78458 m .80015 .7541 L .826 .77932 L p F P
0 g
s
.81 .876 .894 r
.75896 .80186 m .78169 .78458 L .8104 .81136 L p F P
0 g
s
0 .106 .658 r
.59304 .67135 m .61601 .6897 L .64384 .73653 L p F P
0 g
s
0 .106 .659 r
.61601 .6897 m .59304 .67135 L .57176 .62607 L p F P
0 g
s
.885 .527 .362 r
.68502 .31322 m .64936 .28765 L .65523 .25094 L p F P
0 g
s
.803 .435 .36 r
.62377 .23411 m .65523 .25094 L .64936 .28765 L p F P
0 g
s
.629 .263 .33 r
.61655 .27389 m .58793 .27316 L .59614 .23203 L p F P
0 g
s
.629 .263 .33 r
.59614 .23203 m .62377 .23411 L .61655 .27389 L p F P
0 g
s
0 0 .448 r
.54955 .50931 m .53908 .52522 L .52966 .47571 L p F P
0 g
s
0 0 .448 r
.52966 .47571 m .53784 .44838 L .54955 .50931 L p F P
0 g
s
.975 .764 .555 r
.82303 .66152 m .81396 .71223 L .79024 .67793 L p F P
0 g
s
.975 .764 .555 r
.79024 .67793 m .80461 .63404 L .82303 .66152 L p F P
0 g
s
.97 .712 .485 r
.80235 .56156 m .78589 .59877 L .76796 .55751 L p F P
0 g
s
.97 .712 .485 r
.76796 .55751 m .79027 .53347 L .80235 .56156 L p F P
0 g
s
.956 .664 .441 r
.72889 .42235 m .7637 .44191 L .7704 .47196 L p F P
0 g
s
.954 .648 .415 r
.7637 .44191 m .72889 .42235 L .72327 .38229 L p F P
0 g
s
.928 .605 .41 r
.68502 .31322 m .72193 .34859 L .72327 .38229 L p F P
0 g
s
.803 .435 .36 r
.64936 .28765 m .61655 .27389 L .62377 .23411 L p F P
0 g
s
.965 .696 .476 r
.79027 .53347 m .76796 .55751 L .75186 .51258 L p F P
0 g
s
.965 .696 .476 r
.75186 .51258 m .77943 .50305 L .79027 .53347 L p F P
0 g
s
.96 .68 .462 r
.73859 .46663 m .7704 .47196 L .77943 .50305 L p F P
0 g
s
.956 .664 .441 r
.7704 .47196 m .73859 .46663 L .72889 .42235 L p F P
0 g
s
0 .106 .659 r
.57176 .62607 m .58992 .63392 L .61601 .6897 L p F P
0 g
s
0 .067 .62 r
.58992 .63392 m .57176 .62607 L .55339 .57637 L p F P
0 g
s
.96 .68 .462 r
.77943 .50305 m .75186 .51258 L .73859 .46663 L p F P
0 g
s
0 0 .551 r
.56727 .5725 m .55339 .57637 L .53908 .52522 L p F P
0 g
s
0 0 .551 r
.53908 .52522 m .54955 .50931 L .56727 .5725 L p F P
0 g
s
.214 .513 .912 r
.73252 .80517 m .70314 .79477 L .67199 .75475 L p F P
0 g
s
0 .263 .764 r
.64384 .73653 m .67199 .75475 L .70314 .79477 L p F P
0 g
s
.042 0 .343 r
.56324 .34086 m .54508 .3628 L .54656 .31107 L p F P
0 g
s
.042 0 .343 r
.54656 .31107 m .56445 .28578 L .56324 .34086 L p F P
0 g
s
0 .067 .62 r
.55339 .57637 m .56727 .5725 L .58992 .63392 L p F P
0 g
s
0 .288 .786 r
.67199 .75475 m .64384 .73653 L .61601 .6897 L p F P
0 g
s
0 0 .41 r
.55114 .42525 m .53784 .44838 L .53271 .39341 L p F P
0 g
s
0 0 .41 r
.53271 .39341 m .54508 .3628 L .55114 .42525 L p F P
0 g
s
.953 .788 .64 r
.81396 .71223 m .80015 .7541 L .77207 .71473 L p F P
0 g
s
.953 .788 .64 r
.77207 .71473 m .79024 .67793 L .81396 .71223 L p F P
0 g
s
.963 .742 .557 r
.80461 .63404 m .79024 .67793 L .76604 .63324 L p F P
0 g
s
.963 .742 .557 r
.76604 .63324 m .78589 .59877 L .80461 .63404 L p F P
0 g
s
.928 .605 .41 r
.72327 .38229 m .68611 .35577 L .68502 .31322 L p F P
0 g
s
.885 .564 .436 r
.64936 .28765 m .68502 .31322 L .68611 .35577 L p F P
0 g
s
.929 .629 .454 r
.68611 .35577 m .72327 .38229 L .72889 .42235 L p F P
0 g
s
.563 .709 .939 r
.75896 .80186 m .73252 .80517 L .69968 .76237 L p F P
0 g
s
.214 .513 .912 r
.67199 .75475 m .69968 .76237 L .73252 .80517 L p F P
0 g
s
.407 .17 .44 r
.58722 .32897 m .56324 .34086 L .56445 .28578 L p F P
0 g
s
.407 .17 .44 r
.56445 .28578 m .58793 .27316 L .58722 .32897 L p F P
0 g
s
.901 .803 .742 r
.80015 .7541 m .78169 .78458 L .75049 .74206 L p F P
0 g
s
.901 .803 .742 r
.75049 .74206 m .77207 .71473 L .80015 .7541 L p F P
0 g
s
.885 .564 .436 r
.68611 .35577 m .64994 .33704 L .64936 .28765 L p F P
0 g
s
.808 .495 .459 r
.61655 .27389 m .64936 .28765 L .64994 .33704 L p F P
0 g
s
.952 .72 .551 r
.78589 .59877 m .76604 .63324 L .74281 .58048 L p F P
0 g
s
.952 .72 .551 r
.74281 .58048 m .76796 .55751 L .78589 .59877 L p F P
0 g
s
.789 .792 .855 r
.78169 .78458 m .75896 .80186 L .72611 .75821 L p F P
0 g
s
.563 .709 .939 r
.69968 .76237 m .72611 .75821 L .75896 .80186 L p F P
0 g
s
0 .288 .786 r
.61601 .6897 m .64058 .70144 L .67199 .75475 L p F P
0 g
s
.068 .269 .758 r
.64058 .70144 m .61601 .6897 L .58992 .63392 L p F P
0 g
s
.931 .652 .489 r
.69286 .40685 m .72889 .42235 L .73859 .46663 L p F P
0 g
s
.929 .629 .454 r
.72889 .42235 m .69286 .40685 L .68611 .35577 L p F P
0 g
s
.789 .792 .855 r
.72611 .75821 m .75049 .74206 L .78169 .78458 L p F P
0 g
s
.004 .039 .544 r
.56469 .49486 m .54955 .50931 L .53784 .44838 L p F P
0 g
s
.004 .039 .544 r
.53784 .44838 m .55114 .42525 L .56469 .49486 L p F P
0 g
s
.664 .373 .469 r
.61648 .32777 m .58722 .32897 L .58793 .27316 L p F P
0 g
s
.664 .373 .469 r
.58793 .27316 m .61655 .27389 L .61648 .32777 L p F P
0 g
s
.808 .495 .459 r
.64994 .33704 m .61648 .32777 L .61655 .27389 L p F P
0 g
s
.3 .487 .875 r
.69968 .76237 m .67199 .75475 L .64058 .70144 L p F P
0 g
s
.189 .095 .51 r
.57006 .40773 m .55114 .42525 L .54508 .3628 L p F P
0 g
s
.189 .095 .51 r
.54508 .3628 m .56324 .34086 L .57006 .40773 L p F P
0 g
s
.933 .753 .636 r
.79024 .67793 m .77207 .71473 L .74335 .66279 L p F P
0 g
s
.933 .753 .636 r
.74335 .66279 m .76604 .63324 L .79024 .67793 L p F P
0 g
s
.943 .697 .537 r
.76796 .55751 m .74281 .58048 L .72204 .52276 L p F P
0 g
s
.943 .697 .537 r
.72204 .52276 m .75186 .51258 L .76796 .55751 L p F P
0 g
s
.936 .674 .516 r
.70504 .46365 m .73859 .46663 L .75186 .51258 L p F P
0 g
s
.931 .652 .489 r
.73859 .46663 m .70504 .46365 L .69286 .40685 L p F P
0 g
s
.886 .597 .492 r
.64994 .33704 m .68611 .35577 L .69286 .40685 L p F P
0 g
s
.936 .674 .516 r
.75186 .51258 m .72204 .52276 L .70504 .46365 L p F P
0 g
s
.068 .269 .758 r
.58992 .63392 m .61093 .63765 L .64058 .70144 L p F P
0 g
s
.089 .221 .707 r
.61093 .63765 m .58992 .63392 L .56727 .5725 L p F P
0 g
s
.068 .147 .638 r
.58505 .56725 m .56727 .5725 L .54955 .50931 L p F P
0 g
s
.068 .147 .638 r
.54955 .50931 m .56469 .49486 L .58505 .56725 L p F P
0 g
s
.089 .221 .707 r
.56727 .5725 m .58505 .56725 L .61093 .63765 L p F P
0 g
s
.577 .642 .878 r
.72611 .75821 m .69968 .76237 L .66633 .7051 L p F P
0 g
s
.3 .487 .875 r
.64058 .70144 m .66633 .7051 L .69968 .76237 L p F P
0 g
s
.876 .752 .723 r
.77207 .71473 m .75049 .74206 L .71858 .68546 L p F P
0 g
s
.876 .752 .723 r
.71858 .68546 m .74335 .66279 L .77207 .71473 L p F P
0 g
s
.477 .3 .561 r
.59458 .39688 m .57006 .40773 L .56324 .34086 L p F P
0 g
s
.477 .3 .561 r
.56324 .34086 m .58722 .32897 L .59458 .39688 L p F P
0 g
s
.886 .597 .492 r
.69286 .40685 m .65733 .39678 L .64994 .33704 L p F P
0 g
s
.813 .543 .53 r
.61648 .32777 m .64994 .33704 L .65733 .39678 L p F P
0 g
s
.917 .72 .622 r
.76604 .63324 m .74335 .66279 L .7158 .601 L p F P
0 g
s
.917 .72 .622 r
.7158 .601 m .74281 .58048 L .76604 .63324 L p F P
0 g
s
.889 .628 .537 r
.65733 .39678 m .69286 .40685 L .70504 .46365 L p F P
0 g
s
.334 .441 .822 r
.66633 .7051 m .64058 .70144 L .61093 .63765 L p F P
0 g
s
.272 .223 .618 r
.58486 .48256 m .56469 .49486 L .55114 .42525 L p F P
0 g
s
.272 .223 .618 r
.55114 .42525 m .57006 .40773 L .58486 .48256 L p F P
0 g
s
.767 .724 .812 r
.75049 .74206 m .72611 .75821 L .69261 .69981 L p F P
0 g
s
.577 .642 .878 r
.66633 .7051 m .69261 .69981 L .72611 .75821 L p F P
0 g
s
.767 .724 .812 r
.69261 .69981 m .71858 .68546 L .75049 .74206 L p F P
0 g
s
.685 .45 .56 r
.62405 .39325 m .59458 .39688 L .58722 .32897 L p F P
0 g
s
.685 .45 .56 r
.58722 .32897 m .61648 .32777 L .62405 .39325 L p F P
0 g
s
.813 .543 .53 r
.65733 .39678 m .62405 .39325 L .61648 .32777 L p F P
0 g
s
.904 .689 .601 r
.74281 .58048 m .7158 .601 L .69126 .53312 L p F P
0 g
s
.904 .689 .601 r
.69126 .53312 m .72204 .52276 L .74281 .58048 L p F P
0 g
s
.895 .658 .573 r
.67135 .46353 m .70504 .46365 L .72204 .52276 L p F P
0 g
s
.889 .628 .537 r
.70504 .46365 m .67135 .46353 L .65733 .39678 L p F P
0 g
s
.334 .441 .822 r
.61093 .63765 m .63467 .63641 L .66633 .7051 L p F P
0 g
s
.338 .385 .763 r
.63467 .63641 m .61093 .63765 L .58505 .56725 L p F P
0 g
s
.895 .658 .573 r
.72204 .52276 m .69126 .53312 L .67135 .46353 L p F P
0 g
s
.318 .315 .698 r
.60687 .56053 m .58505 .56725 L .56469 .49486 L p F P
0 g
s
.318 .315 .698 r
.56469 .49486 m .58486 .48256 L .60687 .56053 L p F P
0 g
s
.855 .706 .697 r
.74335 .66279 m .71858 .68546 L .68803 .61776 L p F P
0 g
s
.855 .706 .697 r
.68803 .61776 m .7158 .601 L .74335 .66279 L p F P
0 g
s
.575 .581 .821 r
.69261 .69981 m .66633 .7051 L .63467 .63641 L p F P
0 g
s
.818 .585 .585 r
.62405 .39325 m .65733 .39678 L .67135 .46353 L p F P
0 g
s
.338 .385 .763 r
.58505 .56725 m .60687 .56053 L .63467 .63641 L p F P
0 g
s
.519 .39 .644 r
.6099 .47301 m .58486 .48256 L .57006 .40773 L p F P
0 g
s
.519 .39 .644 r
.57006 .40773 m .59458 .39688 L .6099 .47301 L p F P
0 g
s
.748 .666 .77 r
.71858 .68546 m .69261 .69981 L .66064 .62976 L p F P
0 g
s
.748 .666 .77 r
.66064 .62976 m .68803 .61776 L .71858 .68546 L p F P
0 g
s
.575 .581 .821 r
.63467 .63641 m .66064 .62976 L .69261 .69981 L p F P
0 g
s
.818 .585 .585 r
.67135 .46353 m .63913 .46661 L .62405 .39325 L p F P
0 g
s
.701 .51 .626 r
.59458 .39688 m .62405 .39325 L .63913 .46661 L p F P
0 g
s
.701 .51 .626 r
.63913 .46661 m .6099 .47301 L .59458 .39688 L p F P
0 g
s
.839 .664 .666 r
.7158 .601 m .68803 .61776 L .66093 .54316 L p F P
0 g
s
.839 .664 .666 r
.66093 .54316 m .69126 .53312 L .7158 .601 L p F P
0 g
s
.827 .624 .629 r
.63913 .46661 m .67135 .46353 L .69126 .53312 L p F P
0 g
s
.564 .522 .767 r
.66064 .62976 m .63467 .63641 L .60687 .56053 L p F P
0 g
s
.546 .461 .71 r
.63241 .55243 m .60687 .56053 L .58486 .48256 L p F P
0 g
s
.546 .461 .71 r
.58486 .48256 m .6099 .47301 L .63241 .55243 L p F P
0 g
s
.827 .624 .629 r
.69126 .53312 m .66093 .54316 L .63913 .46661 L p F P
0 g
s
.564 .522 .767 r
.60687 .56053 m .63241 .55243 L .66064 .62976 L p F P
0 g
s
.731 .613 .727 r
.68803 .61776 m .66064 .62976 L .63241 .55243 L p F P
0 g
s
.731 .613 .727 r
.63241 .55243 m .66093 .54316 L .68803 .61776 L p F P
0 g
s
.716 .563 .68 r
.6099 .47301 m .63913 .46661 L .66093 .54316 L p F P
0 g
s
.716 .563 .68 r
.66093 .54316 m .63241 .55243 L .6099 .47301 L p F P
0 g
s
.25 Mabswid
.67294 0 m
.92718 .41421 L
s
.92718 .41421 m
1 .94731 L
s
1 .94731 m
.70701 .58522 L
s
.70701 .58522 m
.67294 0 L
s
.08828 .24569 m
0 .80363 L
s
0 .80363 m
.70701 .58522 L
s
.70701 .58522 m
.67294 0 L
s
.67294 0 m
.08828 .24569 L
s
.08828 .24569 m
.67294 0 L
s
0 .80363 m
.39959 1.08495 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.33.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics3D", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[11]= ",
 CellTags->"S5.33.1"]
}, Open  ]],

Cell[TextData[{
 "This shows the graphics objects with projections from the ",
 Cell[BoxData[
  FormBox[
   StyleBox["x",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4,
  ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox["y",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4,
  ColumnWidths->Automatic}],
 " directions. "
}], "MathCaption",
 CellTags->{"S5.33.1", "1.18"}],

Cell[CellGroupData[{

Cell["Shadow[dbell, ZShadow -> False]", "Input",
 CellLabel->"In[12]:= ",
 CellTags->"S5.33.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .92733 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-1.04626e-17 1.05057 -0.0129365 1.05057 [
[ 0 0 0 0 ]
[ 1 .92733 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.05861 .25171 m
0 .62211 L
s
0 .62211 m
.39809 .92733 L
s
.39809 .92733 m
.40984 .59229 L
s
.40984 .59229 m
.05861 .25171 L
s
.68233 0 m
.95161 .42327 L
s
.95161 .42327 m
1 .77748 L
s
1 .77748 m
.70492 .38796 L
s
.70492 .38796 m
.68233 0 L
s
.05861 .25171 m
0 .62211 L
s
0 .62211 m
.70492 .38796 L
s
.70492 .38796 m
.68233 0 L
s
.68233 0 m
.05861 .25171 L
s
.40984 .59229 m
.95161 .42327 L
s
.95161 .42327 m
1 .77748 L
s
1 .77748 m
.39809 .92733 L
s
.39809 .92733 m
.40984 .59229 L
s
0 0 m
1 0 L
1 .92733 L
0 .92733 L
closepath
clip
newpath
.5 Mabswid
.573 .366 .563 r
.63238 .52106 m .62098 .52989 L .62108 .53325 L p F P
0 g
s
.573 .366 .563 r
.62098 .52989 m .6113 .54498 L .61138 .54809 L p F P
0 g
s
.573 .366 .563 r
.61138 .54809 m .62108 .53325 L .62098 .52989 L p F P
0 g
s
.573 .366 .563 r
.63249 .52454 m .62108 .53325 L .62098 .52989 L p F P
0 g
s
.573 .366 .563 r
.62098 .52989 m .63238 .52106 L .63249 .52454 L p F P
0 g
s
.573 .366 .563 r
.6113 .54498 m .62098 .52989 L .62108 .53325 L p F P
0 g
s
.573 .366 .563 r
.64546 .51874 m .63238 .52106 L .63249 .52454 L p F P
0 g
s
.573 .366 .563 r
.62108 .53325 m .63249 .52454 L .63238 .52106 L p F P
0 g
s
.573 .366 .563 r
.64559 .52219 m .63249 .52454 L .63238 .52106 L p F P
0 g
s
.573 .366 .563 r
.63238 .52106 m .64546 .51874 L .64559 .52219 L p F P
0 g
s
.573 .366 .563 r
.63249 .52454 m .62108 .53325 L .62137 .54324 L p F P
0 g
s
.573 .366 .563 r
.62108 .53325 m .61138 .54809 L .61163 .55731 L p F P
0 g
s
.573 .366 .563 r
.61163 .55731 m .62137 .54324 L .62108 .53325 L p F P
0 g
s
.573 .366 .563 r
.63284 .53487 m .62137 .54324 L .62108 .53325 L p F P
0 g
s
.573 .366 .563 r
.62108 .53325 m .63249 .52454 L .63284 .53487 L p F P
0 g
s
.573 .366 .563 r
.61138 .54809 m .62108 .53325 L .62137 .54324 L p F P
0 g
s
.573 .366 .563 r
.62108 .53325 m .61138 .54809 L .6113 .54498 L p F P
0 g
s
.573 .366 .563 r
.63249 .52454 m .64559 .52219 L .64546 .51874 L p F P
0 g
s
.573 .366 .563 r
.64559 .52219 m .63249 .52454 L .63284 .53487 L p F P
0 g
s
.573 .366 .563 r
.62137 .54324 m .63284 .53487 L .63249 .52454 L p F P
0 g
s
.573 .366 .563 r
.64597 .53242 m .63284 .53487 L .63249 .52454 L p F P
0 g
s
.573 .366 .563 r
.63249 .52454 m .64559 .52219 L .64597 .53242 L p F P
0 g
s
.573 .366 .563 r
.6113 .54498 m .60339 .56589 L .60346 .5686 L p F P
0 g
s
.573 .366 .563 r
.60346 .5686 m .61138 .54809 L .6113 .54498 L p F P
0 g
s
.573 .366 .563 r
.60339 .56589 m .6113 .54498 L .61138 .54809 L p F P
0 g
s
.573 .366 .563 r
.61138 .54809 m .60346 .5686 L .60365 .57663 L p F P
0 g
s
.573 .366 .563 r
.60365 .57663 m .61163 .55731 L .61138 .54809 L p F P
0 g
s
.573 .366 .563 r
.62137 .54324 m .61163 .55731 L .61138 .54809 L p F P
0 g
s
.573 .366 .563 r
.60346 .5686 m .61138 .54809 L .61163 .55731 L p F P
0 g
s
.573 .366 .563 r
.61138 .54809 m .60346 .5686 L .60339 .56589 L p F P
0 g
s
.573 .366 .563 r
.66018 .52294 m .64546 .51874 L .64559 .52219 L p F P
0 g
s
.573 .366 .563 r
.66031 .5262 m .64559 .52219 L .64546 .51874 L p F P
0 g
s
.573 .366 .563 r
.64546 .51874 m .66018 .52294 L .66031 .5262 L p F P
0 g
s
.573 .366 .563 r
.63284 .53487 m .62137 .54324 L .62185 .5595 L p F P
0 g
s
.573 .366 .563 r
.62137 .54324 m .61163 .55731 L .61202 .57229 L p F P
0 g
s
.573 .366 .563 r
.61202 .57229 m .62185 .5595 L .62137 .54324 L p F P
0 g
s
.573 .366 .563 r
.6334 .55169 m .62185 .5595 L .62137 .54324 L p F P
0 g
s
.573 .366 .563 r
.62137 .54324 m .63284 .53487 L .6334 .55169 L p F P
0 g
s
.573 .366 .563 r
.61163 .55731 m .62137 .54324 L .62185 .5595 L p F P
0 g
s
.573 .366 .563 r
.64559 .52219 m .66031 .5262 L .66018 .52294 L p F P
0 g
s
.573 .366 .563 r
.66031 .5262 m .64559 .52219 L .64597 .53242 L p F P
0 g
s
.573 .366 .563 r
.63284 .53487 m .64597 .53242 L .64559 .52219 L p F P
0 g
s
.573 .366 .563 r
.66072 .53589 m .64597 .53242 L .64559 .52219 L p F P
0 g
s
.573 .366 .563 r
.64559 .52219 m .66031 .5262 L .66072 .53589 L p F P
0 g
s
.573 .366 .563 r
.64597 .53242 m .63284 .53487 L .6334 .55169 L p F P
0 g
s
.573 .366 .563 r
.62185 .5595 m .6334 .55169 L .63284 .53487 L p F P
0 g
s
.573 .366 .563 r
.64659 .54907 m .6334 .55169 L .63284 .53487 L p F P
0 g
s
.573 .366 .563 r
.63284 .53487 m .64597 .53242 L .64659 .54907 L p F P
0 g
s
.573 .366 .563 r
.61163 .55731 m .60365 .57663 L .60396 .58968 L p F P
0 g
s
.573 .366 .563 r
.60396 .58968 m .61202 .57229 L .61163 .55731 L p F P
0 g
s
.573 .366 .563 r
.62185 .5595 m .61202 .57229 L .61163 .55731 L p F P
0 g
s
.573 .366 .563 r
.60365 .57663 m .61163 .55731 L .61202 .57229 L p F P
0 g
s
.573 .366 .563 r
.61163 .55731 m .60365 .57663 L .60346 .5686 L p F P
0 g
s
.573 .366 .563 r
.60339 .56589 m .5973 .59193 L .59735 .59411 L p F P
0 g
s
.573 .366 .563 r
.59735 .59411 m .60346 .5686 L .60339 .56589 L p F P
0 g
s
.573 .366 .563 r
.5973 .59193 m .60339 .56589 L .60346 .5686 L p F P
0 g
s
.573 .366 .563 r
.60346 .5686 m .59735 .59411 L .59749 .60057 L p F P
0 g
s
.573 .366 .563 r
.59749 .60057 m .60365 .57663 L .60346 .5686 L p F P
0 g
s
.573 .366 .563 r
.59735 .59411 m .60346 .5686 L .60365 .57663 L p F P
0 g
s
.573 .366 .563 r
.60346 .5686 m .59735 .59411 L .5973 .59193 L p F P
0 g
s
.573 .366 .563 r
.64597 .53242 m .66072 .53589 L .66031 .5262 L p F P
0 g
s
.573 .366 .563 r
.66072 .53589 m .64597 .53242 L .64659 .54907 L p F P
0 g
s
.573 .366 .563 r
.6334 .55169 m .64659 .54907 L .64597 .53242 L p F P
0 g
s
.573 .366 .563 r
.66138 .55166 m .64659 .54907 L .64597 .53242 L p F P
0 g
s
.573 .366 .563 r
.64597 .53242 m .66072 .53589 L .66138 .55166 L p F P
0 g
s
.573 .366 .563 r
.67647 .53342 m .66018 .52294 L .66031 .5262 L p F P
0 g
s
.573 .366 .563 r
.67661 .53636 m .66031 .5262 L .66018 .52294 L p F P
0 g
s
.573 .366 .563 r
.66018 .52294 m .67647 .53342 L .67661 .53636 L p F P
0 g
s
.573 .366 .563 r
.6334 .55169 m .62185 .5595 L .6225 .58143 L p F P
0 g
s
.573 .366 .563 r
.62185 .5595 m .61202 .57229 L .61256 .5925 L p F P
0 g
s
.573 .366 .563 r
.61256 .5925 m .6225 .58143 L .62185 .5595 L p F P
0 g
s
.573 .366 .563 r
.63415 .57439 m .6225 .58143 L .62185 .5595 L p F P
0 g
s
.573 .366 .563 r
.62185 .5595 m .6334 .55169 L .63415 .57439 L p F P
0 g
s
.573 .366 .563 r
.61202 .57229 m .62185 .5595 L .6225 .58143 L p F P
0 g
s
.573 .366 .563 r
.60365 .57663 m .59749 .60057 L .59772 .61105 L p F P
0 g
s
.573 .366 .563 r
.59772 .61105 m .60396 .58968 L .60365 .57663 L p F P
0 g
s
.573 .366 .563 r
.61202 .57229 m .60396 .58968 L .60365 .57663 L p F P
0 g
s
.573 .366 .563 r
.59749 .60057 m .60365 .57663 L .60396 .58968 L p F P
0 g
s
.573 .366 .563 r
.60365 .57663 m .59749 .60057 L .59735 .59411 L p F P
0 g
s
.573 .366 .563 r
.66031 .5262 m .67661 .53636 L .67647 .53342 L p F P
0 g
s
.573 .366 .563 r
.67661 .53636 m .66031 .5262 L .66072 .53589 L p F P
0 g
s
.573 .366 .563 r
.67702 .54509 m .66072 .53589 L .66031 .5262 L p F P
0 g
s
.573 .366 .563 r
.66031 .5262 m .67661 .53636 L .67702 .54509 L p F P
0 g
s
.573 .366 .563 r
.64659 .54907 m .6334 .55169 L .63415 .57439 L p F P
0 g
s
.573 .366 .563 r
.6225 .58143 m .63415 .57439 L .6334 .55169 L p F P
0 g
s
.573 .366 .563 r
.64743 .57156 m .63415 .57439 L .6334 .55169 L p F P
0 g
s
.573 .366 .563 r
.6334 .55169 m .64659 .54907 L .64743 .57156 L p F P
0 g
s
.573 .366 .563 r
.61202 .57229 m .60396 .58968 L .60438 .60724 L p F P
0 g
s
.573 .366 .563 r
.60438 .60724 m .61256 .5925 L .61202 .57229 L p F P
0 g
s
.573 .366 .563 r
.6225 .58143 m .61256 .5925 L .61202 .57229 L p F P
0 g
s
.573 .366 .563 r
.60396 .58968 m .61202 .57229 L .61256 .5925 L p F P
0 g
s
.573 .366 .563 r
.5973 .59193 m .59309 .62216 L .59312 .6237 L p F P
0 g
s
.573 .366 .563 r
.59312 .6237 m .59735 .59411 L .5973 .59193 L p F P
0 g
s
.573 .366 .563 r
.59309 .62216 m .5973 .59193 L .59735 .59411 L p F P
0 g
s
.573 .366 .563 r
.66072 .53589 m .67702 .54509 L .67661 .53636 L p F P
0 g
s
.573 .366 .563 r
.67702 .54509 m .66072 .53589 L .66138 .55166 L p F P
0 g
s
.573 .366 .563 r
.64659 .54907 m .66138 .55166 L .66072 .53589 L p F P
0 g
s
.573 .366 .563 r
.67768 .55927 m .66138 .55166 L .66072 .53589 L p F P
0 g
s
.573 .366 .563 r
.66072 .53589 m .67702 .54509 L .67768 .55927 L p F P
0 g
s
.573 .366 .563 r
.59735 .59411 m .59312 .6237 L .59321 .62825 L p F P
0 g
s
.573 .366 .563 r
.59321 .62825 m .59749 .60057 L .59735 .59411 L p F P
0 g
s
.573 .366 .563 r
.59312 .6237 m .59735 .59411 L .59749 .60057 L p F P
0 g
s
.573 .366 .563 r
.59735 .59411 m .59312 .6237 L .59309 .62216 L p F P
0 g
s
.573 .366 .563 r
.66138 .55166 m .64659 .54907 L .64743 .57156 L p F P
0 g
s
.573 .366 .563 r
.63415 .57439 m .64743 .57156 L .64659 .54907 L p F P
0 g
s
.573 .366 .563 r
.66227 .57294 m .64743 .57156 L .64659 .54907 L p F P
0 g
s
.573 .366 .563 r
.64659 .54907 m .66138 .55166 L .66227 .57294 L p F P
0 g
s
.573 .366 .563 r
.60396 .58968 m .59772 .61105 L .59803 .62513 L p F P
0 g
s
.573 .366 .563 r
.59803 .62513 m .60438 .60724 L .60396 .58968 L p F P
0 g
s
.573 .366 .563 r
.61256 .5925 m .60438 .60724 L .60396 .58968 L p F P
0 g
s
.573 .366 .563 r
.59772 .61105 m .60396 .58968 L .60438 .60724 L p F P
0 g
s
.573 .366 .563 r
.60396 .58968 m .59772 .61105 L .59749 .60057 L p F P
0 g
s
.573 .366 .563 r
.59749 .60057 m .59321 .62825 L .59336 .63563 L p F P
0 g
s
.573 .366 .563 r
.59336 .63563 m .59772 .61105 L .59749 .60057 L p F P
0 g
s
.573 .366 .563 r
.59321 .62825 m .59749 .60057 L .59772 .61105 L p F P
0 g
s
.573 .366 .563 r
.59749 .60057 m .59321 .62825 L .59312 .6237 L p F P
0 g
s
.573 .366 .563 r
.63415 .57439 m .6225 .58143 L .6233 .60823 L p F P
0 g
s
.573 .366 .563 r
.6225 .58143 m .61256 .5925 L .61321 .61715 L p F P
0 g
s
.573 .366 .563 r
.61321 .61715 m .6233 .60823 L .6225 .58143 L p F P
0 g
s
.573 .366 .563 r
.63508 .60214 m .6233 .60823 L .6225 .58143 L p F P
0 g
s
.573 .366 .563 r
.6225 .58143 m .63415 .57439 L .63508 .60214 L p F P
0 g
s
.573 .366 .563 r
.61256 .5925 m .6225 .58143 L .6233 .60823 L p F P
0 g
s
.573 .366 .563 r
.69426 .54973 m .67647 .53342 L .67661 .53636 L p F P
0 g
s
.573 .366 .563 r
.69439 .55221 m .67661 .53636 L .67647 .53342 L p F P
0 g
s
.573 .366 .563 r
.67647 .53342 m .69426 .54973 L .69439 .55221 L p F P
0 g
s
.573 .366 .563 r
.61256 .5925 m .60438 .60724 L .60489 .62863 L p F P
0 g
s
.573 .366 .563 r
.60489 .62863 m .61321 .61715 L .61256 .5925 L p F P
0 g
s
.573 .366 .563 r
.6233 .60823 m .61321 .61715 L .61256 .5925 L p F P
0 g
s
.573 .366 .563 r
.60438 .60724 m .61256 .5925 L .61321 .61715 L p F P
0 g
s
.573 .366 .563 r
.64743 .57156 m .63415 .57439 L .63508 .60214 L p F P
0 g
s
.573 .366 .563 r
.6233 .60823 m .63508 .60214 L .63415 .57439 L p F P
0 g
s
.573 .366 .563 r
.64846 .59903 m .63508 .60214 L .63415 .57439 L p F P
0 g
s
.573 .366 .563 r
.63415 .57439 m .64743 .57156 L .64846 .59903 L p F P
0 g
s
.573 .366 .563 r
.67661 .53636 m .69439 .55221 L .69426 .54973 L p F P
0 g
s
.573 .366 .563 r
.69439 .55221 m .67661 .53636 L .67702 .54509 L p F P
0 g
s
.573 .366 .563 r
.69477 .55956 m .67702 .54509 L .67661 .53636 L p F P
0 g
s
.573 .366 .563 r
.67661 .53636 m .69439 .55221 L .69477 .55956 L p F P
0 g
s
.573 .366 .563 r
.66138 .55166 m .67768 .55927 L .67702 .54509 L p F P
0 g
s
.573 .366 .563 r
.67768 .55927 m .66138 .55166 L .66227 .57294 L p F P
0 g
s
.573 .366 .563 r
.64743 .57156 m .66227 .57294 L .66138 .55166 L p F P
0 g
s
.573 .366 .563 r
.67857 .57838 m .66227 .57294 L .66138 .55166 L p F P
0 g
s
.573 .366 .563 r
.66138 .55166 m .67768 .55927 L .67857 .57838 L p F P
0 g
s
.573 .366 .563 r
.59772 .61105 m .59336 .63563 L .59356 .64552 L p F P
0 g
s
.573 .366 .563 r
.59356 .64552 m .59803 .62513 L .59772 .61105 L p F P
0 g
s
.573 .366 .563 r
.60438 .60724 m .59803 .62513 L .59772 .61105 L p F P
0 g
s
.573 .366 .563 r
.59336 .63563 m .59772 .61105 L .59803 .62513 L p F P
0 g
s
.573 .366 .563 r
.59772 .61105 m .59336 .63563 L .59321 .62825 L p F P
0 g
s
.573 .366 .563 r
.60438 .60724 m .59803 .62513 L .59841 .64225 L p F P
0 g
s
.573 .366 .563 r
.59841 .64225 m .60489 .62863 L .60438 .60724 L p F P
0 g
s
.573 .366 .563 r
.61321 .61715 m .60489 .62863 L .60438 .60724 L p F P
0 g
s
.573 .366 .563 r
.59803 .62513 m .60438 .60724 L .60489 .62863 L p F P
0 g
s
.573 .366 .563 r
.66227 .57294 m .64743 .57156 L .64846 .59903 L p F P
0 g
s
.573 .366 .563 r
.63508 .60214 m .64846 .59903 L .64743 .57156 L p F P
0 g
s
.573 .366 .563 r
.66336 .59892 m .64846 .59903 L .64743 .57156 L p F P
0 g
s
.573 .366 .563 r
.64743 .57156 m .66227 .57294 L .66336 .59892 L p F P
0 g
s
.573 .366 .563 r
.67702 .54509 m .69477 .55956 L .69439 .55221 L p F P
0 g
s
.573 .366 .563 r
.69477 .55956 m .67702 .54509 L .67768 .55927 L p F P
0 g
s
.573 .366 .563 r
.69539 .5715 m .67768 .55927 L .67702 .54509 L p F P
0 g
s
.573 .366 .563 r
.67702 .54509 m .69477 .55956 L .69539 .5715 L p F P
0 g
s
.573 .366 .563 r
.59309 .62216 m .59079 .65544 L .59081 .65624 L p F P
0 g
s
.573 .366 .563 r
.59081 .65624 m .59312 .6237 L .59309 .62216 L p F P
0 g
s
.573 .366 .563 r
.59079 .65544 m .59309 .62216 L .59312 .6237 L p F P
0 g
s
.573 .366 .563 r
.59312 .6237 m .59081 .65624 L .59085 .65861 L p F P
0 g
s
.573 .366 .563 r
.59085 .65861 m .59321 .62825 L .59312 .6237 L p F P
0 g
s
.573 .366 .563 r
.59081 .65624 m .59312 .6237 L .59321 .62825 L p F P
0 g
s
.573 .366 .563 r
.59312 .6237 m .59081 .65624 L .59079 .65544 L p F P
0 g
s
.573 .366 .563 r
.59321 .62825 m .59085 .65861 L .59093 .66245 L p F P
0 g
s
.573 .366 .563 r
.59093 .66245 m .59336 .63563 L .59321 .62825 L p F P
0 g
s
.573 .366 .563 r
.59085 .65861 m .59321 .62825 L .59336 .63563 L p F P
0 g
s
.573 .366 .563 r
.59321 .62825 m .59085 .65861 L .59081 .65624 L p F P
0 g
s
.573 .366 .563 r
.59803 .62513 m .59356 .64552 L .59381 .6575 L p F P
0 g
s
.573 .366 .563 r
.59381 .6575 m .59841 .64225 L .59803 .62513 L p F P
0 g
s
.573 .366 .563 r
.60489 .62863 m .59841 .64225 L .59803 .62513 L p F P
0 g
s
.573 .366 .563 r
.59356 .64552 m .59803 .62513 L .59841 .64225 L p F P
0 g
s
.573 .366 .563 r
.59803 .62513 m .59356 .64552 L .59336 .63563 L p F P
0 g
s
.573 .366 .563 r
.6233 .60823 m .61321 .61715 L .61396 .64527 L p F P
0 g
s
.573 .366 .563 r
.61321 .61715 m .60489 .62863 L .60548 .65296 L p F P
0 g
s
.573 .366 .563 r
.60548 .65296 m .61396 .64527 L .61321 .61715 L p F P
0 g
s
.573 .366 .563 r
.62421 .63884 m .61396 .64527 L .61321 .61715 L p F P
0 g
s
.573 .366 .563 r
.61321 .61715 m .6233 .60823 L .62421 .63884 L p F P
0 g
s
.573 .366 .563 r
.60489 .62863 m .61321 .61715 L .61396 .64527 L p F P
0 g
s
.573 .366 .563 r
.59336 .63563 m .59093 .66245 L .59103 .66759 L p F P
0 g
s
.573 .366 .563 r
.59103 .66759 m .59356 .64552 L .59336 .63563 L p F P
0 g
s
.573 .366 .563 r
.59093 .66245 m .59336 .63563 L .59356 .64552 L p F P
0 g
s
.573 .366 .563 r
.59336 .63563 m .59093 .66245 L .59085 .65861 L p F P
0 g
s
.573 .366 .563 r
.63508 .60214 m .6233 .60823 L .62421 .63884 L p F P
0 g
s
.573 .366 .563 r
.61396 .64527 m .62421 .63884 L .6233 .60823 L p F P
0 g
s
.573 .366 .563 r
.63613 .63386 m .62421 .63884 L .6233 .60823 L p F P
0 g
s
.573 .366 .563 r
.6233 .60823 m .63508 .60214 L .63613 .63386 L p F P
0 g
s
.573 .366 .563 r
.66227 .57294 m .67857 .57838 L .67768 .55927 L p F P
0 g
s
.573 .366 .563 r
.67857 .57838 m .66227 .57294 L .66336 .59892 L p F P
0 g
s
.573 .366 .563 r
.64846 .59903 m .66336 .59892 L .66227 .57294 L p F P
0 g
s
.573 .366 .563 r
.67966 .60169 m .66336 .59892 L .66227 .57294 L p F P
0 g
s
.573 .366 .563 r
.66227 .57294 m .67857 .57838 L .67966 .60169 L p F P
0 g
s
.573 .366 .563 r
.67768 .55927 m .69539 .5715 L .69477 .55956 L p F P
0 g
s
.573 .366 .563 r
.69539 .5715 m .67768 .55927 L .67857 .57838 L p F P
0 g
s
.573 .366 .563 r
.69623 .58756 m .67857 .57838 L .67768 .55927 L p F P
0 g
s
.573 .366 .563 r
.67768 .55927 m .69539 .5715 L .69623 .58756 L p F P
0 g
s
.573 .366 .563 r
.60489 .62863 m .59841 .64225 L .59883 .66166 L p F P
0 g
s
.573 .366 .563 r
.59883 .66166 m .60548 .65296 L .60489 .62863 L p F P
0 g
s
.573 .366 .563 r
.61396 .64527 m .60548 .65296 L .60489 .62863 L p F P
0 g
s
.573 .366 .563 r
.59841 .64225 m .60489 .62863 L .60548 .65296 L p F P
0 g
s
.573 .366 .563 r
.64846 .59903 m .63508 .60214 L .63613 .63386 L p F P
0 g
s
.573 .366 .563 r
.62421 .63884 m .63613 .63386 L .63508 .60214 L p F P
0 g
s
.573 .366 .563 r
.64963 .63043 m .63613 .63386 L .63508 .60214 L p F P
0 g
s
.573 .366 .563 r
.63508 .60214 m .64846 .59903 L .64963 .63043 L p F P
0 g
s
.573 .366 .563 r
.71344 .57118 m .69426 .54973 L .69439 .55221 L p F P
0 g
s
.573 .366 .563 r
.71355 .57307 m .69439 .55221 L .69426 .54973 L p F P
0 g
s
.573 .366 .563 r
.69426 .54973 m .71344 .57118 L .71355 .57307 L p F P
0 g
s
.573 .366 .563 r
.69439 .55221 m .71355 .57307 L .71344 .57118 L p F P
0 g
s
.573 .366 .563 r
.71355 .57307 m .69439 .55221 L .69477 .55956 L p F P
0 g
s
.573 .366 .563 r
.71388 .57868 m .69477 .55956 L .69439 .55221 L p F P
0 g
s
.573 .366 .563 r
.69439 .55221 m .71355 .57307 L .71388 .57868 L p F P
0 g
s
.573 .366 .563 r
.59356 .64552 m .59103 .66759 L .59115 .67379 L p F P
0 g
s
.573 .366 .563 r
.59115 .67379 m .59381 .6575 L .59356 .64552 L p F P
0 g
s
.573 .366 .563 r
.59841 .64225 m .59381 .6575 L .59356 .64552 L p F P
0 g
s
.573 .366 .563 r
.59103 .66759 m .59356 .64552 L .59381 .6575 L p F P
0 g
s
.573 .366 .563 r
.59356 .64552 m .59103 .66759 L .59093 .66245 L p F P
0 g
s
.573 .366 .563 r
.59841 .64225 m .59381 .6575 L .59408 .67106 L p F P
0 g
s
.573 .366 .563 r
.59408 .67106 m .59883 .66166 L .59841 .64225 L p F P
0 g
s
.573 .366 .563 r
.60548 .65296 m .59883 .66166 L .59841 .64225 L p F P
0 g
s
.573 .366 .563 r
.59381 .6575 m .59841 .64225 L .59883 .66166 L p F P
0 g
s
.573 .366 .563 r
.66336 .59892 m .64846 .59903 L .64963 .63043 L p F P
0 g
s
.573 .366 .563 r
.63613 .63386 m .64963 .63043 L .64846 .59903 L p F P
0 g
s
.573 .366 .563 r
.6646 .62857 m .64963 .63043 L .64846 .59903 L p F P
0 g
s
.573 .366 .563 r
.64846 .59903 m .66336 .59892 L .6646 .62857 L p F P
0 g
s
.573 .366 .563 r
.69477 .55956 m .71388 .57868 L .71355 .57307 L p F P
0 g
s
.573 .366 .563 r
.71388 .57868 m .69477 .55956 L .69539 .5715 L p F P
0 g
s
.573 .366 .563 r
.7144 .58777 m .69539 .5715 L .69477 .55956 L p F P
0 g
s
.573 .366 .563 r
.69477 .55956 m .71388 .57868 L .7144 .58777 L p F P
0 g
s
.573 .366 .563 r
.59047 .69041 m .59081 .65624 L .59079 .65544 L closepath p F P
0 g
s
.573 .366 .563 r
.59047 .69041 m .59079 .65544 L .59081 .65624 L closepath p F P
0 g
s
.573 .366 .563 r
.59047 .69041 m .59085 .65861 L .59081 .65624 L closepath p F P
0 g
s
.573 .366 .563 r
.59047 .69041 m .59081 .65624 L .59085 .65861 L closepath p F P
0 g
s
.573 .366 .563 r
.59047 .69041 m .59093 .66245 L .59085 .65861 L closepath p F P
0 g
s
.573 .366 .563 r
.59047 .69041 m .59085 .65861 L .59093 .66245 L closepath p F P
0 g
s
.573 .366 .563 r
.67857 .57838 m .69623 .58756 L .69539 .5715 L p F P
0 g
s
.573 .366 .563 r
.69623 .58756 m .67857 .57838 L .67966 .60169 L p F P
0 g
s
.573 .366 .563 r
.66336 .59892 m .67966 .60169 L .67857 .57838 L p F P
0 g
s
.573 .366 .563 r
.69725 .6071 m .67966 .60169 L .67857 .57838 L p F P
0 g
s
.573 .366 .563 r
.67857 .57838 m .69623 .58756 L .69725 .6071 L p F P
0 g
s
.573 .366 .563 r
.59381 .6575 m .59115 .67379 L .59129 .68078 L p F P
0 g
s
.573 .366 .563 r
.59129 .68078 m .59408 .67106 L .59381 .6575 L p F P
0 g
s
.573 .366 .563 r
.59883 .66166 m .59408 .67106 L .59381 .6575 L p F P
0 g
s
.573 .366 .563 r
.59115 .67379 m .59381 .6575 L .59408 .67106 L p F P
0 g
s
.573 .366 .563 r
.59381 .6575 m .59115 .67379 L .59103 .66759 L p F P
0 g
s
.573 .366 .563 r
.59047 .69041 m .59103 .66759 L .59093 .66245 L closepath p F P
0 g
s
.573 .366 .563 r
.59047 .69041 m .59093 .66245 L .59103 .66759 L closepath p F P
0 g
s
.573 .366 .563 r
.67966 .60169 m .66336 .59892 L .6646 .62857 L p F P
0 g
s
.573 .366 .563 r
.64963 .63043 m .6646 .62857 L .66336 .59892 L p F P
0 g
s
.573 .366 .563 r
.68091 .62825 m .6646 .62857 L .66336 .59892 L p F P
0 g
s
.573 .366 .563 r
.66336 .59892 m .67966 .60169 L .68091 .62825 L p F P
0 g
s
.573 .366 .563 r
.61396 .64527 m .60548 .65296 L .6061 .67921 L p F P
0 g
s
.573 .366 .563 r
.60548 .65296 m .59883 .66166 L .59929 .68254 L p F P
0 g
s
.573 .366 .563 r
.59929 .68254 m .6061 .67921 L .60548 .65296 L p F P
0 g
s
.573 .366 .563 r
.61477 .67566 m .6061 .67921 L .60548 .65296 L p F P
0 g
s
.573 .366 .563 r
.60548 .65296 m .61396 .64527 L .61477 .67566 L p F P
0 g
s
.573 .366 .563 r
.59883 .66166 m .60548 .65296 L .6061 .67921 L p F P
0 g
s
.573 .366 .563 r
.62421 .63884 m .61396 .64527 L .61477 .67566 L p F P
0 g
s
.573 .366 .563 r
.6061 .67921 m .61477 .67566 L .61396 .64527 L p F P
0 g
s
.573 .366 .563 r
.62519 .67198 m .61477 .67566 L .61396 .64527 L p F P
0 g
s
.573 .366 .563 r
.61396 .64527 m .62421 .63884 L .62519 .67198 L p F P
0 g
s
.573 .366 .563 r
.69539 .5715 m .7144 .58777 L .71388 .57868 L p F P
0 g
s
.573 .366 .563 r
.7144 .58777 m .69539 .5715 L .69623 .58756 L p F P
0 g
s
.573 .366 .563 r
.7151 .59997 m .69623 .58756 L .69539 .5715 L p F P
0 g
s
.573 .366 .563 r
.69539 .5715 m .7144 .58777 L .7151 .59997 L p F P
0 g
s
.573 .366 .563 r
.59047 .69041 m .59115 .67379 L .59103 .66759 L closepath p F P
0 g
s
.573 .366 .563 r
.59047 .69041 m .59103 .66759 L .59115 .67379 L closepath p F P
0 g
s
.573 .366 .563 r
.59883 .66166 m .59408 .67106 L .59438 .68558 L p F P
0 g
s
.573 .366 .563 r
.59438 .68558 m .59929 .68254 L .59883 .66166 L p F P
0 g
s
.573 .366 .563 r
.6061 .67921 m .59929 .68254 L .59883 .66166 L p F P
0 g
s
.573 .366 .563 r
.59408 .67106 m .59883 .66166 L .59929 .68254 L p F P
0 g
s
.573 .366 .563 r
.63613 .63386 m .62421 .63884 L .62519 .67198 L p F P
0 g
s
.573 .366 .563 r
.61477 .67566 m .62519 .67198 L .62421 .63884 L p F P
0 g
s
.573 .366 .563 r
.63727 .66822 m .62519 .67198 L .62421 .63884 L p F P
0 g
s
.573 .366 .563 r
.62421 .63884 m .63613 .63386 L .63727 .66822 L p F P
0 g
s
.573 .366 .563 r
.59408 .67106 m .59129 .68078 L .59143 .68823 L p F P
0 g
s
.573 .366 .563 r
.59143 .68823 m .59438 .68558 L .59408 .67106 L p F P
0 g
s
.573 .366 .563 r
.59929 .68254 m .59438 .68558 L .59408 .67106 L p F P
0 g
s
.573 .366 .563 r
.59129 .68078 m .59408 .67106 L .59438 .68558 L p F P
0 g
s
.573 .366 .563 r
.59408 .67106 m .59129 .68078 L .59115 .67379 L p F P
0 g
s
.573 .366 .563 r
.59047 .69041 m .59129 .68078 L .59115 .67379 L closepath p F P
0 g
s
.573 .366 .563 r
.59047 .69041 m .59115 .67379 L .59129 .68078 L closepath p F P
0 g
s
.573 .366 .563 r
.64963 .63043 m .63613 .63386 L .63727 .66822 L p F P
0 g
s
.573 .366 .563 r
.62519 .67198 m .63727 .66822 L .63613 .63386 L p F P
0 g
s
.573 .366 .563 r
.6509 .66444 m .63727 .66822 L .63613 .63386 L p F P
0 g
s
.573 .366 .563 r
.63613 .63386 m .64963 .63043 L .6509 .66444 L p F P
0 g
s
.573 .366 .563 r
.59047 .69041 m .59143 .68823 L .59129 .68078 L closepath p F P
0 g
s
.573 .366 .563 r
.59438 .68558 m .59143 .68823 L .59129 .68078 L p F P
0 g
s
.573 .366 .563 r
.59047 .69041 m .59129 .68078 L .59143 .68823 L closepath p F P
0 g
s
.573 .366 .563 r
.67966 .60169 m .69725 .6071 L .69623 .58756 L p F P
0 g
s
.573 .366 .563 r
.69725 .6071 m .67966 .60169 L .68091 .62825 L p F P
0 g
s
.573 .366 .563 r
.6646 .62857 m .68091 .62825 L .67966 .60169 L p F P
0 g
s
.573 .366 .563 r
.6984 .62931 m .68091 .62825 L .67966 .60169 L p F P
0 g
s
.573 .366 .563 r
.67966 .60169 m .69725 .6071 L .6984 .62931 L p F P
0 g
s
.573 .366 .563 r
.73387 .59682 m .71344 .57118 L .71355 .57307 L p F P
0 g
s
.573 .366 .563 r
.73395 .59802 m .71355 .57307 L .71344 .57118 L p F P
0 g
s
.573 .366 .563 r
.71344 .57118 m .73387 .59682 L .73395 .59802 L p F P
0 g
s
.573 .366 .563 r
.69623 .58756 m .7151 .59997 L .7144 .58777 L p F P
0 g
s
.573 .366 .563 r
.7151 .59997 m .69623 .58756 L .69725 .6071 L p F P
0 g
s
.573 .366 .563 r
.71595 .61478 m .69725 .6071 L .69623 .58756 L p F P
0 g
s
.573 .366 .563 r
.69623 .58756 m .7151 .59997 L .71595 .61478 L p F P
0 g
s
.573 .366 .563 r
.6646 .62857 m .64963 .63043 L .6509 .66444 L p F P
0 g
s
.573 .366 .563 r
.63727 .66822 m .6509 .66444 L .64963 .63043 L p F P
0 g
s
.573 .366 .563 r
.66595 .66067 m .6509 .66444 L .64963 .63043 L p F P
0 g
s
.573 .366 .563 r
.64963 .63043 m .6646 .62857 L .66595 .66067 L p F P
0 g
s
.573 .366 .563 r
.71355 .57307 m .73395 .59802 L .73387 .59682 L p F P
0 g
s
.573 .366 .563 r
.73395 .59802 m .71355 .57307 L .71388 .57868 L p F P
0 g
s
.573 .366 .563 r
.73417 .60156 m .71388 .57868 L .71355 .57307 L p F P
0 g
s
.573 .366 .563 r
.71355 .57307 m .73395 .59802 L .73417 .60156 L p F P
0 g
s
.573 .366 .563 r
.59438 .68558 m .59143 .68823 L .59158 .69581 L p F P
0 g
s
.573 .366 .563 r
.59047 .69041 m .59158 .69581 L .59143 .68823 L closepath p F P
0 g
s
.573 .366 .563 r
.59468 .7004 m .59158 .69581 L .59143 .68823 L p F P
0 g
s
.573 .366 .563 r
.59143 .68823 m .59438 .68558 L .59468 .7004 L p F P
0 g
s
.573 .366 .563 r
.59047 .69041 m .59143 .68823 L .59158 .69581 L closepath p F P
0 g
s
.573 .366 .563 r
.59929 .68254 m .59438 .68558 L .59468 .7004 L p F P
0 g
s
.573 .366 .563 r
.59158 .69581 m .59468 .7004 L .59438 .68558 L p F P
0 g
s
.573 .366 .563 r
.59976 .70393 m .59468 .7004 L .59438 .68558 L p F P
0 g
s
.573 .366 .563 r
.59438 .68558 m .59929 .68254 L .59976 .70393 L p F P
0 g
s
.573 .366 .563 r
.59047 .69041 m .59172 .70315 L .59158 .69581 L closepath p F P
0 g
s
.573 .366 .563 r
.59047 .69041 m .59186 .70991 L .59172 .70315 L closepath p F P
0 g
s
.573 .366 .563 r
.59047 .69041 m .59197 .71577 L .59186 .70991 L closepath p F P
0 g
s
.573 .366 .563 r
.59047 .69041 m .59206 .72043 L .59197 .71577 L closepath p F P
0 g
s
.573 .366 .563 r
.59047 .69041 m .59212 .72367 L .59206 .72043 L closepath p F P
0 g
s
.573 .366 .563 r
.59047 .69041 m .59216 .72534 L .59212 .72367 L closepath p F P
0 g
s
.573 .366 .563 r
.59047 .69041 m .59212 .72367 L .59216 .72534 L closepath p F P
0 g
s
.573 .366 .563 r
.59047 .69041 m .59206 .72043 L .59212 .72367 L closepath p F P
0 g
s
.573 .366 .563 r
.59047 .69041 m .59197 .71577 L .59206 .72043 L closepath p F P
0 g
s
.573 .366 .563 r
.59047 .69041 m .59186 .70991 L .59197 .71577 L closepath p F P
0 g
s
.573 .366 .563 r
.59047 .69041 m .59172 .70315 L .59186 .70991 L closepath p F P
0 g
s
.573 .366 .563 r
.59047 .69041 m .59158 .69581 L .59172 .70315 L closepath p F P
0 g
s
.573 .366 .563 r
.6061 .67921 m .59929 .68254 L .59976 .70393 L p F P
0 g
s
.573 .366 .563 r
.59468 .7004 m .59976 .70393 L .59929 .68254 L p F P
0 g
s
.573 .366 .563 r
.60675 .70619 m .59976 .70393 L .59929 .68254 L p F P
0 g
s
.573 .366 .563 r
.59929 .68254 m .6061 .67921 L .60675 .70619 L p F P
0 g
s
.573 .366 .563 r
.71388 .57868 m .73417 .60156 L .73395 .59802 L p F P
0 g
s
.573 .366 .563 r
.73417 .60156 m .71388 .57868 L .7144 .58777 L p F P
0 g
s
.573 .366 .563 r
.73453 .60729 m .7144 .58777 L .71388 .57868 L p F P
0 g
s
.573 .366 .563 r
.71388 .57868 m .73417 .60156 L .73453 .60729 L p F P
0 g
s
.573 .366 .563 r
.61477 .67566 m .6061 .67921 L .60675 .70619 L p F P
0 g
s
.573 .366 .563 r
.59976 .70393 m .60675 .70619 L .6061 .67921 L p F P
0 g
s
.573 .366 .563 r
.6156 .70699 m .60675 .70619 L .6061 .67921 L p F P
0 g
s
.573 .366 .563 r
.6061 .67921 m .61477 .67566 L .6156 .70699 L p F P
0 g
s
.573 .366 .563 r
.68091 .62825 m .6646 .62857 L .66595 .66067 L p F P
0 g
s
.573 .366 .563 r
.6509 .66444 m .66595 .66067 L .6646 .62857 L p F P
0 g
s
.573 .366 .563 r
.68225 .65693 m .66595 .66067 L .6646 .62857 L p F P
0 g
s
.573 .366 .563 r
.6646 .62857 m .68091 .62825 L .68225 .65693 L p F P
0 g
s
.573 .366 .563 r
.59468 .7004 m .59158 .69581 L .59172 .70315 L p F P
0 g
s
.573 .366 .563 r
.59498 .71482 m .59172 .70315 L .59158 .69581 L p F P
0 g
s
.573 .366 .563 r
.59158 .69581 m .59468 .7004 L .59498 .71482 L p F P
0 g
s
.573 .366 .563 r
.62519 .67198 m .61477 .67566 L .6156 .70699 L p F P
0 g
s
.573 .366 .563 r
.60675 .70619 m .6156 .70699 L .61477 .67566 L p F P
0 g
s
.573 .366 .563 r
.6262 .70619 m .6156 .70699 L .61477 .67566 L p F P
0 g
s
.573 .366 .563 r
.61477 .67566 m .62519 .67198 L .6262 .70619 L p F P
0 g
s
.573 .366 .563 r
.7144 .58777 m .73453 .60729 L .73417 .60156 L p F P
0 g
s
.573 .366 .563 r
.73453 .60729 m .7144 .58777 L .7151 .59997 L p F P
0 g
s
.573 .366 .563 r
.73502 .61497 m .7151 .59997 L .7144 .58777 L p F P
0 g
s
.573 .366 .563 r
.7144 .58777 m .73453 .60729 L .73502 .61497 L p F P
0 g
s
.573 .366 .563 r
.63727 .66822 m .62519 .67198 L .6262 .70619 L p F P
0 g
s
.573 .366 .563 r
.6156 .70699 m .6262 .70619 L .62519 .67198 L p F P
0 g
s
.573 .366 .563 r
.63846 .70372 m .6262 .70619 L .62519 .67198 L p F P
0 g
s
.573 .366 .563 r
.62519 .67198 m .63727 .66822 L .63846 .70372 L p F P
0 g
s
.573 .366 .563 r
.59976 .70393 m .59468 .7004 L .59498 .71482 L p F P
0 g
s
.573 .366 .563 r
.59172 .70315 m .59498 .71482 L .59468 .7004 L p F P
0 g
s
.573 .366 .563 r
.60021 .72483 m .59498 .71482 L .59468 .7004 L p F P
0 g
s
.573 .366 .563 r
.59468 .7004 m .59976 .70393 L .60021 .72483 L p F P
0 g
s
.573 .366 .563 r
.59498 .71482 m .59172 .70315 L .59186 .70991 L p F P
0 g
s
.573 .366 .563 r
.59525 .72815 m .59186 .70991 L .59172 .70315 L p F P
0 g
s
.573 .366 .563 r
.59172 .70315 m .59498 .71482 L .59525 .72815 L p F P
0 g
s
.573 .366 .563 r
.69725 .6071 m .71595 .61478 L .7151 .59997 L p F P
0 g
s
.573 .366 .563 r
.71595 .61478 m .69725 .6071 L .6984 .62931 L p F P
0 g
s
.573 .366 .563 r
.68091 .62825 m .6984 .62931 L .69725 .6071 L p F P
0 g
s
.573 .366 .563 r
.71692 .63156 m .6984 .62931 L .69725 .6071 L p F P
0 g
s
.573 .366 .563 r
.69725 .6071 m .71595 .61478 L .71692 .63156 L p F P
0 g
s
.573 .366 .563 r
.88332 .44361 m .86934 .4498 L .8701 .45679 L p F P
0 g
s
.573 .366 .563 r
.86934 .4498 m .85479 .46339 L .85547 .47 L p F P
0 g
s
.573 .366 .563 r
.85547 .47 m .8701 .45679 L .86934 .4498 L p F P
0 g
s
.573 .366 .563 r
.88412 .45068 m .8701 .45679 L .86934 .4498 L p F P
0 g
s
.573 .366 .563 r
.86934 .4498 m .88332 .44361 L .88412 .45068 L p F P
0 g
s
.573 .366 .563 r
.85479 .46339 m .86934 .4498 L .8701 .45679 L p F P
0 g
s
.573 .366 .563 r
.85479 .46339 m .83971 .48398 L .8403 .48992 L p F P
0 g
s
.573 .366 .563 r
.8403 .48992 m .85547 .47 L .85479 .46339 L p F P
0 g
s
.573 .366 .563 r
.8701 .45679 m .85547 .47 L .85479 .46339 L p F P
0 g
s
.573 .366 .563 r
.83971 .48398 m .85479 .46339 L .85547 .47 L p F P
0 g
s
.573 .366 .563 r
.6509 .66444 m .63727 .66822 L .63846 .70372 L p F P
0 g
s
.573 .366 .563 r
.6262 .70619 m .63846 .70372 L .63727 .66822 L p F P
0 g
s
.573 .366 .563 r
.65222 .69957 m .63846 .70372 L .63727 .66822 L p F P
0 g
s
.573 .366 .563 r
.63727 .66822 m .6509 .66444 L .65222 .69957 L p F P
0 g
s
.573 .366 .563 r
.6984 .62931 m .68091 .62825 L .68225 .65693 L p F P
0 g
s
.573 .366 .563 r
.66595 .66067 m .68225 .65693 L .68091 .62825 L p F P
0 g
s
.573 .366 .563 r
.69965 .65323 m .68225 .65693 L .68091 .62825 L p F P
0 g
s
.573 .366 .563 r
.68091 .62825 m .6984 .62931 L .69965 .65323 L p F P
0 g
s
.573 .366 .563 r
.59186 .70991 m .59525 .72815 L .59498 .71482 L p F P
0 g
s
.573 .366 .563 r
.59525 .72815 m .59186 .70991 L .59197 .71577 L p F P
0 g
s
.573 .366 .563 r
.59549 .73974 m .59197 .71577 L .59186 .70991 L p F P
0 g
s
.573 .366 .563 r
.59186 .70991 m .59525 .72815 L .59549 .73974 L p F P
0 g
s
.573 .366 .563 r
.89664 .44495 m .88332 .44361 L .88412 .45068 L p F P
0 g
s
.573 .366 .563 r
.8701 .45679 m .88412 .45068 L .88332 .44361 L p F P
0 g
s
.573 .366 .563 r
.89745 .45181 m .88412 .45068 L .88332 .44361 L p F P
0 g
s
.573 .366 .563 r
.88332 .44361 m .89664 .44495 L .89745 .45181 L p F P
0 g
s
.573 .366 .563 r
.85547 .47 m .8403 .48992 L .83971 .48398 L p F P
0 g
s
.573 .366 .563 r
.82415 .51094 m .83971 .48398 L .8403 .48992 L p F P
0 g
s
.573 .366 .563 r
.83971 .48398 m .82415 .51094 L .82461 .51593 L p F P
0 g
s
.573 .366 .563 r
.82461 .51593 m .8403 .48992 L .83971 .48398 L p F P
0 g
s
.573 .366 .563 r
.60675 .70619 m .59976 .70393 L .60021 .72483 L p F P
0 g
s
.573 .366 .563 r
.59498 .71482 m .60021 .72483 L .59976 .70393 L p F P
0 g
s
.573 .366 .563 r
.60738 .73263 m .60021 .72483 L .59976 .70393 L p F P
0 g
s
.573 .366 .563 r
.59976 .70393 m .60675 .70619 L .60738 .73263 L p F P
0 g
s
.573 .366 .563 r
.8701 .45679 m .85547 .47 L .85683 .48299 L p F P
0 g
s
.573 .366 .563 r
.85547 .47 m .8403 .48992 L .84145 .50158 L p F P
0 g
s
.573 .366 .563 r
.84145 .50158 m .85683 .48299 L .85547 .47 L p F P
0 g
s
.573 .366 .563 r
.87161 .47054 m .85683 .48299 L .85547 .47 L p F P
0 g
s
.573 .366 .563 r
.85547 .47 m .8701 .45679 L .87161 .47054 L p F P
0 g
s
.573 .366 .563 r
.8403 .48992 m .85547 .47 L .85683 .48299 L p F P
0 g
s
.573 .366 .563 r
.88412 .45068 m .8701 .45679 L .87161 .47054 L p F P
0 g
s
.573 .366 .563 r
.85683 .48299 m .87161 .47054 L .8701 .45679 L p F P
0 g
s
.573 .366 .563 r
.88571 .4646 m .87161 .47054 L .8701 .45679 L p F P
0 g
s
.573 .366 .563 r
.8701 .45679 m .88412 .45068 L .88571 .4646 L p F P
0 g
s
.573 .366 .563 r
.7151 .59997 m .73502 .61497 L .73453 .60729 L p F P
0 g
s
.573 .366 .563 r
.73502 .61497 m .7151 .59997 L .71595 .61478 L p F P
0 g
s
.573 .366 .563 r
.73561 .62425 m .71595 .61478 L .7151 .59997 L p F P
0 g
s
.573 .366 .563 r
.7151 .59997 m .73502 .61497 L .73561 .62425 L p F P
0 g
s
.573 .366 .563 r
.59197 .71577 m .59549 .73974 L .59525 .72815 L p F P
0 g
s
.573 .366 .563 r
.59549 .73974 m .59197 .71577 L .59206 .72043 L p F P
0 g
s
.573 .366 .563 r
.59568 .749 m .59206 .72043 L .59197 .71577 L p F P
0 g
s
.573 .366 .563 r
.59197 .71577 m .59549 .73974 L .59568 .749 L p F P
0 g
s
.573 .366 .563 r
.8403 .48992 m .82461 .51593 L .82552 .52573 L p F P
0 g
s
.573 .366 .563 r
.82552 .52573 m .84145 .50158 L .8403 .48992 L p F P
0 g
s
.573 .366 .563 r
.85683 .48299 m .84145 .50158 L .8403 .48992 L p F P
0 g
s
.573 .366 .563 r
.82461 .51593 m .8403 .48992 L .84145 .50158 L p F P
0 g
s
.573 .366 .563 r
.8403 .48992 m .82461 .51593 L .82415 .51094 L p F P
0 g
s
.573 .366 .563 r
.60021 .72483 m .59498 .71482 L .59525 .72815 L p F P
0 g
s
.573 .366 .563 r
.60064 .74422 m .59525 .72815 L .59498 .71482 L p F P
0 g
s
.573 .366 .563 r
.59498 .71482 m .60021 .72483 L .60064 .74422 L p F P
0 g
s
.573 .366 .563 r
.88412 .45068 m .89745 .45181 L .89664 .44495 L p F P
0 g
s
.573 .366 .563 r
.89745 .45181 m .88412 .45068 L .88571 .4646 L p F P
0 g
s
.573 .366 .563 r
.87161 .47054 m .88571 .4646 L .88412 .45068 L p F P
0 g
s
.573 .366 .563 r
.89904 .46529 m .88571 .4646 L .88412 .45068 L p F P
0 g
s
.573 .366 .563 r
.88412 .45068 m .89745 .45181 L .89904 .46529 L p F P
0 g
s
.573 .366 .563 r
.66595 .66067 m .6509 .66444 L .65222 .69957 L p F P
0 g
s
.573 .366 .563 r
.63846 .70372 m .65222 .69957 L .6509 .66444 L p F P
0 g
s
.573 .366 .563 r
.66733 .69377 m .65222 .69957 L .6509 .66444 L p F P
0 g
s
.573 .366 .563 r
.6509 .66444 m .66595 .66067 L .66733 .69377 L p F P
0 g
s
.573 .366 .563 r
.6156 .70699 m .60675 .70619 L .60738 .73263 L p F P
0 g
s
.573 .366 .563 r
.60021 .72483 m .60738 .73263 L .60675 .70619 L p F P
0 g
s
.573 .366 .563 r
.61641 .73777 m .60738 .73263 L .60675 .70619 L p F P
0 g
s
.573 .366 .563 r
.60675 .70619 m .6156 .70699 L .61641 .73777 L p F P
0 g
s
.573 .366 .563 r
.59206 .72043 m .59568 .749 L .59549 .73974 L p F P
0 g
s
.573 .366 .563 r
.59568 .749 m .59206 .72043 L .59212 .72367 L p F P
0 g
s
.573 .366 .563 r
.59581 .75545 m .59212 .72367 L .59206 .72043 L p F P
0 g
s
.573 .366 .563 r
.59206 .72043 m .59568 .749 L .59581 .75545 L p F P
0 g
s
.573 .366 .563 r
.82415 .51094 m .80813 .54338 L .80846 .54718 L p F P
0 g
s
.573 .366 .563 r
.80846 .54718 m .82461 .51593 L .82415 .51094 L p F P
0 g
s
.573 .366 .563 r
.80813 .54338 m .82415 .51094 L .82461 .51593 L p F P
0 g
s
.573 .366 .563 r
.59212 .72367 m .59581 .75545 L .59568 .749 L p F P
0 g
s
.573 .366 .563 r
.59581 .75545 m .59212 .72367 L .59216 .72534 L p F P
0 g
s
.573 .366 .563 r
.59588 .75876 m .59216 .72534 L .59212 .72367 L p F P
0 g
s
.573 .366 .563 r
.59212 .72367 m .59581 .75545 L .59588 .75876 L p F P
0 g
s
.573 .366 .563 r
.90919 .45372 m .89664 .44495 L .89745 .45181 L p F P
0 g
s
.573 .366 .563 r
.90997 .46006 m .89745 .45181 L .89664 .44495 L p F P
0 g
s
.573 .366 .563 r
.89664 .44495 m .90919 .45372 L .90997 .46006 L p F P
0 g
s
.573 .366 .563 r
.59216 .72534 m .59588 .75876 L .59581 .75545 L p F P
0 g
s
.573 .366 .563 r
.87161 .47054 m .85683 .48299 L .8588 .50191 L p F P
0 g
s
.573 .366 .563 r
.85683 .48299 m .84145 .50158 L .84312 .51854 L p F P
0 g
s
.573 .366 .563 r
.84312 .51854 m .8588 .50191 L .85683 .48299 L p F P
0 g
s
.573 .366 .563 r
.8738 .49057 m .8588 .50191 L .85683 .48299 L p F P
0 g
s
.573 .366 .563 r
.85683 .48299 m .87161 .47054 L .8738 .49057 L p F P
0 g
s
.573 .366 .563 r
.84145 .50158 m .85683 .48299 L .8588 .50191 L p F P
0 g
s
.573 .366 .563 r
.88571 .4646 m .87161 .47054 L .8738 .49057 L p F P
0 g
s
.573 .366 .563 r
.8588 .50191 m .8738 .49057 L .87161 .47054 L p F P
0 g
s
.573 .366 .563 r
.88802 .48487 m .8738 .49057 L .87161 .47054 L p F P
0 g
s
.573 .366 .563 r
.87161 .47054 m .88571 .4646 L .88802 .48487 L p F P
0 g
s
.573 .366 .563 r
.6984 .62931 m .71692 .63156 L .71595 .61478 L p F P
0 g
s
.573 .366 .563 r
.71692 .63156 m .6984 .62931 L .69965 .65323 L p F P
0 g
s
.573 .366 .563 r
.68225 .65693 m .69965 .65323 L .6984 .62931 L p F P
0 g
s
.573 .366 .563 r
.71796 .64958 m .69965 .65323 L .6984 .62931 L p F P
0 g
s
.573 .366 .563 r
.6984 .62931 m .71692 .63156 L .71796 .64958 L p F P
0 g
s
.573 .366 .563 r
.75534 .62548 m .73387 .59682 L .73395 .59802 L p F P
0 g
s
.573 .366 .563 r
.75537 .6259 m .73395 .59802 L .73387 .59682 L p F P
0 g
s
.573 .366 .563 r
.73387 .59682 m .75534 .62548 L .75537 .6259 L p F P
0 g
s
.573 .366 .563 r
.73395 .59802 m .75537 .6259 L .75534 .62548 L p F P
0 g
s
.573 .366 .563 r
.75537 .6259 m .73395 .59802 L .73417 .60156 L p F P
0 g
s
.573 .366 .563 r
.75545 .62712 m .73417 .60156 L .73395 .59802 L p F P
0 g
s
.573 .366 .563 r
.73395 .59802 m .75537 .6259 L .75545 .62712 L p F P
0 g
s
.573 .366 .563 r
.71595 .61478 m .73561 .62425 L .73502 .61497 L p F P
0 g
s
.573 .366 .563 r
.73561 .62425 m .71595 .61478 L .71692 .63156 L p F P
0 g
s
.573 .366 .563 r
.73627 .63474 m .71692 .63156 L .71595 .61478 L p F P
0 g
s
.573 .366 .563 r
.71595 .61478 m .73561 .62425 L .73627 .63474 L p F P
0 g
s
.573 .366 .563 r
.68225 .65693 m .66595 .66067 L .66733 .69377 L p F P
0 g
s
.573 .366 .563 r
.65222 .69957 m .66733 .69377 L .66595 .66067 L p F P
0 g
s
.573 .366 .563 r
.68363 .68646 m .66733 .69377 L .66595 .66067 L p F P
0 g
s
.573 .366 .563 r
.66595 .66067 m .68225 .65693 L .68363 .68646 L p F P
0 g
s
.573 .366 .563 r
.6262 .70619 m .6156 .70699 L .61641 .73777 L p F P
0 g
s
.573 .366 .563 r
.60738 .73263 m .61641 .73777 L .6156 .70699 L p F P
0 g
s
.573 .366 .563 r
.6272 .73987 m .61641 .73777 L .6156 .70699 L p F P
0 g
s
.573 .366 .563 r
.6156 .70699 m .6262 .70619 L .6272 .73987 L p F P
0 g
s
.938 .685 .528 r
.26505 .47894 m .26594 .47823 L .2809 .51727 L p F P
0 g
s
.938 .685 .528 r
.2809 .51727 m .27986 .51757 L .26505 .47894 L p F P
0 g
s
.938 .685 .528 r
.27778 .51814 m .2809 .51727 L .26594 .47823 L p F P
0 g
s
.938 .685 .528 r
.27986 .51757 m .2809 .51727 L .2917 .55747 L p F P
0 g
s
.938 .685 .528 r
.2809 .51727 m .27778 .51814 L .28822 .55704 L p F P
0 g
s
.938 .685 .528 r
.28822 .55704 m .2917 .55747 L .2809 .51727 L p F P
0 g
s
.573 .366 .563 r
.82461 .51593 m .80846 .54718 L .80911 .55463 L p F P
0 g
s
.573 .366 .563 r
.80911 .55463 m .82552 .52573 L .82461 .51593 L p F P
0 g
s
.573 .366 .563 r
.84145 .50158 m .82552 .52573 L .82461 .51593 L p F P
0 g
s
.573 .366 .563 r
.80846 .54718 m .82461 .51593 L .82552 .52573 L p F P
0 g
s
.573 .366 .563 r
.82461 .51593 m .80846 .54718 L .80813 .54338 L p F P
0 g
s
.573 .366 .563 r
.84145 .50158 m .82552 .52573 L .82685 .53995 L p F P
0 g
s
.573 .366 .563 r
.82685 .53995 m .84312 .51854 L .84145 .50158 L p F P
0 g
s
.573 .366 .563 r
.8588 .50191 m .84312 .51854 L .84145 .50158 L p F P
0 g
s
.573 .366 .563 r
.82552 .52573 m .84145 .50158 L .84312 .51854 L p F P
0 g
s
.938 .685 .528 r
.27101 .49903 m .27391 .49752 L .28685 .53732 L p F P
0 g
s
.938 .685 .528 r
.28685 .53732 m .28353 .53754 L .27101 .49903 L p F P
0 g
s
.938 .685 .528 r
.28574 .53739 m .28685 .53732 L .27391 .49752 L p F P
0 g
s
.938 .685 .528 r
.28353 .53754 m .28685 .53732 L .2954 .57755 L p F P
0 g
s
.938 .685 .528 r
.28685 .53732 m .28574 .53739 L .2942 .57718 L p F P
0 g
s
.938 .685 .528 r
.2942 .57718 m .2954 .57755 L .28685 .53732 L p F P
0 g
s
.938 .685 .528 r
.2547 .46233 m .25705 .45958 L .27391 .49752 L p F P
0 g
s
.938 .685 .528 r
.27391 .49752 m .27101 .49903 L .2547 .46233 L p F P
0 g
s
.938 .685 .528 r
.27294 .49802 m .27391 .49752 L .25705 .45958 L p F P
0 g
s
.938 .685 .528 r
.27391 .49752 m .27294 .49802 L .28574 .53739 L p F P
0 g
s
.573 .366 .563 r
.59525 .72815 m .60064 .74422 L .60021 .72483 L p F P
0 g
s
.573 .366 .563 r
.60064 .74422 m .59525 .72815 L .59549 .73974 L p F P
0 g
s
.573 .366 .563 r
.60101 .76112 m .59549 .73974 L .59525 .72815 L p F P
0 g
s
.573 .366 .563 r
.59525 .72815 m .60064 .74422 L .60101 .76112 L p F P
0 g
s
.573 .366 .563 r
.89745 .45181 m .90997 .46006 L .90919 .45372 L p F P
0 g
s
.573 .366 .563 r
.90997 .46006 m .89745 .45181 L .89904 .46529 L p F P
0 g
s
.573 .366 .563 r
.88571 .4646 m .89904 .46529 L .89745 .45181 L p F P
0 g
s
.573 .366 .563 r
.91148 .47252 m .89904 .46529 L .89745 .45181 L p F P
0 g
s
.573 .366 .563 r
.89745 .45181 m .90997 .46006 L .91148 .47252 L p F P
0 g
s
.573 .366 .563 r
.73417 .60156 m .75545 .62712 L .75537 .6259 L p F P
0 g
s
.573 .366 .563 r
.75545 .62712 m .73417 .60156 L .73453 .60729 L p F P
0 g
s
.573 .366 .563 r
.75559 .6291 m .73453 .60729 L .73417 .60156 L p F P
0 g
s
.573 .366 .563 r
.73417 .60156 m .75545 .62712 L .75559 .6291 L p F P
0 g
s
.938 .685 .528 r
.26068 .48249 m .26505 .47894 L .27986 .51757 L p F P
0 g
s
.938 .685 .528 r
.27986 .51757 m .27468 .51901 L .26068 .48249 L p F P
0 g
s
.938 .685 .528 r
.27468 .51901 m .27986 .51757 L .29054 .55733 L p F P
0 g
s
.938 .685 .528 r
.2917 .55747 m .29054 .55733 L .27986 .51757 L p F P
0 g
s
.573 .366 .563 r
.60738 .73263 m .60021 .72483 L .60064 .74422 L p F P
0 g
s
.573 .366 .563 r
.60797 .75725 m .60064 .74422 L .60021 .72483 L p F P
0 g
s
.573 .366 .563 r
.60021 .72483 m .60738 .73263 L .60797 .75725 L p F P
0 g
s
.938 .685 .528 r
.28024 .53776 m .28574 .53739 L .27294 .49802 L p F P
0 g
s
.938 .685 .528 r
.28574 .53739 m .28024 .53776 L .28822 .57537 L p F P
0 g
s
.938 .685 .528 r
.28822 .57537 m .2942 .57718 L .28574 .53739 L p F P
0 g
s
.573 .366 .563 r
.89904 .46529 m .88571 .4646 L .88802 .48487 L p F P
0 g
s
.573 .366 .563 r
.8738 .49057 m .88802 .48487 L .88571 .4646 L p F P
0 g
s
.573 .366 .563 r
.90136 .48492 m .88802 .48487 L .88571 .4646 L p F P
0 g
s
.573 .366 .563 r
.88571 .4646 m .89904 .46529 L .90136 .48492 L p F P
0 g
s
.938 .685 .528 r
.25705 .45958 m .25627 .4605 L .27294 .49802 L p F P
0 g
s
.938 .685 .528 r
.26814 .50053 m .27294 .49802 L .25627 .4605 L p F P
0 g
s
.938 .685 .528 r
.27294 .49802 m .26814 .50053 L .28024 .53776 L p F P
0 g
s
.938 .685 .528 r
.29054 .55733 m .2917 .55747 L .29792 .59736 L p F P
0 g
s
.938 .685 .528 r
.2917 .55747 m .28822 .55704 L .29423 .59562 L p F P
0 g
s
.938 .685 .528 r
.29423 .59562 m .29792 .59736 L .2917 .55747 L p F P
0 g
s
.938 .685 .528 r
.24665 .44287 m .24733 .44176 L .26594 .47823 L p F P
0 g
s
.938 .685 .528 r
.26594 .47823 m .26505 .47894 L .24665 .44287 L p F P
0 g
s
.938 .685 .528 r
.2633 .48037 m .26594 .47823 L .24733 .44176 L p F P
0 g
s
.938 .685 .528 r
.26594 .47823 m .2633 .48037 L .27778 .51814 L p F P
0 g
s
.573 .366 .563 r
.63846 .70372 m .6262 .70619 L .6272 .73987 L p F P
0 g
s
.573 .366 .563 r
.61641 .73777 m .6272 .73987 L .6262 .70619 L p F P
0 g
s
.573 .366 .563 r
.63962 .7387 m .6272 .73987 L .6262 .70619 L p F P
0 g
s
.573 .366 .563 r
.6262 .70619 m .63846 .70372 L .63962 .7387 L p F P
0 g
s
.938 .685 .528 r
.29054 .55733 m .28477 .5566 L .27468 .51901 L p F P
0 g
s
.938 .685 .528 r
.28477 .5566 m .29054 .55733 L .29669 .59678 L p F P
0 g
s
.938 .685 .528 r
.29792 .59736 m .29669 .59678 L .29054 .55733 L p F P
0 g
s
.573 .366 .563 r
.73453 .60729 m .75559 .6291 L .75545 .62712 L p F P
0 g
s
.573 .366 .563 r
.75559 .6291 m .73453 .60729 L .73502 .61497 L p F P
0 g
s
.573 .366 .563 r
.75577 .63174 m .73502 .61497 L .73453 .60729 L p F P
0 g
s
.573 .366 .563 r
.73453 .60729 m .75559 .6291 L .75577 .63174 L p F P
0 g
s
.938 .685 .528 r
.27058 .52015 m .27778 .51814 L .2633 .48037 L p F P
0 g
s
.938 .685 .528 r
.27778 .51814 m .27058 .52015 L .28021 .55603 L p F P
0 g
s
.938 .685 .528 r
.28021 .55603 m .28822 .55704 L .27778 .51814 L p F P
0 g
s
.938 .685 .528 r
.24326 .44842 m .24665 .44287 L .26505 .47894 L p F P
0 g
s
.938 .685 .528 r
.26505 .47894 m .26068 .48249 L .24326 .44842 L p F P
0 g
s
.938 .685 .528 r
.26434 .50252 m .27101 .49903 L .28353 .53754 L p F P
0 g
s
.938 .685 .528 r
.28353 .53754 m .27589 .53805 L .26434 .50252 L p F P
0 g
s
.938 .685 .528 r
.27589 .53805 m .28353 .53754 L .2918 .57645 L p F P
0 g
s
.938 .685 .528 r
.2954 .57755 m .2918 .57645 L .28353 .53754 L p F P
0 g
s
.573 .366 .563 r
.69965 .65323 m .68225 .65693 L .68363 .68646 L p F P
0 g
s
.573 .366 .563 r
.66733 .69377 m .68363 .68646 L .68225 .65693 L p F P
0 g
s
.573 .366 .563 r
.70092 .67779 m .68363 .68646 L .68225 .65693 L p F P
0 g
s
.573 .366 .563 r
.68225 .65693 m .69965 .65323 L .70092 .67779 L p F P
0 g
s
.573 .366 .563 r
.82552 .52573 m .80911 .55463 L .81005 .56542 L p F P
0 g
s
.573 .366 .563 r
.81005 .56542 m .82685 .53995 L .82552 .52573 L p F P
0 g
s
.573 .366 .563 r
.84312 .51854 m .82685 .53995 L .82552 .52573 L p F P
0 g
s
.573 .366 .563 r
.80911 .55463 m .82552 .52573 L .82685 .53995 L p F P
0 g
s
.573 .366 .563 r
.82552 .52573 m .80911 .55463 L .80846 .54718 L p F P
0 g
s
.938 .685 .528 r
.24927 .46869 m .2547 .46233 L .27101 .49903 L p F P
0 g
s
.938 .685 .528 r
.27101 .49903 m .26434 .50252 L .24927 .46869 L p F P
0 g
s
.573 .366 .563 r
.7917 .58018 m .80813 .54338 L .80846 .54718 L p F P
0 g
s
.573 .366 .563 r
.80813 .54338 m .7917 .58018 L .79189 .58258 L p F P
0 g
s
.573 .366 .563 r
.79189 .58258 m .80846 .54718 L .80813 .54338 L p F P
0 g
s
.938 .685 .528 r
.2918 .57645 m .2954 .57755 L .29922 .61672 L p F P
0 g
s
.938 .685 .528 r
.2954 .57755 m .2942 .57718 L .29797 .61592 L p F P
0 g
s
.938 .685 .528 r
.29797 .61592 m .29922 .61672 L .2954 .57755 L p F P
0 g
s
.573 .366 .563 r
.59549 .73974 m .60101 .76112 L .60064 .74422 L p F P
0 g
s
.573 .366 .563 r
.60101 .76112 m .59549 .73974 L .59568 .749 L p F P
0 g
s
.573 .366 .563 r
.6013 .77466 m .59568 .749 L .59549 .73974 L p F P
0 g
s
.573 .366 .563 r
.59549 .73974 m .60101 .76112 L .6013 .77466 L p F P
0 g
s
.938 .685 .528 r
.23515 .42883 m .23686 .42492 L .25705 .45958 L p F P
0 g
s
.938 .685 .528 r
.25705 .45958 m .2547 .46233 L .23515 .42883 L p F P
0 g
s
.938 .685 .528 r
.25627 .4605 m .25705 .45958 L .23686 .42492 L p F P
0 g
s
.938 .685 .528 r
.28822 .55704 m .28021 .55603 L .28571 .5916 L p F P
0 g
s
.938 .685 .528 r
.28571 .5916 m .29423 .59562 L .28822 .55704 L p F P
0 g
s
.573 .366 .563 r
.92084 .46955 m .90919 .45372 L .90997 .46006 L p F P
0 g
s
.573 .366 .563 r
.92153 .47509 m .90997 .46006 L .90919 .45372 L p F P
0 g
s
.573 .366 .563 r
.90919 .45372 m .92084 .46955 L .92153 .47509 L p F P
0 g
s
.938 .685 .528 r
.24733 .44176 m .24529 .4451 L .2633 .48037 L p F P
0 g
s
.938 .685 .528 r
.25721 .48531 m .2633 .48037 L .24529 .4451 L p F P
0 g
s
.938 .685 .528 r
.2633 .48037 m .25721 .48531 L .27058 .52015 L p F P
0 g
s
.938 .685 .528 r
.2942 .57718 m .28822 .57537 L .29175 .61197 L p F P
0 g
s
.938 .685 .528 r
.29175 .61197 m .29797 .61592 L .2942 .57718 L p F P
0 g
s
.573 .366 .563 r
.80846 .54718 m .79189 .58258 L .79227 .58726 L p F P
0 g
s
.573 .366 .563 r
.79227 .58726 m .80911 .55463 L .80846 .54718 L p F P
0 g
s
.573 .366 .563 r
.79189 .58258 m .80846 .54718 L .80911 .55463 L p F P
0 g
s
.573 .366 .563 r
.80846 .54718 m .79189 .58258 L .7917 .58018 L p F P
0 g
s
.573 .366 .563 r
.73502 .61497 m .75577 .63174 L .75559 .6291 L p F P
0 g
s
.573 .366 .563 r
.75577 .63174 m .73502 .61497 L .73561 .62425 L p F P
0 g
s
.573 .366 .563 r
.75599 .63493 m .73561 .62425 L .73502 .61497 L p F P
0 g
s
.573 .366 .563 r
.73502 .61497 m .75577 .63174 L .75599 .63493 L p F P
0 g
s
.573 .366 .563 r
.71692 .63156 m .73627 .63474 L .73561 .62425 L p F P
0 g
s
.573 .366 .563 r
.73627 .63474 m .71692 .63156 L .71796 .64958 L p F P
0 g
s
.573 .366 .563 r
.69965 .65323 m .71796 .64958 L .71692 .63156 L p F P
0 g
s
.573 .366 .563 r
.73698 .64595 m .71796 .64958 L .71692 .63156 L p F P
0 g
s
.573 .366 .563 r
.71692 .63156 m .73627 .63474 L .73698 .64595 L p F P
0 g
s
.573 .366 .563 r
.65222 .69957 m .63846 .70372 L .63962 .7387 L p F P
0 g
s
.573 .366 .563 r
.6272 .73987 m .63962 .7387 L .63846 .70372 L p F P
0 g
s
.573 .366 .563 r
.65351 .73417 m .63962 .7387 L .63846 .70372 L p F P
0 g
s
.573 .366 .563 r
.63846 .70372 m .65222 .69957 L .65351 .73417 L p F P
0 g
s
.573 .366 .563 r
.8738 .49057 m .8588 .50191 L .86132 .52605 L p F P
0 g
s
.573 .366 .563 r
.8588 .50191 m .84312 .51854 L .84526 .54016 L p F P
0 g
s
.573 .366 .563 r
.84526 .54016 m .86132 .52605 L .8588 .50191 L p F P
0 g
s
.573 .366 .563 r
.87659 .51616 m .86132 .52605 L .8588 .50191 L p F P
0 g
s
.573 .366 .563 r
.8588 .50191 m .8738 .49057 L .87659 .51616 L p F P
0 g
s
.573 .366 .563 r
.84312 .51854 m .8588 .50191 L .86132 .52605 L p F P
0 g
s
.938 .685 .528 r
.23686 .42492 m .23629 .42623 L .25627 .4605 L p F P
0 g
s
.938 .685 .528 r
.25236 .46507 m .25627 .4605 L .23629 .42623 L p F P
0 g
s
.938 .685 .528 r
.25627 .4605 m .25236 .46507 L .26814 .50053 L p F P
0 g
s
.573 .366 .563 r
.89904 .46529 m .91148 .47252 L .90997 .46006 L p F P
0 g
s
.573 .366 .563 r
.91148 .47252 m .89904 .46529 L .90136 .48492 L p F P
0 g
s
.573 .366 .563 r
.88802 .48487 m .90136 .48492 L .89904 .46529 L p F P
0 g
s
.573 .366 .563 r
.91369 .49065 m .90136 .48492 L .89904 .46529 L p F P
0 g
s
.573 .366 .563 r
.89904 .46529 m .91148 .47252 L .91369 .49065 L p F P
0 g
s
.573 .366 .563 r
.61641 .73777 m .60738 .73263 L .60797 .75725 L p F P
0 g
s
.573 .366 .563 r
.60064 .74422 m .60797 .75725 L .60738 .73263 L p F P
0 g
s
.573 .366 .563 r
.61718 .76648 m .60797 .75725 L .60738 .73263 L p F P
0 g
s
.573 .366 .563 r
.60738 .73263 m .61641 .73777 L .61718 .76648 L p F P
0 g
s
.938 .685 .528 r
.25292 .48879 m .26068 .48249 L .27468 .51901 L p F P
0 g
s
.938 .685 .528 r
.27468 .51901 m .26551 .52157 L .25292 .48879 L p F P
0 g
s
.938 .685 .528 r
.26551 .52157 m .27468 .51901 L .28477 .5566 L p F P
0 g
s
.573 .366 .563 r
.84312 .51854 m .82685 .53995 L .82853 .55805 L p F P
0 g
s
.573 .366 .563 r
.82853 .55805 m .84526 .54016 L .84312 .51854 L p F P
0 g
s
.573 .366 .563 r
.86132 .52605 m .84526 .54016 L .84312 .51854 L p F P
0 g
s
.573 .366 .563 r
.82685 .53995 m .84312 .51854 L .84526 .54016 L p F P
0 g
s
.938 .685 .528 r
.2705 .5384 m .28024 .53776 L .26814 .50053 L p F P
0 g
s
.938 .685 .528 r
.28024 .53776 m .2705 .5384 L .27764 .57217 L p F P
0 g
s
.938 .685 .528 r
.27764 .57217 m .28822 .57537 L .28024 .53776 L p F P
0 g
s
.573 .366 .563 r
.88802 .48487 m .8738 .49057 L .87659 .51616 L p F P
0 g
s
.573 .366 .563 r
.86132 .52605 m .87659 .51616 L .8738 .49057 L p F P
0 g
s
.573 .366 .563 r
.89097 .51077 m .87659 .51616 L .8738 .49057 L p F P
0 g
s
.573 .366 .563 r
.8738 .49057 m .88802 .48487 L .89097 .51077 L p F P
0 g
s
.938 .685 .528 r
.25963 .50498 m .26814 .50053 L .25236 .46507 L p F P
0 g
s
.938 .685 .528 r
.26814 .50053 m .25963 .50498 L .2705 .5384 L p F P
0 g
s
.938 .685 .528 r
.2918 .57645 m .28349 .57394 L .27589 .53805 L p F P
0 g
s
.938 .685 .528 r
.28349 .57394 m .2918 .57645 L .29547 .61434 L p F P
0 g
s
.938 .685 .528 r
.29922 .61672 m .29547 .61434 L .2918 .57645 L p F P
0 g
s
.573 .366 .563 r
.90997 .46006 m .92153 .47509 L .92084 .46955 L p F P
0 g
s
.573 .366 .563 r
.92153 .47509 m .90997 .46006 L .91148 .47252 L p F P
0 g
s
.573 .366 .563 r
.92289 .48596 m .91148 .47252 L .90997 .46006 L p F P
0 g
s
.573 .366 .563 r
.90997 .46006 m .92153 .47509 L .92289 .48596 L p F P
0 g
s
.573 .366 .563 r
.71796 .64958 m .69965 .65323 L .70092 .67779 L p F P
0 g
s
.573 .366 .563 r
.68363 .68646 m .70092 .67779 L .69965 .65323 L p F P
0 g
s
.573 .366 .563 r
.71902 .668 m .70092 .67779 L .69965 .65323 L p F P
0 g
s
.573 .366 .563 r
.69965 .65323 m .71796 .64958 L .71902 .668 L p F P
0 g
s
.573 .366 .563 r
.60797 .75725 m .60064 .74422 L .60101 .76112 L p F P
0 g
s
.573 .366 .563 r
.60849 .77876 m .60101 .76112 L .60064 .74422 L p F P
0 g
s
.573 .366 .563 r
.60064 .74422 m .60797 .75725 L .60849 .77876 L p F P
0 g
s
.573 .366 .563 r
.59568 .749 m .6013 .77466 L .60101 .76112 L p F P
0 g
s
.573 .366 .563 r
.6013 .77466 m .59568 .749 L .59581 .75545 L p F P
0 g
s
.573 .366 .563 r
.60151 .78412 m .59581 .75545 L .59568 .749 L p F P
0 g
s
.573 .366 .563 r
.59568 .749 m .6013 .77466 L .60151 .78412 L p F P
0 g
s
.938 .685 .528 r
.23122 .43785 m .23515 .42883 L .2547 .46233 L p F P
0 g
s
.938 .685 .528 r
.2547 .46233 m .24927 .46869 L .23122 .43785 L p F P
0 g
s
.938 .685 .528 r
.29669 .59678 m .29792 .59736 L .29927 .63545 L p F P
0 g
s
.938 .685 .528 r
.29792 .59736 m .29423 .59562 L .2955 .63244 L p F P
0 g
s
.938 .685 .528 r
.2955 .63244 m .29927 .63545 L .29792 .59736 L p F P
0 g
s
.938 .685 .528 r
.28477 .5566 m .27456 .55532 L .26551 .52157 L p F P
0 g
s
.938 .685 .528 r
.27456 .55532 m .28477 .5566 L .29056 .59389 L p F P
0 g
s
.938 .685 .528 r
.29669 .59678 m .29056 .59389 L .28477 .5566 L p F P
0 g
s
.573 .366 .563 r
.80911 .55463 m .79227 .58726 L .79283 .59404 L p F P
0 g
s
.573 .366 .563 r
.79283 .59404 m .81005 .56542 L .80911 .55463 L p F P
0 g
s
.573 .366 .563 r
.82685 .53995 m .81005 .56542 L .80911 .55463 L p F P
0 g
s
.573 .366 .563 r
.79227 .58726 m .80911 .55463 L .81005 .56542 L p F P
0 g
s
.573 .366 .563 r
.80911 .55463 m .79227 .58726 L .79189 .58258 L p F P
0 g
s
.938 .685 .528 r
.23726 .45825 m .24326 .44842 L .26068 .48249 L p F P
0 g
s
.938 .685 .528 r
.26068 .48249 m .25292 .48879 L .23726 .45825 L p F P
0 g
s
.938 .685 .528 r
.22527 .41074 m .22572 .40926 L .24733 .44176 L p F P
0 g
s
.938 .685 .528 r
.24733 .44176 m .24665 .44287 L .22527 .41074 L p F P
0 g
s
.938 .685 .528 r
.24529 .4451 m .24733 .44176 L .22572 .40926 L p F P
0 g
s
.573 .366 .563 r
.66733 .69377 m .65222 .69957 L .65351 .73417 L p F P
0 g
s
.573 .366 .563 r
.63962 .7387 m .65351 .73417 L .65222 .69957 L p F P
0 g
s
.573 .366 .563 r
.6687 .72635 m .65351 .73417 L .65222 .69957 L p F P
0 g
s
.573 .366 .563 r
.65222 .69957 m .66733 .69377 L .6687 .72635 L p F P
0 g
s
.573 .366 .563 r
.82685 .53995 m .81005 .56542 L .81125 .57911 L p F P
0 g
s
.573 .366 .563 r
.81125 .57911 m .82853 .55805 L .82685 .53995 L p F P
0 g
s
.573 .366 .563 r
.84526 .54016 m .82853 .55805 L .82685 .53995 L p F P
0 g
s
.573 .366 .563 r
.81005 .56542 m .82685 .53995 L .82853 .55805 L p F P
0 g
s
.938 .685 .528 r
.29056 .59389 m .29669 .59678 L .29801 .63444 L p F P
0 g
s
.938 .685 .528 r
.29927 .63545 m .29801 .63444 L .29669 .59678 L p F P
0 g
s
.573 .366 .563 r
.73561 .62425 m .75599 .63493 L .75577 .63174 L p F P
0 g
s
.573 .366 .563 r
.75599 .63493 m .73561 .62425 L .73627 .63474 L p F P
0 g
s
.573 .366 .563 r
.75624 .63851 m .73627 .63474 L .73561 .62425 L p F P
0 g
s
.573 .366 .563 r
.73561 .62425 m .75599 .63493 L .75624 .63851 L p F P
0 g
s
.573 .366 .563 r
.90136 .48492 m .88802 .48487 L .89097 .51077 L p F P
0 g
s
.573 .366 .563 r
.87659 .51616 m .89097 .51077 L .88802 .48487 L p F P
0 g
s
.573 .366 .563 r
.90432 .51 m .89097 .51077 L .88802 .48487 L p F P
0 g
s
.573 .366 .563 r
.88802 .48487 m .90136 .48492 L .90432 .51 L p F P
0 g
s
.938 .685 .528 r
.22303 .41812 m .22527 .41074 L .24665 .44287 L p F P
0 g
s
.938 .685 .528 r
.24665 .44287 m .24326 .44842 L .22303 .41812 L p F P
0 g
s
.573 .366 .563 r
.59581 .75545 m .60151 .78412 L .6013 .77466 L p F P
0 g
s
.573 .366 .563 r
.60151 .78412 m .59581 .75545 L .59588 .75876 L p F P
0 g
s
.573 .366 .563 r
.60162 .78898 m .59588 .75876 L .59581 .75545 L p F P
0 g
s
.573 .366 .563 r
.59581 .75545 m .60151 .78412 L .60162 .78898 L p F P
0 g
s
.938 .685 .528 r
.2595 .52324 m .27058 .52015 L .25721 .48531 L p F P
0 g
s
.938 .685 .528 r
.27058 .52015 m .2595 .52324 L .26787 .55448 L p F P
0 g
s
.938 .685 .528 r
.26787 .55448 m .28021 .55603 L .27058 .52015 L p F P
0 g
s
.938 .685 .528 r
.28822 .57537 m .27764 .57217 L .28074 .60498 L p F P
0 g
s
.938 .685 .528 r
.28074 .60498 m .29175 .61197 L .28822 .57537 L p F P
0 g
s
.573 .366 .563 r
.6272 .73987 m .61641 .73777 L .61718 .76648 L p F P
0 g
s
.573 .366 .563 r
.60797 .75725 m .61718 .76648 L .61641 .73777 L p F P
0 g
s
.573 .366 .563 r
.62813 .77133 m .61718 .76648 L .61641 .73777 L p F P
0 g
s
.573 .366 .563 r
.61641 .73777 m .6272 .73987 L .62813 .77133 L p F P
0 g
s
.938 .685 .528 r
.25406 .50789 m .26434 .50252 L .27589 .53805 L p F P
0 g
s
.938 .685 .528 r
.27589 .53805 m .26412 .53882 L .25406 .50789 L p F P
0 g
s
.938 .685 .528 r
.26412 .53882 m .27589 .53805 L .28349 .57394 L p F P
0 g
s
.938 .685 .528 r
.29423 .59562 m .28571 .5916 L .28682 .6255 L p F P
0 g
s
.938 .685 .528 r
.28682 .6255 m .2955 .63244 L .29423 .59562 L p F P
0 g
s
.938 .685 .528 r
.23629 .42623 m .23346 .43272 L .25236 .46507 L p F P
0 g
s
.938 .685 .528 r
.24544 .47316 m .25236 .46507 L .23346 .43272 L p F P
0 g
s
.938 .685 .528 r
.25236 .46507 m .24544 .47316 L .25963 .50498 L p F P
0 g
s
.938 .685 .528 r
.24091 .47846 m .24927 .46869 L .26434 .50252 L p F P
0 g
s
.938 .685 .528 r
.26434 .50252 m .25406 .50789 L .24091 .47846 L p F P
0 g
s
.573 .366 .563 r
.59588 .75876 m .60162 .78898 L .60151 .78412 L p F P
0 g
s
.573 .366 .563 r
.68363 .68646 m .66733 .69377 L .6687 .72635 L p F P
0 g
s
.573 .366 .563 r
.65351 .73417 m .6687 .72635 L .66733 .69377 L p F P
0 g
s
.573 .366 .563 r
.68499 .71545 m .6687 .72635 L .66733 .69377 L p F P
0 g
s
.573 .366 .563 r
.66733 .69377 m .68363 .68646 L .68499 .71545 L p F P
0 g
s
.938 .685 .528 r
.22572 .40926 m .22437 .4137 L .24529 .4451 L p F P
0 g
s
.938 .685 .528 r
.24058 .45281 m .24529 .4451 L .22437 .4137 L p F P
0 g
s
.938 .685 .528 r
.24529 .4451 m .24058 .45281 L .25721 .48531 L p F P
0 g
s
.573 .366 .563 r
.7749 .61998 m .7917 .58018 L .79189 .58258 L p F P
0 g
s
.573 .366 .563 r
.7917 .58018 m .7749 .61998 L .77496 .6208 L p F P
0 g
s
.573 .366 .563 r
.77496 .6208 m .79189 .58258 L .7917 .58018 L p F P
0 g
s
.938 .685 .528 r
.28021 .55603 m .26787 .55448 L .2726 .58543 L p F P
0 g
s
.938 .685 .528 r
.2726 .58543 m .28571 .5916 L .28021 .55603 L p F P
0 g
s
.573 .366 .563 r
.71796 .64958 m .73698 .64595 L .73627 .63474 L p F P
0 g
s
.573 .366 .563 r
.73698 .64595 m .71796 .64958 L .71902 .668 L p F P
0 g
s
.573 .366 .563 r
.70092 .67779 m .71902 .668 L .71796 .64958 L p F P
0 g
s
.573 .366 .563 r
.7377 .65737 m .71902 .668 L .71796 .64958 L p F P
0 g
s
.573 .366 .563 r
.71796 .64958 m .73698 .64595 L .7377 .65737 L p F P
0 g
s
.573 .366 .563 r
.81005 .56542 m .79283 .59404 L .79352 .60261 L p F P
0 g
s
.573 .366 .563 r
.79352 .60261 m .81125 .57911 L .81005 .56542 L p F P
0 g
s
.573 .366 .563 r
.82853 .55805 m .81125 .57911 L .81005 .56542 L p F P
0 g
s
.573 .366 .563 r
.79283 .59404 m .81005 .56542 L .81125 .57911 L p F P
0 g
s
.573 .366 .563 r
.81005 .56542 m .79283 .59404 L .79227 .58726 L p F P
0 g
s
.573 .366 .563 r
.91148 .47252 m .92289 .48596 L .92153 .47509 L p F P
0 g
s
.573 .366 .563 r
.92289 .48596 m .91148 .47252 L .91369 .49065 L p F P
0 g
s
.573 .366 .563 r
.90136 .48492 m .91369 .49065 L .91148 .47252 L p F P
0 g
s
.573 .366 .563 r
.92486 .50176 m .91369 .49065 L .91148 .47252 L p F P
0 g
s
.573 .366 .563 r
.91148 .47252 m .92289 .48596 L .92486 .50176 L p F P
0 g
s
.573 .366 .563 r
.79189 .58258 m .77496 .6208 L .77509 .62242 L p F P
0 g
s
.573 .366 .563 r
.77509 .62242 m .79227 .58726 L .79189 .58258 L p F P
0 g
s
.573 .366 .563 r
.77496 .6208 m .79189 .58258 L .79227 .58726 L p F P
0 g
s
.573 .366 .563 r
.79189 .58258 m .77496 .6208 L .7749 .61998 L p F P
0 g
s
.938 .685 .528 r
.24784 .49292 m .25721 .48531 L .24058 .45281 L p F P
0 g
s
.938 .685 .528 r
.25721 .48531 m .24784 .49292 L .2595 .52324 L p F P
0 g
s
.938 .685 .528 r
.29547 .61434 m .29922 .61672 L .29806 .65335 L p F P
0 g
s
.938 .685 .528 r
.29922 .61672 m .29797 .61592 L .29681 .65215 L p F P
0 g
s
.938 .685 .528 r
.29681 .65215 m .29806 .65335 L .29922 .61672 L p F P
0 g
s
.573 .366 .563 r
.73627 .63474 m .75624 .63851 L .75599 .63493 L p F P
0 g
s
.573 .366 .563 r
.75624 .63851 m .73627 .63474 L .73698 .64595 L p F P
0 g
s
.573 .366 .563 r
.75651 .64233 m .73698 .64595 L .73627 .63474 L p F P
0 g
s
.573 .366 .563 r
.73627 .63474 m .75624 .63851 L .75651 .64233 L p F P
0 g
s
.573 .366 .563 r
.91369 .49065 m .90136 .48492 L .90432 .51 L p F P
0 g
s
.573 .366 .563 r
.89097 .51077 m .90432 .51 L .90136 .48492 L p F P
0 g
s
.573 .366 .563 r
.91651 .51378 m .90432 .51 L .90136 .48492 L p F P
0 g
s
.573 .366 .563 r
.90136 .48492 m .91369 .49065 L .91651 .51378 L p F P
0 g
s
.938 .685 .528 r
.21305 .39987 m .21402 .39492 L .23686 .42492 L p F P
0 g
s
.938 .685 .528 r
.23686 .42492 m .23515 .42883 L .21305 .39987 L p F P
0 g
s
.938 .685 .528 r
.23629 .42623 m .23686 .42492 L .21402 .39492 L p F P
0 g
s
.938 .685 .528 r
.29797 .61592 m .29175 .61197 L .29059 .64615 L p F P
0 g
s
.938 .685 .528 r
.29059 .64615 m .29681 .65215 L .29797 .61592 L p F P
0 g
s
.573 .366 .563 r
.60101 .76112 m .60849 .77876 L .60797 .75725 L p F P
0 g
s
.573 .366 .563 r
.60849 .77876 m .60101 .76112 L .6013 .77466 L p F P
0 g
s
.573 .366 .563 r
.6089 .79604 m .6013 .77466 L .60101 .76112 L p F P
0 g
s
.573 .366 .563 r
.60101 .76112 m .60849 .77876 L .6089 .79604 L p F P
0 g
s
.938 .685 .528 r
.29056 .59389 m .27971 .58877 L .27456 .55532 L p F P
0 g
s
.938 .685 .528 r
.27971 .58877 m .29056 .59389 L .29176 .62945 L p F P
0 g
s
.938 .685 .528 r
.29801 .63444 m .29176 .62945 L .29056 .59389 L p F P
0 g
s
.573 .366 .563 r
.70092 .67779 m .68363 .68646 L .68499 .71545 L p F P
0 g
s
.573 .366 .563 r
.6687 .72635 m .68499 .71545 L .68363 .68646 L p F P
0 g
s
.573 .366 .563 r
.70218 .70183 m .68499 .71545 L .68363 .68646 L p F P
0 g
s
.573 .366 .563 r
.68363 .68646 m .70092 .67779 L .70218 .70183 L p F P
0 g
s
.573 .366 .563 r
.79227 .58726 m .77509 .62242 L .77526 .62474 L p F P
0 g
s
.573 .366 .563 r
.77526 .62474 m .79283 .59404 L .79227 .58726 L p F P
0 g
s
.573 .366 .563 r
.77509 .62242 m .79227 .58726 L .79283 .59404 L p F P
0 g
s
.573 .366 .563 r
.79227 .58726 m .77509 .62242 L .77496 .6208 L p F P
0 g
s
.573 .366 .563 r
.93139 .49184 m .92084 .46955 L .92153 .47509 L p F P
0 g
s
.573 .366 .563 r
.93196 .4963 m .92153 .47509 L .92084 .46955 L p F P
0 g
s
.573 .366 .563 r
.92084 .46955 m .93139 .49184 L .93196 .4963 L p F P
0 g
s
.938 .685 .528 r
.21402 .39492 m .21369 .39658 L .23629 .42623 L p F P
0 g
s
.938 .685 .528 r
.23346 .43272 m .23629 .42623 L .21369 .39658 L p F P
0 g
s
.938 .685 .528 r
.28349 .57394 m .2707 .57007 L .26412 .53882 L p F P
0 g
s
.938 .685 .528 r
.2707 .57007 m .28349 .57394 L .28682 .60885 L p F P
0 g
s
.938 .685 .528 r
.29547 .61434 m .28682 .60885 L .28349 .57394 L p F P
0 g
s
.938 .685 .528 r
.21908 .43115 m .22303 .41812 L .24326 .44842 L p F P
0 g
s
.938 .685 .528 r
.24326 .44842 m .23726 .45825 L .21908 .43115 L p F P
0 g
s
.573 .366 .563 r
.61718 .76648 m .60797 .75725 L .60849 .77876 L p F P
0 g
s
.573 .366 .563 r
.61784 .79164 m .60849 .77876 L .60797 .75725 L p F P
0 g
s
.573 .366 .563 r
.60797 .75725 m .61718 .76648 L .61784 .79164 L p F P
0 g
s
.573 .366 .563 r
.63962 .7387 m .6272 .73987 L .62813 .77133 L p F P
0 g
s
.573 .366 .563 r
.61718 .76648 m .62813 .77133 L .6272 .73987 L p F P
0 g
s
.573 .366 .563 r
.64071 .7714 m .62813 .77133 L .6272 .73987 L p F P
0 g
s
.573 .366 .563 r
.6272 .73987 m .63962 .7387 L .64071 .7714 L p F P
0 g
s
.573 .366 .563 r
.86132 .52605 m .84526 .54016 L .84777 .56559 L p F P
0 g
s
.573 .366 .563 r
.84526 .54016 m .82853 .55805 L .83051 .57928 L p F P
0 g
s
.573 .366 .563 r
.83051 .57928 m .84777 .56559 L .84526 .54016 L p F P
0 g
s
.573 .366 .563 r
.86428 .5545 m .84777 .56559 L .84526 .54016 L p F P
0 g
s
.573 .366 .563 r
.84526 .54016 m .86132 .52605 L .86428 .5545 L p F P
0 g
s
.573 .366 .563 r
.82853 .55805 m .84526 .54016 L .84777 .56559 L p F P
0 g
s
.573 .366 .563 r
.87659 .51616 m .86132 .52605 L .86428 .5545 L p F P
0 g
s
.573 .366 .563 r
.84777 .56559 m .86428 .5545 L .86132 .52605 L p F P
0 g
s
.573 .366 .563 r
.87989 .54634 m .86428 .5545 L .86132 .52605 L p F P
0 g
s
.573 .366 .563 r
.86132 .52605 m .87659 .51616 L .87989 .54634 L p F P
0 g
s
.938 .685 .528 r
.22517 .4517 m .23122 .43785 L .24927 .46869 L p F P
0 g
s
.938 .685 .528 r
.24927 .46869 m .24091 .47846 L .22517 .4517 L p F P
0 g
s
.938 .685 .528 r
.28682 .60885 m .29547 .61434 L .29431 .64974 L p F P
0 g
s
.938 .685 .528 r
.29806 .65335 m .29431 .64974 L .29547 .61434 L p F P
0 g
s
.573 .366 .563 r
.82853 .55805 m .81125 .57911 L .81265 .59513 L p F P
0 g
s
.573 .366 .563 r
.81265 .59513 m .83051 .57928 L .82853 .55805 L p F P
0 g
s
.573 .366 .563 r
.84777 .56559 m .83051 .57928 L .82853 .55805 L p F P
0 g
s
.573 .366 .563 r
.81125 .57911 m .82853 .55805 L .83051 .57928 L p F P
0 g
s
.938 .685 .528 r
.24201 .49765 m .25292 .48879 L .26551 .52157 L p F P
0 g
s
.938 .685 .528 r
.26551 .52157 m .2526 .52517 L .24201 .49765 L p F P
0 g
s
.938 .685 .528 r
.2526 .52517 m .26551 .52157 L .27456 .55532 L p F P
0 g
s
.573 .366 .563 r
.77759 .65576 m .75534 .62548 L .75537 .6259 L p F P
0 g
s
.573 .366 .563 r
.77756 .65534 m .75537 .6259 L .75534 .62548 L p F P
0 g
s
.573 .366 .563 r
.75534 .62548 m .77759 .65576 L .77756 .65534 L p F P
0 g
s
.573 .366 .563 r
.75537 .6259 m .77756 .65534 L .77759 .65576 L p F P
0 g
s
.573 .366 .563 r
.77756 .65534 m .75537 .6259 L .75545 .62712 L p F P
0 g
s
.573 .366 .563 r
.77747 .65409 m .75545 .62712 L .75537 .6259 L p F P
0 g
s
.573 .366 .563 r
.75537 .6259 m .77756 .65534 L .77747 .65409 L p F P
0 g
s
.938 .685 .528 r
.25678 .53931 m .2705 .5384 L .25963 .50498 L p F P
0 g
s
.938 .685 .528 r
.2705 .5384 m .25678 .53931 L .26274 .56766 L p F P
0 g
s
.938 .685 .528 r
.26274 .56766 m .27764 .57217 L .2705 .5384 L p F P
0 g
s
.938 .685 .528 r
.24766 .51124 m .25963 .50498 L .24544 .47316 L p F P
0 g
s
.938 .685 .528 r
.25963 .50498 m .24766 .51124 L .25678 .53931 L p F P
0 g
s
.938 .685 .528 r
.21082 .41125 m .21305 .39987 L .23515 .42883 L p F P
0 g
s
.938 .685 .528 r
.23515 .42883 m .23122 .43785 L .21082 .41125 L p F P
0 g
s
.573 .366 .563 r
.75545 .62712 m .77747 .65409 L .77756 .65534 L p F P
0 g
s
.573 .366 .563 r
.77747 .65409 m .75545 .62712 L .75559 .6291 L p F P
0 g
s
.573 .366 .563 r
.77732 .65207 m .75559 .6291 L .75545 .62712 L p F P
0 g
s
.573 .366 .563 r
.75545 .62712 m .77747 .65409 L .77732 .65207 L p F P
0 g
s
.573 .366 .563 r
.89097 .51077 m .87659 .51616 L .87989 .54634 L p F P
0 g
s
.573 .366 .563 r
.86428 .5545 m .87989 .54634 L .87659 .51616 L p F P
0 g
s
.573 .366 .563 r
.89445 .54133 m .87989 .54634 L .87659 .51616 L p F P
0 g
s
.573 .366 .563 r
.87659 .51616 m .89097 .51077 L .89445 .54133 L p F P
0 g
s
.573 .366 .563 r
.92153 .47509 m .93196 .4963 L .93139 .49184 L p F P
0 g
s
.573 .366 .563 r
.93196 .4963 m .92153 .47509 L .92289 .48596 L p F P
0 g
s
.573 .366 .563 r
.93308 .50506 m .92289 .48596 L .92153 .47509 L p F P
0 g
s
.573 .366 .563 r
.92153 .47509 m .93196 .4963 L .93308 .50506 L p F P
0 g
s
.573 .366 .563 r
.71902 .668 m .70092 .67779 L .70218 .70183 L p F P
0 g
s
.573 .366 .563 r
.68499 .71545 m .70218 .70183 L .70092 .67779 L p F P
0 g
s
.573 .366 .563 r
.72005 .68598 m .70218 .70183 L .70092 .67779 L p F P
0 g
s
.573 .366 .563 r
.70092 .67779 m .71902 .668 L .72005 .68598 L p F P
0 g
s
.573 .366 .563 r
.79283 .59404 m .77526 .62474 L .77548 .62768 L p F P
0 g
s
.573 .366 .563 r
.77548 .62768 m .79352 .60261 L .79283 .59404 L p F P
0 g
s
.573 .366 .563 r
.81125 .57911 m .79352 .60261 L .79283 .59404 L p F P
0 g
s
.573 .366 .563 r
.77526 .62474 m .79283 .59404 L .79352 .60261 L p F P
0 g
s
.573 .366 .563 r
.79283 .59404 m .77526 .62474 L .77509 .62242 L p F P
0 g
s
.573 .366 .563 r
.73698 .64595 m .75651 .64233 L .75624 .63851 L p F P
0 g
s
.573 .366 .563 r
.75651 .64233 m .73698 .64595 L .7377 .65737 L p F P
0 g
s
.573 .366 .563 r
.71902 .668 m .7377 .65737 L .73698 .64595 L p F P
0 g
s
.573 .366 .563 r
.75677 .6462 m .7377 .65737 L .73698 .64595 L p F P
0 g
s
.573 .366 .563 r
.73698 .64595 m .75651 .64233 L .75677 .6462 L p F P
0 g
s
.573 .366 .563 r
.75559 .6291 m .77732 .65207 L .77747 .65409 L p F P
0 g
s
.573 .366 .563 r
.77732 .65207 m .75559 .6291 L .75577 .63174 L p F P
0 g
s
.573 .366 .563 r
.77711 .64938 m .75577 .63174 L .75559 .6291 L p F P
0 g
s
.573 .366 .563 r
.75559 .6291 m .77732 .65207 L .77711 .64938 L p F P
0 g
s
.938 .685 .528 r
.27456 .55532 m .26018 .55352 L .2526 .52517 L p F P
0 g
s
.938 .685 .528 r
.26018 .55352 m .27456 .55532 L .27971 .58877 L p F P
0 g
s
.573 .366 .563 r
.81125 .57911 m .79352 .60261 L .79433 .6126 L p F P
0 g
s
.573 .366 .563 r
.79433 .6126 m .81265 .59513 L .81125 .57911 L p F P
0 g
s
.573 .366 .563 r
.83051 .57928 m .81265 .59513 L .81125 .57911 L p F P
0 g
s
.573 .366 .563 r
.79352 .60261 m .81125 .57911 L .81265 .59513 L p F P
0 g
s
.938 .685 .528 r
.22882 .47206 m .23726 .45825 L .25292 .48879 L p F P
0 g
s
.938 .685 .528 r
.25292 .48879 m .24201 .49765 L .22882 .47206 L p F P
0 g
s
.938 .685 .528 r
.28571 .5916 m .2726 .58543 L .27348 .61485 L p F P
0 g
s
.938 .685 .528 r
.27348 .61485 m .28682 .6255 L .28571 .5916 L p F P
0 g
s
.573 .366 .563 r
.75577 .63174 m .77711 .64938 L .77732 .65207 L p F P
0 g
s
.573 .366 .563 r
.77711 .64938 m .75577 .63174 L .75599 .63493 L p F P
0 g
s
.573 .366 .563 r
.77687 .64615 m .75599 .63493 L .75577 .63174 L p F P
0 g
s
.573 .366 .563 r
.75577 .63174 m .77711 .64938 L .77687 .64615 L p F P
0 g
s
.938 .685 .528 r
.29801 .63444 m .29927 .63545 L .29557 .67025 L p F P
0 g
s
.938 .685 .528 r
.29927 .63545 m .2955 .63244 L .29188 .66605 L p F P
0 g
s
.938 .685 .528 r
.29188 .66605 m .29557 .67025 L .29927 .63545 L p F P
0 g
s
.938 .685 .528 r
.29175 .61197 m .28074 .60498 L .27961 .63555 L p F P
0 g
s
.938 .685 .528 r
.27961 .63555 m .29059 .64615 L .29175 .61197 L p F P
0 g
s
.573 .366 .563 r
.65351 .73417 m .63962 .7387 L .64071 .7714 L p F P
0 g
s
.573 .366 .563 r
.62813 .77133 m .64071 .7714 L .63962 .7387 L p F P
0 g
s
.573 .366 .563 r
.65472 .76652 m .64071 .7714 L .63962 .7387 L p F P
0 g
s
.573 .366 .563 r
.63962 .7387 m .65351 .73417 L .65472 .76652 L p F P
0 g
s
.938 .685 .528 r
.22437 .4137 m .22127 .42394 L .24058 .45281 L p F P
0 g
s
.938 .685 .528 r
.23333 .46468 m .24058 .45281 L .22127 .42394 L p F P
0 g
s
.938 .685 .528 r
.24058 .45281 m .23333 .46468 L .24784 .49292 L p F P
0 g
s
.573 .366 .563 r
.6013 .77466 m .6089 .79604 L .60849 .77876 L p F P
0 g
s
.573 .366 .563 r
.6089 .79604 m .6013 .77466 L .60151 .78412 L p F P
0 g
s
.573 .366 .563 r
.60919 .80813 m .60151 .78412 L .6013 .77466 L p F P
0 g
s
.573 .366 .563 r
.6013 .77466 m .6089 .79604 L .60919 .80813 L p F P
0 g
s
.573 .366 .563 r
.7377 .65737 m .71902 .668 L .72005 .68598 L p F P
0 g
s
.573 .366 .563 r
.70218 .70183 m .72005 .68598 L .71902 .668 L p F P
0 g
s
.573 .366 .563 r
.73841 .66846 m .72005 .68598 L .71902 .668 L p F P
0 g
s
.573 .366 .563 r
.71902 .668 m .7377 .65737 L .73841 .66846 L p F P
0 g
s
.938 .685 .528 r
.21369 .39658 m .21209 .40477 L .23346 .43272 L p F P
0 g
s
.938 .685 .528 r
.22845 .44419 m .23346 .43272 L .21209 .40477 L p F P
0 g
s
.938 .685 .528 r
.23346 .43272 m .22845 .44419 L .24544 .47316 L p F P
0 g
s
.573 .366 .563 r
.90432 .51 m .89097 .51077 L .89445 .54133 L p F P
0 g
s
.573 .366 .563 r
.87989 .54634 m .89445 .54133 L .89097 .51077 L p F P
0 g
s
.573 .366 .563 r
.90782 .53956 m .89445 .54133 L .89097 .51077 L p F P
0 g
s
.573 .366 .563 r
.89097 .51077 m .90432 .51 L .90782 .53956 L p F P
0 g
s
.938 .685 .528 r
.29176 .62945 m .29801 .63444 L .29434 .66884 L p F P
0 g
s
.938 .685 .528 r
.29557 .67025 m .29434 .66884 L .29801 .63444 L p F P
0 g
s
.573 .366 .563 r
.75599 .63493 m .77687 .64615 L .77711 .64938 L p F P
0 g
s
.573 .366 .563 r
.77687 .64615 m .75599 .63493 L .75624 .63851 L p F P
0 g
s
.573 .366 .563 r
.7766 .64253 m .75624 .63851 L .75599 .63493 L p F P
0 g
s
.573 .366 .563 r
.75599 .63493 m .77687 .64615 L .7766 .64253 L p F P
0 g
s
.938 .685 .528 r
.20166 .38389 m .20185 .38208 L .22572 .40926 L p F P
0 g
s
.938 .685 .528 r
.22572 .40926 m .22527 .41074 L .20166 .38389 L p F P
0 g
s
.938 .685 .528 r
.22437 .4137 m .22572 .40926 L .20185 .38208 L p F P
0 g
s
.573 .366 .563 r
.91369 .49065 m .92486 .50176 L .92289 .48596 L p F P
0 g
s
.573 .366 .563 r
.92486 .50176 m .91369 .49065 L .91651 .51378 L p F P
0 g
s
.573 .366 .563 r
.90432 .51 m .91651 .51378 L .91369 .49065 L p F P
0 g
s
.573 .366 .563 r
.92738 .52189 m .91651 .51378 L .91369 .49065 L p F P
0 g
s
.573 .366 .563 r
.91369 .49065 m .92486 .50176 L .92738 .52189 L p F P
0 g
s
.938 .685 .528 r
.27764 .57217 m .26274 .56766 L .26527 .59516 L p F P
0 g
s
.938 .685 .528 r
.26527 .59516 m .28074 .60498 L .27764 .57217 L p F P
0 g
s
.573 .366 .563 r
.79352 .60261 m .77548 .62768 L .77574 .63109 L p F P
0 g
s
.573 .366 .563 r
.77574 .63109 m .79433 .6126 L .79352 .60261 L p F P
0 g
s
.573 .366 .563 r
.81265 .59513 m .79433 .6126 L .79352 .60261 L p F P
0 g
s
.573 .366 .563 r
.77548 .62768 m .79352 .60261 L .79433 .6126 L p F P
0 g
s
.573 .366 .563 r
.79352 .60261 m .77548 .62768 L .77526 .62474 L p F P
0 g
s
.938 .685 .528 r
.23571 .48455 m .24544 .47316 L .22845 .44419 L p F P
0 g
s
.938 .685 .528 r
.24544 .47316 m .23571 .48455 L .24766 .51124 L p F P
0 g
s
.573 .366 .563 r
.75781 .6612 m .7749 .61998 L .77496 .6208 L p F P
0 g
s
.573 .366 .563 r
.7749 .61998 m .75781 .6612 L .75776 .66036 L p F P
0 g
s
.573 .366 .563 r
.75776 .66036 m .77496 .6208 L .7749 .61998 L p F P
0 g
s
.938 .685 .528 r
.20072 .39284 m .20166 .38389 L .22527 .41074 L p F P
0 g
s
.938 .685 .528 r
.22527 .41074 m .22303 .41812 L .20072 .39284 L p F P
0 g
s
.573 .366 .563 r
.75776 .66036 m .77496 .6208 L .77509 .62242 L p F P
0 g
s
.573 .366 .563 r
.77496 .6208 m .75776 .66036 L .75781 .6612 L p F P
0 g
s
.573 .366 .563 r
.77496 .6208 m .75776 .66036 L .75764 .65872 L p F P
0 g
s
.573 .366 .563 r
.75764 .65872 m .77509 .62242 L .77496 .6208 L p F P
0 g
s
.573 .366 .563 r
.75624 .63851 m .7766 .64253 L .77687 .64615 L p F P
0 g
s
.573 .366 .563 r
.7766 .64253 m .75624 .63851 L .75651 .64233 L p F P
0 g
s
.573 .366 .563 r
.77631 .63869 m .75651 .64233 L .75624 .63851 L p F P
0 g
s
.573 .366 .563 r
.75624 .63851 m .7766 .64253 L .77631 .63869 L p F P
0 g
s
.573 .366 .563 r
.92289 .48596 m .93308 .50506 L .93196 .4963 L p F P
0 g
s
.573 .366 .563 r
.93308 .50506 m .92289 .48596 L .92486 .50176 L p F P
0 g
s
.573 .366 .563 r
.9347 .51777 m .92486 .50176 L .92289 .48596 L p F P
0 g
s
.573 .366 .563 r
.92289 .48596 m .93308 .50506 L .9347 .51777 L p F P
0 g
s
.573 .366 .563 r
.62813 .77133 m .61718 .76648 L .61784 .79164 L p F P
0 g
s
.573 .366 .563 r
.60849 .77876 m .61784 .79164 L .61718 .76648 L p F P
0 g
s
.573 .366 .563 r
.62895 .79895 m .61784 .79164 L .61718 .76648 L p F P
0 g
s
.573 .366 .563 r
.61718 .76648 m .62813 .77133 L .62895 .79895 L p F P
0 g
s
.938 .685 .528 r
.2955 .63244 m .28682 .6255 L .28339 .65638 L p F P
0 g
s
.938 .685 .528 r
.28339 .65638 m .29188 .66605 L .2955 .63244 L p F P
0 g
s
.573 .366 .563 r
.77509 .62242 m .75764 .65872 L .75748 .65635 L p F P
0 g
s
.573 .366 .563 r
.75748 .65635 m .77526 .62474 L .77509 .62242 L p F P
0 g
s
.573 .366 .563 r
.75764 .65872 m .77509 .62242 L .77526 .62474 L p F P
0 g
s
.573 .366 .563 r
.77509 .62242 m .75764 .65872 L .75776 .66036 L p F P
0 g
s
.573 .366 .563 r
.6687 .72635 m .65351 .73417 L .65472 .76652 L p F P
0 g
s
.573 .366 .563 r
.64071 .7714 m .65472 .76652 L .65351 .73417 L p F P
0 g
s
.573 .366 .563 r
.66997 .75677 m .65472 .76652 L .65351 .73417 L p F P
0 g
s
.573 .366 .563 r
.65351 .73417 m .6687 .72635 L .66997 .75677 L p F P
0 g
s
.573 .366 .563 r
.7377 .65737 m .75677 .6462 L .75651 .64233 L p F P
0 g
s
.573 .366 .563 r
.75677 .6462 m .7377 .65737 L .73841 .66846 L p F P
0 g
s
.573 .366 .563 r
.72005 .68598 m .73841 .66846 L .7377 .65737 L p F P
0 g
s
.573 .366 .563 r
.75703 .64994 m .73841 .66846 L .7377 .65737 L p F P
0 g
s
.573 .366 .563 r
.7377 .65737 m .75677 .6462 L .75703 .64994 L p F P
0 g
s
.573 .366 .563 r
.75748 .65635 m .77526 .62474 L .77548 .62768 L p F P
0 g
s
.573 .366 .563 r
.77526 .62474 m .75748 .65635 L .75764 .65872 L p F P
0 g
s
.573 .366 .563 r
.77526 .62474 m .75748 .65635 L .75727 .65338 L p F P
0 g
s
.573 .366 .563 r
.75727 .65338 m .77548 .62768 L .77526 .62474 L p F P
0 g
s
.938 .685 .528 r
.24485 .52733 m .2595 .52324 L .24784 .49292 L p F P
0 g
s
.938 .685 .528 r
.2595 .52324 m .24485 .52733 L .25156 .55244 L p F P
0 g
s
.938 .685 .528 r
.25156 .55244 m .26787 .55448 L .2595 .52324 L p F P
0 g
s
.573 .366 .563 r
.60151 .78412 m .60919 .80813 L .6089 .79604 L p F P
0 g
s
.573 .366 .563 r
.60919 .80813 m .60151 .78412 L .60162 .78898 L p F P
0 g
s
.573 .366 .563 r
.60934 .81435 m .60162 .78898 L .60151 .78412 L p F P
0 g
s
.573 .366 .563 r
.60151 .78412 m .60919 .80813 L .60934 .81435 L p F P
0 g
s
.938 .685 .528 r
.20185 .38208 m .20128 .38748 L .22437 .4137 L p F P
0 g
s
.938 .685 .528 r
.22127 .42394 m .22437 .4137 L .20128 .38748 L p F P
0 g
s
.938 .685 .528 r
.28682 .60885 m .27353 .60041 L .2707 .57007 L p F P
0 g
s
.938 .685 .528 r
.27353 .60041 m .28682 .60885 L .28568 .6414 L p F P
0 g
s
.938 .685 .528 r
.29431 .64974 m .28568 .6414 L .28682 .60885 L p F P
0 g
s
.573 .366 .563 r
.75651 .64233 m .77631 .63869 L .7766 .64253 L p F P
0 g
s
.573 .366 .563 r
.77631 .63869 m .75651 .64233 L .75677 .6462 L p F P
0 g
s
.573 .366 .563 r
.77602 .63482 m .75677 .6462 L .75651 .64233 L p F P
0 g
s
.573 .366 .563 r
.75651 .64233 m .77631 .63869 L .77602 .63482 L p F P
0 g
s
.938 .685 .528 r
.24047 .51499 m .25406 .50789 L .26412 .53882 L p F P
0 g
s
.938 .685 .528 r
.26412 .53882 m .24856 .53986 L .24047 .51499 L p F P
0 g
s
.938 .685 .528 r
.24856 .53986 m .26412 .53882 L .2707 .57007 L p F P
0 g
s
.573 .366 .563 r
.61784 .79164 m .60849 .77876 L .6089 .79604 L p F P
0 g
s
.573 .366 .563 r
.61838 .81189 m .6089 .79604 L .60849 .77876 L p F P
0 g
s
.573 .366 .563 r
.60849 .77876 m .61784 .79164 L .61838 .81189 L p F P
0 g
s
.938 .685 .528 r
.22988 .49137 m .24091 .47846 L .25406 .50789 L p F P
0 g
s
.938 .685 .528 r
.25406 .50789 m .24047 .51499 L .22988 .49137 L p F P
0 g
s
.938 .685 .528 r
.27971 .58877 m .26445 .58158 L .26018 .55352 L p F P
0 g
s
.938 .685 .528 r
.26445 .58158 m .27971 .58877 L .28071 .62062 L p F P
0 g
s
.938 .685 .528 r
.29176 .62945 m .28071 .62062 L .27971 .58877 L p F P
0 g
s
.938 .685 .528 r
.20741 .42871 m .21082 .41125 L .23122 .43785 L p F P
0 g
s
.938 .685 .528 r
.23122 .43785 m .22517 .4517 L .20741 .42871 L p F P
0 g
s
.573 .366 .563 r
.77548 .62768 m .75727 .65338 L .75703 .64994 L p F P
0 g
s
.573 .366 .563 r
.75703 .64994 m .77574 .63109 L .77548 .62768 L p F P
0 g
s
.573 .366 .563 r
.79433 .6126 m .77574 .63109 L .77548 .62768 L p F P
0 g
s
.573 .366 .563 r
.75727 .65338 m .77548 .62768 L .77574 .63109 L p F P
0 g
s
.573 .366 .563 r
.77548 .62768 m .75727 .65338 L .75748 .65635 L p F P
0 g
s
.573 .366 .563 r
.91651 .51378 m .90432 .51 L .90782 .53956 L p F P
0 g
s
.573 .366 .563 r
.89445 .54133 m .90782 .53956 L .90432 .51 L p F P
0 g
s
.573 .366 .563 r
.91983 .54102 m .90782 .53956 L .90432 .51 L p F P
0 g
s
.573 .366 .563 r
.90432 .51 m .91651 .51378 L .91983 .54102 L p F P
0 g
s
.573 .366 .563 r
.68499 .71545 m .6687 .72635 L .66997 .75677 L p F P
0 g
s
.573 .366 .563 r
.65472 .76652 m .66997 .75677 L .6687 .72635 L p F P
0 g
s
.573 .366 .563 r
.68625 .74247 m .66997 .75677 L .6687 .72635 L p F P
0 g
s
.573 .366 .563 r
.6687 .72635 m .68499 .71545 L .68625 .74247 L p F P
0 g
s
.938 .685 .528 r
.21354 .44943 m .21908 .43115 L .23726 .45825 L p F P
0 g
s
.938 .685 .528 r
.23726 .45825 m .22882 .47206 L .21354 .44943 L p F P
0 g
s
.573 .366 .563 r
.75677 .6462 m .77602 .63482 L .77631 .63869 L p F P
0 g
s
.573 .366 .563 r
.77602 .63482 m .75677 .6462 L .75703 .64994 L p F P
0 g
s
.573 .366 .563 r
.73841 .66846 m .75703 .64994 L .75677 .6462 L p F P
0 g
s
.573 .366 .563 r
.77574 .63109 m .75703 .64994 L .75677 .6462 L p F P
0 g
s
.573 .366 .563 r
.75677 .6462 m .77602 .63482 L .77574 .63109 L p F P
0 g
s
.938 .685 .528 r
.26787 .55448 m .25156 .55244 L .25531 .57728 L p F P
0 g
s
.938 .685 .528 r
.25531 .57728 m .2726 .58543 L .26787 .55448 L p F P
0 g
s
.573 .366 .563 r
.83051 .57928 m .81265 .59513 L .81419 .61278 L p F P
0 g
s
.573 .366 .563 r
.81265 .59513 m .79433 .6126 L .79523 .62357 L p F P
0 g
s
.573 .366 .563 r
.79523 .62357 m .81419 .61278 L .81265 .59513 L p F P
0 g
s
.573 .366 .563 r
.8327 .60276 m .81419 .61278 L .81265 .59513 L p F P
0 g
s
.573 .366 .563 r
.81265 .59513 m .83051 .57928 L .8327 .60276 L p F P
0 g
s
.573 .366 .563 r
.79433 .6126 m .81265 .59513 L .81419 .61278 L p F P
0 g
s
.938 .685 .528 r
.28071 .62062 m .29176 .62945 L .28822 .66188 L p F P
0 g
s
.938 .685 .528 r
.29434 .66884 m .28822 .66188 L .29176 .62945 L p F P
0 g
s
.573 .366 .563 r
.60162 .78898 m .60934 .81435 L .60919 .80813 L p F P
0 g
s
.573 .366 .563 r
.84777 .56559 m .83051 .57928 L .8327 .60276 L p F P
0 g
s
.573 .366 .563 r
.81419 .61278 m .8327 .60276 L .83051 .57928 L p F P
0 g
s
.573 .366 .563 r
.85056 .59379 m .8327 .60276 L .83051 .57928 L p F P
0 g
s
.573 .366 .563 r
.83051 .57928 m .84777 .56559 L .85056 .59379 L p F P
0 g
s
.573 .366 .563 r
.79433 .6126 m .77574 .63109 L .77602 .63482 L p F P
0 g
s
.573 .366 .563 r
.77602 .63482 m .79523 .62357 L .79433 .6126 L p F P
0 g
s
.573 .366 .563 r
.81419 .61278 m .79523 .62357 L .79433 .6126 L p F P
0 g
s
.573 .366 .563 r
.77574 .63109 m .79433 .6126 L .79523 .62357 L p F P
0 g
s
.938 .685 .528 r
.23547 .50297 m .24784 .49292 L .23333 .46468 L p F P
0 g
s
.938 .685 .528 r
.24784 .49292 m .23547 .50297 L .24485 .52733 L p F P
0 g
s
.573 .366 .563 r
.79523 .62357 m .77602 .63482 L .77574 .63109 L p F P
0 g
s
.573 .366 .563 r
.75703 .64994 m .77574 .63109 L .77602 .63482 L p F P
0 g
s
.573 .366 .563 r
.77574 .63109 m .75703 .64994 L .75727 .65338 L p F P
0 g
s
.573 .366 .563 r
.86428 .5545 m .84777 .56559 L .85056 .59379 L p F P
0 g
s
.573 .366 .563 r
.8327 .60276 m .85056 .59379 L .84777 .56559 L p F P
0 g
s
.573 .366 .563 r
.86758 .58611 m .85056 .59379 L .84777 .56559 L p F P
0 g
s
.573 .366 .563 r
.84777 .56559 m .86428 .5545 L .86758 .58611 L p F P
0 g
s
.938 .685 .528 r
.19906 .40864 m .20072 .39284 L .22303 .41812 L p F P
0 g
s
.938 .685 .528 r
.22303 .41812 m .21908 .43115 L .19906 .40864 L p F P
0 g
s
.573 .366 .563 r
.70218 .70183 m .68499 .71545 L .68625 .74247 L p F P
0 g
s
.573 .366 .563 r
.66997 .75677 m .68625 .74247 L .68499 .71545 L p F P
0 g
s
.573 .366 .563 r
.70334 .72418 m .68625 .74247 L .68499 .71545 L p F P
0 g
s
.573 .366 .563 r
.68499 .71545 m .70218 .70183 L .70334 .72418 L p F P
0 g
s
.573 .366 .563 r
.75703 .64994 m .73841 .66846 L .73905 .6787 L p F P
0 g
s
.573 .366 .563 r
.73905 .6787 m .75727 .65338 L .75703 .64994 L p F P
0 g
s
.573 .366 .563 r
.73841 .66846 m .75703 .64994 L .75727 .65338 L p F P
0 g
s
.938 .685 .528 r
.29431 .64974 m .29806 .65335 L .29181 .68595 L p F P
0 g
s
.938 .685 .528 r
.29806 .65335 m .29681 .65215 L .29061 .68436 L p F P
0 g
s
.938 .685 .528 r
.29061 .68436 m .29181 .68595 L .29806 .65335 L p F P
0 g
s
.573 .366 .563 r
.73841 .66846 m .72005 .68598 L .72101 .70263 L p F P
0 g
s
.573 .366 .563 r
.72101 .70263 m .73905 .6787 L .73841 .66846 L p F P
0 g
s
.573 .366 .563 r
.75727 .65338 m .73905 .6787 L .73841 .66846 L p F P
0 g
s
.573 .366 .563 r
.72005 .68598 m .73841 .66846 L .73905 .6787 L p F P
0 g
s
.573 .366 .563 r
.72005 .68598 m .70218 .70183 L .70334 .72418 L p F P
0 g
s
.573 .366 .563 r
.68625 .74247 m .70334 .72418 L .70218 .70183 L p F P
0 g
s
.573 .366 .563 r
.72101 .70263 m .70334 .72418 L .70218 .70183 L p F P
0 g
s
.573 .366 .563 r
.70218 .70183 m .72005 .68598 L .72101 .70263 L p F P
0 g
s
.573 .366 .563 r
.94103 .52284 m .93196 .4963 L .93139 .49184 L p F P
0 g
s
.573 .366 .563 r
.93139 .49184 m .94062 .51969 L .94103 .52284 L p F P
0 g
s
.573 .366 .563 r
.94062 .51969 m .93139 .49184 L .93196 .4963 L p F P
0 g
s
.938 .685 .528 r
.2707 .57007 m .25382 .56496 L .24856 .53986 L p F P
0 g
s
.938 .685 .528 r
.25382 .56496 m .2707 .57007 L .27353 .60041 L p F P
0 g
s
.573 .366 .563 r
.70334 .72418 m .72101 .70263 L .72005 .68598 L p F P
0 g
s
.573 .366 .563 r
.73905 .6787 m .72101 .70263 L .72005 .68598 L p F P
0 g
s
.573 .366 .563 r
.79523 .62357 m .77602 .63482 L .77631 .63869 L p F P
0 g
s
.573 .366 .563 r
.79616 .63501 m .77631 .63869 L .77602 .63482 L p F P
0 g
s
.573 .366 .563 r
.77602 .63482 m .79523 .62357 L .79616 .63501 L p F P
0 g
s
.938 .685 .528 r
.29681 .65215 m .29059 .64615 L .28467 .67648 L p F P
0 g
s
.938 .685 .528 r
.28467 .67648 m .29061 .68436 L .29681 .65215 L p F P
0 g
s
.573 .366 .563 r
.87989 .54634 m .86428 .5545 L .86758 .58611 L p F P
0 g
s
.573 .366 .563 r
.85056 .59379 m .86758 .58611 L .86428 .5545 L p F P
0 g
s
.573 .366 .563 r
.88356 .57991 m .86758 .58611 L .86428 .5545 L p F P
0 g
s
.573 .366 .563 r
.86428 .5545 m .87989 .54634 L .88356 .57991 L p F P
0 g
s
.938 .685 .528 r
.2172 .46995 m .22517 .4517 L .24091 .47846 L p F P
0 g
s
.938 .685 .528 r
.24091 .47846 m .22988 .49137 L .2172 .46995 L p F P
0 g
s
.573 .366 .563 r
.64071 .7714 m .62813 .77133 L .62895 .79895 L p F P
0 g
s
.573 .366 .563 r
.61784 .79164 m .62895 .79895 L .62813 .77133 L p F P
0 g
s
.573 .366 .563 r
.64166 .80012 m .62895 .79895 L .62813 .77133 L p F P
0 g
s
.573 .366 .563 r
.62813 .77133 m .64071 .7714 L .64166 .80012 L p F P
0 g
s
.938 .685 .528 r
.18918 .3767 m .18933 .37089 L .21402 .39492 L p F P
0 g
s
.938 .685 .528 r
.21402 .39492 m .21305 .39987 L .18918 .3767 L p F P
0 g
s
.938 .685 .528 r
.21369 .39658 m .21402 .39492 L .18933 .37089 L p F P
0 g
s
.573 .366 .563 r
.75727 .65338 m .73905 .6787 L .73962 .68758 L p F P
0 g
s
.573 .366 .563 r
.73962 .68758 m .75748 .65635 L .75727 .65338 L p F P
0 g
s
.573 .366 .563 r
.73905 .6787 m .75727 .65338 L .75748 .65635 L p F P
0 g
s
.938 .685 .528 r
.28074 .60498 m .26527 .59516 L .26422 .62069 L p F P
0 g
s
.938 .685 .528 r
.26422 .62069 m .27961 .63555 L .28074 .60498 L p F P
0 g
s
.573 .366 .563 r
.92486 .50176 m .9347 .51777 L .93308 .50506 L p F P
0 g
s
.573 .366 .563 r
.9347 .51777 m .92486 .50176 L .92738 .52189 L p F P
0 g
s
.573 .366 .563 r
.91651 .51378 m .92738 .52189 L .92486 .50176 L p F P
0 g
s
.573 .366 .563 r
.93675 .53392 m .92738 .52189 L .92486 .50176 L p F P
0 g
s
.573 .366 .563 r
.92486 .50176 m .9347 .51777 L .93675 .53392 L p F P
0 g
s
.938 .685 .528 r
.18933 .37089 m .18928 .37283 L .21369 .39658 L p F P
0 g
s
.938 .685 .528 r
.21209 .40477 m .21369 .39658 L .18928 .37283 L p F P
0 g
s
.573 .366 .563 r
.77631 .63869 m .79616 .63501 L .79523 .62357 L p F P
0 g
s
.573 .366 .563 r
.79616 .63501 m .77631 .63869 L .7766 .64253 L p F P
0 g
s
.573 .366 .563 r
.79708 .6464 m .7766 .64253 L .77631 .63869 L p F P
0 g
s
.573 .366 .563 r
.77631 .63869 m .79616 .63501 L .79708 .6464 L p F P
0 g
s
.938 .685 .528 r
.28682 .6255 m .27348 .61485 L .27039 .64156 L p F P
0 g
s
.938 .685 .528 r
.27039 .64156 m .28339 .65638 L .28682 .6255 L p F P
0 g
s
.573 .366 .563 r
.93196 .4963 m .94103 .52284 L .94062 .51969 L p F P
0 g
s
.573 .366 .563 r
.94103 .52284 m .93196 .4963 L .93308 .50506 L p F P
0 g
s
.573 .366 .563 r
.94183 .52903 m .93308 .50506 L .93196 .4963 L p F P
0 g
s
.573 .366 .563 r
.93196 .4963 m .94103 .52284 L .94183 .52903 L p F P
0 g
s
.573 .366 .563 r
.75748 .65635 m .73962 .68758 L .74007 .69467 L p F P
0 g
s
.573 .366 .563 r
.74007 .69467 m .75764 .65872 L .75748 .65635 L p F P
0 g
s
.573 .366 .563 r
.73962 .68758 m .75748 .65635 L .75764 .65872 L p F P
0 g
s
.573 .366 .563 r
.75748 .65635 m .73962 .68758 L .73905 .6787 L p F P
0 g
s
.938 .685 .528 r
.28568 .6414 m .29431 .64974 L .28822 .68119 L p F P
0 g
s
.938 .685 .528 r
.29181 .68595 m .28822 .68119 L .29431 .64974 L p F P
0 g
s
.938 .685 .528 r
.21209 .40477 m .20926 .41925 L .22845 .44419 L p F P
0 g
s
.938 .685 .528 r
.22141 .46031 m .22845 .44419 L .20926 .41925 L p F P
0 g
s
.938 .685 .528 r
.22845 .44419 m .22141 .46031 L .23571 .48455 L p F P
0 g
s
.573 .366 .563 r
.81419 .61278 m .79523 .62357 L .79616 .63501 L p F P
0 g
s
.573 .366 .563 r
.8158 .63127 m .79616 .63501 L .79523 .62357 L p F P
0 g
s
.573 .366 .563 r
.79523 .62357 m .81419 .61278 L .8158 .63127 L p F P
0 g
s
.573 .366 .563 r
.89445 .54133 m .87989 .54634 L .88356 .57991 L p F P
0 g
s
.573 .366 .563 r
.86758 .58611 m .88356 .57991 L .87989 .54634 L p F P
0 g
s
.573 .366 .563 r
.89833 .57533 m .88356 .57991 L .87989 .54634 L p F P
0 g
s
.573 .366 .563 r
.87989 .54634 m .89445 .54133 L .89833 .57533 L p F P
0 g
s
.938 .685 .528 r
.20128 .38748 m .19998 .39991 L .22127 .42394 L p F P
0 g
s
.938 .685 .528 r
.2165 .43967 m .22127 .42394 L .19998 .39991 L p F P
0 g
s
.938 .685 .528 r
.22127 .42394 m .2165 .43967 L .23333 .46468 L p F P
0 g
s
.573 .366 .563 r
.75764 .65872 m .74007 .69467 L .74038 .6996 L p F P
0 g
s
.573 .366 .563 r
.74038 .6996 m .75776 .66036 L .75764 .65872 L p F P
0 g
s
.573 .366 .563 r
.74007 .69467 m .75764 .65872 L .75776 .66036 L p F P
0 g
s
.573 .366 .563 r
.75764 .65872 m .74007 .69467 L .73962 .68758 L p F P
0 g
s
.573 .366 .563 r
.92738 .52189 m .91651 .51378 L .91983 .54102 L p F P
0 g
s
.573 .366 .563 r
.90782 .53956 m .91983 .54102 L .91651 .51378 L p F P
0 g
s
.573 .366 .563 r
.93033 .54554 m .91983 .54102 L .91651 .51378 L p F P
0 g
s
.573 .366 .563 r
.91651 .51378 m .92738 .52189 L .93033 .54554 L p F P
0 g
s
.938 .685 .528 r
.2726 .58543 m .25531 .57728 L .25592 .60083 L p F P
0 g
s
.938 .685 .528 r
.25592 .60083 m .27348 .61485 L .2726 .58543 L p F P
0 g
s
.573 .366 .563 r
.6089 .79604 m .61838 .81189 L .61784 .79164 L p F P
0 g
s
.573 .366 .563 r
.61838 .81189 m .6089 .79604 L .60919 .80813 L p F P
0 g
s
.573 .366 .563 r
.61876 .82607 m .60919 .80813 L .6089 .79604 L p F P
0 g
s
.573 .366 .563 r
.6089 .79604 m .61838 .81189 L .61876 .82607 L p F P
0 g
s
.573 .366 .563 r
.7766 .64253 m .79708 .6464 L .79616 .63501 L p F P
0 g
s
.573 .366 .563 r
.79708 .6464 m .7766 .64253 L .77687 .64615 L p F P
0 g
s
.573 .366 .563 r
.79796 .65719 m .77687 .64615 L .7766 .64253 L p F P
0 g
s
.573 .366 .563 r
.7766 .64253 m .79708 .6464 L .79796 .65719 L p F P
0 g
s
.938 .685 .528 r
.18883 .39007 m .18918 .3767 L .21305 .39987 L p F P
0 g
s
.938 .685 .528 r
.21305 .39987 m .21082 .41125 L .18883 .39007 L p F P
0 g
s
.573 .366 .563 r
.75776 .66036 m .74038 .6996 L .74054 .70213 L p F P
0 g
s
.573 .366 .563 r
.74054 .70213 m .75781 .6612 L .75776 .66036 L p F P
0 g
s
.573 .366 .563 r
.74038 .6996 m .75776 .66036 L .75781 .6612 L p F P
0 g
s
.573 .366 .563 r
.75776 .66036 m .74038 .6996 L .74007 .69467 L p F P
0 g
s
.938 .685 .528 r
.22377 .48033 m .23333 .46468 L .2165 .43967 L p F P
0 g
s
.938 .685 .528 r
.23333 .46468 m .22377 .48033 L .23547 .50297 L p F P
0 g
s
.573 .366 .563 r
.75781 .6612 m .74054 .70213 L .74038 .6996 L p F P
0 g
s
.938 .685 .528 r
.22827 .50881 m .24201 .49765 L .2526 .52517 L p F P
0 g
s
.938 .685 .528 r
.2526 .52517 m .23632 .52971 L .22827 .50881 L p F P
0 g
s
.938 .685 .528 r
.23632 .52971 m .2526 .52517 L .26018 .55352 L p F P
0 g
s
.573 .366 .563 r
.73905 .6787 m .72101 .70263 L .72184 .71712 L p F P
0 g
s
.573 .366 .563 r
.72184 .71712 m .73962 .68758 L .73905 .6787 L p F P
0 g
s
.573 .366 .563 r
.72101 .70263 m .73905 .6787 L .73962 .68758 L p F P
0 g
s
.938 .685 .528 r
.2395 .54045 m .25678 .53931 L .24766 .51124 L p F P
0 g
s
.938 .685 .528 r
.25678 .53931 m .2395 .54045 L .244 .56198 L p F P
0 g
s
.938 .685 .528 r
.244 .56198 m .26274 .56766 L .25678 .53931 L p F P
0 g
s
.938 .685 .528 r
.23257 .51913 m .24766 .51124 L .23571 .48455 L p F P
0 g
s
.938 .685 .528 r
.24766 .51124 m .23257 .51913 L .2395 .54045 L p F P
0 g
s
.573 .366 .563 r
.62895 .79895 m .61784 .79164 L .61838 .81189 L p F P
0 g
s
.573 .366 .563 r
.62961 .82119 m .61838 .81189 L .61784 .79164 L p F P
0 g
s
.573 .366 .563 r
.61784 .79164 m .62895 .79895 L .62961 .82119 L p F P
0 g
s
.938 .685 .528 r
.29059 .64615 m .27961 .63555 L .27419 .66258 L p F P
0 g
s
.938 .685 .528 r
.27419 .66258 m .28467 .67648 L .29059 .64615 L p F P
0 g
s
.573 .366 .563 r
.77687 .64615 m .79796 .65719 L .79708 .6464 L p F P
0 g
s
.573 .366 .563 r
.79796 .65719 m .77687 .64615 L .77711 .64938 L p F P
0 g
s
.573 .366 .563 r
.79874 .66687 m .77711 .64938 L .77687 .64615 L p F P
0 g
s
.573 .366 .563 r
.77687 .64615 m .79796 .65719 L .79874 .66687 L p F P
0 g
s
.573 .366 .563 r
.65472 .76652 m .64071 .7714 L .64166 .80012 L p F P
0 g
s
.573 .366 .563 r
.62895 .79895 m .64166 .80012 L .64071 .7714 L p F P
0 g
s
.573 .366 .563 r
.65578 .79493 m .64166 .80012 L .64071 .7714 L p F P
0 g
s
.573 .366 .563 r
.64071 .7714 m .65472 .76652 L .65578 .79493 L p F P
0 g
s
.573 .366 .563 r
.8327 .60276 m .81419 .61278 L .8158 .63127 L p F P
0 g
s
.573 .366 .563 r
.79616 .63501 m .8158 .63127 L .81419 .61278 L p F P
0 g
s
.573 .366 .563 r
.835 .62744 m .8158 .63127 L .81419 .61278 L p F P
0 g
s
.573 .366 .563 r
.81419 .61278 m .8327 .60276 L .835 .62744 L p F P
0 g
s
.938 .685 .528 r
.26018 .55352 m .24207 .55125 L .23632 .52971 L p F P
0 g
s
.938 .685 .528 r
.24207 .55125 m .26018 .55352 L .26445 .58158 L p F P
0 g
s
.573 .366 .563 r
.93308 .50506 m .94183 .52903 L .94103 .52284 L p F P
0 g
s
.573 .366 .563 r
.94183 .52903 m .93308 .50506 L .9347 .51777 L p F P
0 g
s
.573 .366 .563 r
.94299 .53798 m .9347 .51777 L .93308 .50506 L p F P
0 g
s
.573 .366 .563 r
.93308 .50506 m .94183 .52903 L .94299 .53798 L p F P
0 g
s
.938 .685 .528 r
.21822 .48942 m .22882 .47206 L .24201 .49765 L p F P
0 g
s
.938 .685 .528 r
.24201 .49765 m .22827 .50881 L .21822 .48942 L p F P
0 g
s
.573 .366 .563 r
.90782 .53956 m .89445 .54133 L .89833 .57533 L p F P
0 g
s
.573 .366 .563 r
.88356 .57991 m .89833 .57533 L .89445 .54133 L p F P
0 g
s
.573 .366 .563 r
.9117 .57244 m .89833 .57533 L .89445 .54133 L p F P
0 g
s
.573 .366 .563 r
.89445 .54133 m .90782 .53956 L .9117 .57244 L p F P
0 g
s
.938 .685 .528 r
.18928 .37283 m .18903 .38247 L .21209 .40477 L p F P
0 g
s
.938 .685 .528 r
.20926 .41925 m .21209 .40477 L .18903 .38247 L p F P
0 g
s
.573 .366 .563 r
.7994 .67495 m .77732 .65207 L .77711 .64938 L p F P
0 g
s
.573 .366 .563 r
.77711 .64938 m .79874 .66687 L .7994 .67495 L p F P
0 g
s
.573 .366 .563 r
.77711 .64938 m .79874 .66687 L .79796 .65719 L p F P
0 g
s
.573 .366 .563 r
.79874 .66687 m .77711 .64938 L .77732 .65207 L p F P
0 g
s
.938 .685 .528 r
.28071 .62062 m .2652 .60824 L .26445 .58158 L p F P
0 g
s
.938 .685 .528 r
.2652 .60824 m .28071 .62062 L .27743 .64958 L p F P
0 g
s
.938 .685 .528 r
.28822 .66188 m .27743 .64958 L .28071 .62062 L p F P
0 g
s
.573 .366 .563 r
.72101 .70263 m .70334 .72418 L .70435 .74369 L p F P
0 g
s
.573 .366 .563 r
.70435 .74369 m .72184 .71712 L .72101 .70263 L p F P
0 g
s
.573 .366 .563 r
.73962 .68758 m .72184 .71712 L .72101 .70263 L p F P
0 g
s
.573 .366 .563 r
.70334 .72418 m .72101 .70263 L .72184 .71712 L p F P
0 g
s
.573 .366 .563 r
.7999 .68103 m .77747 .65409 L .77732 .65207 L p F P
0 g
s
.573 .366 .563 r
.77732 .65207 m .7994 .67495 L .7999 .68103 L p F P
0 g
s
.573 .366 .563 r
.77732 .65207 m .7994 .67495 L .79874 .66687 L p F P
0 g
s
.573 .366 .563 r
.7994 .67495 m .77732 .65207 L .77747 .65409 L p F P
0 g
s
.938 .685 .528 r
.27353 .60041 m .25602 .58928 L .25382 .56496 L p F P
0 g
s
.938 .685 .528 r
.25602 .58928 m .27353 .60041 L .27243 .62862 L p F P
0 g
s
.938 .685 .528 r
.28568 .6414 m .27243 .62862 L .27353 .60041 L p F P
0 g
s
.573 .366 .563 r
.8158 .63127 m .79616 .63501 L .79708 .6464 L p F P
0 g
s
.573 .366 .563 r
.81741 .64975 m .79708 .6464 L .79616 .63501 L p F P
0 g
s
.573 .366 .563 r
.79616 .63501 m .8158 .63127 L .81741 .64975 L p F P
0 g
s
.938 .685 .528 r
.19674 .43075 m .19906 .40864 L .21908 .43115 L p F P
0 g
s
.938 .685 .528 r
.21908 .43115 m .21354 .44943 L .19674 .43075 L p F P
0 g
s
.938 .685 .528 r
.26274 .56766 m .244 .56198 L .24585 .58282 L p F P
0 g
s
.938 .685 .528 r
.24585 .58282 m .26527 .59516 L .26274 .56766 L p F P
0 g
s
.573 .366 .563 r
.73962 .68758 m .72184 .71712 L .72251 .72872 L p F P
0 g
s
.573 .366 .563 r
.72251 .72872 m .74007 .69467 L .73962 .68758 L p F P
0 g
s
.573 .366 .563 r
.72184 .71712 m .73962 .68758 L .74007 .69467 L p F P
0 g
s
.938 .685 .528 r
.29434 .66884 m .29557 .67025 L .28679 .70027 L p F P
0 g
s
.938 .685 .528 r
.29557 .67025 m .29188 .66605 L .28335 .69499 L p F P
0 g
s
.938 .685 .528 r
.28335 .69499 m .28679 .70027 L .29557 .67025 L p F P
0 g
s
.573 .366 .563 r
.85056 .59379 m .8327 .60276 L .835 .62744 L p F P
0 g
s
.573 .366 .563 r
.8158 .63127 m .835 .62744 L .8327 .60276 L p F P
0 g
s
.573 .366 .563 r
.8535 .62352 m .835 .62744 L .8327 .60276 L p F P
0 g
s
.573 .366 .563 r
.8327 .60276 m .85056 .59379 L .8535 .62352 L p F P
0 g
s
.573 .366 .563 r
.60919 .80813 m .61876 .82607 L .61838 .81189 L p F P
0 g
s
.573 .366 .563 r
.61876 .82607 m .60919 .80813 L .60934 .81435 L p F P
0 g
s
.573 .366 .563 r
.61895 .83337 m .60934 .81435 L .60919 .80813 L p F P
0 g
s
.573 .366 .563 r
.60919 .80813 m .61876 .82607 L .61895 .83337 L p F P
0 g
s
.938 .685 .528 r
.22347 .49887 m .23571 .48455 L .22141 .46031 L p F P
0 g
s
.938 .685 .528 r
.23571 .48455 m .22347 .49887 L .23257 .51913 L p F P
0 g
s
.573 .366 .563 r
.66997 .75677 m .65472 .76652 L .65578 .79493 L p F P
0 g
s
.573 .366 .563 r
.64166 .80012 m .65578 .79493 L .65472 .76652 L p F P
0 g
s
.573 .366 .563 r
.67109 .78345 m .65578 .79493 L .65472 .76652 L p F P
0 g
s
.573 .366 .563 r
.65472 .76652 m .66997 .75677 L .67109 .78345 L p F P
0 g
s
.573 .366 .563 r
.77747 .65409 m .7999 .68103 L .7994 .67495 L p F P
0 g
s
.573 .366 .563 r
.7999 .68103 m .77747 .65409 L .77756 .65534 L p F P
0 g
s
.573 .366 .563 r
.8002 .68481 m .77756 .65534 L .77747 .65409 L p F P
0 g
s
.573 .366 .563 r
.77747 .65409 m .7999 .68103 L .8002 .68481 L p F P
0 g
s
.938 .685 .528 r
.20292 .45165 m .20741 .42871 L .22517 .4517 L p F P
0 g
s
.938 .685 .528 r
.22517 .4517 m .2172 .46995 L .20292 .45165 L p F P
0 g
s
.938 .685 .528 r
.27243 .62862 m .28568 .6414 L .27998 .67025 L p F P
0 g
s
.938 .685 .528 r
.28822 .68119 m .27998 .67025 L .28568 .6414 L p F P
0 g
s
.938 .685 .528 r
.28822 .66188 m .29434 .66884 L .28564 .6985 L p F P
0 g
s
.938 .685 .528 r
.28679 .70027 m .28564 .6985 L .29434 .66884 L p F P
0 g
s
.573 .366 .563 r
.80031 .68609 m .77759 .65576 L .77756 .65534 L p F P
0 g
s
.573 .366 .563 r
.77756 .65534 m .8002 .68481 L .80031 .68609 L p F P
0 g
s
.573 .366 .563 r
.77756 .65534 m .8002 .68481 L .7999 .68103 L p F P
0 g
s
.573 .366 .563 r
.8002 .68481 m .77756 .65534 L .77759 .65576 L p F P
0 g
s
.573 .366 .563 r
.77759 .65576 m .80031 .68609 L .8002 .68481 L p F P
0 g
s
.573 .366 .563 r
.70334 .72418 m .68625 .74247 L .68736 .76613 L p F P
0 g
s
.573 .366 .563 r
.68736 .76613 m .70435 .74369 L .70334 .72418 L p F P
0 g
s
.573 .366 .563 r
.72184 .71712 m .70435 .74369 L .70334 .72418 L p F P
0 g
s
.573 .366 .563 r
.68625 .74247 m .70334 .72418 L .70435 .74369 L p F P
0 g
s
.938 .685 .528 r
.17668 .36356 m .17659 .3615 L .20185 .38208 L p F P
0 g
s
.938 .685 .528 r
.20185 .38208 m .20166 .38389 L .17668 .36356 L p F P
0 g
s
.938 .685 .528 r
.20128 .38748 m .20185 .38208 L .17659 .3615 L p F P
0 g
s
.938 .685 .528 r
.1883 .41051 m .18883 .39007 L .21082 .41125 L p F P
0 g
s
.938 .685 .528 r
.21082 .41125 m .20741 .42871 L .1883 .41051 L p F P
0 g
s
.573 .366 .563 r
.68625 .74247 m .66997 .75677 L .67109 .78345 L p F P
0 g
s
.573 .366 .563 r
.65578 .79493 m .67109 .78345 L .66997 .75677 L p F P
0 g
s
.573 .366 .563 r
.68736 .76613 m .67109 .78345 L .66997 .75677 L p F P
0 g
s
.573 .366 .563 r
.66997 .75677 m .68625 .74247 L .68736 .76613 L p F P
0 g
s
.573 .366 .563 r
.67109 .78345 m .68736 .76613 L .68625 .74247 L p F P
0 g
s
.573 .366 .563 r
.70435 .74369 m .68736 .76613 L .68625 .74247 L p F P
0 g
s
.938 .685 .528 r
.17714 .37378 m .17668 .36356 L .20166 .38389 L p F P
0 g
s
.938 .685 .528 r
.20166 .38389 m .20072 .39284 L .17714 .37378 L p F P
0 g
s
.573 .366 .563 r
.91983 .54102 m .90782 .53956 L .9117 .57244 L p F P
0 g
s
.573 .366 .563 r
.89833 .57533 m .9117 .57244 L .90782 .53956 L p F P
0 g
s
.573 .366 .563 r
.92351 .57125 m .9117 .57244 L .90782 .53956 L p F P
0 g
s
.573 .366 .563 r
.90782 .53956 m .91983 .54102 L .92351 .57125 L p F P
0 g
s
.573 .366 .563 r
.92738 .52189 m .93675 .53392 L .9347 .51777 L p F P
0 g
s
.573 .366 .563 r
.93675 .53392 m .92738 .52189 L .93033 .54554 L p F P
0 g
s
.573 .366 .563 r
.91983 .54102 m .93033 .54554 L .92738 .52189 L p F P
0 g
s
.573 .366 .563 r
.93916 .55285 m .93033 .54554 L .92738 .52189 L p F P
0 g
s
.573 .366 .563 r
.92738 .52189 m .93675 .53392 L .93916 .55285 L p F P
0 g
s
.938 .685 .528 r
.29188 .66605 m .28339 .65638 L .27544 .68288 L p F P
0 g
s
.938 .685 .528 r
.27544 .68288 m .28335 .69499 L .29188 .66605 L p F P
0 g
s
.573 .366 .563 r
.60934 .81435 m .61895 .83337 L .61876 .82607 L p F P
0 g
s
.573 .366 .563 r
.74007 .69467 m .72251 .72872 L .72298 .73681 L p F P
0 g
s
.573 .366 .563 r
.72298 .73681 m .74038 .6996 L .74007 .69467 L p F P
0 g
s
.573 .366 .563 r
.72251 .72872 m .74007 .69467 L .74038 .6996 L p F P
0 g
s
.573 .366 .563 r
.74007 .69467 m .72251 .72872 L .72184 .71712 L p F P
0 g
s
.938 .685 .528 r
.26445 .58158 m .24526 .57254 L .24207 .55125 L p F P
0 g
s
.938 .685 .528 r
.24526 .57254 m .26445 .58158 L .2652 .60824 L p F P
0 g
s
.573 .366 .563 r
.86758 .58611 m .85056 .59379 L .8535 .62352 L p F P
0 g
s
.573 .366 .563 r
.835 .62744 m .8535 .62352 L .85056 .59379 L p F P
0 g
s
.573 .366 .563 r
.87106 .61951 m .8535 .62352 L .85056 .59379 L p F P
0 g
s
.573 .366 .563 r
.85056 .59379 m .86758 .58611 L .87106 .61951 L p F P
0 g
s
.573 .366 .563 r
.9347 .51777 m .94299 .53798 L .94183 .52903 L p F P
0 g
s
.573 .366 .563 r
.94299 .53798 m .9347 .51777 L .93675 .53392 L p F P
0 g
s
.573 .366 .563 r
.94445 .54933 m .93675 .53392 L .9347 .51777 L p F P
0 g
s
.573 .366 .563 r
.9347 .51777 m .94299 .53798 L .94445 .54933 L p F P
0 g
s
.938 .685 .528 r
.20659 .47235 m .21354 .44943 L .22882 .47206 L p F P
0 g
s
.938 .685 .528 r
.22882 .47206 m .21822 .48942 L .20659 .47235 L p F P
0 g
s
.573 .366 .563 r
.64166 .80012 m .62895 .79895 L .62961 .82119 L p F P
0 g
s
.573 .366 .563 r
.61838 .81189 m .62961 .82119 L .62895 .79895 L p F P
0 g
s
.573 .366 .563 r
.64243 .82327 m .62961 .82119 L .62895 .79895 L p F P
0 g
s
.573 .366 .563 r
.62895 .79895 m .64166 .80012 L .64243 .82327 L p F P
0 g
s
.938 .685 .528 r
.17659 .3615 m .17686 .36767 L .20128 .38748 L p F P
0 g
s
.938 .685 .528 r
.19998 .39991 m .20128 .38748 L .17686 .36767 L p F P
0 g
s
.573 .366 .563 r
.79708 .6464 m .81741 .64975 L .8158 .63127 L p F P
0 g
s
.573 .366 .563 r
.81741 .64975 m .79708 .6464 L .79796 .65719 L p F P
0 g
s
.573 .366 .563 r
.81895 .66733 m .79796 .65719 L .79708 .6464 L p F P
0 g
s
.573 .366 .563 r
.79708 .6464 m .81741 .64975 L .81895 .66733 L p F P
0 g
s
.938 .685 .528 r
.27348 .61485 m .25592 .60083 L .25333 .62211 L p F P
0 g
s
.938 .685 .528 r
.25333 .62211 m .27039 .64156 L .27348 .61485 L p F P
0 g
s
.573 .366 .563 r
.74038 .6996 m .72298 .73681 L .72322 .74097 L p F P
0 g
s
.573 .366 .563 r
.72322 .74097 m .74054 .70213 L .74038 .6996 L p F P
0 g
s
.573 .366 .563 r
.72298 .73681 m .74038 .6996 L .74054 .70213 L p F P
0 g
s
.573 .366 .563 r
.74038 .6996 m .72298 .73681 L .72251 .72872 L p F P
0 g
s
.938 .685 .528 r
.27743 .64958 m .28822 .66188 L .27994 .68977 L p F P
0 g
s
.938 .685 .528 r
.28564 .6985 m .27994 .68977 L .28822 .66188 L p F P
0 g
s
.573 .366 .563 r
.62961 .82119 m .61838 .81189 L .61876 .82607 L p F P
0 g
s
.573 .366 .563 r
.63008 .83679 m .61876 .82607 L .61838 .81189 L p F P
0 g
s
.573 .366 .563 r
.61838 .81189 m .62961 .82119 L .63008 .83679 L p F P
0 g
s
.573 .366 .563 r
.72184 .71712 m .70435 .74369 L .70517 .75935 L p F P
0 g
s
.573 .366 .563 r
.70517 .75935 m .72251 .72872 L .72184 .71712 L p F P
0 g
s
.573 .366 .563 r
.70435 .74369 m .72184 .71712 L .72251 .72872 L p F P
0 g
s
.938 .685 .528 r
.27961 .63555 m .26422 .62069 L .25955 .64316 L p F P
0 g
s
.938 .685 .528 r
.25955 .64316 m .27419 .66258 L .27961 .63555 L p F P
0 g
s
.573 .366 .563 r
.835 .62744 m .8158 .63127 L .81741 .64975 L p F P
0 g
s
.573 .366 .563 r
.8373 .6522 m .81741 .64975 L .8158 .63127 L p F P
0 g
s
.573 .366 .563 r
.8158 .63127 m .835 .62744 L .8373 .6522 L p F P
0 g
s
.938 .685 .528 r
.22709 .53229 m .24485 .52733 L .23547 .50297 L p F P
0 g
s
.938 .685 .528 r
.24485 .52733 m .22709 .53229 L .2318 .54996 L p F P
0 g
s
.938 .685 .528 r
.2318 .54996 m .25156 .55244 L .24485 .52733 L p F P
0 g
s
.938 .685 .528 r
.19998 .39991 m .19798 .41895 L .2165 .43967 L p F P
0 g
s
.938 .685 .528 r
.21022 .46036 m .2165 .43967 L .19798 .41895 L p F P
0 g
s
.938 .685 .528 r
.2165 .43967 m .21022 .46036 L .22377 .48033 L p F P
0 g
s
.938 .685 .528 r
.224 .5236 m .24047 .51499 L .24856 .53986 L p F P
0 g
s
.938 .685 .528 r
.24856 .53986 m .2297 .5411 L .224 .5236 L p F P
0 g
s
.938 .685 .528 r
.2297 .5411 m .24856 .53986 L .25382 .56496 L p F P
0 g
s
.938 .685 .528 r
.21653 .507 m .22988 .49137 L .24047 .51499 L p F P
0 g
s
.938 .685 .528 r
.24047 .51499 m .224 .5236 L .21653 .507 L p F P
0 g
s
.573 .366 .563 r
.74054 .70213 m .72322 .74097 L .72298 .73681 L p F P
0 g
s
.573 .366 .563 r
.88356 .57991 m .86758 .58611 L .87106 .61951 L p F P
0 g
s
.573 .366 .563 r
.8535 .62352 m .87106 .61951 L .86758 .58611 L p F P
0 g
s
.573 .366 .563 r
.88744 .61544 m .87106 .61951 L .86758 .58611 L p F P
0 g
s
.573 .366 .563 r
.86758 .58611 m .88356 .57991 L .88744 .61544 L p F P
0 g
s
.573 .366 .563 r
.94849 .55362 m .94103 .52284 L .94062 .51969 L p F P
0 g
s
.573 .366 .563 r
.94062 .51969 m .94827 .55197 L .94849 .55362 L p F P
0 g
s
.573 .366 .563 r
.94827 .55197 m .94062 .51969 L .94103 .52284 L p F P
0 g
s
.938 .685 .528 r
.18903 .38247 m .18859 .39945 L .20926 .41925 L p F P
0 g
s
.938 .685 .528 r
.20529 .43954 m .20926 .41925 L .18859 .39945 L p F P
0 g
s
.938 .685 .528 r
.20926 .41925 m .20529 .43954 L .22141 .46031 L p F P
0 g
s
.938 .685 .528 r
.17795 .39179 m .17714 .37378 L .20072 .39284 L p F P
0 g
s
.938 .685 .528 r
.20072 .39284 m .19906 .40864 L .17795 .39179 L p F P
0 g
s
.938 .685 .528 r
.26527 .59516 m .24585 .58282 L .24494 .60209 L p F P
0 g
s
.938 .685 .528 r
.24494 .60209 m .26422 .62069 L .26527 .59516 L p F P
0 g
s
.938 .685 .528 r
.25156 .55244 m .2318 .54996 L .23439 .56742 L p F P
0 g
s
.938 .685 .528 r
.23439 .56742 m .25531 .57728 L .25156 .55244 L p F P
0 g
s
.938 .685 .528 r
.22047 .51514 m .23547 .50297 L .22377 .48033 L p F P
0 g
s
.938 .685 .528 r
.23547 .50297 m .22047 .51514 L .22709 .53229 L p F P
0 g
s
.573 .366 .563 r
.93033 .54554 m .91983 .54102 L .92351 .57125 L p F P
0 g
s
.573 .366 .563 r
.9117 .57244 m .92351 .57125 L .91983 .54102 L p F P
0 g
s
.573 .366 .563 r
.9336 .57173 m .92351 .57125 L .91983 .54102 L p F P
0 g
s
.573 .366 .563 r
.91983 .54102 m .93033 .54554 L .9336 .57173 L p F P
0 g
s
.938 .685 .528 r
.21257 .48055 m .22141 .46031 L .20529 .43954 L p F P
0 g
s
.938 .685 .528 r
.22141 .46031 m .21257 .48055 L .22347 .49887 L p F P
0 g
s
.573 .366 .563 r
.94103 .52284 m .94849 .55362 L .94827 .55197 L p F P
0 g
s
.573 .366 .563 r
.94849 .55362 m .94103 .52284 L .94183 .52903 L p F P
0 g
s
.573 .366 .563 r
.94891 .55684 m .94183 .52903 L .94103 .52284 L p F P
0 g
s
.573 .366 .563 r
.94103 .52284 m .94849 .55362 L .94891 .55684 L p F P
0 g
s
.938 .685 .528 r
.28339 .65638 m .27039 .64156 L .26336 .66437 L p F P
0 g
s
.938 .685 .528 r
.26336 .66437 m .27544 .68288 L .28339 .65638 L p F P
0 g
s
.938 .685 .528 r
.25382 .56496 m .23337 .55877 L .2297 .5411 L p F P
0 g
s
.938 .685 .528 r
.23337 .55877 m .25382 .56496 L .25602 .58928 L p F P
0 g
s
.573 .366 .563 r
.65578 .79493 m .64166 .80012 L .64243 .82327 L p F P
0 g
s
.573 .366 .563 r
.62961 .82119 m .64243 .82327 L .64166 .80012 L p F P
0 g
s
.573 .366 .563 r
.65663 .81781 m .64243 .82327 L .64166 .80012 L p F P
0 g
s
.573 .366 .563 r
.64166 .80012 m .65578 .79493 L .65663 .81781 L p F P
0 g
s
.938 .685 .528 r
.20757 .492 m .2172 .46995 L .22988 .49137 L p F P
0 g
s
.938 .685 .528 r
.22988 .49137 m .21653 .507 L .20757 .492 L p F P
0 g
s
.573 .366 .563 r
.79796 .65719 m .81895 .66733 L .81741 .64975 L p F P
0 g
s
.573 .366 .563 r
.81895 .66733 m .79796 .65719 L .79874 .66687 L p F P
0 g
s
.573 .366 .563 r
.82033 .68315 m .79874 .66687 L .79796 .65719 L p F P
0 g
s
.573 .366 .563 r
.79796 .65719 m .81895 .66733 L .82033 .68315 L p F P
0 g
s
.573 .366 .563 r
.70435 .74369 m .68736 .76613 L .68825 .78515 L p F P
0 g
s
.573 .366 .563 r
.68825 .78515 m .70517 .75935 L .70435 .74369 L p F P
0 g
s
.573 .366 .563 r
.72251 .72872 m .70517 .75935 L .70435 .74369 L p F P
0 g
s
.573 .366 .563 r
.68736 .76613 m .70435 .74369 L .70517 .75935 L p F P
0 g
s
.938 .685 .528 r
.28822 .68119 m .29181 .68595 L .28054 .71303 L p F P
0 g
s
.938 .685 .528 r
.29181 .68595 m .29061 .68436 L .27945 .71111 L p F P
0 g
s
.938 .685 .528 r
.27945 .71111 m .28054 .71303 L .29181 .68595 L p F P
0 g
s
.573 .366 .563 r
.89833 .57533 m .88356 .57991 L .88744 .61544 L p F P
0 g
s
.573 .366 .563 r
.87106 .61951 m .88744 .61544 L .88356 .57991 L p F P
0 g
s
.573 .366 .563 r
.90243 .61132 m .88744 .61544 L .88356 .57991 L p F P
0 g
s
.573 .366 .563 r
.88356 .57991 m .89833 .57533 L .90243 .61132 L p F P
0 g
s
.938 .685 .528 r
.17686 .36767 m .17751 .38185 L .19998 .39991 L p F P
0 g
s
.938 .685 .528 r
.19798 .41895 m .19998 .39991 L .17751 .38185 L p F P
0 g
s
.573 .366 .563 r
.72251 .72872 m .70517 .75935 L .70574 .77029 L p F P
0 g
s
.573 .366 .563 r
.70574 .77029 m .72298 .73681 L .72251 .72872 L p F P
0 g
s
.573 .366 .563 r
.70517 .75935 m .72251 .72872 L .72298 .73681 L p F P
0 g
s
.938 .685 .528 r
.29061 .68436 m .28467 .67648 L .27406 .70159 L p F P
0 g
s
.938 .685 .528 r
.27406 .70159 m .27945 .71111 L .29061 .68436 L p F P
0 g
s
.573 .366 .563 r
.94183 .52903 m .94891 .55684 L .94849 .55362 L p F P
0 g
s
.573 .366 .563 r
.94891 .55684 m .94183 .52903 L .94299 .53798 L p F P
0 g
s
.573 .366 .563 r
.94951 .5615 m .94299 .53798 L .94183 .52903 L p F P
0 g
s
.573 .366 .563 r
.94183 .52903 m .94891 .55684 L .94951 .5615 L p F P
0 g
s
.938 .685 .528 r
.27243 .62862 m .25503 .61182 L .25602 .58928 L p F P
0 g
s
.938 .685 .528 r
.25503 .61182 m .27243 .62862 L .26736 .65352 L p F P
0 g
s
.938 .685 .528 r
.27998 .67025 m .26736 .65352 L .27243 .62862 L p F P
0 g
s
.573 .366 .563 r
.93675 .53392 m .94445 .54933 L .94299 .53798 L p F P
0 g
s
.573 .366 .563 r
.94445 .54933 m .93675 .53392 L .93916 .55285 L p F P
0 g
s
.573 .366 .563 r
.93033 .54554 m .93916 .55285 L .93675 .53392 L p F P
0 g
s
.573 .366 .563 r
.94616 .56258 m .93916 .55285 L .93675 .53392 L p F P
0 g
s
.573 .366 .563 r
.93675 .53392 m .94445 .54933 L .94616 .56258 L p F P
0 g
s
.573 .366 .563 r
.8535 .62352 m .835 .62744 L .8373 .6522 L p F P
0 g
s
.573 .366 .563 r
.81741 .64975 m .8373 .6522 L .835 .62744 L p F P
0 g
s
.573 .366 .563 r
.85646 .65344 m .8373 .6522 L .835 .62744 L p F P
0 g
s
.573 .366 .563 r
.835 .62744 m .8535 .62352 L .85646 .65344 L p F P
0 g
s
.573 .366 .563 r
.61876 .82607 m .63008 .83679 L .62961 .82119 L p F P
0 g
s
.573 .366 .563 r
.63008 .83679 m .61876 .82607 L .61895 .83337 L p F P
0 g
s
.573 .366 .563 r
.63031 .84483 m .61895 .83337 L .61876 .82607 L p F P
0 g
s
.573 .366 .563 r
.61876 .82607 m .63008 .83679 L .63031 .84483 L p F P
0 g
s
.938 .685 .528 r
.16446 .36051 m .16374 .35404 L .18933 .37089 L p F P
0 g
s
.938 .685 .528 r
.18933 .37089 m .18918 .3767 L .16446 .36051 L p F P
0 g
s
.938 .685 .528 r
.18928 .37283 m .18933 .37089 L .16374 .35404 L p F P
0 g
s
.938 .685 .528 r
.25531 .57728 m .23439 .56742 L .23475 .58392 L p F P
0 g
s
.938 .685 .528 r
.23475 .58392 m .25592 .60083 L .25531 .57728 L p F P
0 g
s
.938 .685 .528 r
.2652 .60824 m .24574 .59271 L .24526 .57254 L p F P
0 g
s
.938 .685 .528 r
.24574 .59271 m .2652 .60824 L .26233 .63238 L p F P
0 g
s
.938 .685 .528 r
.27743 .64958 m .26233 .63238 L .2652 .60824 L p F P
0 g
s
.938 .685 .528 r
.18761 .43728 m .1883 .41051 L .20741 .42871 L p F P
0 g
s
.938 .685 .528 r
.20741 .42871 m .20292 .45165 L .18761 .43728 L p F P
0 g
s
.938 .685 .528 r
.27998 .67025 m .28822 .68119 L .27728 .70728 L p F P
0 g
s
.938 .685 .528 r
.28054 .71303 m .27728 .70728 L .28822 .68119 L p F P
0 g
s
.938 .685 .528 r
.21221 .49925 m .22377 .48033 L .21022 .46036 L p F P
0 g
s
.938 .685 .528 r
.22377 .48033 m .21221 .49925 L .22047 .51514 L p F P
0 g
s
.938 .685 .528 r
.16374 .35404 m .16398 .3562 L .18928 .37283 L p F P
0 g
s
.938 .685 .528 r
.18903 .38247 m .18928 .37283 L .16398 .3562 L p F P
0 g
s
.573 .366 .563 r
.67109 .78345 m .65578 .79493 L .65663 .81781 L p F P
0 g
s
.573 .366 .563 r
.64243 .82327 m .65663 .81781 L .65578 .79493 L p F P
0 g
s
.573 .366 .563 r
.67199 .80493 m .65663 .81781 L .65578 .79493 L p F P
0 g
s
.573 .366 .563 r
.65578 .79493 m .67109 .78345 L .67199 .80493 L p F P
0 g
s
.573 .366 .563 r
.68736 .76613 m .67109 .78345 L .67199 .80493 L p F P
0 g
s
.573 .366 .563 r
.67199 .80493 m .68825 .78515 L .68736 .76613 L p F P
0 g
s
.573 .366 .563 r
.70517 .75935 m .68825 .78515 L .68736 .76613 L p F P
0 g
s
.573 .366 .563 r
.67109 .78345 m .68736 .76613 L .68825 .78515 L p F P
0 g
s
.938 .685 .528 r
.19384 .45836 m .19674 .43075 L .21354 .44943 L p F P
0 g
s
.938 .685 .528 r
.21354 .44943 m .20659 .47235 L .19384 .45836 L p F P
0 g
s
.938 .685 .528 r
.26233 .63238 m .27743 .64958 L .2699 .67438 L p F P
0 g
s
.938 .685 .528 r
.27994 .68977 m .2699 .67438 L .27743 .64958 L p F P
0 g
s
.573 .366 .563 r
.93916 .55285 m .93033 .54554 L .9336 .57173 L p F P
0 g
s
.573 .366 .563 r
.92351 .57125 m .9336 .57173 L .93033 .54554 L p F P
0 g
s
.573 .366 .563 r
.94182 .57375 m .9336 .57173 L .93033 .54554 L p F P
0 g
s
.573 .366 .563 r
.93033 .54554 m .93916 .55285 L .94182 .57375 L p F P
0 g
s
.573 .366 .563 r
.64243 .82327 m .62961 .82119 L .63008 .83679 L p F P
0 g
s
.573 .366 .563 r
.64297 .83951 m .63008 .83679 L .62961 .82119 L p F P
0 g
s
.573 .366 .563 r
.62961 .82119 m .64243 .82327 L .64297 .83951 L p F P
0 g
s
.573 .366 .563 r
.65663 .81781 m .67199 .80493 L .67109 .78345 L p F P
0 g
s
.573 .366 .563 r
.68825 .78515 m .67199 .80493 L .67109 .78345 L p F P
0 g
s
.573 .366 .563 r
.9117 .57244 m .89833 .57533 L .90243 .61132 L p F P
0 g
s
.573 .366 .563 r
.88744 .61544 m .90243 .61132 L .89833 .57533 L p F P
0 g
s
.573 .366 .563 r
.91581 .60722 m .90243 .61132 L .89833 .57533 L p F P
0 g
s
.573 .366 .563 r
.89833 .57533 m .9117 .57244 L .91581 .60722 L p F P
0 g
s
.573 .366 .563 r
.8373 .6522 m .81741 .64975 L .81895 .66733 L p F P
0 g
s
.573 .366 .563 r
.83951 .67585 m .81895 .66733 L .81741 .64975 L p F P
0 g
s
.573 .366 .563 r
.81741 .64975 m .8373 .6522 L .83951 .67585 L p F P
0 g
s
.573 .366 .563 r
.79874 .66687 m .82033 .68315 L .81895 .66733 L p F P
0 g
s
.573 .366 .563 r
.82033 .68315 m .79874 .66687 L .7994 .67495 L p F P
0 g
s
.573 .366 .563 r
.82149 .69641 m .7994 .67495 L .79874 .66687 L p F P
0 g
s
.573 .366 .563 r
.79874 .66687 m .82033 .68315 L .82149 .69641 L p F P
0 g
s
.573 .366 .563 r
.72298 .73681 m .70574 .77029 L .70603 .77592 L p F P
0 g
s
.573 .366 .563 r
.70603 .77592 m .72322 .74097 L .72298 .73681 L p F P
0 g
s
.573 .366 .563 r
.70574 .77029 m .72298 .73681 L .72322 .74097 L p F P
0 g
s
.573 .366 .563 r
.72298 .73681 m .70574 .77029 L .70517 .75935 L p F P
0 g
s
.938 .685 .528 r
.16611 .37537 m .16446 .36051 L .18918 .3767 L p F P
0 g
s
.938 .685 .528 r
.18918 .3767 m .18883 .39007 L .16611 .37537 L p F P
0 g
s
.938 .685 .528 r
.17909 .41689 m .17795 .39179 L .19906 .40864 L p F P
0 g
s
.938 .685 .528 r
.19906 .40864 m .19674 .43075 L .17909 .41689 L p F P
0 g
s
.573 .366 .563 r
.61895 .83337 m .63031 .84483 L .63008 .83679 L p F P
0 g
s
.938 .685 .528 r
.28467 .67648 m .27419 .66258 L .26457 .68485 L p F P
0 g
s
.938 .685 .528 r
.26457 .68485 m .27406 .70159 L .28467 .67648 L p F P
0 g
s
.573 .366 .563 r
.94299 .53798 m .94951 .5615 L .94891 .55684 L p F P
0 g
s
.573 .366 .563 r
.94951 .5615 m .94299 .53798 L .94445 .54933 L p F P
0 g
s
.573 .366 .563 r
.95028 .56739 m .94445 .54933 L .94299 .53798 L p F P
0 g
s
.573 .366 .563 r
.94299 .53798 m .94951 .5615 L .95028 .56739 L p F P
0 g
s
.938 .685 .528 r
.25602 .58928 m .23485 .57584 L .23337 .55877 L p F P
0 g
s
.938 .685 .528 r
.23485 .57584 m .25602 .58928 L .25503 .61182 L p F P
0 g
s
.573 .366 .563 r
.72322 .74097 m .70603 .77592 L .70574 .77029 L p F P
0 g
s
.938 .685 .528 r
.19752 .47926 m .20292 .45165 L .2172 .46995 L p F P
0 g
s
.938 .685 .528 r
.2172 .46995 m .20757 .492 L .19752 .47926 L p F P
0 g
s
.938 .685 .528 r
.21215 .5219 m .22827 .50881 L .23632 .52971 L p F P
0 g
s
.938 .685 .528 r
.23632 .52971 m .21723 .53504 L .21215 .5219 L p F P
0 g
s
.938 .685 .528 r
.21723 .53504 m .23632 .52971 L .24207 .55125 L p F P
0 g
s
.938 .685 .528 r
.16398 .3562 m .16517 .36692 L .18903 .38247 L p F P
0 g
s
.938 .685 .528 r
.18859 .39945 m .18903 .38247 L .16517 .36692 L p F P
0 g
s
.938 .685 .528 r
.21922 .5418 m .2395 .54045 L .23257 .51913 L p F P
0 g
s
.938 .685 .528 r
.2395 .54045 m .21922 .5418 L .22203 .55533 L p F P
0 g
s
.938 .685 .528 r
.22203 .55533 m .244 .56198 L .2395 .54045 L p F P
0 g
s
.938 .685 .528 r
.21486 .52838 m .23257 .51913 L .22347 .49887 L p F P
0 g
s
.938 .685 .528 r
.23257 .51913 m .21486 .52838 L .21922 .5418 L p F P
0 g
s
.573 .366 .563 r
.70517 .75935 m .68825 .78515 L .68887 .79847 L p F P
0 g
s
.573 .366 .563 r
.68887 .79847 m .70574 .77029 L .70517 .75935 L p F P
0 g
s
.573 .366 .563 r
.68825 .78515 m .70517 .75935 L .70574 .77029 L p F P
0 g
s
.573 .366 .563 r
.87106 .61951 m .8535 .62352 L .85646 .65344 L p F P
0 g
s
.573 .366 .563 r
.8373 .6522 m .85646 .65344 L .8535 .62352 L p F P
0 g
s
.573 .366 .563 r
.87457 .6532 m .85646 .65344 L .8535 .62352 L p F P
0 g
s
.573 .366 .563 r
.8535 .62352 m .87106 .61951 L .87457 .6532 L p F P
0 g
s
.573 .366 .563 r
.7994 .67495 m .82149 .69641 L .82033 .68315 L p F P
0 g
s
.573 .366 .563 r
.82149 .69641 m .7994 .67495 L .7999 .68103 L p F P
0 g
s
.573 .366 .563 r
.82236 .70642 m .7999 .68103 L .7994 .67495 L p F P
0 g
s
.573 .366 .563 r
.7994 .67495 m .82149 .69641 L .82236 .70642 L p F P
0 g
s
.938 .685 .528 r
.24207 .55125 m .22083 .54859 L .21723 .53504 L p F P
0 g
s
.938 .685 .528 r
.22083 .54859 m .24207 .55125 L .24526 .57254 L p F P
0 g
s
.938 .685 .528 r
.26422 .62069 m .24494 .60209 L .24129 .61894 L p F P
0 g
s
.938 .685 .528 r
.24129 .61894 m .25955 .64316 L .26422 .62069 L p F P
0 g
s
.573 .366 .563 r
.92351 .57125 m .9117 .57244 L .91581 .60722 L p F P
0 g
s
.573 .366 .563 r
.90243 .61132 m .91581 .60722 L .9117 .57244 L p F P
0 g
s
.573 .366 .563 r
.9274 .60319 m .91581 .60722 L .9117 .57244 L p F P
0 g
s
.573 .366 .563 r
.9117 .57244 m .92351 .57125 L .9274 .60319 L p F P
0 g
s
.938 .685 .528 r
.26736 .65352 m .27998 .67025 L .26981 .69409 L p F P
0 g
s
.938 .685 .528 r
.27728 .70728 m .26981 .69409 L .27998 .67025 L p F P
0 g
s
.938 .685 .528 r
.20581 .50974 m .21822 .48942 L .22827 .50881 L p F P
0 g
s
.938 .685 .528 r
.22827 .50881 m .21215 .5219 L .20581 .50974 L p F P
0 g
s
.938 .685 .528 r
.27039 .64156 m .25333 .62211 L .24756 .64016 L p F P
0 g
s
.938 .685 .528 r
.24756 .64016 m .26336 .66437 L .27039 .64156 L p F P
0 g
s
.938 .685 .528 r
.18859 .39945 m .18798 .42316 L .20529 .43954 L p F P
0 g
s
.938 .685 .528 r
.20032 .46493 m .20529 .43954 L .18798 .42316 L p F P
0 g
s
.938 .685 .528 r
.20529 .43954 m .20032 .46493 L .21257 .48055 L p F P
0 g
s
.938 .685 .528 r
.244 .56198 m .22203 .55533 L .22314 .5684 L p F P
0 g
s
.938 .685 .528 r
.22314 .5684 m .24585 .58282 L .244 .56198 L p F P
0 g
s
.573 .366 .563 r
.65663 .81781 m .64243 .82327 L .64297 .83951 L p F P
0 g
s
.573 .366 .563 r
.63008 .83679 m .64297 .83951 L .64243 .82327 L p F P
0 g
s
.573 .366 .563 r
.65723 .83387 m .64297 .83951 L .64243 .82327 L p F P
0 g
s
.573 .366 .563 r
.64243 .82327 m .65663 .81781 L .65723 .83387 L p F P
0 g
s
.938 .685 .528 r
.16862 .39802 m .16611 .37537 L .18883 .39007 L p F P
0 g
s
.938 .685 .528 r
.18883 .39007 m .1883 .41051 L .16862 .39802 L p F P
0 g
s
.938 .685 .528 r
.19798 .41895 m .19535 .44393 L .21022 .46036 L p F P
0 g
s
.938 .685 .528 r
.17751 .38185 m .17848 .4035 L .19798 .41895 L p F P
0 g
s
.938 .685 .528 r
.19535 .44393 m .19798 .41895 L .17848 .4035 L p F P
0 g
s
.938 .685 .528 r
.20912 .51566 m .22347 .49887 L .21257 .48055 L p F P
0 g
s
.938 .685 .528 r
.22347 .49887 m .20912 .51566 L .21486 .52838 L p F P
0 g
s
.938 .685 .528 r
.25592 .60083 m .23475 .58392 L .23282 .59875 L p F P
0 g
s
.938 .685 .528 r
.23282 .59875 m .25333 .62211 L .25592 .60083 L p F P
0 g
s
.573 .366 .563 r
.93916 .55285 m .94616 .56258 L .94445 .54933 L p F P
0 g
s
.573 .366 .563 r
.94616 .56258 m .93916 .55285 L .94182 .57375 L p F P
0 g
s
.573 .366 .563 r
.9336 .57173 m .94182 .57375 L .93916 .55285 L p F P
0 g
s
.573 .366 .563 r
.94804 .57716 m .94182 .57375 L .93916 .55285 L p F P
0 g
s
.573 .366 .563 r
.93916 .55285 m .94616 .56258 L .94804 .57716 L p F P
0 g
s
.573 .366 .563 r
.7999 .68103 m .82236 .70642 L .82149 .69641 L p F P
0 g
s
.573 .366 .563 r
.82236 .70642 m .7999 .68103 L .8002 .68481 L p F P
0 g
s
.573 .366 .563 r
.8229 .71265 m .8002 .68481 L .7999 .68103 L p F P
0 g
s
.573 .366 .563 r
.7999 .68103 m .82236 .70642 L .8229 .71265 L p F P
0 g
s
.573 .366 .563 r
.64297 .83951 m .63008 .83679 L .63031 .84483 L p F P
0 g
s
.573 .366 .563 r
.64325 .84788 m .63031 .84483 L .63008 .83679 L p F P
0 g
s
.573 .366 .563 r
.63008 .83679 m .64297 .83951 L .64325 .84788 L p F P
0 g
s
.573 .366 .563 r
.94445 .54933 m .95028 .56739 L .94951 .5615 L p F P
0 g
s
.573 .366 .563 r
.95028 .56739 m .94445 .54933 L .94616 .56258 L p F P
0 g
s
.573 .366 .563 r
.95117 .57425 m .94616 .56258 L .94445 .54933 L p F P
0 g
s
.573 .366 .563 r
.94445 .54933 m .95028 .56739 L .95117 .57425 L p F P
0 g
s
.938 .685 .528 r
.20266 .48531 m .21022 .46036 L .19535 .44393 L p F P
0 g
s
.938 .685 .528 r
.21022 .46036 m .20266 .48531 L .21221 .49925 L p F P
0 g
s
.938 .685 .528 r
.28564 .6985 m .28679 .70027 L .27308 .72405 L p F P
0 g
s
.938 .685 .528 r
.28679 .70027 m .28335 .69499 L .27006 .71788 L p F P
0 g
s
.938 .685 .528 r
.27006 .71788 m .27308 .72405 L .28679 .70027 L p F P
0 g
s
.573 .366 .563 r
.68825 .78515 m .67199 .80493 L .67262 .81999 L p F P
0 g
s
.573 .366 .563 r
.67262 .81999 m .68887 .79847 L .68825 .78515 L p F P
0 g
s
.573 .366 .563 r
.70574 .77029 m .68887 .79847 L .68825 .78515 L p F P
0 g
s
.573 .366 .563 r
.67199 .80493 m .68825 .78515 L .68887 .79847 L p F P
0 g
s
.573 .366 .563 r
.70574 .77029 m .68887 .79847 L .68919 .80533 L p F P
0 g
s
.573 .366 .563 r
.68919 .80533 m .70603 .77592 L .70574 .77029 L p F P
0 g
s
.573 .366 .563 r
.68887 .79847 m .70574 .77029 L .70603 .77592 L p F P
0 g
s
.938 .685 .528 r
.27419 .66258 m .25955 .64316 L .25137 .66154 L p F P
0 g
s
.938 .685 .528 r
.25137 .66154 m .26457 .68485 L .27419 .66258 L p F P
0 g
s
.938 .685 .528 r
.27994 .68977 m .28564 .6985 L .27207 .72199 L p F P
0 g
s
.938 .685 .528 r
.27308 .72405 m .27207 .72199 L .28564 .6985 L p F P
0 g
s
.938 .685 .528 r
.24526 .57254 m .2228 .56196 L .22083 .54859 L p F P
0 g
s
.938 .685 .528 r
.2228 .56196 m .24526 .57254 L .24574 .59271 L p F P
0 g
s
.573 .366 .563 r
.9336 .57173 m .92351 .57125 L .9274 .60319 L p F P
0 g
s
.573 .366 .563 r
.91581 .60722 m .9274 .60319 L .92351 .57125 L p F P
0 g
s
.573 .366 .563 r
.93705 .59932 m .9274 .60319 L .92351 .57125 L p F P
0 g
s
.573 .366 .563 r
.92351 .57125 m .9336 .57173 L .93705 .59932 L p F P
0 g
s
.573 .366 .563 r
.88744 .61544 m .87106 .61951 L .87457 .6532 L p F P
0 g
s
.573 .366 .563 r
.85646 .65344 m .87457 .6532 L .87106 .61951 L p F P
0 g
s
.573 .366 .563 r
.89137 .65131 m .87457 .6532 L .87106 .61951 L p F P
0 g
s
.573 .366 .563 r
.87106 .61951 m .88744 .61544 L .89137 .65131 L p F P
0 g
s
.573 .366 .563 r
.81895 .66733 m .83951 .67585 L .8373 .6522 L p F P
0 g
s
.573 .366 .563 r
.83951 .67585 m .81895 .66733 L .82033 .68315 L p F P
0 g
s
.573 .366 .563 r
.8415 .6972 m .82033 .68315 L .81895 .66733 L p F P
0 g
s
.573 .366 .563 r
.81895 .66733 m .83951 .67585 L .8415 .6972 L p F P
0 g
s
.573 .366 .563 r
.8002 .68481 m .8229 .71265 L .82236 .70642 L p F P
0 g
s
.573 .366 .563 r
.8229 .71265 m .8002 .68481 L .80031 .68609 L p F P
0 g
s
.573 .366 .563 r
.82309 .71477 m .80031 .68609 L .8002 .68481 L p F P
0 g
s
.573 .366 .563 r
.8002 .68481 m .8229 .71265 L .82309 .71477 L p F P
0 g
s
.938 .685 .528 r
.19848 .4991 m .20659 .47235 L .21822 .48942 L p F P
0 g
s
.938 .685 .528 r
.21822 .48942 m .20581 .50974 L .19848 .4991 L p F P
0 g
s
.573 .366 .563 r
.80031 .68609 m .82309 .71477 L .8229 .71265 L p F P
0 g
s
.573 .366 .563 r
.85646 .65344 m .8373 .6522 L .83951 .67585 L p F P
0 g
s
.573 .366 .563 r
.85929 .6821 m .83951 .67585 L .8373 .6522 L p F P
0 g
s
.573 .366 .563 r
.8373 .6522 m .85646 .65344 L .85929 .6821 L p F P
0 g
s
.573 .366 .563 r
.67199 .80493 m .65663 .81781 L .65723 .83387 L p F P
0 g
s
.573 .366 .563 r
.64297 .83951 m .65723 .83387 L .65663 .81781 L p F P
0 g
s
.573 .366 .563 r
.67262 .81999 m .65723 .83387 L .65663 .81781 L p F P
0 g
s
.573 .366 .563 r
.65663 .81781 m .67199 .80493 L .67262 .81999 L p F P
0 g
s
.938 .685 .528 r
.15131 .35088 m .15093 .34864 L .17659 .3615 L p F P
0 g
s
.938 .685 .528 r
.17659 .3615 m .17668 .36356 L .15131 .35088 L p F P
0 g
s
.938 .685 .528 r
.17686 .36767 m .17659 .3615 L .15093 .34864 L p F P
0 g
s
.938 .685 .528 r
.28335 .69499 m .27544 .68288 L .26312 .70373 L p F P
0 g
s
.938 .685 .528 r
.26312 .70373 m .27006 .71788 L .28335 .69499 L p F P
0 g
s
.573 .366 .563 r
.65723 .83387 m .67262 .81999 L .67199 .80493 L p F P
0 g
s
.573 .366 .563 r
.68887 .79847 m .67262 .81999 L .67199 .80493 L p F P
0 g
s
.938 .685 .528 r
.16517 .36692 m .16726 .38577 L .18859 .39945 L p F P
0 g
s
.938 .685 .528 r
.18798 .42316 m .18859 .39945 L .16726 .38577 L p F P
0 g
s
.573 .366 .563 r
.94827 .55197 m .95405 .58729 L .94849 .55362 L closepath p F P
0 g
s
.573 .366 .563 r
.94849 .55362 m .95405 .58729 L .94827 .55197 L closepath p F P
0 g
s
.938 .685 .528 r
.15324 .36199 m .15131 .35088 L .17668 .36356 L p F P
0 g
s
.938 .685 .528 r
.17668 .36356 m .17714 .37378 L .15324 .36199 L p F P
0 g
s
.573 .366 .563 r
.63031 .84483 m .64325 .84788 L .64297 .83951 L p F P
0 g
s
.573 .366 .563 r
.94849 .55362 m .95405 .58729 L .94891 .55684 L closepath p F P
0 g
s
.573 .366 .563 r
.94891 .55684 m .95405 .58729 L .94849 .55362 L closepath p F P
0 g
s
.573 .366 .563 r
.70603 .77592 m .68919 .80533 L .68887 .79847 L p F P
0 g
s
.938 .685 .528 r
.26233 .63238 m .24346 .61087 L .24574 .59271 L p F P
0 g
s
.938 .685 .528 r
.24346 .61087 m .26233 .63238 L .25589 .65292 L p F P
0 g
s
.938 .685 .528 r
.2699 .67438 m .25589 .65292 L .26233 .63238 L p F P
0 g
s
.938 .685 .528 r
.24585 .58282 m .22314 .5684 L .2225 .58042 L p F P
0 g
s
.938 .685 .528 r
.2225 .58042 m .24494 .60209 L .24585 .58282 L p F P
0 g
s
.938 .685 .528 r
.15093 .34864 m .15209 .35535 L .17686 .36767 L p F P
0 g
s
.938 .685 .528 r
.17751 .38185 m .17686 .36767 L .15209 .35535 L p F P
0 g
s
.938 .685 .528 r
.25503 .61182 m .23407 .59159 L .23485 .57584 L p F P
0 g
s
.938 .685 .528 r
.23407 .59159 m .25503 .61182 L .25083 .6316 L p F P
0 g
s
.938 .685 .528 r
.26736 .65352 m .25083 .6316 L .25503 .61182 L p F P
0 g
s
.938 .685 .528 r
.2699 .67438 m .27994 .68977 L .26706 .71178 L p F P
0 g
s
.938 .685 .528 r
.27207 .72199 m .26706 .71178 L .27994 .68977 L p F P
0 g
s
.938 .685 .528 r
.1805 .44812 m .17909 .41689 L .19674 .43075 L p F P
0 g
s
.938 .685 .528 r
.19674 .43075 m .19384 .45836 L .1805 .44812 L p F P
0 g
s
.938 .685 .528 r
.20225 .5042 m .21257 .48055 L .20032 .46493 L p F P
0 g
s
.938 .685 .528 r
.21257 .48055 m .20225 .5042 L .20912 .51566 L p F P
0 g
s
.573 .366 .563 r
.94891 .55684 m .95405 .58729 L .94951 .5615 L closepath p F P
0 g
s
.573 .366 .563 r
.94951 .5615 m .95405 .58729 L .94891 .55684 L closepath p F P
0 g
s
.573 .366 .563 r
.94182 .57375 m .9336 .57173 L .93705 .59932 L p F P
0 g
s
.573 .366 .563 r
.9274 .60319 m .93705 .59932 L .9336 .57173 L p F P
0 g
s
.573 .366 .563 r
.94462 .59569 m .93705 .59932 L .9336 .57173 L p F P
0 g
s
.573 .366 .563 r
.9336 .57173 m .94182 .57375 L .94462 .59569 L p F P
0 g
s
.938 .685 .528 r
.18678 .46937 m .18761 .43728 L .20292 .45165 L p F P
0 g
s
.938 .685 .528 r
.20292 .45165 m .19752 .47926 L .18678 .46937 L p F P
0 g
s
.938 .685 .528 r
.25083 .6316 m .26736 .65352 L .25841 .67396 L p F P
0 g
s
.938 .685 .528 r
.26981 .69409 m .25841 .67396 L .26736 .65352 L p F P
0 g
s
.573 .366 .563 r
.90243 .61132 m .88744 .61544 L .89137 .65131 L p F P
0 g
s
.573 .366 .563 r
.87457 .6532 m .89137 .65131 L .88744 .61544 L p F P
0 g
s
.573 .366 .563 r
.90657 .64768 m .89137 .65131 L .88744 .61544 L p F P
0 g
s
.573 .366 .563 r
.88744 .61544 m .90243 .61132 L .90657 .64768 L p F P
0 g
s
.573 .366 .563 r
.65723 .83387 m .64297 .83951 L .64325 .84788 L p F P
0 g
s
.573 .366 .563 r
.65754 .84215 m .64325 .84788 L .64297 .83951 L p F P
0 g
s
.573 .366 .563 r
.64297 .83951 m .65723 .83387 L .65754 .84215 L p F P
0 g
s
.573 .366 .563 r
.94616 .56258 m .95117 .57425 L .95028 .56739 L p F P
0 g
s
.573 .366 .563 r
.95117 .57425 m .94616 .56258 L .94804 .57716 L p F P
0 g
s
.573 .366 .563 r
.94182 .57375 m .94804 .57716 L .94616 .56258 L p F P
0 g
s
.573 .366 .563 r
.95215 .58176 m .94804 .57716 L .94616 .56258 L p F P
0 g
s
.573 .366 .563 r
.94616 .56258 m .95117 .57425 L .95215 .58176 L p F P
0 g
s
.573 .366 .563 r
.68887 .79847 m .67262 .81999 L .67294 .82776 L p F P
0 g
s
.573 .366 .563 r
.67294 .82776 m .68919 .80533 L .68887 .79847 L p F P
0 g
s
.573 .366 .563 r
.67262 .81999 m .68887 .79847 L .68919 .80533 L p F P
0 g
s
.938 .685 .528 r
.15663 .3815 m .15324 .36199 L .17714 .37378 L p F P
0 g
s
.938 .685 .528 r
.17714 .37378 m .17795 .39179 L .15663 .3815 L p F P
0 g
s
.594 .534 .758 r
.51258 .39405 m .49929 .39818 L .51446 .43917 L p F P
0 g
s
.594 .534 .758 r
.51446 .43917 m .5276 .43471 L .51258 .39405 L p F P
0 g
s
.726 .606 .722 r
.49939 .44402 m .51446 .43917 L .49929 .39818 L p F P
0 g
s
.578 .484 .711 r
.5276 .43471 m .51446 .43917 L .52615 .48106 L p F P
0 g
s
.714 .566 .686 r
.51446 .43917 m .49939 .44402 L .51065 .48448 L p F P
0 g
s
.714 .566 .686 r
.51065 .48448 m .52615 .48106 L .51446 .43917 L p F P
0 g
s
.938 .685 .528 r
.1719 .42758 m .16862 .39802 L .1883 .41051 L p F P
0 g
s
.938 .685 .528 r
.1883 .41051 m .18761 .43728 L .1719 .42758 L p F P
0 g
s
.938 .685 .528 r
.27544 .68288 m .26336 .66437 L .25255 .68218 L p F P
0 g
s
.938 .685 .528 r
.25255 .68218 m .26312 .70373 L .27544 .68288 L p F P
0 g
s
.726 .606 .722 r
.49929 .39818 m .48472 .40447 L .49939 .44402 L p F P
0 g
s
.811 .646 .678 r
.48249 .44926 m .49939 .44402 L .48472 .40447 L p F P
0 g
s
.802 .616 .65 r
.49939 .44402 m .48249 .44926 L .49284 .48652 L p F P
0 g
s
.802 .616 .65 r
.49284 .48652 m .51065 .48448 L .49939 .44402 L p F P
0 g
s
.573 .366 .563 r
.95028 .56739 m .95405 .58729 L .94951 .5615 L closepath p F P
0 g
s
.573 .366 .563 r
.94951 .5615 m .95405 .58729 L .95028 .56739 L closepath p F P
0 g
s
.938 .685 .528 r
.20683 .53794 m .22709 .53229 L .22047 .51514 L p F P
0 g
s
.938 .685 .528 r
.22709 .53229 m .20683 .53794 L .20927 .54714 L p F P
0 g
s
.938 .685 .528 r
.20927 .54714 m .2318 .54996 L .22709 .53229 L p F P
0 g
s
.938 .685 .528 r
.20522 .53342 m .224 .5236 L .2297 .5411 L p F P
0 g
s
.938 .685 .528 r
.2297 .5411 m .20818 .54253 L .20522 .53342 L p F P
0 g
s
.938 .685 .528 r
.20818 .54253 m .2297 .5411 L .23337 .55877 L p F P
0 g
s
.938 .685 .528 r
.20131 .52479 m .21653 .507 L .224 .5236 L p F P
0 g
s
.938 .685 .528 r
.224 .5236 m .20522 .53342 L .20131 .52479 L p F P
0 g
s
.938 .685 .528 r
.24574 .59271 m .22304 .57458 L .2228 .56196 L p F P
0 g
s
.938 .685 .528 r
.22304 .57458 m .24574 .59271 L .24346 .61087 L p F P
0 g
s
.938 .685 .528 r
.2318 .54996 m .20927 .54714 L .21059 .55621 L p F P
0 g
s
.938 .685 .528 r
.21059 .55621 m .23439 .56742 L .2318 .54996 L p F P
0 g
s
.573 .366 .563 r
.82033 .68315 m .8415 .6972 L .83951 .67585 L p F P
0 g
s
.573 .366 .563 r
.8415 .6972 m .82033 .68315 L .82149 .69641 L p F P
0 g
s
.573 .366 .563 r
.84317 .71515 m .82149 .69641 L .82033 .68315 L p F P
0 g
s
.573 .366 .563 r
.82033 .68315 m .8415 .6972 L .84317 .71515 L p F P
0 g
s
.938 .685 .528 r
.20337 .52902 m .22047 .51514 L .21221 .49925 L p F P
0 g
s
.938 .685 .528 r
.22047 .51514 m .20337 .52902 L .20683 .53794 L p F P
0 g
s
.938 .685 .528 r
.19047 .49045 m .19384 .45836 L .20659 .47235 L p F P
0 g
s
.938 .685 .528 r
.20659 .47235 m .19848 .4991 L .19047 .49045 L p F P
0 g
s
.938 .685 .528 r
.15209 .35535 m .15476 .37073 L .17751 .38185 L p F P
0 g
s
.938 .685 .528 r
.17848 .4035 m .17751 .38185 L .15476 .37073 L p F P
0 g
s
.578 .484 .711 r
.52615 .48106 m .53922 .47625 L .5276 .43471 L p F P
0 g
s
.557 .427 .659 r
.53922 .47625 m .52615 .48106 L .53392 .52236 L p F P
0 g
s
.703 .525 .644 r
.52615 .48106 m .51065 .48448 L .51807 .52436 L p F P
0 g
s
.703 .525 .644 r
.51807 .52436 m .53392 .52236 L .52615 .48106 L p F P
0 g
s
.573 .366 .563 r
.67262 .81999 m .65723 .83387 L .65754 .84215 L p F P
0 g
s
.573 .366 .563 r
.64325 .84788 m .65754 .84215 L .65723 .83387 L p F P
0 g
s
.573 .366 .563 r
.67294 .82776 m .65754 .84215 L .65723 .83387 L p F P
0 g
s
.573 .366 .563 r
.65723 .83387 m .67262 .81999 L .67294 .82776 L p F P
0 g
s
.573 .366 .563 r
.65754 .84215 m .67294 .82776 L .67262 .81999 L p F P
0 g
s
.573 .366 .563 r
.68919 .80533 m .67294 .82776 L .67262 .81999 L p F P
0 g
s
.573 .366 .563 r
.94804 .57716 m .94182 .57375 L .94462 .59569 L p F P
0 g
s
.573 .366 .563 r
.93705 .59932 m .94462 .59569 L .94182 .57375 L p F P
0 g
s
.573 .366 .563 r
.95001 .59241 m .94462 .59569 L .94182 .57375 L p F P
0 g
s
.573 .366 .563 r
.94182 .57375 m .94804 .57716 L .95001 .59241 L p F P
0 g
s
.605 .583 .802 r
.49468 .35576 m .48116 .35959 L .49929 .39818 L p F P
0 g
s
.605 .583 .802 r
.49929 .39818 m .51258 .39405 L .49468 .35576 L p F P
0 g
s
.739 .646 .756 r
.48472 .40447 m .49929 .39818 L .48116 .35959 L p F P
0 g
s
.796 .586 .617 r
.51065 .48448 m .49284 .48652 L .49958 .52323 L p F P
0 g
s
.796 .586 .617 r
.49958 .52323 m .51807 .52436 L .51065 .48448 L p F P
0 g
s
.938 .685 .528 r
.23337 .55877 m .21008 .55171 L .20818 .54253 L p F P
0 g
s
.938 .685 .528 r
.21008 .55171 m .23337 .55877 L .23485 .57584 L p F P
0 g
s
.573 .366 .563 r
.95028 .56739 m .95405 .58729 L .95117 .57425 L closepath p F P
0 g
s
.573 .366 .563 r
.95117 .57425 m .95405 .58729 L .95028 .56739 L closepath p F P
0 g
s
.573 .366 .563 r
.87457 .6532 m .85646 .65344 L .85929 .6821 L p F P
0 g
s
.573 .366 .563 r
.83951 .67585 m .85929 .6821 L .85646 .65344 L p F P
0 g
s
.573 .366 .563 r
.87794 .68555 m .85929 .6821 L .85646 .65344 L p F P
0 g
s
.573 .366 .563 r
.85646 .65344 m .87457 .6532 L .87794 .68555 L p F P
0 g
s
.573 .366 .563 r
.91581 .60722 m .90243 .61132 L .90657 .64768 L p F P
0 g
s
.573 .366 .563 r
.89137 .65131 m .90657 .64768 L .90243 .61132 L p F P
0 g
s
.573 .366 .563 r
.91996 .64232 m .90657 .64768 L .90243 .61132 L p F P
0 g
s
.573 .366 .563 r
.90243 .61132 m .91581 .60722 L .91996 .64232 L p F P
0 g
s
.938 .685 .528 r
.19664 .51703 m .20757 .492 L .21653 .507 L p F P
0 g
s
.938 .685 .528 r
.21653 .507 m .20131 .52479 L .19664 .51703 L p F P
0 g
s
.739 .646 .756 r
.48116 .35959 m .46714 .36725 L .48472 .40447 L p F P
0 g
s
.823 .678 .703 r
.46895 .41285 m .48472 .40447 L .46714 .36725 L p F P
0 g
s
.811 .646 .678 r
.48472 .40447 m .46895 .41285 L .48249 .44926 L p F P
0 g
s
.938 .685 .528 r
.25333 .62211 m .23282 .59875 L .22867 .61122 L p F P
0 g
s
.938 .685 .528 r
.22867 .61122 m .24756 .64016 L .25333 .62211 L p F P
0 g
s
.938 .685 .528 r
.25589 .65292 m .2699 .67438 L .25826 .69383 L p F P
0 g
s
.938 .685 .528 r
.26706 .71178 m .25826 .69383 L .2699 .67438 L p F P
0 g
s
.938 .685 .528 r
.25955 .64316 m .24129 .61894 L .23498 .6326 L p F P
0 g
s
.938 .685 .528 r
.23498 .6326 m .25137 .66154 L .25955 .64316 L p F P
0 g
s
.938 .685 .528 r
.19535 .44393 m .1922 .47392 L .20266 .48531 L p F P
0 g
s
.938 .685 .528 r
.17848 .4035 m .17976 .43181 L .19535 .44393 L p F P
0 g
s
.938 .685 .528 r
.1922 .47392 m .19535 .44393 L .17976 .43181 L p F P
0 g
s
.938 .685 .528 r
.23439 .56742 m .21059 .55621 L .21073 .56475 L p F P
0 g
s
.938 .685 .528 r
.21073 .56475 m .23475 .58392 L .23439 .56742 L p F P
0 g
s
.404 .422 .765 r
.52462 .39209 m .51258 .39405 L .5276 .43471 L p F P
0 g
s
.404 .422 .765 r
.5276 .43471 m .53884 .43065 L .52462 .39209 L p F P
0 g
s
.384 .36 .709 r
.53884 .43065 m .5276 .43471 L .53922 .47625 L p F P
0 g
s
.938 .685 .528 r
.16133 .4086 m .15663 .3815 L .17795 .39179 L p F P
0 g
s
.938 .685 .528 r
.17795 .39179 m .17909 .41689 L .16133 .4086 L p F P
0 g
s
.938 .685 .528 r
.16726 .38577 m .17017 .41201 L .18798 .42316 L p F P
0 g
s
.938 .685 .528 r
.18721 .45274 m .18798 .42316 L .17017 .41201 L p F P
0 g
s
.938 .685 .528 r
.18798 .42316 m .18721 .45274 L .20032 .46493 L p F P
0 g
s
.938 .685 .528 r
.19906 .52078 m .21221 .49925 L .20266 .48531 L p F P
0 g
s
.938 .685 .528 r
.21221 .49925 m .19906 .52078 L .20337 .52902 L p F P
0 g
s
.938 .685 .528 r
.27728 .70728 m .28054 .71303 L .26449 .73319 L p F P
0 g
s
.938 .685 .528 r
.28054 .71303 m .27945 .71111 L .26356 .731 L p F P
0 g
s
.938 .685 .528 r
.26356 .731 m .26449 .73319 L .28054 .71303 L p F P
0 g
s
.938 .685 .528 r
.24494 .60209 m .2225 .58042 L .22012 .59086 L p F P
0 g
s
.938 .685 .528 r
.22012 .59086 m .24129 .61894 L .24494 .60209 L p F P
0 g
s
.573 .366 .563 r
.85929 .6821 m .83951 .67585 L .8415 .6972 L p F P
0 g
s
.573 .366 .563 r
.86185 .70806 m .8415 .6972 L .83951 .67585 L p F P
0 g
s
.573 .366 .563 r
.83951 .67585 m .85929 .6821 L .86185 .70806 L p F P
0 g
s
.938 .685 .528 r
.27945 .71111 m .27406 .70159 L .25901 .72018 L p F P
0 g
s
.938 .685 .528 r
.25901 .72018 m .26356 .731 L .27945 .71111 L p F P
0 g
s
.573 .366 .563 r
.95215 .58176 m .95405 .58729 L .95117 .57425 L closepath p F P
0 g
s
.573 .366 .563 r
.94804 .57716 m .95215 .58176 L .95117 .57425 L p F P
0 g
s
.573 .366 .563 r
.95117 .57425 m .95405 .58729 L .95215 .58176 L closepath p F P
0 g
s
.573 .366 .563 r
.95215 .58176 m .94804 .57716 L .95001 .59241 L p F P
0 g
s
.573 .366 .563 r
.94462 .59569 m .95001 .59241 L .94804 .57716 L p F P
0 g
s
.573 .366 .563 r
.95317 .58957 m .95001 .59241 L .94804 .57716 L p F P
0 g
s
.573 .366 .563 r
.94804 .57716 m .95215 .58176 L .95317 .58957 L p F P
0 g
s
.938 .685 .528 r
.19454 .4945 m .20032 .46493 L .18721 .45274 L p F P
0 g
s
.938 .685 .528 r
.20032 .46493 m .19454 .4945 L .20225 .5042 L p F P
0 g
s
.573 .366 .563 r
.9274 .60319 m .91581 .60722 L .91996 .64232 L p F P
0 g
s
.573 .366 .563 r
.90657 .64768 m .91996 .64232 L .91581 .60722 L p F P
0 g
s
.573 .366 .563 r
.93132 .63537 m .91996 .64232 L .91581 .60722 L p F P
0 g
s
.573 .366 .563 r
.91581 .60722 m .9274 .60319 L .93132 .63537 L p F P
0 g
s
.864 .668 .636 r
.46396 .45482 m .48249 .44926 L .46895 .41285 L p F P
0 g
s
.858 .646 .614 r
.48249 .44926 m .46396 .45482 L .47293 .48722 L p F P
0 g
s
.858 .646 .614 r
.47293 .48722 m .49284 .48652 L .48249 .44926 L p F P
0 g
s
.938 .685 .528 r
.26981 .69409 m .27728 .70728 L .26173 .72665 L p F P
0 g
s
.938 .685 .528 r
.26449 .73319 m .26173 .72665 L .27728 .70728 L p F P
0 g
s
.938 .685 .528 r
.26336 .66437 m .24756 .64016 L .23879 .65412 L p F P
0 g
s
.938 .685 .528 r
.23879 .65412 m .25255 .68218 L .26336 .66437 L p F P
0 g
s
.938 .685 .528 r
.23485 .57584 m .21081 .56057 L .21008 .55171 L p F P
0 g
s
.938 .685 .528 r
.21081 .56057 m .23485 .57584 L .23407 .59159 L p F P
0 g
s
.384 .36 .709 r
.53922 .47625 m .54987 .47004 L .53884 .43065 L p F P
0 g
s
.345 .283 .643 r
.54987 .47004 m .53922 .47625 L .54699 .51719 L p F P
0 g
s
.557 .427 .659 r
.53392 .52236 m .54699 .51719 L .53922 .47625 L p F P
0 g
s
.938 .685 .528 r
.1399 .35228 m .13829 .34541 L .16374 .35404 L p F P
0 g
s
.938 .685 .528 r
.16374 .35404 m .16446 .36051 L .1399 .35228 L p F P
0 g
s
.938 .685 .528 r
.16398 .3562 m .16374 .35404 L .13829 .34541 L p F P
0 g
s
.573 .366 .563 r
.82149 .69641 m .84317 .71515 L .8415 .6972 L p F P
0 g
s
.573 .366 .563 r
.84317 .71515 m .82149 .69641 L .82236 .70642 L p F P
0 g
s
.573 .366 .563 r
.84443 .72873 m .82236 .70642 L .82149 .69641 L p F P
0 g
s
.573 .366 .563 r
.82149 .69641 m .84317 .71515 L .84443 .72873 L p F P
0 g
s
.938 .685 .528 r
.19141 .51049 m .19752 .47926 L .20757 .492 L p F P
0 g
s
.938 .685 .528 r
.20757 .492 m .19664 .51703 L .19141 .51049 L p F P
0 g
s
.409 .475 .817 r
.50771 .35576 m .49468 .35576 L .51258 .39405 L p F P
0 g
s
.409 .475 .817 r
.51258 .39405 m .52462 .39209 L .50771 .35576 L p F P
0 g
s
.938 .685 .528 r
.13829 .34541 m .13883 .34771 L .16398 .3562 L p F P
0 g
s
.938 .685 .528 r
.16517 .36692 m .16398 .3562 L .13883 .34771 L p F P
0 g
s
.938 .685 .528 r
.27406 .70159 m .26457 .68485 L .25101 .7012 L p F P
0 g
s
.938 .685 .528 r
.25101 .7012 m .25901 .72018 L .27406 .70159 L p F P
0 g
s
.938 .685 .528 r
.15476 .37073 m .15882 .39416 L .17848 .4035 L p F P
0 g
s
.938 .685 .528 r
.17976 .43181 m .17848 .4035 L .15882 .39416 L p F P
0 g
s
.938 .685 .528 r
.14359 .36804 m .1399 .35228 L .16446 .36051 L p F P
0 g
s
.938 .685 .528 r
.16446 .36051 m .16611 .37537 L .14359 .36804 L p F P
0 g
s
.573 .366 .563 r
.93705 .59932 m .9274 .60319 L .93132 .63537 L p F P
0 g
s
.573 .366 .563 r
.91996 .64232 m .93132 .63537 L .9274 .60319 L p F P
0 g
s
.573 .366 .563 r
.94051 .62704 m .93132 .63537 L .9274 .60319 L p F P
0 g
s
.573 .366 .563 r
.9274 .60319 m .93705 .59932 L .94051 .62704 L p F P
0 g
s
.854 .623 .588 r
.49284 .48652 m .47293 .48722 L .47871 .51913 L p F P
0 g
s
.854 .623 .588 r
.47871 .51913 m .49958 .52323 L .49284 .48652 L p F P
0 g
s
.938 .685 .528 r
.25083 .6316 m .23101 .60532 L .23407 .59159 L p F P
0 g
s
.938 .685 .528 r
.23101 .60532 m .25083 .6316 L .24353 .6477 L p F P
0 g
s
.938 .685 .528 r
.25841 .67396 m .24353 .6477 L .25083 .6316 L p F P
0 g
s
.823 .678 .703 r
.46714 .36725 m .45269 .37864 L .46895 .41285 L p F P
0 g
s
.874 .692 .653 r
.45216 .42317 m .46895 .41285 L .45269 .37864 L p F P
0 g
s
.864 .668 .636 r
.46895 .41285 m .45216 .42317 L .46396 .45482 L p F P
0 g
s
.573 .366 .563 r
.95317 .58957 m .95405 .58729 L .95215 .58176 L closepath p F P
0 g
s
.573 .366 .563 r
.95001 .59241 m .95317 .58957 L .95215 .58176 L p F P
0 g
s
.573 .366 .563 r
.95215 .58176 m .95405 .58729 L .95317 .58957 L closepath p F P
0 g
s
.573 .366 .563 r
.89137 .65131 m .87457 .6532 L .87794 .68555 L p F P
0 g
s
.573 .366 .563 r
.85929 .6821 m .87794 .68555 L .87457 .6532 L p F P
0 g
s
.573 .366 .563 r
.89514 .6858 m .87794 .68555 L .87457 .6532 L p F P
0 g
s
.573 .366 .563 r
.87457 .6532 m .89137 .65131 L .89514 .6858 L p F P
0 g
s
.528 .359 .595 r
.54699 .51719 m .53392 .52236 L .53742 .56155 L p F P
0 g
s
.693 .48 .595 r
.53392 .52236 m .51807 .52436 L .52131 .56218 L p F P
0 g
s
.693 .48 .595 r
.52131 .56218 m .53742 .56155 L .53392 .52236 L p F P
0 g
s
.938 .685 .528 r
.24346 .61087 m .22152 .58587 L .22304 .57458 L p F P
0 g
s
.938 .685 .528 r
.22152 .58587 m .24346 .61087 L .23845 .62622 L p F P
0 g
s
.938 .685 .528 r
.25589 .65292 m .23845 .62622 L .24346 .61087 L p F P
0 g
s
.938 .685 .528 r
.23475 .58392 m .21073 .56475 L .20967 .57237 L p F P
0 g
s
.938 .685 .528 r
.20967 .57237 m .23282 .59875 L .23475 .58392 L p F P
0 g
s
.938 .685 .528 r
.13883 .34771 m .14149 .35909 L .16517 .36692 L p F P
0 g
s
.938 .685 .528 r
.16726 .38577 m .16517 .36692 L .14149 .35909 L p F P
0 g
s
.793 .555 .578 r
.51807 .52436 m .49958 .52323 L .50242 .55802 L p F P
0 g
s
.793 .555 .578 r
.50242 .55802 m .52131 .56218 L .51807 .52436 L p F P
0 g
s
.938 .685 .528 r
.17581 .4628 m .1719 .42758 L .18761 .43728 L p F P
0 g
s
.938 .685 .528 r
.18761 .43728 m .18678 .46937 L .17581 .4628 L p F P
0 g
s
.938 .685 .528 r
.25841 .67396 m .26981 .69409 L .25542 .71167 L p F P
0 g
s
.938 .685 .528 r
.26173 .72665 m .25542 .71167 L .26981 .69409 L p F P
0 g
s
.938 .685 .528 r
.19408 .51359 m .20266 .48531 L .1922 .47392 L p F P
0 g
s
.938 .685 .528 r
.20266 .48531 m .19408 .51359 L .19906 .52078 L p F P
0 g
s
.573 .366 .563 r
.94462 .59569 m .93705 .59932 L .94051 .62704 L p F P
0 g
s
.573 .366 .563 r
.93132 .63537 m .94051 .62704 L .93705 .59932 L p F P
0 g
s
.573 .366 .563 r
.94741 .61766 m .94051 .62704 L .93705 .59932 L p F P
0 g
s
.573 .366 .563 r
.93705 .59932 m .94462 .59569 L .94741 .61766 L p F P
0 g
s
.613 .633 .846 r
.4745 .32126 m .46068 .32484 L .48116 .35959 L p F P
0 g
s
.613 .633 .846 r
.48116 .35959 m .49468 .35576 L .4745 .32126 L p F P
0 g
s
.755 .689 .789 r
.46714 .36725 m .48116 .35959 L .46068 .32484 L p F P
0 g
s
.938 .685 .528 r
.18213 .48421 m .1805 .44812 L .19384 .45836 L p F P
0 g
s
.938 .685 .528 r
.19384 .45836 m .19047 .49045 L .18213 .48421 L p F P
0 g
s
.755 .689 .789 r
.46068 .32484 m .44726 .33379 L .46714 .36725 L p F P
0 g
s
.838 .712 .725 r
.45269 .37864 m .46714 .36725 L .44726 .33379 L p F P
0 g
s
.938 .685 .528 r
.23845 .62622 m .25589 .65292 L .24604 .66889 L p F P
0 g
s
.938 .685 .528 r
.25826 .69383 m .24604 .66889 L .25589 .65292 L p F P
0 g
s
.573 .366 .563 r
.82236 .70642 m .84443 .72873 L .84317 .71515 L p F P
0 g
s
.573 .366 .563 r
.84443 .72873 m .82236 .70642 L .8229 .71265 L p F P
0 g
s
.573 .366 .563 r
.84522 .7372 m .8229 .71265 L .82236 .70642 L p F P
0 g
s
.573 .366 .563 r
.82236 .70642 m .84443 .72873 L .84522 .7372 L p F P
0 g
s
.573 .366 .563 r
.95001 .59241 m .94462 .59569 L .94741 .61766 L p F P
0 g
s
.573 .366 .563 r
.94051 .62704 m .94741 .61766 L .94462 .59569 L p F P
0 g
s
.573 .366 .563 r
.95197 .60762 m .94741 .61766 L .94462 .59569 L p F P
0 g
s
.573 .366 .563 r
.94462 .59569 m .95001 .59241 L .95197 .60762 L p F P
0 g
s
.938 .685 .528 r
.19424 .53644 m .21215 .5219 L .21723 .53504 L p F P
0 g
s
.938 .685 .528 r
.21723 .53504 m .19599 .54096 L .19424 .53644 L p F P
0 g
s
.938 .685 .528 r
.19599 .54096 m .21723 .53504 L .22083 .54859 L p F P
0 g
s
.938 .685 .528 r
.1492 .39199 m .14359 .36804 L .16611 .37537 L p F P
0 g
s
.938 .685 .528 r
.16611 .37537 m .16862 .39802 L .1492 .39199 L p F P
0 g
s
.573 .366 .563 r
.95418 .59733 m .95405 .58729 L .95513 .60467 L closepath p F P
0 g
s
.573 .366 .563 r
.95317 .58957 m .95405 .58729 L .95418 .59733 L closepath p F P
0 g
s
.573 .366 .563 r
.95418 .59733 m .95405 .58729 L .95317 .58957 L closepath p F P
0 g
s
.573 .366 .563 r
.95513 .60467 m .95405 .58729 L .95418 .59733 L closepath p F P
0 g
s
.573 .366 .563 r
.95599 .61124 m .95405 .58729 L .95513 .60467 L closepath p F P
0 g
s
.573 .366 .563 r
.95757 .62339 m .95405 .58729 L .95768 .62426 L closepath p F P
0 g
s
.573 .366 .563 r
.95723 .62084 m .95405 .58729 L .95757 .62339 L closepath p F P
0 g
s
.573 .366 .563 r
.9567 .61672 m .95405 .58729 L .95723 .62084 L closepath p F P
0 g
s
.573 .366 .563 r
.95599 .61124 m .95405 .58729 L .9567 .61672 L closepath p F P
0 g
s
.573 .366 .563 r
.95513 .60467 m .95405 .58729 L .95599 .61124 L closepath p F P
0 g
s
.573 .366 .563 r
.9567 .61672 m .95405 .58729 L .95599 .61124 L closepath p F P
0 g
s
.573 .366 .563 r
.95723 .62084 m .95405 .58729 L .9567 .61672 L closepath p F P
0 g
s
.573 .366 .563 r
.95757 .62339 m .95405 .58729 L .95723 .62084 L closepath p F P
0 g
s
.573 .366 .563 r
.95768 .62426 m .95405 .58729 L .95757 .62339 L closepath p F P
0 g
s
.938 .685 .528 r
.19668 .54329 m .21922 .5418 L .21486 .52838 L p F P
0 g
s
.938 .685 .528 r
.21922 .5418 m .19668 .54329 L .19764 .54795 L p F P
0 g
s
.938 .685 .528 r
.19764 .54795 m .22203 .55533 L .21922 .5418 L p F P
0 g
s
.938 .685 .528 r
.19518 .53867 m .21486 .52838 L .20912 .51566 L p F P
0 g
s
.938 .685 .528 r
.21486 .52838 m .19518 .53867 L .19668 .54329 L p F P
0 g
s
.938 .685 .528 r
.16715 .44214 m .16133 .4086 L .17909 .41689 L p F P
0 g
s
.938 .685 .528 r
.17909 .41689 m .1805 .44812 L .16715 .44214 L p F P
0 g
s
.573 .366 .563 r
.95317 .58957 m .95001 .59241 L .95197 .60762 L p F P
0 g
s
.573 .366 .563 r
.94741 .61766 m .95197 .60762 L .95001 .59241 L p F P
0 g
s
.573 .366 .563 r
.95418 .59733 m .95197 .60762 L .95001 .59241 L p F P
0 g
s
.573 .366 .563 r
.95001 .59241 m .95317 .58957 L .95418 .59733 L p F P
0 g
s
.938 .685 .528 r
.26457 .68485 m .25137 .66154 L .23993 .67488 L p F P
0 g
s
.938 .685 .528 r
.23993 .67488 m .25101 .7012 L .26457 .68485 L p F P
0 g
s
.573 .366 .563 r
.95197 .60762 m .95418 .59733 L .95317 .58957 L p F P
0 g
s
.938 .685 .528 r
.22083 .54859 m .19723 .54563 L .19599 .54096 L p F P
0 g
s
.938 .685 .528 r
.19723 .54563 m .22083 .54859 L .2228 .56196 L p F P
0 g
s
.938 .685 .528 r
.19205 .53227 m .20581 .50974 L .21215 .5219 L p F P
0 g
s
.938 .685 .528 r
.21215 .5219 m .19424 .53644 L .19205 .53227 L p F P
0 g
s
.938 .685 .528 r
.23407 .59159 m .21035 .5687 L .21081 .56057 L p F P
0 g
s
.938 .685 .528 r
.21035 .5687 m .23407 .59159 L .23101 .60532 L p F P
0 g
s
.938 .685 .528 r
.22203 .55533 m .19764 .54795 L .198 .55243 L p F P
0 g
s
.938 .685 .528 r
.198 .55243 m .22314 .5684 L .22203 .55533 L p F P
0 g
s
.938 .685 .528 r
.18584 .50547 m .18678 .46937 L .19752 .47926 L p F P
0 g
s
.938 .685 .528 r
.19752 .47926 m .19141 .51049 L .18584 .50547 L p F P
0 g
s
.938 .685 .528 r
.19319 .5343 m .20912 .51566 L .20225 .5042 L p F P
0 g
s
.938 .685 .528 r
.20912 .51566 m .19319 .5343 L .19518 .53867 L p F P
0 g
s
.573 .366 .563 r
.8229 .71265 m .84522 .7372 L .84443 .72873 L p F P
0 g
s
.573 .366 .563 r
.84522 .7372 m .8229 .71265 L .82309 .71477 L p F P
0 g
s
.573 .366 .563 r
.84549 .74007 m .82309 .71477 L .8229 .71265 L p F P
0 g
s
.573 .366 .563 r
.8229 .71265 m .84522 .7372 L .84549 .74007 L p F P
0 g
s
.938 .685 .528 r
.14149 .35909 m .14617 .37905 L .16726 .38577 L p F P
0 g
s
.938 .685 .528 r
.17017 .41201 m .16726 .38577 L .14617 .37905 L p F P
0 g
s
.573 .366 .563 r
.90657 .64768 m .89137 .65131 L .89514 .6858 L p F P
0 g
s
.573 .366 .563 r
.87794 .68555 m .89514 .6858 L .89137 .65131 L p F P
0 g
s
.573 .366 .563 r
.91056 .68264 m .89514 .6858 L .89137 .65131 L p F P
0 g
s
.573 .366 .563 r
.89137 .65131 m .90657 .64768 L .91056 .68264 L p F P
0 g
s
.573 .366 .563 r
.8415 .6972 m .86185 .70806 L .85929 .6821 L p F P
0 g
s
.573 .366 .563 r
.86185 .70806 m .8415 .6972 L .84317 .71515 L p F P
0 g
s
.573 .366 .563 r
.86401 .72993 m .84317 .71515 L .8415 .6972 L p F P
0 g
s
.573 .366 .563 r
.8415 .6972 m .86185 .70806 L .86401 .72993 L p F P
0 g
s
.345 .283 .643 r
.54699 .51719 m .5573 .50882 L .54987 .47004 L p F P
0 g
s
.282 .179 .557 r
.5573 .50882 m .54699 .51719 L .55058 .556 L p F P
0 g
s
.528 .359 .595 r
.53742 .56155 m .55058 .556 L .54699 .51719 L p F P
0 g
s
.938 .685 .528 r
.24129 .61894 m .22012 .59086 L .21608 .59923 L p F P
0 g
s
.938 .685 .528 r
.21608 .59923 m .23498 .6326 L .24129 .61894 L p F P
0 g
s
.573 .366 .563 r
.82309 .71477 m .84549 .74007 L .84522 .7372 L p F P
0 g
s
.573 .366 .563 r
.87794 .68555 m .85929 .6821 L .86185 .70806 L p F P
0 g
s
.573 .366 .563 r
.881 .7149 m .86185 .70806 L .85929 .6821 L p F P
0 g
s
.573 .366 .563 r
.85929 .6821 m .87794 .68555 L .881 .7149 L p F P
0 g
s
.938 .685 .528 r
.2228 .56196 m .19789 .55023 L .19723 .54563 L p F P
0 g
s
.938 .685 .528 r
.19789 .55023 m .2228 .56196 L .22304 .57458 L p F P
0 g
s
.938 .685 .528 r
.24353 .6477 m .25841 .67396 L .24583 .6889 L p F P
0 g
s
.938 .685 .528 r
.25542 .71167 m .24583 .6889 L .25841 .67396 L p F P
0 g
s
.175 .276 .729 r
.53548 .39221 m .52462 .39209 L .53884 .43065 L p F P
0 g
s
.175 .276 .729 r
.53884 .43065 m .54828 .42696 L .53548 .39221 L p F P
0 g
s
.15 .205 .665 r
.54828 .42696 m .53884 .43065 L .54987 .47004 L p F P
0 g
s
.938 .685 .528 r
.18952 .52864 m .19848 .4991 L .20581 .50974 L p F P
0 g
s
.938 .685 .528 r
.20581 .50974 m .19205 .53227 L .18952 .52864 L p F P
0 g
s
.938 .685 .528 r
.24756 .64016 m .22867 .61122 L .22243 .62074 L p F P
0 g
s
.938 .685 .528 r
.22243 .62074 m .23879 .65412 L .24756 .64016 L p F P
0 g
s
.853 .602 .558 r
.49958 .52323 m .47871 .51913 L .48103 .54929 L p F P
0 g
s
.853 .602 .558 r
.48103 .54929 m .50242 .55802 L .49958 .52323 L p F P
0 g
s
.396 .521 .866 r
.48869 .32308 m .4745 .32126 L .49468 .35576 L p F P
0 g
s
.396 .521 .866 r
.49468 .35576 m .50771 .35576 L .48869 .32308 L p F P
0 g
s
.938 .685 .528 r
.17017 .41201 m .17379 .44457 L .18721 .45274 L p F P
0 g
s
.938 .685 .528 r
.18632 .48701 m .18721 .45274 L .17379 .44457 L p F P
0 g
s
.938 .685 .528 r
.18721 .45274 m .18632 .48701 L .19454 .4945 L p F P
0 g
s
.573 .366 .563 r
.95418 .59733 m .95197 .60762 L .95384 .62206 L p F P
0 g
s
.573 .366 .563 r
.95384 .62206 m .95513 .60467 L .95418 .59733 L p F P
0 g
s
.573 .366 .563 r
.95197 .60762 m .95418 .59733 L .95513 .60467 L p F P
0 g
s
.838 .712 .725 r
.44726 .33379 m .43429 .34795 L .45269 .37864 L p F P
0 g
s
.886 .717 .667 r
.43796 .39349 m .45269 .37864 L .43429 .34795 L p F P
0 g
s
.874 .692 .653 r
.45269 .37864 m .43796 .39349 L .45216 .42317 L p F P
0 g
s
.938 .685 .528 r
.15882 .39416 m .16411 .42465 L .17976 .43181 L p F P
0 g
s
.938 .685 .528 r
.18129 .46564 m .17976 .43181 L .16411 .42465 L p F P
0 g
s
.938 .685 .528 r
.17976 .43181 m .18129 .46564 L .1922 .47392 L p F P
0 g
s
.938 .685 .528 r
.27207 .72199 m .27308 .72405 L .25481 .74027 L p F P
0 g
s
.938 .685 .528 r
.27308 .72405 m .27006 .71788 L .25237 .73343 L p F P
0 g
s
.938 .685 .528 r
.25237 .73343 m .25481 .74027 L .27308 .72405 L p F P
0 g
s
.938 .685 .528 r
.15649 .42308 m .1492 .39199 L .16862 .39802 L p F P
0 g
s
.938 .685 .528 r
.16862 .39802 m .1719 .42758 L .15649 .42308 L p F P
0 g
s
.938 .685 .528 r
.22314 .5684 m .198 .55243 L .19775 .55654 L p F P
0 g
s
.938 .685 .528 r
.19775 .55654 m .2225 .58042 L .22314 .5684 L p F P
0 g
s
.938 .685 .528 r
.23282 .59875 m .20967 .57237 L .20745 .57873 L p F P
0 g
s
.938 .685 .528 r
.20745 .57873 m .22867 .61122 L .23282 .59875 L p F P
0 g
s
.938 .685 .528 r
.26706 .71178 m .27207 .72199 L .25399 .73799 L p F P
0 g
s
.938 .685 .528 r
.25481 .74027 m .25399 .73799 L .27207 .72199 L p F P
0 g
s
.938 .685 .528 r
.19082 .53037 m .20225 .5042 L .19454 .4945 L p F P
0 g
s
.938 .685 .528 r
.20225 .5042 m .19082 .53037 L .19319 .5343 L p F P
0 g
s
.938 .685 .528 r
.1922 .47392 m .18865 .50778 L .19408 .51359 L p F P
0 g
s
.938 .685 .528 r
.18865 .50778 m .1922 .47392 L .18129 .46564 L p F P
0 g
s
.15 .205 .665 r
.54987 .47004 m .55823 .46244 L .54828 .42696 L p F P
0 g
s
.092 .107 .582 r
.55823 .46244 m .54987 .47004 L .5573 .50882 L p F P
0 g
s
.938 .685 .528 r
.27006 .71788 m .26312 .70373 L .24679 .71778 L p F P
0 g
s
.938 .685 .528 r
.24679 .71778 m .25237 .73343 L .27006 .71788 L p F P
0 g
s
.899 .68 .597 r
.44413 .46061 m .46396 .45482 L .45216 .42317 L p F P
0 g
s
.894 .663 .581 r
.46396 .45482 m .44413 .46061 L .45131 .48663 L p F P
0 g
s
.894 .663 .581 r
.45131 .48663 m .47293 .48722 L .46396 .45482 L p F P
0 g
s
.169 .327 .781 r
.5203 .3595 m .50771 .35576 L .52462 .39209 L p F P
0 g
s
.169 .327 .781 r
.52462 .39209 m .53548 .39221 L .5203 .3595 L p F P
0 g
s
.573 .366 .563 r
.91996 .64232 m .90657 .64768 L .91056 .68264 L p F P
0 g
s
.573 .366 .563 r
.89514 .6858 m .91056 .68264 L .90657 .64768 L p F P
0 g
s
.573 .366 .563 r
.92395 .67606 m .91056 .68264 L .90657 .64768 L p F P
0 g
s
.573 .366 .563 r
.90657 .64768 m .91996 .64232 L .92395 .67606 L p F P
0 g
s
.938 .685 .528 r
.25137 .66154 m .23498 .6326 L .22624 .64237 L p F P
0 g
s
.938 .685 .528 r
.22624 .64237 m .23993 .67488 L .25137 .66154 L p F P
0 g
s
.938 .685 .528 r
.12666 .34678 m .12597 .34444 L .15093 .34864 L p F P
0 g
s
.938 .685 .528 r
.15093 .34864 m .15131 .35088 L .12666 .34678 L p F P
0 g
s
.938 .685 .528 r
.15209 .35535 m .15093 .34864 L .12597 .34444 L p F P
0 g
s
.938 .685 .528 r
.25826 .69383 m .26706 .71178 L .24996 .72667 L p F P
0 g
s
.938 .685 .528 r
.25399 .73799 m .24996 .72667 L .26706 .71178 L p F P
0 g
s
.573 .366 .563 r
.95513 .60467 m .95384 .62206 L .95551 .63504 L p F P
0 g
s
.573 .366 .563 r
.95551 .63504 m .95599 .61124 L .95513 .60467 L p F P
0 g
s
.573 .366 .563 r
.95384 .62206 m .95513 .60467 L .95599 .61124 L p F P
0 g
s
.573 .366 .563 r
.95513 .60467 m .95384 .62206 L .95197 .60762 L p F P
0 g
s
.573 .366 .563 r
.95197 .60762 m .94741 .61766 L .95008 .63862 L p F P
0 g
s
.573 .366 .563 r
.95008 .63862 m .95384 .62206 L .95197 .60762 L p F P
0 g
s
.573 .366 .563 r
.94741 .61766 m .95197 .60762 L .95384 .62206 L p F P
0 g
s
.938 .685 .528 r
.22304 .57458 m .19795 .55454 L .19789 .55023 L p F P
0 g
s
.938 .685 .528 r
.19795 .55454 m .22304 .57458 L .22152 .58587 L p F P
0 g
s
.938 .685 .528 r
.13006 .3583 m .12666 .34678 L .15131 .35088 L p F P
0 g
s
.938 .685 .528 r
.15131 .35088 m .15324 .36199 L .13006 .3583 L p F P
0 g
s
.938 .685 .528 r
.18676 .52572 m .19047 .49045 L .19848 .4991 L p F P
0 g
s
.938 .685 .528 r
.19848 .4991 m .18952 .52864 L .18676 .52572 L p F P
0 g
s
.892 .647 .562 r
.47293 .48722 m .45131 .48663 L .45587 .51222 L p F P
0 g
s
.892 .647 .562 r
.45587 .51222 m .47871 .51913 L .47293 .48722 L p F P
0 g
s
.938 .685 .528 r
.12597 .34444 m .12803 .35141 L .15209 .35535 L p F P
0 g
s
.938 .685 .528 r
.15476 .37073 m .15209 .35535 L .12803 .35141 L p F P
0 g
s
.938 .685 .528 r
.14617 .37905 m .15265 .40672 L .17017 .41201 L p F P
0 g
s
.938 .685 .528 r
.17379 .44457 m .17017 .41201 L .15265 .40672 L p F P
0 g
s
.906 .698 .61 r
.43463 .43521 m .45216 .42317 L .43796 .39349 L p F P
0 g
s
.899 .68 .597 r
.45216 .42317 m .43463 .43521 L .44413 .46061 L p F P
0 g
s
.938 .685 .528 r
.23845 .62622 m .2183 .59533 L .22152 .58587 L p F P
0 g
s
.938 .685 .528 r
.2183 .59533 m .23845 .62622 L .23089 .63801 L p F P
0 g
s
.938 .685 .528 r
.24604 .66889 m .23089 .63801 L .23845 .62622 L p F P
0 g
s
.938 .685 .528 r
.26312 .70373 m .25255 .68218 L .23831 .69401 L p F P
0 g
s
.938 .685 .528 r
.23831 .69401 m .24679 .71778 L .26312 .70373 L p F P
0 g
s
.938 .685 .528 r
.13601 .3785 m .13006 .3583 L .15324 .36199 L p F P
0 g
s
.938 .685 .528 r
.15324 .36199 m .15663 .3815 L .13601 .3785 L p F P
0 g
s
.938 .685 .528 r
.23101 .60532 m .2087 .57573 L .21035 .5687 L p F P
0 g
s
.938 .685 .528 r
.2087 .57573 m .23101 .60532 L .2258 .61638 L p F P
0 g
s
.938 .685 .528 r
.24353 .6477 m .2258 .61638 L .23101 .60532 L p F P
0 g
s
.573 .366 .563 r
.93132 .63537 m .91996 .64232 L .92395 .67606 L p F P
0 g
s
.573 .366 .563 r
.91056 .68264 m .92395 .67606 L .91996 .64232 L p F P
0 g
s
.573 .366 .563 r
.93508 .66624 m .92395 .67606 L .91996 .64232 L p F P
0 g
s
.573 .366 .563 r
.91996 .64232 m .93132 .63537 L .93508 .66624 L p F P
0 g
s
.938 .685 .528 r
.17384 .48068 m .16715 .44214 L .1805 .44812 L p F P
0 g
s
.938 .685 .528 r
.1805 .44812 m .18213 .48421 L .17384 .48068 L p F P
0 g
s
.573 .366 .563 r
.94741 .61766 m .94051 .62704 L .94382 .65358 L p F P
0 g
s
.573 .366 .563 r
.94382 .65358 m .95008 .63862 L .94741 .61766 L p F P
0 g
s
.573 .366 .563 r
.95384 .62206 m .95008 .63862 L .94741 .61766 L p F P
0 g
s
.573 .366 .563 r
.94051 .62704 m .94741 .61766 L .95008 .63862 L p F P
0 g
s
.938 .685 .528 r
.2225 .58042 m .19775 .55654 L .1969 .56007 L p F P
0 g
s
.938 .685 .528 r
.1969 .56007 m .22012 .59086 L .2225 .58042 L p F P
0 g
s
.938 .685 .528 r
.18019 .50221 m .17581 .4628 L .18678 .46937 L p F P
0 g
s
.938 .685 .528 r
.18678 .46937 m .18584 .50547 L .18019 .50221 L p F P
0 g
s
.573 .366 .563 r
.95599 .61124 m .95551 .63504 L .95692 .6459 L p F P
0 g
s
.573 .366 .563 r
.95692 .6459 m .9567 .61672 L .95599 .61124 L p F P
0 g
s
.573 .366 .563 r
.95551 .63504 m .95599 .61124 L .9567 .61672 L p F P
0 g
s
.573 .366 .563 r
.95599 .61124 m .95551 .63504 L .95384 .62206 L p F P
0 g
s
.573 .366 .563 r
.84317 .71515 m .86401 .72993 L .86185 .70806 L p F P
0 g
s
.573 .366 .563 r
.86401 .72993 m .84317 .71515 L .84443 .72873 L p F P
0 g
s
.573 .366 .563 r
.86565 .74651 m .84443 .72873 L .84317 .71515 L p F P
0 g
s
.573 .366 .563 r
.84317 .71515 m .86401 .72993 L .86565 .74651 L p F P
0 g
s
.681 .428 .533 r
.53742 .56155 m .52131 .56218 L .52015 .59647 L p F P
0 g
s
.792 .523 .531 r
.52131 .56218 m .50242 .55802 L .50114 .58948 L p F P
0 g
s
.792 .523 .531 r
.50114 .58948 m .52015 .59647 L .52131 .56218 L p F P
0 g
s
.938 .685 .528 r
.18816 .52708 m .19454 .4945 L .18632 .48701 L p F P
0 g
s
.938 .685 .528 r
.19454 .4945 m .18816 .52708 L .19082 .53037 L p F P
0 g
s
.938 .685 .528 r
.2258 .61638 m .24353 .6477 L .23337 .65932 L p F P
0 g
s
.938 .685 .528 r
.24583 .6889 m .23337 .65932 L .24353 .6477 L p F P
0 g
s
.938 .685 .528 r
.24604 .66889 m .25826 .69383 L .24289 .70685 L p F P
0 g
s
.938 .685 .528 r
.24996 .72667 m .24289 .70685 L .25826 .69383 L p F P
0 g
s
.484 .268 .51 r
.55058 .556 m .53742 .56155 L .5364 .59709 L p F P
0 g
s
.681 .428 .533 r
.52015 .59647 m .5364 .59709 L .53742 .56155 L p F P
0 g
s
.938 .685 .528 r
.12803 .35141 m .13273 .36736 L .15476 .37073 L p F P
0 g
s
.938 .685 .528 r
.15882 .39416 m .15476 .37073 L .13273 .36736 L p F P
0 g
s
.573 .366 .563 r
.94051 .62704 m .93132 .63537 L .93508 .66624 L p F P
0 g
s
.573 .366 .563 r
.92395 .67606 m .93508 .66624 L .93132 .63537 L p F P
0 g
s
.573 .366 .563 r
.94382 .65358 m .93508 .66624 L .93132 .63537 L p F P
0 g
s
.573 .366 .563 r
.93132 .63537 m .94051 .62704 L .94382 .65358 L p F P
0 g
s
.573 .366 .563 r
.93508 .66624 m .94382 .65358 L .94051 .62704 L p F P
0 g
s
.573 .366 .563 r
.95008 .63862 m .94382 .65358 L .94051 .62704 L p F P
0 g
s
.573 .366 .563 r
.89514 .6858 m .87794 .68555 L .881 .7149 L p F P
0 g
s
.573 .366 .563 r
.86185 .70806 m .881 .7149 L .87794 .68555 L p F P
0 g
s
.573 .366 .563 r
.89856 .71713 m .881 .7149 L .87794 .68555 L p F P
0 g
s
.573 .366 .563 r
.87794 .68555 m .89514 .6858 L .89856 .71713 L p F P
0 g
s
.773 .738 .82 r
.43858 .29535 m .42578 .30547 L .44726 .33379 L p F P
0 g
s
.773 .738 .82 r
.44726 .33379 m .46068 .32484 L .43858 .29535 L p F P
0 g
s
.857 .748 .742 r
.43429 .34795 m .44726 .33379 L .42578 .30547 L p F P
0 g
s
.938 .685 .528 r
.16512 .45993 m .15649 .42308 L .1719 .42758 L p F P
0 g
s
.938 .685 .528 r
.1719 .42758 m .17581 .4628 L .16512 .45993 L p F P
0 g
s
.616 .687 .894 r
.45275 .29199 m .43858 .29535 L .46068 .32484 L p F P
0 g
s
.616 .687 .894 r
.46068 .32484 m .4745 .32126 L .45275 .29199 L p F P
0 g
s
.938 .685 .528 r
.18484 .54407 m .20683 .53794 L .20337 .52902 L closepath p F P
0 g
s
.938 .685 .528 r
.18484 .54407 m .20927 .54714 L .20683 .53794 L closepath p F P
0 g
s
.938 .685 .528 r
.20818 .54253 m .18484 .54407 L .20522 .53342 L closepath p F P
0 g
s
.938 .685 .528 r
.21008 .55171 m .18484 .54407 L .20818 .54253 L closepath p F P
0 g
s
.938 .685 .528 r
.14425 .40643 m .13601 .3785 L .15663 .3815 L p F P
0 g
s
.938 .685 .528 r
.15663 .3815 m .16133 .4086 L .14425 .40643 L p F P
0 g
s
.938 .685 .528 r
.20522 .53342 m .18484 .54407 L .20131 .52479 L closepath p F P
0 g
s
.573 .366 .563 r
.9567 .61672 m .95692 .6459 L .95797 .65408 L p F P
0 g
s
.573 .366 .563 r
.95797 .65408 m .95723 .62084 L .9567 .61672 L p F P
0 g
s
.573 .366 .563 r
.95692 .6459 m .9567 .61672 L .95723 .62084 L p F P
0 g
s
.573 .366 .563 r
.9567 .61672 m .95692 .6459 L .95551 .63504 L p F P
0 g
s
.938 .685 .528 r
.25255 .68218 m .23879 .65412 L .22733 .66323 L p F P
0 g
s
.938 .685 .528 r
.22733 .66323 m .23831 .69401 L .25255 .68218 L p F P
0 g
s
.938 .685 .528 r
.18484 .54407 m .21059 .55621 L .20927 .54714 L closepath p F P
0 g
s
.938 .685 .528 r
.18484 .54407 m .20337 .52902 L .19906 .52078 L closepath p F P
0 g
s
.938 .685 .528 r
.22152 .58587 m .1974 .55839 L .19795 .55454 L p F P
0 g
s
.938 .685 .528 r
.1974 .55839 m .22152 .58587 L .2183 .59533 L p F P
0 g
s
.092 .107 .582 r
.5573 .50882 m .56495 .49733 L .55823 .46244 L p F P
0 g
s
0 0 .467 r
.56495 .49733 m .5573 .50882 L .56078 .54554 L p F P
0 g
s
.282 .179 .557 r
.55058 .556 m .56078 .54554 L .5573 .50882 L p F P
0 g
s
.938 .685 .528 r
.18391 .52364 m .18213 .48421 L .19047 .49045 L p F P
0 g
s
.938 .685 .528 r
.19047 .49045 m .18676 .52572 L .18391 .52364 L p F P
0 g
s
.938 .685 .528 r
.21081 .56057 m .18484 .54407 L .21008 .55171 L closepath p F P
0 g
s
.938 .685 .528 r
.20131 .52479 m .18484 .54407 L .19664 .51703 L closepath p F P
0 g
s
.573 .366 .563 r
.95384 .62206 m .95008 .63862 L .95249 .65752 L p F P
0 g
s
.573 .366 .563 r
.95249 .65752 m .95551 .63504 L .95384 .62206 L p F P
0 g
s
.573 .366 .563 r
.95008 .63862 m .95384 .62206 L .95551 .63504 L p F P
0 g
s
.938 .685 .528 r
.22867 .61122 m .20745 .57873 L .20417 .58351 L p F P
0 g
s
.938 .685 .528 r
.20417 .58351 m .22243 .62074 L .22867 .61122 L p F P
0 g
s
.128 .358 .819 r
.50329 .33012 m .48869 .32308 L .50771 .35576 L p F P
0 g
s
.128 .358 .819 r
.50771 .35576 m .5203 .3595 L .50329 .33012 L p F P
0 g
s
.892 .632 .539 r
.47871 .51913 m .45587 .51222 L .4576 .53635 L p F P
0 g
s
.892 .632 .539 r
.4576 .53635 m .48103 .54929 L .47871 .51913 L p F P
0 g
s
.938 .685 .528 r
.13273 .36736 m .13987 .39157 L .15882 .39416 L p F P
0 g
s
.938 .685 .528 r
.16411 .42465 m .15882 .39416 L .13987 .39157 L p F P
0 g
s
.573 .366 .563 r
.881 .7149 m .86185 .70806 L .86401 .72993 L p F P
0 g
s
.573 .366 .563 r
.88359 .73968 m .86401 .72993 L .86185 .70806 L p F P
0 g
s
.573 .366 .563 r
.86185 .70806 m .881 .7149 L .88359 .73968 L p F P
0 g
s
.573 .366 .563 r
.95723 .62084 m .95797 .65408 L .95863 .65918 L p F P
0 g
s
.573 .366 .563 r
.95863 .65918 m .95757 .62339 L .95723 .62084 L p F P
0 g
s
.573 .366 .563 r
.95797 .65408 m .95723 .62084 L .95757 .62339 L p F P
0 g
s
.573 .366 .563 r
.95723 .62084 m .95797 .65408 L .95692 .6459 L p F P
0 g
s
.938 .685 .528 r
.18484 .54407 m .21073 .56475 L .21059 .55621 L closepath p F P
0 g
s
.938 .685 .528 r
.23498 .6326 m .21608 .59923 L .21055 .60512 L p F P
0 g
s
.938 .685 .528 r
.21055 .60512 m .22624 .64237 L .23498 .6326 L p F P
0 g
s
.938 .685 .528 r
.18484 .54407 m .19906 .52078 L .19408 .51359 L closepath p F P
0 g
s
.938 .685 .528 r
.16411 .42465 m .1704 .46089 L .18129 .46564 L p F P
0 g
s
.938 .685 .528 r
.18301 .50361 m .18129 .46564 L .1704 .46089 L p F P
0 g
s
.938 .685 .528 r
.18129 .46564 m .18301 .50361 L .18865 .50778 L p F P
0 g
s
.886 .717 .667 r
.43429 .34795 m .42189 .36697 L .43796 .39349 L p F P
0 g
s
.915 .715 .618 r
.42317 .41144 m .43796 .39349 L .42189 .36697 L p F P
0 g
s
.906 .698 .61 r
.43796 .39349 m .42317 .41144 L .43463 .43521 L p F P
0 g
s
.855 .58 .522 r
.50242 .55802 m .48103 .54929 L .47973 .57648 L p F P
0 g
s
.855 .58 .522 r
.47973 .57648 m .50114 .58948 L .50242 .55802 L p F P
0 g
s
.938 .685 .528 r
.23089 .63801 m .24604 .66889 L .2331 .67942 L p F P
0 g
s
.938 .685 .528 r
.24289 .70685 m .2331 .67942 L .24604 .66889 L p F P
0 g
s
.175 .029 .431 r
.56078 .54554 m .55058 .556 L .54973 .59117 L p F P
0 g
s
.484 .268 .51 r
.5364 .59709 m .54973 .59117 L .55058 .556 L p F P
0 g
s
.573 .366 .563 r
.95757 .62339 m .95863 .65918 L .95885 .6609 L p F P
0 g
s
.573 .366 .563 r
.95885 .6609 m .95768 .62426 L .95757 .62339 L p F P
0 g
s
.573 .366 .563 r
.95863 .65918 m .95757 .62339 L .95768 .62426 L p F P
0 g
s
.573 .366 .563 r
.95757 .62339 m .95863 .65918 L .95797 .65408 L p F P
0 g
s
.938 .685 .528 r
.15265 .40672 m .16066 .44088 L .17379 .44457 L p F P
0 g
s
.938 .685 .528 r
.17796 .48209 m .17379 .44457 L .16066 .44088 L p F P
0 g
s
.938 .685 .528 r
.17379 .44457 m .17796 .48209 L .18632 .48701 L p F P
0 g
s
.938 .685 .528 r
.21035 .5687 m .18484 .54407 L .21081 .56057 L closepath p F P
0 g
s
.573 .366 .563 r
.95768 .62426 m .95885 .6609 L .95863 .65918 L p F P
0 g
s
.938 .685 .528 r
.19664 .51703 m .18484 .54407 L .19141 .51049 L closepath p F P
0 g
s
.938 .685 .528 r
.22012 .59086 m .1969 .56007 L .19549 .56287 L p F P
0 g
s
.938 .685 .528 r
.19549 .56287 m .21608 .59923 L .22012 .59086 L p F P
0 g
s
.573 .366 .563 r
.84443 .72873 m .86565 .74651 L .86401 .72993 L p F P
0 g
s
.573 .366 .563 r
.86565 .74651 m .84443 .72873 L .84522 .7372 L p F P
0 g
s
.573 .366 .563 r
.86668 .75685 m .84522 .7372 L .84443 .72873 L p F P
0 g
s
.573 .366 .563 r
.84443 .72873 m .86565 .74651 L .86668 .75685 L p F P
0 g
s
.857 .748 .742 r
.42578 .30547 m .41442 .32208 L .43429 .34795 L p F P
0 g
s
.901 .743 .676 r
.42189 .36697 m .43429 .34795 L .41442 .32208 L p F P
0 g
s
.938 .685 .528 r
.15439 .44082 m .14425 .40643 L .16133 .4086 L p F P
0 g
s
.938 .685 .528 r
.16133 .4086 m .16715 .44214 L .15439 .44082 L p F P
0 g
s
.938 .685 .528 r
.18534 .52457 m .18632 .48701 L .17796 .48209 L p F P
0 g
s
.938 .685 .528 r
.18632 .48701 m .18534 .52457 L .18816 .52708 L p F P
0 g
s
.356 .561 .913 r
.46826 .29537 m .45275 .29199 L .4745 .32126 L p F P
0 g
s
.356 .561 .913 r
.4745 .32126 m .48869 .32308 L .46826 .29537 L p F P
0 g
s
.938 .685 .528 r
.18484 .54407 m .20967 .57237 L .21073 .56475 L closepath p F P
0 g
s
.938 .685 .528 r
.26173 .72665 m .26449 .73319 L .24414 .74518 L p F P
0 g
s
.938 .685 .528 r
.26449 .73319 m .26356 .731 L .24344 .74281 L p F P
0 g
s
.938 .685 .528 r
.24344 .74281 m .24414 .74518 L .26449 .73319 L p F P
0 g
s
.938 .685 .528 r
.18484 .54407 m .19408 .51359 L .18865 .50778 L closepath p F P
0 g
s
.573 .366 .563 r
.91056 .68264 m .89514 .6858 L .89856 .71713 L p F P
0 g
s
.573 .366 .563 r
.881 .7149 m .89856 .71713 L .89514 .6858 L p F P
0 g
s
.573 .366 .563 r
.91418 .71441 m .89856 .71713 L .89514 .6858 L p F P
0 g
s
.573 .366 .563 r
.89514 .6858 m .91056 .68264 L .91418 .71441 L p F P
0 g
s
.938 .685 .528 r
.26356 .731 m .25901 .72018 L .23999 .73112 L p F P
0 g
s
.938 .685 .528 r
.23999 .73112 m .24344 .74281 L .26356 .731 L p F P
0 g
s
.938 .685 .528 r
.23879 .65412 m .22243 .62074 L .21435 .62683 L p F P
0 g
s
.938 .685 .528 r
.21435 .62683 m .22733 .66323 L .23879 .65412 L p F P
0 g
s
.938 .685 .528 r
.25542 .71167 m .26173 .72665 L .24205 .73811 L p F P
0 g
s
.938 .685 .528 r
.24414 .74518 m .24205 .73811 L .26173 .72665 L p F P
0 g
s
.938 .685 .528 r
.2258 .61638 m .20594 .58133 L .2087 .57573 L p F P
0 g
s
.938 .685 .528 r
.20594 .58133 m .2258 .61638 L .2186 .62424 L p F P
0 g
s
.938 .685 .528 r
.23337 .65932 m .2186 .62424 L .2258 .61638 L p F P
0 g
s
.938 .685 .528 r
.25901 .72018 m .25101 .7012 L .23396 .71066 L p F P
0 g
s
.938 .685 .528 r
.23396 .71066 m .23999 .73112 L .25901 .72018 L p F P
0 g
s
.573 .366 .563 r
.95008 .63862 m .94382 .65358 L .94682 .67758 L p F P
0 g
s
.573 .366 .563 r
.94682 .67758 m .95249 .65752 L .95008 .63862 L p F P
0 g
s
.573 .366 .563 r
.95551 .63504 m .95249 .65752 L .95008 .63862 L p F P
0 g
s
.573 .366 .563 r
.94382 .65358 m .95008 .63862 L .95249 .65752 L p F P
0 g
s
.938 .685 .528 r
.2087 .57573 m .18484 .54407 L .21035 .5687 L closepath p F P
0 g
s
.938 .685 .528 r
.13987 .39157 m .14911 .42291 L .16411 .42465 L p F P
0 g
s
.938 .685 .528 r
.1704 .46089 m .16411 .42465 L .14911 .42291 L p F P
0 g
s
.938 .685 .528 r
.19141 .51049 m .18484 .54407 L .18584 .50547 L closepath p F P
0 g
s
.573 .366 .563 r
.95551 .63504 m .95249 .65752 L .95451 .67338 L p F P
0 g
s
.573 .366 .563 r
.95451 .67338 m .95692 .6459 L .95551 .63504 L p F P
0 g
s
.573 .366 .563 r
.95249 .65752 m .95551 .63504 L .95692 .6459 L p F P
0 g
s
.938 .685 .528 r
.11662 .3528 m .11413 .34582 L .13829 .34541 L p F P
0 g
s
.938 .685 .528 r
.13829 .34541 m .1399 .35228 L .11662 .3528 L p F P
0 g
s
.938 .685 .528 r
.13883 .34771 m .13829 .34541 L .11413 .34582 L p F P
0 g
s
.938 .685 .528 r
.2183 .59533 m .19626 .56157 L .1974 .55839 L p F P
0 g
s
.938 .685 .528 r
.19626 .56157 m .2183 .59533 L .21349 .60251 L p F P
0 g
s
.938 .685 .528 r
.23089 .63801 m .21349 .60251 L .2183 .59533 L p F P
0 g
s
.938 .685 .528 r
.17472 .50088 m .16512 .45993 L .17581 .4628 L p F P
0 g
s
.938 .685 .528 r
.17581 .4628 m .18019 .50221 L .17472 .50088 L p F P
0 g
s
.938 .685 .528 r
.24583 .6889 m .25542 .71167 L .23728 .72194 L p F P
0 g
s
.938 .685 .528 r
.24205 .73811 m .23728 .72194 L .25542 .71167 L p F P
0 g
s
.573 .366 .563 r
.84522 .7372 m .86668 .75685 L .86565 .74651 L p F P
0 g
s
.573 .366 .563 r
.86668 .75685 m .84522 .7372 L .84549 .74007 L p F P
0 g
s
.573 .366 .563 r
.86702 .76037 m .84549 .74007 L .84522 .7372 L p F P
0 g
s
.573 .366 .563 r
.84522 .7372 m .86668 .75685 L .86702 .76037 L p F P
0 g
s
.938 .685 .528 r
.11413 .34582 m .11496 .34815 L .13883 .34771 L p F P
0 g
s
.938 .685 .528 r
.14149 .35909 m .13883 .34771 L .11496 .34815 L p F P
0 g
s
0 .127 .657 r
.54532 .39428 m .53548 .39221 L .54828 .42696 L p F P
0 g
s
0 .127 .657 r
.54828 .42696 m .5561 .42358 L .54532 .39428 L p F P
0 g
s
0 .052 .589 r
.5561 .42358 m .54828 .42696 L .55823 .46244 L p F P
0 g
s
.938 .685 .528 r
.12231 .36876 m .11662 .3528 L .1399 .35228 L p F P
0 g
s
.938 .685 .528 r
.1399 .35228 m .14359 .36804 L .12231 .36876 L p F P
0 g
s
.938 .685 .528 r
.1811 .52251 m .17384 .48068 L .18213 .48421 L p F P
0 g
s
.938 .685 .528 r
.18213 .48421 m .18391 .52364 L .1811 .52251 L p F P
0 g
s
.938 .685 .528 r
.21349 .60251 m .23089 .63801 L .22105 .64563 L p F P
0 g
s
.938 .685 .528 r
.2331 .67942 m .22105 .64563 L .23089 .63801 L p F P
0 g
s
.938 .685 .528 r
.11496 .34815 m .11908 .35969 L .14149 .35909 L p F P
0 g
s
.938 .685 .528 r
.14617 .37905 m .14149 .35909 L .11908 .35969 L p F P
0 g
s
.938 .685 .528 r
.25101 .7012 m .23993 .67488 L .22563 .68242 L p F P
0 g
s
.938 .685 .528 r
.22563 .68242 m .23396 .71066 L .25101 .7012 L p F P
0 g
s
.938 .685 .528 r
.18484 .54407 m .20745 .57873 L .20967 .57237 L closepath p F P
0 g
s
.573 .366 .563 r
.84549 .74007 m .86702 .76037 L .86668 .75685 L p F P
0 g
s
.938 .685 .528 r
.18484 .54407 m .18865 .50778 L .18301 .50361 L closepath p F P
0 g
s
.938 .685 .528 r
.13093 .39293 m .12231 .36876 L .14359 .36804 L p F P
0 g
s
.938 .685 .528 r
.14359 .36804 m .1492 .39199 L .13093 .39293 L p F P
0 g
s
.938 .685 .528 r
.16597 .48008 m .15439 .44082 L .16715 .44214 L p F P
0 g
s
.938 .685 .528 r
.16715 .44214 m .17384 .48068 L .16597 .48008 L p F P
0 g
s
.573 .366 .563 r
.92395 .67606 m .91056 .68264 L .91418 .71441 L p F P
0 g
s
.573 .366 .563 r
.89856 .71713 m .91418 .71441 L .91056 .68264 L p F P
0 g
s
.573 .366 .563 r
.92757 .7067 m .91418 .71441 L .91056 .68264 L p F P
0 g
s
.573 .366 .563 r
.91056 .68264 m .92395 .67606 L .92757 .7067 L p F P
0 g
s
0 .052 .589 r
.55823 .46244 m .5645 .45349 L .5561 .42358 L p F P
0 g
s
0 0 .493 r
.5645 .45349 m .55823 .46244 L .56495 .49733 L p F P
0 g
s
.938 .685 .528 r
.23337 .65932 m .24583 .6889 L .23006 .69744 L p F P
0 g
s
.938 .685 .528 r
.23728 .72194 m .23006 .69744 L .24583 .6889 L p F P
0 g
s
.573 .366 .563 r
.94382 .65358 m .93508 .66624 L .93849 .69423 L p F P
0 g
s
.573 .366 .563 r
.93849 .69423 m .94682 .67758 L .94382 .65358 L p F P
0 g
s
.573 .366 .563 r
.95249 .65752 m .94682 .67758 L .94382 .65358 L p F P
0 g
s
.573 .366 .563 r
.93508 .66624 m .94382 .65358 L .94682 .67758 L p F P
0 g
s
0 .173 .702 r
.53258 .36674 m .5203 .3595 L .53548 .39221 L p F P
0 g
s
0 .173 .702 r
.53548 .39221 m .54532 .39428 L .53258 .36674 L p F P
0 g
s
.938 .685 .528 r
.11908 .35969 m .12628 .37988 L .14617 .37905 L p F P
0 g
s
.938 .685 .528 r
.15265 .40672 m .14617 .37905 L .12628 .37988 L p F P
0 g
s
.923 .686 .562 r
.42345 .4665 m .44413 .46061 L .43463 .43521 L p F P
0 g
s
.92 .675 .551 r
.44413 .46061 m .42345 .4665 L .42849 .48481 L p F P
0 g
s
.92 .675 .551 r
.42849 .48481 m .45131 .48663 L .44413 .46061 L p F P
0 g
s
.938 .685 .528 r
.20594 .58133 m .18484 .54407 L .2087 .57573 L closepath p F P
0 g
s
.938 .685 .528 r
.21608 .59923 m .19549 .56287 L .19357 .56481 L p F P
0 g
s
.938 .685 .528 r
.19357 .56481 m .21055 .60512 L .21608 .59923 L p F P
0 g
s
.938 .685 .528 r
.18584 .50547 m .18484 .54407 L .18019 .50221 L closepath p F P
0 g
s
.573 .366 .563 r
.86401 .72993 m .88359 .73968 L .881 .7149 L p F P
0 g
s
.573 .366 .563 r
.88359 .73968 m .86401 .72993 L .86565 .74651 L p F P
0 g
s
.573 .366 .563 r
.88555 .75849 m .86565 .74651 L .86401 .72993 L p F P
0 g
s
.573 .366 .563 r
.86401 .72993 m .88359 .73968 L .88555 .75849 L p F P
0 g
s
.938 .685 .528 r
.23993 .67488 m .22624 .64237 L .2154 .64772 L p F P
0 g
s
.938 .685 .528 r
.2154 .64772 m .22563 .68242 L .23993 .67488 L p F P
0 g
s
.938 .685 .528 r
.14207 .42416 m .13093 .39293 L .1492 .39199 L p F P
0 g
s
.938 .685 .528 r
.1492 .39199 m .15649 .42308 L .14207 .42416 L p F P
0 g
s
.573 .366 .563 r
.89856 .71713 m .881 .7149 L .88359 .73968 L p F P
0 g
s
.573 .366 .563 r
.90146 .74361 m .88359 .73968 L .881 .7149 L p F P
0 g
s
.573 .366 .563 r
.881 .7149 m .89856 .71713 L .90146 .74361 L p F P
0 g
s
.938 .685 .528 r
.22243 .62074 m .20417 .58351 L .19996 .58649 L p F P
0 g
s
.938 .685 .528 r
.19996 .58649 m .21435 .62683 L .22243 .62074 L p F P
0 g
s
.938 .685 .528 r
.16066 .44088 m .16983 .48001 L .17796 .48209 L p F P
0 g
s
.938 .685 .528 r
.18249 .52295 m .17796 .48209 L .16983 .48001 L p F P
0 g
s
.938 .685 .528 r
.17796 .48209 m .18249 .52295 L .18534 .52457 L p F P
0 g
s
.893 .617 .512 r
.48103 .54929 m .4576 .53635 L .45639 .558 L p F P
0 g
s
.893 .617 .512 r
.45639 .558 m .47973 .57648 L .48103 .54929 L p F P
0 g
s
.573 .366 .563 r
.93508 .66624 m .92395 .67606 L .92757 .7067 L p F P
0 g
s
.573 .366 .563 r
.91418 .71441 m .92757 .7067 L .92395 .67606 L p F P
0 g
s
.573 .366 .563 r
.93849 .69423 m .92757 .7067 L .92395 .67606 L p F P
0 g
s
.573 .366 .563 r
.92395 .67606 m .93508 .66624 L .93849 .69423 L p F P
0 g
s
.573 .366 .563 r
.95692 .6459 m .95451 .67338 L .95604 .68537 L p F P
0 g
s
.573 .366 .563 r
.95604 .68537 m .95797 .65408 L .95692 .6459 L p F P
0 g
s
.573 .366 .563 r
.95451 .67338 m .95692 .6459 L .95797 .65408 L p F P
0 g
s
.573 .366 .563 r
.95692 .6459 m .95451 .67338 L .95249 .65752 L p F P
0 g
s
.573 .366 .563 r
.92757 .7067 m .93849 .69423 L .93508 .66624 L p F P
0 g
s
.573 .366 .563 r
.94682 .67758 m .93849 .69423 L .93508 .66624 L p F P
0 g
s
.918 .663 .537 r
.45131 .48663 m .42849 .48481 L .43164 .5028 L p F P
0 g
s
.918 .663 .537 r
.43164 .5028 m .45587 .51222 L .45131 .48663 L p F P
0 g
s
.928 .698 .571 r
.41675 .44864 m .43463 .43521 L .42317 .41144 L p F P
0 g
s
.923 .686 .562 r
.43463 .43521 m .41675 .44864 L .42345 .4665 L p F P
0 g
s
.938 .685 .528 r
.14911 .42291 m .16003 .45995 L .1704 .46089 L p F P
0 g
s
.938 .685 .528 r
.17741 .5013 m .1704 .46089 L .16003 .45995 L p F P
0 g
s
.938 .685 .528 r
.1704 .46089 m .17741 .5013 L .18301 .50361 L p F P
0 g
s
.938 .685 .528 r
.17527 .55184 m .19424 .53644 L .19599 .54096 L p F P
0 g
s
.938 .685 .528 r
.19599 .54096 m .17348 .54724 L .17527 .55184 L p F P
0 g
s
.938 .685 .528 r
.17348 .54724 m .19599 .54096 L .19723 .54563 L p F P
0 g
s
.938 .685 .528 r
.17278 .54487 m .19668 .54329 L .19518 .53867 L p F P
0 g
s
.938 .685 .528 r
.19668 .54329 m .17278 .54487 L .17182 .54013 L p F P
0 g
s
.938 .685 .528 r
.17182 .54013 m .19764 .54795 L .19668 .54329 L p F P
0 g
s
.938 .685 .528 r
.17431 .54958 m .19518 .53867 L .19319 .5343 L p F P
0 g
s
.938 .685 .528 r
.19518 .53867 m .17431 .54958 L .17278 .54487 L p F P
0 g
s
.901 .743 .676 r
.41442 .32208 m .40454 .34472 L .42189 .36697 L p F P
0 g
s
.926 .733 .622 r
.41022 .3903 m .42189 .36697 L .40454 .34472 L p F P
0 g
s
.915 .715 .618 r
.42189 .36697 m .41022 .3903 L .42317 .41144 L p F P
0 g
s
.938 .685 .528 r
.19723 .54563 m .17223 .54249 L .17348 .54724 L p F P
0 g
s
.938 .685 .528 r
.17223 .54249 m .19723 .54563 L .19789 .55023 L p F P
0 g
s
.938 .685 .528 r
.17751 .55607 m .19205 .53227 L .19424 .53644 L p F P
0 g
s
.938 .685 .528 r
.19424 .53644 m .17527 .55184 L .17751 .55607 L p F P
0 g
s
.938 .685 .528 r
.12628 .37988 m .13622 .40775 L .15265 .40672 L p F P
0 g
s
.938 .685 .528 r
.16066 .44088 m .15265 .40672 L .13622 .40775 L p F P
0 g
s
0 0 .467 r
.56078 .54554 m .56814 .53028 L .56495 .49733 L p F P
0 g
s
0 0 .294 r
.56814 .53028 m .56078 .54554 L .56009 .57873 L p F P
0 g
s
.175 .029 .431 r
.54973 .59117 m .56009 .57873 L .56078 .54554 L p F P
0 g
s
.938 .685 .528 r
.2186 .62424 m .23337 .65932 L .22072 .66578 L p F P
0 g
s
.938 .685 .528 r
.23006 .69744 m .22072 .66578 L .23337 .65932 L p F P
0 g
s
.938 .685 .528 r
.19764 .54795 m .17182 .54013 L .17147 .53559 L p F P
0 g
s
.938 .685 .528 r
.17147 .53559 m .198 .55243 L .19764 .54795 L p F P
0 g
s
.938 .685 .528 r
.18484 .54407 m .20417 .58351 L .20745 .57873 L closepath p F P
0 g
s
.938 .685 .528 r
.17634 .55402 m .19319 .5343 L .19082 .53037 L p F P
0 g
s
.938 .685 .528 r
.19319 .5343 m .17634 .55402 L .17431 .54958 L p F P
0 g
s
.938 .685 .528 r
.18484 .54407 m .18301 .50361 L .17741 .5013 L closepath p F P
0 g
s
.938 .685 .528 r
.19789 .55023 m .17157 .53782 L .17223 .54249 L p F P
0 g
s
.938 .685 .528 r
.17157 .53782 m .19789 .55023 L .19795 .55454 L p F P
0 g
s
.938 .685 .528 r
.18009 .55973 m .18952 .52864 L .19205 .53227 L p F P
0 g
s
.938 .685 .528 r
.19205 .53227 m .17751 .55607 L .18009 .55973 L p F P
0 g
s
.036 .362 .834 r
.48508 .3053 m .46826 .29537 L .48869 .32308 L p F P
0 g
s
.036 .362 .834 r
.48869 .32308 m .50329 .33012 L .48508 .3053 L p F P
0 g
s
.938 .685 .528 r
.198 .55243 m .17147 .53559 L .17175 .53145 L p F P
0 g
s
.938 .685 .528 r
.17175 .53145 m .19775 .55654 L .198 .55243 L p F P
0 g
s
.938 .685 .528 r
.15519 .46096 m .14207 .42416 L .15649 .42308 L p F P
0 g
s
.938 .685 .528 r
.15649 .42308 m .16512 .45993 L .15519 .46096 L p F P
0 g
s
.938 .685 .528 r
.17876 .55798 m .19082 .53037 L .18816 .52708 L p F P
0 g
s
.938 .685 .528 r
.19082 .53037 m .17876 .55798 L .17634 .55402 L p F P
0 g
s
.573 .366 .563 r
.95249 .65752 m .94682 .67758 L .94934 .69778 L p F P
0 g
s
.573 .366 .563 r
.94934 .69778 m .95451 .67338 L .95249 .65752 L p F P
0 g
s
.573 .366 .563 r
.94682 .67758 m .95249 .65752 L .95451 .67338 L p F P
0 g
s
.938 .685 .528 r
.21349 .60251 m .19458 .56396 L .19626 .56157 L p F P
0 g
s
.938 .685 .528 r
.19458 .56396 m .21349 .60251 L .20729 .60704 L p F P
0 g
s
.938 .685 .528 r
.22105 .64563 m .20729 .60704 L .21349 .60251 L p F P
0 g
s
.938 .685 .528 r
.22624 .64237 m .21055 .60512 L .20375 .60822 L p F P
0 g
s
.938 .685 .528 r
.20375 .60822 m .2154 .64772 L .22624 .64237 L p F P
0 g
s
.666 .362 .45 r
.5364 .59709 m .52015 .59647 L .51447 .62573 L p F P
0 g
s
.793 .488 .473 r
.52015 .59647 m .50114 .58948 L .49569 .61625 L p F P
0 g
s
.793 .488 .473 r
.49569 .61625 m .51447 .62573 L .52015 .59647 L p F P
0 g
s
.938 .685 .528 r
.19795 .55454 m .17153 .53345 L .17157 .53782 L p F P
0 g
s
.938 .685 .528 r
.17153 .53345 m .19795 .55454 L .1974 .55839 L p F P
0 g
s
.938 .685 .528 r
.18289 .56264 m .18676 .52572 L .18952 .52864 L p F P
0 g
s
.938 .685 .528 r
.18952 .52864 m .18009 .55973 L .18289 .56264 L p F P
0 g
s
.573 .366 .563 r
.95797 .65408 m .95604 .68537 L .95699 .69284 L p F P
0 g
s
.573 .366 .563 r
.95699 .69284 m .95863 .65918 L .95797 .65408 L p F P
0 g
s
.573 .366 .563 r
.95604 .68537 m .95797 .65408 L .95863 .65918 L p F P
0 g
s
.573 .366 .563 r
.95797 .65408 m .95604 .68537 L .95451 .67338 L p F P
0 g
s
.938 .685 .528 r
.17844 .52239 m .16597 .48008 L .17384 .48068 L p F P
0 g
s
.938 .685 .528 r
.17384 .48068 m .1811 .52251 L .17844 .52239 L p F P
0 g
s
.412 .136 .381 r
.54973 .59117 m .5364 .59709 L .53075 .62745 L p F P
0 g
s
.666 .362 .45 r
.51447 .62573 m .53075 .62745 L .5364 .59709 L p F P
0 g
s
.938 .685 .528 r
.20217 .58524 m .18484 .54407 L .20594 .58133 L closepath p F P
0 g
s
.938 .685 .528 r
.2186 .62424 m .20217 .58524 L .20594 .58133 L p F P
0 g
s
.938 .685 .528 r
.19775 .55654 m .17175 .53145 L .17265 .52791 L p F P
0 g
s
.938 .685 .528 r
.17265 .52791 m .1969 .56007 L .19775 .55654 L p F P
0 g
s
.938 .685 .528 r
.13622 .40775 m .14842 .44197 L .16066 .44088 L p F P
0 g
s
.938 .685 .528 r
.16983 .48001 m .16066 .44088 L .14842 .44197 L p F P
0 g
s
.938 .685 .528 r
.18147 .56129 m .18816 .52708 L .18534 .52457 L p F P
0 g
s
.938 .685 .528 r
.18816 .52708 m .18147 .56129 L .17876 .55798 L p F P
0 g
s
.938 .685 .528 r
.18019 .50221 m .18484 .54407 L .17472 .50088 L closepath p F P
0 g
s
0 0 .493 r
.56495 .49733 m .57019 .48285 L .5645 .45349 L p F P
0 g
s
0 0 .355 r
.57019 .48285 m .56495 .49733 L .56814 .53028 L p F P
0 g
s
.794 .794 .851 r
.41565 .27249 m .4035 .28358 L .42578 .30547 L p F P
0 g
s
.794 .794 .851 r
.42578 .30547 m .43858 .29535 L .41565 .27249 L p F P
0 g
s
.88 .788 .755 r
.41442 .32208 m .42578 .30547 L .4035 .28358 L p F P
0 g
s
.918 .653 .521 r
.45587 .51222 m .43164 .5028 L .43276 .51969 L p F P
0 g
s
.918 .653 .521 r
.43276 .51969 m .4576 .53635 L .45587 .51222 L p F P
0 g
s
.938 .685 .528 r
.20217 .58524 m .2186 .62424 L .20972 .62846 L p F P
0 g
s
.938 .685 .528 r
.22072 .66578 m .20972 .62846 L .2186 .62424 L p F P
0 g
s
.938 .685 .528 r
.1974 .55839 m .17213 .52959 L .17153 .53345 L p F P
0 g
s
.938 .685 .528 r
.17213 .52959 m .1974 .55839 L .19626 .56157 L p F P
0 g
s
.938 .685 .528 r
.18577 .56467 m .18391 .52364 L .18676 .52572 L p F P
0 g
s
.938 .685 .528 r
.18676 .52572 m .18289 .56264 L .18577 .56467 L p F P
0 g
s
0 .188 .72 r
.51835 .34206 m .50329 .33012 L .5203 .3595 L p F P
0 g
s
0 .188 .72 r
.5203 .3595 m .53258 .36674 L .51835 .34206 L p F P
0 g
s
.609 .749 .944 r
.43023 .26927 m .41565 .27249 L .43858 .29535 L p F P
0 g
s
.609 .749 .944 r
.43858 .29535 m .45275 .29199 L .43023 .26927 L p F P
0 g
s
.934 .71 .575 r
.40866 .43197 m .42317 .41144 L .41022 .3903 L p F P
0 g
s
.928 .698 .571 r
.42317 .41144 m .40866 .43197 L .41675 .44864 L p F P
0 g
s
.573 .366 .563 r
.95863 .65918 m .95699 .69284 L .95731 .69538 L p F P
0 g
s
.573 .366 .563 r
.95731 .69538 m .95885 .6609 L .95863 .65918 L p F P
0 g
s
.573 .366 .563 r
.95699 .69284 m .95863 .65918 L .95885 .6609 L p F P
0 g
s
.573 .366 .563 r
.95863 .65918 m .95699 .69284 L .95604 .68537 L p F P
0 g
s
.938 .685 .528 r
.16968 .50157 m .15519 .46096 L .16512 .45993 L p F P
0 g
s
.938 .685 .528 r
.16512 .45993 m .17472 .50088 L .16968 .50157 L p F P
0 g
s
.938 .685 .528 r
.25399 .73799 m .25481 .74027 L .23257 .74778 L p F P
0 g
s
.938 .685 .528 r
.25481 .74027 m .25237 .73343 L .23087 .74056 L p F P
0 g
s
.938 .685 .528 r
.23087 .74056 m .23257 .74778 L .25481 .74027 L p F P
0 g
s
.938 .685 .528 r
.24996 .72667 m .25399 .73799 L .232 .74536 L p F P
0 g
s
.938 .685 .528 r
.23257 .74778 m .232 .74536 L .25399 .73799 L p F P
0 g
s
.938 .685 .528 r
.1969 .56007 m .17265 .52791 L .17412 .52515 L p F P
0 g
s
.938 .685 .528 r
.17412 .52515 m .19549 .56287 L .1969 .56007 L p F P
0 g
s
.938 .685 .528 r
.25237 .73343 m .24679 .71778 L .22701 .72405 L p F P
0 g
s
.938 .685 .528 r
.22701 .72405 m .23087 .74056 L .25237 .73343 L p F P
0 g
s
.859 .559 .48 r
.50114 .58948 m .47973 .57648 L .47476 .5995 L p F P
0 g
s
.859 .559 .48 r
.47476 .5995 m .49569 .61625 L .50114 .58948 L p F P
0 g
s
.938 .685 .528 r
.18433 .56378 m .18534 .52457 L .18249 .52295 L p F P
0 g
s
.938 .685 .528 r
.18534 .52457 m .18433 .56378 L .18147 .56129 L p F P
0 g
s
.573 .366 .563 r
.95885 .6609 m .95731 .69538 L .95699 .69284 L p F P
0 g
s
.938 .685 .528 r
.18484 .54407 m .19996 .58649 L .20417 .58351 L closepath p F P
0 g
s
.938 .685 .528 r
.24289 .70685 m .24996 .72667 L .2292 .73342 L p F P
0 g
s
.938 .685 .528 r
.232 .74536 m .2292 .73342 L .24996 .72667 L p F P
0 g
s
.573 .366 .563 r
.86565 .74651 m .88555 .75849 L .88359 .73968 L p F P
0 g
s
.573 .366 .563 r
.88555 .75849 m .86565 .74651 L .86668 .75685 L p F P
0 g
s
.573 .366 .563 r
.88677 .77024 m .86668 .75685 L .86565 .74651 L p F P
0 g
s
.573 .366 .563 r
.86565 .74651 m .88555 .75849 L .88677 .77024 L p F P
0 g
s
.573 .366 .563 r
.91418 .71441 m .89856 .71713 L .90146 .74361 L p F P
0 g
s
.573 .366 .563 r
.88359 .73968 m .90146 .74361 L .89856 .71713 L p F P
0 g
s
.573 .366 .563 r
.91724 .74127 m .90146 .74361 L .89856 .71713 L p F P
0 g
s
.573 .366 .563 r
.89856 .71713 m .91418 .71441 L .91724 .74127 L p F P
0 g
s
.938 .685 .528 r
.24679 .71778 m .23831 .69401 L .22116 .69909 L p F P
0 g
s
.938 .685 .528 r
.22116 .69909 m .22701 .72405 L .24679 .71778 L p F P
0 g
s
.938 .685 .528 r
.16003 .45995 m .17213 .50097 L .17741 .5013 L p F P
0 g
s
.938 .685 .528 r
.18484 .54407 m .17741 .5013 L .17213 .50097 L closepath p F P
0 g
s
.938 .685 .528 r
.21055 .60512 m .19357 .56481 L .19124 .56578 L p F P
0 g
s
.938 .685 .528 r
.19124 .56578 m .20375 .60822 L .21055 .60512 L p F P
0 g
s
.938 .685 .528 r
.2331 .67942 m .24289 .70685 L .22431 .71256 L p F P
0 g
s
.938 .685 .528 r
.2292 .73342 m .22431 .71256 L .24289 .70685 L p F P
0 g
s
.938 .685 .528 r
.19626 .56157 m .17332 .52642 L .17213 .52959 L p F P
0 g
s
.938 .685 .528 r
.17332 .52642 m .19626 .56157 L .19458 .56396 L p F P
0 g
s
.938 .685 .528 r
.18859 .56573 m .1811 .52251 L .18391 .52364 L p F P
0 g
s
.938 .685 .528 r
.18391 .52364 m .18577 .56467 L .18859 .56573 L p F P
0 g
s
.938 .685 .528 r
.14842 .44197 m .16231 .4809 L .16983 .48001 L p F P
0 g
s
.938 .685 .528 r
.17974 .52232 m .16983 .48001 L .16231 .4809 L p F P
0 g
s
.938 .685 .528 r
.16983 .48001 m .17974 .52232 L .18249 .52295 L p F P
0 g
s
.938 .685 .528 r
.23831 .69401 m .22733 .66323 L .21362 .66692 L p F P
0 g
s
.938 .685 .528 r
.21362 .66692 m .22116 .69909 L .23831 .69401 L p F P
0 g
s
.88 .788 .755 r
.4035 .28358 m .39381 .30221 L .41442 .32208 L p F P
0 g
s
.919 .77 .679 r
.40454 .34472 m .41442 .32208 L .39381 .30221 L p F P
0 g
s
.938 .685 .528 r
.10389 .35188 m .10292 .34957 L .12597 .34444 L p F P
0 g
s
.938 .685 .528 r
.12597 .34444 m .12666 .34678 L .10389 .35188 L p F P
0 g
s
.938 .685 .528 r
.12803 .35141 m .12597 .34444 L .10292 .34957 L p F P
0 g
s
.938 .685 .528 r
.1087 .3633 m .10389 .35188 L .12666 .34678 L p F P
0 g
s
.938 .685 .528 r
.12666 .34678 m .13006 .3583 L .1087 .3633 L p F P
0 g
s
.938 .685 .528 r
.22105 .64563 m .2331 .67942 L .21758 .68382 L p F P
0 g
s
.938 .685 .528 r
.22431 .71256 m .21758 .68382 L .2331 .67942 L p F P
0 g
s
.938 .685 .528 r
.10292 .34957 m .10583 .35648 L .12803 .35141 L p F P
0 g
s
.938 .685 .528 r
.13273 .36736 m .12803 .35141 L .10583 .35648 L p F P
0 g
s
.938 .685 .528 r
.1171 .38324 m .1087 .3633 L .13006 .3583 L p F P
0 g
s
.938 .685 .528 r
.13006 .3583 m .13601 .3785 L .1171 .38324 L p F P
0 g
s
0 0 .227 r
.56009 .57873 m .54973 .59117 L .54432 .62119 L p F P
0 g
s
.412 .136 .381 r
.53075 .62745 m .54432 .62119 L .54973 .59117 L p F P
0 g
s
.573 .366 .563 r
.94682 .67758 m .93849 .69423 L .94137 .71785 L p F P
0 g
s
.573 .366 .563 r
.94137 .71785 m .94934 .69778 L .94682 .67758 L p F P
0 g
s
.573 .366 .563 r
.95451 .67338 m .94934 .69778 L .94682 .67758 L p F P
0 g
s
.573 .366 .563 r
.93849 .69423 m .94682 .67758 L .94934 .69778 L p F P
0 g
s
.938 .685 .528 r
.19549 .56287 m .17412 .52515 L .17608 .52328 L p F P
0 g
s
.938 .685 .528 r
.17608 .52328 m .19357 .56481 L .19549 .56287 L p F P
0 g
s
.938 .685 .528 r
.10583 .35648 m .11247 .37226 L .13273 .36736 L p F P
0 g
s
.938 .685 .528 r
.13987 .39157 m .13273 .36736 L .11247 .37226 L p F P
0 g
s
.938 .685 .528 r
.1872 .56533 m .18249 .52295 L .17974 .52232 L p F P
0 g
s
.938 .685 .528 r
.18249 .52295 m .1872 .56533 L .18433 .56378 L p F P
0 g
s
.938 .685 .528 r
.22733 .66323 m .21435 .62683 L .20476 .62911 L p F P
0 g
s
.938 .685 .528 r
.20476 .62911 m .21362 .66692 L .22733 .66323 L p F P
0 g
s
.938 .685 .528 r
.12867 .41071 m .1171 .38324 L .13601 .3785 L p F P
0 g
s
.938 .685 .528 r
.13601 .3785 m .14425 .40643 L .12867 .41071 L p F P
0 g
s
.938 .685 .528 r
.19757 .58724 m .18484 .54407 L .20217 .58524 L closepath p F P
0 g
s
.938 .685 .528 r
.20972 .62846 m .19757 .58724 L .20217 .58524 L p F P
0 g
s
.938 .685 .528 r
.11247 .37226 m .12252 .39611 L .13987 .39157 L p F P
0 g
s
.938 .685 .528 r
.14911 .42291 m .13987 .39157 L .12252 .39611 L p F P
0 g
s
.938 .685 .528 r
.17472 .50088 m .18484 .54407 L .16968 .50157 L closepath p F P
0 g
s
.938 .685 .528 r
.20729 .60704 m .22105 .64563 L .20933 .64861 L p F P
0 g
s
.938 .685 .528 r
.21758 .68382 m .20933 .64861 L .22105 .64563 L p F P
0 g
s
.573 .366 .563 r
.95451 .67338 m .94934 .69778 L .95126 .71309 L p F P
0 g
s
.573 .366 .563 r
.95126 .71309 m .95604 .68537 L .95451 .67338 L p F P
0 g
s
.573 .366 .563 r
.94934 .69778 m .95451 .67338 L .95604 .68537 L p F P
0 g
s
.938 .685 .528 r
.14283 .44434 m .12867 .41071 L .14425 .40643 L p F P
0 g
s
.938 .685 .528 r
.14425 .40643 m .15439 .44082 L .14283 .44434 L p F P
0 g
s
.938 .685 .528 r
.19458 .56396 m .17504 .52409 L .17332 .52642 L p F P
0 g
s
.938 .685 .528 r
.17504 .52409 m .19458 .56396 L .19245 .56542 L p F P
0 g
s
.938 .685 .528 r
.20729 .60704 m .19245 .56542 L .19458 .56396 L p F P
0 g
s
.938 .685 .528 r
.19124 .56578 m .17844 .52239 L .1811 .52251 L p F P
0 g
s
.938 .685 .528 r
.1811 .52251 m .18859 .56573 L .19124 .56578 L p F P
0 g
s
.573 .366 .563 r
.90146 .74361 m .88359 .73968 L .88555 .75849 L p F P
0 g
s
.573 .366 .563 r
.90365 .76373 m .88555 .75849 L .88359 .73968 L p F P
0 g
s
.573 .366 .563 r
.88359 .73968 m .90146 .74361 L .90365 .76373 L p F P
0 g
s
.268 .584 .945 r
.44717 .27392 m .43023 .26927 L .45275 .29199 L p F P
0 g
s
.268 .584 .945 r
.45275 .29199 m .46826 .29537 L .44717 .27392 L p F P
0 g
s
.938 .685 .528 r
.12252 .39611 m .13547 .42685 L .14911 .42291 L p F P
0 g
s
.938 .685 .528 r
.16003 .45995 m .14911 .42291 L .13547 .42685 L p F P
0 g
s
.938 .685 .528 r
.21435 .62683 m .19996 .58649 L .19501 .5875 L p F P
0 g
s
.938 .685 .528 r
.19501 .5875 m .20476 .62911 L .21435 .62683 L p F P
0 g
s
.938 .685 .528 r
.15889 .48247 m .14283 .44434 L .15439 .44082 L p F P
0 g
s
.938 .685 .528 r
.15439 .44082 m .16597 .48008 L .15889 .48247 L p F P
0 g
s
.573 .366 .563 r
.86668 .75685 m .88677 .77024 L .88555 .75849 L p F P
0 g
s
.573 .366 .563 r
.88677 .77024 m .86668 .75685 L .86702 .76037 L p F P
0 g
s
.573 .366 .563 r
.88719 .77424 m .86702 .76037 L .86668 .75685 L p F P
0 g
s
.573 .366 .563 r
.86668 .75685 m .88677 .77024 L .88719 .77424 L p F P
0 g
s
.938 .685 .528 r
.19245 .56542 m .20729 .60704 L .19997 .60866 L p F P
0 g
s
.938 .685 .528 r
.20933 .64861 m .19997 .60866 L .20729 .60704 L p F P
0 g
s
.938 .685 .528 r
.13547 .42685 m .15067 .46295 L .16003 .45995 L p F P
0 g
s
.938 .685 .528 r
.17213 .50097 m .16003 .45995 L .15067 .46295 L p F P
0 g
s
.573 .366 .563 r
.92757 .7067 m .91418 .71441 L .91724 .74127 L p F P
0 g
s
.573 .366 .563 r
.90146 .74361 m .91724 .74127 L .91418 .71441 L p F P
0 g
s
.573 .366 .563 r
.93062 .73258 m .91724 .74127 L .91418 .71441 L p F P
0 g
s
.573 .366 .563 r
.91418 .71441 m .92757 .7067 L .93062 .73258 L p F P
0 g
s
.938 .685 .528 r
.19357 .56481 m .17608 .52328 L .17844 .52239 L p F P
0 g
s
.938 .685 .528 r
.17844 .52239 m .19124 .56578 L .19357 .56481 L p F P
0 g
s
.938 .685 .528 r
.16231 .4809 m .17722 .52271 L .17974 .52232 L p F P
0 g
s
.938 .685 .528 r
.18995 .56588 m .17974 .52232 L .17722 .52271 L p F P
0 g
s
.938 .685 .528 r
.17974 .52232 m .18995 .56588 L .1872 .56533 L p F P
0 g
s
.938 .685 .528 r
.17608 .52328 m .15889 .48247 L .16597 .48008 L p F P
0 g
s
.938 .685 .528 r
.16597 .48008 m .17844 .52239 L .17608 .52328 L p F P
0 g
s
.938 .685 .528 r
.18484 .54407 m .19501 .5875 L .19996 .58649 L closepath p F P
0 g
s
.573 .366 .563 r
.93849 .69423 m .92757 .7067 L .93062 .73258 L p F P
0 g
s
.573 .366 .563 r
.93062 .73258 m .94137 .71785 L .93849 .69423 L p F P
0 g
s
.573 .366 .563 r
.94934 .69778 m .94137 .71785 L .93849 .69423 L p F P
0 g
s
.573 .366 .563 r
.92757 .7067 m .93849 .69423 L .94137 .71785 L p F P
0 g
s
.573 .366 .563 r
.86702 .76037 m .88719 .77424 L .88677 .77024 L p F P
0 g
s
.938 .685 .528 r
.15067 .46295 m .1674 .50266 L .17213 .50097 L p F P
0 g
s
.938 .685 .528 r
.18484 .54407 m .17213 .50097 L .1674 .50266 L closepath p F P
0 g
s
.938 .685 .528 r
.19245 .56542 m .17722 .52271 L .17504 .52409 L p F P
0 g
s
.938 .685 .528 r
.17722 .52271 m .19245 .56542 L .18995 .56588 L p F P
0 g
s
.938 .685 .528 r
.19997 .60866 m .18995 .56588 L .19245 .56542 L p F P
0 g
s
.919 .643 .502 r
.4576 .53635 m .43276 .51969 L .43179 .53477 L p F P
0 g
s
.919 .643 .502 r
.43179 .53477 m .45639 .558 L .4576 .53635 L p F P
0 g
s
.573 .366 .563 r
.91724 .74127 m .93062 .73258 L .92757 .7067 L p F P
0 g
s
.573 .366 .563 r
.94137 .71785 m .93062 .73258 L .92757 .7067 L p F P
0 g
s
.897 .604 .481 r
.47973 .57648 m .45639 .558 L .45222 .5762 L p F P
0 g
s
.897 .604 .481 r
.45222 .5762 m .47476 .5995 L .47973 .57648 L p F P
0 g
s
.938 .685 .528 r
.18484 .54407 m .1674 .50266 L .16345 .50632 L closepath p F P
0 g
s
.938 .685 .528 r
.15954 .5409 m .18484 .54407 L .16205 .55043 L closepath p F P
0 g
s
.938 .685 .528 r
.17533 .57542 m .18484 .54407 L .18094 .5812 L closepath p F P
0 g
s
.938 .685 .528 r
.17015 .56812 m .18484 .54407 L .17533 .57542 L closepath p F P
0 g
s
.938 .685 .528 r
.16565 .55965 m .18484 .54407 L .17015 .56812 L closepath p F P
0 g
s
.938 .685 .528 r
.16205 .55043 m .18484 .54407 L .16565 .55965 L closepath p F P
0 g
s
.938 .685 .528 r
.18484 .54407 m .18954 .58647 L .19501 .5875 L closepath p F P
0 g
s
.938 .685 .528 r
.18484 .54407 m .18381 .58344 L .18954 .58647 L closepath p F P
0 g
s
.938 .685 .528 r
.18484 .54407 m .1781 .57852 L .18381 .58344 L closepath p F P
0 g
s
.938 .685 .528 r
.18484 .54407 m .17267 .57194 L .1781 .57852 L closepath p F P
0 g
s
.938 .685 .528 r
.18484 .54407 m .1678 .56401 L .17267 .57194 L closepath p F P
0 g
s
.938 .685 .528 r
.18484 .54407 m .16373 .55511 L .1678 .56401 L closepath p F P
0 g
s
.938 .685 .528 r
.19233 .58724 m .18484 .54407 L .19757 .58724 L closepath p F P
0 g
s
.938 .685 .528 r
.1867 .5852 m .18484 .54407 L .19233 .58724 L closepath p F P
0 g
s
.938 .685 .528 r
.18094 .5812 m .18484 .54407 L .1867 .5852 L closepath p F P
0 g
s
.938 .685 .528 r
.16531 .50425 m .18484 .54407 L .16183 .50883 L closepath p F P
0 g
s
.938 .685 .528 r
.16968 .50157 m .18484 .54407 L .16531 .50425 L closepath p F P
0 g
s
.938 .685 .528 r
.18484 .54407 m .16048 .51178 L .15866 .5188 L closepath p F P
0 g
s
.938 .685 .528 r
.18484 .54407 m .16345 .50632 L .16048 .51178 L closepath p F P
0 g
s
.938 .685 .528 r
.15942 .51511 m .18484 .54407 L .1582 .5228 L closepath p F P
0 g
s
.938 .685 .528 r
.16183 .50883 m .18484 .54407 L .15942 .51511 L closepath p F P
0 g
s
.938 .685 .528 r
.18484 .54407 m .15806 .52707 L .15873 .53617 L closepath p F P
0 g
s
.938 .685 .528 r
.18484 .54407 m .15866 .5188 L .15806 .52707 L closepath p F P
0 g
s
.938 .685 .528 r
.15824 .53154 m .18484 .54407 L .15954 .5409 L closepath p F P
0 g
s
.938 .685 .528 r
.1582 .5228 m .18484 .54407 L .15824 .53154 L closepath p F P
0 g
s
.938 .685 .528 r
.18484 .54407 m .16065 .54568 L .16373 .55511 L closepath p F P
0 g
s
.938 .685 .528 r
.18484 .54407 m .15873 .53617 L .16065 .54568 L closepath p F P
0 g
s
.926 .733 .622 r
.40454 .34472 m .39626 .37269 L .41022 .3903 L p F P
0 g
s
.941 .721 .577 r
.39951 .41721 m .41022 .3903 L .39626 .37269 L p F P
0 g
s
.934 .71 .575 r
.41022 .3903 m .39951 .41721 L .40866 .43197 L p F P
0 g
s
.938 .685 .528 r
.20375 .60822 m .19124 .56578 L .18859 .56573 L p F P
0 g
s
.938 .685 .528 r
.15577 .48478 m .17504 .52409 L .17722 .52271 L p F P
0 g
s
.938 .685 .528 r
.17722 .52271 m .16231 .4809 L .15577 .48478 L p F P
0 g
s
.919 .77 .679 r
.39381 .30221 m .38661 .32779 L .40454 .34472 L p F P
0 g
s
.939 .75 .62 r
.39626 .37269 m .40454 .34472 L .38661 .32779 L p F P
0 g
s
.938 .685 .528 r
.19757 .58724 m .20972 .62846 L .19953 .62876 L p F P
0 g
s
.938 .685 .528 r
.19953 .62876 m .19233 .58724 L .19757 .58724 L p F P
0 g
s
.573 .366 .563 r
.95604 .68537 m .95126 .71309 L .95245 .72263 L p F P
0 g
s
.573 .366 .563 r
.95245 .72263 m .95699 .69284 L .95604 .68537 L p F P
0 g
s
.573 .366 .563 r
.95126 .71309 m .95604 .68537 L .95699 .69284 L p F P
0 g
s
.573 .366 .563 r
.95604 .68537 m .95126 .71309 L .94934 .69778 L p F P
0 g
s
.938 .685 .528 r
.15519 .46096 m .16968 .50157 L .16531 .50425 L p F P
0 g
s
.938 .685 .528 r
.2154 .64772 m .20375 .60822 L .19599 .60833 L p F P
0 g
s
.938 .685 .528 r
.18859 .56573 m .19599 .60833 L .20375 .60822 L p F P
0 g
s
0 0 .355 r
.56814 .53028 m .57291 .51048 L .57019 .48285 L p F P
0 g
s
0 0 .157 r
.57291 .51048 m .56814 .53028 L .5676 .55995 L p F P
0 g
s
0 0 .294 r
.56009 .57873 m .5676 .55995 L .56814 .53028 L p F P
0 g
s
.938 .685 .528 r
.18995 .56588 m .19997 .60866 L .19185 .60725 L p F P
0 g
s
.938 .685 .528 r
.19185 .60725 m .1872 .56533 L .18995 .56588 L p F P
0 g
s
.938 .685 .528 r
.15889 .48247 m .17608 .52328 L .17412 .52515 L p F P
0 g
s
.938 .685 .528 r
.20972 .62846 m .22072 .66578 L .2061 .66661 L p F P
0 g
s
.938 .685 .528 r
.2061 .66661 m .19953 .62876 L .20972 .62846 L p F P
0 g
s
.938 .685 .528 r
.13768 .44791 m .15577 .48478 L .16231 .4809 L p F P
0 g
s
.938 .685 .528 r
.16231 .4809 m .14842 .44197 L .13768 .44791 L p F P
0 g
s
.938 .685 .528 r
.22563 .68242 m .2154 .64772 L .20292 .64827 L p F P
0 g
s
.938 .685 .528 r
.19599 .60833 m .20292 .64827 L .2154 .64772 L p F P
0 g
s
0 .163 .693 r
.50318 .32131 m .48508 .3053 L .50329 .33012 L p F P
0 g
s
0 .163 .693 r
.50329 .33012 m .51835 .34206 L .50318 .32131 L p F P
0 g
s
.938 .685 .528 r
.16531 .50425 m .14652 .46592 L .15519 .46096 L p F P
0 g
s
.938 .685 .528 r
.14207 .42416 m .15519 .46096 L .14652 .46592 L p F P
0 g
s
.938 .685 .528 r
.22072 .66578 m .23006 .69744 L .21171 .69893 L p F P
0 g
s
.938 .685 .528 r
.21171 .69893 m .2061 .66661 L .22072 .66578 L p F P
0 g
s
.938 .685 .528 r
.19599 .60833 m .18859 .56573 L .18577 .56467 L p F P
0 g
s
.938 .685 .528 r
.15053 .49151 m .17332 .52642 L .17504 .52409 L p F P
0 g
s
.938 .685 .528 r
.17504 .52409 m .15577 .48478 L .15053 .49151 L p F P
0 g
s
.938 .685 .528 r
.23396 .71066 m .22563 .68242 L .20904 .68357 L p F P
0 g
s
.938 .685 .528 r
.20292 .64827 m .20904 .68357 L .22563 .68242 L p F P
0 g
s
.573 .366 .563 r
.94934 .69778 m .94137 .71785 L .94355 .73577 L p F P
0 g
s
.573 .366 .563 r
.94355 .73577 m .95126 .71309 L .94934 .69778 L p F P
0 g
s
.573 .366 .563 r
.94137 .71785 m .94934 .69778 L .95126 .71309 L p F P
0 g
s
0 .006 .577 r
.55437 .39808 m .54532 .39428 L .5561 .42358 L p F P
0 g
s
0 .006 .577 r
.5561 .42358 m .56259 .42044 L .55437 .39808 L p F P
0 g
s
0 0 .509 r
.56259 .42044 m .5561 .42358 L .5645 .45349 L p F P
0 g
s
0 0 .033 r
.5676 .55995 m .56009 .57873 L .55512 .60696 L p F P
0 g
s
0 0 .227 r
.54432 .62119 m .55512 .60696 L .56009 .57873 L p F P
0 g
s
.938 .685 .528 r
.12169 .41529 m .13768 .44791 L .14842 .44197 L p F P
0 g
s
.938 .685 .528 r
.14842 .44197 m .13622 .40775 L .12169 .41529 L p F P
0 g
s
.938 .685 .528 r
.20476 .62911 m .19501 .5875 L .18954 .58647 L p F P
0 g
s
.938 .685 .528 r
.23006 .69744 m .23728 .72194 L .21607 .72405 L p F P
0 g
s
.938 .685 .528 r
.21607 .72405 m .21171 .69893 L .23006 .69744 L p F P
0 g
s
.938 .685 .528 r
.14279 .46985 m .16345 .50632 L .1674 .50266 L p F P
0 g
s
.938 .685 .528 r
.1674 .50266 m .15067 .46295 L .14279 .46985 L p F P
0 g
s
.938 .685 .528 r
.23999 .73112 m .23396 .71066 L .21406 .71248 L p F P
0 g
s
.938 .685 .528 r
.20904 .68357 m .21406 .71248 L .23396 .71066 L p F P
0 g
s
.573 .366 .563 r
.91724 .74127 m .90146 .74361 L .90365 .76373 L p F P
0 g
s
.573 .366 .563 r
.88555 .75849 m .90365 .76373 L .90146 .74361 L p F P
0 g
s
.573 .366 .563 r
.91957 .76168 m .90365 .76373 L .90146 .74361 L p F P
0 g
s
.573 .366 .563 r
.90146 .74361 m .91724 .74127 L .91957 .76168 L p F P
0 g
s
.573 .366 .563 r
.95699 .69284 m .95245 .72263 L .95285 .72588 L p F P
0 g
s
.573 .366 .563 r
.95285 .72588 m .95731 .69538 L .95699 .69284 L p F P
0 g
s
.573 .366 .563 r
.95245 .72263 m .95699 .69284 L .95731 .69538 L p F P
0 g
s
.573 .366 .563 r
.95699 .69284 m .95245 .72263 L .95126 .71309 L p F P
0 g
s
.938 .685 .528 r
.14652 .46592 m .12937 .43096 L .14207 .42416 L p F P
0 g
s
.938 .685 .528 r
.13093 .39293 m .14207 .42416 L .12937 .43096 L p F P
0 g
s
.573 .366 .563 r
.90365 .76373 m .88555 .75849 L .88677 .77024 L p F P
0 g
s
.573 .366 .563 r
.90503 .77632 m .88677 .77024 L .88555 .75849 L p F P
0 g
s
.573 .366 .563 r
.88555 .75849 m .90365 .76373 L .90503 .77632 L p F P
0 g
s
.938 .685 .528 r
.1872 .56533 m .19185 .60725 L .18331 .60282 L p F P
0 g
s
.938 .685 .528 r
.18331 .60282 m .18433 .56378 L .1872 .56533 L p F P
0 g
s
.938 .685 .528 r
.23728 .72194 m .24205 .73811 L .21895 .7407 L p F P
0 g
s
.938 .685 .528 r
.21895 .7407 m .21607 .72405 L .23728 .72194 L p F P
0 g
s
.938 .685 .528 r
.15296 .48781 m .17412 .52515 L .17265 .52791 L p F P
0 g
s
.938 .685 .528 r
.17412 .52515 m .15296 .48781 L .15889 .48247 L p F P
0 g
s
.938 .685 .528 r
.24344 .74281 m .23999 .73112 L .2177 .7335 L p F P
0 g
s
.938 .685 .528 r
.21406 .71248 m .2177 .7335 L .23999 .73112 L p F P
0 g
s
.938 .685 .528 r
.24205 .73811 m .24414 .74518 L .22022 .74799 L p F P
0 g
s
.938 .685 .528 r
.22022 .74799 m .21895 .7407 L .24205 .73811 L p F P
0 g
s
.938 .685 .528 r
.10859 .38857 m .12169 .41529 L .13622 .40775 L p F P
0 g
s
.938 .685 .528 r
.13622 .40775 m .12628 .37988 L .10859 .38857 L p F P
0 g
s
.938 .685 .528 r
.24414 .74518 m .24344 .74281 L .2198 .74555 L p F P
0 g
s
.938 .685 .528 r
.2177 .7335 m .2198 .74555 L .24344 .74281 L p F P
0 g
s
.938 .685 .528 r
.2198 .74555 m .22022 .74799 L .24414 .74518 L p F P
0 g
s
0 .317 .788 r
.46636 .28618 m .44717 .27392 L .46826 .29537 L p F P
0 g
s
0 .317 .788 r
.46826 .29537 m .48508 .3053 L .46636 .28618 L p F P
0 g
s
0 0 .509 r
.5645 .45349 m .56901 .44326 L .56259 .42044 L p F P
0 g
s
0 0 .405 r
.56901 .44326 m .5645 .45349 L .57019 .48285 L p F P
0 g
s
.573 .366 .563 r
.95731 .69538 m .95285 .72588 L .95245 .72263 L p F P
0 g
s
.94 .689 .53 r
.40255 .47233 m .42345 .4665 L .41675 .44864 L p F P
0 g
s
.938 .682 .523 r
.42345 .4665 m .40255 .47233 L .40516 .48185 L p F P
0 g
s
.938 .682 .523 r
.40516 .48185 m .42849 .48481 L .42345 .4665 L p F P
0 g
s
.938 .685 .528 r
.12937 .43096 m .11473 .4011 L .13093 .39293 L p F P
0 g
s
.938 .685 .528 r
.12231 .36876 m .13093 .39293 L .11473 .4011 L p F P
0 g
s
.938 .685 .528 r
.19997 .60866 m .20933 .64861 L .19623 .64668 L p F P
0 g
s
.938 .685 .528 r
.19623 .64668 m .19185 .60725 L .19997 .60866 L p F P
0 g
s
0 .048 .615 r
.54469 .3771 m .53258 .36674 L .54532 .39428 L p F P
0 g
s
0 .048 .615 r
.54532 .39428 m .55437 .39808 L .54469 .3771 L p F P
0 g
s
.938 .685 .528 r
.18577 .56467 m .18761 .60541 L .19599 .60833 L p F P
0 g
s
.938 .685 .528 r
.18761 .60541 m .18577 .56467 L .18289 .56264 L p F P
0 g
s
.938 .685 .528 r
.14687 .50081 m .17213 .52959 L .17332 .52642 L p F P
0 g
s
.938 .685 .528 r
.17332 .52642 m .15053 .49151 L .14687 .50081 L p F P
0 g
s
.938 .685 .528 r
.09906 .36913 m .10859 .38857 L .12628 .37988 L p F P
0 g
s
.938 .685 .528 r
.12628 .37988 m .11908 .35969 L .09906 .36913 L p F P
0 g
s
.938 .685 .528 r
.14283 .44434 m .15889 .48247 L .15296 .48781 L p F P
0 g
s
.938 .685 .528 r
.19233 .58724 m .19953 .62876 L .1885 .62504 L p F P
0 g
s
.938 .685 .528 r
.1885 .62504 m .1867 .5852 L .19233 .58724 L p F P
0 g
s
.938 .685 .528 r
.11473 .4011 m .10334 .37786 L .12231 .36876 L p F P
0 g
s
.938 .685 .528 r
.11662 .3528 m .12231 .36876 L .10334 .37786 L p F P
0 g
s
.937 .675 .514 r
.42849 .48481 m .40516 .48185 L .40677 .4912 L p F P
0 g
s
.937 .675 .514 r
.40677 .4912 m .43164 .5028 L .42849 .48481 L p F P
0 g
s
.943 .696 .534 r
.39906 .46303 m .41675 .44864 L .40866 .43197 L p F P
0 g
s
.94 .689 .53 r
.41675 .44864 m .39906 .46303 L .40255 .47233 L p F P
0 g
s
.938 .685 .528 r
.09359 .35798 m .09906 .36913 L .11908 .35969 L p F P
0 g
s
.938 .685 .528 r
.11908 .35969 m .11496 .34815 L .09359 .35798 L p F P
0 g
s
.938 .685 .528 r
.14652 .46592 m .16531 .50425 L .16183 .50883 L p F P
0 g
s
.938 .685 .528 r
.18433 .56378 m .18331 .60282 L .17476 .59556 L p F P
0 g
s
.938 .685 .528 r
.17476 .59556 m .18147 .56129 L .18433 .56378 L p F P
0 g
s
.938 .685 .528 r
.10334 .37786 m .09579 .36247 L .11662 .3528 L p F P
0 g
s
.938 .685 .528 r
.11413 .34582 m .11662 .3528 L .09579 .36247 L p F P
0 g
s
.938 .685 .528 r
.14849 .49587 m .17265 .52791 L .17175 .53145 L p F P
0 g
s
.938 .685 .528 r
.17265 .52791 m .14849 .49587 L .15296 .48781 L p F P
0 g
s
.938 .685 .528 r
.09249 .35572 m .09359 .35798 L .11496 .34815 L p F P
0 g
s
.938 .685 .528 r
.11496 .34815 m .11413 .34582 L .09249 .35572 L p F P
0 g
s
.938 .685 .528 r
.09579 .36247 m .09249 .35572 L .11413 .34582 L p F P
0 g
s
.938 .685 .528 r
.21362 .66692 m .20476 .62911 L .19409 .6274 L p F P
0 g
s
.938 .685 .528 r
.18954 .58647 m .19409 .6274 L .20476 .62911 L p F P
0 g
s
.938 .685 .528 r
.17901 .59953 m .18289 .56264 L .18009 .55973 L p F P
0 g
s
.938 .685 .528 r
.18289 .56264 m .17901 .59953 L .18761 .60541 L p F P
0 g
s
.938 .685 .528 r
.14499 .51226 m .17153 .53345 L .17213 .52959 L p F P
0 g
s
.938 .685 .528 r
.17213 .52959 m .14687 .50081 L .14499 .51226 L p F P
0 g
s
.938 .685 .528 r
.12388 .43646 m .14279 .46985 L .15067 .46295 L p F P
0 g
s
.938 .685 .528 r
.15067 .46295 m .13547 .42685 L .12388 .43646 L p F P
0 g
s
.573 .366 .563 r
.94137 .71785 m .93062 .73258 L .93295 .75224 L p F P
0 g
s
.573 .366 .563 r
.93295 .75224 m .94355 .73577 L .94137 .71785 L p F P
0 g
s
.573 .366 .563 r
.95126 .71309 m .94355 .73577 L .94137 .71785 L p F P
0 g
s
.573 .366 .563 r
.93062 .73258 m .94137 .71785 L .94355 .73577 L p F P
0 g
s
.573 .366 .563 r
.93062 .73258 m .91724 .74127 L .91957 .76168 L p F P
0 g
s
.573 .366 .563 r
.90365 .76373 m .91957 .76168 L .91724 .74127 L p F P
0 g
s
.573 .366 .563 r
.93295 .75224 m .91957 .76168 L .91724 .74127 L p F P
0 g
s
.573 .366 .563 r
.91724 .74127 m .93062 .73258 L .93295 .75224 L p F P
0 g
s
.938 .685 .528 r
.19409 .6274 m .18954 .58647 L .18381 .58344 L p F P
0 g
s
.938 .685 .528 r
.18147 .56129 m .17476 .59556 L .16663 .58577 L p F P
0 g
s
.938 .685 .528 r
.16663 .58577 m .17876 .55798 L .18147 .56129 L p F P
0 g
s
.938 .685 .528 r
.20933 .64861 m .21758 .68382 L .20011 .68165 L p F P
0 g
s
.938 .685 .528 r
.20011 .68165 m .19623 .64668 L .20933 .64861 L p F P
0 g
s
.938 .685 .528 r
.1457 .5063 m .17175 .53145 L .17147 .53559 L p F P
0 g
s
.938 .685 .528 r
.17175 .53145 m .1457 .5063 L .14849 .49587 L p F P
0 g
s
.573 .366 .563 r
.88677 .77024 m .90503 .77632 L .90365 .76373 L p F P
0 g
s
.573 .366 .563 r
.90503 .77632 m .88677 .77024 L .88719 .77424 L p F P
0 g
s
.573 .366 .563 r
.9055 .7806 m .88719 .77424 L .88677 .77024 L p F P
0 g
s
.573 .366 .563 r
.88677 .77024 m .90503 .77632 L .9055 .7806 L p F P
0 g
s
.938 .685 .528 r
.13681 .48037 m .16048 .51178 L .16345 .50632 L p F P
0 g
s
.938 .685 .528 r
.16345 .50632 m .14279 .46985 L .13681 .48037 L p F P
0 g
s
.938 .685 .528 r
.20292 .64827 m .19599 .60833 L .18761 .60541 L p F P
0 g
s
.641 .271 .327 r
.53075 .62745 m .51447 .62573 L .50432 .64854 L p F P
0 g
s
.795 .447 .396 r
.51447 .62573 m .49569 .61625 L .48611 .63702 L p F P
0 g
s
.795 .447 .396 r
.48611 .63702 m .50432 .64854 L .51447 .62573 L p F P
0 g
s
.922 .635 .481 r
.45639 .558 m .43179 .53477 L .42872 .54733 L p F P
0 g
s
.922 .635 .481 r
.42872 .54733 m .45222 .5762 L .45639 .558 L p F P
0 g
s
.937 .669 .504 r
.43164 .5028 m .40677 .4912 L .40731 .49994 L p F P
0 g
s
.937 .669 .504 r
.40731 .49994 m .43276 .51969 L .43164 .5028 L p F P
0 g
s
.938 .685 .528 r
.18009 .55973 m .17062 .59096 L .17901 .59953 L p F P
0 g
s
.938 .685 .528 r
.17062 .59096 m .18009 .55973 L .17751 .55607 L p F P
0 g
s
.573 .366 .563 r
.95126 .71309 m .94355 .73577 L .94492 .74696 L p F P
0 g
s
.573 .366 .563 r
.94492 .74696 m .95245 .72263 L .95126 .71309 L p F P
0 g
s
.573 .366 .563 r
.94355 .73577 m .95126 .71309 L .95245 .72263 L p F P
0 g
s
.938 .685 .528 r
.14501 .52531 m .17157 .53782 L .17153 .53345 L p F P
0 g
s
.938 .685 .528 r
.17153 .53345 m .14499 .51226 L .14501 .52531 L p F P
0 g
s
.573 .366 .563 r
.91957 .76168 m .93295 .75224 L .93062 .73258 L p F P
0 g
s
.573 .366 .563 r
.94355 .73577 m .93295 .75224 L .93062 .73258 L p F P
0 g
s
.946 .703 .537 r
.39483 .45439 m .40866 .43197 L .39951 .41721 L p F P
0 g
s
.943 .696 .534 r
.40866 .43197 m .39483 .45439 L .39906 .46303 L p F P
0 g
s
.938 .685 .528 r
.15296 .48781 m .13306 .45266 L .14283 .44434 L p F P
0 g
s
.938 .685 .528 r
.12867 .41071 m .14283 .44434 L .13306 .45266 L p F P
0 g
s
.938 .685 .528 r
.12901 .45854 m .15053 .49151 L .15577 .48478 L p F P
0 g
s
.938 .685 .528 r
.15577 .48478 m .13768 .44791 L .12901 .45854 L p F P
0 g
s
.941 .721 .577 r
.39626 .37269 m .38968 .40503 L .39951 .41721 L p F P
0 g
s
.939 .75 .62 r
.38661 .32779 m .38188 .35943 L .39626 .37269 L p F P
0 g
s
.949 .732 .574 r
.38968 .40503 m .39626 .37269 L .38188 .35943 L p F P
0 g
s
.938 .685 .528 r
.17876 .55798 m .16663 .58577 L .15932 .57393 L p F P
0 g
s
.938 .685 .528 r
.15932 .57393 m .17634 .55402 L .17876 .55798 L p F P
0 g
s
.938 .685 .528 r
.22116 .69909 m .21362 .66692 L .19824 .66484 L p F P
0 g
s
.938 .685 .528 r
.19409 .6274 m .19824 .66484 L .21362 .66692 L p F P
0 g
s
0 0 .405 r
.57019 .48285 m .57336 .46561 L .56901 .44326 L p F P
0 g
s
0 0 .258 r
.57336 .46561 m .57019 .48285 L .57291 .51048 L p F P
0 g
s
.938 .685 .528 r
.14476 .51862 m .17147 .53559 L .17182 .54013 L p F P
0 g
s
.938 .685 .528 r
.17147 .53559 m .14476 .51862 L .1457 .5063 L p F P
0 g
s
.573 .366 .563 r
.88719 .77424 m .9055 .7806 L .90503 .77632 L p F P
0 g
s
.278 0 .163 r
.54432 .62119 m .53075 .62745 L .52049 .65116 L p F P
0 g
s
.641 .271 .327 r
.50432 .64854 m .52049 .65116 L .53075 .62745 L p F P
0 g
s
.866 .538 .428 r
.49569 .61625 m .47476 .5995 L .46622 .61722 L p F P
0 g
s
.866 .538 .428 r
.46622 .61722 m .48611 .63702 L .49569 .61625 L p F P
0 g
s
.938 .685 .528 r
.17751 .55607 m .16285 .58008 L .17062 .59096 L p F P
0 g
s
.938 .685 .528 r
.16285 .58008 m .17751 .55607 L .17527 .55184 L p F P
0 g
s
0 .053 .616 r
.53392 .35838 m .51835 .34206 L .53258 .36674 L p F P
0 g
s
0 .053 .616 r
.53258 .36674 m .54469 .3771 L .53392 .35838 L p F P
0 g
s
.938 .685 .528 r
.14694 .53932 m .17223 .54249 L .17157 .53782 L p F P
0 g
s
.938 .685 .528 r
.17157 .53782 m .14501 .52531 L .14694 .53932 L p F P
0 g
s
.938 .685 .528 r
.1867 .5852 m .1885 .62504 L .17714 .6174 L p F P
0 g
s
.938 .685 .528 r
.17714 .6174 m .18094 .5812 L .1867 .5852 L p F P
0 g
s
.819 .861 .879 r
.39282 .2575 m .3813 .26931 L .4035 .28358 L p F P
0 g
s
.819 .861 .879 r
.4035 .28358 m .41565 .27249 L .39282 .2575 L p F P
0 g
s
.907 .831 .76 r
.39381 .30221 m .4035 .28358 L .3813 .26931 L p F P
0 g
s
.938 .685 .528 r
.17634 .55402 m .15932 .57393 L .15321 .56061 L p F P
0 g
s
.938 .685 .528 r
.15321 .56061 m .17431 .54958 L .17634 .55402 L p F P
0 g
s
.938 .685 .528 r
.13954 .47468 m .16183 .50883 L .15942 .51511 L p F P
0 g
s
.938 .685 .528 r
.16183 .50883 m .13954 .47468 L .14652 .46592 L p F P
0 g
s
.938 .685 .528 r
.14574 .53224 m .17182 .54013 L .17278 .54487 L p F P
0 g
s
.938 .685 .528 r
.17182 .54013 m .14574 .53224 L .14476 .51862 L p F P
0 g
s
.938 .685 .528 r
.10768 .40787 m .12388 .43646 L .13547 .42685 L p F P
0 g
s
.938 .685 .528 r
.13547 .42685 m .12252 .39611 L .10768 .40787 L p F P
0 g
s
.938 .685 .528 r
.21758 .68382 m .22431 .71256 L .2033 .71037 L p F P
0 g
s
.938 .685 .528 r
.2033 .71037 m .20011 .68165 L .21758 .68382 L p F P
0 g
s
.938 .685 .528 r
.17527 .55184 m .15609 .56741 L .16285 .58008 L p F P
0 g
s
.938 .685 .528 r
.15609 .56741 m .17527 .55184 L .17348 .54724 L p F P
0 g
s
.938 .685 .528 r
.1507 .5536 m .17348 .54724 L .17223 .54249 L p F P
0 g
s
.938 .685 .528 r
.17223 .54249 m .14694 .53932 L .1507 .5536 L p F P
0 g
s
.938 .685 .528 r
.17431 .54958 m .15321 .56061 L .1486 .54647 L p F P
0 g
s
.938 .685 .528 r
.1486 .54647 m .17278 .54487 L .17431 .54958 L p F P
0 g
s
.938 .685 .528 r
.17278 .54487 m .1486 .54647 L .14574 .53224 L p F P
0 g
s
.573 .366 .563 r
.91957 .76168 m .90365 .76373 L .90503 .77632 L p F P
0 g
s
.573 .366 .563 r
.92102 .77445 m .90503 .77632 L .90365 .76373 L p F P
0 g
s
.573 .366 .563 r
.90365 .76373 m .91957 .76168 L .92102 .77445 L p F P
0 g
s
.938 .685 .528 r
.17348 .54724 m .1507 .5536 L .15609 .56741 L p F P
0 g
s
.938 .685 .528 r
.19953 .62876 m .2061 .66661 L .19015 .6616 L p F P
0 g
s
.938 .685 .528 r
.19015 .6616 m .1885 .62504 L .19953 .62876 L p F P
0 g
s
.907 .831 .76 r
.3813 .26931 m .37332 .28941 L .39381 .30221 L p F P
0 g
s
.94 .796 .674 r
.38661 .32779 m .39381 .30221 L .37332 .28941 L p F P
0 g
s
.574 .816 .99 r
.40784 .25435 m .39282 .2575 L .41565 .27249 L p F P
0 g
s
.574 .816 .99 r
.41565 .27249 m .43023 .26927 L .40784 .25435 L p F P
0 g
s
.938 .685 .528 r
.19185 .60725 m .19623 .64668 L .18235 .6398 L p F P
0 g
s
.938 .685 .528 r
.18235 .6398 m .18331 .60282 L .19185 .60725 L p F P
0 g
s
.938 .685 .528 r
.12937 .43096 m .14652 .46592 L .13954 .47468 L p F P
0 g
s
.938 .685 .528 r
.22701 .72405 m .22116 .69909 L .2018 .6969 L p F P
0 g
s
.938 .685 .528 r
.19824 .66484 m .2018 .6969 L .22116 .69909 L p F P
0 g
s
.938 .685 .528 r
.13306 .45266 m .11539 .42146 L .12867 .41071 L p F P
0 g
s
.938 .685 .528 r
.1171 .38324 m .12867 .41071 L .11539 .42146 L p F P
0 g
s
.938 .685 .528 r
.18381 .58344 m .18282 .62169 L .19409 .6274 L p F P
0 g
s
.938 .685 .528 r
.18282 .62169 m .18381 .58344 L .1781 .57852 L p F P
0 g
s
.573 .366 .563 r
.95245 .72263 m .94492 .74696 L .94538 .75077 L p F P
0 g
s
.573 .366 .563 r
.94538 .75077 m .95285 .72588 L .95245 .72263 L p F P
0 g
s
.573 .366 .563 r
.94492 .74696 m .95245 .72263 L .95285 .72588 L p F P
0 g
s
.573 .366 .563 r
.95245 .72263 m .94492 .74696 L .94355 .73577 L p F P
0 g
s
.938 .685 .528 r
.13306 .45266 m .15296 .48781 L .14849 .49587 L p F P
0 g
s
.938 .685 .528 r
.13305 .49409 m .15866 .5188 L .16048 .51178 L p F P
0 g
s
.938 .685 .528 r
.16048 .51178 m .13681 .48037 L .13305 .49409 L p F P
0 g
s
.938 .685 .528 r
.22431 .71256 m .2292 .73342 L .20562 .7313 L p F P
0 g
s
.938 .685 .528 r
.20562 .7313 m .2033 .71037 L .22431 .71256 L p F P
0 g
s
.938 .685 .528 r
.09505 .38556 m .10768 .40787 L .12252 .39611 L p F P
0 g
s
.938 .685 .528 r
.12252 .39611 m .11247 .37226 L .09505 .38556 L p F P
0 g
s
.938 .663 .493 r
.43276 .51969 m .40731 .49994 L .40673 .50768 L p F P
0 g
s
.938 .663 .493 r
.40673 .50768 m .43179 .53477 L .43276 .51969 L p F P
0 g
s
.573 .366 .563 r
.95285 .72588 m .94538 .75077 L .94492 .74696 L p F P
0 g
s
.903 .591 .446 r
.47476 .5995 m .45222 .5762 L .44519 .59006 L p F P
0 g
s
.903 .591 .446 r
.44519 .59006 m .46622 .61722 L .47476 .5995 L p F P
0 g
s
.938 .685 .528 r
.20904 .68357 m .20292 .64827 L .18935 .64385 L p F P
0 g
s
.938 .685 .528 r
.18761 .60541 m .18935 .64385 L .20292 .64827 L p F P
0 g
s
0 0 0 r
.55512 .60696 m .54432 .62119 L .53438 .64459 L p F P
0 g
s
.278 0 .163 r
.52049 .65116 m .53438 .64459 L .54432 .62119 L p F P
0 g
s
.938 .685 .528 r
.23087 .74056 m .22701 .72405 L .20458 .72189 L p F P
0 g
s
.938 .685 .528 r
.2018 .6969 m .20458 .72189 L .22701 .72405 L p F P
0 g
s
.573 .366 .563 r
.94355 .73577 m .93295 .75224 L .9344 .76453 L p F P
0 g
s
.573 .366 .563 r
.9344 .76453 m .94492 .74696 L .94355 .73577 L p F P
0 g
s
.573 .366 .563 r
.93295 .75224 m .94355 .73577 L .94492 .74696 L p F P
0 g
s
.951 .709 .537 r
.39005 .44678 m .39951 .41721 L .38968 .40503 L p F P
0 g
s
.946 .703 .537 r
.39951 .41721 m .39005 .44678 L .39483 .45439 L p F P
0 g
s
0 0 .157 r
.5676 .55995 m .57249 .53525 L .57291 .51048 L p F P
0 g
s
0 0 0 r
.57249 .53525 m .5676 .55995 L .56323 .58506 L p F P
0 g
s
0 0 .033 r
.55512 .60696 m .56323 .58506 L .5676 .55995 L p F P
0 g
s
.938 .685 .528 r
.18094 .5812 m .17714 .6174 L .16601 .60614 L p F P
0 g
s
.938 .685 .528 r
.16601 .60614 m .17533 .57542 L .18094 .5812 L p F P
0 g
s
.938 .685 .528 r
.13463 .48687 m .15942 .51511 L .1582 .5228 L p F P
0 g
s
.938 .685 .528 r
.15942 .51511 m .13463 .48687 L .13954 .47468 L p F P
0 g
s
.938 .685 .528 r
.11539 .42146 m .10087 .39584 L .1171 .38324 L p F P
0 g
s
.938 .685 .528 r
.1087 .3633 m .1171 .38324 L .10087 .39584 L p F P
0 g
s
.938 .685 .528 r
.2292 .73342 m .232 .74536 L .20696 .74331 L p F P
0 g
s
.938 .685 .528 r
.20696 .74331 m .20562 .7313 L .2292 .73342 L p F P
0 g
s
.938 .685 .528 r
.10985 .42919 m .12901 .45854 L .13768 .44791 L p F P
0 g
s
.938 .685 .528 r
.13768 .44791 m .12169 .41529 L .10985 .42919 L p F P
0 g
s
.94 .796 .674 r
.37332 .28941 m .36882 .31707 L .38661 .32779 L p F P
0 g
s
.953 .766 .613 r
.38188 .35943 m .38661 .32779 L .36882 .31707 L p F P
0 g
s
.938 .685 .528 r
.18935 .64385 m .18761 .60541 L .17901 .59953 L p F P
0 g
s
.938 .685 .528 r
.23257 .74778 m .23087 .74056 L .20642 .73847 L p F P
0 g
s
.938 .685 .528 r
.20458 .72189 m .20642 .73847 L .23087 .74056 L p F P
0 g
s
.573 .366 .563 r
.93295 .75224 m .91957 .76168 L .92102 .77445 L p F P
0 g
s
.573 .366 .563 r
.90503 .77632 m .92102 .77445 L .91957 .76168 L p F P
0 g
s
.573 .366 .563 r
.9344 .76453 m .92102 .77445 L .91957 .76168 L p F P
0 g
s
.573 .366 .563 r
.91957 .76168 m .93295 .75224 L .9344 .76453 L p F P
0 g
s
0 .085 .588 r
.48768 .30545 m .46636 .28618 L .48508 .3053 L p F P
0 g
s
0 .085 .588 r
.48508 .3053 m .50318 .32131 L .48768 .30545 L p F P
0 g
s
.086 .552 .905 r
.42627 .25989 m .40784 .25435 L .43023 .26927 L p F P
0 g
s
.086 .552 .905 r
.43023 .26927 m .44717 .27392 L .42627 .25989 L p F P
0 g
s
.938 .685 .528 r
.232 .74536 m .23257 .74778 L .20723 .74574 L p F P
0 g
s
.938 .685 .528 r
.20723 .74574 m .20696 .74331 L .232 .74536 L p F P
0 g
s
.938 .685 .528 r
.08667 .37076 m .09505 .38556 L .11247 .37226 L p F P
0 g
s
.938 .685 .528 r
.11247 .37226 m .10583 .35648 L .08667 .37076 L p F P
0 g
s
.573 .366 .563 r
.92102 .77445 m .90503 .77632 L .9055 .7806 L p F P
0 g
s
.573 .366 .563 r
.92152 .77879 m .9055 .7806 L .90503 .77632 L p F P
0 g
s
.573 .366 .563 r
.90503 .77632 m .92102 .77445 L .92152 .77879 L p F P
0 g
s
.938 .685 .528 r
.19824 .66484 m .19409 .6274 L .18282 .62169 L p F P
0 g
s
.938 .685 .528 r
.12287 .47346 m .14687 .50081 L .15053 .49151 L p F P
0 g
s
.938 .685 .528 r
.15053 .49151 m .12901 .45854 L .12287 .47346 L p F P
0 g
s
.938 .685 .528 r
.20642 .73847 m .20723 .74574 L .23257 .74778 L p F P
0 g
s
.938 .685 .528 r
.1781 .57852 m .17151 .61219 L .18282 .62169 L p F P
0 g
s
.938 .685 .528 r
.17151 .61219 m .1781 .57852 L .17267 .57194 L p F P
0 g
s
.938 .685 .528 r
.2061 .66661 m .21171 .69893 L .19157 .693 L p F P
0 g
s
.938 .685 .528 r
.19157 .693 m .19015 .6616 L .2061 .66661 L p F P
0 g
s
.573 .366 .563 r
.92102 .77445 m .9344 .76453 L .93295 .75224 L p F P
0 g
s
.573 .366 .563 r
.94492 .74696 m .9344 .76453 L .93295 .75224 L p F P
0 g
s
.938 .685 .528 r
.13175 .51036 m .15806 .52707 L .15866 .5188 L p F P
0 g
s
.938 .685 .528 r
.15866 .5188 m .13305 .49409 L .13175 .51036 L p F P
0 g
s
.938 .685 .528 r
.10087 .39584 m .09029 .37716 L .1087 .3633 L p F P
0 g
s
.938 .685 .528 r
.10389 .35188 m .1087 .3633 L .09029 .37716 L p F P
0 g
s
.938 .685 .528 r
.11499 .45145 m .13681 .48037 L .14279 .46985 L p F P
0 g
s
.938 .685 .528 r
.14279 .46985 m .12388 .43646 L .11499 .45145 L p F P
0 g
s
.657 .551 .723 r
.77812 .32672 m .76218 .33232 L .77612 .37547 L p F P
0 g
s
.657 .551 .723 r
.77612 .37547 m .79225 .37047 L .77812 .32672 L p F P
0 g
s
.746 .6 .695 r
.75559 .38067 m .77612 .37547 L .76218 .33232 L p F P
0 g
s
.643 .504 .678 r
.79225 .37047 m .77612 .37547 L .78719 .41847 L p F P
0 g
s
.735 .56 .655 r
.77612 .37547 m .75559 .38067 L .76595 .42123 L p F P
0 g
s
.735 .56 .655 r
.76595 .42123 m .78719 .41847 L .77612 .37547 L p F P
0 g
s
.671 .596 .763 r
.76165 .28435 m .74587 .29054 L .76218 .33232 L p F P
0 g
s
.671 .596 .763 r
.76218 .33232 m .77812 .32672 L .76165 .28435 L p F P
0 g
s
.759 .64 .73 r
.74244 .33997 m .76218 .33232 L .74587 .29054 L p F P
0 g
s
.746 .6 .695 r
.76218 .33232 m .74244 .33997 L .75559 .38067 L p F P
0 g
s
.938 .685 .528 r
.08299 .36427 m .08667 .37076 L .10583 .35648 L p F P
0 g
s
.938 .685 .528 r
.10583 .35648 m .10292 .34957 L .08299 .36427 L p F P
0 g
s
.573 .366 .563 r
.9055 .7806 m .92152 .77879 L .92102 .77445 L p F P
0 g
s
.938 .685 .528 r
.13954 .47468 m .11906 .44331 L .12937 .43096 L p F P
0 g
s
.938 .685 .528 r
.11473 .4011 m .12937 .43096 L .11906 .44331 L p F P
0 g
s
0 0 .258 r
.57291 .51048 m .57544 .48656 L .57336 .46561 L p F P
0 g
s
0 0 .058 r
.57544 .48656 m .57291 .51048 L .57249 .53525 L p F P
0 g
s
.938 .685 .528 r
.09029 .37716 m .08422 .36644 L .10389 .35188 L p F P
0 g
s
.938 .685 .528 r
.10292 .34957 m .10389 .35188 L .08422 .36644 L p F P
0 g
s
.938 .685 .528 r
.17533 .57542 m .16601 .60614 L .1557 .59178 L p F P
0 g
s
.938 .685 .528 r
.1557 .59178 m .17015 .56812 L .17533 .57542 L p F P
0 g
s
.938 .685 .528 r
.08422 .36644 m .08299 .36427 L .10292 .34957 L p F P
0 g
s
.938 .685 .528 r
.13208 .50195 m .1582 .5228 L .15824 .53154 L p F P
0 g
s
.938 .685 .528 r
.1582 .5228 m .13208 .50195 L .13463 .48687 L p F P
0 g
s
.573 .366 .563 r
.94492 .74696 m .9344 .76453 L .93489 .76871 L p F P
0 g
s
.573 .366 .563 r
.93489 .76871 m .94538 .75077 L .94492 .74696 L p F P
0 g
s
.573 .366 .563 r
.9344 .76453 m .94492 .74696 L .94538 .75077 L p F P
0 g
s
0 .018 .564 r
.5225 .34273 m .50318 .32131 L .51835 .34206 L p F P
0 g
s
0 .018 .564 r
.51835 .34206 m .53392 .35838 L .5225 .34273 L p F P
0 g
s
.938 .685 .528 r
.18331 .60282 m .18235 .6398 L .16838 .6282 L p F P
0 g
s
.938 .685 .528 r
.16838 .6282 m .17476 .59556 L .18331 .60282 L p F P
0 g
s
.938 .685 .528 r
.21406 .71248 m .20904 .68357 L .19089 .67806 L p F P
0 g
s
.938 .685 .528 r
.18935 .64385 m .19089 .67806 L .20904 .68357 L p F P
0 g
s
.938 .685 .528 r
.12559 .4655 m .14849 .49587 L .1457 .5063 L p F P
0 g
s
.938 .685 .528 r
.14849 .49587 m .12559 .4655 L .13306 .45266 L p F P
0 g
s
.488 .45 .741 r
.79022 .32321 m .77812 .32672 L .79225 .37047 L p F P
0 g
s
.488 .45 .741 r
.79225 .37047 m .80392 .36565 L .79022 .32321 L p F P
0 g
s
.466 .392 .689 r
.80392 .36565 m .79225 .37047 L .80353 .41404 L p F P
0 g
s
.643 .504 .678 r
.78719 .41847 m .80353 .41404 L .79225 .37047 L p F P
0 g
s
.796 .626 .671 r
.73079 .38606 m .75559 .38067 L .74244 .33997 L p F P
0 g
s
.787 .59 .635 r
.75559 .38067 m .73079 .38606 L .74 .42239 L p F P
0 g
s
.787 .59 .635 r
.74 .42239 m .76595 .42123 L .75559 .38067 L p F P
0 g
s
.938 .685 .528 r
.17267 .57194 m .16072 .59931 L .17151 .61219 L p F P
0 g
s
.938 .685 .528 r
.16072 .59931 m .17267 .57194 L .1678 .56401 L p F P
0 g
s
.501 .501 .789 r
.77429 .2821 m .76165 .28435 L .77812 .32672 L p F P
0 g
s
.501 .501 .789 r
.77812 .32672 m .79022 .32321 L .77429 .2821 L p F P
0 g
s
.759 .64 .73 r
.74587 .29054 m .72698 .30061 L .74244 .33997 L p F P
0 g
s
.808 .662 .702 r
.71901 .34961 m .74244 .33997 L .72698 .30061 L p F P
0 g
s
.796 .626 .671 r
.74244 .33997 m .71901 .34961 L .73079 .38606 L p F P
0 g
s
.938 .685 .528 r
.13301 .52838 m .15873 .53617 L .15806 .52707 L p F P
0 g
s
.938 .685 .528 r
.15806 .52707 m .13175 .51036 L .13301 .52838 L p F P
0 g
s
.938 .685 .528 r
.19623 .64668 m .20011 .68165 L .1815 .6728 L p F P
0 g
s
.938 .685 .528 r
.1815 .6728 m .18235 .6398 L .19623 .64668 L p F P
0 g
s
.573 .366 .563 r
.94538 .75077 m .93489 .76871 L .9344 .76453 L p F P
0 g
s
.938 .685 .528 r
.09407 .40502 m .10985 .42919 L .12169 .41529 L p F P
0 g
s
.938 .685 .528 r
.12169 .41529 m .10859 .38857 L .09407 .40502 L p F P
0 g
s
.926 .627 .458 r
.45222 .5762 m .42872 .54733 L .42366 .55677 L p F P
0 g
s
.926 .627 .458 r
.42366 .55677 m .44519 .59006 L .45222 .5762 L p F P
0 g
s
.573 .366 .563 r
.9344 .76453 m .92102 .77445 L .92152 .77879 L p F P
0 g
s
.573 .366 .563 r
.93489 .76871 m .92152 .77879 L .92102 .77445 L p F P
0 g
s
.573 .366 .563 r
.92102 .77445 m .9344 .76453 L .93489 .76871 L p F P
0 g
s
.939 .658 .48 r
.43179 .53477 m .40673 .50768 L .40507 .51408 L p F P
0 g
s
.939 .658 .48 r
.40507 .51408 m .42872 .54733 L .43179 .53477 L p F P
0 g
s
.938 .685 .528 r
.1885 .62504 m .19015 .6616 L .17363 .65082 L p F P
0 g
s
.938 .685 .528 r
.17363 .65082 m .17714 .6174 L .1885 .62504 L p F P
0 g
s
.938 .685 .528 r
.17015 .56812 m .1557 .59178 L .14672 .57502 L p F P
0 g
s
.938 .685 .528 r
.14672 .57502 m .16565 .55965 L .17015 .56812 L p F P
0 g
s
.938 .685 .528 r
.11539 .42146 m .13306 .45266 L .12559 .4655 L p F P
0 g
s
.938 .685 .528 r
.13206 .51921 m .15824 .53154 L .15954 .5409 L p F P
0 g
s
.938 .685 .528 r
.15824 .53154 m .13206 .51921 L .13208 .50195 L p F P
0 g
s
.938 .685 .528 r
.21171 .69893 m .21607 .72405 L .19267 .71753 L p F P
0 g
s
.938 .685 .528 r
.19267 .71753 m .19157 .693 L .21171 .69893 L p F P
0 g
s
0 0 0 r
.53438 .64459 m .54589 .62886 L .55512 .60696 L p F P
0 g
s
.704 .783 .3 r
.56323 .58506 m .55512 .60696 L .54589 .62886 L p F P
0 g
s
.951 .709 .537 r
.38968 .40503 m .38495 .44056 L .39005 .44678 L p F P
0 g
s
.949 .732 .574 r
.38188 .35943 m .3796 .39598 L .38968 .40503 L p F P
0 g
s
.955 .714 .534 r
.38495 .44056 m .38968 .40503 L .3796 .39598 L p F P
0 g
s
.573 .366 .563 r
.92152 .77879 m .93489 .76871 L .9344 .76453 L p F P
0 g
s
.938 .685 .528 r
.11906 .44331 m .13954 .47468 L .13463 .48687 L p F P
0 g
s
.953 .766 .613 r
.36882 .31707 m .36768 .35123 L .38188 .35943 L p F P
0 g
s
.958 .741 .567 r
.3796 .39598 m .38188 .35943 L .36768 .35123 L p F P
0 g
s
.938 .685 .528 r
.1678 .56401 m .15101 .58365 L .16072 .59931 L p F P
0 g
s
.938 .685 .528 r
.15101 .58365 m .1678 .56401 L .16373 .55511 L p F P
0 g
s
.938 .685 .528 r
.13678 .54726 m .16065 .54568 L .15873 .53617 L p F P
0 g
s
.938 .685 .528 r
.15873 .53617 m .13301 .52838 L .13678 .54726 L p F P
0 g
s
.938 .685 .528 r
.17533 .63457 m .17901 .59953 L .17062 .59096 L p F P
0 g
s
.938 .685 .528 r
.17901 .59953 m .17533 .63457 L .18935 .64385 L p F P
0 g
s
.626 .451 .626 r
.80353 .41404 m .78719 .41847 L .79497 .45978 L p F P
0 g
s
.725 .517 .609 r
.78719 .41847 m .76595 .42123 L .77314 .46018 L p F P
0 g
s
.725 .517 .609 r
.77314 .46018 m .79497 .45978 L .78719 .41847 L p F P
0 g
s
.938 .685 .528 r
.11964 .49202 m .14499 .51226 L .14687 .50081 L p F P
0 g
s
.938 .685 .528 r
.14687 .50081 m .12287 .47346 L .11964 .49202 L p F P
0 g
s
.938 .685 .528 r
.16565 .55965 m .14672 .57502 L .13956 .55671 L p F P
0 g
s
.938 .685 .528 r
.13956 .55671 m .16205 .55043 L .16565 .55965 L p F P
0 g
s
.938 .685 .528 r
.13459 .53777 m .15954 .5409 L .16205 .55043 L p F P
0 g
s
.938 .685 .528 r
.15954 .5409 m .13459 .53777 L .13206 .51921 L p F P
0 g
s
.938 .685 .528 r
.11906 .44331 m .10148 .41637 L .11473 .4011 L p F P
0 g
s
.938 .685 .528 r
.10334 .37786 m .11473 .4011 L .10148 .41637 L p F P
0 g
s
.684 .643 .803 r
.7434 .24488 m .72774 .25166 L .74587 .29054 L p F P
0 g
s
.684 .643 .803 r
.74587 .29054 m .76165 .28435 L .7434 .24488 L p F P
0 g
s
.774 .683 .763 r
.72698 .30061 m .74587 .29054 L .72774 .25166 L p F P
0 g
s
0 .19 .618 r
.44792 .27378 m .42627 .25989 L .44717 .27392 L p F P
0 g
s
0 .19 .618 r
.44717 .27392 m .46636 .28618 L .44792 .27378 L p F P
0 g
s
.938 .685 .528 r
.16373 .55511 m .14289 .566 L .15101 .58365 L p F P
0 g
s
.938 .685 .528 r
.14289 .566 m .16373 .55511 L .16065 .54568 L p F P
0 g
s
.938 .685 .528 r
.2177 .7335 m .21406 .71248 L .19216 .70621 L p F P
0 g
s
.938 .685 .528 r
.19089 .67806 m .19216 .70621 L .21406 .71248 L p F P
0 g
s
.938 .685 .528 r
.16065 .54568 m .13678 .54726 L .14289 .566 L p F P
0 g
s
.938 .685 .528 r
.16205 .55043 m .13956 .55671 L .13459 .53777 L p F P
0 g
s
.938 .685 .528 r
.2018 .6969 m .19824 .66484 L .18191 .65692 L p F P
0 g
s
.938 .685 .528 r
.18282 .62169 m .18191 .65692 L .19824 .66484 L p F P
0 g
s
.78 .554 .592 r
.76595 .42123 m .74 .42239 L .74626 .45724 L p F P
0 g
s
.78 .554 .592 r
.74626 .45724 m .77314 .46018 L .76595 .42123 L p F P
0 g
s
.466 .392 .689 r
.80353 .41404 m .81491 .4079 L .80392 .36565 L p F P
0 g
s
.431 .321 .628 r
.81491 .4079 m .80353 .41404 L .81154 .45588 L p F P
0 g
s
.626 .451 .626 r
.79497 .45978 m .81154 .45588 L .80353 .41404 L p F P
0 g
s
.938 .685 .528 r
.21607 .72405 m .21895 .7407 L .19341 .73384 L p F P
0 g
s
.938 .685 .528 r
.19341 .73384 m .19267 .71753 L .21607 .72405 L p F P
0 g
s
.938 .685 .528 r
.08254 .38736 m .09407 .40502 L .10859 .38857 L p F P
0 g
s
.938 .685 .528 r
.10859 .38857 m .09906 .36913 L .08254 .38736 L p F P
0 g
s
.938 .685 .528 r
.09621 .42653 m .11499 .45145 L .12388 .43646 L p F P
0 g
s
.938 .685 .528 r
.12388 .43646 m .10768 .40787 L .09621 .42653 L p F P
0 g
s
.938 .685 .528 r
.17476 .59556 m .16838 .6282 L .15502 .61237 L p F P
0 g
s
.938 .685 .528 r
.15502 .61237 m .16663 .58577 L .17476 .59556 L p F P
0 g
s
.774 .683 .763 r
.72774 .25166 m .70976 .26404 L .72698 .30061 L p F P
0 g
s
.823 .701 .73 r
.7051 .3144 m .72698 .30061 L .70976 .26404 L p F P
0 g
s
.808 .662 .702 r
.72698 .30061 m .7051 .3144 L .71901 .34961 L p F P
0 g
s
.938 .685 .528 r
.18191 .65692 m .18282 .62169 L .17151 .61219 L p F P
0 g
s
.505 .549 .835 r
.75668 .2438 m .7434 .24488 L .76165 .28435 L p F P
0 g
s
.505 .549 .835 r
.76165 .28435 m .77429 .2821 L .75668 .2438 L p F P
0 g
s
.938 .685 .528 r
.12087 .48234 m .1457 .5063 L .14476 .51862 L p F P
0 g
s
.938 .685 .528 r
.1457 .5063 m .12087 .48234 L .12559 .4655 L p F P
0 g
s
.938 .685 .528 r
.19089 .67806 m .18935 .64385 L .17533 .63457 L p F P
0 g
s
.938 .685 .528 r
.10933 .4712 m .13305 .49409 L .13681 .48037 L p F P
0 g
s
.938 .685 .528 r
.13681 .48037 m .11499 .45145 L .10933 .4712 L p F P
0 g
s
.938 .685 .528 r
.2198 .74555 m .2177 .7335 L .19309 .72678 L p F P
0 g
s
.938 .685 .528 r
.19216 .70621 m .19309 .72678 L .2177 .7335 L p F P
0 g
s
.938 .685 .528 r
.10148 .41637 m .08773 .3953 L .10334 .37786 L p F P
0 g
s
.938 .685 .528 r
.09579 .36247 m .10334 .37786 L .08773 .3953 L p F P
0 g
s
.825 .641 .653 r
.70196 .39165 m .73079 .38606 L .71901 .34961 L p F P
0 g
s
.817 .608 .619 r
.73079 .38606 m .70196 .39165 L .70959 .42209 L p F P
0 g
s
.817 .608 .619 r
.70959 .42209 m .74 .42239 L .73079 .38606 L p F P
0 g
s
.953 .689 .496 r
.3822 .47786 m .40255 .47233 L .39906 .46303 L closepath p F P
0 g
s
.953 .686 .494 r
.3822 .47786 m .40516 .48185 L .40255 .47233 L closepath p F P
0 g
s
.938 .685 .528 r
.10138 .44898 m .12287 .47346 L .12901 .45854 L p F P
0 g
s
.938 .685 .528 r
.12901 .45854 m .10985 .42919 L .10138 .44898 L p F P
0 g
s
.163 .241 .698 r
.79845 .32179 m .79022 .32321 L .80392 .36565 L p F P
0 g
s
.163 .241 .698 r
.80392 .36565 m .81112 .36104 L .79845 .32179 L p F P
0 g
s
.128 .169 .635 r
.81112 .36104 m .80392 .36565 L .81491 .4079 L p F P
0 g
s
.836 .674 .681 r
.69209 .36112 m .71901 .34961 L .7051 .3144 L p F P
0 g
s
.825 .641 .653 r
.71901 .34961 m .69209 .36112 L .70196 .39165 L p F P
0 g
s
0 0 .514 r
.56292 .40332 m .55437 .39808 L .56259 .42044 L p F P
0 g
s
0 0 .514 r
.56259 .42044 m .56811 .41745 L .56292 .40332 L p F P
0 g
s
0 0 .446 r
.56811 .41745 m .56259 .42044 L .56901 .44326 L p F P
0 g
s
.172 .294 .748 r
.78374 .28376 m .77429 .2821 L .79022 .32321 L p F P
0 g
s
.172 .294 .748 r
.79022 .32321 m .79845 .32179 L .78374 .28376 L p F P
0 g
s
.938 .685 .528 r
.20011 .68165 m .2033 .71037 L .18079 .70003 L p F P
0 g
s
.938 .685 .528 r
.18079 .70003 m .1815 .6728 L .20011 .68165 L p F P
0 g
s
.938 .685 .528 r
.21895 .7407 m .22022 .74799 L .19374 .741 L p F P
0 g
s
.938 .685 .528 r
.19374 .741 m .19341 .73384 L .21895 .7407 L p F P
0 g
s
.952 .684 .491 r
.3822 .47786 m .40677 .4912 L .40516 .48185 L closepath p F P
0 g
s
.954 .691 .498 r
.3822 .47786 m .39906 .46303 L .39483 .45439 L closepath p F P
0 g
s
.938 .685 .528 r
.17062 .59096 m .16158 .62077 L .17533 .63457 L p F P
0 g
s
.938 .685 .528 r
.16158 .62077 m .17062 .59096 L .16285 .58008 L p F P
0 g
s
.938 .685 .528 r
.22022 .74799 m .2198 .74555 L .19363 .7386 L p F P
0 g
s
.938 .685 .528 r
.19309 .72678 m .19363 .7386 L .2198 .74555 L p F P
0 g
s
.938 .685 .528 r
.11955 .51331 m .14501 .52531 L .14499 .51226 L p F P
0 g
s
.938 .685 .528 r
.14499 .51226 m .11964 .49202 L .11955 .51331 L p F P
0 g
s
.938 .685 .528 r
.07591 .37721 m .08254 .38736 L .09906 .36913 L p F P
0 g
s
.938 .685 .528 r
.09906 .36913 m .09359 .35798 L .07591 .37721 L p F P
0 g
s
0 0 .446 r
.56901 .44326 m .57216 .43187 L .56811 .41745 L p F P
0 g
s
0 0 .341 r
.57216 .43187 m .56901 .44326 L .57336 .46561 L p F P
0 g
s
.938 .685 .528 r
.19363 .7386 m .19374 .741 L .22022 .74799 L p F P
0 g
s
0 0 .546 r
.55682 .39009 m .54469 .3771 L .55437 .39808 L p F P
0 g
s
0 0 .546 r
.55437 .39808 m .56292 .40332 L .55682 .39009 L p F P
0 g
s
.938 .685 .528 r
.12559 .4655 m .10515 .43839 L .11539 .42146 L p F P
0 g
s
.938 .685 .528 r
.10087 .39584 m .11539 .42146 L .10515 .43839 L p F P
0 g
s
.952 .682 .487 r
.3822 .47786 m .40731 .49994 L .40677 .4912 L closepath p F P
0 g
s
.955 .693 .499 r
.3822 .47786 m .39483 .45439 L .39005 .44678 L closepath p F P
0 g
s
.938 .685 .528 r
.08773 .3953 m .07858 .3813 L .09579 .36247 L p F P
0 g
s
.938 .685 .528 r
.09249 .35572 m .09579 .36247 L .07858 .3813 L p F P
0 g
s
.941 .654 .467 r
.42872 .54733 m .40507 .51408 L .40238 .51881 L p F P
0 g
s
.941 .654 .467 r
.40238 .51881 m .42366 .55677 L .42872 .54733 L p F P
0 g
s
.938 .685 .528 r
.17714 .6174 m .17363 .65082 L .15737 .63465 L p F P
0 g
s
.938 .685 .528 r
.15737 .63465 m .16601 .60614 L .17714 .6174 L p F P
0 g
s
0 0 .058 r
.57249 .53525 m .57514 .50522 L .57544 .48656 L p F P
0 g
s
0 0 0 r
.56323 .58506 m .56888 .55604 L .57249 .53525 L p F P
0 g
s
.786 .715 .18 r
.57514 .50522 m .57249 .53525 L .56888 .55604 L p F P
0 g
s
.938 .685 .528 r
.16663 .58577 m .15502 .61237 L .14298 .59305 L p F P
0 g
s
.938 .685 .528 r
.14298 .59305 m .15932 .57393 L .16663 .58577 L p F P
0 g
s
.796 .396 .294 r
.50432 .64854 m .48611 .63702 L .47264 .65061 L p F P
0 g
s
.873 .515 .367 r
.48611 .63702 m .46622 .61722 L .45434 .62866 L p F P
0 g
s
.873 .515 .367 r
.45434 .62866 m .47264 .65061 L .48611 .63702 L p F P
0 g
s
.938 .685 .528 r
.07457 .37515 m .07591 .37721 L .09359 .35798 L p F P
0 g
s
.938 .685 .528 r
.09359 .35798 m .09249 .35572 L .07457 .37515 L p F P
0 g
s
.958 .741 .567 r
.36768 .35123 m .3697 .39054 L .3796 .39598 L p F P
0 g
s
.96 .719 .529 r
.37973 .43601 m .3796 .39598 L .3697 .39054 L p F P
0 g
s
.955 .714 .534 r
.3796 .39598 m .37973 .43601 L .38495 .44056 L p F P
0 g
s
.938 .685 .528 r
.11173 .46078 m .13463 .48687 L .13208 .50195 L p F P
0 g
s
.938 .685 .528 r
.13463 .48687 m .11173 .46078 L .11906 .44331 L p F P
0 g
s
.938 .685 .528 r
.1192 .50239 m .14476 .51862 L .14574 .53224 L p F P
0 g
s
.938 .685 .528 r
.14476 .51862 m .1192 .50239 L .12087 .48234 L p F P
0 g
s
.938 .685 .528 r
.20458 .72189 m .2018 .6969 L .18112 .68724 L p F P
0 g
s
.938 .685 .528 r
.18191 .65692 m .18112 .68724 L .2018 .6969 L p F P
0 g
s
.591 .132 .132 r
.52049 .65116 m .50432 .64854 L .48993 .66359 L p F P
0 g
s
.796 .396 .294 r
.47264 .65061 m .48993 .66359 L .50432 .64854 L p F P
0 g
s
.938 .685 .528 r
.07858 .3813 m .07457 .37515 L .09249 .35572 L p F P
0 g
s
.938 .685 .528 r
.19015 .6616 m .19157 .693 L .1706 .67967 L p F P
0 g
s
.938 .685 .528 r
.1706 .67967 m .17363 .65082 L .19015 .6616 L p F P
0 g
s
.558 .061 0 r
.51091 .33088 m .48768 .30545 L .50318 .32131 L p F P
0 g
s
.558 .061 0 r
.50318 .32131 m .5225 .34273 L .51091 .33088 L p F P
0 g
s
.812 .575 .579 r
.74 .42239 m .70959 .42209 L .71468 .45124 L p F P
0 g
s
.812 .575 .579 r
.71468 .45124 m .74626 .45724 L .74 .42239 L p F P
0 g
s
.858 .842 .376 r
.56888 .55604 m .56323 .58506 L .55508 .60437 L p F P
0 g
s
.704 .783 .3 r
.54589 .62886 m .55508 .60437 L .56323 .58506 L p F P
0 g
s
.938 .685 .528 r
.18235 .6398 m .1815 .6728 L .16265 .65748 L p F P
0 g
s
.938 .685 .528 r
.16265 .65748 m .16838 .6282 L .18235 .6398 L p F P
0 g
s
.91 .58 .407 r
.46622 .61722 m .44519 .59006 L .43553 .59884 L p F P
0 g
s
.91 .58 .407 r
.43553 .59884 m .45434 .62866 L .46622 .61722 L p F P
0 g
s
.823 .701 .73 r
.70976 .26404 m .68955 .28177 L .7051 .3144 L p F P
0 g
s
.851 .71 .706 r
.68036 .33167 m .7051 .3144 L .68955 .28177 L p F P
0 g
s
.836 .674 .681 r
.7051 .3144 m .68036 .33167 L .69209 .36112 L p F P
0 g
s
.952 .68 .483 r
.3822 .47786 m .40673 .50768 L .40731 .49994 L closepath p F P
0 g
s
.938 .685 .528 r
.10148 .41637 m .11906 .44331 L .11173 .46078 L p F P
0 g
s
.938 .685 .528 r
.16285 .58008 m .14879 .60309 L .16158 .62077 L p F P
0 g
s
.938 .685 .528 r
.14879 .60309 m .16285 .58008 L .15609 .56741 L p F P
0 g
s
.938 .685 .528 r
.08149 .40701 m .09621 .42653 L .10768 .40787 L p F P
0 g
s
.938 .685 .528 r
.10768 .40787 m .09505 .38556 L .08149 .40701 L p F P
0 g
s
.937 .876 .751 r
.36017 .26368 m .35385 .28458 L .37332 .28941 L p F P
0 g
s
.937 .876 .751 r
.37332 .28941 m .3813 .26931 L .36017 .26368 L p F P
0 g
s
.961 .82 .658 r
.36882 .31707 m .37332 .28941 L .35385 .28458 L p F P
0 g
s
.128 .169 .635 r
.81491 .4079 m .82131 .4001 L .81112 .36104 L p F P
0 g
s
.061 .069 .553 r
.82131 .4001 m .81491 .4079 L .82276 .44843 L p F P
0 g
s
.431 .321 .628 r
.81154 .45588 m .82276 .44843 L .81491 .4079 L p F P
0 g
s
.957 .695 .498 r
.3822 .47786 m .39005 .44678 L .38495 .44056 L closepath p F P
0 g
s
.938 .685 .528 r
.12264 .53628 m .14694 .53932 L .14501 .52531 L p F P
0 g
s
.938 .685 .528 r
.14501 .52531 m .11955 .51331 L .12264 .53628 L p F P
0 g
s
0 0 .341 r
.57336 .46561 m .57491 .44595 L .57216 .43187 L p F P
0 g
s
0 0 .192 r
.57491 .44595 m .57336 .46561 L .57544 .48656 L p F P
0 g
s
.604 .388 .562 r
.81154 .45588 m .79497 .45978 L .79909 .49783 L p F P
0 g
s
.716 .47 .552 r
.79497 .45978 m .77314 .46018 L .7768 .49602 L p F P
0 g
s
.716 .47 .552 r
.7768 .49602 m .79909 .49783 L .79497 .45978 L p F P
0 g
s
.938 .685 .528 r
.10515 .43839 m .12559 .4655 L .12087 .48234 L p F P
0 g
s
.839 .937 .891 r
.37107 .25143 m .36017 .26368 L .3813 .26931 L p F P
0 g
s
.839 .937 .891 r
.3813 .26931 m .39282 .2575 L .37107 .25143 L p F P
0 g
s
.152 .33 .789 r
.76754 .24837 m .75668 .2438 L .77429 .2821 L p F P
0 g
s
.152 .33 .789 r
.77429 .2821 m .78374 .28376 L .76754 .24837 L p F P
0 g
s
.011 0 0 r
.53438 .64459 m .52049 .65116 L .50584 .66684 L p F P
0 g
s
.591 .132 .132 r
.48993 .66359 m .50584 .66684 L .52049 .65116 L p F P
0 g
s
0 0 .538 r
.55008 .37834 m .53392 .35838 L .54469 .3771 L p F P
0 g
s
0 0 .538 r
.54469 .3771 m .55682 .39009 L .55008 .37834 L p F P
0 g
s
.588 .044 0 r
.4725 .29532 m .44792 .27378 L .46636 .28618 L p F P
0 g
s
.588 .044 0 r
.46636 .28618 m .48768 .30545 L .4725 .29532 L p F P
0 g
s
.938 .685 .528 r
.2033 .71037 m .20562 .7313 L .18027 .71996 L p F P
0 g
s
.938 .685 .528 r
.18027 .71996 m .18079 .70003 L .2033 .71037 L p F P
0 g
s
.961 .82 .658 r
.35385 .28458 m .35199 .31329 L .36882 .31707 L p F P
0 g
s
.967 .779 .597 r
.36768 .35123 m .36882 .31707 L .35199 .31329 L p F P
0 g
s
.938 .685 .528 r
.15932 .57393 m .14298 .59305 L .13291 .57122 L p F P
0 g
s
.938 .685 .528 r
.13291 .57122 m .15321 .56061 L .15932 .57393 L p F P
0 g
s
.938 .685 .528 r
.17151 .61219 m .16541 .64337 L .18191 .65692 L p F P
0 g
s
.938 .685 .528 r
.16541 .64337 m .17151 .61219 L .16072 .59931 L p F P
0 g
s
.697 .694 .843 r
.72399 .20983 m .70842 .21716 L .72774 .25166 L p F P
0 g
s
.697 .694 .843 r
.72774 .25166 m .7434 .24488 L .72399 .20983 L p F P
0 g
s
.793 .729 .793 r
.70976 .26404 m .72774 .25166 L .70842 .21716 L p F P
0 g
s
.938 .685 .528 r
.1207 .52466 m .14574 .53224 L .1486 .54647 L p F P
0 g
s
.938 .685 .528 r
.14574 .53224 m .1207 .52466 L .1192 .50239 L p F P
0 g
s
.776 .514 .54 r
.77314 .46018 m .74626 .45724 L .74929 .48925 L p F P
0 g
s
.776 .514 .54 r
.74929 .48925 m .7768 .49602 L .77314 .46018 L p F P
0 g
s
.938 .685 .528 r
.10728 .49482 m .13175 .51036 L .13305 .49409 L p F P
0 g
s
.938 .685 .528 r
.13305 .49409 m .10933 .4712 L .10728 .49482 L p F P
0 g
s
.938 .685 .528 r
.15609 .56741 m .13766 .58238 L .14879 .60309 L p F P
0 g
s
.938 .685 .528 r
.13766 .58238 m .15609 .56741 L .1507 .5536 L p F P
0 g
s
.931 .621 .434 r
.44519 .59006 m .42366 .55677 L .41679 .56261 L p F P
0 g
s
.931 .621 .434 r
.41679 .56261 m .43553 .59884 L .44519 .59006 L p F P
0 g
s
.938 .685 .528 r
.12879 .55971 m .1507 .5536 L .14694 .53932 L p F P
0 g
s
.938 .685 .528 r
.14694 .53932 m .12264 .53628 L .12879 .55971 L p F P
0 g
s
.938 .685 .528 r
.10515 .43839 m .08828 .41601 L .10087 .39584 L p F P
0 g
s
.938 .685 .528 r
.09029 .37716 m .10087 .39584 L .08828 .41601 L p F P
0 g
s
.458 .852 .976 r
.38656 .24828 m .37107 .25143 L .39282 .2575 L p F P
0 g
s
.458 .852 .976 r
.39282 .2575 m .40784 .25435 L .38656 .24828 L p F P
0 g
s
.377 .227 .547 r
.82276 .44843 m .81154 .45588 L .81591 .49442 L p F P
0 g
s
.604 .388 .562 r
.79909 .49783 m .81591 .49442 L .81154 .45588 L p F P
0 g
s
.793 .729 .793 r
.70842 .21716 m .69138 .23168 L .70976 .26404 L p F P
0 g
s
.842 .743 .754 r
.68955 .28177 m .70976 .26404 L .69138 .23168 L p F P
0 g
s
.938 .685 .528 r
.19216 .70621 m .19089 .67806 L .17204 .66592 L p F P
0 g
s
.938 .685 .528 r
.17533 .63457 m .17204 .66592 L .19089 .67806 L p F P
0 g
s
.938 .685 .528 r
.15321 .56061 m .13291 .57122 L .12535 .54801 L p F P
0 g
s
.938 .685 .528 r
.12535 .54801 m .1486 .54647 L .15321 .56061 L p F P
0 g
s
.938 .685 .528 r
.1486 .54647 m .12535 .54801 L .1207 .52466 L p F P
0 g
s
.938 .685 .528 r
.20642 .73847 m .20458 .72189 L .1805 .71099 L p F P
0 g
s
.938 .685 .528 r
.18112 .68724 m .1805 .71099 L .20458 .72189 L p F P
0 g
s
.938 .685 .528 r
.1507 .5536 m .12879 .55971 L .13766 .58238 L p F P
0 g
s
.953 .678 .479 r
.3822 .47786 m .40507 .51408 L .40673 .50768 L closepath p F P
0 g
s
.958 .697 .497 r
.3822 .47786 m .38495 .44056 L .37973 .43601 L closepath p F P
0 g
s
.967 .779 .597 r
.35199 .31329 m .35431 .34861 L .36768 .35123 L p F P
0 g
s
.967 .747 .554 r
.3697 .39054 m .36768 .35123 L .35431 .34861 L p F P
0 g
s
.497 .595 .882 r
.73801 .20981 m .72399 .20983 L .7434 .24488 L p F P
0 g
s
.497 .595 .882 r
.7434 .24488 m .75668 .2438 L .73801 .20981 L p F P
0 g
s
.938 .685 .528 r
.0836 .42872 m .10138 .44898 L .10985 .42919 L p F P
0 g
s
.938 .685 .528 r
.10985 .42919 m .09407 .40502 L .0836 .42872 L p F P
0 g
s
.938 .685 .528 r
.17204 .66592 m .17533 .63457 L .16158 .62077 L p F P
0 g
s
.011 0 0 r
.50584 .66684 m .52011 .66001 L .53438 .64459 L p F P
0 g
s
.659 .886 .531 r
.54589 .62886 m .53438 .64459 L .52011 .66001 L p F P
0 g
s
.938 .685 .528 r
.16601 .60614 m .15737 .63465 L .14223 .61383 L p F P
0 g
s
.938 .685 .528 r
.14223 .61383 m .1557 .59178 L .16601 .60614 L p F P
0 g
s
.938 .685 .528 r
.07168 .394 m .08149 .40701 L .09505 .38556 L p F P
0 g
s
.938 .685 .528 r
.09505 .38556 m .08667 .37076 L .07168 .394 L p F P
0 g
s
.938 .685 .528 r
.18112 .68724 m .18191 .65692 L .16541 .64337 L p F P
0 g
s
.938 .685 .528 r
.20562 .7313 m .20696 .74331 L .17997 .73143 L p F P
0 g
s
.938 .685 .528 r
.17997 .73143 m .18027 .71996 L .20562 .7313 L p F P
0 g
s
.938 .685 .528 r
.10784 .48259 m .13208 .50195 L .13206 .51921 L p F P
0 g
s
.938 .685 .528 r
.13208 .50195 m .10784 .48259 L .11173 .46078 L p F P
0 g
s
.938 .685 .528 r
.09684 .47381 m .11964 .49202 L .12287 .47346 L p F P
0 g
s
.938 .685 .528 r
.12287 .47346 m .10138 .44898 L .09684 .47381 L p F P
0 g
s
.843 .649 .64 r
.66943 .39747 m .70196 .39165 L .69209 .36112 L p F P
0 g
s
.836 .618 .608 r
.70196 .39165 m .66943 .39747 L .67515 .42053 L p F P
0 g
s
.836 .618 .608 r
.67515 .42053 m .70959 .42209 L .70196 .39165 L p F P
0 g
s
.938 .685 .528 r
.0888 .45139 m .10933 .4712 L .11499 .45145 L p F P
0 g
s
.938 .685 .528 r
.11499 .45145 m .09621 .42653 L .0888 .45139 L p F P
0 g
s
.854 .681 .667 r
.66194 .37433 m .69209 .36112 L .68036 .33167 L p F P
0 g
s
.843 .649 .64 r
.69209 .36112 m .66194 .37433 L .66943 .39747 L p F P
0 g
s
.938 .685 .528 r
.20723 .74574 m .20642 .73847 L .18009 .7268 L p F P
0 g
s
.938 .685 .528 r
.1805 .71099 m .18009 .7268 L .20642 .73847 L p F P
0 g
s
0 0 .192 r
.57544 .48656 m .57623 .4591 L .57491 .44595 L p F P
0 g
s
0 0 0 r
.57623 .4591 m .57544 .48656 L .57514 .50522 L p F P
0 g
s
.215 0 0 r
.40649 .25425 m .38656 .24828 L .40784 .25435 L p F P
0 g
s
.215 0 0 r
.40784 .25435 m .42627 .25989 L .40649 .25425 L p F P
0 g
s
.938 .685 .528 r
.19157 .693 m .19267 .71753 L .16822 .70231 L p F P
0 g
s
.938 .685 .528 r
.16822 .70231 m .1706 .67967 L .19157 .693 L p F P
0 g
s
0 0 .496 r
.80282 .3224 m .79845 .32179 L .81112 .36104 L p F P
0 g
s
0 0 .496 r
.81112 .36104 m .81389 .35668 L .80282 .3224 L p F P
0 g
s
0 0 .428 r
.81389 .35668 m .81112 .36104 L .82131 .4001 L p F P
0 g
s
.944 .652 .454 r
.42366 .55677 m .40238 .51881 L .39878 .52165 L p F P
0 g
s
.944 .652 .454 r
.39878 .52165 m .41679 .56261 L .42366 .55677 L p F P
0 g
s
.938 .685 .528 r
.08828 .41601 m .07593 .39963 L .09029 .37716 L p F P
0 g
s
.938 .685 .528 r
.08422 .36644 m .09029 .37716 L .07593 .39963 L p F P
0 g
s
0 0 .537 r
.79001 .28921 m .78374 .28376 L .79845 .32179 L p F P
0 g
s
0 0 .537 r
.79845 .32179 m .80282 .3224 L .79001 .28921 L p F P
0 g
s
0 0 .475 r
.54297 .36858 m .5225 .34273 L .53392 .35838 L p F P
0 g
s
0 0 .475 r
.53392 .35838 m .55008 .37834 L .54297 .36858 L p F P
0 g
s
.81 .54 .53 r
.74626 .45724 m .71468 .45124 L .71696 .47793 L p F P
0 g
s
.81 .54 .53 r
.71696 .47793 m .74929 .48925 L .74626 .45724 L p F P
0 g
s
.938 .685 .528 r
.20696 .74331 m .20723 .74574 L .17991 .73375 L p F P
0 g
s
.938 .685 .528 r
.17991 .73375 m .17997 .73143 L .20696 .74331 L p F P
0 g
s
.954 .677 .475 r
.3822 .47786 m .40238 .51881 L .40507 .51408 L closepath p F P
0 g
s
.938 .685 .528 r
.16072 .59931 m .14961 .62476 L .16541 .64337 L p F P
0 g
s
.938 .685 .528 r
.14961 .62476 m .16072 .59931 L .15101 .58365 L p F P
0 g
s
.967 .747 .554 r
.35431 .34861 m .36044 .38902 L .3697 .39054 L p F P
0 g
s
.965 .722 .521 r
.37464 .43336 m .3697 .39054 L .36044 .38902 L p F P
0 g
s
.96 .719 .529 r
.3697 .39054 m .37464 .43336 L .37973 .43601 L p F P
0 g
s
.938 .685 .528 r
.18009 .7268 m .17991 .73375 L .20723 .74574 L p F P
0 g
s
.96 .698 .495 r
.3822 .47786 m .37973 .43601 L .37464 .43336 L closepath p F P
0 g
s
.938 .685 .528 r
.109 .52112 m .13301 .52838 L .13175 .51036 L p F P
0 g
s
.938 .685 .528 r
.13175 .51036 m .10728 .49482 L .109 .52112 L p F P
0 g
s
.938 .685 .528 r
.11173 .46078 m .09196 .43824 L .10148 .41637 L p F P
0 g
s
.938 .685 .528 r
.08773 .3953 m .10148 .41637 L .09196 .43824 L p F P
0 g
s
.842 .743 .754 r
.69138 .23168 m .67293 .25303 L .68955 .28177 L p F P
0 g
s
.87 .748 .726 r
.66722 .30447 m .68955 .28177 L .67293 .25303 L p F P
0 g
s
.851 .71 .706 r
.68955 .28177 m .66722 .30447 L .68036 .33167 L p F P
0 g
s
.938 .685 .528 r
.06737 .38829 m .07168 .394 L .08667 .37076 L p F P
0 g
s
.938 .685 .528 r
.08667 .37076 m .08299 .36427 L .06737 .38829 L p F P
0 g
s
.938 .685 .528 r
.16838 .6282 m .16265 .65748 L .14456 .63632 L p F P
0 g
s
.938 .685 .528 r
.14456 .63632 m .15502 .61237 L .16838 .6282 L p F P
0 g
s
.938 .685 .528 r
.07593 .39963 m .06881 .3902 L .08422 .36644 L p F P
0 g
s
.938 .685 .528 r
.08299 .36427 m .08422 .36644 L .06881 .3902 L p F P
0 g
s
.832 .588 .57 r
.70959 .42209 m .67515 .42053 L .67885 .44258 L p F P
0 g
s
.832 .588 .57 r
.67885 .44258 m .71468 .45124 L .70959 .42209 L p F P
0 g
s
.061 .069 .553 r
.82276 .44843 m .82861 .43751 L .82131 .4001 L p F P
0 g
s
0 0 .439 r
.82861 .43751 m .82276 .44843 L .82711 .48572 L p F P
0 g
s
.377 .227 .547 r
.81591 .49442 m .82711 .48572 L .82276 .44843 L p F P
0 g
s
.938 .685 .528 r
.09859 .46083 m .12087 .48234 L .1192 .50239 L p F P
0 g
s
.938 .685 .528 r
.12087 .48234 m .09859 .46083 L .10515 .43839 L p F P
0 g
s
.868 .714 .689 r
.653 .35205 m .68036 .33167 L .66722 .30447 L p F P
0 g
s
.854 .681 .667 r
.68036 .33167 m .653 .35205 L .66194 .37433 L p F P
0 g
s
.938 .685 .528 r
.06881 .3902 m .06737 .38829 L .08299 .36427 L p F P
0 g
s
.938 .685 .528 r
.1557 .59178 m .14223 .61383 L .12904 .58938 L p F P
0 g
s
.938 .685 .528 r
.12904 .58938 m .14672 .57502 L .1557 .59178 L p F P
0 g
s
.938 .685 .528 r
.1815 .6728 m .18079 .70003 L .1579 .68176 L p F P
0 g
s
.938 .685 .528 r
.1579 .68176 m .16265 .65748 L .1815 .6728 L p F P
0 g
s
.938 .685 .528 r
.19309 .72678 m .19216 .70621 L .16932 .69185 L p F P
0 g
s
.938 .685 .528 r
.17204 .66592 m .16932 .69185 L .19216 .70621 L p F P
0 g
s
.938 .685 .528 r
.10766 .50771 m .13206 .51921 L .13459 .53777 L p F P
0 g
s
.938 .685 .528 r
.13206 .51921 m .10766 .50771 L .10784 .48259 L p F P
0 g
s
.889 .944 .583 r
.55508 .60437 m .54589 .62886 L .53261 .64316 L p F P
0 g
s
.659 .886 .531 r
.52011 .66001 m .53261 .64316 L .54589 .62886 L p F P
0 g
s
.098 .346 .816 r
.7504 .21702 m .73801 .20981 L .75668 .2438 L p F P
0 g
s
.098 .346 .816 r
.75668 .2438 m .76754 .24837 L .7504 .21702 L p F P
0 g
s
.938 .685 .528 r
.17363 .65082 m .1706 .67967 L .14987 .65937 L p F P
0 g
s
.938 .685 .528 r
.14987 .65937 m .15737 .63465 L .17363 .65082 L p F P
0 g
s
0 0 .428 r
.82131 .4001 m .82279 .39075 L .81389 .35668 L p F P
0 g
s
0 0 .331 r
.82279 .39075 m .82131 .4001 L .82861 .43751 L p F P
0 g
s
.938 .685 .528 r
.08828 .41601 m .10515 .43839 L .09859 .46083 L p F P
0 g
s
.786 .715 .18 r
.56888 .55604 m .57242 .52074 L .57514 .50522 L p F P
0 g
s
.918 .851 .405 r
.57242 .52074 m .56888 .55604 L .56212 .57185 L p F P
0 g
s
.858 .842 .376 r
.55508 .60437 m .56212 .57185 L .56888 .55604 L p F P
0 g
s
.938 .685 .528 r
.07056 .41386 m .0836 .42872 L .09407 .40502 L p F P
0 g
s
.938 .685 .528 r
.09407 .40502 m .08254 .38736 L .07056 .41386 L p F P
0 g
s
0 0 .55 r
.77591 .25839 m .76754 .24837 L .78374 .28376 L p F P
0 g
s
0 0 .55 r
.78374 .28376 m .79001 .28921 L .77591 .25839 L p F P
0 g
s
.938 .685 .528 r
.09196 .43824 m .11173 .46078 L .10784 .48259 L p F P
0 g
s
.938 .685 .528 r
.15101 .58365 m .13534 .60198 L .14961 .62476 L p F P
0 g
s
.938 .685 .528 r
.13534 .60198 m .15101 .58365 L .14289 .566 L p F P
0 g
s
.938 .685 .528 r
.11447 .54873 m .13678 .54726 L .13301 .52838 L p F P
0 g
s
.938 .685 .528 r
.13301 .52838 m .109 .52112 L .11447 .54873 L p F P
0 g
s
.58 .004 0 r
.43056 .26895 m .40649 .25425 L .42627 .25989 L p F P
0 g
s
.58 .004 0 r
.42627 .25989 m .44792 .27378 L .43056 .26895 L p F P
0 g
s
.955 .676 .47 r
.3822 .47786 m .39878 .52165 L .40238 .51881 L closepath p F P
0 g
s
.693 .169 0 r
.49966 .32346 m .4725 .29532 L .48768 .30545 L p F P
0 g
s
.693 .169 0 r
.48768 .30545 m .51091 .33088 L .49966 .32346 L p F P
0 g
s
.965 .722 .521 r
.36044 .38902 m .36992 .43275 L .37464 .43336 L p F P
0 g
s
.961 .699 .492 r
.3822 .47786 m .37464 .43336 L .36992 .43275 L closepath p F P
0 g
s
.938 .685 .528 r
.19267 .71753 m .19341 .73384 L .16663 .71741 L p F P
0 g
s
.938 .685 .528 r
.16663 .71741 m .16822 .70231 L .19267 .71753 L p F P
0 g
s
.938 .685 .528 r
.16158 .62077 m .15345 .64758 L .17204 .66592 L p F P
0 g
s
.938 .685 .528 r
.15345 .64758 m .16158 .62077 L .14879 .60309 L p F P
0 g
s
.938 .685 .528 r
.14672 .57502 m .12904 .58938 L .11853 .56257 L p F P
0 g
s
.938 .685 .528 r
.11853 .56257 m .13956 .55671 L .14672 .57502 L p F P
0 g
s
.938 .685 .528 r
.11128 .53485 m .13459 .53777 L .13956 .55671 L p F P
0 g
s
.938 .685 .528 r
.13459 .53777 m .11128 .53485 L .10766 .50771 L p F P
0 g
s
.938 .685 .528 r
.09657 .50248 m .11955 .51331 L .11964 .49202 L p F P
0 g
s
.938 .685 .528 r
.11964 .49202 m .09684 .47381 L .09657 .50248 L p F P
0 g
s
.938 .685 .528 r
.14289 .566 m .12341 .57618 L .13534 .60198 L p F P
0 g
s
.938 .685 .528 r
.12341 .57618 m .14289 .566 L .13678 .54726 L p F P
0 g
s
.938 .685 .528 r
.13678 .54726 m .11447 .54873 L .12341 .57618 L p F P
0 g
s
.938 .685 .528 r
.13956 .55671 m .11853 .56257 L .11128 .53485 L p F P
0 g
s
.573 .306 .473 r
.81591 .49442 m .79909 .49783 L .79929 .53107 L p F P
0 g
s
.706 .412 .476 r
.79909 .49783 m .7768 .49602 L .77669 .52729 L p F P
0 g
s
.706 .412 .476 r
.77669 .52729 m .79929 .53107 L .79909 .49783 L p F P
0 g
s
.938 .685 .528 r
.09196 .43824 m .07643 .42055 L .08773 .3953 L p F P
0 g
s
.938 .685 .528 r
.07858 .3813 m .08773 .3953 L .07643 .42055 L p F P
0 g
s
.938 .685 .528 r
.1805 .71099 m .18112 .68724 L .16013 .67034 L p F P
0 g
s
.938 .685 .528 r
.16541 .64337 m .16013 .67034 L .18112 .68724 L p F P
0 g
s
0 0 0 r
.57514 .50522 m .57605 .47071 L .57623 .4591 L p F P
0 g
s
.841 .74 .219 r
.57605 .47071 m .57514 .50522 L .57242 .52074 L p F P
0 g
s
.772 .468 .472 r
.7768 .49602 m .74929 .48925 L .74887 .51707 L p F P
0 g
s
.772 .468 .472 r
.74887 .51707 m .77669 .52729 L .7768 .49602 L p F P
0 g
s
.938 .685 .528 r
.19363 .7386 m .19309 .72678 L .16732 .71087 L p F P
0 g
s
.938 .685 .528 r
.16932 .69185 m .16732 .71087 L .19309 .72678 L p F P
0 g
s
.637 .144 0 r
.53581 .36129 m .51091 .33088 L .5225 .34273 L p F P
0 g
s
.637 .144 0 r
.5225 .34273 m .54297 .36858 L .53581 .36129 L p F P
0 g
s
.71 .752 .885 r
.70412 .18068 m .68861 .18853 L .70842 .21716 L p F P
0 g
s
.71 .752 .885 r
.70842 .21716 m .72399 .20983 L .70412 .18068 L p F P
0 g
s
.815 .783 .823 r
.69138 .23168 m .70842 .21716 L .68861 .18853 L p F P
0 g
s
.938 .685 .528 r
.07265 .4358 m .0888 .45139 L .09621 .42653 L p F P
0 g
s
.938 .685 .528 r
.09621 .42653 m .08149 .40701 L .07265 .4358 L p F P
0 g
s
.83 .555 .523 r
.71468 .45124 m .67885 .44258 L .68037 .46268 L p F P
0 g
s
.83 .555 .523 r
.68037 .46268 m .71696 .47793 L .71468 .45124 L p F P
0 g
s
.938 .685 .528 r
.16013 .67034 m .16541 .64337 L .14961 .62476 L p F P
0 g
s
.815 .783 .823 r
.68861 .18853 m .67251 .20492 L .69138 .23168 L p F P
0 g
s
.866 .79 .774 r
.67293 .25303 m .69138 .23168 L .67251 .20492 L p F P
0 g
s
.938 .685 .528 r
.15502 .61237 m .14456 .63632 L .12821 .61032 L p F P
0 g
s
.938 .685 .528 r
.12821 .61032 m .14298 .59305 L .15502 .61237 L p F P
0 g
s
.938 .685 .528 r
.16932 .69185 m .17204 .66592 L .15345 .64758 L p F P
0 g
s
.936 .618 .409 r
.43553 .59884 m .41679 .56261 L .4084 .56448 L p F P
0 g
s
.948 .65 .44 r
.41679 .56261 m .39878 .52165 L .39443 .52245 L p F P
0 g
s
.948 .65 .44 r
.39443 .52245 m .4084 .56448 L .41679 .56261 L p F P
0 g
s
.918 .571 .365 r
.45434 .62866 m .43553 .59884 L .42361 .60196 L p F P
0 g
s
.936 .618 .409 r
.4084 .56448 m .42361 .60196 L .43553 .59884 L p F P
0 g
s
.87 .748 .726 r
.67293 .25303 m .65317 .28064 L .66722 .30447 L p F P
0 g
s
.886 .749 .706 r
.64294 .33156 m .66722 .30447 L .65317 .28064 L p F P
0 g
s
.868 .714 .689 r
.66722 .30447 m .64294 .33156 L .653 .35205 L p F P
0 g
s
.938 .685 .528 r
.06304 .4053 m .07056 .41386 L .08254 .38736 L p F P
0 g
s
.938 .685 .528 r
.08254 .38736 m .07591 .37721 L .06304 .4053 L p F P
0 g
s
.938 .685 .528 r
.08601 .48131 m .10728 .49482 L .10933 .4712 L p F P
0 g
s
.938 .685 .528 r
.10933 .4712 m .0888 .45139 L .08601 .48131 L p F P
0 g
s
.938 .685 .528 r
.19341 .73384 m .19374 .741 L .16594 .72405 L p F P
0 g
s
.938 .685 .528 r
.16594 .72405 m .16663 .71741 L .19341 .73384 L p F P
0 g
s
.938 .685 .528 r
.09616 .48775 m .1192 .50239 L .1207 .52466 L p F P
0 g
s
.938 .685 .528 r
.1192 .50239 m .09616 .48775 L .09859 .46083 L p F P
0 g
s
.289 .092 .43 r
.82711 .48572 m .81591 .49442 L .81635 .52808 L p F P
0 g
s
.573 .306 .473 r
.79929 .53107 m .81635 .52808 L .81591 .49442 L p F P
0 g
s
.956 .676 .466 r
.3822 .47786 m .39443 .52245 L .39878 .52165 L closepath p F P
0 g
s
.881 .492 .294 r
.47264 .65061 m .45434 .62866 L .43954 .63302 L p F P
0 g
s
.918 .571 .365 r
.42361 .60196 m .43954 .63302 L .45434 .62866 L p F P
0 g
s
.975 .751 .537 r
.34242 .35188 m .35227 .3916 L .36044 .38902 L p F P
0 g
s
.975 .751 .537 r
.36044 .38902 m .35431 .34861 L .34242 .35188 L p F P
0 g
s
.969 .723 .511 r
.36992 .43275 m .36044 .38902 L .35227 .3916 L p F P
0 g
s
.954 .926 .577 r
.56212 .57185 m .55508 .60437 L .54333 .61679 L p F P
0 g
s
.889 .944 .583 r
.53261 .64316 m .54333 .61679 L .55508 .60437 L p F P
0 g
s
.938 .685 .528 r
.07789 .45868 m .09684 .47381 L .10138 .44898 L p F P
0 g
s
.938 .685 .528 r
.10138 .44898 m .0836 .42872 L .07789 .45868 L p F P
0 g
s
.969 .723 .511 r
.35227 .3916 m .36579 .43424 L .36992 .43275 L p F P
0 g
s
.962 .699 .489 r
.3822 .47786 m .36992 .43275 L .36579 .43424 L closepath p F P
0 g
s
.98 .787 .573 r
.33692 .31692 m .34242 .35188 L .35431 .34861 L p F P
0 g
s
.98 .787 .573 r
.35431 .34861 m .35199 .31329 L .33692 .31692 L p F P
0 g
s
.938 .685 .528 r
.19374 .741 m .19363 .7386 L .16617 .72183 L p F P
0 g
s
.938 .685 .528 r
.16732 .71087 m .16617 .72183 L .19363 .7386 L p F P
0 g
s
.471 .642 .931 r
.71896 .18156 m .70412 .18068 L .72399 .20983 L p F P
0 g
s
.471 .642 .931 r
.72399 .20983 m .73801 .20981 L .71896 .18156 L p F P
0 g
s
.965 .697 .475 r
.3822 .47786 m .36007 .44321 L .35878 .45031 L closepath p F P
0 g
s
.964 .698 .48 r
.3822 .47786 m .36245 .43777 L .36007 .44321 L closepath p F P
0 g
s
.963 .699 .485 r
.3822 .47786 m .36579 .43424 L .36245 .43777 L closepath p F P
0 g
s
.957 .676 .463 r
.3822 .47786 m .38952 .52113 L .39443 .52245 L closepath p F P
0 g
s
.958 .677 .46 r
.3822 .47786 m .38427 .51774 L .38952 .52113 L closepath p F P
0 g
s
.96 .678 .458 r
.3822 .47786 m .37895 .51242 L .38427 .51774 L closepath p F P
0 g
s
.961 .68 .457 r
.3822 .47786 m .3738 .50542 L .37895 .51242 L closepath p F P
0 g
s
.965 .693 .467 r
.3822 .47786 m .35864 .45874 L .35968 .46809 L closepath p F P
0 g
s
.965 .695 .471 r
.3822 .47786 m .35878 .45031 L .35864 .45874 L closepath p F P
0 g
s
.964 .687 .46 r
.3822 .47786 m .36184 .47792 L .36503 .48774 L closepath p F P
0 g
s
.965 .69 .463 r
.3822 .47786 m .35968 .46809 L .36184 .47792 L closepath p F P
0 g
s
.962 .682 .457 r
.3822 .47786 m .36908 .49705 L .3738 .50542 L closepath p F P
0 g
s
.963 .685 .458 r
.3822 .47786 m .36503 .48774 L .36908 .49705 L closepath p F P
0 g
s
.938 .685 .528 r
.18079 .70003 m .18027 .71996 L .15441 .69959 L p F P
0 g
s
.938 .685 .528 r
.15441 .69959 m .1579 .68176 L .18079 .70003 L p F P
0 g
s
.938 .685 .528 r
.07643 .42055 m .06607 .40875 L .07858 .3813 L p F P
0 g
s
.938 .685 .528 r
.07457 .37515 m .07858 .3813 L .06607 .40875 L p F P
0 g
s
.938 .685 .528 r
.16617 .72183 m .16594 .72405 L .19374 .741 L p F P
0 g
s
.788 .33 .153 r
.48993 .66359 m .47264 .65061 L .45572 .65606 L p F P
0 g
s
.881 .492 .294 r
.43954 .63302 m .45572 .65606 L .47264 .65061 L p F P
0 g
s
.982 .838 .626 r
.33635 .28832 m .33692 .31692 L .35199 .31329 L p F P
0 g
s
.982 .838 .626 r
.35199 .31329 m .35385 .28458 L .33635 .28832 L p F P
0 g
s
.809 .501 .468 r
.74929 .48925 m .71696 .47793 L .7163 .50101 L p F P
0 g
s
.809 .501 .468 r
.7163 .50101 m .74887 .51707 L .74929 .48925 L p F P
0 g
s
.719 .186 0 r
.45834 .29156 m .43056 .26895 L .44792 .27378 L p F P
0 g
s
.719 .186 0 r
.44792 .27378 m .4725 .29532 L .45834 .29156 L p F P
0 g
s
.938 .685 .528 r
.14879 .60309 m .13611 .62385 L .15345 .64758 L p F P
0 g
s
.938 .685 .528 r
.13611 .62385 m .14879 .60309 L .13766 .58238 L p F P
0 g
s
0 0 .331 r
.82861 .43751 m .82916 .42333 L .82279 .39075 L p F P
0 g
s
0 0 .198 r
.82916 .42333 m .82861 .43751 L .83268 .47184 L p F P
0 g
s
0 0 .439 r
.82711 .48572 m .83268 .47184 L .82861 .43751 L p F P
0 g
s
.938 .685 .528 r
.10066 .53352 m .12264 .53628 L .11955 .51331 L p F P
0 g
s
.938 .685 .528 r
.11955 .51331 m .09657 .50248 L .10066 .53352 L p F P
0 g
s
.938 .685 .528 r
.06152 .40356 m .06304 .4053 L .07591 .37721 L p F P
0 g
s
.938 .685 .528 r
.07591 .37721 m .07457 .37515 L .06152 .40356 L p F P
0 g
s
.938 .685 .528 r
.09859 .46083 m .08011 .443 L .08828 .41601 L p F P
0 g
s
.938 .685 .528 r
.07593 .39963 m .08828 .41601 L .08011 .443 L p F P
0 g
s
.854 .654 .632 r
.63368 .40351 m .66943 .39747 L .66194 .37433 L p F P
0 g
s
.847 .625 .601 r
.66943 .39747 m .63368 .40351 L .63722 .41798 L p F P
0 g
s
.847 .625 .601 r
.63722 .41798 m .67515 .42053 L .66943 .39747 L p F P
0 g
s
.864 .684 .657 r
.62898 .38899 m .66194 .37433 L .653 .35205 L p F P
0 g
s
.854 .654 .632 r
.66194 .37433 m .62898 .38899 L .63368 .40351 L p F P
0 g
s
.866 .79 .774 r
.67251 .20492 m .65588 .22941 L .67293 .25303 L p F P
0 g
s
.893 .789 .74 r
.65317 .28064 m .67293 .25303 L .65588 .22941 L p F P
0 g
s
.938 .685 .528 r
.06607 .40875 m .06152 .40356 L .07457 .37515 L p F P
0 g
s
0 0 .529 r
.76107 .23118 m .7504 .21702 L .76754 .24837 L p F P
0 g
s
0 0 .529 r
.76754 .24837 m .77591 .25839 L .76107 .23118 L p F P
0 g
s
.963 .916 .714 r
.34113 .26739 m .33635 .28832 L .35385 .28458 L p F P
0 g
s
.963 .916 .714 r
.35385 .28458 m .36017 .26368 L .34113 .26739 L p F P
0 g
s
.938 .685 .528 r
.15737 .63465 m .14987 .65937 L .13052 .63301 L p F P
0 g
s
.938 .685 .528 r
.13052 .63301 m .14223 .61383 L .15737 .63465 L p F P
0 g
s
.47 0 0 r
.50584 .66684 m .48993 .66359 L .47173 .66978 L p F P
0 g
s
.788 .33 .153 r
.45572 .65606 m .47173 .66978 L .48993 .66359 L p F P
0 g
s
.938 .685 .528 r
.08681 .4658 m .10784 .48259 L .10766 .50771 L p F P
0 g
s
.938 .685 .528 r
.10784 .48259 m .08681 .4658 L .09196 .43824 L p F P
0 g
s
.938 .685 .528 r
.14298 .59305 m .12821 .61032 L .11454 .58082 L p F P
0 g
s
.938 .685 .528 r
.11454 .58082 m .13291 .57122 L .14298 .59305 L p F P
0 g
s
0 0 .475 r
.57129 .40961 m .56292 .40332 L .56811 .41745 L p F P
0 g
s
0 0 .475 r
.56811 .41745 m .57308 .4145 L .57129 .40961 L p F P
0 g
s
0 0 .408 r
.57308 .4145 m .56811 .41745 L .57216 .43187 L p F P
0 g
s
.938 .685 .528 r
.1706 .67967 m .16822 .70231 L .14396 .67885 L p F P
0 g
s
.938 .685 .528 r
.14396 .67885 m .14987 .65937 L .1706 .67967 L p F P
0 g
s
.938 .685 .528 r
.18009 .7268 m .1805 .71099 L .15598 .69156 L p F P
0 g
s
.938 .685 .528 r
.16013 .67034 m .15598 .69156 L .1805 .71099 L p F P
0 g
s
.938 .685 .528 r
.09807 .51781 m .1207 .52466 L .12535 .54801 L p F P
0 g
s
.938 .685 .528 r
.1207 .52466 m .09807 .51781 L .09616 .48775 L p F P
0 g
s
.952 .65 .428 r
.4084 .56448 m .39443 .52245 L .38952 .52113 L p F P
0 g
s
.689 .385 0 r
.8034 .32499 m .80282 .3224 L .81389 .35668 L p F P
0 g
s
.689 .385 0 r
.81389 .35668 m .81232 .35262 L .8034 .32499 L p F P
0 g
s
.715 .436 0 r
.81232 .35262 m .81389 .35668 L .82279 .39075 L p F P
0 g
s
0 0 .408 r
.57216 .43187 m .57449 .41949 L .57308 .4145 L p F P
0 g
s
0 0 .303 r
.57449 .41949 m .57216 .43187 L .57491 .44595 L p F P
0 g
s
.685 .353 0 r
.79308 .29827 m .79001 .28921 L .80282 .3224 L p F P
0 g
s
.685 .353 0 r
.80282 .3224 m .8034 .32499 L .79308 .29827 L p F P
0 g
s
.938 .685 .528 r
.16265 .65748 m .1579 .68176 L .13585 .65626 L p F P
0 g
s
.938 .685 .528 r
.13585 .65626 m .14456 .63632 L .16265 .65748 L p F P
0 g
s
.843 .595 .564 r
.67515 .42053 m .63722 .41798 L .63945 .43178 L p F P
0 g
s
.843 .595 .564 r
.63945 .43178 m .67885 .44258 L .67515 .42053 L p F P
0 g
s
0 0 .505 r
.56919 .40504 m .55682 .39009 L .56292 .40332 L p F P
0 g
s
0 0 .505 r
.56292 .40332 m .57129 .40961 L .56919 .40504 L p F P
0 g
s
.972 .723 .498 r
.3456 .39823 m .36245 .43777 L .36579 .43424 L p F P
0 g
s
.972 .723 .498 r
.36579 .43424 m .35227 .3916 L .3456 .39823 L p F P
0 g
s
.878 .716 .678 r
.62333 .37505 m .653 .35205 L .64294 .33156 L p F P
0 g
s
.864 .684 .657 r
.653 .35205 m .62333 .37505 L .62898 .38899 L p F P
0 g
s
.938 .685 .528 r
.07643 .42055 m .09196 .43824 L .08681 .4658 L p F P
0 g
s
0 0 .27 r
.83268 .47184 m .82711 .48572 L .82769 .51822 L p F P
0 g
s
.289 .092 .43 r
.81635 .52808 m .82769 .51822 L .82711 .48572 L p F P
0 g
s
.823 .998 .843 r
.35149 .25505 m .34113 .26739 L .36017 .26368 L p F P
0 g
s
.823 .998 .843 r
.36017 .26368 m .37107 .25143 L .35149 .25505 L p F P
0 g
s
.938 .685 .528 r
.13766 .58238 m .12099 .59591 L .13611 .62385 L p F P
0 g
s
.938 .685 .528 r
.12099 .59591 m .13766 .58238 L .12879 .55971 L p F P
0 g
s
.938 .685 .528 r
.06187 .42538 m .07265 .4358 L .08149 .40701 L p F P
0 g
s
.938 .685 .528 r
.08149 .40701 m .07168 .394 L .06187 .42538 L p F P
0 g
s
.938 .685 .528 r
.08011 .443 m .09859 .46083 L .09616 .48775 L p F P
0 g
s
.938 .685 .528 r
.10895 .56525 m .12879 .55971 L .12264 .53628 L p F P
0 g
s
.938 .685 .528 r
.12264 .53628 m .10066 .53352 L .10895 .56525 L p F P
0 g
s
.47 0 0 r
.47173 .66978 m .48723 .67334 L .50584 .66684 L p F P
0 g
s
.387 .836 .733 r
.52011 .66001 m .50584 .66684 L .48723 .67334 L p F P
0 g
s
0 .334 .817 r
.73298 .19106 m .71896 .18156 L .73801 .20981 L p F P
0 g
s
0 .334 .817 r
.73801 .20981 m .7504 .21702 L .73298 .19106 L p F P
0 g
s
.938 .685 .528 r
.13291 .57122 m .11454 .58082 L .1043 .54941 L p F P
0 g
s
.938 .685 .528 r
.1043 .54941 m .12535 .54801 L .13291 .57122 L p F P
0 g
s
.938 .685 .528 r
.12535 .54801 m .1043 .54941 L .09807 .51781 L p F P
0 g
s
.938 .685 .528 r
.18027 .71996 m .17997 .73143 L .1524 .70987 L p F P
0 g
s
.938 .685 .528 r
.1524 .70987 m .15441 .69959 L .18027 .71996 L p F P
0 g
s
0 0 .303 r
.57491 .44595 m .57544 .42435 L .57449 .41949 L p F P
0 g
s
0 0 .156 r
.57544 .42435 m .57491 .44595 L .57623 .4591 L p F P
0 g
s
.938 .685 .528 r
.12879 .55971 m .10895 .56525 L .12099 .59591 L p F P
0 g
s
.938 .685 .528 r
.14961 .62476 m .13995 .64688 L .16013 .67034 L p F P
0 g
s
.938 .685 .528 r
.13995 .64688 m .14961 .62476 L .13534 .60198 L p F P
0 g
s
.841 .74 .219 r
.57242 .52074 m .57435 .48027 L .57605 .47071 L p F P
0 g
s
.943 .849 .416 r
.57435 .48027 m .57242 .52074 L .56735 .53237 L p F P
0 g
s
.918 .851 .405 r
.56212 .57185 m .56735 .53237 L .57242 .52074 L p F P
0 g
s
0 0 .492 r
.56687 .40101 m .55008 .37834 L .55682 .39009 L p F P
0 g
s
0 0 .492 r
.55682 .39009 m .56919 .40504 L .56687 .40101 L p F P
0 g
s
.938 .685 .528 r
.08808 .51478 m .109 .52112 L .10728 .49482 L p F P
0 g
s
.938 .685 .528 r
.10728 .49482 m .08601 .48131 L .08808 .51478 L p F P
0 g
s
.831 .521 .464 r
.71696 .47793 m .68037 .46268 L .67961 .47996 L p F P
0 g
s
.831 .521 .464 r
.67961 .47996 m .7163 .50101 L .71696 .47793 L p F P
0 g
s
.744 .236 0 r
.52892 .35683 m .49966 .32346 L .51091 .33088 L p F P
0 g
s
.744 .236 0 r
.51091 .33088 m .53581 .36129 L .52892 .35683 L p F P
0 g
s
.715 .436 0 r
.82279 .39075 m .81949 .38006 L .81232 .35262 L p F P
0 g
s
.76 .503 0 r
.81949 .38006 m .82279 .39075 L .82916 .42333 L p F P
0 g
s
.154 .692 .709 r
.36745 .25181 m .35149 .25505 L .37107 .25143 L p F P
0 g
s
.154 .692 .709 r
.37107 .25143 m .38656 .24828 L .36745 .25181 L p F P
0 g
s
.938 .685 .528 r
.08011 .443 m .06654 .4299 L .07593 .39963 L p F P
0 g
s
.938 .685 .528 r
.06881 .3902 m .07593 .39963 L .06654 .4299 L p F P
0 g
s
.976 .906 .566 r
.56735 .53237 m .56212 .57185 L .55241 .5818 L p F P
0 g
s
.954 .926 .577 r
.54333 .61679 m .55241 .5818 L .56212 .57185 L p F P
0 g
s
.938 .685 .528 r
.16732 .71087 m .16932 .69185 L .14669 .66985 L p F P
0 g
s
.938 .685 .528 r
.15345 .64758 m .14669 .66985 L .16932 .69185 L p F P
0 g
s
.942 .616 .385 r
.42361 .60196 m .4084 .56448 L .39884 .56221 L p F P
0 g
s
.952 .65 .428 r
.38952 .52113 m .39884 .56221 L .4084 .56448 L p F P
0 g
s
.703 .341 0 r
.78176 .27352 m .77591 .25839 L .79001 .28921 L p F P
0 g
s
.703 .341 0 r
.79001 .28921 m .79308 .29827 L .78176 .27352 L p F P
0 g
s
.893 .789 .74 r
.65588 .22941 m .63876 .26123 L .65317 .28064 L p F P
0 g
s
.908 .788 .717 r
.63219 .31373 m .65317 .28064 L .63876 .26123 L p F P
0 g
s
.886 .749 .706 r
.65317 .28064 m .63219 .31373 L .64294 .33156 L p F P
0 g
s
.938 .685 .528 r
.17991 .73375 m .18009 .7268 L .15321 .70573 L p F P
0 g
s
.938 .685 .528 r
.15598 .69156 m .15321 .70573 L .18009 .7268 L p F P
0 g
s
.955 .652 .418 r
.39884 .56221 m .38952 .52113 L .38427 .51774 L p F P
0 g
s
.982 .751 .515 r
.33262 .36107 m .3456 .39823 L .35227 .3916 L p F P
0 g
s
.982 .751 .515 r
.35227 .3916 m .34242 .35188 L .33262 .36107 L p F P
0 g
s
.842 .565 .519 r
.67885 .44258 m .63945 .43178 L .64026 .4443 L p F P
0 g
s
.842 .565 .519 r
.64026 .4443 m .68037 .46268 L .67885 .44258 L p F P
0 g
s
.975 .72 .484 r
.34078 .40869 m .36007 .44321 L .36245 .43777 L p F P
0 g
s
.975 .72 .484 r
.36245 .43777 m .3456 .39823 L .34078 .40869 L p F P
0 g
s
.938 .685 .528 r
.06395 .44755 m .07789 .45868 L .0836 .42872 L p F P
0 g
s
.938 .685 .528 r
.0836 .42872 m .07056 .41386 L .06395 .44755 L p F P
0 g
s
.843 .999 .79 r
.53261 .64316 m .52011 .66001 L .50193 .66632 L p F P
0 g
s
.387 .836 .733 r
.48723 .67334 m .50193 .66632 L .52011 .66001 L p F P
0 g
s
.78 .276 0 r
.48926 .3209 m .45834 .29156 L .4725 .29532 L p F P
0 g
s
.78 .276 0 r
.4725 .29532 m .49966 .32346 L .48926 .3209 L p F P
0 g
s
.938 .685 .528 r
.14669 .66985 m .15345 .64758 L .13611 .62385 L p F P
0 g
s
.895 .75 .693 r
.61696 .36228 m .64294 .33156 L .63219 .31373 L p F P
0 g
s
.878 .716 .678 r
.64294 .33156 m .61696 .36228 L .62333 .37505 L p F P
0 g
s
.938 .685 .528 r
.17997 .73143 m .17991 .73375 L .15199 .71196 L p F P
0 g
s
.938 .685 .528 r
.15199 .71196 m .1524 .70987 L .17997 .73143 L p F P
0 g
s
.938 .685 .528 r
.14223 .61383 m .13052 .63301 L .11363 .60189 L p F P
0 g
s
.938 .685 .528 r
.11363 .60189 m .12904 .58938 L .14223 .61383 L p F P
0 g
s
.938 .685 .528 r
.05711 .4208 m .06187 .42538 L .07168 .394 L p F P
0 g
s
.938 .685 .528 r
.07168 .394 m .06737 .38829 L .05711 .4208 L p F P
0 g
s
.938 .685 .528 r
.15598 .69156 m .16013 .67034 L .13995 .64688 L p F P
0 g
s
0 0 .156 r
.57623 .4591 m .5759 .42886 L .57544 .42435 L p F P
0 g
s
.734 .603 .032 r
.5759 .42886 m .57623 .4591 L .57605 .47071 L p F P
0 g
s
.938 .685 .528 r
.07741 .49346 m .09657 .50248 L .09684 .47381 L p F P
0 g
s
.938 .685 .528 r
.09684 .47381 m .07789 .45868 L .07741 .49346 L p F P
0 g
s
.938 .685 .528 r
.08643 .49771 m .10766 .50771 L .11128 .53485 L p F P
0 g
s
.938 .685 .528 r
.10766 .50771 m .08643 .49771 L .08681 .4658 L p F P
0 g
s
.938 .685 .528 r
.15321 .70573 m .15199 .71196 L .17991 .73375 L p F P
0 g
s
0 0 .426 r
.56445 .39768 m .54297 .36858 L .55008 .37834 L p F P
0 g
s
0 0 .426 r
.55008 .37834 m .56687 .40101 L .56445 .39768 L p F P
0 g
s
.938 .685 .528 r
.06922 .47065 m .08601 .48131 L .0888 .45139 L p F P
0 g
s
.938 .685 .528 r
.0888 .45139 m .07265 .4358 L .06922 .47065 L p F P
0 g
s
.49 0 0 r
.38881 .25769 m .36745 .25181 L .38656 .24828 L p F P
0 g
s
.49 0 0 r
.38656 .24828 m .40649 .25425 L .38881 .25769 L p F P
0 g
s
.938 .685 .528 r
.06654 .4299 m .05871 .42234 L .06881 .3902 L p F P
0 g
s
.938 .685 .528 r
.06737 .38829 m .06881 .3902 L .05871 .42234 L p F P
0 g
s
.938 .685 .528 r
.16822 .70231 m .16663 .71741 L .14001 .69188 L p F P
0 g
s
.938 .685 .528 r
.14001 .69188 m .14396 .67885 L .16822 .70231 L p F P
0 g
s
.938 .685 .528 r
.05871 .42234 m .05711 .4208 L .06737 .38829 L p F P
0 g
s
.938 .685 .528 r
.13534 .60198 m .1217 .61795 L .13995 .64688 L p F P
0 g
s
.938 .685 .528 r
.1217 .61795 m .13534 .60198 L .12341 .57618 L p F P
0 g
s
.925 .564 .321 r
.43954 .63302 m .42361 .60196 L .4099 .59908 L p F P
0 g
s
.942 .616 .385 r
.39884 .56221 m .4099 .59908 L .42361 .60196 L p F P
0 g
s
.938 .685 .528 r
.095 .55002 m .11447 .54873 L .109 .52112 L p F P
0 g
s
.938 .685 .528 r
.109 .52112 m .08808 .51478 L .095 .55002 L p F P
0 g
s
.938 .685 .528 r
.08681 .4658 m .07023 .45257 L .07643 .42055 L p F P
0 g
s
.938 .685 .528 r
.06607 .40875 m .07643 .42055 L .07023 .45257 L p F P
0 g
s
.69 .336 .37 r
.79929 .53107 m .77669 .52729 L .77267 .55253 L p F P
0 g
s
.768 .412 .381 r
.77669 .52729 m .74887 .51707 L .74491 .53941 L p F P
0 g
s
.768 .412 .381 r
.74491 .53941 m .77267 .55253 L .77669 .52729 L p F P
0 g
s
.955 .652 .418 r
.38427 .51774 m .38856 .55581 L .39884 .56221 L p F P
0 g
s
.959 .655 .41 r
.38856 .55581 m .38427 .51774 L .37895 .51242 L p F P
0 g
s
.942 .961 .729 r
.54333 .61679 m .53261 .64316 L .51567 .64882 L p F P
0 g
s
.843 .999 .79 r
.50193 .66632 m .51567 .64882 L .53261 .64316 L p F P
0 g
s
.522 .186 .339 r
.81635 .52808 m .79929 .53107 L .79539 .55798 L p F P
0 g
s
.69 .336 .37 r
.77267 .55253 m .79539 .55798 L .79929 .53107 L p F P
0 g
s
.977 .716 .468 r
.3381 .42253 m .35878 .45031 L .36007 .44321 L p F P
0 g
s
.977 .716 .468 r
.36007 .44321 m .34078 .40869 L .3381 .42253 L p F P
0 g
s
.991 .789 .538 r
.32442 .32808 m .33262 .36107 L .34242 .35188 L p F P
0 g
s
.991 .789 .538 r
.34242 .35188 m .33692 .31692 L .32442 .32808 L p F P
0 g
s
0 0 .198 r
.83268 .47184 m .83272 .4531 L .82916 .42333 L p F P
0 g
s
0 0 .03 r
.83272 .4531 m .83268 .47184 L .83329 .50166 L p F P
0 g
s
0 0 .27 r
.82769 .51822 m .83329 .50166 L .83268 .47184 L p F P
0 g
s
.938 .685 .528 r
.14456 .63632 m .13585 .65626 L .1159 .62474 L p F P
0 g
s
.938 .685 .528 r
.1159 .62474 m .12821 .61032 L .14456 .63632 L p F P
0 g
s
.938 .685 .528 r
.12904 .58938 m .11363 .60189 L .10018 .56769 L p F P
0 g
s
.938 .685 .528 r
.10018 .56769 m .11853 .56257 L .12904 .58938 L p F P
0 g
s
.938 .685 .528 r
.09095 .5323 m .11128 .53485 L .11853 .56257 L p F P
0 g
s
.938 .685 .528 r
.11128 .53485 m .09095 .5323 L .08643 .49771 L p F P
0 g
s
.938 .685 .528 r
.07698 .47557 m .09616 .48775 L .09807 .51781 L p F P
0 g
s
.938 .685 .528 r
.09616 .48775 m .07698 .47557 L .08011 .443 L p F P
0 g
s
.841 .845 .848 r
.66909 .16715 m .6539 .18508 L .67251 .20492 L p F P
0 g
s
.841 .845 .848 r
.67251 .20492 m .68861 .18853 L .66909 .16715 L p F P
0 g
s
.894 .842 .787 r
.65588 .22941 m .67251 .20492 L .6539 .18508 L p F P
0 g
s
.938 .685 .528 r
.16617 .72183 m .16732 .71087 L .14173 .68623 L p F P
0 g
s
.938 .685 .528 r
.14669 .66985 m .14173 .68623 L .16732 .71087 L p F P
0 g
s
0 0 .463 r
.74604 .20877 m .73298 .19106 L .7504 .21702 L p F P
0 g
s
0 0 .463 r
.7504 .21702 m .76107 .23118 L .74604 .20877 L p F P
0 g
s
.76 .503 0 r
.82916 .42333 m .8246 .40621 L .81949 .38006 L p F P
0 g
s
.818 .579 .023 r
.8246 .40621 m .82916 .42333 L .83272 .4531 L p F P
0 g
s
.938 .685 .528 r
.1579 .68176 m .15441 .69959 L .12944 .67094 L p F P
0 g
s
.938 .685 .528 r
.12944 .67094 m .13585 .65626 L .1579 .68176 L p F P
0 g
s
.719 .822 .929 r
.68458 .15886 m .66909 .16715 L .68861 .18853 L p F P
0 g
s
.719 .822 .929 r
.68861 .18853 m .70412 .18068 L .68458 .15886 L p F P
0 g
s
.734 .603 .032 r
.57605 .47071 m .57583 .43282 L .5759 .42886 L p F P
0 g
s
.865 .749 .237 r
.57583 .43282 m .57605 .47071 L .57435 .48027 L p F P
0 g
s
.81 .455 .386 r
.74887 .51707 m .7163 .50101 L .71263 .51942 L p F P
0 g
s
.81 .455 .386 r
.71263 .51942 m .74491 .53941 L .74887 .51707 L p F P
0 g
s
.703 .185 0 r
.41516 .27225 m .38881 .25769 L .40649 .25425 L p F P
0 g
s
.703 .185 0 r
.40649 .25425 m .43056 .26895 L .41516 .27225 L p F P
0 g
s
.938 .685 .528 r
.12341 .57618 m .10642 .58506 L .1217 .61795 L p F P
0 g
s
.938 .685 .528 r
.10642 .58506 m .12341 .57618 L .11447 .54873 L p F P
0 g
s
.674 .185 0 r
.56204 .39523 m .53581 .36129 L .54297 .36858 L p F P
0 g
s
.674 .185 0 r
.54297 .36858 m .56445 .39768 L .56204 .39523 L p F P
0 g
s
.739 .347 0 r
.76988 .25177 m .76107 .23118 L .77591 .25839 L p F P
0 g
s
.739 .347 0 r
.77591 .25839 m .78176 .27352 L .76988 .25177 L p F P
0 g
s
.938 .685 .528 r
.11447 .54873 m .095 .55002 L .10642 .58506 L p F P
0 g
s
.938 .685 .528 r
.14987 .65937 m .14396 .67885 L .12126 .64817 L p F P
0 g
s
.938 .685 .528 r
.12126 .64817 m .13052 .63301 L .14987 .65937 L p F P
0 g
s
.938 .685 .528 r
.11853 .56257 m .10018 .56769 L .09095 .5323 L p F P
0 g
s
.938 .685 .528 r
.06654 .4299 m .08011 .443 L .07698 .47557 L p F P
0 g
s
.843 .532 .462 r
.68037 .46268 m .64026 .4443 L .63959 .45498 L p F P
0 g
s
.843 .532 .462 r
.63959 .45498 m .67961 .47996 L .68037 .46268 L p F P
0 g
s
.135 0 .24 r
.82769 .51822 m .81635 .52808 L .81267 .55533 L p F P
0 g
s
.522 .186 .339 r
.79539 .55798 m .81267 .55533 L .81635 .52808 L p F P
0 g
s
.938 .685 .528 r
.0559 .44112 m .06395 .44755 L .07056 .41386 L p F P
0 g
s
.938 .685 .528 r
.07056 .41386 m .06304 .4053 L .0559 .44112 L p F P
0 g
s
.894 .842 .787 r
.6539 .18508 m .63907 .21207 L .65588 .22941 L p F P
0 g
s
.919 .835 .745 r
.63876 .26123 m .65588 .22941 L .63907 .21207 L p F P
0 g
s
.938 .685 .528 r
.07023 .45257 m .08681 .4658 L .08643 .49771 L p F P
0 g
s
.884 .468 .209 r
.45572 .65606 m .43954 .63302 L .42239 .62981 L p F P
0 g
s
.925 .564 .321 r
.4099 .59908 m .42239 .62981 L .43954 .63302 L p F P
0 g
s
.908 .788 .717 r
.63876 .26123 m .62118 .29936 L .63219 .31373 L p F P
0 g
s
.916 .785 .702 r
.61015 .35126 m .63219 .31373 L .62118 .29936 L p F P
0 g
s
.895 .75 .693 r
.63219 .31373 m .61015 .35126 L .61696 .36228 L p F P
0 g
s
.959 .655 .41 r
.37895 .51242 m .37804 .54552 L .38856 .55581 L p F P
0 g
s
.963 .661 .406 r
.37804 .54552 m .37895 .51242 L .3738 .50542 L p F P
0 g
s
.938 .685 .528 r
.16663 .71741 m .16594 .72405 L .13827 .69761 L p F P
0 g
s
.938 .685 .528 r
.13827 .69761 m .14001 .69188 L .16663 .71741 L p F P
0 g
s
.977 .709 .452 r
.33773 .43913 m .35864 .45874 L .35878 .45031 L p F P
0 g
s
.977 .709 .452 r
.35878 .45031 m .3381 .42253 L .33773 .43913 L p F P
0 g
s
.948 .617 .363 r
.4099 .59908 m .39884 .56221 L .38856 .55581 L p F P
0 g
s
.943 .849 .416 r
.56735 .53237 m .57119 .48731 L .57435 .48027 L p F P
0 g
s
.985 .892 .558 r
.57119 .48731 m .56735 .53237 L .56009 .53948 L p F P
0 g
s
.976 .906 .566 r
.55241 .5818 m .56009 .53948 L .56735 .53237 L p F P
0 g
s
.938 .685 .528 r
.13611 .62385 m .12554 .64116 L .14669 .66985 L p F P
0 g
s
.938 .685 .528 r
.12554 .64116 m .13611 .62385 L .12099 .59591 L p F P
0 g
s
.409 .683 .974 r
.70027 .16044 m .68458 .15886 L .70412 .18068 L p F P
0 g
s
.409 .683 .974 r
.70412 .18068 m .71896 .18156 L .70027 .16044 L p F P
0 g
s
.86 .657 .627 r
.59537 .40979 m .63368 .40351 L .62898 .38899 L p F P
0 g
s
.853 .628 .597 r
.63368 .40351 m .59537 .40979 L .59657 .41476 L p F P
0 g
s
.853 .628 .597 r
.59657 .41476 m .63722 .41798 L .63368 .40351 L p F P
0 g
s
.869 .686 .652 r
.59376 .4048 m .62898 .38899 L .62333 .37505 L p F P
0 g
s
.86 .657 .627 r
.62898 .38899 m .59376 .4048 L .59537 .40979 L p F P
0 g
s
.97 .925 .686 r
.55241 .5818 m .54333 .61679 L .52838 .62143 L p F P
0 g
s
.942 .961 .729 r
.51567 .64882 m .52838 .62143 L .54333 .61679 L p F P
0 g
s
.986 .747 .488 r
.32548 .37592 m .34078 .40869 L .3456 .39823 L p F P
0 g
s
.986 .747 .488 r
.3456 .39823 m .33262 .36107 L .32548 .37592 L p F P
0 g
s
.996 .846 .573 r
.32177 .30087 m .32442 .32808 L .33692 .31692 L p F P
0 g
s
.996 .846 .573 r
.33692 .31692 m .33635 .28832 L .32177 .30087 L p F P
0 g
s
.938 .685 .528 r
.0823 .53122 m .10066 .53352 L .09657 .50248 L p F P
0 g
s
.938 .685 .528 r
.09657 .50248 m .07741 .49346 L .0823 .53122 L p F P
0 g
s
.81 .324 .011 r
.52263 .35544 m .48926 .3209 L .49966 .32346 L p F P
0 g
s
.81 .324 .011 r
.49966 .32346 m .52892 .35683 L .52263 .35544 L p F P
0 g
s
.938 .685 .528 r
.07023 .45257 m .05915 .44371 L .06607 .40875 L p F P
0 g
s
.938 .685 .528 r
.06152 .40356 m .06607 .40875 L .05915 .44371 L p F P
0 g
s
.938 .685 .528 r
.16594 .72405 m .16617 .72183 L .13886 .69569 L p F P
0 g
s
.938 .685 .528 r
.14173 .68623 m .13886 .69569 L .16617 .72183 L p F P
0 g
s
.938 .685 .528 r
.15321 .70573 m .15598 .69156 L .13233 .66433 L p F P
0 g
s
.938 .685 .528 r
.13995 .64688 m .13233 .66433 L .15598 .69156 L p F P
0 g
s
.833 .48 .388 r
.7163 .50101 m .67961 .47996 L .67653 .4936 L p F P
0 g
s
.833 .48 .388 r
.67653 .4936 m .71263 .51942 L .7163 .50101 L p F P
0 g
s
.849 .599 .561 r
.63722 .41798 m .59657 .41476 L .5973 .41948 L p F P
0 g
s
.849 .599 .561 r
.5973 .41948 m .63945 .43178 L .63722 .41798 L p F P
0 g
s
.938 .685 .528 r
.13886 .69569 m .13827 .69761 L .16594 .72405 L p F P
0 g
s
.883 .717 .671 r
.5918 .40002 m .62333 .37505 L .61696 .36228 L p F P
0 g
s
.869 .686 .652 r
.62333 .37505 m .5918 .40002 L .59376 .4048 L p F P
0 g
s
.783 .303 .09 r
.44589 .29461 m .41516 .27225 L .43056 .26895 L p F P
0 g
s
.783 .303 .09 r
.43056 .26895 m .45834 .29156 L .44589 .29461 L p F P
0 g
s
.963 .661 .406 r
.3738 .50542 m .36782 .53178 L .37804 .54552 L p F P
0 g
s
.967 .667 .405 r
.36782 .53178 m .3738 .50542 L .36908 .49705 L p F P
0 g
s
.977 .701 .438 r
.33972 .45767 m .35968 .46809 L .35864 .45874 L p F P
0 g
s
.977 .701 .438 r
.35864 .45874 m .33773 .43913 L .33972 .45767 L p F P
0 g
s
.938 .685 .528 r
.05426 .43981 m .0559 .44112 L .06304 .4053 L p F P
0 g
s
.938 .685 .528 r
.06304 .4053 m .06152 .40356 L .05426 .43981 L p F P
0 g
s
.938 .685 .528 r
.05798 .46351 m .06922 .47065 L .07265 .4358 L p F P
0 g
s
.938 .685 .528 r
.07265 .4358 m .06187 .42538 L .05798 .46351 L p F P
0 g
s
.919 .835 .745 r
.63907 .21207 m .62458 .24719 L .63876 .26123 L p F P
0 g
s
.933 .828 .718 r
.62118 .29936 m .63876 .26123 L .62458 .24719 L p F P
0 g
s
.938 .685 .528 r
.13233 .66433 m .13995 .64688 L .1217 .61795 L p F P
0 g
s
.938 .685 .528 r
.12821 .61032 m .1159 .62474 L .09919 .58884 L p F P
0 g
s
.938 .685 .528 r
.09919 .58884 m .11454 .58082 L .12821 .61032 L p F P
0 g
s
.755 .242 0 r
.47173 .66978 m .45572 .65606 L .43599 .65268 L p F P
0 g
s
.884 .468 .209 r
.42239 .62981 m .43599 .65268 L .45572 .65606 L p F P
0 g
s
.938 .685 .528 r
.05915 .44371 m .05426 .43981 L .06152 .40356 L p F P
0 g
s
.938 .685 .528 r
.07919 .51209 m .09807 .51781 L .1043 .54941 L p F P
0 g
s
.938 .685 .528 r
.09807 .51781 m .07919 .51209 L .07698 .47557 L p F P
0 g
s
.938 .685 .528 r
.14173 .68623 m .14669 .66985 L .12554 .64116 L p F P
0 g
s
.865 .749 .237 r
.57435 .48027 m .57525 .43603 L .57583 .43282 L p F P
0 g
s
.953 .846 .421 r
.57525 .43603 m .57435 .48027 L .57119 .48731 L p F P
0 g
s
.938 .685 .528 r
.07153 .50978 m .08808 .51478 L .08601 .48131 L p F P
0 g
s
.938 .685 .528 r
.08601 .48131 m .06922 .47065 L .07153 .50978 L p F P
0 g
s
0 0 .022 r
.83329 .50166 m .82769 .51822 L .82431 .54445 L p F P
0 g
s
.135 0 .24 r
.81267 .55533 m .82431 .54445 L .82769 .51822 L p F P
0 g
s
.767 .268 0 r
.55973 .39377 m .52892 .35683 L .53581 .36129 L p F P
0 g
s
.767 .268 0 r
.53581 .36129 m .56204 .39523 L .55973 .39377 L p F P
0 g
s
.967 .667 .405 r
.36908 .49705 m .35842 .51524 L .36782 .53178 L p F P
0 g
s
.97 .675 .408 r
.35842 .51524 m .36908 .49705 L .36503 .48774 L p F P
0 g
s
.938 .685 .528 r
.06328 .4868 m .07741 .49346 L .07789 .45868 L p F P
0 g
s
.938 .685 .528 r
.07789 .45868 m .06395 .44755 L .06328 .4868 L p F P
0 g
s
.975 .693 .425 r
.344 .4772 m .36184 .47792 L .35968 .46809 L p F P
0 g
s
.975 .693 .425 r
.35968 .46809 m .33972 .45767 L .344 .4772 L p F P
0 g
s
.867 .541 .026 r
.80029 .32944 m .8034 .32499 L .81232 .35262 L p F P
0 g
s
.867 .541 .026 r
.81232 .35262 m .80658 .34894 L .80029 .32944 L p F P
0 g
s
.879 .569 .057 r
.80658 .34894 m .81232 .35262 L .81949 .38006 L p F P
0 g
s
.848 .57 .516 r
.63945 .43178 m .5973 .41948 L .59753 .42375 L p F P
0 g
s
.848 .57 .516 r
.59753 .42375 m .64026 .4443 L .63945 .43178 L p F P
0 g
s
.863 .52 .01 r
.793 .3106 m .79308 .29827 L .8034 .32499 L p F P
0 g
s
.863 .52 .01 r
.8034 .32499 m .80029 .32944 L .793 .3106 L p F P
0 g
s
.938 .685 .528 r
.15441 .69959 m .1524 .70987 L .12574 .67943 L p F P
0 g
s
.938 .685 .528 r
.12574 .67943 m .12944 .67094 L .15441 .69959 L p F P
0 g
s
.969 .93 .626 r
.32524 .28077 m .32177 .30087 L .33635 .28832 L p F P
0 g
s
.969 .93 .626 r
.33635 .28832 m .34113 .26739 L .32524 .28077 L p F P
0 g
s
.9 .75 .686 r
.58959 .39567 m .61696 .36228 L .61015 .35126 L p F P
0 g
s
.883 .717 .671 r
.61696 .36228 m .58959 .39567 L .5918 .40002 L p F P
0 g
s
.938 .685 .528 r
.12099 .59591 m .10707 .60722 L .12554 .64116 L p F P
0 g
s
.938 .685 .528 r
.10707 .60722 m .12099 .59591 L .10895 .56525 L p F P
0 g
s
0 .272 .756 r
.71598 .17174 m .70027 .16044 L .71896 .18156 L p F P
0 g
s
0 .272 .756 r
.71896 .18156 m .73298 .19106 L .71598 .17174 L p F P
0 g
s
.938 .685 .528 r
.09237 .56987 m .10895 .56525 L .10066 .53352 L p F P
0 g
s
.938 .685 .528 r
.10066 .53352 m .0823 .53122 L .09237 .56987 L p F P
0 g
s
.97 .675 .408 r
.36503 .48774 m .35034 .49673 L .35842 .51524 L p F P
0 g
s
.973 .684 .414 r
.35034 .49673 m .36503 .48774 L .36184 .47792 L p F P
0 g
s
.973 .684 .414 r
.36184 .47792 m .344 .4772 L .35034 .49673 L p F P
0 g
s
.981 .902 .659 r
.56009 .53948 m .55241 .5818 L .54009 .5852 L p F P
0 g
s
.97 .925 .686 r
.52838 .62143 m .54009 .5852 L .55241 .5818 L p F P
0 g
s
.938 .685 .528 r
.07698 .47557 m .06285 .4666 L .06654 .4299 L p F P
0 g
s
.938 .685 .528 r
.05871 .42234 m .06654 .4299 L .06285 .4666 L p F P
0 g
s
.938 .685 .528 r
.11454 .58082 m .09919 .58884 L .08672 .55057 L p F P
0 g
s
.938 .685 .528 r
.08672 .55057 m .1043 .54941 L .11454 .58082 L p F P
0 g
s
.938 .685 .528 r
.1043 .54941 m .08672 .55057 L .07919 .51209 L p F P
0 g
s
.938 .685 .528 r
.10895 .56525 m .09237 .56987 L .10707 .60722 L p F P
0 g
s
.938 .685 .528 r
.13052 .63301 m .12126 .64817 L .10142 .6118 L p F P
0 g
s
.938 .685 .528 r
.10142 .6118 m .11363 .60189 L .13052 .63301 L p F P
0 g
s
.82 .363 .142 r
.48021 .32347 m .44589 .29461 L .45834 .29156 L p F P
0 g
s
.82 .363 .142 r
.45834 .29156 m .48926 .3209 L .48021 .32347 L p F P
0 g
s
.212 0 0 r
.48723 .67334 m .47173 .66978 L .4504 .66633 L p F P
0 g
s
.755 .242 0 r
.43599 .65268 m .4504 .66633 L .47173 .66978 L p F P
0 g
s
.846 .496 .39 r
.67961 .47996 m .63959 .45498 L .63747 .46332 L p F P
0 g
s
.846 .496 .39 r
.63747 .46332 m .67653 .4936 L .67961 .47996 L p F P
0 g
s
.879 .569 .057 r
.81949 .38006 m .81163 .36829 L .80658 .34894 L p F P
0 g
s
.898 .604 .102 r
.81163 .36829 m .81949 .38006 L .8246 .40621 L p F P
0 g
s
.938 .685 .528 r
.15199 .71196 m .15321 .70573 L .12723 .67601 L p F P
0 g
s
.938 .685 .528 r
.13233 .66433 m .12723 .67601 L .15321 .70573 L p F P
0 g
s
.818 .579 .023 r
.83272 .4531 m .82743 .43001 L .8246 .40621 L p F P
0 g
s
0 0 .03 r
.83329 .50166 m .83324 .47882 L .83272 .4531 L p F P
0 g
s
.879 .654 .13 r
.82743 .43001 m .83272 .4531 L .83324 .47882 L p F P
0 g
s
.938 .685 .528 r
.06965 .4898 m .08643 .49771 L .09095 .5323 L p F P
0 g
s
.938 .685 .528 r
.08643 .49771 m .06965 .4898 L .07023 .45257 L p F P
0 g
s
.867 .509 .011 r
.78503 .29321 m .78176 .27352 L .79308 .29827 L p F P
0 g
s
.867 .509 .011 r
.79308 .29827 m .793 .3106 L .78503 .29321 L p F P
0 g
s
.931 .56 .277 r
.42239 .62981 m .4099 .59908 L .39504 .59014 L p F P
0 g
s
.948 .617 .363 r
.38856 .55581 m .39504 .59014 L .4099 .59908 L p F P
0 g
s
.938 .685 .528 r
.14396 .67885 m .14001 .69188 L .11505 .65832 L p F P
0 g
s
.938 .685 .528 r
.11505 .65832 m .12126 .64817 L .14396 .67885 L p F P
0 g
s
.954 .621 .345 r
.39504 .59014 m .38856 .55581 L .37804 .54552 L p F P
0 g
s
.933 .828 .718 r
.62458 .24719 m .61038 .28915 L .62118 .29936 L p F P
0 g
s
.94 .823 .701 r
.60319 .34248 m .62118 .29936 L .61038 .28915 L p F P
0 g
s
.916 .785 .702 r
.62118 .29936 m .60319 .34248 L .61015 .35126 L p F P
0 g
s
.784 .37 0 r
.75792 .23399 m .74604 .20877 L .76107 .23118 L p F P
0 g
s
.784 .37 0 r
.76107 .23118 m .76988 .25177 L .75792 .23399 L p F P
0 g
s
.938 .685 .528 r
.13585 .65626 m .12944 .67094 L .1068 .63538 L p F P
0 g
s
.938 .685 .528 r
.1068 .63538 m .1159 .62474 L .13585 .65626 L p F P
0 g
s
.938 .685 .528 r
.05302 .46036 m .05798 .46351 L .06187 .42538 L p F P
0 g
s
.938 .685 .528 r
.06187 .42538 m .05711 .4208 L .05302 .46036 L p F P
0 g
s
.988 .738 .457 r
.32143 .39585 m .3381 .42253 L .34078 .40869 L p F P
0 g
s
.988 .738 .457 r
.34078 .40869 m .32548 .37592 L .32143 .39585 L p F P
0 g
s
.85 .539 .461 r
.64026 .4443 m .59753 .42375 L .59723 .42736 L p F P
0 g
s
.85 .539 .461 r
.59723 .42736 m .63959 .45498 L .64026 .4443 L p F P
0 g
s
.67 .923 .616 r
.33515 .26875 m .32524 .28077 L .34113 .26739 L p F P
0 g
s
.67 .923 .616 r
.34113 .26739 m .35149 .25505 L .33515 .26875 L p F P
0 g
s
.938 .685 .528 r
.05915 .44371 m .07023 .45257 L .06965 .4898 L p F P
0 g
s
.997 .783 .492 r
.31523 .34654 m .32548 .37592 L .33262 .36107 L p F P
0 g
s
.997 .783 .492 r
.33262 .36107 m .32442 .32808 L .31523 .34654 L p F P
0 g
s
.938 .685 .528 r
.1524 .70987 m .15199 .71196 L .12498 .68116 L p F P
0 g
s
.938 .685 .528 r
.12498 .68116 m .12574 .67943 L .1524 .70987 L p F P
0 g
s
.92 .784 .694 r
.58723 .39194 m .61015 .35126 L .60319 .34248 L p F P
0 g
s
.9 .75 .686 r
.61015 .35126 m .58723 .39194 L .58959 .39567 L p F P
0 g
s
.938 .685 .528 r
.06285 .4666 m .07698 .47557 L .07919 .51209 L p F P
0 g
s
.953 .846 .421 r
.57119 .48731 m .57417 .43835 L .57525 .43603 L p F P
0 g
s
.989 .884 .553 r
.57417 .43835 m .57119 .48731 L .56669 .49147 L p F P
0 g
s
.985 .892 .558 r
.56009 .53948 m .56669 .49147 L .57119 .48731 L p F P
0 g
s
.938 .685 .528 r
.12723 .67601 m .12498 .68116 L .15199 .71196 L p F P
0 g
s
.938 .685 .528 r
.1217 .61795 m .1109 .63058 L .13233 .66433 L p F P
0 g
s
.938 .685 .528 r
.1109 .63058 m .1217 .61795 L .10642 .58506 L p F P
0 g
s
.938 .685 .528 r
.06285 .4666 m .05468 .46141 L .05871 .42234 L p F P
0 g
s
.938 .685 .528 r
.05711 .4208 m .05871 .42234 L .05468 .46141 L p F P
0 g
s
.824 .347 .035 r
.55765 .39338 m .52263 .35544 L .52892 .35683 L p F P
0 g
s
.824 .347 .035 r
.52892 .35683 m .55973 .39377 L .55765 .39338 L p F P
0 g
s
.212 0 0 r
.4504 .66633 m .46533 .66981 L .48723 .67334 L p F P
0 g
s
.63 .938 .961 r
.50193 .66632 m .48723 .67334 L .46533 .66981 L p F P
0 g
s
.938 .685 .528 r
.07958 .55104 m .095 .55002 L .08808 .51478 L p F P
0 g
s
.938 .685 .528 r
.08808 .51478 m .07153 .50978 L .07958 .55104 L p F P
0 g
s
0 0 .022 r
.82431 .54445 m .83026 .52558 L .83329 .50166 L p F P
0 g
s
.822 .696 .157 r
.83324 .47882 m .83329 .50166 L .83026 .52558 L p F P
0 g
s
.985 .887 .642 r
.56669 .49147 m .56009 .53948 L .55091 .54162 L p F P
0 g
s
.981 .902 .659 r
.54009 .5852 m .55091 .54162 L .56009 .53948 L p F P
0 g
s
.938 .685 .528 r
.05468 .46141 m .05302 .46036 L .05711 .4208 L p F P
0 g
s
.938 .685 .528 r
.13886 .69569 m .14173 .68623 L .11774 .65392 L p F P
0 g
s
.938 .685 .528 r
.12554 .64116 m .11774 .65392 L .14173 .68623 L p F P
0 g
s
.839 .395 .17 r
.51722 .35724 m .48021 .32347 L .48926 .3209 L p F P
0 g
s
.839 .395 .17 r
.48926 .3209 m .52263 .35544 L .51722 .35724 L p F P
0 g
s
.64 .167 0 r
.73146 .19224 m .71598 .17174 L .73298 .19106 L p F P
0 g
s
.64 .167 0 r
.73298 .19106 m .74604 .20877 L .73146 .19224 L p F P
0 g
s
.22 0 0 r
.35155 .26532 m .33515 .26875 L .35149 .25505 L p F P
0 g
s
.22 0 0 r
.35149 .25505 m .36745 .25181 L .35155 .26532 L p F P
0 g
s
.938 .685 .528 r
.11363 .60189 m .10142 .6118 L .08565 .57175 L p F P
0 g
s
.938 .685 .528 r
.08565 .57175 m .10018 .56769 L .11363 .60189 L p F P
0 g
s
0 0 .491 r
.57129 .40961 m .57395 .41248 L .57342 .41132 L F
.57395 .41248 m .57486 .41346 L .57428 .41259 L F
.57395 .41248 m .57428 .41259 L .57342 .41132 L F
0 0 .477 r
.57296 .41008 m .57425 .41179 L .57385 .41109 L F
.57425 .41179 m .57532 .41322 L .5745 .41203 L F
.57425 .41179 m .5745 .41203 L .57385 .41109 L F
.57532 .41322 m .57561 .4136 L .57552 .41301 L F
.58434 .42524 m .57552 .41301 L p .57561 .4136 L F P
0 g
s
0 0 .477 r
.57532 .41322 m .5756 .41355 L .57561 .4136 L F
.57561 .4136 m .57778 .41614 L .58434 .42524 L F
.5756 .41355 m .57778 .41614 L .57561 .4136 L F
.577 .132 0 r
.58678 .42858 m .57552 .41301 L p .57582 .4134 L F P
0 g
s
.577 .132 0 r
.58168 .42151 m .5787 .41741 L .58678 .42858 L F
.57532 .4127 m .57552 .41301 L .5756 .41309 L F
.57494 .41218 m .57552 .41301 L .57532 .4127 L F
.57532 .4127 m .5756 .41309 L .57552 .41301 L F
.5756 .41309 m .57582 .4134 L .57552 .41301 L F
0 0 .477 r
.57579 .41373 m .57721 .41542 L .57569 .41366 L F
.57721 .41542 m .57738 .41566 L .57569 .41366 L F
.57575 .41368 m .57569 .41366 L .57532 .41322 L F
.57579 .41373 m .57576 .4137 L .57575 .41368 L F
.57576 .4137 m .57569 .41366 L .57575 .41368 L F
.685 .198 0 r
.57275 .40886 m .57496 .41184 L .57552 .41301 L F
0 0 .477 r
.57535 .41319 m .57579 .41373 L .57532 .41322 L F
.57491 .41267 m .57535 .41319 L .57532 .41322 L F
.685 .198 0 r
.57582 .413 m .57764 .41546 L .57552 .41301 L F
.58919 .43101 m .57552 .41301 L p .57764 .41546 L F P
0 g
s
.685 .198 0 r
.57496 .41184 m .57559 .41269 L .57552 .41301 L F
.577 .132 0 r
.57184 .40789 m .57552 .41301 L .57494 .41218 L F
.56687 .40101 m .57552 .41301 L p .57184 .40789 L F P
0 g
s
.577 .132 0 r
.56687 .40101 m .57532 .4127 L .57552 .41301 L F
0 0 .477 r
.56687 .40101 m .56919 .40504 L p .57296 .41008 L F P
0 g
s
0 0 .477 r
.57296 .41008 m .57385 .41109 L .56687 .40101 L F
.57552 .41301 m .56687 .40101 L p .57532 .41322 L F P
0 g
s
.577 .132 0 r
.57552 .41301 m .56445 .39768 L .56687 .40101 L p F P
0 g
s
.685 .198 0 r
.56445 .39768 m .57275 .40886 L .57552 .41301 L F
0 0 .491 r
.57655 .41528 m .57648 .41444 L .57832 .41718 L F
.57486 .41346 m .5758 .41403 L .57597 .41465 L F
.685 .198 0 r
.57275 .40886 m .5748 .41175 L .5745 .41122 L F
.57064 .40602 m .57387 .41053 L .57275 .40886 L F
0 0 .477 r
.56919 .40504 m .57552 .41301 L p .57491 .41267 L F P
0 g
s
0 0 .491 r
.57129 .40961 m .57552 .41301 L p .57395 .41248 L F P
0 g
s
0 0 .491 r
.56919 .40504 m .57129 .40961 L p .57342 .41132 L F P
0 g
s
0 0 .491 r
.57552 .41301 m .56919 .40504 L p .57486 .41346 L F P
0 g
s
0 0 .477 r
.57552 .41301 m .57627 .41429 L .57622 .41424 L F
.685 .198 0 r
.57387 .41053 m .57544 .41273 L .57275 .40886 L F
.57544 .41273 m .57571 .4131 L .57543 .41271 L F
.57544 .41273 m .57543 .41271 L .57275 .40886 L F
0 0 .462 r
.57393 .41173 m .57129 .40961 L .57273 .41353 L p F P
0 g
s
0 0 .462 r
.57273 .41353 m .57308 .4145 L p .57393 .41173 L F P
0 g
s
0 0 .477 r
.57552 .41301 m .57618 .41419 L .57586 .41381 L F
.57552 .41301 m .57586 .41381 L .57491 .41267 L F
.685 .198 0 r
.57543 .4127 m .57539 .41258 L .57275 .40886 L F
.852 .541 .461 r
.5782 .41265 m .58206 .41563 L .5865 .41742 L F
.685 .198 0 r
.57571 .4131 m .57572 .41311 L .57496 .41203 L F
.57499 .41208 m .57496 .41203 L .57275 .40886 L F
.57571 .4131 m .57496 .41203 L .57499 .41208 L F
0 0 .477 r
.57552 .41301 m .57622 .41424 L .57618 .41419 L F
0 0 .491 r
.57597 .41465 m .57606 .41418 L .57655 .41528 L F
.5758 .41403 m .57606 .41418 L .57597 .41465 L F
.57606 .41418 m .57648 .41444 L .57655 .41528 L F
0 0 .477 r
.57552 .41301 m .57721 .41542 L .57627 .41429 L F
0 0 .491 r
.57552 .41301 m .57628 .41406 L .57603 .41389 L F
.57552 .41301 m .57545 .41349 L .57395 .41248 L F
.57513 .41328 m .57574 .41369 L .57486 .41346 L F
.685 .198 0 r
.56445 .39768 m .57552 .41301 L p .57064 .40602 L F P
0 g
s
.685 .198 0 r
.57552 .41301 m .57577 .41319 L .57571 .4131 L F
.57552 .41301 m .57571 .4131 L .57387 .41053 L F
.57552 .41301 m .57387 .41053 L .57064 .40602 L F
.774 .278 0 r
.56942 .40456 m .57299 .40908 L .57113 .40693 L F
.685 .198 0 r
.57496 .41184 m .5759 .41321 L .57602 .41327 L F
.5745 .41122 m .57501 .41194 L .57496 .41184 L F
.57501 .41194 m .5759 .41321 L .57496 .41184 L F
.57552 .41301 m .56204 .39523 L .56445 .39768 L p F P
0 g
s
.774 .278 0 r
.57552 .41301 m .55973 .39377 L p .56942 .40456 L F P
0 g
s
.828 .354 .043 r
.57552 .41301 m .55765 .39338 L p .56823 .40358 L F P
0 g
s
.685 .198 0 r
.5748 .41175 m .57516 .41225 L .5745 .41122 L F
.851 .416 .188 r
.5559 .39407 m .55765 .39338 L p .56712 .40312 L F P
0 g
s
.774 .278 0 r
.58142 .41973 m .58025 .41857 L .58395 .42293 L F
.57775 .41509 m .57955 .4176 L .58142 .41973 L F
.57955 .4176 m .58025 .41857 L .58142 .41973 L F
.851 .416 .188 r
.57552 .41301 m .5559 .39407 L p .56712 .40312 L F P
0 g
s
.685 .198 0 r
.57516 .41225 m .57589 .41328 L .57504 .41201 L F
.57589 .41328 m .57611 .41359 L .57591 .4133 L F
.57589 .41328 m .57591 .4133 L .57504 .41201 L F
.57611 .41359 m .57613 .41361 L .576 .41342 L F
.57599 .41341 m .576 .41342 L .57504 .41201 L F
.57611 .41359 m .576 .41342 L .57599 .41341 L F
.857 .466 .303 r
.5559 .39407 m .57552 .41301 L .56846 .40524 L F
.851 .416 .188 r
.55765 .39338 m .57552 .41301 L .56893 .40497 L F
.857 .466 .303 r
.56846 .40524 m .57552 .41301 L .56964 .40629 L F
.774 .278 0 r
.56204 .39523 m .5712 .40731 L .5733 .40947 L F
.685 .198 0 r
.57643 .41403 m .57645 .41406 L .57639 .41398 L F
0 0 .491 r
.57395 .41248 m .57513 .41328 L .57486 .41346 L F
0 0 .462 r
.57552 .41301 m .57393 .41173 L p .57308 .4145 L F P
0 g
s
.685 .198 0 r
.57621 .41371 m .57622 .41372 L .57609 .41354 L F
.57608 .41353 m .57609 .41354 L .57504 .41201 L F
.57621 .41371 m .57609 .41354 L .57608 .41353 L F
.828 .354 .043 r
.56937 .4049 m .57552 .41301 L .57111 .40691 L F
.55973 .39377 m .57552 .41301 L .56937 .4049 L F
.685 .198 0 r
.57516 .41225 m .57504 .41201 L .5745 .41122 L F
.57658 .41425 m .57659 .41426 L .57653 .41417 L F
.57645 .41406 m .57646 .41407 L .57617 .41364 L F
.57602 .41343 m .57603 .41344 L .5745 .41122 L F
.774 .278 0 r
.57364 .4099 m .57463 .41115 L .57455 .4114 L F
.57463 .41115 m .57582 .41265 L .57455 .4114 L F
.685 .198 0 r
.57667 .41437 m .57705 .41483 L .57693 .41466 L F
.828 .354 .043 r
.56823 .40358 m .5735 .40967 L .57552 .41301 L F
.685 .198 0 r
.5761 .41355 m .57623 .41367 L .5745 .41122 L F
.57659 .41426 m .57623 .41367 L .5761 .41355 L F
.774 .278 0 r
.57455 .4114 m .57582 .41265 L .57552 .41301 L F
.685 .198 0 r
.57616 .41364 m .57617 .41364 L .57603 .41344 L F
.57616 .41364 m .57603 .41344 L .57602 .41343 L F
.57645 .41406 m .57617 .41364 L .57616 .41364 L F
.57637 .41395 m .57639 .41398 L .57622 .41372 L F
.57637 .41395 m .57622 .41372 L .57621 .41371 L F
.57571 .4131 m .57604 .41357 L .57572 .41311 L F
.851 .416 .188 r
.5709 .40757 m .57446 .41168 L .57444 .41173 L F
.56712 .40312 m .57446 .41168 L .5709 .40757 L F
.828 .354 .043 r
.5735 .40967 m .57357 .40975 L .57352 .40969 L F
.57357 .40975 m .57461 .41095 L .57352 .40969 L F
.57461 .41095 m .5796 .41671 L .57462 .41096 L F
.57461 .41095 m .57462 .41096 L .57352 .40969 L F
.685 .198 0 r
.57735 .41526 m .57757 .41556 L .57741 .41532 L F
.57735 .41526 m .57741 .41532 L .57602 .41327 L F
.57757 .41556 m .58678 .42858 L .57806 .41618 L F
.57757 .41556 m .57806 .41618 L .57781 .41582 L F
.57741 .41532 m .57781 .41582 L .57602 .41327 L F
.57757 .41556 m .57781 .41582 L .57741 .41532 L F
.774 .278 0 r
.57675 .41398 m .57552 .41301 L p .57731 .41468 L F P
0 g
s
.774 .278 0 r
.57675 .41398 m .57731 .41468 L .57775 .41509 L F
.57706 .41423 m .57675 .41398 L p .57775 .41509 L F P
0 g
s
.774 .278 0 r
.58919 .43101 m .59146 .43241 L p .58395 .42293 L F P
0 g
s
.774 .278 0 r
.58025 .41857 m .58919 .43101 L .58395 .42293 L F
.685 .198 0 r
.5759 .41321 m .57735 .41526 L .57602 .41327 L F
.57659 .41426 m .57693 .41466 L .57623 .41367 L F
.57667 .41437 m .57693 .41466 L .57659 .41426 L F
.57651 .41415 m .57653 .41417 L .57646 .41407 L F
.57651 .41415 m .57646 .41407 L .57645 .41406 L F
.57658 .41425 m .57653 .41417 L .57651 .41415 L F
.57643 .41403 m .57639 .41398 L .57637 .41395 L F
.57611 .41359 m .5763 .41385 L .57613 .41361 L F
.5763 .41385 m .57636 .41394 L .57631 .41386 L F
.57636 .41394 m .57643 .41403 L .57637 .41395 L F
.57643 .41403 m .57658 .41425 L .57645 .41406 L F
.57658 .41425 m .57667 .41437 L .57659 .41426 L F
.57667 .41437 m .58678 .42858 L .57705 .41483 L F
.577 .132 0 r
.57996 .41913 m .57811 .41658 L .58168 .42151 L F
.5756 .41309 m .57775 .41609 L .57996 .41913 L F
.57775 .41609 m .57811 .41658 L .57996 .41913 L F
.57811 .41658 m .5787 .41741 L .58168 .42151 L F
.685 .198 0 r
.57552 .41301 m .58678 .42858 L p .57658 .41433 L F P
0 g
s
.685 .198 0 r
.57552 .41301 m .57658 .41433 L .57577 .41319 L F
.57675 .41457 m .57702 .41494 L .57688 .41472 L F
.57675 .41457 m .57688 .41472 L .5763 .41385 L F
.57702 .41494 m .58678 .42858 L .57767 .41578 L F
.57702 .41494 m .57767 .41578 L .5763 .41385 L F
.58678 .42858 m .58919 .43101 L p .5785 .41661 L F P
0 g
s
.685 .198 0 r
.57761 .41554 m .58678 .42858 L .5785 .41661 L F
.774 .278 0 r
.57552 .41301 m .58919 .43101 L p .58135 .42011 L F P
0 g
s
.685 .198 0 r
.57604 .41357 m .57675 .41457 L .5763 .41385 L F
.57604 .41357 m .5763 .41385 L .57624 .41376 L F
.57604 .41357 m .57624 .41376 L .57601 .41352 L F
.57602 .41327 m .57761 .41554 L .5785 .41661 L F
.774 .278 0 r
.57552 .41301 m .58135 .42011 L .57775 .41509 L F
.851 .416 .188 r
.57418 .41136 m .57431 .41118 L .57446 .41168 L F
.685 .198 0 r
.5763 .41385 m .57631 .41386 L .57504 .41201 L F
.57636 .41394 m .57637 .41395 L .57504 .41201 L F
.57601 .41352 m .57624 .41376 L .57539 .41258 L F
.57604 .41357 m .57539 .41258 L .57543 .4127 L F
.57559 .41269 m .57582 .413 L .57552 .41301 L F
.577 .132 0 r
.57552 .41301 m .58434 .42524 L p .5756 .41309 L F P
0 g
s
.774 .278 0 r
.57582 .41265 m .57877 .41638 L .57552 .41301 L F
.59146 .43241 m .57552 .41301 L p .57877 .41638 L F P
0 g
s
.828 .354 .043 r
.57552 .41301 m .57462 .4113 L .57111 .40691 L F
.851 .416 .188 r
.56712 .40312 m .57431 .41118 L .57418 .41136 L F
.828 .354 .043 r
.57111 .40691 m .57637 .4135 L .57728 .41403 L F
.57352 .40969 m .57705 .41377 L .57552 .41301 L F
.59348 .43273 m .57552 .41301 L p .57705 .41377 L F P
0 g
s
.851 .416 .188 r
.56712 .40312 m .57401 .4102 L .57431 .41118 L F
.857 .466 .303 r
.57552 .41301 m .55454 .39582 L p .56675 .40454 L F P
0 g
s
.851 .416 .188 r
.56893 .40497 m .57552 .41301 L .57033 .40642 L F
.857 .466 .303 r
.57141 .40787 m .57552 .41301 L .56675 .40454 L F
.57552 .41301 m .57226 .40893 L .56964 .40629 L F
.855 .506 .392 r
.55454 .39582 m .57552 .41301 L p .57208 .40878 L F P
0 g
s
.855 .506 .392 r
.57552 .41301 m .55366 .39856 L p .57208 .40878 L F P
0 g
s
.852 .541 .461 r
.55366 .39856 m .57552 .41301 L p .57255 .4094 L F P
0 g
s
.828 .354 .043 r
.57552 .41301 m .59146 .43241 L p .57827 .41588 L F P
0 g
s
.852 .541 .461 r
.57552 .41301 m .5533 .40216 L p .57262 .41024 L F P
0 g
s
.828 .354 .043 r
.57552 .41301 m .57741 .41481 L .57462 .4113 L F
.59146 .43241 m .59348 .43273 L p .57728 .41403 L F P
0 g
s
.828 .354 .043 r
.57637 .4135 m .59146 .43241 L .57728 .41403 L F
.851 .416 .188 r
.57401 .4102 m .5747 .41091 L .57466 .41104 L F
.828 .354 .043 r
.5796 .41671 m .57958 .41669 L .57415 .41042 L F
.57414 .41042 m .57415 .41042 L .57352 .40969 L F
.5796 .41671 m .57415 .41042 L .57414 .41042 L F
0 0 .491 r
.57574 .41369 m .57608 .41392 L .57586 .41406 L F
.57608 .41392 m .57634 .41435 L .57586 .41406 L F
.57574 .41369 m .57586 .41406 L .57486 .41346 L F
0 0 .477 r
.57552 .41301 m .582 .42114 L p .57721 .41542 L F P
0 g
s
0 0 .477 r
.57721 .41542 m .582 .42114 L .57738 .41566 L F
.577 .132 0 r
.58434 .42524 m .58678 .42858 L p .5787 .41741 L F P
0 g
s
0 0 .477 r
.582 .42114 m .58434 .42524 L p .57778 .41614 L F P
0 g
s
0 0 .491 r
.582 .42114 m .57552 .41301 L p .57533 .41396 L F P
0 g
s
0 0 .462 r
.57477 .41499 m .57692 .41562 L .57552 .41301 L F
.828 .354 .043 r
.57552 .41301 m .57827 .41588 L .57741 .41481 L F
.851 .416 .188 r
.57672 .41299 m .58079 .41718 L .57552 .41301 L F
.828 .354 .043 r
.5796 .41671 m .59348 .43273 L .57958 .41669 L F
.851 .416 .188 r
.59517 .43196 m .57552 .41301 L p .58079 .41718 L F P
0 g
s
.851 .416 .188 r
.59348 .43273 m .59517 .43196 L p .58244 .41887 L F P
0 g
s
.851 .416 .188 r
.57033 .40642 m .5779 .41503 L .58244 .41887 L F
.5779 .41503 m .59348 .43273 L .58244 .41887 L F
.852 .541 .461 r
.56483 .40497 m .5686 .40714 L .57086 .4095 L F
.851 .416 .188 r
.57407 .41028 m .57466 .41104 L .57465 .41109 L F
.57407 .41028 m .57465 .41109 L .57446 .41168 L F
.57401 .4102 m .57407 .41028 L .57446 .41168 L F
.57552 .41301 m .59348 .43273 L p .57568 .4125 L F P
0 g
s
.851 .416 .188 r
.57552 .41301 m .57568 .4125 L .57033 .40642 L F
0 0 .491 r
.57486 .41346 m .57533 .41396 L .57552 .41301 L F
0 0 .462 r
.57308 .4145 m .57552 .41301 L p .57692 .41562 L F P
0 g
s
0 0 .462 r
.57308 .4145 m .57477 .41499 L .57552 .41301 L F
0 0 .396 r
.57308 .4145 m .57449 .41949 L p .57644 .41507 L F P
0 g
s
0 0 .396 r
.57644 .41507 m .57589 .41383 L .57308 .4145 L F
.852 .541 .461 r
.56483 .40497 m .57086 .4095 L .5533 .40216 L F
.85 .572 .516 r
.5533 .40216 m .57552 .41301 L p .56452 .40658 L F P
0 g
s
.851 .416 .188 r
.57579 .41203 m .57672 .41299 L .57552 .41301 L F
.857 .466 .303 r
.5742 .41035 m .58619 .42102 L .57272 .4095 L F
.57272 .4095 m .57575 .41209 L .57552 .41301 L F
.57575 .41209 m .58619 .42102 L .57552 .41301 L F
.57141 .40787 m .5742 .41035 L .57272 .4095 L F
.58619 .42102 m .59644 .43014 L .58516 .42025 L F
.59644 .43014 m .57552 .41301 L p .58516 .42025 L F P
0 g
s
.857 .466 .303 r
.57552 .41301 m .59517 .43196 L p .57226 .40893 L F P
0 g
s
.857 .466 .303 r
.59517 .43196 m .59644 .43014 L p .56964 .40629 L F P
0 g
s
.855 .506 .392 r
.59644 .43014 m .59723 .42736 L p .57208 .40878 L F P
0 g
s
.855 .506 .392 r
.57552 .41301 m .59644 .43014 L p .57208 .40878 L F P
0 g
s
.855 .506 .392 r
.59723 .42736 m .57552 .41301 L p .57208 .40878 L F P
0 g
s
.852 .541 .461 r
.5686 .40714 m .57771 .41237 L .57191 .40994 L F
0 0 .491 r
.57608 .41392 m .57618 .41399 L .57634 .41435 L F
.57618 .41399 m .57986 .41648 L .57648 .41444 L F
.57618 .41399 m .57648 .41444 L .57634 .41435 L F
.57648 .41444 m .57986 .41648 L .57832 .41718 L F
.57552 .41301 m .57986 .41648 L p .57628 .41406 L F P
0 g
s
0 0 .462 r
.57986 .41648 m .57552 .41301 L p .57692 .41562 L F P
0 g
s
0 0 .462 r
.57692 .41562 m .57552 .41301 L .57811 .41597 L F
0 0 .396 r
.57449 .41949 m .57552 .41301 L p .57656 .4148 L F P
0 g
s
0 0 .291 r
.57449 .41949 m .57544 .42435 L p .57609 .41417 L F P
0 g
s
0 0 .396 r
.57552 .41301 m .57308 .4145 L p .57537 .41396 L F P
0 g
s
0 0 .396 r
.57598 .41381 m .57552 .41301 L .57537 .41396 L F
0 0 .291 r
.57609 .41417 m .57589 .41377 L .57449 .41949 L F
.57589 .41377 m .57576 .4135 L .57449 .41949 L F
.852 .541 .461 r
.57555 .41147 m .57552 .41301 L .57262 .41024 L F
.57723 .41217 m .57552 .41301 L .57555 .41147 L F
.57771 .41237 m .57552 .41301 L .57723 .41217 L F
.59753 .42375 m .57552 .41301 L p .57771 .41237 L F P
0 g
s
.852 .541 .461 r
.57635 .41159 m .5772 .41279 L .5782 .41265 L F
.57474 .41066 m .57617 .4119 L .57635 .41159 L F
.57617 .4119 m .5772 .41279 L .57635 .41159 L F
.57489 .4111 m .5772 .41279 L .57474 .41066 L F
.59723 .42736 m .59753 .42375 L p .5865 .41742 L F P
0 g
s
.852 .541 .461 r
.58206 .41563 m .59723 .42736 L .5865 .41742 L F
.5772 .41279 m .59723 .42736 L .5782 .41265 L F
.57552 .41301 m .59723 .42736 L p .57255 .4094 L F P
0 g
s
.85 .572 .516 r
.57552 .41301 m .59753 .42375 L p .57492 .41111 L F P
0 g
s
.85 .572 .516 r
.57552 .41301 m .57492 .41111 L .57227 .40963 L F
0 0 .462 r
.57811 .41597 m .57552 .41301 L .57986 .41648 L F
.852 .541 .461 r
.57255 .4094 m .57489 .4111 L .57474 .41066 L F
.85 .572 .516 r
.59753 .42375 m .5973 .41948 L p .57227 .40963 L F P
0 g
s
.85 .572 .516 r
.57144 .4093 m .57638 .41124 L .57275 .41048 L F
.57607 .41118 m .57552 .41301 L .57355 .41065 L F
.57638 .41124 m .5973 .41948 L .57628 .41144 L F
.5973 .41948 m .57552 .41301 L p .57628 .41144 L F P
0 g
s
.85 .572 .516 r
.57638 .41124 m .57552 .41301 L .57607 .41118 L F
.851 .601 .559 r
.5973 .41948 m .59657 .41476 L p .57317 .41025 L F P
0 g
s
.851 .601 .559 r
.57552 .41301 m .5973 .41948 L p .57317 .41025 L F P
0 g
s
.852 .541 .461 r
.5686 .40714 m .57191 .40994 L .57086 .4095 L F
.85 .572 .516 r
.56452 .40658 m .57552 .41301 L .57227 .40963 L F
.57144 .4093 m .57275 .41048 L .55347 .40645 L F
.57552 .41301 m .55347 .40645 L p .56856 .40961 L F P
0 g
s
.85 .572 .516 r
.57219 .41037 m .57552 .41301 L .56856 .40961 L F
.57355 .41065 m .57552 .41301 L .57219 .41037 L F
.851 .601 .559 r
.56448 .40857 m .57552 .41301 L .57347 .4106 L F
.56448 .40857 m .57347 .4106 L .57218 .41006 L F
.55347 .40645 m .57552 .41301 L p .56448 .40857 L F P
0 g
s
.851 .601 .559 r
.56448 .40857 m .57317 .41025 L .57552 .41301 L F
.57552 .41301 m .55417 .41123 L p .56448 .40857 L F P
0 g
s
.855 .629 .595 r
.57552 .41301 m .55537 .41627 L p .5734 .41056 L F P
0 g
s
.855 .629 .595 r
.55417 .41123 m .57552 .41301 L p .5734 .41056 L F P
0 g
s
.861 .657 .625 r
.5736 .41083 m .57363 .41082 L .57552 .41301 L F
.851 .601 .559 r
.59657 .41476 m .57552 .41301 L p .57317 .41025 L F P
0 g
s
.855 .629 .595 r
.59537 .40979 m .57552 .41301 L p .5734 .41056 L F P
0 g
s
.855 .629 .595 r
.59657 .41476 m .59537 .40979 L p .5734 .41056 L F P
0 g
s
.855 .629 .595 r
.57552 .41301 m .59657 .41476 L p .5734 .41056 L F P
0 g
s
.861 .657 .625 r
.57363 .41082 m .59376 .4048 L .57552 .41301 L F
.57552 .41301 m .55701 .42134 L p .5736 .41083 L F P
0 g
s
.861 .657 .625 r
.5685 .41235 m .57552 .41301 L .5736 .41083 L F
.59537 .40979 m .59376 .4048 L p .5736 .41083 L F P
0 g
s
.861 .657 .625 r
.57552 .41301 m .59537 .40979 L p .5736 .41083 L F P
0 g
s
.871 .687 .65 r
.57552 .41301 m .59376 .4048 L p .57378 .41106 L F P
0 g
s
0 0 .462 r
.57552 .41301 m .57802 .41148 L .57986 .41648 L p F P
0 g
s
0 0 .396 r
.57644 .41507 m .57711 .41354 L .57589 .41383 L F
.57656 .4148 m .57552 .41301 L .57802 .41148 L F
0 0 .291 r
.57544 .42435 m .57552 .41301 L p .57611 .41383 L F P
0 g
s
0 0 .144 r
.57579 .41884 m .57574 .4137 L .57544 .42435 L F
.57544 .42435 m .5759 .42886 L p .57579 .41884 L F P
0 g
s
0 0 .291 r
.57552 .41301 m .57449 .41949 L p .57551 .41467 L F P
0 g
s
0 0 .291 r
.57576 .4135 m .57552 .41301 L .57551 .41467 L F
0 0 .144 r
.57574 .4137 m .57571 .41361 L .57544 .42435 L F
.57571 .41361 m .57569 .41354 L .57544 .42435 L F
.861 .657 .625 r
.55537 .41627 m .57552 .41301 L p .5685 .41235 L F P
0 g
s
.871 .687 .65 r
.57552 .41301 m .55901 .42618 L p .57378 .41106 L F P
0 g
s
.871 .687 .65 r
.55701 .42134 m .57552 .41301 L p .57378 .41106 L F P
0 g
s
.884 .717 .669 r
.57552 .41301 m .56128 .43056 L p .57394 .41128 L F P
0 g
s
.884 .717 .669 r
.55901 .42618 m .57552 .41301 L p .57394 .41128 L F P
0 g
s
.901 .749 .684 r
.57025 .41722 m .57552 .41301 L .57376 .41198 L F
.5679 .42071 m .57552 .41301 L .57025 .41722 L F
.56128 .43056 m .57552 .41301 L p .5679 .42071 L F P
0 g
s
.871 .687 .65 r
.5918 .40002 m .57552 .41301 L p .57378 .41106 L F P
0 g
s
.884 .717 .669 r
.57394 .41128 m .57552 .41301 L .57431 .41091 L F
.901 .749 .684 r
.57376 .41198 m .57552 .41301 L .5744 .41103 L F
.57552 .41301 m .5637 .43428 L p .5741 .41149 L F P
0 g
s
.922 .784 .691 r
.57552 .41301 m .56616 .43716 L p .57424 .41169 L F P
0 g
s
.945 .819 .689 r
.57552 .41301 m .56855 .43906 L p .57293 .4187 L F P
0 g
s
.922 .784 .691 r
.5637 .43428 m .57552 .41301 L p .57333 .41365 L F P
0 g
s
.945 .819 .689 r
.57399 .41376 m .57552 .41301 L .57293 .4187 L F
.922 .784 .691 r
.57333 .41365 m .57552 .41301 L .57399 .41224 L F
.57399 .41224 m .57552 .41301 L .57449 .41115 L F
.945 .819 .689 r
.57439 .41188 m .57552 .41301 L .57399 .41376 L F
.57242 .41793 m .57552 .41301 L .57439 .41188 L F
.56616 .43716 m .57552 .41301 L p .57242 .41793 L F P
0 g
s
.969 .852 .672 r
.57552 .41301 m .57074 .43991 L p .57419 .41464 L F P
0 g
s
.969 .852 .672 r
.57454 .41208 m .57552 .41301 L .57419 .41464 L F
.56855 .43906 m .57552 .41301 L p .57454 .41208 L F P
0 g
s
.987 .877 .63 r
.57074 .43991 m .57552 .41301 L p .57469 .41229 L F P
0 g
s
.987 .877 .63 r
.57552 .41301 m .57265 .43967 L p .57469 .41229 L F P
0 g
s
.99 .882 .551 r
.57265 .43967 m .57552 .41301 L p .57485 .41251 L F P
0 g
s
.99 .882 .551 r
.5747 .41443 m .57485 .41251 L .57552 .41301 L F
.57552 .41301 m .57417 .43835 L p .5747 .41443 L F P
0 g
s
.956 .845 .422 r
.57552 .41301 m .57525 .43603 L p .57509 .41278 L F P
0 g
s
0 0 .144 r
.57552 .41301 m .57544 .42435 L p .57569 .41325 L F P
0 g
s
.872 .752 .242 r
.57552 .41301 m .57583 .43282 L p .57536 .41688 L F P
0 g
s
.956 .845 .422 r
.57496 .41489 m .57552 .41301 L .57503 .41275 L F
.57487 .41763 m .57552 .41301 L .57496 .41489 L F
.57417 .43835 m .57552 .41301 L p .57487 .41763 L F P
0 g
s
.872 .752 .242 r
.57525 .43603 m .57552 .41301 L p .57523 .41302 L F P
0 g
s
.746 .61 .041 r
.57583 .43282 m .57549 .41488 L .57563 .4196 L F
.5759 .42886 m .57583 .43282 L p .57563 .4196 L F P
0 g
s
.746 .61 .041 r
.57549 .41488 m .57545 .41292 L .5755 .41451 L F
.57549 .41488 m .5755 .41451 L .5759 .42886 L F
.851 .601 .559 r
.57218 .41006 m .57347 .4106 L .57317 .41025 L F
.872 .752 .242 r
.57527 .41405 m .57552 .41301 L .57536 .41688 L F
.57523 .41261 m .57552 .41301 L .57527 .41405 L F
.57583 .43282 m .57525 .43603 L p .57523 .41396 L F P
0 g
s
.872 .752 .242 r
.57523 .41396 m .57523 .41261 L .57527 .41384 L F
.57523 .41396 m .57527 .41384 L .57583 .43282 L F
.852 .541 .461 r
.5533 .40216 m .55366 .39856 L p .56483 .40497 L F P
0 g
s
.857 .466 .303 r
.55454 .39582 m .5559 .39407 L p .57141 .40787 L F P
0 g
s
.85 .572 .516 r
.55347 .40645 m .5533 .40216 L p .57144 .4093 L F P
0 g
s
.855 .506 .392 r
.55366 .39856 m .55454 .39582 L p .57208 .40878 L F P
0 g
s
.969 .852 .672 r
.57074 .43991 m .56855 .43906 L p .57454 .41208 L F P
0 g
s
.871 .687 .65 r
.59376 .4048 m .5918 .40002 L p .57378 .41106 L F P
0 g
s
.884 .717 .669 r
.58959 .39567 m .57552 .41301 L p .57394 .41128 L F P
0 g
s
.884 .717 .669 r
.57431 .41091 m .57552 .41301 L .57449 .41073 L F
.5918 .40002 m .58959 .39567 L p .57449 .41073 L F P
0 g
s
.884 .717 .669 r
.57552 .41301 m .5918 .40002 L p .57449 .41073 L F P
0 g
s
.901 .749 .684 r
.5741 .41149 m .57618 .40839 L .57552 .41301 L F
.58723 .39194 m .57552 .41301 L p .57618 .40839 L F P
0 g
s
.901 .749 .684 r
.5744 .41103 m .57947 .40591 L .58723 .39194 L F
.58959 .39567 m .58723 .39194 L p .57947 .40591 L F P
0 g
s
.901 .749 .684 r
.57552 .41301 m .58959 .39567 L p .5744 .41103 L F P
0 g
s
.922 .784 .691 r
.58482 .38902 m .57552 .41301 L p .57424 .41169 L F P
0 g
s
.922 .784 .691 r
.58723 .39194 m .58482 .38902 L p .57449 .41115 L F P
0 g
s
.922 .784 .691 r
.57552 .41301 m .58723 .39194 L p .57449 .41115 L F P
0 g
s
.945 .819 .689 r
.58248 .38703 m .57552 .41301 L p .57439 .41188 L F P
0 g
s
.945 .819 .689 r
.57439 .41188 m .57786 .40427 L .58248 .38703 L F
.58482 .38902 m .58248 .38703 L p .57786 .40427 L F P
0 g
s
.945 .819 .689 r
.57552 .41301 m .58482 .38902 L p .57439 .41188 L F P
0 g
s
.969 .852 .672 r
.58031 .38608 m .57552 .41301 L p .57454 .41208 L F P
0 g
s
.969 .852 .672 r
.58248 .38703 m .58031 .38608 L p .57454 .41208 L F P
0 g
s
.969 .852 .672 r
.57552 .41301 m .58248 .38703 L p .57454 .41208 L F P
0 g
s
.987 .877 .63 r
.58031 .38608 m .57842 .38621 L p .57469 .41229 L F P
0 g
s
.987 .877 .63 r
.57552 .41301 m .58031 .38608 L p .57469 .41229 L F P
0 g
s
.945 .819 .689 r
.56855 .43906 m .56616 .43716 L p .57439 .41188 L F P
0 g
s
.861 .657 .625 r
.55701 .42134 m .55537 .41627 L p .5736 .41083 L F P
0 g
s
.855 .629 .595 r
.55537 .41627 m .55417 .41123 L p .5734 .41056 L F P
0 g
s
.922 .784 .691 r
.56616 .43716 m .5637 .43428 L p .57424 .41169 L F P
0 g
s
.871 .687 .65 r
.55901 .42618 m .55701 .42134 L p .57378 .41106 L F P
0 g
s
.987 .877 .63 r
.57265 .43967 m .57074 .43991 L p .57469 .41229 L F P
0 g
s
.987 .877 .63 r
.57842 .38621 m .57552 .41301 L p .57469 .41229 L F P
0 g
s
.99 .882 .551 r
.57842 .38621 m .57689 .38743 L p .57485 .41251 L F P
0 g
s
.99 .882 .551 r
.57552 .41301 m .57842 .38621 L p .57485 .41251 L F P
0 g
s
.884 .717 .669 r
.56128 .43056 m .55901 .42618 L p .57394 .41128 L F P
0 g
s
0 0 .396 r
.57711 .41354 m .57552 .41301 L .57629 .41374 L F
.57802 .41148 m .57552 .41301 L p .57711 .41354 L F P
0 g
s
0 0 .291 r
.57609 .41417 m .57619 .41255 L .57589 .41377 L F
.57619 .41255 m .57592 .41274 L .57576 .4135 L F
0 0 .396 r
.57629 .41374 m .57552 .41301 L .57598 .41381 L F
0 0 .291 r
.57619 .41255 m .57576 .4135 L .57589 .41377 L F
.99 .882 .551 r
.57485 .41251 m .57496 .41123 L .57552 .41301 L F
.956 .845 .422 r
.57503 .41275 m .57552 .41301 L .57506 .4119 L F
.828 .354 .043 r
.55765 .39338 m .55973 .39377 L p .56823 .40358 L F P
0 g
s
.99 .882 .551 r
.57689 .38743 m .57552 .41301 L p .57496 .41123 L F P
0 g
s
.99 .882 .551 r
.57417 .43835 m .57265 .43967 L p .5747 .41443 L F P
0 g
s
.851 .601 .559 r
.55417 .41123 m .55347 .40645 L p .56448 .40857 L F P
0 g
s
.956 .845 .422 r
.57689 .38743 m .5758 .38968 L p .57506 .4119 L F P
0 g
s
.956 .845 .422 r
.57552 .41301 m .57689 .38743 L p .57506 .4119 L F P
0 g
s
.901 .749 .684 r
.5637 .43428 m .56128 .43056 L p .5741 .41149 L F P
0 g
s
0 0 .291 r
.57583 .41317 m .57552 .41301 L .57576 .4135 L F
0 0 .144 r
.57574 .4137 m .57573 .41279 L .57571 .41361 L F
.956 .845 .422 r
.5758 .38968 m .57552 .41301 L p .57508 .41136 L F P
0 g
s
.872 .752 .242 r
.57552 .41301 m .5758 .38968 L p .57523 .41213 L F P
0 g
s
0 0 .396 r
.57552 .41301 m .57658 .40637 L .57802 .41148 L p F P
0 g
s
0 0 .291 r
.57552 .41301 m .57561 .40142 L p .57611 .41383 L F P
0 g
s
0 0 .291 r
.57592 .41274 m .57552 .41301 L .57583 .41317 L F
0 0 .144 r
.57573 .41279 m .5757 .41282 L .57569 .41354 L F
.57573 .41279 m .57569 .41354 L .57571 .41361 L F
.956 .845 .422 r
.57508 .41136 m .57552 .41301 L .57509 .41278 L F
.57525 .43603 m .57417 .43835 L p .57503 .41275 L F P
0 g
s
.956 .845 .422 r
.57503 .41275 m .57508 .41136 L .57509 .41278 L F
.57503 .41275 m .57509 .41278 L .57525 .43603 L F
0 0 .491 r
.57986 .41648 m .582 .42114 L p .57832 .41718 L F P
0 g
s
.746 .61 .041 r
.57552 .41301 m .5759 .42886 L p .57547 .41329 L F P
0 g
s
.872 .752 .242 r
.57523 .41302 m .57552 .41301 L .57523 .41213 L F
.57521 .39287 m .57552 .41301 L p .57523 .41261 L F P
0 g
s
.746 .61 .041 r
.57544 .41241 m .57552 .41301 L .57547 .41329 L F
.872 .752 .242 r
.5758 .38968 m .57521 .39287 L p .57523 .41213 L F P
0 g
s
.746 .61 .041 r
.57545 .41292 m .57544 .41241 L .57546 .41293 L F
.57545 .41292 m .57546 .41293 L .5759 .42886 L F
.57521 .39287 m .57514 .39684 L p .57544 .41241 L F P
0 g
s
.746 .61 .041 r
.57552 .41301 m .57521 .39287 L p .57544 .41241 L F P
0 g
s
0 0 .291 r
.57629 .411 m .57552 .41301 L .57592 .41274 L F
.57658 .40637 m .57552 .41301 L p .57629 .411 L F P
0 g
s
0 0 .144 r
.57514 .39684 m .57561 .40142 L p .57573 .41331 L F P
0 g
s
0 0 .144 r
.5759 .42886 m .57552 .41301 L p .57573 .41331 L F P
0 g
s
0 0 .144 r
.57552 .41301 m .57514 .39684 L p .57573 .41331 L F P
0 g
s
0 0 .291 r
.57561 .40142 m .57658 .40637 L p .57611 .41383 L F P
0 g
s
.774 .278 0 r
.55973 .39377 m .56204 .39523 L p .56942 .40456 L F P
0 g
s
.746 .61 .041 r
.57545 .41292 m .57552 .41301 L .57544 .41241 L F
.57583 .43282 m .57552 .41301 L p .57545 .41292 L F P
0 g
s
0 0 .144 r
.5757 .41282 m .57552 .41301 L .57569 .41325 L F
.57572 .41205 m .57552 .41301 L .5757 .41282 L F
.746 .61 .041 r
.57514 .39684 m .57552 .41301 L p .57544 .41241 L F P
0 g
s
0 0 .144 r
.57573 .41279 m .57572 .41205 L .5757 .41282 L F
.57561 .40142 m .57552 .41301 L p .57572 .41205 L F P
0 g
s
0 0 .291 r
.57619 .41255 m .57629 .411 L .57592 .41274 L F
.938 .685 .528 r
.0551 .48295 m .06328 .4868 L .06395 .44755 L p F P
0 g
s
.938 .685 .528 r
.06395 .44755 m .0559 .44112 L .0551 .48295 L p F P
0 g
s
.938 .685 .528 r
.07486 .53029 m .09095 .5323 L .10018 .56769 L p F P
0 g
s
.938 .685 .528 r
.09095 .5323 m .07486 .53029 L .06965 .4898 L p F P
0 g
s
.898 .604 .102 r
.8246 .40621 m .8152 .38668 L .81163 .36829 L p F P
0 g
s
.922 .641 .156 r
.8152 .38668 m .8246 .40621 L .82743 .43001 L p F P
0 g
s
.938 .685 .528 r
.11774 .65392 m .12554 .64116 L .10707 .60722 L p F P
0 g
s
.878 .507 .027 r
.77669 .27802 m .76988 .25177 L .78176 .27352 L p F P
0 g
s
.878 .507 .027 r
.78176 .27352 m .78503 .29321 L .77669 .27802 L p F P
0 g
s
.938 .685 .528 r
.12723 .67601 m .13233 .66433 L .1109 .63058 L p F P
0 g
s
.938 .685 .528 r
.06874 .52952 m .0823 .53122 L .07741 .49346 L p F P
0 g
s
.938 .685 .528 r
.07741 .49346 m .06328 .4868 L .06874 .52952 L p F P
0 g
s
.87 .951 .861 r
.51567 .64882 m .50193 .66632 L .4805 .6627 L p F P
0 g
s
.63 .938 .961 r
.46533 .66981 m .4805 .6627 L .50193 .66632 L p F P
0 g
s
.758 .337 .25 r
.77267 .55253 m .74491 .53941 L .73742 .5551 L p F P
0 g
s
.806 .397 .273 r
.74491 .53941 m .71263 .51942 L .706 .53217 L p F P
0 g
s
.806 .397 .273 r
.706 .53217 m .73742 .5551 L .74491 .53941 L p F P
0 g
s
.659 .225 .207 r
.79539 .55798 m .77267 .55253 L .76473 .57039 L p F P
0 g
s
.758 .337 .25 r
.73742 .5551 m .76473 .57039 L .77267 .55253 L p F P
0 g
s
.938 .685 .528 r
.10642 .58506 m .09296 .5921 L .1109 .63058 L p F P
0 g
s
.938 .685 .528 r
.09296 .5921 m .10642 .58506 L .095 .55002 L p F P
0 g
s
.938 .685 .528 r
.095 .55002 m .07958 .55104 L .09296 .5921 L p F P
0 g
s
.853 .504 .392 r
.63959 .45498 m .59723 .42736 L .59644 .43014 L p F P
0 g
s
.853 .504 .392 r
.59644 .43014 m .63747 .46332 L .63959 .45498 L p F P
0 g
s
.938 .685 .528 r
.06043 .50641 m .07153 .50978 L .06922 .47065 L p F P
0 g
s
.938 .685 .528 r
.06922 .47065 m .05798 .46351 L .06043 .50641 L p F P
0 g
s
.938 .685 .528 r
.14001 .69188 m .13827 .69761 L .11232 .6628 L p F P
0 g
s
.938 .685 .528 r
.11232 .6628 m .11505 .65832 L .14001 .69188 L p F P
0 g
s
.938 .685 .528 r
.10018 .56769 m .08565 .57175 L .07486 .53029 L p F P
0 g
s
.94 .823 .701 r
.61038 .28915 m .59638 .33637 L .60319 .34248 L p F P
0 g
s
.944 .82 .692 r
.58482 .38902 m .60319 .34248 L .59638 .33637 L p F P
0 g
s
.92 .784 .694 r
.60319 .34248 m .58482 .38902 L .58723 .39194 L p F P
0 g
s
.832 .431 .287 r
.71263 .51942 m .67653 .4936 L .67123 .50291 L p F P
0 g
s
.832 .431 .287 r
.67123 .50291 m .706 .53217 L .71263 .51942 L p F P
0 g
s
.422 0 .112 r
.81267 .55533 m .79539 .55798 L .78734 .5771 L p F P
0 g
s
.659 .225 .207 r
.76473 .57039 m .78734 .5771 L .79539 .55798 L p F P
0 g
s
.954 .621 .345 r
.37804 .54552 m .37975 .57542 L .39504 .59014 L p F P
0 g
s
.96 .629 .333 r
.37975 .57542 m .37804 .54552 L .36782 .53178 L p F P
0 g
s
.924 .899 .784 r
.63636 .17332 m .62324 .20203 L .63907 .21207 L p F P
0 g
s
.924 .899 .784 r
.63907 .21207 m .6539 .18508 L .63636 .17332 L p F P
0 g
s
.948 .881 .735 r
.62458 .24719 m .63907 .21207 L .62324 .20203 L p F P
0 g
s
.879 .443 .117 r
.43599 .65268 m .42239 .62981 L .40367 .61885 L p F P
0 g
s
.931 .56 .277 r
.39504 .59014 m .40367 .61885 L .42239 .62981 L p F P
0 g
s
.868 .917 .86 r
.65069 .15429 m .63636 .17332 L .6539 .18508 L p F P
0 g
s
.868 .917 .86 r
.6539 .18508 m .66909 .16715 L .65069 .15429 L p F P
0 g
s
.938 .685 .528 r
.06965 .4898 m .0584 .4845 L .05915 .44371 L p F P
0 g
s
.938 .685 .528 r
.05426 .43981 m .05915 .44371 L .0584 .4845 L p F P
0 g
s
.624 .147 .1 r
.37419 .27053 m .35155 .26532 L .36745 .25181 L p F P
0 g
s
.624 .147 .1 r
.36745 .25181 m .38881 .25769 L .37419 .27053 L p F P
0 g
s
.988 .725 .425 r
.32077 .41996 m .33773 .43913 L .3381 .42253 L p F P
0 g
s
.988 .725 .425 r
.3381 .42253 m .32143 .39585 L .32077 .41996 L p F P
0 g
s
.948 .881 .735 r
.62324 .20203 m .61127 .23931 L .62458 .24719 L p F P
0 g
s
.959 .868 .704 r
.61038 .28915 m .62458 .24719 L .61127 .23931 L p F P
0 g
s
.938 .685 .528 r
.13827 .69761 m .13886 .69569 L .11324 .6613 L p F P
0 g
s
.938 .685 .528 r
.11774 .65392 m .11324 .6613 L .13886 .69569 L p F P
0 g
s
.938 .685 .528 r
.1159 .62474 m .1068 .63538 L .08785 .59477 L p F P
0 g
s
.938 .685 .528 r
.08785 .59477 m .09919 .58884 L .1159 .62474 L p F P
0 g
s
.93 .914 .78 r
.52838 .62143 m .51567 .64882 L .49571 .6451 L p F P
0 g
s
.87 .951 .861 r
.4805 .6627 m .49571 .6451 L .51567 .64882 L p F P
0 g
s
.998 .834 .493 r
.31099 .32203 m .31523 .34654 L .32442 .32808 L p F P
0 g
s
.998 .834 .493 r
.32442 .32808 m .32177 .30087 L .31099 .32203 L p F P
0 g
s
.989 .884 .553 r
.56669 .49147 m .57265 .43967 L .57417 .43835 L p F P
0 g
s
.987 .88 .633 r
.57265 .43967 m .56669 .49147 L .56104 .4925 L p F P
0 g
s
.985 .887 .642 r
.55091 .54162 m .56104 .4925 L .56669 .49147 L p F P
0 g
s
.713 .903 .963 r
.6662 .14566 m .65069 .15429 L .66909 .16715 L p F P
0 g
s
.713 .903 .963 r
.66909 .16715 m .68458 .15886 L .6662 .14566 L p F P
0 g
s
.938 .685 .528 r
.06525 .50787 m .07919 .51209 L .08672 .55057 L p F P
0 g
s
.938 .685 .528 r
.07919 .51209 m .06525 .50787 L .06285 .4666 L p F P
0 g
s
.938 .685 .528 r
.11324 .6613 m .11232 .6628 L .13827 .69761 L p F P
0 g
s
.847 .452 .296 r
.67653 .4936 m .63747 .46332 L .63396 .4689 L p F P
0 g
s
.847 .452 .296 r
.63396 .4689 m .67123 .50291 L .67653 .4936 L p F P
0 g
s
.938 .685 .528 r
.05344 .48216 m .0551 .48295 L .0559 .44112 L p F P
0 g
s
.938 .685 .528 r
.0559 .44112 m .05426 .43981 L .05344 .48216 L p F P
0 g
s
.938 .685 .528 r
.12944 .67094 m .12574 .67943 L .10154 .64153 L p F P
0 g
s
.938 .685 .528 r
.10154 .64153 m .1068 .63538 L .12944 .67094 L p F P
0 g
s
.848 .411 .184 r
.5559 .39407 m .51722 .35724 L .52263 .35544 L p F P
0 g
s
.848 .411 .184 r
.52263 .35544 m .55765 .39338 L .5559 .39407 L p F P
0 g
s
0 0 0 r
.82431 .54445 m .81267 .55533 L .80483 .57468 L p F P
0 g
s
.422 0 .112 r
.78734 .5771 m .80483 .57468 L .81267 .55533 L p F P
0 g
s
.938 .685 .528 r
.12126 .64817 m .11505 .65832 L .09324 .61845 L p F P
0 g
s
.938 .685 .528 r
.09324 .61845 m .10142 .6118 L .12126 .64817 L p F P
0 g
s
.959 .868 .704 r
.61127 .23931 m .60028 .28365 L .61038 .28915 L p F P
0 g
s
.965 .859 .685 r
.59638 .33637 m .61038 .28915 L .60028 .28365 L p F P
0 g
s
.751 .312 .208 r
.40254 .28391 m .37419 .27053 L .38881 .25769 L p F P
0 g
s
.751 .312 .208 r
.38881 .25769 m .41516 .27225 L .40254 .28391 L p F P
0 g
s
.938 .685 .528 r
.05468 .46141 m .06285 .4666 L .06525 .50787 L p F P
0 g
s
.938 .685 .528 r
.0584 .4845 m .05344 .48216 L .05426 .43981 L p F P
0 g
s
.951 .887 .732 r
.54009 .5852 m .52838 .62143 L .51079 .61769 L p F P
0 g
s
.93 .914 .78 r
.49571 .6451 m .51079 .61769 L .52838 .62143 L p F P
0 g
s
.938 .685 .528 r
.0584 .4845 m .06965 .4898 L .07486 .53029 L p F P
0 g
s
.938 .685 .528 r
.10707 .60722 m .09679 .61557 L .11774 .65392 L p F P
0 g
s
.938 .685 .528 r
.09679 .61557 m .10707 .60722 L .09237 .56987 L p F P
0 g
s
.938 .685 .528 r
.08012 .57329 m .09237 .56987 L .0823 .53122 L p F P
0 g
s
.938 .685 .528 r
.0823 .53122 m .06874 .52952 L .08012 .57329 L p F P
0 g
s
.935 .56 .238 r
.40367 .61885 m .39504 .59014 L .37975 .57542 L p F P
0 g
s
.263 .686 .966 r
.68276 .1477 m .6662 .14566 L .68458 .15886 L p F P
0 g
s
.263 .686 .966 r
.68458 .15886 m .70027 .16044 L .68276 .1477 L p F P
0 g
s
.879 .654 .13 r
.83324 .47882 m .8278 .45042 L .82743 .43001 L p F P
0 g
s
.933 .719 .239 r
.8278 .45042 m .83324 .47882 L .83062 .49928 L p F P
0 g
s
.822 .696 .157 r
.83026 .52558 m .83062 .49928 L .83324 .47882 L p F P
0 g
s
.854 .463 .301 r
.63747 .46332 m .59644 .43014 L .59517 .43196 L p F P
0 g
s
.854 .463 .301 r
.59517 .43196 m .63396 .4689 L .63747 .46332 L p F P
0 g
s
.805 .388 .256 r
.43581 .30457 m .40254 .28391 L .41516 .27225 L p F P
0 g
s
.805 .388 .256 r
.41516 .27225 m .44589 .29461 L .43581 .30457 L p F P
0 g
s
.938 .685 .528 r
.12498 .68116 m .12723 .67601 L .10366 .63905 L p F P
0 g
s
.938 .685 .528 r
.1109 .63058 m .10366 .63905 L .12723 .67601 L p F P
0 g
s
.938 .685 .528 r
.09919 .58884 m .08785 .59477 L .07372 .55143 L p F P
0 g
s
.938 .685 .528 r
.07372 .55143 m .08672 .55057 L .09919 .58884 L p F P
0 g
s
.938 .685 .528 r
.08672 .55057 m .07372 .55143 L .06525 .50787 L p F P
0 g
s
.997 .766 .437 r
.30996 .37161 m .32143 .39585 L .32548 .37592 L p F P
0 g
s
.997 .766 .437 r
.32548 .37592 m .31523 .34654 L .30996 .37161 L p F P
0 g
s
.961 .87 .702 r
.55091 .54162 m .54009 .5852 L .52564 .58163 L p F P
0 g
s
.951 .887 .732 r
.51079 .61769 m .52564 .58163 L .54009 .5852 L p F P
0 g
s
.922 .641 .156 r
.82743 .43001 m .81714 .40331 L .8152 .38668 L p F P
0 g
s
.945 .677 .216 r
.81714 .40331 m .82743 .43001 L .8278 .45042 L p F P
0 g
s
.96 .629 .333 r
.36782 .53178 m .36481 .55553 L .37975 .57542 L p F P
0 g
s
.965 .64 .328 r
.36481 .55553 m .36782 .53178 L .35842 .51524 L p F P
0 g
s
.965 .859 .685 r
.60028 .28365 m .59005 .33326 L .59638 .33637 L p F P
0 g
s
.968 .854 .675 r
.58248 .38703 m .59638 .33637 L .59005 .33326 L p F P
0 g
s
.944 .82 .692 r
.59638 .33637 m .58248 .38703 L .58482 .38902 L p F P
0 g
s
.938 .685 .528 r
.09237 .56987 m .08012 .57329 L .09679 .61557 L p F P
0 g
s
.985 .708 .394 r
.32361 .44703 m .33972 .45767 L .33773 .43913 L p F P
0 g
s
.985 .708 .394 r
.33773 .43913 m .32077 .41996 L .32361 .44703 L p F P
0 g
s
.831 .404 0 r
.74638 .22105 m .73146 .19224 L .74604 .20877 L p F P
0 g
s
.831 .404 0 r
.74604 .20877 m .75792 .23399 L .74638 .22105 L p F P
0 g
s
.938 .685 .528 r
.05553 .50493 m .06043 .50641 L .05798 .46351 L p F P
0 g
s
.938 .685 .528 r
.05798 .46351 m .05302 .46036 L .05553 .50493 L p F P
0 g
s
.893 .513 .057 r
.76835 .26573 m .75792 .23399 L .76988 .25177 L p F P
0 g
s
.893 .513 .057 r
.76988 .25177 m .77669 .27802 L .76835 .26573 L p F P
0 g
s
.938 .685 .528 r
.10366 .63905 m .1109 .63058 L .09296 .5921 L p F P
0 g
s
.672 .132 0 r
.4504 .66633 m .43599 .65268 L .41433 .64023 L p F P
0 g
s
.879 .443 .117 r
.40367 .61885 m .41433 .64023 L .43599 .65268 L p F P
0 g
s
.832 .429 .281 r
.473 .3312 m .43581 .30457 L .44589 .29461 L p F P
0 g
s
.832 .429 .281 r
.44589 .29461 m .48021 .32347 L .473 .3312 L p F P
0 g
s
.938 .685 .528 r
.11324 .6613 m .11774 .65392 L .09679 .61557 L p F P
0 g
s
.938 .685 .528 r
.06923 .55173 m .07958 .55104 L .07153 .50978 L p F P
0 g
s
.938 .685 .528 r
.07153 .50978 m .06043 .50641 L .06923 .55173 L p F P
0 g
s
0 0 0 r
.80483 .57468 m .81693 .56299 L .82431 .54445 L p F P
0 g
s
.73 .777 .284 r
.83026 .52558 m .82431 .54445 L .81693 .56299 L p F P
0 g
s
.938 .685 .528 r
.12574 .67943 m .12498 .68116 L .10047 .64279 L p F P
0 g
s
.938 .685 .528 r
.10047 .64279 m .10154 .64153 L .12574 .67943 L p F P
0 g
s
.965 .859 .685 r
.56104 .4925 m .55091 .54162 L .5402 .53853 L p F P
0 g
s
.961 .87 .702 r
.52564 .58163 m .5402 .53853 L .55091 .54162 L p F P
0 g
s
.987 .88 .633 r
.56104 .4925 m .57074 .43991 L .57265 .43967 L p F P
0 g
s
.938 .685 .528 r
.06089 .52853 m .06874 .52952 L .06328 .4868 L p F P
0 g
s
.938 .685 .528 r
.06328 .4868 m .0551 .48295 L .06089 .52853 L p F P
0 g
s
.938 .685 .528 r
.06525 .50787 m .05718 .50543 L .05468 .46141 L p F P
0 g
s
.938 .685 .528 r
.05302 .46036 m .05468 .46141 L .05718 .50543 L p F P
0 g
s
.938 .685 .528 r
.10366 .63905 m .10047 .64279 L .12498 .68116 L p F P
0 g
s
.847 .451 .295 r
.51299 .36222 m .473 .3312 L .48021 .32347 L p F P
0 g
s
.847 .451 .295 r
.48021 .32347 m .51722 .35724 L .51299 .36222 L p F P
0 g
s
.918 .881 .458 r
.31347 .30366 m .31099 .32203 L .32177 .30087 L p F P
0 g
s
.918 .881 .458 r
.32177 .30087 m .32524 .28077 L .31347 .30366 L p F P
0 g
s
.968 .854 .675 r
.57074 .43991 m .56104 .4925 L .55449 .4903 L p F P
0 g
s
.965 .859 .685 r
.5402 .53853 m .55449 .4903 L .56104 .4925 L p F P
0 g
s
0 .135 .579 r
.70014 .16021 m .68276 .1477 L .70027 .16044 L p F P
0 g
s
0 .135 .579 r
.70027 .16044 m .71598 .17174 L .70014 .16021 L p F P
0 g
s
.968 .854 .675 r
.59005 .33326 m .58031 .38608 L .58248 .38703 L p F P
0 g
s
.938 .685 .528 r
.05718 .50543 m .05553 .50493 L .05302 .46036 L p F P
0 g
s
.938 .685 .528 r
.10142 .6118 m .09324 .61845 L .07589 .57447 L p F P
0 g
s
.938 .685 .528 r
.07589 .57447 m .08565 .57175 L .10142 .6118 L p F P
0 g
s
.854 .463 .301 r
.55454 .39582 m .51299 .36222 L .51722 .35724 L p F P
0 g
s
.854 .463 .301 r
.51722 .35724 m .5559 .39407 L .55454 .39582 L p F P
0 g
s
.939 .614 .172 r
.79363 .33558 m .80029 .32944 L .80658 .34894 L p F P
0 g
s
.939 .614 .172 r
.80658 .34894 m .79691 .34575 L .79363 .33558 L p F P
0 g
s
.944 .628 .188 r
.79691 .34575 m .80658 .34894 L .81163 .36829 L p F P
0 g
s
.936 .603 .164 r
.78982 .32576 m .793 .3106 L .80029 .32944 L p F P
0 g
s
.936 .603 .164 r
.80029 .32944 m .79363 .33558 L .78982 .32576 L p F P
0 g
s
.965 .64 .328 r
.35842 .51524 m .35102 .53141 L .36481 .55553 L p F P
0 g
s
.97 .654 .332 r
.35102 .53141 m .35842 .51524 L .35034 .49673 L p F P
0 g
s
.938 .685 .528 r
.06406 .52893 m .07486 .53029 L .08565 .57175 L p F P
0 g
s
.938 .685 .528 r
.07486 .53029 m .06406 .52893 L .0584 .4845 L p F P
0 g
s
.981 .69 .367 r
.32983 .47566 m .344 .4772 L .33972 .45767 L p F P
0 g
s
.981 .69 .367 r
.33972 .45767 m .32361 .44703 L .32983 .47566 L p F P
0 g
s
.968 .854 .675 r
.55449 .4903 m .56855 .43906 L .57074 .43991 L p F P
0 g
s
.938 .685 .528 r
.11505 .65832 m .11232 .6628 L .08962 .62139 L p F P
0 g
s
.938 .685 .528 r
.08962 .62139 m .09324 .61845 L .11505 .65832 L p F P
0 g
s
.938 .685 .528 r
.09296 .5921 m .08393 .59682 L .10366 .63905 L p F P
0 g
s
.938 .685 .528 r
.08393 .59682 m .09296 .5921 L .07958 .55104 L p F P
0 g
s
.938 .685 .528 r
.1068 .63538 m .10154 .64153 L .08128 .5982 L p F P
0 g
s
.938 .685 .528 r
.08128 .5982 m .08785 .59477 L .1068 .63538 L p F P
0 g
s
.848 .412 .184 r
.63396 .4689 m .59517 .43196 L .59348 .43273 L p F P
0 g
s
.938 .685 .528 r
.05344 .48216 m .0584 .4845 L .06406 .52893 L p F P
0 g
s
.938 .685 .528 r
.07958 .55104 m .06923 .55173 L .08393 .59682 L p F P
0 g
s
.987 .88 .633 r
.58449 .33332 m .57842 .38621 L .58031 .38608 L p F P
0 g
s
.987 .88 .633 r
.58031 .38608 m .59005 .33326 L .58449 .33332 L p F P
0 g
s
.944 .628 .188 r
.81163 .36829 m .79953 .35584 L .79691 .34575 L p F P
0 g
s
.951 .644 .209 r
.79953 .35584 m .81163 .36829 L .8152 .38668 L p F P
0 g
s
.938 .685 .528 r
.05718 .50543 m .06525 .50787 L .07372 .55143 L p F P
0 g
s
.938 .685 .528 r
.08565 .57175 m .07589 .57447 L .06406 .52893 L p F P
0 g
s
.936 .596 .163 r
.78567 .31674 m .78503 .29321 L .793 .3106 L p F P
0 g
s
.936 .596 .163 r
.793 .3106 m .78982 .32576 L .78567 .31674 L p F P
0 g
s
.97 .654 .332 r
.35034 .49673 m .33914 .50431 L .35102 .53141 L p F P
0 g
s
.976 .672 .346 r
.33914 .50431 m .35034 .49673 L .344 .4772 L p F P
0 g
s
.976 .672 .346 r
.344 .4772 m .32983 .47566 L .33914 .50431 L p F P
0 g
s
.839 .396 .172 r
.67123 .50291 m .63396 .4689 L .62919 .47142 L p F P
0 g
s
.848 .412 .184 r
.59348 .43273 m .62919 .47142 L .63396 .4689 L p F P
0 g
s
.944 .82 .692 r
.56855 .43906 m .55449 .4903 L .54732 .48491 L p F P
0 g
s
.944 .82 .692 r
.54732 .48491 m .56616 .43716 L .56855 .43906 L p F P
0 g
s
.672 .132 0 r
.41433 .64023 m .42686 .65289 L .4504 .66633 L p F P
0 g
s
.096 .579 .906 r
.46533 .66981 m .4504 .66633 L .42686 .65289 L p F P
0 g
s
.938 .685 .528 r
.11232 .6628 m .11324 .6613 L .09083 .6204 L p F P
0 g
s
.938 .685 .528 r
.09679 .61557 m .09083 .6204 L .11324 .6613 L p F P
0 g
s
.853 .504 .391 r
.51299 .36222 m .55454 .39582 L .55366 .39856 L p F P
0 g
s
.985 .887 .643 r
.59136 .28326 m .58449 .33332 L .59005 .33326 L p F P
0 g
s
.985 .887 .643 r
.59005 .33326 m .60028 .28365 L .59136 .28326 L p F P
0 g
s
.926 .802 .334 r
.83062 .49928 m .83026 .52558 L .82357 .54232 L p F P
0 g
s
.73 .777 .284 r
.81693 .56299 m .82357 .54232 L .83026 .52558 L p F P
0 g
s
.822 .368 .151 r
.706 .53217 m .67123 .50291 L .66387 .50734 L p F P
0 g
s
.839 .396 .172 r
.62919 .47142 m .66387 .50734 L .67123 .50291 L p F P
0 g
s
.938 .685 .528 r
.05929 .52833 m .06089 .52853 L .0551 .48295 L p F P
0 g
s
.938 .685 .528 r
.0551 .48295 m .05344 .48216 L .05929 .52833 L p F P
0 g
s
.824 .347 .036 r
.62919 .47142 m .59348 .43273 L .59146 .43241 L p F P
0 g
s
.938 .685 .528 r
.09083 .6204 m .08962 .62139 L .11232 .6628 L p F P
0 g
s
.989 .884 .553 r
.57998 .33663 m .57689 .38743 L .57842 .38621 L p F P
0 g
s
.989 .884 .553 r
.57842 .38621 m .58449 .33332 L .57998 .33663 L p F P
0 g
s
.938 .685 .528 r
.09083 .6204 m .09679 .61557 L .08012 .57329 L p F P
0 g
s
.98 .9 .662 r
.59946 .23819 m .59136 .28326 L .60028 .28365 L p F P
0 g
s
.98 .9 .662 r
.60028 .28365 m .61127 .23931 L .59946 .23819 L p F P
0 g
s
0 0 0 r
.32307 .29237 m .31347 .30366 L .32524 .28077 L p F P
0 g
s
0 0 0 r
.32524 .28077 m .33515 .26875 L .32307 .29237 L p F P
0 g
s
.938 .685 .528 r
.07302 .57527 m .08012 .57329 L .06874 .52952 L p F P
0 g
s
.938 .685 .528 r
.06874 .52952 m .06089 .52853 L .07302 .57527 L p F P
0 g
s
.938 .685 .528 r
.06406 .52893 m .05929 .52833 L .05344 .48216 L p F P
0 g
s
.938 .685 .528 r
.10047 .64279 m .10366 .63905 L .08393 .59682 L p F P
0 g
s
.789 .318 .117 r
.73742 .5551 m .706 .53217 L .69661 .5385 L p F P
0 g
s
.822 .368 .151 r
.66387 .50734 m .69661 .5385 L .706 .53217 L p F P
0 g
s
.748 .258 0 r
.71797 .18255 m .70014 .16021 L .71598 .17174 L p F P
0 g
s
.748 .258 0 r
.71598 .17174 m .73146 .19224 L .71797 .18255 L p F P
0 g
s
.92 .784 .694 r
.56616 .43716 m .54732 .48491 L .53989 .47656 L p F P
0 g
s
.92 .784 .694 r
.53989 .47656 m .5637 .43428 L .56616 .43716 L p F P
0 g
s
.85 .539 .461 r
.51014 .37017 m .55366 .39856 L .5533 .40216 L p F P
0 g
s
.853 .504 .391 r
.55366 .39856 m .51014 .37017 L .51299 .36222 L p F P
0 g
s
.935 .56 .238 r
.37975 .57542 m .38428 .60042 L .40367 .61885 L p F P
0 g
s
.938 .567 .209 r
.38428 .60042 m .37975 .57542 L .36481 .55553 L p F P
0 g
s
.938 .685 .528 r
.06466 .55203 m .06923 .55173 L .06043 .50641 L p F P
0 g
s
.938 .685 .528 r
.06043 .50641 m .05553 .50493 L .06466 .55203 L p F P
0 g
s
.864 .422 .026 r
.41433 .64023 m .40367 .61885 L .38428 .60042 L p F P
0 g
s
.951 .644 .209 r
.8152 .38668 m .80137 .36539 L .79953 .35584 L p F P
0 g
s
.959 .661 .236 r
.80137 .36539 m .8152 .38668 L .81714 .40331 L p F P
0 g
s
.941 .823 .701 r
.55449 .4903 m .5402 .53853 L .52844 .53021 L p F P
0 g
s
.941 .823 .701 r
.52844 .53021 m .54732 .48491 L .55449 .4903 L p F P
0 g
s
.938 .592 .17 r
.78134 .30892 m .77669 .27802 L .78503 .29321 L p F P
0 g
s
.938 .592 .17 r
.78503 .29321 m .78567 .31674 L .78134 .30892 L p F P
0 g
s
.938 .685 .528 r
.08785 .59477 m .08128 .5982 L .06619 .55193 L p F P
0 g
s
.938 .685 .528 r
.06619 .55193 m .07372 .55143 L .08785 .59477 L p F P
0 g
s
.99 .74 .376 r
.30902 .40217 m .32077 .41996 L .32143 .39585 L p F P
0 g
s
.99 .74 .376 r
.32143 .39585 m .30996 .37161 L .30902 .40217 L p F P
0 g
s
.969 .92 .693 r
.60916 .20008 m .59946 .23819 L .61127 .23931 L p F P
0 g
s
.969 .92 .693 r
.61127 .23931 m .62324 .20203 L .60916 .20008 L p F P
0 g
s
.945 .677 .216 r
.8278 .45042 m .81734 .41746 L .81714 .40331 L p F P
0 g
s
.966 .708 .276 r
.81734 .41746 m .8278 .45042 L .82564 .46649 L p F P
0 g
s
.933 .719 .239 r
.83062 .49928 m .82564 .46649 L .8278 .45042 L p F P
0 g
s
.824 .347 .036 r
.59146 .43241 m .62338 .4707 L .62919 .47142 L p F P
0 g
s
.767 .268 0 r
.62338 .4707 m .59146 .43241 L .58919 .43101 L p F P
0 g
s
.938 .685 .528 r
.07372 .55143 m .06619 .55193 L .05718 .50543 L p F P
0 g
s
.953 .846 .421 r
.57675 .34307 m .5758 .38968 L .57689 .38743 L p F P
0 g
s
.953 .846 .421 r
.57689 .38743 m .57998 .33663 L .57675 .34307 L p F P
0 g
s
.725 .229 .056 r
.76473 .57039 m .73742 .5551 L .72657 .56311 L p F P
0 g
s
.789 .318 .117 r
.69661 .5385 m .72657 .56311 L .73742 .5551 L p F P
0 g
s
.846 .495 .389 r
.473 .3312 m .51299 .36222 L .51014 .37017 L p F P
0 g
s
.938 .685 .528 r
.08012 .57329 m .07302 .57527 L .09083 .6204 L p F P
0 g
s
.9 .75 .686 r
.5637 .43428 m .53989 .47656 L .53256 .46561 L p F P
0 g
s
.9 .75 .686 r
.53256 .46561 m .56128 .43056 L .5637 .43428 L p F P
0 g
s
.981 .796 .386 r
.30477 .35106 m .30996 .37161 L .31523 .34654 L p F P
0 g
s
.981 .796 .386 r
.31523 .34654 m .31099 .32203 L .30477 .35106 L p F P
0 g
s
.848 .57 .516 r
.50885 .38078 m .5533 .40216 L .55347 .40645 L p F P
0 g
s
.85 .539 .461 r
.5533 .40216 m .50885 .38078 L .51014 .37017 L p F P
0 g
s
.938 .685 .528 r
.10154 .64153 m .10047 .64279 L .07994 .5989 L p F P
0 g
s
.938 .685 .528 r
.07994 .5989 m .08128 .5982 L .10154 .64153 L p F P
0 g
s
.694 .87 .965 r
.4805 .6627 m .46533 .66981 L .44108 .65588 L p F P
0 g
s
.096 .579 .906 r
.42686 .65289 m .44108 .65588 L .46533 .66981 L p F P
0 g
s
.909 .524 .098 r
.76037 .25691 m .74638 .22105 L .75792 .23399 L p F P
0 g
s
.909 .524 .098 r
.75792 .23399 m .76835 .26573 L .76037 .25691 L p F P
0 g
s
.938 .685 .528 r
.05553 .50493 m .05718 .50543 L .06619 .55193 L p F P
0 g
s
.938 .685 .528 r
.09324 .61845 m .08962 .62139 L .07158 .57567 L p F P
0 g
s
.938 .685 .528 r
.07158 .57567 m .07589 .57447 L .09324 .61845 L p F P
0 g
s
.945 .95 .746 r
.62073 .1706 m .60916 .20008 L .62324 .20203 L p F P
0 g
s
.945 .95 .746 r
.62324 .20203 m .63636 .17332 L .62073 .1706 L p F P
0 g
s
.938 .685 .528 r
.05929 .52833 m .06406 .52893 L .07589 .57447 L p F P
0 g
s
.938 .685 .528 r
.08393 .59682 m .07994 .5989 L .10047 .64279 L p F P
0 g
s
.883 .717 .671 r
.56128 .43056 m .53256 .46561 L .52569 .45258 L p F P
0 g
s
.883 .717 .671 r
.52569 .45258 m .55901 .42618 L .56128 .43056 L p F P
0 g
s
.849 .599 .56 r
.5092 .39353 m .55347 .40645 L .55417 .41123 L p F P
0 g
s
.848 .57 .516 r
.55347 .40645 m .5092 .39353 L .50885 .38078 L p F P
0 g
s
.767 .268 0 r
.58919 .43101 m .61678 .46672 L .62338 .4707 L p F P
0 g
s
.674 .186 0 r
.61678 .46672 m .58919 .43101 L .58678 .42858 L p F P
0 g
s
.866 .75 .238 r
.57497 .3524 m .57521 .39287 L .5758 .38968 L p F P
0 g
s
.866 .75 .238 r
.5758 .38968 m .57675 .34307 L .57497 .3524 L p F P
0 g
s
.583 .05 0 r
.78734 .5771 m .76473 .57039 L .75301 .5797 L p F P
0 g
s
.725 .229 .056 r
.72657 .56311 m .75301 .5797 L .76473 .57039 L p F P
0 g
s
.934 .83 .718 r
.5402 .53853 m .52564 .58163 L .5097 .57101 L p F P
0 g
s
.934 .83 .718 r
.5097 .57101 m .52844 .53021 L .5402 .53853 L p F P
0 g
s
.938 .685 .528 r
.06619 .55193 m .06466 .55203 L .05553 .50493 L p F P
0 g
s
.429 .036 .19 r
.33986 .28866 m .32307 .29237 L .33515 .26875 L p F P
0 g
s
.429 .036 .19 r
.33515 .26875 m .35155 .26532 L .33986 .28866 L p F P
0 g
s
.87 .686 .652 r
.55901 .42618 m .52569 .45258 L .51965 .43811 L p F P
0 g
s
.87 .686 .652 r
.51965 .43811 m .55701 .42134 L .55901 .42618 L p F P
0 g
s
.853 .628 .597 r
.51119 .40782 m .55417 .41123 L .55537 .41627 L p F P
0 g
s
.849 .599 .56 r
.55417 .41123 m .51119 .40782 L .5092 .39353 L p F P
0 g
s
.811 .325 .014 r
.66387 .50734 m .62919 .47142 L .62338 .4707 L p F P
0 g
s
.938 .685 .528 r
.07994 .5989 m .08393 .59682 L .06923 .55173 L p F P
0 g
s
.846 .495 .389 r
.51014 .37017 m .46803 .34386 L .473 .3312 L p F P
0 g
s
.833 .479 .384 r
.43581 .30457 m .473 .3312 L .46803 .34386 L p F P
0 g
s
.86 .657 .627 r
.55701 .42134 m .51965 .43811 L .51473 .42293 L p F P
0 g
s
.86 .657 .627 r
.51473 .42293 m .55537 .41627 L .55701 .42134 L p F P
0 g
s
.938 .685 .528 r
.06923 .55173 m .06466 .55203 L .07994 .5989 L p F P
0 g
s
.853 .628 .597 r
.55537 .41627 m .51473 .42293 L .51119 .40782 L p F P
0 g
s
.85 .874 .857 r
.49571 .6451 m .4805 .6627 L .45675 .64878 L p F P
0 g
s
.694 .87 .965 r
.44108 .65588 m .45675 .64878 L .4805 .6627 L p F P
0 g
s
.985 .892 .56 r
.58407 .28815 m .57998 .33663 L .58449 .33332 L p F P
0 g
s
.985 .892 .56 r
.58449 .33332 m .59136 .28326 L .58407 .28815 L p F P
0 g
s
.938 .685 .528 r
.08962 .62139 m .09083 .6204 L .07302 .57527 L p F P
0 g
s
.972 .766 .338 r
.82564 .46649 m .83062 .49928 L .82483 .51341 L p F P
0 g
s
.926 .802 .334 r
.82357 .54232 m .82483 .51341 L .83062 .49928 L p F P
0 g
s
.938 .685 .528 r
.07589 .57447 m .07158 .57567 L .05929 .52833 L p F P
0 g
s
.674 .186 0 r
.58678 .42858 m .60969 .45962 L .61678 .46672 L p F P
0 g
s
0 0 .425 r
.60969 .45962 m .58678 .42858 L .58434 .42524 L p F P
0 g
s
.938 .685 .528 r
.07158 .57567 m .07302 .57527 L .06089 .52853 L p F P
0 g
s
.938 .685 .528 r
.06089 .52853 m .05929 .52833 L .07158 .57567 L p F P
0 g
s
.876 .984 .83 r
.6343 .15102 m .62073 .1706 L .63636 .17332 L p F P
0 g
s
.876 .984 .83 r
.63636 .17332 m .65069 .15429 L .6343 .15102 L p F P
0 g
s
.734 .603 .032 r
.57477 .3642 m .57514 .39684 L .57521 .39287 L p F P
0 g
s
.734 .603 .032 r
.57521 .39287 m .57497 .3524 L .57477 .3642 L p F P
0 g
s
.923 .84 .744 r
.52564 .58163 m .51079 .61769 L .49133 .60538 L p F P
0 g
s
.923 .84 .744 r
.49133 .60538 m .5097 .57101 L .52564 .58163 L p F P
0 g
s
.959 .661 .236 r
.81714 .40331 m .80235 .37397 L .80137 .36539 L p F P
0 g
s
.967 .677 .265 r
.80235 .37397 m .81714 .40331 L .81734 .41746 L p F P
0 g
s
.938 .685 .528 r
.07302 .57527 m .07158 .57567 L .08962 .62139 L p F P
0 g
s
.203 0 0 r
.80483 .57468 m .78734 .5771 L .77529 .58716 L p F P
0 g
s
.583 .05 0 r
.75301 .5797 m .77529 .58716 L .78734 .5771 L p F P
0 g
s
.901 .855 .787 r
.51079 .61769 m .49571 .6451 L .47359 .63171 L p F P
0 g
s
.85 .874 .857 r
.45675 .64878 m .47359 .63171 L .49571 .6451 L p F P
0 g
s
.871 .443 .026 r
.7358 .21366 m .71797 .18255 L .73146 .19224 L p F P
0 g
s
.871 .443 .026 r
.73146 .19224 m .74638 .22105 L .7358 .21366 L p F P
0 g
s
.901 .855 .787 r
.47359 .63171 m .49133 .60538 L .51079 .61769 L p F P
0 g
s
.941 .592 .183 r
.77704 .30265 m .76835 .26573 L .77669 .27802 L p F P
0 g
s
.941 .592 .183 r
.77669 .27802 m .78134 .30892 L .77704 .30265 L p F P
0 g
s
.677 .293 .312 r
.36355 .29259 m .33986 .28866 L .35155 .26532 L p F P
0 g
s
.677 .293 .312 r
.35155 .26532 m .37419 .27053 L .36355 .29259 L p F P
0 g
s
.938 .685 .528 r
.08128 .5982 m .07994 .5989 L .06466 .55203 L p F P
0 g
s
.938 .685 .528 r
.06466 .55203 m .06619 .55193 L .08128 .5982 L p F P
0 g
s
.833 .479 .384 r
.46803 .34386 m .4287 .32122 L .43581 .30457 L p F P
0 g
s
.81 .45 .375 r
.40254 .28391 m .43581 .30457 L .4287 .32122 L p F P
0 g
s
0 0 .425 r
.58434 .42524 m .60246 .4497 L .60969 .45962 L p F P
0 g
s
0 0 .492 r
.60246 .4497 m .58434 .42524 L .582 .42114 L p F P
0 g
s
0 0 .155 r
.57617 .3779 m .57561 .40142 L .57514 .39684 L p F P
0 g
s
0 0 .155 r
.57514 .39684 m .57477 .3642 L .57617 .3779 L p F P
0 g
s
.916 .786 .702 r
.54732 .48491 m .52844 .53021 L .51619 .51696 L p F P
0 g
s
.916 .786 .702 r
.51619 .51696 m .53989 .47656 L .54732 .48491 L p F P
0 g
s
.844 .532 .462 r
.46803 .34386 m .51014 .37017 L .50885 .38078 L p F P
0 g
s
.768 .398 .355 r
.39348 .30373 m .36355 .29259 L .37419 .27053 L p F P
0 g
s
.768 .398 .355 r
.37419 .27053 m .40254 .28391 L .39348 .30373 L p F P
0 g
s
.81 .45 .375 r
.4287 .32122 m .39348 .30373 L .40254 .28391 L p F P
0 g
s
.64 .957 .929 r
.64987 .14217 m .6343 .15102 L .65069 .15429 L p F P
0 g
s
.64 .957 .929 r
.65069 .15429 m .6662 .14566 L .64987 .14217 L p F P
0 g
s
0 0 .492 r
.582 .42114 m .59544 .43742 L .60246 .4497 L p F P
0 g
s
0 0 .504 r
.59544 .43742 m .582 .42114 L .57986 .41648 L p F P
0 g
s
0 0 .303 r
.57912 .39283 m .57658 .40637 L .57561 .40142 L p F P
0 g
s
0 0 .303 r
.57561 .40142 m .57617 .3779 L .57912 .39283 L p F P
0 g
s
.938 .567 .209 r
.36481 .55553 m .36524 .57525 L .38428 .60042 L p F P
0 g
s
.941 .581 .194 r
.36524 .57525 m .36481 .55553 L .35102 .53141 L p F P
0 g
s
.979 .706 .315 r
.31257 .43667 m .32361 .44703 L .32077 .41996 L p F P
0 g
s
.979 .706 .315 r
.32077 .41996 m .30902 .40217 L .31257 .43667 L p F P
0 g
s
0 0 .504 r
.57986 .41648 m .58901 .42336 L .59544 .43742 L p F P
0 g
s
0 0 .475 r
.58901 .42336 m .57986 .41648 L .57802 .41148 L p F P
0 g
s
0 0 .408 r
.58347 .40825 m .57802 .41148 L .57658 .40637 L p F P
0 g
s
0 0 .408 r
.57658 .40637 m .57912 .39283 L .58347 .40825 L p F P
0 g
s
0 0 .475 r
.57802 .41148 m .58347 .40825 L .58901 .42336 L p F P
0 g
s
.203 0 0 r
.77529 .58716 m .79294 .58484 L .80483 .57468 L p F P
0 g
s
.526 .848 .552 r
.81693 .56299 m .80483 .57468 L .79294 .58484 L p F P
0 g
s
.535 .025 0 r
.42686 .65289 m .41433 .64023 L .39177 .61894 L p F P
0 g
s
.864 .422 .026 r
.38428 .60042 m .39177 .61894 L .41433 .64023 L p F P
0 g
s
.785 .284 0 r
.69661 .5385 m .66387 .50734 L .65475 .50653 L p F P
0 g
s
.811 .325 .014 r
.62338 .4707 m .65475 .50653 L .66387 .50734 L p F P
0 g
s
.978 .906 .572 r
.58977 .24416 m .58407 .28815 L .59136 .28326 L p F P
0 g
s
.978 .906 .572 r
.59136 .28326 m .59946 .23819 L .58977 .24416 L p F P
0 g
s
.784 .736 .21 r
.30666 .3353 m .30477 .35106 L .31099 .32203 L p F P
0 g
s
.784 .736 .21 r
.31099 .32203 m .31347 .30366 L .30666 .3353 L p F P
0 g
s
0 .543 .759 r
.66729 .14435 m .64987 .14217 L .6662 .14566 L p F P
0 g
s
0 .543 .759 r
.6662 .14566 m .68276 .1477 L .66729 .14435 L p F P
0 g
s
.746 .238 0 r
.65475 .50653 m .62338 .4707 L .61678 .46672 L p F P
0 g
s
.944 .85 .419 r
.57883 .29823 m .57675 .34307 L .57998 .33663 L p F P
0 g
s
.944 .85 .419 r
.57998 .33663 m .58407 .28815 L .57883 .29823 L p F P
0 g
s
.895 .75 .693 r
.53989 .47656 m .51619 .51696 L .50407 .49933 L p F P
0 g
s
.895 .75 .693 r
.50407 .49933 m .53256 .46561 L .53989 .47656 L p F P
0 g
s
.966 .708 .276 r
.82564 .46649 m .81576 .42845 L .81734 .41746 L p F P
0 g
s
.982 .732 .332 r
.81576 .42845 m .82564 .46649 L .82097 .47737 L p F P
0 g
s
.972 .766 .338 r
.82483 .51341 m .82097 .47737 L .82564 .46649 L p F P
0 g
s
.904 .926 .543 r
.82357 .54232 m .81693 .56299 L .80566 .57259 L p F P
0 g
s
.526 .848 .552 r
.79294 .58484 m .80566 .57259 L .81693 .56299 L p F P
0 g
s
.842 .565 .518 r
.4656 .36093 m .50885 .38078 L .5092 .39353 L p F P
0 g
s
.844 .532 .462 r
.50885 .38078 m .4656 .36093 L .46803 .34386 L p F P
0 g
s
.967 .677 .265 r
.81734 .41746 m .8024 .3812 L .80235 .37397 L p F P
0 g
s
.975 .691 .295 r
.8024 .3812 m .81734 .41746 L .81576 .42845 L p F P
0 g
s
.839 .41 0 r
.39177 .61894 m .38428 .60042 L .36524 .57525 L p F P
0 g
s
.909 .789 .716 r
.52844 .53021 m .5097 .57101 L .49304 .55362 L p F P
0 g
s
.909 .789 .716 r
.49304 .55362 m .51619 .51696 L .52844 .53021 L p F P
0 g
s
.946 .595 .202 r
.77295 .29825 m .76037 .25691 L .76835 .26573 L p F P
0 g
s
.946 .595 .202 r
.76835 .26573 m .77704 .30265 L .77295 .29825 L p F P
0 g
s
.923 .54 .147 r
.75311 .25205 m .7358 .21366 L .74638 .22105 L p F P
0 g
s
.923 .54 .147 r
.74638 .22105 m .76037 .25691 L .75311 .25205 L p F P
0 g
s
.941 .581 .194 r
.35102 .53141 m .34762 .54455 L .36524 .57525 L p F P
0 g
s
.946 .603 .198 r
.34762 .54455 m .35102 .53141 L .33914 .50431 L p F P
0 g
s
.943 .731 .261 r
.3036 .38668 m .30902 .40217 L .30996 .37161 L p F P
0 g
s
.943 .731 .261 r
.30996 .37161 m .30477 .35106 L .3036 .38668 L p F P
0 g
s
.967 .669 .261 r
.3205 .47327 m .32983 .47566 L .32361 .44703 L p F P
0 g
s
.967 .669 .261 r
.32361 .44703 m .31257 .43667 L .3205 .47327 L p F P
0 g
s
.832 .52 .462 r
.4287 .32122 m .46803 .34386 L .4656 .36093 L p F P
0 g
s
.619 .055 0 r
.68622 .15735 m .66729 .14435 L .68276 .1477 L p F P
0 g
s
.619 .055 0 r
.68276 .1477 m .70014 .16021 L .68622 .15735 L p F P
0 g
s
.736 .21 0 r
.72657 .56311 m .69661 .5385 L .68479 .53783 L p F P
0 g
s
.785 .284 0 r
.65475 .50653 m .68479 .53783 L .69661 .5385 L p F P
0 g
s
.961 .928 .594 r
.59757 .2067 m .58977 .24416 L .59946 .23819 L p F P
0 g
s
.961 .928 .594 r
.59946 .23819 m .60916 .20008 L .59757 .2067 L p F P
0 g
s
.967 .652 .271 r
.79691 .34575 m .78366 .34318 L .79363 .33558 L closepath p F P
0 g
s
.968 .656 .275 r
.79953 .35584 m .78366 .34318 L .79691 .34575 L closepath p F P
0 g
s
.966 .648 .268 r
.79363 .33558 m .78366 .34318 L .78982 .32576 L closepath p F P
0 g
s
.535 .025 0 r
.39177 .61894 m .40226 .62968 L .42686 .65289 L p F P
0 g
s
.284 .606 .954 r
.44108 .65588 m .42686 .65289 L .40226 .62968 L p F P
0 g
s
.878 .716 .678 r
.53256 .46561 m .50407 .49933 L .49271 .47816 L p F P
0 g
s
.878 .716 .678 r
.49271 .47816 m .52569 .45258 L .53256 .46561 L p F P
0 g
s
.981 .854 .472 r
.82483 .51341 m .82357 .54232 L .81333 .55078 L p F P
0 g
s
.904 .926 .543 r
.80566 .57259 m .81333 .55078 L .82357 .54232 L p F P
0 g
s
.946 .603 .198 r
.33914 .50431 m .33241 .50992 L .34762 .54455 L p F P
0 g
s
.955 .633 .221 r
.33241 .50992 m .33914 .50431 L .32983 .47566 L p F P
0 g
s
.843 .595 .563 r
.46591 .38163 m .5092 .39353 L .51119 .40782 L p F P
0 g
s
.842 .565 .518 r
.5092 .39353 m .46591 .38163 L .4656 .36093 L p F P
0 g
s
.955 .633 .221 r
.32983 .47566 m .3205 .47327 L .33241 .50992 L p F P
0 g
s
.97 .66 .281 r
.80137 .36539 m .78366 .34318 L .79953 .35584 L closepath p F P
0 g
s
.966 .646 .268 r
.78982 .32576 m .78366 .34318 L .78567 .31674 L closepath p F P
0 g
s
.746 .238 0 r
.61678 .46672 m .64425 .50037 L .65475 .50653 L p F P
0 g
s
.64 .147 0 r
.64425 .50037 m .61678 .46672 L .60969 .45962 L p F P
0 g
s
0 0 .205 r
.31612 .32516 m .30666 .3353 L .31347 .30366 L p F P
0 g
s
0 0 .205 r
.31347 .30366 m .32307 .29237 L .31612 .32516 L p F P
0 g
s
.844 .742 .222 r
.57594 .31316 m .57497 .3524 L .57675 .34307 L p F P
0 g
s
.844 .742 .222 r
.57675 .34307 m .57883 .29823 L .57594 .31316 L p F P
0 g
s
.823 .346 0 r
.70622 .18043 m .68622 .15735 L .70014 .16021 L p F P
0 g
s
.823 .346 0 r
.70014 .16021 m .71797 .18255 L .70622 .18043 L p F P
0 g
s
.896 .794 .74 r
.5097 .57101 m .49133 .60538 L .47094 .58477 L p F P
0 g
s
.896 .794 .74 r
.47094 .58477 m .49304 .55362 L .5097 .57101 L p F P
0 g
s
.972 .664 .289 r
.80235 .37397 m .78366 .34318 L .80137 .36539 L closepath p F P
0 g
s
.965 .644 .269 r
.78567 .31674 m .78366 .34318 L .78134 .30892 L closepath p F P
0 g
s
.635 .072 0 r
.75301 .5797 m .72657 .56311 L .71273 .5627 L p F P
0 g
s
.736 .21 0 r
.68479 .53783 m .71273 .5627 L .72657 .56311 L p F P
0 g
s
.864 .684 .657 r
.52569 .45258 m .49271 .47816 L .48274 .45454 L p F P
0 g
s
.864 .684 .657 r
.48274 .45454 m .51965 .43811 L .52569 .45258 L p F P
0 g
s
.847 .625 .601 r
.46898 .40496 m .51119 .40782 L .51473 .42293 L p F P
0 g
s
.843 .595 .563 r
.51119 .40782 m .46898 .40496 L .46591 .38163 L p F P
0 g
s
.832 .52 .462 r
.4656 .36093 m .42504 .34393 L .4287 .32122 L p F P
0 g
s
.811 .498 .46 r
.39348 .30373 m .4287 .32122 L .42504 .34393 L p F P
0 g
s
.702 .18 0 r
.68479 .53783 m .65475 .50653 L .64425 .50037 L p F P
0 g
s
.993 .793 .419 r
.82097 .47737 m .82483 .51341 L .816 .52028 L p F P
0 g
s
.981 .854 .472 r
.81333 .55078 m .816 .52028 L .82483 .51341 L p F P
0 g
s
.975 .691 .295 r
.81576 .42845 m .80153 .38674 L .8024 .3812 L p F P
0 g
s
.981 .702 .324 r
.80153 .38674 m .81576 .42845 L .81243 .43573 L p F P
0 g
s
.982 .732 .332 r
.82097 .47737 m .81243 .43573 L .81576 .42845 L p F P
0 g
s
.92 .957 .63 r
.60785 .17753 m .59757 .2067 L .60916 .20008 L p F P
0 g
s
.92 .957 .63 r
.60916 .20008 m .62073 .1706 L .60785 .17753 L p F P
0 g
s
.854 .654 .631 r
.51965 .43811 m .48274 .45454 L .47469 .4297 L p F P
0 g
s
.854 .654 .631 r
.47469 .4297 m .51473 .42293 L .51965 .43811 L p F P
0 g
s
.847 .625 .601 r
.51473 .42293 m .47469 .4297 L .46898 .40496 L p F P
0 g
s
.699 .787 .918 r
.45675 .64878 m .44108 .65588 L .41568 .63176 L p F P
0 g
s
.284 .606 .954 r
.40226 .62968 m .41568 .63176 L .44108 .65588 L p F P
0 g
s
.924 .855 .415 r
.58276 .25721 m .57883 .29823 L .58407 .28815 L p F P
0 g
s
.924 .855 .415 r
.58407 .28815 m .58977 .24416 L .58276 .25721 L p F P
0 g
s
.95 .6 .225 r
.76928 .29592 m .75311 .25205 L .76037 .25691 L p F P
0 g
s
.95 .6 .225 r
.76037 .25691 m .77295 .29825 L .76928 .29592 L p F P
0 g
s
.973 .669 .297 r
.8024 .3812 m .78366 .34318 L .80235 .37397 L closepath p F P
0 g
s
.966 .643 .273 r
.78134 .30892 m .78366 .34318 L .77704 .30265 L closepath p F P
0 g
s
.887 .751 .706 r
.51619 .51696 m .49304 .55362 L .47653 .53018 L p F P
0 g
s
.887 .751 .706 r
.47653 .53018 m .50407 .49933 L .51619 .51696 L p F P
0 g
s
.899 .482 .119 r
.72669 .21234 m .70622 .18043 L .71797 .18255 L p F P
0 g
s
.899 .482 .119 r
.71797 .18255 m .7358 .21366 L .72669 .21234 L p F P
0 g
s
.872 .8 .776 r
.49133 .60538 m .47359 .63171 L .45038 .60888 L p F P
0 g
s
.872 .8 .776 r
.45038 .60888 m .47094 .58477 L .49133 .60538 L p F P
0 g
s
.525 .224 .399 r
.33323 .32108 m .31612 .32516 L .32307 .29237 L p F P
0 g
s
.525 .224 .399 r
.32307 .29237 m .33986 .28866 L .33323 .32108 L p F P
0 g
s
.831 .555 .521 r
.42504 .34393 m .4656 .36093 L .46591 .38163 L p F P
0 g
s
.839 .41 0 r
.36524 .57525 m .36953 .58963 L .39177 .61894 L p F P
0 g
s
.815 .414 0 r
.36953 .58963 m .36524 .57525 L .34762 .54455 L p F P
0 g
s
.64 .147 0 r
.60969 .45962 m .63287 .48901 L .64425 .50037 L p F P
0 g
s
0 0 .472 r
.63287 .48901 m .60969 .45962 L .60246 .4497 L p F P
0 g
s
.397 0 0 r
.77529 .58716 m .75301 .5797 L .73786 .57954 L p F P
0 g
s
.635 .072 0 r
.71273 .5627 m .73786 .57954 L .75301 .5797 L p F P
0 g
s
.811 .498 .46 r
.42504 .34393 m .3886 .331 L .39348 .30373 L p F P
0 g
s
.774 .46 .456 r
.36355 .29259 m .39348 .30373 L .3886 .331 L p F P
0 g
s
0 0 0 r
.57562 .33228 m .57477 .3642 L .57497 .3524 L p F P
0 g
s
0 0 0 r
.57497 .3524 m .57594 .31316 L .57562 .33228 L p F P
0 g
s
.824 .804 .832 r
.47359 .63171 m .45675 .64878 L .43182 .62477 L p F P
0 g
s
.699 .787 .918 r
.41568 .63176 m .43182 .62477 L .45675 .64878 L p F P
0 g
s
.893 .648 .134 r
.30774 .42707 m .31257 .43667 L .30902 .40217 L p F P
0 g
s
.893 .648 .134 r
.30902 .40217 m .3036 .38668 L .30774 .42707 L p F P
0 g
s
0 .044 .586 r
.40226 .62968 m .39177 .61894 L .36953 .58963 L p F P
0 g
s
.824 .804 .832 r
.43182 .62477 m .45038 .60888 L .47359 .63171 L p F P
0 g
s
0 0 .058 r
.3054 .3743 m .3036 .38668 L .30477 .35106 L p F P
0 g
s
0 0 .058 r
.30477 .35106 m .30666 .3353 L .3054 .3743 L p F P
0 g
s
.991 .747 .381 r
.81243 .43573 m .82097 .47737 L .81391 .4824 L p F P
0 g
s
.993 .793 .419 r
.816 .52028 m .81391 .4824 L .82097 .47737 L p F P
0 g
s
.975 .673 .306 r
.80153 .38674 m .78366 .34318 L .8024 .3812 L closepath p F P
0 g
s
.701 .388 .444 r
.35764 .32314 m .33323 .32108 L .33986 .28866 L p F P
0 g
s
.701 .388 .444 r
.33986 .28866 m .36355 .29259 L .35764 .32314 L p F P
0 g
s
.795 .972 .676 r
.62082 .15804 m .60785 .17753 L .62073 .1706 L p F P
0 g
s
.795 .972 .676 r
.62073 .1706 m .6343 .15102 L .62082 .15804 L p F P
0 g
s
.966 .643 .278 r
.77704 .30265 m .78366 .34318 L .77295 .29825 L closepath p F P
0 g
s
.774 .46 .456 r
.3886 .331 m .35764 .32314 L .36355 .29259 L p F P
0 g
s
.934 .558 .198 r
.74693 .25146 m .72669 .21234 L .7358 .21366 L p F P
0 g
s
.934 .558 .198 r
.7358 .21366 m .75311 .25205 L .74693 .25146 L p F P
0 g
s
.397 0 0 r
.73786 .57954 m .75956 .58713 L .77529 .58716 L p F P
0 g
s
.167 .705 .783 r
.79294 .58484 m .77529 .58716 L .75956 .58713 L p F P
0 g
s
0 0 .472 r
.60246 .4497 m .62114 .47291 L .63287 .48901 L p F P
0 g
s
0 0 .535 r
.62114 .47291 m .60246 .4497 L .59544 .43742 L p F P
0 g
s
0 0 .188 r
.57793 .35469 m .57617 .3779 L .57477 .3642 L p F P
0 g
s
0 0 .188 r
.57477 .3642 m .57562 .33228 L .57793 .35469 L p F P
0 g
s
.869 .715 .688 r
.50407 .49933 m .47653 .53018 L .46105 .50182 L p F P
0 g
s
.869 .715 .688 r
.46105 .50182 m .49271 .47816 L .50407 .49933 L p F P
0 g
s
.619 .075 0 r
.71273 .5627 m .68479 .53783 L .67102 .52992 L p F P
0 g
s
.702 .18 0 r
.64425 .50037 m .67102 .52992 L .68479 .53783 L p F P
0 g
s
.37 .805 .639 r
.6365 .14912 m .62082 .15804 L .6343 .15102 L p F P
0 g
s
.37 .805 .639 r
.6343 .15102 m .64987 .14217 L .6365 .14912 L p F P
0 g
s
.976 .676 .315 r
.79976 .39031 m .78366 .34318 L .80153 .38674 L closepath p F P
0 g
s
.981 .702 .324 r
.81243 .43573 m .79976 .39031 L .80153 .38674 L p F P
0 g
s
.832 .587 .569 r
.42511 .37168 m .46591 .38163 L .46898 .40496 L p F P
0 g
s
.831 .555 .521 r
.46591 .38163 m .42511 .37168 L .42504 .34393 L p F P
0 g
s
.985 .711 .351 r
.79976 .39031 m .81243 .43573 L .80745 .43887 L p F P
0 g
s
.991 .747 .381 r
.81391 .4824 m .80745 .43887 L .81243 .43573 L p F P
0 g
s
.967 .644 .284 r
.77295 .29825 m .78366 .34318 L .76928 .29592 L closepath p F P
0 g
s
.873 .751 .725 r
.49304 .55362 m .47094 .58477 L .45069 .55668 L p F P
0 g
s
.873 .751 .725 r
.45069 .55668 m .47653 .53018 L .49304 .55362 L p F P
0 g
s
.815 .414 0 r
.34762 .54455 m .34887 .5537 L .36953 .58963 L p F P
0 g
s
.804 .44 0 r
.34887 .5537 m .34762 .54455 L .33241 .50992 L p F P
0 g
s
.954 .608 .251 r
.76618 .29581 m .74693 .25146 L .75311 .25205 L p F P
0 g
s
.954 .608 .251 r
.75311 .25205 m .76928 .29592 L .76618 .29581 L p F P
0 g
s
.882 .858 .407 r
.58917 .22198 m .58276 .25721 L .58977 .24416 L p F P
0 g
s
.882 .858 .407 r
.58977 .24416 m .59757 .2067 L .58917 .22198 L p F P
0 g
s
.768 .997 .844 r
.80566 .57259 m .79294 .58484 L .77733 .58477 L p F P
0 g
s
.167 .705 .783 r
.75956 .58713 m .77733 .58477 L .79294 .58484 L p F P
0 g
s
.846 .563 .024 r
.31703 .47002 m .3205 .47327 L .31257 .43667 L p F P
0 g
s
.846 .563 .024 r
.31257 .43667 m .30774 .42707 L .31703 .47002 L p F P
0 g
s
.572 .073 0 r
.67102 .52992 m .64425 .50037 L .63287 .48901 L p F P
0 g
s
.811 .538 .525 r
.3886 .331 m .42504 .34393 L .42511 .37168 L p F P
0 g
s
0 0 .535 r
.59544 .43742 m .60969 .45279 L .62114 .47291 L p F P
0 g
s
0 0 .544 r
.60969 .45279 m .59544 .43742 L .58901 .42336 L p F P
0 g
s
.799 .725 .194 r
.5789 .27693 m .57594 .31316 L .57883 .29823 L p F P
0 g
s
.799 .725 .194 r
.57883 .29823 m .58276 .25721 L .5789 .27693 L p F P
0 g
s
0 0 .337 r
.58279 .37926 m .57912 .39283 L .57617 .3779 L p F P
0 g
s
0 0 .337 r
.57617 .3779 m .57793 .35469 L .58279 .37926 L p F P
0 g
s
.37 .571 .916 r
.41568 .63176 m .40226 .62968 L .37792 .59757 L p F P
0 g
s
0 .044 .586 r
.36953 .58963 m .37792 .59757 L .40226 .62968 L p F P
0 g
s
.37 0 0 r
.65469 .15111 m .6365 .14912 L .64987 .14217 L p F P
0 g
s
.37 0 0 r
.64987 .14217 m .66729 .14435 L .65469 .15111 L p F P
0 g
s
.959 .947 .685 r
.81333 .55078 m .80566 .57259 L .79081 .57229 L p F P
0 g
s
.768 .997 .844 r
.77733 .58477 m .79081 .57229 L .80566 .57259 L p F P
0 g
s
.19 .039 .433 r
.31493 .36567 m .3054 .3743 L .30666 .3353 L p F P
0 g
s
.19 .039 .433 r
.30666 .3353 m .31612 .32516 L .31493 .36567 L p F P
0 g
s
.855 .681 .666 r
.49271 .47816 m .46105 .50182 L .44749 .47 L p F P
0 g
s
.855 .681 .666 r
.44749 .47 m .48274 .45454 L .49271 .47816 L p F P
0 g
s
.978 .679 .324 r
.79716 .39172 m .78366 .34318 L .79976 .39031 L closepath p F P
0 g
s
.985 .711 .351 r
.80745 .43887 m .79716 .39172 L .79976 .39031 L p F P
0 g
s
0 0 .544 r
.58901 .42336 m .59911 .42965 L .60969 .45279 L p F P
0 g
s
0 0 .511 r
.59911 .42965 m .58901 .42336 L .58347 .40825 L p F P
0 g
s
.837 .619 .607 r
.42902 .40308 m .46898 .40496 L .47469 .4297 L p F P
0 g
s
.832 .587 .569 r
.46898 .40496 m .42902 .40308 L .42511 .37168 L p F P
0 g
s
.804 .44 0 r
.33241 .50992 m .33102 .51306 L .34887 .5537 L p F P
0 g
s
.813 .491 0 r
.33102 .51306 m .33241 .50992 L .3205 .47327 L p F P
0 g
s
0 0 .443 r
.58998 .4047 m .58347 .40825 L .57912 .39283 L p F P
0 g
s
0 0 .443 r
.57912 .39283 m .58279 .37926 L .58998 .4047 L p F P
0 g
s
.813 .491 0 r
.3205 .47327 m .31703 .47002 L .33102 .51306 L p F P
0 g
s
.968 .646 .292 r
.76928 .29592 m .78366 .34318 L .76618 .29581 L closepath p F P
0 g
s
0 0 .511 r
.58347 .40825 m .58998 .4047 L .59911 .42965 L p F P
0 g
s
.738 .226 0 r
.67501 .16378 m .65469 .15111 L .66729 .14435 L p F P
0 g
s
.738 .226 0 r
.66729 .14435 m .68622 .15735 L .67501 .16378 L p F P
0 g
s
.996 .864 .562 r
.816 .52028 m .81333 .55078 L .79984 .55012 L p F P
0 g
s
.959 .947 .685 r
.79081 .57229 m .79984 .55012 L .81333 .55078 L p F P
0 g
s
0 .062 .625 r
.37792 .59757 m .36953 .58963 L .34887 .5537 L p F P
0 g
s
.848 .75 .755 r
.47094 .58477 m .45038 .60888 L .42732 .57748 L p F P
0 g
s
.848 .75 .755 r
.42732 .57748 m .45069 .55668 L .47094 .58477 L p F P
0 g
s
.844 .65 .639 r
.48274 .45454 m .44749 .47 L .43661 .43647 L p F P
0 g
s
.844 .65 .639 r
.43661 .43647 m .47469 .4297 L .48274 .45454 L p F P
0 g
s
.837 .619 .607 r
.47469 .4297 m .43661 .43647 L .42902 .40308 L p F P
0 g
s
0 0 .277 r
.30996 .41867 m .30774 .42707 L .3036 .38668 L p F P
0 g
s
0 0 .277 r
.3036 .38668 m .3054 .3743 L .30996 .41867 L p F P
0 g
s
.451 0 0 r
.73786 .57954 m .71273 .5627 L .69643 .55348 L p F P
0 g
s
.619 .075 0 r
.67102 .52992 m .69643 .55348 L .71273 .5627 L p F P
0 g
s
.811 .538 .525 r
.42511 .37168 m .38834 .36452 L .3886 .331 L p F P
0 g
s
.778 .51 .53 r
.35764 .32314 m .3886 .331 L .38834 .36452 L p F P
0 g
s
1 .801 .48 r
.81391 .4824 m .816 .52028 L .80442 .51924 L p F P
0 g
s
.996 .864 .562 r
.79984 .55012 m .80442 .51924 L .816 .52028 L p F P
0 g
s
.864 .42 .135 r
.69686 .18632 m .67501 .16378 L .68622 .15735 L p F P
0 g
s
.864 .42 .135 r
.68622 .15735 m .70622 .18043 L .69686 .18632 L p F P
0 g
s
.978 .681 .331 r
.79384 .39089 m .78366 .34318 L .79716 .39172 L closepath p F P
0 g
s
.979 .682 .338 r
.78996 .38781 m .78366 .34318 L .79384 .39089 L closepath p F P
0 g
s
.979 .681 .346 r
.78123 .37554 m .78366 .34318 L .78569 .38262 L closepath p F P
0 g
s
.978 .679 .348 r
.77681 .36691 m .78366 .34318 L .78123 .37554 L closepath p F P
0 g
s
.978 .677 .348 r
.77263 .35713 m .78366 .34318 L .77681 .36691 L closepath p F P
0 g
s
.977 .674 .347 r
.76891 .34669 m .78366 .34318 L .77263 .35713 L closepath p F P
0 g
s
.976 .67 .343 r
.76584 .3361 m .78366 .34318 L .76891 .34669 L closepath p F P
0 g
s
.975 .667 .339 r
.76356 .32588 m .78366 .34318 L .76584 .3361 L closepath p F P
0 g
s
.973 .663 .333 r
.76218 .31655 m .78366 .34318 L .76356 .32588 L closepath p F P
0 g
s
.972 .659 .325 r
.76176 .30854 m .78366 .34318 L .76218 .31655 L closepath p F P
0 g
s
.971 .655 .317 r
.76233 .30224 m .78366 .34318 L .76176 .30854 L closepath p F P
0 g
s
.97 .652 .309 r
.76383 .29794 m .78366 .34318 L .76233 .30224 L closepath p F P
0 g
s
.969 .649 .3 r
.76618 .29581 m .78366 .34318 L .76383 .29794 L closepath p F P
0 g
s
.979 .682 .343 r
.78569 .38262 m .78366 .34318 L .78996 .38781 L closepath p F P
0 g
s
.69 .715 .868 r
.43182 .62477 m .41568 .63176 L .39049 .59832 L p F P
0 g
s
.37 .571 .916 r
.37792 .59757 m .39049 .59832 L .41568 .63176 L p F P
0 g
s
.995 .754 .421 r
.80745 .43887 m .81391 .4824 L .80471 .48112 L p F P
0 g
s
1 .801 .48 r
.80442 .51924 m .80471 .48112 L .81391 .4824 L p F P
0 g
s
.987 .716 .374 r
.79716 .39172 m .80745 .43887 L .80104 .43762 L p F P
0 g
s
.987 .716 .374 r
.80104 .43762 m .79384 .39089 L .79716 .39172 L p F P
0 g
s
.783 .844 .386 r
.59853 .19431 m .58917 .22198 L .59757 .2067 L p F P
0 g
s
.783 .844 .386 r
.59757 .2067 m .60785 .17753 L .59853 .19431 L p F P
0 g
s
.995 .754 .421 r
.80471 .48112 m .80104 .43762 L .80745 .43887 L p F P
0 g
s
.915 .518 .206 r
.71952 .21739 m .69686 .18632 L .70622 .18043 L p F P
0 g
s
.915 .518 .206 r
.70622 .18043 m .72669 .21234 L .71952 .21739 L p F P
0 g
s
.958 .617 .278 r
.74693 .25146 m .76618 .29581 L .76383 .29794 L p F P
0 g
s
.576 .341 .523 r
.33225 .36116 m .31493 .36567 L .31612 .32516 L p F P
0 g
s
.576 .341 .523 r
.31612 .32516 m .33323 .32108 L .33225 .36116 L p F P
0 g
s
.854 .712 .705 r
.47653 .53018 m .45069 .55668 L .43172 .52244 L p F P
0 g
s
.854 .712 .705 r
.43172 .52244 m .46105 .50182 L .47653 .53018 L p F P
0 g
s
.942 .576 .249 r
.74214 .25528 m .71952 .21739 L .72669 .21234 L p F P
0 g
s
.942 .576 .249 r
.72669 .21234 m .74693 .25146 L .74214 .25528 L p F P
0 g
s
.958 .617 .278 r
.76383 .29794 m .74214 .25528 L .74693 .25146 L p F P
0 g
s
.8 .744 .801 r
.45038 .60888 m .43182 .62477 L .40707 .59157 L p F P
0 g
s
.8 .744 .801 r
.40707 .59157 m .42732 .57748 L .45038 .60888 L p F P
0 g
s
.814 .574 .576 r
.38834 .36452 m .42511 .37168 L .42902 .40308 L p F P
0 g
s
.69 .715 .868 r
.39049 .59832 m .40707 .59157 L .43182 .62477 L p F P
0 g
s
.572 .073 0 r
.63287 .48901 m .65592 .5149 L .67102 .52992 L p F P
0 g
s
0 .006 .552 r
.65592 .5149 m .63287 .48901 L .62114 .47291 L p F P
0 g
s
.778 .51 .53 r
.38834 .36452 m .35699 .36085 L .35764 .32314 L p F P
0 g
s
.715 .456 .533 r
.33323 .32108 m .35764 .32314 L .35699 .36085 L p F P
0 g
s
0 0 .043 r
.57849 .30253 m .57562 .33228 L .57594 .31316 L p F P
0 g
s
0 0 .043 r
.57594 .31316 m .5789 .27693 L .57849 .30253 L p F P
0 g
s
.715 .456 .533 r
.35699 .36085 m .33225 .36116 L .33323 .32108 L p F P
0 g
s
.988 .717 .392 r
.79384 .39089 m .80104 .43762 L .79345 .43194 L p F P
0 g
s
.988 .717 .392 r
.79345 .43194 m .78996 .38781 L .79384 .39089 L p F P
0 g
s
0 .053 .551 r
.69643 .55348 m .67102 .52992 L .65592 .5149 L p F P
0 g
s
.961 .626 .305 r
.74214 .25528 m .76383 .29794 L .76233 .30224 L p F P
0 g
s
.451 0 0 r
.69643 .55348 m .71986 .5694 L .73786 .57954 L p F P
0 g
s
0 .444 .794 r
.75956 .58713 m .73786 .57954 L .71986 .5694 L p F P
0 g
s
0 .062 .625 r
.34887 .5537 m .35525 .55808 L .37792 .59757 L p F P
0 g
s
0 .033 .603 r
.35525 .55808 m .34887 .5537 L .33102 .51306 L p F P
0 g
s
.709 .685 .144 r
.58456 .24552 m .5789 .27693 L .58276 .25721 L p F P
0 g
s
.709 .685 .144 r
.58276 .25721 m .58917 .22198 L .58456 .24552 L p F P
0 g
s
0 0 .434 r
.32022 .46594 m .31703 .47002 L .30774 .42707 L p F P
0 g
s
0 0 .434 r
.30774 .42707 m .30996 .41867 L .32022 .46594 L p F P
0 g
s
.404 .519 .86 r
.39049 .59832 m .37792 .59757 L .35525 .55808 L p F P
0 g
s
0 0 0 r
.61111 .1756 m .59853 .19431 L .60785 .17753 L p F P
0 g
s
0 0 0 r
.60785 .17753 m .62082 .15804 L .61111 .1756 L p F P
0 g
s
.839 .676 .681 r
.46105 .50182 m .43172 .52244 L .41514 .48387 L p F P
0 g
s
.839 .676 .681 r
.41514 .48387 m .44749 .47 L .46105 .50182 L p F P
0 g
s
.297 .199 .571 r
.31976 .41185 m .30996 .41867 L .3054 .3743 L p F P
0 g
s
.297 .199 .571 r
.3054 .3743 m .31493 .36567 L .31976 .41185 L p F P
0 g
s
.819 .608 .617 r
.39283 .40259 m .42902 .40308 L .43661 .43647 L p F P
0 g
s
.814 .574 .576 r
.42902 .40308 m .39283 .40259 L .38834 .36452 L p F P
0 g
s
.828 .706 .73 r
.45069 .55668 m .42732 .57748 L .40572 .53902 L p F P
0 g
s
.828 .706 .73 r
.40572 .53902 m .43172 .52244 L .45069 .55668 L p F P
0 g
s
.987 .715 .406 r
.78996 .38781 m .79345 .43194 L .78503 .422 L p F P
0 g
s
.987 .715 .406 r
.78503 .422 m .78569 .38262 L .78996 .38781 L p F P
0 g
s
.994 .754 .451 r
.80104 .43762 m .80471 .48112 L .79374 .47338 L p F P
0 g
s
.994 .754 .451 r
.79374 .47338 m .79345 .43194 L .80104 .43762 L p F P
0 g
s
.964 .637 .33 r
.73901 .26342 m .76233 .30224 L .76176 .30854 L p F P
0 g
s
.961 .626 .305 r
.76233 .30224 m .73901 .26342 L .74214 .25528 L p F P
0 g
s
.783 .552 .586 r
.35699 .36085 m .38834 .36452 L .39283 .40259 L p F P
0 g
s
0 .006 .552 r
.62114 .47291 m .64024 .4933 L .65592 .5149 L p F P
0 g
s
0 .042 .607 r
.64024 .4933 m .62114 .47291 L .60969 .45279 L p F P
0 g
s
0 .033 .603 r
.33102 .51306 m .33562 .51335 L .35525 .55808 L p F P
0 g
s
0 0 .539 r
.33562 .51335 m .33102 .51306 L .31703 .47002 L p F P
0 g
s
.947 .594 .297 r
.71952 .21739 m .74214 .25528 L .73901 .26342 L p F P
0 g
s
0 0 .539 r
.31703 .47002 m .32022 .46594 L .33562 .51335 L p F P
0 g
s
.442 .82 .991 r
.77733 .58477 m .75956 .58713 L .74073 .57644 L p F P
0 g
s
0 .444 .794 r
.71986 .5694 m .74073 .57644 L .75956 .58713 L p F P
0 g
s
0 0 .245 r
.58165 .33278 m .57793 .35469 L .57562 .33228 L p F P
0 g
s
0 0 .245 r
.57562 .33228 m .57849 .30253 L .58165 .33278 L p F P
0 g
s
.827 .642 .651 r
.44749 .47 m .41514 .48387 L .40192 .44314 L p F P
0 g
s
.827 .642 .651 r
.40192 .44314 m .43661 .43647 L .44749 .47 L p F P
0 g
s
.819 .608 .617 r
.43661 .43647 m .40192 .44314 L .39283 .40259 L p F P
0 g
s
.028 0 0 r
.62693 .16678 m .61111 .1756 L .62082 .15804 L p F P
0 g
s
.028 0 0 r
.62082 .15804 m .6365 .14912 L .62693 .16678 L p F P
0 g
s
.678 .655 .82 r
.40707 .59157 m .39049 .59832 L .36696 .55717 L p F P
0 g
s
.404 .519 .86 r
.35525 .55808 m .36696 .55717 L .39049 .59832 L p F P
0 g
s
.996 .796 .521 r
.80471 .48112 m .80442 .51924 L .79052 .50999 L p F P
0 g
s
.996 .796 .521 r
.79052 .50999 m .79374 .47338 L .80471 .48112 L p F P
0 g
s
.984 .711 .414 r
.78569 .38262 m .78503 .422 L .77619 .40821 L p F P
0 g
s
.984 .711 .414 r
.77619 .40821 m .78123 .37554 L .78569 .38262 L p F P
0 g
s
.966 .647 .353 r
.73774 .2756 m .76176 .30854 L .76218 .31655 L p F P
0 g
s
.964 .637 .33 r
.76176 .30854 m .73774 .2756 L .73901 .26342 L p F P
0 g
s
.78 .693 .767 r
.42732 .57748 m .40707 .59157 L .38392 .55076 L p F P
0 g
s
.78 .693 .767 r
.38392 .55076 m .40572 .53902 L .42732 .57748 L p F P
0 g
s
.607 .424 .608 r
.33718 .40685 m .31976 .41185 L .31493 .36567 L p F P
0 g
s
.607 .424 .608 r
.31493 .36567 m .33225 .36116 L .33718 .40685 L p F P
0 g
s
.819 .945 .906 r
.79081 .57229 m .77733 .58477 L .75855 .57387 L p F P
0 g
s
.442 .82 .991 r
.74073 .57644 m .75855 .57387 L .77733 .58477 L p F P
0 g
s
.947 .594 .297 r
.73901 .26342 m .71472 .22878 L .71952 .21739 L p F P
0 g
s
.924 .55 .284 r
.69686 .18632 m .71952 .21739 L .71472 .22878 L p F P
0 g
s
.783 .552 .586 r
.39283 .40259 m .36182 .40378 L .35699 .36085 L p F P
0 g
s
.727 .511 .598 r
.33225 .36116 m .35699 .36085 L .36182 .40378 L p F P
0 g
s
.678 .655 .82 r
.36696 .55717 m .38392 .55076 L .40707 .59157 L p F P
0 g
s
.988 .847 .613 r
.80442 .51924 m .79984 .55012 L .7836 .53989 L p F P
0 g
s
.988 .847 .613 r
.7836 .53989 m .79052 .50999 L .80442 .51924 L p F P
0 g
s
0 .258 .732 r
.71986 .5694 m .69643 .55348 L .67839 .53551 L p F P
0 g
s
0 .053 .551 r
.65592 .5149 m .67839 .53551 L .69643 .55348 L p F P
0 g
s
0 .042 .607 r
.60969 .45279 m .62481 .46611 L .64024 .4933 L p F P
0 g
s
0 .037 .607 r
.62481 .46611 m .60969 .45279 L .59911 .42965 L p F P
0 g
s
.552 .083 .094 r
.64578 .16822 m .62693 .16678 L .6365 .14912 L p F P
0 g
s
.552 .083 .094 r
.6365 .14912 m .65469 .15111 L .64578 .16822 L p F P
0 g
s
.409 .46 .802 r
.36696 .55717 m .35525 .55808 L .33562 .51335 L p F P
0 g
s
.951 .907 .741 r
.79984 .55012 m .79081 .57229 L .77292 .56153 L p F P
0 g
s
.819 .945 .906 r
.75855 .57387 m .77292 .56153 L .79081 .57229 L p F P
0 g
s
.727 .511 .598 r
.36182 .40378 m .33718 .40685 L .33225 .36116 L p F P
0 g
s
0 0 .395 r
.58829 .36612 m .58279 .37926 L .57793 .35469 L p F P
0 g
s
0 0 .395 r
.57793 .35469 m .58165 .33278 L .58829 .36612 L p F P
0 g
s
.982 .705 .418 r
.78123 .37554 m .77619 .40821 L .76738 .3912 L p F P
0 g
s
.982 .705 .418 r
.76738 .3912 m .77681 .36691 L .78123 .37554 L p F P
0 g
s
.359 .309 .666 r
.33049 .4611 m .32022 .46594 L .30996 .41867 L p F P
0 g
s
.359 .309 .666 r
.30996 .41867 m .31976 .41185 L .33049 .4611 L p F P
0 g
s
.951 .907 .741 r
.77292 .56153 m .7836 .53989 L .79984 .55012 L p F P
0 g
s
.968 .658 .373 r
.73842 .29127 m .76218 .31655 L .76356 .32588 L p F P
0 g
s
.966 .647 .353 r
.76218 .31655 m .73842 .29127 L .73774 .2756 L p F P
0 g
s
.812 .666 .702 r
.43172 .52244 m .40572 .53902 L .38689 .49555 L p F P
0 g
s
.812 .666 .702 r
.38689 .49555 m .41514 .48387 L .43172 .52244 L p F P
0 g
s
.924 .55 .284 r
.71472 .22878 m .69045 .20029 L .69686 .18632 L p F P
0 g
s
.88 .478 .259 r
.67501 .16378 m .69686 .18632 L .69045 .20029 L p F P
0 g
s
0 0 0 r
.59344 .22056 m .58456 .24552 L .58917 .22198 L p F P
0 g
s
0 0 0 r
.58917 .22198 m .59853 .19431 L .59344 .22056 L p F P
0 g
s
.79 .591 .631 r
.36182 .40378 m .39283 .40259 L .40192 .44314 L p F P
0 g
s
0 .135 .668 r
.67839 .53551 m .65592 .5149 L .64024 .4933 L p F P
0 g
s
.786 .348 .208 r
.66719 .17966 m .64578 .16822 L .65469 .15111 L p F P
0 g
s
.786 .348 .208 r
.65469 .15111 m .67501 .16378 L .66719 .17966 L p F P
0 g
s
.99 .748 .471 r
.79345 .43194 m .79374 .47338 L .78149 .45933 L p F P
0 g
s
.99 .748 .471 r
.78149 .45933 m .78503 .422 L .79345 .43194 L p F P
0 g
s
.88 .478 .259 r
.69045 .20029 m .66719 .17966 L .67501 .16378 L p F P
0 g
s
0 0 .121 r
.58412 .27642 m .57849 .30253 L .5789 .27693 L p F P
0 g
s
0 0 .121 r
.5789 .27693 m .58456 .24552 L .58412 .27642 L p F P
0 g
s
.95 .612 .34 r
.71472 .22878 m .73901 .26342 L .73774 .2756 L p F P
0 g
s
.979 .697 .418 r
.77681 .36691 m .76738 .3912 L .75905 .37182 L p F P
0 g
s
.979 .697 .418 r
.75905 .37182 m .77263 .35713 L .77681 .36691 L p F P
0 g
s
.97 .668 .39 r
.74105 .30971 m .76356 .32588 L .76584 .3361 L p F P
0 g
s
.968 .658 .373 r
.76356 .32588 m .74105 .30971 L .73842 .29127 L p F P
0 g
s
0 .037 .607 r
.59911 .42965 m .61049 .43469 L .62481 .46611 L p F P
0 g
s
0 0 .569 r
.61049 .43469 m .59911 .42965 L .58998 .4047 L p F P
0 g
s
0 0 .5 r
.59808 .40073 m .58998 .4047 L .58279 .37926 L p F P
0 g
s
0 0 .5 r
.58279 .37926 m .58829 .36612 L .59808 .40073 L p F P
0 g
s
.976 .688 .412 r
.77263 .35713 m .75905 .37182 L .75164 .35105 L p F P
0 g
s
.976 .688 .412 r
.75164 .35105 m .76891 .34669 L .77263 .35713 L p F P
0 g
s
.973 .679 .403 r
.74553 .32998 m .76584 .3361 L .76891 .34669 L p F P
0 g
s
.97 .668 .39 r
.76584 .3361 m .74553 .32998 L .74105 .30971 L p F P
0 g
s
.409 .46 .802 r
.33562 .51335 m .34654 .51053 L .36696 .55717 L p F P
0 g
s
.394 .392 .738 r
.34654 .51053 m .33562 .51335 L .32022 .46594 L p F P
0 g
s
0 0 .569 r
.58998 .4047 m .59808 .40073 L .61049 .43469 L p F P
0 g
s
.8 .628 .669 r
.41514 .48387 m .38689 .49555 L .37196 .44957 L p F P
0 g
s
.8 .628 .669 r
.37196 .44957 m .40192 .44314 L .41514 .48387 L p F P
0 g
s
.394 .392 .738 r
.32022 .46594 m .33049 .4611 L .34654 .51053 L p F P
0 g
s
.973 .679 .403 r
.76891 .34669 m .75164 .35105 L .74553 .32998 L p F P
0 g
s
.79 .591 .631 r
.40192 .44314 m .37196 .44957 L .36182 .40378 L p F P
0 g
s
.663 .599 .773 r
.38392 .55076 m .36696 .55717 L .34654 .51053 L p F P
0 g
s
.764 .646 .732 r
.40572 .53902 m .38392 .55076 L .36377 .50454 L p F P
0 g
s
.764 .646 .732 r
.36377 .50454 m .38689 .49555 L .40572 .53902 L p F P
0 g
s
.63 .489 .672 r
.34788 .4556 m .33049 .4611 L .31976 .41185 L p F P
0 g
s
.63 .489 .672 r
.31976 .41185 m .33718 .40685 L .34788 .4556 L p F P
0 g
s
.738 .558 .65 r
.33718 .40685 m .36182 .40378 L .37196 .44957 L p F P
0 g
s
.142 .537 .921 r
.74073 .57644 m .71986 .5694 L .69979 .54929 L p F P
0 g
s
0 .258 .732 r
.67839 .53551 m .69979 .54929 L .71986 .5694 L p F P
0 g
s
.663 .599 .773 r
.34654 .51053 m .36377 .50454 L .38392 .55076 L p F P
0 g
s
.738 .558 .65 r
.37196 .44957 m .34788 .4556 L .33718 .40685 L p F P
0 g
s
.986 .782 .545 r
.79374 .47338 m .79052 .50999 L .77493 .49265 L p F P
0 g
s
.986 .782 .545 r
.77493 .49265 m .78149 .45933 L .79374 .47338 L p F P
0 g
s
.984 .738 .483 r
.78503 .422 m .78149 .45933 L .76855 .43953 L p F P
0 g
s
.984 .738 .483 r
.76855 .43953 m .77619 .40821 L .78503 .422 L p F P
0 g
s
0 0 .085 r
.60588 .20337 m .59344 .22056 L .59853 .19431 L p F P
0 g
s
0 0 .085 r
.59853 .19431 m .61111 .1756 L .60588 .20337 L p F P
0 g
s
.952 .63 .378 r
.71261 .24616 m .73774 .2756 L .73842 .29127 L p F P
0 g
s
.95 .612 .34 r
.73774 .2756 m .71261 .24616 L .71472 .22878 L p F P
0 g
s
.927 .578 .349 r
.69045 .20029 m .71472 .22878 L .71261 .24616 L p F P
0 g
s
.75 .602 .693 r
.38689 .49555 m .36377 .50454 L .34788 .4556 L p F P
0 g
s
.75 .602 .693 r
.34788 .4556 m .37196 .44957 L .38689 .49555 L p F P
0 g
s
.648 .546 .725 r
.36377 .50454 m .34654 .51053 L .33049 .4611 L p F P
0 g
s
.648 .546 .725 r
.33049 .4611 m .34788 .4556 L .36377 .50454 L p F P
0 g
s
0 .135 .668 r
.64024 .4933 m .65951 .50939 L .67839 .53551 L p F P
0 g
s
0 .164 .703 r
.65951 .50939 m .64024 .4933 L .62481 .46611 L p F P
0 g
s
0 0 .327 r
.58804 .31319 m .58165 .33278 L .57849 .30253 L p F P
0 g
s
0 0 .327 r
.57849 .30253 m .58412 .27642 L .58804 .31319 L p F P
0 g
s
.547 .773 .982 r
.75855 .57387 m .74073 .57644 L .71962 .55505 L p F P
0 g
s
.142 .537 .921 r
.69979 .54929 m .71962 .55505 L .74073 .57644 L p F P
0 g
s
0 .32 .807 r
.69979 .54929 m .67839 .53551 L .65951 .50939 L p F P
0 g
s
.97 .818 .637 r
.79052 .50999 m .7836 .53989 L .76532 .52013 L p F P
0 g
s
.97 .818 .637 r
.76532 .52013 m .77493 .49265 L .79052 .50999 L p F P
0 g
s
0 0 .23 r
.59307 .25531 m .58412 .27642 L .58456 .24552 L p F P
0 g
s
0 0 .23 r
.58456 .24552 m .59344 .22056 L .59307 .25531 L p F P
0 g
s
.977 .726 .486 r
.77619 .40821 m .76855 .43953 L .75561 .41486 L p F P
0 g
s
.977 .726 .486 r
.75561 .41486 m .76738 .3912 L .77619 .40821 L p F P
0 g
s
.281 0 .24 r
.62189 .19485 m .60588 .20337 L .61111 .1756 L p F P
0 g
s
.281 0 .24 r
.61111 .1756 m .62693 .16678 L .62189 .19485 L p F P
0 g
s
.927 .578 .349 r
.71261 .24616 m .68746 .22199 L .69045 .20029 L p F P
0 g
s
.885 .524 .355 r
.66719 .17966 m .69045 .20029 L .68746 .22199 L p F P
0 g
s
.955 .647 .411 r
.71339 .2688 m .73842 .29127 L .74105 .30971 L p F P
0 g
s
.952 .63 .378 r
.73842 .29127 m .71339 .2688 L .71261 .24616 L p F P
0 g
s
.808 .859 .887 r
.77292 .56153 m .75855 .57387 L .73741 .55209 L p F P
0 g
s
.547 .773 .982 r
.71962 .55505 m .73741 .55209 L .75855 .57387 L p F P
0 g
s
.925 .852 .752 r
.7836 .53989 m .77292 .56153 L .75275 .54029 L p F P
0 g
s
.925 .852 .752 r
.75275 .54029 m .76532 .52013 L .7836 .53989 L p F P
0 g
s
.808 .859 .887 r
.73741 .55209 m .75275 .54029 L .77292 .56153 L p F P
0 g
s
0 .164 .703 r
.62481 .46611 m .64082 .47627 L .65951 .50939 L p F P
0 g
s
0 .15 .688 r
.64082 .47627 m .62481 .46611 L .61049 .43469 L p F P
0 g
s
.885 .524 .355 r
.68746 .22199 m .66335 .20464 L .66719 .17966 L p F P
0 g
s
.803 .431 .353 r
.64578 .16822 m .66719 .17966 L .66335 .20464 L p F P
0 g
s
.628 .26 .327 r
.64123 .19534 m .62189 .19485 L .62693 .16678 L p F P
0 g
s
.628 .26 .327 r
.62693 .16678 m .64578 .16822 L .64123 .19534 L p F P
0 g
s
0 0 .473 r
.5962 .3539 m .58829 .36612 L .58165 .33278 L p F P
0 g
s
0 0 .473 r
.58165 .33278 m .58804 .31319 L .5962 .3539 L p F P
0 g
s
.974 .763 .557 r
.78149 .45933 m .77493 .49265 L .7584 .46781 L p F P
0 g
s
.974 .763 .557 r
.7584 .46781 m .76855 .43953 L .78149 .45933 L p F P
0 g
s
.971 .712 .483 r
.76738 .3912 m .75561 .41486 L .74336 .38656 L p F P
0 g
s
.971 .712 .483 r
.74336 .38656 m .75905 .37182 L .76738 .3912 L p F P
0 g
s
.957 .664 .437 r
.71709 .29563 m .74105 .30971 L .74553 .32998 L p F P
0 g
s
.955 .647 .411 r
.74105 .30971 m .71709 .29563 L .71339 .2688 L p F P
0 g
s
.929 .604 .404 r
.68746 .22199 m .71261 .24616 L .71339 .2688 L p F P
0 g
s
.803 .431 .353 r
.66335 .20464 m .64123 .19534 L .64578 .16822 L p F P
0 g
s
.965 .696 .474 r
.75905 .37182 m .74336 .38656 L .73247 .35615 L p F P
0 g
s
.965 .696 .474 r
.73247 .35615 m .75164 .35105 L .75905 .37182 L p F P
0 g
s
.961 .68 .458 r
.72355 .32527 m .74553 .32998 L .75164 .35105 L p F P
0 g
s
.957 .664 .437 r
.74553 .32998 m .72355 .32527 L .71709 .29563 L p F P
0 g
s
0 .15 .688 r
.61049 .43469 m .62338 .43786 L .64082 .47627 L p F P
0 g
s
0 .104 .644 r
.62338 .43786 m .61049 .43469 L .59808 .40073 L p F P
0 g
s
.961 .68 .458 r
.75164 .35105 m .73247 .35615 L .72355 .32527 L p F P
0 g
s
0 .027 .573 r
.60821 .39628 m .59808 .40073 L .58829 .36612 L p F P
0 g
s
0 .027 .573 r
.58829 .36612 m .5962 .3539 L .60821 .39628 L p F P
0 g
s
.273 .535 .917 r
.71962 .55505 m .69979 .54929 L .67865 .51982 L p F P
0 g
s
0 .32 .807 r
.65951 .50939 m .67865 .51982 L .69979 .54929 L p F P
0 g
s
.058 0 .354 r
.60565 .24033 m .59307 .25531 L .59344 .22056 L p F P
0 g
s
.058 0 .354 r
.59344 .22056 m .60588 .20337 L .60565 .24033 L p F P
0 g
s
0 .104 .644 r
.59808 .40073 m .60821 .39628 L .62338 .43786 L p F P
0 g
s
.065 .325 .805 r
.67865 .51982 m .65951 .50939 L .64082 .47627 L p F P
0 g
s
0 0 .426 r
.59761 .2969 m .58804 .31319 L .58412 .27642 L p F P
0 g
s
0 0 .426 r
.58412 .27642 m .59307 .25531 L .59761 .2969 L p F P
0 g
s
.95 .786 .643 r
.77493 .49265 m .76532 .52013 L .7459 .49148 L p F P
0 g
s
.95 .786 .643 r
.7459 .49148 m .7584 .46781 L .77493 .49265 L p F P
0 g
s
.963 .742 .558 r
.76855 .43953 m .7584 .46781 L .74181 .4366 L p F P
0 g
s
.963 .742 .558 r
.74181 .4366 m .75561 .41486 L .76855 .43953 L p F P
0 g
s
.929 .604 .404 r
.71339 .2688 m .68818 .25053 L .68746 .22199 L p F P
0 g
s
.887 .563 .43 r
.66335 .20464 m .68746 .22199 L .68818 .25053 L p F P
0 g
s
.93 .628 .449 r
.68818 .25053 m .71339 .2688 L .71709 .29563 L p F P
0 g
s
.579 .704 .928 r
.73741 .55209 m .71962 .55505 L .69728 .52357 L p F P
0 g
s
.273 .535 .917 r
.67865 .51982 m .69728 .52357 L .71962 .55505 L p F P
0 g
s
.408 .172 .441 r
.62189 .23228 m .60565 .24033 L .60588 .20337 L p F P
0 g
s
.408 .172 .441 r
.60588 .20337 m .62189 .19485 L .62189 .23228 L p F P
0 g
s
.897 .798 .743 r
.76532 .52013 m .75275 .54029 L .73131 .50922 L p F P
0 g
s
.897 .798 .743 r
.73131 .50922 m .7459 .49148 L .76532 .52013 L p F P
0 g
s
.887 .563 .43 r
.68818 .25053 m .66388 .23776 L .66335 .20464 L p F P
0 g
s
.809 .493 .454 r
.64123 .19534 m .66335 .20464 L .66388 .23776 L p F P
0 g
s
.952 .72 .55 r
.75561 .41486 m .74181 .4366 L .7261 .4006 L p F P
0 g
s
.952 .72 .55 r
.7261 .4006 m .74336 .38656 L .75561 .41486 L p F P
0 g
s
.787 .783 .85 r
.75275 .54029 m .73741 .55209 L .71497 .52007 L p F P
0 g
s
.579 .704 .928 r
.69728 .52357 m .71497 .52007 L .73741 .55209 L p F P
0 g
s
.065 .325 .805 r
.64082 .47627 m .6576 .48229 L .67865 .51982 L p F P
0 g
s
.115 .296 .77 r
.6576 .48229 m .64082 .47627 L .62338 .43786 L p F P
0 g
s
.933 .652 .485 r
.69268 .28459 m .71709 .29563 L .72355 .32527 L p F P
0 g
s
.93 .628 .449 r
.71709 .29563 m .69268 .28459 L .68818 .25053 L p F P
0 g
s
.787 .783 .85 r
.71497 .52007 m .73131 .50922 L .75275 .54029 L p F P
0 g
s
.032 .06 .557 r
.60696 .34312 m .5962 .3539 L .58804 .31319 L p F P
0 g
s
.032 .06 .557 r
.58804 .31319 m .59761 .2969 L .60696 .34312 L p F P
0 g
s
.664 .371 .466 r
.6415 .23147 m .62189 .23228 L .62189 .19485 L p F P
0 g
s
.664 .371 .466 r
.62189 .19485 m .64123 .19534 L .6415 .23147 L p F P
0 g
s
.809 .493 .454 r
.66388 .23776 m .6415 .23147 L .64123 .19534 L p F P
0 g
s
.334 .5 .873 r
.69728 .52357 m .67865 .51982 L .6576 .48229 L p F P
0 g
s
.2 .105 .516 r
.61065 .28474 m .59761 .2969 L .59307 .25531 L p F P
0 g
s
.2 .105 .516 r
.59307 .25531 m .60565 .24033 L .61065 .28474 L p F P
0 g
s
.932 .752 .637 r
.7584 .46781 m .7459 .49148 L .72638 .45522 L p F P
0 g
s
.932 .752 .637 r
.72638 .45522 m .74181 .4366 L .7584 .46781 L p F P
0 g
s
.944 .697 .536 r
.74336 .38656 m .7261 .4006 L .71216 .3618 L p F P
0 g
s
.944 .697 .536 r
.71216 .3618 m .73247 .35615 L .74336 .38656 L p F P
0 g
s
.937 .675 .514 r
.70081 .32238 m .72355 .32527 L .73247 .35615 L p F P
0 g
s
.933 .652 .485 r
.72355 .32527 m .70081 .32238 L .69268 .28459 L p F P
0 g
s
.888 .596 .488 r
.66388 .23776 m .68818 .25053 L .69268 .28459 L p F P
0 g
s
.937 .675 .514 r
.73247 .35615 m .71216 .3618 L .70081 .32238 L p F P
0 g
s
.115 .296 .77 r
.62338 .43786 m .63786 .43863 L .6576 .48229 L p F P
0 g
s
.124 .244 .717 r
.63786 .43863 m .62338 .43786 L .60821 .39628 L p F P
0 g
s
.097 .168 .648 r
.62064 .39131 m .60821 .39628 L .5962 .3539 L p F P
0 g
s
.097 .168 .648 r
.5962 .3539 m .60696 .34312 L .62064 .39131 L p F P
0 g
s
.124 .244 .717 r
.60821 .39628 m .62064 .39131 L .63786 .43863 L p F P
0 g
s
.585 .64 .872 r
.71497 .52007 m .69728 .52357 L .67492 .4834 L p F P
0 g
s
.334 .5 .873 r
.6576 .48229 m .67492 .4834 L .69728 .52357 L p F P
0 g
s
.873 .75 .723 r
.7459 .49148 m .73131 .50922 L .70976 .46967 L p F P
0 g
s
.873 .75 .723 r
.70976 .46967 m .72638 .45522 L .7459 .49148 L p F P
0 g
s
.478 .301 .562 r
.62715 .27732 m .61065 .28474 L .60565 .24033 L p F P
0 g
s
.478 .301 .562 r
.60565 .24033 m .62189 .23228 L .62715 .27732 L p F P
0 g
s
.888 .596 .488 r
.69268 .28459 m .66891 .27746 L .66388 .23776 L p F P
0 g
s
.814 .542 .527 r
.6415 .23147 m .66388 .23776 L .66891 .27746 L p F P
0 g
s
.917 .72 .622 r
.74181 .4366 m .72638 .45522 L .70789 .41321 L p F P
0 g
s
.917 .72 .622 r
.70789 .41321 m .7261 .4006 L .74181 .4366 L p F P
0 g
s
.891 .628 .534 r
.66891 .27746 m .69268 .28459 L .70081 .32238 L p F P
0 g
s
.357 .452 .821 r
.67492 .4834 m .6576 .48229 L .63786 .43863 L p F P
0 g
s
.283 .232 .622 r
.62076 .33421 m .60696 .34312 L .59761 .2969 L p F P
0 g
s
.283 .232 .622 r
.59761 .2969 m .61065 .28474 L .62076 .33421 L p F P
0 g
s
.766 .719 .81 r
.73131 .50922 m .71497 .52007 L .69245 .4792 L p F P
0 g
s
.585 .64 .872 r
.67492 .4834 m .69245 .4792 L .71497 .52007 L p F P
0 g
s
.766 .719 .81 r
.69245 .4792 m .70976 .46967 L .73131 .50922 L p F P
0 g
s
.685 .449 .558 r
.64678 .27491 m .62715 .27732 L .62189 .23228 L p F P
0 g
s
.685 .449 .558 r
.62189 .23228 m .6415 .23147 L .64678 .27491 L p F P
0 g
s
.814 .542 .527 r
.66891 .27746 m .64678 .27491 L .6415 .23147 L p F P
0 g
s
.905 .689 .6 r
.7261 .4006 m .70789 .41321 L .69153 .3678 L p F P
0 g
s
.905 .689 .6 r
.69153 .3678 m .71216 .3618 L .7261 .4006 L p F P
0 g
s
.896 .658 .571 r
.67829 .32165 m .70081 .32238 L .71216 .3618 L p F P
0 g
s
.891 .628 .534 r
.70081 .32238 m .67829 .32165 L .66891 .27746 L p F P
0 g
s
.357 .452 .821 r
.63786 .43863 m .65389 .4366 L .67492 .4834 L p F P
0 g
s
.354 .394 .764 r
.65389 .4366 m .63786 .43863 L .62064 .39131 L p F P
0 g
s
.896 .658 .571 r
.71216 .3618 m .69153 .3678 L .67829 .32165 L p F P
0 g
s
.331 .323 .7 r
.63545 .38586 m .62064 .39131 L .60696 .34312 L p F P
0 g
s
.331 .323 .7 r
.60696 .34312 m .62076 .33421 L .63545 .38586 L p F P
0 g
s
.854 .705 .697 r
.72638 .45522 m .70976 .46967 L .68938 .42371 L p F P
0 g
s
.854 .705 .697 r
.68938 .42371 m .70789 .41321 L .72638 .45522 L p F P
0 g
s
.58 .581 .818 r
.69245 .4792 m .67492 .4834 L .65389 .4366 L p F P
0 g
s
.819 .585 .584 r
.64678 .27491 m .66891 .27746 L .67829 .32165 L p F P
0 g
s
.354 .394 .764 r
.62064 .39131 m .63545 .38586 L .65389 .4366 L p F P
0 g
s
.521 .391 .645 r
.63753 .32754 m .62076 .33421 L .61065 .28474 L p F P
0 g
s
.521 .391 .645 r
.61065 .28474 m .62715 .27732 L .63753 .32754 L p F P
0 g
s
.747 .664 .769 r
.70976 .46967 m .69245 .4792 L .6712 .43161 L p F P
0 g
s
.747 .664 .769 r
.6712 .43161 m .68938 .42371 L .70976 .46967 L p F P
0 g
s
.58 .581 .818 r
.65389 .4366 m .6712 .43161 L .69245 .4792 L p F P
0 g
s
.819 .585 .584 r
.67829 .32165 m .65692 .32334 L .64678 .27491 L p F P
0 g
s
.701 .51 .626 r
.62715 .27732 m .64678 .27491 L .65692 .32334 L p F P
0 g
s
.701 .51 .626 r
.65692 .32334 m .63753 .32754 L .62715 .27732 L p F P
0 g
s
.839 .664 .666 r
.70789 .41321 m .68938 .42371 L .6714 .37395 L p F P
0 g
s
.839 .664 .666 r
.6714 .37395 m .69153 .3678 L .70789 .41321 L p F P
0 g
s
.827 .625 .629 r
.65692 .32334 m .67829 .32165 L .69153 .3678 L p F P
0 g
s
.568 .524 .766 r
.6712 .43161 m .65389 .4366 L .63545 .38586 L p F P
0 g
s
.549 .462 .71 r
.65251 .38003 m .63545 .38586 L .62076 .33421 L p F P
0 g
s
.549 .462 .71 r
.62076 .33421 m .63753 .32754 L .65251 .38003 L p F P
0 g
s
.827 .625 .629 r
.69153 .3678 m .6714 .37395 L .65692 .32334 L p F P
0 g
s
.568 .524 .766 r
.63545 .38586 m .65251 .38003 L .6712 .43161 L p F P
0 g
s
.731 .613 .726 r
.68938 .42371 m .6712 .43161 L .65251 .38003 L p F P
0 g
s
.731 .613 .726 r
.65251 .38003 m .6714 .37395 L .68938 .42371 L p F P
0 g
s
.716 .563 .68 r
.63753 .32754 m .65692 .32334 L .6714 .37395 L p F P
0 g
s
.716 .563 .68 r
.6714 .37395 m .65251 .38003 L .63753 .32754 L p F P
0 g
s
.25 Mabswid
.68233 0 m
.95161 .42327 L
s
.95161 .42327 m
1 .77748 L
s
1 .77748 m
.70492 .38796 L
s
.70492 .38796 m
.68233 0 L
s
.05861 .25171 m
0 .62211 L
s
0 .62211 m
.70492 .38796 L
s
.70492 .38796 m
.68233 0 L
s
.68233 0 m
.05861 .25171 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.33.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics3D", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[12]= ",
 CellTags->"S5.33.1"]
}, Open  ]],

Cell[TextData[{
 "Here is the same object with the ",
 Cell[BoxData[
  FormBox[
   StyleBox["x",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4,
  ColumnWidths->Automatic}],
 " shadow moved to the opposite face of the bounding box. "
}], "MathCaption",
 CellTags->{"S5.33.1", "1.19"}],

Cell[CellGroupData[{

Cell["\<\
Shadow[dbell, ZShadow -> False,
                 XShadowPosition -> 1]\
\>", "Input",
 CellLabel->"In[13]:= ",
 CellTags->"S5.33.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .92733 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-6.03359e-17 1.05057 -0.0129365 1.05057 [
[ 0 0 0 0 ]
[ 1 .92733 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.05861 .25171 m
0 .62211 L
s
0 .62211 m
.39809 .92733 L
s
.39809 .92733 m
.40984 .59229 L
s
.40984 .59229 m
.05861 .25171 L
s
.68233 0 m
.95161 .42327 L
s
.95161 .42327 m
1 .77748 L
s
1 .77748 m
.70492 .38796 L
s
.70492 .38796 m
.68233 0 L
s
.05861 .25171 m
0 .62211 L
s
0 .62211 m
.70492 .38796 L
s
.70492 .38796 m
.68233 0 L
s
.68233 0 m
.05861 .25171 L
s
.40984 .59229 m
.95161 .42327 L
s
.95161 .42327 m
1 .77748 L
s
1 .77748 m
.39809 .92733 L
s
.39809 .92733 m
.40984 .59229 L
s
0 0 m
1 0 L
1 .92733 L
0 .92733 L
closepath
clip
newpath
.5 Mabswid
.573 .366 .563 r
.45647 .576 m .44552 .58452 L .44544 .58783 L p F P
0 g
s
.573 .366 .563 r
.44552 .58452 m .43584 .59923 L .43575 .60229 L p F P
0 g
s
.573 .366 .563 r
.43575 .60229 m .44544 .58783 L .44552 .58452 L p F P
0 g
s
.573 .366 .563 r
.4564 .57943 m .44544 .58783 L .44552 .58452 L p F P
0 g
s
.573 .366 .563 r
.44552 .58452 m .45647 .576 L .4564 .57943 L p F P
0 g
s
.573 .366 .563 r
.43584 .59923 m .44552 .58452 L .44544 .58783 L p F P
0 g
s
.573 .366 .563 r
.46864 .57391 m .45647 .576 L .4564 .57943 L p F P
0 g
s
.573 .366 .563 r
.44544 .58783 m .4564 .57943 L .45647 .576 L p F P
0 g
s
.573 .366 .563 r
.46858 .57731 m .4564 .57943 L .45647 .576 L p F P
0 g
s
.573 .366 .563 r
.45647 .576 m .46864 .57391 L .46858 .57731 L p F P
0 g
s
.573 .366 .563 r
.4564 .57943 m .44544 .58783 L .4452 .59766 L p F P
0 g
s
.573 .366 .563 r
.44544 .58783 m .43575 .60229 L .43551 .61135 L p F P
0 g
s
.573 .366 .563 r
.43551 .61135 m .4452 .59766 L .44544 .58783 L p F P
0 g
s
.573 .366 .563 r
.45619 .58959 m .4452 .59766 L .44544 .58783 L p F P
0 g
s
.573 .366 .563 r
.44544 .58783 m .4564 .57943 L .45619 .58959 L p F P
0 g
s
.573 .366 .563 r
.43575 .60229 m .44544 .58783 L .4452 .59766 L p F P
0 g
s
.573 .366 .563 r
.44544 .58783 m .43575 .60229 L .43584 .59923 L p F P
0 g
s
.573 .366 .563 r
.46841 .58737 m .45619 .58959 L .4564 .57943 L p F P
0 g
s
.573 .366 .563 r
.4564 .57943 m .46858 .57731 L .46841 .58737 L p F P
0 g
s
.573 .366 .563 r
.4564 .57943 m .46858 .57731 L .46864 .57391 L p F P
0 g
s
.573 .366 .563 r
.46858 .57731 m .4564 .57943 L .45619 .58959 L p F P
0 g
s
.573 .366 .563 r
.4452 .59766 m .45619 .58959 L .4564 .57943 L p F P
0 g
s
.573 .366 .563 r
.43584 .59923 m .42748 .61968 L .42741 .62235 L p F P
0 g
s
.573 .366 .563 r
.42741 .62235 m .43575 .60229 L .43584 .59923 L p F P
0 g
s
.573 .366 .563 r
.42748 .61968 m .43584 .59923 L .43575 .60229 L p F P
0 g
s
.573 .366 .563 r
.43575 .60229 m .42741 .62235 L .42717 .63024 L p F P
0 g
s
.573 .366 .563 r
.42717 .63024 m .43551 .61135 L .43575 .60229 L p F P
0 g
s
.573 .366 .563 r
.4452 .59766 m .43551 .61135 L .43575 .60229 L p F P
0 g
s
.573 .366 .563 r
.42741 .62235 m .43575 .60229 L .43551 .61135 L p F P
0 g
s
.573 .366 .563 r
.43575 .60229 m .42741 .62235 L .42748 .61968 L p F P
0 g
s
.573 .366 .563 r
.48197 .57825 m .46864 .57391 L .46858 .57731 L p F P
0 g
s
.573 .366 .563 r
.48193 .58147 m .46858 .57731 L .46864 .57391 L p F P
0 g
s
.573 .366 .563 r
.46864 .57391 m .48197 .57825 L .48193 .58147 L p F P
0 g
s
.573 .366 .563 r
.45619 .58959 m .4452 .59766 L .44481 .61365 L p F P
0 g
s
.573 .366 .563 r
.4452 .59766 m .43551 .61135 L .43511 .6261 L p F P
0 g
s
.573 .366 .563 r
.43511 .6261 m .44481 .61365 L .4452 .59766 L p F P
0 g
s
.573 .366 .563 r
.45584 .60614 m .44481 .61365 L .4452 .59766 L p F P
0 g
s
.573 .366 .563 r
.4452 .59766 m .45619 .58959 L .45584 .60614 L p F P
0 g
s
.573 .366 .563 r
.43551 .61135 m .4452 .59766 L .44481 .61365 L p F P
0 g
s
.573 .366 .563 r
.46858 .57731 m .48193 .58147 L .48197 .57825 L p F P
0 g
s
.573 .366 .563 r
.48193 .58147 m .46858 .57731 L .46841 .58737 L p F P
0 g
s
.573 .366 .563 r
.45619 .58959 m .46841 .58737 L .46858 .57731 L p F P
0 g
s
.573 .366 .563 r
.4818 .59101 m .46841 .58737 L .46858 .57731 L p F P
0 g
s
.573 .366 .563 r
.46858 .57731 m .48193 .58147 L .4818 .59101 L p F P
0 g
s
.573 .366 .563 r
.46841 .58737 m .45619 .58959 L .45584 .60614 L p F P
0 g
s
.573 .366 .563 r
.44481 .61365 m .45584 .60614 L .45619 .58959 L p F P
0 g
s
.573 .366 .563 r
.46812 .60376 m .45584 .60614 L .45619 .58959 L p F P
0 g
s
.573 .366 .563 r
.45619 .58959 m .46841 .58737 L .46812 .60376 L p F P
0 g
s
.573 .366 .563 r
.43551 .61135 m .42717 .63024 L .4268 .64307 L p F P
0 g
s
.573 .366 .563 r
.4268 .64307 m .43511 .6261 L .43551 .61135 L p F P
0 g
s
.573 .366 .563 r
.44481 .61365 m .43511 .6261 L .43551 .61135 L p F P
0 g
s
.573 .366 .563 r
.42717 .63024 m .43551 .61135 L .43511 .6261 L p F P
0 g
s
.573 .366 .563 r
.43551 .61135 m .42717 .63024 L .42741 .62235 L p F P
0 g
s
.573 .366 .563 r
.42748 .61968 m .42055 .64519 L .42048 .64733 L p F P
0 g
s
.573 .366 .563 r
.42048 .64733 m .42741 .62235 L .42748 .61968 L p F P
0 g
s
.573 .366 .563 r
.42055 .64519 m .42748 .61968 L .42741 .62235 L p F P
0 g
s
.573 .366 .563 r
.42741 .62235 m .42048 .64733 L .42028 .65368 L p F P
0 g
s
.573 .366 .563 r
.42028 .65368 m .42717 .63024 L .42741 .62235 L p F P
0 g
s
.573 .366 .563 r
.42048 .64733 m .42741 .62235 L .42717 .63024 L p F P
0 g
s
.573 .366 .563 r
.42741 .62235 m .42048 .64733 L .42055 .64519 L p F P
0 g
s
.573 .366 .563 r
.46841 .58737 m .4818 .59101 L .48193 .58147 L p F P
0 g
s
.573 .366 .563 r
.4818 .59101 m .46841 .58737 L .46812 .60376 L p F P
0 g
s
.573 .366 .563 r
.45584 .60614 m .46812 .60376 L .46841 .58737 L p F P
0 g
s
.573 .366 .563 r
.4816 .60652 m .46812 .60376 L .46841 .58737 L p F P
0 g
s
.573 .366 .563 r
.46841 .58737 m .4818 .59101 L .4816 .60652 L p F P
0 g
s
.573 .366 .563 r
.49642 .5888 m .48197 .57825 L .48193 .58147 L p F P
0 g
s
.573 .366 .563 r
.4964 .5917 m .48193 .58147 L .48197 .57825 L p F P
0 g
s
.573 .366 .563 r
.48197 .57825 m .49642 .5888 L .4964 .5917 L p F P
0 g
s
.573 .366 .563 r
.45584 .60614 m .44481 .61365 L .44429 .63523 L p F P
0 g
s
.573 .366 .563 r
.44481 .61365 m .43511 .6261 L .43457 .64597 L p F P
0 g
s
.573 .366 .563 r
.43457 .64597 m .44429 .63523 L .44481 .61365 L p F P
0 g
s
.573 .366 .563 r
.45537 .62848 m .44429 .63523 L .44481 .61365 L p F P
0 g
s
.573 .366 .563 r
.44481 .61365 m .45584 .60614 L .45537 .62848 L p F P
0 g
s
.573 .366 .563 r
.43511 .6261 m .44481 .61365 L .44429 .63523 L p F P
0 g
s
.573 .366 .563 r
.42717 .63024 m .42028 .65368 L .41996 .66399 L p F P
0 g
s
.573 .366 .563 r
.41996 .66399 m .4268 .64307 L .42717 .63024 L p F P
0 g
s
.573 .366 .563 r
.43511 .6261 m .4268 .64307 L .42717 .63024 L p F P
0 g
s
.573 .366 .563 r
.42028 .65368 m .42717 .63024 L .4268 .64307 L p F P
0 g
s
.573 .366 .563 r
.42717 .63024 m .42028 .65368 L .42048 .64733 L p F P
0 g
s
.573 .366 .563 r
.48193 .58147 m .4964 .5917 L .49642 .5888 L p F P
0 g
s
.573 .366 .563 r
.4964 .5917 m .48193 .58147 L .4818 .59101 L p F P
0 g
s
.573 .366 .563 r
.49632 .60028 m .4818 .59101 L .48193 .58147 L p F P
0 g
s
.573 .366 .563 r
.48193 .58147 m .4964 .5917 L .49632 .60028 L p F P
0 g
s
.573 .366 .563 r
.46812 .60376 m .45584 .60614 L .45537 .62848 L p F P
0 g
s
.573 .366 .563 r
.44429 .63523 m .45537 .62848 L .45584 .60614 L p F P
0 g
s
.573 .366 .563 r
.46774 .62588 m .45537 .62848 L .45584 .60614 L p F P
0 g
s
.573 .366 .563 r
.45584 .60614 m .46812 .60376 L .46774 .62588 L p F P
0 g
s
.573 .366 .563 r
.43511 .6261 m .4268 .64307 L .42629 .66034 L p F P
0 g
s
.573 .366 .563 r
.42629 .66034 m .43457 .64597 L .43511 .6261 L p F P
0 g
s
.573 .366 .563 r
.44429 .63523 m .43457 .64597 L .43511 .6261 L p F P
0 g
s
.573 .366 .563 r
.4268 .64307 m .43511 .6261 L .43457 .64597 L p F P
0 g
s
.573 .366 .563 r
.42055 .64519 m .41513 .67484 L .41508 .67635 L p F P
0 g
s
.573 .366 .563 r
.41508 .67635 m .42048 .64733 L .42055 .64519 L p F P
0 g
s
.573 .366 .563 r
.41513 .67484 m .42055 .64519 L .42048 .64733 L p F P
0 g
s
.573 .366 .563 r
.4818 .59101 m .49632 .60028 L .4964 .5917 L p F P
0 g
s
.573 .366 .563 r
.49632 .60028 m .4818 .59101 L .4816 .60652 L p F P
0 g
s
.573 .366 .563 r
.46812 .60376 m .4816 .60652 L .4818 .59101 L p F P
0 g
s
.573 .366 .563 r
.4962 .61423 m .4816 .60652 L .4818 .59101 L p F P
0 g
s
.573 .366 .563 r
.4818 .59101 m .49632 .60028 L .4962 .61423 L p F P
0 g
s
.573 .366 .563 r
.42048 .64733 m .41508 .67635 L .41493 .68082 L p F P
0 g
s
.573 .366 .563 r
.41493 .68082 m .42028 .65368 L .42048 .64733 L p F P
0 g
s
.573 .366 .563 r
.41508 .67635 m .42048 .64733 L .42028 .65368 L p F P
0 g
s
.573 .366 .563 r
.42048 .64733 m .41508 .67635 L .41513 .67484 L p F P
0 g
s
.573 .366 .563 r
.4816 .60652 m .46812 .60376 L .46774 .62588 L p F P
0 g
s
.573 .366 .563 r
.45537 .62848 m .46774 .62588 L .46812 .60376 L p F P
0 g
s
.573 .366 .563 r
.48132 .62745 m .46774 .62588 L .46812 .60376 L p F P
0 g
s
.573 .366 .563 r
.46812 .60376 m .4816 .60652 L .48132 .62745 L p F P
0 g
s
.573 .366 .563 r
.4268 .64307 m .41996 .66399 L .41953 .67783 L p F P
0 g
s
.573 .366 .563 r
.41953 .67783 m .42629 .66034 L .4268 .64307 L p F P
0 g
s
.573 .366 .563 r
.43457 .64597 m .42629 .66034 L .4268 .64307 L p F P
0 g
s
.573 .366 .563 r
.41996 .66399 m .4268 .64307 L .42629 .66034 L p F P
0 g
s
.573 .366 .563 r
.4268 .64307 m .41996 .66399 L .42028 .65368 L p F P
0 g
s
.573 .366 .563 r
.42028 .65368 m .41493 .68082 L .41469 .68807 L p F P
0 g
s
.573 .366 .563 r
.41469 .68807 m .41996 .66399 L .42028 .65368 L p F P
0 g
s
.573 .366 .563 r
.41493 .68082 m .42028 .65368 L .41996 .66399 L p F P
0 g
s
.573 .366 .563 r
.42028 .65368 m .41493 .68082 L .41508 .67635 L p F P
0 g
s
.573 .366 .563 r
.45537 .62848 m .44429 .63523 L .44365 .66158 L p F P
0 g
s
.573 .366 .563 r
.44429 .63523 m .43457 .64597 L .43391 .6702 L p F P
0 g
s
.573 .366 .563 r
.43391 .6702 m .44365 .66158 L .44429 .63523 L p F P
0 g
s
.573 .366 .563 r
.4548 .65576 m .44365 .66158 L .44429 .63523 L p F P
0 g
s
.573 .366 .563 r
.44429 .63523 m .45537 .62848 L .4548 .65576 L p F P
0 g
s
.573 .366 .563 r
.43457 .64597 m .44429 .63523 L .44365 .66158 L p F P
0 g
s
.573 .366 .563 r
.51195 .6051 m .49642 .5888 L .4964 .5917 L p F P
0 g
s
.573 .366 .563 r
.51194 .60754 m .4964 .5917 L .49642 .5888 L p F P
0 g
s
.573 .366 .563 r
.49642 .5888 m .51195 .6051 L .51194 .60754 L p F P
0 g
s
.573 .366 .563 r
.43457 .64597 m .42629 .66034 L .42567 .68135 L p F P
0 g
s
.573 .366 .563 r
.42567 .68135 m .43391 .6702 L .43457 .64597 L p F P
0 g
s
.573 .366 .563 r
.44365 .66158 m .43391 .6702 L .43457 .64597 L p F P
0 g
s
.573 .366 .563 r
.42629 .66034 m .43457 .64597 L .43391 .6702 L p F P
0 g
s
.573 .366 .563 r
.46774 .62588 m .45537 .62848 L .4548 .65576 L p F P
0 g
s
.573 .366 .563 r
.44365 .66158 m .4548 .65576 L .45537 .62848 L p F P
0 g
s
.573 .366 .563 r
.46727 .65289 m .4548 .65576 L .45537 .62848 L p F P
0 g
s
.573 .366 .563 r
.45537 .62848 m .46774 .62588 L .46727 .65289 L p F P
0 g
s
.573 .366 .563 r
.4964 .5917 m .51194 .60754 L .51195 .6051 L p F P
0 g
s
.573 .366 .563 r
.51194 .60754 m .4964 .5917 L .49632 .60028 L p F P
0 g
s
.573 .366 .563 r
.51191 .61477 m .49632 .60028 L .4964 .5917 L p F P
0 g
s
.573 .366 .563 r
.4964 .5917 m .51194 .60754 L .51191 .61477 L p F P
0 g
s
.573 .366 .563 r
.4816 .60652 m .4962 .61423 L .49632 .60028 L p F P
0 g
s
.573 .366 .563 r
.4962 .61423 m .4816 .60652 L .48132 .62745 L p F P
0 g
s
.573 .366 .563 r
.46774 .62588 m .48132 .62745 L .4816 .60652 L p F P
0 g
s
.573 .366 .563 r
.49604 .63303 m .48132 .62745 L .4816 .60652 L p F P
0 g
s
.573 .366 .563 r
.4816 .60652 m .4962 .61423 L .49604 .63303 L p F P
0 g
s
.573 .366 .563 r
.41996 .66399 m .41469 .68807 L .41438 .69779 L p F P
0 g
s
.573 .366 .563 r
.41438 .69779 m .41953 .67783 L .41996 .66399 L p F P
0 g
s
.573 .366 .563 r
.42629 .66034 m .41953 .67783 L .41996 .66399 L p F P
0 g
s
.573 .366 .563 r
.41469 .68807 m .41996 .66399 L .41953 .67783 L p F P
0 g
s
.573 .366 .563 r
.41996 .66399 m .41469 .68807 L .41493 .68082 L p F P
0 g
s
.573 .366 .563 r
.42629 .66034 m .41953 .67783 L .419 .69464 L p F P
0 g
s
.573 .366 .563 r
.419 .69464 m .42567 .68135 L .42629 .66034 L p F P
0 g
s
.573 .366 .563 r
.43391 .6702 m .42567 .68135 L .42629 .66034 L p F P
0 g
s
.573 .366 .563 r
.41953 .67783 m .42629 .66034 L .42567 .68135 L p F P
0 g
s
.573 .366 .563 r
.48132 .62745 m .46774 .62588 L .46727 .65289 L p F P
0 g
s
.573 .366 .563 r
.4548 .65576 m .46727 .65289 L .46774 .62588 L p F P
0 g
s
.573 .366 .563 r
.48098 .65299 m .46727 .65289 L .46774 .62588 L p F P
0 g
s
.573 .366 .563 r
.46774 .62588 m .48132 .62745 L .48098 .65299 L p F P
0 g
s
.573 .366 .563 r
.49632 .60028 m .51191 .61477 L .51194 .60754 L p F P
0 g
s
.573 .366 .563 r
.51191 .61477 m .49632 .60028 L .4962 .61423 L p F P
0 g
s
.573 .366 .563 r
.51186 .62651 m .4962 .61423 L .49632 .60028 L p F P
0 g
s
.573 .366 .563 r
.49632 .60028 m .51191 .61477 L .51186 .62651 L p F P
0 g
s
.573 .366 .563 r
.41513 .67484 m .41132 .70749 L .41129 .70828 L p F P
0 g
s
.573 .366 .563 r
.41129 .70828 m .41508 .67635 L .41513 .67484 L p F P
0 g
s
.573 .366 .563 r
.41132 .70749 m .41513 .67484 L .41508 .67635 L p F P
0 g
s
.573 .366 .563 r
.41508 .67635 m .41129 .70828 L .41122 .71061 L p F P
0 g
s
.573 .366 .563 r
.41122 .71061 m .41493 .68082 L .41508 .67635 L p F P
0 g
s
.573 .366 .563 r
.41129 .70828 m .41508 .67635 L .41493 .68082 L p F P
0 g
s
.573 .366 .563 r
.41508 .67635 m .41129 .70828 L .41132 .70749 L p F P
0 g
s
.573 .366 .563 r
.41493 .68082 m .41122 .71061 L .41109 .71438 L p F P
0 g
s
.573 .366 .563 r
.41109 .71438 m .41469 .68807 L .41493 .68082 L p F P
0 g
s
.573 .366 .563 r
.41122 .71061 m .41493 .68082 L .41469 .68807 L p F P
0 g
s
.573 .366 .563 r
.41493 .68082 m .41122 .71061 L .41129 .70828 L p F P
0 g
s
.573 .366 .563 r
.41953 .67783 m .41438 .69779 L .41399 .70956 L p F P
0 g
s
.573 .366 .563 r
.41399 .70956 m .419 .69464 L .41953 .67783 L p F P
0 g
s
.573 .366 .563 r
.42567 .68135 m .419 .69464 L .41953 .67783 L p F P
0 g
s
.573 .366 .563 r
.41438 .69779 m .41953 .67783 L .419 .69464 L p F P
0 g
s
.573 .366 .563 r
.41953 .67783 m .41438 .69779 L .41469 .68807 L p F P
0 g
s
.573 .366 .563 r
.44365 .66158 m .43391 .6702 L .43316 .69782 L p F P
0 g
s
.573 .366 .563 r
.43391 .6702 m .42567 .68135 L .42496 .70526 L p F P
0 g
s
.573 .366 .563 r
.42496 .70526 m .43316 .69782 L .43391 .6702 L p F P
0 g
s
.573 .366 .563 r
.44292 .69165 m .43316 .69782 L .43391 .6702 L p F P
0 g
s
.573 .366 .563 r
.43391 .6702 m .44365 .66158 L .44292 .69165 L p F P
0 g
s
.573 .366 .563 r
.42567 .68135 m .43391 .6702 L .43316 .69782 L p F P
0 g
s
.573 .366 .563 r
.41469 .68807 m .41109 .71438 L .41092 .71942 L p F P
0 g
s
.573 .366 .563 r
.41092 .71942 m .41438 .69779 L .41469 .68807 L p F P
0 g
s
.573 .366 .563 r
.41109 .71438 m .41469 .68807 L .41438 .69779 L p F P
0 g
s
.573 .366 .563 r
.41469 .68807 m .41109 .71438 L .41122 .71061 L p F P
0 g
s
.573 .366 .563 r
.4548 .65576 m .44365 .66158 L .44292 .69165 L p F P
0 g
s
.573 .366 .563 r
.43316 .69782 m .44292 .69165 L .44365 .66158 L p F P
0 g
s
.573 .366 .563 r
.45414 .68692 m .44292 .69165 L .44365 .66158 L p F P
0 g
s
.573 .366 .563 r
.44365 .66158 m .4548 .65576 L .45414 .68692 L p F P
0 g
s
.573 .366 .563 r
.48132 .62745 m .49604 .63303 L .4962 .61423 L p F P
0 g
s
.573 .366 .563 r
.49604 .63303 m .48132 .62745 L .48098 .65299 L p F P
0 g
s
.573 .366 .563 r
.46727 .65289 m .48098 .65299 L .48132 .62745 L p F P
0 g
s
.573 .366 .563 r
.49584 .65594 m .48098 .65299 L .48132 .62745 L p F P
0 g
s
.573 .366 .563 r
.48132 .62745 m .49604 .63303 L .49584 .65594 L p F P
0 g
s
.573 .366 .563 r
.4962 .61423 m .51186 .62651 L .51191 .61477 L p F P
0 g
s
.573 .366 .563 r
.51186 .62651 m .4962 .61423 L .49604 .63303 L p F P
0 g
s
.573 .366 .563 r
.5118 .64229 m .49604 .63303 L .4962 .61423 L p F P
0 g
s
.573 .366 .563 r
.4962 .61423 m .51186 .62651 L .5118 .64229 L p F P
0 g
s
.573 .366 .563 r
.42567 .68135 m .419 .69464 L .4184 .71371 L p F P
0 g
s
.573 .366 .563 r
.4184 .71371 m .42496 .70526 L .42567 .68135 L p F P
0 g
s
.573 .366 .563 r
.43316 .69782 m .42496 .70526 L .42567 .68135 L p F P
0 g
s
.573 .366 .563 r
.419 .69464 m .42567 .68135 L .42496 .70526 L p F P
0 g
s
.573 .366 .563 r
.46727 .65289 m .4548 .65576 L .45414 .68692 L p F P
0 g
s
.573 .366 .563 r
.44292 .69165 m .45414 .68692 L .4548 .65576 L p F P
0 g
s
.573 .366 .563 r
.46674 .68374 m .45414 .68692 L .4548 .65576 L p F P
0 g
s
.573 .366 .563 r
.4548 .65576 m .46727 .65289 L .46674 .68374 L p F P
0 g
s
.573 .366 .563 r
.52847 .62645 m .51195 .6051 L .51194 .60754 L p F P
0 g
s
.573 .366 .563 r
.52847 .62831 m .51194 .60754 L .51195 .6051 L p F P
0 g
s
.573 .366 .563 r
.51195 .6051 m .52847 .62645 L .52847 .62831 L p F P
0 g
s
.573 .366 .563 r
.51194 .60754 m .52847 .62831 L .52847 .62645 L p F P
0 g
s
.573 .366 .563 r
.52847 .62831 m .51194 .60754 L .51191 .61477 L p F P
0 g
s
.573 .366 .563 r
.52848 .63382 m .51191 .61477 L .51194 .60754 L p F P
0 g
s
.573 .366 .563 r
.51194 .60754 m .52847 .62831 L .52848 .63382 L p F P
0 g
s
.573 .366 .563 r
.41438 .69779 m .41092 .71942 L .41072 .72551 L p F P
0 g
s
.573 .366 .563 r
.41072 .72551 m .41399 .70956 L .41438 .69779 L p F P
0 g
s
.573 .366 .563 r
.419 .69464 m .41399 .70956 L .41438 .69779 L p F P
0 g
s
.573 .366 .563 r
.41092 .71942 m .41438 .69779 L .41399 .70956 L p F P
0 g
s
.573 .366 .563 r
.41438 .69779 m .41092 .71942 L .41109 .71438 L p F P
0 g
s
.573 .366 .563 r
.419 .69464 m .41399 .70956 L .41356 .72287 L p F P
0 g
s
.573 .366 .563 r
.41356 .72287 m .4184 .71371 L .419 .69464 L p F P
0 g
s
.573 .366 .563 r
.42496 .70526 m .4184 .71371 L .419 .69464 L p F P
0 g
s
.573 .366 .563 r
.41399 .70956 m .419 .69464 L .4184 .71371 L p F P
0 g
s
.573 .366 .563 r
.48098 .65299 m .46727 .65289 L .46674 .68374 L p F P
0 g
s
.573 .366 .563 r
.45414 .68692 m .46674 .68374 L .46727 .65289 L p F P
0 g
s
.573 .366 .563 r
.4806 .68213 m .46674 .68374 L .46727 .65289 L p F P
0 g
s
.573 .366 .563 r
.46727 .65289 m .48098 .65299 L .4806 .68213 L p F P
0 g
s
.573 .366 .563 r
.51191 .61477 m .52848 .63382 L .52847 .62831 L p F P
0 g
s
.573 .366 .563 r
.52848 .63382 m .51191 .61477 L .51186 .62651 L p F P
0 g
s
.573 .366 .563 r
.52849 .64275 m .51186 .62651 L .51191 .61477 L p F P
0 g
s
.573 .366 .563 r
.51191 .61477 m .52848 .63382 L .52849 .64275 L p F P
0 g
s
.573 .366 .563 r
.40925 .74182 m .41129 .70828 L .41132 .70749 L closepath p F P
0 g
s
.573 .366 .563 r
.40925 .74182 m .41132 .70749 L .41129 .70828 L closepath p F P
0 g
s
.573 .366 .563 r
.40925 .74182 m .41122 .71061 L .41129 .70828 L closepath p F P
0 g
s
.573 .366 .563 r
.40925 .74182 m .41129 .70828 L .41122 .71061 L closepath p F P
0 g
s
.573 .366 .563 r
.40925 .74182 m .41109 .71438 L .41122 .71061 L closepath p F P
0 g
s
.573 .366 .563 r
.40925 .74182 m .41122 .71061 L .41109 .71438 L closepath p F P
0 g
s
.573 .366 .563 r
.49604 .63303 m .5118 .64229 L .51186 .62651 L p F P
0 g
s
.573 .366 .563 r
.5118 .64229 m .49604 .63303 L .49584 .65594 L p F P
0 g
s
.573 .366 .563 r
.48098 .65299 m .49584 .65594 L .49604 .63303 L p F P
0 g
s
.573 .366 .563 r
.51172 .6615 m .49584 .65594 L .49604 .63303 L p F P
0 g
s
.573 .366 .563 r
.49604 .63303 m .5118 .64229 L .51172 .6615 L p F P
0 g
s
.573 .366 .563 r
.41399 .70956 m .41072 .72551 L .41049 .73237 L p F P
0 g
s
.573 .366 .563 r
.41049 .73237 m .41356 .72287 L .41399 .70956 L p F P
0 g
s
.573 .366 .563 r
.4184 .71371 m .41356 .72287 L .41399 .70956 L p F P
0 g
s
.573 .366 .563 r
.41072 .72551 m .41399 .70956 L .41356 .72287 L p F P
0 g
s
.573 .366 .563 r
.41399 .70956 m .41072 .72551 L .41092 .71942 L p F P
0 g
s
.573 .366 .563 r
.40925 .74182 m .41092 .71942 L .41109 .71438 L closepath p F P
0 g
s
.573 .366 .563 r
.40925 .74182 m .41109 .71438 L .41092 .71942 L closepath p F P
0 g
s
.573 .366 .563 r
.49584 .65594 m .48098 .65299 L .4806 .68213 L p F P
0 g
s
.573 .366 .563 r
.46674 .68374 m .4806 .68213 L .48098 .65299 L p F P
0 g
s
.573 .366 .563 r
.49561 .68203 m .4806 .68213 L .48098 .65299 L p F P
0 g
s
.573 .366 .563 r
.48098 .65299 m .49584 .65594 L .49561 .68203 L p F P
0 g
s
.573 .366 .563 r
.43316 .69782 m .42496 .70526 L .4242 .73103 L p F P
0 g
s
.573 .366 .563 r
.42496 .70526 m .4184 .71371 L .41776 .73421 L p F P
0 g
s
.573 .366 .563 r
.41776 .73421 m .4242 .73103 L .42496 .70526 L p F P
0 g
s
.573 .366 .563 r
.43235 .72767 m .4242 .73103 L .42496 .70526 L p F P
0 g
s
.573 .366 .563 r
.42496 .70526 m .43316 .69782 L .43235 .72767 L p F P
0 g
s
.573 .366 .563 r
.4184 .71371 m .42496 .70526 L .4242 .73103 L p F P
0 g
s
.573 .366 .563 r
.44292 .69165 m .43316 .69782 L .43235 .72767 L p F P
0 g
s
.573 .366 .563 r
.4242 .73103 m .43235 .72767 L .43316 .69782 L p F P
0 g
s
.573 .366 .563 r
.44213 .72419 m .43235 .72767 L .43316 .69782 L p F P
0 g
s
.573 .366 .563 r
.43316 .69782 m .44292 .69165 L .44213 .72419 L p F P
0 g
s
.573 .366 .563 r
.51186 .62651 m .52849 .64275 L .52848 .63382 L p F P
0 g
s
.573 .366 .563 r
.52849 .64275 m .51186 .62651 L .5118 .64229 L p F P
0 g
s
.573 .366 .563 r
.5285 .65475 m .5118 .64229 L .51186 .62651 L p F P
0 g
s
.573 .366 .563 r
.51186 .62651 m .52849 .64275 L .5285 .65475 L p F P
0 g
s
.573 .366 .563 r
.40925 .74182 m .41072 .72551 L .41092 .71942 L closepath p F P
0 g
s
.573 .366 .563 r
.40925 .74182 m .41092 .71942 L .41072 .72551 L closepath p F P
0 g
s
.573 .366 .563 r
.4184 .71371 m .41356 .72287 L .41309 .73712 L p F P
0 g
s
.573 .366 .563 r
.41309 .73712 m .41776 .73421 L .4184 .71371 L p F P
0 g
s
.573 .366 .563 r
.4242 .73103 m .41776 .73421 L .4184 .71371 L p F P
0 g
s
.573 .366 .563 r
.41356 .72287 m .4184 .71371 L .41776 .73421 L p F P
0 g
s
.573 .366 .563 r
.45414 .68692 m .44292 .69165 L .44213 .72419 L p F P
0 g
s
.573 .366 .563 r
.43235 .72767 m .44213 .72419 L .44292 .69165 L p F P
0 g
s
.573 .366 .563 r
.45343 .72067 m .44213 .72419 L .44292 .69165 L p F P
0 g
s
.573 .366 .563 r
.44292 .69165 m .45414 .68692 L .45343 .72067 L p F P
0 g
s
.573 .366 .563 r
.41356 .72287 m .41049 .73237 L .41024 .73969 L p F P
0 g
s
.573 .366 .563 r
.41024 .73969 m .41309 .73712 L .41356 .72287 L p F P
0 g
s
.573 .366 .563 r
.41776 .73421 m .41309 .73712 L .41356 .72287 L p F P
0 g
s
.573 .366 .563 r
.41049 .73237 m .41356 .72287 L .41309 .73712 L p F P
0 g
s
.573 .366 .563 r
.41356 .72287 m .41049 .73237 L .41072 .72551 L p F P
0 g
s
.573 .366 .563 r
.40925 .74182 m .41049 .73237 L .41072 .72551 L closepath p F P
0 g
s
.573 .366 .563 r
.40925 .74182 m .41072 .72551 L .41049 .73237 L closepath p F P
0 g
s
.573 .366 .563 r
.46674 .68374 m .45414 .68692 L .45343 .72067 L p F P
0 g
s
.573 .366 .563 r
.44213 .72419 m .45343 .72067 L .45414 .68692 L p F P
0 g
s
.573 .366 .563 r
.46616 .71714 m .45343 .72067 L .45414 .68692 L p F P
0 g
s
.573 .366 .563 r
.45414 .68692 m .46674 .68374 L .46616 .71714 L p F P
0 g
s
.573 .366 .563 r
.40925 .74182 m .41024 .73969 L .41049 .73237 L closepath p F P
0 g
s
.573 .366 .563 r
.41309 .73712 m .41024 .73969 L .41049 .73237 L p F P
0 g
s
.573 .366 .563 r
.40925 .74182 m .41049 .73237 L .41024 .73969 L closepath p F P
0 g
s
.573 .366 .563 r
.49584 .65594 m .51172 .6615 L .5118 .64229 L p F P
0 g
s
.573 .366 .563 r
.51172 .6615 m .49584 .65594 L .49561 .68203 L p F P
0 g
s
.573 .366 .563 r
.4806 .68213 m .49561 .68203 L .49584 .65594 L p F P
0 g
s
.573 .366 .563 r
.51163 .68331 m .49561 .68203 L .49584 .65594 L p F P
0 g
s
.573 .366 .563 r
.49584 .65594 m .51172 .6615 L .51163 .68331 L p F P
0 g
s
.573 .366 .563 r
.54591 .65192 m .52847 .62645 L .52847 .62831 L p F P
0 g
s
.573 .366 .563 r
.54591 .65309 m .52847 .62831 L .52847 .62645 L p F P
0 g
s
.573 .366 .563 r
.52847 .62645 m .54591 .65192 L .54591 .65309 L p F P
0 g
s
.573 .366 .563 r
.5118 .64229 m .5285 .65475 L .52849 .64275 L p F P
0 g
s
.573 .366 .563 r
.5285 .65475 m .5118 .64229 L .51172 .6615 L p F P
0 g
s
.573 .366 .563 r
.52851 .6693 m .51172 .6615 L .5118 .64229 L p F P
0 g
s
.573 .366 .563 r
.5118 .64229 m .5285 .65475 L .52851 .6693 L p F P
0 g
s
.573 .366 .563 r
.4806 .68213 m .46674 .68374 L .46616 .71714 L p F P
0 g
s
.573 .366 .563 r
.45343 .72067 m .46616 .71714 L .46674 .68374 L p F P
0 g
s
.573 .366 .563 r
.48018 .71364 m .46616 .71714 L .46674 .68374 L p F P
0 g
s
.573 .366 .563 r
.46674 .68374 m .4806 .68213 L .48018 .71364 L p F P
0 g
s
.573 .366 .563 r
.52847 .62831 m .54591 .65309 L .54591 .65192 L p F P
0 g
s
.573 .366 .563 r
.54591 .65309 m .52847 .62831 L .52848 .63382 L p F P
0 g
s
.573 .366 .563 r
.54593 .65657 m .52848 .63382 L .52847 .62831 L p F P
0 g
s
.573 .366 .563 r
.52847 .62831 m .54591 .65309 L .54593 .65657 L p F P
0 g
s
.573 .366 .563 r
.41309 .73712 m .41024 .73969 L .40999 .74713 L p F P
0 g
s
.573 .366 .563 r
.40925 .74182 m .40999 .74713 L .41024 .73969 L closepath p F P
0 g
s
.573 .366 .563 r
.41262 .75167 m .40999 .74713 L .41024 .73969 L p F P
0 g
s
.573 .366 .563 r
.41024 .73969 m .41309 .73712 L .41262 .75167 L p F P
0 g
s
.573 .366 .563 r
.40925 .74182 m .41024 .73969 L .40999 .74713 L closepath p F P
0 g
s
.573 .366 .563 r
.41776 .73421 m .41309 .73712 L .41262 .75167 L p F P
0 g
s
.573 .366 .563 r
.40999 .74713 m .41262 .75167 L .41309 .73712 L p F P
0 g
s
.573 .366 .563 r
.4171 .7552 m .41262 .75167 L .41309 .73712 L p F P
0 g
s
.573 .366 .563 r
.41309 .73712 m .41776 .73421 L .4171 .7552 L p F P
0 g
s
.573 .366 .563 r
.40925 .74182 m .40975 .75433 L .40999 .74713 L closepath p F P
0 g
s
.573 .366 .563 r
.40925 .74182 m .40953 .76096 L .40975 .75433 L closepath p F P
0 g
s
.573 .366 .563 r
.40925 .74182 m .40934 .76671 L .40953 .76096 L closepath p F P
0 g
s
.573 .366 .563 r
.40925 .74182 m .40918 .77128 L .40934 .76671 L closepath p F P
0 g
s
.573 .366 .563 r
.40925 .74182 m .40908 .77446 L .40918 .77128 L closepath p F P
0 g
s
.573 .366 .563 r
.40925 .74182 m .40902 .77609 L .40908 .77446 L closepath p F P
0 g
s
.573 .366 .563 r
.40925 .74182 m .40908 .77446 L .40902 .77609 L closepath p F P
0 g
s
.573 .366 .563 r
.40925 .74182 m .40918 .77128 L .40908 .77446 L closepath p F P
0 g
s
.573 .366 .563 r
.40925 .74182 m .40934 .76671 L .40918 .77128 L closepath p F P
0 g
s
.573 .366 .563 r
.40925 .74182 m .40953 .76096 L .40934 .76671 L closepath p F P
0 g
s
.573 .366 .563 r
.40925 .74182 m .40975 .75433 L .40953 .76096 L closepath p F P
0 g
s
.573 .366 .563 r
.40925 .74182 m .40999 .74713 L .40975 .75433 L closepath p F P
0 g
s
.573 .366 .563 r
.4242 .73103 m .41776 .73421 L .4171 .7552 L p F P
0 g
s
.573 .366 .563 r
.41262 .75167 m .4171 .7552 L .41776 .73421 L p F P
0 g
s
.573 .366 .563 r
.42342 .7575 m .4171 .7552 L .41776 .73421 L p F P
0 g
s
.573 .366 .563 r
.41776 .73421 m .4242 .73103 L .42342 .7575 L p F P
0 g
s
.573 .366 .563 r
.52848 .63382 m .54593 .65657 L .54591 .65309 L p F P
0 g
s
.573 .366 .563 r
.54593 .65657 m .52848 .63382 L .52849 .64275 L p F P
0 g
s
.573 .366 .563 r
.54597 .6622 m .52849 .64275 L .52848 .63382 L p F P
0 g
s
.573 .366 .563 r
.52848 .63382 m .54593 .65657 L .54597 .6622 L p F P
0 g
s
.573 .366 .563 r
.43235 .72767 m .4242 .73103 L .42342 .7575 L p F P
0 g
s
.573 .366 .563 r
.4171 .7552 m .42342 .7575 L .4242 .73103 L p F P
0 g
s
.573 .366 .563 r
.43152 .7584 m .42342 .7575 L .4242 .73103 L p F P
0 g
s
.573 .366 .563 r
.4242 .73103 m .43235 .72767 L .43152 .7584 L p F P
0 g
s
.573 .366 .563 r
.49561 .68203 m .4806 .68213 L .48018 .71364 L p F P
0 g
s
.573 .366 .563 r
.46616 .71714 m .48018 .71364 L .4806 .68213 L p F P
0 g
s
.573 .366 .563 r
.49536 .71019 m .48018 .71364 L .4806 .68213 L p F P
0 g
s
.573 .366 .563 r
.4806 .68213 m .49561 .68203 L .49536 .71019 L p F P
0 g
s
.573 .366 .563 r
.41262 .75167 m .40999 .74713 L .40975 .75433 L p F P
0 g
s
.573 .366 .563 r
.41215 .76582 m .40975 .75433 L .40999 .74713 L p F P
0 g
s
.573 .366 .563 r
.40999 .74713 m .41262 .75167 L .41215 .76582 L p F P
0 g
s
.573 .366 .563 r
.44213 .72419 m .43235 .72767 L .43152 .7584 L p F P
0 g
s
.573 .366 .563 r
.42342 .7575 m .43152 .7584 L .43235 .72767 L p F P
0 g
s
.573 .366 .563 r
.44131 .75776 m .43152 .7584 L .43235 .72767 L p F P
0 g
s
.573 .366 .563 r
.43235 .72767 m .44213 .72419 L .44131 .75776 L p F P
0 g
s
.573 .366 .563 r
.52849 .64275 m .54597 .6622 L .54593 .65657 L p F P
0 g
s
.573 .366 .563 r
.54597 .6622 m .52849 .64275 L .5285 .65475 L p F P
0 g
s
.573 .366 .563 r
.54602 .66974 m .5285 .65475 L .52849 .64275 L p F P
0 g
s
.573 .366 .563 r
.52849 .64275 m .54597 .6622 L .54602 .66974 L p F P
0 g
s
.573 .366 .563 r
.45343 .72067 m .44213 .72419 L .44131 .75776 L p F P
0 g
s
.573 .366 .563 r
.43152 .7584 m .44131 .75776 L .44213 .72419 L p F P
0 g
s
.573 .366 .563 r
.4527 .7555 m .44131 .75776 L .44213 .72419 L p F P
0 g
s
.573 .366 .563 r
.44213 .72419 m .45343 .72067 L .4527 .7555 L p F P
0 g
s
.573 .366 .563 r
.4171 .7552 m .41262 .75167 L .41215 .76582 L p F P
0 g
s
.573 .366 .563 r
.40975 .75433 m .41215 .76582 L .41262 .75167 L p F P
0 g
s
.573 .366 .563 r
.41646 .7757 m .41215 .76582 L .41262 .75167 L p F P
0 g
s
.573 .366 .563 r
.41262 .75167 m .4171 .7552 L .41646 .7757 L p F P
0 g
s
.573 .366 .563 r
.41215 .76582 m .40975 .75433 L .40953 .76096 L p F P
0 g
s
.573 .366 .563 r
.41173 .77889 m .40953 .76096 L .40975 .75433 L p F P
0 g
s
.573 .366 .563 r
.40975 .75433 m .41215 .76582 L .41173 .77889 L p F P
0 g
s
.573 .366 .563 r
.51172 .6615 m .52851 .6693 L .5285 .65475 L p F P
0 g
s
.573 .366 .563 r
.52851 .6693 m .51172 .6615 L .51163 .68331 L p F P
0 g
s
.573 .366 .563 r
.49561 .68203 m .51163 .68331 L .51172 .6615 L p F P
0 g
s
.573 .366 .563 r
.52853 .68578 m .51163 .68331 L .51172 .6615 L p F P
0 g
s
.573 .366 .563 r
.51172 .6615 m .52851 .6693 L .52853 .68578 L p F P
0 g
s
.573 .366 .563 r
.69156 .51055 m .67837 .51634 L .67804 .50946 L p F P
0 g
s
.573 .366 .563 r
.67804 .50946 m .6912 .50358 L .69156 .51055 L p F P
0 g
s
.573 .366 .563 r
.66396 .52259 m .67804 .50946 L .67837 .51634 L p F P
0 g
s
.573 .366 .563 r
.6912 .50358 m .67804 .50946 L .67837 .51634 L p F P
0 g
s
.573 .366 .563 r
.67804 .50946 m .66396 .52259 L .66424 .5291 L p F P
0 g
s
.573 .366 .563 r
.66424 .5291 m .67837 .51634 L .67804 .50946 L p F P
0 g
s
.573 .366 .563 r
.66396 .52259 m .64903 .5426 L .64925 .54845 L p F P
0 g
s
.573 .366 .563 r
.64925 .54845 m .66424 .5291 L .66396 .52259 L p F P
0 g
s
.573 .366 .563 r
.67837 .51634 m .66424 .5291 L .66396 .52259 L p F P
0 g
s
.573 .366 .563 r
.64903 .5426 m .66396 .52259 L .66424 .5291 L p F P
0 g
s
.573 .366 .563 r
.46616 .71714 m .45343 .72067 L .4527 .7555 L p F P
0 g
s
.573 .366 .563 r
.44131 .75776 m .4527 .7555 L .45343 .72067 L p F P
0 g
s
.573 .366 .563 r
.46556 .75161 m .4527 .7555 L .45343 .72067 L p F P
0 g
s
.573 .366 .563 r
.45343 .72067 m .46616 .71714 L .46556 .75161 L p F P
0 g
s
.573 .366 .563 r
.51163 .68331 m .49561 .68203 L .49536 .71019 L p F P
0 g
s
.573 .366 .563 r
.48018 .71364 m .49536 .71019 L .49561 .68203 L p F P
0 g
s
.573 .366 .563 r
.51154 .7068 m .49536 .71019 L .49561 .68203 L p F P
0 g
s
.573 .366 .563 r
.49561 .68203 m .51163 .68331 L .51154 .7068 L p F P
0 g
s
.573 .366 .563 r
.40953 .76096 m .41173 .77889 L .41215 .76582 L p F P
0 g
s
.573 .366 .563 r
.41173 .77889 m .40953 .76096 L .40934 .76671 L p F P
0 g
s
.573 .366 .563 r
.41136 .79026 m .40934 .76671 L .40953 .76096 L p F P
0 g
s
.573 .366 .563 r
.40953 .76096 m .41173 .77889 L .41136 .79026 L p F P
0 g
s
.573 .366 .563 r
.70372 .51186 m .69156 .51055 L .6912 .50358 L p F P
0 g
s
.573 .366 .563 r
.6912 .50358 m .70335 .5051 L .70372 .51186 L p F P
0 g
s
.573 .366 .563 r
.70335 .5051 m .6912 .50358 L .69156 .51055 L p F P
0 g
s
.573 .366 .563 r
.67837 .51634 m .69156 .51055 L .6912 .50358 L p F P
0 g
s
.573 .366 .563 r
.66424 .5291 m .64925 .54845 L .64903 .5426 L p F P
0 g
s
.573 .366 .563 r
.63331 .56887 m .64903 .5426 L .64925 .54845 L p F P
0 g
s
.573 .366 .563 r
.64903 .5426 m .63331 .56887 L .63348 .57378 L p F P
0 g
s
.573 .366 .563 r
.63348 .57378 m .64925 .54845 L .64903 .5426 L p F P
0 g
s
.573 .366 .563 r
.42342 .7575 m .4171 .7552 L .41646 .7757 L p F P
0 g
s
.573 .366 .563 r
.41215 .76582 m .41646 .7757 L .4171 .7552 L p F P
0 g
s
.573 .366 .563 r
.42266 .78344 m .41646 .7757 L .4171 .7552 L p F P
0 g
s
.573 .366 .563 r
.4171 .7552 m .42342 .7575 L .42266 .78344 L p F P
0 g
s
.573 .366 .563 r
.67837 .51634 m .66424 .5291 L .66479 .54189 L p F P
0 g
s
.573 .366 .563 r
.66424 .5291 m .64925 .54845 L .64969 .55993 L p F P
0 g
s
.573 .366 .563 r
.64969 .55993 m .66479 .54189 L .66424 .5291 L p F P
0 g
s
.573 .366 .563 r
.67901 .52988 m .66479 .54189 L .66424 .5291 L p F P
0 g
s
.573 .366 .563 r
.66424 .5291 m .67837 .51634 L .67901 .52988 L p F P
0 g
s
.573 .366 .563 r
.64925 .54845 m .66424 .5291 L .66479 .54189 L p F P
0 g
s
.573 .366 .563 r
.69156 .51055 m .67837 .51634 L .67901 .52988 L p F P
0 g
s
.573 .366 .563 r
.66479 .54189 m .67901 .52988 L .67837 .51634 L p F P
0 g
s
.573 .366 .563 r
.69227 .52425 m .67901 .52988 L .67837 .51634 L p F P
0 g
s
.573 .366 .563 r
.67837 .51634 m .69156 .51055 L .69227 .52425 L p F P
0 g
s
.573 .366 .563 r
.5285 .65475 m .54602 .66974 L .54597 .6622 L p F P
0 g
s
.573 .366 .563 r
.54602 .66974 m .5285 .65475 L .52851 .6693 L p F P
0 g
s
.573 .366 .563 r
.54607 .67886 m .52851 .6693 L .5285 .65475 L p F P
0 g
s
.573 .366 .563 r
.5285 .65475 m .54602 .66974 L .54607 .67886 L p F P
0 g
s
.573 .366 .563 r
.40934 .76671 m .41136 .79026 L .41173 .77889 L p F P
0 g
s
.573 .366 .563 r
.41136 .79026 m .40934 .76671 L .40918 .77128 L p F P
0 g
s
.573 .366 .563 r
.41106 .79933 m .40918 .77128 L .40934 .76671 L p F P
0 g
s
.573 .366 .563 r
.40934 .76671 m .41136 .79026 L .41106 .79933 L p F P
0 g
s
.573 .366 .563 r
.64925 .54845 m .63348 .57378 L .63379 .58342 L p F P
0 g
s
.573 .366 .563 r
.63379 .58342 m .64969 .55993 L .64925 .54845 L p F P
0 g
s
.573 .366 .563 r
.66479 .54189 m .64969 .55993 L .64925 .54845 L p F P
0 g
s
.573 .366 .563 r
.63348 .57378 m .64925 .54845 L .64969 .55993 L p F P
0 g
s
.573 .366 .563 r
.64925 .54845 m .63348 .57378 L .63331 .56887 L p F P
0 g
s
.573 .366 .563 r
.41646 .7757 m .41215 .76582 L .41173 .77889 L p F P
0 g
s
.573 .366 .563 r
.41587 .79471 m .41173 .77889 L .41215 .76582 L p F P
0 g
s
.573 .366 .563 r
.41215 .76582 m .41646 .7757 L .41587 .79471 L p F P
0 g
s
.573 .366 .563 r
.69156 .51055 m .70372 .51186 L .70335 .5051 L p F P
0 g
s
.573 .366 .563 r
.70372 .51186 m .69156 .51055 L .69227 .52425 L p F P
0 g
s
.573 .366 .563 r
.67901 .52988 m .69227 .52425 L .69156 .51055 L p F P
0 g
s
.573 .366 .563 r
.70446 .52513 m .69227 .52425 L .69156 .51055 L p F P
0 g
s
.573 .366 .563 r
.69156 .51055 m .70372 .51186 L .70446 .52513 L p F P
0 g
s
.573 .366 .563 r
.48018 .71364 m .46616 .71714 L .46556 .75161 L p F P
0 g
s
.573 .366 .563 r
.4527 .7555 m .46556 .75161 L .46616 .71714 L p F P
0 g
s
.573 .366 .563 r
.47975 .74613 m .46556 .75161 L .46616 .71714 L p F P
0 g
s
.573 .366 .563 r
.46616 .71714 m .48018 .71364 L .47975 .74613 L p F P
0 g
s
.573 .366 .563 r
.43152 .7584 m .42342 .7575 L .42266 .78344 L p F P
0 g
s
.573 .366 .563 r
.41646 .7757 m .42266 .78344 L .42342 .7575 L p F P
0 g
s
.573 .366 .563 r
.4307 .78859 m .42266 .78344 L .42342 .7575 L p F P
0 g
s
.573 .366 .563 r
.42342 .7575 m .43152 .7584 L .4307 .78859 L p F P
0 g
s
.573 .366 .563 r
.40918 .77128 m .41106 .79933 L .41136 .79026 L p F P
0 g
s
.573 .366 .563 r
.41106 .79933 m .40918 .77128 L .40908 .77446 L p F P
0 g
s
.573 .366 .563 r
.41085 .80565 m .40908 .77446 L .40918 .77128 L p F P
0 g
s
.573 .366 .563 r
.40918 .77128 m .41106 .79933 L .41085 .80565 L p F P
0 g
s
.573 .366 .563 r
.63331 .56887 m .6169 .6005 L .617 .60424 L p F P
0 g
s
.573 .366 .563 r
.617 .60424 m .63348 .57378 L .63331 .56887 L p F P
0 g
s
.573 .366 .563 r
.6169 .6005 m .63331 .56887 L .63348 .57378 L p F P
0 g
s
.573 .366 .563 r
.40908 .77446 m .41085 .80565 L .41106 .79933 L p F P
0 g
s
.573 .366 .563 r
.41085 .80565 m .40908 .77446 L .40902 .77609 L p F P
0 g
s
.573 .366 .563 r
.41075 .8089 m .40902 .77609 L .40908 .77446 L p F P
0 g
s
.573 .366 .563 r
.40908 .77446 m .41085 .80565 L .41075 .8089 L p F P
0 g
s
.573 .366 .563 r
.71476 .52016 m .70372 .51186 L .70335 .5051 L p F P
0 g
s
.573 .366 .563 r
.70335 .5051 m .71439 .51391 L .71476 .52016 L p F P
0 g
s
.573 .366 .563 r
.71439 .51391 m .70335 .5051 L .70372 .51186 L p F P
0 g
s
.573 .366 .563 r
.40902 .77609 m .41075 .8089 L .41085 .80565 L p F P
0 g
s
.573 .366 .563 r
.67901 .52988 m .66479 .54189 L .66559 .56051 L p F P
0 g
s
.573 .366 .563 r
.66479 .54189 m .64969 .55993 L .65033 .57662 L p F P
0 g
s
.573 .366 .563 r
.65033 .57662 m .66559 .56051 L .66479 .54189 L p F P
0 g
s
.573 .366 .563 r
.67995 .5496 m .66559 .56051 L .66479 .54189 L p F P
0 g
s
.573 .366 .563 r
.66479 .54189 m .67901 .52988 L .67995 .5496 L p F P
0 g
s
.573 .366 .563 r
.64969 .55993 m .66479 .54189 L .66559 .56051 L p F P
0 g
s
.573 .366 .563 r
.69227 .52425 m .67901 .52988 L .67995 .5496 L p F P
0 g
s
.573 .366 .563 r
.66559 .56051 m .67995 .5496 L .67901 .52988 L p F P
0 g
s
.573 .366 .563 r
.6933 .5442 m .67995 .5496 L .67901 .52988 L p F P
0 g
s
.573 .366 .563 r
.67901 .52988 m .69227 .52425 L .6933 .5442 L p F P
0 g
s
.573 .366 .563 r
.51163 .68331 m .52853 .68578 L .52851 .6693 L p F P
0 g
s
.573 .366 .563 r
.52853 .68578 m .51163 .68331 L .51154 .7068 L p F P
0 g
s
.573 .366 .563 r
.49536 .71019 m .51154 .7068 L .51163 .68331 L p F P
0 g
s
.573 .366 .563 r
.52854 .70346 m .51154 .7068 L .51163 .68331 L p F P
0 g
s
.573 .366 .563 r
.51163 .68331 m .52853 .68578 L .52854 .70346 L p F P
0 g
s
.573 .366 .563 r
.56413 .68034 m .54591 .65192 L .54591 .65309 L p F P
0 g
s
.573 .366 .563 r
.56413 .68074 m .54591 .65309 L .54591 .65192 L p F P
0 g
s
.573 .366 .563 r
.54591 .65192 m .56413 .68034 L .56413 .68074 L p F P
0 g
s
.573 .366 .563 r
.54591 .65309 m .56413 .68074 L .56413 .68034 L p F P
0 g
s
.573 .366 .563 r
.56413 .68074 m .54591 .65309 L .54593 .65657 L p F P
0 g
s
.573 .366 .563 r
.56415 .68195 m .54593 .65657 L .54591 .65309 L p F P
0 g
s
.573 .366 .563 r
.54591 .65309 m .56413 .68074 L .56415 .68195 L p F P
0 g
s
.573 .366 .563 r
.52851 .6693 m .54607 .67886 L .54602 .66974 L p F P
0 g
s
.573 .366 .563 r
.54607 .67886 m .52851 .6693 L .52853 .68578 L p F P
0 g
s
.573 .366 .563 r
.54613 .68916 m .52853 .68578 L .52851 .6693 L p F P
0 g
s
.573 .366 .563 r
.52851 .6693 m .54607 .67886 L .54613 .68916 L p F P
0 g
s
.573 .366 .563 r
.49536 .71019 m .48018 .71364 L .47975 .74613 L p F P
0 g
s
.573 .366 .563 r
.46556 .75161 m .47975 .74613 L .48018 .71364 L p F P
0 g
s
.573 .366 .563 r
.4951 .73917 m .47975 .74613 L .48018 .71364 L p F P
0 g
s
.573 .366 .563 r
.48018 .71364 m .49536 .71019 L .4951 .73917 L p F P
0 g
s
.573 .366 .563 r
.44131 .75776 m .43152 .7584 L .4307 .78859 L p F P
0 g
s
.573 .366 .563 r
.42266 .78344 m .4307 .78859 L .43152 .7584 L p F P
0 g
s
.573 .366 .563 r
.44051 .79078 m .4307 .78859 L .43152 .7584 L p F P
0 g
s
.573 .366 .563 r
.43152 .7584 m .44131 .75776 L .44051 .79078 L p F P
0 g
s
.573 .366 .563 r
.63348 .57378 m .617 .60424 L .61721 .61156 L p F P
0 g
s
.573 .366 .563 r
.61721 .61156 m .63379 .58342 L .63348 .57378 L p F P
0 g
s
.573 .366 .563 r
.64969 .55993 m .63379 .58342 L .63348 .57378 L p F P
0 g
s
.573 .366 .563 r
.617 .60424 m .63348 .57378 L .63379 .58342 L p F P
0 g
s
.573 .366 .563 r
.63348 .57378 m .617 .60424 L .6169 .6005 L p F P
0 g
s
.573 .366 .563 r
.64969 .55993 m .63379 .58342 L .63426 .59741 L p F P
0 g
s
.573 .366 .563 r
.63426 .59741 m .65033 .57662 L .64969 .55993 L p F P
0 g
s
.573 .366 .563 r
.66559 .56051 m .65033 .57662 L .64969 .55993 L p F P
0 g
s
.573 .366 .563 r
.63379 .58342 m .64969 .55993 L .65033 .57662 L p F P
0 g
s
.573 .366 .563 r
.41173 .77889 m .41587 .79471 L .41646 .7757 L p F P
0 g
s
.573 .366 .563 r
.41587 .79471 m .41173 .77889 L .41136 .79026 L p F P
0 g
s
.573 .366 .563 r
.41535 .81128 m .41136 .79026 L .41173 .77889 L p F P
0 g
s
.573 .366 .563 r
.41173 .77889 m .41587 .79471 L .41535 .81128 L p F P
0 g
s
.573 .366 .563 r
.70372 .51186 m .71476 .52016 L .71439 .51391 L p F P
0 g
s
.573 .366 .563 r
.71476 .52016 m .70372 .51186 L .70446 .52513 L p F P
0 g
s
.573 .366 .563 r
.69227 .52425 m .70446 .52513 L .70372 .51186 L p F P
0 g
s
.573 .366 .563 r
.71548 .53242 m .70446 .52513 L .70372 .51186 L p F P
0 g
s
.573 .366 .563 r
.70372 .51186 m .71476 .52016 L .71548 .53242 L p F P
0 g
s
.573 .366 .563 r
.54593 .65657 m .56415 .68195 L .56413 .68074 L p F P
0 g
s
.573 .366 .563 r
.56415 .68195 m .54593 .65657 L .54597 .6622 L p F P
0 g
s
.573 .366 .563 r
.56417 .68389 m .54597 .6622 L .54593 .65657 L p F P
0 g
s
.573 .366 .563 r
.54593 .65657 m .56415 .68195 L .56417 .68389 L p F P
0 g
s
.573 .366 .563 r
.42266 .78344 m .41646 .7757 L .41587 .79471 L p F P
0 g
s
.573 .366 .563 r
.42195 .80757 m .41587 .79471 L .41646 .7757 L p F P
0 g
s
.573 .366 .563 r
.41646 .7757 m .42266 .78344 L .42195 .80757 L p F P
0 g
s
.573 .366 .563 r
.70446 .52513 m .69227 .52425 L .6933 .5442 L p F P
0 g
s
.573 .366 .563 r
.67995 .5496 m .6933 .5442 L .69227 .52425 L p F P
0 g
s
.573 .366 .563 r
.70553 .54445 m .6933 .5442 L .69227 .52425 L p F P
0 g
s
.573 .366 .563 r
.69227 .52425 m .70446 .52513 L .70553 .54445 L p F P
0 g
s
.573 .366 .563 r
.4527 .7555 m .44131 .75776 L .44051 .79078 L p F P
0 g
s
.573 .366 .563 r
.4307 .78859 m .44051 .79078 L .44131 .75776 L p F P
0 g
s
.573 .366 .563 r
.45198 .7898 m .44051 .79078 L .44131 .75776 L p F P
0 g
s
.573 .366 .563 r
.44131 .75776 m .4527 .7555 L .45198 .7898 L p F P
0 g
s
.573 .366 .563 r
.54597 .6622 m .56417 .68389 L .56415 .68195 L p F P
0 g
s
.573 .366 .563 r
.56417 .68389 m .54597 .6622 L .54602 .66974 L p F P
0 g
s
.573 .366 .563 r
.5642 .68648 m .54602 .66974 L .54597 .6622 L p F P
0 g
s
.573 .366 .563 r
.54597 .6622 m .56417 .68389 L .5642 .68648 L p F P
0 g
s
.573 .366 .563 r
.51154 .7068 m .49536 .71019 L .4951 .73917 L p F P
0 g
s
.573 .366 .563 r
.47975 .74613 m .4951 .73917 L .49536 .71019 L p F P
0 g
s
.573 .366 .563 r
.51144 .7309 m .4951 .73917 L .49536 .71019 L p F P
0 g
s
.573 .366 .563 r
.49536 .71019 m .51154 .7068 L .51144 .7309 L p F P
0 g
s
.573 .366 .563 r
.63379 .58342 m .61721 .61156 L .6175 .62217 L p F P
0 g
s
.573 .366 .563 r
.6175 .62217 m .63426 .59741 L .63379 .58342 L p F P
0 g
s
.573 .366 .563 r
.65033 .57662 m .63426 .59741 L .63379 .58342 L p F P
0 g
s
.573 .366 .563 r
.61721 .61156 m .63379 .58342 L .63426 .59741 L p F P
0 g
s
.573 .366 .563 r
.63379 .58342 m .61721 .61156 L .617 .60424 L p F P
0 g
s
.573 .366 .563 r
.6169 .6005 m .59988 .6364 L .59993 .63875 L p F P
0 g
s
.573 .366 .563 r
.59993 .63875 m .617 .60424 L .6169 .6005 L p F P
0 g
s
.573 .366 .563 r
.59988 .6364 m .6169 .6005 L .617 .60424 L p F P
0 g
s
.573 .366 .563 r
.41136 .79026 m .41535 .81128 L .41587 .79471 L p F P
0 g
s
.573 .366 .563 r
.41535 .81128 m .41136 .79026 L .41106 .79933 L p F P
0 g
s
.573 .366 .563 r
.41493 .82455 m .41106 .79933 L .41136 .79026 L p F P
0 g
s
.573 .366 .563 r
.41136 .79026 m .41535 .81128 L .41493 .82455 L p F P
0 g
s
.573 .366 .563 r
.72422 .52965 m .71439 .51391 L .71476 .52016 L p F P
0 g
s
.573 .366 .563 r
.72456 .5351 m .71476 .52016 L .71439 .51391 L p F P
0 g
s
.573 .366 .563 r
.71439 .51391 m .72422 .52965 L .72456 .5351 L p F P
0 g
s
.573 .366 .563 r
.617 .60424 m .59993 .63875 L .60003 .64335 L p F P
0 g
s
.573 .366 .563 r
.60003 .64335 m .61721 .61156 L .617 .60424 L p F P
0 g
s
.573 .366 .563 r
.59993 .63875 m .617 .60424 L .61721 .61156 L p F P
0 g
s
.573 .366 .563 r
.617 .60424 m .59993 .63875 L .59988 .6364 L p F P
0 g
s
.573 .366 .563 r
.54602 .66974 m .5642 .68648 L .56417 .68389 L p F P
0 g
s
.573 .366 .563 r
.5642 .68648 m .54602 .66974 L .54607 .67886 L p F P
0 g
s
.573 .366 .563 r
.56423 .68961 m .54607 .67886 L .54602 .66974 L p F P
0 g
s
.573 .366 .563 r
.54602 .66974 m .5642 .68648 L .56423 .68961 L p F P
0 g
s
.573 .366 .563 r
.52853 .68578 m .54613 .68916 L .54607 .67886 L p F P
0 g
s
.573 .366 .563 r
.54613 .68916 m .52853 .68578 L .52854 .70346 L p F P
0 g
s
.573 .366 .563 r
.51154 .7068 m .52854 .70346 L .52853 .68578 L p F P
0 g
s
.573 .366 .563 r
.5462 .70016 m .52854 .70346 L .52853 .68578 L p F P
0 g
s
.573 .366 .563 r
.52853 .68578 m .54613 .68916 L .5462 .70016 L p F P
0 g
s
.573 .366 .563 r
.46556 .75161 m .4527 .7555 L .45198 .7898 L p F P
0 g
s
.573 .366 .563 r
.44051 .79078 m .45198 .7898 L .4527 .7555 L p F P
0 g
s
.573 .366 .563 r
.46498 .78554 m .45198 .7898 L .4527 .7555 L p F P
0 g
s
.573 .366 .563 r
.4527 .7555 m .46556 .75161 L .46498 .78554 L p F P
0 g
s
.573 .366 .563 r
.67995 .5496 m .66559 .56051 L .66662 .58426 L p F P
0 g
s
.573 .366 .563 r
.66559 .56051 m .65033 .57662 L .65114 .59788 L p F P
0 g
s
.573 .366 .563 r
.65114 .59788 m .66662 .58426 L .66559 .56051 L p F P
0 g
s
.573 .366 .563 r
.68115 .57477 m .66662 .58426 L .66559 .56051 L p F P
0 g
s
.573 .366 .563 r
.66559 .56051 m .67995 .5496 L .68115 .57477 L p F P
0 g
s
.573 .366 .563 r
.65033 .57662 m .66559 .56051 L .66662 .58426 L p F P
0 g
s
.573 .366 .563 r
.70446 .52513 m .71548 .53242 L .71476 .52016 L p F P
0 g
s
.573 .366 .563 r
.71548 .53242 m .70446 .52513 L .70553 .54445 L p F P
0 g
s
.573 .366 .563 r
.6933 .5442 m .70553 .54445 L .70446 .52513 L p F P
0 g
s
.573 .366 .563 r
.71653 .55026 m .70553 .54445 L .70446 .52513 L p F P
0 g
s
.573 .366 .563 r
.70446 .52513 m .71548 .53242 L .71653 .55026 L p F P
0 g
s
.573 .366 .563 r
.4307 .78859 m .42266 .78344 L .42195 .80757 L p F P
0 g
s
.573 .366 .563 r
.41587 .79471 m .42195 .80757 L .42266 .78344 L p F P
0 g
s
.573 .366 .563 r
.42993 .81673 m .42195 .80757 L .42266 .78344 L p F P
0 g
s
.573 .366 .563 r
.42266 .78344 m .4307 .78859 L .42993 .81673 L p F P
0 g
s
.573 .366 .563 r
.65033 .57662 m .63426 .59741 L .63485 .6152 L p F P
0 g
s
.573 .366 .563 r
.63485 .6152 m .65114 .59788 L .65033 .57662 L p F P
0 g
s
.573 .366 .563 r
.66662 .58426 m .65114 .59788 L .65033 .57662 L p F P
0 g
s
.573 .366 .563 r
.63426 .59741 m .65033 .57662 L .65114 .59788 L p F P
0 g
s
.573 .366 .563 r
.6933 .5442 m .67995 .5496 L .68115 .57477 L p F P
0 g
s
.573 .366 .563 r
.66662 .58426 m .68115 .57477 L .67995 .5496 L p F P
0 g
s
.573 .366 .563 r
.69462 .56969 m .68115 .57477 L .67995 .5496 L p F P
0 g
s
.573 .366 .563 r
.67995 .5496 m .6933 .5442 L .69462 .56969 L p F P
0 g
s
.573 .366 .563 r
.71476 .52016 m .72456 .5351 L .72422 .52965 L p F P
0 g
s
.573 .366 .563 r
.72456 .5351 m .71476 .52016 L .71548 .53242 L p F P
0 g
s
.573 .366 .563 r
.72521 .5458 m .71548 .53242 L .71476 .52016 L p F P
0 g
s
.573 .366 .563 r
.71476 .52016 m .72456 .5351 L .72521 .5458 L p F P
0 g
s
.573 .366 .563 r
.52854 .70346 m .51154 .7068 L .51144 .7309 L p F P
0 g
s
.573 .366 .563 r
.4951 .73917 m .51144 .7309 L .51154 .7068 L p F P
0 g
s
.573 .366 .563 r
.52856 .72154 m .51144 .7309 L .51154 .7068 L p F P
0 g
s
.573 .366 .563 r
.51154 .7068 m .52854 .70346 L .52856 .72154 L p F P
0 g
s
.573 .366 .563 r
.42195 .80757 m .41587 .79471 L .41535 .81128 L p F P
0 g
s
.573 .366 .563 r
.42132 .82865 m .41535 .81128 L .41587 .79471 L p F P
0 g
s
.573 .366 .563 r
.41587 .79471 m .42195 .80757 L .42132 .82865 L p F P
0 g
s
.573 .366 .563 r
.41106 .79933 m .41493 .82455 L .41535 .81128 L p F P
0 g
s
.573 .366 .563 r
.41493 .82455 m .41106 .79933 L .41085 .80565 L p F P
0 g
s
.573 .366 .563 r
.41464 .83381 m .41085 .80565 L .41106 .79933 L p F P
0 g
s
.573 .366 .563 r
.41106 .79933 m .41493 .82455 L .41464 .83381 L p F P
0 g
s
.573 .366 .563 r
.61721 .61156 m .60003 .64335 L .60018 .65001 L p F P
0 g
s
.573 .366 .563 r
.60018 .65001 m .6175 .62217 L .61721 .61156 L p F P
0 g
s
.573 .366 .563 r
.63426 .59741 m .6175 .62217 L .61721 .61156 L p F P
0 g
s
.573 .366 .563 r
.60003 .64335 m .61721 .61156 L .6175 .62217 L p F P
0 g
s
.573 .366 .563 r
.61721 .61156 m .60003 .64335 L .59993 .63875 L p F P
0 g
s
.573 .366 .563 r
.47975 .74613 m .46556 .75161 L .46498 .78554 L p F P
0 g
s
.573 .366 .563 r
.45198 .7898 m .46498 .78554 L .46556 .75161 L p F P
0 g
s
.573 .366 .563 r
.47933 .77807 m .46498 .78554 L .46556 .75161 L p F P
0 g
s
.573 .366 .563 r
.46556 .75161 m .47975 .74613 L .47933 .77807 L p F P
0 g
s
.573 .366 .563 r
.63426 .59741 m .6175 .62217 L .61787 .63562 L p F P
0 g
s
.573 .366 .563 r
.61787 .63562 m .63485 .6152 L .63426 .59741 L p F P
0 g
s
.573 .366 .563 r
.65114 .59788 m .63485 .6152 L .63426 .59741 L p F P
0 g
s
.573 .366 .563 r
.6175 .62217 m .63426 .59741 L .63485 .6152 L p F P
0 g
s
.573 .366 .563 r
.54607 .67886 m .56423 .68961 L .5642 .68648 L p F P
0 g
s
.573 .366 .563 r
.56423 .68961 m .54607 .67886 L .54613 .68916 L p F P
0 g
s
.573 .366 .563 r
.56427 .69313 m .54613 .68916 L .54607 .67886 L p F P
0 g
s
.573 .366 .563 r
.54607 .67886 m .56423 .68961 L .56427 .69313 L p F P
0 g
s
.573 .366 .563 r
.70553 .54445 m .6933 .5442 L .69462 .56969 L p F P
0 g
s
.573 .366 .563 r
.68115 .57477 m .69462 .56969 L .6933 .5442 L p F P
0 g
s
.573 .366 .563 r
.7069 .56912 m .69462 .56969 L .6933 .5442 L p F P
0 g
s
.573 .366 .563 r
.6933 .5442 m .70553 .54445 L .7069 .56912 L p F P
0 g
s
.573 .366 .563 r
.41085 .80565 m .41464 .83381 L .41493 .82455 L p F P
0 g
s
.573 .366 .563 r
.41464 .83381 m .41085 .80565 L .41075 .8089 L p F P
0 g
s
.573 .366 .563 r
.41449 .83857 m .41075 .8089 L .41085 .80565 L p F P
0 g
s
.573 .366 .563 r
.41085 .80565 m .41464 .83381 L .41449 .83857 L p F P
0 g
s
.573 .366 .563 r
.44051 .79078 m .4307 .78859 L .42993 .81673 L p F P
0 g
s
.573 .366 .563 r
.42195 .80757 m .42993 .81673 L .4307 .78859 L p F P
0 g
s
.573 .366 .563 r
.43976 .82162 m .42993 .81673 L .4307 .78859 L p F P
0 g
s
.573 .366 .563 r
.4307 .78859 m .44051 .79078 L .43976 .82162 L p F P
0 g
s
.573 .366 .563 r
.41075 .8089 m .41449 .83857 L .41464 .83381 L p F P
0 g
s
.573 .366 .563 r
.4951 .73917 m .47975 .74613 L .47933 .77807 L p F P
0 g
s
.573 .366 .563 r
.46498 .78554 m .47933 .77807 L .47975 .74613 L p F P
0 g
s
.573 .366 .563 r
.49485 .7676 m .47933 .77807 L .47975 .74613 L p F P
0 g
s
.573 .366 .563 r
.47975 .74613 m .4951 .73917 L .49485 .7676 L p F P
0 g
s
.573 .366 .563 r
.58237 .67521 m .59988 .6364 L .59993 .63875 L p F P
0 g
s
.573 .366 .563 r
.59988 .6364 m .58237 .67521 L .58238 .67602 L p F P
0 g
s
.573 .366 .563 r
.58238 .67602 m .59993 .63875 L .59988 .6364 L p F P
0 g
s
.573 .366 .563 r
.52854 .70346 m .5462 .70016 L .54613 .68916 L p F P
0 g
s
.573 .366 .563 r
.5462 .70016 m .52854 .70346 L .52856 .72154 L p F P
0 g
s
.573 .366 .563 r
.51144 .7309 m .52856 .72154 L .52854 .70346 L p F P
0 g
s
.573 .366 .563 r
.54627 .71137 m .52856 .72154 L .52854 .70346 L p F P
0 g
s
.573 .366 .563 r
.52854 .70346 m .5462 .70016 L .54627 .71137 L p F P
0 g
s
.573 .366 .563 r
.6175 .62217 m .60018 .65001 L .60037 .65843 L p F P
0 g
s
.573 .366 .563 r
.60037 .65843 m .61787 .63562 L .6175 .62217 L p F P
0 g
s
.573 .366 .563 r
.63485 .6152 m .61787 .63562 L .6175 .62217 L p F P
0 g
s
.573 .366 .563 r
.60018 .65001 m .6175 .62217 L .61787 .63562 L p F P
0 g
s
.573 .366 .563 r
.6175 .62217 m .60018 .65001 L .60003 .64335 L p F P
0 g
s
.573 .366 .563 r
.72617 .56134 m .71653 .55026 L .71548 .53242 L p F P
0 g
s
.573 .366 .563 r
.71548 .53242 m .72521 .5458 L .72617 .56134 L p F P
0 g
s
.573 .366 .563 r
.71548 .53242 m .72521 .5458 L .72456 .5351 L p F P
0 g
s
.573 .366 .563 r
.72521 .5458 m .71548 .53242 L .71653 .55026 L p F P
0 g
s
.573 .366 .563 r
.70553 .54445 m .71653 .55026 L .71548 .53242 L p F P
0 g
s
.573 .366 .563 r
.58238 .67602 m .59993 .63875 L .60003 .64335 L p F P
0 g
s
.573 .366 .563 r
.59993 .63875 m .58238 .67602 L .58237 .67521 L p F P
0 g
s
.573 .366 .563 r
.59993 .63875 m .58238 .67602 L .58241 .6776 L p F P
0 g
s
.573 .366 .563 r
.58241 .6776 m .60003 .64335 L .59993 .63875 L p F P
0 g
s
.573 .366 .563 r
.54613 .68916 m .56427 .69313 L .56423 .68961 L p F P
0 g
s
.573 .366 .563 r
.56427 .69313 m .54613 .68916 L .5462 .70016 L p F P
0 g
s
.573 .366 .563 r
.56432 .69688 m .5462 .70016 L .54613 .68916 L p F P
0 g
s
.573 .366 .563 r
.54613 .68916 m .56427 .69313 L .56432 .69688 L p F P
0 g
s
.573 .366 .563 r
.71653 .55026 m .70553 .54445 L .7069 .56912 L p F P
0 g
s
.573 .366 .563 r
.69462 .56969 m .7069 .56912 L .70553 .54445 L p F P
0 g
s
.573 .366 .563 r
.71787 .57302 m .7069 .56912 L .70553 .54445 L p F P
0 g
s
.573 .366 .563 r
.70553 .54445 m .71653 .55026 L .71787 .57302 L p F P
0 g
s
.573 .366 .563 r
.41535 .81128 m .42132 .82865 L .42195 .80757 L p F P
0 g
s
.573 .366 .563 r
.42132 .82865 m .41535 .81128 L .41493 .82455 L p F P
0 g
s
.573 .366 .563 r
.42083 .84557 m .41493 .82455 L .41535 .81128 L p F P
0 g
s
.573 .366 .563 r
.41535 .81128 m .42132 .82865 L .42083 .84557 L p F P
0 g
s
.573 .366 .563 r
.51144 .7309 m .4951 .73917 L .49485 .7676 L p F P
0 g
s
.573 .366 .563 r
.47933 .77807 m .49485 .7676 L .4951 .73917 L p F P
0 g
s
.573 .366 .563 r
.51134 .75448 m .49485 .7676 L .4951 .73917 L p F P
0 g
s
.573 .366 .563 r
.4951 .73917 m .51144 .7309 L .51134 .75448 L p F P
0 g
s
.573 .366 .563 r
.60003 .64335 m .58241 .6776 L .58245 .67989 L p F P
0 g
s
.573 .366 .563 r
.58245 .67989 m .60018 .65001 L .60003 .64335 L p F P
0 g
s
.573 .366 .563 r
.58241 .6776 m .60003 .64335 L .60018 .65001 L p F P
0 g
s
.573 .366 .563 r
.60003 .64335 m .58241 .6776 L .58238 .67602 L p F P
0 g
s
.573 .366 .563 r
.73269 .55169 m .72422 .52965 L .72456 .5351 L p F P
0 g
s
.573 .366 .563 r
.73297 .55609 m .72456 .5351 L .72422 .52965 L p F P
0 g
s
.573 .366 .563 r
.72422 .52965 m .73269 .55169 L .73297 .55609 L p F P
0 g
s
.573 .366 .563 r
.42993 .81673 m .42195 .80757 L .42132 .82865 L p F P
0 g
s
.573 .366 .563 r
.42927 .84138 m .42132 .82865 L .42195 .80757 L p F P
0 g
s
.573 .366 .563 r
.42195 .80757 m .42993 .81673 L .42927 .84138 L p F P
0 g
s
.573 .366 .563 r
.45198 .7898 m .44051 .79078 L .43976 .82162 L p F P
0 g
s
.573 .366 .563 r
.42993 .81673 m .43976 .82162 L .44051 .79078 L p F P
0 g
s
.573 .366 .563 r
.45131 .82185 m .43976 .82162 L .44051 .79078 L p F P
0 g
s
.573 .366 .563 r
.44051 .79078 m .45198 .7898 L .45131 .82185 L p F P
0 g
s
.573 .366 .563 r
.66662 .58426 m .65114 .59788 L .65209 .62288 L p F P
0 g
s
.573 .366 .563 r
.65114 .59788 m .63485 .6152 L .63554 .63606 L p F P
0 g
s
.573 .366 .563 r
.63554 .63606 m .65209 .62288 L .65114 .59788 L p F P
0 g
s
.573 .366 .563 r
.66782 .61223 m .65209 .62288 L .65114 .59788 L p F P
0 g
s
.573 .366 .563 r
.65114 .59788 m .66662 .58426 L .66782 .61223 L p F P
0 g
s
.573 .366 .563 r
.63485 .6152 m .65114 .59788 L .65209 .62288 L p F P
0 g
s
.573 .366 .563 r
.68115 .57477 m .66662 .58426 L .66782 .61223 L p F P
0 g
s
.573 .366 .563 r
.65209 .62288 m .66782 .61223 L .66662 .58426 L p F P
0 g
s
.573 .366 .563 r
.68257 .60444 m .66782 .61223 L .66662 .58426 L p F P
0 g
s
.573 .366 .563 r
.66662 .58426 m .68115 .57477 L .68257 .60444 L p F P
0 g
s
.573 .366 .563 r
.63485 .6152 m .61787 .63562 L .61831 .65136 L p F P
0 g
s
.573 .366 .563 r
.61831 .65136 m .63554 .63606 L .63485 .6152 L p F P
0 g
s
.573 .366 .563 r
.65209 .62288 m .63554 .63606 L .63485 .6152 L p F P
0 g
s
.573 .366 .563 r
.61787 .63562 m .63485 .6152 L .63554 .63606 L p F P
0 g
s
.573 .366 .563 r
.58296 .71033 m .56413 .68034 L .56413 .68074 L p F P
0 g
s
.573 .366 .563 r
.58296 .70992 m .56413 .68074 L .56413 .68034 L p F P
0 g
s
.573 .366 .563 r
.56413 .68034 m .58296 .71033 L .58296 .70992 L p F P
0 g
s
.573 .366 .563 r
.56413 .68074 m .58296 .70992 L .58296 .71033 L p F P
0 g
s
.573 .366 .563 r
.58296 .70992 m .56413 .68074 L .56415 .68195 L p F P
0 g
s
.573 .366 .563 r
.58294 .70869 m .56415 .68195 L .56413 .68074 L p F P
0 g
s
.573 .366 .563 r
.56413 .68074 m .58296 .70992 L .58294 .70869 L p F P
0 g
s
.573 .366 .563 r
.56415 .68195 m .58294 .70869 L .58296 .70992 L p F P
0 g
s
.573 .366 .563 r
.58294 .70869 m .56415 .68195 L .56417 .68389 L p F P
0 g
s
.573 .366 .563 r
.5829 .70671 m .56417 .68389 L .56415 .68195 L p F P
0 g
s
.573 .366 .563 r
.56415 .68195 m .58294 .70869 L .5829 .70671 L p F P
0 g
s
.573 .366 .563 r
.69462 .56969 m .68115 .57477 L .68257 .60444 L p F P
0 g
s
.573 .366 .563 r
.66782 .61223 m .68257 .60444 L .68115 .57477 L p F P
0 g
s
.573 .366 .563 r
.69618 .59973 m .68257 .60444 L .68115 .57477 L p F P
0 g
s
.573 .366 .563 r
.68115 .57477 m .69462 .56969 L .69618 .59973 L p F P
0 g
s
.573 .366 .563 r
.72456 .5351 m .73297 .55609 L .73269 .55169 L p F P
0 g
s
.573 .366 .563 r
.73297 .55609 m .72456 .5351 L .72521 .5458 L p F P
0 g
s
.573 .366 .563 r
.73352 .5647 m .72521 .5458 L .72456 .5351 L p F P
0 g
s
.573 .366 .563 r
.72456 .5351 m .73297 .55609 L .73352 .5647 L p F P
0 g
s
.573 .366 .563 r
.52856 .72154 m .51144 .7309 L .51134 .75448 L p F P
0 g
s
.573 .366 .563 r
.49485 .7676 m .51134 .75448 L .51144 .7309 L p F P
0 g
s
.573 .366 .563 r
.52858 .73918 m .51134 .75448 L .51144 .7309 L p F P
0 g
s
.573 .366 .563 r
.51144 .7309 m .52856 .72154 L .52858 .73918 L p F P
0 g
s
.573 .366 .563 r
.60018 .65001 m .58245 .67989 L .5825 .68277 L p F P
0 g
s
.573 .366 .563 r
.5825 .68277 m .60037 .65843 L .60018 .65001 L p F P
0 g
s
.573 .366 .563 r
.61787 .63562 m .60037 .65843 L .60018 .65001 L p F P
0 g
s
.573 .366 .563 r
.58245 .67989 m .60018 .65001 L .60037 .65843 L p F P
0 g
s
.573 .366 .563 r
.60018 .65001 m .58245 .67989 L .58241 .6776 L p F P
0 g
s
.573 .366 .563 r
.5462 .70016 m .56432 .69688 L .56427 .69313 L p F P
0 g
s
.573 .366 .563 r
.56432 .69688 m .5462 .70016 L .54627 .71137 L p F P
0 g
s
.573 .366 .563 r
.52856 .72154 m .54627 .71137 L .5462 .70016 L p F P
0 g
s
.573 .366 .563 r
.56436 .70067 m .54627 .71137 L .5462 .70016 L p F P
0 g
s
.573 .366 .563 r
.5462 .70016 m .56432 .69688 L .56436 .70067 L p F P
0 g
s
.573 .366 .563 r
.56417 .68389 m .5829 .70671 L .58294 .70869 L p F P
0 g
s
.573 .366 .563 r
.5829 .70671 m .56417 .68389 L .5642 .68648 L p F P
0 g
s
.573 .366 .563 r
.58286 .70407 m .5642 .68648 L .56417 .68389 L p F P
0 g
s
.573 .366 .563 r
.56417 .68389 m .5829 .70671 L .58286 .70407 L p F P
0 g
s
.573 .366 .563 r
.61787 .63562 m .60037 .65843 L .60059 .66824 L p F P
0 g
s
.573 .366 .563 r
.60059 .66824 m .61831 .65136 L .61787 .63562 L p F P
0 g
s
.573 .366 .563 r
.63554 .63606 m .61831 .65136 L .61787 .63562 L p F P
0 g
s
.573 .366 .563 r
.60037 .65843 m .61787 .63562 L .61831 .65136 L p F P
0 g
s
.573 .366 .563 r
.5642 .68648 m .58286 .70407 L .5829 .70671 L p F P
0 g
s
.573 .366 .563 r
.58286 .70407 m .5642 .68648 L .56423 .68961 L p F P
0 g
s
.573 .366 .563 r
.58281 .7009 m .56423 .68961 L .5642 .68648 L p F P
0 g
s
.573 .366 .563 r
.5642 .68648 m .58286 .70407 L .58281 .7009 L p F P
0 g
s
.573 .366 .563 r
.46498 .78554 m .45198 .7898 L .45131 .82185 L p F P
0 g
s
.573 .366 .563 r
.43976 .82162 m .45131 .82185 L .45198 .7898 L p F P
0 g
s
.573 .366 .563 r
.46443 .81724 m .45131 .82185 L .45198 .7898 L p F P
0 g
s
.573 .366 .563 r
.45198 .7898 m .46498 .78554 L .46443 .81724 L p F P
0 g
s
.573 .366 .563 r
.41493 .82455 m .42083 .84557 L .42132 .82865 L p F P
0 g
s
.573 .366 .563 r
.42083 .84557 m .41493 .82455 L .41464 .83381 L p F P
0 g
s
.573 .366 .563 r
.42048 .85741 m .41464 .83381 L .41493 .82455 L p F P
0 g
s
.573 .366 .563 r
.41493 .82455 m .42083 .84557 L .42048 .85741 L p F P
0 g
s
.573 .366 .563 r
.54627 .71137 m .52856 .72154 L .52858 .73918 L p F P
0 g
s
.573 .366 .563 r
.51134 .75448 m .52858 .73918 L .52856 .72154 L p F P
0 g
s
.573 .366 .563 r
.54634 .72226 m .52858 .73918 L .52856 .72154 L p F P
0 g
s
.573 .366 .563 r
.52856 .72154 m .54627 .71137 L .54634 .72226 L p F P
0 g
s
.573 .366 .563 r
.7069 .56912 m .69462 .56969 L .69618 .59973 L p F P
0 g
s
.573 .366 .563 r
.68257 .60444 m .69618 .59973 L .69462 .56969 L p F P
0 g
s
.573 .366 .563 r
.70852 .5982 m .69618 .59973 L .69462 .56969 L p F P
0 g
s
.573 .366 .563 r
.69462 .56969 m .7069 .56912 L .70852 .5982 L p F P
0 g
s
.573 .366 .563 r
.56423 .68961 m .58281 .7009 L .58286 .70407 L p F P
0 g
s
.573 .366 .563 r
.58281 .7009 m .56423 .68961 L .56427 .69313 L p F P
0 g
s
.573 .366 .563 r
.58275 .69735 m .56427 .69313 L .56423 .68961 L p F P
0 g
s
.573 .366 .563 r
.56423 .68961 m .58281 .7009 L .58275 .69735 L p F P
0 g
s
.573 .366 .563 r
.71653 .55026 m .72617 .56134 L .72521 .5458 L p F P
0 g
s
.573 .366 .563 r
.72617 .56134 m .71653 .55026 L .71787 .57302 L p F P
0 g
s
.573 .366 .563 r
.7069 .56912 m .71787 .57302 L .71653 .55026 L p F P
0 g
s
.573 .366 .563 r
.72739 .58113 m .71787 .57302 L .71653 .55026 L p F P
0 g
s
.573 .366 .563 r
.71653 .55026 m .72617 .56134 L .72739 .58113 L p F P
0 g
s
.573 .366 .563 r
.61831 .65136 m .60059 .66824 L .60037 .65843 L p F P
0 g
s
.573 .366 .563 r
.5825 .68277 m .60037 .65843 L .60059 .66824 L p F P
0 g
s
.573 .366 .563 r
.60037 .65843 m .5825 .68277 L .58245 .67989 L p F P
0 g
s
.573 .366 .563 r
.60037 .65843 m .5825 .68277 L .58256 .68612 L p F P
0 g
s
.573 .366 .563 r
.58256 .68612 m .60059 .66824 L .60037 .65843 L p F P
0 g
s
.573 .366 .563 r
.56453 .7154 m .58237 .67521 L .58238 .67602 L p F P
0 g
s
.573 .366 .563 r
.58237 .67521 m .56453 .7154 L .56452 .71457 L p F P
0 g
s
.573 .366 .563 r
.56452 .71457 m .58238 .67602 L .58237 .67521 L p F P
0 g
s
.573 .366 .563 r
.56452 .71457 m .58238 .67602 L .58241 .6776 L p F P
0 g
s
.573 .366 .563 r
.58238 .67602 m .56452 .71457 L .56453 .7154 L p F P
0 g
s
.573 .366 .563 r
.58238 .67602 m .56452 .71457 L .5645 .71296 L p F P
0 g
s
.573 .366 .563 r
.5645 .71296 m .58241 .6776 L .58238 .67602 L p F P
0 g
s
.573 .366 .563 r
.56427 .69313 m .58275 .69735 L .58281 .7009 L p F P
0 g
s
.573 .366 .563 r
.58275 .69735 m .56427 .69313 L .56432 .69688 L p F P
0 g
s
.573 .366 .563 r
.58268 .69358 m .56432 .69688 L .56427 .69313 L p F P
0 g
s
.573 .366 .563 r
.56427 .69313 m .58275 .69735 L .58268 .69358 L p F P
0 g
s
.573 .366 .563 r
.72521 .5458 m .73352 .5647 L .73297 .55609 L p F P
0 g
s
.573 .366 .563 r
.73352 .5647 m .72521 .5458 L .72617 .56134 L p F P
0 g
s
.573 .366 .563 r
.73432 .5772 m .72617 .56134 L .72521 .5458 L p F P
0 g
s
.573 .366 .563 r
.72521 .5458 m .73352 .5647 L .73432 .5772 L p F P
0 g
s
.573 .366 .563 r
.43976 .82162 m .42993 .81673 L .42927 .84138 L p F P
0 g
s
.573 .366 .563 r
.42132 .82865 m .42927 .84138 L .42993 .81673 L p F P
0 g
s
.573 .366 .563 r
.4391 .84867 m .42927 .84138 L .42993 .81673 L p F P
0 g
s
.573 .366 .563 r
.42993 .81673 m .43976 .82162 L .4391 .84867 L p F P
0 g
s
.573 .366 .563 r
.5645 .71296 m .58241 .6776 L .58245 .67989 L p F P
0 g
s
.573 .366 .563 r
.58241 .6776 m .5645 .71296 L .56452 .71457 L p F P
0 g
s
.573 .366 .563 r
.58241 .6776 m .5645 .71296 L .56447 .71064 L p F P
0 g
s
.573 .366 .563 r
.56447 .71064 m .58245 .67989 L .58241 .6776 L p F P
0 g
s
.573 .366 .563 r
.47933 .77807 m .46498 .78554 L .46443 .81724 L p F P
0 g
s
.573 .366 .563 r
.45131 .82185 m .46443 .81724 L .46498 .78554 L p F P
0 g
s
.573 .366 .563 r
.47894 .80788 m .46443 .81724 L .46498 .78554 L p F P
0 g
s
.573 .366 .563 r
.46498 .78554 m .47933 .77807 L .47894 .80788 L p F P
0 g
s
.573 .366 .563 r
.54627 .71137 m .56436 .70067 L .56432 .69688 L p F P
0 g
s
.573 .366 .563 r
.56436 .70067 m .54627 .71137 L .54634 .72226 L p F P
0 g
s
.573 .366 .563 r
.52858 .73918 m .54634 .72226 L .54627 .71137 L p F P
0 g
s
.573 .366 .563 r
.5644 .70435 m .54634 .72226 L .54627 .71137 L p F P
0 g
s
.573 .366 .563 r
.54627 .71137 m .56436 .70067 L .5644 .70435 L p F P
0 g
s
.573 .366 .563 r
.58245 .67989 m .56447 .71064 L .56444 .70772 L p F P
0 g
s
.573 .366 .563 r
.56444 .70772 m .5825 .68277 L .58245 .67989 L p F P
0 g
s
.573 .366 .563 r
.56447 .71064 m .58245 .67989 L .5825 .68277 L p F P
0 g
s
.573 .366 .563 r
.58245 .67989 m .56447 .71064 L .5645 .71296 L p F P
0 g
s
.573 .366 .563 r
.41464 .83381 m .42048 .85741 L .42083 .84557 L p F P
0 g
s
.573 .366 .563 r
.42048 .85741 m .41464 .83381 L .41449 .83857 L p F P
0 g
s
.573 .366 .563 r
.4203 .8635 m .41449 .83857 L .41464 .83381 L p F P
0 g
s
.573 .366 .563 r
.41464 .83381 m .42048 .85741 L .4203 .8635 L p F P
0 g
s
.573 .366 .563 r
.56432 .69688 m .58268 .69358 L .58275 .69735 L p F P
0 g
s
.573 .366 .563 r
.58268 .69358 m .56432 .69688 L .56436 .70067 L p F P
0 g
s
.573 .366 .563 r
.58262 .68978 m .56436 .70067 L .56432 .69688 L p F P
0 g
s
.573 .366 .563 r
.56432 .69688 m .58268 .69358 L .58262 .68978 L p F P
0 g
s
.573 .366 .563 r
.42927 .84138 m .42132 .82865 L .42083 .84557 L p F P
0 g
s
.573 .366 .563 r
.42873 .8612 m .42083 .84557 L .42132 .82865 L p F P
0 g
s
.573 .366 .563 r
.42132 .82865 m .42927 .84138 L .42873 .8612 L p F P
0 g
s
.573 .366 .563 r
.60059 .66824 m .58256 .68612 L .5825 .68277 L p F P
0 g
s
.573 .366 .563 r
.56444 .70772 m .5825 .68277 L .58256 .68612 L p F P
0 g
s
.573 .366 .563 r
.5825 .68277 m .56444 .70772 L .56447 .71064 L p F P
0 g
s
.573 .366 .563 r
.5825 .68277 m .56444 .70772 L .5644 .70435 L p F P
0 g
s
.573 .366 .563 r
.5644 .70435 m .58256 .68612 L .5825 .68277 L p F P
0 g
s
.573 .366 .563 r
.71787 .57302 m .7069 .56912 L .70852 .5982 L p F P
0 g
s
.573 .366 .563 r
.69618 .59973 m .70852 .5982 L .7069 .56912 L p F P
0 g
s
.573 .366 .563 r
.71945 .59979 m .70852 .5982 L .7069 .56912 L p F P
0 g
s
.573 .366 .563 r
.7069 .56912 m .71787 .57302 L .71945 .59979 L p F P
0 g
s
.573 .366 .563 r
.49485 .7676 m .47933 .77807 L .47894 .80788 L p F P
0 g
s
.573 .366 .563 r
.46443 .81724 m .47894 .80788 L .47933 .77807 L p F P
0 g
s
.573 .366 .563 r
.49462 .79409 m .47894 .80788 L .47933 .77807 L p F P
0 g
s
.573 .366 .563 r
.47933 .77807 m .49485 .7676 L .49462 .79409 L p F P
0 g
s
.573 .366 .563 r
.56436 .70067 m .58262 .68978 L .58268 .69358 L p F P
0 g
s
.573 .366 .563 r
.58262 .68978 m .56436 .70067 L .5644 .70435 L p F P
0 g
s
.573 .366 .563 r
.54634 .72226 m .5644 .70435 L .56436 .70067 L p F P
0 g
s
.573 .366 .563 r
.58256 .68612 m .5644 .70435 L .56436 .70067 L p F P
0 g
s
.573 .366 .563 r
.56436 .70067 m .58262 .68978 L .58256 .68612 L p F P
0 g
s
.573 .366 .563 r
.63554 .63606 m .61831 .65136 L .61879 .66869 L p F P
0 g
s
.573 .366 .563 r
.61831 .65136 m .60059 .66824 L .60083 .67901 L p F P
0 g
s
.573 .366 .563 r
.60083 .67901 m .61879 .66869 L .61831 .65136 L p F P
0 g
s
.573 .366 .563 r
.6363 .65912 m .61879 .66869 L .61831 .65136 L p F P
0 g
s
.573 .366 .563 r
.61831 .65136 m .63554 .63606 L .6363 .65912 L p F P
0 g
s
.573 .366 .563 r
.60059 .66824 m .61831 .65136 L .61879 .66869 L p F P
0 g
s
.573 .366 .563 r
.41449 .83857 m .4203 .8635 L .42048 .85741 L p F P
0 g
s
.573 .366 .563 r
.65209 .62288 m .63554 .63606 L .6363 .65912 L p F P
0 g
s
.573 .366 .563 r
.61879 .66869 m .6363 .65912 L .63554 .63606 L p F P
0 g
s
.573 .366 .563 r
.65315 .65057 m .6363 .65912 L .63554 .63606 L p F P
0 g
s
.573 .366 .563 r
.63554 .63606 m .65209 .62288 L .65315 .65057 L p F P
0 g
s
.573 .366 .563 r
.60059 .66824 m .58256 .68612 L .58262 .68978 L p F P
0 g
s
.573 .366 .563 r
.58262 .68978 m .60083 .67901 L .60059 .66824 L p F P
0 g
s
.573 .366 .563 r
.61879 .66869 m .60083 .67901 L .60059 .66824 L p F P
0 g
s
.573 .366 .563 r
.58256 .68612 m .60059 .66824 L .60083 .67901 L p F P
0 g
s
.573 .366 .563 r
.60083 .67901 m .58262 .68978 L .58256 .68612 L p F P
0 g
s
.573 .366 .563 r
.5644 .70435 m .58256 .68612 L .58262 .68978 L p F P
0 g
s
.573 .366 .563 r
.58256 .68612 m .5644 .70435 L .56444 .70772 L p F P
0 g
s
.573 .366 .563 r
.66782 .61223 m .65209 .62288 L .65315 .65057 L p F P
0 g
s
.573 .366 .563 r
.6363 .65912 m .65315 .65057 L .65209 .62288 L p F P
0 g
s
.573 .366 .563 r
.66916 .64328 m .65315 .65057 L .65209 .62288 L p F P
0 g
s
.573 .366 .563 r
.65209 .62288 m .66782 .61223 L .66916 .64328 L p F P
0 g
s
.573 .366 .563 r
.51134 .75448 m .49485 .7676 L .49462 .79409 L p F P
0 g
s
.573 .366 .563 r
.47894 .80788 m .49462 .79409 L .49485 .7676 L p F P
0 g
s
.573 .366 .563 r
.51125 .77639 m .49462 .79409 L .49485 .7676 L p F P
0 g
s
.573 .366 .563 r
.49485 .7676 m .51134 .75448 L .51125 .77639 L p F P
0 g
s
.573 .366 .563 r
.5644 .70435 m .54634 .72226 L .5464 .7323 L p F P
0 g
s
.573 .366 .563 r
.5464 .7323 m .56444 .70772 L .5644 .70435 L p F P
0 g
s
.573 .366 .563 r
.54634 .72226 m .5644 .70435 L .56444 .70772 L p F P
0 g
s
.573 .366 .563 r
.54634 .72226 m .52858 .73918 L .52859 .75551 L p F P
0 g
s
.573 .366 .563 r
.52859 .75551 m .5464 .7323 L .54634 .72226 L p F P
0 g
s
.573 .366 .563 r
.56444 .70772 m .5464 .7323 L .54634 .72226 L p F P
0 g
s
.573 .366 .563 r
.52858 .73918 m .54634 .72226 L .5464 .7323 L p F P
0 g
s
.573 .366 .563 r
.52858 .73918 m .51134 .75448 L .51125 .77639 L p F P
0 g
s
.573 .366 .563 r
.49462 .79409 m .51125 .77639 L .51134 .75448 L p F P
0 g
s
.573 .366 .563 r
.52859 .75551 m .51125 .77639 L .51134 .75448 L p F P
0 g
s
.573 .366 .563 r
.51134 .75448 m .52858 .73918 L .52859 .75551 L p F P
0 g
s
.573 .366 .563 r
.73985 .58227 m .73297 .55609 L .73269 .55169 L p F P
0 g
s
.573 .366 .563 r
.73269 .55169 m .73964 .57917 L .73985 .58227 L p F P
0 g
s
.573 .366 .563 r
.73964 .57917 m .73269 .55169 L .73297 .55609 L p F P
0 g
s
.573 .366 .563 r
.51125 .77639 m .52859 .75551 L .52858 .73918 L p F P
0 g
s
.573 .366 .563 r
.5464 .7323 m .52859 .75551 L .52858 .73918 L p F P
0 g
s
.573 .366 .563 r
.60083 .67901 m .58262 .68978 L .58268 .69358 L p F P
0 g
s
.573 .366 .563 r
.60108 .69024 m .58268 .69358 L .58262 .68978 L p F P
0 g
s
.573 .366 .563 r
.58262 .68978 m .60083 .67901 L .60108 .69024 L p F P
0 g
s
.573 .366 .563 r
.68257 .60444 m .66782 .61223 L .66916 .64328 L p F P
0 g
s
.573 .366 .563 r
.65315 .65057 m .66916 .64328 L .66782 .61223 L p F P
0 g
s
.573 .366 .563 r
.68414 .63743 m .66916 .64328 L .66782 .61223 L p F P
0 g
s
.573 .366 .563 r
.66782 .61223 m .68257 .60444 L .68414 .63743 L p F P
0 g
s
.573 .366 .563 r
.45131 .82185 m .43976 .82162 L .4391 .84867 L p F P
0 g
s
.573 .366 .563 r
.42927 .84138 m .4391 .84867 L .43976 .82162 L p F P
0 g
s
.573 .366 .563 r
.45072 .84997 m .4391 .84867 L .43976 .82162 L p F P
0 g
s
.573 .366 .563 r
.43976 .82162 m .45131 .82185 L .45072 .84997 L p F P
0 g
s
.573 .366 .563 r
.5464 .7323 m .56444 .70772 L .56447 .71064 L p F P
0 g
s
.573 .366 .563 r
.56444 .70772 m .5464 .7323 L .54645 .74101 L p F P
0 g
s
.573 .366 .563 r
.54645 .74101 m .56447 .71064 L .56444 .70772 L p F P
0 g
s
.573 .366 .563 r
.72617 .56134 m .73432 .5772 L .73352 .5647 L p F P
0 g
s
.573 .366 .563 r
.73432 .5772 m .72617 .56134 L .72739 .58113 L p F P
0 g
s
.573 .366 .563 r
.71787 .57302 m .72739 .58113 L .72617 .56134 L p F P
0 g
s
.573 .366 .563 r
.73533 .59308 m .72739 .58113 L .72617 .56134 L p F P
0 g
s
.573 .366 .563 r
.72617 .56134 m .73432 .5772 L .73533 .59308 L p F P
0 g
s
.573 .366 .563 r
.60133 .70142 m .58275 .69735 L .58268 .69358 L p F P
0 g
s
.573 .366 .563 r
.58268 .69358 m .60108 .69024 L .60133 .70142 L p F P
0 g
s
.573 .366 .563 r
.58268 .69358 m .60108 .69024 L .60083 .67901 L p F P
0 g
s
.573 .366 .563 r
.60108 .69024 m .58268 .69358 L .58275 .69735 L p F P
0 g
s
.573 .366 .563 r
.74025 .58835 m .73352 .5647 L .73297 .55609 L p F P
0 g
s
.573 .366 .563 r
.73297 .55609 m .73985 .58227 L .74025 .58835 L p F P
0 g
s
.573 .366 .563 r
.73297 .55609 m .73985 .58227 L .73964 .57917 L p F P
0 g
s
.573 .366 .563 r
.73985 .58227 m .73297 .55609 L .73352 .5647 L p F P
0 g
s
.573 .366 .563 r
.56447 .71064 m .54645 .74101 L .5465 .74796 L p F P
0 g
s
.573 .366 .563 r
.5465 .74796 m .5645 .71296 L .56447 .71064 L p F P
0 g
s
.573 .366 .563 r
.54645 .74101 m .56447 .71064 L .5645 .71296 L p F P
0 g
s
.573 .366 .563 r
.56447 .71064 m .54645 .74101 L .5464 .7323 L p F P
0 g
s
.573 .366 .563 r
.61879 .66869 m .60083 .67901 L .60108 .69024 L p F P
0 g
s
.573 .366 .563 r
.6193 .68684 m .60108 .69024 L .60083 .67901 L p F P
0 g
s
.573 .366 .563 r
.60083 .67901 m .61879 .66869 L .6193 .68684 L p F P
0 g
s
.573 .366 .563 r
.69618 .59973 m .68257 .60444 L .68414 .63743 L p F P
0 g
s
.573 .366 .563 r
.66916 .64328 m .68414 .63743 L .68257 .60444 L p F P
0 g
s
.573 .366 .563 r
.69791 .63314 m .68414 .63743 L .68257 .60444 L p F P
0 g
s
.573 .366 .563 r
.68257 .60444 m .69618 .59973 L .69791 .63314 L p F P
0 g
s
.573 .366 .563 r
.5645 .71296 m .5465 .74796 L .54653 .7528 L p F P
0 g
s
.573 .366 .563 r
.54653 .7528 m .56452 .71457 L .5645 .71296 L p F P
0 g
s
.573 .366 .563 r
.5465 .74796 m .5645 .71296 L .56452 .71457 L p F P
0 g
s
.573 .366 .563 r
.5645 .71296 m .5465 .74796 L .54645 .74101 L p F P
0 g
s
.573 .366 .563 r
.72739 .58113 m .71787 .57302 L .71945 .59979 L p F P
0 g
s
.573 .366 .563 r
.70852 .5982 m .71945 .59979 L .71787 .57302 L p F P
0 g
s
.573 .366 .563 r
.72883 .60438 m .71945 .59979 L .71787 .57302 L p F P
0 g
s
.573 .366 .563 r
.71787 .57302 m .72739 .58113 L .72883 .60438 L p F P
0 g
s
.573 .366 .563 r
.42083 .84557 m .42873 .8612 L .42927 .84138 L p F P
0 g
s
.573 .366 .563 r
.42873 .8612 m .42083 .84557 L .42048 .85741 L p F P
0 g
s
.573 .366 .563 r
.42835 .87508 m .42048 .85741 L .42083 .84557 L p F P
0 g
s
.573 .366 .563 r
.42083 .84557 m .42873 .8612 L .42835 .87508 L p F P
0 g
s
.573 .366 .563 r
.60157 .71201 m .58281 .7009 L .58275 .69735 L p F P
0 g
s
.573 .366 .563 r
.58275 .69735 m .60133 .70142 L .60157 .71201 L p F P
0 g
s
.573 .366 .563 r
.58275 .69735 m .60133 .70142 L .60108 .69024 L p F P
0 g
s
.573 .366 .563 r
.60133 .70142 m .58275 .69735 L .58281 .7009 L p F P
0 g
s
.573 .366 .563 r
.56452 .71457 m .54653 .7528 L .54654 .75528 L p F P
0 g
s
.573 .366 .563 r
.54654 .75528 m .56453 .7154 L .56452 .71457 L p F P
0 g
s
.573 .366 .563 r
.54653 .7528 m .56452 .71457 L .56453 .7154 L p F P
0 g
s
.573 .366 .563 r
.56452 .71457 m .54653 .7528 L .5465 .74796 L p F P
0 g
s
.573 .366 .563 r
.56453 .7154 m .54654 .75528 L .54653 .7528 L p F P
0 g
s
.573 .366 .563 r
.5464 .7323 m .52859 .75551 L .52861 .76972 L p F P
0 g
s
.573 .366 .563 r
.52861 .76972 m .54645 .74101 L .5464 .7323 L p F P
0 g
s
.573 .366 .563 r
.52859 .75551 m .5464 .7323 L .54645 .74101 L p F P
0 g
s
.573 .366 .563 r
.4391 .84867 m .42927 .84138 L .42873 .8612 L p F P
0 g
s
.573 .366 .563 r
.43857 .87044 m .42873 .8612 L .42927 .84138 L p F P
0 g
s
.573 .366 .563 r
.42927 .84138 m .4391 .84867 L .43857 .87044 L p F P
0 g
s
.573 .366 .563 r
.60178 .7215 m .58286 .70407 L .58281 .7009 L p F P
0 g
s
.573 .366 .563 r
.58281 .7009 m .60157 .71201 L .60178 .7215 L p F P
0 g
s
.573 .366 .563 r
.58281 .7009 m .60157 .71201 L .60133 .70142 L p F P
0 g
s
.573 .366 .563 r
.60157 .71201 m .58281 .7009 L .58286 .70407 L p F P
0 g
s
.573 .366 .563 r
.46443 .81724 m .45131 .82185 L .45072 .84997 L p F P
0 g
s
.573 .366 .563 r
.4391 .84867 m .45072 .84997 L .45131 .82185 L p F P
0 g
s
.573 .366 .563 r
.46395 .84506 m .45072 .84997 L .45131 .82185 L p F P
0 g
s
.573 .366 .563 r
.45131 .82185 m .46443 .81724 L .46395 .84506 L p F P
0 g
s
.573 .366 .563 r
.6363 .65912 m .61879 .66869 L .6193 .68684 L p F P
0 g
s
.573 .366 .563 r
.60108 .69024 m .6193 .68684 L .61879 .66869 L p F P
0 g
s
.573 .366 .563 r
.6371 .68335 m .6193 .68684 L .61879 .66869 L p F P
0 g
s
.573 .366 .563 r
.61879 .66869 m .6363 .65912 L .6371 .68335 L p F P
0 g
s
.573 .366 .563 r
.73352 .5647 m .74025 .58835 L .73985 .58227 L p F P
0 g
s
.573 .366 .563 r
.74025 .58835 m .73352 .5647 L .73432 .5772 L p F P
0 g
s
.573 .366 .563 r
.74082 .59715 m .73432 .5772 L .73352 .5647 L p F P
0 g
s
.573 .366 .563 r
.73352 .5647 m .74025 .58835 L .74082 .59715 L p F P
0 g
s
.573 .366 .563 r
.70852 .5982 m .69618 .59973 L .69791 .63314 L p F P
0 g
s
.573 .366 .563 r
.68414 .63743 m .69791 .63314 L .69618 .59973 L p F P
0 g
s
.573 .366 .563 r
.71032 .6305 m .69791 .63314 L .69618 .59973 L p F P
0 g
s
.573 .366 .563 r
.69618 .59973 m .70852 .5982 L .71032 .6305 L p F P
0 g
s
.573 .366 .563 r
.60196 .72942 m .5829 .70671 L .58286 .70407 L p F P
0 g
s
.573 .366 .563 r
.58286 .70407 m .60178 .7215 L .60196 .72942 L p F P
0 g
s
.573 .366 .563 r
.58286 .70407 m .60178 .7215 L .60157 .71201 L p F P
0 g
s
.573 .366 .563 r
.60178 .7215 m .58286 .70407 L .5829 .70671 L p F P
0 g
s
.573 .366 .563 r
.52859 .75551 m .51125 .77639 L .51118 .79551 L p F P
0 g
s
.573 .366 .563 r
.51118 .79551 m .52861 .76972 L .52859 .75551 L p F P
0 g
s
.573 .366 .563 r
.54645 .74101 m .52861 .76972 L .52859 .75551 L p F P
0 g
s
.573 .366 .563 r
.51125 .77639 m .52859 .75551 L .52861 .76972 L p F P
0 g
s
.573 .366 .563 r
.60209 .73539 m .58294 .70869 L .5829 .70671 L p F P
0 g
s
.573 .366 .563 r
.5829 .70671 m .60196 .72942 L .60209 .73539 L p F P
0 g
s
.573 .366 .563 r
.5829 .70671 m .60196 .72942 L .60178 .7215 L p F P
0 g
s
.573 .366 .563 r
.60196 .72942 m .5829 .70671 L .58294 .70869 L p F P
0 g
s
.573 .366 .563 r
.6193 .68684 m .60108 .69024 L .60133 .70142 L p F P
0 g
s
.573 .366 .563 r
.6198 .70497 m .60133 .70142 L .60108 .69024 L p F P
0 g
s
.573 .366 .563 r
.60108 .69024 m .6193 .68684 L .6198 .70497 L p F P
0 g
s
.573 .366 .563 r
.54645 .74101 m .52861 .76972 L .52862 .78108 L p F P
0 g
s
.573 .366 .563 r
.52862 .78108 m .5465 .74796 L .54645 .74101 L p F P
0 g
s
.573 .366 .563 r
.52861 .76972 m .54645 .74101 L .5465 .74796 L p F P
0 g
s
.573 .366 .563 r
.65315 .65057 m .6363 .65912 L .6371 .68335 L p F P
0 g
s
.573 .366 .563 r
.6193 .68684 m .6371 .68335 L .6363 .65912 L p F P
0 g
s
.573 .366 .563 r
.65427 .67976 m .6371 .68335 L .6363 .65912 L p F P
0 g
s
.573 .366 .563 r
.6363 .65912 m .65315 .65057 L .65427 .67976 L p F P
0 g
s
.573 .366 .563 r
.42048 .85741 m .42835 .87508 L .42873 .8612 L p F P
0 g
s
.573 .366 .563 r
.42835 .87508 m .42048 .85741 L .4203 .8635 L p F P
0 g
s
.573 .366 .563 r
.42816 .88223 m .4203 .8635 L .42048 .85741 L p F P
0 g
s
.573 .366 .563 r
.42048 .85741 m .42835 .87508 L .42816 .88223 L p F P
0 g
s
.573 .366 .563 r
.47894 .80788 m .46443 .81724 L .46395 .84506 L p F P
0 g
s
.573 .366 .563 r
.45072 .84997 m .46395 .84506 L .46443 .81724 L p F P
0 g
s
.573 .366 .563 r
.47859 .83402 m .46395 .84506 L .46443 .81724 L p F P
0 g
s
.573 .366 .563 r
.46443 .81724 m .47894 .80788 L .47859 .83402 L p F P
0 g
s
.573 .366 .563 r
.60217 .73909 m .58296 .70992 L .58294 .70869 L p F P
0 g
s
.573 .366 .563 r
.58294 .70869 m .60209 .73539 L .60217 .73909 L p F P
0 g
s
.573 .366 .563 r
.58294 .70869 m .60209 .73539 L .60196 .72942 L p F P
0 g
s
.573 .366 .563 r
.60209 .73539 m .58294 .70869 L .58296 .70992 L p F P
0 g
s
.573 .366 .563 r
.6022 .74035 m .58296 .71033 L .58296 .70992 L p F P
0 g
s
.573 .366 .563 r
.58296 .70992 m .60217 .73909 L .6022 .74035 L p F P
0 g
s
.573 .366 .563 r
.58296 .70992 m .60217 .73909 L .60209 .73539 L p F P
0 g
s
.573 .366 .563 r
.60217 .73909 m .58296 .70992 L .58296 .71033 L p F P
0 g
s
.573 .366 .563 r
.58296 .71033 m .6022 .74035 L .60217 .73909 L p F P
0 g
s
.573 .366 .563 r
.51125 .77639 m .49462 .79409 L .49442 .81727 L p F P
0 g
s
.573 .366 .563 r
.49442 .81727 m .51118 .79551 L .51125 .77639 L p F P
0 g
s
.573 .366 .563 r
.52861 .76972 m .51118 .79551 L .51125 .77639 L p F P
0 g
s
.573 .366 .563 r
.49462 .79409 m .51125 .77639 L .51118 .79551 L p F P
0 g
s
.573 .366 .563 r
.49462 .79409 m .47894 .80788 L .47859 .83402 L p F P
0 g
s
.573 .366 .563 r
.46395 .84506 m .47859 .83402 L .47894 .80788 L p F P
0 g
s
.573 .366 .563 r
.49442 .81727 m .47859 .83402 L .47894 .80788 L p F P
0 g
s
.573 .366 .563 r
.47894 .80788 m .49462 .79409 L .49442 .81727 L p F P
0 g
s
.573 .366 .563 r
.47859 .83402 m .49442 .81727 L .49462 .79409 L p F P
0 g
s
.573 .366 .563 r
.51118 .79551 m .49442 .81727 L .49462 .79409 L p F P
0 g
s
.573 .366 .563 r
.71945 .59979 m .70852 .5982 L .71032 .6305 L p F P
0 g
s
.573 .366 .563 r
.69791 .63314 m .71032 .6305 L .70852 .5982 L p F P
0 g
s
.573 .366 .563 r
.7212 .6295 m .71032 .6305 L .70852 .5982 L p F P
0 g
s
.573 .366 .563 r
.70852 .5982 m .71945 .59979 L .7212 .6295 L p F P
0 g
s
.573 .366 .563 r
.72739 .58113 m .73533 .59308 L .73432 .5772 L p F P
0 g
s
.573 .366 .563 r
.73533 .59308 m .72739 .58113 L .72883 .60438 L p F P
0 g
s
.573 .366 .563 r
.71945 .59979 m .72883 .60438 L .72739 .58113 L p F P
0 g
s
.573 .366 .563 r
.73652 .61168 m .72883 .60438 L .72739 .58113 L p F P
0 g
s
.573 .366 .563 r
.72739 .58113 m .73533 .59308 L .73652 .61168 L p F P
0 g
s
.573 .366 .563 r
.4203 .8635 m .42816 .88223 L .42835 .87508 L p F P
0 g
s
.573 .366 .563 r
.5465 .74796 m .52862 .78108 L .52863 .78901 L p F P
0 g
s
.573 .366 .563 r
.52863 .78901 m .54653 .7528 L .5465 .74796 L p F P
0 g
s
.573 .366 .563 r
.52862 .78108 m .5465 .74796 L .54653 .7528 L p F P
0 g
s
.573 .366 .563 r
.5465 .74796 m .52862 .78108 L .52861 .76972 L p F P
0 g
s
.573 .366 .563 r
.66916 .64328 m .65315 .65057 L .65427 .67976 L p F P
0 g
s
.573 .366 .563 r
.6371 .68335 m .65427 .67976 L .65315 .65057 L p F P
0 g
s
.573 .366 .563 r
.67057 .67608 m .65427 .67976 L .65315 .65057 L p F P
0 g
s
.573 .366 .563 r
.65315 .65057 m .66916 .64328 L .67057 .67608 L p F P
0 g
s
.573 .366 .563 r
.73432 .5772 m .74082 .59715 L .74025 .58835 L p F P
0 g
s
.573 .366 .563 r
.74082 .59715 m .73432 .5772 L .73533 .59308 L p F P
0 g
s
.573 .366 .563 r
.74155 .6083 m .73533 .59308 L .73432 .5772 L p F P
0 g
s
.573 .366 .563 r
.73432 .5772 m .74082 .59715 L .74155 .6083 L p F P
0 g
s
.573 .366 .563 r
.45072 .84997 m .4391 .84867 L .43857 .87044 L p F P
0 g
s
.573 .366 .563 r
.42873 .8612 m .43857 .87044 L .4391 .84867 L p F P
0 g
s
.573 .366 .563 r
.45024 .87262 m .43857 .87044 L .4391 .84867 L p F P
0 g
s
.573 .366 .563 r
.4391 .84867 m .45072 .84997 L .45024 .87262 L p F P
0 g
s
.573 .366 .563 r
.60133 .70142 m .6198 .70497 L .6193 .68684 L p F P
0 g
s
.573 .366 .563 r
.6198 .70497 m .60133 .70142 L .60157 .71201 L p F P
0 g
s
.573 .366 .563 r
.62028 .72222 m .60157 .71201 L .60133 .70142 L p F P
0 g
s
.573 .366 .563 r
.60133 .70142 m .6198 .70497 L .62028 .72222 L p F P
0 g
s
.573 .366 .563 r
.54653 .7528 m .52863 .78901 L .52863 .79309 L p F P
0 g
s
.573 .366 .563 r
.52863 .79309 m .54654 .75528 L .54653 .7528 L p F P
0 g
s
.573 .366 .563 r
.52863 .78901 m .54653 .7528 L .54654 .75528 L p F P
0 g
s
.573 .366 .563 r
.54653 .7528 m .52863 .78901 L .52862 .78108 L p F P
0 g
s
.573 .366 .563 r
.43857 .87044 m .42873 .8612 L .42835 .87508 L p F P
0 g
s
.573 .366 .563 r
.4382 .8857 m .42835 .87508 L .42873 .8612 L p F P
0 g
s
.573 .366 .563 r
.42873 .8612 m .43857 .87044 L .4382 .8857 L p F P
0 g
s
.573 .366 .563 r
.52861 .76972 m .51118 .79551 L .51112 .81085 L p F P
0 g
s
.573 .366 .563 r
.51112 .81085 m .52862 .78108 L .52861 .76972 L p F P
0 g
s
.573 .366 .563 r
.51118 .79551 m .52861 .76972 L .52862 .78108 L p F P
0 g
s
.573 .366 .563 r
.6371 .68335 m .6193 .68684 L .6198 .70497 L p F P
0 g
s
.573 .366 .563 r
.6379 .70765 m .6198 .70497 L .6193 .68684 L p F P
0 g
s
.573 .366 .563 r
.6193 .68684 m .6371 .68335 L .6379 .70765 L p F P
0 g
s
.573 .366 .563 r
.54654 .75528 m .52863 .79309 L .52863 .78901 L p F P
0 g
s
.573 .366 .563 r
.68414 .63743 m .66916 .64328 L .67057 .67608 L p F P
0 g
s
.573 .366 .563 r
.65427 .67976 m .67057 .67608 L .66916 .64328 L p F P
0 g
s
.573 .366 .563 r
.6858 .67231 m .67057 .67608 L .66916 .64328 L p F P
0 g
s
.573 .366 .563 r
.66916 .64328 m .68414 .63743 L .6858 .67231 L p F P
0 g
s
.573 .366 .563 r
.74501 .61257 m .73985 .58227 L .73964 .57917 L p F P
0 g
s
.573 .366 .563 r
.73964 .57917 m .74491 .61095 L .74501 .61257 L p F P
0 g
s
.573 .366 .563 r
.74491 .61095 m .73964 .57917 L .73985 .58227 L p F P
0 g
s
.573 .366 .563 r
.72883 .60438 m .71945 .59979 L .7212 .6295 L p F P
0 g
s
.573 .366 .563 r
.71032 .6305 m .7212 .6295 L .71945 .59979 L p F P
0 g
s
.573 .366 .563 r
.73041 .63011 m .7212 .6295 L .71945 .59979 L p F P
0 g
s
.573 .366 .563 r
.71945 .59979 m .72883 .60438 L .73041 .63011 L p F P
0 g
s
.573 .366 .563 r
.74522 .61574 m .74025 .58835 L .73985 .58227 L p F P
0 g
s
.573 .366 .563 r
.73985 .58227 m .74501 .61257 L .74522 .61574 L p F P
0 g
s
.573 .366 .563 r
.73985 .58227 m .74501 .61257 L .74491 .61095 L p F P
0 g
s
.573 .366 .563 r
.74501 .61257 m .73985 .58227 L .74025 .58835 L p F P
0 g
s
.573 .366 .563 r
.46395 .84506 m .45072 .84997 L .45024 .87262 L p F P
0 g
s
.573 .366 .563 r
.43857 .87044 m .45024 .87262 L .45072 .84997 L p F P
0 g
s
.573 .366 .563 r
.46356 .86746 m .45024 .87262 L .45072 .84997 L p F P
0 g
s
.573 .366 .563 r
.45072 .84997 m .46395 .84506 L .46356 .86746 L p F P
0 g
s
.573 .366 .563 r
.60157 .71201 m .62028 .72222 L .6198 .70497 L p F P
0 g
s
.573 .366 .563 r
.62028 .72222 m .60157 .71201 L .60178 .7215 L p F P
0 g
s
.573 .366 .563 r
.62071 .73774 m .60178 .7215 L .60157 .71201 L p F P
0 g
s
.573 .366 .563 r
.60157 .71201 m .62028 .72222 L .62071 .73774 L p F P
0 g
s
.573 .366 .563 r
.51118 .79551 m .49442 .81727 L .49425 .83589 L p F P
0 g
s
.573 .366 .563 r
.49425 .83589 m .51112 .81085 L .51118 .79551 L p F P
0 g
s
.573 .366 .563 r
.52862 .78108 m .51112 .81085 L .51118 .79551 L p F P
0 g
s
.573 .366 .563 r
.49442 .81727 m .51118 .79551 L .51112 .81085 L p F P
0 g
s
.573 .366 .563 r
.69791 .63314 m .68414 .63743 L .6858 .67231 L p F P
0 g
s
.573 .366 .563 r
.67057 .67608 m .6858 .67231 L .68414 .63743 L p F P
0 g
s
.573 .366 .563 r
.69974 .66848 m .6858 .67231 L .68414 .63743 L p F P
0 g
s
.573 .366 .563 r
.68414 .63743 m .69791 .63314 L .69974 .66848 L p F P
0 g
s
.573 .366 .563 r
.52862 .78108 m .51112 .81085 L .51107 .82157 L p F P
0 g
s
.573 .366 .563 r
.51107 .82157 m .52863 .78901 L .52862 .78108 L p F P
0 g
s
.573 .366 .563 r
.51112 .81085 m .52862 .78108 L .52863 .78901 L p F P
0 g
s
.573 .366 .563 r
.74025 .58835 m .74522 .61574 L .74501 .61257 L p F P
0 g
s
.573 .366 .563 r
.74522 .61574 m .74025 .58835 L .74082 .59715 L p F P
0 g
s
.573 .366 .563 r
.74553 .62031 m .74082 .59715 L .74025 .58835 L p F P
0 g
s
.573 .366 .563 r
.74025 .58835 m .74522 .61574 L .74553 .62031 L p F P
0 g
s
.573 .366 .563 r
.73533 .59308 m .74155 .6083 L .74082 .59715 L p F P
0 g
s
.573 .366 .563 r
.74155 .6083 m .73533 .59308 L .73652 .61168 L p F P
0 g
s
.573 .366 .563 r
.72883 .60438 m .73652 .61168 L .73533 .59308 L p F P
0 g
s
.573 .366 .563 r
.7424 .62132 m .73652 .61168 L .73533 .59308 L p F P
0 g
s
.573 .366 .563 r
.73533 .59308 m .74155 .6083 L .7424 .62132 L p F P
0 g
s
.573 .366 .563 r
.65427 .67976 m .6371 .68335 L .6379 .70765 L p F P
0 g
s
.573 .366 .563 r
.6198 .70497 m .6379 .70765 L .6371 .68335 L p F P
0 g
s
.573 .366 .563 r
.65539 .70912 m .6379 .70765 L .6371 .68335 L p F P
0 g
s
.573 .366 .563 r
.6371 .68335 m .65427 .67976 L .65539 .70912 L p F P
0 g
s
.573 .366 .563 r
.42835 .87508 m .4382 .8857 L .43857 .87044 L p F P
0 g
s
.573 .366 .563 r
.4382 .8857 m .42835 .87508 L .42816 .88223 L p F P
0 g
s
.573 .366 .563 r
.43801 .89357 m .42816 .88223 L .42835 .87508 L p F P
0 g
s
.573 .366 .563 r
.42835 .87508 m .4382 .8857 L .43801 .89357 L p F P
0 g
s
.573 .366 .563 r
.47859 .83402 m .46395 .84506 L .46356 .86746 L p F P
0 g
s
.573 .366 .563 r
.45024 .87262 m .46356 .86746 L .46395 .84506 L p F P
0 g
s
.573 .366 .563 r
.47831 .85505 m .46356 .86746 L .46395 .84506 L p F P
0 g
s
.573 .366 .563 r
.46395 .84506 m .47859 .83402 L .47831 .85505 L p F P
0 g
s
.573 .366 .563 r
.49442 .81727 m .47859 .83402 L .47831 .85505 L p F P
0 g
s
.573 .366 .563 r
.47831 .85505 m .49425 .83589 L .49442 .81727 L p F P
0 g
s
.573 .366 .563 r
.51112 .81085 m .49425 .83589 L .49442 .81727 L p F P
0 g
s
.573 .366 .563 r
.47859 .83402 m .49442 .81727 L .49425 .83589 L p F P
0 g
s
.573 .366 .563 r
.73652 .61168 m .72883 .60438 L .73041 .63011 L p F P
0 g
s
.573 .366 .563 r
.7212 .6295 m .73041 .63011 L .72883 .60438 L p F P
0 g
s
.573 .366 .563 r
.73783 .63221 m .73041 .63011 L .72883 .60438 L p F P
0 g
s
.573 .366 .563 r
.72883 .60438 m .73652 .61168 L .73783 .63221 L p F P
0 g
s
.573 .366 .563 r
.45024 .87262 m .43857 .87044 L .4382 .8857 L p F P
0 g
s
.573 .366 .563 r
.44991 .88851 m .4382 .8857 L .43857 .87044 L p F P
0 g
s
.573 .366 .563 r
.43857 .87044 m .45024 .87262 L .44991 .88851 L p F P
0 g
s
.573 .366 .563 r
.46356 .86746 m .47831 .85505 L .47859 .83402 L p F P
0 g
s
.573 .366 .563 r
.49425 .83589 m .47831 .85505 L .47859 .83402 L p F P
0 g
s
.573 .366 .563 r
.71032 .6305 m .69791 .63314 L .69974 .66848 L p F P
0 g
s
.573 .366 .563 r
.6858 .67231 m .69974 .66848 L .69791 .63314 L p F P
0 g
s
.573 .366 .563 r
.71222 .66464 m .69974 .66848 L .69791 .63314 L p F P
0 g
s
.573 .366 .563 r
.69791 .63314 m .71032 .6305 L .71222 .66464 L p F P
0 g
s
.573 .366 .563 r
.6379 .70765 m .6198 .70497 L .62028 .72222 L p F P
0 g
s
.573 .366 .563 r
.63867 .73084 m .62028 .72222 L .6198 .70497 L p F P
0 g
s
.573 .366 .563 r
.6198 .70497 m .6379 .70765 L .63867 .73084 L p F P
0 g
s
.573 .366 .563 r
.60178 .7215 m .62071 .73774 L .62028 .72222 L p F P
0 g
s
.573 .366 .563 r
.62071 .73774 m .60178 .7215 L .60196 .72942 L p F P
0 g
s
.573 .366 .563 r
.62107 .75074 m .60196 .72942 L .60178 .7215 L p F P
0 g
s
.573 .366 .563 r
.60178 .7215 m .62071 .73774 L .62107 .75074 L p F P
0 g
s
.573 .366 .563 r
.52863 .78901 m .51107 .82157 L .51105 .82708 L p F P
0 g
s
.573 .366 .563 r
.51105 .82708 m .52863 .79309 L .52863 .78901 L p F P
0 g
s
.573 .366 .563 r
.51107 .82157 m .52863 .78901 L .52863 .79309 L p F P
0 g
s
.573 .366 .563 r
.52863 .78901 m .51107 .82157 L .51112 .81085 L p F P
0 g
s
.573 .366 .563 r
.42816 .88223 m .43801 .89357 L .4382 .8857 L p F P
0 g
s
.573 .366 .563 r
.74591 .6261 m .74155 .6083 L .74082 .59715 L p F P
0 g
s
.573 .366 .563 r
.74082 .59715 m .74553 .62031 L .74591 .6261 L p F P
0 g
s
.573 .366 .563 r
.74082 .59715 m .74553 .62031 L .74522 .61574 L p F P
0 g
s
.573 .366 .563 r
.74553 .62031 m .74082 .59715 L .74155 .6083 L p F P
0 g
s
.573 .366 .563 r
.52863 .79309 m .51105 .82708 L .51107 .82157 L p F P
0 g
s
.573 .366 .563 r
.51112 .81085 m .49425 .83589 L .49414 .84893 L p F P
0 g
s
.573 .366 .563 r
.49414 .84893 m .51107 .82157 L .51112 .81085 L p F P
0 g
s
.573 .366 .563 r
.49425 .83589 m .51112 .81085 L .51107 .82157 L p F P
0 g
s
.573 .366 .563 r
.67057 .67608 m .65427 .67976 L .65539 .70912 L p F P
0 g
s
.573 .366 .563 r
.6379 .70765 m .65539 .70912 L .65427 .67976 L p F P
0 g
s
.573 .366 .563 r
.67199 .70913 m .65539 .70912 L .65427 .67976 L p F P
0 g
s
.573 .366 .563 r
.65427 .67976 m .67057 .67608 L .67199 .70913 L p F P
0 g
s
.573 .366 .563 r
.60196 .72942 m .62107 .75074 L .62071 .73774 L p F P
0 g
s
.573 .366 .563 r
.62107 .75074 m .60196 .72942 L .60209 .73539 L p F P
0 g
s
.573 .366 .563 r
.62134 .76054 m .60209 .73539 L .60196 .72942 L p F P
0 g
s
.573 .366 .563 r
.60196 .72942 m .62107 .75074 L .62134 .76054 L p F P
0 g
s
.573 .366 .563 r
.7212 .6295 m .71032 .6305 L .71222 .66464 L p F P
0 g
s
.573 .366 .563 r
.69974 .66848 m .71222 .66464 L .71032 .6305 L p F P
0 g
s
.573 .366 .563 r
.72304 .66086 m .71222 .66464 L .71032 .6305 L p F P
0 g
s
.573 .366 .563 r
.71032 .6305 m .7212 .6295 L .72304 .66086 L p F P
0 g
s
.573 .366 .563 r
.46356 .86746 m .45024 .87262 L .44991 .88851 L p F P
0 g
s
.573 .366 .563 r
.4382 .8857 m .44991 .88851 L .45024 .87262 L p F P
0 g
s
.573 .366 .563 r
.46329 .88317 m .44991 .88851 L .45024 .87262 L p F P
0 g
s
.573 .366 .563 r
.45024 .87262 m .46356 .86746 L .46329 .88317 L p F P
0 g
s
.573 .366 .563 r
.73652 .61168 m .7424 .62132 L .74155 .6083 L p F P
0 g
s
.573 .366 .563 r
.7424 .62132 m .73652 .61168 L .73783 .63221 L p F P
0 g
s
.573 .366 .563 r
.73041 .63011 m .73783 .63221 L .73652 .61168 L p F P
0 g
s
.573 .366 .563 r
.74334 .63564 m .73783 .63221 L .73652 .61168 L p F P
0 g
s
.573 .366 .563 r
.73652 .61168 m .7424 .62132 L .74334 .63564 L p F P
0 g
s
.573 .366 .563 r
.60209 .73539 m .62134 .76054 L .62107 .75074 L p F P
0 g
s
.573 .366 .563 r
.62134 .76054 m .60209 .73539 L .60217 .73909 L p F P
0 g
s
.573 .366 .563 r
.62151 .76665 m .60217 .73909 L .60209 .73539 L p F P
0 g
s
.573 .366 .563 r
.60209 .73539 m .62134 .76054 L .62151 .76665 L p F P
0 g
s
.573 .366 .563 r
.44991 .88851 m .4382 .8857 L .43801 .89357 L p F P
0 g
s
.573 .366 .563 r
.44973 .8967 m .43801 .89357 L .4382 .8857 L p F P
0 g
s
.573 .366 .563 r
.4382 .8857 m .44991 .88851 L .44973 .8967 L p F P
0 g
s
.573 .366 .563 r
.74155 .6083 m .74591 .6261 L .74553 .62031 L p F P
0 g
s
.573 .366 .563 r
.74591 .6261 m .74155 .6083 L .7424 .62132 L p F P
0 g
s
.573 .366 .563 r
.74636 .63283 m .7424 .62132 L .74155 .6083 L p F P
0 g
s
.573 .366 .563 r
.74155 .6083 m .74591 .6261 L .74636 .63283 L p F P
0 g
s
.573 .366 .563 r
.49425 .83589 m .47831 .85505 L .47812 .86979 L p F P
0 g
s
.573 .366 .563 r
.47812 .86979 m .49414 .84893 L .49425 .83589 L p F P
0 g
s
.573 .366 .563 r
.51107 .82157 m .49414 .84893 L .49425 .83589 L p F P
0 g
s
.573 .366 .563 r
.47831 .85505 m .49425 .83589 L .49414 .84893 L p F P
0 g
s
.573 .366 .563 r
.51107 .82157 m .49414 .84893 L .49408 .85564 L p F P
0 g
s
.573 .366 .563 r
.49408 .85564 m .51105 .82708 L .51107 .82157 L p F P
0 g
s
.573 .366 .563 r
.49414 .84893 m .51107 .82157 L .51105 .82708 L p F P
0 g
s
.573 .366 .563 r
.73041 .63011 m .7212 .6295 L .72304 .66086 L p F P
0 g
s
.573 .366 .563 r
.71222 .66464 m .72304 .66086 L .7212 .6295 L p F P
0 g
s
.573 .366 .563 r
.73208 .6572 m .72304 .66086 L .7212 .6295 L p F P
0 g
s
.573 .366 .563 r
.7212 .6295 m .73041 .63011 L .73208 .6572 L p F P
0 g
s
.573 .366 .563 r
.6858 .67231 m .67057 .67608 L .67199 .70913 L p F P
0 g
s
.573 .366 .563 r
.65539 .70912 m .67199 .70913 L .67057 .67608 L p F P
0 g
s
.573 .366 .563 r
.68747 .7075 m .67199 .70913 L .67057 .67608 L p F P
0 g
s
.573 .366 .563 r
.67057 .67608 m .6858 .67231 L .68747 .7075 L p F P
0 g
s
.573 .366 .563 r
.62028 .72222 m .63867 .73084 L .6379 .70765 L p F P
0 g
s
.573 .366 .563 r
.63867 .73084 m .62028 .72222 L .62071 .73774 L p F P
0 g
s
.573 .366 .563 r
.63936 .75177 m .62071 .73774 L .62028 .72222 L p F P
0 g
s
.573 .366 .563 r
.62028 .72222 m .63867 .73084 L .63936 .75177 L p F P
0 g
s
.573 .366 .563 r
.60217 .73909 m .62151 .76665 L .62134 .76054 L p F P
0 g
s
.573 .366 .563 r
.62151 .76665 m .60217 .73909 L .6022 .74035 L p F P
0 g
s
.573 .366 .563 r
.62157 .76872 m .6022 .74035 L .60217 .73909 L p F P
0 g
s
.573 .366 .563 r
.60217 .73909 m .62151 .76665 L .62157 .76872 L p F P
0 g
s
.573 .366 .563 r
.6022 .74035 m .62157 .76872 L .62151 .76665 L p F P
0 g
s
.573 .366 .563 r
.65539 .70912 m .6379 .70765 L .63867 .73084 L p F P
0 g
s
.573 .366 .563 r
.65646 .73722 m .63867 .73084 L .6379 .70765 L p F P
0 g
s
.573 .366 .563 r
.6379 .70765 m .65539 .70912 L .65646 .73722 L p F P
0 g
s
.573 .366 .563 r
.47831 .85505 m .46356 .86746 L .46329 .88317 L p F P
0 g
s
.573 .366 .563 r
.44991 .88851 m .46329 .88317 L .46356 .86746 L p F P
0 g
s
.573 .366 .563 r
.47812 .86979 m .46329 .88317 L .46356 .86746 L p F P
0 g
s
.573 .366 .563 r
.46356 .86746 m .47831 .85505 L .47812 .86979 L p F P
0 g
s
.573 .366 .563 r
.46329 .88317 m .47812 .86979 L .47831 .85505 L p F P
0 g
s
.573 .366 .563 r
.49414 .84893 m .47812 .86979 L .47831 .85505 L p F P
0 g
s
.573 .366 .563 r
.74491 .61095 m .74829 .64565 L .74501 .61257 L closepath p F P
0 g
s
.573 .366 .563 r
.74501 .61257 m .74829 .64565 L .74491 .61095 L closepath p F P
0 g
s
.573 .366 .563 r
.43801 .89357 m .44973 .8967 L .44991 .88851 L p F P
0 g
s
.573 .366 .563 r
.74522 .61574 m .74829 .64565 L .74501 .61257 L closepath p F P
0 g
s
.573 .366 .563 r
.74501 .61257 m .74829 .64565 L .74522 .61574 L closepath p F P
0 g
s
.573 .366 .563 r
.51105 .82708 m .49408 .85564 L .49414 .84893 L p F P
0 g
s
.573 .366 .563 r
.74553 .62031 m .74829 .64565 L .74522 .61574 L closepath p F P
0 g
s
.573 .366 .563 r
.74522 .61574 m .74829 .64565 L .74553 .62031 L closepath p F P
0 g
s
.573 .366 .563 r
.73783 .63221 m .73041 .63011 L .73208 .6572 L p F P
0 g
s
.573 .366 .563 r
.72304 .66086 m .73208 .6572 L .73041 .63011 L p F P
0 g
s
.573 .366 .563 r
.7392 .65375 m .73208 .6572 L .73041 .63011 L p F P
0 g
s
.573 .366 .563 r
.73041 .63011 m .73783 .63221 L .7392 .65375 L p F P
0 g
s
.573 .366 .563 r
.69974 .66848 m .6858 .67231 L .68747 .7075 L p F P
0 g
s
.573 .366 .563 r
.67199 .70913 m .68747 .7075 L .6858 .67231 L p F P
0 g
s
.573 .366 .563 r
.70159 .70415 m .68747 .7075 L .6858 .67231 L p F P
0 g
s
.573 .366 .563 r
.6858 .67231 m .69974 .66848 L .70159 .70415 L p F P
0 g
s
.573 .366 .563 r
.46329 .88317 m .44991 .88851 L .44973 .8967 L p F P
0 g
s
.573 .366 .563 r
.46315 .89127 m .44973 .8967 L .44991 .88851 L p F P
0 g
s
.573 .366 .563 r
.44991 .88851 m .46329 .88317 L .46315 .89127 L p F P
0 g
s
.573 .366 .563 r
.7424 .62132 m .74636 .63283 L .74591 .6261 L p F P
0 g
s
.573 .366 .563 r
.74636 .63283 m .7424 .62132 L .74334 .63564 L p F P
0 g
s
.573 .366 .563 r
.73783 .63221 m .74334 .63564 L .7424 .62132 L p F P
0 g
s
.573 .366 .563 r
.74685 .6402 m .74334 .63564 L .7424 .62132 L p F P
0 g
s
.573 .366 .563 r
.7424 .62132 m .74636 .63283 L .74685 .6402 L p F P
0 g
s
.573 .366 .563 r
.49414 .84893 m .47812 .86979 L .47802 .87738 L p F P
0 g
s
.573 .366 .563 r
.47802 .87738 m .49408 .85564 L .49414 .84893 L p F P
0 g
s
.573 .366 .563 r
.47812 .86979 m .49414 .84893 L .49408 .85564 L p F P
0 g
s
.592 .534 .758 r
.32302 .45906 m .31083 .46282 L .32584 .50225 L p F P
0 g
s
.592 .534 .758 r
.32584 .50225 m .33788 .49816 L .32302 .45906 L p F P
0 g
s
.725 .605 .722 r
.31122 .50696 m .32584 .50225 L .31083 .46282 L p F P
0 g
s
.576 .482 .711 r
.33788 .49816 m .32584 .50225 L .33681 .54277 L p F P
0 g
s
.714 .567 .687 r
.32584 .50225 m .31122 .50696 L .32178 .54609 L p F P
0 g
s
.714 .567 .687 r
.32178 .54609 m .33681 .54277 L .32584 .50225 L p F P
0 g
s
.725 .605 .722 r
.31083 .46282 m .29671 .46892 L .31122 .50696 L p F P
0 g
s
.803 .641 .681 r
.29412 .51228 m .31122 .50696 L .29671 .46892 L p F P
0 g
s
.795 .613 .655 r
.31122 .50696 m .29412 .51228 L .30383 .54831 L p F P
0 g
s
.795 .613 .655 r
.30383 .54831 m .32178 .54609 L .31122 .50696 L p F P
0 g
s
.573 .366 .563 r
.74591 .6261 m .74829 .64565 L .74553 .62031 L closepath p F P
0 g
s
.573 .366 .563 r
.74553 .62031 m .74829 .64565 L .74591 .6261 L closepath p F P
0 g
s
.573 .366 .563 r
.62071 .73774 m .63936 .75177 L .63867 .73084 L p F P
0 g
s
.573 .366 .563 r
.63936 .75177 m .62071 .73774 L .62107 .75074 L p F P
0 g
s
.573 .366 .563 r
.63994 .76936 m .62107 .75074 L .62071 .73774 L p F P
0 g
s
.573 .366 .563 r
.62071 .73774 m .63936 .75177 L .63994 .76936 L p F P
0 g
s
.576 .482 .711 r
.33681 .54277 m .34877 .53834 L .33788 .49816 L p F P
0 g
s
.554 .424 .658 r
.34877 .53834 m .33681 .54277 L .34332 .58293 L p F P
0 g
s
.704 .527 .647 r
.33681 .54277 m .32178 .54609 L .328 .58487 L p F P
0 g
s
.704 .527 .647 r
.328 .58487 m .34332 .58293 L .33681 .54277 L p F P
0 g
s
.573 .366 .563 r
.47812 .86979 m .46329 .88317 L .46315 .89127 L p F P
0 g
s
.573 .366 .563 r
.44973 .8967 m .46315 .89127 L .46329 .88317 L p F P
0 g
s
.573 .366 .563 r
.47802 .87738 m .46315 .89127 L .46329 .88317 L p F P
0 g
s
.573 .366 .563 r
.46329 .88317 m .47812 .86979 L .47802 .87738 L p F P
0 g
s
.573 .366 .563 r
.46315 .89127 m .47802 .87738 L .47812 .86979 L p F P
0 g
s
.573 .366 .563 r
.49408 .85564 m .47802 .87738 L .47812 .86979 L p F P
0 g
s
.573 .366 .563 r
.74334 .63564 m .73783 .63221 L .7392 .65375 L p F P
0 g
s
.573 .366 .563 r
.73208 .6572 m .7392 .65375 L .73783 .63221 L p F P
0 g
s
.573 .366 .563 r
.74432 .65061 m .7392 .65375 L .73783 .63221 L p F P
0 g
s
.573 .366 .563 r
.73783 .63221 m .74334 .63564 L .74432 .65061 L p F P
0 g
s
.604 .583 .803 r
.30472 .42248 m .29231 .42595 L .31083 .46282 L p F P
0 g
s
.604 .583 .803 r
.31083 .46282 m .32302 .45906 L .30472 .42248 L p F P
0 g
s
.738 .643 .754 r
.29671 .46892 m .31083 .46282 L .29231 .42595 L p F P
0 g
s
.79 .586 .625 r
.32178 .54609 m .30383 .54831 L .30946 .58401 L p F P
0 g
s
.79 .586 .625 r
.30946 .58401 m .328 .58487 L .32178 .54609 L p F P
0 g
s
.573 .366 .563 r
.74591 .6261 m .74829 .64565 L .74636 .63283 L closepath p F P
0 g
s
.573 .366 .563 r
.74636 .63283 m .74829 .64565 L .74591 .6261 L closepath p F P
0 g
s
.573 .366 .563 r
.67199 .70913 m .65539 .70912 L .65646 .73722 L p F P
0 g
s
.573 .366 .563 r
.63867 .73084 m .65646 .73722 L .65539 .70912 L p F P
0 g
s
.573 .366 .563 r
.67336 .74085 m .65646 .73722 L .65539 .70912 L p F P
0 g
s
.573 .366 .563 r
.65539 .70912 m .67199 .70913 L .67336 .74085 L p F P
0 g
s
.573 .366 .563 r
.71222 .66464 m .69974 .66848 L .70159 .70415 L p F P
0 g
s
.573 .366 .563 r
.68747 .7075 m .70159 .70415 L .69974 .66848 L p F P
0 g
s
.573 .366 .563 r
.71413 .69909 m .70159 .70415 L .69974 .66848 L p F P
0 g
s
.573 .366 .563 r
.69974 .66848 m .71222 .66464 L .71413 .69909 L p F P
0 g
s
.738 .643 .754 r
.29231 .42595 m .27875 .43336 L .29671 .46892 L p F P
0 g
s
.814 .671 .704 r
.28073 .47726 m .29671 .46892 L .27875 .43336 L p F P
0 g
s
.803 .641 .681 r
.29671 .46892 m .28073 .47726 L .29412 .51228 L p F P
0 g
s
.372 .404 .765 r
.33327 .45763 m .32302 .45906 L .33788 .49816 L p F P
0 g
s
.372 .404 .765 r
.33788 .49816 m .34734 .49471 L .33327 .45763 L p F P
0 g
s
.35 .337 .704 r
.34734 .49471 m .33788 .49816 L .34877 .53834 L p F P
0 g
s
.573 .366 .563 r
.65646 .73722 m .63867 .73084 L .63936 .75177 L p F P
0 g
s
.573 .366 .563 r
.65743 .76266 m .63936 .75177 L .63867 .73084 L p F P
0 g
s
.573 .366 .563 r
.63867 .73084 m .65646 .73722 L .65743 .76266 L p F P
0 g
s
.573 .366 .563 r
.74636 .63283 m .74829 .64565 L .74685 .6402 L closepath p F P
0 g
s
.573 .366 .563 r
.74685 .6402 m .74829 .64565 L .74636 .63283 L closepath p F P
0 g
s
.573 .366 .563 r
.74334 .63564 m .74685 .6402 L .74636 .63283 L p F P
0 g
s
.573 .366 .563 r
.74685 .6402 m .74334 .63564 L .74432 .65061 L p F P
0 g
s
.573 .366 .563 r
.7392 .65375 m .74432 .65061 L .74334 .63564 L p F P
0 g
s
.573 .366 .563 r
.74736 .64788 m .74432 .65061 L .74334 .63564 L p F P
0 g
s
.573 .366 .563 r
.74334 .63564 m .74685 .6402 L .74736 .64788 L p F P
0 g
s
.573 .366 .563 r
.72304 .66086 m .71222 .66464 L .71413 .69909 L p F P
0 g
s
.573 .366 .563 r
.70159 .70415 m .71413 .69909 L .71222 .66464 L p F P
0 g
s
.573 .366 .563 r
.7249 .69243 m .71413 .69909 L .71222 .66464 L p F P
0 g
s
.573 .366 .563 r
.71222 .66464 m .72304 .66086 L .7249 .69243 L p F P
0 g
s
.851 .661 .645 r
.27478 .51813 m .29412 .51228 L .28073 .47726 L p F P
0 g
s
.845 .641 .626 r
.29412 .51228 m .27478 .51813 L .28319 .54946 L p F P
0 g
s
.845 .641 .626 r
.28319 .54946 m .30383 .54831 L .29412 .51228 L p F P
0 g
s
.35 .337 .704 r
.34877 .53834 m .35768 .5328 L .34734 .49471 L p F P
0 g
s
.306 .25 .63 r
.35768 .5328 m .34877 .53834 L .35529 .57814 L p F P
0 g
s
.554 .424 .658 r
.34332 .58293 m .35529 .57814 L .34877 .53834 L p F P
0 g
s
.573 .366 .563 r
.62107 .75074 m .63994 .76936 L .63936 .75177 L p F P
0 g
s
.573 .366 .563 r
.63994 .76936 m .62107 .75074 L .62134 .76054 L p F P
0 g
s
.573 .366 .563 r
.64038 .78266 m .62134 .76054 L .62107 .75074 L p F P
0 g
s
.573 .366 .563 r
.62107 .75074 m .63994 .76936 L .64038 .78266 L p F P
0 g
s
.376 .46 .82 r
.31598 .42294 m .30472 .42248 L .32302 .45906 L p F P
0 g
s
.376 .46 .82 r
.32302 .45906 m .33327 .45763 L .31598 .42294 L p F P
0 g
s
.573 .366 .563 r
.73208 .6572 m .72304 .66086 L .7249 .69243 L p F P
0 g
s
.573 .366 .563 r
.71413 .69909 m .7249 .69243 L .72304 .66086 L p F P
0 g
s
.573 .366 .563 r
.73376 .68441 m .7249 .69243 L .72304 .66086 L p F P
0 g
s
.573 .366 .563 r
.72304 .66086 m .73208 .6572 L .73376 .68441 L p F P
0 g
s
.841 .621 .604 r
.30383 .54831 m .28319 .54946 L .28801 .58047 L p F P
0 g
s
.841 .621 .604 r
.28801 .58047 m .30946 .58401 L .30383 .54831 L p F P
0 g
s
.814 .671 .704 r
.27875 .43336 m .26413 .44458 L .28073 .47726 L p F P
0 g
s
.859 .683 .662 r
.26312 .4877 m .28073 .47726 L .26413 .44458 L p F P
0 g
s
.851 .661 .645 r
.28073 .47726 m .26312 .4877 L .27478 .51813 L p F P
0 g
s
.573 .366 .563 r
.74736 .64788 m .74829 .64565 L .74685 .6402 L closepath p F P
0 g
s
.573 .366 .563 r
.74432 .65061 m .74736 .64788 L .74685 .6402 L p F P
0 g
s
.573 .366 .563 r
.74685 .6402 m .74829 .64565 L .74736 .64788 L closepath p F P
0 g
s
.573 .366 .563 r
.68747 .7075 m .67199 .70913 L .67336 .74085 L p F P
0 g
s
.573 .366 .563 r
.65646 .73722 m .67336 .74085 L .67199 .70913 L p F P
0 g
s
.573 .366 .563 r
.68908 .74132 m .67336 .74085 L .67199 .70913 L p F P
0 g
s
.573 .366 .563 r
.67199 .70913 m .68747 .7075 L .68908 .74132 L p F P
0 g
s
.524 .354 .593 r
.35529 .57814 m .34332 .58293 L .34507 .62124 L p F P
0 g
s
.694 .485 .6 r
.34332 .58293 m .328 .58487 L .32956 .62184 L p F P
0 g
s
.694 .485 .6 r
.32956 .62184 m .34507 .62124 L .34332 .58293 L p F P
0 g
s
.787 .558 .591 r
.328 .58487 m .30946 .58401 L .31075 .61801 L p F P
0 g
s
.787 .558 .591 r
.31075 .61801 m .32956 .62184 L .328 .58487 L p F P
0 g
s
.573 .366 .563 r
.7392 .65375 m .73208 .6572 L .73376 .68441 L p F P
0 g
s
.573 .366 .563 r
.7249 .69243 m .73376 .68441 L .73208 .6572 L p F P
0 g
s
.573 .366 .563 r
.74058 .67532 m .73376 .68441 L .73208 .6572 L p F P
0 g
s
.573 .366 .563 r
.73208 .6572 m .7392 .65375 L .74058 .67532 L p F P
0 g
s
.611 .633 .848 r
.2836 .3898 m .2709 .39302 L .29231 .42595 L p F P
0 g
s
.611 .633 .848 r
.29231 .42595 m .30472 .42248 L .2836 .3898 L p F P
0 g
s
.753 .685 .785 r
.27875 .43336 m .29231 .42595 L .2709 .39302 L p F P
0 g
s
.753 .685 .785 r
.2709 .39302 m .25798 .40165 L .27875 .43336 L p F P
0 g
s
.828 .701 .724 r
.26413 .44458 m .27875 .43336 L .25798 .40165 L p F P
0 g
s
.573 .366 .563 r
.62134 .76054 m .64038 .78266 L .63994 .76936 L p F P
0 g
s
.573 .366 .563 r
.64038 .78266 m .62134 .76054 L .62151 .76665 L p F P
0 g
s
.573 .366 .563 r
.64066 .79095 m .62151 .76665 L .62134 .76054 L p F P
0 g
s
.573 .366 .563 r
.62134 .76054 m .64038 .78266 L .64066 .79095 L p F P
0 g
s
.573 .366 .563 r
.74432 .65061 m .7392 .65375 L .74058 .67532 L p F P
0 g
s
.573 .366 .563 r
.73376 .68441 m .74058 .67532 L .7392 .65375 L p F P
0 g
s
.573 .366 .563 r
.74529 .66554 m .74058 .67532 L .7392 .65375 L p F P
0 g
s
.573 .366 .563 r
.7392 .65375 m .74432 .65061 L .74529 .66554 L p F P
0 g
s
.573 .366 .563 r
.74913 .67452 m .74829 .64565 L .74939 .67856 L closepath p F P
0 g
s
.573 .366 .563 r
.74877 .66914 m .74829 .64565 L .74913 .67452 L closepath p F P
0 g
s
.573 .366 .563 r
.74834 .6627 m .74829 .64565 L .74877 .66914 L closepath p F P
0 g
s
.573 .366 .563 r
.74786 .6555 m .74829 .64565 L .74834 .6627 L closepath p F P
0 g
s
.573 .366 .563 r
.74736 .64788 m .74829 .64565 L .74786 .6555 L closepath p F P
0 g
s
.573 .366 .563 r
.74786 .6555 m .74829 .64565 L .74736 .64788 L closepath p F P
0 g
s
.573 .366 .563 r
.74834 .6627 m .74829 .64565 L .74786 .6555 L closepath p F P
0 g
s
.573 .366 .563 r
.74877 .66914 m .74829 .64565 L .74834 .6627 L closepath p F P
0 g
s
.573 .366 .563 r
.74913 .67452 m .74829 .64565 L .74877 .66914 L closepath p F P
0 g
s
.573 .366 .563 r
.74939 .67856 m .74829 .64565 L .74913 .67452 L closepath p F P
0 g
s
.573 .366 .563 r
.74956 .68106 m .74829 .64565 L .74939 .67856 L closepath p F P
0 g
s
.573 .366 .563 r
.74956 .68106 m .74829 .64565 L .74962 .68191 L closepath p F P
0 g
s
.573 .366 .563 r
.74939 .67856 m .74829 .64565 L .74956 .68106 L closepath p F P
0 g
s
.573 .366 .563 r
.74962 .68191 m .74829 .64565 L .74956 .68106 L closepath p F P
0 g
s
.573 .366 .563 r
.74736 .64788 m .74432 .65061 L .74529 .66554 L p F P
0 g
s
.573 .366 .563 r
.74058 .67532 m .74529 .66554 L .74432 .65061 L p F P
0 g
s
.573 .366 .563 r
.74786 .6555 m .74529 .66554 L .74432 .65061 L p F P
0 g
s
.573 .366 .563 r
.74432 .65061 m .74736 .64788 L .74786 .6555 L p F P
0 g
s
.573 .366 .563 r
.74529 .66554 m .74786 .6555 L .74736 .64788 L p F P
0 g
s
.573 .366 .563 r
.62151 .76665 m .64066 .79095 L .64038 .78266 L p F P
0 g
s
.573 .366 .563 r
.64066 .79095 m .62151 .76665 L .62157 .76872 L p F P
0 g
s
.573 .366 .563 r
.64075 .79377 m .62157 .76872 L .62151 .76665 L p F P
0 g
s
.573 .366 .563 r
.62151 .76665 m .64066 .79095 L .64075 .79377 L p F P
0 g
s
.573 .366 .563 r
.70159 .70415 m .68747 .7075 L .68908 .74132 L p F P
0 g
s
.573 .366 .563 r
.67336 .74085 m .68908 .74132 L .68747 .7075 L p F P
0 g
s
.573 .366 .563 r
.70337 .73843 m .68908 .74132 L .68747 .7075 L p F P
0 g
s
.573 .366 .563 r
.68747 .7075 m .70159 .70415 L .70337 .73843 L p F P
0 g
s
.573 .366 .563 r
.63936 .75177 m .65743 .76266 L .65646 .73722 L p F P
0 g
s
.573 .366 .563 r
.65743 .76266 m .63936 .75177 L .63994 .76936 L p F P
0 g
s
.573 .366 .563 r
.65825 .78408 m .63994 .76936 L .63936 .75177 L p F P
0 g
s
.573 .366 .563 r
.63936 .75177 m .65743 .76266 L .65825 .78408 L p F P
0 g
s
.306 .25 .63 r
.35529 .57814 m .36391 .5705 L .35768 .5328 L p F P
0 g
s
.23 .132 .531 r
.36391 .5705 m .35529 .57814 L .35713 .61608 L p F P
0 g
s
.524 .354 .593 r
.34507 .62124 m .35713 .61608 L .35529 .57814 L p F P
0 g
s
.573 .366 .563 r
.62157 .76872 m .64075 .79377 L .64066 .79095 L p F P
0 g
s
.573 .366 .563 r
.67336 .74085 m .65646 .73722 L .65743 .76266 L p F P
0 g
s
.573 .366 .563 r
.6746 .7696 m .65743 .76266 L .65646 .73722 L p F P
0 g
s
.573 .366 .563 r
.65646 .73722 m .67336 .74085 L .6746 .7696 L p F P
0 g
s
.072 .21 .703 r
.34167 .45845 m .33327 .45763 L .34734 .49471 L p F P
0 g
s
.072 .21 .703 r
.34734 .49471 m .35433 .49185 L .34167 .45845 L p F P
0 g
s
.043 .129 .629 r
.35433 .49185 m .34734 .49471 L .35768 .5328 L p F P
0 g
s
.841 .602 .577 r
.30946 .58401 m .28801 .58047 L .28899 .60996 L p F P
0 g
s
.841 .602 .577 r
.28899 .60996 m .31075 .61801 L .30946 .58401 L p F P
0 g
s
.357 .508 .872 r
.29606 .39199 m .2836 .3898 L .30472 .42248 L p F P
0 g
s
.357 .508 .872 r
.30472 .42248 m .31598 .42294 L .29606 .39199 L p F P
0 g
s
.573 .366 .563 r
.74786 .6555 m .74529 .66554 L .74622 .67971 L p F P
0 g
s
.573 .366 .563 r
.74622 .67971 m .74834 .6627 L .74786 .6555 L p F P
0 g
s
.573 .366 .563 r
.74529 .66554 m .74786 .6555 L .74834 .6627 L p F P
0 g
s
.828 .701 .724 r
.25798 .40165 m .24492 .41551 L .26413 .44458 L p F P
0 g
s
.87 .705 .674 r
.24863 .45936 m .26413 .44458 L .24492 .41551 L p F P
0 g
s
.859 .683 .662 r
.26413 .44458 m .24863 .45936 L .26312 .4877 L p F P
0 g
s
.043 .129 .629 r
.35768 .5328 m .36366 .52615 L .35433 .49185 L p F P
0 g
s
0 .012 .528 r
.36366 .52615 m .35768 .5328 L .36391 .5705 L p F P
0 g
s
.881 .672 .615 r
.25358 .52441 m .27478 .51813 L .26312 .4877 L p F P
0 g
s
.877 .657 .601 r
.27478 .51813 m .25358 .52441 L .26031 .54956 L p F P
0 g
s
.877 .657 .601 r
.26031 .54956 m .28319 .54946 L .27478 .51813 L p F P
0 g
s
.06 .264 .756 r
.32615 .42724 m .31598 .42294 L .33327 .45763 L p F P
0 g
s
.06 .264 .756 r
.33327 .45763 m .34167 .45845 L .32615 .42724 L p F P
0 g
s
.573 .366 .563 r
.71413 .69909 m .70159 .70415 L .70337 .73843 L p F P
0 g
s
.573 .366 .563 r
.68908 .74132 m .70337 .73843 L .70159 .70415 L p F P
0 g
s
.573 .366 .563 r
.71597 .73216 m .70337 .73843 L .70159 .70415 L p F P
0 g
s
.573 .366 .563 r
.70159 .70415 m .71413 .69909 L .71597 .73216 L p F P
0 g
s
.573 .366 .563 r
.74834 .6627 m .74622 .67971 L .74705 .69244 L p F P
0 g
s
.573 .366 .563 r
.74705 .69244 m .74877 .66914 L .74834 .6627 L p F P
0 g
s
.573 .366 .563 r
.74622 .67971 m .74834 .6627 L .74877 .66914 L p F P
0 g
s
.573 .366 .563 r
.74834 .6627 m .74622 .67971 L .74529 .66554 L p F P
0 g
s
.573 .366 .563 r
.74529 .66554 m .74058 .67532 L .74189 .69587 L p F P
0 g
s
.573 .366 .563 r
.74189 .69587 m .74622 .67971 L .74529 .66554 L p F P
0 g
s
.573 .366 .563 r
.74058 .67532 m .74529 .66554 L .74622 .67971 L p F P
0 g
s
.875 .643 .584 r
.28319 .54946 m .26031 .54956 L .26409 .57443 L p F P
0 g
s
.875 .643 .584 r
.26409 .57443 m .28801 .58047 L .28319 .54946 L p F P
0 g
s
.888 .687 .626 r
.24419 .5 m .26312 .4877 L .24863 .45936 L p F P
0 g
s
.881 .672 .615 r
.26312 .4877 m .24419 .5 L .25358 .52441 L p F P
0 g
s
.573 .366 .563 r
.7249 .69243 m .71413 .69909 L .71597 .73216 L p F P
0 g
s
.573 .366 .563 r
.70337 .73843 m .71597 .73216 L .71413 .69909 L p F P
0 g
s
.573 .366 .563 r
.72669 .72271 m .71597 .73216 L .71413 .69909 L p F P
0 g
s
.573 .366 .563 r
.71413 .69909 m .7249 .69243 L .72669 .72271 L p F P
0 g
s
.573 .366 .563 r
.74058 .67532 m .73376 .68441 L .73536 .71043 L p F P
0 g
s
.573 .366 .563 r
.73536 .71043 m .74189 .69587 L .74058 .67532 L p F P
0 g
s
.573 .366 .563 r
.74622 .67971 m .74189 .69587 L .74058 .67532 L p F P
0 g
s
.573 .366 .563 r
.73376 .68441 m .74058 .67532 L .74189 .69587 L p F P
0 g
s
.573 .366 .563 r
.74705 .69244 m .74877 .66914 L .74913 .67452 L p F P
0 g
s
.573 .366 .563 r
.74877 .66914 m .74705 .69244 L .74622 .67971 L p F P
0 g
s
.573 .366 .563 r
.74877 .66914 m .74705 .69244 L .74775 .70309 L p F P
0 g
s
.573 .366 .563 r
.74775 .70309 m .74913 .67452 L .74877 .66914 L p F P
0 g
s
.573 .366 .563 r
.63994 .76936 m .65825 .78408 L .65743 .76266 L p F P
0 g
s
.573 .366 .563 r
.65825 .78408 m .63994 .76936 L .64038 .78266 L p F P
0 g
s
.573 .366 .563 r
.65887 .80031 m .64038 .78266 L .63994 .76936 L p F P
0 g
s
.573 .366 .563 r
.63994 .76936 m .65825 .78408 L .65887 .80031 L p F P
0 g
s
.683 .436 .543 r
.34507 .62124 m .32956 .62184 L .32629 .65556 L p F P
0 g
s
.786 .53 .549 r
.32956 .62184 m .31075 .61801 L .30756 .64895 L p F P
0 g
s
.786 .53 .549 r
.30756 .64895 m .32629 .65556 L .32956 .62184 L p F P
0 g
s
.479 .261 .505 r
.35713 .61608 m .34507 .62124 L .34187 .65619 L p F P
0 g
s
.683 .436 .543 r
.32629 .65556 m .34187 .65619 L .34507 .62124 L p F P
0 g
s
.573 .366 .563 r
.73376 .68441 m .7249 .69243 L .72669 .72271 L p F P
0 g
s
.573 .366 .563 r
.71597 .73216 m .72669 .72271 L .7249 .69243 L p F P
0 g
s
.573 .366 .563 r
.73536 .71043 m .72669 .72271 L .7249 .69243 L p F P
0 g
s
.573 .366 .563 r
.7249 .69243 m .73376 .68441 L .73536 .71043 L p F P
0 g
s
.573 .366 .563 r
.72669 .72271 m .73536 .71043 L .73376 .68441 L p F P
0 g
s
.573 .366 .563 r
.74189 .69587 m .73536 .71043 L .73376 .68441 L p F P
0 g
s
.573 .366 .563 r
.68908 .74132 m .67336 .74085 L .6746 .7696 L p F P
0 g
s
.573 .366 .563 r
.65743 .76266 m .6746 .7696 L .67336 .74085 L p F P
0 g
s
.573 .366 .563 r
.69055 .77201 m .6746 .7696 L .67336 .74085 L p F P
0 g
s
.573 .366 .563 r
.67336 .74085 m .68908 .74132 L .69055 .77201 L p F P
0 g
s
.77 .731 .816 r
.24735 .36541 m .23512 .37512 L .25798 .40165 L p F P
0 g
s
.77 .731 .816 r
.25798 .40165 m .2709 .39302 L .24735 .36541 L p F P
0 g
s
.845 .735 .741 r
.24492 .41551 m .25798 .40165 L .23512 .37512 L p F P
0 g
s
.614 .689 .896 r
.2604 .36239 m .24735 .36541 L .2709 .39302 L p F P
0 g
s
.614 .689 .896 r
.2709 .39302 m .2836 .3898 L .2604 .36239 L p F P
0 g
s
.573 .366 .563 r
.74913 .67452 m .74775 .70309 L .74828 .71111 L p F P
0 g
s
.573 .366 .563 r
.74828 .71111 m .74939 .67856 L .74913 .67452 L p F P
0 g
s
.573 .366 .563 r
.74775 .70309 m .74913 .67452 L .74939 .67856 L p F P
0 g
s
.573 .366 .563 r
.74913 .67452 m .74775 .70309 L .74705 .69244 L p F P
0 g
s
0 .012 .528 r
.36391 .5705 m .36929 .56005 L .36366 .52615 L p F P
0 g
s
0 0 .383 r
.36929 .56005 m .36391 .5705 L .36571 .60638 L p F P
0 g
s
.23 .132 .531 r
.35713 .61608 m .36571 .60638 L .36391 .5705 L p F P
0 g
s
.573 .366 .563 r
.74622 .67971 m .74189 .69587 L .74308 .7144 L p F P
0 g
s
.573 .366 .563 r
.74308 .7144 m .74705 .69244 L .74622 .67971 L p F P
0 g
s
.573 .366 .563 r
.74189 .69587 m .74622 .67971 L .74705 .69244 L p F P
0 g
s
.001 .29 .787 r
.30831 .39943 m .29606 .39199 L .31598 .42294 L p F P
0 g
s
.001 .29 .787 r
.31598 .42294 m .32615 .42724 L .30831 .39943 L p F P
0 g
s
.875 .63 .565 r
.28801 .58047 m .26409 .57443 L .26475 .59801 L p F P
0 g
s
.875 .63 .565 r
.26475 .59801 m .28899 .60996 L .28801 .58047 L p F P
0 g
s
.573 .366 .563 r
.6746 .7696 m .65743 .76266 L .65825 .78408 L p F P
0 g
s
.573 .366 .563 r
.67564 .79386 m .65825 .78408 L .65743 .76266 L p F P
0 g
s
.573 .366 .563 r
.65743 .76266 m .6746 .7696 L .67564 .79386 L p F P
0 g
s
.573 .366 .563 r
.74939 .67856 m .74828 .71111 L .7486 .71611 L p F P
0 g
s
.573 .366 .563 r
.7486 .71611 m .74956 .68106 L .74939 .67856 L p F P
0 g
s
.573 .366 .563 r
.74828 .71111 m .74939 .67856 L .74956 .68106 L p F P
0 g
s
.573 .366 .563 r
.74939 .67856 m .74828 .71111 L .74775 .70309 L p F P
0 g
s
.87 .705 .674 r
.24492 .41551 m .23185 .43423 L .24863 .45936 L p F P
0 g
s
.896 .703 .634 r
.2325 .47731 m .24863 .45936 L .23185 .43423 L p F P
0 g
s
.888 .687 .626 r
.24863 .45936 m .2325 .47731 L .24419 .5 L p F P
0 g
s
.843 .584 .547 r
.31075 .61801 m .28899 .60996 L .28603 .6367 L p F P
0 g
s
.843 .584 .547 r
.28603 .6367 m .30756 .64895 L .31075 .61801 L p F P
0 g
s
.101 0 .382 r
.36571 .60638 m .35713 .61608 L .35409 .65067 L p F P
0 g
s
.479 .261 .505 r
.34187 .65619 m .35409 .65067 L .35713 .61608 L p F P
0 g
s
.573 .366 .563 r
.7486 .71611 m .74956 .68106 L .74962 .68191 L p F P
0 g
s
.573 .366 .563 r
.74956 .68106 m .7486 .71611 L .74828 .71111 L p F P
0 g
s
.573 .366 .563 r
.74956 .68106 m .7486 .71611 L .74871 .7178 L p F P
0 g
s
.573 .366 .563 r
.74871 .7178 m .74962 .68191 L .74956 .68106 L p F P
0 g
s
.573 .366 .563 r
.74962 .68191 m .74871 .7178 L .7486 .71611 L p F P
0 g
s
.573 .366 .563 r
.64038 .78266 m .65887 .80031 L .65825 .78408 L p F P
0 g
s
.573 .366 .563 r
.65887 .80031 m .64038 .78266 L .64066 .79095 L p F P
0 g
s
.573 .366 .563 r
.65926 .81044 m .64066 .79095 L .64038 .78266 L p F P
0 g
s
.573 .366 .563 r
.64038 .78266 m .65887 .80031 L .65926 .81044 L p F P
0 g
s
.845 .735 .741 r
.23512 .37512 m .22378 .39128 L .24492 .41551 L p F P
0 g
s
.884 .728 .683 r
.23185 .43423 m .24492 .41551 L .22378 .39128 L p F P
0 g
s
.304 .545 .917 r
.27423 .36606 m .2604 .36239 L .2836 .3898 L p F P
0 g
s
.304 .545 .917 r
.2836 .3898 m .29606 .39199 L .27423 .36606 L p F P
0 g
s
.573 .366 .563 r
.70337 .73843 m .68908 .74132 L .69055 .77201 L p F P
0 g
s
.573 .366 .563 r
.6746 .7696 m .69055 .77201 L .68908 .74132 L p F P
0 g
s
.573 .366 .563 r
.70498 .76956 m .69055 .77201 L .68908 .74132 L p F P
0 g
s
.573 .366 .563 r
.68908 .74132 m .70337 .73843 L .70498 .76956 L p F P
0 g
s
.573 .366 .563 r
.74189 .69587 m .73536 .71043 L .73681 .73395 L p F P
0 g
s
.573 .366 .563 r
.73681 .73395 m .74308 .7144 L .74189 .69587 L p F P
0 g
s
.573 .366 .563 r
.74705 .69244 m .74308 .7144 L .74189 .69587 L p F P
0 g
s
.573 .366 .563 r
.73536 .71043 m .74189 .69587 L .74308 .7144 L p F P
0 g
s
.573 .366 .563 r
.74705 .69244 m .74308 .7144 L .74407 .72995 L p F P
0 g
s
.573 .366 .563 r
.74407 .72995 m .74775 .70309 L .74705 .69244 L p F P
0 g
s
.573 .366 .563 r
.74308 .7144 m .74705 .69244 L .74775 .70309 L p F P
0 g
s
.573 .366 .563 r
.65939 .81389 m .64075 .79377 L .64066 .79095 L p F P
0 g
s
.573 .366 .563 r
.64066 .79095 m .65926 .81044 L .65939 .81389 L p F P
0 g
s
.573 .366 .563 r
.64066 .79095 m .65926 .81044 L .65887 .80031 L p F P
0 g
s
.573 .366 .563 r
.65926 .81044 m .64066 .79095 L .64075 .79377 L p F P
0 g
s
0 .003 .575 r
.34842 .46138 m .34167 .45845 L .35433 .49185 L p F P
0 g
s
0 .003 .575 r
.35433 .49185 m .35908 .48953 L .34842 .46138 L p F P
0 g
s
0 0 .497 r
.35908 .48953 m .35433 .49185 L .36366 .52615 L p F P
0 g
s
.573 .366 .563 r
.64075 .79377 m .65939 .81389 L .65926 .81044 L p F P
0 g
s
.573 .366 .563 r
.71597 .73216 m .70337 .73843 L .70498 .76956 L p F P
0 g
s
.573 .366 .563 r
.69055 .77201 m .70498 .76956 L .70337 .73843 L p F P
0 g
s
.573 .366 .563 r
.71764 .76218 m .70498 .76956 L .70337 .73843 L p F P
0 g
s
.573 .366 .563 r
.70337 .73843 m .71597 .73216 L .71764 .76218 L p F P
0 g
s
0 0 .497 r
.36366 .52615 m .36695 .51843 L .35908 .48953 L p F P
0 g
s
0 0 .376 r
.36695 .51843 m .36366 .52615 L .36929 .56005 L p F P
0 g
s
.573 .366 .563 r
.73536 .71043 m .72669 .72271 L .7283 .75014 L p F P
0 g
s
.573 .366 .563 r
.7283 .75014 m .73681 .73395 L .73536 .71043 L p F P
0 g
s
.573 .366 .563 r
.74308 .7144 m .73681 .73395 L .73536 .71043 L p F P
0 g
s
.573 .366 .563 r
.72669 .72271 m .73536 .71043 L .73681 .73395 L p F P
0 g
s
0 .05 .617 r
.33538 .43511 m .32615 .42724 L .34167 .45845 L p F P
0 g
s
0 .05 .617 r
.34167 .45845 m .34842 .46138 L .33538 .43511 L p F P
0 g
s
.903 .678 .589 r
.23103 .53097 m .25358 .52441 L .24419 .5 L p F P
0 g
s
.9 .668 .579 r
.25358 .52441 m .23103 .53097 L .23574 .54866 L p F P
0 g
s
.9 .668 .579 r
.23574 .54866 m .26031 .54956 L .25358 .52441 L p F P
0 g
s
.573 .366 .563 r
.65825 .78408 m .67564 .79386 L .6746 .7696 L p F P
0 g
s
.573 .366 .563 r
.67564 .79386 m .65825 .78408 L .65887 .80031 L p F P
0 g
s
.573 .366 .563 r
.67644 .81228 m .65887 .80031 L .65825 .78408 L p F P
0 g
s
.573 .366 .563 r
.65825 .78408 m .67564 .79386 L .67644 .81228 L p F P
0 g
s
.573 .366 .563 r
.69055 .77201 m .6746 .7696 L .67564 .79386 L p F P
0 g
s
.573 .366 .563 r
.69178 .79794 m .67564 .79386 L .6746 .7696 L p F P
0 g
s
.573 .366 .563 r
.6746 .7696 m .69055 .77201 L .69178 .79794 L p F P
0 g
s
.877 .618 .543 r
.28899 .60996 m .26475 .59801 L .26221 .61931 L p F P
0 g
s
.877 .618 .543 r
.26221 .61931 m .28603 .6367 L .28899 .60996 L p F P
0 g
s
.573 .366 .563 r
.72669 .72271 m .71597 .73216 L .71764 .76218 L p F P
0 g
s
.573 .366 .563 r
.70498 .76956 m .71764 .76218 L .71597 .73216 L p F P
0 g
s
.573 .366 .563 r
.7283 .75014 m .71764 .76218 L .71597 .73216 L p F P
0 g
s
.573 .366 .563 r
.71597 .73216 m .72669 .72271 L .7283 .75014 L p F P
0 g
s
.573 .366 .563 r
.74775 .70309 m .74407 .72995 L .74482 .7417 L p F P
0 g
s
.573 .366 .563 r
.74482 .7417 m .74828 .71111 L .74775 .70309 L p F P
0 g
s
.573 .366 .563 r
.74407 .72995 m .74775 .70309 L .74828 .71111 L p F P
0 g
s
.573 .366 .563 r
.74775 .70309 m .74407 .72995 L .74308 .7144 L p F P
0 g
s
.573 .366 .563 r
.71764 .76218 m .7283 .75014 L .72669 .72271 L p F P
0 g
s
.573 .366 .563 r
.73681 .73395 m .7283 .75014 L .72669 .72271 L p F P
0 g
s
.898 .659 .567 r
.26031 .54956 m .23574 .54866 L .23835 .56613 L p F P
0 g
s
.898 .659 .567 r
.23835 .56613 m .26409 .57443 L .26031 .54956 L p F P
0 g
s
.907 .689 .596 r
.22441 .51381 m .24419 .5 L .2325 .47731 L p F P
0 g
s
.903 .678 .589 r
.24419 .5 m .22441 .51381 L .23103 .53097 L p F P
0 g
s
.884 .728 .683 r
.22378 .39128 m .21341 .41341 L .23185 .43423 L p F P
0 g
s
.906 .719 .639 r
.21898 .45729 m .23185 .43423 L .21341 .41341 L p F P
0 g
s
.896 .703 .634 r
.23185 .43423 m .21898 .45729 L .2325 .47731 L p F P
0 g
s
0 0 .383 r
.36571 .60638 m .37095 .59226 L .36929 .56005 L p F P
0 g
s
0 0 .163 r
.37095 .59226 m .36571 .60638 L .36293 .63903 L p F P
0 g
s
.101 0 .382 r
.35409 .65067 m .36293 .63903 L .36571 .60638 L p F P
0 g
s
0 .276 .774 r
.28883 .37621 m .27423 .36606 L .29606 .39199 L p F P
0 g
s
0 .276 .774 r
.29606 .39199 m .30831 .39943 L .28883 .37621 L p F P
0 g
s
.573 .366 .563 r
.74308 .7144 m .73681 .73395 L .73803 .75375 L p F P
0 g
s
.573 .366 .563 r
.73803 .75375 m .74407 .72995 L .74308 .7144 L p F P
0 g
s
.573 .366 .563 r
.73681 .73395 m .74308 .7144 L .74407 .72995 L p F P
0 g
s
.67 .376 .466 r
.34187 .65619 m .32629 .65556 L .31817 .68456 L p F P
0 g
s
.788 .499 .499 r
.32629 .65556 m .30756 .64895 L .29987 .67549 L p F P
0 g
s
.788 .499 .499 r
.29987 .67549 m .31817 .68456 L .32629 .65556 L p F P
0 g
s
.573 .366 .563 r
.74828 .71111 m .74482 .7417 L .74528 .74902 L p F P
0 g
s
.573 .366 .563 r
.74528 .74902 m .7486 .71611 L .74828 .71111 L p F P
0 g
s
.573 .366 .563 r
.74482 .7417 m .74828 .71111 L .7486 .71611 L p F P
0 g
s
.573 .366 .563 r
.74828 .71111 m .74482 .7417 L .74407 .72995 L p F P
0 g
s
.403 .124 .371 r
.35409 .65067 m .34187 .65619 L .33366 .68628 L p F P
0 g
s
.67 .376 .466 r
.31817 .68456 m .33366 .68628 L .34187 .65619 L p F P
0 g
s
0 0 .376 r
.36929 .56005 m .3717 .54695 L .36695 .51843 L p F P
0 g
s
0 0 .202 r
.3717 .54695 m .36929 .56005 L .37095 .59226 L p F P
0 g
s
.791 .784 .845 r
.22251 .3444 m .21101 .355 L .23512 .37512 L p F P
0 g
s
.791 .784 .845 r
.23512 .37512 m .24735 .36541 L .22251 .3444 L p F P
0 g
s
.867 .771 .754 r
.22378 .39128 m .23512 .37512 L .21101 .355 L p F P
0 g
s
.898 .65 .554 r
.26409 .57443 m .23835 .56613 L .23872 .58264 L p F P
0 g
s
.898 .65 .554 r
.23872 .58264 m .26475 .59801 L .26409 .57443 L p F P
0 g
s
0 .056 .614 r
.32044 .41178 m .30831 .39943 L .32615 .42724 L p F P
0 g
s
0 .056 .614 r
.32615 .42724 m .33538 .43511 L .32044 .41178 L p F P
0 g
s
.604 .751 .948 r
.23597 .34151 m .22251 .3444 L .24735 .36541 L p F P
0 g
s
.604 .751 .948 r
.24735 .36541 m .2604 .36239 L .23597 .34151 L p F P
0 g
s
.912 .699 .601 r
.21615 .4979 m .2325 .47731 L .21898 .45729 L p F P
0 g
s
.907 .689 .596 r
.2325 .47731 m .21615 .4979 L .22441 .51381 L p F P
0 g
s
.573 .366 .563 r
.74528 .74902 m .7486 .71611 L .74871 .7178 L p F P
0 g
s
.573 .366 .563 r
.7486 .71611 m .74528 .74902 L .74482 .7417 L p F P
0 g
s
.573 .366 .563 r
.7486 .71611 m .74528 .74902 L .74544 .7515 L p F P
0 g
s
.573 .366 .563 r
.74544 .7515 m .74871 .7178 L .7486 .71611 L p F P
0 g
s
.847 .566 .512 r
.30756 .64895 m .28603 .6367 L .27914 .65952 L p F P
0 g
s
.847 .566 .512 r
.27914 .65952 m .29987 .67549 L .30756 .64895 L p F P
0 g
s
.573 .366 .563 r
.74871 .7178 m .74544 .7515 L .74528 .74902 L p F P
0 g
s
.573 .366 .563 r
.65887 .80031 m .67644 .81228 L .67564 .79386 L p F P
0 g
s
.573 .366 .563 r
.67644 .81228 m .65887 .80031 L .65926 .81044 L p F P
0 g
s
.573 .366 .563 r
.67693 .82378 m .65926 .81044 L .65887 .80031 L p F P
0 g
s
.573 .366 .563 r
.65887 .80031 m .67644 .81228 L .67693 .82378 L p F P
0 g
s
.573 .366 .563 r
.70498 .76956 m .69055 .77201 L .69178 .79794 L p F P
0 g
s
.573 .366 .563 r
.67564 .79386 m .69178 .79794 L .69055 .77201 L p F P
0 g
s
.573 .366 .563 r
.70634 .79585 m .69178 .79794 L .69055 .77201 L p F P
0 g
s
.573 .366 .563 r
.69055 .77201 m .70498 .76956 L .70634 .79585 L p F P
0 g
s
.867 .771 .754 r
.21101 .355 m .2015 .37301 L .22378 .39128 L p F P
0 g
s
.9 .752 .688 r
.21341 .41341 m .22378 .39128 L .2015 .37301 L p F P
0 g
s
0 0 .137 r
.36293 .63903 m .35409 .65067 L .34613 .68042 L p F P
0 g
s
.403 .124 .371 r
.33366 .68628 m .34613 .68042 L .35409 .65067 L p F P
0 g
s
.573 .366 .563 r
.73681 .73395 m .7283 .75014 L .72966 .77326 L p F P
0 g
s
.573 .366 .563 r
.72966 .77326 m .73803 .75375 L .73681 .73395 L p F P
0 g
s
.573 .366 .563 r
.74407 .72995 m .73803 .75375 L .73681 .73395 L p F P
0 g
s
.573 .366 .563 r
.7283 .75014 m .73681 .73395 L .73803 .75375 L p F P
0 g
s
.573 .366 .563 r
.74407 .72995 m .73803 .75375 L .73896 .76873 L p F P
0 g
s
.573 .366 .563 r
.73896 .76873 m .74482 .7417 L .74407 .72995 L p F P
0 g
s
.573 .366 .563 r
.73803 .75375 m .74407 .72995 L .74482 .7417 L p F P
0 g
s
.573 .366 .563 r
.69178 .79794 m .67564 .79386 L .67644 .81228 L p F P
0 g
s
.573 .366 .563 r
.69272 .81763 m .67644 .81228 L .67564 .79386 L p F P
0 g
s
.573 .366 .563 r
.67564 .79386 m .69178 .79794 L .69272 .81763 L p F P
0 g
s
.189 .556 .933 r
.2513 .34636 m .23597 .34151 L .2604 .36239 L p F P
0 g
s
.189 .556 .933 r
.2604 .36239 m .27423 .36606 L .2513 .34636 L p F P
0 g
s
.573 .366 .563 r
.65926 .81044 m .67693 .82378 L .67644 .81228 L p F P
0 g
s
.573 .366 .563 r
.67693 .82378 m .65926 .81044 L .65939 .81389 L p F P
0 g
s
.573 .366 .563 r
.6771 .82769 m .65939 .81389 L .65926 .81044 L p F P
0 g
s
.573 .366 .563 r
.65926 .81044 m .67693 .82378 L .6771 .82769 L p F P
0 g
s
.573 .366 .563 r
.71764 .76218 m .70498 .76956 L .70634 .79585 L p F P
0 g
s
.573 .366 .563 r
.69178 .79794 m .70634 .79585 L .70498 .76956 L p F P
0 g
s
.573 .366 .563 r
.71905 .78752 m .70634 .79585 L .70498 .76956 L p F P
0 g
s
.573 .366 .563 r
.70498 .76956 m .71764 .76218 L .71905 .78752 L p F P
0 g
s
.573 .366 .563 r
.7283 .75014 m .71764 .76218 L .71905 .78752 L p F P
0 g
s
.573 .366 .563 r
.71905 .78752 m .72966 .77326 L .7283 .75014 L p F P
0 g
s
.573 .366 .563 r
.73803 .75375 m .72966 .77326 L .7283 .75014 L p F P
0 g
s
.573 .366 .563 r
.71764 .76218 m .7283 .75014 L .72966 .77326 L p F P
0 g
s
.573 .366 .563 r
.65939 .81389 m .6771 .82769 L .67693 .82378 L p F P
0 g
s
.9 .642 .539 r
.26475 .59801 m .23872 .58264 L .23681 .59747 L p F P
0 g
s
.9 .642 .539 r
.23681 .59747 m .26221 .61931 L .26475 .59801 L p F P
0 g
s
.573 .366 .563 r
.70634 .79585 m .71905 .78752 L .71764 .76218 L p F P
0 g
s
.573 .366 .563 r
.72966 .77326 m .71905 .78752 L .71764 .76218 L p F P
0 g
s
.881 .607 .519 r
.28603 .6367 m .26221 .61931 L .25651 .63737 L p F P
0 g
s
.881 .607 .519 r
.25651 .63737 m .27914 .65952 L .28603 .6367 L p F P
0 g
s
.906 .719 .639 r
.21341 .41341 m .20415 .44081 L .21898 .45729 L p F P
0 g
s
.919 .71 .603 r
.2066 .48394 m .21898 .45729 L .20415 .44081 L p F P
0 g
s
.912 .699 .601 r
.21898 .45729 m .2066 .48394 L .21615 .4979 L p F P
0 g
s
.9 .752 .688 r
.2015 .37301 m .19402 .39785 L .21341 .41341 L p F P
0 g
s
.917 .734 .64 r
.20415 .44081 m .21341 .41341 L .19402 .39785 L p F P
0 g
s
.573 .366 .563 r
.74482 .7417 m .73896 .76873 L .73953 .77808 L p F P
0 g
s
.573 .366 .563 r
.73953 .77808 m .74528 .74902 L .74482 .7417 L p F P
0 g
s
.573 .366 .563 r
.73896 .76873 m .74482 .7417 L .74528 .74902 L p F P
0 g
s
.573 .366 .563 r
.74482 .7417 m .73896 .76873 L .73803 .75375 L p F P
0 g
s
0 0 .202 r
.37095 .59226 m .37312 .57395 L .3717 .54695 L p F P
0 g
s
0 0 0 r
.37312 .57395 m .37095 .59226 L .3685 .62145 L p F P
0 g
s
0 0 .163 r
.36293 .63903 m .3685 .62145 L .37095 .59226 L p F P
0 g
s
0 .015 .545 r
.30417 .39238 m .28883 .37621 L .30831 .39943 L p F P
0 g
s
0 .015 .545 r
.30831 .39943 m .32044 .41178 L .30417 .39238 L p F P
0 g
s
.573 .366 .563 r
.73803 .75375 m .72966 .77326 L .7307 .79081 L p F P
0 g
s
.573 .366 .563 r
.7307 .79081 m .73896 .76873 L .73803 .75375 L p F P
0 g
s
.573 .366 .563 r
.72966 .77326 m .73803 .75375 L .73896 .76873 L p F P
0 g
s
0 0 .443 r
.35379 .46619 m .34842 .46138 L .35908 .48953 L p F P
0 g
s
0 0 .443 r
.35908 .48953 m .36191 .48765 L .35379 .46619 L p F P
0 g
s
0 0 .365 r
.36191 .48765 m .35908 .48953 L .36695 .51843 L p F P
0 g
s
0 0 0 r
.3685 .62145 m .36293 .63903 L .35552 .66703 L p F P
0 g
s
0 0 .137 r
.34613 .68042 m .35552 .66703 L .36293 .63903 L p F P
0 g
s
.573 .366 .563 r
.70634 .79585 m .69178 .79794 L .69272 .81763 L p F P
0 g
s
.573 .366 .563 r
.67644 .81228 m .69272 .81763 L .69178 .79794 L p F P
0 g
s
.573 .366 .563 r
.70738 .81583 m .69272 .81763 L .69178 .79794 L p F P
0 g
s
.573 .366 .563 r
.69178 .79794 m .70634 .79585 L .70738 .81583 L p F P
0 g
s
.573 .366 .563 r
.73953 .77808 m .74528 .74902 L .74544 .7515 L p F P
0 g
s
.573 .366 .563 r
.74528 .74902 m .73953 .77808 L .73896 .76873 L p F P
0 g
s
.573 .366 .563 r
.74528 .74902 m .73953 .77808 L .73973 .78126 L p F P
0 g
s
.573 .366 .563 r
.73973 .78126 m .74544 .7515 L .74528 .74902 L p F P
0 g
s
.573 .366 .563 r
.69272 .81763 m .67644 .81228 L .67693 .82378 L p F P
0 g
s
.573 .366 .563 r
.69331 .82994 m .67693 .82378 L .67644 .81228 L p F P
0 g
s
.573 .366 .563 r
.67644 .81228 m .69272 .81763 L .69331 .82994 L p F P
0 g
s
0 .197 .669 r
.26843 .35866 m .2513 .34636 L .27423 .36606 L p F P
0 g
s
0 .197 .669 r
.27423 .36606 m .28883 .37621 L .26843 .35866 L p F P
0 g
s
0 0 .365 r
.36695 .51843 m .36791 .50968 L .36191 .48765 L p F P
0 g
s
0 0 .24 r
.36791 .50968 m .36695 .51843 L .3717 .54695 L p F P
0 g
s
.573 .366 .563 r
.74544 .7515 m .73973 .78126 L .73953 .77808 L p F P
0 g
s
.919 .682 .565 r
.20783 .5376 m .23103 .53097 L .22441 .51381 L p F P
0 g
s
.917 .676 .559 r
.23103 .53097 m .20783 .5376 L .21027 .5468 L p F P
0 g
s
.917 .676 .559 r
.21027 .5468 m .23574 .54866 L .23103 .53097 L p F P
0 g
s
0 0 .474 r
.34386 .44619 m .33538 .43511 L .34842 .46138 L p F P
0 g
s
0 0 .474 r
.34842 .46138 m .35379 .46619 L .34386 .44619 L p F P
0 g
s
.916 .67 .552 r
.23574 .54866 m .21027 .5468 L .21159 .55588 L p F P
0 g
s
.916 .67 .552 r
.21159 .55588 m .23835 .56613 L .23574 .54866 L p F P
0 g
s
.921 .688 .569 r
.20437 .52869 m .22441 .51381 L .21615 .4979 L p F P
0 g
s
.919 .682 .565 r
.22441 .51381 m .20437 .52869 L .20783 .5376 L p F P
0 g
s
.573 .366 .563 r
.72966 .77326 m .71905 .78752 L .72012 .80677 L p F P
0 g
s
.573 .366 .563 r
.72012 .80677 m .7307 .79081 L .72966 .77326 L p F P
0 g
s
.573 .366 .563 r
.73896 .76873 m .7307 .79081 L .72966 .77326 L p F P
0 g
s
.573 .366 .563 r
.71905 .78752 m .72966 .77326 L .7307 .79081 L p F P
0 g
s
.573 .366 .563 r
.71905 .78752 m .70634 .79585 L .70738 .81583 L p F P
0 g
s
.573 .366 .563 r
.69272 .81763 m .70738 .81583 L .70634 .79585 L p F P
0 g
s
.573 .366 .563 r
.72012 .80677 m .70738 .81583 L .70634 .79585 L p F P
0 g
s
.573 .366 .563 r
.70634 .79585 m .71905 .78752 L .72012 .80677 L p F P
0 g
s
.573 .366 .563 r
.67693 .82378 m .69331 .82994 L .69272 .81763 L p F P
0 g
s
.573 .366 .563 r
.69331 .82994 m .67693 .82378 L .6771 .82769 L p F P
0 g
s
.573 .366 .563 r
.69351 .83412 m .6771 .82769 L .67693 .82378 L p F P
0 g
s
.573 .366 .563 r
.67693 .82378 m .69331 .82994 L .69351 .83412 L p F P
0 g
s
.65 .294 .356 r
.33366 .68628 m .31817 .68456 L .30533 .70744 L p F P
0 g
s
.792 .466 .436 r
.31817 .68456 m .29987 .67549 L .28784 .69633 L p F P
0 g
s
.792 .466 .436 r
.28784 .69633 m .30533 .70744 L .31817 .68456 L p F P
0 g
s
.903 .635 .522 r
.26221 .61931 m .23681 .59747 L .23268 .60994 L p F P
0 g
s
.903 .635 .522 r
.23268 .60994 m .25651 .63737 L .26221 .61931 L p F P
0 g
s
.916 .665 .544 r
.23835 .56613 m .21159 .55588 L .21173 .56442 L p F P
0 g
s
.916 .665 .544 r
.21173 .56442 m .23872 .58264 L .23835 .56613 L p F P
0 g
s
.573 .366 .563 r
.73896 .76873 m .7307 .79081 L .73134 .80176 L p F P
0 g
s
.573 .366 .563 r
.73134 .80176 m .73953 .77808 L .73896 .76873 L p F P
0 g
s
.573 .366 .563 r
.7307 .79081 m .73896 .76873 L .73953 .77808 L p F P
0 g
s
.573 .366 .563 r
.70738 .81583 m .72012 .80677 L .71905 .78752 L p F P
0 g
s
.573 .366 .563 r
.7307 .79081 m .72012 .80677 L .71905 .78752 L p F P
0 g
s
.924 .694 .571 r
.20006 .52044 m .21615 .4979 L .2066 .48394 L p F P
0 g
s
.921 .688 .569 r
.21615 .4979 m .20006 .52044 L .20437 .52869 L p F P
0 g
s
.919 .71 .603 r
.20415 .44081 m .19616 .47254 L .2066 .48394 L p F P
0 g
s
.917 .734 .64 r
.19402 .39785 m .18861 .42864 L .20415 .44081 L p F P
0 g
s
.927 .719 .602 r
.19616 .47254 m .20415 .44081 L .18861 .42864 L p F P
0 g
s
0 0 .24 r
.3717 .54695 m .37153 .53139 L .36791 .50968 L p F P
0 g
s
0 0 .067 r
.37153 .53139 m .3717 .54695 L .37312 .57395 L p F P
0 g
s
.573 .366 .563 r
.6771 .82769 m .69351 .83412 L .69331 .82994 L p F P
0 g
s
.261 0 .143 r
.34613 .68042 m .33366 .68628 L .32059 .71006 L p F P
0 g
s
.65 .294 .356 r
.30533 .70744 m .32059 .71006 L .33366 .68628 L p F P
0 g
s
.854 .549 .472 r
.29987 .67549 m .27914 .65952 L .2685 .67733 L p F P
0 g
s
.854 .549 .472 r
.2685 .67733 m .28784 .69633 L .29987 .67549 L p F P
0 g
s
0 0 .453 r
.33254 .4285 m .32044 .41178 L .33538 .43511 L p F P
0 g
s
0 0 .453 r
.33538 .43511 m .34386 .44619 L .33254 .4285 L p F P
0 g
s
.816 .847 .872 r
.19737 .33114 m .1866 .34239 L .21101 .355 L p F P
0 g
s
.816 .847 .872 r
.21101 .355 m .22251 .3444 L .19737 .33114 L p F P
0 g
s
.892 .81 .76 r
.2015 .37301 m .21101 .355 L .1866 .34239 L p F P
0 g
s
.573 .366 .563 r
.70738 .81583 m .69272 .81763 L .69331 .82994 L p F P
0 g
s
.573 .366 .563 r
.70803 .82831 m .69331 .82994 L .69272 .81763 L p F P
0 g
s
.573 .366 .563 r
.69272 .81763 m .70738 .81583 L .70803 .82831 L p F P
0 g
s
.892 .81 .76 r
.1866 .34239 m .17899 .36172 L .2015 .37301 L p F P
0 g
s
.919 .776 .686 r
.19402 .39785 m .2015 .37301 L .17899 .36172 L p F P
0 g
s
.566 .819 .993 r
.21126 .32832 m .19737 .33114 L .22251 .3444 L p F P
0 g
s
.566 .819 .993 r
.22251 .3444 m .23597 .34151 L .21126 .32832 L p F P
0 g
s
.573 .366 .563 r
.73953 .77808 m .73134 .80176 L .73156 .80549 L p F P
0 g
s
.573 .366 .563 r
.73156 .80549 m .73973 .78126 L .73953 .77808 L p F P
0 g
s
.573 .366 .563 r
.73134 .80176 m .73953 .77808 L .73973 .78126 L p F P
0 g
s
.573 .366 .563 r
.73953 .77808 m .73134 .80176 L .7307 .79081 L p F P
0 g
s
.917 .661 .535 r
.23872 .58264 m .21173 .56442 L .21068 .57204 L p F P
0 g
s
.917 .661 .535 r
.21068 .57204 m .23681 .59747 L .23872 .58264 L p F P
0 g
s
.573 .366 .563 r
.73973 .78126 m .73156 .80549 L .73134 .80176 L p F P
0 g
s
.887 .598 .492 r
.27914 .65952 m .25651 .63737 L .24782 .65132 L p F P
0 g
s
.887 .598 .492 r
.24782 .65132 m .2685 .67733 L .27914 .65952 L p F P
0 g
s
0 0 0 r
.35552 .66703 m .34613 .68042 L .33337 .7039 L p F P
0 g
s
.261 0 .143 r
.32059 .71006 m .33337 .7039 L .34613 .68042 L p F P
0 g
s
.573 .366 .563 r
.7307 .79081 m .72012 .80677 L .72078 .81879 L p F P
0 g
s
.573 .366 .563 r
.72078 .81879 m .73134 .80176 L .7307 .79081 L p F P
0 g
s
.573 .366 .563 r
.72012 .80677 m .7307 .79081 L .73134 .80176 L p F P
0 g
s
.928 .7 .572 r
.19508 .51325 m .2066 .48394 L .19616 .47254 L p F P
0 g
s
.924 .694 .571 r
.2066 .48394 m .19508 .51325 L .20006 .52044 L p F P
0 g
s
0 0 0 r
.3685 .62145 m .37108 .59832 L .37312 .57395 L p F P
0 g
s
0 0 0 r
.35552 .66703 m .36192 .64636 L .3685 .62145 L p F P
0 g
s
.841 .79 .291 r
.37108 .59832 m .3685 .62145 L .36192 .64636 L p F P
0 g
s
.919 .776 .686 r
.17899 .36172 m .1745 .38841 L .19402 .39785 L p F P
0 g
s
.93 .749 .635 r
.18861 .42864 m .19402 .39785 L .1745 .38841 L p F P
0 g
s
.573 .366 .563 r
.72012 .80677 m .70738 .81583 L .70803 .82831 L p F P
0 g
s
.573 .366 .563 r
.69331 .82994 m .70803 .82831 L .70738 .81583 L p F P
0 g
s
.573 .366 .563 r
.72078 .81879 m .70803 .82831 L .70738 .81583 L p F P
0 g
s
.573 .366 .563 r
.70738 .81583 m .72012 .80677 L .72078 .81879 L p F P
0 g
s
.595 .073 0 r
.28724 .37784 m .26843 .35866 L .28883 .37621 L p F P
0 g
s
.595 .073 0 r
.28883 .37621 m .30417 .39238 L .28724 .37784 L p F P
0 g
s
0 .485 .839 r
.22818 .33396 m .21126 .32832 L .23597 .34151 L p F P
0 g
s
0 .485 .839 r
.23597 .34151 m .2513 .34636 L .22818 .33396 L p F P
0 g
s
.573 .366 .563 r
.70803 .82831 m .69331 .82994 L .69351 .83412 L p F P
0 g
s
.573 .366 .563 r
.70825 .83256 m .69351 .83412 L .69331 .82994 L p F P
0 g
s
.573 .366 .563 r
.69331 .82994 m .70803 .82831 L .70825 .83256 L p F P
0 g
s
.573 .366 .563 r
.70803 .82831 m .72078 .81879 L .72012 .80677 L p F P
0 g
s
.573 .366 .563 r
.73134 .80176 m .72078 .81879 L .72012 .80677 L p F P
0 g
s
.658 .551 .722 r
.57052 .39705 m .55551 .40232 L .56897 .44387 L p F P
0 g
s
.658 .551 .722 r
.56897 .44387 m .58416 .43917 L .57052 .39705 L p F P
0 g
s
.744 .599 .695 r
.54883 .44899 m .56897 .44387 L .55551 .40232 L p F P
0 g
s
.644 .505 .679 r
.58416 .43917 m .56897 .44387 L .5789 .48553 L p F P
0 g
s
.734 .561 .658 r
.56897 .44387 m .54883 .44899 L .55813 .48829 L p F P
0 g
s
.734 .561 .658 r
.55813 .48829 m .5789 .48553 L .56897 .44387 L p F P
0 g
s
.672 .596 .763 r
.55384 .35652 m .539 .36235 L .55551 .40232 L p F P
0 g
s
.672 .596 .763 r
.55551 .40232 m .57052 .39705 L .55384 .35652 L p F P
0 g
s
.756 .637 .729 r
.53614 .40981 m .55551 .40232 L .539 .36235 L p F P
0 g
s
.744 .599 .695 r
.55551 .40232 m .53614 .40981 L .54883 .44899 L p F P
0 g
s
.573 .366 .563 r
.69351 .83412 m .70825 .83256 L .70803 .82831 L p F P
0 g
s
0 0 .067 r
.37312 .57395 m .37261 .55186 L .37153 .53139 L p F P
0 g
s
.809 .688 .145 r
.37261 .55186 m .37312 .57395 L .37108 .59832 L p F P
0 g
s
.573 .366 .563 r
.73134 .80176 m .72078 .81879 L .72101 .82288 L p F P
0 g
s
.573 .366 .563 r
.72101 .82288 m .73156 .80549 L .73134 .80176 L p F P
0 g
s
.573 .366 .563 r
.72078 .81879 m .73134 .80176 L .73156 .80549 L p F P
0 g
s
.621 .149 0 r
.32027 .41388 m .30417 .39238 L .32044 .41178 L p F P
0 g
s
.621 .149 0 r
.32044 .41178 m .33254 .4285 L .32027 .41388 L p F P
0 g
s
.474 .441 .741 r
.58109 .39403 m .57052 .39705 L .58416 .43917 L p F P
0 g
s
.474 .441 .741 r
.58416 .43917 m .59432 .43488 L .58109 .39403 L p F P
0 g
s
.45 .379 .686 r
.59432 .43488 m .58416 .43917 L .59428 .48137 L p F P
0 g
s
.644 .505 .679 r
.5789 .48553 m .59428 .48137 L .58416 .43917 L p F P
0 g
s
.789 .623 .674 r
.52392 .45453 m .54883 .44899 L .53614 .40981 L p F P
0 g
s
.781 .59 .641 r
.54883 .44899 m .52392 .45453 L .53216 .48971 L p F P
0 g
s
.781 .59 .641 r
.53216 .48971 m .55813 .48829 L .54883 .44899 L p F P
0 g
s
.487 .495 .791 r
.56496 .35471 m .55384 .35652 L .57052 .39705 L p F P
0 g
s
.487 .495 .791 r
.57052 .39705 m .58109 .39403 L .56496 .35471 L p F P
0 g
s
.756 .637 .729 r
.539 .36235 m .5205 .37216 L .53614 .40981 L p F P
0 g
s
.801 .656 .703 r
.51255 .41944 m .53614 .40981 L .5205 .37216 L p F P
0 g
s
.789 .623 .674 r
.53614 .40981 m .51255 .41944 L .52392 .45453 L p F P
0 g
s
.573 .366 .563 r
.73156 .80549 m .72101 .82288 L .72078 .81879 L p F P
0 g
s
.907 .63 .505 r
.25651 .63737 m .23268 .60994 L .22646 .61946 L p F P
0 g
s
.907 .63 .505 r
.22646 .61946 m .24782 .65132 L .25651 .63737 L p F P
0 g
s
.573 .366 .563 r
.72078 .81879 m .70803 .82831 L .70825 .83256 L p F P
0 g
s
.573 .366 .563 r
.72101 .82288 m .70825 .83256 L .70803 .82831 L p F P
0 g
s
.573 .366 .563 r
.70803 .82831 m .72078 .81879 L .72101 .82288 L p F P
0 g
s
.919 .657 .525 r
.23681 .59747 m .21068 .57204 L .20846 .5784 L p F P
0 g
s
.919 .657 .525 r
.20846 .5784 m .23268 .60994 L .23681 .59747 L p F P
0 g
s
0 0 0 r
.33337 .7039 m .3436 .68902 L .35552 .66703 L p F P
0 g
s
.841 .885 .455 r
.36192 .64636 m .35552 .66703 L .3436 .68902 L p F P
0 g
s
.928 .7 .572 r
.19616 .47254 m .18965 .50743 L .19508 .51325 L p F P
0 g
s
.927 .719 .602 r
.18861 .42864 m .18527 .46425 L .19616 .47254 L p F P
0 g
s
.933 .705 .571 r
.18965 .50743 m .19616 .47254 L .18527 .46425 L p F P
0 g
s
.573 .366 .563 r
.70825 .83256 m .72101 .82288 L .72078 .81879 L p F P
0 g
s
.93 .749 .635 r
.1745 .38841 m .17302 .42144 L .18861 .42864 L p F P
0 g
s
.935 .728 .598 r
.18527 .46425 m .18861 .42864 L .17302 .42144 L p F P
0 g
s
.627 .453 .628 r
.59428 .48137 m .5789 .48553 L .5849 .52577 L p F P
0 g
s
.725 .521 .615 r
.5789 .48553 m .55813 .48829 L .56365 .52623 L p F P
0 g
s
.725 .521 .615 r
.56365 .52623 m .5849 .52577 L .5789 .48553 L p F P
0 g
s
.684 .642 .801 r
.5347 .31906 m .52001 .32545 L .539 .36235 L p F P
0 g
s
.684 .642 .801 r
.539 .36235 m .55384 .35652 L .5347 .31906 L p F P
0 g
s
.771 .677 .76 r
.5205 .37216 m .539 .36235 L .52001 .32545 L p F P
0 g
s
.524 0 0 r
.24796 .34772 m .22818 .33396 L .2513 .34636 L p F P
0 g
s
.524 0 0 r
.2513 .34636 m .26843 .35866 L .24796 .34772 L p F P
0 g
s
.775 .556 .602 r
.55813 .48829 m .53216 .48971 L .53695 .52367 L p F P
0 g
s
.775 .556 .602 r
.53695 .52367 m .56365 .52623 L .55813 .48829 L p F P
0 g
s
.45 .379 .686 r
.59428 .48137 m .60417 .4758 L .59432 .43488 L p F P
0 g
s
.411 .303 .62 r
.60417 .4758 m .59428 .48137 L .60048 .52214 L p F P
0 g
s
.627 .453 .628 r
.5849 .52577 m .60048 .52214 L .59428 .48137 L p F P
0 g
s
.771 .677 .76 r
.52001 .32545 m .50248 .33744 L .5205 .37216 L p F P
0 g
s
.815 .692 .729 r
.49848 .38577 m .5205 .37216 L .50248 .33744 L p F P
0 g
s
.801 .656 .703 r
.5205 .37216 m .49848 .38577 L .51255 .41944 L p F P
0 g
s
.49 .545 .84 r
.54648 .31838 m .5347 .31906 L .55384 .35652 L p F P
0 g
s
.49 .545 .84 r
.55384 .35652 m .56496 .35471 L .54648 .31838 L p F P
0 g
s
.816 .636 .659 r
.4945 .46046 m .52392 .45453 L .51255 .41944 L p F P
0 g
s
.808 .606 .629 r
.52392 .45453 m .4945 .46046 L .50133 .48993 L p F P
0 g
s
.808 .606 .629 r
.50133 .48993 m .53216 .48971 L .52392 .45453 L p F P
0 g
s
.932 .684 .541 r
.18484 .54407 m .20783 .5376 L .20437 .52869 L closepath p F P
0 g
s
.931 .682 .539 r
.18484 .54407 m .21027 .5468 L .20783 .5376 L closepath p F P
0 g
s
.052 .166 .665 r
.58722 .39326 m .58109 .39403 L .59432 .43488 L p F P
0 g
s
.052 .166 .665 r
.59432 .43488 m .59946 .43104 L .58722 .39326 L p F P
0 g
s
.008 .08 .59 r
.59946 .43104 m .59432 .43488 L .60417 .4758 L p F P
0 g
s
.826 .666 .685 r
.48497 .43108 m .51255 .41944 L .49848 .38577 L p F P
0 g
s
.816 .636 .659 r
.51255 .41944 m .48497 .43108 L .4945 .46046 L p F P
0 g
s
0 0 .346 r
.35811 .47256 m .35379 .46619 L .36191 .48765 L p F P
0 g
s
0 0 .346 r
.36191 .48765 m .36324 .48611 L .35811 .47256 L p F P
0 g
s
0 0 .271 r
.36324 .48611 m .36191 .48765 L .36791 .50968 L p F P
0 g
s
.06 .225 .721 r
.57233 .35691 m .56496 .35471 L .58109 .39403 L p F P
0 g
s
.06 .225 .721 r
.58109 .39403 m .58722 .39326 L .57233 .35691 L p F P
0 g
s
.931 .68 .536 r
.18484 .54407 m .21159 .55588 L .21027 .5468 L closepath p F P
0 g
s
.933 .686 .542 r
.18484 .54407 m .20437 .52869 L .20006 .52044 L closepath p F P
0 g
s
0 0 .271 r
.36791 .50968 m .36703 .50002 L .36324 .48611 L p F P
0 g
s
0 0 .15 r
.36703 .50002 m .36791 .50968 L .37153 .53139 L p F P
0 g
s
0 0 .371 r
.35186 .45996 m .34386 .44619 L .35379 .46619 L p F P
0 g
s
0 0 .371 r
.35379 .46619 m .35811 .47256 L .35186 .45996 L p F P
0 g
s
.931 .678 .533 r
.18484 .54407 m .21173 .56442 L .21159 .55588 L closepath p F P
0 g
s
.934 .688 .543 r
.18484 .54407 m .20006 .52044 L .19508 .51325 L closepath p F P
0 g
s
.922 .654 .515 r
.23268 .60994 m .20846 .5784 L .20518 .58318 L p F P
0 g
s
.922 .654 .515 r
.20518 .58318 m .22646 .61946 L .23268 .60994 L p F P
0 g
s
.809 .688 .145 r
.37108 .59832 m .37106 .57022 L .37261 .55186 L p F P
0 g
s
.92 .819 .357 r
.37106 .57022 m .37108 .59832 L .36558 .61897 L p F P
0 g
s
.841 .79 .291 r
.36192 .64636 m .36558 .61897 L .37108 .59832 L p F P
0 g
s
.798 .427 .354 r
.30533 .70744 m .28784 .69633 L .27181 .71034 L p F P
0 g
s
.864 .534 .425 r
.28784 .69633 m .2685 .67733 L .25442 .68914 L p F P
0 g
s
.864 .534 .425 r
.25442 .68914 m .27181 .71034 L .28784 .69633 L p F P
0 g
s
.935 .728 .598 r
.17302 .42144 m .1744 .45948 L .18527 .46425 L p F P
0 g
s
.938 .71 .568 r
.18401 .50327 m .18527 .46425 L .1744 .45948 L p F P
0 g
s
.933 .705 .571 r
.18527 .46425 m .18401 .50327 L .18965 .50743 L p F P
0 g
s
.611 .174 .185 r
.32059 .71006 m .30533 .70744 L .28812 .72292 L p F P
0 g
s
.798 .427 .354 r
.27181 .71034 m .28812 .72292 L .30533 .70744 L p F P
0 g
s
.721 .216 0 r
.30757 .40303 m .28724 .37784 L .30417 .39238 L p F P
0 g
s
.721 .216 0 r
.30417 .39238 m .32027 .41388 L .30757 .40303 L p F P
0 g
s
.804 .576 .593 r
.53216 .48971 m .50133 .48993 L .50518 .51833 L p F P
0 g
s
.804 .576 .593 r
.50518 .51833 m .53695 .52367 L .53216 .48971 L p F P
0 g
s
.946 .9 .51 r
.36558 .61897 m .36192 .64636 L .35133 .66578 L p F P
0 g
s
.841 .885 .455 r
.3436 .68902 m .35133 .66578 L .36192 .64636 L p F P
0 g
s
.895 .591 .463 r
.2685 .67733 m .24782 .65132 L .23643 .66041 L p F P
0 g
s
.895 .591 .463 r
.23643 .66041 m .25442 .68914 L .2685 .67733 L p F P
0 g
s
.815 .692 .729 r
.50248 .33744 m .48222 .35481 L .49848 .38577 L p F P
0 g
s
.839 .699 .708 r
.47312 .40292 m .49848 .38577 L .48222 .35481 L p F P
0 g
s
.826 .666 .685 r
.49848 .38577 m .47312 .40292 L .48497 .43108 L p F P
0 g
s
.931 .677 .53 r
.18484 .54407 m .21068 .57204 L .21173 .56442 L closepath p F P
0 g
s
.921 .851 .756 r
.16296 .33821 m .15723 .35819 L .17899 .36172 L p F P
0 g
s
.921 .851 .756 r
.17899 .36172 m .1866 .34239 L .16296 .33821 L p F P
0 g
s
.94 .798 .676 r
.1745 .38841 m .17899 .36172 L .15723 .35819 L p F P
0 g
s
.008 .08 .59 r
.60417 .4758 m .60858 .46886 L .59946 .43104 L p F P
0 g
s
0 0 .487 r
.60858 .46886 m .60417 .4758 L .61025 .5153 L p F P
0 g
s
.411 .303 .62 r
.60048 .52214 m .61025 .5153 L .60417 .4758 L p F P
0 g
s
.935 .69 .543 r
.18484 .54407 m .19508 .51325 L .18965 .50743 L closepath p F P
0 g
s
0 0 .15 r
.37153 .53139 m .36931 .51369 L .36703 .50002 L p F P
0 g
s
.763 .585 .014 r
.36931 .51369 m .37153 .53139 L .37261 .55186 L p F P
0 g
s
.606 .392 .564 r
.60048 .52214 m .5849 .52577 L .58668 .56309 L p F P
0 g
s
.716 .477 .562 r
.5849 .52577 m .56365 .52623 L .56511 .56138 L p F P
0 g
s
.716 .477 .562 r
.56511 .56138 m .58668 .56309 L .5849 .52577 L p F P
0 g
s
.839 .92 .888 r
.173 .3266 m .16296 .33821 L .1866 .34239 L p F P
0 g
s
.839 .92 .888 r
.1866 .34239 m .19737 .33114 L .173 .3266 L p F P
0 g
s
.03 .26 .76 r
.55531 .32335 m .54648 .31838 L .56496 .35471 L p F P
0 g
s
.03 .26 .76 r
.56496 .35471 m .57233 .35691 L .55531 .32335 L p F P
0 g
s
0 0 0 r
.33337 .7039 m .32059 .71006 L .30298 .72618 L p F P
0 g
s
.611 .174 .185 r
.28812 .72292 m .30298 .72618 L .32059 .71006 L p F P
0 g
s
.63 .207 0 r
.34476 .44886 m .33254 .4285 L .34386 .44619 L p F P
0 g
s
.63 .207 0 r
.34386 .44619 m .35186 .45996 L .34476 .44886 L p F P
0 g
s
.716 .184 0 r
.27033 .36892 m .24796 .34772 L .26843 .35866 L p F P
0 g
s
.716 .184 0 r
.26843 .35866 m .28724 .37784 L .27033 .36892 L p F P
0 g
s
.94 .798 .676 r
.15723 .35819 m .15569 .38573 L .1745 .38841 L p F P
0 g
s
.944 .761 .625 r
.17302 .42144 m .1745 .38841 L .15569 .38573 L p F P
0 g
s
.698 .692 .841 r
.51375 .28613 m .49919 .29304 L .52001 .32545 L p F P
0 g
s
.698 .692 .841 r
.52001 .32545 m .5347 .31906 L .51375 .28613 L p F P
0 g
s
.788 .721 .789 r
.50248 .33744 m .52001 .32545 L .49919 .29304 L p F P
0 g
s
.771 .521 .556 r
.56365 .52623 m .53695 .52367 L .53802 .55505 L p F P
0 g
s
.771 .521 .556 r
.53802 .55505 m .56511 .56138 L .56365 .52623 L p F P
0 g
s
.913 .627 .487 r
.24782 .65132 m .22646 .61946 L .2184 .62554 L p F P
0 g
s
.913 .627 .487 r
.2184 .62554 m .23643 .66041 L .24782 .65132 L p F P
0 g
s
.439 .847 .968 r
.18735 .32377 m .173 .3266 L .19737 .33114 L p F P
0 g
s
.439 .847 .968 r
.19737 .33114 m .21126 .32832 L .18735 .32377 L p F P
0 g
s
.35 .2 .532 r
.61025 .5153 m .60048 .52214 L .60244 .55993 L p F P
0 g
s
.606 .392 .564 r
.58668 .56309 m .60244 .55993 L .60048 .52214 L p F P
0 g
s
.788 .721 .789 r
.49919 .29304 m .48269 .30705 L .50248 .33744 L p F P
0 g
s
.832 .73 .752 r
.48222 .35481 m .50248 .33744 L .48269 .30705 L p F P
0 g
s
.932 .676 .527 r
.18484 .54407 m .20846 .5784 L .21068 .57204 L closepath p F P
0 g
s
.937 .692 .542 r
.18484 .54407 m .18965 .50743 L .18401 .50327 L closepath p F P
0 g
s
.944 .761 .625 r
.15569 .38573 m .15808 .41966 L .17302 .42144 L p F P
0 g
s
.944 .735 .59 r
.1744 .45948 m .17302 .42144 L .15808 .41966 L p F P
0 g
s
.479 .593 .889 r
.5263 .28646 m .51375 .28613 L .5347 .31906 L p F P
0 g
s
.479 .593 .889 r
.5347 .31906 m .54648 .31838 L .5263 .28646 L p F P
0 g
s
0 0 0 r
.30298 .72618 m .31614 .71978 L .33337 .7039 L p F P
0 g
s
.758 .952 .635 r
.3436 .68902 m .33337 .7039 L .31614 .71978 L p F P
0 g
s
.831 .643 .648 r
.461 .46679 m .4945 .46046 L .48497 .43108 L p F P
0 g
s
.825 .616 .62 r
.4945 .46046 m .461 .46679 L .46611 .48911 L p F P
0 g
s
.825 .616 .62 r
.46611 .48911 m .50133 .48993 L .4945 .46046 L p F P
0 g
s
.841 .672 .673 r
.45378 .44453 m .48497 .43108 L .47312 .40292 L p F P
0 g
s
.831 .643 .648 r
.48497 .43108 m .45378 .44453 L .461 .46679 L p F P
0 g
s
.763 .585 .014 r
.37261 .55186 m .36999 .52653 L .36931 .51369 L p F P
0 g
s
.871 .722 .204 r
.36999 .52653 m .37261 .55186 L .37106 .57022 L p F P
0 g
s
.341 0 0 r
.20588 .32976 m .18735 .32377 L .21126 .32832 L p F P
0 g
s
.341 0 0 r
.21126 .32832 m .22818 .33396 L .20588 .32976 L p F P
0 g
s
0 0 .323 r
.58897 .39469 m .58722 .39326 L .59946 .43104 L p F P
0 g
s
0 0 .323 r
.59946 .43104 m .59964 .42766 L .58897 .39469 L p F P
0 g
s
0 0 .244 r
.59964 .42766 m .59946 .43104 L .60858 .46886 L p F P
0 g
s
.925 .653 .505 r
.22646 .61946 m .20518 .58318 L .20098 .58616 L p F P
0 g
s
.925 .653 .505 r
.20098 .58616 m .2184 .62554 L .22646 .61946 L p F P
0 g
s
0 0 .364 r
.57598 .36298 m .57233 .35691 L .58722 .39326 L p F P
0 g
s
0 0 .364 r
.58722 .39326 m .58897 .39469 L .57598 .36298 L p F P
0 g
s
.706 .237 0 r
.3371 .43976 m .32027 .41388 L .33254 .4285 L p F P
0 g
s
.706 .237 0 r
.33254 .4285 m .34476 .44886 L .3371 .43976 L p F P
0 g
s
.802 .546 .55 r
.53695 .52367 m .50518 .51833 L .50584 .5445 L p F P
0 g
s
.802 .546 .55 r
.50584 .5445 m .53802 .55505 L .53695 .52367 L p F P
0 g
s
.933 .675 .524 r
.18484 .54407 m .20518 .58318 L .20846 .5784 L closepath p F P
0 g
s
.944 .735 .59 r
.15808 .41966 m .16404 .45853 L .1744 .45948 L p F P
0 g
s
.942 .713 .563 r
.17842 .50095 m .1744 .45948 L .16404 .45853 L p F P
0 g
s
.938 .71 .568 r
.1744 .45948 m .17842 .50095 L .18401 .50327 L p F P
0 g
s
.938 .693 .541 r
.18484 .54407 m .18401 .50327 L .17842 .50095 L closepath p F P
0 g
s
.832 .73 .752 r
.48269 .30705 m .46435 .3278 L .48222 .35481 L p F P
0 g
s
.856 .733 .726 r
.45939 .37712 m .48222 .35481 L .46435 .3278 L p F P
0 g
s
.839 .699 .708 r
.48222 .35481 m .45939 .37712 L .47312 .40292 L p F P
0 g
s
.821 .588 .586 r
.50133 .48993 m .46611 .48911 L .46888 .51059 L p F P
0 g
s
.821 .588 .586 r
.46888 .51059 m .50518 .51833 L .50133 .48993 L p F P
0 g
s
0 0 .487 r
.61025 .5153 m .61423 .50531 L .60858 .46886 L p F P
0 g
s
0 0 .338 r
.61423 .50531 m .61025 .5153 L .61225 .55186 L p F P
0 g
s
.35 .2 .532 r
.60244 .55993 m .61225 .55186 L .61025 .5153 L p F P
0 g
s
.854 .702 .693 r
.44474 .42324 m .47312 .40292 L .45939 .37712 L p F P
0 g
s
.841 .672 .673 r
.47312 .40292 m .44474 .42324 L .45378 .44453 L p F P
0 g
s
.937 .96 .663 r
.35133 .66578 m .3436 .68902 L .32749 .70377 L p F P
0 g
s
.758 .952 .635 r
.31614 .71978 m .32749 .70377 L .3436 .68902 L p F P
0 g
s
0 .267 .774 r
.53676 .29393 m .5263 .28646 L .54648 .31838 L p F P
0 g
s
0 .267 .774 r
.54648 .31838 m .55531 .32335 L .53676 .29393 L p F P
0 g
s
0 0 .244 r
.60858 .46886 m .6076 .46065 L .59964 .42766 L p F P
0 g
s
0 0 .129 r
.6076 .46065 m .60858 .46886 L .61423 .50531 L p F P
0 g
s
.92 .819 .357 r
.36558 .61897 m .3669 .58565 L .37106 .57022 L p F P
0 g
s
.977 .887 .525 r
.3669 .58565 m .36558 .61897 L .35677 .6349 L p F P
0 g
s
.946 .9 .51 r
.35133 .66578 m .35677 .6349 L .36558 .61897 L p F P
0 g
s
0 0 .366 r
.56117 .33377 m .55531 .32335 L .57233 .35691 L p F P
0 g
s
0 0 .366 r
.57233 .35691 m .57598 .36298 L .56117 .33377 L p F P
0 g
s
.674 .127 0 r
.22831 .34417 m .20588 .32976 L .22818 .33396 L p F P
0 g
s
.674 .127 0 r
.22818 .33396 m .24796 .34772 L .22831 .34417 L p F P
0 g
s
.934 .675 .521 r
.18484 .54407 m .20098 .58616 L .20518 .58318 L closepath p F P
0 g
s
.791 .293 0 r
.29498 .39651 m .27033 .36892 L .28724 .37784 L p F P
0 g
s
.791 .293 0 r
.28724 .37784 m .30757 .40303 L .29498 .39651 L p F P
0 g
s
.942 .713 .563 r
.16404 .45853 m .17314 .50062 L .17842 .50095 L p F P
0 g
s
.94 .694 .539 r
.18484 .54407 m .17842 .50095 L .17314 .50062 L closepath p F P
0 g
s
.576 .312 .478 r
.60244 .55993 m .58668 .56309 L .58402 .59594 L p F P
0 g
s
.708 .425 .494 r
.58668 .56309 m .56511 .56138 L .56234 .59228 L p F P
0 g
s
.708 .425 .494 r
.56234 .59228 m .58402 .59594 L .58668 .56309 L p F P
0 g
s
.871 .722 .204 r
.37106 .57022 m .369 .53797 L .36999 .52653 L p F P
0 g
s
.951 .825 .386 r
.369 .53797 m .37106 .57022 L .3669 .58565 L p F P
0 g
s
.77 .481 .497 r
.56511 .56138 m .53802 .55505 L .53524 .58256 L p F P
0 g
s
.77 .481 .497 r
.53524 .58256 m .56234 .59228 L .56511 .56138 L p F P
0 g
s
.778 .289 0 r
.32923 .43309 m .30757 .40303 L .32027 .41388 L p F P
0 g
s
.778 .289 0 r
.32027 .41388 m .3371 .43976 L .32923 .43309 L p F P
0 g
s
.71 .749 .883 r
.49174 .25916 m .47728 .26653 L .49919 .29304 L p F P
0 g
s
.71 .749 .883 r
.49919 .29304 m .51375 .28613 L .49174 .25916 L p F P
0 g
s
.81 .771 .817 r
.48269 .30705 m .49919 .29304 L .47728 .26653 L p F P
0 g
s
.82 .561 .546 r
.50518 .51833 m .46888 .51059 L .46918 .5303 L p F P
0 g
s
.82 .561 .546 r
.46918 .5303 m .50584 .5445 L .50518 .51833 L p F P
0 g
s
.81 .771 .817 r
.47728 .26653 m .46186 .28228 L .48269 .30705 L p F P
0 g
s
.854 .773 .771 r
.46435 .3278 m .48269 .30705 L .46186 .28228 L p F P
0 g
s
.92 .626 .469 r
.23643 .66041 m .2184 .62554 L .20884 .62781 L p F P
0 g
s
.929 .653 .496 r
.2184 .62554 m .20098 .58616 L .19603 .58717 L p F P
0 g
s
.929 .653 .496 r
.19603 .58717 m .20884 .62781 L .2184 .62554 L p F P
0 g
s
.905 .586 .432 r
.25442 .68914 m .23643 .66041 L .2228 .66408 L p F P
0 g
s
.92 .626 .469 r
.20884 .62781 m .2228 .66408 L .23643 .66041 L p F P
0 g
s
.856 .733 .726 r
.46435 .3278 m .4443 .35474 L .45939 .37712 L p F P
0 g
s
.87 .734 .709 r
.43424 .40381 m .45939 .37712 L .4443 .35474 L p F P
0 g
s
.854 .702 .693 r
.45939 .37712 m .43424 .40381 L .44474 .42324 L p F P
0 g
s
.248 .048 .4 r
.61225 .55186 m .60244 .55993 L .59996 .59321 L p F P
0 g
s
.576 .312 .478 r
.58402 .59594 m .59996 .59321 L .60244 .55993 L p F P
0 g
s
.935 .675 .518 r
.18484 .54407 m .19603 .58717 L .20098 .58616 L closepath p F P
0 g
s
.876 .52 .371 r
.27181 .71034 m .25442 .68914 L .23744 .69417 L p F P
0 g
s
.905 .586 .432 r
.2228 .66408 m .23744 .69417 L .25442 .68914 L p F P
0 g
s
.952 .739 .578 r
.14451 .42357 m .15471 .46152 L .16404 .45853 L p F P
0 g
s
.952 .739 .578 r
.16404 .45853 m .15808 .41966 L .14451 .42357 L p F P
0 g
s
.947 .715 .555 r
.17314 .50062 m .16404 .45853 L .15471 .46152 L p F P
0 g
s
.975 .924 .647 r
.35677 .6349 m .35133 .66578 L .33704 .67863 L p F P
0 g
s
.937 .96 .663 r
.32749 .70377 m .33704 .67863 L .35133 .66578 L p F P
0 g
s
.947 .715 .555 r
.15471 .46152 m .16841 .50231 L .17314 .50062 L p F P
0 g
s
.941 .695 .537 r
.18484 .54407 m .17314 .50062 L .16841 .50231 L closepath p F P
0 g
s
.958 .771 .609 r
.1385 .39021 m .14451 .42357 L .15808 .41966 L p F P
0 g
s
.958 .771 .609 r
.15808 .41966 m .15569 .38573 L .1385 .39021 L p F P
0 g
s
.446 .64 .939 r
.50514 .26032 m .49174 .25916 L .51375 .28613 L p F P
0 g
s
.446 .64 .939 r
.51375 .28613 m .5263 .28646 L .50514 .26032 L p F P
0 g
s
.944 .693 .527 r
.18484 .54407 m .1615 .51143 L .15968 .51846 L closepath p F P
0 g
s
.943 .694 .531 r
.18484 .54407 m .16446 .50597 L .1615 .51143 L closepath p F P
0 g
s
.942 .695 .534 r
.18484 .54407 m .16841 .50231 L .16446 .50597 L closepath p F P
0 g
s
.937 .675 .515 r
.18484 .54407 m .19056 .58614 L .19603 .58717 L closepath p F P
0 g
s
.938 .676 .514 r
.18484 .54407 m .18484 .5831 L .19056 .58614 L closepath p F P
0 g
s
.94 .678 .512 r
.18484 .54407 m .17912 .57818 L .18484 .5831 L closepath p F P
0 g
s
.941 .68 .512 r
.18484 .54407 m .17369 .5716 L .17912 .57818 L closepath p F P
0 g
s
.945 .69 .52 r
.18484 .54407 m .15908 .52672 L .15976 .53583 L closepath p F P
0 g
s
.945 .692 .524 r
.18484 .54407 m .15968 .51846 L .15908 .52672 L closepath p F P
0 g
s
.944 .686 .515 r
.18484 .54407 m .16168 .54533 L .16475 .55477 L closepath p F P
0 g
s
.945 .688 .518 r
.18484 .54407 m .15976 .53583 L .16168 .54533 L closepath p F P
0 g
s
.943 .682 .512 r
.18484 .54407 m .16882 .56367 L .17369 .5716 L closepath p F P
0 g
s
.944 .684 .513 r
.18484 .54407 m .16475 .55477 L .16882 .56367 L closepath p F P
0 g
s
.801 .38 .246 r
.28812 .72292 m .27181 .71034 L .25233 .71652 L p F P
0 g
s
.876 .52 .371 r
.23744 .69417 m .25233 .71652 L .27181 .71034 L p F P
0 g
s
.961 .817 .655 r
.13726 .36296 m .1385 .39021 L .15569 .38573 L p F P
0 g
s
.961 .817 .655 r
.15569 .38573 m .15723 .35819 L .13726 .36296 L p F P
0 g
s
.803 .513 .498 r
.53802 .55505 m .50584 .5445 L .50322 .56733 L p F P
0 g
s
.803 .513 .498 r
.50322 .56733 m .53524 .58256 L .53802 .55505 L p F P
0 g
s
.781 .287 .035 r
.25422 .36621 m .22831 .34417 L .24796 .34772 L p F P
0 g
s
.781 .287 .035 r
.24796 .34772 m .27033 .36892 L .25422 .36621 L p F P
0 g
s
0 0 .129 r
.61423 .50531 m .61252 .49237 L .6076 .46065 L p F P
0 g
s
0 0 .338 r
.61225 .55186 m .61612 .53897 L .61423 .50531 L p F P
0 g
s
.773 .588 .018 r
.61252 .49237 m .61423 .50531 L .61612 .53897 L p F P
0 g
s
.841 .648 .642 r
.42398 .47348 m .461 .46679 L .45378 .44453 L p F P
0 g
s
.835 .622 .614 r
.461 .46679 m .42398 .47348 L .42714 .48748 L p F P
0 g
s
.835 .622 .614 r
.42714 .48748 m .46611 .48911 L .461 .46679 L p F P
0 g
s
.85 .675 .665 r
.41945 .45952 m .45378 .44453 L .44474 .42324 L p F P
0 g
s
.841 .648 .642 r
.45378 .44453 m .41945 .45952 L .42398 .47348 L p F P
0 g
s
.854 .773 .771 r
.46186 .28228 m .44556 .30594 L .46435 .3278 L p F P
0 g
s
.877 .771 .741 r
.4443 .35474 m .46435 .3278 L .44556 .30594 L p F P
0 g
s
.647 .227 0 r
.54507 .30824 m .53676 .29393 L .55531 .32335 L p F P
0 g
s
.647 .227 0 r
.55531 .32335 m .56117 .33377 L .54507 .30824 L p F P
0 g
s
.952 .89 .733 r
.14121 .34308 m .13726 .36296 L .15723 .35819 L p F P
0 g
s
.952 .89 .733 r
.15723 .35819 m .16296 .33821 L .14121 .34308 L p F P
0 g
s
.52 0 0 r
.30298 .72618 m .28812 .72292 L .26709 .72991 L p F P
0 g
s
.801 .38 .246 r
.25233 .71652 m .26709 .72991 L .28812 .72292 L p F P
0 g
s
0 0 .291 r
.36184 .48007 m .35811 .47256 L .36324 .48611 L p F P
0 g
s
0 0 .291 r
.36324 .48611 m .36361 .48475 L .36184 .48007 L p F P
0 g
s
0 0 .219 r
.36361 .48475 m .36324 .48611 L .36703 .50002 L p F P
0 g
s
.933 .654 .488 r
.20884 .62781 m .19603 .58717 L .19056 .58614 L p F P
0 g
s
.87 .543 .031 r
.58644 .39822 m .58897 .39469 L .59964 .42766 L p F P
0 g
s
.87 .543 .031 r
.59964 .42766 m .59504 .42478 L .58644 .39822 L p F P
0 g
s
.889 .588 .08 r
.59504 .42478 m .59964 .42766 L .6076 .46065 L p F P
0 g
s
0 0 .219 r
.36703 .50002 m .36492 .48956 L .36361 .48475 L p F P
0 g
s
.714 .486 0 r
.36492 .48956 m .36703 .50002 L .36931 .51369 L p F P
0 g
s
.863 .511 .006 r
.57598 .37271 m .57598 .36298 L .58897 .39469 L p F P
0 g
s
.863 .511 .006 r
.58897 .39469 m .58644 .39822 L .57598 .37271 L p F P
0 g
s
.831 .596 .582 r
.46611 .48911 m .42714 .48748 L .42878 .50091 L p F P
0 g
s
.831 .596 .582 r
.42878 .50091 m .46888 .51059 L .46611 .48911 L p F P
0 g
s
.634 .261 0 r
.35968 .47572 m .35186 .45996 L .35811 .47256 L p F P
0 g
s
.634 .261 0 r
.35811 .47256 m .36184 .48007 L .35968 .47572 L p F P
0 g
s
.951 .716 .547 r
.14685 .46841 m .16446 .50597 L .16841 .50231 L p F P
0 g
s
.951 .716 .547 r
.16841 .50231 m .15471 .46152 L .14685 .46841 L p F P
0 g
s
.862 .704 .684 r
.41374 .4462 m .44474 .42324 L .43424 .40381 L p F P
0 g
s
.85 .675 .665 r
.44474 .42324 m .41374 .4462 L .41945 .45952 L p F P
0 g
s
0 0 .12 r
.61612 .53897 m .61225 .55186 L .60998 .58399 L p F P
0 g
s
.248 .048 .4 r
.59996 .59321 m .60998 .58399 L .61225 .55186 L p F P
0 g
s
.841 .989 .859 r
.15058 .33145 m .14121 .34308 L .16296 .33821 L p F P
0 g
s
.841 .989 .859 r
.16296 .33821 m .173 .3266 L .15058 .33145 L p F P
0 g
s
.52 0 0 r
.26709 .72991 m .2814 .73351 L .30298 .72618 L p F P
0 g
s
.418 .858 .762 r
.31614 .71978 m .30298 .72618 L .2814 .73351 L p F P
0 g
s
0 .231 .739 r
.51737 .26991 m .50514 .26032 L .5263 .28646 L p F P
0 g
s
0 .231 .739 r
.5263 .28646 m .53676 .29393 L .51737 .26991 L p F P
0 g
s
.714 .486 0 r
.36931 .51369 m .36571 .49428 L .36492 .48956 L p F P
0 g
s
.805 .614 .055 r
.36571 .49428 m .36931 .51369 L .36999 .52653 L p F P
0 g
s
.951 .825 .386 r
.3669 .58565 m .36638 .54748 L .369 .53797 L p F P
0 g
s
.988 .876 .529 r
.36638 .54748 m .3669 .58565 L .36025 .59739 L p F P
0 g
s
.977 .887 .525 r
.35677 .6349 m .36025 .59739 L .3669 .58565 L p F P
0 g
s
.681 .255 0 r
.35724 .47191 m .34476 .44886 L .35186 .45996 L p F P
0 g
s
.681 .255 0 r
.35186 .45996 m .35968 .47572 L .35724 .47191 L p F P
0 g
s
.822 .531 .498 r
.50584 .5445 m .46918 .5303 L .46694 .54739 L p F P
0 g
s
.822 .531 .498 r
.46694 .54739 m .50322 .56733 L .50584 .5445 L p F P
0 g
s
.825 .347 .02 r
.32149 .42918 m .29498 .39651 L .30757 .40303 L p F P
0 g
s
.825 .347 .02 r
.30757 .40303 m .32923 .43309 L .32149 .42918 L p F P
0 g
s
.889 .588 .08 r
.6076 .46065 m .60143 .45133 L .59504 .42478 L p F P
0 g
s
.916 .64 .148 r
.60143 .45133 m .6076 .46065 L .61252 .49237 L p F P
0 g
s
0 0 0 r
.16539 .32853 m .15058 .33145 L .173 .3266 L p F P
0 g
s
0 0 0 r
.173 .3266 m .18735 .32377 L .16539 .32853 L p F P
0 g
s
.985 .898 .632 r
.36025 .59739 m .35677 .6349 L .34491 .64524 L p F P
0 g
s
.975 .924 .647 r
.33704 .67863 m .34491 .64524 L .35677 .6349 L p F P
0 g
s
.927 .627 .453 r
.2228 .66408 m .20884 .62781 L .19819 .62609 L p F P
0 g
s
.933 .654 .488 r
.19056 .58614 m .19819 .62609 L .20884 .62781 L p F P
0 g
s
.868 .492 .007 r
.56406 .34926 m .56117 .33377 L .57598 .36298 L p F P
0 g
s
.868 .492 .007 r
.57598 .36298 m .57598 .37271 L .56406 .34926 L p F P
0 g
s
.877 .771 .741 r
.44556 .30594 m .42845 .33678 L .4443 .35474 L p F P
0 g
s
.89 .768 .721 r
.42271 .38707 m .4443 .35474 L .42845 .33678 L p F P
0 g
s
.87 .734 .709 r
.4443 .35474 m .42271 .38707 L .43424 .40381 L p F P
0 g
s
.938 .657 .481 r
.19819 .62609 m .19056 .58614 L .18484 .5831 L p F P
0 g
s
.96 .741 .562 r
.133 .43317 m .14685 .46841 L .15471 .46152 L p F P
0 g
s
.96 .741 .562 r
.15471 .46152 m .14451 .42357 L .133 .43317 L p F P
0 g
s
.831 .57 .544 r
.46888 .51059 m .42878 .50091 L .42883 .51319 L p F P
0 g
s
.831 .57 .544 r
.42883 .51319 m .46918 .5303 L .46888 .51059 L p F P
0 g
s
.954 .715 .536 r
.14089 .47894 m .1615 .51143 L .16446 .50597 L p F P
0 g
s
.954 .715 .536 r
.16446 .50597 m .14685 .46841 L .14089 .47894 L p F P
0 g
s
.868 .992 .82 r
.32749 .70377 m .31614 .71978 L .29499 .72692 L p F P
0 g
s
.418 .858 .762 r
.2814 .73351 m .29499 .72692 L .31614 .71978 L p F P
0 g
s
.824 .362 .117 r
.28308 .39473 m .25422 .36621 L .27033 .36892 L p F P
0 g
s
.824 .362 .117 r
.27033 .36892 m .29498 .39651 L .28308 .39473 L p F P
0 g
s
.878 .734 .699 r
.4071 .4341 m .43424 .40381 L .42271 .38707 L p F P
0 g
s
.862 .704 .684 r
.43424 .40381 m .4071 .4341 L .41374 .4462 L p F P
0 g
s
.805 .614 .055 r
.36999 .52653 m .36593 .49868 L .36571 .49428 L p F P
0 g
s
.897 .736 .232 r
.36593 .49868 m .36999 .52653 L .369 .53797 L p F P
0 g
s
.745 .28 0 r
.35462 .46881 m .3371 .43976 L .34476 .44886 L p F P
0 g
s
.745 .28 0 r
.34476 .44886 m .35724 .47191 L .35462 .46881 L p F P
0 g
s
.557 .009 0 r
.18548 .33435 m .16539 .32853 L .18735 .32377 L p F P
0 g
s
.557 .009 0 r
.18735 .32377 m .20588 .32976 L .18548 .33435 L p F P
0 g
s
.916 .585 .401 r
.23744 .69417 m .2228 .66408 L .20749 .66197 L p F P
0 g
s
.927 .627 .453 r
.19819 .62609 m .20749 .66197 L .2228 .66408 L p F P
0 g
s
.696 .358 .401 r
.58402 .59594 m .56234 .59228 L .55528 .61752 L p F P
0 g
s
.768 .435 .421 r
.56234 .59228 m .53524 .58256 L .52859 .60491 L p F P
0 g
s
.768 .435 .421 r
.52859 .60491 m .55528 .61752 L .56234 .59228 L p F P
0 g
s
.938 .657 .481 r
.18484 .5831 m .18694 .62037 L .19819 .62609 L p F P
0 g
s
.943 .661 .476 r
.18694 .62037 m .18484 .5831 L .17912 .57818 L p F P
0 g
s
.944 .939 .756 r
.33704 .67863 m .32749 .70377 L .30773 .71023 L p F P
0 g
s
.868 .992 .82 r
.29499 .72692 m .30773 .71023 L .32749 .70377 L p F P
0 g
s
.528 .196 .349 r
.59996 .59321 m .58402 .59594 L .57686 .62284 L p F P
0 g
s
.696 .358 .401 r
.55528 .61752 m .57686 .62284 L .58402 .59594 L p F P
0 g
s
.957 .712 .525 r
.13715 .49266 m .15968 .51846 L .1615 .51143 L p F P
0 g
s
.957 .712 .525 r
.1615 .51143 m .14089 .47894 L .13715 .49266 L p F P
0 g
s
.971 .776 .584 r
.12383 .40192 m .133 .43317 L .14451 .42357 L p F P
0 g
s
.971 .776 .584 r
.14451 .42357 m .1385 .39021 L .12383 .40192 L p F P
0 g
s
.773 .588 .018 r
.61612 .53897 m .61415 .52157 L .61252 .49237 L p F P
0 g
s
0 0 .12 r
.60998 .58399 m .61406 .56846 L .61612 .53897 L p F P
0 g
s
.872 .706 .184 r
.61415 .52157 m .61612 .53897 L .61406 .56846 L p F P
0 g
s
.835 .829 .841 r
.45513 .24723 m .4408 .26437 L .46186 .28228 L p F P
0 g
s
.835 .829 .841 r
.46186 .28228 m .47728 .26653 L .45513 .24723 L p F P
0 g
s
.881 .82 .784 r
.44556 .30594 m .46186 .28228 L .4408 .26437 L p F P
0 g
s
.723 .266 0 r
.52831 .28753 m .51737 .26991 L .53676 .29393 L p F P
0 g
s
.723 .266 0 r
.53676 .29393 m .54507 .30824 L .52831 .28753 L p F P
0 g
s
.916 .64 .148 r
.61252 .49237 m .60536 .4768 L .60143 .45133 L p F P
0 g
s
.946 .692 .229 r
.60536 .4768 m .61252 .49237 L .61415 .52157 L p F P
0 g
s
.72 .818 .926 r
.4695 .23946 m .45513 .24723 L .47728 .26653 L p F P
0 g
s
.72 .818 .926 r
.47728 .26653 m .49174 .25916 L .4695 .23946 L p F P
0 g
s
.897 .736 .232 r
.369 .53797 m .36559 .50258 L .36593 .49868 L p F P
0 g
s
.963 .825 .399 r
.36559 .50258 m .369 .53797 L .36638 .54748 L p F P
0 g
s
.805 .476 .431 r
.53524 .58256 m .50322 .56733 L .49733 .58575 L p F P
0 g
s
.805 .476 .431 r
.49733 .58575 m .52859 .60491 L .53524 .58256 L p F P
0 g
s
.74 .262 .111 r
.21044 .34848 m .18548 .33435 L .20588 .32976 L p F P
0 g
s
.74 .262 .111 r
.20588 .32976 m .22831 .34417 L .21044 .34848 L p F P
0 g
s
.803 .324 0 r
.35195 .46658 m .32923 .43309 L .3371 .43976 L p F P
0 g
s
.803 .324 0 r
.3371 .43976 m .35462 .46881 L .35195 .46658 L p F P
0 g
s
.881 .487 .032 r
.55116 .32888 m .54507 .30824 L .56117 .33377 L p F P
0 g
s
.881 .487 .032 r
.56117 .33377 m .56406 .34926 L .55116 .32888 L p F P
0 g
s
.833 .543 .498 r
.46918 .5303 m .42883 .51319 L .42726 .52376 L p F P
0 g
s
.833 .543 .498 r
.42726 .52376 m .46694 .54739 L .46918 .5303 L p F P
0 g
s
.067 0 .179 r
.60998 .58399 m .59996 .59321 L .59295 .62044 L p F P
0 g
s
.528 .196 .349 r
.57686 .62284 m .59295 .62044 L .59996 .59321 L p F P
0 g
s
.881 .82 .784 r
.4408 .26437 m .42658 .2903 L .44556 .30594 L p F P
0 g
s
.902 .811 .748 r
.42845 .33678 m .44556 .30594 L .42658 .2903 L p F P
0 g
s
.887 .507 .311 r
.25233 .71652 m .23744 .69417 L .21824 .6919 L p F P
0 g
s
.916 .585 .401 r
.20749 .66197 m .21824 .6919 L .23744 .69417 L p F P
0 g
s
.89 .768 .721 r
.42845 .33678 m .41062 .37378 L .42271 .38707 L p F P
0 g
s
.897 .766 .708 r
.39981 .42375 m .42271 .38707 L .41062 .37378 L p F P
0 g
s
.878 .734 .699 r
.42271 .38707 m .39981 .42375 L .4071 .4341 L p F P
0 g
s
.943 .661 .476 r
.17912 .57818 m .17564 .61086 L .18694 .62037 L p F P
0 g
s
.947 .666 .474 r
.17564 .61086 m .17912 .57818 L .17369 .5716 L p F P
0 g
s
.959 .707 .513 r
.13587 .50893 m .15908 .52672 L .15968 .51846 L p F P
0 g
s
.959 .707 .513 r
.15968 .51846 m .13715 .49266 L .13587 .50893 L p F P
0 g
s
.935 .63 .438 r
.20749 .66197 m .19819 .62609 L .18694 .62037 L p F P
0 g
s
.988 .876 .529 r
.36025 .59739 m .36223 .55461 L .36638 .54748 L p F P
0 g
s
.989 .883 .623 r
.36223 .55461 m .36025 .59739 L .35135 .60483 L p F P
0 g
s
.985 .898 .632 r
.34491 .64524 m .35135 .60483 L .36025 .59739 L p F P
0 g
s
.367 .676 .976 r
.48382 .24126 m .4695 .23946 L .49174 .25916 L p F P
0 g
s
.367 .676 .976 r
.49174 .25916 m .50514 .26032 L .48382 .24126 L p F P
0 g
s
.846 .65 .638 r
.38423 .48049 m .42398 .47348 L .41945 .45952 L p F P
0 g
s
.84 .625 .611 r
.42398 .47348 m .38423 .48049 L .3853 .4853 L p F P
0 g
s
.84 .625 .611 r
.3853 .4853 m .42714 .48748 L .42398 .47348 L p F P
0 g
s
.855 .677 .66 r
.38267 .4757 m .41945 .45952 L .41374 .4462 L p F P
0 g
s
.846 .65 .638 r
.41945 .45952 m .38267 .4757 L .38423 .48049 L p F P
0 g
s
.962 .901 .715 r
.34491 .64524 m .33704 .67863 L .31954 .68402 L p F P
0 g
s
.944 .939 .756 r
.30773 .71023 m .31954 .68402 L .33704 .67863 L p F P
0 g
s
.967 .74 .543 r
.12418 .44815 m .14089 .47894 L .14685 .46841 L p F P
0 g
s
.967 .74 .543 r
.14685 .46841 m .133 .43317 L .12418 .44815 L p F P
0 g
s
.981 .829 .619 r
.12014 .37619 m .12383 .40192 L .1385 .39021 L p F P
0 g
s
.981 .829 .619 r
.1385 .39021 m .13726 .36296 L .12014 .37619 L p F P
0 g
s
.845 .4 .159 r
.31424 .42826 m .28308 .39473 L .29498 .39651 L p F P
0 g
s
.845 .4 .159 r
.29498 .39651 m .32149 .42918 L .31424 .42826 L p F P
0 g
s
.826 .5 .437 r
.50322 .56733 m .46694 .54739 L .46222 .56106 L p F P
0 g
s
.826 .5 .437 r
.46222 .56106 m .49733 .58575 L .50322 .56733 L p F P
0 g
s
.837 .6 .58 r
.42714 .48748 m .3853 .4853 L .38583 .4899 L p F P
0 g
s
.837 .6 .58 r
.38583 .4899 m .42878 .50091 L .42714 .48748 L p F P
0 g
s
.867 .704 .678 r
.3807 .47113 m .41374 .4462 L .4071 .4341 L p F P
0 g
s
.855 .677 .66 r
.41374 .4462 m .3807 .47113 L .38267 .4757 L p F P
0 g
s
.804 .366 .205 r
.23968 .37008 m .21044 .34848 L .22831 .34417 L p F P
0 g
s
.804 .366 .205 r
.22831 .34417 m .25422 .36621 L .23968 .37008 L p F P
0 g
s
.947 .666 .474 r
.17369 .5716 m .16486 .59796 L .17564 .61086 L p F P
0 g
s
.951 .673 .475 r
.16486 .59796 m .17369 .5716 L .16882 .56367 L p F P
0 g
s
.959 .702 .502 r
.13714 .52697 m .15976 .53583 L .15908 .52672 L p F P
0 g
s
.959 .702 .502 r
.15908 .52672 m .13587 .50893 L .13714 .52697 L p F P
0 g
s
.902 .811 .748 r
.42658 .2903 m .41247 .32412 L .42845 .33678 L p F P
0 g
s
.914 .804 .725 r
.41062 .37378 m .42845 .33678 L .41247 .32412 L p F P
0 g
s
.795 .321 .104 r
.26709 .72991 m .25233 .71652 L .23019 .71423 L p F P
0 g
s
.887 .507 .311 r
.21824 .6919 m .23019 .71423 L .25233 .71652 L p F P
0 g
s
.963 .825 .399 r
.36638 .54748 m .36469 .50578 L .36559 .50258 L p F P
0 g
s
.992 .869 .53 r
.36469 .50578 m .36638 .54748 L .36223 .55461 L p F P
0 g
s
0 0 0 r
.61406 .56846 m .60998 .58399 L .60335 .61022 L p F P
0 g
s
.067 0 .179 r
.59295 .62044 m .60335 .61022 L .60998 .58399 L p F P
0 g
s
.84 .373 .052 r
.34935 .4653 m .32149 .42918 L .32923 .43309 L p F P
0 g
s
.84 .373 .052 r
.32923 .43309 m .35195 .46658 L .34935 .4653 L p F P
0 g
s
.951 .673 .475 r
.16882 .56367 m .15516 .58229 L .16486 .59796 L p F P
0 g
s
.954 .68 .478 r
.15516 .58229 m .16882 .56367 L .16475 .55477 L p F P
0 g
s
.959 .695 .492 r
.14093 .54585 m .16168 .54533 L .15976 .53583 L p F P
0 g
s
.959 .695 .492 r
.15976 .53583 m .13714 .52697 L .14093 .54585 L p F P
0 g
s
.955 .634 .223 r
.57982 .40372 m .58644 .39822 L .59504 .42478 L p F P
0 g
s
.955 .634 .223 r
.59504 .42478 m .58589 .42246 L .57982 .40372 L p F P
0 g
s
.963 .657 .249 r
.58589 .42246 m .59504 .42478 L .60143 .45133 L p F P
0 g
s
.837 .574 .543 r
.42878 .50091 m .38583 .4899 L .38579 .49408 L p F P
0 g
s
.837 .574 .543 r
.38579 .49408 m .42883 .51319 L .42878 .50091 L p F P
0 g
s
.95 .615 .208 r
.57244 .38574 m .57598 .37271 L .58644 .39822 L p F P
0 g
s
.95 .615 .208 r
.58644 .39822 m .57982 .40372 L .57244 .38574 L p F P
0 g
s
.974 .917 .675 r
.12252 .35724 m .12014 .37619 L .13726 .36296 L p F P
0 g
s
.974 .917 .675 r
.13726 .36296 m .14121 .34308 L .12252 .35724 L p F P
0 g
s
.882 .733 .693 r
.3784 .46701 m .4071 .4341 L .39981 .42375 L p F P
0 g
s
.867 .704 .678 r
.4071 .4341 m .3784 .46701 L .3807 .47113 L p F P
0 g
s
0 .134 .612 r
.49791 .2525 m .48382 .24126 L .50514 .26032 L p F P
0 g
s
0 .134 .612 r
.50514 .26032 m .51737 .26991 L .49791 .2525 L p F P
0 g
s
.954 .68 .478 r
.16475 .55477 m .14704 .56462 L .15516 .58229 L p F P
0 g
s
.957 .687 .484 r
.14704 .56462 m .16475 .55477 L .16168 .54533 L p F P
0 g
s
.957 .687 .484 r
.16168 .54533 m .14093 .54585 L .14704 .56462 L p F P
0 g
s
.968 .877 .691 r
.35135 .60483 m .34491 .64524 L .33045 .6493 L p F P
0 g
s
.962 .901 .715 r
.31954 .68402 m .33045 .6493 L .34491 .64524 L p F P
0 g
s
.833 .417 .251 r
.27244 .39791 m .23968 .37008 L .25422 .36621 L p F P
0 g
s
.833 .417 .251 r
.25422 .36621 m .28308 .39473 L .27244 .39791 L p F P
0 g
s
.31 0 0 r
.2814 .73351 m .26709 .72991 L .24308 .72763 L p F P
0 g
s
.795 .321 .104 r
.23019 .71423 m .24308 .72763 L .26709 .72991 L p F P
0 g
s
.838 .514 .44 r
.46694 .54739 m .42726 .52376 L .42413 .53213 L p F P
0 g
s
.838 .514 .44 r
.42413 .53213 m .46222 .56106 L .46694 .54739 L p F P
0 g
s
.963 .657 .249 r
.60143 .45133 m .59038 .44117 L .58589 .42246 L p F P
0 g
s
.972 .682 .284 r
.59038 .44117 m .60143 .45133 L .60536 .4768 L p F P
0 g
s
.946 .692 .229 r
.61415 .52157 m .60662 .50015 L .60536 .4768 L p F P
0 g
s
.973 .739 .314 r
.60662 .50015 m .61415 .52157 L .61235 .54702 L p F P
0 g
s
.872 .706 .184 r
.61406 .56846 m .61235 .54702 L .61415 .52157 L p F P
0 g
s
.948 .601 .206 r
.56404 .36928 m .56406 .34926 L .57598 .37271 L p F P
0 g
s
.948 .601 .206 r
.57598 .37271 m .57244 .38574 L .56404 .36928 L p F P
0 g
s
.927 .587 .372 r
.21824 .6919 m .20749 .66197 L .19121 .654 L p F P
0 g
s
.935 .63 .438 r
.18694 .62037 m .19121 .654 L .20749 .66197 L p F P
0 g
s
.943 .636 .427 r
.19121 .654 m .18694 .62037 L .17564 .61086 L p F P
0 g
s
.914 .804 .725 r
.41247 .32412 m .39847 .36458 L .41062 .37378 L p F P
0 g
s
.92 .799 .711 r
.39217 .41564 m .41062 .37378 L .39847 .36458 L p F P
0 g
s
.897 .766 .708 r
.41062 .37378 m .39217 .41564 L .39981 .42375 L p F P
0 g
s
.897 .493 .077 r
.53779 .31246 m .52831 .28753 L .54507 .30824 L p F P
0 g
s
.897 .493 .077 r
.54507 .30824 m .55116 .32888 L .53779 .31246 L p F P
0 g
s
.971 .735 .521 r
.11859 .46791 m .13715 .49266 L .14089 .47894 L p F P
0 g
s
.971 .735 .521 r
.14089 .47894 m .12418 .44815 L .11859 .46791 L p F P
0 g
s
.839 .549 .498 r
.42883 .51319 m .38579 .49408 L .38519 .49765 L p F P
0 g
s
.839 .549 .498 r
.38519 .49765 m .42726 .52376 L .42883 .51319 L p F P
0 g
s
.742 .966 .691 r
.1313 .34597 m .12252 .35724 L .14121 .34308 L p F P
0 g
s
.742 .966 .691 r
.14121 .34308 m .15058 .33145 L .1313 .34597 L p F P
0 g
s
.981 .775 .552 r
.11252 .42057 m .12418 .44815 L .133 .43317 L p F P
0 g
s
.981 .775 .552 r
.133 .43317 m .12383 .40192 L .11252 .42057 L p F P
0 g
s
.901 .764 .701 r
.37587 .46352 m .39981 .42375 L .39217 .41564 L p F P
0 g
s
.882 .733 .693 r
.39981 .42375 m .37587 .46352 L .3784 .46701 L p F P
0 g
s
.992 .869 .53 r
.36223 .55461 m .36327 .50814 L .36469 .50578 L p F P
0 g
s
.99 .874 .617 r
.36327 .50814 m .36223 .55461 L .3567 .55899 L p F P
0 g
s
.989 .883 .623 r
.35135 .60483 m .3567 .55899 L .36223 .55461 L p F P
0 g
s
.855 .419 .18 r
.34694 .46506 m .31424 .42826 L .32149 .42918 L p F P
0 g
s
.855 .419 .18 r
.32149 .42918 m .34935 .4653 L .34694 .46506 L p F P
0 g
s
.31 0 0 r
.24308 .72763 m .25668 .73119 L .2814 .73351 L p F P
0 g
s
.642 .938 .964 r
.29499 .72692 m .2814 .73351 L .25668 .73119 L p F P
0 g
s
0 0 0 r
.60335 .61022 m .60801 .5924 L .61406 .56846 L p F P
0 g
s
.948 .797 .344 r
.61235 .54702 m .61406 .56846 L .60801 .5924 L p F P
0 g
s
.971 .864 .676 r
.3567 .55899 m .35135 .60483 L .34056 .60751 L p F P
0 g
s
.968 .877 .691 r
.33045 .6493 m .34056 .60751 L .35135 .60483 L p F P
0 g
s
.848 .444 .275 r
.30782 .43042 m .27244 .39791 L .28308 .39473 L p F P
0 g
s
.848 .444 .275 r
.28308 .39473 m .31424 .42826 L .30782 .43042 L p F P
0 g
s
.794 .322 0 r
.51156 .27264 m .49791 .2525 L .51737 .26991 L p F P
0 g
s
.794 .322 0 r
.51737 .26991 m .52831 .28753 L .51156 .27264 L p F P
0 g
s
.245 0 0 r
.14656 .34286 m .1313 .34597 L .15058 .33145 L p F P
0 g
s
.245 0 0 r
.15058 .33145 m .16539 .32853 L .14656 .34286 L p F P
0 g
s
0 0 .273 r
.36361 .48475 m .36407 .48561 L .36362 .4841 L F
.36545 .48821 m .36362 .4841 L p .36407 .48561 L F P
0 g
s
0 0 .273 r
.36362 .4841 m .36184 .48007 L .36361 .48475 L p F P
0 g
s
0 0 .273 r
.36361 .48475 m .36362 .4841 L p .36407 .48561 L F P
0 g
s
.651 .276 0 r
.36184 .48007 m .36378 .48427 L .36362 .4841 L F
.36378 .48427 m .36403 .48481 L .36362 .4841 L F
.36362 .4841 m .35968 .47572 L .36184 .48007 L p F P
0 g
s
.651 .276 0 r
.36378 .48427 m .36362 .4841 L .36419 .48515 L F
.36184 .48007 m .36362 .4841 L p .36378 .48427 L F P
0 g
s
.817 .622 .067 r
.36127 .46923 m .3615 .4737 L p .36264 .48011 L F P
0 g
s
0 0 .202 r
.36361 .48475 m .36492 .48956 L p .3646 .48803 L F P
0 g
s
0 0 .202 r
.3646 .48803 m .36391 .48525 L .36361 .48475 L F
.36362 .4841 m .36361 .48475 L p .36392 .48527 L F P
0 g
s
0 0 .202 r
.36408 .48553 m .36362 .4841 L .36392 .48527 L F
.904 .739 .24 r
.36162 .46531 m .36127 .46923 L p .36275 .48065 L F P
0 g
s
.695 .27 0 r
.35968 .47572 m .36317 .48267 L .36362 .4841 L F
.36362 .4841 m .35724 .47191 L .35968 .47572 L p F P
0 g
s
.695 .27 0 r
.36744 .49117 m .36538 .48746 L .37013 .49651 L F
.756 .293 0 r
.36362 .4841 m .35462 .46881 L .35724 .47191 L p F P
0 g
s
.81 .334 0 r
.36362 .4841 m .35195 .46658 L p .35983 .47708 L F P
0 g
s
.695 .27 0 r
.36608 .48846 m .36502 .48662 L .36654 .48938 L F
.3656 .4875 m .36486 .48626 L .3658 .48789 L F
.36411 .48453 m .36481 .48614 L .3656 .4875 L F
.36481 .48614 m .36486 .48626 L .3656 .4875 L F
.36391 .48414 m .36362 .4841 L .36411 .48453 L F
.35968 .47572 m .36362 .4841 L p .36363 .48357 L F P
0 g
s
.695 .27 0 r
.36363 .48357 m .36362 .4841 L .36391 .48414 L F
.36317 .48267 m .36411 .48453 L .36362 .4841 L F
.756 .293 0 r
.35724 .47191 m .36422 .48437 L .36362 .4841 L F
.651 .276 0 r
.36615 .48941 m .36465 .48628 L .36765 .49264 L F
.36419 .48515 m .36458 .4861 L .36615 .48941 L F
.36458 .4861 m .36465 .48628 L .36615 .48941 L F
.695 .27 0 r
.36362 .4841 m .36516 .48693 L .36502 .48662 L F
.36362 .4841 m .36493 .48641 L .36486 .48626 L F
.36362 .4841 m .36486 .48626 L .36411 .48453 L F
.756 .293 0 r
.37013 .49651 m .37276 .49962 L p .36676 .48891 L F P
0 g
s
.847 .651 .637 r
.36927 .47974 m .36859 .48114 L .37267 .47871 L F
.36645 .48059 m .36655 .48123 L .36753 .48027 L F
.36513 .48099 m .36541 .48127 L .36569 .48082 L F
.36399 .48133 m .36498 .48129 L .36513 .48099 L F
.36498 .48129 m .36541 .48127 L .36513 .48099 L F
.902 .764 .699 r
.36583 .47565 m .36838 .47257 L .37323 .46081 L F
.883 .733 .691 r
.3784 .46701 m .37587 .46352 L p .36904 .47302 L F P
0 g
s
.868 .704 .677 r
.36762 .47716 m .37094 .47563 L .3784 .46701 L F
.756 .293 0 r
.36311 .4824 m .36385 .4842 L .36422 .48437 L F
.36112 .47883 m .36337 .48325 L .36311 .4824 L F
.36337 .48325 m .36385 .4842 L .36311 .4824 L F
.858 .424 .186 r
.36549 .48502 m .36716 .48743 L .36847 .48866 L F
.651 .276 0 r
.36765 .49264 m .36362 .4841 L p .36403 .48481 L F P
0 g
s
.695 .27 0 r
.37013 .49651 m .36362 .4841 L p .36411 .48453 L F P
0 g
s
.756 .293 0 r
.36583 .48724 m .36443 .48533 L .36676 .48891 L F
.36422 .48437 m .3644 .48521 L .36583 .48724 L F
.3644 .48521 m .36443 .48533 L .36583 .48724 L F
.695 .27 0 r
.36362 .4841 m .36502 .48662 L .36493 .48641 L F
.36362 .4841 m .36765 .49264 L p .36516 .48693 L F P
0 g
s
.695 .27 0 r
.36486 .48626 m .36493 .48641 L .3658 .48789 L F
.36493 .48641 m .36502 .48662 L .36608 .48846 L F
.36654 .48938 m .36516 .48693 L .36744 .49117 L F
.36502 .48662 m .36516 .48693 L .36654 .48938 L F
.36516 .48693 m .36538 .48746 L .36744 .49117 L F
.756 .293 0 r
.36362 .4841 m .37013 .49651 L p .36397 .48444 L F P
0 g
s
.756 .293 0 r
.36362 .4841 m .36385 .4842 L .36112 .47883 L F
.35724 .47191 m .36362 .4841 L p .36112 .47883 L F P
0 g
s
.81 .334 0 r
.364 .48368 m .36362 .4841 L .36464 .48471 L F
.35983 .47708 m .36362 .4841 L .364 .48368 L F
.756 .293 0 r
.36362 .4841 m .36397 .48444 L .36385 .4842 L F
.36422 .48437 m .36605 .48763 L .36362 .4841 L F
.37276 .49962 m .36362 .4841 L p .36605 .48763 L F P
0 g
s
.81 .334 0 r
.35462 .46881 m .36362 .4841 L p .35983 .47708 L F P
0 g
s
.844 .381 .062 r
.35195 .46658 m .36362 .4841 L p .36072 .47884 L F P
0 g
s
.844 .381 .062 r
.36362 .4841 m .34935 .4653 L p .36072 .47884 L F P
0 g
s
.858 .424 .186 r
.34935 .4653 m .36362 .4841 L .36117 .47975 L F
.36362 .4841 m .34694 .46506 L p .35907 .47757 L F P
0 g
s
.858 .424 .186 r
.36117 .47975 m .36362 .4841 L .35907 .47757 L F
.858 .462 .291 r
.34694 .46506 m .36362 .4841 L p .36145 .48031 L F P
0 g
s
.858 .462 .291 r
.36362 .4841 m .34483 .46587 L p .36145 .48031 L F P
0 g
s
.852 .495 .375 r
.35984 .4791 m .36362 .4841 L .36165 .4807 L F
.34483 .46587 m .36362 .4841 L p .35984 .4791 L F P
0 g
s
.81 .334 0 r
.35983 .47708 m .364 .48368 L .36362 .4841 L F
.364 .48368 m .36477 .48491 L .36362 .4841 L F
.844 .381 .062 r
.36484 .48461 m .36441 .48449 L .36495 .48476 L F
.36441 .48449 m .36432 .48447 L .36495 .48476 L F
.36495 .48476 m .36432 .48447 L .36499 .48482 L F
.36435 .48393 m .36425 .48436 L .36484 .48461 L F
.36072 .47884 m .36402 .484 L .36435 .48393 L F
.36402 .484 m .36425 .48436 L .36435 .48393 L F
.36425 .48436 m .36432 .48447 L .36484 .48461 L F
.81 .334 0 r
.36464 .48471 m .36362 .4841 L .36477 .48491 L F
.756 .293 0 r
.36385 .4842 m .36431 .4851 L .36422 .48437 L F
.36431 .4851 m .36443 .48533 L .36441 .48525 L F
.36431 .4851 m .36441 .48525 L .36422 .48437 L F
.844 .381 .062 r
.36072 .47884 m .36273 .48165 L .36198 .48112 L F
.36273 .48165 m .36435 .48393 L .36198 .48112 L F
.36435 .48393 m .36429 .48394 L .36198 .48112 L F
.36484 .48461 m .36481 .4846 L .36445 .48416 L F
.36447 .48416 m .36445 .48416 L .36198 .48112 L F
.36484 .48461 m .36445 .48416 L .36447 .48416 L F
.36499 .48482 m .36493 .48479 L .36442 .48416 L F
.36445 .48416 m .36442 .48416 L .36198 .48112 L F
.36499 .48482 m .36442 .48416 L .36445 .48416 L F
.36531 .48527 m .36514 .48515 L .36481 .48472 L F
.36458 .48436 m .36451 .48434 L .36198 .48112 L F
.81 .334 0 r
.36477 .48491 m .36362 .4841 L .36514 .48549 L F
.36514 .48549 m .36362 .4841 L .36741 .48909 L F
.844 .381 .062 r
.36198 .48112 m .36465 .48453 L .36362 .4841 L F
.36465 .48453 m .36497 .48493 L .36362 .4841 L F
.36493 .48479 m .36481 .48472 L .36451 .48434 L F
.36493 .48479 m .36451 .48434 L .36458 .48436 L F
.36435 .48393 m .36484 .48461 L .36429 .48394 L F
.36484 .48461 m .36499 .48482 L .36481 .4846 L F
.858 .424 .186 r
.36509 .48454 m .3647 .48463 L .36549 .48502 L F
.81 .334 0 r
.36477 .48491 m .36573 .48643 L .36362 .4841 L F
.844 .381 .062 r
.36362 .4841 m .36495 .48546 L .36484 .48528 L F
.36362 .4841 m .36438 .48457 L .36072 .47884 L F
.858 .424 .186 r
.36117 .47975 m .36223 .48121 L .36273 .48165 L F
.36223 .48121 m .36451 .48436 L .36273 .48165 L F
.36273 .48165 m .36451 .48436 L .36509 .48454 L F
.36451 .48436 m .3647 .48463 L .36509 .48454 L F
.844 .381 .062 r
.36497 .48493 m .36514 .48515 L .36362 .4841 L F
.36514 .48515 m .36533 .48539 L .36362 .4841 L F
.36533 .48539 m .3658 .486 L .36362 .4841 L F
.3658 .486 m .36612 .4864 L .36362 .4841 L F
.36531 .48527 m .36481 .48472 L .36493 .48479 L F
.36499 .48482 m .36531 .48527 L .36493 .48479 L F
.36531 .48527 m .36612 .4864 L .36514 .48515 L F
.36612 .4864 m .36641 .48681 L .36362 .4841 L F
.81 .334 0 r
.37544 .50183 m .36362 .4841 L p .36573 .48643 L F P
0 g
s
.844 .381 .062 r
.37802 .50305 m .36362 .4841 L p .36641 .48681 L F P
0 g
s
.844 .381 .062 r
.36499 .48482 m .36655 .48795 L .37802 .50305 L F
.36432 .48447 m .36655 .48795 L .36499 .48482 L F
.858 .424 .186 r
.3647 .48463 m .37802 .50305 L .36549 .48502 L F
.844 .381 .062 r
.36362 .4841 m .36484 .48528 L .36438 .48457 L F
.81 .334 0 r
.36741 .48909 m .36362 .4841 L .36832 .49055 L F
.36832 .49055 m .36362 .4841 L .37012 .49339 L F
.37012 .49339 m .36362 .4841 L .37544 .50183 L F
.844 .381 .062 r
.36362 .4841 m .37544 .50183 L p .36495 .48546 L F P
0 g
s
.858 .424 .186 r
.36117 .47975 m .36528 .48477 L .36362 .4841 L F
.36528 .48477 m .36549 .48502 L .36362 .4841 L F
.838 .576 .542 r
.36362 .4841 m .34115 .47822 L p .35469 .48007 L F P
0 g
s
.858 .462 .291 r
.36568 .48475 m .36547 .48502 L .36638 .48548 L F
.36547 .48502 m .36541 .48509 L .36638 .48548 L F
.36638 .48548 m .36541 .48509 L .3667 .48581 L F
.858 .424 .186 r
.36362 .4841 m .36431 .48409 L .36117 .47975 L F
.858 .462 .291 r
.36145 .48031 m .36261 .4817 L .36277 .48169 L F
.36261 .4817 m .36493 .48451 L .36277 .48169 L F
.36277 .48169 m .36493 .48451 L .36568 .48475 L F
.858 .424 .186 r
.36362 .4841 m .36518 .48529 L .36431 .48409 L F
.858 .462 .291 r
.36493 .48451 m .36541 .48509 L .36568 .48475 L F
.858 .424 .186 r
.36362 .4841 m .37802 .50305 L p .36518 .48529 L F P
0 g
s
.858 .424 .186 r
.36549 .48502 m .36847 .48866 L .36362 .4841 L F
.38038 .50322 m .36362 .4841 L p .36847 .48866 L F P
0 g
s
.858 .424 .186 r
.37802 .50305 m .38038 .50322 L p .36847 .48866 L F P
0 g
s
.858 .424 .186 r
.36716 .48743 m .37802 .50305 L .36847 .48866 L F
.858 .462 .291 r
.36362 .4841 m .36507 .48468 L .36145 .48031 L F
.36145 .48031 m .36597 .48505 L .36362 .4841 L F
.846 .524 .443 r
.36362 .4841 m .34191 .47045 L p .35543 .47754 L F P
0 g
s
.852 .495 .375 r
.35984 .4791 m .36361 .48242 L .36362 .4841 L F
.36362 .4841 m .34313 .46769 L p .35984 .4791 L F P
0 g
s
.846 .524 .443 r
.3612 .48056 m .36362 .4841 L .35543 .47754 L F
.34313 .46769 m .36362 .4841 L .36066 .48017 L F
.841 .551 .498 r
.34191 .47045 m .36362 .4841 L p .35685 .47849 L F P
0 g
s
.852 .495 .375 r
.36361 .48242 m .36627 .48477 L .36362 .4841 L F
.846 .524 .443 r
.36066 .48017 m .36362 .4841 L .3612 .48056 L F
.36801 .48541 m .36763 .48597 L .37099 .48754 L F
.36276 .48167 m .36609 .48461 L .36722 .48485 L F
.858 .462 .291 r
.36597 .48505 m .3663 .4854 L .36362 .4841 L F
.38243 .50233 m .36362 .4841 L p .3663 .4854 L F P
0 g
s
.858 .462 .291 r
.36362 .4841 m .36621 .48606 L .36507 .48468 L F
.852 .495 .375 r
.36627 .48477 m .368 .48629 L .36362 .4841 L F
.38243 .50233 m .38405 .50045 L p .37414 .49171 L F P
0 g
s
.841 .551 .498 r
.36362 .4841 m .34124 .47401 L p .35964 .48121 L F P
0 g
s
.852 .495 .375 r
.36165 .4807 m .36555 .48476 L .36671 .48515 L F
.846 .524 .443 r
.36494 .48371 m .36763 .48597 L .36503 .48368 L F
.36494 .48371 m .36503 .48368 L .36276 .48167 L F
.858 .462 .291 r
.36362 .4841 m .38038 .50322 L p .36621 .48606 L F P
0 g
s
.858 .462 .291 r
.38038 .50322 m .38243 .50233 L p .37039 .48969 L F P
0 g
s
.858 .462 .291 r
.3667 .48581 m .36855 .48817 L .37039 .48969 L F
.36855 .48817 m .38038 .50322 L .37039 .48969 L F
.36541 .48509 m .38038 .50322 L .3667 .48581 L F
.852 .495 .375 r
.36362 .4841 m .38243 .50233 L p .3658 .48502 L F P
0 g
s
.852 .495 .375 r
.36362 .4841 m .3658 .48502 L .36165 .4807 L F
.846 .524 .443 r
.3612 .48056 m .36494 .48371 L .36276 .48167 L F
.852 .495 .375 r
.36671 .48515 m .36786 .48716 L .37414 .49171 L F
.36555 .48476 m .36786 .48716 L .36671 .48515 L F
.846 .524 .443 r
.3612 .48056 m .36716 .48575 L .36763 .48597 L F
.852 .495 .375 r
.36786 .48716 m .38243 .50233 L .37414 .49171 L F
.38405 .50045 m .36362 .4841 L p .368 .48629 L F P
0 g
s
.846 .524 .443 r
.36362 .4841 m .38405 .50045 L p .36952 .4878 L F P
0 g
s
.846 .524 .443 r
.36362 .4841 m .36952 .4878 L .36716 .48575 L F
.36362 .4841 m .36716 .48575 L .36359 .48264 L F
.36362 .4841 m .36359 .48264 L .3612 .48056 L F
.38519 .49765 m .36362 .4841 L p .3612 .48056 L F P
0 g
s
.841 .551 .498 r
.36339 .48268 m .36362 .4841 L .35964 .48121 L F
.36375 .48282 m .36362 .4841 L .36339 .48268 L F
.34191 .47045 m .3679 .48445 L .35804 .48059 L F
.34124 .47401 m .34191 .47045 L p .35804 .48059 L F P
0 g
s
.838 .576 .542 r
.34124 .47401 m .36362 .4841 L p .35841 .48013 L F P
0 g
s
.846 .524 .443 r
.36648 .48495 m .36763 .48597 L .36801 .48541 L F
.841 .551 .498 r
.35977 .48047 m .36816 .48614 L .35878 .47953 L F
.838 .576 .542 r
.36046 .48086 m .36067 .48108 L .36033 .48084 L F
.841 .551 .498 r
.36362 .4841 m .36226 .48215 L .35977 .48047 L F
.838 .576 .542 r
.36067 .48108 m .36362 .4841 L .36033 .48084 L F
.841 .551 .498 r
.36362 .4841 m .35977 .48047 L .35685 .47849 L F
.838 .576 .542 r
.36033 .48084 m .36362 .4841 L .35469 .48007 L F
.838 .601 .579 r
.34115 .47822 m .36362 .4841 L p .35623 .48064 L F P
0 g
s
.841 .551 .498 r
.36555 .48353 m .36362 .4841 L .36375 .48282 L F
.36607 .48373 m .36362 .4841 L .36555 .48353 L F
.3679 .48445 m .36362 .4841 L .36607 .48373 L F
.846 .524 .443 r
.36722 .48485 m .36648 .48495 L .36801 .48541 L F
.36609 .48461 m .36648 .48495 L .36722 .48485 L F
.841 .551 .498 r
.38579 .49408 m .36362 .4841 L p .3679 .48445 L F P
0 g
s
.841 .551 .498 r
.36816 .48614 m .36888 .48646 L .35878 .47953 L F
.846 .524 .443 r
.38405 .50045 m .38519 .49765 L p .37099 .48754 L F P
0 g
s
.846 .524 .443 r
.36716 .48575 m .38405 .50045 L .37099 .48754 L F
.841 .551 .498 r
.38519 .49765 m .38579 .49408 L p .35878 .47953 L F P
0 g
s
.838 .576 .542 r
.38579 .49408 m .38583 .4899 L p .35841 .48013 L F P
0 g
s
.841 .551 .498 r
.36362 .4841 m .38519 .49765 L p .36617 .48479 L F P
0 g
s
.841 .551 .498 r
.36362 .4841 m .36617 .48479 L .36226 .48215 L F
.838 .576 .542 r
.36362 .4841 m .38579 .49408 L p .3689 .48547 L F P
0 g
s
.838 .576 .542 r
.36362 .4841 m .36372 .48284 L .36339 .48267 L F
.36362 .4841 m .36339 .48267 L .35841 .48013 L F
.36362 .4841 m .3689 .48547 L .36372 .48284 L F
.38583 .4899 m .36362 .4841 L p .36046 .48086 L F P
0 g
s
.838 .601 .579 r
.35623 .48064 m .36806 .48434 L .3853 .4853 L F
.38583 .4899 m .3853 .4853 L p .36806 .48434 L F P
0 g
s
.838 .601 .579 r
.36362 .4841 m .36484 .48333 L .36462 .48326 L F
.36362 .4841 m .36342 .48289 L .35623 .48064 L F
.36113 .48218 m .36362 .4841 L .35964 .48223 L F
.36123 .48218 m .36362 .4841 L .36113 .48218 L F
.36362 .4841 m .34165 .48288 L p .35964 .48223 L F P
0 g
s
.838 .601 .579 r
.36083 .48138 m .36164 .48216 L .34165 .48288 L F
.842 .626 .61 r
.3562 .48206 m .36362 .4841 L .36064 .48181 L F
.34165 .48288 m .36362 .4841 L p .3562 .48206 L F P
0 g
s
.842 .626 .61 r
.36362 .4841 m .34272 .48775 L p .36089 .48272 L F P
0 g
s
.842 .626 .61 r
.3562 .48206 m .36152 .48176 L .35975 .48303 L F
.838 .601 .579 r
.36164 .48216 m .36362 .4841 L .36123 .48218 L F
.3646 .48206 m .36362 .4841 L .36164 .48216 L F
.842 .626 .61 r
.36152 .48176 m .36208 .48239 L .35975 .48303 L F
.847 .651 .637 r
.35922 .48277 m .35998 .48254 L .36362 .4841 L F
.842 .626 .61 r
.3562 .48206 m .35975 .48303 L .34272 .48775 L F
.847 .651 .637 r
.36362 .4841 m .3443 .49262 L p .35922 .48277 L F P
0 g
s
.847 .651 .637 r
.34272 .48775 m .36362 .4841 L p .36054 .48237 L F P
0 g
s
.856 .677 .659 r
.36002 .48334 m .36038 .48312 L .36362 .4841 L F
.36038 .48312 m .36053 .48303 L .36362 .4841 L F
.838 .601 .579 r
.36362 .4841 m .36462 .48326 L .36342 .48289 L F
.36362 .4841 m .36512 .48342 L .36484 .48333 L F
.36499 .48204 m .36362 .4841 L .3646 .48206 L F
.36083 .48138 m .36499 .48204 L .36164 .48216 L F
.3853 .4853 m .36362 .4841 L p .36499 .48204 L F P
0 g
s
.842 .626 .61 r
.3853 .4853 m .38423 .48049 L p .36064 .48181 L F P
0 g
s
.838 .601 .579 r
.36362 .4841 m .36548 .48353 L .36512 .48342 L F
.36362 .4841 m .38583 .4899 L p .36548 .48353 L F P
0 g
s
.842 .626 .61 r
.36362 .4841 m .3853 .4853 L p .36064 .48181 L F P
0 g
s
.842 .626 .61 r
.36185 .48245 m .36362 .4841 L .36089 .48272 L F
.36506 .48157 m .36362 .4841 L .36185 .48245 L F
.36152 .48176 m .36506 .48157 L .36208 .48239 L F
.38423 .48049 m .36362 .4841 L p .36506 .48157 L F P
0 g
s
.847 .651 .637 r
.35998 .48254 m .36399 .48133 L .36362 .4841 L F
.36054 .48237 m .36362 .4841 L .36137 .48213 L F
.36137 .48213 m .36362 .4841 L .36399 .48133 L F
.856 .677 .659 r
.36053 .48303 m .36397 .48101 L .36362 .4841 L F
.847 .651 .637 r
.38267 .4757 m .36362 .4841 L p .36399 .48133 L F P
0 g
s
.847 .651 .637 r
.36569 .48082 m .36591 .48125 L .36645 .48059 L F
.36541 .48127 m .36591 .48125 L .36569 .48082 L F
.36591 .48125 m .36655 .48123 L .36645 .48059 L F
.36753 .48027 m .36739 .48119 L .36927 .47974 L F
.36655 .48123 m .36739 .48119 L .36753 .48027 L F
.36739 .48119 m .36859 .48114 L .36927 .47974 L F
.36362 .4841 m .38423 .48049 L p .36399 .48133 L F P
0 g
s
.856 .677 .659 r
.3807 .47113 m .36362 .4841 L p .36397 .48101 L F P
0 g
s
.856 .677 .659 r
.36362 .4841 m .34631 .49723 L p .36002 .48334 L F P
0 g
s
.856 .677 .659 r
.35933 .48374 m .36362 .4841 L .36094 .48279 L F
.35834 .48433 m .36362 .4841 L .35933 .48374 L F
.3443 .49262 m .36362 .4841 L p .35834 .48433 L F P
0 g
s
.868 .704 .677 r
.36127 .48314 m .36362 .4841 L .34867 .50138 L F
.883 .733 .691 r
.34867 .50138 m .35795 .48847 L .36362 .4841 L F
.36362 .4841 m .35126 .50487 L .34867 .50138 L p F P
0 g
s
.883 .733 .691 r
.34867 .50138 m .36362 .4841 L p .35795 .48847 L F P
0 g
s
.902 .764 .699 r
.36105 .48614 m .36362 .4841 L .35395 .50753 L F
.847 .651 .637 r
.38423 .48049 m .38267 .4757 L p .37267 .47871 L F P
0 g
s
.847 .651 .637 r
.36859 .48114 m .38423 .48049 L .37267 .47871 L F
.856 .677 .659 r
.36362 .4841 m .38267 .4757 L p .36094 .48279 L F P
0 g
s
.868 .704 .677 r
.35868 .48558 m .36295 .48359 L .36176 .48268 L F
.35451 .48952 m .36118 .48483 L .35868 .48558 L F
.36118 .48483 m .36295 .48359 L .35868 .48558 L F
.856 .677 .659 r
.38267 .4757 m .3807 .47113 L p .36094 .48279 L F P
0 g
s
.868 .704 .677 r
.36127 .48314 m .36394 .48063 L .36362 .4841 L F
.36362 .4841 m .3626 .48384 L .35451 .48952 L F
.883 .733 .691 r
.35988 .48577 m .36272 .48347 L .36193 .48292 L F
.868 .704 .677 r
.36362 .4841 m .3807 .47113 L p .36274 .48374 L F P
0 g
s
.868 .704 .677 r
.36362 .4841 m .36274 .48374 L .3626 .48384 L F
.883 .733 .691 r
.36156 .48344 m .36175 .48317 L .36362 .4841 L F
.868 .704 .677 r
.34631 .49723 m .36362 .4841 L p .35451 .48952 L F P
0 g
s
.883 .733 .691 r
.35795 .48847 m .36156 .48344 L .36362 .4841 L F
.902 .764 .699 r
.36191 .48355 m .36241 .48371 L .36166 .48433 L F
.36196 .48342 m .36241 .48371 L .36191 .48355 L F
.36196 .48342 m .3625 .48364 L .36241 .48371 L F
.883 .733 .691 r
.36362 .4841 m .3626 .48359 L .36186 .48436 L F
.902 .764 .699 r
.3625 .48364 m .36362 .4841 L .36166 .48433 L F
.883 .733 .691 r
.36362 .4841 m .36186 .48436 L .35795 .48847 L F
.902 .764 .699 r
.36166 .48433 m .36362 .4841 L .36105 .48614 L F
.924 .795 .7 r
.36362 .4841 m .35662 .50923 L .35395 .50753 L p F P
0 g
s
.948 .827 .691 r
.36362 .4841 m .35914 .50991 L p .36158 .49019 L F P
0 g
s
.883 .733 .691 r
.36099 .48528 m .36272 .48347 L .35988 .48577 L F
.36175 .48317 m .36193 .48292 L .36362 .4841 L F
.902 .764 .699 r
.36072 .48591 m .36265 .48349 L .36209 .48315 L F
.36128 .48556 m .36265 .48349 L .36072 .48591 L F
.868 .704 .677 r
.36394 .48063 m .36622 .47848 L .36362 .4841 L F
.3784 .46701 m .36362 .4841 L p .36622 .47848 L F P
0 g
s
.868 .704 .677 r
.36176 .48268 m .36457 .48245 L .36762 .47716 L F
.36295 .48359 m .36457 .48245 L .36176 .48268 L F
.36457 .48245 m .3807 .47113 L .36762 .47716 L F
.883 .733 .691 r
.36362 .4841 m .3784 .46701 L p .3626 .48359 L F P
0 g
s
.902 .764 .699 r
.36362 .4841 m .36265 .48349 L .36191 .4846 L F
.36362 .4841 m .36191 .4846 L .35971 .48794 L F
.35126 .50487 m .36362 .4841 L p .35971 .48794 L F P
0 g
s
.924 .795 .7 r
.35961 .49105 m .36215 .48365 L .36362 .4841 L F
.35818 .49522 m .35961 .49105 L .36362 .4841 L F
.35395 .50753 m .35818 .49522 L .36362 .4841 L F
.35395 .50753 m .36362 .4841 L p .36079 .48761 L F P
0 g
s
.948 .827 .691 r
.36208 .48616 m .36362 .4841 L .36158 .49019 L F
.883 .733 .691 r
.36193 .48292 m .36521 .48084 L .36904 .47302 L F
.36272 .48347 m .36521 .48084 L .36193 .48292 L F
.37587 .46352 m .36362 .4841 L p .36193 .48292 L F P
0 g
s
.902 .764 .699 r
.36196 .48342 m .36386 .4796 L .36362 .4841 L F
.37323 .46081 m .36362 .4841 L p .36386 .4796 L F P
0 g
s
.924 .795 .7 r
.36362 .4841 m .36266 .48358 L .36166 .48574 L F
.948 .827 .691 r
.36339 .484 m .36362 .4841 L .36343 .48435 L F
.924 .795 .7 r
.36362 .4841 m .36166 .48574 L .36079 .48761 L F
.948 .827 .691 r
.36339 .484 m .36343 .48435 L .36208 .48616 L F
.924 .795 .7 r
.36134 .48601 m .36266 .48358 L .36225 .48336 L F
.948 .827 .691 r
.3624 .48358 m .36261 .48367 L .36233 .4842 L F
.924 .795 .7 r
.36215 .48365 m .36225 .48336 L .36362 .4841 L F
.948 .827 .691 r
.36261 .48367 m .36339 .484 L .36233 .4842 L F
.36233 .4842 m .36339 .484 L .36208 .48616 L F
.35662 .50923 m .36362 .4841 L p .36155 .48738 L F P
0 g
s
.972 .854 .666 r
.36362 .4841 m .36353 .48515 L p .3634 .48403 L F P
0 g
s
.948 .827 .691 r
.36362 .4841 m .36272 .48371 L .36155 .48738 L F
.972 .854 .666 r
.36353 .48515 m .36139 .50954 L p .3632 .48653 L F P
0 g
s
.972 .854 .666 r
.3634 .48403 m .36349 .48484 L .3632 .48653 L F
.36349 .48484 m .36353 .48515 L .3632 .48653 L F
.924 .795 .7 r
.36166 .48574 m .36266 .48358 L .36134 .48601 L F
.948 .827 .691 r
.36155 .48738 m .36272 .48371 L .3624 .48358 L F
.972 .854 .666 r
.36256 .4838 m .3634 .48403 L .36139 .50954 L F
.35914 .50991 m .36362 .4841 L p .36211 .48721 L F P
0 g
s
.99 .871 .615 r
.36362 .4841 m .36327 .50814 L p .36282 .48831 L F P
0 g
s
.883 .733 .691 r
.36521 .48084 m .3784 .46701 L .36904 .47302 L F
.902 .764 .699 r
.36362 .4841 m .37587 .46352 L p .36265 .48349 L F P
0 g
s
.902 .764 .699 r
.36209 .48315 m .36452 .48066 L .36583 .47565 L F
.36265 .48349 m .36452 .48066 L .36209 .48315 L F
.36452 .48066 m .37587 .46352 L .36583 .47565 L F
.924 .795 .7 r
.36362 .4841 m .37323 .46081 L p .36266 .48358 L F P
0 g
s
.924 .795 .7 r
.37323 .46081 m .3706 .45903 L p .36225 .48336 L F P
0 g
s
.924 .795 .7 r
.36266 .48358 m .37323 .46081 L .36225 .48336 L F
.3706 .45903 m .36362 .4841 L p .36225 .48336 L F P
0 g
s
.948 .827 .691 r
.36811 .45825 m .36362 .4841 L p .3624 .48358 L F P
0 g
s
.948 .827 .691 r
.36362 .4841 m .3706 .45903 L p .36272 .48371 L F P
0 g
s
.948 .827 .691 r
.36272 .48371 m .36279 .4835 L .3624 .48358 L F
.36279 .4835 m .3706 .45903 L .3625 .48329 L F
.36279 .4835 m .3625 .48329 L .3624 .48358 L F
.3706 .45903 m .36811 .45825 L p .36247 .48328 L F P
0 g
s
.948 .827 .691 r
.3625 .48329 m .3706 .45903 L .36247 .48328 L F
.972 .854 .666 r
.36276 .4841 m .36811 .45825 L .36252 .4841 L F
.36362 .4841 m .36285 .48363 L .36237 .48598 L F
.36362 .4841 m .36237 .48598 L .36226 .48651 L F
.36362 .4841 m .36226 .48651 L .36211 .48721 L F
.99 .871 .615 r
.36272 .48402 m .36362 .4841 L .36282 .48831 L F
.972 .854 .666 r
.36211 .48721 m .36276 .4841 L .36252 .4841 L F
.99 .871 .615 r
.36139 .50954 m .36362 .4841 L p .36272 .48402 L F P
0 g
s
.993 .866 .53 r
.36289 .48426 m .36362 .4841 L .36309 .48666 L F
.36327 .50814 m .36362 .4841 L p .36289 .48426 L F P
0 g
s
.967 .825 .402 r
.36303 .48382 m .36339 .48399 L .36356 .48537 L F
.993 .866 .53 r
.36362 .4841 m .36469 .50578 L p .36328 .48896 L F P
0 g
s
.967 .825 .402 r
.36347 .48705 m .36356 .48537 L .36378 .48725 L F
.36394 .49049 m .36378 .48725 L .36559 .50258 L F
.36347 .48705 m .36378 .48725 L .36394 .49049 L F
.993 .866 .53 r
.36309 .48666 m .36362 .4841 L .36328 .48896 L F
.967 .825 .402 r
.36303 .48382 m .36356 .48537 L .36347 .48705 L F
.36559 .50258 m .36469 .50578 L p .36331 .48756 L F P
0 g
s
.967 .825 .402 r
.36331 .48756 m .36303 .48382 L .3634 .48656 L F
.36331 .48756 m .3634 .48656 L .36559 .50258 L F
.948 .827 .691 r
.35914 .50991 m .35662 .50923 L p .36102 .48972 L F P
0 g
s
.948 .827 .691 r
.36102 .48972 m .3624 .48358 L .36187 .48788 L F
.36102 .48972 m .36187 .48788 L .35914 .50991 L F
.967 .825 .402 r
.36326 .48686 m .36362 .4841 L .36303 .48382 L F
.36469 .50578 m .36362 .4841 L p .36326 .48686 L F P
0 g
s
.967 .825 .402 r
.36362 .4841 m .36559 .50258 L p .36351 .48496 L F P
0 g
s
.904 .739 .24 r
.36362 .4841 m .36593 .49868 L p .36357 .48478 L F P
0 g
s
.904 .739 .24 r
.36559 .50258 m .36362 .4841 L p .36451 .49425 L F P
0 g
s
.904 .739 .24 r
.36451 .49425 m .36362 .4841 L .36344 .48595 L F
.817 .622 .067 r
.36362 .4841 m .36571 .49428 L p .36365 .48529 L F P
0 g
s
.967 .825 .402 r
.36339 .48399 m .36362 .4841 L .36351 .48496 L F
.904 .739 .24 r
.36342 .48391 m .36362 .4841 L .36357 .48478 L F
.36344 .48595 m .36362 .4841 L .36314 .48366 L F
.36331 .48443 m .36348 .48425 L .36593 .49868 L F
.817 .622 .067 r
.36483 .49246 m .36362 .4841 L .36334 .48405 L F
.729 .498 0 r
.36401 .48643 m .36362 .4841 L .36364 .48471 L F
.972 .854 .666 r
.36587 .45852 m .36362 .4841 L p .36256 .4838 L F P
0 g
s
.972 .854 .666 r
.36811 .45825 m .36587 .45852 L p .36252 .4841 L F P
0 g
s
.972 .854 .666 r
.36362 .4841 m .36811 .45825 L p .36426 .47684 L F P
0 g
s
.972 .854 .666 r
.36362 .4841 m .36426 .47684 L .3629 .48339 L F
.36362 .4841 m .3629 .48339 L .36285 .48363 L F
.99 .871 .615 r
.36362 .4841 m .36587 .45852 L p .36272 .48402 L F P
0 g
s
.99 .871 .615 r
.36398 .45983 m .36362 .4841 L p .36272 .48402 L F P
0 g
s
.99 .871 .615 r
.36587 .45852 m .36398 .45983 L p .36272 .48402 L F P
0 g
s
.993 .866 .53 r
.36362 .4841 m .36398 .45983 L p .36289 .48426 L F P
0 g
s
.993 .866 .53 r
.36255 .46213 m .36362 .4841 L p .36289 .48426 L F P
0 g
s
.993 .866 .53 r
.36398 .45983 m .36255 .46213 L p .36289 .48426 L F P
0 g
s
.967 .825 .402 r
.36362 .4841 m .36255 .46213 L p .36303 .48382 L F P
0 g
s
.967 .825 .402 r
.36303 .48382 m .36241 .47566 L .36339 .48399 L F
.904 .739 .24 r
.36306 .48303 m .36337 .48362 L .36348 .48425 L F
.817 .622 .067 r
.36321 .48337 m .36362 .4841 L .36365 .48529 L F
.729 .498 0 r
.36364 .48471 m .36362 .4841 L .36347 .48392 L F
.36571 .49428 m .36362 .4841 L p .36401 .48643 L F P
0 g
s
.924 .795 .7 r
.36079 .48761 m .36166 .48574 L .36134 .48601 L F
.902 .764 .699 r
.35971 .48794 m .36128 .48556 L .36072 .48591 L F
.883 .733 .691 r
.35795 .48847 m .36099 .48528 L .35988 .48577 L F
.729 .498 0 r
.36347 .48392 m .36353 .48399 L .36375 .48487 L F
.36382 .48527 m .36375 .48487 L .36492 .48956 L F
.36347 .48392 m .36375 .48487 L .36382 .48527 L F
.838 .601 .579 r
.34115 .47822 m .36083 .48138 L .35497 .48184 