(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   2462253,     156387]*)
(*NotebookOutlinePosition[   2471449,     156652]*)
(*  CellTagsIndexPosition[   2470598,     156619]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Algebra",
 StyleBox["`", "MB"],
 "Horner",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.3.1", "1.1"}],

Cell["\<\
This package applies Horner\[CloseCurlyQuote]s rule to rearrange polynomials \
in Horner form. This is useful for efficient and stable numerical evaluation. \
Any polynomial can be rewritten in Horner, or nested, form. \
\>", "Text",
 CellTags->{"S5.3.1", "1.2"}],

Cell[BoxData[
 FormBox[Cell[BoxData[
   FormBox[GridBox[{
      {Cell[TextData[StyleBox[Cell[BoxData[
        FormBox[
         StyleBox[
          RowBox[{
           StyleBox["p",
            "TI"], 
           RowBox[{"(", 
            StyleBox["x",
             "TI"], ")"}]}],
          "DisplayFormula"], TraditionalForm]],
        UnderoverscriptBoxOptions->{LimitsPositioning->True},
        GridBoxOptions->{ColumnWidths->Automatic}],
        UnderoverscriptBoxOptions->{LimitsPositioning->True},
        GridBoxOptions->{ColumnWidths->Automatic}]],
        UnderoverscriptBoxOptions->{LimitsPositioning->True},
        GridBoxOptions->{ColumnWidths->Automatic}], Cell[TextData[StyleBox[
       Cell[BoxData[
        FormBox[
         StyleBox["=",
          "DisplayFormula"], TraditionalForm]],
        UnderoverscriptBoxOptions->{LimitsPositioning->True},
        GridBoxOptions->{ColumnWidths->Automatic}],
        UnderoverscriptBoxOptions->{LimitsPositioning->True},
        GridBoxOptions->{ColumnWidths->Automatic}]],
        UnderoverscriptBoxOptions->{LimitsPositioning->True},
        GridBoxOptions->{ColumnWidths->Automatic}], Cell[TextData[StyleBox[
       Cell[BoxData[
        FormBox[
         StyleBox[
          RowBox[{
           SubscriptBox[
            StyleBox["a",
             "TI"], "0"], " ", 
           SuperscriptBox[
            StyleBox["x",
             "TI"], 
            StyleBox["n",
             "TI"]], "+", "\[CenterEllipsis]", "+", 
           SubscriptBox[
            StyleBox["a",
             "TI"], 
            RowBox[{
             StyleBox["n",
              "TI"], "-", "1"}]], " ", 
           StyleBox["x",
            "TI"], "+", 
           SubscriptBox[
            StyleBox["a",
             "TI"], 
            StyleBox["n",
             "TI"]]}],
          "DisplayFormula"], TraditionalForm]],
        UnderoverscriptBoxOptions->{LimitsPositioning->True},
        GridBoxOptions->{ColumnWidths->Automatic}],
        UnderoverscriptBoxOptions->{LimitsPositioning->True},
        GridBoxOptions->{ColumnWidths->Automatic}]],
        UnderoverscriptBoxOptions->{LimitsPositioning->True},
        GridBoxOptions->{ColumnWidths->Automatic}]},
      {Cell[TextData[StyleBox[Cell[BoxData[
        FormBox[
         StyleBox["\[Null]",
          "DisplayFormula"], TraditionalForm]],
        UnderoverscriptBoxOptions->{LimitsPositioning->True},
        GridBoxOptions->{ColumnWidths->Automatic}],
        UnderoverscriptBoxOptions->{LimitsPositioning->True},
        GridBoxOptions->{ColumnWidths->Automatic}]],
        UnderoverscriptBoxOptions->{LimitsPositioning->True},
        GridBoxOptions->{ColumnWidths->Automatic}], Cell[TextData[StyleBox[
       Cell[BoxData[
        FormBox[
         StyleBox["=",
          "DisplayFormula"], TraditionalForm]],
        UnderoverscriptBoxOptions->{LimitsPositioning->True},
        GridBoxOptions->{ColumnWidths->Automatic}],
        UnderoverscriptBoxOptions->{LimitsPositioning->True},
        GridBoxOptions->{ColumnWidths->Automatic}]],
        UnderoverscriptBoxOptions->{LimitsPositioning->True},
        GridBoxOptions->{ColumnWidths->Automatic}], Cell[TextData[StyleBox[
       Cell[BoxData[
        FormBox[
         StyleBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"\[CenterEllipsis]", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 SubscriptBox[
                  StyleBox["a",
                   "TI"], "0"], " ", 
                 StyleBox["x",
                  "TI"], "+", 
                 SubscriptBox[
                  StyleBox["a",
                   "TI"], "1"]}], ")"}], " ", 
               StyleBox["x",
                "TI"], "+", 
               SubscriptBox[
                StyleBox["a",
                 "TI"], "2"]}], ")"}], " ", 
             StyleBox["x",
              "TI"], "+", "\[CenterEllipsis]", 
             SubscriptBox[
              StyleBox["a",
               "TI"], 
              RowBox[{
               StyleBox["n",
                "TI"], "-", "1"}]]}], ")"}], " ", 
           StyleBox["x",
            "TI"], "+", 
           SubscriptBox[
            StyleBox["a",
             "TI"], 
            StyleBox["n",
             "TI"]]}],
          "DisplayFormula"], TraditionalForm]],
        UnderoverscriptBoxOptions->{LimitsPositioning->True},
        GridBoxOptions->{ColumnWidths->Automatic}],
        UnderoverscriptBoxOptions->{LimitsPositioning->True},
        GridBoxOptions->{ColumnWidths->Automatic}]],
        UnderoverscriptBoxOptions->{LimitsPositioning->True},
        GridBoxOptions->{ColumnWidths->Automatic}]}
      },
     ColumnAlignments->{Right, Center, Left}], TraditionalForm]],
   UnderoverscriptBoxOptions->{LimitsPositioning->True},
   GridBoxOptions->{ColumnWidths->Automatic}], 
  TraditionalForm]], "DisplayFormula",
 UnderoverscriptBoxOptions->{LimitsPositioning->True},
 GridBoxOptions->{ColumnWidths->Automatic},
 CellTags->{"S5.3.1", "1.3"}],

Cell[TextData[{
 "Assume that ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["x",
     "TI"], 
    StyleBox["n",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " can be calculated using only ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["log", "2"], 
    RowBox[{"(", 
     StyleBox["n",
      "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " multiplications for integer ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "\[NonBreakingSpace]",
 Cell[BoxData[
  FormBox[
   RowBox[{"[", "1", "]"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". For a polynomial of degree ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", the Horner form requires ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " multiplications and ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " additions. The expanded form, however, requires ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{
      StyleBox["i",
       "TI"], "=", "1"}], 
     StyleBox["n",
      "TI"],
     LimitsPositioning->True], 
    SubscriptBox["log", "2"], 
    RowBox[{"(", 
     StyleBox["i",
      "TI"], ")"}], "=", 
    SubscriptBox["log", "2"], 
    RowBox[{"(", 
     RowBox[{"\[CapitalGamma]", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        StyleBox["n",
         "TI"]}], ")"}]}], ")"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " multiplications, which is already more than twice as expensive for a \
polynomial of degree 10. Thus, one advantage of Horner form is that the work \
involved in exponentiation is distributed across addition and multiplication, \
resulting in savings of some basic arithmetic operations. Another advantage \
is that Horner form is more stable to evaluate numerically when compared with \
the expanded form. The reason for this is that each sum and product involve \
quantities which vary on a more evenly distributed scale. "
}], "Text",
 CellTags->{"S5.3.1", "1.4"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["Horner[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["poly", "TI",
       UnderoverscriptBoxOptions->{LimitsPositioning->True},
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4,
       ColumnWidths->Automatic}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["put the polynomial ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["poly", "TI",
       UnderoverscriptBoxOptions->{LimitsPositioning->True},
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4,
       ColumnWidths->Automatic}],
      StyleBox[" in Horner form",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Horner[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["poly", "TI",
       UnderoverscriptBoxOptions->{LimitsPositioning->True},
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4,
       ColumnWidths->Automatic}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["vars", "TI",
       UnderoverscriptBoxOptions->{LimitsPositioning->True},
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4,
       ColumnWidths->Automatic}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["put the polynomial ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["poly", "TI",
       UnderoverscriptBoxOptions->{LimitsPositioning->True},
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4,
       ColumnWidths->Automatic}],
      StyleBox[
      " in Horner form with respect to the variable or list of variables ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["vars", "TI",
       UnderoverscriptBoxOptions->{LimitsPositioning->True},
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4,
       ColumnWidths->Automatic}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.3.1"],

Cell["Factoring polynomials in Horner or nested form. ", "Caption",
 CellTags->"S5.3.1"],

Cell[TextData[{
 "The function ",
 StyleBox["Horner", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 " can be used for both univariate and multivariate polynomials. It also \
works efficiently on both sparse and dense polynomials and fractional \
exponents. "
}], "Text",
 CellTags->{"S5.3.1", "1.5"}],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.3.1", "1.6"}],

Cell["<<Algebra`Horner`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.3.1"],

Cell[TextData[{
 "By using the ",
 StyleBox["Variables", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 " function, ",
 StyleBox["Horner", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 " puts the polynomial into Horner form with respect to the variables \
identified using ",
 StyleBox["Variables", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 ". "
}], "MathCaption",
 CellTags->{"S5.3.1", "1.7"}],

Cell[CellGroupData[{

Cell["Horner[11 x^3 -4 x^2 + 7 x + 2]", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.3.1"],

Cell[BoxData[
 RowBox[{"2", "+", 
  RowBox[{"x", " ", 
   RowBox[{"(", 
    RowBox[{"7", "+", 
     RowBox[{"x", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "4"}], "+", 
        RowBox[{"11", " ", "x"}]}], ")"}]}]}], ")"}]}]}]], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.3.1"]
}, Open  ]],

Cell[TextData[{
 "Here the coefficients of the polynomial are symbolic, so it is important to \
specify the variable ",
 Cell[BoxData[
  FormBox[
   StyleBox["x",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.3.1", "1.8"}],

Cell[CellGroupData[{

Cell["Horner[a x^3 + b x^2 + c x + d, x]", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.3.1"],

Cell[BoxData[
 RowBox[{"d", "+", 
  RowBox[{"x", " ", 
   RowBox[{"(", 
    RowBox[{"c", "+", 
     RowBox[{"x", " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", 
        RowBox[{"a", " ", "x"}]}], ")"}]}]}], ")"}]}]}]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.3.1"]
}, Open  ]],

Cell["\<\
The exponents of a polynomial do not need to be integers, nor do they need to \
be of equal increments. The nested polynomial is scaled by the smallest \
exponent. \
\>", "MathCaption",
 CellTags->{"S5.3.1", "1.9"}],

Cell[CellGroupData[{

Cell["Horner[x^(1/3) + x + x^(3/2)]", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.3.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"1", "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SqrtBox["x"]}], ")"}], " ", 
     SuperscriptBox["x", 
      RowBox[{"2", "/", "3"}]]}]}], ")"}], " ", 
  SuperscriptBox["x", 
   RowBox[{"1", "/", "3"}]]}]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.3.1"]
}, Open  ]],

Cell["\<\
Exponents must be integers or rational numbers for the expression to be \
considered a valid polynomial. \
\>", "MathCaption",
 CellTags->{"S5.3.1", "1.10"}],

Cell[CellGroupData[{

Cell["Horner[1 + x^a, x]", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.3.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Horner", "::", "\<\"fail\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"The expression \\!\\(1 + x\\^a\\) is not a valid \
polynomial in the variable \\!\\(x\\)\"\>"}]], "Message",
 CellTags->"S5.3.1"],

Cell[BoxData[
 RowBox[{"Horner", "[", 
  RowBox[{
   RowBox[{"1", "+", 
    SuperscriptBox["x", "a"]}], ",", "x"}], "]"}]], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S5.3.1"]
}, Open  ]],

Cell["This constructs a bivariate polynomial. ", "MathCaption",
 CellTags->{"S5.3.1", "1.11"}],

Cell[CellGroupData[{

Cell["\<\
bipoly = Sum[i j  x^i y^j,
             {i, 0, 2}, {j, 0, 2}]\
\>", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.3.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", " ", "y"}], "+", 
  RowBox[{"2", " ", 
   SuperscriptBox["x", "2"], " ", "y"}], "+", 
  RowBox[{"2", " ", "x", " ", 
   SuperscriptBox["y", "2"]}], "+", 
  RowBox[{"4", " ", 
   SuperscriptBox["x", "2"], " ", 
   SuperscriptBox["y", "2"]}]}]], "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S5.3.1"]
}, Open  ]],

Cell[TextData[{
 "Here the polynomial is put in Horner form first with respect to ",
 Cell[BoxData[
  FormBox[
   StyleBox["x",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and then with respect to ",
 Cell[BoxData[
  FormBox[
   StyleBox["y",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.3.1", "1.12"}],

Cell[CellGroupData[{

Cell["Horner[bipoly, {x, y}]", "Input",
 CellLabel->"In[7]:= ",
 CellTags->"S5.3.1"],

Cell[BoxData[
 RowBox[{"x", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"y", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"2", " ", "y"}]}], ")"}]}], "+", 
    RowBox[{"x", " ", "y", " ", 
     RowBox[{"(", 
      RowBox[{"2", "+", 
       RowBox[{"4", " ", "y"}]}], ")"}]}]}], ")"}]}]], "Output",
 CellLabel->"Out[7]= ",
 CellTags->"S5.3.1"]
}, Open  ]],

Cell[TextData[{
 "The factorization that you obtain is dependent upon the ordering of the \
variables which you specify. In this example, the polynomial is put in Horner \
form first with respect to ",
 Cell[BoxData[
  FormBox[
   StyleBox["y",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and then with respect to ",
 Cell[BoxData[
  FormBox[
   StyleBox["x",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.3.1", "1.13"}],

Cell[CellGroupData[{

Cell["hornerbipoly = Horner[bipoly, {y, x}]", "Input",
 CellLabel->"In[8]:= ",
 CellTags->"S5.3.1"],

Cell[BoxData[
 RowBox[{"y", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"2", " ", "x"}]}], ")"}]}], "+", 
    RowBox[{"x", " ", 
     RowBox[{"(", 
      RowBox[{"2", "+", 
       RowBox[{"4", " ", "x"}]}], ")"}], " ", "y"}]}], ")"}]}]], "Output",
 CellLabel->"Out[8]= ",
 CellTags->"S5.3.1"]
}, Open  ]],

Cell["\<\
Polynomials are often evaluated using machine\[Hyphen]precision floating\
\[Hyphen]point arithmetic. This is an inexact process because there are only \
finitely many numbers available in the representation. Therefore, different \
methods of evaluation will give different answers. The following example \
illustrates how numerical stability of a polynomial can be improved using \
Horner form. The example also illustrates how the time required for \
evaluation can be significantly reduced. Timings will be different for \
different computers, but the relative timings should be similar. \
\>", "Text",
 CellTags->{"S5.3.1", "1.14"}],

Cell["Define the derivative of a Legendre polynomial. ", "MathCaption",
 CellTags->{"S5.3.1", "1.15"}],

Cell["dpoly[x_] = D[LegendreP[50, x], x];", "Input",
 CellLabel->"In[9]:= ",
 CellTags->"S5.3.1"],

Cell[TextData[{
 "This plots the polynomial and gives the time required for evaluation. ",
 StyleBox["Plot", "MR"],
 " uses machine\[Hyphen]precision numbers to evaluate the polynomial by \
default. The plot is not very smooth due to the accumulation of \
representation errors associated with machine\[Hyphen]precision computations. \
"
}], "MathCaption",
 CellTags->{"S5.3.1", "1.16"}],

Cell[CellGroupData[{

Cell["\<\
Plot[Evaluate[dpoly[x]], {x, 1, 1.01},
  PlotRange -> All, PlotPoints -> 2000]//Timing\
\>", "Input",
 CellLabel->"In[10]:= ",
 CellTags->"S5.3.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-95.2143 95.2381 0.0819016 6.51601e-06 [
[.21429 .0694 -15 -9 ]
[.21429 .0694 15 0 ]
[.40476 .0694 -15 -9 ]
[.40476 .0694 15 0 ]
[.59524 .0694 -15 -9 ]
[.59524 .0694 15 0 ]
[.78571 .0694 -15 -9 ]
[.78571 .0694 15 0 ]
[.97619 .0694 -12 -9 ]
[.97619 .0694 12 0 ]
[.01131 .21222 -30 -4.5 ]
[.01131 .21222 0 4.5 ]
[.01131 .34254 -30 -4.5 ]
[.01131 .34254 0 4.5 ]
[.01131 .47286 -30 -4.5 ]
[.01131 .47286 0 4.5 ]
[.01131 .60318 -30 -4.5 ]
[.01131 .60318 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .0819 m
.21429 .08815 L
s
[(1.002)] .21429 .0694 0 1 Mshowa
.40476 .0819 m
.40476 .08815 L
s
[(1.004)] .40476 .0694 0 1 Mshowa
.59524 .0819 m
.59524 .08815 L
s
[(1.006)] .59524 .0694 0 1 Mshowa
.78571 .0819 m
.78571 .08815 L
s
[(1.008)] .78571 .0694 0 1 Mshowa
.97619 .0819 m
.97619 .08815 L
s
[(1.01)] .97619 .0694 0 1 Mshowa
.125 Mabswid
.07143 .0819 m
.07143 .08565 L
s
.11905 .0819 m
.11905 .08565 L
s
.16667 .0819 m
.16667 .08565 L
s
.2619 .0819 m
.2619 .08565 L
s
.30952 .0819 m
.30952 .08565 L
s
.35714 .0819 m
.35714 .08565 L
s
.45238 .0819 m
.45238 .08565 L
s
.5 .0819 m
.5 .08565 L
s
.54762 .0819 m
.54762 .08565 L
s
.64286 .0819 m
.64286 .08565 L
s
.69048 .0819 m
.69048 .08565 L
s
.7381 .0819 m
.7381 .08565 L
s
.83333 .0819 m
.83333 .08565 L
s
.88095 .0819 m
.88095 .08565 L
s
.92857 .0819 m
.92857 .08565 L
s
.25 Mabswid
0 .0819 m
1 .0819 L
s
.02381 .21222 m
.03006 .21222 L
s
[(20000)] .01131 .21222 1 0 Mshowa
.02381 .34254 m
.03006 .34254 L
s
[(40000)] .01131 .34254 1 0 Mshowa
.02381 .47286 m
.03006 .47286 L
s
[(60000)] .01131 .47286 1 0 Mshowa
.02381 .60318 m
.03006 .60318 L
s
[(80000)] .01131 .60318 1 0 Mshowa
.125 Mabswid
.02381 .11448 m
.02756 .11448 L
s
.02381 .14706 m
.02756 .14706 L
s
.02381 .17964 m
.02756 .17964 L
s
.02381 .2448 m
.02756 .2448 L
s
.02381 .27738 m
.02756 .27738 L
s
.02381 .30996 m
.02756 .30996 L
s
.02381 .37512 m
.02756 .37512 L
s
.02381 .4077 m
.02756 .4077 L
s
.02381 .44028 m
.02756 .44028 L
s
.02381 .50544 m
.02756 .50544 L
s
.02381 .53802 m
.02756 .53802 L
s
.02381 .5706 m
.02756 .5706 L
s
.02381 .04932 m
.02756 .04932 L
s
.02381 .01674 m
.02756 .01674 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
.5 Mabswid
.02381 .09418 m
.02427 .10309 L
.02429 .07562 L
.0243 .10549 L
.02431 .10087 L
.02432 .09956 L
.02433 .10093 L
.02435 .10211 L
.02436 .10069 L
.02438 .10606 L
.02439 .11252 L
.0244 .10697 L
.02441 .06441 L
.02441 .11872 L
.02442 .08437 L
.02443 .08731 L
.02444 .08989 L
.02446 .08406 L
.02447 .12175 L
.02448 .10468 L
.0245 .0974 L
.02451 .08211 L
.02452 .09029 L
.02453 .01472 L
.02454 .11047 L
.02455 .11348 L
.02456 .06501 L
.02457 .11295 L
.02458 .11269 L
.02459 .10468 L
.0246 .12782 L
.02461 .07698 L
.02461 .103 L
.02462 .09458 L
.02463 .06838 L
.02464 .08995 L
.02465 .0793 L
.02466 .08424 L
.02467 .10825 L
.02468 .1034 L
.02469 .09865 L
.0247 .09214 L
.02471 .09557 L
.02472 .12536 L
.02473 .08415 L
.02475 .10542 L
.02476 .09653 L
.02477 .1231 L
.02478 .11395 L
.02479 .08046 L
Mistroke
.02481 .10012 L
.02482 .06249 L
.02482 .05745 L
.02484 .09103 L
.02485 .12198 L
.02487 .11384 L
.02488 .07017 L
.0249 .07875 L
.0249 .05837 L
.02491 .08651 L
.02493 .08442 L
.02494 .0997 L
.02494 .10915 L
.02495 .08967 L
.02496 .085 L
.02498 .09279 L
.02499 .07121 L
.025 .11319 L
.02501 .13542 L
.02502 .10164 L
.02504 .14072 L
.02505 .05304 L
.02506 .09908 L
.02508 .07965 L
.02509 .05916 L
.02511 .06077 L
.02512 .09425 L
.02514 .0832 L
.02515 .08139 L
.02516 .0879 L
.02518 .08327 L
.02519 .06436 L
.0252 .10579 L
.02521 .08578 L
.02523 .04912 L
.02524 .10191 L
.02525 .09953 L
.02527 .0836 L
.02528 .07744 L
.0253 .09615 L
.02531 .09449 L
.02532 .0837 L
.02533 .11872 L
.02534 .09835 L
.02536 .09712 L
.02537 .09891 L
.02538 .07202 L
.0254 .14123 L
.02541 .04208 L
.02542 .12195 L
Mistroke
.02544 .086 L
.02545 .0595 L
.02547 .10171 L
.02548 .07752 L
.02549 .14599 L
.0255 .10737 L
.02551 .0727 L
.02552 .10386 L
.02554 .08134 L
.02555 .11428 L
.02556 .09761 L
.02557 .07899 L
.02558 .09721 L
.02559 .05639 L
.0256 .11955 L
.0256 .12216 L
.02562 .05556 L
.02563 .11253 L
.02564 .08864 L
.02565 .11867 L
.02567 .09398 L
.02568 .14161 L
.0257 .07741 L
.02571 .09587 L
.02573 .10773 L
.02574 .09327 L
.02575 .07856 L
.02577 .10598 L
.02578 .1349 L
.0258 .10145 L
.02581 .08536 L
.02583 .09175 L
.02584 .12673 L
.02586 .08594 L
.02586 .0727 L
.02587 .09755 L
.02589 .07942 L
.0259 .03845 L
.02591 .09034 L
.02592 .11039 L
.02593 .09334 L
.02594 .08078 L
.02595 .0935 L
.02596 .08545 L
.02597 .10738 L
.02598 .12172 L
.026 .10906 L
.02601 .11195 L
.02601 .10584 L
.02602 .12507 L
Mistroke
.02603 .09093 L
.02604 .09344 L
.02605 .10334 L
.02606 .07412 L
.02607 .11099 L
.02607 .08926 L
.02608 .07601 L
.02609 .09909 L
.0261 .10965 L
.02611 .0825 L
.02613 .14518 L
.02614 .10744 L
.02614 .11284 L
.02616 .05813 L
.02618 .09597 L
.02619 .11793 L
.02621 .08607 L
.02622 .09219 L
.02623 .08348 L
.02625 .09798 L
.02626 .10087 L
.02628 .09105 L
.02629 .06621 L
.0263 .10085 L
.02631 .10633 L
.02632 .11844 L
.02634 .08061 L
.02635 .07698 L
.02636 .06847 L
.02638 .13275 L
.02639 .07369 L
.0264 .09179 L
.02642 .11868 L
.02643 .02856 L
.02645 .0691 L
.02646 .09652 L
.02647 .07425 L
.02648 .09603 L
.02649 .06465 L
.02651 .10484 L
.02652 .08486 L
.02652 .08956 L
.02654 .12114 L
.02655 .11772 L
.02656 .06173 L
.02656 .07916 L
.02657 .10516 L
.02659 .08688 L
.0266 .10077 L
.02661 .09525 L
Mistroke
.02662 .09102 L
.02663 .08511 L
.02664 .07415 L
.02665 .11085 L
.02666 .08866 L
.02668 .11041 L
.02669 .08722 L
.02671 .11958 L
.02672 .08628 L
.02674 .07303 L
.02675 .09472 L
.02677 .08383 L
.02677 .1254 L
.02678 .08081 L
.0268 .1209 L
.02681 .07736 L
.02683 .09658 L
.02684 .10394 L
.02685 .10776 L
.02687 .07564 L
.02688 .13307 L
.0269 .07447 L
.02691 .059 L
.02692 .09391 L
.02693 .09046 L
.02694 .11969 L
.02696 .10223 L
.02697 .07725 L
.02699 .065 L
.02699 .09067 L
.027 .07754 L
.02701 .04696 L
.02702 .11884 L
.02703 .0818 L
.02704 .08403 L
.02705 .08391 L
.02707 .07642 L
.02708 .07977 L
.0271 .10334 L
.02711 .10448 L
.02712 .10318 L
.02713 .08392 L
.02714 .09401 L
.02716 .11892 L
.02717 .11399 L
.02719 .15287 L
.0272 .04108 L
.02722 .08307 L
.02723 .07767 L
.02725 .11271 L
Mistroke
.02726 .10319 L
.02727 .09739 L
.02729 .0284 L
.0273 .1121 L
.02732 .11797 L
.02733 .09671 L
.02734 .10346 L
.02736 .12291 L
.02737 .11227 L
.02738 .10035 L
.02739 .07016 L
.02741 .0947 L
.02742 .09779 L
.02743 .1086 L
.02745 .12664 L
.02746 .11741 L
.02747 .07171 L
.02749 .08233 L
.0275 .11473 L
.02751 .12548 L
.02753 .06861 L
.02754 .12182 L
.02755 .07283 L
.02757 .06903 L
.02758 .09755 L
.02759 .12775 L
.0276 .08896 L
.02761 .08334 L
.02763 .08624 L
.02764 .18107 L
.02765 .13466 L
.02767 .05625 L
.02768 .12351 L
.0277 .11677 L
.02771 .1117 L
.02773 .11899 L
.02774 .11595 L
.02775 .09976 L
.02776 .10679 L
.02776 .09129 L
.02777 .09082 L
.02779 .06734 L
.0278 .10927 L
.02782 .10586 L
.02783 .12875 L
.02785 .1273 L
.02786 .11756 L
.02788 .09401 L
.02789 .08382 L
.0279 .13146 L
Mistroke
.02792 .09211 L
.02793 .10131 L
.02795 .05082 L
.02796 .09778 L
.02798 .07452 L
.02799 .13177 L
.028 .10578 L
.02802 .10628 L
.02803 .09407 L
.02804 .1156 L
.02806 .08625 L
.02807 .09061 L
.02808 .06748 L
.0281 .10077 L
.0281 .08843 L
.02811 .06913 L
.02813 .10184 L
.02814 .07464 L
.02815 .08846 L
.02817 .0986 L
.02818 .0692 L
.0282 .10589 L
.02821 .09889 L
.02822 .09509 L
.02823 .09565 L
.02824 .13837 L
.02825 .08084 L
.02826 .10532 L
.02827 .07235 L
.02829 .08312 L
.0283 .09206 L
.02832 .11253 L
.02833 .09063 L
.02834 .09622 L
.02836 .11435 L
.02837 .08268 L
.02838 .07261 L
.0284 .09257 L
.02841 .09987 L
.02842 .06319 L
.02844 .06733 L
.02845 .1073 L
.02847 .0975 L
.02848 .0968 L
.02849 .10927 L
.02851 .10047 L
.02852 .10546 L
.02854 .09743 L
.02855 .11996 L
.02857 .12076 L
Mistroke
.02858 .12817 L
.02858 .08862 L
.02859 .07465 L
.0286 .08974 L
.02862 .10198 L
.02863 .08167 L
.02864 .10707 L
.02866 .07314 L
.02867 .08287 L
.02869 .06681 L
.0287 .07855 L
.02871 .08101 L
.02873 .07728 L
.02874 .0881 L
.02876 .07347 L
.02877 .1081 L
.02879 .07929 L
.0288 .10426 L
.02881 .12209 L
.02882 .06774 L
.02884 .09255 L
.02884 .10029 L
.02885 .1368 L
.02887 .12641 L
.02888 .09619 L
.02889 .11631 L
.02889 .10669 L
.0289 .06059 L
.02892 .06529 L
.02893 .05634 L
.02893 .06653 L
.02895 .08723 L
.02897 .10976 L
.02898 .10733 L
.02899 .11142 L
.02901 .10269 L
.02902 .08224 L
.02904 .09252 L
.02905 .06498 L
.02907 .11053 L
.02908 .0357 L
.0291 .1114 L
.02911 .10774 L
.02912 .07631 L
.02914 .06409 L
.02914 .10083 L
.02915 .11059 L
.02916 .09265 L
.02917 .08507 L
.02919 .07407 L
Mistroke
.02919 .09513 L
.0292 .08635 L
.02922 .08374 L
.02923 .11335 L
.02925 .10451 L
.02926 .11549 L
.02928 .12779 L
.02928 .11128 L
.02929 .09599 L
.02931 .05787 L
.02932 .1235 L
.02932 .06981 L
.02934 .10084 L
.02935 .08463 L
.02937 .0862 L
.02938 .11862 L
.02939 .11982 L
.0294 .0969 L
.02941 .0593 L
.02942 .09012 L
.02943 .10248 L
.02945 .09591 L
.02945 .09141 L
.02946 .11816 L
.02947 .08161 L
.02948 .08803 L
.02949 .08455 L
.0295 .09767 L
.02951 .06425 L
.02953 .11026 L
.02954 .0991 L
.02956 .09666 L
.02957 .08635 L
.02959 .11035 L
.0296 .07995 L
.02961 .0846 L
.02963 .07131 L
.02964 .07931 L
.02965 .08323 L
.02966 .07862 L
.02967 .112 L
.02968 .08953 L
.02969 .10518 L
.0297 .06259 L
.02972 .09733 L
.02974 .07138 L
.02975 .07749 L
.02976 .0575 L
.02978 .06643 L
.02979 .05897 L
Mistroke
.0298 .12481 L
.02981 .1134 L
.02983 .11809 L
.02984 .10868 L
.02986 .09616 L
.02987 .08414 L
.02988 .1011 L
.0299 .0954 L
.02991 .09407 L
.02993 .09738 L
.02994 .13686 L
.02995 .10109 L
.02997 .03106 L
.02998 .07716 L
.03 .08846 L
.03001 .14206 L
.03003 .10013 L
.03004 .06481 L
.03005 .10496 L
.03007 .06944 L
.03008 .12012 L
.03009 .09689 L
.0301 .13722 L
.03011 .09783 L
.03011 .08899 L
.03013 .08585 L
.03014 .08574 L
.03015 .11577 L
.03016 .10421 L
.03017 .08035 L
.03019 .09514 L
.03021 .05632 L
.03022 .06446 L
.03024 .10383 L
.03024 .1048 L
.03025 .09911 L
.03027 .06755 L
.03028 .0847 L
.0303 .05418 L
.03031 .10117 L
.03033 .09482 L
.03033 .07787 L
.03034 .07294 L
.03036 .13409 L
.03037 .09702 L
.03038 .08323 L
.03038 .12034 L
.03039 .09277 L
.03041 .1132 L
.03042 .10506 L
Mistroke
.03043 .09909 L
.03044 .08037 L
.03045 .08688 L
.03046 .1035 L
.03047 .08982 L
.03048 .12032 L
.03049 .09009 L
.0305 .11541 L
.03052 .10451 L
.03053 .10819 L
.03054 .11334 L
.03056 .06198 L
.03057 .12638 L
.03059 .07725 L
.0306 .08244 L
.03062 .10152 L
.03063 .10425 L
.03064 .11723 L
.03065 .0959 L
.03066 .08604 L
.03068 .07292 L
.03069 .077 L
.03069 .10841 L
.03071 .0962 L
.03072 .08905 L
.03073 .11627 L
.03075 .07815 L
.03076 .09958 L
.03078 .08667 L
.03079 .10922 L
.0308 .1009 L
.03081 .11224 L
.03083 .07911 L
.03084 .08603 L
.03086 .08675 L
.03087 .08378 L
.03089 .10733 L
.0309 .07382 L
.03092 .09002 L
.03093 .08008 L
.03095 .12356 L
.03095 .1215 L
.03096 .07766 L
.03098 .09945 L
.03099 .08278 L
.03101 .09948 L
.03102 .11457 L
.03104 .12845 L
.03104 .07099 L
.03105 .07691 L
Mistroke
.03106 .08199 L
.03107 .11926 L
.03108 .08599 L
.03109 .07148 L
.0311 .06942 L
.03111 .10727 L
.03112 .06525 L
.03113 .11961 L
.03114 .11927 L
.03115 .10669 L
.03116 .09123 L
.03117 .11701 L
.03118 .05936 L
.03119 .0786 L
.0312 .07837 L
.03121 .08042 L
.03123 .11999 L
.03124 .09623 L
.03124 .09998 L
.03126 .11841 L
.03127 .132 L
.03128 .08573 L
.03128 .07717 L
.03129 .11518 L
.03131 .09889 L
.03132 .06441 L
.03132 .09491 L
.03134 .08409 L
.03135 .10113 L
.03137 .09505 L
.03138 .06326 L
.03139 .1273 L
.03141 .07255 L
.03142 .13253 L
.03143 .08933 L
.03144 .11388 L
.03146 .06479 L
.03147 .11257 L
.03147 .11058 L
.03149 .05021 L
.0315 .08375 L
.03152 .08328 L
.03153 .07196 L
.03154 .11845 L
.03155 .10938 L
.03156 .06071 L
.03157 .10132 L
.03158 .07191 L
.0316 .13173 L
.0316 .1114 L
Mistroke
.03161 .12017 L
.03163 .08445 L
.03164 .06589 L
.03165 .11501 L
.03166 .06527 L
.03167 .11086 L
.03168 .05443 L
.03169 .11805 L
.03171 .10963 L
.03172 .11213 L
.03173 .13 L
.03174 .08631 L
.03175 .13833 L
.03176 .09557 L
.03177 .04462 L
.03177 .07203 L
.03178 .12542 L
.03179 .07179 L
.0318 .10545 L
.03182 .12949 L
.03183 .13957 L
.03185 .06243 L
.03186 .07531 L
.03187 .12295 L
.03188 .08466 L
.03189 .08034 L
.03191 .04826 L
.03192 .11496 L
.03193 .0958 L
.03194 .09266 L
.03195 .06298 L
.03197 .11463 L
.03198 .08055 L
.03199 .10195 L
.03201 .10069 L
.03202 .1108 L
.03204 .07598 L
.03205 .09811 L
.03206 .09192 L
.03207 .13961 L
.03208 .10824 L
.03209 .09523 L
.0321 .10187 L
.03212 .08688 L
.03213 .08802 L
.03214 .0748 L
.03216 .07933 L
.03217 .08872 L
.03218 .11296 L
.0322 .09045 L
Mistroke
.03221 .08643 L
.03223 .07931 L
.03224 .08299 L
.03225 .10781 L
.03227 .09565 L
.03228 .10466 L
.03229 .13411 L
.03231 .0828 L
.03232 .09684 L
.03234 .07278 L
.03235 .08012 L
.03237 .08742 L
.03238 .09631 L
.0324 .11453 L
.0324 .11361 L
.03241 .08918 L
.03242 .07012 L
.03243 .11027 L
.03244 .0882 L
.03246 .07712 L
.03247 .11278 L
.03247 .08421 L
.03249 .09578 L
.0325 .0992 L
.03252 .09788 L
.03253 .08966 L
.03255 .07758 L
.03256 .13367 L
.03257 .08839 L
.03259 .12954 L
.0326 .08615 L
.03262 .12213 L
.03263 .10249 L
.03264 .08718 L
.03265 .07092 L
.03266 .10949 L
.03268 .06128 L
.03269 .0907 L
.03271 .08304 L
.03272 .09618 L
.03273 .04509 L
.03274 .08929 L
.03275 .13042 L
.03276 .11894 L
.03276 .08706 L
.03277 .07342 L
.03278 .12595 L
.03279 .12376 L
.03281 .11265 L
.03281 .0564 L
Mistroke
.03282 .09704 L
.03283 .07401 L
.03284 .0895 L
.03285 .09749 L
.03287 .11529 L
.03288 .11653 L
.03289 .09432 L
.0329 .07421 L
.03292 .09364 L
.03293 .10856 L
.03294 .07023 L
.03295 .1287 L
.03296 .08285 L
.03298 .09122 L
.03299 .06999 L
.03301 .10395 L
.03302 .05644 L
.03303 .07583 L
.03305 .07621 L
.03306 .07374 L
.03308 .06622 L
.03309 .12155 L
.0331 .12919 L
.03312 .1138 L
.03313 .09743 L
.03315 .12001 L
.03316 .14361 L
.03317 .10843 L
.03318 .09029 L
.0332 .10606 L
.0332 .09373 L
.03321 .1032 L
.03322 .10846 L
.03323 .1048 L
.03324 .08972 L
.03325 .12498 L
.03326 .10795 L
.03327 .13604 L
.03328 .10758 L
.03329 .11129 L
.0333 .07892 L
.0333 .06656 L
.03331 .07765 L
.03333 .08033 L
.03334 .08915 L
.03336 .07637 L
.03337 .10398 L
.03339 .04854 L
.0334 .09139 L
.03341 .07897 L
Mistroke
.03343 .08193 L
.03344 .11745 L
.03345 .09714 L
.03347 .1066 L
.03348 .07734 L
.0335 .09988 L
.03351 .06793 L
.03353 .09177 L
.03354 .06186 L
.03355 .08559 L
.03356 .08814 L
.03358 .13676 L
.03359 .08572 L
.0336 .08042 L
.03362 .10611 L
.03363 .1018 L
.03364 .10656 L
.03366 .09899 L
.03367 .09156 L
.03368 .06301 L
.0337 .09855 L
.03371 .08692 L
.03372 .07367 L
.03374 .10589 L
.03375 .10272 L
.03376 .11352 L
.03377 .07834 L
.03378 .06885 L
.0338 .10969 L
.03381 .10307 L
.03382 .05464 L
.03383 .09852 L
.03384 .08703 L
.03386 .10104 L
.03387 .05392 L
.03388 .0919 L
.03389 .08052 L
.03391 .12374 L
.03392 .08817 L
.03393 .06613 L
.03394 .08478 L
.03396 .065 L
.03397 .10843 L
.03397 .11368 L
.03399 .13105 L
.034 .10695 L
.03402 .12726 L
.03403 .10906 L
.03404 .10043 L
.03406 .08921 L
Mistroke
.03407 .12538 L
.03408 .08744 L
.0341 .09693 L
.03411 .10288 L
.03413 .0999 L
.03414 .09036 L
.03415 .11272 L
.03417 .05832 L
.03418 .11276 L
.03419 .10176 L
.03421 .12472 L
.03422 .06359 L
.03424 .08991 L
.03425 .07546 L
.03427 .07725 L
.03428 .08012 L
.03429 .08679 L
.0343 .07485 L
.03431 .09251 L
.03431 .09754 L
.03433 .08379 L
.03434 .11226 L
.03435 .14342 L
.03436 .12437 L
.03437 .10099 L
.03439 .09439 L
.0344 .10547 L
.03442 .0822 L
.03443 .09687 L
.03445 .11079 L
.03446 .10951 L
.03447 .1229 L
.03449 .11571 L
.0345 .10517 L
.03452 .13435 L
.03453 .10621 L
.03454 .11958 L
.03456 .1035 L
.03458 .08942 L
.03459 .10663 L
.03461 .06461 L
.03461 .05074 L
.03462 .10211 L
.03464 .0813 L
.03465 .07556 L
.03466 .09402 L
.03467 .08691 L
.03467 .13847 L
.03468 .10918 L
.03469 .09291 L
Mistroke
.0347 .09573 L
.03471 .1059 L
.03471 .06035 L
.03472 .13377 L
.03474 .08926 L
.03475 .07961 L
.03477 .07451 L
.03478 .09693 L
.0348 .07696 L
.03481 .06871 L
.03482 .10869 L
.03484 .12499 L
.03485 .06809 L
.03487 .08772 L
.03488 .12249 L
.03489 .13598 L
.03491 .14873 L
.03492 .06072 L
.03493 .08058 L
.03494 .14672 L
.03496 .09553 L
.03497 .06168 L
.03498 .10987 L
.035 .07076 L
.03501 .09354 L
.03503 .08658 L
.03504 .09305 L
.03505 .08447 L
.03506 .11131 L
.03508 .07629 L
.03509 .10747 L
.03511 .07416 L
.03512 .08958 L
.03513 .08524 L
.03515 .139 L
.03516 .12002 L
.03516 .07094 L
.03518 .05707 L
.03519 .09542 L
.03521 .10839 L
.03522 .11797 L
.03524 .12101 L
.03525 .10425 L
.03528 .08192 L
.03529 .06654 L
.03531 .14435 L
.03532 .09454 L
.03534 .08832 L
.03535 .08081 L
.03536 .09397 L
Mistroke
.03537 .1002 L
.03538 .10802 L
.0354 .08834 L
.03541 .13553 L
.03543 .09831 L
.03544 .09263 L
.03546 .06894 L
.03547 .12058 L
.03548 .09202 L
.0355 .14684 L
.03551 .08686 L
.03553 .08998 L
.03554 .06549 L
.03555 .06963 L
.03557 .08304 L
.03558 .05386 L
.03559 .08148 L
.03561 .08693 L
.03562 .12188 L
.03563 .06023 L
.03565 .10815 L
.03566 .06499 L
.03568 .10052 L
.03569 .12223 L
.03571 .07642 L
.03572 .09107 L
.03573 .13564 L
.03575 .0859 L
.03576 .08819 L
.03578 .13326 L
.03578 .08362 L
.03579 .10565 L
.03581 .07595 L
.03582 .10358 L
.03583 .12015 L
.03584 .16241 L
.03585 .10246 L
.03586 .11358 L
.03587 .09473 L
.03588 .08168 L
.03589 .07526 L
.0359 .11196 L
.03592 .08194 L
.03592 .06577 L
.03593 .0905 L
.03594 .12791 L
.03595 .07969 L
.03596 .09762 L
.03597 .12701 L
.03598 .07522 L
Mistroke
.03599 .11686 L
.036 .10274 L
.03601 .12448 L
.03602 .0894 L
.03603 .0815 L
.03604 .06063 L
.03605 .08949 L
.03606 .0542 L
.03607 .16472 L
.03608 .09979 L
.0361 .06838 L
.03611 .10118 L
.03613 .14662 L
.03614 .07985 L
.03615 .08326 L
.03617 .10602 L
.03618 .08123 L
.03619 .10043 L
.03621 .12638 L
.03622 .07996 L
.03623 .10599 L
.03624 .06159 L
.03625 .07401 L
.03627 .06612 L
.03628 .08052 L
.03629 .10749 L
.03631 .09548 L
.03632 .11801 L
.03634 .0762 L
.03635 .11344 L
.03636 .10113 L
.03638 .06033 L
.03639 .10585 L
.0364 .16109 L
.03641 .12174 L
.03642 .0553 L
.03643 .0699 L
.03644 .11258 L
.03645 .12129 L
.03646 .06985 L
.03647 .11747 L
.03647 .0966 L
.03649 .11132 L
.03651 .06596 L
.03651 .06195 L
.03652 .09231 L
.03654 .14011 L
.03655 .07434 L
.03657 .08218 L
.03658 .0806 L
Mistroke
.0366 .02886 L
.03661 .09764 L
.03662 .04663 L
.03663 .07692 L
.03664 .07095 L
.03666 .08919 L
.03667 .11521 L
.03667 .06414 L
.03669 .09353 L
.0367 .08094 L
.03672 .1232 L
.03673 .10465 L
.03674 .08385 L
.03675 .08991 L
.03676 .08586 L
.03677 .08441 L
.03678 .11048 L
.0368 .08503 L
.0368 .07837 L
.03681 .10499 L
.03683 .05848 L
.03684 .11506 L
.03685 .0895 L
.03686 .11339 L
.03686 .08313 L
.03687 .0526 L
.03688 .06061 L
.0369 .07611 L
.03691 .09723 L
.03692 .11999 L
.03694 .09132 L
.03695 .0975 L
.03696 .06772 L
.03696 .10503 L
.03697 .10649 L
.03698 .12159 L
.03699 .08919 L
.037 .08962 L
.03702 .07124 L
.03703 .07776 L
.03705 .09575 L
.03706 .10964 L
.03707 .12132 L
.03708 .14418 L
.03709 .11344 L
.03711 .07257 L
.03712 .08268 L
.03713 .09158 L
.03714 .07467 L
.03715 .07979 L
Mistroke
.03717 .10549 L
.03718 .05797 L
.03719 .13142 L
.03721 .10122 L
.03722 .09608 L
.03723 .07358 L
.03724 .09179 L
.03725 .09122 L
.03727 .08757 L
.03728 .08743 L
.03728 .05937 L
.0373 .11563 L
.03731 .08167 L
.03733 .09244 L
.03734 .06768 L
.03735 .09195 L
.03737 .11507 L
.03738 .10377 L
.03739 .07523 L
.03741 .05269 L
.03742 .06817 L
.03744 .09883 L
.03745 .1221 L
.03746 .09288 L
.03748 .11088 L
.03749 .10511 L
.0375 .09728 L
.03752 .05514 L
.03753 .03757 L
.03755 .09372 L
.03756 .09054 L
.03758 .1036 L
.03759 .07577 L
.0376 .10474 L
.03761 .09479 L
.03762 .08835 L
.03763 .0589 L
.03764 .08674 L
.03765 .08547 L
.03766 .08797 L
.03767 .09164 L
.03769 .095 L
.0377 .11436 L
.03771 .11864 L
.03773 .11753 L
.03774 .09027 L
.03776 .09042 L
.03777 .08553 L
.03778 .08954 L
.0378 .10992 L
Mistroke
.03781 .06306 L
.03783 .07076 L
.03784 .12252 L
.03784 .11999 L
.03786 .09752 L
.03787 .10003 L
.03789 .07919 L
.0379 .09239 L
.03792 .09756 L
.03793 .11392 L
.03793 .10623 L
.03794 .11809 L
.03795 .11195 L
.03796 .08745 L
.03797 .13527 L
.03798 .10849 L
.03799 .10581 L
.038 .08789 L
.03801 .05523 L
.03802 .12603 L
.03803 .11941 L
.03804 .06362 L
.03805 .10522 L
.03806 .08386 L
.03808 .10616 L
.03809 .09896 L
.0381 .09832 L
.03811 .07697 L
.03813 .12496 L
.03813 .1068 L
.03814 .07167 L
.03816 .13656 L
.03817 .07045 L
.03818 .08834 L
.0382 .10447 L
.03821 .14182 L
.03822 .12271 L
.03824 .10026 L
.03825 .10006 L
.03827 .06218 L
.03828 .11493 L
.0383 .11203 L
.03831 .12268 L
.03833 .06907 L
.03834 .12232 L
.03836 .07991 L
.03836 .07422 L
.03837 .11123 L
.03839 .12675 L
.0384 .1109 L
Mistroke
.0384 .07555 L
.03841 .1084 L
.03842 .05646 L
.03844 .10932 L
.03844 .08495 L
.03845 .09313 L
.03846 .07556 L
.03847 .09907 L
.03848 .08717 L
.03849 .05668 L
.0385 .07973 L
.0385 .07829 L
.03852 .10601 L
.03853 .09361 L
.03855 .08209 L
.03856 .07049 L
.03858 .10523 L
.03859 .09796 L
.03861 .09154 L
.03862 .11885 L
.03863 .07818 L
.03865 .08501 L
.03867 .07379 L
.03869 .06939 L
.0387 .10862 L
.03871 .1016 L
.03872 .06002 L
.03874 .07147 L
.03875 .11512 L
.03877 .10134 L
.03878 .09422 L
.0388 .10043 L
.03881 .09693 L
.03883 .11766 L
.03884 .08828 L
.03886 .07185 L
.03887 .10026 L
.03888 .08269 L
.03889 .11059 L
.03891 .09381 L
.03892 .10744 L
.03893 .10355 L
.03895 .05884 L
.03896 .11818 L
.03897 .04968 L
.03899 .07514 L
.039 .08198 L
.03901 .05216 L
.03903 .10744 L
.03904 .0653 L
Mistroke
.03906 .11966 L
.03907 .09182 L
.03908 .09216 L
.0391 .08884 L
.03911 .08855 L
.03912 .10733 L
.03912 .12211 L
.03913 .11948 L
.03915 .1108 L
.03916 .12656 L
.03916 .08464 L
.03918 .10079 L
.03919 .07907 L
.03921 .09303 L
.03922 .09917 L
.03924 .08691 L
.03925 .08561 L
.03925 .09378 L
.03927 .07435 L
.03928 .09257 L
.03929 .10076 L
.0393 .09173 L
.03932 .11637 L
.03933 .10155 L
.03934 .1073 L
.03936 .10332 L
.03938 .09539 L
.03939 .12443 L
.0394 .10323 L
.03941 .10258 L
.03942 .05307 L
.03943 .08653 L
.03943 .12374 L
.03944 .10516 L
.03945 .09259 L
.03946 .06228 L
.03948 .14476 L
.03948 .10786 L
.03949 .08734 L
.0395 .08086 L
.03951 .10239 L
.03953 .05934 L
.03953 .11872 L
.03954 .15481 L
.03956 .09279 L
.03957 .11417 L
.03958 .10205 L
.03959 .099 L
.0396 .0629 L
.03962 .11347 L
Mistroke
.03963 .10362 L
.03964 .09256 L
.03965 .12276 L
.03966 .06891 L
.03968 .11442 L
.03969 .09114 L
.03971 .07292 L
.03972 .10792 L
.03974 .10833 L
.03975 .07544 L
.03976 .04765 L
.03978 .08694 L
.03979 .11331 L
.0398 .1006 L
.03981 .10125 L
.03982 .09576 L
.03984 .09357 L
.03985 .096 L
.03986 .11397 L
.03988 .08744 L
.03989 .07054 L
.0399 .06764 L
.03992 .06765 L
.03993 .08963 L
.03994 .10509 L
.03996 .09601 L
.03997 .06961 L
.03999 .07818 L
.04 .12155 L
.04001 .12838 L
.04002 .08521 L
.04004 .11956 L
.04005 .10482 L
.04007 .10688 L
.04008 .06581 L
.04009 .11145 L
.04011 .10097 L
.04012 .08412 L
.04013 .08168 L
.04015 .15331 L
.04016 .12132 L
.04018 .09704 L
.04018 .08222 L
.04019 .07574 L
.0402 .09722 L
.04021 .10126 L
.04022 .11664 L
.04024 .07798 L
.04025 .0798 L
.04026 .10833 L
Mistroke
.04027 .0665 L
.04028 .10884 L
.04029 .0971 L
.0403 .07344 L
.04031 .082 L
.04032 .07445 L
.04034 .11177 L
.04035 .11638 L
.04036 .12199 L
.04037 .1121 L
.04038 .10863 L
.0404 .1004 L
.04041 .11882 L
.04043 .08984 L
.04044 .07944 L
.04045 .0881 L
.04046 .08602 L
.04047 .10348 L
.04049 .07433 L
.0405 .06524 L
.04051 .08309 L
.04053 .07201 L
.04054 .07206 L
.04056 .09219 L
.04057 .09016 L
.04059 .11153 L
.0406 .09555 L
.0406 .0949 L
.04062 .06584 L
.04063 .12502 L
.04063 .1164 L
.04065 .09237 L
.04066 .12071 L
.04068 .0991 L
.04069 .09214 L
.0407 .09244 L
.04072 .10645 L
.04073 .13908 L
.04074 .10135 L
.04075 .13022 L
.04077 .09083 L
.04078 .08727 L
.0408 .08742 L
.04081 .09754 L
.04082 .07275 L
.04084 .09467 L
.04085 .10277 L
.04086 .10975 L
.04087 .13228 L
.04088 .08558 L
Mistroke
.0409 .06272 L
.04091 .09848 L
.04091 .11695 L
.04092 .06724 L
.04093 .07713 L
.04094 .10965 L
.04095 .09661 L
.04096 .07157 L
.04098 .09535 L
.04099 .08042 L
.04101 .11533 L
.04102 .08994 L
.04102 .06547 L
.04103 .09283 L
.04104 .06078 L
.04105 .09394 L
.04106 .08767 L
.04107 .09506 L
.04108 .07495 L
.04108 .08247 L
.04109 .10662 L
.04111 .06073 L
.04112 .10888 L
.04112 .05112 L
.04114 .09343 L
.04116 .11209 L
.04117 .12128 L
.04118 .07677 L
.0412 .07863 L
.04121 .0814 L
.04123 .13744 L
.04124 .09699 L
.04126 .09213 L
.04126 .13738 L
.04127 .0772 L
.04128 .11951 L
.04129 .11516 L
.0413 .06923 L
.04131 .1208 L
.04132 .09657 L
.04134 .12596 L
.04135 .09143 L
.04136 .08364 L
.04137 .14651 L
.04138 .09138 L
.0414 .10626 L
.04141 .08632 L
.04142 .07881 L
.04144 .14829 L
.04145 .08365 L
Mistroke
.04147 .08254 L
.04148 .10102 L
.04149 .11969 L
.0415 .09084 L
.04151 .10602 L
.04152 .07257 L
.04153 .09595 L
.04154 .12398 L
.04155 .12605 L
.04156 .09473 L
.04158 .06464 L
.04159 .0664 L
.0416 .0729 L
.04162 .07387 L
.04163 .09332 L
.04164 .09703 L
.04165 .08275 L
.04167 .08083 L
.04167 .14303 L
.04168 .09863 L
.0417 .10958 L
.04171 .11382 L
.04173 .0881 L
.04174 .09854 L
.04175 .09231 L
.04176 .06719 L
.04177 .1451 L
.04177 .09371 L
.04179 .06741 L
.0418 .09294 L
.04181 .12801 L
.04182 .09431 L
.04184 .12591 L
.04185 .12309 L
.04185 .09267 L
.04186 .09534 L
.04187 .08198 L
.04188 .07836 L
.04189 .09872 L
.0419 .12287 L
.04192 .07753 L
.04193 .06003 L
.04194 .09016 L
.04195 .10533 L
.04196 .12232 L
.04197 .08769 L
.04198 .10619 L
.042 .0812 L
.04201 .12462 L
.04202 .093 L
Mistroke
.04204 .09857 L
.04205 .09677 L
.04207 .12228 L
.04208 .09223 L
.04209 .09966 L
.04211 .06206 L
.04212 .11556 L
.04214 .1095 L
.04215 .04788 L
.04215 .07275 L
.04217 .06784 L
.04218 .11689 L
.0422 .10144 L
.04221 .13123 L
.04223 .07783 L
.04224 .09606 L
.04225 .09922 L
.04226 .11297 L
.04228 .0784 L
.04229 .09594 L
.0423 .09335 L
.04231 .10039 L
.04232 .09662 L
.04233 .08444 L
.04233 .05536 L
.04234 .11718 L
.04235 .05321 L
.04236 .12589 L
.04237 .09722 L
.04238 .10854 L
.04239 .05155 L
.0424 .09142 L
.04242 .07404 L
.04243 .12216 L
.04244 .07717 L
.04246 .10965 L
.04247 .1083 L
.04249 .09459 L
.0425 .07731 L
.0425 .09426 L
.04252 .09889 L
.04253 .12534 L
.04254 .05328 L
.04255 .08678 L
.04257 .08102 L
.04258 .0685 L
.0426 .0668 L
.04261 .09922 L
.04262 .07595 L
.04264 .09535 L
Mistroke
.04265 .07856 L
.04267 .10677 L
.04268 .10819 L
.0427 .08123 L
.04271 .0968 L
.04272 .09886 L
.04274 .09055 L
.04275 .12014 L
.04276 .09441 L
.04277 .08522 L
.04279 .06748 L
.0428 .11742 L
.04282 .08973 L
.04283 .08498 L
.04285 .09809 L
.04285 .0946 L
.04286 .09711 L
.04287 .07695 L
.04288 .10905 L
.04289 .08519 L
.04291 .10253 L
.04292 .08894 L
.04294 .09818 L
.04295 .10312 L
.04296 .08481 L
.04298 .07292 L
.04299 .12707 L
.04301 .08796 L
.04302 .09314 L
.04304 .1037 L
.04305 .06664 L
.04306 .12144 L
.04308 .0832 L
.04309 .08674 L
.04311 .11959 L
.04312 .11145 L
.04313 .08699 L
.04314 .09546 L
.04316 .06659 L
.04316 .0844 L
.04317 .11294 L
.04318 .10855 L
.04319 .11739 L
.0432 .09629 L
.04321 .09755 L
.04322 .06399 L
.04323 .0869 L
.04324 .09028 L
.04325 .09421 L
.04326 .11426 L
Mistroke
.04326 .09427 L
.04327 .08406 L
.04329 .08231 L
.0433 .05902 L
.04332 .12341 L
.04333 .0757 L
.04335 .1126 L
.04336 .09947 L
.04337 .07789 L
.04339 .11052 L
.0434 .07585 L
.04341 .09917 L
.04343 .08622 L
.04345 .11788 L
.04346 .06975 L
.04347 .12686 L
.04349 .10301 L
.0435 .09023 L
.04351 .12588 L
.04352 .08484 L
.04354 .08041 L
.04355 .11334 L
.04356 .10837 L
.04358 .07422 L
.04359 .12142 L
.0436 .08566 L
.04362 .07519 L
.04363 .12115 L
.04364 .07031 L
.04366 .05942 L
.04367 .07138 L
.04368 .1095 L
.0437 .09395 L
.0437 .08166 L
.04371 .10067 L
.04373 .09654 L
.04374 .09812 L
.04376 .07795 L
.04377 .07014 L
.04379 .09497 L
.0438 .07115 L
.04382 .11466 L
.04383 .07517 L
.04384 .07383 L
.04386 .10384 L
.04387 .12248 L
.04388 .12007 L
.0439 .10573 L
.04391 .1243 L
.04393 .10094 L
Mistroke
.04394 .09693 L
.04395 .1122 L
.04396 .11228 L
.04398 .10922 L
.04399 .1059 L
.044 .09604 L
.04402 .11314 L
.04403 .0847 L
.04405 .05196 L
.04406 .10249 L
.04407 .11436 L
.04408 .10386 L
.0441 .10003 L
.04411 .11531 L
.04413 .08784 L
.04414 .11998 L
.04415 .10432 L
.04417 .07412 L
.04417 .0778 L
.04418 .13119 L
.0442 .11509 L
.04421 .1124 L
.04422 .11594 L
.04424 .13738 L
.04426 .07882 L
.04427 .06943 L
.04428 .08023 L
.0443 .05789 L
.04431 .08505 L
.04433 .09361 L
.04433 .10657 L
.04434 .09686 L
.04435 .09003 L
.04436 .08364 L
.04437 .12507 L
.04439 .07836 L
.0444 .08776 L
.04442 .11709 L
.04443 .09356 L
.04445 .08945 L
.04446 .1038 L
.04447 .07192 L
.04449 .08356 L
.0445 .1288 L
.04452 .10175 L
.04453 .05088 L
.04455 .09589 L
.04456 .07865 L
.04458 .09389 L
.04459 .09359 L
Mistroke
.0446 .10782 L
.04462 .08687 L
.04463 .08656 L
.04464 .09005 L
.04467 .09799 L
.04468 .1144 L
.0447 .05437 L
.04471 .09845 L
.04472 .0839 L
.04474 .08828 L
.04475 .10942 L
.04476 .1108 L
.04477 .11907 L
.04478 .12307 L
.0448 .08932 L
.04481 .10374 L
.04482 .06401 L
.04484 .10771 L
.04485 .07823 L
.04487 .08829 L
.04488 .06427 L
.04489 .10704 L
.0449 .0606 L
.04491 .0862 L
.04493 .11906 L
.04493 .14621 L
.04494 .07997 L
.04495 .07918 L
.04496 .13337 L
.04498 .09402 L
.04498 .06974 L
.04499 .13087 L
.04501 .1244 L
.04502 .10991 L
.04504 .10113 L
.04505 .09844 L
.04507 .08603 L
.04508 .12152 L
.04509 .08103 L
.04511 .10761 L
.04512 .13864 L
.04513 .10555 L
.04514 .11537 L
.04516 .09724 L
.04517 .08879 L
.04517 .08902 L
.04519 .05219 L
.0452 .0908 L
.04521 .11491 L
.04522 .09426 L
Mistroke
.04524 .11538 L
.04525 .07107 L
.04526 .11085 L
.04527 .08558 L
.04528 .10397 L
.04529 .1147 L
.0453 .08821 L
.04531 .13266 L
.04533 .06956 L
.04534 .08861 L
.04535 .07455 L
.04536 .07484 L
.04537 .13113 L
.04538 .13715 L
.04539 .05902 L
.0454 .10405 L
.04541 .1093 L
.04543 .13435 L
.04544 .0653 L
.04545 .09391 L
.04546 .11365 L
.04547 .09942 L
.04548 .10161 L
.04549 .04694 L
.0455 .12842 L
.04551 .0858 L
.04552 .08079 L
.04552 .09647 L
.04554 .0926 L
.04555 .10205 L
.04557 .08928 L
.04558 .08438 L
.04559 .13706 L
.0456 .09722 L
.04561 .10402 L
.04563 .11649 L
.04564 .09623 L
.04565 .08115 L
.04566 .08869 L
.04567 .08262 L
.04569 .08356 L
.0457 .09439 L
.04571 .12488 L
.04573 .069 L
.04574 .09423 L
.04576 .07728 L
.04577 .09873 L
.04578 .11921 L
.04579 .07928 L
.0458 .11793 L
Mistroke
.04581 .10846 L
.04582 .06998 L
.04583 .0998 L
.04585 .09513 L
.04586 .10691 L
.04588 .12629 L
.04589 .1165 L
.04591 .11315 L
.04592 .06552 L
.04593 .07945 L
.04595 .09731 L
.04596 .07238 L
.04598 .08079 L
.04599 .09801 L
.046 .07743 L
.04602 .09138 L
.04603 .14794 L
.04604 .11585 L
.04606 .11274 L
.04607 .08612 L
.04608 .111 L
.0461 .13842 L
.04611 .12247 L
.04613 .12952 L
.04614 .11287 L
.04616 .08504 L
.04617 .09144 L
.04618 .09924 L
.0462 .09194 L
.04621 .08446 L
.04622 .07695 L
.04623 .0991 L
.04624 .13668 L
.04625 .10823 L
.04626 .13912 L
.04627 .12052 L
.04628 .07895 L
.04629 .1057 L
.04631 .05812 L
.04632 .08656 L
.04634 .06224 L
.04634 .08751 L
.04635 .09077 L
.04637 .09459 L
.04638 .11148 L
.04639 .06792 L
.0464 .11528 L
.04641 .09515 L
.04643 .04469 L
.04644 .12281 L
Mistroke
.04646 .11888 L
.04647 .10888 L
.04647 .07568 L
.04648 .11582 L
.04649 .12061 L
.04652 .13951 L
.04654 .14647 L
.04655 .07759 L
.04655 .10715 L
.04656 .10178 L
.04657 .09507 L
.04658 .07157 L
.04659 .09597 L
.0466 .09788 L
.04661 .11066 L
.04662 .10438 L
.04663 .05814 L
.04665 .09664 L
.04666 .07302 L
.04667 .13343 L
.04669 .10516 L
.0467 .11191 L
.04672 .08483 L
.04673 .07482 L
.04674 .08014 L
.04675 .11545 L
.04676 .06816 L
.04677 .08154 L
.04678 .1098 L
.0468 .09937 L
.04681 .07498 L
.04683 .0756 L
.04684 .09127 L
.04685 .09841 L
.04687 .07743 L
.04688 .123 L
.0469 .07835 L
.04691 .12524 L
.04693 .11446 L
.04694 .11078 L
.04695 .08017 L
.04697 .09888 L
.04698 .12472 L
.047 .07141 L
.04701 .07182 L
.04702 .09253 L
.04703 .09219 L
.04705 .08443 L
.04706 .11734 L
.04707 .08639 L
Mistroke
.04709 .09527 L
.0471 .10728 L
.04712 .12272 L
.04713 .10247 L
.04715 .07343 L
.04716 .08202 L
.04716 .09417 L
.04718 .11729 L
.04719 .09772 L
.0472 .11951 L
.04722 .07878 L
.04723 .10141 L
.04724 .061 L
.04726 .07276 L
.04727 .06543 L
.04729 .07175 L
.0473 .08965 L
.04731 .10527 L
.04732 .11633 L
.04733 .12445 L
.04735 .11498 L
.04736 .10092 L
.04737 .08367 L
.04737 .12108 L
.04738 .0959 L
.04739 .07632 L
.0474 .09768 L
.04742 .10598 L
.04743 .11763 L
.04744 .14425 L
.04746 .10049 L
.04747 .06714 L
.04748 .07861 L
.04749 .10879 L
.04751 .09007 L
.04752 .10948 L
.04753 .11904 L
.04755 .11667 L
.04756 .0882 L
.04758 .09822 L
.04759 .07706 L
.0476 .07175 L
.04761 .09066 L
.04762 .09725 L
.04764 .14983 L
.04765 .07574 L
.04767 .07978 L
.04768 .07833 L
.04768 .06035 L
.0477 .0987 L
Mistroke
.04772 .05791 L
.04773 .12027 L
.04774 .12134 L
.04775 .08584 L
.04776 .07532 L
.04777 .12211 L
.04779 .05969 L
.0478 .11475 L
.04782 .07194 L
.04783 .05891 L
.04784 .06887 L
.04785 .11468 L
.04786 .07468 L
.04788 .09712 L
.04789 .06472 L
.0479 .0834 L
.04791 .07493 L
.04793 .11123 L
.04794 .08865 L
.04795 .11617 L
.04797 .10596 L
.04798 .11111 L
.048 .14082 L
.04801 .09583 L
.04803 .10451 L
.04804 .0988 L
.04806 .11433 L
.04806 .08808 L
.04807 .09206 L
.04809 .12225 L
.0481 .08621 L
.04811 .11761 L
.04813 .11288 L
.04814 .06622 L
.04815 .10022 L
.04817 .09348 L
.04818 .11558 L
.0482 .1321 L
.04821 .08711 L
.04823 .08628 L
.04823 .13147 L
.04824 .10284 L
.04826 .11138 L
.04827 .09014 L
.04828 .13207 L
.04829 .11568 L
.0483 .11024 L
.04831 .13382 L
.04832 .07669 L
.04833 .13577 L
Mistroke
.04834 .09824 L
.04835 .08535 L
.04837 .09976 L
.04838 .07344 L
.0484 .11494 L
.04841 .09342 L
.04842 .11728 L
.04843 .07955 L
.04844 .08311 L
.04845 .07855 L
.04846 .10989 L
.04847 .07786 L
.04849 .07381 L
.0485 .08143 L
.04852 .13473 L
.04852 .1253 L
.04853 .06322 L
.04855 .1009 L
.04856 .05561 L
.04858 .10729 L
.04859 .08905 L
.04861 .10639 L
.04862 .10703 L
.04863 .06656 L
.04865 .0779 L
.04866 .09346 L
.04867 .07377 L
.04869 .09828 L
.0487 .07058 L
.04871 .11407 L
.04871 .06436 L
.04872 .12927 L
.04874 .10857 L
.04875 .07418 L
.04876 .07613 L
.04877 .12745 L
.04878 .122 L
.04879 .10098 L
.0488 .07711 L
.04881 .07684 L
.04882 .0535 L
.04883 .0838 L
.04885 .1113 L
.04886 .14229 L
.04887 .09194 L
.04888 .0931 L
.0489 .10884 L
.04891 .1009 L
.04892 .1246 L
.04894 .06499 L
Mistroke
.04895 .11107 L
.04897 .11083 L
.04898 .11324 L
.04898 .1072 L
.04899 .07057 L
.049 .08996 L
.04902 .09037 L
.04902 .09733 L
.04903 .11775 L
.04905 .12691 L
.04906 .09067 L
.04908 .13628 L
.04909 .13838 L
.0491 .12868 L
.04912 .12977 L
.04913 .09196 L
.04914 .0699 L
.04916 .05313 L
.04917 .09996 L
.04919 .10798 L
.0492 .07962 L
.04921 .07629 L
.04922 .12717 L
.04923 .1244 L
.04925 .10994 L
.04926 .11488 L
.04928 .11028 L
.04929 .09986 L
.0493 .10981 L
.04931 .10499 L
.04933 .09766 L
.04933 .11216 L
.04934 .07014 L
.04935 .09707 L
.04936 .11585 L
.04937 .07817 L
.04938 .06946 L
.04939 .08696 L
.04939 .06654 L
.04941 .13199 L
.04942 .08666 L
.04944 .07538 L
.04945 .05619 L
.04947 .14761 L
.04948 .1286 L
.0495 .08568 L
.04951 .06772 L
.04952 .11217 L
.04954 .09462 L
.04955 .09268 L
Mistroke
.04957 .07781 L
.04958 .11647 L
.0496 .08751 L
.04961 .08305 L
.04962 .09561 L
.04963 .09885 L
.04964 .08856 L
.04966 .08117 L
.04967 .0789 L
.04968 .10474 L
.0497 .05068 L
.04971 .14627 L
.04973 .10508 L
.04974 .0987 L
.04975 .08552 L
.04976 .09843 L
.04978 .04829 L
.04979 .12376 L
.04981 .1027 L
.04982 .12882 L
.04983 .06645 L
.04984 .03197 L
.04985 .1186 L
.04986 .0602 L
.04988 .05226 L
.04989 .10407 L
.04991 .12916 L
.04992 .10477 L
.04994 .05386 L
.04995 .07594 L
.04996 .06706 L
.04998 .12033 L
.04999 .07273 L
.05001 .103 L
.05002 .10668 L
.05003 .10953 L
.05005 .08752 L
.05007 .07816 L
.05007 .10336 L
.05008 .12577 L
.0501 .12476 L
.05011 .10455 L
.05013 .11421 L
.05014 .12014 L
.05015 .09424 L
.05017 .07157 L
.05018 .10195 L
.05019 .08754 L
.0502 .08815 L
.05022 .09017 L
Mistroke
.05023 .1072 L
.05025 .07887 L
.05025 .09767 L
.05026 .091 L
.05028 .1069 L
.05029 .10496 L
.05031 .07858 L
.05032 .10892 L
.05033 .10591 L
.05036 .09698 L
.05038 .10903 L
.05039 .08941 L
.0504 .0837 L
.05042 .09267 L
.05043 .09954 L
.05045 .04803 L
.05046 .10301 L
.05048 .09788 L
.05048 .10346 L
.05049 .10149 L
.0505 .0956 L
.05051 .12044 L
.05053 .10411 L
.05054 .08352 L
.05055 .11204 L
.05057 .12209 L
.05058 .08309 L
.0506 .0812 L
.05061 .0721 L
.05062 .10457 L
.05064 .07592 L
.05065 .08649 L
.05066 .09654 L
.05068 .12118 L
.05069 .06856 L
.0507 .08881 L
.05072 .09436 L
.05073 .06872 L
.05074 .0853 L
.05075 .08403 L
.05076 .11037 L
.05078 .09568 L
.05079 .10298 L
.0508 .12795 L
.05081 .06823 L
.05082 .11027 L
.05083 .08876 L
.05085 .06756 L
.05086 .11328 L
.05088 .08209 L
Mistroke
.05089 .07762 L
.0509 .08137 L
.05091 .08605 L
.05092 .11882 L
.05093 .08848 L
.05095 .11245 L
.05096 .0946 L
.05097 .07335 L
.05098 .09823 L
.051 .09978 L
.05101 .0798 L
.05103 .08725 L
.05104 .05297 L
.05105 .08479 L
.05106 .08656 L
.05108 .11003 L
.05109 .09427 L
.05111 .06619 L
.05112 .1093 L
.05113 .06449 L
.05115 .07219 L
.05116 .11876 L
.05117 .09786 L
.05119 .0757 L
.0512 .13058 L
.05122 .03194 L
.05123 .07134 L
.05125 .08897 L
.05126 .09621 L
.05128 .07762 L
.05128 .11396 L
.05129 .07721 L
.0513 .10688 L
.05131 .10469 L
.05132 .07953 L
.05134 .10008 L
.05135 .11856 L
.05137 .06043 L
.05138 .05619 L
.0514 .11159 L
.05141 .12447 L
.05142 .09413 L
.05144 .09828 L
.05145 .10129 L
.05147 .06852 L
.05148 .03633 L
.05149 .10905 L
.05151 .09451 L
.05152 .05225 L
.05154 .08611 L
Mistroke
.05155 .0993 L
.05156 .10186 L
.05157 .07481 L
.05159 .07165 L
.05159 .10586 L
.0516 .10415 L
.05162 .06931 L
.05163 .06014 L
.05163 .08238 L
.05165 .11322 L
.05167 .10573 L
.05167 .12799 L
.05168 .1066 L
.0517 .08893 L
.0517 .13319 L
.05171 .10504 L
.05172 .09837 L
.05173 .07978 L
.05175 .11742 L
.05176 .11723 L
.05178 .07116 L
.05179 .10128 L
.05181 .06509 L
.05181 .10726 L
.05182 .05739 L
.05184 .10418 L
.05185 .09099 L
.05187 .09781 L
.05188 .0812 L
.05189 .07174 L
.05191 .10063 L
.05192 .1061 L
.05194 .09236 L
.05195 .12716 L
.05196 .12863 L
.05198 .08471 L
.05199 .11605 L
.052 .07804 L
.05201 .09012 L
.05202 .0534 L
.05203 .11447 L
.05204 .0763 L
.05206 .08248 L
.05207 .11772 L
.05207 .06021 L
.05208 .10003 L
.05209 .08131 L
.05211 .12782 L
.05212 .07858 L
.05212 .11042 L
Mistroke
.05214 .08372 L
.05215 .08968 L
.05216 .08012 L
.05217 .03501 L
.05219 .0761 L
.0522 .09897 L
.05221 .08811 L
.05223 .12511 L
.05224 .09172 L
.05226 .08751 L
.05227 .05362 L
.05229 .08674 L
.05229 .09565 L
.0523 .09581 L
.05232 .07094 L
.05233 .11822 L
.05235 .15845 L
.05236 .07661 L
.05237 .10183 L
.05239 .10363 L
.0524 .1045 L
.05241 .11036 L
.05243 .12541 L
.05244 .08075 L
.05246 .09484 L
.05247 .11614 L
.05247 .06291 L
.05249 .10661 L
.0525 .08187 L
.05251 .06893 L
.05252 .07486 L
.05254 .0735 L
.05254 .08573 L
.05255 .11136 L
.05256 .1135 L
.05257 .08411 L
.05258 .10983 L
.0526 .08444 L
.05261 .06346 L
.05263 .09057 L
.05264 .09264 L
.05265 .07737 L
.05266 .11255 L
.05268 .1229 L
.05269 .09811 L
.0527 .10554 L
.05272 .09875 L
.05274 .09587 L
.05275 .0982 L
.05276 .13206 L
Mistroke
.05278 .10277 L
.05279 .14168 L
.0528 .10181 L
.05282 .11673 L
.05283 .06818 L
.05285 .08419 L
.05286 .09324 L
.05289 .115 L
.05291 .09491 L
.05292 .13155 L
.05294 .08074 L
.05295 .09111 L
.05297 .11744 L
.05298 .12159 L
.05299 .09277 L
.05301 .07907 L
.05302 .13355 L
.05304 .08921 L
.05305 .08133 L
.05306 .13062 L
.05308 .07454 L
.05309 .09814 L
.05311 .10662 L
.05312 .08667 L
.05313 .07743 L
.05314 .06729 L
.05316 .07049 L
.05317 .12406 L
.05319 .09032 L
.0532 .06067 L
.05321 .12309 L
.05323 .09432 L
.05324 .11775 L
.05324 .08295 L
.05326 .1074 L
.05327 .10629 L
.05328 .0983 L
.05328 .08266 L
.05329 .11521 L
.05331 .08319 L
.05332 .12256 L
.05332 .10986 L
.05334 .11983 L
.05335 .12304 L
.05337 .10338 L
.05338 .11102 L
.0534 .07595 L
.05341 .11808 L
.05342 .07606 L
.05344 .09109 L
Mistroke
.05345 .11912 L
.05346 .11944 L
.05348 .08096 L
.05349 .09637 L
.0535 .11107 L
.05352 .09085 L
.05353 .09629 L
.05354 .10987 L
.05356 .0914 L
.05357 .10085 L
.05358 .07973 L
.05359 .09877 L
.0536 .11121 L
.05362 .14073 L
.05363 .08534 L
.05365 .05303 L
.05366 .11602 L
.05368 .10942 L
.05369 .11296 L
.0537 .07648 L
.05372 .12122 L
.05373 .07567 L
.05375 .11414 L
.05376 .11444 L
.05377 .09826 L
.05378 .11453 L
.05379 .07916 L
.05381 .1287 L
.05382 .08672 L
.05384 .09176 L
.05389 .1144 L
.0539 .08416 L
.05392 .11956 L
.05393 .07084 L
.05394 .14138 L
.05396 .1155 L
.05397 .09706 L
.05399 .06669 L
.054 .12239 L
.054 .07413 L
.05402 .08216 L
.05403 .06878 L
.05404 .12633 L
.05406 .13239 L
.05407 .08349 L
.05409 .10165 L
.0541 .06945 L
.05411 .08319 L
.05413 .06722 L
.05414 .08033 L
Mistroke
.05415 .11316 L
.05416 .11431 L
.05418 .08618 L
.05418 .13138 L
.05419 .14075 L
.0542 .07667 L
.05421 .09057 L
.05422 .08956 L
.05423 .10805 L
.05424 .09983 L
.05425 .09598 L
.05427 .08518 L
.05428 .12379 L
.0543 .12158 L
.05431 .11524 L
.05433 .13109 L
.05434 .10367 L
.05435 .10391 L
.05437 .08112 L
.05438 .05091 L
.05439 .09467 L
.0544 .06849 L
.05442 .04895 L
.05443 .07121 L
.05445 .07782 L
.05446 .08769 L
.05447 .08487 L
.05449 .12398 L
.0545 .08442 L
.0545 .06373 L
.05452 .1348 L
.05453 .08982 L
.05455 .06575 L
.05456 .13346 L
.05458 .06535 L
.05459 .1113 L
.05461 .09406 L
.05462 .12496 L
.05462 .06194 L
.05464 .08661 L
.05465 .08119 L
.05467 .08941 L
.05468 .06581 L
.0547 .115 L
.05471 .05799 L
.05472 .09045 L
.05474 .04552 L
.05475 .09757 L
.05477 .06697 L
.05478 .07186 L
Mistroke
.05479 .11046 L
.0548 .06895 L
.05481 .0961 L
.05483 .06962 L
.05484 .11536 L
.05486 .09457 L
.05487 .01761 L
.05488 .10673 L
.05489 .10947 L
.0549 .09314 L
.05491 .06106 L
.05492 .06252 L
.05493 .0658 L
.05494 .10122 L
.05495 .06859 L
.05497 .11808 L
.05498 .05174 L
.05499 .10269 L
.055 .09032 L
.05501 .08426 L
.05503 .11397 L
.05504 .1312 L
.05506 .08508 L
.05507 .09992 L
.05508 .10469 L
.05509 .10831 L
.05511 .09061 L
.05512 .10251 L
.05513 .12023 L
.05515 .07804 L
.05516 .07576 L
.05517 .08206 L
.05519 .10073 L
.0552 .09437 L
.05522 .07524 L
.05523 .10006 L
.05524 .11083 L
.05525 .09484 L
.05526 .11289 L
.05528 .09484 L
.05529 .11964 L
.0553 .11937 L
.05531 .07878 L
.05532 .09652 L
.05533 .09615 L
.05534 .05864 L
.05535 .05535 L
.05536 .11048 L
.05537 .07123 L
.05539 .07392 L
Mistroke
.0554 .07546 L
.05542 .07791 L
.05543 .10886 L
.05543 .07339 L
.05544 .10771 L
.05545 .07107 L
.05546 .10861 L
.05548 .11514 L
.05549 .07683 L
.05551 .08967 L
.05552 .12746 L
.05553 .08968 L
.05554 .09821 L
.05556 .06904 L
.05557 .09753 L
.05559 .06999 L
.0556 .09718 L
.05561 .09012 L
.05563 .05149 L
.05564 .11668 L
.05565 .09935 L
.05567 .10525 L
.05568 .065 L
.0557 .11191 L
.05571 .08471 L
.05573 .09976 L
.05574 .10044 L
.05575 .09953 L
.05576 .07719 L
.05577 .11063 L
.05578 .06604 L
.05578 .07053 L
.05579 .11446 L
.05581 .06205 L
.05582 .1004 L
.05583 .14135 L
.05583 .10632 L
.05584 .06691 L
.05586 .09579 L
.05587 .06372 L
.05587 .1284 L
.05588 .09243 L
.05589 .10306 L
.0559 .10589 L
.05592 .10507 L
.05593 .09691 L
.05595 .09634 L
.05596 .09298 L
.05598 .10697 L
.05599 .10868 L
Mistroke
.05601 .10394 L
.05602 .12457 L
.05602 .07362 L
.05603 .06759 L
.05604 .08349 L
.05605 .0571 L
.05606 .12569 L
.05607 .11305 L
.05608 .08547 L
.05609 .06998 L
.0561 .12094 L
.05612 .10447 L
.05613 .06799 L
.05615 .10029 L
.05616 .11708 L
.05617 .09388 L
.05618 .08639 L
.05619 .10869 L
.0562 .08701 L
.05621 .10351 L
.05622 .1001 L
.05624 .07607 L
.05625 .08492 L
.05626 .12154 L
.05628 .14749 L
.05629 .08028 L
.0563 .1168 L
.05631 .10092 L
.05632 .13446 L
.05634 .11235 L
.05635 .09721 L
.05636 .0793 L
.05638 .08017 L
.05639 .09646 L
.05641 .11615 L
.05642 .11082 L
.05643 .0824 L
.05645 .07655 L
.05646 .04881 L
.05648 .13097 L
.05649 .09518 L
.0565 .08853 L
.05651 .11111 L
.05652 .06097 L
.05654 .07823 L
.05655 .08067 L
.05656 .12169 L
.05658 .10681 L
.05659 .12224 L
.0566 .1188 L
Mistroke
.05662 .11102 L
.05663 .10607 L
.05665 .13405 L
.05666 .11246 L
.05668 .08234 L
.05668 .08503 L
.05669 .12564 L
.05671 .07791 L
.05672 .10209 L
.05673 .11129 L
.05674 .06777 L
.05675 .12197 L
.05676 .09414 L
.05677 .11017 L
.05678 .1113 L
.05679 .11926 L
.0568 .12504 L
.05682 .07237 L
.05683 .07189 L
.05684 .09509 L
.05686 .07225 L
.05687 .07836 L
.05688 .11038 L
.05689 .11276 L
.0569 .02605 L
.05691 .14828 L
.05692 .08894 L
.05694 .08487 L
.05695 .06956 L
.05697 .13678 L
.05697 .12643 L
.05698 .10431 L
.057 .0793 L
.05701 .09013 L
.05703 .1165 L
.05704 .12259 L
.05706 .09306 L
.05707 .09106 L
.05708 .10307 L
.0571 .10124 L
.05711 .0991 L
.05712 .11809 L
.05714 .0649 L
.05715 .09618 L
.05716 .08896 L
.05717 .07979 L
.05719 .1029 L
.0572 .12871 L
.05722 .07302 L
.05722 .10562 L
Mistroke
.05723 .11078 L
.05724 .09705 L
.05725 .04156 L
.05726 .05994 L
.05727 .11896 L
.05728 .1008 L
.0573 .11036 L
.05731 .09388 L
.05733 .10657 L
.05734 .08123 L
.05735 .07797 L
.05736 .08007 L
.05737 .07934 L
.05739 .06872 L
.0574 .07713 L
.05741 .10556 L
.05742 .13726 L
.05743 .12577 L
.05745 .09555 L
.05746 .10508 L
.05747 .09146 L
.05749 .06063 L
.0575 .06862 L
.05752 .09532 L
.05753 .0883 L
.05755 .08924 L
.05756 .10015 L
.05757 .09255 L
.05758 .1059 L
.05759 .08013 L
.05761 .09379 L
.05762 .07569 L
.05762 .1317 L
.05764 .11267 L
.05765 .09271 L
.05766 .10859 L
.05767 .12159 L
.05769 .08119 L
.0577 .0661 L
.05772 .0998 L
.05773 .08171 L
.05775 .08697 L
.05776 .08094 L
.05777 .08772 L
.05779 .10592 L
.0578 .0646 L
.05782 .07002 L
.05783 .11838 L
.05784 .09719 L
.05786 .0934 L
Mistroke
.05787 .12857 L
.05788 .12665 L
.05789 .11502 L
.0579 .08809 L
.05791 .10577 L
.05792 .10996 L
.05794 .10424 L
.05795 .12571 L
.05797 .1211 L
.05798 .10268 L
.05799 .13024 L
.05801 .1041 L
.05802 .10431 L
.05803 .08861 L
.05805 .08804 L
.05806 .09862 L
.05808 .10425 L
.05809 .09032 L
.05811 .11273 L
.05812 .09465 L
.05814 .10369 L
.05815 .06765 L
.05816 .0996 L
.05817 .11163 L
.05818 .07738 L
.05819 .11529 L
.0582 .09108 L
.05821 .12138 L
.05822 .08769 L
.05823 .08286 L
.05824 .12757 L
.05825 .11845 L
.05826 .12296 L
.05827 .13066 L
.05827 .09393 L
.05828 .07823 L
.05829 .10167 L
.0583 .13311 L
.05831 .09413 L
.05833 .08269 L
.05834 .06411 L
.05836 .08717 L
.05837 .09751 L
.05839 .09515 L
.0584 .0589 L
.05841 .08527 L
.05843 .09491 L
.05844 .11181 L
.05846 .1128 L
.05847 .10132 L
Mistroke
.05849 .06821 L
.0585 .05545 L
.05852 .09369 L
.05852 .10319 L
.05853 .11411 L
.05855 .09263 L
.05856 .09241 L
.05858 .09219 L
.05859 .11486 L
.0586 .09587 L
.05862 .10487 L
.05863 .08646 L
.05864 .06557 L
.05866 .08693 L
.05867 .10684 L
.05868 .10355 L
.0587 .13269 L
.05871 .10822 L
.05872 .11448 L
.05874 .0616 L
.05875 .10694 L
.05875 .09909 L
.05877 .10661 L
.05878 .09121 L
.0588 .10366 L
.05881 .11465 L
.05883 .07393 L
.05884 .05517 L
.05886 .12104 L
.05887 .12904 L
.05888 .08979 L
.0589 .05166 L
.05891 .13594 L
.05893 .12748 L
.05894 .09356 L
.05895 .14261 L
.05897 .09506 L
.05898 .06985 L
.05899 .10934 L
.059 .10094 L
.05902 .06664 L
.05903 .07682 L
.05904 .06126 L
.05906 .09598 L
.05907 .06457 L
.05909 .07558 L
.0591 .11085 L
.05911 .10779 L
.05912 .08774 L
.05914 .10997 L
Mistroke
.05915 .11555 L
.05917 .08182 L
.05918 .09675 L
.05919 .07353 L
.0592 .10948 L
.05921 .09622 L
.05922 .10246 L
.05924 .11465 L
.05925 .10319 L
.05927 .13986 L
.05928 .06817 L
.0593 .07907 L
.05931 .06053 L
.05932 .08668 L
.05934 .12458 L
.05935 .09453 L
.05937 .0911 L
.05938 .09487 L
.0594 .07245 L
.05941 .1129 L
.05943 .14372 L
.05943 .0752 L
.05944 .12173 L
.05946 .11233 L
.05947 .08802 L
.05949 .11505 L
.0595 .08118 L
.05951 .0934 L
.05953 .11911 L
.05954 .08105 L
.05955 .10125 L
.05957 .05734 L
.05958 .10346 L
.05959 .11067 L
.05961 .09111 L
.05962 .11351 L
.05963 .08203 L
.05965 .07529 L
.05966 .10617 L
.05966 .09044 L
.05968 .08411 L
.05969 .11728 L
.05971 .07908 L
.05972 .11036 L
.05972 .09388 L
.05974 .09965 L
.05975 .08799 L
.05977 .08542 L
.05978 .10876 L
.05979 .09233 L
Mistroke
.05981 .08185 L
.05982 .09589 L
.05983 .10002 L
.05984 .12861 L
.05985 .12102 L
.05986 .10595 L
.05987 .11961 L
.05989 .09145 L
.0599 .10855 L
.05992 .06442 L
.05993 .10734 L
.05994 .12754 L
.05996 .10421 L
.05997 .08001 L
.05998 .08505 L
.05999 .08908 L
.06001 .09838 L
.06002 .09242 L
.06004 .09743 L
.06005 .05577 L
.06006 .11284 L
.06008 .10583 L
.06009 .08153 L
.06011 .11164 L
.06012 .12652 L
.06014 .1203 L
.06015 .13427 L
.06016 .08813 L
.06018 .12554 L
.06019 .08735 L
.0602 .08567 L
.06021 .09944 L
.06022 .07868 L
.06023 .08834 L
.06024 .10882 L
.06024 .10511 L
.06025 .08465 L
.06026 .08658 L
.06028 .08396 L
.06029 .09255 L
.06031 .07485 L
.06032 .11784 L
.06033 .08506 L
.06035 .07778 L
.06036 .10341 L
.06037 .09566 L
.06038 .10947 L
.0604 .10062 L
.06041 .07045 L
.06043 .10522 L
Mistroke
.06044 .06346 L
.06045 .11988 L
.06046 .05351 L
.06048 .07064 L
.06049 .12996 L
.0605 .0879 L
.06052 .10981 L
.06053 .11584 L
.06055 .13922 L
.06056 .05928 L
.06057 .0713 L
.06058 .08831 L
.06059 .09313 L
.06061 .09964 L
.06062 .06053 L
.06063 .12516 L
.06065 .10283 L
.06066 .07958 L
.06068 .06992 L
.06068 .08666 L
.06069 .10692 L
.06071 .1361 L
.06072 .06492 L
.06074 .09896 L
.06074 .05834 L
.06075 .08176 L
.06076 .10549 L
.06077 .10521 L
.06078 .10124 L
.06079 .07854 L
.0608 .06604 L
.06082 .04611 L
.06083 .10356 L
.06084 .10718 L
.06086 .12103 L
.06087 .07122 L
.06089 .08553 L
.0609 .07398 L
.06091 .06912 L
.06093 .06999 L
.06094 .07799 L
.06095 .08652 L
.06097 .08989 L
.06098 .07124 L
.06099 .14056 L
.06101 .11319 L
.06102 .07227 L
.06104 .09024 L
.06104 .05153 L
.06105 .12023 L
Mistroke
.06107 .12685 L
.06108 .08762 L
.0611 .1129 L
.06111 .10018 L
.06113 .08156 L
.06114 .05939 L
.06115 .13264 L
.06117 .10581 L
.06118 .09242 L
.06119 .10903 L
.06121 .04456 L
.06123 .08885 L
.06124 .09393 L
.06125 .08402 L
.06127 .10029 L
.06128 .10323 L
.06129 .07508 L
.0613 .07323 L
.06132 .11002 L
.06133 .08758 L
.06134 .12147 L
.06136 .05425 L
.06137 .0707 L
.06138 .11371 L
.0614 .11118 L
.06141 .08384 L
.06142 .07111 L
.06144 .10142 L
.06145 .07596 L
.06146 .08771 L
.06148 .07049 L
.06149 .08251 L
.0615 .06271 L
.06151 .04312 L
.06152 .1008 L
.06154 .09575 L
.06155 .09671 L
.06156 .13307 L
.06157 .08879 L
.06158 .11635 L
.0616 .0829 L
.06161 .08928 L
.06162 .07094 L
.06164 .08604 L
.06165 .12106 L
.06166 .09979 L
.06167 .11657 L
.06168 .10044 L
.0617 .08753 L
.06171 .09094 L
Mistroke
.06171 .08324 L
.06173 .08229 L
.06174 .10356 L
.06176 .12384 L
.06177 .07001 L
.06178 .09886 L
.0618 .07631 L
.06181 .09398 L
.06182 .12151 L
.06184 .05879 L
.06185 .11255 L
.06187 .07572 L
.06188 .057 L
.06189 .11167 L
.06191 .09569 L
.06192 .08683 L
.06193 .13588 L
.06195 .09488 L
.06196 .09681 L
.06198 .09349 L
.06199 .09282 L
.06201 .1104 L
.06202 .10161 L
.06204 .11755 L
.06205 .1195 L
.06206 .0875 L
.06207 .10865 L
.06208 .1045 L
.06212 .09274 L
.06213 .09218 L
.06214 .09009 L
.06216 .07957 L
.06217 .06494 L
.06219 .09964 L
.0622 .08917 L
.06221 .0936 L
.06223 .11009 L
.06224 .10396 L
.06225 .13422 L
.06226 .10271 L
.06227 .08062 L
.06228 .11641 L
.06229 .10946 L
.0623 .1025 L
.06232 .10421 L
.06233 .10494 L
.06235 .09172 L
.06236 .09056 L
.06238 .09927 L
.06239 .07356 L
Mistroke
.06239 .08024 L
.0624 .08817 L
.06241 .09026 L
.06242 .11632 L
.06243 .10086 L
.06244 .13463 L
.06245 .11012 L
.06246 .09353 L
.06247 .12406 L
.06248 .12871 L
.06249 .1138 L
.06251 .0747 L
.06252 .10518 L
.06254 .07945 L
.06255 .09939 L
.06256 .07579 L
.06258 .09144 L
.06259 .13117 L
.0626 .10647 L
.06261 .0993 L
.06262 .07327 L
.06263 .12548 L
.06264 .11203 L
.06265 .105 L
.06266 .09448 L
.06267 .12652 L
.06268 .05743 L
.06269 .11544 L
.0627 .11982 L
.06272 .08138 L
.06273 .08652 L
.06275 .08012 L
.06276 .12067 L
.06276 .10163 L
.06277 .0616 L
.06278 .10562 L
.06279 .07949 L
.0628 .09342 L
.06281 .0905 L
.06282 .09136 L
.06283 .12988 L
.06284 .06888 L
.06285 .09719 L
.06286 .04711 L
.06287 .11848 L
.06288 .07271 L
.06289 .12221 L
.0629 .0901 L
.06291 .07571 L
.06293 .11209 L
Mistroke
.06294 .0893 L
.06296 .09962 L
.06297 .11181 L
.06298 .06674 L
.06299 .12271 L
.063 .10048 L
.06302 .12075 L
.06303 .09363 L
.06304 .10067 L
.06305 .05082 L
.06306 .14321 L
.06307 .12906 L
.06308 .08284 L
.06309 .08148 L
.0631 .09617 L
.06311 .07389 L
.06313 .13792 L
.06314 .07332 L
.06315 .09599 L
.06317 .11682 L
.06318 .10136 L
.06319 .14457 L
.0632 .06024 L
.06322 .10656 L
.06323 .09735 L
.06324 .07688 L
.06326 .11322 L
.06327 .09135 L
.06328 .07143 L
.06329 .06878 L
.06331 .09663 L
.06332 .08612 L
.06333 .08483 L
.06335 .0846 L
.06336 .14431 L
.06337 .06997 L
.06339 .0804 L
.06341 .09962 L
.06343 .09748 L
.06344 .11453 L
.06345 .11109 L
.06347 .11252 L
.06348 .09978 L
.0635 .10214 L
.06351 .11951 L
.06353 .11551 L
.06354 .10068 L
.06355 .12402 L
.06357 .07993 L
.06358 .08167 L
Mistroke
.06359 .10592 L
.0636 .07355 L
.06361 .14168 L
.06362 .1197 L
.06363 .11115 L
.06364 .09571 L
.06366 .08135 L
.06367 .09226 L
.06369 .10087 L
.0637 .09221 L
.06372 .10601 L
.06373 .11194 L
.06375 .0753 L
.06376 .07703 L
.06377 .09472 L
.06379 .06192 L
.0638 .08868 L
.06382 .06502 L
.06383 .07398 L
.06384 .07718 L
.06385 .10982 L
.06387 .09618 L
.06388 .06398 L
.06389 .12163 L
.06391 .09023 L
.06392 .13774 L
.06394 .09127 L
.06395 .08518 L
.06396 .10854 L
.06397 .08338 L
.06398 .09053 L
.064 .09554 L
.06401 .08809 L
.06403 .11505 L
.06404 .10802 L
.06406 .08889 L
.06407 .13858 L
.06408 .11454 L
.06409 .11027 L
.06409 .10211 L
.0641 .11122 L
.06412 .10725 L
.06413 .10502 L
.06414 .08894 L
.06415 .03242 L
.06416 .07331 L
.06418 .08793 L
.06419 .08259 L
.0642 .06198 L
.06422 .07619 L
Mistroke
.06423 .04048 L
.06424 .08967 L
.06426 .11057 L
.06427 .09191 L
.06428 .087 L
.0643 .14099 L
.06431 .08445 L
.06432 .07352 L
.06433 .10652 L
.06434 .08408 L
.06436 .06319 L
.06437 .08346 L
.06438 .10153 L
.06439 .10327 L
.0644 .075 L
.06442 .09428 L
.06443 .12842 L
.06444 .08172 L
.06446 .10631 L
.06447 .06061 L
.06449 .09078 L
.0645 .08762 L
.06451 .05696 L
.06452 .10497 L
.06453 .09338 L
.06454 .10958 L
.06455 .07871 L
.06457 .11442 L
.06458 .08518 L
.0646 .07292 L
.06461 .0671 L
.06462 .08139 L
.06463 .1454 L
.06465 .07544 L
.06466 .07534 L
.06468 .08582 L
.06469 .10123 L
.0647 .06692 L
.06472 .10604 L
.06473 .08721 L
.06474 .0992 L
.06476 .09705 L
.06477 .10154 L
.06479 .09528 L
.0648 .09855 L
.06482 .10193 L
.06482 .05238 L
.06483 .05093 L
.06485 .05585 L
.06486 .07394 L
Mistroke
.06487 .10706 L
.06488 .08415 L
.0649 .0671 L
.06491 .09454 L
.06492 .0881 L
.06493 .1087 L
.06494 .11257 L
.06495 .1029 L
.06497 .10998 L
.06498 .05973 L
.065 .07822 L
.06501 .10167 L
.06502 .08699 L
.06504 .08892 L
.06505 .10639 L
.06507 .04754 L
.06508 .09489 L
.06509 .06377 L
.0651 .06579 L
.06512 .0608 L
.06513 .07667 L
.06515 .11574 L
.06516 .09578 L
.06517 .0982 L
.06518 .07852 L
.06519 .08457 L
.06521 .11596 L
.06521 .07567 L
.06522 .08545 L
.06523 .11206 L
.06524 .08755 L
.06526 .11717 L
.06527 .1041 L
.06528 .07956 L
.06529 .1034 L
.0653 .10281 L
.0653 .13567 L
.06532 .10876 L
.06533 .09331 L
.06534 .11289 L
.06535 .10166 L
.06536 .0938 L
.06538 .07181 L
.06539 .1014 L
.0654 .12526 L
.06542 .0912 L
.06543 .07765 L
.06544 .06103 L
.06545 .14325 L
.06547 .10575 L
Mistroke
.06548 .07827 L
.06548 .12475 L
.0655 .08526 L
.06551 .09804 L
.06553 .08985 L
.06554 .09361 L
.06555 .1163 L
.06557 .11812 L
.06558 .08079 L
.06559 .08928 L
.06561 .06193 L
.06562 .07131 L
.06564 .08945 L
.06565 .07907 L
.06566 .1185 L
.06567 .09151 L
.06569 .10248 L
.0657 .0667 L
.06572 .09359 L
.06573 .11174 L
.06575 .12082 L
.06576 .04158 L
.06578 .08109 L
.06579 .09343 L
.0658 .14761 L
.06581 .0877 L
.06582 .07493 L
.06583 .10749 L
.06584 .09599 L
.06585 .07615 L
.06586 .09158 L
.06587 .08496 L
.06589 .09704 L
.0659 .08874 L
.06591 .11502 L
.06593 .08749 L
.06594 .07957 L
.06596 .05967 L
.06597 .07966 L
.06598 .09821 L
.066 .06501 L
.06601 .07868 L
.06603 .08529 L
.06604 .11032 L
.06604 .08653 L
.06606 .08048 L
.06607 .07909 L
.06609 .1138 L
.0661 .10423 L
.06612 .0995 L
Mistroke
.06613 .09853 L
.06613 .10947 L
.06614 .0644 L
.06615 .08674 L
.06616 .11655 L
.06617 .06273 L
.06618 .092 L
.06619 .1346 L
.0662 .09226 L
.06621 .12196 L
.06622 .05841 L
.06623 .1094 L
.06623 .14126 L
.06625 .12588 L
.06626 .09138 L
.06628 .10439 L
.06629 .09181 L
.0663 .13834 L
.0663 .10723 L
.06631 .1032 L
.06633 .09342 L
.06633 .13741 L
.06634 .12092 L
.06636 .13885 L
.06637 .07683 L
.06639 .06432 L
.0664 .09166 L
.06641 .09167 L
.06643 .09333 L
.06644 .12595 L
.06645 .13608 L
.06647 .09071 L
.06648 .0784 L
.0665 .05607 L
.06651 .13027 L
.06652 .12259 L
.06653 .08 L
.06654 .07728 L
.06656 .11313 L
.06657 .08569 L
.06659 .10565 L
.0666 .05968 L
.06661 .13132 L
.06662 .10626 L
.06664 .07866 L
.06664 .09278 L
.06665 .11185 L
.06666 .11644 L
.06667 .08693 L
.06668 .09749 L
Mistroke
.06669 .1002 L
.0667 .09612 L
.0667 .10503 L
.06672 .08386 L
.06673 .09637 L
.06675 .09886 L
.06676 .09584 L
.06678 .08154 L
.06679 .11205 L
.06681 .10011 L
.06682 .09413 L
.06683 .08979 L
.06685 .07943 L
.06686 .11637 L
.06688 .1078 L
.06691 .08471 L
.06692 .12794 L
.06694 .06518 L
.06695 .09464 L
.06695 .07578 L
.06697 .1031 L
.06698 .06637 L
.067 .12816 L
.06701 .10219 L
.06702 .09216 L
.06704 .1284 L
.06705 .11508 L
.06707 .11991 L
.06708 .11189 L
.06709 .03119 L
.06711 .14199 L
.06712 .10527 L
.06713 .07719 L
.06715 .09612 L
.06716 .10473 L
.06717 .06083 L
.06719 .12309 L
.0672 .11411 L
.06722 .08666 L
.06723 .07842 L
.06724 .09921 L
.06726 .10807 L
.06727 .08278 L
.06729 .10259 L
.0673 .09198 L
.0673 .1042 L
.06731 .12178 L
.06732 .11258 L
.06734 .09394 L
.06735 .10006 L
Mistroke
.06736 .07925 L
.06737 .07642 L
.06738 .06542 L
.0674 .09409 L
.0674 .10459 L
.06741 .09466 L
.06743 .08421 L
.06744 .05493 L
.06745 .08237 L
.06747 .11055 L
.06748 .08452 L
.0675 .11295 L
.06751 .11003 L
.06753 .08881 L
.06754 .07889 L
.06756 .08785 L
.06757 .12582 L
.06758 .06536 L
.0676 .10808 L
.06761 .09111 L
.06762 .11031 L
.06764 .06576 L
.06765 .06587 L
.06766 .09522 L
.06768 .09513 L
.06769 .14731 L
.06771 .0962 L
.06772 .1008 L
.06773 .08583 L
.06775 .13797 L
.06776 .08324 L
.06778 .10892 L
.06779 .11013 L
.06781 .08403 L
.06782 .10659 L
.06784 .07603 L
.06785 .08357 L
.06785 .13334 L
.06787 .0763 L
.06788 .09528 L
.0679 .09908 L
.06791 .13308 L
.06792 .11075 L
.06794 .07936 L
.06795 .1252 L
.06796 .08541 L
.06798 .09412 L
.06799 .10824 L
.068 .08829 L
.06802 .11261 L
Mistroke
.06803 .13888 L
.06804 .06291 L
.06806 .08998 L
.06807 .09392 L
.06808 .06633 L
.06809 .07586 L
.0681 .06777 L
.06812 .07967 L
.06813 .06699 L
.06813 .11455 L
.06815 .14297 L
.06816 .06726 L
.06818 .07409 L
.06819 .07392 L
.0682 .07448 L
.06822 .07191 L
.06823 .09907 L
.06824 .09186 L
.06825 .13935 L
.06826 .06903 L
.06827 .09603 L
.06828 .10555 L
.0683 .1148 L
.06831 .07967 L
.06833 .10422 L
.06834 .08153 L
.06835 .07442 L
.06837 .05703 L
.06838 .10313 L
.06839 .12392 L
.0684 .06925 L
.06842 .08274 L
.06843 .06798 L
.06845 .13389 L
.06846 .08496 L
.06848 .08671 L
.06849 .10477 L
.0685 .07721 L
.06852 .12943 L
.06853 .10831 L
.06855 .07158 L
.06856 .12306 L
.06858 .10236 L
.06859 .09193 L
.0686 .1055 L
.06861 .07523 L
.06861 .07723 L
.06862 .08597 L
.06864 .06517 L
.06865 .12777 L
Mistroke
.06866 .12053 L
.06867 .12389 L
.06868 .11735 L
.0687 .07529 L
.06871 .09298 L
.06873 .0834 L
.06874 .08637 L
.06875 .06515 L
.06877 .12404 L
.06878 .11198 L
.06879 .13305 L
.06881 .08889 L
.06882 .06702 L
.06883 .14725 L
.06884 .10566 L
.06886 .11044 L
.06887 .08897 L
.06889 .16221 L
.0689 .05592 L
.06891 .09794 L
.06892 .09792 L
.06893 .09503 L
.06895 .08759 L
.06896 .10479 L
.06896 .10482 L
.06897 .1076 L
.06898 .08702 L
.06899 .1118 L
.069 .12915 L
.06901 .07247 L
.06902 .03478 L
.06903 .13596 L
.06905 .10454 L
.06906 .12954 L
.06908 .12057 L
.06909 .09467 L
.0691 .13448 L
.06912 .07266 L
.06913 .09188 L
.06915 .08822 L
.06916 .11519 L
.06917 .09079 L
.06919 .10323 L
.0692 .1144 L
.06922 .08577 L
.06923 .12099 L
.06924 .0836 L
.06925 .08328 L
.06927 .06485 L
.06928 .12654 L
Mistroke
.06929 .11489 L
.06931 .12878 L
.06932 .08332 L
.06933 .07366 L
.06935 .08699 L
.06936 .0775 L
.06937 .08947 L
.06939 .08739 L
.0694 .13001 L
.06941 .12084 L
.06943 .10054 L
.06944 .07744 L
.06945 .09285 L
.06946 .10923 L
.06947 .10521 L
.06949 .09549 L
.0695 .09332 L
.06951 .10299 L
.06953 .07378 L
.06954 .12193 L
.06956 .06527 L
.06957 .10244 L
.06959 .0829 L
.0696 .08307 L
.06961 .10928 L
.06962 .09851 L
.06963 .07796 L
.06964 .07882 L
.06965 .11661 L
.06966 .10964 L
.06968 .08495 L
.06969 .07634 L
.06971 .09136 L
.06972 .11473 L
.06973 .05749 L
.06975 .06509 L
.06976 .0977 L
.06978 .10774 L
.06979 .11883 L
.06981 .11618 L
.06982 .08555 L
.06983 .06903 L
.06985 .07521 L
.06986 .08107 L
.06988 .12271 L
.06989 .07309 L
.0699 .11968 L
.06992 .12683 L
.06993 .07637 L
.06994 .12124 L
Mistroke
.06995 .10041 L
.06997 .1103 L
.06998 .15026 L
.06999 .11585 L
.07 .0925 L
.07001 .10352 L
.07003 .0999 L
.07004 .09302 L
.07005 .10684 L
.07007 .12477 L
.07008 .1114 L
.07009 .08469 L
.0701 .12075 L
.07011 .09058 L
.07012 .10828 L
.07013 .08593 L
.07015 .09744 L
.07016 .09606 L
.07018 .08867 L
.07019 .08144 L
.0702 .10283 L
.07022 .11891 L
.07023 .12946 L
.07024 .08104 L
.07025 .08862 L
.07027 .09474 L
.07028 .11856 L
.0703 .05382 L
.07031 .09573 L
.07033 .0746 L
.07034 .09247 L
.07035 .1054 L
.07037 .08429 L
.07038 .08817 L
.0704 .10472 L
.07041 .15101 L
.07042 .0627 L
.07044 .05007 L
.07045 .095 L
.07047 .05194 L
.07048 .13739 L
.0705 .12015 L
.07051 .11798 L
.07052 .11294 L
.07053 .07809 L
.07054 .09105 L
.07056 .08805 L
.07056 .07121 L
.07057 .0694 L
.07058 .07711 L
Mistroke
.07059 .08458 L
.0706 .10655 L
.07062 .07885 L
.07063 .07853 L
.07063 .11802 L
.07065 .14377 L
.07067 .0892 L
.07068 .08188 L
.0707 .10365 L
.0707 .13467 L
.07071 .10925 L
.07073 .13767 L
.07074 .15191 L
.07076 .07745 L
.07077 .07903 L
.07078 .08581 L
.07079 .08529 L
.0708 .07539 L
.0708 .08249 L
.07082 .08804 L
.07083 .09381 L
.07084 .13285 L
.07085 .08409 L
.07086 .08919 L
.07087 .07686 L
.07089 .10987 L
.07089 .10813 L
.0709 .0996 L
.07092 .11183 L
.07093 .08365 L
.07095 .06208 L
.07096 .08898 L
.07097 .06683 L
.07098 .06622 L
.071 .07125 L
.07101 .15178 L
.07102 .05916 L
.07104 .05525 L
.07105 .10285 L
.07106 .11747 L
.07108 .07533 L
.07109 .16777 L
.07111 .08288 L
.07112 .07778 L
.07114 .1279 L
.07115 .11381 L
.07117 .07557 L
.07117 .1074 L
.07118 .13808 L
.07119 .10841 L
Mistroke
.0712 .094 L
.07121 .1163 L
.07122 .09656 L
.07123 .09012 L
.07124 .09231 L
.07125 .12527 L
.07126 .10095 L
.07127 .10795 L
.07128 .07266 L
.0713 .12708 L
.07131 .12265 L
.07132 .06668 L
.07133 .10574 L
.07134 .08657 L
.07136 .08432 L
.07137 .07373 L
.07139 .11226 L
.07139 .11561 L
.0714 .11118 L
.07142 .0952 L
.07143 .1083 L
.07144 .12309 L
.07145 .08647 L
.07147 .10398 L
.07148 .11035 L
.07149 .07199 L
.0715 .0973 L
.07151 .11698 L
.07152 .09694 L
.07154 .12558 L
.07155 .07113 L
.07157 .08073 L
.07158 .08613 L
.07159 .07555 L
.07161 .09286 L
.07162 .06377 L
.07164 .1353 L
.07165 .08879 L
.07166 .09112 L
.07167 .09604 L
.07169 .12884 L
.0717 .09444 L
.07172 .08437 L
.07173 .12345 L
.07174 .07581 L
.07175 .09463 L
.07176 .07557 L
.07178 .07914 L
.07178 .10125 L
.07179 .11629 L
Mistroke
.0718 .08839 L
.07181 .1177 L
.07183 .07345 L
.07184 .08032 L
.07185 .13384 L
.07186 .13265 L
.07187 .14067 L
.07187 .07321 L
.07189 .11247 L
.0719 .08114 L
.07191 .11024 L
.07192 .08191 L
.07193 .0887 L
.07195 .08816 L
.07196 .07066 L
.07198 .09663 L
.07199 .11694 L
.072 .10451 L
.07202 .12712 L
.07203 .07621 L
.07205 .08978 L
.07206 .08645 L
.07206 .08826 L
.07208 .09815 L
.07209 .11131 L
.07209 .07538 L
.0721 .09717 L
.07211 .0957 L
.07212 .09428 L
.07214 .12528 L
.07215 .14629 L
.07217 .07436 L
.07218 .07295 L
.07219 .07753 L
.0722 .12514 L
.07222 .0964 L
.07223 .11914 L
.07224 .08434 L
.07226 .09097 L
.07227 .12207 L
.07229 .07623 L
.0723 .09033 L
.07231 .10621 L
.07232 .09399 L
.07233 .09089 L
.07234 .09998 L
.07235 .08623 L
.07236 .12663 L
.07238 .07917 L
.07239 .0889 L
Mistroke
.0724 .0757 L
.07241 .09972 L
.07243 .07579 L
.07244 .09371 L
.07245 .07824 L
.07246 .10264 L
.07247 .08335 L
.07248 .09978 L
.07249 .12147 L
.0725 .0919 L
.07252 .1147 L
.07253 .05999 L
.07254 .09548 L
.07255 .09466 L
.07256 .11242 L
.07257 .10072 L
.07258 .08496 L
.07259 .05876 L
.0726 .09306 L
.07262 .10943 L
.07263 .10158 L
.07264 .13337 L
.07265 .12345 L
.07266 .08639 L
.07267 .08045 L
.07268 .0802 L
.0727 .07795 L
.07271 .05741 L
.07271 .08408 L
.07273 .09039 L
.07274 .11336 L
.07276 .08516 L
.07277 .13627 L
.07277 .13185 L
.07279 .08765 L
.0728 .08926 L
.07282 .12069 L
.07283 .06353 L
.07284 .10025 L
.07286 .08758 L
.07287 .07017 L
.07289 .09888 L
.0729 .08926 L
.07291 .07364 L
.07292 .11237 L
.07293 .09299 L
.07295 .10287 L
.07296 .11319 L
.07298 .10032 L
.07299 .14444 L
Mistroke
.073 .08197 L
.07302 .08427 L
.07303 .08108 L
.07304 .08286 L
.07306 .09776 L
.07307 .09787 L
.07308 .09308 L
.07309 .11481 L
.07311 .11876 L
.07312 .10537 L
.07313 .11676 L
.07314 .10056 L
.07315 .11706 L
.07316 .10133 L
.07317 .11799 L
.07318 .0753 L
.07319 .09327 L
.0732 .11636 L
.07322 .04879 L
.07323 .09789 L
.07324 .082 L
.07326 .13551 L
.07327 .07888 L
.07328 .11547 L
.07329 .06996 L
.07331 .07099 L
.07332 .11738 L
.07334 .07796 L
.07335 .04591 L
.07337 .0939 L
.07338 .10655 L
.07339 .1218 L
.07341 .09871 L
.07342 .06292 L
.07344 .05852 L
.07345 .1003 L
.07346 .09906 L
.07348 .07373 L
.07349 .11623 L
.0735 .08037 L
.07351 .09827 L
.07353 .08111 L
.07354 .08135 L
.07356 .09375 L
.07357 .0766 L
.07358 .10396 L
.0736 .10084 L
.07361 .07084 L
.07362 .09026 L
.07363 .08574 L
Mistroke
.07365 .1088 L
.07366 .09034 L
.07368 .08707 L
.07369 .08988 L
.0737 .09733 L
.07372 .07261 L
.07372 .0944 L
.07373 .13613 L
.07375 .07585 L
.07376 .0901 L
.07378 .12431 L
.07379 .09349 L
.07381 .11794 L
.07382 .09434 L
.07383 .05849 L
.07385 .09696 L
.07386 .08042 L
.07387 .06658 L
.07389 .077 L
.0739 .11124 L
.07392 .09168 L
.07393 .08004 L
.07395 .12788 L
.07396 .10983 L
.07397 .10773 L
.07398 .09786 L
.074 .06445 L
.07401 .08968 L
.07402 .10624 L
.07404 .10527 L
.07405 .08598 L
.07406 .09863 L
.07407 .11092 L
.07409 .09633 L
.0741 .10676 L
.07411 .11681 L
.07413 .08702 L
.07414 .09766 L
.07416 .10483 L
.07417 .05143 L
.07418 .07792 L
.07419 .1254 L
.0742 .08803 L
.07422 .11672 L
.07423 .13409 L
.07425 .09104 L
.07426 .12808 L
.07427 .0917 L
.07429 .11282 L
.0743 .11314 L
Mistroke
.07431 .05658 L
.07433 .11374 L
.07434 .10071 L
.07436 .11065 L
.07437 .07895 L
.07438 .09497 L
.07439 .09369 L
.07441 .10072 L
.07442 .12033 L
.07444 .12878 L
.07445 .10034 L
.07446 .06725 L
.07448 .13373 L
.07449 .1264 L
.07451 .10208 L
.07452 .11819 L
.07453 .10467 L
.07454 .09479 L
.07456 .10555 L
.07457 .11691 L
.07458 .0717 L
.0746 .0828 L
.07461 .08777 L
.07463 .08036 L
.07463 .12342 L
.07464 .07848 L
.07466 .1161 L
.07467 .08258 L
.07469 .0992 L
.07469 .05234 L
.0747 .08724 L
.07471 .12187 L
.07473 .10109 L
.07474 .12185 L
.07476 .12932 L
.07477 .10731 L
.07478 .11315 L
.0748 .13672 L
.07481 .07485 L
.07481 .0543 L
.07483 .10974 L
.07484 .09187 L
.07485 .06185 L
.07486 .11317 L
.07488 .13413 L
.07489 .07951 L
.07491 .08559 L
.07493 .11733 L
.07494 .13616 L
.07496 .10363 L
Mistroke
.07497 .10187 L
.07499 .12361 L
.075 .13013 L
.07501 .11576 L
.07503 .07335 L
.07504 .08841 L
.07505 .06516 L
.07506 .08162 L
.07507 .06872 L
.07509 .11439 L
.0751 .11198 L
.07511 .09715 L
.07513 .06244 L
.07514 .0845 L
.07516 .10629 L
.07516 .10887 L
.07517 .09716 L
.07518 .12409 L
.07519 .08964 L
.0752 .07526 L
.07522 .11389 L
.07523 .08004 L
.07525 .09483 L
.07526 .09789 L
.07528 .09617 L
.07529 .09115 L
.0753 .05937 L
.07532 .08055 L
.07533 .09732 L
.07535 .06285 L
.07536 .09012 L
.07537 .08317 L
.07539 .10999 L
.0754 .12081 L
.07542 .10338 L
.07543 .1249 L
.07544 .09394 L
.07545 .1155 L
.07547 .07744 L
.07547 .11932 L
.07548 .13415 L
.07549 .1156 L
.0755 .09053 L
.07551 .09133 L
.07552 .08538 L
.07553 .06424 L
.07554 .08149 L
.07555 .0714 L
.07556 .05757 L
.07557 .07429 L
Mistroke
.07557 .10515 L
.07558 .14288 L
.0756 .07445 L
.07561 .06679 L
.07563 .08052 L
.07564 .10519 L
.07566 .11308 L
.07567 .09265 L
.07568 .06957 L
.0757 .12746 L
.07571 .09602 L
.07572 .10452 L
.07574 .08359 L
.07575 .10792 L
.07577 .11631 L
.07578 .08938 L
.0758 .0941 L
.07581 .12232 L
.07582 .09469 L
.07583 .15266 L
.07585 .12181 L
.07586 .11037 L
.07587 .10509 L
.07589 .11842 L
.0759 .09132 L
.07591 .12369 L
.07593 .11023 L
.07594 .09798 L
.07595 .09064 L
.07596 .06297 L
.07598 .10773 L
.07599 .10139 L
.07601 .06189 L
.07602 .09669 L
.07604 .09411 L
.07605 .08766 L
.07607 .08821 L
.07608 .09618 L
.07609 .07049 L
.07611 .02813 L
.07612 .08691 L
.07614 .09495 L
.07615 .1047 L
.07617 .11937 L
.07618 .08621 L
.07619 .11186 L
.07619 .11521 L
.07621 .08861 L
.07622 .12422 L
.07623 .09144 L
Mistroke
.07623 .08735 L
.07624 .08148 L
.07625 .10943 L
.07626 .09627 L
.07627 .13034 L
.07629 .09315 L
.0763 .09505 L
.07632 .10463 L
.07633 .05657 L
.07635 .09873 L
.07636 .11826 L
.07638 .10048 L
.07639 .11251 L
.07639 .0989 L
.0764 .11221 L
.07641 .11009 L
.07642 .06434 L
.07643 .08796 L
.07644 .09899 L
.07645 .09561 L
.07646 .13026 L
.07647 .08253 L
.07649 .09377 L
.0765 .09029 L
.07651 .09803 L
.07652 .11518 L
.07653 .08835 L
.07654 .11878 L
.07655 .07158 L
.07656 .05561 L
.07657 .06092 L
.07658 .05914 L
.0766 .08889 L
.07661 .13589 L
.07663 .11196 L
.07664 .07443 L
.07666 .08658 L
.07667 .10065 L
.07668 .12279 L
.0767 .08727 L
.07671 .09696 L
.07673 .08876 L
.07674 .1215 L
.07675 .10147 L
.07676 .12847 L
.07677 .11356 L
.07679 .09907 L
.0768 .08788 L
.07682 .08206 L
.07683 .0938 L
Mistroke
.07684 .03924 L
.07686 .10801 L
.07687 .09296 L
.07688 .05302 L
.07689 .08852 L
.07691 .11599 L
.07692 .11047 L
.07694 .10379 L
.07695 .09105 L
.07696 .09277 L
.07697 .1252 L
.07698 .0742 L
.07699 .10853 L
.07701 .05141 L
.07702 .10226 L
.07704 .08967 L
.07705 .11056 L
.07707 .10614 L
.07708 .06373 L
.07709 .13029 L
.07711 .07033 L
.07712 .09741 L
.07714 .09733 L
.07715 .09918 L
.07717 .10312 L
.07718 .09966 L
.0772 .07994 L
.0772 .08447 L
.07721 .08694 L
.07723 .14664 L
.07724 .11683 L
.07726 .13475 L
.07727 .1387 L
.07728 .10515 L
.0773 .08885 L
.07731 .0914 L
.07732 .10781 L
.07733 .10732 L
.07735 .0819 L
.07736 .08996 L
.07738 .07865 L
.07739 .0985 L
.0774 .10222 L
.07742 .13057 L
.07743 .09942 L
.07743 .09713 L
.07745 .10417 L
.07746 .10395 L
.07748 .06807 L
.07749 .06816 L
Mistroke
.07751 .06796 L
.07752 .0845 L
.07753 .08136 L
.07755 .11169 L
.07756 .14346 L
.07758 .10998 L
.07759 .08451 L
.07761 .07827 L
.07762 .08445 L
.07763 .08629 L
.07765 .05754 L
.07766 .06513 L
.07767 .0768 L
.07768 .07612 L
.0777 .0853 L
.07771 .12415 L
.07772 .09797 L
.07774 .09902 L
.07775 .1214 L
.07776 .10762 L
.07778 .11868 L
.07779 .08745 L
.0778 .08704 L
.07782 .10218 L
.07783 .10692 L
.07784 .09064 L
.07786 .08888 L
.07787 .09775 L
.07788 .08521 L
.07789 .06648 L
.0779 .0939 L
.07792 .12746 L
.07793 .09752 L
.07795 .11386 L
.07796 .09015 L
.07798 .08017 L
.07799 .10633 L
.078 .09655 L
.07802 .13266 L
.07803 .08842 L
.07804 .11595 L
.07806 .07984 L
.07807 .09669 L
.07809 .12499 L
.0781 .09709 L
.07811 .11086 L
.07812 .07701 L
.07814 .12407 L
.07815 .07588 L
.07816 .07558 L
Mistroke
.07818 .0667 L
.07819 .12534 L
.07821 .09148 L
.07822 .08354 L
.07823 .08132 L
.07824 .10176 L
.07826 .08188 L
.07827 .09062 L
.07828 .0983 L
.0783 .1176 L
.07831 .09221 L
.07833 .09333 L
.07833 .08318 L
.07834 .04471 L
.07836 .12557 L
.07837 .12965 L
.07839 .12343 L
.0784 .10399 L
.07841 .12165 L
.07843 .06275 L
.07844 .11638 L
.07846 .09088 L
.07847 .12165 L
.07848 .08706 L
.0785 .0809 L
.07851 .05961 L
.07853 .14983 L
.07854 .10348 L
.07856 .06198 L
.07857 .08319 L
.07858 .09857 L
.07859 .11267 L
.07861 .10952 L
.07862 .08429 L
.07863 .10305 L
.07864 .09135 L
.07866 .11492 L
.07867 .11041 L
.07868 .09656 L
.0787 .11914 L
.07871 .07571 L
.07872 .10228 L
.07873 .08008 L
.07874 .1079 L
.07876 .1048 L
.07877 .13473 L
.07878 .09058 L
.0788 .10829 L
.07881 .11174 L
.07883 .07606 L
Mistroke
.07884 .11811 L
.07885 .097 L
.07886 .09092 L
.07887 .08321 L
.07889 .12816 L
.0789 .12493 L
.07891 .13262 L
.07893 .10023 L
.07894 .0814 L
.07896 .12277 L
.07897 .05922 L
.07897 .06532 L
.07898 .08339 L
.07899 .10902 L
.07901 .09614 L
.07902 .12854 L
.07903 .08537 L
.07905 .07482 L
.07907 .08957 L
.07908 .09194 L
.07909 .13825 L
.0791 .11794 L
.07912 .06508 L
.07913 .09635 L
.07915 .10815 L
.07916 .09478 L
.07917 .04564 L
.07919 .10571 L
.0792 .07719 L
.07921 .09757 L
.07923 .11128 L
.07924 .05963 L
.07926 .09666 L
.07927 .12181 L
.07929 .08668 L
.0793 .10893 L
.07932 .10023 L
.07932 .09833 L
.07933 .08271 L
.07934 .07386 L
.07935 .05489 L
.07936 .10548 L
.07937 .09276 L
.07938 .03921 L
.07939 .06133 L
.07941 .09689 L
.07942 .06561 L
.07944 .07572 L
.07947 .09295 L
.07948 .10709 L
Mistroke
.0795 .10443 L
.07951 .09593 L
.07952 .09204 L
.07954 .08574 L
.07955 .14095 L
.07957 .09985 L
.07958 .07818 L
.0796 .09515 L
.0796 .08356 L
.07961 .09864 L
.07963 .07662 L
.07964 .12125 L
.07964 .09546 L
.07965 .11106 L
.07966 .1319 L
.07968 .12749 L
.07968 .15216 L
.07969 .07903 L
.0797 .05689 L
.07971 .13228 L
.07972 .10686 L
.07973 .067 L
.07974 .07029 L
.07974 .0655 L
.07976 .09659 L
.07977 .10109 L
.07979 .11564 L
.0798 .0954 L
.07982 .08628 L
.07983 .09931 L
.07985 .05678 L
.07986 .10582 L
.07987 .12031 L
.07989 .06874 L
.0799 .08777 L
.07992 .0953 L
.07993 .11102 L
.07994 .08367 L
.07996 .13284 L
.07997 .07887 L
.07998 .08999 L
.07999 .12751 L
.08001 .13079 L
.08002 .09047 L
.08004 .11817 L
.08005 .12639 L
.08006 .1348 L
.08008 .09986 L
.08009 .12961 L
.0801 .0913 L
Mistroke
.08012 .1101 L
.08013 .12115 L
.08015 .09144 L
.08016 .11233 L
.08017 .07169 L
.08018 .0658 L
.0802 .09743 L
.08021 .11043 L
.08023 .08157 L
.08024 .08868 L
.08026 .11203 L
.08027 .0665 L
.08028 .10402 L
.0803 .08782 L
.08031 .12756 L
.08031 .07898 L
.08033 .09467 L
.08034 .06254 L
.08036 .0794 L
.08037 .09022 L
.08038 .08628 L
.0804 .09352 L
.08041 .11895 L
.08042 .10109 L
.08044 .10326 L
.08045 .11528 L
.08047 .08096 L
.08048 .09728 L
.08048 .05677 L
.0805 .09409 L
.08051 .09442 L
.08052 .08404 L
.08053 .08895 L
.08055 .06925 L
.08055 .08598 L
.08056 .12769 L
.08057 .1072 L
.08058 .10727 L
.0806 .099 L
.0806 .08808 L
.08061 .09966 L
.08063 .09504 L
.08064 .09986 L
.08066 .09281 L
.08067 .07865 L
.08069 .11369 L
.0807 .11838 L
.08071 .09631 L
.08072 .08799 L
.08073 .07845 L
Mistroke
.08075 .12013 L
.08076 .14738 L
.08077 .08264 L
.08079 .11839 L
.0808 .13799 L
.08081 .09862 L
.08082 .11741 L
.08083 .06867 L
.08084 .06178 L
.08086 .12409 L
.08087 .07351 L
.08088 .14559 L
.08089 .1214 L
.08091 .10162 L
.08092 .06898 L
.08094 .12125 L
.08095 .06767 L
.08096 .10212 L
.08098 .08381 L
.08099 .12636 L
.081 .11723 L
.08102 .09704 L
.08103 .08991 L
.08104 .07628 L
.08106 .1351 L
.08107 .08675 L
.08108 .09834 L
.0811 .12279 L
.08111 .10277 L
.08113 .0755 L
.08114 .06153 L
.08116 .07578 L
.08117 .0838 L
.08118 .0975 L
.0812 .07688 L
.08121 .09156 L
.08123 .0972 L
.08124 .1073 L
.08125 .0842 L
.08126 .08348 L
.08127 .11256 L
.08129 .11574 L
.0813 .09289 L
.08131 .09432 L
.08133 .10637 L
.08134 .10713 L
.08136 .08951 L
.08137 .07861 L
.08139 .07712 L
.08139 .12845 L
Mistroke
.0814 .07392 L
.08142 .09057 L
.08143 .13041 L
.08145 .10607 L
.08146 .07738 L
.08146 .12335 L
.08148 .08832 L
.08149 .12163 L
.0815 .13799 L
.0815 .12116 L
.08151 .12026 L
.08153 .07595 L
.08154 .06674 L
.08156 .12645 L
.08157 .07671 L
.08159 .07167 L
.0816 .08754 L
.0816 .12052 L
.08162 .08993 L
.08163 .08319 L
.08165 .12371 L
.08166 .14612 L
.08168 .10774 L
.08169 .09728 L
.08171 .11775 L
.08172 .08457 L
.08173 .1088 L
.08175 .12019 L
.08176 .11656 L
.08178 .13784 L
.08179 .11284 L
.08181 .11402 L
.08182 .09322 L
.08183 .09391 L
.08184 .08126 L
.08185 .08359 L
.08187 .07749 L
.08188 .10525 L
.0819 .0432 L
.08191 .11834 L
.08192 .10591 L
.08194 .06849 L
.08195 .12456 L
.08196 .09866 L
.08197 .0982 L
.08199 .07729 L
.082 .0551 L
.08202 .05701 L
.08203 .0808 L
.08204 .09883 L
Mistroke
.08205 .09467 L
.08206 .08354 L
.08207 .08503 L
.08209 .10685 L
.0821 .08694 L
.08212 .10786 L
.08213 .09796 L
.08215 .09477 L
.08216 .10001 L
.08217 .09038 L
.08219 .12015 L
.0822 .11 L
.08222 .09172 L
.08223 .12287 L
.08225 .08694 L
.08226 .08971 L
.08228 .1048 L
.08229 .09142 L
.08229 .08664 L
.08231 .10966 L
.08232 .10956 L
.08254 .10751 L
.08256 .10265 L
.08257 .1424 L
.08258 .11286 L
.08259 .09981 L
.0826 .07604 L
.08262 .15812 L
.08263 .09906 L
.08265 .08166 L
.08266 .11778 L
.08267 .0764 L
.08269 .14022 L
.0827 .09737 L
.08272 .1005 L
.08273 .11877 L
.08274 .09944 L
.08275 .13757 L
.08276 .08567 L
.08277 .12852 L
.08278 .12198 L
.08278 .10518 L
.0828 .12115 L
.08281 .12934 L
.08282 .08639 L
.08284 .11724 L
.08285 .10655 L
.08286 .05103 L
.08288 .12369 L
.08289 .1194 L
Mistroke
.0829 .0744 L
.08292 .12295 L
.08293 .10697 L
.08294 .06105 L
.08296 .10208 L
.08297 .10036 L
.08297 .09562 L
.08299 .09603 L
.083 .12546 L
.08302 .12212 L
.08303 .06622 L
.08305 .15131 L
.08306 .07583 L
.08308 .1018 L
.08309 .09396 L
.0831 .11475 L
.08312 .11688 L
.08313 .10623 L
.08315 .0979 L
.08316 .0705 L
.08318 .06263 L
.08319 .07768 L
.08321 .09918 L
.08322 .10878 L
.08324 .12956 L
.08325 .11766 L
.08327 .06386 L
.08328 .09999 L
.08329 .11624 L
.0833 .07772 L
.08331 .09718 L
.08332 .07203 L
.08334 .10747 L
.08335 .10112 L
.08337 .1227 L
.08338 .1002 L
.08339 .10014 L
.08341 .07668 L
.08342 .09181 L
.08343 .07074 L
.08344 .12432 L
.08346 .06814 L
.08347 .0549 L
.08347 .08186 L
.08349 .09801 L
.0835 .0686 L
.08352 .14248 L
.08353 .05387 L
.08355 .09041 L
.08356 .07372 L
Mistroke
.08357 .09241 L
.08359 .07193 L
.0836 .10092 L
.08362 .09065 L
.08363 .10396 L
.08364 .10261 L
.08365 .05303 L
.08366 .12605 L
.08367 .08107 L
.08368 .06439 L
.08369 .10644 L
.0837 .08643 L
.08371 .05523 L
.08372 .07407 L
.08373 .07747 L
.08375 .13092 L
.08376 .03327 L
.08378 .15069 L
.08379 .08317 L
.0838 .0868 L
.08382 .07084 L
.08383 .11355 L
.08384 .0541 L
.08386 .09028 L
.08387 .08983 L
.08389 .06068 L
.0839 .12197 L
.08392 .10329 L
.08393 .12864 L
.08395 .05628 L
.08395 .06815 L
.08396 .09011 L
.08398 .09321 L
.08399 .06045 L
.084 .08702 L
.08401 .08655 L
.08402 .11559 L
.08404 .0791 L
.08405 .06897 L
.08407 .11064 L
.08408 .07508 L
.08409 .08082 L
.08411 .09041 L
.08412 .07427 L
.08413 .12805 L
.08415 .11973 L
.08417 .07337 L
.08417 .10474 L
.08418 .09962 L
.0842 .0872 L
Mistroke
.08421 .08995 L
.08422 .12217 L
.08423 .10045 L
.08424 .0878 L
.08425 .09941 L
.08426 .0961 L
.08427 .12175 L
.08428 .08143 L
.08429 .08846 L
.0843 .12792 L
.08431 .1222 L
.08434 .10357 L
.08436 .11454 L
.08437 .086 L
.08439 .0791 L
.0844 .09408 L
.08442 .11384 L
.08443 .13124 L
.08444 .10992 L
.08446 .08524 L
.08447 .0998 L
.08449 .09691 L
.08449 .09218 L
.0845 .09393 L
.08452 .08201 L
.08453 .0987 L
.08453 .10795 L
.08454 .09524 L
.08455 .10641 L
.08457 .08973 L
.08457 .11054 L
.08458 .07425 L
.0846 .11246 L
.08461 .09625 L
.08463 .1016 L
.08464 .06633 L
.08465 .08519 L
.08467 .08876 L
.08468 .09174 L
.0847 .06616 L
.08471 .10993 L
.08472 .121 L
.08474 .10885 L
.08475 .0969 L
.08477 .08349 L
.08478 .08164 L
.08479 .10335 L
.08481 .12875 L
.08482 .11326 L
.08483 .11006 L
Mistroke
.08485 .09777 L
.08486 .11418 L
.08488 .08212 L
.08489 .07318 L
.0849 .11455 L
.08492 .10345 L
.08493 .11497 L
.08494 .11017 L
.08495 .11278 L
.08496 .09352 L
.08498 .11566 L
.08499 .12513 L
.08501 .06977 L
.08502 .11447 L
.08503 .09159 L
.08504 .08917 L
.08506 .1012 L
.08507 .06268 L
.08509 .08403 L
.0851 .0716 L
.08511 .09296 L
.08512 .09056 L
.08513 .10308 L
.08515 .11788 L
.08516 .12114 L
.08516 .07817 L
.08518 .12103 L
.08519 .10079 L
.0852 .08262 L
.0852 .11483 L
.08521 .12257 L
.08523 .10954 L
.08524 .12439 L
.08525 .11781 L
.08526 .10679 L
.08528 .07545 L
.08529 .1184 L
.0853 .09021 L
.08532 .09382 L
.08533 .12739 L
.08534 .11034 L
.08535 .13068 L
.08537 .10707 L
.08538 .12546 L
.08539 .14196 L
.0854 .09859 L
.08541 .07965 L
.08543 .09895 L
.08544 .07374 L
.08546 .08496 L
Mistroke
.08546 .08896 L
.08547 .12979 L
.08548 .11543 L
.08549 .1079 L
.0855 .09883 L
.08552 .09707 L
.08553 .09678 L
.08554 .09412 L
.08555 .0629 L
.08556 .09434 L
.08557 .07705 L
.08558 .07574 L
.08559 .07469 L
.0856 .07813 L
.08561 .08924 L
.08562 .0943 L
.08564 .04708 L
.08565 .12214 L
.08566 .13619 L
.08567 .08359 L
.08568 .11681 L
.08569 .08563 L
.0857 .10196 L
.08571 .09864 L
.08571 .07318 L
.08573 .05596 L
.08574 .09638 L
.08576 .0948 L
.08577 .06165 L
.08578 .09082 L
.08579 .14176 L
.0858 .12575 L
.08582 .13377 L
.08583 .09346 L
.08584 .09393 L
.08585 .06333 L
.08586 .13976 L
.08588 .12389 L
.08589 .07767 L
.0859 .08619 L
.08592 .09774 L
.08593 .1133 L
.08594 .06662 L
.08596 .10556 L
.08597 .0861 L
.08598 .0521 L
.08599 .08611 L
.086 .08259 L
.08601 .10431 L
.08602 .12 L
Mistroke
.08604 .08763 L
.08605 .12145 L
.08607 .12155 L
.08608 .11841 L
.08609 .13465 L
.08611 .07749 L
.08612 .11276 L
.08613 .10097 L
.08615 .08553 L
.08616 .06483 L
.08617 .11184 L
.08619 .09262 L
.0862 .07563 L
.08621 .09857 L
.08623 .08479 L
.08624 .13576 L
.08626 .13401 L
.08627 .10975 L
.08629 .11908 L
.0863 .09923 L
.08632 .12514 L
.08633 .05917 L
.08633 .07622 L
.08634 .10578 L
.08635 .09487 L
.08637 .10612 L
.08638 .14636 L
.08639 .13046 L
.0864 .10052 L
.08641 .1606 L
.08643 .13227 L
.08644 .12156 L
.08645 .06896 L
.08647 .05808 L
.08648 .1121 L
.0865 .07949 L
.08651 .12693 L
.08652 .0914 L
.08654 .13348 L
.08655 .08298 L
.08656 .08153 L
.08657 .12098 L
.08659 .09298 L
.0866 .06435 L
.08662 .09166 L
.08663 .09787 L
.08664 .12093 L
.08665 .14953 L
.08666 .05078 L
.08668 .10102 L
Mistroke
.08668 .10198 L
.08669 .07838 L
.0867 .05809 L
.08671 .12409 L
.08672 .11276 L
.08673 .10176 L
.08674 .10922 L
.08674 .10387 L
.08676 .11489 L
.08677 .09257 L
.08679 .09795 L
.0868 .10473 L
.08681 .07979 L
.08682 .07956 L
.08683 .12371 L
.08685 .07704 L
.08686 .12927 L
.08687 .07883 L
.08689 .07728 L
.0869 .05777 L
.08691 .09617 L
.08692 .09054 L
.08695 .07282 L
.08697 .11707 L
.08698 .05735 L
.087 .11975 L
.08701 .07909 L
.08702 .10387 L
.08704 .14801 L
.08705 .08986 L
.08707 .12155 L
.08708 .13921 L
.08709 .13022 L
.0871 .12996 L
.08712 .12938 L
.08713 .11582 L
.08714 .06647 L
.08716 .10447 L
.08717 .10945 L
.08719 .08352 L
.08719 .09338 L
.0872 .12075 L
.08722 .10831 L
.08723 .07736 L
.08725 .10778 L
.08725 .12261 L
.08726 .11404 L
.08728 .13654 L
.08729 .1181 L
.0873 .08554 L
Mistroke
.08732 .11568 L
.08733 .02997 L
.08734 .07423 L
.08736 .09811 L
.08737 .11658 L
.08738 .10989 L
.08739 .09684 L
.08741 .08775 L
.08742 .07012 L
.08744 .11992 L
.08745 .09404 L
.08747 .09664 L
.08748 .11768 L
.08749 .11659 L
.08751 .12613 L
.08752 .08997 L
.08754 .15325 L
.08755 .07041 L
.08757 .04996 L
.08758 .10467 L
.08759 .09985 L
.08761 .09221 L
.08762 .1032 L
.08764 .07333 L
.08765 .06892 L
.08766 .09443 L
.08767 .08728 L
.08769 .06086 L
.0877 .12131 L
.08771 .06345 L
.08772 .10388 L
.08773 .12858 L
.08775 .11889 L
.08776 .112 L
.08777 .08417 L
.08779 .10557 L
.0878 .065 L
.08782 .07176 L
.08783 .0774 L
.08783 .07885 L
.08784 .10546 L
.08785 .1236 L
.08787 .11676 L
.08788 .14394 L
.0879 .12134 L
.08791 .11508 L
.08792 .07515 L
.08794 .12924 L
.08795 .13249 L
.08797 .07312 L
Mistroke
.08798 .06746 L
.08799 .13766 L
.08801 .11064 L
.08802 .11233 L
.08804 .0928 L
.08805 .07158 L
.08806 .11557 L
.08808 .123 L
.08809 .13446 L
.0881 .0864 L
.08812 .14413 L
.08813 .1112 L
.08814 .13082 L
.08816 .11513 L
.08817 .08952 L
.08818 .05624 L
.08819 .05139 L
.0882 .04476 L
.08821 .08618 L
.08822 .09733 L
.08824 .11499 L
.08824 .1216 L
.08825 .1056 L
.08827 .06384 L
.08828 .13062 L
.0883 .13285 L
.08831 .13886 L
.08833 .11326 L
.08834 .10819 L
.08835 .10412 L
.08837 .10264 L
.08838 .07965 L
.0884 .08811 L
.08841 .10045 L
.08842 .09833 L
.08843 .08543 L
.08844 .12011 L
.08846 .13702 L
.08847 .06982 L
.08848 .1 L
.0885 .08972 L
.08851 .09346 L
.08852 .11008 L
.08853 .07781 L
.08854 .07363 L
.08855 .14549 L
.08856 .13987 L
.08857 .11067 L
.08858 .10472 L
.08858 .06775 L
Mistroke
.08859 .05115 L
.0886 .10447 L
.08862 .09706 L
.08863 .07844 L
.08865 .12085 L
.08865 .12298 L
.08866 .09629 L
.08868 .08047 L
.08869 .11444 L
.0887 .10502 L
.08872 .10537 L
.08873 .07736 L
.08874 .06957 L
.08876 .06448 L
.08877 .07164 L
.08878 .08377 L
.08879 .09215 L
.0888 .11629 L
.08881 .09772 L
.08882 .12422 L
.08884 .10164 L
.08885 .13352 L
.08887 .08355 L
.08888 .09171 L
.08889 .08772 L
.08891 .07723 L
.08892 .11192 L
.08893 .10994 L
.08895 .07907 L
.08896 .09491 L
.08897 .08721 L
.08899 .09517 L
.089 .05227 L
.08901 .09839 L
.08903 .09036 L
.08904 .1459 L
.08906 .09311 L
.08907 .07897 L
.08909 .12132 L
.0891 .10727 L
.08912 .06398 L
.08912 .08217 L
.08913 .08788 L
.08914 .10592 L
.08915 .12927 L
.08916 .08186 L
.08918 .08291 L
.08919 .07949 L
.08921 .10718 L
.08922 .05918 L
Mistroke
.08924 .09011 L
.08925 .12032 L
.08926 .08426 L
.08928 .09421 L
.08929 .11893 L
.08931 .10921 L
.08932 .05894 L
.08934 .07705 L
.08935 .10382 L
.08937 .10321 L
.08938 .10409 L
.08939 .07561 L
.0894 .11287 L
.08941 .06542 L
.08943 .10086 L
.08944 .10654 L
.08944 .12725 L
.08945 .06199 L
.08946 .10145 L
.08948 .09293 L
.08948 .10857 L
.08949 .07841 L
.0895 .07446 L
.08951 .10946 L
.08952 .11873 L
.08953 .0752 L
.08953 .09194 L
.08954 .09496 L
.08956 .06494 L
.08957 .10556 L
.08959 .09424 L
.0896 .09116 L
.08962 .11867 L
.08963 .06786 L
.08964 .0984 L
.08966 .11856 L
.08966 .12106 L
.08967 .1143 L
.08969 .10563 L
.0897 .06308 L
.08972 .12421 L
.08973 .06174 L
.08974 .07342 L
.08976 .10653 L
.08977 .07404 L
.08978 .11157 L
.0898 .06311 L
.08981 .05596 L
.08983 .11627 L
.08983 .12394 L
Mistroke
.08984 .09603 L
.08986 .09687 L
.08987 .12659 L
.08989 .10894 L
.0899 .07183 L
.08992 .09711 L
.08992 .10788 L
.08993 .10332 L
.08995 .10961 L
.08996 .0845 L
.08996 .12873 L
.08997 .07575 L
.08998 .1134 L
.09 .0819 L
.09001 .092 L
.09003 .09209 L
.09004 .08702 L
.09004 .05596 L
.09006 .10596 L
.09007 .10081 L
.09009 .09497 L
.0901 .10705 L
.09012 .08739 L
.09013 .09459 L
.09013 .09193 L
.09015 .112 L
.09016 .09149 L
.09018 .07468 L
.09019 .09878 L
.0902 .08795 L
.09022 .06725 L
.09023 .0834 L
.09025 .10439 L
.09026 .08899 L
.09027 .07154 L
.09029 .117 L
.0903 .08439 L
.09031 .1102 L
.09032 .06927 L
.09033 .0879 L
.09034 .13595 L
.09035 .11905 L
.09037 .0922 L
.09038 .12267 L
.09038 .08579 L
.09039 .10784 L
.0904 .06814 L
.09042 .07818 L
.09043 .08433 L
.09045 .10409 L
Mistroke
.09046 .1088 L
.09047 .08798 L
.09048 .08365 L
.09049 .11752 L
.09051 .10872 L
.09052 .09132 L
.09054 .10926 L
.09055 .09324 L
.09057 .09508 L
.09058 .0777 L
.09059 .0919 L
.09061 .10703 L
.09062 .08045 L
.09063 .10103 L
.09065 .07185 L
.09066 .08609 L
.09068 .08674 L
.09069 .10712 L
.09071 .06041 L
.09072 .09339 L
.09073 .07442 L
.09074 .0748 L
.09076 .10281 L
.09077 .12255 L
.09078 .11584 L
.0908 .05092 L
.09081 .10576 L
.09082 .07502 L
.09083 .08489 L
.09085 .07402 L
.09086 .06557 L
.09087 .06993 L
.09089 .09602 L
.0909 .14311 L
.09092 .13929 L
.09092 .10618 L
.09093 .03148 L
.09095 .09526 L
.09096 .06292 L
.09097 .13098 L
.09099 .0649 L
.091 .10653 L
.09102 .13166 L
.09103 .10013 L
.09105 .12861 L
.09106 .13715 L
.09107 .08132 L
.09109 .07168 L
.0911 .12464 L
.09112 .08194 L
Mistroke
.09113 .11319 L
.09115 .08479 L
.09116 .08946 L
.09117 .06973 L
.09118 .12239 L
.09119 .08384 L
.09121 .06892 L
.09122 .08606 L
.09124 .07689 L
.09125 .07654 L
.09126 .08289 L
.09128 .08078 L
.09129 .11549 L
.0913 .11037 L
.09131 .12332 L
.09133 .07355 L
.09134 .13073 L
.09136 .10715 L
.09137 .09433 L
.09138 .08338 L
.09139 .05511 L
.0914 .15139 L
.09141 .09386 L
.09143 .06785 L
.09144 .06424 L
.09146 .08159 L
.09147 .11327 L
.09149 .07642 L
.0915 .11264 L
.09151 .12024 L
.09153 .10426 L
.09154 .12636 L
.09156 .09412 L
.09157 .08062 L
.09158 .07193 L
.0916 .12422 L
.09162 .10784 L
.09162 .09614 L
.09163 .12309 L
.09165 .13054 L
.09166 .08262 L
.09168 .11036 L
.09169 .11466 L
.0917 .11019 L
.09172 .12451 L
.09173 .13053 L
.09174 .08862 L
.09176 .07136 L
.09177 .12182 L
.09178 .06676 L
Mistroke
.0918 .09399 L
.09181 .0962 L
.09182 .06745 L
.09184 .12926 L
.09185 .09979 L
.09185 .07671 L
.09187 .10579 L
.09188 .08223 L
.0919 .09046 L
.09191 .08102 L
.09193 .09293 L
.09194 .1037 L
.09196 .0612 L
.09197 .10073 L
.09198 .12343 L
.092 .09139 L
.09201 .06997 L
.09203 .11933 L
.09204 .11641 L
.09205 .08334 L
.09207 .0827 L
.09208 .05739 L
.09209 .08402 L
.0921 .09233 L
.09212 .11582 L
.09213 .1053 L
.09214 .08456 L
.09216 .08864 L
.09217 .1028 L
.09218 .09613 L
.0922 .06114 L
.09221 .08563 L
.09222 .09606 L
.09224 .10479 L
.09225 .09695 L
.09226 .10912 L
.09228 .11569 L
.09229 .10011 L
.0923 .09041 L
.09231 .07247 L
.09232 .08177 L
.09234 .11589 L
.09235 .09239 L
.09237 .11085 L
.09238 .10987 L
.0924 .11585 L
.09241 .10279 L
.09242 .0727 L
.09244 .11413 L
.09245 .10571 L
Mistroke
.09247 .07289 L
.09248 .10771 L
.09249 .05516 L
.09251 .07599 L
.09252 .09921 L
.09253 .08314 L
.09253 .09713 L
.09254 .04879 L
.09256 .11842 L
.09257 .10246 L
.09259 .12032 L
.0926 .12891 L
.09261 .06929 L
.09263 .11385 L
.09264 .15226 L
.09266 .0919 L
.09267 .09146 L
.09269 .10402 L
.0927 .0779 L
.09271 .07897 L
.09273 .09779 L
.09274 .08502 L
.09275 .0889 L
.09277 .10964 L
.09278 .08712 L
.09279 .06637 L
.09281 .10454 L
.09282 .10203 L
.09282 .09607 L
.09284 .0806 L
.09285 .12151 L
.09287 .12232 L
.09288 .08363 L
.09289 .10543 L
.09291 .083 L
.09292 .11632 L
.09293 .04127 L
.09294 .14437 L
.09295 .0762 L
.09295 .11718 L
.09297 .09976 L
.09298 .07808 L
.093 .07176 L
.09301 .06097 L
.09303 .12061 L
.09304 .12273 L
.09305 .11178 L
.09308 .09439 L
.09309 .08351 L
.09311 .12383 L
Mistroke
.09312 .11818 L
.09314 .11626 L
.09319 .10222 L
.0932 .12096 L
.09322 .09268 L
.09323 .08012 L
.09325 .10072 L
.09326 .0922 L
.09326 .0748 L
.09327 .09901 L
.09328 .09845 L
.09329 .12124 L
.0933 .12787 L
.09331 .09625 L
.09333 .11868 L
.09334 .10281 L
.09335 .12081 L
.09336 .08048 L
.09337 .08979 L
.09339 .09379 L
.0934 .09894 L
.09342 .09473 L
.09343 .10062 L
.09345 .09185 L
.09346 .08859 L
.09347 .12127 L
.09349 .13454 L
.0935 .11795 L
.09351 .08396 L
.09352 .12141 L
.09353 .09821 L
.09354 .11208 L
.09355 .0754 L
.09356 .11563 L
.09358 .09599 L
.09359 .09484 L
.09361 .07792 L
.09362 .08989 L
.09364 .10813 L
.09364 .11917 L
.09365 .08662 L
.09366 .1033 L
.09367 .11415 L
.09368 .14068 L
.09369 .07861 L
.0937 .10316 L
.09371 .09659 L
.09372 .11538 L
.09373 .07854 L
.09374 .11482 L
Mistroke
.09375 .13435 L
.09377 .09785 L
.09378 .12117 L
.0938 .09009 L
.09381 .08418 L
.09382 .05033 L
.09384 .06424 L
.09385 .06109 L
.09386 .11312 L
.09387 .15817 L
.09388 .08429 L
.09388 .08792 L
.0939 .11366 L
.09391 .03964 L
.09392 .06976 L
.09393 .08207 L
.09394 .12083 L
.09396 .13321 L
.09398 .08206 L
.09399 .09302 L
.094 .1067 L
.09401 .13321 L
.09402 .07205 L
.09403 .06916 L
.09404 .10356 L
.09405 .09827 L
.09407 .07708 L
.09408 .09916 L
.0941 .06193 L
.0941 .10985 L
.09411 .09919 L
.09412 .09241 L
.09413 .11151 L
.09414 .05035 L
.09416 .07515 L
.09417 .13195 L
.09418 .11273 L
.09419 .10852 L
.0942 .10565 L
.09421 .11798 L
.09422 .07408 L
.09423 .11057 L
.09424 .09038 L
.09424 .08114 L
.09426 .09355 L
.09427 .06155 L
.09428 .08613 L
.09429 .08626 L
.09431 .07275 L
.09432 .08798 L
Mistroke
.09433 .12219 L
.09434 .10608 L
.09435 .07783 L
.09437 .11291 L
.09438 .06302 L
.0944 .15504 L
.09441 .10215 L
.09442 .06929 L
.09444 .09203 L
.09445 .08531 L
.09446 .07639 L
.09448 .0936 L
.0945 .08458 L
.0945 .09462 L
.09451 .07177 L
.09453 .08581 L
.09454 .11794 L
.09456 .10413 L
.09457 .09868 L
.09459 .08073 L
.0946 .10412 L
.09461 .03792 L
.09462 .09455 L
.09463 .08805 L
.09465 .13548 L
.09466 .09096 L
.09467 .06958 L
.09468 .09396 L
.09468 .09191 L
.09469 .07772 L
.0947 .14098 L
.09471 .10123 L
.09472 .0989 L
.09475 .08927 L
.09476 .09431 L
.09478 .08202 L
.09479 .10574 L
.0948 .10355 L
.09482 .08663 L
.09483 .12261 L
.09484 .10376 L
.09485 .10837 L
.09486 .11151 L
.09488 .09982 L
.09489 .12525 L
.09489 .09482 L
.09491 .08901 L
.09492 .07803 L
.09494 .10168 L
.09495 .14348 L
Mistroke
.09497 .06557 L
.09498 .09935 L
.095 .08078 L
.09501 .121 L
.09502 .0707 L
.09503 .08571 L
.09505 .11741 L
.09506 .11813 L
.09507 .08623 L
.09509 .07463 L
.0951 .09512 L
.09511 .09447 L
.09512 .11955 L
.09513 .12024 L
.09515 .07815 L
.09516 .12039 L
.09517 .07456 L
.09519 .10807 L
.0952 .08698 L
.09521 .07101 L
.09522 .08885 L
.09523 .05837 L
.09525 .07838 L
.09526 .13133 L
.09527 .11766 L
.09529 .08417 L
.09531 .04399 L
.09531 .12899 L
.09532 .1098 L
.09534 .09419 L
.09534 .09451 L
.09535 .13094 L
.09537 .11379 L
.09538 .06874 L
.0954 .11211 L
.09541 .13159 L
.09542 .07223 L
.09544 .08368 L
.09545 .1152 L
.09546 .05638 L
.09548 .09636 L
.09549 .09945 L
.09551 .06454 L
.09552 .11312 L
.09553 .09047 L
.09555 .09215 L
.09556 .07234 L
.09557 .11006 L
.09559 .11045 L
.0956 .08576 L
Mistroke
.09562 .09909 L
.09563 .07624 L
.09564 .14325 L
.09565 .10908 L
.09566 .0993 L
.09568 .11695 L
.09569 .11499 L
.0957 .11 L
.09573 .09494 L
.09573 .1274 L
.09574 .08893 L
.09576 .10045 L
.09577 .06897 L
.09578 .0765 L
.0958 .0575 L
.09581 .10546 L
.09582 .11837 L
.09584 .08426 L
.09586 .14093 L
.09587 .10523 L
.09588 .0643 L
.0959 .12597 L
.09591 .08371 L
.09593 .1002 L
.09594 .09055 L
.09595 .1008 L
.09596 .10844 L
.09598 .06976 L
.09598 .05392 L
.09599 .1239 L
.096 .11202 L
.09601 .07818 L
.09602 .08576 L
.09603 .08909 L
.09604 .11847 L
.09605 .11987 L
.09606 .11689 L
.09607 .11829 L
.09608 .10373 L
.09609 .05933 L
.09611 .09932 L
.09612 .10767 L
.09614 .06696 L
.09615 .07228 L
.09616 .11405 L
.09618 .08665 L
.09619 .08285 L
.0962 .12655 L
.09621 .06766 L
.09622 .10921 L
Mistroke
.09624 .0812 L
.09625 .12954 L
.09627 .07919 L
.09628 .13688 L
.09629 .08517 L
.0963 .06048 L
.09632 .08769 L
.09633 .07688 L
.09635 .11448 L
.09636 .08102 L
.09637 .09261 L
.09638 .08749 L
.09639 .0946 L
.09641 .03674 L
.09642 .11785 L
.09643 .10426 L
.09644 .0749 L
.09645 .07049 L
.09646 .1148 L
.09647 .08959 L
.09648 .06703 L
.09649 .08815 L
.0965 .09447 L
.09652 .12211 L
.09653 .10122 L
.09655 .12226 L
.09656 .12875 L
.09656 .10543 L
.09658 .04639 L
.09659 .09087 L
.0966 .12017 L
.09661 .1097 L
.09662 .07263 L
.09664 .07983 L
.09665 .11492 L
.09666 .1005 L
.09667 .05234 L
.09669 .10955 L
.0967 .09561 L
.09672 .12318 L
.09673 .05574 L
.09674 .12069 L
.09676 .09005 L
.09677 .04851 L
.09678 .11556 L
.0968 .10425 L
.09681 .06565 L
.09683 .10022 L
.09683 .07688 L
.09684 .08017 L
Mistroke
.09686 .12234 L
.09687 .08647 L
.09689 .07932 L
.0969 .08952 L
.09691 .11745 L
.09692 .1097 L
.09693 .09047 L
.09694 .07969 L
.09695 .10806 L
.09695 .11006 L
.09697 .07796 L
.09698 .08094 L
.097 .109 L
.09701 .14401 L
.09703 .09736 L
.09704 .06474 L
.09704 .1314 L
.09706 .11079 L
.09708 .12506 L
.09709 .08326 L
.09711 .0964 L
.09712 .08071 L
.09713 .06507 L
.09715 .08143 L
.09716 .10864 L
.09718 .09601 L
.09719 .09615 L
.0972 .11261 L
.09722 .07476 L
.09723 .06145 L
.09725 .11417 L
.09726 .12266 L
.09727 .08141 L
.09728 .11277 L
.0973 .11552 L
.09731 .08855 L
.09732 .10282 L
.09734 .12489 L
.09735 .14628 L
.09737 .09907 L
.09738 .09925 L
.09739 .13783 L
.0974 .12732 L
.09742 .09438 L
.09743 .06148 L
.09744 .10887 L
.09746 .11415 L
.09747 .03792 L
.09749 .08401 L
.09749 .08992 L
Mistroke
.0975 .11347 L
.09752 .08166 L
.09753 .11249 L
.09755 .14682 L
.09755 .07882 L
.09756 .10975 L
.09758 .11568 L
.09759 .10487 L
.0976 .11095 L
.09762 .12301 L
.09763 .14117 L
.09764 .10664 L
.09766 .0934 L
.09767 .10898 L
.09768 .10175 L
.09769 .10547 L
.0977 .11815 L
.09771 .1017 L
.09772 .12028 L
.09774 .09532 L
.09775 .08893 L
.09777 .10457 L
.09778 .11408 L
.09779 .10761 L
.09781 .06901 L
.09782 .1311 L
.09783 .10586 L
.09785 .10582 L
.09786 .09474 L
.09787 .09454 L
.09789 .13041 L
.0979 .09035 L
.09791 .08298 L
.09793 .11632 L
.09794 .05703 L
.09796 .1071 L
.09797 .0843 L
.09799 .05889 L
.098 .09412 L
.09802 .0725 L
.09802 .10727 L
.09803 .10195 L
.09804 .12633 L
.09805 .08868 L
.09806 .11236 L
.09807 .10603 L
.09808 .09038 L
.09809 .11782 L
.09811 .11548 L
.09812 .08053 L
Mistroke
.09814 .07653 L
.09815 .10479 L
.09817 .08295 L
.09818 .10946 L
.09819 .09578 L
.09821 .09497 L
.09822 .10779 L
.09824 .10677 L
.09825 .09093 L
.09827 .08475 L
.09828 .11676 L
.09828 .05945 L
.0983 .1292 L
.09831 .09504 L
.09833 .10213 L
.09834 .10819 L
.09835 .1043 L
.09836 .11909 L
.09837 .06861 L
.09838 .1133 L
.09839 .12013 L
.0984 .09469 L
.09841 .08805 L
.09842 .11028 L
.09843 .1006 L
.09843 .08656 L
.09844 .11884 L
.09846 .08073 L
.09847 .11057 L
.09849 .08649 L
.0985 .12545 L
.09852 .09151 L
.09853 .12892 L
.09855 .09704 L
.09856 .1014 L
.09857 .09649 L
.09859 .07471 L
.0986 .10065 L
.09862 .0778 L
.09863 .12491 L
.09864 .09639 L
.09866 .10035 L
.09867 .05955 L
.09868 .08054 L
.09869 .09672 L
.09871 .11879 L
.09872 .10122 L
.09873 .09044 L
.09875 .07977 L
.09876 .08929 L
Mistroke
.09877 .09547 L
.09879 .13833 L
.0988 .08653 L
.09881 .11078 L
.09883 .09349 L
.09884 .12999 L
.09885 .0492 L
.09887 .10071 L
.09888 .11762 L
.09889 .14599 L
.0989 .09345 L
.09891 .05751 L
.09893 .10615 L
.09894 .09353 L
.09896 .09095 L
.09897 .09071 L
.09899 .10263 L
.099 .11883 L
.09901 .08297 L
.09903 .09979 L
.09904 .10167 L
.09906 .10898 L
.09907 .11386 L
.09908 .10262 L
.0991 .1134 L
.09911 .07866 L
.09912 .1408 L
.09913 .1085 L
.09915 .13495 L
.09916 .07969 L
.09917 .17379 L
.09919 .09597 L
.0992 .10293 L
.09922 .08702 L
.09923 .08622 L
.09924 .11029 L
.09925 .11177 L
.09927 .11424 L
.09928 .08041 L
.0993 .0921 L
.09931 .08117 L
.09932 .13319 L
.09934 .09808 L
.09935 .10715 L
.09935 .09773 L
.09937 .09643 L
.09938 .10594 L
.0994 .12095 L
.09941 .13277 L
.09941 .09462 L
Mistroke
.09943 .1218 L
.09944 .08944 L
.09945 .11243 L
.09947 .09431 L
.09948 .11162 L
.0995 .12263 L
.09951 .10048 L
.09952 .1145 L
.09953 .12053 L
.09954 .0812 L
.09955 .11429 L
.09956 .13238 L
.09957 .09516 L
.09959 .08907 L
.0996 .07528 L
.09962 .08673 L
.09963 .1274 L
.09964 .05977 L
.09966 .0864 L
.09967 .06906 L
.09968 .11974 L
.0997 .10634 L
.09971 .07547 L
.09972 .09479 L
.09974 .11611 L
.09975 .08336 L
.09977 .11163 L
.09978 .07218 L
.09979 .13726 L
.09981 .07631 L
.09982 .08598 L
.09984 .09764 L
.09985 .09395 L
.09987 .07758 L
.09988 .09923 L
.09988 .11309 L
.09989 .10986 L
.0999 .11147 L
.09992 .07499 L
.09993 .06339 L
.09994 .11224 L
.09996 .11028 L
.09997 .09147 L
.09999 .13655 L
.1 .09718 L
.10001 .05754 L
.10003 .10582 L
.10004 .09827 L
.10006 .08479 L
.10007 .08628 L
Mistroke
.10009 .08672 L
.1001 .11946 L
.10011 .12567 L
.10012 .1131 L
.10014 .07587 L
.10014 .08619 L
.10015 .11758 L
.10017 .08235 L
.10018 .08399 L
.10018 .1041 L
.10019 .10495 L
.1002 .07542 L
.10022 .07396 L
.10023 .11013 L
.10023 .09354 L
.10025 .08214 L
.10026 .08613 L
.10027 .13564 L
.10028 .09701 L
.1003 .07131 L
.10031 .11073 L
.10032 .15318 L
.10034 .08866 L
.10035 .0784 L
.10037 .12817 L
.10038 .12082 L
.10039 .091 L
.1004 .1287 L
.10041 .11345 L
.10043 .08709 L
.10044 .13957 L
.10045 .07642 L
.10047 .10062 L
.10048 .04992 L
.10049 .08455 L
.10051 .06239 L
.10052 .13983 L
.10054 .09818 L
.10055 .14165 L
.10056 .08535 L
.10057 .10348 L
.10058 .07793 L
.1006 .08271 L
.10061 .10033 L
.10063 .11343 L
.10063 .13462 L
.10064 .13461 L
.10065 .08677 L
.10066 .06815 L
.10067 .11529 L
Mistroke
.10068 .12268 L
.10069 .08556 L
.1007 .08458 L
.10071 .09593 L
.10072 .08395 L
.10074 .11189 L
.10075 .09958 L
.10077 .06402 L
.10078 .05101 L
.1008 .11233 L
.1008 .10966 L
.10081 .1036 L
.10083 .04993 L
.10084 .10648 L
.10085 .08896 L
.10086 .1272 L
.10087 .07294 L
.10089 .07302 L
.1009 .08091 L
.10092 .10174 L
.10093 .06691 L
.10094 .06358 L
.10094 .09825 L
.10095 .10823 L
.10097 .04567 L
.10098 .08787 L
.10099 .14176 L
.101 .10399 L
.10101 .07864 L
.10102 .12213 L
.10103 .07861 L
.10104 .11159 L
.10105 .08142 L
.10106 .11961 L
.10107 .07346 L
.10108 .09789 L
.1011 .08929 L
.10111 .10591 L
.10113 .09998 L
.10113 .09546 L
.10114 .12001 L
.10115 .08763 L
.10116 .10993 L
.10117 .10008 L
.10118 .12904 L
.10119 .14289 L
.1012 .11231 L
.10122 .16055 L
.10123 .11652 L
.10125 .07614 L
Mistroke
.10125 .07605 L
.10126 .11564 L
.10128 .03447 L
.10129 .12065 L
.10131 .09413 L
.10131 .06998 L
.10132 .06933 L
.10134 .14571 L
.10135 .0956 L
.10137 .11729 L
.10138 .11332 L
.10139 .0925 L
.10141 .09759 L
.10142 .10472 L
.10143 .11528 L
.10144 .13753 L
.10145 .09862 L
.10146 .08394 L
.10147 .0894 L
.10148 .08088 L
.1015 .09508 L
.10152 .07699 L
.10153 .08376 L
.10154 .11278 L
.10156 .06305 L
.10157 .11917 L
.10158 .09711 L
.1016 .1052 L
.10161 .12105 L
.10162 .11541 L
.10164 .12503 L
.10165 .06786 L
.10166 .11427 L
.10168 .11073 L
.10169 .10341 L
.10171 .08525 L
.10172 .09641 L
.10173 .05878 L
.10175 .12608 L
.10176 .12104 L
.10177 .09529 L
.10178 .07849 L
.1018 .10714 L
.1018 .13884 L
.10181 .09222 L
.10183 .08401 L
.10184 .10018 L
.10185 .10265 L
.10186 .11695 L
.10187 .11243 L
Mistroke
.10189 .08027 L
.1019 .10702 L
.10192 .08524 L
.10193 .10399 L
.10194 .11237 L
.10196 .10611 L
.10197 .09562 L
.10198 .1014 L
.102 .10796 L
.10202 .08261 L
.10202 .09838 L
.10203 .1178 L
.10205 .14753 L
.10206 .06204 L
.10208 .10452 L
.10209 .08146 L
.10211 .09542 L
.10211 .09127 L
.10212 .11441 L
.10214 .08532 L
.10215 .12993 L
.10215 .11119 L
.10216 .09149 L
.10217 .08377 L
.10218 .0717 L
.10219 .11798 L
.1022 .11235 L
.10221 .10499 L
.10222 .07857 L
.10224 .16044 L
.10225 .07702 L
.10226 .11002 L
.10227 .11793 L
.10228 .09799 L
.1023 .11722 L
.10231 .07411 L
.10232 .0788 L
.10234 .09449 L
.10235 .10919 L
.10236 .07693 L
.10237 .08915 L
.10238 .10202 L
.1024 .11415 L
.10241 .08628 L
.10241 .16236 L
.10243 .10455 L
.10244 .06745 L
.10246 .12139 L
.10247 .07825 L
.10249 .12986 L
Mistroke
.1025 .10341 L
.10251 .08355 L
.10252 .10886 L
.10254 .11103 L
.10255 .08023 L
.10257 .10303 L
.10258 .11861 L
.10259 .1039 L
.10261 .09178 L
.10262 .10169 L
.10263 .1429 L
.10265 .06731 L
.10266 .08245 L
.10268 .07138 L
.10269 .11382 L
.10271 .08734 L
.10271 .12189 L
.10272 .0388 L
.10274 .09107 L
.10275 .08026 L
.10277 .10626 L
.10278 .13124 L
.10279 .11164 L
.10281 .10371 L
.10282 .10765 L
.10283 .10531 L
.10285 .07644 L
.10286 .0891 L
.10287 .09685 L
.10288 .11262 L
.10289 .08964 L
.1029 .07824 L
.10291 .08744 L
.10293 .12074 L
.10294 .06896 L
.10295 .07968 L
.10297 .10361 L
.10298 .0818 L
.103 .10638 L
.10301 .14814 L
.10302 .04487 L
.10303 .09589 L
.10305 .08163 L
.10306 .11092 L
.10308 .13761 L
.10309 .10192 L
.1031 .10727 L
.10312 .08792 L
.10313 .05906 L
.10313 .10736 L
Mistroke
.10315 .11224 L
.10316 .07749 L
.10317 .07393 L
.10318 .08904 L
.1032 .10156 L
.1032 .11244 L
.10321 .08504 L
.10323 .0727 L
.10324 .09111 L
.10326 .10355 L
.10327 .0739 L
.10328 .06881 L
.10329 .09491 L
.1033 .09737 L
.10331 .08421 L
.10332 .08452 L
.10334 .08708 L
.10334 .11794 L
.10335 .1046 L
.10337 .0981 L
.10338 .11441 L
.10339 .09311 L
.1034 .08591 L
.1034 .12599 L
.10342 .12676 L
.10343 .1064 L
.10345 .11318 L
.10346 .06856 L
.10347 .08256 L
.10348 .07697 L
.10349 .10922 L
.1035 .10085 L
.10351 .10431 L
.10351 .09716 L
.10352 .09813 L
.10353 .04376 L
.10354 .12277 L
.10356 .07778 L
.10357 .12079 L
.10359 .11155 L
.1036 .05518 L
.10361 .06724 L
.10362 .10719 L
.10363 .11847 L
.10365 .11862 L
.10366 .15823 L
.10367 .09079 L
.10368 .10557 L
.10369 .08464 L
.10371 .0886 L
Mistroke
.10372 .10457 L
.10373 .13131 L
.10375 .12465 L
.10376 .09821 L
.10378 .08449 L
.10379 .12095 L
.1038 .07564 L
.10381 .13412 L
.10382 .0809 L
.10383 .08824 L
.10384 .09143 L
.10386 .09936 L
.10387 .10446 L
.10389 .08756 L
.1039 .09815 L
.10391 .08868 L
.10393 .12995 L
.10394 .09465 L
.10395 .07838 L
.10397 .12309 L
.10398 .09526 L
.104 .09646 L
.10401 .11079 L
.10402 .09386 L
.10404 .10463 L
.10405 .11155 L
.10407 .13272 L
.10408 .10098 L
.10409 .14601 L
.10411 .075 L
.10412 .1297 L
.10413 .09825 L
.10415 .04943 L
.10416 .107 L
.10418 .07815 L
.10419 .10728 L
.1042 .13727 L
.10422 .09583 L
.10423 .12397 L
.10423 .12441 L
.10424 .09457 L
.10425 .11028 L
.10427 .10776 L
.10428 .08134 L
.10428 .12766 L
.1043 .05471 L
.10431 .11664 L
.10433 .09879 L
.10434 .0857 L
.10435 .0732 L
Mistroke
.10436 .10064 L
.10437 .11149 L
.10438 .09322 L
.10439 .11619 L
.10441 .13562 L
.10442 .11539 L
.10443 .13262 L
.10445 .08684 L
.10446 .0911 L
.10448 .05524 L
.10449 .09852 L
.1045 .09273 L
.10451 .10301 L
.10453 .11183 L
.10454 .11926 L
.10454 .11851 L
.10455 .10955 L
.10456 .07699 L
.10457 .09835 L
.10458 .08785 L
.1046 .07273 L
.10461 .1463 L
.10462 .10226 L
.10463 .09826 L
.10464 .07237 L
.10466 .10331 L
.10467 .08083 L
.10468 .11909 L
.1047 .1045 L
.10471 .08714 L
.10473 .10366 L
.10474 .10846 L
.10474 .11256 L
.10476 .11114 L
.10477 .02577 L
.10477 .11556 L
.10479 .13299 L
.1048 .09916 L
.10482 .08352 L
.10483 .11309 L
.10485 .09213 L
.10486 .08714 L
.10487 .13339 L
.10488 .11348 L
.1049 .0952 L
.10491 .09275 L
.10493 .13771 L
.10494 .05826 L
.10495 .09718 L
.10497 .12956 L
Mistroke
.10498 .05836 L
.105 .09066 L
.10501 .09946 L
.10503 .14385 L
.10504 .1344 L
.10505 .13754 L
.10506 .08677 L
.10507 .09991 L
.10508 .06849 L
.1051 .11224 L
.10511 .10806 L
.10512 .11696 L
.10513 .07815 L
.10515 .11052 L
.10515 .14707 L
.10516 .12353 L
.10518 .10237 L
.10519 .11932 L
.10521 .06985 L
.10522 .13077 L
.10524 .11161 L
.10525 .0621 L
.10526 .1003 L
.10528 .10032 L
.10529 .10864 L
.10531 .06633 L
.10532 .12837 L
.10533 .13638 L
.10534 .07045 L
.10535 .10522 L
.10537 .0625 L
.10538 .06287 L
.1054 .08076 L
.10541 .09547 L
.10542 .05527 L
.10543 .10005 L
.10544 .08268 L
.10544 .12848 L
.10545 .10056 L
.10546 .10981 L
.10547 .07296 L
.10548 .09805 L
.10549 .1062 L
.1055 .10699 L
.10551 .12355 L
.10553 .09265 L
.10554 .0933 L
.10556 .09079 L
.10557 .07412 L
.10558 .09528 L
Mistroke
.10559 .10955 L
.1056 .08185 L
.10561 .05531 L
.10562 .12059 L
.10563 .07563 L
.10563 .12758 L
.10564 .07275 L
.10565 .08127 L
.10566 .10915 L
.10568 .06829 L
.10569 .08471 L
.1057 .09558 L
.10571 .10354 L
.10573 .11846 L
.10574 .13327 L
.10575 .07239 L
.10577 .07461 L
.10578 .11923 L
.1058 .11266 L
.10581 .06645 L
.10582 .10538 L
.10584 .0895 L
.10585 .11545 L
.10587 .09648 L
.10588 .12993 L
.10589 .076 L
.10591 .13537 L
.10592 .13537 L
.10594 .08705 L
.10595 .09746 L
.10596 .11106 L
.10597 .09548 L
.10599 .05855 L
.106 .11163 L
.10601 .04999 L
.10603 .10656 L
.10604 .09601 L
.10606 .07353 L
.10607 .07988 L
.10608 .11459 L
.1061 .13697 L
.10611 .07875 L
.10613 .10072 L
.10614 .11501 L
.10616 .07384 L
.10617 .09146 L
.10618 .06239 L
.10619 .11715 L
.1062 .08724 L
.10622 .13451 L
Mistroke
.10623 .08812 L
.10625 .10034 L
.10626 .09606 L
.10627 .14504 L
.10628 .09034 L
.10629 .09939 L
.10631 .10059 L
.10632 .08549 L
.10634 .09365 L
.10635 .09877 L
.10636 .08202 L
.10637 .10121 L
.10639 .12322 L
.10639 .07444 L
.1064 .08782 L
.10641 .1175 L
.10642 .07256 L
.10643 .08915 L
.10644 .09792 L
.10645 .04798 L
.10645 .09278 L
.10647 .078 L
.10648 .08846 L
.1065 .09906 L
.10651 .09973 L
.10653 .12877 L
.10654 .1197 L
.10656 .09384 L
.10657 .10017 L
.10658 .07059 L
.1066 .10182 L
.10661 .0903 L
.10663 .12379 L
.10664 .08439 L
.10666 .11179 L
.10667 .11657 L
.10668 .07483 L
.10669 .10519 L
.1067 .06396 L
.10672 .08289 L
.10673 .11072 L
.10675 .10179 L
.10676 .09805 L
.10677 .09489 L
.10679 .09871 L
.1068 .0995 L
.10681 .09274 L
.10682 .08674 L
.10684 .05341 L
.10685 .07617 L
Mistroke
.10687 .09022 L
.10688 .09759 L
.10689 .11321 L
.10691 .07877 L
.10692 .07944 L
.10692 .10212 L
.10694 .12922 L
.10695 .0995 L
.10697 .09522 L
.10698 .10149 L
.107 .10289 L
.10701 .0657 L
.10703 .16387 L
.10704 .08738 L
.10704 .12963 L
.10706 .09657 L
.10707 .11674 L
.10709 .14231 L
.1071 .11572 L
.10712 .08146 L
.10713 .07365 L
.10714 .10179 L
.10716 .10256 L
.10717 .08202 L
.10718 .08281 L
.1072 .08754 L
.10721 .07098 L
.10722 .11591 L
.10723 .13267 L
.10725 .11513 L
.10726 .1176 L
.10728 .10518 L
.10729 .11115 L
.10732 .12752 L
.10733 .05713 L
.10734 .13424 L
.10735 .10926 L
.10736 .13772 L
.10737 .10969 L
.10738 .14647 L
.10739 .0966 L
.10741 .10186 L
.10742 .09637 L
.10744 .07566 L
.10744 .10103 L
.10745 .11419 L
.10747 .08801 L
.10748 .08247 L
.10749 .08242 L
.1075 .11331 L
Mistroke
.10751 .08145 L
.10752 .12378 L
.10753 .10541 L
.10754 .08766 L
.10755 .13665 L
.10756 .05745 L
.10757 .10792 L
.10758 .10189 L
.10759 .0945 L
.10761 .1189 L
.10762 .10157 L
.10764 .09623 L
.10765 .1095 L
.10767 .07949 L
.10768 .08041 L
.10769 .1025 L
.10771 .07672 L
.10772 .09069 L
.10773 .07286 L
.10775 .11242 L
.10776 .07559 L
.10777 .10418 L
.10779 .08751 L
.1078 .10434 L
.10781 .08352 L
.10782 .11973 L
.10783 .11489 L
.10785 .07349 L
.10786 .06652 L
.10787 .11121 L
.10789 .12412 L
.1079 .09983 L
.10792 .153 L
.10793 .11551 L
.10795 .11871 L
.10796 .07327 L
.10797 .09346 L
.10799 .09661 L
.108 .10695 L
.10801 .09261 L
.10802 .11218 L
.10803 .12344 L
.10804 .11041 L
.10805 .1176 L
.10806 .07442 L
.10807 .11161 L
.10808 .12735 L
.1081 .09031 L
.10811 .11671 L
.10813 .15524 L
Mistroke
.10814 .09576 L
.10815 .10201 L
.10816 .12827 L
.10817 .09373 L
.10818 .12034 L
.10819 .10489 L
.1082 .08182 L
.10822 .11091 L
.10823 .10238 L
.10825 .09192 L
.10826 .11294 L
.10827 .05867 L
.10828 .13 L
.10829 .12922 L
.1083 .11643 L
.10831 .04434 L
.10832 .09249 L
.10833 .10863 L
.10834 .12889 L
.10835 .10268 L
.10835 .12945 L
.10836 .12219 L
.10838 .16119 L
.10839 .11415 L
.10839 .07029 L
.10841 .1247 L
.10843 .09207 L
.10843 .08586 L
.10844 .08648 L
.10846 .09974 L
.10847 .0896 L
.10848 .10361 L
.10849 .10351 L
.1085 .11788 L
.10852 .08722 L
.10853 .08162 L
.10855 .10966 L
.10856 .10434 L
.10857 .12578 L
.10859 .07636 L
.1086 .11209 L
.10862 .07932 L
.10862 .05794 L
.10863 .11352 L
.10865 .12853 L
.10866 .12998 L
.10867 .09672 L
.10868 .11148 L
.10869 .12106 L
.10871 .10056 L
Mistroke
.10872 .08772 L
.10874 .10544 L
.10874 .1124 L
.10875 .09817 L
.10876 .08622 L
.10877 .10214 L
.10878 .11853 L
.1088 .07497 L
.10881 .09101 L
.10882 .07924 L
.10883 .0716 L
.10884 .0822 L
.10885 .07217 L
.10886 .04098 L
.10887 .10343 L
.10888 .07295 L
.1089 .09763 L
.10891 .07243 L
.10891 .09235 L
.10892 .11088 L
.10893 .10665 L
.10894 .10779 L
.10895 .08433 L
.10896 .10375 L
.10898 .13039 L
.10899 .07655 L
.109 .09561 L
.10902 .14235 L
.10903 .11042 L
.10904 .07974 L
.10906 .09173 L
.10907 .13611 L
.10909 .09152 L
.1091 .11127 L
.10912 .07961 L
.10913 .12107 L
.10914 .05597 L
.10915 .0818 L
.10916 .09191 L
.10918 .09853 L
.10919 .07086 L
.10921 .13334 L
.10922 .0964 L
.10923 .09864 L
.10924 .1122 L
.10926 .09353 L
.10926 .14338 L
.10927 .11927 L
.10928 .09174 L
.10929 .10869 L
Mistroke
.1093 .06894 L
.10931 .07316 L
.10932 .11336 L
.10932 .12404 L
.10934 .1148 L
.10935 .1271 L
.10937 .11422 L
.10938 .10313 L
.1094 .07038 L
.10941 .10068 L
.10943 .09477 L
.10944 .11241 L
.10945 .11484 L
.10947 .10285 L
.10948 .08367 L
.1095 .10885 L
.10951 .11195 L
.10953 .10564 L
.10954 .09906 L
.10955 .09952 L
.10956 .13019 L
.10957 .07361 L
.10959 .13607 L
.1096 .12983 L
.10962 .08098 L
.10963 .08816 L
.10964 .09768 L
.10966 .11574 L
.10967 .11682 L
.10968 .10118 L
.10969 .08758 L
.10971 .11629 L
.10972 .09607 L
.10974 .08021 L
.10975 .11687 L
.10976 .12334 L
.10977 .10942 L
.10978 .10863 L
.10979 .12967 L
.10981 .09419 L
.10982 .13343 L
.10983 .09646 L
.10984 .14313 L
.10985 .08611 L
.10987 .09368 L
.10988 .12613 L
.1099 .11196 L
.10991 .13508 L
.10992 .1208 L
.10994 .08565 L
Mistroke
.10995 .07346 L
.10997 .10402 L
.10998 .1018 L
.10999 .05909 L
.11 .08092 L
.11001 .10154 L
.11003 .1295 L
.11004 .09547 L
.11005 .08239 L
.11006 .06986 L
.11007 .06197 L
.11008 .10995 L
.1101 .07559 L
.11011 .10184 L
.11012 .13533 L
.11014 .09206 L
.11015 .09228 L
.11017 .05287 L
.11018 .09034 L
.11019 .10059 L
.11021 .11935 L
.11022 .10269 L
.11024 .10458 L
.11025 .11525 L
.11027 .11705 L
.11028 .08128 L
.1103 .11581 L
.1103 .1134 L
.11031 .1012 L
.11032 .12972 L
.11033 .07594 L
.11034 .09944 L
.11035 .138 L
.11036 .09775 L
.11037 .11207 L
.11039 .10266 L
.1104 .11886 L
.11042 .04876 L
.11043 .09992 L
.11045 .0951 L
.11046 .09534 L
.11047 .10832 L
.11049 .09717 L
.1105 .08033 L
.11051 .11986 L
.11052 .0794 L
.11053 .13416 L
.11055 .09162 L
.11055 .12068 L
.11056 .1199 L
Mistroke
.11058 .07282 L
.11059 .10382 L
.11061 .07526 L
.11062 .07741 L
.11063 .06456 L
.11064 .10809 L
.11065 .12983 L
.11065 .07684 L
.11067 .10189 L
.11068 .0963 L
.11069 .10859 L
.1107 .11227 L
.11071 .12012 L
.11072 .11571 L
.11073 .06987 L
.11074 .0969 L
.11075 .07921 L
.11077 .0551 L
.11078 .088 L
.1108 .14476 L
.11081 .08304 L
.11081 .08602 L
.11083 .08216 L
.11084 .07714 L
.11086 .10462 L
.11087 .12658 L
.11089 .12199 L
.1109 .13496 L
.11091 .1259 L
.11093 .10924 L
.11094 .09073 L
.11096 .08178 L
.11097 .07196 L
.11098 .12253 L
.111 .12605 L
.11101 .09619 L
.11102 .12473 L
.11103 .11457 L
.11104 .08929 L
.11105 .09204 L
.11106 .11993 L
.11107 .12248 L
.11108 .10896 L
.11109 .06305 L
.1111 .0867 L
.11111 .06434 L
.11111 .13118 L
.11113 .1249 L
.11114 .08126 L
.11116 .09322 L
Mistroke
.11117 .10727 L
.11119 .09968 L
.1112 .09918 L
.11121 .0924 L
.11122 .08383 L
.11124 .05576 L
.11124 .08451 L
.11125 .0854 L
.11127 .11142 L
.11128 .13413 L
.11129 .08666 L
.1113 .08635 L
.11131 .07145 L
.11133 .11108 L
.11134 .12635 L
.11134 .10582 L
.11136 .08266 L
.11137 .10304 L
.11139 .08677 L
.1114 .10874 L
.11142 .08018 L
.11143 .08519 L
.11144 .09738 L
.11146 .09473 L
.11147 .08067 L
.11149 .07501 L
.1115 .08616 L
.11153 .10575 L
.11155 .08119 L
.11156 .1301 L
.11158 .10812 L
.11159 .12885 L
.11161 .08681 L
.11162 .12729 L
.11163 .10869 L
.11164 .08132 L
.11165 .09523 L
.11166 .10855 L
.11166 .09558 L
.11167 .09874 L
.11169 .10974 L
.1117 .05703 L
.11171 .09166 L
.11171 .1071 L
.11172 .12666 L
.11174 .07366 L
.11175 .11087 L
.11177 .11818 L
.11178 .10877 L
.1118 .11311 L
Mistroke
.11181 .11971 L
.11182 .13991 L
.11184 .07758 L
.11185 .13097 L
.11186 .07922 L
.11187 .0923 L
.11189 .11322 L
.1119 .09971 L
.11191 .13221 L
.11192 .06587 L
.11193 .05723 L
.11194 .0754 L
.11195 .09196 L
.11196 .05771 L
.11196 .13812 L
.11198 .09534 L
.112 .0939 L
.112 .1153 L
.11201 .06497 L
.11202 .04798 L
.11203 .10634 L
.11204 .12025 L
.11205 .09331 L
.11206 .06618 L
.11207 .10405 L
.11208 .12223 L
.11209 .09511 L
.1121 .06529 L
.11211 .12111 L
.11212 .10853 L
.11213 .10929 L
.11214 .08223 L
.11215 .08832 L
.11216 .08825 L
.11217 .09377 L
.11219 .10972 L
.1122 .13715 L
.11222 .12385 L
.11223 .08312 L
.11225 .10216 L
.11226 .10072 L
.11227 .12919 L
.11229 .1383 L
.1123 .14173 L
.11232 .13637 L
.11233 .1169 L
.11233 .09453 L
.11235 .09141 L
.11236 .06118 L
.11237 .1133 L
Mistroke
.11239 .07459 L
.1124 .05885 L
.11242 .11527 L
.11243 .09993 L
.11244 .10648 L
.11246 .10552 L
.11247 .09628 L
.11248 .10631 L
.11249 .13654 L
.1125 .09037 L
.11251 .07841 L
.11252 .09794 L
.11254 .10914 L
.11255 .13419 L
.11255 .14603 L
.11256 .11833 L
.11257 .13828 L
.11259 .11055 L
.1126 .11193 L
.11262 .09407 L
.11263 .09877 L
.11264 .08976 L
.11265 .13444 L
.11265 .13295 L
.11266 .08853 L
.11268 .09905 L
.11269 .11879 L
.11271 .10705 L
.11272 .06498 L
.11273 .09516 L
.11275 .12448 L
.11276 .12674 L
.11277 .08833 L
.11278 .10863 L
.11279 .1069 L
.11281 .10052 L
.11282 .10764 L
.11284 .05458 L
.11285 .08838 L
.11286 .0948 L
.11288 .10539 L
.11289 .06955 L
.1129 .10992 L
.11292 .07715 L
.11293 .09469 L
.11293 .07765 L
.11295 .13029 L
.11297 .08892 L
.11298 .09237 L
.11299 .08783 L
Mistroke
.113 .11303 L
.11301 .1119 L
.11302 .12735 L
.11303 .12106 L
.11304 .11717 L
.11305 .08431 L
.11306 .02778 L
.11308 .13418 L
.11309 .07696 L
.1131 .10864 L
.11312 .08203 L
.11313 .10352 L
.11314 .0773 L
.11315 .07465 L
.11317 .12549 L
.11318 .09696 L
.1132 .10017 L
.11321 .10316 L
.11322 .09844 L
.11324 .10001 L
.11325 .07395 L
.11326 .13258 L
.11328 .08836 L
.11329 .12354 L
.11331 .07964 L
.11332 .09767 L
.11334 .12488 L
.11335 .11084 L
.11336 .07239 L
.11337 .15118 L
.11339 .08525 L
.1134 .09024 L
.11341 .13646 L
.11343 .11827 L
.11344 .12483 L
.11345 .13749 L
.11347 .1192 L
.11348 .14157 L
.11349 .08387 L
.11351 .07849 L
.11352 .10721 L
.11353 .09253 L
.11355 .08577 L
.11356 .08927 L
.11357 .11664 L
.11358 .08021 L
.11359 .06179 L
.1136 .11461 L
.11362 .08407 L
.11363 .09432 L
Mistroke
.11365 .13564 L
.11366 .08588 L
.11368 .15608 L
.11369 .1099 L
.1137 .06869 L
.11372 .06547 L
.11373 .07752 L
.11375 .12444 L
.11376 .0895 L
.11378 .13391 L
.11379 .1245 L
.1138 .11501 L
.11381 .10431 L
.11382 .10413 L
.11382 .13319 L
.11384 .10793 L
.11385 .09775 L
.11387 .09164 L
.11388 .064 L
.11389 .11326 L
.11391 .08492 L
.11392 .10475 L
.11394 .08103 L
.11395 .13101 L
.11397 .08869 L
.11398 .09906 L
.11399 .0831 L
.11401 .08181 L
.11402 .09136 L
.11404 .07991 L
.11405 .04941 L
.11406 .11442 L
.11407 .14563 L
.11409 .0937 L
.1141 .10011 L
.11412 .11608 L
.11413 .07721 L
.11415 .09292 L
.11416 .10387 L
.11417 .11564 L
.11419 .10046 L
.1142 .09822 L
.11422 .1399 L
.11423 .10896 L
.11425 .12743 L
.11426 .08442 L
.11427 .10095 L
.11428 .10473 L
.11429 .11468 L
.11431 .11055 L
Mistroke
.11432 .04837 L
.11434 .08104 L
.11435 .11174 L
.11436 .12992 L
.11438 .12654 L
.11439 .07007 L
.1144 .12778 L
.11441 .10448 L
.11443 .07639 L
.11444 .09939 L
.11446 .10338 L
.11447 .09598 L
.11448 .0784 L
.11449 .08858 L
.1145 .09114 L
.11451 .08643 L
.11453 .13302 L
.11454 .10626 L
.11455 .10694 L
.11456 .125 L
.11457 .08758 L
.11459 .12499 L
.1146 .1259 L
.11461 .12771 L
.11463 .10778 L
.11464 .13073 L
.11466 .09592 L
.11467 .12319 L
.11469 .09444 L
.1147 .10405 L
.11471 .12926 L
.11472 .11471 L
.11473 .09094 L
.11475 .09917 L
.11476 .14108 L
.11477 .04806 L
.11478 .11654 L
.11479 .10944 L
.11481 .10489 L
.11482 .1266 L
.11483 .11837 L
.11485 .15265 L
.11486 .08115 L
.11487 .11003 L
.11489 .10954 L
.1149 .10274 L
.11491 .09981 L
.11493 .08288 L
.11494 .05897 L
.11496 .07387 L
Mistroke
.11497 .09153 L
.11499 .08578 L
.115 .08652 L
.11502 .11569 L
.11502 .08675 L
.11503 .07536 L
.11504 .08627 L
.11505 .12895 L
.11506 .11662 L
.11508 .09051 L
.11509 .13223 L
.11511 .09635 L
.11512 .11483 L
.11514 .12019 L
.11515 .12342 L
.11516 .12691 L
.11518 .08864 L
.11519 .06907 L
.11521 .10857 L
.11522 .08014 L
.11523 .11383 L
.11525 .09053 L
.11526 .10849 L
.11528 .09534 L
.11529 .1078 L
.1153 .07033 L
.11531 .11212 L
.11533 .11393 L
.11533 .07585 L
.11534 .0952 L
.11535 .1121 L
.11536 .09086 L
.11537 .09771 L
.11538 .04972 L
.11539 .09874 L
.1154 .0932 L
.11541 .12276 L
.11542 .13555 L
.11543 .11873 L
.11543 .11365 L
.11544 .08155 L
.11546 .14055 L
.11547 .11063 L
.11549 .09695 L
.1155 .10371 L
.11552 .08403 L
.11553 .09823 L
.11554 .1175 L
.11556 .08095 L
.11557 .07691 L
Mistroke
.11558 .07049 L
.1156 .09131 L
.11561 .06977 L
.11563 .11503 L
.11564 .09084 L
.11566 .08858 L
.11567 .09047 L
.11568 .16271 L
.11569 .0665 L
.11571 .15624 L
.11572 .06328 L
.11573 .1087 L
.11575 .07896 L
.11576 .14531 L
.11577 .1342 L
.11578 .08605 L
.1158 .06217 L
.11581 .0908 L
.11582 .10961 L
.11584 .07757 L
.11585 .09735 L
.11587 .12647 L
.11588 .10806 L
.11589 .08473 L
.1159 .08765 L
.11591 .08876 L
.11593 .08687 L
.11594 .0656 L
.11596 .06734 L
.11597 .06367 L
.11598 .12576 L
.116 .09361 L
.11601 .12239 L
.11603 .12426 L
.11604 .0896 L
.11605 .11762 L
.11607 .10526 L
.11608 .14413 L
.1161 .12615 L
.11611 .10564 L
.11612 .08691 L
.11613 .09562 L
.11615 .05027 L
.11616 .09654 L
.11617 .12891 L
.11619 .11164 L
.1162 .10928 L
.11622 .12365 L
.11623 .07851 L
.11624 .10764 L
Mistroke
.11625 .12775 L
.11627 .08094 L
.11628 .13492 L
.11629 .11017 L
.11631 .10644 L
.11632 .1261 L
.11634 .06316 L
.11634 .11056 L
.11635 .12348 L
.11637 .09878 L
.11638 .11978 L
.1164 .14705 L
.1164 .14325 L
.11641 .11374 L
.11643 .06072 L
.11644 .09312 L
.11645 .10932 L
.11647 .09292 L
.11648 .14155 L
.11649 .06917 L
.11651 .09803 L
.11652 .09409 L
.11653 .09382 L
.11654 .12126 L
.11655 .0656 L
.11656 .12864 L
.11657 .10415 L
.11659 .11119 L
.1166 .08783 L
.11662 .10581 L
.11663 .10227 L
.11664 .09311 L
.11666 .09744 L
.11667 .10155 L
.11668 .10857 L
.1167 .11367 L
.11671 .11547 L
.11672 .10154 L
.11674 .10267 L
.11675 .07371 L
.11676 .12005 L
.11678 .13696 L
.11679 .10456 L
.11681 .09325 L
.11682 .108 L
.11684 .07077 L
.11685 .12833 L
.11686 .10986 L
.11687 .12881 L
.11688 .07157 L
Mistroke
.1169 .08656 L
.11691 .09508 L
.11692 .12262 L
.11694 .108 L
.11695 .05317 L
.11696 .1313 L
.11698 .14829 L
.11699 .11943 L
.117 .10537 L
.11701 .0756 L
.11703 .10608 L
.11703 .08846 L
.11704 .13091 L
.11706 .10403 L
.11707 .11369 L
.11709 .10593 L
.1171 .09238 L
.11711 .11735 L
.11713 .12496 L
.11714 .12305 L
.11715 .12189 L
.11716 .10161 L
.11718 .13031 L
.11719 .10647 L
.11721 .10662 L
.11722 .11225 L
.11723 .0962 L
.11725 .11845 L
.11726 .0965 L
.11727 .09098 L
.11728 .09845 L
.11729 .10334 L
.11731 .0866 L
.11732 .12707 L
.11732 .09268 L
.11734 .11353 L
.11735 .10281 L
.11736 .13899 L
.11737 .11271 L
.11739 .10394 L
.1174 .08916 L
.11742 .10049 L
.11742 .12008 L
.11743 .09836 L
.11744 .07731 L
.11745 .10621 L
.11746 .07771 L
.11748 .12332 L
.11749 .11184 L
.1175 .10385 L
Mistroke
.11751 .12056 L
.11752 .05889 L
.11753 .0789 L
.11754 .06838 L
.11755 .08869 L
.11756 .05166 L
.11758 .084 L
.11759 .10767 L
.1176 .08163 L
.11761 .04786 L
.11762 .08492 L
.11763 .05887 L
.11764 .08135 L
.11765 .06077 L
.11766 .12056 L
.11767 .11494 L
.11767 .1147 L
.11769 .09157 L
.1177 .06686 L
.11772 .12177 L
.11773 .08038 L
.11774 .12501 L
.11775 .14105 L
.11776 .06926 L
.11778 .10585 L
.11779 .10567 L
.11781 .11208 L
.11781 .10912 L
.11782 .09126 L
.11784 .1042 L
.11785 .10249 L
.11786 .11198 L
.11788 .08431 L
.11789 .08277 L
.11791 .1254 L
.11792 .09404 L
.11793 .0607 L
.11794 .09932 L
.11795 .1077 L
.11796 .09456 L
.11797 .10208 L
.11798 .09837 L
.118 .15105 L
.11801 .07427 L
.11803 .1282 L
.11804 .06511 L
.11806 .07444 L
.11807 .1059 L
.11808 .08055 L
.11809 .11071 L
Mistroke
.11811 .12312 L
.11812 .08841 L
.11814 .10879 L
.11815 .14328 L
.11816 .10142 L
.11818 .0772 L
.11819 .11038 L
.11821 .08624 L
.11822 .08294 L
.11823 .11846 L
.11825 .12699 L
.11826 .08097 L
.11828 .09984 L
.11829 .09263 L
.11831 .12435 L
.11832 .13229 L
.11833 .13796 L
.11835 .0728 L
.11836 .09695 L
.11837 .12378 L
.11838 .10794 L
.11839 .10501 L
.1184 .09462 L
.11841 .10813 L
.11842 .10202 L
.11843 .12876 L
.11844 .10735 L
.11846 .08584 L
.11847 .08508 L
.11849 .0931 L
.11849 .09152 L
.1185 .10975 L
.11852 .04644 L
.11853 .10358 L
.11854 .0871 L
.11855 .08743 L
.11856 .09319 L
.11858 .14708 L
.11859 .15385 L
.11861 .09356 L
.11862 .09239 L
.11862 .08595 L
.11863 .1413 L
.11864 .10848 L
.11865 .11138 L
.11867 .09296 L
.11868 .09271 L
.11869 .09869 L
.1187 .07744 L
.11871 .11927 L
Mistroke
.11872 .09403 L
.11873 .08204 L
.11874 .10378 L
.11875 .08856 L
.11877 .14471 L
.11878 .07871 L
.11879 .06215 L
.11879 .10493 L
.1188 .07572 L
.11882 .09679 L
.11883 .09748 L
.11884 .12406 L
.11885 .12092 L
.11886 .12277 L
.11888 .08771 L
.11889 .1237 L
.11891 .05604 L
.11892 .09661 L
.11893 .11075 L
.11895 .1131 L
.11896 .10366 L
.11897 .05552 L
.11899 .0809 L
.119 .14222 L
.11901 .06735 L
.11902 .07949 L
.11904 .07525 L
.11905 .11652 L
.11907 .09609 L
.11908 .09511 L
.11909 .10268 L
.1191 .08941 L
.11911 .12239 L
.11913 .10542 L
.11914 .08366 L
.11915 .0732 L
.11916 .08391 L
.11917 .11706 L
.11918 .09804 L
.11919 .1453 L
.11921 .10125 L
.11922 .14248 L
.11923 .11168 L
.11924 .09565 L
.11926 .11449 L
.11927 .1189 L
.11928 .1029 L
.1193 .09028 L
.11931 .08473 L
.11931 .10747 L
Mistroke
.11933 .10028 L
.11934 .12303 L
.11936 .09621 L
.11937 .13465 L
.11938 .09829 L
.1194 .10568 L
.11941 .12103 L
.11942 .09124 L
.11944 .10679 L
.11945 .09002 L
.11947 .08802 L
.11948 .10023 L
.11948 .07821 L
.1195 .08929 L
.11951 .11942 L
.11952 .08656 L
.11953 .12171 L
.11955 .12342 L
.11955 .0919 L
.11956 .11844 L
.11957 .089 L
.11958 .08719 L
.1196 .13347 L
.1196 .10381 L
.11961 .09538 L
.11963 .10447 L
.11964 .11326 L
.11966 .05844 L
.11967 .10702 L
.11968 .11645 L
.1197 .10977 L
.11971 .11134 L
.11972 .12956 L
.11973 .06925 L
.11975 .07899 L
.11976 .11929 L
.11976 .11275 L
.11978 .12887 L
.11979 .1098 L
.11981 .06959 L
.11982 .11575 L
.11983 .09504 L
.11984 .10601 L
.11985 .08131 L
.11986 .0632 L
.11987 .12965 L
.11989 .09689 L
.11989 .12178 L
.1199 .07959 L
.11992 .11984 L
Mistroke
.11993 .08247 L
.11994 .09992 L
.11995 .10515 L
.11996 .10729 L
.11997 .0659 L
.11998 .07528 L
.11999 .05085 L
.12 .12758 L
.12002 .1198 L
.12003 .10905 L
.12004 .0906 L
.12005 .0754 L
.12006 .12543 L
.12006 .10018 L
.12007 .09395 L
.12008 .05435 L
.1201 .1162 L
.12011 .08522 L
.12012 .0694 L
.12013 .11501 L
.12014 .0844 L
.12015 .07438 L
.12017 .12639 L
.12018 .10492 L
.1202 .12 L
.12021 .06622 L
.12022 .07178 L
.12023 .11046 L
.12024 .05939 L
.12026 .16416 L
.12027 .11057 L
.12028 .09112 L
.1203 .08089 L
.12031 .08038 L
.12033 .11162 L
.12034 .14101 L
.12035 .0504 L
.12036 .09891 L
.12037 .09637 L
.12038 .10303 L
.12039 .10764 L
.12041 .11034 L
.12042 .09461 L
.12043 .09163 L
.12045 .10479 L
.12046 .08016 L
.12047 .07461 L
.12049 .05978 L
.1205 .08838 L
.12052 .07493 L
Mistroke
.12053 .09426 L
.12054 .10942 L
.12056 .10297 L
.12057 .10945 L
.12058 .12208 L
.1206 .13047 L
.12061 .09554 L
.12063 .0973 L
.12064 .07993 L
.12066 .08288 L
.12067 .11041 L
.12069 .13155 L
.12069 .1133 L
.1207 .09391 L
.12071 .0872 L
.12072 .09252 L
.12075 .11138 L
.12076 .11627 L
.12078 .12644 L
.12079 .1224 L
.12081 .09964 L
.12082 .08939 L
.12083 .10698 L
.12085 .10732 L
.12086 .08372 L
.12088 .09859 L
.12089 .10975 L
.12091 .11506 L
.12092 .06425 L
.12092 .12693 L
.12093 .10871 L
.12094 .07095 L
.12095 .12169 L
.12096 .10739 L
.12097 .13054 L
.12098 .09064 L
.12098 .12283 L
.12099 .11217 L
.12101 .08143 L
.12102 .08303 L
.12102 .13321 L
.12104 .09061 L
.12105 .10336 L
.12107 .08398 L
.12108 .10633 L
.12109 .13318 L
.1211 .10718 L
.12111 .10136 L
.12113 .07937 L
.12114 .06978 L
Mistroke
.12116 .12047 L
.12117 .08764 L
.12119 .10041 L
.1212 .0954 L
.12122 .08192 L
.12122 .06424 L
.12123 .09012 L
.12125 .11508 L
.12126 .14303 L
.12128 .10969 L
.12129 .1228 L
.1213 .10684 L
.12131 .11213 L
.12133 .12601 L
.12134 .08085 L
.12136 .11013 L
.12137 .11861 L
.12139 .10061 L
.1214 .10138 L
.1214 .07442 L
.12142 .11714 L
.12143 .11366 L
.12144 .14397 L
.12145 .09298 L
.12146 .12612 L
.12147 .09531 L
.12148 .09432 L
.12149 .07639 L
.1215 .11338 L
.12151 .10371 L
.12153 .08613 L
.12154 .10483 L
.12156 .1632 L
.12157 .09328 L
.12158 .04409 L
.12159 .07716 L
.1216 .07269 L
.12161 .11813 L
.12162 .0546 L
.12163 .10509 L
.12165 .08349 L
.12166 .11943 L
.12168 .08037 L
.12169 .07071 L
.12169 .09105 L
.12171 .08754 L
.12173 .10172 L
.12174 .1119 L
.12175 .12258 L
.12177 .1163 L
Mistroke
.12178 .081 L
.12179 .1258 L
.12181 .08796 L
.12182 .06916 L
.12184 .09976 L
.12185 .14307 L
.12186 .16224 L
.12187 .08869 L
.12188 .08602 L
.12188 .10716 L
.1219 .08866 L
.12191 .09886 L
.12193 .07327 L
.12194 .09745 L
.12194 .11733 L
.12195 .088 L
.12196 .11878 L
.12197 .12548 L
.12198 .07232 L
.122 .0974 L
.12201 .1018 L
.12202 .09383 L
.12203 .1353 L
.12204 .10841 L
.12206 .11911 L
.12207 .07965 L
.12209 .10573 L
.1221 .1129 L
.12212 .09298 L
.12213 .07147 L
.12214 .05771 L
.12215 .05754 L
.12215 .11012 L
.12216 .11117 L
.12218 .08819 L
.12219 .10581 L
.12221 .09036 L
.12222 .10831 L
.12224 .09378 L
.12225 .06235 L
.12226 .07636 L
.12228 .09514 L
.12229 .14528 L
.12231 .11595 L
.12232 .12489 L
.12233 .11229 L
.12235 .09822 L
.12236 .07069 L
.12238 .08691 L
.12239 .09723 L
Mistroke
.12241 .11339 L
.12242 .06835 L
.12243 .09998 L
.12244 .11585 L
.12245 .08276 L
.12246 .11505 L
.12246 .11622 L
.12247 .14268 L
.12249 .14045 L
.1225 .13424 L
.1225 .06528 L
.12251 .12356 L
.12252 .12629 L
.12253 .07875 L
.12254 .0988 L
.12255 .13865 L
.12256 .10122 L
.12257 .1308 L
.12259 .05942 L
.1226 .1106 L
.12261 .08308 L
.12263 .11415 L
.12264 .1027 L
.12266 .09243 L
.12267 .09753 L
.12268 .08664 L
.1227 .07638 L
.12271 .06551 L
.12273 .08841 L
.12274 .10258 L
.12276 .05305 L
.12277 .13161 L
.12278 .07546 L
.12279 .10944 L
.1228 .12179 L
.12282 .14132 L
.12283 .09468 L
.12285 .08143 L
.12286 .10466 L
.12287 .08047 L
.12289 .10132 L
.1229 .11536 L
.12291 .11407 L
.12292 .1035 L
.12294 .07935 L
.12295 .08833 L
.12297 .15201 L
.12298 .1144 L
.12299 .10254 L
.123 .11005 L
Mistroke
.12301 .08296 L
.12302 .12091 L
.12304 .0857 L
.12305 .06543 L
.12307 .09712 L
.12308 .11138 L
.1231 .12679 L
.12311 .08412 L
.12312 .09293 L
.12314 .09168 L
.12315 .13788 L
.12317 .10585 L
.12318 .11492 L
.1232 .1153 L
.12321 .11081 L
.12323 .10418 L
.12324 .12314 L
.12324 .07536 L
.12326 .07024 L
.12327 .09797 L
.12329 .09474 L
.1233 .07522 L
.12332 .08604 L
.12333 .08596 L
.12334 .07724 L
.12335 .15497 L
.12337 .11057 L
.12338 .11139 L
.12339 .11316 L
.12341 .11988 L
.12342 .09574 L
.12343 .08847 L
.12345 .13591 L
.12346 .1032 L
.12346 .09889 L
.12348 .09467 L
.12349 .10549 L
.12351 .11213 L
.12352 .11299 L
.12354 .07457 L
.12355 .0803 L
.12357 .08552 L
.12358 .07383 L
.12359 .09546 L
.12361 .1255 L
.12362 .12221 L
.12364 .0899 L
.12365 .09794 L
.12367 .10202 L
.12368 .06234 L
Mistroke
.12369 .14844 L
.1237 .12546 L
.12371 .10183 L
.12373 .06312 L
.12374 .07925 L
.12376 .05238 L
.12377 .13434 L
.12378 .08015 L
.1238 .12022 L
.12381 .11826 L
.12383 .09629 L
.12384 .10156 L
.12385 .08783 L
.12387 .12115 L
.12388 .07502 L
.12389 .14063 L
.12391 .09761 L
.12392 .09356 L
.12394 .11963 L
.12395 .11928 L
.12396 .0712 L
.12398 .09672 L
.12399 .10802 L
.12401 .12009 L
.12402 .11339 L
.12403 .11364 L
.12404 .08695 L
.12405 .09761 L
.12407 .10799 L
.12408 .07144 L
.12409 .11104 L
.12411 .08983 L
.12412 .08742 L
.12413 .13974 L
.12415 .07683 L
.12416 .09827 L
.12417 .14173 L
.12419 .0674 L
.1242 .08849 L
.12421 .10564 L
.12422 .13102 L
.12424 .10638 L
.12424 .101 L
.12425 .13285 L
.12427 .10798 L
.12428 .07955 L
.12428 .08848 L
.12429 .10288 L
.1243 .10128 L
.12432 .09855 L
Mistroke
.12433 .09758 L
.12433 .12913 L
.12435 .07945 L
.12437 .10476 L
.12438 .09537 L
.12439 .08044 L
.12441 .10825 L
.12442 .09895 L
.12444 .09518 L
.12445 .13134 L
.12445 .10434 L
.12447 .09228 L
.12448 .10824 L
.12449 .11897 L
.1245 .09786 L
.12452 .09189 L
.12453 .10434 L
.12455 .11138 L
.12455 .11476 L
.12456 .11651 L
.12457 .10958 L
.12458 .12845 L
.12459 .10868 L
.12461 .08256 L
.12462 .07638 L
.12463 .10588 L
.12464 .11775 L
.12465 .1176 L
.12466 .08674 L
.12467 .10085 L
.12468 .15176 L
.12469 .09271 L
.12469 .08206 L
.12471 .06272 L
.12472 .11711 L
.12473 .12637 L
.12473 .1145 L
.12474 .13346 L
.12476 .07707 L
.12477 .08483 L
.12477 .08971 L
.12479 .10701 L
.1248 .11904 L
.12482 .08005 L
.12483 .09356 L
.12485 .13556 L
.12486 .09159 L
.12487 .11992 L
.12488 .04192 L
.12489 .07587 L
Mistroke
.12491 .1179 L
.12492 .08237 L
.12493 .08466 L
.12494 .08357 L
.12495 .08191 L
.12497 .09281 L
.12498 .09288 L
.12499 .09095 L
.12501 .10566 L
.12502 .11681 L
.12503 .12633 L
.12505 .09696 L
.12506 .08746 L
.12507 .11329 L
.12508 .08934 L
.12509 .12316 L
.1251 .09982 L
.12511 .0911 L
.12513 .08862 L
.12514 .11157 L
.12516 .14872 L
.12517 .08142 L
.12518 .09072 L
.1252 .11897 L
.12521 .09516 L
.12522 .13655 L
.12524 .10754 L
.12525 .10413 L
.12527 .04803 L
.12528 .09611 L
.12529 .08366 L
.12531 .11531 L
.12532 .07393 L
.12534 .10715 L
.12535 .13561 L
.12536 .09825 L
.12538 .0797 L
.12539 .11737 L
.12539 .16275 L
.12541 .09062 L
.12543 .15539 L
.12543 .07712 L
.12544 .10004 L
.12546 .15232 L
.12547 .10673 L
.12548 .09249 L
.12549 .14381 L
.1255 .07296 L
.12552 .15859 L
.12553 .11134 L
Mistroke
.12555 .10005 L
.12556 .09023 L
.12557 .05609 L
.12559 .09118 L
.1256 .08764 L
.12562 .08563 L
.12563 .0949 L
.12565 .09822 L
.12565 .1267 L
.12566 .11341 L
.12568 .1202 L
.12569 .10615 L
.12571 .04804 L
.12572 .10308 L
.12574 .11017 L
.12574 .09246 L
.12575 .08986 L
.12576 .09992 L
.12577 .12423 L
.12578 .0863 L
.12579 .07988 L
.12579 .05837 L
.1258 .10746 L
.12582 .04699 L
.12583 .07799 L
.12584 .09681 L
.12585 .11841 L
.12587 .11036 L
.12588 .11481 L
.12589 .11719 L
.1259 .08648 L
.12591 .0919 L
.12593 .10315 L
.12594 .12141 L
.12595 .07154 L
.12597 .10171 L
.12598 .12804 L
.126 .10109 L
.12601 .1003 L
.12601 .1285 L
.12603 .10517 L
.12604 .08718 L
.12605 .0804 L
.12606 .0853 L
.12608 .10643 L
.12609 .12898 L
.1261 .1122 L
.12612 .09605 L
.12613 .1371 L
.12614 .10756 L
Mistroke
.12616 .11275 L
.12617 .11983 L
.12618 .11902 L
.1262 .124 L
.12621 .11088 L
.12622 .08945 L
.12624 .09774 L
.12625 .11352 L
.12627 .11256 L
.12628 .0892 L
.12629 .14418 L
.12631 .14053 L
.12632 .10547 L
.12634 .10148 L
.12635 .10453 L
.12636 .09893 L
.12637 .11434 L
.12638 .0532 L
.12639 .10489 L
.1264 .06435 L
.12642 .11876 L
.12642 .09886 L
.12643 .10973 L
.12645 .08324 L
.12646 .07681 L
.12648 .11489 L
.12649 .11856 L
.12651 .15181 L
.12652 .07962 L
.12653 .08986 L
.12655 .09126 L
.12656 .1136 L
.12657 .12038 L
.12659 .09748 L
.1266 .07142 L
.12662 .11955 L
.12663 .10781 L
.12663 .03938 L
.12665 .05059 L
.12667 .09494 L
.12667 .10456 L
.12668 .11017 L
.12669 .07477 L
.1267 .1166 L
.12671 .07582 L
.12673 .10332 L
.12674 .12409 L
.12675 .0619 L
.12676 .08853 L
.12678 .11204 L
Mistroke
.12679 .09311 L
.12679 .09227 L
.1268 .10158 L
.12681 .13194 L
.12683 .13019 L
.12683 .095 L
.12684 .09638 L
.12686 .0773 L
.12687 .09033 L
.12688 .13199 L
.1269 .07825 L
.12691 .11659 L
.12693 .08655 L
.12694 .11118 L
.12695 .10358 L
.12696 .0993 L
.12697 .12427 L
.12697 .11934 L
.12699 .08408 L
.127 .09106 L
.12702 .10191 L
.12703 .12263 L
.12705 .10838 L
.12706 .0879 L
.12707 .14144 L
.12709 .09038 L
.1271 .1062 L
.12711 .08618 L
.12713 .06533 L
.12714 .12735 L
.12715 .10893 L
.12717 .09467 L
.12718 .12171 L
.1272 .1392 L
.12721 .11004 L
.12722 .1048 L
.12724 .12372 L
.12725 .12465 L
.12727 .09263 L
.12728 .05744 L
.1273 .09272 L
.12731 .1455 L
.12731 .11423 L
.12732 .1282 L
.12733 .08546 L
.12735 .05983 L
.12736 .11737 L
.12737 .07928 L
.12739 .08529 L
.1274 .06366 L
Mistroke
.12742 .08206 L
.12743 .13718 L
.12744 .12976 L
.12746 .08922 L
.12747 .10083 L
.12749 .12418 L
.1275 .09036 L
.12752 .08659 L
.12753 .11931 L
.12753 .14407 L
.12755 .1063 L
.12756 .07381 L
.12757 .12217 L
.12758 .12767 L
.1276 .12215 L
.1276 .15071 L
.12761 .10896 L
.12762 .11833 L
.12763 .0766 L
.12765 .13138 L
.12765 .08255 L
.12766 .10804 L
.12768 .08418 L
.12769 .13136 L
.12769 .10776 L
.12771 .10245 L
.12772 .11456 L
.12774 .10046 L
.12775 .05543 L
.12777 .11064 L
.12778 .09791 L
.1278 .11156 L
.12781 .13141 L
.12782 .08194 L
.12783 .09863 L
.12784 .07057 L
.12786 .09255 L
.12787 .14101 L
.12788 .07552 L
.1279 .09513 L
.12791 .13988 L
.12792 .09096 L
.12794 .11652 L
.12795 .14322 L
.12797 .12809 L
.12798 .08564 L
.12799 .11645 L
.128 .11158 L
.12801 .08705 L
.12803 .14033 L
Mistroke
.12804 .10382 L
.12805 .08618 L
.12806 .11926 L
.12807 .13831 L
.12808 .08963 L
.12809 .09157 L
.1281 .09796 L
.12811 .11463 L
.12812 .08494 L
.12813 .11665 L
.12814 .13426 L
.12815 .08138 L
.12817 .0868 L
.12823 .10347 L
.12824 .1314 L
.12826 .11128 L
.12827 .09618 L
.12829 .08183 L
.1283 .09659 L
.12831 .11533 L
.12833 .07755 L
.12834 .08228 L
.12835 .13547 L
.12837 .09773 L
.12838 .08206 L
.1284 .11796 L
.12841 .12221 L
.12842 .13525 L
.12843 .11224 L
.12845 .08269 L
.12846 .07805 L
.12847 .09061 L
.12849 .07411 L
.1285 .11784 L
.12852 .09195 L
.12853 .10405 L
.12854 .13709 L
.12855 .09774 L
.12857 .10504 L
.12858 .09378 L
.12859 .05527 L
.12861 .06461 L
.12862 .12872 L
.12864 .11271 L
.12865 .09963 L
.12867 .10129 L
.12868 .06712 L
.1287 .09819 L
.12871 .0861 L
.12872 .12207 L
Mistroke
.12873 .05582 L
.12874 .0803 L
.12875 .12241 L
.12877 .14217 L
.12878 .13446 L
.12879 .10174 L
.12881 .10451 L
.12882 .07542 L
.12883 .0762 L
.12884 .12332 L
.12886 .13324 L
.12886 .10049 L
.12887 .10132 L
.12889 .11165 L
.12889 .10642 L
.1289 .06356 L
.12891 .14165 L
.12892 .10876 L
.12894 .08398 L
.12895 .09564 L
.12896 .14093 L
.12897 .12627 L
.12898 .09554 L
.129 .11019 L
.12901 .09644 L
.12903 .10477 L
.12904 .0974 L
.12905 .06344 L
.12906 .09891 L
.12907 .08839 L
.12908 .12176 L
.12909 .12349 L
.1291 .11003 L
.12911 .11092 L
.12912 .09097 L
.12913 .12149 L
.12913 .10152 L
.12914 .05393 L
.12916 .07271 L
.12917 .10796 L
.12919 .11612 L
.1292 .13011 L
.12922 .09193 L
.12923 .10994 L
.12925 .08324 L
.12926 .1048 L
.12927 .1062 L
.12929 .10011 L
.1293 .07912 L
.12932 .11886 L
Mistroke
.12933 .08831 L
.12934 .09011 L
.12941 .09617 L
.12942 .11271 L
.12944 .10133 L
.12945 .11644 L
.12946 .10917 L
.12948 .08523 L
.12949 .14837 L
.12951 .11753 L
.12952 .10508 L
.12953 .11151 L
.12955 .11681 L
.12956 .11168 L
.12958 .10783 L
.12959 .09351 L
.1296 .10384 L
.12961 .11276 L
.12963 .1532 L
.12964 .13029 L
.12965 .0672 L
.12966 .08093 L
.12967 .08655 L
.12968 .07504 L
.12969 .08895 L
.1297 .09217 L
.12972 .06568 L
.12974 .08449 L
.12975 .11494 L
.12976 .09131 L
.12977 .13725 L
.12978 .10388 L
.12978 .08118 L
.1298 .09227 L
.12981 .13981 L
.12982 .07723 L
.12983 .09325 L
.12985 .08053 L
.12986 .12356 L
.12987 .07444 L
.12987 .09804 L
.12988 .10971 L
.1299 .10995 L
.12991 .08889 L
.12993 .10926 L
.12993 .09625 L
.12994 .12824 L
.12995 .09851 L
.12996 .12771 L
.12997 .13297 L
Mistroke
.12998 .0946 L
.12999 .12097 L
.12999 .1147 L
.13001 .07592 L
.13002 .09231 L
.13004 .10649 L
.13005 .12735 L
.13006 .09551 L
.13008 .11642 L
.13009 .06552 L
.1301 .1073 L
.13011 .09734 L
.13012 .13814 L
.13014 .11346 L
.13015 .12089 L
.13016 .1239 L
.13017 .06919 L
.13018 .11273 L
.1302 .09848 L
.13021 .11485 L
.13022 .0729 L
.13024 .06482 L
.13026 .06333 L
.13026 .06642 L
.13027 .08598 L
.13029 .09121 L
.1303 .11886 L
.1303 .13154 L
.13032 .11713 L
.13033 .05649 L
.13035 .13286 L
.13036 .10708 L
.13038 .093 L
.13039 .09035 L
.1304 .13839 L
.13041 .12631 L
.13043 .09253 L
.13044 .14373 L
.13046 .12199 L
.13047 .10434 L
.13048 .06782 L
.1305 .09241 L
.13051 .05838 L
.13053 .11063 L
.13054 .10022 L
.13056 .09618 L
.13057 .11544 L
.13058 .09701 L
.1306 .10942 L
.13061 .12255 L
Mistroke
.13063 .11001 L
.13064 .11992 L
.13065 .07315 L
.13067 .13333 L
.13068 .09898 L
.1307 .10539 L
.1307 .09489 L
.13071 .10753 L
.13072 .09479 L
.13073 .1323 L
.13074 .1018 L
.13075 .10444 L
.13076 .1176 L
.13078 .11757 L
.13079 .10319 L
.13081 .1039 L
.13082 .11857 L
.13083 .1194 L
.13084 .08783 L
.13085 .07302 L
.13087 .1036 L
.13088 .0852 L
.13088 .09515 L
.1309 .11463 L
.13091 .11684 L
.13093 .08463 L
.13094 .06924 L
.13095 .11924 L
.13096 .09621 L
.13097 .10041 L
.13097 .08165 L
.13099 .08263 L
.131 .1042 L
.13101 .10341 L
.13102 .10462 L
.13104 .09359 L
.13105 .11478 L
.13106 .0838 L
.13106 .12103 L
.13107 .11751 L
.13109 .09075 L
.1311 .09697 L
.13111 .06843 L
.13112 .14655 L
.13113 .1561 L
.13114 .06536 L
.13115 .10086 L
.13117 .08354 L
.13117 .11271 L
.13118 .10721 L
Mistroke
.1312 .12662 L
.13121 .09272 L
.13122 .1226 L
.13124 .04881 L
.13125 .1161 L
.13127 .11458 L
.13128 .13429 L
.13129 .07187 L
.13131 .10524 L
.13132 .12585 L
.13134 .05755 L
.13135 .08202 L
.13135 .09759 L
.13137 .14259 L
.13139 .11232 L
.1314 .07665 L
.13141 .10342 L
.13143 .144 L
.13144 .08172 L
.13145 .08893 L
.13146 .12314 L
.13147 .08915 L
.13148 .08888 L
.13149 .06998 L
.1315 .11563 L
.1315 .10164 L
.13151 .06509 L
.13152 .10732 L
.13153 .08813 L
.13154 .11768 L
.13156 .11935 L
.13157 .10577 L
.13158 .11221 L
.13159 .05308 L
.1316 .10494 L
.13162 .11765 L
.13163 .12555 L
.13165 .08444 L
.13166 .10845 L
.13167 .12723 L
.13169 .12996 L
.1317 .11147 L
.1317 .09939 L
.13172 .12002 L
.13173 .1106 L
.13174 .09187 L
.13175 .11575 L
.13177 .09861 L
.13178 .05515 L
.1318 .09054 L
Mistroke
.13181 .11411 L
.13182 .09947 L
.13183 .05277 L
.13185 .09448 L
.13186 .08364 L
.13188 .10701 L
.13189 .11781 L
.1319 .09535 L
.13192 .09743 L
.13193 .09803 L
.13194 .06888 L
.13196 .10547 L
.13197 .08555 L
.13199 .14227 L
.132 .10381 L
.13202 .08196 L
.13203 .10723 L
.13205 .10846 L
.13205 .10155 L
.13206 .11221 L
.13207 .08942 L
.13208 .08492 L
.13209 .08203 L
.13211 .13043 L
.13212 .09559 L
.13214 .06776 L
.13215 .09916 L
.13217 .08579 L
.13218 .0874 L
.13219 .10122 L
.13221 .14767 L
.13222 .11425 L
.13224 .13752 L
.13225 .09326 L
.13226 .09615 L
.13228 .07428 L
.1323 .08992 L
.13231 .1146 L
.13232 .12974 L
.13233 .09784 L
.13234 .09005 L
.13236 .10098 L
.13236 .07238 L
.13237 .07327 L
.13238 .08414 L
.13239 .13843 L
.1324 .12648 L
.13241 .10369 L
.13242 .08621 L
.13243 .08651 L
Mistroke
.13244 .117 L
.13245 .13096 L
.13246 .09252 L
.13246 .08155 L
.13247 .0827 L
.13249 .10163 L
.1325 .11878 L
.13252 .09295 L
.13253 .08321 L
.13255 .12093 L
.13256 .08656 L
.13257 .1082 L
.13259 .12419 L
.1326 .12993 L
.13261 .15356 L
.13263 .12819 L
.13264 .1113 L
.13266 .10523 L
.13267 .08898 L
.13268 .1029 L
.13269 .12449 L
.13271 .06405 L
.13272 .10808 L
.13274 .10924 L
.13275 .11963 L
.13276 .09682 L
.13278 .10048 L
.13279 .10196 L
.1328 .09785 L
.13282 .12149 L
.13283 .11831 L
.13284 .09979 L
.13286 .07177 L
.13287 .09438 L
.13288 .10947 L
.1329 .07016 L
.13291 .15039 L
.13292 .11947 L
.13293 .12003 L
.13294 .10762 L
.13296 .08744 L
.13297 .09957 L
.13299 .10879 L
.133 .05642 L
.13302 .12828 L
.13303 .08874 L
.13304 .11874 L
.13306 .06639 L
.13307 .13875 L
.13308 .14477 L
Mistroke
.1331 .12778 L
.13311 .11303 L
.13313 .11414 L
.13314 .13199 L
.13315 .08062 L
.13316 .06533 L
.13318 .10633 L
.13319 .07896 L
.1332 .09698 L
.13322 .08623 L
.13323 .1108 L
.13325 .09116 L
.13326 .10744 L
.13327 .12222 L
.13328 .12749 L
.1333 .1032 L
.13331 .1272 L
.13332 .13696 L
.13334 .08802 L
.13335 .12742 L
.13337 .10638 L
.13337 .15042 L
.13338 .10672 L
.1334 .08744 L
.13341 .10292 L
.13343 .09297 L
.13343 .1206 L
.13344 .13945 L
.13346 .08688 L
.13347 .12983 L
.13348 .10987 L
.1335 .10183 L
.13351 .08165 L
.13352 .10627 L
.13354 .09015 L
.13355 .12524 L
.13356 .09353 L
.13357 .10856 L
.13358 .05192 L
.13359 .11146 L
.1336 .12967 L
.13362 .11345 L
.13363 .09345 L
.13365 .09864 L
.13366 .10305 L
.13367 .11657 L
.13369 .10331 L
.1337 .07769 L
.13371 .13251 L
.13373 .08548 L
Mistroke
.13374 .11476 L
.13375 .09111 L
.13377 .1238 L
.13378 .12132 L
.13379 .07703 L
.13381 .13637 L
.13382 .1069 L
.13384 .1173 L
.13385 .07803 L
.13387 .07995 L
.13388 .13181 L
.1339 .0779 L
.1339 .08199 L
.13391 .08968 L
.13393 .09802 L
.13394 .08441 L
.13395 .0977 L
.13396 .11802 L
.13397 .0822 L
.13399 .09136 L
.134 .11794 L
.13401 .0854 L
.13403 .10461 L
.13404 .12597 L
.13406 .11112 L
.13407 .08931 L
.13409 .15144 L
.1341 .08666 L
.13412 .10124 L
.13413 .10759 L
.13415 .10215 L
.13416 .13065 L
.13417 .08812 L
.13418 .11088 L
.13419 .0984 L
.13421 .08612 L
.13422 .069 L
.13422 .06703 L
.13423 .09331 L
.13424 .10012 L
.13425 .07424 L
.13426 .05884 L
.13427 .07602 L
.13428 .06863 L
.13429 .09511 L
.1343 .06478 L
.13431 .10503 L
.13431 .09998 L
.13432 .09474 L
.13434 .1113 L
Mistroke
.13435 .07207 L
.13437 .06765 L
.13438 .07556 L
.1344 .12 L
.13441 .09652 L
.13442 .12157 L
.13444 .1072 L
.13444 .11155 L
.13445 .08859 L
.13447 .11375 L
.13448 .12009 L
.1345 .13532 L
.13451 .08445 L
.13452 .11517 L
.13454 .06864 L
.13455 .10524 L
.13456 .11705 L
.13458 .10281 L
.13459 .11481 L
.13461 .10766 L
.13461 .08613 L
.13462 .09377 L
.13464 .08478 L
.13465 .11469 L
.13467 .10673 L
.13468 .11028 L
.1347 .09479 L
.13471 .08348 L
.13472 .09065 L
.13473 .10127 L
.13474 .09642 L
.13476 .11233 L
.13477 .09262 L
.13477 .06828 L
.13478 .09811 L
.13479 .14095 L
.13481 .12387 L
.13482 .12137 L
.13482 .07965 L
.13484 .0819 L
.13485 .12171 L
.13487 .10772 L
.13488 .10858 L
.1349 .12964 L
.13491 .06092 L
.13491 .10341 L
.13493 .1057 L
.13494 .11062 L
.13496 .10918 L
.13497 .09246 L
Mistroke
.13499 .10127 L
.135 .12188 L
.13501 .07175 L
.13502 .12089 L
.13504 .09902 L
.13505 .14151 L
.13506 .11905 L
.13507 .09178 L
.13508 .16158 L
.13509 .09137 L
.1351 .1006 L
.13512 .10911 L
.13513 .09021 L
.13515 .08591 L
.13516 .08483 L
.13517 .07689 L
.13519 .08383 L
.1352 .05375 L
.13521 .06982 L
.13522 .12954 L
.13523 .08958 L
.13524 .10316 L
.13525 .08176 L
.13526 .1018 L
.13527 .10796 L
.13529 .10107 L
.13529 .13083 L
.1353 .09611 L
.13532 .10676 L
.13533 .14513 L
.13534 .11993 L
.13535 .11944 L
.13536 .11366 L
.13538 .11468 L
.13538 .09569 L
.13539 .10128 L
.13541 .10506 L
.13542 .14356 L
.13544 .13958 L
.13545 .09949 L
.13546 .0962 L
.13548 .05629 L
.13549 .10089 L
.13551 .13753 L
.13552 .0841 L
.13553 .08504 L
.13555 .11032 L
.13556 .08445 L
.13557 .10485 L
.13558 .11284 L
Mistroke
.1356 .11685 L
.13561 .07738 L
.13562 .10813 L
.13564 .09119 L
.13565 .14209 L
.13566 .10103 L
.13567 .1497 L
.13568 .14144 L
.13569 .06424 L
.13571 .10233 L
.13571 .09848 L
.13572 .08237 L
.13574 .11219 L
.13575 .11344 L
.13577 .0757 L
.13578 .12481 L
.13578 .13022 L
.1358 .07343 L
.13581 .11614 L
.13582 .12537 L
.13583 .09693 L
.13584 .08037 L
.13585 .08946 L
.13586 .09325 L
.13588 .10824 L
.13588 .10676 L
.13589 .11736 L
.13591 .07383 L
.13592 .07287 L
.13594 .11261 L
.13595 .09638 L
.13597 .11405 L
.13598 .08078 L
.13599 .09103 L
.13601 .11335 L
.13602 .14233 L
.13604 .09559 L
.13605 .10297 L
.13606 .11503 L
.13607 .07822 L
.13608 .09069 L
.1361 .12316 L
.13611 .0929 L
.13613 .09261 L
.13614 .11822 L
.13615 .12213 L
.13616 .09098 L
.13617 .10901 L
.13618 .1144 L
.13619 .09952 L
Mistroke
.1362 .0803 L
.13621 .0543 L
.13622 .10925 L
.13622 .05117 L
.13624 .0984 L
.13625 .12012 L
.13626 .11083 L
.13627 .1542 L
.13629 .14521 L
.13629 .10615 L
.1363 .09047 L
.13632 .07184 L
.13633 .09029 L
.13634 .10187 L
.13636 .10807 L
.13637 .09109 L
.13638 .08238 L
.1364 .10066 L
.13641 .0888 L
.13642 .05367 L
.13643 .12697 L
.13644 .08843 L
.13645 .09274 L
.13646 .11924 L
.13648 .07415 L
.13649 .11691 L
.13651 .12801 L
.13652 .0938 L
.13653 .0884 L
.13655 .09448 L
.13656 .11005 L
.13658 .1191 L
.13659 .12746 L
.13661 .10181 L
.13662 .12936 L
.13663 .10681 L
.13665 .09746 L
.13666 .11441 L
.13667 .12134 L
.13669 .11421 L
.1367 .12804 L
.13671 .11238 L
.13673 .10829 L
.13674 .10874 L
.13676 .07651 L
.13677 .07949 L
.13677 .0761 L
.13679 .09343 L
.1368 .0873 L
.13681 .09886 L
Mistroke
.13682 .11618 L
.13683 .09804 L
.13685 .08723 L
.13686 .09083 L
.13688 .11799 L
.13689 .10677 L
.1369 .11522 L
.13692 .10992 L
.13693 .08413 L
.13695 .13721 L
.13696 .09073 L
.13698 .10922 L
.13699 .12835 L
.13701 .10046 L
.13702 .09683 L
.13704 .13085 L
.13704 .12786 L
.13705 .1184 L
.13706 .09379 L
.13707 .12191 L
.13708 .0883 L
.1371 .10193 L
.13711 .11048 L
.13712 .11353 L
.13713 .08741 L
.13714 .09098 L
.13715 .11148 L
.13715 .09505 L
.13716 .10196 L
.13718 .13001 L
.13719 .07071 L
.13719 .12816 L
.1372 .06786 L
.13721 .09755 L
.13723 .12405 L
.13724 .1028 L
.13726 .09563 L
.13727 .10667 L
.13729 .1322 L
.1373 .109 L
.13731 .08261 L
.13733 .07538 L
.13734 .09494 L
.13736 .10057 L
.13737 .0916 L
.13738 .11668 L
.1374 .09186 L
.13741 .08598 L
.13742 .07437 L
.13743 .07374 L
Mistroke
.13745 .09311 L
.13746 .10506 L
.13747 .15312 L
.13749 .11839 L
.1375 .08967 L
.13751 .10156 L
.13753 .13134 L
.13754 .09317 L
.13755 .13032 L
.13757 .11599 L
.13758 .10512 L
.13759 .13391 L
.13761 .11096 L
.13762 .10033 L
.13763 .08502 L
.13764 .10402 L
.13765 .12305 L
.13767 .14782 L
.13768 .11429 L
.1377 .07244 L
.13771 .0836 L
.13773 .12367 L
.13774 .13018 L
.13775 .0819 L
.13777 .09966 L
.13778 .12543 L
.1378 .09163 L
.13781 .07574 L
.13782 .10452 L
.13784 .1046 L
.13785 .08848 L
.13786 .08574 L
.13787 .13604 L
.13789 .09092 L
.1379 .10035 L
.13792 .11111 L
.13793 .11338 L
.13794 .06597 L
.13796 .10059 L
.13797 .07729 L
.13798 .11313 L
.13799 .08797 L
.13801 .09187 L
.13802 .1122 L
.13804 .06728 L
.13805 .09475 L
.13806 .13277 L
.13808 .10963 L
.13809 .10531 L
.13809 .10496 L
Mistroke
.13811 .09317 L
.13812 .08818 L
.13814 .10799 L
.13814 .10118 L
.13815 .1014 L
.13817 .11636 L
.13818 .08345 L
.13819 .10205 L
.13821 .11657 L
.13822 .10433 L
.13824 .11836 L
.13825 .08036 L
.13826 .11528 L
.13827 .10946 L
.13828 .11419 L
.13829 .11784 L
.1383 .12988 L
.13831 .10666 L
.13833 .11192 L
.13834 .10264 L
.13836 .1617 L
.13837 .0686 L
.13838 .08481 L
.1384 .14566 L
.13841 .13156 L
.13842 .10894 L
.13844 .10992 L
.13845 .08616 L
.13846 .10119 L
.13848 .11778 L
.13849 .12255 L
.13851 .0925 L
.13852 .1341 L
.13853 .11516 L
.13855 .08779 L
.13856 .10838 L
.13858 .08301 L
.13859 .08021 L
.13861 .06585 L
.13862 .12092 L
.13862 .13745 L
.13863 .09849 L
.13864 .12464 L
.13866 .08687 L
.13867 .13396 L
.13868 .08177 L
.1387 .09765 L
.13871 .08174 L
.13873 .11043 L
.13874 .09677 L
Mistroke
.13875 .07638 L
.13877 .09622 L
.13878 .09686 L
.1388 .13088 L
.13881 .1105 L
.13883 .06633 L
.13884 .12534 L
.13886 .0938 L
.13887 .09331 L
.13889 .12688 L
.13889 .07875 L
.1389 .0613 L
.13892 .08933 L
.13893 .13256 L
.13893 .10276 L
.13894 .09358 L
.13895 .09182 L
.13897 .1245 L
.13897 .07324 L
.13898 .10665 L
.13899 .07706 L
.139 .08658 L
.13901 .12459 L
.13902 .09259 L
.13903 .09708 L
.13903 .11449 L
.13905 .10684 L
.13906 .12626 L
.13908 .0932 L
.13909 .10465 L
.13911 .08499 L
.13912 .0732 L
.13914 .13203 L
.13915 .12443 L
.13916 .08997 L
.13918 .09393 L
.13919 .07965 L
.13921 .06798 L
.13922 .14297 L
.13923 .09561 L
.13925 .1299 L
.13926 .09136 L
.13927 .08408 L
.13928 .09778 L
.1393 .11043 L
.13931 .11507 L
.13932 .12236 L
.13934 .08601 L
.13935 .09175 L
.13936 .07234 L
Mistroke
.13938 .06622 L
.13939 .08096 L
.1394 .13445 L
.13942 .10511 L
.13943 .10425 L
.13944 .11817 L
.13946 .11258 L
.13947 .10068 L
.13948 .09378 L
.13949 .09275 L
.1395 .11035 L
.13952 .14373 L
.13953 .09564 L
.13955 .09369 L
.13956 .07416 L
.13958 .10852 L
.13959 .108 L
.1396 .11365 L
.13962 .09244 L
.13963 .1073 L
.13965 .09526 L
.13966 .09229 L
.13967 .08614 L
.13969 .10921 L
.1397 .09789 L
.13971 .08368 L
.13972 .0658 L
.13974 .10351 L
.13975 .1108 L
.13977 .09982 L
.13978 .10606 L
.13979 .05271 L
.13981 .13422 L
.13982 .12132 L
.13983 .07013 L
.13984 .10521 L
.13986 .12174 L
.13987 .10864 L
.13989 .07358 L
.1399 .12384 L
.13991 .10753 L
.13993 .114 L
.13994 .11783 L
.13994 .09655 L
.13996 .0924 L
.13997 .08035 L
.13999 .09652 L
.13999 .07778 L
.14 .12987 L
.14002 .08793 L
Mistroke
.14003 .1009 L
.14004 .08891 L
.14006 .12358 L
.14007 .14548 L
.14009 .13332 L
.1401 .10864 L
.14011 .15383 L
.14012 .08093 L
.14012 .09616 L
.14013 .12022 L
.14015 .10122 L
.14016 .10638 L
.14018 .10067 L
.14019 .09178 L
.14021 .09201 L
.14022 .13007 L
.14023 .09699 L
.14025 .11053 L
.14026 .10661 L
.14028 .11316 L
.14029 .1085 L
.14031 .09484 L
.14032 .14377 L
.14034 .11318 L
.14035 .11323 L
.14036 .12341 L
.14037 .07993 L
.14039 .10092 L
.1404 .0726 L
.14041 .11752 L
.14043 .1024 L
.14044 .06956 L
.14046 .0989 L
.14047 .09694 L
.14047 .10223 L
.14048 .1043 L
.14049 .08753 L
.14051 .11099 L
.14052 .10321 L
.14053 .07993 L
.14055 .07283 L
.14056 .14018 L
.14058 .09888 L
.14059 .09454 L
.1406 .12344 L
.14062 .12341 L
.14063 .10626 L
.14065 .08501 L
.14066 .11848 L
.14068 .1221 L
Mistroke
.14069 .12983 L
.14071 .10443 L
.14072 .11013 L
.14074 .11268 L
.14074 .1103 L
.14075 .13332 L
.14077 .10573 L
.14078 .1021 L
.14078 .08631 L
.14079 .10571 L
.1408 .10427 L
.14082 .08323 L
.14082 .09073 L
.14083 .13143 L
.14084 .16412 L
.14085 .11754 L
.14086 .11406 L
.14087 .07174 L
.14088 .11571 L
.14088 .10091 L
.1409 .11261 L
.14091 .05137 L
.14093 .11532 L
.14094 .10811 L
.14096 .1268 L
.14097 .10006 L
.14098 .10472 L
.141 .11458 L
.14101 .08596 L
.14101 .06313 L
.14103 .08374 L
.14104 .1172 L
.14106 .08169 L
.14107 .13371 L
.14109 .09599 L
.1411 .12984 L
.14111 .07453 L
.14112 .09713 L
.14114 .10403 L
.14115 .11237 L
.14117 .09799 L
.14118 .04794 L
.14118 .08084 L
.1412 .0966 L
.14121 .05652 L
.14123 .06596 L
.14124 .06793 L
.14126 .10363 L
.14126 .12602 L
.14127 .13419 L
Mistroke
.14129 .04768 L
.1413 .1132 L
.1413 .13397 L
.14131 .12591 L
.14132 .11822 L
.14134 .09539 L
.14135 .09756 L
.14136 .1135 L
.14137 .10444 L
.14139 .12123 L
.1414 .07841 L
.14142 .09199 L
.14143 .07841 L
.14144 .07809 L
.14146 .13013 L
.14147 .11814 L
.14147 .09364 L
.14149 .03189 L
.1415 .06786 L
.14152 .15444 L
.14153 .11294 L
.14154 .06441 L
.14156 .10705 L
.14157 .11485 L
.14159 .09889 L
.1416 .08066 L
.14161 .11837 L
.14163 .12956 L
.14164 .1326 L
.14165 .11108 L
.14166 .08066 L
.14168 .12622 L
.14168 .11332 L
.14169 .11014 L
.14171 .10399 L
.14172 .05884 L
.14172 .12024 L
.14173 .10583 L
.14174 .0793 L
.14176 .08969 L
.14177 .14632 L
.14179 .10706 L
.1418 .13011 L
.14181 .10228 L
.14182 .07647 L
.14183 .07866 L
.14184 .08364 L
.14185 .10524 L
.14186 .11794 L
.14188 .10527 L
Mistroke
.14189 .09795 L
.14191 .09034 L
.14191 .07937 L
.14192 .09274 L
.14194 .10995 L
.14194 .10654 L
.14195 .11651 L
.14197 .12822 L
.14198 .13216 L
.142 .07858 L
.14201 .11042 L
.14202 .07054 L
.14204 .07834 L
.14205 .0918 L
.14207 .10968 L
.14208 .1278 L
.14209 .08026 L
.14211 .09451 L
.14212 .08103 L
.14213 .10241 L
.14214 .17065 L
.14216 .08303 L
.14217 .10217 L
.14218 .11736 L
.1422 .08741 L
.14222 .09058 L
.14222 .13917 L
.14223 .11426 L
.14224 .12584 L
.14225 .08285 L
.14227 .11988 L
.14227 .07596 L
.14228 .0846 L
.1423 .09432 L
.14231 .09699 L
.14233 .08993 L
.14234 .06575 L
.14234 .10596 L
.14236 .11901 L
.14237 .09393 L
.14238 .07771 L
.14239 .10392 L
.1424 .08884 L
.14241 .1063 L
.14242 .1305 L
.14244 .08323 L
.14244 .13675 L
.14245 .09051 L
.14247 .12944 L
.14248 .10263 L
Mistroke
.1425 .09959 L
.14251 .09811 L
.14253 .09095 L
.14254 .11065 L
.14255 .11083 L
.14257 .11093 L
.14258 .11548 L
.1426 .12372 L
.14261 .10542 L
.14262 .11224 L
.14263 .11186 L
.14264 .08493 L
.14266 .11499 L
.14267 .06903 L
.14269 .15714 L
.1427 .12868 L
.14271 .10329 L
.14272 .11504 L
.14273 .12812 L
.14274 .13431 L
.14275 .12026 L
.14276 .08952 L
.14277 .10283 L
.14278 .06619 L
.14278 .11067 L
.14279 .12591 L
.1428 .11073 L
.14282 .10648 L
.14283 .11211 L
.14285 .12941 L
.14285 .09592 L
.14286 .12236 L
.14288 .09238 L
.14289 .09209 L
.1429 .09062 L
.14292 .11266 L
.14293 .08595 L
.14294 .10548 L
.14296 .14208 L
.14297 .04695 L
.14298 .08013 L
.14299 .1039 L
.143 .09539 L
.14301 .13444 L
.14302 .12296 L
.14304 .09509 L
.14305 .12878 L
.14307 .08555 L
.14308 .08227 L
.14309 .09361 L
Mistroke
.1431 .07951 L
.14312 .12183 L
.14313 .09692 L
.14315 .09567 L
.14316 .08058 L
.14317 .10667 L
.14319 .09923 L
.1432 .10096 L
.14321 .10938 L
.14323 .10592 L
.14324 .08307 L
.14326 .14114 L
.14327 .14452 L
.14329 .10556 L
.1433 .09882 L
.14332 .08211 L
.14332 .10895 L
.14333 .08967 L
.14334 .08266 L
.14335 .16253 L
.14336 .09388 L
.14338 .0763 L
.14339 .06104 L
.14341 .10897 L
.14342 .10276 L
.14344 .13743 L
.14345 .09551 L
.14346 .08656 L
.14348 .10857 L
.14349 .09205 L
.14351 .1578 L
.14352 .11306 L
.14354 .09907 L
.14355 .11119 L
.14357 .0747 L
.14358 .09469 L
.14359 .07733 L
.1436 .08951 L
.14361 .07371 L
.14363 .12265 L
.14364 .11264 L
.14364 .10418 L
.14365 .07899 L
.14366 .13687 L
.14368 .08102 L
.14368 .05906 L
.14369 .06771 L
.1437 .077 L
.14371 .11653 L
.14372 .10923 L
Mistroke
.14373 .08488 L
.14373 .116 L
.14374 .08869 L
.14376 .08088 L
.14377 .10918 L
.14379 .11682 L
.1438 .11444 L
.14382 .14027 L
.14383 .07729 L
.14384 .0883 L
.14386 .07483 L
.14387 .12013 L
.14389 .11759 L
.14394 .10385 L
.14395 .10519 L
.14396 .06635 L
.14397 .10152 L
.14398 .09745 L
.14399 .08144 L
.14401 .10465 L
.14402 .11236 L
.14403 .15595 L
.14404 .11342 L
.14405 .08797 L
.14407 .10679 L
.14408 .07567 L
.14409 .12403 L
.14411 .10645 L
.14412 .0965 L
.14413 .1602 L
.14415 .09937 L
.14416 .11614 L
.14417 .11085 L
.14419 .07801 L
.1442 .11075 L
.14421 .13582 L
.14423 .07461 L
.14424 .1183 L
.14425 .06546 L
.14427 .07282 L
.14428 .1245 L
.1443 .12803 L
.14431 .12325 L
.14433 .11733 L
.14434 .10644 L
.14435 .11201 L
.14436 .12022 L
.14436 .09369 L
.14437 .11517 L
.14439 .12407 L
Mistroke
.1444 .07964 L
.14441 .09566 L
.14442 .13043 L
.14443 .13514 L
.14445 .1009 L
.14446 .12798 L
.14448 .10217 L
.14449 .10169 L
.1445 .12023 L
.14451 .10309 L
.14452 .14688 L
.14453 .1169 L
.14454 .09572 L
.14456 .13958 L
.14457 .12745 L
.14459 .05539 L
.14459 .10789 L
.1446 .08331 L
.14461 .06441 L
.14462 .12998 L
.14463 .08251 L
.14465 .06503 L
.14466 .15326 L
.14467 .11453 L
.14468 .09502 L
.14469 .09094 L
.1447 .11067 L
.14471 .15324 L
.14472 .09335 L
.14473 .10465 L
.14475 .1138 L
.14476 .10853 L
.14478 .07747 L
.14479 .09992 L
.1448 .07527 L
.14482 .08768 L
.14483 .10224 L
.14484 .09596 L
.14485 .11238 L
.14485 .09607 L
.14486 .06553 L
.14488 .07964 L
.14489 .09573 L
.1449 .13722 L
.14491 .11178 L
.14492 .10562 L
.14494 .14415 L
.14495 .11474 L
.14497 .07215 L
.14498 .14346 L
Mistroke
.14499 .08907 L
.145 .097 L
.14502 .08801 L
.14503 .09126 L
.14505 .08573 L
.14506 .08216 L
.14507 .11349 L
.14508 .11812 L
.14509 .10213 L
.14511 .0962 L
.14512 .10411 L
.14512 .10194 L
.14513 .10539 L
.14514 .11576 L
.14516 .11428 L
.14517 .09865 L
.14518 .10466 L
.14519 .12698 L
.1452 .11778 L
.14521 .07997 L
.14522 .08652 L
.14523 .10173 L
.14524 .11236 L
.14525 .12328 L
.14527 .15223 L
.14528 .08963 L
.14529 .09919 L
.14531 .10123 L
.14532 .13099 L
.14534 .08269 L
.14535 .0835 L
.14535 .09682 L
.14537 .13481 L
.14538 .11292 L
.14539 .11253 L
.1454 .08657 L
.14542 .08286 L
.14543 .13314 L
.14544 .09726 L
.14546 .12973 L
.14547 .13426 L
.14548 .08741 L
.14549 .14632 L
.14551 .1237 L
.14552 .0964 L
.14554 .10622 L
.14555 .1374 L
.14556 .11038 L
.14558 .13049 L
.14559 .09775 L
Mistroke
.14561 .10874 L
.14562 .13104 L
.14564 .08332 L
.14565 .11534 L
.14566 .12075 L
.14567 .09043 L
.14568 .1048 L
.14569 .1051 L
.14571 .10523 L
.14572 .12639 L
.14573 .11418 L
.14574 .08929 L
.14576 .11722 L
.14576 .12279 L
.14577 .11503 L
.14579 .11605 L
.1458 .12115 L
.14582 .10295 L
.14583 .09594 L
.14585 .13613 L
.14586 .11404 L
.14587 .10185 L
.14589 .09265 L
.1459 .13539 L
.14592 .12391 L
.14593 .11802 L
.14594 .08008 L
.14595 .0566 L
.14596 .12612 L
.14598 .10545 L
.14599 .10757 L
.14601 .07084 L
.14602 .12396 L
.14603 .12048 L
.14604 .10098 L
.14605 .06761 L
.14606 .14715 L
.14607 .10397 L
.14608 .11676 L
.14609 .06521 L
.1461 .09525 L
.14611 .14169 L
.14611 .05823 L
.14612 .09503 L
.14614 .10075 L
.14615 .11182 L
.14617 .07036 L
.14617 .12256 L
.14618 .08913 L
.1462 .08866 L
Mistroke
.14621 .08841 L
.14622 .10818 L
.14624 .09557 L
.14625 .117 L
.14627 .07976 L
.14628 .07821 L
.14629 .08072 L
.1463 .15416 L
.14631 .09186 L
.14632 .07164 L
.14633 .11402 L
.14634 .09833 L
.14636 .08903 L
.14637 .10021 L
.14639 .14019 L
.1464 .09825 L
.14641 .09886 L
.14643 .08817 L
.14644 .08868 L
.14645 .10983 L
.14647 .12251 L
.14648 .06813 L
.14649 .10648 L
.14651 .11125 L
.14652 .10093 L
.14654 .05728 L
.14655 .10189 L
.14656 .13755 L
.14658 .03369 L
.14659 .11651 L
.14661 .11944 L
.14662 .13037 L
.14664 .09745 L
.14665 .09098 L
.14667 .11021 L
.14668 .1403 L
.14669 .10115 L
.1467 .10907 L
.14671 .09368 L
.14673 .08513 L
.14674 .07845 L
.14676 .09927 L
.14677 .09204 L
.14678 .11265 L
.1468 .07972 L
.14681 .12296 L
.14681 .09736 L
.14683 .10568 L
.14684 .1565 L
.14686 .1318 L
Mistroke
.14688 .1119 L
.14689 .07982 L
.14691 .08215 L
.14692 .12582 L
.14692 .0966 L
.14693 .11766 L
.14694 .10998 L
.14696 .14015 L
.14697 .07885 L
.14697 .1196 L
.14699 .10994 L
.147 .08484 L
.14702 .10032 L
.14703 .06505 L
.14705 .05603 L
.14706 .08506 L
.14706 .0697 L
.14708 .06801 L
.14709 .11393 L
.14711 .12043 L
.14712 .10215 L
.14714 .08865 L
.14715 .08546 L
.14716 .12707 L
.14717 .12976 L
.14718 .09727 L
.1472 .12863 L
.14721 .10575 L
.14722 .11335 L
.14723 .08347 L
.14724 .0909 L
.14724 .07364 L
.14726 .08212 L
.14727 .06562 L
.14728 .10418 L
.14729 .12079 L
.1473 .10093 L
.14732 .11951 L
.14733 .09403 L
.14735 .07777 L
.14736 .11298 L
.14738 .06349 L
.14739 .13813 L
.1474 .11709 L
.14741 .12747 L
.14743 .12725 L
.14744 .05125 L
.14745 .11012 L
.14747 .09856 L
.14748 .07264 L
Mistroke
.1475 .13004 L
.14751 .11219 L
.14752 .1013 L
.14753 .13218 L
.14754 .08969 L
.14756 .07059 L
.14757 .10254 L
.14758 .14751 L
.14759 .1102 L
.1476 .06187 L
.14762 .09269 L
.14763 .1126 L
.14764 .09201 L
.14765 .14731 L
.14767 .08177 L
.14768 .11132 L
.14769 .0843 L
.1477 .09844 L
.14772 .13311 L
.14773 .13489 L
.14773 .08202 L
.14775 .09834 L
.14776 .12693 L
.14778 .1287 L
.14779 .08405 L
.1478 .11271 L
.14782 .12767 L
.14783 .09853 L
.14784 .11996 L
.14786 .11443 L
.14787 .10393 L
.14789 .12274 L
.1479 .14515 L
.14791 .11787 L
.14793 .08103 L
.14794 .07497 L
.14795 .08918 L
.14797 .11524 L
.14798 .07727 L
.148 .10016 L
.14801 .05188 L
.14803 .05542 L
.14804 .11987 L
.14805 .09107 L
.14806 .11469 L
.14807 .1244 L
.14807 .10559 L
.14809 .11404 L
.1481 .10819 L
.14811 .08709 L
Mistroke
.14812 .13571 L
.14813 .09644 L
.14815 .11976 L
.14816 .14686 L
.14817 .15502 L
.14819 .09706 L
.1482 .09203 L
.14822 .09262 L
.14823 .12179 L
.14825 .07986 L
.14826 .1205 L
.14828 .09273 L
.14828 .13061 L
.14829 .08082 L
.14831 .08086 L
.14832 .09853 L
.14834 .0676 L
.14835 .08891 L
.14837 .117 L
.14837 .10441 L
.14838 .11829 L
.1484 .10731 L
.14841 .12197 L
.14841 .08359 L
.14842 .12135 L
.14843 .14061 L
.14844 .13082 L
.14845 .08496 L
.14846 .05939 L
.14847 .11485 L
.14848 .06398 L
.1485 .05905 L
.14851 .08163 L
.14853 .1022 L
.14854 .0817 L
.14856 .11429 L
.14857 .09408 L
.14858 .1005 L
.1486 .11471 L
.14861 .10519 L
.14862 .11187 L
.14864 .12103 L
.14865 .10875 L
.14867 .09497 L
.14868 .08684 L
.14869 .07814 L
.1487 .12534 L
.14872 .07239 L
.14873 .08134 L
.14874 .10064 L
Mistroke
.14876 .14287 L
.14877 .1033 L
.14879 .08734 L
.1488 .1476 L
.14881 .08139 L
.14882 .09591 L
.14884 .10754 L
.14886 .12321 L
.14888 .12533 L
.14889 .14335 L
.1489 .10142 L
.14891 .11334 L
.14892 .08241 L
.14894 .09552 L
.14895 .09309 L
.14897 .11593 L
.14898 .09437 L
.14899 .11948 L
.14901 .11318 L
.14902 .10977 L
.14903 .0792 L
.14904 .10572 L
.14905 .11387 L
.14907 .11589 L
.14908 .08536 L
.14909 .10805 L
.14911 .09198 L
.14912 .09611 L
.14913 .09671 L
.14915 .14009 L
.14916 .09898 L
.14918 .07508 L
.14919 .10047 L
.1492 .12239 L
.14921 .09821 L
.14922 .11195 L
.14924 .10832 L
.14925 .12328 L
.14925 .0853 L
.14927 .12768 L
.14928 .06914 L
.14929 .1058 L
.14929 .08565 L
.1493 .11299 L
.14932 .07477 L
.14933 .07443 L
.14934 .11194 L
.14935 .07984 L
.14937 .10158 L
.14938 .11239 L
Mistroke
.14939 .08349 L
.14941 .0944 L
.14942 .10685 L
.14944 .13474 L
.14945 .1407 L
.14947 .05079 L
.14948 .11653 L
.14949 .1093 L
.1495 .1232 L
.14952 .11401 L
.14953 .0961 L
.14955 .08205 L
.14955 .12018 L
.14956 .09816 L
.14958 .10655 L
.14959 .0826 L
.1496 .09345 L
.1496 .12431 L
.14961 .08695 L
.14963 .08198 L
.14964 .113 L
.14965 .10967 L
.14966 .14295 L
.14967 .04218 L
.14968 .11207 L
.14969 .11027 L
.14971 .08231 L
.14972 .07512 L
.14972 .11818 L
.14974 .1315 L
.14975 .06578 L
.14977 .07422 L
.14978 .10371 L
.14979 .07766 L
.1498 .11205 L
.14981 .05104 L
.14983 .09091 L
.14983 .09517 L
.14984 .1412 L
.14985 .09514 L
.14986 .08945 L
.14987 .09937 L
.14989 .11558 L
.1499 .08185 L
.14991 .0867 L
.14992 .07194 L
.14994 .09432 L
.14995 .14551 L
.14996 .06661 L
.14998 .0654 L
Mistroke
.14999 .13176 L
.15 .12218 L
.15001 .08398 L
.15002 .15989 L
.15004 .09935 L
.15005 .11344 L
.15007 .11749 L
.15008 .12167 L
.15009 .09145 L
.1501 .0916 L
.15012 .10081 L
.15013 .11726 L
.15015 .09535 L
.15016 .08666 L
.15017 .14586 L
.15018 .1371 L
.15019 .09585 L
.15021 .07919 L
.15022 .14093 L
.15023 .09172 L
.15024 .08147 L
.15025 .08564 L
.15026 .10897 L
.15027 .08528 L
.15028 .06738 L
.15029 .09245 L
.1503 .10447 L
.15032 .11082 L
.15033 .10988 L
.15035 .09822 L
.15036 .08632 L
.15036 .12068 L
.15038 .12281 L
.15039 .09964 L
.1504 .10105 L
.15041 .11476 L
.15043 .10364 L
.15044 .0885 L
.15045 .1315 L
.15047 .09595 L
.15048 .10988 L
.1505 .07014 L
.15051 .08441 L
.15052 .12322 L
.15053 .10901 L
.15054 .10758 L
.15055 .12608 L
.15057 .06959 L
.15058 .09857 L
.1506 .11819 L
Mistroke
.15061 .09589 L
.15063 .09512 L
.15064 .08462 L
.15066 .07504 L
.15067 .06832 L
.15069 .12006 L
.1507 .08745 L
.15071 .10388 L
.15072 .10077 L
.15072 .09433 L
.15074 .09047 L
.15075 .13654 L
.15076 .08917 L
.15077 .06734 L
.15079 .07065 L
.1508 .11499 L
.15081 .0969 L
.15082 .10513 L
.15083 .11903 L
.15085 .09987 L
.15085 .13036 L
.15086 .12633 L
.15088 .15326 L
.15089 .09835 L
.15091 .09712 L
.15092 .0853 L
.15093 .16061 L
.15095 .07166 L
.15096 .13585 L
.15097 .12254 L
.15098 .09347 L
.151 .05716 L
.15101 .11797 L
.15102 .12811 L
.15104 .1098 L
.15105 .14239 L
.15107 .08719 L
.15108 .08843 L
.15109 .11042 L
.15111 .08809 L
.15112 .0836 L
.15113 .12426 L
.15114 .12996 L
.15115 .13193 L
.15116 .10153 L
.15117 .09366 L
.15118 .11395 L
.1512 .09233 L
.15121 .07079 L
.15123 .1053 L
Mistroke
.15124 .12659 L
.15124 .11161 L
.15125 .14987 L
.15126 .11245 L
.15128 .10422 L
.15129 .14946 L
.1513 .09257 L
.15131 .11976 L
.15132 .10939 L
.15133 .11089 L
.15134 .06415 L
.15135 .14975 L
.15136 .11569 L
.15137 .10555 L
.15139 .09897 L
.1514 .11051 L
.15142 .09805 L
.15143 .12035 L
.15144 .12158 L
.15146 .09783 L
.15147 .11649 L
.15148 .09634 L
.15149 .1236 L
.1515 .10566 L
.1515 .10856 L
.15152 .10405 L
.15153 .09463 L
.15154 .10553 L
.15155 .1223 L
.15156 .12039 L
.15158 .14798 L
.1516 .10578 L
.15161 .11155 L
.15162 .09165 L
.15163 .06866 L
.15164 .08959 L
.15165 .13829 L
.15166 .09228 L
.15167 .12303 L
.15169 .08621 L
.1517 .09867 L
.15172 .08962 L
.15172 .12484 L
.15173 .07577 L
.15174 .10539 L
.15175 .09028 L
.15176 .06929 L
.15178 .088 L
.1518 .06975 L
.1518 .10192 L
Mistroke
.15181 .11821 L
.15182 .09034 L
.15183 .08032 L
.15184 .08583 L
.15185 .09914 L
.15186 .12917 L
.15186 .07831 L
.15188 .1294 L
.15189 .14245 L
.1519 .12414 L
.15191 .06392 L
.15193 .1204 L
.15194 .09718 L
.15195 .06672 L
.15196 .10394 L
.15197 .09319 L
.15199 .07737 L
.152 .09843 L
.15202 .09142 L
.15203 .13693 L
.15205 .09368 L
.15206 .11838 L
.15207 .05391 L
.15208 .11928 L
.1521 .1201 L
.15211 .12317 L
.15212 .06516 L
.15213 .11837 L
.15215 .08122 L
.15216 .13216 L
.15218 .15251 L
.15219 .12115 L
.15221 .06961 L
.15221 .09602 L
.15222 .11348 L
.15224 .12927 L
.15225 .10086 L
.15225 .09339 L
.15226 .13388 L
.15227 .11727 L
.15229 .04366 L
.1523 .12554 L
.15231 .12049 L
.15232 .08075 L
.15233 .06961 L
.15234 .1228 L
.15235 .10901 L
.15236 .12154 L
.15237 .09467 L
.15238 .07383 L
Mistroke
.1524 .10629 L
.15241 .07837 L
.15242 .09438 L
.15244 .0743 L
.15245 .09518 L
.15247 .09109 L
.15248 .1241 L
.15248 .07563 L
.1525 .05024 L
.15251 .1028 L
.15251 .07821 L
.15253 .09933 L
.15254 .13515 L
.15256 .10254 L
.15257 .04876 L
.15259 .10161 L
.1526 .10791 L
.15261 .1024 L
.15262 .10999 L
.15264 .1016 L
.15265 .09579 L
.15267 .1393 L
.15268 .12707 L
.15269 .09417 L
.15271 .09058 L
.15272 .11245 L
.15274 .08427 L
.15275 .092 L
.15276 .1082 L
.15278 .12014 L
.15279 .08249 L
.15279 .09149 L
.15281 .13076 L
.15282 .10965 L
.15283 .11555 L
.15284 .08335 L
.15285 .06932 L
.15286 .10823 L
.15287 .10231 L
.15289 .12253 L
.15289 .1118 L
.1529 .10499 L
.15291 .12672 L
.15292 .10409 L
.15294 .11203 L
.15294 .06349 L
.15295 .13365 L
.15297 .12367 L
.15298 .09263 L
.153 .10168 L
Mistroke
.15301 .10173 L
.15302 .10421 L
.15304 .08427 L
.15305 .11585 L
.15307 .09344 L
.15308 .11381 L
.15309 .10017 L
.1531 .10093 L
.15311 .10867 L
.15313 .07405 L
.15314 .1217 L
.15316 .0964 L
.15317 .12974 L
.15318 .11712 L
.1532 .08505 L
.15321 .09154 L
.15324 .10279 L
.15325 .06498 L
.15326 .1129 L
.15328 .10437 L
.15329 .1347 L
.1533 .10482 L
.15331 .08375 L
.15332 .1148 L
.15334 .10958 L
.15335 .0932 L
.15337 .08599 L
.15337 .10691 L
.15338 .10387 L
.1534 .0658 L
.15341 .07434 L
.15342 .11785 L
.15344 .11841 L
.15345 .12043 L
.15347 .10273 L
.15348 .08664 L
.15349 .11279 L
.1535 .11724 L
.15351 .10768 L
.15353 .06801 L
.15353 .11334 L
.15354 .09184 L
.15355 .12677 L
.15356 .13788 L
.15357 .09075 L
.15358 .09035 L
.15359 .12465 L
.15359 .11726 L
.15361 .13071 L
.15362 .15087 L
Mistroke
.15364 .10095 L
.15365 .1037 L
.15366 .1274 L
.15367 .11609 L
.15369 .11483 L
.1537 .10437 L
.15371 .07496 L
.15373 .08841 L
.15374 .07902 L
.15376 .11426 L
.15377 .07372 L
.15377 .10953 L
.15379 .08588 L
.1538 .09811 L
.15381 .05685 L
.15382 .09732 L
.15384 .09773 L
.15385 .11371 L
.15387 .13382 L
.15387 .09131 L
.15388 .06903 L
.15389 .11471 L
.1539 .10105 L
.15391 .07643 L
.15393 .10939 L
.15394 .09409 L
.15395 .11682 L
.15396 .11028 L
.15397 .1248 L
.15398 .08481 L
.15399 .10538 L
.154 .08546 L
.15401 .09696 L
.15401 .09497 L
.15403 .09915 L
.15405 .13201 L
.15406 .10416 L
.15407 .07686 L
.15408 .10881 L
.15409 .09664 L
.1541 .10443 L
.15411 .09498 L
.15412 .11405 L
.15412 .12666 L
.15414 .12581 L
.15415 .08726 L
.15417 .08522 L
.15418 .11592 L
.15419 .07028 L
.1542 .0957 L
Mistroke
.15421 .1128 L
.15423 .09807 L
.15424 .11796 L
.15426 .14925 L
.15426 .13749 L
.15427 .10586 L
.15429 .08755 L
.1543 .11285 L
.15431 .06376 L
.15433 .10637 L
.15434 .13174 L
.15436 .09376 L
.15437 .07233 L
.15438 .10636 L
.15439 .0875 L
.1544 .08602 L
.15441 .08421 L
.15442 .11152 L
.15443 .11806 L
.15445 .08853 L
.15446 .09821 L
.15448 .12888 L
.15449 .09258 L
.1545 .12643 L
.15452 .13072 L
.15453 .10753 L
.15454 .10092 L
.15456 .15826 L
.15457 .12988 L
.15459 .08748 L
.1546 .14903 L
.15461 .12957 L
.15463 .11691 L
.15464 .0953 L
.15465 .10392 L
.15467 .09312 L
.15468 .11328 L
.1547 .12235 L
.15471 .13428 L
.15471 .06903 L
.15473 .15582 L
.15475 .08106 L
.15475 .1299 L
.15476 .09085 L
.15478 .09597 L
.15479 .09891 L
.1548 .11688 L
.15481 .07453 L
.15482 .06025 L
.15484 .09841 L
Mistroke
.15485 .11968 L
.15487 .08382 L
.15488 .11736 L
.15489 .13438 L
.15491 .14228 L
.15492 .13574 L
.15494 .07463 L
.15495 .13907 L
.15497 .12007 L
.15497 .07834 L
.15498 .06838 L
.155 .15009 L
.15501 .10299 L
.15503 .09043 L
.15504 .0716 L
.15506 .10487 L
.15506 .10985 L
.15507 .15047 L
.15509 .10332 L
.1551 .1131 L
.15511 .09834 L
.15511 .05904 L
.15512 .07722 L
.15514 .07915 L
.15515 .11419 L
.15516 .09029 L
.15517 .11124 L
.15518 .13183 L
.15519 .07169 L
.1552 .08558 L
.15521 .0942 L
.15522 .12658 L
.15523 .11221 L
.15525 .0998 L
.15526 .11063 L
.15527 .13028 L
.15529 .12201 L
.1553 .10829 L
.15532 .05613 L
.15533 .12701 L
.15533 .09063 L
.15535 .13743 L
.15536 .09343 L
.15537 .13914 L
.15538 .04547 L
.1554 .11095 L
.15541 .09865 L
.15542 .07825 L
.15544 .12687 L
.15545 .15993 L
Mistroke
.15546 .09497 L
.15548 .0685 L
.15549 .09115 L
.1555 .12536 L
.15552 .08178 L
.15553 .10805 L
.15554 .07241 L
.15556 .12536 L
.15557 .06484 L
.15559 .1394 L
.1556 .13707 L
.15562 .0906 L
.15563 .09044 L
.15564 .14047 L
.15566 .09048 L
.15567 .06322 L
.15568 .08893 L
.15569 .09384 L
.1557 .11973 L
.15571 .08928 L
.15572 .11562 L
.15574 .13005 L
.15574 .10636 L
.15575 .08268 L
.15577 .11377 L
.15578 .06301 L
.1558 .10367 L
.15581 .10425 L
.15583 .09242 L
.15584 .1389 L
.15585 .1031 L
.15587 .12768 L
.15588 .11361 L
.1559 .08869 L
.15591 .14949 L
.15592 .09706 L
.15593 .14287 L
.15594 .09703 L
.15596 .09546 L
.15597 .08809 L
.15599 .11755 L
.156 .10141 L
.15601 .07938 L
.15602 .08446 L
.15603 .12438 L
.15604 .13299 L
.15605 .10175 L
.15606 .07684 L
.15607 .08171 L
.15613 .11169 L
Mistroke
.15614 .07451 L
.15615 .11598 L
.15616 .12626 L
.15618 .10115 L
.15619 .11318 L
.1562 .10043 L
.15621 .08906 L
.15623 .09899 L
.15624 .11264 L
.15625 .08834 L
.15627 .1112 L
.15629 .13997 L
.15629 .15694 L
.1563 .07428 L
.15631 .14224 L
.15632 .11761 L
.15633 .07284 L
.15634 .10199 L
.15635 .13495 L
.15636 .06705 L
.15637 .10291 L
.15638 .08612 L
.15639 .14046 L
.1564 .07558 L
.15642 .07448 L
.15643 .09181 L
.15644 .07244 L
.15645 .07586 L
.15646 .13916 L
.15647 .12909 L
.15648 .07428 L
.15649 .10596 L
.1565 .10578 L
.15651 .0811 L
.15651 .10256 L
.15653 .10471 L
.15654 .08537 L
.15655 .07719 L
.15656 .10238 L
.15657 .13881 L
.15659 .13638 L
.1566 .13063 L
.15662 .09156 L
.15663 .07025 L
.15664 .10717 L
.15666 .1045 L
.15667 .09566 L
.15669 .12212 L
.1567 .12702 L
.15672 .12668 L
Mistroke
.15672 .10026 L
.15673 .09736 L
.15675 .12225 L
.15676 .1187 L
.15676 .09925 L
.15677 .12375 L
.15678 .1221 L
.15679 .05936 L
.1568 .12007 L
.15681 .08239 L
.15683 .0803 L
.15684 .08632 L
.15686 .10819 L
.15687 .08894 L
.15688 .07333 L
.1569 .1211 L
.15691 .08605 L
.15692 .09188 L
.15694 .10659 L
.15695 .07271 L
.15696 .08399 L
.15698 .0846 L
.15699 .13008 L
.157 .11135 L
.15702 .15253 L
.15703 .06525 L
.15704 .06215 L
.15705 .11866 L
.15706 .06993 L
.15708 .12399 L
.15709 .1024 L
.15711 .09172 L
.15712 .08965 L
.15714 .11605 L
.15715 .08948 L
.15716 .13479 L
.15718 .1011 L
.15719 .08863 L
.1572 .13083 L
.15722 .1145 L
.15723 .1214 L
.15725 .11239 L
.15726 .09952 L
.15728 .10517 L
.15729 .08421 L
.1573 .07961 L
.15731 .08986 L
.15733 .1329 L
.15734 .06812 L
.15735 .11869 L
Mistroke
.15737 .08063 L
.15738 .11866 L
.15739 .11102 L
.1574 .05749 L
.15742 .11388 L
.15743 .14107 L
.15744 .10276 L
.15746 .13315 L
.15747 .12736 L
.15749 .09145 L
.1575 .08641 L
.15751 .06583 L
.15752 .10881 L
.15753 .09686 L
.15755 .12841 L
.15756 .09007 L
.15758 .12902 L
.15759 .11181 L
.1576 .09509 L
.15762 .08667 L
.15763 .12937 L
.15765 .09243 L
.15766 .08814 L
.15767 .10891 L
.15769 .10611 L
.1577 .09561 L
.15772 .1396 L
.15773 .10058 L
.15774 .13249 L
.15775 .10531 L
.15777 .11907 L
.15778 .1206 L
.15779 .08731 L
.15781 .11344 L
.15782 .11588 L
.15784 .10438 L
.15785 .14101 L
.15786 .15161 L
.15787 .09643 L
.15789 .09769 L
.1579 .10758 L
.15791 .09846 L
.15793 .10078 L
.15794 .10639 L
.15796 .10959 L
.15796 .08351 L
.15797 .07861 L
.15799 .10361 L
.158 .10161 L
.15801 .13742 L
Mistroke
.15803 .10214 L
.15804 .11218 L
.15806 .10028 L
.15807 .12115 L
.15809 .14412 L
.1581 .14551 L
.15811 .09003 L
.15812 .08198 L
.15813 .11792 L
.15814 .07756 L
.15815 .10217 L
.15816 .0867 L
.15818 .12252 L
.15819 .11311 L
.15821 .09558 L
.15822 .13438 L
.15824 .09938 L
.15825 .09531 L
.15826 .09712 L
.15828 .05334 L
.15829 .09387 L
.15831 .0858 L
.15832 .10586 L
.15834 .11109 L
.15835 .09386 L
.15836 .09999 L
.15838 .14605 L
.15839 .09504 L
.15841 .12634 L
.15842 .12158 L
.15843 .09181 L
.15844 .11803 L
.15846 .12229 L
.15847 .12152 L
.15848 .07888 L
.15849 .10592 L
.1585 .0949 L
.15852 .09751 L
.15853 .09868 L
.15854 .07621 L
.15856 .12584 L
.15857 .09312 L
.15858 .07351 L
.15859 .09503 L
.1586 .06734 L
.15862 .1356 L
.15863 .16429 L
.15863 .11253 L
.15865 .09447 L
.15866 .10191 L
Mistroke
.15868 .13245 L
.15869 .09044 L
.1587 .10936 L
.15872 .11197 L
.15873 .10068 L
.15874 .10696 L
.15876 .10389 L
.15877 .08338 L
.15879 .13737 L
.1588 .09251 L
.15881 .09641 L
.15883 .12931 L
.15884 .10424 L
.15885 .07933 L
.15887 .06027 L
.15888 .08778 L
.1589 .09342 L
.15891 .1329 L
.15893 .08345 L
.15893 .08257 L
.15894 .13438 L
.15896 .12272 L
.15897 .10748 L
.15899 .10314 L
.159 .12886 L
.15901 .0607 L
.15903 .10377 L
.15904 .0735 L
.15906 .12899 L
.15907 .11053 L
.15908 .0801 L
.15909 .09422 L
.1591 .07884 L
.15911 .09481 L
.15912 .1204 L
.15913 .12749 L
.15915 .1263 L
.15916 .05963 L
.15917 .07616 L
.15919 .10964 L
.1592 .13331 L
.15922 .09786 L
.15923 .08818 L
.15924 .13414 L
.15925 .08822 L
.15927 .11203 L
.15928 .14084 L
.1593 .12392 L
.15931 .10848 L
.15932 .11176 L
Mistroke
.15934 .11062 L
.15935 .11945 L
.15935 .12868 L
.15937 .09328 L
.15938 .10958 L
.15939 .0982 L
.1594 .10643 L
.15942 .11548 L
.15942 .10738 L
.15943 .11487 L
.15945 .11154 L
.15946 .12894 L
.15948 .12215 L
.15949 .09054 L
.1595 .09974 L
.15951 .09475 L
.15952 .06494 L
.15953 .06989 L
.15954 .09759 L
.15956 .09923 L
.15956 .08149 L
.15957 .1494 L
.15959 .09966 L
.1596 .11626 L
.15961 .08397 L
.15962 .10658 L
.15963 .11913 L
.15964 .08647 L
.15965 .06447 L
.15967 .11719 L
.15968 .1024 L
.15969 .08733 L
.1597 .07427 L
.15971 .11698 L
.15972 .10224 L
.15973 .11905 L
.15973 .1255 L
.15974 .11754 L
.15975 .10891 L
.15977 .07913 L
.15978 .13264 L
.15979 .11959 L
.15981 .09676 L
.15982 .13655 L
.15983 .10851 L
.15984 .12336 L
.15985 .13504 L
.15987 .13062 L
.15988 .10484 L
.1599 .10875 L
Mistroke
.15991 .12728 L
.15992 .12197 L
.15994 .10145 L
.15995 .10798 L
.15997 .09312 L
.15997 .07978 L
.15998 .12024 L
.15999 .10839 L
.16 .10929 L
.16001 .12253 L
.16002 .08974 L
.16003 .0966 L
.16004 .09245 L
.16005 .05247 L
.16006 .15168 L
.16008 .10354 L
.16009 .1098 L
.16011 .12861 L
.16012 .0908 L
.16013 .09042 L
.16015 .11609 L
.16016 .09002 L
.16017 .11871 L
.16019 .14104 L
.1602 .06969 L
.16021 .13423 L
.16023 .09263 L
.16024 .086 L
.16025 .07393 L
.16027 .11658 L
.16028 .12543 L
.16029 .12008 L
.1603 .07782 L
.16031 .07591 L
.16033 .08269 L
.16034 .11057 L
.16036 .145 L
.16037 .11313 L
.16039 .09775 L
.1604 .09735 L
.16041 .12137 L
.16043 .09864 L
.16044 .09336 L
.16045 .09097 L
.16047 .08876 L
.16048 .11543 L
.1605 .10956 L
.16051 .1264 L
.16052 .10548 L
.16053 .15026 L
Mistroke
.16054 .13111 L
.16055 .12749 L
.16056 .12373 L
.16058 .08313 L
.16059 .12805 L
.1606 .1238 L
.16062 .08418 L
.16063 .12565 L
.16065 .10094 L
.16066 .11736 L
.16067 .10693 L
.16069 .09498 L
.1607 .08324 L
.16072 .08906 L
.16073 .07295 L
.16074 .11094 L
.16075 .08841 L
.16077 .11434 L
.16078 .08904 L
.16079 .09677 L
.16081 .09337 L
.16083 .10014 L
.16084 .06933 L
.16085 .11353 L
.16087 .14162 L
.16088 .10936 L
.16089 .09052 L
.16091 .0858 L
.16092 .08424 L
.16094 .07706 L
.16095 .11467 L
.16097 .12739 L
.16098 .11164 L
.16098 .11004 L
.161 .08034 L
.16101 .14107 L
.16103 .09243 L
.16104 .09656 L
.16106 .13302 L
.16107 .10119 L
.16108 .0914 L
.16109 .10132 L
.16111 .09981 L
.16112 .12318 L
.16113 .11261 L
.16115 .11784 L
.16116 .12612 L
.16118 .13309 L
.16119 .11435 L
.16121 .08997 L
Mistroke
.16122 .11333 L
.16123 .09809 L
.16125 .07297 L
.16126 .10915 L
.16128 .11148 L
.16129 .09965 L
.16131 .08021 L
.16131 .12114 L
.16132 .10603 L
.16134 .09339 L
.16135 .11888 L
.16136 .06645 L
.16138 .11036 L
.16139 .09672 L
.1614 .11705 L
.16142 .08606 L
.16143 .07868 L
.16145 .16083 L
.16146 .10323 L
.16147 .07839 L
.16148 .11192 L
.16149 .11566 L
.16151 .12115 L
.16152 .10556 L
.16153 .11031 L
.16154 .08755 L
.16155 .09303 L
.16156 .08355 L
.16157 .08833 L
.16158 .12301 L
.16159 .11656 L
.1616 .08043 L
.16161 .09373 L
.16162 .13346 L
.16163 .13805 L
.16165 .11747 L
.16166 .11612 L
.16168 .11645 L
.16169 .10312 L
.16171 .07086 L
.16172 .08981 L
.16173 .07666 L
.16174 .07487 L
.16175 .11879 L
.16176 .10734 L
.16177 .10194 L
.16178 .06802 L
.1618 .12415 L
.16181 .14485 L
.16183 .09747 L
Mistroke
.16184 .15244 L
.16185 .1068 L
.16185 .10407 L
.16186 .12241 L
.16188 .08964 L
.16189 .12061 L
.1619 .11478 L
.16191 .10651 L
.16193 .12445 L
.16194 .13389 L
.16194 .1136 L
.16195 .12471 L
.16196 .09522 L
.16197 .11508 L
.16198 .10573 L
.16199 .06448 L
.16201 .06946 L
.16202 .11949 L
.16204 .09609 L
.16205 .10668 L
.16205 .12188 L
.16206 .10423 L
.16207 .08747 L
.16208 .10531 L
.16209 .1052 L
.1621 .11171 L
.16212 .08558 L
.16213 .07702 L
.16214 .07512 L
.16216 .11416 L
.16217 .05531 L
.16217 .11886 L
.16219 .11049 L
.1622 .12877 L
.16222 .06456 L
.16223 .08329 L
.16223 .07026 L
.16225 .09973 L
.16226 .08645 L
.16228 .11734 L
.16229 .06193 L
.1623 .11682 L
.16232 .08023 L
.16233 .07992 L
.16234 .13564 L
.16235 .10937 L
.16237 .13081 L
.16237 .08077 L
.16238 .12227 L
.1624 .10504 L
Mistroke
.16241 .13521 L
.16243 .1131 L
.16244 .13032 L
.16245 .12196 L
.16247 .08666 L
.16248 .09783 L
.16249 .11738 L
.16251 .13904 L
.16252 .11769 L
.16253 .09956 L
.16255 .11475 L
.16256 .14279 L
.16257 .09105 L
.16259 .09516 L
.1626 .12345 L
.16262 .12284 L
.16263 .11693 L
.16265 .08031 L
.16266 .13888 L
.16267 .09641 L
.16268 .0795 L
.16269 .07258 L
.16271 .12391 L
.16272 .08978 L
.16272 .10224 L
.16274 .06734 L
.16275 .12313 L
.16276 .10568 L
.16277 .12771 L
.16278 .13577 L
.1628 .07321 L
.16281 .12811 L
.16283 .10831 L
.16284 .08742 L
.16286 .04685 L
.16287 .12372 L
.16288 .1025 L
.1629 .09862 L
.16291 .07173 L
.16293 .11487 L
.16293 .1249 L
.16294 .11249 L
.16296 .11049 L
.16297 .12866 L
.16299 .09014 L
.163 .1226 L
.16302 .07964 L
.16303 .13888 L
.16303 .08757 L
.16305 .09667 L
Mistroke
.16306 .11181 L
.16307 .11269 L
.16308 .12328 L
.16308 .13782 L
.16309 .10227 L
.1631 .09857 L
.16311 .06122 L
.16312 .10411 L
.16313 .09518 L
.16315 .13461 L
.16316 .1186 L
.16317 .10134 L
.16318 .12778 L
.16319 .12004 L
.16321 .12159 L
.16322 .12411 L
.16323 .13028 L
.16325 .09434 L
.16326 .13822 L
.16328 .11343 L
.16329 .1066 L
.16329 .10654 L
.16331 .11863 L
.16332 .12067 L
.16333 .05703 L
.16334 .14752 L
.16336 .11935 L
.16337 .09682 L
.16338 .07719 L
.1634 .09991 L
.16341 .16902 L
.16343 .07491 L
.16344 .13817 L
.16345 .12202 L
.16347 .14863 L
.16348 .113 L
.1635 .07953 L
.16351 .16055 L
.16353 .10892 L
.16354 .12582 L
.16355 .08225 L
.16356 .08335 L
.16358 .08709 L
.16359 .07956 L
.1636 .11883 L
.16362 .12222 L
.16363 .11207 L
.16365 .13654 L
.16366 .10412 L
.16367 .08875 L
Mistroke
.16368 .08092 L
.1637 .12495 L
.1637 .11242 L
.16371 .07198 L
.16373 .13618 L
.16374 .07511 L
.16376 .06386 L
.16377 .07872 L
.16378 .11541 L
.1638 .12939 L
.16381 .07972 L
.16383 .11298 L
.16384 .10685 L
.16385 .09666 L
.16387 .08677 L
.16388 .13976 L
.1639 .11296 L
.16391 .13271 L
.16392 .05412 L
.16393 .11613 L
.16395 .11056 L
.16395 .09712 L
.16396 .12338 L
.16397 .10367 L
.16398 .10081 L
.16399 .13047 L
.164 .13733 L
.16401 .10438 L
.16402 .13884 L
.16403 .15403 L
.16404 .10264 L
.16404 .12238 L
.16405 .10215 L
.16406 .11594 L
.16408 .10447 L
.16409 .09283 L
.16411 .10501 L
.16412 .12939 L
.16414 .11797 L
.16415 .09526 L
.16416 .10031 L
.16418 .11688 L
.16419 .10035 L
.1642 .12894 L
.16422 .11594 L
.16423 .12895 L
.16425 .10575 L
.16426 .13621 L
.16428 .08457 L
.16429 .11771 L
Mistroke
.16429 .12205 L
.16431 .09167 L
.16433 .10827 L
.16434 .09688 L
.16435 .12111 L
.16437 .09447 L
.16438 .09519 L
.16439 .11148 L
.1644 .14325 L
.16442 .083 L
.16443 .13061 L
.16444 .08248 L
.16446 .09428 L
.16447 .08397 L
.16449 .12564 L
.1645 .1135 L
.16451 .07864 L
.16452 .09808 L
.16453 .0722 L
.16455 .10631 L
.16456 .09605 L
.16458 .09465 L
.16459 .08216 L
.1646 .08344 L
.16462 .09781 L
.16463 .11371 L
.16465 .07442 L
.16466 .07278 L
.16467 .09113 L
.16469 .10218 L
.1647 .086 L
.16472 .06738 L
.16473 .12967 L
.16473 .10205 L
.16474 .14605 L
.16475 .12243 L
.16476 .10902 L
.16478 .07313 L
.16479 .09707 L
.16481 .08346 L
.16482 .08628 L
.16484 .12334 L
.16485 .10081 L
.16487 .09943 L
.16488 .12118 L
.1649 .09328 L
.16491 .11311 L
.16492 .11693 L
.16494 .08247 L
.16495 .15295 L
Mistroke
.16496 .12283 L
.16497 .10622 L
.16499 .1334 L
.165 .08572 L
.16502 .14465 L
.16502 .13795 L
.16503 .09819 L
.16505 .08809 L
.16506 .13295 L
.16507 .10691 L
.16509 .10318 L
.1651 .09503 L
.16511 .10761 L
.16513 .07591 L
.16514 .09494 L
.16515 .09034 L
.16516 .08607 L
.16517 .10387 L
.16518 .1355 L
.16519 .1259 L
.16521 .07029 L
.16522 .08992 L
.16524 .1228 L
.16525 .08263 L
.16526 .11266 L
.16528 .11361 L
.16529 .11712 L
.1653 .06793 L
.16532 .11752 L
.16533 .08923 L
.16534 .06783 L
.16536 .09958 L
.16537 .08765 L
.16538 .10636 L
.1654 .09882 L
.16541 .07113 L
.16543 .06437 L
.16544 .08377 L
.16546 .10415 L
.16547 .10647 L
.16549 .07888 L
.16549 .11871 L
.1655 .14967 L
.16551 .04535 L
.16552 .08674 L
.16553 .08384 L
.16555 .10376 L
.16556 .08604 L
.16558 .1193 L
.16559 .1158 L
Mistroke
.16561 .1061 L
.16562 .10088 L
.16563 .11379 L
.16565 .1236 L
.16566 .10511 L
.16568 .1199 L
.16569 .09113 L
.16571 .09691 L
.16572 .08641 L
.16574 .09591 L
.16575 .11754 L
.16577 .0848 L
.16577 .07935 L
.16578 .09425 L
.1658 .11325 L
.16581 .10461 L
.16581 .09108 L
.16582 .12847 L
.16583 .06947 L
.16585 .12144 L
.16585 .11724 L
.16586 .10894 L
.16587 .11891 L
.16588 .11073 L
.16589 .11219 L
.16591 .10016 L
.16592 .09061 L
.16593 .13941 L
.16594 .05566 L
.16595 .08553 L
.16596 .10589 L
.16597 .12474 L
.16598 .11222 L
.16599 .13449 L
.16601 .11261 L
.16601 .05959 L
.16602 .12809 L
.16604 .12563 L
.16605 .07308 L
.16607 .0895 L
.16607 .09577 L
.16608 .08896 L
.1661 .10982 L
.16611 .08421 L
.16611 .05422 L
.16612 .07427 L
.16613 .0859 L
.16614 .1105 L
.16615 .14612 L
.16616 .10791 L
Mistroke
.16617 .05578 L
.16618 .07169 L
.16619 .0944 L
.1662 .10331 L
.16621 .10677 L
.16623 .07139 L
.16624 .15184 L
.16626 .12709 L
.16627 .11439 L
.16628 .06038 L
.16629 .08831 L
.1663 .09375 L
.16632 .09773 L
.16633 .08798 L
.16635 .09296 L
.16635 .0824 L
.16636 .10244 L
.16638 .1146 L
.16638 .08884 L
.16639 .0947 L
.1664 .13007 L
.16641 .09598 L
.16642 .09205 L
.16643 .06634 L
.16644 .07815 L
.16646 .1655 L
.16647 .09218 L
.16649 .14318 L
.1665 .14911 L
.16651 .07854 L
.16653 .09719 L
.16654 .11333 L
.16656 .09368 L
.16657 .13981 L
.16658 .10753 L
.16659 .10546 L
.1666 .10252 L
.16661 .11158 L
.16663 .11329 L
.16664 .1133 L
.16665 .1307 L
.16666 .12052 L
.16666 .10967 L
.16667 .09017 L
.16668 .11424 L
.1667 .09978 L
.16671 .13077 L
.16672 .11571 L
.16673 .10282 L
.16674 .10603 L
Mistroke
.16674 .11133 L
.16675 .06309 L
.16676 .13132 L
.16678 .12532 L
.16679 .12863 L
.16679 .12831 L
.1668 .13187 L
.16681 .09242 L
.16683 .14258 L
.16684 .10804 L
.16684 .1014 L
.16686 .08908 L
.16687 .12225 L
.16688 .11813 L
.16689 .09331 L
.16691 .10592 L
.16692 .1081 L
.16693 .11896 L
.16695 .0702 L
.16696 .10857 L
.16698 .07275 L
.16699 .10649 L
.16701 .09242 L
.16701 .07666 L
.16702 .12147 L
.16704 .07985 L
.16705 .15228 L
.16706 .05429 L
.16708 .07081 L
.16709 .10468 L
.1671 .08338 L
.16712 .08459 L
.16713 .10778 L
.16715 .1097 L
.16716 .10475 L
.16717 .08429 L
.16718 .14219 L
.16719 .10886 L
.16721 .12442 L
.16722 .10071 L
.16723 .10615 L
.16724 .13616 L
.16725 .10621 L
.16726 .09051 L
.16727 .1399 L
.16728 .12419 L
.16729 .10413 L
.1673 .09998 L
.16731 .11586 L
.16732 .091 L
Mistroke
.16733 .09862 L
.16735 .10263 L
.16736 .13049 L
.16738 .03823 L
.16739 .12335 L
.16741 .09307 L
.16742 .08016 L
.16743 .10718 L
.16744 .11024 L
.16745 .13628 L
.16746 .11464 L
.16747 .12997 L
.16748 .1484 L
.1675 .13303 L
.16751 .14053 L
.16753 .08689 L
.16754 .12361 L
.16755 .08745 L
.16755 .1044 L
.16756 .08527 L
.16758 .06302 L
.16759 .10624 L
.1676 .10887 L
.16761 .10917 L
.16763 .0986 L
.16763 .11619 L
.16764 .06769 L
.16765 .12711 L
.16766 .07694 L
.16767 .10472 L
.16768 .13002 L
.16769 .11549 L
.1677 .09202 L
.16771 .10822 L
.16772 .09419 L
.16773 .13166 L
.16774 .07284 L
.16776 .05791 L
.16776 .11814 L
.16777 .09588 L
.16779 .0639 L
.1678 .10616 L
.16782 .05785 L
.16783 .11929 L
.16784 .14014 L
.16786 .06652 L
.16787 .0977 L
.16787 .06761 L
.16789 .05679 L
.1679 .09604 L
Mistroke
.16792 .11083 L
.16793 .08864 L
.16793 .1373 L
.16795 .10061 L
.16796 .09691 L
.16798 .07884 L
.16799 .099 L
.168 .10809 L
.16802 .14467 L
.16803 .06318 L
.16805 .08404 L
.16806 .12411 L
.16808 .10619 L
.16809 .06159 L
.16811 .06598 L
.16812 .10765 L
.16812 .09227 L
.16814 .08776 L
.16815 .0555 L
.16817 .093 L
.16818 .1064 L
.1682 .06901 L
.16821 .11036 L
.16822 .0693 L
.16824 .12886 L
.16825 .10295 L
.16826 .10421 L
.16827 .09489 L
.16828 .08085 L
.16829 .11925 L
.16831 .11582 L
.16832 .06238 L
.16833 .09986 L
.16835 .11717 L
.16836 .08906 L
.16837 .10149 L
.16838 .11123 L
.16839 .09554 L
.16841 .10709 L
.16842 .12053 L
.16842 .12321 L
.16844 .1195 L
.16845 .083 L
.16846 .14113 L
.16847 .08378 L
.16848 .08853 L
.1685 .12346 L
.16851 .08891 L
.16853 .10436 L
.16854 .11265 L
Mistroke
.16856 .09274 L
.16857 .10356 L
.16858 .09278 L
.1686 .07987 L
.16861 .12158 L
.16863 .11435 L
.16866 .10258 L
.16867 .11028 L
.16869 .09146 L
.1687 .10208 L
.16872 .1136 L
.16873 .01681 L
.16875 .08971 L
.16876 .09758 L
.16876 .09624 L
.16877 .09819 L
.16878 .12163 L
.16879 .09922 L
.1688 .11979 L
.16881 .07024 L
.16882 .09847 L
.16883 .14901 L
.16884 .11379 L
.16885 .10969 L
.16886 .12225 L
.16888 .10893 L
.16889 .1822 L
.1689 .09879 L
.16892 .13708 L
.16893 .08678 L
.16893 .12843 L
.16895 .12696 L
.16896 .07116 L
.16897 .1223 L
.16898 .09422 L
.16899 .11155 L
.169 .10025 L
.16901 .09778 L
.16902 .16365 L
.16903 .12604 L
.16904 .10335 L
.16904 .14749 L
.16906 .1284 L
.16907 .06053 L
.16909 .06975 L
.1691 .09101 L
.16912 .13238 L
.16913 .08291 L
.16914 .05638 L
.16915 .11772 L
Mistroke
.16917 .10607 L
.16917 .08562 L
.16918 .09121 L
.1692 .10275 L
.16921 .14486 L
.16923 .08493 L
.16924 .11237 L
.16926 .10521 L
.16926 .13998 L
.16927 .07015 L
.16928 .06707 L
.16929 .09507 L
.1693 .11675 L
.16931 .12196 L
.16932 .07444 L
.16933 .09618 L
.16934 .09112 L
.16936 .07571 L
.16937 .11265 L
.16938 .08499 L
.1694 .10462 L
.16941 .09852 L
.16942 .12466 L
.16943 .12566 L
.16944 .05766 L
.16946 .08045 L
.16947 .12272 L
.16948 .09894 L
.1695 .12821 L
.16951 .10812 L
.16952 .08584 L
.16954 .09469 L
.16955 .10269 L
.16957 .10164 L
.16958 .14706 L
.1696 .11662 L
.16961 .1004 L
.16962 .08139 L
.16963 .14064 L
.16964 .14362 L
.16964 .12526 L
.16965 .08084 L
.16966 .08841 L
.16968 .10558 L
.16968 .11052 L
.16969 .08869 L
.16971 .09431 L
.16972 .08469 L
.16973 .12683 L
.16974 .10859 L
Mistroke
.16976 .09804 L
.16977 .09216 L
.16978 .14834 L
.1698 .13256 L
.16981 .09022 L
.16982 .08779 L
.16983 .12191 L
.16984 .09961 L
.16986 .13038 L
.16987 .09204 L
.16988 .09712 L
.16989 .10859 L
.16991 .11124 L
.16992 .10175 L
.16994 .10707 L
.16994 .12168 L
.16995 .14647 L
.16996 .11275 L
.16997 .12982 L
.16998 .13783 L
.17 .10439 L
.17001 .09012 L
.17002 .10602 L
.17003 .11562 L
.17004 .09663 L
.17005 .09321 L
.17006 .09934 L
.17007 .09292 L
.17008 .12284 L
.17008 .08 L
.1701 .14292 L
.17011 .06666 L
.17013 .09699 L
.17014 .09126 L
.17015 .06586 L
.17016 .11566 L
.17017 .13335 L
.17018 .11411 L
.17018 .10159 L
.17019 .11452 L
.17021 .10704 L
.17022 .10757 L
.17023 .0696 L
.17025 .11995 L
.17026 .11304 L
.17027 .08537 L
.17028 .0664 L
.17029 .09006 L
.17031 .11957 L
.17032 .08649 L
Mistroke
.17033 .09795 L
.17034 .09802 L
.17035 .12454 L
.17037 .09482 L
.17038 .13296 L
.1704 .12981 L
.17041 .06952 L
.17042 .11209 L
.17044 .12274 L
.17045 .12608 L
.17046 .07196 L
.17047 .10132 L
.17048 .1255 L
.17049 .16093 L
.1705 .09059 L
.17052 .12945 L
.17053 .07866 L
.17055 .09548 L
.17056 .08143 L
.17057 .10373 L
.17059 .07125 L
.1706 .05674 L
.17061 .12111 L
.17063 .09484 L
.17064 .15819 L
.17065 .12287 L
.17067 .10056 L
.17068 .13451 L
.17069 .10595 L
.17071 .10157 L
.17072 .10647 L
.17074 .09692 L
.17075 .09848 L
.17077 .08757 L
.17078 .11939 L
.1708 .10635 L
.17081 .14335 L
.17082 .12069 L
.17083 .08119 L
.17084 .09532 L
.17085 .12211 L
.17087 .12431 L
.17088 .08864 L
.17089 .10983 L
.1709 .09976 L
.17091 .10279 L
.17092 .08996 L
.17093 .11046 L
.17094 .08629 L
.17095 .10929 L
Mistroke
.17096 .13168 L
.17097 .12991 L
.17098 .14126 L
.17099 .11834 L
.17101 .08352 L
.17102 .07042 L
.17103 .11239 L
.17104 .09853 L
.17106 .13554 L
.17106 .10247 L
.17107 .09551 L
.17109 .09028 L
.1711 .11889 L
.17112 .09341 L
.17113 .05604 L
.17114 .1303 L
.17115 .14484 L
.17116 .10363 L
.17117 .09872 L
.17118 .11936 L
.17119 .09228 L
.1712 .1234 L
.1712 .15614 L
.17121 .09146 L
.17122 .09487 L
.17123 .11736 L
.17124 .10713 L
.17126 .10424 L
.17128 .0815 L
.17128 .09958 L
.17129 .12361 L
.17131 .07555 L
.17132 .09116 L
.17132 .15386 L
.17134 .11197 L
.17135 .0942 L
.17137 .08266 L
.17138 .12155 L
.17139 .10312 L
.1714 .09439 L
.17141 .08905 L
.17142 .13501 L
.17143 .1319 L
.17145 .07707 L
.17146 .15299 L
.17146 .12673 L
.17148 .07579 L
.17149 .07338 L
.1715 .10046 L
.17151 .13214 L
Mistroke
.17152 .09536 L
.17152 .10815 L
.17153 .11101 L
.17155 .11491 L
.17156 .14235 L
.17158 .13228 L
.17159 .11677 L
.1716 .11717 L
.17161 .12771 L
.17162 .10411 L
.17162 .09672 L
.17163 .10658 L
.17164 .11723 L
.17165 .07327 L
.17167 .07636 L
.17168 .12363 L
.1717 .07045 L
.17171 .0884 L
.17172 .08786 L
.17173 .08553 L
.17174 .09946 L
.17176 .0985 L
.17177 .10318 L
.17178 .07128 L
.17179 .10148 L
.1718 .10708 L
.17182 .11207 L
.17183 .07314 L
.17184 .10572 L
.17186 .10575 L
.17187 .08425 L
.17189 .11139 L
.1719 .06854 L
.1719 .1132 L
.17192 .11412 L
.17193 .11368 L
.17194 .09469 L
.17195 .08824 L
.17197 .09308 L
.17198 .08219 L
.17199 .12591 L
.17201 .10561 L
.17202 .08876 L
.17203 .0648 L
.17205 .06992 L
.17206 .11977 L
.17207 .1126 L
.17209 .14201 L
.1721 .07349 L
.17212 .0973 L
Mistroke
.17213 .12095 L
.17214 .09837 L
.17216 .11675 L
.17217 .0883 L
.17219 .08102 L
.1722 .09949 L
.17222 .09815 L
.17222 .1301 L
.17223 .07629 L
.17225 .13117 L
.17226 .09709 L
.17227 .11794 L
.17228 .08184 L
.17229 .12431 L
.17231 .07698 L
.17232 .06388 L
.17232 .12933 L
.17234 .12434 L
.17235 .05785 L
.17237 .1238 L
.17238 .12622 L
.1724 .09461 L
.17241 .11599 L
.17242 .08448 L
.17244 .12851 L
.17245 .10189 L
.17247 .09751 L
.17248 .125 L
.17249 .04425 L
.1725 .10646 L
.17251 .14581 L
.17253 .12386 L
.17254 .12367 L
.17256 .0946 L
.17257 .09771 L
.17258 .06689 L
.17259 .14735 L
.1726 .12163 L
.17261 .1194 L
.17262 .12205 L
.17263 .10672 L
.17264 .05973 L
.17266 .09159 L
.17267 .10738 L
.17268 .10494 L
.17269 .09472 L
.17269 .1403 L
.1727 .11165 L
.17272 .10006 L
.17273 .09001 L
Mistroke
.17273 .07551 L
.17275 .09113 L
.17276 .12292 L
.17278 .09646 L
.17279 .1176 L
.1728 .10597 L
.17282 .07221 L
.17283 .15097 L
.17284 .12727 L
.17285 .11051 L
.17287 .13517 L
.17287 .13328 L
.17288 .11494 L
.1729 .073 L
.17291 .09744 L
.17293 .12534 L
.17294 .07561 L
.17295 .13172 L
.17297 .14712 L
.17298 .09057 L
.17299 .13831 L
.173 .07969 L
.17302 .09746 L
.17303 .09852 L
.17305 .12737 L
.17306 .11751 L
.17308 .11566 L
.17309 .09889 L
.17311 .1206 L
.17312 .10998 L
.17313 .13727 L
.17315 .10578 L
.17316 .11211 L
.17318 .12404 L
.17319 .14344 L
.1732 .1027 L
.17321 .09242 L
.17322 .12806 L
.17322 .1064 L
.17324 .14937 L
.17325 .08157 L
.17326 .1114 L
.17327 .09693 L
.17328 .12322 L
.1733 .09082 L
.17331 .06984 L
.17333 .15149 L
.17334 .0829 L
.17335 .11475 L
.17337 .07998 L
Mistroke
.17338 .08314 L
.1734 .10093 L
.17341 .08977 L
.17343 .10817 L
.17343 .09716 L
.17344 .13912 L
.17346 .09972 L
.17347 .0804 L
.17349 .11599 L
.1735 .12182 L
.17352 .1262 L
.17352 .10059 L
.17353 .11424 L
.17355 .08087 L
.17356 .10913 L
.17356 .14167 L
.17357 .11267 L
.17358 .1182 L
.17359 .08899 L
.1736 .09181 L
.17361 .10325 L
.17362 .1112 L
.17363 .08476 L
.17365 .10264 L
.17366 .12541 L
.17368 .07402 L
.17369 .13122 L
.17371 .09042 L
.17372 .11518 L
.17373 .1253 L
.17375 .10199 L
.17376 .0913 L
.17378 .07952 L
.17379 .09388 L
.1738 .08272 L
.17382 .09733 L
.17383 .10719 L
.17384 .12281 L
.17385 .09531 L
.17387 .10846 L
.17388 .09625 L
.17389 .13231 L
.17391 .14916 L
.17392 .13405 L
.17394 .12598 L
.17395 .10702 L
.17396 .11245 L
.17397 .13662 L
.17399 .11867 L
.174 .14705 L
Mistroke
.17402 .12126 L
.17403 .11041 L
.17404 .12475 L
.17406 .09667 L
.17407 .07067 L
.17407 .12499 L
.17409 .07973 L
.1741 .09699 L
.17412 .04916 L
.17412 .08228 L
.17413 .10908 L
.17415 .0944 L
.17416 .08942 L
.17417 .09769 L
.17419 .09954 L
.1742 .13865 L
.17422 .10174 L
.17423 .11633 L
.17424 .09341 L
.17425 .10666 L
.17426 .14029 L
.17427 .14653 L
.17428 .09969 L
.17429 .07919 L
.17431 .12405 L
.17432 .11381 L
.17434 .12377 L
.17435 .11819 L
.17436 .09711 L
.17438 .06145 L
.17439 .11596 L
.1744 .1585 L
.17442 .08813 L
.17443 .12525 L
.17444 .11013 L
.17446 .11621 L
.17447 .11846 L
.17449 .12536 L
.1745 .0884 L
.17451 .10876 L
.17453 .10607 L
.17454 .08855 L
.17456 .08664 L
.17457 .12933 L
.17459 .13096 L
.1746 .08892 L
.1746 .10385 L
.17461 .07759 L
.17462 .12897 L
.17464 .10992 L
Mistroke
.17464 .12746 L
.17465 .1117 L
.17467 .12613 L
.17468 .09405 L
.1747 .13635 L
.17471 .14713 L
.17472 .09928 L
.17474 .08534 L
.17475 .07774 L
.17476 .1123 L
.17478 .13434 L
.17479 .11108 L
.17481 .11864 L
.17482 .08768 L
.17483 .11784 L
.17484 .14137 L
.17485 .13556 L
.17487 .10957 L
.17488 .09034 L
.1749 .10789 L
.17491 .08025 L
.17492 .1328 L
.17493 .12352 L
.17494 .13533 L
.17495 .12157 L
.17496 .07762 L
.17497 .11374 L
.17498 .11084 L
.17499 .1226 L
.17501 .12827 L
.17502 .09818 L
.17503 .1239 L
.17504 .12255 L
.17504 .08543 L
.17506 .12752 L
.17507 .10599 L
.17507 .12717 L
.17508 .13443 L
.17509 .07863 L
.1751 .08396 L
.17511 .10032 L
.17512 .13461 L
.17514 .11159 L
.17515 .12472 L
.17517 .07593 L
.17518 .09659 L
.17519 .13394 L
.1752 .12593 L
.17521 .1046 L
.17522 .10088 L
Mistroke
.17523 .11576 L
.17524 .13933 L
.17525 .1226 L
.17526 .10673 L
.17527 .11797 L
.17527 .07483 L
.17528 .10489 L
.17529 .08256 L
.1753 .11952 L
.17531 .07623 L
.17533 .0944 L
.17534 .09447 L
.17534 .09304 L
.17536 .09107 L
.17537 .09567 L
.17539 .10819 L
.17542 .12899 L
.17543 .12991 L
.17544 .09071 L
.17545 .14906 L
.17546 .07996 L
.17548 .119 L
.17548 .12194 L
.17549 .10574 L
.17551 .08546 L
.17552 .11367 L
.17553 .1091 L
.17553 .10123 L
.17554 .09894 L
.17556 .12536 L
.17557 .08961 L
.17558 .0947 L
.1756 .1133 L
.17561 .11046 L
.17563 .08214 L
.17564 .14784 L
.17565 .08632 L
.17566 .11131 L
.17567 .11883 L
.17568 .1147 L
.17569 .10418 L
.17571 .0951 L
.17571 .07376 L
.17572 .09215 L
.17574 .13983 L
.17575 .09599 L
.17576 .09449 L
.17577 .11648 L
.17578 .12535 L
.1758 .10986 L
Mistroke
.17581 .12579 L
.17582 .12205 L
.17584 .10965 L
.17585 .08807 L
.17586 .11804 L
.17587 .10073 L
.17589 .08854 L
.1759 .08703 L
.17591 .07728 L
.17593 .1406 L
.17594 .13984 L
.17595 .08137 L
.17596 .07704 L
.17598 .0855 L
.17599 .11958 L
.17601 .09431 L
.17602 .06794 L
.17604 .09764 L
.17604 .11654 L
.17605 .11105 L
.17606 .10877 L
.17607 .12328 L
.17608 .06129 L
.1761 .08054 L
.17611 .11914 L
.17611 .0872 L
.17613 .09925 L
.17614 .13117 L
.17616 .10024 L
.17617 .10691 L
.17619 .11744 L
.1762 .1327 L
.17621 .08294 L
.17623 .09489 L
.17624 .09763 L
.17626 .09506 L
.17627 .10901 L
.17628 .10098 L
.17629 .09869 L
.1763 .07414 L
.17632 .08873 L
.17633 .11149 L
.17635 .08585 L
.17636 .0846 L
.17637 .08725 L
.17638 .13435 L
.17639 .11527 L
.1764 .09451 L
.17641 .10234 L
.17642 .11867 L
Mistroke
.17643 .05629 L
.17644 .09672 L
.17646 .10832 L
.17647 .08577 L
.17647 .07763 L
.17648 .08732 L
.17649 .11054 L
.17651 .09438 L
.17652 .13294 L
.17654 .14442 L
.17655 .10184 L
.17656 .13128 L
.17658 .07833 L
.17659 .09414 L
.17661 .11308 L
.17662 .07876 L
.17664 .13608 L
.17665 .11601 L
.17666 .11833 L
.17668 .12567 L
.17669 .08119 L
.1767 .10337 L
.17671 .1127 L
.17673 .11913 L
.17674 .07601 L
.17675 .12219 L
.17677 .08238 L
.17678 .10956 L
.17679 .07763 L
.17681 .07764 L
.17682 .07869 L
.17683 .05661 L
.17685 .10268 L
.17686 .12825 L
.17688 .104 L
.17689 .08023 L
.1769 .11196 L
.17691 .09589 L
.17692 .10194 L
.17693 .11363 L
.17695 .10644 L
.17696 .09414 L
.17697 .12554 L
.17698 .11858 L
.17699 .10713 L
.17701 .08722 L
.17702 .11605 L
.17703 .11697 L
.17705 .10371 L
.17706 .10834 L
Mistroke
.17708 .09427 L
.17708 .14385 L
.17709 .06105 L
.17711 .1239 L
.17712 .11758 L
.17712 .13781 L
.17714 .1107 L
.17715 .04763 L
.17717 .09489 L
.17718 .11934 L
.1772 .1349 L
.17721 .11793 L
.17722 .07611 L
.17723 .10885 L
.17725 .11416 L
.17726 .09564 L
.17728 .12472 L
.17729 .10295 L
.1773 .07911 L
.17732 .10844 L
.17733 .09033 L
.17734 .09868 L
.17736 .08241 L
.17738 .13514 L
.17739 .11384 L
.1774 .14187 L
.17742 .11171 L
.17743 .12987 L
.17745 .11075 L
.17746 .11975 L
.17748 .08719 L
.17749 .09972 L
.1775 .08485 L
.17752 .09056 L
.17753 .0835 L
.17754 .11775 L
.17755 .08682 L
.17756 .10327 L
.17757 .12095 L
.17757 .10547 L
.17758 .13951 L
.1776 .12454 L
.17761 .06808 L
.17763 .14078 L
.17763 .14605 L
.17764 .10746 L
.17765 .08798 L
.17766 .05956 L
.17767 .1217 L
.17768 .06573 L
Mistroke
.17769 .10937 L
.17771 .10478 L
.17771 .07429 L
.17772 .15608 L
.17773 .10414 L
.17774 .08636 L
.17776 .08051 L
.17777 .04668 L
.17777 .09001 L
.17779 .113 L
.1778 .12991 L
.17782 .11972 L
.17783 .11966 L
.17784 .12127 L
.17785 .09316 L
.17786 .11924 L
.17787 .08723 L
.17788 .08361 L
.17789 .10269 L
.1779 .11382 L
.1779 .10096 L
.17791 .13333 L
.17793 .11567 L
.17794 .09883 L
.17795 .12606 L
.17796 .09466 L
.17797 .10451 L
.17799 .0865 L
.178 .09441 L
.17802 .12618 L
.17803 .08498 L
.17803 .09451 L
.17804 .1307 L
.17805 .18288 L
.17807 .14117 L
.17808 .12829 L
.1781 .1339 L
.17811 .07052 L
.17811 .10249 L
.17812 .11468 L
.17813 .12201 L
.17814 .09319 L
.17815 .10083 L
.17816 .1302 L
.17817 .09809 L
.17818 .14743 L
.1782 .09437 L
.17821 .10932 L
.17823 .11545 L
.17823 .11772 L
Mistroke
.17824 .12175 L
.17825 .1415 L
.17826 .11352 L
.17827 .11467 L
.17828 .10493 L
.17829 .10852 L
.1783 .14823 L
.17832 .13203 L
.17833 .08553 L
.17835 .10271 L
.17835 .13948 L
.17836 .10721 L
.17838 .1517 L
.17839 .07159 L
.17841 .13876 L
.17841 .07623 L
.17842 .15316 L
.17844 .16221 L
.17845 .08098 L
.17846 .12158 L
.17848 .06627 L
.17849 .10703 L
.17851 .13622 L
.17852 .13249 L
.17853 .10135 L
.17854 .07463 L
.17855 .13177 L
.17856 .10395 L
.17857 .12805 L
.17858 .10382 L
.1786 .11058 L
.17861 .09957 L
.17863 .11405 L
.17864 .11122 L
.17865 .11189 L
.17867 .09866 L
.17868 .07557 L
.17869 .09424 L
.17871 .09231 L
.17872 .07894 L
.17874 .10185 L
.17875 .08325 L
.17876 .07498 L
.17878 .09032 L
.17879 .10875 L
.1788 .10809 L
.17882 .07809 L
.17883 .10267 L
.17885 .09821 L
.17886 .13146 L
Mistroke
.17888 .09156 L
.17889 .07753 L
.1789 .1037 L
.17891 .0995 L
.17897 .08493 L
.17899 .09646 L
.179 .09715 L
.17902 .11533 L
.17903 .07494 L
.17904 .09317 L
.17906 .09274 L
.17907 .08034 L
.17908 .13387 L
.17909 .12396 L
.1791 .07368 L
.17912 .0897 L
.17913 .10292 L
.17913 .12006 L
.17914 .08752 L
.17915 .13283 L
.17917 .10532 L
.17918 .08932 L
.17919 .07901 L
.1792 .08402 L
.17921 .11593 L
.17922 .16185 L
.17923 .11231 L
.17925 .10743 L
.17926 .08545 L
.17927 .12042 L
.17929 .08822 L
.1793 .08731 L
.1793 .10148 L
.17932 .07861 L
.17933 .08724 L
.17934 .142 L
.17935 .11833 L
.17936 .08506 L
.17938 .10111 L
.17939 .1179 L
.1794 .09101 L
.17941 .06514 L
.17943 .07447 L
.17944 .09262 L
.17946 .08235 L
.17947 .08608 L
.17948 .1073 L
.17949 .12995 L
.17951 .09476 L
.17952 .12763 L
Mistroke
.17954 .14447 L
.17955 .11354 L
.17957 .11118 L
.17963 .09901 L
.17964 .07321 L
.17965 .08937 L
.17965 .1118 L
.17966 .12834 L
.17968 .08762 L
.17969 .12877 L
.1797 .08949 L
.17971 .07713 L
.17973 .1236 L
.17973 .1146 L
.17974 .10409 L
.17975 .12061 L
.17976 .17061 L
.17977 .08795 L
.17979 .11943 L
.1798 .06372 L
.17982 .13721 L
.17983 .12349 L
.17984 .11903 L
.17986 .12093 L
.17987 .06755 L
.17989 .14859 L
.1799 .1051 L
.1799 .07063 L
.17992 .10929 L
.17993 .07681 L
.17995 .11703 L
.17996 .1095 L
.17998 .14567 L
.17999 .09322 L
.18 .11101 L
.18001 .06822 L
.18002 .11652 L
.18003 .05691 L
.18003 .11622 L
.18004 .11142 L
.18006 .12955 L
.18007 .05833 L
.18008 .09619 L
.1801 .09772 L
.18011 .11535 L
.18013 .1277 L
.18014 .09134 L
.18015 .13418 L
.18016 .08787 L
.18018 .1008 L
Mistroke
.18019 .10746 L
.18021 .12525 L
.18022 .06169 L
.18023 .15688 L
.18024 .12212 L
.18025 .09916 L
.18026 .10155 L
.18028 .12162 L
.18029 .11261 L
.1803 .08082 L
.18031 .12184 L
.18032 .08578 L
.18034 .11187 L
.18035 .07308 L
.18036 .12437 L
.18038 .11346 L
.18039 .09376 L
.18041 .07074 L
.18042 .12895 L
.18043 .15461 L
.18044 .11666 L
.18045 .06747 L
.18046 .10144 L
.18047 .10852 L
.18049 .1163 L
.1805 .1115 L
.18052 .0885 L
.18053 .10846 L
.18054 .13992 L
.18055 .08116 L
.18057 .08444 L
.18058 .11743 L
.1806 .12215 L
.18061 .09733 L
.18062 .08662 L
.18064 .11447 L
.18065 .08151 L
.18066 .08523 L
.18068 .06634 L
.18069 .09432 L
.18071 .14244 L
.18072 .09329 L
.18074 .11906 L
.18075 .11341 L
.18077 .11864 L
.18077 .10136 L
.18078 .10393 L
.18079 .1118 L
.1808 .12372 L
.18081 .11521 L
Mistroke
.18083 .13962 L
.18084 .08726 L
.18084 .06681 L
.18086 .10762 L
.18087 .12719 L
.18089 .09674 L
.1809 .11926 L
.18092 .10403 L
.18093 .11153 L
.18094 .0923 L
.18096 .0847 L
.18097 .08211 L
.18099 .07085 L
.181 .08697 L
.18101 .11359 L
.18102 .11092 L
.18103 .08464 L
.18105 .1078 L
.18106 .11517 L
.18108 .0988 L
.18109 .12039 L
.1811 .08588 L
.18111 .11477 L
.18112 .11973 L
.18113 .09608 L
.18114 .07981 L
.18115 .09422 L
.18116 .07834 L
.18117 .08147 L
.18118 .08673 L
.18118 .12 L
.18119 .08467 L
.18121 .11728 L
.18122 .10053 L
.18124 .15388 L
.18125 .09883 L
.18127 .10101 L
.18128 .12219 L
.18129 .07928 L
.18131 .12788 L
.18132 .11748 L
.18134 .10629 L
.18135 .0893 L
.18137 .11181 L
.18138 .11776 L
.18139 .07786 L
.18141 .13349 L
.18142 .0956 L
.18143 .10868 L
.18144 .10235 L
Mistroke
.18146 .08713 L
.18147 .11583 L
.18148 .14523 L
.1815 .08349 L
.18151 .10519 L
.18153 .07127 L
.18154 .06826 L
.18155 .11592 L
.18156 .13434 L
.18158 .08641 L
.18159 .12237 L
.18161 .10893 L
.18162 .09211 L
.18163 .11326 L
.18164 .12747 L
.18165 .08159 L
.18166 .10898 L
.18168 .09648 L
.18169 .12794 L
.1817 .07492 L
.18171 .09263 L
.18172 .09112 L
.18174 .10342 L
.18175 .12201 L
.18176 .11214 L
.18178 .11106 L
.18179 .07136 L
.18181 .09702 L
.18181 .15164 L
.18182 .10617 L
.18184 .0912 L
.18185 .15007 L
.18186 .07109 L
.18187 .12052 L
.18189 .09517 L
.1819 .11619 L
.18191 .12111 L
.18193 .12714 L
.18194 .11986 L
.18195 .11092 L
.18196 .11111 L
.18198 .10917 L
.18199 .08083 L
.18201 .1061 L
.18202 .11008 L
.18204 .10845 L
.18205 .11077 L
.18206 .12475 L
.18208 .10676 L
.18209 .11186 L
Mistroke
.18211 .06842 L
.18212 .10475 L
.18213 .11888 L
.18215 .12396 L
.18216 .08239 L
.18217 .07974 L
.18218 .11296 L
.18219 .13942 L
.1822 .12388 L
.18221 .11929 L
.18223 .07008 L
.18223 .12624 L
.18224 .09436 L
.18226 .09991 L
.18227 .12889 L
.18228 .10322 L
.1823 .08434 L
.18231 .0977 L
.18233 .13832 L
.18234 .0916 L
.18235 .08102 L
.18237 .08863 L
.18238 .09165 L
.1824 .13042 L
.18241 .11872 L
.18241 .12197 L
.18243 .12309 L
.18244 .1175 L
.18246 .13162 L
.18247 .06923 L
.18249 .11432 L
.1825 .14862 L
.1825 .11774 L
.18252 .09306 L
.18253 .11755 L
.18254 .10317 L
.18255 .12891 L
.18256 .128 L
.18256 .07496 L
.18257 .11145 L
.18258 .07107 L
.18259 .06162 L
.1826 .09371 L
.18262 .09666 L
.18263 .06789 L
.18265 .1 L
.18266 .11905 L
.18268 .08745 L
.18269 .09585 L
.1827 .09202 L
Mistroke
.18272 .06568 L
.18273 .06453 L
.18275 .09196 L
.18276 .10387 L
.18278 .09042 L
.18279 .1247 L
.18281 .15139 L
.18282 .12034 L
.18283 .12124 L
.18284 .10272 L
.18285 .1151 L
.18287 .08973 L
.18288 .12388 L
.1829 .06788 L
.18291 .10496 L
.18292 .12117 L
.18293 .13824 L
.18295 .0913 L
.18296 .10623 L
.18297 .07233 L
.18299 .08419 L
.183 .0532 L
.18301 .10452 L
.18302 .10805 L
.18303 .08587 L
.18305 .14242 L
.18306 .11773 L
.18307 .12918 L
.18309 .1194 L
.1831 .06816 L
.18312 .11632 L
.18313 .12652 L
.18315 .07267 L
.18316 .11454 L
.18317 .14971 L
.18319 .10817 L
.1832 .12447 L
.18322 .09419 L
.18323 .08842 L
.18325 .09438 L
.18325 .11895 L
.18326 .09631 L
.18327 .09468 L
.18328 .06514 L
.18329 .10029 L
.18331 .1241 L
.18332 .12779 L
.18334 .12093 L
.18335 .10136 L
.18336 .10678 L
Mistroke
.18338 .12712 L
.18339 .13811 L
.18341 .09235 L
.18342 .08776 L
.18342 .14644 L
.18344 .10223 L
.18345 .1082 L
.18346 .11168 L
.18347 .10196 L
.18349 .09375 L
.1835 .11061 L
.18352 .11632 L
.18353 .11055 L
.18354 .11203 L
.18356 .08819 L
.18357 .09378 L
.18358 .12787 L
.18358 .08052 L
.18359 .1007 L
.18361 .12404 L
.18362 .13608 L
.18364 .12694 L
.18365 .10513 L
.18366 .10308 L
.18368 .11809 L
.18369 .08003 L
.1837 .12336 L
.18372 .14399 L
.18373 .12716 L
.18375 .05106 L
.18376 .0881 L
.18378 .12151 L
.18379 .09349 L
.1838 .09801 L
.18381 .12592 L
.18383 .10403 L
.18383 .14004 L
.18384 .07521 L
.18386 .13131 L
.18387 .1205 L
.18388 .11011 L
.18389 .1234 L
.18389 .12313 L
.18391 .11598 L
.18392 .09848 L
.18392 .07327 L
.18394 .14492 L
.18395 .12264 L
.18396 .13465 L
.18397 .10178 L
Mistroke
.18399 .10148 L
.184 .07495 L
.18401 .11472 L
.18403 .0967 L
.18404 .1214 L
.18406 .09518 L
.18407 .10009 L
.18409 .11221 L
.18409 .13672 L
.1841 .11591 L
.18412 .16008 L
.18413 .10695 L
.18414 .13556 L
.18416 .09404 L
.18417 .07054 L
.18418 .06443 L
.1842 .09804 L
.18421 .08264 L
.18423 .15028 L
.18424 .11534 L
.18425 .10452 L
.18426 .10291 L
.18427 .13962 L
.18429 .06948 L
.1843 .14252 L
.18431 .11905 L
.18432 .12411 L
.18433 .11696 L
.18434 .11021 L
.18435 .17852 L
.18436 .09891 L
.18437 .12537 L
.18438 .10702 L
.18439 .09086 L
.1844 .07132 L
.18441 .09605 L
.18443 .06757 L
.18444 .11403 L
.18446 .0901 L
.18447 .14778 L
.18449 .12983 L
.18449 .12192 L
.1845 .13114 L
.18452 .12126 L
.18453 .10015 L
.18454 .12134 L
.18455 .08332 L
.18456 .07705 L
.18458 .15838 L
.18459 .13905 L
Mistroke
.18461 .09461 L
.18462 .1292 L
.18462 .1359 L
.18463 .11933 L
.18464 .11661 L
.18466 .10897 L
.18467 .12193 L
.18468 .09372 L
.18469 .05037 L
.1847 .12154 L
.18471 .12349 L
.18472 .09741 L
.18473 .06053 L
.18474 .08492 L
.18475 .07588 L
.18476 .09576 L
.18477 .13292 L
.18479 .12676 L
.1848 .07767 L
.18482 .09554 L
.18482 .11986 L
.18483 .09563 L
.18484 .10244 L
.18485 .08445 L
.18486 .11663 L
.18487 .0933 L
.18488 .09522 L
.18489 .08222 L
.18491 .13557 L
.18492 .11441 L
.18494 .11135 L
.18494 .09081 L
.18495 .12483 L
.18497 .10538 L
.18498 .12746 L
.185 .08213 L
.185 .08726 L
.18501 .1196 L
.18503 .1286 L
.18504 .10655 L
.18505 .11466 L
.18507 .10116 L
.18508 .07195 L
.1851 .10538 L
.18511 .11352 L
.18512 .11566 L
.18513 .12455 L
.18514 .10535 L
.18514 .12354 L
.18516 .1211 L
Mistroke
.18522 .11076 L
.18523 .12101 L
.18524 .11281 L
.18526 .08729 L
.18527 .12307 L
.18529 .10612 L
.1853 .07656 L
.18531 .09992 L
.18532 .0797 L
.18534 .14064 L
.18535 .09115 L
.18536 .09533 L
.18538 .08827 L
.18539 .06891 L
.18541 .13341 L
.18542 .10326 L
.18544 .08213 L
.18545 .12102 L
.18547 .10795 L
.18548 .13696 L
.18549 .11517 L
.1855 .07881 L
.18551 .13739 L
.18553 .07522 L
.18554 .12855 L
.18556 .087 L
.18557 .07203 L
.18559 .07401 L
.1856 .096 L
.18562 .09226 L
.18563 .09727 L
.18564 .13239 L
.18565 .10023 L
.18567 .11003 L
.18568 .12943 L
.18569 .09082 L
.1857 .11251 L
.18571 .11495 L
.18572 .11082 L
.18573 .11324 L
.18574 .06816 L
.18574 .09802 L
.18575 .13147 L
.18576 .10993 L
.18577 .11992 L
.18578 .12349 L
.1858 .1089 L
.18581 .10955 L
.18583 .07334 L
.18584 .09203 L
Mistroke
.18586 .09851 L
.18586 .08785 L
.18587 .11371 L
.18589 .0828 L
.1859 .08941 L
.18592 .14151 L
.18593 .04605 L
.18595 .07506 L
.18596 .14059 L
.18598 .08721 L
.18599 .09744 L
.18601 .11007 L
.18601 .06985 L
.18602 .06727 L
.18604 .0962 L
.18605 .10154 L
.18606 .12759 L
.18608 .1153 L
.18609 .08946 L
.18611 .13244 L
.18612 .10169 L
.18613 .09111 L
.18615 .12264 L
.18616 .05602 L
.18618 .06205 L
.18619 .10189 L
.1862 .06485 L
.18621 .07574 L
.18622 .15922 L
.18624 .09618 L
.18625 .10173 L
.18626 .11631 L
.18627 .07435 L
.18628 .12464 L
.1863 .13144 L
.18631 .08668 L
.18631 .11841 L
.18632 .15898 L
.18633 .10669 L
.18634 .13792 L
.18635 .08532 L
.18636 .17923 L
.18636 .10319 L
.18638 .1156 L
.18639 .12099 L
.18641 .07779 L
.18642 .09482 L
.18643 .14919 L
.18644 .09923 L
.18645 .16201 L
Mistroke
.18647 .11799 L
.18648 .14243 L
.18649 .06161 L
.18651 .10545 L
.18652 .08399 L
.18653 .09309 L
.18654 .14437 L
.18656 .11264 L
.18656 .13563 L
.18657 .11654 L
.18659 .10821 L
.1866 .11683 L
.18662 .06517 L
.18663 .10021 L
.18664 .13588 L
.18666 .103 L
.18667 .14496 L
.18668 .09343 L
.1867 .09954 L
.18671 .09787 L
.18672 .08226 L
.18674 .12169 L
.18675 .10471 L
.18677 .12104 L
.18678 .11524 L
.18679 .12934 L
.18681 .11409 L
.18682 .15361 L
.18684 .10553 L
.18685 .11312 L
.18687 .08089 L
.18688 .15374 L
.18689 .08306 L
.1869 .10929 L
.18691 .08191 L
.18691 .05046 L
.18693 .07252 L
.18694 .14336 L
.18696 .10345 L
.18697 .08069 L
.18699 .11565 L
.187 .08453 L
.18701 .12241 L
.18703 .07907 L
.18704 .09708 L
.18706 .11281 L
.18707 .11392 L
.18709 .17589 L
.1871 .08095 L
.18712 .07786 L
Mistroke
.18713 .07979 L
.18714 .09464 L
.18716 .09699 L
.18717 .10928 L
.18718 .12936 L
.18719 .09834 L
.1872 .12485 L
.18721 .10466 L
.18722 .16441 L
.18722 .10221 L
.18724 .13403 L
.18725 .11091 L
.18726 .10047 L
.18726 .11376 L
.18727 .13293 L
.18728 .12589 L
.18729 .09499 L
.1873 .09716 L
.18731 .11451 L
.18732 .11961 L
.18734 .08037 L
.18735 .11812 L
.18737 .11349 L
.18738 .08746 L
.1874 .11957 L
.18741 .11455 L
.18742 .10439 L
.18744 .08457 L
.18745 .07405 L
.18747 .11637 L
.18748 .12645 L
.1875 .07658 L
.1875 .06771 L
.18751 .12391 L
.18753 .14584 L
.18754 .09979 L
.18756 .12456 L
.18757 .09399 L
.18758 .15029 L
.1876 .11784 L
.18761 .08648 L
.18763 .08638 L
.18764 .09153 L
.18765 .08738 L
.18766 .07405 L
.18768 .09187 L
.18769 .12357 L
.1877 .10511 L
.18772 .11324 L
.18773 .11428 L
Mistroke
.18775 .12418 L
.18775 .15734 L
.18776 .11873 L
.18778 .08242 L
.18779 .11245 L
.18781 .13264 L
.18782 .10507 L
.18784 .11058 L
.18785 .12507 L
.18786 .12244 L
.18788 .08113 L
.18789 .12708 L
.1879 .11916 L
.18792 .09764 L
.18793 .0894 L
.18795 .08069 L
.18796 .13396 L
.18798 .10125 L
.18799 .10368 L
.188 .09654 L
.18801 .1089 L
.18803 .13269 L
.18804 .07853 L
.18805 .10791 L
.18807 .10875 L
.18808 .1011 L
.18809 .128 L
.18811 .06669 L
.18812 .09758 L
.18813 .0984 L
.18815 .10732 L
.18816 .12837 L
.18817 .08505 L
.18819 .13966 L
.1882 .13912 L
.18821 .06421 L
.18822 .08997 L
.18823 .0817 L
.18825 .08391 L
.18826 .11217 L
.18827 .11729 L
.18828 .08644 L
.18829 .15964 L
.18831 .10711 L
.18832 .14084 L
.18833 .09923 L
.18834 .0889 L
.18836 .09517 L
.18837 .11373 L
.18838 .11814 L
Mistroke
.18839 .11727 L
.18841 .12842 L
.18842 .11368 L
.18842 .10964 L
.18844 .0992 L
.18845 .09924 L
.18847 .07873 L
.18848 .09704 L
.18849 .08785 L
.18851 .13018 L
.18852 .11588 L
.18853 .1127 L
.18855 .11873 L
.18856 .10197 L
.18858 .12926 L
.18859 .1069 L
.1886 .12822 L
.18862 .13121 L
.18863 .12789 L
.18864 .13841 L
.18866 .0938 L
.18867 .11141 L
.18869 .10398 L
.1887 .08623 L
.18872 .08786 L
.18873 .09611 L
.18874 .12345 L
.18875 .12716 L
.18876 .13261 L
.18876 .15263 L
.18878 .12426 L
.18879 .13551 L
.18881 .14246 L
.18882 .10648 L
.18884 .09663 L
.18885 .09072 L
.18887 .10864 L
.18888 .07513 L
.18889 .07396 L
.18891 .10493 L
.18892 .10512 L
.18894 .11532 L
.18895 .1182 L
.18897 .07622 L
.18898 .15497 L
.18899 .11222 L
.18901 .11225 L
.18902 .10847 L
.18903 .10754 L
.18904 .13126 L
Mistroke
.18905 .10978 L
.18906 .0918 L
.18907 .10366 L
.18908 .13233 L
.18909 .09669 L
.1891 .11056 L
.18911 .10996 L
.18912 .1155 L
.18912 .09886 L
.18913 .11063 L
.18914 .07991 L
.18915 .0957 L
.18916 .10455 L
.18917 .09907 L
.18919 .11951 L
.1892 .12069 L
.18922 .09513 L
.18923 .11262 L
.18925 .1131 L
.18926 .09006 L
.18927 .11325 L
.18929 .10218 L
.1893 .1336 L
.18932 .12294 L
.18933 .0904 L
.18934 .08059 L
.18936 .11535 L
.18937 .09866 L
.18938 .13023 L
.18939 .10836 L
.18941 .09524 L
.18942 .11971 L
.18943 .14526 L
.18945 .10867 L
.18946 .12387 L
.18948 .08181 L
.18949 .06764 L
.1895 .11914 L
.18951 .11954 L
.18953 .08159 L
.18954 .08617 L
.18956 .09072 L
.18957 .10627 L
.18958 .09339 L
.1896 .11777 L
.18961 .09305 L
.18961 .10022 L
.18963 .10165 L
.18964 .14308 L
.18966 .101 L
Mistroke
.18967 .12467 L
.18969 .10154 L
.1897 .11559 L
.18971 .12986 L
.18973 .1258 L
.18974 .10212 L
.18976 .13744 L
.18977 .08433 L
.18979 .11614 L
.1898 .12497 L
.18981 .07093 L
.18983 .128 L
.18984 .10114 L
.18985 .14 L
.18986 .07976 L
.18988 .10331 L
.18989 .11835 L
.1899 .10364 L
.18992 .09106 L
.18993 .13481 L
.18994 .10878 L
.18996 .09282 L
.18997 .0692 L
.18998 .11278 L
.19 .09936 L
.19001 .10794 L
.19002 .10524 L
.19004 .13275 L
.19005 .10612 L
.19006 .0701 L
.19007 .07154 L
.19008 .10982 L
.1901 .12948 L
.19011 .11371 L
.19012 .1189 L
.19013 .08524 L
.19014 .09135 L
.19016 .10962 L
.19017 .09636 L
.19018 .12651 L
.1902 .12705 L
.19021 .10052 L
.19023 .16833 L
.19023 .0788 L
.19024 .09863 L
.19026 .10079 L
.19027 .12611 L
.19027 .10069 L
.19029 .11437 L
.1903 .10214 L
Mistroke
.19032 .09521 L
.19033 .11974 L
.19034 .08762 L
.19036 .07649 L
.19037 .06245 L
.19038 .10271 L
.1904 .11005 L
.19041 .12026 L
.19043 .09331 L
.19044 .07967 L
.19045 .0824 L
.19047 .09789 L
.19048 .11111 L
.19049 .1064 L
.19051 .12266 L
.19052 .13466 L
.19054 .14959 L
.19055 .15964 L
.19057 .09846 L
.19057 .13442 L
.19058 .10219 L
.1906 .10352 L
.19061 .12592 L
.19063 .1075 L
.19064 .11636 L
.19065 .10216 L
.19067 .09726 L
.19068 .13517 L
.19069 .12307 L
.1907 .11949 L
.19071 .1207 L
.19073 .09138 L
.19074 .1274 L
.19076 .08851 L
.19076 .12785 L
.19077 .11168 L
.19079 .13006 L
.1908 .16397 L
.19081 .08227 L
.19083 .15708 L
.19084 .10078 L
.19086 .14255 L
.19087 .10513 L
.19088 .08629 L
.19089 .14674 L
.19091 .08701 L
.19092 .06892 L
.19092 .06772 L
.19094 .12134 L
.19095 .1186 L
Mistroke
.19097 .08822 L
.19098 .10371 L
.19099 .12468 L
.19101 .11888 L
.19102 .10894 L
.19103 .10414 L
.19104 .11982 L
.19106 .08404 L
.19106 .10168 L
.19107 .12675 L
.19109 .0995 L
.1911 .12804 L
.19112 .09494 L
.19113 .10912 L
.19114 .09989 L
.19115 .10171 L
.19116 .13267 L
.19116 .0776 L
.19118 .13327 L
.1912 .08676 L
.1912 .13343 L
.19121 .08954 L
.19123 .14764 L
.19124 .14052 L
.19125 .1095 L
.19126 .09413 L
.19126 .10982 L
.19128 .13749 L
.19129 .13582 L
.19131 .09436 L
.19132 .09998 L
.19133 .10224 L
.19134 .09757 L
.19135 .05714 L
.19136 .1285 L
.19136 .08842 L
.19137 .12284 L
.19138 .08846 L
.19139 .11055 L
.1914 .08454 L
.19142 .09811 L
.19143 .12627 L
.19145 .10532 L
.19146 .11989 L
.19147 .09224 L
.19148 .09811 L
.19149 .09014 L
.19151 .05942 L
.19152 .06942 L
.19153 .09673 L
Mistroke
.19154 .11501 L
.19155 .14381 L
.19157 .07132 L
.19158 .11212 L
.19159 .10931 L
.19161 .10032 L
.19162 .11865 L
.19164 .06253 L
.19165 .10252 L
.19165 .11503 L
.19167 .16568 L
.19168 .11259 L
.19169 .12596 L
.1917 .13015 L
.19172 .07165 L
.19173 .11695 L
.19174 .13267 L
.19176 .10989 L
.19177 .10108 L
.19178 .11854 L
.1918 .13164 L
.19181 .1067 L
.19182 .07352 L
.19184 .1088 L
.19185 .0945 L
.19187 .07007 L
.19188 .11088 L
.19189 .11064 L
.19191 .14301 L
.19192 .08837 L
.19194 .07389 L
.19195 .07268 L
.19197 .08684 L
.19198 .08521 L
.19199 .12417 L
.19201 .0914 L
.19202 .1136 L
.19204 .11309 L
.19205 .08386 L
.19206 .09812 L
.19208 .1312 L
.19209 .14122 L
.19209 .07113 L
.1921 .09896 L
.19211 .06869 L
.19213 .10655 L
.19213 .08799 L
.19214 .09064 L
.19216 .0939 L
.19217 .07709 L
Mistroke
.19219 .1354 L
.1922 .08773 L
.19222 .11369 L
.19223 .11334 L
.19224 .15711 L
.19225 .12393 L
.19226 .07881 L
.19228 .11909 L
.19229 .10675 L
.19231 .11557 L
.19232 .12497 L
.19233 .13656 L
.19234 .10277 L
.19236 .10681 L
.19236 .10007 L
.19237 .15895 L
.19238 .10417 L
.19239 .10269 L
.19241 .09558 L
.19242 .09373 L
.19243 .10001 L
.19244 .09089 L
.19245 .11252 L
.19245 .11158 L
.19251 .09784 L
.19253 .13027 L
.19254 .13498 L
.19255 .10895 L
.19257 .08755 L
.19258 .09301 L
.19258 .08186 L
.1926 .06702 L
.19261 .12516 L
.19262 .12724 L
.19262 .12315 L
.19263 .13394 L
.19265 .10888 L
.19266 .10188 L
.19268 .10977 L
.19269 .0837 L
.19271 .08726 L
.19272 .07264 L
.19273 .08084 L
.19275 .12188 L
.19276 .09758 L
.19278 .10034 L
.19279 .13088 L
.1928 .09552 L
.19282 .08938 L
.19283 .10714 L
Mistroke
.19285 .14396 L
.19286 .12189 L
.19287 .10483 L
.19288 .08067 L
.1929 .08846 L
.19291 .12029 L
.19292 .13345 L
.19293 .10393 L
.19294 .11685 L
.19296 .04454 L
.19297 .08421 L
.19297 .09902 L
.19299 .11358 L
.193 .10962 L
.19302 .06452 L
.19303 .13656 L
.19304 .09746 L
.19305 .1065 L
.19306 .08767 L
.19307 .11921 L
.19308 .12709 L
.1931 .09519 L
.1931 .10894 L
.19311 .06782 L
.19313 .11759 L
.19314 .13512 L
.19315 .096 L
.19316 .09641 L
.19317 .06783 L
.19317 .10382 L
.19318 .07988 L
.1932 .10885 L
.19321 .11587 L
.19323 .11665 L
.19324 .1132 L
.19325 .08236 L
.19326 .09101 L
.19327 .15334 L
.19327 .10048 L
.19328 .10295 L
.19329 .09957 L
.1933 .0911 L
.19332 .12821 L
.19333 .08297 L
.19335 .12637 L
.19336 .12191 L
.19337 .09545 L
.19338 .11705 L
.19339 .14076 L
.19341 .15231 L
Mistroke
.19342 .11448 L
.19343 .09201 L
.19344 .08287 L
.19345 .14263 L
.19347 .09195 L
.19348 .09362 L
.19349 .09786 L
.19351 .13218 L
.19352 .137 L
.19354 .12723 L
.19354 .14664 L
.19355 .1349 L
.19357 .06667 L
.19358 .0728 L
.19358 .11504 L
.1936 .11741 L
.19361 .10999 L
.19363 .15111 L
.19364 .11244 L
.19366 .10488 L
.19367 .10677 L
.19368 .07028 L
.19369 .06719 L
.19371 .09237 L
.19372 .10877 L
.19374 .12293 L
.19375 .11318 L
.19376 .07671 L
.19378 .09642 L
.19379 .08677 L
.1938 .09776 L
.19382 .13408 L
.19383 .09489 L
.19385 .06448 L
.19386 .09179 L
.19388 .10303 L
.19389 .10641 L
.1939 .10224 L
.19391 .1076 L
.19392 .14548 L
.19393 .09447 L
.19394 .10724 L
.19395 .11697 L
.19396 .12665 L
.19397 .07765 L
.19399 .09815 L
.194 .12153 L
.19401 .07224 L
.19403 .09825 L
.19404 .15836 L
Mistroke
.19406 .1212 L
.19407 .1285 L
.19408 .12454 L
.1941 .04705 L
.19411 .09301 L
.19413 .14773 L
.19414 .07873 L
.19414 .10494 L
.19416 .10228 L
.19417 .12811 L
.19419 .13734 L
.1942 .1069 L
.19422 .08145 L
.19423 .1294 L
.19423 .10413 L
.19425 .10096 L
.19426 .07345 L
.19427 .13118 L
.19428 .08391 L
.19429 .11882 L
.19429 .10638 L
.1943 .09102 L
.19431 .11159 L
.19432 .14619 L
.19433 .11703 L
.19435 .11249 L
.19436 .11361 L
.19438 .08052 L
.19439 .14635 L
.19441 .1147 L
.19442 .1166 L
.19443 .10792 L
.19445 .11025 L
.19446 .12834 L
.19448 .10916 L
.19449 .12871 L
.19451 .07855 L
.19452 .10253 L
.19454 .10237 L
.19455 .09274 L
.19455 .08966 L
.19458 .07977 L
.1946 .11217 L
.19461 .10548 L
.19462 .08795 L
.19464 .11246 L
.19465 .06124 L
.19467 .07186 L
.19468 .08354 L
.1947 .04212 L
Mistroke
.19471 .12785 L
.19472 .1542 L
.19474 .10005 L
.19475 .12439 L
.19476 .10763 L
.19478 .13132 L
.19479 .11081 L
.1948 .14297 L
.19482 .12149 L
.19483 .11357 L
.19485 .12384 L
.19486 .10195 L
.19486 .0959 L
.19488 .11802 L
.19489 .10114 L
.1949 .12322 L
.19492 .10668 L
.19493 .16673 L
.19493 .08814 L
.19495 .08424 L
.19496 .1133 L
.19496 .11485 L
.19497 .08849 L
.19498 .10331 L
.19499 .12714 L
.195 .12801 L
.19501 .11991 L
.19503 .10302 L
.19504 .0815 L
.19506 .10126 L
.19507 .09574 L
.19509 .13713 L
.1951 .10329 L
.19512 .07276 L
.19513 .10395 L
.19513 .09318 L
.19515 .10299 L
.19516 .11258 L
.19517 .12523 L
.19517 .11784 L
.19518 .08981 L
.1952 .09161 L
.19521 .07145 L
.19521 .1075 L
.19522 .04481 L
.19523 .13526 L
.19524 .14948 L
.19525 .1023 L
.19526 .11445 L
.19527 .11424 L
Mistroke
.19528 .0722 L
.1953 .10735 L
.19531 .11135 L
.19532 .10857 L
.19534 .09737 L
.19535 .12978 L
.19537 .13241 L
.19538 .11177 L
.1954 .11846 L
.19541 .10727 L
.19542 .08028 L
.19544 .14358 L
.19545 .13882 L
.19547 .12103 L
.19548 .07617 L
.19549 .11606 L
.1955 .12595 L
.19551 .09173 L
.19553 .09339 L
.19554 .10222 L
.19556 .06317 L
.19557 .12132 L
.19557 .13639 L
.19559 .1257 L
.1956 .09374 L
.19562 .11394 L
.19563 .11035 L
.19565 .07855 L
.19566 .08968 L
.19567 .10919 L
.19568 .13916 L
.1957 .11962 L
.19571 .06699 L
.19572 .10224 L
.19574 .09074 L
.19575 .11693 L
.19576 .10233 L
.19577 .06459 L
.19578 .12016 L
.19579 .1125 L
.19581 .12307 L
.19582 .11156 L
.19584 .12523 L
.19585 .11684 L
.19586 .11346 L
.19588 .08478 L
.19589 .11023 L
.1959 .12439 L
.19591 .09763 L
.19592 .08558 L
Mistroke
.19593 .08938 L
.19594 .09269 L
.19596 .10883 L
.19597 .11485 L
.19599 .12038 L
.196 .06798 L
.19602 .09312 L
.19603 .12429 L
.19604 .06751 L
.19606 .13913 L
.19607 .11384 L
.19609 .0883 L
.1961 .13715 L
.19612 .14383 L
.19613 .11049 L
.19614 .08201 L
.19615 .12894 L
.19617 .072 L
.19618 .10144 L
.19619 .09677 L
.19621 .10988 L
.19622 .11192 L
.19624 .10445 L
.19625 .05052 L
.19626 .10298 L
.19627 .1145 L
.19629 .12701 L
.19629 .09614 L
.1963 .09211 L
.19632 .10891 L
.19633 .10224 L
.19634 .07409 L
.19636 .11448 L
.19637 .11413 L
.19638 .07093 L
.1964 .08121 L
.19641 .09458 L
.19643 .11012 L
.19644 .06831 L
.19646 .09174 L
.19647 .11135 L
.19649 .0803 L
.1965 .11661 L
.19651 .13659 L
.19652 .08537 L
.19653 .11944 L
.19655 .15148 L
.19656 .11819 L
.19656 .11471 L
.19657 .11733 L
Mistroke
.19658 .11298 L
.1966 .14593 L
.1966 .09159 L
.19661 .06602 L
.19662 .09815 L
.19663 .12645 L
.19664 .09242 L
.19665 .12198 L
.19666 .13393 L
.19666 .10246 L
.19668 .12003 L
.19669 .12578 L
.19671 .0969 L
.19672 .13971 L
.19674 .11229 L
.19675 .08496 L
.19677 .07334 L
.19678 .13137 L
.19679 .10456 L
.19681 .11743 L
.19682 .08665 L
.19684 .11955 L
.19685 .07583 L
.19686 .09348 L
.19688 .09736 L
.19689 .12656 L
.1969 .11217 L
.19691 .04916 L
.19693 .13105 L
.19694 .08749 L
.19695 .10413 L
.19697 .07154 L
.19698 .10126 L
.19699 .06282 L
.197 .06934 L
.19702 .12525 L
.19703 .10591 L
.19704 .11243 L
.19706 .07999 L
.19707 .11532 L
.19709 .10114 L
.1971 .16879 L
.19711 .11064 L
.19712 .14043 L
.19713 .1333 L
.19715 .08912 L
.19716 .11163 L
.19717 .09113 L
.19719 .13202 L
.1972 .06465 L
Mistroke
.19722 .12551 L
.19723 .10402 L
.19724 .12577 L
.19726 .103 L
.19727 .07547 L
.19729 .08688 L
.1973 .13096 L
.19732 .10482 L
.19733 .09273 L
.19735 .08908 L
.19736 .07565 L
.19736 .10008 L
.19738 .08342 L
.19739 .07436 L
.19741 .10956 L
.19742 .0972 L
.19743 .15361 L
.19745 .13412 L
.19746 .12503 L
.19747 .0936 L
.19748 .08436 L
.1975 .0881 L
.19751 .13773 L
.19753 .11576 L
.19754 .08304 L
.19755 .13294 L
.19756 .10883 L
.19757 .09317 L
.19758 .12668 L
.1976 .13373 L
.19761 .09909 L
.19763 .07528 L
.19764 .1032 L
.19766 .07345 L
.19767 .08597 L
.19768 .12209 L
.1977 .09515 L
.19771 .09059 L
.19773 .09282 L
.19774 .09436 L
.19776 .08167 L
.19777 .08262 L
.19779 .08263 L
.19779 .10669 L
.1978 .08425 L
.19782 .08573 L
.19783 .06482 L
.19785 .1118 L
.19786 .11229 L
.19787 .09664 L
Mistroke
.19789 .11423 L
.1979 .1002 L
.19791 .14093 L
.19793 .13993 L
.19794 .12087 L
.19795 .1282 L
.19797 .10056 L
.19798 .10784 L
.19799 .12188 L
.19801 .0854 L
.19802 .13669 L
.19802 .12531 L
.19804 .09951 L
.19805 .1114 L
.19807 .12341 L
.19808 .14349 L
.1981 .11795 L
.19811 .11723 L
.19813 .09918 L
.19814 .10544 L
.19815 .07943 L
.19817 .10721 L
.19818 .10965 L
.1982 .09663 L
.19821 .08985 L
.19822 .14022 L
.19824 .10978 L
.19825 .10244 L
.19826 .09812 L
.19827 .12727 L
.19829 .10526 L
.1983 .08105 L
.19831 .11233 L
.19833 .08871 L
.19834 .11634 L
.19836 .0889 L
.19837 .12916 L
.19838 .10604 L
.19839 .11476 L
.19841 .12111 L
.19842 .13646 L
.19844 .09656 L
.19845 .12978 L
.19846 .07489 L
.19847 .09579 L
.19848 .11966 L
.19849 .15234 L
.19851 .11477 L
.19852 .09627 L
.19854 .11744 L
Mistroke
.19855 .14149 L
.19857 .12646 L
.19858 .10387 L
.19859 .11818 L
.19861 .11104 L
.19862 .09943 L
.19864 .11032 L
.19865 .11503 L
.19866 .09571 L
.19868 .11044 L
.1987 .15543 L
.1987 .1289 L
.19871 .10688 L
.19873 .13345 L
.19874 .13333 L
.19876 .13925 L
.19877 .13165 L
.19878 .11347 L
.1988 .12126 L
.19881 .09908 L
.19882 .07266 L
.19884 .10323 L
.19885 .0733 L
.19886 .10825 L
.19888 .08392 L
.19889 .11235 L
.1989 .10744 L
.19892 .07954 L
.19893 .08415 L
.19893 .08974 L
.19895 .11073 L
.19896 .09681 L
.19898 .09851 L
.19899 .10451 L
.19899 .10333 L
.19901 .10384 L
.19902 .07096 L
.19904 .12233 L
.19905 .06442 L
.19906 .11363 L
.19908 .08772 L
.19909 .14814 L
.1991 .08843 L
.19911 .14126 L
.19912 .12763 L
.19913 .08639 L
.19914 .09798 L
.19915 .11751 L
.19917 .12105 L
.19918 .07968 L
Mistroke
.1992 .08687 L
.19921 .11274 L
.19922 .13023 L
.19924 .08745 L
.19925 .11777 L
.19926 .1255 L
.19928 .09996 L
.19929 .11409 L
.19931 .05111 L
.19932 .12265 L
.19933 .10274 L
.19935 .1238 L
.19936 .09783 L
.19938 .09378 L
.19939 .11073 L
.1994 .1423 L
.19942 .059 L
.19943 .13515 L
.19945 .12296 L
.19946 .08188 L
.19946 .12501 L
.19947 .09221 L
.19948 .13156 L
.1995 .11903 L
.19951 .09132 L
.19953 .09887 L
.19954 .10995 L
.19955 .12315 L
.19957 .08077 L
.19958 .1294 L
.19959 .12555 L
.19961 .1199 L
.19962 .11542 L
.19964 .14941 L
.19965 .11003 L
.19967 .09067 L
.19968 .1206 L
.19969 .05821 L
.1997 .09361 L
.19972 .15055 L
.19972 .12332 L
.19973 .11976 L
.19975 .13176 L
.19976 .10722 L
.19976 .11269 L
.19977 .14956 L
.19978 .10003 L
.1998 .09384 L
.19981 .09595 L
.19981 .10808 L
Mistroke
.19983 .13598 L
.19984 .09528 L
.19985 .11482 L
.19986 .11944 L
.19988 .13557 L
.19989 .12367 L
.1999 .12535 L
.19992 .10427 L
.19993 .12027 L
.19995 .12033 L
.19996 .13031 L
.19998 .11026 L
.19998 .12468 L
.19999 .11879 L
.20001 .05535 L
.20002 .09147 L
.20003 .11229 L
.20005 .11305 L
.20006 .14231 L
.20008 .10778 L
.20009 .1041 L
.2001 .07944 L
.20012 .12346 L
.20013 .06853 L
.20014 .0891 L
.20015 .09934 L
.20016 .11566 L
.20017 .12812 L
.20019 .11965 L
.2002 .12769 L
.20021 .11079 L
.20022 .10963 L
.20023 .07877 L
.20024 .07897 L
.20025 .12189 L
.20026 .11978 L
.20038 .09804 L
.20039 .09072 L
.2004 .0908 L
.20041 .05382 L
.20042 .12253 L
.20044 .10904 L
.20045 .13739 L
.20047 .09051 L
.20048 .09275 L
.20048 .15669 L
.20049 .10539 L
.2005 .07551 L
.20051 .08138 L
.20052 .10645 L
Mistroke
.20053 .12617 L
.20054 .09013 L
.20054 .07358 L
.20055 .0795 L
.20056 .07217 L
.20057 .10632 L
.20058 .1375 L
.20059 .08882 L
.2006 .09584 L
.2006 .11974 L
.20062 .12527 L
.20063 .10499 L
.20065 .10901 L
.20066 .16248 L
.20068 .10343 L
.20069 .11235 L
.20071 .10777 L
.20072 .08008 L
.20073 .13957 L
.20075 .10732 L
.20076 .10168 L
.20076 .08596 L
.20077 .1043 L
.20078 .12992 L
.2008 .07792 L
.20081 .11809 L
.20082 .12103 L
.20083 .11194 L
.20084 .08645 L
.20085 .07361 L
.20086 .08059 L
.20088 .13318 L
.20089 .0757 L
.2009 .11916 L
.20092 .12169 L
.20093 .1347 L
.20095 .09339 L
.20096 .11803 L
.20097 .08569 L
.20099 .1168 L
.201 .09695 L
.201 .09392 L
.20101 .09283 L
.20102 .07445 L
.20104 .0976 L
.20105 .12333 L
.20105 .10645 L
.20107 .08998 L
.20108 .11758 L
.2011 .11426 L
Mistroke
.20111 .12837 L
.20112 .11206 L
.20113 .10663 L
.20114 .10305 L
.20116 .10104 L
.20117 .12973 L
.20118 .11014 L
.20119 .13889 L
.2012 .13436 L
.20122 .11073 L
.20123 .09932 L
.20124 .09393 L
.20125 .10593 L
.20126 .11192 L
.20127 .12046 L
.20128 .10329 L
.2013 .13279 L
.2013 .08548 L
.20131 .09308 L
.20133 .14744 L
.20134 .08098 L
.20135 .11386 L
.20136 .14705 L
.20136 .06195 L
.20137 .09765 L
.20138 .1029 L
.2014 .13632 L
.20141 .13455 L
.20142 .09688 L
.20143 .12676 L
.20144 .15402 L
.20146 .0866 L
.20146 .13553 L
.20147 .11251 L
.20149 .10194 L
.2015 .08548 L
.20152 .14067 L
.20153 .14373 L
.20155 .08454 L
.20156 .10707 L
.20157 .10759 L
.20159 .11849 L
.2016 .13592 L
.20162 .09166 L
.20163 .11377 L
.20164 .14284 L
.20165 .13077 L
.20166 .12411 L
.20172 .09577 L
.20175 .08271 L
Mistroke
.20176 .10252 L
.20177 .11569 L
.20178 .12124 L
.20179 .07099 L
.2018 .10843 L
.20182 .09579 L
.20183 .10923 L
.20184 .07344 L
.20185 .10156 L
.20187 .0952 L
.20188 .10015 L
.20188 .11893 L
.2019 .09367 L
.20191 .12572 L
.20192 .07075 L
.20193 .14107 L
.20194 .16762 L
.20195 .1356 L
.20196 .08219 L
.20197 .14358 L
.20198 .1503 L
.20199 .13763 L
.20201 .09855 L
.20202 .11492 L
.20204 .09653 L
.20205 .05451 L
.20206 .09999 L
.20207 .13155 L
.20208 .11946 L
.20209 .12191 L
.2021 .10804 L
.20211 .07444 L
.20213 .118 L
.20214 .11477 L
.20216 .11129 L
.20217 .09466 L
.20219 .1139 L
.2022 .10906 L
.20222 .09606 L
.20223 .12321 L
.20224 .1475 L
.20226 .12283 L
.20227 .11599 L
.20228 .07884 L
.2023 .09043 L
.20231 .09587 L
.20232 .13581 L
.20234 .10721 L
.20235 .11148 L
.20237 .07138 L
Mistroke
.20238 .11584 L
.2024 .0784 L
.20241 .11501 L
.20242 .11334 L
.20244 .11511 L
.20256 .12602 L
.20258 .10891 L
.20259 .07345 L
.20259 .13835 L
.20261 .12807 L
.20262 .12283 L
.20264 .07281 L
.20265 .10968 L
.20267 .07332 L
.20268 .11313 L
.20268 .10724 L
.20269 .10446 L
.2027 .11468 L
.20272 .11816 L
.20273 .08896 L
.20274 .08079 L
.20274 .06609 L
.20275 .13848 L
.20277 .11358 L
.20278 .0958 L
.20278 .11499 L
.2028 .14384 L
.20281 .15319 L
.20283 .12665 L
.20284 .07753 L
.20286 .10531 L
.20287 .10851 L
.20289 .14631 L
.2029 .06419 L
.20291 .11764 L
.20293 .06096 L
.20294 .09037 L
.20296 .12801 L
.20297 .08712 L
.20299 .1302 L
.203 .10813 L
.20301 .11295 L
.20302 .10695 L
.20303 .09567 L
.20305 .08803 L
.20306 .12963 L
.20308 .10941 L
.20309 .13607 L
.2031 .11828 L
.20312 .12354 L
Mistroke
.20313 .10361 L
.20315 .06483 L
.20316 .0888 L
.20317 .11489 L
.20319 .1351 L
.2032 .10742 L
.20321 .10709 L
.20323 .09429 L
.20324 .08093 L
.20326 .10544 L
.20327 .16047 L
.20328 .10701 L
.2033 .15088 L
.20331 .05742 L
.20332 .09967 L
.20334 .12091 L
.20335 .07392 L
.20336 .10403 L
.20337 .12493 L
.20338 .10506 L
.2034 .09717 L
.20341 .09012 L
.20342 .07623 L
.20344 .10893 L
.20345 .10944 L
.20347 .09202 L
.20348 .12772 L
.20349 .09451 L
.20351 .09636 L
.20352 .102 L
.20352 .09469 L
.20354 .10728 L
.20355 .11283 L
.20356 .10776 L
.20357 .12462 L
.20358 .10665 L
.20359 .08586 L
.2036 .07427 L
.20361 .13619 L
.20362 .13957 L
.20363 .13423 L
.20365 .09183 L
.20366 .1137 L
.20368 .10594 L
.20369 .10258 L
.2037 .10017 L
.20371 .13693 L
.20372 .07898 L
.20373 .13526 L
.20374 .12427 L
Mistroke
.20376 .11412 L
.20377 .12539 L
.20378 .09227 L
.2038 .0764 L
.20381 .08994 L
.20382 .10441 L
.20383 .10578 L
.20384 .11184 L
.20386 .08569 L
.20387 .10177 L
.20389 .11847 L
.2039 .12441 L
.20391 .08862 L
.20393 .09828 L
.20394 .13072 L
.20395 .10414 L
.20397 .13777 L
.20398 .09823 L
.20399 .12006 L
.204 .11112 L
.20402 .13964 L
.20403 .12535 L
.20404 .10795 L
.20405 .1237 L
.20406 .1419 L
.20407 .09694 L
.20408 .1589 L
.20409 .12104 L
.2041 .12034 L
.20411 .13832 L
.20413 .12476 L
.20414 .11128 L
.20415 .14173 L
.20417 .11518 L
.20418 .12685 L
.20419 .1155 L
.2042 .11627 L
.20422 .12247 L
.20423 .11113 L
.20424 .11698 L
.20425 .08172 L
.20426 .10342 L
.20426 .10454 L
.20427 .11233 L
.20428 .10672 L
.2043 .0812 L
.20431 .11756 L
.20433 .07506 L
.20434 .12404 L
.20436 .12877 L
Mistroke
.20437 .12057 L
.20437 .13171 L
.20439 .09072 L
.2044 .0571 L
.20441 .09179 L
.20442 .12167 L
.20443 .11066 L
.20444 .13596 L
.20445 .10718 L
.20446 .09462 L
.20447 .09572 L
.20447 .11361 L
.20449 .11935 L
.2045 .10821 L
.20452 .1017 L
.20453 .11427 L
.20455 .07969 L
.20455 .11006 L
.20456 .1166 L
.20458 .12916 L
.20459 .11435 L
.20461 .1175 L
.20462 .12766 L
.20464 .08358 L
.20465 .09426 L
.20467 .06928 L
.20468 .13921 L
.20468 .08441 L
.20469 .12283 L
.2047 .06899 L
.20471 .11844 L
.20472 .09373 L
.20473 .06839 L
.20475 .07711 L
.20476 .11748 L
.20477 .11045 L
.20479 .10682 L
.2048 .09342 L
.2048 .09935 L
.20482 .08447 L
.20483 .09625 L
.20484 .15696 L
.20485 .11009 L
.20486 .13031 L
.20487 .1108 L
.20488 .11092 L
.20489 .17487 L
.2049 .10322 L
.20491 .14769 L
.20493 .04314 L
Mistroke
.20494 .09068 L
.20496 .11204 L
.20497 .10714 L
.20498 .1293 L
.205 .10779 L
.20501 .10205 L
.20502 .13175 L
.20504 .1011 L
.20505 .11783 L
.20506 .14301 L
.20508 .08999 L
.20509 .13265 L
.20511 .11724 L
.20512 .08072 L
.20513 .13935 L
.20514 .12685 L
.20515 .1204 L
.20516 .08887 L
.20518 .10149 L
.20519 .09751 L
.20521 .08868 L
.20522 .13785 L
.20523 .07819 L
.20525 .12972 L
.20526 .10465 L
.20527 .10844 L
.20528 .08188 L
.20529 .11628 L
.20531 .06419 L
.20532 .10131 L
.20534 .11314 L
.20535 .11027 L
.20536 .09608 L
.20538 .15283 L
.20539 .11916 L
.2054 .09079 L
.20542 .06176 L
.20543 .09404 L
.20544 .14796 L
.20545 .09787 L
.20547 .09759 L
.20548 .14334 L
.2055 .10634 L
.20551 .1367 L
.20552 .09604 L
.20553 .11286 L
.20554 .11935 L
.20555 .11977 L
.20556 .11391 L
.20557 .10066 L
Mistroke
.20558 .11618 L
.20559 .11799 L
.2056 .10683 L
.20562 .099 L
.20563 .07334 L
.20564 .12138 L
.20565 .14039 L
.20567 .13799 L
.20568 .11804 L
.20569 .13821 L
.20571 .09121 L
.20572 .10181 L
.20573 .13632 L
.20574 .14114 L
.20576 .12728 L
.20577 .10491 L
.20578 .09129 L
.2058 .08572 L
.20581 .13124 L
.20582 .09919 L
.20584 .07077 L
.20585 .12094 L
.20587 .11638 L
.20588 .0924 L
.20589 .11855 L
.2059 .09943 L
.20591 .07493 L
.20593 .11595 L
.20594 .13877 L
.20595 .12069 L
.20596 .09169 L
.20597 .09762 L
.20598 .09428 L
.20599 .11444 L
.206 .10183 L
.20601 .09974 L
.20602 .0886 L
.20604 .11231 L
.20605 .12795 L
.20607 .1354 L
.20608 .08758 L
.20609 .11207 L
.2061 .11123 L
.20611 .12731 L
.20613 .10821 L
.20614 .10185 L
.20616 .1189 L
.20617 .13025 L
.20619 .05404 L
.2062 .14848 L
Mistroke
.20621 .11343 L
.20622 .11912 L
.20623 .11508 L
.20625 .11401 L
.20626 .1086 L
.20627 .09838 L
.20629 .0977 L
.2063 .09507 L
.20631 .08224 L
.20633 .12236 L
.20634 .11779 L
.20635 .09468 L
.20637 .1021 L
.20638 .11347 L
.20639 .10675 L
.2064 .08428 L
.20642 .11051 L
.20643 .13307 L
.20645 .09143 L
.20646 .11128 L
.20647 .13516 L
.20648 .08727 L
.20649 .09564 L
.2065 .10368 L
.20651 .09163 L
.20652 .13009 L
.20653 .12097 L
.20654 .10578 L
.20655 .16581 L
.20657 .10597 L
.20658 .11442 L
.20659 .12176 L
.2066 .09586 L
.20662 .1732 L
.20663 .12829 L
.20664 .14139 L
.20666 .09905 L
.20667 .07513 L
.20668 .08411 L
.20669 .07676 L
.20671 .09186 L
.20672 .07904 L
.20673 .1274 L
.20675 .0884 L
.20676 .08618 L
.20677 .09221 L
.20679 .10214 L
.2068 .08025 L
.20681 .13069 L
.20683 .09084 L
Mistroke
.20684 .15005 L
.20685 .14064 L
.20686 .11885 L
.20688 .09983 L
.20689 .11842 L
.2069 .10129 L
.20691 .09977 L
.20692 .09292 L
.20693 .12046 L
.20694 .10614 L
.20695 .13063 L
.20696 .1234 L
.20697 .09478 L
.20699 .11384 L
.207 .1157 L
.20701 .07223 L
.20703 .08569 L
.20704 .07267 L
.20705 .10321 L
.20706 .14313 L
.20708 .08281 L
.20709 .12441 L
.2071 .08882 L
.20711 .11442 L
.20712 .07667 L
.20713 .08149 L
.20713 .10148 L
.20714 .08402 L
.20716 .10821 L
.20717 .13105 L
.20719 .10346 L
.20719 .11368 L
.2072 .11402 L
.20721 .09038 L
.20722 .0879 L
.20723 .13673 L
.20724 .11344 L
.20724 .10153 L
.20725 .12147 L
.20726 .12962 L
.20727 .08887 L
.20728 .09089 L
.20729 .09718 L
.2073 .09551 L
.2073 .11043 L
.20732 .15064 L
.20733 .11645 L
.20734 .12337 L
.20735 .09372 L
.20736 .1436 L
Mistroke
.20737 .08159 L
.20738 .11754 L
.2074 .12167 L
.20741 .07048 L
.20742 .09909 L
.20744 .10107 L
.20745 .14939 L
.20747 .11191 L
.20748 .13556 L
.20748 .15606 L
.2075 .08005 L
.20751 .13048 L
.20752 .10084 L
.20753 .14323 L
.20754 .16381 L
.20755 .11274 L
.20756 .09568 L
.20757 .09002 L
.20758 .11643 L
.20759 .10252 L
.20761 .08431 L
.20762 .11514 L
.20763 .10146 L
.20764 .09981 L
.20766 .12633 L
.20767 .14133 L
.20769 .10903 L
.2077 .09628 L
.20771 .14029 L
.20773 .16799 L
.20774 .10906 L
.20775 .08355 L
.20777 .0893 L
.20778 .12611 L
.2078 .13051 L
.20781 .09603 L
.20783 .13178 L
.20784 .11886 L
.20785 .12849 L
.20786 .10361 L
.20787 .09424 L
.20789 .14986 L
.2079 .11169 L
.20791 .08967 L
.20792 .11341 L
.20792 .08225 L
.20793 .10684 L
.20794 .0922 L
.20796 .13306 L
.20797 .11713 L
Mistroke
.20798 .0744 L
.208 .1514 L
.20801 .108 L
.20802 .07048 L
.20803 .11994 L
.20805 .07296 L
.20806 .14945 L
.20808 .10394 L
.20809 .09135 L
.20809 .10766 L
.20811 .0943 L
.20812 .09449 L
.20814 .12213 L
.20815 .10158 L
.20816 .0879 L
.20818 .08523 L
.20819 .1001 L
.2082 .09287 L
.20821 .09603 L
.20823 .11453 L
.20823 .09173 L
.20824 .12821 L
.20826 .06033 L
.20827 .14134 L
.20829 .06421 L
.2083 .1167 L
.20831 .0903 L
.20833 .09835 L
.20834 .08102 L
.20835 .10644 L
.20837 .10782 L
.20838 .08349 L
.2084 .11924 L
.20841 .1214 L
.20843 .11344 L
.20844 .11722 L
.20845 .09773 L
.20847 .08758 L
.20848 .10367 L
.20849 .09535 L
.20851 .11198 L
.20852 .08799 L
.20854 .11056 L
.20855 .08699 L
.20856 .08124 L
.20858 .12266 L
.20859 .07957 L
.20861 .10824 L
.20862 .12058 L
.20863 .05891 L
Mistroke
.20864 .09234 L
.20865 .08215 L
.20866 .12911 L
.20867 .1276 L
.20868 .15347 L
.20869 .1069 L
.2087 .11337 L
.20871 .14651 L
.20873 .12617 L
.20874 .08395 L
.20874 .1265 L
.20876 .08435 L
.20877 .11945 L
.20878 .15563 L
.20879 .06603 L
.20881 .08851 L
.20882 .05912 L
.20884 .12079 L
.20884 .10869 L
.20885 .11008 L
.20886 .09359 L
.20887 .12221 L
.20888 .12814 L
.20889 .12977 L
.2089 .09488 L
.20892 .12134 L
.20893 .10842 L
.20895 .07593 L
.20895 .13146 L
.20896 .09402 L
.20897 .11148 L
.20898 .11773 L
.20899 .10131 L
.209 .12839 L
.20901 .12321 L
.20903 .09869 L
.20903 .10294 L
.20904 .09234 L
.20906 .12999 L
.20907 .11402 L
.20908 .13429 L
.20909 .11786 L
.2091 .11033 L
.20911 .09765 L
.20912 .11016 L
.20913 .0849 L
.20914 .08161 L
.20915 .11575 L
.20917 .08954 L
.20918 .11661 L
Mistroke
.20919 .06863 L
.20921 .11236 L
.20922 .08618 L
.20922 .1308 L
.20924 .1068 L
.20925 .10025 L
.20926 .11848 L
.20927 .11962 L
.20929 .11871 L
.2093 .12927 L
.20931 .12237 L
.20933 .12797 L
.20934 .14634 L
.20935 .11838 L
.20936 .12464 L
.20937 .09905 L
.20939 .15117 L
.2094 .13709 L
.20941 .08297 L
.20943 .1188 L
.20944 .12207 L
.20945 .09138 L
.20947 .10916 L
.20948 .13813 L
.2095 .1524 L
.20951 .06631 L
.20952 .09263 L
.20954 .06962 L
.20955 .10837 L
.20956 .12856 L
.20957 .15289 L
.20958 .12214 L
.2096 .08039 L
.20961 .10479 L
.20962 .0948 L
.20964 .1136 L
.20965 .07414 L
.20966 .14169 L
.20968 .08566 L
.20969 .1459 L
.20971 .12957 L
.20972 .1067 L
.20973 .11301 L
.20974 .07428 L
.20975 .09932 L
.20977 .12262 L
.20978 .07388 L
.20978 .1425 L
.2098 .11944 L
.20981 .0779 L
Mistroke
.20982 .09079 L
.20982 .10899 L
.20983 .10485 L
.20985 .08685 L
.20986 .13868 L
.20987 .15273 L
.20988 .11412 L
.2099 .06942 L
.20991 .10743 L
.20992 .06992 L
.20994 .11473 L
.20995 .12403 L
.20997 .15049 L
.20998 .08696 L
.20998 .12684 L
.21 .10813 L
.21001 .08479 L
.21002 .11175 L
.21003 .09411 L
.21005 .07629 L
.21006 .12257 L
.21008 .09341 L
.21008 .15428 L
.21009 .13349 L
.2101 .11831 L
.21011 .06589 L
.21013 .06787 L
.21014 .11586 L
.21015 .13086 L
.21016 .09208 L
.21017 .11691 L
.21018 .10553 L
.21019 .10941 L
.2102 .1175 L
.21021 .11729 L
.21022 .11281 L
.21024 .09895 L
.21025 .11024 L
.21026 .11341 L
.21027 .11386 L
.21028 .15718 L
.2103 .1133 L
.21031 .1271 L
.21033 .10507 L
.21033 .14942 L
.21034 .12508 L
.21036 .14403 L
.21037 .0909 L
.21039 .1231 L
.2104 .1509 L
Mistroke
.21041 .10439 L
.21042 .1316 L
.21043 .08128 L
.21043 .09429 L
.21044 .07699 L
.21045 .11761 L
.21047 .12093 L
.21048 .12678 L
.2105 .12188 L
.21051 .10787 L
.21054 .08451 L
.21055 .1388 L
.21056 .09019 L
.21057 .06624 L
.21058 .1142 L
.2106 .09463 L
.21061 .12321 L
.21062 .09696 L
.21064 .09246 L
.21065 .1237 L
.21066 .13582 L
.21068 .123 L
.2107 .10914 L
.2107 .08496 L
.21071 .14322 L
.21073 .09391 L
.21074 .12519 L
.21075 .10204 L
.21076 .13301 L
.21077 .06653 L
.21078 .12603 L
.21079 .11436 L
.2108 .12087 L
.21081 .12143 L
.21082 .09779 L
.21084 .11624 L
.21085 .1191 L
.21087 .09847 L
.21088 .14796 L
.21089 .11234 L
.2109 .12607 L
.21091 .07715 L
.21093 .08703 L
.21094 .12598 L
.21094 .07065 L
.21096 .11007 L
.21098 .10547 L
.21098 .09524 L
.21099 .10257 L
.21101 .09774 L
Mistroke
.21102 .07129 L
.21104 .10179 L
.21105 .10954 L
.21106 .08008 L
.21107 .08496 L
.21108 .09765 L
.21109 .10128 L
.2111 .14783 L
.21111 .11753 L
.21112 .10387 L
.21113 .08319 L
.21113 .11897 L
.21114 .08863 L
.21115 .05712 L
.21116 .10238 L
.21117 .11734 L
.21118 .11407 L
.21119 .10356 L
.2112 .10924 L
.21121 .11387 L
.21123 .1072 L
.21125 .1389 L
.21126 .12474 L
.21127 .14386 L
.21129 .12245 L
.2113 .0735 L
.21132 .15107 L
.21133 .08767 L
.21133 .10801 L
.21135 .10907 L
.21136 .0913 L
.21137 .12053 L
.21138 .11983 L
.21139 .09774 L
.2114 .12408 L
.21141 .13831 L
.21142 .12573 L
.21143 .09399 L
.21144 .07366 L
.21146 .09516 L
.21147 .1391 L
.21149 .09074 L
.2115 .10372 L
.21151 .09004 L
.21153 .11901 L
.21154 .13362 L
.21155 .10355 L
.21156 .07538 L
.21157 .11736 L
.21158 .09552 L
Mistroke
.21159 .11438 L
.2116 .12385 L
.21161 .09546 L
.21162 .13741 L
.21164 .12062 L
.21165 .09582 L
.21167 .13822 L
.21168 .11432 L
.21169 .06807 L
.2117 .08669 L
.21171 .09643 L
.21171 .10688 L
.21173 .15824 L
.21174 .13583 L
.21176 .04553 L
.21177 .08528 L
.21179 .10367 L
.2118 .09719 L
.21181 .11071 L
.21181 .10965 L
.21182 .11978 L
.21184 .09509 L
.21185 .14274 L
.21186 .08247 L
.21187 .11899 L
.21188 .11282 L
.21189 .13561 L
.2119 .11448 L
.21191 .12234 L
.21192 .10873 L
.21193 .11587 L
.21195 .1025 L
.21196 .08296 L
.21198 .13146 L
.21199 .11743 L
.212 .11865 L
.21202 .09201 L
.21203 .12694 L
.21204 .09377 L
.21205 .10196 L
.21206 .08227 L
.21207 .09833 L
.21208 .09064 L
.21209 .09072 L
.2121 .12154 L
.21211 .09157 L
.21213 .13144 L
.21214 .08282 L
.21216 .09653 L
.21217 .09181 L
Mistroke
.21219 .12037 L
.2122 .09633 L
.2122 .12902 L
.21222 .09959 L
.21223 .11686 L
.21225 .1263 L
.21226 .10241 L
.21228 .1059 L
.21229 .1086 L
.2123 .09377 L
.21231 .09984 L
.21232 .15157 L
.21233 .13965 L
.21234 .10979 L
.21235 .09394 L
.21236 .07373 L
.21238 .10213 L
.21239 .11535 L
.2124 .10895 L
.21241 .14403 L
.21242 .11661 L
.21242 .10469 L
.21244 .06653 L
.21245 .11961 L
.21247 .13325 L
.21248 .14363 L
.21249 .0896 L
.2125 .07231 L
.21251 .09555 L
.21252 .11629 L
.21253 .09029 L
.21255 .09865 L
.21256 .10569 L
.21257 .11256 L
.21259 .07008 L
.2126 .07587 L
.21262 .13511 L
.21263 .05761 L
.21264 .09204 L
.21266 .10742 L
.21267 .11039 L
.21268 .09608 L
.21269 .10682 L
.2127 .10333 L
.21271 .09391 L
.21272 .12566 L
.21272 .14949 L
.21274 .12841 L
.21275 .103 L
.21276 .08477 L
Mistroke
.21276 .11375 L
.21277 .10105 L
.21279 .08745 L
.2128 .13288 L
.21281 .08129 L
.21282 .08064 L
.21284 .07317 L
.21285 .06641 L
.21287 .07258 L
.21288 .07186 L
.21289 .0962 L
.21291 .09218 L
.21292 .12961 L
.21294 .10563 L
.21295 .13782 L
.21297 .13378 L
.21298 .13112 L
.21299 .15413 L
.21301 .09871 L
.21302 .09017 L
.21303 .12175 L
.21304 .11488 L
.21305 .09622 L
.21307 .08375 L
.21308 .15626 L
.21309 .12424 L
.2131 .09692 L
.21311 .08615 L
.21312 .12582 L
.21313 .12869 L
.21313 .12614 L
.21315 .11177 L
.21316 .12888 L
.21317 .09761 L
.21317 .10163 L
.21318 .12227 L
.2132 .10316 L
.21321 .12792 L
.21321 .09209 L
.21323 .10717 L
.21324 .10692 L
.21325 .09641 L
.21326 .14237 L
.21327 .10451 L
.21328 .07997 L
.21329 .08048 L
.2133 .12331 L
.21331 .13091 L
.21332 .09242 L
.21333 .1451 L
Mistroke
.21334 .09229 L
.21336 .09089 L
.21337 .08788 L
.21339 .11208 L
.2134 .09226 L
.21342 .14856 L
.21343 .12914 L
.21344 .1125 L
.21346 .13248 L
.21347 .13207 L
.21347 .11509 L
.21349 .12512 L
.2135 .07337 L
.21352 .08478 L
.21353 .1078 L
.21354 .07023 L
.21355 .14728 L
.21357 .10598 L
.21358 .10392 L
.2136 .14092 L
.21361 .13043 L
.21363 .12645 L
.21363 .1316 L
.21364 .12249 L
.21366 .14239 L
.21367 .1088 L
.21368 .09094 L
.21369 .131 L
.2137 .07261 L
.21371 .07652 L
.21372 .11763 L
.21373 .05789 L
.21374 .1156 L
.21375 .13123 L
.21376 .08189 L
.21377 .11593 L
.21379 .13251 L
.2138 .11415 L
.21381 .13461 L
.21383 .1377 L
.21384 .16019 L
.21386 .13598 L
.21387 .11593 L
.21389 .08434 L
.2139 .11581 L
.21391 .12315 L
.21392 .15516 L
.21394 .09399 L
.21395 .09111 L
.21397 .11027 L
Mistroke
.21398 .0849 L
.214 .07531 L
.214 .11386 L
.21401 .12575 L
.21403 .10938 L
.21404 .11248 L
.21404 .11053 L
.21405 .08583 L
.21406 .07723 L
.21407 .1015 L
.21408 .12401 L
.21409 .10854 L
.21409 .12883 L
.2141 .11166 L
.21411 .10481 L
.21412 .10592 L
.21413 .11978 L
.21414 .16326 L
.21416 .083 L
.21417 .13617 L
.21419 .14312 L
.2142 .15045 L
.2142 .11768 L
.21421 .11513 L
.21422 .10204 L
.21423 .1054 L
.21424 .12768 L
.21425 .0684 L
.21427 .11613 L
.21428 .09637 L
.21429 .0978 L
.21431 .1554 L
.21432 .1227 L
.21432 .10154 L
.21434 .10044 L
.21435 .10846 L
.21437 .11558 L
.21438 .11063 L
.21438 .11066 L
.2144 .113 L
.21441 .10015 L
.21443 .12774 L
.21444 .12344 L
.21445 .10472 L
.21447 .141 L
.21448 .13556 L
.2145 .12934 L
.21451 .10361 L
.21452 .12113 L
.21453 .14902 L
Mistroke
.21455 .11674 L
.21456 .13045 L
.21457 .1338 L
.21459 .12665 L
.2146 .10534 L
.21462 .09268 L
.21463 .11806 L
.21465 .10124 L
.21466 .07199 L
.21467 .12416 L
.21469 .08933 L
.2147 .13299 L
.2147 .09685 L
.21472 .13568 L
.21473 .15169 L
.21474 .09139 L
.21476 .08602 L
.21477 .12385 L
.21478 .11278 L
.2148 .10364 L
.21481 .13148 L
.21483 .1028 L
.21484 .14116 L
.21485 .11772 L
.21486 .07155 L
.21486 .12186 L
.21487 .10423 L
.21489 .09537 L
.2149 .10846 L
.21491 .1337 L
.21492 .09531 L
.21493 .11692 L
.21495 .06767 L
.21496 .13035 L
.21498 .12796 L
.21499 .11297 L
.215 .10192 L
.21502 .07418 L
.21503 .06552 L
.21504 .09213 L
.21506 .11532 L
.21507 .1277 L
.21508 .10011 L
.21509 .13209 L
.21511 .12226 L
.21512 .13992 L
.21514 .10484 L
.21515 .10552 L
.21516 .10814 L
.2153 .12497 L
Mistroke
.21531 .07013 L
.21533 .10502 L
.21534 .12913 L
.21536 .11224 L
.21537 .11293 L
.21539 .13173 L
.2154 .13765 L
.21541 .08082 L
.21542 .1361 L
.21543 .09866 L
.21544 .15391 L
.21546 .10814 L
.21547 .13044 L
.21549 .09838 L
.2155 .112 L
.21551 .1367 L
.21553 .11131 L
.21554 .11493 L
.21555 .14134 L
.21555 .12146 L
.21556 .12755 L
.21558 .07322 L
.21559 .12827 L
.2156 .07937 L
.21561 .15492 L
.21562 .11141 L
.21563 .15338 L
.21564 .0833 L
.21565 .10645 L
.21566 .13214 L
.21567 .07282 L
.21568 .09146 L
.21569 .10515 L
.2157 .14044 L
.21571 .12006 L
.21572 .07619 L
.21574 .07444 L
.21575 .14877 L
.21577 .09463 L
.21578 .09917 L
.21579 .15513 L
.21581 .09699 L
.21582 .10306 L
.21583 .14564 L
.21584 .0854 L
.21585 .16023 L
.21586 .11447 L
.21587 .11804 L
.21587 .13783 L
.21588 .13001 L
Mistroke
.21589 .1135 L
.21591 .14993 L
.21592 .10943 L
.21594 .11577 L
.21595 .09438 L
.21596 .0981 L
.21598 .12871 L
.21599 .10983 L
.21599 .08369 L
.21601 .08734 L
.21602 .10127 L
.21603 .07985 L
.21604 .11941 L
.21605 .1299 L
.21607 .10647 L
.21608 .13623 L
.2161 .10438 L
.2161 .11691 L
.21611 .12051 L
.21613 .09832 L
.21614 .13641 L
.21615 .11897 L
.21617 .0874 L
.21618 .1444 L
.2162 .09645 L
.21621 .13135 L
.21622 .1294 L
.21624 .11393 L
.21625 .06642 L
.21626 .12379 L
.21628 .07903 L
.21629 .12069 L
.21631 .0898 L
.21632 .08222 L
.21633 .0896 L
.21634 .08555 L
.21635 .09725 L
.21637 .09419 L
.21638 .13912 L
.21639 .14316 L
.21641 .09452 L
.21642 .12796 L
.21643 .10328 L
.21645 .10146 L
.21646 .09518 L
.21648 .10713 L
.21649 .11501 L
.2165 .14554 L
.21651 .12479 L
.21652 .09838 L
Mistroke
.21654 .08549 L
.21655 .11537 L
.21655 .13788 L
.21657 .06928 L
.21658 .11304 L
.21659 .1244 L
.21659 .13891 L
.2166 .10884 L
.21662 .13046 L
.21663 .15532 L
.21665 .12267 L
.21666 .1083 L
.21667 .08681 L
.21668 .14477 L
.21669 .09955 L
.21671 .11736 L
.21672 .10093 L
.21672 .08771 L
.21674 .12557 L
.21675 .10274 L
.21677 .1173 L
.21678 .11918 L
.21679 .15586 L
.2168 .0884 L
.21681 .11909 L
.21683 .09859 L
.21684 .0991 L
.21686 .08824 L
.21687 .13759 L
.21688 .12963 L
.2169 .09529 L
.21691 .1315 L
.21693 .11925 L
.21694 .08271 L
.21695 .09039 L
.21697 .14383 L
.21698 .13648 L
.217 .08793 L
.21701 .1206 L
.21701 .13884 L
.21703 .11472 L
.21704 .10779 L
.21706 .08737 L
.21707 .12724 L
.21708 .06727 L
.21709 .08216 L
.2171 .15682 L
.21711 .12066 L
.21712 .11658 L
.21714 .1064 L
Mistroke
.21714 .09611 L
.21715 .09831 L
.21716 .1038 L
.21717 .10585 L
.21719 .13113 L
.21719 .14545 L
.2172 .16962 L
.21722 .11135 L
.21723 .15036 L
.21725 .09778 L
.21726 .11277 L
.21727 .13846 L
.21728 .12671 L
.21729 .12479 L
.2173 .13781 L
.21731 .11831 L
.21732 .0637 L
.21734 .11368 L
.21735 .09691 L
.21737 .13647 L
.21738 .1026 L
.21739 .1085 L
.21741 .11891 L
.21742 .10992 L
.21744 .12966 L
.21745 .13351 L
.21747 .112 L
.21748 .14578 L
.21749 .10443 L
.21751 .11912 L
.21752 .11117 L
.21753 .11229 L
.21754 .12349 L
.21755 .08351 L
.21756 .10021 L
.21757 .13398 L
.21757 .12144 L
.21759 .10639 L
.2176 .12019 L
.21761 .07757 L
.21762 .08533 L
.21762 .13733 L
.21763 .10471 L
.21764 .07137 L
.21765 .11965 L
.21766 .09569 L
.21767 .08503 L
.21769 .11503 L
.2177 .09253 L
.21772 .07119 L
Mistroke
.21773 .0775 L
.21775 .12108 L
.21776 .15139 L
.21777 .10222 L
.21779 .09602 L
.2178 .10105 L
.21781 .12117 L
.21783 .09174 L
.21784 .07315 L
.21786 .12515 L
.21787 .10394 L
.21788 .14473 L
.21789 .10498 L
.21791 .10347 L
.21792 .10962 L
.21793 .09507 L
.21795 .14649 L
.21796 .12185 L
.21798 .09995 L
.21799 .07712 L
.218 .10681 L
.21801 .10118 L
.21803 .10442 L
.21804 .1112 L
.21805 .1195 L
.21807 .11281 L
.21808 .0705 L
.2181 .1389 L
.2181 .09634 L
.21811 .14664 L
.21813 .14591 L
.21814 .07183 L
.21815 .13516 L
.21817 .08609 L
.21818 .10233 L
.2182 .11182 L
.21821 .09717 L
.21823 .10521 L
.21824 .15412 L
.21825 .06346 L
.21827 .09938 L
.21828 .12584 L
.2183 .12629 L
.21831 .11881 L
.21833 .10945 L
.21834 .11563 L
.21834 .08843 L
.21836 .09559 L
.21837 .12987 L
.21839 .08193 L
Mistroke
.2184 .14451 L
.21842 .12128 L
.21843 .12959 L
.21844 .12645 L
.21845 .13473 L
.21847 .09866 L
.21848 .12505 L
.21849 .1351 L
.21851 .11537 L
.21852 .10206 L
.21853 .13507 L
.21855 .10275 L
.21856 .09821 L
.21856 .12398 L
.21858 .09866 L
.21859 .16215 L
.21861 .10287 L
.21862 .12039 L
.21864 .14868 L
.21865 .13071 L
.21867 .13776 L
.21868 .08281 L
.21869 .13797 L
.21871 .13426 L
.21874 .10462 L
.21875 .13214 L
.21875 .12917 L
.21877 .06095 L
.21878 .13116 L
.2188 .11774 L
.21881 .08706 L
.21883 .0922 L
.21884 .10555 L
.21885 .12133 L
.21887 .10777 L
.21888 .11133 L
.21893 .1276 L
.21895 .1391 L
.21896 .13452 L
.21897 .07949 L
.21898 .15301 L
.21899 .12264 L
.21901 .12488 L
.21902 .12757 L
.21904 .12034 L
.21905 .10119 L
.21906 .10133 L
.21908 .09877 L
.21909 .0659 L
.21911 .12789 L
Mistroke
.21911 .13618 L
.21912 .10723 L
.21914 .13941 L
.21915 .10657 L
.21917 .11875 L
.21918 .12642 L
.2192 .10681 L
.21921 .1168 L
.21922 .10869 L
.21924 .1255 L
.21925 .10208 L
.21926 .10842 L
.21928 .10053 L
.21929 .10614 L
.2193 .06271 L
.21931 .13425 L
.21933 .11807 L
.21934 .12705 L
.21936 .12689 L
.21936 .09138 L
.21937 .11178 L
.21938 .10565 L
.21939 .12472 L
.2194 .10262 L
.21941 .09811 L
.21942 .08063 L
.21944 .10303 L
.21945 .116 L
.21947 .0858 L
.21948 .11473 L
.21949 .13429 L
.2195 .06999 L
.21951 .10425 L
.21953 .11923 L
.21954 .05468 L
.21955 .12285 L
.21956 .10781 L
.21957 .10148 L
.21959 .14304 L
.2196 .10339 L
.21961 .05728 L
.21963 .1055 L
.21964 .12245 L
.21966 .11451 L
.21966 .12313 L
.21967 .0921 L
.21969 .13132 L
.2197 .1148 L
.21971 .10492 L
.21972 .09497 L
Mistroke
.21974 .10714 L
.21975 .06525 L
.21976 .08407 L
.21978 .10176 L
.21979 .09335 L
.2198 .0793 L
.21981 .1425 L
.21983 .11849 L
.21984 .1351 L
.21986 .09366 L
.21987 .09287 L
.21989 .08185 L
.2199 .10578 L
.21991 .0991 L
.21993 .15299 L
.21994 .13287 L
.21995 .12559 L
.21997 .0871 L
.21998 .13879 L
.22 .13673 L
.22001 .10912 L
.22002 .08143 L
.22003 .13571 L
.22004 .0854 L
.22005 .13636 L
.22006 .10937 L
.22008 .12009 L
.22009 .14212 L
.22011 .13133 L
.22012 .09452 L
.22013 .12552 L
.22015 .07079 L
.22016 .08872 L
.22017 .14508 L
.22019 .09888 L
.2202 .08872 L
.22022 .10169 L
.22023 .11153 L
.22025 .12243 L
.22026 .12717 L
.22028 .12244 L
.22029 .10027 L
.2203 .09214 L
.22031 .08468 L
.22032 .13058 L
.22033 .09349 L
.22034 .14028 L
.22035 .13875 L
.22036 .15063 L
.22037 .09289 L
Mistroke
.22038 .1268 L
.22039 .1239 L
.2204 .12247 L
.22041 .10194 L
.22041 .11062 L
.22042 .07566 L
.22043 .13201 L
.22044 .13511 L
.22045 .07836 L
.22047 .15574 L
.22048 .13239 L
.2205 .08287 L
.22051 .10265 L
.22053 .06689 L
.22054 .08307 L
.22055 .09813 L
.22057 .1374 L
.22058 .12102 L
.2206 .09219 L
.22061 .06779 L
.22063 .09557 L
.22064 .10806 L
.22066 .1565 L
.22066 .08436 L
.22067 .09905 L
.22069 .10557 L
.2207 .13703 L
.22072 .09786 L
.22073 .10655 L
.22074 .11693 L
.22076 .15269 L
.22077 .114 L
.22078 .11102 L
.2208 .10456 L
.22081 .14641 L
.22082 .11027 L
.22084 .12509 L
.22085 .12034 L
.22086 .15031 L
.22087 .16325 L
.22088 .11942 L
.22089 .07572 L
.22091 .09347 L
.22092 .10414 L
.22094 .10463 L
.22095 .06709 L
.22097 .08574 L
.22098 .11003 L
.221 .13728 L
.22101 .10452 L
Mistroke
.22102 .13231 L
.22104 .11927 L
.22105 .08362 L
.22107 .11916 L
.22108 .12776 L
.22109 .11888 L
.2211 .10652 L
.22111 .11309 L
.22112 .05609 L
.22113 .1167 L
.22114 .087 L
.22116 .08132 L
.22117 .09059 L
.22118 .14094 L
.2212 .12373 L
.22121 .10343 L
.22123 .11904 L
.22124 .11268 L
.22126 .11941 L
.22127 .14378 L
.22129 .12123 L
.2213 .10858 L
.22131 .09094 L
.22133 .11066 L
.22134 .10122 L
.22135 .08677 L
.22136 .10028 L
.22138 .13256 L
.22139 .1225 L
.22141 .13025 L
.22142 .12107 L
.22144 .10005 L
.22145 .10486 L
.22146 .1468 L
.22148 .09946 L
.22149 .10424 L
.2215 .09137 L
.22151 .09792 L
.22152 .1209 L
.22154 .08989 L
.22155 .12496 L
.22155 .10246 L
.22157 .11654 L
.22158 .13232 L
.2216 .10126 L
.22161 .14306 L
.22163 .13128 L
.22164 .13942 L
.22165 .10341 L
.22166 .10267 L
Mistroke
.22168 .15799 L
.22169 .12346 L
.22171 .11783 L
.22172 .07505 L
.22173 .07784 L
.22175 .11235 L
.22176 .12053 L
.22177 .12462 L
.22179 .11611 L
.2218 .13817 L
.22182 .10422 L
.22182 .13197 L
.22183 .0862 L
.22185 .11749 L
.22186 .07489 L
.22187 .14018 L
.22188 .09494 L
.22189 .12456 L
.2219 .12799 L
.22191 .09986 L
.22192 .07548 L
.22194 .10759 L
.22196 .13244 L
.22197 .11966 L
.22198 .07681 L
.222 .08176 L
.22201 .12512 L
.22202 .09461 L
.22204 .10217 L
.22205 .08281 L
.22207 .11138 L
.22208 .11929 L
.2221 .12096 L
.22211 .0829 L
.22213 .08568 L
.22214 .10258 L
.22215 .13389 L
.22216 .11524 L
.22217 .0731 L
.22218 .11375 L
.22219 .13062 L
.2222 .09264 L
.22221 .1288 L
.22222 .09338 L
.22223 .10454 L
.22224 .07158 L
.22225 .11101 L
.22226 .07126 L
.22226 .06817 L
.22227 .10343 L
Mistroke
.22228 .12422 L
.22229 .11574 L
.2223 .07934 L
.22232 .07987 L
.22233 .10045 L
.22235 .14024 L
.22236 .10569 L
.22237 .13376 L
.22239 .11895 L
.2224 .09474 L
.22241 .11722 L
.22242 .09823 L
.22243 .09299 L
.22245 .11867 L
.22246 .12214 L
.22248 .13249 L
.22249 .12019 L
.2225 .11555 L
.22252 .12177 L
.22253 .0873 L
.22254 .12522 L
.22256 .11778 L
.22257 .06951 L
.22258 .1026 L
.22259 .11642 L
.2226 .1204 L
.22262 .13383 L
.22263 .10744 L
.22265 .09607 L
.22266 .12562 L
.22267 .12523 L
.22268 .10745 L
.22269 .10525 L
.2227 .09276 L
.22271 .09771 L
.22272 .13536 L
.22273 .11671 L
.22274 .09118 L
.22276 .14147 L
.22277 .08238 L
.22278 .1277 L
.22279 .11315 L
.22281 .14993 L
.22282 .10455 L
.22283 .12766 L
.22285 .12179 L
.22286 .09517 L
.22288 .1381 L
.22289 .12284 L
.2229 .10835 L
Mistroke
.22291 .09675 L
.22292 .05998 L
.22294 .08136 L
.22295 .08657 L
.22297 .131 L
.22298 .10594 L
.22299 .07558 L
.223 .10572 L
.22302 .07559 L
.22303 .11569 L
.22304 .11847 L
.22305 .13105 L
.22307 .13429 L
.22308 .12221 L
.22309 .11804 L
.2231 .09948 L
.22311 .09204 L
.22312 .12812 L
.22313 .10236 L
.22314 .09943 L
.22315 .09696 L
.22316 .12284 L
.22318 .10626 L
.22319 .09056 L
.2232 .14099 L
.22322 .11455 L
.22323 .12856 L
.22324 .09384 L
.22325 .12861 L
.22325 .1199 L
.22327 .13795 L
.22328 .09801 L
.2233 .15312 L
.22331 .09028 L
.22332 .08225 L
.22333 .07535 L
.22334 .07648 L
.22335 .09249 L
.22336 .10503 L
.22337 .13307 L
.22339 .1237 L
.2234 .07959 L
.22342 .11521 L
.22343 .07483 L
.22344 .11693 L
.22346 .11585 L
.22347 .12871 L
.22349 .10973 L
.2235 .10736 L
.22351 .11599 L
Mistroke
.22352 .141 L
.22353 .12879 L
.22354 .13816 L
.22355 .10266 L
.22356 .12665 L
.22358 .08931 L
.22359 .09214 L
.22361 .1812 L
.22362 .10417 L
.22363 .08875 L
.22364 .15011 L
.22365 .10198 L
.22366 .12489 L
.22367 .14758 L
.22368 .09204 L
.22369 .1012 L
.22369 .11789 L
.2237 .09631 L
.22371 .11155 L
.22372 .13696 L
.22373 .12606 L
.22375 .12928 L
.22376 .10732 L
.22377 .14542 L
.22378 .13552 L
.2238 .12099 L
.22381 .09835 L
.22381 .08248 L
.22383 .09451 L
.22384 .10253 L
.22386 .13004 L
.22387 .12505 L
.22391 .11644 L
.22391 .06621 L
.22392 .09899 L
.22394 .10768 L
.22395 .08993 L
.22395 .10563 L
.22396 .10972 L
.22397 .14191 L
.22398 .12685 L
.22399 .10386 L
.22401 .11166 L
.22402 .10185 L
.22403 .16024 L
.22404 .1082 L
.22405 .07116 L
.22407 .1068 L
.22407 .09621 L
.22408 .13938 L
Mistroke
.2241 .09512 L
.2241 .10494 L
.22411 .12982 L
.22412 .07744 L
.22413 .121 L
.22415 .12584 L
.22415 .13774 L
.22416 .12148 L
.22418 .12402 L
.22419 .08403 L
.22421 .14708 L
.22422 .13284 L
.22423 .11195 L
.22425 .10699 L
.22426 .10823 L
.22427 .08938 L
.22428 .10565 L
.22429 .06595 L
.22431 .09478 L
.22432 .1234 L
.22432 .10222 L
.22433 .12643 L
.22434 .13588 L
.22436 .08778 L
.22437 .14798 L
.22437 .08914 L
.22439 .09631 L
.2244 .09201 L
.22442 .09096 L
.22443 .10675 L
.22443 .10608 L
.22445 .12896 L
.22446 .08543 L
.22448 .09891 L
.22449 .0948 L
.22451 .09204 L
.22452 .11467 L
.22453 .11361 L
.22455 .09245 L
.22456 .12405 L
.22457 .09477 L
.22458 .11896 L
.22459 .11281 L
.22461 .11753 L
.22462 .13418 L
.22463 .08745 L
.22465 .10816 L
.22466 .10236 L
.22467 .12215 L
.22469 .05671 L
Mistroke
.2247 .12178 L
.22471 .12805 L
.22473 .14524 L
.22474 .08344 L
.22476 .13002 L
.22477 .08423 L
.22478 .14251 L
.22479 .07267 L
.2248 .14853 L
.22482 .13121 L
.22483 .11377 L
.22484 .10155 L
.22486 .10661 L
.22487 .14353 L
.22488 .0816 L
.2249 .14056 L
.22491 .10326 L
.22493 .09974 L
.22494 .10419 L
.22495 .13373 L
.22497 .14184 L
.22498 .14053 L
.22498 .0761 L
.225 .12951 L
.22501 .12379 L
.22502 .11338 L
.22502 .11405 L
.22503 .06035 L
.22504 .12466 L
.22505 .11763 L
.22507 .12495 L
.22508 .07398 L
.22509 .09091 L
.2251 .13848 L
.22511 .1315 L
.22513 .10919 L
.22514 .14833 L
.22516 .11247 L
.22517 .10362 L
.22519 .10051 L
.22519 .11643 L
.2252 .05672 L
.22522 .05089 L
.22523 .10723 L
.22524 .12358 L
.22525 .07925 L
.22526 .11386 L
.22528 .09847 L
.22529 .0811 L
.22531 .10752 L
Mistroke
.22532 .07183 L
.22532 .10333 L
.22533 .08217 L
.22534 .08313 L
.22536 .10573 L
.22537 .08957 L
.22538 .11258 L
.22539 .1103 L
.2254 .11644 L
.22541 .10553 L
.22542 .11524 L
.22543 .09657 L
.22544 .12273 L
.22545 .11187 L
.22546 .11819 L
.22547 .09023 L
.22549 .08243 L
.2255 .1162 L
.22551 .08643 L
.22552 .09915 L
.22553 .12833 L
.22554 .15445 L
.22555 .10193 L
.22556 .1088 L
.22556 .10554 L
.22559 .11878 L
.22561 .12627 L
.22562 .08663 L
.22563 .09198 L
.22564 .12306 L
.22565 .1123 L
.22567 .11899 L
.22568 .14324 L
.2257 .12283 L
.22571 .11822 L
.22572 .13233 L
.22574 .1157 L
.22575 .1084 L
.22576 .1244 L
.22577 .06889 L
.22578 .14755 L
.2258 .08534 L
.22581 .11764 L
.22583 .11495 L
.22584 .11166 L
.22585 .0971 L
.22586 .10561 L
.22588 .06969 L
.22589 .12053 L
.22591 .13673 L
Mistroke
.22592 .11273 L
.22593 .11713 L
.22594 .10416 L
.22595 .12529 L
.22597 .13087 L
.22598 .13669 L
.22598 .1063 L
.226 .15095 L
.22601 .08335 L
.22602 .10206 L
.22603 .10667 L
.22603 .0895 L
.22605 .10187 L
.22606 .10945 L
.22607 .10245 L
.22608 .10327 L
.2261 .1222 L
.22611 .1354 L
.22613 .09024 L
.22614 .07547 L
.22615 .09068 L
.22616 .1479 L
.22617 .12284 L
.22619 .10208 L
.2262 .11416 L
.22621 .09805 L
.22622 .13723 L
.22623 .13531 L
.22625 .077 L
.22626 .11044 L
.22628 .11943 L
.22629 .06766 L
.2263 .12837 L
.2263 .10288 L
.22631 .11632 L
.22633 .1204 L
.22634 .07205 L
.22635 .1138 L
.22636 .12469 L
.22637 .13412 L
.22638 .12764 L
.22639 .14939 L
.2264 .08196 L
.22641 .13142 L
.22643 .08968 L
.22644 .0911 L
.22646 .07559 L
.22646 .14636 L
.22647 .10348 L
.22649 .09962 L
Mistroke
.2265 .10509 L
.2265 .14724 L
.22651 .12942 L
.22652 .08418 L
.22653 .10746 L
.22654 .13243 L
.22655 .10422 L
.22657 .08408 L
.22658 .11671 L
.22659 .1256 L
.22661 .06175 L
.22662 .10874 L
.22662 .10266 L
.22664 .10365 L
.22665 .06461 L
.22667 .09271 L
.22668 .07573 L
.22668 .10875 L
.2267 .09131 L
.22671 .15046 L
.22673 .09413 L
.22674 .08316 L
.22675 .09426 L
.22677 .08061 L
.22678 .10036 L
.22679 .09745 L
.2268 .08067 L
.22682 .1427 L
.22682 .11139 L
.22683 .14029 L
.22685 .13277 L
.22686 .10778 L
.22688 .0866 L
.22689 .13257 L
.2269 .12564 L
.22692 .13277 L
.22693 .08687 L
.22694 .08302 L
.22696 .10859 L
.22697 .09221 L
.22699 .12497 L
.227 .1172 L
.22703 .09675 L
.22704 .09971 L
.22705 .07745 L
.22707 .09902 L
.22708 .11847 L
.2271 .10732 L
.22711 .08501 L
.22713 .116 L
Mistroke
.22714 .14015 L
.22715 .13215 L
.22717 .11832 L
.22718 .09442 L
.2272 .11333 L
.2272 .11034 L
.22721 .07216 L
.22723 .09898 L
.22724 .09591 L
.22724 .0841 L
.22725 .11038 L
.22726 .129 L
.22728 .14692 L
.22728 .10761 L
.22729 .07599 L
.22731 .12812 L
.22732 .11685 L
.22734 .10843 L
.22735 .11384 L
.22736 .10643 L
.22738 .14442 L
.22739 .10649 L
.22741 .03851 L
.22742 .11115 L
.22743 .11276 L
.22744 .08638 L
.22746 .09551 L
.22747 .0997 L
.22748 .08362 L
.2275 .13076 L
.22751 .12118 L
.22752 .09915 L
.22754 .12926 L
.22755 .13621 L
.22756 .08381 L
.22757 .08397 L
.22758 .11623 L
.2276 .15279 L
.22761 .14524 L
.22763 .13561 L
.22764 .07887 L
.22765 .11077 L
.22766 .11456 L
.22768 .09526 L
.22769 .10374 L
.2277 .08607 L
.22772 .08162 L
.22773 .11391 L
.22774 .12516 L
.22776 .1347 L
Mistroke
.22777 .10696 L
.22779 .12519 L
.2278 .13131 L
.22782 .11788 L
.22783 .12464 L
.22784 .10136 L
.22785 .12429 L
.22786 .09887 L
.22788 .09717 L
.22789 .09026 L
.22791 .11987 L
.22792 .08793 L
.22793 .13319 L
.22794 .13242 L
.22795 .1506 L
.22796 .08219 L
.22797 .1185 L
.22798 .13536 L
.22799 .10977 L
.228 .12115 L
.22802 .0967 L
.22803 .10344 L
.22804 .1059 L
.22805 .10354 L
.22807 .06129 L
.22808 .13286 L
.22809 .08608 L
.22811 .11723 L
.22812 .108 L
.22813 .1178 L
.22814 .11317 L
.22815 .13128 L
.22817 .08338 L
.22818 .13513 L
.2282 .13001 L
.22821 .14047 L
.22822 .09848 L
.22824 .10987 L
.22825 .08964 L
.22826 .0863 L
.22828 .1437 L
.22829 .10177 L
.2283 .07782 L
.22831 .13328 L
.22833 .09635 L
.22834 .11816 L
.22835 .10191 L
.22836 .10199 L
.22837 .09093 L
.22838 .12697 L
Mistroke
.22839 .12151 L
.2284 .12393 L
.22841 .07427 L
.22842 .12144 L
.22844 .15835 L
.22845 .0776 L
.22846 .11563 L
.22848 .13214 L
.22849 .12075 L
.2285 .098 L
.22851 .07717 L
.22853 .09304 L
.22854 .13851 L
.22855 .12605 L
.22856 .1139 L
.22857 .0816 L
.22857 .08528 L
.22858 .0896 L
.22859 .12753 L
.22861 .09119 L
.22862 .11069 L
.22863 .1152 L
.22864 .08179 L
.22865 .1359 L
.22866 .12014 L
.22867 .12057 L
.22868 .12747 L
.22868 .09522 L
.22869 .11785 L
.2287 .11166 L
.22871 .11393 L
.22872 .10149 L
.22873 .13849 L
.22874 .15157 L
.22874 .13994 L
.22875 .15758 L
.22877 .07707 L
.22878 .09394 L
.22878 .15291 L
.2288 .08496 L
.22881 .15099 L
.22882 .13222 L
.22883 .1499 L
.22885 .12004 L
.22886 .10936 L
.22887 .06392 L
.22889 .07967 L
.2289 .11909 L
.22892 .10222 L
.22892 .13606 L
Mistroke
.22893 .08275 L
.22894 .10702 L
.22895 .12207 L
.22896 .09194 L
.22897 .14678 L
.22898 .14037 L
.22899 .10094 L
.229 .10716 L
.22901 .11156 L
.22903 .10816 L
.22904 .10658 L
.22906 .09686 L
.22907 .0919 L
.22908 .0903 L
.22909 .14072 L
.2291 .12206 L
.22912 .1502 L
.22913 .08255 L
.22915 .10932 L
.22916 .07248 L
.22917 .10992 L
.22919 .12212 L
.2292 .07976 L
.22922 .08321 L
.22923 .16443 L
.22925 .13272 L
.22926 .10048 L
.22927 .08637 L
.22929 .12068 L
.2293 .15186 L
.22931 .10493 L
.22931 .11889 L
.22932 .09012 L
.22933 .08982 L
.22934 .0916 L
.22935 .0886 L
.22936 .08303 L
.22937 .07549 L
.22938 .05158 L
.22939 .14735 L
.2294 .12125 L
.22941 .11875 L
.22942 .14052 L
.22944 .14375 L
.22944 .1086 L
.22945 .13322 L
.22947 .13183 L
.22948 .12226 L
.2295 .09651 L
.22951 .12591 L
Mistroke
.22953 .1092 L
.22953 .08122 L
.22954 .125 L
.22956 .13413 L
.22957 .09422 L
.22958 .08324 L
.22959 .1331 L
.2296 .06996 L
.22961 .11316 L
.22962 .07522 L
.22963 .11803 L
.22964 .08792 L
.22965 .08374 L
.22967 .10238 L
.22968 .06421 L
.22969 .13927 L
.2297 .12047 L
.22971 .09889 L
.22972 .13694 L
.22973 .11679 L
.22974 .10625 L
.22976 .08898 L
.22977 .14741 L
.22979 .12715 L
.2298 .08108 L
.22981 .11176 L
.22983 .09862 L
.22984 .10196 L
.22984 .1344 L
.22986 .14214 L
.22987 .10415 L
.22989 .13842 L
.2299 .11221 L
.22991 .11267 L
.22992 .1291 L
.22994 .09847 L
.22995 .12957 L
.22997 .08018 L
.22998 .11679 L
.23 .11494 L
.23001 .10366 L
.23002 .10228 L
.23004 .12142 L
.23005 .12374 L
.23006 .12551 L
.23007 .1109 L
.23008 .14769 L
.2301 .12118 L
.23011 .12246 L
.23013 .14007 L
Mistroke
.23014 .13851 L
.23015 .11449 L
.23017 .08931 L
.23018 .11745 L
.23019 .10213 L
.23021 .16946 L
.23022 .11835 L
.23022 .12712 L
.23024 .12211 L
.23025 .10032 L
.23026 .08847 L
.23027 .16126 L
.23027 .11097 L
.23029 .11576 L
.2303 .14531 L
.23031 .14819 L
.23032 .10356 L
.23034 .13482 L
.23035 .08504 L
.23037 .13054 L
.23038 .12493 L
.23039 .11604 L
.23041 .14758 L
.23042 .11725 L
.23043 .1461 L
.23044 .14058 L
.23046 .14695 L
.23047 .12822 L
.23048 .14132 L
.23049 .10559 L
.2305 .11711 L
.2305 .10298 L
.23051 .11111 L
.23052 .12611 L
.23053 .10471 L
.23055 .11529 L
.23056 .09894 L
.23058 .11489 L
.23059 .13881 L
.2306 .13816 L
.23061 .13201 L
.23062 .13124 L
.23062 .12756 L
.23063 .1272 L
.23064 .10821 L
.23065 .11809 L
.23066 .11636 L
.23067 .09427 L
.23067 .10432 L
.23068 .10235 L
Mistroke
.2307 .13935 L
.23071 .10391 L
.23073 .11303 L
.23074 .07693 L
.23076 .1323 L
.23077 .06593 L
.23079 .1225 L
.2308 .10227 L
.23081 .06151 L
.23083 .12661 L
.23084 .1158 L
.23084 .13297 L
.23085 .06421 L
.23086 .10635 L
.23088 .13499 L
.23089 .07821 L
.23089 .09025 L
.23091 .14666 L
.23092 .11797 L
.23093 .08406 L
.23094 .1169 L
.23095 .14937 L
.23097 .08543 L
.23098 .09488 L
.231 .14419 L
.23101 .11007 L
.23103 .09247 L
.23104 .11393 L
.23105 .11726 L
.23107 .10139 L
.23108 .10218 L
.23108 .12702 L
.23109 .10233 L
.2311 .09115 L
.23112 .11198 L
.23112 .10354 L
.23113 .10172 L
.23115 .09037 L
.23116 .11715 L
.23118 .09274 L
.23119 .09611 L
.2312 .11283 L
.23121 .09684 L
.23122 .1191 L
.23124 .09088 L
.23125 .13017 L
.23125 .09588 L
.23127 .08258 L
.23128 .13616 L
.2313 .12539 L
Mistroke
.23131 .10582 L
.23132 .1129 L
.23133 .08901 L
.23134 .12162 L
.23135 .09688 L
.23136 .10213 L
.23138 .12926 L
.23138 .13627 L
.23139 .09317 L
.23141 .13742 L
.23142 .13765 L
.23143 .07383 L
.23144 .0744 L
.23144 .0943 L
.23145 .09573 L
.23146 .12225 L
.23147 .11343 L
.23149 .11997 L
.2315 .11467 L
.23151 .16153 L
.23152 .1173 L
.23154 .10249 L
.23154 .07918 L
.23155 .13056 L
.23157 .16272 L
.23158 .08221 L
.2316 .09877 L
.23161 .1211 L
.23163 .07196 L
.23164 .11713 L
.23165 .12467 L
.23167 .08616 L
.23168 .11101 L
.2317 .12875 L
.23171 .11657 L
.23172 .10439 L
.23173 .11715 L
.23174 .13376 L
.23176 .13102 L
.23177 .10833 L
.23179 .13773 L
.2318 .09257 L
.23181 .12267 L
.23182 .0815 L
.23183 .14088 L
.23184 .14185 L
.23185 .1461 L
.23186 .11494 L
.23187 .11055 L
.23188 .0727 L
Mistroke
.23189 .07382 L
.23189 .13812 L
.2319 .06602 L
.23192 .15393 L
.23193 .1449 L
.23195 .1066 L
.23196 .09219 L
.23198 .1458 L
.23199 .13936 L
.232 .09207 L
.23202 .12137 L
.23203 .10545 L
.23205 .06434 L
.23205 .10322 L
.23206 .12577 L
.23207 .10791 L
.23208 .12166 L
.23209 .12476 L
.23211 .11274 L
.23213 .14198 L
.23214 .12726 L
.23215 .09271 L
.23217 .08657 L
.23218 .12744 L
.23219 .10857 L
.23221 .15385 L
.23222 .12984 L
.23224 .12754 L
.23225 .11325 L
.23227 .09656 L
.23228 .09773 L
.2323 .1132 L
.23231 .14698 L
.23232 .12898 L
.23234 .12546 L
.23235 .1375 L
.23236 .13136 L
.23237 .10428 L
.23239 .07177 L
.2324 .11259 L
.23241 .09759 L
.23242 .09575 L
.23243 .11814 L
.23245 .14579 L
.23246 .11061 L
.23247 .09987 L
.23249 .11648 L
.2325 .1017 L
.23252 .15978 L
.23253 .11509 L
Mistroke
.23253 .10211 L
.23255 .08557 L
.23256 .0889 L
.23257 .14542 L
.23258 .12269 L
.2326 .12278 L
.23261 .11399 L
.23262 .13058 L
.23264 .13222 L
.23265 .11149 L
.23266 .09585 L
.23268 .11066 L
.23269 .13803 L
.2327 .14538 L
.23272 .07173 L
.23273 .10146 L
.23274 .12188 L
.23276 .1184 L
.23277 .14033 L
.23279 .08793 L
.2328 .12536 L
.23282 .12157 L
.23283 .11288 L
.23284 .10276 L
.23286 .12923 L
.23287 .08608 L
.23288 .10271 L
.23289 .11736 L
.23291 .13765 L
.23292 .10855 L
.23293 .12667 L
.23294 .13128 L
.23295 .072 L
.23297 .14083 L
.23298 .12698 L
.233 .11666 L
.23301 .10213 L
.23302 .14619 L
.23304 .12099 L
.23305 .12137 L
.23307 .14672 L
.23308 .14437 L
.23311 .11304 L
.23313 .09786 L
.23314 .08801 L
.23315 .1299 L
.23316 .14071 L
.23317 .14866 L
.23318 .09135 L
.23319 .1563 L
Mistroke
.23319 .11112 L
.23321 .12126 L
.23322 .10474 L
.23323 .11866 L
.23324 .12403 L
.23326 .08216 L
.23327 .11745 L
.23327 .12328 L
.23329 .09099 L
.2333 .11484 L
.23332 .07407 L
.23333 .11125 L
.23334 .10357 L
.23336 .09869 L
.23337 .06407 L
.23338 .10852 L
.2334 .10198 L
.23341 .10791 L
.23343 .12225 L
.23344 .0786 L
.23345 .11971 L
.23347 .09159 L
.23348 .11289 L
.2335 .14866 L
.23351 .0876 L
.23352 .15191 L
.23353 .11933 L
.23354 .08985 L
.23356 .05986 L
.23357 .14118 L
.23358 .11579 L
.23359 .12257 L
.2336 .13476 L
.23361 .10983 L
.23362 .14225 L
.23363 .0651 L
.23365 .09111 L
.23366 .10116 L
.23368 .10912 L
.23369 .10174 L
.23369 .1033 L
.23371 .06939 L
.23372 .08274 L
.23373 .12909 L
.23373 .09936 L
.23374 .10893 L
.23376 .13441 L
.23377 .1043 L
.23378 .12588 L
.23379 .14574 L
Mistroke
.23381 .14435 L
.23382 .09106 L
.23383 .13713 L
.23384 .11785 L
.23385 .08259 L
.23387 .07978 L
.23387 .11504 L
.23388 .10877 L
.2339 .13692 L
.23391 .12067 L
.23391 .08321 L
.23392 .14771 L
.23393 .09979 L
.23395 .11866 L
.23396 .13929 L
.23396 .11922 L
.23398 .12281 L
.23399 .13973 L
.23401 .12756 L
.23402 .08773 L
.23403 .13082 L
.23405 .08581 L
.23406 .08585 L
.23408 .13062 L
.23409 .07707 L
.2341 .10599 L
.23411 .12638 L
.23412 .12284 L
.23414 .11398 L
.23415 .11465 L
.23417 .16215 L
.23418 .11283 L
.23419 .12201 L
.2342 .10095 L
.23422 .1161 L
.23423 .11592 L
.23425 .10215 L
.23426 .12097 L
.23427 .1338 L
.23429 .12444 L
.2343 .09367 L
.23432 .1016 L
.23433 .12624 L
.23434 .10625 L
.23436 .07729 L
.23437 .11838 L
.23439 .12976 L
.23439 .09498 L
.2344 .14467 L
.23441 .1259 L
Mistroke
.23442 .12263 L
.23443 .10994 L
.23444 .11632 L
.23445 .08923 L
.23447 .11986 L
.23448 .12565 L
.2345 .16349 L
.23451 .15251 L
.23457 .10657 L
.23458 .08998 L
.23459 .11225 L
.2346 .16454 L
.23462 .11746 L
.23463 .0536 L
.23465 .07905 L
.23466 .09654 L
.23466 .12452 L
.23467 .06452 L
.23468 .10199 L
.23469 .14769 L
.2347 .11591 L
.23472 .08934 L
.23473 .10827 L
.23474 .11593 L
.23475 .11899 L
.23476 .0893 L
.23476 .14489 L
.23478 .11224 L
.23479 .13388 L
.23481 .09265 L
.23482 .14873 L
.23483 .10865 L
.23484 .12113 L
.23485 .08091 L
.23486 .12291 L
.23488 .08755 L
.23489 .12124 L
.23491 .10262 L
.23492 .14402 L
.23493 .10681 L
.23495 .10799 L
.23496 .11372 L
.23497 .17559 L
.23499 .11876 L
.235 .11516 L
.23502 .09543 L
.23503 .10337 L
.23505 .13334 L
.23506 .1224 L
.23507 .14754 L
Mistroke
.23508 .07678 L
.23509 .09312 L
.2351 .15333 L
.23511 .11752 L
.23512 .15625 L
.23512 .10985 L
.23513 .15088 L
.23514 .10555 L
.23515 .09604 L
.23516 .09303 L
.23518 .09973 L
.23518 .11901 L
.23519 .10838 L
.23521 .10386 L
.23522 .09776 L
.23524 .13242 L
.23525 .11694 L
.23527 .11386 L
.23528 .09887 L
.23529 .10991 L
.2353 .09972 L
.23531 .11742 L
.23533 .13407 L
.23534 .1332 L
.23536 .12419 L
.23537 .12494 L
.23537 .13945 L
.23539 .09353 L
.2354 .09571 L
.23541 .12167 L
.23542 .09653 L
.23543 .1348 L
.23544 .08124 L
.23545 .09233 L
.23546 .12863 L
.23547 .08845 L
.23547 .10806 L
.23548 .10353 L
.23549 .13692 L
.2355 .14578 L
.23552 .13684 L
.23553 .13829 L
.23554 .09037 L
.23555 .1121 L
.23557 .12663 L
.23558 .13022 L
.23559 .10847 L
.23561 .11409 L
.23562 .11036 L
.23563 .07592 L
Mistroke
.23564 .10881 L
.23565 .12601 L
.23565 .12048 L
.23566 .13113 L
.23567 .1262 L
.23569 .11344 L
.2357 .14125 L
.23572 .14763 L
.23572 .08535 L
.23573 .10891 L
.23575 .09195 L
.23576 .13209 L
.23577 .11638 L
.23579 .08427 L
.2358 .10835 L
.23581 .11607 L
.23582 .10884 L
.23584 .10744 L
.23585 .12108 L
.23587 .16502 L
.23588 .13139 L
.23589 .14858 L
.2359 .08999 L
.23592 .06986 L
.23593 .13516 L
.23595 .09906 L
.23596 .09378 L
.23597 .10099 L
.23598 .12751 L
.23599 .10248 L
.23601 .15369 L
.23602 .13146 L
.23604 .12218 L
.23605 .08826 L
.23606 .11995 L
.23607 .0967 L
.23607 .09913 L
.23608 .12098 L
.23609 .12568 L
.23611 .11351 L
.23612 .14773 L
.23614 .138 L
.23615 .12265 L
.23616 .10564 L
.23617 .13102 L
.23618 .1278 L
.2362 .11374 L
.23621 .09514 L
.23623 .10526 L
.23623 .11939 L
Mistroke
.23624 .10801 L
.23626 .12006 L
.23627 .0871 L
.23628 .09802 L
.2363 .14413 L
.23631 .15542 L
.23633 .10412 L
.23634 .08999 L
.23635 .14636 L
.23636 .10812 L
.23637 .09792 L
.23638 .12398 L
.23639 .09328 L
.2364 .13249 L
.23642 .07677 L
.23643 .10529 L
.23645 .13069 L
.23646 .10162 L
.23647 .1055 L
.23649 .12137 L
.2365 .07283 L
.23651 .12637 L
.23653 .08204 L
.23654 .09718 L
.23655 .08656 L
.23657 .10333 L
.23658 .10148 L
.23659 .14135 L
.23661 .12856 L
.23662 .11433 L
.23664 .10941 L
.23665 .07239 L
.23667 .12521 L
.23668 .10621 L
.2367 .12245 L
.2367 .15339 L
.23671 .1295 L
.23672 .1275 L
.23673 .08023 L
.23674 .10033 L
.23675 .13849 L
.23676 .09269 L
.23677 .08245 L
.23679 .15378 L
.2368 .09339 L
.23682 .11827 L
.23683 .12251 L
.23685 .13811 L
.23686 .10983 L
.23687 .10655 L
Mistroke
.23689 .09798 L
.2369 .10372 L
.23692 .12072 L
.23693 .10048 L
.23694 .11835 L
.23695 .11902 L
.23696 .10717 L
.23698 .11129 L
.23699 .09313 L
.23701 .12581 L
.23702 .09596 L
.23703 .11177 L
.23704 .12073 L
.23705 .10937 L
.23706 .06581 L
.23707 .11918 L
.23708 .1208 L
.23709 .10969 L
.2371 .11649 L
.23711 .1073 L
.23711 .09504 L
.23712 .09678 L
.23714 .08869 L
.23715 .11299 L
.23717 .09186 L
.23718 .14417 L
.2372 .13184 L
.23721 .0837 L
.23722 .11748 L
.23724 .12028 L
.23725 .1239 L
.23727 .08128 L
.23728 .09559 L
.2373 .0777 L
.23731 .15518 L
.23732 .10029 L
.23734 .10527 L
.23735 .10762 L
.23736 .11849 L
.23737 .09243 L
.23739 .13656 L
.2374 .08862 L
.23741 .09667 L
.23743 .13107 L
.23744 .1429 L
.23745 .13843 L
.23747 .09466 L
.23748 .10488 L
.23749 .12844 L
.23751 .1517 L
Mistroke
.23752 .09321 L
.23753 .12929 L
.23755 .09304 L
.23756 .15676 L
.23757 .12263 L
.23758 .07206 L
.23759 .15273 L
.23761 .08543 L
.23762 .12195 L
.23764 .1274 L
.23765 .10806 L
.23767 .13052 L
.23768 .11332 L
.23769 .08944 L
.23771 .08608 L
.23772 .10341 L
.23773 .12622 L
.23775 .12414 L
.23776 .11637 L
.23778 .1295 L
.23779 .07501 L
.2378 .12172 L
.23781 .08392 L
.23783 .09993 L
.23784 .11406 L
.23785 .15867 L
.23787 .11151 L
.23788 .09386 L
.2379 .12554 L
.23791 .10149 L
.23792 .12054 L
.23793 .1332 L
.23795 .10538 L
.23796 .10431 L
.23797 .11844 L
.23799 .13217 L
.238 .1438 L
.23801 .13014 L
.23802 .1008 L
.23803 .10407 L
.23805 .11946 L
.23806 .1606 L
.23808 .122 L
.23809 .12824 L
.23811 .10711 L
.23812 .11598 L
.23813 .15779 L
.23815 .13343 L
.23816 .1263 L
.23817 .11607 L
Mistroke
.23819 .13393 L
.2382 .14113 L
.23822 .12335 L
.23823 .12117 L
.23825 .0711 L
.23826 .09595 L
.23827 .12811 L
.23828 .12494 L
.2383 .0968 L
.23831 .10694 L
.23832 .15718 L
.23834 .11263 L
.23835 .12201 L
.23836 .13436 L
.23838 .14081 L
.23839 .09484 L
.2384 .13452 L
.23842 .16573 L
.23843 .11537 L
.23844 .15689 L
.23846 .07795 L
.23847 .1203 L
.23848 .10848 L
.23849 .13965 L
.2385 .16312 L
.23852 .11493 L
.23853 .11602 L
.23854 .10887 L
.23855 .14695 L
.23856 .10465 L
.23858 .10542 L
.23859 .05015 L
.2386 .12351 L
.23862 .14542 L
.23863 .13049 L
.23864 .10496 L
.23865 .12255 L
.23866 .14728 L
.23868 .1064 L
.23869 .10951 L
.23869 .08323 L
.23871 .06721 L
.23872 .08235 L
.23874 .11436 L
.23875 .11923 L
.23876 .11907 L
.23878 .12148 L
.23879 .11091 L
.23881 .09776 L
.23882 .09193 L
Mistroke
.23884 .09196 L
.23885 .10236 L
.23887 .09348 L
.23888 .13067 L
.23889 .12132 L
.2389 .11451 L
.23892 .11601 L
.23893 .10705 L
.23895 .12318 L
.23896 .12442 L
.23897 .08921 L
.23899 .16555 L
.239 .14857 L
.23901 .10747 L
.23902 .11609 L
.23903 .10072 L
.23904 .12484 L
.23905 .13293 L
.23906 .12804 L
.23908 .09159 L
.23909 .08837 L
.23911 .12091 L
.23912 .08017 L
.23914 .13235 L
.23915 .11973 L
.23916 .10064 L
.23918 .13574 L
.23919 .10708 L
.23921 .08347 L
.23922 .12362 L
.23924 .09437 L
.23925 .13837 L
.23926 .12592 L
.23928 .10229 L
.23929 .12008 L
.2393 .12879 L
.23931 .11806 L
.23932 .14943 L
.23933 .14306 L
.23934 .1161 L
.23935 .11458 L
.23936 .18124 L
.23937 .12452 L
.23938 .13088 L
.23939 .10846 L
.2394 .12015 L
.2394 .11797 L
.23941 .06992 L
.23942 .10115 L
.23943 .08777 L
Mistroke
.23944 .08365 L
.23946 .09793 L
.23947 .12459 L
.23949 .12841 L
.2395 .10546 L
.23952 .0923 L
.23953 .08374 L
.23954 .12081 L
.23956 .09545 L
.23957 .10409 L
.23959 .13363 L
.2396 .12855 L
.23961 .12645 L
.23963 .08825 L
.23965 .17391 L
.23965 .0912 L
.23966 .10466 L
.23968 .08777 L
.23969 .09427 L
.23971 .06242 L
.23972 .14689 L
.23973 .09209 L
.23974 .15963 L
.23976 .12771 L
.23977 .09721 L
.23978 .11411 L
.2398 .1285 L
.23981 .11206 L
.23982 .11174 L
.23983 .11954 L
.23984 .09661 L
.23986 .10284 L
.23987 .11381 L
.23988 .07863 L
.2399 .08032 L
.23991 .13645 L
.23993 .12097 L
.23994 .10913 L
.23996 .11369 L
.23997 .13796 L
.23998 .07759 L
.24 .12829 L
.24001 .09846 L
.24001 .10059 L
.24003 .12807 L
.24004 .1223 L
.24005 .11359 L
.24006 .10725 L
.24007 .12424 L
.24008 .09197 L
Mistroke
.24009 .12105 L
.24009 .10692 L
.24011 .08772 L
.24012 .08302 L
.24014 .12739 L
.24015 .12282 L
.24017 .09528 L
.24018 .12459 L
.24019 .11647 L
.24021 .10466 L
.24022 .12193 L
.24023 .1163 L
.24024 .09399 L
.24026 .12755 L
.24027 .134 L
.24028 .13414 L
.24029 .09841 L
.2403 .12207 L
.24032 .1152 L
.24033 .11737 L
.24035 .15717 L
.24036 .1197 L
.24037 .12847 L
.24039 .12206 L
.2404 .13263 L
.24041 .13822 L
.24042 .11802 L
.24043 .0996 L
.24044 .10646 L
.24045 .14662 L
.24047 .11057 L
.24048 .11821 L
.2405 .10531 L
.2405 .1026 L
.24051 .11775 L
.24052 .10085 L
.24053 .10494 L
.24054 .1379 L
.24056 .11084 L
.24057 .13566 L
.24058 .09603 L
.24059 .07894 L
.2406 .05877 L
.24061 .10535 L
.24062 .12009 L
.24063 .14216 L
.24064 .12379 L
.24065 .07693 L
.24066 .11596 L
.24068 .0721 L
Mistroke
.24069 .14646 L
.2407 .15268 L
.24071 .09919 L
.24072 .11754 L
.24073 .12823 L
.24074 .16005 L
.24075 .0757 L
.24075 .10656 L
.24077 .10877 L
.24078 .13857 L
.2408 .08715 L
.24081 .10332 L
.24083 .11805 L
.24083 .10569 L
.24084 .10321 L
.24086 .09275 L
.24087 .10651 L
.24089 .1601 L
.24089 .07859 L
.2409 .1007 L
.24092 .10706 L
.24093 .12028 L
.24094 .14631 L
.24096 .13313 L
.24099 .1061 L
.241 .08551 L
.24102 .11769 L
.24103 .10934 L
.24104 .12813 L
.24105 .08558 L
.24106 .13729 L
.24107 .09997 L
.24108 .11101 L
.24109 .12356 L
.24111 .12612 L
.24112 .11042 L
.24113 .11725 L
.24115 .14005 L
.24116 .1013 L
.24117 .09619 L
.24118 .13529 L
.2412 .08174 L
.24121 .06496 L
.24122 .0987 L
.24123 .10822 L
.24125 .14311 L
.24126 .09889 L
.24127 .1267 L
.24129 .10186 L
.2413 .10558 L
Mistroke
.24132 .13478 L
.24133 .11837 L
.24134 .07325 L
.24134 .121 L
.24136 .12846 L
.24138 .05329 L
.24138 .10833 L
.24139 .10786 L
.24141 .07888 L
.24142 .10807 L
.24143 .11318 L
.24144 .14401 L
.24145 .14149 L
.24147 .10676 L
.24148 .13192 L
.2415 .08267 L
.24151 .07449 L
.24152 .12535 L
.24154 .12883 L
.24155 .13369 L
.24157 .08741 L
.24158 .12999 L
.2416 .12814 L
.2416 .13669 L
.24161 .1153 L
.24163 .11975 L
.24164 .13163 L
.24166 .08642 L
.24167 .10247 L
.24169 .09452 L
.24169 .12518 L
.2417 .14132 L
.24172 .09359 L
.24173 .12374 L
.24173 .13302 L
.24174 .11388 L
.24175 .13608 L
.24176 .14151 L
.24177 .10929 L
.24178 .09439 L
.24179 .09732 L
.2418 .10686 L
.24182 .13366 L
.24183 .10308 L
.24184 .11667 L
.24185 .11686 L
.24186 .12483 L
.24188 .09307 L
.24189 .11393 L
.2419 .12283 L
Mistroke
.24192 .12238 L
.24193 .11936 L
.24195 .13974 L
.24195 .13517 L
.24196 .11441 L
.24198 .09432 L
.24199 .11381 L
.242 .08319 L
.24202 .09998 L
.24203 .10928 L
.24204 .08044 L
.24205 .09215 L
.24207 .14166 L
.24208 .12631 L
.2421 .10917 L
.24211 .11332 L
.24212 .12894 L
.24214 .09269 L
.24214 .10973 L
.24215 .05925 L
.24217 .13556 L
.24218 .11629 L
.2422 .08664 L
.24221 .10186 L
.24222 .09867 L
.24224 .14529 L
.24225 .09201 L
.24226 .14423 L
.24227 .08996 L
.24229 .09243 L
.2423 .13356 L
.2423 .08297 L
.24232 .07492 L
.24233 .08631 L
.24237 .11994 L
.24238 .07299 L
.24239 .12821 L
.2424 .14501 L
.24241 .13625 L
.24243 .07835 L
.24244 .13729 L
.24246 .15362 L
.24247 .12194 L
.24248 .09831 L
.24249 .12911 L
.2425 .15018 L
.24252 .11363 L
.24253 .10738 L
.24255 .06715 L
.24256 .1208 L
Mistroke
.24257 .09513 L
.24259 .06626 L
.2426 .08887 L
.24261 .0956 L
.24263 .14387 L
.24264 .1009 L
.24265 .13037 L
.24267 .10711 L
.24268 .12706 L
.2427 .09262 L
.24271 .10434 L
.24272 .05017 L
.24273 .08833 L
.24274 .1361 L
.24276 .10768 L
.24276 .13911 L
.24277 .10357 L
.24278 .15756 L
.24279 .12154 L
.2428 .11434 L
.24281 .11433 L
.24282 .15187 L
.24283 .12717 L
.24285 .13606 L
.24286 .13517 L
.24287 .1101 L
.24288 .07877 L
.24289 .10115 L
.24291 .07866 L
.24292 .11915 L
.24294 .06709 L
.24295 .11463 L
.24296 .1409 L
.24298 .09508 L
.24299 .11331 L
.24299 .10451 L
.24301 .11043 L
.24302 .13841 L
.24303 .10958 L
.24304 .11512 L
.24305 .08817 L
.24305 .1498 L
.24306 .08107 L
.24307 .12909 L
.24308 .14977 L
.24309 .10664 L
.24311 .1229 L
.24312 .08864 L
.24313 .11954 L
.24314 .08591 L
Mistroke
.24316 .13849 L
.24317 .14542 L
.24319 .09422 L
.2432 .10793 L
.24321 .07706 L
.24323 .10183 L
.24324 .12765 L
.24325 .12137 L
.24326 .09312 L
.24328 .10378 L
.24328 .12301 L
.24329 .09771 L
.24331 .12 L
.24332 .1016 L
.24334 .10069 L
.24335 .1017 L
.24336 .13495 L
.24337 .14548 L
.24338 .08853 L
.24338 .11609 L
.2434 .11149 L
.24342 .10013 L
.24342 .09319 L
.24343 .12588 L
.24345 .09131 L
.24346 .14984 L
.24347 .13407 L
.24348 .11178 L
.24348 .0925 L
.2435 .12828 L
.24351 .12038 L
.24353 .11835 L
.24354 .15455 L
.24354 .11503 L
.24356 .12532 L
.24357 .13207 L
.24359 .10277 L
.2436 .11057 L
.24361 .12394 L
.24363 .14444 L
.24365 .16682 L
.24366 .14768 L
.24367 .13405 L
.24368 .11114 L
.24369 .12187 L
.24369 .10768 L
.24371 .10594 L
.24372 .10085 L
.24373 .1279 L
.24374 .10945 L
Mistroke
.24376 .12025 L
.24377 .17137 L
.24378 .10663 L
.2438 .07394 L
.24381 .12818 L
.24381 .07397 L
.24383 .09509 L
.24384 .09517 L
.24386 .09013 L
.24387 .089 L
.24388 .13152 L
.2439 .11977 L
.24391 .09759 L
.24393 .10997 L
.24394 .09365 L
.24395 .13664 L
.24397 .08106 L
.24398 .1136 L
.244 .09734 L
.24401 .10847 L
.24401 .12667 L
.24403 .0946 L
.24404 .113 L
.24406 .07384 L
.24407 .08892 L
.24409 .11269 L
.2441 .10129 L
.2441 .12322 L
.24412 .15611 L
.24413 .12299 L
.24414 .12495 L
.24415 .11526 L
.24417 .11347 L
.24418 .14686 L
.24418 .11877 L
.24419 .07021 L
.2442 .14557 L
.24422 .11898 L
.24423 .1295 L
.24423 .08972 L
.24424 .13799 L
.24425 .10192 L
.24426 .12415 L
.24427 .10093 L
.24428 .0966 L
.24429 .08526 L
.24431 .13129 L
.24432 .09306 L
.24433 .1025 L
.24433 .11272 L
Mistroke
.24434 .14167 L
.24435 .1133 L
.24436 .15106 L
.24437 .14583 L
.24438 .16616 L
.24439 .10716 L
.24439 .12003 L
.2444 .10693 L
.24441 .09371 L
.24442 .12815 L
.24443 .07233 L
.24444 .14943 L
.24445 .11037 L
.24446 .12876 L
.24447 .10274 L
.24448 .12901 L
.24449 .1112 L
.2445 .1503 L
.24452 .13021 L
.24454 .10951 L
.24455 .11198 L
.24456 .07446 L
.24458 .11159 L
.24459 .11323 L
.2446 .15228 L
.24461 .13406 L
.24462 .14442 L
.24462 .11595 L
.24463 .13515 L
.24464 .11108 L
.24466 .09202 L
.24467 .14832 L
.24469 .08296 L
.24469 .10968 L
.2447 .13466 L
.24472 .13516 L
.24473 .09921 L
.24475 .09562 L
.24476 .11304 L
.24476 .08459 L
.24478 .08901 L
.24479 .12272 L
.24481 .14751 L
.24482 .12189 L
.24484 .1178 L
.24485 .09261 L
.24486 .14804 L
.24488 .09232 L
.24489 .09359 L
.24491 .12771 L
Mistroke
.24492 .0904 L
.24493 .12015 L
.24495 .1304 L
.24496 .14521 L
.24497 .13025 L
.24498 .127 L
.24499 .13942 L
.245 .09579 L
.24501 .08549 L
.24501 .10603 L
.24503 .13022 L
.24504 .08988 L
.24505 .133 L
.24506 .14815 L
.24506 .11705 L
.24508 .08758 L
.24509 .119 L
.24509 .10875 L
.24511 .16305 L
.24512 .12234 L
.24513 .09697 L
.24514 .10669 L
.24516 .09285 L
.24517 .11598 L
.24518 .1265 L
.2452 .0964 L
.24521 .13038 L
.24522 .11156 L
.24523 .13337 L
.24525 .08886 L
.24525 .12183 L
.24526 .09102 L
.24528 .11499 L
.24529 .10022 L
.24529 .13062 L
.2453 .1206 L
.24531 .13092 L
.24533 .11062 L
.24534 .13789 L
.24536 .13571 L
.24537 .08237 L
.24538 .08158 L
.24539 .12383 L
.2454 .12744 L
.24541 .09929 L
.24542 .11015 L
.24543 .10944 L
.24545 .1128 L
.24546 .12638 L
.24547 .10201 L
Mistroke
.24549 .09343 L
.2455 .10637 L
.24551 .10528 L
.24552 .12646 L
.24553 .11687 L
.24555 .13759 L
.24556 .12626 L
.24557 .0944 L
.24559 .08581 L
.2456 .08703 L
.24561 .11059 L
.24563 .10209 L
.24564 .12683 L
.24565 .11805 L
.24567 .1129 L
.24568 .10461 L
.2457 .14295 L
.24571 .10262 L
.24573 .12521 L
.24573 .13052 L
.24574 .10743 L
.24576 .13791 L
.24577 .09265 L
.24579 .1354 L
.2458 .08672 L
.24581 .11027 L
.24582 .0905 L
.24584 .1198 L
.24585 .13559 L
.24587 .09867 L
.24588 .12075 L
.2459 .18113 L
.24591 .10108 L
.24591 .15146 L
.24593 .15318 L
.24594 .12584 L
.24595 .10288 L
.24596 .08749 L
.24598 .17267 L
.24598 .07885 L
.24599 .12882 L
.246 .12418 L
.24601 .11148 L
.24602 .09801 L
.24604 .09927 L
.24605 .11028 L
.24607 .08098 L
.24608 .12054 L
.24609 .12872 L
.2461 .0945 L
Mistroke
.24611 .16841 L
.24612 .11731 L
.24613 .11918 L
.24614 .12947 L
.24616 .13227 L
.24617 .17381 L
.24619 .16838 L
.2462 .12207 L
.2462 .09133 L
.24622 .11277 L
.24624 .06271 L
.24625 .11109 L
.24626 .08385 L
.24628 .12478 L
.24629 .13283 L
.2463 .11743 L
.24632 .09015 L
.24633 .12534 L
.24635 .0956 L
.24636 .09419 L
.24637 .1136 L
.24638 .10819 L
.24639 .08764 L
.24641 .1672 L
.24642 .05415 L
.24643 .09343 L
.24644 .12631 L
.24645 .09474 L
.24646 .13239 L
.24647 .07625 L
.24647 .11002 L
.24649 .12816 L
.2465 .13146 L
.24652 .11724 L
.24653 .09045 L
.24655 .10792 L
.24656 .12766 L
.24657 .11402 L
.24658 .11689 L
.24659 .07522 L
.24661 .08506 L
.24664 .10104 L
.24666 .09762 L
.24667 .11537 L
.24668 .12047 L
.2467 .16168 L
.24671 .11484 L
.24672 .13198 L
.24674 .12037 L
.24675 .10058 L
Mistroke
.24677 .12932 L
.24678 .09077 L
.24679 .08046 L
.2468 .16313 L
.24682 .13884 L
.24683 .12995 L
.24685 .10296 L
.24686 .13515 L
.24687 .08795 L
.24689 .13319 L
.2469 .12415 L
.2469 .11575 L
.24692 .13354 L
.24693 .0764 L
.24695 .0938 L
.24696 .14473 L
.24697 .11674 L
.24699 .11071 L
.247 .12439 L
.24701 .05266 L
.24702 .13719 L
.24704 .13953 L
.24705 .1278 L
.24707 .12222 L
.24708 .07479 L
.2471 .10798 L
.24711 .13922 L
.24712 .08533 L
.24714 .11752 L
.24714 .05055 L
.24715 .10257 L
.24717 .12558 L
.24718 .15397 L
.2472 .09526 L
.24721 .14422 L
.24722 .11141 L
.24724 .08547 L
.24725 .10837 L
.24726 .10938 L
.24728 .13508 L
.24729 .12872 L
.24731 .11867 L
.24731 .13146 L
.24732 .12212 L
.24734 .09545 L
.24735 .1215 L
.24736 .08962 L
.24737 .15377 L
.24738 .06948 L
.24739 .09323 L
Mistroke
.2474 .12402 L
.24741 .11015 L
.24742 .15106 L
.24744 .11218 L
.24744 .08374 L
.24745 .13169 L
.24747 .11213 L
.24748 .11679 L
.2475 .15439 L
.24751 .11681 L
.24752 .10722 L
.24754 .10569 L
.24755 .1297 L
.24756 .11927 L
.24757 .13518 L
.24759 .10646 L
.2476 .10798 L
.2476 .14321 L
.24762 .13394 L
.24763 .08246 L
.24765 .10686 L
.24766 .07937 L
.24767 .11852 L
.24768 .12442 L
.24769 .12099 L
.2477 .11145 L
.24771 .10844 L
.24773 .09544 L
.24773 .08731 L
.24774 .07414 L
.24776 .09973 L
.24777 .10929 L
.24778 .14097 L
.24779 .10886 L
.2478 .12323 L
.24781 .13725 L
.24782 .1379 L
.24784 .12299 L
.24785 .1152 L
.24786 .10706 L
.24786 .07507 L
.24787 .14666 L
.24788 .09179 L
.24789 .08982 L
.2479 .0972 L
.24791 .07982 L
.24792 .14907 L
.24794 .10219 L
.24795 .12404 L
.24796 .14877 L
Mistroke
.24798 .11827 L
.24799 .11988 L
.248 .12169 L
.24801 .08672 L
.24802 .0873 L
.24804 .15083 L
.24805 .1205 L
.24806 .09339 L
.24807 .10471 L
.24808 .10772 L
.2481 .09002 L
.24811 .12449 L
.24812 .08854 L
.24814 .10269 L
.24815 .12677 L
.24817 .16125 L
.24818 .11665 L
.24819 .06999 L
.2482 .10376 L
.24821 .11158 L
.24822 .10433 L
.24823 .1161 L
.24825 .14669 L
.24826 .13363 L
.24828 .09389 L
.24829 .14132 L
.2483 .08746 L
.24832 .10836 L
.24833 .13392 L
.24834 .1117 L
.24836 .14606 L
.24837 .11755 L
.24838 .10327 L
.2484 .10941 L
.24841 .07861 L
.24842 .09704 L
.24844 .10126 L
.24845 .08977 L
.24847 .10855 L
.24848 .14259 L
.2485 .10718 L
.24851 .08664 L
.24852 .12095 L
.24854 .13342 L
.24855 .12713 L
.24857 .12746 L
.24858 .05859 L
.24859 .10196 L
.24861 .12431 L
.24862 .13338 L
Mistroke
.24862 .18471 L
.24863 .13531 L
.24864 .08881 L
.24866 .12083 L
.24867 .11912 L
.24867 .11207 L
.24869 .13715 L
.2487 .14721 L
.24871 .12867 L
.24872 .1188 L
.24873 .17081 L
.24875 .08176 L
.24876 .11852 L
.24877 .08503 L
.24878 .13617 L
.2488 .13193 L
.24881 .09412 L
.24882 .11065 L
.24883 .16056 L
.24884 .11163 L
.24884 .13977 L
.24885 .14607 L
.24886 .1249 L
.24888 .10296 L
.24889 .13917 L
.24891 .1285 L
.24892 .14261 L
.24893 .12115 L
.24894 .08477 L
.24895 .08351 L
.24895 .10083 L
.24897 .08206 L
.24898 .13795 L
.24899 .15788 L
.249 .13892 L
.24901 .10135 L
.24902 .13567 L
.24903 .14405 L
.24905 .12882 L
.24906 .12726 L
.24907 .0952 L
.24909 .12614 L
.2491 .1154 L
.24911 .10958 L
.24913 .12014 L
.24915 .0981 L
.24916 .12411 L
.24917 .08293 L
.24918 .09321 L
.24919 .12081 L
Mistroke
.24921 .08725 L
.24921 .08619 L
.24922 .1022 L
.24924 .11563 L
.24925 .10347 L
.24926 .14644 L
.24928 .10922 L
.24929 .12484 L
.24931 .12466 L
.24932 .13204 L
.24934 .10744 L
.24935 .12242 L
.24936 .09469 L
.24938 .15978 L
.24939 .14161 L
.2494 .14525 L
.24942 .08851 L
.24943 .08875 L
.24944 .09481 L
.24946 .09466 L
.24947 .10271 L
.24947 .11841 L
.24949 .12159 L
.2495 .10486 L
.24952 .12368 L
.24953 .13391 L
.24955 .15257 L
.24956 .13133 L
.24957 .15495 L
.24957 .12857 L
.24958 .07406 L
.24959 .07626 L
.2496 .06271 L
.24961 .12494 L
.24962 .09582 L
.24963 .14911 L
.24964 .12143 L
.24964 .12069 L
.24965 .10635 L
.24967 .09023 L
.24968 .14664 L
.24969 .16509 L
.2497 .09758 L
.24971 .13897 L
.24973 .12634 L
.24974 .13516 L
.24976 .13681 L
.24977 .11238 L
.24978 .14941 L
.24979 .1544 L
Mistroke
.2498 .11178 L
.24982 .13716 L
.24983 .12629 L
.24983 .1229 L
.24984 .13357 L
.24985 .12246 L
.24987 .10694 L
.24987 .11248 L
.24988 .11398 L
.2499 .10287 L
.24991 .07644 L
.24993 .10886 L
.24994 .15033 L
.24996 .10502 L
.24997 .09491 L
.24998 .11345 L
.25 .11046 L
.25001 .11475 L
.25003 .13128 L
.25003 .13474 L
.25004 .11276 L
.25006 .10758 L
.25007 .14173 L
.25007 .15647 L
.25008 .11914 L
.25009 .10729 L
.25011 .10931 L
.25011 .10767 L
.25012 .13901 L
.25014 .10567 L
.25015 .11912 L
.25017 .11523 L
.25018 .10269 L
.2502 .16192 L
.25021 .10304 L
.25022 .11341 L
.25024 .10808 L
.25025 .16035 L
.25026 .14281 L
.25027 .11087 L
.25029 .13854 L
.2503 .08564 L
.25032 .1294 L
.25033 .11628 L
.25034 .1243 L
.25036 .13754 L
.25036 .09571 L
.25037 .15059 L
.25039 .0838 L
.2504 .10195 L
Mistroke
.25042 .13155 L
.25043 .06915 L
.25045 .09811 L
.25046 .08095 L
.25048 .1129 L
.25049 .14761 L
.2505 .08814 L
.25052 .11001 L
.25053 .1368 L
.25055 .08622 L
.25056 .14209 L
.25057 .08475 L
.25059 .09902 L
.2506 .15823 L
.25061 .13498 L
.25062 .10751 L
.25064 .08489 L
.25065 .07834 L
.25066 .11511 L
.25068 .12195 L
.25069 .12184 L
.2507 .13932 L
.25072 .09445 L
.25073 .11428 L
.25074 .12562 L
.25076 .10288 L
.25077 .109 L
.25078 .10788 L
.2508 .15263 L
.25081 .10184 L
.25082 .08428 L
.25083 .0846 L
.25084 .12185 L
.25086 .10894 L
.25087 .11433 L
.25089 .1166 L
.2509 .10959 L
.25092 .13175 L
.25093 .14846 L
.25094 .12167 L
.25096 .10129 L
.25097 .11225 L
.25098 .10689 L
.251 .1003 L
.25101 .10858 L
.25103 .11321 L
.25104 .15172 L
.25105 .12078 L
.25106 .09898 L
.25108 .08329 L
Mistroke
.25109 .10433 L
.25111 .07629 L
.25112 .09302 L
.25113 .10176 L
.25115 .15924 L
.25116 .09904 L
.25117 .10681 L
.25118 .09596 L
.2512 .1378 L
.25121 .11549 L
.25123 .12521 L
.25124 .10202 L
.25125 .13188 L
.25127 .10655 L
.25127 .09165 L
.25128 .11576 L
.2513 .10988 L
.25131 .12649 L
.25133 .09705 L
.25133 .07719 L
.25134 .09153 L
.25136 .08605 L
.25137 .12265 L
.25138 .08848 L
.2514 .13848 L
.25141 .06725 L
.25143 .13108 L
.25144 .14482 L
.25145 .11258 L
.25146 .11169 L
.25147 .15017 L
.25148 .10643 L
.25149 .12623 L
.2515 .09813 L
.25152 .12285 L
.25153 .08407 L
.25155 .10264 L
.25156 .11192 L
.25157 .11256 L
.25159 .13102 L
.2516 .10681 L
.25161 .09489 L
.25163 .10579 L
.25164 .08842 L
.25165 .13727 L
.25167 .16254 L
.25168 .08753 L
.25169 .15131 L
.25171 .10153 L
.25172 .08251 L
Mistroke
.25174 .12447 L
.25175 .08301 L
.25177 .10795 L
.25178 .11006 L
.2518 .15587 L
.25181 .10725 L
.25181 .16776 L
.25183 .11752 L
.25184 .15633 L
.25185 .11842 L
.25186 .14621 L
.25187 .12099 L
.25189 .10957 L
.2519 .1116 L
.25192 .09301 L
.25193 .13191 L
.25194 .09316 L
.25196 .0917 L
.25197 .13697 L
.25199 .12487 L
.252 .10942 L
.25202 .1068 L
.25203 .10505 L
.25205 .09426 L
.25206 .14221 L
.25208 .11649 L
.25208 .12709 L
.25209 .12118 L
.25211 .11832 L
.25212 .13435 L
.25212 .103 L
.25213 .12049 L
.25214 .13041 L
.25215 .11041 L
.25216 .1091 L
.25217 .07455 L
.25219 .11877 L
.25219 .14492 L
.2522 .12647 L
.25222 .1392 L
.25223 .1071 L
.25223 .14524 L
.25224 .08666 L
.25225 .14067 L
.25227 .10182 L
.25228 .14145 L
.2523 .13631 L
.25231 .11195 L
.25233 .16375 L
.25234 .14552 L
Mistroke
.25235 .11409 L
.25237 .13991 L
.25238 .1084 L
.2524 .08675 L
.25241 .09741 L
.25242 .12447 L
.25244 .09958 L
.25245 .09531 L
.25246 .12305 L
.25247 .08498 L
.25249 .13899 L
.2525 .13447 L
.25251 .1148 L
.25253 .11349 L
.25254 .09975 L
.25255 .12063 L
.25257 .09269 L
.25258 .0936 L
.25259 .11322 L
.25261 .15865 L
.25262 .13366 L
.25263 .07556 L
.25265 .12011 L
.25266 .12514 L
.25267 .15367 L
.25268 .13453 L
.25269 .09896 L
.25271 .13624 L
.25272 .11026 L
.25274 .15933 L
.25275 .12279 L
.25277 .1313 L
.25278 .14051 L
.25279 .13597 L
.25281 .08078 L
.25282 .08963 L
.25283 .11101 L
.25285 .12748 L
.25286 .08707 L
.25288 .10471 L
.25289 .08322 L
.2529 .0921 L
.25291 .12518 L
.25293 .15137 L
.25294 .08018 L
.25295 .13648 L
.25297 .10765 L
.25298 .11376 L
.253 .10803 L
.25301 .12054 L
Mistroke
.25302 .12446 L
.25303 .13473 L
.25305 .11392 L
.25306 .09952 L
.25307 .11699 L
.25309 .0887 L
.2531 .10306 L
.25312 .12917 L
.25312 .11592 L
.25313 .14597 L
.25315 .12092 L
.25316 .10579 L
.25318 .1047 L
.25319 .12327 L
.25321 .10944 L
.25322 .09482 L
.25323 .09016 L
.25325 .12059 L
.25326 .10203 L
.25327 .10535 L
.25333 .11911 L
.25334 .10883 L
.25335 .14031 L
.25336 .13396 L
.25337 .12529 L
.25338 .11297 L
.2534 .15198 L
.25341 .13781 L
.25342 .08426 L
.25344 .13966 L
.25346 .10634 L
.25347 .12145 L
.25348 .10162 L
.2535 .09124 L
.25351 .09219 L
.25353 .09122 L
.25354 .10499 L
.25355 .15089 L
.25357 .13105 L
.25358 .13752 L
.25359 .13169 L
.2536 .11191 L
.25362 .11088 L
.25373 .09872 L
.25375 .10646 L
.25376 .15059 L
.25377 .14467 L
.25378 .12171 L
.2538 .14223 L
.25381 .11358 L
Mistroke
.25382 .1286 L
.25383 .12701 L
.25384 .14533 L
.25386 .08603 L
.25387 .08659 L
.25388 .12671 L
.2539 .1327 L
.25391 .08956 L
.25392 .14686 L
.25394 .11049 L
.25395 .12187 L
.25396 .13871 L
.25398 .14868 L
.25399 .14457 L
.25401 .14099 L
.25401 .11394 L
.25402 .1063 L
.25404 .14303 L
.25405 .12551 L
.25407 .09392 L
.25408 .11153 L
.25409 .12165 L
.25411 .11098 L
.25412 .08808 L
.25414 .1263 L
.25415 .14476 L
.25416 .14969 L
.25417 .10662 L
.25418 .0997 L
.2542 .10725 L
.25421 .10631 L
.25423 .1023 L
.25424 .12633 L
.25425 .12885 L
.25427 .12533 L
.25428 .1157 L
.25429 .12601 L
.25431 .12402 L
.25432 .13256 L
.25433 .13561 L
.25434 .14136 L
.25435 .08337 L
.25436 .11332 L
.25437 .10589 L
.25438 .08219 L
.25439 .10255 L
.2544 .12084 L
.25441 .09038 L
.25442 .0806 L
.25443 .11751 L
Mistroke
.25444 .14182 L
.25445 .08338 L
.25446 .11005 L
.25447 .13089 L
.25448 .11872 L
.2545 .11376 L
.25451 .12259 L
.25453 .11096 L
.25454 .09236 L
.25456 .08732 L
.25457 .08891 L
.25459 .11494 L
.2546 .10387 L
.25462 .10442 L
.25463 .11828 L
.25464 .13788 L
.25466 .13681 L
.25467 .07538 L
.25468 .10378 L
.25469 .07783 L
.2547 .11432 L
.25471 .0945 L
.25472 .1011 L
.25473 .08114 L
.25475 .12962 L
.25476 .12128 L
.25478 .12229 L
.25479 .11982 L
.2548 .08756 L
.25482 .13483 L
.25483 .09535 L
.25484 .12069 L
.25485 .11713 L
.25487 .12833 L
.25488 .08513 L
.25489 .11844 L
.2549 .09484 L
.25491 .09954 L
.25492 .12261 L
.25493 .11667 L
.25494 .12034 L
.25495 .11166 L
.25495 .11148 L
.25496 .13298 L
.25498 .13815 L
.25499 .13855 L
.255 .0819 L
.25501 .10745 L
.25503 .12678 L
.25504 .11987 L
Mistroke
.25506 .09814 L
.25507 .14904 L
.25508 .09608 L
.25509 .1011 L
.2551 .08962 L
.25511 .10325 L
.25512 .07953 L
.25513 .1232 L
.25513 .14186 L
.25514 .11005 L
.25515 .13286 L
.25517 .14181 L
.25518 .1142 L
.25519 .1068 L
.2552 .11884 L
.25521 .1329 L
.25523 .11377 L
.25524 .11904 L
.25526 .10953 L
.25527 .07948 L
.25529 .13205 L
.2553 .10909 L
.25531 .13586 L
.25533 .15443 L
.25534 .11423 L
.25535 .09072 L
.25536 .07972 L
.25538 .09232 L
.25539 .06802 L
.2554 .13081 L
.25542 .13742 L
.25543 .10525 L
.25544 .08872 L
.25546 .10374 L
.25547 .14018 L
.25548 .07772 L
.2555 .07689 L
.25551 .1024 L
.25552 .11418 L
.25554 .10722 L
.25555 .11047 L
.25557 .13032 L
.25558 .11437 L
.25559 .09912 L
.25561 .14472 L
.25562 .12279 L
.25564 .1109 L
.25565 .11547 L
.25565 .14804 L
.25567 .12933 L
Mistroke
.25568 .12233 L
.25569 .1008 L
.2557 .13614 L
.25571 .13374 L
.25575 .12815 L
.25582 .11801 L
.25582 .16389 L
.25583 .10312 L
.25584 .11998 L
.25585 .06856 L
.25586 .12128 L
.25587 .10912 L
.25588 .10815 L
.2559 .11162 L
.25591 .13257 L
.25593 .08478 L
.25594 .13083 L
.25595 .10994 L
.25595 .11926 L
.25597 .1423 L
.25598 .10942 L
.25599 .14861 L
.256 .1302 L
.25602 .142 L
.25603 .14481 L
.25604 .09639 L
.25606 .13367 L
.25607 .10414 L
.25608 .10047 L
.25609 .10343 L
.2561 .14342 L
.25612 .15985 L
.25613 .10679 L
.25615 .11388 L
.25616 .07341 L
.25617 .11694 L
.25619 .12521 L
.2562 .11409 L
.25621 .12605 L
.25623 .06865 L
.25624 .1232 L
.25625 .10412 L
.25626 .10528 L
.25627 .10081 L
.25629 .12377 L
.2563 .10195 L
.25631 .16378 L
.25632 .08156 L
.25633 .11517 L
.25634 .13316 L
Mistroke
.25635 .09872 L
.25636 .12662 L
.25637 .08476 L
.25638 .13983 L
.2564 .13082 L
.25641 .06529 L
.25643 .09669 L
.25644 .08531 L
.25644 .0956 L
.25646 .13112 L
.25647 .14001 L
.25648 .10706 L
.25649 .07935 L
.2565 .14492 L
.25652 .10161 L
.25653 .12429 L
.25654 .09724 L
.25655 .10886 L
.25657 .10861 L
.25658 .0822 L
.2566 .10745 L
.25661 .14874 L
.25662 .14349 L
.25664 .14378 L
.25665 .11796 L
.25666 .0845 L
.25668 .14653 L
.25669 .11815 L
.25671 .0773 L
.25671 .09155 L
.25672 .11152 L
.25674 .12013 L
.25675 .13351 L
.25677 .12266 L
.25678 .11692 L
.25679 .15553 L
.2568 .11651 L
.25681 .10761 L
.25682 .10648 L
.25683 .11822 L
.25683 .13409 L
.25685 .15459 L
.25686 .12027 L
.25688 .11955 L
.25689 .10972 L
.25691 .12892 L
.25692 .11124 L
.25692 .13165 L
.25694 .09056 L
.25696 .15737 L
Mistroke
.25697 .10042 L
.25699 .12725 L
.257 .1567 L
.25701 .13474 L
.25703 .07635 L
.25704 .1169 L
.25706 .16232 L
.25707 .07211 L
.25708 .1198 L
.25709 .15055 L
.2571 .10595 L
.25711 .12436 L
.25713 .11052 L
.25714 .09735 L
.25716 .1453 L
.25717 .1277 L
.25717 .14262 L
.25719 .15398 L
.2572 .10931 L
.25722 .08801 L
.25723 .0963 L
.25725 .13872 L
.25726 .11233 L
.25728 .10473 L
.25729 .11132 L
.2573 .15844 L
.25732 .14051 L
.25733 .11406 L
.25735 .14022 L
.25736 .13926 L
.25737 .15257 L
.25738 .09504 L
.2574 .04033 L
.25741 .11965 L
.25742 .1247 L
.25743 .13749 L
.25744 .13868 L
.25745 .11825 L
.25747 .07819 L
.25748 .16311 L
.2575 .09351 L
.25751 .11511 L
.25752 .16642 L
.25754 .13044 L
.25755 .11769 L
.25756 .11207 L
.25757 .15612 L
.25758 .08828 L
.25759 .12697 L
.2576 .17099 L
Mistroke
.25762 .1051 L
.25763 .16007 L
.25765 .10926 L
.25766 .11496 L
.25767 .08432 L
.25769 .09381 L
.2577 .13809 L
.25771 .15417 L
.25773 .14001 L
.25774 .12076 L
.25775 .09517 L
.25777 .11202 L
.25778 .15688 L
.25779 .09319 L
.25781 .10533 L
.25782 .13296 L
.25784 .09132 L
.25785 .14493 L
.25787 .09356 L
.25788 .11044 L
.2579 .12773 L
.2579 .12529 L
.25791 .10075 L
.25792 .08406 L
.25793 .10828 L
.25794 .12075 L
.25796 .08401 L
.25797 .13096 L
.25799 .1147 L
.258 .13689 L
.25802 .10613 L
.25803 .13747 L
.25804 .11296 L
.25806 .11205 L
.25807 .14571 L
.25809 .15086 L
.2581 .11998 L
.25812 .15368 L
.25813 .13711 L
.25815 .09737 L
.25816 .09364 L
.25817 .13035 L
.25818 .14389 L
.25819 .10294 L
.25821 .13597 L
.25821 .09269 L
.25822 .13077 L
.25823 .12351 L
.25824 .16873 L
.25825 .14115 L
Mistroke
.25826 .10279 L
.25827 .09329 L
.25828 .11479 L
.25829 .13491 L
.2583 .12675 L
.25831 .1344 L
.25831 .11462 L
.25832 .09858 L
.25834 .15375 L
.25835 .14999 L
.25837 .074 L
.25838 .10116 L
.2584 .1364 L
.25841 .11938 L
.25842 .08625 L
.25844 .11208 L
.25845 .10322 L
.25846 .1553 L
.25848 .12498 L
.2585 .14695 L
.25851 .11995 L
.25852 .09917 L
.25853 .12121 L
.25854 .0937 L
.25856 .15181 L
.25857 .1219 L
.25859 .08703 L
.2586 .1154 L
.25861 .09242 L
.25863 .08302 L
.25864 .11992 L
.25865 .10836 L
.25867 .12021 L
.25868 .09386 L
.25869 .09962 L
.25871 .11293 L
.25872 .10591 L
.25873 .0875 L
.25875 .14831 L
.25876 .13679 L
.25877 .10444 L
.25878 .13428 L
.25879 .08994 L
.25881 .11 L
.25882 .12506 L
.25884 .13187 L
.25885 .12009 L
.25887 .09488 L
.25888 .1441 L
.25889 .0762 L
Mistroke
.25891 .17574 L
.25892 .0931 L
.25893 .10006 L
.25895 .13365 L
.25896 .09881 L
.25898 .11078 L
.25899 .09342 L
.259 .16104 L
.25901 .10339 L
.25903 .11845 L
.25904 .12289 L
.25905 .08493 L
.25907 .16472 L
.25908 .15095 L
.2591 .10823 L
.25911 .1246 L
.25912 .13666 L
.25913 .13016 L
.25915 .12267 L
.25916 .09723 L
.25917 .10376 L
.25919 .15024 L
.2592 .09352 L
.25922 .09246 L
.25922 .114 L
.25923 .13554 L
.25925 .10706 L
.25926 .11688 L
.25928 .07061 L
.25928 .12208 L
.25929 .10968 L
.25931 .11511 L
.25932 .09789 L
.25933 .14728 L
.25935 .11875 L
.25936 .12024 L
.25937 .14547 L
.25939 .10869 L
.2594 .12972 L
.25941 .15541 L
.25942 .12854 L
.25943 .11201 L
.25944 .12801 L
.25945 .08291 L
.25947 .15017 L
.25948 .12368 L
.2595 .1112 L
.25951 .07134 L
.25952 .16453 L
.25954 .18139 L
Mistroke
.25955 .08932 L
.25956 .107 L
.25958 .10598 L
.25959 .08701 L
.2596 .13105 L
.25962 .09468 L
.25963 .10695 L
.25964 .11141 L
.25966 .13701 L
.25967 .13539 L
.25969 .13863 L
.2597 .10889 L
.25972 .11545 L
.25973 .12355 L
.25975 .15467 L
.25975 .15069 L
.25976 .09057 L
.25977 .12587 L
.25978 .11037 L
.25979 .11601 L
.25981 .12547 L
.25982 .126 L
.25984 .09157 L
.25985 .11832 L
.25987 .1475 L
.25988 .09057 L
.25989 .14498 L
.25991 .11968 L
.25992 .10911 L
.25994 .14496 L
.25995 .12656 L
.25997 .10206 L
.25998 .09999 L
.26 .13607 L
.26001 .14571 L
.26002 .14239 L
.26003 .14617 L
.26004 .14545 L
.26006 .10428 L
.26007 .08744 L
.26007 .11658 L
.26008 .11684 L
.26009 .15719 L
.2601 .10836 L
.26011 .11974 L
.26012 .12103 L
.26013 .14524 L
.26014 .15419 L
.26015 .10865 L
.26016 .13195 L
Mistroke
.26016 .11844 L
.26017 .10743 L
.26019 .14862 L
.2602 .10282 L
.26022 .16637 L
.26023 .15124 L
.26025 .09231 L
.26026 .1124 L
.26028 .08092 L
.26029 .11047 L
.2603 .16134 L
.26031 .12471 L
.26033 .12934 L
.26035 .08702 L
.26036 .1111 L
.26037 .13748 L
.26039 .12586 L
.2604 .10481 L
.26041 .13469 L
.26042 .10334 L
.26044 .13067 L
.26045 .13829 L
.26046 .12863 L
.26048 .13114 L
.26049 .15129 L
.2605 .16002 L
.26052 .10122 L
.26053 .08336 L
.26054 .13298 L
.26056 .11121 L
.26057 .13938 L
.26058 .12823 L
.2606 .10129 L
.26061 .11627 L
.26062 .09427 L
.26063 .11585 L
.26064 .10597 L
.26066 .08042 L
.26067 .13523 L
.26069 .10271 L
.2607 .07362 L
.26072 .14414 L
.26073 .1514 L
.26074 .14245 L
.26076 .08379 L
.26077 .10466 L
.26078 .13291 L
.2608 .159 L
.26081 .10159 L
.26083 .09632 L
Mistroke
.26084 .14778 L
.26085 .11628 L
.26086 .1151 L
.26088 .10485 L
.26089 .1285 L
.2609 .10241 L
.26092 .10746 L
.26093 .09863 L
.26095 .0943 L
.26096 .11269 L
.26097 .10889 L
.26098 .11374 L
.261 .11231 L
.26101 .10468 L
.26102 .14642 L
.26104 .12311 L
.26105 .11899 L
.26107 .14992 L
.26107 .08505 L
.26108 .13232 L
.2611 .12918 L
.26111 .07804 L
.26113 .12482 L
.26114 .13666 L
.26116 .14899 L
.26117 .0985 L
.26118 .10384 L
.2612 .12348 L
.26121 .11663 L
.26122 .07879 L
.26124 .09324 L
.26125 .11403 L
.26127 .11363 L
.26128 .12285 L
.2613 .1147 L
.26131 .13364 L
.26132 .12306 L
.26133 .06764 L
.26135 .07652 L
.26136 .11231 L
.26137 .10439 L
.26139 .12857 L
.2614 .1265 L
.26141 .14733 L
.26143 .10422 L
.26144 .14764 L
.26146 .08387 L
.26147 .11723 L
.26149 .15858 L
.2615 .14239 L
Mistroke
.26151 .11506 L
.26152 .10767 L
.26154 .09626 L
.26155 .1108 L
.26157 .0805 L
.26158 .10954 L
.26159 .10352 L
.26161 .10624 L
.26162 .11305 L
.26162 .11107 L
.26164 .11834 L
.26165 .08783 L
.26167 .14194 L
.26168 .11442 L
.2617 .15187 L
.2617 .09707 L
.26171 .11108 L
.26173 .10587 L
.26174 .12928 L
.26175 .08018 L
.26176 .13143 L
.26177 .14637 L
.26178 .11563 L
.26179 .06362 L
.2618 .08749 L
.26181 .09698 L
.26182 .11332 L
.26184 .11723 L
.26184 .13499 L
.26185 .10128 L
.26187 .17223 L
.26188 .14677 L
.2619 .11367 L
.26191 .14611 L
.26193 .12108 L
.26193 .13926 L
.26194 .15071 L
.26196 .11745 L
.26197 .0574 L
.26198 .10285 L
.26198 .07193 L
.26199 .11793 L
.262 .10233 L
.26201 .09656 L
.26202 .12162 L
.26203 .13329 L
.26204 .10359 L
.26206 .10365 L
.26207 .11458 L
.26209 .10808 L
Mistroke
.2621 .09702 L
.26212 .09856 L
.26213 .11429 L
.26215 .04445 L
.26216 .09081 L
.26217 .12819 L
.26219 .11549 L
.2622 .09135 L
.26221 .13367 L
.26223 .10386 L
.26225 .13325 L
.26225 .13103 L
.26226 .14003 L
.26228 .06772 L
.26229 .07977 L
.26231 .09981 L
.26232 .11165 L
.26233 .13035 L
.26235 .07713 L
.26236 .07258 L
.26237 .09335 L
.26238 .14056 L
.2624 .1169 L
.26241 .12423 L
.26243 .12818 L
.26244 .13938 L
.26245 .07063 L
.26247 .13926 L
.26248 .12314 L
.26248 .10897 L
.2625 .11528 L
.26251 .1136 L
.26253 .11262 L
.26254 .08138 L
.26256 .11684 L
.26257 .15795 L
.26259 .08075 L
.2626 .10148 L
.26261 .09445 L
.26263 .10611 L
.26264 .13491 L
.26266 .09873 L
.26267 .11348 L
.26268 .08796 L
.2627 .14267 L
.26271 .14701 L
.26272 .10609 L
.26273 .10401 L
.26275 .13092 L
.26276 .08363 L
Mistroke
.26277 .13599 L
.26279 .11807 L
.2628 .15164 L
.26281 .11018 L
.26283 .11251 L
.26284 .13439 L
.26285 .125 L
.26287 .08156 L
.26288 .1147 L
.26289 .15883 L
.26291 .11437 L
.26292 .14613 L
.26293 .10736 L
.26294 .12067 L
.26295 .13992 L
.26297 .11375 L
.26298 .12143 L
.263 .12734 L
.26301 .15415 L
.26303 .10905 L
.26304 .09714 L
.26305 .15207 L
.26307 .12576 L
.26308 .15446 L
.2631 .11774 L
.26311 .07617 L
.26312 .15112 L
.26314 .11525 L
.26315 .15291 L
.26316 .1072 L
.26317 .10208 L
.26319 .14717 L
.2632 .10877 L
.26321 .15199 L
.26323 .10799 L
.26324 .08901 L
.26326 .06026 L
.26327 .11385 L
.26328 .08544 L
.26329 .10588 L
.26331 .09384 L
.26332 .11524 L
.26334 .10475 L
.26335 .12042 L
.26336 .10551 L
.26338 .10511 L
.26339 .1483 L
.26339 .0932 L
.26341 .08428 L
.26342 .17766 L
Mistroke
.26344 .1417 L
.26344 .09357 L
.26345 .14089 L
.26347 .12846 L
.26348 .10154 L
.26349 .11448 L
.26351 .14786 L
.26352 .13243 L
.26354 .09646 L
.26355 .1348 L
.26356 .10932 L
.26357 .10227 L
.26358 .12505 L
.26359 .12306 L
.2636 .05144 L
.26361 .10665 L
.26363 .11219 L
.26364 .10232 L
.26366 .1173 L
.26367 .0877 L
.26368 .09052 L
.2637 .12569 L
.26371 .09846 L
.26372 .11379 L
.26374 .07749 L
.26375 .11295 L
.26376 .11065 L
.26378 .09144 L
.26379 .09899 L
.26381 .12392 L
.26382 .13063 L
.26383 .10281 L
.26385 .11629 L
.26386 .0871 L
.26388 .12573 L
.26389 .11031 L
.26391 .10165 L
.26392 .08481 L
.26392 .12631 L
.26393 .09532 L
.26394 .10274 L
.26396 .17538 L
.26397 .08851 L
.26398 .08695 L
.264 .12342 L
.26401 .10573 L
.26403 .1178 L
.26404 .1374 L
.26405 .13199 L
.26407 .14157 L
Mistroke
.26408 .10917 L
.2641 .13886 L
.26411 .09236 L
.26413 .10653 L
.26414 .11771 L
.26416 .0829 L
.26417 .11092 L
.26419 .11603 L
.2642 .09217 L
.2642 .14821 L
.26422 .12522 L
.26423 .06145 L
.26423 .09999 L
.26425 .12146 L
.26426 .11416 L
.26427 .124 L
.26428 .10653 L
.2643 .12143 L
.2643 .13528 L
.26431 .12997 L
.26432 .07671 L
.26433 .13066 L
.26435 .12653 L
.26436 .12983 L
.26436 .13649 L
.26438 .14935 L
.26439 .11598 L
.26441 .10845 L
.26442 .12196 L
.26443 .12364 L
.26444 .12875 L
.26445 .11113 L
.26447 .14674 L
.26448 .09998 L
.26449 .10869 L
.26451 .12909 L
.26452 .10533 L
.26453 .107 L
.26455 .09872 L
.26456 .10137 L
.26458 .06687 L
.26459 .09426 L
.2646 .11035 L
.26461 .09252 L
.26462 .10804 L
.26464 .08169 L
.26465 .14621 L
.26466 .08755 L
.26467 .10296 L
.26468 .12229 L
Mistroke
.26468 .14155 L
.2647 .15891 L
.26471 .13383 L
.26472 .10877 L
.26473 .08953 L
.26474 .13147 L
.26475 .09318 L
.26476 .12311 L
.26478 .1242 L
.26479 .15143 L
.26481 .1214 L
.26482 .13129 L
.26484 .13361 L
.26484 .14185 L
.26485 .10854 L
.26487 .1254 L
.26488 .1253 L
.26489 .14733 L
.2649 .10728 L
.26491 .0881 L
.26493 .15984 L
.26494 .1665 L
.26496 .12143 L
.26497 .14341 L
.26498 .08541 L
.26498 .13688 L
.26499 .12192 L
.26501 .0982 L
.26502 .1174 L
.26503 .14719 L
.26504 .11043 L
.26505 .12039 L
.26506 .13003 L
.26507 .14399 L
.26508 .14887 L
.26509 .11551 L
.2651 .0977 L
.26511 .08848 L
.26512 .07792 L
.26514 .10842 L
.26515 .12731 L
.26517 .11505 L
.26517 .14446 L
.26518 .09122 L
.26519 .09405 L
.2652 .07408 L
.26521 .12656 L
.26522 .10775 L
.26523 .09598 L
.26524 .1314 L
Mistroke
.26526 .10761 L
.26527 .16227 L
.26529 .10029 L
.26529 .12361 L
.2653 .07195 L
.26532 .11771 L
.26533 .11802 L
.26579 .12594 L
.26604 .1302 L
.26628 .13299 L
.26629 .13056 L
.26631 .14113 L
.26631 .1014 L
.26632 .11616 L
.26634 .09188 L
.26635 .1341 L
.26637 .10959 L
.26638 .10092 L
.26639 .11854 L
.26641 .10145 L
.26642 .11133 L
.26643 .13532 L
.26644 .09026 L
.26645 .07313 L
.26646 .10761 L
.26647 .07061 L
.26649 .12328 L
.26649 .10013 L
.2665 .12665 L
.26651 .11553 L
.26652 .09375 L
.26653 .11221 L
.26655 .13065 L
.26656 .08689 L
.26658 .12152 L
.26659 .13023 L
.2666 .1102 L
.26661 .08521 L
.26662 .08694 L
.26664 .07696 L
.26665 .12444 L
.26666 .09121 L
.26668 .12477 L
.26669 .10326 L
.2667 .12997 L
.26672 .08998 L
.26673 .13068 L
.26674 .13754 L
.26676 .13308 L
.26677 .07027 L
Mistroke
.26679 .1293 L
.2668 .09743 L
.26682 .11863 L
.26683 .0948 L
.26683 .10047 L
.26685 .16607 L
.26686 .14161 L
.26688 .12797 L
.26689 .12281 L
.2669 .134 L
.26692 .13174 L
.26693 .12405 L
.26695 .15615 L
.26696 .11771 L
.26697 .12759 L
.26699 .0873 L
.267 .13471 L
.26701 .10673 L
.26702 .08397 L
.26704 .10571 L
.26704 .11399 L
.26705 .08723 L
.26707 .1186 L
.26708 .13756 L
.26709 .10399 L
.26709 .11796 L
.2671 .09335 L
.26712 .10087 L
.26713 .12514 L
.26714 .08948 L
.26715 .13788 L
.26717 .13182 L
.26718 .10192 L
.26719 .1025 L
.26721 .11615 L
.26722 .18674 L
.26724 .13175 L
.26725 .06953 L
.26726 .12346 L
.26727 .10346 L
.26728 .1127 L
.26729 .13622 L
.2673 .13006 L
.26732 .13904 L
.26733 .11847 L
.26735 .1171 L
.26735 .12717 L
.26736 .12248 L
.26737 .15563 L
.26738 .11226 L
Mistroke
.26739 .09594 L
.2674 .0979 L
.26741 .12178 L
.26742 .11562 L
.26743 .08811 L
.26744 .11787 L
.26745 .14029 L
.26746 .12404 L
.26747 .14022 L
.26748 .14765 L
.26749 .11572 L
.2675 .13137 L
.26751 .0902 L
.26753 .18275 L
.26754 .08878 L
.26755 .09979 L
.26757 .14555 L
.26758 .11756 L
.2676 .08159 L
.2676 .07977 L
.26761 .10621 L
.26762 .11928 L
.26763 .10373 L
.26764 .13481 L
.26765 .1336 L
.26766 .11002 L
.26768 .12589 L
.26769 .11434 L
.26771 .07403 L
.26772 .11682 L
.26774 .14158 L
.26774 .08452 L
.26775 .12335 L
.26777 .07954 L
.26778 .12565 L
.26779 .1557 L
.26781 .13509 L
.26782 .14063 L
.26784 .11707 L
.26785 .11465 L
.26786 .10403 L
.26787 .15433 L
.26788 .09044 L
.26789 .1208 L
.2679 .13707 L
.26791 .12753 L
.26793 .13419 L
.26794 .12251 L
.26796 .14305 L
.26797 .15514 L
Mistroke
.26799 .11675 L
.268 .11776 L
.26801 .13308 L
.26803 .10974 L
.26804 .11487 L
.26806 .06563 L
.26807 .12291 L
.26809 .08443 L
.2681 .14072 L
.26811 .0753 L
.26813 .11815 L
.26814 .15401 L
.26815 .15478 L
.26817 .09184 L
.26818 .13607 L
.26819 .0858 L
.2682 .15554 L
.26821 .11621 L
.26823 .14263 L
.26823 .13629 L
.26824 .10472 L
.26826 .11543 L
.26827 .08059 L
.26828 .09749 L
.26829 .10633 L
.2683 .16739 L
.26832 .10403 L
.26833 .10561 L
.26835 .11826 L
.26836 .08412 L
.26838 .09702 L
.26839 .12013 L
.2684 .10422 L
.26842 .1397 L
.26843 .09895 L
.26845 .08208 L
.26845 .1054 L
.26846 .11661 L
.26848 .0698 L
.26849 .12357 L
.26851 .13221 L
.26852 .11938 L
.26854 .08466 L
.26854 .11018 L
.26855 .09342 L
.26857 .10545 L
.26858 .10913 L
.26859 .10927 L
.26859 .15581 L
.2686 .15106 L
Mistroke
.26861 .1153 L
.26862 .10432 L
.26863 .10109 L
.26864 .1116 L
.26865 .10084 L
.26867 .1008 L
.26868 .11372 L
.26869 .09301 L
.2687 .11633 L
.26871 .06537 L
.26873 .13113 L
.26874 .09669 L
.26875 .06626 L
.26877 .15657 L
.26878 .12278 L
.2688 .13831 L
.26881 .1145 L
.26881 .12234 L
.26882 .16419 L
.26883 .095 L
.26885 .15991 L
.26886 .09187 L
.26887 .11623 L
.26889 .153 L
.2689 .11783 L
.26892 .09971 L
.26893 .14381 L
.26894 .1038 L
.26895 .15109 L
.26897 .09563 L
.26898 .11642 L
.269 .09839 L
.26901 .11858 L
.26902 .11995 L
.26904 .10407 L
.26905 .12971 L
.26907 .12884 L
.26908 .14553 L
.2691 .09531 L
.26911 .129 L
.26912 .13226 L
.26914 .05175 L
.26915 .12399 L
.26916 .11109 L
.26917 .13127 L
.26918 .10658 L
.26919 .1072 L
.2692 .08792 L
.26922 .12367 L
.26922 .06587 L
Mistroke
.26923 .09205 L
.26925 .12777 L
.26926 .10446 L
.26928 .11306 L
.26929 .10614 L
.26931 .12535 L
.26932 .11474 L
.26933 .12929 L
.26935 .10283 L
.26936 .08525 L
.26938 .15102 L
.26939 .12805 L
.2694 .11318 L
.26941 .13451 L
.26942 .09089 L
.26944 .11747 L
.26945 .08428 L
.26946 .12599 L
.26948 .08552 L
.26949 .12584 L
.2695 .11787 L
.26951 .10266 L
.26952 .13622 L
.26953 .12144 L
.26954 .14126 L
.26955 .10682 L
.26956 .15131 L
.26956 .12781 L
.26957 .12059 L
.26958 .0839 L
.2696 .07187 L
.26961 .12777 L
.26963 .10108 L
.26963 .11036 L
.26964 .10974 L
.26966 .12878 L
.26967 .11748 L
.26968 .12742 L
.2697 .115 L
.26971 .14357 L
.26972 .14087 L
.26973 .11948 L
.26974 .11448 L
.26976 .12348 L
.26977 .15886 L
.26978 .08788 L
.26979 .13008 L
.2698 .07575 L
.26982 .11345 L
.26983 .12092 L
Mistroke
.26985 .12685 L
.26986 .10527 L
.26987 .10501 L
.26989 .15727 L
.2699 .12054 L
.26991 .12522 L
.26993 .10745 L
.26994 .10451 L
.26995 .10514 L
.26997 .12424 L
.26998 .08509 L
.26999 .0918 L
.27001 .12092 L
.27002 .13211 L
.27004 .11731 L
.27005 .13479 L
.27007 .1393 L
.27008 .1027 L
.2701 .14711 L
.2701 .11746 L
.27011 .1111 L
.27013 .10228 L
.27014 .10748 L
.27015 .09524 L
.27016 .09894 L
.27017 .11773 L
.27019 .13344 L
.2702 .08385 L
.27022 .09504 L
.27023 .1486 L
.27024 .12221 L
.27026 .11758 L
.27027 .14137 L
.27029 .09177 L
.2703 .08718 L
.27032 .10969 L
.27033 .11802 L
.27035 .08462 L
.27036 .14806 L
.27037 .1281 L
.27038 .1678 L
.27039 .15377 L
.27041 .1131 L
.27041 .10329 L
.27042 .11497 L
.27043 .12944 L
.27044 .13281 L
.27045 .03907 L
.27046 .12755 L
.27047 .08683 L
Mistroke
.27049 .09327 L
.27049 .08829 L
.2705 .11241 L
.27052 .09784 L
.27053 .09712 L
.27053 .12337 L
.27054 .12479 L
.27055 .0671 L
.27057 .1189 L
.27058 .08155 L
.27059 .09102 L
.27061 .1276 L
.27062 .09711 L
.27064 .09339 L
.27064 .11212 L
.27065 .10624 L
.27067 .11808 L
.27068 .15776 L
.27069 .10865 L
.2707 .11539 L
.27071 .09229 L
.27072 .11441 L
.27072 .12059 L
.27073 .09552 L
.27075 .07388 L
.27076 .13986 L
.27078 .1201 L
.27079 .13174 L
.2708 .09608 L
.27082 .15802 L
.27083 .13711 L
.27085 .11867 L
.27086 .1466 L
.27087 .12109 L
.27088 .14414 L
.2709 .11445 L
.27091 .14627 L
.27092 .12219 L
.27093 .10193 L
.27094 .09454 L
.27096 .12657 L
.27097 .12521 L
.27098 .15231 L
.271 .08546 L
.27101 .13251 L
.27102 .12941 L
.27103 .12087 L
.27104 .11818 L
.27106 .07972 L
.27107 .11899 L
Mistroke
.27108 .132 L
.27109 .1375 L
.2711 .11241 L
.27112 .14723 L
.27113 .09901 L
.27114 .12638 L
.27115 .11904 L
.27116 .1064 L
.27117 .1123 L
.27118 .14431 L
.2712 .09134 L
.27121 .06743 L
.27121 .10375 L
.27123 .08403 L
.27124 .12217 L
.27125 .1425 L
.27126 .10802 L
.27127 .12574 L
.27127 .10474 L
.27128 .13245 L
.2713 .14532 L
.27131 .11377 L
.27133 .12952 L
.27134 .14896 L
.27135 .12392 L
.27136 .1522 L
.27137 .10353 L
.27137 .13798 L
.27138 .15064 L
.27139 .12328 L
.27141 .11444 L
.27142 .12991 L
.27143 .11852 L
.27145 .1185 L
.27146 .13779 L
.27147 .10105 L
.27148 .14453 L
.27149 .14781 L
.27151 .1575 L
.27152 .12942 L
.27153 .14218 L
.27154 .12976 L
.27155 .08064 L
.27157 .13204 L
.27158 .14613 L
.27159 .12309 L
.27161 .12735 L
.27162 .06985 L
.27164 .12735 L
.27165 .12313 L
Mistroke
.27167 .10803 L
.27168 .12862 L
.27169 .10904 L
.2717 .13279 L
.27171 .13502 L
.27173 .1272 L
.27174 .11097 L
.27174 .11634 L
.27176 .11431 L
.27177 .07416 L
.27179 .11672 L
.2718 .13454 L
.27181 .10423 L
.27183 .07668 L
.27185 .12788 L
.27186 .10533 L
.27187 .15562 L
.27188 .07005 L
.2719 .11867 L
.27191 .10692 L
.27192 .1089 L
.27194 .08469 L
.27195 .13023 L
.27196 .11013 L
.27198 .10533 L
.272 .13576 L
.272 .11181 L
.27201 .12439 L
.27202 .14486 L
.27203 .10736 L
.27204 .09665 L
.27206 .1464 L
.27206 .10795 L
.27207 .13755 L
.27209 .09159 L
.2721 .14621 L
.27212 .10555 L
.27213 .10485 L
.27215 .12077 L
.27216 .12876 L
.27217 .12545 L
.27219 .1467 L
.2722 .10417 L
.27222 .09515 L
.27223 .10237 L
.27224 .08313 L
.27225 .1058 L
.27226 .09166 L
.27228 .10118 L
.27229 .09994 L
Mistroke
.27231 .14085 L
.27232 .14292 L
.27233 .10576 L
.27234 .16283 L
.27235 .15415 L
.27236 .09742 L
.27237 .11307 L
.27238 .09245 L
.27239 .12544 L
.2724 .14109 L
.27241 .14419 L
.27241 .15203 L
.27242 .17472 L
.27244 .08987 L
.27245 .09053 L
.27291 .11472 L
.27292 .11221 L
.27294 .11801 L
.27295 .12329 L
.27296 .09406 L
.27298 .08418 L
.27299 .13119 L
.273 .15644 L
.27301 .18437 L
.27303 .14749 L
.27304 .09404 L
.27306 .16411 L
.27307 .09505 L
.27308 .11162 L
.2731 .10231 L
.2731 .11903 L
.27311 .09358 L
.27313 .15131 L
.27314 .12725 L
.27316 .11949 L
.27317 .11794 L
.27317 .11677 L
.27319 .0969 L
.2732 .12265 L
.27321 .08641 L
.27322 .14835 L
.27324 .12334 L
.27325 .09788 L
.27326 .12625 L
.27326 .15079 L
.27327 .09916 L
.27329 .15916 L
.2733 .1524 L
.27331 .07348 L
.27332 .15265 L
Mistroke
.27333 .12329 L
.27335 .11689 L
.27336 .16842 L
.27338 .09275 L
.27339 .08235 L
.27341 .13103 L
.27342 .07526 L
.27343 .11239 L
.27345 .10843 L
.27346 .09027 L
.27348 .13413 L
.27349 .14326 L
.27351 .10316 L
.27351 .13571 L
.27352 .10525 L
.27353 .09158 L
.27354 .1432 L
.27355 .10696 L
.27356 .10697 L
.27357 .08007 L
.27359 .12424 L
.2736 .09718 L
.27361 .07268 L
.27363 .12862 L
.27364 .07472 L
.27365 .14438 L
.27366 .1098 L
.27368 .10638 L
.27368 .14928 L
.27369 .08616 L
.27371 .1283 L
.27372 .10761 L
.27374 .10263 L
.27375 .13607 L
.27376 .09949 L
.27377 .1473 L
.27378 .09192 L
.27378 .10229 L
.2738 .09244 L
.27381 .14012 L
.27383 .13765 L
.27384 .1023 L
.27385 .12066 L
.27386 .12576 L
.27387 .0947 L
.27387 .15917 L
.27388 .0783 L
.27389 .11757 L
.2739 .1154 L
.27391 .12673 L
Mistroke
.27393 .09917 L
.27394 .08419 L
.27395 .12339 L
.27396 .10522 L
.27397 .0954 L
.27398 .1498 L
.27399 .09766 L
.27401 .07873 L
.27402 .10841 L
.27403 .14301 L
.27405 .09604 L
.27406 .11028 L
.27408 .11113 L
.27409 .10423 L
.2741 .0925 L
.27412 .13884 L
.27413 .08475 L
.27415 .12064 L
.27416 .1352 L
.27416 .1459 L
.27418 .12065 L
.27419 .13004 L
.27421 .10043 L
.27422 .09192 L
.27424 .09068 L
.27425 .13251 L
.27426 .12939 L
.27427 .09742 L
.27428 .10055 L
.27429 .06396 L
.2743 .12053 L
.27431 .13182 L
.27431 .12004 L
.27432 .08715 L
.27433 .09626 L
.27434 .14329 L
.27435 .12746 L
.27437 .12082 L
.27438 .13194 L
.27439 .11572 L
.2744 .11478 L
.27441 .10726 L
.27443 .13879 L
.27444 .1233 L
.27446 .14454 L
.27447 .10039 L
.27448 .14144 L
.2745 .10985 L
.27451 .09351 L
.27451 .08288 L
Mistroke
.27452 .12324 L
.27453 .13455 L
.27455 .1465 L
.27456 .13036 L
.27458 .13428 L
.27459 .0893 L
.27461 .136 L
.27462 .12066 L
.27463 .09839 L
.27465 .09794 L
.27466 .10553 L
.27467 .11976 L
.27469 .13444 L
.2747 .12038 L
.27471 .07788 L
.27473 .11926 L
.27474 .1209 L
.27475 .11927 L
.27477 .09922 L
.27478 .11522 L
.2748 .11884 L
.27481 .12413 L
.27483 .08332 L
.27484 .13166 L
.27486 .12801 L
.27486 .1225 L
.27487 .16742 L
.27488 .10744 L
.27489 .08136 L
.2749 .13727 L
.27492 .15872 L
.27493 .13031 L
.27493 .12839 L
.27495 .08673 L
.27496 .09862 L
.27498 .0973 L
.27501 .09472 L
.27502 .157 L
.27503 .12957 L
.27505 .09681 L
.27506 .08978 L
.27508 .17414 L
.27509 .12387 L
.27509 .13347 L
.27511 .12252 L
.27512 .12074 L
.27513 .08819 L
.27514 .1093 L
.27516 .10702 L
.27516 .13223 L
Mistroke
.27517 .09987 L
.27518 .12391 L
.27519 .11543 L
.27521 .12457 L
.27521 .08717 L
.27522 .12395 L
.27524 .11459 L
.27525 .10135 L
.27525 .13102 L
.27527 .10036 L
.27528 .08051 L
.2753 .10127 L
.27531 .1299 L
.27533 .11516 L
.27534 .13813 L
.27535 .07786 L
.27537 .11492 L
.27538 .08519 L
.27539 .13728 L
.2754 .12066 L
.27541 .13588 L
.27543 .0881 L
.27544 .11717 L
.27546 .1335 L
.27547 .12498 L
.27548 .13083 L
.2755 .08634 L
.27551 .12901 L
.27552 .13047 L
.27554 .08813 L
.27555 .08713 L
.27556 .08235 L
.27557 .09632 L
.27558 .08428 L
.2756 .10149 L
.27561 .13928 L
.27562 .09077 L
.27563 .09362 L
.27564 .08394 L
.27565 .12604 L
.27566 .09402 L
.27567 .11234 L
.27568 .09088 L
.27569 .12181 L
.2757 .08007 L
.27571 .15707 L
.27573 .14957 L
.27574 .10592 L
.27576 .10757 L
.27577 .17356 L
Mistroke
.27579 .13214 L
.2758 .13191 L
.27581 .09176 L
.27582 .11642 L
.27583 .13571 L
.27584 .11718 L
.27585 .12788 L
.27586 .09421 L
.27588 .12266 L
.27589 .08688 L
.27591 .10649 L
.27592 .11403 L
.27592 .13856 L
.27593 .12782 L
.27594 .18457 L
.27595 .09732 L
.27596 .10324 L
.27597 .13108 L
.27598 .11479 L
.27599 .15434 L
.276 .11086 L
.27601 .13538 L
.27602 .12979 L
.27603 .10711 L
.27604 .13058 L
.27606 .13316 L
.27606 .11155 L
.27607 .10451 L
.27609 .12677 L
.2761 .108 L
.27612 .11686 L
.27613 .13679 L
.27614 .15626 L
.27616 .10423 L
.27617 .1203 L
.27617 .10304 L
.27618 .17163 L
.27619 .08006 L
.27621 .11979 L
.27621 .10862 L
.27622 .0929 L
.27624 .10373 L
.27625 .09797 L
.27627 .14531 L
.27628 .09921 L
.2763 .10508 L
.27631 .13294 L
.27631 .10362 L
.27633 .10911 L
.27634 .1467 L
Mistroke
.27636 .10022 L
.27637 .08523 L
.27638 .14644 L
.2764 .1261 L
.27641 .13108 L
.27642 .1161 L
.27643 .08141 L
.27644 .11714 L
.27645 .15327 L
.27646 .09856 L
.27648 .14492 L
.27649 .14253 L
.27651 .1221 L
.27652 .13603 L
.27653 .14301 L
.27655 .12791 L
.27656 .1055 L
.27657 .14445 L
.27658 .12582 L
.2766 .17558 L
.27661 .09607 L
.27663 .10897 L
.27664 .15615 L
.27665 .09041 L
.27667 .08819 L
.27668 .12401 L
.2767 .10664 L
.27671 .11712 L
.27673 .09659 L
.27674 .10325 L
.27675 .07253 L
.27676 .12622 L
.27677 .1367 L
.27679 .10662 L
.2768 .14603 L
.2768 .10864 L
.27682 .12381 L
.27683 .11121 L
.27684 .10266 L
.27685 .14916 L
.27686 .09293 L
.27688 .0932 L
.27689 .1541 L
.27691 .1323 L
.27692 .13424 L
.27694 .11519 L
.27695 .08656 L
.27696 .12923 L
.27698 .13646 L
.27699 .11061 L
Mistroke
.27701 .10957 L
.27701 .13088 L
.27702 .1354 L
.27704 .13013 L
.27705 .09824 L
.27707 .08864 L
.27708 .10005 L
.2771 .13052 L
.2771 .11597 L
.27711 .15138 L
.27713 .1293 L
.27714 .11421 L
.27715 .15104 L
.27715 .13347 L
.27716 .09437 L
.27717 .11752 L
.27718 .11654 L
.27719 .15044 L
.2772 .13546 L
.27721 .111 L
.27723 .10656 L
.27724 .11093 L
.27725 .09716 L
.27726 .15561 L
.27727 .09853 L
.27729 .1118 L
.2773 .13278 L
.27731 .09901 L
.27733 .07397 L
.27734 .12392 L
.27736 .12518 L
.27736 .12039 L
.27737 .08957 L
.27739 .1345 L
.2774 .15542 L
.27741 .13094 L
.27742 .11323 L
.27744 .14586 L
.27745 .1224 L
.27746 .14831 L
.27748 .08925 L
.27749 .1087 L
.2775 .08365 L
.27751 .09151 L
.27753 .08343 L
.27754 .09964 L
.27756 .10237 L
.27757 .14675 L
.27758 .10736 L
.2776 .14574 L
Mistroke
.27761 .08714 L
.27763 .11457 L
.27764 .1394 L
.27766 .14618 L
.27767 .09147 L
.27768 .075 L
.2777 .12295 L
.27771 .12783 L
.27772 .13063 L
.27773 .13741 L
.27774 .11243 L
.27775 .12309 L
.27776 .07807 L
.27778 .15137 L
.27778 .11414 L
.27779 .07953 L
.27781 .09921 L
.27782 .14303 L
.27784 .09663 L
.27785 .10377 L
.27787 .13743 L
.27788 .11683 L
.27789 .11331 L
.2779 .15759 L
.27792 .12457 L
.27793 .13942 L
.27795 .13672 L
.27796 .10364 L
.27797 .14858 L
.27798 .09949 L
.278 .0857 L
.27801 .10126 L
.27802 .11117 L
.27804 .17067 L
.27805 .14365 L
.27806 .12543 L
.27807 .14725 L
.27808 .09733 L
.27809 .13229 L
.2781 .15136 L
.27811 .06726 L
.27811 .12936 L
.27812 .13527 L
.27813 .04319 L
.27814 .08897 L
.27815 .12425 L
.27817 .15179 L
.27818 .14059 L
.2782 .11394 L
.27822 .12747 L
Mistroke
.27823 .08849 L
.27824 .09568 L
.27826 .08774 L
.27827 .12166 L
.27828 .10606 L
.2783 .08088 L
.27831 .10047 L
.27833 .14855 L
.27834 .11842 L
.27836 .13542 L
.27837 .1209 L
.27838 .12182 L
.27839 .13354 L
.27841 .10028 L
.27842 .08225 L
.27843 .11485 L
.27845 .14171 L
.27846 .11898 L
.27847 .11583 L
.27848 .14051 L
.2785 .10166 L
.27851 .13334 L
.27852 .1013 L
.27854 .12828 L
.27855 .13974 L
.27857 .13135 L
.27859 .11641 L
.27861 .0757 L
.27862 .09067 L
.27863 .09384 L
.27864 .16375 L
.27866 .12408 L
.27867 .11557 L
.27868 .11906 L
.2787 .14858 L
.27871 .10184 L
.27873 .1028 L
.27874 .10148 L
.27875 .13408 L
.27876 .12709 L
.27878 .13251 L
.27879 .14861 L
.2788 .11667 L
.27882 .11676 L
.27883 .12889 L
.27884 .12437 L
.27886 .12204 L
.27887 .11133 L
.27888 .14553 L
.27889 .14353 L
Mistroke
.2789 .10344 L
.27892 .09995 L
.27893 .12148 L
.27893 .08049 L
.27895 .11216 L
.27897 .13633 L
.27898 .15249 L
.27898 .1478 L
.27899 .153 L
.279 .07294 L
.27902 .1447 L
.27903 .09288 L
.27904 .11255 L
.27905 .08391 L
.27906 .13911 L
.27908 .11599 L
.27909 .11225 L
.27911 .08998 L
.27912 .07454 L
.27914 .12893 L
.27914 .07995 L
.27915 .09258 L
.27917 .13364 L
.27918 .10785 L
.27918 .09424 L
.27919 .14507 L
.2792 .14892 L
.27922 .11858 L
.27923 .10945 L
.27923 .11471 L
.27925 .10511 L
.27926 .13933 L
.27927 .13942 L
.27928 .18178 L
.27929 .10544 L
.27931 .1053 L
.27932 .1459 L
.27934 .148 L
.27935 .0872 L
.27937 .11242 L
.27938 .14377 L
.2794 .10761 L
.27941 .13778 L
.27942 .13827 L
.27943 .0713 L
.27944 .08422 L
.27945 .12905 L
.27947 .11462 L
.27948 .11754 L
.27949 .08995 L
Mistroke
.27951 .13936 L
.27952 .10099 L
.27953 .14462 L
.27955 .12273 L
.27956 .12585 L
.27958 .10937 L
.27959 .15882 L
.27961 .10148 L
.27962 .13361 L
.27963 .1373 L
.27965 .13646 L
.27966 .17292 L
.27966 .11206 L
.27968 .10739 L
.27969 .11416 L
.27971 .09643 L
.27972 .10203 L
.27973 .12206 L
.27974 .09838 L
.27976 .09217 L
.27977 .12973 L
.27979 .08895 L
.2798 .11041 L
.27982 .11669 L
.27982 .10227 L
.27983 .13132 L
.27985 .10514 L
.27986 .14495 L
.27987 .1403 L
.27988 .08678 L
.27989 .08565 L
.2799 .10467 L
.27991 .15633 L
.27992 .12047 L
.27993 .11117 L
.27994 .15545 L
.27995 .12779 L
.27996 .1103 L
.27998 .08365 L
.27999 .10114 L
.28001 .12928 L
.28002 .16728 L
.28003 .11879 L
.28005 .10828 L
.28006 .13298 L
.28006 .10981 L
.28008 .09534 L
.2801 .12888 L
.2801 .12868 L
.28011 .12861 L
Mistroke
.28013 .09579 L
.28014 .0883 L
.28016 .1377 L
.28017 .08687 L
.28018 .16103 L
.28019 .14046 L
.2802 .15298 L
.2802 .10633 L
.28022 .14674 L
.28023 .13433 L
.28024 .15926 L
.28025 .15803 L
.28026 .11788 L
.28027 .15102 L
.28028 .10804 L
.28029 .09246 L
.28029 .12282 L
.2803 .07884 L
.28032 .09608 L
.28033 .14467 L
.28035 .0617 L
.28036 .13141 L
.28038 .1387 L
.28039 .12621 L
.2804 .14019 L
.28042 .13786 L
.28043 .13227 L
.28043 .14945 L
.28045 .11482 L
.28046 .12117 L
.28048 .10191 L
.28049 .11868 L
.2805 .10141 L
.28051 .12508 L
.28052 .13091 L
.28053 .09077 L
.28054 .11178 L
.28054 .13934 L
.28056 .10951 L
.28057 .15028 L
.28058 .13025 L
.28059 .10191 L
.2806 .08777 L
.28062 .14671 L
.28063 .1034 L
.28064 .11737 L
.28066 .16923 L
.28067 .12088 L
.28068 .08524 L
.28069 .11963 L
Mistroke
.28071 .12153 L
.28072 .08454 L
.28072 .09041 L
.28074 .10315 L
.28075 .12923 L
.28077 .12632 L
.28078 .12295 L
.28079 .10087 L
.28081 .15393 L
.28082 .12494 L
.28084 .12729 L
.28085 .14032 L
.28087 .1292 L
.28088 .11433 L
.28089 .12326 L
.28091 .15322 L
.28092 .1066 L
.28093 .13105 L
.28095 .11428 L
.28096 .10526 L
.28098 .13796 L
.28099 .11733 L
.281 .11411 L
.28102 .15106 L
.28103 .12094 L
.28104 .08099 L
.28105 .16523 L
.28106 .08987 L
.28107 .13596 L
.28108 .17549 L
.28109 .1426 L
.2811 .09078 L
.28111 .11422 L
.28113 .11412 L
.28114 .09721 L
.28115 .14752 L
.28117 .15199 L
.28118 .10843 L
.2812 .16157 L
.28121 .14305 L
.28122 .09496 L
.28124 .12595 L
.28125 .11001 L
.28127 .15376 L
.28128 .12795 L
.28128 .15381 L
.2813 .0906 L
.28131 .08154 L
.28133 .13597 L
.28134 .12553 L
Mistroke
.28136 .08708 L
.28137 .14051 L
.28137 .11888 L
.28139 .13048 L
.2814 .11983 L
.28141 .08549 L
.28142 .12059 L
.28143 .09192 L
.28143 .1402 L
.28144 .10615 L
.28145 .1302 L
.28146 .1137 L
.28147 .09939 L
.28149 .12791 L
.2815 .11835 L
.28151 .13679 L
.28152 .14146 L
.28153 .08271 L
.28155 .12861 L
.28156 .09115 L
.28157 .12817 L
.28159 .11548 L
.2816 .08574 L
.28162 .13874 L
.28163 .12452 L
.28163 .11809 L
.28165 .10773 L
.28166 .0915 L
.28167 .11485 L
.28168 .10953 L
.2817 .09237 L
.28171 .12564 L
.28172 .10858 L
.28174 .13027 L
.28175 .15361 L
.28176 .10379 L
.28178 .17145 L
.28179 .09559 L
.2818 .13675 L
.28182 .12414 L
.28183 .15913 L
.28185 .11052 L
.28186 .13239 L
.28187 .12373 L
.28189 .13829 L
.2819 .11306 L
.28192 .12526 L
.28193 .12501 L
.28194 .12188 L
.28196 .13663 L
Mistroke
.28197 .11991 L
.28198 .12515 L
.28199 .09529 L
.282 .15092 L
.28201 .13172 L
.28202 .12463 L
.28204 .13286 L
.28205 .12741 L
.28207 .12062 L
.28208 .13728 L
.28209 .11806 L
.28211 .10844 L
.28212 .11247 L
.28214 .10232 L
.28215 .11315 L
.28217 .14302 L
.28218 .1191 L
.28219 .11778 L
.28221 .10586 L
.28222 .13408 L
.28224 .11661 L
.28225 .11663 L
.28226 .12459 L
.28227 .13746 L
.28229 .10844 L
.28229 .14166 L
.2823 .06023 L
.28231 .09296 L
.28232 .14852 L
.28233 .11172 L
.28234 .12364 L
.28235 .0928 L
.28236 .11744 L
.28237 .10908 L
.28238 .09444 L
.28238 .09266 L
.28239 .13605 L
.2824 .12081 L
.28241 .11326 L
.28243 .14915 L
.28244 .07107 L
.28246 .12335 L
.28248 .08379 L
.28249 .09798 L
.2825 .08634 L
.28252 .12324 L
.28253 .11548 L
.28254 .10446 L
.28256 .10003 L
.28257 .11886 L
Mistroke
.28259 .08916 L
.2826 .1489 L
.28262 .11554 L
.28263 .09127 L
.28264 .11481 L
.28265 .12849 L
.28266 .13807 L
.28268 .13998 L
.28269 .13126 L
.28271 .16036 L
.28272 .13688 L
.28273 .11245 L
.28274 .12178 L
.28276 .1154 L
.28277 .12866 L
.28278 .16624 L
.2828 .10991 L
.28281 .1538 L
.28282 .10764 L
.28284 .12254 L
.28285 .11708 L
.28286 .16036 L
.28287 .16391 L
.28288 .07349 L
.2829 .09925 L
.28291 .12674 L
.28293 .13589 L
.28294 .15813 L
.28296 .09797 L
.28297 .14145 L
.28298 .10077 L
.283 .13229 L
.28301 .13592 L
.28303 .13063 L
.28304 .14953 L
.28306 .07509 L
.28307 .1329 L
.28308 .12382 L
.28309 .13535 L
.2831 .13013 L
.28312 .0985 L
.28313 .12934 L
.28315 .13236 L
.28316 .12553 L
.28317 .15682 L
.28319 .13807 L
.2832 .11581 L
.28321 .14834 L
.28323 .0822 L
.28324 .13125 L
Mistroke
.28325 .09379 L
.28327 .15829 L
.28328 .14489 L
.28329 .14331 L
.2833 .10115 L
.28331 .12516 L
.28332 .10552 L
.28334 .15204 L
.28335 .11783 L
.28336 .10209 L
.28337 .1002 L
.28338 .07099 L
.2834 .11144 L
.28341 .13975 L
.28342 .10108 L
.28344 .11475 L
.28345 .10383 L
.28347 .08995 L
.28348 .14403 L
.28348 .08885 L
.2835 .11598 L
.28351 .14466 L
.28352 .1011 L
.28353 .17503 L
.28355 .15719 L
.28356 .10885 L
.28358 .10738 L
.28359 .09506 L
.2836 .13303 L
.28362 .13396 L
.28363 .09249 L
.28364 .14462 L
.28365 .11397 L
.28367 .13451 L
.28368 .09779 L
.2837 .11422 L
.28371 .12617 L
.28372 .1453 L
.28374 .08301 L
.28375 .09745 L
.28377 .13977 L
.28378 .11541 L
.2838 .10712 L
.28381 .15273 L
.28383 .09548 L
.28383 .11765 L
.28384 .09312 L
.28385 .09886 L
.28386 .11498 L
.28387 .09438 L
Mistroke
.28389 .11145 L
.28389 .1293 L
.2839 .11572 L
.28392 .14667 L
.28393 .08624 L
.28394 .12003 L
.28396 .13504 L
.28397 .14324 L
.28399 .12499 L
.284 .07631 L
.28401 .14212 L
.28403 .10565 L
.28405 .0956 L
.28406 .15479 L
.28407 .11262 L
.28408 .1529 L
.28409 .0789 L
.28411 .1147 L
.28412 .15038 L
.28414 .11901 L
.28415 .10178 L
.28416 .16459 L
.28417 .08923 L
.28418 .15262 L
.28419 .09563 L
.2842 .13184 L
.28421 .12765 L
.28422 .11767 L
.28423 .14508 L
.28423 .11342 L
.28424 .11256 L
.28425 .1324 L
.28427 .13107 L
.28428 .13412 L
.2843 .1394 L
.28431 .14592 L
.28432 .15974 L
.28434 .15866 L
.28435 .08649 L
.28437 .15691 L
.28438 .14771 L
.28439 .11651 L
.28441 .12578 L
.28442 .11507 L
.28444 .1185 L
.28445 .12465 L
.28447 .12147 L
.28448 .11718 L
.28448 .09325 L
.2845 .10034 L
Mistroke
.28452 .11098 L
.28453 .10229 L
.28454 .11755 L
.28456 .11838 L
.28457 .12852 L
.28458 .148 L
.28459 .14794 L
.28461 .13312 L
.28462 .14519 L
.28463 .09654 L
.28465 .10417 L
.28468 .11604 L
.28468 .10503 L
.28469 .12702 L
.28471 .13397 L
.28472 .15071 L
.28473 .11732 L
.28475 .11282 L
.28476 .15533 L
.28478 .11929 L
.28479 .12205 L
.28481 .09806 L
.28481 .11124 L
.28482 .10668 L
.28484 .12513 L
.28485 .11439 L
.28486 .09235 L
.28488 .12312 L
.28489 .15871 L
.2849 .10723 L
.28492 .10087 L
.28493 .14729 L
.28495 .08909 L
.28496 .09187 L
.28498 .10311 L
.28498 .13665 L
.28499 .08844 L
.28501 .09822 L
.28502 .09442 L
.28503 .14118 L
.28504 .10372 L
.28505 .13531 L
.28506 .06077 L
.28507 .0948 L
.28508 .14425 L
.28509 .08601 L
.2851 .1142 L
.28511 .14644 L
.28512 .12105 L
.28513 .12905 L
Mistroke
.28515 .11642 L
.28516 .11449 L
.28518 .10075 L
.28519 .11096 L
.28521 .09173 L
.28522 .12593 L
.28523 .15596 L
.28524 .13774 L
.28525 .12688 L
.28526 .11264 L
.28527 .13604 L
.28528 .10292 L
.2853 .10369 L
.28532 .12997 L
.28533 .08388 L
.28534 .14549 L
.28535 .0975 L
.28536 .07816 L
.28536 .10339 L
.28538 .116 L
.28539 .15303 L
.2854 .12158 L
.28541 .14173 L
.28543 .1216 L
.28544 .16599 L
.28545 .11375 L
.28545 .10922 L
.28546 .10239 L
.28547 .10804 L
.28548 .1218 L
.28549 .13944 L
.28551 .09561 L
.28552 .08175 L
.28554 .12707 L
.28555 .1028 L
.28555 .13203 L
.28556 .14597 L
.28557 .12664 L
.28558 .09983 L
.28559 .11274 L
.2856 .07246 L
.28562 .12287 L
.28563 .08756 L
.28564 .10221 L
.28566 .08536 L
.28567 .14474 L
.28568 .15061 L
.28569 .12369 L
.2857 .14892 L
.28572 .13777 L
Mistroke
.28573 .10389 L
.28575 .12104 L
.28576 .13505 L
.28578 .12331 L
.28579 .17642 L
.28581 .10376 L
.28582 .15024 L
.28583 .1194 L
.28584 .13827 L
.28586 .09377 L
.28587 .09036 L
.28588 .12474 L
.2859 .14388 L
.28591 .1369 L
.28592 .09751 L
.28594 .09883 L
.28606 .10766 L
.28607 .1107 L
.28607 .12127 L
.28608 .13286 L
.28609 .10877 L
.2861 .09972 L
.28611 .11393 L
.28612 .1171 L
.28612 .11376 L
.28614 .1011 L
.28615 .13599 L
.28616 .11884 L
.28617 .15565 L
.28619 .10576 L
.2862 .13778 L
.28621 .10858 L
.28622 .1228 L
.28623 .07275 L
.28625 .1082 L
.28625 .13212 L
.28626 .11308 L
.28628 .13197 L
.28629 .12785 L
.28629 .07546 L
.2863 .10278 L
.28631 .11904 L
.28633 .11622 L
.28634 .12646 L
.28634 .08959 L
.28636 .1578 L
.28637 .10354 L
.28639 .12639 L
.2864 .12053 L
.28641 .09766 L
Mistroke
.28643 .11053 L
.28644 .08072 L
.28646 .13102 L
.28647 .11202 L
.28649 .09968 L
.2865 .09536 L
.28651 .12237 L
.28652 .12336 L
.28654 .09859 L
.28655 .12503 L
.28657 .1217 L
.28658 .12018 L
.28659 .11184 L
.2866 .11291 L
.28661 .10624 L
.28663 .14678 L
.28664 .10479 L
.28665 .10934 L
.28666 .15365 L
.28667 .1312 L
.28668 .10309 L
.2867 .12674 L
.28671 .14105 L
.28672 .11945 L
.28673 .12291 L
.28675 .10652 L
.28675 .1301 L
.28676 .12105 L
.28678 .06073 L
.28679 .09733 L
.2868 .14061 L
.28682 .11487 L
.28683 .11823 L
.28685 .08889 L
.28686 .09967 L
.28688 .07426 L
.28689 .13311 L
.2869 .16311 L
.2869 .11835 L
.28692 .16176 L
.28694 .12621 L
.28694 .14351 L
.28695 .12551 L
.28697 .1247 L
.28698 .1037 L
.287 .12897 L
.28701 .07895 L
.28702 .12636 L
.28703 .11668 L
.28704 .16228 L
Mistroke
.28704 .12263 L
.28706 .11066 L
.28707 .11449 L
.28708 .13612 L
.28709 .15834 L
.28711 .09801 L
.28711 .12556 L
.28712 .11344 L
.28713 .09338 L
.28714 .1329 L
.28716 .12233 L
.28717 .09725 L
.28718 .14649 L
.2872 .08011 L
.28721 .14481 L
.28722 .10332 L
.28724 .12046 L
.28725 .10641 L
.28727 .10948 L
.28728 .13597 L
.28729 .07842 L
.2873 .14269 L
.28731 .12186 L
.28732 .16457 L
.28733 .12089 L
.28735 .11449 L
.28736 .12122 L
.28737 .14817 L
.28739 .12397 L
.2874 .11121 L
.28741 .10206 L
.28742 .11418 L
.28744 .12736 L
.28745 .10811 L
.28747 .08319 L
.28748 .11242 L
.28749 .14569 L
.28751 .13068 L
.28752 .13514 L
.28754 .11218 L
.28755 .12482 L
.28757 .08338 L
.28758 .14546 L
.28759 .15359 L
.28761 .11769 L
.28762 .15253 L
.28763 .11469 L
.28764 .10725 L
.28765 .10547 L
.28766 .05451 L
Mistroke
.28767 .13245 L
.28769 .14154 L
.28769 .09819 L
.2877 .14307 L
.28772 .12559 L
.28773 .11649 L
.28774 .1078 L
.28776 .14834 L
.28777 .15327 L
.28779 .12981 L
.2878 .13616 L
.28781 .1183 L
.28783 .12722 L
.28784 .10183 L
.28786 .14016 L
.28787 .0805 L
.28788 .11729 L
.28789 .1174 L
.28791 .10132 L
.28792 .14622 L
.28793 .10644 L
.28795 .12862 L
.28796 .10717 L
.28797 .13644 L
.28798 .07914 L
.28799 .10797 L
.288 .1127 L
.28801 .12643 L
.28802 .08212 L
.28802 .13181 L
.28803 .11648 L
.28804 .11809 L
.28805 .11375 L
.28806 .11231 L
.28808 .11217 L
.28809 .11902 L
.2881 .12699 L
.28811 .14603 L
.28812 .10985 L
.28814 .10519 L
.28815 .11632 L
.28817 .13331 L
.28818 .14399 L
.28819 .12526 L
.28821 .09599 L
.28822 .12987 L
.28822 .11346 L
.28824 .15559 L
.28825 .13598 L
.28826 .1167 L
Mistroke
.28827 .11781 L
.28829 .10482 L
.2883 .14002 L
.28832 .08589 L
.28833 .13594 L
.28834 .13322 L
.28836 .08463 L
.28837 .11484 L
.28839 .10501 L
.2884 .10612 L
.28842 .11276 L
.28843 .1157 L
.28844 .1088 L
.28846 .156 L
.28847 .09867 L
.28848 .13853 L
.2885 .11155 L
.28851 .08583 L
.28852 .09615 L
.28854 .15565 L
.28855 .16691 L
.28857 .14057 L
.28857 .11259 L
.28858 .13062 L
.28859 .1204 L
.2886 .11301 L
.28861 .14291 L
.28863 .15097 L
.28864 .08232 L
.28866 .13406 L
.28867 .11309 L
.28869 .12721 L
.2887 .13835 L
.28871 .14554 L
.28873 .079 L
.28874 .13279 L
.28876 .1089 L
.28877 .08613 L
.28878 .08151 L
.2888 .12346 L
.28881 .11259 L
.28883 .12252 L
.28884 .07951 L
.28885 .1422 L
.28886 .15353 L
.28888 .13771 L
.28888 .14614 L
.28889 .11147 L
.2889 .12664 L
.28891 .12777 L
Mistroke
.28892 .17186 L
.28893 .13493 L
.28894 .1317 L
.28895 .10054 L
.28896 .11772 L
.28897 .14187 L
.28898 .11886 L
.28898 .11369 L
.28899 .12971 L
.28901 .13533 L
.28902 .14917 L
.28904 .15187 L
.28905 .15359 L
.28907 .13883 L
.28908 .1474 L
.28909 .12878 L
.28911 .13915 L
.28912 .10482 L
.28913 .13167 L
.28915 .10506 L
.28916 .12975 L
.28918 .0979 L
.28919 .1484 L
.28921 .12388 L
.28922 .08861 L
.28923 .1574 L
.28924 .10969 L
.28926 .14772 L
.28927 .13131 L
.28928 .12097 L
.2893 .12495 L
.28931 .10007 L
.28932 .13572 L
.28934 .11363 L
.28935 .11016 L
.28936 .13069 L
.28937 .09511 L
.28939 .12358 L
.2894 .11507 L
.28942 .10946 L
.28943 .11249 L
.28944 .13888 L
.28945 .13585 L
.28946 .10956 L
.28948 .13593 L
.28949 .11421 L
.28951 .14826 L
.28952 .12897 L
.28953 .13257 L
.28955 .12212 L
Mistroke
.28956 .11928 L
.28958 .14466 L
.28959 .11668 L
.2896 .1562 L
.28962 .08928 L
.28963 .13387 L
.28965 .11106 L
.28966 .15008 L
.28967 .13154 L
.28968 .10548 L
.2897 .1204 L
.28971 .12917 L
.28972 .12537 L
.28974 .12977 L
.28975 .09277 L
.28977 .0921 L
.28978 .13356 L
.28979 .13638 L
.2898 .11443 L
.28982 .11453 L
.28983 .09562 L
.28984 .14547 L
.28986 .1512 L
.28987 .10701 L
.28989 .13466 L
.28989 .13564 L
.2899 .14697 L
.28992 .0827 L
.28993 .14063 L
.28994 .16181 L
.28995 .10578 L
.28996 .11678 L
.28997 .11487 L
.28999 .12477 L
.29 .06983 L
.29002 .08285 L
.29003 .1036 L
.29004 .12847 L
.29006 .11759 L
.29007 .12587 L
.29007 .11417 L
.29009 .12205 L
.2901 .09794 L
.29011 .0998 L
.29012 .08646 L
.29014 .14824 L
.29015 .13899 L
.29017 .13304 L
.29018 .08639 L
.29019 .12047 L
Mistroke
.2902 .09144 L
.29022 .11994 L
.29023 .15074 L
.29025 .12581 L
.29026 .12201 L
.29027 .13045 L
.29029 .10868 L
.2903 .1234 L
.29031 .12061 L
.29033 .11214 L
.29034 .15779 L
.29036 .15077 L
.29037 .09565 L
.29039 .10795 L
.2904 .13167 L
.29042 .11063 L
.29042 .17862 L
.29043 .12041 L
.29044 .08489 L
.29045 .11784 L
.29046 .14375 L
.29048 .09244 L
.29049 .11609 L
.29051 .14165 L
.29052 .10279 L
.29054 .11916 L
.29055 .11886 L
.29056 .08043 L
.29058 .15347 L
.29059 .14149 L
.29061 .12415 L
.29062 .0945 L
.29063 .10241 L
.29065 .09303 L
.29066 .12572 L
.29068 .10108 L
.29069 .12885 L
.2907 .10264 L
.29071 .12109 L
.29073 .10202 L
.29073 .15029 L
.29074 .13788 L
.29076 .14264 L
.29077 .08688 L
.29077 .10078 L
.29078 .14166 L
.29079 .11734 L
.2908 .12759 L
.29081 .14957 L
.29082 .14589 L
Mistroke
.29083 .11209 L
.29083 .0965 L
.29084 .12076 L
.29086 .05705 L
.29087 .09259 L
.29089 .11965 L
.2909 .11282 L
.29092 .11185 L
.29093 .13297 L
.29094 .10121 L
.29096 .12839 L
.29097 .11273 L
.29098 .16568 L
.291 .14557 L
.29101 .11921 L
.29103 .11346 L
.29104 .09905 L
.29105 .11772 L
.29106 .12581 L
.29107 .15958 L
.29108 .12455 L
.29109 .14565 L
.29111 .05004 L
.29112 .12798 L
.29113 .08322 L
.29115 .12195 L
.29116 .13861 L
.29118 .1049 L
.29119 .12836 L
.2912 .09062 L
.29122 .14289 L
.29123 .10832 L
.29125 .11402 L
.29126 .14819 L
.29127 .13637 L
.29129 .10825 L
.2913 .12895 L
.29131 .14129 L
.29133 .1003 L
.29134 .12685 L
.29135 .1398 L
.29137 .10883 L
.29138 .13195 L
.2914 .12359 L
.29141 .10081 L
.29142 .07844 L
.29143 .09658 L
.29144 .14353 L
.29146 .16628 L
.29147 .09352 L
Mistroke
.29147 .12593 L
.29148 .13467 L
.29149 .12166 L
.2915 .15268 L
.29151 .14127 L
.29152 .12537 L
.29153 .09158 L
.29154 .12532 L
.29155 .14126 L
.29157 .10828 L
.29158 .14919 L
.29159 .1161 L
.29161 .15166 L
.29162 .12739 L
.29164 .0958 L
.29165 .14863 L
.29167 .11534 L
.29168 .1517 L
.29169 .11347 L
.29171 .13925 L
.29172 .10045 L
.29173 .12138 L
.29175 .11594 L
.29176 .16199 L
.29177 .13549 L
.29179 .12869 L
.2918 .14006 L
.29182 .11048 L
.29183 .12311 L
.29183 .12108 L
.29185 .15487 L
.29186 .13303 L
.29188 .14619 L
.29189 .10807 L
.29191 .10314 L
.29192 .13836 L
.29193 .13338 L
.29194 .11802 L
.29195 .14359 L
.29196 .11734 L
.29197 .14928 L
.29198 .12144 L
.29199 .16825 L
.29201 .12812 L
.29202 .09847 L
.29202 .14 L
.29203 .12926 L
.29204 .12085 L
.29206 .0927 L
.29207 .11917 L
Mistroke
.29208 .14149 L
.29209 .16346 L
.2921 .1342 L
.29212 .1056 L
.29213 .12612 L
.29214 .16419 L
.29216 .13094 L
.29217 .14003 L
.29217 .14229 L
.29219 .13953 L
.2922 .15394 L
.2922 .08678 L
.29221 .12627 L
.29222 .1178 L
.29224 .11472 L
.29225 .17607 L
.29227 .13773 L
.29227 .07544 L
.29228 .12055 L
.2923 .11899 L
.29231 .15756 L
.29233 .1187 L
.29234 .12988 L
.29235 .11078 L
.29236 .10406 L
.29237 .15413 L
.29239 .16264 L
.2924 .09168 L
.29241 .12496 L
.29243 .12609 L
.29244 .11435 L
.29245 .11841 L
.29247 .10893 L
.29248 .17114 L
.2925 .10866 L
.29251 .12255 L
.29253 .13513 L
.29253 .14464 L
.29254 .09243 L
.29256 .10122 L
.29257 .12867 L
.29258 .0878 L
.29259 .09975 L
.2926 .11665 L
.29261 .10386 L
.29262 .12479 L
.29263 .13621 L
.29264 .09981 L
.29265 .13686 L
.29267 .08649 L
Mistroke
.29268 .10191 L
.2927 .11222 L
.29271 .13296 L
.29272 .144 L
.29273 .11049 L
.29274 .13106 L
.29275 .13201 L
.29276 .10451 L
.29277 .13628 L
.29279 .07576 L
.2928 .13008 L
.29282 .12377 L
.29282 .13791 L
.29283 .10976 L
.29285 .132 L
.29286 .16336 L
.29288 .1272 L
.29289 .14194 L
.2929 .12393 L
.29292 .12482 L
.29293 .15744 L
.29295 .11085 L
.29296 .09819 L
.29297 .11806 L
.29299 .12222 L
.293 .13169 L
.29301 .08044 L
.29302 .12761 L
.29304 .12829 L
.29305 .11129 L
.29306 .12969 L
.29307 .17384 L
.29308 .14491 L
.29309 .10855 L
.2931 .11956 L
.2931 .13034 L
.29312 .15022 L
.29313 .11006 L
.29315 .15589 L
.29316 .10112 L
.29318 .13983 L
.29319 .13823 L
.2932 .16351 L
.29321 .14818 L
.29322 .10081 L
.29324 .16196 L
.29325 .16176 L
.29326 .08037 L
.29327 .15993 L
.29328 .13445 L
Mistroke
.2933 .13029 L
.29331 .13847 L
.29332 .13452 L
.29334 .11265 L
.29335 .13517 L
.29337 .15171 L
.29338 .11689 L
.29338 .12767 L
.2934 .13643 L
.29341 .11837 L
.29342 .11958 L
.29343 .08972 L
.29345 .13919 L
.29346 .12311 L
.29347 .1101 L
.29349 .11091 L
.2935 .12004 L
.29351 .13007 L
.29353 .09529 L
.29354 .11044 L
.29355 .12296 L
.29357 .11972 L
.29358 .11971 L
.2936 .1291 L
.29361 .13868 L
.29362 .12546 L
.29364 .15178 L
.29365 .17609 L
.29366 .12355 L
.29368 .1381 L
.29369 .10923 L
.29371 .13021 L
.29373 .07489 L
.29373 .10908 L
.29374 .09114 L
.29375 .11794 L
.29376 .09377 L
.29377 .12772 L
.29379 .11691 L
.29379 .11431 L
.2938 .1274 L
.29382 .0897 L
.29383 .1626 L
.29385 .11203 L
.29386 .14828 L
.29388 .15678 L
.29389 .12972 L
.2939 .11042 L
.29392 .09789 L
.29393 .1326 L
Mistroke
.29395 .14448 L
.29396 .16296 L
.29397 .11381 L
.29398 .10699 L
.29399 .15355 L
.29401 .10723 L
.29402 .14274 L
.29404 .1148 L
.29405 .12046 L
.29406 .10742 L
.29407 .08536 L
.29408 .14873 L
.29409 .10484 L
.2941 .13847 L
.29411 .12255 L
.29412 .08943 L
.29413 .14144 L
.29413 .12328 L
.29414 .12497 L
.29415 .10629 L
.29417 .15534 L
.29418 .14502 L
.2942 .12522 L
.29421 .08811 L
.29423 .14342 L
.29424 .16142 L
.29425 .15135 L
.29427 .11628 L
.29428 .10199 L
.29429 .12486 L
.29431 .08443 L
.29432 .15928 L
.29434 .11754 L
.29435 .09713 L
.29437 .1608 L
.29438 .10431 L
.29439 .11971 L
.2944 .12106 L
.29442 .0932 L
.29443 .12452 L
.29444 .09942 L
.29446 .16741 L
.29447 .1179 L
.29448 .13482 L
.2945 .09889 L
.29451 .11229 L
.29452 .12025 L
.29454 .12777 L
.29455 .1082 L
.29456 .16711 L
Mistroke
.29458 .13687 L
.29459 .11033 L
.2946 .12475 L
.29461 .13251 L
.29462 .11624 L
.29464 .14835 L
.29465 .07129 L
.29467 .13231 L
.29468 .12099 L
.2947 .09359 L
.29471 .1667 L
.29472 .12927 L
.29474 .12965 L
.29475 .12872 L
.29476 .12756 L
.29478 .13082 L
.29479 .13847 L
.29481 .12724 L
.29482 .11813 L
.29483 .15744 L
.29484 .10591 L
.29485 .08694 L
.29486 .13003 L
.29487 .13401 L
.29488 .11239 L
.2949 .09657 L
.29491 .1389 L
.29493 .12669 L
.29494 .13722 L
.29496 .13067 L
.29497 .11641 L
.29499 .14469 L
.295 .11579 L
.29501 .12161 L
.29503 .15085 L
.29504 .15141 L
.29505 .11573 L
.29506 .10489 L
.29508 .15677 L
.29509 .10814 L
.29511 .17459 L
.29511 .14684 L
.29512 .08792 L
.29514 .13065 L
.29515 .10913 L
.29516 .10923 L
.29518 .15157 L
.29519 .0917 L
.2952 .09506 L
.29522 .0842 L
Mistroke
.29523 .17251 L
.29524 .14887 L
.29525 .13253 L
.29526 .12229 L
.29527 .13717 L
.29528 .15652 L
.2953 .14285 L
.29531 .15427 L
.29533 .15785 L
.29534 .10202 L
.29535 .08725 L
.29537 .13186 L
.29538 .08608 L
.29539 .1493 L
.29541 .14115 L
.29542 .15532 L
.29543 .10425 L
.29545 .14462 L
.29546 .13895 L
.29548 .13815 L
.29549 .11656 L
.2955 .11197 L
.29552 .09769 L
.29553 .15717 L
.29555 .15751 L
.29556 .11873 L
.29558 .1721 L
.29558 .11486 L
.29559 .13087 L
.2956 .13252 L
.29561 .11098 L
.29563 .10368 L
.29564 .07031 L
.29565 .14079 L
.29567 .10098 L
.29568 .12968 L
.2957 .13364 L
.29571 .13846 L
.29572 .1239 L
.29574 .11633 L
.29575 .10354 L
.29577 .13768 L
.29578 .12635 L
.2958 .14277 L
.29581 .13364 L
.29583 .09881 L
.29584 .09531 L
.29586 .12078 L
.29586 .11314 L
.29587 .14151 L
Mistroke
.29588 .10812 L
.29589 .13705 L
.2959 .13971 L
.29591 .08698 L
.29592 .16551 L
.29594 .12189 L
.29594 .12221 L
.29595 .11081 L
.29596 .11766 L
.29597 .10525 L
.29598 .12925 L
.29599 .15494 L
.296 .13826 L
.296 .15042 L
.29602 .08926 L
.29603 .11655 L
.29605 .10491 L
.29606 .12633 L
.29608 .10822 L
.29609 .13414 L
.29611 .13705 L
.29612 .09475 L
.29613 .10393 L
.29615 .14011 L
.29616 .13117 L
.29618 .10731 L
.29619 .13161 L
.2962 .14261 L
.29622 .17851 L
.29623 .11394 L
.29624 .15129 L
.29625 .10139 L
.29627 .09122 L
.29628 .14494 L
.29629 .17698 L
.29631 .13624 L
.29632 .12225 L
.29634 .17746 L
.29635 .12 L
.29636 .14402 L
.29637 .14241 L
.29639 .12944 L
.2964 .10004 L
.29642 .14732 L
.29643 .12537 L
.29644 .1127 L
.29645 .13397 L
.29646 .14248 L
.29647 .13578 L
.29649 .13723 L
Mistroke
.2965 .11275 L
.29652 .11224 L
.29653 .16184 L
.29655 .11861 L
.29656 .06398 L
.29657 .08217 L
.29659 .11066 L
.2966 .15891 L
.29662 .11395 L
.29663 .13705 L
.29665 .16427 L
.29666 .10572 L
.29668 .13366 L
.29668 .1115 L
.29669 .13867 L
.29671 .13106 L
.29672 .0955 L
.29674 .1259 L
.29675 .0996 L
.29676 .08634 L
.29678 .08478 L
.29679 .13328 L
.2968 .15002 L
.29682 .07417 L
.29683 .09542 L
.29684 .10518 L
.29686 .11364 L
.29687 .13412 L
.29688 .10502 L
.2969 .11194 L
.29691 .08264 L
.29691 .11058 L
.29693 .1211 L
.29694 .10292 L
.29696 .1411 L
.29697 .08149 L
.29697 .09314 L
.29699 .08414 L
.297 .11718 L
.29702 .07512 L
.29703 .11336 L
.29704 .13491 L
.29706 .13341 L
.29706 .13267 L
.29707 .10944 L
.29709 .12973 L
.2971 .11491 L
.29711 .13909 L
.29712 .11538 L
.29713 .10257 L
Mistroke
.29715 .08896 L
.29716 .07446 L
.29718 .14009 L
.29719 .09569 L
.2972 .15081 L
.29722 .11182 L
.29723 .13531 L
.29724 .1353 L
.29726 .11177 L
.29727 .11001 L
.29729 .12056 L
.2973 .1443 L
.29731 .12257 L
.29733 .12957 L
.29734 .15516 L
.29736 .10984 L
.29737 .13184 L
.29738 .10244 L
.2974 .08031 L
.29741 .12158 L
.29743 .0986 L
.29744 .13828 L
.29744 .11277 L
.29745 .08345 L
.29746 .10417 L
.29748 .08794 L
.29749 .12473 L
.29751 .1302 L
.29752 .12921 L
.29763 .12201 L
.29765 .11424 L
.29766 .12102 L
.29768 .12282 L
.29769 .15681 L
.29771 .09237 L
.29772 .10086 L
.29772 .09914 L
.29774 .15536 L
.29775 .11276 L
.29776 .094 L
.29777 .12111 L
.29779 .11483 L
.29779 .13844 L
.2978 .10418 L
.29781 .07423 L
.29782 .16215 L
.29784 .12161 L
.29785 .09636 L
.29786 .12612 L
.29787 .07944 L
Mistroke
.29788 .12579 L
.29788 .19547 L
.2979 .12142 L
.29791 .08166 L
.29792 .14562 L
.29793 .1202 L
.29794 .12353 L
.29796 .14934 L
.29797 .10954 L
.29798 .09334 L
.298 .1187 L
.29801 .10927 L
.29802 .07725 L
.29803 .14074 L
.29805 .11156 L
.29805 .09082 L
.29806 .08152 L
.29808 .13285 L
.29809 .13298 L
.29811 .12431 L
.29812 .12313 L
.29813 .11369 L
.29815 .11086 L
.29816 .13891 L
.29817 .10746 L
.29819 .12367 L
.2982 .14325 L
.29822 .10928 L
.29823 .12402 L
.29824 .09511 L
.29825 .13567 L
.29827 .09525 L
.29828 .1377 L
.2983 .12133 L
.29831 .13784 L
.29833 .08891 L
.29834 .13916 L
.29836 .11029 L
.29837 .14133 L
.29838 .07152 L
.29839 .09768 L
.2984 .07825 L
.29841 .09862 L
.29842 .06793 L
.29843 .11547 L
.29844 .16817 L
.29845 .13848 L
.29847 .09676 L
.29848 .1035 L
.29849 .12693 L
Mistroke
.29851 .05963 L
.29852 .11638 L
.29854 .13068 L
.29855 .12069 L
.29856 .12371 L
.29858 .15503 L
.29859 .16247 L
.29861 .14883 L
.29862 .13585 L
.29862 .12195 L
.29864 .14721 L
.29865 .10467 L
.29867 .12418 L
.29868 .11844 L
.2987 .17453 L
.29871 .10826 L
.29871 .10202 L
.29873 .12268 L
.29874 .11093 L
.29875 .16608 L
.29876 .13012 L
.29877 .12622 L
.29877 .1281 L
.29878 .12716 L
.29879 .10579 L
.2988 .16343 L
.29881 .11924 L
.29883 .13809 L
.29884 .09691 L
.29885 .13401 L
.29886 .08462 L
.29887 .0943 L
.29889 .1002 L
.2989 .08516 L
.29891 .12106 L
.29893 .13206 L
.29894 .09777 L
.29896 .11376 L
.29897 .09772 L
.29897 .14171 L
.29899 .14929 L
.299 .11912 L
.29901 .1397 L
.29902 .10428 L
.29904 .13705 L
.29905 .13237 L
.29906 .11874 L
.29908 .14508 L
.29909 .16198 L
.2991 .11124 L
Mistroke
.29912 .13364 L
.29913 .12389 L
.29914 .10251 L
.29916 .09763 L
.29917 .1119 L
.29918 .13648 L
.2992 .1018 L
.29921 .14899 L
.29923 .16176 L
.29924 .13513 L
.29926 .10756 L
.29927 .14973 L
.29928 .12257 L
.2993 .11279 L
.29931 .10534 L
.29932 .10984 L
.29933 .15805 L
.29934 .11472 L
.29935 .1439 L
.29936 .1081 L
.29938 .11438 L
.29939 .13803 L
.29941 .12176 L
.29942 .14823 L
.29943 .14716 L
.29945 .10192 L
.29946 .16284 L
.29947 .12823 L
.29949 .12269 L
.29951 .12414 L
.29952 .06542 L
.29953 .11022 L
.29955 .10966 L
.29956 .10217 L
.29958 .1577 L
.29959 .14287 L
.29961 .12812 L
.29962 .12626 L
.29963 .1401 L
.29964 .0934 L
.29966 .10875 L
.29967 .08092 L
.29967 .11063 L
.29968 .14998 L
.29969 .1338 L
.2997 .11531 L
.29971 .13211 L
.29972 .10888 L
.29974 .14977 L
.29975 .11027 L
Mistroke
.29975 .12122 L
.29977 .1068 L
.29978 .15193 L
.2998 .07975 L
.29981 .08893 L
.29983 .12592 L
.29984 .14153 L
.29985 .14602 L
.29987 .12927 L
.29988 .13149 L
.29989 .12967 L
.2999 .07623 L
.29991 .07616 L
.29992 .14173 L
.29993 .14415 L
.29994 .15775 L
.29995 .11878 L
.29996 .08253 L
.29998 .11243 L
.29999 .12267 L
.30001 .12603 L
.30002 .12707 L
.30003 .11164 L
.30004 .09109 L
.30005 .14543 L
.30006 .11382 L
.30007 .11806 L
.30008 .09773 L
.3001 .11358 L
.30011 .10175 L
.30013 .12937 L
.30014 .14977 L
.30015 .10727 L
.30015 .12567 L
.30016 .09008 L
.30018 .11803 L
.30019 .1152 L
.30021 .13041 L
.30022 .13022 L
.30023 .11079 L
.30023 .13295 L
.30024 .11804 L
.30025 .14432 L
.30026 .13854 L
.30028 .13476 L
.30029 .10842 L
.3003 .09903 L
.30031 .13486 L
.30032 .1358 L
.30032 .1094 L
Mistroke
.30034 .13866 L
.30035 .13723 L
.30036 .12465 L
.30037 .09716 L
.30038 .12557 L
.3004 .12531 L
.30041 .08135 L
.30043 .15361 L
.30044 .11271 L
.30046 .11196 L
.30047 .12155 L
.30048 .08181 L
.3005 .12922 L
.30051 .08615 L
.30053 .12692 L
.30054 .12713 L
.30054 .11135 L
.30056 .14354 L
.30057 .1207 L
.30059 .0922 L
.3006 .0993 L
.30062 .09419 L
.30063 .11001 L
.30063 .15149 L
.30065 .13596 L
.30066 .10505 L
.30067 .14553 L
.30068 .12569 L
.30069 .0945 L
.3007 .15848 L
.30072 .10828 L
.30072 .12931 L
.30073 .09367 L
.30074 .11812 L
.30075 .13531 L
.30076 .11678 L
.30077 .10035 L
.30078 .1102 L
.30079 .11437 L
.30081 .14332 L
.30082 .12433 L
.30084 .10619 L
.30085 .11641 L
.30086 .13703 L
.30088 .08474 L
.30089 .13472 L
.3009 .10889 L
.30091 .10955 L
.30092 .11357 L
.30093 .1078 L
Mistroke
.30094 .14681 L
.30096 .1607 L
.30097 .11785 L
.30099 .10302 L
.301 .12668 L
.30101 .10139 L
.30103 .13976 L
.30104 .13005 L
.30105 .12975 L
.30107 .11649 L
.30108 .11962 L
.30109 .14005 L
.30111 .11214 L
.30112 .09365 L
.30113 .13623 L
.30115 .1419 L
.30116 .10355 L
.30118 .13362 L
.30119 .15123 L
.30121 .13176 L
.30122 .15008 L
.30124 .11228 L
.30124 .09649 L
.30125 .11041 L
.30126 .09861 L
.30127 .09943 L
.30129 .11563 L
.3013 .10999 L
.30131 .15233 L
.30131 .09792 L
.30133 .15778 L
.30134 .16783 L
.30136 .09954 L
.30137 .14024 L
.30139 .11494 L
.3014 .12825 L
.30141 .13675 L
.30143 .12223 L
.30144 .0925 L
.30146 .11709 L
.30147 .13637 L
.30148 .1715 L
.30149 .10152 L
.3015 .11813 L
.30152 .14944 L
.30153 .09678 L
.30155 .09301 L
.30156 .13425 L
.30157 .08162 L
.30158 .11395 L
Mistroke
.30159 .10566 L
.3016 .11556 L
.30161 .11534 L
.30162 .12213 L
.30163 .17866 L
.30164 .11286 L
.30165 .09691 L
.30166 .1302 L
.30166 .11994 L
.30168 .08929 L
.30169 .09332 L
.30171 .12947 L
.30172 .10827 L
.30172 .11871 L
.30174 .11329 L
.30175 .13188 L
.30177 .13266 L
.30178 .15445 L
.30179 .11831 L
.30181 .102 L
.30182 .14833 L
.30183 .12264 L
.30184 .18297 L
.30185 .1228 L
.30186 .17543 L
.30187 .11835 L
.30189 .12404 L
.3019 .14998 L
.30192 .15708 L
.30193 .09459 L
.30194 .13424 L
.30196 .09967 L
.30197 .12316 L
.30198 .11686 L
.30199 .09717 L
.30201 .11449 L
.30202 .12991 L
.30204 .13675 L
.30205 .14182 L
.30206 .11782 L
.30208 .15017 L
.3021 .09211 L
.30211 .1449 L
.30212 .09064 L
.30214 .14712 L
.30215 .14359 L
.30217 .17341 L
.30218 .15833 L
.30219 .13345 L
.3022 .09929 L
Mistroke
.3022 .1088 L
.30221 .0879 L
.30223 .1444 L
.30224 .13318 L
.30226 .14583 L
.30227 .09466 L
.30229 .16176 L
.3023 .11223 L
.30231 .13833 L
.30233 .10215 L
.30234 .14959 L
.30236 .1084 L
.30237 .14653 L
.30238 .11896 L
.3024 .11599 L
.30241 .10942 L
.30243 .10496 L
.30244 .09809 L
.30245 .08695 L
.30246 .11495 L
.30247 .10125 L
.30248 .11519 L
.30249 .13344 L
.3025 .13813 L
.30251 .11735 L
.30252 .09357 L
.30253 .10901 L
.30254 .17149 L
.30255 .1067 L
.30257 .08228 L
.30258 .11416 L
.30259 .15634 L
.3026 .14215 L
.30264 .11374 L
.30265 .12023 L
.30266 .08291 L
.30268 .10577 L
.30269 .13976 L
.30271 .13687 L
.30271 .13572 L
.30272 .09229 L
.30274 .08314 L
.30275 .099 L
.30276 .13928 L
.30277 .13993 L
.30278 .13941 L
.30279 .14005 L
.3028 .14825 L
.30281 .1344 L
.30282 .11115 L
Mistroke
.30283 .14917 L
.30284 .14393 L
.30286 .1272 L
.30288 .1063 L
.30289 .13489 L
.3029 .1277 L
.30292 .13439 L
.30293 .07854 L
.30294 .12725 L
.30295 .10472 L
.30297 .13304 L
.30298 .14405 L
.303 .10387 L
.30301 .12942 L
.30302 .09617 L
.30304 .10787 L
.30305 .11303 L
.30307 .1156 L
.30307 .12257 L
.30308 .12917 L
.3031 .16569 L
.30311 .1377 L
.30313 .15242 L
.30314 .08506 L
.30315 .12753 L
.30317 .11512 L
.30318 .16591 L
.30319 .13171 L
.3032 .13799 L
.30322 .14974 L
.30323 .12208 L
.30324 .10206 L
.30326 .13088 L
.30327 .13296 L
.30329 .08961 L
.3033 .12863 L
.30331 .12489 L
.30333 .13912 L
.30334 .11076 L
.30335 .12183 L
.30336 .12012 L
.30337 .11416 L
.30338 .12618 L
.30339 .12097 L
.3034 .13035 L
.30342 .14588 L
.30343 .12764 L
.30345 .05668 L
.30346 .11184 L
.30346 .10685 L
Mistroke
.30347 .13648 L
.30348 .10857 L
.30349 .10914 L
.30351 .15874 L
.30352 .11915 L
.30353 .09194 L
.30354 .13867 L
.30355 .12759 L
.30356 .12542 L
.30357 .14433 L
.30358 .10382 L
.30359 .07318 L
.3036 .1386 L
.30362 .12175 L
.30363 .16978 L
.30365 .13226 L
.30366 .05087 L
.30367 .12678 L
.30369 .11304 L
.3037 .09278 L
.30371 .12833 L
.30371 .14537 L
.30372 .13124 L
.30373 .0938 L
.30374 .14034 L
.30375 .06577 L
.30377 .10548 L
.30378 .11026 L
.30379 .11836 L
.3038 .10362 L
.30381 .15674 L
.30382 .13486 L
.30383 .14021 L
.30384 .10133 L
.30385 .1224 L
.30386 .10834 L
.30388 .14319 L
.30389 .13206 L
.30389 .12872 L
.30391 .12184 L
.30392 .11727 L
.30393 .09499 L
.30394 .11799 L
.30394 .13616 L
.30396 .12342 L
.30397 .11647 L
.30398 .14414 L
.30399 .12421 L
.304 .10758 L
.30401 .13534 L
Mistroke
.30402 .16585 L
.30404 .10567 L
.30405 .12549 L
.30407 .12784 L
.30408 .10772 L
.3041 .14161 L
.30411 .11908 L
.30412 .13317 L
.30413 .183 L
.30414 .10446 L
.30414 .12395 L
.30415 .09727 L
.30416 .13211 L
.30417 .11241 L
.30418 .11578 L
.30419 .15305 L
.30421 .10512 L
.30422 .14139 L
.30422 .11038 L
.30424 .14031 L
.30426 .1276 L
.30427 .11444 L
.30428 .13052 L
.3043 .09636 L
.30431 .12975 L
.30433 .11364 L
.30434 .12532 L
.30436 .16893 L
.30436 .11814 L
.30437 .12936 L
.30439 .12247 L
.3044 .09461 L
.30442 .11708 L
.30443 .1222 L
.30444 .13032 L
.30445 .1107 L
.30447 .1236 L
.30448 .10684 L
.3045 .1087 L
.30451 .14117 L
.30452 .10628 L
.30454 .10759 L
.30455 .15956 L
.30456 .12114 L
.30458 .12613 L
.30459 .0922 L
.30461 .12929 L
.30462 .10501 L
.30463 .11068 L
.30465 .1118 L
Mistroke
.30466 .20008 L
.30467 .14728 L
.30468 .1272 L
.30469 .11411 L
.30471 .11382 L
.30472 .1225 L
.30473 .08248 L
.30474 .12796 L
.30475 .09503 L
.30476 .11128 L
.30477 .12735 L
.30477 .11335 L
.30479 .1004 L
.3048 .1512 L
.30481 .1804 L
.30482 .12931 L
.30483 .11554 L
.30484 .13328 L
.30485 .13018 L
.30486 .12547 L
.30487 .12286 L
.30488 .0852 L
.30489 .12927 L
.3049 .10707 L
.30491 .09027 L
.30492 .11144 L
.30493 .15166 L
.30494 .11477 L
.30495 .12788 L
.30496 .10457 L
.30497 .1505 L
.30498 .08879 L
.305 .08806 L
.30501 .13505 L
.30503 .14218 L
.30504 .08001 L
.30506 .15222 L
.30507 .10589 L
.30508 .13011 L
.3051 .15387 L
.30511 .11315 L
.30511 .1423 L
.30513 .14558 L
.30514 .12883 L
.30516 .10321 L
.30517 .14616 L
.30518 .1091 L
.3052 .10686 L
.30521 .12723 L
.30522 .08836 L
Mistroke
.30524 .10535 L
.30525 .16551 L
.30527 .08225 L
.30527 .09822 L
.30528 .12245 L
.3053 .11123 L
.30531 .06205 L
.30532 .13463 L
.30533 .08351 L
.30534 .10161 L
.30535 .12204 L
.30536 .11963 L
.30537 .13702 L
.30538 .09227 L
.30539 .11811 L
.3054 .08875 L
.30541 .16635 L
.30543 .12925 L
.30544 .12627 L
.30546 .09833 L
.30547 .11822 L
.30548 .11104 L
.3055 .07586 L
.30551 .11935 L
.30552 .13922 L
.30553 .11607 L
.30555 .10486 L
.30555 .12618 L
.30556 .13971 L
.30558 .12867 L
.30559 .06726 L
.30561 .10713 L
.30562 .09075 L
.30563 .13059 L
.30564 .0964 L
.30565 .14403 L
.30565 .11074 L
.30567 .10611 L
.30568 .1469 L
.30569 .16436 L
.3057 .09916 L
.30572 .13032 L
.30573 .16057 L
.30574 .14606 L
.30574 .09604 L
.30575 .15853 L
.30576 .09899 L
.30577 .09768 L
.30578 .14907 L
.3058 .15932 L
Mistroke
.30581 .10741 L
.30583 .16565 L
.30584 .10612 L
.30585 .13159 L
.30585 .12917 L
.30586 .13695 L
.30587 .14404 L
.30588 .10698 L
.30589 .11367 L
.30591 .13859 L
.30592 .09599 L
.30593 .1015 L
.30595 .15059 L
.30596 .09816 L
.30597 .07497 L
.30598 .10058 L
.30599 .10563 L
.30601 .14197 L
.30602 .1134 L
.30603 .14071 L
.30604 .13857 L
.30605 .11236 L
.30607 .1059 L
.30608 .11393 L
.3061 .12865 L
.30611 .13501 L
.30612 .14219 L
.30613 .11095 L
.30614 .13421 L
.30616 .11054 L
.30617 .11435 L
.30617 .09689 L
.30619 .08141 L
.3062 .10254 L
.30622 .08961 L
.30623 .11326 L
.30624 .14741 L
.30626 .09246 L
.30627 .13589 L
.30628 .10706 L
.3063 .09697 L
.30631 .09359 L
.30632 .16003 L
.30634 .14372 L
.30635 .10868 L
.30636 .14537 L
.30638 .10802 L
.30639 .16359 L
.30641 .11506 L
.30642 .15001 L
Mistroke
.30644 .14124 L
.30645 .09054 L
.30647 .10309 L
.30648 .13416 L
.30649 .13653 L
.3065 .10757 L
.30651 .11339 L
.30651 .1384 L
.30653 .12647 L
.30654 .14925 L
.30655 .1146 L
.30656 .13639 L
.30657 .15122 L
.30659 .11736 L
.3066 .11281 L
.30662 .1307 L
.30663 .14356 L
.30665 .09769 L
.30666 .13726 L
.30667 .12976 L
.30669 .11984 L
.3067 .108 L
.30672 .14294 L
.30672 .09762 L
.30673 .12412 L
.30675 .12458 L
.30676 .12373 L
.30678 .08979 L
.30679 .10449 L
.30681 .14489 L
.30681 .09958 L
.30682 .11713 L
.30684 .13647 L
.30685 .18657 L
.30686 .09251 L
.30686 .10743 L
.30687 .15227 L
.30688 .10047 L
.30689 .1021 L
.3069 .11386 L
.30691 .10127 L
.30692 .11717 L
.30694 .10839 L
.30695 .12622 L
.30697 .11174 L
.30698 .14526 L
.307 .1229 L
.30701 .11767 L
.30702 .13531 L
.30704 .11265 L
Mistroke
.30705 .11465 L
.30707 .12662 L
.30708 .09156 L
.3071 .10055 L
.30711 .11098 L
.30713 .11897 L
.30713 .103 L
.30714 .13239 L
.30716 .14417 L
.30717 .10522 L
.30719 .07843 L
.3072 .09723 L
.30721 .12872 L
.30723 .09291 L
.30724 .1441 L
.30725 .14918 L
.30727 .09907 L
.30728 .08191 L
.30729 .12745 L
.30731 .09326 L
.30732 .12084 L
.30733 .14158 L
.30735 .12626 L
.30736 .11806 L
.30736 .11472 L
.30738 .10455 L
.30739 .09795 L
.30741 .11439 L
.30742 .13076 L
.30744 .1247 L
.30745 .12277 L
.30746 .14707 L
.30748 .14725 L
.30749 .11513 L
.3075 .11893 L
.30751 .12823 L
.30752 .12761 L
.30754 .10945 L
.30755 .12008 L
.30757 .11175 L
.30758 .12321 L
.30759 .11086 L
.30761 .12401 L
.30762 .13841 L
.30763 .12966 L
.30765 .15325 L
.30766 .11519 L
.30767 .16861 L
.30768 .08497 L
.3077 .14054 L
Mistroke
.30771 .10245 L
.30772 .10442 L
.30774 .13523 L
.30775 .13217 L
.30776 .0977 L
.30777 .12688 L
.30778 .12818 L
.30779 .14002 L
.3078 .14358 L
.30781 .20732 L
.30782 .12438 L
.30784 .17623 L
.30785 .14761 L
.30786 .13864 L
.30787 .12081 L
.30788 .10814 L
.30789 .11052 L
.3079 .11176 L
.30791 .11426 L
.30792 .14638 L
.30793 .14625 L
.30795 .13274 L
.30796 .13124 L
.30797 .13666 L
.30799 .14292 L
.308 .09361 L
.30801 .12559 L
.30802 .11005 L
.30803 .13931 L
.30803 .1265 L
.30804 .12724 L
.30805 .11206 L
.30806 .15565 L
.30807 .1134 L
.30808 .13005 L
.30809 .11365 L
.30809 .13036 L
.30811 .08947 L
.30812 .07697 L
.30814 .12288 L
.30815 .10099 L
.30817 .15144 L
.30818 .1108 L
.3082 .15669 L
.30821 .14414 L
.30822 .09515 L
.30824 .12612 L
.30825 .10344 L
.30825 .17419 L
.30826 .1223 L
Mistroke
.30827 .17776 L
.30829 .11282 L
.3083 .18287 L
.3083 .13622 L
.30832 .14022 L
.30833 .09008 L
.30834 .12317 L
.30835 .15933 L
.30836 .15625 L
.30837 .11263 L
.30838 .16347 L
.3084 .14158 L
.30841 .12358 L
.30843 .10843 L
.30844 .13833 L
.30845 .11633 L
.30846 .07003 L
.30847 .11219 L
.30849 .08151 L
.3085 .10654 L
.30852 .09422 L
.30853 .09957 L
.30854 .13888 L
.30856 .09997 L
.30857 .13699 L
.30859 .13487 L
.3086 .12492 L
.30862 .112 L
.30863 .09069 L
.30864 .10032 L
.30865 .12856 L
.30866 .1297 L
.30868 .06847 L
.3087 .13356 L
.30871 .12954 L
.30872 .05614 L
.30874 .10785 L
.30875 .17823 L
.30876 .12066 L
.30877 .10927 L
.30879 .16198 L
.30879 .11072 L
.3088 .14622 L
.30882 .12305 L
.30883 .16546 L
.30884 .1337 L
.30884 .1027 L
.30885 .15612 L
.30887 .1476 L
.30888 .15439 L
Mistroke
.3089 .10259 L
.30891 .0929 L
.30893 .13447 L
.30894 .12593 L
.30895 .11515 L
.30897 .11664 L
.30898 .13098 L
.30898 .13652 L
.309 .11032 L
.30901 .11679 L
.30902 .11013 L
.30902 .12901 L
.30903 .14871 L
.30904 .08839 L
.30905 .08474 L
.30906 .0982 L
.30908 .11506 L
.30909 .13334 L
.30911 .12891 L
.30912 .10658 L
.30912 .12148 L
.30913 .11245 L
.30914 .12217 L
.30916 .10474 L
.30917 .13722 L
.30918 .1136 L
.3092 .09801 L
.30921 .12604 L
.30923 .12573 L
.30924 .14199 L
.30925 .13143 L
.30926 .07744 L
.30928 .14977 L
.30928 .07568 L
.30929 .10486 L
.3093 .14947 L
.30931 .07072 L
.30932 .1187 L
.30933 .17047 L
.30934 .16204 L
.30935 .15377 L
.30936 .11837 L
.30938 .11001 L
.30939 .1199 L
.3094 .15404 L
.30942 .13725 L
.30943 .09762 L
.30943 .14989 L
.30945 .12194 L
.30946 .12448 L
Mistroke
.30948 .14948 L
.30949 .15787 L
.3095 .07647 L
.30951 .12616 L
.30953 .12766 L
.30954 .10713 L
.30956 .09946 L
.30957 .10549 L
.30963 .12666 L
.30964 .07968 L
.30965 .13657 L
.30966 .16189 L
.30967 .14303 L
.30968 .15414 L
.30969 .13501 L
.3097 .12533 L
.30971 .11756 L
.30973 .11059 L
.30974 .11884 L
.30976 .11928 L
.30977 .1218 L
.30977 .12851 L
.30979 .11729 L
.30981 .16642 L
.30982 .16298 L
.30983 .11815 L
.30985 .1306 L
.30986 .10772 L
.30988 .1197 L
.30989 .12645 L
.3099 .11036 L
.30991 .10914 L
.30992 .10845 L
.30994 .15455 L
.30995 .10888 L
.30996 .16159 L
.30998 .17712 L
.30999 .10242 L
.31 .10834 L
.31002 .10972 L
.31003 .09937 L
.31004 .14228 L
.31006 .08869 L
.31007 .11355 L
.31008 .08327 L
.31009 .0877 L
.31011 .09227 L
.31011 .12849 L
.31012 .11663 L
.31014 .08563 L
Mistroke
.31015 .12773 L
.31015 .18076 L
.31016 .12662 L
.31017 .08123 L
.31019 .11446 L
.3102 .14779 L
.3102 .12416 L
.31022 .11321 L
.31024 .09899 L
.31025 .1165 L
.31026 .1273 L
.31028 .10151 L
.31029 .13317 L
.31031 .09201 L
.31032 .16838 L
.31032 .14317 L
.31034 .10547 L
.31035 .15291 L
.31036 .13016 L
.31037 .11917 L
.31038 .14688 L
.3104 .099 L
.31041 .0965 L
.31042 .11366 L
.31043 .12134 L
.31044 .11931 L
.31045 .14513 L
.31046 .07938 L
.31048 .12564 L
.31049 .09039 L
.3105 .11541 L
.31051 .14739 L
.31052 .10815 L
.31053 .14528 L
.31054 .14027 L
.31055 .10423 L
.31056 .11954 L
.31056 .1076 L
.31058 .16054 L
.31059 .12415 L
.31061 .12711 L
.31062 .12125 L
.31063 .10204 L
.31064 .10776 L
.31065 .11314 L
.31066 .11756 L
.31067 .15788 L
.31067 .11482 L
.31069 .12791 L
.3107 .13467 L
Mistroke
.31071 .17201 L
.31073 .09965 L
.31074 .12998 L
.31075 .11092 L
.31076 .14295 L
.31078 .11823 L
.31079 .11106 L
.3108 .09345 L
.31081 .10246 L
.31082 .0919 L
.31083 .10422 L
.31085 .1229 L
.31086 .13336 L
.31088 .12027 L
.31089 .10123 L
.3109 .13379 L
.31092 .11852 L
.31093 .10215 L
.31094 .09042 L
.31095 .16311 L
.31096 .16332 L
.31097 .12385 L
.31098 .13849 L
.311 .10788 L
.31101 .11003 L
.31103 .12785 L
.31104 .13116 L
.31105 .12224 L
.31107 .1217 L
.31108 .14281 L
.31109 .09667 L
.31111 .1143 L
.31112 .09463 L
.31113 .15157 L
.31115 .12295 L
.31116 .15238 L
.31118 .12507 L
.31119 .15195 L
.31121 .1548 L
.31122 .13076 L
.31123 .12723 L
.31125 .13067 L
.31126 .09246 L
.31126 .13013 L
.31128 .11288 L
.31129 .14009 L
.3113 .11959 L
.31131 .1342 L
.31133 .09804 L
.31134 .14897 L
Mistroke
.31135 .11276 L
.31136 .11567 L
.31137 .13051 L
.31139 .10264 L
.3114 .12791 L
.31142 .10818 L
.31143 .10224 L
.31144 .12694 L
.31146 .12213 L
.31147 .1235 L
.31148 .10468 L
.3115 .12741 L
.31151 .08789 L
.31152 .15386 L
.31153 .13923 L
.31155 .09692 L
.31156 .14836 L
.31158 .09801 L
.31159 .10513 L
.3116 .09491 L
.31161 .10917 L
.31162 .13017 L
.31164 .11769 L
.31165 .08168 L
.31165 .13453 L
.31166 .14805 L
.31167 .11537 L
.31168 .12851 L
.31169 .07591 L
.3117 .13756 L
.31171 .12108 L
.31172 .14604 L
.31174 .10557 L
.31175 .12539 L
.31176 .16897 L
.31177 .10818 L
.31178 .15129 L
.3118 .13404 L
.31181 .13752 L
.31182 .10198 L
.31184 .14998 L
.31185 .18574 L
.31187 .15571 L
.31187 .15799 L
.31188 .1284 L
.31189 .13842 L
.3119 .08824 L
.31191 .13803 L
.31193 .14457 L
.31194 .10851 L
Mistroke
.31196 .09733 L
.31197 .15249 L
.31199 .11773 L
.312 .16968 L
.31201 .12696 L
.31202 .1725 L
.31204 .119 L
.31205 .14388 L
.31207 .1062 L
.31208 .12237 L
.31209 .11089 L
.31211 .13893 L
.31212 .11957 L
.31213 .1084 L
.31215 .09702 L
.31217 .14348 L
.31218 .15037 L
.31219 .15299 L
.31221 .09993 L
.31222 .12368 L
.31223 .10513 L
.31224 .11 L
.31225 .13301 L
.31226 .11042 L
.31227 .11825 L
.31229 .14034 L
.31229 .14253 L
.3123 .18313 L
.31232 .09128 L
.31233 .11623 L
.31234 .14737 L
.31236 .12727 L
.31237 .10961 L
.31239 .09855 L
.3124 .11189 L
.31241 .08796 L
.31243 .15736 L
.31244 .11409 L
.31246 .12082 L
.31247 .13836 L
.31247 .12622 L
.31249 .12586 L
.31251 .14524 L
.31252 .1161 L
.31253 .14749 L
.31255 .14248 L
.31256 .08607 L
.31256 .0973 L
.31257 .14042 L
.31258 .09955 L
Mistroke
.31259 .12825 L
.3126 .12993 L
.31261 .1127 L
.31262 .1185 L
.31263 .10777 L
.31264 .13325 L
.31265 .12924 L
.31266 .13783 L
.31268 .15023 L
.31269 .1152 L
.3127 .16571 L
.31271 .10612 L
.31272 .12693 L
.31274 .14681 L
.31275 .12039 L
.31277 .14173 L
.31278 .12472 L
.31279 .16082 L
.31281 .113 L
.31282 .14417 L
.31282 .11918 L
.31284 .12616 L
.31285 .1005 L
.31286 .08493 L
.31287 .08915 L
.31289 .13088 L
.3129 .13835 L
.31292 .11075 L
.31293 .10196 L
.31294 .12359 L
.31295 .09869 L
.31297 .11891 L
.31298 .09307 L
.31299 .12433 L
.31301 .12439 L
.31302 .10783 L
.31304 .10486 L
.31305 .11441 L
.31306 .07831 L
.31308 .12075 L
.31309 .10295 L
.31311 .12303 L
.31312 .09984 L
.31314 .14939 L
.31315 .09625 L
.31316 .09636 L
.31317 .1307 L
.31318 .11999 L
.31319 .12778 L
.31321 .05811 L
Mistroke
.31322 .08727 L
.31324 .14347 L
.31325 .12014 L
.31326 .11145 L
.31328 .12325 L
.31329 .13061 L
.3133 .13417 L
.31331 .12353 L
.31332 .13054 L
.31333 .14741 L
.31334 .12926 L
.31336 .09767 L
.31337 .12349 L
.31338 .15415 L
.3134 .13609 L
.31341 .09262 L
.31343 .12179 L
.31344 .12168 L
.31345 .17203 L
.31346 .12789 L
.31348 .13138 L
.31349 .12187 L
.3135 .13095 L
.31351 .15011 L
.31352 .09397 L
.31354 .12112 L
.31355 .13119 L
.31356 .12551 L
.31358 .1009 L
.31359 .14859 L
.31361 .12238 L
.31361 .17869 L
.31362 .13256 L
.31364 .11778 L
.31365 .16092 L
.31366 .13668 L
.31367 .0996 L
.31369 .12908 L
.3137 .11566 L
.31371 .17959 L
.31372 .09695 L
.31373 .13164 L
.31374 .09788 L
.31375 .11873 L
.31376 .16113 L
.31376 .10048 L
.31377 .11487 L
.31378 .16321 L
.31379 .11075 L
.3138 .12917 L
Mistroke
.31381 .12621 L
.31382 .11488 L
.31383 .16918 L
.31384 .13551 L
.31385 .11195 L
.31386 .11728 L
.31388 .12252 L
.31389 .12352 L
.31391 .1185 L
.31392 .13516 L
.31393 .13462 L
.31395 .15247 L
.31396 .14331 L
.31397 .10461 L
.31398 .11079 L
.31399 .14287 L
.314 .10119 L
.31401 .11907 L
.31402 .11294 L
.31403 .08945 L
.31404 .13891 L
.31406 .11791 L
.31407 .13575 L
.31407 .11825 L
.31409 .09001 L
.3141 .13148 L
.3141 .10257 L
.31412 .12115 L
.31414 .1106 L
.31414 .12305 L
.31415 .1178 L
.31417 .11657 L
.31418 .14267 L
.31419 .10171 L
.3142 .12387 L
.31421 .13692 L
.31423 .11623 L
.31424 .11326 L
.31426 .12759 L
.31427 .13886 L
.31429 .107 L
.3143 .12087 L
.31431 .15374 L
.31433 .10613 L
.31434 .09095 L
.31436 .10939 L
.31436 .12776 L
.31437 .11112 L
.31439 .10648 L
.3144 .09917 L
Mistroke
.31442 .13122 L
.31443 .11988 L
.31445 .13045 L
.31445 .14684 L
.31446 .14756 L
.31447 .11418 L
.31448 .15091 L
.31449 .10751 L
.3145 .1293 L
.3145 .11524 L
.31451 .14249 L
.31453 .13699 L
.31454 .14987 L
.31455 .09549 L
.31456 .13801 L
.31458 .15469 L
.31459 .13006 L
.3146 .15309 L
.31461 .1177 L
.31462 .11403 L
.31464 .16044 L
.31465 .10723 L
.31466 .15987 L
.31468 .13179 L
.31469 .12116 L
.31471 .14326 L
.31472 .15028 L
.31472 .07653 L
.31474 .1156 L
.31475 .13558 L
.31476 .12998 L
.31477 .19824 L
.31479 .13997 L
.3148 .12152 L
.31481 .15692 L
.31483 .12828 L
.31484 .14785 L
.31485 .11718 L
.31487 .08989 L
.31488 .11385 L
.31489 .1345 L
.31491 .11623 L
.31492 .14811 L
.31493 .13696 L
.31495 .1368 L
.31496 .12512 L
.31498 .13162 L
.31499 .09501 L
.31501 .1418 L
.31502 .13532 L
Mistroke
.31503 .14813 L
.31505 .13311 L
.31506 .10863 L
.31507 .09813 L
.31508 .08079 L
.31509 .1618 L
.3151 .07778 L
.31511 .12398 L
.31513 .12067 L
.31513 .13051 L
.31514 .13015 L
.31516 .15732 L
.31517 .17593 L
.31519 .13179 L
.3152 .14141 L
.31522 .10594 L
.31523 .12031 L
.31524 .11174 L
.31526 .13559 L
.31527 .17913 L
.31529 .13307 L
.3153 .13085 L
.31531 .12434 L
.31532 .13569 L
.31533 .09857 L
.31535 .13184 L
.31536 .1306 L
.31538 .15224 L
.31539 .12816 L
.31541 .10147 L
.31541 .12683 L
.31542 .11179 L
.31544 .07586 L
.31545 .12558 L
.31546 .10663 L
.31547 .12761 L
.31548 .08814 L
.31549 .11342 L
.3155 .12579 L
.3155 .13942 L
.31551 .10891 L
.31552 .10316 L
.31554 .08985 L
.31554 .12967 L
.31555 .12302 L
.31557 .09107 L
.31558 .13678 L
.31559 .13504 L
.31561 .11488 L
.31562 .12005 L
Mistroke
.31564 .09913 L
.31565 .14479 L
.31566 .12757 L
.31567 .12434 L
.31568 .13294 L
.31569 .1735 L
.3157 .13922 L
.31571 .1442 L
.31573 .13898 L
.31574 .10845 L
.31576 .11578 L
.31577 .13072 L
.31578 .11169 L
.3158 .08262 L
.31581 .1004 L
.31582 .1361 L
.31584 .08037 L
.31585 .14852 L
.31586 .143 L
.31588 .08268 L
.31589 .09967 L
.31591 .09637 L
.31592 .11834 L
.31593 .12306 L
.31595 .09463 L
.31596 .10122 L
.31598 .1255 L
.31599 .09143 L
.31601 .10474 L
.31602 .16072 L
.31602 .11786 L
.31603 .10865 L
.31604 .07419 L
.31605 .08425 L
.31607 .11931 L
.31608 .08424 L
.3161 .13239 L
.31611 .141 L
.31613 .11765 L
.31614 .1763 L
.31615 .12688 L
.31617 .11448 L
.31618 .08752 L
.3162 .13117 L
.31621 .15673 L
.31623 .1187 L
.31624 .10221 L
.31626 .14032 L
.31627 .14225 L
.31629 .11282 L
Mistroke
.31629 .14835 L
.3163 .10687 L
.31632 .09123 L
.31633 .09192 L
.31633 .16103 L
.31634 .09652 L
.31635 .12489 L
.31637 .12042 L
.31637 .10501 L
.31638 .08277 L
.31639 .14253 L
.3164 .11985 L
.31641 .12637 L
.31642 .12422 L
.31643 .12482 L
.31643 .10442 L
.31645 .12649 L
.31646 .15286 L
.31648 .06966 L
.31649 .07601 L
.31651 .10953 L
.31652 .12871 L
.31654 .11627 L
.31655 .15748 L
.31656 .13272 L
.31658 .1157 L
.31659 .12527 L
.31661 .13578 L
.31662 .09543 L
.31663 .15619 L
.31665 .14328 L
.31666 .12814 L
.31667 .16921 L
.31668 .16119 L
.3167 .05879 L
.31671 .13445 L
.31672 .13315 L
.31674 .09731 L
.31675 .12801 L
.31676 .14856 L
.31678 .14743 L
.31679 .12553 L
.3168 .13546 L
.31682 .10555 L
.31683 .12987 L
.31684 .1622 L
.31686 .11303 L
.31687 .12828 L
.31688 .14433 L
.31689 .14552 L
Mistroke
.3169 .1131 L
.31692 .12042 L
.31693 .11545 L
.31695 .12672 L
.31696 .1427 L
.31698 .12443 L
.31699 .10865 L
.317 .13933 L
.31702 .10632 L
.31703 .14058 L
.31704 .13865 L
.31706 .14228 L
.31707 .09947 L
.31709 .10303 L
.3171 .10566 L
.31711 .11134 L
.31711 .14102 L
.31712 .12538 L
.31714 .10729 L
.31715 .11945 L
.31716 .15404 L
.31718 .14841 L
.31719 .13019 L
.31721 .07834 L
.31722 .13147 L
.31724 .10899 L
.31725 .13445 L
.31727 .12178 L
.31728 .10734 L
.31729 .13509 L
.31731 .11956 L
.31732 .13088 L
.31733 .13198 L
.31735 .15429 L
.31736 .13509 L
.31737 .13616 L
.31739 .09088 L
.31739 .09648 L
.3174 .08262 L
.31742 .11171 L
.31743 .10234 L
.31744 .11733 L
.31746 .11163 L
.31747 .17367 L
.31749 .13019 L
.3175 .14805 L
.31751 .14696 L
.31752 .11676 L
.31753 .17242 L
.31754 .12226 L
Mistroke
.31755 .08797 L
.31756 .14025 L
.31758 .1273 L
.31759 .14303 L
.31761 .14506 L
.31762 .09394 L
.31763 .11278 L
.31765 .1803 L
.31766 .10694 L
.31767 .13241 L
.31769 .12873 L
.3177 .14519 L
.31771 .12953 L
.31773 .14285 L
.31774 .09921 L
.31776 .09725 L
.31777 .14556 L
.31778 .13958 L
.3178 .12326 L
.31781 .09507 L
.31783 .14922 L
.31784 .12294 L
.31786 .10616 L
.31786 .13134 L
.31787 .11735 L
.31788 .10131 L
.31789 .15043 L
.3179 .14475 L
.31792 .15424 L
.31793 .10054 L
.31795 .12436 L
.31796 .12043 L
.31798 .14601 L
.31799 .11677 L
.318 .15779 L
.31802 .13533 L
.31803 .13314 L
.31805 .13514 L
.31806 .0813 L
.31808 .1147 L
.31809 .1304 L
.31811 .1485 L
.31812 .13826 L
.31814 .13467 L
.31814 .12867 L
.31815 .16695 L
.31817 .15444 L
.31818 .14342 L
.31819 .12393 L
.3182 .12727 L
Mistroke
.31821 .13654 L
.31822 .15928 L
.31823 .11426 L
.31824 .11513 L
.31825 .14176 L
.31827 .14701 L
.31828 .11037 L
.31829 .13823 L
.3183 .08826 L
.31831 .11645 L
.31833 .0943 L
.31834 .11722 L
.31836 .07592 L
.31837 .10405 L
.31838 .10703 L
.3184 .12624 L
.31841 .13562 L
.31843 .10985 L
.31843 .16503 L
.31844 .12704 L
.31845 .09255 L
.31846 .13566 L
.31847 .13912 L
.31848 .12322 L
.31849 .11143 L
.31851 .12381 L
.31852 .14286 L
.31854 .14237 L
.31855 .13971 L
.31856 .13199 L
.31857 .14122 L
.31858 .12736 L
.3186 .14586 L
.31861 .11833 L
.31861 .14052 L
.31863 .16048 L
.31864 .11411 L
.31866 .09095 L
.31867 .142 L
.31868 .08744 L
.31869 .15534 L
.3187 .07428 L
.3187 .13642 L
.31872 .11387 L
.31873 .13927 L
.31874 .14249 L
.31875 .10978 L
.31877 .09683 L
.31878 .13326 L
.31879 .0857 L
Mistroke
.31879 .11778 L
.3188 .11774 L
.31881 .1104 L
.31882 .13311 L
.31883 .12135 L
.31885 .14088 L
.31886 .16305 L
.31887 .13 L
.31888 .15248 L
.3189 .09653 L
.3189 .13439 L
.31891 .1668 L
.31893 .15923 L
.31894 .10454 L
.31895 .17367 L
.31897 .11747 L
.31898 .10451 L
.319 .10542 L
.319 .15371 L
.31901 .12567 L
.31902 .12145 L
.31904 .10129 L
.31905 .1542 L
.31906 .13379 L
.31906 .15545 L
.31907 .17605 L
.31909 .12214 L
.3191 .13289 L
.31911 .1512 L
.31912 .12447 L
.31914 .1408 L
.31914 .1001 L
.31915 .09324 L
.31916 .08196 L
.31917 .12852 L
.31918 .14279 L
.31919 .16704 L
.3192 .09697 L
.31922 .11777 L
.31923 .13594 L
.31923 .09916 L
.31925 .11446 L
.31926 .13637 L
.31928 .11395 L
.31929 .123 L
.31931 .10104 L
.31931 .14333 L
.31932 .14416 L
.31934 .12193 L
.31935 .14773 L
Mistroke
.31936 .13459 L
.31937 .10828 L
.31938 .12622 L
.31939 .14358 L
.31939 .13467 L
.3194 .12717 L
.31942 .12142 L
.31943 .11834 L
.31944 .09253 L
.31945 .12553 L
.31946 .07556 L
.31948 .16085 L
.31949 .08516 L
.31951 .16024 L
.31952 .19682 L
.31954 .1217 L
.31955 .16085 L
.31957 .09867 L
.31958 .10411 L
.31959 .11758 L
.3196 .14177 L
.31961 .15972 L
.31963 .15523 L
.31964 .18713 L
.31965 .12539 L
.31967 .13779 L
.31968 .10125 L
.31969 .10675 L
.3197 .17367 L
.31972 .12735 L
.31973 .17202 L
.31975 .06485 L
.31976 .11039 L
.31977 .15019 L
.31979 .09546 L
.3198 .11992 L
.31982 .13117 L
.31983 .13032 L
.31984 .10871 L
.31986 .136 L
.31987 .14169 L
.31988 .12211 L
.31989 .1355 L
.3199 .13375 L
.31991 .11113 L
.31992 .13998 L
.31993 .11818 L
.31994 .13965 L
.31995 .11225 L
.31997 .12983 L
Mistroke
.31998 .11143 L
.31999 .08849 L
.32 .15801 L
.32001 .07862 L
.32002 .11781 L
.32003 .12195 L
.32005 .12759 L
.32006 .10917 L
.32008 .14771 L
.32009 .13249 L
.32009 .14205 L
.3201 .14052 L
.32011 .12725 L
.32012 .14321 L
.32013 .1333 L
.32014 .13522 L
.32016 .12486 L
.32017 .09181 L
.32019 .09752 L
.3202 .13841 L
.3202 .1304 L
.32021 .12398 L
.32022 .13074 L
.32023 .14866 L
.32024 .14199 L
.32025 .13661 L
.32026 .13676 L
.32028 .14122 L
.32029 .14249 L
.32031 .09344 L
.32032 .17322 L
.32033 .14584 L
.32034 .13424 L
.32035 .12416 L
.32037 .14387 L
.32038 .10527 L
.32039 .14168 L
.32041 .09994 L
.32042 .13971 L
.32043 .14207 L
.32045 .10813 L
.32046 .11455 L
.32047 .12648 L
.32049 .09769 L
.3205 .16088 L
.32051 .12933 L
.32052 .10992 L
.32054 .13768 L
.32054 .12047 L
.32055 .09043 L
Mistroke
.32057 .09001 L
.32058 .11648 L
.32058 .11127 L
.32059 .17585 L
.3206 .13399 L
.32062 .15934 L
.32063 .12727 L
.32063 .09449 L
.32065 .12937 L
.32066 .12847 L
.32068 .12991 L
.32069 .11605 L
.32071 .13483 L
.32072 .12282 L
.32074 .09249 L
.32075 .1268 L
.32077 .10721 L
.32078 .10352 L
.3208 .11638 L
.32081 .13429 L
.32082 .15329 L
.32084 .14025 L
.32085 .12315 L
.32086 .13108 L
.32087 .12198 L
.32088 .14028 L
.3209 .13173 L
.3209 .08776 L
.32091 .12884 L
.32093 .15553 L
.32094 .143 L
.32095 .1364 L
.32095 .14363 L
.32096 .16962 L
.32098 .14546 L
.32099 .13905 L
.321 .14341 L
.32101 .1183 L
.32102 .09924 L
.32103 .12199 L
.32104 .13549 L
.32104 .11874 L
.32106 .07795 L
.32107 .10126 L
.32108 .17373 L
.32109 .14508 L
.32109 .13147 L
.32111 .135 L
.32112 .13699 L
.32113 .12517 L
Mistroke
.32114 .11888 L
.32115 .13108 L
.32116 .12999 L
.32117 .11915 L
.32119 .17363 L
.3212 .10656 L
.32122 .10698 L
.32123 .1407 L
.32125 .11806 L
.32126 .14806 L
.32127 .16758 L
.32129 .13269 L
.3213 .12734 L
.3213 .0926 L
.32132 .11494 L
.32133 .1536 L
.32135 .13715 L
.32136 .1146 L
.32137 .15484 L
.32139 .09523 L
.3214 .11844 L
.32141 .12722 L
.32143 .09149 L
.32144 .10013 L
.32147 .11475 L
.32148 .11713 L
.32149 .1212 L
.3215 .1329 L
.32151 .15945 L
.32152 .15049 L
.32153 .10723 L
.32154 .11822 L
.32155 .12996 L
.32156 .12385 L
.32157 .11554 L
.32159 .11247 L
.3216 .09571 L
.32161 .10553 L
.32163 .1303 L
.32164 .13384 L
.32165 .1228 L
.32166 .13027 L
.32168 .14876 L
.32169 .14475 L
.32171 .13386 L
.32172 .14856 L
.32173 .07653 L
.32174 .13027 L
.32175 .12855 L
.32176 .14261 L
Mistroke
.32177 .1189 L
.32178 .15915 L
.32178 .15891 L
.32179 .08997 L
.3218 .13523 L
.32182 .14406 L
.32183 .07016 L
.32184 .1168 L
.32185 .10441 L
.32186 .1359 L
.32188 .13865 L
.32189 .16102 L
.32191 .13658 L
.32192 .10497 L
.32193 .13527 L
.32195 .14453 L
.32196 .10246 L
.32198 .1432 L
.32199 .14888 L
.32199 .10702 L
.32201 .12501 L
.32202 .09149 L
.32204 .12919 L
.32205 .11651 L
.32206 .14429 L
.32208 .10639 L
.32209 .13429 L
.3221 .13718 L
.32212 .13062 L
.32213 .12687 L
.32214 .09958 L
.32216 .14206 L
.32217 .12137 L
.32219 .14585 L
.3222 .12412 L
.32222 .14456 L
.32223 .11103 L
.32224 .09787 L
.32226 .10606 L
.32227 .10122 L
.32228 .11582 L
.32229 .10101 L
.3223 .15157 L
.3223 .14635 L
.32232 .11236 L
.32233 .04827 L
.32234 .11717 L
.32235 .16501 L
.32237 .14389 L
.32238 .10581 L
Mistroke
.32239 .1805 L
.3224 .08944 L
.32241 .13015 L
.32242 .08698 L
.32243 .09675 L
.32244 .12093 L
.32246 .11404 L
.32247 .10796 L
.32248 .14005 L
.32249 .12243 L
.3225 .14654 L
.32251 .10124 L
.32252 .12753 L
.32253 .12132 L
.32254 .11702 L
.32256 .1203 L
.32257 .12919 L
.32258 .09191 L
.32259 .13246 L
.3226 .13132 L
.32261 .12886 L
.32262 .12502 L
.32263 .10423 L
.32264 .10606 L
.32265 .15981 L
.32266 .16185 L
.32267 .13161 L
.32268 .12362 L
.3227 .11391 L
.32271 .12188 L
.32274 .14412 L
.32276 .16912 L
.32277 .1186 L
.32278 .15883 L
.32279 .12287 L
.32281 .13522 L
.32282 .14443 L
.32283 .14295 L
.32285 .14575 L
.32286 .13135 L
.32287 .13005 L
.32288 .15818 L
.3229 .17427 L
.32291 .09961 L
.32292 .14383 L
.32294 .14217 L
.32295 .1215 L
.32296 .10035 L
.32298 .08584 L
.32299 .12832 L
Mistroke
.323 .13248 L
.32302 .13405 L
.32303 .13498 L
.32303 .13392 L
.32305 .10029 L
.32306 .16888 L
.32308 .12757 L
.32309 .07851 L
.3231 .18077 L
.32312 .16742 L
.32313 .09691 L
.32315 .12884 L
.32316 .13893 L
.32318 .08239 L
.32319 .12127 L
.3232 .13832 L
.32322 .12424 L
.32323 .13757 L
.32325 .10314 L
.32326 .09629 L
.32328 .17125 L
.32329 .1028 L
.32331 .17569 L
.32332 .15621 L
.32332 .1616 L
.32334 .13459 L
.32335 .15013 L
.32337 .10922 L
.32338 .14958 L
.3234 .14713 L
.32341 .10486 L
.32342 .10272 L
.32343 .12972 L
.32345 .15857 L
.32346 .12746 L
.32347 .13841 L
.32349 .18287 L
.3235 .11091 L
.32351 .15941 L
.32353 .129 L
.32354 .12094 L
.32355 .13741 L
.32356 .17079 L
.32357 .14431 L
.32359 .14564 L
.3236 .13776 L
.32363 .11577 L
.32365 .14407 L
.32366 .09137 L
.32367 .12869 L
Mistroke
.32369 .1619 L
.3237 .147 L
.32372 .10655 L
.32373 .10876 L
.32374 .09973 L
.32375 .13018 L
.32376 .11027 L
.32378 .09654 L
.32379 .13223 L
.32381 .11626 L
.32382 .15409 L
.32384 .09762 L
.32385 .12766 L
.32386 .13516 L
.32388 .15603 L
.32389 .14329 L
.32391 .11092 L
.32392 .13605 L
.32393 .09883 L
.32395 .12198 L
.32396 .12312 L
.32397 .11264 L
.32399 .10317 L
.324 .17204 L
.32401 .13567 L
.32403 .12783 L
.32404 .12252 L
.32406 .11654 L
.32407 .12736 L
.32409 .09054 L
.3241 .13438 L
.32411 .13565 L
.32413 .12974 L
.32414 .10659 L
.32415 .12934 L
.32416 .13645 L
.32417 .13353 L
.32418 .12286 L
.32419 .13813 L
.3242 .1459 L
.32421 .12856 L
.32422 .11646 L
.32424 .12189 L
.32425 .07251 L
.32427 .15875 L
.32428 .12521 L
.32429 .15893 L
.3243 .16002 L
.32431 .1164 L
.32432 .16473 L
Mistroke
.32433 .15709 L
.32434 .11953 L
.32436 .12665 L
.32437 .12825 L
.32439 .12463 L
.3244 .16693 L
.3244 .12726 L
.32441 .10785 L
.32442 .12776 L
.32444 .15137 L
.32445 .12528 L
.32447 .14506 L
.32448 .15933 L
.32448 .08148 L
.32449 .09394 L
.3245 .12315 L
.32451 .1294 L
.32452 .13845 L
.32453 .12646 L
.32453 .11626 L
.32455 .10993 L
.32457 .17156 L
.32457 .15024 L
.32458 .13683 L
.3246 .10385 L
.32461 .14189 L
.32462 .10322 L
.32463 .12799 L
.32464 .08603 L
.32466 .14949 L
.32467 .10381 L
.32469 .10146 L
.3247 .11664 L
.32471 .09278 L
.32473 .15867 L
.32474 .09836 L
.32476 .10855 L
.32477 .11701 L
.32479 .16316 L
.32479 .14046 L
.3248 .12241 L
.32482 .12663 L
.32483 .1439 L
.32485 .10091 L
.32486 .14396 L
.32488 .10298 L
.32488 .11326 L
.32489 .14698 L
.32491 .11392 L
.32492 .12005 L
Mistroke
.32493 .11621 L
.32493 .1381 L
.32494 .17599 L
.32496 .12646 L
.32497 .13983 L
.32498 .10499 L
.32499 .11956 L
.325 .09042 L
.32501 .1638 L
.32502 .09693 L
.32504 .12572 L
.32505 .09931 L
.32506 .1611 L
.32508 .12251 L
.32509 .11464 L
.3251 .14927 L
.32511 .12841 L
.32513 .13091 L
.32513 .10353 L
.32514 .1626 L
.32515 .12742 L
.32516 .14709 L
.32517 .11558 L
.32517 .13769 L
.32519 .13929 L
.3252 .13564 L
.32522 .14877 L
.32523 .11465 L
.32525 .10325 L
.32526 .11339 L
.32528 .1413 L
.32529 .12787 L
.3253 .16852 L
.32532 .0839 L
.32533 .08587 L
.32534 .121 L
.32536 .0892 L
.32537 .11585 L
.32538 .13311 L
.3254 .1067 L
.32541 .10773 L
.32543 .10702 L
.32544 .08243 L
.32545 .08333 L
.32546 .13613 L
.32547 .12565 L
.32549 .1181 L
.32549 .11043 L
.3255 .15024 L
.32552 .11543 L
Mistroke
.32553 .12349 L
.32554 .10669 L
.32555 .10763 L
.32557 .13278 L
.32558 .10055 L
.32559 .10998 L
.3256 .15073 L
.32561 .17891 L
.32562 .15719 L
.32563 .0822 L
.32564 .11683 L
.32566 .12707 L
.32567 .13089 L
.32568 .16703 L
.32569 .14916 L
.3257 .09224 L
.32571 .1499 L
.32572 .13079 L
.32573 .11953 L
.32574 .12514 L
.32576 .15563 L
.32577 .10482 L
.32578 .13894 L
.32579 .15524 L
.3258 .15136 L
.32581 .12608 L
.32582 .12295 L
.32584 .12517 L
.32585 .1321 L
.32585 .14073 L
.32587 .15499 L
.32588 .10648 L
.3259 .11533 L
.32591 .10343 L
.32591 .11887 L
.32593 .10977 L
.32594 .08527 L
.32596 .11602 L
.32597 .11156 L
.32598 .05818 L
.326 .11789 L
.32601 .09871 L
.32603 .14406 L
.32604 .14648 L
.32605 .11463 L
.32606 .1398 L
.32607 .13747 L
.32609 .12113 L
.3261 .14592 L
.32612 .15976 L
Mistroke
.32613 .10855 L
.32614 .11804 L
.32616 .12103 L
.32617 .10191 L
.32619 .11068 L
.3262 .16351 L
.32621 .14022 L
.32623 .13865 L
.32624 .15787 L
.32625 .0977 L
.32626 .10709 L
.32627 .13857 L
.32628 .18209 L
.32629 .11656 L
.3263 .12383 L
.32631 .12051 L
.32632 .13967 L
.32633 .16696 L
.32634 .15021 L
.32636 .11132 L
.32637 .11188 L
.32639 .10548 L
.3264 .15215 L
.32641 .12628 L
.32642 .09689 L
.32643 .09961 L
.32645 .11661 L
.32648 .14043 L
.32649 .14522 L
.32651 .16625 L
.32652 .16197 L
.32653 .11057 L
.32655 .17844 L
.32656 .17016 L
.32658 .1251 L
.32659 .14397 L
.3266 .11844 L
.32661 .09407 L
.32662 .13429 L
.32664 .15162 L
.32665 .12896 L
.32667 .10352 L
.32668 .12383 L
.3267 .16087 L
.32671 .14396 L
.32672 .16609 L
.32674 .07003 L
.32675 .13164 L
.32677 .13614 L
.32678 .12505 L
Mistroke
.32679 .12199 L
.32681 .13115 L
.32682 .09603 L
.32683 .12323 L
.32685 .12869 L
.32686 .11331 L
.32687 .11672 L
.32689 .08991 L
.3269 .14961 L
.32691 .14623 L
.32692 .11373 L
.32693 .09397 L
.32695 .15115 L
.32696 .1343 L
.32697 .15054 L
.32698 .14894 L
.32699 .1275 L
.32701 .0976 L
.32702 .12841 L
.32703 .13122 L
.32704 .12226 L
.32705 .14755 L
.32706 .145 L
.32707 .14029 L
.32709 .14685 L
.3271 .14264 L
.32711 .12671 L
.32712 .13558 L
.32712 .12927 L
.32713 .13586 L
.32714 .16025 L
.32715 .13635 L
.32716 .13604 L
.32717 .11845 L
.32719 .11083 L
.32719 .14566 L
.3272 .17532 L
.32722 .11573 L
.32723 .14476 L
.32725 .13334 L
.32726 .13834 L
.32727 .12253 L
.32729 .1138 L
.3273 .12179 L
.32731 .12276 L
.32731 .09848 L
.32732 .14774 L
.32733 .14565 L
.32734 .14628 L
.32735 .11506 L
Mistroke
.32737 .16422 L
.32738 .14423 L
.3274 .12211 L
.32741 .10762 L
.32742 .12742 L
.32743 .14096 L
.32744 .14257 L
.32745 .13184 L
.32746 .16374 L
.32746 .14475 L
.32748 .12886 L
.32749 .09541 L
.3275 .1068 L
.32751 .1631 L
.32752 .13784 L
.32753 .14314 L
.32754 .09207 L
.32755 .11776 L
.32756 .15539 L
.32757 .14068 L
.32757 .11993 L
.32758 .1438 L
.32759 .11119 L
.3276 .12435 L
.32761 .11051 L
.32762 .13134 L
.32763 .12172 L
.32764 .09784 L
.32765 .14284 L
.32766 .10388 L
.32767 .1812 L
.32768 .14677 L
.32769 .13528 L
.3277 .09214 L
.32772 .14131 L
.32773 .15287 L
.32774 .10331 L
.32776 .13903 L
.32777 .17095 L
.32779 .1218 L
.3278 .11563 L
.32781 .0967 L
.32781 .12533 L
.32782 .1332 L
.32783 .10489 L
.32784 .10614 L
.32785 .1305 L
.32787 .09859 L
.32788 .10733 L
.32789 .16268 L
Mistroke
.3279 .09284 L
.32791 .10428 L
.32793 .17149 L
.32794 .15193 L
.32795 .13673 L
.32796 .10876 L
.32798 .15232 L
.32798 .17725 L
.32799 .11825 L
.32801 .11822 L
.32802 .11384 L
.32803 .13998 L
.32805 .15115 L
.32806 .139 L
.32807 .16047 L
.32809 .10649 L
.3281 .15275 L
.32812 .13124 L
.32813 .11522 L
.32815 .17324 L
.32816 .12544 L
.32818 .1285 L
.32819 .15601 L
.32821 .12965 L
.32821 .10753 L
.32822 .13805 L
.32824 .11654 L
.32825 .09874 L
.32825 .15878 L
.32826 .11689 L
.32827 .1165 L
.32829 .11317 L
.32829 .16487 L
.3283 .09777 L
.32831 .16395 L
.32832 .13275 L
.32833 .1199 L
.32834 .11304 L
.32835 .1711 L
.32835 .19639 L
.32837 .12392 L
.32838 .15571 L
.3284 .17782 L
.32841 .13222 L
.32841 .13472 L
.32842 .12277 L
.32843 .1511 L
.32845 .14391 L
.32846 .14308 L
.32848 .11731 L
Mistroke
.32848 .12098 L
.32849 .13505 L
.32851 .10827 L
.32852 .10272 L
.32853 .09928 L
.32854 .14406 L
.32856 .107 L
.32857 .13225 L
.32858 .12216 L
.32859 .1092 L
.3286 .15139 L
.3286 .1336 L
.32861 .09277 L
.32862 .1729 L
.32863 .12823 L
.32864 .13586 L
.32865 .13495 L
.32867 .17326 L
.32868 .12716 L
.3287 .12455 L
.32871 .09462 L
.32872 .13955 L
.32873 .15749 L
.32874 .07426 L
.32876 .13582 L
.32877 .12764 L
.32879 .11798 L
.3288 .15604 L
.32882 .12902 L
.32883 .11238 L
.32883 .11861 L
.32885 .08251 L
.32886 .12783 L
.32887 .09327 L
.32887 .14785 L
.32888 .13915 L
.3289 .08548 L
.32891 .1255 L
.32893 .0927 L
.32894 .1226 L
.32895 .16122 L
.32896 .1099 L
.32897 .11921 L
.32898 .11324 L
.329 .16021 L
.32901 .14408 L
.32902 .13592 L
.32903 .14786 L
.32905 .08184 L
.32906 .12797 L
Mistroke
.32908 .15647 L
.32909 .18426 L
.3291 .13671 L
.32911 .12735 L
.32912 .10062 L
.32912 .13648 L
.32914 .15709 L
.32915 .13595 L
.32916 .09544 L
.32918 .13769 L
.32919 .12327 L
.3292 .12547 L
.32922 .12906 L
.32923 .14952 L
.32924 .08104 L
.32926 .14888 L
.32927 .08594 L
.32928 .10768 L
.3293 .12328 L
.32931 .13839 L
.32932 .11017 L
.32933 .14314 L
.32935 .13343 L
.32936 .10136 L
.32937 .15545 L
.32938 .1326 L
.32939 .10829 L
.3294 .0834 L
.32942 .14593 L
.32943 .12817 L
.32944 .15558 L
.32946 .10656 L
.32947 .14775 L
.32948 .10916 L
.32949 .12351 L
.32951 .12315 L
.32951 .14244 L
.32952 .10543 L
.32954 .09105 L
.32955 .09291 L
.32957 .14029 L
.32958 .11714 L
.32959 .15622 L
.32961 .13106 L
.32962 .13672 L
.32963 .14395 L
.32965 .1175 L
.32966 .07932 L
.32967 .1489 L
.32969 .12592 L
Mistroke
.3297 .14389 L
.32972 .12877 L
.32973 .13325 L
.32974 .12653 L
.32976 .10616 L
.32977 .11198 L
.32979 .12114 L
.3298 .18816 L
.32982 .13165 L
.32983 .11848 L
.32984 .12572 L
.32985 .1238 L
.32986 .12719 L
.32986 .09933 L
.32988 .13422 L
.32989 .09171 L
.32991 .11697 L
.32992 .12284 L
.32994 .13418 L
.32995 .07879 L
.32996 .16046 L
.32998 .12251 L
.32999 .10675 L
.33001 .11732 L
.33002 .13373 L
.33003 .111 L
.33005 .15703 L
.33006 .13678 L
.33008 .09717 L
.33009 .15932 L
.33011 .09774 L
.33012 .12396 L
.33013 .15182 L
.33014 .13049 L
.33015 .13633 L
.33016 .12442 L
.33016 .10237 L
.33017 .13489 L
.33019 .16294 L
.3302 .10712 L
.33021 .1166 L
.33021 .13275 L
.33022 .1249 L
.33023 .12159 L
.33024 .1321 L
.33025 .14884 L
.33026 .11989 L
.33027 .13378 L
.33029 .16896 L
.3303 .12123 L
Mistroke
.33032 .12347 L
.33033 .10369 L
.33034 .12996 L
.33036 .13862 L
.33037 .12374 L
.33039 .11166 L
.3304 .11132 L
.33041 .11709 L
.33043 .13094 L
.33044 .11351 L
.33046 .14238 L
.33047 .16618 L
.33048 .15026 L
.33049 .15688 L
.33051 .15221 L
.33052 .12173 L
.33053 .16747 L
.33055 .12258 L
.33056 .11293 L
.33057 .11898 L
.33059 .1137 L
.3306 .12256 L
.33061 .11611 L
.33063 .14116 L
.33064 .11964 L
.33065 .10968 L
.33067 .15176 L
.33068 .15479 L
.3307 .11612 L
.3307 .1112 L
.33071 .11338 L
.33073 .15522 L
.33074 .09781 L
.33075 .13436 L
.33077 .10597 L
.33079 .12282 L
.3308 .12805 L
.33081 .14253 L
.33083 .10199 L
.33084 .13932 L
.33085 .10749 L
.33087 .1044 L
.33088 .09176 L
.3309 .11486 L
.33091 .14284 L
.33093 .09687 L
.33094 .09557 L
.33094 .12458 L
.33096 .09545 L
.33097 .11021 L
Mistroke
.33099 .10567 L
.331 .12314 L
.33102 .1395 L
.33103 .11199 L
.33104 .12563 L
.33105 .12831 L
.33107 .10622 L
.33108 .15966 L
.33109 .1197 L
.33111 .14714 L
.33112 .12667 L
.33113 .14569 L
.33115 .12162 L
.33116 .10392 L
.33117 .15348 L
.33118 .09821 L
.33119 .11402 L
.33121 .12584 L
.33123 .17517 L
.33124 .13532 L
.33125 .10341 L
.33127 .14883 L
.33128 .13215 L
.33129 .13754 L
.33131 .15383 L
.33132 .14549 L
.33134 .17044 L
.33135 .11408 L
.33137 .12943 L
.33138 .11893 L
.33139 .17325 L
.3314 .12855 L
.33142 .09367 L
.33143 .17136 L
.33144 .14689 L
.33146 .11879 L
.33147 .13971 L
.33148 .16809 L
.3315 .12582 L
.33151 .0936 L
.33152 .10717 L
.33154 .13746 L
.33155 .07087 L
.33156 .14811 L
.33158 .11787 L
.33159 .16749 L
.3316 .11484 L
.33161 .12958 L
.33162 .12773 L
.33163 .1436 L
Mistroke
.33165 .14181 L
.33166 .15348 L
.33167 .13756 L
.33168 .1733 L
.33169 .12407 L
.33171 .12089 L
.33172 .0961 L
.33174 .09808 L
.33175 .12185 L
.33176 .16271 L
.33178 .13298 L
.33179 .1051 L
.33179 .07338 L
.33181 .13349 L
.33182 .13705 L
.33183 .05367 L
.33184 .14487 L
.33186 .1141 L
.33187 .08316 L
.33189 .15532 L
.3319 .14251 L
.33191 .16952 L
.33192 .08644 L
.33194 .1065 L
.33195 .13202 L
.33197 .12113 L
.33198 .11818 L
.33199 .11436 L
.33201 .13722 L
.33202 .13427 L
.33203 .12347 L
.33205 .08531 L
.33206 .14395 L
.33208 .10028 L
.33209 .11067 L
.33211 .13849 L
.33212 .10041 L
.33214 .17334 L
.33214 .10273 L
.33215 .11061 L
.33216 .12676 L
.33217 .10398 L
.33218 .10617 L
.3322 .11765 L
.33221 .15032 L
.33223 .12767 L
.33224 .12042 L
.33226 .12917 L
.33227 .12669 L
.33228 .12635 L
Mistroke
.3323 .0768 L
.33231 .11641 L
.33233 .1215 L
.33234 .11073 L
.33235 .14951 L
.33237 .11571 L
.33239 .13931 L
.3324 .15863 L
.33241 .11041 L
.33242 .13885 L
.33243 .11978 L
.33245 .12805 L
.33245 .14712 L
.33246 .14375 L
.33247 .13353 L
.33248 .14265 L
.33249 .15523 L
.3325 .11657 L
.33251 .15443 L
.33252 .12104 L
.33253 .15382 L
.33254 .11554 L
.33255 .15087 L
.33255 .13632 L
.33256 .1264 L
.33258 .1345 L
.33259 .1176 L
.33261 .12708 L
.33262 .12192 L
.33264 .14535 L
.33265 .1177 L
.33266 .07537 L
.33268 .14266 L
.33269 .18878 L
.3327 .15525 L
.33272 .11696 L
.33274 .12981 L
.33275 .08324 L
.33276 .16437 L
.33278 .14757 L
.33279 .09321 L
.3328 .10927 L
.33281 .13992 L
.33283 .10467 L
.33284 .15954 L
.33285 .13286 L
.33287 .15451 L
.33288 .10736 L
.33289 .14389 L
.33291 .08656 L
Mistroke
.33292 .12203 L
.33293 .15684 L
.33295 .13014 L
.33296 .15756 L
.33297 .11625 L
.33299 .09529 L
.333 .13485 L
.33301 .15157 L
.33302 .10807 L
.33303 .11669 L
.33305 .10012 L
.33306 .14472 L
.33308 .16435 L
.33309 .12186 L
.33311 .14353 L
.33312 .09384 L
.33313 .15 L
.33315 .12668 L
.33316 .10936 L
.33317 .13491 L
.33319 .15148 L
.3332 .1333 L
.33322 .09875 L
.33323 .12358 L
.33324 .15579 L
.33325 .11424 L
.33327 .12734 L
.33328 .11178 L
.33329 .1626 L
.33331 .11567 L
.33332 .12414 L
.33334 .11933 L
.33335 .13713 L
.33336 .1293 L
.33337 .13643 L
.33339 .09553 L
.3334 .13155 L
.33342 .10294 L
.33343 .14513 L
.33344 .0876 L
.33346 .12549 L
.33347 .1581 L
.33349 .0751 L
.3335 .16177 L
.33352 .14813 L
.33353 .12854 L
.33356 .10261 L
.33357 .08304 L
.33359 .12286 L
.3336 .12421 L
Mistroke
.33361 .13668 L
.33362 .12697 L
.33363 .1319 L
.33365 .10247 L
.33366 .13396 L
.33367 .12216 L
.33369 .12514 L
.3337 .08906 L
.33371 .15323 L
.33373 .11352 L
.33374 .14839 L
.33374 .14509 L
.33376 .15339 L
.33377 .12037 L
.33378 .1246 L
.33378 .13094 L
.33379 .10202 L
.3338 .14062 L
.33381 .14636 L
.33382 .13914 L
.33383 .10492 L
.33384 .128 L
.33386 .13848 L
.33387 .09808 L
.33388 .06773 L
.33389 .11275 L
.3339 .14698 L
.33392 .15964 L
.33393 .12302 L
.33395 .09445 L
.33396 .15424 L
.33398 .12579 L
.33399 .14675 L
.334 .12495 L
.33401 .13632 L
.33401 .11494 L
.33402 .10407 L
.33404 .17667 L
.33405 .14403 L
.33407 .12626 L
.33408 .12008 L
.3341 .14097 L
.33411 .16772 L
.33411 .14802 L
.33412 .1263 L
.33413 .13397 L
.33415 .08318 L
.33416 .13398 L
.33417 .13928 L
.33418 .11014 L
Mistroke
.33419 .12379 L
.3342 .10408 L
.33421 .10982 L
.33422 .124 L
.33423 .08977 L
.33425 .0949 L
.33426 .13945 L
.33427 .11285 L
.33428 .09505 L
.33429 .12241 L
.33431 .10131 L
.33432 .09571 L
.33432 .08169 L
.33433 .12087 L
.33434 .16472 L
.33435 .13391 L
.33436 .15615 L
.33437 .1299 L
.33439 .07981 L
.3344 .12068 L
.33441 .15678 L
.33443 .15799 L
.33444 .13535 L
.33444 .12132 L
.33446 .10757 L
.33447 .11647 L
.33449 .15784 L
.3345 .15327 L
.3345 .12406 L
.33452 .15259 L
.33453 .14482 L
.33455 .14146 L
.33456 .13613 L
.33457 .15648 L
.33459 .13425 L
.3346 .15512 L
.33461 .15908 L
.33462 .13886 L
.33464 .08968 L
.33464 .11981 L
.33465 .10812 L
.33467 .13808 L
.33468 .15563 L
.3347 .10056 L
.33471 .10108 L
.33472 .11892 L
.33474 .13159 L
.33475 .12528 L
.33476 .15248 L
.33478 .18708 L
Mistroke
.33479 .12643 L
.3348 .16904 L
.33482 .15637 L
.33483 .125 L
.33484 .09208 L
.33486 .08566 L
.33487 .15633 L
.33489 .13626 L
.3349 .10652 L
.33492 .10615 L
.33493 .12455 L
.33494 .13726 L
.33495 .12639 L
.33496 .12669 L
.33498 .13756 L
.33499 .1131 L
.33499 .1208 L
.33501 .08535 L
.33502 .10855 L
.33503 .15464 L
.33504 .14784 L
.33506 .10959 L
.33507 .09369 L
.33508 .10606 L
.33511 .12922 L
.33513 .14866 L
.33514 .12214 L
.33515 .12443 L
.33517 .165 L
.33518 .09898 L
.33519 .12845 L
.3352 .10697 L
.33522 .17495 L
.33523 .15589 L
.33524 .14569 L
.33525 .14774 L
.33526 .13035 L
.33527 .165 L
.33528 .13401 L
.33529 .17132 L
.3353 .15355 L
.33531 .1199 L
.33532 .10168 L
.33533 .11541 L
.33535 .11922 L
.33535 .0831 L
.33536 .09715 L
.33538 .10592 L
.33539 .10554 L
.33541 .15501 L
Mistroke
.33542 .14059 L
.33543 .14995 L
.33545 .14255 L
.33546 .11878 L
.33548 .14255 L
.33549 .18224 L
.3355 .12438 L
.33551 .15269 L
.33552 .0879 L
.33554 .15444 L
.33555 .09561 L
.33556 .12021 L
.33558 .12811 L
.33559 .13855 L
.3356 .15451 L
.33562 .1369 L
.33563 .12447 L
.33565 .15223 L
.33566 .12655 L
.33567 .10928 L
.33568 .08735 L
.33569 .15759 L
.33571 .1164 L
.33572 .15117 L
.33572 .09826 L
.33574 .11165 L
.33575 .13635 L
.33576 .17545 L
.33577 .12548 L
.33577 .15204 L
.33579 .12871 L
.3358 .14114 L
.33582 .18824 L
.33583 .15507 L
.33585 .11505 L
.33586 .14147 L
.33586 .14985 L
.33588 .14612 L
.33589 .11621 L
.3359 .1371 L
.33591 .17254 L
.33592 .14626 L
.33594 .1042 L
.33595 .12122 L
.33596 .14558 L
.33597 .17499 L
.33599 .13214 L
.336 .09919 L
.33602 .13423 L
.33603 .13798 L
Mistroke
.33604 .10785 L
.33606 .15281 L
.33607 .10074 L
.33608 .10122 L
.3361 .15793 L
.33611 .12318 L
.33613 .13659 L
.33613 .14593 L
.33614 .09117 L
.33615 .14517 L
.33616 .11381 L
.33617 .13891 L
.33619 .09016 L
.3362 .13577 L
.3362 .12707 L
.33622 .14632 L
.33624 .10988 L
.33625 .09517 L
.33625 .17972 L
.33627 .14415 L
.33628 .1434 L
.33629 .14158 L
.3363 .13349 L
.33632 .08262 L
.33633 .12189 L
.33635 .1383 L
.33636 .12095 L
.33638 .12593 L
.33639 .12131 L
.3364 .15485 L
.33641 .11784 L
.33642 .1236 L
.33643 .13871 L
.33645 .12032 L
.33646 .10076 L
.33647 .16505 L
.33649 .1137 L
.3365 .15189 L
.33651 .13687 L
.33652 .12045 L
.33654 .13175 L
.33654 .10016 L
.33655 .14717 L
.33657 .13542 L
.33658 .15593 L
.3366 .11692 L
.33661 .11246 L
.33662 .10664 L
.33664 .11863 L
.33665 .10983 L
Mistroke
.33666 .11884 L
.33668 .12075 L
.33669 .15765 L
.3367 .12871 L
.33672 .13085 L
.33673 .12161 L
.33675 .09091 L
.33676 .12582 L
.33677 .16066 L
.33679 .13701 L
.3368 .13723 L
.33682 .13629 L
.33683 .12501 L
.33685 .06361 L
.33686 .10466 L
.33687 .1585 L
.33688 .15471 L
.33689 .15815 L
.33691 .11928 L
.33692 .13411 L
.33693 .10891 L
.33694 .12733 L
.33695 .0926 L
.33697 .14965 L
.33698 .13712 L
.337 .08565 L
.33701 .12872 L
.33702 .10881 L
.33704 .14422 L
.33705 .12238 L
.33707 .16627 L
.33708 .16951 L
.3371 .13656 L
.33711 .10487 L
.33712 .10403 L
.33714 .15484 L
.33715 .1446 L
.33716 .10592 L
.33717 .13137 L
.33718 .12663 L
.33719 .15661 L
.3372 .12815 L
.33721 .10082 L
.33722 .15157 L
.33723 .1217 L
.33725 .13794 L
.33726 .19377 L
.33727 .13832 L
.33728 .14562 L
.33728 .14093 L
Mistroke
.3373 .12508 L
.33731 .15022 L
.33732 .10961 L
.33733 .10288 L
.33735 .09544 L
.33736 .16545 L
.33738 .11476 L
.33739 .10944 L
.3374 .14327 L
.33742 .13539 L
.33743 .12359 L
.33744 .15107 L
.33745 .13449 L
.33746 .14787 L
.33747 .11683 L
.33748 .1012 L
.33749 .1339 L
.33749 .1418 L
.3375 .13268 L
.33751 .08301 L
.33753 .13758 L
.33754 .12851 L
.33756 .1112 L
.33757 .14398 L
.33759 .12905 L
.3376 .17172 L
.33761 .12504 L
.33763 .1321 L
.33764 .12729 L
.33764 .15216 L
.33765 .1203 L
.33766 .12383 L
.33767 .13487 L
.33768 .13859 L
.33769 .09294 L
.3377 .11974 L
.33771 .08926 L
.33773 .10003 L
.33774 .1352 L
.33775 .15209 L
.33776 .10601 L
.33777 .15424 L
.33778 .152 L
.33779 .13567 L
.3378 .10361 L
.33781 .12746 L
.33782 .10268 L
.33783 .14876 L
.33784 .10208 L
.33785 .12964 L
Mistroke
.33786 .10138 L
.33786 .13369 L
.33787 .14307 L
.33789 .15548 L
.3379 .14017 L
.33792 .14457 L
.33792 .14141 L
.33793 .13778 L
.33794 .15745 L
.33795 .12028 L
.33796 .14281 L
.33797 .11769 L
.33797 .13096 L
.33798 .12519 L
.33799 .117 L
.338 .12845 L
.33801 .10857 L
.33802 .11631 L
.33803 .14907 L
.33803 .12663 L
.33805 .1544 L
.33806 .09081 L
.33807 .12111 L
.33808 .12544 L
.33809 .15304 L
.3381 .12297 L
.33811 .17539 L
.33813 .15207 L
.33814 .14411 L
.33815 .13212 L
.33817 .12401 L
.33818 .15367 L
.3382 .09819 L
.33821 .14154 L
.33821 .1596 L
.33822 .1063 L
.33823 .11921 L
.33824 .10595 L
.33825 .14002 L
.33826 .10239 L
.33827 .09753 L
.33828 .10796 L
.33829 .14611 L
.33831 .1371 L
.33832 .14201 L
.33834 .10763 L
.33835 .11253 L
.33837 .12887 L
.33838 .09057 L
.3384 .16238 L
Mistroke
.33841 .14556 L
.33842 .14263 L
.33843 .13731 L
.33844 .10176 L
.33845 .13115 L
.33847 .10448 L
.33848 .13816 L
.33848 .12636 L
.3385 .15049 L
.33851 .13955 L
.33853 .12024 L
.33854 .15565 L
.33856 .08236 L
.33857 .11813 L
.33858 .13483 L
.33859 .11123 L
.33861 .1417 L
.33862 .10639 L
.33864 .13599 L
.33865 .19263 L
.33866 .15746 L
.33868 .14932 L
.33869 .14697 L
.3387 .15756 L
.33872 .13966 L
.33873 .14036 L
.33875 .11566 L
.33876 .11162 L
.33878 .12917 L
.33879 .108 L
.33881 .10145 L
.33882 .11552 L
.33883 .14859 L
.33884 .1134 L
.33885 .15749 L
.33886 .12114 L
.33887 .1585 L
.33888 .10249 L
.3389 .12702 L
.33891 .13287 L
.33893 .12846 L
.33894 .09768 L
.33895 .15631 L
.33897 .12269 L
.33898 .17121 L
.339 .09508 L
.33901 .15488 L
.33903 .12652 L
.33904 .14914 L
.33905 .14346 L
Mistroke
.33906 .1133 L
.33907 .10425 L
.33908 .10753 L
.33909 .1153 L
.3391 .13451 L
.33911 .13812 L
.33912 .11057 L
.33913 .10562 L
.33914 .14125 L
.33915 .13755 L
.33916 .11506 L
.33917 .16582 L
.33918 .12311 L
.33918 .13331 L
.3392 .13691 L
.33921 .14123 L
.33922 .15032 L
.33923 .12425 L
.33925 .11382 L
.33926 .17908 L
.33928 .12764 L
.33929 .11699 L
.33931 .10778 L
.33932 .11099 L
.33933 .1555 L
.33935 .14058 L
.33936 .1502 L
.33937 .0831 L
.33939 .1818 L
.3394 .1337 L
.33942 .1648 L
.33943 .16663 L
.33944 .10667 L
.33945 .12624 L
.33947 .12295 L
.33948 .12001 L
.3395 .13315 L
.33951 .1499 L
.33952 .12348 L
.33954 .15129 L
.33955 .11292 L
.33956 .11431 L
.33957 .14564 L
.33959 .13619 L
.3396 .13466 L
.33961 .0999 L
.33963 .15411 L
.33964 .12995 L
.33966 .11956 L
.33966 .10651 L
Mistroke
.33967 .08497 L
.33969 .1346 L
.3397 .10771 L
.33971 .1305 L
.33973 .12145 L
.33974 .14841 L
.33976 .1023 L
.33977 .11133 L
.33979 .10747 L
.3398 .12095 L
.33981 .14329 L
.33983 .08736 L
.33984 .13266 L
.33986 .12417 L
.33987 .17857 L
.33989 .16227 L
.3399 .13909 L
.33992 .10972 L
.33993 .10771 L
.33995 .14597 L
.33996 .10757 L
.33998 .16745 L
.33999 .13491 L
.33999 .12165 L
.34001 .12668 L
.34002 .16851 L
.34003 .11765 L
.34005 .14803 L
.34006 .1543 L
.34008 .12284 L
.34009 .15571 L
.3401 .11386 L
.34011 .12355 L
.34013 .1322 L
.34014 .13469 L
.34015 .14077 L
.34017 .14484 L
.34018 .15134 L
.3402 .14019 L
.34021 .13573 L
.34023 .1256 L
.34024 .11847 L
.34025 .14724 L
.34026 .14032 L
.34027 .11439 L
.34029 .11373 L
.3403 .16092 L
.34031 .11503 L
.34033 .15332 L
.34034 .13042 L
Mistroke
.34035 .12291 L
.34037 .11297 L
.34038 .13764 L
.34039 .14685 L
.3404 .15254 L
.34041 .12409 L
.34043 .11953 L
.34044 .13918 L
.34045 .12632 L
.34046 .15264 L
.34047 .11713 L
.34048 .15398 L
.34049 .10524 L
.3405 .15027 L
.34051 .11495 L
.34052 .15701 L
.34053 .16126 L
.34054 .10434 L
.34055 .11202 L
.34057 .15104 L
.34058 .07656 L
.3406 .16316 L
.34061 .14617 L
.34063 .09841 L
.34064 .14045 L
.34064 .13517 L
.34066 .14005 L
.34067 .08967 L
.34068 .1213 L
.34069 .09899 L
.3407 .16157 L
.34072 .15377 L
.34073 .1178 L
.34075 .10277 L
.34076 .11648 L
.34077 .14434 L
.34077 .11998 L
.34078 .13612 L
.3408 .15297 L
.34081 .13704 L
.34082 .1583 L
.34083 .11959 L
.34085 .13703 L
.34086 .15347 L
.34086 .11686 L
.34087 .13017 L
.34088 .16207 L
.34089 .1332 L
.3409 .14969 L
.34091 .11513 L
Mistroke
.34093 .15728 L
.34094 .15256 L
.34096 .11257 L
.34097 .1464 L
.34097 .16459 L
.34098 .12088 L
.34099 .15336 L
.341 .11874 L
.34101 .14768 L
.34102 .19071 L
.34104 .14729 L
.34105 .09863 L
.34106 .15142 L
.34108 .11996 L
.34109 .1189 L
.34109 .17993 L
.34111 .13085 L
.34112 .11642 L
.34114 .09512 L
.34115 .09939 L
.34115 .10358 L
.34117 .12879 L
.34118 .16034 L
.3412 .10517 L
.34121 .1042 L
.34122 .16009 L
.34124 .15418 L
.34125 .13169 L
.34126 .12074 L
.34127 .14329 L
.34129 .09824 L
.34129 .11101 L
.3413 .11287 L
.34132 .15577 L
.34133 .12949 L
.34135 .14107 L
.34136 .14292 L
.34137 .15495 L
.34139 .12111 L
.3414 .14539 L
.34141 .11671 L
.34142 .13583 L
.34144 .16665 L
.34145 .16318 L
.34147 .10508 L
.34148 .09714 L
.34149 .1594 L
.34151 .13852 L
.34152 .10226 L
.34154 .12726 L
Mistroke
.34155 .16046 L
.34157 .14946 L
.34158 .14528 L
.34159 .07634 L
.3416 .17846 L
.34161 .11093 L
.34163 .0894 L
.34164 .11666 L
.34164 .1022 L
.34166 .1526 L
.34167 .13978 L
.34168 .12453 L
.34169 .12325 L
.3417 .15183 L
.34172 .09622 L
.34173 .13387 L
.34175 .15861 L
.34176 .14206 L
.34178 .14306 L
.34179 .13712 L
.3418 .13214 L
.34182 .12913 L
.34183 .14151 L
.34185 .1167 L
.34185 .13453 L
.34186 .12897 L
.34188 .11774 L
.34189 .09584 L
.34191 .12038 L
.34192 .12407 L
.34194 .17009 L
.34195 .08063 L
.34196 .09957 L
.34197 .10665 L
.34198 .11917 L
.342 .11051 L
.34201 .12719 L
.34202 .11857 L
.34203 .167 L
.34203 .10508 L
.34204 .16045 L
.34205 .13746 L
.34206 .07919 L
.34207 .11826 L
.34208 .14146 L
.34209 .11297 L
.3421 .10294 L
.34211 .14667 L
.34213 .14689 L
.34214 .09279 L
Mistroke
.34215 .10762 L
.34217 .11723 L
.34218 .11622 L
.3422 .07553 L
.34221 .12987 L
.34221 .11518 L
.34223 .13851 L
.34224 .10569 L
.34225 .09949 L
.34226 .12641 L
.34228 .14417 L
.34229 .08977 L
.3423 .13815 L
.34232 .07887 L
.34233 .13747 L
.34234 .10575 L
.34235 .10345 L
.34237 .12888 L
.34238 .12415 L
.3424 .14821 L
.34241 .10368 L
.34243 .11352 L
.34244 .14081 L
.34245 .1274 L
.34247 .14448 L
.34248 .11376 L
.3425 .14174 L
.34251 .13007 L
.34252 .14446 L
.34254 .13473 L
.34255 .13109 L
.34256 .08905 L
.34257 .16456 L
.34258 .08971 L
.34259 .10395 L
.3426 .14821 L
.34262 .19377 L
.34263 .14942 L
.34265 .12012 L
.34266 .11593 L
.34267 .11832 L
.34269 .13399 L
.3427 .10172 L
.34271 .11712 L
.34273 .14616 L
.34275 .13628 L
.34276 .11238 L
.34277 .13275 L
.34279 .12257 L
.3428 .0948 L
Mistroke
.34282 .13414 L
.34283 .12904 L
.34284 .13367 L
.34285 .16206 L
.34286 .13426 L
.34287 .11615 L
.34288 .17264 L
.34289 .16555 L
.3429 .15197 L
.34291 .16386 L
.34292 .12793 L
.34293 .15952 L
.34294 .16343 L
.34295 .12893 L
.34296 .11193 L
.34296 .10822 L
.34297 .14189 L
.34298 .09646 L
.34299 .13811 L
.34301 .12057 L
.34302 .09559 L
.34304 .1536 L
.34306 .0977 L
.34307 .13225 L
.34308 .13745 L
.3431 .15234 L
.34311 .1357 L
.34312 .12855 L
.34314 .13325 L
.34315 .13137 L
.34317 .14374 L
.34318 .14516 L
.3432 .10738 L
.34321 .14429 L
.34321 .10392 L
.34323 .15503 L
.34324 .1185 L
.34326 .08957 L
.34327 .10238 L
.34328 .13644 L
.3433 .12661 L
.34331 .13667 L
.34333 .14118 L
.34334 .1086 L
.34335 .11814 L
.34336 .14547 L
.34338 .18121 L
.34339 .09055 L
.3434 .12434 L
.34342 .1549 L
Mistroke
.34343 .14415 L
.34344 .16051 L
.34345 .15967 L
.34346 .14016 L
.34348 .13467 L
.3435 .13418 L
.34351 .11144 L
.34352 .15801 L
.34354 .17292 L
.34355 .15484 L
.34356 .14021 L
.34358 .10803 L
.34359 .12586 L
.34361 .14718 L
.34362 .1825 L
.34363 .17377 L
.34364 .12331 L
.34366 .13816 L
.34367 .14222 L
.34369 .10852 L
.3437 .16586 L
.34371 .09961 L
.34373 .13417 L
.34374 .10735 L
.34375 .13536 L
.34377 .13412 L
.34378 .13423 L
.34379 .14513 L
.34381 .17814 L
.34382 .13618 L
.34383 .15097 L
.34385 .09105 L
.34386 .14237 L
.34387 .10064 L
.34388 .11645 L
.34389 .12304 L
.34391 .14126 L
.34392 .13139 L
.34393 .16402 L
.34394 .10076 L
.34395 .15423 L
.34396 .13996 L
.34398 .10103 L
.34399 .10566 L
.34401 .1337 L
.34402 .09196 L
.34403 .12443 L
.34405 .08324 L
.34406 .1558 L
.34406 .15802 L
Mistroke
.34408 .17232 L
.34409 .18255 L
.3441 .10522 L
.34411 .12523 L
.34413 .12855 L
.34414 .14756 L
.34416 .12671 L
.34417 .1391 L
.34418 .14183 L
.34419 .11395 L
.34421 .08979 L
.34422 .11089 L
.34424 .14656 L
.34425 .13784 L
.34426 .11227 L
.34428 .12205 L
.34429 .12245 L
.3443 .10796 L
.34432 .11692 L
.34433 .15765 L
.34435 .12606 L
.34436 .09837 L
.34438 .15166 L
.34439 .11482 L
.3444 .19544 L
.34442 .17987 L
.34443 .12309 L
.34445 .13329 L
.34446 .11579 L
.34448 .14439 L
.34449 .1047 L
.34451 .15413 L
.34451 .13216 L
.34452 .14824 L
.34453 .13558 L
.34454 .11921 L
.34455 .10901 L
.34456 .15321 L
.34457 .12346 L
.34458 .16083 L
.3446 .1565 L
.34461 .13071 L
.34462 .12678 L
.34462 .1253 L
.34463 .11123 L
.34464 .10932 L
.34465 .13999 L
.34466 .14561 L
.34468 .14722 L
.34469 .10506 L
Mistroke
.3447 .10464 L
.34471 .15679 L
.34472 .13222 L
.34473 .10853 L
.34474 .1333 L
.34475 .14069 L
.34475 .12551 L
.34476 .1083 L
.34478 .11773 L
.34479 .11526 L
.34479 .11901 L
.34481 .14081 L
.34482 .12479 L
.34484 .10004 L
.34485 .13671 L
.34487 .11481 L
.34488 .16599 L
.34489 .13388 L
.3449 .11026 L
.34491 .13182 L
.34493 .13272 L
.34494 .158 L
.34494 .15407 L
.34496 .1285 L
.34497 .11703 L
.34498 .13754 L
.34498 .14122 L
.34499 .15128 L
.34501 .16307 L
.34502 .1382 L
.34503 .07669 L
.34504 .13525 L
.34506 .13412 L
.34507 .11867 L
.34508 .10387 L
.3451 .13223 L
.34511 .11342 L
.34513 .12844 L
.34514 .14487 L
.34515 .16744 L
.34517 .11746 L
.34518 .09758 L
.34518 .15179 L
.3452 .12167 L
.34521 .12426 L
.34523 .13719 L
.34524 .12432 L
.34525 .17151 L
.34527 .1047 L
.34528 .13926 L
Mistroke
.34529 .13625 L
.34531 .12982 L
.34532 .12559 L
.34533 .09108 L
.34534 .15669 L
.34535 .14158 L
.34537 .14847 L
.34538 .13659 L
.34539 .12655 L
.3454 .07523 L
.34541 .1142 L
.34543 .13374 L
.34544 .14836 L
.34544 .09846 L
.34546 .10557 L
.34548 .13261 L
.3455 .13395 L
.34551 .1626 L
.34552 .10509 L
.34553 .15817 L
.34554 .10745 L
.34556 .16714 L
.34557 .14377 L
.34558 .11779 L
.34559 .12863 L
.3456 .13692 L
.34562 .09398 L
.34563 .08354 L
.34563 .11708 L
.34565 .11161 L
.34566 .13043 L
.34567 .11044 L
.34568 .14634 L
.34568 .14276 L
.34569 .13013 L
.3457 .13399 L
.34572 .11009 L
.34573 .14086 L
.34575 .12939 L
.34576 .10083 L
.34576 .09014 L
.34578 .16297 L
.34579 .14464 L
.34581 .0918 L
.34582 .13964 L
.34584 .08225 L
.34585 .16589 L
.34585 .15919 L
.34587 .12899 L
.34588 .18715 L
Mistroke
.3459 .11463 L
.34591 .15858 L
.34592 .16834 L
.34594 .14268 L
.34595 .116 L
.34596 .12135 L
.34597 .14647 L
.34599 .18282 L
.34599 .15219 L
.346 .12982 L
.34602 .10111 L
.34603 .10092 L
.34605 .12347 L
.34606 .09582 L
.34607 .11534 L
.34609 .14294 L
.3461 .11957 L
.34611 .11073 L
.34613 .10947 L
.34614 .15261 L
.34615 .14664 L
.34617 .09997 L
.34618 .13711 L
.34619 .06702 L
.34621 .1236 L
.34622 .11951 L
.34624 .14518 L
.34625 .10982 L
.34627 .15618 L
.34628 .15919 L
.34629 .14579 L
.3463 .13314 L
.34631 .13369 L
.34633 .11494 L
.34634 .18271 L
.34634 .10622 L
.34636 .15752 L
.34637 .17439 L
.34638 .14887 L
.34639 .17706 L
.3464 .13683 L
.34642 .13074 L
.34643 .17429 L
.34645 .16731 L
.34646 .14987 L
.34648 .10614 L
.34649 .17638 L
.3465 .1004 L
.34652 .15285 L
.34653 .07437 L
Mistroke
.34655 .07618 L
.34655 .10897 L
.34656 .1247 L
.34658 .12259 L
.34659 .1697 L
.34661 .10499 L
.34662 .12017 L
.34664 .11463 L
.34665 .12687 L
.34665 .10775 L
.34667 .09337 L
.34668 .11402 L
.34669 .14882 L
.3467 .15149 L
.3467 .1357 L
.34671 .1578 L
.34672 .11945 L
.34673 .13457 L
.34674 .146 L
.34675 .11284 L
.34677 .1102 L
.34678 .12943 L
.34679 .10615 L
.3468 .12158 L
.34681 .11633 L
.34683 .14009 L
.34684 .13689 L
.34685 .14859 L
.34687 .1366 L
.34688 .14245 L
.3469 .16778 L
.3469 .11432 L
.34691 .12675 L
.34693 .16204 L
.34694 .11212 L
.34695 .15481 L
.34696 .15845 L
.34698 .13342 L
.34699 .13372 L
.347 .08288 L
.34702 .14223 L
.34703 .11116 L
.34705 .11571 L
.34706 .12732 L
.34707 .14461 L
.34709 .13105 L
.3471 .10937 L
.34712 .09015 L
.34713 .12214 L
.34715 .13333 L
Mistroke
.34716 .12463 L
.34717 .11228 L
.34718 .10475 L
.3472 .12962 L
.34721 .11698 L
.34722 .08782 L
.34724 .13188 L
.34725 .1316 L
.34726 .13942 L
.34727 .09968 L
.34728 .1437 L
.34729 .14505 L
.3473 .08979 L
.34732 .15486 L
.34733 .13939 L
.34735 .0976 L
.34736 .17391 L
.34737 .12572 L
.34739 .10429 L
.3474 .0903 L
.34741 .18393 L
.34743 .14685 L
.34745 .10443 L
.34746 .15908 L
.34747 .12979 L
.34749 .15446 L
.3475 .14062 L
.34752 .14533 L
.34753 .12795 L
.34754 .1449 L
.34755 .10678 L
.34756 .15014 L
.34757 .14712 L
.34758 .18571 L
.34759 .13249 L
.3476 .13359 L
.34761 .1289 L
.34762 .11322 L
.34763 .13382 L
.34764 .19669 L
.34765 .13711 L
.34766 .11556 L
.34766 .16293 L
.34767 .15412 L
.34768 .15642 L
.34769 .15441 L
.34771 .15528 L
.34772 .16534 L
.34774 .10704 L
.34776 .11355 L
Mistroke
.34777 .16467 L
.34778 .11674 L
.3478 .14505 L
.34781 .13092 L
.34782 .10195 L
.34784 .13837 L
.34785 .12737 L
.34787 .15004 L
.34788 .14927 L
.3479 .09803 L
.34791 .11236 L
.34791 .10824 L
.34793 .06955 L
.34794 .09917 L
.34796 .1409 L
.34797 .1108 L
.34799 .11488 L
.348 .12196 L
.34801 .15321 L
.34802 .08878 L
.34804 .12854 L
.34805 .13371 L
.34806 .16726 L
.34808 .10528 L
.34809 .16885 L
.3481 .11382 L
.34812 .08034 L
.34813 .14203 L
.34814 .16886 L
.34815 .14888 L
.34816 .10393 L
.34818 .12073 L
.34819 .12047 L
.34821 .11867 L
.34822 .1716 L
.34824 .15572 L
.34825 .14729 L
.34826 .11591 L
.34828 .09662 L
.34829 .17233 L
.34831 .14137 L
.34832 .15022 L
.34834 .15167 L
.34835 .16544 L
.34836 .14672 L
.34837 .12741 L
.34838 .12464 L
.3484 .15489 L
.34841 .12527 L
.34843 .12006 L
Mistroke
.34844 .14376 L
.34845 .1533 L
.34847 .1288 L
.34848 .13568 L
.34849 .15149 L
.34851 .15107 L
.34852 .1199 L
.34853 .1174 L
.34854 .11617 L
.34855 .12287 L
.34856 .12702 L
.34858 .14552 L
.34859 .12247 L
.3486 .10179 L
.34862 .13081 L
.34863 .15026 L
.34864 .12075 L
.34865 .14607 L
.34866 .11492 L
.34868 .11877 L
.34869 .1368 L
.3487 .12707 L
.34872 .09903 L
.34873 .11306 L
.34876 .14818 L
.34878 .169 L
.34879 .10751 L
.3488 .13403 L
.34881 .13563 L
.34883 .18491 L
.34884 .10558 L
.34886 .17524 L
.34887 .14202 L
.34888 .14006 L
.3489 .10356 L
.34891 .10018 L
.34892 .11562 L
.34893 .14239 L
.34895 .12863 L
.34896 .13107 L
.34897 .11028 L
.34899 .16117 L
.349 .09906 L
.34902 .0965 L
.34903 .15499 L
.34904 .12995 L
.34905 .1025 L
.34906 .1576 L
.34908 .08839 L
.34909 .13753 L
Mistroke
.3491 .14264 L
.34911 .11892 L
.34912 .11163 L
.34914 .15627 L
.34915 .12653 L
.34916 .12145 L
.34917 .13571 L
.34919 .17866 L
.3492 .14916 L
.34921 .13769 L
.34922 .14272 L
.34924 .09915 L
.34925 .1251 L
.34925 .1155 L
.34927 .12418 L
.34928 .07569 L
.3493 .11332 L
.34931 .12925 L
.34932 .14576 L
.34934 .12122 L
.34935 .0895 L
.34936 .16995 L
.34938 .11153 L
.34939 .12305 L
.34941 .14083 L
.34942 .12774 L
.34943 .14575 L
.34944 .11645 L
.34946 .1116 L
.34947 .12884 L
.34949 .13017 L
.3495 .0913 L
.34952 .14599 L
.34953 .13643 L
.34955 .05142 L
.34956 .10741 L
.34957 .12794 L
.34958 .13315 L
.3496 .10544 L
.34961 .16468 L
.34962 .12002 L
.34963 .1476 L
.34964 .1558 L
.34966 .11862 L
.34967 .15523 L
.34968 .13173 L
.3497 .18274 L
.34971 .13054 L
.34972 .18336 L
.34974 .09989 L
Mistroke
.34975 .13488 L
.34977 .1247 L
.34978 .14217 L
.3498 .12295 L
.34981 .09425 L
.34983 .12472 L
.34984 .16138 L
.34985 .1571 L
.34986 .15958 L
.34987 .12926 L
.34988 .07874 L
.34989 .17529 L
.3499 .13874 L
.34991 .13132 L
.34992 .14007 L
.34993 .12075 L
.34994 .11027 L
.34995 .13688 L
.34996 .12278 L
.34996 .12426 L
.34997 .10534 L
.34998 .14723 L
.34999 .12843 L
.35 .15189 L
.35002 .10986 L
.35003 .12794 L
.35005 .14881 L
.35006 .17457 L
.35008 .11259 L
.35009 .13517 L
.3501 .12115 L
.35012 .09678 L
.35013 .14811 L
.35015 .15292 L
.35016 .15194 L
.35018 .11704 L
.35019 .12448 L
.35021 .1659 L
.35022 .12404 L
.35022 .14374 L
.35024 .11934 L
.35025 .14702 L
.35027 .14339 L
.35028 .14134 L
.35029 .10575 L
.35031 .13887 L
.35032 .11898 L
.35033 .14163 L
.35035 .1279 L
.35036 .14853 L
Mistroke
.35037 .1289 L
.35039 .12643 L
.3504 .11467 L
.35041 .12141 L
.35042 .1356 L
.35043 .12565 L
.35045 .10677 L
.35046 .16057 L
.35047 .13864 L
.35049 .11247 L
.3505 .10519 L
.3505 .13069 L
.35052 .13454 L
.35053 .0972 L
.35055 .12677 L
.35056 .15558 L
.35057 .14391 L
.35059 .13743 L
.35059 .17438 L
.3506 .17959 L
.35062 .14756 L
.35063 .13515 L
.35064 .12592 L
.35065 .10593 L
.35067 .09446 L
.35068 .12117 L
.3507 .14951 L
.35071 .15606 L
.35072 .1402 L
.35074 .10649 L
.35075 .12572 L
.35076 .12652 L
.35078 .09999 L
.35079 .12475 L
.35081 .13269 L
.35082 .12778 L
.35084 .14925 L
.35085 .11054 L
.35086 .07961 L
.35087 .11375 L
.35089 .11692 L
.3509 .14933 L
.35092 .13124 L
.35093 .14108 L
.35094 .09155 L
.35096 .13613 L
.35097 .16361 L
.35098 .08471 L
.35098 .13845 L
.35099 .12311 L
Mistroke
.35101 .11332 L
.35102 .13342 L
.35104 .14954 L
.35105 .15225 L
.35107 .11585 L
.35108 .10274 L
.35109 .09589 L
.35111 .10715 L
.35112 .15055 L
.35113 .12136 L
.35115 .15554 L
.35116 .1475 L
.35118 .11582 L
.35119 .10027 L
.3512 .12509 L
.35121 .11583 L
.35123 .13537 L
.35124 .13852 L
.35125 .09757 L
.35126 .17489 L
.35127 .12738 L
.35128 .1186 L
.35128 .11939 L
.35129 .10628 L
.35131 .08241 L
.35132 .11314 L
.35134 .16382 L
.35135 .1114 L
.35136 .12008 L
.35137 .07607 L
.35138 .11456 L
.3514 .15752 L
.35141 .14664 L
.35141 .1242 L
.35143 .14009 L
.35144 .13699 L
.35146 .06493 L
.35147 .097 L
.35149 .17552 L
.35149 .15053 L
.3515 .10867 L
.35152 .11956 L
.35153 .14968 L
.35154 .13692 L
.35156 .13123 L
.35157 .13674 L
.35158 .15341 L
.3516 .16031 L
.35161 .15513 L
.35163 .13655 L
Mistroke
.35164 .13367 L
.35165 .12963 L
.35167 .15228 L
.35168 .11489 L
.35169 .13291 L
.3517 .12057 L
.35171 .15208 L
.35172 .12202 L
.35173 .11966 L
.35174 .12878 L
.35174 .14606 L
.35175 .11925 L
.35177 .12473 L
.35178 .12509 L
.35179 .17642 L
.3518 .15365 L
.35181 .14793 L
.35183 .15401 L
.35184 .13835 L
.35186 .12947 L
.35187 .10937 L
.35189 .14742 L
.3519 .11367 L
.3519 .15629 L
.35192 .113 L
.35193 .09005 L
.35194 .1267 L
.35195 .11706 L
.35196 .14379 L
.35198 .13868 L
.35199 .14421 L
.35201 .1626 L
.35202 .12493 L
.35203 .13213 L
.35203 .13567 L
.35204 .13403 L
.35206 .14408 L
.35207 .10936 L
.35208 .12601 L
.35209 .14077 L
.35211 .13313 L
.35211 .13416 L
.35212 .10389 L
.35213 .13151 L
.35214 .13474 L
.35215 .14089 L
.35216 .12473 L
.35217 .1065 L
.35219 .12951 L
.3522 .1199 L
Mistroke
.35222 .13981 L
.35223 .11952 L
.35223 .15892 L
.35224 .12781 L
.35225 .10849 L
.35226 .16291 L
.35227 .12693 L
.35228 .18091 L
.3523 .12608 L
.35231 .13169 L
.35232 .13983 L
.35234 .124 L
.35235 .11338 L
.35235 .16529 L
.35237 .136 L
.35238 .12834 L
.3524 .15324 L
.35241 .11582 L
.35241 .1363 L
.35243 .15647 L
.35244 .104 L
.35246 .15332 L
.35247 .10324 L
.35248 .15068 L
.3525 .18088 L
.35251 .11828 L
.35252 .10232 L
.35253 .13034 L
.35255 .15033 L
.35255 .07788 L
.35256 .09876 L
.35258 .10852 L
.35259 .13316 L
.35261 .16043 L
.35262 .13351 L
.35263 .0956 L
.35265 .14803 L
.35266 .17658 L
.35267 .12194 L
.35268 .15944 L
.3527 .17138 L
.35271 .17408 L
.35273 .18844 L
.35274 .14105 L
.35276 .14274 L
.35277 .09694 L
.35279 .16921 L
.3528 .09983 L
.35281 .09776 L
.35283 .15821 L
Mistroke
.35284 .14113 L
.35286 .13233 L
.35287 .16206 L
.35288 .16548 L
.35289 .15729 L
.3529 .12095 L
.3529 .10627 L
.35292 .1509 L
.35293 .11811 L
.35294 .11685 L
.35295 .17424 L
.35296 .14434 L
.35298 .12969 L
.35299 .13762 L
.35301 .11073 L
.35302 .16957 L
.35304 .14478 L
.35305 .13195 L
.35306 .17441 L
.35308 .13412 L
.35309 .11231 L
.35311 .09887 L
.35311 .1732 L
.35312 .13988 L
.35314 .08956 L
.35315 .08277 L
.35317 .13453 L
.35318 .13956 L
.3532 .09568 L
.3532 .12957 L
.35321 .1515 L
.35323 .16185 L
.35324 .13346 L
.35325 .13858 L
.35325 .15418 L
.35326 .16136 L
.35327 .09851 L
.35328 .14303 L
.35329 .12853 L
.3533 .17486 L
.35331 .10919 L
.35333 .15758 L
.35334 .07612 L
.35335 .14359 L
.35336 .1579 L
.35337 .12728 L
.35339 .13127 L
.3534 .12369 L
.35341 .15968 L
.35343 .07309 L
Mistroke
.35344 .12884 L
.35346 .16722 L
.35346 .13832 L
.35347 .15103 L
.35349 .12048 L
.3535 .1029 L
.3535 .1492 L
.35352 .12482 L
.35353 .14055 L
.35355 .11368 L
.35356 .14059 L
.35358 .1202 L
.35359 .13141 L
.3536 .13529 L
.35361 .18228 L
.35363 .18165 L
.35364 .13566 L
.35366 .14833 L
.35367 .13036 L
.35368 .10756 L
.3537 .12051 L
.35371 .16192 L
.35372 .13793 L
.35374 .12113 L
.35375 .14306 L
.35377 .0983 L
.35378 .13406 L
.3538 .11907 L
.35381 .11659 L
.35382 .15768 L
.35383 .11817 L
.35384 .11577 L
.35385 .10226 L
.35386 .12187 L
.35387 .12723 L
.35389 .15737 L
.35391 .13111 L
.35392 .13086 L
.35393 .14723 L
.35395 .17867 L
.35396 .11417 L
.35397 .11372 L
.35399 .12996 L
.354 .17378 L
.35402 .09834 L
.35403 .15178 L
.35405 .13475 L
.35406 .15674 L
.35408 .14746 L
.35409 .16357 L
Mistroke
.3541 .14571 L
.35411 .16075 L
.35412 .12545 L
.35413 .18205 L
.35414 .08339 L
.35415 .10678 L
.35416 .13509 L
.35417 .12242 L
.35419 .15454 L
.3542 .13975 L
.35421 .11088 L
.35422 .18286 L
.35423 .11261 L
.35424 .15617 L
.35425 .12507 L
.35426 .13634 L
.35427 .1251 L
.35428 .15331 L
.3543 .13422 L
.35431 .13029 L
.35432 .16691 L
.35434 .10747 L
.35435 .10635 L
.35436 .14219 L
.35437 .14794 L
.35438 .1232 L
.3544 .164 L
.35441 .14595 L
.35442 .19336 L
.35444 .18138 L
.35449 .1204 L
.3545 .13726 L
.35451 .12993 L
.35453 .08604 L
.35454 .17541 L
.35456 .15787 L
.35456 .12909 L
.35457 .10997 L
.35459 .10958 L
.3546 .15199 L
.3546 .10324 L
.35461 .10924 L
.35462 .11677 L
.35464 .16527 L
.35465 .14713 L
.35467 .13661 L
.35468 .12736 L
.35469 .11319 L
.3547 .16114 L
.35471 .09926 L
Mistroke
.35473 .11764 L
.35474 .13421 L
.35476 .10406 L
.35477 .07917 L
.35479 .12816 L
.3548 .16177 L
.35481 .1394 L
.35483 .15347 L
.35484 .1107 L
.35485 .14322 L
.35487 .11291 L
.35489 .1501 L
.3549 .12991 L
.35491 .11051 L
.35493 .11717 L
.35494 .12652 L
.35495 .11672 L
.35496 .13934 L
.35498 .10288 L
.35499 .13263 L
.355 .15497 L
.35502 .14119 L
.35503 .1213 L
.35504 .1591 L
.35506 .11832 L
.35507 .1375 L
.35508 .11431 L
.3551 .10215 L
.35511 .12465 L
.35512 .11465 L
.35514 .1222 L
.35515 .09439 L
.35516 .11294 L
.35517 .11548 L
.35518 .11781 L
.3552 .11641 L
.35521 .16626 L
.35522 .12035 L
.35524 .1776 L
.35525 .18269 L
.35527 .13068 L
.35528 .12542 L
.35529 .11063 L
.35531 .12893 L
.35532 .11305 L
.35533 .15091 L
.35533 .11657 L
.35534 .15261 L
.35536 .14304 L
.35537 .14608 L
Mistroke
.35539 .1537 L
.3554 .11621 L
.35542 .11276 L
.35543 .09555 L
.35545 .16125 L
.35546 .11009 L
.35547 .13444 L
.35549 .13462 L
.3555 .11769 L
.35552 .1464 L
.35553 .09886 L
.35555 .16102 L
.35556 .13949 L
.35557 .1166 L
.35559 .14247 L
.3556 .11791 L
.35561 .13188 L
.35563 .14513 L
.35564 .09048 L
.35565 .11084 L
.35567 .12217 L
.35567 .15716 L
.35568 .14029 L
.3557 .15092 L
.35571 .18472 L
.35572 .10507 L
.35574 .15666 L
.35575 .10275 L
.35577 .14134 L
.35578 .09931 L
.35579 .15975 L
.3558 .10518 L
.35581 .14421 L
.35582 .11662 L
.35583 .13559 L
.35584 .15221 L
.35586 .12509 L
.35587 .11349 L
.35589 .16024 L
.3559 .13107 L
.35591 .14252 L
.35593 .14065 L
.35594 .13242 L
.35595 .12717 L
.35597 .13392 L
.35598 .14411 L
.35599 .09899 L
.35601 .16687 L
.35602 .13333 L
.35604 .12414 L
Mistroke
.35605 .11574 L
.35607 .11064 L
.35608 .1304 L
.35609 .12904 L
.35611 .12307 L
.35612 .11541 L
.35614 .15205 L
.35615 .12044 L
.35616 .11518 L
.35617 .10035 L
.35619 .13359 L
.35619 .16463 L
.3562 .10982 L
.35622 .1431 L
.35623 .17175 L
.35624 .1261 L
.35626 .08538 L
.35627 .11799 L
.35628 .10073 L
.3563 .146 L
.35631 .16083 L
.35633 .15312 L
.35634 .13249 L
.35636 .13662 L
.35637 .16679 L
.35639 .13322 L
.3564 .13081 L
.35642 .1217 L
.35643 .14741 L
.35643 .15298 L
.35645 .13197 L
.35646 .11644 L
.35647 .1379 L
.35647 .15497 L
.35648 .16181 L
.3565 .1254 L
.35651 .15379 L
.35651 .09089 L
.35652 .11512 L
.35653 .1498 L
.35654 .1183 L
.35655 .14471 L
.35656 .10721 L
.35656 .1298 L
.35658 .09047 L
.35659 .13307 L
.35661 .1215 L
.35662 .12888 L
.35664 .09049 L
.35665 .12339 L
Mistroke
.35667 .1322 L
.35668 .15687 L
.35669 .13348 L
.35671 .11669 L
.35672 .14078 L
.35674 .1194 L
.35675 .08771 L
.35677 .10433 L
.35677 .18074 L
.35678 .17304 L
.35679 .14203 L
.3568 .16514 L
.35681 .13052 L
.35683 .17684 L
.35684 .09749 L
.35686 .14958 L
.35687 .11027 L
.35688 .13711 L
.3569 .13167 L
.35692 .14037 L
.35693 .16146 L
.35694 .09157 L
.35696 .15642 L
.35697 .12253 L
.35698 .06763 L
.357 .12147 L
.35701 .13561 L
.35702 .13427 L
.35704 .13841 L
.35705 .10345 L
.35706 .1239 L
.35707 .10884 L
.35708 .11524 L
.35709 .1466 L
.35711 .12353 L
.35712 .1248 L
.35713 .1112 L
.35715 .09509 L
.35716 .13144 L
.35718 .12982 L
.35719 .19036 L
.35719 .16112 L
.35721 .15305 L
.35722 .14746 L
.35723 .11181 L
.35724 .11688 L
.35726 .12279 L
.35727 .159 L
.35728 .18077 L
.3573 .1351 L
Mistroke
.35731 .16984 L
.35732 .13399 L
.35734 .1493 L
.35735 .1277 L
.35736 .12916 L
.35738 .10935 L
.35739 .12268 L
.35741 .15945 L
.35742 .15395 L
.35743 .17078 L
.35745 .10097 L
.35746 .09816 L
.35748 .14598 L
.35749 .12155 L
.3575 .11073 L
.35752 .14418 L
.35753 .10434 L
.35754 .17953 L
.35755 .18582 L
.35756 .10564 L
.35757 .13613 L
.35758 .14796 L
.3576 .13246 L
.35761 .13854 L
.35763 .1158 L
.35764 .11233 L
.35766 .1151 L
.35767 .17074 L
.35768 .13634 L
.3577 .158 L
.35771 .11792 L
.35773 .13187 L
.35774 .15406 L
.35775 .1414 L
.35777 .09434 L
.35778 .14007 L
.3578 .12031 L
.35781 .13206 L
.35782 .1241 L
.35783 .09206 L
.35785 .09083 L
.35785 .0988 L
.35786 .1279 L
.35787 .13605 L
.35788 .1107 L
.35789 .12484 L
.3579 .15772 L
.35791 .0967 L
.35792 .12935 L
.35793 .16357 L
Mistroke
.35794 .14436 L
.35796 .10635 L
.35797 .12771 L
.35798 .13609 L
.35799 .1094 L
.35801 .15969 L
.35802 .1516 L
.35803 .16341 L
.35805 .11789 L
.35806 .13658 L
.35807 .14548 L
.35808 .11509 L
.35809 .12464 L
.35811 .1567 L
.35812 .13594 L
.35813 .12782 L
.35815 .15039 L
.35816 .15028 L
.35817 .09639 L
.35819 .13504 L
.3582 .12842 L
.35821 .13042 L
.35823 .15869 L
.35824 .13589 L
.35825 .13091 L
.35826 .14847 L
.35828 .11979 L
.35828 .17432 L
.35829 .14559 L
.35831 .15862 L
.35832 .12279 L
.35832 .11634 L
.35833 .13536 L
.35834 .13328 L
.35836 .14783 L
.35837 .12221 L
.35837 .12491 L
.35839 .10388 L
.3584 .17065 L
.35841 .13634 L
.35842 .15021 L
.35843 .12165 L
.35845 .17432 L
.35846 .13128 L
.35848 .12482 L
.35849 .16061 L
.35851 .10049 L
.35852 .11138 L
.35854 .11318 L
.35855 .11889 L
Mistroke
.35856 .13831 L
.35857 .11405 L
.35858 .17548 L
.3586 .10352 L
.35861 .14337 L
.35862 .12299 L
.35864 .12671 L
.35869 .14215 L
.35871 .13078 L
.35872 .12336 L
.35872 .09633 L
.35874 .13177 L
.35875 .14105 L
.35877 .09848 L
.35878 .17368 L
.35879 .15235 L
.35879 .12709 L
.3588 .16877 L
.35881 .08306 L
.35882 .1714 L
.35883 .16797 L
.35885 .12498 L
.35886 .15758 L
.35888 .14376 L
.35889 .15013 L
.3589 .08395 L
.35891 .14173 L
.35893 .14674 L
.35894 .13395 L
.35895 .12871 L
.35897 .1323 L
.35898 .12474 L
.35899 .13482 L
.35901 .15516 L
.35902 .13535 L
.35903 .16862 L
.35904 .14801 L
.35906 .17294 L
.35907 .13171 L
.35908 .12077 L
.35909 .12144 L
.3591 .14088 L
.35912 .11959 L
.35913 .13169 L
.35915 .13846 L
.35915 .13683 L
.35916 .15928 L
.35917 .16965 L
.35918 .08971 L
.35919 .15425 L
Mistroke
.3592 .16957 L
.35922 .119 L
.35923 .12064 L
.35925 .08307 L
.35926 .11274 L
.35927 .1204 L
.35928 .09295 L
.3593 .11749 L
.35931 .15511 L
.35933 .15202 L
.35934 .11978 L
.35935 .12195 L
.35936 .13218 L
.35937 .11599 L
.35938 .09766 L
.3594 .10196 L
.35941 .08479 L
.35943 .13331 L
.35944 .13014 L
.35946 .14923 L
.35947 .11978 L
.35948 .08382 L
.3595 .19628 L
.35951 .14772 L
.35953 .13296 L
.35954 .12998 L
.35956 .1651 L
.35957 .11707 L
.35959 .13118 L
.35959 .14822 L
.3596 .09983 L
.35962 .13296 L
.35963 .12912 L
.35965 .14238 L
.35966 .12603 L
.35967 .11901 L
.35969 .13781 L
.3597 .15386 L
.35971 .15587 L
.35972 .10482 L
.35974 .11932 L
.35975 .1413 L
.35977 .09004 L
.35978 .12184 L
.35979 .11139 L
.35981 .12857 L
.35982 .18565 L
.35982 .1271 L
.35984 .11649 L
.35985 .14277 L
Mistroke
.35987 .11856 L
.35988 .17149 L
.3599 .16079 L
.35991 .14465 L
.35993 .12778 L
.35994 .1406 L
.35995 .11948 L
.35997 .12599 L
.35998 .13422 L
.35999 .10515 L
.36001 .11946 L
.36002 .16084 L
.36004 .134 L
.36005 .11856 L
.36006 .15145 L
.36007 .14605 L
.36009 .14105 L
.36011 .10385 L
.36013 .08946 L
.36014 .12332 L
.36015 .09504 L
.36017 .13675 L
.36018 .18748 L
.36019 .12372 L
.36021 .13485 L
.36022 .12041 L
.36023 .16493 L
.36025 .12375 L
.36026 .10683 L
.36028 .12406 L
.36029 .10753 L
.36031 .13818 L
.36032 .11674 L
.36033 .16556 L
.36035 .12343 L
.36037 .1197 L
.36038 .10631 L
.36039 .11368 L
.36041 .15117 L
.36042 .12347 L
.36043 .14935 L
.36044 .15944 L
.36044 .10197 L
.36045 .10329 L
.36047 .14519 L
.36048 .1318 L
.36049 .09793 L
.3605 .10742 L
.36051 .11914 L
.36053 .12377 L
Mistroke
.36054 .16962 L
.36056 .12762 L
.36057 .11634 L
.36058 .0799 L
.36058 .09137 L
.36059 .11167 L
.36061 .13243 L
.36062 .08734 L
.36064 .151 L
.36065 .11449 L
.36067 .16889 L
.36067 .14518 L
.36068 .12073 L
.36069 .14833 L
.3607 .15481 L
.36071 .12474 L
.36073 .14987 L
.36074 .16603 L
.36075 .16838 L
.36076 .15386 L
.36077 .08652 L
.36078 .09692 L
.36079 .13325 L
.3608 .14595 L
.36081 .13854 L
.36081 .11016 L
.36083 .14789 L
.36084 .12317 L
.36085 .08815 L
.36086 .13815 L
.36088 .16895 L
.36089 .14723 L
.36091 .12084 L
.36092 .09393 L
.36094 .12905 L
.36095 .14603 L
.36096 .11136 L
.36098 .11257 L
.36099 .14318 L
.36101 .12217 L
.36102 .11959 L
.36103 .11247 L
.36105 .09874 L
.36106 .10591 L
.36107 .12262 L
.36108 .11534 L
.3611 .11985 L
.3611 .16751 L
.36111 .159 L
.36113 .12516 L
Mistroke
.36114 .11215 L
.36115 .12811 L
.36115 .11191 L
.36116 .1888 L
.36118 .14553 L
.36119 .16717 L
.3612 .14749 L
.36121 .13532 L
.36122 .12737 L
.36123 .11219 L
.36124 .14426 L
.36126 .09924 L
.36127 .12752 L
.36129 .11057 L
.3613 .14692 L
.36132 .14195 L
.36133 .10479 L
.36134 .14356 L
.36136 .14416 L
.36137 .1057 L
.36137 .20502 L
.36139 .17244 L
.3614 .13811 L
.36142 .14602 L
.36143 .1193 L
.36144 .11095 L
.36146 .13453 L
.36147 .10851 L
.36149 .13887 L
.3615 .10475 L
.36151 .13822 L
.36153 .10439 L
.36154 .14878 L
.36155 .15382 L
.36156 .17021 L
.36157 .14192 L
.36158 .1047 L
.36159 .14691 L
.36161 .14652 L
.36162 .16459 L
.36162 .10851 L
.36163 .12643 L
.36164 .10597 L
.36166 .15928 L
.36167 .1335 L
.36169 .1099 L
.3617 .10928 L
.36171 .12623 L
.36172 .15292 L
.36173 .18283 L
Mistroke
.36175 .12724 L
.36175 .13497 L
.36176 .12301 L
.36178 .14326 L
.36179 .09753 L
.3618 .16986 L
.36182 .14141 L
.36183 .15791 L
.36184 .14492 L
.36185 .13058 L
.36187 .14239 L
.36188 .13071 L
.3619 .12629 L
.36191 .11646 L
.36192 .12707 L
.36194 .15795 L
.36195 .13093 L
.36197 .11597 L
.36198 .12879 L
.36199 .12149 L
.36206 .09615 L
.36206 .09379 L
.36207 .11724 L
.36208 .15834 L
.36209 .11736 L
.36211 .16898 L
.36211 .14132 L
.36212 .07512 L
.36214 .18612 L
.36215 .15381 L
.36216 .13941 L
.36217 .12586 L
.36218 .09827 L
.36219 .12889 L
.3622 .09858 L
.36221 .16295 L
.36223 .13408 L
.36224 .10925 L
.36226 .14744 L
.36227 .1176 L
.36229 .14186 L
.3623 .12725 L
.36231 .11388 L
.36232 .14007 L
.36233 .16735 L
.36234 .12627 L
.36236 .11116 L
.36237 .13531 L
.36239 .14449 L
.36241 .11075 L
Mistroke
.36242 .12299 L
.36243 .14142 L
.36244 .11876 L
.36245 .1302 L
.36246 .11465 L
.36247 .16078 L
.36248 .13263 L
.36248 .10794 L
.3625 .11465 L
.36251 .1634 L
.36253 .13789 L
.36254 .1084 L
.36255 .11771 L
.36256 .11977 L
.36258 .08646 L
.36259 .13076 L
.3626 .12684 L
.36262 .11896 L
.36263 .11434 L
.36265 .11681 L
.36266 .13052 L
.36267 .13088 L
.36268 .13287 L
.36269 .17107 L
.36271 .10588 L
.36272 .13613 L
.36273 .10652 L
.36274 .09525 L
.36275 .13004 L
.36277 .12144 L
.36278 .12358 L
.36279 .13184 L
.36281 .1449 L
.36282 .09121 L
.36283 .13197 L
.36285 .15308 L
.36286 .13944 L
.36288 .16572 L
.36289 .1308 L
.36289 .13985 L
.36291 .10633 L
.36292 .0938 L
.36293 .152 L
.36294 .14295 L
.36295 .14704 L
.36297 .13401 L
.36298 .15742 L
.36299 .16407 L
.36301 .15172 L
.36302 .1484 L
Mistroke
.36304 .10424 L
.36305 .14461 L
.36306 .15608 L
.36307 .13502 L
.36309 .11437 L
.3631 .12485 L
.36312 .09967 L
.36313 .1535 L
.36315 .15833 L
.36316 .15087 L
.36318 .09877 L
.36319 .17406 L
.3632 .17239 L
.36321 .09538 L
.36322 .10937 L
.36323 .13912 L
.36324 .12182 L
.36325 .12472 L
.36326 .13533 L
.36327 .10556 L
.36329 .14308 L
.3633 .12366 L
.36331 .09546 L
.36333 .13775 L
.36334 .08867 L
.36336 .09913 L
.36337 .15362 L
.36338 .14068 L
.3634 .14094 L
.36341 .14978 L
.36343 .13395 L
.36344 .12895 L
.36344 .14388 L
.36346 .20028 L
.36347 .142 L
.36349 .13854 L
.3635 .12699 L
.36352 .1054 L
.36353 .13088 L
.36353 .1292 L
.36355 .09579 L
.36356 .13263 L
.36357 .09535 L
.36358 .12196 L
.36359 .14539 L
.36359 .14572 L
.3636 .13363 L
.36361 .12438 L
.36362 .13776 L
.36363 .14662 L
Mistroke
.36365 .10587 L
.36366 .11497 L
.36368 .1332 L
.36369 .16502 L
.36371 .1187 L
.36372 .15121 L
.36373 .13172 L
.36375 .12395 L
.36376 .15175 L
.36378 .12544 L
.36379 .1215 L
.36381 .13714 L
.36382 .12795 L
.36384 .14323 L
.36385 .16136 L
.36385 .14777 L
.36387 .09812 L
.36388 .15563 L
.3639 .14862 L
.36391 .15885 L
.36393 .09535 L
.36394 .16485 L
.36395 .13928 L
.36396 .15707 L
.36398 .13259 L
.36399 .1349 L
.364 .12243 L
.36402 .08368 L
.36403 .15497 L
.36404 .11748 L
.36406 .12539 L
.36407 .13529 L
.36408 .15221 L
.36409 .14242 L
.3641 .11194 L
.36412 .13859 L
.36413 .14033 L
.36413 .16386 L
.36415 .17351 L
.36416 .16277 L
.36418 .11158 L
.36419 .15395 L
.3642 .11791 L
.36422 .17734 L
.36423 .09646 L
.36424 .2037 L
.36425 .12284 L
.36426 .19065 L
.36427 .11552 L
.36428 .114 L
Mistroke
.3643 .12794 L
.36431 .1648 L
.36433 .12238 L
.36434 .12313 L
.36435 .17584 L
.36437 .13057 L
.36438 .15662 L
.3644 .1211 L
.36441 .11229 L
.36442 .10884 L
.36443 .15165 L
.36445 .13012 L
.36446 .13278 L
.36448 .14598 L
.36449 .14158 L
.3645 .13528 L
.36452 .14323 L
.36453 .15921 L
.36454 .13808 L
.36455 .15748 L
.36456 .10224 L
.36457 .16396 L
.36459 .15741 L
.36462 .14752 L
.36467 .12941 L
.36469 .09003 L
.3647 .10394 L
.36471 .12333 L
.36472 .1281 L
.36473 .10409 L
.36474 .14275 L
.36475 .17762 L
.36476 .17515 L
.36477 .11661 L
.36478 .10378 L
.36478 .14402 L
.3648 .1329 L
.36482 .15501 L
.36483 .13574 L
.36484 .11575 L
.36485 .11497 L
.36486 .09456 L
.36486 .15202 L
.36487 .09134 L
.36488 .10574 L
.3649 .13553 L
.3649 .13687 L
.36491 .13228 L
.36492 .11342 L
.36493 .14495 L
Mistroke
.36495 .15467 L
.36495 .14729 L
.36496 .09504 L
.36498 .15715 L
.36499 .18051 L
.36499 .16321 L
.36501 .11509 L
.36502 .09348 L
.36504 .14002 L
.36505 .11754 L
.36507 .14486 L
.36508 .15981 L
.36509 .09434 L
.36511 .11257 L
.36512 .16093 L
.36513 .14216 L
.36514 .11995 L
.36516 .15298 L
.36517 .13915 L
.36518 .08849 L
.3652 .0973 L
.36521 .15904 L
.36522 .12913 L
.36524 .13873 L
.36525 .0974 L
.36526 .14132 L
.36528 .1349 L
.36529 .13959 L
.3653 .13241 L
.36531 .13484 L
.36532 .10685 L
.36534 .13645 L
.36535 .10178 L
.36536 .12897 L
.36537 .14412 L
.36538 .11842 L
.36539 .15055 L
.3654 .15658 L
.36541 .13217 L
.36542 .12538 L
.36543 .12456 L
.36544 .14796 L
.36545 .10728 L
.36547 .11219 L
.36548 .16718 L
.3655 .11768 L
.36551 .12444 L
.36553 .09825 L
.36553 .16016 L
.36554 .12967 L
Mistroke
.36556 .15492 L
.36557 .09212 L
.36558 .10367 L
.36559 .13173 L
.3656 .15191 L
.36562 .14875 L
.36563 .1515 L
.36565 .16747 L
.36566 .12982 L
.36566 .14402 L
.36567 .15085 L
.36568 .136 L
.3657 .08188 L
.36571 .10345 L
.36572 .1442 L
.36573 .12258 L
.36574 .11639 L
.36575 .11856 L
.36576 .119 L
.36577 .12637 L
.36578 .13915 L
.36579 .15187 L
.3658 .08648 L
.36581 .12105 L
.36583 .1295 L
.36584 .12079 L
.36585 .10622 L
.36586 .14215 L
.36587 .09625 L
.36589 .1143 L
.3659 .12735 L
.36591 .12235 L
.36592 .14733 L
.36593 .09053 L
.36595 .1121 L
.36596 .16662 L
.36596 .12265 L
.36598 .15553 L
.36599 .17405 L
.36601 .1597 L
.36602 .17451 L
.36604 .16102 L
.36605 .1937 L
.36606 .15338 L
.36608 .14099 L
.36609 .14964 L
.3661 .13271 L
.36611 .16318 L
.36612 .16709 L
.36614 .1377 L
Mistroke
.36615 .11812 L
.36617 .10838 L
.36618 .14891 L
.36619 .14923 L
.36621 .15751 L
.36622 .12109 L
.36624 .13336 L
.36625 .13919 L
.36626 .18136 L
.36627 .11919 L
.36628 .15855 L
.3663 .17357 L
.36631 .14085 L
.36632 .14486 L
.36633 .14526 L
.36634 .18049 L
.36635 .12111 L
.36636 .1372 L
.36637 .13029 L
.36638 .13582 L
.36639 .10221 L
.36641 .0949 L
.36642 .12568 L
.36643 .13397 L
.36645 .13331 L
.36646 .1189 L
.36646 .16364 L
.36648 .15248 L
.36649 .12849 L
.3665 .1266 L
.36651 .11267 L
.36652 .11433 L
.36654 .14934 L
.36656 .13529 L
.36656 .13602 L
.36657 .17393 L
.36659 .11663 L
.3666 .15812 L
.36662 .1181 L
.36663 .14693 L
.36664 .14997 L
.36666 .13702 L
.36667 .15981 L
.36668 .15805 L
.3667 .11827 L
.36671 .13131 L
.36673 .12323 L
.36674 .11636 L
.36674 .11704 L
.36675 .16509 L
Mistroke
.36676 .16067 L
.36677 .10898 L
.36679 .10114 L
.3668 .13073 L
.36681 .11109 L
.36682 .13598 L
.36683 .12538 L
.36684 .14283 L
.36685 .1315 L
.36686 .14682 L
.36687 .1421 L
.36689 .13979 L
.3669 .10952 L
.36691 .17219 L
.36692 .13396 L
.36693 .11341 L
.36695 .15589 L
.36696 .106 L
.36698 .16685 L
.36699 .11314 L
.36701 .11906 L
.36702 .14741 L
.36702 .15341 L
.36703 .14215 L
.36704 .12469 L
.36706 .14498 L
.36707 .13126 L
.36708 .1258 L
.3671 .08683 L
.36711 .13447 L
.36713 .15104 L
.36714 .11062 L
.36715 .12156 L
.36717 .11403 L
.36718 .10258 L
.3672 .14498 L
.36721 .14148 L
.36733 .11294 L
.36736 .1431 L
.36737 .17014 L
.36738 .15778 L
.3674 .09707 L
.3674 .15211 L
.36741 .14208 L
.36742 .1091 L
.36743 .10478 L
.36744 .13431 L
.36745 .14294 L
.36746 .16223 L
.36748 .15981 L
Mistroke
.36749 .0999 L
.36751 .18712 L
.36752 .15376 L
.36753 .1412 L
.36754 .16137 L
.36755 .12424 L
.36757 .16926 L
.36758 .15348 L
.3676 .14447 L
.36761 .12642 L
.36763 .12813 L
.36764 .17296 L
.36765 .16847 L
.36766 .12647 L
.36766 .10633 L
.36767 .14759 L
.36768 .12538 L
.36769 .10524 L
.3677 .08904 L
.36772 .13343 L
.36773 .12231 L
.36775 .14164 L
.36776 .17755 L
.36777 .13432 L
.36778 .14173 L
.3678 .12663 L
.36781 .11558 L
.36782 .13521 L
.36784 .11892 L
.36785 .15636 L
.36787 .15496 L
.36788 .14034 L
.36789 .10868 L
.3679 .13734 L
.36791 .11256 L
.36793 .09418 L
.36794 .16677 L
.36795 .12612 L
.36796 .14525 L
.36797 .12561 L
.36799 .10594 L
.368 .13778 L
.36801 .13915 L
.36803 .115 L
.36804 .13369 L
.36806 .13032 L
.36807 .13222 L
.36807 .14451 L
.36809 .17673 L
.3681 .15339 L
Mistroke
.3681 .09715 L
.36812 .12032 L
.36813 .08075 L
.36815 .15121 L
.36816 .1527 L
.36818 .13403 L
.36819 .10835 L
.3682 .13874 L
.36821 .12071 L
.36823 .15227 L
.36824 .16696 L
.36826 .15304 L
.36827 .12039 L
.36828 .16143 L
.3683 .13272 L
.36831 .1782 L
.36833 .13122 L
.36834 .15109 L
.36836 .15655 L
.36837 .12264 L
.36838 .11506 L
.3684 .09471 L
.36841 .12416 L
.36842 .16718 L
.36843 .13162 L
.36844 .1678 L
.36845 .13148 L
.36846 .15762 L
.36848 .13127 L
.36848 .06002 L
.36849 .16196 L
.36851 .09197 L
.36852 .14607 L
.36854 .18084 L
.36855 .13876 L
.36857 .16685 L
.36858 .11178 L
.36859 .10895 L
.3686 .13343 L
.36862 .12542 L
.36863 .13902 L
.36865 .14444 L
.36866 .15782 L
.36867 .1322 L
.36868 .15131 L
.3687 .11699 L
.36871 .15631 L
.36872 .14411 L
.36874 .09329 L
.36875 .16645 L
Mistroke
.36876 .11556 L
.36877 .1267 L
.36878 .11295 L
.36879 .11332 L
.3688 .10742 L
.36881 .16363 L
.36882 .13599 L
.36882 .11846 L
.36883 .128 L
.36884 .09728 L
.36886 .16856 L
.36887 .13836 L
.36889 .1588 L
.36889 .12491 L
.3689 .09499 L
.36892 .15484 L
.36893 .15068 L
.36894 .145 L
.36896 .10522 L
.36897 .15329 L
.36898 .14245 L
.36899 .14787 L
.369 .14897 L
.36902 .11383 L
.36903 .16169 L
.36904 .1329 L
.36905 .12937 L
.36906 .14357 L
.36908 .12073 L
.36909 .14714 L
.36911 .17051 L
.36912 .11003 L
.36913 .11156 L
.36915 .13598 L
.36916 .13806 L
.36917 .11779 L
.36919 .14775 L
.3692 .14837 L
.36921 .12651 L
.36923 .12719 L
.36924 .15825 L
.36925 .16466 L
.36927 .11066 L
.36928 .14196 L
.3693 .14029 L
.36931 .12034 L
.36933 .12748 L
.36936 .1409 L
.36937 .14002 L
.36937 .12606 L
Mistroke
.36938 .13186 L
.36939 .15764 L
.3694 .14144 L
.36941 .11718 L
.36942 .1352 L
.36943 .13224 L
.36945 .13607 L
.36946 .13638 L
.36948 .12824 L
.36949 .16519 L
.3695 .14552 L
.36952 .13099 L
.36953 .09847 L
.36955 .15024 L
.36956 .14909 L
.36958 .12461 L
.36959 .14965 L
.36961 .14088 L
.36962 .13772 L
.36964 .17145 L
.36964 .15546 L
.36965 .11843 L
.36967 .11563 L
.36968 .11805 L
.36968 .15242 L
.36969 .1735 L
.3697 .10652 L
.36972 .10041 L
.36972 .13824 L
.36973 .13061 L
.36974 .16552 L
.36975 .13635 L
.36976 .14939 L
.36977 .17871 L
.36978 .11562 L
.36978 .14999 L
.3698 .15366 L
.36981 .14217 L
.36983 .09968 L
.36984 .13068 L
.36986 .12687 L
.36987 .12318 L
.36989 .1224 L
.3699 .19718 L
.36991 .11719 L
.36993 .11928 L
.36994 .14025 L
.36996 .14097 L
.36997 .09625 L
.36998 .12275 L
Mistroke
.37 .12946 L
.37001 .10268 L
.37002 .16309 L
.37003 .12001 L
.37005 .12017 L
.37006 .16384 L
.37007 .14739 L
.37009 .13258 L
.3701 .13379 L
.37011 .13001 L
.37013 .15025 L
.37014 .11259 L
.37015 .15132 L
.37017 .1258 L
.37018 .13224 L
.37019 .17309 L
.37021 .13738 L
.37022 .14558 L
.37023 .15319 L
.37024 .14758 L
.37025 .11551 L
.37027 .13215 L
.37028 .14609 L
.3703 .15872 L
.37031 .14206 L
.37032 .11994 L
.37034 .11444 L
.37035 .1346 L
.37036 .14637 L
.37037 .13807 L
.37038 .14617 L
.3704 .15304 L
.37041 .14359 L
.37043 .11574 L
.37044 .12801 L
.37045 .09838 L
.37047 .14504 L
.37048 .16467 L
.37049 .14504 L
.37051 .13297 L
.37052 .13654 L
.37053 .10253 L
.37054 .14689 L
.37055 .10521 L
.37057 .1112 L
.37058 .0978 L
.3706 .10222 L
.37061 .16442 L
.37062 .14419 L
.37063 .13118 L
Mistroke
.37064 .16012 L
.37065 .15303 L
.37066 .13781 L
.37067 .12534 L
.37068 .12317 L
.37069 .13274 L
.37071 .13481 L
.37072 .10934 L
.37073 .13843 L
.37074 .15866 L
.37075 .15885 L
.37077 .14107 L
.37078 .14022 L
.3708 .07231 L
.37081 .15169 L
.37082 .15177 L
.37083 .15199 L
.37085 .12071 L
.37086 .13463 L
.37089 .16432 L
.3709 .17059 L
.37091 .19086 L
.37093 .14307 L
.37094 .13598 L
.37096 .17291 L
.37097 .08784 L
.37098 .12298 L
.371 .11199 L
.37101 .15667 L
.37102 .10273 L
.37103 .13726 L
.37104 .141 L
.37106 .1243 L
.37107 .1098 L
.37109 .14756 L
.3711 .1343 L
.3711 .10895 L
.37112 .18251 L
.37113 .09861 L
.37114 .13873 L
.37115 .14317 L
.37116 .17122 L
.37116 .15847 L
.37117 .12043 L
.37118 .17579 L
.37119 .15874 L
.3712 .13516 L
.37122 .14381 L
.37123 .11462 L
.37125 .12415 L
Mistroke
.37126 .12611 L
.37128 .14095 L
.37129 .11296 L
.37131 .13094 L
.37132 .20083 L
.37133 .09913 L
.37135 .1435 L
.37136 .11165 L
.37137 .12803 L
.37139 .11377 L
.37141 .1602 L
.37141 .14848 L
.37142 .15571 L
.37144 .10464 L
.37145 .14373 L
.37147 .13012 L
.37148 .14548 L
.37149 .1352 L
.37151 .16091 L
.37152 .12702 L
.37153 .10796 L
.37154 .10696 L
.37156 .1051 L
.37157 .11769 L
.37159 .11052 L
.3716 .15772 L
.37161 .11501 L
.37163 .11449 L
.37164 .13571 L
.37164 .11812 L
.37166 .13009 L
.37167 .11063 L
.37169 .13247 L
.3717 .11785 L
.37172 .18337 L
.37173 .14564 L
.37174 .18496 L
.37176 .14102 L
.37177 .13452 L
.37179 .15073 L
.3718 .12021 L
.37182 .13513 L
.37183 .14707 L
.37184 .1556 L
.37186 .13404 L
.37187 .15189 L
.37188 .12322 L
.37189 .10812 L
.37191 .159 L
.37192 .16081 L
Mistroke
.37193 .12599 L
.37195 .14887 L
.37196 .11613 L
.37197 .16964 L
.37199 .12361 L
.372 .12968 L
.37201 .13835 L
.37203 .16014 L
.37204 .13075 L
.37205 .1435 L
.37207 .13173 L
.37208 .14466 L
.37209 .13104 L
.3721 .1536 L
.37211 .16086 L
.37213 .13552 L
.37214 .12037 L
.37216 .12505 L
.37217 .13949 L
.37219 .13145 L
.3722 .10487 L
.37221 .10799 L
.37223 .12851 L
.37224 .17134 L
.37225 .13387 L
.37227 .13541 L
.37228 .12122 L
.3723 .10985 L
.37231 .10441 L
.37232 .13325 L
.37233 .12336 L
.37235 .13921 L
.37236 .12112 L
.37237 .16612 L
.37239 .12967 L
.3724 .15583 L
.37242 .15529 L
.37243 .14821 L
.37244 .11329 L
.37245 .15626 L
.37247 .15973 L
.37248 .12826 L
.3725 .11185 L
.37251 .17497 L
.37252 .13964 L
.37254 .14487 L
.37254 .15095 L
.37255 .1863 L
.37257 .15635 L
.37258 .14138 L
Mistroke
.3726 .12496 L
.3726 .11591 L
.37261 .14419 L
.37263 .16006 L
.37264 .09558 L
.37265 .15314 L
.37267 .14408 L
.37268 .13031 L
.37269 .13064 L
.37271 .11868 L
.37272 .17253 L
.37273 .16799 L
.37274 .13747 L
.37275 .1496 L
.37276 .10961 L
.37277 .12846 L
.37279 .14211 L
.3728 .1246 L
.37282 .12639 L
.37283 .11336 L
.37284 .1253 L
.37285 .09927 L
.37287 .13351 L
.37288 .11191 L
.3729 .12453 L
.37291 .16268 L
.37292 .12478 L
.37294 .15696 L
.37295 .17641 L
.37296 .11004 L
.37298 .12443 L
.37299 .13517 L
.37301 .13645 L
.37302 .15146 L
.37304 .13991 L
.37305 .14807 L
.37307 .12615 L
.37307 .14369 L
.37308 .15405 L
.37309 .16122 L
.3731 .14406 L
.37311 .11441 L
.37313 .11093 L
.37314 .13751 L
.37316 .12467 L
.37317 .14679 L
.37319 .11617 L
.3732 .11409 L
.37321 .15106 L
.37323 .13213 L
Mistroke
.37324 .1379 L
.37326 .10969 L
.37327 .10937 L
.37329 .12969 L
.3733 .15708 L
.37332 .14317 L
.37333 .12118 L
.37334 .15021 L
.37335 .10464 L
.37336 .17188 L
.37338 .11853 L
.37339 .14948 L
.37339 .1511 L
.37341 .1692 L
.37342 .11822 L
.37343 .13608 L
.37343 .1643 L
.37344 .15074 L
.37345 .13716 L
.37346 .16576 L
.37347 .12335 L
.37348 .1621 L
.37348 .14436 L
.37349 .11599 L
.37351 .12745 L
.37352 .14367 L
.37354 .08589 L
.37355 .13289 L
.37357 .10776 L
.37358 .14472 L
.3736 .15098 L
.37361 .13857 L
.37362 .1814 L
.37364 .10565 L
.37365 .10789 L
.37367 .12299 L
.37367 .10612 L
.37368 .17974 L
.3737 .16685 L
.37371 .14759 L
.37373 .12884 L
.37374 .18534 L
.37376 .14704 L
.37377 .12475 L
.37378 .09263 L
.3738 .12458 L
.37381 .10063 L
.37382 .15025 L
.37384 .13637 L
.37385 .14429 L
Mistroke
.37386 .16008 L
.37388 .16592 L
.37389 .14848 L
.3739 .1338 L
.37392 .1385 L
.37395 .12524 L
.37395 .11959 L
.37396 .11991 L
.37398 .1659 L
.37399 .11607 L
.37401 .12145 L
.37402 .15202 L
.37403 .16116 L
.37405 .15676 L
.37406 .12742 L
.37407 .16984 L
.37408 .1356 L
.3741 .1446 L
.37411 .15629 L
.37412 .12797 L
.37414 .12306 L
.37415 .12311 L
.37416 .08841 L
.37418 .1276 L
.37419 .18145 L
.37421 .10084 L
.37422 .13895 L
.37423 .17899 L
.37424 .14233 L
.37425 .17507 L
.37427 .1109 L
.37428 .1401 L
.37428 .11812 L
.3743 .0905 L
.37431 .17653 L
.37432 .11358 L
.37433 .16997 L
.37433 .10983 L
.37435 .16726 L
.37436 .13131 L
.37437 .09994 L
.37438 .152 L
.3744 .15124 L
.37441 .15233 L
.37443 .14252 L
.37444 .16098 L
.37446 .17766 L
.37447 .1459 L
.37448 .13767 L
.37449 .14295 L
Mistroke
.3745 .13065 L
.37451 .15658 L
.37452 .12176 L
.37453 .11858 L
.37455 .1223 L
.37456 .12583 L
.37458 .08232 L
.37459 .14827 L
.3746 .1342 L
.3746 .12981 L
.37461 .17336 L
.37463 .11617 L
.37464 .16052 L
.37465 .14988 L
.37466 .14 L
.37468 .17276 L
.37468 .13224 L
.37469 .13748 L
.3747 .10666 L
.37471 .18563 L
.37472 .14285 L
.37473 .11426 L
.37474 .14729 L
.37476 .08604 L
.37477 .14933 L
.37479 .13947 L
.3748 .11537 L
.3748 .11625 L
.37481 .12432 L
.37482 .15522 L
.37483 .11585 L
.37484 .10416 L
.37485 .14067 L
.37487 .15163 L
.37488 .08712 L
.37489 .14499 L
.37491 .13057 L
.37492 .11481 L
.37492 .15213 L
.37494 .10955 L
.37495 .1115 L
.37497 .1201 L
.37498 .1407 L
.37499 .13994 L
.375 .13834 L
.37501 .13286 L
.37503 .14684 L
.37504 .111 L
.37505 .13541 L
.37507 .14292 L
Mistroke
.37508 .12812 L
.37509 .12491 L
.3751 .13423 L
.37512 .17353 L
.37512 .11991 L
.37513 .15474 L
.37515 .17324 L
.37516 .15957 L
.37518 .11588 L
.37519 .1551 L
.3752 .13827 L
.37522 .17759 L
.37523 .15776 L
.37524 .15247 L
.37525 .15981 L
.37527 .1248 L
.37528 .12388 L
.3753 .14337 L
.37531 .14836 L
.37532 .13845 L
.37534 .13909 L
.37535 .17265 L
.37537 .14441 L
.37538 .1165 L
.3754 .11004 L
.37541 .11884 L
.37542 .15997 L
.37543 .09676 L
.37544 .17076 L
.37546 .16147 L
.37547 .09642 L
.37547 .11353 L
.37549 .15465 L
.3755 .14091 L
.37551 .14274 L
.37552 .11962 L
.37553 .11799 L
.37555 .14997 L
.37556 .13796 L
.37558 .15836 L
.37559 .09164 L
.37561 .12651 L
.37562 .123 L
.37563 .14659 L
.37565 .15595 L
.37566 .13721 L
.37568 .13632 L
.37568 .15033 L
.37569 .14126 L
.37571 .15994 L
Mistroke
.37572 .16051 L
.37574 .12688 L
.37575 .14399 L
.37577 .12555 L
.37578 .12127 L
.37578 .12872 L
.3758 .14291 L
.37581 .15769 L
.37582 .14872 L
.37582 .15554 L
.37583 .15065 L
.37584 .1644 L
.37585 .13618 L
.37586 .1244 L
.37587 .10579 L
.37588 .14253 L
.3759 .15974 L
.37591 .17987 L
.37592 .10584 L
.37593 .13349 L
.37594 .16653 L
.37596 .13653 L
.37597 .19122 L
.37598 .16173 L
.376 .1284 L
.37601 .12998 L
.37603 .13624 L
.37603 .17518 L
.37604 .12996 L
.37606 .0835 L
.37607 .15291 L
.37608 .11081 L
.37609 .12015 L
.37611 .13849 L
.37612 .1354 L
.37613 .16913 L
.37615 .16772 L
.37616 .09308 L
.37618 .13068 L
.37619 .11329 L
.3762 .10397 L
.37622 .13319 L
.37623 .10719 L
.37625 .14375 L
.37626 .09297 L
.37628 .12594 L
.37629 .16718 L
.3763 .15452 L
.37631 .13754 L
.37633 .14878 L
Mistroke
.37634 .13839 L
.37635 .14548 L
.37637 .11283 L
.37638 .20534 L
.37639 .13816 L
.3764 .16579 L
.37641 .11719 L
.37642 .12746 L
.37643 .13408 L
.37645 .16911 L
.37645 .12821 L
.37646 .14522 L
.37648 .09704 L
.37649 .07418 L
.37651 .14408 L
.37652 .13929 L
.37654 .20008 L
.37655 .1449 L
.37656 .13356 L
.37657 .14058 L
.37659 .12433 L
.3766 .12638 L
.37662 .14932 L
.37663 .13732 L
.37664 .16052 L
.37665 .17118 L
.37667 .11915 L
.37668 .14136 L
.37669 .17061 L
.37671 .10801 L
.37672 .06121 L
.37673 .11335 L
.37674 .1039 L
.37675 .13971 L
.37676 .15447 L
.37677 .16351 L
.37678 .11434 L
.37678 .14371 L
.37679 .1696 L
.3768 .1572 L
.37681 .1578 L
.37682 .16701 L
.37684 .16162 L
.37685 .12038 L
.37687 .14605 L
.37688 .14074 L
.3769 .0927 L
.37691 .14403 L
.37693 .09737 L
.37694 .14188 L
Mistroke
.37695 .12672 L
.37696 .10647 L
.37697 .13676 L
.37698 .13921 L
.37699 .12649 L
.377 .15427 L
.37702 .15143 L
.37703 .14726 L
.37705 .13915 L
.37706 .13088 L
.37708 .15933 L
.37709 .17414 L
.3771 .16791 L
.37712 .12146 L
.37713 .13184 L
.37715 .13965 L
.37716 .17036 L
.37717 .1425 L
.37719 .13328 L
.3772 .14365 L
.37722 .08961 L
.37723 .17613 L
.37724 .15123 L
.37726 .13971 L
.37727 .10982 L
.37728 .12674 L
.3773 .13106 L
.37731 .11738 L
.37732 .14306 L
.37733 .14366 L
.37734 .19 L
.37735 .10754 L
.37737 .11494 L
.37738 .16792 L
.37739 .17017 L
.37741 .13293 L
.37742 .10553 L
.37743 .14712 L
.37744 .12818 L
.37746 .18894 L
.37746 .11915 L
.37747 .14649 L
.37749 .16231 L
.3775 .15208 L
.37752 .12435 L
.37753 .16314 L
.37754 .16253 L
.37756 .13108 L
.37757 .11308 L
.37758 .13973 L
Mistroke
.3776 .13684 L
.37761 .12586 L
.37762 .1066 L
.37764 .1516 L
.37765 .14631 L
.37767 .12625 L
.37768 .15349 L
.37769 .15044 L
.37771 .12873 L
.37772 .12177 L
.37774 .13748 L
.37775 .12187 L
.37777 .17306 L
.37778 .18404 L
.37779 .12449 L
.3778 .11578 L
.37781 .1395 L
.37781 .09711 L
.37783 .14927 L
.37784 .12879 L
.37784 .14205 L
.37786 .16168 L
.37787 .15636 L
.37789 .10902 L
.3779 .10341 L
.37792 .09351 L
.37793 .11302 L
.37794 .1674 L
.37796 .17429 L
.37797 .16854 L
.37799 .16223 L
.378 .13962 L
.37801 .11389 L
.37803 .13972 L
.37804 .10806 L
.37806 .12724 L
.37807 .12363 L
.37808 .14961 L
.37809 .11629 L
.3781 .11738 L
.37811 .20592 L
.37812 .13483 L
.37814 .12562 L
.37815 .13337 L
.37815 .13589 L
.37816 .14186 L
.37817 .11521 L
.37818 .14274 L
.37819 .14439 L
.3782 .15797 L
Mistroke
.37821 .12076 L
.37822 .12677 L
.37824 .11073 L
.37825 .10969 L
.37827 .12756 L
.37828 .15413 L
.3783 .16466 L
.37831 .13886 L
.37832 .1501 L
.37834 .13867 L
.37835 .1378 L
.37836 .16662 L
.37838 .12103 L
.37839 .17339 L
.37841 .12147 L
.37842 .13071 L
.37843 .12904 L
.37844 .0995 L
.37846 .12696 L
.37847 .17633 L
.37848 .11628 L
.3785 .16339 L
.37851 .16527 L
.37853 .13261 L
.37854 .14148 L
.37855 .14448 L
.37856 .13767 L
.37858 .11378 L
.37859 .1381 L
.3786 .15335 L
.37862 .09392 L
.37863 .16226 L
.37865 .15506 L
.37865 .12358 L
.37866 .13751 L
.37868 .13514 L
.37869 .1355 L
.3787 .21998 L
.37872 .16204 L
.37874 .17213 L
.37875 .15166 L
.37876 .1191 L
.37878 .12768 L
.37879 .14233 L
.3788 .12317 L
.37882 .11716 L
.37883 .11757 L
.37885 .1585 L
.37886 .15264 L
.37888 .13468 L
Mistroke
.37889 .14703 L
.37889 .13291 L
.37891 .12802 L
.37893 .11511 L
.37894 .11279 L
.37895 .14329 L
.37897 .12287 L
.37898 .14239 L
.37899 .12529 L
.379 .17197 L
.37902 .1173 L
.37903 .1627 L
.37904 .13639 L
.37906 .16157 L
.37907 .13588 L
.37909 .14923 L
.3791 .11536 L
.37911 .16601 L
.37912 .14016 L
.37913 .13434 L
.37914 .13069 L
.37916 .12362 L
.37918 .12077 L
.37919 .15116 L
.3792 .14771 L
.37922 .1444 L
.37923 .14937 L
.37924 .17824 L
.37926 .17383 L
.37927 .16495 L
.37927 .10951 L
.37929 .12387 L
.3793 .14731 L
.37931 .146 L
.37932 .15453 L
.37934 .19213 L
.37935 .09918 L
.37937 .13614 L
.37938 .14314 L
.37939 .1622 L
.3794 .13038 L
.37942 .14248 L
.37943 .12385 L
.37945 .15547 L
.37946 .14871 L
.37947 .13122 L
.37949 .15992 L
.3795 .15876 L
.37951 .15139 L
.37953 .14832 L
Mistroke
.37955 .11157 L
.37956 .15948 L
.37957 .15959 L
.37959 .15394 L
.3796 .16036 L
.37961 .16538 L
.37962 .12684 L
.37963 .14118 L
.37964 .15901 L
.37966 .15269 L
.37967 .15088 L
.37969 .11758 L
.3797 .13462 L
.37971 .12055 L
.37973 .18065 L
.37974 .16747 L
.37976 .11427 L
.37977 .1305 L
.37978 .11806 L
.37979 .15158 L
.3798 .10013 L
.37982 .15763 L
.37983 .1395 L
.37984 .11671 L
.37985 .14354 L
.37986 .14082 L
.37988 .08178 L
.37989 .14328 L
.3799 .13812 L
.37992 .1657 L
.37993 .11201 L
.37994 .14378 L
.37996 .12452 L
.37997 .127 L
.37998 .1302 L
.38 .16934 L
.38001 .11161 L
.38003 .14583 L
.38004 .17379 L
.38006 .09996 L
.38007 .16522 L
.38009 .17238 L
.38009 .16882 L
.3801 .14571 L
.38011 .12334 L
.38012 .11699 L
.38013 .09566 L
.38015 .17541 L
.38016 .14747 L
.38018 .14344 L
Mistroke
.38019 .13404 L
.38021 .14305 L
.38022 .14432 L
.38023 .17056 L
.38025 .1118 L
.38026 .14166 L
.38028 .09573 L
.38029 .15629 L
.38031 .11398 L
.38032 .14887 L
.38034 .08949 L
.38035 .13895 L
.38036 .16322 L
.38037 .18636 L
.38038 .1353 L
.3804 .14079 L
.3804 .13561 L
.38041 .18014 L
.38042 .1296 L
.38043 .15442 L
.38045 .13448 L
.38045 .13321 L
.38046 .14137 L
.38047 .12445 L
.38048 .16791 L
.38049 .10822 L
.3805 .16684 L
.3805 .16377 L
.38051 .13174 L
.38053 .17359 L
.38054 .1041 L
.38056 .14551 L
.38057 .12393 L
.38059 .13721 L
.3806 .17096 L
.38062 .14131 L
.38063 .16609 L
.38064 .11424 L
.38066 .13648 L
.38067 .14875 L
.38069 .20491 L
.3807 .19137 L
.38071 .13072 L
.38073 .11187 L
.38074 .16193 L
.38075 .10313 L
.38076 .14635 L
.38078 .13847 L
.38079 .13175 L
.3808 .09815 L
Mistroke
.38082 .14432 L
.38083 .17207 L
.38084 .13523 L
.38086 .12246 L
.38087 .09258 L
.38088 .15647 L
.3809 .08328 L
.38091 .12508 L
.38092 .12345 L
.38094 .12388 L
.38095 .16793 L
.38096 .11594 L
.38097 .18144 L
.38098 .11862 L
.381 .09883 L
.38101 .13122 L
.38103 .12523 L
.38104 .19602 L
.38106 .17243 L
.38107 .13219 L
.38108 .15926 L
.3811 .14324 L
.38111 .14587 L
.38113 .16178 L
.38114 .1601 L
.38115 .10897 L
.38117 .17945 L
.38118 .18188 L
.38119 .12914 L
.3812 .13635 L
.38122 .16819 L
.38123 .12394 L
.38124 .16304 L
.38126 .13606 L
.38127 .1148 L
.38129 .12492 L
.3813 .14121 L
.38131 .14062 L
.38132 .08659 L
.38134 .13121 L
.38135 .14901 L
.38137 .1476 L
.38138 .15439 L
.38139 .1458 L
.3814 .11368 L
.38141 .10843 L
.38142 .12221 L
.38144 .16325 L
.38145 .096 L
.38147 .16476 L
Mistroke
.38147 .15584 L
.38148 .11669 L
.3815 .09919 L
.38151 .12977 L
.38152 .13314 L
.38154 .15276 L
.38155 .14261 L
.38157 .16721 L
.38158 .13212 L
.38159 .1236 L
.3816 .08665 L
.3816 .10624 L
.38161 .15754 L
.38163 .17237 L
.38164 .17632 L
.38166 .16017 L
.38167 .10209 L
.38169 .17897 L
.3817 .15515 L
.38171 .15039 L
.38173 .12931 L
.38174 .11694 L
.38175 .17455 L
.38177 .12665 L
.38178 .17555 L
.38179 .10934 L
.38181 .10828 L
.38182 .17706 L
.38184 .13357 L
.38185 .16589 L
.38186 .16523 L
.38188 .15312 L
.38189 .10296 L
.38191 .11914 L
.38192 .12689 L
.38194 .08809 L
.38195 .15163 L
.38195 .13217 L
.38196 .11445 L
.38197 .12618 L
.38199 .12659 L
.382 .11809 L
.38201 .15244 L
.38203 .12631 L
.38204 .10543 L
.38206 .13844 L
.38207 .12845 L
.38208 .12549 L
.3821 .15015 L
.38211 .19294 L
Mistroke
.38213 .12507 L
.38214 .16117 L
.38216 .10944 L
.38217 .10732 L
.38219 .15031 L
.3822 .13188 L
.38222 .10786 L
.38223 .14162 L
.38223 .15167 L
.38225 .14826 L
.38226 .10879 L
.38226 .11946 L
.38227 .15069 L
.38228 .14744 L
.3823 .13733 L
.38231 .08598 L
.38231 .14979 L
.38232 .17015 L
.38233 .11008 L
.38235 .16223 L
.38236 .14448 L
.38238 .14789 L
.38239 .14325 L
.38239 .15249 L
.38241 .14288 L
.38242 .14278 L
.38244 .13264 L
.38245 .14052 L
.38247 .13138 L
.38248 .16843 L
.38249 .15403 L
.38251 .16211 L
.38252 .14014 L
.38253 .19147 L
.38254 .18318 L
.38255 .16351 L
.38256 .10978 L
.38256 .18783 L
.38257 .13256 L
.38258 .15896 L
.38259 .14615 L
.3826 .15057 L
.38262 .12896 L
.38263 .13648 L
.38265 .17656 L
.38266 .14553 L
.38268 .1363 L
.38269 .13541 L
.38271 .12106 L
.38271 .13971 L
Mistroke
.38272 .14679 L
.38273 .1161 L
.38274 .16489 L
.38275 .11142 L
.38275 .14843 L
.38277 .17223 L
.38278 .14815 L
.38279 .18058 L
.3828 .12406 L
.38282 .10108 L
.38283 .12021 L
.38283 .13315 L
.38285 .12277 L
.38286 .1115 L
.38287 .13434 L
.38287 .15402 L
.38288 .13052 L
.3829 .14224 L
.38291 .1853 L
.38292 .12323 L
.38292 .15016 L
.38293 .11268 L
.38294 .10154 L
.38295 .14887 L
.38296 .15534 L
.38298 .13479 L
.38299 .17114 L
.383 .16249 L
.38301 .1348 L
.38302 .17959 L
.38303 .14142 L
.38303 .13824 L
.38304 .13578 L
.38305 .13176 L
.38306 .16431 L
.38307 .13918 L
.38308 .18398 L
.38309 .12825 L
.38309 .13339 L
.3831 .13142 L
.38311 .13017 L
.38313 .16854 L
.38313 .12199 L
.38314 .17504 L
.38316 .1204 L
.38317 .12295 L
.38317 .16459 L
.38319 .12867 L
.3832 .10971 L
.38322 .12521 L
Mistroke
.38323 .14675 L
.38324 .13161 L
.38326 .14747 L
.38327 .17142 L
.38328 .13052 L
.38329 .172 L
.3833 .14558 L
.38331 .15138 L
.38332 .16808 L
.38334 .1876 L
.38335 .11354 L
.38336 .14145 L
.38337 .15866 L
.38338 .15367 L
.3834 .10016 L
.38341 .13735 L
.38343 .14264 L
.38344 .12663 L
.38346 .15312 L
.38347 .12634 L
.38348 .1652 L
.3835 .12009 L
.38351 .11811 L
.38351 .15284 L
.38352 .1612 L
.38353 .11257 L
.38355 .14801 L
.38356 .13794 L
.38358 .10394 L
.38359 .13601 L
.3836 .13092 L
.38362 .173 L
.38363 .13886 L
.38365 .15134 L
.38366 .12191 L
.38367 .16631 L
.38369 .13033 L
.38371 .15656 L
.38372 .14241 L
.38373 .12392 L
.38375 .12657 L
.38376 .16487 L
.38377 .15185 L
.38379 .11259 L
.3838 .16411 L
.38381 .14141 L
.38383 .16016 L
.38384 .14194 L
.38385 .16998 L
.38387 .1885 L
Mistroke
.38388 .15454 L
.3839 .09452 L
.38391 .13487 L
.38392 .10883 L
.38394 .14799 L
.38395 .11852 L
.38397 .13378 L
.38398 .15409 L
.384 .14915 L
.38401 .15039 L
.38403 .13375 L
.38404 .12833 L
.38404 .15088 L
.38406 .16403 L
.38407 .09946 L
.38409 .09607 L
.3841 .12775 L
.38412 .09648 L
.38413 .1295 L
.38414 .10929 L
.38415 .11921 L
.38417 .12828 L
.38418 .12439 L
.38419 .13265 L
.38421 .12731 L
.38422 .12196 L
.38423 .14968 L
.38425 .12887 L
.38426 .15364 L
.38427 .14819 L
.38428 .12003 L
.38429 .16108 L
.38431 .13722 L
.38432 .19629 L
.38432 .17155 L
.38434 .14272 L
.38435 .09075 L
.38437 .12586 L
.38438 .14677 L
.38439 .11866 L
.38441 .10961 L
.38442 .11678 L
.38443 .10607 L
.38444 .17988 L
.38445 .16403 L
.38446 .17909 L
.38447 .12839 L
.38449 .11262 L
.3845 .14398 L
.38452 .14929 L
Mistroke
.38453 .14636 L
.38454 .11001 L
.38456 .18308 L
.38457 .12237 L
.38458 .14699 L
.38459 .12684 L
.38461 .16462 L
.38462 .15299 L
.38464 .19101 L
.38465 .16015 L
.38467 .10488 L
.38468 .152 L
.38469 .13007 L
.38471 .18351 L
.38472 .14799 L
.38474 .14413 L
.38475 .13144 L
.38476 .11153 L
.38478 .11174 L
.38479 .12851 L
.3848 .12807 L
.38481 .14274 L
.38483 .14044 L
.38484 .15102 L
.38484 .15165 L
.38486 .17602 L
.38487 .10955 L
.38489 .1614 L
.3849 .11039 L
.38491 .16385 L
.38493 .16026 L
.38494 .17396 L
.38496 .11867 L
.38497 .14352 L
.38498 .11602 L
.385 .10806 L
.38501 .1099 L
.38503 .17672 L
.38504 .11119 L
.38506 .12645 L
.38507 .10924 L
.38508 .13371 L
.38509 .15559 L
.3851 .12581 L
.38511 .10295 L
.38512 .18449 L
.38512 .14606 L
.38514 .10236 L
.38515 .13969 L
.38516 .13898 L
Mistroke
.38516 .12071 L
.38517 .13398 L
.3852 .11694 L
.38521 .10537 L
.38522 .10649 L
.38524 .19934 L
.38524 .10181 L
.38525 .13743 L
.38527 .10726 L
.38528 .13203 L
.38529 .14256 L
.3853 .15034 L
.38531 .1506 L
.38533 .13903 L
.38534 .16088 L
.38536 .15948 L
.38537 .17719 L
.38538 .14198 L
.38538 .1388 L
.38539 .14269 L
.38541 .19157 L
.38542 .16582 L
.38543 .14841 L
.38544 .17483 L
.38545 .13116 L
.38546 .12728 L
.38547 .15113 L
.38548 .12811 L
.38548 .13216 L
.38549 .1563 L
.38551 .09674 L
.38552 .11945 L
.38553 .14094 L
.38554 .16135 L
.38555 .13257 L
.38557 .16562 L
.38558 .12946 L
.38559 .12875 L
.38561 .13924 L
.38562 .1612 L
.38563 .16673 L
.38564 .12627 L
.38565 .16018 L
.38566 .10294 L
.38567 .12644 L
.38567 .11723 L
.38569 .16782 L
.3857 .14548 L
.38572 .13525 L
.38573 .10831 L
Mistroke
.38573 .12207 L
.38575 .12842 L
.38576 .14449 L
.38577 .12882 L
.38577 .17149 L
.38578 .12167 L
.3858 .1312 L
.38581 .14657 L
.38583 .12989 L
.38584 .14175 L
.38585 .13874 L
.38586 .11729 L
.38587 .14284 L
.38588 .16502 L
.38588 .11083 L
.38589 .13396 L
.3859 .12754 L
.38591 .15487 L
.38592 .14889 L
.38593 .11415 L
.38594 .1331 L
.38594 .11235 L
.38595 .1249 L
.38596 .11252 L
.38598 .11722 L
.38598 .14419 L
.38599 .1368 L
.38601 .13135 L
.38602 .13649 L
.38602 .16846 L
.38604 .14559 L
.38605 .11801 L
.38607 .18407 L
.38608 .1565 L
.38609 .15346 L
.38611 .1208 L
.38612 .10172 L
.38613 .14954 L
.38614 .11372 L
.38615 .14585 L
.38616 .15778 L
.38617 .14499 L
.38617 .14825 L
.38619 .15663 L
.3862 .09645 L
.38622 .13201 L
.38623 .15145 L
.38623 .13033 L
.38625 .16019 L
.38626 .15525 L
Mistroke
.38628 .17679 L
.38629 .13659 L
.3863 .08954 L
.38631 .14746 L
.38632 .09209 L
.38633 .10652 L
.38634 .11471 L
.38636 .12307 L
.38637 .09617 L
.38638 .16701 L
.3864 .13804 L
.38641 .12363 L
.38642 .15789 L
.38644 .07233 L
.38645 .14741 L
.38647 .14647 L
.38648 .14415 L
.3865 .1365 L
.38651 .14496 L
.38653 .1853 L
.38654 .12959 L
.38655 .13716 L
.38656 .17359 L
.38657 .13781 L
.38658 .14657 L
.38659 .1413 L
.3866 .12612 L
.38661 .12352 L
.38662 .13816 L
.38663 .11072 L
.38664 .13966 L
.38665 .1329 L
.38666 .18551 L
.38666 .12427 L
.38667 .15324 L
.38668 .13638 L
.38669 .15396 L
.3867 .1503 L
.38672 .14873 L
.38673 .15241 L
.38675 .16236 L
.38676 .13718 L
.38678 .1108 L
.38679 .12119 L
.3868 .14483 L
.38682 .10381 L
.38683 .16413 L
.38685 .16482 L
.38686 .15532 L
.38687 .15545 L
Mistroke
.38689 .15138 L
.3869 .15022 L
.38691 .13667 L
.38692 .10809 L
.38694 .12894 L
.38695 .14656 L
.38697 .12989 L
.38698 .14037 L
.38699 .15845 L
.38701 .12214 L
.38702 .14076 L
.38703 .13696 L
.38704 .17753 L
.38706 .15033 L
.38707 .126 L
.38708 .15657 L
.3871 .17696 L
.38711 .16072 L
.38713 .10156 L
.38713 .11228 L
.38714 .10539 L
.38716 .14283 L
.38717 .13635 L
.38718 .13597 L
.3872 .11456 L
.38722 .14456 L
.38723 .13535 L
.38724 .16078 L
.38726 .18729 L
.38727 .11236 L
.38728 .11149 L
.3873 .12439 L
.38731 .10892 L
.38733 .15796 L
.38734 .16091 L
.38736 .17101 L
.38737 .14072 L
.38737 .11865 L
.38739 .14853 L
.3874 .11068 L
.38742 .11152 L
.38743 .14517 L
.38745 .1417 L
.38746 .10896 L
.38747 .16016 L
.38748 .15558 L
.3875 .16063 L
.38751 .15213 L
.38754 .14112 L
.38755 .14957 L
Mistroke
.38756 .12716 L
.38757 .14858 L
.38758 .13577 L
.3876 .1388 L
.38761 .09646 L
.38762 .11497 L
.38764 .14057 L
.38765 .14984 L
.38767 .13334 L
.38768 .12854 L
.3877 .12319 L
.3877 .1644 L
.38771 .14292 L
.38773 .14687 L
.38774 .13764 L
.38775 .11246 L
.38777 .16159 L
.38778 .10647 L
.38779 .12685 L
.38781 .11917 L
.38782 .13988 L
.38784 .1215 L
.38785 .15893 L
.38786 .16148 L
.38787 .09849 L
.38788 .19133 L
.3879 .12816 L
.38791 .15211 L
.38792 .13468 L
.38793 .17245 L
.38794 .13177 L
.38795 .12839 L
.38796 .12941 L
.38798 .13228 L
.38799 .09934 L
.38801 .13631 L
.38802 .12653 L
.38803 .12901 L
.38804 .14293 L
.38805 .1222 L
.38807 .16316 L
.38808 .12954 L
.3881 .14731 L
.38811 .16136 L
.38812 .15106 L
.38813 .16509 L
.38814 .16153 L
.38816 .15852 L
.38817 .14457 L
.38818 .13645 L
Mistroke
.38819 .15792 L
.3882 .12159 L
.38821 .14257 L
.38822 .1435 L
.38824 .12116 L
.38825 .15602 L
.38827 .11382 L
.38828 .20292 L
.3883 .13308 L
.38831 .13649 L
.38832 .15913 L
.38833 .14576 L
.38834 .19433 L
.38836 .08475 L
.38837 .1468 L
.38838 .12467 L
.3884 .17564 L
.38841 .16444 L
.38843 .10265 L
.38844 .15314 L
.38846 .12464 L
.38847 .11001 L
.38848 .11419 L
.3885 .13303 L
.38851 .15233 L
.38852 .13722 L
.38854 .15909 L
.38855 .1418 L
.38856 .12795 L
.38858 .125 L
.3886 .1754 L
.38861 .13856 L
.38862 .13645 L
.38864 .12996 L
.38865 .13909 L
.38867 .13069 L
.38868 .15502 L
.38868 .12631 L
.3887 .1162 L
.38871 .11873 L
.38873 .13893 L
.38874 .11113 L
.38875 .15188 L
.38877 .15244 L
.38878 .10687 L
.38879 .16827 L
.3888 .13712 L
.38881 .10862 L
.38883 .1163 L
.38884 .11821 L
Mistroke
.38886 .16334 L
.38886 .15114 L
.38887 .14788 L
.38889 .13367 L
.3889 .12504 L
.3889 .18384 L
.38891 .14049 L
.38892 .13101 L
.38894 .13961 L
.38895 .11778 L
.38897 .16805 L
.38898 .17633 L
.389 .13517 L
.389 .15769 L
.38901 .1149 L
.38903 .10713 L
.38904 .13501 L
.38906 .13441 L
.38907 .13109 L
.38909 .15085 L
.3891 .16761 L
.38911 .13045 L
.38913 .12076 L
.38914 .12098 L
.38916 .14902 L
.38917 .15006 L
.38919 .11887 L
.3892 .15313 L
.38921 .14686 L
.38923 .17133 L
.38924 .16059 L
.38925 .13315 L
.38926 .13422 L
.38928 .13639 L
.38929 .11446 L
.3893 .1061 L
.38932 .1652 L
.38933 .13507 L
.38934 .13963 L
.38936 .14521 L
.38937 .14614 L
.38938 .14033 L
.3894 .15576 L
.38941 .16518 L
.38942 .16529 L
.38944 .19459 L
.38945 .12256 L
.38946 .08472 L
.38947 .1442 L
.38948 .15816 L
Mistroke
.3895 .14879 L
.38952 .13354 L
.38954 .12786 L
.38955 .11762 L
.38957 .1626 L
.38958 .14282 L
.3896 .10379 L
.38961 .10788 L
.38962 .09975 L
.38963 .14544 L
.38964 .1338 L
.38966 .13528 L
.38966 .16645 L
.38967 .12069 L
.38969 .163 L
.3897 .13684 L
.38971 .12348 L
.38973 .08659 L
.38974 .13182 L
.38976 .11092 L
.38977 .11288 L
.38978 .17972 L
.3898 .1745 L
.38981 .12893 L
.38983 .14254 L
.38984 .16179 L
.38986 .1623 L
.38987 .12483 L
.38988 .11404 L
.38989 .159 L
.38991 .11763 L
.38992 .17775 L
.38994 .12384 L
.38995 .13656 L
.38996 .14481 L
.38998 .10934 L
.38999 .14928 L
.39001 .12275 L
.39002 .16098 L
.39003 .13617 L
.39004 .13908 L
.39005 .12519 L
.39007 .15456 L
.39008 .13113 L
.39009 .18887 L
.39011 .11261 L
.39012 .15865 L
.39013 .15604 L
.39015 .18489 L
.39016 .09439 L
Mistroke
.39017 .12011 L
.39019 .1063 L
.3902 .1444 L
.39021 .10991 L
.39022 .16206 L
.39024 .12535 L
.39024 .13621 L
.39025 .12049 L
.39027 .14674 L
.39028 .09892 L
.39028 .15924 L
.39029 .14184 L
.3903 .1346 L
.39032 .09912 L
.39033 .12141 L
.39033 .16204 L
.39035 .15007 L
.39036 .13076 L
.39038 .1517 L
.39039 .12375 L
.39041 .13929 L
.39042 .12767 L
.39044 .17781 L
.39045 .10012 L
.39046 .12973 L
.39047 .16082 L
.39049 .15543 L
.3905 .16664 L
.39052 .13168 L
.39053 .13474 L
.39054 .17906 L
.39055 .10763 L
.39056 .16912 L
.39058 .10757 L
.39059 .1443 L
.39059 .15119 L
.3906 .14506 L
.39061 .1172 L
.39063 .15703 L
.39064 .17953 L
.39065 .11874 L
.39066 .15904 L
.39067 .12789 L
.39068 .08167 L
.39069 .13812 L
.39071 .13656 L
.39074 .13402 L
.39079 .12762 L
.39081 .12761 L
.39081 .17264 L
Mistroke
.39082 .12293 L
.39083 .11975 L
.39084 .16074 L
.39085 .14771 L
.39086 .17295 L
.39086 .13415 L
.39087 .16386 L
.39089 .11046 L
.3909 .1636 L
.39092 .14813 L
.39093 .16733 L
.39095 .15432 L
.39096 .10786 L
.39097 .12267 L
.39099 .1514 L
.391 .1496 L
.39101 .13569 L
.39102 .12091 L
.39103 .12614 L
.39109 .14948 L
.3911 .10564 L
.39111 .11854 L
.39113 .1702 L
.39114 .17721 L
.39116 .14345 L
.39117 .13361 L
.39119 .15738 L
.3912 .0982 L
.3912 .11951 L
.39122 .10692 L
.39123 .15442 L
.39125 .16573 L
.39126 .13235 L
.39128 .13086 L
.39128 .15048 L
.39129 .13107 L
.39131 .13674 L
.39132 .14616 L
.39133 .1287 L
.39134 .11109 L
.39135 .13683 L
.39136 .1478 L
.39137 .13252 L
.39138 .1341 L
.39139 .13405 L
.3914 .17517 L
.39142 .13726 L
.39143 .16415 L
.39145 .10866 L
.39146 .16422 L
Mistroke
.39147 .17642 L
.39149 .17407 L
.3915 .09779 L
.39152 .13075 L
.39153 .17849 L
.39155 .13243 L
.39156 .15931 L
.39158 .13014 L
.39158 .17393 L
.39159 .14627 L
.39161 .12731 L
.39162 .16885 L
.39164 .12207 L
.39165 .13734 L
.39166 .19175 L
.39168 .14102 L
.39169 .12444 L
.3917 .18498 L
.39171 .14532 L
.39173 .12686 L
.39174 .16176 L
.39176 .17202 L
.39177 .12336 L
.39178 .14022 L
.3918 .1049 L
.39181 .14183 L
.39181 .17906 L
.39183 .14754 L
.39184 .13431 L
.39186 .1267 L
.39187 .16036 L
.39189 .13736 L
.3919 .10456 L
.39192 .17893 L
.39193 .15685 L
.39194 .11549 L
.39196 .13175 L
.39197 .11394 L
.39199 .14431 L
.392 .15547 L
.39201 .16229 L
.39203 .12387 L
.39204 .08267 L
.39205 .13339 L
.39206 .11878 L
.39208 .16888 L
.39209 .09983 L
.3921 .15006 L
.39212 .15642 L
.39213 .17063 L
Mistroke
.39214 .14574 L
.39216 .13201 L
.39217 .1273 L
.39218 .15477 L
.3922 .13244 L
.39221 .12374 L
.39222 .15729 L
.39224 .11985 L
.39225 .12993 L
.39226 .1607 L
.39227 .12989 L
.39228 .13855 L
.3923 .13811 L
.39275 .122 L
.39277 .13474 L
.39278 .12807 L
.39279 .16183 L
.3928 .11698 L
.39281 .1722 L
.39282 .11829 L
.39283 .10528 L
.39284 .16226 L
.39285 .1894 L
.39286 .10863 L
.39287 .17262 L
.39288 .10832 L
.39289 .13431 L
.3929 .1018 L
.39291 .1358 L
.39292 .13056 L
.39293 .14625 L
.39294 .1277 L
.39295 .13175 L
.39296 .1406 L
.39297 .14676 L
.39298 .17863 L
.39299 .14077 L
.39301 .14484 L
.39302 .15666 L
.39304 .12049 L
.39305 .15414 L
.39306 .13514 L
.39308 .0904 L
.39309 .14901 L
.3931 .17647 L
.39311 .10506 L
.39313 .1114 L
.39314 .1348 L
.39315 .14856 L
.39317 .11145 L
Mistroke
.39318 .09864 L
.39319 .13013 L
.39321 .12264 L
.39322 .15943 L
.39324 .10277 L
.39325 .10521 L
.39327 .16329 L
.39327 .14264 L
.39328 .14637 L
.3933 .15981 L
.39331 .08247 L
.39333 .10207 L
.39334 .18666 L
.39335 .12473 L
.39337 .1831 L
.39338 .13791 L
.39338 .18905 L
.39339 .11934 L
.3934 .15124 L
.39341 .16902 L
.39342 .15748 L
.39343 .15686 L
.39345 .15504 L
.39346 .1351 L
.39347 .11891 L
.39348 .1674 L
.39349 .16318 L
.39351 .10296 L
.39352 .15372 L
.39353 .15967 L
.39355 .15753 L
.39356 .14518 L
.39356 .15574 L
.39358 .17148 L
.39359 .10381 L
.39361 .1548 L
.39362 .13914 L
.39363 .15289 L
.39365 .17309 L
.39366 .18426 L
.39367 .15344 L
.39369 .12774 L
.3937 .14627 L
.39372 .18716 L
.39373 .11656 L
.39375 .10992 L
.39376 .17362 L
.39377 .13052 L
.39378 .09882 L
.39379 .11092 L
Mistroke
.39381 .12405 L
.39382 .13953 L
.39383 .17982 L
.39385 .12587 L
.39386 .09794 L
.39387 .13149 L
.39389 .17716 L
.3939 .17041 L
.39392 .13203 L
.39393 .1386 L
.39395 .17474 L
.39395 .14001 L
.39396 .12762 L
.39398 .14639 L
.39399 .14625 L
.394 .12146 L
.39401 .17043 L
.39402 .18662 L
.39403 .14868 L
.39404 .15997 L
.39405 .12924 L
.39406 .16524 L
.39407 .14244 L
.39409 .14591 L
.3941 .15264 L
.39412 .17174 L
.39413 .14571 L
.39414 .1371 L
.39415 .1071 L
.39416 .14239 L
.39416 .15496 L
.39418 .14735 L
.39419 .15083 L
.39421 .15913 L
.39422 .13281 L
.39424 .14023 L
.39427 .16011 L
.39428 .11108 L
.3943 .17435 L
.39431 .13587 L
.39433 .16315 L
.39434 .16139 L
.39436 .15869 L
.39437 .12895 L
.39438 .15726 L
.3944 .16074 L
.39441 .11727 L
.39442 .17263 L
.39444 .15433 L
.39445 .15977 L
Mistroke
.39447 .13265 L
.39448 .11968 L
.39449 .13129 L
.3945 .12658 L
.39452 .14901 L
.39452 .13758 L
.39453 .12307 L
.39454 .12077 L
.39455 .14373 L
.39456 .12829 L
.39457 .18139 L
.39458 .14119 L
.39459 .17048 L
.3946 .13813 L
.39461 .11864 L
.39461 .11653 L
.39463 .1726 L
.39465 .14638 L
.39466 .1308 L
.39467 .13469 L
.39469 .16284 L
.3947 .15495 L
.39472 .19529 L
.39473 .14807 L
.39474 .12854 L
.39475 .1514 L
.39476 .1555 L
.39478 .13168 L
.39479 .1505 L
.3948 .13023 L
.39482 .13037 L
.39483 .14207 L
.39484 .14543 L
.39486 .15277 L
.39487 .13806 L
.39489 .12052 L
.3949 .14058 L
.39491 .18124 L
.39492 .13621 L
.39493 .14266 L
.39495 .12374 L
.39496 .14153 L
.39496 .14162 L
.39498 .13205 L
.39499 .13223 L
.395 .12753 L
.395 .14795 L
.39501 .13685 L
.39503 .13484 L
.39504 .14064 L
Mistroke
.39506 .10769 L
.39507 .13712 L
.39509 .15816 L
.39509 .13978 L
.3951 .13745 L
.39512 .13082 L
.39513 .17579 L
.39513 .14876 L
.39515 .15053 L
.39516 .16414 L
.39518 .15074 L
.39519 .16392 L
.3952 .12594 L
.39521 .13944 L
.39522 .15067 L
.39524 .16837 L
.39525 .12599 L
.39527 .18677 L
.39528 .11284 L
.39529 .18183 L
.39531 .18254 L
.39532 .18704 L
.39534 .15098 L
.39535 .09707 L
.39536 .17938 L
.39537 .15217 L
.39538 .15175 L
.3954 .14187 L
.39541 .13961 L
.39543 .18689 L
.39544 .15522 L
.39545 .11963 L
.39546 .12655 L
.39547 .17107 L
.39548 .14019 L
.39548 .15619 L
.39549 .14862 L
.39551 .10433 L
.39552 .14607 L
.39554 .14677 L
.39555 .16054 L
.39557 .12192 L
.39558 .16609 L
.39558 .13025 L
.3956 .15703 L
.39561 .15098 L
.39563 .14978 L
.39564 .11884 L
.39566 .16576 L
.39567 .16167 L
Mistroke
.39569 .15032 L
.3957 .12969 L
.39571 .20018 L
.39573 .20596 L
.39574 .16541 L
.39576 .12539 L
.39577 .11466 L
.39579 .10571 L
.3958 .16531 L
.39581 .12668 L
.39582 .17979 L
.39583 .1396 L
.39585 .15205 L
.39586 .16297 L
.39588 .13102 L
.39589 .1421 L
.3959 .10964 L
.39592 .11604 L
.39593 .14129 L
.39594 .08284 L
.39595 .10389 L
.39597 .12454 L
.39598 .1604 L
.396 .15919 L
.39601 .16752 L
.39602 .13263 L
.39603 .15604 L
.39604 .13889 L
.39605 .14353 L
.39607 .13395 L
.39608 .13362 L
.39609 .10933 L
.3961 .15563 L
.39611 .16751 L
.39613 .14414 L
.39614 .14716 L
.39615 .14785 L
.39617 .10965 L
.39618 .11977 L
.3962 .12017 L
.39621 .12306 L
.39621 .15551 L
.39623 .1274 L
.39624 .14795 L
.39625 .14563 L
.39626 .19989 L
.39628 .13143 L
.39629 .17525 L
.3963 .14178 L
.39632 .16393 L
Mistroke
.39633 .12084 L
.39634 .142 L
.39636 .15777 L
.39637 .11889 L
.39638 .16525 L
.3964 .14149 L
.39641 .14122 L
.39642 .14036 L
.39644 .16082 L
.39645 .15569 L
.39647 .13987 L
.39648 .17439 L
.3965 .12587 L
.39651 .14686 L
.39652 .13287 L
.39654 .17743 L
.39655 .16931 L
.39656 .11685 L
.39657 .1141 L
.39658 .13706 L
.39659 .159 L
.3966 .17915 L
.39662 .16104 L
.39663 .1321 L
.39665 .099 L
.39666 .18799 L
.39667 .13401 L
.39669 .09371 L
.3967 .15272 L
.39671 .14333 L
.39673 .14945 L
.39675 .08889 L
.39676 .12497 L
.39677 .15109 L
.39679 .14632 L
.3968 .12691 L
.39682 .13916 L
.39683 .13606 L
.39683 .13789 L
.39684 .1552 L
.39685 .10265 L
.39686 .16649 L
.39687 .13224 L
.39688 .14579 L
.3969 .18315 L
.3969 .13291 L
.39691 .16868 L
.39693 .12996 L
.39694 .14812 L
.39695 .13701 L
Mistroke
.39696 .14232 L
.39698 .14911 L
.39698 .12456 L
.39699 .12166 L
.397 .13216 L
.39701 .14672 L
.39702 .15328 L
.39704 .12323 L
.39706 .13406 L
.39707 .14683 L
.39708 .16959 L
.3971 .14614 L
.39711 .18559 L
.39712 .11197 L
.39714 .11302 L
.39715 .15435 L
.39717 .12339 L
.39718 .13077 L
.39719 .14758 L
.3972 .13297 L
.39721 .11176 L
.39721 .10234 L
.39723 .13909 L
.39724 .16197 L
.39726 .16707 L
.39727 .12084 L
.39728 .14257 L
.3973 .11608 L
.39731 .11944 L
.39733 .17095 L
.39734 .17282 L
.39736 .0853 L
.39737 .13993 L
.39738 .16809 L
.3974 .10989 L
.39741 .15756 L
.39743 .11779 L
.39744 .17884 L
.39745 .08345 L
.39746 .15332 L
.39748 .142 L
.39749 .10323 L
.39751 .12621 L
.39752 .13466 L
.39754 .19132 L
.39755 .20943 L
.39756 .17604 L
.39758 .13073 L
.39759 .1425 L
.39761 .16068 L
Mistroke
.39762 .14072 L
.39764 .12367 L
.39765 .14013 L
.39766 .11966 L
.39767 .1624 L
.39768 .17964 L
.39768 .1668 L
.3977 .15611 L
.39771 .12337 L
.39773 .16963 L
.39774 .13578 L
.39775 .09174 L
.39777 .12591 L
.39779 .15693 L
.3978 .15384 L
.39781 .12131 L
.39783 .12196 L
.39784 .15768 L
.39785 .11532 L
.39787 .15433 L
.39788 .11817 L
.39789 .18505 L
.39791 .09084 L
.39792 .12565 L
.39793 .16116 L
.39794 .15596 L
.39795 .13201 L
.39796 .1304 L
.39798 .12741 L
.39799 .17884 L
.398 .19263 L
.39802 .17176 L
.39803 .12103 L
.39805 .16336 L
.39806 .12855 L
.39806 .12952 L
.39808 .1509 L
.39809 .15029 L
.3981 .14292 L
.39811 .18323 L
.39813 .09703 L
.39814 .1364 L
.39815 .14765 L
.39817 .14577 L
.39818 .1516 L
.39819 .11679 L
.39821 .12241 L
.39822 .14238 L
.39823 .12043 L
.39825 .09174 L
Mistroke
.39826 .16287 L
.39828 .17739 L
.39829 .15145 L
.3983 .1288 L
.39832 .13608 L
.39833 .15979 L
.39835 .18735 L
.39836 .12285 L
.39837 .09717 L
.39839 .12563 L
.3984 .17722 L
.39841 .10425 L
.39842 .13875 L
.39843 .14433 L
.39844 .12138 L
.39845 .12784 L
.39847 .12734 L
.39848 .15472 L
.3985 .16914 L
.39851 .1533 L
.39852 .13251 L
.39854 .1296 L
.39855 .15227 L
.39856 .12495 L
.39858 .14021 L
.3986 .15233 L
.39861 .13733 L
.39862 .13545 L
.39864 .11821 L
.39865 .15308 L
.39867 .14024 L
.39868 .11742 L
.39869 .15546 L
.3987 .16042 L
.39871 .12678 L
.39872 .13584 L
.39873 .16252 L
.39874 .1205 L
.39875 .14623 L
.39876 .1164 L
.39877 .13107 L
.39878 .12667 L
.39879 .16357 L
.3988 .17142 L
.39881 .14735 L
.39881 .09147 L
.39882 .1213 L
.39883 .13133 L
.39884 .0866 L
.39886 .11555 L
Mistroke
.39887 .18122 L
.39889 .12152 L
.39891 .14412 L
.39892 .1314 L
.39893 .15276 L
.39895 .10064 L
.39896 .12181 L
.39897 .12556 L
.39899 .11655 L
.399 .14548 L
.39902 .14472 L
.39903 .14634 L
.39905 .13462 L
.39906 .14953 L
.39906 .13228 L
.39908 .1962 L
.39909 .13123 L
.39911 .11602 L
.39912 .15404 L
.39914 .18412 L
.39915 .13292 L
.39916 .17947 L
.39917 .13161 L
.39919 .13133 L
.3992 .15253 L
.39921 .10419 L
.39923 .14507 L
.39924 .12163 L
.39925 .12753 L
.39927 .18448 L
.39928 .11769 L
.39929 .11558 L
.3993 .178 L
.39931 .17538 L
.39933 .18724 L
.39934 .12295 L
.39936 .12773 L
.39937 .09111 L
.39939 .14111 L
.3994 .12464 L
.39941 .14404 L
.39943 .18441 L
.39944 .16625 L
.39946 .12662 L
.39947 .1131 L
.39949 .13552 L
.3995 .16244 L
.39951 .12461 L
.39952 .12932 L
.39953 .1716 L
Mistroke
.39955 .14886 L
.39956 .10907 L
.39958 .13371 L
.39959 .1722 L
.3996 .15232 L
.39962 .11987 L
.39963 .15049 L
.39965 .15052 L
.39966 .11694 L
.39967 .13243 L
.39969 .12215 L
.3997 .17043 L
.39971 .13623 L
.39973 .18205 L
.39974 .15028 L
.39976 .17454 L
.39977 .13914 L
.39978 .13786 L
.3998 .0936 L
.39981 .14723 L
.39983 .12935 L
.39984 .15715 L
.39985 .12951 L
.39986 .1227 L
.39987 .13722 L
.39989 .15511 L
.3999 .16991 L
.39991 .1671 L
.39992 .16896 L
.39994 .18686 L
.39995 .15779 L
.39997 .13545 L
.39998 .16445 L
.39999 .13099 L
.40001 .11692 L
.40002 .1422 L
.40003 .1562 L
.40004 .16633 L
.40006 .18895 L
.40006 .10989 L
.40007 .13803 L
.40009 .14352 L
.4001 .13551 L
.4001 .16905 L
.40011 .12531 L
.40012 .13234 L
.40014 .15898 L
.40015 .13591 L
.40015 .14326 L
.40017 .17514 L
Mistroke
.40019 .14643 L
.4002 .1539 L
.40021 .13404 L
.40023 .13389 L
.40024 .11291 L
.40026 .16995 L
.40027 .17322 L
.40027 .17629 L
.40029 .15974 L
.4003 .11841 L
.40031 .16736 L
.40032 .10929 L
.40033 .1609 L
.40035 .13975 L
.40036 .13913 L
.40037 .17213 L
.40038 .15702 L
.40039 .13244 L
.4004 .13501 L
.40041 .16601 L
.40041 .15929 L
.40043 .12428 L
.40044 .14911 L
.40045 .17555 L
.40046 .14297 L
.40046 .12844 L
.40048 .15451 L
.40049 .18037 L
.4005 .12388 L
.40051 .14753 L
.40052 .1528 L
.40053 .09341 L
.40054 .12837 L
.40056 .10134 L
.40057 .14564 L
.40059 .14753 L
.4006 .14519 L
.40061 .13581 L
.40062 .10428 L
.40063 .17319 L
.40064 .1704 L
.40065 .10128 L
.40066 .11723 L
.40068 .13852 L
.40069 .16634 L
.4007 .12983 L
.40071 .17573 L
.40072 .16667 L
.40074 .15403 L
.40075 .11067 L
Mistroke
.40076 .15665 L
.40077 .15415 L
.40078 .11777 L
.4008 .1279 L
.40081 .12971 L
.40083 .11248 L
.40084 .16207 L
.40085 .11985 L
.40087 .14155 L
.40088 .12685 L
.40089 .14821 L
.4009 .1391 L
.40091 .12528 L
.40092 .11549 L
.40093 .12768 L
.40095 .14388 L
.40096 .13439 L
.40098 .13845 L
.40099 .14677 L
.401 .16433 L
.40102 .12207 L
.40103 .13691 L
.40104 .12013 L
.40106 .10248 L
.40107 .12798 L
.40108 .13386 L
.4011 .19119 L
.40111 .10608 L
.40112 .13969 L
.40114 .11651 L
.40115 .13163 L
.40117 .1758 L
.40118 .14409 L
.4012 .15208 L
.40121 .12862 L
.40121 .14614 L
.40123 .15388 L
.40124 .11287 L
.40125 .12407 L
.40126 .14991 L
.40128 .13359 L
.40129 .12853 L
.4013 .18826 L
.40131 .15036 L
.40132 .13002 L
.40133 .18129 L
.40135 .17108 L
.40137 .12053 L
.40138 .13869 L
.40139 .15504 L
Mistroke
.40141 .15002 L
.40142 .16105 L
.40143 .1165 L
.40145 .16125 L
.40146 .1676 L
.40147 .1585 L
.40148 .13469 L
.4015 .12231 L
.40151 .12961 L
.40153 .1283 L
.40154 .17075 L
.40155 .14077 L
.40156 .14159 L
.40157 .12654 L
.40159 .14333 L
.4016 .14812 L
.4016 .16575 L
.40161 .16702 L
.40162 .13994 L
.40163 .17023 L
.40164 .12885 L
.40165 .20538 L
.40166 .13694 L
.40167 .12645 L
.40169 .15682 L
.4017 .14389 L
.40171 .13256 L
.40172 .15625 L
.40173 .17765 L
.40175 .14307 L
.40176 .12757 L
.40177 .11436 L
.40179 .16341 L
.4018 .16056 L
.40182 .15062 L
.40182 .11201 L
.40183 .19242 L
.40185 .12897 L
.40186 .15421 L
.40186 .14678 L
.40188 .10466 L
.40189 .12182 L
.40191 .14044 L
.40192 .18126 L
.40193 .13638 L
.40195 .14027 L
.40196 .15232 L
.40197 .17568 L
.40199 .14305 L
.402 .10883 L
Mistroke
.40202 .13144 L
.40203 .09338 L
.40204 .12265 L
.40206 .13198 L
.40208 .14835 L
.4021 .15866 L
.40211 .17083 L
.40213 .13882 L
.40214 .12124 L
.40216 .11576 L
.40217 .145 L
.40217 .15823 L
.40219 .17725 L
.4022 .12857 L
.40222 .14156 L
.40223 .16109 L
.40224 .12093 L
.40226 .18412 L
.40227 .10203 L
.40228 .13199 L
.40229 .11181 L
.4023 .1299 L
.40231 .12889 L
.40232 .1901 L
.40234 .14201 L
.40235 .13933 L
.40237 .13082 L
.40238 .16486 L
.40239 .12073 L
.40241 .1578 L
.40242 .15379 L
.40243 .16974 L
.40244 .15242 L
.40246 .18494 L
.40247 .14802 L
.40249 .13683 L
.4025 .14617 L
.40251 .13251 L
.40253 .15688 L
.40254 .13135 L
.40256 .18016 L
.40257 .12718 L
.40259 .13895 L
.4026 .15742 L
.40261 .158 L
.40262 .13435 L
.40263 .11982 L
.40265 .16584 L
.40266 .15173 L
.40266 .1318 L
Mistroke
.40268 .16163 L
.40269 .19181 L
.4027 .12968 L
.40271 .14618 L
.40272 .15259 L
.40274 .12409 L
.40275 .13677 L
.40277 .1289 L
.40278 .14474 L
.4028 .14245 L
.40281 .12496 L
.40282 .15695 L
.40284 .10137 L
.40285 .17504 L
.40287 .14793 L
.40287 .14492 L
.40288 .17415 L
.4029 .19429 L
.40291 .1395 L
.40293 .14992 L
.40294 .12705 L
.40296 .14422 L
.40296 .17836 L
.40297 .12237 L
.40299 .14642 L
.403 .15534 L
.40301 .14465 L
.40301 .15615 L
.40302 .11887 L
.40303 .14149 L
.40304 .13027 L
.40305 .13827 L
.40306 .12568 L
.40307 .18519 L
.40309 .14892 L
.4031 .15522 L
.40311 .13507 L
.40312 .10979 L
.40313 .0938 L
.40315 .14807 L
.40316 .13935 L
.40317 .1863 L
.40319 .16538 L
.4032 .10858 L
.40322 .17894 L
.40322 .14259 L
.40323 .17154 L
.40325 .16795 L
.40326 .14693 L
.40326 .18806 L
Mistroke
.40328 .14698 L
.40329 .12909 L
.40331 .13564 L
.40332 .1815 L
.40334 .16177 L
.40335 .1986 L
.40336 .12574 L
.40337 .12569 L
.40339 .16026 L
.4034 .1548 L
.40342 .14208 L
.40343 .13074 L
.40345 .1774 L
.40346 .12709 L
.40347 .14729 L
.40349 .1817 L
.4035 .17647 L
.40352 .1422 L
.40353 .09677 L
.40354 .15092 L
.40356 .0755 L
.40357 .0935 L
.40358 .14151 L
.40359 .12188 L
.4036 .11355 L
.40361 .0974 L
.40362 .14938 L
.40364 .14209 L
.40365 .10059 L
.40367 .15826 L
.40368 .1495 L
.40369 .12604 L
.40371 .18694 L
.40372 .13763 L
.40373 .14648 L
.40375 .17273 L
.40376 .17456 L
.40378 .15886 L
.40379 .14572 L
.40381 .14521 L
.40382 .12622 L
.40384 .15077 L
.40385 .14625 L
.40386 .15164 L
.40387 .13137 L
.40388 .16037 L
.40389 .12441 L
.4039 .15103 L
.40391 .13255 L
.40392 .15811 L
Mistroke
.40393 .17177 L
.40394 .12258 L
.40395 .14231 L
.40396 .16743 L
.40397 .14492 L
.40398 .09499 L
.40398 .09994 L
.40399 .15377 L
.404 .13872 L
.40401 .12013 L
.40403 .15895 L
.40404 .15986 L
.40406 .15125 L
.40407 .11929 L
.40409 .16326 L
.4041 .11196 L
.40411 .12128 L
.40413 .16709 L
.40414 .16884 L
.40416 .16586 L
.40417 .1572 L
.40419 .1657 L
.4042 .15013 L
.40422 .15941 L
.40423 .18299 L
.40423 .10763 L
.40425 .13656 L
.40426 .13146 L
.40428 .15994 L
.40429 .15839 L
.40431 .16668 L
.40432 .13302 L
.40433 .15032 L
.40434 .11245 L
.40436 .16182 L
.40437 .14469 L
.40438 .13583 L
.4044 .13295 L
.40441 .11191 L
.40442 .13367 L
.40444 .20118 L
.40445 .17886 L
.40446 .16203 L
.40447 .1137 L
.40448 .12365 L
.40451 .14932 L
.40453 .16662 L
.40454 .12326 L
.40456 .13851 L
.40457 .15483 L
Mistroke
.40458 .0902 L
.4046 .18286 L
.40461 .15148 L
.40462 .15127 L
.40463 .12333 L
.40465 .13238 L
.40466 .13908 L
.40468 .11308 L
.40469 .1361 L
.40471 .10091 L
.40472 .11928 L
.40473 .11897 L
.40475 .11609 L
.40476 .16968 L
.40477 .18057 L
.40479 .08533 L
.4048 .11613 L
.40482 .15798 L
.40483 .15033 L
.40485 .19017 L
.40486 .11152 L
.40487 .1784 L
.40489 .16285 L
.4049 .15153 L
.40491 .132 L
.40493 .11583 L
.40494 .13229 L
.40495 .10943 L
.40497 .1611 L
.40498 .11172 L
.40498 .11936 L
.405 .16366 L
.40501 .13198 L
.40503 .12165 L
.40504 .12752 L
.40505 .15408 L
.40506 .17373 L
.40507 .13339 L
.40508 .1357 L
.40509 .14158 L
.4051 .14196 L
.40511 .1526 L
.40512 .09504 L
.40513 .1294 L
.40513 .1783 L
.40515 .15936 L
.40516 .16372 L
.40518 .11955 L
.40519 .18285 L
.40521 .1342 L
Mistroke
.40522 .17633 L
.40523 .18254 L
.40523 .15325 L
.40524 .12911 L
.40525 .13358 L
.40526 .15657 L
.40527 .13979 L
.40528 .1558 L
.40529 .17311 L
.4053 .16457 L
.40531 .09134 L
.40533 .13615 L
.40534 .14309 L
.40535 .18034 L
.40536 .12918 L
.40537 .13151 L
.40538 .12028 L
.40539 .14289 L
.4054 .14946 L
.40542 .12264 L
.40543 .14309 L
.40545 .12646 L
.40546 .15344 L
.40548 .11426 L
.40549 .15557 L
.4055 .12356 L
.40552 .12632 L
.40553 .12546 L
.40554 .12053 L
.40556 .12497 L
.40557 .16798 L
.40559 .15777 L
.4056 .13707 L
.40562 .18794 L
.40563 .13506 L
.40564 .14156 L
.40565 .17238 L
.40567 .16342 L
.40568 .13156 L
.40569 .11807 L
.40571 .14603 L
.40572 .17968 L
.40573 .16368 L
.40575 .11951 L
.40576 .13348 L
.40578 .16337 L
.40579 .15084 L
.40581 .14381 L
.40582 .10706 L
.40583 .14685 L
Mistroke
.40584 .14085 L
.40586 .1693 L
.40587 .1424 L
.40589 .0871 L
.4059 .14508 L
.40591 .12737 L
.40593 .12555 L
.40594 .1491 L
.40596 .19117 L
.40597 .13899 L
.40597 .12773 L
.40599 .15548 L
.406 .12049 L
.40602 .11859 L
.40603 .14106 L
.40604 .172 L
.40605 .16164 L
.40607 .14913 L
.40608 .14783 L
.4061 .09869 L
.40611 .12502 L
.40613 .14577 L
.40613 .11667 L
.40614 .1321 L
.40616 .13862 L
.40617 .15013 L
.40618 .13283 L
.40619 .16933 L
.4062 .15818 L
.40621 .15487 L
.40622 .15526 L
.40623 .13165 L
.40624 .17531 L
.40625 .13665 L
.40626 .17458 L
.40627 .14947 L
.40629 .11895 L
.4063 .13318 L
.40632 .17742 L
.40633 .13785 L
.40634 .1489 L
.40636 .12901 L
.40637 .13043 L
.40637 .12404 L
.40639 .1192 L
.4064 .09701 L
.40641 .16001 L
.40642 .14388 L
.40644 .16178 L
.40645 .13675 L
Mistroke
.40647 .13136 L
.40648 .19089 L
.40649 .11193 L
.4065 .11696 L
.40651 .16769 L
.40651 .1384 L
.40653 .18767 L
.40654 .16003 L
.40655 .14451 L
.40656 .15014 L
.40658 .16959 L
.40659 .12002 L
.4066 .13886 L
.4066 .16754 L
.40661 .15919 L
.40662 .14101 L
.40663 .12148 L
.40664 .15313 L
.40666 .13217 L
.40667 .14065 L
.40669 .11717 L
.4067 .16138 L
.4067 .14091 L
.40671 .15351 L
.40672 .10793 L
.40673 .12454 L
.40674 .14739 L
.40675 .11445 L
.40677 .15492 L
.40678 .16464 L
.40679 .16859 L
.40681 .13123 L
.40682 .16935 L
.40682 .18974 L
.40684 .16807 L
.40685 .12143 L
.40687 .12302 L
.40688 .15704 L
.40689 .14296 L
.4069 .15074 L
.40691 .13815 L
.40693 .13597 L
.40694 .15151 L
.40695 .12814 L
.40697 .1661 L
.40698 .17565 L
.40699 .13901 L
.407 .13721 L
.40702 .10294 L
.40703 .14379 L
Mistroke
.40703 .14623 L
.40705 .09325 L
.40706 .16744 L
.40708 .16115 L
.40709 .15034 L
.4071 .1493 L
.40712 .1793 L
.40713 .16101 L
.40714 .17423 L
.40716 .16379 L
.40717 .1591 L
.40719 .17886 L
.4072 .15694 L
.40721 .15658 L
.40722 .13706 L
.40724 .16544 L
.40725 .13554 L
.40727 .17699 L
.40728 .15732 L
.4073 .12738 L
.40731 .14082 L
.40732 .1093 L
.40733 .13526 L
.40734 .14087 L
.40736 .18023 L
.40737 .10002 L
.40738 .13862 L
.40739 .14789 L
.4074 .1276 L
.40741 .13373 L
.40742 .1769 L
.40744 .16954 L
.40745 .13816 L
.40746 .17009 L
.40748 .12026 L
.40749 .13651 L
.40751 .18148 L
.40752 .15996 L
.40753 .13353 L
.40755 .17733 L
.40756 .15428 L
.40756 .1804 L
.40758 .12618 L
.40759 .16768 L
.4076 .16392 L
.40761 .13762 L
.40762 .17449 L
.40764 .17242 L
.40765 .13233 L
.40767 .13264 L
Mistroke
.40768 .12684 L
.40769 .14168 L
.40769 .09643 L
.4077 .16703 L
.40772 .12787 L
.40773 .12738 L
.40774 .14418 L
.40775 .13934 L
.40776 .12241 L
.40777 .16363 L
.40778 .16919 L
.40779 .13087 L
.4078 .11793 L
.40781 .14235 L
.40783 .13299 L
.40784 .14516 L
.40785 .17325 L
.40785 .11727 L
.40786 .13779 L
.40788 .16704 L
.40789 .15416 L
.40791 .12673 L
.40792 .10027 L
.40794 .15625 L
.40795 .12284 L
.40796 .13973 L
.40798 .17583 L
.40799 .15949 L
.40801 .16486 L
.40802 .12393 L
.40803 .13229 L
.40805 .13046 L
.40806 .13411 L
.40808 .17332 L
.40809 .10023 L
.40811 .14615 L
.40812 .1746 L
.40812 .17933 L
.40814 .16668 L
.40815 .14543 L
.40816 .14434 L
.40817 .12253 L
.40818 .12166 L
.40819 .1529 L
.4082 .12697 L
.40821 .16389 L
.40821 .10233 L
.40822 .13355 L
.40823 .13541 L
.40824 .10688 L
Mistroke
.40825 .17782 L
.40825 .14119 L
.40827 .16683 L
.40828 .17841 L
.4083 .16243 L
.40831 .11769 L
.40833 .1468 L
.40834 .12472 L
.40836 .14201 L
.40837 .12415 L
.40838 .14654 L
.4084 .16668 L
.40841 .13886 L
.40843 .15153 L
.40844 .14202 L
.40846 .13124 L
.40847 .16542 L
.40848 .16448 L
.40849 .17463 L
.4085 .12826 L
.40852 .15929 L
.40853 .13648 L
.40855 .11952 L
.40856 .14155 L
.40857 .14238 L
.40859 .14585 L
.4086 .17336 L
.40861 .13555 L
.40862 .17399 L
.40864 .13516 L
.40865 .12107 L
.40867 .14259 L
.40868 .14364 L
.40869 .15004 L
.4087 .14294 L
.40871 .17399 L
.40872 .122 L
.40874 .12034 L
.40875 .14586 L
.40877 .14533 L
.40878 .15388 L
.4088 .10143 L
.40881 .18414 L
.40882 .13458 L
.40884 .11535 L
.40885 .1422 L
.40887 .14107 L
.40888 .15971 L
.4089 .14432 L
.40891 .13628 L
Mistroke
.40893 .12844 L
.40893 .12342 L
.40894 .179 L
.40896 .12658 L
.40897 .13545 L
.40899 .14985 L
.409 .14125 L
.40901 .1355 L
.40903 .14198 L
.40904 .11842 L
.40905 .14542 L
.40907 .12825 L
.40908 .10865 L
.40909 .13016 L
.40911 .14922 L
.40912 .13655 L
.40913 .18932 L
.40914 .16115 L
.40915 .15379 L
.40916 .14722 L
.40918 .12641 L
.40919 .15637 L
.40921 .14271 L
.40922 .16775 L
.40924 .10343 L
.40925 .17158 L
.40927 .1244 L
.40928 .12295 L
.40929 .16671 L
.40931 .14702 L
.40932 .18074 L
.40934 .12187 L
.40935 .14637 L
.40937 .16293 L
.40938 .13619 L
.40939 .10386 L
.4094 .15966 L
.40941 .15915 L
.40943 .12636 L
.40944 .14543 L
.40945 .15059 L
.40947 .11524 L
.40948 .12677 L
.4095 .14749 L
.40951 .11464 L
.40952 .1683 L
.40953 .14167 L
.40955 .11074 L
.40956 .10762 L
.40958 .15745 L
Mistroke
.40959 .16703 L
.4096 .17968 L
.40961 .13225 L
.40962 .10525 L
.40963 .12392 L
.40965 .12121 L
.40966 .10212 L
.40967 .14007 L
.40968 .13982 L
.40969 .14334 L
.40971 .1712 L
.40972 .15592 L
.40973 .16545 L
.40975 .13642 L
.40976 .12207 L
.40978 .12812 L
.40979 .13182 L
.40979 .14314 L
.40981 .13085 L
.40982 .12697 L
.40983 .1234 L
.40984 .11699 L
.40986 .1167 L
.40987 .12712 L
.40988 .13549 L
.4099 .14134 L
.40991 .12415 L
.40992 .10968 L
.40993 .15261 L
.40995 .15037 L
.40996 .12834 L
.40998 .14266 L
.40999 .13451 L
.41001 .19557 L
.41002 .17315 L
.41003 .14655 L
.41005 .17501 L
.41006 .1891 L
.41008 .18608 L
.41009 .17634 L
.4101 .17172 L
.41017 .14761 L
.41018 .15397 L
.41019 .10608 L
.4102 .15047 L
.41021 .12716 L
.41023 .12275 L
.41024 .0917 L
.41025 .10269 L
.41027 .19136 L
Mistroke
.41028 .15244 L
.41029 .16888 L
.41031 .11682 L
.41032 .14011 L
.41034 .15441 L
.41035 .15159 L
.41036 .16184 L
.41037 .11612 L
.41038 .16366 L
.41039 .11098 L
.4104 .15593 L
.41041 .14681 L
.41041 .15032 L
.41042 .12203 L
.41043 .13943 L
.41044 .16782 L
.41045 .19381 L
.41047 .12988 L
.41048 .18914 L
.4105 .12624 L
.41051 .11354 L
.41053 .09731 L
.41054 .1917 L
.41055 .16314 L
.41056 .13448 L
.41057 .15757 L
.41058 .15728 L
.41059 .11895 L
.4106 .20673 L
.41062 .14649 L
.41063 .12765 L
.41065 .13439 L
.41068 .15273 L
.4107 .13137 L
.41071 .16958 L
.41072 .14103 L
.41074 .17843 L
.41075 .15337 L
.41077 .12553 L
.41078 .1449 L
.41079 .12721 L
.41081 .1547 L
.41082 .14431 L
.41083 .13894 L
.41085 .17194 L
.41086 .15773 L
.41088 .16263 L
.41089 .12148 L
.4109 .14369 L
.41091 .15529 L
Mistroke
.41093 .16293 L
.41093 .10546 L
.41094 .17114 L
.41096 .12619 L
.41096 .15875 L
.41097 .16477 L
.41099 .15885 L
.411 .16402 L
.41101 .09896 L
.41102 .16061 L
.41103 .11544 L
.41104 .13859 L
.41105 .13164 L
.41106 .12478 L
.41107 .16897 L
.41108 .15127 L
.4111 .16796 L
.41111 .13154 L
.41113 .11821 L
.41114 .1521 L
.41115 .14037 L
.41116 .14498 L
.41117 .21246 L
.41119 .14441 L
.4112 .13371 L
.41121 .13799 L
.41123 .1341 L
.41124 .17286 L
.41125 .14791 L
.41127 .17706 L
.41128 .14728 L
.4113 .13981 L
.41131 .12536 L
.41132 .15287 L
.41133 .12781 L
.41134 .17195 L
.41136 .16826 L
.41136 .12759 L
.41137 .16248 L
.41139 .13095 L
.4114 .1057 L
.4114 .13835 L
.41141 .1222 L
.41142 .1689 L
.41144 .13296 L
.41145 .15018 L
.41145 .17318 L
.41147 .0867 L
.41149 .15625 L
.4115 .15933 L
Mistroke
.41151 .09801 L
.41153 .12288 L
.41154 .18467 L
.41156 .14577 L
.41157 .13995 L
.41157 .14025 L
.41159 .14666 L
.4116 .17256 L
.41161 .19543 L
.41162 .11705 L
.41163 .12 L
.41165 .13617 L
.41166 .13856 L
.41167 .14061 L
.41168 .15448 L
.41169 .12032 L
.4117 .18369 L
.41171 .15046 L
.41171 .12721 L
.41173 .12182 L
.41174 .13049 L
.41175 .15672 L
.41176 .147 L
.41176 .12453 L
.41178 .14619 L
.41179 .16151 L
.4118 .12462 L
.41181 .14137 L
.41182 .18196 L
.41183 .09509 L
.41184 .14064 L
.41186 .13182 L
.41187 .13705 L
.41189 .16689 L
.4119 .13574 L
.41191 .15875 L
.41192 .11339 L
.41193 .1457 L
.41194 .14033 L
.41195 .13827 L
.41196 .1326 L
.41197 .14445 L
.41198 .15044 L
.41199 .13961 L
.41201 .18162 L
.41202 .17091 L
.41204 .16675 L
.41205 .10986 L
.41206 .11094 L
.41207 .12957 L
Mistroke
.41208 .09972 L
.4121 .12368 L
.41211 .11345 L
.41213 .11455 L
.41214 .15101 L
.41215 .15398 L
.41217 .14962 L
.41218 .18216 L
.41219 .11696 L
.4122 .13269 L
.41221 .14164 L
.41222 .17723 L
.41223 .15959 L
.41225 .15088 L
.41226 .16534 L
.41228 .14044 L
.41229 .12163 L
.4123 .16693 L
.41232 .16941 L
.41233 .17707 L
.41234 .15046 L
.41236 .13845 L
.41237 .12624 L
.41238 .14178 L
.4124 .15452 L
.41241 .14878 L
.41242 .11729 L
.41244 .17822 L
.41245 .13947 L
.41247 .16422 L
.41248 .1453 L
.4125 .16215 L
.41251 .16771 L
.41251 .16431 L
.41253 .15287 L
.41254 .12087 L
.41255 .18596 L
.41256 .09886 L
.41258 .1435 L
.41259 .09357 L
.4126 .10741 L
.41261 .14404 L
.41262 .15473 L
.41263 .17538 L
.41265 .12182 L
.41266 .13465 L
.41268 .18287 L
.41269 .16333 L
.41271 .1098 L
.41272 .15101 L
Mistroke
.41273 .14794 L
.41275 .1 L
.41276 .14904 L
.41277 .13226 L
.41278 .14266 L
.4128 .17647 L
.41281 .18166 L
.41283 .15786 L
.41284 .1325 L
.41285 .13659 L
.41286 .13491 L
.41287 .18502 L
.41289 .11791 L
.4129 .16619 L
.4129 .12083 L
.41291 .15004 L
.41292 .12736 L
.41293 .18962 L
.41294 .1293 L
.41295 .11736 L
.41296 .12884 L
.41297 .17961 L
.41299 .1366 L
.413 .14833 L
.41301 .14171 L
.41302 .1885 L
.41303 .14972 L
.41305 .13988 L
.41306 .16821 L
.41307 .15693 L
.41308 .1936 L
.4131 .15052 L
.41311 .17008 L
.41312 .14897 L
.41313 .18097 L
.41315 .1519 L
.41316 .14685 L
.41316 .09931 L
.41318 .13055 L
.41319 .18346 L
.41321 .14917 L
.41322 .15462 L
.41323 .16367 L
.41325 .14136 L
.41326 .16646 L
.41327 .1757 L
.41329 .13502 L
.4133 .11046 L
.41332 .16012 L
.41333 .15542 L
Mistroke
.41334 .15846 L
.41335 .11784 L
.41337 .09113 L
.41338 .09096 L
.4134 .18935 L
.41341 .07962 L
.41343 .12694 L
.41344 .17374 L
.41346 .17256 L
.41347 .12081 L
.41348 .11309 L
.41349 .15196 L
.4135 .12871 L
.41351 .14149 L
.41352 .13345 L
.41353 .18296 L
.41354 .15522 L
.41355 .1471 L
.41357 .13479 L
.41358 .17033 L
.41359 .16896 L
.41361 .11108 L
.41362 .1361 L
.41364 .1394 L
.41365 .12437 L
.41366 .10115 L
.41368 .1658 L
.41369 .13512 L
.41371 .17403 L
.41371 .15628 L
.41372 .15109 L
.41374 .11705 L
.41375 .20429 L
.41377 .12175 L
.41378 .16996 L
.4138 .12734 L
.41381 .11618 L
.41381 .12649 L
.41383 .16563 L
.41384 .15378 L
.41385 .15086 L
.41386 .16154 L
.41386 .11439 L
.41387 .11838 L
.41388 .13865 L
.41389 .14472 L
.4139 .17879 L
.41391 .12765 L
.41393 .13788 L
.41394 .17091 L
Mistroke
.41396 .1147 L
.41397 .15253 L
.41399 .17192 L
.414 .11239 L
.41401 .1334 L
.41403 .12484 L
.41404 .16647 L
.41406 .17942 L
.41407 .13044 L
.41409 .1152 L
.4141 .15525 L
.41412 .1838 L
.41413 .18457 L
.41413 .13381 L
.41415 .17802 L
.41416 .18306 L
.41418 .15302 L
.41419 .14956 L
.4142 .16126 L
.41422 .16057 L
.41423 .12736 L
.41424 .08645 L
.41426 .1326 L
.41427 .17322 L
.41428 .13865 L
.4143 .14037 L
.41431 .12454 L
.41432 .17828 L
.41434 .1682 L
.41435 .16812 L
.41435 .17785 L
.41437 .13789 L
.41438 .15328 L
.4144 .1769 L
.41441 .13913 L
.41441 .19357 L
.41443 .16281 L
.41444 .11901 L
.41446 .16359 L
.41447 .13078 L
.41448 .12926 L
.4145 .13262 L
.41451 .16474 L
.41451 .15173 L
.41453 .11556 L
.41454 .21293 L
.41455 .15661 L
.41456 .15106 L
.41458 .13973 L
.41459 .14472 L
Mistroke
.41461 .15146 L
.41462 .13801 L
.41463 .1267 L
.41465 .13651 L
.41466 .15341 L
.41467 .15293 L
.41469 .17008 L
.4147 .13681 L
.41471 .16764 L
.41473 .09592 L
.41474 .1234 L
.41476 .1743 L
.41477 .13927 L
.41478 .15488 L
.4148 .17466 L
.41481 .1132 L
.41482 .144 L
.41484 .15617 L
.41486 .14974 L
.41487 .15911 L
.41488 .13358 L
.41489 .13182 L
.41489 .16823 L
.4149 .16504 L
.41492 .14771 L
.41493 .11168 L
.41493 .15868 L
.41495 .17474 L
.41496 .13912 L
.41498 .15228 L
.41499 .15679 L
.415 .14335 L
.41502 .16263 L
.41503 .16007 L
.41504 .17653 L
.41506 .13685 L
.41507 .16716 L
.41509 .20476 L
.4151 .14821 L
.41511 .10037 L
.41512 .13519 L
.41514 .11431 L
.41515 .17305 L
.41517 .17483 L
.41518 .13474 L
.41519 .1348 L
.4152 .16155 L
.41521 .13504 L
.41523 .1333 L
.41524 .17907 L
Mistroke
.41524 .14917 L
.41525 .11713 L
.41526 .1089 L
.41527 .17763 L
.41528 .11973 L
.41529 .11789 L
.41529 .13714 L
.41531 .141 L
.41533 .13834 L
.41534 .19476 L
.41536 .14025 L
.41537 .16065 L
.41538 .1694 L
.4154 .1075 L
.41541 .15336 L
.41542 .13667 L
.41544 .15662 L
.41545 .15012 L
.41547 .14308 L
.41548 .11738 L
.4155 .10815 L
.41551 .118 L
.41552 .16429 L
.41553 .15309 L
.41555 .09801 L
.41556 .13562 L
.41557 .1347 L
.41559 .17043 L
.4156 .16716 L
.41561 .12141 L
.41563 .15684 L
.41564 .14022 L
.41565 .16938 L
.41567 .18207 L
.41568 .16692 L
.41569 .10765 L
.41571 .14041 L
.41572 .17652 L
.41573 .12393 L
.41574 .1492 L
.41575 .16491 L
.41576 .14036 L
.41578 .16058 L
.41579 .15744 L
.41581 .16523 L
.41583 .17152 L
.41584 .12313 L
.41585 .16581 L
.41587 .16403 L
.41588 .20328 L
Mistroke
.41589 .19908 L
.41591 .17012 L
.41592 .14755 L
.41594 .1393 L
.41595 .10973 L
.41597 .13141 L
.41598 .16598 L
.41599 .10731 L
.416 .16537 L
.41601 .13846 L
.41603 .11202 L
.41604 .15727 L
.41606 .17502 L
.41607 .15984 L
.41608 .15296 L
.41609 .09774 L
.41611 .17387 L
.41612 .17335 L
.41613 .11324 L
.41615 .15363 L
.41616 .13024 L
.41617 .15488 L
.41619 .12709 L
.4162 .13661 L
.41621 .13092 L
.41622 .16277 L
.41623 .18057 L
.41625 .13539 L
.41626 .14415 L
.41627 .13767 L
.41628 .12348 L
.41629 .09948 L
.41631 .14519 L
.41632 .17532 L
.41633 .14452 L
.41635 .178 L
.41636 .12217 L
.41637 .14529 L
.41638 .15584 L
.4164 .16304 L
.4164 .11304 L
.41641 .17147 L
.41643 .17468 L
.41644 .1267 L
.41646 .17662 L
.41647 .15855 L
.41648 .1752 L
.4165 .15215 L
.41651 .11896 L
.41652 .1571 L
Mistroke
.41653 .10699 L
.41655 .14748 L
.41656 .13616 L
.41658 .12938 L
.41659 .14064 L
.41661 .15314 L
.41662 .09686 L
.41663 .1469 L
.41665 .14654 L
.41666 .20326 L
.41668 .14195 L
.41669 .1609 L
.41671 .12681 L
.41672 .13579 L
.41673 .17451 L
.41674 .16468 L
.41675 .13208 L
.41675 .14445 L
.41677 .14757 L
.41678 .15267 L
.41678 .14144 L
.4168 .16165 L
.41681 .22394 L
.41683 .14833 L
.41684 .13936 L
.41686 .17924 L
.41687 .15659 L
.41688 .13637 L
.4169 .11646 L
.41691 .10931 L
.41692 .11152 L
.41694 .10352 L
.41695 .1288 L
.41696 .17921 L
.41697 .1657 L
.41699 .16973 L
.417 .12997 L
.41702 .13264 L
.41703 .14318 L
.41705 .14783 L
.41706 .14066 L
.41707 .18445 L
.41708 .13259 L
.41709 .15054 L
.4171 .14038 L
.41711 .17895 L
.41711 .15761 L
.41713 .15169 L
.41714 .13976 L
.41716 .1626 L
Mistroke
.41717 .15392 L
.41718 .1489 L
.41719 .17101 L
.41721 .14088 L
.41722 .14457 L
.41723 .17726 L
.41725 .14381 L
.41726 .19792 L
.41727 .1412 L
.41728 .15262 L
.4173 .18273 L
.41731 .13844 L
.41733 .12376 L
.41734 .12813 L
.41735 .13942 L
.41737 .17592 L
.41738 .13232 L
.4174 .15121 L
.41741 .11894 L
.41742 .14477 L
.41744 .16353 L
.41745 .16364 L
.41747 .12808 L
.41748 .17093 L
.4175 .14754 L
.41751 .18937 L
.41752 .13526 L
.41754 .14999 L
.41755 .15781 L
.41756 .12083 L
.41758 .13269 L
.41759 .17439 L
.41761 .15071 L
.41762 .14936 L
.41763 .1542 L
.41764 .18169 L
.41766 .12113 L
.41767 .11431 L
.41769 .12641 L
.4177 .11834 L
.41772 .13194 L
.41773 .12679 L
.41774 .1932 L
.41775 .1447 L
.41776 .15305 L
.41777 .19979 L
.41778 .1724 L
.41779 .14055 L
.4178 .17728 L
.41781 .14726 L
Mistroke
.41782 .17889 L
.41784 .10198 L
.41785 .13401 L
.41785 .14881 L
.41787 .13131 L
.41789 .14391 L
.4179 .15821 L
.41791 .10752 L
.41792 .16784 L
.41792 .11603 L
.41793 .17344 L
.41794 .14645 L
.41795 .16254 L
.41797 .14957 L
.41797 .15466 L
.41798 .14623 L
.41799 .14568 L
.418 .11304 L
.41802 .14745 L
.41803 .12376 L
.41803 .17068 L
.41805 .14688 L
.41806 .14043 L
.41806 .15896 L
.41808 .17175 L
.41809 .13979 L
.41811 .1206 L
.41812 .11651 L
.41814 .15407 L
.41815 .13559 L
.41816 .1522 L
.41818 .14671 L
.41819 .15309 L
.4182 .11963 L
.41821 .13946 L
.41822 .15521 L
.41824 .15407 L
.41825 .11558 L
.41827 .18277 L
.41828 .15463 L
.41829 .11345 L
.4183 .12605 L
.41832 .14074 L
.41833 .1527 L
.41835 .13735 L
.41836 .15062 L
.41837 .18732 L
.41838 .16125 L
.41839 .12864 L
.41841 .15316 L
Mistroke
.41842 .12541 L
.41842 .12887 L
.41844 .13198 L
.41845 .15473 L
.41846 .13506 L
.41846 .14298 L
.41847 .16188 L
.41849 .1477 L
.4185 .1352 L
.41851 .10366 L
.41852 .14684 L
.41854 .18648 L
.41855 .12262 L
.41856 .14915 L
.41858 .14474 L
.41859 .20228 L
.41861 .13943 L
.41862 .13159 L
.41864 .11069 L
.41865 .14153 L
.41867 .14811 L
.41868 .14467 L
.41871 .13817 L
.41873 .12939 L
.41874 .17714 L
.41874 .1925 L
.41876 .15621 L
.41877 .12472 L
.41879 .13465 L
.4188 .15229 L
.41881 .12442 L
.41882 .16437 L
.41883 .14009 L
.41884 .0984 L
.41885 .13902 L
.41886 .1875 L
.41888 .17269 L
.41889 .15642 L
.41891 .16675 L
.41891 .10321 L
.41892 .14553 L
.41894 .10975 L
.41895 .12967 L
.41896 .15028 L
.41898 .13869 L
.41899 .15631 L
.419 .1254 L
.41902 .12657 L
.41903 .15851 L
.41905 .10243 L
Mistroke
.41906 .16716 L
.41907 .13425 L
.41909 .14942 L
.4191 .10536 L
.41912 .16594 L
.41913 .12512 L
.41914 .16874 L
.41915 .15974 L
.41916 .08407 L
.41918 .15637 L
.41919 .124 L
.4192 .17207 L
.41922 .16452 L
.41923 .11299 L
.41924 .15352 L
.41926 .15561 L
.41927 .14913 L
.41929 .18259 L
.4193 .16784 L
.41931 .19711 L
.41932 .12955 L
.41933 .15413 L
.41935 .13566 L
.41936 .13068 L
.41936 .13781 L
.41938 .16791 L
.41939 .1014 L
.4194 .18328 L
.41941 .13107 L
.41941 .1239 L
.41943 .15529 L
.41944 .12301 L
.41946 .14548 L
.41947 .15288 L
.41949 .16261 L
.4195 .12825 L
.4195 .11082 L
.41952 .16343 L
.41953 .16116 L
.41955 .1552 L
.41956 .1174 L
.41957 .18397 L
.41957 .16177 L
.41958 .18828 L
.41959 .16164 L
.4196 .11975 L
.41961 .13435 L
.41963 .1229 L
.41964 .1324 L
.41965 .14724 L
Mistroke
.41966 .15335 L
.41967 .14078 L
.41968 .15672 L
.41968 .13763 L
.41969 .14936 L
.4197 .14047 L
.41971 .1331 L
.41972 .11546 L
.41973 .14591 L
.41974 .12909 L
.41974 .18137 L
.41975 .15895 L
.41976 .18929 L
.41978 .11628 L
.41978 .14395 L
.41979 .14788 L
.41981 .14329 L
.41982 .16038 L
.41982 .1815 L
.41984 .1648 L
.41985 .12093 L
.41987 .13453 L
.41988 .16319 L
.41989 .17128 L
.41991 .17698 L
.41992 .12674 L
.41993 .14152 L
.41994 .12082 L
.41995 .14789 L
.41996 .13339 L
.41997 .17144 L
.41997 .1294 L
.41999 .15356 L
.42 .16612 L
.42002 .16715 L
.42003 .13033 L
.42003 .13446 L
.42005 .13728 L
.42006 .17536 L
.42008 .12954 L
.42009 .13652 L
.4201 .14588 L
.42011 .1758 L
.42013 .14101 L
.42014 .14414 L
.42016 .14682 L
.42017 .14205 L
.42018 .14252 L
.4202 .17713 L
.42021 .12801 L
Mistroke
.42023 .14241 L
.42024 .10886 L
.42025 .18148 L
.42027 .11439 L
.42028 .14498 L
.4203 .16138 L
.42031 .10849 L
.42031 .14987 L
.42032 .10491 L
.42033 .17415 L
.42034 .16381 L
.42035 .17237 L
.42036 .13753 L
.42037 .13228 L
.42038 .13519 L
.42039 .189 L
.4204 .16321 L
.42041 .14822 L
.42042 .13605 L
.42043 .16194 L
.42044 .14295 L
.42045 .10468 L
.42046 .13604 L
.42047 .16519 L
.42049 .13708 L
.4205 .17976 L
.42052 .15506 L
.42053 .12657 L
.42054 .15455 L
.42055 .14767 L
.42057 .1757 L
.42058 .17489 L
.42059 .14497 L
.4206 .16857 L
.42061 .17186 L
.42062 .18465 L
.42063 .12424 L
.42064 .13792 L
.42065 .11733 L
.42066 .12587 L
.42068 .14852 L
.42069 .13603 L
.4207 .19649 L
.42071 .20475 L
.42072 .1311 L
.42073 .10362 L
.42074 .14869 L
.42075 .14699 L
.42077 .12097 L
.42078 .11975 L
Mistroke
.42079 .1122 L
.42081 .12042 L
.42082 .11991 L
.42084 .11844 L
.42084 .14776 L
.42085 .14238 L
.42087 .1822 L
.42088 .16135 L
.42089 .12876 L
.42091 .179 L
.42092 .18079 L
.42093 .15965 L
.42095 .15073 L
.42096 .1271 L
.42098 .13013 L
.42099 .15201 L
.421 .14523 L
.42102 .16832 L
.42103 .15381 L
.42105 .15499 L
.42106 .17013 L
.42107 .12827 L
.42108 .1184 L
.42109 .14855 L
.42111 .14295 L
.42112 .19353 L
.42113 .14009 L
.42115 .17728 L
.42116 .14868 L
.42117 .12717 L
.42119 .11817 L
.4212 .17751 L
.42122 .18214 L
.42123 .14857 L
.42124 .12775 L
.42125 .14861 L
.42126 .11687 L
.42128 .13533 L
.42129 .13409 L
.42129 .15837 L
.42131 .15785 L
.42132 .17424 L
.42133 .15609 L
.42133 .13407 L
.42134 .14906 L
.42136 .13552 L
.42137 .14472 L
.42139 .18953 L
.4214 .15983 L
.42141 .13209 L
Mistroke
.42142 .15323 L
.42143 .18738 L
.42143 .16114 L
.42145 .13246 L
.42146 .13078 L
.42148 .13697 L
.42149 .14336 L
.42151 .16342 L
.42152 .14574 L
.42153 .1403 L
.42154 .13762 L
.42155 .17373 L
.42157 .14032 L
.42158 .16508 L
.4216 .21013 L
.42161 .1563 L
.42162 .12706 L
.42164 .10705 L
.42165 .14235 L
.42167 .1243 L
.42168 .12638 L
.42169 .13959 L
.4217 .17221 L
.42171 .13478 L
.42172 .13138 L
.42173 .18417 L
.42174 .1397 L
.42176 .15605 L
.42177 .12713 L
.42177 .15705 L
.42179 .13617 L
.4218 .11286 L
.42181 .14978 L
.42182 .11726 L
.42182 .14355 L
.42184 .1213 L
.42185 .15078 L
.42186 .16255 L
.42187 .17263 L
.42189 .19077 L
.4219 .14813 L
.42192 .13721 L
.42193 .15109 L
.42194 .11742 L
.42196 .17969 L
.42197 .12903 L
.42198 .10895 L
.42199 .11364 L
.422 .16795 L
.42202 .10232 L
Mistroke
.42203 .15466 L
.42205 .14612 L
.42206 .15537 L
.42207 .11973 L
.42209 .19678 L
.4221 .16885 L
.42211 .16994 L
.42212 .15093 L
.42213 .13277 L
.42214 .12825 L
.42215 .10801 L
.42217 .16544 L
.42218 .14935 L
.42219 .13908 L
.42221 .11867 L
.42222 .17326 L
.42223 .15631 L
.42225 .14394 L
.42226 .12711 L
.42227 .15868 L
.42229 .14262 L
.4223 .15133 L
.42231 .12228 L
.42232 .17229 L
.42233 .15269 L
.42235 .14325 L
.42236 .16478 L
.42237 .15982 L
.42239 .12059 L
.4224 .16643 L
.42242 .17281 L
.42242 .1307 L
.42243 .10578 L
.42245 .12757 L
.42246 .15479 L
.42246 .15503 L
.42248 .12742 L
.42249 .13268 L
.42251 .15481 L
.42252 .12439 L
.42253 .13938 L
.42254 .11949 L
.42255 .13756 L
.42256 .13212 L
.42257 .13379 L
.42259 .11502 L
.42259 .14283 L
.4226 .17952 L
.42261 .17751 L
.42262 .13351 L
Mistroke
.42263 .11288 L
.42264 .16422 L
.42265 .1089 L
.42266 .15313 L
.42267 .12543 L
.42268 .1822 L
.4227 .15857 L
.42271 .13439 L
.42273 .14237 L
.42274 .16323 L
.42275 .15648 L
.42276 .15851 L
.42277 .19281 L
.42278 .16093 L
.42279 .15207 L
.4228 .14539 L
.42281 .17395 L
.42282 .16048 L
.42283 .15026 L
.42284 .12928 L
.42285 .1374 L
.42287 .17101 L
.42288 .11746 L
.4229 .16172 L
.42291 .12911 L
.42292 .11887 L
.42293 .19006 L
.42294 .19194 L
.42296 .17352 L
.42297 .16457 L
.42298 .16059 L
.423 .10476 L
.42301 .15626 L
.42303 .1244 L
.42304 .16137 L
.42305 .13662 L
.42306 .11731 L
.42307 .16985 L
.42308 .17644 L
.42309 .15842 L
.42311 .1252 L
.42312 .17419 L
.42314 .155 L
.42315 .14626 L
.42316 .13885 L
.42317 .15057 L
.42319 .12902 L
.4232 .11982 L
.42322 .16881 L
.42323 .16852 L
Mistroke
.42324 .09516 L
.42326 .11281 L
.42327 .16606 L
.42328 .16032 L
.4233 .18728 L
.42331 .16651 L
.42333 .16158 L
.42334 .14116 L
.42336 .16553 L
.42336 .14749 L
.42337 .13261 L
.42339 .13115 L
.4234 .15244 L
.42341 .14295 L
.42342 .14449 L
.42344 .1421 L
.42345 .13221 L
.42346 .09971 L
.42347 .14257 L
.42348 .13838 L
.42349 .16946 L
.42351 .15552 L
.42352 .15034 L
.42354 .16734 L
.42355 .15595 L
.42357 .12958 L
.42358 .10877 L
.42359 .15979 L
.42361 .12371 L
.42362 .12437 L
.42363 .11278 L
.42364 .1553 L
.42366 .14651 L
.42367 .16423 L
.42369 .15793 L
.4237 .14506 L
.42371 .22197 L
.42372 .12021 L
.42373 .14543 L
.42375 .13252 L
.42375 .14331 L
.42376 .11841 L
.42377 .1902 L
.42378 .13744 L
.4238 .1462 L
.42381 .14749 L
.42382 .17998 L
.42383 .14808 L
.42384 .18498 L
.42385 .16499 L
Mistroke
.42386 .15147 L
.42387 .14258 L
.42388 .16183 L
.42389 .1354 L
.42391 .14912 L
.42392 .11913 L
.42393 .12675 L
.42394 .15105 L
.42396 .12748 L
.42398 .14486 L
.42398 .16928 L
.42399 .15565 L
.42401 .13798 L
.42402 .1774 L
.42402 .11957 L
.42404 .1282 L
.42405 .12774 L
.42407 .17314 L
.42408 .15347 L
.42409 .12693 L
.42411 .12918 L
.42412 .20238 L
.42413 .08864 L
.42415 .12889 L
.42416 .19418 L
.42418 .17317 L
.42419 .14629 L
.4242 .1491 L
.42422 .11553 L
.42423 .16439 L
.42424 .11039 L
.42426 .16872 L
.42427 .12436 L
.42429 .12924 L
.4243 .11193 L
.42431 .12742 L
.42432 .16852 L
.42433 .14815 L
.42435 .14525 L
.42436 .13682 L
.42437 .15863 L
.42438 .20226 L
.4244 .14505 L
.4244 .15065 L
.42441 .17128 L
.42443 .14498 L
.42444 .1687 L
.42445 .16208 L
.42447 .17942 L
.42448 .11598 L
Mistroke
.4245 .15688 L
.42451 .16377 L
.42452 .16315 L
.42454 .16529 L
.42455 .18934 L
.42457 .13471 L
.42458 .15286 L
.42458 .14373 L
.4246 .12979 L
.42462 .16345 L
.42463 .15445 L
.42466 .14235 L
.42467 .1373 L
.42468 .13591 L
.42469 .11679 L
.42471 .13633 L
.42472 .16211 L
.42473 .17701 L
.42474 .13171 L
.42475 .11786 L
.42476 .12981 L
.42477 .17934 L
.42478 .14722 L
.42479 .17519 L
.4248 .14311 L
.42482 .11752 L
.42483 .1699 L
.42485 .14452 L
.42486 .13228 L
.42488 .139 L
.42489 .19446 L
.4249 .145 L
.42492 .1402 L
.42493 .15775 L
.42493 .14611 L
.42495 .17374 L
.42496 .17073 L
.42497 .1457 L
.42498 .13906 L
.42499 .16108 L
.425 .19157 L
.42501 .13785 L
.42502 .13562 L
.42503 .16818 L
.42505 .12271 L
.42506 .1359 L
.42507 .14029 L
.42508 .12618 L
.42508 .12445 L
.42509 .14451 L
Mistroke
.4251 .1164 L
.42511 .14883 L
.42513 .17641 L
.42514 .14017 L
.42514 .1677 L
.42515 .14256 L
.42516 .12112 L
.42518 .13999 L
.42518 .13413 L
.42519 .16149 L
.4252 .15845 L
.42521 .11708 L
.42522 .14221 L
.42524 .14066 L
.42525 .13383 L
.42527 .15053 L
.42528 .17872 L
.4253 .10437 L
.42531 .16881 L
.42532 .19015 L
.42534 .15728 L
.42535 .18159 L
.42536 .14282 L
.42537 .14973 L
.42538 .13951 L
.4254 .16333 L
.42541 .12487 L
.42543 .13707 L
.42544 .17633 L
.42545 .14723 L
.42546 .15856 L
.42548 .1137 L
.42549 .14269 L
.42551 .13889 L
.42552 .15293 L
.42553 .15291 L
.42554 .10282 L
.42555 .1761 L
.42557 .14999 L
.42558 .17052 L
.42558 .18311 L
.4256 .15399 L
.42561 .12017 L
.42562 .15274 L
.42562 .15398 L
.42563 .15425 L
.42565 .14583 L
.42566 .14025 L
.42568 .13171 L
.42569 .13595 L
Mistroke
.42571 .13718 L
.42572 .16804 L
.42574 .12821 L
.42575 .15242 L
.42575 .15889 L
.42576 .13741 L
.42577 .13288 L
.42579 .19487 L
.4258 .15555 L
.42581 .13139 L
.42582 .15105 L
.42583 .16891 L
.42585 .1726 L
.42586 .14811 L
.42588 .17125 L
.42589 .12562 L
.42589 .14543 L
.4259 .15391 L
.42591 .08779 L
.42593 .14392 L
.42594 .15669 L
.42596 .15901 L
.42597 .1175 L
.42597 .17629 L
.42598 .11766 L
.42599 .12837 L
.426 .15801 L
.42601 .12012 L
.42602 .14209 L
.42603 .11978 L
.42604 .15859 L
.42606 .12981 L
.42607 .17439 L
.42609 .1743 L
.42609 .12374 L
.4261 .13028 L
.42611 .1337 L
.42612 .1416 L
.42613 .16404 L
.42614 .09307 L
.42615 .12708 L
.42616 .14568 L
.42618 .15714 L
.42619 .16177 L
.42621 .14824 L
.42621 .1384 L
.42622 .17968 L
.42624 .16914 L
.42625 .14106 L
.42627 .1286 L
Mistroke
.42628 .18248 L
.42628 .1264 L
.4263 .14519 L
.42631 .13788 L
.42633 .16574 L
.42634 .13163 L
.42635 .1749 L
.42637 .16248 L
.42638 .16496 L
.42639 .19016 L
.4264 .15718 L
.42641 .11398 L
.42642 .07833 L
.42643 .13499 L
.42644 .11384 L
.42646 .17431 L
.42648 .10441 L
.42649 .15216 L
.4265 .16884 L
.42651 .10949 L
.42653 .14561 L
.42654 .14804 L
.42655 .10842 L
.42657 .1495 L
.42658 .09038 L
.4266 .14901 L
.42661 .15902 L
.42662 .15572 L
.42665 .14565 L
.42667 .17671 L
.42668 .16545 L
.4267 .15127 L
.42671 .12698 L
.42672 .14794 L
.42674 .15551 L
.42675 .14849 L
.42677 .17095 L
.42678 .20359 L
.42679 .17206 L
.4268 .1596 L
.42681 .13479 L
.42683 .14263 L
.42684 .15394 L
.42684 .16646 L
.42685 .15782 L
.42686 .173 L
.42687 .15201 L
.42688 .15066 L
.42689 .14492 L
.42691 .14269 L
Mistroke
.42692 .09619 L
.42694 .12395 L
.42695 .13216 L
.42696 .13969 L
.42698 .17028 L
.42699 .14553 L
.42701 .16285 L
.42702 .12965 L
.42703 .16248 L
.42704 .16204 L
.42706 .15033 L
.42707 .15597 L
.42709 .16754 L
.4271 .11035 L
.42711 .13073 L
.42713 .1344 L
.42714 .17008 L
.42716 .1506 L
.42716 .17118 L
.42717 .15738 L
.42719 .14224 L
.4272 .08384 L
.4272 .12924 L
.42721 .18075 L
.42722 .15733 L
.42723 .11678 L
.42724 .16029 L
.42725 .17406 L
.42727 .14115 L
.42728 .18058 L
.4273 .12245 L
.42731 .18088 L
.42732 .166 L
.42733 .1443 L
.42734 .16765 L
.42736 .14882 L
.42737 .13205 L
.42738 .16659 L
.42739 .13746 L
.42739 .13259 L
.4274 .1815 L
.42741 .16959 L
.42742 .13163 L
.42743 .16368 L
.42744 .16283 L
.42746 .12914 L
.42747 .18108 L
.42749 .1429 L
.4275 .15144 L
.42751 .13606 L
Mistroke
.42752 .1913 L
.42753 .16038 L
.42755 .12246 L
.42756 .15614 L
.42756 .13935 L
.42757 .17751 L
.42758 .09746 L
.4276 .12334 L
.4276 .11986 L
.42761 .12139 L
.42763 .16783 L
.42764 .18764 L
.42766 .16161 L
.42767 .14067 L
.42769 .16402 L
.4277 .11441 L
.42771 .14015 L
.42773 .11648 L
.42774 .13942 L
.42776 .16833 L
.42776 .19218 L
.42777 .14115 L
.42779 .10576 L
.4278 .06301 L
.4278 .16419 L
.42781 .15797 L
.42782 .12611 L
.42784 .15883 L
.42784 .13582 L
.42785 .19063 L
.42787 .14772 L
.42788 .15539 L
.4279 .0965 L
.42791 .14989 L
.42793 .15614 L
.42794 .15221 L
.42795 .17176 L
.42797 .17233 L
.42798 .17047 L
.42799 .18946 L
.428 .16776 L
.42802 .125 L
.42803 .14765 L
.42805 .12669 L
.42806 .16437 L
.42807 .15899 L
.42809 .17133 L
.4281 .19204 L
.4281 .17095 L
.42812 .18142 L
Mistroke
.42813 .1764 L
.42815 .14901 L
.42816 .13738 L
.42818 .16609 L
.42819 .12723 L
.4282 .17837 L
.42822 .15115 L
.42823 .14002 L
.42825 .17495 L
.42826 .14656 L
.42828 .10571 L
.42829 .1269 L
.4283 .16159 L
.42832 .14372 L
.42833 .15903 L
.42834 .18531 L
.42835 .22426 L
.42837 .16145 L
.42838 .17278 L
.42839 .12572 L
.42841 .15078 L
.42842 .15015 L
.42843 .14992 L
.42845 .19311 L
.42846 .15106 L
.42847 .15197 L
.42849 .11331 L
.4285 .13785 L
.42851 .10817 L
.42853 .10731 L
.42854 .14082 L
.42855 .13859 L
.42856 .16675 L
.42857 .13023 L
.42859 .14407 L
.4286 .14545 L
.42862 .16987 L
.42863 .16603 L
.42865 .14276 L
.42866 .15567 L
.42867 .16037 L
.42869 .13764 L
.4287 .15608 L
.42871 .1641 L
.42873 .16555 L
.42874 .17134 L
.42876 .14436 L
.42877 .14015 L
.42878 .15576 L
.42879 .14071 L
Mistroke
.42881 .13026 L
.42882 .15029 L
.42883 .19782 L
.42885 .1587 L
.42886 .16129 L
.42888 .17762 L
.42889 .16467 L
.4289 .16341 L
.42891 .16722 L
.42893 .15797 L
.42895 .16748 L
.42897 .17325 L
.42898 .12501 L
.42899 .14958 L
.429 .16156 L
.42901 .12618 L
.42903 .16303 L
.42904 .13372 L
.42906 .17938 L
.42907 .15685 L
.42908 .12599 L
.4291 .16777 L
.42911 .12438 L
.42912 .14343 L
.42913 .18939 L
.42914 .1048 L
.42916 .17097 L
.42917 .17385 L
.42918 .14121 L
.4292 .17666 L
.42921 .18173 L
.42922 .14251 L
.42924 .17235 L
.42925 .14981 L
.42927 .17584 L
.42928 .15959 L
.42929 .15669 L
.4293 .09967 L
.42931 .16605 L
.42933 .15488 L
.42934 .16263 L
.42934 .17407 L
.42936 .12724 L
.42937 .1399 L
.42938 .14385 L
.42939 .14692 L
.42939 .16225 L
.42941 .20042 L
.42942 .11279 L
.42943 .15996 L
Mistroke
.42944 .14359 L
.42946 .15359 L
.42947 .16591 L
.42948 .13659 L
.4295 .15918 L
.42951 .14033 L
.42953 .13349 L
.42954 .13549 L
.42955 .16302 L
.42956 .16941 L
.42957 .13004 L
.42958 .16508 L
.42959 .14238 L
.42961 .15572 L
.42962 .1503 L
.42964 .12779 L
.42964 .14458 L
.42965 .17072 L
.42966 .1866 L
.42967 .10706 L
.42968 .15288 L
.4297 .11879 L
.42971 .12362 L
.42972 .16693 L
.42973 .14863 L
.42974 .16522 L
.42975 .16637 L
.42976 .10042 L
.42977 .16311 L
.42978 .13525 L
.42979 .13404 L
.4298 .16514 L
.42982 .14323 L
.42983 .15307 L
.42985 .14486 L
.42985 .14592 L
.42986 .16359 L
.42987 .14423 L
.42988 .14295 L
.42989 .18032 L
.42989 .14594 L
.42991 .14912 L
.42992 .15143 L
.42994 .13207 L
.42995 .14356 L
.42997 .12161 L
.42997 .17704 L
.42998 .14878 L
.43 .12127 L
.43001 .13247 L
Mistroke
.43003 .15292 L
.43003 .12046 L
.43004 .17633 L
.43006 .14832 L
.43007 .14556 L
.43008 .15955 L
.4301 .12648 L
.43011 .13963 L
.43013 .14735 L
.43014 .11714 L
.43015 .16455 L
.43016 .15898 L
.43017 .16861 L
.43018 .1491 L
.43019 .14298 L
.4302 .19145 L
.43022 .17731 L
.43023 .16356 L
.43025 .1716 L
.43026 .14939 L
.43027 .1425 L
.43029 .14344 L
.4303 .13653 L
.43031 .14989 L
.43033 .13052 L
.43034 .14058 L
.43036 .20721 L
.43037 .18096 L
.43038 .15554 L
.4304 .15664 L
.43041 .10917 L
.43043 .11626 L
.43044 .15915 L
.43045 .14554 L
.43047 .19315 L
.43048 .18283 L
.43048 .14497 L
.4305 .15101 L
.43052 .16576 L
.43052 .15183 L
.43053 .14241 L
.43055 .149 L
.43056 .14023 L
.43057 .17411 L
.43058 .17519 L
.43059 .14736 L
.43061 .14989 L
.43062 .14538 L
.43065 .13396 L
.43066 .13123 L
Mistroke
.43068 .1254 L
.43069 .16701 L
.43071 .14092 L
.43072 .15439 L
.43074 .18368 L
.43075 .1938 L
.43076 .12378 L
.43078 .14594 L
.43079 .12789 L
.4308 .15363 L
.43081 .14472 L
.43082 .16361 L
.43083 .14153 L
.43084 .16116 L
.43084 .16332 L
.43086 .16205 L
.43087 .14627 L
.43088 .15259 L
.43089 .1426 L
.43089 .17682 L
.4309 .18146 L
.43091 .12622 L
.43093 .16225 L
.43094 .15777 L
.43096 .15573 L
.43097 .12762 L
.43099 .13601 L
.431 .09231 L
.43101 .13529 L
.43103 .16209 L
.43104 .17998 L
.43105 .1763 L
.43106 .14268 L
.43107 .17432 L
.43109 .16022 L
.4311 .12428 L
.43111 .13005 L
.43113 .19353 L
.43114 .091 L
.43116 .1939 L
.43117 .12217 L
.43118 .19731 L
.4312 .11882 L
.43121 .11662 L
.43122 .18659 L
.43123 .12774 L
.43125 .17292 L
.43125 .13302 L
.43126 .11516 L
.43128 .18596 L
Mistroke
.43129 .13124 L
.43129 .16176 L
.4313 .13602 L
.43131 .13625 L
.43133 .11146 L
.43134 .16379 L
.43136 .19414 L
.43137 .14368 L
.43138 .12267 L
.43139 .11064 L
.4314 .14636 L
.43142 .14753 L
.43142 .16133 L
.43143 .14076 L
.43145 .13489 L
.43146 .13311 L
.43147 .13109 L
.43149 .16963 L
.4315 .15169 L
.43151 .09968 L
.43152 .15601 L
.43154 .15484 L
.43155 .17763 L
.43157 .15205 L
.43158 .11869 L
.43159 .1246 L
.43161 .15495 L
.43162 .13886 L
.43164 .16019 L
.43165 .16106 L
.43166 .13699 L
.43167 .13069 L
.43168 .15082 L
.43169 .13698 L
.43171 .16359 L
.43172 .16848 L
.43174 .16604 L
.43175 .21431 L
.43176 .15283 L
.43177 .1368 L
.43177 .09428 L
.43178 .21109 L
.43179 .16732 L
.43181 .14687 L
.43182 .19431 L
.43184 .14133 L
.43185 .1497 L
.43186 .20541 L
.43187 .13763 L
.43188 .12137 L
Mistroke
.4319 .08168 L
.43191 .14754 L
.43193 .11229 L
.43194 .10883 L
.43196 .16995 L
.43197 .16345 L
.43198 .17114 L
.432 .13854 L
.43201 .12107 L
.43203 .15333 L
.43204 .1387 L
.43206 .18697 L
.43207 .13806 L
.43208 .1262 L
.4321 .14838 L
.43211 .20933 L
.43212 .14273 L
.43213 .14852 L
.43215 .18753 L
.43216 .16577 L
.43217 .1767 L
.43219 .14707 L
.4322 .12087 L
.43221 .15007 L
.43223 .14639 L
.43224 .158 L
.43225 .12346 L
.43227 .14243 L
.43228 .15905 L
.4323 .12392 L
.43231 .15821 L
.43232 .16582 L
.43233 .16187 L
.43234 .17476 L
.43235 .16688 L
.43237 .14197 L
.43238 .16493 L
.43239 .12552 L
.4324 .16735 L
.43241 .12745 L
.43243 .20914 L
.43244 .1266 L
.43245 .17138 L
.43247 .17233 L
.43248 .16124 L
.4325 .13316 L
.4325 .13869 L
.43251 .16537 L
.43253 .17305 L
.43254 .14918 L
Mistroke
.43254 .16214 L
.43256 .12818 L
.43257 .13362 L
.43259 .17226 L
.4326 .10126 L
.43262 .1462 L
.43263 .18358 L
.43264 .1742 L
.43265 .12417 L
.43267 .17138 L
.43268 .11759 L
.4327 .16773 L
.43271 .13769 L
.43272 .13175 L
.43274 .14413 L
.43275 .1429 L
.43276 .18126 L
.43278 .12866 L
.4328 .13601 L
.43281 .13931 L
.43282 .14592 L
.43284 .16551 L
.43285 .11885 L
.43285 .14429 L
.43287 .13048 L
.43288 .19595 L
.4329 .15948 L
.43291 .13828 L
.43292 .14241 L
.43294 .16519 L
.43295 .1486 L
.43297 .17953 L
.43298 .14482 L
.43299 .08673 L
.433 .14294 L
.43301 .14717 L
.43302 .17866 L
.43303 .17094 L
.43304 .14831 L
.43306 .14775 L
.43307 .16226 L
.43309 .18153 L
.4331 .13985 L
.43311 .12676 L
.43312 .13756 L
.43314 .19548 L
.43315 .10779 L
.43317 .13871 L
.43318 .14182 L
.43319 .09554 L
Mistroke
.43321 .12558 L
.43322 .13205 L
.43323 .14476 L
.43325 .16364 L
.43327 .1544 L
.43328 .13573 L
.4333 .16806 L
.4333 .13078 L
.43331 .16105 L
.43333 .14531 L
.43334 .19545 L
.43335 .14706 L
.43336 .14873 L
.43337 .14079 L
.43338 .13876 L
.43339 .15342 L
.4334 .10623 L
.43341 .17353 L
.43342 .1356 L
.43343 .13611 L
.43344 .12709 L
.43345 .12554 L
.43347 .12976 L
.43348 .16219 L
.4335 .18363 L
.43351 .15184 L
.43353 .12977 L
.43354 .14026 L
.43355 .14947 L
.43357 .12272 L
.43358 .1495 L
.43359 .13857 L
.4336 .13391 L
.43361 .1184 L
.43363 .16596 L
.43364 .14184 L
.43365 .16713 L
.43367 .1407 L
.43368 .12206 L
.43369 .19178 L
.43371 .17588 L
.43372 .11884 L
.43373 .12826 L
.43375 .19892 L
.43376 .14759 L
.43378 .16759 L
.43379 .15385 L
.43381 .09318 L
.43382 .10651 L
.43383 .15287 L
Mistroke
.43385 .17892 L
.43386 .15803 L
.43387 .15577 L
.43388 .20475 L
.43389 .16534 L
.4339 .14332 L
.43391 .18421 L
.43392 .194 L
.43393 .1129 L
.43394 .17151 L
.43396 .16165 L
.43397 .18226 L
.43399 .20628 L
.434 .13803 L
.43401 .10986 L
.43402 .1915 L
.43403 .16644 L
.43404 .12917 L
.43405 .11734 L
.43406 .18137 L
.43408 .13682 L
.43409 .12239 L
.43411 .18247 L
.43412 .12449 L
.43413 .1765 L
.43413 .16304 L
.43414 .13975 L
.43416 .13552 L
.43417 .16107 L
.43418 .14271 L
.43419 .1532 L
.4342 .15457 L
.43421 .15384 L
.43422 .20409 L
.43423 .17046 L
.43424 .15351 L
.43425 .13947 L
.43427 .12598 L
.43428 .18786 L
.4343 .15619 L
.43431 .14629 L
.43432 .15436 L
.43434 .13591 L
.43435 .14217 L
.43437 .18293 L
.43438 .12719 L
.4344 .1858 L
.4344 .153 L
.43441 .14669 L
.43442 .1586 L
Mistroke
.43443 .14305 L
.43444 .1472 L
.43445 .14649 L
.43445 .15455 L
.43446 .16146 L
.43448 .19158 L
.43449 .16851 L
.4345 .17346 L
.4345 .14706 L
.43451 .16713 L
.43453 .17128 L
.43454 .14867 L
.43455 .13824 L
.43455 .17465 L
.43456 .16459 L
.43457 .12797 L
.43458 .13952 L
.43459 .11926 L
.43459 .15967 L
.43461 .1616 L
.43462 .16395 L
.43464 .15115 L
.43465 .11449 L
.43467 .13597 L
.43468 .17411 L
.43469 .14464 L
.4347 .15162 L
.43472 .10238 L
.43473 .15286 L
.43474 .1538 L
.43475 .1347 L
.43476 .12598 L
.43478 .16722 L
.43479 .14871 L
.4348 .15019 L
.43481 .17486 L
.43482 .13887 L
.43483 .1625 L
.43484 .17709 L
.43485 .13589 L
.43486 .16041 L
.43487 .14061 L
.43489 .16179 L
.4349 .15299 L
.43491 .16113 L
.43493 .14825 L
.43494 .15716 L
.43494 .12886 L
.43495 .10958 L
.43496 .1502 L
Mistroke
.43498 .14472 L
.43499 .14177 L
.435 .18119 L
.43502 .13782 L
.43503 .15155 L
.43506 .13984 L
.43507 .132 L
.43508 .13317 L
.43509 .19792 L
.4351 .13509 L
.43512 .18159 L
.43513 .15653 L
.43515 .15274 L
.43516 .17389 L
.43517 .20959 L
.43519 .14563 L
.4352 .17627 L
.43521 .17143 L
.43523 .18384 L
.43524 .15537 L
.43526 .1537 L
.43527 .11878 L
.43528 .12619 L
.4353 .13903 L
.43531 .17588 L
.43533 .11984 L
.43534 .13439 L
.43534 .17548 L
.43536 .14601 L
.43537 .15352 L
.43538 .17941 L
.43539 .1398 L
.4354 .13386 L
.43541 .18649 L
.43542 .09969 L
.43543 .14613 L
.43544 .15158 L
.43545 .16355 L
.43547 .12951 L
.43548 .1766 L
.43548 .11174 L
.43549 .14252 L
.4355 .14754 L
.43551 .15869 L
.43552 .11671 L
.43553 .13764 L
.43554 .16793 L
.43555 .1191 L
.43556 .15141 L
.43557 .16111 L
Mistroke
.43558 .14394 L
.43559 .18648 L
.4356 .16136 L
.43562 .13219 L
.43563 .13977 L
.43563 .13327 L
.43565 .19148 L
.43566 .14909 L
.43568 .11239 L
.43569 .13983 L
.43571 .13961 L
.43572 .14531 L
.43573 .12825 L
.43575 .12353 L
.43576 .17419 L
.43577 .17318 L
.43578 .12138 L
.43579 .15314 L
.43581 .17154 L
.43582 .17559 L
.43583 .16899 L
.43585 .1653 L
.43586 .14721 L
.43587 .12088 L
.43589 .16925 L
.4359 .16364 L
.43592 .14106 L
.43593 .18403 L
.43594 .14054 L
.43595 .10246 L
.43596 .17129 L
.43598 .16263 L
.43598 .11774 L
.43599 .17625 L
.43601 .11133 L
.43602 .12979 L
.43602 .11031 L
.43603 .1502 L
.43604 .15156 L
.43606 .1584 L
.43607 .14253 L
.43608 .12408 L
.43609 .1929 L
.43611 .1182 L
.43612 .16477 L
.43613 .14509 L
.43615 .14875 L
.43616 .18077 L
.43617 .14921 L
.43618 .15631 L
Mistroke
.43619 .19792 L
.43621 .17439 L
.43622 .14825 L
.43623 .16197 L
.43624 .15647 L
.43625 .16308 L
.43627 .14836 L
.43628 .18466 L
.43629 .15656 L
.4363 .14415 L
.43631 .16516 L
.43632 .13538 L
.43633 .18111 L
.43635 .13495 L
.43636 .15502 L
.43637 .12771 L
.43638 .16778 L
.43639 .11711 L
.4364 .16559 L
.43641 .18477 L
.43642 .18268 L
.43643 .16331 L
.43643 .17249 L
.43645 .18297 L
.43646 .16004 L
.43648 .12111 L
.43649 .10331 L
.4365 .16801 L
.43651 .10075 L
.43652 .14498 L
.43653 .15192 L
.43653 .16562 L
.43654 .17296 L
.43656 .16897 L
.43657 .14239 L
.43659 .14018 L
.43659 .16266 L
.4366 .20321 L
.43662 .15545 L
.43663 .15252 L
.43664 .20842 L
.43666 .17664 L
.43667 .19019 L
.43668 .16499 L
.43669 .15497 L
.4367 .15047 L
.43672 .12457 L
.43673 .14286 L
.43674 .1628 L
.43676 .17415 L
Mistroke
.43677 .15763 L
.43679 .15676 L
.4368 .13064 L
.43681 .13213 L
.43682 .17301 L
.43683 .1846 L
.43684 .14296 L
.43685 .16087 L
.43687 .16189 L
.43688 .19166 L
.4369 .15294 L
.43691 .17319 L
.43692 .11799 L
.43693 .19844 L
.43695 .15115 L
.43696 .15866 L
.43698 .14937 L
.43699 .15216 L
.437 .12176 L
.43702 .13322 L
.43703 .1618 L
.43704 .14379 L
.43706 .16041 L
.43707 .15187 L
.43709 .15414 L
.4371 .14669 L
.43712 .1323 L
.43713 .118 L
.43715 .15689 L
.43715 .12567 L
.43716 .14706 L
.43717 .13446 L
.43718 .17085 L
.43719 .12265 L
.43721 .11991 L
.43722 .17184 L
.43722 .15166 L
.43724 .17411 L
.43725 .16257 L
.43727 .12533 L
.43728 .11993 L
.4373 .18311 L
.43731 .1444 L
.43732 .11944 L
.43734 .16 L
.43735 .16777 L
.43737 .15422 L
.43738 .13159 L
.43739 .10821 L
.4374 .17322 L
Mistroke
.43741 .16316 L
.43743 .17469 L
.43744 .16344 L
.43746 .20351 L
.43747 .12596 L
.43748 .13982 L
.43749 .13297 L
.4375 .21872 L
.43751 .19644 L
.43752 .14478 L
.43753 .17385 L
.43754 .16397 L
.43755 .16465 L
.43756 .12214 L
.43756 .11733 L
.43757 .15127 L
.43759 .16432 L
.4376 .14035 L
.43762 .15756 L
.43763 .16398 L
.43763 .15138 L
.43765 .13311 L
.43766 .19349 L
.43768 .13279 L
.43769 .10863 L
.4377 .13005 L
.43772 .14236 L
.43772 .16822 L
.43773 .10903 L
.43775 .1703 L
.43776 .16296 L
.43777 .09824 L
.43778 .17281 L
.43779 .10236 L
.43781 .13402 L
.43782 .0769 L
.43784 .16997 L
.43785 .1591 L
.43786 .14213 L
.43788 .18857 L
.43789 .16399 L
.4379 .18538 L
.43792 .10907 L
.43793 .16541 L
.43794 .18333 L
.43796 .13289 L
.43797 .13459 L
.43799 .18336 L
.438 .10916 L
.43801 .14635 L
Mistroke
.43803 .15297 L
.43804 .14739 L
.43806 .15009 L
.43807 .17453 L
.43809 .15625 L
.4381 .1092 L
.43811 .11777 L
.43812 .19794 L
.43814 .18913 L
.43814 .14852 L
.43815 .14599 L
.43817 .13582 L
.43818 .14856 L
.43819 .17502 L
.43821 .14351 L
.43822 .14 L
.43823 .15967 L
.43825 .10834 L
.43826 .17766 L
.43828 .17909 L
.43829 .15823 L
.43831 .14273 L
.43832 .14688 L
.43834 .18904 L
.43835 .15451 L
.43836 .15436 L
.43837 .16999 L
.43838 .16118 L
.43838 .12346 L
.43839 .15382 L
.4384 .14459 L
.43841 .16239 L
.43843 .13826 L
.43844 .16254 L
.43845 .1637 L
.43846 .14216 L
.43848 .13938 L
.43849 .13611 L
.43851 .13328 L
.43852 .14528 L
.43853 .14339 L
.43854 .12482 L
.43854 .13564 L
.43856 .14797 L
.43857 .15843 L
.43859 .15034 L
.4386 .18426 L
.43861 .13744 L
.43863 .16776 L
.43864 .16811 L
Mistroke
.43864 .11953 L
.43866 .17847 L
.43867 .15383 L
.43869 .1222 L
.4387 .13799 L
.43871 .13491 L
.43873 .14354 L
.43874 .12534 L
.43876 .17522 L
.43877 .16281 L
.43878 .14239 L
.43879 .18098 L
.4388 .17315 L
.43882 .16376 L
.43883 .12653 L
.43884 .14191 L
.43885 .12887 L
.43886 .15038 L
.43887 .13824 L
.43888 .14663 L
.43889 .1966 L
.4389 .18076 L
.43891 .1414 L
.43892 .13026 L
.43893 .16604 L
.43894 .16496 L
.43896 .17846 L
.43897 .1782 L
.43899 .17359 L
.439 .17841 L
.43902 .14443 L
.43902 .15763 L
.43903 .19039 L
.43905 .1111 L
.43906 .15629 L
.43907 .16782 L
.43908 .1597 L
.43909 .15916 L
.43911 .23341 L
.43912 .14618 L
.43914 .14241 L
.43915 .16227 L
.43915 .13942 L
.43916 .16691 L
.43917 .12328 L
.43919 .14182 L
.4392 .1623 L
.43921 .14263 L
.43922 .16067 L
.43923 .11919 L
Mistroke
.43924 .10985 L
.43925 .17411 L
.43926 .17151 L
.43927 .17404 L
.43928 .20503 L
.43929 .17072 L
.4393 .16947 L
.43932 .15024 L
.43933 .14091 L
.43935 .14028 L
.43935 .14527 L
.43936 .1667 L
.43937 .13433 L
.43938 .16205 L
.43939 .15841 L
.4394 .15458 L
.43941 .17736 L
.43942 .14525 L
.43944 .16946 L
.43945 .14082 L
.43947 .13481 L
.43947 .1756 L
.43948 .146 L
.4395 .16748 L
.43951 .12494 L
.43953 .10448 L
.43953 .17268 L
.43954 .13411 L
.43956 .12867 L
.43957 .17009 L
.43958 .17926 L
.4396 .12411 L
.43961 .14832 L
.43963 .097 L
.43964 .11552 L
.43965 .12666 L
.43966 .18285 L
.43967 .15608 L
.43968 .16628 L
.43969 .15196 L
.4397 .14944 L
.43972 .1271 L
.43973 .18353 L
.43975 .12362 L
.43976 .14044 L
.43977 .17236 L
.43979 .12956 L
.4398 .16648 L
.43981 .17438 L
.43983 .14506 L
Mistroke
.43984 .14868 L
.43986 .13759 L
.43987 .2131 L
.43988 .10489 L
.4399 .13058 L
.43991 .15106 L
.43992 .16968 L
.43994 .15883 L
.43995 .123 L
.43997 .19356 L
.43998 .13924 L
.44 .15847 L
.44001 .16002 L
.44001 .17954 L
.44002 .1642 L
.44003 .16863 L
.44005 .11808 L
.44006 .1997 L
.44007 .18677 L
.44008 .12721 L
.44009 .18941 L
.44011 .15642 L
.44012 .13729 L
.44014 .16718 L
.44015 .13482 L
.44016 .17182 L
.44018 .16028 L
.44019 .13664 L
.4402 .1472 L
.44022 .1772 L
.44023 .17157 L
.44024 .15281 L
.44025 .14782 L
.44027 .1002 L
.44028 .16601 L
.4403 .17462 L
.44031 .14445 L
.44032 .15342 L
.44033 .15268 L
.44034 .16073 L
.44036 .13367 L
.44037 .16625 L
.44037 .1285 L
.44038 .1547 L
.44039 .15865 L
.4404 .15919 L
.44041 .14956 L
.44042 .14975 L
.44043 .10611 L
.44044 .12993 L
Mistroke
.44046 .14974 L
.44047 .14508 L
.44048 .15221 L
.44049 .14517 L
.4405 .11004 L
.44051 .13573 L
.44053 .19062 L
.44054 .10873 L
.44055 .1361 L
.44057 .15195 L
.44058 .15288 L
.44059 .16183 L
.4406 .16469 L
.44062 .18695 L
.44062 .16065 L
.44063 .15581 L
.44065 .16533 L
.44066 .13718 L
.44068 .14316 L
.44069 .16921 L
.4407 .15281 L
.44072 .12899 L
.44073 .12532 L
.44074 .18541 L
.44076 .13722 L
.44077 .16445 L
.44078 .15244 L
.4408 .15415 L
.44081 .13043 L
.44083 .19623 L
.44084 .11213 L
.44085 .15915 L
.44087 .18562 L
.44088 .14184 L
.4409 .1708 L
.44091 .14818 L
.44093 .14298 L
.44094 .08798 L
.44095 .18184 L
.44096 .16186 L
.44097 .16371 L
.44099 .11596 L
.441 .15431 L
.441 .18354 L
.44102 .19289 L
.44103 .16378 L
.44105 .15169 L
.44106 .1343 L
.44107 .14062 L
.44109 .15377 L
Mistroke
.4411 .14246 L
.44112 .14322 L
.44113 .19156 L
.44115 .15189 L
.44116 .14081 L
.44118 .14742 L
.44119 .13386 L
.4412 .15221 L
.44122 .10239 L
.44123 .18113 L
.44124 .168 L
.44125 .15745 L
.44126 .17027 L
.44127 .15659 L
.44128 .15286 L
.44128 .15121 L
.4413 .16418 L
.44131 .14348 L
.44132 .13216 L
.44132 .1646 L
.44133 .14273 L
.44134 .13482 L
.44135 .13079 L
.44136 .15362 L
.44137 .14525 L
.44138 .17292 L
.4414 .14885 L
.44141 .15401 L
.44143 .16898 L
.44144 .17065 L
.44146 .20186 L
.44147 .13417 L
.44148 .18482 L
.4415 .18916 L
.44151 .1338 L
.44152 .15346 L
.44154 .11642 L
.44155 .16285 L
.44157 .17164 L
.44158 .16368 L
.44159 .12645 L
.4416 .14686 L
.44162 .1623 L
.44163 .12226 L
.44164 .17897 L
.44166 .14111 L
.44167 .15505 L
.44169 .13629 L
.4417 .14169 L
.44171 .14904 L
Mistroke
.44172 .18325 L
.44174 .12142 L
.44175 .17906 L
.44176 .19331 L
.44178 .17316 L
.44179 .16817 L
.44181 .17251 L
.44181 .12872 L
.44182 .14066 L
.44184 .17731 L
.44185 .15614 L
.44187 .14302 L
.44188 .1316 L
.4419 .16139 L
.44191 .15277 L
.44192 .15987 L
.44194 .16005 L
.44195 .18791 L
.44196 .17351 L
.44198 .154 L
.44199 .14067 L
.44201 .14629 L
.44202 .16826 L
.44204 .16398 L
.44205 .13655 L
.44206 .16538 L
.44207 .135 L
.44209 .16979 L
.4421 .13697 L
.44211 .12787 L
.44213 .19242 L
.44214 .15427 L
.44215 .17546 L
.44217 .14698 L
.44218 .18739 L
.44219 .12026 L
.44221 .1419 L
.44222 .15619 L
.44223 .12697 L
.44225 .15113 L
.44226 .14116 L
.44227 .17922 L
.44228 .13936 L
.44229 .15065 L
.44231 .11072 L
.44232 .15452 L
.44233 .15406 L
.44234 .15542 L
.44235 .15893 L
.44237 .17317 L
Mistroke
.44238 .12911 L
.44239 .14539 L
.4424 .15762 L
.44242 .17023 L
.44243 .1499 L
.44244 .13237 L
.44245 .12535 L
.44246 .1403 L
.44247 .17415 L
.44248 .1314 L
.4425 .1566 L
.44251 .1675 L
.44253 .11676 L
.44254 .13101 L
.44255 .11196 L
.44257 .1109 L
.44258 .17047 L
.44259 .18223 L
.44261 .16301 L
.44262 .17418 L
.44264 .14944 L
.44265 .16108 L
.44266 .12679 L
.44268 .17426 L
.44269 .15242 L
.4427 .1125 L
.44272 .18208 L
.44273 .12299 L
.44275 .12735 L
.44276 .14612 L
.44278 .15095 L
.44279 .14138 L
.44281 .15265 L
.44282 .16841 L
.44282 .12294 L
.44284 .12987 L
.44285 .19335 L
.44286 .13266 L
.44287 .14552 L
.44288 .16039 L
.4429 .1224 L
.44291 .14854 L
.44292 .16292 L
.44294 .17842 L
.44295 .10465 L
.44297 .16675 L
.44298 .1567 L
.443 .15132 L
.44301 .15176 L
.44303 .15018 L
Mistroke
.44304 .14424 L
.44305 .15032 L
.44306 .16552 L
.44307 .18952 L
.44308 .16012 L
.44309 .17673 L
.4431 .14626 L
.44311 .1206 L
.44312 .17532 L
.44313 .14163 L
.44314 .14565 L
.44315 .16526 L
.44316 .15021 L
.44317 .13156 L
.44318 .18598 L
.44318 .14478 L
.4432 .16126 L
.44321 .15026 L
.44322 .15985 L
.44323 .19589 L
.44325 .11771 L
.44326 .13965 L
.44328 .11182 L
.44329 .12914 L
.44331 .17273 L
.44332 .13431 L
.44333 .17416 L
.44335 .10524 L
.44336 .20397 L
.44337 .16651 L
.44339 .17963 L
.4434 .15315 L
.44342 .16601 L
.44343 .14339 L
.44344 .16812 L
.44345 .14225 L
.44347 .15046 L
.44348 .15365 L
.44349 .14326 L
.44351 .15294 L
.44352 .14364 L
.44354 .16649 L
.44355 .15571 L
.44356 .13456 L
.44357 .14872 L
.44359 .13595 L
.4436 .16978 L
.44361 .14674 L
.44363 .1339 L
.44364 .12794 L
Mistroke
.44366 .09476 L
.44366 .16545 L
.44367 .15808 L
.44369 .1566 L
.4437 .16737 L
.44372 .18844 L
.44373 .15628 L
.44375 .1817 L
.44376 .14816 L
.44377 .14725 L
.44379 .17738 L
.4438 .15799 L
.44381 .14583 L
.44383 .1324 L
.44384 .13438 L
.44386 .12535 L
.44387 .12337 L
.44389 .0959 L
.4439 .11884 L
.44391 .13538 L
.44392 .19233 L
.44394 .12632 L
.44395 .1409 L
.44396 .13485 L
.44398 .15434 L
.44399 .14446 L
.444 .13475 L
.44401 .12865 L
.44403 .16956 L
.44404 .13635 L
.44405 .17525 L
.44407 .15756 L
.44408 .12395 L
.4441 .16206 L
.44411 .16746 L
.44412 .14553 L
.44413 .13296 L
.44414 .13885 L
.44416 .12213 L
.44417 .16119 L
.44419 .13032 L
.4442 .13401 L
.44421 .16313 L
.44423 .12877 L
.44424 .13354 L
.44426 .16233 L
.44427 .15757 L
.44428 .1565 L
.4443 .14874 L
.44431 .14197 L
Mistroke
.44433 .16515 L
.44434 .16906 L
.44435 .14505 L
.44436 .16733 L
.44438 .1642 L
.44439 .15088 L
.4444 .15376 L
.44442 .14434 L
.44443 .1544 L
.44445 .14069 L
.44446 .16001 L
.44447 .18752 L
.44448 .14551 L
.4445 .16287 L
.44451 .159 L
.44452 .12034 L
.44454 .16397 L
.44455 .13362 L
.44457 .14794 L
.44458 .16349 L
.4446 .18176 L
.44461 .1383 L
.44463 .14957 L
.44464 .13744 L
.44467 .1211 L
.44468 .11438 L
.4447 .14749 L
.44471 .16542 L
.44472 .18469 L
.44473 .17149 L
.44474 .15678 L
.44475 .18566 L
.44477 .13438 L
.44478 .14983 L
.4448 .16512 L
.44481 .14039 L
.44482 .17668 L
.44484 .15545 L
.44484 .1269 L
.44485 .09624 L
.44487 .13179 L
.44488 .14673 L
.44489 .12819 L
.44489 .10215 L
.4449 .18431 L
.44491 .18385 L
.44492 .11146 L
.44493 .1445 L
.44494 .15966 L
.44495 .11623 L
Mistroke
.44497 .14403 L
.44498 .19831 L
.44499 .21441 L
.445 .16289 L
.44501 .16209 L
.44503 .1005 L
.44504 .14791 L
.44506 .17124 L
.44507 .16291 L
.44508 .17601 L
.4451 .15414 L
.44511 .15215 L
.44512 .15361 L
.44513 .15263 L
.44514 .19023 L
.44515 .16982 L
.44516 .14335 L
.44518 .14676 L
.44519 .15628 L
.44521 .17645 L
.44522 .17773 L
.44522 .16895 L
.44523 .17165 L
.44524 .14677 L
.44525 .18788 L
.44526 .16108 L
.44527 .14202 L
.44528 .16327 L
.44529 .13026 L
.4453 .133 L
.44531 .08875 L
.44532 .13432 L
.44532 .1318 L
.44533 .18761 L
.44534 .17134 L
.44536 .13182 L
.44537 .16199 L
.44538 .16637 L
.4454 .14708 L
.44541 .12732 L
.44543 .1697 L
.44544 .17438 L
.44546 .16827 L
.44546 .14153 L
.44547 .16722 L
.44548 .12763 L
.44549 .13048 L
.4455 .17592 L
.44551 .11363 L
.44552 .1434 L
Mistroke
.44554 .13061 L
.44555 .13353 L
.44556 .08542 L
.44557 .18644 L
.44558 .20307 L
.44559 .11332 L
.4456 .14803 L
.44561 .13122 L
.44563 .14121 L
.44564 .16527 L
.44565 .1374 L
.44566 .15802 L
.44568 .19512 L
.44568 .14613 L
.44569 .17465 L
.44571 .16426 L
.44572 .1575 L
.44573 .17033 L
.44575 .13989 L
.44576 .15339 L
.44578 .14471 L
.44579 .15105 L
.4458 .11898 L
.44582 .15564 L
.44583 .18179 L
.44585 .17148 L
.44586 .18744 L
.44587 .1565 L
.44588 .15986 L
.4459 .15078 L
.44591 .13467 L
.44592 .17021 L
.44594 .13683 L
.44595 .18546 L
.44596 .13433 L
.44597 .24101 L
.44598 .15631 L
.44599 .16428 L
.446 .1435 L
.44601 .14468 L
.44602 .1953 L
.44604 .14191 L
.44605 .13579 L
.44605 .14785 L
.44606 .17875 L
.44607 .15266 L
.44609 .18902 L
.44609 .14652 L
.4461 .13857 L
.44611 .15534 L
Mistroke
.44612 .14017 L
.44613 .10142 L
.44614 .1751 L
.44615 .1942 L
.44616 .14582 L
.44618 .14191 L
.44619 .14538 L
.4462 .13345 L
.44621 .16965 L
.44622 .15016 L
.44623 .16118 L
.44624 .1352 L
.44626 .19198 L
.44627 .17438 L
.44628 .16146 L
.44628 .1135 L
.44629 .132 L
.4463 .16899 L
.44631 .15051 L
.44632 .14162 L
.44633 .11828 L
.44634 .16493 L
.44635 .16508 L
.44636 .16784 L
.44637 .11924 L
.44639 .16359 L
.4464 .13895 L
.4464 .17736 L
.44641 .12934 L
.44642 .17707 L
.44644 .16701 L
.44645 .16414 L
.44645 .14 L
.44647 .17962 L
.44648 .15679 L
.4465 .15842 L
.4465 .11704 L
.44651 .16454 L
.44653 .14085 L
.44654 .1668 L
.44656 .14507 L
.44657 .14404 L
.44659 .16264 L
.4466 .2003 L
.44661 .16211 L
.44663 .14426 L
.44664 .15422 L
.44665 .14279 L
.44666 .11583 L
.44667 .17481 L
Mistroke
.44669 .16668 L
.4467 .15846 L
.44672 .13051 L
.44673 .17308 L
.44674 .17379 L
.44676 .15233 L
.44677 .16277 L
.44678 .16831 L
.4468 .16479 L
.44681 .19077 L
.44682 .14468 L
.44683 .13766 L
.44685 .14978 L
.44686 .16366 L
.44687 .1364 L
.44688 .18215 L
.44689 .21627 L
.4469 .13507 L
.44691 .14499 L
.44692 .14955 L
.44693 .17428 L
.44694 .15243 L
.44696 .17192 L
.44696 .15739 L
.44697 .16606 L
.44699 .12175 L
.447 .1445 L
.44702 .12451 L
.44703 .13819 L
.44704 .13927 L
.44705 .1532 L
.44706 .1393 L
.44708 .16925 L
.44709 .15264 L
.44711 .13008 L
.44712 .16486 L
.44713 .18024 L
.44715 .15674 L
.44716 .17379 L
.44717 .13658 L
.44718 .13514 L
.44719 .14406 L
.44721 .12812 L
.44722 .16379 L
.44722 .1674 L
.44724 .18174 L
.44725 .17522 L
.44727 .12346 L
.44728 .15975 L
.4473 .17084 L
Mistroke
.44731 .16733 L
.44732 .16415 L
.44734 .21789 L
.44735 .18111 L
.44736 .16128 L
.44738 .15978 L
.44739 .14061 L
.44741 .1618 L
.44742 .21544 L
.44743 .1516 L
.44745 .16855 L
.44746 .1499 L
.44747 .13699 L
.44749 .15149 L
.4475 .15139 L
.44752 .15505 L
.44753 .17157 L
.44755 .13192 L
.44756 .15093 L
.44757 .12289 L
.44759 .12551 L
.4476 .15792 L
.44761 .15798 L
.44762 .16605 L
.44764 .174 L
.44765 .16152 L
.44766 .14671 L
.44768 .16912 L
.44769 .14567 L
.44771 .16339 L
.44772 .10684 L
.44773 .17177 L
.44774 .15635 L
.44775 .15256 L
.44776 .15362 L
.44777 .13021 L
.44778 .15455 L
.4478 .1508 L
.4478 .14048 L
.44781 .16168 L
.44783 .15095 L
.44784 .16694 L
.44785 .18381 L
.44785 .16017 L
.44786 .14689 L
.44788 .1434 L
.44789 .19976 L
.44789 .17636 L
.44791 .14793 L
.44792 .13206 L
Mistroke
.44793 .186 L
.44794 .15176 L
.44796 .16219 L
.44797 .17925 L
.44798 .17217 L
.448 .14399 L
.44801 .21048 L
.44802 .15635 L
.44803 .17381 L
.44804 .15572 L
.44805 .12024 L
.44806 .15883 L
.44808 .12647 L
.44809 .1227 L
.44809 .18074 L
.4481 .1743 L
.44811 .18326 L
.44812 .14667 L
.44814 .17264 L
.44815 .14321 L
.44817 .15771 L
.44818 .14391 L
.4482 .19761 L
.44821 .13644 L
.44822 .19212 L
.44823 .16175 L
.44824 .15287 L
.44826 .19696 L
.44827 .12897 L
.44828 .18065 L
.44829 .09398 L
.4483 .15099 L
.44832 .13589 L
.44833 .14396 L
.44835 .16019 L
.44836 .17793 L
.44837 .12486 L
.44839 .12472 L
.4484 .14468 L
.44842 .1657 L
.44843 .11142 L
.44844 .15142 L
.44845 .15583 L
.44847 .16174 L
.44848 .16444 L
.44849 .12811 L
.4485 .13982 L
.44851 .18288 L
.44853 .17768 L
.44854 .2298 L
Mistroke
.44855 .16263 L
.44857 .14784 L
.44858 .16644 L
.44858 .16463 L
.4486 .15021 L
.44861 .15528 L
.44861 .14759 L
.44862 .12848 L
.44863 .17651 L
.44864 .1416 L
.44865 .16076 L
.44866 .14652 L
.44868 .14134 L
.44869 .1492 L
.44871 .12721 L
.44872 .14355 L
.44874 .16035 L
.44875 .1501 L
.44877 .0975 L
.44878 .15917 L
.44878 .16666 L
.4488 .18093 L
.44881 .13537 L
.44882 .15445 L
.44882 .20816 L
.44883 .09362 L
.44885 .16624 L
.44886 .19062 L
.44886 .14406 L
.44887 .17033 L
.44888 .11662 L
.44889 .17943 L
.4489 .15185 L
.44891 .13389 L
.44892 .15574 L
.44893 .1706 L
.44895 .17798 L
.44896 .17948 L
.44898 .14346 L
.44899 .18639 L
.449 .13265 L
.44902 .16305 L
.44903 .11733 L
.44905 .15032 L
.44906 .16187 L
.44907 .1732 L
.44909 .18354 L
.4491 .18111 L
.44912 .13875 L
.44913 .16172 L
Mistroke
.44914 .1689 L
.44915 .13229 L
.44917 .17511 L
.44918 .14622 L
.44919 .18429 L
.44921 .1521 L
.44922 .13917 L
.44923 .15583 L
.44925 .12143 L
.44926 .15845 L
.44927 .13829 L
.44929 .15503 L
.4493 .13483 L
.44931 .13999 L
.44933 .16215 L
.44934 .1538 L
.44935 .16766 L
.44936 .15599 L
.44937 .15407 L
.44938 .18178 L
.4494 .18383 L
.44941 .1333 L
.44943 .12927 L
.44945 .16777 L
.44946 .09408 L
.44947 .14233 L
.44949 .18073 L
.4495 .15139 L
.44951 .13986 L
.44953 .14356 L
.44954 .15874 L
.44956 .15643 L
.44957 .16015 L
.44959 .1344 L
.4496 .1436 L
.4496 .1881 L
.44962 .1757 L
.44963 .19901 L
.44965 .12986 L
.44966 .14745 L
.44968 .14979 L
.44969 .14471 L
.4497 .17876 L
.44971 .13948 L
.44973 .178 L
.44974 .13553 L
.44975 .15341 L
.44977 .15141 L
.44978 .18394 L
.44979 .16805 L
Mistroke
.44981 .21303 L
.44982 .13451 L
.44983 .11722 L
.44984 .15368 L
.44985 .13292 L
.44987 .18545 L
.44988 .19136 L
.44989 .13254 L
.4499 .13974 L
.44991 .13525 L
.44993 .16726 L
.44994 .16471 L
.44995 .12918 L
.44997 .15399 L
.44998 .15229 L
.44999 .13578 L
.45 .16199 L
.45001 .13492 L
.45002 .10251 L
.45003 .15626 L
.45005 .1163 L
.45006 .1902 L
.45008 .17867 L
.45009 .13789 L
.4501 .16326 L
.45012 .18527 L
.45013 .11442 L
.45014 .17166 L
.45015 .1824 L
.45017 .10675 L
.45018 .13512 L
.4502 .15329 L
.45021 .12176 L
.45023 .13767 L
.45024 .15175 L
.45025 .16821 L
.45027 .15485 L
.45028 .14736 L
.45029 .12845 L
.45031 .15853 L
.45033 .1612 L
.45034 .15515 L
.45035 .16716 L
.45036 .16801 L
.45036 .15667 L
.45037 .15849 L
.45039 .19959 L
.4504 .14884 L
.45042 .14027 L
.45043 .19822 L
Mistroke
.45045 .19338 L
.45046 .1224 L
.45047 .13637 L
.45049 .12263 L
.4505 .15933 L
.45052 .15877 L
.45053 .13771 L
.45054 .1399 L
.45056 .17901 L
.45057 .12056 L
.45059 .15105 L
.4506 .13997 L
.45062 .12134 L
.45063 .15276 L
.45064 .14195 L
.45065 .20269 L
.45066 .13521 L
.45067 .11921 L
.45067 .14853 L
.45068 .15994 L
.4507 .18335 L
.45071 .1769 L
.45072 .12801 L
.45072 .15922 L
.45073 .15424 L
.45074 .20547 L
.45075 .18195 L
.45076 .18583 L
.45077 .17481 L
.45078 .1802 L
.4508 .14599 L
.45081 .19633 L
.45083 .1603 L
.45084 .17627 L
.45085 .16184 L
.45087 .14769 L
.45088 .13826 L
.4509 .16722 L
.45091 .1683 L
.45092 .11328 L
.45094 .18273 L
.45095 .11552 L
.45097 .13103 L
.45098 .11236 L
.45099 .16425 L
.451 .11636 L
.45102 .16284 L
.45103 .15914 L
.45104 .16112 L
.45106 .12725 L
Mistroke
.45107 .16185 L
.45108 .13917 L
.4511 .14283 L
.45111 .1514 L
.45112 .13269 L
.45114 .17097 L
.45115 .14581 L
.45116 .13032 L
.45118 .1657 L
.45119 .14976 L
.45121 .13115 L
.45122 .17507 L
.45124 .17983 L
.45125 .12753 L
.45126 .17108 L
.45128 .12698 L
.45129 .12299 L
.45131 .12931 L
.45132 .19482 L
.45133 .16487 L
.45134 .16071 L
.45135 .11718 L
.45137 .13765 L
.45138 .15965 L
.45139 .14223 L
.45141 .16051 L
.45142 .12988 L
.45143 .13107 L
.45145 .15196 L
.45146 .11627 L
.45147 .20641 L
.45149 .14302 L
.4515 .16467 L
.45151 .15186 L
.45152 .19601 L
.45154 .14143 L
.45154 .15634 L
.45155 .22026 L
.45157 .1686 L
.45158 .18854 L
.45158 .21562 L
.45159 .15516 L
.4516 .14557 L
.45162 .16946 L
.45163 .16522 L
.45163 .17073 L
.45165 .17497 L
.45167 .1327 L
.45168 .1733 L
.45169 .14631 L
Mistroke
.45171 .16397 L
.45172 .15715 L
.45174 .14992 L
.45175 .15508 L
.45175 .13457 L
.45177 .17454 L
.45178 .20122 L
.45179 .14624 L
.4518 .2098 L
.45181 .15763 L
.45183 .2041 L
.45184 .16975 L
.45185 .13663 L
.45186 .18042 L
.45187 .15258 L
.45188 .12447 L
.45189 .1491 L
.45191 .11624 L
.45192 .14696 L
.45193 .15309 L
.45194 .13654 L
.45195 .14122 L
.45196 .16106 L
.45197 .16061 L
.45198 .17407 L
.45199 .15228 L
.45199 .18739 L
.45201 .12478 L
.45202 .13931 L
.45204 .17128 L
.45205 .15903 L
.45206 .15677 L
.45207 .1377 L
.45208 .18214 L
.45209 .1163 L
.45209 .17914 L
.4521 .1504 L
.45212 .11038 L
.45213 .11917 L
.45214 .16504 L
.45216 .12535 L
.45217 .15594 L
.45218 .1712 L
.45219 .13353 L
.4522 .1748 L
.45222 .16737 L
.45223 .15968 L
.45224 .15379 L
.45225 .16412 L
.45226 .16905 L
Mistroke
.45228 .13175 L
.45229 .18134 L
.4523 .1155 L
.45232 .16003 L
.45233 .19277 L
.45235 .21627 L
.45236 .16495 L
.45237 .15098 L
.45238 .18562 L
.45239 .17376 L
.4524 .16338 L
.45241 .12972 L
.45243 .18124 L
.45244 .15134 L
.45246 .13789 L
.45247 .12888 L
.45248 .14445 L
.4525 .16299 L
.45251 .14476 L
.45252 .18625 L
.45254 .16202 L
.45255 .20625 L
.45256 .16668 L
.45258 .16324 L
.45259 .16484 L
.4526 .15417 L
.45262 .12692 L
.45263 .16973 L
.45265 .15399 L
.45266 .11535 L
.45268 .18056 L
.45268 .10952 L
.45269 .13397 L
.45271 .19138 L
.45272 .17921 L
.45273 .17031 L
.45274 .17567 L
.45276 .14338 L
.45277 .12727 L
.45278 .1639 L
.45278 .13806 L
.4528 .16193 L
.45281 .15816 L
.45283 .13055 L
.45284 .19094 L
.45286 .13222 L
.45287 .18464 L
.45288 .1765 L
.4529 .16611 L
.45291 .22491 L
Mistroke
.45293 .17312 L
.45294 .12601 L
.45295 .17412 L
.45296 .16159 L
.45297 .13996 L
.45299 .16844 L
.453 .13767 L
.45302 .13296 L
.45303 .14192 L
.45304 .14228 L
.45305 .16793 L
.45306 .18806 L
.45307 .15981 L
.45307 .17229 L
.45308 .12026 L
.45309 .16761 L
.4531 .15157 L
.45312 .10881 L
.45313 .12198 L
.45313 .17802 L
.45315 .1214 L
.45316 .19009 L
.45318 .13409 L
.45319 .18258 L
.45319 .15792 L
.45321 .11046 L
.45322 .21481 L
.45324 .186 L
.45325 .14505 L
.45326 .18685 L
.45328 .16881 L
.45329 .21428 L
.4533 .17128 L
.45331 .15302 L
.45332 .15209 L
.45333 .16721 L
.45334 .18322 L
.45336 .13605 L
.45337 .15871 L
.45339 .14367 L
.4534 .15116 L
.45341 .12299 L
.45343 .14149 L
.45344 .16851 L
.45345 .16597 L
.45347 .13996 L
.45348 .18238 L
.45349 .12659 L
.45351 .16269 L
.45352 .16014 L
Mistroke
.45354 .13531 L
.45355 .14998 L
.45356 .12166 L
.45358 .15156 L
.45359 .14157 L
.45361 .18247 L
.45362 .13247 L
.45364 .09932 L
.45365 .14587 L
.45366 .14879 L
.45367 .1646 L
.45368 .16341 L
.45368 .12103 L
.4537 .1413 L
.45371 .11045 L
.45372 .13165 L
.45373 .17771 L
.45374 .18298 L
.45376 .16807 L
.45377 .16741 L
.45379 .1541 L
.4538 .20601 L
.45381 .15759 L
.45383 .17305 L
.45384 .21281 L
.45386 .11425 L
.45387 .22113 L
.45389 .11841 L
.45389 .15873 L
.4539 .15698 L
.45392 .17173 L
.45393 .17345 L
.45395 .19652 L
.45396 .14213 L
.45397 .20803 L
.45398 .15798 L
.45399 .16045 L
.45401 .12896 L
.45402 .15302 L
.45402 .16246 L
.45403 .10391 L
.45404 .15166 L
.45405 .1631 L
.45406 .13475 L
.45407 .12476 L
.45408 .14445 L
.45409 .1454 L
.45411 .10712 L
.45412 .17792 L
.45414 .17958 L
Mistroke
.45415 .17461 L
.45417 .15927 L
.45418 .15861 L
.45419 .15732 L
.45421 .16543 L
.45422 .17093 L
.45423 .12067 L
.45425 .11724 L
.45426 .14919 L
.45428 .17744 L
.45429 .18085 L
.4543 .17504 L
.45431 .16532 L
.45433 .20959 L
.45434 .15849 L
.45435 .15969 L
.45437 .14118 L
.45438 .15894 L
.4544 .13546 L
.45441 .16971 L
.45442 .12456 L
.45443 .1478 L
.45445 .18972 L
.45446 .12395 L
.45448 .14218 L
.45449 .16902 L
.4545 .18649 L
.45451 .11444 L
.45452 .15079 L
.45453 .13921 L
.45455 .17536 L
.45456 .16947 L
.45458 .19282 L
.45458 .15096 L
.45459 .20818 L
.45461 .19893 L
.45462 .20595 L
.45463 .13611 L
.45465 .15644 L
.45466 .12561 L
.45467 .16587 L
.45469 .11814 L
.4547 .16249 L
.45471 .15255 L
.45472 .1559 L
.45473 .14412 L
.45474 .17028 L
.45475 .16821 L
.45477 .12202 L
.45478 .12872 L
Mistroke
.4548 .15836 L
.45481 .16225 L
.45482 .21845 L
.45484 .12328 L
.45485 .18732 L
.45486 .1567 L
.45488 .17367 L
.45489 .18371 L
.4549 .19834 L
.45492 .13997 L
.45493 .15034 L
.45495 .14423 L
.45496 .18986 L
.45498 .14109 L
.45499 .1618 L
.455 .14784 L
.45502 .12684 L
.45503 .1579 L
.45505 .17097 L
.45506 .18717 L
.45507 .13978 L
.45508 .20998 L
.45509 .15055 L
.45511 .14002 L
.45512 .15056 L
.45512 .14304 L
.45514 .177 L
.45515 .16006 L
.45517 .11021 L
.45518 .15272 L
.45519 .10988 L
.45521 .15462 L
.45522 .15962 L
.45524 .15613 L
.45525 .16693 L
.45527 .20379 L
.45528 .15006 L
.45529 .12764 L
.4553 .17644 L
.45531 .14565 L
.45532 .23776 L
.45533 .13596 L
.45535 .1708 L
.45536 .13394 L
.45537 .15349 L
.45537 .13478 L
.45538 .13462 L
.4554 .12786 L
.4554 .18266 L
.45541 .14834 L
Mistroke
.45543 .15622 L
.45544 .15335 L
.45544 .12532 L
.45546 .15495 L
.45547 .16949 L
.45549 .15945 L
.4555 .13859 L
.45552 .16548 L
.45553 .18433 L
.45554 .13257 L
.45556 .14393 L
.45557 .18852 L
.45559 .12772 L
.45559 .17956 L
.4556 .18359 L
.45562 .18749 L
.45563 .19311 L
.45565 .14525 L
.45566 .20713 L
.45567 .13119 L
.45569 .17812 L
.4557 .1127 L
.45571 .146 L
.45573 .12687 L
.45574 .1663 L
.45575 .1713 L
.45576 .17569 L
.45577 .15115 L
.45579 .11887 L
.4558 .19313 L
.4558 .15485 L
.45582 .17654 L
.45583 .13534 L
.45584 .1781 L
.45584 .17614 L
.45585 .16135 L
.45587 .14037 L
.45588 .13881 L
.45589 .15548 L
.4559 .18323 L
.45592 .15208 L
.45593 .13515 L
.45594 .09738 L
.45596 .16507 L
.45597 .16474 L
.45598 .13528 L
.45599 .11449 L
.456 .16695 L
.45602 .11507 L
.45603 .13355 L
Mistroke
.45604 .18834 L
.45605 .11887 L
.45607 .17226 L
.45608 .17321 L
.4561 .14721 L
.4561 .16822 L
.45611 .14606 L
.45612 .16999 L
.45613 .18142 L
.45614 .15779 L
.45616 .12256 L
.45617 .19694 L
.45618 .12915 L
.45619 .1302 L
.4562 .14376 L
.45621 .1376 L
.45622 .16795 L
.45623 .13268 L
.45624 .13976 L
.45626 .15012 L
.45627 .18888 L
.45628 .1353 L
.45629 .16493 L
.4563 .16502 L
.45631 .19441 L
.45632 .16478 L
.45633 .13543 L
.45634 .11559 L
.45635 .11645 L
.45635 .17269 L
.45637 .15969 L
.45638 .1614 L
.4564 .18487 L
.45641 .12754 L
.45642 .19226 L
.45643 .16096 L
.45644 .13002 L
.45645 .13079 L
.45647 .1442 L
.45648 .13498 L
.45649 .1563 L
.4565 .15006 L
.45651 .14169 L
.45653 .16904 L
.45654 .12179 L
.45656 .12049 L
.45657 .15456 L
.45658 .15569 L
.4566 .13322 L
.45661 .15798 L
Mistroke
.45662 .16824 L
.45663 .21006 L
.45665 .14981 L
.45666 .13144 L
.45667 .16583 L
.45668 .19703 L
.45669 .15734 L
.45671 .16553 L
.45672 .15326 L
.45673 .1902 L
.45675 .16549 L
.45676 .14444 L
.45678 .16122 L
.45678 .19785 L
.45679 .19789 L
.45681 .16908 L
.45682 .1513 L
.45683 .15392 L
.45685 .16673 L
.45686 .18435 L
.45687 .11071 L
.45688 .10803 L
.4569 .11904 L
.45693 .14187 L
.45694 .18374 L
.45696 .14992 L
.45697 .13924 L
.45697 .1387 L
.45699 .17854 L
.45701 .16847 L
.45701 .1816 L
.45702 .1337 L
.45704 .13233 L
.45705 .15732 L
.45706 .15476 L
.45708 .1461 L
.45709 .16 L
.4571 .15043 L
.45712 .15321 L
.45713 .1293 L
.45715 .1834 L
.45716 .1611 L
.45718 .14895 L
.45719 .15701 L
.45721 .18547 L
.45722 .17951 L
.45724 .16247 L
.45725 .14432 L
.45725 .16265 L
.45727 .15171 L
Mistroke
.45728 .16109 L
.45728 .11556 L
.45729 .20387 L
.4573 .13653 L
.45732 .11994 L
.45733 .16516 L
.45733 .15018 L
.45734 .16181 L
.45735 .17293 L
.45736 .14645 L
.45737 .16404 L
.45738 .16626 L
.45738 .10781 L
.4574 .11668 L
.45741 .17315 L
.45743 .19419 L
.45744 .15989 L
.45744 .19557 L
.45746 .15998 L
.45747 .18327 L
.45749 .11888 L
.4575 .18748 L
.45751 .17509 L
.45753 .13734 L
.45754 .15291 L
.45755 .19017 L
.45756 .20068 L
.45757 .18529 L
.45758 .17542 L
.45759 .17222 L
.45761 .15221 L
.45762 .13414 L
.45764 .1355 L
.45765 .155 L
.45766 .20376 L
.45768 .13577 L
.45769 .1485 L
.4577 .14813 L
.45771 .1902 L
.45773 .15603 L
.45774 .15825 L
.45776 .15006 L
.45777 .14933 L
.45778 .13149 L
.4578 .16591 L
.45781 .20904 L
.45783 .17362 L
.45784 .10187 L
.45785 .15431 L
.45787 .17791 L
Mistroke
.45788 .16527 L
.4579 .15767 L
.45791 .1696 L
.45792 .15869 L
.45792 .12727 L
.45793 .11313 L
.45795 .1831 L
.45796 .13765 L
.45798 .14792 L
.45799 .13416 L
.45801 .13903 L
.45802 .17815 L
.45803 .13528 L
.45805 .1931 L
.45806 .15638 L
.45808 .16144 L
.45809 .16066 L
.4581 .14953 L
.45812 .16137 L
.45813 .13752 L
.45815 .15898 L
.45816 .17271 L
.45818 .18329 L
.45819 .16295 L
.45819 .13516 L
.45821 .1695 L
.45822 .18373 L
.45823 .146 L
.45823 .1563 L
.45824 .17846 L
.45826 .16047 L
.45827 .15597 L
.45828 .16377 L
.45828 .14476 L
.45829 .11787 L
.45831 .15729 L
.45832 .1369 L
.45834 .18135 L
.45835 .13471 L
.45835 .13224 L
.45837 .18764 L
.45838 .17459 L
.45841 .14482 L
.45842 .1462 L
.45844 .11393 L
.45845 .13709 L
.45846 .15779 L
.45847 .13185 L
.45848 .14393 L
.4585 .14014 L
Mistroke
.45851 .16135 L
.45853 .13402 L
.45854 .16485 L
.45855 .17109 L
.45857 .12021 L
.45858 .16691 L
.45859 .17453 L
.4586 .17647 L
.45861 .14136 L
.45862 .14887 L
.45863 .17948 L
.45864 .16107 L
.45865 .13246 L
.45865 .14283 L
.45866 .14592 L
.45867 .17453 L
.45868 .17041 L
.45869 .1552 L
.45871 .14737 L
.45872 .10623 L
.45873 .16625 L
.45874 .16091 L
.45876 .16604 L
.45877 .15662 L
.45878 .14333 L
.4588 .11124 L
.45881 .18192 L
.45883 .15837 L
.45884 .18022 L
.45884 .15374 L
.45886 .19295 L
.45887 .13284 L
.45888 .17416 L
.45889 .16556 L
.4589 .17342 L
.45892 .16148 L
.45893 .11364 L
.45895 .18227 L
.45896 .1597 L
.45897 .18643 L
.45897 .16962 L
.45898 .15864 L
.459 .15125 L
.45901 .13034 L
.45902 .1686 L
.45903 .17241 L
.45905 .13397 L
.45905 .13636 L
.45906 .12106 L
.45907 .11878 L
Mistroke
.45908 .16051 L
.45909 .20703 L
.4591 .17949 L
.45911 .14247 L
.45913 .19966 L
.45914 .18209 L
.45915 .16258 L
.45916 .17663 L
.45917 .1476 L
.45919 .16153 L
.4592 .15089 L
.45921 .15005 L
.45922 .17358 L
.45923 .13195 L
.45925 .14382 L
.45926 .14894 L
.45927 .22599 L
.45928 .13618 L
.4593 .14082 L
.45931 .15147 L
.45932 .1833 L
.45934 .15713 L
.45935 .18344 L
.45937 .12691 L
.45938 .15792 L
.45939 .16574 L
.4594 .1637 L
.45941 .17338 L
.45942 .14059 L
.45944 .17413 L
.45945 .1779 L
.45947 .1773 L
.45948 .1222 L
.45949 .12212 L
.45951 .15931 L
.45952 .1517 L
.45954 .12387 L
.45955 .11676 L
.45956 .14931 L
.45957 .1455 L
.45958 .15214 L
.4596 .17045 L
.45961 .18595 L
.45962 .15137 L
.45963 .17199 L
.45964 .20539 L
.45965 .16341 L
.45966 .12245 L
.45967 .18656 L
.45968 .1973 L
Mistroke
.45969 .17566 L
.45971 .17364 L
.45972 .1756 L
.45973 .12452 L
.45975 .13334 L
.45976 .13043 L
.45977 .1807 L
.45978 .15262 L
.45979 .16958 L
.4598 .14437 L
.45981 .16546 L
.45983 .15625 L
.45984 .16185 L
.45986 .12437 L
.45986 .15369 L
.45987 .15353 L
.45989 .19206 L
.4599 .16656 L
.45992 .18937 L
.45993 .14726 L
.45995 .18203 L
.45996 .16768 L
.45997 .14154 L
.45999 .13933 L
.46 .18613 L
.46001 .15222 L
.46003 .16716 L
.46004 .14467 L
.46005 .1772 L
.46005 .13243 L
.46006 .09927 L
.46008 .14605 L
.46009 .16782 L
.4601 .13905 L
.46011 .12827 L
.46012 .15979 L
.46013 .14772 L
.46014 .13675 L
.46015 .13276 L
.46016 .15674 L
.46017 .12462 L
.46019 .14643 L
.4602 .17557 L
.4602 .16204 L
.46022 .14469 L
.46023 .16532 L
.46025 .17801 L
.46026 .1441 L
.46028 .1476 L
.46029 .16566 L
Mistroke
.46031 .15616 L
.46032 .1362 L
.46033 .16537 L
.46034 .14733 L
.46036 .1886 L
.46036 .15791 L
.46037 .16677 L
.46039 .14288 L
.4604 .17871 L
.46041 .15643 L
.46043 .12913 L
.46044 .08843 L
.46045 .16032 L
.46047 .125 L
.46048 .19599 L
.4605 .20416 L
.46051 .14836 L
.46053 .17058 L
.46054 .14724 L
.46056 .18156 L
.46057 .16341 L
.46059 .16698 L
.46059 .18294 L
.4606 .1569 L
.46062 .177 L
.46063 .1171 L
.46063 .16154 L
.46064 .1365 L
.46065 .14832 L
.46067 .17711 L
.46067 .16225 L
.46068 .15292 L
.46069 .10613 L
.4607 .14362 L
.46071 .13781 L
.46072 .15329 L
.46073 .19641 L
.46073 .15206 L
.46075 .1697 L
.46076 .16949 L
.46078 .16772 L
.46079 .19206 L
.46081 .14446 L
.46082 .14607 L
.46084 .15653 L
.46085 .11936 L
.46086 .13434 L
.46088 .11411 L
.46089 .16756 L
.46091 .17627 L
Mistroke
.46092 .17489 L
.46093 .12025 L
.46095 .16817 L
.46096 .12517 L
.46097 .16967 L
.46098 .14407 L
.461 .15369 L
.46101 .16824 L
.46102 .1438 L
.46104 .14465 L
.46105 .17614 L
.46106 .19611 L
.46108 .16233 L
.46109 .1628 L
.4611 .16072 L
.46112 .16805 L
.46113 .14858 L
.46113 .118 L
.46115 .17137 L
.46116 .18814 L
.46118 .13551 L
.46119 .15515 L
.4612 .1752 L
.46122 .13847 L
.46123 .18215 L
.46124 .12888 L
.46125 .18482 L
.46126 .13564 L
.46128 .14166 L
.46129 .15335 L
.4613 .15838 L
.46132 .18787 L
.46133 .20669 L
.46135 .2003 L
.46135 .1579 L
.46136 .13882 L
.46138 .17362 L
.46139 .17154 L
.46139 .15545 L
.46141 .16009 L
.46142 .13073 L
.46144 .1748 L
.46145 .18845 L
.46147 .23239 L
.46148 .15847 L
.46149 .13209 L
.4615 .14947 L
.46152 .14748 L
.46153 .17609 L
.46155 .17493 L
Mistroke
.46156 .16014 L
.46157 .16529 L
.46159 .15547 L
.4616 .13029 L
.46161 .17699 L
.46163 .14154 L
.46165 .12865 L
.46166 .14459 L
.46167 .15858 L
.46169 .18555 L
.4617 .11949 L
.46172 .17224 L
.46173 .15105 L
.46174 .18809 L
.46175 .18968 L
.46176 .1697 L
.46177 .16218 L
.46178 .17609 L
.4618 .15451 L
.46181 .11683 L
.46182 .16796 L
.46184 .13301 L
.46185 .13192 L
.46186 .18768 L
.46188 .13141 L
.46189 .12494 L
.46191 .15812 L
.46192 .16412 L
.46194 .15019 L
.46195 .19016 L
.46196 .16926 L
.46198 .13622 L
.46199 .19312 L
.462 .19208 L
.46201 .13849 L
.46202 .14609 L
.46203 .17799 L
.46204 .16533 L
.46205 .14066 L
.46206 .16998 L
.46207 .155 L
.46208 .14877 L
.46209 .13636 L
.4621 .18304 L
.4621 .09972 L
.46211 .16568 L
.46212 .14254 L
.46213 .14506 L
.46214 .16178 L
.46216 .16165 L
Mistroke
.46217 .16222 L
.46219 .12993 L
.4622 .14596 L
.46222 .17236 L
.46223 .16327 L
.46224 .12753 L
.46226 .15158 L
.46227 .14377 L
.46228 .15333 L
.4623 .15658 L
.46231 .18263 L
.46233 .16128 L
.46234 .16921 L
.46236 .1319 L
.46237 .17669 L
.46238 .16882 L
.46239 .15538 L
.4624 .17211 L
.46242 .156 L
.46243 .13755 L
.46245 .14636 L
.46246 .16992 L
.46247 .15908 L
.46248 .14413 L
.4625 .1459 L
.46251 .18191 L
.46252 .09824 L
.46254 .126 L
.46255 .12873 L
.46256 .131 L
.46258 .18304 L
.46259 .1317 L
.4626 .15574 L
.46261 .14555 L
.46262 .11996 L
.46264 .10577 L
.46265 .15742 L
.46267 .12481 L
.46268 .14557 L
.4627 .14955 L
.46271 .19544 L
.46271 .15715 L
.46273 .12981 L
.46274 .14004 L
.46276 .15536 L
.46277 .10462 L
.46279 .17267 L
.4628 .17404 L
.46281 .15744 L
.46283 .15537 L
Mistroke
.46284 .14894 L
.46286 .16614 L
.46287 .14567 L
.46288 .18699 L
.46289 .13543 L
.4629 .17026 L
.46292 .17307 L
.46293 .16779 L
.46296 .15501 L
.46297 .14939 L
.46298 .2052 L
.46299 .16785 L
.46301 .16741 L
.46302 .14831 L
.46303 .17466 L
.46304 .10806 L
.46305 .17614 L
.46306 .17299 L
.46307 .14912 L
.46308 .15046 L
.46309 .12369 L
.4631 .15012 L
.46311 .14359 L
.46312 .13856 L
.46314 .17335 L
.46314 .13641 L
.46315 .14346 L
.46318 .16691 L
.4632 .15206 L
.46321 .18379 L
.46323 .17962 L
.46324 .19643 L
.46325 .18374 L
.46326 .15187 L
.46327 .20138 L
.46327 .14029 L
.46329 .15066 L
.4633 .2075 L
.46331 .13187 L
.46332 .12265 L
.46332 .1444 L
.46333 .16687 L
.46334 .15567 L
.46336 .20569 L
.46337 .12518 L
.46338 .14172 L
.46339 .18425 L
.4634 .15563 L
.46342 .15993 L
.46343 .15433 L
Mistroke
.46344 .16309 L
.46346 .19622 L
.46347 .16154 L
.46347 .17543 L
.46349 .14561 L
.4635 .17301 L
.46351 .16905 L
.46351 .16308 L
.46352 .12887 L
.46353 .17813 L
.46354 .14237 L
.46355 .14626 L
.46357 .1482 L
.46358 .16619 L
.4636 .15676 L
.46361 .12014 L
.46363 .15658 L
.46364 .20481 L
.46366 .17169 L
.46366 .15677 L
.46367 .15427 L
.46369 .14157 L
.4637 .15798 L
.46371 .19216 L
.46373 .15888 L
.46374 .13866 L
.46375 .1643 L
.46377 .15758 L
.46378 .15857 L
.4638 .12593 L
.46381 .16231 L
.46383 .11236 L
.46383 .15736 L
.46384 .15041 L
.46386 .16081 L
.46387 .15675 L
.46388 .16643 L
.46389 .19796 L
.4639 .17935 L
.46391 .16152 L
.46392 .15556 L
.46393 .15032 L
.46394 .17775 L
.46395 .17627 L
.46397 .15581 L
.46398 .16817 L
.464 .1907 L
.46401 .12584 L
.46402 .17176 L
.46403 .1691 L
Mistroke
.46404 .18791 L
.46405 .1529 L
.46406 .15367 L
.46407 .21668 L
.46407 .15182 L
.46409 .18611 L
.4641 .14704 L
.46412 .15933 L
.46413 .18398 L
.46414 .1939 L
.46415 .18261 L
.46416 .17842 L
.46417 .14744 L
.46418 .14548 L
.4642 .20305 L
.46421 .19313 L
.46423 .17834 L
.46424 .15885 L
.46426 .1313 L
.46427 .17575 L
.46429 .12605 L
.4643 .1996 L
.4643 .12507 L
.46432 .14005 L
.46433 .1227 L
.46434 .1367 L
.46436 .13329 L
.46437 .1534 L
.46438 .15859 L
.46439 .16883 L
.4644 .1313 L
.46442 .13145 L
.46443 .16999 L
.46444 .17763 L
.46446 .18206 L
.46447 .1831 L
.46448 .16007 L
.4645 .18141 L
.46451 .14641 L
.46453 .17707 L
.46454 .14273 L
.46456 .12495 L
.46457 .19745 L
.46458 .1821 L
.4646 .16173 L
.46461 .17718 L
.46462 .15059 L
.46463 .12075 L
.46464 .11847 L
.46466 .1877 L
Mistroke
.46467 .17278 L
.46469 .11488 L
.4647 .14518 L
.46471 .18449 L
.46472 .16467 L
.46474 .20542 L
.46475 .15405 L
.46477 .15408 L
.46478 .16754 L
.46478 .16773 L
.4648 .17314 L
.46481 .14749 L
.46482 .19929 L
.46483 .18407 L
.46484 .16826 L
.46485 .12554 L
.46486 .15168 L
.46487 .15562 L
.46488 .20106 L
.46489 .1602 L
.4649 .17587 L
.46491 .17572 L
.46493 .16071 L
.46494 .12272 L
.46496 .15874 L
.46497 .14305 L
.46498 .13876 L
.465 .11695 L
.46501 .15087 L
.46502 .1492 L
.46503 .19182 L
.46505 .15797 L
.46506 .18255 L
.46507 .13948 L
.46508 .17264 L
.46509 .14315 L
.46509 .12859 L
.46511 .15154 L
.46512 .15821 L
.46513 .15294 L
.46514 .17795 L
.46515 .15813 L
.46516 .15984 L
.46517 .17552 L
.46519 .12088 L
.4652 .16059 L
.46522 .14927 L
.46523 .15666 L
.46524 .15863 L
.46526 .14757 L
Mistroke
.46527 .15977 L
.46529 .1645 L
.4653 .16035 L
.46531 .14007 L
.46532 .17379 L
.46533 .20176 L
.46534 .17476 L
.46536 .17393 L
.46537 .15424 L
.46538 .1827 L
.4654 .17652 L
.46541 .11924 L
.46542 .15247 L
.46544 .16363 L
.46545 .15333 L
.46547 .11419 L
.46548 .1466 L
.4655 .15057 L
.46551 .14238 L
.46552 .22429 L
.46554 .13492 L
.46555 .1975 L
.46555 .15263 L
.46557 .16106 L
.46558 .20535 L
.4656 .18395 L
.46561 .15769 L
.46562 .20246 L
.46563 .20948 L
.46565 .13867 L
.46566 .13128 L
.46568 .17601 L
.46569 .16215 L
.46571 .14592 L
.46571 .18209 L
.46572 .13816 L
.46574 .21692 L
.46575 .14902 L
.46576 .10527 L
.46577 .12199 L
.46578 .1566 L
.46579 .18265 L
.4658 .16493 L
.46581 .15584 L
.46582 .16591 L
.46583 .10901 L
.46584 .18289 L
.46585 .19827 L
.46587 .15302 L
.46588 .21535 L
Mistroke
.46589 .16687 L
.46591 .1726 L
.46592 .15573 L
.46594 .13815 L
.46595 .15441 L
.46595 .1844 L
.46597 .19615 L
.46598 .15607 L
.46599 .17655 L
.466 .16892 L
.46601 .1379 L
.46603 .1784 L
.46605 .10816 L
.46606 .17074 L
.46607 .19252 L
.46608 .1367 L
.46609 .14608 L
.46609 .1684 L
.46611 .11616 L
.46612 .19401 L
.46613 .16322 L
.46614 .16672 L
.46616 .14907 L
.46617 .17872 L
.46617 .10199 L
.46618 .15791 L
.46619 .16993 L
.4662 .14616 L
.46621 .13417 L
.46622 .20139 L
.46624 .17622 L
.46625 .14688 L
.46627 .18451 L
.46628 .17437 L
.46628 .12048 L
.46629 .20891 L
.4663 .11774 L
.46631 .16957 L
.46632 .14271 L
.46633 .20356 L
.46635 .13485 L
.46636 .15508 L
.46637 .14863 L
.46639 .16201 L
.4664 .22337 L
.4664 .17152 L
.46642 .16294 L
.46643 .1688 L
.46645 .13863 L
.46646 .20004 L
Mistroke
.46646 .20713 L
.46648 .16088 L
.46649 .16677 L
.46651 .1502 L
.46652 .11977 L
.46653 .1632 L
.46655 .14229 L
.46656 .16743 L
.46657 .16166 L
.46658 .17698 L
.46659 .17386 L
.4666 .15114 L
.46661 .17413 L
.46663 .22117 L
.46664 .15435 L
.46666 .16405 L
.46667 .15864 L
.46668 .13015 L
.4667 .12683 L
.46671 .1366 L
.46672 .18117 L
.46673 .17282 L
.46675 .15099 L
.46676 .16838 L
.46678 .20702 L
.46679 .17409 L
.4668 .14219 L
.46682 .17044 L
.46683 .18417 L
.46685 .14497 L
.46686 .13557 L
.46687 .15593 L
.46689 .16171 L
.4669 .16029 L
.46692 .20731 L
.46693 .16428 L
.46694 .16506 L
.46695 .19522 L
.46697 .17785 L
.46698 .13497 L
.46698 .1906 L
.467 .18904 L
.46701 .16692 L
.46703 .18713 L
.46704 .10685 L
.46705 .16136 L
.46707 .18461 L
.46708 .19262 L
.4671 .13188 L
.46711 .1826 L
Mistroke
.46712 .15948 L
.46714 .15615 L
.46715 .16179 L
.46717 .14778 L
.46718 .21431 L
.4672 .15815 L
.46721 .16418 L
.46722 .16427 L
.46723 .18444 L
.46724 .17297 L
.46725 .14926 L
.46726 .18185 L
.46726 .15886 L
.46728 .18046 L
.46729 .19171 L
.4673 .15819 L
.4673 .17347 L
.46731 .1502 L
.46732 .15254 L
.46733 .14542 L
.46734 .15261 L
.46735 .11791 L
.46736 .16808 L
.46738 .15375 L
.46739 .13017 L
.46741 .13238 L
.46742 .16615 L
.46744 .15514 L
.46745 .16184 L
.46746 .21467 L
.46748 .1777 L
.46749 .18859 L
.4675 .16803 L
.46752 .18847 L
.46753 .16247 L
.46755 .18465 L
.46756 .17405 L
.46757 .14132 L
.46758 .11612 L
.4676 .15404 L
.46761 .18082 L
.46762 .15296 L
.46764 .15628 L
.46765 .18425 L
.46767 .12528 L
.46768 .18375 L
.46769 .16573 L
.4677 .14137 L
.46772 .14694 L
.46773 .13912 L
Mistroke
.46774 .15392 L
.46776 .13082 L
.46777 .12318 L
.46779 .15409 L
.46779 .15391 L
.4678 .18139 L
.46782 .13272 L
.46783 .1504 L
.46785 .17266 L
.46785 .17349 L
.46786 .13526 L
.46788 .17761 L
.46789 .11326 L
.4679 .177 L
.46792 .15578 L
.46793 .15293 L
.46794 .12206 L
.46796 .16196 L
.46797 .15638 L
.46798 .15661 L
.46799 .15799 L
.468 .20025 L
.46801 .14758 L
.46802 .17954 L
.46804 .14942 L
.46805 .19914 L
.46807 .14147 L
.46808 .16517 L
.46809 .19157 L
.46811 .1334 L
.46812 .15917 L
.46813 .15613 L
.46815 .18382 L
.46816 .15177 L
.46817 .17297 L
.46819 .12907 L
.4682 .12932 L
.46821 .20806 L
.46823 .16928 L
.46824 .16222 L
.46826 .12567 L
.46827 .17007 L
.46829 .13073 L
.4683 .18902 L
.46832 .18329 L
.46833 .1615 L
.46834 .20132 L
.46835 .16563 L
.46836 .13332 L
.46838 .19574 L
Mistroke
.46839 .19489 L
.46839 .17824 L
.46841 .1727 L
.46842 .13254 L
.46844 .16765 L
.46845 .10534 L
.46846 .18906 L
.46848 .19577 L
.46849 .15703 L
.46851 .13881 L
.46852 .18352 L
.46854 .13151 L
.46855 .13587 L
.46857 .15989 L
.46858 .13425 L
.4686 .201 L
.4686 .16207 L
.46861 .14952 L
.46863 .15761 L
.46864 .16717 L
.46865 .13362 L
.46866 .17765 L
.46867 .16617 L
.46868 .16302 L
.46869 .17103 L
.4687 .15682 L
.46871 .14433 L
.46873 .155 L
.46874 .13655 L
.46875 .16685 L
.46876 .15708 L
.46877 .14506 L
.46879 .16349 L
.4688 .14629 L
.46882 .17276 L
.46883 .12485 L
.46884 .15752 L
.46886 .12045 L
.46887 .14988 L
.46889 .15939 L
.46889 .18395 L
.4689 .18899 L
.46891 .17403 L
.46892 .21819 L
.46893 .20573 L
.46894 .18183 L
.46895 .12291 L
.46897 .16864 L
.46898 .18215 L
.469 .16524 L
Mistroke
.46901 .16602 L
.46903 .1453 L
.46903 .13352 L
.46904 .16672 L
.46906 .17892 L
.46907 .21204 L
.46907 .17426 L
.46909 .20483 L
.4691 .14658 L
.46912 .13689 L
.46913 .15649 L
.46914 .16798 L
.46915 .1605 L
.46916 .19767 L
.46916 .15754 L
.46918 .16783 L
.4692 .11772 L
.4692 .15228 L
.46921 .17881 L
.46923 .15415 L
.46924 .10245 L
.46925 .19495 L
.46925 .11684 L
.46926 .15144 L
.46927 .12088 L
.46928 .15376 L
.46929 .13063 L
.46931 .16782 L
.46932 .1824 L
.46933 .17591 L
.46936 .15029 L
.46936 .1935 L
.46937 .13629 L
.46939 .18184 L
.4694 .18408 L
.46942 .16778 L
.46943 .14986 L
.46944 .17184 L
.46946 .14607 L
.46947 .18462 L
.46949 .18836 L
.4695 .17931 L
.46951 .16979 L
.46953 .16045 L
.46954 .14763 L
.46956 .18569 L
.46957 .09734 L
.46958 .15014 L
.46959 .15197 L
.46961 .1386 L
Mistroke
.46961 .14512 L
.46962 .16631 L
.46963 .18498 L
.46964 .14301 L
.46965 .15651 L
.46966 .15168 L
.46967 .12405 L
.46968 .09325 L
.46969 .14494 L
.4697 .14339 L
.46972 .11425 L
.46973 .16725 L
.46974 .14356 L
.46975 .17978 L
.46977 .16852 L
.46978 .11399 L
.46979 .14522 L
.46981 .10159 L
.46982 .14396 L
.46983 .16131 L
.46984 .13708 L
.46986 .14829 L
.46987 .18906 L
.46988 .16915 L
.4699 .13497 L
.46991 .19129 L
.46992 .14159 L
.46994 .17922 L
.46995 .17656 L
.46997 .18107 L
.46998 .1686 L
.46999 .17743 L
.47 .16542 L
.47001 .16036 L
.47003 .15009 L
.47004 .17874 L
.47005 .1586 L
.47006 .1587 L
.47007 .19338 L
.47008 .12534 L
.47009 .17554 L
.4701 .16403 L
.47011 .14093 L
.47012 .15444 L
.47014 .1396 L
.47015 .17197 L
.47016 .17671 L
.47017 .17047 L
.47018 .16181 L
.47019 .13833 L
Mistroke
.4702 .17466 L
.47021 .14218 L
.47023 .2054 L
.47024 .21044 L
.47025 .17577 L
.47027 .18134 L
.47028 .16215 L
.47029 .17696 L
.4703 .17368 L
.47032 .20873 L
.47033 .1299 L
.47034 .1436 L
.47036 .19362 L
.47037 .18569 L
.47039 .12376 L
.4704 .19496 L
.47041 .17372 L
.47043 .15464 L
.47044 .18823 L
.47045 .15286 L
.47046 .1453 L
.47047 .14525 L
.47049 .20962 L
.4705 .16044 L
.47052 .1829 L
.47053 .16029 L
.47054 .12625 L
.47055 .15947 L
.47056 .13471 L
.47057 .16679 L
.47057 .17006 L
.47058 .15704 L
.4706 .18315 L
.47061 .15917 L
.47063 .14533 L
.47064 .17453 L
.47066 .14393 L
.47066 .19121 L
.47067 .15329 L
.47069 .14497 L
.4707 .16226 L
.47072 .18329 L
.47073 .13824 L
.47073 .13277 L
.47075 .1779 L
.47076 .14237 L
.47078 .16455 L
.47079 .18919 L
.4708 .1937 L
.47082 .17371 L
Mistroke
.47083 .14855 L
.47084 .18721 L
.47085 .18901 L
.47086 .17988 L
.47087 .15912 L
.47088 .1449 L
.47089 .15961 L
.47091 .1382 L
.47093 .16806 L
.47094 .14904 L
.47095 .15041 L
.47096 .16487 L
.47098 .165 L
.47099 .16706 L
.471 .11021 L
.47102 .14242 L
.47103 .19229 L
.47105 .15927 L
.47106 .13598 L
.47107 .15635 L
.47109 .16521 L
.4711 .14865 L
.47112 .23475 L
.47113 .12982 L
.47114 .11646 L
.47116 .15919 L
.47117 .16031 L
.47119 .10505 L
.4712 .18107 L
.4712 .15308 L
.47121 .11283 L
.47122 .20863 L
.47124 .19292 L
.47125 .13606 L
.47127 .13742 L
.47128 .15448 L
.47129 .19287 L
.47131 .19953 L
.47132 .1776 L
.47133 .18177 L
.47135 .13223 L
.47136 .18381 L
.47138 .16015 L
.47139 .13766 L
.47141 .12082 L
.47142 .13233 L
.47144 .15781 L
.47145 .15281 L
.47146 .18041 L
.47147 .19379 L
Mistroke
.47148 .15993 L
.47148 .14017 L
.4715 .16259 L
.47151 .14896 L
.47152 .1268 L
.47153 .179 L
.47154 .13583 L
.47155 .15029 L
.47156 .13875 L
.47158 .13802 L
.47159 .15468 L
.47159 .1466 L
.47161 .18044 L
.47162 .12165 L
.47163 .16717 L
.47164 .16583 L
.47164 .14815 L
.47166 .14214 L
.47167 .19885 L
.47169 .1824 L
.4717 .16247 L
.47172 .14189 L
.47173 .16273 L
.47174 .14661 L
.47176 .13751 L
.47177 .18225 L
.47179 .16872 L
.4718 .14915 L
.47182 .15464 L
.47183 .13555 L
.47184 .1312 L
.47185 .14674 L
.47186 .16353 L
.47188 .18843 L
.47189 .14312 L
.47191 .13275 L
.47192 .15689 L
.47193 .11695 L
.47195 .13316 L
.47196 .10939 L
.47198 .15161 L
.47199 .15957 L
.472 .14936 L
.47202 .20737 L
.47203 .18395 L
.47204 .15615 L
.47206 .12533 L
.47207 .18245 L
.47209 .14891 L
.4721 .14517 L
Mistroke
.47211 .16496 L
.47213 .14527 L
.47214 .19457 L
.47215 .12979 L
.47217 .19123 L
.47218 .18348 L
.47219 .1311 L
.4722 .14163 L
.47222 .1732 L
.47223 .18288 L
.47224 .20433 L
.47225 .16742 L
.47227 .16086 L
.47228 .21486 L
.4723 .17465 L
.47231 .16573 L
.47232 .17969 L
.47234 .15791 L
.47235 .16518 L
.47236 .15181 L
.47237 .13996 L
.47239 .19786 L
.47239 .18408 L
.4724 .16632 L
.47242 .18778 L
.47243 .13465 L
.47243 .16814 L
.47244 .12198 L
.47245 .1972 L
.47247 .14211 L
.47248 .19577 L
.47248 .15179 L
.4725 .15983 L
.47251 .12933 L
.47253 .1589 L
.47254 .13913 L
.47256 .16728 L
.47257 .15152 L
.47259 .13734 L
.4726 .12583 L
.47262 .1406 L
.47263 .19423 L
.47264 .1355 L
.47265 .14311 L
.47267 .19092 L
.47268 .16183 L
.47269 .20258 L
.4727 .19001 L
.47271 .16753 L
.47273 .1461 L
Mistroke
.47274 .15043 L
.47274 .14932 L
.47275 .11434 L
.47276 .18483 L
.47278 .14709 L
.47279 .17083 L
.4728 .16575 L
.47281 .13158 L
.47282 .15751 L
.47283 .20605 L
.47284 .15975 L
.47286 .1458 L
.47286 .1443 L
.47287 .14808 L
.47289 .16091 L
.4729 .14416 L
.47292 .11677 L
.47293 .21082 L
.47294 .16431 L
.47295 .14492 L
.47296 .17635 L
.47297 .12487 L
.47298 .14056 L
.47299 .1713 L
.473 .14334 L
.47301 .1608 L
.47302 .16415 L
.47304 .16641 L
.47305 .13906 L
.47306 .1651 L
.47307 .19251 L
.47308 .18362 L
.4731 .17305 L
.47311 .10453 L
.47313 .18284 L
.47314 .17502 L
.47315 .23247 L
.47316 .12623 L
.47317 .18147 L
.47319 .15217 L
.4732 .15633 L
.47321 .15336 L
.47323 .11044 L
.47324 .12384 L
.47325 .15233 L
.47327 .18709 L
.47328 .1508 L
.4733 .17987 L
.4733 .15152 L
.47331 .17701 L
Mistroke
.47332 .16348 L
.47333 .17948 L
.47334 .18526 L
.47336 .18819 L
.47337 .20017 L
.47338 .17717 L
.47338 .16734 L
.47339 .1735 L
.47341 .18404 L
.47342 .12081 L
.47342 .17955 L
.47344 .15162 L
.47345 .15433 L
.47346 .15218 L
.47347 .17715 L
.47349 .14303 L
.4735 .17372 L
.47352 .18962 L
.47353 .21102 L
.47354 .20329 L
.47356 .16263 L
.47357 .19307 L
.47359 .17823 L
.4736 .15037 L
.47362 .1858 L
.47363 .15137 L
.47365 .19434 L
.47366 .14457 L
.47366 .14469 L
.47368 .16254 L
.47369 .15333 L
.4737 .12469 L
.47372 .19585 L
.47373 .16496 L
.47375 .17185 L
.47376 .21077 L
.47378 .15949 L
.47378 .15754 L
.47379 .10826 L
.4738 .17254 L
.47381 .14458 L
.47382 .12655 L
.47384 .16108 L
.47385 .19182 L
.47385 .18307 L
.47387 .17655 L
.47388 .17245 L
.47389 .18916 L
.4739 .14736 L
.4739 .16822 L
Mistroke
.47391 .16704 L
.47392 .2123 L
.47394 .15392 L
.47395 .18881 L
.47396 .19361 L
.47397 .1154 L
.47398 .15525 L
.474 .17937 L
.47401 .16302 L
.47403 .13728 L
.47404 .1488 L
.47405 .14427 L
.47406 .15208 L
.47407 .1606 L
.47409 .15472 L
.47409 .18885 L
.4741 .16462 L
.47411 .16685 L
.47412 .16321 L
.47413 .18978 L
.47414 .18667 L
.47415 .11646 L
.47417 .14885 L
.47418 .15109 L
.4742 .16478 L
.47421 .14816 L
.47422 .19298 L
.47424 .1262 L
.47425 .16551 L
.47425 .15703 L
.47427 .19111 L
.47428 .14695 L
.4743 .20596 L
.47431 .17487 L
.47432 .17578 L
.47433 .12322 L
.47434 .10976 L
.47436 .1596 L
.47437 .13981 L
.47439 .13403 L
.4744 .19099 L
.47441 .17848 L
.47444 .15423 L
.47445 .12213 L
.47446 .13339 L
.47448 .15732 L
.47449 .16442 L
.47451 .16429 L
.47452 .21122 L
.47454 .13568 L
Mistroke
.47455 .17276 L
.47456 .14101 L
.47457 .14691 L
.47458 .12794 L
.47459 .13208 L
.47461 .17092 L
.47462 .1869 L
.47463 .13325 L
.47463 .16701 L
.47464 .15697 L
.47465 .13149 L
.47466 .10322 L
.47467 .13136 L
.47469 .13683 L
.4747 .14305 L
.47472 .18903 L
.47473 .13531 L
.47475 .20859 L
.47476 .1506 L
.47477 .15318 L
.47479 .15586 L
.4748 .16841 L
.47481 .13963 L
.47483 .16742 L
.47484 .16253 L
.47485 .16478 L
.47487 .15991 L
.47488 .15262 L
.47489 .11559 L
.47491 .16062 L
.47492 .11311 L
.47493 .15487 L
.47494 .13261 L
.47495 .18844 L
.47497 .15705 L
.47498 .18712 L
.475 .14549 L
.47501 .16963 L
.47503 .12503 L
.47504 .14555 L
.47505 .15374 L
.47507 .17809 L
.47508 .16107 L
.4751 .17849 L
.47511 .15783 L
.47512 .1487 L
.47513 .14296 L
.47515 .2071 L
.47516 .16563 L
.47517 .14593 L
Mistroke
.47519 .1684 L
.4752 .15218 L
.47522 .17686 L
.47523 .12882 L
.47524 .16438 L
.47526 .15531 L
.47527 .15809 L
.47528 .11747 L
.47529 .15952 L
.47531 .17641 L
.47532 .18066 L
.47534 .19563 L
.47535 .15139 L
.47536 .16973 L
.47537 .14171 L
.47538 .16993 L
.47539 .15306 L
.47541 .13589 L
.47542 .13025 L
.47543 .20442 L
.47544 .21045 L
.47545 .14862 L
.47547 .17733 L
.47548 .17814 L
.47549 .17869 L
.47551 .17515 L
.47552 .16231 L
.47554 .17679 L
.47555 .16758 L
.47555 .15799 L
.47557 .17013 L
.47558 .18217 L
.47559 .13104 L
.4756 .13377 L
.47562 .12998 L
.47563 .15838 L
.47565 .15939 L
.47566 .13645 L
.47567 .17413 L
.47569 .16358 L
.4757 .12774 L
.47571 .20635 L
.47573 .16391 L
.47574 .16344 L
.47575 .20221 L
.47577 .16012 L
.47577 .15444 L
.47578 .18107 L
.4758 .19678 L
.47581 .15029 L
Mistroke
.47582 .17581 L
.47584 .12877 L
.47585 .19551 L
.47587 .1812 L
.47588 .15876 L
.47589 .19707 L
.47591 .18396 L
.47592 .14549 L
.47594 .162 L
.47594 .17033 L
.47595 .15506 L
.47597 .18792 L
.47598 .1891 L
.47599 .11809 L
.47601 .15491 L
.47602 .18748 L
.47603 .14328 L
.47605 .16359 L
.47606 .17512 L
.47608 .19373 L
.47609 .18358 L
.4761 .18427 L
.47612 .19312 L
.47613 .1443 L
.47615 .15634 L
.47616 .19182 L
.47617 .16862 L
.47618 .16144 L
.47619 .12967 L
.47621 .19459 L
.47623 .12991 L
.47623 .19172 L
.47624 .21983 L
.47626 .22173 L
.47627 .14087 L
.47628 .13241 L
.47629 .13971 L
.4763 .17976 L
.47631 .12264 L
.47632 .20402 L
.47633 .14406 L
.47634 .18251 L
.47635 .14301 L
.47637 .13541 L
.47638 .14336 L
.4764 .17398 L
.47641 .14686 L
.47642 .12723 L
.47644 .15114 L
.47645 .13973 L
Mistroke
.47646 .15307 L
.47647 .17034 L
.47648 .16288 L
.47649 .14935 L
.4765 .15968 L
.47651 .16568 L
.47652 .16197 L
.47653 .1811 L
.47655 .18622 L
.47655 .13054 L
.47656 .15941 L
.47658 .13886 L
.47658 .1851 L
.47659 .13596 L
.47661 .16051 L
.47662 .11983 L
.47663 .17054 L
.47664 .16476 L
.47665 .15661 L
.47667 .16375 L
.47668 .13946 L
.4767 .14591 L
.47671 .15596 L
.47672 .20501 L
.47673 .16002 L
.47674 .11823 L
.47676 .19837 L
.47677 .1429 L
.47678 .15131 L
.47679 .13603 L
.4768 .13565 L
.47681 .16194 L
.47682 .16379 L
.47683 .15782 L
.47684 .14656 L
.47684 .21028 L
.47686 .19739 L
.47688 .14823 L
.47688 .17884 L
.47689 .15038 L
.47691 .13069 L
.47692 .18572 L
.47693 .1877 L
.47694 .13597 L
.47695 .18677 L
.47697 .18961 L
.47698 .18664 L
.477 .13854 L
.47701 .16178 L
.47702 .1608 L
Mistroke
.47704 .14375 L
.47705 .1946 L
.47707 .12847 L
.47708 .18416 L
.4771 .16294 L
.4771 .13763 L
.47711 .18756 L
.47713 .19768 L
.47714 .15995 L
.47716 .17762 L
.47717 .16945 L
.47719 .13738 L
.47719 .17625 L
.4772 .14848 L
.47722 .17455 L
.47723 .1513 L
.47724 .15764 L
.47724 .12465 L
.47725 .1452 L
.47727 .15213 L
.47728 .17478 L
.47729 .15232 L
.4773 .186 L
.47731 .16415 L
.47732 .18371 L
.47733 .18569 L
.47734 .16318 L
.47735 .15614 L
.47736 .11219 L
.47738 .14506 L
.47739 .17516 L
.4774 .2154 L
.47742 .17218 L
.47743 .14381 L
.47745 .15029 L
.47746 .13344 L
.47746 .14506 L
.47748 .17631 L
.47749 .15863 L
.4775 .1655 L
.47751 .17395 L
.47753 .12833 L
.47754 .20527 L
.47755 .17466 L
.47757 .19828 L
.47758 .16957 L
.47759 .18958 L
.47761 .16905 L
.47762 .16427 L
.47763 .16654 L
Mistroke
.47765 .1768 L
.47766 .17797 L
.47767 .15276 L
.47769 .17391 L
.4777 .14938 L
.47772 .19332 L
.47773 .15508 L
.47775 .16128 L
.47776 .18742 L
.47777 .19549 L
.47779 .17479 L
.47781 .16879 L
.47781 .15874 L
.47782 .13491 L
.47783 .16622 L
.47784 .13202 L
.47785 .18492 L
.47787 .11128 L
.47787 .15257 L
.47788 .14738 L
.4779 .18583 L
.47791 .16061 L
.47793 .17769 L
.47794 .17561 L
.47796 .14296 L
.47797 .18339 L
.47798 .14544 L
.478 .17217 L
.47801 .1688 L
.47807 .16081 L
.47808 .18621 L
.47808 .12743 L
.4781 .15547 L
.47812 .13812 L
.47813 .12884 L
.47815 .18232 L
.47815 .14561 L
.47816 .21062 L
.47817 .156 L
.47818 .16696 L
.47819 .1534 L
.4782 .18675 L
.47821 .14703 L
.47822 .1277 L
.47823 .18569 L
.47824 .17283 L
.47825 .20225 L
.47826 .13952 L
.47828 .13577 L
.47829 .16328 L
Mistroke
.4783 .14856 L
.47832 .14629 L
.47833 .18617 L
.47834 .1792 L
.47835 .15019 L
.47836 .17258 L
.47838 .18445 L
.47839 .1843 L
.47841 .16855 L
.47842 .18513 L
.47844 .1642 L
.47845 .17603 L
.47846 .15651 L
.47847 .15261 L
.47848 .12467 L
.47849 .16388 L
.47849 .15296 L
.4785 .13199 L
.47852 .19283 L
.47853 .15738 L
.47855 .12598 L
.47856 .1612 L
.47857 .14946 L
.47858 .16843 L
.4786 .1642 L
.47861 .18599 L
.47862 .151 L
.47864 .2019 L
.47865 .13528 L
.47866 .16279 L
.47868 .13358 L
.47869 .19755 L
.4787 .13871 L
.47871 .17677 L
.47872 .13852 L
.47874 .16309 L
.47875 .17625 L
.47876 .17513 L
.47877 .14641 L
.47878 .15922 L
.4788 .15621 L
.47881 .17925 L
.47882 .13964 L
.47884 .18119 L
.47885 .12391 L
.47886 .16755 L
.47887 .12308 L
.47889 .17803 L
.47889 .14732 L
.4789 .16881 L
Mistroke
.47892 .16556 L
.47893 .12914 L
.47895 .17462 L
.47896 .18424 L
.47897 .15247 L
.47899 .15676 L
.479 .16388 L
.47901 .18297 L
.47903 .16242 L
.47904 .17794 L
.47905 .13176 L
.47907 .17377 L
.47908 .1767 L
.47909 .21396 L
.47911 .15728 L
.47912 .16094 L
.47914 .13018 L
.47915 .17652 L
.47917 .14279 L
.47918 .14397 L
.4792 .20695 L
.47921 .12849 L
.47923 .18999 L
.47923 .16376 L
.47924 .17084 L
.47925 .15532 L
.47926 .1553 L
.47927 .19473 L
.47928 .1363 L
.47929 .1963 L
.4793 .15718 L
.47931 .1738 L
.47932 .16905 L
.47933 .20755 L
.47934 .17177 L
.47935 .1691 L
.47936 .1474 L
.47937 .17864 L
.47938 .20269 L
.47939 .17299 L
.47941 .17712 L
.47942 .12417 L
.47944 .18308 L
.47945 .17284 L
.47946 .15517 L
.47948 .19191 L
.47949 .12588 L
.47951 .16534 L
.47952 .16056 L
.47955 .15376 L
Mistroke
.47956 .17107 L
.47958 .14302 L
.47959 .16797 L
.47961 .13942 L
.47962 .17179 L
.47964 .16143 L
.47965 .15869 L
.47966 .14274 L
.47967 .1767 L
.47968 .15901 L
.47969 .13672 L
.47971 .17624 L
.47972 .08791 L
.47974 .15227 L
.47975 .17781 L
.47976 .17882 L
.47978 .16263 L
.47979 .14655 L
.4798 .15952 L
.47981 .15903 L
.47982 .17158 L
.47984 .20174 L
.47985 .14547 L
.47987 .14869 L
.47988 .16963 L
.47989 .18634 L
.4799 .17615 L
.47991 .15004 L
.47993 .15276 L
.47993 .16914 L
.47994 .16212 L
.47995 .13372 L
.47996 .13911 L
.47997 .15966 L
.47998 .14994 L
.47999 .17138 L
.48001 .18771 L
.48002 .17008 L
.48003 .18654 L
.48004 .11549 L
.48005 .18418 L
.48007 .16103 L
.48008 .16931 L
.48009 .15982 L
.48011 .1685 L
.48012 .17328 L
.48014 .18127 L
.48015 .151 L
.48017 .14727 L
.48018 .14257 L
Mistroke
.4802 .13788 L
.48021 .14563 L
.48023 .14496 L
.48023 .18396 L
.48024 .19369 L
.48026 .16789 L
.48027 .17035 L
.48029 .15385 L
.4803 .15125 L
.48031 .15511 L
.48033 .1688 L
.48034 .17831 L
.48036 .15788 L
.48037 .14137 L
.48038 .22741 L
.4804 .2082 L
.48041 .17486 L
.48043 .19624 L
.48044 .16551 L
.48045 .11774 L
.48046 .16943 L
.48048 .18262 L
.48048 .15579 L
.48049 .17757 L
.4805 .15037 L
.48051 .16254 L
.48052 .14788 L
.48053 .17436 L
.48054 .19611 L
.48055 .15466 L
.48056 .1783 L
.48057 .14913 L
.48057 .18614 L
.48058 .14446 L
.48059 .12559 L
.48061 .13382 L
.48062 .18268 L
.48063 .14238 L
.48065 .14561 L
.48066 .18689 L
.48068 .1391 L
.48069 .16128 L
.48071 .17381 L
.48072 .17271 L
.48073 .11194 L
.48075 .15076 L
.48076 .13228 L
.48078 .14338 L
.48079 .16255 L
.48081 .146 L
Mistroke
.48082 .15751 L
.48082 .16581 L
.48084 .19145 L
.48085 .15975 L
.48087 .16299 L
.48088 .17149 L
.4809 .15252 L
.48091 .13349 L
.48092 .20602 L
.48093 .18218 L
.48095 .19898 L
.48096 .1419 L
.48097 .0926 L
.48099 .18483 L
.481 .16663 L
.48102 .13617 L
.48103 .17661 L
.48105 .18486 L
.48106 .14907 L
.48107 .15873 L
.48109 .14837 L
.4811 .16136 L
.48112 .12453 L
.48113 .15257 L
.48115 .19198 L
.48115 .14649 L
.48116 .18209 L
.48118 .14833 L
.48119 .17266 L
.4812 .13122 L
.48122 .13686 L
.48123 .15293 L
.48124 .17115 L
.48126 .1659 L
.48127 .16432 L
.48129 .16883 L
.4813 .14256 L
.48131 .14014 L
.48132 .17051 L
.48133 .13901 L
.48135 .1451 L
.48136 .15306 L
.48137 .16961 L
.48138 .13326 L
.48139 .1715 L
.48139 .15292 L
.48141 .14022 L
.48142 .18978 L
.48143 .18897 L
.48144 .12958 L
Mistroke
.48146 .13472 L
.48147 .14669 L
.48148 .16718 L
.4815 .19565 L
.48151 .16068 L
.48151 .12679 L
.48153 .17636 L
.48154 .14391 L
.48155 .1698 L
.48156 .17799 L
.48158 .14569 L
.48159 .18283 L
.4816 .16981 L
.48162 .22047 L
.48163 .16117 L
.48164 .17397 L
.48165 .15802 L
.48167 .15114 L
.48168 .12852 L
.48169 .16436 L
.48171 .14654 L
.48172 .1854 L
.48173 .10613 L
.48175 .19477 L
.48176 .15097 L
.48178 .19358 L
.48179 .17445 L
.4818 .16067 L
.48181 .19685 L
.48182 .17415 L
.48184 .17525 L
.48185 .16676 L
.48185 .11315 L
.48187 .13656 L
.48189 .15645 L
.4819 .14673 L
.4819 .1847 L
.48192 .19321 L
.48193 .15892 L
.48195 .19499 L
.48196 .15923 L
.48197 .10778 L
.48198 .13082 L
.48199 .15138 L
.48199 .18541 L
.48201 .161 L
.48202 .19247 L
.48204 .17034 L
.48205 .12899 L
.48207 .15888 L
Mistroke
.48208 .12151 L
.4821 .14514 L
.48211 .17257 L
.48212 .1731 L
.48214 .12103 L
.48215 .20386 L
.48217 .17642 L
.48218 .12714 L
.48219 .14123 L
.48221 .14541 L
.48222 .22123 L
.48223 .19309 L
.48224 .15166 L
.48226 .1722 L
.48227 .15731 L
.48228 .18607 L
.4823 .14811 L
.48231 .18281 L
.48232 .15042 L
.48234 .18944 L
.48235 .17135 L
.48236 .15829 L
.48238 .16048 L
.48239 .10846 L
.4824 .15243 L
.48242 .22295 L
.48243 .14339 L
.48244 .14249 L
.48245 .20948 L
.48246 .18385 L
.48248 .1547 L
.48249 .1693 L
.48251 .1434 L
.48252 .15841 L
.48254 .14637 L
.48255 .18322 L
.48256 .17407 L
.48258 .12121 L
.48259 .1638 L
.4826 .21819 L
.48262 .17301 L
.48263 .17003 L
.48265 .12459 L
.48266 .13285 L
.48267 .16917 L
.48268 .15852 L
.4827 .11363 L
.48271 .14316 L
.48272 .16054 L
.48274 .19922 L
Mistroke
.48275 .17467 L
.48277 .16208 L
.48278 .16399 L
.48279 .18117 L
.4828 .15277 L
.48282 .1351 L
.48283 .17323 L
.48284 .18116 L
.48286 .14471 L
.48287 .17415 L
.48289 .17619 L
.48289 .16608 L
.4829 .14884 L
.48292 .18017 L
.48293 .15282 L
.48294 .14795 L
.48296 .14541 L
.48298 .13963 L
.48299 .16384 L
.483 .16427 L
.48302 .18125 L
.48303 .18651 L
.48304 .14138 L
.48306 .18355 L
.48307 .1698 L
.48309 .16385 L
.4831 .17233 L
.48312 .14764 L
.48313 .12517 L
.48313 .15882 L
.48315 .18069 L
.48316 .13589 L
.48318 .14123 L
.48319 .19088 L
.48321 .1473 L
.48322 .15814 L
.48323 .21066 L
.48324 .15982 L
.48326 .17656 L
.48327 .15724 L
.48328 .14825 L
.4833 .16762 L
.48331 .17203 L
.48332 .1684 L
.48334 .1567 L
.48335 .14299 L
.48336 .16902 L
.48337 .17933 L
.48338 .15141 L
.4834 .16963 L
Mistroke
.48341 .14312 L
.48343 .15076 L
.48344 .18695 L
.48346 .13431 L
.48347 .16078 L
.48348 .1755 L
.48349 .19485 L
.4835 .16703 L
.48352 .15103 L
.48353 .19208 L
.48355 .12255 L
.48356 .15359 L
.48358 .19894 L
.48359 .14181 L
.4836 .16575 L
.48361 .14626 L
.48363 .16278 L
.48364 .15612 L
.48365 .1614 L
.48366 .15823 L
.48368 .13384 L
.48369 .14246 L
.48371 .16013 L
.48372 .15016 L
.48373 .13172 L
.48374 .20103 L
.48375 .18349 L
.48377 .15977 L
.48378 .17092 L
.48378 .14184 L
.48379 .12857 L
.4838 .17916 L
.48382 .15775 L
.48383 .13043 L
.48385 .15693 L
.48386 .13938 L
.48386 .12559 L
.48388 .12798 L
.48389 .17569 L
.48391 .15569 L
.48392 .15581 L
.48394 .19738 L
.48395 .15485 L
.48395 .12468 L
.48397 .19976 L
.48398 .15655 L
.484 .14259 L
.48401 .15746 L
.48402 .19619 L
.48404 .16472 L
Mistroke
.48405 .21309 L
.48407 .2073 L
.48408 .1775 L
.48409 .1829 L
.4841 .15041 L
.48411 .14783 L
.48413 .15766 L
.48414 .15751 L
.48415 .16856 L
.48416 .16156 L
.48417 .16682 L
.48419 .17739 L
.4842 .15748 L
.4842 .15995 L
.48421 .14793 L
.48422 .08424 L
.48424 .16691 L
.48425 .18204 L
.48427 .12676 L
.48428 .15033 L
.48429 .15322 L
.4843 .17239 L
.48431 .12705 L
.48433 .12373 L
.48434 .21886 L
.48436 .15005 L
.48437 .11902 L
.48439 .19016 L
.4844 .19652 L
.48441 .18507 L
.48443 .16863 L
.48444 .15683 L
.48445 .17575 L
.48447 .16988 L
.48448 .12786 L
.4845 .17609 L
.48451 .16953 L
.48453 .14598 L
.48454 .16504 L
.48455 .18104 L
.48456 .19189 L
.48458 .15559 L
.48459 .21782 L
.4846 .12696 L
.48462 .18284 L
.48463 .18 L
.48464 .16948 L
.48465 .16702 L
.48467 .21712 L
.48468 .17898 L
Mistroke
.48469 .1613 L
.48471 .19939 L
.48472 .19285 L
.48474 .20317 L
.48475 .2055 L
.48476 .13806 L
.48477 .1742 L
.48478 .18064 L
.4848 .17753 L
.48482 .15319 L
.48484 .13951 L
.48485 .168 L
.48487 .18613 L
.48488 .15846 L
.4849 .18014 L
.48491 .17939 L
.48492 .14617 L
.48494 .19221 L
.48495 .16836 L
.48497 .1924 L
.48498 .18682 L
.48499 .1478 L
.485 .15263 L
.48502 .17137 L
.48503 .17301 L
.48504 .21344 L
.48506 .16339 L
.48507 .17894 L
.48509 .18098 L
.4851 .12785 L
.48512 .18667 L
.48513 .17326 L
.48514 .15455 L
.48516 .14616 L
.48517 .16072 L
.48518 .18245 L
.48519 .1789 L
.48521 .15331 L
.48522 .1337 L
.48524 .11328 L
.48525 .1555 L
.48526 .17803 L
.48528 .15903 L
.48529 .15472 L
.48531 .17892 L
.48532 .18714 L
.48533 .17603 L
.48535 .15776 L
.48536 .19766 L
.48537 .14015 L
Mistroke
.48538 .13185 L
.48539 .18794 L
.4854 .16849 L
.48541 .15899 L
.48542 .17889 L
.48543 .17875 L
.48544 .13967 L
.48546 .20418 L
.48547 .18332 L
.48549 .16497 L
.4855 .16548 L
.48551 .14027 L
.48552 .18845 L
.48553 .1355 L
.48554 .11167 L
.48555 .19344 L
.48556 .18288 L
.48558 .15016 L
.48559 .194 L
.48561 .12509 L
.48562 .1553 L
.48563 .13073 L
.48563 .13909 L
.48564 .19479 L
.48566 .15437 L
.48567 .18498 L
.48568 .17427 L
.48569 .15158 L
.4857 .16102 L
.48571 .17205 L
.48572 .24855 L
.48573 .17069 L
.48574 .14589 L
.48575 .13323 L
.48576 .15388 L
.48577 .15747 L
.48579 .19374 L
.4858 .16524 L
.4858 .15192 L
.48582 .13688 L
.48583 .13416 L
.48584 .16572 L
.48585 .20541 L
.48586 .16085 L
.48588 .18215 L
.48589 .10377 L
.48591 .164 L
.48592 .19977 L
.48594 .14711 L
.48595 .17175 L
Mistroke
.48596 .18575 L
.48598 .14837 L
.48599 .16792 L
.48601 .12755 L
.48602 .18578 L
.48602 .15971 L
.48604 .17968 L
.48605 .14167 L
.48607 .17124 L
.48608 .14539 L
.4861 .1674 L
.48611 .19625 L
.48611 .18025 L
.48613 .1675 L
.48614 .17625 L
.48615 .15643 L
.48616 .14598 L
.48617 .19761 L
.48618 .21339 L
.4862 .18131 L
.4862 .10734 L
.48621 .14034 L
.48622 .18552 L
.48623 .13503 L
.48624 .16022 L
.48625 .17674 L
.48626 .23576 L
.48627 .17923 L
.48629 .12478 L
.4863 .14735 L
.48632 .17624 L
.48633 .2359 L
.48634 .14736 L
.48636 .14179 L
.48637 .16806 L
.48638 .192 L
.48639 .14907 L
.4864 .15369 L
.48641 .19286 L
.48642 .19259 L
.48644 .21054 L
.48645 .16188 L
.48647 .16526 L
.48648 .14861 L
.48649 .13389 L
.48651 .09554 L
.48652 .1598 L
.48653 .15578 L
.48655 .13753 L
.48656 .15481 L
Mistroke
.48657 .15614 L
.48663 .16344 L
.48664 .15769 L
.48666 .17538 L
.48667 .14115 L
.48669 .17394 L
.4867 .14427 L
.48672 .15476 L
.48673 .19207 L
.48675 .16588 L
.48676 .16369 L
.48677 .17559 L
.48679 .20504 L
.4868 .14292 L
.48681 .1978 L
.48683 .16789 L
.48684 .17318 L
.48686 .23168 L
.48687 .19691 L
.48688 .17087 L
.48689 .16145 L
.4869 .11245 L
.48691 .18973 L
.48692 .18148 L
.48693 .18661 L
.48695 .17271 L
.48696 .11961 L
.48698 .19509 L
.48699 .22792 L
.48701 .16671 L
.48702 .12905 L
.48703 .1684 L
.48705 .1865 L
.48706 .13755 L
.48707 .14081 L
.48709 .16507 L
.4871 .15366 L
.48711 .17578 L
.48713 .15935 L
.48714 .14347 L
.48715 .15748 L
.48716 .15387 L
.48717 .15556 L
.48719 .15186 L
.4872 .15837 L
.4872 .13243 L
.48722 .15424 L
.48723 .15897 L
.48725 .18617 L
.48726 .1185 L
Mistroke
.48727 .16325 L
.48728 .17275 L
.48729 .14842 L
.4873 .17699 L
.48731 .14439 L
.48733 .15369 L
.48734 .1656 L
.48735 .15596 L
.48736 .17135 L
.48737 .14865 L
.48738 .17288 L
.48739 .18629 L
.48739 .14932 L
.4874 .18079 L
.48741 .14077 L
.48743 .13537 L
.48744 .137 L
.48745 .17412 L
.48747 .18014 L
.48748 .16658 L
.48749 .18062 L
.48749 .17235 L
.4875 .16318 L
.48751 .15057 L
.48752 .15921 L
.48753 .20272 L
.48755 .16684 L
.48756 .16822 L
.48757 .1991 L
.48759 .16062 L
.4876 .17433 L
.48761 .147 L
.48762 .13417 L
.48764 .16125 L
.48765 .18149 L
.48766 .18282 L
.48767 .16221 L
.48768 .16513 L
.4877 .18337 L
.48771 .16287 L
.48772 .20487 L
.48773 .19297 L
.48775 .15497 L
.48777 .19177 L
.48777 .18168 L
.48778 .19548 L
.4878 .15684 L
.48781 .1381 L
.48781 .14905 L
.48783 .1885 L
Mistroke
.48784 .1972 L
.48786 .15384 L
.48787 .1703 L
.48788 .18394 L
.4879 .14048 L
.48791 .14138 L
.48792 .18527 L
.48794 .18577 L
.48795 .17714 L
.48797 .17943 L
.48798 .13498 L
.48799 .16606 L
.48801 .15241 L
.48802 .19238 L
.48803 .21924 L
.48805 .1837 L
.48806 .145 L
.48808 .21485 L
.48809 .18174 L
.48811 .17163 L
.48812 .19018 L
.48813 .18047 L
.48814 .15926 L
.48815 .17415 L
.48816 .18144 L
.48817 .19506 L
.48818 .11362 L
.48819 .15799 L
.4882 .1673 L
.48822 .19379 L
.48823 .15323 L
.48824 .13919 L
.48826 .17384 L
.48827 .16385 L
.48829 .21482 L
.4883 .16483 L
.48831 .14224 L
.48833 .1872 L
.48834 .15173 L
.48836 .13091 L
.48837 .16802 L
.48837 .16599 L
.48839 .17752 L
.4884 .16044 L
.48842 .14814 L
.48843 .1698 L
.48845 .14326 L
.48846 .17279 L
.48846 .14185 L
.48848 .1268 L
Mistroke
.48849 .16851 L
.4885 .19271 L
.48851 .1543 L
.48852 .13628 L
.48852 .16837 L
.48853 .16002 L
.48854 .18168 L
.48855 .18944 L
.48856 .14383 L
.48858 .19319 L
.48859 .17762 L
.48861 .1621 L
.48862 .19053 L
.48864 .13602 L
.48865 .18152 L
.48867 .17793 L
.48868 .15502 L
.48869 .15079 L
.48871 .14547 L
.48872 .14718 L
.48874 .15003 L
.48875 .19857 L
.48877 .16252 L
.48878 .16355 L
.48878 .17558 L
.4888 .15576 L
.48881 .17187 L
.48883 .1939 L
.48884 .15366 L
.48886 .12963 L
.48887 .13902 L
.48888 .14558 L
.48889 .14501 L
.48891 .12313 L
.48892 .1547 L
.48893 .15917 L
.48895 .14264 L
.48896 .18113 L
.48897 .19138 L
.48899 .15275 L
.489 .18743 L
.48901 .18537 L
.48902 .13104 L
.48903 .15286 L
.48905 .17863 L
.48906 .18436 L
.48906 .1733 L
.48908 .16753 L
.48909 .19411 L
.48911 .15203 L
Mistroke
.48912 .12163 L
.48913 .18951 L
.48915 .15705 L
.48916 .14536 L
.48917 .16157 L
.48918 .1957 L
.48919 .21149 L
.4892 .18918 L
.48921 .17422 L
.48923 .15604 L
.48924 .14948 L
.48926 .19554 L
.48927 .19442 L
.48928 .20294 L
.4893 .16514 L
.48931 .20906 L
.48932 .18041 L
.48933 .15521 L
.48935 .17522 L
.48936 .17894 L
.48938 .14417 L
.48939 .1997 L
.48941 .16577 L
.48942 .13473 L
.48943 .15227 L
.48945 .1872 L
.48946 .17566 L
.48948 .15856 L
.48949 .1995 L
.48951 .15306 L
.48952 .14539 L
.48953 .18156 L
.48954 .14943 L
.48955 .1793 L
.48955 .15197 L
.48957 .19773 L
.48958 .20249 L
.4896 .16433 L
.48961 .18048 L
.48963 .14832 L
.48964 .15702 L
.48965 .17459 L
.48967 .15826 L
.48968 .15102 L
.4897 .13986 L
.48971 .15786 L
.48972 .14554 L
.48974 .13975 L
.48975 .17916 L
.48977 .11932 L
Mistroke
.48978 .14999 L
.4898 .20314 L
.48981 .17114 L
.48982 .14831 L
.48983 .14413 L
.48984 .17232 L
.48985 .15092 L
.48986 .1671 L
.48986 .1915 L
.48988 .16578 L
.48989 .18326 L
.4899 .20976 L
.4899 .13297 L
.48991 .14035 L
.48992 .18054 L
.48993 .21189 L
.48994 .15715 L
.48995 .18058 L
.48996 .1534 L
.48998 .14518 L
.48999 .17417 L
.49001 .17034 L
.49002 .1992 L
.49004 .22912 L
.49005 .15703 L
.49006 .18191 L
.49008 .16311 L
.49009 .15398 L
.4901 .19672 L
.49012 .17165 L
.49013 .20446 L
.49015 .14275 L
.49016 .15926 L
.49017 .1783 L
.49018 .16063 L
.4902 .16637 L
.49021 .14616 L
.49022 .11928 L
.49024 .16701 L
.49025 .16122 L
.49027 .14077 L
.49028 .14437 L
.49029 .15741 L
.4903 .17116 L
.49032 .13986 L
.49033 .22566 L
.49034 .16003 L
.49036 .20197 L
.49037 .12775 L
.49039 .16986 L
Mistroke
.49039 .15683 L
.4904 .18211 L
.49042 .13597 L
.49043 .14264 L
.49045 .18181 L
.49046 .13903 L
.49048 .14662 L
.49049 .14689 L
.4905 .14453 L
.49052 .17588 L
.49053 .16422 L
.49054 .22623 L
.49056 .20269 L
.49057 .16667 L
.49059 .15526 L
.4906 .17808 L
.49061 .14362 L
.49062 .16188 L
.49064 .12946 L
.49065 .15585 L
.49067 .15804 L
.49068 .17318 L
.49069 .21366 L
.49071 .14928 L
.49072 .14512 L
.49073 .11364 L
.49074 .20459 L
.49076 .15481 L
.49077 .15767 L
.49078 .19026 L
.4908 .15347 L
.49081 .22718 L
.49083 .14637 L
.49084 .21267 L
.49085 .21065 L
.49086 .16611 L
.49087 .18076 L
.49089 .17039 L
.4909 .15689 L
.49091 .21034 L
.49092 .10677 L
.49093 .15337 L
.49095 .16023 L
.49096 .16811 L
.49097 .18506 L
.49098 .19368 L
.491 .19787 L
.49101 .1407 L
.49102 .14375 L
.49103 .15172 L
Mistroke
.49105 .17936 L
.49106 .16169 L
.49106 .23072 L
.49108 .15775 L
.49109 .187 L
.49111 .14156 L
.49112 .13865 L
.49113 .17008 L
.49115 .16778 L
.49116 .16588 L
.49117 .18402 L
.49119 .13207 L
.4912 .15443 L
.49122 .1711 L
.49123 .13409 L
.49124 .13973 L
.49126 .12805 L
.49127 .20463 L
.49128 .13095 L
.4913 .16102 L
.49131 .17512 L
.49133 .15372 L
.49134 .20045 L
.49136 .19337 L
.49136 .17138 L
.49137 .1666 L
.49139 .15263 L
.4914 .1748 L
.49141 .1477 L
.49143 .14747 L
.49144 .1617 L
.49146 .15278 L
.49147 .18009 L
.49148 .20468 L
.4915 .20832 L
.49151 .13575 L
.49152 .20257 L
.49153 .20174 L
.49154 .13768 L
.49155 .16309 L
.49156 .18085 L
.49158 .17151 L
.49159 .12642 L
.4916 .19556 L
.49162 .1608 L
.49163 .18969 L
.49164 .16287 L
.49166 .15679 L
.49167 .18948 L
.49168 .18717 L
Mistroke
.4917 .16489 L
.49171 .16171 L
.49172 .18177 L
.49174 .17285 L
.49175 .21087 L
.49175 .17968 L
.49177 .16835 L
.49178 .17178 L
.4918 .12423 L
.49181 .1948 L
.49183 .17472 L
.49184 .16335 L
.49185 .15505 L
.49187 .15798 L
.49188 .13635 L
.49189 .16035 L
.4919 .19088 L
.49192 .14506 L
.49193 .15493 L
.49194 .2005 L
.49196 .16891 L
.49197 .18824 L
.49199 .14994 L
.492 .18361 L
.49201 .16516 L
.49202 .17353 L
.49204 .15949 L
.49205 .15796 L
.49206 .18385 L
.49207 .16624 L
.49209 .17619 L
.4921 .13881 L
.49212 .16976 L
.49213 .1333 L
.49214 .15073 L
.49215 .20961 L
.49216 .18581 L
.49218 .16297 L
.49218 .15227 L
.49219 .21027 L
.4922 .13594 L
.49221 .14457 L
.49222 .16729 L
.49224 .15631 L
.49225 .16382 L
.49226 .14433 L
.49227 .1349 L
.49227 .19309 L
.49229 .17428 L
.4923 .15238 L
Mistroke
.4923 .1711 L
.49231 .18071 L
.49232 .17526 L
.49233 .19388 L
.49234 .1604 L
.49235 .179 L
.49237 .16226 L
.49238 .21405 L
.4924 .17148 L
.4924 .18853 L
.49241 .16233 L
.49242 .17061 L
.49243 .15575 L
.49244 .17436 L
.49245 .14223 L
.49246 .16531 L
.49247 .14843 L
.49248 .14927 L
.49248 .17215 L
.49249 .2085 L
.4925 .18827 L
.49251 .16019 L
.49252 .20402 L
.49253 .13964 L
.49254 .21511 L
.49255 .17362 L
.49256 .15856 L
.49258 .14205 L
.49259 .17224 L
.49261 .12358 L
.49261 .12798 L
.49262 .16662 L
.49263 .16965 L
.49264 .13363 L
.49265 .15221 L
.49265 .13932 L
.49267 .17593 L
.49268 .14158 L
.4927 .13514 L
.49271 .1494 L
.49273 .19022 L
.49273 .18541 L
.49274 .20977 L
.49276 .19593 L
.49277 .17098 L
.49279 .19165 L
.49279 .17314 L
.4928 .13173 L
.49282 .16825 L
.49283 .1594 L
Mistroke
.49286 .14495 L
.49287 .12755 L
.49289 .13376 L
.4929 .16291 L
.49292 .21513 L
.49293 .13152 L
.49294 .18472 L
.49295 .13662 L
.49296 .15285 L
.49297 .20881 L
.49298 .14377 L
.49299 .1548 L
.493 .1498 L
.49301 .18604 L
.49302 .203 L
.49303 .19269 L
.49305 .16311 L
.49306 .14402 L
.49307 .12831 L
.49309 .1307 L
.4931 .17117 L
.49312 .17925 L
.49313 .15621 L
.49314 .14809 L
.49316 .18233 L
.49317 .17124 L
.49319 .18012 L
.4932 .13401 L
.49321 .15731 L
.49323 .19482 L
.49324 .14303 L
.49326 .1398 L
.49327 .14653 L
.49328 .1732 L
.49328 .1356 L
.49329 .17085 L
.49331 .12831 L
.49332 .09496 L
.49333 .16961 L
.49334 .19848 L
.49335 .16446 L
.49337 .12232 L
.49338 .17411 L
.4934 .16027 L
.49341 .20019 L
.49342 .18654 L
.49344 .15546 L
.49345 .13424 L
.49346 .16856 L
.49348 .1751 L
Mistroke
.49349 .14807 L
.4935 .19373 L
.49351 .16264 L
.49353 .15516 L
.49354 .20671 L
.49356 .20183 L
.49357 .1451 L
.49358 .15435 L
.49359 .15197 L
.4936 .15617 L
.49361 .12248 L
.49362 .13796 L
.49363 .15945 L
.49364 .1501 L
.49364 .147 L
.49365 .19492 L
.49367 .15892 L
.49368 .15188 L
.49369 .13638 L
.4937 .14689 L
.49372 .16613 L
.49373 .16988 L
.49374 .18553 L
.49375 .16496 L
.49376 .15281 L
.49378 .13923 L
.49379 .15017 L
.4938 .21138 L
.49381 .13116 L
.49383 .19072 L
.49384 .16775 L
.49385 .12684 L
.49386 .1731 L
.49388 .18168 L
.49389 .1771 L
.49389 .18068 L
.49391 .13573 L
.49392 .15629 L
.49394 .18982 L
.49395 .1508 L
.49396 .14344 L
.49398 .13596 L
.49399 .16525 L
.494 .16773 L
.49402 .19469 L
.49403 .15925 L
.49405 .19449 L
.49406 .13832 L
.49407 .17728 L
.49409 .17166 L
Mistroke
.4941 .1481 L
.49411 .14369 L
.49413 .19296 L
.49414 .10878 L
.49416 .1267 L
.49417 .15443 L
.49419 .18176 L
.4942 .11589 L
.49421 .20131 L
.49422 .15686 L
.49423 .17756 L
.49423 .13048 L
.49425 .1651 L
.49426 .14893 L
.49427 .18855 L
.49428 .2042 L
.49429 .1226 L
.49431 .17785 L
.49432 .13112 L
.49434 .14162 L
.49435 .1796 L
.49436 .13395 L
.49438 .14924 L
.49439 .18211 L
.49441 .16269 L
.49442 .12028 L
.49444 .17207 L
.49444 .16507 L
.49445 .13059 L
.49447 .1722 L
.49448 .15973 L
.4945 .15506 L
.49451 .18498 L
.49453 .18054 L
.49453 .15068 L
.49454 .14531 L
.49455 .1726 L
.49456 .14378 L
.49457 .16182 L
.49458 .10644 L
.49459 .1757 L
.4946 .16896 L
.49461 .14055 L
.49462 .15713 L
.49463 .17178 L
.49464 .19024 L
.49465 .17159 L
.49466 .14358 L
.49467 .13863 L
.49469 .16019 L
Mistroke
.4947 .1845 L
.4947 .18835 L
.49472 .20303 L
.49473 .16259 L
.49475 .16716 L
.49476 .13964 L
.49478 .1441 L
.49479 .12141 L
.49481 .19717 L
.49482 .1826 L
.49484 .13155 L
.49485 .15513 L
.49486 .16422 L
.49488 .16207 L
.49489 .16831 L
.4949 .13575 L
.49492 .18584 L
.49493 .10752 L
.49495 .18638 L
.49496 .16737 L
.49498 .1675 L
.49499 .16475 L
.49499 .15879 L
.495 .1818 L
.49501 .12694 L
.49502 .09507 L
.49503 .15248 L
.49504 .20274 L
.49505 .13752 L
.49506 .16555 L
.49508 .18858 L
.49509 .20025 L
.4951 .15464 L
.49511 .22736 L
.49513 .16255 L
.49514 .13829 L
.49515 .16465 L
.49516 .16308 L
.49517 .13564 L
.49519 .19022 L
.4952 .18092 L
.49521 .16677 L
.49523 .14467 L
.49524 .14016 L
.49526 .16276 L
.49527 .17286 L
.49528 .15973 L
.49529 .16268 L
.4953 .15146 L
.49531 .15497 L
Mistroke
.49532 .19371 L
.49533 .1404 L
.49535 .20055 L
.49536 .23823 L
.49538 .15774 L
.49539 .14265 L
.49541 .18294 L
.49542 .16658 L
.49543 .14705 L
.49545 .15077 L
.49546 .19311 L
.49548 .16784 L
.49549 .19978 L
.4955 .20206 L
.49552 .16574 L
.49553 .1331 L
.49554 .19891 L
.49556 .11616 L
.49557 .19116 L
.49559 .19381 L
.4956 .20105 L
.49561 .21177 L
.49563 .17995 L
.49564 .20297 L
.49566 .15413 L
.49567 .1813 L
.49568 .17798 L
.49571 .17261 L
.49573 .16703 L
.49574 .18115 L
.49574 .18142 L
.49576 .19224 L
.49577 .16097 L
.49578 .15876 L
.49579 .21055 L
.4958 .16073 L
.49581 .12335 L
.49581 .16826 L
.49582 .16722 L
.49584 .16092 L
.49587 .1431 L
.49588 .19961 L
.49588 .12936 L
.4959 .1781 L
.49591 .15617 L
.49593 .17514 L
.49594 .16371 L
.49596 .13846 L
.49597 .15327 L
.49598 .15315 L
Mistroke
.49599 .13484 L
.49601 .16055 L
.49602 .2095 L
.49603 .183 L
.49604 .16551 L
.49605 .18062 L
.49606 .19495 L
.49607 .18732 L
.49608 .13608 L
.49609 .16913 L
.4961 .16495 L
.49612 .17104 L
.49613 .15605 L
.49615 .19815 L
.49616 .19569 L
.49617 .15478 L
.49619 .18561 L
.4962 .18881 L
.49621 .13489 L
.49622 .15691 L
.49622 .17623 L
.49624 .17338 L
.49625 .15191 L
.49625 .18598 L
.49626 .18634 L
.49627 .18035 L
.49629 .19009 L
.4963 .17546 L
.49632 .20851 L
.49632 .15298 L
.49633 .17703 L
.49634 .20369 L
.49636 .20174 L
.49637 .21274 L
.49638 .17683 L
.4964 .21181 L
.49641 .1832 L
.49643 .18382 L
.49644 .17053 L
.49645 .15201 L
.49647 .17405 L
.49648 .18152 L
.49649 .14901 L
.49651 .1971 L
.49653 .18001 L
.49654 .21711 L
.49655 .15217 L
.49657 .18344 L
.49658 .13254 L
.49658 .15948 L
Mistroke
.4966 .14758 L
.49661 .1916 L
.49663 .12853 L
.49664 .18656 L
.49666 .20299 L
.49667 .15659 L
.49668 .21263 L
.4967 .16355 L
.49671 .15575 L
.49671 .11569 L
.49672 .14451 L
.49673 .1925 L
.49675 .17569 L
.49676 .15306 L
.49678 .19158 L
.49679 .19494 L
.49681 .15719 L
.49682 .18406 L
.49683 .21606 L
.49685 .14687 L
.49686 .17533 L
.49687 .17168 L
.4969 .16545 L
.49691 .17676 L
.49693 .15915 L
.49694 .22395 L
.49695 .14739 L
.49697 .21625 L
.49698 .15704 L
.497 .16061 L
.497 .19127 L
.49701 .20583 L
.49703 .12552 L
.49704 .14366 L
.49704 .1333 L
.49706 .2057 L
.49707 .14035 L
.49708 .19853 L
.49709 .15676 L
.49711 .14746 L
.49711 .17083 L
.49712 .16101 L
.49713 .15422 L
.49714 .17242 L
.49715 .17914 L
.49717 .14825 L
.49718 .1493 L
.4972 .16534 L
.49721 .14357 L
.49723 .20149 L
Mistroke
.49724 .13775 L
.49725 .16772 L
.49726 .14483 L
.49727 .19233 L
.49729 .18601 L
.4973 .15985 L
.49731 .19644 L
.49732 .14328 L
.49733 .18367 L
.49735 .18679 L
.49736 .18515 L
.49738 .1672 L
.49739 .17694 L
.4974 .19197 L
.49742 .11214 L
.49743 .16544 L
.49744 .16114 L
.49746 .16178 L
.49747 .17432 L
.49748 .13337 L
.4975 .15198 L
.49751 .16264 L
.49753 .15944 L
.49754 .15437 L
.49756 .17847 L
.49757 .17849 L
.49758 .15881 L
.4976 .19284 L
.49761 .1802 L
.49762 .14728 L
.49763 .16874 L
.49764 .21778 L
.49766 .17674 L
.49767 .14293 L
.49767 .16237 L
.49769 .18934 L
.4977 .14913 L
.49771 .15054 L
.49771 .1608 L
.49772 .19981 L
.49774 .14193 L
.49775 .18028 L
.49776 .18125 L
.49777 .17956 L
.49778 .18348 L
.49779 .18925 L
.4978 .13129 L
.49781 .1432 L
.49782 .2093 L
.49783 .24198 L
Mistroke
.49784 .13242 L
.49785 .17538 L
.49785 .16934 L
.49787 .1865 L
.49788 .14798 L
.49789 .19484 L
.4979 .17551 L
.49791 .20843 L
.49792 .18713 L
.49793 .19753 L
.49795 .19158 L
.49796 .16451 L
.49798 .1811 L
.49799 .15838 L
.498 .17801 L
.49802 .15232 L
.49804 .13861 L
.49805 .16664 L
.49806 .17185 L
.49808 .16438 L
.49809 .15535 L
.49811 .18257 L
.49811 .18489 L
.49812 .12747 L
.49813 .19998 L
.49814 .16878 L
.49815 .13131 L
.49815 .16184 L
.49816 .11278 L
.49817 .18129 L
.49819 .15714 L
.4982 .13057 L
.49822 .1915 L
.49823 .13259 L
.49825 .17585 L
.49826 .14261 L
.49827 .13412 L
.49829 .17385 L
.4983 .13246 L
.49831 .15754 L
.49832 .18984 L
.49833 .16892 L
.49834 .15805 L
.49835 .16672 L
.49835 .19756 L
.49837 .17815 L
.49838 .16012 L
.49839 .15195 L
.4984 .18492 L
.4984 .16694 L
Mistroke
.49841 .20728 L
.49842 .11333 L
.49843 .20991 L
.49844 .16953 L
.49845 .19903 L
.49847 .1603 L
.49848 .15175 L
.4985 .20852 L
.49851 .12666 L
.49853 .12603 L
.49854 .16802 L
.49855 .1877 L
.49857 .16038 L
.49858 .21508 L
.49859 .12629 L
.49861 .19487 L
.49862 .18273 L
.49864 .17129 L
.49865 .17246 L
.49866 .13284 L
.49867 .15838 L
.49869 .13301 L
.4987 .15509 L
.49872 .16778 L
.49873 .16124 L
.49874 .15548 L
.49876 .19207 L
.49877 .15625 L
.49878 .17272 L
.49879 .14566 L
.49881 .1115 L
.49882 .16032 L
.49883 .14997 L
.49885 .18143 L
.49886 .13595 L
.49887 .18577 L
.49888 .16104 L
.49889 .14015 L
.49891 .16948 L
.49892 .16738 L
.49893 .20268 L
.49895 .18081 L
.49897 .14813 L
.49898 .18337 L
.49899 .19282 L
.49901 .14518 L
.49902 .1413 L
.49903 .169 L
.49905 .18379 L
.49906 .17192 L
Mistroke
.49908 .16139 L
.49909 .15805 L
.49911 .16804 L
.49912 .15244 L
.49912 .14873 L
.49914 .16125 L
.49916 .17497 L
.49917 .19716 L
.49918 .18535 L
.4992 .16549 L
.49921 .17932 L
.49922 .17693 L
.49923 .1923 L
.49925 .14433 L
.49926 .13769 L
.49927 .16065 L
.49929 .20937 L
.4993 .18862 L
.49931 .18862 L
.49933 .15574 L
.49934 .19842 L
.49935 .16886 L
.49936 .17519 L
.49937 .18453 L
.49939 .1659 L
.49941 .19672 L
.49942 .208 L
.49943 .167 L
.49945 .1643 L
.49946 .19533 L
.49947 .11461 L
.49949 .17295 L
.4995 .19852 L
.49952 .19769 L
.49953 .16613 L
.49955 .16703 L
.49956 .1341 L
.49957 .17666 L
.49958 .12485 L
.49959 .15946 L
.49961 .14177 L
.49962 .19695 L
.49964 .20639 L
.49965 .17411 L
.49966 .20716 L
.49968 .20075 L
.49969 .16561 L
.4997 .17284 L
.49971 .17922 L
.49973 .19092 L
Mistroke
.49974 .1446 L
.49976 .21377 L
.49977 .17492 L
.49978 .16523 L
.49979 .1816 L
.4998 .1529 L
.49982 .17077 L
.49983 .18789 L
.49984 .15276 L
.49986 .16699 L
.49987 .18314 L
.49989 .16085 L
.4999 .14478 L
.49991 .2019 L
.49993 .18046 L
.49994 .15499 L
.49996 .19361 L
.49997 .15794 L
.49999 .14129 L
.5 .15437 L
.50002 .15322 L
.50003 .18426 L
.50003 .17183 L
.50005 .19054 L
.50006 .19041 L
.50008 .15333 L
.50009 .14519 L
.50011 .12631 L
.50012 .16226 L
.50013 .14848 L
.50014 .21027 L
.50016 .16263 L
.50017 .17935 L
.50018 .17958 L
.5002 .20119 L
.50021 .16563 L
.50022 .15127 L
.50024 .17938 L
.50025 .19605 L
.50026 .17354 L
.50027 .14589 L
.50028 .2285 L
.5003 .17872 L
.50031 .18265 L
.50031 .16903 L
.50033 .17935 L
.50034 .11735 L
.50036 .19473 L
.50037 .14754 L
.50038 .16919 L
Mistroke
.5004 .19821 L
.50041 .19708 L
.50042 .16257 L
.50043 .21505 L
.50044 .16996 L
.50045 .18296 L
.50046 .17938 L
.50049 .16834 L
.50051 .16149 L
.50052 .16006 L
.50053 .16775 L
.50055 .17255 L
.50056 .1434 L
.50057 .16962 L
.50059 .16534 L
.5006 .1468 L
.50062 .1727 L
.50063 .20002 L
.50065 .19229 L
.50066 .18479 L
.50067 .20112 L
.50069 .17596 L
.5007 .16203 L
.50071 .16806 L
.50073 .15202 L
.50074 .20505 L
.50075 .14402 L
.50076 .1612 L
.50077 .21214 L
.50078 .11446 L
.5008 .17978 L
.50081 .19733 L
.50083 .21207 L
.50084 .14378 L
.50085 .17402 L
.50087 .19614 L
.50088 .21173 L
.50088 .20094 L
.50089 .17988 L
.5009 .13859 L
.50092 .16565 L
.50093 .16657 L
.50095 .1859 L
.50096 .1355 L
.50098 .14892 L
.50099 .18916 L
.501 .14773 L
.50101 .15611 L
.50103 .18248 L
.50104 .16522 L
Mistroke
.50106 .181 L
.50107 .13953 L
.50108 .14434 L
.5011 .13131 L
.50111 .13816 L
.50113 .14767 L
.50114 .15168 L
.50116 .18443 L
.50117 .18057 L
.50118 .1574 L
.5012 .1806 L
.50121 .15899 L
.50123 .13598 L
.50124 .13206 L
.50125 .1706 L
.50126 .15357 L
.50127 .18121 L
.50127 .18832 L
.50128 .18262 L
.50129 .17233 L
.50131 .13763 L
.50132 .16584 L
.50132 .17981 L
.50134 .16619 L
.50135 .14568 L
.50137 .13355 L
.50138 .1485 L
.5014 .17447 L
.5014 .17253 L
.50141 .15577 L
.50143 .14686 L
.50144 .13508 L
.50146 .16781 L
.50147 .15743 L
.50149 .16539 L
.5015 .1706 L
.50151 .17509 L
.50152 .14522 L
.50154 .18265 L
.50155 .17888 L
.50157 .16359 L
.50158 .16021 L
.50159 .18045 L
.50161 .1871 L
.50162 .15903 L
.50163 .1694 L
.50164 .17376 L
.50165 .13652 L
.50167 .17668 L
.50168 .15975 L
Mistroke
.5017 .18723 L
.50171 .15579 L
.50172 .19602 L
.50174 .18707 L
.50175 .17895 L
.50175 .1947 L
.50177 .14149 L
.50178 .14451 L
.50191 .1756 L
.50192 .15867 L
.50194 .16746 L
.50195 .14611 L
.50196 .14037 L
.50198 .19553 L
.50199 .18667 L
.50201 .20662 L
.50201 .15883 L
.50202 .15247 L
.50204 .20001 L
.50205 .11878 L
.50206 .1133 L
.50207 .16333 L
.50209 .18277 L
.5021 .19773 L
.50212 .15194 L
.50213 .21922 L
.50214 .21315 L
.50216 .14903 L
.50217 .18303 L
.50219 .13174 L
.5022 .14838 L
.5022 .1611 L
.50222 .1753 L
.50223 .16624 L
.50223 .17813 L
.50224 .21616 L
.50225 .1401 L
.50226 .19872 L
.50227 .1596 L
.50228 .17798 L
.50229 .17326 L
.5023 .15256 L
.5023 .19532 L
.50231 .2076 L
.50232 .1781 L
.50233 .18923 L
.50234 .1967 L
.50235 .1761 L
.50236 .18845 L
.50237 .16288 L
Mistroke
.50239 .17248 L
.50239 .18325 L
.5024 .17127 L
.50242 .1496 L
.50243 .15816 L
.50243 .1583 L
.50244 .1773 L
.50245 .12256 L
.50246 .17786 L
.50247 .19381 L
.50248 .16621 L
.5025 .16764 L
.50251 .16912 L
.50253 .13148 L
.50254 .18337 L
.50256 .16525 L
.50257 .14578 L
.50258 .20563 L
.50259 .16077 L
.5026 .18971 L
.50261 .18263 L
.50263 .13001 L
.50264 .14813 L
.50265 .14488 L
.50266 .18515 L
.50267 .14863 L
.50269 .1597 L
.5027 .16163 L
.50271 .17484 L
.50272 .15739 L
.50273 .16524 L
.50274 .1559 L
.50274 .1684 L
.50275 .15179 L
.50277 .19213 L
.50278 .14273 L
.50279 .16765 L
.5028 .16168 L
.50282 .18027 L
.50283 .20609 L
.50284 .17228 L
.50286 .1289 L
.50287 .20614 L
.50289 .2135 L
.5029 .16995 L
.50292 .18311 L
.50293 .12675 L
.50293 .1601 L
.50295 .2036 L
.50296 .15736 L
Mistroke
.50298 .18274 L
.50299 .18513 L
.503 .181 L
.50301 .14643 L
.50303 .19959 L
.50304 .16984 L
.50306 .15576 L
.50307 .19184 L
.50308 .16401 L
.5031 .16579 L
.50311 .12092 L
.50312 .11364 L
.50314 .18478 L
.50315 .23701 L
.50317 .17264 L
.50318 .17939 L
.50319 .18675 L
.50321 .15205 L
.50322 .16698 L
.50323 .15846 L
.50323 .16092 L
.50324 .19309 L
.50326 .17722 L
.50327 .16042 L
.50327 .15286 L
.50329 .1549 L
.50331 .19972 L
.50332 .16797 L
.50333 .16218 L
.50335 .14726 L
.50336 .17469 L
.50338 .16151 L
.50339 .16979 L
.5034 .13233 L
.50341 .1911 L
.50343 .16733 L
.50344 .19064 L
.50345 .20796 L
.50346 .15071 L
.50347 .15556 L
.50349 .14936 L
.5035 .2225 L
.5035 .15737 L
.50351 .15506 L
.50352 .18107 L
.50354 .15862 L
.50355 .15335 L
.50356 .18136 L
.50357 .1503 L
.50358 .20791 L
Mistroke
.50359 .16596 L
.5036 .15519 L
.50361 .16221 L
.50362 .18698 L
.50363 .1783 L
.50365 .16892 L
.50366 .16672 L
.50367 .1674 L
.50369 .16281 L
.5037 .15105 L
.50372 .19076 L
.50373 .14966 L
.50373 .1739 L
.50375 .16989 L
.50376 .17863 L
.50377 .19135 L
.50378 .16323 L
.5038 .24023 L
.50381 .1871 L
.50382 .16512 L
.50384 .17208 L
.50385 .1852 L
.50386 .14253 L
.50388 .13436 L
.50389 .17761 L
.5039 .20311 L
.50392 .20941 L
.50393 .1901 L
.50395 .19944 L
.50396 .18339 L
.50397 .18584 L
.50399 .11927 L
.504 .17934 L
.50401 .20225 L
.50403 .19819 L
.50404 .18791 L
.50405 .17131 L
.50406 .20035 L
.50407 .16204 L
.50409 .18382 L
.5041 .142 L
.50412 .13367 L
.50412 .20308 L
.50413 .14931 L
.50415 .16869 L
.50416 .19432 L
.50417 .1823 L
.50419 .16546 L
.5042 .18545 L
.50421 .15357 L
Mistroke
.50423 .18065 L
.50424 .22391 L
.50426 .20718 L
.50427 .13661 L
.50428 .14671 L
.50429 .19293 L
.5043 .16736 L
.50432 .171 L
.50433 .12061 L
.50434 .13524 L
.50435 .19277 L
.50436 .17262 L
.50437 .16947 L
.50438 .17428 L
.50439 .18493 L
.5044 .15185 L
.50441 .17981 L
.50442 .15937 L
.50443 .15778 L
.50444 .20943 L
.50446 .1715 L
.50447 .17229 L
.50449 .18013 L
.5045 .20344 L
.50452 .19129 L
.50453 .16627 L
.50455 .13397 L
.50456 .18181 L
.50458 .19803 L
.50459 .22388 L
.5046 .1488 L
.50462 .18585 L
.50463 .13612 L
.50465 .14714 L
.50465 .10242 L
.50466 .1816 L
.50468 .15267 L
.50469 .15528 L
.5047 .15553 L
.50471 .18083 L
.50472 .21121 L
.50473 .16873 L
.50474 .21432 L
.50475 .20023 L
.50476 .16174 L
.50477 .15863 L
.50479 .16158 L
.5048 .16061 L
.5048 .18166 L
.50481 .22405 L
Mistroke
.50482 .14454 L
.50483 .14735 L
.50484 .20943 L
.50485 .17705 L
.50486 .15547 L
.50487 .19089 L
.50488 .18664 L
.50489 .20963 L
.5049 .18912 L
.50491 .15403 L
.50492 .15434 L
.50494 .15559 L
.50494 .16861 L
.50495 .22995 L
.50497 .18728 L
.50498 .13497 L
.505 .19657 L
.50501 .17287 L
.50503 .12147 L
.50504 .1805 L
.50505 .19583 L
.50507 .20121 L
.50508 .17955 L
.50509 .16769 L
.5051 .19831 L
.50511 .19695 L
.50513 .14729 L
.50514 .13862 L
.50515 .14817 L
.50517 .18332 L
.50518 .13624 L
.50519 .18696 L
.50521 .1801 L
.50522 .21145 L
.50524 .15334 L
.50525 .16963 L
.50527 .19168 L
.50528 .21116 L
.5053 .1743 L
.50531 .17244 L
.50531 .15459 L
.50532 .18359 L
.50533 .14954 L
.50535 .18103 L
.50536 .20311 L
.50536 .18958 L
.50538 .19406 L
.50539 .14992 L
.50541 .18595 L
.50542 .16306 L
Mistroke
.50544 .18394 L
.50545 .17549 L
.50545 .17113 L
.50547 .16041 L
.50548 .22032 L
.5055 .10848 L
.50551 .16915 L
.50552 .14345 L
.50553 .16758 L
.50554 .14996 L
.50555 .18507 L
.50556 .15736 L
.50558 .20769 L
.50558 .19966 L
.50559 .18456 L
.5056 .15915 L
.50561 .13951 L
.50563 .1625 L
.50564 .21194 L
.50565 .18044 L
.50567 .19879 L
.50568 .12839 L
.5057 .14289 L
.5057 .1825 L
.50571 .16394 L
.50573 .12488 L
.50574 .13361 L
.50576 .16041 L
.50577 .14609 L
.50577 .14564 L
.50579 .22482 L
.5058 .17605 L
.50582 .13069 L
.50583 .13869 L
.50585 .17061 L
.50586 .18575 L
.50587 .20009 L
.50588 .16734 L
.5059 .19437 L
.50591 .19947 L
.50593 .19457 L
.50594 .18249 L
.50595 .15034 L
.50597 .14661 L
.50598 .16298 L
.506 .1591 L
.50601 .13968 L
.50602 .16036 L
.50604 .16298 L
.50605 .18329 L
Mistroke
.50606 .16826 L
.50607 .1991 L
.50608 .18556 L
.5061 .16886 L
.50611 .14318 L
.50613 .16264 L
.50614 .19919 L
.50616 .18044 L
.50616 .1767 L
.50617 .1398 L
.50618 .16955 L
.50619 .18325 L
.5062 .19282 L
.50621 .19709 L
.50622 .1847 L
.50624 .18916 L
.50624 .16187 L
.50625 .17714 L
.50627 .19875 L
.50628 .15432 L
.5063 .12693 L
.50631 .16537 L
.50632 .19788 L
.50633 .19606 L
.50634 .20578 L
.50634 .20038 L
.50636 .21173 L
.50637 .18714 L
.50638 .17289 L
.50639 .16278 L
.50641 .18862 L
.50642 .16121 L
.50643 .17187 L
.50643 .18056 L
.50644 .13055 L
.50645 .2067 L
.50646 .14976 L
.50647 .23036 L
.50649 .191 L
.5065 .13845 L
.50651 .1738 L
.50652 .14488 L
.50654 .16073 L
.50654 .19108 L
.50655 .12581 L
.50657 .13848 L
.50658 .19406 L
.50659 .14624 L
.50661 .21432 L
.50662 .19316 L
Mistroke
.50664 .18038 L
.50665 .15739 L
.50667 .17955 L
.50668 .14371 L
.50669 .18308 L
.50671 .17706 L
.50672 .16108 L
.50673 .16112 L
.50674 .18523 L
.50676 .13997 L
.50677 .15857 L
.50678 .17315 L
.5068 .18 L
.50681 .18306 L
.50682 .15738 L
.50683 .18829 L
.50684 .09891 L
.50685 .19471 L
.50686 .15422 L
.50687 .19415 L
.50688 .17358 L
.5069 .15833 L
.50691 .17292 L
.50691 .1563 L
.50692 .14168 L
.50693 .18328 L
.50695 .1691 L
.50695 .18877 L
.50696 .15992 L
.50698 .13232 L
.50699 .17115 L
.507 .18093 L
.50702 .17387 L
.50703 .19256 L
.50704 .10636 L
.50706 .20885 L
.50707 .12001 L
.50708 .18518 L
.50709 .13905 L
.5071 .13538 L
.50711 .15397 L
.50712 .21968 L
.50714 .15951 L
.50715 .20035 L
.50717 .17931 L
.50718 .17783 L
.50719 .14946 L
.50721 .20207 L
.50722 .15621 L
.50723 .20793 L
Mistroke
.50725 .17349 L
.50726 .17686 L
.50727 .14801 L
.50729 .20341 L
.5073 .15233 L
.50731 .18238 L
.50733 .17927 L
.50734 .20858 L
.50736 .18392 L
.50737 .21651 L
.50739 .15735 L
.5074 .19881 L
.50742 .18653 L
.50743 .15898 L
.50743 .16637 L
.50744 .16173 L
.50745 .17697 L
.50747 .15567 L
.50747 .1798 L
.50748 .23462 L
.5075 .17001 L
.50751 .13045 L
.50753 .1614 L
.50754 .18294 L
.50755 .18495 L
.50757 .16269 L
.50758 .12761 L
.5076 .15207 L
.50761 .16373 L
.50762 .17527 L
.50764 .21402 L
.50765 .17515 L
.50766 .17832 L
.50767 .20963 L
.50769 .23097 L
.5077 .19199 L
.50772 .12963 L
.50773 .2209 L
.50774 .14047 L
.50775 .17453 L
.50776 .1726 L
.50778 .15099 L
.50778 .16799 L
.50779 .17353 L
.5078 .18841 L
.50781 .15195 L
.50782 .18388 L
.50783 .15393 L
.50784 .17601 L
.50784 .13872 L
Mistroke
.50786 .15482 L
.50787 .19143 L
.50789 .16831 L
.5079 .13621 L
.50791 .15591 L
.50792 .18491 L
.50793 .16516 L
.50795 .13658 L
.50796 .16936 L
.50797 .15365 L
.50799 .15601 L
.508 .20104 L
.50801 .1568 L
.50802 .21121 L
.50804 .16645 L
.50804 .17761 L
.50805 .17185 L
.50807 .20023 L
.50808 .15069 L
.5081 .18997 L
.50811 .18984 L
.50812 .18102 L
.50814 .166 L
.50815 .13012 L
.50816 .16068 L
.50818 .16675 L
.50819 .15865 L
.5082 .17546 L
.50822 .1502 L
.50823 .15781 L
.50825 .14075 L
.50826 .13294 L
.50827 .18059 L
.50829 .17219 L
.5083 .17175 L
.50832 .18482 L
.50833 .2043 L
.50835 .16673 L
.50836 .16799 L
.50837 .14952 L
.50838 .17576 L
.50839 .15527 L
.50839 .18557 L
.50841 .1417 L
.50842 .13449 L
.50844 .16076 L
.50845 .19543 L
.50847 .13399 L
.50848 .16713 L
.50849 .16018 L
Mistroke
.50851 .17454 L
.50852 .14326 L
.50854 .14924 L
.50855 .17594 L
.50857 .20839 L
.50858 .18173 L
.5086 .15206 L
.50861 .18564 L
.50862 .14918 L
.50864 .13997 L
.50865 .20785 L
.50866 .16495 L
.50867 .21525 L
.50868 .19237 L
.50869 .18595 L
.5087 .21056 L
.50871 .18712 L
.50872 .15264 L
.50873 .20409 L
.50874 .18518 L
.50875 .19891 L
.50875 .18522 L
.50876 .18271 L
.50877 .17994 L
.50878 .17558 L
.50879 .16608 L
.5088 .13276 L
.50882 .17711 L
.50883 .19459 L
.50885 .19166 L
.50886 .18704 L
.50888 .19728 L
.50889 .16827 L
.5089 .1437 L
.50892 .15481 L
.50893 .16554 L
.50894 .19146 L
.50896 .16349 L
.50897 .1355 L
.50899 .18909 L
.509 .15564 L
.50901 .18911 L
.50902 .12945 L
.50903 .19492 L
.50904 .17168 L
.50905 .16815 L
.50906 .16146 L
.50908 .21413 L
.50909 .15982 L
.50911 .15407 L
Mistroke
.50912 .20566 L
.50913 .14294 L
.50915 .1793 L
.50916 .16295 L
.50918 .16567 L
.50919 .17396 L
.50921 .19912 L
.50922 .15094 L
.50923 .1638 L
.50924 .15861 L
.50926 .18475 L
.50927 .18926 L
.50929 .18818 L
.5093 .17746 L
.50932 .18115 L
.50933 .18082 L
.50934 .19745 L
.50936 .17282 L
.50937 .2137 L
.50938 .1596 L
.5094 .202 L
.50941 .15574 L
.50943 .18602 L
.50944 .18552 L
.50946 .15795 L
.50947 .15628 L
.50948 .16015 L
.50949 .13977 L
.50951 .21209 L
.50952 .17486 L
.50953 .13727 L
.50955 .14843 L
.50956 .18507 L
.50957 .15203 L
.50958 .17636 L
.5096 .17867 L
.50961 .1791 L
.50962 .19823 L
.50964 .17768 L
.50965 .1945 L
.50967 .15428 L
.50968 .21207 L
.50969 .18822 L
.5097 .1986 L
.50971 .16664 L
.50973 .179 L
.50974 .18346 L
.50975 .19515 L
.50976 .15418 L
.50977 .17675 L
Mistroke
.50978 .16018 L
.5098 .14623 L
.50981 .17275 L
.50982 .16704 L
.50984 .19488 L
.50985 .14919 L
.50986 .14458 L
.50987 .21906 L
.50989 .14073 L
.50989 .19871 L
.5099 .21778 L
.50992 .20993 L
.50993 .13545 L
.50995 .16953 L
.50996 .13578 L
.50997 .15658 L
.50999 .19342 L
.51 .18129 L
.51001 .15422 L
.51003 .18241 L
.51004 .16258 L
.51005 .15163 L
.51007 .1776 L
.51008 .1572 L
.5101 .16949 L
.51011 .20877 L
.51012 .16227 L
.51014 .16775 L
.51015 .15568 L
.51017 .20353 L
.51018 .14151 L
.5102 .15908 L
.51021 .11194 L
.51022 .19234 L
.51023 .13874 L
.51024 .14657 L
.51024 .1585 L
.51026 .13093 L
.51027 .1846 L
.51029 .19363 L
.5103 .18088 L
.51032 .19299 L
.51033 .20547 L
.51034 .13718 L
.51036 .16394 L
.51037 .16906 L
.51039 .16246 L
.5104 .13803 L
.51042 .16813 L
.51043 .18772 L
Mistroke
.51045 .18611 L
.51046 .2038 L
.51047 .16498 L
.51049 .19846 L
.5105 .1791 L
.51051 .19826 L
.51052 .14284 L
.51053 .1592 L
.51054 .13016 L
.51055 .13107 L
.51055 .21788 L
.51057 .17944 L
.51058 .14838 L
.51059 .18971 L
.51059 .14649 L
.5106 .17433 L
.51061 .17535 L
.51062 .16658 L
.51063 .20206 L
.51064 .1672 L
.51065 .20368 L
.51067 .15864 L
.51068 .13248 L
.5107 .18378 L
.51071 .16567 L
.51073 .2137 L
.51074 .15905 L
.51075 .14572 L
.51077 .14297 L
.51078 .20466 L
.51079 .16902 L
.51081 .16265 L
.51082 .14962 L
.51084 .1956 L
.51085 .17237 L
.51086 .11682 L
.51087 .18233 L
.51089 .17658 L
.5109 .13162 L
.51091 .19544 L
.51093 .20115 L
.51094 .15965 L
.51096 .18749 L
.51097 .17738 L
.51098 .14756 L
.51099 .17244 L
.51101 .16693 L
.51102 .17269 L
.51103 .19706 L
.51105 .17538 L
Mistroke
.51106 .21595 L
.51108 .17563 L
.51108 .20723 L
.51109 .20228 L
.51111 .19819 L
.51112 .2085 L
.51114 .22079 L
.51115 .20474 L
.51116 .17923 L
.51118 .17474 L
.51119 .15785 L
.51121 .18331 L
.51122 .1782 L
.51123 .18282 L
.51125 .14541 L
.51126 .17878 L
.51128 .17316 L
.51129 .19824 L
.5113 .13347 L
.51131 .12467 L
.51132 .15941 L
.51133 .16427 L
.51134 .15597 L
.51136 .1612 L
.51137 .17453 L
.51138 .21164 L
.5114 .19731 L
.51141 .18725 L
.51142 .21522 L
.51144 .17028 L
.51145 .17993 L
.51147 .14091 L
.51148 .17833 L
.5115 .1279 L
.51151 .14127 L
.51152 .17374 L
.51154 .13437 L
.51155 .16612 L
.51156 .16814 L
.51158 .16948 L
.51159 .1645 L
.5116 .13792 L
.51162 .21814 L
.51163 .21573 L
.51165 .16891 L
.51166 .16025 L
.51167 .17568 L
.51169 .21036 L
.5117 .16424 L
.51171 .22039 L
Mistroke
.51171 .15525 L
.51172 .19127 L
.51174 .17526 L
.51175 .20411 L
.51177 .17399 L
.51178 .16895 L
.5118 .18155 L
.51181 .19532 L
.51182 .16083 L
.51184 .15448 L
.51185 .19556 L
.51187 .15837 L
.51188 .16679 L
.5119 .18078 L
.51191 .14894 L
.51193 .15265 L
.51194 .17909 L
.51195 .18965 L
.51196 .20209 L
.51198 .1237 L
.51199 .16762 L
.512 .13737 L
.51202 .18728 L
.51203 .18569 L
.51205 .13894 L
.51206 .18156 L
.51206 .17451 L
.51208 .17505 L
.51209 .18726 L
.51209 .19888 L
.51211 .14535 L
.51212 .17865 L
.51213 .14856 L
.51214 .14841 L
.51215 .19197 L
.51217 .20577 L
.51218 .18311 L
.5122 .20623 L
.51221 .17028 L
.51222 .15083 L
.51224 .21445 L
.51225 .15614 L
.51227 .17554 L
.51228 .18977 L
.5123 .15823 L
.51231 .21189 L
.51233 .20108 L
.51234 .23491 L
.51235 .20347 L
.51236 .16975 L
Mistroke
.51237 .1829 L
.51238 .15656 L
.51239 .17612 L
.5124 .16689 L
.51241 .17671 L
.51242 .1832 L
.51243 .15462 L
.51244 .18712 L
.51245 .17298 L
.51246 .14883 L
.51246 .20026 L
.51247 .16869 L
.51248 .20427 L
.51249 .18484 L
.5125 .1517 L
.51252 .21067 L
.51253 .20312 L
.51255 .17034 L
.51256 .16217 L
.51258 .17633 L
.51259 .16752 L
.5126 .16296 L
.51262 .18174 L
.51263 .18045 L
.51265 .16398 L
.51266 .15269 L
.51268 .2543 L
.51269 .14214 L
.51271 .12254 L
.51271 .20374 L
.51272 .15386 L
.51274 .20264 L
.51275 .21927 L
.51277 .18165 L
.51278 .15647 L
.51279 .233 L
.51281 .13396 L
.51282 .1861 L
.51283 .17885 L
.51284 .15235 L
.51286 .21094 L
.51287 .16806 L
.51289 .1291 L
.5129 .16401 L
.51291 .2226 L
.51293 .1743 L
.51294 .17339 L
.51294 .18333 L
.51296 .17281 L
.51297 .16069 L
Mistroke
.51299 .1506 L
.513 .17143 L
.51302 .15297 L
.51303 .15054 L
.51305 .21925 L
.51306 .1262 L
.51307 .16758 L
.51309 .15938 L
.5131 .18705 L
.51312 .17223 L
.51313 .21078 L
.51314 .19357 L
.51316 .19248 L
.51317 .16414 L
.51318 .15998 L
.51319 .17557 L
.51321 .16805 L
.51322 .19181 L
.51323 .18489 L
.51325 .18375 L
.51326 .1643 L
.51328 .15964 L
.51329 .22222 L
.5133 .17188 L
.51331 .21934 L
.51333 .21057 L
.51334 .17811 L
.51336 .18023 L
.51337 .16839 L
.51338 .16628 L
.51339 .15663 L
.5134 .1828 L
.51341 .16288 L
.51343 .14711 L
.51344 .12834 L
.51346 .16001 L
.51347 .14235 L
.51349 .19439 L
.5135 .20723 L
.51351 .18413 L
.51353 .18843 L
.51354 .16933 L
.51356 .14558 L
.51357 .14733 L
.51358 .17772 L
.5136 .14812 L
.51362 .19395 L
.51362 .19084 L
.51363 .18597 L
.51365 .15378 L
Mistroke
.51366 .17274 L
.51368 .15297 L
.51369 .12974 L
.5137 .17969 L
.51372 .16413 L
.51373 .15196 L
.51375 .16752 L
.51376 .19662 L
.51378 .15087 L
.51379 .19023 L
.5138 .13577 L
.51382 .17851 L
.51383 .17923 L
.51384 .19991 L
.51386 .17019 L
.51387 .13783 L
.51388 .20093 L
.5139 .21005 L
.51391 .19819 L
.51393 .15206 L
.51394 .16697 L
.51395 .17991 L
.51397 .15531 L
.51398 .15845 L
.51399 .22106 L
.514 .19628 L
.51401 .18464 L
.51403 .13838 L
.51404 .15987 L
.51405 .18866 L
.51407 .18964 L
.51408 .16824 L
.5141 .16661 L
.51411 .18674 L
.51412 .14761 L
.51413 .16869 L
.51414 .20318 L
.51416 .13065 L
.51417 .21121 L
.51418 .14636 L
.51419 .17391 L
.5142 .20099 L
.51421 .1377 L
.51422 .14436 L
.51423 .16389 L
.51424 .17491 L
.51425 .16843 L
.51426 .15328 L
.51427 .15827 L
.51428 .15014 L
Mistroke
.5143 .19575 L
.51431 .12719 L
.51433 .19731 L
.51434 .17155 L
.51436 .15609 L
.51437 .21061 L
.51438 .14322 L
.51439 .17195 L
.5144 .19895 L
.51441 .18483 L
.51442 .20308 L
.51443 .18198 L
.51445 .21517 L
.51446 .17003 L
.51448 .15975 L
.51449 .21424 L
.5145 .15563 L
.51451 .15999 L
.51451 .18166 L
.51453 .18181 L
.51454 .1781 L
.51455 .18575 L
.51456 .17963 L
.51457 .17527 L
.51458 .14576 L
.51459 .21721 L
.5146 .17611 L
.5146 .17951 L
.51461 .15591 L
.51463 .14387 L
.51464 .20294 L
.51464 .20614 L
.51466 .15635 L
.51467 .17584 L
.51468 .18535 L
.5147 .20949 L
.51471 .19293 L
.51473 .16692 L
.51474 .20139 L
.51474 .1932 L
.51475 .17237 L
.51476 .17053 L
.51478 .16057 L
.51479 .14531 L
.51479 .17111 L
.51481 .16314 L
.51482 .17662 L
.51483 .18095 L
.51484 .17016 L
.51485 .2235 L
Mistroke
.51486 .19566 L
.51487 .15892 L
.51488 .18089 L
.5149 .15507 L
.51491 .19021 L
.51492 .19711 L
.51493 .18988 L
.51495 .19759 L
.51495 .16095 L
.51496 .16965 L
.51498 .20698 L
.51499 .15883 L
.51501 .19971 L
.51502 .17111 L
.51504 .17513 L
.51505 .17674 L
.51506 .1635 L
.51508 .19609 L
.51509 .18608 L
.5151 .21093 L
.51511 .18939 L
.51512 .19011 L
.51514 .19968 L
.51515 .14077 L
.51515 .14726 L
.51517 .19675 L
.51518 .20624 L
.5152 .18667 L
.51521 .13887 L
.51522 .17035 L
.51523 .14913 L
.51524 .16543 L
.51524 .21465 L
.51526 .14997 L
.51527 .21414 L
.51528 .1671 L
.51529 .1517 L
.5153 .13373 L
.51531 .24366 L
.51533 .22167 L
.51533 .20459 L
.51534 .14472 L
.51536 .19997 L
.51537 .21059 L
.51538 .20035 L
.51539 .16672 L
.5154 .19247 L
.51541 .20431 L
.51542 .20166 L
.51543 .16522 L
Mistroke
.51545 .17729 L
.51547 .15673 L
.51548 .14693 L
.51549 .15449 L
.51551 .20961 L
.51552 .16795 L
.51553 .14988 L
.51555 .16305 L
.51556 .20716 L
.51558 .18265 L
.51559 .18725 L
.51561 .18759 L
.51562 .19069 L
.51562 .15449 L
.51563 .1488 L
.51564 .20186 L
.51565 .23286 L
.51566 .14089 L
.51567 .18058 L
.51568 .16899 L
.51569 .20338 L
.5157 .16172 L
.51571 .1606 L
.51572 .17771 L
.51574 .1641 L
.51575 .11952 L
.51577 .20579 L
.51577 .18707 L
.51578 .17757 L
.5158 .15523 L
.51581 .13716 L
.51583 .15809 L
.51584 .17381 L
.51586 .21434 L
.51587 .17551 L
.51588 .21928 L
.5159 .17806 L
.51591 .20249 L
.51592 .17946 L
.51593 .17577 L
.51594 .15322 L
.51596 .14805 L
.51597 .19595 L
.51598 .17175 L
.516 .14285 L
.51601 .13471 L
.51603 .16113 L
.51604 .17917 L
.51605 .20284 L
.51606 .20124 L
Mistroke
.51607 .20495 L
.51609 .19189 L
.51609 .15175 L
.5161 .15542 L
.51611 .18755 L
.51612 .18303 L
.51613 .18134 L
.51614 .16249 L
.51615 .13229 L
.51617 .20729 L
.51618 .19019 L
.51618 .2135 L
.5162 .16398 L
.51621 .17796 L
.51623 .19084 L
.51624 .17122 L
.51624 .15247 L
.51626 .14894 L
.51627 .1276 L
.51629 .14364 L
.5163 .19425 L
.51632 .19729 L
.51633 .16178 L
.51634 .13993 L
.51636 .16356 L
.51637 .16408 L
.51638 .16097 L
.51639 .18448 L
.51641 .14343 L
.51642 .15905 L
.51643 .15447 L
.51645 .15438 L
.51646 .14495 L
.51647 .13467 L
.51649 .15681 L
.5165 .15557 L
.51652 .2061 L
.51653 .14703 L
.51654 .21466 L
.51655 .18104 L
.51656 .18533 L
.51658 .1899 L
.51659 .1461 L
.5166 .18016 L
.51661 .20301 L
.51662 .1801 L
.51663 .17571 L
.51664 .17041 L
.51665 .14317 L
.51666 .1867 L
Mistroke
.51667 .22641 L
.51669 .13656 L
.5167 .1701 L
.51672 .1722 L
.51673 .18899 L
.51674 .14472 L
.51675 .13817 L
.51676 .14084 L
.51678 .1568 L
.51679 .16584 L
.51681 .2057 L
.51682 .17932 L
.51684 .1972 L
.51685 .21523 L
.51686 .18557 L
.51688 .19826 L
.51689 .1917 L
.51691 .19735 L
.51692 .10656 L
.51694 .1251 L
.51695 .19 L
.51697 .15972 L
.51697 .16359 L
.51698 .1494 L
.517 .1474 L
.51701 .15736 L
.51703 .15151 L
.51704 .16157 L
.51705 .16716 L
.51707 .21034 L
.51708 .12839 L
.51709 .16976 L
.5171 .2011 L
.51712 .16931 L
.51713 .1866 L
.51715 .14696 L
.51716 .21621 L
.51717 .17757 L
.51719 .15517 L
.5172 .12979 L
.5172 .14975 L
.51722 .19838 L
.51723 .14274 L
.51725 .24059 L
.51726 .17625 L
.51728 .18597 L
.51729 .15746 L
.5173 .13557 L
.51732 .13405 L
.51733 .15746 L
Mistroke
.51735 .22358 L
.51736 .20552 L
.51738 .1125 L
.51739 .23757 L
.5174 .18767 L
.51742 .17052 L
.51743 .18939 L
.51744 .1654 L
.51745 .21514 L
.51747 .16639 L
.51748 .17228 L
.51749 .16799 L
.51751 .18633 L
.51752 .16083 L
.51753 .18513 L
.51755 .14163 L
.51756 .19434 L
.51757 .18734 L
.51759 .14514 L
.5176 .17646 L
.51761 .1735 L
.51763 .14197 L
.51764 .161 L
.51765 .16234 L
.51766 .19647 L
.51767 .21582 L
.51769 .14638 L
.5177 .1302 L
.51772 .18344 L
.51773 .17686 L
.51775 .17065 L
.51776 .16548 L
.51777 .13952 L
.51779 .25459 L
.5178 .18592 L
.51781 .20088 L
.51783 .1897 L
.51786 .16764 L
.51787 .1519 L
.51789 .15971 L
.5179 .12698 L
.5179 .16107 L
.51791 .18134 L
.51792 .19002 L
.51793 .18418 L
.51795 .14372 L
.51796 .19226 L
.51798 .17485 L
.51799 .21488 L
.518 .18967 L
Mistroke
.51801 .19527 L
.51803 .18268 L
.51804 .11343 L
.51805 .15375 L
.51807 .18848 L
.51808 .17262 L
.5181 .19799 L
.5181 .17288 L
.51811 .22164 L
.51813 .19162 L
.51814 .17932 L
.51816 .14396 L
.51817 .16374 L
.51819 .17191 L
.5182 .18061 L
.51821 .21947 L
.51823 .15473 L
.51824 .18616 L
.51825 .16692 L
.51827 .21064 L
.51828 .20039 L
.5183 .15574 L
.51831 .14899 L
.51833 .24835 L
.51834 .18241 L
.51835 .18724 L
.51836 .16839 L
.51838 .2063 L
.51839 .1828 L
.5184 .14873 L
.51842 .16825 L
.51843 .22404 L
.51845 .15342 L
.51846 .20555 L
.51847 .15481 L
.51849 .16766 L
.5185 .19085 L
.51852 .16542 L
.51853 .11101 L
.51854 .17774 L
.51855 .15187 L
.51857 .17415 L
.51858 .18624 L
.5186 .19219 L
.51861 .16345 L
.51863 .19068 L
.51864 .1814 L
.51865 .17203 L
.51867 .18449 L
.51868 .15494 L
Mistroke
.51868 .11768 L
.5187 .18361 L
.51871 .17519 L
.51873 .15312 L
.51874 .16125 L
.51875 .13208 L
.51877 .19837 L
.51878 .19397 L
.51879 .18446 L
.51881 .20564 L
.51882 .12988 L
.51884 .16192 L
.51885 .15222 L
.51885 .19116 L
.51887 .20157 L
.51888 .17511 L
.51889 .1657 L
.5189 .15264 L
.51892 .18924 L
.51892 .14958 L
.51893 .17828 L
.51894 .18847 L
.51895 .16976 L
.51897 .17685 L
.51897 .17095 L
.51898 .15653 L
.519 .1489 L
.51901 .20664 L
.51903 .15316 L
.51904 .20788 L
.51905 .15382 L
.51907 .19273 L
.51908 .1889 L
.51909 .19056 L
.5191 .19674 L
.51912 .13964 L
.51913 .16783 L
.51913 .17736 L
.51915 .21267 L
.51916 .15798 L
.51918 .20797 L
.51919 .16097 L
.5192 .20495 L
.51921 .1722 L
.51922 .21146 L
.51923 .19031 L
.51924 .14044 L
.51926 .18249 L
.51926 .14945 L
.51927 .1888 L
Mistroke
.51929 .18621 L
.5193 .14331 L
.51931 .19154 L
.51932 .16676 L
.51933 .16304 L
.51934 .19348 L
.51935 .17328 L
.51937 .14191 L
.51938 .17063 L
.51939 .17698 L
.5194 .15627 L
.51941 .17856 L
.51942 .18035 L
.51943 .21094 L
.51943 .16492 L
.51944 .17986 L
.51945 .16652 L
.51946 .18554 L
.51948 .19341 L
.51949 .15672 L
.51951 .1576 L
.51952 .16451 L
.51953 .1788 L
.51954 .17822 L
.51955 .17685 L
.51957 .16674 L
.51958 .158 L
.51959 .21327 L
.5196 .16528 L
.51961 .15534 L
.51963 .17168 L
.51964 .20399 L
.51965 .2045 L
.51967 .19217 L
.51968 .19603 L
.5197 .18329 L
.51971 .18794 L
.51972 .16706 L
.51972 .21252 L
.51973 .16159 L
.51975 .18471 L
.51976 .17624 L
.51978 .14941 L
.51979 .17463 L
.5198 .19237 L
.51982 .15519 L
.51983 .14545 L
.51984 .19687 L
.51986 .16499 L
.51987 .16801 L
Mistroke
.51989 .15695 L
.5199 .19543 L
.51991 .14747 L
.51993 .20286 L
.51994 .16655 L
.51995 .13225 L
.51997 .18589 L
.51998 .17324 L
.52 .14538 L
.52001 .17283 L
.52003 .21203 L
.52003 .16669 L
.52004 .16408 L
.52006 .1614 L
.52007 .18571 L
.52008 .19131 L
.52009 .21984 L
.5201 .13533 L
.52011 .19588 L
.52012 .19757 L
.52013 .15969 L
.52015 .17464 L
.52016 .23151 L
.52018 .18821 L
.52019 .15278 L
.52021 .17793 L
.52022 .13954 L
.52023 .17881 L
.52025 .17873 L
.52026 .16285 L
.52028 .18328 L
.52029 .18303 L
.5203 .22238 L
.52031 .18639 L
.52032 .20559 L
.52034 .16105 L
.52036 .18469 L
.52037 .17421 L
.52038 .21131 L
.52039 .11397 L
.5204 .16899 L
.52042 .18604 L
.52042 .21188 L
.52043 .18433 L
.52044 .18037 L
.52045 .21818 L
.52047 .18323 L
.52048 .19615 L
.52049 .17529 L
.5205 .18758 L
Mistroke
.52051 .19216 L
.52051 .20234 L
.52053 .12098 L
.52054 .19057 L
.52055 .14521 L
.52056 .17806 L
.52057 .14523 L
.52059 .15589 L
.5206 .17726 L
.52061 .20142 L
.52063 .15919 L
.52064 .17693 L
.52065 .19176 L
.52066 .1868 L
.52068 .17114 L
.52069 .13631 L
.52069 .20992 L
.52071 .23907 L
.52072 .1688 L
.52074 .12624 L
.52075 .14405 L
.52076 .15913 L
.52078 .13849 L
.52079 .14753 L
.5208 .14579 L
.52082 .16047 L
.52083 .17247 L
.52085 .18515 L
.52086 .17603 L
.52087 .1584 L
.52089 .17523 L
.5209 .17063 L
.52091 .12971 L
.52093 .15943 L
.52094 .16724 L
.52096 .12935 L
.52096 .22126 L
.52097 .23124 L
.52099 .1554 L
.52099 .2079 L
.521 .1908 L
.52102 .14702 L
.52103 .21492 L
.52104 .20854 L
.52105 .18079 L
.52106 .17396 L
.52107 .18709 L
.52108 .23882 L
.52109 .15836 L
.5211 .19687 L
Mistroke
.52111 .14292 L
.52113 .16046 L
.52114 .1943 L
.52116 .15386 L
.52117 .17741 L
.52118 .15709 L
.52119 .21656 L
.5212 .13821 L
.52121 .15382 L
.52122 .18501 L
.52123 .11 L
.52125 .192 L
.52126 .15716 L
.52127 .12811 L
.52129 .15885 L
.5213 .15459 L
.5213 .18875 L
.52132 .18076 L
.52133 .13095 L
.52135 .18744 L
.52136 .15233 L
.52137 .13611 L
.52138 .19659 L
.5214 .16331 L
.52141 .17649 L
.52143 .14277 L
.52144 .21001 L
.52146 .14547 L
.52147 .14923 L
.52148 .20678 L
.52149 .1884 L
.5215 .19784 L
.52151 .18101 L
.52153 .12106 L
.52154 .20588 L
.52156 .19685 L
.52157 .21191 L
.52158 .15198 L
.52159 .18257 L
.5216 .17515 L
.52162 .18951 L
.52162 .2091 L
.52163 .14263 L
.52165 .20325 L
.52166 .22382 L
.52166 .20111 L
.52167 .16921 L
.52168 .1711 L
.5217 .22048 L
.52171 .14039 L
Mistroke
.52172 .157 L
.52173 .16768 L
.52174 .1367 L
.52176 .19874 L
.52177 .1683 L
.52179 .16684 L
.5218 .16094 L
.52181 .1908 L
.52182 .18709 L
.52183 .17922 L
.52184 .19988 L
.52185 .19863 L
.52186 .20098 L
.52187 .22041 L
.52188 .20071 L
.52189 .15294 L
.52189 .17198 L
.5219 .14333 L
.52192 .18694 L
.52193 .17553 L
.52196 .20281 L
.52198 .21611 L
.52199 .13459 L
.52201 .17026 L
.52202 .1612 L
.52203 .21473 L
.52205 .15085 L
.52206 .171 L
.52208 .19633 L
.52209 .21833 L
.5221 .19218 L
.52211 .18579 L
.52212 .18308 L
.52214 .17002 L
.52215 .23515 L
.52217 .21942 L
.52219 .18692 L
.52221 .1832 L
.52222 .15255 L
.52224 .18973 L
.52224 .14366 L
.52225 .14078 L
.52227 .19485 L
.52228 .16291 L
.52229 .17536 L
.52231 .1869 L
.52232 .20115 L
.52233 .15665 L
.52235 .20765 L
.52236 .18032 L
Mistroke
.52237 .15299 L
.52239 .17011 L
.5224 .21189 L
.52242 .12176 L
.52243 .2272 L
.52245 .1743 L
.52246 .15582 L
.52247 .17448 L
.52249 .21653 L
.5225 .19126 L
.52251 .19057 L
.52252 .18244 L
.52253 .18832 L
.52253 .15318 L
.52255 .20888 L
.52256 .17195 L
.52257 .17684 L
.52258 .23423 L
.52259 .17707 L
.52261 .18157 L
.52263 .19573 L
.52264 .17385 L
.52265 .12756 L
.52266 .19143 L
.52267 .18273 L
.52268 .15249 L
.52269 .14555 L
.5227 .12785 L
.52272 .15405 L
.52273 .18891 L
.52275 .17503 L
.52275 .17065 L
.52276 .19037 L
.52277 .17157 L
.52278 .18556 L
.52279 .17822 L
.52281 .20894 L
.52282 .16026 L
.52283 .13561 L
.52284 .1837 L
.52285 .19868 L
.52286 .16569 L
.52287 .17154 L
.52288 .17852 L
.52289 .21659 L
.52289 .16089 L
.52291 .1691 L
.52292 .19338 L
.52293 .16355 L
.52294 .16296 L
Mistroke
.52296 .16797 L
.52297 .15702 L
.52298 .1482 L
.52299 .1672 L
.523 .20598 L
.52302 .15855 L
.52303 .18665 L
.52305 .17448 L
.52306 .21464 L
.52307 .12883 L
.52309 .15375 L
.5231 .16103 L
.52311 .20726 L
.52313 .19383 L
.52314 .18911 L
.52315 .21981 L
.52316 .14358 L
.52318 .19425 L
.52318 .18936 L
.52319 .20322 L
.5232 .1731 L
.52321 .19488 L
.52323 .13737 L
.52324 .14454 L
.52324 .13753 L
.52326 .17846 L
.52327 .18727 L
.52328 .19038 L
.52329 .16519 L
.5233 .17543 L
.52331 .18808 L
.52332 .18087 L
.52334 .19622 L
.52335 .17641 L
.52336 .22088 L
.52337 .16412 L
.52338 .15402 L
.5234 .18115 L
.5234 .18422 L
.52341 .18056 L
.52342 .17035 L
.52343 .17591 L
.52344 .19992 L
.52345 .18825 L
.52346 .1817 L
.52348 .21399 L
.52349 .2083 L
.5235 .19301 L
.52352 .13062 L
.52353 .16295 L
Mistroke
.52354 .17876 L
.52356 .11759 L
.52357 .13394 L
.52359 .1751 L
.5236 .19636 L
.52362 .14601 L
.52363 .18059 L
.52364 .14769 L
.52365 .1924 L
.52366 .20382 L
.52368 .16214 L
.52369 .15491 L
.52371 .17607 L
.52372 .17581 L
.52373 .17059 L
.52374 .16419 L
.52375 .1864 L
.52376 .1623 L
.52377 .15873 L
.52378 .14318 L
.52379 .19269 L
.5238 .16598 L
.52381 .20742 L
.52382 .14324 L
.52382 .19727 L
.52384 .18875 L
.52385 .16153 L
.52387 .17299 L
.52388 .17351 L
.5239 .18753 L
.52391 .17443 L
.52393 .18493 L
.52394 .17604 L
.52395 .21421 L
.52397 .17353 L
.52398 .12024 L
.524 .19598 L
.52401 .17106 L
.52403 .20411 L
.52404 .19321 L
.52405 .18805 L
.52406 .15785 L
.52407 .16797 L
.52409 .17282 L
.5241 .20386 L
.52412 .19291 L
.52413 .19344 L
.52414 .20135 L
.52416 .17889 L
.52417 .15918 L
Mistroke
.52418 .17762 L
.52419 .13519 L
.52421 .17854 L
.52422 .15347 L
.52424 .1289 L
.52425 .16238 L
.52426 .20075 L
.52427 .18277 L
.52428 .1737 L
.52429 .16487 L
.52431 .1704 L
.52432 .21589 L
.52433 .16611 L
.52434 .17877 L
.52435 .15202 L
.52437 .18432 L
.52438 .13195 L
.52439 .17222 L
.52441 .20291 L
.52442 .16296 L
.52444 .19254 L
.52445 .16023 L
.52445 .15849 L
.52447 .20992 L
.52448 .19574 L
.52449 .19374 L
.5245 .16476 L
.52452 .15173 L
.52453 .165 L
.52454 .15358 L
.52456 .17187 L
.52457 .21667 L
.52458 .18832 L
.5246 .2018 L
.52461 .19396 L
.52462 .209 L
.52464 .17802 L
.52465 .16735 L
.52467 .22257 L
.52468 .18088 L
.52469 .21413 L
.52471 .17298 L
.52472 .20419 L
.52474 .22669 L
.52475 .15305 L
.52477 .19793 L
.52478 .18601 L
.5248 .2331 L
.5248 .16994 L
.52481 .20381 L
Mistroke
.52482 .15799 L
.52483 .19365 L
.52484 .19883 L
.52486 .17206 L
.52487 .19061 L
.52489 .19142 L
.5249 .16505 L
.52492 .16987 L
.52493 .19723 L
.52494 .17949 L
.52496 .1932 L
.52497 .15725 L
.52499 .17364 L
.525 .18555 L
.52501 .16983 L
.52503 .17404 L
.52504 .15027 L
.52506 .17208 L
.52507 .23166 L
.52508 .1928 L
.52509 .16205 L
.52511 .19903 L
.52511 .17744 L
.52512 .19173 L
.52513 .17538 L
.52514 .16785 L
.52515 .20226 L
.52516 .20836 L
.52517 .17722 L
.52518 .17044 L
.52519 .19978 L
.5252 .16442 L
.52521 .1912 L
.52521 .19756 L
.52522 .22067 L
.52524 .18444 L
.52525 .19354 L
.52527 .20302 L
.52528 .17366 L
.5253 .19225 L
.52531 .11784 L
.52532 .18339 L
.52534 .18561 L
.52535 .15197 L
.52536 .20334 L
.52538 .17694 L
.52539 .22467 L
.52541 .18626 L
.52542 .18136 L
.52543 .16124 L
Mistroke
.52544 .16135 L
.52545 .17174 L
.52546 .19685 L
.52547 .17288 L
.52549 .15203 L
.5255 .14741 L
.52551 .17379 L
.52553 .1692 L
.52554 .16251 L
.52556 .18105 L
.52557 .18269 L
.52558 .18376 L
.5256 .15025 L
.52561 .16295 L
.52563 .18004 L
.52564 .18551 L
.52565 .17963 L
.52567 .20772 L
.52568 .16901 L
.52569 .18586 L
.52571 .18693 L
.52572 .15082 L
.52574 .16631 L
.52575 .16744 L
.52577 .16869 L
.52578 .16066 L
.52579 .1325 L
.52581 .20504 L
.52582 .1747 L
.52583 .17276 L
.52584 .12936 L
.52585 .21479 L
.52586 .14085 L
.52588 .15594 L
.52589 .1942 L
.52589 .1768 L
.52591 .14564 L
.52592 .17826 L
.52593 .19803 L
.52594 .15822 L
.52595 .22639 L
.52597 .16555 L
.52598 .16103 L
.52599 .11864 L
.52601 .1656 L
.52602 .1535 L
.52603 .18094 L
.52605 .17725 L
.52606 .17149 L
.52608 .16388 L
Mistroke
.52609 .22263 L
.5261 .19352 L
.52612 .21326 L
.52613 .16012 L
.52615 .18186 L
.52616 .1663 L
.52618 .16192 L
.52619 .13231 L
.5262 .14382 L
.52621 .13699 L
.52622 .22225 L
.52624 .17946 L
.52625 .20209 L
.52625 .21143 L
.52627 .17213 L
.52628 .1826 L
.5263 .15238 L
.52631 .20214 L
.52632 .18399 L
.52634 .20525 L
.52635 .1695 L
.52637 .20969 L
.52638 .17287 L
.5264 .16084 L
.52641 .18916 L
.52643 .18627 L
.52644 .2154 L
.52645 .1673 L
.52647 .17127 L
.52648 .15662 L
.52649 .15322 L
.5265 .16555 L
.52651 .15823 L
.52652 .1557 L
.52653 .1785 L
.52653 .19755 L
.52655 .17001 L
.52656 .20914 L
.52657 .18049 L
.52657 .2157 L
.52658 .15588 L
.52659 .18239 L
.5266 .19474 L
.52661 .19191 L
.52662 .13608 L
.52663 .19738 L
.52665 .13027 L
.52666 .1861 L
.52667 .17933 L
.52669 .14913 L
Mistroke
.52671 .22573 L
.52672 .17818 L
.52673 .16921 L
.52675 .15506 L
.52676 .20748 L
.52677 .19689 L
.52679 .23448 L
.5268 .18423 L
.52682 .18909 L
.52683 .15354 L
.52684 .19283 L
.52685 .20602 L
.52687 .14854 L
.52688 .20082 L
.52689 .21732 L
.52691 .17548 L
.52692 .15419 L
.52693 .17116 L
.52695 .2057 L
.52696 .15551 L
.52697 .17305 L
.52699 .2004 L
.527 .21779 L
.52701 .17077 L
.52703 .18069 L
.52704 .20225 L
.52705 .19369 L
.52706 .14876 L
.52707 .18879 L
.52709 .21834 L
.5271 .16622 L
.52711 .16294 L
.52713 .16621 L
.52715 .16733 L
.52716 .1874 L
.52717 .16276 L
.52719 .17934 L
.5272 .16223 L
.52721 .18949 L
.52723 .17307 L
.52724 .17376 L
.52726 .18346 L
.52727 .20948 L
.52729 .17986 L
.5273 .16308 L
.5273 .13944 L
.52731 .19609 L
.52732 .16165 L
.52733 .19971 L
.52735 .2007 L
Mistroke
.52736 .18028 L
.52737 .20914 L
.52739 .18321 L
.5274 .20886 L
.52742 .18058 L
.52743 .21214 L
.52745 .14622 L
.52746 .18468 L
.52748 .14201 L
.52749 .23282 L
.5275 .22116 L
.52755 .17395 L
.52757 .17216 L
.52758 .18125 L
.5276 .13669 L
.52761 .12235 L
.52763 .18144 L
.52763 .16647 L
.52764 .1584 L
.52766 .16207 L
.52767 .17278 L
.52768 .17662 L
.52769 .17535 L
.5277 .20815 L
.5277 .19793 L
.52772 .20358 L
.52773 .19686 L
.52774 .17122 L
.52775 .17832 L
.52776 .20447 L
.52778 .21377 L
.52779 .16982 L
.52781 .22095 L
.52782 .17906 L
.52784 .18483 L
.52785 .14608 L
.52786 .21612 L
.52787 .20737 L
.52789 .16333 L
.5279 .15541 L
.52791 .14468 L
.52793 .15383 L
.52794 .21054 L
.52796 .15193 L
.52797 .15863 L
.52798 .1545 L
.52799 .16292 L
.52802 .18686 L
.52803 .18055 L
.52805 .2111 L
Mistroke
.52806 .19747 L
.52807 .20095 L
.52809 .18378 L
.5281 .19138 L
.5281 .1696 L
.52812 .22162 L
.52813 .16268 L
.52815 .16881 L
.52816 .16688 L
.52817 .1939 L
.52819 .21601 L
.5282 .19326 L
.52822 .16562 L
.52823 .17759 L
.52824 .18357 L
.52826 .16059 L
.52827 .14466 L
.52829 .18967 L
.52829 .20916 L
.5283 .21695 L
.52831 .20153 L
.52832 .17951 L
.52833 .17926 L
.52834 .164 L
.52835 .14359 L
.52835 .17218 L
.52837 .13876 L
.52839 .14068 L
.52839 .16571 L
.5284 .1892 L
.52842 .16548 L
.52843 .18641 L
.52845 .20819 L
.52846 .20711 L
.52847 .17483 L
.52849 .16225 L
.5285 .1703 L
.52851 .15436 L
.52852 .18192 L
.52853 .17711 L
.52854 .22101 L
.52855 .1931 L
.52857 .14697 L
.52858 .13635 L
.5286 .16101 L
.52861 .14131 L
.52862 .19205 L
.52863 .2221 L
.52864 .16572 L
.52865 .18617 L
Mistroke
.52866 .21137 L
.52868 .13892 L
.52869 .12724 L
.52869 .20521 L
.52871 .176 L
.52872 .21341 L
.52873 .1753 L
.52874 .18302 L
.52875 .18528 L
.52876 .20048 L
.52877 .15035 L
.52879 .18253 L
.5288 .16692 L
.52881 .17852 L
.52882 .19735 L
.52883 .16333 L
.52884 .13785 L
.52885 .17388 L
.52885 .22048 L
.52886 .13524 L
.52887 .17638 L
.52889 .18331 L
.5289 .16082 L
.52891 .16247 L
.52893 .14785 L
.52894 .1997 L
.52895 .16422 L
.52896 .1677 L
.52897 .18078 L
.52899 .18525 L
.529 .17243 L
.52902 .13851 L
.52903 .20448 L
.52904 .18197 L
.52906 .18579 L
.52907 .18778 L
.52908 .20819 L
.52909 .1773 L
.52911 .21887 L
.52912 .17663 L
.52914 .17598 L
.52915 .14543 L
.52916 .18556 L
.52918 .20187 L
.52919 .13142 L
.5292 .20199 L
.52922 .20858 L
.52923 .17234 L
.52924 .215 L
.52925 .16484 L
Mistroke
.52926 .14949 L
.52927 .19 L
.52928 .16418 L
.52929 .13912 L
.52931 .18998 L
.52932 .18597 L
.52934 .15313 L
.52935 .1973 L
.52936 .17796 L
.52938 .21849 L
.52939 .20478 L
.5294 .22084 L
.52941 .17973 L
.52941 .20203 L
.52942 .21236 L
.52943 .20769 L
.52944 .18037 L
.52945 .19623 L
.52946 .16511 L
.52948 .13353 L
.52949 .19828 L
.52951 .1709 L
.52952 .15575 L
.52954 .19117 L
.52954 .1643 L
.52955 .22517 L
.52957 .18523 L
.52958 .19024 L
.5296 .13956 L
.52961 .14793 L
.52963 .1885 L
.52964 .17148 L
.52966 .18839 L
.52966 .18514 L
.52967 .172 L
.52968 .15083 L
.52969 .17136 L
.5297 .17576 L
.52971 .18028 L
.52972 .20624 L
.52973 .19005 L
.52975 .17487 L
.52976 .13334 L
.52977 .15269 L
.52979 .18813 L
.5298 .18434 L
.52981 .17196 L
.52983 .15865 L
.52984 .21305 L
.52985 .15082 L
Mistroke
.52987 .17865 L
.52988 .17835 L
.52989 .18254 L
.5299 .13565 L
.52991 .19114 L
.52993 .18349 L
.52994 .17035 L
.52995 .19044 L
.52996 .16566 L
.52997 .17725 L
.52999 .19698 L
.53 .13492 L
.53001 .16502 L
.53003 .20165 L
.53004 .17946 L
.53006 .20641 L
.53007 .21084 L
.53007 .21559 L
.53009 .25078 L
.5301 .19692 L
.53011 .20654 L
.53012 .15629 L
.53014 .17597 L
.53015 .15503 L
.53016 .15602 L
.53018 .16554 L
.53019 .20079 L
.5302 .20386 L
.53022 .18287 L
.53023 .1784 L
.53024 .12938 L
.53026 .20109 L
.53027 .22896 L
.53029 .14806 L
.5303 .16783 L
.53031 .18668 L
.53033 .13875 L
.53034 .18532 L
.53036 .16202 L
.53037 .16816 L
.53038 .19953 L
.5304 .18522 L
.53042 .17049 L
.53042 .20225 L
.53043 .21871 L
.53044 .19576 L
.53045 .21971 L
.53046 .23859 L
.53048 .13383 L
.53048 .17139 L
Mistroke
.53049 .15278 L
.53051 .16868 L
.53052 .17488 L
.53054 .17528 L
.53055 .20131 L
.53057 .18264 L
.53058 .2178 L
.53059 .15733 L
.53061 .18238 L
.53062 .1424 L
.53064 .20494 L
.53065 .19585 L
.53066 .21221 L
.53067 .14873 L
.53068 .14978 L
.5307 .18056 L
.53071 .16695 L
.53073 .19528 L
.53074 .20522 L
.53075 .1635 L
.53076 .18441 L
.53077 .18298 L
.53078 .19839 L
.53079 .16339 L
.5308 .14311 L
.53081 .14842 L
.53082 .15627 L
.53083 .18959 L
.53083 .19575 L
.53084 .17263 L
.53086 .16106 L
.53087 .16399 L
.53089 .22804 L
.53089 .1571 L
.5309 .21396 L
.53092 .16959 L
.53093 .15545 L
.53094 .22644 L
.53096 .14791 L
.53097 .17166 L
.53099 .17748 L
.531 .17961 L
.53101 .18777 L
.53102 .2015 L
.53103 .14817 L
.53104 .17736 L
.53105 .18267 L
.53106 .20469 L
.53108 .17914 L
.53109 .20424 L
Mistroke
.53111 .16597 L
.53112 .19056 L
.53113 .19172 L
.53115 .21926 L
.53116 .15559 L
.53117 .13128 L
.53119 .20017 L
.5312 .20565 L
.53121 .1826 L
.53123 .22094 L
.53124 .18145 L
.53126 .16476 L
.53127 .19752 L
.53128 .20364 L
.5313 .15717 L
.53131 .17278 L
.53133 .18391 L
.53134 .15925 L
.53136 .2184 L
.53137 .18526 L
.53137 .18699 L
.53138 .17096 L
.53139 .19741 L
.53141 .14607 L
.53142 .18299 L
.53143 .14341 L
.53145 .19607 L
.53146 .13845 L
.53148 .1904 L
.53149 .17898 L
.5315 .21192 L
.53152 .17346 L
.53153 .18399 L
.53155 .17374 L
.53156 .13376 L
.53158 .17854 L
.53159 .20512 L
.53161 .20727 L
.53162 .18236 L
.53164 .20094 L
.53165 .15215 L
.53165 .18092 L
.53167 .17898 L
.53168 .15149 L
.53168 .19908 L
.53169 .17396 L
.5317 .17103 L
.53172 .19745 L
.53173 .13672 L
.53173 .18028 L
Mistroke
.53174 .1751 L
.53175 .17529 L
.53176 .15266 L
.53177 .17261 L
.53178 .19806 L
.53178 .19276 L
.5318 .14587 L
.53181 .16823 L
.53183 .16814 L
.53184 .16668 L
.53186 .18878 L
.53187 .1984 L
.53188 .18993 L
.5319 .22397 L
.53191 .17403 L
.53192 .16806 L
.53193 .16863 L
.53194 .19752 L
.53196 .18023 L
.53197 .2077 L
.53199 .20983 L
.532 .21842 L
.53201 .15267 L
.53203 .19092 L
.53204 .21325 L
.53205 .19011 L
.53207 .18946 L
.53208 .15722 L
.53208 .18426 L
.5321 .18466 L
.53211 .18834 L
.53213 .19878 L
.53214 .15249 L
.53216 .15371 L
.53217 .20369 L
.53217 .1749 L
.53219 .15546 L
.5322 .21516 L
.53221 .15447 L
.53221 .23049 L
.53222 .18805 L
.53224 .13928 L
.53225 .16733 L
.53227 .16219 L
.53228 .20155 L
.53229 .17246 L
.5323 .22008 L
.53232 .15978 L
.53233 .22031 L
.53234 .20331 L
Mistroke
.53236 .17659 L
.53237 .20539 L
.53238 .19002 L
.53239 .19147 L
.5324 .2128 L
.53242 .20831 L
.53243 .17692 L
.53244 .18383 L
.53246 .21295 L
.53247 .1734 L
.53249 .21178 L
.5325 .17313 L
.53251 .16069 L
.53252 .15889 L
.53253 .17772 L
.53255 .17384 L
.53256 .16531 L
.53258 .17933 L
.53259 .17523 L
.53259 .18518 L
.53261 .18801 L
.53262 .13986 L
.53263 .17768 L
.53263 .19892 L
.53264 .19073 L
.53266 .20293 L
.53267 .16214 L
.53269 .16324 L
.5327 .19226 L
.53272 .18174 L
.53272 .17719 L
.53273 .15562 L
.53275 .18232 L
.53276 .19227 L
.53278 .16749 L
.53279 .25703 L
.53281 .21169 L
.53282 .23515 L
.53284 .18959 L
.53285 .16551 L
.53286 .18374 L
.53288 .19429 L
.53289 .19829 L
.53291 .20945 L
.53292 .17236 L
.53293 .15305 L
.53295 .15743 L
.53296 .18415 L
.53297 .19966 L
.53298 .13746 L
Mistroke
.533 .16048 L
.53301 .20068 L
.53302 .17461 L
.53304 .21907 L
.53305 .19093 L
.53306 .14541 L
.53308 .18418 L
.53309 .18509 L
.5331 .20187 L
.53312 .21601 L
.53313 .19221 L
.53314 .2103 L
.53316 .18957 L
.53317 .17259 L
.53318 .1518 L
.53319 .21103 L
.5332 .19 L
.53322 .16376 L
.53323 .15017 L
.53325 .18817 L
.53326 .14296 L
.53328 .17944 L
.53329 .19792 L
.5333 .20138 L
.53332 .21297 L
.53333 .18524 L
.53334 .17912 L
.53336 .15451 L
.53337 .18258 L
.53339 .14349 L
.5334 .14495 L
.53341 .2447 L
.53342 .16276 L
.53344 .18266 L
.53345 .13177 L
.53346 .19211 L
.53348 .1554 L
.53349 .15921 L
.53351 .14303 L
.53352 .21284 L
.53353 .18888 L
.53354 .18564 L
.53356 .14982 L
.53357 .1977 L
.53358 .18609 L
.5336 .15406 L
.53361 .21924 L
.53363 .18195 L
.53364 .14945 L
.53366 .17051 L
Mistroke
.53367 .19784 L
.53369 .13369 L
.5337 .20371 L
.53371 .15557 L
.53373 .20784 L
.53374 .17423 L
.53375 .19334 L
.53376 .14699 L
.53377 .17388 L
.53379 .20977 L
.5338 .19472 L
.53381 .14648 L
.53383 .15729 L
.53384 .16965 L
.53385 .19122 L
.53387 .1434 L
.53388 .18707 L
.5339 .2034 L
.53391 .1509 L
.53392 .15378 L
.53393 .20123 L
.53394 .13396 L
.53396 .16233 L
.53396 .17007 L
.53397 .19026 L
.53399 .17303 L
.534 .19625 L
.534 .18608 L
.53401 .17106 L
.53402 .19563 L
.53404 .20089 L
.53405 .13663 L
.53405 .17834 L
.53407 .16057 L
.53409 .18036 L
.5341 .13473 L
.53411 .21893 L
.53413 .15953 L
.53414 .15776 L
.53416 .22295 L
.53417 .1609 L
.53418 .15861 L
.53419 .18374 L
.53421 .15076 L
.53422 .13323 L
.53424 .19782 L
.53425 .19408 L
.53426 .1739 L
.53427 .20299 L
.53428 .17134 L
Mistroke
.5343 .21348 L
.53431 .19353 L
.53431 .16934 L
.53432 .18059 L
.53433 .20511 L
.53435 .21205 L
.53436 .21393 L
.53437 .16832 L
.53438 .19577 L
.53439 .17391 L
.5344 .19324 L
.53441 .21097 L
.53443 .18508 L
.53443 .16092 L
.53444 .19984 L
.53446 .21728 L
.53447 .16308 L
.53449 .1904 L
.5345 .14581 L
.53451 .1722 L
.53452 .23236 L
.53453 .17479 L
.53454 .19869 L
.53455 .19974 L
.53456 .17242 L
.53457 .19653 L
.53458 .17166 L
.53459 .2007 L
.53461 .15485 L
.53462 .18679 L
.53463 .15977 L
.53464 .23458 L
.53465 .13815 L
.53467 .13961 L
.53468 .20735 L
.53469 .22227 L
.5347 .18655 L
.53471 .18808 L
.53472 .14538 L
.53474 .1761 L
.53475 .17044 L
.53476 .22178 L
.53477 .1954 L
.53478 .14972 L
.5348 .21642 L
.53481 .18932 L
.53482 .21452 L
.53483 .18366 L
.53485 .2246 L
.53485 .20322 L
Mistroke
.53486 .2041 L
.53487 .16828 L
.53488 .15106 L
.53489 .173 L
.53491 .18265 L
.53492 .19293 L
.53493 .14906 L
.53494 .1559 L
.53496 .19848 L
.53497 .18478 L
.53499 .15584 L
.535 .1649 L
.53501 .17718 L
.53502 .18695 L
.53503 .15023 L
.53505 .20311 L
.53505 .15806 L
.53506 .20877 L
.53507 .17035 L
.53508 .23086 L
.53509 .1756 L
.5351 .21784 L
.53511 .21269 L
.53511 .16024 L
.53512 .18648 L
.53513 .17392 L
.53515 .16696 L
.53516 .2178 L
.53518 .19241 L
.53519 .17613 L
.53519 .17258 L
.5352 .17948 L
.53521 .18066 L
.53523 .15748 L
.53524 .1632 L
.53525 .15037 L
.53527 .19064 L
.53528 .18501 L
.53529 .16834 L
.53531 .15982 L
.53532 .14285 L
.53534 .1866 L
.53535 .14849 L
.53537 .16496 L
.53538 .20971 L
.5354 .19484 L
.53541 .14368 L
.53542 .20726 L
.53544 .2113 L
.53545 .17958 L
Mistroke
.53546 .2068 L
.53547 .13776 L
.53548 .17746 L
.53549 .18091 L
.5355 .15329 L
.53551 .16254 L
.53552 .19209 L
.53553 .17174 L
.53554 .15722 L
.53555 .21295 L
.53555 .15875 L
.53556 .14055 L
.53557 .16898 L
.53558 .1923 L
.53559 .21226 L
.5356 .17559 L
.53562 .20438 L
.53563 .20358 L
.53564 .16114 L
.53566 .25521 L
.53568 .17663 L
.53569 .15801 L
.5357 .19708 L
.53572 .17177 L
.53573 .13613 L
.53574 .16191 L
.53576 .18187 L
.53577 .16054 L
.53579 .16374 L
.5358 .14209 L
.53581 .16951 L
.53582 .20419 L
.53584 .17516 L
.53585 .11886 L
.53586 .13137 L
.53588 .21933 L
.53589 .1851 L
.5359 .1686 L
.53592 .20725 L
.53593 .15369 L
.53594 .17282 L
.53595 .17133 L
.53597 .19537 L
.53598 .16149 L
.536 .18472 L
.53601 .17204 L
.53602 .17328 L
.53603 .1596 L
.53604 .178 L
.53605 .16098 L
Mistroke
.53607 .18955 L
.53608 .15339 L
.5361 .24558 L
.53611 .1654 L
.53613 .1639 L
.53614 .18524 L
.53615 .16811 L
.53617 .17711 L
.53618 .14784 L
.5362 .16848 L
.53621 .14566 L
.53623 .17893 L
.53624 .20334 L
.53626 .24085 L
.53626 .15564 L
.53627 .1454 L
.53629 .1692 L
.5363 .18453 L
.53632 .20173 L
.53633 .20573 L
.53634 .17527 L
.53636 .19555 L
.53637 .21822 L
.53638 .16364 L
.5364 .19773 L
.53641 .2077 L
.53642 .15023 L
.53644 .18826 L
.53645 .1813 L
.53646 .1801 L
.53648 .17009 L
.53649 .20305 L
.53649 .16544 L
.53651 .16909 L
.53652 .14318 L
.53654 .17399 L
.53655 .19073 L
.53657 .21013 L
.53658 .18414 L
.5366 .12841 L
.53661 .21298 L
.53662 .17342 L
.53664 .21183 L
.53665 .1956 L
.53667 .19478 L
.53668 .20756 L
.53669 .17068 L
.53671 .20081 L
.53672 .16696 L
.53673 .14521 L
Mistroke
.53674 .21766 L
.53676 .185 L
.53677 .197 L
.53678 .15048 L
.5368 .18449 L
.53681 .18625 L
.53683 .20947 L
.53684 .19722 L
.53685 .17072 L
.53686 .20437 L
.53688 .19895 L
.53689 .23315 L
.53691 .21497 L
.53692 .17526 L
.53693 .20394 L
.53694 .16679 L
.53695 .18101 L
.53696 .15231 L
.53698 .20635 L
.53699 .17434 L
.53701 .15153 L
.53702 .15599 L
.53704 .15028 L
.53705 .21156 L
.53706 .17331 L
.53708 .19597 L
.53709 .17266 L
.53711 .18335 L
.53712 .18588 L
.53713 .20332 L
.53715 .18261 L
.53717 .20913 L
.53717 .14891 L
.53718 .16343 L
.5372 .21057 L
.53721 .196 L
.53723 .16998 L
.53724 .17511 L
.53725 .18742 L
.53727 .17729 L
.53728 .16714 L
.53729 .16438 L
.53731 .16147 L
.53732 .18729 L
.53733 .16093 L
.53735 .14938 L
.53736 .22036 L
.53737 .14811 L
.53739 .19949 L
.5374 .18992 L
Mistroke
.5374 .16667 L
.53742 .18572 L
.53743 .19408 L
.53745 .18945 L
.53746 .19262 L
.53746 .17561 L
.53748 .18404 L
.53749 .16033 L
.53751 .16412 L
.53752 .16318 L
.53753 .2011 L
.53755 .18757 L
.53756 .20845 L
.53757 .1696 L
.53758 .16938 L
.53759 .20546 L
.5376 .20054 L
.53761 .21819 L
.53762 .19298 L
.53764 .17309 L
.53765 .2026 L
.53767 .16194 L
.53768 .18188 L
.53769 .17997 L
.53771 .1364 L
.53772 .21907 L
.53773 .2059 L
.53775 .16488 L
.53776 .1905 L
.53777 .2486 L
.53779 .19014 L
.5378 .20146 L
.53782 .19221 L
.53783 .19845 L
.53784 .2231 L
.53786 .14926 L
.53787 .16514 L
.53789 .18373 L
.5379 .15874 L
.53792 .19002 L
.53793 .1495 L
.53793 .16666 L
.53794 .17992 L
.53795 .21179 L
.53797 .19996 L
.53797 .15759 L
.53798 .23153 L
.538 .12689 L
.53801 .16681 L
.53803 .19586 L
Mistroke
.53804 .13126 L
.53805 .16536 L
.53807 .18844 L
.53808 .22443 L
.53809 .20321 L
.53811 .17604 L
.53812 .14755 L
.53814 .14739 L
.53815 .20264 L
.53817 .17452 L
.53818 .19094 L
.5382 .17322 L
.53821 .20906 L
.53822 .1839 L
.53823 .18296 L
.53824 .16653 L
.53824 .21738 L
.53826 .18384 L
.53827 .14631 L
.53828 .19203 L
.53829 .18522 L
.53831 .17541 L
.53832 .16998 L
.53832 .1772 L
.53834 .17147 L
.53835 .1469 L
.53836 .21897 L
.53836 .14657 L
.53837 .17532 L
.53839 .15736 L
.5384 .2247 L
.53842 .19461 L
.53843 .16616 L
.53845 .17193 L
.53846 .21513 L
.53847 .1921 L
.53849 .18489 L
.5385 .20411 L
.53852 .20118 L
.53853 .19457 L
.53854 .17039 L
.53856 .18743 L
.53857 .17225 L
.53858 .19622 L
.53859 .19208 L
.53861 .19763 L
.53862 .19987 L
.53863 .16159 L
.53865 .16556 L
.53866 .20138 L
Mistroke
.53868 .18742 L
.53869 .14935 L
.5387 .19351 L
.53871 .1944 L
.53873 .17235 L
.53874 .18105 L
.53876 .17782 L
.53877 .13081 L
.53878 .18247 L
.53879 .14951 L
.5388 .20261 L
.53881 .17943 L
.53883 .14916 L
.53884 .13546 L
.53886 .20486 L
.53887 .17948 L
.53889 .20698 L
.5389 .13087 L
.53891 .18264 L
.53893 .14288 L
.53894 .20924 L
.53896 .21134 L
.53897 .18969 L
.53899 .1754 L
.539 .159 L
.53902 .17368 L
.53903 .18982 L
.53904 .12389 L
.53905 .16477 L
.53906 .23058 L
.53908 .20373 L
.53909 .17103 L
.5391 .19987 L
.53911 .19414 L
.53912 .15275 L
.53914 .1691 L
.53915 .19072 L
.53916 .18178 L
.53918 .17111 L
.53919 .21464 L
.5392 .1966 L
.53922 .18713 L
.53923 .17662 L
.53924 .21272 L
.53926 .18278 L
.53927 .19043 L
.53928 .17369 L
.5393 .18991 L
.53931 .1499 L
.53931 .17549 L
Mistroke
.53933 .14567 L
.53934 .19291 L
.53936 .14744 L
.53937 .19892 L
.53938 .21614 L
.5394 .21207 L
.53941 .16486 L
.53942 .22154 L
.53943 .17613 L
.53944 .17518 L
.53945 .13424 L
.53946 .2212 L
.53947 .21282 L
.53949 .20032 L
.5395 .23133 L
.53952 .15359 L
.53953 .15452 L
.53954 .16525 L
.53956 .16418 L
.53957 .17582 L
.53958 .17701 L
.5396 .20187 L
.53961 .14355 L
.53962 .21188 L
.53964 .15618 L
.53965 .1821 L
.53967 .17049 L
.53968 .19631 L
.53969 .20915 L
.53971 .15734 L
.53972 .18275 L
.53974 .14989 L
.53975 .16101 L
.53977 .2284 L
.53978 .16203 L
.53978 .20519 L
.53979 .18033 L
.5398 .18752 L
.53981 .19371 L
.53983 .20646 L
.53984 .21384 L
.53985 .1633 L
.53986 .19379 L
.53988 .21879 L
.53989 .14392 L
.5399 .18268 L
.53992 .14739 L
.53993 .13275 L
.53994 .21373 L
.53996 .13518 L
Mistroke
.53997 .18092 L
.53999 .16351 L
.54 .20814 L
.54001 .20188 L
.54002 .1643 L
.54003 .20253 L
.54005 .18186 L
.54006 .20401 L
.54008 .18293 L
.54009 .20138 L
.5401 .20033 L
.54011 .18417 L
.54012 .1877 L
.54013 .18567 L
.54014 .23509 L
.54015 .18733 L
.54016 .21463 L
.54017 .17703 L
.54018 .18516 L
.54019 .12502 L
.54019 .22893 L
.54021 .21357 L
.54022 .17994 L
.54024 .22016 L
.54025 .19032 L
.54027 .18707 L
.54028 .16282 L
.5403 .18344 L
.54031 .22124 L
.54032 .18346 L
.54034 .16397 L
.54035 .19095 L
.54037 .17067 L
.54038 .18513 L
.54039 .21711 L
.54041 .14397 L
.54042 .18878 L
.54043 .17373 L
.54044 .18676 L
.54046 .16848 L
.54047 .19813 L
.54048 .20998 L
.5405 .16624 L
.54051 .20163 L
.54053 .21611 L
.54054 .18077 L
.54055 .20607 L
.54056 .20548 L
.54058 .18204 L
.54059 .22937 L
Mistroke
.54061 .16162 L
.54062 .17401 L
.54065 .19653 L
.54066 .19703 L
.54067 .14995 L
.54068 .21554 L
.54069 .2042 L
.54071 .16739 L
.54072 .12546 L
.54074 .19773 L
.54075 .18526 L
.54076 .17848 L
.54077 .19881 L
.54078 .13096 L
.5408 .14501 L
.54081 .21172 L
.54082 .20693 L
.54084 .2 L
.54085 .14739 L
.54086 .20129 L
.54088 .19095 L
.54089 .20891 L
.54091 .18707 L
.54092 .18504 L
.54093 .17379 L
.54094 .18308 L
.54095 .14038 L
.54097 .1749 L
.54098 .13811 L
.54099 .20664 L
.541 .22351 L
.54101 .20114 L
.54102 .13572 L
.54103 .19554 L
.54104 .18657 L
.54105 .18093 L
.54106 .22675 L
.54107 .15298 L
.54108 .14988 L
.5411 .1921 L
.54111 .19476 L
.54113 .18678 L
.54114 .2052 L
.54116 .20827 L
.54117 .18939 L
.54118 .18493 L
.54119 .16027 L
.5412 .18722 L
.5412 .19178 L
.54122 .17744 L
Mistroke
.54123 .1774 L
.54125 .19963 L
.54126 .19431 L
.54128 .20221 L
.54129 .20674 L
.5413 .18047 L
.5413 .18519 L
.54131 .17228 L
.54133 .17778 L
.54134 .12636 L
.54136 .18412 L
.54137 .20407 L
.54138 .17339 L
.54139 .15871 L
.5414 .17621 L
.5414 .20435 L
.54141 .17694 L
.54142 .18185 L
.54143 .20054 L
.54144 .17825 L
.54146 .22304 L
.54147 .21832 L
.54149 .16856 L
.5415 .18157 L
.5415 .17791 L
.54151 .192 L
.54152 .1195 L
.54153 .18374 L
.54154 .15389 L
.54155 .15904 L
.54157 .15381 L
.54158 .1584 L
.54159 .21715 L
.54161 .18621 L
.54162 .16235 L
.54162 .15886 L
.54164 .19632 L
.54165 .16233 L
.54167 .17972 L
.54168 .20416 L
.54168 .20971 L
.5417 .17534 L
.54171 .21107 L
.54173 .19456 L
.54174 .14432 L
.54175 .19973 L
.54177 .1247 L
.54178 .17864 L
.54179 .18031 L
.5418 .19362 L
Mistroke
.54182 .17266 L
.54182 .22034 L
.54183 .18931 L
.54185 .16662 L
.54186 .20805 L
.54188 .17897 L
.54189 .17512 L
.5419 .19008 L
.54192 .1649 L
.54193 .17909 L
.54194 .21642 L
.54196 .1976 L
.54197 .21026 L
.54198 .19094 L
.542 .16716 L
.54201 .17237 L
.54202 .18304 L
.54204 .18308 L
.54205 .17154 L
.54207 .16806 L
.54208 .18907 L
.5421 .14589 L
.54211 .18763 L
.54212 .23655 L
.54213 .18408 L
.54214 .22113 L
.54216 .19436 L
.54217 .19791 L
.54217 .19257 L
.54219 .20827 L
.5422 .18186 L
.54221 .20374 L
.54222 .18386 L
.54223 .18642 L
.54225 .17325 L
.54226 .24237 L
.54228 .17107 L
.54229 .17952 L
.54231 .14393 L
.54232 .18989 L
.54233 .19773 L
.54235 .13848 L
.54236 .1871 L
.54238 .22895 L
.54238 .1801 L
.54239 .14437 L
.54241 .20307 L
.54242 .19514 L
.54244 .22858 L
.54245 .17992 L
Mistroke
.54247 .17703 L
.54248 .20601 L
.54248 .17275 L
.5425 .16578 L
.54251 .20061 L
.54252 .14387 L
.54253 .24079 L
.54253 .20217 L
.54254 .19381 L
.54255 .13194 L
.54256 .1876 L
.54257 .19474 L
.54258 .22446 L
.5426 .18406 L
.54261 .17123 L
.54262 .16952 L
.54263 .21508 L
.54264 .17217 L
.54266 .19972 L
.54267 .19195 L
.54268 .13697 L
.5427 .17592 L
.54271 .22108 L
.54273 .16897 L
.54274 .18722 L
.54274 .18129 L
.54276 .14005 L
.54277 .21573 L
.54278 .19548 L
.54279 .22129 L
.54281 .16479 L
.54282 .1683 L
.54283 .25034 L
.54285 .15167 L
.54286 .20734 L
.54287 .19721 L
.54289 .22636 L
.5429 .21951 L
.54291 .16307 L
.54293 .19627 L
.54294 .15968 L
.54296 .19413 L
.54297 .21017 L
.54298 .19403 L
.543 .19123 L
.54301 .18937 L
.54303 .19046 L
.54304 .19756 L
.54305 .17126 L
.54307 .18585 L
Mistroke
.54308 .16993 L
.54309 .15879 L
.5431 .1899 L
.54311 .16838 L
.54312 .20424 L
.54313 .19191 L
.54315 .12707 L
.54316 .17925 L
.54318 .20129 L
.54319 .18733 L
.54321 .1711 L
.54322 .24569 L
.54323 .16671 L
.54325 .18437 L
.54326 .20646 L
.54328 .16948 L
.54329 .18435 L
.5433 .19799 L
.54332 .21331 L
.54333 .17758 L
.54335 .19192 L
.54336 .1683 L
.54337 .21222 L
.54338 .17528 L
.5434 .17914 L
.5434 .19091 L
.54341 .13015 L
.54342 .21925 L
.54343 .17855 L
.54344 .18336 L
.54345 .16138 L
.54346 .17993 L
.54347 .20084 L
.54348 .14997 L
.54349 .17108 L
.5435 .19011 L
.5435 .19989 L
.54351 .15423 L
.54353 .17471 L
.54354 .18407 L
.54356 .16871 L
.54357 .15975 L
.54359 .17368 L
.5436 .22582 L
.54361 .20684 L
.54363 .20951 L
.54364 .1655 L
.54365 .22367 L
.54367 .18096 L
.54368 .192 L
Mistroke
.5437 .16384 L
.54371 .15055 L
.54373 .21129 L
.54374 .15318 L
.54375 .19542 L
.54376 .15223 L
.54378 .18618 L
.54379 .19017 L
.5438 .15493 L
.54382 .1794 L
.54383 .19654 L
.54384 .16428 L
.54385 .16421 L
.54387 .17509 L
.54388 .18102 L
.54389 .14627 L
.54391 .20124 L
.54392 .17115 L
.54394 .15312 L
.54395 .15598 L
.54396 .19231 L
.54397 .24911 L
.54398 .20536 L
.544 .18746 L
.54401 .19334 L
.54402 .19018 L
.54403 .15917 L
.54404 .1758 L
.54405 .20868 L
.54407 .17042 L
.54408 .22587 L
.54409 .17798 L
.54411 .16512 L
.54412 .16667 L
.54413 .22139 L
.54414 .18865 L
.54416 .15193 L
.54416 .19169 L
.54417 .19725 L
.54419 .17733 L
.5442 .14545 L
.54422 .1534 L
.54423 .18615 L
.54424 .1636 L
.54426 .18371 L
.54427 .15013 L
.54428 .20643 L
.5443 .1871 L
.54431 .16654 L
.54432 .17457 L
Mistroke
.54434 .17305 L
.54435 .19049 L
.54437 .16965 L
.54438 .20481 L
.54439 .1839 L
.54441 .17236 L
.54442 .17184 L
.54444 .15444 L
.54445 .18003 L
.54447 .20364 L
.54448 .13769 L
.54449 .20076 L
.5445 .15453 L
.54451 .1761 L
.54451 .19002 L
.54453 .22718 L
.54454 .19455 L
.54456 .16108 L
.54457 .16654 L
.54459 .19428 L
.5446 .23139 L
.54461 .20941 L
.54463 .18732 L
.54464 .13348 L
.54466 .16974 L
.54467 .18574 L
.54469 .20192 L
.5447 .15854 L
.54471 .22437 L
.54472 .22138 L
.54475 .20854 L
.54481 .18442 L
.54482 .1701 L
.54483 .21005 L
.54484 .174 L
.54485 .18496 L
.54486 .20391 L
.54486 .19067 L
.54487 .19413 L
.54488 .19002 L
.54489 .21979 L
.5449 .20337 L
.54491 .14334 L
.54492 .15373 L
.54494 .15406 L
.54495 .17941 L
.54496 .16411 L
.54497 .2178 L
.54498 .1576 L
.54498 .16043 L
Mistroke
.545 .12765 L
.54501 .1736 L
.54503 .18521 L
.54505 .14456 L
.54506 .17848 L
.54507 .21858 L
.54508 .16424 L
.54508 .21018 L
.54509 .1926 L
.54511 .18268 L
.54512 .22076 L
.54513 .208 L
.54514 .18809 L
.54516 .24826 L
.54517 .15501 L
.54517 .18984 L
.54518 .20088 L
.54519 .16929 L
.54521 .15833 L
.54522 .18581 L
.54524 .17561 L
.54524 .18531 L
.54525 .17105 L
.54527 .1826 L
.54528 .23292 L
.54528 .14648 L
.54529 .20408 L
.5453 .18756 L
.54531 .18639 L
.54532 .17643 L
.54533 .19503 L
.54535 .1834 L
.54536 .21049 L
.54537 .13645 L
.54539 .21239 L
.5454 .23252 L
.5454 .18179 L
.54542 .18194 L
.54543 .21337 L
.54545 .20267 L
.54546 .20063 L
.54546 .15528 L
.54548 .18004 L
.54549 .19055 L
.54551 .18717 L
.54552 .16829 L
.54553 .14839 L
.54555 .20145 L
.54556 .16985 L
.54557 .15242 L
Mistroke
.54558 .15612 L
.5456 .19511 L
.5456 .19377 L
.54561 .20395 L
.54563 .1695 L
.54564 .17842 L
.54566 .13304 L
.54567 .17785 L
.54568 .18254 L
.5457 .21545 L
.54571 .16991 L
.54572 .20803 L
.54574 .20233 L
.54575 .177 L
.54577 .17196 L
.54578 .19399 L
.54579 .20054 L
.54581 .18039 L
.54582 .17499 L
.54583 .16963 L
.54585 .18233 L
.54586 .14302 L
.54588 .20141 L
.54589 .20099 L
.5459 .19222 L
.54591 .14864 L
.54592 .17441 L
.54593 .18002 L
.54594 .2317 L
.54595 .18603 L
.54596 .17493 L
.54596 .16357 L
.54597 .19075 L
.54599 .18339 L
.546 .15067 L
.54602 .19471 L
.54603 .17668 L
.54604 .17754 L
.54606 .20686 L
.54607 .18993 L
.54609 .18451 L
.5461 .20695 L
.54612 .18003 L
.54613 .19027 L
.54614 .16487 L
.54615 .21983 L
.54615 .21391 L
.54616 .21058 L
.54618 .23894 L
.54619 .17126 L
Mistroke
.5462 .17247 L
.54621 .20862 L
.54622 .20984 L
.54623 .2168 L
.54624 .17726 L
.54625 .19882 L
.54626 .17202 L
.54627 .17461 L
.54628 .16463 L
.54629 .15797 L
.54631 .17537 L
.54632 .2145 L
.54632 .20578 L
.54634 .19322 L
.54635 .17154 L
.54637 .17562 L
.54638 .16412 L
.5464 .16168 L
.5464 .18078 L
.54641 .14917 L
.54643 .18237 L
.54644 .18973 L
.54645 .24106 L
.54646 .14753 L
.54647 .13866 L
.54648 .19039 L
.54649 .21825 L
.5465 .16121 L
.54651 .13522 L
.54652 .20613 L
.54653 .1895 L
.54654 .22229 L
.54655 .19809 L
.54657 .20966 L
.54658 .17621 L
.5466 .15341 L
.54661 .1645 L
.54663 .2128 L
.54664 .19074 L
.54666 .17017 L
.54667 .14987 L
.54668 .19432 L
.54669 .15071 L
.5467 .16686 L
.54672 .17628 L
.54673 .16275 L
.54674 .17548 L
.54676 .2061 L
.54677 .16857 L
.54678 .204 L
Mistroke
.5468 .17622 L
.54681 .20383 L
.54682 .21405 L
.54684 .18341 L
.54685 .1802 L
.54687 .16246 L
.54688 .22227 L
.54689 .17586 L
.54691 .21562 L
.54692 .15542 L
.54694 .19185 L
.54695 .20057 L
.54696 .17613 L
.54698 .19511 L
.54699 .18854 L
.54699 .16631 L
.54701 .1554 L
.54702 .17301 L
.54703 .18189 L
.54704 .20426 L
.54706 .17985 L
.54706 .15988 L
.54707 .16897 L
.54708 .15497 L
.54709 .22443 L
.54711 .22061 L
.54712 .17739 L
.54713 .20772 L
.54714 .1482 L
.54714 .15713 L
.54715 .21425 L
.54716 .18338 L
.54717 .23079 L
.54719 .17375 L
.5472 .24174 L
.5472 .18884 L
.54721 .20916 L
.54722 .22872 L
.54724 .20882 L
.54725 .1839 L
.54726 .1691 L
.54727 .18917 L
.54728 .22613 L
.5473 .16699 L
.54731 .14602 L
.54733 .19884 L
.54734 .19612 L
.54736 .17057 L
.54737 .24158 L
.54738 .18081 L
Mistroke
.5474 .17912 L
.54741 .17543 L
.54743 .20206 L
.54744 .18244 L
.54746 .1774 L
.54747 .21991 L
.54748 .17378 L
.54749 .17909 L
.5475 .16843 L
.54751 .20547 L
.54752 .15055 L
.54753 .21508 L
.54754 .21245 L
.54755 .16071 L
.54757 .16323 L
.54758 .20626 L
.54759 .18163 L
.5476 .17714 L
.54761 .18592 L
.54763 .16521 L
.54763 .24005 L
.54764 .17387 L
.54766 .22982 L
.54767 .1785 L
.54769 .17355 L
.5477 .15247 L
.54771 .18752 L
.54772 .17192 L
.54773 .22776 L
.54773 .18328 L
.54775 .20154 L
.54776 .17543 L
.54778 .16428 L
.54779 .14776 L
.5478 .13576 L
.54781 .14184 L
.54781 .20588 L
.54782 .2136 L
.54783 .16102 L
.54784 .13821 L
.54785 .19127 L
.54786 .15459 L
.54788 .15985 L
.54789 .16599 L
.5479 .16793 L
.54791 .21925 L
.54792 .22342 L
.54793 .1978 L
.54794 .17158 L
.54796 .1864 L
Mistroke
.54797 .1647 L
.54798 .17918 L
.548 .16624 L
.54801 .20757 L
.54803 .17553 L
.54804 .16873 L
.54806 .16256 L
.54807 .15506 L
.54808 .16401 L
.5481 .17273 L
.54811 .17213 L
.54813 .23612 L
.54813 .17988 L
.54814 .17885 L
.54816 .16837 L
.54817 .17938 L
.54818 .24981 L
.54819 .17591 L
.5482 .16432 L
.54821 .14679 L
.54822 .15312 L
.54824 .1563 L
.54825 .20638 L
.54826 .16478 L
.54827 .18648 L
.54829 .18845 L
.54829 .17686 L
.5483 .14925 L
.54831 .20835 L
.54832 .16524 L
.54833 .22285 L
.54834 .18536 L
.54835 .16913 L
.54836 .18224 L
.54838 .20496 L
.54839 .14905 L
.54841 .17207 L
.54842 .1775 L
.54843 .16295 L
.54845 .20651 L
.54846 .15514 L
.54846 .16382 L
.54848 .22315 L
.54849 .16263 L
.5485 .17691 L
.54851 .17271 L
.54853 .20019 L
.54854 .2021 L
.54856 .15773 L
.54857 .20141 L
Mistroke
.54858 .17335 L
.5486 .20585 L
.54861 .15693 L
.54862 .2056 L
.54864 .21165 L
.54865 .20155 L
.54866 .20752 L
.54868 .19388 L
.54869 .15868 L
.5487 .14953 L
.54872 .18496 L
.54873 .19111 L
.54875 .1723 L
.54876 .20767 L
.54878 .15929 L
.54879 .17342 L
.54881 .19834 L
.54881 .15212 L
.54882 .16215 L
.54883 .17967 L
.54884 .1848 L
.54885 .16953 L
.54886 .20842 L
.54887 .19978 L
.54888 .13537 L
.5489 .17679 L
.54891 .15269 L
.54893 .1656 L
.54894 .17354 L
.54895 .20731 L
.54897 .21266 L
.54898 .22145 L
.549 .1846 L
.54901 .2005 L
.54903 .21908 L
.54904 .19175 L
.54905 .15631 L
.54906 .19393 L
.54907 .17767 L
.54909 .15516 L
.5491 .14607 L
.54912 .14114 L
.54913 .18653 L
.54914 .23646 L
.54915 .18767 L
.54916 .18902 L
.54917 .17423 L
.54918 .22084 L
.54919 .22551 L
.5492 .1733 L
Mistroke
.54921 .15374 L
.54922 .17634 L
.54922 .2292 L
.54923 .19428 L
.54925 .16782 L
.54926 .16945 L
.54928 .18428 L
.54929 .15851 L
.54931 .17357 L
.54932 .18301 L
.54934 .19728 L
.54935 .1697 L
.54936 .17676 L
.54938 .16024 L
.54938 .18093 L
.54939 .20166 L
.5494 .13175 L
.54941 .2117 L
.54942 .19198 L
.54944 .16973 L
.54946 .19442 L
.54947 .22735 L
.54948 .18416 L
.5495 .20272 L
.54951 .17553 L
.54952 .17393 L
.54954 .17164 L
.54955 .17128 L
.54957 .16383 L
.54958 .14836 L
.5496 .19086 L
.5496 .16631 L
.54961 .18492 L
.54963 .16115 L
.54964 .19769 L
.54965 .1542 L
.54966 .21031 L
.54968 .14971 L
.54969 .20476 L
.5497 .21584 L
.54972 .20032 L
.54973 .11971 L
.54975 .21332 L
.54976 .1861 L
.54977 .15883 L
.54978 .20704 L
.5498 .22202 L
.5498 .21088 L
.54981 .1961 L
.54982 .18448 L
Mistroke
.54984 .16174 L
.54985 .16507 L
.54987 .21178 L
.54988 .19826 L
.54989 .1713 L
.54991 .21995 L
.54992 .24241 L
.54994 .20892 L
.54995 .20918 L
.54997 .17511 L
.54998 .1499 L
.55 .20526 L
.55001 .1587 L
.55003 .18348 L
.55003 .23984 L
.55004 .1661 L
.55006 .21923 L
.55007 .20134 L
.55007 .19488 L
.55009 .20215 L
.5501 .20381 L
.55011 .16988 L
.55011 .21567 L
.55012 .16238 L
.55013 .18434 L
.55014 .22308 L
.55015 .18019 L
.55016 .16722 L
.55016 .17553 L
.55017 .1782 L
.55019 .18032 L
.5502 .16202 L
.55022 .1622 L
.55023 .16281 L
.55025 .22947 L
.55026 .18806 L
.55027 .19676 L
.55029 .2166 L
.5503 .17533 L
.55032 .20819 L
.55033 .16696 L
.55035 .18435 L
.55036 .15069 L
.55037 .20078 L
.55039 .17617 L
.5504 .17492 L
.55041 .16487 L
.55042 .15201 L
.55044 .21712 L
.55045 .21725 L
Mistroke
.55046 .17974 L
.55048 .22582 L
.55049 .17548 L
.5505 .19392 L
.55052 .2517 L
.55053 .17565 L
.55054 .18729 L
.55056 .20019 L
.55057 .18512 L
.55058 .14706 L
.5506 .20736 L
.55061 .17168 L
.55062 .19206 L
.55063 .18869 L
.55064 .18257 L
.55066 .13039 L
.55067 .21342 L
.55069 .241 L
.5507 .21047 L
.55071 .2317 L
.55073 .21442 L
.55074 .21117 L
.55076 .16405 L
.55077 .1905 L
.55078 .21013 L
.5508 .22603 L
.55081 .19599 L
.55083 .17838 L
.55084 .21564 L
.55085 .20974 L
.55086 .19629 L
.55087 .16589 L
.55089 .14707 L
.5509 .15519 L
.55092 .19552 L
.55093 .21632 L
.55094 .19169 L
.55096 .23288 L
.55097 .16355 L
.55099 .20734 L
.551 .18148 L
.55102 .18705 L
.55103 .20612 L
.55104 .17705 L
.55105 .183 L
.55107 .19409 L
.55108 .23376 L
.5511 .17306 L
.55111 .20669 L
.55112 .15053 L
Mistroke
.55114 .18101 L
.55115 .14996 L
.55116 .18839 L
.55117 .19309 L
.55118 .17696 L
.5512 .20347 L
.55121 .18816 L
.55121 .20761 L
.55123 .1702 L
.55124 .22423 L
.55126 .17567 L
.55127 .19521 L
.55129 .16596 L
.5513 .1924 L
.55131 .17898 L
.55133 .17118 L
.55134 .19715 L
.55135 .15456 L
.55137 .1702 L
.55139 .23794 L
.55139 .21182 L
.5514 .20099 L
.55142 .13195 L
.55143 .17853 L
.55145 .22696 L
.55146 .19337 L
.55147 .21431 L
.55148 .19082 L
.55149 .21585 L
.5515 .18838 L
.55151 .22051 L
.55152 .15429 L
.55153 .1862 L
.55154 .19368 L
.55156 .17816 L
.55157 .18536 L
.55158 .16526 L
.55159 .17313 L
.5516 .17161 L
.55162 .14608 L
.55163 .19756 L
.55165 .18181 L
.55166 .15191 L
.55167 .20369 L
.55168 .19757 L
.55169 .19967 L
.55171 .19644 L
.55172 .16592 L
.55174 .24389 L
.55175 .17243 L
Mistroke
.55176 .20394 L
.55178 .21597 L
.55179 .17235 L
.5518 .17491 L
.55182 .20003 L
.55183 .17734 L
.55184 .17875 L
.55185 .18864 L
.55187 .17178 L
.55188 .14922 L
.55189 .1629 L
.5519 .20442 L
.55191 .19338 L
.55192 .20864 L
.55193 .15525 L
.55194 .18639 L
.55195 .17179 L
.55196 .17582 L
.55198 .20919 L
.55199 .16573 L
.55201 .19935 L
.55202 .18953 L
.55203 .20516 L
.55204 .17122 L
.55205 .21145 L
.55207 .20989 L
.55208 .18581 L
.5521 .17375 L
.55211 .23159 L
.55213 .14259 L
.55214 .17126 L
.55215 .21231 L
.55217 .19144 L
.55218 .20419 L
.5522 .16035 L
.55221 .14938 L
.55222 .23222 L
.55224 .20143 L
.55225 .21216 L
.55226 .19858 L
.55227 .13744 L
.55229 .19102 L
.5523 .23142 L
.55232 .15442 L
.55233 .1696 L
.55234 .22345 L
.55236 .16249 L
.55237 .19158 L
.55238 .21659 L
.55239 .15358 L
Mistroke
.55241 .19118 L
.55242 .154 L
.55244 .16983 L
.55245 .19147 L
.55246 .16366 L
.55248 .18737 L
.55248 .22498 L
.55249 .11535 L
.55251 .19917 L
.55252 .21151 L
.55254 .16876 L
.55255 .15069 L
.55257 .20288 L
.55258 .18912 L
.55259 .20981 L
.55261 .17954 L
.55262 .17548 L
.55263 .20511 L
.55265 .16215 L
.55266 .18405 L
.55268 .19997 L
.55269 .16752 L
.55271 .17587 L
.55272 .21318 L
.55273 .1771 L
.55274 .20215 L
.55276 .16462 L
.55277 .16751 L
.55278 .20222 L
.5528 .14743 L
.55281 .21603 L
.55282 .2096 L
.55283 .18517 L
.55285 .21202 L
.55286 .1993 L
.55287 .20035 L
.55289 .20926 L
.5529 .16559 L
.55292 .20399 L
.55293 .17095 L
.55294 .22769 L
.55295 .17954 L
.55296 .21685 L
.55298 .18843 L
.55299 .17429 L
.55301 .21356 L
.55302 .1766 L
.55303 .17962 L
.55305 .22092 L
.55306 .21934 L
Mistroke
.55307 .18707 L
.55309 .23893 L
.5531 .19413 L
.55312 .16842 L
.55313 .16794 L
.55315 .18636 L
.55316 .21789 L
.55317 .1878 L
.55318 .19497 L
.5532 .21497 L
.55321 .15121 L
.55322 .183 L
.55324 .19092 L
.55325 .21561 L
.55326 .15912 L
.55328 .18484 L
.55329 .21193 L
.5533 .23205 L
.55332 .21221 L
.55333 .18648 L
.55334 .18801 L
.55336 .1986 L
.55337 .23358 L
.55338 .22232 L
.55339 .15157 L
.5534 .21147 L
.55342 .21326 L
.55343 .17717 L
.55344 .19445 L
.55346 .19995 L
.55348 .22254 L
.55349 .18799 L
.5535 .18015 L
.55352 .17321 L
.55353 .17795 L
.55354 .14495 L
.55356 .21643 L
.55357 .22482 L
.55359 .14974 L
.5536 .21003 L
.55362 .18829 L
.55363 .17748 L
.55363 .18523 L
.55365 .17535 L
.55367 .20218 L
.55368 .20492 L
.55369 .2068 L
.55371 .17297 L
.55372 .17616 L
.55377 .18628 L
Mistroke
.55383 .19779 L
.55384 .17023 L
.55386 .21207 L
.55387 .1804 L
.55389 .2124 L
.5539 .17865 L
.55391 .20497 L
.55393 .18182 L
.55394 .21083 L
.55395 .16247 L
.55396 .22273 L
.55398 .19371 L
.55398 .18122 L
.55399 .169 L
.554 .2075 L
.55401 .2084 L
.55403 .20612 L
.55404 .18929 L
.55405 .23641 L
.55406 .17034 L
.55407 .21574 L
.55409 .17686 L
.5541 .17145 L
.55411 .14639 L
.55413 .17712 L
.55414 .1925 L
.55416 .18006 L
.55417 .20415 L
.55418 .21051 L
.5542 .19525 L
.55421 .17625 L
.55421 .15633 L
.55423 .1639 L
.55424 .16292 L
.55426 .19801 L
.55427 .20597 L
.55428 .15586 L
.5543 .19794 L
.55431 .18362 L
.55432 .18552 L
.55434 .16481 L
.55435 .14982 L
.55437 .1693 L
.55438 .20246 L
.55439 .17301 L
.55441 .18421 L
.55442 .13388 L
.55443 .18059 L
.55444 .19113 L
.55446 .17304 L
Mistroke
.55447 .16403 L
.55448 .20254 L
.5545 .24531 L
.55451 .1568 L
.55453 .20597 L
.55454 .20801 L
.55455 .21565 L
.55457 .1463 L
.55458 .20628 L
.55459 .16168 L
.5546 .19176 L
.55461 .15242 L
.55462 .19199 L
.55463 .18448 L
.55464 .1827 L
.55465 .21522 L
.55466 .21399 L
.55468 .22056 L
.55469 .23492 L
.5547 .20088 L
.5547 .20236 L
.55471 .13119 L
.55473 .17498 L
.55474 .17543 L
.55476 .17496 L
.55477 .18859 L
.55479 .16758 L
.5548 .15906 L
.55482 .20202 L
.55482 .16486 L
.55483 .22339 L
.55485 .20065 L
.55486 .15395 L
.55487 .20131 L
.55488 .1587 L
.55489 .20681 L
.5549 .23914 L
.55491 .18984 L
.55492 .14313 L
.55493 .16894 L
.55494 .14637 L
.55496 .19239 L
.55497 .21054 L
.55498 .2129 L
.555 .18984 L
.55501 .17076 L
.55503 .1764 L
.55504 .21199 L
.55505 .21659 L
.55507 .1766 L
Mistroke
.55508 .20242 L
.5551 .19805 L
.55511 .204 L
.55511 .21346 L
.55513 .17902 L
.55514 .17385 L
.55516 .18102 L
.55517 .16155 L
.55519 .18257 L
.5552 .20927 L
.5552 .17879 L
.55522 .14095 L
.55523 .19441 L
.55524 .20336 L
.55525 .18318 L
.55526 .19562 L
.55526 .16893 L
.55527 .25417 L
.55528 .21336 L
.55529 .14301 L
.5553 .16902 L
.55532 .18012 L
.55533 .13713 L
.55535 .17866 L
.55536 .18413 L
.55538 .16102 L
.55539 .20909 L
.5554 .17582 L
.55542 .19145 L
.55543 .19226 L
.55545 .16372 L
.55546 .19635 L
.55548 .20527 L
.55549 .20846 L
.55551 .18644 L
.55552 .17869 L
.55552 .1966 L
.55554 .17296 L
.55555 .17162 L
.55557 .15349 L
.55558 .23316 L
.5556 .20653 L
.55561 .20789 L
.55562 .19421 L
.55563 .19915 L
.55565 .21637 L
.55566 .14995 L
.55567 .21142 L
.55569 .18596 L
.5557 .2154 L
Mistroke
.55571 .17154 L
.55573 .22672 L
.55574 .18601 L
.55575 .17794 L
.55576 .19221 L
.55577 .16244 L
.55579 .21688 L
.5558 .17499 L
.5558 .16126 L
.55582 .15019 L
.55583 .21165 L
.55585 .18249 L
.55586 .19361 L
.55587 .17978 L
.55589 .17 L
.5559 .23969 L
.55591 .15935 L
.55592 .17565 L
.55593 .14389 L
.55594 .24359 L
.55595 .18367 L
.55597 .18699 L
.55598 .18425 L
.556 .219 L
.55601 .2113 L
.55602 .18602 L
.55604 .17977 L
.55605 .19465 L
.55606 .17829 L
.55608 .19649 L
.55609 .17595 L
.5561 .19573 L
.55612 .16328 L
.55613 .13655 L
.55614 .16363 L
.55616 .17586 L
.55617 .19899 L
.55619 .18066 L
.5562 .13505 L
.55621 .22949 L
.55623 .1748 L
.55625 .18769 L
.55626 .17926 L
.55627 .21884 L
.55628 .1666 L
.55628 .20487 L
.55629 .20011 L
.55631 .18248 L
.55632 .20517 L
.55632 .17109 L
Mistroke
.55634 .18755 L
.55635 .17105 L
.55637 .1661 L
.55638 .19118 L
.55639 .1907 L
.55641 .1601 L
.55642 .18924 L
.55643 .17597 L
.55645 .20352 L
.55646 .15833 L
.55648 .17735 L
.55649 .17488 L
.5565 .16978 L
.55651 .19879 L
.55653 .1855 L
.55654 .18328 L
.55655 .19677 L
.55657 .17769 L
.55658 .14743 L
.55659 .22572 L
.5566 .20082 L
.55662 .18919 L
.55663 .17184 L
.55663 .21005 L
.55664 .19466 L
.55665 .19067 L
.55666 .21124 L
.55667 .21486 L
.55668 .27446 L
.55669 .15749 L
.5567 .19215 L
.55672 .13976 L
.55673 .20187 L
.55675 .16652 L
.55676 .17914 L
.55677 .19065 L
.55679 .19717 L
.5568 .15438 L
.55682 .20459 L
.55683 .19376 L
.55684 .15132 L
.55686 .15131 L
.55687 .18077 L
.55689 .16466 L
.5569 .18226 L
.55691 .22984 L
.55692 .18961 L
.55694 .16971 L
.55695 .18051 L
.55696 .18093 L
Mistroke
.55698 .19064 L
.55699 .21035 L
.557 .2232 L
.55702 .21014 L
.55703 .17352 L
.55704 .20285 L
.55706 .1919 L
.55707 .183 L
.55708 .21635 L
.5571 .18666 L
.55711 .21024 L
.55712 .16068 L
.55713 .21543 L
.55714 .20422 L
.55715 .13915 L
.55717 .14492 L
.55718 .19055 L
.5572 .18489 L
.55721 .18865 L
.55723 .25456 L
.55724 .19504 L
.55726 .20605 L
.55726 .19257 L
.55727 .19866 L
.55729 .18714 L
.5573 .226 L
.55731 .16752 L
.55733 .23186 L
.55734 .19939 L
.55736 .16618 L
.55737 .16134 L
.55738 .18862 L
.5574 .18857 L
.55741 .20236 L
.55743 .14953 L
.55743 .17071 L
.55744 .18324 L
.55746 .17304 L
.55747 .22695 L
.55749 .2043 L
.5575 .20924 L
.55751 .17848 L
.55752 .20341 L
.55753 .2161 L
.55755 .20374 L
.55756 .18376 L
.55756 .1997 L
.55757 .14962 L
.55758 .17626 L
.5576 .23223 L
Mistroke
.55761 .20318 L
.55763 .20706 L
.55764 .11886 L
.55764 .20452 L
.55766 .1543 L
.55767 .22832 L
.55768 .19214 L
.5577 .14803 L
.55772 .20211 L
.55772 .13899 L
.55773 .17404 L
.55775 .21315 L
.55776 .19117 L
.55778 .19397 L
.55779 .17964 L
.5578 .17635 L
.55782 .1725 L
.55783 .20942 L
.55784 .1845 L
.55786 .20826 L
.55787 .19103 L
.55788 .16439 L
.55789 .19903 L
.5579 .20737 L
.55792 .17022 L
.55793 .16478 L
.55794 .20338 L
.55795 .18285 L
.55797 .16069 L
.55797 .22312 L
.55798 .18966 L
.55799 .22384 L
.558 .19001 L
.55802 .22081 L
.55803 .20979 L
.55804 .13711 L
.55806 .18858 L
.55807 .17576 L
.55808 .21895 L
.55808 .1701 L
.55809 .17654 L
.55811 .19027 L
.55812 .20691 L
.55814 .15173 L
.55815 .21175 L
.55816 .22282 L
.55818 .19063 L
.55819 .20971 L
.55821 .12647 L
.55822 .17093 L
Mistroke
.55823 .18509 L
.55825 .14609 L
.55826 .21753 L
.55828 .19132 L
.55829 .20295 L
.5583 .1809 L
.55831 .23038 L
.55833 .18194 L
.55834 .19899 L
.55836 .20057 L
.55837 .1879 L
.55838 .16341 L
.5584 .21327 L
.55841 .18891 L
.55843 .11747 L
.55844 .18696 L
.55845 .13881 L
.55847 .19436 L
.55848 .18364 L
.5585 .19933 L
.55851 .17148 L
.55852 .20174 L
.55854 .22479 L
.55855 .15247 L
.55856 .20642 L
.55857 .18101 L
.55859 .18619 L
.5586 .19694 L
.55862 .16964 L
.55863 .21669 L
.55865 .16462 L
.55866 .18028 L
.55868 .20761 L
.55869 .16357 L
.5587 .19312 L
.55872 .18261 L
.55873 .21945 L
.55875 .16959 L
.55876 .20411 L
.55877 .23429 L
.55878 .2026 L
.55879 .2056 L
.55881 .16948 L
.55882 .22217 L
.55884 .17423 L
.55885 .17118 L
.55886 .23311 L
.55888 .20536 L
.55889 .17363 L
.5589 .14967 L
Mistroke
.55891 .20026 L
.55893 .19703 L
.55894 .22763 L
.55896 .20148 L
.55897 .17764 L
.55898 .17021 L
.55899 .20258 L
.559 .17358 L
.55901 .20076 L
.55903 .2065 L
.55904 .20285 L
.55906 .17071 L
.55907 .21095 L
.55909 .20958 L
.5591 .17658 L
.55911 .17036 L
.55913 .16761 L
.55914 .20938 L
.55916 .16905 L
.55917 .16451 L
.55919 .1748 L
.5592 .21402 L
.55922 .20282 L
.55923 .21125 L
.55923 .20839 L
.55925 .17251 L
.55926 .22286 L
.55928 .20779 L
.55929 .20176 L
.5593 .15851 L
.55932 .18105 L
.55933 .208 L
.55934 .21445 L
.55936 .20614 L
.55937 .14497 L
.55938 .18143 L
.5594 .23525 L
.55941 .17928 L
.55942 .17379 L
.55944 .17915 L
.55945 .20241 L
.55945 .20096 L
.55947 .20335 L
.55948 .18101 L
.5595 .17626 L
.55951 .19124 L
.55951 .20643 L
.55953 .16254 L
.55954 .18258 L
.55956 .21751 L
Mistroke
.55957 .18716 L
.55958 .19709 L
.5596 .1949 L
.55961 .19458 L
.55963 .22625 L
.55964 .21266 L
.55966 .17807 L
.55967 .17717 L
.55969 .20205 L
.5597 .21056 L
.55971 .23316 L
.55972 .17987 L
.55973 .21819 L
.55975 .16552 L
.55976 .1643 L
.55977 .18523 L
.55979 .16247 L
.55981 .15805 L
.55982 .15117 L
.55983 .17911 L
.55985 .23317 L
.55986 .20652 L
.55987 .2278 L
.55989 .21861 L
.5599 .22889 L
.55991 .19214 L
.55993 .17397 L
.55994 .16968 L
.55995 .18167 L
.55996 .19879 L
.55997 .19225 L
.55998 .18618 L
.56 .18954 L
.56001 .17936 L
.56002 .19094 L
.56004 .19371 L
.56005 .20183 L
.56007 .16493 L
.56008 .19902 L
.5601 .17806 L
.56011 .17418 L
.56012 .18593 L
.56013 .14866 L
.56014 .23193 L
.56016 .1771 L
.56017 .15818 L
.56018 .17912 L
.56019 .19474 L
.5602 .1704 L
.56021 .17404 L
Mistroke
.56023 .16082 L
.56024 .20394 L
.56025 .19338 L
.56027 .217 L
.56028 .19346 L
.5603 .19559 L
.56031 .19917 L
.56032 .15166 L
.56034 .15716 L
.56035 .20213 L
.56037 .21353 L
.56038 .16136 L
.5604 .19555 L
.56041 .19644 L
.56043 .18822 L
.56043 .16867 L
.56044 .1977 L
.56045 .23245 L
.56046 .20768 L
.56047 .19152 L
.56049 .21326 L
.5605 .22191 L
.56052 .18573 L
.56053 .21321 L
.56055 .22889 L
.56056 .20804 L
.56057 .13848 L
.56059 .18044 L
.5606 .21349 L
.56062 .19383 L
.56063 .18406 L
.56064 .18178 L
.56066 .2095 L
.56067 .23802 L
.56069 .14265 L
.5607 .26119 L
.56071 .20824 L
.56072 .1635 L
.56074 .19782 L
.56074 .21211 L
.56075 .21835 L
.56076 .22657 L
.56077 .16855 L
.56078 .1958 L
.56079 .22075 L
.5608 .22055 L
.56081 .16433 L
.56082 .17642 L
.56083 .17275 L
.56084 .20132 L
Mistroke
.56084 .18799 L
.56085 .19562 L
.56087 .18785 L
.56088 .22272 L
.5609 .20641 L
.56091 .20228 L
.56092 .16275 L
.56094 .18432 L
.56095 .19769 L
.56097 .18261 L
.56097 .21115 L
.56098 .2041 L
.561 .15637 L
.56101 .19544 L
.56102 .16299 L
.56104 .17464 L
.56105 .20393 L
.56107 .17192 L
.56108 .17927 L
.56109 .20929 L
.56111 .19561 L
.56112 .19858 L
.56113 .18157 L
.56114 .15106 L
.56115 .20411 L
.56117 .17333 L
.56118 .17991 L
.56118 .17769 L
.56119 .17696 L
.5612 .19444 L
.56122 .22274 L
.56123 .16048 L
.56123 .17438 L
.56125 .20579 L
.56126 .22639 L
.56127 .21529 L
.56128 .18437 L
.5613 .21754 L
.56131 .19636 L
.56133 .2055 L
.56134 .19438 L
.56135 .15457 L
.56137 .18594 L
.56138 .21277 L
.5614 .21467 L
.56141 .19954 L
.56143 .17871 L
.56144 .20511 L
.56146 .17487 L
.56146 .13881 L
Mistroke
.56147 .15505 L
.56149 .20093 L
.5615 .18453 L
.56152 .16569 L
.56153 .21527 L
.56154 .16086 L
.56156 .17463 L
.56157 .17845 L
.56158 .20444 L
.5616 .19101 L
.56161 .19187 L
.56163 .17132 L
.56164 .16202 L
.56164 .2126 L
.56166 .21384 L
.56167 .14418 L
.56169 .21894 L
.5617 .21324 L
.56171 .14811 L
.56172 .21158 L
.56173 .17013 L
.56173 .19821 L
.56175 .18492 L
.56176 .15102 L
.56177 .20904 L
.56178 .18074 L
.56179 .17103 L
.5618 .21991 L
.56182 .1942 L
.56182 .19368 L
.56183 .21 L
.56185 .2206 L
.56186 .2156 L
.56188 .19724 L
.56188 .22952 L
.56189 .21689 L
.56191 .21424 L
.56192 .17556 L
.56192 .19155 L
.56194 .19329 L
.56195 .19973 L
.56197 .1851 L
.56198 .13971 L
.56199 .16565 L
.56201 .23914 L
.56202 .20641 L
.56204 .20642 L
.56205 .20626 L
.56206 .19766 L
.56208 .17805 L
Mistroke
.56209 .20252 L
.5621 .1694 L
.56211 .20236 L
.56213 .17323 L
.56214 .19445 L
.56216 .17968 L
.56217 .1979 L
.56219 .18127 L
.56219 .20549 L
.5622 .19971 L
.56221 .17434 L
.56222 .21013 L
.56224 .17666 L
.56224 .203 L
.56225 .2034 L
.56227 .21796 L
.56228 .22448 L
.5623 .15716 L
.56231 .22702 L
.56231 .12335 L
.56232 .15287 L
.56233 .21938 L
.56235 .18283 L
.56236 .21741 L
.56237 .21431 L
.56238 .18123 L
.56239 .16368 L
.56241 .16985 L
.56241 .18462 L
.56242 .20128 L
.56244 .17822 L
.56245 .19882 L
.56247 .21315 L
.56248 .19531 L
.5625 .19653 L
.56251 .19096 L
.56252 .14258 L
.56254 .21036 L
.56255 .21612 L
.56257 .16651 L
.56258 .15356 L
.56259 .16052 L
.5626 .14554 L
.56261 .19624 L
.56263 .21034 L
.56264 .14146 L
.56266 .24161 L
.56267 .2194 L
.56268 .19679 L
.56269 .1986 L
Mistroke
.5627 .2151 L
.56271 .18533 L
.56272 .18842 L
.56273 .17278 L
.56274 .21943 L
.56275 .14333 L
.56276 .2206 L
.56276 .18644 L
.56277 .23003 L
.56279 .22671 L
.5628 .21373 L
.56282 .19953 L
.56283 .20684 L
.56283 .20166 L
.56285 .22543 L
.56286 .18018 L
.56288 .17565 L
.56289 .21316 L
.5629 .16128 L
.56292 .21194 L
.56293 .19617 L
.56294 .18853 L
.56295 .15445 L
.56296 .18036 L
.56297 .21468 L
.56298 .19692 L
.56299 .13961 L
.56301 .21506 L
.56302 .16595 L
.56304 .20454 L
.56305 .1998 L
.56306 .23467 L
.56308 .23829 L
.56309 .18277 L
.5631 .1743 L
.56312 .16531 L
.56313 .16876 L
.56315 .17664 L
.56316 .19586 L
.56317 .1691 L
.56319 .14869 L
.5632 .18017 L
.56321 .17534 L
.56323 .21595 L
.56324 .20679 L
.56326 .16278 L
.56327 .22859 L
.56329 .25706 L
.5633 .1919 L
.5633 .18428 L
Mistroke
.56331 .17637 L
.56332 .17792 L
.56334 .2449 L
.56335 .17901 L
.56337 .15195 L
.56338 .24665 L
.56339 .2262 L
.56341 .17207 L
.56342 .22774 L
.56343 .17237 L
.56345 .18498 L
.56347 .17843 L
.56348 .25485 L
.56349 .14717 L
.56351 .21853 L
.56352 .17433 L
.56354 .21084 L
.56355 .17991 L
.56357 .17755 L
.56358 .14889 L
.56358 .22539 L
.5636 .19691 L
.56361 .17349 L
.56362 .19954 L
.56362 .19384 L
.56363 .22672 L
.56365 .16535 L
.56366 .20473 L
.56366 .18297 L
.56367 .14725 L
.56368 .17952 L
.56369 .18236 L
.5637 .19236 L
.56371 .17988 L
.56371 .18614 L
.56373 .22578 L
.56374 .18026 L
.56376 .21217 L
.56378 .19839 L
.56379 .1401 L
.5638 .21006 L
.56382 .14609 L
.56383 .19355 L
.56384 .17306 L
.56386 .18629 L
.56389 .21073 L
.5639 .18845 L
.56392 .23017 L
.56393 .20364 L
.56394 .18856 L
Mistroke
.56395 .20056 L
.56397 .21605 L
.56398 .20494 L
.56399 .20747 L
.56401 .18391 L
.56402 .21632 L
.56403 .22136 L
.56405 .17675 L
.56406 .17848 L
.56408 .2055 L
.56409 .12578 L
.56411 .17805 L
.56412 .16475 L
.56413 .23851 L
.56414 .16803 L
.56416 .19403 L
.56417 .17622 L
.56419 .1538 L
.5642 .19017 L
.56421 .18738 L
.56423 .20384 L
.56424 .20928 L
.56426 .19494 L
.56427 .20695 L
.56428 .21469 L
.5643 .16693 L
.56431 .20287 L
.56433 .19792 L
.56434 .19095 L
.56434 .17814 L
.56436 .20728 L
.56437 .23198 L
.56438 .20391 L
.56439 .21055 L
.5644 .22615 L
.56441 .17731 L
.56442 .20261 L
.56443 .19866 L
.56444 .16721 L
.56445 .17489 L
.56447 .18571 L
.56448 .20534 L
.56448 .16403 L
.56449 .18397 L
.5645 .22605 L
.56451 .17388 L
.56452 .17954 L
.56453 .15551 L
.56454 .18209 L
.56455 .17333 L
Mistroke
.56456 .21195 L
.56457 .22555 L
.56458 .20506 L
.56459 .1877 L
.5646 .25687 L
.56462 .18408 L
.56463 .25086 L
.56463 .16967 L
.56465 .24304 L
.56466 .21764 L
.56468 .1415 L
.56469 .20896 L
.56471 .19704 L
.56472 .21221 L
.56473 .20882 L
.56475 .17109 L
.56476 .18625 L
.56477 .2017 L
.56478 .20318 L
.56479 .19711 L
.56481 .18291 L
.56482 .20118 L
.56483 .16152 L
.56485 .19893 L
.56486 .1864 L
.56487 .18389 L
.56489 .16986 L
.5649 .17253 L
.56492 .1936 L
.56493 .15332 L
.56494 .2107 L
.56495 .19698 L
.56496 .20643 L
.56498 .13632 L
.56498 .17665 L
.56499 .18187 L
.565 .19173 L
.56501 .14063 L
.56502 .2149 L
.56503 .19832 L
.56504 .1925 L
.56506 .20222 L
.56507 .14709 L
.56507 .21328 L
.56508 .17771 L
.56509 .16677 L
.56511 .20331 L
.56512 .21103 L
.56514 .23221 L
.56515 .18162 L
Mistroke
.56516 .20576 L
.56518 .20243 L
.56519 .22064 L
.56521 .2115 L
.56522 .21421 L
.56524 .20605 L
.56524 .18989 L
.56525 .19679 L
.56527 .21225 L
.56528 .20919 L
.5653 .22371 L
.56531 .1568 L
.56532 .18729 L
.56533 .18901 L
.56535 .14335 L
.56536 .19588 L
.56538 .1963 L
.56539 .21229 L
.56541 .21078 L
.56541 .25205 L
.56542 .19407 L
.56544 .17577 L
.56545 .17684 L
.56546 .23142 L
.56547 .20902 L
.56548 .23106 L
.56549 .19711 L
.5655 .19031 L
.56551 .18754 L
.56552 .1983 L
.56553 .20632 L
.56555 .20383 L
.56556 .16486 L
.56558 .18482 L
.56559 .17432 L
.5656 .16285 L
.56561 .2148 L
.56562 .17175 L
.56564 .17268 L
.56565 .19279 L
.56567 .20626 L
.56568 .24795 L
.56568 .20471 L
.5657 .21735 L
.56571 .19891 L
.56573 .19927 L
.56574 .18272 L
.56576 .16749 L
.56577 .18094 L
.56579 .18389 L
Mistroke
.5658 .17598 L
.56581 .21411 L
.56583 .19668 L
.56584 .16311 L
.56585 .19612 L
.56585 .18117 L
.56586 .21588 L
.56587 .2144 L
.56588 .21922 L
.56589 .22032 L
.5659 .19235 L
.5659 .21927 L
.56591 .16243 L
.56593 .16705 L
.56594 .23175 L
.56594 .18786 L
.56595 .21283 L
.56596 .17473 L
.56597 .20416 L
.56598 .19347 L
.56599 .1853 L
.566 .26585 L
.56601 .19616 L
.56601 .21742 L
.56603 .24137 L
.56604 .19546 L
.56605 .15932 L
.56605 .16618 L
.56606 .18424 L
.56607 .20779 L
.56608 .17698 L
.56609 .14681 L
.56611 .17971 L
.56612 .2088 L
.56613 .23564 L
.56614 .2015 L
.56615 .14727 L
.56616 .21324 L
.56617 .16667 L
.56619 .21364 L
.5662 .17738 L
.56622 .19172 L
.56623 .17629 L
.56624 .20061 L
.56626 .21652 L
.56627 .19286 L
.56628 .21063 L
.56629 .20492 L
.5663 .20085 L
.56631 .16421 L
Mistroke
.56632 .20745 L
.56633 .16253 L
.56634 .18951 L
.56636 .22146 L
.56637 .24176 L
.56638 .21895 L
.56639 .16223 L
.5664 .18197 L
.56642 .19476 L
.56643 .1962 L
.56645 .23287 L
.56646 .18568 L
.56647 .19682 L
.56648 .14847 L
.56649 .1761 L
.56651 .20633 L
.56652 .18482 L
.56654 .19461 L
.56655 .20891 L
.56656 .23338 L
.56658 .23847 L
.56659 .21355 L
.56661 .18046 L
.56662 .18196 L
.56664 .18153 L
.56665 .19625 L
.56666 .16158 L
.56668 .19694 L
.56669 .18516 L
.5667 .2075 L
.56671 .19768 L
.56672 .20444 L
.56674 .23473 L
.56675 .18509 L
.56677 .20523 L
.56678 .22618 L
.56679 .17282 L
.56681 .17359 L
.56682 .18122 L
.56683 .1942 L
.56685 .18421 L
.56686 .15041 L
.56687 .18088 L
.56688 .18525 L
.5669 .22931 L
.56691 .18911 L
.56692 .18705 L
.56693 .15146 L
.56694 .21996 L
.56695 .16219 L
Mistroke
.56696 .22336 L
.56697 .18311 L
.56698 .1937 L
.56699 .19133 L
.56701 .18001 L
.56702 .21039 L
.56703 .18826 L
.56705 .21839 L
.56706 .17607 L
.56707 .17515 L
.56708 .18967 L
.5671 .20056 L
.56711 .16815 L
.56713 .18441 L
.56714 .17544 L
.56716 .17823 L
.56717 .18879 L
.56718 .18026 L
.5672 .21054 L
.56721 .24743 L
.56722 .26251 L
.56724 .22456 L
.56725 .13311 L
.56727 .18795 L
.56728 .19343 L
.56729 .25567 L
.5673 .16458 L
.56732 .22359 L
.56733 .26491 L
.56734 .18443 L
.56736 .19987 L
.56737 .18055 L
.56739 .19436 L
.5674 .1589 L
.56741 .23884 L
.56742 .18987 L
.56744 .22047 L
.56745 .17635 L
.56746 .19919 L
.56748 .21787 L
.56749 .19253 L
.56751 .17462 L
.56751 .20645 L
.56752 .2333 L
.56754 .23362 L
.56755 .19173 L
.56756 .20602 L
.56758 .21572 L
.56759 .2161 L
.56761 .17806 L
Mistroke
.56762 .21539 L
.56764 .21075 L
.56765 .19177 L
.56766 .22136 L
.56768 .18455 L
.56769 .18845 L
.56771 .22368 L
.56772 .21317 L
.56774 .15982 L
.56775 .21325 L
.56775 .1422 L
.56777 .19666 L
.56778 .22988 L
.5678 .2214 L
.56781 .20374 L
.56783 .20091 L
.56784 .17614 L
.56785 .16938 L
.56786 .20886 L
.56788 .21842 L
.56789 .22158 L
.5679 .14613 L
.56792 .20705 L
.56793 .18879 L
.56794 .1591 L
.56796 .20739 L
.56797 .2221 L
.56797 .20712 L
.56799 .23137 L
.568 .19983 L
.56802 .17201 L
.56803 .16133 L
.56805 .22282 L
.56806 .23025 L
.56808 .21775 L
.56809 .15291 L
.5681 .18866 L
.56812 .1961 L
.56813 .18209 L
.56815 .22642 L
.56816 .2304 L
.56818 .23725 L
.56819 .17652 L
.5682 .23227 L
.56821 .17177 L
.56822 .16264 L
.56824 .16479 L
.56825 .18888 L
.56826 .19571 L
.56828 .19259 L
Mistroke
.56829 .22005 L
.56831 .20279 L
.56832 .20316 L
.56833 .2112 L
.56834 .21588 L
.56836 .21826 L
.56837 .17792 L
.56839 .19942 L
.5684 .17794 L
.56841 .20288 L
.56842 .18748 L
.56843 .21133 L
.56844 .18935 L
.56846 .22123 L
.56847 .18624 L
.56849 .18388 L
.5685 .16639 L
.56852 .19846 L
.56853 .17172 L
.56854 .20679 L
.56856 .19573 L
.56857 .17584 L
.56859 .17231 L
.5686 .21219 L
.56862 .2162 L
.56863 .15651 L
.56865 .20314 L
.56865 .23159 L
.56866 .24365 L
.56867 .20247 L
.56868 .16278 L
.56869 .19669 L
.56871 .18829 L
.56872 .18774 L
.56873 .16511 L
.56875 .17851 L
.56876 .14618 L
.56878 .19269 L
.56879 .20319 L
.56881 .20612 L
.56882 .18376 L
.56883 .19683 L
.56885 .16203 L
.56886 .20266 L
.56887 .17297 L
.56889 .17292 L
.5689 .19617 L
.56891 .18197 L
.56893 .21103 L
.56894 .21217 L
Mistroke
.56896 .14215 L
.56897 .19379 L
.56898 .19027 L
.569 .21151 L
.56901 .22066 L
.56903 .19141 L
.56904 .16938 L
.56906 .19952 L
.56907 .20664 L
.56908 .20957 L
.5691 .15882 L
.56911 .19477 L
.56912 .1785 L
.56913 .20264 L
.56915 .20852 L
.56916 .194 L
.56917 .18314 L
.56919 .23317 L
.5692 .21687 L
.56922 .17853 L
.56923 .19688 L
.56924 .16873 L
.56925 .2307 L
.56927 .22598 L
.56928 .19978 L
.56929 .1999 L
.5693 .18782 L
.56931 .21075 L
.56933 .15941 L
.56934 .19406 L
.56935 .18469 L
.56937 .18475 L
.56938 .16068 L
.56939 .21096 L
.5694 .20937 L
.56941 .22931 L
.56943 .20458 L
.56944 .19286 L
.56945 .18228 L
.56947 .22308 L
.56948 .20784 L
.5695 .19051 L
.56951 .18298 L
.56951 .18867 L
.56953 .23207 L
.56954 .14956 L
.56955 .19319 L
.56956 .18409 L
.56958 .20908 L
.56959 .17777 L
Mistroke
.5696 .21272 L
.56962 .16422 L
.56963 .20902 L
.56964 .21928 L
.56965 .18818 L
.56967 .21694 L
.56968 .22649 L
.5697 .20582 L
.56971 .19379 L
.56973 .19194 L
.56974 .17575 L
.56975 .18412 L
.56977 .16119 L
.56978 .18105 L
.5698 .18352 L
.56981 .20305 L
.56982 .17032 L
.56984 .21 L
.56985 .20496 L
.56986 .15525 L
.56987 .23427 L
.56988 .17601 L
.56989 .20625 L
.5699 .1747 L
.56992 .18589 L
.56993 .16177 L
.56995 .23231 L
.56996 .22567 L
.56997 .1907 L
.56999 .20433 L
.57 .17979 L
.57001 .22523 L
.57003 .19735 L
.57005 .16623 L
.57006 .1812 L
.57007 .22077 L
.57009 .1966 L
.5701 .18158 L
.57012 .16284 L
.57013 .17237 L
.57013 .21112 L
.57014 .22556 L
.57015 .23244 L
.57016 .14658 L
.57017 .14519 L
.57018 .17654 L
.5702 .20494 L
.5702 .184 L
.57021 .16646 L
.57023 .17168 L
Mistroke
.57024 .1829 L
.57025 .17752 L
.57026 .18296 L
.57028 .17186 L
.57028 .22634 L
.57029 .17577 L
.5703 .17782 L
.57031 .20729 L
.57032 .16511 L
.57034 .23652 L
.57036 .14471 L
.57037 .20095 L
.57038 .19414 L
.5704 .24013 L
.57041 .21259 L
.57042 .15597 L
.57044 .22387 L
.57045 .2249 L
.57047 .18947 L
.57048 .20859 L
.5705 .19847 L
.57051 .18879 L
.57052 .16358 L
.57053 .17671 L
.57054 .18407 L
.57056 .22346 L
.57057 .22178 L
.57059 .21741 L
.5706 .14868 L
.57061 .17699 L
.57062 .18235 L
.57064 .19031 L
.57065 .19037 L
.57066 .20818 L
.57068 .20671 L
.57069 .179 L
.5707 .17292 L
.57072 .25783 L
.57073 .1977 L
.57074 .22637 L
.57075 .15732 L
.57076 .25193 L
.57078 .19423 L
.57079 .17936 L
.57081 .23236 L
.57082 .16706 L
.57084 .16307 L
.57085 .18125 L
.57086 .19961 L
.57088 .18509 L
Mistroke
.57089 .20896 L
.57091 .21576 L
.57092 .19454 L
.57094 .20487 L
.57095 .22156 L
.57096 .19198 L
.57097 .2068 L
.57098 .17161 L
.571 .20809 L
.57101 .19113 L
.57103 .17604 L
.57104 .25738 L
.57105 .20022 L
.57107 .18881 L
.57108 .21333 L
.57109 .1775 L
.57111 .2018 L
.57112 .15918 L
.57113 .20153 L
.57115 .21545 L
.57116 .19602 L
.57117 .17407 L
.57118 .22332 L
.57119 .2004 L
.5712 .21847 L
.57122 .21541 L
.57123 .24232 L
.57124 .20255 L
.57125 .19224 L
.57126 .16321 L
.57128 .18326 L
.57129 .18749 L
.5713 .18066 L
.57132 .18812 L
.57133 .20427 L
.57135 .14368 L
.57136 .21815 L
.57136 .19115 L
.57138 .19959 L
.57139 .23845 L
.5714 .16643 L
.57141 .19917 L
.57143 .22321 L
.57144 .16736 L
.57146 .20073 L
.57147 .17323 L
.57148 .20107 L
.57149 .2359 L
.57151 .19896 L
.57152 .2338 L
Mistroke
.57154 .21237 L
.57155 .22923 L
.57156 .21712 L
.57158 .2238 L
.57159 .2005 L
.5716 .23091 L
.57162 .16204 L
.57162 .19845 L
.57163 .1849 L
.57165 .21594 L
.57166 .23634 L
.57168 .19896 L
.57169 .17754 L
.5717 .19793 L
.57171 .17675 L
.57172 .17977 L
.57174 .2183 L
.57174 .16441 L
.57175 .22577 L
.57177 .19548 L
.57178 .18188 L
.57178 .21641 L
.57179 .19831 L
.5718 .1671 L
.57182 .21974 L
.57183 .22962 L
.57183 .20508 L
.57185 .21328 L
.57186 .17587 L
.57188 .19114 L
.57189 .18747 L
.5719 .21718 L
.57192 .14994 L
.57194 .20583 L
.57195 .2098 L
.57198 .2217 L
.57199 .17334 L
.57201 .23444 L
.57202 .19146 L
.57204 .21908 L
.57205 .15624 L
.57206 .19546 L
.57208 .22187 L
.57209 .21072 L
.5721 .24123 L
.57212 .16266 L
.57213 .18677 L
.57214 .16965 L
.57216 .17236 L
.57217 .22213 L
Mistroke
.57219 .21002 L
.5722 .19887 L
.57221 .18843 L
.57222 .2297 L
.57223 .22135 L
.57224 .20102 L
.57225 .19983 L
.57227 .22042 L
.57228 .13501 L
.5723 .22924 L
.57231 .18294 L
.57233 .22342 L
.57234 .23022 L
.57235 .21208 L
.57237 .20283 L
.57238 .15351 L
.57239 .19744 L
.5724 .20461 L
.57241 .21475 L
.57243 .24935 L
.57243 .18908 L
.57244 .16717 L
.57246 .17869 L
.57247 .14758 L
.57249 .17342 L
.5725 .13121 L
.57252 .17148 L
.57253 .19869 L
.57254 .19417 L
.57255 .1795 L
.57255 .21149 L
.57256 .20269 L
.57257 .16813 L
.57258 .16219 L
.5726 .2103 L
.5726 .19514 L
.57261 .18925 L
.57262 .18932 L
.57263 .19943 L
.57265 .18442 L
.57266 .23469 L
.57267 .23093 L
.57268 .1886 L
.57269 .19083 L
.57271 .24351 L
.57272 .20035 L
.57274 .1985 L
.57275 .23452 L
.57276 .18216 L
.57277 .17422 L
Mistroke
.57278 .20194 L
.57279 .17437 L
.5728 .18369 L
.57281 .20232 L
.57282 .2221 L
.57284 .18289 L
.57285 .17583 L
.57286 .21814 L
.57287 .18261 L
.57288 .18935 L
.57288 .21406 L
.5729 .23343 L
.57291 .15334 L
.57292 .2126 L
.57293 .2372 L
.57294 .20678 L
.57296 .1985 L
.57297 .22265 L
.57299 .18669 L
.573 .22128 L
.57301 .19867 L
.57302 .20843 L
.57303 .20468 L
.57304 .20357 L
.57305 .1957 L
.57306 .20335 L
.57306 .16884 L
.57308 .18671 L
.57309 .19882 L
.57311 .18273 L
.57312 .19861 L
.57313 .20566 L
.57314 .23017 L
.57316 .22165 L
.57317 .20765 L
.57318 .2044 L
.5732 .18239 L
.57321 .15107 L
.57323 .19898 L
.57323 .20763 L
.57324 .22235 L
.57326 .18663 L
.57327 .17092 L
.57328 .19894 L
.5733 .24961 L
.57331 .18172 L
.57333 .20443 L
.57334 .20321 L
.57335 .20371 L
.57337 .20918 L
Mistroke
.57338 .23271 L
.57338 .16538 L
.5734 .23763 L
.57341 .19355 L
.57342 .17824 L
.57343 .2015 L
.57345 .19538 L
.57345 .22071 L
.57346 .17453 L
.57347 .19637 L
.57348 .15604 L
.57349 .16446 L
.57351 .17106 L
.57352 .17269 L
.57354 .2121 L
.57355 .17587 L
.57356 .18646 L
.57357 .15856 L
.57358 .18606 L
.57359 .20529 L
.5736 .1373 L
.57362 .12702 L
.57363 .17376 L
.57364 .19138 L
.57366 .19055 L
.57367 .20379 L
.57368 .16855 L
.57369 .23171 L
.57371 .18526 L
.57372 .22424 L
.57373 .21592 L
.57375 .21222 L
.57376 .21718 L
.57377 .2265 L
.57379 .22161 L
.5738 .20751 L
.57382 .23374 L
.57383 .22397 L
.57384 .22253 L
.57385 .19854 L
.57386 .24072 L
.57386 .15881 L
.57388 .21491 L
.57389 .19512 L
.5739 .21939 L
.57391 .2294 L
.57393 .18571 L
.57394 .20361 L
.57394 .16664 L
.57395 .13719 L
Mistroke
.57396 .20978 L
.57398 .18081 L
.57399 .14459 L
.574 .15869 L
.57401 .18604 L
.57402 .26045 L
.57404 .17399 L
.57405 .2164 L
.57407 .20491 L
.57408 .17686 L
.5741 .21648 L
.57411 .19644 L
.57412 .19323 L
.57413 .17996 L
.57414 .19148 L
.57414 .20499 L
.57416 .23029 L
.57417 .20749 L
.57419 .1992 L
.5742 .2041 L
.57422 .20803 L
.57423 .22119 L
.57424 .23426 L
.57426 .21064 L
.57427 .17779 L
.57429 .12875 L
.5743 .22751 L
.57432 .18028 L
.57433 .18557 L
.57435 .15743 L
.57436 .22316 L
.57437 .21564 L
.57439 .22201 L
.5744 .23626 L
.57441 .17525 L
.57442 .21524 L
.57443 .24473 L
.57444 .1575 L
.57445 .22412 L
.57445 .22473 L
.57447 .2005 L
.57448 .18988 L
.57449 .19847 L
.5745 .19685 L
.5745 .21429 L
.57452 .15727 L
.57453 .15073 L
.57455 .19914 L
.57456 .21378 L
.57457 .22152 L
Mistroke
.57458 .19893 L
.5746 .19184 L
.57461 .22426 L
.57462 .19497 L
.57464 .20834 L
.57465 .19771 L
.57465 .22076 L
.57467 .19295 L
.57468 .22865 L
.5747 .19106 L
.57471 .1476 L
.57472 .15508 L
.57473 .22404 L
.57475 .18886 L
.57476 .1803 L
.57478 .19152 L
.57479 .20235 L
.57481 .22393 L
.57481 .19465 L
.57482 .21269 L
.57484 .18808 L
.57485 .23302 L
.57486 .18791 L
.57487 .21408 L
.57488 .15536 L
.57489 .24393 L
.5749 .19652 L
.57491 .19722 L
.57492 .24001 L
.57493 .25992 L
.57494 .21436 L
.57495 .16474 L
.57497 .18283 L
.57498 .17777 L
.575 .20123 L
.57501 .23108 L
.57502 .17071 L
.57504 .19548 L
.57505 .20767 L
.57505 .21116 L
.57507 .20386 L
.57508 .24382 L
.57509 .2242 L
.5751 .18589 L
.57512 .19187 L
.57513 .19975 L
.57515 .21212 L
.57516 .21469 L
.57517 .15124 L
.57518 .24914 L
Mistroke
.57519 .14707 L
.5752 .18033 L
.57521 .22635 L
.57522 .19518 L
.57523 .19166 L
.57524 .20746 L
.57524 .20851 L
.57525 .1747 L
.57526 .22417 L
.57528 .18433 L
.57528 .21565 L
.57529 .19858 L
.57531 .16172 L
.57532 .21457 L
.57532 .18438 L
.57534 .23199 L
.57535 .22663 L
.57537 .17491 L
.57538 .24509 L
.5754 .15508 L
.57541 .20582 L
.57542 .18169 L
.57543 .14456 L
.57544 .21618 L
.57545 .15467 L
.57547 .15652 L
.57548 .22032 L
.57549 .2107 L
.57549 .18749 L
.5755 .23463 L
.57552 .16844 L
.57553 .22385 L
.57553 .2108 L
.57555 .18264 L
.57556 .19201 L
.57557 .18617 L
.57558 .22548 L
.57559 .2132 L
.5756 .17231 L
.57561 .17722 L
.57563 .21412 L
.57564 .20312 L
.57566 .21011 L
.57567 .20069 L
.57568 .1852 L
.5757 .14195 L
.57571 .22773 L
.57572 .22095 L
.57574 .15781 L
.57576 .25233 L
Mistroke
.57577 .21888 L
.57578 .15296 L
.5758 .22728 L
.57581 .18357 L
.57583 .21958 L
.57584 .21467 L
.57585 .1824 L
.57586 .19502 L
.57587 .20855 L
.57588 .21271 L
.57589 .1485 L
.5759 .23092 L
.57591 .22548 L
.57592 .2057 L
.57593 .20756 L
.57594 .21419 L
.57595 .17662 L
.57596 .1703 L
.57597 .17763 L
.57599 .18976 L
.576 .20823 L
.57601 .19121 L
.57602 .14904 L
.57604 .20405 L
.57605 .19911 L
.57606 .20102 L
.57608 .20784 L
.57609 .17333 L
.5761 .178 L
.57611 .20611 L
.57612 .1561 L
.57614 .18812 L
.57615 .20543 L
.57616 .23195 L
.57618 .20243 L
.57619 .18645 L
.5762 .2386 L
.57622 .21207 L
.57623 .18691 L
.57625 .18563 L
.57626 .16296 L
.57627 .16945 L
.57628 .22413 L
.57629 .2263 L
.57631 .18308 L
.57631 .19054 L
.57632 .22467 L
.57634 .20497 L
.57635 .14301 L
.57635 .1906 L
Mistroke
.57636 .19829 L
.57637 .20248 L
.57639 .2086 L
.5764 .18328 L
.57641 .20494 L
.57642 .1701 L
.57644 .16124 L
.57645 .24605 L
.57646 .20068 L
.57648 .21326 L
.57649 .22167 L
.57651 .15983 L
.57652 .18302 L
.57652 .15567 L
.57654 .15312 L
.57655 .17497 L
.57656 .20235 L
.57657 .17206 L
.57658 .19027 L
.5766 .18821 L
.57661 .19118 L
.57662 .2082 L
.57663 .19433 L
.57664 .22636 L
.57665 .21425 L
.57666 .20467 L
.57668 .24747 L
.57669 .20478 L
.5767 .22012 L
.57671 .24167 L
.57672 .1714 L
.57673 .18843 L
.57674 .1986 L
.57675 .2326 L
.57676 .21342 L
.57678 .17057 L
.57679 .18925 L
.5768 .22327 L
.57681 .19462 L
.57682 .20151 L
.57683 .19219 L
.57685 .18996 L
.57686 .23477 L
.57687 .19341 L
.57688 .17112 L
.57689 .18404 L
.57691 .1898 L
.57692 .19093 L
.57694 .19289 L
.57695 .18801 L
Mistroke
.57696 .15849 L
.57696 .17928 L
.57697 .19386 L
.57698 .20469 L
.57699 .24294 L
.577 .23039 L
.57701 .186 L
.57702 .24421 L
.57703 .19418 L
.57705 .18037 L
.57706 .15057 L
.57708 .13535 L
.57709 .22223 L
.5771 .21098 L
.57712 .21215 L
.57713 .2121 L
.57714 .21637 L
.57715 .20801 L
.57716 .20765 L
.57717 .21323 L
.57718 .1775 L
.5772 .18444 L
.57721 .20699 L
.57723 .20825 L
.57724 .20191 L
.57725 .21544 L
.57726 .19559 L
.57728 .24374 L
.57729 .13743 L
.57731 .16508 L
.57732 .24919 L
.57733 .16919 L
.57735 .20439 L
.57736 .16056 L
.57737 .23549 L
.57739 .17405 L
.5774 .21974 L
.57742 .21197 L
.57743 .21091 L
.57745 .20246 L
.57745 .19601 L
.57746 .19448 L
.57748 .19079 L
.57749 .14985 L
.5775 .15631 L
.57751 .22625 L
.57753 .22967 L
.57754 .21575 L
.57755 .19773 L
.57756 .18495 L
Mistroke
.57757 .19935 L
.57758 .2279 L
.5776 .20469 L
.57761 .18777 L
.57763 .22896 L
.57764 .2094 L
.57765 .18405 L
.57767 .18654 L
.57768 .18319 L
.5777 .20026 L
.57771 .22028 L
.57772 .18492 L
.57773 .16957 L
.57774 .1724 L
.57776 .20496 L
.57778 .21234 L
.57779 .18942 L
.5778 .22938 L
.57782 .18389 L
.57783 .18742 L
.57784 .19735 L
.57785 .18577 L
.57787 .22988 L
.57787 .20231 L
.57788 .19025 L
.5779 .18527 L
.57791 .21129 L
.57792 .20164 L
.57793 .17465 L
.57793 .15227 L
.57795 .19463 L
.57796 .17543 L
.57798 .22151 L
.57799 .22275 L
.57801 .21992 L
.57801 .19339 L
.57802 .19646 L
.57804 .19411 L
.57805 .18771 L
.57806 .20982 L
.57808 .23328 L
.57809 .19306 L
.5781 .19787 L
.57812 .14531 L
.57813 .22588 L
.57815 .23038 L
.57816 .21565 L
.57818 .18119 L
.57818 .19637 L
.57819 .17269 L
Mistroke
.57821 .20666 L
.57822 .18078 L
.57823 .16677 L
.57824 .23655 L
.57825 .19847 L
.57826 .19417 L
.57827 .16834 L
.57828 .20437 L
.57829 .22543 L
.5783 .23952 L
.57831 .17271 L
.57832 .22127 L
.57834 .20192 L
.57835 .19157 L
.57837 .18019 L
.57838 .24231 L
.57839 .20785 L
.57841 .21834 L
.57842 .25754 L
.57843 .18437 L
.57844 .19115 L
.57846 .17613 L
.57846 .16774 L
.57847 .18042 L
.57849 .18177 L
.5785 .22239 L
.57852 .20294 L
.57853 .1979 L
.57854 .2133 L
.57855 .18339 L
.57856 .20992 L
.57857 .16054 L
.57858 .15122 L
.5786 .18902 L
.57861 .1954 L
.57862 .19786 L
.57863 .24943 L
.57864 .19223 L
.57865 .2325 L
.57866 .20409 L
.57866 .21668 L
.57868 .25834 L
.57869 .17732 L
.57871 .18668 L
.57872 .2096 L
.57873 .20337 L
.57874 .18432 L
.57875 .19762 L
.57876 .15565 L
.57877 .22834 L
Mistroke
.57877 .19729 L
.57878 .16004 L
.57879 .17343 L
.5788 .18021 L
.57882 .17554 L
.57883 .21813 L
.57885 .20396 L
.57886 .16818 L
.57887 .24386 L
.57888 .23977 L
.57889 .19675 L
.57891 .25542 L
.57892 .2283 L
.57893 .19647 L
.57894 .19986 L
.57895 .18258 L
.57897 .24781 L
.57898 .20973 L
.57899 .17536 L
.57901 .23743 L
.57902 .21417 L
.57904 .21093 L
.57905 .18833 L
.57905 .20526 L
.57907 .20422 L
.57908 .17498 L
.57909 .20342 L
.5791 .18206 L
.57911 .18819 L
.57912 .17577 L
.57913 .18255 L
.57914 .2097 L
.57916 .22471 L
.57917 .17876 L
.57919 .19945 L
.5792 .17183 L
.57921 .21798 L
.57922 .1814 L
.57924 .19148 L
.57925 .22535 L
.57926 .22037 L
.57928 .18967 L
.57929 .1954 L
.57931 .21445 L
.57932 .18728 L
.57933 .19568 L
.57934 .16331 L
.57935 .15513 L
.57937 .19034 L
.57938 .20816 L
Mistroke
.57939 .17828 L
.57941 .19908 L
.57942 .14516 L
.57944 .23136 L
.57945 .21653 L
.57946 .22065 L
.57948 .21776 L
.57949 .22117 L
.57951 .21445 L
.57952 .18718 L
.57954 .16886 L
.57955 .19073 L
.57956 .16003 L
.57957 .21459 L
.57958 .22299 L
.57958 .17829 L
.5796 .17483 L
.57961 .22023 L
.57963 .21635 L
.57964 .2359 L
.57965 .18151 L
.57967 .17656 L
.57968 .15707 L
.5797 .1815 L
.57971 .18891 L
.57973 .15911 L
.57974 .19831 L
.57975 .19181 L
.57977 .18219 L
.57978 .23067 L
.57979 .23386 L
.5798 .18154 L
.57982 .19104 L
.57983 .18961 L
.57985 .19924 L
.57986 .19366 L
.57988 .18226 L
.57989 .19865 L
.5799 .17464 L
.57992 .21814 L
.57993 .19423 L
.57995 .22622 L
.57996 .22143 L
.57997 .1724 L
.57999 .2256 L
.58 .17245 L
.58001 .1786 L
.58002 .20535 L
.58004 .17219 L
.58005 .1766 L
Mistroke
.58006 .17411 L
.58008 .19693 L
.58009 .17126 L
.5801 .18077 L
.58012 .21944 L
.58013 .18186 L
.58014 .20471 L
.58016 .20268 L
.58017 .23598 L
.58018 .19596 L
.58019 .17023 L
.5802 .18966 L
.58022 .19679 L
.58023 .17616 L
.58024 .19047 L
.58026 .1737 L
.58027 .20046 L
.58029 .18851 L
.5803 .22267 L
.58032 .19248 L
.58033 .23318 L
.58034 .21228 L
.58036 .22681 L
.58037 .18236 L
.58038 .20444 L
.5804 .21412 L
.58042 .18692 L
.58043 .16752 L
.58044 .21853 L
.58046 .19993 L
.58047 .17648 L
.58048 .20336 L
.58049 .18661 L
.58051 .15842 L
.58052 .20495 L
.58053 .19578 L
.58055 .19459 L
.58056 .22879 L
.58057 .1774 L
.58059 .21291 L
.5806 .19295 L
.58061 .21333 L
.58063 .21706 L
.58064 .23064 L
.58065 .18929 L
.58067 .1888 L
.58068 .19636 L
.58069 .19937 L
.5807 .17847 L
.58071 .18503 L
Mistroke
.58073 .12147 L
.58074 .18985 L
.58076 .20089 L
.58077 .18134 L
.58078 .20503 L
.5808 .213 L
.58081 .20745 L
.58082 .18863 L
.58083 .19537 L
.58084 .21143 L
.58086 .18584 L
.58087 .18449 L
.58088 .18763 L
.5809 .23203 L
.58091 .16818 L
.58092 .20282 L
.58094 .18986 L
.58095 .22387 L
.58097 .22659 L
.58098 .2198 L
.58099 .1994 L
.581 .23781 L
.58101 .16309 L
.58103 .21454 L
.58104 .17541 L
.58106 .16724 L
.58107 .19104 L
.58108 .22238 L
.58109 .18526 L
.5811 .1991 L
.58111 .18737 L
.58112 .19291 L
.58113 .1932 L
.58114 .17312 L
.58115 .20399 L
.58117 .20435 L
.58118 .19198 L
.58119 .1568 L
.5812 .22501 L
.58121 .2174 L
.58123 .18222 L
.58124 .16943 L
.58126 .20856 L
.58127 .23191 L
.58128 .22888 L
.58129 .16134 L
.5813 .15453 L
.58132 .19984 L
.58133 .18104 L
.58135 .15866 L
Mistroke
.58136 .18049 L
.58137 .22261 L
.58138 .17495 L
.5814 .19799 L
.58141 .23565 L
.58143 .24292 L
.58144 .20004 L
.58146 .1746 L
.58147 .19444 L
.58149 .21795 L
.5815 .243 L
.58152 .22161 L
.58153 .19398 L
.58155 .24615 L
.58155 .22419 L
.58156 .17817 L
.58158 .19293 L
.58159 .20639 L
.5816 .15174 L
.58161 .18058 L
.58161 .23027 L
.58163 .20361 L
.58164 .1975 L
.58166 .1943 L
.58167 .17835 L
.58168 .15451 L
.58169 .21326 L
.58171 .20141 L
.58172 .16128 L
.58173 .17629 L
.58175 .20266 L
.58176 .19847 L
.58177 .2047 L
.58178 .2179 L
.58179 .22347 L
.58181 .24145 L
.58182 .23967 L
.58183 .18403 L
.58184 .23469 L
.58186 .20403 L
.58187 .17616 L
.58189 .20388 L
.5819 .16668 L
.58192 .20876 L
.58192 .21161 L
.58193 .23223 L
.58195 .17156 L
.58196 .22708 L
.58197 .21801 L
.58198 .23042 L
Mistroke
.58199 .21804 L
.582 .17786 L
.58201 .18212 L
.58202 .16579 L
.58203 .2357 L
.58204 .16393 L
.58205 .16957 L
.58206 .2208 L
.58207 .18508 L
.58209 .20984 L
.5821 .25419 L
.58212 .18826 L
.58213 .1876 L
.58215 .18091 L
.58216 .22324 L
.58218 .21007 L
.58219 .20434 L
.5822 .21596 L
.58221 .18697 L
.58222 .20446 L
.58224 .20594 L
.58225 .19288 L
.58226 .24238 L
.58227 .20758 L
.58228 .16528 L
.58229 .16746 L
.5823 .24244 L
.58231 .23791 L
.58232 .15442 L
.58233 .20139 L
.58234 .18296 L
.58236 .22153 L
.58237 .16183 L
.58238 .18065 L
.58239 .20486 L
.5824 .22133 L
.58242 .20434 L
.58243 .20127 L
.58245 .22433 L
.58246 .18684 L
.58246 .15509 L
.58247 .20794 L
.58248 .21379 L
.5825 .1994 L
.5825 .21702 L
.58251 .16725 L
.58252 .19375 L
.58253 .2226 L
.58254 .22366 L
.58255 .15372 L
Mistroke
.58256 .19515 L
.58258 .18766 L
.58258 .17337 L
.58259 .22272 L
.5826 .20699 L
.58261 .19119 L
.58263 .16557 L
.58263 .22913 L
.58264 .23424 L
.58266 .1999 L
.58267 .21384 L
.58268 .23644 L
.58269 .16882 L
.5827 .21026 L
.58271 .1927 L
.58272 .15826 L
.58273 .20145 L
.58275 .24301 L
.58277 .17555 L
.58278 .21538 L
.58279 .22017 L
.58281 .22915 L
.58282 .20615 L
.58283 .1851 L
.58285 .18164 L
.58286 .22849 L
.58288 .18082 L
.58289 .21834 L
.58291 .18774 L
.58292 .19456 L
.58294 .23624 L
.58295 .2077 L
.58296 .2188 L
.58297 .19307 L
.58298 .18455 L
.58299 .23369 L
.583 .15362 L
.58301 .22295 L
.58302 .19894 L
.58303 .21336 L
.58304 .17872 L
.58305 .2095 L
.58306 .21768 L
.58307 .20423 L
.58307 .22585 L
.58308 .16942 L
.58309 .19444 L
.5831 .22278 L
.58311 .22781 L
.58313 .17762 L
Mistroke
.58314 .17002 L
.58316 .20702 L
.58317 .21475 L
.58319 .20458 L
.5832 .17755 L
.58321 .19024 L
.58323 .19028 L
.58324 .15083 L
.58326 .21333 L
.58327 .17917 L
.58329 .22738 L
.5833 .18582 L
.58332 .2159 L
.58332 .23573 L
.58333 .25634 L
.58335 .18691 L
.58336 .21892 L
.58338 .18975 L
.58339 .14617 L
.5834 .203 L
.58342 .19016 L
.58343 .20727 L
.58344 .1919 L
.58345 .21117 L
.58347 .15564 L
.58348 .20327 L
.5835 .21367 L
.58351 .18605 L
.58352 .22805 L
.58353 .14327 L
.58354 .20177 L
.58355 .17274 L
.58357 .21744 L
.58358 .18253 L
.5836 .21216 L
.58361 .1831 L
.58363 .19312 L
.58364 .20074 L
.58366 .22119 L
.58367 .17026 L
.58368 .23988 L
.5837 .20502 L
.58371 .19027 L
.58373 .18031 L
.58374 .17138 L
.58375 .20594 L
.58377 .20327 L
.58378 .19167 L
.58379 .21472 L
.5838 .2044 L
Mistroke
.58382 .22704 L
.58383 .19209 L
.58384 .21658 L
.58386 .21128 L
.58387 .19848 L
.58388 .20631 L
.5839 .19006 L
.58391 .22364 L
.58392 .18055 L
.58394 .16822 L
.58395 .19106 L
.58396 .20457 L
.58398 .16141 L
.58399 .19135 L
.584 .18907 L
.58401 .17888 L
.58402 .1914 L
.58404 .22353 L
.58405 .21137 L
.58406 .17675 L
.58407 .20294 L
.58408 .20581 L
.5841 .21141 L
.58411 .16748 L
.58412 .19553 L
.58414 .21711 L
.58415 .17087 L
.58417 .14943 L
.58417 .22295 L
.58418 .16932 L
.5842 .2008 L
.58421 .1927 L
.58421 .17189 L
.58423 .21569 L
.58424 .19595 L
.58426 .18097 L
.58427 .23061 L
.58429 .19204 L
.5843 .20248 L
.58431 .21372 L
.58432 .20065 L
.58434 .20254 L
.58435 .15292 L
.58437 .1566 L
.58438 .21401 L
.58439 .24053 L
.58441 .22009 L
.58442 .20524 L
.58443 .19308 L
.58445 .1951 L
Mistroke
.58446 .17907 L
.58448 .20169 L
.58449 .22389 L
.58451 .1924 L
.58452 .18197 L
.58454 .21767 L
.58455 .14244 L
.58456 .15695 L
.58457 .23398 L
.58458 .18215 L
.58459 .21538 L
.5846 .25056 L
.58462 .23269 L
.58463 .24717 L
.58464 .21779 L
.58466 .18977 L
.58467 .20573 L
.58468 .22332 L
.5847 .18423 L
.58471 .21452 L
.58473 .15582 L
.58474 .24398 L
.58476 .18917 L
.58477 .20114 L
.58478 .23983 L
.5848 .20894 L
.58481 .20639 L
.58482 .20381 L
.58483 .18906 L
.58484 .17954 L
.58485 .19027 L
.58486 .15193 L
.58487 .23288 L
.58487 .1819 L
.58488 .16873 L
.5849 .18517 L
.58491 .218 L
.58492 .21508 L
.58493 .19169 L
.58494 .20949 L
.58495 .18909 L
.58496 .21424 L
.58497 .20461 L
.58498 .19314 L
.58499 .23758 L
.58501 .2152 L
.58502 .1856 L
.58504 .22864 L
.58505 .19571 L
.58506 .21144 L
Mistroke
.58508 .19771 L
.58509 .19222 L
.58511 .20622 L
.58512 .18347 L
.58513 .195 L
.58515 .22687 L
.58516 .23114 L
.58517 .17492 L
.58518 .24105 L
.5852 .17988 L
.58521 .1834 L
.58522 .18965 L
.58524 .17028 L
.58525 .20134 L
.58526 .2156 L
.58528 .23008 L
.58529 .20174 L
.5853 .17917 L
.58532 .20463 L
.58533 .20356 L
.58534 .23169 L
.58535 .2243 L
.58536 .17448 L
.58538 .2054 L
.58539 .16377 L
.5854 .19745 L
.58542 .22102 L
.58543 .21871 L
.58545 .22294 L
.58546 .20095 L
.58548 .15924 L
.58549 .22934 L
.5855 .16281 L
.58552 .20266 L
.58553 .17575 L
.58555 .21678 L
.58556 .18692 L
.58558 .22023 L
.58559 .1689 L
.5856 .18917 L
.58562 .19455 L
.58563 .18904 L
.58564 .22598 L
.58565 .22724 L
.58567 .22411 L
.58568 .20281 L
.58569 .1911 L
.58571 .19263 L
.58572 .17289 L
.58574 .19687 L
Mistroke
.58575 .18407 L
.58576 .20457 L
.58577 .23446 L
.58579 .20109 L
.5858 .1995 L
.58581 .22728 L
.58583 .21154 L
.58584 .19833 L
.58585 .21045 L
.58586 .20233 L
.58587 .21796 L
.58589 .21385 L
.5859 .2296 L
.58591 .19674 L
.58593 .17865 L
.58594 .21145 L
.58596 .20678 L
.58597 .18843 L
.58599 .19243 L
.586 .21037 L
.58601 .19738 L
.58602 .20308 L
.58603 .19141 L
.58603 .17837 L
.58605 .28628 L
.58606 .15384 L
.58608 .21622 L
.58609 .24032 L
.58611 .22367 L
.58612 .16721 L
.58614 .17921 L
.58615 .20516 L
.58616 .17781 L
.58618 .23484 L
.58619 .19921 L
.58621 .20009 L
.58622 .20555 L
.58624 .22038 L
.58625 .21752 L
.58626 .25328 L
.58628 .19023 L
.58629 .17998 L
.5863 .17263 L
.58632 .23876 L
.58633 .20036 L
.58634 .23051 L
.58636 .20393 L
.58636 .23053 L
.58637 .17576 L
.58639 .2432 L
Mistroke
.5864 .16212 L
.58641 .23193 L
.58643 .2044 L
.58644 .21868 L
.58646 .19829 L
.58647 .2442 L
.58648 .19731 L
.58649 .22256 L
.5865 .19862 L
.58651 .17789 L
.58652 .17 L
.58653 .23747 L
.58655 .21982 L
.58656 .21111 L
.58658 .15461 L
.58659 .17087 L
.5866 .1561 L
.58662 .19723 L
.58663 .21573 L
.58664 .20435 L
.58666 .19681 L
.58667 .18467 L
.58668 .18355 L
.5867 .21874 L
.58671 .1802 L
.58673 .17455 L
.58674 .20701 L
.58676 .20362 L
.58677 .19434 L
.58678 .24434 L
.5868 .2148 L
.58681 .22786 L
.58683 .20188 L
.58684 .2258 L
.58684 .18209 L
.58685 .19764 L
.58686 .19986 L
.58688 .17801 L
.58689 .18181 L
.5869 .19168 L
.58692 .2314 L
.58693 .18694 L
.58695 .19942 L
.58696 .20014 L
.58697 .1791 L
.58699 .19626 L
.587 .21065 L
.58702 .20852 L
.58703 .2392 L
.58705 .19414 L
Mistroke
.58706 .23457 L
.58707 .14914 L
.58708 .20878 L
.58709 .1851 L
.5871 .22139 L
.5871 .1991 L
.58711 .1828 L
.58712 .21438 L
.58713 .12545 L
.58715 .20804 L
.58716 .21026 L
.58716 .16525 L
.58718 .2157 L
.58719 .19835 L
.58721 .20164 L
.58722 .18191 L
.58723 .1763 L
.58724 .1653 L
.58725 .19209 L
.58727 .18505 L
.58728 .19337 L
.5873 .2263 L
.58731 .20729 L
.58733 .208 L
.58734 .19825 L
.58735 .20701 L
.58736 .21359 L
.58737 .19 L
.58739 .19161 L
.5874 .17709 L
.58741 .22696 L
.58743 .24456 L
.58744 .20924 L
.58745 .18354 L
.58747 .20105 L
.58748 .22936 L
.5875 .21771 L
.58751 .17249 L
.58752 .20402 L
.58753 .19964 L
.58754 .16073 L
.58756 .24362 L
.58757 .21923 L
.58758 .16614 L
.58759 .22511 L
.5876 .21099 L
.58761 .15813 L
.58762 .22521 L
.58763 .21349 L
.58764 .22654 L
Mistroke
.58765 .20939 L
.58766 .21656 L
.58767 .19433 L
.58768 .21253 L
.58768 .19928 L
.5877 .20339 L
.58771 .16245 L
.58773 .19759 L
.58774 .17094 L
.58776 .17374 L
.58777 .15593 L
.58779 .19794 L
.5878 .19668 L
.58781 .21281 L
.58783 .2141 L
.58784 .21521 L
.58785 .19507 L
.58786 .19298 L
.58787 .19579 L
.58789 .18002 L
.5879 .23649 L
.58791 .20854 L
.58793 .19342 L
.58794 .22709 L
.58796 .19501 L
.58797 .17473 L
.58798 .19772 L
.58799 .255 L
.588 .21331 L
.58802 .23118 L
.58803 .2169 L
.58805 .16619 L
.58806 .20549 L
.58806 .21444 L
.58808 .20603 L
.58809 .21443 L
.5881 .25091 L
.5881 .17879 L
.58811 .21807 L
.58813 .19999 L
.58814 .22015 L
.58816 .18855 L
.58817 .22837 L
.58819 .19149 L
.5882 .24393 L
.5882 .19491 L
.58822 .17101 L
.58823 .18397 L
.58825 .1745 L
.58826 .22112 L
Mistroke
.58828 .22119 L
.58829 .19345 L
.58831 .19519 L
.58832 .22115 L
.58833 .1584 L
.58835 .20347 L
.58836 .1967 L
.58838 .21795 L
.58839 .21847 L
.5884 .21926 L
.58842 .19262 L
.58843 .16236 L
.58844 .21094 L
.58845 .2357 L
.58847 .2162 L
.58848 .21039 L
.58849 .21727 L
.58851 .19733 L
.58852 .21348 L
.58853 .24592 L
.58855 .22437 L
.58856 .21394 L
.58857 .22424 L
.58859 .18097 L
.5886 .22056 L
.58861 .1956 L
.58863 .15991 L
.58864 .19643 L
.58865 .23009 L
.58866 .21535 L
.58867 .24036 L
.58869 .21265 L
.5887 .19668 L
.58872 .18761 L
.58873 .23799 L
.58875 .21253 L
.58876 .15731 L
.58877 .23781 L
.58879 .19129 L
.5888 .20295 L
.58881 .16909 L
.58883 .18363 L
.58884 .24635 L
.58886 .15082 L
.58887 .15491 L
.58888 .16488 L
.58889 .20609 L
.58891 .1956 L
.58892 .21414 L
.58893 .2015 L
Mistroke
.58895 .22563 L
.58896 .1736 L
.58898 .20668 L
.58899 .18766 L
.589 .21729 L
.58901 .16915 L
.58903 .23041 L
.58904 .2118 L
.58905 .15817 L
.58907 .18206 L
.58908 .19475 L
.5891 .21426 L
.5891 .19219 L
.58911 .1881 L
.58913 .18939 L
.58914 .21107 L
.58916 .18503 L
.58917 .19454 L
.58918 .22645 L
.5892 .2162 L
.58921 .18677 L
.58923 .15218 L
.58924 .22148 L
.58925 .18707 L
.58927 .19543 L
.58928 .18372 L
.5893 .19975 L
.58931 .2242 L
.58933 .1811 L
.58934 .20051 L
.58934 .21055 L
.58936 .21338 L
.58938 .18084 L
.58939 .21283 L
.5894 .20886 L
.58942 .2468 L
.58943 .22066 L
.58944 .17819 L
.58945 .20717 L
.58947 .22566 L
.58948 .19917 L
.58949 .17415 L
.58951 .21863 L
.58952 .18203 L
.58954 .25164 L
.58955 .2275 L
.58956 .19581 L
.58957 .20971 L
.58958 .17895 L
.5896 .17345 L
Mistroke
.58961 .20457 L
.58963 .22224 L
.58964 .26966 L
.58965 .18799 L
.58967 .20756 L
.58968 .20851 L
.58969 .18018 L
.58971 .2278 L
.58972 .2332 L
.58974 .1937 L
.58975 .15952 L
.58977 .21148 L
.58978 .2236 L
.58979 .17848 L
.5898 .21433 L
.58982 .21564 L
.58983 .20612 L
.58984 .23371 L
.58986 .21606 L
.58987 .19038 L
.58988 .21838 L
.5899 .20897 L
.58991 .19001 L
.58992 .25893 L
.58994 .20542 L
.58995 .1886 L
.58996 .1875 L
.58998 .1771 L
.58999 .19537 L
.59 .18541 L
.59001 .16002 L
.59002 .20414 L
.59004 .24576 L
.59005 .25537 L
.59006 .20856 L
.59007 .23462 L
.59008 .16566 L
.5901 .2086 L
.59011 .19283 L
.59012 .22674 L
.59014 .1829 L
.59015 .18572 L
.59016 .24848 L
.59018 .24029 L
.59019 .21558 L
.59019 .24193 L
.59021 .21053 L
.59022 .23314 L
.59023 .22399 L
.59024 .20999 L
Mistroke
.59026 .19415 L
.59027 .1695 L
.59029 .22882 L
.5903 .17949 L
.59031 .23323 L
.59032 .22531 L
.59034 .24487 L
.59035 .21887 L
.59037 .2061 L
.59038 .20437 L
.59039 .20991 L
.59041 .21025 L
.59042 .18641 L
.59043 .16597 L
.59045 .13849 L
.59046 .18926 L
.59048 .18131 L
.59049 .16793 L
.59051 .20542 L
.59052 .22367 L
.59054 .12876 L
.59054 .22096 L
.59055 .19242 L
.59056 .18701 L
.59057 .25398 L
.59058 .21405 L
.5906 .21905 L
.59061 .22972 L
.59063 .16914 L
.59064 .22904 L
.59066 .207 L
.59067 .20367 L
.59068 .19465 L
.5907 .23104 L
.59071 .20949 L
.59073 .18492 L
.59074 .22346 L
.59075 .24375 L
.59077 .17839 L
.59078 .20758 L
.5908 .20681 L
.59081 .17661 L
.59082 .18258 L
.59083 .17744 L
.59085 .20521 L
.59085 .21388 L
.59086 .20714 L
.59088 .18364 L
.59089 .19179 L
.59089 .17023 L
Mistroke
.5909 .16064 L
.59091 .19345 L
.59092 .16187 L
.59093 .24842 L
.59094 .19127 L
.59096 .21441 L
.59097 .23247 L
.59098 .2054 L
.59099 .17769 L
.59101 .22651 L
.59102 .18408 L
.59103 .19553 L
.59105 .20013 L
.59106 .1941 L
.59107 .17587 L
.59108 .21998 L
.59109 .19361 L
.59111 .21159 L
.59112 .19065 L
.59113 .20535 L
.59115 .18171 L
.59116 .1804 L
.59117 .20444 L
.59119 .22122 L
.5912 .19998 L
.59122 .23614 L
.59123 .2405 L
.59124 .21053 L
.59125 .19034 L
.59126 .19143 L
.59128 .21464 L
.59128 .20345 L
.59129 .22248 L
.59131 .14838 L
.59132 .196 L
.59133 .1875 L
.59133 .20434 L
.59134 .21841 L
.59136 .22615 L
.59137 .23017 L
.59138 .17523 L
.59139 .19249 L
.59141 .22821 L
.59142 .23295 L
.59143 .18984 L
.59145 .20174 L
.59146 .19939 L
.59147 .20649 L
.59148 .20313 L
.59149 .17576 L
Mistroke
.59151 .17804 L
.59152 .23113 L
.59153 .21903 L
.59154 .20974 L
.59156 .15441 L
.59157 .19351 L
.59159 .14737 L
.5916 .24951 L
.59162 .25372 L
.59162 .21543 L
.59163 .18794 L
.59164 .16787 L
.59165 .18921 L
.59166 .20981 L
.59167 .20378 L
.59168 .17608 L
.59169 .20575 L
.5917 .1805 L
.59171 .22717 L
.59172 .22084 L
.59173 .19118 L
.59174 .17673 L
.59175 .22616 L
.59176 .21545 L
.59178 .18757 L
.59179 .23583 L
.59179 .1832 L
.5918 .19125 L
.59181 .1982 L
.59182 .22625 L
.59183 .20245 L
.59184 .19683 L
.5919 .18052 L
.59191 .21417 L
.59192 .20405 L
.59193 .17338 L
.59194 .19663 L
.59196 .19897 L
.59197 .20109 L
.59199 .21876 L
.592 .22815 L
.59201 .24854 L
.59202 .20295 L
.59203 .19406 L
.59205 .23174 L
.59206 .20143 L
.59208 .21708 L
.59209 .22085 L
.59211 .23352 L
.59212 .22752 L
Mistroke
.59214 .21208 L
.59215 .19178 L
.59216 .1767 L
.59217 .22114 L
.59218 .22537 L
.59219 .20957 L
.5922 .18826 L
.59221 .18767 L
.59223 .19031 L
.59224 .22442 L
.59226 .21072 L
.59227 .21409 L
.59228 .19181 L
.59229 .22816 L
.5923 .19433 L
.59232 .17293 L
.59233 .19665 L
.59234 .20583 L
.59235 .18705 L
.59237 .21592 L
.59238 .20898 L
.5924 .18617 L
.59241 .22889 L
.59242 .22893 L
.59244 .21726 L
.59245 .2121 L
.59247 .19297 L
.59248 .23666 L
.5925 .1988 L
.5925 .21111 L
.59251 .1967 L
.59253 .18492 L
.59254 .17501 L
.59256 .24756 L
.59257 .19044 L
.59258 .18032 L
.59259 .22488 L
.59261 .16242 L
.59262 .22438 L
.59264 .17486 L
.59265 .17492 L
.59267 .22962 L
.59267 .20098 L
.59268 .19665 L
.5927 .20135 L
.59271 .21461 L
.59272 .18483 L
.59273 .18962 L
.59274 .17803 L
.59275 .23259 L
Mistroke
.59276 .15621 L
.59277 .19576 L
.59278 .20399 L
.59279 .21422 L
.59281 .23583 L
.59282 .17938 L
.59284 .17154 L
.59285 .21993 L
.59286 .18992 L
.59287 .22337 L
.59288 .1678 L
.59289 .21049 L
.5929 .19717 L
.59291 .21499 L
.59293 .1599 L
.59294 .22464 L
.59296 .20082 L
.59297 .20122 L
.59297 .21873 L
.59299 .20289 L
.59301 .23032 L
.59302 .20848 L
.59303 .21206 L
.59304 .17516 L
.59306 .23587 L
.59307 .20171 L
.59309 .18491 L
.5931 .21995 L
.59312 .20514 L
.59313 .18467 L
.59314 .18459 L
.59315 .17706 L
.59316 .21342 L
.59316 .192 L
.59318 .17141 L
.59319 .20702 L
.5932 .22106 L
.59321 .19284 L
.59322 .22638 L
.59323 .2021 L
.59324 .17662 L
.59325 .17775 L
.59326 .20258 L
.59328 .21312 L
.59329 .22757 L
.5933 .18482 L
.59331 .20715 L
.59332 .20503 L
.59334 .22541 L
.59335 .20216 L
Mistroke
.59337 .20077 L
.59338 .17892 L
.5934 .17341 L
.59341 .17592 L
.59342 .20952 L
.59343 .20383 L
.59343 .23689 L
.59344 .23941 L
.59346 .19071 L
.59347 .23429 L
.59349 .19284 L
.5935 .23204 L
.59352 .20837 L
.59353 .25641 L
.59354 .13678 L
.59356 .19298 L
.59357 .21899 L
.59359 .20261 L
.5936 .177 L
.59361 .20842 L
.59363 .18512 L
.59364 .20401 L
.59366 .23003 L
.59367 .20094 L
.59369 .21947 L
.5937 .2099 L
.59371 .19722 L
.59372 .21328 L
.59373 .20311 L
.59374 .20947 L
.59375 .20752 L
.59376 .25272 L
.59377 .21123 L
.59378 .18705 L
.59379 .25607 L
.59379 .20916 L
.5938 .26156 L
.59381 .18318 L
.59382 .20626 L
.59383 .16019 L
.59384 .17064 L
.59385 .22432 L
.59387 .22094 L
.59388 .1887 L
.59389 .24853 L
.59391 .19249 L
.59392 .21809 L
.59394 .20459 L
.59395 .17705 L
.59396 .22761 L
Mistroke
.59397 .19668 L
.59398 .21122 L
.59399 .24009 L
.59401 .1685 L
.59402 .21112 L
.59404 .22117 L
.59405 .19144 L
.59406 .19675 L
.59408 .2317 L
.59409 .16739 L
.5941 .22196 L
.59412 .18467 L
.59413 .21575 L
.59414 .17863 L
.59415 .16532 L
.59417 .19333 L
.59418 .23299 L
.59419 .20647 L
.59421 .21239 L
.59422 .19117 L
.59423 .19063 L
.59424 .21766 L
.59425 .22127 L
.59426 .20513 L
.59427 .23569 L
.59428 .2116 L
.59429 .26252 L
.59431 .19926 L
.59432 .16657 L
.59433 .16862 L
.59434 .20509 L
.59435 .22217 L
.59437 .19367 L
.59438 .23164 L
.5944 .21307 L
.59441 .21538 L
.59442 .23709 L
.59443 .22141 L
.59444 .21406 L
.59446 .23869 L
.59447 .23014 L
.59448 .19173 L
.5945 .21446 L
.59451 .24319 L
.59452 .14633 L
.59454 .17957 L
.59455 .23405 L
.59457 .21066 L
.59458 .16192 L
.59459 .18292 L
Mistroke
.5946 .24545 L
.59461 .18536 L
.59463 .18228 L
.59464 .22071 L
.59465 .18334 L
.59466 .21616 L
.59467 .15069 L
.59468 .22085 L
.59469 .17959 L
.59469 .14237 L
.59471 .19412 L
.59472 .15432 L
.59474 .1764 L
.59475 .20317 L
.59477 .20413 L
.59478 .22481 L
.59478 .18851 L
.5948 .24673 L
.59482 .16373 L
.59483 .20349 L
.59484 .17875 L
.59486 .21952 L
.59487 .19957 L
.59489 .21219 L
.5949 .2207 L
.59491 .2099 L
.59493 .18429 L
.59494 .21263 L
.59496 .23867 L
.59497 .21332 L
.59499 .17037 L
.595 .20009 L
.59501 .21896 L
.59502 .19003 L
.59503 .20694 L
.59505 .21565 L
.59506 .18326 L
.59508 .17666 L
.59509 .21357 L
.5951 .17817 L
.59512 .20585 L
.59513 .20832 L
.59514 .17948 L
.59515 .2075 L
.59517 .23484 L
.59518 .20196 L
.5952 .19427 L
.59521 .20958 L
.59522 .20782 L
.59523 .19579 L
Mistroke
.59524 .21941 L
.59525 .23159 L
.59527 .17196 L
.59528 .22701 L
.5953 .18714 L
.59531 .18201 L
.59533 .23249 L
.59534 .20255 L
.59535 .21623 L
.59537 .24262 L
.59538 .24502 L
.5954 .19818 L
.59541 .19189 L
.59543 .2035 L
.59544 .1474 L
.59544 .20774 L
.59546 .18284 L
.59547 .20363 L
.59549 .14999 L
.5955 .25349 L
.59552 .1887 L
.59553 .23106 L
.59554 .22881 L
.59556 .20501 L
.59557 .21703 L
.59558 .2183 L
.5956 .19507 L
.59561 .20274 L
.59563 .18791 L
.59564 .18148 L
.59565 .23596 L
.59567 .21554 L
.59568 .21096 L
.59569 .18113 L
.59571 .1546 L
.59572 .19851 L
.59574 .19859 L
.59575 .1625 L
.59576 .20369 L
.59578 .22787 L
.59579 .23693 L
.5958 .22521 L
.59581 .20041 L
.59582 .18605 L
.59584 .18562 L
.59585 .17188 L
.59586 .23423 L
.59588 .18537 L
.59589 .23169 L
.5959 .17895 L
Mistroke
.59592 .2272 L
.59593 .18144 L
.59595 .2 L
.59596 .22848 L
.59597 .2367 L
.59598 .2276 L
.59599 .20487 L
.59601 .20816 L
.59602 .24683 L
.59602 .21405 L
.59604 .20405 L
.59605 .19605 L
.59606 .21209 L
.59606 .24284 L
.59607 .20461 L
.59609 .22031 L
.5961 .24013 L
.59611 .16292 L
.59612 .16611 L
.59614 .23511 L
.59615 .23832 L
.59616 .21485 L
.59618 .17157 L
.59619 .16259 L
.59621 .24505 L
.59622 .2329 L
.59623 .2301 L
.59624 .17151 L
.59625 .19783 L
.59626 .22943 L
.59627 .17789 L
.59628 .19135 L
.59629 .17867 L
.5963 .17059 L
.59631 .21041 L
.59632 .17585 L
.59633 .2162 L
.59635 .19226 L
.59636 .20804 L
.59637 .16328 L
.59638 .23716 L
.59639 .22573 L
.59641 .19322 L
.59642 .20212 L
.59644 .19516 L
.59645 .17216 L
.59646 .21356 L
.59648 .18044 L
.59649 .20989 L
.5965 .18571 L
Mistroke
.59652 .16398 L
.59653 .22896 L
.59655 .18725 L
.59656 .19741 L
.59657 .21349 L
.59659 .18545 L
.5966 .2383 L
.59662 .21672 L
.59663 .21404 L
.59665 .24394 L
.59666 .18516 L
.59667 .21873 L
.59669 .22566 L
.5967 .16992 L
.59672 .19577 L
.59673 .22366 L
.59674 .1877 L
.59676 .20783 L
.59677 .19892 L
.59678 .25066 L
.59679 .2094 L
.5968 .21568 L
.59681 .19925 L
.59682 .19021 L
.59683 .16583 L
.59684 .17915 L
.59685 .20048 L
.59687 .18875 L
.59688 .1924 L
.5969 .21512 L
.59691 .17745 L
.59693 .2287 L
.59694 .21891 L
.59694 .2171 L
.59696 .16902 L
.59697 .18299 L
.59699 .18832 L
.597 .22313 L
.59702 .20173 L
.59703 .19661 L
.59704 .21814 L
.59705 .18782 L
.59706 .23653 L
.59708 .21285 L
.59709 .18584 L
.5971 .20568 L
.59711 .19339 L
.59712 .17379 L
.59712 .1688 L
.59713 .16611 L
Mistroke
.59714 .19356 L
.59715 .20628 L
.59716 .21137 L
.59717 .20828 L
.59718 .20152 L
.59719 .14768 L
.59721 .20051 L
.59722 .25477 L
.59724 .14148 L
.59725 .20299 L
.59726 .26144 L
.59728 .18467 L
.59729 .22565 L
.5973 .24759 L
.59731 .21049 L
.59732 .22006 L
.59733 .21478 L
.59734 .23774 L
.59736 .19114 L
.59737 .21738 L
.59739 .20859 L
.5974 .22258 L
.59741 .2358 L
.59743 .20231 L
.59744 .1915 L
.59745 .21047 L
.59747 .21991 L
.59748 .19744 L
.59749 .17938 L
.59751 .20618 L
.59752 .21187 L
.59753 .21606 L
.59755 .17575 L
.59756 .19868 L
.59758 .21683 L
.59759 .19962 L
.59761 .2489 L
.59762 .20687 L
.59763 .19017 L
.59764 .25535 L
.59765 .21303 L
.59767 .18548 L
.59768 .19631 L
.5977 .19376 L
.59771 .16594 L
.59772 .22246 L
.59774 .21802 L
.59775 .18748 L
.59776 .18638 L
.59777 .15456 L
Mistroke
.59778 .23761 L
.59778 .21555 L
.5978 .16981 L
.59781 .22538 L
.59783 .21561 L
.59784 .21465 L
.59784 .16444 L
.59786 .21241 L
.59787 .20658 L
.59789 .23503 L
.5979 .22748 L
.59791 .24428 L
.59793 .21177 L
.59794 .19794 L
.59796 .2115 L
.59797 .18421 L
.59799 .21555 L
.598 .22048 L
.59801 .17689 L
.59803 .23876 L
.59804 .18732 L
.59805 .19975 L
.59807 .22509 L
.59808 .17968 L
.59809 .19032 L
.5981 .2013 L
.5981 .2222 L
.59811 .20458 L
.59812 .15951 L
.59813 .21003 L
.59814 .15627 L
.59816 .22683 L
.59817 .22138 L
.59818 .17182 L
.59819 .22447 L
.5982 .22011 L
.59821 .23414 L
.59822 .20333 L
.59823 .1939 L
.59824 .17253 L
.59825 .22878 L
.59826 .22683 L
.59827 .19927 L
.59828 .21435 L
.59828 .22775 L
.59829 .16972 L
.59831 .19579 L
.59832 .24552 L
.59834 .22597 L
.59835 .20181 L
Mistroke
.59837 .20438 L
.59838 .17956 L
.5984 .26393 L
.59841 .21231 L
.59842 .20794 L
.59844 .19812 L
.59845 .20753 L
.59845 .24102 L
.59846 .16496 L
.59847 .17743 L
.59848 .23741 L
.59849 .15018 L
.5985 .21313 L
.59852 .17252 L
.59853 .21523 L
.59854 .24583 L
.59855 .1832 L
.59856 .21243 L
.59858 .17986 L
.59859 .19217 L
.59861 .17853 L
.59862 .2041 L
.59864 .18095 L
.59865 .2634 L
.59866 .19312 L
.59868 .17633 L
.59869 .15137 L
.59869 .20577 L
.5987 .21786 L
.59871 .2164 L
.59873 .23966 L
.59874 .20831 L
.59874 .16298 L
.59876 .17125 L
.59877 .18218 L
.59879 .18387 L
.5988 .21925 L
.59882 .19309 L
.59883 .27862 L
.59885 .19828 L
.59886 .16647 L
.59887 .20311 L
.59888 .23512 L
.5989 .24258 L
.59891 .21269 L
.59892 .21788 L
.59893 .21197 L
.59894 .22543 L
.59896 .24679 L
.59897 .18236 L
Mistroke
.59897 .19077 L
.59898 .17473 L
.59899 .23241 L
.59901 .22264 L
.59902 .26022 L
.59903 .23117 L
.59904 .23661 L
.59905 .23045 L
.59906 .18204 L
.59907 .21896 L
.59908 .19471 L
.59909 .19432 L
.5991 .20529 L
.59912 .20949 L
.59913 .18849 L
.59914 .17743 L
.59916 .20035 L
.59917 .20666 L
.59919 .20925 L
.5992 .1713 L
.59921 .18339 L
.59922 .2065 L
.59923 .2133 L
.59925 .23042 L
.59926 .21114 L
.59926 .17638 L
.59928 .20942 L
.59929 .25806 L
.59931 .21663 L
.59932 .20611 L
.59934 .18385 L
.59935 .24625 L
.59936 .23443 L
.59937 .2053 L
.59938 .20967 L
.5994 .26836 L
.59941 .22134 L
.59942 .18311 L
.59943 .22614 L
.59945 .22315 L
.59946 .19401 L
.59947 .17947 L
.59949 .20118 L
.5995 .22543 L
.59951 .17535 L
.59953 .21049 L
.59954 .20922 L
.59956 .23111 L
.59957 .20225 L
.59958 .22176 L
Mistroke
.59959 .16863 L
.5996 .15558 L
.59962 .20992 L
.59963 .19378 L
.59964 .19494 L
.59966 .21096 L
.59967 .17957 L
.59968 .1868 L
.5997 .19459 L
.59971 .21556 L
.59972 .24512 L
.59974 .23033 L
.59975 .18272 L
.59976 .22473 L
.59977 .17832 L
.59979 .23988 L
.5998 .23267 L
.59981 .20147 L
.59982 .20562 L
.59983 .19116 L
.59984 .24431 L
.59985 .18636 L
.59986 .20596 L
.59987 .17788 L
.59988 .22452 L
.59989 .22655 L
.5999 .23529 L
.59991 .17393 L
.59993 .19646 L
.59994 .2139 L
.59996 .21594 L
.59997 .204 L
.59999 .18151 L
.6 .18977 L
.60001 .20608 L
.60003 .25262 L
.60005 .22475 L
.60006 .22906 L
.60007 .16877 L
.60009 .18993 L
.6001 .17609 L
.60012 .21571 L
.60012 .21512 L
.60013 .20111 L
.60015 .21829 L
.60016 .17026 L
.60017 .17195 L
.60018 .22884 L
.60019 .20605 L
.6002 .23722 L
Mistroke
.60021 .2024 L
.60022 .22569 L
.60023 .19839 L
.60024 .21842 L
.60026 .23919 L
.60027 .22918 L
.60027 .16955 L
.60028 .19535 L
.60029 .21862 L
.6003 .20218 L
.60031 .17652 L
.60032 .20597 L
.60033 .19732 L
.60034 .18345 L
.60035 .22322 L
.60036 .18486 L
.60037 .22876 L
.60038 .19557 L
.60039 .24908 L
.60041 .20335 L
.60041 .21918 L
.60042 .21324 L
.60044 .16658 L
.60045 .23029 L
.60047 .21058 L
.60048 .18972 L
.60049 .16078 L
.60051 .20072 L
.60052 .24063 L
.60054 .18707 L
.60055 .1779 L
.60056 .23839 L
.60057 .24097 L
.60058 .22803 L
.6006 .1698 L
.60061 .21372 L
.60062 .20515 L
.60064 .18778 L
.60065 .16525 L
.60066 .20635 L
.60068 .228 L
.60069 .22807 L
.60071 .22851 L
.60072 .21768 L
.60073 .22932 L
.60074 .22495 L
.60075 .19533 L
.60077 .17716 L
.60078 .21963 L
.60078 .19753 L
Mistroke
.6008 .21121 L
.60081 .19682 L
.60082 .20445 L
.60082 .21294 L
.60083 .19431 L
.60085 .20361 L
.60086 .18729 L
.60087 .20656 L
.60088 .18885 L
.6009 .20362 L
.60091 .17178 L
.60092 .23754 L
.60094 .2376 L
.60095 .19794 L
.60097 .14298 L
.60098 .17588 L
.60098 .2284 L
.601 .24879 L
.60101 .19742 L
.60102 .17352 L
.60103 .21297 L
.60105 .18263 L
.60106 .20942 L
.60108 .16772 L
.60108 .18559 L
.60109 .21877 L
.6011 .24974 L
.60111 .2314 L
.60113 .19809 L
.60114 .17013 L
.60115 .21174 L
.60116 .16727 L
.60117 .25135 L
.60117 .25541 L
.60118 .1911 L
.60119 .23036 L
.6012 .23593 L
.60121 .19171 L
.60122 .17744 L
.60124 .24964 L
.60125 .20918 L
.60126 .1983 L
.60128 .19957 L
.60129 .19888 L
.6013 .18963 L
.60131 .15899 L
.60133 .2083 L
.60133 .20882 L
.60134 .20831 L
.60135 .21316 L
Mistroke
.60136 .19698 L
.60137 .17458 L
.60138 .24555 L
.60139 .1796 L
.60141 .18159 L
.60142 .21078 L
.60144 .19185 L
.60145 .21903 L
.60147 .20841 L
.60147 .22547 L
.60148 .23205 L
.6015 .20422 L
.60151 .22474 L
.60152 .18538 L
.60154 .20085 L
.60155 .19172 L
.60157 .2109 L
.60158 .20221 L
.60159 .19028 L
.6016 .22357 L
.60161 .19776 L
.60162 .22486 L
.60163 .20956 L
.60164 .22215 L
.60166 .21319 L
.60167 .21336 L
.60169 .19359 L
.6017 .20535 L
.60172 .19962 L
.60173 .22981 L
.60174 .19983 L
.60176 .22251 L
.60177 .21569 L
.60179 .22934 L
.6018 .24182 L
.60182 .21284 L
.60183 .18723 L
.60184 .19668 L
.60185 .16793 L
.60187 .22048 L
.60188 .19497 L
.6019 .21125 L
.60191 .20194 L
.60192 .18199 L
.60194 .21655 L
.60195 .20237 L
.60196 .16523 L
.60197 .18659 L
.60197 .1632 L
.60199 .22597 L
Mistroke
.602 .22751 L
.60201 .2265 L
.60202 .20777 L
.60203 .24561 L
.60205 .17677 L
.60206 .24015 L
.60208 .21467 L
.60209 .20003 L
.60211 .19673 L
.60212 .2135 L
.60213 .21532 L
.60215 .16202 L
.60216 .20327 L
.60218 .20595 L
.60218 .22148 L
.60219 .24838 L
.60221 .19741 L
.60222 .20593 L
.60224 .1884 L
.60225 .20038 L
.60227 .16753 L
.60228 .2171 L
.60228 .21964 L
.6023 .23016 L
.60231 .20921 L
.60232 .17664 L
.60232 .20491 L
.60233 .22419 L
.60235 .23435 L
.60236 .20256 L
.60237 .18882 L
.60238 .23034 L
.60239 .21865 L
.6024 .18604 L
.60241 .24286 L
.60242 .22397 L
.60243 .19413 L
.60244 .24275 L
.60246 .24782 L
.60247 .15949 L
.60248 .24022 L
.6025 .23687 L
.60251 .18158 L
.60253 .20749 L
.60254 .24698 L
.60254 .21166 L
.60256 .20464 L
.60257 .22696 L
.60258 .17661 L
.60259 .20236 L
Mistroke
.60261 .20569 L
.60262 .23843 L
.60263 .23014 L
.60265 .21991 L
.60266 .18603 L
.60267 .18571 L
.60269 .21163 L
.6027 .18685 L
.60271 .19464 L
.60273 .25732 L
.60274 .21727 L
.60276 .19486 L
.60277 .19338 L
.60278 .17147 L
.6028 .20742 L
.60281 .24527 L
.60283 .18216 L
.60284 .25888 L
.60285 .1869 L
.60287 .19483 L
.60289 .18724 L
.60289 .20203 L
.6029 .16217 L
.60291 .17716 L
.60292 .213 L
.60293 .19775 L
.60295 .23932 L
.60296 .21749 L
.60296 .21259 L
.60298 .23911 L
.60299 .2544 L
.60301 .23803 L
.60302 .19372 L
.60304 .19247 L
.60305 .20497 L
.60306 .18933 L
.60308 .20848 L
.60309 .23013 L
.60311 .20881 L
.60312 .2293 L
.60313 .22761 L
.60314 .21385 L
.60315 .22549 L
.60317 .22561 L
.60318 .21861 L
.6032 .18679 L
.60321 .20469 L
.60323 .21644 L
.60323 .23266 L
.60324 .21987 L
Mistroke
.60326 .23447 L
.60327 .20462 L
.60328 .19382 L
.60329 .19969 L
.6033 .16 L
.60331 .19963 L
.60332 .22873 L
.60332 .2144 L
.60333 .2486 L
.60334 .15851 L
.60336 .20969 L
.60337 .22957 L
.60337 .19398 L
.60339 .23674 L
.6034 .18175 L
.60342 .1834 L
.60343 .19354 L
.60344 .22659 L
.60346 .17525 L
.60347 .18909 L
.60348 .19543 L
.60349 .18611 L
.6035 .24934 L
.60351 .21138 L
.60352 .20473 L
.60353 .23784 L
.60355 .24376 L
.60356 .21463 L
.60358 .18847 L
.60359 .22735 L
.6036 .15109 L
.60362 .24359 L
.60363 .18481 L
.60364 .20659 L
.60366 .22927 L
.60367 .20127 L
.60368 .21717 L
.6037 .18904 L
.60371 .20591 L
.60373 .20052 L
.60374 .26137 L
.60375 .24871 L
.60377 .21237 L
.60378 .25915 L
.6038 .21268 L
.60381 .18229 L
.60383 .18932 L
.60384 .18707 L
.60384 .1856 L
.60385 .20543 L
Mistroke
.60386 .18669 L
.60388 .20999 L
.60389 .20115 L
.6039 .20183 L
.60392 .21278 L
.60393 .25665 L
.60395 .22234 L
.60396 .21239 L
.60397 .19918 L
.60399 .2402 L
.604 .23122 L
.60402 .22286 L
.60403 .17068 L
.60405 .17754 L
.60406 .22139 L
.60408 .20238 L
.60409 .17737 L
.60411 .26225 L
.60412 .18162 L
.60412 .21724 L
.60414 .18917 L
.60415 .21939 L
.60415 .17079 L
.60416 .19412 L
.60417 .21724 L
.60419 .15784 L
.6042 .22284 L
.6042 .19305 L
.60421 .21744 L
.60422 .18778 L
.60423 .20254 L
.60424 .23968 L
.60425 .26983 L
.60425 .22197 L
.60427 .18682 L
.60428 .1695 L
.6043 .23856 L
.60431 .19777 L
.60433 .23353 L
.60434 .24334 L
.60436 .23231 L
.60437 .24554 L
.60438 .24353 L
.6044 .23681 L
.60441 .23531 L
.60443 .20207 L
.60444 .22163 L
.60446 .20019 L
.60446 .23541 L
.60447 .22037 L
Mistroke
.60448 .18995 L
.60449 .20004 L
.6045 .21268 L
.60452 .2306 L
.60453 .20602 L
.60455 .20736 L
.60456 .23909 L
.60457 .23928 L
.60459 .23444 L
.6046 .23907 L
.60461 .21506 L
.60462 .20116 L
.60464 .20846 L
.60465 .20958 L
.60467 .17888 L
.60468 .17852 L
.6047 .21302 L
.60471 .20324 L
.60472 .20948 L
.60474 .20095 L
.60475 .19747 L
.60477 .23018 L
.60478 .18006 L
.6048 .22469 L
.60481 .21345 L
.60482 .20099 L
.60484 .176 L
.60485 .18288 L
.60486 .22277 L
.60487 .23031 L
.60488 .21442 L
.6049 .20059 L
.60491 .16645 L
.60492 .26211 L
.60493 .22079 L
.60495 .22235 L
.60496 .19719 L
.60497 .23686 L
.60499 .18926 L
.605 .18316 L
.60501 .22598 L
.60502 .22936 L
.60504 .18882 L
.60505 .18609 L
.60507 .22506 L
.60508 .22123 L
.60509 .23048 L
.60511 .18953 L
.60512 .21623 L
.60512 .23634 L
Mistroke
.60514 .1999 L
.60515 .22115 L
.60517 .20652 L
.60518 .18344 L
.60519 .2431 L
.60521 .19631 L
.60522 .26239 L
.60524 .21487 L
.60525 .20473 L
.60526 .22294 L
.60527 .19477 L
.60528 .17113 L
.60529 .22122 L
.6053 .22007 L
.60532 .16656 L
.60533 .17433 L
.60534 .17532 L
.60536 .21259 L
.60537 .21769 L
.60538 .19916 L
.6054 .22877 L
.60541 .23976 L
.60543 .22382 L
.60544 .20779 L
.60546 .23399 L
.60547 .22233 L
.60549 .23745 L
.6055 .17083 L
.60551 .22185 L
.60552 .24191 L
.60553 .18698 L
.60554 .19575 L
.60555 .17915 L
.60556 .19839 L
.60557 .20807 L
.60558 .17724 L
.60559 .21143 L
.6056 .21981 L
.60561 .20825 L
.60562 .21086 L
.60562 .2028 L
.60563 .18688 L
.60564 .16793 L
.60565 .25582 L
.60566 .23845 L
.60568 .22087 L
.60569 .16117 L
.60571 .22748 L
.60572 .21243 L
.60574 .21681 L
Mistroke
.60575 .2118 L
.60576 .24502 L
.60578 .22918 L
.60579 .1986 L
.60581 .19797 L
.60582 .21118 L
.60583 .19295 L
.60585 .19072 L
.60587 .22276 L
.60587 .21133 L
.60588 .2487 L
.60589 .19097 L
.6059 .20433 L
.60591 .2244 L
.60593 .20231 L
.60594 .23273 L
.60595 .20202 L
.60597 .24126 L
.60598 .14553 L
.606 .18616 L
.60601 .18133 L
.60603 .21753 L
.60604 .18513 L
.60605 .21377 L
.60607 .22824 L
.60608 .17707 L
.60609 .23923 L
.60611 .24969 L
.60612 .23352 L
.60613 .2278 L
.60625 .17978 L
.60626 .18363 L
.60627 .21705 L
.60628 .21216 L
.60629 .23472 L
.6063 .19585 L
.60631 .15901 L
.60632 .21467 L
.60634 .23173 L
.60635 .23276 L
.60637 .20199 L
.60638 .21131 L
.60639 .23735 L
.60641 .17158 L
.60642 .22421 L
.60643 .22077 L
.60645 .20359 L
.60646 .19801 L
.60647 .22763 L
.60649 .20406 L
Mistroke
.6065 .23011 L
.60651 .24517 L
.60653 .21596 L
.60654 .18663 L
.60656 .20957 L
.60657 .19574 L
.60659 .25808 L
.6066 .26712 L
.60661 .19717 L
.60662 .17572 L
.60663 .21399 L
.60665 .17298 L
.60666 .18885 L
.60667 .22442 L
.60669 .19301 L
.6067 .17956 L
.60672 .21543 L
.60673 .21688 L
.60675 .22838 L
.60676 .20017 L
.60676 .18593 L
.60678 .18124 L
.60679 .21964 L
.60679 .20895 L
.60681 .23893 L
.60682 .20427 L
.60684 .21517 L
.60685 .18684 L
.60686 .23479 L
.60688 .18725 L
.60689 .20292 L
.6069 .2333 L
.60691 .20854 L
.60693 .23332 L
.60694 .19564 L
.60696 .2236 L
.60697 .1847 L
.60698 .2734 L
.607 .1998 L
.60701 .18433 L
.60701 .22205 L
.60703 .19233 L
.60704 .20043 L
.60706 .19943 L
.60707 .22752 L
.60708 .23464 L
.60708 .21936 L
.60709 .20917 L
.6071 .26083 L
.60711 .2229 L
Mistroke
.60712 .18787 L
.60714 .24419 L
.60715 .23132 L
.60717 .19465 L
.60718 .23553 L
.60719 .19061 L
.6072 .19012 L
.60721 .18391 L
.60723 .21073 L
.60724 .21135 L
.60725 .25326 L
.60726 .2118 L
.60726 .19456 L
.60727 .20108 L
.60728 .18986 L
.60729 .22059 L
.6073 .23138 L
.60731 .2118 L
.60733 .23831 L
.60734 .1844 L
.60736 .16997 L
.60737 .22644 L
.60738 .18742 L
.60739 .19733 L
.6074 .20435 L
.60742 .21341 L
.60743 .21397 L
.60743 .19601 L
.60744 .24257 L
.60745 .18293 L
.60747 .20657 L
.60748 .19376 L
.60748 .24642 L
.6075 .18897 L
.60751 .22463 L
.60753 .21991 L
.60754 .19964 L
.60756 .17518 L
.60757 .20415 L
.60759 .20809 L
.6076 .17409 L
.60761 .23675 L
.60763 .21419 L
.60764 .18667 L
.60764 .21226 L
.60766 .17751 L
.60767 .24661 L
.60768 .19213 L
.60769 .24905 L
.6077 .22783 L
Mistroke
.60771 .21626 L
.60771 .19695 L
.60772 .26789 L
.60774 .20356 L
.60775 .24613 L
.60777 .19821 L
.60778 .19234 L
.6078 .20461 L
.60781 .2167 L
.60782 .18733 L
.60784 .2061 L
.60785 .24511 L
.60786 .2005 L
.60787 .25305 L
.60789 .19118 L
.6079 .23562 L
.60792 .20916 L
.60793 .20058 L
.60794 .22426 L
.60796 .22733 L
.60797 .24236 L
.60797 .18318 L
.60799 .20191 L
.608 .21707 L
.60802 .20354 L
.60803 .24388 L
.60805 .19619 L
.60806 .2455 L
.60808 .18314 L
.60809 .23399 L
.6081 .22366 L
.60812 .23679 L
.60813 .23577 L
.60815 .18435 L
.60816 .22476 L
.60817 .21461 L
.60819 .22306 L
.6082 .23643 L
.60821 .21373 L
.60822 .26002 L
.60824 .19667 L
.60825 .21826 L
.60826 .16923 L
.60828 .19608 L
.60829 .2043 L
.6083 .24519 L
.60832 .25462 L
.60833 .20683 L
.60834 .23262 L
.60836 .20323 L
Mistroke
.60837 .21411 L
.60838 .15375 L
.6084 .2281 L
.60841 .21863 L
.60841 .21604 L
.60843 .19738 L
.60844 .22567 L
.60846 .23267 L
.60847 .21454 L
.60849 .19015 L
.6085 .20461 L
.60852 .19291 L
.60853 .25216 L
.60854 .20442 L
.60856 .18402 L
.60857 .2242 L
.60859 .17445 L
.6086 .19707 L
.60861 .22376 L
.60863 .17271 L
.60864 .2224 L
.60865 .21974 L
.60866 .20017 L
.60868 .21857 L
.60869 .19086 L
.6087 .21853 L
.60872 .20733 L
.60873 .25211 L
.60875 .2367 L
.60876 .22226 L
.60877 .23667 L
.60878 .22106 L
.6088 .20701 L
.60881 .18632 L
.60883 .15136 L
.60884 .24742 L
.60885 .20094 L
.60887 .21133 L
.60888 .24665 L
.60888 .17074 L
.6089 .21605 L
.60891 .22266 L
.60893 .18154 L
.60894 .27014 L
.60896 .23391 L
.60897 .21864 L
.60898 .20787 L
.609 .20072 L
.60901 .17548 L
.60903 .20985 L
Mistroke
.60904 .24639 L
.60906 .25018 L
.60907 .24657 L
.60908 .17073 L
.6091 .18152 L
.60911 .19266 L
.60912 .22405 L
.60913 .25197 L
.60915 .21838 L
.60916 .20892 L
.60917 .23477 L
.60919 .207 L
.6092 .23666 L
.60921 .19553 L
.60923 .17196 L
.60924 .20568 L
.60925 .22 L
.60927 .2617 L
.60928 .21846 L
.6093 .22507 L
.60931 .2629 L
.60932 .26137 L
.60933 .18974 L
.60934 .21029 L
.60935 .21717 L
.60937 .17291 L
.60938 .19426 L
.60939 .24489 L
.6094 .17063 L
.60941 .22588 L
.60943 .23084 L
.60944 .22383 L
.60945 .21633 L
.60947 .20642 L
.60948 .19808 L
.6095 .22469 L
.60951 .20302 L
.60953 .22011 L
.60954 .21572 L
.60955 .22925 L
.60956 .24119 L
.60957 .22082 L
.60959 .20239 L
.60959 .22053 L
.6096 .22882 L
.60962 .22971 L
.60963 .2194 L
.60964 .1768 L
.60965 .16712 L
.60967 .2166 L
Mistroke
.60968 .20273 L
.6097 .19933 L
.60971 .22271 L
.60972 .21781 L
.60974 .17793 L
.60975 .22217 L
.60976 .20247 L
.60978 .24062 L
.6098 .18815 L
.60981 .16691 L
.60982 .20148 L
.60984 .22135 L
.60985 .19314 L
.60986 .20716 L
.60987 .23398 L
.60988 .22457 L
.60989 .27186 L
.6099 .21801 L
.60992 .17856 L
.60993 .19974 L
.60995 .21464 L
.60996 .17635 L
.60997 .2419 L
.60999 .22741 L
.61 .18798 L
.61001 .16952 L
.61003 .2376 L
.61004 .17749 L
.61006 .2113 L
.61007 .1977 L
.61009 .22911 L
.6101 .24922 L
.61012 .23565 L
.61013 .21583 L
.61014 .15277 L
.61015 .17284 L
.61016 .22926 L
.61017 .22819 L
.61018 .21592 L
.61019 .19018 L
.6102 .22697 L
.61021 .19765 L
.61022 .2176 L
.61023 .1873 L
.61024 .22062 L
.61025 .25212 L
.61025 .21922 L
.61026 .22072 L
.61027 .22247 L
.61028 .21602 L
Mistroke
.61029 .27409 L
.61031 .22223 L
.61032 .23736 L
.61034 .25522 L
.61035 .2463 L
.61037 .18807 L
.61038 .26559 L
.61039 .23617 L
.61041 .17425 L
.61042 .217 L
.61044 .17906 L
.61045 .26191 L
.61047 .21482 L
.61048 .21494 L
.6105 .15345 L
.61051 .25874 L
.61051 .20831 L
.61053 .18176 L
.61054 .23132 L
.61056 .1789 L
.61057 .22561 L
.61059 .23934 L
.6106 .20246 L
.61061 .20703 L
.61062 .19011 L
.61064 .2287 L
.61065 .19406 L
.61066 .21157 L
.61068 .23579 L
.61069 .2282 L
.6107 .20193 L
.61072 .27492 L
.61073 .22606 L
.61073 .23303 L
.61075 .21904 L
.61076 .21095 L
.61078 .25197 L
.61079 .22021 L
.61081 .21979 L
.61082 .17664 L
.61084 .2575 L
.61085 .18153 L
.61086 .25488 L
.61088 .20404 L
.61089 .19215 L
.61091 .19744 L
.61092 .21857 L
.61094 .1985 L
.61095 .21192 L
.61096 .20485 L
Mistroke
.61097 .2186 L
.61098 .19328 L
.611 .21444 L
.61101 .20475 L
.61103 .22028 L
.61104 .2075 L
.61105 .21795 L
.61107 .25045 L
.61108 .19853 L
.61109 .1797 L
.6111 .16954 L
.61112 .19215 L
.61113 .16417 L
.61115 .22906 L
.61116 .20369 L
.61117 .18591 L
.61118 .25244 L
.61119 .23299 L
.6112 .18029 L
.61122 .17865 L
.61123 .19989 L
.61125 .19332 L
.61126 .16608 L
.61128 .24772 L
.61129 .23266 L
.6113 .2547 L
.61131 .2396 L
.61132 .19131 L
.61134 .12712 L
.61135 .20474 L
.61136 .24505 L
.61138 .19851 L
.61139 .23211 L
.61141 .2271 L
.61142 .25154 L
.61143 .21134 L
.61145 .20281 L
.61146 .19689 L
.61148 .24273 L
.61148 .18698 L
.61149 .2387 L
.61151 .20895 L
.61152 .20208 L
.61154 .25804 L
.61155 .18469 L
.61156 .17999 L
.61157 .19147 L
.61158 .21654 L
.6116 .23957 L
.61161 .21549 L
Mistroke
.61161 .19667 L
.61162 .24495 L
.61163 .2457 L
.61165 .19532 L
.61166 .1906 L
.61168 .22655 L
.61169 .17302 L
.61169 .23821 L
.61171 .22747 L
.61172 .26071 L
.61174 .22613 L
.61175 .23412 L
.61177 .22269 L
.61177 .19084 L
.61178 .19737 L
.6118 .22101 L
.61181 .22212 L
.61183 .21152 L
.61184 .22633 L
.61185 .17204 L
.61187 .21837 L
.61188 .20805 L
.6119 .15518 L
.61191 .16716 L
.61192 .21799 L
.61193 .18055 L
.61194 .2127 L
.61196 .23133 L
.61197 .18767 L
.61198 .19758 L
.61199 .2259 L
.612 .23169 L
.61202 .22212 L
.61203 .21612 L
.61203 .21867 L
.61204 .22483 L
.61205 .20951 L
.61207 .23863 L
.61208 .18231 L
.6121 .21305 L
.61211 .18447 L
.61212 .23837 L
.61213 .18231 L
.61214 .22499 L
.61216 .19448 L
.61217 .21531 L
.61219 .18692 L
.6122 .23163 L
.61222 .21376 L
.61223 .20561 L
Mistroke
.61224 .20554 L
.61226 .21162 L
.61227 .21221 L
.61229 .24046 L
.6123 .26867 L
.61232 .23248 L
.61233 .18183 L
.61234 .24194 L
.61236 .20681 L
.61237 .17638 L
.61238 .18092 L
.61239 .24098 L
.61241 .22217 L
.61242 .22645 L
.61243 .19454 L
.61245 .19293 L
.61246 .20804 L
.61247 .20669 L
.61249 .17376 L
.6125 .19082 L
.61251 .16436 L
.61253 .19361 L
.61254 .25218 L
.61255 .20366 L
.61257 .21791 L
.61258 .23396 L
.61259 .23226 L
.6126 .22299 L
.61261 .26923 L
.61263 .22249 L
.61264 .20655 L
.61266 .23116 L
.61267 .24636 L
.61269 .2264 L
.6127 .21878 L
.61271 .21204 L
.61273 .19974 L
.61274 .21103 L
.61275 .21603 L
.61277 .18402 L
.61278 .19238 L
.6128 .1781 L
.61281 .19874 L
.61282 .21812 L
.61283 .21093 L
.61285 .23881 L
.61286 .16934 L
.61287 .20505 L
.61289 .22362 L
.6129 .17065 L
Mistroke
.61292 .19875 L
.61293 .24695 L
.61294 .21446 L
.61295 .16 L
.61297 .19074 L
.61298 .22884 L
.613 .16241 L
.61301 .18625 L
.61302 .238 L
.61304 .17778 L
.61304 .22644 L
.61305 .20548 L
.61307 .20547 L
.61308 .19171 L
.6131 .21237 L
.6131 .16165 L
.61311 .23307 L
.61313 .21935 L
.61314 .22181 L
.61315 .17656 L
.61317 .15057 L
.61318 .18626 L
.6132 .19703 L
.6132 .22299 L
.61321 .19457 L
.61323 .21599 L
.61324 .24446 L
.61325 .19609 L
.61326 .21813 L
.61327 .20129 L
.61329 .18611 L
.6133 .2457 L
.61332 .21799 L
.61333 .21248 L
.61334 .26392 L
.61336 .226 L
.61337 .26864 L
.61338 .25029 L
.6134 .21026 L
.61341 .21596 L
.61342 .19964 L
.61344 .21907 L
.61345 .14614 L
.61347 .25015 L
.61348 .21205 L
.61349 .23066 L
.61351 .22889 L
.61352 .21413 L
.61354 .18994 L
.61355 .18304 L
Mistroke
.61357 .20763 L
.61358 .19343 L
.61358 .24143 L
.61359 .23648 L
.6136 .24504 L
.61362 .22662 L
.61363 .17301 L
.61364 .18673 L
.61366 .19549 L
.61367 .19908 L
.61369 .24459 L
.6137 .23356 L
.61371 .24877 L
.61373 .21247 L
.61374 .2396 L
.61376 .19929 L
.61377 .16947 L
.61379 .22151 L
.6138 .2156 L
.61383 .20096 L
.61384 .23419 L
.61385 .19228 L
.61386 .22556 L
.61386 .21248 L
.61388 .21507 L
.61389 .23243 L
.61391 .20796 L
.61392 .17906 L
.61393 .22295 L
.61394 .23187 L
.61396 .19386 L
.61396 .19901 L
.61397 .21815 L
.61399 .21727 L
.614 .24178 L
.61401 .19253 L
.61401 .21845 L
.61402 .24238 L
.61404 .18741 L
.61405 .22294 L
.61407 .19318 L
.61408 .2032 L
.6141 .18623 L
.61411 .2059 L
.61412 .24832 L
.61414 .23078 L
.61415 .23688 L
.61416 .15404 L
.61417 .25592 L
.61418 .19318 L
Mistroke
.6142 .20787 L
.6142 .23496 L
.61421 .23244 L
.61423 .21705 L
.61424 .20835 L
.61424 .21904 L
.61425 .17287 L
.61426 .21171 L
.61428 .23219 L
.61429 .20872 L
.6143 .24158 L
.61431 .21855 L
.61432 .17955 L
.61432 .24002 L
.61433 .24317 L
.61434 .2308 L
.61436 .22075 L
.61437 .21572 L
.61437 .18965 L
.61438 .1941 L
.61439 .191 L
.61441 .22752 L
.61442 .19881 L
.61443 .26472 L
.61443 .20316 L
.61444 .19242 L
.61446 .23782 L
.61447 .20898 L
.61449 .20115 L
.6145 .19674 L
.61451 .19019 L
.61452 .21683 L
.61453 .24861 L
.61454 .19112 L
.61455 .20777 L
.61456 .24198 L
.61457 .17394 L
.61458 .20279 L
.61459 .18915 L
.6146 .25138 L
.61461 .19033 L
.61462 .22907 L
.61464 .23807 L
.61465 .20045 L
.61467 .19591 L
.61468 .18465 L
.61469 .23362 L
.61471 .1878 L
.61472 .1973 L
.61474 .20145 L
Mistroke
.61475 .15604 L
.61477 .26339 L
.61478 .20147 L
.61478 .23698 L
.6148 .20628 L
.61481 .18144 L
.61481 .19402 L
.61483 .20992 L
.61484 .20147 L
.61486 .26212 L
.61487 .21521 L
.61488 .20527 L
.61489 .20622 L
.6149 .20906 L
.61491 .21014 L
.61492 .17832 L
.61493 .25052 L
.61494 .22728 L
.61495 .23846 L
.61496 .18474 L
.61496 .25803 L
.61497 .21167 L
.61499 .18467 L
.615 .20913 L
.61502 .2146 L
.61503 .17777 L
.61503 .23342 L
.61505 .23938 L
.61506 .16112 L
.61507 .18715 L
.61508 .21703 L
.6151 .22746 L
.61511 .19081 L
.61513 .19191 L
.61513 .20647 L
.61514 .20039 L
.61515 .20609 L
.61516 .18794 L
.61517 .19108 L
.61517 .19738 L
.61519 .20523 L
.6152 .19801 L
.61521 .19644 L
.61522 .18287 L
.61523 .16074 L
.61523 .27165 L
.61524 .21035 L
.61525 .17852 L
.61526 .18745 L
.61527 .22446 L
Mistroke
.61529 .2155 L
.61529 .21462 L
.6153 .19948 L
.61532 .22882 L
.61533 .19257 L
.61535 .21575 L
.61536 .23029 L
.61537 .22718 L
.61538 .22603 L
.61539 .2351 L
.6154 .23718 L
.61541 .24734 L
.61542 .2221 L
.61543 .27514 L
.61544 .18582 L
.61545 .17072 L
.61546 .19857 L
.61547 .21424 L
.61549 .18017 L
.6155 .20751 L
.61552 .22664 L
.61552 .24914 L
.61553 .23776 L
.61555 .19265 L
.61556 .22405 L
.61557 .17548 L
.61558 .20904 L
.61559 .2288 L
.6156 .19801 L
.61561 .24492 L
.61562 .1996 L
.61563 .1766 L
.61564 .17694 L
.61566 .24206 L
.61567 .22009 L
.61568 .20113 L
.6157 .22697 L
.61571 .24175 L
.61572 .23965 L
.61573 .21345 L
.61575 .21684 L
.61576 .2238 L
.61578 .18224 L
.61579 .19432 L
.6158 .18144 L
.61581 .1514 L
.61582 .23223 L
.61584 .20728 L
.61585 .21932 L
.61586 .21906 L
Mistroke
.61588 .21211 L
.61589 .19668 L
.6159 .22463 L
.61592 .23734 L
.61593 .24176 L
.61594 .25166 L
.61596 .19267 L
.61597 .21381 L
.61599 .18392 L
.616 .23748 L
.61602 .15741 L
.61603 .21079 L
.61604 .21791 L
.61606 .22074 L
.61607 .20346 L
.61609 .17642 L
.6161 .19458 L
.61611 .18671 L
.61612 .19761 L
.61613 .22181 L
.61615 .20755 L
.61615 .23693 L
.61616 .22022 L
.61618 .21678 L
.61619 .21532 L
.6162 .2407 L
.6162 .21114 L
.61621 .20229 L
.61623 .18804 L
.61624 .1894 L
.61625 .2408 L
.61626 .24024 L
.61627 .25845 L
.61628 .21716 L
.61628 .23393 L
.61629 .19113 L
.61631 .2589 L
.61632 .20926 L
.61632 .25622 L
.61633 .24598 L
.61634 .20592 L
.61636 .17486 L
.61637 .22578 L
.61637 .24395 L
.61639 .22822 L
.6164 .20653 L
.61641 .24451 L
.61642 .231 L
.61644 .21877 L
.61645 .19613 L
Mistroke
.61646 .21704 L
.61648 .23297 L
.61649 .23842 L
.61651 .19712 L
.61652 .24463 L
.61654 .20307 L
.61654 .20244 L
.61655 .20278 L
.61657 .192 L
.61658 .18749 L
.61659 .23807 L
.61661 .20588 L
.61662 .16802 L
.61663 .19192 L
.61665 .16801 L
.61666 .28036 L
.61668 .17191 L
.61669 .19891 L
.61671 .16308 L
.61671 .19604 L
.61672 .20838 L
.61674 .21147 L
.61675 .206 L
.61676 .2143 L
.61677 .2341 L
.61678 .22124 L
.61679 .19527 L
.6168 .26375 L
.61681 .22593 L
.61682 .22233 L
.61683 .24092 L
.61684 .20424 L
.61685 .22828 L
.61687 .22011 L
.61688 .20867 L
.6169 .19633 L
.61691 .14936 L
.61692 .21081 L
.61694 .23396 L
.61695 .19769 L
.61696 .2343 L
.61697 .20917 L
.61698 .21885 L
.61699 .21286 L
.617 .19356 L
.61702 .19852 L
.61703 .20791 L
.61705 .2211 L
.61706 .18085 L
.61707 .20702 L
Mistroke
.61708 .17925 L
.61709 .24461 L
.61709 .23652 L
.61711 .2132 L
.61712 .23621 L
.61713 .23113 L
.61714 .23059 L
.61716 .22477 L
.61717 .22287 L
.61718 .19462 L
.61719 .19427 L
.61719 .2096 L
.6172 .21322 L
.61721 .15898 L
.61722 .21299 L
.61723 .23005 L
.61724 .17204 L
.61725 .21461 L
.61726 .1665 L
.61727 .19975 L
.61728 .25918 L
.61729 .21476 L
.61731 .2255 L
.61732 .2182 L
.61733 .22375 L
.61735 .16365 L
.61736 .16411 L
.61737 .21018 L
.61739 .19737 L
.6174 .2091 L
.61741 .19891 L
.61742 .1709 L
.61743 .26374 L
.61745 .21798 L
.61746 .17297 L
.61747 .24431 L
.61748 .24579 L
.6175 .17268 L
.61751 .21733 L
.61752 .20996 L
.61754 .2104 L
.61755 .23907 L
.61757 .23419 L
.61757 .21947 L
.61758 .25844 L
.6176 .19031 L
.61761 .23282 L
.61761 .19365 L
.61763 .1993 L
.61764 .20903 L
Mistroke
.61766 .18882 L
.61767 .18675 L
.61769 .20962 L
.6177 .22663 L
.61771 .21929 L
.61772 .2389 L
.61774 .20098 L
.61775 .23428 L
.61777 .23404 L
.61778 .22401 L
.61779 .22065 L
.61781 .24926 L
.61782 .17951 L
.61784 .23694 L
.61785 .18713 L
.61787 .23253 L
.61788 .22587 L
.61789 .21073 L
.6179 .22811 L
.61791 .18359 L
.61792 .21888 L
.61794 .19616 L
.61795 .25014 L
.61796 .21582 L
.61797 .20153 L
.61799 .21543 L
.61799 .22006 L
.618 .21914 L
.61802 .22643 L
.61803 .19419 L
.61805 .16629 L
.61806 .19128 L
.61808 .22995 L
.61809 .23012 L
.6181 .24064 L
.61812 .18563 L
.61813 .23982 L
.61815 .20584 L
.61816 .21201 L
.61818 .23263 L
.61818 .2096 L
.61819 .22774 L
.61821 .18295 L
.61822 .1935 L
.61824 .22139 L
.61825 .23284 L
.61826 .19776 L
.61827 .21332 L
.61828 .16111 L
.61829 .24352 L
Mistroke
.6183 .26056 L
.61831 .21563 L
.61832 .21123 L
.61838 .18488 L
.61839 .23041 L
.6184 .21359 L
.61841 .23113 L
.61843 .20044 L
.61844 .24554 L
.61845 .15792 L
.61845 .20819 L
.61846 .18167 L
.61848 .23649 L
.61849 .23584 L
.61851 .30445 L
.61852 .22112 L
.61853 .22234 L
.61854 .21727 L
.61855 .24037 L
.61857 .24537 L
.61858 .25829 L
.61859 .19599 L
.6186 .21371 L
.6186 .23223 L
.61861 .19431 L
.61862 .2349 L
.61863 .21871 L
.61864 .19762 L
.61865 .21876 L
.61867 .19076 L
.61868 .177 L
.6187 .22645 L
.61871 .24923 L
.61872 .22347 L
.61873 .20432 L
.61874 .26148 L
.61876 .21736 L
.61877 .21891 L
.61879 .23376 L
.6188 .24678 L
.61882 .16732 L
.61883 .2131 L
.61884 .16772 L
.61885 .24293 L
.61886 .21655 L
.61886 .21136 L
.61887 .22118 L
.61888 .20652 L
.6189 .22241 L
.61891 .20475 L
Mistroke
.61892 .22757 L
.61894 .23526 L
.61895 .21281 L
.61896 .25682 L
.61897 .21552 L
.61898 .19015 L
.619 .18511 L
.61901 .21932 L
.61901 .20813 L
.61902 .20162 L
.61903 .22669 L
.61905 .24241 L
.61906 .2487 L
.61906 .22241 L
.61908 .19304 L
.61909 .20986 L
.61911 .19405 L
.61912 .20187 L
.61914 .25653 L
.61915 .19599 L
.61916 .23693 L
.61918 .23834 L
.61919 .1809 L
.6192 .19236 L
.61923 .22327 L
.61924 .23595 L
.61926 .21063 L
.61927 .22278 L
.61928 .19781 L
.61929 .22804 L
.6193 .24024 L
.61932 .19953 L
.61933 .22585 L
.61934 .22626 L
.61936 .19823 L
.61937 .23828 L
.61939 .21859 L
.6194 .25572 L
.61942 .24912 L
.61942 .1698 L
.61943 .25207 L
.61945 .19459 L
.61946 .20097 L
.61947 .18011 L
.61949 .19896 L
.6195 .23437 L
.61951 .21944 L
.61953 .2403 L
.61954 .19465 L
.61956 .18117 L
Mistroke
.61957 .18599 L
.61958 .19375 L
.61959 .22832 L
.6196 .22891 L
.61962 .20376 L
.61963 .23499 L
.61964 .2291 L
.61965 .20225 L
.61966 .1832 L
.61967 .19459 L
.61968 .19157 L
.61969 .20651 L
.6197 .21025 L
.61971 .22603 L
.61972 .22782 L
.61973 .23819 L
.61974 .26098 L
.61975 .21064 L
.61976 .20156 L
.61977 .27068 L
.61979 .20873 L
.6198 .26118 L
.61982 .23466 L
.61983 .23962 L
.61984 .24296 L
.61986 .2173 L
.61988 .19013 L
.61989 .23861 L
.6199 .21138 L
.61991 .18954 L
.61992 .21256 L
.61994 .2108 L
.61995 .20767 L
.61996 .20012 L
.61998 .17722 L
.61999 .22221 L
.62 .22953 L
.62002 .21404 L
.62003 .20603 L
.62005 .23784 L
.62005 .16144 L
.62006 .21114 L
.62008 .20648 L
.62009 .23205 L
.62011 .22492 L
.62012 .22043 L
.62013 .23571 L
.62014 .22847 L
.62015 .26911 L
.62016 .22713 L
Mistroke
.62017 .19404 L
.62018 .23031 L
.62019 .20571 L
.62021 .24188 L
.62022 .26844 L
.62023 .25807 L
.62027 .22436 L
.62028 .17913 L
.6203 .18406 L
.62031 .21496 L
.62032 .23043 L
.62034 .25696 L
.62035 .22392 L
.62037 .20024 L
.62038 .21989 L
.6204 .17979 L
.6204 .19357 L
.62041 .22189 L
.62042 .22002 L
.62043 .222 L
.62044 .21071 L
.62046 .23238 L
.62047 .19068 L
.62048 .20838 L
.62049 .20307 L
.6205 .18118 L
.62051 .23418 L
.62052 .19623 L
.62054 .20485 L
.62055 .22376 L
.62056 .23177 L
.62058 .21636 L
.62059 .22705 L
.62061 .2233 L
.62062 .27197 L
.62064 .2469 L
.62065 .20413 L
.62066 .15456 L
.62068 .2502 L
.62069 .22997 L
.62071 .2145 L
.62072 .23055 L
.62073 .22243 L
.62074 .22172 L
.62076 .23989 L
.62077 .21402 L
.62079 .20038 L
.6208 .24043 L
.62082 .18858 L
.62083 .19993 L
Mistroke
.62084 .20476 L
.62086 .23376 L
.62087 .25713 L
.62089 .15651 L
.6209 .2157 L
.62091 .20464 L
.62093 .17748 L
.62094 .24159 L
.62095 .21186 L
.62096 .19698 L
.62098 .20549 L
.62099 .24736 L
.621 .2001 L
.62102 .22563 L
.62103 .19314 L
.62105 .22592 L
.62106 .22594 L
.62107 .2139 L
.62108 .24372 L
.6211 .23045 L
.62111 .24048 L
.62113 .17918 L
.62114 .19395 L
.62115 .20032 L
.62117 .23119 L
.62118 .20868 L
.62119 .21554 L
.6212 .22437 L
.62121 .23838 L
.62123 .24125 L
.62124 .22402 L
.62126 .23359 L
.62127 .21483 L
.62128 .21988 L
.6213 .21618 L
.62131 .24673 L
.62132 .22052 L
.62133 .2167 L
.62135 .2189 L
.62136 .23835 L
.62137 .22266 L
.62139 .26709 L
.6214 .22387 L
.62142 .21925 L
.62143 .16902 L
.62144 .22873 L
.62146 .26179 L
.62147 .20908 L
.62148 .20027 L
.62149 .28135 L
Mistroke
.6215 .22408 L
.62152 .22179 L
.62153 .22283 L
.62155 .23383 L
.62156 .23484 L
.62157 .1554 L
.62158 .20973 L
.62159 .22063 L
.6216 .23281 L
.62161 .24276 L
.62162 .2332 L
.62163 .20092 L
.62165 .21466 L
.62166 .23578 L
.62168 .19397 L
.62168 .19313 L
.62169 .22343 L
.62171 .20275 L
.62172 .17091 L
.62173 .21188 L
.62175 .21176 L
.62177 .20824 L
.62177 .19693 L
.62178 .20552 L
.6218 .24007 L
.62181 .21626 L
.62183 .24814 L
.62184 .19567 L
.62185 .20775 L
.62186 .20822 L
.62188 .22292 L
.62189 .13837 L
.62191 .21962 L
.62192 .20985 L
.62194 .19389 L
.62195 .25383 L
.62197 .19541 L
.62198 .20286 L
.62198 .24445 L
.62199 .23238 L
.622 .26165 L
.62202 .19467 L
.62203 .23057 L
.62203 .20207 L
.62204 .15651 L
.62205 .19079 L
.62207 .22642 L
.62208 .20977 L
.62209 .25062 L
.62211 .26065 L
Mistroke
.62212 .21439 L
.62213 .24115 L
.62214 .20831 L
.62215 .20021 L
.62217 .21046 L
.62218 .19882 L
.6222 .25444 L
.62221 .23168 L
.62223 .23212 L
.62224 .17844 L
.62226 .1663 L
.62227 .21277 L
.62228 .20148 L
.6223 .2455 L
.62231 .21685 L
.62233 .194 L
.62234 .21823 L
.62236 .19006 L
.62237 .24089 L
.62237 .20492 L
.62239 .24898 L
.6224 .24872 L
.62242 .22914 L
.62243 .23088 L
.62245 .26048 L
.62246 .20296 L
.62247 .17742 L
.62248 .22864 L
.6225 .23051 L
.62251 .1891 L
.62252 .18323 L
.62254 .24119 L
.62255 .23518 L
.62256 .23839 L
.62258 .23901 L
.62259 .19485 L
.6226 .21536 L
.62261 .22194 L
.62262 .23706 L
.62264 .21604 L
.62265 .21813 L
.62267 .20502 L
.62268 .24706 L
.6227 .25678 L
.62271 .2308 L
.62272 .21305 L
.62274 .19374 L
.62275 .22499 L
.62277 .19985 L
.62278 .23642 L
Mistroke
.6228 .19615 L
.62281 .24818 L
.62282 .21205 L
.62283 .24514 L
.62284 .18958 L
.62286 .27476 L
.62287 .22412 L
.62289 .25255 L
.6229 .19285 L
.62291 .19512 L
.62293 .26454 L
.62294 .24786 L
.62295 .26345 L
.62296 .25624 L
.62298 .22797 L
.62299 .25548 L
.62301 .22696 L
.62302 .19445 L
.62303 .24308 L
.62304 .22922 L
.62305 .23137 L
.62306 .20167 L
.62308 .24302 L
.62309 .20664 L
.62311 .23492 L
.62312 .21705 L
.62314 .21666 L
.62315 .23242 L
.62316 .19789 L
.62318 .21332 L
.62319 .22169 L
.62321 .20893 L
.62322 .19163 L
.62324 .21798 L
.62325 .23487 L
.62327 .19621 L
.62328 .23531 L
.62328 .22334 L
.6233 .20387 L
.62331 .21796 L
.62333 .23192 L
.62334 .22935 L
.62336 .21038 L
.62337 .22773 L
.62338 .19035 L
.62339 .20878 L
.62341 .19504 L
.62342 .26349 L
.62343 .25994 L
.62345 .22682 L
Mistroke
.62346 .21491 L
.62346 .23185 L
.62348 .17856 L
.62349 .24567 L
.62351 .22506 L
.62352 .20383 L
.62353 .21082 L
.62356 .22996 L
.62358 .22375 L
.62359 .2449 L
.62361 .2013 L
.62362 .20234 L
.62363 .23149 L
.62365 .19678 L
.62366 .20137 L
.62368 .20575 L
.62369 .23981 L
.62369 .28009 L
.6237 .19964 L
.62371 .19756 L
.62373 .26216 L
.62374 .23419 L
.62376 .22717 L
.62377 .1983 L
.62378 .20914 L
.6238 .2064 L
.62381 .25067 L
.62382 .20117 L
.62384 .23894 L
.62385 .22482 L
.62386 .24183 L
.62388 .23345 L
.62389 .25109 L
.6239 .19356 L
.62391 .22262 L
.62392 .20211 L
.62393 .22817 L
.62395 .21383 L
.62396 .2073 L
.62398 .24573 L
.62399 .17552 L
.62401 .27267 L
.62401 .20017 L
.62402 .21924 L
.62404 .18711 L
.62405 .18278 L
.62406 .20274 L
.62408 .24198 L
.62409 .20804 L
.62411 .27012 L
Mistroke
.62412 .23025 L
.62413 .21 L
.62414 .19672 L
.62414 .2221 L
.62415 .24841 L
.62417 .26764 L
.62418 .25554 L
.6242 .24703 L
.62421 .2232 L
.62423 .23207 L
.62424 .17949 L
.62425 .19858 L
.62427 .22727 L
.62428 .21882 L
.6243 .24725 L
.62431 .24152 L
.62433 .23011 L
.62434 .23989 L
.62436 .16999 L
.62437 .20841 L
.62438 .21839 L
.62439 .21023 L
.62441 .26429 L
.62442 .1918 L
.62444 .24087 L
.62445 .19162 L
.62446 .23228 L
.62448 .2386 L
.62449 .2176 L
.6245 .24889 L
.6245 .24026 L
.62451 .24207 L
.62453 .19909 L
.62454 .20292 L
.62455 .21192 L
.62456 .19884 L
.62457 .22096 L
.62459 .25881 L
.6246 .18241 L
.62462 .22681 L
.62463 .22374 L
.62464 .18622 L
.62466 .19113 L
.62467 .18437 L
.62468 .23327 L
.6247 .2472 L
.62471 .27284 L
.62472 .263 L
.62473 .18707 L
.62475 .26592 L
Mistroke
.62476 .2188 L
.62478 .24359 L
.62479 .16022 L
.6248 .18843 L
.62481 .17877 L
.62482 .2165 L
.62484 .19735 L
.62485 .21992 L
.62485 .23336 L
.62486 .25907 L
.62487 .2178 L
.62488 .2008 L
.62489 .20057 L
.6249 .17645 L
.62491 .24161 L
.62492 .22238 L
.62494 .18262 L
.62495 .1938 L
.62497 .23363 L
.62498 .25043 L
.62499 .23095 L
.62501 .24255 L
.62502 .1994 L
.62504 .28246 L
.62505 .24435 L
.62506 .21417 L
.62508 .19712 L
.62509 .19351 L
.62511 .21093 L
.62512 .25677 L
.62513 .21819 L
.62514 .21604 L
.62516 .20867 L
.62517 .19364 L
.62518 .2358 L
.6252 .21879 L
.62521 .23455 L
.62523 .20717 L
.62524 .21572 L
.62525 .21984 L
.62526 .22256 L
.62528 .22671 L
.62529 .21956 L
.6253 .24612 L
.62531 .21366 L
.62532 .21415 L
.62533 .22048 L
.62535 .24369 L
.62536 .17001 L
.62538 .26201 L
Mistroke
.62539 .20033 L
.62541 .23524 L
.62541 .20639 L
.62542 .2096 L
.62544 .23074 L
.62545 .21712 L
.62546 .20943 L
.62548 .25359 L
.62549 .20643 L
.6255 .27664 L
.62552 .22785 L
.62553 .26224 L
.62554 .26101 L
.62555 .18971 L
.62556 .2384 L
.62557 .2079 L
.62558 .23257 L
.6256 .22311 L
.62561 .21345 L
.62563 .21265 L
.62564 .20076 L
.62565 .22802 L
.62567 .18681 L
.62568 .24232 L
.62569 .23116 L
.62571 .24369 L
.62572 .21016 L
.62573 .24394 L
.62575 .2043 L
.62576 .18701 L
.62577 .202 L
.62579 .22906 L
.6258 .23186 L
.62582 .20775 L
.62583 .19937 L
.62585 .18972 L
.62586 .2265 L
.62588 .22281 L
.62589 .19575 L
.6259 .23302 L
.62591 .21261 L
.62592 .21901 L
.62594 .23551 L
.62595 .2328 L
.62595 .24573 L
.62597 .22226 L
.62598 .2512 L
.626 .2613 L
.62601 .20934 L
.62602 .25857 L
Mistroke
.62604 .22662 L
.62605 .20882 L
.62607 .24043 L
.62608 .23078 L
.6261 .21408 L
.62611 .22229 L
.62612 .18754 L
.62614 .19032 L
.62615 .16408 L
.62616 .2643 L
.62617 .22839 L
.62619 .21793 L
.62619 .21342 L
.6262 .20038 L
.62621 .19614 L
.62622 .21947 L
.62624 .22465 L
.62624 .25378 L
.62625 .24494 L
.62626 .24247 L
.62627 .26841 L
.62628 .1917 L
.62629 .17594 L
.62629 .23347 L
.6263 .2134 L
.62632 .23869 L
.62633 .2271 L
.62635 .22469 L
.62636 .22566 L
.62638 .24418 L
.62639 .21097 L
.6264 .21188 L
.62642 .24708 L
.62643 .18264 L
.62645 .2482 L
.62646 .20478 L
.62648 .20952 L
.62649 .22184 L
.6265 .24193 L
.62652 .20774 L
.62653 .22855 L
.62654 .21407 L
.62655 .21524 L
.62657 .23431 L
.62658 .26766 L
.62659 .21096 L
.62661 .24242 L
.62662 .19886 L
.62663 .18442 L
.62665 .21894 L
Mistroke
.62666 .20387 L
.62667 .22188 L
.62669 .25111 L
.6267 .2014 L
.62671 .20848 L
.62673 .23137 L
.62674 .18641 L
.62675 .19302 L
.62676 .21513 L
.62677 .2151 L
.62679 .18453 L
.6268 .26133 L
.62682 .20747 L
.62683 .2124 L
.62685 .2588 L
.62686 .23846 L
.62687 .21764 L
.62689 .25384 L
.6269 .2736 L
.62691 .19915 L
.62693 .25205 L
.62694 .20212 L
.62696 .20629 L
.62697 .22094 L
.62698 .20387 L
.62699 .20585 L
.62701 .1904 L
.62702 .25299 L
.62703 .24017 L
.62705 .21281 L
.62706 .17297 L
.62708 .18772 L
.62709 .21292 L
.6271 .27775 L
.62711 .19813 L
.62713 .26823 L
.62714 .24241 L
.62716 .24493 L
.62717 .22453 L
.62718 .21635 L
.6272 .25261 L
.6272 .25502 L
.62721 .22317 L
.62723 .191 L
.62724 .21529 L
.62726 .21123 L
.62726 .22063 L
.62727 .23988 L
.62729 .19881 L
.6273 .20595 L
Mistroke
.62731 .19801 L
.62733 .19854 L
.62734 .23401 L
.62735 .21701 L
.62737 .24373 L
.62738 .23131 L
.62739 .19281 L
.6274 .20822 L
.62741 .26011 L
.62742 .27745 L
.62743 .223 L
.62745 .23772 L
.62746 .26131 L
.62748 .24555 L
.62749 .24963 L
.6275 .20672 L
.62752 .19235 L
.62753 .21241 L
.62754 .20104 L
.62756 .17218 L
.62757 .21924 L
.62758 .23494 L
.6276 .2192 L
.62761 .2363 L
.62762 .24493 L
.62764 .23339 L
.62765 .25324 L
.62767 .22437 L
.62768 .20485 L
.6277 .2251 L
.62771 .22298 L
.62773 .26794 L
.62774 .20241 L
.62774 .19894 L
.62776 .27968 L
.62777 .21996 L
.62778 .21537 L
.62779 .20754 L
.6278 .20106 L
.62782 .22315 L
.62783 .19123 L
.62785 .19043 L
.62786 .18065 L
.62787 .25313 L
.62789 .19724 L
.6279 .23519 L
.62792 .18593 L
.62793 .17457 L
.62795 .20506 L
.62796 .25368 L
Mistroke
.62798 .26363 L
.62799 .21158 L
.62801 .24513 L
.62801 .2301 L
.62802 .16982 L
.62804 .25848 L
.62805 .23066 L
.62805 .19804 L
.62806 .21205 L
.62807 .20313 L
.62809 .17472 L
.62809 .21447 L
.6281 .22113 L
.62811 .24388 L
.62812 .19923 L
.62813 .21313 L
.62814 .22732 L
.62814 .18582 L
.62815 .24237 L
.62817 .2253 L
.62818 .23841 L
.6282 .22781 L
.62821 .17877 L
.62823 .23657 L
.62824 .21301 L
.62826 .17581 L
.62827 .23545 L
.62828 .24387 L
.6283 .21249 L
.62831 .22083 L
.62833 .20172 L
.62834 .23159 L
.62835 .2007 L
.62837 .2341 L
.62838 .21424 L
.62839 .23776 L
.6284 .23332 L
.62842 .26253 L
.62843 .2542 L
.62844 .23252 L
.62846 .22876 L
.62847 .22549 L
.62848 .22153 L
.6285 .21798 L
.62851 .17414 L
.62852 .25767 L
.62854 .23554 L
.62855 .18439 L
.62856 .22071 L
.62858 .2161 L
Mistroke
.62859 .19653 L
.6286 .19261 L
.62861 .20379 L
.62862 .22357 L
.62864 .21634 L
.62865 .22063 L
.62867 .25829 L
.62868 .22874 L
.6287 .24897 L
.62871 .2407 L
.62872 .18526 L
.62874 .19741 L
.62875 .21192 L
.62876 .2279 L
.62878 .23984 L
.62879 .2501 L
.62881 .19587 L
.62882 .20646 L
.62883 .18798 L
.62884 .2431 L
.62886 .2355 L
.62887 .21138 L
.62888 .23399 L
.6289 .22178 L
.62891 .21228 L
.62893 .25191 L
.62894 .20253 L
.62895 .18094 L
.62896 .20995 L
.62898 .21942 L
.62899 .2098 L
.62901 .28327 L
.62902 .19686 L
.62903 .17653 L
.62905 .21659 L
.62905 .20886 L
.62906 .25629 L
.62908 .24583 L
.62909 .25771 L
.62911 .19838 L
.62911 .18361 L
.62912 .16695 L
.62914 .18784 L
.62915 .2231 L
.62916 .21945 L
.62918 .23163 L
.62919 .22051 L
.6292 .22718 L
.62922 .20631 L
.62923 .20776 L
Mistroke
.62924 .21555 L
.62925 .23056 L
.62926 .21967 L
.62927 .23024 L
.62928 .26077 L
.6293 .22451 L
.62931 .22772 L
.62933 .25043 L
.62934 .21402 L
.62935 .24541 L
.62937 .22601 L
.62938 .24031 L
.62939 .24161 L
.62941 .17887 L
.62942 .23931 L
.62943 .22924 L
.62945 .24293 L
.62946 .2847 L
.62947 .21311 L
.62949 .24449 L
.6295 .21123 L
.62952 .21561 L
.62953 .22447 L
.62955 .19719 L
.62956 .21586 L
.62958 .19563 L
.62958 .2363 L
.62959 .20895 L
.6296 .22212 L
.62961 .24962 L
.62962 .21751 L
.62964 .18853 L
.62965 .19673 L
.62967 .22269 L
.62968 .24639 L
.6297 .2474 L
.62971 .18064 L
.62972 .22829 L
.62974 .23246 L
.62975 .27047 L
.62977 .21032 L
.62978 .24564 L
.6298 .24351 L
.62981 .25568 L
.62983 .2206 L
.62984 .19475 L
.62985 .21107 L
.62986 .23379 L
.62987 .18043 L
.62989 .22294 L
Mistroke
.6299 .19003 L
.6299 .23215 L
.62991 .23901 L
.62992 .22729 L
.62993 .23523 L
.62994 .23401 L
.62995 .23884 L
.62996 .23347 L
.62997 .24553 L
.62998 .18147 L
.62999 .19392 L
.62999 .20574 L
.63 .21301 L
.63002 .20573 L
.63003 .22551 L
.63005 .22056 L
.63006 .21255 L
.63009 .19861 L
.63011 .228 L
.63012 .20064 L
.63013 .22228 L
.63014 .17413 L
.63016 .24494 L
.63018 .22715 L
.63019 .23003 L
.6302 .17168 L
.63021 .20347 L
.63022 .24461 L
.63024 .23957 L
.63025 .22147 L
.63027 .21007 L
.63028 .2663 L
.63029 .23278 L
.63031 .24487 L
.63032 .24053 L
.63033 .25513 L
.63035 .16461 L
.63037 .22576 L
.63038 .17657 L
.63039 .2134 L
.6304 .17617 L
.63042 .18349 L
.63043 .22051 L
.63045 .22181 L
.63046 .25592 L
.63047 .17662 L
.63049 .21478 L
.6305 .26696 L
.63051 .2287 L
.63053 .21635 L
Mistroke
.63054 .22104 L
.63056 .24136 L
.63057 .20275 L
.63058 .23903 L
.6306 .24792 L
.63061 .23027 L
.63062 .20162 L
.63062 .20161 L
.63063 .2253 L
.63065 .23465 L
.63066 .26655 L
.63067 .1697 L
.63068 .23863 L
.63069 .23184 L
.63071 .22813 L
.63072 .20267 L
.63074 .21289 L
.63075 .21075 L
.63075 .21747 L
.63077 .20324 L
.63078 .18291 L
.63079 .20953 L
.6308 .23353 L
.63082 .2311 L
.63083 .25787 L
.63085 .21028 L
.63085 .24914 L
.63086 .19983 L
.63087 .23591 L
.63088 .2503 L
.63089 .20124 L
.63091 .20327 L
.63092 .18702 L
.63093 .22087 L
.63094 .2358 L
.63095 .26916 L
.63096 .17726 L
.63097 .23725 L
.63098 .2162 L
.63098 .21661 L
.63099 .22866 L
.63101 .27184 L
.63102 .24093 L
.63102 .20932 L
.63103 .18836 L
.63104 .22391 L
.63105 .20609 L
.63106 .19916 L
.63107 .2216 L
.63109 .23032 L
Mistroke
.6311 .23912 L
.63111 .24264 L
.63113 .24019 L
.63114 .20875 L
.63116 .19257 L
.63117 .22272 L
.63119 .19826 L
.6312 .20114 L
.63121 .19775 L
.63122 .23477 L
.63123 .1713 L
.63124 .23846 L
.63125 .25431 L
.63126 .20178 L
.63128 .24007 L
.63129 .19422 L
.63129 .22745 L
.63131 .2017 L
.63132 .22532 L
.63133 .222 L
.63134 .23452 L
.63134 .24651 L
.63136 .23048 L
.63137 .2207 L
.63138 .23186 L
.63139 .27732 L
.6314 .21825 L
.63141 .20738 L
.63142 .2402 L
.63144 .21902 L
.63145 .24995 L
.63147 .24113 L
.63148 .23609 L
.6315 .1769 L
.63151 .17951 L
.63152 .21676 L
.63153 .20395 L
.63154 .19829 L
.63154 .26308 L
.63155 .22791 L
.63156 .24063 L
.63157 .20102 L
.63158 .20924 L
.63159 .23119 L
.63161 .26948 L
.63162 .22761 L
.63162 .19496 L
.63164 .19417 L
.63165 .21151 L
.63167 .22872 L
Mistroke
.63168 .24492 L
.6317 .19677 L
.63171 .23782 L
.63173 .22413 L
.63174 .17381 L
.63176 .22477 L
.63176 .21469 L
.63177 .24491 L
.63179 .22336 L
.6318 .23579 L
.63182 .2123 L
.63183 .22367 L
.63184 .17346 L
.63185 .19902 L
.63187 .24989 L
.63188 .24025 L
.63189 .15453 L
.63191 .17492 L
.63192 .2446 L
.63193 .21688 L
.63195 .26014 L
.63196 .2398 L
.63198 .24639 L
.63199 .23423 L
.63202 .21265 L
.63203 .2334 L
.63204 .19935 L
.63205 .20549 L
.63208 .21305 L
.63209 .26564 L
.63211 .2227 L
.63212 .25301 L
.63213 .20358 L
.63214 .27092 L
.63214 .24634 L
.63216 .21591 L
.63217 .21003 L
.63218 .22838 L
.63219 .24574 L
.6322 .23133 L
.63222 .21619 L
.63223 .19595 L
.63224 .24715 L
.63226 .24963 L
.63227 .25974 L
.63227 .22878 L
.63229 .18034 L
.6323 .27258 L
.63232 .2313 L
.63233 .21034 L
Mistroke
.63234 .2016 L
.63235 .21171 L
.63237 .17901 L
.63238 .21749 L
.6324 .19937 L
.63241 .22872 L
.63243 .23808 L
.63244 .25574 L
.63245 .1978 L
.63247 .22442 L
.63248 .18668 L
.63248 .19551 L
.63251 .23017 L
.63253 .27144 L
.63254 .25702 L
.63256 .2043 L
.63257 .21537 L
.63258 .2171 L
.6326 .21078 L
.63261 .19079 L
.63262 .2526 L
.63264 .24125 L
.63265 .23259 L
.63267 .20208 L
.63268 .18053 L
.63268 .24587 L
.6327 .22915 L
.63271 .16874 L
.63273 .20378 L
.63274 .1713 L
.63275 .22101 L
.63276 .23109 L
.63277 .21765 L
.63278 .17085 L
.63279 .25264 L
.6328 .19741 L
.63281 .2203 L
.63282 .22059 L
.63282 .23043 L
.63283 .20074 L
.63284 .18317 L
.63286 .24973 L
.63287 .24561 L
.63289 .27563 L
.63289 .23973 L
.6329 .15985 L
.63292 .24087 L
.63293 .24233 L
.63294 .17245 L
.63295 .254 L
Mistroke
.63297 .17571 L
.63298 .20765 L
.63299 .2389 L
.633 .26862 L
.63301 .22424 L
.63302 .22992 L
.63303 .18302 L
.63304 .22163 L
.63306 .18952 L
.63307 .2249 L
.63308 .19776 L
.63309 .20459 L
.6331 .22553 L
.63311 .19272 L
.63312 .20813 L
.63313 .23213 L
.63314 .22317 L
.63316 .21007 L
.63317 .20442 L
.63318 .20199 L
.63319 .26552 L
.6332 .26132 L
.63321 .22126 L
.63322 .21251 L
.63323 .22979 L
.63324 .21259 L
.63324 .21605 L
.63325 .21282 L
.63327 .26203 L
.63328 .25195 L
.63329 .21248 L
.63331 .17395 L
.63332 .1988 L
.63333 .19629 L
.63334 .14758 L
.63335 .2337 L
.63337 .24243 L
.63338 .20179 L
.63339 .21561 L
.6334 .22414 L
.63341 .19556 L
.63343 .18957 L
.63344 .22747 L
.63346 .24567 L
.63347 .21014 L
.63348 .23685 L
.6335 .22224 L
.63351 .22071 L
.63352 .22637 L
.63353 .21322 L
Mistroke
.63354 .23575 L
.63355 .19732 L
.63356 .23706 L
.63358 .25681 L
.63358 .16891 L
.63359 .19589 L
.63361 .24411 L
.63362 .20454 L
.63363 .21496 L
.63365 .25507 L
.63366 .23228 L
.63368 .24769 L
.63369 .21319 L
.6337 .21789 L
.63371 .22601 L
.63373 .19203 L
.63374 .21675 L
.63375 .22756 L
.63377 .24573 L
.63378 .21319 L
.63379 .22887 L
.6338 .21307 L
.63381 .22148 L
.63383 .19793 L
.63384 .21684 L
.63386 .23224 L
.63387 .19506 L
.63389 .21345 L
.6339 .21409 L
.63391 .21266 L
.63393 .20567 L
.63394 .25004 L
.63395 .20617 L
.63397 .2548 L
.63398 .23498 L
.634 .20012 L
.63401 .23408 L
.63402 .1753 L
.63403 .23264 L
.63405 .21895 L
.63406 .20166 L
.63407 .25347 L
.63409 .24896 L
.6341 .22268 L
.63412 .20756 L
.63413 .20713 L
.63414 .25538 L
.63415 .21691 L
.63417 .19784 L
.63418 .23108 L
Mistroke
.63419 .18796 L
.63421 .22967 L
.63422 .20045 L
.63424 .19471 L
.63424 .23215 L
.63425 .2557 L
.63427 .2792 L
.63428 .18421 L
.63429 .23565 L
.63431 .21232 L
.63432 .24886 L
.63434 .21411 L
.63435 .21925 L
.63437 .20718 L
.63438 .21993 L
.63439 .24851 L
.63441 .2533 L
.63442 .24839 L
.63444 .19105 L
.63445 .2297 L
.63447 .17068 L
.63448 .26154 L
.63448 .27385 L
.6345 .2412 L
.63451 .22976 L
.63453 .26088 L
.63454 .21839 L
.63456 .2184 L
.63457 .22326 L
.63458 .24293 L
.63459 .1739 L
.63461 .22977 L
.63462 .18002 L
.63463 .24936 L
.63465 .22044 L
.63466 .26235 L
.63467 .24983 L
.63469 .15952 L
.6347 .20278 L
.6347 .2131 L
.63472 .23254 L
.63473 .21218 L
.63475 .25689 L
.63476 .23492 L
.63478 .20091 L
.63479 .20522 L
.63481 .20432 L
.63482 .19407 L
.63483 .21058 L
.63485 .2093 L
Mistroke
.63486 .22877 L
.63488 .25322 L
.63489 .23117 L
.6349 .26154 L
.63492 .25272 L
.63493 .21398 L
.63494 .25152 L
.63495 .23884 L
.63497 .22676 L
.63498 .22071 L
.63499 .24158 L
.63501 .17684 L
.63502 .17503 L
.63504 .26267 L
.63505 .26217 L
.63506 .20101 L
.63507 .2271 L
.63509 .22025 L
.6351 .19527 L
.63512 .25907 L
.63513 .23239 L
.63514 .25475 L
.63515 .24221 L
.63516 .21105 L
.63517 .23085 L
.63519 .23373 L
.63525 .2453 L
.63526 .2243 L
.63527 .21525 L
.63529 .25103 L
.6353 .25538 L
.63532 .17948 L
.63533 .22232 L
.63534 .23347 L
.63535 .20247 L
.63536 .23239 L
.63536 .22108 L
.63538 .23784 L
.63539 .25387 L
.63541 .23655 L
.63542 .23204 L
.63544 .22359 L
.63545 .21613 L
.63546 .24113 L
.63547 .26392 L
.63548 .26653 L
.6355 .19299 L
.63551 .20648 L
.63552 .19762 L
.63554 .19115 L
Mistroke
.63555 .19092 L
.63556 .2397 L
.63557 .24296 L
.63559 .20794 L
.6356 .16937 L
.63562 .23929 L
.63563 .2002 L
.63564 .21879 L
.63566 .19401 L
.63567 .20548 L
.63569 .25921 L
.6357 .22608 L
.63572 .25139 L
.63573 .25531 L
.63574 .18184 L
.63576 .1783 L
.63576 .23559 L
.63577 .20284 L
.63578 .19709 L
.63579 .27861 L
.6358 .22929 L
.63581 .20997 L
.63582 .22044 L
.63584 .30995 L
.63585 .21218 L
.63587 .24598 L
.63588 .1699 L
.6359 .24384 L
.6359 .2251 L
.63591 .25762 L
.63593 .25471 L
.63594 .24702 L
.63594 .22205 L
.63596 .22944 L
.63597 .20136 L
.63599 .18926 L
.636 .23856 L
.63601 .20478 L
.63602 .20796 L
.63603 .20436 L
.63604 .22202 L
.63605 .272 L
.63607 .20074 L
.63607 .21883 L
.63608 .18989 L
.6361 .22459 L
.63611 .22841 L
.63612 .22946 L
.63612 .22243 L
.63613 .17274 L
Mistroke
.63615 .177 L
.63616 .21674 L
.63618 .20892 L
.63619 .20014 L
.63621 .2549 L
.63622 .23592 L
.63623 .21155 L
.63625 .26274 L
.63625 .22914 L
.63626 .21343 L
.63627 .27665 L
.63628 .26206 L
.6363 .20557 L
.6363 .26577 L
.63631 .2594 L
.63633 .19155 L
.63634 .20206 L
.63636 .25181 L
.63637 .19229 L
.63638 .22455 L
.63639 .2471 L
.6364 .22991 L
.63642 .22254 L
.63643 .23213 L
.63643 .21991 L
.63645 .23168 L
.63646 .22597 L
.63648 .21837 L
.63649 .20499 L
.6365 .2676 L
.63651 .2123 L
.63652 .19976 L
.63652 .22128 L
.63654 .25125 L
.63656 .18223 L
.63656 .23046 L
.63657 .18338 L
.63659 .24236 L
.6366 .2258 L
.63661 .2617 L
.63661 .22934 L
.63662 .21968 L
.63663 .23242 L
.63664 .24673 L
.63665 .2561 L
.63667 .21875 L
.63668 .25932 L
.63669 .2708 L
.6367 .21641 L
.63672 .20481 L
Mistroke
.63672 .21173 L
.63673 .21578 L
.63675 .19672 L
.63676 .27216 L
.63678 .23666 L
.63679 .25686 L
.63681 .1973 L
.63682 .24689 L
.63683 .27335 L
.63684 .2277 L
.63686 .24363 L
.63687 .21951 L
.63689 .21441 L
.6369 .21352 L
.63691 .23966 L
.63692 .23364 L
.63694 .22005 L
.63695 .21565 L
.63696 .2321 L
.63698 .22624 L
.63699 .23477 L
.637 .24753 L
.637 .17937 L
.63701 .22652 L
.63702 .19586 L
.63703 .24536 L
.63704 .22384 L
.63705 .19355 L
.63706 .2395 L
.63707 .20023 L
.63708 .22616 L
.63709 .22734 L
.63711 .19815 L
.63713 .21827 L
.63713 .19661 L
.63714 .21458 L
.63716 .26825 L
.63717 .27445 L
.63718 .23659 L
.6372 .24104 L
.63721 .21872 L
.63722 .22592 L
.63724 .16885 L
.63725 .23899 L
.63726 .19497 L
.63727 .17965 L
.63728 .21814 L
.63729 .22493 L
.6373 .23298 L
.63732 .21096 L
Mistroke
.63733 .22117 L
.63735 .16966 L
.63736 .21889 L
.63737 .26718 L
.63739 .2452 L
.6374 .21325 L
.63742 .22002 L
.63743 .24973 L
.63745 .19286 L
.63746 .17978 L
.63747 .20512 L
.63749 .25271 L
.6375 .15712 L
.63751 .20016 L
.63753 .24193 L
.63754 .26182 L
.63755 .21421 L
.63757 .24138 L
.63758 .20332 L
.6376 .23041 L
.6376 .20494 L
.63761 .24132 L
.63762 .19037 L
.63763 .23931 L
.63764 .2456 L
.63766 .26343 L
.63767 .2415 L
.63769 .23194 L
.6377 .22707 L
.63772 .20949 L
.63773 .21089 L
.63774 .24885 L
.63776 .25001 L
.63777 .17788 L
.63779 .22127 L
.6378 .19227 L
.63782 .22575 L
.63783 .2509 L
.63785 .23444 L
.63786 .21599 L
.63788 .23388 L
.63788 .21555 L
.63789 .23219 L
.63791 .24286 L
.63792 .22779 L
.63792 .21571 L
.63793 .22958 L
.63794 .25417 L
.63796 .20966 L
.63796 .24876 L
Mistroke
.63797 .23777 L
.63798 .26361 L
.63799 .2076 L
.63801 .22188 L
.63802 .26539 L
.63804 .19781 L
.63804 .25881 L
.63805 .21695 L
.63807 .20582 L
.63808 .21415 L
.63809 .20035 L
.63811 .1922 L
.63812 .24023 L
.63813 .20179 L
.63814 .25289 L
.63816 .19761 L
.63817 .19643 L
.63818 .22908 L
.6382 .19061 L
.63821 .17765 L
.63822 .2732 L
.63824 .19173 L
.63825 .23036 L
.63826 .19527 L
.63828 .20782 L
.63829 .23552 L
.6383 .22339 L
.63831 .25639 L
.63832 .20489 L
.63834 .20838 L
.63835 .19967 L
.63836 .19564 L
.63837 .20391 L
.63838 .19916 L
.63839 .20491 L
.6384 .24709 L
.63841 .27566 L
.63842 .24641 L
.63843 .17966 L
.63844 .23683 L
.63845 .21412 L
.63847 .20534 L
.63848 .23703 L
.6385 .23214 L
.63851 .23049 L
.63853 .25748 L
.63853 .23745 L
.63854 .19469 L
.63856 .24891 L
.63857 .22041 L
Mistroke
.63858 .21587 L
.63859 .18711 L
.6386 .23553 L
.63862 .22841 L
.63863 .23096 L
.63865 .23972 L
.63866 .22764 L
.63866 .21387 L
.63867 .25099 L
.63868 .20997 L
.6387 .20116 L
.63871 .24497 L
.63872 .23752 L
.63873 .22202 L
.63874 .18716 L
.63875 .26023 L
.63876 .24072 L
.63877 .25393 L
.63878 .21022 L
.6388 .22627 L
.63881 .21483 L
.63882 .25787 L
.63883 .23424 L
.63884 .20452 L
.63885 .25 L
.63887 .22901 L
.63888 .20112 L
.6389 .18713 L
.6389 .22885 L
.63891 .20965 L
.63893 .20891 L
.63894 .22471 L
.63894 .21788 L
.63895 .22625 L
.63896 .30129 L
.63898 .26014 L
.63898 .26862 L
.63899 .23021 L
.63901 .20435 L
.63902 .21322 L
.63904 .21306 L
.63904 .21966 L
.63905 .19169 L
.63907 .19975 L
.63908 .20417 L
.6391 .20599 L
.63911 .19245 L
.63912 .23183 L
.63914 .20181 L
.63915 .25001 L
Mistroke
.63916 .26423 L
.63917 .25291 L
.63918 .23413 L
.63919 .24907 L
.6392 .2303 L
.63921 .25666 L
.63923 .26296 L
.63925 .19181 L
.63926 .25087 L
.63927 .24869 L
.63929 .23677 L
.6393 .20464 L
.63931 .21108 L
.63932 .24986 L
.63934 .24856 L
.63935 .20431 L
.63937 .19683 L
.63938 .2265 L
.63939 .24159 L
.63941 .18554 L
.63942 .24734 L
.63944 .24442 L
.63945 .21225 L
.63946 .25798 L
.63948 .22609 L
.63949 .21841 L
.6395 .17155 L
.63951 .2509 L
.63953 .22526 L
.63953 .18633 L
.63954 .23399 L
.63956 .26792 L
.63957 .22114 L
.63958 .23825 L
.63959 .25839 L
.6396 .19262 L
.63962 .20353 L
.63963 .18383 L
.63965 .24641 L
.63966 .23758 L
.63967 .19966 L
.63969 .23365 L
.6397 .26546 L
.63972 .21798 L
.63973 .23187 L
.63975 .19809 L
.63975 .18281 L
.63976 .2509 L
.63978 .24772 L
.63979 .24655 L
Mistroke
.63981 .18647 L
.63982 .22532 L
.63984 .24428 L
.63984 .24133 L
.63985 .22254 L
.63987 .23834 L
.63988 .22069 L
.63988 .2243 L
.63989 .20081 L
.6399 .2191 L
.63991 .24226 L
.63992 .235 L
.63993 .25769 L
.63994 .25957 L
.63995 .22092 L
.63997 .22893 L
.63998 .21016 L
.63999 .18999 L
.64 .2024 L
.64001 .27677 L
.64003 .24885 L
.64004 .23053 L
.64005 .21935 L
.64007 .26864 L
.64008 .22954 L
.6401 .21355 L
.6401 .25719 L
.64011 .20795 L
.64013 .23308 L
.64014 .22421 L
.64014 .22171 L
.64016 .23426 L
.64017 .24893 L
.64019 .19276 L
.6402 .26495 L
.64022 .22576 L
.64023 .27232 L
.64024 .23113 L
.64025 .22816 L
.64027 .22457 L
.64028 .23364 L
.6403 .17983 L
.64031 .27439 L
.64032 .19477 L
.64034 .23317 L
.64035 .24052 L
.64036 .23691 L
.64038 .23578 L
.64039 .2365 L
.64041 .23582 L
Mistroke
.64042 .25273 L
.64044 .2606 L
.64045 .23209 L
.64046 .24574 L
.64047 .22859 L
.64048 .20595 L
.64049 .2051 L
.6405 .24782 L
.64051 .20707 L
.64053 .24462 L
.64055 .23653 L
.64056 .21047 L
.64057 .25321 L
.64059 .21708 L
.6406 .20712 L
.64061 .2187 L
.64063 .20811 L
.64064 .20019 L
.64066 .20428 L
.64067 .20363 L
.64069 .23547 L
.6407 .27345 L
.64071 .22828 L
.64072 .22857 L
.64074 .21541 L
.64075 .24816 L
.64077 .23535 L
.64078 .23418 L
.64084 .22943 L
.64085 .23686 L
.64086 .24928 L
.64087 .23046 L
.64088 .22749 L
.64089 .17037 L
.6409 .2621 L
.64091 .244 L
.64092 .18696 L
.64093 .25638 L
.64094 .22925 L
.64096 .16593 L
.64097 .15923 L
.64098 .19034 L
.64099 .25033 L
.64099 .22124 L
.641 .21999 L
.64101 .19044 L
.64102 .24942 L
.64104 .24143 L
.64105 .20166 L
.64106 .24009 L
Mistroke
.64107 .24141 L
.64108 .19745 L
.6411 .23247 L
.64111 .2809 L
.64112 .25535 L
.64114 .26154 L
.64115 .24586 L
.64117 .23967 L
.64118 .26116 L
.6412 .23036 L
.64121 .22716 L
.64121 .24317 L
.64123 .2316 L
.64124 .2048 L
.64126 .21216 L
.64127 .21309 L
.64128 .2261 L
.6413 .23529 L
.64131 .22394 L
.64132 .24804 L
.64134 .18713 L
.64135 .21967 L
.64136 .22858 L
.64138 .24876 L
.64139 .19087 L
.64141 .25524 L
.64142 .22668 L
.64144 .26214 L
.64145 .26217 L
.64146 .23183 L
.64148 .26219 L
.64149 .26815 L
.64151 .20523 L
.64151 .21539 L
.64152 .26904 L
.64154 .20243 L
.64155 .2736 L
.64156 .27674 L
.64157 .18987 L
.64158 .25824 L
.64159 .21949 L
.6416 .21268 L
.64161 .17949 L
.64162 .23081 L
.64163 .26721 L
.64165 .22568 L
.64166 .22664 L
.64166 .24883 L
.64167 .20848 L
.64168 .21513 L
Mistroke
.64169 .28857 L
.6417 .19552 L
.64171 .21766 L
.64172 .2264 L
.64173 .22403 L
.64174 .22663 L
.64175 .18744 L
.64176 .24235 L
.64177 .21646 L
.64178 .2707 L
.64179 .24271 L
.6418 .22798 L
.64181 .20261 L
.64183 .24085 L
.64184 .24974 L
.64186 .23383 L
.64187 .25653 L
.64188 .20629 L
.6419 .20193 L
.64191 .1873 L
.64193 .23532 L
.64194 .24389 L
.64195 .25585 L
.64196 .19668 L
.64197 .21636 L
.64199 .22073 L
.642 .23335 L
.64201 .25657 L
.64202 .24781 L
.64204 .19576 L
.64205 .22475 L
.64207 .21849 L
.64208 .21511 L
.64209 .24419 L
.64211 .22724 L
.64212 .26205 L
.64213 .22181 L
.64214 .22629 L
.64215 .2134 L
.64216 .212 L
.64217 .22483 L
.64219 .19465 L
.64219 .22698 L
.6422 .22794 L
.64221 .23194 L
.64222 .24121 L
.64224 .19299 L
.64224 .23252 L
.64225 .2229 L
.64227 .16595 L
Mistroke
.64228 .22017 L
.6423 .23997 L
.64231 .21231 L
.64233 .21162 L
.64234 .22694 L
.64235 .25206 L
.64236 .18935 L
.64237 .20672 L
.6424 .23694 L
.64242 .1903 L
.64243 .26282 L
.64245 .23631 L
.64246 .22729 L
.64248 .21202 L
.64249 .24141 L
.64249 .22993 L
.64251 .23941 L
.64253 .24752 L
.64254 .25646 L
.64255 .21373 L
.64256 .26682 L
.64257 .22711 L
.64258 .19226 L
.64259 .23242 L
.64259 .20733 L
.64261 .19997 L
.64262 .20972 L
.64264 .21772 L
.64265 .21835 L
.64266 .22412 L
.64266 .2601 L
.64267 .20627 L
.64268 .26381 L
.64269 .20801 L
.6427 .25823 L
.64271 .19505 L
.64272 .27164 L
.64274 .25627 L
.64275 .22902 L
.64276 .18476 L
.64278 .2145 L
.64279 .26532 L
.6428 .20715 L
.64281 .23475 L
.64282 .21409 L
.64284 .21339 L
.64285 .21961 L
.64286 .23063 L
.64288 .23212 L
.64289 .24141 L
Mistroke
.64291 .22791 L
.64292 .23742 L
.64292 .19145 L
.64294 .21495 L
.64295 .18908 L
.64297 .24554 L
.64298 .19463 L
.643 .20201 L
.64301 .24263 L
.64303 .21424 L
.64304 .23744 L
.64304 .20686 L
.64305 .22432 L
.64306 .24108 L
.64307 .21438 L
.64308 .24713 L
.64309 .27162 L
.6431 .2501 L
.64312 .21412 L
.64313 .20282 L
.64315 .24403 L
.64316 .25519 L
.64317 .16933 L
.64318 .24696 L
.6432 .23381 L
.64321 .2097 L
.64323 .24148 L
.64324 .2222 L
.64325 .25433 L
.64326 .22543 L
.64327 .25113 L
.64328 .1952 L
.6433 .21888 L
.64331 .20193 L
.64332 .21374 L
.64333 .21027 L
.64334 .22478 L
.64336 .21737 L
.64337 .2112 L
.64338 .19502 L
.6434 .24538 L
.64341 .2085 L
.64343 .20556 L
.64344 .26611 L
.64345 .2279 L
.64346 .23058 L
.64347 .23145 L
.64348 .20745 L
.64349 .23527 L
.64351 .23671 L
Mistroke
.64352 .25031 L
.64354 .20453 L
.64355 .211 L
.64356 .21387 L
.64357 .20071 L
.64359 .22128 L
.6436 .18395 L
.64362 .22833 L
.64363 .25461 L
.64364 .19897 L
.64366 .2356 L
.64367 .22806 L
.64368 .18266 L
.6437 .21112 L
.64371 .21453 L
.64373 .24641 L
.64374 .23846 L
.64376 .2337 L
.64377 .23185 L
.64379 .1689 L
.64379 .20682 L
.6438 .20508 L
.64381 .20407 L
.64382 .22178 L
.64383 .23178 L
.64385 .2403 L
.64386 .26336 L
.64386 .2344 L
.64388 .23231 L
.64389 .18184 L
.64391 .28863 L
.64392 .2861 L
.64394 .21243 L
.64395 .22884 L
.64396 .21068 L
.64398 .22228 L
.64399 .24039 L
.64401 .26636 L
.64402 .2258 L
.64403 .22064 L
.64404 .26641 L
.64405 .24074 L
.64407 .19179 L
.64408 .21314 L
.6441 .25046 L
.64411 .17549 L
.64412 .18448 L
.64413 .23714 L
.64414 .19192 L
.64415 .21512 L
Mistroke
.64416 .28296 L
.64417 .2411 L
.64418 .23613 L
.64419 .19218 L
.6442 .18577 L
.6442 .22113 L
.64421 .20047 L
.64423 .19283 L
.64424 .24513 L
.64426 .23124 L
.64427 .21752 L
.64429 .2613 L
.6443 .19568 L
.64432 .22371 L
.64433 .25461 L
.64434 .25469 L
.64436 .25506 L
.64437 .16429 L
.64439 .22654 L
.6444 .21936 L
.64441 .25187 L
.64443 .25973 L
.64444 .20907 L
.64445 .22204 L
.64446 .22348 L
.64448 .22508 L
.64449 .23445 L
.6445 .23659 L
.64452 .25572 L
.64453 .20364 L
.64455 .17179 L
.64456 .24851 L
.64457 .18033 L
.64458 .22364 L
.6446 .20841 L
.64461 .24912 L
.64463 .22914 L
.64464 .25802 L
.64465 .24226 L
.64466 .19974 L
.64467 .21747 L
.64468 .27781 L
.6447 .2073 L
.64471 .23222 L
.64472 .22104 L
.64473 .21302 L
.64474 .19736 L
.64476 .21044 L
.64477 .26564 L
.64478 .20798 L
Mistroke
.6448 .25235 L
.64481 .23694 L
.64483 .25445 L
.64483 .25944 L
.64484 .23247 L
.64486 .23587 L
.64487 .22365 L
.64488 .22731 L
.64489 .22105 L
.64491 .24628 L
.64492 .22218 L
.64493 .20668 L
.64495 .21061 L
.64496 .2139 L
.64497 .21001 L
.64498 .24657 L
.645 .25799 L
.64501 .21591 L
.64503 .21834 L
.64504 .21443 L
.64506 .18963 L
.64507 .24538 L
.64508 .23011 L
.6451 .21607 L
.64511 .23151 L
.64513 .22638 L
.64514 .26414 L
.64515 .20807 L
.64517 .22866 L
.64518 .24178 L
.64519 .25489 L
.6452 .20602 L
.64521 .21685 L
.64522 .22674 L
.64523 .17711 L
.64525 .16148 L
.64526 .23477 L
.64528 .24308 L
.64529 .22367 L
.6453 .21107 L
.64532 .23672 L
.64533 .23481 L
.64534 .204 L
.64536 .22224 L
.64538 .21614 L
.64539 .21401 L
.6454 .26611 L
.64542 .22209 L
.64543 .24849 L
.64545 .21186 L
Mistroke
.64546 .2369 L
.64547 .21426 L
.64548 .20977 L
.64549 .25125 L
.6455 .23283 L
.64551 .2349 L
.64552 .19558 L
.64553 .19966 L
.64554 .21465 L
.64555 .25137 L
.64556 .19906 L
.64557 .21988 L
.64558 .26068 L
.64559 .23833 L
.64561 .23651 L
.64562 .21509 L
.64563 .22111 L
.64564 .19972 L
.64566 .18546 L
.64567 .23412 L
.64568 .21946 L
.6457 .22283 L
.64573 .23097 L
.64573 .2453 L
.64574 .26136 L
.64576 .24104 L
.64577 .22821 L
.64579 .21451 L
.6458 .23035 L
.64581 .18763 L
.64583 .27555 L
.64584 .23443 L
.64585 .1994 L
.64587 .24639 L
.64587 .25544 L
.64588 .17463 L
.6459 .19001 L
.64591 .24184 L
.64591 .20314 L
.64592 .22864 L
.64593 .24498 L
.64594 .26704 L
.64595 .24784 L
.64596 .20105 L
.64596 .22314 L
.64598 .19618 L
.64599 .22941 L
.64601 .20677 L
.64602 .18631 L
.64603 .22726 L
Mistroke
.64604 .20705 L
.64606 .19374 L
.64607 .25344 L
.64608 .22533 L
.6461 .23225 L
.64611 .25048 L
.64613 .28749 L
.64614 .25957 L
.64614 .2052 L
.64616 .2067 L
.64617 .22731 L
.64618 .19833 L
.64619 .23342 L
.6462 .20234 L
.64622 .21427 L
.64623 .19691 L
.64624 .1827 L
.64625 .23342 L
.64626 .23789 L
.64627 .2801 L
.64628 .26346 L
.6463 .20141 L
.64631 .27516 L
.64632 .22895 L
.64633 .22732 L
.64634 .19217 L
.64635 .24384 L
.64636 .24162 L
.64637 .20549 L
.64638 .23534 L
.64638 .21716 L
.6464 .24498 L
.64641 .21662 L
.64643 .18269 L
.64644 .20753 L
.64645 .2632 L
.64646 .2186 L
.64647 .20122 L
.64648 .19176 L
.64648 .19488 L
.64649 .22768 L
.64651 .19852 L
.64652 .20072 L
.64653 .20121 L
.64655 .24576 L
.64656 .21263 L
.64657 .20226 L
.64658 .2514 L
.64659 .20428 L
.64661 .28125 L
Mistroke
.64662 .24372 L
.64663 .2255 L
.64664 .21893 L
.64665 .21695 L
.64667 .1842 L
.64668 .23993 L
.6467 .24349 L
.64671 .23373 L
.64672 .16741 L
.64674 .2539 L
.64675 .23577 L
.64676 .24793 L
.64677 .25552 L
.64678 .22548 L
.64679 .24534 L
.6468 .23769 L
.64682 .2326 L
.64683 .21229 L
.64685 .23493 L
.64686 .20128 L
.64687 .24141 L
.64689 .21675 L
.6469 .20165 L
.64691 .22449 L
.64693 .2529 L
.64694 .20748 L
.64695 .23419 L
.64697 .21377 L
.64698 .23797 L
.64699 .22623 L
.64701 .25602 L
.64702 .24756 L
.64704 .21533 L
.64705 .24268 L
.64707 .20506 L
.64707 .28477 L
.64708 .26094 L
.6471 .27101 L
.64711 .23791 L
.64712 .17853 L
.64713 .2365 L
.64715 .23999 L
.64716 .19255 L
.64717 .1781 L
.64718 .20876 L
.64719 .20184 L
.6472 .2662 L
.64722 .21648 L
.64723 .20401 L
.64725 .23174 L
Mistroke
.64726 .21307 L
.64727 .24584 L
.64729 .20595 L
.6473 .22028 L
.64732 .25726 L
.64733 .24582 L
.64734 .23884 L
.64735 .20162 L
.64736 .20528 L
.64738 .27064 L
.64739 .21724 L
.64741 .20635 L
.64742 .20821 L
.64743 .22084 L
.64744 .26623 L
.64746 .24281 L
.64746 .20704 L
.64747 .23244 L
.64748 .19797 L
.64749 .20841 L
.6475 .22361 L
.64751 .20419 L
.64752 .20596 L
.64752 .23709 L
.64754 .25705 L
.64755 .2096 L
.64757 .20558 L
.64758 .26738 L
.64758 .26189 L
.6476 .20755 L
.64761 .22094 L
.64763 .21639 L
.64764 .22553 L
.64765 .23066 L
.64767 .2376 L
.64768 .23959 L
.64768 .2604 L
.6477 .25537 L
.64771 .23189 L
.64772 .22184 L
.64773 .22169 L
.64775 .2324 L
.64776 .21537 L
.64778 .23735 L
.64779 .26627 L
.6478 .21362 L
.64782 .22112 L
.64783 .20757 L
.64784 .18689 L
.64785 .22014 L
Mistroke
.64787 .22384 L
.64788 .20581 L
.6479 .28617 L
.64791 .21862 L
.64793 .24959 L
.64794 .2204 L
.64795 .25259 L
.64797 .26047 L
.64798 .17044 L
.648 .23044 L
.64801 .24002 L
.64803 .26 L
.64804 .23753 L
.64805 .19353 L
.64806 .23994 L
.64807 .22061 L
.64807 .24394 L
.64809 .24828 L
.6481 .28067 L
.64812 .27235 L
.64813 .26473 L
.64815 .24971 L
.64816 .2615 L
.64817 .21521 L
.64819 .28392 L
.6482 .24616 L
.64822 .27353 L
.64823 .18471 L
.64825 .23041 L
.64826 .22137 L
.64828 .24825 L
.64829 .23022 L
.6483 .20883 L
.64832 .2204 L
.64833 .24337 L
.64834 .20537 L
.64835 .22082 L
.64836 .2222 L
.64837 .26286 L
.64838 .23989 L
.64838 .26514 L
.6484 .24484 L
.64841 .22971 L
.64842 .27708 L
.64842 .21877 L
.64843 .22875 L
.64844 .20802 L
.64845 .22767 L
.64846 .27702 L
.64847 .22026 L
Mistroke
.64848 .23209 L
.6485 .24453 L
.64851 .23643 L
.64853 .2163 L
.64854 .2268 L
.64856 .26595 L
.64857 .23656 L
.64858 .24612 L
.6486 .2196 L
.64861 .23821 L
.64862 .17729 L
.64864 .20454 L
.64865 .20715 L
.64867 .22164 L
.64868 .19908 L
.64869 .25232 L
.6487 .27129 L
.64872 .21907 L
.64873 .24235 L
.64874 .20476 L
.64876 .2056 L
.64877 .22206 L
.64879 .23078 L
.6488 .25154 L
.64881 .23362 L
.64882 .20137 L
.64884 .23569 L
.64885 .20335 L
.64887 .2046 L
.64888 .20314 L
.64889 .19836 L
.64891 .21761 L
.64891 .24122 L
.64892 .26457 L
.64894 .21406 L
.64895 .24508 L
.64897 .21821 L
.64897 .21834 L
.64898 .19802 L
.649 .25734 L
.64901 .23991 L
.64902 .26195 L
.64904 .25792 L
.64905 .21516 L
.64906 .19868 L
.64908 .24495 L
.64909 .21171 L
.6491 .23953 L
.64911 .26495 L
.64912 .28278 L
Mistroke
.64913 .16902 L
.64914 .24193 L
.64916 .24566 L
.64917 .20827 L
.64919 .23449 L
.6492 .21722 L
.64921 .22661 L
.64923 .2148 L
.64924 .20475 L
.64925 .2128 L
.64927 .20741 L
.64928 .2248 L
.64929 .24757 L
.64931 .24874 L
.64932 .1916 L
.64933 .21419 L
.64935 .22029 L
.64936 .23808 L
.64938 .23304 L
.64939 .24483 L
.64941 .23352 L
.64942 .23373 L
.64944 .22022 L
.64944 .22139 L
.64945 .23833 L
.64946 .22145 L
.64947 .25991 L
.64948 .22039 L
.6495 .19067 L
.64951 .20905 L
.64953 .27674 L
.64954 .26892 L
.64956 .21542 L
.64957 .23344 L
.64958 .24839 L
.6496 .19525 L
.64961 .24421 L
.64963 .25471 L
.64964 .20584 L
.64966 .24054 L
.64967 .22588 L
.64969 .25056 L
.6497 .23451 L
.64971 .2478 L
.64972 .19114 L
.64973 .21813 L
.64975 .22976 L
.64976 .25018 L
.64976 .25727 L
.64977 .24417 L
Mistroke
.64978 .24023 L
.64979 .26119 L
.6498 .21951 L
.64981 .20454 L
.64982 .21964 L
.64983 .24604 L
.64984 .20247 L
.64985 .23624 L
.64985 .18223 L
.64986 .26575 L
.64988 .23104 L
.64989 .21667 L
.64991 .21309 L
.64992 .24447 L
.64994 .22856 L
.64995 .22124 L
.64996 .25403 L
.64998 .22528 L
.64999 .21922 L
.65 .22955 L
.65002 .20502 L
.65004 .27424 L
.65005 .2244 L
.65006 .20177 L
.65008 .27662 L
.65009 .22674 L
.6501 .19812 L
.65011 .19983 L
.65013 .25431 L
.65014 .23508 L
.65015 .2113 L
.65017 .2391 L
.65018 .26332 L
.65019 .19059 L
.65021 .23477 L
.65022 .20687 L
.65023 .20982 L
.65025 .2362 L
.65026 .22127 L
.65027 .26042 L
.65029 .2077 L
.6503 .21551 L
.65031 .19423 L
.65032 .22343 L
.65033 .21965 L
.65035 .22629 L
.65036 .264 L
.65038 .22552 L
.65039 .15788 L
.65041 .21719 L
Mistroke
.65042 .26134 L
.65043 .18861 L
.65045 .27997 L
.65046 .21124 L
.65047 .23293 L
.65049 .24421 L
.6505 .23233 L
.65052 .23707 L
.65053 .24204 L
.65054 .26084 L
.65055 .2317 L
.65057 .22915 L
.65058 .24279 L
.65059 .22034 L
.65061 .19319 L
.65062 .20375 L
.65064 .24224 L
.65065 .21242 L
.65066 .22093 L
.65067 .22118 L
.65069 .24506 L
.6507 .2791 L
.65071 .24387 L
.65073 .2406 L
.65074 .23774 L
.65076 .19539 L
.65077 .25053 L
.65078 .22839 L
.65079 .22267 L
.6508 .22816 L
.65082 .2249 L
.65083 .22688 L
.65085 .22616 L
.65086 .2315 L
.65087 .2419 L
.65088 .19784 L
.65089 .21967 L
.65091 .25188 L
.65092 .23548 L
.65093 .28284 L
.65095 .25218 L
.65096 .23092 L
.65098 .24959 L
.65099 .24647 L
.651 .22292 L
.65102 .20075 L
.65103 .20835 L
.65106 .23244 L
.65107 .22179 L
.65108 .20351 L
Mistroke
.65109 .25907 L
.65111 .18708 L
.65112 .25028 L
.65114 .2569 L
.65115 .24898 L
.65116 .23999 L
.65117 .20623 L
.65118 .20966 L
.65119 .19697 L
.6512 .22794 L
.65121 .22023 L
.65122 .24813 L
.65123 .15507 L
.65125 .24098 L
.65126 .18236 L
.65127 .26607 L
.65128 .18328 L
.65129 .24632 L
.65131 .19953 L
.65133 .25948 L
.65134 .25899 L
.65135 .25364 L
.65137 .23487 L
.65138 .27052 L
.6514 .23079 L
.65141 .22288 L
.65143 .22868 L
.65144 .19674 L
.65145 .21178 L
.65147 .22314 L
.65148 .2472 L
.65149 .20352 L
.6515 .19622 L
.65151 .21842 L
.65152 .23176 L
.65153 .23827 L
.65155 .2619 L
.65156 .23838 L
.65157 .24682 L
.65159 .2629 L
.6516 .23221 L
.65162 .19718 L
.65163 .23692 L
.65165 .22885 L
.65166 .24157 L
.65167 .1985 L
.65169 .2611 L
.6517 .24632 L
.65171 .2323 L
.65173 .23389 L
Mistroke
.65174 .21593 L
.65175 .20984 L
.65176 .23562 L
.65177 .2425 L
.65179 .26234 L
.6518 .22766 L
.6518 .22178 L
.65182 .2254 L
.65183 .22513 L
.65185 .23351 L
.65186 .22821 L
.65187 .21525 L
.65188 .26374 L
.65189 .24293 L
.6519 .28638 L
.65191 .26357 L
.65193 .25177 L
.65193 .22333 L
.65194 .23678 L
.65196 .21396 L
.65197 .21198 L
.65198 .28077 L
.65199 .22318 L
.652 .24254 L
.65201 .25571 L
.65202 .20684 L
.65204 .21075 L
.65205 .21099 L
.65206 .23892 L
.65207 .23986 L
.65208 .2233 L
.65209 .20258 L
.6521 .18222 L
.6521 .20782 L
.65211 .2747 L
.65212 .19565 L
.65213 .26883 L
.65215 .23663 L
.65216 .24941 L
.65218 .26648 L
.65219 .26041 L
.6522 .20569 L
.65221 .24247 L
.65222 .25507 L
.65224 .25655 L
.65225 .29783 L
.65226 .27072 L
.65227 .19397 L
.65228 .2266 L
.6523 .22956 L
Mistroke
.65231 .18578 L
.65232 .258 L
.65234 .21635 L
.65235 .22774 L
.65237 .25808 L
.65238 .2375 L
.65238 .2627 L
.6524 .19522 L
.65241 .20563 L
.65242 .24527 L
.65243 .21104 L
.65245 .23915 L
.65246 .22374 L
.65247 .22471 L
.65249 .23881 L
.6525 .24528 L
.65251 .26939 L
.65253 .25669 L
.65254 .24485 L
.65256 .20904 L
.65257 .23017 L
.65258 .21009 L
.6526 .23859 L
.65261 .20787 L
.65262 .23392 L
.65264 .20906 L
.65265 .22157 L
.65267 .27276 L
.65268 .22391 L
.6527 .23512 L
.6527 .23903 L
.65271 .20315 L
.65273 .24888 L
.65274 .2301 L
.65275 .22154 L
.65276 .21715 L
.65277 .20558 L
.65279 .22996 L
.6528 .22107 L
.6528 .22589 L
.65282 .20604 L
.65283 .20685 L
.65285 .22524 L
.65286 .24218 L
.65288 .23056 L
.65289 .22934 L
.6529 .21251 L
.65292 .23355 L
.65293 .23289 L
.65295 .2016 L
Mistroke
.65296 .23318 L
.65297 .23763 L
.65298 .24047 L
.65299 .22085 L
.65301 .25207 L
.65302 .23738 L
.65304 .21803 L
.65305 .24894 L
.65306 .22903 L
.65307 .20805 L
.65309 .27023 L
.65309 .26173 L
.6531 .20556 L
.65311 .26909 L
.65312 .20856 L
.65314 .19092 L
.65315 .20183 L
.65316 .28209 L
.65317 .19572 L
.65318 .23862 L
.65318 .20126 L
.6532 .20375 L
.65321 .30582 L
.65322 .25517 L
.65323 .24124 L
.65324 .2402 L
.65326 .22838 L
.65327 .196 L
.65328 .21344 L
.6533 .23088 L
.65331 .19648 L
.65332 .22253 L
.65333 .25779 L
.65335 .24639 L
.65336 .25133 L
.65336 .2492 L
.65338 .2799 L
.65339 .23846 L
.65341 .2066 L
.65342 .21701 L
.65343 .19929 L
.65345 .23984 L
.65346 .23176 L
.65347 .20455 L
.65349 .28289 L
.6535 .20792 L
.65352 .22561 L
.65353 .2504 L
.65354 .24063 L
.65355 .23825 L
Mistroke
.65357 .20362 L
.65358 .25277 L
.6536 .25614 L
.65361 .2625 L
.65363 .23813 L
.65364 .22964 L
.65366 .2502 L
.65367 .21583 L
.65368 .26373 L
.65369 .2513 L
.65371 .19437 L
.65372 .2542 L
.65373 .23624 L
.65374 .25532 L
.65375 .25079 L
.65377 .17309 L
.65378 .23306 L
.65379 .21619 L
.65381 .24919 L
.65382 .23705 L
.65383 .24526 L
.65385 .25386 L
.65386 .21085 L
.65388 .21958 L
.65389 .23958 L
.65391 .20267 L
.65392 .24694 L
.65394 .19796 L
.65395 .22236 L
.65396 .25409 L
.65397 .23168 L
.65398 .18149 L
.65399 .20001 L
.654 .21789 L
.65401 .23215 L
.65402 .24916 L
.65403 .23976 L
.65404 .20815 L
.65405 .20096 L
.65406 .24082 L
.65407 .23705 L
.65407 .21787 L
.65408 .23602 L
.65409 .25265 L
.6541 .257 L
.65411 .27486 L
.65413 .22959 L
.65414 .21671 L
.65415 .19717 L
.65416 .26067 L
Mistroke
.65417 .27194 L
.65419 .28848 L
.6542 .27454 L
.65421 .24073 L
.65423 .24461 L
.65424 .25134 L
.65426 .19566 L
.65427 .20184 L
.65427 .19662 L
.65429 .23406 L
.6543 .21467 L
.65431 .23418 L
.65432 .22898 L
.65434 .24322 L
.65435 .24443 L
.65436 .26669 L
.65438 .19329 L
.65439 .17235 L
.65441 .2052 L
.65442 .23436 L
.65444 .19748 L
.65445 .2502 L
.65447 .25167 L
.65448 .25884 L
.65449 .20856 L
.65451 .25707 L
.65452 .25069 L
.65453 .21851 L
.65454 .24604 L
.65456 .29982 L
.65457 .26019 L
.65459 .19505 L
.6546 .24654 L
.65462 .23577 L
.65462 .22243 L
.65463 .25292 L
.65464 .23546 L
.65465 .21873 L
.65466 .26125 L
.65468 .23598 L
.65469 .22346 L
.65471 .21845 L
.65472 .24822 L
.65474 .23537 L
.65475 .22511 L
.65476 .27 L
.65478 .21755 L
.65479 .19196 L
.65481 .22468 L
.65482 .18838 L
Mistroke
.65484 .25552 L
.65484 .26422 L
.65485 .24625 L
.65487 .19553 L
.65488 .24418 L
.6549 .262 L
.65491 .22342 L
.65492 .23989 L
.65494 .23074 L
.65496 .24689 L
.65496 .24959 L
.65497 .22301 L
.65499 .2377 L
.655 .23823 L
.65501 .22844 L
.65502 .2524 L
.65504 .25048 L
.65504 .28902 L
.65505 .20692 L
.65506 .2889 L
.65507 .27331 L
.65509 .21577 L
.6551 .20944 L
.65512 .22919 L
.65513 .2214 L
.65514 .22565 L
.65516 .24318 L
.65517 .20128 L
.65518 .22927 L
.65519 .25788 L
.6552 .2065 L
.65521 .25454 L
.65522 .20917 L
.65523 .2357 L
.65524 .25174 L
.65525 .21963 L
.65527 .27261 L
.65528 .24351 L
.65529 .18377 L
.65531 .24064 L
.65532 .25511 L
.65533 .21961 L
.65534 .26515 L
.65536 .22842 L
.65536 .24118 L
.65537 .23785 L
.65539 .20823 L
.6554 .23228 L
.65542 .23328 L
.65543 .25752 L
Mistroke
.65544 .27536 L
.65545 .23792 L
.65546 .24561 L
.65546 .22335 L
.65548 .22905 L
.65549 .18219 L
.6555 .23966 L
.65551 .27216 L
.65553 .20866 L
.65554 .25977 L
.65555 .24701 L
.65555 .24659 L
.65556 .22782 L
.65558 .27405 L
.65558 .24756 L
.65559 .24351 L
.65561 .1918 L
.65562 .20063 L
.65564 .24042 L
.65565 .24346 L
.65566 .25233 L
.65568 .24406 L
.65569 .22062 L
.65569 .23324 L
.65571 .23401 L
.65572 .23716 L
.65573 .23553 L
.65574 .21267 L
.65576 .22852 L
.65577 .2653 L
.65579 .19037 L
.6558 .23067 L
.65581 .29779 L
.65583 .18824 L
.65584 .25777 L
.65586 .20344 L
.65587 .23934 L
.65588 .22692 L
.65589 .18545 L
.65591 .24091 L
.65592 .23151 L
.65593 .2315 L
.65595 .22636 L
.65596 .24063 L
.65598 .20217 L
.65598 .24765 L
.65599 .18963 L
.65601 .22652 L
.65602 .23855 L
.65604 .21432 L
Mistroke
.65605 .28862 L
.65607 .24774 L
.65608 .23089 L
.65609 .24183 L
.65611 .19868 L
.65612 .22653 L
.65613 .23952 L
.65615 .21207 L
.65616 .20093 L
.65618 .20354 L
.65619 .23615 L
.65621 .22043 L
.65622 .20795 L
.65622 .23915 L
.65624 .22006 L
.65626 .26883 L
.65627 .25679 L
.65628 .1987 L
.6563 .22424 L
.65631 .2458 L
.65632 .23431 L
.65633 .22677 L
.65635 .20928 L
.65636 .25532 L
.65637 .22506 L
.65639 .27843 L
.6564 .30659 L
.65641 .23195 L
.65643 .23984 L
.65644 .21232 L
.65645 .25154 L
.65646 .24261 L
.65647 .21085 L
.65649 .22026 L
.6565 .19057 L
.65652 .20049 L
.65653 .2376 L
.65655 .23095 L
.65656 .2367 L
.65657 .25225 L
.65659 .21732 L
.6566 .24891 L
.65662 .22797 L
.65663 .20365 L
.65665 .23827 L
.65666 .20493 L
.65667 .26817 L
.65668 .24565 L
.65669 .2834 L
.65671 .24632 L
Mistroke
.65672 .26088 L
.65674 .21215 L
.65675 .26959 L
.65676 .20832 L
.65678 .25574 L
.65679 .22178 L
.6568 .21407 L
.65681 .25369 L
.65683 .26576 L
.65684 .25677 L
.65686 .26881 L
.65687 .28235 L
.65688 .27607 L
.65689 .2502 L
.6569 .19658 L
.65691 .22205 L
.65693 .25874 L
.65694 .2682 L
.65696 .2495 L
.65697 .26782 L
.65699 .19093 L
.657 .25921 L
.65701 .25996 L
.65703 .22266 L
.65704 .17707 L
.65706 .23346 L
.65707 .27429 L
.65709 .23178 L
.6571 .20418 L
.65712 .24702 L
.65712 .2616 L
.65713 .22345 L
.65715 .24529 L
.65716 .20634 L
.65718 .22038 L
.65719 .2192 L
.6572 .24227 L
.65722 .24555 L
.65723 .20378 L
.65724 .27363 L
.65725 .19328 L
.65727 .22607 L
.65728 .25669 L
.6573 .21425 L
.65731 .1822 L
.65732 .20109 L
.65734 .24356 L
.65735 .17909 L
.65735 .25994 L
.65737 .17391 L
Mistroke
.65738 .24728 L
.6574 .21623 L
.65741 .24148 L
.65743 .23818 L
.65744 .22444 L
.65746 .24924 L
.65747 .26823 L
.65748 .24157 L
.6575 .29756 L
.65751 .19445 L
.65753 .24839 L
.65754 .21849 L
.65755 .23853 L
.65757 .21555 L
.65758 .26675 L
.65759 .24428 L
.6576 .24229 L
.65762 .23966 L
.65763 .23158 L
.65764 .23849 L
.65766 .21605 L
.65767 .23592 L
.65768 .20371 L
.65769 .21698 L
.65771 .21495 L
.65772 .2249 L
.65774 .26092 L
.65775 .20844 L
.65775 .20222 L
.65777 .19997 L
.65778 .1663 L
.6578 .24227 L
.65781 .21151 L
.65782 .18241 L
.65784 .23611 L
.65785 .21163 L
.65786 .22311 L
.65787 .23393 L
.65788 .29342 L
.6579 .21352 L
.65791 .20183 L
.65792 .23478 L
.65794 .23794 L
.65795 .25517 L
.65797 .23071 L
.65797 .22174 L
.65798 .21434 L
.658 .25732 L
.65801 .23969 L
.65802 .26429 L
Mistroke
.65803 .27124 L
.65805 .22437 L
.65806 .25472 L
.65807 .20124 L
.65809 .27561 L
.6581 .25155 L
.65811 .21257 L
.65812 .19095 L
.65814 .26451 L
.65815 .22951 L
.65817 .24765 L
.65818 .2484 L
.6582 .22458 L
.65821 .22772 L
.65824 .23604 L
.65827 .24931 L
.65828 .2762 L
.65829 .25862 L
.65831 .19938 L
.65832 .23865 L
.65833 .21282 L
.65835 .25696 L
.65836 .20737 L
.65837 .24488 L
.65838 .2655 L
.6584 .28669 L
.65841 .25657 L
.65843 .21045 L
.65843 .26701 L
.65844 .28019 L
.65846 .26211 L
.65847 .20732 L
.65848 .25354 L
.65849 .24131 L
.6585 .21395 L
.65851 .27501 L
.65852 .23502 L
.65853 .22348 L
.65853 .20563 L
.65855 .24139 L
.65856 .23204 L
.65858 .22503 L
.65859 .232 L
.6586 .21063 L
.65861 .28831 L
.65863 .24107 L
.65864 .24315 L
.65865 .24175 L
.65867 .2221 L
.65868 .22348 L
Mistroke
.6587 .19458 L
.65871 .22103 L
.65873 .24224 L
.65874 .28519 L
.65876 .27092 L
.65877 .20989 L
.65879 .19596 L
.6588 .19495 L
.65881 .16539 L
.65882 .22348 L
.65884 .20048 L
.65885 .20938 L
.65886 .25801 L
.65886 .26115 L
.65888 .23657 L
.65889 .25726 L
.65891 .2131 L
.65892 .19618 L
.65894 .26355 L
.65895 .2547 L
.65896 .22686 L
.65898 .25738 L
.65899 .19638 L
.65901 .25258 L
.65902 .23577 L
.65903 .27038 L
.65904 .23958 L
.65905 .22497 L
.65907 .26873 L
.65908 .25011 L
.6591 .23058 L
.65911 .23424 L
.65912 .24255 L
.65913 .26079 L
.65914 .24877 L
.65915 .25925 L
.65916 .26159 L
.65917 .19841 L
.65918 .24177 L
.65919 .2118 L
.6592 .19747 L
.6592 .19359 L
.65921 .19552 L
.65923 .21774 L
.65924 .23361 L
.65926 .23581 L
.65927 .28559 L
.65929 .23725 L
.6593 .20209 L
.65932 .25843 L
Mistroke
.65933 .25876 L
.65934 .26281 L
.65936 .24621 L
.65937 .26834 L
.65939 .25994 L
.6594 .22838 L
.65941 .20741 L
.65943 .2251 L
.65944 .2049 L
.65945 .23212 L
.65946 .18434 L
.65948 .21891 L
.65949 .28706 L
.6595 .27579 L
.65952 .21118 L
.65953 .24784 L
.65955 .2055 L
.65956 .20307 L
.65957 .22891 L
.65958 .2244 L
.6596 .23813 L
.65961 .24222 L
.65963 .22296 L
.65964 .22589 L
.65965 .24869 L
.65966 .24275 L
.65967 .20636 L
.65968 .20952 L
.6597 .21718 L
.65971 .22624 L
.65972 .22501 L
.65973 .21922 L
.65974 .23879 L
.65976 .19942 L
.65977 .24417 L
.65978 .21957 L
.6598 .20649 L
.65981 .25302 L
.65983 .22475 L
.65983 .22197 L
.65984 .19738 L
.65985 .20803 L
.65986 .25062 L
.65988 .18045 L
.65989 .25967 L
.65991 .22208 L
.65992 .2234 L
.65993 .21561 L
.65995 .23201 L
.65996 .21872 L
Mistroke
.65997 .20015 L
.65998 .22778 L
.66 .24282 L
.66001 .28622 L
.66003 .21785 L
.66004 .24339 L
.66006 .23547 L
.66007 .26382 L
.66008 .20711 L
.6601 .20704 L
.66011 .26256 L
.66013 .22761 L
.66014 .23515 L
.66015 .22172 L
.66017 .21329 L
.66018 .23282 L
.66019 .22038 L
.6602 .21912 L
.66021 .27923 L
.66022 .23701 L
.66023 .24067 L
.66025 .22797 L
.66026 .22024 L
.66028 .21713 L
.66029 .24379 L
.6603 .22911 L
.66032 .23657 L
.66033 .24478 L
.66034 .25043 L
.66036 .23725 L
.66037 .23888 L
.66039 .22959 L
.6604 .20278 L
.66042 .23228 L
.66043 .25508 L
.66045 .23342 L
.66046 .20348 L
.66047 .23312 L
.66048 .25372 L
.66049 .23107 L
.6605 .24882 L
.66051 .29485 L
.66052 .24962 L
.66053 .25501 L
.66054 .18722 L
.66055 .18137 L
.66056 .24294 L
.66057 .18165 L
.66058 .23818 L
.66058 .27038 L
Mistroke
.66059 .24664 L
.6606 .24246 L
.66061 .21053 L
.66062 .28539 L
.66064 .21442 L
.66065 .20998 L
.66067 .27071 L
.66068 .19853 L
.6607 .2263 L
.66071 .22384 L
.66072 .25318 L
.66074 .20924 L
.66075 .265 L
.66077 .25983 L
.66078 .27028 L
.6608 .26386 L
.66081 .23964 L
.66083 .2451 L
.66083 .28061 L
.66084 .22264 L
.66086 .25818 L
.66087 .23476 L
.66089 .22469 L
.6609 .24469 L
.66091 .29623 L
.66093 .22927 L
.66094 .25319 L
.66095 .1833 L
.66097 .23095 L
.66098 .22667 L
.66099 .2145 L
.66101 .20805 L
.66101 .22824 L
.66102 .26404 L
.66104 .21563 L
.66105 .27965 L
.66107 .24804 L
.66108 .2466 L
.66109 .18958 L
.6611 .21483 L
.66111 .19969 L
.66112 .22758 L
.66114 .23082 L
.66115 .23565 L
.66117 .22903 L
.66118 .24319 L
.66119 .25813 L
.66121 .259 L
.66122 .22527 L
.66123 .23094 L
Mistroke
.66124 .22781 L
.66126 .18572 L
.66126 .23847 L
.66127 .22239 L
.66129 .21275 L
.6613 .23923 L
.66132 .23288 L
.66133 .2266 L
.66134 .23472 L
.66136 .25665 L
.66137 .21043 L
.66138 .21072 L
.66139 .21493 L
.66141 .19782 L
.66142 .24283 L
.66144 .2478 L
.66145 .24286 L
.66147 .25409 L
.66148 .22426 L
.66149 .24241 L
.66151 .26484 L
.66152 .23572 L
.66154 .24073 L
.66155 .24389 L
.66157 .22864 L
.66158 .21306 L
.6616 .25574 L
.6616 .26642 L
.66161 .19491 L
.66163 .1983 L
.66164 .23288 L
.66164 .21042 L
.66166 .24676 L
.66167 .21895 L
.66169 .22023 L
.6617 .22875 L
.66171 .23351 L
.66173 .24411 L
.66174 .24845 L
.66176 .24679 L
.66177 .25688 L
.66178 .26341 L
.6618 .25331 L
.66181 .23805 L
.66183 .21585 L
.66184 .22619 L
.66185 .22422 L
.66186 .24737 L
.66187 .19295 L
.66188 .245 L
Mistroke
.66189 .21642 L
.6619 .28284 L
.66191 .27061 L
.66192 .25446 L
.66193 .25904 L
.66194 .21762 L
.66195 .26945 L
.66195 .20528 L
.66196 .25432 L
.66197 .25698 L
.66199 .21575 L
.662 .23828 L
.662 .22601 L
.66202 .23655 L
.66204 .25507 L
.66205 .24818 L
.66206 .24456 L
.66208 .253 L
.66209 .24634 L
.66211 .19393 L
.66212 .21379 L
.66213 .22311 L
.66215 .25436 L
.66216 .24118 L
.66218 .25388 L
.66219 .21153 L
.6622 .24816 L
.66221 .23808 L
.66222 .24899 L
.66224 .19886 L
.66225 .26725 L
.66225 .24899 L
.66227 .25189 L
.66228 .22224 L
.6623 .25149 L
.66231 .24419 L
.66232 .27037 L
.66234 .20694 L
.66235 .25759 L
.66237 .25099 L
.66238 .22122 L
.6624 .2612 L
.66241 .28149 L
.66242 .25379 L
.66244 .21597 L
.66245 .221 L
.66246 .1942 L
.66248 .24987 L
.66249 .25868 L
.6625 .20218 L
Mistroke
.66252 .27168 L
.66253 .23971 L
.66255 .20945 L
.66256 .20591 L
.66257 .2218 L
.66259 .22622 L
.6626 .26554 L
.66262 .20859 L
.66263 .22606 L
.66265 .28947 L
.66266 .21248 L
.66266 .24131 L
.66268 .22505 L
.66269 .23007 L
.66271 .21754 L
.66272 .18371 L
.66274 .23844 L
.66275 .25176 L
.66276 .2931 L
.66278 .26904 L
.66279 .23754 L
.6628 .24746 L
.66281 .2317 L
.66283 .18383 L
.66284 .21112 L
.66286 .25931 L
.66287 .23816 L
.66288 .24471 L
.6629 .1939 L
.66291 .24546 L
.66291 .16535 L
.66293 .23356 L
.66294 .2316 L
.66296 .24405 L
.66297 .21858 L
.66299 .21217 L
.663 .25859 L
.66302 .20043 L
.66303 .21913 L
.66304 .23169 L
.66306 .24709 L
.66307 .20546 L
.66309 .27774 L
.6631 .24775 L
.66311 .24647 L
.66313 .25357 L
.66314 .258 L
.66315 .20654 L
.66316 .25018 L
.66318 .22254 L
Mistroke
.66319 .23626 L
.6632 .17697 L
.66322 .23959 L
.66323 .24156 L
.66324 .24273 L
.66326 .23838 L
.66327 .2096 L
.66328 .25157 L
.6633 .19845 L
.66331 .25129 L
.66332 .2167 L
.66334 .22856 L
.66335 .19669 L
.66336 .18896 L
.66337 .20441 L
.66338 .25689 L
.6634 .19607 L
.66341 .21539 L
.66343 .20814 L
.66344 .24663 L
.66346 .24556 L
.66347 .29727 L
.66348 .22171 L
.6635 .24634 L
.66351 .23639 L
.66353 .19438 L
.66354 .24602 L
.66355 .24688 L
.66357 .292 L
.66359 .25024 L
.66359 .20687 L
.6636 .24347 L
.66362 .2426 L
.66363 .26176 L
.66365 .27699 L
.66366 .23306 L
.66367 .1993 L
.66369 .2147 L
.6637 .25413 L
.66371 .26386 L
.66373 .25601 L
.66374 .27489 L
.66375 .24458 L
.66377 .2789 L
.66378 .27012 L
.66379 .20468 L
.66381 .23142 L
.66382 .21716 L
.66384 .22601 L
.66385 .20992 L
Mistroke
.66387 .2387 L
.66388 .21561 L
.66389 .24326 L
.66391 .19634 L
.66392 .2402 L
.66393 .27185 L
.66394 .25139 L
.66396 .22581 L
.66397 .26074 L
.66398 .24499 L
.664 .24027 L
.66401 .24603 L
.66402 .29274 L
.66404 .22159 L
.66405 .25536 L
.66407 .23284 L
.66408 .26793 L
.66409 .24648 L
.6641 .22618 L
.66411 .27199 L
.66413 .25176 L
.66414 .21923 L
.66415 .23967 L
.66416 .19392 L
.66417 .22506 L
.66418 .20679 L
.66419 .23981 L
.6642 .2455 L
.66421 .22714 L
.66422 .22133 L
.66423 .23592 L
.66424 .22207 L
.66425 .2379 L
.66427 .2414 L
.66428 .25174 L
.6643 .23284 L
.66431 .20022 L
.66433 .23659 L
.66434 .24938 L
.66435 .21496 L
.66436 .24421 L
.66437 .23452 L
.66438 .24861 L
.66439 .2607 L
.6644 .27558 L
.66442 .2631 L
.66443 .24287 L
.66445 .23729 L
.66446 .29024 L
.66447 .20676 L
Mistroke
.66448 .27003 L
.66449 .23022 L
.6645 .22686 L
.66451 .21323 L
.66452 .26395 L
.66453 .21023 L
.66453 .25819 L
.66454 .22798 L
.66455 .23532 L
.66457 .23436 L
.66457 .21994 L
.66458 .23093 L
.6646 .17729 L
.66461 .19193 L
.66462 .20294 L
.66464 .21944 L
.66465 .21693 L
.66466 .25999 L
.66467 .23219 L
.66468 .20647 L
.6647 .23179 L
.66471 .22157 L
.66472 .24291 L
.66472 .24613 L
.66473 .24836 L
.66475 .27221 L
.66476 .29247 L
.66476 .19633 L
.66478 .22224 L
.66479 .27128 L
.66481 .2016 L
.66482 .27628 L
.66484 .24196 L
.66485 .29228 L
.66485 .25444 L
.66487 .26289 L
.66488 .22732 L
.6649 .20777 L
.66491 .24506 L
.66492 .20132 L
.66494 .23528 L
.66495 .24708 L
.66496 .25125 L
.66497 .23679 L
.66499 .28201 L
.66499 .26898 L
.665 .22497 L
.66502 .22029 L
.66503 .23899 L
.66505 .24652 L
Mistroke
.66506 .21216 L
.66507 .27422 L
.66509 .23884 L
.6651 .23927 L
.66511 .23728 L
.66513 .23586 L
.66514 .23631 L
.66516 .20826 L
.66517 .254 L
.66518 .23193 L
.6652 .25626 L
.66521 .20605 L
.66522 .23075 L
.66524 .20843 L
.66525 .23178 L
.66527 .19552 L
.66528 .26096 L
.66529 .25184 L
.6653 .26931 L
.66531 .25959 L
.66532 .24726 L
.66533 .24303 L
.66534 .25301 L
.66535 .24089 L
.66536 .22742 L
.66538 .25265 L
.66539 .22113 L
.6654 .26724 L
.66541 .24411 L
.66542 .23323 L
.66543 .25023 L
.66545 .26032 L
.66546 .24852 L
.66548 .25066 L
.66549 .22251 L
.66551 .2726 L
.66552 .20972 L
.66553 .23827 L
.66554 .23806 L
.66555 .21293 L
.66556 .2322 L
.66557 .22253 L
.66558 .2548 L
.66559 .23118 L
.66559 .24029 L
.6656 .19402 L
.66561 .21406 L
.66562 .2288 L
.66563 .26805 L
.66564 .22006 L
Mistroke
.66565 .23437 L
.66567 .23932 L
.66568 .26439 L
.66569 .1967 L
.6657 .25372 L
.66571 .2635 L
.66572 .23043 L
.66574 .19581 L
.66575 .24726 L
.66576 .27305 L
.66577 .2929 L
.66579 .22947 L
.66579 .2523 L
.6658 .21622 L
.66582 .20806 L
.66583 .23879 L
.66584 .25135 L
.66585 .22426 L
.66587 .23426 L
.66588 .24352 L
.66589 .27521 L
.6659 .2628 L
.66591 .30393 L
.66592 .21457 L
.66593 .2389 L
.66594 .20577 L
.66596 .22354 L
.66597 .22195 L
.66598 .24851 L
.66599 .25214 L
.666 .25826 L
.66601 .2373 L
.66602 .24045 L
.66603 .24868 L
.66604 .25132 L
.66606 .24085 L
.66607 .24145 L
.66608 .1898 L
.66609 .23579 L
.6661 .20257 L
.66611 .23582 L
.66612 .23842 L
.66613 .23638 L
.66614 .2677 L
.66614 .24445 L
.66615 .20917 L
.66617 .18518 L
.66618 .26028 L
.66619 .24085 L
.66621 .23992 L
Mistroke
.66622 .23326 L
.66623 .25505 L
.66624 .25003 L
.66625 .25601 L
.66627 .2137 L
.66628 .24701 L
.6663 .20751 L
.66631 .16126 L
.66632 .27818 L
.66634 .22475 L
.66635 .27236 L
.66636 .25284 L
.66637 .22308 L
.66638 .24048 L
.6664 .27917 L
.66641 .20444 L
.66642 .21619 L
.66643 .21993 L
.66644 .26453 L
.66645 .23641 L
.66646 .20628 L
.66648 .239 L
.66649 .19869 L
.66651 .2233 L
.66652 .27748 L
.66654 .21536 L
.66655 .22343 L
.66656 .21343 L
.66658 .26414 L
.66659 .25259 L
.66661 .214 L
.66662 .21764 L
.66663 .24039 L
.66665 .25807 L
.66666 .24173 L
.66667 .21003 L
.66669 .27666 L
.6667 .29364 L
.66672 .2221 L
.66673 .30597 L
.66674 .24842 L
.66676 .23734 L
.66677 .25627 L
.66679 .2206 L
.6668 .21733 L
.66681 .23243 L
.66683 .25861 L
.66684 .26186 L
.66685 .22601 L
.66686 .22756 L
Mistroke
.66687 .23057 L
.66689 .21561 L
.6669 .2008 L
.66692 .2392 L
.66693 .25449 L
.66694 .28079 L
.66695 .2425 L
.66696 .25881 L
.66697 .23635 L
.66697 .235 L
.66698 .18929 L
.667 .23815 L
.66701 .24341 L
.66702 .23014 L
.66703 .2448 L
.66704 .26444 L
.66706 .24054 L
.66707 .24212 L
.66709 .23912 L
.6671 .25101 L
.6671 .18571 L
.66711 .23543 L
.66712 .229 L
.66713 .2307 L
.66715 .28926 L
.66716 .2351 L
.66717 .23495 L
.66718 .25044 L
.66719 .24744 L
.6672 .21834 L
.66721 .26143 L
.66722 .22528 L
.66723 .23267 L
.66723 .21738 L
.66725 .23399 L
.66726 .26695 L
.66727 .31049 L
.66728 .24104 L
.6673 .29323 L
.66731 .22644 L
.66732 .25209 L
.66733 .31681 L
.66734 .24664 L
.66736 .22877 L
.66737 .25465 L
.66739 .22785 L
.6674 .24278 L
.66741 .24068 L
.66743 .28479 L
.66744 .23801 L
Mistroke
.66745 .23127 L
.66747 .24288 L
.66748 .23842 L
.66749 .25542 L
.6675 .23925 L
.66752 .26326 L
.66753 .21583 L
.66755 .23629 L
.66756 .2478 L
.66757 .21967 L
.66758 .23432 L
.66759 .26926 L
.66761 .24711 L
.66762 .22987 L
.66762 .23926 L
.66763 .24729 L
.66764 .24039 L
.66766 .25086 L
.66767 .23187 L
.66768 .22407 L
.66769 .22013 L
.6677 .16627 L
.66771 .20419 L
.66772 .27828 L
.66773 .27305 L
.66774 .29678 L
.66775 .22721 L
.66775 .23669 L
.66776 .21937 L
.66777 .23675 L
.66779 .22142 L
.6678 .23358 L
.66781 .25833 L
.66783 .21752 L
.66784 .23117 L
.66785 .25518 L
.66785 .25408 L
.66786 .2693 L
.66788 .21906 L
.66789 .24547 L
.66789 .20564 L
.6679 .24015 L
.66791 .20898 L
.66792 .22169 L
.66793 .27837 L
.66794 .19787 L
.66795 .244 L
.66795 .29429 L
.66796 .26859 L
.66797 .23691 L
Mistroke
.66798 .24849 L
.668 .25076 L
.66801 .22732 L
.66802 .24759 L
.66804 .22778 L
.66805 .24568 L
.66806 .23242 L
.66806 .22796 L
.66807 .29215 L
.66808 .29504 L
.66809 .24814 L
.6681 .25082 L
.66812 .26277 L
.66813 .26715 L
.66814 .24142 L
.66816 .20225 L
.66817 .25767 L
.66818 .27575 L
.66819 .2019 L
.66821 .23082 L
.66822 .22532 L
.66823 .2357 L
.66824 .23294 L
.66825 .25807 L
.66827 .22801 L
.66828 .2496 L
.66829 .26286 L
.66831 .26952 L
.66832 .21453 L
.66834 .25749 L
.66835 .27251 L
.66835 .24528 L
.66837 .24466 L
.66838 .2269 L
.66838 .23563 L
.6684 .21293 L
.66841 .24404 L
.66843 .3172 L
.66844 .23301 L
.66846 .22827 L
.66847 .2033 L
.66848 .23436 L
.66849 .23442 L
.66851 .22559 L
.66852 .25875 L
.66854 .25112 L
.66855 .22225 L
.66856 .23386 L
.66858 .23503 L
.66859 .25006 L
Mistroke
.66861 .27202 L
.66862 .26146 L
.66864 .21772 L
.66865 .23044 L
.66866 .27546 L
.66867 .22767 L
.66868 .26845 L
.66869 .25276 L
.66871 .22866 L
.66872 .23176 L
.66873 .25666 L
.66874 .23583 L
.66876 .27956 L
.66876 .26493 L
.66877 .25711 L
.66879 .2467 L
.6688 .24611 L
.66882 .22174 L
.66883 .27284 L
.66885 .2266 L
.66886 .22737 L
.66887 .21426 L
.66889 .23493 L
.6689 .25468 L
.66892 .25024 L
.66893 .23999 L
.66894 .23889 L
.66895 .25633 L
.66896 .2261 L
.66898 .23315 L
.66899 .25987 L
.66901 .25553 L
.66902 .29189 L
.66903 .2559 L
.66904 .24414 L
.66905 .26677 L
.66906 .242 L
.66907 .23055 L
.66908 .2615 L
.66909 .26957 L
.6691 .24929 L
.66912 .26752 L
.66913 .21175 L
.66914 .21486 L
.66914 .22398 L
.66915 .21227 L
.66917 .23692 L
.66918 .23376 L
.66918 .2347 L
.6692 .22515 L
Mistroke
.66921 .23945 L
.66923 .23276 L
.66924 .25184 L
.66925 .27408 L
.66927 .2955 L
.66928 .25835 L
.6693 .25463 L
.66931 .24545 L
.66933 .24713 L
.66933 .2399 L
.66934 .26999 L
.66935 .26572 L
.66936 .22701 L
.66937 .24005 L
.66937 .27746 L
.66939 .22293 L
.6694 .26429 L
.66942 .26131 L
.66943 .2325 L
.66944 .23786 L
.66946 .20412 L
.66947 .22997 L
.66948 .24392 L
.66949 .20801 L
.66951 .204 L
.66952 .25899 L
.66954 .27723 L
.66955 .23672 L
.66956 .27433 L
.66958 .24132 L
.66959 .20223 L
.66959 .25857 L
.66961 .25429 L
.66962 .25471 L
.66963 .26283 L
.66964 .26126 L
.66966 .23698 L
.66967 .27198 L
.66967 .24798 L
.66969 .2763 L
.6697 .23693 L
.66972 .25427 L
.66973 .28064 L
.66974 .25194 L
.66975 .2422 L
.66976 .23115 L
.66977 .20882 L
.66978 .24572 L
.6698 .25033 L
.66981 .24885 L
Mistroke
.66981 .23485 L
.66982 .25635 L
.66983 .27978 L
.66984 .24132 L
.66985 .26819 L
.66986 .24599 L
.66987 .27479 L
.66988 .251 L
.66989 .22822 L
.6699 .2426 L
.66991 .26583 L
.66993 .27993 L
.66994 .25942 L
.66995 .23447 L
.66997 .27281 L
.66998 .24098 L
.66999 .2545 L
.67 .23008 L
.67001 .19746 L
.67002 .23532 L
.67003 .22264 L
.67004 .22792 L
.67005 .23532 L
.67006 .24057 L
.67008 .21615 L
.67008 .24588 L
.67009 .20713 L
.67011 .22939 L
.67012 .23372 L
.67014 .24474 L
.67015 .23024 L
.67017 .22758 L
.67018 .22315 L
.67019 .2052 L
.67021 .26716 L
.67022 .21334 L
.67023 .24617 L
.67024 .22507 L
.67025 .23289 L
.67025 .26548 L
.67027 .22847 L
.67028 .25147 L
.67029 .21105 L
.6703 .24689 L
.67031 .21463 L
.67033 .27408 L
.67035 .21899 L
.67035 .25069 L
.67036 .24101 L
.67038 .24457 L
Mistroke
.67039 .23808 L
.6704 .25778 L
.67041 .24615 L
.67042 .24294 L
.67044 .22688 L
.67045 .2701 L
.67047 .26447 L
.67047 .24939 L
.67048 .24377 L
.67049 .20158 L
.6705 .28405 L
.67051 .26297 L
.67053 .18297 L
.67054 .23053 L
.67055 .22914 L
.67056 .26215 L
.67057 .22405 L
.67058 .23732 L
.67059 .22085 L
.6706 .26239 L
.67061 .21631 L
.67062 .24764 L
.67063 .24811 L
.67064 .20968 L
.67066 .22858 L
.67067 .20718 L
.67069 .22101 L
.6707 .20744 L
.67071 .27302 L
.67073 .24878 L
.67074 .2682 L
.67075 .22366 L
.67076 .24702 L
.67077 .24568 L
.67077 .22968 L
.67079 .2826 L
.6708 .25187 L
.67082 .25141 L
.67083 .24179 L
.67083 .26146 L
.67085 .19664 L
.67086 .22493 L
.67088 .23589 L
.67089 .25485 L
.6709 .25789 L
.67092 .27026 L
.67093 .22386 L
.67095 .2507 L
.67096 .19886 L
.67098 .26244 L
Mistroke
.67099 .24801 L
.671 .18102 L
.67102 .26065 L
.67103 .21071 L
.67104 .27018 L
.67106 .21237 L
.67107 .20775 L
.67108 .24562 L
.67109 .23026 L
.67109 .25571 L
.6711 .23765 L
.67111 .26107 L
.67112 .25233 L
.67113 .26886 L
.67115 .25705 L
.67116 .26339 L
.67116 .22308 L
.67118 .23219 L
.67119 .28871 L
.67119 .28611 L
.67121 .28766 L
.67122 .23629 L
.67123 .22862 L
.67123 .26261 L
.67124 .25059 L
.67125 .2185 L
.67126 .24629 L
.67127 .21299 L
.67128 .23849 L
.67129 .2212 L
.6713 .24323 L
.6713 .22354 L
.67131 .20892 L
.67133 .22369 L
.67134 .23494 L
.67134 .26632 L
.67136 .25578 L
.67137 .30445 L
.67139 .23934 L
.6714 .23564 L
.67143 .22751 L
.67144 .23895 L
.67145 .26384 L
.67146 .2163 L
.67148 .26014 L
.67149 .28474 L
.6715 .27761 L
.67151 .27392 L
.67152 .25666 L
.67153 .24201 L
Mistroke
.67154 .24242 L
.67155 .20931 L
.67155 .23982 L
.67157 .20724 L
.67158 .22542 L
.6716 .24409 L
.67161 .25203 L
.67163 .27765 L
.67164 .24131 L
.67165 .24246 L
.67167 .24355 L
.67168 .21132 L
.6717 .23474 L
.67171 .24787 L
.67173 .21469 L
.67174 .20184 L
.67175 .24504 L
.67176 .23867 L
.67177 .26874 L
.67179 .23036 L
.6718 .23663 L
.67182 .29127 L
.67183 .22861 L
.67184 .25442 L
.67186 .21641 L
.67187 .26768 L
.67188 .29216 L
.67189 .19164 L
.67191 .20521 L
.67192 .21675 L
.67195 .23627 L
.67196 .22528 L
.67198 .23526 L
.67199 .20449 L
.67199 .2775 L
.67201 .2805 L
.67202 .22274 L
.67202 .19911 L
.67204 .22494 L
.67205 .28268 L
.67206 .27104 L
.67207 .21595 L
.67208 .23838 L
.67209 .22406 L
.6721 .25062 L
.67212 .26657 L
.67213 .23026 L
.67214 .25334 L
.67215 .20286 L
.67216 .27165 L
Mistroke
.67217 .2313 L
.67218 .2351 L
.67219 .22235 L
.6722 .27209 L
.6722 .29645 L
.67221 .2893 L
.67222 .24978 L
.67223 .24303 L
.67225 .26948 L
.67226 .27853 L
.67226 .22485 L
.67228 .22971 L
.67229 .24336 L
.6723 .22022 L
.67231 .21803 L
.67232 .30227 L
.67234 .21212 L
.67235 .28949 L
.67237 .23118 L
.67238 .18956 L
.6724 .27536 L
.6724 .23974 L
.67241 .24661 L
.67243 .27182 L
.67244 .1558 L
.67245 .24766 L
.67246 .22913 L
.67247 .2755 L
.67248 .20861 L
.67249 .28138 L
.6725 .24609 L
.67251 .24261 L
.67252 .25082 L
.67253 .2236 L
.67254 .22361 L
.67255 .26412 L
.67257 .21228 L
.67258 .24571 L
.67259 .23237 L
.67261 .22615 L
.67262 .23197 L
.67263 .2146 L
.67264 .26678 L
.67265 .25209 L
.67269 .21371 L
.6727 .23808 L
.67271 .18389 L
.67272 .21167 L
.67273 .27642 L
.67275 .22808 L
Mistroke
.67276 .24868 L
.67277 .23892 L
.67278 .23751 L
.67279 .23254 L
.67281 .29039 L
.67282 .22036 L
.67283 .23335 L
.67284 .22543 L
.67285 .24396 L
.67286 .26867 L
.67287 .27684 L
.67288 .26437 L
.67289 .24125 L
.6729 .22703 L
.67292 .22066 L
.67293 .20214 L
.67295 .28891 L
.67296 .22285 L
.67297 .27337 L
.67298 .24107 L
.67299 .22741 L
.673 .22015 L
.67301 .27745 L
.67303 .23715 L
.67304 .26534 L
.67306 .27336 L
.67307 .24545 L
.67307 .19846 L
.67309 .25589 L
.6731 .28875 L
.67312 .22255 L
.67313 .23893 L
.67315 .22383 L
.67316 .25972 L
.67317 .24091 L
.67319 .2208 L
.6732 .25374 L
.67322 .21196 L
.67323 .23625 L
.67324 .24439 L
.67325 .24442 L
.67326 .22209 L
.67328 .29149 L
.67329 .25501 L
.67331 .23628 L
.67332 .22027 L
.67332 .24443 L
.67333 .25122 L
.67334 .261 L
.67335 .23267 L
Mistroke
.67336 .20692 L
.67337 .23404 L
.67339 .21436 L
.6734 .23074 L
.67342 .25588 L
.67343 .26346 L
.67344 .23115 L
.67345 .25505 L
.67346 .26185 L
.67348 .27221 L
.67349 .22329 L
.67351 .27021 L
.67352 .25359 L
.67354 .20425 L
.67355 .2381 L
.67356 .20882 L
.67358 .22681 L
.67359 .20803 L
.67361 .29756 L
.67362 .2439 L
.67364 .18319 L
.67365 .21092 L
.67367 .25331 L
.67368 .22216 L
.67368 .21322 L
.6737 .23124 L
.67371 .22782 L
.67373 .26635 L
.67374 .25862 L
.67376 .2554 L
.67377 .23255 L
.67378 .25308 L
.67379 .23644 L
.67381 .28771 L
.67382 .22069 L
.67383 .24286 L
.67385 .2075 L
.67386 .27738 L
.67387 .2641 L
.67389 .22736 L
.6739 .27109 L
.67391 .2551 L
.67392 .22174 L
.67393 .25277 L
.67395 .21361 L
.67396 .2692 L
.67396 .23645 L
.67398 .25133 L
.67399 .24125 L
.67401 .22214 L
Mistroke
.67402 .2663 L
.67403 .2374 L
.67405 .27046 L
.67406 .23615 L
.67407 .20458 L
.67408 .25648 L
.6741 .2302 L
.6741 .29548 L
.67411 .26698 L
.67413 .20776 L
.67414 .24934 L
.67416 .23831 L
.67417 .2775 L
.67418 .22802 L
.6742 .26809 L
.67421 .22327 L
.67422 .22542 L
.67423 .27563 L
.67425 .28632 L
.67426 .27737 L
.67428 .25609 L
.67429 .23962 L
.67431 .24088 L
.67432 .31582 L
.67433 .21457 L
.67435 .2249 L
.67436 .20532 L
.67438 .2758 L
.67439 .23743 L
.67441 .2627 L
.67442 .26799 L
.67443 .24462 L
.67444 .21797 L
.67445 .25645 L
.67445 .22058 L
.67447 .26333 L
.67448 .22577 L
.6745 .26734 L
.67451 .2506 L
.67453 .1962 L
.67454 .23679 L
.67455 .26014 L
.67457 .21511 L
.67458 .2673 L
.6746 .22151 L
.67461 .21299 L
.67463 .19363 L
.67464 .22639 L
.67466 .28829 L
.67467 .21222 L
Mistroke
.67468 .23915 L
.6747 .23089 L
.67471 .22427 L
.67472 .27383 L
.67473 .24171 L
.67474 .22217 L
.67475 .22901 L
.67478 .21136 L
.67479 .24726 L
.6748 .19743 L
.67481 .21398 L
.67481 .26735 L
.67483 .24459 L
.67484 .21381 L
.67485 .30171 L
.67486 .23434 L
.67488 .23418 L
.67489 .26493 L
.67491 .19234 L
.67492 .24161 L
.67493 .24711 L
.67495 .26661 L
.67496 .2594 L
.67496 .22314 L
.67498 .22729 L
.67499 .26979 L
.67501 .29767 L
.67502 .20481 L
.67503 .27021 L
.67504 .19569 L
.67506 .24502 L
.67507 .27613 L
.67508 .25244 L
.6751 .25441 L
.67511 .24926 L
.67512 .21081 L
.67513 .25369 L
.67515 .25513 L
.67516 .20328 L
.67517 .24739 L
.67519 .24456 L
.6752 .27486 L
.67521 .21746 L
.67522 .25862 L
.67524 .25247 L
.67525 .26225 L
.67526 .1963 L
.67528 .23932 L
.6753 .24075 L
.67531 .25235 L
Mistroke
.67532 .25708 L
.67534 .27661 L
.67535 .26559 L
.67537 .25056 L
.67538 .23166 L
.67539 .24139 L
.67541 .23211 L
.67542 .23237 L
.67544 .23763 L
.67545 .2275 L
.67545 .22958 L
.67546 .22011 L
.67547 .25899 L
.67549 .21282 L
.6755 .24201 L
.67551 .23501 L
.67552 .28363 L
.67553 .27099 L
.67554 .25216 L
.67555 .28105 L
.67556 .29508 L
.67558 .24578 L
.67559 .2354 L
.67561 .21323 L
.67562 .19937 L
.67563 .28496 L
.67565 .26316 L
.67567 .26501 L
.67568 .23366 L
.67569 .29752 L
.67571 .22755 L
.67572 .25948 L
.67574 .28594 L
.67575 .24694 L
.67576 .252 L
.67577 .26094 L
.67579 .23717 L
.6758 .22757 L
.67581 .25678 L
.67582 .22909 L
.67583 .22525 L
.67584 .29 L
.67586 .26943 L
.67587 .25775 L
.67589 .24519 L
.6759 .23732 L
.67591 .25516 L
.67593 .2567 L
.67594 .28844 L
.67594 .17496 L
Mistroke
.67596 .21735 L
.67597 .23182 L
.67598 .26561 L
.67599 .24891 L
.67601 .24206 L
.67602 .27361 L
.67604 .26738 L
.67605 .26625 L
.67606 .20783 L
.67607 .24659 L
.67609 .27818 L
.6761 .25014 L
.67612 .26694 L
.67613 .23875 L
.67614 .26582 L
.67616 .24052 L
.67617 .26898 L
.67618 .24775 L
.6762 .2552 L
.67621 .22003 L
.67623 .26625 L
.67624 .26435 L
.67626 .21575 L
.67627 .21418 L
.67629 .22355 L
.67629 .24285 L
.6763 .26277 L
.67631 .25157 L
.67632 .25687 L
.67633 .25804 L
.67635 .25549 L
.67636 .26553 L
.67638 .23696 L
.67639 .23675 L
.67641 .26321 L
.67642 .21286 L
.67643 .26079 L
.67645 .26358 L
.67646 .28878 L
.67648 .2366 L
.67649 .2419 L
.67651 .25216 L
.67652 .22135 L
.67653 .2313 L
.67654 .20422 L
.67655 .24331 L
.67657 .23405 L
.67658 .21453 L
.6766 .25078 L
.67661 .28811 L
Mistroke
.67663 .28285 L
.67664 .21503 L
.67664 .25344 L
.67666 .25897 L
.67667 .24843 L
.67669 .23191 L
.6767 .2511 L
.67671 .22179 L
.67672 .27788 L
.67672 .25172 L
.67673 .23824 L
.67674 .23893 L
.67676 .24236 L
.67677 .2131 L
.67679 .25452 L
.6768 .24283 L
.67681 .22336 L
.67683 .2724 L
.67684 .23366 L
.67686 .24402 L
.67686 .25007 L
.67687 .25829 L
.67688 .20963 L
.67689 .24022 L
.6769 .27047 L
.67691 .25832 L
.67692 .22812 L
.67694 .22034 L
.67695 .23229 L
.67697 .25888 L
.67698 .21004 L
.67699 .25834 L
.677 .25628 L
.67701 .29345 L
.67703 .23358 L
.67703 .27013 L
.67704 .26543 L
.67706 .2564 L
.67707 .19197 L
.67709 .28034 L
.6771 .26288 L
.67711 .2018 L
.67712 .27256 L
.67713 .23233 L
.67713 .27732 L
.67715 .27531 L
.67716 .26363 L
.67717 .24599 L
.67718 .20593 L
.6772 .25499 L
Mistroke
.67721 .24709 L
.67722 .23464 L
.67722 .23534 L
.67723 .2406 L
.67724 .24675 L
.67725 .25923 L
.67726 .18866 L
.67728 .21509 L
.67729 .24889 L
.6773 .20914 L
.67731 .16852 L
.67733 .26226 L
.67733 .24111 L
.67734 .26725 L
.67736 .2759 L
.67737 .2236 L
.67739 .2704 L
.6774 .23391 L
.67742 .24704 L
.67743 .2005 L
.67744 .29938 L
.67746 .25199 L
.67747 .24928 L
.67749 .2671 L
.6775 .25633 L
.67751 .24043 L
.67752 .18777 L
.67753 .21086 L
.67755 .26198 L
.67756 .21927 L
.67758 .19004 L
.67759 .25425 L
.6776 .29961 L
.67761 .2385 L
.67762 .23312 L
.67763 .25845 L
.67764 .24705 L
.67765 .22825 L
.67766 .19609 L
.67767 .22266 L
.67769 .27074 L
.6777 .23105 L
.6777 .27818 L
.67771 .28625 L
.67772 .25532 L
.67774 .26431 L
.67774 .23979 L
.67775 .22247 L
.67777 .25903 L
.67778 .247 L
Mistroke
.67779 .22778 L
.67781 .28259 L
.67782 .22427 L
.67784 .24238 L
.67785 .25062 L
.67786 .23413 L
.67787 .22467 L
.67788 .26232 L
.67789 .25596 L
.6779 .22853 L
.67791 .24047 L
.67793 .26499 L
.67794 .25204 L
.67796 .29317 L
.67797 .24884 L
.67798 .25243 L
.678 .25851 L
.67801 .25565 L
.67802 .27578 L
.67804 .28278 L
.67805 .22161 L
.67807 .26455 L
.67808 .25631 L
.67809 .22687 L
.67811 .22242 L
.67812 .25637 L
.67814 .2373 L
.67815 .24381 L
.67816 .22127 L
.67818 .31114 L
.67819 .20692 L
.67819 .25518 L
.67821 .20265 L
.67822 .28335 L
.67823 .21694 L
.67824 .29331 L
.67826 .27083 L
.67827 .27474 L
.67828 .27137 L
.67829 .26478 L
.6783 .1814 L
.67832 .27591 L
.67833 .26699 L
.67835 .21146 L
.67836 .20276 L
.67837 .26802 L
.67839 .24368 L
.6784 .246 L
.67841 .25029 L
.67843 .2388 L
Mistroke
.67844 .2162 L
.67846 .24333 L
.67847 .24611 L
.67849 .28585 L
.6785 .24242 L
.6785 .21301 L
.67852 .25191 L
.67853 .29331 L
.67854 .25038 L
.67855 .27288 L
.67857 .29276 L
.67858 .26502 L
.67858 .21282 L
.67859 .22424 L
.6786 .2184 L
.67861 .21014 L
.67862 .24748 L
.67863 .2153 L
.67864 .22731 L
.67865 .26469 L
.67867 .25696 L
.67868 .23416 L
.67869 .23355 L
.6787 .25279 L
.67871 .21645 L
.67873 .25122 L
.67874 .22487 L
.67875 .25785 L
.67877 .24261 L
.67878 .21927 L
.67879 .19411 L
.6788 .24591 L
.67881 .26794 L
.67883 .26629 L
.67884 .25613 L
.67884 .24673 L
.67886 .24412 L
.67887 .27393 L
.67889 .22031 L
.6789 .25901 L
.67891 .26458 L
.67893 .23516 L
.67894 .27559 L
.67895 .21803 L
.67897 .23728 L
.67898 .22814 L
.679 .24531 L
.67901 .2528 L
.67902 .19224 L
.67904 .30745 L
Mistroke
.67905 .22413 L
.67906 .22606 L
.67908 .30349 L
.67909 .19478 L
.67911 .24877 L
.67912 .22094 L
.67914 .2573 L
.67915 .24199 L
.67916 .24672 L
.67917 .24223 L
.67918 .23 L
.67919 .24329 L
.6792 .25693 L
.67921 .24149 L
.67923 .25937 L
.67924 .2297 L
.67926 .19071 L
.67927 .27887 L
.67929 .22437 L
.6793 .24463 L
.67931 .24743 L
.67933 .23841 L
.67934 .24155 L
.67936 .26162 L
.67937 .23753 L
.67939 .23248 L
.6794 .24984 L
.67941 .24924 L
.67943 .22943 L
.67944 .22581 L
.67945 .24792 L
.67946 .21814 L
.67947 .26941 L
.67948 .24408 L
.67949 .25464 L
.6795 .27621 L
.67951 .27158 L
.67952 .23507 L
.67953 .27208 L
.67954 .22735 L
.67955 .22549 L
.67955 .24324 L
.67956 .24102 L
.67957 .23444 L
.67958 .21419 L
.67959 .2412 L
.67961 .25523 L
.67962 .22938 L
.67964 .22176 L
.67965 .24093 L
Mistroke
.67967 .18726 L
.67968 .25555 L
.67969 .22802 L
.67971 .23992 L
.67972 .23092 L
.67974 .19323 L
.67975 .25367 L
.67976 .25558 L
.67978 .22377 L
.6798 .22886 L
.6798 .24253 L
.67981 .22495 L
.67983 .23776 L
.67984 .26009 L
.67986 .26108 L
.67987 .26097 L
.67988 .29228 L
.6799 .24412 L
.67991 .27072 L
.67992 .24807 L
.67993 .24429 L
.67995 .22063 L
.67996 .25719 L
.67998 .25704 L
.67999 .25859 L
.68 .23085 L
.68002 .23861 L
.68003 .26016 L
.68003 .25462 L
.68005 .23097 L
.68006 .20909 L
.68008 .2442 L
.68009 .27769 L
.68011 .2146 L
.68012 .28676 L
.68014 .24759 L
.68015 .22244 L
.68016 .23918 L
.68018 .26228 L
.68019 .23366 L
.68021 .2426 L
.68022 .26441 L
.68023 .24118 L
.68025 .23283 L
.68026 .24847 L
.68027 .24315 L
.68028 .25008 L
.6803 .22492 L
.68031 .28076 L
.68033 .2658 L
Mistroke
.68034 .25731 L
.68035 .22895 L
.68037 .21558 L
.68038 .25098 L
.6804 .24916 L
.68041 .21653 L
.68042 .23277 L
.68044 .21904 L
.68045 .24992 L
.68046 .23122 L
.68048 .24063 L
.68049 .27046 L
.6805 .26651 L
.68052 .26149 L
.68053 .24881 L
.68055 .25306 L
.68056 .24107 L
.68057 .2726 L
.68059 .30288 L
.6806 .2235 L
.68061 .24613 L
.68062 .23242 L
.68063 .22397 L
.68065 .2884 L
.68066 .28137 L
.68067 .2481 L
.68069 .2834 L
.6807 .24024 L
.68072 .24513 L
.68073 .25539 L
.68074 .23812 L
.68076 .30859 L
.68077 .22821 L
.68078 .30321 L
.68079 .27151 L
.6808 .24951 L
.68081 .27272 L
.68082 .29975 L
.68084 .25505 L
.68085 .21029 L
.68085 .23584 L
.68086 .23895 L
.68087 .24803 L
.68089 .27019 L
.6809 .21276 L
.6809 .22387 L
.68092 .29517 L
.68093 .18081 L
.68095 .24995 L
.68096 .25737 L
Mistroke
.68098 .23904 L
.68099 .23728 L
.68101 .24756 L
.68101 .26227 L
.68102 .21519 L
.68104 .26405 L
.68105 .21961 L
.68106 .25024 L
.68107 .24179 L
.68108 .30931 L
.6811 .20577 L
.68111 .28075 L
.68112 .24996 L
.68113 .2873 L
.68114 .23508 L
.68115 .23933 L
.68116 .22745 L
.68118 .22186 L
.68119 .23861 L
.6812 .22757 L
.68121 .23138 L
.68122 .28132 L
.68123 .23899 L
.68124 .22679 L
.68125 .25102 L
.68126 .24041 L
.68128 .22706 L
.68129 .25724 L
.6813 .23664 L
.68131 .22624 L
.68132 .24956 L
.68133 .21171 L
.68134 .21278 L
.68135 .22717 L
.68136 .23347 L
.68136 .26398 L
.68137 .26211 L
.68139 .28665 L
.6814 .24946 L
.68141 .25132 L
.68143 .2326 L
.68144 .24499 L
.68145 .21458 L
.68146 .21916 L
.68147 .2725 L
.68149 .2583 L
.6815 .2899 L
.68151 .26066 L
.68152 .24996 L
.68153 .25195 L
Mistroke
.68155 .21399 L
.68156 .27311 L
.68158 .22928 L
.68159 .20721 L
.6816 .27628 L
.68162 .24555 L
.68163 .25052 L
.68164 .25346 L
.68165 .29461 L
.68166 .28972 L
.68167 .21038 L
.68168 .2388 L
.6817 .25168 L
.68171 .22034 L
.68173 .19162 L
.68174 .23407 L
.68175 .26417 L
.68177 .17998 L
.68178 .24962 L
.68179 .2305 L
.68181 .28349 L
.68182 .26178 L
.68183 .2665 L
.68185 .24643 L
.68186 .29351 L
.68187 .25984 L
.68189 .27369 L
.6819 .22888 L
.68192 .2172 L
.68193 .27889 L
.68195 .24615 L
.68196 .21283 L
.68196 .26054 L
.68198 .24622 L
.68199 .25226 L
.682 .24133 L
.68201 .24881 L
.68203 .27199 L
.68204 .29539 L
.68205 .25577 L
.68206 .26413 L
.68207 .25329 L
.68209 .22827 L
.6821 .21328 L
.68212 .25235 L
.68213 .22558 L
.68214 .23817 L
.68216 .25055 L
.68217 .24119 L
.68218 .2727 L
Mistroke
.6822 .28023 L
.68221 .23172 L
.68222 .26818 L
.68223 .23495 L
.68225 .19509 L
.68225 .1998 L
.68226 .28222 L
.68227 .22856 L
.68228 .24447 L
.6823 .26765 L
.68231 .24585 L
.68231 .23649 L
.68233 .25625 L
.68234 .26464 L
.68235 .2902 L
.68236 .24627 L
.68237 .24285 L
.68238 .23092 L
.68239 .24005 L
.6824 .24429 L
.68242 .20064 L
.68243 .19457 L
.68244 .23763 L
.68245 .24267 L
.68247 .20507 L
.68247 .24149 L
.68248 .26419 L
.68249 .24339 L
.6825 .23933 L
.68251 .25446 L
.68253 .21345 L
.68254 .22956 L
.68254 .22808 L
.68256 .21925 L
.68257 .25325 L
.68259 .20784 L
.6826 .24087 L
.68262 .249 L
.68263 .24895 L
.68264 .25385 L
.68266 .24316 L
.68267 .27389 L
.68268 .27138 L
.68269 .25306 L
.6827 .24822 L
.68272 .28274 L
.68273 .25482 L
.68273 .27365 L
.68275 .27147 L
.68276 .24203 L
Mistroke
.68278 .24491 L
.68279 .23017 L
.6828 .25768 L
.68281 .28218 L
.68282 .2535 L
.68282 .26026 L
.68284 .23379 L
.68285 .24961 L
.68286 .2339 L
.68287 .28154 L
.68288 .2354 L
.68289 .25283 L
.68291 .24056 L
.68291 .24081 L
.68292 .22352 L
.68294 .30016 L
.68295 .28303 L
.68297 .21268 L
.68298 .23757 L
.683 .24995 L
.68301 .20495 L
.68302 .2255 L
.68304 .22374 L
.68305 .25095 L
.68306 .25464 L
.68307 .24639 L
.68308 .24762 L
.68309 .23239 L
.6831 .19527 L
.68311 .24728 L
.68313 .21995 L
.68314 .26532 L
.68316 .25844 L
.68317 .26038 L
.68318 .24598 L
.6832 .2402 L
.68321 .2925 L
.68322 .23277 L
.68324 .22176 L
.68325 .22394 L
.68326 .28282 L
.68328 .29384 L
.68329 .2734 L
.68331 .22337 L
.68332 .21814 L
.68333 .22064 L
.68335 .24048 L
.68336 .24766 L
.68338 .21735 L
.68339 .24782 L
Mistroke
.68341 .26457 L
.68342 .21762 L
.68342 .28804 L
.68343 .24729 L
.68344 .21359 L
.68346 .23638 L
.68347 .27823 L
.68348 .26736 L
.6835 .22318 L
.68351 .27273 L
.68353 .23904 L
.68354 .25484 L
.68355 .20575 L
.68357 .25455 L
.68358 .23637 L
.6836 .28695 L
.68361 .27555 L
.68367 .21617 L
.68368 .27041 L
.68369 .24801 L
.6837 .24324 L
.6837 .19106 L
.68372 .23405 L
.68373 .21165 L
.68373 .2717 L
.68374 .27615 L
.68375 .26029 L
.68377 .2133 L
.68378 .25648 L
.68378 .29908 L
.68379 .21525 L
.6838 .25865 L
.68382 .25388 L
.68383 .24308 L
.68383 .27761 L
.68385 .27069 L
.68386 .25038 L
.68388 .2555 L
.68389 .25637 L
.68391 .24962 L
.68392 .22292 L
.68393 .2637 L
.68395 .28577 L
.68396 .2372 L
.68396 .24766 L
.68398 .24311 L
.68399 .23167 L
.684 .27981 L
.684 .25795 L
.68401 .2884 L
Mistroke
.68403 .19045 L
.68404 .26215 L
.68404 .21923 L
.68406 .25717 L
.68407 .23235 L
.68409 .29895 L
.6841 .24358 L
.68412 .25404 L
.68413 .25809 L
.68414 .23586 L
.68416 .286 L
.68417 .24431 L
.68418 .24179 L
.6842 .26188 L
.68421 .20826 L
.68422 .24155 L
.68424 .24961 L
.68425 .26664 L
.68426 .2288 L
.68428 .23937 L
.68429 .31086 L
.68429 .23721 L
.68431 .26832 L
.68432 .27073 L
.68434 .23135 L
.68435 .212 L
.68437 .29038 L
.68438 .25235 L
.6844 .25998 L
.68441 .21492 L
.68442 .24196 L
.68444 .29903 L
.68445 .19458 L
.68447 .2265 L
.68448 .23969 L
.6845 .23677 L
.68451 .25116 L
.68452 .23068 L
.68453 .22159 L
.68454 .24026 L
.68456 .27782 L
.68457 .29728 L
.68459 .26517 L
.6846 .25083 L
.68461 .25479 L
.68463 .26314 L
.68464 .23656 L
.68465 .25685 L
.68466 .22912 L
.68468 .21536 L
Mistroke
.68469 .25646 L
.68471 .18135 L
.68472 .24187 L
.68473 .24394 L
.68474 .21443 L
.68475 .24254 L
.68476 .25927 L
.68478 .22868 L
.68479 .29548 L
.68481 .246 L
.68482 .2206 L
.68484 .19622 L
.68485 .22747 L
.68486 .22741 L
.68488 .24928 L
.68489 .29707 L
.68491 .22241 L
.68492 .23676 L
.68494 .22935 L
.68495 .24534 L
.68497 .25905 L
.68497 .2031 L
.68498 .27294 L
.68499 .23809 L
.685 .24058 L
.68501 .24509 L
.68503 .22616 L
.68504 .19169 L
.68505 .25369 L
.68507 .22504 L
.68508 .28783 L
.6851 .23466 L
.68511 .2425 L
.68513 .2398 L
.68514 .25463 L
.68515 .23981 L
.68517 .29042 L
.68518 .24762 L
.6852 .2167 L
.68521 .26648 L
.68522 .21529 L
.68523 .26094 L
.68525 .253 L
.68526 .27866 L
.68526 .23895 L
.68528 .28888 L
.68529 .22218 L
.68531 .23788 L
.68532 .21174 L
.68533 .24842 L
Mistroke
.68535 .21242 L
.68536 .26866 L
.68537 .27329 L
.68538 .23932 L
.68539 .2646 L
.6854 .26467 L
.68541 .2439 L
.68543 .24438 L
.68544 .23383 L
.68546 .24271 L
.68547 .2551 L
.68548 .27136 L
.6855 .20675 L
.68551 .23334 L
.68552 .21785 L
.68553 .26225 L
.68555 .2114 L
.68556 .27755 L
.68558 .25757 L
.68559 .23543 L
.6856 .2894 L
.68562 .25873 L
.68563 .25854 L
.68565 .25469 L
.68566 .2303 L
.68567 .2772 L
.68569 .23044 L
.6857 .27888 L
.68572 .22309 L
.68573 .2297 L
.68574 .285 L
.68574 .26801 L
.68575 .27293 L
.68577 .2268 L
.68578 .2762 L
.6858 .21187 L
.68581 .22804 L
.68583 .24403 L
.68584 .26057 L
.68585 .25702 L
.68587 .24786 L
.68588 .20768 L
.6859 .26152 L
.68591 .25309 L
.68592 .24472 L
.68594 .23541 L
.68595 .25862 L
.68597 .25699 L
.68598 .22672 L
.686 .27669 L
Mistroke
.68601 .27777 L
.68601 .24362 L
.68603 .27794 L
.68604 .21857 L
.68605 .21046 L
.68605 .24661 L
.68606 .2677 L
.68608 .27182 L
.68609 .22306 L
.68609 .24462 L
.6861 .29889 L
.68611 .26585 L
.68612 .27215 L
.68613 .21797 L
.68614 .20953 L
.68615 .2896 L
.68616 .24227 L
.68617 .27033 L
.68619 .32367 L
.68621 .27781 L
.68622 .26114 L
.68623 .24694 L
.68625 .22393 L
.68626 .25685 L
.68627 .24263 L
.68629 .22998 L
.6863 .25032 L
.68632 .25185 L
.68633 .23033 L
.68635 .28586 L
.68636 .25865 L
.68637 .23621 L
.68638 .24319 L
.68639 .26132 L
.68641 .25865 L
.68642 .26076 L
.68643 .24866 L
.68645 .22706 L
.68646 .30084 L
.68647 .24483 L
.68649 .24904 L
.6865 .26226 L
.68651 .27051 L
.68653 .26596 L
.68654 .277 L
.68654 .24604 L
.68656 .24657 L
.68657 .2183 L
.68659 .2077 L
.6866 .27109 L
Mistroke
.68661 .22651 L
.68663 .22835 L
.68664 .24141 L
.68665 .25495 L
.68666 .2361 L
.68667 .26715 L
.68669 .25853 L
.68672 .24726 L
.68673 .23831 L
.68675 .23242 L
.68675 .24395 L
.68676 .27116 L
.68677 .24802 L
.68678 .25901 L
.68679 .24624 L
.6868 .25205 L
.68681 .22783 L
.68683 .22679 L
.68684 .24342 L
.68685 .23267 L
.68687 .24539 L
.68688 .18864 L
.68689 .26526 L
.68691 .25593 L
.68692 .22985 L
.68693 .21551 L
.68695 .24739 L
.68696 .29038 L
.68698 .25415 L
.68699 .21565 L
.687 .26695 L
.68702 .29834 L
.68703 .25377 L
.68705 .27466 L
.68706 .2249 L
.68707 .25334 L
.68709 .25243 L
.68711 .2358 L
.68712 .28429 L
.68714 .2376 L
.68714 .24093 L
.68715 .21584 L
.68717 .25595 L
.68718 .23666 L
.68718 .31961 L
.6872 .31705 L
.68721 .22831 L
.68723 .23928 L
.68724 .25476 L
.68725 .22022 L
Mistroke
.68727 .27272 L
.68728 .28252 L
.6873 .23327 L
.68731 .27403 L
.68732 .20184 L
.68734 .25759 L
.68735 .25235 L
.68737 .22061 L
.68738 .20133 L
.6874 .30024 L
.68741 .2227 L
.68741 .23922 L
.68743 .2403 L
.68744 .23974 L
.68745 .2439 L
.68745 .22371 L
.68746 .21152 L
.68748 .18261 L
.68749 .25836 L
.68749 .18527 L
.6875 .28234 L
.68751 .24709 L
.68752 .26555 L
.68753 .28175 L
.68754 .22813 L
.68754 .23802 L
.68756 .25757 L
.68757 .19876 L
.68759 .2669 L
.6876 .26465 L
.68762 .24794 L
.68763 .22064 L
.68765 .27388 L
.68766 .21519 L
.68767 .23844 L
.68769 .24687 L
.6877 .23716 L
.68772 .28476 L
.68773 .25496 L
.68775 .27347 L
.68776 .27486 L
.68777 .24611 L
.68778 .24658 L
.68779 .23659 L
.68781 .19716 L
.68782 .24096 L
.68783 .23192 L
.68785 .23038 L
.68786 .2598 L
.68788 .27212 L
Mistroke
.68789 .26693 L
.6879 .23335 L
.68791 .21533 L
.68793 .25098 L
.68794 .27441 L
.68796 .27613 L
.68797 .26599 L
.68798 .23955 L
.68799 .28073 L
.688 .25234 L
.68801 .24767 L
.68803 .25215 L
.68804 .22288 L
.68806 .24443 L
.68807 .27484 L
.68809 .20703 L
.6881 .2554 L
.68811 .3038 L
.68813 .23713 L
.68814 .22188 L
.68816 .27151 L
.68817 .23428 L
.68818 .25063 L
.6882 .26904 L
.68822 .24154 L
.68822 .23212 L
.68823 .21579 L
.68824 .26076 L
.68825 .29573 L
.68826 .23498 L
.68828 .26886 L
.68829 .22024 L
.6883 .24997 L
.68832 .27217 L
.68833 .3038 L
.68835 .21785 L
.68836 .23119 L
.68838 .24358 L
.68839 .25045 L
.6884 .239 L
.68842 .23559 L
.68843 .21291 L
.68844 .27171 L
.68846 .2616 L
.68847 .28021 L
.68848 .28138 L
.6885 .26859 L
.68851 .26404 L
.68853 .25845 L
.68854 .24215 L
Mistroke
.68856 .30212 L
.68857 .26531 L
.68858 .25782 L
.6886 .24328 L
.68861 .26045 L
.68863 .258 L
.68864 .26682 L
.68865 .21643 L
.68867 .24208 L
.68868 .24959 L
.68869 .26532 L
.68869 .18634 L
.6887 .2537 L
.68872 .24451 L
.68873 .24729 L
.68874 .26217 L
.68876 .25447 L
.68877 .24812 L
.68879 .24836 L
.6888 .29164 L
.68882 .24419 L
.68883 .24224 L
.68885 .26737 L
.68886 .26204 L
.68887 .22724 L
.68889 .24337 L
.6889 .24079 L
.68891 .25266 L
.68894 .27288 L
.68895 .24874 L
.68897 .28911 L
.68898 .25116 L
.68899 .21045 L
.68901 .28588 L
.68902 .23086 L
.68902 .25748 L
.68904 .19625 L
.68905 .23914 L
.68907 .25024 L
.68908 .24429 L
.68909 .24018 L
.68911 .26266 L
.68912 .27583 L
.68914 .18635 L
.68915 .25357 L
.68916 .281 L
.68918 .29081 L
.68919 .299 L
.68919 .25989 L
.68921 .23537 L
Mistroke
.68922 .20686 L
.68923 .27929 L
.68924 .24703 L
.68926 .22913 L
.68926 .22833 L
.68927 .23641 L
.68928 .26196 L
.68929 .27344 L
.68931 .26009 L
.68931 .26832 L
.68932 .27692 L
.68934 .28408 L
.68935 .24646 L
.68937 .22837 L
.68938 .26305 L
.6894 .30419 L
.68941 .28869 L
.68943 .26224 L
.68943 .24594 L
.68944 .23367 L
.68945 .26401 L
.68946 .23523 L
.68947 .26211 L
.68949 .24788 L
.6895 .25162 L
.68952 .22369 L
.68953 .22367 L
.68954 .26431 L
.68955 .20335 L
.68956 .27103 L
.68957 .24061 L
.68958 .25834 L
.6896 .20555 L
.68961 .25372 L
.68961 .24465 L
.68963 .25219 L
.68964 .25262 L
.68965 .24474 L
.68966 .27583 L
.68967 .23045 L
.68968 .26852 L
.68969 .26312 L
.68971 .25197 L
.68972 .28316 L
.68973 .27307 L
.68974 .22042 L
.68975 .25235 L
.68977 .27004 L
.68978 .28103 L
.68979 .24966 L
Mistroke
.6898 .29767 L
.68981 .24052 L
.68983 .25758 L
.68984 .26884 L
.68986 .22541 L
.68987 .26399 L
.68987 .26644 L
.68988 .27974 L
.68989 .2556 L
.6899 .2496 L
.68991 .21755 L
.68992 .27632 L
.68993 .27957 L
.68994 .26535 L
.68995 .24015 L
.68997 .25992 L
.68998 .25944 L
.68999 .25662 L
.69001 .24891 L
.69002 .22132 L
.69004 .23767 L
.69006 .2516 L
.69007 .28046 L
.69008 .28228 L
.69009 .26982 L
.6901 .22402 L
.69012 .2698 L
.69013 .27088 L
.69014 .26908 L
.69016 .29992 L
.69017 .26763 L
.69019 .24704 L
.6902 .24261 L
.69021 .25734 L
.69022 .20624 L
.69023 .27793 L
.69025 .27696 L
.69026 .23604 L
.69027 .28863 L
.69028 .23111 L
.6903 .25127 L
.69031 .27974 L
.69033 .24751 L
.69034 .20093 L
.69035 .22733 L
.69037 .26939 L
.69037 .22062 L
.69038 .26017 L
.6904 .2299 L
.69041 .19941 L
Mistroke
.69042 .19267 L
.69043 .26085 L
.69044 .29158 L
.69046 .23432 L
.69047 .21121 L
.69047 .26834 L
.69049 .19599 L
.6905 .23905 L
.69052 .23117 L
.69053 .31328 L
.69055 .26457 L
.69056 .21543 L
.69057 .2063 L
.69059 .27523 L
.6906 .24354 L
.69062 .239 L
.69063 .25579 L
.69065 .26074 L
.69066 .26491 L
.69066 .29214 L
.69068 .25869 L
.69069 .2577 L
.69071 .2449 L
.69072 .26549 L
.69073 .21926 L
.69074 .21972 L
.69076 .28951 L
.69076 .23031 L
.69077 .22982 L
.69078 .24446 L
.69079 .22765 L
.6908 .2745 L
.69081 .23362 L
.69082 .25185 L
.69082 .25193 L
.69084 .30074 L
.69085 .26864 L
.69087 .27382 L
.69088 .30774 L
.69088 .25701 L
.6909 .31757 L
.69091 .22186 L
.69093 .24864 L
.69094 .26768 L
.69095 .26253 L
.69097 .23962 L
.69098 .22264 L
.69099 .26698 L
.691 .2672 L
.69102 .24612 L
Mistroke
.69102 .29672 L
.69103 .2966 L
.69105 .24565 L
.69106 .2593 L
.69108 .2595 L
.69109 .25909 L
.6911 .2147 L
.69112 .24922 L
.69113 .2401 L
.69114 .27799 L
.69116 .25704 L
.69117 .2709 L
.69118 .23207 L
.6912 .20846 L
.69121 .25679 L
.69122 .21258 L
.69124 .26896 L
.69125 .25092 L
.69127 .20623 L
.69128 .22508 L
.6913 .26037 L
.69131 .26297 L
.69133 .29216 L
.69133 .28531 L
.69134 .2594 L
.69136 .25382 L
.69137 .25277 L
.69138 .23862 L
.6914 .28261 L
.69141 .25942 L
.69143 .21853 L
.69144 .23135 L
.69146 .27509 L
.69147 .24785 L
.69148 .2395 L
.69149 .25514 L
.6915 .23895 L
.69151 .23083 L
.69152 .21061 L
.69153 .27361 L
.69155 .24473 L
.69156 .23924 L
.69157 .24351 L
.69159 .2876 L
.6916 .23942 L
.69161 .2163 L
.69163 .25738 L
.69164 .23156 L
.69165 .26618 L
.69167 .24058 L
Mistroke
.69168 .24647 L
.6917 .23333 L
.69171 .24256 L
.69172 .21901 L
.69174 .23587 L
.69175 .24232 L
.69175 .21244 L
.69177 .21793 L
.69178 .23195 L
.69179 .23561 L
.6918 .25474 L
.69181 .26223 L
.69183 .25765 L
.69184 .25566 L
.69186 .2707 L
.69187 .26331 L
.69188 .27072 L
.69188 .23225 L
.69189 .25272 L
.6919 .28434 L
.69191 .26584 L
.69192 .25397 L
.69193 .25308 L
.69194 .28123 L
.69194 .24215 L
.69195 .24543 L
.69196 .2524 L
.69198 .26425 L
.69199 .25055 L
.69199 .27276 L
.69201 .2592 L
.69203 .27661 L
.69204 .20331 L
.69205 .25275 L
.69207 .22414 L
.69208 .25547 L
.6921 .22011 L
.6921 .25956 L
.69211 .24593 L
.69213 .24258 L
.69214 .23578 L
.69215 .2326 L
.69216 .22042 L
.69217 .25439 L
.69218 .2588 L
.69219 .22303 L
.6922 .25525 L
.69221 .21832 L
.69222 .24289 L
.69224 .25901 L
Mistroke
.69225 .23393 L
.69227 .24381 L
.69228 .29655 L
.6923 .30153 L
.69231 .27807 L
.69232 .25296 L
.69234 .23082 L
.69235 .23978 L
.69236 .23633 L
.69237 .28024 L
.69238 .21633 L
.69239 .26531 L
.6924 .25924 L
.69241 .26728 L
.69242 .25663 L
.69242 .2399 L
.69243 .22355 L
.69245 .22061 L
.69246 .26484 L
.69248 .22689 L
.69249 .2545 L
.69251 .25238 L
.69252 .29157 L
.69253 .26333 L
.69255 .26095 L
.69256 .27507 L
.69257 .24498 L
.69259 .23311 L
.6926 .26499 L
.69261 .27285 L
.69263 .25317 L
.69264 .25065 L
.69265 .22599 L
.69267 .25689 L
.69268 .23459 L
.69269 .3146 L
.6927 .2617 L
.69271 .24344 L
.69273 .2442 L
.69274 .25565 L
.69276 .22019 L
.69277 .25932 L
.69279 .28574 L
.6928 .22282 L
.69281 .24494 L
.69283 .25632 L
.69284 .21355 L
.69285 .28034 L
.69286 .25703 L
.69287 .28718 L
Mistroke
.69287 .29318 L
.69289 .21086 L
.6929 .24492 L
.69292 .28303 L
.69293 .25672 L
.69295 .23123 L
.69296 .25414 L
.69298 .25637 L
.69299 .26609 L
.693 .31565 L
.69302 .28201 L
.69303 .24124 L
.69305 .26964 L
.69306 .23046 L
.69307 .24329 L
.69308 .2632 L
.69309 .26252 L
.6931 .21807 L
.69311 .24375 L
.69313 .30229 L
.69314 .21571 L
.69316 .23456 L
.69317 .27347 L
.69318 .22588 L
.6932 .21169 L
.69321 .29193 L
.69323 .25426 L
.69324 .2694 L
.69324 .26782 L
.69326 .26489 L
.69327 .26146 L
.69327 .25118 L
.69329 .25477 L
.6933 .22663 L
.69332 .23472 L
.69333 .32682 L
.69334 .21969 L
.69336 .22643 L
.69337 .25108 L
.69339 .23998 L
.6934 .25424 L
.69342 .23994 L
.69343 .25619 L
.69344 .25151 L
.69346 .21355 L
.69347 .27393 L
.69349 .25541 L
.6935 .21749 L
.6935 .22636 L
.69352 .24221 L
Mistroke
.69353 .24547 L
.69354 .26294 L
.69354 .27685 L
.69355 .2388 L
.69356 .24447 L
.69357 .27951 L
.69358 .29903 L
.6936 .26158 L
.69361 .2726 L
.69362 .22939 L
.69363 .27328 L
.69364 .28397 L
.69365 .29043 L
.69366 .23883 L
.69367 .2373 L
.69368 .24411 L
.69369 .27599 L
.69371 .3076 L
.69372 .21261 L
.69374 .26489 L
.69375 .25665 L
.69376 .21704 L
.69378 .256 L
.69379 .24899 L
.69381 .27818 L
.69382 .24853 L
.69384 .2749 L
.69385 .26375 L
.69386 .29274 L
.69387 .27061 L
.69388 .2755 L
.6939 .24514 L
.69391 .26186 L
.69393 .28706 L
.69394 .20894 L
.69395 .31972 L
.69397 .22686 L
.69398 .26126 L
.69399 .28824 L
.694 .23201 L
.69402 .2522 L
.69403 .22992 L
.69405 .2206 L
.69406 .22168 L
.69407 .27245 L
.69408 .27789 L
.69409 .28825 L
.6941 .282 L
.69412 .26723 L
.69413 .27559 L
Mistroke
.69415 .28181 L
.69416 .29749 L
.69418 .27836 L
.69419 .25279 L
.6942 .26738 L
.69422 .25595 L
.69423 .26127 L
.69425 .26068 L
.69426 .22701 L
.69427 .26018 L
.69429 .28618 L
.69431 .2639 L
.69431 .26809 L
.69432 .26181 L
.69434 .25621 L
.69435 .25582 L
.69437 .28741 L
.69438 .27059 L
.69439 .23904 L
.69441 .21888 L
.69442 .28132 L
.69443 .27269 L
.69444 .24843 L
.69446 .27683 L
.69447 .24286 L
.69449 .23738 L
.6945 .22274 L
.69451 .22081 L
.69453 .2566 L
.69454 .25092 L
.69454 .23642 L
.69456 .25324 L
.69457 .23022 L
.69459 .27013 L
.6946 .27816 L
.69462 .24485 L
.69463 .27751 L
.69464 .28177 L
.69466 .25072 L
.69467 .26248 L
.69468 .25684 L
.6947 .27372 L
.69472 .2436 L
.69473 .24148 L
.69474 .24232 L
.69476 .25741 L
.69477 .24796 L
.69478 .26898 L
.69478 .25453 L
.69479 .26641 L
Mistroke
.69481 .2274 L
.69482 .25888 L
.69483 .25168 L
.69486 .23368 L
.69488 .27392 L
.69489 .21296 L
.6949 .25901 L
.69491 .23535 L
.69492 .23208 L
.69493 .23098 L
.69495 .21518 L
.69496 .28243 L
.69497 .24167 L
.69499 .25741 L
.695 .25575 L
.69501 .26402 L
.69503 .28666 L
.69504 .26171 L
.69506 .29194 L
.69507 .24992 L
.69509 .32181 L
.6951 .26826 L
.69511 .27646 L
.69513 .30148 L
.69514 .25519 L
.69515 .22539 L
.69517 .22254 L
.69518 .29936 L
.6952 .26283 L
.69521 .3036 L
.69522 .20703 L
.69523 .22789 L
.69525 .24179 L
.69526 .26217 L
.69527 .18377 L
.69529 .2634 L
.6953 .28592 L
.69532 .26585 L
.69533 .25204 L
.69534 .27486 L
.69535 .23349 L
.69537 .26519 L
.69538 .25553 L
.69539 .28095 L
.69541 .27151 L
.69542 .30673 L
.69544 .24741 L
.69544 .27111 L
.69545 .28065 L
.69547 .2528 L
Mistroke
.69548 .25321 L
.6955 .28938 L
.69551 .27949 L
.69553 .26707 L
.69554 .22767 L
.69555 .27671 L
.69557 .22691 L
.69558 .31701 L
.69559 .24101 L
.69561 .27167 L
.69562 .20225 L
.69564 .24294 L
.69565 .27398 L
.69567 .22935 L
.69568 .24662 L
.69569 .26206 L
.6957 .24045 L
.69572 .23158 L
.69573 .28111 L
.69574 .26723 L
.69576 .28501 L
.69577 .27163 L
.69578 .24986 L
.69579 .22778 L
.69581 .24934 L
.69582 .26941 L
.69583 .22438 L
.69585 .24246 L
.69586 .1828 L
.69588 .26101 L
.69589 .23228 L
.6959 .27645 L
.69591 .269 L
.69592 .26994 L
.69594 .27122 L
.69595 .26825 L
.69596 .24628 L
.69597 .22343 L
.69598 .23163 L
.696 .2678 L
.69601 .25256 L
.69602 .29178 L
.69603 .302 L
.69605 .2394 L
.69606 .29989 L
.69607 .27418 L
.69608 .26319 L
.6961 .2592 L
.69611 .20024 L
.69611 .25221 L
Mistroke
.69613 .26743 L
.69614 .26678 L
.69616 .26691 L
.69617 .2624 L
.69618 .25696 L
.6962 .23286 L
.69621 .25234 L
.69622 .27884 L
.69624 .24232 L
.69625 .2577 L
.69627 .25531 L
.69628 .23767 L
.69629 .20864 L
.69631 .23849 L
.69632 .26414 L
.69633 .29797 L
.69635 .29819 L
.69636 .27424 L
.69638 .25186 L
.69639 .28135 L
.69641 .23193 L
.69642 .28431 L
.69643 .21847 L
.69644 .25963 L
.69645 .25728 L
.69645 .28906 L
.69647 .24536 L
.69648 .23504 L
.6965 .25358 L
.69651 .26099 L
.69653 .26968 L
.69654 .25831 L
.69655 .20957 L
.69657 .23625 L
.69658 .2641 L
.6966 .26954 L
.69661 .26282 L
.69663 .24734 L
.69664 .26822 L
.69666 .20906 L
.69667 .24935 L
.69668 .28166 L
.6967 .23299 L
.69671 .25143 L
.69672 .25231 L
.69673 .25131 L
.69674 .23426 L
.69675 .25183 L
.69676 .27603 L
.69676 .25833 L
Mistroke
.69678 .26433 L
.69679 .24282 L
.6968 .28143 L
.69681 .23793 L
.69681 .20264 L
.69682 .22928 L
.69683 .22459 L
.69684 .2456 L
.69685 .25472 L
.69686 .23327 L
.69688 .27192 L
.69689 .22558 L
.69691 .20683 L
.69692 .25215 L
.69694 .30277 L
.69695 .21425 L
.69696 .27352 L
.69698 .24941 L
.69699 .27936 L
.69701 .30593 L
.69702 .24422 L
.69703 .29919 L
.69705 .22271 L
.69706 .22692 L
.69707 .27845 L
.69708 .23354 L
.6971 .24712 L
.69711 .32238 L
.69712 .26385 L
.69714 .25896 L
.69715 .24938 L
.69717 .21892 L
.69718 .24594 L
.69719 .23185 L
.6972 .24914 L
.69722 .25264 L
.69723 .22174 L
.69725 .25758 L
.69726 .28515 L
.69727 .26161 L
.69729 .28877 L
.6973 .28718 L
.6973 .28201 L
.69732 .23108 L
.69733 .25044 L
.69735 .21279 L
.69736 .26684 L
.69738 .28062 L
.69739 .19885 L
.6974 .25415 L
Mistroke
.69742 .28258 L
.69743 .26336 L
.69745 .29267 L
.69746 .26781 L
.69748 .25471 L
.69749 .2845 L
.6975 .27964 L
.69751 .2481 L
.69752 .24451 L
.69753 .29917 L
.69754 .25235 L
.69755 .22625 L
.69757 .26377 L
.69758 .22309 L
.69759 .27778 L
.69761 .30235 L
.69762 .26592 L
.69764 .27933 L
.69765 .19568 L
.69767 .27072 L
.69768 .21814 L
.69769 .25246 L
.69771 .25348 L
.69772 .25978 L
.69774 .27535 L
.69775 .22735 L
.69776 .24217 L
.69777 .25306 L
.69779 .28512 L
.6978 .24618 L
.69782 .24294 L
.69783 .265 L
.69784 .29391 L
.69786 .27439 L
.69787 .26111 L
.69788 .26159 L
.69789 .23421 L
.6979 .28837 L
.69792 .22747 L
.69793 .28214 L
.69795 .26036 L
.69796 .24454 L
.69797 .27352 L
.69799 .2433 L
.698 .216 L
.69801 .25319 L
.69803 .26535 L
.69804 .23578 L
.69805 .26983 L
.69806 .24282 L
Mistroke
.69807 .28949 L
.69809 .29309 L
.6981 .26074 L
.69812 .29062 L
.69813 .25562 L
.69814 .24323 L
.69815 .27496 L
.69816 .29308 L
.69817 .27885 L
.69818 .24857 L
.69819 .24611 L
.6982 .2828 L
.69821 .30001 L
.69823 .25694 L
.69824 .27639 L
.69825 .23718 L
.69826 .27673 L
.69827 .29599 L
.69829 .27328 L
.6983 .26962 L
.69832 .28998 L
.69833 .26307 L
.69834 .26373 L
.69835 .24903 L
.69837 .23585 L
.69838 .26216 L
.69839 .24635 L
.69841 .24672 L
.69842 .25348 L
.69843 .24674 L
.69845 .25606 L
.69846 .26216 L
.69849 .27544 L
.69851 .22455 L
.69852 .28231 L
.69853 .22542 L
.69854 .23282 L
.69855 .29672 L
.69857 .28056 L
.69858 .21372 L
.69859 .24562 L
.69861 .2534 L
.69862 .24922 L
.69863 .2842 L
.69864 .28706 L
.69865 .23715 L
.69866 .24233 L
.69867 .24639 L
.69868 .28957 L
.69868 .27634 L
Mistroke
.69869 .28555 L
.6987 .25632 L
.69871 .24006 L
.69872 .28712 L
.69874 .24553 L
.69875 .25913 L
.69877 .23071 L
.69878 .25096 L
.6988 .24254 L
.69881 .29103 L
.69882 .28287 L
.69884 .25 L
.69885 .24447 L
.69887 .24357 L
.69888 .25545 L
.6989 .24505 L
.69891 .23177 L
.69893 .26834 L
.69894 .23569 L
.69894 .26555 L
.69896 .23826 L
.69897 .23013 L
.69899 .24536 L
.699 .25505 L
.69902 .24211 L
.69903 .24827 L
.69904 .22916 L
.69905 .23648 L
.69907 .27509 L
.69908 .20874 L
.69909 .29084 L
.69911 .23644 L
.69912 .24158 L
.69913 .24748 L
.69915 .26549 L
.69916 .25327 L
.69916 .29448 L
.69918 .24546 L
.69919 .21512 L
.69921 .24055 L
.69922 .2818 L
.69924 .27207 L
.69925 .28424 L
.69927 .27768 L
.69928 .23615 L
.69929 .26404 L
.69931 .26415 L
.69932 .22576 L
.69934 .24996 L
.69935 .24808 L
Mistroke
.69937 .26253 L
.69938 .24175 L
.69939 .2762 L
.6994 .2557 L
.69941 .22591 L
.69943 .24333 L
.69944 .26725 L
.69946 .24864 L
.69947 .24164 L
.69948 .25983 L
.6995 .23797 L
.69951 .26036 L
.69952 .23256 L
.69953 .2412 L
.69955 .24746 L
.69956 .25987 L
.69958 .28492 L
.69959 .22516 L
.6996 .25511 L
.69961 .26756 L
.69962 .243 L
.69963 .21512 L
.69965 .26439 L
.69966 .26198 L
.69967 .21425 L
.69968 .26648 L
.69969 .26103 L
.69971 .19406 L
.69972 .21209 L
.69973 .22375 L
.69976 .25002 L
.69978 .25429 L
.69979 .27296 L
.69981 .2535 L
.69982 .28236 L
.69984 .23428 L
.69985 .26308 L
.69985 .25211 L
.69987 .2659 L
.69988 .27062 L
.6999 .29079 L
.69991 .28941 L
.69993 .26905 L
.69994 .24193 L
.69995 .2784 L
.69996 .23903 L
.69998 .2501 L
.69999 .19551 L
.7 .24191 L
.70002 .26717 L
Mistroke
.70003 .2397 L
.70004 .25713 L
.70006 .27178 L
.70007 .25134 L
.70008 .25769 L
.70009 .24645 L
.7001 .24008 L
.70012 .24132 L
.70013 .24429 L
.70013 .23774 L
.70015 .24729 L
.70016 .24066 L
.70018 .19783 L
.70019 .23757 L
.7002 .23573 L
.70022 .27508 L
.70023 .2452 L
.70024 .23716 L
.70025 .25475 L
.70027 .27197 L
.70027 .23133 L
.70028 .30256 L
.7003 .27056 L
.70031 .23337 L
.70033 .23077 L
.70034 .25816 L
.70035 .27344 L
.70037 .28703 L
.70038 .19788 L
.70039 .23591 L
.7004 .26501 L
.70042 .25432 L
.70043 .25895 L
.70045 .21312 L
.70046 .20376 L
.70048 .24025 L
.70049 .26433 L
.7005 .23591 L
.70052 .28313 L
.70053 .18037 L
.70055 .25367 L
.70056 .29046 L
.70058 .29097 L
.70059 .25948 L
.7006 .23709 L
.70061 .2627 L
.70062 .26009 L
.70062 .29863 L
.70064 .24062 L
.70065 .25159 L
Mistroke
.70067 .23792 L
.70068 .22608 L
.7007 .27542 L
.70071 .25906 L
.70072 .27169 L
.70074 .21797 L
.70075 .25321 L
.70077 .27615 L
.70078 .24211 L
.7008 .26884 L
.70081 .2394 L
.70083 .2627 L
.70084 .29211 L
.70085 .27057 L
.70087 .22313 L
.70088 .28053 L
.70089 .26506 L
.7009 .2532 L
.70091 .29547 L
.70092 .24256 L
.70093 .27805 L
.70094 .29443 L
.70095 .25836 L
.70096 .282 L
.70098 .24985 L
.70099 .27618 L
.701 .26758 L
.70101 .24202 L
.70101 .23757 L
.70103 .25683 L
.70104 .31132 L
.70105 .24577 L
.70106 .33601 L
.70108 .25687 L
.70109 .26776 L
.7011 .29262 L
.70112 .25737 L
.70113 .20629 L
.70113 .24564 L
.70115 .27002 L
.70116 .24217 L
.70118 .24892 L
.70119 .22835 L
.7012 .26431 L
.70122 .23395 L
.70123 .2943 L
.70124 .28068 L
.70126 .26281 L
.70127 .27273 L
.70129 .24772 L
Mistroke
.7013 .24135 L
.7013 .24883 L
.70132 .30914 L
.70133 .25885 L
.70134 .25679 L
.70135 .26186 L
.70136 .24134 L
.70137 .25872 L
.70138 .22919 L
.70139 .28313 L
.7014 .28487 L
.70141 .27072 L
.70142 .24087 L
.70143 .2685 L
.70145 .25281 L
.70146 .24161 L
.70148 .25664 L
.70149 .28429 L
.7015 .26805 L
.70152 .24411 L
.70153 .26955 L
.70154 .23253 L
.70155 .22852 L
.70157 .24338 L
.70157 .24651 L
.70158 .24925 L
.7016 .22402 L
.70161 .2581 L
.70163 .27922 L
.70164 .27091 L
.70166 .23488 L
.70167 .26479 L
.70168 .30599 L
.70169 .28287 L
.7017 .31179 L
.70171 .24213 L
.70172 .26912 L
.70173 .30927 L
.70174 .2893 L
.70175 .21975 L
.70176 .27435 L
.70177 .31052 L
.70177 .26339 L
.70178 .25851 L
.70179 .26593 L
.70181 .28958 L
.70182 .28041 L
.70183 .25382 L
.70185 .28012 L
.70186 .24617 L
Mistroke
.70187 .22723 L
.70187 .28488 L
.70188 .258 L
.70189 .24082 L
.7019 .27051 L
.70191 .2996 L
.70193 .261 L
.70194 .27619 L
.70196 .24609 L
.70197 .30219 L
.70198 .22427 L
.70199 .2519 L
.702 .22563 L
.70202 .22447 L
.70203 .30935 L
.70204 .23978 L
.70205 .26407 L
.70206 .25685 L
.70208 .28339 L
.70209 .25079 L
.7021 .26335 L
.70212 .27413 L
.70213 .24111 L
.70215 .24688 L
.70215 .28194 L
.70216 .21479 L
.70218 .23466 L
.70219 .23859 L
.70219 .24594 L
.70221 .25591 L
.70222 .26818 L
.70224 .24695 L
.70225 .27447 L
.70227 .23515 L
.70228 .26967 L
.70229 .23148 L
.7023 .28585 L
.70232 .31529 L
.70233 .27829 L
.70235 .32744 L
.70236 .26818 L
.70237 .25352 L
.70239 .30426 L
.7024 .2439 L
.70242 .23585 L
.70243 .23207 L
.70245 .23431 L
.70246 .24336 L
.70247 .27863 L
.70248 .24239 L
Mistroke
.70249 .2728 L
.7025 .2595 L
.70251 .21137 L
.70252 .26665 L
.70253 .23789 L
.70254 .23479 L
.70255 .24392 L
.70257 .26144 L
.70258 .23169 L
.70259 .26269 L
.7026 .28727 L
.70261 .2817 L
.70262 .26573 L
.70264 .2292 L
.70265 .23458 L
.70267 .26522 L
.70268 .25186 L
.70269 .2675 L
.70271 .29367 L
.70272 .23008 L
.70273 .24333 L
.70273 .26356 L
.70274 .24999 L
.70276 .27917 L
.70277 .27796 L
.70278 .25963 L
.70279 .23198 L
.7028 .26021 L
.70281 .2629 L
.70282 .27187 L
.70283 .2222 L
.70284 .29179 L
.70285 .24942 L
.70287 .25929 L
.7029 .28097 L
.70291 .26011 L
.70292 .24981 L
.70293 .30593 L
.70295 .27911 L
.70296 .24528 L
.70298 .24012 L
.70298 .28596 L
.70299 .27874 L
.70301 .29833 L
.70302 .24231 L
.70303 .29416 L
.70305 .24084 L
.70306 .24964 L
.70308 .25673 L
.70309 .26311 L
Mistroke
.7031 .24122 L
.70311 .25781 L
.70312 .26672 L
.70313 .29938 L
.70314 .27216 L
.70315 .25445 L
.70317 .24014 L
.70318 .25474 L
.7032 .27205 L
.70321 .23291 L
.70322 .27796 L
.70324 .21589 L
.70325 .27745 L
.70326 .26891 L
.70328 .26066 L
.70329 .27549 L
.7033 .26308 L
.70332 .2757 L
.70333 .22458 L
.70335 .25961 L
.70336 .24394 L
.70337 .26951 L
.70339 .25376 L
.7034 .25753 L
.70342 .26548 L
.70343 .24967 L
.70345 .24036 L
.70346 .25963 L
.70346 .27939 L
.70347 .27281 L
.70348 .25031 L
.7035 .30125 L
.70351 .28781 L
.70352 .22738 L
.70353 .28793 L
.70354 .26172 L
.70355 .28201 L
.70357 .2645 L
.70358 .24375 L
.7036 .27655 L
.70361 .26851 L
.70362 .30214 L
.70364 .27205 L
.70365 .26951 L
.70367 .27934 L
.70368 .26502 L
.70369 .2557 L
.7037 .2544 L
.70371 .28387 L
.70373 .284 L
Mistroke
.70374 .26477 L
.70376 .2516 L
.70377 .25532 L
.70378 .29089 L
.70379 .26985 L
.7038 .22472 L
.70381 .29214 L
.70382 .27279 L
.70383 .24345 L
.70384 .26318 L
.70385 .28472 L
.70386 .25193 L
.70387 .25872 L
.70387 .2966 L
.70389 .2567 L
.7039 .27271 L
.70392 .23603 L
.70393 .26662 L
.70395 .24559 L
.70396 .24035 L
.70398 .29003 L
.70399 .22854 L
.704 .23935 L
.70402 .24179 L
.70403 .21645 L
.70405 .27863 L
.70406 .28995 L
.70408 .26988 L
.70409 .2679 L
.7041 .22046 L
.70411 .27092 L
.70412 .26265 L
.70414 .24815 L
.70415 .27126 L
.70417 .28712 L
.70418 .2544 L
.70419 .23924 L
.70421 .27733 L
.70422 .26304 L
.70423 .27523 L
.70424 .20477 L
.70426 .28958 L
.70427 .2597 L
.70429 .28861 L
.7043 .25983 L
.70431 .24084 L
.70432 .26999 L
.70433 .24087 L
.70434 .22466 L
.70436 .26511 L
Mistroke
.70437 .23415 L
.70438 .27521 L
.70439 .26606 L
.7044 .24237 L
.70442 .27564 L
.70443 .23537 L
.70444 .28082 L
.70446 .27815 L
.70447 .24407 L
.70449 .2913 L
.7045 .26218 L
.7045 .24562 L
.70452 .26898 L
.70453 .25743 L
.70454 .24985 L
.70455 .2672 L
.70457 .24542 L
.70458 .28076 L
.70459 .32575 L
.70461 .22803 L
.70462 .23565 L
.70463 .22823 L
.70464 .26405 L
.70466 .26032 L
.70467 .28288 L
.70469 .24283 L
.7047 .25794 L
.70472 .24945 L
.70473 .26368 L
.70474 .26633 L
.70476 .2278 L
.70477 .23301 L
.70479 .26438 L
.7048 .29733 L
.70481 .22181 L
.70483 .21403 L
.70484 .24047 L
.70485 .25675 L
.70486 .24089 L
.70487 .27428 L
.70488 .23784 L
.70489 .20699 L
.70491 .32777 L
.70492 .25658 L
.70494 .27498 L
.70495 .25334 L
.70496 .25807 L
.70498 .22606 L
.70499 .24721 L
.705 .30132 L
Mistroke
.70502 .19921 L
.70503 .28262 L
.70505 .23652 L
.70506 .26624 L
.70508 .26059 L
.70509 .28081 L
.70511 .28289 L
.70512 .24939 L
.70513 .28735 L
.70514 .30435 L
.70515 .25188 L
.70516 .27593 L
.70517 .24212 L
.70518 .2395 L
.70519 .23155 L
.7052 .24738 L
.70521 .2631 L
.70522 .24613 L
.70523 .28969 L
.70524 .29742 L
.70525 .25792 L
.70527 .24776 L
.70528 .24223 L
.70529 .203 L
.7053 .2308 L
.70531 .26219 L
.70533 .27538 L
.70534 .25007 L
.70535 .26914 L
.70537 .27948 L
.70538 .25148 L
.70539 .24155 L
.7054 .28043 L
.70542 .27434 L
.70543 .23691 L
.70545 .23483 L
.70546 .25962 L
.70548 .28839 L
.70548 .25978 L
.70549 .29988 L
.7055 .26859 L
.70551 .27342 L
.70552 .2823 L
.70553 .2531 L
.70554 .25083 L
.70555 .26933 L
.70557 .25226 L
.70558 .26121 L
.70559 .24083 L
.7056 .26244 L
Mistroke
.70562 .26131 L
.70563 .27802 L
.70565 .28063 L
.70566 .22907 L
.70567 .26638 L
.70569 .28553 L
.7057 .29152 L
.70572 .26143 L
.70573 .24661 L
.70575 .25713 L
.70576 .26836 L
.70578 .23986 L
.70579 .29523 L
.7058 .28715 L
.70581 .27158 L
.70582 .25525 L
.70584 .23032 L
.70585 .22487 L
.70585 .2635 L
.70587 .27385 L
.70588 .30265 L
.7059 .21684 L
.70591 .23376 L
.70592 .22775 L
.70594 .26092 L
.70595 .24242 L
.70597 .25901 L
.70598 .25224 L
.70599 .26204 L
.70601 .24423 L
.70602 .24892 L
.70604 .2677 L
.70605 .28164 L
.70607 .22923 L
.70608 .24772 L
.70608 .27485 L
.7061 .26407 L
.70611 .22945 L
.70612 .24336 L
.70612 .24794 L
.70613 .28495 L
.70615 .26708 L
.70616 .28071 L
.70616 .26559 L
.70617 .3046 L
.70618 .25168 L
.70619 .25761 L
.7062 .30339 L
.70621 .2842 L
.70621 .25497 L
Mistroke
.70623 .2597 L
.70624 .24099 L
.70626 .25767 L
.70627 .23111 L
.70629 .2671 L
.7063 .25509 L
.70632 .29134 L
.70633 .27108 L
.70634 .24845 L
.70636 .27092 L
.70637 .2248 L
.70639 .27649 L
.7064 .29652 L
.70642 .25743 L
.70643 .28521 L
.70644 .23298 L
.70645 .3065 L
.70646 .29349 L
.70646 .27352 L
.70648 .27212 L
.70649 .26124 L
.7065 .28342 L
.70652 .2823 L
.70653 .25727 L
.70655 .26561 L
.70656 .25476 L
.70658 .29569 L
.70659 .25876 L
.7066 .29896 L
.70662 .26155 L
.70663 .2562 L
.70665 .21789 L
.70666 .30831 L
.70667 .28707 L
.70668 .28411 L
.7067 .2506 L
.70671 .20196 L
.70672 .30437 L
.70673 .24792 L
.70674 .21554 L
.70676 .25145 L
.70677 .25364 L
.70677 .27945 L
.70678 .27333 L
.70679 .29418 L
.70681 .27148 L
.70682 .26579 L
.70683 .29469 L
.70685 .2438 L
.70686 .26067 L
Mistroke
.70687 .20773 L
.70689 .27249 L
.7069 .27386 L
.70692 .24304 L
.70693 .28237 L
.70695 .25793 L
.70696 .20997 L
.70697 .23294 L
.70697 .31241 L
.70698 .28386 L
.707 .23531 L
.70701 .29405 L
.70703 .25366 L
.70704 .29027 L
.70706 .27268 L
.70706 .29424 L
.70707 .23716 L
.70709 .30663 L
.7071 .2363 L
.7071 .2594 L
.70711 .19355 L
.70712 .27628 L
.70713 .2432 L
.70714 .24347 L
.70715 .2437 L
.70716 .2462 L
.70717 .2618 L
.70719 .28116 L
.7072 .28367 L
.70721 .27589 L
.70722 .27115 L
.70723 .28131 L
.70723 .23399 L
.70725 .24905 L
.70726 .24714 L
.70728 .3322 L
.70729 .26397 L
.70729 .27596 L
.70731 .28891 L
.70732 .26863 L
.70733 .24965 L
.70734 .28603 L
.70736 .2545 L
.70737 .31398 L
.70738 .2494 L
.70739 .28041 L
.7074 .24958 L
.70741 .21597 L
.70741 .27143 L
.70742 .29668 L
Mistroke
.70743 .24938 L
.70744 .26502 L
.70746 .26513 L
.70747 .20926 L
.70749 .26882 L
.7075 .25352 L
.70751 .22256 L
.70752 .29129 L
.70753 .25832 L
.70754 .26755 L
.70756 .23746 L
.70757 .2311 L
.70758 .25843 L
.70758 .28737 L
.70759 .29439 L
.70761 .24293 L
.70762 .2209 L
.70763 .26747 L
.70764 .27587 L
.70765 .28769 L
.70767 .27408 L
.70768 .22902 L
.7077 .25767 L
.70771 .28865 L
.70773 .27131 L
.70774 .27878 L
.70775 .232 L
.70777 .26969 L
.70778 .22815 L
.70779 .29339 L
.7078 .28491 L
.70781 .25434 L
.70782 .23517 L
.70783 .23987 L
.70783 .25417 L
.70785 .27389 L
.70786 .24775 L
.70786 .24063 L
.70788 .27653 L
.70789 .28219 L
.70791 .29229 L
.70792 .28462 L
.70794 .31251 L
.70795 .2618 L
.70796 .25035 L
.70798 .2915 L
.70799 .28051 L
.708 .27837 L
.70802 .27321 L
.70803 .26692 L
Mistroke
.70804 .25354 L
.70806 .28887 L
.70807 .26764 L
.70808 .25107 L
.7081 .26973 L
.70811 .28795 L
.70812 .21827 L
.70813 .24459 L
.70814 .26986 L
.70816 .28426 L
.70818 .29344 L
.70819 .28628 L
.7082 .24857 L
.70822 .28066 L
.70823 .24583 L
.70824 .25628 L
.70826 .27159 L
.70827 .26966 L
.70829 .25479 L
.7083 .28376 L
.70832 .31391 L
.70833 .24161 L
.70834 .27619 L
.70835 .23071 L
.70836 .2744 L
.70838 .22781 L
.70839 .26779 L
.70841 .22635 L
.70842 .23607 L
.70843 .30692 L
.70845 .27641 L
.70846 .27002 L
.70847 .24273 L
.70848 .24178 L
.7085 .23019 L
.70851 .24697 L
.70853 .27224 L
.70854 .23452 L
.70855 .25595 L
.70856 .27641 L
.70857 .26904 L
.70858 .24152 L
.7086 .26877 L
.70861 .24977 L
.70863 .24537 L
.70864 .30239 L
.70866 .25324 L
.70867 .24165 L
.70868 .26268 L
.7087 .21931 L
Mistroke
.70871 .29059 L
.70873 .29343 L
.70874 .28173 L
.70876 .22477 L
.70877 .26772 L
.70879 .23396 L
.7088 .23541 L
.7088 .22642 L
.70882 .27436 L
.70883 .22845 L
.70885 .26961 L
.70886 .26142 L
.70888 .26252 L
.70889 .25615 L
.7089 .23995 L
.70891 .26681 L
.70893 .23447 L
.70894 .27728 L
.70895 .30802 L
.70897 .26087 L
.70898 .22464 L
.70899 .25529 L
.70901 .30818 L
.70902 .3242 L
.70902 .29541 L
.70904 .28409 L
.70905 .32579 L
.70907 .25082 L
.70908 .2685 L
.70908 .27472 L
.7091 .25884 L
.70911 .28923 L
.70913 .221 L
.70914 .28096 L
.70915 .22924 L
.70917 .25075 L
.70918 .27135 L
.70918 .24087 L
.7092 .30649 L
.70921 .25998 L
.70922 .27615 L
.70923 .26141 L
.70925 .22829 L
.70926 .27777 L
.70928 .29594 L
.70929 .35622 L
.7093 .25874 L
.70932 .2446 L
.70933 .2684 L
.70934 .29879 L
Mistroke
.70936 .25636 L
.70937 .28363 L
.70939 .26334 L
.7094 .27369 L
.70942 .26074 L
.70943 .29429 L
.70944 .2972 L
.70945 .22433 L
.70947 .23936 L
.70948 .26781 L
.7095 .27701 L
.70951 .23192 L
.70952 .26107 L
.70954 .30709 L
.70955 .20692 L
.70956 .26403 L
.70956 .28063 L
.70957 .22303 L
.70959 .24074 L
.7096 .2531 L
.70962 .27974 L
.70963 .24143 L
.70965 .2321 L
.70966 .29408 L
.70967 .23449 L
.70969 .26703 L
.7097 .30814 L
.70972 .23861 L
.70973 .25222 L
.70974 .24432 L
.70976 .27857 L
.70977 .29632 L
.70979 .29525 L
.7098 .29296 L
.70982 .24534 L
.70983 .30917 L
.70983 .27761 L
.70985 .27262 L
.70986 .26667 L
.70987 .24711 L
.70987 .26107 L
.70988 .22986 L
.7099 .27855 L
.70991 .24292 L
.70991 .23789 L
.70992 .23649 L
.70993 .26223 L
.70994 .30837 L
.70995 .24021 L
.70996 .25262 L
Mistroke
.70996 .27705 L
.70998 .24346 L
.70999 .25581 L
.71001 .22943 L
.71002 .30826 L
.71004 .26533 L
.71005 .26487 L
.71007 .25735 L
.71008 .24405 L
.71009 .2239 L
.71011 .24488 L
.71012 .24112 L
.71014 .28317 L
.71015 .23403 L
.71017 .28314 L
.71018 .25735 L
.71019 .28777 L
.7102 .27746 L
.71021 .23548 L
.71023 .23126 L
.71024 .23837 L
.71026 .25018 L
.71027 .2369 L
.71028 .28268 L
.7103 .2867 L
.71031 .23066 L
.71033 .27335 L
.71034 .28441 L
.71035 .2744 L
.71037 .20573 L
.71038 .25717 L
.71039 .23299 L
.71041 .20629 L
.71042 .26772 L
.71044 .23407 L
.71045 .26147 L
.71046 .23758 L
.71048 .24309 L
.71049 .31487 L
.7105 .28559 L
.71052 .23669 L
.71053 .32673 L
.71054 .23679 L
.71055 .20467 L
.71057 .24313 L
.71058 .25331 L
.71059 .26471 L
.7106 .30218 L
.71062 .22194 L
.71063 .26548 L
Mistroke
.71065 .2583 L
.71066 .26337 L
.71067 .30408 L
.71069 .25338 L
.7107 .25256 L
.71071 .29226 L
.71072 .27155 L
.71073 .26581 L
.71074 .25824 L
.71075 .26253 L
.71077 .20333 L
.71078 .28894 L
.71078 .25529 L
.71079 .27394 L
.7108 .29337 L
.71082 .28962 L
.71083 .26869 L
.71083 .28179 L
.71085 .28257 L
.71086 .29788 L
.71088 .2789 L
.71089 .20899 L
.71091 .2504 L
.71092 .28333 L
.71094 .2336 L
.71094 .21526 L
.71095 .26733 L
.71097 .29498 L
.71098 .27214 L
.71098 .24987 L
.711 .27959 L
.71101 .21846 L
.71103 .25314 L
.71104 .27253 L
.71105 .2696 L
.71106 .30448 L
.71107 .2585 L
.71108 .26341 L
.71109 .25425 L
.71111 .25527 L
.71112 .24633 L
.71112 .249 L
.71114 .2986 L
.71115 .19743 L
.71116 .27705 L
.71117 .25808 L
.71118 .23067 L
.71118 .27442 L
.71119 .26556 L
.71121 .29089 L
Mistroke
.71122 .23937 L
.71124 .22126 L
.71125 .24975 L
.71126 .30132 L
.71127 .29108 L
.71128 .28609 L
.71129 .24365 L
.71129 .27838 L
.7113 .23906 L
.71132 .25002 L
.71133 .24912 L
.71134 .27812 L
.71136 .3177 L
.71137 .25838 L
.71138 .30894 L
.71139 .22202 L
.7114 .28152 L
.71142 .28619 L
.71143 .25085 L
.71144 .2417 L
.71145 .25162 L
.71146 .28454 L
.71148 .21582 L
.71149 .27983 L
.7115 .29471 L
.71152 .2833 L
.71153 .2407 L
.71155 .28388 L
.71156 .2784 L
.71156 .25408 L
.71158 .26109 L
.71159 .25947 L
.7116 .23754 L
.71161 .21666 L
.71163 .26254 L
.71164 .24202 L
.71165 .2451 L
.71167 .29019 L
.71168 .25551 L
.7117 .27624 L
.71171 .20605 L
.71172 .24671 L
.71173 .22645 L
.71175 .24592 L
.71176 .26247 L
.71177 .30817 L
.71179 .28466 L
.7118 .2462 L
.71182 .27846 L
.71183 .26884 L
Mistroke
.71185 .26363 L
.71186 .27458 L
.71188 .25988 L
.71188 .27419 L
.71189 .25172 L
.71191 .28757 L
.71192 .34812 L
.71193 .27403 L
.71194 .23178 L
.71195 .21645 L
.71197 .24178 L
.71198 .27976 L
.71198 .26003 L
.712 .26201 L
.71201 .25491 L
.71203 .32592 L
.71204 .25039 L
.71206 .29582 L
.71207 .23656 L
.71208 .3002 L
.7121 .26043 L
.71211 .2526 L
.71213 .26533 L
.71214 .21115 L
.71215 .2899 L
.71216 .28483 L
.71217 .25749 L
.71219 .29047 L
.7122 .24654 L
.71222 .29021 L
.71223 .26542 L
.71224 .29435 L
.71225 .2377 L
.71226 .245 L
.71227 .29329 L
.71228 .25996 L
.71229 .2897 L
.7123 .29625 L
.71231 .26524 L
.71232 .29934 L
.71232 .27302 L
.71233 .27982 L
.71235 .28481 L
.71236 .27654 L
.71238 .29666 L
.71239 .2455 L
.71239 .27875 L
.71241 .26791 L
.71242 .23934 L
.71244 .25672 L
Mistroke
.71245 .27283 L
.71246 .2766 L
.71248 .27006 L
.71249 .2307 L
.7125 .28318 L
.71251 .28309 L
.71252 .25367 L
.71253 .2616 L
.71254 .25892 L
.71255 .29777 L
.71257 .2911 L
.71259 .28221 L
.7126 .25377 L
.71261 .27445 L
.71262 .2356 L
.71264 .2633 L
.71265 .2278 L
.71266 .29328 L
.71268 .21892 L
.71269 .26768 L
.71271 .22599 L
.71272 .23965 L
.71273 .28501 L
.71275 .24527 L
.71276 .2383 L
.71278 .26485 L
.71279 .27502 L
.7128 .28187 L
.71282 .28573 L
.71283 .26095 L
.71285 .25667 L
.71286 .26339 L
.71287 .24759 L
.71288 .24851 L
.7129 .31697 L
.71291 .26073 L
.71292 .284 L
.71293 .22907 L
.71294 .24755 L
.71296 .31482 L
.71297 .2736 L
.71298 .29128 L
.713 .23779 L
.71301 .26598 L
.71303 .25905 L
.71304 .26821 L
.71305 .3173 L
.71307 .24313 L
.71308 .25985 L
.7131 .27743 L
Mistroke
.71311 .27173 L
.71313 .29116 L
.71314 .23378 L
.71314 .26694 L
.71316 .28207 L
.71317 .27542 L
.71318 .25288 L
.71318 .21945 L
.71319 .27899 L
.71321 .24718 L
.71322 .21482 L
.71322 .24196 L
.71323 .30132 L
.71324 .25429 L
.71325 .27876 L
.71326 .27104 L
.71327 .24199 L
.71328 .25411 L
.71329 .27707 L
.71331 .28297 L
.71332 .23675 L
.71334 .24915 L
.71335 .2715 L
.71336 .21131 L
.71338 .27273 L
.71339 .25325 L
.7134 .27604 L
.71342 .28868 L
.71343 .27564 L
.71345 .20893 L
.71346 .27792 L
.71348 .2903 L
.71349 .27427 L
.7135 .28683 L
.71351 .28212 L
.71353 .28722 L
.71354 .27765 L
.71355 .26446 L
.71357 .22943 L
.71358 .21458 L
.71359 .25345 L
.71361 .30214 L
.71362 .26753 L
.71363 .23436 L
.71365 .27108 L
.71366 .23674 L
.71367 .31002 L
.71369 .25077 L
.7137 .29351 L
.71371 .27358 L
Mistroke
.71372 .26436 L
.71373 .22196 L
.71374 .26112 L
.71376 .26485 L
.71377 .25881 L
.71379 .25196 L
.71381 .26873 L
.71382 .29722 L
.71383 .23528 L
.71385 .25349 L
.71386 .23574 L
.71387 .2464 L
.71389 .28036 L
.7139 .21815 L
.71392 .2647 L
.71393 .23873 L
.71395 .28373 L
.71396 .27636 L
.71396 .31133 L
.71398 .24808 L
.714 .2506 L
.71401 .24628 L
.71402 .21589 L
.71404 .23632 L
.71405 .29497 L
.71406 .24734 L
.71407 .25036 L
.71409 .24082 L
.7141 .30051 L
.71411 .28348 L
.71413 .22474 L
.71414 .25018 L
.71416 .29863 L
.71417 .26646 L
.71418 .23914 L
.71419 .28365 L
.7142 .28511 L
.71422 .21866 L
.71423 .29861 L
.71424 .27285 L
.71425 .2676 L
.71426 .28881 L
.71427 .29683 L
.71429 .28798 L
.7143 .26984 L
.71431 .25698 L
.71433 .26898 L
.71434 .2719 L
.71435 .22483 L
.71436 .28652 L
Mistroke
.71438 .25733 L
.71438 .2797 L
.71439 .29219 L
.71441 .26594 L
.71442 .28687 L
.71444 .26856 L
.71445 .26455 L
.71446 .26625 L
.71448 .26961 L
.71449 .27669 L
.7145 .2248 L
.71452 .26229 L
.71453 .27681 L
.71454 .28027 L
.71456 .27609 L
.71457 .26576 L
.71459 .2838 L
.7146 .27169 L
.71461 .28256 L
.71463 .24922 L
.71464 .21481 L
.71466 .24714 L
.71467 .26571 L
.71469 .25962 L
.7147 .25406 L
.71471 .2822 L
.71472 .29667 L
.71473 .27756 L
.71473 .29799 L
.71475 .28073 L
.71476 .24534 L
.71478 .29131 L
.71479 .23569 L
.71481 .27823 L
.71482 .26964 L
.71484 .23415 L
.71485 .29079 L
.71486 .27859 L
.71488 .2191 L
.71489 .23445 L
.71491 .25807 L
.71492 .25029 L
.71494 .28141 L
.71495 .31021 L
.71496 .25982 L
.71498 .27694 L
.71499 .22952 L
.715 .26031 L
.71501 .28967 L
.71502 .24145 L
Mistroke
.71503 .26619 L
.71504 .28729 L
.71504 .22307 L
.71506 .29931 L
.71507 .25132 L
.71508 .30388 L
.71509 .25214 L
.71509 .21925 L
.7151 .22275 L
.71511 .2987 L
.71512 .24987 L
.71513 .24807 L
.71514 .29881 L
.71516 .24857 L
.71517 .26252 L
.71519 .29941 L
.7152 .25874 L
.71522 .26137 L
.71523 .22844 L
.71524 .24836 L
.71526 .32213 L
.71527 .28772 L
.71529 .27798 L
.7153 .27699 L
.71532 .28105 L
.71532 .29151 L
.71533 .30039 L
.71535 .2654 L
.71536 .2811 L
.71538 .264 L
.71539 .25927 L
.71541 .26881 L
.71542 .23726 L
.71543 .25255 L
.71545 .24437 L
.71546 .25433 L
.71547 .25977 L
.71548 .24225 L
.7155 .31545 L
.71551 .27681 L
.71553 .27048 L
.71554 .264 L
.71555 .24153 L
.71557 .25733 L
.71558 .25351 L
.71558 .24779 L
.7156 .27039 L
.71561 .24728 L
.71563 .28632 L
.71564 .2379 L
Mistroke
.71566 .25208 L
.71567 .21708 L
.71568 .30254 L
.7157 .27252 L
.71571 .29305 L
.71573 .23521 L
.71574 .25289 L
.71576 .30442 L
.71577 .26987 L
.71578 .23238 L
.7158 .28555 L
.71581 .29127 L
.71582 .26796 L
.71583 .30429 L
.71585 .22014 L
.71586 .27958 L
.71587 .29444 L
.71589 .28391 L
.7159 .33277 L
.71592 .27969 L
.71593 .26279 L
.71594 .3209 L
.71595 .27308 L
.71597 .25453 L
.71598 .27797 L
.71599 .2693 L
.71601 .25202 L
.71602 .24439 L
.71603 .25597 L
.71604 .27304 L
.71605 .23615 L
.71607 .27018 L
.71608 .26249 L
.71609 .26544 L
.7161 .27604 L
.71611 .26471 L
.71613 .25352 L
.71614 .30894 L
.71615 .29539 L
.71618 .27089 L
.7162 .29265 L
.71621 .24527 L
.71622 .29886 L
.71624 .27561 L
.71626 .27808 L
.71626 .27203 L
.71627 .26713 L
.71629 .26376 L
.7163 .25862 L
.71632 .29397 L
Mistroke
.71633 .26419 L
.71634 .24001 L
.71636 .24976 L
.71637 .32206 L
.71638 .25932 L
.7164 .21635 L
.71641 .28125 L
.71642 .28503 L
.71644 .2871 L
.71645 .26625 L
.71646 .24839 L
.71648 .27497 L
.71649 .25475 L
.71651 .283 L
.71652 .26556 L
.71654 .2632 L
.71655 .27917 L
.71657 .22473 L
.71658 .26216 L
.71659 .24451 L
.7166 .24963 L
.71661 .26355 L
.71663 .23062 L
.71664 .25655 L
.71665 .27224 L
.71667 .2827 L
.71668 .26179 L
.71669 .31539 L
.71671 .24165 L
.71672 .25679 L
.71674 .23327 L
.71675 .23614 L
.71676 .29275 L
.71677 .26741 L
.71678 .28894 L
.7168 .29104 L
.71681 .31099 L
.71683 .27772 L
.71684 .29523 L
.71684 .28238 L
.71685 .28165 L
.71686 .26734 L
.71687 .26249 L
.71688 .21825 L
.71689 .28609 L
.71691 .25922 L
.71692 .26045 L
.71694 .27998 L
.71695 .27012 L
.71696 .33627 L
Mistroke
.71697 .26172 L
.71698 .27499 L
.717 .30078 L
.71701 .30742 L
.71703 .23657 L
.71704 .27984 L
.71706 .29856 L
.71707 .26255 L
.71708 .28644 L
.71709 .27207 L
.71711 .26831 L
.71712 .24669 L
.71714 .25457 L
.71715 .27674 L
.71717 .28917 L
.71718 .2902 L
.71719 .23769 L
.7172 .29739 L
.71721 .26802 L
.71723 .24986 L
.71724 .2544 L
.71726 .286 L
.71727 .25843 L
.71727 .23515 L
.71729 .26931 L
.7173 .25564 L
.71732 .2649 L
.71733 .27901 L
.71735 .26694 L
.71736 .26353 L
.71737 .30664 L
.71738 .23941 L
.71739 .29188 L
.7174 .2681 L
.71741 .22499 L
.71741 .2268 L
.71742 .23801 L
.71743 .29011 L
.71745 .23591 L
.71745 .26202 L
.71746 .29071 L
.71748 .24027 L
.71749 .27392 L
.71751 .21635 L
.71752 .23992 L
.71754 .27119 L
.71755 .24089 L
.71756 .25396 L
.71758 .2777 L
.71759 .2634 L
Mistroke
.71761 .24858 L
.71762 .25901 L
.71764 .29185 L
.71765 .2304 L
.71767 .29212 L
.71767 .27317 L
.71768 .3016 L
.7177 .25546 L
.71771 .28066 L
.71773 .25056 L
.71774 .28283 L
.71775 .31543 L
.71777 .27413 L
.71778 .31396 L
.71779 .29337 L
.71781 .28154 L
.71782 .2905 L
.71783 .29751 L
.71785 .30096 L
.71786 .28975 L
.71787 .3024 L
.71789 .29795 L
.7179 .27881 L
.7179 .29059 L
.71792 .28755 L
.71793 .24689 L
.71795 .26772 L
.71796 .22836 L
.71796 .23033 L
.71798 .24922 L
.71799 .26227 L
.71801 .28321 L
.71802 .25645 L
.71803 .26115 L
.71805 .26255 L
.71805 .25456 L
.71806 .26427 L
.71808 .262 L
.71809 .27312 L
.7181 .2679 L
.71811 .27035 L
.71812 .29448 L
.71814 .29814 L
.71816 .26643 L
.71817 .26683 L
.71818 .26915 L
.7182 .28975 L
.71821 .29267 L
.71822 .24536 L
.71823 .25222 L
Mistroke
.71825 .24639 L
.71826 .27164 L
.71828 .26028 L
.71829 .2216 L
.7183 .29707 L
.71832 .22684 L
.71833 .24467 L
.71835 .31653 L
.71836 .28196 L
.71837 .26588 L
.71839 .25481 L
.7184 .28727 L
.71842 .29306 L
.71843 .2879 L
.71844 .2391 L
.71844 .2807 L
.71845 .28904 L
.71847 .28465 L
.71848 .25334 L
.7185 .27351 L
.71851 .2355 L
.71853 .24383 L
.71854 .26287 L
.71855 .26782 L
.71857 .32489 L
.71858 .24165 L
.7186 .25326 L
.71861 .27288 L
.71862 .26146 L
.71864 .27988 L
.71865 .29071 L
.71867 .26465 L
.71868 .22646 L
.7187 .29607 L
.71871 .30004 L
.71871 .24749 L
.71873 .28685 L
.71874 .26734 L
.71875 .25395 L
.71875 .29181 L
.71876 .25175 L
.71878 .32 L
.71879 .27218 L
.71879 .28649 L
.7188 .30334 L
.71881 .26392 L
.71882 .23552 L
.71883 .21645 L
.71884 .21918 L
.71884 .2905 L
Mistroke
.71886 .27201 L
.71887 .24133 L
.71889 .30397 L
.7189 .22508 L
.71892 .27683 L
.71893 .33184 L
.71895 .28171 L
.71896 .26141 L
.71897 .29249 L
.71899 .27075 L
.719 .28736 L
.71902 .23463 L
.71903 .28388 L
.71905 .29872 L
.71906 .29365 L
.71907 .23093 L
.71908 .25362 L
.71909 .26023 L
.71911 .28373 L
.71912 .22082 L
.71914 .23589 L
.71915 .28093 L
.71916 .29028 L
.71918 .24459 L
.71919 .24719 L
.7192 .28615 L
.71921 .24462 L
.71923 .25812 L
.71924 .23905 L
.71926 .29907 L
.71927 .24343 L
.71928 .28572 L
.71929 .2545 L
.7193 .26579 L
.71931 .28747 L
.71933 .26148 L
.71934 .26184 L
.71936 .29738 L
.71937 .25111 L
.71939 .27695 L
.7194 .25893 L
.71941 .29587 L
.71943 .26399 L
.71944 .27115 L
.71946 .2781 L
.71947 .26228 L
.71949 .27046 L
.7195 .28233 L
.71952 .25466 L
.71953 .26581 L
Mistroke
.71953 .26432 L
.71955 .25473 L
.71956 .25765 L
.71958 .25793 L
.71959 .21083 L
.71961 .29776 L
.71962 .26144 L
.71963 .24585 L
.71965 .26773 L
.71966 .26538 L
.71968 .28225 L
.71969 .22918 L
.7197 .26943 L
.71972 .23028 L
.71973 .29773 L
.71974 .2127 L
.71976 .27349 L
.71977 .23446 L
.71978 .23746 L
.7198 .25243 L
.71981 .21844 L
.71983 .25102 L
.71984 .24324 L
.71986 .28139 L
.71986 .26453 L
.71987 .27566 L
.71989 .31067 L
.7199 .22495 L
.71991 .25946 L
.71993 .30397 L
.71994 .26829 L
.71995 .24096 L
.71997 .2761 L
.71998 .25784 L
.72 .29084 L
.72001 .24931 L
.72003 .26582 L
.72003 .27022 L
.72004 .27894 L
.72006 .26335 L
.72007 .25556 L
.72008 .27495 L
.72009 .30493 L
.7201 .26329 L
.72011 .29717 L
.72012 .26655 L
.72013 .22981 L
.72014 .29438 L
.72015 .28942 L
.72016 .26381 L
Mistroke
.72017 .23185 L
.72018 .26647 L
.7202 .28446 L
.72021 .26788 L
.72023 .23857 L
.72024 .26848 L
.72026 .29249 L
.72027 .2705 L
.72028 .28171 L
.72029 .30785 L
.7203 .2709 L
.72031 .2576 L
.72032 .25978 L
.72033 .27846 L
.72035 .27556 L
.72037 .23138 L
.72038 .28417 L
.72039 .24601 L
.7204 .23868 L
.72041 .26205 L
.72041 .26982 L
.72043 .2914 L
.72044 .22837 L
.72045 .26527 L
.72046 .24226 L
.72048 .26725 L
.72049 .23347 L
.7205 .26671 L
.7205 .26414 L
.72051 .24829 L
.72052 .2631 L
.72053 .29678 L
.72054 .29478 L
.72056 .27317 L
.72057 .29005 L
.72058 .29618 L
.72059 .27935 L
.7206 .27351 L
.72061 .2678 L
.72062 .32753 L
.72062 .24426 L
.72064 .24988 L
.72065 .2596 L
.72066 .27979 L
.72067 .25349 L
.72068 .23247 L
.7207 .23467 L
.72071 .29161 L
.72073 .31153 L
.72074 .29514 L
Mistroke
.72075 .22956 L
.72077 .28822 L
.72078 .31163 L
.72079 .25986 L
.7208 .24615 L
.72081 .2549 L
.72083 .26874 L
.72084 .28068 L
.72085 .27496 L
.72087 .26713 L
.72089 .26282 L
.72089 .27282 L
.7209 .27552 L
.72092 .29637 L
.72093 .28603 L
.72093 .27661 L
.72095 .22917 L
.72096 .30026 L
.72098 .2955 L
.72099 .29908 L
.72101 .29378 L
.72102 .28611 L
.72103 .23568 L
.72104 .22619 L
.72106 .26341 L
.72107 .24646 L
.72109 .24342 L
.7211 .29114 L
.72111 .29369 L
.72113 .23886 L
.72114 .26492 L
.72115 .26526 L
.72117 .2682 L
.72119 .28211 L
.7212 .25515 L
.72121 .26009 L
.72122 .2623 L
.72123 .28459 L
.72124 .27533 L
.72126 .26865 L
.72127 .2831 L
.72128 .30548 L
.72129 .2661 L
.72131 .25372 L
.72131 .26637 L
.72132 .30377 L
.72134 .28184 L
.72135 .27673 L
.72137 .29467 L
.72138 .26328 L
Mistroke
.7214 .24835 L
.72141 .26292 L
.72142 .30845 L
.72144 .24437 L
.72145 .28731 L
.72147 .24739 L
.72148 .30429 L
.72149 .29894 L
.7215 .28927 L
.72151 .30133 L
.72153 .28901 L
.72154 .2881 L
.72156 .31679 L
.72157 .27761 L
.72158 .26992 L
.72159 .30712 L
.7216 .2364 L
.72161 .30219 L
.72162 .27695 L
.72163 .28845 L
.72164 .23932 L
.72165 .27824 L
.72167 .27997 L
.72168 .28897 L
.72168 .29306 L
.72169 .23338 L
.7217 .22325 L
.72172 .25853 L
.72172 .26591 L
.72173 .27834 L
.72175 .23786 L
.72176 .28591 L
.72177 .24768 L
.72179 .29781 L
.7218 .25353 L
.72182 .27313 L
.72183 .23749 L
.72184 .3142 L
.72185 .29558 L
.72186 .28423 L
.72187 .31234 L
.72188 .29574 L
.72189 .25378 L
.72191 .27392 L
.72192 .27275 L
.72194 .27761 L
.72195 .24913 L
.72196 .29023 L
.72198 .2767 L
.72199 .25531 L
Mistroke
.722 .31221 L
.72202 .31501 L
.72203 .29271 L
.72205 .28276 L
.72206 .26735 L
.72207 .25599 L
.72209 .25032 L
.7221 .27494 L
.72211 .24099 L
.72213 .313 L
.72214 .30897 L
.72216 .3196 L
.72217 .25707 L
.72219 .29697 L
.7222 .30769 L
.7222 .27447 L
.72221 .24339 L
.72222 .30888 L
.72224 .25458 L
.72225 .28294 L
.72226 .30044 L
.72227 .25102 L
.72228 .26006 L
.7223 .26509 L
.72231 .26663 L
.72233 .31354 L
.72234 .23634 L
.72235 .25876 L
.72237 .25165 L
.72238 .27452 L
.72239 .28621 L
.72241 .21343 L
.72242 .26599 L
.72243 .2454 L
.72244 .25537 L
.72246 .21759 L
.72247 .22751 L
.72249 .27962 L
.7225 .32406 L
.72251 .25579 L
.72252 .24497 L
.72253 .26218 L
.72255 .28223 L
.72256 .26453 L
.72256 .29551 L
.72257 .29485 L
.72258 .28192 L
.72259 .25104 L
.7226 .26495 L
.72261 .28205 L
Mistroke
.72262 .23327 L
.72263 .26471 L
.72265 .28152 L
.72266 .29192 L
.72267 .31199 L
.72268 .29125 L
.72269 .26913 L
.72271 .23023 L
.72272 .26665 L
.72273 .26308 L
.72274 .26953 L
.72276 .28587 L
.72277 .24113 L
.72278 .25271 L
.72279 .2233 L
.72281 .30586 L
.72281 .24184 L
.72282 .26336 L
.72284 .23711 L
.72285 .24148 L
.72287 .23741 L
.72288 .23482 L
.72289 .30414 L
.72291 .23958 L
.72292 .23036 L
.72293 .27187 L
.72295 .24493 L
.72296 .27788 L
.72297 .3024 L
.72299 .24754 L
.723 .23309 L
.72302 .22698 L
.72303 .31086 L
.72304 .28701 L
.72306 .24579 L
.72307 .26401 L
.72309 .2671 L
.7231 .28397 L
.72312 .28454 L
.72313 .26714 L
.72314 .27608 L
.72315 .24175 L
.72316 .28316 L
.72316 .28176 L
.72318 .25908 L
.72319 .25861 L
.72321 .26023 L
.72322 .2414 L
.72324 .26009 L
.72325 .27723 L
Mistroke
.72327 .25121 L
.72328 .25136 L
.72329 .29385 L
.72331 .24176 L
.72332 .25318 L
.72334 .26908 L
.72335 .26702 L
.72337 .25866 L
.72338 .26655 L
.72339 .25325 L
.72341 .27628 L
.72342 .30389 L
.72343 .2334 L
.72344 .27822 L
.72345 .27201 L
.72346 .25316 L
.72347 .23604 L
.72347 .25947 L
.72349 .26646 L
.7235 .28604 L
.72351 .2945 L
.72352 .26394 L
.72352 .2553 L
.72353 .33089 L
.72354 .26523 L
.72355 .29596 L
.72356 .27175 L
.72357 .26423 L
.72359 .25828 L
.7236 .28412 L
.72362 .33168 L
.72363 .25693 L
.72365 .25477 L
.72366 .23196 L
.72367 .28314 L
.72369 .27422 L
.7237 .28967 L
.72371 .25045 L
.72373 .29525 L
.72374 .27246 L
.72376 .29682 L
.72377 .25525 L
.72378 .26905 L
.72379 .19928 L
.7238 .22608 L
.72381 .30547 L
.72382 .26122 L
.72383 .25505 L
.72385 .29213 L
.72386 .28056 L
Mistroke
.72388 .26686 L
.72389 .26249 L
.72391 .28497 L
.72392 .31136 L
.72394 .2806 L
.72395 .2355 L
.72396 .3199 L
.72398 .21925 L
.72399 .26027 L
.724 .24212 L
.72401 .30118 L
.72403 .29496 L
.72404 .30019 L
.72406 .28275 L
.72407 .23021 L
.72409 .24588 L
.7241 .27268 L
.72411 .262 L
.72413 .23681 L
.72414 .24831 L
.72415 .26301 L
.72417 .24549 L
.72418 .24056 L
.7242 .28544 L
.72421 .24635 L
.72423 .26503 L
.72424 .26481 L
.72425 .23286 L
.72426 .26329 L
.72428 .26031 L
.72429 .25243 L
.7243 .26873 L
.72432 .26665 L
.72433 .26382 L
.72434 .31061 L
.72436 .27061 L
.72437 .31422 L
.72438 .28121 L
.7244 .33454 L
.72441 .30222 L
.72442 .27145 L
.72444 .29308 L
.72445 .2941 L
.72446 .26993 L
.72447 .28579 L
.72448 .32081 L
.7245 .26294 L
.72451 .31131 L
.72452 .30511 L
.72453 .2671 L
Mistroke
.72454 .24418 L
.72456 .30708 L
.72457 .31546 L
.72458 .27216 L
.72459 .25123 L
.72461 .28771 L
.72462 .28248 L
.72463 .24834 L
.72464 .28962 L
.72466 .2687 L
.72467 .2533 L
.72467 .27825 L
.72469 .24709 L
.7247 .27621 L
.72472 .24987 L
.72473 .29573 L
.72474 .27339 L
.72476 .27238 L
.72477 .26603 L
.72478 .22432 L
.7248 .321 L
.72481 .22242 L
.72483 .27763 L
.72484 .23129 L
.72485 .25568 L
.72487 .32201 L
.72488 .26994 L
.72489 .26652 L
.72491 .22032 L
.72492 .25194 L
.72494 .29011 L
.72495 .24649 L
.72497 .3011 L
.72498 .25658 L
.72499 .24516 L
.72501 .28935 L
.72502 .26786 L
.72504 .25393 L
.72505 .2304 L
.72507 .31226 L
.72508 .28383 L
.72509 .25647 L
.7251 .25163 L
.72511 .30304 L
.72511 .24875 L
.72512 .23987 L
.72513 .28307 L
.72515 .28194 L
.72516 .25061 L
.72518 .28869 L
Mistroke
.72518 .23353 L
.72519 .23109 L
.7252 .29483 L
.72521 .30691 L
.72522 .31058 L
.72522 .22322 L
.72524 .23873 L
.72525 .27493 L
.72526 .26515 L
.72527 .28517 L
.72528 .29074 L
.72529 .30993 L
.72531 .30577 L
.72531 .29211 L
.72532 .28501 L
.72533 .25886 L
.72534 .30813 L
.72535 .27555 L
.72537 .29835 L
.72538 .29639 L
.72539 .25248 L
.7254 .25649 L
.72541 .24189 L
.72543 .22103 L
.72544 .32097 L
.72546 .25642 L
.72547 .24885 L
.72547 .32656 L
.72549 .27999 L
.7255 .26498 L
.72551 .26511 L
.72552 .29053 L
.72553 .25105 L
.72554 .26174 L
.72555 .33318 L
.72556 .29646 L
.72557 .26226 L
.72558 .31133 L
.72559 .26773 L
.7256 .27492 L
.72561 .27504 L
.72563 .26674 L
.72564 .28035 L
.72566 .25564 L
.72567 .28157 L
.72569 .26887 L
.7257 .30242 L
.72571 .28327 L
.72573 .26974 L
.72574 .27032 L
Mistroke
.72575 .23691 L
.72576 .24566 L
.72577 .21966 L
.72579 .2496 L
.7258 .29043 L
.72582 .23892 L
.72583 .26845 L
.72584 .25192 L
.72585 .25217 L
.72587 .26259 L
.72588 .28562 L
.7259 .30304 L
.72591 .27931 L
.72592 .25153 L
.72593 .25418 L
.72594 .31061 L
.72596 .25152 L
.72596 .24275 L
.72597 .33747 L
.72599 .25432 L
.726 .26158 L
.72601 .24668 L
.72602 .29548 L
.72603 .27436 L
.72605 .2461 L
.72606 .25118 L
.72608 .29356 L
.72609 .35329 L
.7261 .27917 L
.72612 .29854 L
.72613 .26036 L
.72615 .28459 L
.72616 .24004 L
.72618 .28398 L
.72618 .26202 L
.72619 .30734 L
.72621 .2615 L
.72622 .32866 L
.72624 .25956 L
.72625 .25999 L
.72627 .30323 L
.72628 .28629 L
.72628 .23303 L
.7263 .26355 L
.72631 .26061 L
.72632 .2792 L
.72633 .25086 L
.72633 .31247 L
.72635 .27583 L
.72636 .27009 L
Mistroke
.72636 .28342 L
.72637 .30839 L
.72638 .29869 L
.7264 .27138 L
.72641 .26487 L
.72642 .27857 L
.72643 .23383 L
.72644 .26357 L
.72646 .27129 L
.72647 .28213 L
.72648 .23016 L
.7265 .29505 L
.72651 .25797 L
.72653 .27434 L
.72654 .31302 L
.72654 .23568 L
.72656 .28848 L
.72657 .23601 L
.72658 .29901 L
.72659 .29516 L
.72661 .29108 L
.72662 .28815 L
.72663 .25354 L
.72665 .30412 L
.72666 .3054 L
.72667 .30421 L
.72669 .30946 L
.7267 .28375 L
.72671 .23609 L
.72673 .27203 L
.72674 .26621 L
.72676 .26814 L
.72677 .26293 L
.72678 .24728 L
.7268 .31726 L
.72681 .26626 L
.72683 .24462 L
.72684 .2356 L
.72685 .32347 L
.72687 .2397 L
.72689 .23431 L
.72689 .29534 L
.7269 .26172 L
.72691 .28519 L
.72692 .27951 L
.72693 .25764 L
.72693 .24533 L
.72695 .2703 L
.72696 .24546 L
.72698 .2458 L
Mistroke
.72699 .28028 L
.727 .30937 L
.72702 .30546 L
.72703 .25997 L
.72705 .311 L
.72706 .34907 L
.72707 .29404 L
.72709 .32111 L
.72711 .29952 L
.72712 .26628 L
.72713 .24208 L
.72714 .29784 L
.72715 .32828 L
.72717 .26472 L
.72718 .2594 L
.7272 .33205 L
.72721 .26246 L
.72722 .29724 L
.72723 .24887 L
.72724 .30051 L
.72725 .26479 L
.72726 .29915 L
.72727 .33065 L
.72728 .30398 L
.72729 .28347 L
.7273 .28731 L
.7273 .26738 L
.72731 .28454 L
.72733 .25808 L
.72734 .26377 L
.72736 .27477 L
.72736 .30011 L
.72737 .30067 L
.72739 .29133 L
.7274 .24807 L
.72741 .23009 L
.72743 .29406 L
.72744 .25387 L
.72746 .28801 L
.72747 .31613 L
.72748 .25873 L
.72749 .23433 L
.7275 .31799 L
.72751 .26295 L
.72752 .3171 L
.72753 .30843 L
.72755 .29093 L
.72756 .27053 L
.72758 .29073 L
.72759 .2706 L
Mistroke
.7276 .2566 L
.72762 .30278 L
.72763 .27856 L
.72764 .28128 L
.72766 .30245 L
.72767 .29582 L
.72768 .25383 L
.7277 .28566 L
.72771 .29089 L
.72773 .27288 L
.72774 .29553 L
.72775 .28902 L
.72777 .29404 L
.72778 .3222 L
.7278 .26068 L
.72781 .31909 L
.72783 .29455 L
.72784 .23728 L
.72784 .28251 L
.72785 .2596 L
.72786 .2759 L
.72788 .25389 L
.72789 .298 L
.7279 .26212 L
.72792 .25768 L
.72793 .24301 L
.72795 .30065 L
.72796 .3023 L
.72797 .24699 L
.72799 .26538 L
.728 .30026 L
.72802 .29068 L
.72803 .21057 L
.72805 .31537 L
.72806 .30812 L
.72808 .27059 L
.72809 .25869 L
.72811 .29327 L
.72811 .25142 L
.72812 .29935 L
.72814 .23728 L
.72815 .29002 L
.72815 .31041 L
.72816 .29097 L
.72817 .28335 L
.72819 .2927 L
.72819 .28375 L
.7282 .25194 L
.72821 .30529 L
.72822 .26542 L
Mistroke
.72823 .28669 L
.72824 .28249 L
.72825 .31939 L
.72825 .29625 L
.72827 .28044 L
.72828 .28031 L
.72874 .27528 L
.72875 .29407 L
.72877 .27058 L
.72878 .30073 L
.72878 .2753 L
.7288 .29072 L
.72881 .24714 L
.72882 .27247 L
.72883 .28869 L
.72883 .26227 L
.72884 .31732 L
.72885 .26977 L
.72887 .26912 L
.72888 .27574 L
.72889 .28813 L
.7289 .28605 L
.72891 .29168 L
.72892 .25063 L
.72893 .2388 L
.72895 .25043 L
.72896 .29732 L
.72898 .27436 L
.72899 .28468 L
.729 .29935 L
.72902 .34441 L
.72903 .30045 L
.72904 .2536 L
.72906 .28407 L
.72907 .29056 L
.72909 .27978 L
.7291 .27273 L
.72912 .29359 L
.72913 .29881 L
.72914 .29094 L
.72916 .27446 L
.72917 .30319 L
.72918 .31753 L
.72919 .27037 L
.72921 .28512 L
.72922 .27063 L
.72924 .26945 L
.72925 .23239 L
.72926 .29629 L
.72927 .27517 L
Mistroke
.72928 .27922 L
.7293 .25191 L
.72931 .26698 L
.72933 .30857 L
.72934 .25021 L
.72935 .325 L
.72937 .24256 L
.72938 .2737 L
.72939 .23783 L
.72941 .24613 L
.72942 .30236 L
.72943 .26913 L
.72945 .24088 L
.72946 .30378 L
.72948 .27004 L
.72949 .30976 L
.7295 .27882 L
.72951 .26257 L
.72952 .28102 L
.72953 .24465 L
.72954 .25463 L
.72956 .27819 L
.72956 .27938 L
.72957 .24154 L
.72959 .29092 L
.7296 .27054 L
.72962 .27172 L
.72963 .32932 L
.72964 .28896 L
.72966 .29075 L
.72967 .25126 L
.72969 .27792 L
.7297 .26366 L
.72971 .26135 L
.72973 .28297 L
.72974 .24628 L
.72976 .29524 L
.72977 .31441 L
.72979 .29502 L
.7298 .26728 L
.72981 .30514 L
.72983 .32767 L
.72984 .29045 L
.72986 .30297 L
.72987 .23355 L
.72988 .25814 L
.72989 .26555 L
.7299 .26534 L
.72992 .30817 L
.72993 .26993 L
Mistroke
.72995 .26728 L
.72996 .2677 L
.72997 .32159 L
.72999 .25922 L
.73 .31018 L
.73001 .32928 L
.73002 .29194 L
.73004 .26789 L
.73005 .26471 L
.73007 .26693 L
.73008 .2557 L
.73009 .27357 L
.7301 .34192 L
.73011 .26348 L
.73012 .2255 L
.73014 .22993 L
.73015 .24673 L
.73017 .30107 L
.73018 .29551 L
.7302 .28017 L
.73021 .27636 L
.73022 .25513 L
.73024 .31021 L
.73025 .24887 L
.73027 .28192 L
.73028 .28527 L
.7303 .276 L
.73031 .25517 L
.73033 .27592 L
.73033 .29967 L
.73034 .31122 L
.73036 .25542 L
.73037 .27813 L
.73039 .27668 L
.7304 .25042 L
.73041 .26625 L
.73043 .26089 L
.73044 .26642 L
.73045 .28809 L
.73046 .31828 L
.73048 .31695 L
.73049 .28287 L
.73051 .27698 L
.73052 .28439 L
.73053 .2729 L
.73055 .27845 L
.73056 .28212 L
.73056 .30548 L
.73058 .28164 L
.73059 .24886 L
Mistroke
.73061 .22571 L
.73062 .29688 L
.73064 .25014 L
.73065 .28901 L
.73067 .23174 L
.73068 .24885 L
.73069 .24305 L
.73071 .25761 L
.73072 .29538 L
.73074 .32085 L
.73075 .30616 L
.73076 .25579 L
.73078 .29562 L
.73079 .2918 L
.7308 .27083 L
.73081 .30292 L
.73083 .2753 L
.73084 .26844 L
.73085 .32615 L
.73087 .29951 L
.73088 .26408 L
.73089 .33519 L
.73091 .26189 L
.73092 .30023 L
.73093 .26141 L
.73095 .2885 L
.73096 .25922 L
.73097 .32372 L
.73099 .26934 L
.731 .2757 L
.73101 .29341 L
.73102 .23311 L
.73103 .31364 L
.73105 .30665 L
.73107 .28791 L
.73109 .27788 L
.7311 .26654 L
.73112 .2475 L
.73113 .26466 L
.73115 .2542 L
.73116 .24439 L
.73117 .29571 L
.73118 .25466 L
.73119 .27888 L
.73121 .27467 L
.73122 .24992 L
.73122 .26996 L
.73124 .274 L
.73125 .27296 L
.73127 .27189 L
Mistroke
.73128 .29747 L
.73129 .26722 L
.73131 .26553 L
.73132 .27117 L
.73134 .24187 L
.73135 .27911 L
.73136 .26531 L
.73137 .25482 L
.73139 .26385 L
.7314 .22215 L
.73141 .25599 L
.73143 .29327 L
.73144 .31348 L
.73146 .27148 L
.73146 .25727 L
.73147 .29613 L
.73149 .2509 L
.7315 .26587 L
.73152 .24869 L
.73153 .29304 L
.73155 .30378 L
.73156 .27007 L
.73157 .28301 L
.73159 .28192 L
.7316 .26861 L
.73161 .32471 L
.73163 .24945 L
.73165 .24892 L
.73166 .2866 L
.73167 .2694 L
.73169 .25231 L
.7317 .24639 L
.73171 .25285 L
.73172 .25652 L
.73174 .27841 L
.73175 .25451 L
.73176 .24027 L
.73178 .24669 L
.73179 .28556 L
.73181 .26945 L
.73182 .28699 L
.73183 .3031 L
.73185 .27887 L
.73186 .25804 L
.73188 .28947 L
.73189 .26121 L
.7319 .26697 L
.73191 .2729 L
.73193 .30234 L
.73194 .28998 L
Mistroke
.73196 .30473 L
.73197 .24074 L
.73198 .26555 L
.732 .2745 L
.73201 .32679 L
.73201 .24814 L
.73203 .26135 L
.73204 .2612 L
.73205 .27225 L
.73206 .25163 L
.73208 .31676 L
.73209 .24216 L
.7321 .28446 L
.73212 .26537 L
.73213 .29821 L
.73215 .26825 L
.73216 .29845 L
.73217 .23931 L
.73219 .26907 L
.7322 .23312 L
.73222 .29588 L
.73223 .28657 L
.73223 .29466 L
.73225 .2636 L
.73227 .24982 L
.73228 .28413 L
.73229 .25555 L
.73231 .25587 L
.73232 .31086 L
.73232 .28889 L
.73234 .24322 L
.73235 .30931 L
.73236 .29726 L
.73237 .31524 L
.73237 .24456 L
.73239 .28486 L
.7324 .25949 L
.73242 .29595 L
.73243 .29328 L
.73244 .32348 L
.73245 .26527 L
.73246 .31193 L
.73247 .27157 L
.73248 .29052 L
.73249 .27893 L
.7325 .29536 L
.73252 .25841 L
.73253 .2843 L
.73254 .29118 L
.73256 .29414 L
Mistroke
.73257 .26947 L
.73258 .27232 L
.73259 .30388 L
.7326 .29261 L
.7326 .28895 L
.73261 .29352 L
.73262 .29578 L
.73263 .30792 L
.73264 .22829 L
.73265 .26009 L
.73266 .2787 L
.73267 .30364 L
.73268 .31037 L
.73269 .24789 L
.73271 .27677 L
.73272 .23845 L
.73274 .25089 L
.73275 .29979 L
.73277 .25167 L
.73278 .26958 L
.73279 .26204 L
.73281 .3015 L
.73282 .29268 L
.73282 .30395 L
.73284 .27206 L
.73285 .25758 L
.73287 .26824 L
.73288 .27174 L
.73289 .29244 L
.7329 .29643 L
.73291 .24525 L
.73292 .24802 L
.73293 .26968 L
.73293 .21803 L
.73294 .27921 L
.73295 .31363 L
.73297 .29403 L
.73298 .25304 L
.73299 .28931 L
.733 .28682 L
.73306 .26378 L
.73307 .27518 L
.73309 .27257 L
.7331 .29628 L
.73311 .24288 L
.73313 .23543 L
.73314 .25616 L
.73316 .25392 L
.73317 .3169 L
.73318 .29024 L
Mistroke
.73319 .27392 L
.7332 .26398 L
.7332 .2657 L
.73322 .31448 L
.73323 .27787 L
.73324 .27336 L
.73325 .27643 L
.73326 .29931 L
.73327 .26089 L
.73328 .27984 L
.73329 .27685 L
.7333 .31109 L
.73332 .30181 L
.73333 .30311 L
.73334 .27226 L
.73335 .27264 L
.73336 .25426 L
.73336 .27186 L
.73338 .2573 L
.73339 .24684 L
.73341 .29122 L
.73342 .24106 L
.73344 .2602 L
.73345 .3094 L
.73347 .30104 L
.73348 .27629 L
.73349 .26227 L
.7335 .2995 L
.73351 .30928 L
.73353 .25642 L
.73354 .2727 L
.73356 .27547 L
.73357 .3129 L
.73359 .27373 L
.7336 .25913 L
.73361 .26282 L
.73362 .26944 L
.73362 .32464 L
.73363 .26385 L
.73364 .32274 L
.73365 .22178 L
.73366 .28223 L
.73368 .27107 L
.73369 .24956 L
.73371 .31461 L
.73372 .2687 L
.73373 .2742 L
.73374 .30929 L
.73376 .27993 L
.73377 .25452 L
Mistroke
.73379 .29118 L
.7338 .28713 L
.73381 .29692 L
.73383 .26061 L
.73384 .28304 L
.73385 .29727 L
.73386 .28583 L
.73387 .22221 L
.73389 .32593 L
.7339 .24882 L
.73391 .23105 L
.73392 .25739 L
.73393 .30922 L
.73395 .29205 L
.73396 .29129 L
.73397 .25996 L
.73399 .27742 L
.734 .2893 L
.73402 .27696 L
.73403 .29328 L
.73403 .29379 L
.73404 .30976 L
.73405 .33281 L
.73407 .2965 L
.73408 .22145 L
.73409 .28976 L
.73411 .27382 L
.73412 .25101 L
.73414 .30832 L
.73415 .28016 L
.73416 .25867 L
.73417 .28473 L
.73419 .26011 L
.7342 .28952 L
.73422 .28589 L
.73423 .26473 L
.73424 .29838 L
.73426 .28972 L
.73427 .25714 L
.73429 .23778 L
.7343 .2755 L
.73432 .28055 L
.73433 .29684 L
.73434 .27708 L
.73435 .3139 L
.73436 .24666 L
.73437 .30763 L
.73439 .26907 L
.7344 .28797 L
.73441 .31835 L
Mistroke
.73442 .29708 L
.73444 .30068 L
.73444 .26148 L
.73445 .32796 L
.73447 .28099 L
.73448 .26 L
.7345 .28509 L
.73451 .2973 L
.73453 .26059 L
.73454 .27629 L
.73455 .28086 L
.73457 .30188 L
.73458 .2684 L
.7346 .27557 L
.73461 .27127 L
.73462 .29599 L
.73463 .31464 L
.73464 .28196 L
.73466 .29018 L
.73467 .30028 L
.73469 .27877 L
.7347 .33577 L
.73471 .22722 L
.73472 .30172 L
.73473 .28576 L
.73474 .31318 L
.73475 .30242 L
.73476 .2981 L
.73477 .318 L
.73478 .24787 L
.73479 .28311 L
.73479 .31736 L
.7348 .26567 L
.73482 .26562 L
.73483 .30293 L
.73485 .29018 L
.73486 .27492 L
.73488 .28058 L
.73489 .25508 L
.7349 .25578 L
.73492 .27651 L
.73493 .25623 L
.73495 .32355 L
.73496 .27217 L
.73498 .26145 L
.73499 .24338 L
.735 .26986 L
.73501 .2805 L
.73502 .3184 L
.73504 .29506 L
Mistroke
.73505 .27272 L
.73507 .32602 L
.73508 .25385 L
.73509 .31372 L
.73511 .30951 L
.73512 .33331 L
.73514 .31927 L
.73515 .28774 L
.73516 .28991 L
.73517 .30096 L
.73519 .26532 L
.7352 .23881 L
.73522 .25695 L
.73523 .30224 L
.73524 .26949 L
.73525 .23604 L
.73526 .27318 L
.73527 .30852 L
.73529 .2528 L
.7353 .266 L
.73531 .24699 L
.73532 .26878 L
.73533 .25026 L
.73535 .25137 L
.73536 .27364 L
.73537 .30775 L
.73539 .21905 L
.7354 .24238 L
.73542 .30664 L
.73543 .26606 L
.73543 .32428 L
.73545 .26116 L
.73546 .28889 L
.73547 .31107 L
.73548 .25137 L
.7355 .26467 L
.73551 .29619 L
.73552 .25231 L
.73554 .2539 L
.73555 .27097 L
.73556 .3024 L
.73557 .28497 L
.73559 .28163 L
.7356 .30995 L
.73562 .28456 L
.73563 .27736 L
.73564 .27392 L
.73566 .27442 L
.73567 .27784 L
.73569 .287 L
Mistroke
.7357 .2622 L
.73572 .23892 L
.73573 .28327 L
.73574 .30459 L
.73576 .30397 L
.73577 .30523 L
.73578 .28381 L
.73579 .25711 L
.7358 .25827 L
.73581 .28362 L
.73582 .25991 L
.73584 .27394 L
.73584 .28641 L
.73585 .29768 L
.73587 .29873 L
.73588 .31187 L
.73589 .25105 L
.73591 .29169 L
.73592 .32053 L
.73594 .27904 L
.73595 .27895 L
.73596 .21419 L
.73598 .28113 L
.736 .26644 L
.73601 .2942 L
.73602 .27216 L
.73603 .299 L
.73604 .25991 L
.73606 .30777 L
.73607 .25451 L
.73608 .27378 L
.7361 .25532 L
.73611 .25012 L
.73612 .28155 L
.73613 .29768 L
.73614 .24161 L
.73615 .26635 L
.73616 .34037 L
.73617 .28462 L
.73618 .28939 L
.73618 .28752 L
.73619 .29879 L
.7362 .29822 L
.73622 .30898 L
.73623 .25254 L
.73625 .29791 L
.73626 .28962 L
.73628 .29762 L
.73629 .31518 L
.7363 .27722 L
Mistroke
.73632 .28009 L
.73633 .30176 L
.73634 .22669 L
.73636 .26144 L
.73637 .24353 L
.73639 .26016 L
.7364 .3151 L
.73642 .27295 L
.73643 .31885 L
.73644 .23756 L
.73644 .3163 L
.73645 .25266 L
.73647 .28509 L
.73648 .27233 L
.73649 .29653 L
.73651 .26051 L
.73652 .33201 L
.73654 .26984 L
.73655 .27669 L
.73657 .26888 L
.73658 .229 L
.73659 .31284 L
.73661 .30207 L
.73662 .28596 L
.73664 .31142 L
.73665 .26516 L
.73666 .22814 L
.73667 .26868 L
.73669 .28469 L
.7367 .27563 L
.73671 .3036 L
.73672 .26196 L
.73673 .25999 L
.73675 .30837 L
.73676 .25532 L
.73677 .25894 L
.73679 .26881 L
.7368 .30139 L
.73681 .303 L
.73682 .31925 L
.73683 .33095 L
.73685 .23452 L
.73686 .31395 L
.73686 .27919 L
.73688 .29915 L
.73689 .25429 L
.73691 .30595 L
.73692 .28121 L
.73693 .26895 L
.73695 .23357 L
Mistroke
.73696 .3106 L
.73697 .26416 L
.73699 .27878 L
.737 .28006 L
.73702 .28353 L
.73703 .30103 L
.73704 .2624 L
.73706 .30237 L
.73707 .26498 L
.73708 .30241 L
.7371 .27698 L
.73711 .31245 L
.73713 .27694 L
.73714 .29371 L
.73716 .2748 L
.73717 .23453 L
.73718 .30493 L
.73719 .32342 L
.7372 .2429 L
.73721 .26546 L
.73722 .30272 L
.73723 .27808 L
.73725 .27418 L
.73726 .29295 L
.73728 .28967 L
.73729 .29526 L
.73731 .28705 L
.73732 .31443 L
.73733 .32826 L
.73735 .28682 L
.73736 .31386 L
.73738 .30092 L
.73739 .31018 L
.73741 .28043 L
.73742 .2997 L
.73743 .26786 L
.73745 .27901 L
.73746 .29736 L
.73747 .28801 L
.73748 .27438 L
.73748 .27977 L
.7375 .25924 L
.73751 .25053 L
.73752 .30129 L
.73753 .25912 L
.73754 .26851 L
.73755 .289 L
.73756 .25384 L
.73757 .26934 L
.73757 .25529 L
Mistroke
.73758 .26118 L
.73759 .24464 L
.7376 .30246 L
.73761 .30126 L
.73763 .28842 L
.73764 .26846 L
.73766 .32419 L
.73767 .29309 L
.73769 .30411 L
.7377 .29427 L
.73771 .26013 L
.73773 .26695 L
.73774 .26687 L
.73776 .29829 L
.73777 .2839 L
.73778 .25737 L
.7378 .28716 L
.73782 .26515 L
.73782 .29353 L
.73783 .27123 L
.73785 .28252 L
.73786 .28932 L
.73788 .30031 L
.73789 .2789 L
.7379 .30621 L
.73792 .27161 L
.73793 .23722 L
.73794 .28498 L
.73795 .33436 L
.73797 .31285 L
.73798 .26697 L
.738 .28849 L
.73801 .29534 L
.73802 .29689 L
.73804 .2813 L
.73805 .29963 L
.73805 .27452 L
.73807 .27122 L
.73808 .27728 L
.7381 .32293 L
.73811 .31256 L
.73813 .23881 L
.73814 .27018 L
.73816 .30997 L
.73817 .30572 L
.73818 .26857 L
.7382 .26967 L
.73821 .30527 L
.73823 .28072 L
.73824 .31293 L
Mistroke
.73825 .31287 L
.73827 .2904 L
.73828 .27214 L
.73829 .23458 L
.7383 .32266 L
.73832 .2592 L
.73833 .30318 L
.73834 .29699 L
.73836 .26344 L
.73837 .29246 L
.73839 .27634 L
.7384 .27164 L
.73841 .32109 L
.73842 .28891 L
.73844 .26016 L
.73845 .30229 L
.73847 .29974 L
.73848 .27614 L
.73849 .27823 L
.7385 .28708 L
.73851 .28297 L
.73852 .26803 L
.73854 .28372 L
.73855 .26199 L
.73856 .30772 L
.73857 .2609 L
.73858 .29584 L
.7386 .26191 L
.73861 .26883 L
.73862 .27425 L
.73864 .31082 L
.73865 .28711 L
.73867 .24133 L
.73868 .27972 L
.7387 .30617 L
.73871 .29233 L
.73873 .26758 L
.73873 .27369 L
.73874 .27294 L
.73876 .29831 L
.73877 .22239 L
.73879 .25996 L
.7388 .32753 L
.73881 .31012 L
.73883 .26906 L
.73884 .3005 L
.73886 .26748 L
.73887 .29454 L
.73888 .28862 L
.73889 .29485 L
Mistroke
.73891 .23954 L
.73892 .28818 L
.73894 .28938 L
.73895 .31099 L
.73896 .23888 L
.73898 .28561 L
.73899 .26664 L
.73901 .24201 L
.73902 .31967 L
.73902 .29632 L
.73904 .30756 L
.73905 .27044 L
.73907 .27224 L
.73908 .26424 L
.73909 .29396 L
.73911 .24667 L
.73912 .24707 L
.73914 .29635 L
.73915 .27347 L
.73917 .28541 L
.73917 .25398 L
.73918 .28094 L
.7392 .27016 L
.73921 .30832 L
.73922 .27151 L
.73923 .24692 L
.73924 .26892 L
.73926 .27221 L
.73927 .26987 L
.73928 .32078 L
.7393 .29123 L
.73931 .26971 L
.73932 .28488 L
.73934 .28427 L
.73935 .27907 L
.73936 .28073 L
.73938 .23721 L
.73939 .24079 L
.73941 .29324 L
.73942 .31997 L
.73943 .23915 L
.73945 .31366 L
.73947 .27465 L
.73948 .3202 L
.73949 .28369 L
.7395 .23261 L
.7395 .28438 L
.73951 .30792 L
.73953 .30342 L
.73954 .29949 L
Mistroke
.73955 .32999 L
.73956 .25758 L
.73957 .27241 L
.73959 .28265 L
.7396 .2811 L
.73962 .29217 L
.73963 .3076 L
.73964 .24238 L
.73966 .31236 L
.73967 .27087 L
.73968 .27234 L
.7397 .267 L
.73971 .28134 L
.73972 .28016 L
.73973 .27188 L
.73975 .28089 L
.73976 .30185 L
.73978 .28677 L
.73979 .22862 L
.7398 .29964 L
.73981 .30538 L
.73982 .27005 L
.73984 .28693 L
.73985 .22375 L
.73985 .2796 L
.73986 .27748 L
.73987 .2876 L
.73988 .28309 L
.73989 .29197 L
.7399 .26903 L
.73991 .30141 L
.73992 .27036 L
.73994 .26188 L
.73995 .25569 L
.73997 .26067 L
.73998 .29464 L
.74 .28965 L
.74001 .33026 L
.74002 .31127 L
.74004 .3103 L
.74005 .28852 L
.74006 .29449 L
.74008 .30766 L
.74009 .28983 L
.74011 .27031 L
.74012 .27997 L
.74013 .29437 L
.74014 .26836 L
.74016 .25318 L
.74017 .34364 L
Mistroke
.74018 .28063 L
.7402 .27077 L
.74021 .32039 L
.74023 .30172 L
.74024 .2364 L
.74025 .2376 L
.74026 .26016 L
.74028 .34101 L
.74029 .30773 L
.7403 .28979 L
.74032 .28694 L
.74033 .3014 L
.74035 .26828 L
.74035 .2984 L
.74036 .25785 L
.74038 .25743 L
.74039 .25816 L
.74041 .25502 L
.74041 .31475 L
.74042 .29634 L
.74044 .30008 L
.74045 .28791 L
.74046 .27853 L
.74048 .24984 L
.74049 .27686 L
.7405 .25915 L
.74052 .2857 L
.74053 .29485 L
.74054 .30538 L
.74055 .25099 L
.74056 .22038 L
.74057 .28605 L
.74058 .28681 L
.7406 .26933 L
.74061 .28022 L
.74063 .25992 L
.74064 .26627 L
.74065 .27826 L
.74067 .27963 L
.74068 .28485 L
.74069 .26454 L
.74071 .27907 L
.74072 .27235 L
.74073 .27756 L
.74075 .29812 L
.74076 .2883 L
.74078 .30124 L
.74079 .28221 L
.74081 .30398 L
.74082 .25416 L
Mistroke
.74083 .3614 L
.74085 .33704 L
.74086 .28265 L
.74088 .2845 L
.74088 .28792 L
.74089 .28106 L
.74091 .27041 L
.74092 .33177 L
.74092 .26515 L
.74093 .26975 L
.74094 .28312 L
.74096 .25145 L
.74097 .27915 L
.74097 .2529 L
.74099 .24441 L
.741 .26634 L
.74102 .29633 L
.74103 .2852 L
.74105 .27002 L
.74105 .28351 L
.74106 .30868 L
.74108 .27953 L
.74109 .29003 L
.74111 .26946 L
.74112 .2979 L
.74114 .29177 L
.74115 .22929 L
.74116 .31531 L
.74117 .3321 L
.74119 .26174 L
.7412 .24806 L
.74121 .27254 L
.74123 .3174 L
.74124 .24678 L
.74126 .30655 L
.74127 .29812 L
.74128 .29121 L
.74129 .31449 L
.7413 .3082 L
.74132 .23683 L
.74133 .24237 L
.74135 .28051 L
.74136 .25107 L
.74137 .267 L
.74139 .22772 L
.7414 .27728 L
.7414 .29857 L
.74142 .28766 L
.74143 .29535 L
.74144 .30321 L
Mistroke
.74145 .32281 L
.74146 .27356 L
.74147 .26899 L
.74148 .2755 L
.74149 .25033 L
.7415 .26326 L
.74151 .28867 L
.74153 .29024 L
.74154 .26826 L
.74156 .33607 L
.74157 .27123 L
.74158 .28474 L
.7416 .244 L
.74161 .28142 L
.74162 .27873 L
.74164 .3187 L
.74165 .26083 L
.74166 .25952 L
.74168 .23334 L
.74169 .27405 L
.74171 .29788 L
.74172 .30175 L
.74173 .24756 L
.74174 .29957 L
.74175 .28163 L
.74176 .26784 L
.74178 .27873 L
.74179 .27537 L
.74181 .27887 L
.74182 .25571 L
.74184 .30749 L
.74185 .3477 L
.74186 .26094 L
.74188 .30562 L
.74189 .26705 L
.74191 .2984 L
.74192 .30855 L
.74193 .32001 L
.74195 .29238 L
.74197 .28999 L
.74197 .26415 L
.74198 .22813 L
.742 .28976 L
.74201 .28135 L
.74203 .2918 L
.74204 .25459 L
.74205 .29565 L
.74207 .29112 L
.74208 .29716 L
.74209 .29834 L
Mistroke
.7421 .2612 L
.74212 .25673 L
.74213 .31651 L
.74215 .2515 L
.74216 .25405 L
.74217 .28697 L
.74219 .29475 L
.7422 .27019 L
.7422 .26117 L
.74222 .29361 L
.74223 .27517 L
.74225 .26212 L
.74226 .28877 L
.74226 .28664 L
.74228 .3011 L
.74229 .27349 L
.7423 .30568 L
.74232 .23451 L
.74233 .26618 L
.74235 .28573 L
.74236 .28382 L
.74237 .29267 L
.74238 .30324 L
.74239 .28087 L
.7424 .3224 L
.74241 .28407 L
.74242 .28617 L
.74244 .29069 L
.74245 .3099 L
.74247 .2848 L
.74248 .24534 L
.74249 .30205 L
.74251 .26534 L
.74252 .33432 L
.74253 .28939 L
.74255 .25041 L
.74256 .26668 L
.74257 .28106 L
.74259 .22087 L
.7426 .3111 L
.74262 .27323 L
.74263 .28009 L
.74264 .31722 L
.74266 .32098 L
.74267 .26596 L
.74269 .25496 L
.7427 .24551 L
.74272 .25585 L
.74273 .28271 L
.74273 .31742 L
Mistroke
.74274 .35004 L
.74275 .29659 L
.74277 .25427 L
.74278 .30209 L
.74279 .31748 L
.74281 .27739 L
.74282 .24402 L
.74284 .31552 L
.74285 .272 L
.74286 .27673 L
.74288 .28797 L
.74289 .28379 L
.74291 .24338 L
.74292 .26459 L
.74294 .31724 L
.74295 .3108 L
.74297 .24463 L
.74298 .30651 L
.743 .29739 L
.743 .2895 L
.74301 .28477 L
.74302 .30139 L
.74303 .309 L
.74304 .29394 L
.74305 .28595 L
.74306 .28243 L
.74308 .29159 L
.74308 .25986 L
.74309 .32229 L
.7431 .29449 L
.74311 .27701 L
.74312 .28689 L
.74313 .25137 L
.74314 .30786 L
.74314 .27296 L
.74316 .25785 L
.74317 .3104 L
.74319 .29795 L
.7432 .3203 L
.74322 .32377 L
.74323 .28688 L
.74325 .29024 L
.74326 .29689 L
.74327 .29138 L
.74329 .29772 L
.7433 .27258 L
.74332 .27243 L
.74333 .3053 L
.74334 .31037 L
.74336 .30625 L
Mistroke
.74337 .2822 L
.74338 .2873 L
.74339 .28923 L
.74341 .30053 L
.74342 .30194 L
.74343 .2751 L
.74345 .22526 L
.74346 .32506 L
.74347 .30982 L
.74349 .28186 L
.7435 .27875 L
.74351 .27276 L
.74353 .33216 L
.74354 .26692 L
.74355 .27722 L
.74357 .29905 L
.74358 .29774 L
.74359 .29753 L
.7436 .32388 L
.74361 .31309 L
.74363 .33399 L
.74364 .31511 L
.74366 .34805 L
.74367 .2851 L
.74369 .24929 L
.7437 .33236 L
.74371 .26961 L
.74373 .27854 L
.74374 .3162 L
.74376 .27526 L
.74377 .33006 L
.74378 .2589 L
.7438 .24335 L
.74381 .32028 L
.74382 .28842 L
.74383 .23144 L
.74385 .21092 L
.74386 .27739 L
.74387 .28356 L
.74389 .27249 L
.7439 .30801 L
.74392 .2659 L
.74393 .33696 L
.74394 .2665 L
.74395 .2892 L
.74397 .27948 L
.74398 .29306 L
.74399 .3481 L
.74401 .3015 L
.74402 .2367 L
Mistroke
.74404 .26868 L
.74405 .29141 L
.74405 .32261 L
.74407 .30256 L
.74408 .25509 L
.7441 .26323 L
.74411 .28818 L
.74413 .26501 L
.74414 .33682 L
.74415 .29436 L
.74417 .2909 L
.74418 .27421 L
.7442 .26215 L
.74421 .25834 L
.74423 .31655 L
.74424 .30391 L
.74425 .26327 L
.74427 .28093 L
.74428 .24567 L
.74429 .30603 L
.74429 .26599 L
.7443 .24322 L
.74432 .24115 L
.74433 .32242 L
.74434 .33549 L
.74436 .26108 L
.74437 .29552 L
.74439 .29111 L
.7444 .27612 L
.74442 .24065 L
.74443 .2758 L
.74445 .31775 L
.74446 .27357 L
.74447 .29921 L
.74449 .26004 L
.7445 .23805 L
.74451 .25418 L
.74452 .24291 L
.74454 .27433 L
.74455 .22757 L
.74456 .30836 L
.74457 .25962 L
.74458 .34332 L
.7446 .29719 L
.74461 .28473 L
.74462 .30416 L
.74464 .29394 L
.74465 .28519 L
.74467 .33441 L
.74467 .2643 L
Mistroke
.74468 .29961 L
.7447 .26558 L
.74471 .31088 L
.74471 .27699 L
.74473 .31712 L
.74474 .30092 L
.74476 .31052 L
.74477 .27437 L
.74479 .29427 L
.7448 .33455 L
.74481 .28414 L
.74483 .28969 L
.74484 .30721 L
.74486 .27064 L
.74487 .3156 L
.74489 .27256 L
.7449 .28358 L
.74491 .33452 L
.74493 .27794 L
.74494 .26947 L
.74495 .24034 L
.74497 .28903 L
.74498 .32674 L
.74499 .29079 L
.74501 .29879 L
.74502 .30414 L
.74504 .29584 L
.74505 .26113 L
.74506 .31431 L
.74507 .25032 L
.74509 .29813 L
.74509 .26572 L
.7451 .26663 L
.74512 .26005 L
.74513 .30085 L
.74514 .2979 L
.74516 .30036 L
.74517 .24556 L
.74518 .3266 L
.7452 .30434 L
.74521 .25504 L
.74523 .27443 L
.74524 .27356 L
.74526 .26305 L
.74527 .28851 L
.74528 .29412 L
.74528 .28689 L
.74529 .28732 L
.7453 .33601 L
.74531 .32031 L
Mistroke
.74532 .29204 L
.74533 .29663 L
.74533 .28025 L
.74534 .29419 L
.74536 .28329 L
.74537 .25321 L
.74539 .31684 L
.7454 .26651 L
.74542 .29853 L
.74543 .30225 L
.74543 .29981 L
.74545 .3074 L
.74546 .27001 L
.74548 .29917 L
.74549 .34905 L
.74551 .30487 L
.74552 .2682 L
.74554 .27038 L
.74555 .31424 L
.74556 .27944 L
.74557 .27075 L
.74558 .27403 L
.7456 .27475 L
.74561 .31487 L
.74562 .20721 L
.74563 .28781 L
.74565 .28629 L
.74566 .30651 L
.74568 .28123 L
.74569 .34457 L
.7457 .25661 L
.74572 .32947 L
.74573 .26654 L
.74574 .3193 L
.74575 .23616 L
.74577 .27641 L
.74577 .257 L
.74578 .28338 L
.7458 .27843 L
.74581 .24809 L
.74581 .35524 L
.74582 .27896 L
.74583 .28383 L
.74585 .32645 L
.74586 .23413 L
.74586 .27145 L
.74588 .26247 L
.74589 .29988 L
.74591 .30577 L
.74592 .2948 L
Mistroke
.74594 .21754 L
.74595 .26389 L
.74597 .32524 L
.74598 .31304 L
.74598 .31303 L
.746 .25919 L
.74601 .26542 L
.74603 .29925 L
.74604 .33277 L
.74605 .30567 L
.74606 .34342 L
.74607 .26798 L
.74608 .29495 L
.74609 .29132 L
.7461 .29184 L
.74611 .28331 L
.74612 .27538 L
.74614 .25548 L
.74615 .23122 L
.74617 .26247 L
.74618 .24302 L
.7462 .27636 L
.74621 .29604 L
.74622 .32114 L
.74623 .29787 L
.74624 .30789 L
.74626 .26838 L
.74627 .25859 L
.74628 .30452 L
.7463 .28856 L
.74631 .29484 L
.74632 .30722 L
.74634 .28508 L
.74635 .28943 L
.74636 .26223 L
.74638 .27486 L
.74639 .28827 L
.7464 .31955 L
.74642 .26145 L
.74643 .31759 L
.74645 .29361 L
.74646 .31145 L
.74648 .28644 L
.74649 .22706 L
.7465 .31685 L
.74652 .2915 L
.74653 .28349 L
.74654 .28727 L
.74655 .27557 L
.74656 .31256 L
Mistroke
.74656 .31178 L
.74658 .28458 L
.74659 .32103 L
.7466 .31363 L
.74661 .30854 L
.74662 .26911 L
.74664 .29188 L
.74666 .30807 L
.74666 .3247 L
.74667 .30887 L
.74669 .26103 L
.7467 .26679 L
.74671 .31684 L
.74672 .32558 L
.74673 .30445 L
.74675 .28939 L
.74676 .32566 L
.74678 .3332 L
.74678 .29741 L
.74679 .29845 L
.7468 .19528 L
.74681 .22248 L
.74682 .30055 L
.74684 .28274 L
.74686 .25879 L
.74686 .29093 L
.74687 .23277 L
.74688 .27781 L
.74689 .31173 L
.7469 .27796 L
.74691 .27954 L
.74692 .31189 L
.74694 .29654 L
.74695 .25399 L
.74696 .29208 L
.74697 .29504 L
.74699 .29828 L
.74699 .29151 L
.747 .27832 L
.74702 .26406 L
.74703 .33924 L
.74704 .29341 L
.74706 .30903 L
.74707 .29776 L
.74708 .28057 L
.7471 .25319 L
.74712 .29406 L
.74713 .26122 L
.74714 .29037 L
.74716 .26583 L
Mistroke
.74717 .27968 L
.74719 .30578 L
.7472 .28458 L
.74722 .30667 L
.74723 .31609 L
.74723 .31661 L
.74725 .27805 L
.74726 .26969 L
.74727 .26525 L
.74727 .29924 L
.74728 .26683 L
.7473 .32496 L
.74731 .28936 L
.74731 .25428 L
.74732 .27638 L
.74733 .31552 L
.74734 .27136 L
.74735 .28245 L
.74736 .29016 L
.74737 .26659 L
.74738 .24575 L
.7474 .29869 L
.74741 .26358 L
.74742 .34288 L
.74743 .234 L
.74744 .29024 L
.74745 .26503 L
.74747 .34046 L
.74748 .26574 L
.74749 .28512 L
.74751 .28979 L
.74752 .29599 L
.74752 .28983 L
.74754 .29908 L
.74756 .31797 L
.74756 .30124 L
.74757 .27948 L
.74759 .28045 L
.7476 .26974 L
.74762 .277 L
.74763 .31365 L
.74764 .27891 L
.74766 .28338 L
.74767 .21115 L
.74768 .29681 L
.7477 .29969 L
.74771 .28342 L
.74772 .32526 L
.74774 .29518 L
.74775 .3128 L
Mistroke
.74777 .30623 L
.74779 .29092 L
.74781 .30972 L
.74782 .31887 L
.74784 .30453 L
.74785 .24844 L
.74786 .27112 L
.74788 .291 L
.74789 .30249 L
.74791 .28975 L
.74792 .30328 L
.74794 .26436 L
.74795 .30259 L
.74796 .23938 L
.74797 .27503 L
.74798 .27546 L
.74799 .32284 L
.748 .31429 L
.74801 .29485 L
.74802 .29073 L
.74803 .28253 L
.74805 .2856 L
.74806 .34524 L
.74807 .29807 L
.74808 .29669 L
.74809 .32315 L
.74811 .28188 L
.74812 .28883 L
.74813 .26768 L
.74815 .31972 L
.74816 .33529 L
.74817 .28323 L
.74818 .31217 L
.7482 .30488 L
.74821 .2747 L
.74823 .24826 L
.74824 .29763 L
.74825 .28973 L
.74827 .2754 L
.74828 .28956 L
.74829 .29268 L
.7483 .32059 L
.74831 .26988 L
.74833 .30609 L
.74834 .25216 L
.74835 .27421 L
.74836 .27753 L
.74837 .2718 L
.74838 .27323 L
.74839 .31599 L
Mistroke
.74841 .29351 L
.74842 .28348 L
.74844 .32117 L
.74845 .29282 L
.74845 .2846 L
.74846 .29973 L
.74847 .30349 L
.74849 .28168 L
.7485 .32123 L
.74851 .32192 L
.74852 .2852 L
.74853 .31371 L
.74854 .2863 L
.74854 .29704 L
.74855 .2938 L
.74856 .27748 L
.74857 .29429 L
.74858 .26006 L
.7486 .25719 L
.74861 .306 L
.74863 .28275 L
.74864 .29456 L
.74866 .29444 L
.74866 .27255 L
.74867 .2695 L
.74869 .27047 L
.7487 .28477 L
.7487 .33455 L
.74871 .27232 L
.74872 .27035 L
.74874 .3261 L
.74875 .3038 L
.74875 .30137 L
.74878 .27712 L
.74879 .30716 L
.7488 .26062 L
.74881 .28471 L
.74883 .28709 L
.74884 .29222 L
.74884 .26621 L
.74886 .26883 L
.74887 .32595 L
.74888 .27235 L
.74889 .26008 L
.7489 .26305 L
.74891 .27143 L
.74892 .27769 L
.74893 .30831 L
.74894 .30167 L
.74895 .28105 L
Mistroke
.74897 .27556 L
.74898 .2976 L
.74899 .28894 L
.749 .27665 L
.74901 .31267 L
.74903 .30378 L
.74904 .28982 L
.74906 .29195 L
.74907 .32372 L
.74908 .28902 L
.7491 .31507 L
.74911 .30202 L
.74912 .29979 L
.74914 .27983 L
.74915 .29034 L
.74916 .27686 L
.74918 .35136 L
.74919 .28391 L
.7492 .33104 L
.74921 .29038 L
.74922 .28567 L
.74924 .2585 L
.74925 .24331 L
.74926 .29046 L
.74928 .24774 L
.74929 .24446 L
.74931 .31645 L
.74932 .25836 L
.74933 .30155 L
.74934 .29729 L
.74935 .25082 L
.74936 .34403 L
.74937 .31144 L
.74938 .30461 L
.7494 .28867 L
.74941 .30728 L
.74943 .34447 L
.74944 .2886 L
.74945 .272 L
.74947 .2833 L
.74948 .26133 L
.7495 .23358 L
.74951 .336 L
.74953 .26261 L
.74954 .28891 L
.74954 .26217 L
.74956 .27512 L
.74957 .26407 L
.74959 .29063 L
.7496 .26534 L
Mistroke
.74962 .29308 L
.74963 .27284 L
.74964 .28283 L
.74965 .2877 L
.74966 .27893 L
.74967 .29685 L
.74967 .33546 L
.74968 .32923 L
.74969 .28621 L
.7497 .26645 L
.74972 .28104 L
.74972 .23845 L
.74973 .31468 L
.74975 .31851 L
.74976 .29569 L
.74978 .28368 L
.74978 .31095 L
.74979 .25992 L
.74981 .2857 L
.74982 .30287 L
.74983 .33651 L
.74984 .26226 L
.74985 .29309 L
.74986 .31026 L
.74987 .31317 L
.74988 .27799 L
.74989 .25253 L
.7499 .27238 L
.74992 .29171 L
.74993 .24351 L
.74994 .26928 L
.74996 .27431 L
.74997 .2803 L
.74998 .27826 L
.74998 .33015 L
.74999 .29523 L
.75001 .28221 L
.75002 .30104 L
.75004 .33806 L
.75005 .31288 L
.75006 .35147 L
.75008 .28894 L
.75009 .30322 L
.75009 .28797 L
.75011 .25425 L
.75012 .3043 L
.75014 .28798 L
.75015 .27628 L
.75016 .30697 L
.75017 .32764 L
Mistroke
.75019 .2826 L
.7502 .23807 L
.75022 .28924 L
.75023 .29553 L
.75025 .29393 L
.75026 .29595 L
.75027 .26405 L
.75029 .30348 L
.7503 .31705 L
.75031 .29871 L
.75032 .24623 L
.75033 .35864 L
.75035 .25805 L
.75036 .26156 L
.75038 .27743 L
.75039 .25125 L
.7504 .25991 L
.75041 .28069 L
.75043 .29382 L
.75044 .28182 L
.75046 .30098 L
.75047 .24736 L
.75048 .25547 L
.75049 .31084 L
.7505 .34062 L
.75052 .29088 L
.75053 .29144 L
.75054 .28328 L
.75055 .28057 L
.75056 .28229 L
.75057 .31652 L
.75058 .30019 L
.75059 .31251 L
.7506 .3019 L
.75061 .32024 L
.75062 .3003 L
.75063 .30464 L
.75065 .29474 L
.75066 .3282 L
.75068 .32766 L
.75069 .32003 L
.75071 .26994 L
.75072 .26794 L
.75073 .30141 L
.75074 .29 L
.75075 .2878 L
.75076 .29793 L
.75077 .28728 L
.75078 .29843 L
.7508 .3174 L
Mistroke
.75081 .27515 L
.75083 .29801 L
.75084 .30485 L
.75085 .3287 L
.75085 .31087 L
.75086 .28346 L
.75088 .27442 L
.75089 .2791 L
.7509 .25272 L
.75091 .23731 L
.75092 .24113 L
.75093 .28839 L
.75093 .32883 L
.75094 .27801 L
.75095 .2679 L
.75096 .30572 L
.75098 .28546 L
.75098 .33323 L
.75099 .31835 L
.75101 .25731 L
.75102 .27704 L
.75103 .29433 L
.75105 .28998 L
.75106 .26382 L
.75108 .26713 L
.75108 .32214 L
.75109 .25817 L
.7511 .29163 L
.75111 .28516 L
.75113 .30615 L
.75113 .31231 L
.75114 .29588 L
.75116 .26253 L
.75117 .31333 L
.75118 .30642 L
.75119 .27805 L
.7512 .26156 L
.75121 .32143 L
.75122 .29541 L
.75123 .28714 L
.75125 .26768 L
.75126 .31602 L
.75127 .30005 L
.75128 .28256 L
.7513 .24347 L
.7513 .35188 L
.75131 .30069 L
.75133 .29795 L
.75134 .24891 L
.75136 .27102 L
Mistroke
.75137 .27576 L
.75139 .24768 L
.7514 .30689 L
.75141 .26579 L
.75142 .30722 L
.75144 .25474 L
.75145 .25232 L
.75147 .29625 L
.75148 .29074 L
.75149 .3502 L
.7515 .29052 L
.75152 .2826 L
.75153 .32816 L
.75154 .24927 L
.75156 .25576 L
.75158 .33121 L
.75158 .30316 L
.75159 .2894 L
.7516 .2645 L
.75161 .27033 L
.75162 .2629 L
.75163 .28679 L
.75163 .26688 L
.75164 .27524 L
.75165 .31861 L
.75166 .29369 L
.75168 .24308 L
.75169 .29904 L
.75171 .261 L
.75172 .30611 L
.75172 .28735 L
.75174 .28488 L
.75175 .29639 L
.75176 .28751 L
.75177 .30748 L
.75179 .27414 L
.7518 .28524 L
.75181 .26893 L
.75183 .28207 L
.75184 .26576 L
.75186 .29718 L
.75187 .30927 L
.75189 .26596 L
.7519 .27423 L
.75191 .307 L
.75192 .2523 L
.75194 .26659 L
.75196 .29627 L
.75196 .26822 L
.75197 .30756 L
Mistroke
.75198 .23596 L
.75199 .31982 L
.752 .2737 L
.75201 .28863 L
.75202 .26494 L
.75203 .30374 L
.75204 .29713 L
.75205 .29839 L
.75206 .32875 L
.75207 .28088 L
.75208 .29564 L
.75209 .31517 L
.7521 .33759 L
.75211 .33302 L
.75212 .30314 L
.75213 .30335 L
.75215 .33003 L
.75216 .28446 L
.75218 .27047 L
.75219 .30351 L
.75221 .32569 L
.75222 .32872 L
.75223 .27803 L
.75225 .25645 L
.75226 .26203 L
.75226 .27623 L
.75228 .27879 L
.75229 .31883 L
.75231 .26998 L
.75232 .28034 L
.75233 .31993 L
.75235 .30784 L
.75236 .31609 L
.75237 .32219 L
.75239 .2458 L
.7524 .30599 L
.75242 .25737 L
.75242 .2912 L
.75243 .23704 L
.75245 .28723 L
.75246 .26664 L
.75247 .28792 L
.75248 .24591 L
.75249 .2611 L
.7525 .29715 L
.75251 .26259 L
.75252 .27682 L
.75253 .34875 L
.75254 .31456 L
.75255 .26684 L
Mistroke
.75256 .26833 L
.75257 .23097 L
.75258 .26196 L
.75259 .2627 L
.75261 .28097 L
.75262 .30627 L
.75264 .27656 L
.75265 .27315 L
.75266 .25882 L
.75268 .30486 L
.75269 .24397 L
.75271 .28257 L
.75272 .25719 L
.75273 .29131 L
.75274 .28068 L
.75275 .34919 L
.75277 .27365 L
.75278 .29624 L
.7528 .30596 L
.75281 .33944 L
.75282 .26805 L
.75284 .28962 L
.75285 .32186 L
.75286 .30765 L
.75288 .33284 L
.75289 .32312 L
.75289 .27004 L
.75291 .29894 L
.75293 .27686 L
.75294 .29767 L
.75295 .30869 L
.75296 .2859 L
.75297 .262 L
.75298 .29947 L
.75299 .29337 L
.753 .26751 L
.75301 .2558 L
.75302 .27062 L
.75304 .33256 L
.75305 .28717 L
.75306 .32575 L
.75308 .30349 L
.75309 .30565 L
.7531 .29971 L
.75311 .28453 L
.75313 .27948 L
.75314 .29281 L
.75316 .29732 L
.75317 .29978 L
.75318 .28674 L
Mistroke
.7532 .27373 L
.75321 .29075 L
.75322 .3036 L
.75323 .27837 L
.75324 .31819 L
.75326 .26377 L
.75327 .27725 L
.75328 .29417 L
.7533 .28057 L
.75331 .27455 L
.75332 .32629 L
.75334 .33447 L
.75335 .28928 L
.75337 .28595 L
.75338 .26604 L
.75339 .31014 L
.7534 .25041 L
.75341 .32065 L
.75343 .27125 L
.75344 .29542 L
.75346 .30218 L
.75347 .26149 L
.75348 .30134 L
.75349 .29483 L
.7535 .28866 L
.75351 .31675 L
.75352 .31709 L
.75353 .31185 L
.75354 .33177 L
.75355 .3205 L
.75357 .30521 L
.75358 .25812 L
.75359 .32971 L
.7536 .30254 L
.75361 .28194 L
.75363 .29295 L
.75364 .29932 L
.75366 .30447 L
.75367 .28153 L
.75368 .3024 L
.75369 .28344 L
.7537 .33508 L
.75372 .28194 L
.75373 .29167 L
.75374 .28096 L
.75376 .27825 L
.75377 .29302 L
.75378 .28685 L
.7538 .33334 L
.75381 .28051 L
Mistroke
.75383 .2678 L
.75384 .31619 L
.75385 .26981 L
.75386 .27447 L
.75387 .28461 L
.75389 .3097 L
.7539 .28343 L
.75391 .32558 L
.75392 .27835 L
.75393 .30602 L
.75394 .26423 L
.75395 .29756 L
.75395 .28177 L
.75397 .25251 L
.75398 .30613 L
.754 .25945 L
.75401 .30191 L
.75403 .30171 L
.75404 .28975 L
.75404 .24579 L
.75406 .29553 L
.75408 .30241 L
.75408 .2785 L
.75409 .25838 L
.75411 .32014 L
.75412 .32532 L
.75413 .299 L
.75414 .29435 L
.75415 .28874 L
.75417 .31326 L
.75419 .29308 L
.7542 .31694 L
.75421 .33222 L
.75421 .26426 L
.75423 .33219 L
.75424 .2626 L
.75425 .32718 L
.75426 .31584 L
.75426 .25517 L
.75427 .30663 L
.75428 .30331 L
.75429 .30207 L
.7543 .31627 L
.75431 .26903 L
.75432 .28267 L
.75432 .3126 L
.75433 .29195 L
.75435 .29872 L
.75436 .31114 L
.75438 .25605 L
Mistroke
.75439 .30229 L
.75441 .28838 L
.75442 .24793 L
.75443 .29409 L
.75445 .28377 L
.75446 .31679 L
.75448 .27868 L
.75448 .27234 L
.75449 .27449 L
.75451 .2503 L
.75452 .30482 L
.75453 .32603 L
.75453 .28697 L
.75454 .29349 L
.75455 .28785 L
.75456 .29788 L
.75458 .30562 L
.75459 .2718 L
.7546 .30215 L
.75462 .29569 L
.75463 .36383 L
.75465 .28368 L
.75466 .27123 L
.75467 .27117 L
.75469 .29373 L
.7547 .30716 L
.7547 .29892 L
.75471 .24547 L
.75472 .28869 L
.75474 .23188 L
.75475 .27917 L
.75475 .33145 L
.75477 .29085 L
.75478 .28338 L
.7548 .33075 L
.75481 .30838 L
.75483 .2935 L
.75484 .26965 L
.75484 .31692 L
.75486 .32041 L
.75487 .28415 L
.75488 .24866 L
.75489 .3063 L
.7549 .28791 L
.75492 .3166 L
.75493 .30422 L
.75494 .30979 L
.75495 .31223 L
.75496 .30069 L
.75497 .26175 L
Mistroke
.75498 .25054 L
.755 .26916 L
.75501 .28104 L
.75501 .30683 L
.75503 .32419 L
.75504 .29004 L
.75505 .24673 L
.75506 .28666 L
.75507 .2859 L
.75507 .28345 L
.75508 .27129 L
.7551 .31059 L
.75511 .30807 L
.75512 .31259 L
.75513 .32235 L
.75515 .29495 L
.75516 .31263 L
.75517 .29781 L
.75517 .29755 L
.75519 .25599 L
.7552 .2798 L
.75522 .27372 L
.75523 .2953 L
.75525 .29396 L
.75526 .29536 L
.75527 .31393 L
.75529 .31719 L
.7553 .27755 L
.75532 .29773 L
.75533 .31106 L
.75534 .31602 L
.75535 .30596 L
.75536 .29957 L
.75538 .29102 L
.7554 .27699 L
.75541 .31773 L
.75542 .3009 L
.75543 .24869 L
.75544 .30219 L
.75546 .29735 L
.75546 .29762 L
.75547 .25328 L
.75548 .27414 L
.75549 .32433 L
.75551 .3333 L
.75552 .33746 L
.75553 .28041 L
.75554 .33773 L
.75555 .31372 L
.75555 .30007 L
Mistroke
.75557 .29083 L
.75558 .27437 L
.75559 .27942 L
.7556 .31216 L
.75561 .30994 L
.75563 .28858 L
.75564 .32106 L
.75565 .27888 L
.75567 .28275 L
.75568 .3116 L
.75569 .30329 L
.7557 .27349 L
.75572 .29404 L
.75573 .32135 L
.75573 .2556 L
.75575 .30212 L
.75576 .2647 L
.75578 .283 L
.75579 .23968 L
.7558 .23722 L
.75582 .25025 L
.75583 .28931 L
.75584 .31359 L
.75586 .25237 L
.75587 .31338 L
.75589 .30254 L
.7559 .30468 L
.75591 .2825 L
.75592 .34592 L
.75594 .3069 L
.75595 .302 L
.75597 .33758 L
.75598 .31224 L
.756 .28205 L
.75601 .28701 L
.75603 .26357 L
.75604 .29549 L
.75605 .26055 L
.75606 .29613 L
.75607 .24938 L
.75609 .30949 L
.7561 .28738 L
.75611 .28371 L
.75613 .30537 L
.75613 .30326 L
.75614 .26147 L
.75616 .27616 L
.75617 .27234 L
.75618 .30415 L
.75618 .25231 L
Mistroke
.75619 .30494 L
.75621 .30817 L
.75621 .27486 L
.75622 .28049 L
.75624 .27682 L
.75625 .28826 L
.75627 .25604 L
.75628 .32117 L
.75629 .28722 L
.7563 .28986 L
.75631 .29746 L
.75632 .2784 L
.75633 .32585 L
.75635 .27309 L
.75636 .25203 L
.75638 .24742 L
.75638 .33158 L
.75639 .26326 L
.75641 .32602 L
.75642 .30424 L
.75643 .28476 L
.75643 .28424 L
.75644 .29128 L
.75645 .26735 L
.75646 .2898 L
.75647 .31122 L
.75648 .31399 L
.75649 .27725 L
.75651 .27905 L
.75652 .30695 L
.75653 .2613 L
.75654 .33882 L
.75654 .29722 L
.75655 .31349 L
.75657 .25924 L
.75658 .32331 L
.7566 .3096 L
.75661 .26971 L
.75663 .31585 L
.75664 .31664 L
.75665 .30584 L
.75665 .35794 L
.75666 .29185 L
.75667 .29179 L
.75668 .26498 L
.75669 .29859 L
.7567 .33485 L
.75671 .29709 L
.75672 .32378 L
.75673 .33083 L
Mistroke
.75674 .2862 L
.75675 .28652 L
.75676 .27609 L
.75678 .31226 L
.75678 .26735 L
.75679 .29212 L
.75681 .26309 L
.75682 .2849 L
.75684 .33191 L
.75685 .28844 L
.75686 .30044 L
.75688 .30269 L
.75689 .32256 L
.75689 .32723 L
.7569 .26097 L
.75691 .32205 L
.75693 .27201 L
.75694 .29076 L
.75694 .28079 L
.75696 .29728 L
.75697 .31471 L
.75699 .34597 L
.757 .29215 L
.75702 .29925 L
.75703 .29447 L
.75703 .29277 L
.75705 .29099 L
.75706 .32595 L
.75708 .25285 L
.75709 .2689 L
.7571 .29282 L
.75712 .27719 L
.75713 .31998 L
.75714 .24291 L
.75715 .28735 L
.75717 .29875 L
.75717 .28978 L
.75718 .26885 L
.7572 .32049 L
.75721 .33156 L
.75723 .27131 L
.75724 .28699 L
.75725 .31764 L
.75727 .29257 L
.75728 .28527 L
.75729 .26954 L
.75731 .26128 L
.75732 .3613 L
.75733 .31043 L
.75735 .3173 L
Mistroke
.75736 .33681 L
.75737 .30158 L
.75739 .27834 L
.7574 .29541 L
.75742 .26972 L
.75743 .3224 L
.75745 .31472 L
.75746 .3023 L
.75747 .27699 L
.75748 .31689 L
.75749 .29424 L
.75751 .27633 L
.75752 .25065 L
.75752 .29744 L
.75754 .30146 L
.75755 .29542 L
.75756 .30897 L
.75757 .32316 L
.75758 .26905 L
.7576 .26784 L
.75761 .31788 L
.75763 .28836 L
.75764 .29097 L
.75766 .27122 L
.75767 .28289 L
.75768 .30395 L
.7577 .27478 L
.75771 .32288 L
.75773 .31003 L
.75774 .32131 L
.75774 .31264 L
.75776 .25747 L
.75777 .29691 L
.75779 .26863 L
.7578 .27328 L
.75782 .29779 L
.75783 .26025 L
.75783 .31799 L
.75785 .28637 L
.75786 .33684 L
.75787 .31014 L
.75788 .24564 L
.75789 .29225 L
.75789 .31416 L
.7579 .30105 L
.75792 .28271 L
.75793 .30908 L
.75795 .25625 L
.75796 .28301 L
.75798 .30617 L
Mistroke
.75799 .2584 L
.758 .30943 L
.75801 .29779 L
.75802 .24892 L
.75804 .32577 L
.75805 .27333 L
.75806 .23854 L
.75808 .22365 L
.75809 .3437 L
.75811 .31968 L
.75812 .29344 L
.75812 .26172 L
.75813 .31593 L
.75814 .26114 L
.75816 .29116 L
.75816 .30886 L
.75817 .26708 L
.75818 .26615 L
.75819 .31431 L
.7582 .29417 L
.75822 .29843 L
.75823 .26427 L
.75824 .2936 L
.75825 .29 L
.75827 .30523 L
.75828 .29218 L
.75829 .29321 L
.75831 .31277 L
.75832 .30733 L
.75833 .29776 L
.75834 .30859 L
.75835 .30849 L
.75836 .27971 L
.75837 .25397 L
.75838 .32162 L
.75839 .29627 L
.7584 .28724 L
.7584 .30422 L
.75841 .28605 L
.75843 .29557 L
.75844 .2953 L
.75846 .252 L
.75847 .27833 L
.75849 .33642 L
.7585 .28722 L
.75852 .2614 L
.75853 .29453 L
.75854 .29269 L
.75856 .3407 L
.75857 .28049 L
Mistroke
.75859 .26178 L
.7586 .26945 L
.75861 .31314 L
.75863 .28133 L
.75864 .27813 L
.75865 .27033 L
.75866 .31457 L
.75868 .29269 L
.75869 .30716 L
.7587 .25931 L
.75872 .28317 L
.75873 .32146 L
.75874 .29195 L
.75876 .30969 L
.75877 .26062 L
.75878 .30788 L
.7588 .31156 L
.75881 .26909 L
.75882 .26903 L
.75884 .31837 L
.75885 .32185 L
.75886 .27979 L
.75887 .3392 L
.75888 .29529 L
.7589 .29095 L
.75891 .27807 L
.75893 .32587 L
.75894 .29503 L
.75896 .35725 L
.75897 .32786 L
.75898 .27453 L
.759 .30037 L
.75901 .27701 L
.75903 .24994 L
.75904 .306 L
.75905 .34231 L
.75907 .33502 L
.75908 .27743 L
.75909 .28211 L
.75909 .33635 L
.7591 .26718 L
.75912 .31579 L
.75913 .29857 L
.75915 .32016 L
.75916 .31142 L
.75919 .29207 L
.7592 .26905 L
.75922 .30213 L
.75923 .29183 L
.75925 .25337 L
Mistroke
.75926 .29966 L
.75927 .3227 L
.75929 .28622 L
.7593 .25891 L
.75931 .30341 L
.75933 .30279 L
.75934 .30543 L
.75935 .30949 L
.75937 .32407 L
.75938 .31565 L
.75939 .27483 L
.75941 .27751 L
.75942 .26183 L
.75943 .29113 L
.75944 .30578 L
.75946 .26158 L
.75947 .26333 L
.75948 .35108 L
.7595 .27668 L
.75951 .31657 L
.75952 .29282 L
.75954 .25849 L
.75955 .27967 L
.75957 .29085 L
.75958 .28342 L
.75959 .31111 L
.7596 .31842 L
.75961 .29433 L
.75963 .27815 L
.75964 .29815 L
.75965 .26385 L
.75966 .3161 L
.75967 .31069 L
.75968 .30183 L
.75969 .26537 L
.7597 .29417 L
.75971 .28391 L
.75972 .30014 L
.75973 .29655 L
.75974 .32315 L
.75975 .31468 L
.75975 .32373 L
.75977 .29702 L
.75978 .28105 L
.7598 .31076 L
.75981 .32669 L
.75983 .30132 L
.75984 .32116 L
.75985 .30549 L
.75987 .25047 L
Mistroke
.75988 .27035 L
.7599 .31557 L
.75991 .28955 L
.75993 .28395 L
.75994 .30922 L
.75995 .28371 L
.75996 .28376 L
.75997 .23097 L
.75999 .31013 L
.76 .25937 L
.76001 .34393 L
.76003 .29049 L
.76004 .2521 L
.76006 .28441 L
.76006 .31921 L
.76007 .31723 L
.76009 .31623 L
.7601 .32386 L
.76012 .33231 L
.76013 .30578 L
.76014 .30515 L
.76015 .29643 L
.76016 .31175 L
.76017 .32616 L
.76018 .27674 L
.76018 .23763 L
.7602 .28604 L
.76021 .28748 L
.76023 .26353 L
.76024 .29881 L
.76026 .25465 L
.76027 .23447 L
.76027 .2851 L
.76029 .27049 L
.76031 .29544 L
.76032 .31193 L
.76034 .27502 L
.76035 .32101 L
.76036 .31554 L
.76038 .27703 L
.76039 .28256 L
.76041 .30731 L
.76042 .3064 L
.76043 .29953 L
.76045 .27537 L
.76046 .30484 L
.76048 .27738 L
.76049 .2782 L
.7605 .31711 L
.76051 .33133 L
Mistroke
.76053 .25456 L
.76054 .30212 L
.76055 .29967 L
.76057 .33061 L
.76058 .31229 L
.76059 .25985 L
.76061 .28994 L
.76062 .26096 L
.76063 .30536 L
.76065 .28972 L
.76066 .29937 L
.76067 .28355 L
.76069 .29248 L
.7607 .28923 L
.76071 .26618 L
.76073 .28474 L
.76074 .30262 L
.76074 .30223 L
.76076 .27582 L
.76077 .30004 L
.76079 .30506 L
.7608 .26889 L
.76082 .30262 L
.76083 .29006 L
.76085 .29557 L
.76086 .3296 L
.76086 .30808 L
.76088 .26514 L
.76089 .26233 L
.76091 .30277 L
.76092 .30726 L
.76094 .34916 L
.76095 .29459 L
.76096 .30414 L
.76098 .26531 L
.76099 .29919 L
.761 .29966 L
.76102 .2876 L
.76103 .29559 L
.76104 .32385 L
.76105 .29464 L
.76107 .28447 L
.76108 .30207 L
.7611 .2271 L
.76111 .25053 L
.76112 .27573 L
.76113 .27905 L
.76114 .32166 L
.76115 .30227 L
.76116 .31324 L
Mistroke
.76117 .31677 L
.76118 .32753 L
.76119 .34308 L
.76121 .28458 L
.76122 .29586 L
.76123 .28219 L
.76124 .2824 L
.76125 .29268 L
.76127 .29901 L
.76128 .32796 L
.7613 .27297 L
.76131 .28628 L
.76132 .33236 L
.76133 .33076 L
.76135 .28757 L
.76136 .31527 L
.76137 .27858 L
.76139 .30012 L
.7614 .27709 L
.76141 .31641 L
.76143 .29135 L
.76144 .29954 L
.76146 .27549 L
.76147 .30761 L
.76148 .31877 L
.76149 .31501 L
.7615 .30809 L
.76153 .29484 L
.76154 .29721 L
.76155 .27923 L
.76156 .25874 L
.76157 .28391 L
.76158 .31494 L
.76159 .28895 L
.7616 .32964 L
.76161 .28419 L
.76163 .29058 L
.76164 .33078 L
.76166 .33364 L
.76166 .25691 L
.76167 .29532 L
.76169 .29408 L
.7617 .31275 L
.76172 .31651 L
.76173 .33844 L
.76175 .29815 L
.76176 .28365 L
.76177 .32811 L
.76179 .30445 L
.7618 .29574 L
Mistroke
.76181 .28191 L
.76182 .2936 L
.76183 .28275 L
.76185 .28835 L
.76186 .30307 L
.76187 .2805 L
.76189 .29642 L
.7619 .27096 L
.76192 .30522 L
.76193 .31112 L
.76194 .33847 L
.76196 .27674 L
.76197 .34836 L
.76197 .30796 L
.76199 .28093 L
.762 .28638 L
.76201 .29082 L
.76202 .29602 L
.76204 .285 L
.76204 .31091 L
.76205 .28295 L
.76206 .32614 L
.76207 .27962 L
.76209 .29324 L
.76209 .3438 L
.7621 .27036 L
.76212 .32604 L
.76213 .31472 L
.76215 .27773 L
.76216 .32712 L
.76218 .32501 L
.76219 .29974 L
.7622 .28546 L
.76221 .32099 L
.76222 .29476 L
.76224 .34552 L
.76225 .31421 L
.76225 .29536 L
.76227 .29517 L
.76228 .24903 L
.7623 .27014 L
.76231 .2932 L
.76232 .33152 L
.76233 .26031 L
.76234 .29132 L
.76235 .29512 L
.76236 .31316 L
.76238 .29167 L
.76238 .30212 L
.76239 .32094 L
Mistroke
.76241 .31775 L
.76242 .25526 L
.76243 .28176 L
.76244 .29768 L
.76244 .31784 L
.76246 .31415 L
.76247 .34699 L
.76249 .32138 L
.7625 .2976 L
.76252 .30139 L
.76253 .26429 L
.76255 .29548 L
.76256 .26749 L
.76257 .33736 L
.76258 .30955 L
.76259 .29901 L
.7626 .27619 L
.76261 .30911 L
.76262 .30039 L
.76262 .28789 L
.76263 .31899 L
.76264 .30046 L
.76266 .3112 L
.76267 .32508 L
.76269 .23644 L
.7627 .23736 L
.76272 .27245 L
.76273 .309 L
.76274 .24887 L
.76276 .34984 L
.76277 .34046 L
.76277 .26183 L
.76279 .33656 L
.7628 .31908 L
.76282 .31558 L
.76283 .31329 L
.76284 .24641 L
.76286 .29639 L
.76287 .31336 L
.76288 .27721 L
.7629 .28707 L
.76291 .26014 L
.76293 .28779 L
.76294 .28971 L
.76294 .31464 L
.76296 .28068 L
.76297 .29784 L
.76298 .29972 L
.76299 .31646 L
.76301 .28107 L
Mistroke
.76301 .26748 L
.76302 .30484 L
.76303 .30597 L
.76304 .26798 L
.76305 .27927 L
.76307 .30687 L
.76308 .33112 L
.7631 .29623 L
.76311 .29549 L
.76311 .30304 L
.76313 .2368 L
.76314 .28977 L
.76315 .30532 L
.76316 .31267 L
.76317 .33206 L
.76319 .27989 L
.7632 .26187 L
.76322 .33365 L
.76323 .29404 L
.76324 .29202 L
.76325 .29773 L
.76327 .2926 L
.76328 .26576 L
.76329 .30529 L
.76331 .27273 L
.76332 .25286 L
.76333 .32353 L
.76335 .35144 L
.76336 .27302 L
.76338 .3106 L
.76339 .30869 L
.7634 .33462 L
.76341 .29798 L
.76342 .29732 L
.76344 .27243 L
.76345 .29454 L
.76347 .28797 L
.76348 .28518 L
.76349 .29713 L
.76349 .30005 L
.7635 .3317 L
.76351 .27897 L
.76352 .29779 L
.76353 .29782 L
.76355 .30997 L
.76356 .30841 L
.76358 .26033 L
.76359 .33863 L
.7636 .28471 L
.76361 .31339 L
Mistroke
.76362 .30688 L
.76364 .3033 L
.76365 .28532 L
.76367 .33472 L
.76369 .29344 L
.7637 .30778 L
.76371 .27704 L
.76373 .30778 L
.76374 .28341 L
.76375 .29764 L
.76377 .30061 L
.76378 .33649 L
.7638 .3187 L
.76381 .29866 L
.76383 .27863 L
.76384 .29054 L
.76385 .29317 L
.76386 .34118 L
.76388 .31027 L
.76389 .31665 L
.7639 .28736 L
.76392 .31235 L
.76393 .28619 L
.76394 .31242 L
.76395 .29054 L
.76397 .3201 L
.76398 .28678 L
.76399 .31855 L
.76401 .28635 L
.76402 .31765 L
.76404 .31769 L
.76405 .2931 L
.76406 .30444 L
.76407 .30616 L
.76408 .26711 L
.7641 .27511 L
.76411 .28296 L
.76412 .29318 L
.76413 .33634 L
.76414 .34416 L
.76416 .30058 L
.76417 .27266 L
.76418 .30656 L
.76419 .28146 L
.76421 .27108 L
.76422 .31904 L
.76423 .31692 L
.76424 .29221 L
.76426 .33465 L
.76427 .33454 L
Mistroke
.76427 .2966 L
.76429 .31171 L
.7643 .26724 L
.76432 .28779 L
.76433 .2765 L
.76434 .3046 L
.76436 .27853 L
.76437 .28685 L
.76438 .31183 L
.7644 .28787 L
.76441 .29591 L
.76443 .25844 L
.76444 .27509 L
.76445 .29815 L
.76447 .28341 L
.76448 .3075 L
.76449 .29827 L
.76451 .32301 L
.76452 .29117 L
.76454 .279 L
.76455 .29517 L
.76457 .25883 L
.76458 .32639 L
.76459 .31872 L
.7646 .32589 L
.76461 .28997 L
.76463 .29059 L
.76464 .23103 L
.76465 .32133 L
.76466 .29049 L
.76467 .27004 L
.76469 .32904 L
.7647 .30448 L
.76472 .29392 L
.76473 .31218 L
.76474 .34036 L
.76476 .30668 L
.76477 .34078 L
.76479 .2783 L
.7648 .31949 L
.76482 .31545 L
.76483 .29299 L
.76484 .27094 L
.76486 .2995 L
.76487 .29721 L
.76488 .30893 L
.76489 .28574 L
.7649 .34027 L
.76491 .25737 L
.76492 .27892 L
Mistroke
.76493 .30739 L
.76494 .31682 L
.76495 .30263 L
.76497 .29293 L
.76498 .33548 L
.76499 .32721 L
.765 .28843 L
.765 .30467 L
.76501 .28322 L
.76502 .32503 L
.76504 .32768 L
.76505 .26763 L
.76507 .31733 L
.76508 .33566 L
.76509 .29541 L
.76511 .31834 L
.76512 .29838 L
.76512 .29836 L
.76514 .28281 L
.76515 .34027 L
.76517 .27077 L
.76518 .27919 L
.76519 .30729 L
.76521 .33437 L
.76522 .31472 L
.76524 .31866 L
.76525 .30587 L
.76526 .29424 L
.76528 .28869 L
.76529 .2833 L
.76529 .24429 L
.76531 .25648 L
.76532 .29002 L
.76533 .30374 L
.76534 .36033 L
.76536 .30914 L
.76536 .32172 L
.76537 .29356 L
.76538 .29126 L
.76539 .22923 L
.76541 .29775 L
.76542 .27686 L
.76543 .26709 L
.76545 .26332 L
.76546 .28743 L
.76548 .26119 L
.76549 .25949 L
.76549 .26054 L
.76551 .34198 L
.76552 .31741 L
Mistroke
.76553 .34306 L
.76554 .29926 L
.76556 .28124 L
.76557 .29569 L
.76557 .29761 L
.76559 .29485 L
.7656 .34754 L
.76562 .24144 L
.76563 .31301 L
.76565 .26487 L
.76566 .30187 L
.76567 .26672 L
.76568 .32488 L
.76569 .22804 L
.7657 .34688 L
.7657 .28838 L
.76571 .26665 L
.76573 .29686 L
.76574 .28979 L
.76575 .32552 L
.76576 .32621 L
.76576 .29041 L
.76577 .27857 L
.76578 .26516 L
.7658 .30741 L
.76581 .33079 L
.76583 .32774 L
.76584 .29902 L
.76585 .26173 L
.76586 .26898 L
.76586 .29907 L
.76587 .33403 L
.76588 .31048 L
.76589 .30244 L
.7659 .26006 L
.76592 .25932 L
.76593 .27654 L
.76595 .31713 L
.76596 .33447 L
.76597 .28751 L
.76598 .3146 L
.76599 .25539 L
.76601 .29504 L
.76602 .30303 L
.76603 .28823 L
.76604 .34591 L
.76605 .29609 L
.76607 .27523 L
.76608 .31827 L
.76609 .28541 L
Mistroke
.76611 .30752 L
.76612 .24437 L
.76614 .32218 L
.76615 .3453 L
.76615 .34664 L
.76617 .30913 L
.76618 .29334 L
.76618 .24205 L
.7662 .32804 L
.76621 .30516 L
.76623 .2855 L
.76624 .29926 L
.76626 .30273 L
.76627 .29267 L
.76628 .26367 L
.76629 .27335 L
.76631 .31326 L
.76632 .29499 L
.76634 .28191 L
.76635 .27892 L
.76636 .33121 L
.76638 .3042 L
.76639 .30162 L
.76641 .27635 L
.76642 .2733 L
.76644 .31517 L
.76645 .30025 L
.76646 .27496 L
.76647 .2804 L
.76648 .29137 L
.76649 .3024 L
.76651 .32258 L
.76652 .32845 L
.76653 .28305 L
.76654 .30007 L
.76656 .25342 L
.76656 .2874 L
.76657 .27349 L
.76659 .31093 L
.7666 .31611 L
.76662 .28496 L
.76663 .32733 L
.76665 .29906 L
.76666 .28649 L
.76667 .30074 L
.76668 .28091 L
.7667 .29765 L
.76671 .3174 L
.76673 .29468 L
.76674 .32183 L
Mistroke
.76675 .29907 L
.76676 .2466 L
.76678 .28607 L
.76679 .28134 L
.7668 .26929 L
.76682 .28736 L
.76683 .35241 L
.76684 .30097 L
.76685 .27471 L
.76686 .31819 L
.76687 .2949 L
.76688 .29888 L
.76689 .31355 L
.7669 .28941 L
.7669 .33291 L
.76691 .3069 L
.76692 .30367 L
.76694 .35066 L
.76695 .32315 L
.76697 .29534 L
.76697 .30188 L
.76698 .281 L
.767 .28822 L
.76701 .27097 L
.76702 .32492 L
.76704 .24059 L
.76705 .31576 L
.76706 .29763 L
.76708 .27122 L
.76709 .32329 L
.7671 .31492 L
.76711 .33492 L
.76712 .33355 L
.76713 .31331 L
.76714 .28265 L
.76716 .24546 L
.76717 .28687 L
.76719 .28608 L
.7672 .26928 L
.76721 .31956 L
.76723 .26586 L
.76724 .24217 L
.76725 .32787 L
.76727 .26486 L
.76728 .34858 L
.76729 .31263 L
.76731 .32509 L
.76732 .30907 L
.76735 .28331 L
.76736 .27131 L
Mistroke
.76738 .25855 L
.76739 .27692 L
.76741 .28255 L
.76742 .33381 L
.76743 .30086 L
.76744 .2765 L
.76745 .28407 L
.76747 .29925 L
.76748 .33007 L
.76749 .33177 L
.76751 .30968 L
.76752 .30024 L
.76754 .3068 L
.76755 .30868 L
.76755 .29698 L
.76757 .28034 L
.76758 .31291 L
.76758 .30861 L
.7676 .32601 L
.76761 .30771 L
.76763 .30629 L
.76764 .33237 L
.76766 .33328 L
.76767 .31797 L
.76768 .30303 L
.76769 .32193 L
.76771 .28981 L
.76772 .30493 L
.76774 .28821 L
.76775 .28621 L
.76777 .27112 L
.76778 .30099 L
.76779 .34856 L
.76781 .32381 L
.76782 .31032 L
.76784 .32143 L
.76785 .2991 L
.76786 .26502 L
.76788 .32214 L
.76789 .31821 L
.7679 .27629 L
.76792 .33087 L
.76793 .32111 L
.76795 .34726 L
.76796 .25582 L
.76797 .29432 L
.76798 .27971 L
.76799 .35483 L
.76801 .29925 L
.76802 .29273 L
Mistroke
.76803 .31216 L
.76805 .30049 L
.76806 .347 L
.76807 .29727 L
.76809 .29113 L
.7681 .28336 L
.76812 .30362 L
.76813 .29392 L
.76814 .30732 L
.76815 .27557 L
.76816 .31624 L
.76817 .31066 L
.76817 .321 L
.76818 .27677 L
.7682 .26837 L
.76821 .25214 L
.76822 .2841 L
.76823 .28916 L
.76825 .32381 L
.76826 .32547 L
.76827 .2816 L
.76829 .29818 L
.7683 .31476 L
.76831 .36008 L
.76832 .34757 L
.76833 .31741 L
.76835 .31376 L
.76836 .31336 L
.76838 .33303 L
.76839 .2497 L
.76841 .2921 L
.76841 .24591 L
.76842 .30651 L
.76844 .30031 L
.76845 .25951 L
.76846 .31627 L
.76847 .27558 L
.76848 .30868 L
.76849 .3442 L
.7685 .28624 L
.76851 .30645 L
.76852 .30799 L
.76853 .31957 L
.76854 .27917 L
.76856 .24661 L
.76858 .33788 L
.76859 .28744 L
.7686 .32386 L
.76862 .2386 L
.76863 .27358 L
Mistroke
.76864 .29003 L
.76866 .2939 L
.76867 .30186 L
.76868 .25157 L
.7687 .28056 L
.76871 .31422 L
.76872 .29032 L
.76874 .31398 L
.76875 .28953 L
.76876 .24571 L
.76877 .34122 L
.76878 .31235 L
.7688 .3414 L
.76881 .32365 L
.76882 .3146 L
.76883 .3102 L
.76884 .35669 L
.76886 .34915 L
.76887 .30215 L
.76888 .27289 L
.7689 .33462 L
.76891 .30664 L
.76893 .28613 L
.76893 .34336 L
.76894 .31301 L
.76896 .27537 L
.76897 .26424 L
.76897 .2996 L
.76899 .32261 L
.769 .31701 L
.76902 .30864 L
.76903 .27484 L
.76905 .32207 L
.76906 .33178 L
.76907 .29822 L
.76908 .33634 L
.7691 .26633 L
.76911 .25046 L
.76913 .2402 L
.76914 .34189 L
.76915 .28987 L
.76917 .31514 L
.76918 .31378 L
.76919 .29623 L
.76921 .26588 L
.76922 .33136 L
.76924 .25532 L
.76925 .34696 L
.76927 .26499 L
.76928 .34577 L
Mistroke
.76929 .30073 L
.7693 .30061 L
.76931 .29047 L
.76932 .33246 L
.76933 .27598 L
.76934 .29464 L
.76936 .28792 L
.76938 .30644 L
.76939 .33363 L
.7694 .32995 L
.76942 .27934 L
.76943 .25192 L
.76944 .2823 L
.76946 .27584 L
.76947 .31647 L
.76949 .27821 L
.7695 .26449 L
.76952 .31196 L
.76953 .27927 L
.76955 .31129 L
.76956 .33349 L
.76957 .32588 L
.76958 .29797 L
.76959 .32884 L
.7696 .29063 L
.76961 .27565 L
.76962 .29417 L
.76963 .34172 L
.76964 .31566 L
.76965 .29702 L
.76966 .29206 L
.76967 .32051 L
.76968 .31376 L
.76968 .26652 L
.76969 .34111 L
.7697 .3015 L
.76971 .32317 L
.76972 .26404 L
.76974 .30774 L
.76975 .3099 L
.76977 .25637 L
.76978 .28022 L
.7698 .26679 L
.76981 .29081 L
.76982 .32901 L
.76984 .29226 L
.76985 .35077 L
.76987 .30245 L
.76988 .28823 L
.7699 .32614 L
Mistroke
.76991 .33342 L
.76993 .31043 L
.76993 .25171 L
.76994 .29351 L
.76996 .27165 L
.76997 .31348 L
.76999 .31154 L
.77 .39762 L
.77001 .27742 L
.77003 .3044 L
.77004 .3003 L
.77005 .30168 L
.77007 .29697 L
.77008 .33163 L
.77009 .31425 L
.77011 .32263 L
.77012 .31964 L
.77013 .33305 L
.77015 .31142 L
.77016 .30056 L
.77016 .29502 L
.77018 .30517 L
.77019 .30539 L
.77021 .33358 L
.77022 .29084 L
.77024 .31311 L
.77025 .34111 L
.77027 .32074 L
.77028 .30032 L
.77029 .3243 L
.77031 .28678 L
.77032 .32008 L
.77034 .26657 L
.77035 .31752 L
.77037 .33716 L
.77038 .28158 L
.77039 .3011 L
.7704 .32062 L
.77041 .27403 L
.77043 .31538 L
.77044 .28317 L
.77045 .31943 L
.77047 .30581 L
.77048 .29413 L
.7705 .31787 L
.77051 .31236 L
.77052 .32079 L
.77053 .2779 L
.77055 .30083 L
.77056 .32099 L
Mistroke
.77058 .28297 L
.77059 .29879 L
.7706 .35915 L
.77061 .30401 L
.77062 .33352 L
.77063 .34601 L
.77065 .30802 L
.77066 .28437 L
.77067 .26878 L
.77068 .33823 L
.77069 .24779 L
.77071 .27091 L
.77072 .27874 L
.77073 .31002 L
.77075 .30427 L
.77076 .27887 L
.77078 .32692 L
.77079 .30411 L
.77079 .29609 L
.77081 .27054 L
.77082 .31262 L
.77083 .35666 L
.77084 .29641 L
.77086 .30345 L
.77087 .25814 L
.77088 .31372 L
.7709 .29463 L
.77091 .38495 L
.77093 .3131 L
.77094 .28962 L
.77095 .32204 L
.77097 .30169 L
.77098 .3218 L
.771 .28232 L
.77101 .32585 L
.77103 .28477 L
.77104 .28555 L
.77105 .36114 L
.77106 .26009 L
.77108 .35749 L
.77109 .29152 L
.7711 .33228 L
.77112 .26127 L
.77113 .30437 L
.77114 .30876 L
.77115 .31257 L
.77116 .31253 L
.77117 .28123 L
.77118 .30535 L
.7712 .3249 L
Mistroke
.77121 .28212 L
.77123 .33676 L
.77124 .31912 L
.77125 .31334 L
.77127 .32431 L
.77128 .29701 L
.77129 .32051 L
.77131 .30373 L
.77132 .32418 L
.77134 .32009 L
.77135 .32572 L
.77137 .29573 L
.77138 .31874 L
.77139 .31031 L
.7714 .31836 L
.77142 .32686 L
.77143 .30205 L
.77145 .3247 L
.77146 .28472 L
.77148 .29019 L
.77148 .30158 L
.77149 .27341 L
.77151 .27098 L
.77152 .31368 L
.77153 .29314 L
.77154 .33186 L
.77155 .3017 L
.77156 .28258 L
.77157 .29608 L
.77158 .30032 L
.77159 .27844 L
.7716 .32641 L
.77162 .29769 L
.77163 .32465 L
.77165 .31276 L
.77166 .29772 L
.77167 .25713 L
.77169 .31308 L
.7717 .31791 L
.77171 .2647 L
.77172 .32437 L
.77173 .28667 L
.77174 .3056 L
.77175 .34292 L
.77176 .29555 L
.77177 .29003 L
.77178 .28062 L
.7718 .31848 L
.77181 .33734 L
.77183 .34215 L
Mistroke
.77184 .31407 L
.77185 .33927 L
.77186 .30272 L
.77187 .34712 L
.77188 .27225 L
.77189 .30957 L
.7719 .27636 L
.77192 .31202 L
.77193 .33255 L
.77195 .29755 L
.77196 .30569 L
.77197 .28896 L
.77197 .27927 L
.77198 .24967 L
.772 .29947 L
.77201 .2694 L
.77202 .27277 L
.77203 .33276 L
.77204 .27214 L
.77205 .30882 L
.77206 .29623 L
.77208 .27561 L
.7721 .25794 L
.7721 .28737 L
.77211 .31344 L
.77213 .31796 L
.77214 .29162 L
.77215 .29154 L
.77217 .30594 L
.77218 .3654 L
.7722 .30875 L
.77221 .31976 L
.77222 .30598 L
.77223 .27559 L
.77224 .28564 L
.77225 .31238 L
.77226 .32637 L
.77227 .29194 L
.77229 .31469 L
.77231 .28577 L
.77232 .31227 L
.77233 .36651 L
.77235 .30395 L
.77236 .33472 L
.77237 .33484 L
.77238 .29019 L
.7724 .34546 L
.77241 .28917 L
.77243 .29299 L
.77244 .29488 L
Mistroke
.77245 .29313 L
.77247 .2753 L
.77248 .26463 L
.7725 .28261 L
.77251 .28806 L
.77253 .2882 L
.77254 .26742 L
.77255 .31865 L
.77257 .31994 L
.77258 .30439 L
.7726 .33765 L
.77261 .33039 L
.77262 .25715 L
.77264 .29732 L
.77265 .32271 L
.77266 .28068 L
.77267 .26241 L
.77268 .31061 L
.77269 .2778 L
.7727 .27712 L
.77271 .31363 L
.77272 .30992 L
.77273 .22391 L
.77275 .29238 L
.77275 .29954 L
.77276 .33789 L
.77278 .34901 L
.77278 .33278 L
.77279 .30249 L
.7728 .26959 L
.77281 .26184 L
.77283 .34241 L
.77284 .31878 L
.77285 .32466 L
.77286 .29441 L
.77287 .33758 L
.77288 .3168 L
.77289 .31377 L
.7729 .35686 L
.77291 .28282 L
.77292 .26986 L
.77293 .33388 L
.77294 .28654 L
.77295 .29404 L
.77296 .34165 L
.77297 .29343 L
.77298 .31746 L
.773 .3303 L
.77301 .33084 L
.77303 .31941 L
Mistroke
.77306 .3319 L
.77307 .34003 L
.77308 .3293 L
.77309 .25972 L
.7731 .29615 L
.77311 .28708 L
.77312 .34419 L
.77312 .30047 L
.77314 .34282 L
.77315 .31093 L
.77316 .29969 L
.77317 .29522 L
.77319 .29293 L
.7732 .29122 L
.77321 .23757 L
.77323 .2907 L
.77324 .30183 L
.77325 .32981 L
.77326 .28751 L
.77327 .3244 L
.77329 .28583 L
.7733 .33738 L
.77332 .32762 L
.77333 .31746 L
.77334 .29952 L
.77336 .32755 L
.77337 .31871 L
.77338 .33042 L
.7734 .27818 L
.77341 .30597 L
.77342 .28064 L
.77344 .29964 L
.77345 .31532 L
.77346 .31656 L
.77347 .35326 L
.77348 .2888 L
.7735 .31235 L
.77351 .33265 L
.77353 .31025 L
.77354 .33938 L
.77355 .33157 L
.77357 .34123 L
.77358 .30509 L
.77359 .28169 L
.7736 .30233 L
.77362 .30232 L
.77363 .30188 L
.77365 .31605 L
.77365 .30896 L
.77366 .32054 L
Mistroke
.77368 .31456 L
.77369 .29705 L
.77371 .31011 L
.77372 .33762 L
.77373 .30997 L
.77374 .31436 L
.77375 .34925 L
.77377 .26336 L
.77378 .28934 L
.77379 .23372 L
.77381 .29388 L
.77382 .30965 L
.77384 .30803 L
.77385 .27894 L
.77387 .2759 L
.77388 .33587 L
.77389 .332 L
.77391 .30565 L
.77392 .33138 L
.77394 .30337 L
.77395 .33906 L
.77396 .2785 L
.77398 .30242 L
.77399 .3102 L
.774 .27242 L
.77402 .26699 L
.77403 .32879 L
.77405 .3409 L
.77406 .26903 L
.77408 .33786 L
.77409 .26942 L
.7741 .3014 L
.77411 .28875 L
.77412 .27429 L
.77413 .34822 L
.77414 .30207 L
.77415 .32213 L
.77417 .28455 L
.77418 .28912 L
.77418 .29055 L
.77419 .3211 L
.7742 .30994 L
.77422 .35647 L
.77423 .28061 L
.77424 .2706 L
.77425 .29563 L
.77426 .3169 L
.77426 .26591 L
.77427 .30033 L
.77428 .29923 L
Mistroke
.7743 .2962 L
.77431 .3439 L
.77431 .31176 L
.77432 .32316 L
.77433 .30213 L
.77435 .30302 L
.77436 .26797 L
.77436 .30946 L
.77438 .34565 L
.77439 .33835 L
.7744 .36291 L
.77441 .30825 L
.77443 .33014 L
.77444 .32655 L
.77445 .29047 L
.77447 .33028 L
.77448 .33561 L
.7745 .28612 L
.77451 .28282 L
.77452 .33476 L
.77453 .27219 L
.77454 .31743 L
.77456 .30643 L
.77457 .32985 L
.77458 .32124 L
.7746 .29872 L
.77461 .26286 L
.77462 .29477 L
.77464 .26755 L
.77465 .28755 L
.77467 .32552 L
.77468 .29008 L
.77469 .28439 L
.7747 .30356 L
.77471 .30932 L
.77473 .3308 L
.77474 .3188 L
.77475 .31065 L
.77476 .27803 L
.77477 .31555 L
.77478 .32943 L
.77479 .35514 L
.7748 .30538 L
.77481 .29773 L
.77482 .31293 L
.77483 .30153 L
.77484 .29108 L
.77485 .30037 L
.77487 .26738 L
.77488 .29474 L
Mistroke
.7749 .3014 L
.77491 .34374 L
.77493 .26061 L
.77493 .29373 L
.77494 .33944 L
.77496 .28522 L
.77497 .29713 L
.77498 .26706 L
.77499 .29194 L
.775 .30636 L
.77502 .29537 L
.77503 .29109 L
.77505 .27761 L
.77506 .33211 L
.77507 .3029 L
.77508 .3324 L
.77509 .34497 L
.7751 .33311 L
.77511 .31818 L
.77512 .33042 L
.77512 .28526 L
.77513 .27297 L
.77514 .33425 L
.77515 .31974 L
.77516 .32005 L
.77517 .28972 L
.77518 .32251 L
.7752 .30843 L
.7752 .29817 L
.77521 .31594 L
.77523 .32947 L
.77524 .31572 L
.77525 .28397 L
.77527 .29568 L
.77528 .32291 L
.7753 .28709 L
.77531 .25726 L
.77531 .29861 L
.77532 .30215 L
.77533 .3292 L
.77535 .30575 L
.77535 .30287 L
.77536 .339 L
.77538 .32053 L
.77539 .33619 L
.77541 .30666 L
.77542 .32277 L
.77544 .30989 L
.77544 .28443 L
.77545 .33685 L
Mistroke
.77547 .35661 L
.77548 .35903 L
.7755 .36718 L
.77551 .31682 L
.77552 .29598 L
.77554 .33482 L
.77555 .30757 L
.77556 .34212 L
.77557 .3339 L
.77558 .25579 L
.77559 .32814 L
.7756 .29982 L
.77561 .33199 L
.77563 .33508 L
.77564 .28837 L
.77566 .29463 L
.77567 .29271 L
.77569 .29746 L
.7757 .31284 L
.77571 .33289 L
.77572 .32484 L
.77574 .30029 L
.77575 .30918 L
.77577 .30887 L
.77578 .30337 L
.77579 .33281 L
.77581 .28006 L
.77582 .29672 L
.77584 .34176 L
.77585 .33597 L
.77586 .3444 L
.77588 .29257 L
.77589 .31539 L
.77589 .26813 L
.77591 .31874 L
.77593 .33061 L
.77593 .28927 L
.77594 .32244 L
.77596 .29284 L
.77597 .3284 L
.77598 .30769 L
.77599 .32619 L
.776 .31138 L
.77602 .32577 L
.77603 .29299 L
.77605 .31648 L
.77606 .2865 L
.77607 .24758 L
.77609 .33108 L
.7761 .26937 L
Mistroke
.77611 .30581 L
.77613 .29235 L
.77614 .36594 L
.77615 .29287 L
.77616 .29652 L
.77618 .3073 L
.77619 .28133 L
.77621 .33686 L
.77622 .2963 L
.77623 .32711 L
.77624 .31428 L
.77625 .31952 L
.77627 .32824 L
.77628 .2813 L
.77628 .30671 L
.77629 .29097 L
.7763 .30415 L
.77631 .29079 L
.77632 .28882 L
.77633 .28945 L
.77634 .32663 L
.77635 .2734 L
.77637 .26845 L
.77638 .34973 L
.77639 .29384 L
.7764 .31218 L
.77641 .31233 L
.77643 .29106 L
.77644 .30261 L
.77645 .30219 L
.77647 .25718 L
.77648 .29132 L
.77649 .30492 L
.7765 .32254 L
.77651 .31802 L
.77652 .31256 L
.77653 .2826 L
.77654 .3025 L
.77656 .30146 L
.77657 .28363 L
.77659 .30365 L
.7766 .31767 L
.77661 .32683 L
.77663 .28989 L
.77664 .31908 L
.77665 .28722 L
.77667 .34754 L
.77668 .33292 L
.7767 .29134 L
.77671 .28595 L
Mistroke
.77672 .32822 L
.77674 .31753 L
.77675 .32072 L
.77676 .28594 L
.77678 .30105 L
.77679 .345 L
.77681 .32135 L
.77682 .36646 L
.77684 .29947 L
.77685 .27881 L
.77686 .31586 L
.77687 .31643 L
.77688 .34077 L
.77689 .28546 L
.7769 .28979 L
.77691 .28092 L
.77693 .27972 L
.77695 .30479 L
.77696 .24251 L
.77697 .33257 L
.77699 .29867 L
.777 .29858 L
.77701 .28613 L
.77703 .30514 L
.77704 .25528 L
.77706 .30087 L
.77707 .31974 L
.77709 .27463 L
.7771 .29882 L
.77712 .3379 L
.77713 .31917 L
.77714 .36791 L
.77715 .29682 L
.77716 .30534 L
.77716 .34652 L
.77718 .27618 L
.77719 .27958 L
.7772 .29632 L
.77721 .29743 L
.77722 .31928 L
.77723 .27728 L
.77724 .30059 L
.77725 .30939 L
.77725 .32122 L
.77726 .33267 L
.77727 .30678 L
.77728 .27997 L
.77729 .30659 L
.77731 .29856 L
.77732 .27622 L
Mistroke
.77734 .3415 L
.77735 .34869 L
.77737 .28334 L
.77738 .30091 L
.77739 .31498 L
.77741 .31988 L
.77742 .29054 L
.77744 .34481 L
.77745 .3532 L
.77747 .26002 L
.77748 .30501 L
.7775 .23792 L
.7775 .28885 L
.77751 .32495 L
.77753 .32415 L
.77754 .31004 L
.77756 .29375 L
.77757 .26978 L
.77758 .29197 L
.7776 .27132 L
.77761 .27879 L
.77762 .29243 L
.77763 .31227 L
.77765 .34366 L
.77766 .34787 L
.77768 .33616 L
.77769 .36918 L
.7777 .31538 L
.77771 .33413 L
.77772 .3223 L
.77773 .2745 L
.77775 .26848 L
.77776 .3075 L
.77778 .29864 L
.77779 .31098 L
.77781 .30647 L
.77782 .29641 L
.77784 .32786 L
.77785 .33721 L
.77786 .28636 L
.77788 .29831 L
.77789 .30544 L
.77791 .33261 L
.77792 .37285 L
.77793 .30928 L
.77795 .33053 L
.77796 .31569 L
.77797 .29988 L
.77798 .29293 L
.778 .35667 L
Mistroke
.77801 .31393 L
.77802 .29547 L
.77804 .35416 L
.77805 .29097 L
.77807 .29569 L
.77808 .3253 L
.77809 .28283 L
.7781 .33178 L
.77812 .32056 L
.77813 .31639 L
.77815 .32512 L
.77816 .33396 L
.77817 .30793 L
.77818 .29218 L
.77819 .29647 L
.7782 .28051 L
.77822 .2959 L
.77825 .3181 L
.77826 .28559 L
.77828 .34702 L
.77829 .36292 L
.7783 .26619 L
.77832 .28719 L
.77833 .31111 L
.77835 .33392 L
.77836 .29521 L
.77837 .28464 L
.77838 .32371 L
.77839 .28711 L
.77839 .27416 L
.77841 .27722 L
.77842 .33245 L
.77844 .30192 L
.77845 .31756 L
.77847 .28392 L
.77848 .35322 L
.77849 .32468 L
.77851 .29368 L
.77852 .34652 L
.77853 .28482 L
.77855 .27585 L
.77856 .26831 L
.77857 .32527 L
.77859 .29053 L
.7786 .32043 L
.77861 .29702 L
.77863 .32946 L
.77864 .28873 L
.77864 .30042 L
.77866 .29789 L
Mistroke
.77867 .31719 L
.77869 .29536 L
.7787 .28669 L
.7787 .31084 L
.77872 .32473 L
.77873 .30551 L
.77875 .30256 L
.77876 .31244 L
.77877 .35576 L
.77879 .28826 L
.7788 .2817 L
.77881 .35141 L
.77882 .30223 L
.77883 .29392 L
.77884 .35349 L
.77885 .28974 L
.77887 .32106 L
.77888 .26444 L
.7789 .30126 L
.77891 .30412 L
.77892 .32054 L
.77894 .2906 L
.77895 .33117 L
.77896 .2986 L
.77898 .31685 L
.77899 .29775 L
.779 .3027 L
.77902 .28339 L
.77903 .27924 L
.77904 .29887 L
.77905 .28734 L
.77906 .2854 L
.77908 .30537 L
.77909 .32966 L
.7791 .3273 L
.77912 .29261 L
.77913 .34906 L
.77914 .30271 L
.77916 .33015 L
.77917 .30156 L
.77919 .27656 L
.7792 .3309 L
.77921 .30407 L
.77922 .34857 L
.77923 .28958 L
.77925 .30692 L
.77926 .30913 L
.77927 .38296 L
.77929 .31902 L
.7793 .29454 L
Mistroke
.77931 .31285 L
.77933 .29668 L
.77934 .2906 L
.77936 .28899 L
.77937 .28309 L
.77939 .28962 L
.7794 .33621 L
.77941 .3018 L
.77942 .29641 L
.77943 .30292 L
.77944 .30646 L
.77945 .28369 L
.77946 .3337 L
.77948 .28474 L
.77948 .31377 L
.77949 .26716 L
.77951 .29877 L
.77952 .32432 L
.77952 .3315 L
.77953 .32281 L
.77954 .2863 L
.77955 .37417 L
.77956 .34299 L
.77957 .33743 L
.77959 .30576 L
.7796 .30015 L
.77962 .31277 L
.77963 .33238 L
.77965 .2725 L
.77966 .27672 L
.77967 .31565 L
.77968 .28711 L
.77969 .34566 L
.77971 .31729 L
.77972 .28199 L
.77973 .27046 L
.77975 .3159 L
.77976 .27901 L
.77977 .31275 L
.77979 .3518 L
.7798 .34846 L
.77982 .28188 L
.77983 .36261 L
.77984 .31668 L
.77985 .26051 L
.77986 .32341 L
.77988 .33112 L
.77989 .31284 L
.7799 .33747 L
.77991 .26225 L
Mistroke
.77992 .32236 L
.77993 .28756 L
.77994 .28469 L
.77995 .35073 L
.77996 .3172 L
.77997 .28543 L
.77998 .32656 L
.77999 .28427 L
.78 .30674 L
.78002 .28074 L
.78003 .31591 L
.78005 .34118 L
.78006 .30415 L
.78008 .38297 L
.78009 .31256 L
.7801 .2586 L
.78011 .28208 L
.78012 .29639 L
.78014 .29518 L
.78014 .25963 L
.78015 .27003 L
.78016 .30034 L
.78017 .27651 L
.78019 .3206 L
.78019 .29463 L
.7802 .26678 L
.78022 .34598 L
.78023 .32237 L
.78025 .2869 L
.78025 .31484 L
.78026 .26938 L
.78028 .29861 L
.78029 .34474 L
.78031 .33184 L
.78032 .28547 L
.78033 .32844 L
.78035 .32314 L
.78036 .329 L
.78038 .2962 L
.78039 .31954 L
.7804 .29342 L
.78041 .29362 L
.78042 .32011 L
.78043 .32603 L
.78045 .3057 L
.78046 .33645 L
.78047 .3061 L
.78049 .31492 L
.7805 .31352 L
.78052 .31625 L
Mistroke
.78053 .27054 L
.78054 .29887 L
.78056 .31955 L
.78057 .28097 L
.78059 .31773 L
.7806 .29285 L
.78061 .30646 L
.78062 .3006 L
.78063 .3241 L
.78065 .32001 L
.78066 .34307 L
.78067 .29771 L
.78069 .29859 L
.7807 .30711 L
.78071 .31643 L
.78073 .30384 L
.78074 .30409 L
.78075 .31602 L
.78077 .26817 L
.78078 .29498 L
.78079 .29137 L
.7808 .28704 L
.78081 .27304 L
.78083 .33661 L
.78084 .32906 L
.78085 .26358 L
.78086 .33013 L
.78087 .24691 L
.78088 .29078 L
.78089 .30762 L
.78089 .32387 L
.78091 .3564 L
.78092 .34771 L
.78093 .3204 L
.78094 .28285 L
.78096 .29901 L
.78097 .35013 L
.78099 .32305 L
.781 .29826 L
.78102 .33902 L
.78102 .31881 L
.78103 .34559 L
.78105 .29424 L
.78106 .31772 L
.78107 .30883 L
.78108 .29613 L
.78109 .33042 L
.78111 .31934 L
.78112 .26984 L
.78114 .35708 L
Mistroke
.78114 .31162 L
.78115 .3106 L
.78116 .33049 L
.78117 .32532 L
.78118 .33919 L
.7812 .32581 L
.78121 .26075 L
.78122 .30283 L
.78123 .31788 L
.78124 .33143 L
.78125 .28317 L
.78126 .27975 L
.78127 .28738 L
.78133 .32475 L
.78134 .30129 L
.78135 .32085 L
.78135 .30575 L
.78136 .34882 L
.78137 .32735 L
.78138 .32302 L
.78139 .29744 L
.78141 .29723 L
.78142 .33125 L
.78143 .30244 L
.78144 .25557 L
.78145 .28182 L
.78147 .29415 L
.78148 .32367 L
.7815 .30594 L
.78151 .31139 L
.78152 .3203 L
.78154 .31834 L
.78156 .29256 L
.78157 .30719 L
.78158 .2924 L
.7816 .30604 L
.78161 .3197 L
.78162 .2583 L
.78163 .34854 L
.78164 .31971 L
.78166 .29844 L
.78167 .27834 L
.78168 .34253 L
.7817 .28665 L
.78171 .33118 L
.78173 .32692 L
.78174 .3229 L
.78176 .30018 L
.78177 .30085 L
.78177 .32391 L
Mistroke
.78179 .33792 L
.7818 .30865 L
.78181 .33148 L
.78182 .30982 L
.78183 .34631 L
.78184 .30883 L
.78185 .34444 L
.78186 .29525 L
.78187 .30139 L
.78189 .25515 L
.7819 .32145 L
.78191 .3177 L
.78193 .31507 L
.78194 .33043 L
.78195 .3067 L
.78196 .30326 L
.78198 .31589 L
.78199 .33266 L
.78201 .32009 L
.78201 .31334 L
.78202 .35315 L
.78204 .27463 L
.78205 .30021 L
.78206 .3141 L
.78208 .29044 L
.78209 .33426 L
.78211 .29484 L
.78212 .35647 L
.78213 .27049 L
.78214 .34214 L
.78215 .32374 L
.78216 .3324 L
.78217 .31245 L
.78218 .28922 L
.7822 .33936 L
.78221 .30444 L
.78223 .32067 L
.78224 .26845 L
.78225 .31196 L
.78227 .29307 L
.78228 .35778 L
.78229 .3221 L
.78231 .32535 L
.78232 .27809 L
.78234 .29221 L
.78235 .33923 L
.78236 .2817 L
.78238 .29375 L
.78239 .26409 L
.78241 .27654 L
Mistroke
.78242 .31514 L
.78243 .30288 L
.78245 .30963 L
.78246 .2958 L
.78248 .36427 L
.78249 .31745 L
.7825 .3209 L
.7825 .27696 L
.78251 .32463 L
.78253 .32583 L
.78254 .28853 L
.78255 .3202 L
.78256 .27439 L
.78257 .31367 L
.78259 .34506 L
.7826 .34344 L
.78262 .28164 L
.78263 .27564 L
.78264 .36509 L
.78266 .30895 L
.78267 .26926 L
.78268 .32406 L
.7827 .32025 L
.78271 .26848 L
.78272 .34271 L
.78273 .2848 L
.78275 .31276 L
.78276 .27571 L
.78278 .34326 L
.78279 .33771 L
.7828 .30591 L
.78281 .28713 L
.78282 .28887 L
.78284 .25801 L
.78285 .28388 L
.78285 .3043 L
.78286 .3222 L
.78287 .31676 L
.78288 .33802 L
.78289 .31554 L
.7829 .34218 L
.78291 .32344 L
.78292 .34918 L
.78294 .30876 L
.78295 .29168 L
.78296 .30128 L
.78297 .2918 L
.78298 .29433 L
.783 .34839 L
.78301 .31025 L
Mistroke
.78302 .34261 L
.78303 .32381 L
.78305 .33636 L
.78306 .29878 L
.78307 .30146 L
.78308 .31131 L
.7831 .2993 L
.78311 .31463 L
.78311 .29039 L
.78313 .37308 L
.78314 .31249 L
.78316 .27485 L
.78317 .32906 L
.78318 .32554 L
.7832 .31875 L
.78321 .31128 L
.78322 .30602 L
.78324 .30637 L
.78325 .27894 L
.78327 .33335 L
.78328 .33466 L
.78329 .34165 L
.78331 .32005 L
.78332 .31345 L
.78333 .28161 L
.78335 .39378 L
.78336 .29485 L
.78338 .3041 L
.78339 .2548 L
.78341 .34249 L
.78342 .28461 L
.78343 .3611 L
.78344 .32335 L
.78345 .2913 L
.78345 .31761 L
.78347 .33942 L
.78348 .33992 L
.7835 .29031 L
.78351 .28691 L
.78353 .31743 L
.78354 .31549 L
.78356 .32722 L
.78357 .32725 L
.78358 .30499 L
.7836 .33617 L
.78361 .27124 L
.78363 .27023 L
.78364 .3212 L
.78366 .32526 L
.78367 .34788 L
Mistroke
.78368 .32658 L
.7837 .30108 L
.78371 .3439 L
.78372 .28292 L
.78373 .31637 L
.78374 .28108 L
.78375 .29634 L
.78376 .25415 L
.78376 .32181 L
.78378 .3009 L
.78379 .31671 L
.7838 .32227 L
.78381 .29723 L
.78381 .30022 L
.78382 .32157 L
.78383 .30873 L
.78384 .28427 L
.78385 .34718 L
.78386 .31357 L
.78388 .30998 L
.78389 .31719 L
.78391 .30891 L
.78392 .31941 L
.78394 .35477 L
.78395 .30165 L
.78396 .29562 L
.78398 .34438 L
.78399 .2882 L
.784 .32831 L
.78401 .30586 L
.78402 .31023 L
.78402 .33797 L
.78404 .31342 L
.78405 .33419 L
.78407 .33557 L
.78408 .31468 L
.7841 .33814 L
.78411 .30807 L
.78413 .29754 L
.78414 .30665 L
.78415 .34099 L
.78417 .30334 L
.78418 .3107 L
.7842 .26603 L
.78421 .35084 L
.78423 .3249 L
.78424 .26142 L
.78425 .30833 L
.78427 .34316 L
.78428 .31886 L
Mistroke
.78429 .26699 L
.78431 .29903 L
.78432 .28781 L
.78433 .33274 L
.78435 .30568 L
.78436 .35755 L
.78438 .28082 L
.78439 .33694 L
.7844 .29625 L
.78442 .32778 L
.78443 .32082 L
.78444 .35107 L
.78446 .28179 L
.78448 .30788 L
.78449 .3271 L
.7845 .27776 L
.78452 .30115 L
.78453 .31903 L
.78454 .2863 L
.78455 .3379 L
.78457 .31336 L
.78458 .30514 L
.78459 .31689 L
.78461 .3076 L
.78462 .31115 L
.78463 .33593 L
.78465 .30887 L
.78466 .40074 L
.78467 .34475 L
.78469 .30803 L
.7847 .3361 L
.78471 .33877 L
.78473 .29328 L
.78474 .25997 L
.78475 .30754 L
.78476 .33119 L
.78477 .31274 L
.78479 .3183 L
.7848 .31777 L
.78481 .29129 L
.78482 .28148 L
.78483 .26778 L
.78485 .32261 L
.78486 .34243 L
.78487 .26034 L
.78489 .34457 L
.7849 .31765 L
.78491 .29302 L
.78492 .37851 L
.78493 .29528 L
Mistroke
.78495 .37144 L
.78496 .28702 L
.78496 .29519 L
.78498 .27079 L
.78499 .32552 L
.78501 .29462 L
.78502 .25635 L
.78503 .32197 L
.78505 .31138 L
.78506 .30124 L
.78507 .31283 L
.78509 .32593 L
.7851 .33498 L
.78512 .31517 L
.78513 .30969 L
.78514 .30296 L
.78516 .32659 L
.78517 .35625 L
.78518 .31665 L
.7852 .31585 L
.78521 .29363 L
.78523 .29036 L
.78524 .31524 L
.78526 .31682 L
.78527 .2599 L
.78528 .34042 L
.78529 .31001 L
.7853 .30933 L
.78531 .29036 L
.78532 .36004 L
.78533 .31539 L
.78535 .3395 L
.78536 .28074 L
.78538 .31733 L
.78539 .27595 L
.78541 .32514 L
.78542 .34401 L
.78543 .29911 L
.78545 .32436 L
.78546 .32003 L
.78548 .28074 L
.78549 .30579 L
.78551 .31867 L
.78552 .35144 L
.78553 .34088 L
.78554 .26371 L
.78555 .32355 L
.78556 .30421 L
.78557 .2944 L
.78558 .34414 L
Mistroke
.78558 .2933 L
.7856 .32679 L
.78561 .33949 L
.78562 .33268 L
.78563 .29921 L
.78565 .3188 L
.78566 .35868 L
.78567 .36361 L
.78568 .31963 L
.78569 .32826 L
.7857 .36335 L
.78571 .33123 L
.78572 .35974 L
.78573 .30997 L
.78574 .32244 L
.78576 .26132 L
.78577 .35282 L
.78579 .28958 L
.7858 .33067 L
.78581 .35793 L
.78583 .29935 L
.78584 .33332 L
.78586 .30014 L
.78587 .34428 L
.78588 .28987 L
.7859 .27578 L
.78591 .29471 L
.78593 .31391 L
.78595 .30481 L
.78596 .33968 L
.78598 .29947 L
.78599 .29492 L
.786 .31466 L
.78601 .34601 L
.78602 .32302 L
.78604 .34573 L
.78605 .31587 L
.78606 .31093 L
.78608 .29968 L
.78609 .38361 L
.7861 .32825 L
.78612 .31398 L
.78613 .32673 L
.78614 .32784 L
.78616 .33836 L
.78617 .28466 L
.78618 .31774 L
.7862 .3754 L
.78621 .30287 L
.78622 .36045 L
Mistroke
.78624 .28264 L
.78625 .36313 L
.78626 .31806 L
.78627 .25577 L
.78628 .29074 L
.7863 .2691 L
.78631 .32945 L
.78633 .37911 L
.78634 .282 L
.78635 .31139 L
.78636 .26961 L
.78638 .33024 L
.78639 .3261 L
.78641 .28274 L
.78642 .30621 L
.78643 .29607 L
.78644 .28787 L
.78645 .33816 L
.78647 .32144 L
.78648 .34623 L
.78648 .3064 L
.7865 .30653 L
.78651 .34473 L
.78652 .28496 L
.78652 .33592 L
.78653 .33815 L
.78655 .33137 L
.78656 .31706 L
.78657 .30822 L
.78658 .31321 L
.7866 .34605 L
.78661 .29797 L
.78662 .26738 L
.78664 .32833 L
.78665 .34923 L
.78667 .31055 L
.78668 .3215 L
.78669 .3296 L
.7867 .30802 L
.78671 .34367 L
.78672 .31751 L
.78673 .29369 L
.78675 .30592 L
.78676 .30789 L
.78678 .32496 L
.78678 .31867 L
.78679 .28702 L
.78681 .32321 L
.78682 .27933 L
.78683 .2972 L
Mistroke
.78684 .31103 L
.78685 .31728 L
.78685 .27264 L
.78686 .31979 L
.78687 .37076 L
.78688 .26151 L
.78689 .30746 L
.7869 .38557 L
.78691 .33026 L
.78692 .29484 L
.78693 .28887 L
.78694 .29098 L
.78696 .31509 L
.78697 .30482 L
.78698 .34069 L
.787 .31311 L
.78701 .30296 L
.78703 .31346 L
.78703 .28584 L
.78704 .36663 L
.78705 .36073 L
.78706 .32901 L
.78707 .30449 L
.78708 .29443 L
.78709 .35769 L
.78711 .31391 L
.78712 .32957 L
.78714 .33448 L
.78715 .36126 L
.78717 .33155 L
.78718 .27926 L
.78719 .28876 L
.78721 .32932 L
.78722 .28473 L
.78724 .3238 L
.78725 .31877 L
.78725 .3197 L
.78727 .28602 L
.78728 .30498 L
.7873 .33601 L
.78731 .35623 L
.78733 .31495 L
.78734 .28835 L
.78735 .2836 L
.78737 .31369 L
.78738 .31808 L
.78739 .31006 L
.78741 .34011 L
.78742 .30584 L
.78742 .27077 L
Mistroke
.78744 .3063 L
.78746 .35959 L
.78747 .31525 L
.78748 .29424 L
.7875 .31248 L
.78751 .348 L
.78752 .32337 L
.78753 .26964 L
.78754 .25225 L
.78755 .28716 L
.78756 .31267 L
.78756 .32239 L
.78758 .28202 L
.78759 .28595 L
.78761 .36675 L
.78762 .27841 L
.78763 .3064 L
.78764 .28288 L
.78765 .31444 L
.78767 .33485 L
.78769 .34505 L
.78769 .35216 L
.7877 .34255 L
.78772 .28138 L
.78773 .34493 L
.78775 .31953 L
.78776 .30644 L
.78777 .31489 L
.78779 .32592 L
.7878 .34127 L
.78781 .34614 L
.78783 .33646 L
.78784 .29802 L
.78786 .31258 L
.78787 .36156 L
.78789 .32635 L
.7879 .36467 L
.78791 .30921 L
.78792 .32952 L
.78793 .36252 L
.78795 .32522 L
.78796 .3189 L
.78798 .28751 L
.78798 .33071 L
.78799 .31933 L
.788 .33287 L
.78801 .31809 L
.78803 .30803 L
.78804 .27113 L
.78805 .31213 L
Mistroke
.78806 .31723 L
.78807 .33886 L
.78808 .25319 L
.78809 .28043 L
.7881 .29585 L
.78811 .329 L
.78812 .32267 L
.78813 .32629 L
.78814 .33903 L
.78815 .34737 L
.78817 .29793 L
.78818 .32557 L
.7882 .2817 L
.78821 .29857 L
.78822 .31154 L
.78824 .31673 L
.78825 .29681 L
.78826 .35496 L
.78827 .32139 L
.78828 .33012 L
.7883 .27119 L
.78831 .29436 L
.78831 .34242 L
.78833 .32057 L
.78834 .30535 L
.78836 .34154 L
.78837 .28668 L
.78838 .28604 L
.7884 .28116 L
.78841 .34513 L
.78842 .32724 L
.78843 .34336 L
.78845 .34384 L
.78846 .32289 L
.78847 .33874 L
.78848 .35087 L
.78849 .34279 L
.78851 .28064 L
.78852 .29183 L
.78854 .37033 L
.78855 .33607 L
.78856 .32121 L
.78858 .31793 L
.78859 .3126 L
.78859 .31159 L
.78861 .31046 L
.78862 .2866 L
.78863 .27703 L
.78864 .33597 L
.78866 .26732 L
Mistroke
.78867 .31232 L
.78869 .31502 L
.78869 .30432 L
.7887 .27746 L
.78871 .3641 L
.78872 .2979 L
.78873 .31755 L
.78875 .31809 L
.78876 .3147 L
.78877 .31955 L
.78878 .30641 L
.78879 .31544 L
.7888 .28708 L
.78881 .36284 L
.78882 .31594 L
.78883 .3331 L
.78885 .33719 L
.78886 .30332 L
.78887 .28724 L
.78888 .30998 L
.7889 .33635 L
.7889 .31355 L
.78891 .29717 L
.78892 .29952 L
.78893 .29209 L
.78894 .30996 L
.78895 .3166 L
.78896 .3323 L
.78897 .37042 L
.78899 .31758 L
.789 .31061 L
.78902 .31465 L
.78902 .33856 L
.78903 .35886 L
.78905 .36416 L
.78906 .29127 L
.78908 .33855 L
.78908 .34833 L
.78909 .34457 L
.78911 .33174 L
.78912 .29044 L
.78914 .29521 L
.78915 .30345 L
.78916 .33718 L
.78918 .30207 L
.78919 .29546 L
.7892 .30519 L
.78921 .31196 L
.78922 .31999 L
.78923 .32196 L
Mistroke
.78924 .2874 L
.78926 .33832 L
.78927 .32939 L
.78929 .35473 L
.7893 .32251 L
.78931 .32365 L
.78933 .35046 L
.78934 .26513 L
.78935 .27586 L
.78937 .34444 L
.78938 .33227 L
.78939 .34191 L
.78941 .34064 L
.78942 .30501 L
.78944 .33733 L
.78945 .33822 L
.78947 .28483 L
.78948 .29626 L
.78949 .32036 L
.78951 .31523 L
.78952 .30648 L
.78953 .33655 L
.78955 .36291 L
.78956 .2934 L
.78958 .29559 L
.78959 .29763 L
.7896 .33588 L
.78962 .32147 L
.78963 .28896 L
.78964 .29642 L
.78965 .30982 L
.78966 .33226 L
.78967 .31334 L
.78968 .34358 L
.78969 .29904 L
.7897 .28076 L
.78971 .31043 L
.78973 .34562 L
.78974 .32233 L
.78976 .3214 L
.78977 .28285 L
.78977 .28697 L
.78979 .28668 L
.7898 .34272 L
.78981 .3459 L
.78982 .26525 L
.78983 .34411 L
.78985 .32282 L
.78986 .33668 L
.78988 .34345 L
Mistroke
.78989 .31655 L
.7899 .33495 L
.7899 .29066 L
.78991 .28458 L
.78993 .31467 L
.78994 .26505 L
.78996 .32879 L
.78997 .31542 L
.78997 .2906 L
.78998 .34557 L
.78999 .31471 L
.79 .33604 L
.79001 .27431 L
.79002 .27956 L
.79003 .29587 L
.79004 .31523 L
.79005 .36378 L
.79007 .35626 L
.79008 .2986 L
.7901 .3458 L
.79011 .31728 L
.79012 .31891 L
.79014 .37032 L
.79015 .38983 L
.79017 .34185 L
.79018 .36456 L
.79019 .34335 L
.7902 .34754 L
.79022 .34481 L
.79023 .36615 L
.79025 .35437 L
.79026 .30537 L
.79027 .29382 L
.79029 .32596 L
.7903 .28925 L
.79031 .30491 L
.79033 .30885 L
.79034 .31732 L
.79035 .3057 L
.79037 .32716 L
.79038 .31875 L
.79039 .29394 L
.79041 .3308 L
.79042 .31088 L
.79044 .32299 L
.79045 .30543 L
.79047 .33857 L
.79048 .37667 L
.79048 .33178 L
.7905 .30204 L
Mistroke
.79051 .31678 L
.79052 .29247 L
.79053 .30491 L
.79055 .30747 L
.79056 .32209 L
.79057 .30898 L
.79058 .31405 L
.79059 .34669 L
.7906 .24972 L
.79062 .26909 L
.79063 .30798 L
.79065 .3444 L
.79066 .34283 L
.79068 .27321 L
.79069 .36015 L
.7907 .34374 L
.79072 .34194 L
.79073 .30565 L
.79074 .33576 L
.79075 .34059 L
.79077 .35907 L
.79078 .3574 L
.7908 .31213 L
.79081 .30028 L
.79082 .30448 L
.79083 .34029 L
.79084 .32385 L
.79086 .2859 L
.79087 .32671 L
.79087 .31363 L
.79088 .33448 L
.79089 .31188 L
.7909 .36821 L
.79091 .28987 L
.79092 .29846 L
.79092 .37398 L
.79094 .31912 L
.79096 .32901 L
.79097 .33364 L
.79098 .33217 L
.79099 .33554 L
.791 .33058 L
.79101 .28471 L
.79103 .30855 L
.79104 .31319 L
.79107 .32822 L
.79108 .33864 L
.7911 .29624 L
.79111 .31558 L
.79113 .303 L
Mistroke
.79114 .26141 L
.79115 .31621 L
.79116 .28718 L
.79118 .32772 L
.79119 .34452 L
.7912 .3328 L
.79122 .33149 L
.79123 .29511 L
.79125 .31112 L
.79126 .3313 L
.79127 .32286 L
.79128 .32016 L
.7913 .33557 L
.79131 .32039 L
.79133 .31183 L
.79134 .31791 L
.79135 .3431 L
.79137 .33116 L
.79137 .31533 L
.79138 .32529 L
.7914 .27938 L
.79141 .29847 L
.79143 .34022 L
.79143 .30202 L
.79144 .3121 L
.79146 .32325 L
.79147 .31809 L
.79148 .30139 L
.7915 .32387 L
.79151 .28611 L
.79153 .3364 L
.79154 .30046 L
.79155 .33761 L
.79156 .31642 L
.79157 .3328 L
.79158 .30113 L
.79159 .3092 L
.7916 .27645 L
.79162 .3341 L
.79163 .32299 L
.79165 .32072 L
.79166 .2945 L
.79167 .30363 L
.79169 .28766 L
.7917 .32739 L
.79172 .3435 L
.79173 .36299 L
.79174 .31957 L
.79176 .29564 L
.79177 .28574 L
Mistroke
.79178 .30819 L
.79179 .36896 L
.79181 .33844 L
.79182 .29913 L
.79184 .29223 L
.79185 .27552 L
.79187 .2957 L
.79188 .32336 L
.7919 .26668 L
.79191 .30216 L
.79191 .30933 L
.79192 .30071 L
.79193 .30334 L
.79194 .31342 L
.79195 .32428 L
.79196 .31592 L
.79198 .32764 L
.79199 .31993 L
.79201 .31655 L
.79202 .36394 L
.79203 .30707 L
.79205 .29706 L
.79206 .32704 L
.79207 .34729 L
.79209 .25821 L
.7921 .32878 L
.79212 .30626 L
.79213 .33349 L
.79214 .2873 L
.79215 .34047 L
.79217 .33046 L
.79218 .32237 L
.7922 .37853 L
.79221 .33986 L
.79222 .32688 L
.79223 .27947 L
.79224 .26059 L
.79226 .3105 L
.79227 .3019 L
.79227 .30681 L
.79228 .30211 L
.79229 .34838 L
.7923 .36773 L
.79231 .28888 L
.79232 .30416 L
.79233 .28433 L
.79234 .33894 L
.79236 .30809 L
.79237 .33268 L
.79238 .30466 L
Mistroke
.79239 .39383 L
.7924 .35823 L
.79241 .30256 L
.79243 .31139 L
.79244 .36003 L
.79245 .32096 L
.79247 .28646 L
.79248 .33947 L
.79249 .3318 L
.7925 .32803 L
.79252 .33875 L
.79252 .28401 L
.79253 .33952 L
.79255 .31896 L
.79256 .30773 L
.79258 .27139 L
.79259 .32707 L
.7926 .30692 L
.79262 .3068 L
.79263 .27699 L
.79264 .3106 L
.79266 .34259 L
.79267 .31822 L
.79268 .30044 L
.7927 .36432 L
.79271 .3334 L
.79273 .33697 L
.79274 .32754 L
.79275 .32602 L
.79277 .36246 L
.79278 .3035 L
.7928 .33068