(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     51662,       2045]*)
(*NotebookOutlinePosition[     59528,       2278]*)
(*  CellTagsIndexPosition[     58939,       2251]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Statistics",
 StyleBox["`", "MB"],
 "HypothesisTests",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S6.2.1", "1.1"}],

Cell["\<\
A test of a statistical hypothesis is a test of assumption about the \
distribution of a variable. Given sample data, you test whether the \
population from which the sample came has a certain characteristic. You can \
use functions in this package to test hypotheses concerning the mean, the \
variance, the difference in two population means, or the ratio of their \
variances. \
\>", "Text",
 CellTags->{"S6.2.1", "1.2"}],

Cell[TextData[{
 "The data that is given as an argument in a test function is assumed to be \
normally distributed. As a consequence of the Central Limit Theorem, you can \
disregard this normality assumption in the case of tests for the mean when \
the sample size, ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", is large and the data is unimodal. The test functions accept as arguments \
the list of univariate data, a hypothesized parameter and relevant options. "
}], "Text",
 CellTags->{"S6.2.1", "1.3"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["MeanTest[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["mu", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "give the p\[Hyphen]value for the test that the population mean is \
equal to ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["\[Mu]", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" based on the Student ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["t",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" distribution ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["MeanTest[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["mu", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", KnownVariance -> ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["var", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "give the p\[Hyphen]value for the test that the population mean is \
equal to ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["\[Mu]", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" based on the normal distribution ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S6.2.1"],

Cell["Hypothesis tests for the mean.", "Caption",
 CellTags->"S6.2.1"],

Cell[TextData[{
 "Hypothesis tests for the mean are based on the normal distribution when the \
population variance is known, and the Student ",
 Cell[BoxData[
  FormBox[
   StyleBox["t",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " distribution with ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["n",
     "TI"], "-", "1"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " degrees of freedom when the variance has to be estimated. If you know the \
standard deviation instead of the variance, you can also specify ",
 StyleBox["KnownStandardDeviation -> ", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 StyleBox["std", "TI"],
 ". "
}], "Text",
 CellTags->{"S6.2.1", "1.4"}],

Cell[TextData[{
 "The output of a hypothesis test is a p\[Hyphen]value, which is the \
probability of the sample estimate being as extreme as it is given that the \
hypothesized population parameter is true. A two\[Hyphen]sided test can be \
requested using ",
 StyleBox["TwoSided", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 " ",
 StyleBox["->", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 " ",
 StyleBox["True", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 ". For more detailed information about a test use ",
 StyleBox["FullReport", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 " ",
 StyleBox["->", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 " ",
 StyleBox["True", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 ". This causes the parameter estimate and the test statistic to be included \
in the output. You can also specify a significance level using ",
 StyleBox["SignificanceLevel -> ", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 StyleBox["siglev", "TI"],
 ", which yields a conclusion of the test, stating acceptance or rejection of \
the hypothesis. "
}], "Text",
 CellTags->{"S6.2.1", "1.5"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["option name", "TI",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["default value", "TI",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox["",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["SignificanceLevel", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["None", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "significance level of the test ",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["TwoSided", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["False", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "whether to perform a two\[Hyphen]sided test ",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["FullReport", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["False", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "whether to include the estimate, test statistic and distribution in \
output ",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
 GridBoxOptions->{RowLines->{True, False},
 RowSpacings->0.4},
 CellTags->"S6.2.1"],

Cell["Options for all hypothesis test functions.", "Caption",
 CellTags->"S6.2.1"],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S6.2.1", "1.6"}],

Cell["<<Statistics`HypothesisTests`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S6.2.1"],

Cell["\<\
Here is a list of data sampled from a normal population whose variance is \
known to be 8. \
\>", "MathCaption",
 CellTags->{"S6.2.1", "1.7"}],

Cell["\<\
data1 = {34, 37, 44, 31, 41, 42, 38, 45,
 42, 38};\
\>", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S6.2.1"],

Cell[TextData[{
 "This tests whether the population mean is equal to 34. It is very unlikely \
that ",
 StyleBox["data1", "MR"],
 " came from a normal population having variance 8 and a mean as low as 34. "
}], "MathCaption",
 CellTags->{"S6.2.1", "1.8"}],

Cell[CellGroupData[{

Cell["MeanTest[data1, 34, KnownVariance -> 8]", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S6.2.1"],

Cell[BoxData[
 RowBox[{"OneSidedPValue", "\[Rule]", "3.0539431798547487`*^-9"}]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S6.2.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["MeanDifferenceTest[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["data",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["data",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["diff", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the p\[Hyphen]value for Welch",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SuperscriptBox["\[Null]", "\[Prime]"], TraditionalForm]], 
       "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["s approximate ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["t",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["\[Hyphen]test that the difference in population means is ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["diff", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["MeanDifferenceTest[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["data",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["data",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["diff", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", EqualVariances -> True]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "give the p\[Hyphen]value for the test that the difference in \
population means is ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["diff", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" based on the Student ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["t",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" distribution",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["MeanDifferenceTest[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["data",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["data",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["diff", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", KnownVariance -> {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["var",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["var",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "give the p\[Hyphen]value for the test that the difference in \
population means is ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["diff", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" based on the normal distribution",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S6.2.1"],

Cell["Hypothesis tests for mean and difference in means.", "Caption",
 CellTags->"S6.2.1"],

Cell[TextData[{
 "To test the similarity between two populations, you can test whether their \
means are equal, or equivalently, you can test whether the difference between \
their means is zero. If the variances of the populations are known and \
specified as a value of ",
 StyleBox["KnownVariance", "MR"],
 ", the test is based on the normal distribution. Usually, however, the \
variances are unknown and the test uses quantiles from the Student ",
 Cell[BoxData[
  FormBox[
   StyleBox["t",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " distribution to evaluate the hypothesis. "
}], "Text",
 CellTags->{"S6.2.1", "1.9"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["option name", "TI",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["default value", "TI",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox["",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["EqualVariances", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["False", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "equal unknown population variances ",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["KnownVariance", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["None", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "known population variance ",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["KnownStandardDeviation", "MR",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["None", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "known population standard deviation ",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
 GridBoxOptions->{RowLines->{True, False},
 RowSpacings->0.4},
 CellTags->"S6.2.1"],

Cell["Additional options for tests concerning difference in means.", "Caption",
 CellTags->"S6.2.1"],

Cell[TextData[{
 "This is a second list of sample data whose population variance is also ",
 Cell[BoxData[
  FormBox["8", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S6.2.1", "1.10"}],

Cell["\<\
data2 = {39, 40, 34, 45, 44, 38, 42, 39,
   47, 41};\
\>", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S6.2.1"],

Cell[TextData[{
 "This tests whether the difference between the means of the two populations \
is ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S6.2.1", "1.11"}],

Cell[CellGroupData[{

Cell["\<\
MeanDifferenceTest[data1, data2, 0,
KnownVariance -> {8, 8}]\
\>", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S6.2.1"],

Cell[BoxData[
 RowBox[{"OneSidedPValue", "\[Rule]", "0.08947936657534972`"}]], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S6.2.1"]
}, Open  ]],

Cell[TextData[{
 "This is the result of the same test but with a specified significance level \
and a request for a full report. The output now includes the estimator, test \
statistic, and the conclusion of the test. At this level of significance, it \
is not unlikely that ",
 StyleBox["data1", "MR"],
 " and ",
 StyleBox["data2", "MR"],
 " came from the same normal population having variance 8. "
}], "MathCaption",
 CellTags->{"S6.2.1", "1.12"}],

Cell[CellGroupData[{

Cell["\<\
MeanDifferenceTest[data1, data2, 0,
KnownVariance -> {8, 8},
SignificanceLevel -> .05, FullReport -> True]\
\>", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S6.2.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"FullReport", "\[Rule]", 
    TagBox[GridBox[{
       {"\<\"MeanDiff\"\>", "\<\"TestStat\"\>", "\<\"Distribution\"\>"},
       {
        RowBox[{"-", "1.7`"}], 
        RowBox[{"-", "1.3439680055715613`"}], 
        RowBox[{"NormalDistribution", "[", "]"}]}
       },
      RowSpacings->1,
      ColumnSpacings->3,
      RowAlignments->Baseline,
      ColumnAlignments->{Left}],
     Function[BoxForm`e$, 
      TableForm[
      BoxForm`e$, 
       TableHeadings -> {None, {"MeanDiff", "TestStat", "Distribution"}}]]]}],
    ",", 
   RowBox[{"OneSidedPValue", "\[Rule]", "0.08947936657534972`"}], ",", 
   RowBox[{"\<\"Fail to reject null hypothesis at significance level\"\>", 
    "\[Rule]", "0.05`"}]}], "}"}]], "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S6.2.1"]
}, Open  ]],

Cell[TextData[{
 "You can also test for variance and the ratio of two variances using ",
 StyleBox["VarianceTest", "MR"],
 " and ",
 StyleBox["VarianceRatioTest", "MR"],
 ". These use the chi\[Hyphen]square and ",
 Cell[BoxData[
  FormBox[
   StyleBox["F",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "\[Hyphen]ratio distributions respectively. The same output options, ",
 StyleBox["SignificanceLevel", "MR"],
 ", ",
 StyleBox["TwoSided", "MR"],
 ", and ",
 StyleBox["FullReport", "MR"],
 ", are available for these tests. "
}], "Text",
 CellTags->{"S6.2.1", "1.13"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["VarianceTest[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["var", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["options", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "give the p\[Hyphen]value for the test that the population variance is\
\[NonBreakingSpace]",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["var", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["VarianceRatioTest[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["data",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["data",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ratio", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["options", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "give the p\[Hyphen]value for the test that the ratio of population \
variances is ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ratio", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S6.2.1"],

Cell["Hypothesis tests for variance and ratio of two variances. ", "Caption",
 CellTags->"S6.2.1"],

Cell["Here is another set of data. ", "MathCaption",
 CellTags->{"S6.2.1", "1.14"}],

Cell["data = {41.0, 42.4, 42.5, 40.6, 45.6, 34.4};", "Input",
 CellLabel->"In[7]:= ",
 CellTags->"S6.2.1"],

Cell[TextData[{
 "This is a test to see whether the variance of the population from which \
these data were sampled is ",
 Cell[BoxData[
  FormBox["8", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S6.2.1", "1.15"}],

Cell[CellGroupData[{

Cell["\<\
VarianceTest[data, 8, TwoSided -> True,
FullReport -> True]\
\>", "Input",
 CellLabel->"In[8]:= ",
 CellTags->"S6.2.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"FullReport", "\[Rule]", 
    TagBox[GridBox[{
       {"\<\"Variance\"\>", "\<\"TestStat\"\>", "\<\"Distribution\"\>"},
       {"13.809666666666672`", "8.63104166666667`", 
        RowBox[{"ChiSquareDistribution", "[", "5", "]"}]}
       },
      RowSpacings->1,
      ColumnSpacings->3,
      RowAlignments->Baseline,
      ColumnAlignments->{Left}],
     Function[BoxForm`e$, 
      TableForm[
      BoxForm`e$, 
       TableHeadings -> {None, {"Variance", "TestStat", "Distribution"}}]]]}],
    ",", 
   RowBox[{"TwoSidedPValue", "\[Rule]", "0.24943394568935573`"}]}], 
  "}"}]], "Output",
 CellLabel->"Out[8]= ",
 CellTags->"S6.2.1"]
}, Open  ]],

Cell[TextData[{
 "If you have already calculated a test statistic in terms of the normal, chi\
\[Hyphen]square, Student ",
 Cell[BoxData[
  FormBox[
   StyleBox["t",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", or ",
 Cell[BoxData[
  FormBox[
   StyleBox["F",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "\[Hyphen]ratio distribution, you can get its p\[Hyphen]value using the \
appropriate p\[Hyphen]value function. For example, ",
 StyleBox["NormalPValue", "MR"],
 " computes a p\[Hyphen]value for a test statistic using a normal \
distribution with mean zero and unit variance. A two\[Hyphen]sided \
p\[Hyphen]value is obtained by giving ",
 StyleBox["TwoSided", "MR"],
 " ",
 StyleBox["->", "MR"],
 " ",
 StyleBox["True", "MR"],
 ". "
}], "Text",
 CellTags->{"S6.2.1", "1.16"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["NormalPValue[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["teststat", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the p\[Hyphen]value for ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["teststat", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" in terms of the normal distribution with mean ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["0", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and unit variance",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["StudentTPValue[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["teststat", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dof", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the p\[Hyphen]value for ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["teststat", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" in terms of the Student ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["t", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" distribution with ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dof", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" degrees of freedom",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ChiSquarePValue[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["teststat", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dof", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the p\[Hyphen]value for ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["teststat", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" in terms of the chi\[Hyphen]square distribution with ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dof", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" degrees of freedom ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["FRatioPValue[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["teststat", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["numdof", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dendof", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the p\[Hyphen]value for ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["teststat", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" in terms of the ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["F", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["\[Hyphen]ratio distribution with ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["numdof", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" numerator degrees of freedom and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dendof", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" denominator degrees of freedom",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S6.2.1"],

Cell["\<\
Functions providing p\[Hyphen]values of test statistics. \
\>", "Caption",
 CellTags->"S6.2.1"],

Cell[TextData[{
 "This is the tail probability of the normal distribution with mean ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and unit variance at point ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "1.96"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S6.2.1", "1.17"}],

Cell[CellGroupData[{

Cell["NormalPValue[-1.96]", "Input",
 CellLabel->"In[9]:= ",
 CellTags->"S6.2.1"],

Cell[BoxData[
 RowBox[{"OneSidedPValue", "\[Rule]", "0.024997895148220428`"}]], "Output",
 CellLabel->"Out[9]= ",
 CellTags->"S6.2.1"]
}, Open  ]],

Cell[TextData[{
 "A ",
 StyleBox["TwoSidedPValue", "MR"],
 " gives the probability of the test statistic being at least as extreme as \
",
 Cell[BoxData[
  FormBox["1.96", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " at either tail of the distribution. "
}], "MathCaption",
 CellTags->{"S6.2.1", "1.18"}],

Cell[CellGroupData[{

Cell["NormalPValue[-1.96, TwoSided -> True]", "Input",
 CellLabel->"In[10]:= ",
 CellTags->"S6.2.1"],

Cell[BoxData[
 RowBox[{"TwoSidedPValue", "\[Rule]", "0.049995790296440856`"}]], "Output",
 CellLabel->"Out[10]= ",
 CellTags->"S6.2.1"]
}, Open  ]],

Cell["\<\
Note that a p\[Hyphen]value for a statistical distribution is not equivalent \
to the cumulative distribution function (CDF) for that distribution. \
\>", "MathCaption",
 CellTags->{"S6.2.1", "1.19"}],

Cell[CellGroupData[{

Cell["\<\
Plot[CDF[ChiSquareDistribution[5], x],
  {x, 1, 10}, PlotRange->{0, 1}]\
\>", "Input",
 CellLabel->"In[11]:= ",
 CellTags->"S6.2.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0952381 0 0.618034 [
[.21429 -0.0125 -3 -9 ]
[.21429 -0.0125 3 0 ]
[.40476 -0.0125 -3 -9 ]
[.40476 -0.0125 3 0 ]
[.59524 -0.0125 -3 -9 ]
[.59524 -0.0125 3 0 ]
[.78571 -0.0125 -3 -9 ]
[.78571 -0.0125 3 0 ]
[.97619 -0.0125 -6 -9 ]
[.97619 -0.0125 6 0 ]
[.01131 .12361 -18 -4.5 ]
[.01131 .12361 0 4.5 ]
[.01131 .24721 -18 -4.5 ]
[.01131 .24721 0 4.5 ]
[.01131 .37082 -18 -4.5 ]
[.01131 .37082 0 4.5 ]
[.01131 .49443 -18 -4.5 ]
[.01131 .49443 0 4.5 ]
[.01131 .61803 -6 -4.5 ]
[.01131 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 0 m
.21429 .00625 L
s
[(2)] .21429 -0.0125 0 1 Mshowa
.40476 0 m
.40476 .00625 L
s
[(4)] .40476 -0.0125 0 1 Mshowa
.59524 0 m
.59524 .00625 L
s
[(6)] .59524 -0.0125 0 1 Mshowa
.78571 0 m
.78571 .00625 L
s
[(8)] .78571 -0.0125 0 1 Mshowa
.97619 0 m
.97619 .00625 L
s
[(10)] .97619 -0.0125 0 1 Mshowa
.125 Mabswid
.07143 0 m
.07143 .00375 L
s
.11905 0 m
.11905 .00375 L
s
.16667 0 m
.16667 .00375 L
s
.2619 0 m
.2619 .00375 L
s
.30952 0 m
.30952 .00375 L
s
.35714 0 m
.35714 .00375 L
s
.45238 0 m
.45238 .00375 L
s
.5 0 m
.5 .00375 L
s
.54762 0 m
.54762 .00375 L
s
.64286 0 m
.64286 .00375 L
s
.69048 0 m
.69048 .00375 L
s
.7381 0 m
.7381 .00375 L
s
.83333 0 m
.83333 .00375 L
s
.88095 0 m
.88095 .00375 L
s
.92857 0 m
.92857 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
.02381 .12361 m
.03006 .12361 L
s
[(0.2)] .01131 .12361 1 0 Mshowa
.02381 .24721 m
.03006 .24721 L
s
[(0.4)] .01131 .24721 1 0 Mshowa
.02381 .37082 m
.03006 .37082 L
s
[(0.6)] .01131 .37082 1 0 Mshowa
.02381 .49443 m
.03006 .49443 L
s
[(0.8)] .01131 .49443 1 0 Mshowa
.02381 .61803 m
.03006 .61803 L
s
[(1)] .01131 .61803 1 0 Mshowa
.125 Mabswid
.02381 .0309 m
.02756 .0309 L
s
.02381 .0618 m
.02756 .0618 L
s
.02381 .09271 m
.02756 .09271 L
s
.02381 .15451 m
.02756 .15451 L
s
.02381 .18541 m
.02756 .18541 L
s
.02381 .21631 m
.02756 .21631 L
s
.02381 .27812 m
.02756 .27812 L
s
.02381 .30902 m
.02756 .30902 L
s
.02381 .33992 m
.02756 .33992 L
s
.02381 .40172 m
.02756 .40172 L
s
.02381 .43262 m
.02756 .43262 L
s
.02381 .46353 m
.02756 .46353 L
s
.02381 .52533 m
.02756 .52533 L
s
.02381 .55623 m
.02756 .55623 L
s
.02381 .58713 m
.02756 .58713 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.11905 .02314 m
.15382 .04444 L
.19174 .07365 L
.22736 .10516 L
.26161 .13784 L
.29806 .17396 L
.33316 .20903 L
.37046 .24576 L
.4064 .28 L
.44097 .31144 L
.47775 .34298 L
.51316 .37129 L
.54722 .39652 L
.58347 .42124 L
.61837 .44295 L
.65547 .46387 L
.69121 .48202 L
.72558 .49774 L
.76216 .51272 L
.79738 .52557 L
.8348 .53767 L
.87086 .54797 L
.90556 .55673 L
.94246 .56494 L
.97619 .57154 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S6.2.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[11]= ",
 CellTags->"S6.2.1"]
}, Open  ]],

Cell["\<\
A one\[Hyphen]sided p\[Hyphen]value has a maximum value of 0.5 because it \
represents a one\[Hyphen]sided tail probability. The maximum occurs at the \
median for the underlying statistical distribution. \
\>", "MathCaption",
 CellTags->{"S6.2.1", "1.20"}],

Cell[CellGroupData[{

Cell["\<\
Plot[OneSidedPValue /. ChiSquarePValue[x, 5],
  {x, 1, 10}, PlotRange->{0, 1}]\
\>", "Input",
 CellLabel->"In[12]:= ",
 CellTags->"S6.2.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0952381 0 0.618034 [
[.21429 -0.0125 -3 -9 ]
[.21429 -0.0125 3 0 ]
[.40476 -0.0125 -3 -9 ]
[.40476 -0.0125 3 0 ]
[.59524 -0.0125 -3 -9 ]
[.59524 -0.0125 3 0 ]
[.78571 -0.0125 -3 -9 ]
[.78571 -0.0125 3 0 ]
[.97619 -0.0125 -6 -9 ]
[.97619 -0.0125 6 0 ]
[.01131 .12361 -18 -4.5 ]
[.01131 .12361 0 4.5 ]
[.01131 .24721 -18 -4.5 ]
[.01131 .24721 0 4.5 ]
[.01131 .37082 -18 -4.5 ]
[.01131 .37082 0 4.5 ]
[.01131 .49443 -18 -4.5 ]
[.01131 .49443 0 4.5 ]
[.01131 .61803 -6 -4.5 ]
[.01131 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 0 m
.21429 .00625 L
s
[(2)] .21429 -0.0125 0 1 Mshowa
.40476 0 m
.40476 .00625 L
s
[(4)] .40476 -0.0125 0 1 Mshowa
.59524 0 m
.59524 .00625 L
s
[(6)] .59524 -0.0125 0 1 Mshowa
.78571 0 m
.78571 .00625 L
s
[(8)] .78571 -0.0125 0 1 Mshowa
.97619 0 m
.97619 .00625 L
s
[(10)] .97619 -0.0125 0 1 Mshowa
.125 Mabswid
.07143 0 m
.07143 .00375 L
s
.11905 0 m
.11905 .00375 L
s
.16667 0 m
.16667 .00375 L
s
.2619 0 m
.2619 .00375 L
s
.30952 0 m
.30952 .00375 L
s
.35714 0 m
.35714 .00375 L
s
.45238 0 m
.45238 .00375 L
s
.5 0 m
.5 .00375 L
s
.54762 0 m
.54762 .00375 L
s
.64286 0 m
.64286 .00375 L
s
.69048 0 m
.69048 .00375 L
s
.7381 0 m
.7381 .00375 L
s
.83333 0 m
.83333 .00375 L
s
.88095 0 m
.88095 .00375 L
s
.92857 0 m
.92857 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
.02381 .12361 m
.03006 .12361 L
s
[(0.2)] .01131 .12361 1 0 Mshowa
.02381 .24721 m
.03006 .24721 L
s
[(0.4)] .01131 .24721 1 0 Mshowa
.02381 .37082 m
.03006 .37082 L
s
[(0.6)] .01131 .37082 1 0 Mshowa
.02381 .49443 m
.03006 .49443 L
s
[(0.8)] .01131 .49443 1 0 Mshowa
.02381 .61803 m
.03006 .61803 L
s
[(1)] .01131 .61803 1 0 Mshowa
.125 Mabswid
.02381 .0309 m
.02756 .0309 L
s
.02381 .0618 m
.02756 .0618 L
s
.02381 .09271 m
.02756 .09271 L
s
.02381 .15451 m
.02756 .15451 L
s
.02381 .18541 m
.02756 .18541 L
s
.02381 .21631 m
.02756 .21631 L
s
.02381 .27812 m
.02756 .27812 L
s
.02381 .30902 m
.02756 .30902 L
s
.02381 .33992 m
.02756 .33992 L
s
.02381 .40172 m
.02756 .40172 L
s
.02381 .43262 m
.02756 .43262 L
s
.02381 .46353 m
.02756 .46353 L
s
.02381 .52533 m
.02756 .52533 L
s
.02381 .55623 m
.02756 .55623 L
s
.02381 .58713 m
.02756 .58713 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.11905 .02314 m
.15382 .04444 L
.19174 .07365 L
.22736 .10516 L
.26161 .13784 L
.29806 .17396 L
.33316 .20903 L
.37046 .24576 L
.4064 .28 L
.42285 .29517 L
.42735 .29926 L
.4322 .30363 L
.43455 .30573 L
.43571 .30676 L
.43678 .30772 L
.43775 .30859 L
.43878 .30853 L
.43993 .30751 L
.44097 .30659 L
.45882 .29102 L
.47775 .27506 L
.51381 .24625 L
.5485 .22059 L
.58541 .19554 L
.62095 .17356 L
.65512 .15435 L
.6915 .13587 L
.72652 .11989 L
.76374 .1047 L
.79961 .0917 L
.8341 .08057 L
.87081 .07008 L
.90615 .06116 L
.94012 .05359 L
.97619 .0465 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S6.2.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[12]= ",
 CellTags->"S6.2.1"]
}, Open  ]],

Cell["\<\
A two\[Hyphen]sided p\[Hyphen]value is twice the one\[Hyphen]sided \
p\[Hyphen]value. \
\>", "MathCaption",
 CellTags->{"S6.2.1", "1.21"}],

Cell[CellGroupData[{

Cell["\<\
Plot[TwoSidedPValue /. ChiSquarePValue[x, 5,
  TwoSided -> True], {x, 1, 10}, PlotRange->{0, 1}]\
\>", "Input",
 CellLabel->"In[13]:= ",
 CellTags->"S6.2.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0952381 0 0.618034 [
[.21429 -0.0125 -3 -9 ]
[.21429 -0.0125 3 0 ]
[.40476 -0.0125 -3 -9 ]
[.40476 -0.0125 3 0 ]
[.59524 -0.0125 -3 -9 ]
[.59524 -0.0125 3 0 ]
[.78571 -0.0125 -3 -9 ]
[.78571 -0.0125 3 0 ]
[.97619 -0.0125 -6 -9 ]
[.97619 -0.0125 6 0 ]
[.01131 .12361 -18 -4.5 ]
[.01131 .12361 0 4.5 ]
[.01131 .24721 -18 -4.5 ]
[.01131 .24721 0 4.5 ]
[.01131 .37082 -18 -4.5 ]
[.01131 .37082 0 4.5 ]
[.01131 .49443 -18 -4.5 ]
[.01131 .49443 0 4.5 ]
[.01131 .61803 -6 -4.5 ]
[.01131 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 0 m
.21429 .00625 L
s
[(2)] .21429 -0.0125 0 1 Mshowa
.40476 0 m
.40476 .00625 L
s
[(4)] .40476 -0.0125 0 1 Mshowa
.59524 0 m
.59524 .00625 L
s
[(6)] .59524 -0.0125 0 1 Mshowa
.78571 0 m
.78571 .00625 L
s
[(8)] .78571 -0.0125 0 1 Mshowa
.97619 0 m
.97619 .00625 L
s
[(10)] .97619 -0.0125 0 1 Mshowa
.125 Mabswid
.07143 0 m
.07143 .00375 L
s
.11905 0 m
.11905 .00375 L
s
.16667 0 m
.16667 .00375 L
s
.2619 0 m
.2619 .00375 L
s
.30952 0 m
.30952 .00375 L
s
.35714 0 m
.35714 .00375 L
s
.45238 0 m
.45238 .00375 L
s
.5 0 m
.5 .00375 L
s
.54762 0 m
.54762 .00375 L
s
.64286 0 m
.64286 .00375 L
s
.69048 0 m
.69048 .00375 L
s
.7381 0 m
.7381 .00375 L
s
.83333 0 m
.83333 .00375 L
s
.88095 0 m
.88095 .00375 L
s
.92857 0 m
.92857 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
.02381 .12361 m
.03006 .12361 L
s
[(0.2)] .01131 .12361 1 0 Mshowa
.02381 .24721 m
.03006 .24721 L
s
[(0.4)] .01131 .24721 1 0 Mshowa
.02381 .37082 m
.03006 .37082 L
s
[(0.6)] .01131 .37082 1 0 Mshowa
.02381 .49443 m
.03006 .49443 L
s
[(0.8)] .01131 .49443 1 0 Mshowa
.02381 .61803 m
.03006 .61803 L
s
[(1)] .01131 .61803 1 0 Mshowa
.125 Mabswid
.02381 .0309 m
.02756 .0309 L
s
.02381 .0618 m
.02756 .0618 L
s
.02381 .09271 m
.02756 .09271 L
s
.02381 .15451 m
.02756 .15451 L
s
.02381 .18541 m
.02756 .18541 L
s
.02381 .21631 m
.02756 .21631 L
s
.02381 .27812 m
.02756 .27812 L
s
.02381 .30902 m
.02756 .30902 L
s
.02381 .33992 m
.02756 .33992 L
s
.02381 .40172 m
.02756 .40172 L
s
.02381 .43262 m
.02756 .43262 L
s
.02381 .46353 m
.02756 .46353 L
s
.02381 .52533 m
.02756 .52533 L
s
.02381 .55623 m
.02756 .55623 L
s
.02381 .58713 m
.02756 .58713 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.11905 .04627 m
.15382 .08888 L
.19174 .1473 L
.22736 .21032 L
.26161 .27568 L
.29806 .34792 L
.33316 .41805 L
.37046 .49153 L
.4064 .56 L
.42285 .59033 L
.42735 .59851 L
.4322 .60726 L
.43455 .61146 L
.43571 .61353 L
.43678 .61545 L
.43775 .61717 L
.43878 .61706 L
.43993 .61502 L
.44097 .61318 L
.45882 .58205 L
.47775 .55012 L
.51381 .4925 L
.5485 .44119 L
.58541 .39108 L
.62095 .34713 L
.65512 .3087 L
.6915 .27174 L
.72652 .23977 L
.76374 .20941 L
.79961 .18341 L
.8341 .16114 L
.87081 .14016 L
.90615 .12233 L
.94012 .10717 L
.97619 .093 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S6.2.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[13]= ",
 CellTags->"S6.2.1"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S6.2.1"->{
    Cell[1776, 53, 141, 6, 36, "Subsection",
      CellTags->{"S6.2.1", "1.1"}],
    Cell[1920, 61, 434, 8, 72, "Text",
      CellTags->{"S6.2.1", "1.2"}],
    Cell[2357, 71, 605, 13, 72, "Text",
      CellTags->{"S6.2.1", "1.3"}],
    Cell[2965, 86, 3236, 98, 102, "DefinitionBox",
      CellTags->"S6.2.1"],
    Cell[6204, 186, 70, 1, 15, "Caption",
      CellTags->"S6.2.1"],
    Cell[6277, 189, 789, 23, 72, "Text",
      CellTags->{"S6.2.1", "1.4"}],
    Cell[7069, 214, 1247, 37, 104, "Text",
      CellTags->{"S6.2.1", "1.5"}],
    Cell[8319, 253, 3475, 102, 128, "DefinitionBox3Col",
      CellTags->"S6.2.1"],
    Cell[11797, 357, 82, 1, 15, "Caption",
      CellTags->"S6.2.1"],
    Cell[11882, 360, 77, 1, 40, "MathCaption",
      CellTags->{"S6.2.1", "1.6"}],
    Cell[11962, 363, 91, 2, 70, "Input",
      CellTags->"S6.2.1"],
    Cell[12056, 367, 152, 4, 70, "MathCaption",
      CellTags->{"S6.2.1", "1.7"}],
    Cell[12211, 373, 120, 5, 70, "Input",
      CellTags->"S6.2.1"],
    Cell[12334, 380, 255, 6, 70, "MathCaption",
      CellTags->{"S6.2.1", "1.8"}],
    Cell[12614, 390, 101, 2, 70, "Input",
      CellTags->"S6.2.1"],
    Cell[12718, 394, 136, 3, 70, "Output",
      CellTags->"S6.2.1"],
    Cell[12869, 400, 6782, 203, 70, "DefinitionBox",
      CellTags->"S6.2.1"],
    Cell[19654, 605, 90, 1, 70, "Caption",
      CellTags->"S6.2.1"],
    Cell[19747, 608, 676, 15, 70, "Text",
      CellTags->{"S6.2.1", "1.9"}],
    Cell[20426, 625, 3320, 96, 70, "DefinitionBox3Col",
      CellTags->"S6.2.1"],
    Cell[23749, 723, 100, 1, 70, "Caption",
      CellTags->"S6.2.1"],
    Cell[23852, 726, 259, 7, 70, "MathCaption",
      CellTags->{"S6.2.1", "1.10"}],
    Cell[24114, 735, 122, 5, 70, "Input",
      CellTags->"S6.2.1"],
    Cell[24239, 742, 268, 8, 70, "MathCaption",
      CellTags->{"S6.2.1", "1.11"}],
    Cell[24532, 754, 130, 5, 70, "Input",
      CellTags->"S6.2.1"],
    Cell[24665, 761, 133, 3, 70, "Output",
      CellTags->"S6.2.1"],
    Cell[24813, 767, 450, 10, 70, "MathCaption",
      CellTags->{"S6.2.1", "1.12"}],
    Cell[25288, 781, 176, 6, 70, "Input",
      CellTags->"S6.2.1"],
    Cell[25467, 789, 820, 24, 70, "Output",
      CellTags->"S6.2.1"],
    Cell[26302, 816, 618, 19, 70, "Text",
      CellTags->{"S6.2.1", "1.13"}],
    Cell[26923, 837, 3290, 103, 70, "DefinitionBox",
      CellTags->"S6.2.1"],
    Cell[30216, 942, 98, 1, 70, "Caption",
      CellTags->"S6.2.1"],
    Cell[30317, 945, 83, 1, 70, "MathCaption",
      CellTags->{"S6.2.1", "1.14"}],
    Cell[30403, 948, 106, 2, 70, "Input",
      CellTags->"S6.2.1"],
    Cell[30512, 952, 289, 8, 70, "MathCaption",
      CellTags->{"S6.2.1", "1.15"}],
    Cell[30826, 964, 129, 5, 70, "Input",
      CellTags->"S6.2.1"],
    Cell[30958, 971, 688, 21, 70, "Output",
      CellTags->"S6.2.1"],
    Cell[31661, 995, 882, 27, 70, "Text",
      CellTags->{"S6.2.1", "1.16"}],
    Cell[32546, 1024, 5922, 177, 70, "DefinitionBox",
      CellTags->"S6.2.1"],
    Cell[38471, 1203, 105, 3, 70, "Caption",
      CellTags->"S6.2.1"],
    Cell[38579, 1208, 421, 12, 70, "MathCaption",
      CellTags->{"S6.2.1", "1.17"}],
    Cell[39025, 1224, 81, 2, 70, "Input",
      CellTags->"S6.2.1"],
    Cell[39109, 1228, 134, 3, 70, "Output",
      CellTags->"S6.2.1"],
    Cell[39258, 1234, 344, 10, 70, "MathCaption",
      CellTags->{"S6.2.1", "1.18"}],
    Cell[39627, 1248, 100, 2, 70, "Input",
      CellTags->"S6.2.1"],
    Cell[39730, 1252, 135, 3, 70, "Output",
      CellTags->"S6.2.1"],
    Cell[39880, 1258, 210, 4, 70, "MathCaption",
      CellTags->{"S6.2.1", "1.19"}],
    Cell[40115, 1266, 142, 5, 70, "Input",
      CellTags->"S6.2.1"],
    Cell[40260, 1273, 3234, 229, 70, 3164, 226, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S6.2.1"],
    Cell[43497, 1504, 180, 6, 70, "Output",
      CellTags->"S6.2.1"],
    Cell[43692, 1513, 267, 5, 70, "MathCaption",
      CellTags->{"S6.2.1", "1.20"}],
    Cell[43984, 1522, 149, 5, 70, "Input",
      CellTags->"S6.2.1"],
    Cell[44136, 1529, 3388, 239, 70, 3318, 236, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S6.2.1"],
    Cell[47527, 1770, 180, 6, 70, "Output",
      CellTags->"S6.2.1"],
    Cell[47722, 1779, 148, 4, 70, "MathCaption",
      CellTags->{"S6.2.1", "1.21"}],
    Cell[47895, 1787, 167, 5, 70, "Input",
      CellTags->"S6.2.1"],
    Cell[48065, 1794, 3386, 239, 70, 3316, 236, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S6.2.1"],
    Cell[51454, 2035, 180, 6, 70, "Output",
      CellTags->"S6.2.1"]},
  "1.1"->{
    Cell[1776, 53, 141, 6, 36, "Subsection",
      CellTags->{"S6.2.1", "1.1"}]},
  "1.2"->{
    Cell[1920, 61, 434, 8, 72, "Text",
      CellTags->{"S6.2.1", "1.2"}]},
  "1.3"->{
    Cell[2357, 71, 605, 13, 72, "Text",
      CellTags->{"S6.2.1", "1.3"}]},
  "1.4"->{
    Cell[6277, 189, 789, 23, 72, "Text",
      CellTags->{"S6.2.1", "1.4"}]},
  "1.5"->{
    Cell[7069, 214, 1247, 37, 104, "Text",
      CellTags->{"S6.2.1", "1.5"}]},
  "1.6"->{
    Cell[11882, 360, 77, 1, 40, "MathCaption",
      CellTags->{"S6.2.1", "1.6"}]},
  "1.7"->{
    Cell[12056, 367, 152, 4, 70, "MathCaption",
      CellTags->{"S6.2.1", "1.7"}]},
  "1.8"->{
    Cell[12334, 380, 255, 6, 70, "MathCaption",
      CellTags->{"S6.2.1", "1.8"}]},
  "1.9"->{
    Cell[19747, 608, 676, 15, 70, "Text",
      CellTags->{"S6.2.1", "1.9"}]},
  "1.10"->{
    Cell[23852, 726, 259, 7, 70, "MathCaption",
      CellTags->{"S6.2.1", "1.10"}]},
  "1.11"->{
    Cell[24239, 742, 268, 8, 70, "MathCaption",
      CellTags->{"S6.2.1", "1.11"}]},
  "1.12"->{
    Cell[24813, 767, 450, 10, 70, "MathCaption",
      CellTags->{"S6.2.1", "1.12"}]},
  "1.13"->{
    Cell[26302, 816, 618, 19, 70, "Text",
      CellTags->{"S6.2.1", "1.13"}]},
  "1.14"->{
    Cell[30317, 945, 83, 1, 70, "MathCaption",
      CellTags->{"S6.2.1", "1.14"}]},
  "1.15"->{
    Cell[30512, 952, 289, 8, 70, "MathCaption",
      CellTags->{"S6.2.1", "1.15"}]},
  "1.16"->{
    Cell[31661, 995, 882, 27, 70, "Text",
      CellTags->{"S6.2.1", "1.16"}]},
  "1.17"->{
    Cell[38579, 1208, 421, 12, 70, "MathCaption",
      CellTags->{"S6.2.1", "1.17"}]},
  "1.18"->{
    Cell[39258, 1234, 344, 10, 70, "MathCaption",
      CellTags->{"S6.2.1", "1.18"}]},
  "1.19"->{
    Cell[39880, 1258, 210, 4, 70, "MathCaption",
      CellTags->{"S6.2.1", "1.19"}]},
  "1.20"->{
    Cell[43692, 1513, 267, 5, 70, "MathCaption",
      CellTags->{"S6.2.1", "1.20"}]},
  "1.21"->{
    Cell[47722, 1779, 148, 4, 70, "MathCaption",
      CellTags->{"S6.2.1", "1.21"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S6.2.1", 52284, 2061},
  {"1.1", 56929, 2184},
  {"1.2", 57022, 2187},
  {"1.3", 57109, 2190},
  {"1.4", 57197, 2193},
  {"1.5", 57286, 2196},
  {"1.6", 57377, 2199},
  {"1.7", 57472, 2202},
  {"1.8", 57568, 2205},
  {"1.9", 57664, 2208},
  {"1.10", 57755, 2211},
  {"1.11", 57853, 2214},
  {"1.12", 57951, 2217},
  {"1.13", 58050, 2220},
  {"1.14", 58142, 2223},
  {"1.15", 58239, 2226},
  {"1.16", 58337, 2229},
  {"1.17", 58429, 2232},
  {"1.18", 58529, 2235},
  {"1.19", 58629, 2238},
  {"1.20", 58728, 2241},
  {"1.21", 58827, 2244}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 141, 6, 36, "Subsection",
  CellTags->{"S6.2.1", "1.1"}],
Cell[1920, 61, 434, 8, 72, "Text",
  CellTags->{"S6.2.1", "1.2"}],
Cell[2357, 71, 605, 13, 72, "Text",
  CellTags->{"S6.2.1", "1.3"}],
Cell[2965, 86, 3236, 98, 102, "DefinitionBox",
  CellTags->"S6.2.1"],
Cell[6204, 186, 70, 1, 15, "Caption",
  CellTags->"S6.2.1"],
Cell[6277, 189, 789, 23, 72, "Text",
  CellTags->{"S6.2.1", "1.4"}],
Cell[7069, 214, 1247, 37, 104, "Text",
  CellTags->{"S6.2.1", "1.5"}],
Cell[8319, 253, 3475, 102, 128, "DefinitionBox3Col",
  CellTags->"S6.2.1"],
Cell[11797, 357, 82, 1, 15, "Caption",
  CellTags->"S6.2.1"],
Cell[11882, 360, 77, 1, 40, "MathCaption",
  CellTags->{"S6.2.1", "1.6"}],
Cell[11962, 363, 91, 2, 70, "Input",
  CellTags->"S6.2.1"],
Cell[12056, 367, 152, 4, 70, "MathCaption",
  CellTags->{"S6.2.1", "1.7"}],
Cell[12211, 373, 120, 5, 70, "Input",
  CellTags->"S6.2.1"],
Cell[12334, 380, 255, 6, 70, "MathCaption",
  CellTags->{"S6.2.1", "1.8"}],

Cell[CellGroupData[{
Cell[12614, 390, 101, 2, 70, "Input",
  CellTags->"S6.2.1"],
Cell[12718, 394, 136, 3, 70, "Output",
  CellTags->"S6.2.1"]
}, Open  ]],
Cell[12869, 400, 6782, 203, 70, "DefinitionBox",
  CellTags->"S6.2.1"],
Cell[19654, 605, 90, 1, 70, "Caption",
  CellTags->"S6.2.1"],
Cell[19747, 608, 676, 15, 70, "Text",
  CellTags->{"S6.2.1", "1.9"}],
Cell[20426, 625, 3320, 96, 70, "DefinitionBox3Col",
  CellTags->"S6.2.1"],
Cell[23749, 723, 100, 1, 70, "Caption",
  CellTags->"S6.2.1"],
Cell[23852, 726, 259, 7, 70, "MathCaption",
  CellTags->{"S6.2.1", "1.10"}],
Cell[24114, 735, 122, 5, 70, "Input",
  CellTags->"S6.2.1"],
Cell[24239, 742, 268, 8, 70, "MathCaption",
  CellTags->{"S6.2.1", "1.11"}],

Cell[CellGroupData[{
Cell[24532, 754, 130, 5, 70, "Input",
  CellTags->"S6.2.1"],
Cell[24665, 761, 133, 3, 70, "Output",
  CellTags->"S6.2.1"]
}, Open  ]],
Cell[24813, 767, 450, 10, 70, "MathCaption",
  CellTags->{"S6.2.1", "1.12"}],

Cell[CellGroupData[{
Cell[25288, 781, 176, 6, 70, "Input",
  CellTags->"S6.2.1"],
Cell[25467, 789, 820, 24, 70, "Output",
  CellTags->"S6.2.1"]
}, Open  ]],
Cell[26302, 816, 618, 19, 70, "Text",
  CellTags->{"S6.2.1", "1.13"}],
Cell[26923, 837, 3290, 103, 70, "DefinitionBox",
  CellTags->"S6.2.1"],
Cell[30216, 942, 98, 1, 70, "Caption",
  CellTags->"S6.2.1"],
Cell[30317, 945, 83, 1, 70, "MathCaption",
  CellTags->{"S6.2.1", "1.14"}],
Cell[30403, 948, 106, 2, 70, "Input",
  CellTags->"S6.2.1"],
Cell[30512, 952, 289, 8, 70, "MathCaption",
  CellTags->{"S6.2.1", "1.15"}],

Cell[CellGroupData[{
Cell[30826, 964, 129, 5, 70, "Input",
  CellTags->"S6.2.1"],
Cell[30958, 971, 688, 21, 70, "Output",
  CellTags->"S6.2.1"]
}, Open  ]],
Cell[31661, 995, 882, 27, 70, "Text",
  CellTags->{"S6.2.1", "1.16"}],
Cell[32546, 1024, 5922, 177, 70, "DefinitionBox",
  CellTags->"S6.2.1"],
Cell[38471, 1203, 105, 3, 70, "Caption",
  CellTags->"S6.2.1"],
Cell[38579, 1208, 421, 12, 70, "MathCaption",
  CellTags->{"S6.2.1", "1.17"}],

Cell[CellGroupData[{
Cell[39025, 1224, 81, 2, 70, "Input",
  CellTags->"S6.2.1"],
Cell[39109, 1228, 134, 3, 70, "Output",
  CellTags->"S6.2.1"]
}, Open  ]],
Cell[39258, 1234, 344, 10, 70, "MathCaption",
  CellTags->{"S6.2.1", "1.18"}],

Cell[CellGroupData[{
Cell[39627, 1248, 100, 2, 70, "Input",
  CellTags->"S6.2.1"],
Cell[39730, 1252, 135, 3, 70, "Output",
  CellTags->"S6.2.1"]
}, Open  ]],
Cell[39880, 1258, 210, 4, 70, "MathCaption",
  CellTags->{"S6.2.1", "1.19"}],

Cell[CellGroupData[{
Cell[40115, 1266, 142, 5, 70, "Input",
  CellTags->"S6.2.1"],
Cell[40260, 1273, 3234, 229, 70, 3164, 226, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S6.2.1"],
Cell[43497, 1504, 180, 6, 70, "Output",
  CellTags->"S6.2.1"]
}, Open  ]],
Cell[43692, 1513, 267, 5, 70, "MathCaption",
  CellTags->{"S6.2.1", "1.20"}],

Cell[CellGroupData[{
Cell[43984, 1522, 149, 5, 70, "Input",
  CellTags->"S6.2.1"],
Cell[44136, 1529, 3388, 239, 70, 3318, 236, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S6.2.1"],
Cell[47527, 1770, 180, 6, 70, "Output",
  CellTags->"S6.2.1"]
}, Open  ]],
Cell[47722, 1779, 148, 4, 70, "MathCaption",
  CellTags->{"S6.2.1", "1.21"}],

Cell[CellGroupData[{
Cell[47895, 1787, 167, 5, 70, "Input",
  CellTags->"S6.2.1"],
Cell[48065, 1794, 3386, 239, 70, 3316, 236, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S6.2.1"],
Cell[51454, 2035, 180, 6, 70, "Output",
  CellTags->"S6.2.1"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

