(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     36640,       2016]*)
(*NotebookOutlinePosition[     40269,       2127]*)
(*  CellTagsIndexPosition[     39979,       2112]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Graphics",
 StyleBox["`", "MB"],
 "ImplicitPlot",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.34.1", "1.1"}],

Cell[TextData[{
 "There are several ways to specify a curve in the plane. A different \
plotting function is used for each of these specifications. Graphs of \
functions are plotted using ",
 StyleBox["Plot", "MR"],
 ". Curves given parametrically are plotted using ",
 StyleBox["ParametricPlot", "MR"],
 ". ",
 StyleBox["ImplicitPlot", "MR"],
 " plots curves that are given implicitly as the solutions to equations. "
}], "Text",
 CellTags->{"S5.34.1", "1.2"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["ImplicitPlot[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["eqn", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xmin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xmax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["plot the solution to ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["eqn", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" using the ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["Solve", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" method, with ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ranging from ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xmin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" to ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xmax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ImplicitPlot[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["eqn", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xmin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["m",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["m",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] , ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xmax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["plot the solution, avoiding the points ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["m",
          "TI"], 
         StyleBox["i",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ImplicitPlot[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["eqn", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xmin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xmax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["y", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ymin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ymax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["plot the solution using the ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ContourPlot", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" method",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ImplicitPlot[{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["eqn",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["eqn",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] }, ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ranges", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["options", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["plot the solutions to the ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["eqn",
          "TI"], 
         StyleBox["i",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.34.1"],

Cell["Plots of curves given implicitly. ", "Caption",
 CellTags->"S5.34.1"],

Cell[TextData[{
 "There are two methods ",
 StyleBox["ImplicitPlot", "MR"],
 " can use to plot the solution to the given equations. The method that is \
used is determined by the form of the variable ranges given. One method uses \
",
 StyleBox["Solve", "MR"],
 " to find solutions to the equation at each point in the ",
 Cell[BoxData[
  FormBox[
   StyleBox["x",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " range. It carefully avoids dangerous points, plotting to within machine \
precision of those points, to generate an apparently smooth graph. This is \
the method used if you just give the range for ",
 Cell[BoxData[
  FormBox[
   StyleBox["x",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". The second method treats the equation as a function in \
three\[Hyphen]dimensional space, and generates a contour of the equation \
cutting through the plane where ",
 Cell[BoxData[
  FormBox[
   StyleBox["z",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " equals zero. This method is faster than the ",
 StyleBox["Solve", "MR"],
 " method and handles a greater variety of cases, but may generate rougher \
graphs, especially around singularities or intersections of the curve. This \
method is used if you specify a range for both ",
 Cell[BoxData[
  FormBox[
   StyleBox["x",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox["y",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "Text",
 CellTags->{"S5.34.1", "1.3"}],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.34.1", "1.4"}],

Cell["<< Graphics`ImplicitPlot`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.34.1"],

Cell[TextData[{
 "This plots an ellipse using the ",
 StyleBox["Solve", "MR"],
 " method. "
}], "MathCaption",
 CellTags->{"S5.34.1", "1.5"}],

Cell[CellGroupData[{

Cell["ImplicitPlot[x^2 + 2 y^2 == 3, {x, -2, 2}]", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.34.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .70711 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.274929 0.353553 0.274929 [
[.08761 .34105 -12 -9 ]
[.08761 .34105 12 0 ]
[.22507 .34105 -6 -9 ]
[.22507 .34105 6 0 ]
[.36254 .34105 -12 -9 ]
[.36254 .34105 12 0 ]
[.63746 .34105 -9 -9 ]
[.63746 .34105 9 0 ]
[.77493 .34105 -3 -9 ]
[.77493 .34105 3 0 ]
[.91239 .34105 -9 -9 ]
[.91239 .34105 9 0 ]
[.4875 .07862 -12 -4.5 ]
[.4875 .07862 0 4.5 ]
[.4875 .21609 -24 -4.5 ]
[.4875 .21609 0 4.5 ]
[.4875 .49102 -18 -4.5 ]
[.4875 .49102 0 4.5 ]
[.4875 .62848 -6 -4.5 ]
[.4875 .62848 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .70711 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.08761 .35355 m
.08761 .3598 L
s
[(-1.5)] .08761 .34105 0 1 Mshowa
.22507 .35355 m
.22507 .3598 L
s
[(-1)] .22507 .34105 0 1 Mshowa
.36254 .35355 m
.36254 .3598 L
s
[(-0.5)] .36254 .34105 0 1 Mshowa
.63746 .35355 m
.63746 .3598 L
s
[(0.5)] .63746 .34105 0 1 Mshowa
.77493 .35355 m
.77493 .3598 L
s
[(1)] .77493 .34105 0 1 Mshowa
.91239 .35355 m
.91239 .3598 L
s
[(1.5)] .91239 .34105 0 1 Mshowa
.125 Mabswid
.1151 .35355 m
.1151 .3573 L
s
.14259 .35355 m
.14259 .3573 L
s
.17009 .35355 m
.17009 .3573 L
s
.19758 .35355 m
.19758 .3573 L
s
.25256 .35355 m
.25256 .3573 L
s
.28006 .35355 m
.28006 .3573 L
s
.30755 .35355 m
.30755 .3573 L
s
.33504 .35355 m
.33504 .3573 L
s
.39003 .35355 m
.39003 .3573 L
s
.41752 .35355 m
.41752 .3573 L
s
.44501 .35355 m
.44501 .3573 L
s
.47251 .35355 m
.47251 .3573 L
s
.52749 .35355 m
.52749 .3573 L
s
.55499 .35355 m
.55499 .3573 L
s
.58248 .35355 m
.58248 .3573 L
s
.60997 .35355 m
.60997 .3573 L
s
.66496 .35355 m
.66496 .3573 L
s
.69245 .35355 m
.69245 .3573 L
s
.71994 .35355 m
.71994 .3573 L
s
.74744 .35355 m
.74744 .3573 L
s
.80242 .35355 m
.80242 .3573 L
s
.82991 .35355 m
.82991 .3573 L
s
.85741 .35355 m
.85741 .3573 L
s
.8849 .35355 m
.8849 .3573 L
s
.06011 .35355 m
.06011 .3573 L
s
.03262 .35355 m
.03262 .3573 L
s
.00513 .35355 m
.00513 .3573 L
s
.93989 .35355 m
.93989 .3573 L
s
.96738 .35355 m
.96738 .3573 L
s
.99487 .35355 m
.99487 .3573 L
s
.25 Mabswid
0 .35355 m
1 .35355 L
s
.5 .07862 m
.50625 .07862 L
s
[(-1)] .4875 .07862 1 0 Mshowa
.5 .21609 m
.50625 .21609 L
s
[(-0.5)] .4875 .21609 1 0 Mshowa
.5 .49102 m
.50625 .49102 L
s
[(0.5)] .4875 .49102 1 0 Mshowa
.5 .62848 m
.50625 .62848 L
s
[(1)] .4875 .62848 1 0 Mshowa
.125 Mabswid
.5 .10612 m
.50375 .10612 L
s
.5 .13361 m
.50375 .13361 L
s
.5 .1611 m
.50375 .1611 L
s
.5 .1886 m
.50375 .1886 L
s
.5 .24358 m
.50375 .24358 L
s
.5 .27107 m
.50375 .27107 L
s
.5 .29857 m
.50375 .29857 L
s
.5 .32606 m
.50375 .32606 L
s
.5 .38105 m
.50375 .38105 L
s
.5 .40854 m
.50375 .40854 L
s
.5 .43603 m
.50375 .43603 L
s
.5 .46352 m
.50375 .46352 L
s
.5 .51851 m
.50375 .51851 L
s
.5 .546 m
.50375 .546 L
s
.5 .5735 m
.50375 .5735 L
s
.5 .60099 m
.50375 .60099 L
s
.5 .05113 m
.50375 .05113 L
s
.5 .02364 m
.50375 .02364 L
s
.5 .65597 m
.50375 .65597 L
s
.5 .68347 m
.50375 .68347 L
s
.25 Mabswid
.5 0 m
.5 .70711 L
s
0 0 m
1 0 L
1 .70711 L
0 .70711 L
closepath
clip
newpath
.5 Mabswid
.02381 .35348 m
.02544 .32575 L
.0303 .29813 L
.03838 .27089 L
.04961 .24422 L
.06392 .2183 L
.0812 .19329 L
.10135 .16939 L
.12422 .14674 L
.14966 .1255 L
.17748 .10582 L
.20752 .08784 L
.23955 .07166 L
.27336 .05742 L
.30872 .0452 L
.34538 .03508 L
.3831 .02714 L
.42162 .02143 L
.46068 .01799 L
.5 .01684 L
.53932 .01799 L
.57838 .02143 L
.6169 .02714 L
.65462 .03508 L
.69128 .0452 L
.72664 .05742 L
.76045 .07166 L
.79248 .08784 L
.82252 .10582 L
.85034 .1255 L
.87578 .14674 L
.89865 .16939 L
.9188 .19329 L
.93608 .2183 L
.95039 .24422 L
.96162 .27089 L
.9697 .29813 L
.97456 .32575 L
.97619 .35348 L
s
.02381 .35363 m
.02544 .38136 L
.0303 .40898 L
.03838 .43621 L
.04961 .46289 L
.06392 .48881 L
.0812 .51381 L
.10135 .53772 L
.12422 .56037 L
.14966 .58161 L
.17748 .60128 L
.20752 .61927 L
.23955 .63544 L
.27336 .64969 L
.30872 .66191 L
.34538 .67203 L
.3831 .67997 L
.42162 .68568 L
.46068 .68912 L
.5 .69027 L
.53932 .68912 L
.57838 .68568 L
.6169 .67997 L
.65462 .67203 L
.69128 .66191 L
.72664 .64969 L
.76045 .63544 L
.79248 .61927 L
.82252 .60128 L
.85034 .58161 L
.87578 .56037 L
.89865 .53772 L
.9188 .51381 L
.93608 .48881 L
.95039 .46289 L
.96162 .43621 L
.9697 .40898 L
.97456 .38136 L
.97619 .35363 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.34.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.34.1"]
}, Open  ]],

Cell[TextData[{
 "Because range specifications for both ",
 Cell[BoxData[
  FormBox[
   StyleBox["x",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox["y",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " are given, the ",
 StyleBox["ContourPlot", "MR"],
 " method is used. "
}], "MathCaption",
 CellTags->{"S5.34.1", "1.6"}],

Cell[CellGroupData[{

Cell["\<\
ImplicitPlot[Sin[2 x] + Cos[3 y] == 1,
    {x, -2 Pi, 2 Pi},{y, -2 Pi, 2 Pi},
 PlotPoints->30]\
\>", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.34.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% ContourGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.0765168 0.5 0.0765168 [
[.0409 -0.0125 -6 -9 ]
[.0409 -0.0125 6 0 ]
[.19393 -0.0125 -6 -9 ]
[.19393 -0.0125 6 0 ]
[.34697 -0.0125 -6 -9 ]
[.34697 -0.0125 6 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.65303 -0.0125 -3 -9 ]
[.65303 -0.0125 3 0 ]
[.80607 -0.0125 -3 -9 ]
[.80607 -0.0125 3 0 ]
[.9591 -0.0125 -3 -9 ]
[.9591 -0.0125 3 0 ]
[-0.0125 .0409 -12 -4.5 ]
[-0.0125 .0409 0 4.5 ]
[-0.0125 .19393 -12 -4.5 ]
[-0.0125 .19393 0 4.5 ]
[-0.0125 .34697 -12 -4.5 ]
[-0.0125 .34697 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .65303 -6 -4.5 ]
[-0.0125 .65303 0 4.5 ]
[-0.0125 .80607 -6 -4.5 ]
[-0.0125 .80607 0 4.5 ]
[-0.0125 .9591 -6 -4.5 ]
[-0.0125 .9591 0 4.5 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.0409 0 m
.0409 .00625 L
s
[(-6)] .0409 -0.0125 0 1 Mshowa
.19393 0 m
.19393 .00625 L
s
[(-4)] .19393 -0.0125 0 1 Mshowa
.34697 0 m
.34697 .00625 L
s
[(-2)] .34697 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(0)] .5 -0.0125 0 1 Mshowa
.65303 0 m
.65303 .00625 L
s
[(2)] .65303 -0.0125 0 1 Mshowa
.80607 0 m
.80607 .00625 L
s
[(4)] .80607 -0.0125 0 1 Mshowa
.9591 0 m
.9591 .00625 L
s
[(6)] .9591 -0.0125 0 1 Mshowa
.125 Mabswid
.07916 0 m
.07916 .00375 L
s
.11742 0 m
.11742 .00375 L
s
.15567 0 m
.15567 .00375 L
s
.23219 0 m
.23219 .00375 L
s
.27045 0 m
.27045 .00375 L
s
.30871 0 m
.30871 .00375 L
s
.38522 0 m
.38522 .00375 L
s
.42348 0 m
.42348 .00375 L
s
.46174 0 m
.46174 .00375 L
s
.53826 0 m
.53826 .00375 L
s
.57652 0 m
.57652 .00375 L
s
.61478 0 m
.61478 .00375 L
s
.69129 0 m
.69129 .00375 L
s
.72955 0 m
.72955 .00375 L
s
.76781 0 m
.76781 .00375 L
s
.84433 0 m
.84433 .00375 L
s
.88258 0 m
.88258 .00375 L
s
.92084 0 m
.92084 .00375 L
s
.00264 0 m
.00264 .00375 L
s
.99736 0 m
.99736 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .0409 m
.00625 .0409 L
s
[(-6)] -0.0125 .0409 1 0 Mshowa
0 .19393 m
.00625 .19393 L
s
[(-4)] -0.0125 .19393 1 0 Mshowa
0 .34697 m
.00625 .34697 L
s
[(-2)] -0.0125 .34697 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(0)] -0.0125 .5 1 0 Mshowa
0 .65303 m
.00625 .65303 L
s
[(2)] -0.0125 .65303 1 0 Mshowa
0 .80607 m
.00625 .80607 L
s
[(4)] -0.0125 .80607 1 0 Mshowa
0 .9591 m
.00625 .9591 L
s
[(6)] -0.0125 .9591 1 0 Mshowa
.125 Mabswid
0 .07916 m
.00375 .07916 L
s
0 .11742 m
.00375 .11742 L
s
0 .15567 m
.00375 .15567 L
s
0 .23219 m
.00375 .23219 L
s
0 .27045 m
.00375 .27045 L
s
0 .30871 m
.00375 .30871 L
s
0 .38522 m
.00375 .38522 L
s
0 .42348 m
.00375 .42348 L
s
0 .46174 m
.00375 .46174 L
s
0 .53826 m
.00375 .53826 L
s
0 .57652 m
.00375 .57652 L
s
0 .61478 m
.00375 .61478 L
s
0 .69129 m
.00375 .69129 L
s
0 .72955 m
.00375 .72955 L
s
0 .76781 m
.00375 .76781 L
s
0 .84433 m
.00375 .84433 L
s
0 .88258 m
.00375 .88258 L
s
0 .92084 m
.00375 .92084 L
s
0 .00264 m
.00375 .00264 L
s
0 .99736 m
.00375 .99736 L
s
.25 Mabswid
0 0 m
0 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 Mabswid
.74867 .80489 m
.78183 .78358 L
.81499 .7823 L
.84814 .80089 L
.85898 .81499 L
.84814 .8402 L
.83884 .84814 L
.81499 .85891 L
.78183 .85773 L
.76215 .84814 L
.74867 .83543 L
.74251 .81499 L
.74867 .80489 L
s
.54973 .78134 m
.57138 .78183 L
.58289 .78515 L
.61605 .80978 L
.61812 .81499 L
.61605 .8291 L
.59846 .84814 L
.58289 .85626 L
.54973 .85981 L
.52164 .84814 L
.51658 .84417 L
.50086 .81499 L
.51658 .79742 L
.5477 .78183 L
.54973 .78134 L
s
.31764 .78038 m
.33097 .78183 L
.3508 .78916 L
.38073 .81499 L
.36159 .84814 L
.3508 .85252 L
.31764 .86072 L
.28448 .85024 L
.2801 .84814 L
.25899 .81499 L
.28448 .7916 L
.30816 .78183 L
.31764 .78038 L
s
.08554 .78071 m
.09127 .78183 L
.1187 .79434 L
.13935 .81499 L
.1187 .84759 L
.11795 .84814 L
.08554 .86042 L
.05239 .85452 L
.03999 .84814 L
.02003 .81499 L
.05239 .78701 L
.06817 .78183 L
.08554 .78071 L
s
.74867 .6439 m
.78183 .62358 L
.81499 .62235 L
.84814 .64012 L
.85653 .6492 L
.84814 .68094 L
.84674 .68236 L
.81499 .70578 L
.78183 .70536 L
.75432 .68236 L
.74867 .67586 L
.74471 .6492 L
.74867 .6439 L
s
.51658 .63683 m
.54973 .62142 L
.58289 .62509 L
.61605 .64844 L
.61643 .6492 L
.61605 .66864 L
.6062 .68236 L
.58289 .70466 L
.54973 .70603 L
.51658 .68802 L
.51363 .68236 L
.5034 .6492 L
.51658 .63683 L
s
.28448 .63128 m
.31764 .62047 L
.3508 .62895 L
.37896 .6492 L
.37046 .68236 L
.3508 .70165 L
.31764 .70625 L
.28448 .69874 L
.27117 .68236 L
.26127 .6492 L
.28448 .63128 L
s
.05239 .62688 m
.08554 .62079 L
.1187 .6339 L
.13686 .6492 L
.12652 .68236 L
.1187 .69436 L
.08554 .70618 L
.05239 .70351 L
.03222 .68236 L
.02242 .6492 L
.05239 .62688 L
s
.74867 .483 m
.78183 .46325 L
.81499 .46206 L
.84814 .47933 L
.85251 .48342 L
.85251 .51658 L
.84814 .52067 L
.81499 .53794 L
.78183 .53675 L
.74867 .517 L
.74831 .51658 L
.74831 .48342 L
.74867 .483 L
s
.51658 .47613 m
.54973 .46115 L
.58289 .46472 L
.61225 .48342 L
.61225 .51658 L
.58289 .53528 L
.54973 .53885 L
.51658 .52387 L
.50761 .51658 L
.50761 .48342 L
.51658 .47613 L
s
.28448 .47074 m
.31764 .46024 L
.3508 .46847 L
.37577 .48342 L
.37577 .51658 L
.3508 .53153 L
.31764 .53976 L
.28448 .52926 L
.26519 .51658 L
.26519 .48342 L
.28448 .47074 L
s
.05239 .46647 m
.08554 .46054 L
.1187 .47329 L
.13266 .48342 L
.13266 .51658 L
.1187 .52671 L
.08554 .53946 L
.05239 .53353 L
.02646 .51658 L
.02646 .48342 L
.05239 .46647 L
s
.78183 .29464 m
.81499 .29422 L
.84674 .31764 L
.84814 .31906 L
.85653 .3508 L
.84814 .35988 L
.81499 .37765 L
.78183 .37642 L
.74867 .3561 L
.74471 .3508 L
.74867 .32414 L
.75432 .31764 L
.78183 .29464 L
s
.51658 .31198 m
.54973 .29397 L
.58289 .29534 L
.6062 .31764 L
.61605 .33136 L
.61643 .3508 L
.61605 .35156 L
.58289 .37491 L
.54973 .37858 L
.51658 .36317 L
.5034 .3508 L
.51363 .31764 L
.51658 .31198 L
s
.28448 .30126 m
.31764 .29375 L
.3508 .29835 L
.37046 .31764 L
.37896 .3508 L
.3508 .37105 L
.31764 .37953 L
.28448 .36872 L
.26127 .3508 L
.27117 .31764 L
.28448 .30126 L
s
.05239 .29649 m
.08554 .29382 L
.1187 .30564 L
.12652 .31764 L
.13686 .3508 L
.1187 .3661 L
.08554 .37921 L
.05239 .37312 L
.02242 .3508 L
.03222 .31764 L
.05239 .29649 L
s
.78183 .14227 m
.81499 .14109 L
.83884 .15186 L
.84814 .1598 L
.85898 .18501 L
.84814 .19911 L
.81499 .2177 L
.78183 .21642 L
.74867 .19511 L
.74251 .18501 L
.74867 .16457 L
.76215 .15186 L
.78183 .14227 L
s
.54973 .14019 m
.58289 .14374 L
.59846 .15186 L
.61605 .1709 L
.61812 .18501 L
.61605 .19022 L
.58289 .21485 L
.57138 .21817 L
.54973 .21866 L
.5477 .21817 L
.51658 .20258 L
.50086 .18501 L
.51658 .15583 L
.52164 .15186 L
.54973 .14019 L
s
.28448 .14976 m
.31764 .13928 L
.3508 .14748 L
.36159 .15186 L
.38073 .18501 L
.3508 .21084 L
.33097 .21817 L
.31764 .21962 L
.30816 .21817 L
.28448 .2084 L
.25899 .18501 L
.2801 .15186 L
.28448 .14976 L
s
.05239 .14548 m
.08554 .13958 L
.11795 .15186 L
.1187 .15241 L
.13935 .18501 L
.1187 .20566 L
.09127 .21817 L
.08554 .21929 L
.06817 .21817 L
.05239 .21299 L
.02003 .18501 L
.03999 .15186 L
.05239 .14548 L
s
.85981 .98077 m
.84814 .96019 L
.82866 .94761 L
.81499 .9423 L
.78183 .94352 L
.77219 .94761 L
.74867 .96416 L
.74177 .98077 L
s
.61869 .98077 m
.61605 .9692 L
.58853 .94761 L
.58289 .94502 L
.54973 .94138 L
.53198 .94761 L
.51658 .9568 L
.5 .98077 L
s
.38131 .98077 m
.3508 .94885 L
.34819 .94761 L
.31764 .94045 L
.29145 .94761 L
.28448 .95119 L
.25823 .98077 L
s
.01923 .98077 m
.05055 .94761 L
.05239 .9468 L
.08554 .94077 L
.10747 .94761 L
.1187 .95383 L
.14019 .98077 L
s
.85981 .01923 m
.84814 .03981 L
.82866 .05239 L
.81499 .0577 L
.78183 .05648 L
.77219 .05239 L
.74867 .03584 L
.74177 .01923 L
s
.61869 .01923 m
.61605 .0308 L
.58853 .05239 L
.58289 .05498 L
.54973 .05862 L
.53198 .05239 L
.51658 .0432 L
.5 .01923 L
s
.38131 .01923 m
.3508 .05115 L
.34819 .05239 L
.31764 .05955 L
.29145 .05239 L
.28448 .04881 L
.25823 .01923 L
s
.01923 .01923 m
.05055 .05239 L
.05239 .0532 L
.08554 .05923 L
.10747 .05239 L
.1187 .04617 L
.14019 .01923 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.34.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "ContourGraphics", "\[SkeletonIndicator]"}],
  
  False,
  Editable->False]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.34.1"]
}, Open  ]],

Cell[TextData[{
 "Both methods can accept standard graphics options; the ",
 StyleBox["Solve", "MR"],
 " method accepts the options of ",
 StyleBox["Plot", "MR"],
 ", while the ",
 StyleBox["ContourPlot", "MR"],
 " method accepts ",
 StyleBox["ContourPlot", "MR"],
 " options. "
}], "Text",
 CellTags->{"S5.34.1", "1.7"}],

Cell["Here multiple curves are displayed. ", "MathCaption",
 CellTags->{"S5.34.1", "1.8"}],

Cell[CellGroupData[{

Cell["\<\
ImplicitPlot[{(x^2 + y^2)^2 == (x^2 - y^2),
 (x^2 + y^2)^2 == 2 x y}, {x,-2,2},
 PlotStyle->{GrayLevel[0],Dashing[{.03}]}]\
\>", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.34.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .80591 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.47619 0.402953 0.47619 [
[.02381 .39045 -6 -9 ]
[.02381 .39045 6 0 ]
[.2619 .39045 -12 -9 ]
[.2619 .39045 12 0 ]
[.7381 .39045 -9 -9 ]
[.7381 .39045 9 0 ]
[.97619 .39045 -3 -9 ]
[.97619 .39045 3 0 ]
[.4875 .04581 -30 -4.5 ]
[.4875 .04581 0 4.5 ]
[.4875 .16486 -24 -4.5 ]
[.4875 .16486 0 4.5 ]
[.4875 .28391 -30 -4.5 ]
[.4875 .28391 0 4.5 ]
[.4875 .522 -24 -4.5 ]
[.4875 .522 0 4.5 ]
[.4875 .64105 -18 -4.5 ]
[.4875 .64105 0 4.5 ]
[.4875 .7601 -24 -4.5 ]
[.4875 .7601 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .80591 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .40295 m
.02381 .4092 L
s
[(-1)] .02381 .39045 0 1 Mshowa
.2619 .40295 m
.2619 .4092 L
s
[(-0.5)] .2619 .39045 0 1 Mshowa
.7381 .40295 m
.7381 .4092 L
s
[(0.5)] .7381 .39045 0 1 Mshowa
.97619 .40295 m
.97619 .4092 L
s
[(1)] .97619 .39045 0 1 Mshowa
.125 Mabswid
.07143 .40295 m
.07143 .4067 L
s
.11905 .40295 m
.11905 .4067 L
s
.16667 .40295 m
.16667 .4067 L
s
.21429 .40295 m
.21429 .4067 L
s
.30952 .40295 m
.30952 .4067 L
s
.35714 .40295 m
.35714 .4067 L
s
.40476 .40295 m
.40476 .4067 L
s
.45238 .40295 m
.45238 .4067 L
s
.54762 .40295 m
.54762 .4067 L
s
.59524 .40295 m
.59524 .4067 L
s
.64286 .40295 m
.64286 .4067 L
s
.69048 .40295 m
.69048 .4067 L
s
.78571 .40295 m
.78571 .4067 L
s
.83333 .40295 m
.83333 .4067 L
s
.88095 .40295 m
.88095 .4067 L
s
.92857 .40295 m
.92857 .4067 L
s
.25 Mabswid
0 .40295 m
1 .40295 L
s
.5 .04581 m
.50625 .04581 L
s
[(-0.75)] .4875 .04581 1 0 Mshowa
.5 .16486 m
.50625 .16486 L
s
[(-0.5)] .4875 .16486 1 0 Mshowa
.5 .28391 m
.50625 .28391 L
s
[(-0.25)] .4875 .28391 1 0 Mshowa
.5 .522 m
.50625 .522 L
s
[(0.25)] .4875 .522 1 0 Mshowa
.5 .64105 m
.50625 .64105 L
s
[(0.5)] .4875 .64105 1 0 Mshowa
.5 .7601 m
.50625 .7601 L
s
[(0.75)] .4875 .7601 1 0 Mshowa
.125 Mabswid
.5 .06962 m
.50375 .06962 L
s
.5 .09343 m
.50375 .09343 L
s
.5 .11724 m
.50375 .11724 L
s
.5 .14105 m
.50375 .14105 L
s
.5 .18867 m
.50375 .18867 L
s
.5 .21248 m
.50375 .21248 L
s
.5 .23629 m
.50375 .23629 L
s
.5 .2601 m
.50375 .2601 L
s
.5 .30771 m
.50375 .30771 L
s
.5 .33152 m
.50375 .33152 L
s
.5 .35533 m
.50375 .35533 L
s
.5 .37914 m
.50375 .37914 L
s
.5 .42676 m
.50375 .42676 L
s
.5 .45057 m
.50375 .45057 L
s
.5 .47438 m
.50375 .47438 L
s
.5 .49819 m
.50375 .49819 L
s
.5 .54581 m
.50375 .54581 L
s
.5 .56962 m
.50375 .56962 L
s
.5 .59343 m
.50375 .59343 L
s
.5 .61724 m
.50375 .61724 L
s
.5 .66486 m
.50375 .66486 L
s
.5 .68867 m
.50375 .68867 L
s
.5 .71248 m
.50375 .71248 L
s
.5 .73629 m
.50375 .73629 L
s
.5 .022 m
.50375 .022 L
s
.5 .78391 m
.50375 .78391 L
s
.25 Mabswid
.5 0 m
.5 .80591 L
s
0 0 m
1 0 L
1 .80591 L
0 .80591 L
closepath
clip
newpath
.5 Mabswid
.02381 .40287 m
.02462 .3869 L
.02706 .371 L
.0311 .35537 L
.03671 .34017 L
.04386 .32552 L
.05251 .31157 L
.06258 .29843 L
.07401 .28623 L
.08673 .27509 L
.10065 .26512 L
.11566 .25641 L
.13168 .24905 L
.14858 .24314 L
.16626 .23873 L
.1846 .23588 L
.20346 .23465 L
.22272 .23505 L
.24224 .23708 L
.2619 .24075 L
.28157 .24601 L
.30109 .25279 L
.32035 .26099 L
.33921 .27049 L
.35755 .2811 L
.37523 .29262 L
.39213 .30477 L
.40815 .31728 L
.42316 .32984 L
.43708 .34212 L
.4498 .35383 L
.46123 .36469 L
.4713 .37446 L
.47995 .38297 L
.4871 .39007 L
.49271 .39567 L
.49675 .39971 L
.49919 .40214 L
.5 .40295 L
s
.02381 .40303 m
.02462 .419 L
.02706 .43491 L
.0311 .45053 L
.03671 .46574 L
.04386 .48038 L
.05251 .49434 L
.06258 .50747 L
.07401 .51967 L
.08673 .53081 L
.10065 .54079 L
.11566 .5495 L
.13168 .55685 L
.14858 .56277 L
.16626 .56718 L
.1846 .57002 L
.20346 .57126 L
.22272 .57086 L
.24224 .56882 L
.2619 .56516 L
.28157 .5599 L
.30109 .55312 L
.32035 .54491 L
.33921 .53541 L
.35755 .5248 L
.37523 .51329 L
.39213 .50113 L
.40815 .48862 L
.42316 .47607 L
.43708 .46378 L
.4498 .45208 L
.46123 .44122 L
.4713 .43144 L
.47995 .42294 L
.4871 .41583 L
.49271 .41023 L
.49675 .4062 L
.49919 .40377 L
.5 .40295 L
s
.5 .40295 m
.50081 .40214 L
.50325 .39971 L
.50729 .39567 L
.5129 .39007 L
.52005 .38297 L
.5287 .37446 L
.53877 .36469 L
.5502 .35383 L
.56292 .34212 L
.57684 .32984 L
.59185 .31728 L
.60787 .30477 L
.62477 .29262 L
.64245 .2811 L
.66079 .27049 L
.67965 .26099 L
.69891 .25279 L
.71843 .24601 L
.7381 .24075 L
.75776 .23708 L
.77728 .23505 L
.79654 .23465 L
.8154 .23588 L
.83374 .23873 L
.85142 .24314 L
.86832 .24905 L
.88434 .25641 L
.89935 .26512 L
.91327 .27509 L
.92599 .28623 L
.93742 .29843 L
.94749 .31157 L
.95614 .32552 L
.96329 .34017 L
.9689 .35537 L
.97294 .371 L
.97538 .3869 L
.97619 .40287 L
s
.5 .40295 m
.50081 .40377 L
.50325 .4062 L
.50729 .41023 L
.5129 .41583 L
.52005 .42294 L
.5287 .43144 L
.53877 .44122 L
.5502 .45208 L
.56292 .46378 L
.57684 .47607 L
.59185 .48862 L
.60787 .50113 L
.62477 .51329 L
.64245 .5248 L
.66079 .53541 L
.67965 .54491 L
.69891 .55312 L
.71843 .5599 L
.7381 .56516 L
.75776 .56882 L
.77728 .57086 L
.79654 .57126 L
.8154 .57002 L
.83374 .56718 L
.85142 .56277 L
.86832 .55685 L
.88434 .5495 L
.89935 .54079 L
.91327 .53081 L
.92599 .51967 L
.93742 .50747 L
.94749 .49434 L
.95614 .48038 L
.96329 .46574 L
.9689 .45053 L
.97294 .43491 L
.97538 .419 L
.97619 .40303 L
s
[ .03 ] 0 setdash
.11623 .1813 m
.11688 .16648 L
.11884 .15177 L
.1221 .13736 L
.12662 .12334 L
.13239 .10982 L
.13935 .0969 L
.14747 .08467 L
.15669 .07324 L
.16694 .0627 L
.17815 .05312 L
.19025 .04459 L
.20316 .03718 L
.21678 .03097 L
.23103 .02601 L
.24581 .02236 L
.26101 .02008 L
.27653 .01919 L
.29227 .01974 L
.30811 .02175 L
.32396 .02525 L
.3397 .03024 L
.35522 .03675 L
.37042 .04477 L
.38519 .05431 L
.39944 .06536 L
.41307 .07792 L
.42597 .09199 L
.43807 .10758 L
.44929 .1247 L
.45954 .14338 L
.46875 .16368 L
.47687 .18569 L
.48384 .2096 L
.4896 .2357 L
.49413 .26451 L
.49738 .29712 L
.49934 .33622 L
.5 .4009 L
s
.11623 .18146 m
.11688 .19636 L
.11884 .21132 L
.1221 .22617 L
.12662 .24079 L
.13239 .25511 L
.13935 .26903 L
.14747 .28246 L
.15669 .29533 L
.16694 .30757 L
.17815 .31913 L
.19025 .32994 L
.20316 .33997 L
.21678 .34919 L
.23103 .35757 L
.24581 .36511 L
.26101 .37182 L
.27653 .37771 L
.29227 .38281 L
.30811 .38716 L
.32396 .39081 L
.3397 .39381 L
.35522 .39623 L
.37042 .39814 L
.38519 .39961 L
.39944 .40071 L
.41307 .4015 L
.42597 .40206 L
.43807 .40243 L
.44929 .40267 L
.45954 .40281 L
.46875 .40289 L
.47687 .40293 L
.48384 .40294 L
.4896 .40295 L
.49413 .40295 L
.49738 .40295 L
.49934 .40295 L
.5 .40295 L
s
.5 .40295 m
.50066 .40295 L
.50262 .40295 L
.50587 .40295 L
.5104 .40296 L
.51616 .40296 L
.52313 .40298 L
.53125 .40302 L
.54046 .4031 L
.55071 .40324 L
.56193 .40348 L
.57403 .40385 L
.58693 .4044 L
.60056 .4052 L
.61481 .40629 L
.62958 .40776 L
.64478 .40967 L
.6603 .4121 L
.67604 .4151 L
.69189 .41874 L
.70773 .42309 L
.72347 .42819 L
.73899 .43408 L
.75419 .44079 L
.76897 .44834 L
.78322 .45672 L
.79684 .46594 L
.80975 .47597 L
.82185 .48678 L
.83306 .49833 L
.84331 .51057 L
.85253 .52345 L
.86065 .53688 L
.86761 .55079 L
.87338 .56511 L
.8779 .57974 L
.88116 .59458 L
.88312 .60954 L
.88377 .62444 L
s
.5 .405 m
.50066 .46969 L
.50262 .50879 L
.50587 .54139 L
.5104 .57021 L
.51616 .5963 L
.52313 .62021 L
.53125 .64223 L
.54046 .66253 L
.55071 .6812 L
.56193 .69832 L
.57403 .71391 L
.58693 .72798 L
.60056 .74054 L
.61481 .75159 L
.62958 .76113 L
.64478 .76915 L
.6603 .77566 L
.67604 .78066 L
.69189 .78416 L
.70773 .78617 L
.72347 .78672 L
.73899 .78583 L
.75419 .78354 L
.76897 .77989 L
.78322 .77494 L
.79684 .76872 L
.80975 .76132 L
.82185 .75279 L
.83306 .74321 L
.84331 .73266 L
.85253 .72123 L
.86065 .70901 L
.86761 .69609 L
.87338 .68257 L
.8779 .66855 L
.88116 .65413 L
.88312 .63942 L
.88377 .62461 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.34.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.34.1"]
}, Open  ]],

Cell[TextData[{
 "You can find other interesting examples of using a contour plot to do \
implicit plotting in the book ",
 StyleBox["Exploring Mathematics with Mathematica", "TI"],
 ", by Theodore Gray and Jerry Glynn (Addison\[Hyphen]Wesley, 1991). "
}], "Text",
 CellTags->{"S5.34.1", "1.9"}]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.34.1"->{
    Cell[1776, 53, 137, 6, 36, "Subsection",
      CellTags->{"S5.34.1", "1.1"}],
    Cell[1916, 61, 461, 11, 72, "Text",
      CellTags->{"S5.34.1", "1.2"}],
    Cell[2380, 74, 8683, 272, 180, "DefinitionBox",
      CellTags->"S5.34.1"],
    Cell[11066, 348, 75, 1, 15, "Caption",
      CellTags->"S5.34.1"],
    Cell[11144, 351, 1716, 47, 152, "Text",
      CellTags->{"S5.34.1", "1.3"}],
    Cell[12863, 400, 78, 1, 40, "MathCaption",
      CellTags->{"S5.34.1", "1.4"}],
    Cell[12944, 403, 88, 2, 28, "Input",
      CellTags->"S5.34.1"],
    Cell[13035, 407, 141, 5, 38, "MathCaption",
      CellTags->{"S5.34.1", "1.5"}],
    Cell[13201, 416, 105, 2, 28, "Input",
      CellTags->"S5.34.1"],
    Cell[13309, 420, 4696, 343, 186, 4625, 340, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.34.1"],
    Cell[18008, 765, 180, 6, 70, "Output",
      CellTags->"S5.34.1"],
    Cell[18203, 774, 464, 17, 70, "MathCaption",
      CellTags->{"S5.34.1", "1.6"}],
    Cell[18692, 795, 165, 6, 70, "Input",
      CellTags->"S5.34.1"],
    Cell[18860, 803, 8333, 595, 70, 8262, 592, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.34.1"],
    Cell[27196, 1400, 190, 7, 70, "Output",
      CellTags->"S5.34.1"],
    Cell[27401, 1410, 321, 11, 70, "Text",
      CellTags->{"S5.34.1", "1.7"}],
    Cell[27725, 1423, 90, 1, 70, "MathCaption",
      CellTags->{"S5.34.1", "1.8"}],
    Cell[27840, 1428, 193, 6, 70, "Input",
      CellTags->"S5.34.1"],
    Cell[28036, 1436, 8095, 560, 70, 8024, 557, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.34.1"],
    Cell[36134, 1998, 180, 6, 70, "Output",
      CellTags->"S5.34.1"],
    Cell[36329, 2007, 295, 6, 70, "Text",
      CellTags->{"S5.34.1", "1.9"}]},
  "1.1"->{
    Cell[1776, 53, 137, 6, 36, "Subsection",
      CellTags->{"S5.34.1", "1.1"}]},
  "1.2"->{
    Cell[1916, 61, 461, 11, 72, "Text",
      CellTags->{"S5.34.1", "1.2"}]},
  "1.3"->{
    Cell[11144, 351, 1716, 47, 152, "Text",
      CellTags->{"S5.34.1", "1.3"}]},
  "1.4"->{
    Cell[12863, 400, 78, 1, 40, "MathCaption",
      CellTags->{"S5.34.1", "1.4"}]},
  "1.5"->{
    Cell[13035, 407, 141, 5, 38, "MathCaption",
      CellTags->{"S5.34.1", "1.5"}]},
  "1.6"->{
    Cell[18203, 774, 464, 17, 70, "MathCaption",
      CellTags->{"S5.34.1", "1.6"}]},
  "1.7"->{
    Cell[27401, 1410, 321, 11, 70, "Text",
      CellTags->{"S5.34.1", "1.7"}]},
  "1.8"->{
    Cell[27725, 1423, 90, 1, 70, "MathCaption",
      CellTags->{"S5.34.1", "1.8"}]},
  "1.9"->{
    Cell[36329, 2007, 295, 6, 70, "Text",
      CellTags->{"S5.34.1", "1.9"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.34.1", 37263, 2032},
  {"1.1", 39118, 2081},
  {"1.2", 39212, 2084},
  {"1.3", 39301, 2087},
  {"1.4", 39394, 2090},
  {"1.5", 39490, 2093},
  {"1.6", 39587, 2096},
  {"1.7", 39685, 2099},
  {"1.8", 39777, 2102},
  {"1.9", 39874, 2105}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 137, 6, 36, "Subsection",
  CellTags->{"S5.34.1", "1.1"}],
Cell[1916, 61, 461, 11, 72, "Text",
  CellTags->{"S5.34.1", "1.2"}],
Cell[2380, 74, 8683, 272, 180, "DefinitionBox",
  CellTags->"S5.34.1"],
Cell[11066, 348, 75, 1, 15, "Caption",
  CellTags->"S5.34.1"],
Cell[11144, 351, 1716, 47, 152, "Text",
  CellTags->{"S5.34.1", "1.3"}],
Cell[12863, 400, 78, 1, 40, "MathCaption",
  CellTags->{"S5.34.1", "1.4"}],
Cell[12944, 403, 88, 2, 28, "Input",
  CellTags->"S5.34.1"],
Cell[13035, 407, 141, 5, 38, "MathCaption",
  CellTags->{"S5.34.1", "1.5"}],

Cell[CellGroupData[{
Cell[13201, 416, 105, 2, 28, "Input",
  CellTags->"S5.34.1"],
Cell[13309, 420, 4696, 343, 186, 4625, 340, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.34.1"],
Cell[18008, 765, 180, 6, 70, "Output",
  CellTags->"S5.34.1"]
}, Open  ]],
Cell[18203, 774, 464, 17, 70, "MathCaption",
  CellTags->{"S5.34.1", "1.6"}],

Cell[CellGroupData[{
Cell[18692, 795, 165, 6, 70, "Input",
  CellTags->"S5.34.1"],
Cell[18860, 803, 8333, 595, 70, 8262, 592, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.34.1"],
Cell[27196, 1400, 190, 7, 70, "Output",
  CellTags->"S5.34.1"]
}, Open  ]],
Cell[27401, 1410, 321, 11, 70, "Text",
  CellTags->{"S5.34.1", "1.7"}],
Cell[27725, 1423, 90, 1, 70, "MathCaption",
  CellTags->{"S5.34.1", "1.8"}],

Cell[CellGroupData[{
Cell[27840, 1428, 193, 6, 70, "Input",
  CellTags->"S5.34.1"],
Cell[28036, 1436, 8095, 560, 70, 8024, 557, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.34.1"],
Cell[36134, 1998, 180, 6, 70, "Output",
  CellTags->"S5.34.1"]
}, Open  ]],
Cell[36329, 2007, 295, 6, 70, "Text",
  CellTags->{"S5.34.1", "1.9"}]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

