(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   1028383,      59856]*)
(*NotebookOutlinePosition[   1036942,      60094]*)
(*  CellTagsIndexPosition[   1036454,      60073]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Graphics",
 StyleBox["`", "MB"],
 "InequalityGraphics",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.35.1", "1.1"}],

Cell["\<\
This package provides functions for visualizing logical combinations of \
inequalities over the reals in 2D and 3D. It also provides functionality for \
visualizing regions over the complexes. \
\>", "Text",
 CellTags->{"S5.35.1", "1.2"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["InequalityPlot[ ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ineqs", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xmin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xmax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["y", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ymin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ymax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "construct a graphical representation of the set of inequalities ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ineqs", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" in 2D",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["InequalityPlot3D[ ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ineqs", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xmin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xmax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["y", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ymin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ymax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["z", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["zmin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["zmax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "construct a graphical representation of the set of inequalities ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ineqs", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" in 3D ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.35.1"],

Cell["Visualization of inequalities. ", "Caption",
 CellTags->"S5.35.1"],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.35.1", "1.3"}],

Cell["<<Graphics`InequalityGraphics`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.35.1"],

Cell[TextData[{
 "This plots the region ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "\[LessEqual]", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       StyleBox["x",
        "TI"], "+", "2", 
       StyleBox["y",
        "TI"]}], ")"}], "2"], "+", "4", 
    SuperscriptBox[
     StyleBox["y",
      "TI"], "2"], "\[LessEqual]", "4"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.35.1", "1.4"}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InequalityPlot", "[", " ", 
  RowBox[{
   RowBox[{"1", "\[LessEqual]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"x", "+", 
        RowBox[{"2", "y"}]}], ")"}], "2"], "+", 
     RowBox[{"4", 
      SuperscriptBox["y", "2"]}]}], "\[LessEqual]", "4"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", 
     RowBox[{"-", "3"}], ",", " ", "3"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"y", ",", " ", 
     RowBox[{"-", "3"}], ",", " ", "3"}], "}"}]}], " ", "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.35.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .35355 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.353553 [
[ 0 0 0 0 ]
[ 1 .35355 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .35355 L
0 .35355 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.353553 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.168359 0.176777 0.168359 [
[.16328 .16428 -6 -9 ]
[.16328 .16428 6 0 ]
[.33164 .16428 -6 -9 ]
[.33164 .16428 6 0 ]
[.66836 .16428 -3 -9 ]
[.66836 .16428 3 0 ]
[.83672 .16428 -3 -9 ]
[.83672 .16428 3 0 ]
[.4875 .00842 -12 -4.5 ]
[.4875 .00842 0 4.5 ]
[.4875 .0926 -24 -4.5 ]
[.4875 .0926 0 4.5 ]
[.4875 .26096 -18 -4.5 ]
[.4875 .26096 0 4.5 ]
[.4875 .34514 -6 -4.5 ]
[.4875 .34514 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .35355 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.16328 .17678 m
.16328 .18303 L
s
[(-2)] .16328 .16428 0 1 Mshowa
.33164 .17678 m
.33164 .18303 L
s
[(-1)] .33164 .16428 0 1 Mshowa
.66836 .17678 m
.66836 .18303 L
s
[(1)] .66836 .16428 0 1 Mshowa
.83672 .17678 m
.83672 .18303 L
s
[(2)] .83672 .16428 0 1 Mshowa
.125 Mabswid
.0286 .17678 m
.0286 .18053 L
s
.06227 .17678 m
.06227 .18053 L
s
.09594 .17678 m
.09594 .18053 L
s
.12961 .17678 m
.12961 .18053 L
s
.19695 .17678 m
.19695 .18053 L
s
.23063 .17678 m
.23063 .18053 L
s
.2643 .17678 m
.2643 .18053 L
s
.29797 .17678 m
.29797 .18053 L
s
.36531 .17678 m
.36531 .18053 L
s
.39898 .17678 m
.39898 .18053 L
s
.43266 .17678 m
.43266 .18053 L
s
.46633 .17678 m
.46633 .18053 L
s
.53367 .17678 m
.53367 .18053 L
s
.56734 .17678 m
.56734 .18053 L
s
.60102 .17678 m
.60102 .18053 L
s
.63469 .17678 m
.63469 .18053 L
s
.70203 .17678 m
.70203 .18053 L
s
.7357 .17678 m
.7357 .18053 L
s
.76937 .17678 m
.76937 .18053 L
s
.80305 .17678 m
.80305 .18053 L
s
.87039 .17678 m
.87039 .18053 L
s
.90406 .17678 m
.90406 .18053 L
s
.93773 .17678 m
.93773 .18053 L
s
.9714 .17678 m
.9714 .18053 L
s
.25 Mabswid
0 .17678 m
1 .17678 L
s
.5 .00842 m
.50625 .00842 L
s
[(-1)] .4875 .00842 1 0 Mshowa
.5 .0926 m
.50625 .0926 L
s
[(-0.5)] .4875 .0926 1 0 Mshowa
.5 .26096 m
.50625 .26096 L
s
[(0.5)] .4875 .26096 1 0 Mshowa
.5 .34514 m
.50625 .34514 L
s
[(1)] .4875 .34514 1 0 Mshowa
.125 Mabswid
.5 .02525 m
.50375 .02525 L
s
.5 .04209 m
.50375 .04209 L
s
.5 .05893 m
.50375 .05893 L
s
.5 .07576 m
.50375 .07576 L
s
.5 .10943 m
.50375 .10943 L
s
.5 .12627 m
.50375 .12627 L
s
.5 .1431 m
.50375 .1431 L
s
.5 .15994 m
.50375 .15994 L
s
.5 .19361 m
.50375 .19361 L
s
.5 .21045 m
.50375 .21045 L
s
.5 .22728 m
.50375 .22728 L
s
.5 .24412 m
.50375 .24412 L
s
.5 .27779 m
.50375 .27779 L
s
.5 .29463 m
.50375 .29463 L
s
.5 .31146 m
.50375 .31146 L
s
.5 .3283 m
.50375 .3283 L
s
.25 Mabswid
.5 0 m
.5 .35355 L
s
0 0 m
1 0 L
1 .35355 L
0 .35355 L
closepath
clip
newpath
.5 Mabswid
.02381 .2958 m
.0241 .29157 L
.02437 .28991 L
.02497 .28722 L
.02605 .28372 L
.02851 .27796 L
.03347 .26955 L
.044 .25648 L
.05398 .24658 L
.06359 .23825 L
.0738 .23022 L
.08364 .22309 L
.0931 .21666 L
.10317 .21018 L
.11287 .20424 L
.12317 .1982 L
.1331 .19261 L
.14265 .18743 L
.15281 .1821 L
.16259 .17712 L
.17299 .17199 L
.183 .16719 L
.19264 .16269 L
.20289 .15802 L
.21276 .15363 L
.22226 .14951 L
.23236 .14522 L
.24209 .14118 L
.25243 .13698 L
.2619 .1332 L
s
.02381 .29585 m
.0241 .29993 L
.02437 .30146 L
.02468 .3028 L
.02497 .30384 L
.02605 .30681 L
.02723 .30922 L
.02851 .31134 L
.03347 .31727 L
.03613 .31965 L
.03895 .32182 L
.044 .32508 L
.05346 .32976 L
.06353 .33349 L
.07323 .33628 L
.08353 .33862 L
.09346 .3404 L
.10301 .34177 L
.11317 .34291 L
.12295 .34375 L
.12794 .34409 L
.13335 .3444 L
.13812 .34463 L
.14336 .34482 L
.14835 .34496 L
.15107 .34502 L
.15361 .34506 L
.15487 .34508 L
.15623 .3451 L
.15743 .34511 L
.1587 .34512 L
.15985 .34513 L
.1605 .34513 L
.16111 .34513 L
.16167 .34513 L
.16218 .34513 L
.16245 .34513 L
.16275 .34514 L
.16306 .34514 L
.16334 .34514 L
.16366 .34514 L
.16382 .34514 L
.164 .34514 L
.16431 .34513 L
.1646 .34513 L
.16526 .34513 L
.16597 .34513 L
.16664 .34513 L
.16727 .34512 L
.16846 .34512 L
Mistroke
.17068 .3451 L
.1731 .34507 L
.17803 .34498 L
.18328 .34485 L
.19369 .3445 L
.20372 .34405 L
.21337 .3435 L
.22363 .34282 L
.23351 .34206 L
.24302 .34125 L
.25314 .34029 L
.2619 .3394 L
Mfstroke
0 1 1 r
.02381 .2958 m
.0241 .29157 L
.02437 .28991 L
.02497 .28722 L
.02605 .28372 L
.02851 .27796 L
.03347 .26955 L
.044 .25648 L
.05398 .24658 L
.06359 .23825 L
.0738 .23022 L
.08364 .22309 L
.0931 .21666 L
.10317 .21018 L
.11287 .20424 L
.12317 .1982 L
.1331 .19261 L
.14265 .18743 L
.15281 .1821 L
.16259 .17712 L
.17299 .17199 L
.183 .16719 L
.19264 .16269 L
.20289 .15802 L
.21276 .15363 L
.22226 .14951 L
.23236 .14522 L
.24209 .14118 L
.25243 .13698 L
.2619 .1332 L
.2619 .3394 L
.25314 .34029 L
.24302 .34125 L
.23351 .34206 L
.22363 .34282 L
.21337 .3435 L
.20372 .34405 L
.19369 .3445 L
.18328 .34485 L
.17803 .34498 L
.1731 .34507 L
.17068 .3451 L
.16846 .34512 L
.16727 .34512 L
.16664 .34513 L
.16597 .34513 L
.16526 .34513 L
.1646 .34513 L
.16431 .34513 L
.164 .34514 L
.16382 .34514 L
.16366 .34514 L
.16334 .34514 L
.16306 .34514 L
.16275 .34514 L
.16245 .34513 L
.16218 .34513 L
.16167 .34513 L
.16111 .34513 L
.1605 .34513 L
.15985 .34513 L
.1587 .34512 L
.15743 .34511 L
.15623 .3451 L
.15487 .34508 L
.15361 .34506 L
.15107 .34502 L
.14835 .34496 L
.14336 .34482 L
.13812 .34463 L
.13335 .3444 L
.12794 .34409 L
.12295 .34375 L
.11317 .34291 L
.10301 .34177 L
.09346 .3404 L
.08353 .33862 L
.07323 .33628 L
.06353 .33349 L
.05346 .32976 L
.044 .32508 L
.03895 .32182 L
.03613 .31965 L
.03347 .31727 L
.02851 .31134 L
.02723 .30922 L
.02605 .30681 L
.02497 .30384 L
.02468 .3028 L
.02437 .30146 L
.0241 .29993 L
.02381 .29585 L
F
0 g
.02381 .2958 m
.0241 .29157 L
.02437 .28991 L
.02497 .28722 L
.02605 .28372 L
.02851 .27796 L
.03347 .26955 L
.044 .25648 L
.05398 .24658 L
.06359 .23825 L
.0738 .23022 L
.08364 .22309 L
.0931 .21666 L
.10317 .21018 L
.11287 .20424 L
.12317 .1982 L
.1331 .19261 L
.14265 .18743 L
.15281 .1821 L
.16259 .17712 L
.17299 .17199 L
.183 .16719 L
.19264 .16269 L
.20289 .15802 L
.21276 .15363 L
.22226 .14951 L
.23236 .14522 L
.24209 .14118 L
.25243 .13698 L
.2619 .1332 L
s
.02381 .29585 m
.0241 .29993 L
.02437 .30146 L
.02468 .3028 L
.02497 .30384 L
.02605 .30681 L
.02723 .30922 L
.02851 .31134 L
.03347 .31727 L
.03613 .31965 L
.03895 .32182 L
.044 .32508 L
.05346 .32976 L
.06353 .33349 L
.07323 .33628 L
.08353 .33862 L
.09346 .3404 L
.10301 .34177 L
.11317 .34291 L
.12295 .34375 L
.12794 .34409 L
.13335 .3444 L
.13812 .34463 L
.14336 .34482 L
.14835 .34496 L
.15107 .34502 L
.15361 .34506 L
.15487 .34508 L
.15623 .3451 L
.15743 .34511 L
.1587 .34512 L
.15985 .34513 L
.1605 .34513 L
.16111 .34513 L
.16167 .34513 L
.16218 .34513 L
.16245 .34513 L
.16275 .34514 L
.16306 .34514 L
.16334 .34514 L
.16366 .34514 L
.16382 .34514 L
.164 .34514 L
.16431 .34513 L
.1646 .34513 L
.16526 .34513 L
.16597 .34513 L
.16664 .34513 L
.16727 .34512 L
.16846 .34512 L
Mistroke
.17068 .3451 L
.1731 .34507 L
.17803 .34498 L
.18328 .34485 L
.19369 .3445 L
.20372 .34405 L
.21337 .3435 L
.22363 .34282 L
.23351 .34206 L
.24302 .34125 L
.25314 .34029 L
.2619 .3394 L
Mfstroke
.2619 .23632 m
.26249 .24033 L
.26303 .24179 L
.26364 .24305 L
.26423 .24402 L
.26639 .24668 L
.26875 .24876 L
.27131 .25051 L
.27646 .25316 L
.28122 .25496 L
.28609 .25639 L
.29145 .25763 L
.29705 .25864 L
.30229 .25937 L
.30748 .25993 L
.31241 .26033 L
.31684 .2606 L
.31935 .26071 L
.32168 .2608 L
.32421 .26087 L
.32564 .2609 L
.32696 .26092 L
.32811 .26094 L
.32877 .26094 L
.32938 .26095 L
.33003 .26095 L
.33061 .26095 L
.33094 .26096 L
.33129 .26096 L
.33194 .26096 L
.33251 .26095 L
.33305 .26095 L
.33364 .26095 L
.33428 .26095 L
.33558 .26093 L
.33677 .26092 L
.33895 .26088 L
.34124 .26083 L
.34601 .26067 L
.35111 .26045 L
.36029 .2599 L
.37097 .25906 L
.38104 .25808 L
.40028 .25576 L
.42074 .25272 L
.44044 .2493 L
.45938 .24558 L
.47955 .24119 L
.49896 .23656 L
.5196 .2312 L
Mistroke
.53948 .22561 L
.5586 .21982 L
.57895 .21319 L
.59854 .20633 L
.61936 .19844 L
.63942 .19017 L
.65872 .18146 L
.67925 .17114 L
.69902 .15969 L
.71803 .14618 L
.72772 .13722 L
.73051 .13405 L
.73315 .13056 L
.73552 .12663 L
.73617 .12529 L
.73686 .12362 L
.73745 .1218 L
.7381 .11728 L
Mfstroke
.2619 .3394 m
.28122 .33721 L
.30229 .33451 L
.32208 .33168 L
.3411 .32873 L
.36136 .32533 L
.38085 .32182 L
.40158 .31786 L
.42154 .31381 L
.44075 .30971 L
.46118 .30513 L
.48086 .30051 L
.49978 .29588 L
.51992 .29074 L
.53931 .28559 L
.55992 .2799 L
.57977 .2742 L
.59887 .26851 L
.61919 .26224 L
.63876 .25597 L
.65955 .24906 L
.67958 .24214 L
.69886 .23523 L
.71936 .2276 L
.7381 .22035 L
s
0 1 1 r
.2619 .23632 m
.26249 .24033 L
.26303 .24179 L
.26364 .24305 L
.26423 .24402 L
.26639 .24668 L
.26875 .24876 L
.27131 .25051 L
.27646 .25316 L
.28122 .25496 L
.28609 .25639 L
.29145 .25763 L
.29705 .25864 L
.30229 .25937 L
.30748 .25993 L
.31241 .26033 L
.31684 .2606 L
.31935 .26071 L
.32168 .2608 L
.32421 .26087 L
.32564 .2609 L
.32696 .26092 L
.32811 .26094 L
.32877 .26094 L
.32938 .26095 L
.33003 .26095 L
.33061 .26095 L
.33094 .26096 L
.33129 .26096 L
.33194 .26096 L
.33251 .26095 L
.33305 .26095 L
.33364 .26095 L
.33428 .26095 L
.33558 .26093 L
.33677 .26092 L
.33895 .26088 L
.34124 .26083 L
.34601 .26067 L
.35111 .26045 L
.36029 .2599 L
.37097 .25906 L
.38104 .25808 L
.40028 .25576 L
.42074 .25272 L
.44044 .2493 L
.45938 .24558 L
.47955 .24119 L
.49896 .23656 L
.5196 .2312 L
.53948 .22561 L
.5586 .21982 L
.57895 .21319 L
.59854 .20633 L
.61936 .19844 L
.63942 .19017 L
.65872 .18146 L
.67925 .17114 L
.69902 .15969 L
.71803 .14618 L
.72772 .13722 L
.73051 .13405 L
.73315 .13056 L
.73552 .12663 L
.73617 .12529 L
.73686 .12362 L
.73745 .1218 L
.7381 .11728 L
.7381 .22035 L
.71936 .2276 L
.69886 .23523 L
.67958 .24214 L
.65955 .24906 L
.63876 .25597 L
.61919 .26224 L
.59887 .26851 L
.57977 .2742 L
.55992 .2799 L
.53931 .28559 L
.51992 .29074 L
.49978 .29588 L
.48086 .30051 L
.46118 .30513 L
.44075 .30971 L
.42154 .31381 L
.40158 .31786 L
.38085 .32182 L
.36136 .32533 L
.3411 .32873 L
.32208 .33168 L
.30229 .33451 L
.28122 .33721 L
.2619 .3394 L
F
0 g
.2619 .23632 m
.26249 .24033 L
.26303 .24179 L
.26364 .24305 L
.26423 .24402 L
.26639 .24668 L
.26875 .24876 L
.27131 .25051 L
.27646 .25316 L
.28122 .25496 L
.28609 .25639 L
.29145 .25763 L
.29705 .25864 L
.30229 .25937 L
.30748 .25993 L
.31241 .26033 L
.31684 .2606 L
.31935 .26071 L
.32168 .2608 L
.32421 .26087 L
.32564 .2609 L
.32696 .26092 L
.32811 .26094 L
.32877 .26094 L
.32938 .26095 L
.33003 .26095 L
.33061 .26095 L
.33094 .26096 L
.33129 .26096 L
.33194 .26096 L
.33251 .26095 L
.33305 .26095 L
.33364 .26095 L
.33428 .26095 L
.33558 .26093 L
.33677 .26092 L
.33895 .26088 L
.34124 .26083 L
.34601 .26067 L
.35111 .26045 L
.36029 .2599 L
.37097 .25906 L
.38104 .25808 L
.40028 .25576 L
.42074 .25272 L
.44044 .2493 L
.45938 .24558 L
.47955 .24119 L
.49896 .23656 L
.5196 .2312 L
Mistroke
.53948 .22561 L
.5586 .21982 L
.57895 .21319 L
.59854 .20633 L
.61936 .19844 L
.63942 .19017 L
.65872 .18146 L
.67925 .17114 L
.69902 .15969 L
.71803 .14618 L
.72772 .13722 L
.73051 .13405 L
.73315 .13056 L
.73552 .12663 L
.73617 .12529 L
.73686 .12362 L
.73745 .1218 L
.7381 .11728 L
Mfstroke
.2619 .3394 m
.28122 .33721 L
.30229 .33451 L
.32208 .33168 L
.3411 .32873 L
.36136 .32533 L
.38085 .32182 L
.40158 .31786 L
.42154 .31381 L
.44075 .30971 L
.46118 .30513 L
.48086 .30051 L
.49978 .29588 L
.51992 .29074 L
.53931 .28559 L
.55992 .2799 L
.57977 .2742 L
.59887 .26851 L
.61919 .26224 L
.63876 .25597 L
.65955 .24906 L
.67958 .24214 L
.69886 .23523 L
.71936 .2276 L
.7381 .22035 L
s
.2619 .1332 m
.28122 .12573 L
.30229 .1179 L
.32208 .11083 L
.3411 .10428 L
.36136 .09755 L
.38085 .0913 L
.40158 .08491 L
.42154 .07897 L
.44075 .07347 L
.46118 .06783 L
.48086 .06261 L
.49978 .05779 L
.51992 .05285 L
.53931 .04831 L
.55992 .0437 L
.57977 .03947 L
.59887 .03561 L
.61919 .03172 L
.63876 .02821 L
.65955 .02472 L
.67958 .02162 L
.69886 .01889 L
.71936 .01627 L
.7381 .01415 L
s
.2619 .23628 m
.26249 .23197 L
.26303 .23025 L
.26423 .22742 L
.26639 .22368 L
.27131 .21739 L
.28122 .20798 L
.30229 .19304 L
.32225 .18161 L
.34146 .172 L
.3619 .16282 L
.38157 .15475 L
.40049 .14758 L
.42063 .1405 L
.44002 .13417 L
.46063 .12791 L
.48048 .12233 L
.49958 .11736 L
.5199 .11249 L
.53947 .10821 L
.56026 .10413 L
.58029 .10067 L
.59957 .09782 L
.62007 .09536 L
.63028 .09438 L
.63981 .09364 L
.64898 .0931 L
.65411 .09288 L
.6588 .09273 L
.6612 .09267 L
.66252 .09265 L
.66376 .09263 L
.6648 .09262 L
.66594 .09261 L
.66655 .0926 L
.66719 .0926 L
.66774 .0926 L
.66834 .0926 L
.66868 .0926 L
.66904 .0926 L
.66939 .0926 L
.6697 .0926 L
.67031 .0926 L
.67094 .09261 L
.67162 .09261 L
.67226 .09262 L
.67372 .09264 L
.67498 .09267 L
.67613 .09269 L
.67872 .09277 L
Mistroke
.68111 .09286 L
.68366 .09298 L
.68823 .09327 L
.69368 .09374 L
.6986 .09429 L
.70363 .09502 L
.70824 .09586 L
.71331 .09701 L
.71866 .09856 L
.72341 .10034 L
.72603 .10156 L
.7285 .10292 L
.7308 .10446 L
.7333 .10657 L
.7344 .10774 L
.73557 .10924 L
.73657 .11091 L
.73714 .11217 L
.73767 .11382 L
.7381 .11723 L
Mfstroke
0 1 1 r
.2619 .1332 m
.28122 .12573 L
.30229 .1179 L
.32208 .11083 L
.3411 .10428 L
.36136 .09755 L
.38085 .0913 L
.40158 .08491 L
.42154 .07897 L
.44075 .07347 L
.46118 .06783 L
.48086 .06261 L
.49978 .05779 L
.51992 .05285 L
.53931 .04831 L
.55992 .0437 L
.57977 .03947 L
.59887 .03561 L
.61919 .03172 L
.63876 .02821 L
.65955 .02472 L
.67958 .02162 L
.69886 .01889 L
.71936 .01627 L
.7381 .01415 L
.7381 .11723 L
.73767 .11382 L
.73714 .11217 L
.73657 .11091 L
.73557 .10924 L
.7344 .10774 L
.7333 .10657 L
.7308 .10446 L
.7285 .10292 L
.72603 .10156 L
.72341 .10034 L
.71866 .09856 L
.71331 .09701 L
.70824 .09586 L
.70363 .09502 L
.6986 .09429 L
.69368 .09374 L
.68823 .09327 L
.68366 .09298 L
.68111 .09286 L
.67872 .09277 L
.67613 .09269 L
.67498 .09267 L
.67372 .09264 L
.67226 .09262 L
.67162 .09261 L
.67094 .09261 L
.67031 .0926 L
.6697 .0926 L
.66939 .0926 L
.66904 .0926 L
.66868 .0926 L
.66834 .0926 L
.66774 .0926 L
.66719 .0926 L
.66655 .0926 L
.66594 .09261 L
.6648 .09262 L
.66376 .09263 L
.66252 .09265 L
.6612 .09267 L
.6588 .09273 L
.65411 .09288 L
.64898 .0931 L
.63981 .09364 L
.63028 .09438 L
.62007 .09536 L
.59957 .09782 L
.58029 .10067 L
.56026 .10413 L
.53947 .10821 L
.5199 .11249 L
.49958 .11736 L
.48048 .12233 L
.46063 .12791 L
.44002 .13417 L
.42063 .1405 L
.40049 .14758 L
.38157 .15475 L
.3619 .16282 L
.34146 .172 L
.32225 .18161 L
.30229 .19304 L
.28122 .20798 L
.27131 .21739 L
.26639 .22368 L
.26423 .22742 L
.26303 .23025 L
.26249 .23197 L
.2619 .23628 L
F
0 g
.2619 .1332 m
.28122 .12573 L
.30229 .1179 L
.32208 .11083 L
.3411 .10428 L
.36136 .09755 L
.38085 .0913 L
.40158 .08491 L
.42154 .07897 L
.44075 .07347 L
.46118 .06783 L
.48086 .06261 L
.49978 .05779 L
.51992 .05285 L
.53931 .04831 L
.55992 .0437 L
.57977 .03947 L
.59887 .03561 L
.61919 .03172 L
.63876 .02821 L
.65955 .02472 L
.67958 .02162 L
.69886 .01889 L
.71936 .01627 L
.7381 .01415 L
s
.2619 .23628 m
.26249 .23197 L
.26303 .23025 L
.26423 .22742 L
.26639 .22368 L
.27131 .21739 L
.28122 .20798 L
.30229 .19304 L
.32225 .18161 L
.34146 .172 L
.3619 .16282 L
.38157 .15475 L
.40049 .14758 L
.42063 .1405 L
.44002 .13417 L
.46063 .12791 L
.48048 .12233 L
.49958 .11736 L
.5199 .11249 L
.53947 .10821 L
.56026 .10413 L
.58029 .10067 L
.59957 .09782 L
.62007 .09536 L
.63028 .09438 L
.63981 .09364 L
.64898 .0931 L
.65411 .09288 L
.6588 .09273 L
.6612 .09267 L
.66252 .09265 L
.66376 .09263 L
.6648 .09262 L
.66594 .09261 L
.66655 .0926 L
.66719 .0926 L
.66774 .0926 L
.66834 .0926 L
.66868 .0926 L
.66904 .0926 L
.66939 .0926 L
.6697 .0926 L
.67031 .0926 L
.67094 .09261 L
.67162 .09261 L
.67226 .09262 L
.67372 .09264 L
.67498 .09267 L
.67613 .09269 L
.67872 .09277 L
Mistroke
.68111 .09286 L
.68366 .09298 L
.68823 .09327 L
.69368 .09374 L
.6986 .09429 L
.70363 .09502 L
.70824 .09586 L
.71331 .09701 L
.71866 .09856 L
.72341 .10034 L
.72603 .10156 L
.7285 .10292 L
.7308 .10446 L
.7333 .10657 L
.7344 .10774 L
.73557 .10924 L
.73657 .11091 L
.73714 .11217 L
.73767 .11382 L
.7381 .11723 L
Mfstroke
.7381 .01415 m
.74775 .01317 L
.75829 .01219 L
.76818 .01136 L
.77769 .01064 L
.78782 .00998 L
.79757 .00944 L
.80793 .00899 L
.81312 .00881 L
.81791 .00867 L
.82258 .00856 L
.82496 .00852 L
.82752 .00848 L
.82883 .00846 L
.83007 .00845 L
.83128 .00844 L
.8324 .00843 L
.83346 .00843 L
.834 .00842 L
.83459 .00842 L
.83492 .00842 L
.83523 .00842 L
.83552 .00842 L
.83584 .00842 L
.83613 .00842 L
.83639 .00842 L
.83667 .00842 L
.83698 .00842 L
.83728 .00842 L
.83745 .00842 L
.83762 .00842 L
.83794 .00842 L
.8383 .00842 L
.83894 .00842 L
.83952 .00842 L
.84087 .00843 L
.84229 .00844 L
.84469 .00847 L
.84732 .0085 L
.84989 .00855 L
.85222 .00861 L
.85746 .00876 L
.86225 .00894 L
.86745 .00919 L
.87768 .00985 L
.88753 .01071 L
.897 .01179 L
.90709 .01324 L
.9168 .015 L
.92711 .01736 L
Mistroke
.93706 .02025 L
.94662 .02382 L
.95196 .02629 L
.95679 .02895 L
.9615 .03206 L
.96397 .03399 L
.96659 .03634 L
.96897 .03889 L
.97159 .04237 L
.97274 .04429 L
.97397 .0468 L
.97457 .04832 L
.97513 .05006 L
.97538 .05098 L
.97564 .05214 L
.97593 .05383 L
.97619 .0577 L
Mfstroke
.7381 .22035 m
.74775 .2165 L
.75829 .21222 L
.76818 .2081 L
.77769 .20406 L
.78782 .19966 L
.79757 .19533 L
.80793 .1906 L
.81791 .18593 L
.82752 .18132 L
.83773 .17627 L
.84757 .17126 L
.85703 .16629 L
.8671 .16083 L
.8768 .15537 L
.8871 .14933 L
.89703 .14325 L
.90658 .13711 L
.91674 .13019 L
.92652 .12308 L
.93692 .11489 L
.94693 .10613 L
.95657 .09645 L
.96146 .0908 L
.96682 .08357 L
.96916 .07987 L
.97167 .07523 L
.97288 .07257 L
.97403 .06959 L
.97507 .06619 L
.97535 .06501 L
.97565 .06353 L
.97591 .06191 L
.97619 .05775 L
s
0 1 1 r
.7381 .01415 m
.74775 .01317 L
.75829 .01219 L
.76818 .01136 L
.77769 .01064 L
.78782 .00998 L
.79757 .00944 L
.80793 .00899 L
.81312 .00881 L
.81791 .00867 L
.82258 .00856 L
.82496 .00852 L
.82752 .00848 L
.82883 .00846 L
.83007 .00845 L
.83128 .00844 L
.8324 .00843 L
.83346 .00843 L
.834 .00842 L
.83459 .00842 L
.83492 .00842 L
.83523 .00842 L
.83552 .00842 L
.83584 .00842 L
.83613 .00842 L
.83639 .00842 L
.83667 .00842 L
.83698 .00842 L
.83728 .00842 L
.83745 .00842 L
.83762 .00842 L
.83794 .00842 L
.8383 .00842 L
.83894 .00842 L
.83952 .00842 L
.84087 .00843 L
.84229 .00844 L
.84469 .00847 L
.84732 .0085 L
.84989 .00855 L
.85222 .00861 L
.85746 .00876 L
.86225 .00894 L
.86745 .00919 L
.87768 .00985 L
.88753 .01071 L
.897 .01179 L
.90709 .01324 L
.9168 .015 L
.92711 .01736 L
.93706 .02025 L
.94662 .02382 L
.95196 .02629 L
.95679 .02895 L
.9615 .03206 L
.96397 .03399 L
.96659 .03634 L
.96897 .03889 L
.97159 .04237 L
.97274 .04429 L
.97397 .0468 L
.97457 .04832 L
.97513 .05006 L
.97538 .05098 L
.97564 .05214 L
.97593 .05383 L
.97619 .0577 L
.97619 .05775 L
.97591 .06191 L
.97565 .06353 L
.97535 .06501 L
.97507 .06619 L
.97403 .06959 L
.97288 .07257 L
.97167 .07523 L
.96916 .07987 L
.96682 .08357 L
.96146 .0908 L
.95657 .09645 L
.94693 .10613 L
.93692 .11489 L
.92652 .12308 L
.91674 .13019 L
.90658 .13711 L
.89703 .14325 L
.8871 .14933 L
.8768 .15537 L
.8671 .16083 L
.85703 .16629 L
.84757 .17126 L
.83773 .17627 L
.82752 .18132 L
.81791 .18593 L
.80793 .1906 L
.79757 .19533 L
.78782 .19966 L
.77769 .20406 L
.76818 .2081 L
.75829 .21222 L
.74775 .2165 L
.7381 .22035 L
F
0 g
.7381 .01415 m
.74775 .01317 L
.75829 .01219 L
.76818 .01136 L
.77769 .01064 L
.78782 .00998 L
.79757 .00944 L
.80793 .00899 L
.81312 .00881 L
.81791 .00867 L
.82258 .00856 L
.82496 .00852 L
.82752 .00848 L
.82883 .00846 L
.83007 .00845 L
.83128 .00844 L
.8324 .00843 L
.83346 .00843 L
.834 .00842 L
.83459 .00842 L
.83492 .00842 L
.83523 .00842 L
.83552 .00842 L
.83584 .00842 L
.83613 .00842 L
.83639 .00842 L
.83667 .00842 L
.83698 .00842 L
.83728 .00842 L
.83745 .00842 L
.83762 .00842 L
.83794 .00842 L
.8383 .00842 L
.83894 .00842 L
.83952 .00842 L
.84087 .00843 L
.84229 .00844 L
.84469 .00847 L
.84732 .0085 L
.84989 .00855 L
.85222 .00861 L
.85746 .00876 L
.86225 .00894 L
.86745 .00919 L
.87768 .00985 L
.88753 .01071 L
.897 .01179 L
.90709 .01324 L
.9168 .015 L
.92711 .01736 L
Mistroke
.93706 .02025 L
.94662 .02382 L
.95196 .02629 L
.95679 .02895 L
.9615 .03206 L
.96397 .03399 L
.96659 .03634 L
.96897 .03889 L
.97159 .04237 L
.97274 .04429 L
.97397 .0468 L
.97457 .04832 L
.97513 .05006 L
.97538 .05098 L
.97564 .05214 L
.97593 .05383 L
.97619 .0577 L
Mfstroke
.7381 .22035 m
.74775 .2165 L
.75829 .21222 L
.76818 .2081 L
.77769 .20406 L
.78782 .19966 L
.79757 .19533 L
.80793 .1906 L
.81791 .18593 L
.82752 .18132 L
.83773 .17627 L
.84757 .17126 L
.85703 .16629 L
.8671 .16083 L
.8768 .15537 L
.8871 .14933 L
.89703 .14325 L
.90658 .13711 L
.91674 .13019 L
.92652 .12308 L
.93692 .11489 L
.94693 .10613 L
.95657 .09645 L
.96146 .0908 L
.96682 .08357 L
.96916 .07987 L
.97167 .07523 L
.97288 .07257 L
.97403 .06959 L
.97507 .06619 L
.97535 .06501 L
.97565 .06353 L
.97591 .06191 L
.97619 .05775 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.353553 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.168359 0.176777 0.168359 [
[.16328 .16428 -6 -9 ]
[.16328 .16428 6 0 ]
[.33164 .16428 -6 -9 ]
[.33164 .16428 6 0 ]
[.66836 .16428 -3 -9 ]
[.66836 .16428 3 0 ]
[.83672 .16428 -3 -9 ]
[.83672 .16428 3 0 ]
[.4875 .00842 -12 -4.5 ]
[.4875 .00842 0 4.5 ]
[.4875 .0926 -24 -4.5 ]
[.4875 .0926 0 4.5 ]
[.4875 .26096 -18 -4.5 ]
[.4875 .26096 0 4.5 ]
[.4875 .34514 -6 -4.5 ]
[.4875 .34514 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .35355 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.16328 .17678 m
.16328 .18303 L
s
[(-2)] .16328 .16428 0 1 Mshowa
.33164 .17678 m
.33164 .18303 L
s
[(-1)] .33164 .16428 0 1 Mshowa
.66836 .17678 m
.66836 .18303 L
s
[(1)] .66836 .16428 0 1 Mshowa
.83672 .17678 m
.83672 .18303 L
s
[(2)] .83672 .16428 0 1 Mshowa
.125 Mabswid
.0286 .17678 m
.0286 .18053 L
s
.06227 .17678 m
.06227 .18053 L
s
.09594 .17678 m
.09594 .18053 L
s
.12961 .17678 m
.12961 .18053 L
s
.19695 .17678 m
.19695 .18053 L
s
.23063 .17678 m
.23063 .18053 L
s
.2643 .17678 m
.2643 .18053 L
s
.29797 .17678 m
.29797 .18053 L
s
.36531 .17678 m
.36531 .18053 L
s
.39898 .17678 m
.39898 .18053 L
s
.43266 .17678 m
.43266 .18053 L
s
.46633 .17678 m
.46633 .18053 L
s
.53367 .17678 m
.53367 .18053 L
s
.56734 .17678 m
.56734 .18053 L
s
.60102 .17678 m
.60102 .18053 L
s
.63469 .17678 m
.63469 .18053 L
s
.70203 .17678 m
.70203 .18053 L
s
.7357 .17678 m
.7357 .18053 L
s
.76937 .17678 m
.76937 .18053 L
s
.80305 .17678 m
.80305 .18053 L
s
.87039 .17678 m
.87039 .18053 L
s
.90406 .17678 m
.90406 .18053 L
s
.93773 .17678 m
.93773 .18053 L
s
.9714 .17678 m
.9714 .18053 L
s
.25 Mabswid
0 .17678 m
1 .17678 L
s
.5 .00842 m
.50625 .00842 L
s
[(-1)] .4875 .00842 1 0 Mshowa
.5 .0926 m
.50625 .0926 L
s
[(-0.5)] .4875 .0926 1 0 Mshowa
.5 .26096 m
.50625 .26096 L
s
[(0.5)] .4875 .26096 1 0 Mshowa
.5 .34514 m
.50625 .34514 L
s
[(1)] .4875 .34514 1 0 Mshowa
.125 Mabswid
.5 .02525 m
.50375 .02525 L
s
.5 .04209 m
.50375 .04209 L
s
.5 .05893 m
.50375 .05893 L
s
.5 .07576 m
.50375 .07576 L
s
.5 .10943 m
.50375 .10943 L
s
.5 .12627 m
.50375 .12627 L
s
.5 .1431 m
.50375 .1431 L
s
.5 .15994 m
.50375 .15994 L
s
.5 .19361 m
.50375 .19361 L
s
.5 .21045 m
.50375 .21045 L
s
.5 .22728 m
.50375 .22728 L
s
.5 .24412 m
.50375 .24412 L
s
.5 .27779 m
.50375 .27779 L
s
.5 .29463 m
.50375 .29463 L
s
.5 .31146 m
.50375 .31146 L
s
.5 .3283 m
.50375 .3283 L
s
.25 Mabswid
.5 0 m
.5 .35355 L
s
0 0 m
1 0 L
1 .35355 L
0 .35355 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004/0000]2000`400?l00000o`00003oooooool]
ooooo`00ooooool]ooooo`00ooooool]ooooo`00ooooool]ooooo`00ooooool]ooooo`00ooooool]
ooooo`00ooooool]ooooo`00ooooool]ooooo`00ooooool]ooooo`00ooooool]ooooo`00ooooool]
ooooo`00ooooool]ooooo`00ooooool]ooooo`00ooooool]ooooo`00ooooool]ooooo`00ooooool]
ooooo`00ooooool]ooooo`00ooooool]ooooo`00ooooool]ooooo`00ooooool]ooooo`00ooooool]
ooooo`00ooooool]ooooo`00ooooool]ooooo`00ooooool]ooooo`00ooooool]ooooo`00ooooool]
ooooo`00ooooool]ooooo`00ooooool]ooooo`00ooooool]ooooo`00ooooool]ooooo`00ooooool]
ooooo`00ooooool]ooooo`00ooooool]ooooo`00ooooool]ooooo`00ooooool]ooooo`00ooooool]
ooooo`00ooooool]ooooo`00ooooool]ooooo`00ooooool]ooooo`00S?ooool3o`0000Kooooo00?o
0000ooooooooool0U?ooool008gooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`2D
ooooo`00QOooool5o`0000?ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`2Doooo
o`00SOooool00ol0003oooooooooo`05ooooo`?o0000C?oooolSo`0002Gooooo002=ooooo`03o`00
0?oooooooooo00Gooooo00?o0000ooooooooool0?oooool=o`0002?o0?oo1_l0000Oooooo`00S?oo
ool2o`0000Oooooo00?o0000ooooooooool0>Oooool6o`0003Ko0?oo1_l0000Iooooo`00SOooool0
0ol0003oooooooooo`05ooooo`03o`000?oooooooooo02kooooo2ol00012o`3oo`;o00005oooool0
09Gooooo00?o0000ooooooooool0:?ooool6o`0004oo0?oo0_l0000Eooooo`00UOooool2o`0002?o
oooo1_l0001Go`3oo`03o`000?oooooooooo01;ooooo002Eooooo`03o`000?oooooooooo01cooooo
1_l0001No`3oo`?o00004Oooool009Gooooo00?o0000ooooooooool06?ooool4o`0006Ko0?oo00?o
0000ooooooooool03oooool009Gooooo00?o0000ooooooooool05Oooool3o`0006_o0?oo0_l0000?
ooooo`00UOooool2o`0001;ooooo1?l0001_o`3oo`03o`000?oooooooooo00gooooo002Eooooo`03
o`000?oooooooooo00_ooooo1_l0001do`3oo`03o`000?oooooooooo00cooooo002Eooooo`03o`00
0?oooooooooo00Kooooo1Ol0001jo`3oo`03o`000?oooooooooo00cooooo002Eooooo`03o`000?oo
oooooooo00;ooooo1?l0001oo`3oo`;o00003Oooool009Gooooo00?o0000ooooool000000_l00024
o`3oo`03o`000?oooooooooo00_ooooo002Cooooo`Co0000Qol0ool00ol0003oooooooooo`0;oooo
o`00Soooool4o`0000;o0?oo00?o0000o`3oool0ool0Q_l0ool00ol0003oooooooooo`0;ooooo`00
S?ooool3o`0000Ko0?oo00?o0000o`3oool0ool0QOl0ool2o`0000gooooo0027ooooo`Go00002Ol0
ool00ol0003o0?ooo`3oo`25o`3oo`03o`000?oooooooooo00cooooo0023ooooo`Co00003_l0ool0
0ol0003o0?ooo`3oo`25o`3oo`03o`000?oooooooooo00cooooo0020ooooo`?o00004_l0ool2o`00
08Go0?oo00?o0000ooooooooool03Oooool007gooooo0ol0000Eo`3oo`03o`000?l0oooo0?oo08Co
0?oo00?o0000ooooooooool03Oooool007[ooooo0ol00004o`3oo`;o00001?l0ool00ol0003o0?oo
o`3oo`02o`3oo`?o00001_l0ool00ol0003o0?ooo`3oo`23o`3oo`03o`000?oooooooooo00kooooo
001fooooo`Co00001_l0ool01?l0003o0?ooo`3oool00007o`3oo`05o`000?l0oooo0?ooo`3oool0
00001Ol0ool00ol0003o0?ooo`3oo`23o`3oo`03o`000?oooooooooo00kooooo001booooo`Co0000
0ol0ool5o`0000;o0?oo00Co0000o`3oool0oooo00002ol0ool00ol0003o0?ooo`3oo`03o`3oo`03
o`000?l0oooo0?oo08;o0?oo00?o0000ooooooooool03oooool006oooooo0ol0000>o`3oo`04o`00
0?l0oooo0?ooo`0000_o0?oo00?o0000o`3oool0ool00ol0ool3o`00027o0?oo5_l0001:o`3oo`03
o`000?oooooooooo013ooooo001/ooooo`?o00004Ol0ool01?l0003o0?ooo`3oool00007o`3oo`Co
00001_l0ool00ol0003o0?ooo`3oo`0Go`3oo`[o00005_ooool5o`0004Co0?oo00?o0000oooooooo
ool04Oooool006Wooooo0ol0000Do`3oo`04o`000?l0oooo0?ooo`0000Oo0?oo00?o0000o`3oool0
ool01ol0ool00ol0003o0?ooo`3oo`0Ao`3oo`Ko00009Oooool3o`00043o0?oo00?o0000oooooooo
ool04_ooool006Kooooo0ol0000Ho`3oo`;o00002?l0ool5o`0000Go0?oo00?o0000o`3oool0ool0
2ol0ool6o`0002kooooo00?o0000o`3oool0ool0??l0ool00ol0003oooooooooo`0Cooooo`00Hooo
ool3o`0002oo0?oo00?o0000o`3oool0ool01ol0ool4o`0003Gooooo00?o0000o`3oool0ool0>Ol0
ool2o`0001Kooooo001Qooooo`;o0000<_l0ool2o`0000Go0?oo0ol0000joooooc[o0?oo00?o0000
ooooooooool05_ooool005kooooo0ol0000do`3oo`03o`000?l0oooo0?oo00Co0000?Ooooolio`3o
o`03o`000?oooooooooo01Oooooo001Kooooo`?o0000=?l0ool6o`00047ooooo>?l0ool00ol0003o
ooooooooo`0Hooooo`00F?ooool3o`0003?o0?oo1?l00003ooooo`03o`000?oooooooooo047ooooo
=ol0ool00ol0003oooooooooo`0Iooooo`00EOooool3o`0003?o0?oo0ol00007ooooo`03o`000?oo
oooooooo047ooooo=_l0ool00ol0003oooooooooo`0Jooooo`00Doooool2o`0003Co0?oo0_l0000:
ooooo`;o0000@_ooooleo`3oo`03o`000?oooooooooo01_ooooo001Booooo`03o`000?l0oooo0?oo
037o0?oo0ol0000<ooooo`03o`000?oooooooooo043ooooo00?o0000o`3oool0ool0<Ol0ool2o`00
01kooooo000dooooo`Go00005oooool2o`0001Co0?oo0ol0000Jo`3oo`?o00003oooool00ol0003o
ooooooooo`0[ooooo`?o00004Oooool00ol0003o0?ooo`3oo`0Io`3oo`Go00004ol0ool00ol0003o
ooooooooo`0Nooooo`00=Oooool01?l0003oooooooooool0000Dooooo`?o00005ol0ool00ol0003o
0?ooo`3oo`0Fo`3oo`?o00004_ooool00ol0003oooooooooo`0/ooooo`03o`000?oooooooooo00oo
oooo00?o0000o`3oool0ool06ol0ool01?l0003o0?ooo`3oool0000Ao`3oo`;o00008Oooool002ko
oooo1Ol00003ooooo`03o`000?oooooooooo017ooooo0ol0000Bo`3oo`Go00000ol0ool00ol0003o
0?ooo`3oo`0Co`3oo`?o00005Oooool2o`0002gooooo00?o0000ooooooooool03_ooool00ol0003o
0?ooo`3oo`0Mo`3oo`03o`000?l0oooo0?oo00ko0?oo0ol0000Sooooo`00=oooool00ol0003ooooo
ooooo`0=ooooo`?o00007Ol0ool00ol0003o0?ooo`3oo`0@o`3oo`?o00006?ooool00ol0003ooooo
ooooo`0/ooooo`03o`000?oooooooooo00cooooo0_l0000Qo`3oo`03o`000?l0oooo0?oo00co0?oo
00?o0000ooooooooool09?ooool003Cooooo00Go0000ooooooooooooooooo`00000;ooooo`?o0000
8?l0ool00ol0003o0?ooo`3oo`0=o`3oo`?o00006oooool00ol0003oooooooooo`0/ooooo`03o`00
0?oooooooooo00_ooooo00?o0000o`3oool0ool07_l0ool01Ol0003o0?ooo`3oool0oooo000000_o
0?oo0_l0000Wooooo`00=?ooool01Ol0003ooooooooooooooooo000000Wooooo0_l0000Ro`3oo`;o
00003?l0ool3o`0001kooooo00?o0000ooooooooool0:oooool2o`0000_ooooo0_l0000Qo`3oo`05
o`000?l0oooo0?ooo`3oool000002_l0ool00ol0003oooooooooo`0Wooooo`00=Oooool3o`0000Wo
oooo00?o0000o`3oool0ool08ol0ool00ol0003o0?ooo`3oo`08o`3oo`;o00008Oooool00ol0003o
ooooooooo`0/ooooo`03o`000?oooooooooo00Sooooo00?o0000o`3oool0ool08_l0ool3o`0000Wo
0?oo0_l0000Zooooo`00?oooool2o`0002ko0?oo0ol0000Sooooo`;o0000=_ooool2o`0002oo0?oo
0_l0000/ooooo`00??ooool3o`0002go0?oo0ol0000Vooooo`03o`000?oooooooooo03?ooooo0_l0
000`o`3oo`03o`000?oooooooooo02cooooo000iooooo`?o0000;_l0ool2o`0002Wooooo00?o0000
ooooooooool0<Oooool2o`00033o0?oo0_l0000_ooooo`00>?ooool00ol0003o0?ooo`3oo`0]o`3o
o`;o0000:oooool00ol0003oooooooooo`0_ooooo`;o0000;ol0ool3o`00037ooooo000fooooo`;o
0000;_l0ool2o`0002gooooo00?o0000ooooooooool0;Oooool2o`00033o0?oo00?o0000oooooooo
ool0<_ooool000Goooooool0000Ro`0000Kooooo000>ooooo`03o`000?oooooooooo00Kooooo00?o
0000ooooooooool01oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Cooooo00?o
0000o`3oool000002Ol0ool00ol0003o0?ooo`3oo`07o`3oo`03o`000?l0oooo0?oo00Ko0?oo00?o
0000o`3oool0ool01ol0ool00ol0003o0?ooo`3oo`03o`3oo`;o00000_ooool00ol0003ooooooooo
o`06ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool01oooool00ol0003ooooooooo
o`06ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool01oooool00ol0003ooooooooo
o`06ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool01oooool00ol0003ooooooooo
o`03ooooo`;o000000?o0?ooo`000?l0ool02?l0ool00ol0003o0?ooo`3oo`07o`3oo`03o`000?l0
oooo0?oo00Ko0?oo00?o0000o`3oool0ool01ol0ool00ol0003o0?ooo`3oo`03o`3oo`?o000000?o
ooooo`000?ooool01oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Oooooo00?o
0000ooooooooool01_ooool00ol0003oooooooooo`0=ooooo`00<?ooool2o`0000;o0?oo00?o0000
o`3oool0ool0:Ol0ool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo02gooooo00?o0000
ooooooooool0:?ooool2o`0000?o0?oo00?o0000o`3oool0ool0:Ol0ool00ol0003oooooooooo`02
ooooo`03o`000?oooooooooo03?ooooo000^ooooo`;o0000;_l0ool2o`0003Gooooo00?o0000oooo
ooooool09_ooool2o`0002oo0?oo0_l0000kooooo`00;Oooool00ol0003o0?ooo`3oo`0]o`3oo`03
o`000?oooooooooo03Gooooo00?o0000ooooooooool09?ooool2o`0002ko0?oo0ol0000mooooo`00
:oooool2o`0002ko0?oo0_l0000hooooo`;o00008_ooool3o`0002ko0?oo0_l00010ooooo`00:?oo
ool3o`0002oo0?oo00?o0000ooooooooool0>?ooool00ol0003oooooooooo`0Nooooo`?o0000<?l0
ool00ol0003oooooooooo`10ooooo`009oooool00ol0003o0?ooo`3oo`0^o`3oo`;o0000>oooool0
0ol0003oooooooooo`0Looooo`;o0000<Ol0ool2o`0004?ooooo000Uooooo`;o0000<?l0ool00ol0
003oooooooooo`0kooooo`03o`000?oooooooooo01[ooooo0_l0000`o`3oo`?o0000AOooool002Co
oooo00?o0000o`3oool0ool0;ol0ool00ol0003oooooooooo`0looooo`03o`000?oooooooooo01Oo
oooo0ol0000_o`3oo`?o0000B?ooool002;ooooo0_l0000ao`3oo`03o`000?oooooooooo03gooooo
0_l0000Dooooo`Co0000;ol0ool3o`0004_ooooo000Oooooo`?o0000<_l0ool00ol0003ooooooooo
o`0nooooo`03o`000?oooooooooo013ooooo0ol0000`o`3oo`?o0000C_ooool001kooooo00?o0000
o`3oool0ool0<_l0ool00ol0003oooooooooo`0oooooo`03o`000?oooooooooo00gooooo0ol0000b
o`3oo`03o`000?oooooooooo04oooooo000Mooooo`03o`000?l0oooo0?oo03;o0?oo00?o0000oooo
ooooool0@?ooool00ol0003oooooooooo`0:ooooo`?o0000<ol0ool2o`0005;ooooo000Looooo`03
o`000?l0oooo0?oo03?o0?oo00?o0000ooooooooool0@?ooool00ol0003oooooooooo`07ooooo`?o
0000<ol0ool3o`0005Cooooo000Kooooo`03o`000?l0oooo0?oo03?o0?oo00?o0000ooooooooool0
@Oooool2o`0000Gooooo0ol0000do`3oo`;o0000Eoooool001[ooooo00?o0000o`3oool0ool0=?l0
ool00ol0003oooooooooo`11ooooo`03o`000?oooooooooo00Co0000=?l0ool3o`0005Wooooo000I
ooooo`03o`000?l0oooo0?oo03Go0?oo00?o0000ooooooooool0@?ooool4o`0003Go0?oo0ol0001L
ooooo`005oooool2o`0003So0?oo00?o0000ooooooooool0?Oooool3o`000003o`3oool0003o0?oo
03?o0?oo0ol0001Oooooo`005_ooool00ol0003o0?ooo`3oo`0ho`3oo`03o`000?oooooooooo03So
oooo1Ol00004o`3oo`;o0000<Ol0ool2o`0006;ooooo000Eooooo`03o`000?l0oooo0?oo03[o0?oo
00?o0000ooooooooool0<_ooool5o`0000Wo0?oo00?o0000o`3oool0ool0;Ol0ool3o`0006Cooooo
000Dooooo`03o`000?l0oooo0?oo03co0?oo0_l0000/ooooo`Ko00003_l0ool00ol0003o0?ooo`3o
o`0Zo`3oo`?o0000Ioooool001?ooooo00?o0000o`3oool0ool0?ol0ool3o`0002?ooooo2?l00004
o`3oo`03o`000?l0oooo0?oo00;o0?oo0ol00006o`3oo`03o`000?l0oooo0?oo02Oo0?oo0ol0001Z
ooooo`004_ooool00ol0003o0?ooo`3oo`13o`3oo`?o00005oooool9o`0000Go0?oo00Co0000o`3o
ool0oooo00001ol0ool01Ol0003o0?ooo`3oool0oooo000000Go0?oo00?o0000o`3oool0ool09?l0
ool3o`0006gooooo000Booooo`03o`000?l0oooo0?oo04Ko0?oo5ol0000>o`3oo`04o`000?l0oooo
0?ooo`0000_o0?oo00?o0000o`3oool0ool00ol0ool3o`00027o0?oo0ol0001`ooooo`004Oooool0
0ol0003o0?ooo`3oo`1/o`3oo`04o`000?l0oooo0?ooo`0000_o0?oo00?o0000o`3oool0ool00ol0
ool00ol0003o0?ooo`3oo`0Lo`3oo`Go0000Loooool0013ooooo00?o0000o`3oool0ool0KOl0ool0
1?l0003o0?ooo`3oool00007o`3oo`Co00001_l0ool00ol0003o0?ooo`3oo`0Ho`3oo`Co0000N?oo
ool000oooooo00?o0000o`3oool0ool0K_l0ool01?l0003o0?ooo`3oool00007o`3oo`03o`000?l0
oooo0?oo00Oo0?oo00?o0000o`3oool0ool05Ol0ool3o`0007cooooo000?ooooo`03o`000?l0oooo
0?oo06oo0?oo0_l00008o`3oo`Go00001Ol0ool00ol0003o0?ooo`3oo`0Co`3oo`;o0000Ooooool0
00kooooo00?o0000o`3oool0ool0Q?l0ool2o`00017o0?oo0ol00021ooooo`003_ooool00ol0003o
0?ooo`3oo`24o`3oo`03o`000?l0oooo0?oo00_o0?oo1Ol00024ooooo`003Oooool00ol0003o0?oo
o`3oo`25o`3oo`03o`000?l0oooo0?oo00Oo0?oo1?l00029ooooo`003Oooool00ol0003o0?ooo`3o
o`25o`3oo`03o`000?l0oooo0?oo00Co0?oo0ol0002=ooooo`003?ooool00ol0003o0?ooo`3oo`26
o`3oo`03o`000?l0oooo0?oo00Co0000T?ooool000cooooo00?o0000o`3oool0ool0QOl0ool4o`00
09Cooooo000<ooooo`03o`000?l0oooo0?oo08;o0?oo0ol000000ooooooo0000ooooo`2Eooooo`00
3?ooool2o`0007oo0?oo1?l00004ooooo`03o`000?oooooooooo09Cooooo000=ooooo`03o`000?l0
oooo0?oo07Oo0?oo1_l00008ooooo`03o`000?oooooooooo09Cooooo000=ooooo`03o`000?l0oooo
0?oo077o0?oo1_l0000>ooooo`03o`000?oooooooooo09Cooooo000>ooooo`03o`000?l0oooo0?oo
06co0?oo1?l0000Dooooo`;o0000UOooool000oooooo00?o0000o`3oool0ool0J?l0ool3o`0001So
oooo00?o0000ooooooooool0U?ooool0013ooooo00?o0000o`3oool0ool0Hol0ool4o`0001_ooooo
00?o0000ooooooooool0U?ooool0017ooooo00?o0000o`3oool0ool0G?l0ool6o`0001oooooo00?o
0000ooooooooool0U?ooool001;ooooo0ol0001Eo`3oo`Ko00009Oooool00ol0003oooooooooo`2D
ooooo`005Oooool3o`0004go0?oo1Ol0000[ooooo`;o0000UOooool001Sooooo0_l0000oo`3oo`co
0000<?ooool00ol0003oooooooooo`2Dooooo`006_ooool3o`0003Oo0?oo1Ol0000cooooo`?o0000
1_ooool00ol0003oooooooooo`2Dooooo`007Oooool9o`00027o0?oo3Ol0000iooooo`03o`000?oo
oooooooo00Gooooo00?o0000ooooooooool0U?ooool002Kooooo8Ol00016ooooo`03o`000?oooooo
oooo00Gooooo0ol0002Dooooo`00SOooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo
09Cooooo002=ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0U?ooool008cooooo
0_l00007ooooo`03o`000?oooooooooo09Cooooo002=ooooo`03o`000?oooooooooo09cooooo003o
ooooobgooooo003oooooobgooooo003oooooobgooooo003oooooobgooooo003oooooobgooooo003o
ooooobgooooo003oooooobgooooo003oooooobgooooo003oooooobgooooo003oooooobgooooo003o
ooooobgooooo003oooooobgooooo003oooooobgooooo003oooooobgooooo003oooooobgooooo003o
ooooobgooooo003oooooobgooooo003oooooobgooooo003oooooobgooooo003oooooobgooooo003o
ooooobgooooo003oooooobgooooo003oooooobgooooo003oooooobgooooo003oooooobgooooo003o
ooooobgooooo003oooooobgooooo003oooooobgooooo003oooooobgooooo003oooooobgooooo003o
ooooobgooooo003oooooobgooooo003oooooobgooooo003oooooobgooooo003oooooobgooooo003o
ooooobgooooo003oooooobgooooo0000\
\>"],
 ImageRangeCache->{{{0, 299}, {179, 0}} -> {-5.00005, -0.34665, 0.00334452, \
0.00945973}, {{0, 299}, {142.312, 36.625}} -> {-3.09249, -1.85198, 0.0206855, \
0.0206855}},
 CellTags->"S5.35.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.35.1"]
}, Open  ]],

Cell[TextData[{
 "In this case there is a logical combination of inequalities to describe the \
region ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "<", 
    SuperscriptBox[
     StyleBox["x",
      "TI"], "2"], "-", 
    SuperscriptBox[
     StyleBox["y",
      "TI"], "2"], "<", "4", "\[And]", 
    StyleBox["x",
     "TI"], 
    StyleBox["y",
     "TI"], "<", "1", "\[And]", 
    StyleBox["x",
     "TI"], ">", "0", "\[And]", 
    StyleBox["y",
     "TI"], ">", "0"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.35.1", "1.5"}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InequalityPlot", "[", " ", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "<", 
     RowBox[{
      SuperscriptBox["x", "2"], "-", 
      SuperscriptBox["y", "2"]}], "<", "4"}], "\[And]", 
    RowBox[{
     RowBox[{"x", " ", "y"}], "<", "1"}], "\[And]", 
    RowBox[{"x", ">", "0"}], "\[And]", 
    RowBox[{"y", ">", "0"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", 
     RowBox[{"-", "2"}], ",", " ", "3"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"y", ",", " ", 
     RowBox[{"-", "2"}], ",", " ", "2"}], "}"}]}], " ", "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.35.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .74293 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.742934 [
[ 0 0 0 0 ]
[ 1 .74293 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .74293 L
0 .74293 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.742934 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.876216 0.900026 0.0176889 0.900026 [
[.20381 .00519 -9 -9 ]
[.20381 .00519 9 0 ]
[.38382 .00519 -9 -9 ]
[.38382 .00519 9 0 ]
[.56382 .00519 -9 -9 ]
[.56382 .00519 9 0 ]
[.74383 .00519 -9 -9 ]
[.74383 .00519 9 0 ]
[.92384 .00519 -3 -9 ]
[.92384 .00519 3 0 ]
[.01131 .19769 -18 -4.5 ]
[.01131 .19769 0 4.5 ]
[.01131 .3777 -18 -4.5 ]
[.01131 .3777 0 4.5 ]
[.01131 .5577 -18 -4.5 ]
[.01131 .5577 0 4.5 ]
[.01131 .73771 -18 -4.5 ]
[.01131 .73771 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .74293 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.20381 .01769 m
.20381 .02394 L
s
[(1.2)] .20381 .00519 0 1 Mshowa
.38382 .01769 m
.38382 .02394 L
s
[(1.4)] .38382 .00519 0 1 Mshowa
.56382 .01769 m
.56382 .02394 L
s
[(1.6)] .56382 .00519 0 1 Mshowa
.74383 .01769 m
.74383 .02394 L
s
[(1.8)] .74383 .00519 0 1 Mshowa
.92384 .01769 m
.92384 .02394 L
s
[(2)] .92384 .00519 0 1 Mshowa
.125 Mabswid
.06881 .01769 m
.06881 .02144 L
s
.11381 .01769 m
.11381 .02144 L
s
.15881 .01769 m
.15881 .02144 L
s
.24882 .01769 m
.24882 .02144 L
s
.29382 .01769 m
.29382 .02144 L
s
.33882 .01769 m
.33882 .02144 L
s
.42882 .01769 m
.42882 .02144 L
s
.47382 .01769 m
.47382 .02144 L
s
.51882 .01769 m
.51882 .02144 L
s
.60883 .01769 m
.60883 .02144 L
s
.65383 .01769 m
.65383 .02144 L
s
.69883 .01769 m
.69883 .02144 L
s
.78883 .01769 m
.78883 .02144 L
s
.83383 .01769 m
.83383 .02144 L
s
.87883 .01769 m
.87883 .02144 L
s
.96884 .01769 m
.96884 .02144 L
s
.25 Mabswid
0 .01769 m
1 .01769 L
s
.02381 .19769 m
.03006 .19769 L
s
[(0.2)] .01131 .19769 1 0 Mshowa
.02381 .3777 m
.03006 .3777 L
s
[(0.4)] .01131 .3777 1 0 Mshowa
.02381 .5577 m
.03006 .5577 L
s
[(0.6)] .01131 .5577 1 0 Mshowa
.02381 .73771 m
.03006 .73771 L
s
[(0.8)] .01131 .73771 1 0 Mshowa
.125 Mabswid
.02381 .06269 m
.02756 .06269 L
s
.02381 .10769 m
.02756 .10769 L
s
.02381 .15269 m
.02756 .15269 L
s
.02381 .2427 m
.02756 .2427 L
s
.02381 .2877 m
.02756 .2877 L
s
.02381 .3327 m
.02756 .3327 L
s
.02381 .4227 m
.02756 .4227 L
s
.02381 .4677 m
.02756 .4677 L
s
.02381 .5127 m
.02756 .5127 L
s
.02381 .60271 m
.02756 .60271 L
s
.02381 .64771 m
.02756 .64771 L
s
.02381 .69271 m
.02756 .69271 L
s
.25 Mabswid
.02381 0 m
.02381 .74293 L
s
0 0 m
1 0 L
1 .74293 L
0 .74293 L
closepath
clip
newpath
.5 Mabswid
.02381 .01769 m
.02411 .01769 L
.02439 .01769 L
.0247 .01769 L
.025 .01769 L
.02528 .01769 L
.02554 .01769 L
.02582 .01769 L
.02612 .01769 L
.02642 .01769 L
.02674 .01769 L
.02704 .01769 L
.02732 .01769 L
.02764 .01769 L
.02783 .01769 L
.028 .01769 L
.02831 .01769 L
.02864 .01769 L
.02881 .01769 L
.02899 .01769 L
.02931 .01769 L
.02948 .01769 L
.02965 .01769 L
.02983 .01769 L
.03002 .01769 L
.03019 .01769 L
.03037 .01769 L
.0307 .01769 L
.03102 .01769 L
.03132 .01769 L
.03161 .01769 L
.03188 .01769 L
.03217 .01769 L
.03249 .01769 L
.03281 .01769 L
.03314 .01769 L
.03343 .01769 L
.03374 .01769 L
.03392 .01769 L
.03409 .01769 L
.03428 .01769 L
.03447 .01769 L
.0348 .01769 L
.03499 .01769 L
.03516 .01769 L
.03549 .01769 L
.03579 .01769 L
.03595 .01769 L
.03613 .01769 L
.03645 .01769 L
Mistroke
.03665 .01769 L
.03684 .01769 L
.037 .01769 L
.03718 .01769 L
.03738 .01769 L
.03759 .01769 L
.03776 .01769 L
.03796 .01769 L
.03814 .01769 L
.03831 .01769 L
.0385 .01769 L
.03868 .01769 L
.039 .01769 L
.03918 .01769 L
.03935 .01769 L
.03965 .01769 L
.03997 .01769 L
.04028 .01769 L
.04056 .01769 L
.04087 .01769 L
.0412 .01769 L
.04138 .01769 L
.04156 .01769 L
.04189 .01769 L
.04207 .01769 L
.04223 .01769 L
.04242 .01769 L
.04261 .01769 L
.04294 .01769 L
.04312 .01769 L
.04329 .01769 L
.04362 .01769 L
.04391 .01769 L
.04425 .01769 L
.04457 .01769 L
.04486 .01769 L
.04518 .01769 L
.04548 .01769 L
.04575 .01769 L
.04605 .01769 L
.04638 .01769 L
.04655 .01769 L
.04673 .01769 L
.04705 .01769 L
.04723 .01769 L
.04739 .01769 L
.04757 .01769 L
.04776 .01769 L
.04808 .01769 L
.04826 .01769 L
Mistroke
.04843 .01769 L
.04875 .01769 L
.04903 .01769 L
.04937 .01769 L
.04968 .01769 L
.04998 .01769 L
.05025 .01769 L
.05056 .01769 L
.05086 .01769 L
.05113 .01769 L
.05138 .01769 L
.05166 .01769 L
.05195 .01769 L
.05224 .01769 L
.05256 .01769 L
.05285 .01769 L
.05313 .01769 L
.05344 .01769 L
.05362 .01769 L
.05379 .01769 L
.05409 .01769 L
.05442 .01769 L
.05471 .01769 L
.05503 .01769 L
.05537 .01769 L
.05568 .01769 L
.05597 .01769 L
.05623 .01769 L
.05654 .01769 L
.05683 .01769 L
.05714 .01769 L
.05748 .01769 L
.05776 .01769 L
.05808 .01769 L
.05841 .01769 L
.0586 .01769 L
.05877 .01769 L
.05911 .01769 L
.05943 .01769 L
.05972 .01769 L
.05999 .01769 L
.0603 .01769 L
.06059 .01769 L
.06087 .01769 L
.06111 .01769 L
.06139 .01769 L
.06168 .01769 L
.06197 .01769 L
.06228 .01769 L
.06258 .01769 L
Mistroke
.06285 .01769 L
.06316 .01769 L
.06334 .01769 L
.0635 .01769 L
.06381 .01769 L
.06413 .01769 L
.06444 .01769 L
.06477 .01769 L
.06509 .01769 L
.06539 .01769 L
.06568 .01769 L
.06595 .01769 L
.06626 .01769 L
.06654 .01769 L
.06686 .01769 L
.0672 .01769 L
.06748 .01769 L
.06779 .01769 L
.06813 .01769 L
.06832 .01769 L
.06849 .01769 L
.06883 .01769 L
.06915 .01769 L
.06942 .01769 L
.06971 .01769 L
.07002 .01769 L
.07032 .01769 L
.07059 .01769 L
.07084 .01769 L
.07111 .01769 L
.0714 .01769 L
.07169 .01769 L
.07201 .01769 L
.0723 .01769 L
.07257 .01769 L
.07289 .01769 L
.07306 .01769 L
.07323 .01769 L
.07353 .01769 L
.07385 .01769 L
.07416 .01769 L
.0745 .01769 L
.07482 .01769 L
.07512 .01769 L
.07541 .01769 L
.07568 .01769 L
.07598 .01769 L
.07627 .01769 L
.07659 .01769 L
.07693 .01769 L
Mistroke
.07721 .01769 L
.07753 .01769 L
.07786 .01769 L
.07805 .01769 L
.07823 .01769 L
.07856 .01769 L
.07888 .01769 L
.07915 .01769 L
.07945 .01769 L
.07976 .01769 L
.08005 .01769 L
.08032 .01769 L
.08057 .01769 L
.08085 .01769 L
.08114 .01769 L
.08143 .01769 L
.08174 .01769 L
.08204 .01769 L
.08231 .01769 L
.08262 .01769 L
.0828 .01769 L
.08297 .01769 L
.08327 .01769 L
.08359 .01769 L
.0839 .01769 L
.08424 .01769 L
.08456 .01769 L
.08486 .01769 L
.08512 .01769 L
.08542 .01769 L
.08573 .01769 L
.08602 .01769 L
.08634 .01769 L
.08667 .01769 L
.08696 .01769 L
.08727 .01769 L
.08761 .01769 L
.0878 .01769 L
.08797 .01769 L
.08831 .01769 L
.08863 .01769 L
.0889 .01769 L
.0892 .01769 L
.08951 .01769 L
.0898 .01769 L
.09007 .01769 L
.09032 .01769 L
.09061 .01769 L
.09088 .01769 L
.09118 .01769 L
Mistroke
.09149 .01769 L
.09179 .01769 L
.09206 .01769 L
.09237 .01769 L
.09255 .01769 L
.09272 .01769 L
.09302 .01769 L
.09334 .01769 L
.09365 .01769 L
.09383 .01769 L
.09399 .01769 L
.09429 .01769 L
.09461 .01769 L
.0949 .01769 L
.09516 .01769 L
.09546 .01769 L
.09577 .01769 L
.09609 .01769 L
.09627 .01769 L
.09644 .01769 L
.09678 .01769 L
.09696 .01769 L
.09714 .01769 L
.09745 .01769 L
.09778 .01769 L
.0981 .01769 L
.09839 .01769 L
.09866 .01769 L
.09895 .01769 L
.09922 .01769 L
.09948 .01769 L
.09977 .01769 L
.10009 .01769 L
.10039 .01769 L
.10068 .01769 L
.10099 .01769 L
.10129 .01769 L
.10156 .01769 L
.10185 .01769 L
.10217 .01769 L
.1025 .01769 L
.10279 .01769 L
.1031 .01769 L
.10344 .01769 L
.10375 .01769 L
.10391 .01769 L
.10409 .01769 L
.10428 .01769 L
.10445 .01769 L
.10477 .01769 L
Mistroke
.10507 .01769 L
.10541 .01769 L
.10573 .01769 L
.10602 .01769 L
.10632 .01769 L
.10661 .01769 L
.10688 .01769 L
.10718 .01769 L
.10752 .01769 L
.10784 .01769 L
.10813 .01769 L
.10844 .01769 L
.10877 .01769 L
.10909 .01769 L
.10937 .01769 L
.10971 .01769 L
.1099 .01769 L
.11008 .01769 L
.1104 .01769 L
.11056 .01769 L
.11074 .01769 L
.11092 .01769 L
.1111 .01769 L
.11143 .01769 L
.11161 .01769 L
.11178 .01769 L
.11197 .01769 L
.11217 .01769 L
.11234 .01769 L
.11253 .01769 L
.11271 .01769 L
.11287 .01769 L
.11318 .01769 L
.11351 .01769 L
.11382 .01769 L
.11416 .01769 L
.11448 .01769 L
.11477 .01769 L
.11507 .01769 L
.11533 .01769 L
.11564 .01769 L
.11593 .01769 L
.11625 .01769 L
.11658 .01769 L
.11687 .01769 L
.11718 .01769 L
.11752 .01769 L
.11771 .01769 L
.11788 .01769 L
.11822 .01769 L
Mistroke
.11853 .01769 L
.1188 .01769 L
.1191 .01769 L
.11941 .01769 L
.11971 .01769 L
.11998 .01769 L
.12023 .01769 L
.1205 .01769 L
.12079 .01769 L
.12108 .01769 L
.1214 .01769 L
.12169 .01769 L
.12196 .01769 L
.12228 .01769 L
.12245 .01769 L
.12262 .01769 L
.12292 .01769 L
.12324 .01769 L
.12355 .01769 L
.12389 .01769 L
.12421 .01769 L
.12451 .01769 L
.1248 .01769 L
.12507 .01769 L
.12538 .01769 L
.12567 .01769 L
.12599 .01769 L
.12632 .01769 L
.12661 .01769 L
.12692 .01769 L
.12726 .01769 L
.12745 .01769 L
.12762 .01769 L
.12796 .01769 L
.12828 .01769 L
.12855 .01769 L
.12885 .01769 L
.12916 .01769 L
.12945 .01769 L
.12972 .01769 L
.12997 .01769 L
.13026 .01769 L
.13054 .01769 L
.13083 .01769 L
.13114 .01769 L
.13144 .01769 L
.13171 .01769 L
.13202 .01769 L
.1322 .01769 L
.13237 .01769 L
Mistroke
.13267 .01769 L
.13299 .01769 L
.1333 .01769 L
.13348 .01769 L
.13364 .01769 L
.13394 .01769 L
.13426 .01769 L
.13455 .01769 L
.13481 .01769 L
.13511 .01769 L
.13542 .01769 L
.13574 .01769 L
.13592 .01769 L
.13609 .01769 L
.13642 .01769 L
.13661 .01769 L
.13678 .01769 L
.13709 .01769 L
.13743 .01769 L
.13774 .01769 L
.13803 .01769 L
.13831 .01769 L
.1386 .01769 L
.13887 .01769 L
.13912 .01769 L
.13942 .01769 L
.13974 .01769 L
.14004 .01769 L
.14032 .01769 L
.14064 .01769 L
.14094 .01769 L
.14121 .01769 L
.1415 .01769 L
.14181 .01769 L
.14215 .01769 L
.14243 .01769 L
.14275 .01769 L
.14308 .01769 L
.14339 .01769 L
.14356 .01769 L
.14374 .01769 L
.14392 .01769 L
.1441 .01769 L
.14442 .01769 L
.14471 .01769 L
.14504 .01769 L
.14538 .01769 L
.14566 .01769 L
.14597 .01769 L
.14626 .01769 L
Mistroke
.14652 .01769 L
.14683 .01769 L
.14716 .01769 L
.14748 .01769 L
.14777 .01769 L
.14808 .01769 L
.14841 .01769 L
.14873 .01769 L
.14902 .01769 L
.14935 .01769 L
.14954 .01769 L
.14972 .01769 L
.15004 .01769 L
.15021 .01769 L
.15039 .01769 L
.15056 .01769 L
.15074 .01769 L
.15107 .01769 L
.15125 .01769 L
.15142 .01769 L
.15161 .01769 L
.15181 .01769 L
.15198 .01769 L
.15217 .01769 L
.15235 .01769 L
.15251 .01769 L
.15282 .01769 L
.15315 .01769 L
.15346 .01769 L
.1538 .01769 L
.15412 .01769 L
.15441 .01769 L
.15471 .01769 L
.15497 .01769 L
.15528 .01769 L
.15557 .01769 L
.15589 .01769 L
.15622 .01769 L
.15651 .01769 L
.15682 .01769 L
.15716 .01769 L
.15735 .01769 L
.15752 .01769 L
.15786 .01769 L
.15818 .01769 L
.15845 .01769 L
.15874 .01769 L
.15905 .01769 L
.15935 .01769 L
.15962 .01769 L
Mistroke
.15987 .01769 L
.16014 .01769 L
.16043 .01769 L
.16072 .01769 L
.16104 .01769 L
.16133 .01769 L
.1616 .01769 L
.16192 .01769 L
.16209 .01769 L
.16226 .01769 L
.16256 .01769 L
.16288 .01769 L
.16319 .01769 L
.16353 .01769 L
.16385 .01769 L
.16415 .01769 L
.16444 .01769 L
.16471 .01769 L
.16502 .01769 L
.16531 .01769 L
.16563 .01769 L
.16596 .01769 L
.16625 .01769 L
.16656 .01769 L
.1669 .01769 L
.16709 .01769 L
.16726 .01769 L
.1676 .01769 L
.16792 .01769 L
.16819 .01769 L
.16848 .01769 L
.1688 .01769 L
.16909 .01769 L
.16936 .01769 L
.16961 .01769 L
.1699 .01769 L
.17017 .01769 L
.17047 .01769 L
.17078 .01769 L
.17108 .01769 L
.17134 .01769 L
.17166 .01769 L
.17184 .01769 L
.172 .01769 L
.1723 .01769 L
.17262 .01769 L
.17294 .01769 L
.17311 .01769 L
.17328 .01769 L
.17358 .01769 L
Mistroke
.1739 .01769 L
.17418 .01769 L
.17445 .01769 L
.17474 .01769 L
.17506 .01769 L
.17537 .01769 L
.17555 .01769 L
.17572 .01769 L
.17606 .01769 L
.17625 .01769 L
.17642 .01769 L
.17673 .01769 L
.17706 .01769 L
.17738 .01769 L
.17767 .01769 L
.17794 .01769 L
.17823 .01769 L
.17851 .01769 L
.17876 .01769 L
.17905 .01769 L
.17937 .01769 L
.17968 .01769 L
.17996 .01769 L
.18027 .01769 L
.18057 .01769 L
.18084 .01769 L
.18113 .01769 L
.18145 .01769 L
.18178 .01769 L
.18207 .01769 L
.18238 .01769 L
.18272 .01769 L
.18303 .01769 L
.18319 .01769 L
.18337 .01769 L
.18356 .01769 L
.18373 .01769 L
.18405 .01769 L
.18435 .01769 L
.18467 .01769 L
.18501 .01769 L
.1853 .01769 L
.1856 .01769 L
.18589 .01769 L
.18615 .01769 L
.18646 .01769 L
.1868 .01769 L
.18711 .01769 L
.1874 .01769 L
.18771 .01769 L
Mistroke
.18805 .01769 L
.18836 .01769 L
.18865 .01769 L
.18898 .01769 L
.18917 .01769 L
.18935 .01769 L
.18967 .01769 L
.18984 .01769 L
.19002 .01769 L
.19019 .01769 L
.19037 .01769 L
.1907 .01769 L
.19088 .01769 L
.19106 .01769 L
.19124 .01769 L
.19144 .01769 L
.19161 .01769 L
.1918 .01769 L
.19198 .01769 L
.19214 .01769 L
.19245 .01769 L
.19278 .01769 L
.19309 .01769 L
.19343 .01769 L
.19375 .01769 L
.19405 .01769 L
.19434 .01769 L
.1946 .01769 L
.19491 .01769 L
.1952 .01769 L
.19552 .01769 L
.19585 .01769 L
.19614 .01769 L
.19645 .01769 L
.19679 .01769 L
.19698 .01769 L
.19715 .01769 L
.19749 .01769 L
.1978 .01769 L
.19807 .01769 L
.19837 .01769 L
.19868 .01769 L
.19897 .01769 L
.19925 .01769 L
.1995 .01769 L
.19977 .01769 L
.20006 .01769 L
.20035 .01769 L
.20066 .01769 L
.20096 .01769 L
Mistroke
.20123 .01769 L
.20154 .01769 L
.20172 .01769 L
.20189 .01769 L
.20219 .01769 L
.20251 .01769 L
.20282 .01769 L
.20316 .01769 L
.20348 .01769 L
.20378 .01769 L
.20407 .01769 L
.20434 .01769 L
.20464 .01769 L
.20493 .01769 L
.20525 .01769 L
.20559 .01769 L
.20587 .01769 L
.20619 .01769 L
.20653 .01769 L
.20672 .01769 L
.20689 .01769 L
.20722 .01769 L
.20754 .01769 L
.20781 .01769 L
.20811 .01769 L
.20842 .01769 L
.20871 .01769 L
.20899 .01769 L
.20924 .01769 L
.20951 .01769 L
.2098 .01769 L
.21009 .01769 L
.2104 .01769 L
.2107 .01769 L
.21097 .01769 L
.21129 .01769 L
.21146 .01769 L
.21163 .01769 L
.21193 .01769 L
.21225 .01769 L
.21256 .01769 L
.21274 .01769 L
.2129 .01769 L
.2132 .01769 L
.21352 .01769 L
.2138 .01769 L
.21407 .01769 L
.21437 .01769 L
.21468 .01769 L
.215 .01769 L
Mistroke
.21518 .01769 L
.21534 .01769 L
.21568 .01769 L
.21587 .01769 L
.21604 .01769 L
.21635 .01769 L
.21668 .01769 L
.217 .01769 L
.21729 .01769 L
.21756 .01769 L
.21785 .01769 L
.21813 .01769 L
.21838 .01769 L
.21867 .01769 L
.21899 .01769 L
.2193 .01769 L
.21958 .01769 L
.2199 .01769 L
.22019 .01769 L
.22046 .01769 L
.22075 .01769 L
.22107 .01769 L
.2214 .01769 L
.22169 .01769 L
.222 .01769 L
.22234 .01769 L
.22265 .01769 L
.22281 .01769 L
.22299 .01769 L
.22318 .01769 L
.22335 .01769 L
.22367 .01769 L
.22397 .01769 L
.22429 .01769 L
.22463 .01769 L
.22492 .01769 L
.22522 .01769 L
.22551 .01769 L
.22577 .01769 L
.22608 .01769 L
.22642 .01769 L
.22673 .01769 L
.22702 .01769 L
.22733 .01769 L
.22767 .01769 L
.22798 .01769 L
.22827 .01769 L
.2286 .01769 L
.22879 .01769 L
.22897 .01769 L
Mistroke
.22929 .01769 L
.22947 .01769 L
.22963 .01769 L
.22981 .01769 L
.22999 .01769 L
.23032 .01769 L
.2305 .01769 L
.23067 .01769 L
.23086 .01769 L
.23106 .01769 L
.23123 .01769 L
.23142 .01769 L
.2316 .01769 L
.23176 .01769 L
.23207 .01769 L
.2324 .01769 L
.23271 .01769 L
.23305 .01769 L
.23337 .01769 L
.23366 .01769 L
.23396 .01769 L
.23422 .01769 L
.23453 .01769 L
.23482 .01769 L
.23513 .01769 L
.23547 .01769 L
.23575 .01769 L
.23607 .01769 L
.23641 .01769 L
.23659 .01769 L
.23677 .01769 L
.2371 .01769 L
.23742 .01769 L
.23769 .01769 L
.23799 .01769 L
.2383 .01769 L
.23859 .01769 L
.23886 .01769 L
.23911 .01769 L
.23938 .01769 L
.23967 .01769 L
.23997 .01769 L
.24028 .01769 L
.24057 .01769 L
.24084 .01769 L
.24116 .01769 L
.24134 .01769 L
.2415 .01769 L
.2418 .01769 L
.24212 .01769 L
Mistroke
.24243 .01769 L
.24277 .01769 L
.24309 .01769 L
.24339 .01769 L
.24368 .01769 L
.24395 .01769 L
.24426 .01769 L
.24455 .01769 L
.24487 .01769 L
.2452 .01769 L
.24549 .01769 L
.2458 .01769 L
.24614 .01769 L
.24633 .01769 L
.2465 .01769 L
.24684 .01769 L
.24715 .01769 L
.24742 .01769 L
.24772 .01769 L
.24803 .01769 L
.24833 .01769 L
.2486 .01769 L
.24885 .01769 L
.24912 .01769 L
.24941 .01769 L
.2497 .01769 L
.25002 .01769 L
.25031 .01769 L
.25058 .01769 L
.2509 .01769 L
.25108 .01769 L
.25124 .01769 L
.25154 .01769 L
.25186 .01769 L
.25217 .01769 L
.25235 .01769 L
.25251 .01769 L
.25281 .01769 L
.25313 .01769 L
.25342 .01769 L
.25368 .01769 L
.25398 .01769 L
.25429 .01769 L
.25461 .01769 L
.25479 .01769 L
.25495 .01769 L
.25529 .01769 L
.25548 .01769 L
.25565 .01769 L
.25596 .01769 L
Mistroke
.25629 .01769 L
.25661 .01769 L
.2569 .01769 L
.25717 .01769 L
.25746 .01769 L
.25774 .01769 L
.25799 .01769 L
.25828 .01769 L
.2586 .01769 L
.25891 .01769 L
.25919 .01769 L
.2595 .01769 L
.2598 .01769 L
.26007 .01769 L
.26036 .01769 L
.26068 .01769 L
.26101 .01769 L
.2613 .01769 L
.26161 .01769 L
.26184 .01769 L
.26205 .01769 L
.26228 .01769 L
.26252 .01769 L
.26273 .01769 L
.26293 .01769 L
.26315 .01769 L
.26338 .01769 L
.26358 .01769 L
.2638 .01769 L
.26402 .01769 L
.26423 .01769 L
.26442 .01769 L
.2646 .01769 L
.26481 .01769 L
.265 .01769 L
.26521 .01769 L
.26544 .01769 L
.26568 .01769 L
.26591 .01769 L
.26612 .01769 L
.26631 .01769 L
.26653 .01769 L
.26674 .01769 L
.26697 .01769 L
.26721 .01769 L
.26744 .01769 L
.26765 .01769 L
.26789 .01769 L
.26816 .01769 L
.26841 .01769 L
Mistroke
.26863 .01769 L
Mfstroke
.02381 .01782 m
.02411 .04101 L
.02439 .04993 L
.025 .06408 L
.02612 .08218 L
.02742 .09834 L
.02864 .1111 L
.03374 .15176 L
.03894 .18339 L
.04457 .21213 L
.05508 .25699 L
.06519 .29374 L
.07492 .32528 L
.08528 .35595 L
.09524 .38332 L
.10584 .41061 L
.11605 .43547 L
.12587 .45828 L
.13632 .48156 L
.14637 .50312 L
.15706 .52525 L
.16736 .5459 L
.17727 .56522 L
.18781 .58524 L
.19796 .60405 L
.20773 .62175 L
.21812 .6402 L
.22812 .65762 L
.23875 .6758 L
.249 .69301 L
.25885 .7093 L
.26863 .72525 L
s
0 1 1 r
.02381 .01769 m
.02411 .01769 L
.02439 .01769 L
.0247 .01769 L
.025 .01769 L
.02528 .01769 L
.02554 .01769 L
.02582 .01769 L
.02612 .01769 L
.02642 .01769 L
.02674 .01769 L
.02704 .01769 L
.02732 .01769 L
.02764 .01769 L
.02783 .01769 L
.028 .01769 L
.02831 .01769 L
.02864 .01769 L
.02881 .01769 L
.02899 .01769 L
.02931 .01769 L
.02948 .01769 L
.02965 .01769 L
.02983 .01769 L
.03002 .01769 L
.03019 .01769 L
.03037 .01769 L
.0307 .01769 L
.03102 .01769 L
.03132 .01769 L
.03161 .01769 L
.03188 .01769 L
.03217 .01769 L
.03249 .01769 L
.03281 .01769 L
.03314 .01769 L
.03343 .01769 L
.03374 .01769 L
.03392 .01769 L
.03409 .01769 L
.03428 .01769 L
.03447 .01769 L
.0348 .01769 L
.03499 .01769 L
.03516 .01769 L
.03549 .01769 L
.03579 .01769 L
.03595 .01769 L
.03613 .01769 L
.03645 .01769 L
.03665 .01769 L
.03684 .01769 L
.037 .01769 L
.03718 .01769 L
.03738 .01769 L
.03759 .01769 L
.03776 .01769 L
.03796 .01769 L
.03814 .01769 L
.03831 .01769 L
.0385 .01769 L
.03868 .01769 L
.039 .01769 L
.03918 .01769 L
.03935 .01769 L
.03965 .01769 L
.03997 .01769 L
.04028 .01769 L
.04056 .01769 L
.04087 .01769 L
.0412 .01769 L
.04138 .01769 L
.04156 .01769 L
.04189 .01769 L
.04207 .01769 L
.04223 .01769 L
.04242 .01769 L
.04261 .01769 L
.04294 .01769 L
.04312 .01769 L
.04329 .01769 L
.04362 .01769 L
.04391 .01769 L
.04425 .01769 L
.04457 .01769 L
.04486 .01769 L
.04518 .01769 L
.04548 .01769 L
.04575 .01769 L
.04605 .01769 L
.04638 .01769 L
.04655 .01769 L
.04673 .01769 L
.04705 .01769 L
.04723 .01769 L
.04739 .01769 L
.04757 .01769 L
.04776 .01769 L
.04808 .01769 L
.04826 .01769 L
.04843 .01769 L
.04875 .01769 L
.04903 .01769 L
.04937 .01769 L
.04968 .01769 L
.04998 .01769 L
.05025 .01769 L
.05056 .01769 L
.05086 .01769 L
.05113 .01769 L
.05138 .01769 L
.05166 .01769 L
.05195 .01769 L
.05224 .01769 L
.05256 .01769 L
.05285 .01769 L
.05313 .01769 L
.05344 .01769 L
.05362 .01769 L
.05379 .01769 L
.05409 .01769 L
.05442 .01769 L
.05471 .01769 L
.05503 .01769 L
.05537 .01769 L
.05568 .01769 L
.05597 .01769 L
.05623 .01769 L
.05654 .01769 L
.05683 .01769 L
.05714 .01769 L
.05748 .01769 L
.05776 .01769 L
.05808 .01769 L
.05841 .01769 L
.0586 .01769 L
.05877 .01769 L
.05911 .01769 L
.05943 .01769 L
.05972 .01769 L
.05999 .01769 L
.0603 .01769 L
.06059 .01769 L
.06087 .01769 L
.06111 .01769 L
.06139 .01769 L
.06168 .01769 L
.06197 .01769 L
.06228 .01769 L
.06258 .01769 L
.06285 .01769 L
.06316 .01769 L
.06334 .01769 L
.0635 .01769 L
.06381 .01769 L
.06413 .01769 L
.06444 .01769 L
.06477 .01769 L
.06509 .01769 L
.06539 .01769 L
.06568 .01769 L
.06595 .01769 L
.06626 .01769 L
.06654 .01769 L
.06686 .01769 L
.0672 .01769 L
.06748 .01769 L
.06779 .01769 L
.06813 .01769 L
.06832 .01769 L
.06849 .01769 L
.06883 .01769 L
.06915 .01769 L
.06942 .01769 L
.06971 .01769 L
.07002 .01769 L
.07032 .01769 L
.07059 .01769 L
.07084 .01769 L
.07111 .01769 L
.0714 .01769 L
.07169 .01769 L
.07201 .01769 L
.0723 .01769 L
.07257 .01769 L
.07289 .01769 L
.07306 .01769 L
.07323 .01769 L
.07353 .01769 L
.07385 .01769 L
.07416 .01769 L
.0745 .01769 L
.07482 .01769 L
.07512 .01769 L
.07541 .01769 L
.07568 .01769 L
.07598 .01769 L
.07627 .01769 L
.07659 .01769 L
.07693 .01769 L
.07721 .01769 L
.07753 .01769 L
.07786 .01769 L
.07805 .01769 L
.07823 .01769 L
.07856 .01769 L
.07888 .01769 L
.07915 .01769 L
.07945 .01769 L
.07976 .01769 L
.08005 .01769 L
.08032 .01769 L
.08057 .01769 L
.08085 .01769 L
.08114 .01769 L
.08143 .01769 L
.08174 .01769 L
.08204 .01769 L
.08231 .01769 L
.08262 .01769 L
.0828 .01769 L
.08297 .01769 L
.08327 .01769 L
.08359 .01769 L
.0839 .01769 L
.08424 .01769 L
.08456 .01769 L
.08486 .01769 L
.08512 .01769 L
.08542 .01769 L
.08573 .01769 L
.08602 .01769 L
.08634 .01769 L
.08667 .01769 L
.08696 .01769 L
.08727 .01769 L
.08761 .01769 L
.0878 .01769 L
.08797 .01769 L
.08831 .01769 L
.08863 .01769 L
.0889 .01769 L
.0892 .01769 L
.08951 .01769 L
.0898 .01769 L
.09007 .01769 L
.09032 .01769 L
.09061 .01769 L
.09088 .01769 L
.09118 .01769 L
.09149 .01769 L
.09179 .01769 L
.09206 .01769 L
.09237 .01769 L
.09255 .01769 L
.09272 .01769 L
.09302 .01769 L
.09334 .01769 L
.09365 .01769 L
.09383 .01769 L
.09399 .01769 L
.09429 .01769 L
.09461 .01769 L
.0949 .01769 L
.09516 .01769 L
.09546 .01769 L
.09577 .01769 L
.09609 .01769 L
.09627 .01769 L
.09644 .01769 L
.09678 .01769 L
.09696 .01769 L
.09714 .01769 L
.09745 .01769 L
.09778 .01769 L
.0981 .01769 L
.09839 .01769 L
.09866 .01769 L
.09895 .01769 L
.09922 .01769 L
.09948 .01769 L
.09977 .01769 L
.10009 .01769 L
.10039 .01769 L
.10068 .01769 L
.10099 .01769 L
.10129 .01769 L
.10156 .01769 L
.10185 .01769 L
.10217 .01769 L
.1025 .01769 L
.10279 .01769 L
.1031 .01769 L
.10344 .01769 L
.10375 .01769 L
.10391 .01769 L
.10409 .01769 L
.10428 .01769 L
.10445 .01769 L
.10477 .01769 L
.10507 .01769 L
.10541 .01769 L
.10573 .01769 L
.10602 .01769 L
.10632 .01769 L
.10661 .01769 L
.10688 .01769 L
.10718 .01769 L
.10752 .01769 L
.10784 .01769 L
.10813 .01769 L
.10844 .01769 L
.10877 .01769 L
.10909 .01769 L
.10937 .01769 L
.10971 .01769 L
.1099 .01769 L
.11008 .01769 L
.1104 .01769 L
.11056 .01769 L
.11074 .01769 L
.11092 .01769 L
.1111 .01769 L
.11143 .01769 L
.11161 .01769 L
.11178 .01769 L
.11197 .01769 L
.11217 .01769 L
.11234 .01769 L
.11253 .01769 L
.11271 .01769 L
.11287 .01769 L
.11318 .01769 L
.11351 .01769 L
.11382 .01769 L
.11416 .01769 L
.11448 .01769 L
.11477 .01769 L
.11507 .01769 L
.11533 .01769 L
.11564 .01769 L
.11593 .01769 L
.11625 .01769 L
.11658 .01769 L
.11687 .01769 L
.11718 .01769 L
.11752 .01769 L
.11771 .01769 L
.11788 .01769 L
.11822 .01769 L
.11853 .01769 L
.1188 .01769 L
.1191 .01769 L
.11941 .01769 L
.11971 .01769 L
.11998 .01769 L
.12023 .01769 L
.1205 .01769 L
.12079 .01769 L
.12108 .01769 L
.1214 .01769 L
.12169 .01769 L
.12196 .01769 L
.12228 .01769 L
.12245 .01769 L
.12262 .01769 L
.12292 .01769 L
.12324 .01769 L
.12355 .01769 L
.12389 .01769 L
.12421 .01769 L
.12451 .01769 L
.1248 .01769 L
.12507 .01769 L
.12538 .01769 L
.12567 .01769 L
.12599 .01769 L
.12632 .01769 L
.12661 .01769 L
.12692 .01769 L
.12726 .01769 L
.12745 .01769 L
.12762 .01769 L
.12796 .01769 L
.12828 .01769 L
.12855 .01769 L
.12885 .01769 L
.12916 .01769 L
.12945 .01769 L
.12972 .01769 L
.12997 .01769 L
.13026 .01769 L
.13054 .01769 L
.13083 .01769 L
.13114 .01769 L
.13144 .01769 L
.13171 .01769 L
.13202 .01769 L
.1322 .01769 L
.13237 .01769 L
.13267 .01769 L
.13299 .01769 L
.1333 .01769 L
.13348 .01769 L
.13364 .01769 L
.13394 .01769 L
.13426 .01769 L
.13455 .01769 L
.13481 .01769 L
.13511 .01769 L
.13542 .01769 L
.13574 .01769 L
.13592 .01769 L
.13609 .01769 L
.13642 .01769 L
.13661 .01769 L
.13678 .01769 L
.13709 .01769 L
.13743 .01769 L
.13774 .01769 L
.13803 .01769 L
.13831 .01769 L
.1386 .01769 L
.13887 .01769 L
.13912 .01769 L
.13942 .01769 L
.13974 .01769 L
.14004 .01769 L
.14032 .01769 L
.14064 .01769 L
.14094 .01769 L
.14121 .01769 L
.1415 .01769 L
.14181 .01769 L
.14215 .01769 L
.14243 .01769 L
.14275 .01769 L
.14308 .01769 L
.14339 .01769 L
.14356 .01769 L
.14374 .01769 L
.14392 .01769 L
.1441 .01769 L
.14442 .01769 L
.14471 .01769 L
.14504 .01769 L
.14538 .01769 L
.14566 .01769 L
.14597 .01769 L
.14626 .01769 L
.14652 .01769 L
.14683 .01769 L
.14716 .01769 L
.14748 .01769 L
.14777 .01769 L
.14808 .01769 L
.14841 .01769 L
.14873 .01769 L
.14902 .01769 L
.14935 .01769 L
.14954 .01769 L
.14972 .01769 L
.15004 .01769 L
.15021 .01769 L
.15039 .01769 L
.15056 .01769 L
.15074 .01769 L
.15107 .01769 L
.15125 .01769 L
.15142 .01769 L
.15161 .01769 L
.15181 .01769 L
.15198 .01769 L
.15217 .01769 L
.15235 .01769 L
.15251 .01769 L
.15282 .01769 L
.15315 .01769 L
.15346 .01769 L
.1538 .01769 L
.15412 .01769 L
.15441 .01769 L
.15471 .01769 L
.15497 .01769 L
.15528 .01769 L
.15557 .01769 L
.15589 .01769 L
.15622 .01769 L
.15651 .01769 L
.15682 .01769 L
.15716 .01769 L
.15735 .01769 L
.15752 .01769 L
.15786 .01769 L
.15818 .01769 L
.15845 .01769 L
.15874 .01769 L
.15905 .01769 L
.15935 .01769 L
.15962 .01769 L
.15987 .01769 L
.16014 .01769 L
.16043 .01769 L
.16072 .01769 L
.16104 .01769 L
.16133 .01769 L
.1616 .01769 L
.16192 .01769 L
.16209 .01769 L
.16226 .01769 L
.16256 .01769 L
.16288 .01769 L
.16319 .01769 L
.16353 .01769 L
.16385 .01769 L
.16415 .01769 L
.16444 .01769 L
.16471 .01769 L
.16502 .01769 L
.16531 .01769 L
.16563 .01769 L
.16596 .01769 L
.16625 .01769 L
.16656 .01769 L
.1669 .01769 L
.16709 .01769 L
.16726 .01769 L
.1676 .01769 L
.16792 .01769 L
.16819 .01769 L
.16848 .01769 L
.1688 .01769 L
.16909 .01769 L
.16936 .01769 L
.16961 .01769 L
.1699 .01769 L
.17017 .01769 L
.17047 .01769 L
.17078 .01769 L
.17108 .01769 L
.17134 .01769 L
.17166 .01769 L
.17184 .01769 L
.172 .01769 L
.1723 .01769 L
.17262 .01769 L
.17294 .01769 L
.17311 .01769 L
.17328 .01769 L
.17358 .01769 L
.1739 .01769 L
.17418 .01769 L
.17445 .01769 L
.17474 .01769 L
.17506 .01769 L
.17537 .01769 L
.17555 .01769 L
.17572 .01769 L
.17606 .01769 L
.17625 .01769 L
.17642 .01769 L
.17673 .01769 L
.17706 .01769 L
.17738 .01769 L
.17767 .01769 L
.17794 .01769 L
.17823 .01769 L
.17851 .01769 L
.17876 .01769 L
.17905 .01769 L
.17937 .01769 L
.17968 .01769 L
.17996 .01769 L
.18027 .01769 L
.18057 .01769 L
.18084 .01769 L
.18113 .01769 L
.18145 .01769 L
.18178 .01769 L
.18207 .01769 L
.18238 .01769 L
.18272 .01769 L
.18303 .01769 L
.18319 .01769 L
.18337 .01769 L
.18356 .01769 L
.18373 .01769 L
.18405 .01769 L
.18435 .01769 L
.18467 .01769 L
.18501 .01769 L
.1853 .01769 L
.1856 .01769 L
.18589 .01769 L
.18615 .01769 L
.18646 .01769 L
.1868 .01769 L
.18711 .01769 L
.1874 .01769 L
.18771 .01769 L
.18805 .01769 L
.18836 .01769 L
.18865 .01769 L
.18898 .01769 L
.18917 .01769 L
.18935 .01769 L
.18967 .01769 L
.18984 .01769 L
.19002 .01769 L
.19019 .01769 L
.19037 .01769 L
.1907 .01769 L
.19088 .01769 L
.19106 .01769 L
.19124 .01769 L
.19144 .01769 L
.19161 .01769 L
.1918 .01769 L
.19198 .01769 L
.19214 .01769 L
.19245 .01769 L
.19278 .01769 L
.19309 .01769 L
.19343 .01769 L
.19375 .01769 L
.19405 .01769 L
.19434 .01769 L
.1946 .01769 L
.19491 .01769 L
.1952 .01769 L
.19552 .01769 L
.19585 .01769 L
.19614 .01769 L
.19645 .01769 L
.19679 .01769 L
.19698 .01769 L
.19715 .01769 L
.19749 .01769 L
.1978 .01769 L
.19807 .01769 L
.19837 .01769 L
.19868 .01769 L
.19897 .01769 L
.19925 .01769 L
.1995 .01769 L
.19977 .01769 L
.20006 .01769 L
.20035 .01769 L
.20066 .01769 L
.20096 .01769 L
.20123 .01769 L
.20154 .01769 L
.20172 .01769 L
.20189 .01769 L
.20219 .01769 L
.20251 .01769 L
.20282 .01769 L
.20316 .01769 L
.20348 .01769 L
.20378 .01769 L
.20407 .01769 L
.20434 .01769 L
.20464 .01769 L
.20493 .01769 L
.20525 .01769 L
.20559 .01769 L
.20587 .01769 L
.20619 .01769 L
.20653 .01769 L
.20672 .01769 L
.20689 .01769 L
.20722 .01769 L
.20754 .01769 L
.20781 .01769 L
.20811 .01769 L
.20842 .01769 L
.20871 .01769 L
.20899 .01769 L
.20924 .01769 L
.20951 .01769 L
.2098 .01769 L
.21009 .01769 L
.2104 .01769 L
.2107 .01769 L
.21097 .01769 L
.21129 .01769 L
.21146 .01769 L
.21163 .01769 L
.21193 .01769 L
.21225 .01769 L
.21256 .01769 L
.21274 .01769 L
.2129 .01769 L
.2132 .01769 L
.21352 .01769 L
.2138 .01769 L
.21407 .01769 L
.21437 .01769 L
.21468 .01769 L
.215 .01769 L
.21518 .01769 L
.21534 .01769 L
.21568 .01769 L
.21587 .01769 L
.21604 .01769 L
.21635 .01769 L
.21668 .01769 L
.217 .01769 L
.21729 .01769 L
.21756 .01769 L
.21785 .01769 L
.21813 .01769 L
.21838 .01769 L
.21867 .01769 L
.21899 .01769 L
.2193 .01769 L
.21958 .01769 L
.2199 .01769 L
.22019 .01769 L
.22046 .01769 L
.22075 .01769 L
.22107 .01769 L
.2214 .01769 L
.22169 .01769 L
.222 .01769 L
.22234 .01769 L
.22265 .01769 L
.22281 .01769 L
.22299 .01769 L
.22318 .01769 L
.22335 .01769 L
.22367 .01769 L
.22397 .01769 L
.22429 .01769 L
.22463 .01769 L
.22492 .01769 L
.22522 .01769 L
.22551 .01769 L
.22577 .01769 L
.22608 .01769 L
.22642 .01769 L
.22673 .01769 L
.22702 .01769 L
.22733 .01769 L
.22767 .01769 L
.22798 .01769 L
.22827 .01769 L
.2286 .01769 L
.22879 .01769 L
.22897 .01769 L
.22929 .01769 L
.22947 .01769 L
.22963 .01769 L
.22981 .01769 L
.22999 .01769 L
.23032 .01769 L
.2305 .01769 L
.23067 .01769 L
.23086 .01769 L
.23106 .01769 L
.23123 .01769 L
.23142 .01769 L
.2316 .01769 L
.23176 .01769 L
.23207 .01769 L
.2324 .01769 L
.23271 .01769 L
.23305 .01769 L
.23337 .01769 L
.23366 .01769 L
.23396 .01769 L
.23422 .01769 L
.23453 .01769 L
.23482 .01769 L
.23513 .01769 L
.23547 .01769 L
.23575 .01769 L
.23607 .01769 L
.23641 .01769 L
.23659 .01769 L
.23677 .01769 L
.2371 .01769 L
.23742 .01769 L
.23769 .01769 L
.23799 .01769 L
.2383 .01769 L
.23859 .01769 L
.23886 .01769 L
.23911 .01769 L
.23938 .01769 L
.23967 .01769 L
.23997 .01769 L
.24028 .01769 L
.24057 .01769 L
.24084 .01769 L
.24116 .01769 L
.24134 .01769 L
.2415 .01769 L
.2418 .01769 L
.24212 .01769 L
.24243 .01769 L
.24277 .01769 L
.24309 .01769 L
.24339 .01769 L
.24368 .01769 L
.24395 .01769 L
.24426 .01769 L
.24455 .01769 L
.24487 .01769 L
.2452 .01769 L
.24549 .01769 L
.2458 .01769 L
.24614 .01769 L
.24633 .01769 L
.2465 .01769 L
.24684 .01769 L
.24715 .01769 L
.24742 .01769 L
.24772 .01769 L
.24803 .01769 L
.24833 .01769 L
.2486 .01769 L
.24885 .01769 L
.24912 .01769 L
.24941 .01769 L
.2497 .01769 L
.25002 .01769 L
.25031 .01769 L
.25058 .01769 L
.2509 .01769 L
.25108 .01769 L
.25124 .01769 L
.25154 .01769 L
.25186 .01769 L
.25217 .01769 L
.25235 .01769 L
.25251 .01769 L
.25281 .01769 L
.25313 .01769 L
.25342 .01769 L
.25368 .01769 L
.25398 .01769 L
.25429 .01769 L
.25461 .01769 L
.25479 .01769 L
.25495 .01769 L
.25529 .01769 L
.25548 .01769 L
.25565 .01769 L
.25596 .01769 L
.25629 .01769 L
.25661 .01769 L
.2569 .01769 L
.25717 .01769 L
.25746 .01769 L
.25774 .01769 L
.25799 .01769 L
.25828 .01769 L
.2586 .01769 L
.25891 .01769 L
.25919 .01769 L
.2595 .01769 L
.2598 .01769 L
.26007 .01769 L
.26036 .01769 L
.26068 .01769 L
.26101 .01769 L
.2613 .01769 L
.26161 .01769 L
.26184 .01769 L
.26205 .01769 L
.26228 .01769 L
.26252 .01769 L
.26273 .01769 L
.26293 .01769 L
.26315 .01769 L
.26338 .01769 L
.26358 .01769 L
.2638 .01769 L
.26402 .01769 L
.26423 .01769 L
.26442 .01769 L
.2646 .01769 L
.26481 .01769 L
.265 .01769 L
.26521 .01769 L
.26544 .01769 L
.26568 .01769 L
.26591 .01769 L
.26612 .01769 L
.26631 .01769 L
.26653 .01769 L
.26674 .01769 L
.26697 .01769 L
.26721 .01769 L
.26744 .01769 L
.26765 .01769 L
.26789 .01769 L
.26816 .01769 L
.26841 .01769 L
.26863 .01769 L
.26863 .72525 L
.25885 .7093 L
.249 .69301 L
.23875 .6758 L
.22812 .65762 L
.21812 .6402 L
.20773 .62175 L
.19796 .60405 L
.18781 .58524 L
.17727 .56522 L
.16736 .5459 L
.15706 .52525 L
.14637 .50312 L
.13632 .48156 L
.12587 .45828 L
.11605 .43547 L
.10584 .41061 L
.09524 .38332 L
.08528 .35595 L
.07492 .32528 L
.06519 .29374 L
.05508 .25699 L
.04457 .21213 L
.03894 .18339 L
.03374 .15176 L
.02864 .1111 L
.02742 .09834 L
.02612 .08218 L
.025 .06408 L
.02439 .04993 L
.02411 .04101 L
.02381 .01782 L
F
0 g
.02381 .01769 m
.02411 .01769 L
.02439 .01769 L
.0247 .01769 L
.025 .01769 L
.02528 .01769 L
.02554 .01769 L
.02582 .01769 L
.02612 .01769 L
.02642 .01769 L
.02674 .01769 L
.02704 .01769 L
.02732 .01769 L
.02764 .01769 L
.02783 .01769 L
.028 .01769 L
.02831 .01769 L
.02864 .01769 L
.02881 .01769 L
.02899 .01769 L
.02931 .01769 L
.02948 .01769 L
.02965 .01769 L
.02983 .01769 L
.03002 .01769 L
.03019 .01769 L
.03037 .01769 L
.0307 .01769 L
.03102 .01769 L
.03132 .01769 L
.03161 .01769 L
.03188 .01769 L
.03217 .01769 L
.03249 .01769 L
.03281 .01769 L
.03314 .01769 L
.03343 .01769 L
.03374 .01769 L
.03392 .01769 L
.03409 .01769 L
.03428 .01769 L
.03447 .01769 L
.0348 .01769 L
.03499 .01769 L
.03516 .01769 L
.03549 .01769 L
.03579 .01769 L
.03595 .01769 L
.03613 .01769 L
.03645 .01769 L
Mistroke
.03665 .01769 L
.03684 .01769 L
.037 .01769 L
.03718 .01769 L
.03738 .01769 L
.03759 .01769 L
.03776 .01769 L
.03796 .01769 L
.03814 .01769 L
.03831 .01769 L
.0385 .01769 L
.03868 .01769 L
.039 .01769 L
.03918 .01769 L
.03935 .01769 L
.03965 .01769 L
.03997 .01769 L
.04028 .01769 L
.04056 .01769 L
.04087 .01769 L
.0412 .01769 L
.04138 .01769 L
.04156 .01769 L
.04189 .01769 L
.04207 .01769 L
.04223 .01769 L
.04242 .01769 L
.04261 .01769 L
.04294 .01769 L
.04312 .01769 L
.04329 .01769 L
.04362 .01769 L
.04391 .01769 L
.04425 .01769 L
.04457 .01769 L
.04486 .01769 L
.04518 .01769 L
.04548 .01769 L
.04575 .01769 L
.04605 .01769 L
.04638 .01769 L
.04655 .01769 L
.04673 .01769 L
.04705 .01769 L
.04723 .01769 L
.04739 .01769 L
.04757 .01769 L
.04776 .01769 L
.04808 .01769 L
.04826 .01769 L
Mistroke
.04843 .01769 L
.04875 .01769 L
.04903 .01769 L
.04937 .01769 L
.04968 .01769 L
.04998 .01769 L
.05025 .01769 L
.05056 .01769 L
.05086 .01769 L
.05113 .01769 L
.05138 .01769 L
.05166 .01769 L
.05195 .01769 L
.05224 .01769 L
.05256 .01769 L
.05285 .01769 L
.05313 .01769 L
.05344 .01769 L
.05362 .01769 L
.05379 .01769 L
.05409 .01769 L
.05442 .01769 L
.05471 .01769 L
.05503 .01769 L
.05537 .01769 L
.05568 .01769 L
.05597 .01769 L
.05623 .01769 L
.05654 .01769 L
.05683 .01769 L
.05714 .01769 L
.05748 .01769 L
.05776 .01769 L
.05808 .01769 L
.05841 .01769 L
.0586 .01769 L
.05877 .01769 L
.05911 .01769 L
.05943 .01769 L
.05972 .01769 L
.05999 .01769 L
.0603 .01769 L
.06059 .01769 L
.06087 .01769 L
.06111 .01769 L
.06139 .01769 L
.06168 .01769 L
.06197 .01769 L
.06228 .01769 L
.06258 .01769 L
Mistroke
.06285 .01769 L
.06316 .01769 L
.06334 .01769 L
.0635 .01769 L
.06381 .01769 L
.06413 .01769 L
.06444 .01769 L
.06477 .01769 L
.06509 .01769 L
.06539 .01769 L
.06568 .01769 L
.06595 .01769 L
.06626 .01769 L
.06654 .01769 L
.06686 .01769 L
.0672 .01769 L
.06748 .01769 L
.06779 .01769 L
.06813 .01769 L
.06832 .01769 L
.06849 .01769 L
.06883 .01769 L
.06915 .01769 L
.06942 .01769 L
.06971 .01769 L
.07002 .01769 L
.07032 .01769 L
.07059 .01769 L
.07084 .01769 L
.07111 .01769 L
.0714 .01769 L
.07169 .01769 L
.07201 .01769 L
.0723 .01769 L
.07257 .01769 L
.07289 .01769 L
.07306 .01769 L
.07323 .01769 L
.07353 .01769 L
.07385 .01769 L
.07416 .01769 L
.0745 .01769 L
.07482 .01769 L
.07512 .01769 L
.07541 .01769 L
.07568 .01769 L
.07598 .01769 L
.07627 .01769 L
.07659 .01769 L
.07693 .01769 L
Mistroke
.07721 .01769 L
.07753 .01769 L
.07786 .01769 L
.07805 .01769 L
.07823 .01769 L
.07856 .01769 L
.07888 .01769 L
.07915 .01769 L
.07945 .01769 L
.07976 .01769 L
.08005 .01769 L
.08032 .01769 L
.08057 .01769 L
.08085 .01769 L
.08114 .01769 L
.08143 .01769 L
.08174 .01769 L
.08204 .01769 L
.08231 .01769 L
.08262 .01769 L
.0828 .01769 L
.08297 .01769 L
.08327 .01769 L
.08359 .01769 L
.0839 .01769 L
.08424 .01769 L
.08456 .01769 L
.08486 .01769 L
.08512 .01769 L
.08542 .01769 L
.08573 .01769 L
.08602 .01769 L
.08634 .01769 L
.08667 .01769 L
.08696 .01769 L
.08727 .01769 L
.08761 .01769 L
.0878 .01769 L
.08797 .01769 L
.08831 .01769 L
.08863 .01769 L
.0889 .01769 L
.0892 .01769 L
.08951 .01769 L
.0898 .01769 L
.09007 .01769 L
.09032 .01769 L
.09061 .01769 L
.09088 .01769 L
.09118 .01769 L
Mistroke
.09149 .01769 L
.09179 .01769 L
.09206 .01769 L
.09237 .01769 L
.09255 .01769 L
.09272 .01769 L
.09302 .01769 L
.09334 .01769 L
.09365 .01769 L
.09383 .01769 L
.09399 .01769 L
.09429 .01769 L
.09461 .01769 L
.0949 .01769 L
.09516 .01769 L
.09546 .01769 L
.09577 .01769 L
.09609 .01769 L
.09627 .01769 L
.09644 .01769 L
.09678 .01769 L
.09696 .01769 L
.09714 .01769 L
.09745 .01769 L
.09778 .01769 L
.0981 .01769 L
.09839 .01769 L
.09866 .01769 L
.09895 .01769 L
.09922 .01769 L
.09948 .01769 L
.09977 .01769 L
.10009 .01769 L
.10039 .01769 L
.10068 .01769 L
.10099 .01769 L
.10129 .01769 L
.10156 .01769 L
.10185 .01769 L
.10217 .01769 L
.1025 .01769 L
.10279 .01769 L
.1031 .01769 L
.10344 .01769 L
.10375 .01769 L
.10391 .01769 L
.10409 .01769 L
.10428 .01769 L
.10445 .01769 L
.10477 .01769 L
Mistroke
.10507 .01769 L
.10541 .01769 L
.10573 .01769 L
.10602 .01769 L
.10632 .01769 L
.10661 .01769 L
.10688 .01769 L
.10718 .01769 L
.10752 .01769 L
.10784 .01769 L
.10813 .01769 L
.10844 .01769 L
.10877 .01769 L
.10909 .01769 L
.10937 .01769 L
.10971 .01769 L
.1099 .01769 L
.11008 .01769 L
.1104 .01769 L
.11056 .01769 L
.11074 .01769 L
.11092 .01769 L
.1111 .01769 L
.11143 .01769 L
.11161 .01769 L
.11178 .01769 L
.11197 .01769 L
.11217 .01769 L
.11234 .01769 L
.11253 .01769 L
.11271 .01769 L
.11287 .01769 L
.11318 .01769 L
.11351 .01769 L
.11382 .01769 L
.11416 .01769 L
.11448 .01769 L
.11477 .01769 L
.11507 .01769 L
.11533 .01769 L
.11564 .01769 L
.11593 .01769 L
.11625 .01769 L
.11658 .01769 L
.11687 .01769 L
.11718 .01769 L
.11752 .01769 L
.11771 .01769 L
.11788 .01769 L
.11822 .01769 L
Mistroke
.11853 .01769 L
.1188 .01769 L
.1191 .01769 L
.11941 .01769 L
.11971 .01769 L
.11998 .01769 L
.12023 .01769 L
.1205 .01769 L
.12079 .01769 L
.12108 .01769 L
.1214 .01769 L
.12169 .01769 L
.12196 .01769 L
.12228 .01769 L
.12245 .01769 L
.12262 .01769 L
.12292 .01769 L
.12324 .01769 L
.12355 .01769 L
.12389 .01769 L
.12421 .01769 L
.12451 .01769 L
.1248 .01769 L
.12507 .01769 L
.12538 .01769 L
.12567 .01769 L
.12599 .01769 L
.12632 .01769 L
.12661 .01769 L
.12692 .01769 L
.12726 .01769 L
.12745 .01769 L
.12762 .01769 L
.12796 .01769 L
.12828 .01769 L
.12855 .01769 L
.12885 .01769 L
.12916 .01769 L
.12945 .01769 L
.12972 .01769 L
.12997 .01769 L
.13026 .01769 L
.13054 .01769 L
.13083 .01769 L
.13114 .01769 L
.13144 .01769 L
.13171 .01769 L
.13202 .01769 L
.1322 .01769 L
.13237 .01769 L
Mistroke
.13267 .01769 L
.13299 .01769 L
.1333 .01769 L
.13348 .01769 L
.13364 .01769 L
.13394 .01769 L
.13426 .01769 L
.13455 .01769 L
.13481 .01769 L
.13511 .01769 L
.13542 .01769 L
.13574 .01769 L
.13592 .01769 L
.13609 .01769 L
.13642 .01769 L
.13661 .01769 L
.13678 .01769 L
.13709 .01769 L
.13743 .01769 L
.13774 .01769 L
.13803 .01769 L
.13831 .01769 L
.1386 .01769 L
.13887 .01769 L
.13912 .01769 L
.13942 .01769 L
.13974 .01769 L
.14004 .01769 L
.14032 .01769 L
.14064 .01769 L
.14094 .01769 L
.14121 .01769 L
.1415 .01769 L
.14181 .01769 L
.14215 .01769 L
.14243 .01769 L
.14275 .01769 L
.14308 .01769 L
.14339 .01769 L
.14356 .01769 L
.14374 .01769 L
.14392 .01769 L
.1441 .01769 L
.14442 .01769 L
.14471 .01769 L
.14504 .01769 L
.14538 .01769 L
.14566 .01769 L
.14597 .01769 L
.14626 .01769 L
Mistroke
.14652 .01769 L
.14683 .01769 L
.14716 .01769 L
.14748 .01769 L
.14777 .01769 L
.14808 .01769 L
.14841 .01769 L
.14873 .01769 L
.14902 .01769 L
.14935 .01769 L
.14954 .01769 L
.14972 .01769 L
.15004 .01769 L
.15021 .01769 L
.15039 .01769 L
.15056 .01769 L
.15074 .01769 L
.15107 .01769 L
.15125 .01769 L
.15142 .01769 L
.15161 .01769 L
.15181 .01769 L
.15198 .01769 L
.15217 .01769 L
.15235 .01769 L
.15251 .01769 L
.15282 .01769 L
.15315 .01769 L
.15346 .01769 L
.1538 .01769 L
.15412 .01769 L
.15441 .01769 L
.15471 .01769 L
.15497 .01769 L
.15528 .01769 L
.15557 .01769 L
.15589 .01769 L
.15622 .01769 L
.15651 .01769 L
.15682 .01769 L
.15716 .01769 L
.15735 .01769 L
.15752 .01769 L
.15786 .01769 L
.15818 .01769 L
.15845 .01769 L
.15874 .01769 L
.15905 .01769 L
.15935 .01769 L
.15962 .01769 L
Mistroke
.15987 .01769 L
.16014 .01769 L
.16043 .01769 L
.16072 .01769 L
.16104 .01769 L
.16133 .01769 L
.1616 .01769 L
.16192 .01769 L
.16209 .01769 L
.16226 .01769 L
.16256 .01769 L
.16288 .01769 L
.16319 .01769 L
.16353 .01769 L
.16385 .01769 L
.16415 .01769 L
.16444 .01769 L
.16471 .01769 L
.16502 .01769 L
.16531 .01769 L
.16563 .01769 L
.16596 .01769 L
.16625 .01769 L
.16656 .01769 L
.1669 .01769 L
.16709 .01769 L
.16726 .01769 L
.1676 .01769 L
.16792 .01769 L
.16819 .01769 L
.16848 .01769 L
.1688 .01769 L
.16909 .01769 L
.16936 .01769 L
.16961 .01769 L
.1699 .01769 L
.17017 .01769 L
.17047 .01769 L
.17078 .01769 L
.17108 .01769 L
.17134 .01769 L
.17166 .01769 L
.17184 .01769 L
.172 .01769 L
.1723 .01769 L
.17262 .01769 L
.17294 .01769 L
.17311 .01769 L
.17328 .01769 L
.17358 .01769 L
Mistroke
.1739 .01769 L
.17418 .01769 L
.17445 .01769 L
.17474 .01769 L
.17506 .01769 L
.17537 .01769 L
.17555 .01769 L
.17572 .01769 L
.17606 .01769 L
.17625 .01769 L
.17642 .01769 L
.17673 .01769 L
.17706 .01769 L
.17738 .01769 L
.17767 .01769 L
.17794 .01769 L
.17823 .01769 L
.17851 .01769 L
.17876 .01769 L
.17905 .01769 L
.17937 .01769 L
.17968 .01769 L
.17996 .01769 L
.18027 .01769 L
.18057 .01769 L
.18084 .01769 L
.18113 .01769 L
.18145 .01769 L
.18178 .01769 L
.18207 .01769 L
.18238 .01769 L
.18272 .01769 L
.18303 .01769 L
.18319 .01769 L
.18337 .01769 L
.18356 .01769 L
.18373 .01769 L
.18405 .01769 L
.18435 .01769 L
.18467 .01769 L
.18501 .01769 L
.1853 .01769 L
.1856 .01769 L
.18589 .01769 L
.18615 .01769 L
.18646 .01769 L
.1868 .01769 L
.18711 .01769 L
.1874 .01769 L
.18771 .01769 L
Mistroke
.18805 .01769 L
.18836 .01769 L
.18865 .01769 L
.18898 .01769 L
.18917 .01769 L
.18935 .01769 L
.18967 .01769 L
.18984 .01769 L
.19002 .01769 L
.19019 .01769 L
.19037 .01769 L
.1907 .01769 L
.19088 .01769 L
.19106 .01769 L
.19124 .01769 L
.19144 .01769 L
.19161 .01769 L
.1918 .01769 L
.19198 .01769 L
.19214 .01769 L
.19245 .01769 L
.19278 .01769 L
.19309 .01769 L
.19343 .01769 L
.19375 .01769 L
.19405 .01769 L
.19434 .01769 L
.1946 .01769 L
.19491 .01769 L
.1952 .01769 L
.19552 .01769 L
.19585 .01769 L
.19614 .01769 L
.19645 .01769 L
.19679 .01769 L
.19698 .01769 L
.19715 .01769 L
.19749 .01769 L
.1978 .01769 L
.19807 .01769 L
.19837 .01769 L
.19868 .01769 L
.19897 .01769 L
.19925 .01769 L
.1995 .01769 L
.19977 .01769 L
.20006 .01769 L
.20035 .01769 L
.20066 .01769 L
.20096 .01769 L
Mistroke
.20123 .01769 L
.20154 .01769 L
.20172 .01769 L
.20189 .01769 L
.20219 .01769 L
.20251 .01769 L
.20282 .01769 L
.20316 .01769 L
.20348 .01769 L
.20378 .01769 L
.20407 .01769 L
.20434 .01769 L
.20464 .01769 L
.20493 .01769 L
.20525 .01769 L
.20559 .01769 L
.20587 .01769 L
.20619 .01769 L
.20653 .01769 L
.20672 .01769 L
.20689 .01769 L
.20722 .01769 L
.20754 .01769 L
.20781 .01769 L
.20811 .01769 L
.20842 .01769 L
.20871 .01769 L
.20899 .01769 L
.20924 .01769 L
.20951 .01769 L
.2098 .01769 L
.21009 .01769 L
.2104 .01769 L
.2107 .01769 L
.21097 .01769 L
.21129 .01769 L
.21146 .01769 L
.21163 .01769 L
.21193 .01769 L
.21225 .01769 L
.21256 .01769 L
.21274 .01769 L
.2129 .01769 L
.2132 .01769 L
.21352 .01769 L
.2138 .01769 L
.21407 .01769 L
.21437 .01769 L
.21468 .01769 L
.215 .01769 L
Mistroke
.21518 .01769 L
.21534 .01769 L
.21568 .01769 L
.21587 .01769 L
.21604 .01769 L
.21635 .01769 L
.21668 .01769 L
.217 .01769 L
.21729 .01769 L
.21756 .01769 L
.21785 .01769 L
.21813 .01769 L
.21838 .01769 L
.21867 .01769 L
.21899 .01769 L
.2193 .01769 L
.21958 .01769 L
.2199 .01769 L
.22019 .01769 L
.22046 .01769 L
.22075 .01769 L
.22107 .01769 L
.2214 .01769 L
.22169 .01769 L
.222 .01769 L
.22234 .01769 L
.22265 .01769 L
.22281 .01769 L
.22299 .01769 L
.22318 .01769 L
.22335 .01769 L
.22367 .01769 L
.22397 .01769 L
.22429 .01769 L
.22463 .01769 L
.22492 .01769 L
.22522 .01769 L
.22551 .01769 L
.22577 .01769 L
.22608 .01769 L
.22642 .01769 L
.22673 .01769 L
.22702 .01769 L
.22733 .01769 L
.22767 .01769 L
.22798 .01769 L
.22827 .01769 L
.2286 .01769 L
.22879 .01769 L
.22897 .01769 L
Mistroke
.22929 .01769 L
.22947 .01769 L
.22963 .01769 L
.22981 .01769 L
.22999 .01769 L
.23032 .01769 L
.2305 .01769 L
.23067 .01769 L
.23086 .01769 L
.23106 .01769 L
.23123 .01769 L
.23142 .01769 L
.2316 .01769 L
.23176 .01769 L
.23207 .01769 L
.2324 .01769 L
.23271 .01769 L
.23305 .01769 L
.23337 .01769 L
.23366 .01769 L
.23396 .01769 L
.23422 .01769 L
.23453 .01769 L
.23482 .01769 L
.23513 .01769 L
.23547 .01769 L
.23575 .01769 L
.23607 .01769 L
.23641 .01769 L
.23659 .01769 L
.23677 .01769 L
.2371 .01769 L
.23742 .01769 L
.23769 .01769 L
.23799 .01769 L
.2383 .01769 L
.23859 .01769 L
.23886 .01769 L
.23911 .01769 L
.23938 .01769 L
.23967 .01769 L
.23997 .01769 L
.24028 .01769 L
.24057 .01769 L
.24084 .01769 L
.24116 .01769 L
.24134 .01769 L
.2415 .01769 L
.2418 .01769 L
.24212 .01769 L
Mistroke
.24243 .01769 L
.24277 .01769 L
.24309 .01769 L
.24339 .01769 L
.24368 .01769 L
.24395 .01769 L
.24426 .01769 L
.24455 .01769 L
.24487 .01769 L
.2452 .01769 L
.24549 .01769 L
.2458 .01769 L
.24614 .01769 L
.24633 .01769 L
.2465 .01769 L
.24684 .01769 L
.24715 .01769 L
.24742 .01769 L
.24772 .01769 L
.24803 .01769 L
.24833 .01769 L
.2486 .01769 L
.24885 .01769 L
.24912 .01769 L
.24941 .01769 L
.2497 .01769 L
.25002 .01769 L
.25031 .01769 L
.25058 .01769 L
.2509 .01769 L
.25108 .01769 L
.25124 .01769 L
.25154 .01769 L
.25186 .01769 L
.25217 .01769 L
.25235 .01769 L
.25251 .01769 L
.25281 .01769 L
.25313 .01769 L
.25342 .01769 L
.25368 .01769 L
.25398 .01769 L
.25429 .01769 L
.25461 .01769 L
.25479 .01769 L
.25495 .01769 L
.25529 .01769 L
.25548 .01769 L
.25565 .01769 L
.25596 .01769 L
Mistroke
.25629 .01769 L
.25661 .01769 L
.2569 .01769 L
.25717 .01769 L
.25746 .01769 L
.25774 .01769 L
.25799 .01769 L
.25828 .01769 L
.2586 .01769 L
.25891 .01769 L
.25919 .01769 L
.2595 .01769 L
.2598 .01769 L
.26007 .01769 L
.26036 .01769 L
.26068 .01769 L
.26101 .01769 L
.2613 .01769 L
.26161 .01769 L
.26184 .01769 L
.26205 .01769 L
.26228 .01769 L
.26252 .01769 L
.26273 .01769 L
.26293 .01769 L
.26315 .01769 L
.26338 .01769 L
.26358 .01769 L
.2638 .01769 L
.26402 .01769 L
.26423 .01769 L
.26442 .01769 L
.2646 .01769 L
.26481 .01769 L
.265 .01769 L
.26521 .01769 L
.26544 .01769 L
.26568 .01769 L
.26591 .01769 L
.26612 .01769 L
.26631 .01769 L
.26653 .01769 L
.26674 .01769 L
.26697 .01769 L
.26721 .01769 L
.26744 .01769 L
.26765 .01769 L
.26789 .01769 L
.26816 .01769 L
.26841 .01769 L
Mistroke
.26863 .01769 L
Mfstroke
.02381 .01782 m
.02411 .04101 L
.02439 .04993 L
.025 .06408 L
.02612 .08218 L
.02742 .09834 L
.02864 .1111 L
.03374 .15176 L
.03894 .18339 L
.04457 .21213 L
.05508 .25699 L
.06519 .29374 L
.07492 .32528 L
.08528 .35595 L
.09524 .38332 L
.10584 .41061 L
.11605 .43547 L
.12587 .45828 L
.13632 .48156 L
.14637 .50312 L
.15706 .52525 L
.16736 .5459 L
.17727 .56522 L
.18781 .58524 L
.19796 .60405 L
.20773 .62175 L
.21812 .6402 L
.22812 .65762 L
.23875 .6758 L
.249 .69301 L
.25885 .7093 L
.26863 .72525 L
s
.26863 .01769 m
.26944 .01769 L
.27018 .01769 L
.27103 .01769 L
.27183 .01769 L
.27257 .01769 L
.27326 .01769 L
.27401 .01769 L
.27481 .01769 L
.27561 .01769 L
.27647 .01769 L
.27728 .01769 L
.27803 .01769 L
.2789 .01769 L
.27939 .01769 L
.27985 .01769 L
.28068 .01769 L
.28157 .01769 L
.28202 .01769 L
.28249 .01769 L
.28334 .01769 L
.28381 .01769 L
.28426 .01769 L
.28474 .01769 L
.28526 .01769 L
.2857 .01769 L
.28619 .01769 L
.28707 .01769 L
.28793 .01769 L
.28873 .01769 L
.2895 .01769 L
.29022 .01769 L
.29102 .01769 L
.29187 .01769 L
.29272 .01769 L
.29362 .01769 L
.29438 .01769 L
.29521 .01769 L
.2957 .01769 L
.29615 .01769 L
.29665 .01769 L
.29717 .01769 L
.29805 .01769 L
.29855 .01769 L
.29902 .01769 L
.29989 .01769 L
.30068 .01769 L
.30112 .01769 L
.3016 .01769 L
.30247 .01769 L
Mistroke
.303 .01769 L
.3035 .01769 L
.30394 .01769 L
.30442 .01769 L
.30495 .01769 L
.3055 .01769 L
.30598 .01769 L
.3065 .01769 L
.30699 .01769 L
.30743 .01769 L
.30794 .01769 L
.30843 .01769 L
.30929 .01769 L
.30978 .01769 L
.31023 .01769 L
.31103 .01769 L
.31189 .01769 L
.31271 .01769 L
.31345 .01769 L
.31428 .01769 L
.31519 .01769 L
.31564 .01769 L
.31613 .01769 L
.31701 .01769 L
.31749 .01769 L
.31794 .01769 L
.31843 .01769 L
.31895 .01769 L
.31982 .01769 L
.32032 .01769 L
.32078 .01769 L
.32164 .01769 L
.32243 .01769 L
.32334 .01769 L
.3242 .01769 L
.32498 .01769 L
.32583 .01769 L
.32662 .01769 L
.32735 .01769 L
.32816 .01769 L
.32905 .01769 L
.32949 .01769 L
.32997 .01769 L
.33083 .01769 L
.3313 .01769 L
.33174 .01769 L
.33222 .01769 L
.33273 .01769 L
.33358 .01769 L
.33407 .01769 L
Mistroke
.33452 .01769 L
.33537 .01769 L
.33614 .01769 L
.33703 .01769 L
.33788 .01769 L
.33868 .01769 L
.3394 .01769 L
.34024 .01769 L
.34102 .01769 L
.34175 .01769 L
.34242 .01769 L
.34316 .01769 L
.34394 .01769 L
.34473 .01769 L
.34557 .01769 L
.34637 .01769 L
.34709 .01769 L
.34794 .01769 L
.34842 .01769 L
.34887 .01769 L
.34968 .01769 L
.35055 .01769 L
.35133 .01769 L
.35219 .01769 L
.35308 .01769 L
.35392 .01769 L
.3547 .01769 L
.35541 .01769 L
.35623 .01769 L
.357 .01769 L
.35784 .01769 L
.35874 .01769 L
.3595 .01769 L
.36034 .01769 L
.36124 .01769 L
.36174 .01769 L
.36221 .01769 L
.3631 .01769 L
.36395 .01769 L
.36475 .01769 L
.36547 .01769 L
.3663 .01769 L
.36708 .01769 L
.3678 .01769 L
.36847 .01769 L
.3692 .01769 L
.36997 .01769 L
.37076 .01769 L
.37159 .01769 L
.37238 .01769 L
Mistroke
.3731 .01769 L
.37395 .01769 L
.37443 .01769 L
.37487 .01769 L
.37567 .01769 L
.37653 .01769 L
.37736 .01769 L
.37826 .01769 L
.37912 .01769 L
.37991 .01769 L
.3807 .01769 L
.38141 .01769 L
.38223 .01769 L
.383 .01769 L
.38385 .01769 L
.38474 .01769 L
.38551 .01769 L
.38635 .01769 L
.38725 .01769 L
.38776 .01769 L
.38822 .01769 L
.38912 .01769 L
.38997 .01769 L
.39069 .01769 L
.39148 .01769 L
.39232 .01769 L
.3931 .01769 L
.39382 .01769 L
.39449 .01769 L
.39522 .01769 L
.39599 .01769 L
.39678 .01769 L
.39762 .01769 L
.39841 .01769 L
.39913 .01769 L
.39997 .01769 L
.40045 .01769 L
.40089 .01769 L
.4017 .01769 L
.40255 .01769 L
.40338 .01769 L
.40429 .01769 L
.40515 .01769 L
.40594 .01769 L
.40673 .01769 L
.40744 .01769 L
.40827 .01769 L
.40904 .01769 L
.40989 .01769 L
.41079 .01769 L
Mistroke
.41155 .01769 L
.41239 .01769 L
.4133 .01769 L
.4138 .01769 L
.41427 .01769 L
.41516 .01769 L
.41601 .01769 L
.41674 .01769 L
.41754 .01769 L
.41837 .01769 L
.41915 .01769 L
.41988 .01769 L
.42055 .01769 L
.42128 .01769 L
.42205 .01769 L
.42284 .01769 L
.42367 .01769 L
.42447 .01769 L
.42518 .01769 L
.42603 .01769 L
.42651 .01769 L
.42695 .01769 L
.42776 .01769 L
.42861 .01769 L
.42945 .01769 L
.43036 .01769 L
.43121 .01769 L
.43201 .01769 L
.43273 .01769 L
.43352 .01769 L
.43434 .01769 L
.43512 .01769 L
.43597 .01769 L
.43687 .01769 L
.43763 .01769 L
.43847 .01769 L
.43938 .01769 L
.43989 .01769 L
.44035 .01769 L
.44125 .01769 L
.4421 .01769 L
.44282 .01769 L
.44362 .01769 L
.44446 .01769 L
.44524 .01769 L
.44597 .01769 L
.44664 .01769 L
.44741 .01769 L
.44814 .01769 L
.44893 .01769 L
Mistroke
.44977 .01769 L
.45056 .01769 L
.45128 .01769 L
.45213 .01769 L
.4526 .01769 L
.45304 .01769 L
.45385 .01769 L
.4547 .01769 L
.45554 .01769 L
.45602 .01769 L
.45645 .01769 L
.45726 .01769 L
.45811 .01769 L
.45888 .01769 L
.45959 .01769 L
.46038 .01769 L
.46123 .01769 L
.46207 .01769 L
.46255 .01769 L
.463 .01769 L
.46391 .01769 L
.46441 .01769 L
.46487 .01769 L
.4657 .01769 L
.46659 .01769 L
.46744 .01769 L
.46822 .01769 L
.46894 .01769 L
.46972 .01769 L
.47046 .01769 L
.47113 .01769 L
.47192 .01769 L
.47278 .01769 L
.47359 .01769 L
.47434 .01769 L
.47519 .01769 L
.47599 .01769 L
.47671 .01769 L
.47749 .01769 L
.47833 .01769 L
.47923 .01769 L
.47999 .01769 L
.48083 .01769 L
.48173 .01769 L
.48257 .01769 L
.483 .01769 L
.48348 .01769 L
.48398 .01769 L
.48445 .01769 L
.48531 .01769 L
Mistroke
.4861 .01769 L
.48701 .01769 L
.48787 .01769 L
.48864 .01769 L
.48946 .01769 L
.49023 .01769 L
.49094 .01769 L
.49176 .01769 L
.49266 .01769 L
.4935 .01769 L
.49428 .01769 L
.49511 .01769 L
.49601 .01769 L
.49685 .01769 L
.49762 .01769 L
.49852 .01769 L
.49903 .01769 L
.4995 .01769 L
.50036 .01769 L
.5008 .01769 L
.50128 .01769 L
.50175 .01769 L
.50224 .01769 L
.50312 .01769 L
.50361 .01769 L
.50406 .01769 L
.50456 .01769 L
.5051 .01769 L
.50556 .01769 L
.50606 .01769 L
.50654 .01769 L
.50698 .01769 L
.5078 .01769 L
.50868 .01769 L
.50951 .01769 L
.51042 .01769 L
.51127 .01769 L
.51207 .01769 L
.51286 .01769 L
.51357 .01769 L
.51439 .01769 L
.51517 .01769 L
.51601 .01769 L
.51691 .01769 L
.51768 .01769 L
.51851 .01769 L
.51942 .01769 L
.51993 .01769 L
.52039 .01769 L
.52129 .01769 L
Mistroke
.52214 .01769 L
.52286 .01769 L
.52366 .01769 L
.52449 .01769 L
.52527 .01769 L
.526 .01769 L
.52667 .01769 L
.5274 .01769 L
.52817 .01769 L
.52896 .01769 L
.52979 .01769 L
.53059 .01769 L
.5313 .01769 L
.53215 .01769 L
.53263 .01769 L
.53307 .01769 L
.53388 .01769 L
.53473 .01769 L
.53556 .01769 L
.53647 .01769 L
.53733 .01769 L
.53813 .01769 L
.53892 .01769 L
.53963 .01769 L
.54046 .01769 L
.54123 .01769 L
.54208 .01769 L
.54298 .01769 L
.54375 .01769 L
.54459 .01769 L
.54549 .01769 L
.546 .01769 L
.54646 .01769 L
.54736 .01769 L
.54821 .01769 L
.54894 .01769 L
.54974 .01769 L
.55057 .01769 L
.55135 .01769 L
.55208 .01769 L
.55275 .01769 L
.55352 .01769 L
.55425 .01769 L
.55504 .01769 L
.55588 .01769 L
.55667 .01769 L
.55739 .01769 L
.55824 .01769 L
.55871 .01769 L
.55915 .01769 L
Mistroke
.55996 .01769 L
.56081 .01769 L
.56165 .01769 L
.56213 .01769 L
.56256 .01769 L
.56337 .01769 L
.56422 .01769 L
.56499 .01769 L
.5657 .01769 L
.56649 .01769 L
.56733 .01769 L
.56818 .01769 L
.56866 .01769 L
.56911 .01769 L
.57001 .01769 L
.57052 .01769 L
.57098 .01769 L
.5718 .01769 L
.5727 .01769 L
.57354 .01769 L
.57432 .01769 L
.57505 .01769 L
.57583 .01769 L
.57657 .01769 L
.57724 .01769 L
.57803 .01769 L
.57888 .01769 L
.5797 .01769 L
.58045 .01769 L
.5813 .01769 L
.5821 .01769 L
.58281 .01769 L
.58359 .01769 L
.58444 .01769 L
.58533 .01769 L
.5861 .01769 L
.58693 .01769 L
.58783 .01769 L
.58867 .01769 L
.5891 .01769 L
.58958 .01769 L
.59008 .01769 L
.59055 .01769 L
.59141 .01769 L
.5922 .01769 L
.59306 .01769 L
.59397 .01769 L
.59474 .01769 L
.59556 .01769 L
.59633 .01769 L
Mistroke
.59703 .01769 L
.59786 .01769 L
.59876 .01769 L
.5996 .01769 L
.60038 .01769 L
.60121 .01769 L
.6021 .01769 L
.60295 .01769 L
.60371 .01769 L
.60461 .01769 L
.60512 .01769 L
.60559 .01769 L
.60646 .01769 L
.60689 .01769 L
.60738 .01769 L
.60784 .01769 L
.60833 .01769 L
.60921 .01769 L
.6097 .01769 L
.61016 .01769 L
.61066 .01769 L
.61119 .01769 L
.61166 .01769 L
.61216 .01769 L
.61263 .01769 L
.61307 .01769 L
.6139 .01769 L
.61478 .01769 L
.61561 .01769 L
.61651 .01769 L
.61737 .01769 L
.61816 .01769 L
.61895 .01769 L
.61966 .01769 L
.62048 .01769 L
.62126 .01769 L
.6221 .01769 L
.623 .01769 L
.62376 .01769 L
.6246 .01769 L
.62551 .01769 L
.62601 .01769 L
.62648 .01769 L
.62737 .01769 L
.62822 .01769 L
.62895 .01769 L
.62974 .01769 L
.63058 .01769 L
.63136 .01769 L
.63209 .01769 L
Mistroke
.63275 .01769 L
.63349 .01769 L
.63426 .01769 L
.63504 .01769 L
.63588 .01769 L
.63667 .01769 L
.63739 .01769 L
.63824 .01769 L
.63871 .01769 L
.63915 .01769 L
.63996 .01769 L
.64082 .01769 L
.64165 .01769 L
.64256 .01769 L
.64342 .01769 L
.64421 .01769 L
.645 .01769 L
.64571 .01769 L
.64654 .01769 L
.64731 .01769 L
.64816 .01769 L
.64906 .01769 L
.64983 .01769 L
.65067 .01769 L
.65157 .01769 L
.65208 .01769 L
.65254 .01769 L
.65344 .01769 L
.65429 .01769 L
.65502 .01769 L
.65581 .01769 L
.65665 .01769 L
.65743 .01769 L
.65816 .01769 L
.65883 .01769 L
.6596 .01769 L
.66033 .01769 L
.66112 .01769 L
.66196 .01769 L
.66275 .01769 L
.66347 .01769 L
.66431 .01769 L
.66479 .01769 L
.66523 .01769 L
.66604 .01769 L
.66689 .01769 L
.66773 .01769 L
.6682 .01769 L
.66864 .01769 L
.66944 .01769 L
Mistroke
.6703 .01769 L
.67106 .01769 L
.67178 .01769 L
.67256 .01769 L
.67341 .01769 L
.67425 .01769 L
.67473 .01769 L
.67518 .01769 L
.67608 .01769 L
.67659 .01769 L
.67705 .01769 L
.67788 .01769 L
.67877 .01769 L
.67961 .01769 L
.68039 .01769 L
.68112 .01769 L
.6819 .01769 L
.68264 .01769 L
.68331 .01769 L
.6841 .01769 L
.68495 .01769 L
.68576 .01769 L
.68652 .01769 L
.68737 .01769 L
.68816 .01769 L
.68888 .01769 L
.68966 .01769 L
.69051 .01769 L
.6914 .01769 L
.69217 .01769 L
.693 .01769 L
.6939 .01769 L
.69473 .01769 L
.69517 .01769 L
.69565 .01769 L
.69615 .01769 L
.69662 .01769 L
.69748 .01769 L
.69826 .01769 L
.69913 .01769 L
.70004 .01769 L
.7008 .01769 L
.70162 .01769 L
.7024 .01769 L
.7031 .01769 L
.70392 .01769 L
.70482 .01769 L
.70566 .01769 L
.70644 .01769 L
.70727 .01769 L
Mistroke
.70817 .01769 L
.70901 .01769 L
.70978 .01769 L
.71068 .01769 L
.71118 .01769 L
.71166 .01769 L
.71252 .01769 L
.71296 .01769 L
.71344 .01769 L
.7139 .01769 L
.71439 .01769 L
.71527 .01769 L
.71576 .01769 L
.71622 .01769 L
.71672 .01769 L
.71725 .01769 L
.71772 .01769 L
.71822 .01769 L
.71869 .01769 L
.71913 .01769 L
.71996 .01769 L
.72084 .01769 L
.72167 .01769 L
.72257 .01769 L
.72343 .01769 L
.72422 .01769 L
.725 .01769 L
.72572 .01769 L
.72654 .01769 L
.72731 .01769 L
.72816 .01769 L
.72906 .01769 L
.72982 .01769 L
.73066 .01769 L
.73156 .01769 L
.73207 .01769 L
.73253 .01769 L
.73343 .01769 L
.73428 .01769 L
.735 .01769 L
.7358 .01769 L
.73663 .01769 L
.73741 .01769 L
.73814 .01769 L
.73881 .01769 L
.73954 .01769 L
.74031 .01769 L
.74109 .01769 L
.74193 .01769 L
.74272 .01769 L
Mistroke
.74344 .01769 L
.74429 .01769 L
.74476 .01769 L
.7452 .01769 L
.74601 .01769 L
.74687 .01769 L
.7477 .01769 L
.74861 .01769 L
.74947 .01769 L
.75026 .01769 L
.75105 .01769 L
.75176 .01769 L
.75259 .01769 L
.75336 .01769 L
.75421 .01769 L
.75511 .01769 L
.75588 .01769 L
.75671 .01769 L
.75762 .01769 L
.75813 .01769 L
.75859 .01769 L
.75949 .01769 L
.76034 .01769 L
.76106 .01769 L
.76186 .01769 L
.76269 .01769 L
.76348 .01769 L
.7642 .01769 L
.76487 .01769 L
.76561 .01769 L
.76638 .01769 L
.76716 .01769 L
.768 .01769 L
.76879 .01769 L
.76951 .01769 L
.77036 .01769 L
.77083 .01769 L
.77127 .01769 L
.77208 .01769 L
.77294 .01769 L
.77377 .01769 L
.77425 .01769 L
.77468 .01769 L
.77549 .01769 L
.77634 .01769 L
.7771 .01769 L
.77782 .01769 L
.7786 .01769 L
.77945 .01769 L
.78029 .01769 L
Mistroke
.78077 .01769 L
.78122 .01769 L
.78212 .01769 L
.78263 .01769 L
.78309 .01769 L
.78391 .01769 L
.78481 .01769 L
.78565 .01769 L
.78643 .01769 L
.78716 .01769 L
.78794 .01769 L
.78867 .01769 L
.78934 .01769 L
.79013 .01769 L
.79099 .01769 L
.7918 .01769 L
.79255 .01769 L
.7934 .01769 L
.7942 .01769 L
.79492 .01769 L
.79569 .01769 L
.79654 .01769 L
.79744 .01769 L
.7982 .01769 L
.79904 .01769 L
.79994 .01769 L
.80077 .01769 L
.8012 .01769 L
.80168 .01769 L
.80218 .01769 L
.80265 .01769 L
.80351 .01769 L
.80429 .01769 L
.80516 .01769 L
.80607 .01769 L
.80683 .01769 L
.80765 .01769 L
.80843 .01769 L
.80913 .01769 L
.80995 .01769 L
.81085 .01769 L
.81169 .01769 L
.81247 .01769 L
.8133 .01769 L
.81419 .01769 L
.81503 .01769 L
.8158 .01769 L
.8167 .01769 L
.81721 .01769 L
.81768 .01769 L
Mistroke
.81855 .01769 L
.81903 .01769 L
.81947 .01769 L
.81993 .01769 L
.82042 .01769 L
.8213 .01769 L
.82179 .01769 L
.82224 .01769 L
.82274 .01769 L
.82328 .01769 L
.82374 .01769 L
.82424 .01769 L
.82472 .01769 L
.82516 .01769 L
.82599 .01769 L
.82686 .01769 L
.82769 .01769 L
.8286 .01769 L
.82945 .01769 L
.83024 .01769 L
.83103 .01769 L
.83174 .01769 L
.83256 .01769 L
.83334 .01769 L
.83418 .01769 L
.83508 .01769 L
.83584 .01769 L
.83668 .01769 L
.83758 .01769 L
.83809 .01769 L
.83855 .01769 L
.83945 .01769 L
.8403 .01769 L
.84102 .01769 L
.84182 .01769 L
.84265 .01769 L
.84343 .01769 L
.84416 .01769 L
.84482 .01769 L
.84556 .01769 L
.84633 .01769 L
.84711 .01769 L
.84795 .01769 L
.84874 .01769 L
.84946 .01769 L
.85031 .01769 L
.85078 .01769 L
.85122 .01769 L
.85203 .01769 L
.85289 .01769 L
Mistroke
.85372 .01769 L
.85463 .01769 L
.85548 .01769 L
.85628 .01769 L
.85706 .01769 L
.85778 .01769 L
.8586 .01769 L
.85938 .01769 L
.86023 .01769 L
.86112 .01769 L
.86189 .01769 L
.86273 .01769 L
.86363 .01769 L
.86414 .01769 L
.8646 .01769 L
.8655 .01769 L
.86635 .01769 L
.86707 .01769 L
.86787 .01769 L
.8687 .01769 L
.86949 .01769 L
.87021 .01769 L
.87088 .01769 L
.87162 .01769 L
.87239 .01769 L
.87317 .01769 L
.87401 .01769 L
.8748 .01769 L
.87552 .01769 L
.87637 .01769 L
.87684 .01769 L
.87728 .01769 L
.87809 .01769 L
.87895 .01769 L
.87978 .01769 L
.88025 .01769 L
.88069 .01769 L
.88149 .01769 L
.88235 .01769 L
.88311 .01769 L
.88382 .01769 L
.88461 .01769 L
.88545 .01769 L
.8863 .01769 L
.88678 .01769 L
.88722 .01769 L
.88813 .01769 L
.88863 .01769 L
.88909 .01769 L
.88992 .01769 L
Mistroke
.89081 .01769 L
.89165 .01769 L
.89243 .01769 L
.89316 .01769 L
.89394 .01769 L
.89467 .01769 L
.89535 .01769 L
.89613 .01769 L
.89699 .01769 L
.8978 .01769 L
.89855 .01769 L
.8994 .01769 L
.9002 .01769 L
.90092 .01769 L
.90169 .01769 L
.90254 .01769 L
.90344 .01769 L
.9042 .01769 L
.90504 .01769 L
.90565 .01769 L
.90621 .01769 L
.90682 .01769 L
.90748 .01769 L
.90804 .01769 L
.90858 .01769 L
.90916 .01769 L
.90979 .01769 L
.91031 .01769 L
.91089 .01769 L
.91149 .01769 L
.91204 .01769 L
.91257 .01769 L
.91304 .01769 L
.91359 .01769 L
.91411 .01769 L
.91467 .01769 L
.91529 .01769 L
.91594 .01769 L
.91654 .01769 L
.9171 .01769 L
.91762 .01769 L
.91821 .01769 L
.91878 .01769 L
.91939 .01769 L
.92003 .01769 L
.92064 .01769 L
.9212 .01769 L
.92185 .01769 L
.92256 .01769 L
.92322 .01769 L
Mistroke
.92384 .01769 L
Mfstroke
.26863 .72525 m
.29521 .70919 L
.3242 .69249 L
.35142 .67753 L
.37761 .66375 L
.40547 .6497 L
.4323 .63675 L
.46081 .62354 L
.48828 .61135 L
.51471 .60007 L
.54283 .58853 L
.5699 .57784 L
.59593 .56794 L
.62364 .55777 L
.65032 .54833 L
.67868 .53865 L
.70599 .52966 L
.73227 .5213 L
.76023 .51269 L
.78715 .50468 L
.81576 .49645 L
.84332 .48877 L
.86984 .48162 L
.89805 .47424 L
.92384 .4677 L
s
0 1 1 r
.26863 .01769 m
.26944 .01769 L
.27018 .01769 L
.27103 .01769 L
.27183 .01769 L
.27257 .01769 L
.27326 .01769 L
.27401 .01769 L
.27481 .01769 L
.27561 .01769 L
.27647 .01769 L
.27728 .01769 L
.27803 .01769 L
.2789 .01769 L
.27939 .01769 L
.27985 .01769 L
.28068 .01769 L
.28157 .01769 L
.28202 .01769 L
.28249 .01769 L
.28334 .01769 L
.28381 .01769 L
.28426 .01769 L
.28474 .01769 L
.28526 .01769 L
.2857 .01769 L
.28619 .01769 L
.28707 .01769 L
.28793 .01769 L
.28873 .01769 L
.2895 .01769 L
.29022 .01769 L
.29102 .01769 L
.29187 .01769 L
.29272 .01769 L
.29362 .01769 L
.29438 .01769 L
.29521 .01769 L
.2957 .01769 L
.29615 .01769 L
.29665 .01769 L
.29717 .01769 L
.29805 .01769 L
.29855 .01769 L
.29902 .01769 L
.29989 .01769 L
.30068 .01769 L
.30112 .01769 L
.3016 .01769 L
.30247 .01769 L
.303 .01769 L
.3035 .01769 L
.30394 .01769 L
.30442 .01769 L
.30495 .01769 L
.3055 .01769 L
.30598 .01769 L
.3065 .01769 L
.30699 .01769 L
.30743 .01769 L
.30794 .01769 L
.30843 .01769 L
.30929 .01769 L
.30978 .01769 L
.31023 .01769 L
.31103 .01769 L
.31189 .01769 L
.31271 .01769 L
.31345 .01769 L
.31428 .01769 L
.31519 .01769 L
.31564 .01769 L
.31613 .01769 L
.31701 .01769 L
.31749 .01769 L
.31794 .01769 L
.31843 .01769 L
.31895 .01769 L
.31982 .01769 L
.32032 .01769 L
.32078 .01769 L
.32164 .01769 L
.32243 .01769 L
.32334 .01769 L
.3242 .01769 L
.32498 .01769 L
.32583 .01769 L
.32662 .01769 L
.32735 .01769 L
.32816 .01769 L
.32905 .01769 L
.32949 .01769 L
.32997 .01769 L
.33083 .01769 L
.3313 .01769 L
.33174 .01769 L
.33222 .01769 L
.33273 .01769 L
.33358 .01769 L
.33407 .01769 L
.33452 .01769 L
.33537 .01769 L
.33614 .01769 L
.33703 .01769 L
.33788 .01769 L
.33868 .01769 L
.3394 .01769 L
.34024 .01769 L
.34102 .01769 L
.34175 .01769 L
.34242 .01769 L
.34316 .01769 L
.34394 .01769 L
.34473 .01769 L
.34557 .01769 L
.34637 .01769 L
.34709 .01769 L
.34794 .01769 L
.34842 .01769 L
.34887 .01769 L
.34968 .01769 L
.35055 .01769 L
.35133 .01769 L
.35219 .01769 L
.35308 .01769 L
.35392 .01769 L
.3547 .01769 L
.35541 .01769 L
.35623 .01769 L
.357 .01769 L
.35784 .01769 L
.35874 .01769 L
.3595 .01769 L
.36034 .01769 L
.36124 .01769 L
.36174 .01769 L
.36221 .01769 L
.3631 .01769 L
.36395 .01769 L
.36475 .01769 L
.36547 .01769 L
.3663 .01769 L
.36708 .01769 L
.3678 .01769 L
.36847 .01769 L
.3692 .01769 L
.36997 .01769 L
.37076 .01769 L
.37159 .01769 L
.37238 .01769 L
.3731 .01769 L
.37395 .01769 L
.37443 .01769 L
.37487 .01769 L
.37567 .01769 L
.37653 .01769 L
.37736 .01769 L
.37826 .01769 L
.37912 .01769 L
.37991 .01769 L
.3807 .01769 L
.38141 .01769 L
.38223 .01769 L
.383 .01769 L
.38385 .01769 L
.38474 .01769 L
.38551 .01769 L
.38635 .01769 L
.38725 .01769 L
.38776 .01769 L
.38822 .01769 L
.38912 .01769 L
.38997 .01769 L
.39069 .01769 L
.39148 .01769 L
.39232 .01769 L
.3931 .01769 L
.39382 .01769 L
.39449 .01769 L
.39522 .01769 L
.39599 .01769 L
.39678 .01769 L
.39762 .01769 L
.39841 .01769 L
.39913 .01769 L
.39997 .01769 L
.40045 .01769 L
.40089 .01769 L
.4017 .01769 L
.40255 .01769 L
.40338 .01769 L
.40429 .01769 L
.40515 .01769 L
.40594 .01769 L
.40673 .01769 L
.40744 .01769 L
.40827 .01769 L
.40904 .01769 L
.40989 .01769 L
.41079 .01769 L
.41155 .01769 L
.41239 .01769 L
.4133 .01769 L
.4138 .01769 L
.41427 .01769 L
.41516 .01769 L
.41601 .01769 L
.41674 .01769 L
.41754 .01769 L
.41837 .01769 L
.41915 .01769 L
.41988 .01769 L
.42055 .01769 L
.42128 .01769 L
.42205 .01769 L
.42284 .01769 L
.42367 .01769 L
.42447 .01769 L
.42518 .01769 L
.42603 .01769 L
.42651 .01769 L
.42695 .01769 L
.42776 .01769 L
.42861 .01769 L
.42945 .01769 L
.43036 .01769 L
.43121 .01769 L
.43201 .01769 L
.43273 .01769 L
.43352 .01769 L
.43434 .01769 L
.43512 .01769 L
.43597 .01769 L
.43687 .01769 L
.43763 .01769 L
.43847 .01769 L
.43938 .01769 L
.43989 .01769 L
.44035 .01769 L
.44125 .01769 L
.4421 .01769 L
.44282 .01769 L
.44362 .01769 L
.44446 .01769 L
.44524 .01769 L
.44597 .01769 L
.44664 .01769 L
.44741 .01769 L
.44814 .01769 L
.44893 .01769 L
.44977 .01769 L
.45056 .01769 L
.45128 .01769 L
.45213 .01769 L
.4526 .01769 L
.45304 .01769 L
.45385 .01769 L
.4547 .01769 L
.45554 .01769 L
.45602 .01769 L
.45645 .01769 L
.45726 .01769 L
.45811 .01769 L
.45888 .01769 L
.45959 .01769 L
.46038 .01769 L
.46123 .01769 L
.46207 .01769 L
.46255 .01769 L
.463 .01769 L
.46391 .01769 L
.46441 .01769 L
.46487 .01769 L
.4657 .01769 L
.46659 .01769 L
.46744 .01769 L
.46822 .01769 L
.46894 .01769 L
.46972 .01769 L
.47046 .01769 L
.47113 .01769 L
.47192 .01769 L
.47278 .01769 L
.47359 .01769 L
.47434 .01769 L
.47519 .01769 L
.47599 .01769 L
.47671 .01769 L
.47749 .01769 L
.47833 .01769 L
.47923 .01769 L
.47999 .01769 L
.48083 .01769 L
.48173 .01769 L
.48257 .01769 L
.483 .01769 L
.48348 .01769 L
.48398 .01769 L
.48445 .01769 L
.48531 .01769 L
.4861 .01769 L
.48701 .01769 L
.48787 .01769 L
.48864 .01769 L
.48946 .01769 L
.49023 .01769 L
.49094 .01769 L
.49176 .01769 L
.49266 .01769 L
.4935 .01769 L
.49428 .01769 L
.49511 .01769 L
.49601 .01769 L
.49685 .01769 L
.49762 .01769 L
.49852 .01769 L
.49903 .01769 L
.4995 .01769 L
.50036 .01769 L
.5008 .01769 L
.50128 .01769 L
.50175 .01769 L
.50224 .01769 L
.50312 .01769 L
.50361 .01769 L
.50406 .01769 L
.50456 .01769 L
.5051 .01769 L
.50556 .01769 L
.50606 .01769 L
.50654 .01769 L
.50698 .01769 L
.5078 .01769 L
.50868 .01769 L
.50951 .01769 L
.51042 .01769 L
.51127 .01769 L
.51207 .01769 L
.51286 .01769 L
.51357 .01769 L
.51439 .01769 L
.51517 .01769 L
.51601 .01769 L
.51691 .01769 L
.51768 .01769 L
.51851 .01769 L
.51942 .01769 L
.51993 .01769 L
.52039 .01769 L
.52129 .01769 L
.52214 .01769 L
.52286 .01769 L
.52366 .01769 L
.52449 .01769 L
.52527 .01769 L
.526 .01769 L
.52667 .01769 L
.5274 .01769 L
.52817 .01769 L
.52896 .01769 L
.52979 .01769 L
.53059 .01769 L
.5313 .01769 L
.53215 .01769 L
.53263 .01769 L
.53307 .01769 L
.53388 .01769 L
.53473 .01769 L
.53556 .01769 L
.53647 .01769 L
.53733 .01769 L
.53813 .01769 L
.53892 .01769 L
.53963 .01769 L
.54046 .01769 L
.54123 .01769 L
.54208 .01769 L
.54298 .01769 L
.54375 .01769 L
.54459 .01769 L
.54549 .01769 L
.546 .01769 L
.54646 .01769 L
.54736 .01769 L
.54821 .01769 L
.54894 .01769 L
.54974 .01769 L
.55057 .01769 L
.55135 .01769 L
.55208 .01769 L
.55275 .01769 L
.55352 .01769 L
.55425 .01769 L
.55504 .01769 L
.55588 .01769 L
.55667 .01769 L
.55739 .01769 L
.55824 .01769 L
.55871 .01769 L
.55915 .01769 L
.55996 .01769 L
.56081 .01769 L
.56165 .01769 L
.56213 .01769 L
.56256 .01769 L
.56337 .01769 L
.56422 .01769 L
.56499 .01769 L
.5657 .01769 L
.56649 .01769 L
.56733 .01769 L
.56818 .01769 L
.56866 .01769 L
.56911 .01769 L
.57001 .01769 L
.57052 .01769 L
.57098 .01769 L
.5718 .01769 L
.5727 .01769 L
.57354 .01769 L
.57432 .01769 L
.57505 .01769 L
.57583 .01769 L
.57657 .01769 L
.57724 .01769 L
.57803 .01769 L
.57888 .01769 L
.5797 .01769 L
.58045 .01769 L
.5813 .01769 L
.5821 .01769 L
.58281 .01769 L
.58359 .01769 L
.58444 .01769 L
.58533 .01769 L
.5861 .01769 L
.58693 .01769 L
.58783 .01769 L
.58867 .01769 L
.5891 .01769 L
.58958 .01769 L
.59008 .01769 L
.59055 .01769 L
.59141 .01769 L
.5922 .01769 L
.59306 .01769 L
.59397 .01769 L
.59474 .01769 L
.59556 .01769 L
.59633 .01769 L
.59703 .01769 L
.59786 .01769 L
.59876 .01769 L
.5996 .01769 L
.60038 .01769 L
.60121 .01769 L
.6021 .01769 L
.60295 .01769 L
.60371 .01769 L
.60461 .01769 L
.60512 .01769 L
.60559 .01769 L
.60646 .01769 L
.60689 .01769 L
.60738 .01769 L
.60784 .01769 L
.60833 .01769 L
.60921 .01769 L
.6097 .01769 L
.61016 .01769 L
.61066 .01769 L
.61119 .01769 L
.61166 .01769 L
.61216 .01769 L
.61263 .01769 L
.61307 .01769 L
.6139 .01769 L
.61478 .01769 L
.61561 .01769 L
.61651 .01769 L
.61737 .01769 L
.61816 .01769 L
.61895 .01769 L
.61966 .01769 L
.62048 .01769 L
.62126 .01769 L
.6221 .01769 L
.623 .01769 L
.62376 .01769 L
.6246 .01769 L
.62551 .01769 L
.62601 .01769 L
.62648 .01769 L
.62737 .01769 L
.62822 .01769 L
.62895 .01769 L
.62974 .01769 L
.63058 .01769 L
.63136 .01769 L
.63209 .01769 L
.63275 .01769 L
.63349 .01769 L
.63426 .01769 L
.63504 .01769 L
.63588 .01769 L
.63667 .01769 L
.63739 .01769 L
.63824 .01769 L
.63871 .01769 L
.63915 .01769 L
.63996 .01769 L
.64082 .01769 L
.64165 .01769 L
.64256 .01769 L
.64342 .01769 L
.64421 .01769 L
.645 .01769 L
.64571 .01769 L
.64654 .01769 L
.64731 .01769 L
.64816 .01769 L
.64906 .01769 L
.64983 .01769 L
.65067 .01769 L
.65157 .01769 L
.65208 .01769 L
.65254 .01769 L
.65344 .01769 L
.65429 .01769 L
.65502 .01769 L
.65581 .01769 L
.65665 .01769 L
.65743 .01769 L
.65816 .01769 L
.65883 .01769 L
.6596 .01769 L
.66033 .01769 L
.66112 .01769 L
.66196 .01769 L
.66275 .01769 L
.66347 .01769 L
.66431 .01769 L
.66479 .01769 L
.66523 .01769 L
.66604 .01769 L
.66689 .01769 L
.66773 .01769 L
.6682 .01769 L
.66864 .01769 L
.66944 .01769 L
.6703 .01769 L
.67106 .01769 L
.67178 .01769 L
.67256 .01769 L
.67341 .01769 L
.67425 .01769 L
.67473 .01769 L
.67518 .01769 L
.67608 .01769 L
.67659 .01769 L
.67705 .01769 L
.67788 .01769 L
.67877 .01769 L
.67961 .01769 L
.68039 .01769 L
.68112 .01769 L
.6819 .01769 L
.68264 .01769 L
.68331 .01769 L
.6841 .01769 L
.68495 .01769 L
.68576 .01769 L
.68652 .01769 L
.68737 .01769 L
.68816 .01769 L
.68888 .01769 L
.68966 .01769 L
.69051 .01769 L
.6914 .01769 L
.69217 .01769 L
.693 .01769 L
.6939 .01769 L
.69473 .01769 L
.69517 .01769 L
.69565 .01769 L
.69615 .01769 L
.69662 .01769 L
.69748 .01769 L
.69826 .01769 L
.69913 .01769 L
.70004 .01769 L
.7008 .01769 L
.70162 .01769 L
.7024 .01769 L
.7031 .01769 L
.70392 .01769 L
.70482 .01769 L
.70566 .01769 L
.70644 .01769 L
.70727 .01769 L
.70817 .01769 L
.70901 .01769 L
.70978 .01769 L
.71068 .01769 L
.71118 .01769 L
.71166 .01769 L
.71252 .01769 L
.71296 .01769 L
.71344 .01769 L
.7139 .01769 L
.71439 .01769 L
.71527 .01769 L
.71576 .01769 L
.71622 .01769 L
.71672 .01769 L
.71725 .01769 L
.71772 .01769 L
.71822 .01769 L
.71869 .01769 L
.71913 .01769 L
.71996 .01769 L
.72084 .01769 L
.72167 .01769 L
.72257 .01769 L
.72343 .01769 L
.72422 .01769 L
.725 .01769 L
.72572 .01769 L
.72654 .01769 L
.72731 .01769 L
.72816 .01769 L
.72906 .01769 L
.72982 .01769 L
.73066 .01769 L
.73156 .01769 L
.73207 .01769 L
.73253 .01769 L
.73343 .01769 L
.73428 .01769 L
.735 .01769 L
.7358 .01769 L
.73663 .01769 L
.73741 .01769 L
.73814 .01769 L
.73881 .01769 L
.73954 .01769 L
.74031 .01769 L
.74109 .01769 L
.74193 .01769 L
.74272 .01769 L
.74344 .01769 L
.74429 .01769 L
.74476 .01769 L
.7452 .01769 L
.74601 .01769 L
.74687 .01769 L
.7477 .01769 L
.74861 .01769 L
.74947 .01769 L
.75026 .01769 L
.75105 .01769 L
.75176 .01769 L
.75259 .01769 L
.75336 .01769 L
.75421 .01769 L
.75511 .01769 L
.75588 .01769 L
.75671 .01769 L
.75762 .01769 L
.75813 .01769 L
.75859 .01769 L
.75949 .01769 L
.76034 .01769 L
.76106 .01769 L
.76186 .01769 L
.76269 .01769 L
.76348 .01769 L
.7642 .01769 L
.76487 .01769 L
.76561 .01769 L
.76638 .01769 L
.76716 .01769 L
.768 .01769 L
.76879 .01769 L
.76951 .01769 L
.77036 .01769 L
.77083 .01769 L
.77127 .01769 L
.77208 .01769 L
.77294 .01769 L
.77377 .01769 L
.77425 .01769 L
.77468 .01769 L
.77549 .01769 L
.77634 .01769 L
.7771 .01769 L
.77782 .01769 L
.7786 .01769 L
.77945 .01769 L
.78029 .01769 L
.78077 .01769 L
.78122 .01769 L
.78212 .01769 L
.78263 .01769 L
.78309 .01769 L
.78391 .01769 L
.78481 .01769 L
.78565 .01769 L
.78643 .01769 L
.78716 .01769 L
.78794 .01769 L
.78867 .01769 L
.78934 .01769 L
.79013 .01769 L
.79099 .01769 L
.7918 .01769 L
.79255 .01769 L
.7934 .01769 L
.7942 .01769 L
.79492 .01769 L
.79569 .01769 L
.79654 .01769 L
.79744 .01769 L
.7982 .01769 L
.79904 .01769 L
.79994 .01769 L
.80077 .01769 L
.8012 .01769 L
.80168 .01769 L
.80218 .01769 L
.80265 .01769 L
.80351 .01769 L
.80429 .01769 L
.80516 .01769 L
.80607 .01769 L
.80683 .01769 L
.80765 .01769 L
.80843 .01769 L
.80913 .01769 L
.80995 .01769 L
.81085 .01769 L
.81169 .01769 L
.81247 .01769 L
.8133 .01769 L
.81419 .01769 L
.81503 .01769 L
.8158 .01769 L
.8167 .01769 L
.81721 .01769 L
.81768 .01769 L
.81855 .01769 L
.81903 .01769 L
.81947 .01769 L
.81993 .01769 L
.82042 .01769 L
.8213 .01769 L
.82179 .01769 L
.82224 .01769 L
.82274 .01769 L
.82328 .01769 L
.82374 .01769 L
.82424 .01769 L
.82472 .01769 L
.82516 .01769 L
.82599 .01769 L
.82686 .01769 L
.82769 .01769 L
.8286 .01769 L
.82945 .01769 L
.83024 .01769 L
.83103 .01769 L
.83174 .01769 L
.83256 .01769 L
.83334 .01769 L
.83418 .01769 L
.83508 .01769 L
.83584 .01769 L
.83668 .01769 L
.83758 .01769 L
.83809 .01769 L
.83855 .01769 L
.83945 .01769 L
.8403 .01769 L
.84102 .01769 L
.84182 .01769 L
.84265 .01769 L
.84343 .01769 L
.84416 .01769 L
.84482 .01769 L
.84556 .01769 L
.84633 .01769 L
.84711 .01769 L
.84795 .01769 L
.84874 .01769 L
.84946 .01769 L
.85031 .01769 L
.85078 .01769 L
.85122 .01769 L
.85203 .01769 L
.85289 .01769 L
.85372 .01769 L
.85463 .01769 L
.85548 .01769 L
.85628 .01769 L
.85706 .01769 L
.85778 .01769 L
.8586 .01769 L
.85938 .01769 L
.86023 .01769 L
.86112 .01769 L
.86189 .01769 L
.86273 .01769 L
.86363 .01769 L
.86414 .01769 L
.8646 .01769 L
.8655 .01769 L
.86635 .01769 L
.86707 .01769 L
.86787 .01769 L
.8687 .01769 L
.86949 .01769 L
.87021 .01769 L
.87088 .01769 L
.87162 .01769 L
.87239 .01769 L
.87317 .01769 L
.87401 .01769 L
.8748 .01769 L
.87552 .01769 L
.87637 .01769 L
.87684 .01769 L
.87728 .01769 L
.87809 .01769 L
.87895 .01769 L
.87978 .01769 L
.88025 .01769 L
.88069 .01769 L
.88149 .01769 L
.88235 .01769 L
.88311 .01769 L
.88382 .01769 L
.88461 .01769 L
.88545 .01769 L
.8863 .01769 L
.88678 .01769 L
.88722 .01769 L
.88813 .01769 L
.88863 .01769 L
.88909 .01769 L
.88992 .01769 L
.89081 .01769 L
.89165 .01769 L
.89243 .01769 L
.89316 .01769 L
.89394 .01769 L
.89467 .01769 L
.89535 .01769 L
.89613 .01769 L
.89699 .01769 L
.8978 .01769 L
.89855 .01769 L
.8994 .01769 L
.9002 .01769 L
.90092 .01769 L
.90169 .01769 L
.90254 .01769 L
.90344 .01769 L
.9042 .01769 L
.90504 .01769 L
.90565 .01769 L
.90621 .01769 L
.90682 .01769 L
.90748 .01769 L
.90804 .01769 L
.90858 .01769 L
.90916 .01769 L
.90979 .01769 L
.91031 .01769 L
.91089 .01769 L
.91149 .01769 L
.91204 .01769 L
.91257 .01769 L
.91304 .01769 L
.91359 .01769 L
.91411 .01769 L
.91467 .01769 L
.91529 .01769 L
.91594 .01769 L
.91654 .01769 L
.9171 .01769 L
.91762 .01769 L
.91821 .01769 L
.91878 .01769 L
.91939 .01769 L
.92003 .01769 L
.92064 .01769 L
.9212 .01769 L
.92185 .01769 L
.92256 .01769 L
.92322 .01769 L
.92384 .01769 L
.92384 .4677 L
.89805 .47424 L
.86984 .48162 L
.84332 .48877 L
.81576 .49645 L
.78715 .50468 L
.76023 .51269 L
.73227 .5213 L
.70599 .52966 L
.67868 .53865 L
.65032 .54833 L
.62364 .55777 L
.59593 .56794 L
.5699 .57784 L
.54283 .58853 L
.51471 .60007 L
.48828 .61135 L
.46081 .62354 L
.4323 .63675 L
.40547 .6497 L
.37761 .66375 L
.35142 .67753 L
.3242 .69249 L
.29521 .70919 L
.26863 .72525 L
F
0 g
.26863 .01769 m
.26944 .01769 L
.27018 .01769 L
.27103 .01769 L
.27183 .01769 L
.27257 .01769 L
.27326 .01769 L
.27401 .01769 L
.27481 .01769 L
.27561 .01769 L
.27647 .01769 L
.27728 .01769 L
.27803 .01769 L
.2789 .01769 L
.27939 .01769 L
.27985 .01769 L
.28068 .01769 L
.28157 .01769 L
.28202 .01769 L
.28249 .01769 L
.28334 .01769 L
.28381 .01769 L
.28426 .01769 L
.28474 .01769 L
.28526 .01769 L
.2857 .01769 L
.28619 .01769 L
.28707 .01769 L
.28793 .01769 L
.28873 .01769 L
.2895 .01769 L
.29022 .01769 L
.29102 .01769 L
.29187 .01769 L
.29272 .01769 L
.29362 .01769 L
.29438 .01769 L
.29521 .01769 L
.2957 .01769 L
.29615 .01769 L
.29665 .01769 L
.29717 .01769 L
.29805 .01769 L
.29855 .01769 L
.29902 .01769 L
.29989 .01769 L
.30068 .01769 L
.30112 .01769 L
.3016 .01769 L
.30247 .01769 L
Mistroke
.303 .01769 L
.3035 .01769 L
.30394 .01769 L
.30442 .01769 L
.30495 .01769 L
.3055 .01769 L
.30598 .01769 L
.3065 .01769 L
.30699 .01769 L
.30743 .01769 L
.30794 .01769 L
.30843 .01769 L
.30929 .01769 L
.30978 .01769 L
.31023 .01769 L
.31103 .01769 L
.31189 .01769 L
.31271 .01769 L
.31345 .01769 L
.31428 .01769 L
.31519 .01769 L
.31564 .01769 L
.31613 .01769 L
.31701 .01769 L
.31749 .01769 L
.31794 .01769 L
.31843 .01769 L
.31895 .01769 L
.31982 .01769 L
.32032 .01769 L
.32078 .01769 L
.32164 .01769 L
.32243 .01769 L
.32334 .01769 L
.3242 .01769 L
.32498 .01769 L
.32583 .01769 L
.32662 .01769 L
.32735 .01769 L
.32816 .01769 L
.32905 .01769 L
.32949 .01769 L
.32997 .01769 L
.33083 .01769 L
.3313 .01769 L
.33174 .01769 L
.33222 .01769 L
.33273 .01769 L
.33358 .01769 L
.33407 .01769 L
Mistroke
.33452 .01769 L
.33537 .01769 L
.33614 .01769 L
.33703 .01769 L
.33788 .01769 L
.33868 .01769 L
.3394 .01769 L
.34024 .01769 L
.34102 .01769 L
.34175 .01769 L
.34242 .01769 L
.34316 .01769 L
.34394 .01769 L
.34473 .01769 L
.34557 .01769 L
.34637 .01769 L
.34709 .01769 L
.34794 .01769 L
.34842 .01769 L
.34887 .01769 L
.34968 .01769 L
.35055 .01769 L
.35133 .01769 L
.35219 .01769 L
.35308 .01769 L
.35392 .01769 L
.3547 .01769 L
.35541 .01769 L
.35623 .01769 L
.357 .01769 L
.35784 .01769 L
.35874 .01769 L
.3595 .01769 L
.36034 .01769 L
.36124 .01769 L
.36174 .01769 L
.36221 .01769 L
.3631 .01769 L
.36395 .01769 L
.36475 .01769 L
.36547 .01769 L
.3663 .01769 L
.36708 .01769 L
.3678 .01769 L
.36847 .01769 L
.3692 .01769 L
.36997 .01769 L
.37076 .01769 L
.37159 .01769 L
.37238 .01769 L
Mistroke
.3731 .01769 L
.37395 .01769 L
.37443 .01769 L
.37487 .01769 L
.37567 .01769 L
.37653 .01769 L
.37736 .01769 L
.37826 .01769 L
.37912 .01769 L
.37991 .01769 L
.3807 .01769 L
.38141 .01769 L
.38223 .01769 L
.383 .01769 L
.38385 .01769 L
.38474 .01769 L
.38551 .01769 L
.38635 .01769 L
.38725 .01769 L
.38776 .01769 L
.38822 .01769 L
.38912 .01769 L
.38997 .01769 L
.39069 .01769 L
.39148 .01769 L
.39232 .01769 L
.3931 .01769 L
.39382 .01769 L
.39449 .01769 L
.39522 .01769 L
.39599 .01769 L
.39678 .01769 L
.39762 .01769 L
.39841 .01769 L
.39913 .01769 L
.39997 .01769 L
.40045 .01769 L
.40089 .01769 L
.4017 .01769 L
.40255 .01769 L
.40338 .01769 L
.40429 .01769 L
.40515 .01769 L
.40594 .01769 L
.40673 .01769 L
.40744 .01769 L
.40827 .01769 L
.40904 .01769 L
.40989 .01769 L
.41079 .01769 L
Mistroke
.41155 .01769 L
.41239 .01769 L
.4133 .01769 L
.4138 .01769 L
.41427 .01769 L
.41516 .01769 L
.41601 .01769 L
.41674 .01769 L
.41754 .01769 L
.41837 .01769 L
.41915 .01769 L
.41988 .01769 L
.42055 .01769 L
.42128 .01769 L
.42205 .01769 L
.42284 .01769 L
.42367 .01769 L
.42447 .01769 L
.42518 .01769 L
.42603 .01769 L
.42651 .01769 L
.42695 .01769 L
.42776 .01769 L
.42861 .01769 L
.42945 .01769 L
.43036 .01769 L
.43121 .01769 L
.43201 .01769 L
.43273 .01769 L
.43352 .01769 L
.43434 .01769 L
.43512 .01769 L
.43597 .01769 L
.43687 .01769 L
.43763 .01769 L
.43847 .01769 L
.43938 .01769 L
.43989 .01769 L
.44035 .01769 L
.44125 .01769 L
.4421 .01769 L
.44282 .01769 L
.44362 .01769 L
.44446 .01769 L
.44524 .01769 L
.44597 .01769 L
.44664 .01769 L
.44741 .01769 L
.44814 .01769 L
.44893 .01769 L
Mistroke
.44977 .01769 L
.45056 .01769 L
.45128 .01769 L
.45213 .01769 L
.4526 .01769 L
.45304 .01769 L
.45385 .01769 L
.4547 .01769 L
.45554 .01769 L
.45602 .01769 L
.45645 .01769 L
.45726 .01769 L
.45811 .01769 L
.45888 .01769 L
.45959 .01769 L
.46038 .01769 L
.46123 .01769 L
.46207 .01769 L
.46255 .01769 L
.463 .01769 L
.46391 .01769 L
.46441 .01769 L
.46487 .01769 L
.4657 .01769 L
.46659 .01769 L
.46744 .01769 L
.46822 .01769 L
.46894 .01769 L
.46972 .01769 L
.47046 .01769 L
.47113 .01769 L
.47192 .01769 L
.47278 .01769 L
.47359 .01769 L
.47434 .01769 L
.47519 .01769 L
.47599 .01769 L
.47671 .01769 L
.47749 .01769 L
.47833 .01769 L
.47923 .01769 L
.47999 .01769 L
.48083 .01769 L
.48173 .01769 L
.48257 .01769 L
.483 .01769 L
.48348 .01769 L
.48398 .01769 L
.48445 .01769 L
.48531 .01769 L
Mistroke
.4861 .01769 L
.48701 .01769 L
.48787 .01769 L
.48864 .01769 L
.48946 .01769 L
.49023 .01769 L
.49094 .01769 L
.49176 .01769 L
.49266 .01769 L
.4935 .01769 L
.49428 .01769 L
.49511 .01769 L
.49601 .01769 L
.49685 .01769 L
.49762 .01769 L
.49852 .01769 L
.49903 .01769 L
.4995 .01769 L
.50036 .01769 L
.5008 .01769 L
.50128 .01769 L
.50175 .01769 L
.50224 .01769 L
.50312 .01769 L
.50361 .01769 L
.50406 .01769 L
.50456 .01769 L
.5051 .01769 L
.50556 .01769 L
.50606 .01769 L
.50654 .01769 L
.50698 .01769 L
.5078 .01769 L
.50868 .01769 L
.50951 .01769 L
.51042 .01769 L
.51127 .01769 L
.51207 .01769 L
.51286 .01769 L
.51357 .01769 L
.51439 .01769 L
.51517 .01769 L
.51601 .01769 L
.51691 .01769 L
.51768 .01769 L
.51851 .01769 L
.51942 .01769 L
.51993 .01769 L
.52039 .01769 L
.52129 .01769 L
Mistroke
.52214 .01769 L
.52286 .01769 L
.52366 .01769 L
.52449 .01769 L
.52527 .01769 L
.526 .01769 L
.52667 .01769 L
.5274 .01769 L
.52817 .01769 L
.52896 .01769 L
.52979 .01769 L
.53059 .01769 L
.5313 .01769 L
.53215 .01769 L
.53263 .01769 L
.53307 .01769 L
.53388 .01769 L
.53473 .01769 L
.53556 .01769 L
.53647 .01769 L
.53733 .01769 L
.53813 .01769 L
.53892 .01769 L
.53963 .01769 L
.54046 .01769 L
.54123 .01769 L
.54208 .01769 L
.54298 .01769 L
.54375 .01769 L
.54459 .01769 L
.54549 .01769 L
.546 .01769 L
.54646 .01769 L
.54736 .01769 L
.54821 .01769 L
.54894 .01769 L
.54974 .01769 L
.55057 .01769 L
.55135 .01769 L
.55208 .01769 L
.55275 .01769 L
.55352 .01769 L
.55425 .01769 L
.55504 .01769 L
.55588 .01769 L
.55667 .01769 L
.55739 .01769 L
.55824 .01769 L
.55871 .01769 L
.55915 .01769 L
Mistroke
.55996 .01769 L
.56081 .01769 L
.56165 .01769 L
.56213 .01769 L
.56256 .01769 L
.56337 .01769 L
.56422 .01769 L
.56499 .01769 L
.5657 .01769 L
.56649 .01769 L
.56733 .01769 L
.56818 .01769 L
.56866 .01769 L
.56911 .01769 L
.57001 .01769 L
.57052 .01769 L
.57098 .01769 L
.5718 .01769 L
.5727 .01769 L
.57354 .01769 L
.57432 .01769 L
.57505 .01769 L
.57583 .01769 L
.57657 .01769 L
.57724 .01769 L
.57803 .01769 L
.57888 .01769 L
.5797 .01769 L
.58045 .01769 L
.5813 .01769 L
.5821 .01769 L
.58281 .01769 L
.58359 .01769 L
.58444 .01769 L
.58533 .01769 L
.5861 .01769 L
.58693 .01769 L
.58783 .01769 L
.58867 .01769 L
.5891 .01769 L
.58958 .01769 L
.59008 .01769 L
.59055 .01769 L
.59141 .01769 L
.5922 .01769 L
.59306 .01769 L
.59397 .01769 L
.59474 .01769 L
.59556 .01769 L
.59633 .01769 L
Mistroke
.59703 .01769 L
.59786 .01769 L
.59876 .01769 L
.5996 .01769 L
.60038 .01769 L
.60121 .01769 L
.6021 .01769 L
.60295 .01769 L
.60371 .01769 L
.60461 .01769 L
.60512 .01769 L
.60559 .01769 L
.60646 .01769 L
.60689 .01769 L
.60738 .01769 L
.60784 .01769 L
.60833 .01769 L
.60921 .01769 L
.6097 .01769 L
.61016 .01769 L
.61066 .01769 L
.61119 .01769 L
.61166 .01769 L
.61216 .01769 L
.61263 .01769 L
.61307 .01769 L
.6139 .01769 L
.61478 .01769 L
.61561 .01769 L
.61651 .01769 L
.61737 .01769 L
.61816 .01769 L
.61895 .01769 L
.61966 .01769 L
.62048 .01769 L
.62126 .01769 L
.6221 .01769 L
.623 .01769 L
.62376 .01769 L
.6246 .01769 L
.62551 .01769 L
.62601 .01769 L
.62648 .01769 L
.62737 .01769 L
.62822 .01769 L
.62895 .01769 L
.62974 .01769 L
.63058 .01769 L
.63136 .01769 L
.63209 .01769 L
Mistroke
.63275 .01769 L
.63349 .01769 L
.63426 .01769 L
.63504 .01769 L
.63588 .01769 L
.63667 .01769 L
.63739 .01769 L
.63824 .01769 L
.63871 .01769 L
.63915 .01769 L
.63996 .01769 L
.64082 .01769 L
.64165 .01769 L
.64256 .01769 L
.64342 .01769 L
.64421 .01769 L
.645 .01769 L
.64571 .01769 L
.64654 .01769 L
.64731 .01769 L
.64816 .01769 L
.64906 .01769 L
.64983 .01769 L
.65067 .01769 L
.65157 .01769 L
.65208 .01769 L
.65254 .01769 L
.65344 .01769 L
.65429 .01769 L
.65502 .01769 L
.65581 .01769 L
.65665 .01769 L
.65743 .01769 L
.65816 .01769 L
.65883 .01769 L
.6596 .01769 L
.66033 .01769 L
.66112 .01769 L
.66196 .01769 L
.66275 .01769 L
.66347 .01769 L
.66431 .01769 L
.66479 .01769 L
.66523 .01769 L
.66604 .01769 L
.66689 .01769 L
.66773 .01769 L
.6682 .01769 L
.66864 .01769 L
.66944 .01769 L
Mistroke
.6703 .01769 L
.67106 .01769 L
.67178 .01769 L
.67256 .01769 L
.67341 .01769 L
.67425 .01769 L
.67473 .01769 L
.67518 .01769 L
.67608 .01769 L
.67659 .01769 L
.67705 .01769 L
.67788 .01769 L
.67877 .01769 L
.67961 .01769 L
.68039 .01769 L
.68112 .01769 L
.6819 .01769 L
.68264 .01769 L
.68331 .01769 L
.6841 .01769 L
.68495 .01769 L
.68576 .01769 L
.68652 .01769 L
.68737 .01769 L
.68816 .01769 L
.68888 .01769 L
.68966 .01769 L
.69051 .01769 L
.6914 .01769 L
.69217 .01769 L
.693 .01769 L
.6939 .01769 L
.69473 .01769 L
.69517 .01769 L
.69565 .01769 L
.69615 .01769 L
.69662 .01769 L
.69748 .01769 L
.69826 .01769 L
.69913 .01769 L
.70004 .01769 L
.7008 .01769 L
.70162 .01769 L
.7024 .01769 L
.7031 .01769 L
.70392 .01769 L
.70482 .01769 L
.70566 .01769 L
.70644 .01769 L
.70727 .01769 L
Mistroke
.70817 .01769 L
.70901 .01769 L
.70978 .01769 L
.71068 .01769 L
.71118 .01769 L
.71166 .01769 L
.71252 .01769 L
.71296 .01769 L
.71344 .01769 L
.7139 .01769 L
.71439 .01769 L
.71527 .01769 L
.71576 .01769 L
.71622 .01769 L
.71672 .01769 L
.71725 .01769 L
.71772 .01769 L
.71822 .01769 L
.71869 .01769 L
.71913 .01769 L
.71996 .01769 L
.72084 .01769 L
.72167 .01769 L
.72257 .01769 L
.72343 .01769 L
.72422 .01769 L
.725 .01769 L
.72572 .01769 L
.72654 .01769 L
.72731 .01769 L
.72816 .01769 L
.72906 .01769 L
.72982 .01769 L
.73066 .01769 L
.73156 .01769 L
.73207 .01769 L
.73253 .01769 L
.73343 .01769 L
.73428 .01769 L
.735 .01769 L
.7358 .01769 L
.73663 .01769 L
.73741 .01769 L
.73814 .01769 L
.73881 .01769 L
.73954 .01769 L
.74031 .01769 L
.74109 .01769 L
.74193 .01769 L
.74272 .01769 L
Mistroke
.74344 .01769 L
.74429 .01769 L
.74476 .01769 L
.7452 .01769 L
.74601 .01769 L
.74687 .01769 L
.7477 .01769 L
.74861 .01769 L
.74947 .01769 L
.75026 .01769 L
.75105 .01769 L
.75176 .01769 L
.75259 .01769 L
.75336 .01769 L
.75421 .01769 L
.75511 .01769 L
.75588 .01769 L
.75671 .01769 L
.75762 .01769 L
.75813 .01769 L
.75859 .01769 L
.75949 .01769 L
.76034 .01769 L
.76106 .01769 L
.76186 .01769 L
.76269 .01769 L
.76348 .01769 L
.7642 .01769 L
.76487 .01769 L
.76561 .01769 L
.76638 .01769 L
.76716 .01769 L
.768 .01769 L
.76879 .01769 L
.76951 .01769 L
.77036 .01769 L
.77083 .01769 L
.77127 .01769 L
.77208 .01769 L
.77294 .01769 L
.77377 .01769 L
.77425 .01769 L
.77468 .01769 L
.77549 .01769 L
.77634 .01769 L
.7771 .01769 L
.77782 .01769 L
.7786 .01769 L
.77945 .01769 L
.78029 .01769 L
Mistroke
.78077 .01769 L
.78122 .01769 L
.78212 .01769 L
.78263 .01769 L
.78309 .01769 L
.78391 .01769 L
.78481 .01769 L
.78565 .01769 L
.78643 .01769 L
.78716 .01769 L
.78794 .01769 L
.78867 .01769 L
.78934 .01769 L
.79013 .01769 L
.79099 .01769 L
.7918 .01769 L
.79255 .01769 L
.7934 .01769 L
.7942 .01769 L
.79492 .01769 L
.79569 .01769 L
.79654 .01769 L
.79744 .01769 L
.7982 .01769 L
.79904 .01769 L
.79994 .01769 L
.80077 .01769 L
.8012 .01769 L
.80168 .01769 L
.80218 .01769 L
.80265 .01769 L
.80351 .01769 L
.80429 .01769 L
.80516 .01769 L
.80607 .01769 L
.80683 .01769 L
.80765 .01769 L
.80843 .01769 L
.80913 .01769 L
.80995 .01769 L
.81085 .01769 L
.81169 .01769 L
.81247 .01769 L
.8133 .01769 L
.81419 .01769 L
.81503 .01769 L
.8158 .01769 L
.8167 .01769 L
.81721 .01769 L
.81768 .01769 L
Mistroke
.81855 .01769 L
.81903 .01769 L
.81947 .01769 L
.81993 .01769 L
.82042 .01769 L
.8213 .01769 L
.82179 .01769 L
.82224 .01769 L
.82274 .01769 L
.82328 .01769 L
.82374 .01769 L
.82424 .01769 L
.82472 .01769 L
.82516 .01769 L
.82599 .01769 L
.82686 .01769 L
.82769 .01769 L
.8286 .01769 L
.82945 .01769 L
.83024 .01769 L
.83103 .01769 L
.83174 .01769 L
.83256 .01769 L
.83334 .01769 L
.83418 .01769 L
.83508 .01769 L
.83584 .01769 L
.83668 .01769 L
.83758 .01769 L
.83809 .01769 L
.83855 .01769 L
.83945 .01769 L
.8403 .01769 L
.84102 .01769 L
.84182 .01769 L
.84265 .01769 L
.84343 .01769 L
.84416 .01769 L
.84482 .01769 L
.84556 .01769 L
.84633 .01769 L
.84711 .01769 L
.84795 .01769 L
.84874 .01769 L
.84946 .01769 L
.85031 .01769 L
.85078 .01769 L
.85122 .01769 L
.85203 .01769 L
.85289 .01769 L
Mistroke
.85372 .01769 L
.85463 .01769 L
.85548 .01769 L
.85628 .01769 L
.85706 .01769 L
.85778 .01769 L
.8586 .01769 L
.85938 .01769 L
.86023 .01769 L
.86112 .01769 L
.86189 .01769 L
.86273 .01769 L
.86363 .01769 L
.86414 .01769 L
.8646 .01769 L
.8655 .01769 L
.86635 .01769 L
.86707 .01769 L
.86787 .01769 L
.8687 .01769 L
.86949 .01769 L
.87021 .01769 L
.87088 .01769 L
.87162 .01769 L
.87239 .01769 L
.87317 .01769 L
.87401 .01769 L
.8748 .01769 L
.87552 .01769 L
.87637 .01769 L
.87684 .01769 L
.87728 .01769 L
.87809 .01769 L
.87895 .01769 L
.87978 .01769 L
.88025 .01769 L
.88069 .01769 L
.88149 .01769 L
.88235 .01769 L
.88311 .01769 L
.88382 .01769 L
.88461 .01769 L
.88545 .01769 L
.8863 .01769 L
.88678 .01769 L
.88722 .01769 L
.88813 .01769 L
.88863 .01769 L
.88909 .01769 L
.88992 .01769 L
Mistroke
.89081 .01769 L
.89165 .01769 L
.89243 .01769 L
.89316 .01769 L
.89394 .01769 L
.89467 .01769 L
.89535 .01769 L
.89613 .01769 L
.89699 .01769 L
.8978 .01769 L
.89855 .01769 L
.8994 .01769 L
.9002 .01769 L
.90092 .01769 L
.90169 .01769 L
.90254 .01769 L
.90344 .01769 L
.9042 .01769 L
.90504 .01769 L
.90565 .01769 L
.90621 .01769 L
.90682 .01769 L
.90748 .01769 L
.90804 .01769 L
.90858 .01769 L
.90916 .01769 L
.90979 .01769 L
.91031 .01769 L
.91089 .01769 L
.91149 .01769 L
.91204 .01769 L
.91257 .01769 L
.91304 .01769 L
.91359 .01769 L
.91411 .01769 L
.91467 .01769 L
.91529 .01769 L
.91594 .01769 L
.91654 .01769 L
.9171 .01769 L
.91762 .01769 L
.91821 .01769 L
.91878 .01769 L
.91939 .01769 L
.92003 .01769 L
.92064 .01769 L
.9212 .01769 L
.92185 .01769 L
.92256 .01769 L
.92322 .01769 L
Mistroke
.92384 .01769 L
Mfstroke
.26863 .72525 m
.29521 .70919 L
.3242 .69249 L
.35142 .67753 L
.37761 .66375 L
.40547 .6497 L
.4323 .63675 L
.46081 .62354 L
.48828 .61135 L
.51471 .60007 L
.54283 .58853 L
.5699 .57784 L
.59593 .56794 L
.62364 .55777 L
.65032 .54833 L
.67868 .53865 L
.70599 .52966 L
.73227 .5213 L
.76023 .51269 L
.78715 .50468 L
.81576 .49645 L
.84332 .48877 L
.86984 .48162 L
.89805 .47424 L
.92384 .4677 L
s
.92384 .01778 m
.9239 .03294 L
.92396 .03877 L
.92409 .04802 L
.92433 .05984 L
.92461 .07039 L
.92487 .07871 L
.92596 .10516 L
.92707 .12565 L
.92828 .1442 L
.93052 .17299 L
.93269 .1964 L
.93476 .21636 L
.93698 .23562 L
.93911 .2527 L
.94138 .26961 L
.94356 .2849 L
.94566 .29884 L
.94789 .31298 L
.95005 .32599 L
.95233 .33925 L
.95453 .35155 L
.95665 .36298 L
.95891 .37475 L
.96108 .38574 L
.96317 .39603 L
.96539 .40669 L
.96753 .41669 L
.9698 .42707 L
.97199 .43684 L
.9741 .44603 L
.97619 .45498 L
s
.92384 .4677 m
.92596 .46717 L
.92828 .46659 L
.93045 .46605 L
.93254 .46554 L
.93477 .46498 L
.93691 .46446 L
.93919 .4639 L
.94139 .46336 L
.9435 .46284 L
.94574 .46229 L
.94791 .46176 L
.94999 .46126 L
.9522 .46072 L
.95433 .4602 L
.9566 .45966 L
.95878 .45913 L
.96088 .45863 L
.96312 .45809 L
.96527 .45758 L
.96755 .45703 L
.96976 .45651 L
.97188 .456 L
.97413 .45547 L
.97619 .45498 L
s
0 1 1 r
.92384 .01778 m
.9239 .03294 L
.92396 .03877 L
.92409 .04802 L
.92433 .05984 L
.92461 .07039 L
.92487 .07871 L
.92596 .10516 L
.92707 .12565 L
.92828 .1442 L
.93052 .17299 L
.93269 .1964 L
.93476 .21636 L
.93698 .23562 L
.93911 .2527 L
.94138 .26961 L
.94356 .2849 L
.94566 .29884 L
.94789 .31298 L
.95005 .32599 L
.95233 .33925 L
.95453 .35155 L
.95665 .36298 L
.95891 .37475 L
.96108 .38574 L
.96317 .39603 L
.96539 .40669 L
.96753 .41669 L
.9698 .42707 L
.97199 .43684 L
.9741 .44603 L
.97619 .45498 L
.97619 .45498 L
.97413 .45547 L
.97188 .456 L
.96976 .45651 L
.96755 .45703 L
.96527 .45758 L
.96312 .45809 L
.96088 .45863 L
.95878 .45913 L
.9566 .45966 L
.95433 .4602 L
.9522 .46072 L
.94999 .46126 L
.94791 .46176 L
.94574 .46229 L
.9435 .46284 L
.94139 .46336 L
.93919 .4639 L
.93691 .46446 L
.93477 .46498 L
.93254 .46554 L
.93045 .46605 L
.92828 .46659 L
.92596 .46717 L
.92384 .4677 L
F
0 g
.92384 .01778 m
.9239 .03294 L
.92396 .03877 L
.92409 .04802 L
.92433 .05984 L
.92461 .07039 L
.92487 .07871 L
.92596 .10516 L
.92707 .12565 L
.92828 .1442 L
.93052 .17299 L
.93269 .1964 L
.93476 .21636 L
.93698 .23562 L
.93911 .2527 L
.94138 .26961 L
.94356 .2849 L
.94566 .29884 L
.94789 .31298 L
.95005 .32599 L
.95233 .33925 L
.95453 .35155 L
.95665 .36298 L
.95891 .37475 L
.96108 .38574 L
.96317 .39603 L
.96539 .40669 L
.96753 .41669 L
.9698 .42707 L
.97199 .43684 L
.9741 .44603 L
.97619 .45498 L
s
.92384 .4677 m
.92596 .46717 L
.92828 .46659 L
.93045 .46605 L
.93254 .46554 L
.93477 .46498 L
.93691 .46446 L
.93919 .4639 L
.94139 .46336 L
.9435 .46284 L
.94574 .46229 L
.94791 .46176 L
.94999 .46126 L
.9522 .46072 L
.95433 .4602 L
.9566 .45966 L
.95878 .45913 L
.96088 .45863 L
.96312 .45809 L
.96527 .45758 L
.96755 .45703 L
.96976 .45651 L
.97188 .456 L
.97413 .45547 L
.97619 .45498 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.742934 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.876216 0.900026 0.0176889 0.900026 [
[.20381 .00519 -9 -9 ]
[.20381 .00519 9 0 ]
[.38382 .00519 -9 -9 ]
[.38382 .00519 9 0 ]
[.56382 .00519 -9 -9 ]
[.56382 .00519 9 0 ]
[.74383 .00519 -9 -9 ]
[.74383 .00519 9 0 ]
[.92384 .00519 -3 -9 ]
[.92384 .00519 3 0 ]
[.01131 .19769 -18 -4.5 ]
[.01131 .19769 0 4.5 ]
[.01131 .3777 -18 -4.5 ]
[.01131 .3777 0 4.5 ]
[.01131 .5577 -18 -4.5 ]
[.01131 .5577 0 4.5 ]
[.01131 .73771 -18 -4.5 ]
[.01131 .73771 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .74293 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.20381 .01769 m
.20381 .02394 L
s
[(1.2)] .20381 .00519 0 1 Mshowa
.38382 .01769 m
.38382 .02394 L
s
[(1.4)] .38382 .00519 0 1 Mshowa
.56382 .01769 m
.56382 .02394 L
s
[(1.6)] .56382 .00519 0 1 Mshowa
.74383 .01769 m
.74383 .02394 L
s
[(1.8)] .74383 .00519 0 1 Mshowa
.92384 .01769 m
.92384 .02394 L
s
[(2)] .92384 .00519 0 1 Mshowa
.125 Mabswid
.06881 .01769 m
.06881 .02144 L
s
.11381 .01769 m
.11381 .02144 L
s
.15881 .01769 m
.15881 .02144 L
s
.24882 .01769 m
.24882 .02144 L
s
.29382 .01769 m
.29382 .02144 L
s
.33882 .01769 m
.33882 .02144 L
s
.42882 .01769 m
.42882 .02144 L
s
.47382 .01769 m
.47382 .02144 L
s
.51882 .01769 m
.51882 .02144 L
s
.60883 .01769 m
.60883 .02144 L
s
.65383 .01769 m
.65383 .02144 L
s
.69883 .01769 m
.69883 .02144 L
s
.78883 .01769 m
.78883 .02144 L
s
.83383 .01769 m
.83383 .02144 L
s
.87883 .01769 m
.87883 .02144 L
s
.96884 .01769 m
.96884 .02144 L
s
.25 Mabswid
0 .01769 m
1 .01769 L
s
.02381 .19769 m
.03006 .19769 L
s
[(0.2)] .01131 .19769 1 0 Mshowa
.02381 .3777 m
.03006 .3777 L
s
[(0.4)] .01131 .3777 1 0 Mshowa
.02381 .5577 m
.03006 .5577 L
s
[(0.6)] .01131 .5577 1 0 Mshowa
.02381 .73771 m
.03006 .73771 L
s
[(0.8)] .01131 .73771 1 0 Mshowa
.125 Mabswid
.02381 .06269 m
.02756 .06269 L
s
.02381 .10769 m
.02756 .10769 L
s
.02381 .15269 m
.02756 .15269 L
s
.02381 .2427 m
.02756 .2427 L
s
.02381 .2877 m
.02756 .2877 L
s
.02381 .3327 m
.02756 .3327 L
s
.02381 .4227 m
.02756 .4227 L
s
.02381 .4677 m
.02756 .4677 L
s
.02381 .5127 m
.02756 .5127 L
s
.02381 .60271 m
.02756 .60271 L
s
.02381 .64771 m
.02756 .64771 L
s
.02381 .69271 m
.02756 .69271 L
s
.25 Mabswid
.02381 0 m
.02381 .74293 L
s
0 0 m
1 0 L
1 .74293 L
0 .74293 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.35.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.35.1"]
}, Open  ]],

Cell[TextData[{
 "This plots the symmetric difference between the two regions ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       StyleBox["x",
        "TI"], "+", 
       FractionBox["1", "2"]}], ")"}], "2"], "+", 
    SuperscriptBox[
     StyleBox["y",
      "TI"], "2"], "\[LessEqual]", "1"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       StyleBox["x",
        "TI"], "-", 
       FractionBox["1", "2"]}], ")"}], "2"], "+", 
    SuperscriptBox[
     StyleBox["y",
      "TI"], "2"], "\[LessEqual]", "1"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". Since the region is bounded, you will not need to give additional bounds \
in the range specification. "
}], "MathCaption",
 CellTags->{"S5.35.1", "1.6"}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InequalityPlot", "[", " ", 
  RowBox[{
   RowBox[{"Xor", "[", " ", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"x", "+", 
          FractionBox["1", "2"]}], ")"}], "2"], "+", " ", 
       SuperscriptBox["y", "2"]}], "\[LessEqual]", "1"}], ",", " ", 
     RowBox[{
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"x", "-", 
          FractionBox["1", "2"]}], ")"}], "2"], "+", " ", 
       SuperscriptBox["y", "2"]}], "\[LessEqual]", "1"}]}], "]"}], ",", " ", 
   RowBox[{"{", "x", "}"}], ",", " ", 
   RowBox[{"{", "y", "}"}]}], " ", "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.35.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .66667 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.666667 [
[ 0 0 0 0 ]
[ 1 .66667 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .66667 L
0 .66667 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.666667 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.31746 0.333333 0.31746 [
[.02381 .32083 -12 -9 ]
[.02381 .32083 12 0 ]
[.18254 .32083 -6 -9 ]
[.18254 .32083 6 0 ]
[.34127 .32083 -12 -9 ]
[.34127 .32083 12 0 ]
[.65873 .32083 -9 -9 ]
[.65873 .32083 9 0 ]
[.81746 .32083 -3 -9 ]
[.81746 .32083 3 0 ]
[.97619 .32083 -9 -9 ]
[.97619 .32083 9 0 ]
[.4875 .01587 -12 -4.5 ]
[.4875 .01587 0 4.5 ]
[.4875 .1746 -24 -4.5 ]
[.4875 .1746 0 4.5 ]
[.4875 .49206 -18 -4.5 ]
[.4875 .49206 0 4.5 ]
[.4875 .65079 -6 -4.5 ]
[.4875 .65079 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .66667 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .33333 m
.02381 .33958 L
s
[(-1.5)] .02381 .32083 0 1 Mshowa
.18254 .33333 m
.18254 .33958 L
s
[(-1)] .18254 .32083 0 1 Mshowa
.34127 .33333 m
.34127 .33958 L
s
[(-0.5)] .34127 .32083 0 1 Mshowa
.65873 .33333 m
.65873 .33958 L
s
[(0.5)] .65873 .32083 0 1 Mshowa
.81746 .33333 m
.81746 .33958 L
s
[(1)] .81746 .32083 0 1 Mshowa
.97619 .33333 m
.97619 .33958 L
s
[(1.5)] .97619 .32083 0 1 Mshowa
.125 Mabswid
.05556 .33333 m
.05556 .33708 L
s
.0873 .33333 m
.0873 .33708 L
s
.11905 .33333 m
.11905 .33708 L
s
.15079 .33333 m
.15079 .33708 L
s
.21429 .33333 m
.21429 .33708 L
s
.24603 .33333 m
.24603 .33708 L
s
.27778 .33333 m
.27778 .33708 L
s
.30952 .33333 m
.30952 .33708 L
s
.37302 .33333 m
.37302 .33708 L
s
.40476 .33333 m
.40476 .33708 L
s
.43651 .33333 m
.43651 .33708 L
s
.46825 .33333 m
.46825 .33708 L
s
.53175 .33333 m
.53175 .33708 L
s
.56349 .33333 m
.56349 .33708 L
s
.59524 .33333 m
.59524 .33708 L
s
.62698 .33333 m
.62698 .33708 L
s
.69048 .33333 m
.69048 .33708 L
s
.72222 .33333 m
.72222 .33708 L
s
.75397 .33333 m
.75397 .33708 L
s
.78571 .33333 m
.78571 .33708 L
s
.84921 .33333 m
.84921 .33708 L
s
.88095 .33333 m
.88095 .33708 L
s
.9127 .33333 m
.9127 .33708 L
s
.94444 .33333 m
.94444 .33708 L
s
.25 Mabswid
0 .33333 m
1 .33333 L
s
.5 .01587 m
.50625 .01587 L
s
[(-1)] .4875 .01587 1 0 Mshowa
.5 .1746 m
.50625 .1746 L
s
[(-0.5)] .4875 .1746 1 0 Mshowa
.5 .49206 m
.50625 .49206 L
s
[(0.5)] .4875 .49206 1 0 Mshowa
.5 .65079 m
.50625 .65079 L
s
[(1)] .4875 .65079 1 0 Mshowa
.125 Mabswid
.5 .04762 m
.50375 .04762 L
s
.5 .07937 m
.50375 .07937 L
s
.5 .11111 m
.50375 .11111 L
s
.5 .14286 m
.50375 .14286 L
s
.5 .20635 m
.50375 .20635 L
s
.5 .2381 m
.50375 .2381 L
s
.5 .26984 m
.50375 .26984 L
s
.5 .30159 m
.50375 .30159 L
s
.5 .36508 m
.50375 .36508 L
s
.5 .39683 m
.50375 .39683 L
s
.5 .42857 m
.50375 .42857 L
s
.5 .46032 m
.50375 .46032 L
s
.5 .52381 m
.50375 .52381 L
s
.5 .55556 m
.50375 .55556 L
s
.5 .5873 m
.50375 .5873 L
s
.5 .61905 m
.50375 .61905 L
s
.25 Mabswid
.5 0 m
.5 .66667 L
s
0 0 m
1 0 L
1 .66667 L
0 .66667 L
closepath
clip
newpath
.5 Mabswid
.02381 .33324 m
.0242 .31756 L
.02456 .31155 L
.02536 .30201 L
.0268 .28985 L
.02849 .27904 L
.03008 .27055 L
.03669 .24383 L
.04342 .22348 L
.05073 .20539 L
.06436 .17809 L
.07747 .15672 L
.09008 .1392 L
.10351 .12297 L
.11644 .10921 L
.13018 .09622 L
.14341 .08507 L
.15615 .07544 L
.16969 .06623 L
.18274 .05829 L
.1966 .05075 L
.20995 .04431 L
.2228 .03881 L
.23647 .03367 L
.24963 .02939 L
.26229 .02585 L
.27577 .0227 L
.28874 .02025 L
.29534 .01921 L
.30252 .01825 L
.30884 .01753 L
.3158 .0169 L
.3224 .01643 L
.32601 .01624 L
.3294 .0161 L
.33242 .016 L
.33393 .01596 L
.33559 .01592 L
.33701 .0159 L
.33781 .01589 L
.33853 .01588 L
.33921 .01588 L
.33956 .01588 L
.33994 .01588 L
.34027 .01587 L
.34063 .01587 L
.34096 .01587 L
.34127 .01587 L
s
.02381 .33342 m
.0242 .3491 L
.02456 .35512 L
.02536 .36466 L
.0268 .37682 L
.02849 .38762 L
.03008 .39611 L
.03669 .42284 L
.04342 .44319 L
.05073 .46128 L
.06436 .48857 L
.07747 .50995 L
.09008 .52746 L
.10351 .5437 L
.11644 .55746 L
.13018 .57044 L
.14341 .5816 L
.15615 .59123 L
.16969 .60043 L
.18274 .60838 L
.1966 .61591 L
.20995 .62236 L
.2228 .62786 L
.23647 .633 L
.24963 .63728 L
.26229 .64081 L
.27577 .64396 L
.28874 .64642 L
.29534 .64745 L
.30252 .64842 L
.30884 .64913 L
.3158 .64977 L
.3224 .65023 L
.32601 .65043 L
.3294 .65057 L
.33242 .65067 L
.33393 .65071 L
.33559 .65074 L
.33701 .65077 L
.33781 .65077 L
.33853 .65078 L
.33921 .65079 L
.33956 .65079 L
.33994 .65079 L
.34027 .65079 L
.34063 .65079 L
.34096 .65079 L
.34127 .65079 L
s
0 1 1 r
.02381 .33324 m
.0242 .31756 L
.02456 .31155 L
.02536 .30201 L
.0268 .28985 L
.02849 .27904 L
.03008 .27055 L
.03669 .24383 L
.04342 .22348 L
.05073 .20539 L
.06436 .17809 L
.07747 .15672 L
.09008 .1392 L
.10351 .12297 L
.11644 .10921 L
.13018 .09622 L
.14341 .08507 L
.15615 .07544 L
.16969 .06623 L
.18274 .05829 L
.1966 .05075 L
.20995 .04431 L
.2228 .03881 L
.23647 .03367 L
.24963 .02939 L
.26229 .02585 L
.27577 .0227 L
.28874 .02025 L
.29534 .01921 L
.30252 .01825 L
.30884 .01753 L
.3158 .0169 L
.3224 .01643 L
.32601 .01624 L
.3294 .0161 L
.33242 .016 L
.33393 .01596 L
.33559 .01592 L
.33701 .0159 L
.33781 .01589 L
.33853 .01588 L
.33921 .01588 L
.33956 .01588 L
.33994 .01588 L
.34027 .01587 L
.34063 .01587 L
.34096 .01587 L
.34127 .01587 L
.34127 .65079 L
.34096 .65079 L
.34063 .65079 L
.34027 .65079 L
.33994 .65079 L
.33956 .65079 L
.33921 .65079 L
.33853 .65078 L
.33781 .65077 L
.33701 .65077 L
.33559 .65074 L
.33393 .65071 L
.33242 .65067 L
.3294 .65057 L
.32601 .65043 L
.3224 .65023 L
.3158 .64977 L
.30884 .64913 L
.30252 .64842 L
.29534 .64745 L
.28874 .64642 L
.27577 .64396 L
.26229 .64081 L
.24963 .63728 L
.23647 .633 L
.2228 .62786 L
.20995 .62236 L
.1966 .61591 L
.18274 .60838 L
.16969 .60043 L
.15615 .59123 L
.14341 .5816 L
.13018 .57044 L
.11644 .55746 L
.10351 .5437 L
.09008 .52746 L
.07747 .50995 L
.06436 .48857 L
.05073 .46128 L
.04342 .44319 L
.03669 .42284 L
.03008 .39611 L
.02849 .38762 L
.0268 .37682 L
.02536 .36466 L
.02456 .35512 L
.0242 .3491 L
.02381 .33342 L
F
0 g
.02381 .33324 m
.0242 .31756 L
.02456 .31155 L
.02536 .30201 L
.0268 .28985 L
.02849 .27904 L
.03008 .27055 L
.03669 .24383 L
.04342 .22348 L
.05073 .20539 L
.06436 .17809 L
.07747 .15672 L
.09008 .1392 L
.10351 .12297 L
.11644 .10921 L
.13018 .09622 L
.14341 .08507 L
.15615 .07544 L
.16969 .06623 L
.18274 .05829 L
.1966 .05075 L
.20995 .04431 L
.2228 .03881 L
.23647 .03367 L
.24963 .02939 L
.26229 .02585 L
.27577 .0227 L
.28874 .02025 L
.29534 .01921 L
.30252 .01825 L
.30884 .01753 L
.3158 .0169 L
.3224 .01643 L
.32601 .01624 L
.3294 .0161 L
.33242 .016 L
.33393 .01596 L
.33559 .01592 L
.33701 .0159 L
.33781 .01589 L
.33853 .01588 L
.33921 .01588 L
.33956 .01588 L
.33994 .01588 L
.34027 .01587 L
.34063 .01587 L
.34096 .01587 L
.34127 .01587 L
s
.02381 .33342 m
.0242 .3491 L
.02456 .35512 L
.02536 .36466 L
.0268 .37682 L
.02849 .38762 L
.03008 .39611 L
.03669 .42284 L
.04342 .44319 L
.05073 .46128 L
.06436 .48857 L
.07747 .50995 L
.09008 .52746 L
.10351 .5437 L
.11644 .55746 L
.13018 .57044 L
.14341 .5816 L
.15615 .59123 L
.16969 .60043 L
.18274 .60838 L
.1966 .61591 L
.20995 .62236 L
.2228 .62786 L
.23647 .633 L
.24963 .63728 L
.26229 .64081 L
.27577 .64396 L
.28874 .64642 L
.29534 .64745 L
.30252 .64842 L
.30884 .64913 L
.3158 .64977 L
.3224 .65023 L
.32601 .65043 L
.3294 .65057 L
.33242 .65067 L
.33393 .65071 L
.33559 .65074 L
.33701 .65077 L
.33781 .65077 L
.33853 .65078 L
.33921 .65079 L
.33956 .65079 L
.33994 .65079 L
.34027 .65079 L
.34063 .65079 L
.34096 .65079 L
.34127 .65079 L
s
.34127 .01587 m
.34147 .01587 L
.34164 .01587 L
.34185 .01587 L
.34204 .01587 L
.34239 .01587 L
.34277 .01588 L
.34318 .01588 L
.34362 .01588 L
.3444 .01589 L
.34522 .0159 L
.34598 .01591 L
.34771 .01594 L
.34948 .01598 L
.35109 .01603 L
.35473 .01616 L
.3579 .01631 L
.36135 .01651 L
.36812 .01701 L
.37465 .01763 L
.38158 .01844 L
.38825 .01937 L
.39468 .0204 L
.40151 .02164 L
.40809 .02299 L
.41442 .02442 L
.42116 .02609 L
.42764 .02785 L
.43454 .02988 L
.44118 .032 L
.44757 .0342 L
.45436 .0367 L
.46091 .03928 L
.4672 .04192 L
.4739 .04491 L
.48035 .04796 L
.48721 .0514 L
.49381 .05492 L
.5 .0584 L
s
.34127 .33327 m
.34147 .32218 L
.34164 .31792 L
.34204 .31117 L
.34277 .30255 L
.34361 .29487 L
.3444 .28883 L
.34771 .26972 L
.35108 .25504 L
.35473 .24187 L
.36154 .22171 L
.3681 .2056 L
.37441 .19212 L
.38112 .17934 L
.38758 .16823 L
.39445 .15744 L
.40107 .14788 L
.40744 .13934 L
.41421 .13087 L
.42073 .12324 L
.42766 .11564 L
.43434 .10877 L
.44077 .10252 L
.4476 .09626 L
.45418 .09056 L
.46051 .08536 L
.46725 .08012 L
.47373 .07535 L
.48063 .07054 L
.48727 .06616 L
.49366 .06217 L
.5 .0584 L
s
0 1 1 r
.34127 .01587 m
.34147 .01587 L
.34164 .01587 L
.34185 .01587 L
.34204 .01587 L
.34239 .01587 L
.34277 .01588 L
.34318 .01588 L
.34362 .01588 L
.3444 .01589 L
.34522 .0159 L
.34598 .01591 L
.34771 .01594 L
.34948 .01598 L
.35109 .01603 L
.35473 .01616 L
.3579 .01631 L
.36135 .01651 L
.36812 .01701 L
.37465 .01763 L
.38158 .01844 L
.38825 .01937 L
.39468 .0204 L
.40151 .02164 L
.40809 .02299 L
.41442 .02442 L
.42116 .02609 L
.42764 .02785 L
.43454 .02988 L
.44118 .032 L
.44757 .0342 L
.45436 .0367 L
.46091 .03928 L
.4672 .04192 L
.4739 .04491 L
.48035 .04796 L
.48721 .0514 L
.49381 .05492 L
.5 .0584 L
.5 .0584 L
.49366 .06217 L
.48727 .06616 L
.48063 .07054 L
.47373 .07535 L
.46725 .08012 L
.46051 .08536 L
.45418 .09056 L
.4476 .09626 L
.44077 .10252 L
.43434 .10877 L
.42766 .11564 L
.42073 .12324 L
.41421 .13087 L
.40744 .13934 L
.40107 .14788 L
.39445 .15744 L
.38758 .16823 L
.38112 .17934 L
.37441 .19212 L
.3681 .2056 L
.36154 .22171 L
.35473 .24187 L
.35108 .25504 L
.34771 .26972 L
.3444 .28883 L
.34361 .29487 L
.34277 .30255 L
.34204 .31117 L
.34164 .31792 L
.34147 .32218 L
.34127 .33327 L
F
0 g
.34127 .01587 m
.34147 .01587 L
.34164 .01587 L
.34185 .01587 L
.34204 .01587 L
.34239 .01587 L
.34277 .01588 L
.34318 .01588 L
.34362 .01588 L
.3444 .01589 L
.34522 .0159 L
.34598 .01591 L
.34771 .01594 L
.34948 .01598 L
.35109 .01603 L
.35473 .01616 L
.3579 .01631 L
.36135 .01651 L
.36812 .01701 L
.37465 .01763 L
.38158 .01844 L
.38825 .01937 L
.39468 .0204 L
.40151 .02164 L
.40809 .02299 L
.41442 .02442 L
.42116 .02609 L
.42764 .02785 L
.43454 .02988 L
.44118 .032 L
.44757 .0342 L
.45436 .0367 L
.46091 .03928 L
.4672 .04192 L
.4739 .04491 L
.48035 .04796 L
.48721 .0514 L
.49381 .05492 L
.5 .0584 L
s
.34127 .33327 m
.34147 .32218 L
.34164 .31792 L
.34204 .31117 L
.34277 .30255 L
.34361 .29487 L
.3444 .28883 L
.34771 .26972 L
.35108 .25504 L
.35473 .24187 L
.36154 .22171 L
.3681 .2056 L
.37441 .19212 L
.38112 .17934 L
.38758 .16823 L
.39445 .15744 L
.40107 .14788 L
.40744 .13934 L
.41421 .13087 L
.42073 .12324 L
.42766 .11564 L
.43434 .10877 L
.44077 .10252 L
.4476 .09626 L
.45418 .09056 L
.46051 .08536 L
.46725 .08012 L
.47373 .07535 L
.48063 .07054 L
.48727 .06616 L
.49366 .06217 L
.5 .0584 L
s
.34127 .3334 m
.34147 .34449 L
.34164 .34874 L
.34204 .3555 L
.34277 .36412 L
.34361 .37179 L
.3444 .37784 L
.34771 .39695 L
.35108 .41163 L
.35473 .4248 L
.36154 .44496 L
.3681 .46107 L
.37441 .47455 L
.38112 .48733 L
.38758 .49844 L
.39445 .50923 L
.40107 .51879 L
.40744 .52733 L
.41421 .5358 L
.42073 .54343 L
.42766 .55102 L
.43434 .5579 L
.44077 .56414 L
.4476 .57041 L
.45418 .57611 L
.46051 .58131 L
.46725 .58654 L
.47373 .59132 L
.48063 .59613 L
.48727 .60051 L
.49366 .6045 L
.5 .60826 L
s
.34127 .65079 m
.34147 .65079 L
.34164 .65079 L
.34185 .65079 L
.34204 .65079 L
.34239 .65079 L
.34277 .65079 L
.34318 .65079 L
.34362 .65078 L
.3444 .65078 L
.34522 .65077 L
.34598 .65076 L
.34771 .65073 L
.34948 .65069 L
.35109 .65064 L
.35473 .65051 L
.3579 .65036 L
.36135 .65016 L
.36812 .64966 L
.37465 .64903 L
.38158 .64822 L
.38825 .6473 L
.39468 .64627 L
.40151 .64503 L
.40809 .64368 L
.41442 .64225 L
.42116 .64058 L
.42764 .63882 L
.43454 .63678 L
.44118 .63466 L
.44757 .63247 L
.45436 .62997 L
.46091 .62739 L
.4672 .62475 L
.4739 .62176 L
.48035 .61871 L
.48721 .61526 L
.49381 .61174 L
.5 .60826 L
s
0 1 1 r
.34127 .3334 m
.34147 .34449 L
.34164 .34874 L
.34204 .3555 L
.34277 .36412 L
.34361 .37179 L
.3444 .37784 L
.34771 .39695 L
.35108 .41163 L
.35473 .4248 L
.36154 .44496 L
.3681 .46107 L
.37441 .47455 L
.38112 .48733 L
.38758 .49844 L
.39445 .50923 L
.40107 .51879 L
.40744 .52733 L
.41421 .5358 L
.42073 .54343 L
.42766 .55102 L
.43434 .5579 L
.44077 .56414 L
.4476 .57041 L
.45418 .57611 L
.46051 .58131 L
.46725 .58654 L
.47373 .59132 L
.48063 .59613 L
.48727 .60051 L
.49366 .6045 L
.5 .60826 L
.5 .60826 L
.49381 .61174 L
.48721 .61526 L
.48035 .61871 L
.4739 .62176 L
.4672 .62475 L
.46091 .62739 L
.45436 .62997 L
.44757 .63247 L
.44118 .63466 L
.43454 .63678 L
.42764 .63882 L
.42116 .64058 L
.41442 .64225 L
.40809 .64368 L
.40151 .64503 L
.39468 .64627 L
.38825 .6473 L
.38158 .64822 L
.37465 .64903 L
.36812 .64966 L
.36135 .65016 L
.3579 .65036 L
.35473 .65051 L
.35109 .65064 L
.34948 .65069 L
.34771 .65073 L
.34598 .65076 L
.34522 .65077 L
.3444 .65078 L
.34362 .65078 L
.34318 .65079 L
.34277 .65079 L
.34239 .65079 L
.34204 .65079 L
.34185 .65079 L
.34164 .65079 L
.34147 .65079 L
.34127 .65079 L
F
0 g
.34127 .3334 m
.34147 .34449 L
.34164 .34874 L
.34204 .3555 L
.34277 .36412 L
.34361 .37179 L
.3444 .37784 L
.34771 .39695 L
.35108 .41163 L
.35473 .4248 L
.36154 .44496 L
.3681 .46107 L
.37441 .47455 L
.38112 .48733 L
.38758 .49844 L
.39445 .50923 L
.40107 .51879 L
.40744 .52733 L
.41421 .5358 L
.42073 .54343 L
.42766 .55102 L
.43434 .5579 L
.44077 .56414 L
.4476 .57041 L
.45418 .57611 L
.46051 .58131 L
.46725 .58654 L
.47373 .59132 L
.48063 .59613 L
.48727 .60051 L
.49366 .6045 L
.5 .60826 L
s
.34127 .65079 m
.34147 .65079 L
.34164 .65079 L
.34185 .65079 L
.34204 .65079 L
.34239 .65079 L
.34277 .65079 L
.34318 .65079 L
.34362 .65078 L
.3444 .65078 L
.34522 .65077 L
.34598 .65076 L
.34771 .65073 L
.34948 .65069 L
.35109 .65064 L
.35473 .65051 L
.3579 .65036 L
.36135 .65016 L
.36812 .64966 L
.37465 .64903 L
.38158 .64822 L
.38825 .6473 L
.39468 .64627 L
.40151 .64503 L
.40809 .64368 L
.41442 .64225 L
.42116 .64058 L
.42764 .63882 L
.43454 .63678 L
.44118 .63466 L
.44757 .63247 L
.45436 .62997 L
.46091 .62739 L
.4672 .62475 L
.4739 .62176 L
.48035 .61871 L
.48721 .61526 L
.49381 .61174 L
.5 .60826 L
s
.5 .60826 m
.50644 .60444 L
.51346 .60004 L
.52006 .59566 L
.5264 .59122 L
.53315 .58624 L
.53965 .58118 L
.54656 .57549 L
.55321 .56968 L
.55961 .56378 L
.56643 .55713 L
.57298 .55033 L
.57929 .5434 L
.586 .53554 L
.59247 .52745 L
.59934 .51822 L
.60596 .50861 L
.61232 .4986 L
.6191 .48694 L
.62562 .4745 L
.63255 .45958 L
.63923 .44289 L
.64565 .42352 L
.64891 .41169 L
.65248 .396 L
.65404 .38768 L
.65571 .37699 L
.65652 .37069 L
.65729 .36352 L
.65798 .35513 L
.65817 .35219 L
.65837 .34845 L
.65854 .34428 L
.65873 .3334 L
s
.5 .60826 m
.50644 .61188 L
.51346 .61561 L
.52006 .6189 L
.5264 .6219 L
.53315 .6249 L
.53965 .62761 L
.54656 .63032 L
.55321 .63274 L
.55961 .63492 L
.56643 .63708 L
.57298 .63899 L
.57929 .64069 L
.586 .64235 L
.59247 .6438 L
.59934 .64519 L
.60596 .64638 L
.61232 .64738 L
.6191 .64831 L
.62562 .64906 L
.63255 .64971 L
.63923 .65019 L
.64229 .65037 L
.64565 .65052 L
.64897 .65064 L
.65079 .65069 L
.65248 .65073 L
.65329 .65075 L
.65416 .65076 L
.65493 .65077 L
.65575 .65078 L
.65649 .65079 L
.65691 .65079 L
.6573 .65079 L
.65766 .65079 L
.65799 .65079 L
.65816 .65079 L
.65835 .65079 L
.65855 .65079 L
.65873 .65079 L
s
0 1 1 r
.5 .60826 m
.50644 .60444 L
.51346 .60004 L
.52006 .59566 L
.5264 .59122 L
.53315 .58624 L
.53965 .58118 L
.54656 .57549 L
.55321 .56968 L
.55961 .56378 L
.56643 .55713 L
.57298 .55033 L
.57929 .5434 L
.586 .53554 L
.59247 .52745 L
.59934 .51822 L
.60596 .50861 L
.61232 .4986 L
.6191 .48694 L
.62562 .4745 L
.63255 .45958 L
.63923 .44289 L
.64565 .42352 L
.64891 .41169 L
.65248 .396 L
.65404 .38768 L
.65571 .37699 L
.65652 .37069 L
.65729 .36352 L
.65798 .35513 L
.65817 .35219 L
.65837 .34845 L
.65854 .34428 L
.65873 .3334 L
.65873 .65079 L
.65855 .65079 L
.65835 .65079 L
.65816 .65079 L
.65799 .65079 L
.65766 .65079 L
.6573 .65079 L
.65691 .65079 L
.65649 .65079 L
.65575 .65078 L
.65493 .65077 L
.65416 .65076 L
.65329 .65075 L
.65248 .65073 L
.65079 .65069 L
.64897 .65064 L
.64565 .65052 L
.64229 .65037 L
.63923 .65019 L
.63255 .64971 L
.62562 .64906 L
.6191 .64831 L
.61232 .64738 L
.60596 .64638 L
.59934 .64519 L
.59247 .6438 L
.586 .64235 L
.57929 .64069 L
.57298 .63899 L
.56643 .63708 L
.55961 .63492 L
.55321 .63274 L
.54656 .63032 L
.53965 .62761 L
.53315 .6249 L
.5264 .6219 L
.52006 .6189 L
.51346 .61561 L
.50644 .61188 L
.5 .60826 L
F
0 g
.5 .60826 m
.50644 .60444 L
.51346 .60004 L
.52006 .59566 L
.5264 .59122 L
.53315 .58624 L
.53965 .58118 L
.54656 .57549 L
.55321 .56968 L
.55961 .56378 L
.56643 .55713 L
.57298 .55033 L
.57929 .5434 L
.586 .53554 L
.59247 .52745 L
.59934 .51822 L
.60596 .50861 L
.61232 .4986 L
.6191 .48694 L
.62562 .4745 L
.63255 .45958 L
.63923 .44289 L
.64565 .42352 L
.64891 .41169 L
.65248 .396 L
.65404 .38768 L
.65571 .37699 L
.65652 .37069 L
.65729 .36352 L
.65798 .35513 L
.65817 .35219 L
.65837 .34845 L
.65854 .34428 L
.65873 .3334 L
s
.5 .60826 m
.50644 .61188 L
.51346 .61561 L
.52006 .6189 L
.5264 .6219 L
.53315 .6249 L
.53965 .62761 L
.54656 .63032 L
.55321 .63274 L
.55961 .63492 L
.56643 .63708 L
.57298 .63899 L
.57929 .64069 L
.586 .64235 L
.59247 .6438 L
.59934 .64519 L
.60596 .64638 L
.61232 .64738 L
.6191 .64831 L
.62562 .64906 L
.63255 .64971 L
.63923 .65019 L
.64229 .65037 L
.64565 .65052 L
.64897 .65064 L
.65079 .65069 L
.65248 .65073 L
.65329 .65075 L
.65416 .65076 L
.65493 .65077 L
.65575 .65078 L
.65649 .65079 L
.65691 .65079 L
.6573 .65079 L
.65766 .65079 L
.65799 .65079 L
.65816 .65079 L
.65835 .65079 L
.65855 .65079 L
.65873 .65079 L
s
.5 .0584 m
.50644 .05479 L
.51346 .05106 L
.52006 .04776 L
.5264 .04477 L
.53315 .04177 L
.53965 .03905 L
.54656 .03635 L
.55321 .03392 L
.55961 .03174 L
.56643 .02959 L
.57298 .02767 L
.57929 .02597 L
.586 .02432 L
.59247 .02287 L
.59934 .02148 L
.60596 .02029 L
.61232 .01928 L
.6191 .01836 L
.62562 .0176 L
.63255 .01695 L
.63923 .01647 L
.64229 .0163 L
.64565 .01614 L
.64897 .01602 L
.65079 .01597 L
.65248 .01593 L
.65329 .01592 L
.65416 .01591 L
.65493 .0159 L
.65575 .01589 L
.65649 .01588 L
.65691 .01588 L
.6573 .01588 L
.65766 .01587 L
.65799 .01587 L
.65816 .01587 L
.65835 .01587 L
.65855 .01587 L
.65873 .01587 L
s
.5 .0584 m
.50644 .06222 L
.51346 .06663 L
.52006 .071 L
.5264 .07544 L
.53315 .08043 L
.53965 .08549 L
.54656 .09118 L
.55321 .09698 L
.55961 .10288 L
.56643 .10953 L
.57298 .11633 L
.57929 .12327 L
.586 .13113 L
.59247 .13922 L
.59934 .14845 L
.60596 .15806 L
.61232 .16807 L
.6191 .17973 L
.62562 .19217 L
.63255 .20709 L
.63923 .22377 L
.64565 .24315 L
.64891 .25498 L
.65248 .27067 L
.65404 .27898 L
.65571 .28968 L
.65652 .29598 L
.65729 .30315 L
.65798 .31153 L
.65817 .31447 L
.65837 .31822 L
.65854 .32238 L
.65873 .33327 L
s
0 1 1 r
.5 .0584 m
.50644 .05479 L
.51346 .05106 L
.52006 .04776 L
.5264 .04477 L
.53315 .04177 L
.53965 .03905 L
.54656 .03635 L
.55321 .03392 L
.55961 .03174 L
.56643 .02959 L
.57298 .02767 L
.57929 .02597 L
.586 .02432 L
.59247 .02287 L
.59934 .02148 L
.60596 .02029 L
.61232 .01928 L
.6191 .01836 L
.62562 .0176 L
.63255 .01695 L
.63923 .01647 L
.64229 .0163 L
.64565 .01614 L
.64897 .01602 L
.65079 .01597 L
.65248 .01593 L
.65329 .01592 L
.65416 .01591 L
.65493 .0159 L
.65575 .01589 L
.65649 .01588 L
.65691 .01588 L
.6573 .01588 L
.65766 .01587 L
.65799 .01587 L
.65816 .01587 L
.65835 .01587 L
.65855 .01587 L
.65873 .01587 L
.65873 .33327 L
.65854 .32238 L
.65837 .31822 L
.65817 .31447 L
.65798 .31153 L
.65729 .30315 L
.65652 .29598 L
.65571 .28968 L
.65404 .27898 L
.65248 .27067 L
.64891 .25498 L
.64565 .24315 L
.63923 .22377 L
.63255 .20709 L
.62562 .19217 L
.6191 .17973 L
.61232 .16807 L
.60596 .15806 L
.59934 .14845 L
.59247 .13922 L
.586 .13113 L
.57929 .12327 L
.57298 .11633 L
.56643 .10953 L
.55961 .10288 L
.55321 .09698 L
.54656 .09118 L
.53965 .08549 L
.53315 .08043 L
.5264 .07544 L
.52006 .071 L
.51346 .06663 L
.50644 .06222 L
.5 .0584 L
F
0 g
.5 .0584 m
.50644 .05479 L
.51346 .05106 L
.52006 .04776 L
.5264 .04477 L
.53315 .04177 L
.53965 .03905 L
.54656 .03635 L
.55321 .03392 L
.55961 .03174 L
.56643 .02959 L
.57298 .02767 L
.57929 .02597 L
.586 .02432 L
.59247 .02287 L
.59934 .02148 L
.60596 .02029 L
.61232 .01928 L
.6191 .01836 L
.62562 .0176 L
.63255 .01695 L
.63923 .01647 L
.64229 .0163 L
.64565 .01614 L
.64897 .01602 L
.65079 .01597 L
.65248 .01593 L
.65329 .01592 L
.65416 .01591 L
.65493 .0159 L
.65575 .01589 L
.65649 .01588 L
.65691 .01588 L
.6573 .01588 L
.65766 .01587 L
.65799 .01587 L
.65816 .01587 L
.65835 .01587 L
.65855 .01587 L
.65873 .01587 L
s
.5 .0584 m
.50644 .06222 L
.51346 .06663 L
.52006 .071 L
.5264 .07544 L
.53315 .08043 L
.53965 .08549 L
.54656 .09118 L
.55321 .09698 L
.55961 .10288 L
.56643 .10953 L
.57298 .11633 L
.57929 .12327 L
.586 .13113 L
.59247 .13922 L
.59934 .14845 L
.60596 .15806 L
.61232 .16807 L
.6191 .17973 L
.62562 .19217 L
.63255 .20709 L
.63923 .22377 L
.64565 .24315 L
.64891 .25498 L
.65248 .27067 L
.65404 .27898 L
.65571 .28968 L
.65652 .29598 L
.65729 .30315 L
.65798 .31153 L
.65817 .31447 L
.65837 .31822 L
.65854 .32238 L
.65873 .33327 L
s
.65873 .01587 m
.65912 .01587 L
.65948 .01587 L
.65989 .01588 L
.66028 .01588 L
.66097 .01588 L
.66172 .01589 L
.66255 .0159 L
.66343 .01591 L
.665 .01593 L
.66662 .01597 L
.66814 .01601 L
.67161 .01613 L
.67514 .0163 L
.67837 .01648 L
.68565 .01702 L
.69198 .01762 L
.69889 .01842 L
.71244 .02045 L
.72548 .02297 L
.73934 .02628 L
.7527 .0301 L
.76555 .03438 L
.77922 .03963 L
.79238 .04538 L
.80504 .0516 L
.81851 .05901 L
.83148 .06699 L
.84527 .07646 L
.85855 .08665 L
.87133 .09757 L
.88492 .11058 L
.89801 .1247 L
.91059 .14008 L
.92399 .15893 L
.93689 .18033 L
.9506 .20846 L
.95744 .22586 L
.96381 .24554 L
.96689 .25705 L
.9698 .26993 L
.9714 .27841 L
.97315 .28947 L
.97392 .2954 L
.97473 .30292 L
.97543 .31131 L
.97582 .31802 L
.97619 .33324 L
s
.65873 .65079 m
.65912 .65079 L
.65948 .65079 L
.65989 .65079 L
.66028 .65079 L
.66097 .65079 L
.66172 .65078 L
.66255 .65077 L
.66343 .65076 L
.665 .65073 L
.66662 .6507 L
.66814 .65065 L
.67161 .65053 L
.67514 .65037 L
.67837 .65019 L
.68565 .64965 L
.69198 .64905 L
.69889 .64824 L
.71244 .64622 L
.72548 .6437 L
.73934 .64039 L
.7527 .63657 L
.76555 .63228 L
.77922 .62704 L
.79238 .62129 L
.80504 .61507 L
.81851 .60765 L
.83148 .59968 L
.84527 .59021 L
.85855 .58002 L
.87133 .5691 L
.88492 .55609 L
.89801 .54197 L
.91059 .52659 L
.92399 .50774 L
.93689 .48633 L
.9506 .4582 L
.95744 .44081 L
.96381 .42113 L
.96689 .40962 L
.9698 .39673 L
.9714 .38826 L
.97315 .37719 L
.97392 .37127 L
.97473 .36375 L
.97543 .35536 L
.97582 .34865 L
.97619 .33342 L
s
0 1 1 r
.65873 .01587 m
.65912 .01587 L
.65948 .01587 L
.65989 .01588 L
.66028 .01588 L
.66097 .01588 L
.66172 .01589 L
.66255 .0159 L
.66343 .01591 L
.665 .01593 L
.66662 .01597 L
.66814 .01601 L
.67161 .01613 L
.67514 .0163 L
.67837 .01648 L
.68565 .01702 L
.69198 .01762 L
.69889 .01842 L
.71244 .02045 L
.72548 .02297 L
.73934 .02628 L
.7527 .0301 L
.76555 .03438 L
.77922 .03963 L
.79238 .04538 L
.80504 .0516 L
.81851 .05901 L
.83148 .06699 L
.84527 .07646 L
.85855 .08665 L
.87133 .09757 L
.88492 .11058 L
.89801 .1247 L
.91059 .14008 L
.92399 .15893 L
.93689 .18033 L
.9506 .20846 L
.95744 .22586 L
.96381 .24554 L
.96689 .25705 L
.9698 .26993 L
.9714 .27841 L
.97315 .28947 L
.97392 .2954 L
.97473 .30292 L
.97543 .31131 L
.97582 .31802 L
.97619 .33324 L
.97619 .33342 L
.97582 .34865 L
.97543 .35536 L
.97473 .36375 L
.97392 .37127 L
.97315 .37719 L
.9714 .38826 L
.9698 .39673 L
.96689 .40962 L
.96381 .42113 L
.95744 .44081 L
.9506 .4582 L
.93689 .48633 L
.92399 .50774 L
.91059 .52659 L
.89801 .54197 L
.88492 .55609 L
.87133 .5691 L
.85855 .58002 L
.84527 .59021 L
.83148 .59968 L
.81851 .60765 L
.80504 .61507 L
.79238 .62129 L
.77922 .62704 L
.76555 .63228 L
.7527 .63657 L
.73934 .64039 L
.72548 .6437 L
.71244 .64622 L
.69889 .64824 L
.69198 .64905 L
.68565 .64965 L
.67837 .65019 L
.67514 .65037 L
.67161 .65053 L
.66814 .65065 L
.66662 .6507 L
.665 .65073 L
.66343 .65076 L
.66255 .65077 L
.66172 .65078 L
.66097 .65079 L
.66028 .65079 L
.65989 .65079 L
.65948 .65079 L
.65912 .65079 L
.65873 .65079 L
F
0 g
.65873 .01587 m
.65912 .01587 L
.65948 .01587 L
.65989 .01588 L
.66028 .01588 L
.66097 .01588 L
.66172 .01589 L
.66255 .0159 L
.66343 .01591 L
.665 .01593 L
.66662 .01597 L
.66814 .01601 L
.67161 .01613 L
.67514 .0163 L
.67837 .01648 L
.68565 .01702 L
.69198 .01762 L
.69889 .01842 L
.71244 .02045 L
.72548 .02297 L
.73934 .02628 L
.7527 .0301 L
.76555 .03438 L
.77922 .03963 L
.79238 .04538 L
.80504 .0516 L
.81851 .05901 L
.83148 .06699 L
.84527 .07646 L
.85855 .08665 L
.87133 .09757 L
.88492 .11058 L
.89801 .1247 L
.91059 .14008 L
.92399 .15893 L
.93689 .18033 L
.9506 .20846 L
.95744 .22586 L
.96381 .24554 L
.96689 .25705 L
.9698 .26993 L
.9714 .27841 L
.97315 .28947 L
.97392 .2954 L
.97473 .30292 L
.97543 .31131 L
.97582 .31802 L
.97619 .33324 L
s
.65873 .65079 m
.65912 .65079 L
.65948 .65079 L
.65989 .65079 L
.66028 .65079 L
.66097 .65079 L
.66172 .65078 L
.66255 .65077 L
.66343 .65076 L
.665 .65073 L
.66662 .6507 L
.66814 .65065 L
.67161 .65053 L
.67514 .65037 L
.67837 .65019 L
.68565 .64965 L
.69198 .64905 L
.69889 .64824 L
.71244 .64622 L
.72548 .6437 L
.73934 .64039 L
.7527 .63657 L
.76555 .63228 L
.77922 .62704 L
.79238 .62129 L
.80504 .61507 L
.81851 .60765 L
.83148 .59968 L
.84527 .59021 L
.85855 .58002 L
.87133 .5691 L
.88492 .55609 L
.89801 .54197 L
.91059 .52659 L
.92399 .50774 L
.93689 .48633 L
.9506 .4582 L
.95744 .44081 L
.96381 .42113 L
.96689 .40962 L
.9698 .39673 L
.9714 .38826 L
.97315 .37719 L
.97392 .37127 L
.97473 .36375 L
.97543 .35536 L
.97582 .34865 L
.97619 .33342 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.666667 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.31746 0.333333 0.31746 [
[.02381 .32083 -12 -9 ]
[.02381 .32083 12 0 ]
[.18254 .32083 -6 -9 ]
[.18254 .32083 6 0 ]
[.34127 .32083 -12 -9 ]
[.34127 .32083 12 0 ]
[.65873 .32083 -9 -9 ]
[.65873 .32083 9 0 ]
[.81746 .32083 -3 -9 ]
[.81746 .32083 3 0 ]
[.97619 .32083 -9 -9 ]
[.97619 .32083 9 0 ]
[.4875 .01587 -12 -4.5 ]
[.4875 .01587 0 4.5 ]
[.4875 .1746 -24 -4.5 ]
[.4875 .1746 0 4.5 ]
[.4875 .49206 -18 -4.5 ]
[.4875 .49206 0 4.5 ]
[.4875 .65079 -6 -4.5 ]
[.4875 .65079 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .66667 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .33333 m
.02381 .33958 L
s
[(-1.5)] .02381 .32083 0 1 Mshowa
.18254 .33333 m
.18254 .33958 L
s
[(-1)] .18254 .32083 0 1 Mshowa
.34127 .33333 m
.34127 .33958 L
s
[(-0.5)] .34127 .32083 0 1 Mshowa
.65873 .33333 m
.65873 .33958 L
s
[(0.5)] .65873 .32083 0 1 Mshowa
.81746 .33333 m
.81746 .33958 L
s
[(1)] .81746 .32083 0 1 Mshowa
.97619 .33333 m
.97619 .33958 L
s
[(1.5)] .97619 .32083 0 1 Mshowa
.125 Mabswid
.05556 .33333 m
.05556 .33708 L
s
.0873 .33333 m
.0873 .33708 L
s
.11905 .33333 m
.11905 .33708 L
s
.15079 .33333 m
.15079 .33708 L
s
.21429 .33333 m
.21429 .33708 L
s
.24603 .33333 m
.24603 .33708 L
s
.27778 .33333 m
.27778 .33708 L
s
.30952 .33333 m
.30952 .33708 L
s
.37302 .33333 m
.37302 .33708 L
s
.40476 .33333 m
.40476 .33708 L
s
.43651 .33333 m
.43651 .33708 L
s
.46825 .33333 m
.46825 .33708 L
s
.53175 .33333 m
.53175 .33708 L
s
.56349 .33333 m
.56349 .33708 L
s
.59524 .33333 m
.59524 .33708 L
s
.62698 .33333 m
.62698 .33708 L
s
.69048 .33333 m
.69048 .33708 L
s
.72222 .33333 m
.72222 .33708 L
s
.75397 .33333 m
.75397 .33708 L
s
.78571 .33333 m
.78571 .33708 L
s
.84921 .33333 m
.84921 .33708 L
s
.88095 .33333 m
.88095 .33708 L
s
.9127 .33333 m
.9127 .33708 L
s
.94444 .33333 m
.94444 .33708 L
s
.25 Mabswid
0 .33333 m
1 .33333 L
s
.5 .01587 m
.50625 .01587 L
s
[(-1)] .4875 .01587 1 0 Mshowa
.5 .1746 m
.50625 .1746 L
s
[(-0.5)] .4875 .1746 1 0 Mshowa
.5 .49206 m
.50625 .49206 L
s
[(0.5)] .4875 .49206 1 0 Mshowa
.5 .65079 m
.50625 .65079 L
s
[(1)] .4875 .65079 1 0 Mshowa
.125 Mabswid
.5 .04762 m
.50375 .04762 L
s
.5 .07937 m
.50375 .07937 L
s
.5 .11111 m
.50375 .11111 L
s
.5 .14286 m
.50375 .14286 L
s
.5 .20635 m
.50375 .20635 L
s
.5 .2381 m
.50375 .2381 L
s
.5 .26984 m
.50375 .26984 L
s
.5 .30159 m
.50375 .30159 L
s
.5 .36508 m
.50375 .36508 L
s
.5 .39683 m
.50375 .39683 L
s
.5 .42857 m
.50375 .42857 L
s
.5 .46032 m
.50375 .46032 L
s
.5 .52381 m
.50375 .52381 L
s
.5 .55556 m
.50375 .55556 L
s
.5 .5873 m
.50375 .5873 L
s
.5 .61905 m
.50375 .61905 L
s
.25 Mabswid
.5 0 m
.5 .66667 L
s
0 0 m
1 0 L
1 .66667 L
0 .66667 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.35.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.35.1"]
}, Open  ]],

Cell[TextData[{
 "This plots the region ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[LeftBracketingBar]", "\[LeftBracketingBar]"}], 
    StyleBox["x",
     "TI"], "\[RightBracketingBar]", "-", "\[LeftBracketingBar]", 
    StyleBox["y",
     "TI"], 
    RowBox[{"\[RightBracketingBar]", "\[RightBracketingBar]"}], 
    "\[LessEqual]", "1"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". The full region is an infinite x shaped figure. "
}], "MathCaption",
 CellTags->{"S5.35.1", "1.7"}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InequalityPlot", "[", " ", 
  RowBox[{
   RowBox[{
    RowBox[{"Abs", "[", " ", 
     RowBox[{
      RowBox[{"Abs", "[", "x", "]"}], " ", "-", " ", 
      RowBox[{"Abs", "[", "y", "]"}]}], "]"}], " ", "\[LessEqual]", " ", 
    "1"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", 
     RowBox[{"-", "2"}], ",", " ", "2"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"y", ",", " ", 
     RowBox[{"-", "2"}], ",", " ", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.35.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 1 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.5 0.238095 [
[.02381 .4875 -6 -9 ]
[.02381 .4875 6 0 ]
[.2619 .4875 -6 -9 ]
[.2619 .4875 6 0 ]
[.7381 .4875 -3 -9 ]
[.7381 .4875 3 0 ]
[.97619 .4875 -3 -9 ]
[.97619 .4875 3 0 ]
[.4875 .02381 -12 -4.5 ]
[.4875 .02381 0 4.5 ]
[.4875 .2619 -12 -4.5 ]
[.4875 .2619 0 4.5 ]
[.4875 .7381 -6 -4.5 ]
[.4875 .7381 0 4.5 ]
[.4875 .97619 -6 -4.5 ]
[.4875 .97619 0 4.5 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .5 m
.02381 .50625 L
s
[(-2)] .02381 .4875 0 1 Mshowa
.2619 .5 m
.2619 .50625 L
s
[(-1)] .2619 .4875 0 1 Mshowa
.7381 .5 m
.7381 .50625 L
s
[(1)] .7381 .4875 0 1 Mshowa
.97619 .5 m
.97619 .50625 L
s
[(2)] .97619 .4875 0 1 Mshowa
.125 Mabswid
.07143 .5 m
.07143 .50375 L
s
.11905 .5 m
.11905 .50375 L
s
.16667 .5 m
.16667 .50375 L
s
.21429 .5 m
.21429 .50375 L
s
.30952 .5 m
.30952 .50375 L
s
.35714 .5 m
.35714 .50375 L
s
.40476 .5 m
.40476 .50375 L
s
.45238 .5 m
.45238 .50375 L
s
.54762 .5 m
.54762 .50375 L
s
.59524 .5 m
.59524 .50375 L
s
.64286 .5 m
.64286 .50375 L
s
.69048 .5 m
.69048 .50375 L
s
.78571 .5 m
.78571 .50375 L
s
.83333 .5 m
.83333 .50375 L
s
.88095 .5 m
.88095 .50375 L
s
.92857 .5 m
.92857 .50375 L
s
.25 Mabswid
0 .5 m
1 .5 L
s
.5 .02381 m
.50625 .02381 L
s
[(-2)] .4875 .02381 1 0 Mshowa
.5 .2619 m
.50625 .2619 L
s
[(-1)] .4875 .2619 1 0 Mshowa
.5 .7381 m
.50625 .7381 L
s
[(1)] .4875 .7381 1 0 Mshowa
.5 .97619 m
.50625 .97619 L
s
[(2)] .4875 .97619 1 0 Mshowa
.125 Mabswid
.5 .07143 m
.50375 .07143 L
s
.5 .11905 m
.50375 .11905 L
s
.5 .16667 m
.50375 .16667 L
s
.5 .21429 m
.50375 .21429 L
s
.5 .30952 m
.50375 .30952 L
s
.5 .35714 m
.50375 .35714 L
s
.5 .40476 m
.50375 .40476 L
s
.5 .45238 m
.50375 .45238 L
s
.5 .54762 m
.50375 .54762 L
s
.5 .59524 m
.50375 .59524 L
s
.5 .64286 m
.50375 .64286 L
s
.5 .69048 m
.50375 .69048 L
s
.5 .78571 m
.50375 .78571 L
s
.5 .83333 m
.50375 .83333 L
s
.5 .88095 m
.50375 .88095 L
s
.5 .92857 m
.50375 .92857 L
s
.25 Mabswid
.5 0 m
.5 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 Mabswid
.02381 .02381 m
.03347 .02381 L
.044 .02381 L
.0539 .02381 L
.06341 .02381 L
.07354 .02381 L
.08328 .02381 L
.09365 .02381 L
.10363 .02381 L
.11323 .02381 L
.12345 .02381 L
.13329 .02381 L
.14275 .02381 L
.15282 .02381 L
.16251 .02381 L
.17282 .02381 L
.18274 .02381 L
.19229 .02381 L
.20245 .02381 L
.21224 .02381 L
.22263 .02381 L
.23265 .02381 L
.24229 .02381 L
.25254 .02381 L
.2619 .02381 L
s
.02381 .2619 m
.03347 .27156 L
.044 .2821 L
.0539 .29199 L
.06341 .3015 L
.07354 .31163 L
.08328 .32138 L
.09365 .33174 L
.10363 .34172 L
.11323 .35133 L
.12345 .36154 L
.13329 .37138 L
.14275 .38084 L
.15282 .39091 L
.16251 .40061 L
.17282 .41091 L
.18274 .42084 L
.19229 .43039 L
.20245 .44055 L
.21224 .45033 L
.22263 .46073 L
.23265 .47074 L
.24229 .48038 L
.25254 .49063 L
.2619 .5 L
s
0 1 1 r
.02381 .02381 m
.03347 .02381 L
.044 .02381 L
.0539 .02381 L
.06341 .02381 L
.07354 .02381 L
.08328 .02381 L
.09365 .02381 L
.10363 .02381 L
.11323 .02381 L
.12345 .02381 L
.13329 .02381 L
.14275 .02381 L
.15282 .02381 L
.16251 .02381 L
.17282 .02381 L
.18274 .02381 L
.19229 .02381 L
.20245 .02381 L
.21224 .02381 L
.22263 .02381 L
.23265 .02381 L
.24229 .02381 L
.25254 .02381 L
.2619 .02381 L
.2619 .5 L
.25254 .49063 L
.24229 .48038 L
.23265 .47074 L
.22263 .46073 L
.21224 .45033 L
.20245 .44055 L
.19229 .43039 L
.18274 .42084 L
.17282 .41091 L
.16251 .40061 L
.15282 .39091 L
.14275 .38084 L
.13329 .37138 L
.12345 .36154 L
.11323 .35133 L
.10363 .34172 L
.09365 .33174 L
.08328 .32138 L
.07354 .31163 L
.06341 .3015 L
.0539 .29199 L
.044 .2821 L
.03347 .27156 L
.02381 .2619 L
F
0 g
.02381 .02381 m
.03347 .02381 L
.044 .02381 L
.0539 .02381 L
.06341 .02381 L
.07354 .02381 L
.08328 .02381 L
.09365 .02381 L
.10363 .02381 L
.11323 .02381 L
.12345 .02381 L
.13329 .02381 L
.14275 .02381 L
.15282 .02381 L
.16251 .02381 L
.17282 .02381 L
.18274 .02381 L
.19229 .02381 L
.20245 .02381 L
.21224 .02381 L
.22263 .02381 L
.23265 .02381 L
.24229 .02381 L
.25254 .02381 L
.2619 .02381 L
s
.02381 .2619 m
.03347 .27156 L
.044 .2821 L
.0539 .29199 L
.06341 .3015 L
.07354 .31163 L
.08328 .32138 L
.09365 .33174 L
.10363 .34172 L
.11323 .35133 L
.12345 .36154 L
.13329 .37138 L
.14275 .38084 L
.15282 .39091 L
.16251 .40061 L
.17282 .41091 L
.18274 .42084 L
.19229 .43039 L
.20245 .44055 L
.21224 .45033 L
.22263 .46073 L
.23265 .47074 L
.24229 .48038 L
.25254 .49063 L
.2619 .5 L
s
.02381 .7381 m
.03347 .72844 L
.044 .7179 L
.0539 .70801 L
.06341 .6985 L
.07354 .68837 L
.08328 .67862 L
.09365 .66826 L
.10363 .65828 L
.11323 .64867 L
.12345 .63846 L
.13329 .62862 L
.14275 .61916 L
.15282 .60909 L
.16251 .59939 L
.17282 .58909 L
.18274 .57916 L
.19229 .56961 L
.20245 .55945 L
.21224 .54967 L
.22263 .53927 L
.23265 .52926 L
.24229 .51962 L
.25254 .50937 L
.2619 .5 L
s
.02381 .97619 m
.03347 .97619 L
.044 .97619 L
.0539 .97619 L
.06341 .97619 L
.07354 .97619 L
.08328 .97619 L
.09365 .97619 L
.10363 .97619 L
.11323 .97619 L
.12345 .97619 L
.13329 .97619 L
.14275 .97619 L
.15282 .97619 L
.16251 .97619 L
.17282 .97619 L
.18274 .97619 L
.19229 .97619 L
.20245 .97619 L
.21224 .97619 L
.22263 .97619 L
.23265 .97619 L
.24229 .97619 L
.25254 .97619 L
.2619 .97619 L
s
0 1 1 r
.02381 .7381 m
.03347 .72844 L
.044 .7179 L
.0539 .70801 L
.06341 .6985 L
.07354 .68837 L
.08328 .67862 L
.09365 .66826 L
.10363 .65828 L
.11323 .64867 L
.12345 .63846 L
.13329 .62862 L
.14275 .61916 L
.15282 .60909 L
.16251 .59939 L
.17282 .58909 L
.18274 .57916 L
.19229 .56961 L
.20245 .55945 L
.21224 .54967 L
.22263 .53927 L
.23265 .52926 L
.24229 .51962 L
.25254 .50937 L
.2619 .5 L
.2619 .97619 L
.25254 .97619 L
.24229 .97619 L
.23265 .97619 L
.22263 .97619 L
.21224 .97619 L
.20245 .97619 L
.19229 .97619 L
.18274 .97619 L
.17282 .97619 L
.16251 .97619 L
.15282 .97619 L
.14275 .97619 L
.13329 .97619 L
.12345 .97619 L
.11323 .97619 L
.10363 .97619 L
.09365 .97619 L
.08328 .97619 L
.07354 .97619 L
.06341 .97619 L
.0539 .97619 L
.044 .97619 L
.03347 .97619 L
.02381 .97619 L
F
0 g
.02381 .7381 m
.03347 .72844 L
.044 .7179 L
.0539 .70801 L
.06341 .6985 L
.07354 .68837 L
.08328 .67862 L
.09365 .66826 L
.10363 .65828 L
.11323 .64867 L
.12345 .63846 L
.13329 .62862 L
.14275 .61916 L
.15282 .60909 L
.16251 .59939 L
.17282 .58909 L
.18274 .57916 L
.19229 .56961 L
.20245 .55945 L
.21224 .54967 L
.22263 .53927 L
.23265 .52926 L
.24229 .51962 L
.25254 .50937 L
.2619 .5 L
s
.02381 .97619 m
.03347 .97619 L
.044 .97619 L
.0539 .97619 L
.06341 .97619 L
.07354 .97619 L
.08328 .97619 L
.09365 .97619 L
.10363 .97619 L
.11323 .97619 L
.12345 .97619 L
.13329 .97619 L
.14275 .97619 L
.15282 .97619 L
.16251 .97619 L
.17282 .97619 L
.18274 .97619 L
.19229 .97619 L
.20245 .97619 L
.21224 .97619 L
.22263 .97619 L
.23265 .97619 L
.24229 .97619 L
.25254 .97619 L
.2619 .97619 L
s
.7381 .02381 m
.74775 .02381 L
.75829 .02381 L
.76818 .02381 L
.77769 .02381 L
.78782 .02381 L
.79757 .02381 L
.80793 .02381 L
.81791 .02381 L
.82752 .02381 L
.83773 .02381 L
.84757 .02381 L
.85703 .02381 L
.8671 .02381 L
.8768 .02381 L
.8871 .02381 L
.89703 .02381 L
.90658 .02381 L
.91674 .02381 L
.92652 .02381 L
.93692 .02381 L
.94693 .02381 L
.95657 .02381 L
.96682 .02381 L
.97619 .02381 L
s
.7381 .5 m
.74775 .49034 L
.75829 .47981 L
.76818 .46991 L
.77769 .4604 L
.78782 .45027 L
.79757 .44052 L
.80793 .43016 L
.81791 .42018 L
.82752 .41058 L
.83773 .40036 L
.84757 .39052 L
.85703 .38106 L
.8671 .37099 L
.8768 .3613 L
.8871 .35099 L
.89703 .34107 L
.90658 .33152 L
.91674 .32136 L
.92652 .31157 L
.93692 .30118 L
.94693 .29116 L
.95657 .28152 L
.96682 .27127 L
.97619 .2619 L
s
0 1 1 r
.7381 .02381 m
.74775 .02381 L
.75829 .02381 L
.76818 .02381 L
.77769 .02381 L
.78782 .02381 L
.79757 .02381 L
.80793 .02381 L
.81791 .02381 L
.82752 .02381 L
.83773 .02381 L
.84757 .02381 L
.85703 .02381 L
.8671 .02381 L
.8768 .02381 L
.8871 .02381 L
.89703 .02381 L
.90658 .02381 L
.91674 .02381 L
.92652 .02381 L
.93692 .02381 L
.94693 .02381 L
.95657 .02381 L
.96682 .02381 L
.97619 .02381 L
.97619 .2619 L
.96682 .27127 L
.95657 .28152 L
.94693 .29116 L
.93692 .30118 L
.92652 .31157 L
.91674 .32136 L
.90658 .33152 L
.89703 .34107 L
.8871 .35099 L
.8768 .3613 L
.8671 .37099 L
.85703 .38106 L
.84757 .39052 L
.83773 .40036 L
.82752 .41058 L
.81791 .42018 L
.80793 .43016 L
.79757 .44052 L
.78782 .45027 L
.77769 .4604 L
.76818 .46991 L
.75829 .47981 L
.74775 .49034 L
.7381 .5 L
F
0 g
.7381 .02381 m
.74775 .02381 L
.75829 .02381 L
.76818 .02381 L
.77769 .02381 L
.78782 .02381 L
.79757 .02381 L
.80793 .02381 L
.81791 .02381 L
.82752 .02381 L
.83773 .02381 L
.84757 .02381 L
.85703 .02381 L
.8671 .02381 L
.8768 .02381 L
.8871 .02381 L
.89703 .02381 L
.90658 .02381 L
.91674 .02381 L
.92652 .02381 L
.93692 .02381 L
.94693 .02381 L
.95657 .02381 L
.96682 .02381 L
.97619 .02381 L
s
.7381 .5 m
.74775 .49034 L
.75829 .47981 L
.76818 .46991 L
.77769 .4604 L
.78782 .45027 L
.79757 .44052 L
.80793 .43016 L
.81791 .42018 L
.82752 .41058 L
.83773 .40036 L
.84757 .39052 L
.85703 .38106 L
.8671 .37099 L
.8768 .3613 L
.8871 .35099 L
.89703 .34107 L
.90658 .33152 L
.91674 .32136 L
.92652 .31157 L
.93692 .30118 L
.94693 .29116 L
.95657 .28152 L
.96682 .27127 L
.97619 .2619 L
s
.2619 .02381 m
.27156 .03347 L
.2821 .044 L
.29199 .0539 L
.3015 .06341 L
.31163 .07354 L
.32138 .08328 L
.33174 .09365 L
.34172 .10363 L
.35133 .11323 L
.36154 .12345 L
.37138 .13329 L
.38084 .14275 L
.39091 .15282 L
.40061 .16251 L
.41091 .17282 L
.42084 .18274 L
.43039 .19229 L
.44055 .20245 L
.45033 .21224 L
.46073 .22263 L
.47074 .23265 L
.48038 .24229 L
.49063 .25254 L
.5 .2619 L
s
.2619 .97619 m
.27156 .96653 L
.2821 .956 L
.29199 .9461 L
.3015 .93659 L
.31163 .92646 L
.32138 .91672 L
.33174 .90635 L
.34172 .89637 L
.35133 .88677 L
.36154 .87655 L
.37138 .86671 L
.38084 .85725 L
.39091 .84718 L
.40061 .83749 L
.41091 .82718 L
.42084 .81726 L
.43039 .80771 L
.44055 .79755 L
.45033 .78776 L
.46073 .77737 L
.47074 .76735 L
.48038 .75772 L
.49063 .74746 L
.5 .7381 L
s
0 1 1 r
.2619 .02381 m
.27156 .03347 L
.2821 .044 L
.29199 .0539 L
.3015 .06341 L
.31163 .07354 L
.32138 .08328 L
.33174 .09365 L
.34172 .10363 L
.35133 .11323 L
.36154 .12345 L
.37138 .13329 L
.38084 .14275 L
.39091 .15282 L
.40061 .16251 L
.41091 .17282 L
.42084 .18274 L
.43039 .19229 L
.44055 .20245 L
.45033 .21224 L
.46073 .22263 L
.47074 .23265 L
.48038 .24229 L
.49063 .25254 L
.5 .2619 L
.5 .7381 L
.49063 .74746 L
.48038 .75772 L
.47074 .76735 L
.46073 .77737 L
.45033 .78776 L
.44055 .79755 L
.43039 .80771 L
.42084 .81726 L
.41091 .82718 L
.40061 .83749 L
.39091 .84718 L
.38084 .85725 L
.37138 .86671 L
.36154 .87655 L
.35133 .88677 L
.34172 .89637 L
.33174 .90635 L
.32138 .91672 L
.31163 .92646 L
.3015 .93659 L
.29199 .9461 L
.2821 .956 L
.27156 .96653 L
.2619 .97619 L
F
0 g
.2619 .02381 m
.27156 .03347 L
.2821 .044 L
.29199 .0539 L
.3015 .06341 L
.31163 .07354 L
.32138 .08328 L
.33174 .09365 L
.34172 .10363 L
.35133 .11323 L
.36154 .12345 L
.37138 .13329 L
.38084 .14275 L
.39091 .15282 L
.40061 .16251 L
.41091 .17282 L
.42084 .18274 L
.43039 .19229 L
.44055 .20245 L
.45033 .21224 L
.46073 .22263 L
.47074 .23265 L
.48038 .24229 L
.49063 .25254 L
.5 .2619 L
s
.2619 .97619 m
.27156 .96653 L
.2821 .956 L
.29199 .9461 L
.3015 .93659 L
.31163 .92646 L
.32138 .91672 L
.33174 .90635 L
.34172 .89637 L
.35133 .88677 L
.36154 .87655 L
.37138 .86671 L
.38084 .85725 L
.39091 .84718 L
.40061 .83749 L
.41091 .82718 L
.42084 .81726 L
.43039 .80771 L
.44055 .79755 L
.45033 .78776 L
.46073 .77737 L
.47074 .76735 L
.48038 .75772 L
.49063 .74746 L
.5 .7381 L
s
.5 .2619 m
.50966 .25225 L
.52019 .24171 L
.53009 .23182 L
.5396 .22231 L
.54973 .21218 L
.55948 .20243 L
.56984 .19207 L
.57982 .18209 L
.58942 .17248 L
.59964 .16227 L
.60948 .15243 L
.61894 .14297 L
.62901 .1329 L
.6387 .1232 L
.64901 .1129 L
.65893 .10297 L
.66848 .09342 L
.67864 .08326 L
.68843 .07348 L
.69882 .06308 L
.70884 .05307 L
.71848 .04343 L
.72873 .03318 L
.7381 .02381 L
s
.5 .7381 m
.50966 .74775 L
.52019 .75829 L
.53009 .76818 L
.5396 .77769 L
.54973 .78782 L
.55948 .79757 L
.56984 .80793 L
.57982 .81791 L
.58942 .82752 L
.59964 .83773 L
.60948 .84757 L
.61894 .85703 L
.62901 .8671 L
.6387 .8768 L
.64901 .8871 L
.65893 .89703 L
.66848 .90658 L
.67864 .91674 L
.68843 .92652 L
.69882 .93692 L
.70884 .94693 L
.71848 .95657 L
.72873 .96682 L
.7381 .97619 L
s
0 1 1 r
.5 .2619 m
.50966 .25225 L
.52019 .24171 L
.53009 .23182 L
.5396 .22231 L
.54973 .21218 L
.55948 .20243 L
.56984 .19207 L
.57982 .18209 L
.58942 .17248 L
.59964 .16227 L
.60948 .15243 L
.61894 .14297 L
.62901 .1329 L
.6387 .1232 L
.64901 .1129 L
.65893 .10297 L
.66848 .09342 L
.67864 .08326 L
.68843 .07348 L
.69882 .06308 L
.70884 .05307 L
.71848 .04343 L
.72873 .03318 L
.7381 .02381 L
.7381 .97619 L
.72873 .96682 L
.71848 .95657 L
.70884 .94693 L
.69882 .93692 L
.68843 .92652 L
.67864 .91674 L
.66848 .90658 L
.65893 .89703 L
.64901 .8871 L
.6387 .8768 L
.62901 .8671 L
.61894 .85703 L
.60948 .84757 L
.59964 .83773 L
.58942 .82752 L
.57982 .81791 L
.56984 .80793 L
.55948 .79757 L
.54973 .78782 L
.5396 .77769 L
.53009 .76818 L
.52019 .75829 L
.50966 .74775 L
.5 .7381 L
F
0 g
.5 .2619 m
.50966 .25225 L
.52019 .24171 L
.53009 .23182 L
.5396 .22231 L
.54973 .21218 L
.55948 .20243 L
.56984 .19207 L
.57982 .18209 L
.58942 .17248 L
.59964 .16227 L
.60948 .15243 L
.61894 .14297 L
.62901 .1329 L
.6387 .1232 L
.64901 .1129 L
.65893 .10297 L
.66848 .09342 L
.67864 .08326 L
.68843 .07348 L
.69882 .06308 L
.70884 .05307 L
.71848 .04343 L
.72873 .03318 L
.7381 .02381 L
s
.5 .7381 m
.50966 .74775 L
.52019 .75829 L
.53009 .76818 L
.5396 .77769 L
.54973 .78782 L
.55948 .79757 L
.56984 .80793 L
.57982 .81791 L
.58942 .82752 L
.59964 .83773 L
.60948 .84757 L
.61894 .85703 L
.62901 .8671 L
.6387 .8768 L
.64901 .8871 L
.65893 .89703 L
.66848 .90658 L
.67864 .91674 L
.68843 .92652 L
.69882 .93692 L
.70884 .94693 L
.71848 .95657 L
.72873 .96682 L
.7381 .97619 L
s
.7381 .5 m
.74775 .50966 L
.75829 .52019 L
.76818 .53009 L
.77769 .5396 L
.78782 .54973 L
.79757 .55948 L
.80793 .56984 L
.81791 .57982 L
.82752 .58942 L
.83773 .59964 L
.84757 .60948 L
.85703 .61894 L
.8671 .62901 L
.8768 .6387 L
.8871 .64901 L
.89703 .65893 L
.90658 .66848 L
.91674 .67864 L
.92652 .68843 L
.93692 .69882 L
.94693 .70884 L
.95657 .71848 L
.96682 .72873 L
.97619 .7381 L
s
.7381 .97619 m
.74775 .97619 L
.75829 .97619 L
.76818 .97619 L
.77769 .97619 L
.78782 .97619 L
.79757 .97619 L
.80793 .97619 L
.81791 .97619 L
.82752 .97619 L
.83773 .97619 L
.84757 .97619 L
.85703 .97619 L
.8671 .97619 L
.8768 .97619 L
.8871 .97619 L
.89703 .97619 L
.90658 .97619 L
.91674 .97619 L
.92652 .97619 L
.93692 .97619 L
.94693 .97619 L
.95657 .97619 L
.96682 .97619 L
.97619 .97619 L
s
0 1 1 r
.7381 .5 m
.74775 .50966 L
.75829 .52019 L
.76818 .53009 L
.77769 .5396 L
.78782 .54973 L
.79757 .55948 L
.80793 .56984 L
.81791 .57982 L
.82752 .58942 L
.83773 .59964 L
.84757 .60948 L
.85703 .61894 L
.8671 .62901 L
.8768 .6387 L
.8871 .64901 L
.89703 .65893 L
.90658 .66848 L
.91674 .67864 L
.92652 .68843 L
.93692 .69882 L
.94693 .70884 L
.95657 .71848 L
.96682 .72873 L
.97619 .7381 L
.97619 .97619 L
.96682 .97619 L
.95657 .97619 L
.94693 .97619 L
.93692 .97619 L
.92652 .97619 L
.91674 .97619 L
.90658 .97619 L
.89703 .97619 L
.8871 .97619 L
.8768 .97619 L
.8671 .97619 L
.85703 .97619 L
.84757 .97619 L
.83773 .97619 L
.82752 .97619 L
.81791 .97619 L
.80793 .97619 L
.79757 .97619 L
.78782 .97619 L
.77769 .97619 L
.76818 .97619 L
.75829 .97619 L
.74775 .97619 L
.7381 .97619 L
F
0 g
.7381 .5 m
.74775 .50966 L
.75829 .52019 L
.76818 .53009 L
.77769 .5396 L
.78782 .54973 L
.79757 .55948 L
.80793 .56984 L
.81791 .57982 L
.82752 .58942 L
.83773 .59964 L
.84757 .60948 L
.85703 .61894 L
.8671 .62901 L
.8768 .6387 L
.8871 .64901 L
.89703 .65893 L
.90658 .66848 L
.91674 .67864 L
.92652 .68843 L
.93692 .69882 L
.94693 .70884 L
.95657 .71848 L
.96682 .72873 L
.97619 .7381 L
s
.7381 .97619 m
.74775 .97619 L
.75829 .97619 L
.76818 .97619 L
.77769 .97619 L
.78782 .97619 L
.79757 .97619 L
.80793 .97619 L
.81791 .97619 L
.82752 .97619 L
.83773 .97619 L
.84757 .97619 L
.85703 .97619 L
.8671 .97619 L
.8768 .97619 L
.8871 .97619 L
.89703 .97619 L
.90658 .97619 L
.91674 .97619 L
.92652 .97619 L
.93692 .97619 L
.94693 .97619 L
.95657 .97619 L
.96682 .97619 L
.97619 .97619 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 1 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.5 0.238095 [
[.02381 .4875 -6 -9 ]
[.02381 .4875 6 0 ]
[.2619 .4875 -6 -9 ]
[.2619 .4875 6 0 ]
[.7381 .4875 -3 -9 ]
[.7381 .4875 3 0 ]
[.97619 .4875 -3 -9 ]
[.97619 .4875 3 0 ]
[.4875 .02381 -12 -4.5 ]
[.4875 .02381 0 4.5 ]
[.4875 .2619 -12 -4.5 ]
[.4875 .2619 0 4.5 ]
[.4875 .7381 -6 -4.5 ]
[.4875 .7381 0 4.5 ]
[.4875 .97619 -6 -4.5 ]
[.4875 .97619 0 4.5 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .5 m
.02381 .50625 L
s
[(-2)] .02381 .4875 0 1 Mshowa
.2619 .5 m
.2619 .50625 L
s
[(-1)] .2619 .4875 0 1 Mshowa
.7381 .5 m
.7381 .50625 L
s
[(1)] .7381 .4875 0 1 Mshowa
.97619 .5 m
.97619 .50625 L
s
[(2)] .97619 .4875 0 1 Mshowa
.125 Mabswid
.07143 .5 m
.07143 .50375 L
s
.11905 .5 m
.11905 .50375 L
s
.16667 .5 m
.16667 .50375 L
s
.21429 .5 m
.21429 .50375 L
s
.30952 .5 m
.30952 .50375 L
s
.35714 .5 m
.35714 .50375 L
s
.40476 .5 m
.40476 .50375 L
s
.45238 .5 m
.45238 .50375 L
s
.54762 .5 m
.54762 .50375 L
s
.59524 .5 m
.59524 .50375 L
s
.64286 .5 m
.64286 .50375 L
s
.69048 .5 m
.69048 .50375 L
s
.78571 .5 m
.78571 .50375 L
s
.83333 .5 m
.83333 .50375 L
s
.88095 .5 m
.88095 .50375 L
s
.92857 .5 m
.92857 .50375 L
s
.25 Mabswid
0 .5 m
1 .5 L
s
.5 .02381 m
.50625 .02381 L
s
[(-2)] .4875 .02381 1 0 Mshowa
.5 .2619 m
.50625 .2619 L
s
[(-1)] .4875 .2619 1 0 Mshowa
.5 .7381 m
.50625 .7381 L
s
[(1)] .4875 .7381 1 0 Mshowa
.5 .97619 m
.50625 .97619 L
s
[(2)] .4875 .97619 1 0 Mshowa
.125 Mabswid
.5 .07143 m
.50375 .07143 L
s
.5 .11905 m
.50375 .11905 L
s
.5 .16667 m
.50375 .16667 L
s
.5 .21429 m
.50375 .21429 L
s
.5 .30952 m
.50375 .30952 L
s
.5 .35714 m
.50375 .35714 L
s
.5 .40476 m
.50375 .40476 L
s
.5 .45238 m
.50375 .45238 L
s
.5 .54762 m
.50375 .54762 L
s
.5 .59524 m
.50375 .59524 L
s
.5 .64286 m
.50375 .64286 L
s
.5 .69048 m
.50375 .69048 L
s
.5 .78571 m
.50375 .78571 L
s
.5 .83333 m
.50375 .83333 L
s
.5 .88095 m
.50375 .88095 L
s
.5 .92857 m
.50375 .92857 L
s
.25 Mabswid
.5 0 m
.5 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.35.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S5.35.1"]
}, Open  ]],

Cell[TextData[{
 "This is an array of various norm\[Hyphen]related regions. The center \
diagonal corresponds to the unit balls in ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[ScriptL]", "1"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[ScriptL]", "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[ScriptL]", "3"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[ScriptL]", "4"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " respectively or the regions ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[LeftBracketingBar]", 
    StyleBox["x",
     "TI"], 
    SuperscriptBox["\[RightBracketingBar]", 
     StyleBox["p",
      "TI"]], "+", "\[LeftBracketingBar]", 
    StyleBox["y",
     "TI"], 
    SuperscriptBox["\[RightBracketingBar]", 
     StyleBox["p",
      "TI"]], "\[LessEqual]", "1"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " for ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["p",
     "TI"], "=", "1", ",", "2", ",", "3"}], TraditionalForm]], 
  "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox["4", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.35.1", "1.8"}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", " ", 
  RowBox[{"GraphicsArray", "[", " ", "\[IndentingNewLine]", 
   RowBox[{"Table", "[", " ", 
    RowBox[{
     RowBox[{"InequalityPlot", "[", " ", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox[
          RowBox[{"Abs", "[", "x", "]"}], "p"], "+", 
         SuperscriptBox[
          RowBox[{"Abs", "[", "y", "]"}], "q"]}], "\[LessEqual]", "1"}], ",", 
       " ", 
       RowBox[{"{", 
        RowBox[{"x", ",", " ", 
         RowBox[{"-", "1"}], ",", " ", "1"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"y", ",", " ", 
         RowBox[{"-", "1"}], ",", " ", "1"}], "}"}], ",", " ", 
       RowBox[{"Ticks", "->", " ", "None"}], ",", " ", 
       RowBox[{"DisplayFunction", "->", " ", "Identity"}]}], "]"}], ",", " ", 
     
     RowBox[{"{", 
      RowBox[{"p", ",", " ", "1", ",", " ", "4"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"q", ",", " ", "1", ",", " ", "4"}], "}"}]}], " ", "]"}], 
   "\[IndentingNewLine]", "]"}], "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.35.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.238095 0.0238095 0.238095 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0238095 0.245293 0.245293 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 1 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.476191 0.5 0.476191 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .5 m
1 .5 L
s
.5 0 m
.5 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 Mabswid
.02381 .5 m
.06244 .36327 L
.10458 .25022 L
.14415 .17231 L
.18221 .11827 L
.20178 .09706 L
.22272 .07856 L
.24259 .06447 L
.26416 .05246 L
.28492 .04363 L
.30409 .03745 L
.32282 .03294 L
.33359 .03091 L
.34344 .02937 L
.36285 .02709 L
.37356 .02618 L
.38373 .0255 L
.39332 .02501 L
.40354 .02461 L
.41318 .02434 L
.42192 .02415 L
.4268 .02408 L
.43195 .02401 L
.4364 .02396 L
.44117 .02392 L
.4463 .02389 L
.4511 .02386 L
.45402 .02385 L
.45679 .02384 L
.45947 .02383 L
.46199 .02383 L
.46658 .02382 L
.46902 .02382 L
.47164 .02382 L
.47425 .02381 L
.47699 .02381 L
.47934 .02381 L
.48066 .02381 L
.4819 .02381 L
.48305 .02381 L
.4843 .02381 L
.4854 .02381 L
.48657 .02381 L
.48762 .02381 L
.48877 .02381 L
.48982 .02381 L
.49081 .02381 L
.49203 .02381 L
.4932 .02381 L
.49425 .02381 L
Mistroke
.49539 .02381 L
.49663 .02381 L
.49795 .02381 L
.49919 .02381 L
.50032 .02381 L
.50153 .02381 L
.50265 .02381 L
.50389 .02381 L
.50521 .02381 L
.50588 .02381 L
.5066 .02381 L
.50791 .02381 L
.50919 .02381 L
.51037 .02381 L
.51147 .02381 L
.5125 .02381 L
.51363 .02381 L
.51485 .02381 L
.51606 .02381 L
.51733 .02381 L
.5196 .02381 L
.52091 .02381 L
.5221 .02381 L
.52477 .02381 L
.52723 .02381 L
.52956 .02382 L
.53228 .02382 L
.53478 .02382 L
.53774 .02383 L
.54044 .02383 L
.54513 .02385 L
.55016 .02387 L
.55482 .02389 L
.55924 .02392 L
.56437 .02397 L
.56913 .02402 L
.57431 .02409 L
.57989 .02419 L
.5895 .0244 L
.59853 .02468 L
.60927 .02513 L
.61913 .02567 L
.62891 .02637 L
.63803 .02717 L
.64867 .02833 L
.65872 .02969 L
.67915 .03335 L
.69773 .03797 L
.71772 .04462 L
.73617 .05262 L
Mistroke
.75491 .06291 L
.77554 .07719 L
.79659 .09547 L
.81584 .11597 L
.85464 .17029 L
.89436 .24781 L
.93258 .34809 L
.97324 .48832 L
.97619 .5 L
Mfstroke
.02381 .5 m
.06244 .63673 L
.10458 .74978 L
.14415 .82769 L
.18221 .88173 L
.20178 .90294 L
.22272 .92144 L
.24259 .93553 L
.26416 .94754 L
.28492 .95637 L
.30409 .96255 L
.32282 .96706 L
.33359 .96909 L
.34344 .97063 L
.36285 .97291 L
.37356 .97382 L
.38373 .9745 L
.39332 .97499 L
.40354 .97539 L
.41318 .97566 L
.42192 .97585 L
.4268 .97592 L
.43195 .97599 L
.4364 .97604 L
.44117 .97608 L
.4463 .97611 L
.4511 .97614 L
.45402 .97615 L
.45679 .97616 L
.45947 .97617 L
.46199 .97617 L
.46658 .97618 L
.46902 .97618 L
.47164 .97618 L
.47425 .97619 L
.47699 .97619 L
.47934 .97619 L
.48066 .97619 L
.4819 .97619 L
.48305 .97619 L
.4843 .97619 L
.4854 .97619 L
.48657 .97619 L
.48762 .97619 L
.48877 .97619 L
.48982 .97619 L
.49081 .97619 L
.49203 .97619 L
.4932 .97619 L
.49425 .97619 L
Mistroke
.49539 .97619 L
.49663 .97619 L
.49795 .97619 L
.49919 .97619 L
.50032 .97619 L
.50153 .97619 L
.50265 .97619 L
.50389 .97619 L
.50521 .97619 L
.50588 .97619 L
.5066 .97619 L
.50791 .97619 L
.50919 .97619 L
.51037 .97619 L
.51147 .97619 L
.5125 .97619 L
.51363 .97619 L
.51485 .97619 L
.51606 .97619 L
.51733 .97619 L
.5196 .97619 L
.52091 .97619 L
.5221 .97619 L
.52477 .97619 L
.52723 .97619 L
.52956 .97618 L
.53228 .97618 L
.53478 .97618 L
.53774 .97617 L
.54044 .97617 L
.54513 .97615 L
.55016 .97613 L
.55482 .97611 L
.55924 .97608 L
.56437 .97603 L
.56913 .97598 L
.57431 .97591 L
.57989 .97581 L
.5895 .9756 L
.59853 .97532 L
.60927 .97487 L
.61913 .97433 L
.62891 .97363 L
.63803 .97283 L
.64867 .97167 L
.65872 .97031 L
.67915 .96665 L
.69773 .96203 L
.71772 .95538 L
.73617 .94738 L
Mistroke
.75491 .93709 L
.77554 .92281 L
.79659 .90453 L
.81584 .88403 L
.85464 .82971 L
.89436 .75219 L
.93258 .65191 L
.97324 .51168 L
.97619 .5 L
Mfstroke
0 1 1 r
.02381 .5 m
.06244 .36327 L
.10458 .25022 L
.14415 .17231 L
.18221 .11827 L
.20178 .09706 L
.22272 .07856 L
.24259 .06447 L
.26416 .05246 L
.28492 .04363 L
.30409 .03745 L
.32282 .03294 L
.33359 .03091 L
.34344 .02937 L
.36285 .02709 L
.37356 .02618 L
.38373 .0255 L
.39332 .02501 L
.40354 .02461 L
.41318 .02434 L
.42192 .02415 L
.4268 .02408 L
.43195 .02401 L
.4364 .02396 L
.44117 .02392 L
.4463 .02389 L
.4511 .02386 L
.45402 .02385 L
.45679 .02384 L
.45947 .02383 L
.46199 .02383 L
.46658 .02382 L
.46902 .02382 L
.47164 .02382 L
.47425 .02381 L
.47699 .02381 L
.47934 .02381 L
.48066 .02381 L
.4819 .02381 L
.48305 .02381 L
.4843 .02381 L
.4854 .02381 L
.48657 .02381 L
.48762 .02381 L
.48877 .02381 L
.48982 .02381 L
.49081 .02381 L
.49203 .02381 L
.4932 .02381 L
.49425 .02381 L
.49539 .02381 L
.49663 .02381 L
.49795 .02381 L
.49919 .02381 L
.50032 .02381 L
.50153 .02381 L
.50265 .02381 L
.50389 .02381 L
.50521 .02381 L
.50588 .02381 L
.5066 .02381 L
.50791 .02381 L
.50919 .02381 L
.51037 .02381 L
.51147 .02381 L
.5125 .02381 L
.51363 .02381 L
.51485 .02381 L
.51606 .02381 L
.51733 .02381 L
.5196 .02381 L
.52091 .02381 L
.5221 .02381 L
.52477 .02381 L
.52723 .02381 L
.52956 .02382 L
.53228 .02382 L
.53478 .02382 L
.53774 .02383 L
.54044 .02383 L
.54513 .02385 L
.55016 .02387 L
.55482 .02389 L
.55924 .02392 L
.56437 .02397 L
.56913 .02402 L
.57431 .02409 L
.57989 .02419 L
.5895 .0244 L
.59853 .02468 L
.60927 .02513 L
.61913 .02567 L
.62891 .02637 L
.63803 .02717 L
.64867 .02833 L
.65872 .02969 L
.67915 .03335 L
.69773 .03797 L
.71772 .04462 L
.73617 .05262 L
.75491 .06291 L
.77554 .07719 L
.79659 .09547 L
.81584 .11597 L
.85464 .17029 L
.89436 .24781 L
.93258 .34809 L
.97324 .48832 L
.97619 .5 L
.97619 .5 L
.97324 .51168 L
.93258 .65191 L
.89436 .75219 L
.85464 .82971 L
.81584 .88403 L
.79659 .90453 L
.77554 .92281 L
.75491 .93709 L
.73617 .94738 L
.71772 .95538 L
.69773 .96203 L
.67915 .96665 L
.65872 .97031 L
.64867 .97167 L
.63803 .97283 L
.62891 .97363 L
.61913 .97433 L
.60927 .97487 L
.59853 .97532 L
.5895 .9756 L
.57989 .97581 L
.57431 .97591 L
.56913 .97598 L
.56437 .97603 L
.55924 .97608 L
.55482 .97611 L
.55016 .97613 L
.54513 .97615 L
.54044 .97617 L
.53774 .97617 L
.53478 .97618 L
.53228 .97618 L
.52956 .97618 L
.52723 .97619 L
.52477 .97619 L
.5221 .97619 L
.52091 .97619 L
.5196 .97619 L
.51733 .97619 L
.51606 .97619 L
.51485 .97619 L
.51363 .97619 L
.5125 .97619 L
.51147 .97619 L
.51037 .97619 L
.50919 .97619 L
.50791 .97619 L
.5066 .97619 L
.50588 .97619 L
.50521 .97619 L
.50389 .97619 L
.50265 .97619 L
.50153 .97619 L
.50032 .97619 L
.49919 .97619 L
.49795 .97619 L
.49663 .97619 L
.49539 .97619 L
.49425 .97619 L
.4932 .97619 L
.49203 .97619 L
.49081 .97619 L
.48982 .97619 L
.48877 .97619 L
.48762 .97619 L
.48657 .97619 L
.4854 .97619 L
.4843 .97619 L
.48305 .97619 L
.4819 .97619 L
.48066 .97619 L
.47934 .97619 L
.47699 .97619 L
.47425 .97619 L
.47164 .97618 L
.46902 .97618 L
.46658 .97618 L
.46199 .97617 L
.45947 .97617 L
.45679 .97616 L
.45402 .97615 L
.4511 .97614 L
.4463 .97611 L
.44117 .97608 L
.4364 .97604 L
.43195 .97599 L
.4268 .97592 L
.42192 .97585 L
.41318 .97566 L
.40354 .97539 L
.39332 .97499 L
.38373 .9745 L
.37356 .97382 L
.36285 .97291 L
.34344 .97063 L
.33359 .96909 L
.32282 .96706 L
.30409 .96255 L
.28492 .95637 L
.26416 .94754 L
.24259 .93553 L
.22272 .92144 L
.20178 .90294 L
.18221 .88173 L
.14415 .82769 L
.10458 .74978 L
.06244 .63673 L
.02381 .5 L
F
0 g
.02381 .5 m
.06244 .36327 L
.10458 .25022 L
.14415 .17231 L
.18221 .11827 L
.20178 .09706 L
.22272 .07856 L
.24259 .06447 L
.26416 .05246 L
.28492 .04363 L
.30409 .03745 L
.32282 .03294 L
.33359 .03091 L
.34344 .02937 L
.36285 .02709 L
.37356 .02618 L
.38373 .0255 L
.39332 .02501 L
.40354 .02461 L
.41318 .02434 L
.42192 .02415 L
.4268 .02408 L
.43195 .02401 L
.4364 .02396 L
.44117 .02392 L
.4463 .02389 L
.4511 .02386 L
.45402 .02385 L
.45679 .02384 L
.45947 .02383 L
.46199 .02383 L
.46658 .02382 L
.46902 .02382 L
.47164 .02382 L
.47425 .02381 L
.47699 .02381 L
.47934 .02381 L
.48066 .02381 L
.4819 .02381 L
.48305 .02381 L
.4843 .02381 L
.4854 .02381 L
.48657 .02381 L
.48762 .02381 L
.48877 .02381 L
.48982 .02381 L
.49081 .02381 L
.49203 .02381 L
.4932 .02381 L
.49425 .02381 L
Mistroke
.49539 .02381 L
.49663 .02381 L
.49795 .02381 L
.49919 .02381 L
.50032 .02381 L
.50153 .02381 L
.50265 .02381 L
.50389 .02381 L
.50521 .02381 L
.50588 .02381 L
.5066 .02381 L
.50791 .02381 L
.50919 .02381 L
.51037 .02381 L
.51147 .02381 L
.5125 .02381 L
.51363 .02381 L
.51485 .02381 L
.51606 .02381 L
.51733 .02381 L
.5196 .02381 L
.52091 .02381 L
.5221 .02381 L
.52477 .02381 L
.52723 .02381 L
.52956 .02382 L
.53228 .02382 L
.53478 .02382 L
.53774 .02383 L
.54044 .02383 L
.54513 .02385 L
.55016 .02387 L
.55482 .02389 L
.55924 .02392 L
.56437 .02397 L
.56913 .02402 L
.57431 .02409 L
.57989 .02419 L
.5895 .0244 L
.59853 .02468 L
.60927 .02513 L
.61913 .02567 L
.62891 .02637 L
.63803 .02717 L
.64867 .02833 L
.65872 .02969 L
.67915 .03335 L
.69773 .03797 L
.71772 .04462 L
.73617 .05262 L
Mistroke
.75491 .06291 L
.77554 .07719 L
.79659 .09547 L
.81584 .11597 L
.85464 .17029 L
.89436 .24781 L
.93258 .34809 L
.97324 .48832 L
.97619 .5 L
Mfstroke
.02381 .5 m
.06244 .63673 L
.10458 .74978 L
.14415 .82769 L
.18221 .88173 L
.20178 .90294 L
.22272 .92144 L
.24259 .93553 L
.26416 .94754 L
.28492 .95637 L
.30409 .96255 L
.32282 .96706 L
.33359 .96909 L
.34344 .97063 L
.36285 .97291 L
.37356 .97382 L
.38373 .9745 L
.39332 .97499 L
.40354 .97539 L
.41318 .97566 L
.42192 .97585 L
.4268 .97592 L
.43195 .97599 L
.4364 .97604 L
.44117 .97608 L
.4463 .97611 L
.4511 .97614 L
.45402 .97615 L
.45679 .97616 L
.45947 .97617 L
.46199 .97617 L
.46658 .97618 L
.46902 .97618 L
.47164 .97618 L
.47425 .97619 L
.47699 .97619 L
.47934 .97619 L
.48066 .97619 L
.4819 .97619 L
.48305 .97619 L
.4843 .97619 L
.4854 .97619 L
.48657 .97619 L
.48762 .97619 L
.48877 .97619 L
.48982 .97619 L
.49081 .97619 L
.49203 .97619 L
.4932 .97619 L
.49425 .97619 L
Mistroke
.49539 .97619 L
.49663 .97619 L
.49795 .97619 L
.49919 .97619 L
.50032 .97619 L
.50153 .97619 L
.50265 .97619 L
.50389 .97619 L
.50521 .97619 L
.50588 .97619 L
.5066 .97619 L
.50791 .97619 L
.50919 .97619 L
.51037 .97619 L
.51147 .97619 L
.5125 .97619 L
.51363 .97619 L
.51485 .97619 L
.51606 .97619 L
.51733 .97619 L
.5196 .97619 L
.52091 .97619 L
.5221 .97619 L
.52477 .97619 L
.52723 .97619 L
.52956 .97618 L
.53228 .97618 L
.53478 .97618 L
.53774 .97617 L
.54044 .97617 L
.54513 .97615 L
.55016 .97613 L
.55482 .97611 L
.55924 .97608 L
.56437 .97603 L
.56913 .97598 L
.57431 .97591 L
.57989 .97581 L
.5895 .9756 L
.59853 .97532 L
.60927 .97487 L
.61913 .97433 L
.62891 .97363 L
.63803 .97283 L
.64867 .97167 L
.65872 .97031 L
.67915 .96665 L
.69773 .96203 L
.71772 .95538 L
.73617 .94738 L
Mistroke
.75491 .93709 L
.77554 .92281 L
.79659 .90453 L
.81584 .88403 L
.85464 .82971 L
.89436 .75219 L
.93258 .65191 L
.97324 .51168 L
.97619 .5 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 1 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.476191 0.5 0.476191 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .5 m
1 .5 L
s
.5 0 m
.5 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.267442 0.0238095 0.488926 0.245293 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 1 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.476191 0.5 0.476191 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .5 m
1 .5 L
s
.5 0 m
.5 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 Mabswid
.02381 .49973 m
.02499 .45277 L
.02605 .43483 L
.02729 .41903 L
.02846 .4066 L
.03279 .37108 L
.0375 .34197 L
.04262 .31627 L
.06244 .24483 L
.07308 .2167 L
.08435 .19156 L
.10458 .15512 L
.14241 .10674 L
.16182 .08881 L
.1827 .07332 L
.20241 .06163 L
.22393 .05151 L
.24452 .04396 L
.26364 .03849 L
.28416 .03397 L
.30277 .03087 L
.32201 .02848 L
.33194 .02752 L
.34283 .02664 L
.36277 .02545 L
.37366 .02499 L
.38383 .02465 L
.39429 .02439 L
.40419 .0242 L
.41308 .02407 L
.41806 .02402 L
.42274 .02397 L
.43214 .02391 L
.43714 .02388 L
.44252 .02386 L
.44786 .02384 L
.45348 .02383 L
.45828 .02382 L
.461 .02382 L
.46353 .02382 L
.46598 .02382 L
.46857 .02381 L
.47142 .02381 L
.47405 .02381 L
.47649 .02381 L
.47878 .02381 L
.48129 .02381 L
.4827 .02381 L
.48398 .02381 L
.48513 .02381 L
Mistroke
.48635 .02381 L
.4875 .02381 L
.48854 .02381 L
.48978 .02381 L
.49047 .02381 L
.49111 .02381 L
.49228 .02381 L
.49352 .02381 L
.4946 .02381 L
.49575 .02381 L
.49684 .02381 L
.49784 .02381 L
.499 .02381 L
.50027 .02381 L
.50147 .02381 L
.50257 .02381 L
.50375 .02381 L
.505 .02381 L
.50606 .02381 L
.50722 .02381 L
.50847 .02381 L
.50918 .02381 L
.50981 .02381 L
.51105 .02381 L
.51222 .02381 L
.51332 .02381 L
.51449 .02381 L
.51657 .02381 L
.51773 .02381 L
.51881 .02381 L
.52127 .02381 L
.52255 .02381 L
.52394 .02381 L
.52647 .02381 L
.52894 .02381 L
.53122 .02381 L
.53368 .02382 L
.53639 .02382 L
.53902 .02382 L
.54189 .02382 L
.5468 .02383 L
.55197 .02384 L
.55675 .02386 L
.56121 .02387 L
.56649 .0239 L
.57129 .02393 L
.57652 .02397 L
.58206 .02402 L
.59203 .02414 L
.60122 .0243 L
Mistroke
.61112 .02452 L
.62201 .02484 L
.63216 .02522 L
.64143 .02567 L
.65227 .02631 L
.66232 .02703 L
.68132 .02884 L
.70205 .03159 L
.72258 .03531 L
.7412 .03975 L
.76046 .04562 L
.78128 .05374 L
.80124 .0636 L
.82231 .07672 L
.8603 .10956 L
.87982 .13261 L
.90074 .16381 L
.922 .20521 L
.93176 .22888 L
.94212 .25864 L
.95054 .28774 L
.95982 .32794 L
.96389 .34986 L
.96827 .37867 L
.97028 .39489 L
.9724 .41555 L
.97421 .43879 L
.97524 .45745 L
.97619 .49973 L
Mfstroke
.02381 .50027 m
.02499 .54723 L
.02605 .56517 L
.02729 .58097 L
.02846 .5934 L
.03279 .62892 L
.0375 .65803 L
.04262 .68373 L
.06244 .75517 L
.07308 .7833 L
.08435 .80844 L
.10458 .84488 L
.14241 .89326 L
.16182 .91119 L
.1827 .92668 L
.20241 .93837 L
.22393 .94849 L
.24452 .95604 L
.26364 .96151 L
.28416 .96603 L
.30277 .96913 L
.32201 .97152 L
.33194 .97248 L
.34283 .97336 L
.36277 .97455 L
.37366 .97501 L
.38383 .97535 L
.39429 .97561 L
.40419 .9758 L
.41308 .97593 L
.41806 .97598 L
.42274 .97603 L
.43214 .97609 L
.43714 .97612 L
.44252 .97614 L
.44786 .97616 L
.45348 .97617 L
.45828 .97618 L
.461 .97618 L
.46353 .97618 L
.46598 .97618 L
.46857 .97619 L
.47142 .97619 L
.47405 .97619 L
.47649 .97619 L
.47878 .97619 L
.48129 .97619 L
.4827 .97619 L
.48398 .97619 L
.48513 .97619 L
Mistroke
.48635 .97619 L
.4875 .97619 L
.48854 .97619 L
.48978 .97619 L
.49047 .97619 L
.49111 .97619 L
.49228 .97619 L
.49352 .97619 L
.4946 .97619 L
.49575 .97619 L
.49684 .97619 L
.49784 .97619 L
.499 .97619 L
.50027 .97619 L
.50147 .97619 L
.50257 .97619 L
.50375 .97619 L
.505 .97619 L
.50606 .97619 L
.50722 .97619 L
.50847 .97619 L
.50918 .97619 L
.50981 .97619 L
.51105 .97619 L
.51222 .97619 L
.51332 .97619 L
.51449 .97619 L
.51657 .97619 L
.51773 .97619 L
.51881 .97619 L
.52127 .97619 L
.52255 .97619 L
.52394 .97619 L
.52647 .97619 L
.52894 .97619 L
.53122 .97619 L
.53368 .97618 L
.53639 .97618 L
.53902 .97618 L
.54189 .97618 L
.5468 .97617 L
.55197 .97616 L
.55675 .97614 L
.56121 .97613 L
.56649 .9761 L
.57129 .97607 L
.57652 .97603 L
.58206 .97598 L
.59203 .97586 L
.60122 .9757 L
Mistroke
.61112 .97548 L
.62201 .97516 L
.63216 .97478 L
.64143 .97433 L
.65227 .97369 L
.66232 .97297 L
.68132 .97116 L
.70205 .96841 L
.72258 .96469 L
.7412 .96025 L
.76046 .95438 L
.78128 .94626 L
.80124 .9364 L
.82231 .92328 L
.8603 .89044 L
.87982 .86739 L
.90074 .83619 L
.922 .79479 L
.93176 .77112 L
.94212 .74136 L
.95054 .71226 L
.95982 .67206 L
.96389 .65014 L
.96827 .62133 L
.97028 .60511 L
.9724 .58445 L
.97421 .56121 L
.97524 .54255 L
.97619 .50027 L
Mfstroke
0 1 1 r
.02381 .49973 m
.02499 .45277 L
.02605 .43483 L
.02729 .41903 L
.02846 .4066 L
.03279 .37108 L
.0375 .34197 L
.04262 .31627 L
.06244 .24483 L
.07308 .2167 L
.08435 .19156 L
.10458 .15512 L
.14241 .10674 L
.16182 .08881 L
.1827 .07332 L
.20241 .06163 L
.22393 .05151 L
.24452 .04396 L
.26364 .03849 L
.28416 .03397 L
.30277 .03087 L
.32201 .02848 L
.33194 .02752 L
.34283 .02664 L
.36277 .02545 L
.37366 .02499 L
.38383 .02465 L
.39429 .02439 L
.40419 .0242 L
.41308 .02407 L
.41806 .02402 L
.42274 .02397 L
.43214 .02391 L
.43714 .02388 L
.44252 .02386 L
.44786 .02384 L
.45348 .02383 L
.45828 .02382 L
.461 .02382 L
.46353 .02382 L
.46598 .02382 L
.46857 .02381 L
.47142 .02381 L
.47405 .02381 L
.47649 .02381 L
.47878 .02381 L
.48129 .02381 L
.4827 .02381 L
.48398 .02381 L
.48513 .02381 L
.48635 .02381 L
.4875 .02381 L
.48854 .02381 L
.48978 .02381 L
.49047 .02381 L
.49111 .02381 L
.49228 .02381 L
.49352 .02381 L
.4946 .02381 L
.49575 .02381 L
.49684 .02381 L
.49784 .02381 L
.499 .02381 L
.50027 .02381 L
.50147 .02381 L
.50257 .02381 L
.50375 .02381 L
.505 .02381 L
.50606 .02381 L
.50722 .02381 L
.50847 .02381 L
.50918 .02381 L
.50981 .02381 L
.51105 .02381 L
.51222 .02381 L
.51332 .02381 L
.51449 .02381 L
.51657 .02381 L
.51773 .02381 L
.51881 .02381 L
.52127 .02381 L
.52255 .02381 L
.52394 .02381 L
.52647 .02381 L
.52894 .02381 L
.53122 .02381 L
.53368 .02382 L
.53639 .02382 L
.53902 .02382 L
.54189 .02382 L
.5468 .02383 L
.55197 .02384 L
.55675 .02386 L
.56121 .02387 L
.56649 .0239 L
.57129 .02393 L
.57652 .02397 L
.58206 .02402 L
.59203 .02414 L
.60122 .0243 L
.61112 .02452 L
.62201 .02484 L
.63216 .02522 L
.64143 .02567 L
.65227 .02631 L
.66232 .02703 L
.68132 .02884 L
.70205 .03159 L
.72258 .03531 L
.7412 .03975 L
.76046 .04562 L
.78128 .05374 L
.80124 .0636 L
.82231 .07672 L
.8603 .10956 L
.87982 .13261 L
.90074 .16381 L
.922 .20521 L
.93176 .22888 L
.94212 .25864 L
.95054 .28774 L
.95982 .32794 L
.96389 .34986 L
.96827 .37867 L
.97028 .39489 L
.9724 .41555 L
.97421 .43879 L
.97524 .45745 L
.97619 .49973 L
.97619 .50027 L
.97524 .54255 L
.97421 .56121 L
.9724 .58445 L
.97028 .60511 L
.96827 .62133 L
.96389 .65014 L
.95982 .67206 L
.95054 .71226 L
.94212 .74136 L
.93176 .77112 L
.922 .79479 L
.90074 .83619 L
.87982 .86739 L
.8603 .89044 L
.82231 .92328 L
.80124 .9364 L
.78128 .94626 L
.76046 .95438 L
.7412 .96025 L
.72258 .96469 L
.70205 .96841 L
.68132 .97116 L
.66232 .97297 L
.65227 .97369 L
.64143 .97433 L
.63216 .97478 L
.62201 .97516 L
.61112 .97548 L
.60122 .9757 L
.59203 .97586 L
.58206 .97598 L
.57652 .97603 L
.57129 .97607 L
.56649 .9761 L
.56121 .97613 L
.55675 .97614 L
.55197 .97616 L
.5468 .97617 L
.54189 .97618 L
.53902 .97618 L
.53639 .97618 L
.53368 .97618 L
.53122 .97619 L
.52894 .97619 L
.52647 .97619 L
.52394 .97619 L
.52255 .97619 L
.52127 .97619 L
.51881 .97619 L
.51773 .97619 L
.51657 .97619 L
.51449 .97619 L
.51332 .97619 L
.51222 .97619 L
.51105 .97619 L
.50981 .97619 L
.50918 .97619 L
.50847 .97619 L
.50722 .97619 L
.50606 .97619 L
.505 .97619 L
.50375 .97619 L
.50257 .97619 L
.50147 .97619 L
.50027 .97619 L
.499 .97619 L
.49784 .97619 L
.49684 .97619 L
.49575 .97619 L
.4946 .97619 L
.49352 .97619 L
.49228 .97619 L
.49111 .97619 L
.49047 .97619 L
.48978 .97619 L
.48854 .97619 L
.4875 .97619 L
.48635 .97619 L
.48513 .97619 L
.48398 .97619 L
.4827 .97619 L
.48129 .97619 L
.47878 .97619 L
.47649 .97619 L
.47405 .97619 L
.47142 .97619 L
.46857 .97619 L
.46598 .97618 L
.46353 .97618 L
.461 .97618 L
.45828 .97618 L
.45348 .97617 L
.44786 .97616 L
.44252 .97614 L
.43714 .97612 L
.43214 .97609 L
.42274 .97603 L
.41806 .97598 L
.41308 .97593 L
.40419 .9758 L
.39429 .97561 L
.38383 .97535 L
.37366 .97501 L
.36277 .97455 L
.34283 .97336 L
.33194 .97248 L
.32201 .97152 L
.30277 .96913 L
.28416 .96603 L
.26364 .96151 L
.24452 .95604 L
.22393 .94849 L
.20241 .93837 L
.1827 .92668 L
.16182 .91119 L
.14241 .89326 L
.10458 .84488 L
.08435 .80844 L
.07308 .7833 L
.06244 .75517 L
.04262 .68373 L
.0375 .65803 L
.03279 .62892 L
.02846 .5934 L
.02729 .58097 L
.02605 .56517 L
.02499 .54723 L
.02381 .50027 L
F
0 g
.02381 .49973 m
.02499 .45277 L
.02605 .43483 L
.02729 .41903 L
.02846 .4066 L
.03279 .37108 L
.0375 .34197 L
.04262 .31627 L
.06244 .24483 L
.07308 .2167 L
.08435 .19156 L
.10458 .15512 L
.14241 .10674 L
.16182 .08881 L
.1827 .07332 L
.20241 .06163 L
.22393 .05151 L
.24452 .04396 L
.26364 .03849 L
.28416 .03397 L
.30277 .03087 L
.32201 .02848 L
.33194 .02752 L
.34283 .02664 L
.36277 .02545 L
.37366 .02499 L
.38383 .02465 L
.39429 .02439 L
.40419 .0242 L
.41308 .02407 L
.41806 .02402 L
.42274 .02397 L
.43214 .02391 L
.43714 .02388 L
.44252 .02386 L
.44786 .02384 L
.45348 .02383 L
.45828 .02382 L
.461 .02382 L
.46353 .02382 L
.46598 .02382 L
.46857 .02381 L
.47142 .02381 L
.47405 .02381 L
.47649 .02381 L
.47878 .02381 L
.48129 .02381 L
.4827 .02381 L
.48398 .02381 L
.48513 .02381 L
Mistroke
.48635 .02381 L
.4875 .02381 L
.48854 .02381 L
.48978 .02381 L
.49047 .02381 L
.49111 .02381 L
.49228 .02381 L
.49352 .02381 L
.4946 .02381 L
.49575 .02381 L
.49684 .02381 L
.49784 .02381 L
.499 .02381 L
.50027 .02381 L
.50147 .02381 L
.50257 .02381 L
.50375 .02381 L
.505 .02381 L
.50606 .02381 L
.50722 .02381 L
.50847 .02381 L
.50918 .02381 L
.50981 .02381 L
.51105 .02381 L
.51222 .02381 L
.51332 .02381 L
.51449 .02381 L
.51657 .02381 L
.51773 .02381 L
.51881 .02381 L
.52127 .02381 L
.52255 .02381 L
.52394 .02381 L
.52647 .02381 L
.52894 .02381 L
.53122 .02381 L
.53368 .02382 L
.53639 .02382 L
.53902 .02382 L
.54189 .02382 L
.5468 .02383 L
.55197 .02384 L
.55675 .02386 L
.56121 .02387 L
.56649 .0239 L
.57129 .02393 L
.57652 .02397 L
.58206 .02402 L
.59203 .02414 L
.60122 .0243 L
Mistroke
.61112 .02452 L
.62201 .02484 L
.63216 .02522 L
.64143 .02567 L
.65227 .02631 L
.66232 .02703 L
.68132 .02884 L
.70205 .03159 L
.72258 .03531 L
.7412 .03975 L
.76046 .04562 L
.78128 .05374 L
.80124 .0636 L
.82231 .07672 L
.8603 .10956 L
.87982 .13261 L
.90074 .16381 L
.922 .20521 L
.93176 .22888 L
.94212 .25864 L
.95054 .28774 L
.95982 .32794 L
.96389 .34986 L
.96827 .37867 L
.97028 .39489 L
.9724 .41555 L
.97421 .43879 L
.97524 .45745 L
.97619 .49973 L
Mfstroke
.02381 .50027 m
.02499 .54723 L
.02605 .56517 L
.02729 .58097 L
.02846 .5934 L
.03279 .62892 L
.0375 .65803 L
.04262 .68373 L
.06244 .75517 L
.07308 .7833 L
.08435 .80844 L
.10458 .84488 L
.14241 .89326 L
.16182 .91119 L
.1827 .92668 L
.20241 .93837 L
.22393 .94849 L
.24452 .95604 L
.26364 .96151 L
.28416 .96603 L
.30277 .96913 L
.32201 .97152 L
.33194 .97248 L
.34283 .97336 L
.36277 .97455 L
.37366 .97501 L
.38383 .97535 L
.39429 .97561 L
.40419 .9758 L
.41308 .97593 L
.41806 .97598 L
.42274 .97603 L
.43214 .97609 L
.43714 .97612 L
.44252 .97614 L
.44786 .97616 L
.45348 .97617 L
.45828 .97618 L
.461 .97618 L
.46353 .97618 L
.46598 .97618 L
.46857 .97619 L
.47142 .97619 L
.47405 .97619 L
.47649 .97619 L
.47878 .97619 L
.48129 .97619 L
.4827 .97619 L
.48398 .97619 L
.48513 .97619 L
Mistroke
.48635 .97619 L
.4875 .97619 L
.48854 .97619 L
.48978 .97619 L
.49047 .97619 L
.49111 .97619 L
.49228 .97619 L
.49352 .97619 L
.4946 .97619 L
.49575 .97619 L
.49684 .97619 L
.49784 .97619 L
.499 .97619 L
.50027 .97619 L
.50147 .97619 L
.50257 .97619 L
.50375 .97619 L
.505 .97619 L
.50606 .97619 L
.50722 .97619 L
.50847 .97619 L
.50918 .97619 L
.50981 .97619 L
.51105 .97619 L
.51222 .97619 L
.51332 .97619 L
.51449 .97619 L
.51657 .97619 L
.51773 .97619 L
.51881 .97619 L
.52127 .97619 L
.52255 .97619 L
.52394 .97619 L
.52647 .97619 L
.52894 .97619 L
.53122 .97619 L
.53368 .97618 L
.53639 .97618 L
.53902 .97618 L
.54189 .97618 L
.5468 .97617 L
.55197 .97616 L
.55675 .97614 L
.56121 .97613 L
.56649 .9761 L
.57129 .97607 L
.57652 .97603 L
.58206 .97598 L
.59203 .97586 L
.60122 .9757 L
Mistroke
.61112 .97548 L
.62201 .97516 L
.63216 .97478 L
.64143 .97433 L
.65227 .97369 L
.66232 .97297 L
.68132 .97116 L
.70205 .96841 L
.72258 .96469 L
.7412 .96025 L
.76046 .95438 L
.78128 .94626 L
.80124 .9364 L
.82231 .92328 L
.8603 .89044 L
.87982 .86739 L
.90074 .83619 L
.922 .79479 L
.93176 .77112 L
.94212 .74136 L
.95054 .71226 L
.95982 .67206 L
.96389 .65014 L
.96827 .62133 L
.97028 .60511 L
.9724 .58445 L
.97421 .56121 L
.97524 .54255 L
.97619 .50027 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 1 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.476191 0.5 0.476191 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .5 m
1 .5 L
s
.5 0 m
.5 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.511074 0.0238095 0.732558 0.245293 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 1 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.476191 0.5 0.476191 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .5 m
1 .5 L
s
.5 0 m
.5 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 Mabswid
.02381 .4967 m
.02499 .39796 L
.02605 .37354 L
.02729 .35385 L
.02846 .33925 L
.03279 .30072 L
.03524 .28457 L
.0375 .27174 L
.04262 .24762 L
.05224 .21328 L
.06244 .18585 L
.0825 .1465 L
.10458 .11596 L
.12399 .09587 L
.14487 .07908 L
.166 .06582 L
.18609 .0559 L
.20612 .04805 L
.22428 .04236 L
.24396 .03746 L
.26493 .03343 L
.28418 .0306 L
.305 .02832 L
.32494 .02673 L
.33498 .02611 L
.346 .02555 L
.36551 .02482 L
.37645 .02453 L
.38642 .02432 L
.39634 .02417 L
.40551 .02406 L
.41558 .02397 L
.42066 .02393 L
.42627 .0239 L
.43119 .02388 L
.43636 .02386 L
.44084 .02385 L
.44562 .02384 L
.45078 .02383 L
.45558 .02382 L
.45851 .02382 L
.46129 .02382 L
.46397 .02381 L
.46647 .02381 L
.46889 .02381 L
.4711 .02381 L
.47356 .02381 L
.47619 .02381 L
.47872 .02381 L
.48015 .02381 L
Mistroke
.48147 .02381 L
.4839 .02381 L
.48526 .02381 L
.48649 .02381 L
.48765 .02381 L
.48887 .02381 L
.48991 .02381 L
.49106 .02381 L
.49229 .02381 L
.49361 .02381 L
.49486 .02381 L
.49599 .02381 L
.49714 .02381 L
.4982 .02381 L
.49936 .02381 L
.50059 .02381 L
.50166 .02381 L
.50266 .02381 L
.50376 .02381 L
.50494 .02381 L
.5062 .02381 L
.50735 .02381 L
.50867 .02381 L
.50991 .02381 L
.51107 .02381 L
.51213 .02381 L
.5133 .02381 L
.51454 .02381 L
.51578 .02381 L
.51712 .02381 L
.51953 .02381 L
.521 .02381 L
.5224 .02381 L
.52502 .02381 L
.52756 .02381 L
.53027 .02381 L
.53258 .02381 L
.53513 .02381 L
.53786 .02382 L
.5408 .02382 L
.54613 .02382 L
.55108 .02383 L
.55569 .02384 L
.56074 .02385 L
.56615 .02387 L
.57183 .02389 L
.57719 .02392 L
.58724 .02399 L
.59694 .02408 L
.60723 .02422 L
Mistroke
.61601 .02437 L
.62567 .02458 L
.6451 .02518 L
.656 .02565 L
.66598 .02616 L
.68498 .02745 L
.70571 .0294 L
.7254 .03191 L
.74637 .03547 L
.7678 .04025 L
.78798 .04606 L
.80807 .05342 L
.82655 .06187 L
.84698 .07358 L
.86605 .08733 L
.88439 .10393 L
.90405 .12672 L
.91423 .1413 L
.9253 .16009 L
.93487 .17965 L
.94543 .20638 L
.95312 .23107 L
.96035 .2609 L
.96433 .28196 L
.96797 .30635 L
.97005 .32386 L
.97198 .34435 L
.97303 .35845 L
.97399 .37438 L
.97505 .39911 L
.97619 .4967 L
Mfstroke
.02381 .5033 m
.02499 .60204 L
.02605 .62646 L
.02729 .64615 L
.02846 .66075 L
.03279 .69928 L
.03524 .71543 L
.0375 .72826 L
.04262 .75238 L
.05224 .78672 L
.06244 .81415 L
.0825 .8535 L
.10458 .88404 L
.12399 .90413 L
.14487 .92092 L
.166 .93418 L
.18609 .9441 L
.20612 .95195 L
.22428 .95764 L
.24396 .96254 L
.26493 .96657 L
.28418 .9694 L
.305 .97168 L
.32494 .97327 L
.33498 .97389 L
.346 .97445 L
.36551 .97518 L
.37645 .97547 L
.38642 .97568 L
.39634 .97583 L
.40551 .97594 L
.41558 .97603 L
.42066 .97607 L
.42627 .9761 L
.43119 .97612 L
.43636 .97614 L
.44084 .97615 L
.44562 .97616 L
.45078 .97617 L
.45558 .97618 L
.45851 .97618 L
.46129 .97618 L
.46397 .97619 L
.46647 .97619 L
.46889 .97619 L
.4711 .97619 L
.47356 .97619 L
.47619 .97619 L
.47872 .97619 L
.48015 .97619 L
Mistroke
.48147 .97619 L
.4839 .97619 L
.48526 .97619 L
.48649 .97619 L
.48765 .97619 L
.48887 .97619 L
.48991 .97619 L
.49106 .97619 L
.49229 .97619 L
.49361 .97619 L
.49486 .97619 L
.49599 .97619 L
.49714 .97619 L
.4982 .97619 L
.49936 .97619 L
.50059 .97619 L
.50166 .97619 L
.50266 .97619 L
.50376 .97619 L
.50494 .97619 L
.5062 .97619 L
.50735 .97619 L
.50867 .97619 L
.50991 .97619 L
.51107 .97619 L
.51213 .97619 L
.5133 .97619 L
.51454 .97619 L
.51578 .97619 L
.51712 .97619 L
.51953 .97619 L
.521 .97619 L
.5224 .97619 L
.52502 .97619 L
.52756 .97619 L
.53027 .97619 L
.53258 .97619 L
.53513 .97619 L
.53786 .97618 L
.5408 .97618 L
.54613 .97618 L
.55108 .97617 L
.55569 .97616 L
.56074 .97615 L
.56615 .97613 L
.57183 .97611 L
.57719 .97608 L
.58724 .97601 L
.59694 .97592 L
.60723 .97578 L
Mistroke
.61601 .97563 L
.62567 .97542 L
.6451 .97482 L
.656 .97436 L
.66598 .97384 L
.68498 .97255 L
.70571 .9706 L
.7254 .96809 L
.74637 .96453 L
.7678 .95975 L
.78798 .95394 L
.80807 .94658 L
.82655 .93813 L
.84698 .92642 L
.86605 .91267 L
.88439 .89607 L
.90405 .87328 L
.91423 .8587 L
.9253 .83991 L
.93487 .82035 L
.94543 .79362 L
.95312 .76893 L
.96035 .7391 L
.96433 .71804 L
.96797 .69365 L
.97005 .67614 L
.97198 .65565 L
.97303 .64155 L
.97399 .62562 L
.97505 .60089 L
.97619 .5033 L
Mfstroke
0 1 1 r
.02381 .4967 m
.02499 .39796 L
.02605 .37354 L
.02729 .35385 L
.02846 .33925 L
.03279 .30072 L
.03524 .28457 L
.0375 .27174 L
.04262 .24762 L
.05224 .21328 L
.06244 .18585 L
.0825 .1465 L
.10458 .11596 L
.12399 .09587 L
.14487 .07908 L
.166 .06582 L
.18609 .0559 L
.20612 .04805 L
.22428 .04236 L
.24396 .03746 L
.26493 .03343 L
.28418 .0306 L
.305 .02832 L
.32494 .02673 L
.33498 .02611 L
.346 .02555 L
.36551 .02482 L
.37645 .02453 L
.38642 .02432 L
.39634 .02417 L
.40551 .02406 L
.41558 .02397 L
.42066 .02393 L
.42627 .0239 L
.43119 .02388 L
.43636 .02386 L
.44084 .02385 L
.44562 .02384 L
.45078 .02383 L
.45558 .02382 L
.45851 .02382 L
.46129 .02382 L
.46397 .02381 L
.46647 .02381 L
.46889 .02381 L
.4711 .02381 L
.47356 .02381 L
.47619 .02381 L
.47872 .02381 L
.48015 .02381 L
.48147 .02381 L
.4839 .02381 L
.48526 .02381 L
.48649 .02381 L
.48765 .02381 L
.48887 .02381 L
.48991 .02381 L
.49106 .02381 L
.49229 .02381 L
.49361 .02381 L
.49486 .02381 L
.49599 .02381 L
.49714 .02381 L
.4982 .02381 L
.49936 .02381 L
.50059 .02381 L
.50166 .02381 L
.50266 .02381 L
.50376 .02381 L
.50494 .02381 L
.5062 .02381 L
.50735 .02381 L
.50867 .02381 L
.50991 .02381 L
.51107 .02381 L
.51213 .02381 L
.5133 .02381 L
.51454 .02381 L
.51578 .02381 L
.51712 .02381 L
.51953 .02381 L
.521 .02381 L
.5224 .02381 L
.52502 .02381 L
.52756 .02381 L
.53027 .02381 L
.53258 .02381 L
.53513 .02381 L
.53786 .02382 L
.5408 .02382 L
.54613 .02382 L
.55108 .02383 L
.55569 .02384 L
.56074 .02385 L
.56615 .02387 L
.57183 .02389 L
.57719 .02392 L
.58724 .02399 L
.59694 .02408 L
.60723 .02422 L
.61601 .02437 L
.62567 .02458 L
.6451 .02518 L
.656 .02565 L
.66598 .02616 L
.68498 .02745 L
.70571 .0294 L
.7254 .03191 L
.74637 .03547 L
.7678 .04025 L
.78798 .04606 L
.80807 .05342 L
.82655 .06187 L
.84698 .07358 L
.86605 .08733 L
.88439 .10393 L
.90405 .12672 L
.91423 .1413 L
.9253 .16009 L
.93487 .17965 L
.94543 .20638 L
.95312 .23107 L
.96035 .2609 L
.96433 .28196 L
.96797 .30635 L
.97005 .32386 L
.97198 .34435 L
.97303 .35845 L
.97399 .37438 L
.97505 .39911 L
.97619 .4967 L
.97619 .5033 L
.97505 .60089 L
.97399 .62562 L
.97303 .64155 L
.97198 .65565 L
.97005 .67614 L
.96797 .69365 L
.96433 .71804 L
.96035 .7391 L
.95312 .76893 L
.94543 .79362 L
.93487 .82035 L
.9253 .83991 L
.91423 .8587 L
.90405 .87328 L
.88439 .89607 L
.86605 .91267 L
.84698 .92642 L
.82655 .93813 L
.80807 .94658 L
.78798 .95394 L
.7678 .95975 L
.74637 .96453 L
.7254 .96809 L
.70571 .9706 L
.68498 .97255 L
.66598 .97384 L
.656 .97436 L
.6451 .97482 L
.62567 .97542 L
.61601 .97563 L
.60723 .97578 L
.59694 .97592 L
.58724 .97601 L
.57719 .97608 L
.57183 .97611 L
.56615 .97613 L
.56074 .97615 L
.55569 .97616 L
.55108 .97617 L
.54613 .97618 L
.5408 .97618 L
.53786 .97618 L
.53513 .97619 L
.53258 .97619 L
.53027 .97619 L
.52756 .97619 L
.52502 .97619 L
.5224 .97619 L
.521 .97619 L
.51953 .97619 L
.51712 .97619 L
.51578 .97619 L
.51454 .97619 L
.5133 .97619 L
.51213 .97619 L
.51107 .97619 L
.50991 .97619 L
.50867 .97619 L
.50735 .97619 L
.5062 .97619 L
.50494 .97619 L
.50376 .97619 L
.50266 .97619 L
.50166 .97619 L
.50059 .97619 L
.49936 .97619 L
.4982 .97619 L
.49714 .97619 L
.49599 .97619 L
.49486 .97619 L
.49361 .97619 L
.49229 .97619 L
.49106 .97619 L
.48991 .97619 L
.48887 .97619 L
.48765 .97619 L
.48649 .97619 L
.48526 .97619 L
.4839 .97619 L
.48147 .97619 L
.48015 .97619 L
.47872 .97619 L
.47619 .97619 L
.47356 .97619 L
.4711 .97619 L
.46889 .97619 L
.46647 .97619 L
.46397 .97619 L
.46129 .97618 L
.45851 .97618 L
.45558 .97618 L
.45078 .97617 L
.44562 .97616 L
.44084 .97615 L
.43636 .97614 L
.43119 .97612 L
.42627 .9761 L
.42066 .97607 L
.41558 .97603 L
.40551 .97594 L
.39634 .97583 L
.38642 .97568 L
.37645 .97547 L
.36551 .97518 L
.346 .97445 L
.33498 .97389 L
.32494 .97327 L
.305 .97168 L
.28418 .9694 L
.26493 .96657 L
.24396 .96254 L
.22428 .95764 L
.20612 .95195 L
.18609 .9441 L
.166 .93418 L
.14487 .92092 L
.12399 .90413 L
.10458 .88404 L
.0825 .8535 L
.06244 .81415 L
.05224 .78672 L
.04262 .75238 L
.0375 .72826 L
.03524 .71543 L
.03279 .69928 L
.02846 .66075 L
.02729 .64615 L
.02605 .62646 L
.02499 .60204 L
.02381 .5033 L
F
0 g
.02381 .4967 m
.02499 .39796 L
.02605 .37354 L
.02729 .35385 L
.02846 .33925 L
.03279 .30072 L
.03524 .28457 L
.0375 .27174 L
.04262 .24762 L
.05224 .21328 L
.06244 .18585 L
.0825 .1465 L
.10458 .11596 L
.12399 .09587 L
.14487 .07908 L
.166 .06582 L
.18609 .0559 L
.20612 .04805 L
.22428 .04236 L
.24396 .03746 L
.26493 .03343 L
.28418 .0306 L
.305 .02832 L
.32494 .02673 L
.33498 .02611 L
.346 .02555 L
.36551 .02482 L
.37645 .02453 L
.38642 .02432 L
.39634 .02417 L
.40551 .02406 L
.41558 .02397 L
.42066 .02393 L
.42627 .0239 L
.43119 .02388 L
.43636 .02386 L
.44084 .02385 L
.44562 .02384 L
.45078 .02383 L
.45558 .02382 L
.45851 .02382 L
.46129 .02382 L
.46397 .02381 L
.46647 .02381 L
.46889 .02381 L
.4711 .02381 L
.47356 .02381 L
.47619 .02381 L
.47872 .02381 L
.48015 .02381 L
Mistroke
.48147 .02381 L
.4839 .02381 L
.48526 .02381 L
.48649 .02381 L
.48765 .02381 L
.48887 .02381 L
.48991 .02381 L
.49106 .02381 L
.49229 .02381 L
.49361 .02381 L
.49486 .02381 L
.49599 .02381 L
.49714 .02381 L
.4982 .02381 L
.49936 .02381 L
.50059 .02381 L
.50166 .02381 L
.50266 .02381 L
.50376 .02381 L
.50494 .02381 L
.5062 .02381 L
.50735 .02381 L
.50867 .02381 L
.50991 .02381 L
.51107 .02381 L
.51213 .02381 L
.5133 .02381 L
.51454 .02381 L
.51578 .02381 L
.51712 .02381 L
.51953 .02381 L
.521 .02381 L
.5224 .02381 L
.52502 .02381 L
.52756 .02381 L
.53027 .02381 L
.53258 .02381 L
.53513 .02381 L
.53786 .02382 L
.5408 .02382 L
.54613 .02382 L
.55108 .02383 L
.55569 .02384 L
.56074 .02385 L
.56615 .02387 L
.57183 .02389 L
.57719 .02392 L
.58724 .02399 L
.59694 .02408 L
.60723 .02422 L
Mistroke
.61601 .02437 L
.62567 .02458 L
.6451 .02518 L
.656 .02565 L
.66598 .02616 L
.68498 .02745 L
.70571 .0294 L
.7254 .03191 L
.74637 .03547 L
.7678 .04025 L
.78798 .04606 L
.80807 .05342 L
.82655 .06187 L
.84698 .07358 L
.86605 .08733 L
.88439 .10393 L
.90405 .12672 L
.91423 .1413 L
.9253 .16009 L
.93487 .17965 L
.94543 .20638 L
.95312 .23107 L
.96035 .2609 L
.96433 .28196 L
.96797 .30635 L
.97005 .32386 L
.97198 .34435 L
.97303 .35845 L
.97399 .37438 L
.97505 .39911 L
.97619 .4967 L
Mfstroke
.02381 .5033 m
.02499 .60204 L
.02605 .62646 L
.02729 .64615 L
.02846 .66075 L
.03279 .69928 L
.03524 .71543 L
.0375 .72826 L
.04262 .75238 L
.05224 .78672 L
.06244 .81415 L
.0825 .8535 L
.10458 .88404 L
.12399 .90413 L
.14487 .92092 L
.166 .93418 L
.18609 .9441 L
.20612 .95195 L
.22428 .95764 L
.24396 .96254 L
.26493 .96657 L
.28418 .9694 L
.305 .97168 L
.32494 .97327 L
.33498 .97389 L
.346 .97445 L
.36551 .97518 L
.37645 .97547 L
.38642 .97568 L
.39634 .97583 L
.40551 .97594 L
.41558 .97603 L
.42066 .97607 L
.42627 .9761 L
.43119 .97612 L
.43636 .97614 L
.44084 .97615 L
.44562 .97616 L
.45078 .97617 L
.45558 .97618 L
.45851 .97618 L
.46129 .97618 L
.46397 .97619 L
.46647 .97619 L
.46889 .97619 L
.4711 .97619 L
.47356 .97619 L
.47619 .97619 L
.47872 .97619 L
.48015 .97619 L
Mistroke
.48147 .97619 L
.4839 .97619 L
.48526 .97619 L
.48649 .97619 L
.48765 .97619 L
.48887 .97619 L
.48991 .97619 L
.49106 .97619 L
.49229 .97619 L
.49361 .97619 L
.49486 .97619 L
.49599 .97619 L
.49714 .97619 L
.4982 .97619 L
.49936 .97619 L
.50059 .97619 L
.50166 .97619 L
.50266 .97619 L
.50376 .97619 L
.50494 .97619 L
.5062 .97619 L
.50735 .97619 L
.50867 .97619 L
.50991 .97619 L
.51107 .97619 L
.51213 .97619 L
.5133 .97619 L
.51454 .97619 L
.51578 .97619 L
.51712 .97619 L
.51953 .97619 L
.521 .97619 L
.5224 .97619 L
.52502 .97619 L
.52756 .97619 L
.53027 .97619 L
.53258 .97619 L
.53513 .97619 L
.53786 .97618 L
.5408 .97618 L
.54613 .97618 L
.55108 .97617 L
.55569 .97616 L
.56074 .97615 L
.56615 .97613 L
.57183 .97611 L
.57719 .97608 L
.58724 .97601 L
.59694 .97592 L
.60723 .97578 L
Mistroke
.61601 .97563 L
.62567 .97542 L
.6451 .97482 L
.656 .97436 L
.66598 .97384 L
.68498 .97255 L
.70571 .9706 L
.7254 .96809 L
.74637 .96453 L
.7678 .95975 L
.78798 .95394 L
.80807 .94658 L
.82655 .93813 L
.84698 .92642 L
.86605 .91267 L
.88439 .89607 L
.90405 .87328 L
.91423 .8587 L
.9253 .83991 L
.93487 .82035 L
.94543 .79362 L
.95312 .76893 L
.96035 .7391 L
.96433 .71804 L
.96797 .69365 L
.97005 .67614 L
.97198 .65565 L
.97303 .64155 L
.97399 .62562 L
.97505 .60089 L
.97619 .5033 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 1 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.476191 0.5 0.476191 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .5 m
1 .5 L
s
.5 0 m
.5 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.754707 0.0238095 0.97619 0.245293 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 1 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.476191 0.5 0.476191 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .5 m
1 .5 L
s
.5 0 m
.5 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 Mabswid
.02381 .48856 m
.02499 .35003 L
.02605 .32384 L
.02729 .30364 L
.02846 .28911 L
.03053 .26909 L
.03279 .25223 L
.0379 .22379 L
.04262 .20421 L
.05224 .17451 L
.06244 .15142 L
.0825 .11917 L
.0939 .1055 L
.10458 .09475 L
.12312 .07957 L
.14335 .06673 L
.16449 .05633 L
.18458 .0486 L
.20425 .04261 L
.22522 .0376 L
.24663 .03365 L
.2668 .03081 L
.28688 .02866 L
.30535 .02717 L
.32418 .02604 L
.33499 .02554 L
.34484 .02516 L
.36435 .0246 L
.37509 .02437 L
.38527 .02421 L
.39492 .02409 L
.40518 .024 L
.41393 .02394 L
.4236 .02389 L
.42851 .02387 L
.43369 .02385 L
.43816 .02384 L
.44294 .02383 L
.4481 .02383 L
.4529 .02382 L
.45584 .02382 L
.45861 .02382 L
.46129 .02381 L
.4638 .02381 L
.46843 .02381 L
.47088 .02381 L
.47352 .02381 L
.47628 .02381 L
.47764 .02381 L
.4789 .02381 L
Mistroke
.48125 .02381 L
.48249 .02381 L
.48381 .02381 L
.48498 .02381 L
.48621 .02381 L
.48756 .02381 L
.4888 .02381 L
.48996 .02381 L
.49104 .02381 L
.49223 .02381 L
.4935 .02381 L
.49463 .02381 L
.49585 .02381 L
.49701 .02381 L
.49809 .02381 L
.49905 .02381 L
.50011 .02381 L
.50122 .02381 L
.50227 .02381 L
.50345 .02381 L
.50471 .02381 L
.5059 .02381 L
.50698 .02381 L
.50825 .02381 L
.50897 .02381 L
.50963 .02381 L
.51084 .02381 L
.51212 .02381 L
.51335 .02381 L
.51468 .02381 L
.51592 .02381 L
.51706 .02381 L
.5184 .02381 L
.51985 .02381 L
.52249 .02381 L
.5247 .02381 L
.52715 .02381 L
.5297 .02381 L
.5321 .02381 L
.53638 .02381 L
.53879 .02381 L
.541 .02382 L
.54573 .02382 L
.55079 .02382 L
.55556 .02383 L
.55991 .02384 L
.56501 .02385 L
.57054 .02387 L
.57574 .02389 L
.5806 .02391 L
Mistroke
.59005 .02396 L
.60045 .02405 L
.61058 .02416 L
.62148 .02431 L
.6316 .02451 L
.64263 .02477 L
.65317 .02509 L
.66273 .02544 L
.68242 .02639 L
.70339 .02782 L
.72265 .0296 L
.74348 .03216 L
.76343 .03537 L
.7845 .03976 L
.80416 .045 L
.82249 .05111 L
.84114 .05885 L
.86142 .06947 L
.88268 .08391 L
.9028 .10199 L
.92259 .12619 L
.93258 .14213 L
.94361 .16434 L
.95179 .18572 L
.95929 .21158 L
.96322 .22922 L
.96753 .25434 L
.9697 .27104 L
.97089 .28217 L
.97202 .2946 L
.97307 .3088 L
.9742 .3291 L
.97524 .35767 L
.97619 .48856 L
Mfstroke
.02381 .51144 m
.02499 .64997 L
.02605 .67616 L
.02729 .69636 L
.02846 .71089 L
.03053 .73091 L
.03279 .74777 L
.0379 .77621 L
.04262 .79579 L
.05224 .82549 L
.06244 .84858 L
.0825 .88083 L
.0939 .8945 L
.10458 .90525 L
.12312 .92043 L
.14335 .93327 L
.16449 .94367 L
.18458 .9514 L
.20425 .95739 L
.22522 .9624 L
.24663 .96635 L
.2668 .96919 L
.28688 .97134 L
.30535 .97283 L
.32418 .97396 L
.33499 .97446 L
.34484 .97484 L
.36435 .9754 L
.37509 .97563 L
.38527 .97579 L
.39492 .97591 L
.40518 .976 L
.41393 .97606 L
.4236 .97611 L
.42851 .97613 L
.43369 .97615 L
.43816 .97616 L
.44294 .97617 L
.4481 .97617 L
.4529 .97618 L
.45584 .97618 L
.45861 .97618 L
.46129 .97619 L
.4638 .97619 L
.46843 .97619 L
.47088 .97619 L
.47352 .97619 L
.47628 .97619 L
.47764 .97619 L
.4789 .97619 L
Mistroke
.48125 .97619 L
.48249 .97619 L
.48381 .97619 L
.48498 .97619 L
.48621 .97619 L
.48756 .97619 L
.4888 .97619 L
.48996 .97619 L
.49104 .97619 L
.49223 .97619 L
.4935 .97619 L
.49463 .97619 L
.49585 .97619 L
.49701 .97619 L
.49809 .97619 L
.49905 .97619 L
.50011 .97619 L
.50122 .97619 L
.50227 .97619 L
.50345 .97619 L
.50471 .97619 L
.5059 .97619 L
.50698 .97619 L
.50825 .97619 L
.50897 .97619 L
.50963 .97619 L
.51084 .97619 L
.51212 .97619 L
.51335 .97619 L
.51468 .97619 L
.51592 .97619 L
.51706 .97619 L
.5184 .97619 L
.51985 .97619 L
.52249 .97619 L
.5247 .97619 L
.52715 .97619 L
.5297 .97619 L
.5321 .97619 L
.53638 .97619 L
.53879 .97619 L
.541 .97618 L
.54573 .97618 L
.55079 .97618 L
.55556 .97617 L
.55991 .97616 L
.56501 .97615 L
.57054 .97613 L
.57574 .97611 L
.5806 .97609 L
Mistroke
.59005 .97604 L
.60045 .97595 L
.61058 .97584 L
.62148 .97569 L
.6316 .97549 L
.64263 .97523 L
.65317 .97491 L
.66273 .97456 L
.68242 .97361 L
.70339 .97218 L
.72265 .9704 L
.74348 .96784 L
.76343 .96463 L
.7845 .96024 L
.80416 .955 L
.82249 .94889 L
.84114 .94115 L
.86142 .93053 L
.88268 .91609 L
.9028 .89801 L
.92259 .87381 L
.93258 .85787 L
.94361 .83566 L
.95179 .81428 L
.95929 .78842 L
.96322 .77078 L
.96753 .74566 L
.9697 .72896 L
.97089 .71783 L
.97202 .7054 L
.97307 .6912 L
.9742 .6709 L
.97524 .64233 L
.97619 .51144 L
Mfstroke
0 1 1 r
.02381 .48856 m
.02499 .35003 L
.02605 .32384 L
.02729 .30364 L
.02846 .28911 L
.03053 .26909 L
.03279 .25223 L
.0379 .22379 L
.04262 .20421 L
.05224 .17451 L
.06244 .15142 L
.0825 .11917 L
.0939 .1055 L
.10458 .09475 L
.12312 .07957 L
.14335 .06673 L
.16449 .05633 L
.18458 .0486 L
.20425 .04261 L
.22522 .0376 L
.24663 .03365 L
.2668 .03081 L
.28688 .02866 L
.30535 .02717 L
.32418 .02604 L
.33499 .02554 L
.34484 .02516 L
.36435 .0246 L
.37509 .02437 L
.38527 .02421 L
.39492 .02409 L
.40518 .024 L
.41393 .02394 L
.4236 .02389 L
.42851 .02387 L
.43369 .02385 L
.43816 .02384 L
.44294 .02383 L
.4481 .02383 L
.4529 .02382 L
.45584 .02382 L
.45861 .02382 L
.46129 .02381 L
.4638 .02381 L
.46843 .02381 L
.47088 .02381 L
.47352 .02381 L
.47628 .02381 L
.47764 .02381 L
.4789 .02381 L
.48125 .02381 L
.48249 .02381 L
.48381 .02381 L
.48498 .02381 L
.48621 .02381 L
.48756 .02381 L
.4888 .02381 L
.48996 .02381 L
.49104 .02381 L
.49223 .02381 L
.4935 .02381 L
.49463 .02381 L
.49585 .02381 L
.49701 .02381 L
.49809 .02381 L
.49905 .02381 L
.50011 .02381 L
.50122 .02381 L
.50227 .02381 L
.50345 .02381 L
.50471 .02381 L
.5059 .02381 L
.50698 .02381 L
.50825 .02381 L
.50897 .02381 L
.50963 .02381 L
.51084 .02381 L
.51212 .02381 L
.51335 .02381 L
.51468 .02381 L
.51592 .02381 L
.51706 .02381 L
.5184 .02381 L
.51985 .02381 L
.52249 .02381 L
.5247 .02381 L
.52715 .02381 L
.5297 .02381 L
.5321 .02381 L
.53638 .02381 L
.53879 .02381 L
.541 .02382 L
.54573 .02382 L
.55079 .02382 L
.55556 .02383 L
.55991 .02384 L
.56501 .02385 L
.57054 .02387 L
.57574 .02389 L
.5806 .02391 L
.59005 .02396 L
.60045 .02405 L
.61058 .02416 L
.62148 .02431 L
.6316 .02451 L
.64263 .02477 L
.65317 .02509 L
.66273 .02544 L
.68242 .02639 L
.70339 .02782 L
.72265 .0296 L
.74348 .03216 L
.76343 .03537 L
.7845 .03976 L
.80416 .045 L
.82249 .05111 L
.84114 .05885 L
.86142 .06947 L
.88268 .08391 L
.9028 .10199 L
.92259 .12619 L
.93258 .14213 L
.94361 .16434 L
.95179 .18572 L
.95929 .21158 L
.96322 .22922 L
.96753 .25434 L
.9697 .27104 L
.97089 .28217 L
.97202 .2946 L
.97307 .3088 L
.9742 .3291 L
.97524 .35767 L
.97619 .48856 L
.97619 .51144 L
.97524 .64233 L
.9742 .6709 L
.97307 .6912 L
.97202 .7054 L
.97089 .71783 L
.9697 .72896 L
.96753 .74566 L
.96322 .77078 L
.95929 .78842 L
.95179 .81428 L
.94361 .83566 L
.93258 .85787 L
.92259 .87381 L
.9028 .89801 L
.88268 .91609 L
.86142 .93053 L
.84114 .94115 L
.82249 .94889 L
.80416 .955 L
.7845 .96024 L
.76343 .96463 L
.74348 .96784 L
.72265 .9704 L
.70339 .97218 L
.68242 .97361 L
.66273 .97456 L
.65317 .97491 L
.64263 .97523 L
.6316 .97549 L
.62148 .97569 L
.61058 .97584 L
.60045 .97595 L
.59005 .97604 L
.5806 .97609 L
.57574 .97611 L
.57054 .97613 L
.56501 .97615 L
.55991 .97616 L
.55556 .97617 L
.55079 .97618 L
.54573 .97618 L
.541 .97618 L
.53879 .97619 L
.53638 .97619 L
.5321 .97619 L
.5297 .97619 L
.52715 .97619 L
.5247 .97619 L
.52249 .97619 L
.51985 .97619 L
.5184 .97619 L
.51706 .97619 L
.51592 .97619 L
.51468 .97619 L
.51335 .97619 L
.51212 .97619 L
.51084 .97619 L
.50963 .97619 L
.50897 .97619 L
.50825 .97619 L
.50698 .97619 L
.5059 .97619 L
.50471 .97619 L
.50345 .97619 L
.50227 .97619 L
.50122 .97619 L
.50011 .97619 L
.49905 .97619 L
.49809 .97619 L
.49701 .97619 L
.49585 .97619 L
.49463 .97619 L
.4935 .97619 L
.49223 .97619 L
.49104 .97619 L
.48996 .97619 L
.4888 .97619 L
.48756 .97619 L
.48621 .97619 L
.48498 .97619 L
.48381 .97619 L
.48249 .97619 L
.48125 .97619 L
.4789 .97619 L
.47764 .97619 L
.47628 .97619 L
.47352 .97619 L
.47088 .97619 L
.46843 .97619 L
.4638 .97619 L
.46129 .97619 L
.45861 .97618 L
.45584 .97618 L
.4529 .97618 L
.4481 .97617 L
.44294 .97617 L
.43816 .97616 L
.43369 .97615 L
.42851 .97613 L
.4236 .97611 L
.41393 .97606 L
.40518 .976 L
.39492 .97591 L
.38527 .97579 L
.37509 .97563 L
.36435 .9754 L
.34484 .97484 L
.33499 .97446 L
.32418 .97396 L
.30535 .97283 L
.28688 .97134 L
.2668 .96919 L
.24663 .96635 L
.22522 .9624 L
.20425 .95739 L
.18458 .9514 L
.16449 .94367 L
.14335 .93327 L
.12312 .92043 L
.10458 .90525 L
.0939 .8945 L
.0825 .88083 L
.06244 .84858 L
.05224 .82549 L
.04262 .79579 L
.0379 .77621 L
.03279 .74777 L
.03053 .73091 L
.02846 .71089 L
.02729 .69636 L
.02605 .67616 L
.02499 .64997 L
.02381 .51144 L
F
0 g
.02381 .48856 m
.02499 .35003 L
.02605 .32384 L
.02729 .30364 L
.02846 .28911 L
.03053 .26909 L
.03279 .25223 L
.0379 .22379 L
.04262 .20421 L
.05224 .17451 L
.06244 .15142 L
.0825 .11917 L
.0939 .1055 L
.10458 .09475 L
.12312 .07957 L
.14335 .06673 L
.16449 .05633 L
.18458 .0486 L
.20425 .04261 L
.22522 .0376 L
.24663 .03365 L
.2668 .03081 L
.28688 .02866 L
.30535 .02717 L
.32418 .02604 L
.33499 .02554 L
.34484 .02516 L
.36435 .0246 L
.37509 .02437 L
.38527 .02421 L
.39492 .02409 L
.40518 .024 L
.41393 .02394 L
.4236 .02389 L
.42851 .02387 L
.43369 .02385 L
.43816 .02384 L
.44294 .02383 L
.4481 .02383 L
.4529 .02382 L
.45584 .02382 L
.45861 .02382 L
.46129 .02381 L
.4638 .02381 L
.46843 .02381 L
.47088 .02381 L
.47352 .02381 L
.47628 .02381 L
.47764 .02381 L
.4789 .02381 L
Mistroke
.48125 .02381 L
.48249 .02381 L
.48381 .02381 L
.48498 .02381 L
.48621 .02381 L
.48756 .02381 L
.4888 .02381 L
.48996 .02381 L
.49104 .02381 L
.49223 .02381 L
.4935 .02381 L
.49463 .02381 L
.49585 .02381 L
.49701 .02381 L
.49809 .02381 L
.49905 .02381 L
.50011 .02381 L
.50122 .02381 L
.50227 .02381 L
.50345 .02381 L
.50471 .02381 L
.5059 .02381 L
.50698 .02381 L
.50825 .02381 L
.50897 .02381 L
.50963 .02381 L
.51084 .02381 L
.51212 .02381 L
.51335 .02381 L
.51468 .02381 L
.51592 .02381 L
.51706 .02381 L
.5184 .02381 L
.51985 .02381 L
.52249 .02381 L
.5247 .02381 L
.52715 .02381 L
.5297 .02381 L
.5321 .02381 L
.53638 .02381 L
.53879 .02381 L
.541 .02382 L
.54573 .02382 L
.55079 .02382 L
.55556 .02383 L
.55991 .02384 L
.56501 .02385 L
.57054 .02387 L
.57574 .02389 L
.5806 .02391 L
Mistroke
.59005 .02396 L
.60045 .02405 L
.61058 .02416 L
.62148 .02431 L
.6316 .02451 L
.64263 .02477 L
.65317 .02509 L
.66273 .02544 L
.68242 .02639 L
.70339 .02782 L
.72265 .0296 L
.74348 .03216 L
.76343 .03537 L
.7845 .03976 L
.80416 .045 L
.82249 .05111 L
.84114 .05885 L
.86142 .06947 L
.88268 .08391 L
.9028 .10199 L
.92259 .12619 L
.93258 .14213 L
.94361 .16434 L
.95179 .18572 L
.95929 .21158 L
.96322 .22922 L
.96753 .25434 L
.9697 .27104 L
.97089 .28217 L
.97202 .2946 L
.97307 .3088 L
.9742 .3291 L
.97524 .35767 L
.97619 .48856 L
Mfstroke
.02381 .51144 m
.02499 .64997 L
.02605 .67616 L
.02729 .69636 L
.02846 .71089 L
.03053 .73091 L
.03279 .74777 L
.0379 .77621 L
.04262 .79579 L
.05224 .82549 L
.06244 .84858 L
.0825 .88083 L
.0939 .8945 L
.10458 .90525 L
.12312 .92043 L
.14335 .93327 L
.16449 .94367 L
.18458 .9514 L
.20425 .95739 L
.22522 .9624 L
.24663 .96635 L
.2668 .96919 L
.28688 .97134 L
.30535 .97283 L
.32418 .97396 L
.33499 .97446 L
.34484 .97484 L
.36435 .9754 L
.37509 .97563 L
.38527 .97579 L
.39492 .97591 L
.40518 .976 L
.41393 .97606 L
.4236 .97611 L
.42851 .97613 L
.43369 .97615 L
.43816 .97616 L
.44294 .97617 L
.4481 .97617 L
.4529 .97618 L
.45584 .97618 L
.45861 .97618 L
.46129 .97619 L
.4638 .97619 L
.46843 .97619 L
.47088 .97619 L
.47352 .97619 L
.47628 .97619 L
.47764 .97619 L
.4789 .97619 L
Mistroke
.48125 .97619 L
.48249 .97619 L
.48381 .97619 L
.48498 .97619 L
.48621 .97619 L
.48756 .97619 L
.4888 .97619 L
.48996 .97619 L
.49104 .97619 L
.49223 .97619 L
.4935 .97619 L
.49463 .97619 L
.49585 .97619 L
.49701 .97619 L
.49809 .97619 L
.49905 .97619 L
.50011 .97619 L
.50122 .97619 L
.50227 .97619 L
.50345 .97619 L
.50471 .97619 L
.5059 .97619 L
.50698 .97619 L
.50825 .97619 L
.50897 .97619 L
.50963 .97619 L
.51084 .97619 L
.51212 .97619 L
.51335 .97619 L
.51468 .97619 L
.51592 .97619 L
.51706 .97619 L
.5184 .97619 L
.51985 .97619 L
.52249 .97619 L
.5247 .97619 L
.52715 .97619 L
.5297 .97619 L
.5321 .97619 L
.53638 .97619 L
.53879 .97619 L
.541 .97618 L
.54573 .97618 L
.55079 .97618 L
.55556 .97617 L
.55991 .97616 L
.56501 .97615 L
.57054 .97613 L
.57574 .97611 L
.5806 .97609 L
Mistroke
.59005 .97604 L
.60045 .97595 L
.61058 .97584 L
.62148 .97569 L
.6316 .97549 L
.64263 .97523 L
.65317 .97491 L
.66273 .97456 L
.68242 .97361 L
.70339 .97218 L
.72265 .9704 L
.74348 .96784 L
.76343 .96463 L
.7845 .96024 L
.80416 .955 L
.82249 .94889 L
.84114 .94115 L
.86142 .93053 L
.88268 .91609 L
.9028 .89801 L
.92259 .87381 L
.93258 .85787 L
.94361 .83566 L
.95179 .81428 L
.95929 .78842 L
.96322 .77078 L
.96753 .74566 L
.9697 .72896 L
.97089 .71783 L
.97202 .7054 L
.97307 .6912 L
.9742 .6709 L
.97524 .64233 L
.97619 .51144 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 1 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.476191 0.5 0.476191 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .5 m
1 .5 L
s
.5 0 m
.5 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.0238095 0.267442 0.245293 0.488926 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 1 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.47619 0.5 0.47619 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .5 m
1 .5 L
s
.5 0 m
.5 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 Mabswid
.02381 .5 m
.04313 .44437 L
.06419 .38883 L
.08398 .34134 L
.10301 .29973 L
.12326 .25961 L
.14276 .22487 L
.16348 .19187 L
.18345 .1637 L
.20265 .13975 L
.22309 .11745 L
.24276 .09887 L
.26168 .0835 L
.28182 .06961 L
.30121 .05845 L
.32182 .04876 L
.34168 .04131 L
.36077 .03571 L
.3811 .03122 L
.40066 .02813 L
.41137 .02688 L
.42145 .02595 L
.43149 .02523 L
.44073 .02473 L
.45014 .02436 L
.45548 .0242 L
.46047 .02408 L
.4657 .02399 L
.47065 .02392 L
.47509 .02388 L
.4776 .02386 L
.47993 .02385 L
.48224 .02383 L
.48474 .02383 L
.4871 .02382 L
.48926 .02381 L
.4905 .02381 L
.49165 .02381 L
.49292 .02381 L
.49363 .02381 L
.49428 .02381 L
.49491 .02381 L
.49558 .02381 L
.49593 .02381 L
.49631 .02381 L
.49667 .02381 L
.49699 .02381 L
.49763 .02381 L
.49798 .02381 L
.49832 .02381 L
Mistroke
.49891 .02381 L
.49956 .02381 L
.5 .02381 L
Mfstroke
.02381 .5 m
.04313 .55563 L
.06419 .61117 L
.08398 .65866 L
.10301 .70027 L
.12326 .74039 L
.14276 .77513 L
.16348 .80813 L
.18345 .8363 L
.20265 .86025 L
.22309 .88255 L
.24276 .90113 L
.26168 .9165 L
.28182 .93039 L
.30121 .94155 L
.32182 .95124 L
.34168 .95869 L
.36077 .96429 L
.3811 .96878 L
.40066 .97187 L
.41137 .97312 L
.42145 .97405 L
.43149 .97477 L
.44073 .97527 L
.45014 .97564 L
.45548 .9758 L
.46047 .97592 L
.4657 .97601 L
.47065 .97608 L
.47509 .97612 L
.4776 .97614 L
.47993 .97615 L
.48224 .97617 L
.48474 .97617 L
.4871 .97618 L
.48926 .97619 L
.4905 .97619 L
.49165 .97619 L
.49292 .97619 L
.49363 .97619 L
.49428 .97619 L
.49491 .97619 L
.49558 .97619 L
.49593 .97619 L
.49631 .97619 L
.49667 .97619 L
.49699 .97619 L
.49763 .97619 L
.49798 .97619 L
.49832 .97619 L
Mistroke
.49891 .97619 L
.49956 .97619 L
.5 .97619 L
Mfstroke
0 1 1 r
.02381 .5 m
.04313 .44437 L
.06419 .38883 L
.08398 .34134 L
.10301 .29973 L
.12326 .25961 L
.14276 .22487 L
.16348 .19187 L
.18345 .1637 L
.20265 .13975 L
.22309 .11745 L
.24276 .09887 L
.26168 .0835 L
.28182 .06961 L
.30121 .05845 L
.32182 .04876 L
.34168 .04131 L
.36077 .03571 L
.3811 .03122 L
.40066 .02813 L
.41137 .02688 L
.42145 .02595 L
.43149 .02523 L
.44073 .02473 L
.45014 .02436 L
.45548 .0242 L
.46047 .02408 L
.4657 .02399 L
.47065 .02392 L
.47509 .02388 L
.4776 .02386 L
.47993 .02385 L
.48224 .02383 L
.48474 .02383 L
.4871 .02382 L
.48926 .02381 L
.4905 .02381 L
.49165 .02381 L
.49292 .02381 L
.49363 .02381 L
.49428 .02381 L
.49491 .02381 L
.49558 .02381 L
.49593 .02381 L
.49631 .02381 L
.49667 .02381 L
.49699 .02381 L
.49763 .02381 L
.49798 .02381 L
.49832 .02381 L
.49891 .02381 L
.49956 .02381 L
.5 .02381 L
.5 .97619 L
.49956 .97619 L
.49891 .97619 L
.49832 .97619 L
.49798 .97619 L
.49763 .97619 L
.49699 .97619 L
.49667 .97619 L
.49631 .97619 L
.49593 .97619 L
.49558 .97619 L
.49491 .97619 L
.49428 .97619 L
.49363 .97619 L
.49292 .97619 L
.49165 .97619 L
.4905 .97619 L
.48926 .97619 L
.4871 .97618 L
.48474 .97617 L
.48224 .97617 L
.47993 .97615 L
.4776 .97614 L
.47509 .97612 L
.47065 .97608 L
.4657 .97601 L
.46047 .97592 L
.45548 .9758 L
.45014 .97564 L
.44073 .97527 L
.43149 .97477 L
.42145 .97405 L
.41137 .97312 L
.40066 .97187 L
.3811 .96878 L
.36077 .96429 L
.34168 .95869 L
.32182 .95124 L
.30121 .94155 L
.28182 .93039 L
.26168 .9165 L
.24276 .90113 L
.22309 .88255 L
.20265 .86025 L
.18345 .8363 L
.16348 .80813 L
.14276 .77513 L
.12326 .74039 L
.10301 .70027 L
.08398 .65866 L
.06419 .61117 L
.04313 .55563 L
.02381 .5 L
F
0 g
.02381 .5 m
.04313 .44437 L
.06419 .38883 L
.08398 .34134 L
.10301 .29973 L
.12326 .25961 L
.14276 .22487 L
.16348 .19187 L
.18345 .1637 L
.20265 .13975 L
.22309 .11745 L
.24276 .09887 L
.26168 .0835 L
.28182 .06961 L
.30121 .05845 L
.32182 .04876 L
.34168 .04131 L
.36077 .03571 L
.3811 .03122 L
.40066 .02813 L
.41137 .02688 L
.42145 .02595 L
.43149 .02523 L
.44073 .02473 L
.45014 .02436 L
.45548 .0242 L
.46047 .02408 L
.4657 .02399 L
.47065 .02392 L
.47509 .02388 L
.4776 .02386 L
.47993 .02385 L
.48224 .02383 L
.48474 .02383 L
.4871 .02382 L
.48926 .02381 L
.4905 .02381 L
.49165 .02381 L
.49292 .02381 L
.49363 .02381 L
.49428 .02381 L
.49491 .02381 L
.49558 .02381 L
.49593 .02381 L
.49631 .02381 L
.49667 .02381 L
.49699 .02381 L
.49763 .02381 L
.49798 .02381 L
.49832 .02381 L
Mistroke
.49891 .02381 L
.49956 .02381 L
.5 .02381 L
Mfstroke
.02381 .5 m
.04313 .55563 L
.06419 .61117 L
.08398 .65866 L
.10301 .70027 L
.12326 .74039 L
.14276 .77513 L
.16348 .80813 L
.18345 .8363 L
.20265 .86025 L
.22309 .88255 L
.24276 .90113 L
.26168 .9165 L
.28182 .93039 L
.30121 .94155 L
.32182 .95124 L
.34168 .95869 L
.36077 .96429 L
.3811 .96878 L
.40066 .97187 L
.41137 .97312 L
.42145 .97405 L
.43149 .97477 L
.44073 .97527 L
.45014 .97564 L
.45548 .9758 L
.46047 .97592 L
.4657 .97601 L
.47065 .97608 L
.47509 .97612 L
.4776 .97614 L
.47993 .97615 L
.48224 .97617 L
.48474 .97617 L
.4871 .97618 L
.48926 .97619 L
.4905 .97619 L
.49165 .97619 L
.49292 .97619 L
.49363 .97619 L
.49428 .97619 L
.49491 .97619 L
.49558 .97619 L
.49593 .97619 L
.49631 .97619 L
.49667 .97619 L
.49699 .97619 L
.49763 .97619 L
.49798 .97619 L
.49832 .97619 L
Mistroke
.49891 .97619 L
.49956 .97619 L
.5 .97619 L
Mfstroke
.5 .02381 m
.50059 .02381 L
.50112 .02381 L
.50174 .02381 L
.50232 .02381 L
.50286 .02381 L
.50336 .02381 L
.50391 .02381 L
.50449 .02381 L
.50507 .02381 L
.5057 .02381 L
.50683 .02381 L
.50752 .02381 L
.50817 .02381 L
.5094 .02381 L
.51059 .02381 L
.51186 .02382 L
.51414 .02382 L
.51554 .02383 L
.51686 .02383 L
.51932 .02384 L
.52188 .02386 L
.52459 .02388 L
.52944 .02392 L
.53466 .02399 L
.54039 .0241 L
.54549 .02422 L
.55014 .02437 L
.5606 .02479 L
.57014 .02533 L
.58052 .02611 L
.59041 .02707 L
.60091 .02834 L
.61979 .03139 L
.63989 .03588 L
.65923 .04161 L
.6798 .04944 L
.69961 .05889 L
.71867 .06992 L
.73895 .08398 L
.75847 .09996 L
.77922 .11981 L
.79921 .14194 L
.81844 .16622 L
.8389 .19547 L
.8586 .22718 L
.87755 .26114 L
.89772 .30125 L
.91713 .34389 L
.93777 .39378 L
Mistroke
.95765 .44651 L
.97619 .5 L
Mfstroke
.5 .97619 m
.50059 .97619 L
.50112 .97619 L
.50174 .97619 L
.50232 .97619 L
.50286 .97619 L
.50336 .97619 L
.50391 .97619 L
.50449 .97619 L
.50507 .97619 L
.5057 .97619 L
.50683 .97619 L
.50752 .97619 L
.50817 .97619 L
.5094 .97619 L
.51059 .97619 L
.51186 .97618 L
.51414 .97618 L
.51554 .97617 L
.51686 .97617 L
.51932 .97616 L
.52188 .97614 L
.52459 .97612 L
.52944 .97608 L
.53466 .97601 L
.54039 .9759 L
.54549 .97578 L
.55014 .97563 L
.5606 .97521 L
.57014 .97467 L
.58052 .97389 L
.59041 .97293 L
.60091 .97166 L
.61979 .96861 L
.63989 .96412 L
.65923 .95839 L
.6798 .95056 L
.69961 .94111 L
.71867 .93008 L
.73895 .91602 L
.75847 .90004 L
.77922 .88019 L
.79921 .85806 L
.81844 .83378 L
.8389 .80453 L
.8586 .77282 L
.87755 .73886 L
.89772 .69875 L
.91713 .65611 L
.93777 .60622 L
Mistroke
.95765 .55349 L
.97619 .5 L
Mfstroke
0 1 1 r
.5 .02381 m
.50059 .02381 L
.50112 .02381 L
.50174 .02381 L
.50232 .02381 L
.50286 .02381 L
.50336 .02381 L
.50391 .02381 L
.50449 .02381 L
.50507 .02381 L
.5057 .02381 L
.50683 .02381 L
.50752 .02381 L
.50817 .02381 L
.5094 .02381 L
.51059 .02381 L
.51186 .02382 L
.51414 .02382 L
.51554 .02383 L
.51686 .02383 L
.51932 .02384 L
.52188 .02386 L
.52459 .02388 L
.52944 .02392 L
.53466 .02399 L
.54039 .0241 L
.54549 .02422 L
.55014 .02437 L
.5606 .02479 L
.57014 .02533 L
.58052 .02611 L
.59041 .02707 L
.60091 .02834 L
.61979 .03139 L
.63989 .03588 L
.65923 .04161 L
.6798 .04944 L
.69961 .05889 L
.71867 .06992 L
.73895 .08398 L
.75847 .09996 L
.77922 .11981 L
.79921 .14194 L
.81844 .16622 L
.8389 .19547 L
.8586 .22718 L
.87755 .26114 L
.89772 .30125 L
.91713 .34389 L
.93777 .39378 L
.95765 .44651 L
.97619 .5 L
.97619 .5 L
.95765 .55349 L
.93777 .60622 L
.91713 .65611 L
.89772 .69875 L
.87755 .73886 L
.8586 .77282 L
.8389 .80453 L
.81844 .83378 L
.79921 .85806 L
.77922 .88019 L
.75847 .90004 L
.73895 .91602 L
.71867 .93008 L
.69961 .94111 L
.6798 .95056 L
.65923 .95839 L
.63989 .96412 L
.61979 .96861 L
.60091 .97166 L
.59041 .97293 L
.58052 .97389 L
.57014 .97467 L
.5606 .97521 L
.55014 .97563 L
.54549 .97578 L
.54039 .9759 L
.53466 .97601 L
.52944 .97608 L
.52459 .97612 L
.52188 .97614 L
.51932 .97616 L
.51686 .97617 L
.51554 .97617 L
.51414 .97618 L
.51186 .97618 L
.51059 .97619 L
.5094 .97619 L
.50817 .97619 L
.50752 .97619 L
.50683 .97619 L
.5057 .97619 L
.50507 .97619 L
.50449 .97619 L
.50391 .97619 L
.50336 .97619 L
.50286 .97619 L
.50232 .97619 L
.50174 .97619 L
.50112 .97619 L
.50059 .97619 L
.5 .97619 L
F
0 g
.5 .02381 m
.50059 .02381 L
.50112 .02381 L
.50174 .02381 L
.50232 .02381 L
.50286 .02381 L
.50336 .02381 L
.50391 .02381 L
.50449 .02381 L
.50507 .02381 L
.5057 .02381 L
.50683 .02381 L
.50752 .02381 L
.50817 .02381 L
.5094 .02381 L
.51059 .02381 L
.51186 .02382 L
.51414 .02382 L
.51554 .02383 L
.51686 .02383 L
.51932 .02384 L
.52188 .02386 L
.52459 .02388 L
.52944 .02392 L
.53466 .02399 L
.54039 .0241 L
.54549 .02422 L
.55014 .02437 L
.5606 .02479 L
.57014 .02533 L
.58052 .02611 L
.59041 .02707 L
.60091 .02834 L
.61979 .03139 L
.63989 .03588 L
.65923 .04161 L
.6798 .04944 L
.69961 .05889 L
.71867 .06992 L
.73895 .08398 L
.75847 .09996 L
.77922 .11981 L
.79921 .14194 L
.81844 .16622 L
.8389 .19547 L
.8586 .22718 L
.87755 .26114 L
.89772 .30125 L
.91713 .34389 L
.93777 .39378 L
Mistroke
.95765 .44651 L
.97619 .5 L
Mfstroke
.5 .97619 m
.50059 .97619 L
.50112 .97619 L
.50174 .97619 L
.50232 .97619 L
.50286 .97619 L
.50336 .97619 L
.50391 .97619 L
.50449 .97619 L
.50507 .97619 L
.5057 .97619 L
.50683 .97619 L
.50752 .97619 L
.50817 .97619 L
.5094 .97619 L
.51059 .97619 L
.51186 .97618 L
.51414 .97618 L
.51554 .97617 L
.51686 .97617 L
.51932 .97616 L
.52188 .97614 L
.52459 .97612 L
.52944 .97608 L
.53466 .97601 L
.54039 .9759 L
.54549 .97578 L
.55014 .97563 L
.5606 .97521 L
.57014 .97467 L
.58052 .97389 L
.59041 .97293 L
.60091 .97166 L
.61979 .96861 L
.63989 .96412 L
.65923 .95839 L
.6798 .95056 L
.69961 .94111 L
.71867 .93008 L
.73895 .91602 L
.75847 .90004 L
.77922 .88019 L
.79921 .85806 L
.81844 .83378 L
.8389 .80453 L
.8586 .77282 L
.87755 .73886 L
.89772 .69875 L
.91713 .65611 L
.93777 .60622 L
Mistroke
.95765 .55349 L
.97619 .5 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 1 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.47619 0.5 0.47619 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .5 m
1 .5 L
s
.5 0 m
.5 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.267442 0.267442 0.488926 0.488926 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 1 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.47619 0.5 0.47619 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .5 m
1 .5 L
s
.5 0 m
.5 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 Mabswid
.02381 .49983 m
.0244 .47104 L
.02493 .46 L
.02613 .44253 L
.0283 .42031 L
.03082 .40063 L
.03321 .38524 L
.04313 .33724 L
.05323 .30129 L
.06419 .26992 L
.08463 .22385 L
.1043 .18912 L
.12322 .16172 L
.14336 .13737 L
.16275 .11763 L
.18336 .09989 L
.20322 .08544 L
.22231 .07363 L
.24264 .06301 L
.2622 .05445 L
.28299 .0469 L
.30303 .04097 L
.3223 .03635 L
.3428 .03245 L
.36255 .02957 L
.38153 .02749 L
.3921 .02659 L
.40174 .02591 L
.41185 .02532 L
.4212 .02489 L
.43074 .02454 L
.44112 .02426 L
.45045 .02408 L
.45577 .024 L
.46075 .02394 L
.46567 .0239 L
.47085 .02386 L
.47526 .02384 L
.47777 .02383 L
.4801 .02383 L
.48262 .02382 L
.48395 .02382 L
.48536 .02382 L
.48659 .02381 L
.48794 .02381 L
.48919 .02381 L
.49033 .02381 L
.49151 .02381 L
.49264 .02381 L
.49383 .02381 L
Mistroke
.4945 .02381 L
.49513 .02381 L
.49572 .02381 L
.49627 .02381 L
.49677 .02381 L
.4973 .02381 L
.49789 .02381 L
.49851 .02381 L
.49904 .02381 L
.49962 .02381 L
.5 .02381 L
Mfstroke
.02381 .50017 m
.0244 .52896 L
.02493 .54 L
.02613 .55747 L
.0283 .57969 L
.03082 .59937 L
.03321 .61476 L
.04313 .66276 L
.05323 .69871 L
.06419 .73008 L
.08463 .77615 L
.1043 .81088 L
.12322 .83828 L
.14336 .86263 L
.16275 .88237 L
.18336 .90011 L
.20322 .91456 L
.22231 .92637 L
.24264 .93699 L
.2622 .94555 L
.28299 .9531 L
.30303 .95903 L
.3223 .96365 L
.3428 .96755 L
.36255 .97043 L
.38153 .97251 L
.3921 .97341 L
.40174 .97409 L
.41185 .97468 L
.4212 .97511 L
.43074 .97546 L
.44112 .97574 L
.45045 .97592 L
.45577 .976 L
.46075 .97606 L
.46567 .9761 L
.47085 .97614 L
.47526 .97616 L
.47777 .97617 L
.4801 .97617 L
.48262 .97618 L
.48395 .97618 L
.48536 .97618 L
.48659 .97619 L
.48794 .97619 L
.48919 .97619 L
.49033 .97619 L
.49151 .97619 L
.49264 .97619 L
.49383 .97619 L
Mistroke
.4945 .97619 L
.49513 .97619 L
.49572 .97619 L
.49627 .97619 L
.49677 .97619 L
.4973 .97619 L
.49789 .97619 L
.49851 .97619 L
.49904 .97619 L
.49962 .97619 L
.5 .97619 L
Mfstroke
0 1 1 r
.02381 .49983 m
.0244 .47104 L
.02493 .46 L
.02613 .44253 L
.0283 .42031 L
.03082 .40063 L
.03321 .38524 L
.04313 .33724 L
.05323 .30129 L
.06419 .26992 L
.08463 .22385 L
.1043 .18912 L
.12322 .16172 L
.14336 .13737 L
.16275 .11763 L
.18336 .09989 L
.20322 .08544 L
.22231 .07363 L
.24264 .06301 L
.2622 .05445 L
.28299 .0469 L
.30303 .04097 L
.3223 .03635 L
.3428 .03245 L
.36255 .02957 L
.38153 .02749 L
.3921 .02659 L
.40174 .02591 L
.41185 .02532 L
.4212 .02489 L
.43074 .02454 L
.44112 .02426 L
.45045 .02408 L
.45577 .024 L
.46075 .02394 L
.46567 .0239 L
.47085 .02386 L
.47526 .02384 L
.47777 .02383 L
.4801 .02383 L
.48262 .02382 L
.48395 .02382 L
.48536 .02382 L
.48659 .02381 L
.48794 .02381 L
.48919 .02381 L
.49033 .02381 L
.49151 .02381 L
.49264 .02381 L
.49383 .02381 L
.4945 .02381 L
.49513 .02381 L
.49572 .02381 L
.49627 .02381 L
.49677 .02381 L
.4973 .02381 L
.49789 .02381 L
.49851 .02381 L
.49904 .02381 L
.49962 .02381 L
.5 .02381 L
.5 .97619 L
.49962 .97619 L
.49904 .97619 L
.49851 .97619 L
.49789 .97619 L
.4973 .97619 L
.49677 .97619 L
.49627 .97619 L
.49572 .97619 L
.49513 .97619 L
.4945 .97619 L
.49383 .97619 L
.49264 .97619 L
.49151 .97619 L
.49033 .97619 L
.48919 .97619 L
.48794 .97619 L
.48659 .97619 L
.48536 .97618 L
.48395 .97618 L
.48262 .97618 L
.4801 .97617 L
.47777 .97617 L
.47526 .97616 L
.47085 .97614 L
.46567 .9761 L
.46075 .97606 L
.45577 .976 L
.45045 .97592 L
.44112 .97574 L
.43074 .97546 L
.4212 .97511 L
.41185 .97468 L
.40174 .97409 L
.3921 .97341 L
.38153 .97251 L
.36255 .97043 L
.3428 .96755 L
.3223 .96365 L
.30303 .95903 L
.28299 .9531 L
.2622 .94555 L
.24264 .93699 L
.22231 .92637 L
.20322 .91456 L
.18336 .90011 L
.16275 .88237 L
.14336 .86263 L
.12322 .83828 L
.1043 .81088 L
.08463 .77615 L
.06419 .73008 L
.05323 .69871 L
.04313 .66276 L
.03321 .61476 L
.03082 .59937 L
.0283 .57969 L
.02613 .55747 L
.02493 .54 L
.0244 .52896 L
.02381 .50017 L
F
0 g
.02381 .49983 m
.0244 .47104 L
.02493 .46 L
.02613 .44253 L
.0283 .42031 L
.03082 .40063 L
.03321 .38524 L
.04313 .33724 L
.05323 .30129 L
.06419 .26992 L
.08463 .22385 L
.1043 .18912 L
.12322 .16172 L
.14336 .13737 L
.16275 .11763 L
.18336 .09989 L
.20322 .08544 L
.22231 .07363 L
.24264 .06301 L
.2622 .05445 L
.28299 .0469 L
.30303 .04097 L
.3223 .03635 L
.3428 .03245 L
.36255 .02957 L
.38153 .02749 L
.3921 .02659 L
.40174 .02591 L
.41185 .02532 L
.4212 .02489 L
.43074 .02454 L
.44112 .02426 L
.45045 .02408 L
.45577 .024 L
.46075 .02394 L
.46567 .0239 L
.47085 .02386 L
.47526 .02384 L
.47777 .02383 L
.4801 .02383 L
.48262 .02382 L
.48395 .02382 L
.48536 .02382 L
.48659 .02381 L
.48794 .02381 L
.48919 .02381 L
.49033 .02381 L
.49151 .02381 L
.49264 .02381 L
.49383 .02381 L
Mistroke
.4945 .02381 L
.49513 .02381 L
.49572 .02381 L
.49627 .02381 L
.49677 .02381 L
.4973 .02381 L
.49789 .02381 L
.49851 .02381 L
.49904 .02381 L
.49962 .02381 L
.5 .02381 L
Mfstroke
.02381 .50017 m
.0244 .52896 L
.02493 .54 L
.02613 .55747 L
.0283 .57969 L
.03082 .59937 L
.03321 .61476 L
.04313 .66276 L
.05323 .69871 L
.06419 .73008 L
.08463 .77615 L
.1043 .81088 L
.12322 .83828 L
.14336 .86263 L
.16275 .88237 L
.18336 .90011 L
.20322 .91456 L
.22231 .92637 L
.24264 .93699 L
.2622 .94555 L
.28299 .9531 L
.30303 .95903 L
.3223 .96365 L
.3428 .96755 L
.36255 .97043 L
.38153 .97251 L
.3921 .97341 L
.40174 .97409 L
.41185 .97468 L
.4212 .97511 L
.43074 .97546 L
.44112 .97574 L
.45045 .97592 L
.45577 .976 L
.46075 .97606 L
.46567 .9761 L
.47085 .97614 L
.47526 .97616 L
.47777 .97617 L
.4801 .97617 L
.48262 .97618 L
.48395 .97618 L
.48536 .97618 L
.48659 .97619 L
.48794 .97619 L
.48919 .97619 L
.49033 .97619 L
.49151 .97619 L
.49264 .97619 L
.49383 .97619 L
Mistroke
.4945 .97619 L
.49513 .97619 L
.49572 .97619 L
.49627 .97619 L
.49677 .97619 L
.4973 .97619 L
.49789 .97619 L
.49851 .97619 L
.49904 .97619 L
.49962 .97619 L
.5 .97619 L
Mfstroke
.5 .02381 m
.50059 .02381 L
.50112 .02381 L
.50174 .02381 L
.50232 .02381 L
.50286 .02381 L
.50336 .02381 L
.50391 .02381 L
.50449 .02381 L
.50507 .02381 L
.5057 .02381 L
.50683 .02381 L
.50752 .02381 L
.50817 .02381 L
.5094 .02381 L
.51059 .02381 L
.51186 .02381 L
.51414 .02382 L
.51554 .02382 L
.51686 .02382 L
.51932 .02383 L
.52188 .02383 L
.52459 .02384 L
.52944 .02387 L
.53466 .0239 L
.54039 .02395 L
.54549 .02402 L
.55014 .02409 L
.5606 .0243 L
.57014 .02457 L
.58052 .02496 L
.59041 .02544 L
.60091 .02608 L
.61979 .02761 L
.63989 .02988 L
.65923 .0328 L
.6798 .0368 L
.69961 .04168 L
.71867 .04745 L
.73895 .05491 L
.75847 .06354 L
.77922 .07451 L
.79921 .08708 L
.81844 .10132 L
.8389 .11919 L
.8586 .13956 L
.87755 .16274 L
.89772 .19236 L
.91713 .22735 L
.93777 .2751 L
Mistroke
.94808 .30551 L
.95765 .34041 L
.96228 .36107 L
.96663 .3843 L
.96904 .3997 L
.97165 .41982 L
.9728 .43064 L
.97401 .44438 L
.97505 .45973 L
.97564 .47201 L
.97619 .49983 L
Mfstroke
.5 .97619 m
.50059 .97619 L
.50112 .97619 L
.50174 .97619 L
.50232 .97619 L
.50286 .97619 L
.50336 .97619 L
.50391 .97619 L
.50449 .97619 L
.50507 .97619 L
.5057 .97619 L
.50683 .97619 L
.50752 .97619 L
.50817 .97619 L
.5094 .97619 L
.51059 .97619 L
.51186 .97619 L
.51414 .97618 L
.51554 .97618 L
.51686 .97618 L
.51932 .97617 L
.52188 .97617 L
.52459 .97616 L
.52944 .97613 L
.53466 .9761 L
.54039 .97605 L
.54549 .97598 L
.55014 .97591 L
.5606 .9757 L
.57014 .97543 L
.58052 .97504 L
.59041 .97456 L
.60091 .97392 L
.61979 .97239 L
.63989 .97012 L
.65923 .9672 L
.6798 .9632 L
.69961 .95832 L
.71867 .95255 L
.73895 .94509 L
.75847 .93646 L
.77922 .92549 L
.79921 .91292 L
.81844 .89868 L
.8389 .88081 L
.8586 .86044 L
.87755 .83726 L
.89772 .80764 L
.91713 .77265 L
.93777 .7249 L
Mistroke
.94808 .69449 L
.95765 .65959 L
.96228 .63893 L
.96663 .6157 L
.96904 .6003 L
.97165 .58018 L
.9728 .56936 L
.97401 .55562 L
.97505 .54027 L
.97564 .52799 L
.97619 .50017 L
Mfstroke
0 1 1 r
.5 .02381 m
.50059 .02381 L
.50112 .02381 L
.50174 .02381 L
.50232 .02381 L
.50286 .02381 L
.50336 .02381 L
.50391 .02381 L
.50449 .02381 L
.50507 .02381 L
.5057 .02381 L
.50683 .02381 L
.50752 .02381 L
.50817 .02381 L
.5094 .02381 L
.51059 .02381 L
.51186 .02381 L
.51414 .02382 L
.51554 .02382 L
.51686 .02382 L
.51932 .02383 L
.52188 .02383 L
.52459 .02384 L
.52944 .02387 L
.53466 .0239 L
.54039 .02395 L
.54549 .02402 L
.55014 .02409 L
.5606 .0243 L
.57014 .02457 L
.58052 .02496 L
.59041 .02544 L
.60091 .02608 L
.61979 .02761 L
.63989 .02988 L
.65923 .0328 L
.6798 .0368 L
.69961 .04168 L
.71867 .04745 L
.73895 .05491 L
.75847 .06354 L
.77922 .07451 L
.79921 .08708 L
.81844 .10132 L
.8389 .11919 L
.8586 .13956 L
.87755 .16274 L
.89772 .19236 L
.91713 .22735 L
.93777 .2751 L
.94808 .30551 L
.95765 .34041 L
.96228 .36107 L
.96663 .3843 L
.96904 .3997 L
.97165 .41982 L
.9728 .43064 L
.97401 .44438 L
.97505 .45973 L
.97564 .47201 L
.97619 .49983 L
.97619 .50017 L
.97564 .52799 L
.97505 .54027 L
.97401 .55562 L
.9728 .56936 L
.97165 .58018 L
.96904 .6003 L
.96663 .6157 L
.96228 .63893 L
.95765 .65959 L
.94808 .69449 L
.93777 .7249 L
.91713 .77265 L
.89772 .80764 L
.87755 .83726 L
.8586 .86044 L
.8389 .88081 L
.81844 .89868 L
.79921 .91292 L
.77922 .92549 L
.75847 .93646 L
.73895 .94509 L
.71867 .95255 L
.69961 .95832 L
.6798 .9632 L
.65923 .9672 L
.63989 .97012 L
.61979 .97239 L
.60091 .97392 L
.59041 .97456 L
.58052 .97504 L
.57014 .97543 L
.5606 .9757 L
.55014 .97591 L
.54549 .97598 L
.54039 .97605 L
.53466 .9761 L
.52944 .97613 L
.52459 .97616 L
.52188 .97617 L
.51932 .97617 L
.51686 .97618 L
.51554 .97618 L
.51414 .97618 L
.51186 .97619 L
.51059 .97619 L
.5094 .97619 L
.50817 .97619 L
.50752 .97619 L
.50683 .97619 L
.5057 .97619 L
.50507 .97619 L
.50449 .97619 L
.50391 .97619 L
.50336 .97619 L
.50286 .97619 L
.50232 .97619 L
.50174 .97619 L
.50112 .97619 L
.50059 .97619 L
.5 .97619 L
F
0 g
.5 .02381 m
.50059 .02381 L
.50112 .02381 L
.50174 .02381 L
.50232 .02381 L
.50286 .02381 L
.50336 .02381 L
.50391 .02381 L
.50449 .02381 L
.50507 .02381 L
.5057 .02381 L
.50683 .02381 L
.50752 .02381 L
.50817 .02381 L
.5094 .02381 L
.51059 .02381 L
.51186 .02381 L
.51414 .02382 L
.51554 .02382 L
.51686 .02382 L
.51932 .02383 L
.52188 .02383 L
.52459 .02384 L
.52944 .02387 L
.53466 .0239 L
.54039 .02395 L
.54549 .02402 L
.55014 .02409 L
.5606 .0243 L
.57014 .02457 L
.58052 .02496 L
.59041 .02544 L
.60091 .02608 L
.61979 .02761 L
.63989 .02988 L
.65923 .0328 L
.6798 .0368 L
.69961 .04168 L
.71867 .04745 L
.73895 .05491 L
.75847 .06354 L
.77922 .07451 L
.79921 .08708 L
.81844 .10132 L
.8389 .11919 L
.8586 .13956 L
.87755 .16274 L
.89772 .19236 L
.91713 .22735 L
.93777 .2751 L
Mistroke
.94808 .30551 L
.95765 .34041 L
.96228 .36107 L
.96663 .3843 L
.96904 .3997 L
.97165 .41982 L
.9728 .43064 L
.97401 .44438 L
.97505 .45973 L
.97564 .47201 L
.97619 .49983 L
Mfstroke
.5 .97619 m
.50059 .97619 L
.50112 .97619 L
.50174 .97619 L
.50232 .97619 L
.50286 .97619 L
.50336 .97619 L
.50391 .97619 L
.50449 .97619 L
.50507 .97619 L
.5057 .97619 L
.50683 .97619 L
.50752 .97619 L
.50817 .97619 L
.5094 .97619 L
.51059 .97619 L
.51186 .97619 L
.51414 .97618 L
.51554 .97618 L
.51686 .97618 L
.51932 .97617 L
.52188 .97617 L
.52459 .97616 L
.52944 .97613 L
.53466 .9761 L
.54039 .97605 L
.54549 .97598 L
.55014 .97591 L
.5606 .9757 L
.57014 .97543 L
.58052 .97504 L
.59041 .97456 L
.60091 .97392 L
.61979 .97239 L
.63989 .97012 L
.65923 .9672 L
.6798 .9632 L
.69961 .95832 L
.71867 .95255 L
.73895 .94509 L
.75847 .93646 L
.77922 .92549 L
.79921 .91292 L
.81844 .89868 L
.8389 .88081 L
.8586 .86044 L
.87755 .83726 L
.89772 .80764 L
.91713 .77265 L
.93777 .7249 L
Mistroke
.94808 .69449 L
.95765 .65959 L
.96228 .63893 L
.96663 .6157 L
.96904 .6003 L
.97165 .58018 L
.9728 .56936 L
.97401 .55562 L
.97505 .54027 L
.97564 .52799 L
.97619 .50017 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 1 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.47619 0.5 0.47619 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .5 m
1 .5 L
s
.5 0 m
.5 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.511074 0.267442 0.732558 0.488926 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 1 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.47619 0.5 0.47619 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .5 m
1 .5 L
s
.5 0 m
.5 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 Mabswid
.02381 .49762 m
.0244 .42636 L
.02493 .40867 L
.02555 .39435 L
.02613 .3837 L
.0283 .35538 L
.02952 .3434 L
.03065 .33381 L
.03321 .31559 L
.03803 .28907 L
.04313 .26721 L
.05315 .23431 L
.06419 .20679 L
.08434 .16931 L
.10372 .14234 L
.12434 .11979 L
.14419 .10223 L
.16329 .08825 L
.18361 .07585 L
.20317 .06586 L
.22397 .05698 L
.244 .04987 L
.26327 .04417 L
.28378 .03916 L
.30352 .03523 L
.32251 .03218 L
.34272 .0296 L
.36217 .02769 L
.37208 .02691 L
.38285 .02618 L
.40278 .02516 L
.41266 .02479 L
.42317 .02448 L
.4329 .02425 L
.44204 .0241 L
.44696 .02403 L
.45213 .02397 L
.45698 .02393 L
.46139 .02389 L
.46616 .02387 L
.47126 .02384 L
.47352 .02384 L
.47598 .02383 L
.48044 .02382 L
.48278 .02382 L
.48496 .02381 L
.48736 .02381 L
.48871 .02381 L
.48994 .02381 L
.49122 .02381 L
Mistroke
.49241 .02381 L
.49371 .02381 L
.49444 .02381 L
.4951 .02381 L
.49573 .02381 L
.49631 .02381 L
.49695 .02381 L
.49727 .02381 L
.49763 .02381 L
.49822 .02381 L
.49885 .02381 L
.49945 .02381 L
.5 .02381 L
Mfstroke
.02381 .50238 m
.0244 .57364 L
.02493 .59133 L
.02555 .60565 L
.02613 .6163 L
.0283 .64462 L
.02952 .6566 L
.03065 .66619 L
.03321 .68441 L
.03803 .71093 L
.04313 .73279 L
.05315 .76569 L
.06419 .79321 L
.08434 .83069 L
.10372 .85766 L
.12434 .88021 L
.14419 .89777 L
.16329 .91175 L
.18361 .92415 L
.20317 .93414 L
.22397 .94302 L
.244 .95013 L
.26327 .95583 L
.28378 .96084 L
.30352 .96477 L
.32251 .96782 L
.34272 .9704 L
.36217 .97231 L
.37208 .97309 L
.38285 .97382 L
.40278 .97484 L
.41266 .97521 L
.42317 .97552 L
.4329 .97575 L
.44204 .9759 L
.44696 .97597 L
.45213 .97603 L
.45698 .97607 L
.46139 .97611 L
.46616 .97613 L
.47126 .97616 L
.47352 .97616 L
.47598 .97617 L
.48044 .97618 L
.48278 .97618 L
.48496 .97619 L
.48736 .97619 L
.48871 .97619 L
.48994 .97619 L
.49122 .97619 L
Mistroke
.49241 .97619 L
.49371 .97619 L
.49444 .97619 L
.4951 .97619 L
.49573 .97619 L
.49631 .97619 L
.49695 .97619 L
.49727 .97619 L
.49763 .97619 L
.49822 .97619 L
.49885 .97619 L
.49945 .97619 L
.5 .97619 L
Mfstroke
0 1 1 r
.02381 .49762 m
.0244 .42636 L
.02493 .40867 L
.02555 .39435 L
.02613 .3837 L
.0283 .35538 L
.02952 .3434 L
.03065 .33381 L
.03321 .31559 L
.03803 .28907 L
.04313 .26721 L
.05315 .23431 L
.06419 .20679 L
.08434 .16931 L
.10372 .14234 L
.12434 .11979 L
.14419 .10223 L
.16329 .08825 L
.18361 .07585 L
.20317 .06586 L
.22397 .05698 L
.244 .04987 L
.26327 .04417 L
.28378 .03916 L
.30352 .03523 L
.32251 .03218 L
.34272 .0296 L
.36217 .02769 L
.37208 .02691 L
.38285 .02618 L
.40278 .02516 L
.41266 .02479 L
.42317 .02448 L
.4329 .02425 L
.44204 .0241 L
.44696 .02403 L
.45213 .02397 L
.45698 .02393 L
.46139 .02389 L
.46616 .02387 L
.47126 .02384 L
.47352 .02384 L
.47598 .02383 L
.48044 .02382 L
.48278 .02382 L
.48496 .02381 L
.48736 .02381 L
.48871 .02381 L
.48994 .02381 L
.49122 .02381 L
.49241 .02381 L
.49371 .02381 L
.49444 .02381 L
.4951 .02381 L
.49573 .02381 L
.49631 .02381 L
.49695 .02381 L
.49727 .02381 L
.49763 .02381 L
.49822 .02381 L
.49885 .02381 L
.49945 .02381 L
.5 .02381 L
.5 .97619 L
.49945 .97619 L
.49885 .97619 L
.49822 .97619 L
.49763 .97619 L
.49727 .97619 L
.49695 .97619 L
.49631 .97619 L
.49573 .97619 L
.4951 .97619 L
.49444 .97619 L
.49371 .97619 L
.49241 .97619 L
.49122 .97619 L
.48994 .97619 L
.48871 .97619 L
.48736 .97619 L
.48496 .97619 L
.48278 .97618 L
.48044 .97618 L
.47598 .97617 L
.47352 .97616 L
.47126 .97616 L
.46616 .97613 L
.46139 .97611 L
.45698 .97607 L
.45213 .97603 L
.44696 .97597 L
.44204 .9759 L
.4329 .97575 L
.42317 .97552 L
.41266 .97521 L
.40278 .97484 L
.38285 .97382 L
.37208 .97309 L
.36217 .97231 L
.34272 .9704 L
.32251 .96782 L
.30352 .96477 L
.28378 .96084 L
.26327 .95583 L
.244 .95013 L
.22397 .94302 L
.20317 .93414 L
.18361 .92415 L
.16329 .91175 L
.14419 .89777 L
.12434 .88021 L
.10372 .85766 L
.08434 .83069 L
.06419 .79321 L
.05315 .76569 L
.04313 .73279 L
.03803 .71093 L
.03321 .68441 L
.03065 .66619 L
.02952 .6566 L
.0283 .64462 L
.02613 .6163 L
.02555 .60565 L
.02493 .59133 L
.0244 .57364 L
.02381 .50238 L
F
0 g
.02381 .49762 m
.0244 .42636 L
.02493 .40867 L
.02555 .39435 L
.02613 .3837 L
.0283 .35538 L
.02952 .3434 L
.03065 .33381 L
.03321 .31559 L
.03803 .28907 L
.04313 .26721 L
.05315 .23431 L
.06419 .20679 L
.08434 .16931 L
.10372 .14234 L
.12434 .11979 L
.14419 .10223 L
.16329 .08825 L
.18361 .07585 L
.20317 .06586 L
.22397 .05698 L
.244 .04987 L
.26327 .04417 L
.28378 .03916 L
.30352 .03523 L
.32251 .03218 L
.34272 .0296 L
.36217 .02769 L
.37208 .02691 L
.38285 .02618 L
.40278 .02516 L
.41266 .02479 L
.42317 .02448 L
.4329 .02425 L
.44204 .0241 L
.44696 .02403 L
.45213 .02397 L
.45698 .02393 L
.46139 .02389 L
.46616 .02387 L
.47126 .02384 L
.47352 .02384 L
.47598 .02383 L
.48044 .02382 L
.48278 .02382 L
.48496 .02381 L
.48736 .02381 L
.48871 .02381 L
.48994 .02381 L
.49122 .02381 L
Mistroke
.49241 .02381 L
.49371 .02381 L
.49444 .02381 L
.4951 .02381 L
.49573 .02381 L
.49631 .02381 L
.49695 .02381 L
.49727 .02381 L
.49763 .02381 L
.49822 .02381 L
.49885 .02381 L
.49945 .02381 L
.5 .02381 L
Mfstroke
.02381 .50238 m
.0244 .57364 L
.02493 .59133 L
.02555 .60565 L
.02613 .6163 L
.0283 .64462 L
.02952 .6566 L
.03065 .66619 L
.03321 .68441 L
.03803 .71093 L
.04313 .73279 L
.05315 .76569 L
.06419 .79321 L
.08434 .83069 L
.10372 .85766 L
.12434 .88021 L
.14419 .89777 L
.16329 .91175 L
.18361 .92415 L
.20317 .93414 L
.22397 .94302 L
.244 .95013 L
.26327 .95583 L
.28378 .96084 L
.30352 .96477 L
.32251 .96782 L
.34272 .9704 L
.36217 .97231 L
.37208 .97309 L
.38285 .97382 L
.40278 .97484 L
.41266 .97521 L
.42317 .97552 L
.4329 .97575 L
.44204 .9759 L
.44696 .97597 L
.45213 .97603 L
.45698 .97607 L
.46139 .97611 L
.46616 .97613 L
.47126 .97616 L
.47352 .97616 L
.47598 .97617 L
.48044 .97618 L
.48278 .97618 L
.48496 .97619 L
.48736 .97619 L
.48871 .97619 L
.48994 .97619 L
.49122 .97619 L
Mistroke
.49241 .97619 L
.49371 .97619 L
.49444 .97619 L
.4951 .97619 L
.49573 .97619 L
.49631 .97619 L
.49695 .97619 L
.49727 .97619 L
.49763 .97619 L
.49822 .97619 L
.49885 .97619 L
.49945 .97619 L
.5 .97619 L
Mfstroke
.5 .02381 m
.50059 .02381 L
.50112 .02381 L
.50174 .02381 L
.50232 .02381 L
.50286 .02381 L
.50336 .02381 L
.50391 .02381 L
.50449 .02381 L
.50507 .02381 L
.5057 .02381 L
.50683 .02381 L
.50752 .02381 L
.50817 .02381 L
.5094 .02381 L
.51059 .02381 L
.51186 .02381 L
.51414 .02381 L
.51554 .02382 L
.51686 .02382 L
.51932 .02382 L
.52188 .02382 L
.52459 .02383 L
.52944 .02385 L
.53466 .02387 L
.54039 .02391 L
.54549 .02395 L
.55014 .02399 L
.5606 .02414 L
.57014 .02432 L
.58052 .02458 L
.59041 .0249 L
.60091 .02532 L
.61979 .02635 L
.63989 .02787 L
.65923 .02982 L
.6798 .03251 L
.69961 .0358 L
.71867 .0397 L
.73895 .04477 L
.75847 .05068 L
.77922 .05824 L
.79921 .06698 L
.81844 .077 L
.8389 .08973 L
.8586 .1045 L
.87755 .12164 L
.89772 .14413 L
.91713 .17165 L
.927 .18885 L
Mistroke
.93777 .21121 L
.94808 .23786 L
.95765 .27024 L
.96266 .29243 L
.96512 .30551 L
.96738 .31947 L
.9694 .33425 L
.97161 .35446 L
.97269 .36679 L
.97384 .38328 L
.97448 .3949 L
.97506 .40837 L
.97564 .42792 L
.97619 .49762 L
Mfstroke
.5 .97619 m
.50059 .97619 L
.50112 .97619 L
.50174 .97619 L
.50232 .97619 L
.50286 .97619 L
.50336 .97619 L
.50391 .97619 L
.50449 .97619 L
.50507 .97619 L
.5057 .97619 L
.50683 .97619 L
.50752 .97619 L
.50817 .97619 L
.5094 .97619 L
.51059 .97619 L
.51186 .97619 L
.51414 .97619 L
.51554 .97618 L
.51686 .97618 L
.51932 .97618 L
.52188 .97618 L
.52459 .97617 L
.52944 .97615 L
.53466 .97613 L
.54039 .97609 L
.54549 .97605 L
.55014 .97601 L
.5606 .97586 L
.57014 .97568 L
.58052 .97542 L
.59041 .9751 L
.60091 .97468 L
.61979 .97365 L
.63989 .97213 L
.65923 .97018 L
.6798 .96749 L
.69961 .9642 L
.71867 .9603 L
.73895 .95523 L
.75847 .94932 L
.77922 .94176 L
.79921 .93302 L
.81844 .923 L
.8389 .91027 L
.8586 .8955 L
.87755 .87836 L
.89772 .85587 L
.91713 .82835 L
.927 .81115 L
Mistroke
.93777 .78879 L
.94808 .76214 L
.95765 .72976 L
.96266 .70757 L
.96512 .69449 L
.96738 .68053 L
.9694 .66575 L
.97161 .64554 L
.97269 .63321 L
.97384 .61672 L
.97448 .6051 L
.97506 .59163 L
.97564 .57208 L
.97619 .50238 L
Mfstroke
0 1 1 r
.5 .02381 m
.50059 .02381 L
.50112 .02381 L
.50174 .02381 L
.50232 .02381 L
.50286 .02381 L
.50336 .02381 L
.50391 .02381 L
.50449 .02381 L
.50507 .02381 L
.5057 .02381 L
.50683 .02381 L
.50752 .02381 L
.50817 .02381 L
.5094 .02381 L
.51059 .02381 L
.51186 .02381 L
.51414 .02381 L
.51554 .02382 L
.51686 .02382 L
.51932 .02382 L
.52188 .02382 L
.52459 .02383 L
.52944 .02385 L
.53466 .02387 L
.54039 .02391 L
.54549 .02395 L
.55014 .02399 L
.5606 .02414 L
.57014 .02432 L
.58052 .02458 L
.59041 .0249 L
.60091 .02532 L
.61979 .02635 L
.63989 .02787 L
.65923 .02982 L
.6798 .03251 L
.69961 .0358 L
.71867 .0397 L
.73895 .04477 L
.75847 .05068 L
.77922 .05824 L
.79921 .06698 L
.81844 .077 L
.8389 .08973 L
.8586 .1045 L
.87755 .12164 L
.89772 .14413 L
.91713 .17165 L
.927 .18885 L
.93777 .21121 L
.94808 .23786 L
.95765 .27024 L
.96266 .29243 L
.96512 .30551 L
.96738 .31947 L
.9694 .33425 L
.97161 .35446 L
.97269 .36679 L
.97384 .38328 L
.97448 .3949 L
.97506 .40837 L
.97564 .42792 L
.97619 .49762 L
.97619 .50238 L
.97564 .57208 L
.97506 .59163 L
.97448 .6051 L
.97384 .61672 L
.97269 .63321 L
.97161 .64554 L
.9694 .66575 L
.96738 .68053 L
.96512 .69449 L
.96266 .70757 L
.95765 .72976 L
.94808 .76214 L
.93777 .78879 L
.927 .81115 L
.91713 .82835 L
.89772 .85587 L
.87755 .87836 L
.8586 .8955 L
.8389 .91027 L
.81844 .923 L
.79921 .93302 L
.77922 .94176 L
.75847 .94932 L
.73895 .95523 L
.71867 .9603 L
.69961 .9642 L
.6798 .96749 L
.65923 .97018 L
.63989 .97213 L
.61979 .97365 L
.60091 .97468 L
.59041 .9751 L
.58052 .97542 L
.57014 .97568 L
.5606 .97586 L
.55014 .97601 L
.54549 .97605 L
.54039 .97609 L
.53466 .97613 L
.52944 .97615 L
.52459 .97617 L
.52188 .97618 L
.51932 .97618 L
.51686 .97618 L
.51554 .97618 L
.51414 .97619 L
.51186 .97619 L
.51059 .97619 L
.5094 .97619 L
.50817 .97619 L
.50752 .97619 L
.50683 .97619 L
.5057 .97619 L
.50507 .97619 L
.50449 .97619 L
.50391 .97619 L
.50336 .97619 L
.50286 .97619 L
.50232 .97619 L
.50174 .97619 L
.50112 .97619 L
.50059 .97619 L
.5 .97619 L
F
0 g
.5 .02381 m
.50059 .02381 L
.50112 .02381 L
.50174 .02381 L
.50232 .02381 L
.50286 .02381 L
.50336 .02381 L
.50391 .02381 L
.50449 .02381 L
.50507 .02381 L
.5057 .02381 L
.50683 .02381 L
.50752 .02381 L
.50817 .02381 L
.5094 .02381 L
.51059 .02381 L
.51186 .02381 L
.51414 .02381 L
.51554 .02382 L
.51686 .02382 L
.51932 .02382 L
.52188 .02382 L
.52459 .02383 L
.52944 .02385 L
.53466 .02387 L
.54039 .02391 L
.54549 .02395 L
.55014 .02399 L
.5606 .02414 L
.57014 .02432 L
.58052 .02458 L
.59041 .0249 L
.60091 .02532 L
.61979 .02635 L
.63989 .02787 L
.65923 .02982 L
.6798 .03251 L
.69961 .0358 L
.71867 .0397 L
.73895 .04477 L
.75847 .05068 L
.77922 .05824 L
.79921 .06698 L
.81844 .077 L
.8389 .08973 L
.8586 .1045 L
.87755 .12164 L
.89772 .14413 L
.91713 .17165 L
.927 .18885 L
Mistroke
.93777 .21121 L
.94808 .23786 L
.95765 .27024 L
.96266 .29243 L
.96512 .30551 L
.96738 .31947 L
.9694 .33425 L
.97161 .35446 L
.97269 .36679 L
.97384 .38328 L
.97448 .3949 L
.97506 .40837 L
.97564 .42792 L
.97619 .49762 L
Mfstroke
.5 .97619 m
.50059 .97619 L
.50112 .97619 L
.50174 .97619 L
.50232 .97619 L
.50286 .97619 L
.50336 .97619 L
.50391 .97619 L
.50449 .97619 L
.50507 .97619 L
.5057 .97619 L
.50683 .97619 L
.50752 .97619 L
.50817 .97619 L
.5094 .97619 L
.51059 .97619 L
.51186 .97619 L
.51414 .97619 L
.51554 .97618 L
.51686 .97618 L
.51932 .97618 L
.52188 .97618 L
.52459 .97617 L
.52944 .97615 L
.53466 .97613 L
.54039 .97609 L
.54549 .97605 L
.55014 .97601 L
.5606 .97586 L
.57014 .97568 L
.58052 .97542 L
.59041 .9751 L
.60091 .97468 L
.61979 .97365 L
.63989 .97213 L
.65923 .97018 L
.6798 .96749 L
.69961 .9642 L
.71867 .9603 L
.73895 .95523 L
.75847 .94932 L
.77922 .94176 L
.79921 .93302 L
.81844 .923 L
.8389 .91027 L
.8586 .8955 L
.87755 .87836 L
.89772 .85587 L
.91713 .82835 L
.927 .81115 L
Mistroke
.93777 .78879 L
.94808 .76214 L
.95765 .72976 L
.96266 .70757 L
.96512 .69449 L
.96738 .68053 L
.9694 .66575 L
.97161 .64554 L
.97269 .63321 L
.97384 .61672 L
.97448 .6051 L
.97506 .59163 L
.97564 .57208 L
.97619 .50238 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 1 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.47619 0.5 0.47619 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .5 m
1 .5 L
s
.5 0 m
.5 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.754707 0.267442 0.97619 0.488926 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 1 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.47619 0.5 0.47619 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .5 m
1 .5 L
s
.5 0 m
.5 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 Mabswid
.02381 .49105 m
.0244 .38257 L
.02493 .36199 L
.02555 .34606 L
.02613 .33457 L
.02717 .31867 L
.0283 .30519 L
.03085 .28225 L
.03321 .26623 L
.03803 .24144 L
.04313 .2216 L
.05315 .19258 L
.06419 .169 L
.08434 .13775 L
.10372 .11581 L
.12434 .09778 L
.14419 .08393 L
.16329 .07301 L
.18361 .0634 L
.20317 .05571 L
.22397 .04891 L
.244 .04349 L
.26327 .03916 L
.28378 .03537 L
.30352 .0324 L
.32251 .0301 L
.34272 .02816 L
.36217 .02672 L
.37208 .02613 L
.38285 .02559 L
.40278 .02483 L
.41266 .02455 L
.42317 .02431 L
.4329 .02414 L
.44204 .02402 L
.44696 .02397 L
.45213 .02393 L
.45698 .0239 L
.46139 .02387 L
.46616 .02385 L
.47126 .02384 L
.47352 .02383 L
.47598 .02382 L
.48044 .02382 L
.48278 .02382 L
.48496 .02381 L
.48736 .02381 L
.48871 .02381 L
.48994 .02381 L
.49122 .02381 L
Mistroke
.49241 .02381 L
.49371 .02381 L
.49444 .02381 L
.4951 .02381 L
.49573 .02381 L
.49631 .02381 L
.49695 .02381 L
.49727 .02381 L
.49763 .02381 L
.49822 .02381 L
.49885 .02381 L
.49945 .02381 L
.5 .02381 L
Mfstroke
.02381 .50895 m
.0244 .61743 L
.02493 .63801 L
.02555 .65394 L
.02613 .66543 L
.02717 .68133 L
.0283 .69481 L
.03085 .71775 L
.03321 .73377 L
.03803 .75856 L
.04313 .7784 L
.05315 .80742 L
.06419 .831 L
.08434 .86225 L
.10372 .88419 L
.12434 .90222 L
.14419 .91607 L
.16329 .92699 L
.18361 .9366 L
.20317 .94429 L
.22397 .95109 L
.244 .95651 L
.26327 .96084 L
.28378 .96463 L
.30352 .9676 L
.32251 .9699 L
.34272 .97184 L
.36217 .97328 L
.37208 .97387 L
.38285 .97441 L
.40278 .97517 L
.41266 .97545 L
.42317 .97569 L
.4329 .97586 L
.44204 .97598 L
.44696 .97603 L
.45213 .97607 L
.45698 .9761 L
.46139 .97613 L
.46616 .97615 L
.47126 .97616 L
.47352 .97617 L
.47598 .97618 L
.48044 .97618 L
.48278 .97618 L
.48496 .97619 L
.48736 .97619 L
.48871 .97619 L
.48994 .97619 L
.49122 .97619 L
Mistroke
.49241 .97619 L
.49371 .97619 L
.49444 .97619 L
.4951 .97619 L
.49573 .97619 L
.49631 .97619 L
.49695 .97619 L
.49727 .97619 L
.49763 .97619 L
.49822 .97619 L
.49885 .97619 L
.49945 .97619 L
.5 .97619 L
Mfstroke
0 1 1 r
.02381 .49105 m
.0244 .38257 L
.02493 .36199 L
.02555 .34606 L
.02613 .33457 L
.02717 .31867 L
.0283 .30519 L
.03085 .28225 L
.03321 .26623 L
.03803 .24144 L
.04313 .2216 L
.05315 .19258 L
.06419 .169 L
.08434 .13775 L
.10372 .11581 L
.12434 .09778 L
.14419 .08393 L
.16329 .07301 L
.18361 .0634 L
.20317 .05571 L
.22397 .04891 L
.244 .04349 L
.26327 .03916 L
.28378 .03537 L
.30352 .0324 L
.32251 .0301 L
.34272 .02816 L
.36217 .02672 L
.37208 .02613 L
.38285 .02559 L
.40278 .02483 L
.41266 .02455 L
.42317 .02431 L
.4329 .02414 L
.44204 .02402 L
.44696 .02397 L
.45213 .02393 L
.45698 .0239 L
.46139 .02387 L
.46616 .02385 L
.47126 .02384 L
.47352 .02383 L
.47598 .02382 L
.48044 .02382 L
.48278 .02382 L
.48496 .02381 L
.48736 .02381 L
.48871 .02381 L
.48994 .02381 L
.49122 .02381 L
.49241 .02381 L
.49371 .02381 L
.49444 .02381 L
.4951 .02381 L
.49573 .02381 L
.49631 .02381 L
.49695 .02381 L
.49727 .02381 L
.49763 .02381 L
.49822 .02381 L
.49885 .02381 L
.49945 .02381 L
.5 .02381 L
.5 .97619 L
.49945 .97619 L
.49885 .97619 L
.49822 .97619 L
.49763 .97619 L
.49727 .97619 L
.49695 .97619 L
.49631 .97619 L
.49573 .97619 L
.4951 .97619 L
.49444 .97619 L
.49371 .97619 L
.49241 .97619 L
.49122 .97619 L
.48994 .97619 L
.48871 .97619 L
.48736 .97619 L
.48496 .97619 L
.48278 .97618 L
.48044 .97618 L
.47598 .97618 L
.47352 .97617 L
.47126 .97616 L
.46616 .97615 L
.46139 .97613 L
.45698 .9761 L
.45213 .97607 L
.44696 .97603 L
.44204 .97598 L
.4329 .97586 L
.42317 .97569 L
.41266 .97545 L
.40278 .97517 L
.38285 .97441 L
.37208 .97387 L
.36217 .97328 L
.34272 .97184 L
.32251 .9699 L
.30352 .9676 L
.28378 .96463 L
.26327 .96084 L
.244 .95651 L
.22397 .95109 L
.20317 .94429 L
.18361 .9366 L
.16329 .92699 L
.14419 .91607 L
.12434 .90222 L
.10372 .88419 L
.08434 .86225 L
.06419 .831 L
.05315 .80742 L
.04313 .7784 L
.03803 .75856 L
.03321 .73377 L
.03085 .71775 L
.0283 .69481 L
.02717 .68133 L
.02613 .66543 L
.02555 .65394 L
.02493 .63801 L
.0244 .61743 L
.02381 .50895 L
F
0 g
.02381 .49105 m
.0244 .38257 L
.02493 .36199 L
.02555 .34606 L
.02613 .33457 L
.02717 .31867 L
.0283 .30519 L
.03085 .28225 L
.03321 .26623 L
.03803 .24144 L
.04313 .2216 L
.05315 .19258 L
.06419 .169 L
.08434 .13775 L
.10372 .11581 L
.12434 .09778 L
.14419 .08393 L
.16329 .07301 L
.18361 .0634 L
.20317 .05571 L
.22397 .04891 L
.244 .04349 L
.26327 .03916 L
.28378 .03537 L
.30352 .0324 L
.32251 .0301 L
.34272 .02816 L
.36217 .02672 L
.37208 .02613 L
.38285 .02559 L
.40278 .02483 L
.41266 .02455 L
.42317 .02431 L
.4329 .02414 L
.44204 .02402 L
.44696 .02397 L
.45213 .02393 L
.45698 .0239 L
.46139 .02387 L
.46616 .02385 L
.47126 .02384 L
.47352 .02383 L
.47598 .02382 L
.48044 .02382 L
.48278 .02382 L
.48496 .02381 L
.48736 .02381 L
.48871 .02381 L
.48994 .02381 L
.49122 .02381 L
Mistroke
.49241 .02381 L
.49371 .02381 L
.49444 .02381 L
.4951 .02381 L
.49573 .02381 L
.49631 .02381 L
.49695 .02381 L
.49727 .02381 L
.49763 .02381 L
.49822 .02381 L
.49885 .02381 L
.49945 .02381 L
.5 .02381 L
Mfstroke
.02381 .50895 m
.0244 .61743 L
.02493 .63801 L
.02555 .65394 L
.02613 .66543 L
.02717 .68133 L
.0283 .69481 L
.03085 .71775 L
.03321 .73377 L
.03803 .75856 L
.04313 .7784 L
.05315 .80742 L
.06419 .831 L
.08434 .86225 L
.10372 .88419 L
.12434 .90222 L
.14419 .91607 L
.16329 .92699 L
.18361 .9366 L
.20317 .94429 L
.22397 .95109 L
.244 .95651 L
.26327 .96084 L
.28378 .96463 L
.30352 .9676 L
.32251 .9699 L
.34272 .97184 L
.36217 .97328 L
.37208 .97387 L
.38285 .97441 L
.40278 .97517 L
.41266 .97545 L
.42317 .97569 L
.4329 .97586 L
.44204 .97598 L
.44696 .97603 L
.45213 .97607 L
.45698 .9761 L
.46139 .97613 L
.46616 .97615 L
.47126 .97616 L
.47352 .97617 L
.47598 .97618 L
.48044 .97618 L
.48278 .97618 L
.48496 .97619 L
.48736 .97619 L
.48871 .97619 L
.48994 .97619 L
.49122 .97619 L
Mistroke
.49241 .97619 L
.49371 .97619 L
.49444 .97619 L
.4951 .97619 L
.49573 .97619 L
.49631 .97619 L
.49695 .97619 L
.49727 .97619 L
.49763 .97619 L
.49822 .97619 L
.49885 .97619 L
.49945 .97619 L
.5 .97619 L
Mfstroke
.5 .02381 m
.50059 .02381 L
.50112 .02381 L
.50174 .02381 L
.50232 .02381 L
.50286 .02381 L
.50336 .02381 L
.50391 .02381 L
.50449 .02381 L
.50507 .02381 L
.5057 .02381 L
.50683 .02381 L
.50752 .02381 L
.50817 .02381 L
.5094 .02381 L
.51059 .02381 L
.51186 .02381 L
.51414 .02381 L
.51554 .02381 L
.51686 .02381 L
.51932 .02382 L
.52188 .02382 L
.52459 .02383 L
.52944 .02384 L
.53466 .02386 L
.54039 .02388 L
.54549 .02391 L
.55014 .02395 L
.5606 .02406 L
.57014 .02419 L
.58052 .02439 L
.59041 .02463 L
.60091 .02495 L
.61979 .02572 L
.63989 .02686 L
.65923 .02832 L
.6798 .03035 L
.69961 .03283 L
.71867 .03578 L
.73895 .03962 L
.75847 .04411 L
.77922 .04987 L
.79921 .05657 L
.81844 .06429 L
.8389 .07416 L
.8586 .08571 L
.87755 .09925 L
.89772 .11725 L
.91713 .13967 L
.927 .15393 L
Mistroke
.93777 .17275 L
.94808 .19567 L
.95765 .22433 L
.96266 .24454 L
.96512 .25672 L
.96738 .26993 L
.9694 .28421 L
.97161 .30426 L
.97277 .31784 L
.97384 .33412 L
.97444 .34572 L
.97498 .35925 L
.9756 .38243 L
.97619 .49105 L
Mfstroke
.5 .97619 m
.50059 .97619 L
.50112 .97619 L
.50174 .97619 L
.50232 .97619 L
.50286 .97619 L
.50336 .97619 L
.50391 .97619 L
.50449 .97619 L
.50507 .97619 L
.5057 .97619 L
.50683 .97619 L
.50752 .97619 L
.50817 .97619 L
.5094 .97619 L
.51059 .97619 L
.51186 .97619 L
.51414 .97619 L
.51554 .97619 L
.51686 .97619 L
.51932 .97618 L
.52188 .97618 L
.52459 .97617 L
.52944 .97616 L
.53466 .97614 L
.54039 .97612 L
.54549 .97609 L
.55014 .97605 L
.5606 .97595 L
.57014 .97581 L
.58052 .97561 L
.59041 .97537 L
.60091 .97505 L
.61979 .97428 L
.63989 .97314 L
.65923 .97168 L
.6798 .96965 L
.69961 .96717 L
.71867 .96422 L
.73895 .96038 L
.75847 .95589 L
.77922 .95013 L
.79921 .94343 L
.81844 .93571 L
.8389 .92584 L
.8586 .91429 L
.87755 .90075 L
.89772 .88275 L
.91713 .86033 L
.927 .84607 L
Mistroke
.93777 .82725 L
.94808 .80433 L
.95765 .77567 L
.96266 .75546 L
.96512 .74328 L
.96738 .73007 L
.9694 .71579 L
.97161 .69574 L
.97277 .68216 L
.97384 .66588 L
.97444 .65428 L
.97498 .64075 L
.9756 .61757 L
.97619 .50895 L
Mfstroke
0 1 1 r
.5 .02381 m
.50059 .02381 L
.50112 .02381 L
.50174 .02381 L
.50232 .02381 L
.50286 .02381 L
.50336 .02381 L
.50391 .02381 L
.50449 .02381 L
.50507 .02381 L
.5057 .02381 L
.50683 .02381 L
.50752 .02381 L
.50817 .02381 L
.5094 .02381 L
.51059 .02381 L
.51186 .02381 L
.51414 .02381 L
.51554 .02381 L
.51686 .02381 L
.51932 .02382 L
.52188 .02382 L
.52459 .02383 L
.52944 .02384 L
.53466 .02386 L
.54039 .02388 L
.54549 .02391 L
.55014 .02395 L
.5606 .02406 L
.57014 .02419 L
.58052 .02439 L
.59041 .02463 L
.60091 .02495 L
.61979 .02572 L
.63989 .02686 L
.65923 .02832 L
.6798 .03035 L
.69961 .03283 L
.71867 .03578 L
.73895 .03962 L
.75847 .04411 L
.77922 .04987 L
.79921 .05657 L
.81844 .06429 L
.8389 .07416 L
.8586 .08571 L
.87755 .09925 L
.89772 .11725 L
.91713 .13967 L
.927 .15393 L
.93777 .17275 L
.94808 .19567 L
.95765 .22433 L
.96266 .24454 L
.96512 .25672 L
.96738 .26993 L
.9694 .28421 L
.97161 .30426 L
.97277 .31784 L
.97384 .33412 L
.97444 .34572 L
.97498 .35925 L
.9756 .38243 L
.97619 .49105 L
.97619 .50895 L
.9756 .61757 L
.97498 .64075 L
.97444 .65428 L
.97384 .66588 L
.97277 .68216 L
.97161 .69574 L
.9694 .71579 L
.96738 .73007 L
.96512 .74328 L
.96266 .75546 L
.95765 .77567 L
.94808 .80433 L
.93777 .82725 L
.927 .84607 L
.91713 .86033 L
.89772 .88275 L
.87755 .90075 L
.8586 .91429 L
.8389 .92584 L
.81844 .93571 L
.79921 .94343 L
.77922 .95013 L
.75847 .95589 L
.73895 .96038 L
.71867 .96422 L
.69961 .96717 L
.6798 .96965 L
.65923 .97168 L
.63989 .97314 L
.61979 .97428 L
.60091 .97505 L
.59041 .97537 L
.58052 .97561 L
.57014 .97581 L
.5606 .97595 L
.55014 .97605 L
.54549 .97609 L
.54039 .97612 L
.53466 .97614 L
.52944 .97616 L
.52459 .97617 L
.52188 .97618 L
.51932 .97618 L
.51686 .97619 L
.51554 .97619 L
.51414 .97619 L
.51186 .97619 L
.51059 .97619 L
.5094 .97619 L
.50817 .97619 L
.50752 .97619 L
.50683 .97619 L
.5057 .97619 L
.50507 .97619 L
.50449 .97619 L
.50391 .97619 L
.50336 .97619 L
.50286 .97619 L
.50232 .97619 L
.50174 .97619 L
.50112 .97619 L
.50059 .97619 L
.5 .97619 L
F
0 g
.5 .02381 m
.50059 .02381 L
.50112 .02381 L
.50174 .02381 L
.50232 .02381 L
.50286 .02381 L
.50336 .02381 L
.50391 .02381 L
.50449 .02381 L
.50507 .02381 L
.5057 .02381 L
.50683 .02381 L
.50752 .02381 L
.50817 .02381 L
.5094 .02381 L
.51059 .02381 L
.51186 .02381 L
.51414 .02381 L
.51554 .02381 L
.51686 .02381 L
.51932 .02382 L
.52188 .02382 L
.52459 .02383 L
.52944 .02384 L
.53466 .02386 L
.54039 .02388 L
.54549 .02391 L
.55014 .02395 L
.5606 .02406 L
.57014 .02419 L
.58052 .02439 L
.59041 .02463 L
.60091 .02495 L
.61979 .02572 L
.63989 .02686 L
.65923 .02832 L
.6798 .03035 L
.69961 .03283 L
.71867 .03578 L
.73895 .03962 L
.75847 .04411 L
.77922 .04987 L
.79921 .05657 L
.81844 .06429 L
.8389 .07416 L
.8586 .08571 L
.87755 .09925 L
.89772 .11725 L
.91713 .13967 L
.927 .15393 L
Mistroke
.93777 .17275 L
.94808 .19567 L
.95765 .22433 L
.96266 .24454 L
.96512 .25672 L
.96738 .26993 L
.9694 .28421 L
.97161 .30426 L
.97277 .31784 L
.97384 .33412 L
.97444 .34572 L
.97498 .35925 L
.9756 .38243 L
.97619 .49105 L
Mfstroke
.5 .97619 m
.50059 .97619 L
.50112 .97619 L
.50174 .97619 L
.50232 .97619 L
.50286 .97619 L
.50336 .97619 L
.50391 .97619 L
.50449 .97619 L
.50507 .97619 L
.5057 .97619 L
.50683 .97619 L
.50752 .97619 L
.50817 .97619 L
.5094 .97619 L
.51059 .97619 L
.51186 .97619 L
.51414 .97619 L
.51554 .97619 L
.51686 .97619 L
.51932 .97618 L
.52188 .97618 L
.52459 .97617 L
.52944 .97616 L
.53466 .97614 L
.54039 .97612 L
.54549 .97609 L
.55014 .97605 L
.5606 .97595 L
.57014 .97581 L
.58052 .97561 L
.59041 .97537 L
.60091 .97505 L
.61979 .97428 L
.63989 .97314 L
.65923 .97168 L
.6798 .96965 L
.69961 .96717 L
.71867 .96422 L
.73895 .96038 L
.75847 .95589 L
.77922 .95013 L
.79921 .94343 L
.81844 .93571 L
.8389 .92584 L
.8586 .91429 L
.87755 .90075 L
.89772 .88275 L
.91713 .86033 L
.927 .84607 L
Mistroke
.93777 .82725 L
.94808 .80433 L
.95765 .77567 L
.96266 .75546 L
.96512 .74328 L
.96738 .73007 L
.9694 .71579 L
.97161 .69574 L
.97277 .68216 L
.97384 .66588 L
.97444 .65428 L
.97498 .64075 L
.9756 .61757 L
.97619 .50895 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 1 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.47619 0.5 0.47619 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .5 m
1 .5 L
s
.5 0 m
.5 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.0238095 0.511074 0.245293 0.732558 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.999999 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.999999 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.476191 0.5 0.476191 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .5 m
1 .5 L
s
.5 0 m
.5 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 Mabswid
.02381 .5 m
.06244 .42586 L
.10458 .35216 L
.14415 .28973 L
.18221 .23589 L
.22272 .18527 L
.26171 .14305 L
.30316 .10518 L
.34309 .07552 L
.3815 .0533 L
.40095 .04441 L
.42237 .03647 L
.44268 .03071 L
.45178 .02869 L
.46172 .02689 L
.4671 .02608 L
.4721 .02544 L
.47727 .02489 L
.48196 .02449 L
.48658 .02419 L
.4887 .02408 L
.49093 .02398 L
.49332 .0239 L
.49438 .02388 L
.49552 .02385 L
.49675 .02383 L
.49789 .02382 L
.49859 .02381 L
.49925 .02381 L
.50049 .02381 L
.50163 .02381 L
.50286 .02383 L
.50401 .02384 L
.50508 .02386 L
.50754 .02393 L
.51014 .02403 L
.51268 .02415 L
.51504 .02428 L
.5204 .02468 L
.5293 .02561 L
.53882 .02697 L
.54906 .02886 L
.56016 .03141 L
.58032 .03736 L
.60019 .04489 L
.62123 .05467 L
.65912 .07698 L
.69946 .10736 L
.73829 .14305 L
.77956 .18793 L
Mistroke
.81932 .23794 L
.85757 .2923 L
.89827 .3569 L
.93745 .42567 L
.97619 .5 L
Mfstroke
.02381 .5 m
.06244 .57414 L
.10458 .64784 L
.14415 .71027 L
.18221 .76411 L
.22272 .81473 L
.26171 .85695 L
.30316 .89482 L
.34309 .92448 L
.3815 .9467 L
.40095 .95559 L
.42237 .96353 L
.44268 .96929 L
.45178 .97131 L
.46172 .97311 L
.4671 .97392 L
.4721 .97455 L
.47727 .97511 L
.48196 .97551 L
.48658 .97581 L
.4887 .97592 L
.49093 .97602 L
.49332 .9761 L
.49438 .97612 L
.49552 .97615 L
.49675 .97617 L
.49789 .97618 L
.49859 .97619 L
.49925 .97619 L
.50049 .97619 L
.50163 .97618 L
.50286 .97617 L
.50401 .97616 L
.50508 .97614 L
.50754 .97607 L
.51014 .97597 L
.51268 .97585 L
.51504 .97572 L
.5204 .97532 L
.5293 .97439 L
.53882 .97303 L
.54906 .97114 L
.56016 .96859 L
.58032 .96264 L
.60019 .95511 L
.62123 .94532 L
.65912 .92302 L
.69946 .89264 L
.73829 .85695 L
.77956 .81206 L
Mistroke
.81932 .76206 L
.85757 .70769 L
.89827 .6431 L
.93745 .57433 L
.97619 .5 L
Mfstroke
0 1 1 r
.02381 .5 m
.06244 .42586 L
.10458 .35216 L
.14415 .28973 L
.18221 .23589 L
.22272 .18527 L
.26171 .14305 L
.30316 .10518 L
.34309 .07552 L
.3815 .0533 L
.40095 .04441 L
.42237 .03647 L
.44268 .03071 L
.45178 .02869 L
.46172 .02689 L
.4671 .02608 L
.4721 .02544 L
.47727 .02489 L
.48196 .02449 L
.48658 .02419 L
.4887 .02408 L
.49093 .02398 L
.49332 .0239 L
.49438 .02388 L
.49552 .02385 L
.49675 .02383 L
.49789 .02382 L
.49859 .02381 L
.49925 .02381 L
.50049 .02381 L
.50163 .02381 L
.50286 .02383 L
.50401 .02384 L
.50508 .02386 L
.50754 .02393 L
.51014 .02403 L
.51268 .02415 L
.51504 .02428 L
.5204 .02468 L
.5293 .02561 L
.53882 .02697 L
.54906 .02886 L
.56016 .03141 L
.58032 .03736 L
.60019 .04489 L
.62123 .05467 L
.65912 .07698 L
.69946 .10736 L
.73829 .14305 L
.77956 .18793 L
.81932 .23794 L
.85757 .2923 L
.89827 .3569 L
.93745 .42567 L
.97619 .5 L
.97619 .5 L
.93745 .57433 L
.89827 .6431 L
.85757 .70769 L
.81932 .76206 L
.77956 .81206 L
.73829 .85695 L
.69946 .89264 L
.65912 .92302 L
.62123 .94532 L
.60019 .95511 L
.58032 .96264 L
.56016 .96859 L
.54906 .97114 L
.53882 .97303 L
.5293 .97439 L
.5204 .97532 L
.51504 .97572 L
.51268 .97585 L
.51014 .97597 L
.50754 .97607 L
.50508 .97614 L
.50401 .97616 L
.50286 .97617 L
.50163 .97618 L
.50049 .97619 L
.49925 .97619 L
.49859 .97619 L
.49789 .97618 L
.49675 .97617 L
.49552 .97615 L
.49438 .97612 L
.49332 .9761 L
.49093 .97602 L
.4887 .97592 L
.48658 .97581 L
.48196 .97551 L
.47727 .97511 L
.4721 .97455 L
.4671 .97392 L
.46172 .97311 L
.45178 .97131 L
.44268 .96929 L
.42237 .96353 L
.40095 .95559 L
.3815 .9467 L
.34309 .92448 L
.30316 .89482 L
.26171 .85695 L
.22272 .81473 L
.18221 .76411 L
.14415 .71027 L
.10458 .64784 L
.06244 .57414 L
.02381 .5 L
F
0 g
.02381 .5 m
.06244 .42586 L
.10458 .35216 L
.14415 .28973 L
.18221 .23589 L
.22272 .18527 L
.26171 .14305 L
.30316 .10518 L
.34309 .07552 L
.3815 .0533 L
.40095 .04441 L
.42237 .03647 L
.44268 .03071 L
.45178 .02869 L
.46172 .02689 L
.4671 .02608 L
.4721 .02544 L
.47727 .02489 L
.48196 .02449 L
.48658 .02419 L
.4887 .02408 L
.49093 .02398 L
.49332 .0239 L
.49438 .02388 L
.49552 .02385 L
.49675 .02383 L
.49789 .02382 L
.49859 .02381 L
.49925 .02381 L
.50049 .02381 L
.50163 .02381 L
.50286 .02383 L
.50401 .02384 L
.50508 .02386 L
.50754 .02393 L
.51014 .02403 L
.51268 .02415 L
.51504 .02428 L
.5204 .02468 L
.5293 .02561 L
.53882 .02697 L
.54906 .02886 L
.56016 .03141 L
.58032 .03736 L
.60019 .04489 L
.62123 .05467 L
.65912 .07698 L
.69946 .10736 L
.73829 .14305 L
.77956 .18793 L
Mistroke
.81932 .23794 L
.85757 .2923 L
.89827 .3569 L
.93745 .42567 L
.97619 .5 L
Mfstroke
.02381 .5 m
.06244 .57414 L
.10458 .64784 L
.14415 .71027 L
.18221 .76411 L
.22272 .81473 L
.26171 .85695 L
.30316 .89482 L
.34309 .92448 L
.3815 .9467 L
.40095 .95559 L
.42237 .96353 L
.44268 .96929 L
.45178 .97131 L
.46172 .97311 L
.4671 .97392 L
.4721 .97455 L
.47727 .97511 L
.48196 .97551 L
.48658 .97581 L
.4887 .97592 L
.49093 .97602 L
.49332 .9761 L
.49438 .97612 L
.49552 .97615 L
.49675 .97617 L
.49789 .97618 L
.49859 .97619 L
.49925 .97619 L
.50049 .97619 L
.50163 .97618 L
.50286 .97617 L
.50401 .97616 L
.50508 .97614 L
.50754 .97607 L
.51014 .97597 L
.51268 .97585 L
.51504 .97572 L
.5204 .97532 L
.5293 .97439 L
.53882 .97303 L
.54906 .97114 L
.56016 .96859 L
.58032 .96264 L
.60019 .95511 L
.62123 .94532 L
.65912 .92302 L
.69946 .89264 L
.73829 .85695 L
.77956 .81206 L
Mistroke
.81932 .76206 L
.85757 .70769 L
.89827 .6431 L
.93745 .57433 L
.97619 .5 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.999999 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.476191 0.5 0.476191 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .5 m
1 .5 L
s
.5 0 m
.5 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.267442 0.511074 0.488926 0.732558 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 1 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.476191 0.5 0.476191 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .5 m
1 .5 L
s
.5 0 m
.5 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 Mabswid
.02381 .49981 m
.02499 .46656 L
.02605 .45381 L
.02846 .43364 L
.03279 .40798 L
.03784 .38526 L
.04262 .36749 L
.06244 .31211 L
.08265 .27071 L
.10458 .23467 L
.14545 .18212 L
.1848 .14306 L
.22263 .11293 L
.26292 .08702 L
.30169 .06707 L
.34292 .05046 L
.36351 .04379 L
.38262 .0385 L
.40229 .03394 L
.42082 .03044 L
.44134 .02744 L
.45995 .0255 L
.46971 .02477 L
.47505 .02446 L
.48003 .02423 L
.48428 .02407 L
.48883 .02394 L
.49143 .02389 L
.49271 .02387 L
.49389 .02385 L
.49494 .02384 L
.4961 .02383 L
.49726 .02382 L
.4985 .02381 L
.49971 .02381 L
.50085 .02381 L
.50209 .02381 L
.50278 .02382 L
.50341 .02382 L
.50469 .02383 L
.50608 .02385 L
.50859 .02389 L
.51093 .02393 L
.51341 .024 L
.51785 .02414 L
.52298 .02436 L
.52778 .02462 L
.5387 .02538 L
.54911 .02635 L
.55899 .02748 L
Mistroke
.57753 .03016 L
.59737 .03387 L
.61577 .0381 L
.65495 .04973 L
.69659 .06628 L
.73671 .08681 L
.77531 .11146 L
.81636 .14409 L
.8559 .18363 L
.89393 .23246 L
.91511 .26668 L
.9344 .30493 L
.944 .32789 L
.95442 .35768 L
.9592 .37394 L
.96427 .39411 L
.9686 .41529 L
.97089 .42916 L
.97336 .4482 L
.97408 .45526 L
.97484 .46416 L
.97549 .47409 L
.97619 .49981 L
Mfstroke
.02381 .50019 m
.02499 .53344 L
.02605 .54619 L
.02846 .56636 L
.03279 .59202 L
.03784 .61474 L
.04262 .63251 L
.06244 .68789 L
.08265 .72929 L
.10458 .76533 L
.14545 .81788 L
.1848 .85694 L
.22263 .88707 L
.26292 .91298 L
.30169 .93293 L
.34292 .94954 L
.36351 .95621 L
.38262 .9615 L
.40229 .96606 L
.42082 .96956 L
.44134 .97256 L
.45995 .9745 L
.46971 .97523 L
.47505 .97554 L
.48003 .97577 L
.48428 .97593 L
.48883 .97606 L
.49143 .97611 L
.49271 .97613 L
.49389 .97615 L
.49494 .97616 L
.4961 .97617 L
.49726 .97618 L
.4985 .97619 L
.49971 .97619 L
.50085 .97619 L
.50209 .97619 L
.50278 .97618 L
.50341 .97618 L
.50469 .97617 L
.50608 .97615 L
.50859 .97611 L
.51093 .97607 L
.51341 .976 L
.51785 .97586 L
.52298 .97564 L
.52778 .97538 L
.5387 .97462 L
.54911 .97365 L
.55899 .97252 L
Mistroke
.57753 .96984 L
.59737 .96613 L
.61577 .9619 L
.65495 .95027 L
.69659 .93372 L
.73671 .91319 L
.77531 .88854 L
.81636 .85591 L
.8559 .81637 L
.89393 .76754 L
.91511 .73332 L
.9344 .69507 L
.944 .67211 L
.95442 .64232 L
.9592 .62606 L
.96427 .60589 L
.9686 .58471 L
.97089 .57084 L
.97336 .5518 L
.97408 .54474 L
.97484 .53584 L
.97549 .52591 L
.97619 .50019 L
Mfstroke
0 1 1 r
.02381 .49981 m
.02499 .46656 L
.02605 .45381 L
.02846 .43364 L
.03279 .40798 L
.03784 .38526 L
.04262 .36749 L
.06244 .31211 L
.08265 .27071 L
.10458 .23467 L
.14545 .18212 L
.1848 .14306 L
.22263 .11293 L
.26292 .08702 L
.30169 .06707 L
.34292 .05046 L
.36351 .04379 L
.38262 .0385 L
.40229 .03394 L
.42082 .03044 L
.44134 .02744 L
.45995 .0255 L
.46971 .02477 L
.47505 .02446 L
.48003 .02423 L
.48428 .02407 L
.48883 .02394 L
.49143 .02389 L
.49271 .02387 L
.49389 .02385 L
.49494 .02384 L
.4961 .02383 L
.49726 .02382 L
.4985 .02381 L
.49971 .02381 L
.50085 .02381 L
.50209 .02381 L
.50278 .02382 L
.50341 .02382 L
.50469 .02383 L
.50608 .02385 L
.50859 .02389 L
.51093 .02393 L
.51341 .024 L
.51785 .02414 L
.52298 .02436 L
.52778 .02462 L
.5387 .02538 L
.54911 .02635 L
.55899 .02748 L
.57753 .03016 L
.59737 .03387 L
.61577 .0381 L
.65495 .04973 L
.69659 .06628 L
.73671 .08681 L
.77531 .11146 L
.81636 .14409 L
.8559 .18363 L
.89393 .23246 L
.91511 .26668 L
.9344 .30493 L
.944 .32789 L
.95442 .35768 L
.9592 .37394 L
.96427 .39411 L
.9686 .41529 L
.97089 .42916 L
.97336 .4482 L
.97408 .45526 L
.97484 .46416 L
.97549 .47409 L
.97619 .49981 L
.97619 .50019 L
.97549 .52591 L
.97484 .53584 L
.97408 .54474 L
.97336 .5518 L
.97089 .57084 L
.9686 .58471 L
.96427 .60589 L
.9592 .62606 L
.95442 .64232 L
.944 .67211 L
.9344 .69507 L
.91511 .73332 L
.89393 .76754 L
.8559 .81637 L
.81636 .85591 L
.77531 .88854 L
.73671 .91319 L
.69659 .93372 L
.65495 .95027 L
.61577 .9619 L
.59737 .96613 L
.57753 .96984 L
.55899 .97252 L
.54911 .97365 L
.5387 .97462 L
.52778 .97538 L
.52298 .97564 L
.51785 .97586 L
.51341 .976 L
.51093 .97607 L
.50859 .97611 L
.50608 .97615 L
.50469 .97617 L
.50341 .97618 L
.50278 .97618 L
.50209 .97619 L
.50085 .97619 L
.49971 .97619 L
.4985 .97619 L
.49726 .97618 L
.4961 .97617 L
.49494 .97616 L
.49389 .97615 L
.49271 .97613 L
.49143 .97611 L
.48883 .97606 L
.48428 .97593 L
.48003 .97577 L
.47505 .97554 L
.46971 .97523 L
.45995 .9745 L
.44134 .97256 L
.42082 .96956 L
.40229 .96606 L
.38262 .9615 L
.36351 .95621 L
.34292 .94954 L
.30169 .93293 L
.26292 .91298 L
.22263 .88707 L
.1848 .85694 L
.14545 .81788 L
.10458 .76533 L
.08265 .72929 L
.06244 .68789 L
.04262 .63251 L
.03784 .61474 L
.03279 .59202 L
.02846 .56636 L
.02605 .54619 L
.02499 .53344 L
.02381 .50019 L
F
0 g
.02381 .49981 m
.02499 .46656 L
.02605 .45381 L
.02846 .43364 L
.03279 .40798 L
.03784 .38526 L
.04262 .36749 L
.06244 .31211 L
.08265 .27071 L
.10458 .23467 L
.14545 .18212 L
.1848 .14306 L
.22263 .11293 L
.26292 .08702 L
.30169 .06707 L
.34292 .05046 L
.36351 .04379 L
.38262 .0385 L
.40229 .03394 L
.42082 .03044 L
.44134 .02744 L
.45995 .0255 L
.46971 .02477 L
.47505 .02446 L
.48003 .02423 L
.48428 .02407 L
.48883 .02394 L
.49143 .02389 L
.49271 .02387 L
.49389 .02385 L
.49494 .02384 L
.4961 .02383 L
.49726 .02382 L
.4985 .02381 L
.49971 .02381 L
.50085 .02381 L
.50209 .02381 L
.50278 .02382 L
.50341 .02382 L
.50469 .02383 L
.50608 .02385 L
.50859 .02389 L
.51093 .02393 L
.51341 .024 L
.51785 .02414 L
.52298 .02436 L
.52778 .02462 L
.5387 .02538 L
.54911 .02635 L
.55899 .02748 L
Mistroke
.57753 .03016 L
.59737 .03387 L
.61577 .0381 L
.65495 .04973 L
.69659 .06628 L
.73671 .08681 L
.77531 .11146 L
.81636 .14409 L
.8559 .18363 L
.89393 .23246 L
.91511 .26668 L
.9344 .30493 L
.944 .32789 L
.95442 .35768 L
.9592 .37394 L
.96427 .39411 L
.9686 .41529 L
.97089 .42916 L
.97336 .4482 L
.97408 .45526 L
.97484 .46416 L
.97549 .47409 L
.97619 .49981 L
Mfstroke
.02381 .50019 m
.02499 .53344 L
.02605 .54619 L
.02846 .56636 L
.03279 .59202 L
.03784 .61474 L
.04262 .63251 L
.06244 .68789 L
.08265 .72929 L
.10458 .76533 L
.14545 .81788 L
.1848 .85694 L
.22263 .88707 L
.26292 .91298 L
.30169 .93293 L
.34292 .94954 L
.36351 .95621 L
.38262 .9615 L
.40229 .96606 L
.42082 .96956 L
.44134 .97256 L
.45995 .9745 L
.46971 .97523 L
.47505 .97554 L
.48003 .97577 L
.48428 .97593 L
.48883 .97606 L
.49143 .97611 L
.49271 .97613 L
.49389 .97615 L
.49494 .97616 L
.4961 .97617 L
.49726 .97618 L
.4985 .97619 L
.49971 .97619 L
.50085 .97619 L
.50209 .97619 L
.50278 .97618 L
.50341 .97618 L
.50469 .97617 L
.50608 .97615 L
.50859 .97611 L
.51093 .97607 L
.51341 .976 L
.51785 .97586 L
.52298 .97564 L
.52778 .97538 L
.5387 .97462 L
.54911 .97365 L
.55899 .97252 L
Mistroke
.57753 .96984 L
.59737 .96613 L
.61577 .9619 L
.65495 .95027 L
.69659 .93372 L
.73671 .91319 L
.77531 .88854 L
.81636 .85591 L
.8559 .81637 L
.89393 .76754 L
.91511 .73332 L
.9344 .69507 L
.944 .67211 L
.95442 .64232 L
.9592 .62606 L
.96427 .60589 L
.9686 .58471 L
.97089 .57084 L
.97336 .5518 L
.97408 .54474 L
.97484 .53584 L
.97549 .52591 L
.97619 .50019 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 1 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.476191 0.5 0.476191 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .5 m
1 .5 L
s
.5 0 m
.5 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.511074 0.511074 0.732558 0.732558 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.999999 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.999999 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.476191 0.5 0.476191 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .5 m
1 .5 L
s
.5 0 m
.5 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 Mabswid
.02381 .49738 m
.02499 .41895 L
.02605 .39947 L
.02729 .38372 L
.02846 .372 L
.03279 .34083 L
.03524 .32764 L
.0375 .31709 L
.04262 .29703 L
.05224 .26786 L
.06244 .24383 L
.0825 .2077 L
.10458 .17756 L
.14487 .13677 L
.18364 .10782 L
.22486 .08411 L
.26457 .06628 L
.30277 .05277 L
.34341 .04163 L
.38254 .03367 L
.40395 .03036 L
.42412 .02787 L
.43389 .02689 L
.4442 .026 L
.45386 .0253 L
.46267 .02479 L
.47215 .02435 L
.47737 .02417 L
.48231 .02403 L
.48687 .02393 L
.49109 .02386 L
.49329 .02384 L
.49455 .02383 L
.49572 .02382 L
.49696 .02382 L
.49809 .02381 L
.49934 .02381 L
.50064 .02381 L
.50188 .02381 L
.50258 .02381 L
.50322 .02382 L
.5044 .02382 L
.50565 .02383 L
.50781 .02385 L
.51019 .02388 L
.51273 .02392 L
.51546 .02398 L
.52039 .0241 L
.52998 .02444 L
.53875 .02486 L
Mistroke
.55778 .02616 L
.56854 .02712 L
.57851 .02816 L
.6177 .03371 L
.63915 .03777 L
.65933 .04229 L
.69793 .05298 L
.73899 .06771 L
.77853 .08584 L
.81655 .10794 L
.85703 .1384 L
.89599 .17825 L
.91727 .20733 L
.92704 .22349 L
.9374 .24351 L
.94689 .2656 L
.95193 .27949 L
.95735 .29693 L
.96232 .31629 L
.96687 .33882 L
.96912 .3529 L
.97121 .36905 L
.97236 .37994 L
.9734 .39192 L
.97455 .40949 L
.97578 .44314 L
.97619 .49738 L
Mfstroke
.02381 .50262 m
.02499 .58105 L
.02605 .60053 L
.02729 .61628 L
.02846 .628 L
.03279 .65917 L
.03524 .67236 L
.0375 .68291 L
.04262 .70297 L
.05224 .73214 L
.06244 .75617 L
.0825 .7923 L
.10458 .82244 L
.14487 .86323 L
.18364 .89218 L
.22486 .91589 L
.26457 .93372 L
.30277 .94723 L
.34341 .95837 L
.38254 .96633 L
.40395 .96964 L
.42412 .97213 L
.43389 .97311 L
.4442 .974 L
.45386 .9747 L
.46267 .97521 L
.47215 .97565 L
.47737 .97583 L
.48231 .97597 L
.48687 .97607 L
.49109 .97613 L
.49329 .97616 L
.49455 .97617 L
.49572 .97618 L
.49696 .97618 L
.49809 .97619 L
.49934 .97619 L
.50064 .97619 L
.50188 .97619 L
.50258 .97619 L
.50322 .97618 L
.5044 .97618 L
.50565 .97617 L
.50781 .97615 L
.51019 .97612 L
.51273 .97608 L
.51546 .97602 L
.52039 .9759 L
.52998 .97556 L
.53875 .97514 L
Mistroke
.55778 .97384 L
.56854 .97288 L
.57851 .97184 L
.6177 .96629 L
.63915 .96223 L
.65933 .95771 L
.69793 .94701 L
.73899 .93229 L
.77853 .91415 L
.81655 .89206 L
.85703 .8616 L
.89599 .82175 L
.91727 .79267 L
.92704 .77651 L
.9374 .75649 L
.94689 .7344 L
.95193 .72051 L
.95735 .70307 L
.96232 .68371 L
.96687 .66118 L
.96912 .6471 L
.97121 .63095 L
.97236 .62006 L
.9734 .60808 L
.97455 .59051 L
.97578 .55686 L
.97619 .50262 L
Mfstroke
0 1 1 r
.02381 .49738 m
.02499 .41895 L
.02605 .39947 L
.02729 .38372 L
.02846 .372 L
.03279 .34083 L
.03524 .32764 L
.0375 .31709 L
.04262 .29703 L
.05224 .26786 L
.06244 .24383 L
.0825 .2077 L
.10458 .17756 L
.14487 .13677 L
.18364 .10782 L
.22486 .08411 L
.26457 .06628 L
.30277 .05277 L
.34341 .04163 L
.38254 .03367 L
.40395 .03036 L
.42412 .02787 L
.43389 .02689 L
.4442 .026 L
.45386 .0253 L
.46267 .02479 L
.47215 .02435 L
.47737 .02417 L
.48231 .02403 L
.48687 .02393 L
.49109 .02386 L
.49329 .02384 L
.49455 .02383 L
.49572 .02382 L
.49696 .02382 L
.49809 .02381 L
.49934 .02381 L
.50064 .02381 L
.50188 .02381 L
.50258 .02381 L
.50322 .02382 L
.5044 .02382 L
.50565 .02383 L
.50781 .02385 L
.51019 .02388 L
.51273 .02392 L
.51546 .02398 L
.52039 .0241 L
.52998 .02444 L
.53875 .02486 L
.55778 .02616 L
.56854 .02712 L
.57851 .02816 L
.6177 .03371 L
.63915 .03777 L
.65933 .04229 L
.69793 .05298 L
.73899 .06771 L
.77853 .08584 L
.81655 .10794 L
.85703 .1384 L
.89599 .17825 L
.91727 .20733 L
.92704 .22349 L
.9374 .24351 L
.94689 .2656 L
.95193 .27949 L
.95735 .29693 L
.96232 .31629 L
.96687 .33882 L
.96912 .3529 L
.97121 .36905 L
.97236 .37994 L
.9734 .39192 L
.97455 .40949 L
.97578 .44314 L
.97619 .49738 L
.97619 .50262 L
.97578 .55686 L
.97455 .59051 L
.9734 .60808 L
.97236 .62006 L
.97121 .63095 L
.96912 .6471 L
.96687 .66118 L
.96232 .68371 L
.95735 .70307 L
.95193 .72051 L
.94689 .7344 L
.9374 .75649 L
.92704 .77651 L
.91727 .79267 L
.89599 .82175 L
.85703 .8616 L
.81655 .89206 L
.77853 .91415 L
.73899 .93229 L
.69793 .94701 L
.65933 .95771 L
.63915 .96223 L
.6177 .96629 L
.57851 .97184 L
.56854 .97288 L
.55778 .97384 L
.53875 .97514 L
.52998 .97556 L
.52039 .9759 L
.51546 .97602 L
.51273 .97608 L
.51019 .97612 L
.50781 .97615 L
.50565 .97617 L
.5044 .97618 L
.50322 .97618 L
.50258 .97619 L
.50188 .97619 L
.50064 .97619 L
.49934 .97619 L
.49809 .97619 L
.49696 .97618 L
.49572 .97618 L
.49455 .97617 L
.49329 .97616 L
.49109 .97613 L
.48687 .97607 L
.48231 .97597 L
.47737 .97583 L
.47215 .97565 L
.46267 .97521 L
.45386 .9747 L
.4442 .974 L
.43389 .97311 L
.42412 .97213 L
.40395 .96964 L
.38254 .96633 L
.34341 .95837 L
.30277 .94723 L
.26457 .93372 L
.22486 .91589 L
.18364 .89218 L
.14487 .86323 L
.10458 .82244 L
.0825 .7923 L
.06244 .75617 L
.05224 .73214 L
.04262 .70297 L
.0375 .68291 L
.03524 .67236 L
.03279 .65917 L
.02846 .628 L
.02729 .61628 L
.02605 .60053 L
.02499 .58105 L
.02381 .50262 L
F
0 g
.02381 .49738 m
.02499 .41895 L
.02605 .39947 L
.02729 .38372 L
.02846 .372 L
.03279 .34083 L
.03524 .32764 L
.0375 .31709 L
.04262 .29703 L
.05224 .26786 L
.06244 .24383 L
.0825 .2077 L
.10458 .17756 L
.14487 .13677 L
.18364 .10782 L
.22486 .08411 L
.26457 .06628 L
.30277 .05277 L
.34341 .04163 L
.38254 .03367 L
.40395 .03036 L
.42412 .02787 L
.43389 .02689 L
.4442 .026 L
.45386 .0253 L
.46267 .02479 L
.47215 .02435 L
.47737 .02417 L
.48231 .02403 L
.48687 .02393 L
.49109 .02386 L
.49329 .02384 L
.49455 .02383 L
.49572 .02382 L
.49696 .02382 L
.49809 .02381 L
.49934 .02381 L
.50064 .02381 L
.50188 .02381 L
.50258 .02381 L
.50322 .02382 L
.5044 .02382 L
.50565 .02383 L
.50781 .02385 L
.51019 .02388 L
.51273 .02392 L
.51546 .02398 L
.52039 .0241 L
.52998 .02444 L
.53875 .02486 L
Mistroke
.55778 .02616 L
.56854 .02712 L
.57851 .02816 L
.6177 .03371 L
.63915 .03777 L
.65933 .04229 L
.69793 .05298 L
.73899 .06771 L
.77853 .08584 L
.81655 .10794 L
.85703 .1384 L
.89599 .17825 L
.91727 .20733 L
.92704 .22349 L
.9374 .24351 L
.94689 .2656 L
.95193 .27949 L
.95735 .29693 L
.96232 .31629 L
.96687 .33882 L
.96912 .3529 L
.97121 .36905 L
.97236 .37994 L
.9734 .39192 L
.97455 .40949 L
.97578 .44314 L
.97619 .49738 L
Mfstroke
.02381 .50262 m
.02499 .58105 L
.02605 .60053 L
.02729 .61628 L
.02846 .628 L
.03279 .65917 L
.03524 .67236 L
.0375 .68291 L
.04262 .70297 L
.05224 .73214 L
.06244 .75617 L
.0825 .7923 L
.10458 .82244 L
.14487 .86323 L
.18364 .89218 L
.22486 .91589 L
.26457 .93372 L
.30277 .94723 L
.34341 .95837 L
.38254 .96633 L
.40395 .96964 L
.42412 .97213 L
.43389 .97311 L
.4442 .974 L
.45386 .9747 L
.46267 .97521 L
.47215 .97565 L
.47737 .97583 L
.48231 .97597 L
.48687 .97607 L
.49109 .97613 L
.49329 .97616 L
.49455 .97617 L
.49572 .97618 L
.49696 .97618 L
.49809 .97619 L
.49934 .97619 L
.50064 .97619 L
.50188 .97619 L
.50258 .97619 L
.50322 .97618 L
.5044 .97618 L
.50565 .97617 L
.50781 .97615 L
.51019 .97612 L
.51273 .97608 L
.51546 .97602 L
.52039 .9759 L
.52998 .97556 L
.53875 .97514 L
Mistroke
.55778 .97384 L
.56854 .97288 L
.57851 .97184 L
.6177 .96629 L
.63915 .96223 L
.65933 .95771 L
.69793 .94701 L
.73899 .93229 L
.77853 .91415 L
.81655 .89206 L
.85703 .8616 L
.89599 .82175 L
.91727 .79267 L
.92704 .77651 L
.9374 .75649 L
.94689 .7344 L
.95193 .72051 L
.95735 .70307 L
.96232 .68371 L
.96687 .66118 L
.96912 .6471 L
.97121 .63095 L
.97236 .62006 L
.9734 .60808 L
.97455 .59051 L
.97578 .55686 L
.97619 .50262 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.999999 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.476191 0.5 0.476191 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .5 m
1 .5 L
s
.5 0 m
.5 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.754707 0.511074 0.97619 0.732558 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 1 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.476191 0.5 0.476191 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .5 m
1 .5 L
s
.5 0 m
.5 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 Mabswid
.02381 .49038 m
.02499 .37381 L
.02605 .3517 L
.02729 .33458 L
.02846 .32223 L
.03053 .30514 L
.03279 .29067 L
.0379 .26601 L
.04262 .2488 L
.05224 .22219 L
.06244 .20088 L
.0825 .16977 L
.10458 .14455 L
.14487 .11133 L
.18364 .08832 L
.22486 .06979 L
.26457 .05603 L
.30277 .0457 L
.34341 .03724 L
.38254 .03122 L
.40395 .02873 L
.42412 .02686 L
.43389 .02612 L
.4442 .02545 L
.45386 .02493 L
.46267 .02454 L
.47215 .02422 L
.47737 .02408 L
.48231 .02397 L
.48687 .0239 L
.49109 .02385 L
.49329 .02383 L
.49455 .02382 L
.49572 .02382 L
.49696 .02381 L
.49809 .02381 L
.49934 .02381 L
.50064 .02381 L
.50188 .02381 L
.50258 .02381 L
.50322 .02381 L
.5044 .02382 L
.50565 .02383 L
.50781 .02384 L
.51019 .02386 L
.51273 .02389 L
.51546 .02393 L
.52039 .02403 L
.52998 .02428 L
.53875 .0246 L
Mistroke
.55778 .02557 L
.56854 .02629 L
.57851 .02708 L
.6177 .03125 L
.63915 .03432 L
.65933 .03774 L
.69793 .04586 L
.73899 .05713 L
.77853 .07114 L
.81655 .08842 L
.85703 .11264 L
.89599 .14512 L
.91727 .16946 L
.92704 .18324 L
.9374 .2006 L
.94689 .22016 L
.95193 .23269 L
.95735 .2487 L
.96232 .2669 L
.96449 .27649 L
.96687 .28868 L
.96897 .30165 L
.97121 .31917 L
.97246 .33164 L
.97358 .34606 L
.97472 .36648 L
.97578 .40327 L
.97619 .49038 L
Mfstroke
.02381 .50962 m
.02499 .62619 L
.02605 .6483 L
.02729 .66542 L
.02846 .67777 L
.03053 .69486 L
.03279 .70933 L
.0379 .73399 L
.04262 .7512 L
.05224 .77781 L
.06244 .79912 L
.0825 .83023 L
.10458 .85545 L
.14487 .88867 L
.18364 .91168 L
.22486 .93021 L
.26457 .94397 L
.30277 .9543 L
.34341 .96276 L
.38254 .96878 L
.40395 .97127 L
.42412 .97314 L
.43389 .97388 L
.4442 .97455 L
.45386 .97507 L
.46267 .97546 L
.47215 .97578 L
.47737 .97592 L
.48231 .97603 L
.48687 .9761 L
.49109 .97615 L
.49329 .97617 L
.49455 .97617 L
.49572 .97618 L
.49696 .97619 L
.49809 .97619 L
.49934 .97619 L
.50064 .97619 L
.50188 .97619 L
.50258 .97619 L
.50322 .97618 L
.5044 .97618 L
.50565 .97617 L
.50781 .97616 L
.51019 .97614 L
.51273 .97611 L
.51546 .97606 L
.52039 .97597 L
.52998 .97572 L
.53875 .9754 L
Mistroke
.55778 .97443 L
.56854 .9737 L
.57851 .97292 L
.6177 .96875 L
.63915 .96568 L
.65933 .96226 L
.69793 .95414 L
.73899 .94287 L
.77853 .92886 L
.81655 .91158 L
.85703 .88736 L
.89599 .85488 L
.91727 .83054 L
.92704 .81676 L
.9374 .7994 L
.94689 .77984 L
.95193 .76731 L
.95735 .75129 L
.96232 .7331 L
.96449 .72351 L
.96687 .71132 L
.96897 .69835 L
.97121 .68083 L
.97246 .66836 L
.97358 .65394 L
.97472 .63352 L
.97578 .59673 L
.97619 .50962 L
Mfstroke
0 1 1 r
.02381 .49038 m
.02499 .37381 L
.02605 .3517 L
.02729 .33458 L
.02846 .32223 L
.03053 .30514 L
.03279 .29067 L
.0379 .26601 L
.04262 .2488 L
.05224 .22219 L
.06244 .20088 L
.0825 .16977 L
.10458 .14455 L
.14487 .11133 L
.18364 .08832 L
.22486 .06979 L
.26457 .05603 L
.30277 .0457 L
.34341 .03724 L
.38254 .03122 L
.40395 .02873 L
.42412 .02686 L
.43389 .02612 L
.4442 .02545 L
.45386 .02493 L
.46267 .02454 L
.47215 .02422 L
.47737 .02408 L
.48231 .02397 L
.48687 .0239 L
.49109 .02385 L
.49329 .02383 L
.49455 .02382 L
.49572 .02382 L
.49696 .02381 L
.49809 .02381 L
.49934 .02381 L
.50064 .02381 L
.50188 .02381 L
.50258 .02381 L
.50322 .02381 L
.5044 .02382 L
.50565 .02383 L
.50781 .02384 L
.51019 .02386 L
.51273 .02389 L
.51546 .02393 L
.52039 .02403 L
.52998 .02428 L
.53875 .0246 L
.55778 .02557 L
.56854 .02629 L
.57851 .02708 L
.6177 .03125 L
.63915 .03432 L
.65933 .03774 L
.69793 .04586 L
.73899 .05713 L
.77853 .07114 L
.81655 .08842 L
.85703 .11264 L
.89599 .14512 L
.91727 .16946 L
.92704 .18324 L
.9374 .2006 L
.94689 .22016 L
.95193 .23269 L
.95735 .2487 L
.96232 .2669 L
.96449 .27649 L
.96687 .28868 L
.96897 .30165 L
.97121 .31917 L
.97246 .33164 L
.97358 .34606 L
.97472 .36648 L
.97578 .40327 L
.97619 .49038 L
.97619 .50962 L
.97578 .59673 L
.97472 .63352 L
.97358 .65394 L
.97246 .66836 L
.97121 .68083 L
.96897 .69835 L
.96687 .71132 L
.96449 .72351 L
.96232 .7331 L
.95735 .75129 L
.95193 .76731 L
.94689 .77984 L
.9374 .7994 L
.92704 .81676 L
.91727 .83054 L
.89599 .85488 L
.85703 .88736 L
.81655 .91158 L
.77853 .92886 L
.73899 .94287 L
.69793 .95414 L
.65933 .96226 L
.63915 .96568 L
.6177 .96875 L
.57851 .97292 L
.56854 .9737 L
.55778 .97443 L
.53875 .9754 L
.52998 .97572 L
.52039 .97597 L
.51546 .97606 L
.51273 .97611 L
.51019 .97614 L
.50781 .97616 L
.50565 .97617 L
.5044 .97618 L
.50322 .97618 L
.50258 .97619 L
.50188 .97619 L
.50064 .97619 L
.49934 .97619 L
.49809 .97619 L
.49696 .97619 L
.49572 .97618 L
.49455 .97617 L
.49329 .97617 L
.49109 .97615 L
.48687 .9761 L
.48231 .97603 L
.47737 .97592 L
.47215 .97578 L
.46267 .97546 L
.45386 .97507 L
.4442 .97455 L
.43389 .97388 L
.42412 .97314 L
.40395 .97127 L
.38254 .96878 L
.34341 .96276 L
.30277 .9543 L
.26457 .94397 L
.22486 .93021 L
.18364 .91168 L
.14487 .88867 L
.10458 .85545 L
.0825 .83023 L
.06244 .79912 L
.05224 .77781 L
.04262 .7512 L
.0379 .73399 L
.03279 .70933 L
.03053 .69486 L
.02846 .67777 L
.02729 .66542 L
.02605 .6483 L
.02499 .62619 L
.02381 .50962 L
F
0 g
.02381 .49038 m
.02499 .37381 L
.02605 .3517 L
.02729 .33458 L
.02846 .32223 L
.03053 .30514 L
.03279 .29067 L
.0379 .26601 L
.04262 .2488 L
.05224 .22219 L
.06244 .20088 L
.0825 .16977 L
.10458 .14455 L
.14487 .11133 L
.18364 .08832 L
.22486 .06979 L
.26457 .05603 L
.30277 .0457 L
.34341 .03724 L
.38254 .03122 L
.40395 .02873 L
.42412 .02686 L
.43389 .02612 L
.4442 .02545 L
.45386 .02493 L
.46267 .02454 L
.47215 .02422 L
.47737 .02408 L
.48231 .02397 L
.48687 .0239 L
.49109 .02385 L
.49329 .02383 L
.49455 .02382 L
.49572 .02382 L
.49696 .02381 L
.49809 .02381 L
.49934 .02381 L
.50064 .02381 L
.50188 .02381 L
.50258 .02381 L
.50322 .02381 L
.5044 .02382 L
.50565 .02383 L
.50781 .02384 L
.51019 .02386 L
.51273 .02389 L
.51546 .02393 L
.52039 .02403 L
.52998 .02428 L
.53875 .0246 L
Mistroke
.55778 .02557 L
.56854 .02629 L
.57851 .02708 L
.6177 .03125 L
.63915 .03432 L
.65933 .03774 L
.69793 .04586 L
.73899 .05713 L
.77853 .07114 L
.81655 .08842 L
.85703 .11264 L
.89599 .14512 L
.91727 .16946 L
.92704 .18324 L
.9374 .2006 L
.94689 .22016 L
.95193 .23269 L
.95735 .2487 L
.96232 .2669 L
.96449 .27649 L
.96687 .28868 L
.96897 .30165 L
.97121 .31917 L
.97246 .33164 L
.97358 .34606 L
.97472 .36648 L
.97578 .40327 L
.97619 .49038 L
Mfstroke
.02381 .50962 m
.02499 .62619 L
.02605 .6483 L
.02729 .66542 L
.02846 .67777 L
.03053 .69486 L
.03279 .70933 L
.0379 .73399 L
.04262 .7512 L
.05224 .77781 L
.06244 .79912 L
.0825 .83023 L
.10458 .85545 L
.14487 .88867 L
.18364 .91168 L
.22486 .93021 L
.26457 .94397 L
.30277 .9543 L
.34341 .96276 L
.38254 .96878 L
.40395 .97127 L
.42412 .97314 L
.43389 .97388 L
.4442 .97455 L
.45386 .97507 L
.46267 .97546 L
.47215 .97578 L
.47737 .97592 L
.48231 .97603 L
.48687 .9761 L
.49109 .97615 L
.49329 .97617 L
.49455 .97617 L
.49572 .97618 L
.49696 .97619 L
.49809 .97619 L
.49934 .97619 L
.50064 .97619 L
.50188 .97619 L
.50258 .97619 L
.50322 .97618 L
.5044 .97618 L
.50565 .97617 L
.50781 .97616 L
.51019 .97614 L
.51273 .97611 L
.51546 .97606 L
.52039 .97597 L
.52998 .97572 L
.53875 .9754 L
Mistroke
.55778 .97443 L
.56854 .9737 L
.57851 .97292 L
.6177 .96875 L
.63915 .96568 L
.65933 .96226 L
.69793 .95414 L
.73899 .94287 L
.77853 .92886 L
.81655 .91158 L
.85703 .88736 L
.89599 .85488 L
.91727 .83054 L
.92704 .81676 L
.9374 .7994 L
.94689 .77984 L
.95193 .76731 L
.95735 .75129 L
.96232 .7331 L
.96449 .72351 L
.96687 .71132 L
.96897 .69835 L
.97121 .68083 L
.97246 .66836 L
.97358 .65394 L
.97472 .63352 L
.97578 .59673 L
.97619 .50962 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 1 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.476191 0.5 0.476191 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .5 m
1 .5 L
s
.5 0 m
.5 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.0238095 0.754707 0.245293 0.97619 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 1 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.47619 0.5 0.47619 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .5 m
1 .5 L
s
.5 0 m
.5 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 Mabswid
.02381 .5 m
.04313 .48068 L
.06419 .45961 L
.08398 .43983 L
.10301 .4208 L
.12326 .40055 L
.14276 .38105 L
.16348 .36033 L
.18345 .34036 L
.20265 .32116 L
.22309 .30072 L
.24276 .28105 L
.26168 .26213 L
.28182 .24199 L
.30121 .2226 L
.32182 .20199 L
.34168 .18213 L
.36077 .16304 L
.3811 .14271 L
.40066 .12315 L
.42145 .10236 L
.44149 .08232 L
.46076 .06305 L
.48126 .04255 L
.5 .02381 L
s
.02381 .5 m
.04313 .51932 L
.06419 .54039 L
.08398 .56017 L
.10301 .5792 L
.12326 .59945 L
.14276 .61895 L
.16348 .63967 L
.18345 .65964 L
.20265 .67884 L
.22309 .69928 L
.24276 .71895 L
.26168 .73787 L
.28182 .75801 L
.30121 .7774 L
.32182 .79801 L
.34168 .81787 L
.36077 .83696 L
.3811 .85729 L
.40066 .87685 L
.42145 .89764 L
.44149 .91768 L
.46076 .93695 L
.48126 .95745 L
.5 .97619 L
s
0 1 1 r
.02381 .5 m
.04313 .48068 L
.06419 .45961 L
.08398 .43983 L
.10301 .4208 L
.12326 .40055 L
.14276 .38105 L
.16348 .36033 L
.18345 .34036 L
.20265 .32116 L
.22309 .30072 L
.24276 .28105 L
.26168 .26213 L
.28182 .24199 L
.30121 .2226 L
.32182 .20199 L
.34168 .18213 L
.36077 .16304 L
.3811 .14271 L
.40066 .12315 L
.42145 .10236 L
.44149 .08232 L
.46076 .06305 L
.48126 .04255 L
.5 .02381 L
.5 .97619 L
.48126 .95745 L
.46076 .93695 L
.44149 .91768 L
.42145 .89764 L
.40066 .87685 L
.3811 .85729 L
.36077 .83696 L
.34168 .81787 L
.32182 .79801 L
.30121 .7774 L
.28182 .75801 L
.26168 .73787 L
.24276 .71895 L
.22309 .69928 L
.20265 .67884 L
.18345 .65964 L
.16348 .63967 L
.14276 .61895 L
.12326 .59945 L
.10301 .5792 L
.08398 .56017 L
.06419 .54039 L
.04313 .51932 L
.02381 .5 L
F
0 g
.02381 .5 m
.04313 .48068 L
.06419 .45961 L
.08398 .43983 L
.10301 .4208 L
.12326 .40055 L
.14276 .38105 L
.16348 .36033 L
.18345 .34036 L
.20265 .32116 L
.22309 .30072 L
.24276 .28105 L
.26168 .26213 L
.28182 .24199 L
.30121 .2226 L
.32182 .20199 L
.34168 .18213 L
.36077 .16304 L
.3811 .14271 L
.40066 .12315 L
.42145 .10236 L
.44149 .08232 L
.46076 .06305 L
.48126 .04255 L
.5 .02381 L
s
.02381 .5 m
.04313 .51932 L
.06419 .54039 L
.08398 .56017 L
.10301 .5792 L
.12326 .59945 L
.14276 .61895 L
.16348 .63967 L
.18345 .65964 L
.20265 .67884 L
.22309 .69928 L
.24276 .71895 L
.26168 .73787 L
.28182 .75801 L
.30121 .7774 L
.32182 .79801 L
.34168 .81787 L
.36077 .83696 L
.3811 .85729 L
.40066 .87685 L
.42145 .89764 L
.44149 .91768 L
.46076 .93695 L
.48126 .95745 L
.5 .97619 L
s
.5 .02381 m
.51932 .04313 L
.54039 .06419 L
.56017 .08398 L
.5792 .10301 L
.59945 .12326 L
.61895 .14276 L
.63967 .16348 L
.65964 .18345 L
.67884 .20265 L
.69928 .22309 L
.71895 .24276 L
.73787 .26168 L
.75801 .28182 L
.7774 .30121 L
.79801 .32182 L
.81787 .34168 L
.83696 .36077 L
.85729 .3811 L
.87685 .40066 L
.89764 .42145 L
.91768 .44149 L
.93695 .46076 L
.95745 .48126 L
.97619 .5 L
s
.5 .97619 m
.51932 .95687 L
.54039 .93581 L
.56017 .91602 L
.5792 .89699 L
.59945 .87674 L
.61895 .85724 L
.63967 .83652 L
.65964 .81655 L
.67884 .79735 L
.69928 .77691 L
.71895 .75724 L
.73787 .73832 L
.75801 .71818 L
.7774 .69879 L
.79801 .67818 L
.81787 .65832 L
.83696 .63923 L
.85729 .6189 L
.87685 .59934 L
.89764 .57855 L
.91768 .55851 L
.93695 .53924 L
.95745 .51874 L
.97619 .5 L
s
0 1 1 r
.5 .02381 m
.51932 .04313 L
.54039 .06419 L
.56017 .08398 L
.5792 .10301 L
.59945 .12326 L
.61895 .14276 L
.63967 .16348 L
.65964 .18345 L
.67884 .20265 L
.69928 .22309 L
.71895 .24276 L
.73787 .26168 L
.75801 .28182 L
.7774 .30121 L
.79801 .32182 L
.81787 .34168 L
.83696 .36077 L
.85729 .3811 L
.87685 .40066 L
.89764 .42145 L
.91768 .44149 L
.93695 .46076 L
.95745 .48126 L
.97619 .5 L
.97619 .5 L
.95745 .51874 L
.93695 .53924 L
.91768 .55851 L
.89764 .57855 L
.87685 .59934 L
.85729 .6189 L
.83696 .63923 L
.81787 .65832 L
.79801 .67818 L
.7774 .69879 L
.75801 .71818 L
.73787 .73832 L
.71895 .75724 L
.69928 .77691 L
.67884 .79735 L
.65964 .81655 L
.63967 .83652 L
.61895 .85724 L
.59945 .87674 L
.5792 .89699 L
.56017 .91602 L
.54039 .93581 L
.51932 .95687 L
.5 .97619 L
F
0 g
.5 .02381 m
.51932 .04313 L
.54039 .06419 L
.56017 .08398 L
.5792 .10301 L
.59945 .12326 L
.61895 .14276 L
.63967 .16348 L
.65964 .18345 L
.67884 .20265 L
.69928 .22309 L
.71895 .24276 L
.73787 .26168 L
.75801 .28182 L
.7774 .30121 L
.79801 .32182 L
.81787 .34168 L
.83696 .36077 L
.85729 .3811 L
.87685 .40066 L
.89764 .42145 L
.91768 .44149 L
.93695 .46076 L
.95745 .48126 L
.97619 .5 L
s
.5 .97619 m
.51932 .95687 L
.54039 .93581 L
.56017 .91602 L
.5792 .89699 L
.59945 .87674 L
.61895 .85724 L
.63967 .83652 L
.65964 .81655 L
.67884 .79735 L
.69928 .77691 L
.71895 .75724 L
.73787 .73832 L
.75801 .71818 L
.7774 .69879 L
.79801 .67818 L
.81787 .65832 L
.83696 .63923 L
.85729 .6189 L
.87685 .59934 L
.89764 .57855 L
.91768 .55851 L
.93695 .53924 L
.95745 .51874 L
.97619 .5 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 1 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.47619 0.5 0.47619 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .5 m
1 .5 L
s
.5 0 m
.5 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.267442 0.754707 0.488926 0.97619 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 1 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.47619 0.5 0.47619 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .5 m
1 .5 L
s
.5 0 m
.5 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 Mabswid
.02381 .4999 m
.0244 .48327 L
.02493 .47688 L
.02613 .46674 L
.0283 .45377 L
.03082 .4422 L
.03321 .43308 L
.04313 .40409 L
.05323 .38164 L
.06419 .36132 L
.08463 .32982 L
.1043 .30422 L
.12322 .28243 L
.14336 .2614 L
.16275 .24278 L
.18336 .22436 L
.20322 .20771 L
.22231 .19255 L
.24264 .17719 L
.2622 .16307 L
.28299 .14869 L
.30303 .13536 L
.3223 .12299 L
.3428 .11025 L
.36255 .09837 L
.38153 .08727 L
.40174 .07577 L
.4212 .06499 L
.44188 .05382 L
.4618 .04331 L
.48097 .03342 L
.5 .02381 L
s
.02381 .5001 m
.0244 .51673 L
.02493 .52312 L
.02613 .53326 L
.0283 .54623 L
.03082 .5578 L
.03321 .56692 L
.04313 .59591 L
.05323 .61836 L
.06419 .63868 L
.08463 .67018 L
.1043 .69578 L
.12322 .71757 L
.14336 .7386 L
.16275 .75722 L
.18336 .77564 L
.20322 .79229 L
.22231 .80745 L
.24264 .82281 L
.2622 .83693 L
.28299 .85131 L
.30303 .86464 L
.3223 .87701 L
.3428 .88975 L
.36255 .90163 L
.38153 .91273 L
.40174 .92423 L
.4212 .93501 L
.44188 .94618 L
.4618 .95669 L
.48097 .96658 L
.5 .97619 L
s
0 1 1 r
.02381 .4999 m
.0244 .48327 L
.02493 .47688 L
.02613 .46674 L
.0283 .45377 L
.03082 .4422 L
.03321 .43308 L
.04313 .40409 L
.05323 .38164 L
.06419 .36132 L
.08463 .32982 L
.1043 .30422 L
.12322 .28243 L
.14336 .2614 L
.16275 .24278 L
.18336 .22436 L
.20322 .20771 L
.22231 .19255 L
.24264 .17719 L
.2622 .16307 L
.28299 .14869 L
.30303 .13536 L
.3223 .12299 L
.3428 .11025 L
.36255 .09837 L
.38153 .08727 L
.40174 .07577 L
.4212 .06499 L
.44188 .05382 L
.4618 .04331 L
.48097 .03342 L
.5 .02381 L
.5 .97619 L
.48097 .96658 L
.4618 .95669 L
.44188 .94618 L
.4212 .93501 L
.40174 .92423 L
.38153 .91273 L
.36255 .90163 L
.3428 .88975 L
.3223 .87701 L
.30303 .86464 L
.28299 .85131 L
.2622 .83693 L
.24264 .82281 L
.22231 .80745 L
.20322 .79229 L
.18336 .77564 L
.16275 .75722 L
.14336 .7386 L
.12322 .71757 L
.1043 .69578 L
.08463 .67018 L
.06419 .63868 L
.05323 .61836 L
.04313 .59591 L
.03321 .56692 L
.03082 .5578 L
.0283 .54623 L
.02613 .53326 L
.02493 .52312 L
.0244 .51673 L
.02381 .5001 L
F
0 g
.02381 .4999 m
.0244 .48327 L
.02493 .47688 L
.02613 .46674 L
.0283 .45377 L
.03082 .4422 L
.03321 .43308 L
.04313 .40409 L
.05323 .38164 L
.06419 .36132 L
.08463 .32982 L
.1043 .30422 L
.12322 .28243 L
.14336 .2614 L
.16275 .24278 L
.18336 .22436 L
.20322 .20771 L
.22231 .19255 L
.24264 .17719 L
.2622 .16307 L
.28299 .14869 L
.30303 .13536 L
.3223 .12299 L
.3428 .11025 L
.36255 .09837 L
.38153 .08727 L
.40174 .07577 L
.4212 .06499 L
.44188 .05382 L
.4618 .04331 L
.48097 .03342 L
.5 .02381 L
s
.02381 .5001 m
.0244 .51673 L
.02493 .52312 L
.02613 .53326 L
.0283 .54623 L
.03082 .5578 L
.03321 .56692 L
.04313 .59591 L
.05323 .61836 L
.06419 .63868 L
.08463 .67018 L
.1043 .69578 L
.12322 .71757 L
.14336 .7386 L
.16275 .75722 L
.18336 .77564 L
.20322 .79229 L
.22231 .80745 L
.24264 .82281 L
.2622 .83693 L
.28299 .85131 L
.30303 .86464 L
.3223 .87701 L
.3428 .88975 L
.36255 .90163 L
.38153 .91273 L
.40174 .92423 L
.4212 .93501 L
.44188 .94618 L
.4618 .95669 L
.48097 .96658 L
.5 .97619 L
s
.5 .02381 m
.51932 .03357 L
.54039 .04445 L
.56017 .05491 L
.5792 .06521 L
.59945 .07645 L
.61895 .08755 L
.63967 .09969 L
.65964 .11175 L
.67884 .12371 L
.69928 .13687 L
.71895 .15001 L
.73787 .16312 L
.75801 .17768 L
.7774 .19233 L
.79801 .20872 L
.81787 .22542 L
.83696 .24252 L
.85729 .26205 L
.87685 .2825 L
.89764 .3066 L
.91768 .33307 L
.93695 .36331 L
.94672 .38155 L
.95745 .40554 L
.96213 .41817 L
.96714 .43436 L
.96957 .44387 L
.97188 .45467 L
.97394 .46728 L
.97451 .4717 L
.97511 .47732 L
.97562 .48357 L
.97619 .4999 L
s
.5 .97619 m
.51932 .96643 L
.54039 .95555 L
.56017 .94509 L
.5792 .93479 L
.59945 .92355 L
.61895 .91245 L
.63967 .90031 L
.65964 .88825 L
.67884 .87629 L
.69928 .86313 L
.71895 .84999 L
.73787 .83688 L
.75801 .82232 L
.7774 .80767 L
.79801 .79128 L
.81787 .77458 L
.83696 .75748 L
.85729 .73795 L
.87685 .7175 L
.89764 .6934 L
.91768 .66693 L
.93695 .63669 L
.94672 .61845 L
.95745 .59446 L
.96213 .58183 L
.96714 .56564 L
.96957 .55613 L
.97188 .54533 L
.97394 .53272 L
.97451 .5283 L
.97511 .52268 L
.97562 .51643 L
.97619 .5001 L
s
0 1 1 r
.5 .02381 m
.51932 .03357 L
.54039 .04445 L
.56017 .05491 L
.5792 .06521 L
.59945 .07645 L
.61895 .08755 L
.63967 .09969 L
.65964 .11175 L
.67884 .12371 L
.69928 .13687 L
.71895 .15001 L
.73787 .16312 L
.75801 .17768 L
.7774 .19233 L
.79801 .20872 L
.81787 .22542 L
.83696 .24252 L
.85729 .26205 L
.87685 .2825 L
.89764 .3066 L
.91768 .33307 L
.93695 .36331 L
.94672 .38155 L
.95745 .40554 L
.96213 .41817 L
.96714 .43436 L
.96957 .44387 L
.97188 .45467 L
.97394 .46728 L
.97451 .4717 L
.97511 .47732 L
.97562 .48357 L
.97619 .4999 L
.97619 .5001 L
.97562 .51643 L
.97511 .52268 L
.97451 .5283 L
.97394 .53272 L
.97188 .54533 L
.96957 .55613 L
.96714 .56564 L
.96213 .58183 L
.95745 .59446 L
.94672 .61845 L
.93695 .63669 L
.91768 .66693 L
.89764 .6934 L
.87685 .7175 L
.85729 .73795 L
.83696 .75748 L
.81787 .77458 L
.79801 .79128 L
.7774 .80767 L
.75801 .82232 L
.73787 .83688 L
.71895 .84999 L
.69928 .86313 L
.67884 .87629 L
.65964 .88825 L
.63967 .90031 L
.61895 .91245 L
.59945 .92355 L
.5792 .93479 L
.56017 .94509 L
.54039 .95555 L
.51932 .96643 L
.5 .97619 L
F
0 g
.5 .02381 m
.51932 .03357 L
.54039 .04445 L
.56017 .05491 L
.5792 .06521 L
.59945 .07645 L
.61895 .08755 L
.63967 .09969 L
.65964 .11175 L
.67884 .12371 L
.69928 .13687 L
.71895 .15001 L
.73787 .16312 L
.75801 .17768 L
.7774 .19233 L
.79801 .20872 L
.81787 .22542 L
.83696 .24252 L
.85729 .26205 L
.87685 .2825 L
.89764 .3066 L
.91768 .33307 L
.93695 .36331 L
.94672 .38155 L
.95745 .40554 L
.96213 .41817 L
.96714 .43436 L
.96957 .44387 L
.97188 .45467 L
.97394 .46728 L
.97451 .4717 L
.97511 .47732 L
.97562 .48357 L
.97619 .4999 L
s
.5 .97619 m
.51932 .96643 L
.54039 .95555 L
.56017 .94509 L
.5792 .93479 L
.59945 .92355 L
.61895 .91245 L
.63967 .90031 L
.65964 .88825 L
.67884 .87629 L
.69928 .86313 L
.71895 .84999 L
.73787 .83688 L
.75801 .82232 L
.7774 .80767 L
.79801 .79128 L
.81787 .77458 L
.83696 .75748 L
.85729 .73795 L
.87685 .7175 L
.89764 .6934 L
.91768 .66693 L
.93695 .63669 L
.94672 .61845 L
.95745 .59446 L
.96213 .58183 L
.96714 .56564 L
.96957 .55613 L
.97188 .54533 L
.97394 .53272 L
.97451 .5283 L
.97511 .52268 L
.97562 .51643 L
.97619 .5001 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 1 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.47619 0.5 0.47619 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .5 m
1 .5 L
s
.5 0 m
.5 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.511074 0.754707 0.732558 0.97619 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 1 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.47619 0.5 0.47619 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .5 m
1 .5 L
s
.5 0 m
.5 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 Mabswid
.02381 .49835 m
.0244 .44892 L
.02493 .43662 L
.02555 .42666 L
.02613 .41923 L
.0283 .39941 L
.03065 .38422 L
.03321 .37129 L
.03837 .3511 L
.04313 .33638 L
.05335 .31149 L
.06419 .29078 L
.08311 .2622 L
.10326 .23785 L
.12264 .21806 L
.14325 .19969 L
.16311 .18389 L
.1822 .17006 L
.20253 .15651 L
.22209 .14441 L
.24288 .13239 L
.26292 .12151 L
.28219 .1116 L
.30269 .10159 L
.32244 .0924 L
.34142 .08394 L
.36164 .0753 L
.38109 .0673 L
.40177 .0591 L
.42169 .05149 L
.44086 .0444 L
.46125 .03709 L
.48088 .03027 L
.49976 .02389 L
.5 .02381 L
s
.02381 .50165 m
.0244 .55108 L
.02493 .56338 L
.02555 .57334 L
.02613 .58077 L
.0283 .60059 L
.03065 .61578 L
.03321 .62871 L
.03837 .6489 L
.04313 .66362 L
.05335 .68851 L
.06419 .70922 L
.08311 .7378 L
.10326 .76215 L
.12264 .78194 L
.14325 .80031 L
.16311 .81611 L
.1822 .82994 L
.20253 .84349 L
.22209 .85559 L
.24288 .86761 L
.26292 .87849 L
.28219 .8884 L
.30269 .89841 L
.32244 .9076 L
.34142 .91606 L
.36164 .9247 L
.38109 .9327 L
.40177 .9409 L
.42169 .94851 L
.44086 .9556 L
.46125 .96291 L
.48088 .96973 L
.49976 .97611 L
.5 .97619 L
s
0 1 1 r
.02381 .49835 m
.0244 .44892 L
.02493 .43662 L
.02555 .42666 L
.02613 .41923 L
.0283 .39941 L
.03065 .38422 L
.03321 .37129 L
.03837 .3511 L
.04313 .33638 L
.05335 .31149 L
.06419 .29078 L
.08311 .2622 L
.10326 .23785 L
.12264 .21806 L
.14325 .19969 L
.16311 .18389 L
.1822 .17006 L
.20253 .15651 L
.22209 .14441 L
.24288 .13239 L
.26292 .12151 L
.28219 .1116 L
.30269 .10159 L
.32244 .0924 L
.34142 .08394 L
.36164 .0753 L
.38109 .0673 L
.40177 .0591 L
.42169 .05149 L
.44086 .0444 L
.46125 .03709 L
.48088 .03027 L
.49976 .02389 L
.5 .02381 L
.5 .97619 L
.49976 .97611 L
.48088 .96973 L
.46125 .96291 L
.44086 .9556 L
.42169 .94851 L
.40177 .9409 L
.38109 .9327 L
.36164 .9247 L
.34142 .91606 L
.32244 .9076 L
.30269 .89841 L
.28219 .8884 L
.26292 .87849 L
.24288 .86761 L
.22209 .85559 L
.20253 .84349 L
.1822 .82994 L
.16311 .81611 L
.14325 .80031 L
.12264 .78194 L
.10326 .76215 L
.08311 .7378 L
.06419 .70922 L
.05335 .68851 L
.04313 .66362 L
.03837 .6489 L
.03321 .62871 L
.03065 .61578 L
.0283 .60059 L
.02613 .58077 L
.02555 .57334 L
.02493 .56338 L
.0244 .55108 L
.02381 .50165 L
F
0 g
.02381 .49835 m
.0244 .44892 L
.02493 .43662 L
.02555 .42666 L
.02613 .41923 L
.0283 .39941 L
.03065 .38422 L
.03321 .37129 L
.03837 .3511 L
.04313 .33638 L
.05335 .31149 L
.06419 .29078 L
.08311 .2622 L
.10326 .23785 L
.12264 .21806 L
.14325 .19969 L
.16311 .18389 L
.1822 .17006 L
.20253 .15651 L
.22209 .14441 L
.24288 .13239 L
.26292 .12151 L
.28219 .1116 L
.30269 .10159 L
.32244 .0924 L
.34142 .08394 L
.36164 .0753 L
.38109 .0673 L
.40177 .0591 L
.42169 .05149 L
.44086 .0444 L
.46125 .03709 L
.48088 .03027 L
.49976 .02389 L
.5 .02381 L
s
.02381 .50165 m
.0244 .55108 L
.02493 .56338 L
.02555 .57334 L
.02613 .58077 L
.0283 .60059 L
.03065 .61578 L
.03321 .62871 L
.03837 .6489 L
.04313 .66362 L
.05335 .68851 L
.06419 .70922 L
.08311 .7378 L
.10326 .76215 L
.12264 .78194 L
.14325 .80031 L
.16311 .81611 L
.1822 .82994 L
.20253 .84349 L
.22209 .85559 L
.24288 .86761 L
.26292 .87849 L
.28219 .8884 L
.30269 .89841 L
.32244 .9076 L
.34142 .91606 L
.36164 .9247 L
.38109 .9327 L
.40177 .9409 L
.42169 .94851 L
.44086 .9556 L
.46125 .96291 L
.48088 .96973 L
.49976 .97611 L
.5 .97619 L
s
.5 .02381 m
.51932 .03034 L
.54039 .03767 L
.56017 .04478 L
.5792 .05183 L
.59945 .05958 L
.61895 .06731 L
.63967 .07585 L
.65964 .08441 L
.67884 .09299 L
.69928 .10253 L
.71895 .11218 L
.73787 .12193 L
.75801 .1329 L
.7774 .14411 L
.79801 .15686 L
.81787 .17011 L
.83696 .18395 L
.85729 .20014 L
.87685 .21758 L
.89764 .23884 L
.91768 .26326 L
.93695 .29278 L
.94692 .31207 L
.952 .32365 L
.95745 .33803 L
.96252 .3542 L
.96714 .37294 L
.96937 .38435 L
.97054 .3914 L
.97179 .40007 L
.97288 .40908 L
.97345 .4147 L
.97408 .42172 L
.97464 .42949 L
.97517 .43853 L
.97567 .4508 L
.97619 .49835 L
s
.5 .97619 m
.51932 .96966 L
.54039 .96233 L
.56017 .95522 L
.5792 .94817 L
.59945 .94042 L
.61895 .93269 L
.63967 .92415 L
.65964 .91559 L
.67884 .90701 L
.69928 .89747 L
.71895 .88782 L
.73787 .87807 L
.75801 .8671 L
.7774 .85589 L
.79801 .84314 L
.81787 .82989 L
.83696 .81605 L
.85729 .79986 L
.87685 .78242 L
.89764 .76116 L
.91768 .73674 L
.93695 .70722 L
.94692 .68793 L
.952 .67635 L
.95745 .66197 L
.96252 .6458 L
.96714 .62706 L
.96937 .61565 L
.97054 .6086 L
.97179 .59993 L
.97288 .59092 L
.97345 .5853 L
.97408 .57828 L
.97464 .57051 L
.97517 .56147 L
.97567 .5492 L
.97619 .50165 L
s
0 1 1 r
.5 .02381 m
.51932 .03034 L
.54039 .03767 L
.56017 .04478 L
.5792 .05183 L
.59945 .05958 L
.61895 .06731 L
.63967 .07585 L
.65964 .08441 L
.67884 .09299 L
.69928 .10253 L
.71895 .11218 L
.73787 .12193 L
.75801 .1329 L
.7774 .14411 L
.79801 .15686 L
.81787 .17011 L
.83696 .18395 L
.85729 .20014 L
.87685 .21758 L
.89764 .23884 L
.91768 .26326 L
.93695 .29278 L
.94692 .31207 L
.952 .32365 L
.95745 .33803 L
.96252 .3542 L
.96714 .37294 L
.96937 .38435 L
.97054 .3914 L
.97179 .40007 L
.97288 .40908 L
.97345 .4147 L
.97408 .42172 L
.97464 .42949 L
.97517 .43853 L
.97567 .4508 L
.97619 .49835 L
.97619 .50165 L
.97567 .5492 L
.97517 .56147 L
.97464 .57051 L
.97408 .57828 L
.97345 .5853 L
.97288 .59092 L
.97179 .59993 L
.97054 .6086 L
.96937 .61565 L
.96714 .62706 L
.96252 .6458 L
.95745 .66197 L
.952 .67635 L
.94692 .68793 L
.93695 .70722 L
.91768 .73674 L
.89764 .76116 L
.87685 .78242 L
.85729 .79986 L
.83696 .81605 L
.81787 .82989 L
.79801 .84314 L
.7774 .85589 L
.75801 .8671 L
.73787 .87807 L
.71895 .88782 L
.69928 .89747 L
.67884 .90701 L
.65964 .91559 L
.63967 .92415 L
.61895 .93269 L
.59945 .94042 L
.5792 .94817 L
.56017 .95522 L
.54039 .96233 L
.51932 .96966 L
.5 .97619 L
F
0 g
.5 .02381 m
.51932 .03034 L
.54039 .03767 L
.56017 .04478 L
.5792 .05183 L
.59945 .05958 L
.61895 .06731 L
.63967 .07585 L
.65964 .08441 L
.67884 .09299 L
.69928 .10253 L
.71895 .11218 L
.73787 .12193 L
.75801 .1329 L
.7774 .14411 L
.79801 .15686 L
.81787 .17011 L
.83696 .18395 L
.85729 .20014 L
.87685 .21758 L
.89764 .23884 L
.91768 .26326 L
.93695 .29278 L
.94692 .31207 L
.952 .32365 L
.95745 .33803 L
.96252 .3542 L
.96714 .37294 L
.96937 .38435 L
.97054 .3914 L
.97179 .40007 L
.97288 .40908 L
.97345 .4147 L
.97408 .42172 L
.97464 .42949 L
.97517 .43853 L
.97567 .4508 L
.97619 .49835 L
s
.5 .97619 m
.51932 .96966 L
.54039 .96233 L
.56017 .95522 L
.5792 .94817 L
.59945 .94042 L
.61895 .93269 L
.63967 .92415 L
.65964 .91559 L
.67884 .90701 L
.69928 .89747 L
.71895 .88782 L
.73787 .87807 L
.75801 .8671 L
.7774 .85589 L
.79801 .84314 L
.81787 .82989 L
.83696 .81605 L
.85729 .79986 L
.87685 .78242 L
.89764 .76116 L
.91768 .73674 L
.93695 .70722 L
.94692 .68793 L
.952 .67635 L
.95745 .66197 L
.96252 .6458 L
.96714 .62706 L
.96937 .61565 L
.97054 .6086 L
.97179 .59993 L
.97288 .59092 L
.97345 .5853 L
.97408 .57828 L
.97464 .57051 L
.97517 .56147 L
.97567 .5492 L
.97619 .50165 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 1 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.47619 0.5 0.47619 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .5 m
1 .5 L
s
.5 0 m
.5 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.754707 0.754707 0.97619 0.97619 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 1 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.47619 0.5 0.47619 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .5 m
1 .5 L
s
.5 0 m
.5 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 Mabswid
.02381 .4932 m
.0244 .41074 L
.02493 .39507 L
.02555 .38292 L
.02613 .37414 L
.02717 .36197 L
.0283 .35163 L
.03085 .33393 L
.03321 .32149 L
.03803 .30206 L
.04313 .28629 L
.05315 .26275 L
.06419 .24302 L
.08434 .21567 L
.10372 .19522 L
.12434 .17722 L
.14419 .16234 L
.16329 .14968 L
.18361 .13757 L
.20317 .12695 L
.22397 .11658 L
.244 .10732 L
.26327 .099 L
.28378 .09068 L
.30352 .08312 L
.32251 .07622 L
.34272 .06922 L
.36217 .0628 L
.38285 .05627 L
.40278 .05024 L
.42194 .04465 L
.44233 .03893 L
.46196 .03362 L
.48084 .02867 L
.5 .02381 L
s
.02381 .5068 m
.0244 .58926 L
.02493 .60493 L
.02555 .61708 L
.02613 .62586 L
.02717 .63803 L
.0283 .64837 L
.03085 .66607 L
.03321 .67851 L
.03803 .69794 L
.04313 .71371 L
.05315 .73725 L
.06419 .75698 L
.08434 .78433 L
.10372 .80478 L
.12434 .82278 L
.14419 .83766 L
.16329 .85032 L
.18361 .86244 L
.20317 .87305 L
.22397 .88342 L
.244 .89268 L
.26327 .901 L
.28378 .90932 L
.30352 .91688 L
.32251 .92378 L
.34272 .93078 L
.36217 .9372 L
.38285 .94373 L
.40278 .94976 L
.42194 .95535 L
.44233 .96107 L
.46196 .96638 L
.48084 .97133 L
.5 .97619 L
s
0 1 1 r
.02381 .4932 m
.0244 .41074 L
.02493 .39507 L
.02555 .38292 L
.02613 .37414 L
.02717 .36197 L
.0283 .35163 L
.03085 .33393 L
.03321 .32149 L
.03803 .30206 L
.04313 .28629 L
.05315 .26275 L
.06419 .24302 L
.08434 .21567 L
.10372 .19522 L
.12434 .17722 L
.14419 .16234 L
.16329 .14968 L
.18361 .13757 L
.20317 .12695 L
.22397 .11658 L
.244 .10732 L
.26327 .099 L
.28378 .09068 L
.30352 .08312 L
.32251 .07622 L
.34272 .06922 L
.36217 .0628 L
.38285 .05627 L
.40278 .05024 L
.42194 .04465 L
.44233 .03893 L
.46196 .03362 L
.48084 .02867 L
.5 .02381 L
.5 .97619 L
.48084 .97133 L
.46196 .96638 L
.44233 .96107 L
.42194 .95535 L
.40278 .94976 L
.38285 .94373 L
.36217 .9372 L
.34272 .93078 L
.32251 .92378 L
.30352 .91688 L
.28378 .90932 L
.26327 .901 L
.244 .89268 L
.22397 .88342 L
.20317 .87305 L
.18361 .86244 L
.16329 .85032 L
.14419 .83766 L
.12434 .82278 L
.10372 .80478 L
.08434 .78433 L
.06419 .75698 L
.05315 .73725 L
.04313 .71371 L
.03803 .69794 L
.03321 .67851 L
.03085 .66607 L
.0283 .64837 L
.02717 .63803 L
.02613 .62586 L
.02555 .61708 L
.02493 .60493 L
.0244 .58926 L
.02381 .5068 L
F
0 g
.02381 .4932 m
.0244 .41074 L
.02493 .39507 L
.02555 .38292 L
.02613 .37414 L
.02717 .36197 L
.0283 .35163 L
.03085 .33393 L
.03321 .32149 L
.03803 .30206 L
.04313 .28629 L
.05315 .26275 L
.06419 .24302 L
.08434 .21567 L
.10372 .19522 L
.12434 .17722 L
.14419 .16234 L
.16329 .14968 L
.18361 .13757 L
.20317 .12695 L
.22397 .11658 L
.244 .10732 L
.26327 .099 L
.28378 .09068 L
.30352 .08312 L
.32251 .07622 L
.34272 .06922 L
.36217 .0628 L
.38285 .05627 L
.40278 .05024 L
.42194 .04465 L
.44233 .03893 L
.46196 .03362 L
.48084 .02867 L
.5 .02381 L
s
.02381 .5068 m
.0244 .58926 L
.02493 .60493 L
.02555 .61708 L
.02613 .62586 L
.02717 .63803 L
.0283 .64837 L
.03085 .66607 L
.03321 .67851 L
.03803 .69794 L
.04313 .71371 L
.05315 .73725 L
.06419 .75698 L
.08434 .78433 L
.10372 .80478 L
.12434 .82278 L
.14419 .83766 L
.16329 .85032 L
.18361 .86244 L
.20317 .87305 L
.22397 .88342 L
.244 .89268 L
.26327 .901 L
.28378 .90932 L
.30352 .91688 L
.32251 .92378 L
.34272 .93078 L
.36217 .9372 L
.38285 .94373 L
.40278 .94976 L
.42194 .95535 L
.44233 .96107 L
.46196 .96638 L
.48084 .97133 L
.5 .97619 L
s
.5 .02381 m
.51932 .02871 L
.54039 .03424 L
.56017 .03962 L
.5792 .04498 L
.59945 .0509 L
.61895 .05682 L
.63967 .0634 L
.65964 .07002 L
.67884 .0767 L
.69928 .08416 L
.71895 .09176 L
.73787 .09948 L
.75801 .10822 L
.7774 .11723 L
.79801 .12757 L
.81787 .13841 L
.83696 .14984 L
.85729 .16338 L
.87685 .17818 L
.89764 .19653 L
.91768 .21806 L
.93695 .24487 L
.94692 .26289 L
.952 .27394 L
.95745 .28791 L
.96252 .30399 L
.96714 .32321 L
.96937 .33526 L
.97054 .34285 L
.97179 .35235 L
.97288 .36246 L
.97345 .36888 L
.97408 .37707 L
.97464 .38633 L
.97517 .39745 L
.97567 .41322 L
.97619 .4932 L
s
.5 .97619 m
.51932 .97129 L
.54039 .96576 L
.56017 .96038 L
.5792 .95502 L
.59945 .9491 L
.61895 .94318 L
.63967 .9366 L
.65964 .92998 L
.67884 .9233 L
.69928 .91584 L
.71895 .90824 L
.73787 .90052 L
.75801 .89178 L
.7774 .88277 L
.79801 .87243 L
.81787 .86159 L
.83696 .85016 L
.85729 .83662 L
.87685 .82182 L
.89764 .80347 L
.91768 .78194 L
.93695 .75513 L
.94692 .73711 L
.952 .72606 L
.95745 .71209 L
.96252 .69601 L
.96714 .67679 L
.96937 .66474 L
.97054 .65715 L
.97179 .64765 L
.97288 .63754 L
.97345 .63112 L
.97408 .62293 L
.97464 .61367 L
.97517 .60255 L
.97567 .58678 L
.97619 .5068 L
s
0 1 1 r
.5 .02381 m
.51932 .02871 L
.54039 .03424 L
.56017 .03962 L
.5792 .04498 L
.59945 .0509 L
.61895 .05682 L
.63967 .0634 L
.65964 .07002 L
.67884 .0767 L
.69928 .08416 L
.71895 .09176 L
.73787 .09948 L
.75801 .10822 L
.7774 .11723 L
.79801 .12757 L
.81787 .13841 L
.83696 .14984 L
.85729 .16338 L
.87685 .17818 L
.89764 .19653 L
.91768 .21806 L
.93695 .24487 L
.94692 .26289 L
.952 .27394 L
.95745 .28791 L
.96252 .30399 L
.96714 .32321 L
.96937 .33526 L
.97054 .34285 L
.97179 .35235 L
.97288 .36246 L
.97345 .36888 L
.97408 .37707 L
.97464 .38633 L
.97517 .39745 L
.97567 .41322 L
.97619 .4932 L
.97619 .5068 L
.97567 .58678 L
.97517 .60255 L
.97464 .61367 L
.97408 .62293 L
.97345 .63112 L
.97288 .63754 L
.97179 .64765 L
.97054 .65715 L
.96937 .66474 L
.96714 .67679 L
.96252 .69601 L
.95745 .71209 L
.952 .72606 L
.94692 .73711 L
.93695 .75513 L
.91768 .78194 L
.89764 .80347 L
.87685 .82182 L
.85729 .83662 L
.83696 .85016 L
.81787 .86159 L
.79801 .87243 L
.7774 .88277 L
.75801 .89178 L
.73787 .90052 L
.71895 .90824 L
.69928 .91584 L
.67884 .9233 L
.65964 .92998 L
.63967 .9366 L
.61895 .94318 L
.59945 .9491 L
.5792 .95502 L
.56017 .96038 L
.54039 .96576 L
.51932 .97129 L
.5 .97619 L
F
0 g
.5 .02381 m
.51932 .02871 L
.54039 .03424 L
.56017 .03962 L
.5792 .04498 L
.59945 .0509 L
.61895 .05682 L
.63967 .0634 L
.65964 .07002 L
.67884 .0767 L
.69928 .08416 L
.71895 .09176 L
.73787 .09948 L
.75801 .10822 L
.7774 .11723 L
.79801 .12757 L
.81787 .13841 L
.83696 .14984 L
.85729 .16338 L
.87685 .17818 L
.89764 .19653 L
.91768 .21806 L
.93695 .24487 L
.94692 .26289 L
.952 .27394 L
.95745 .28791 L
.96252 .30399 L
.96714 .32321 L
.96937 .33526 L
.97054 .34285 L
.97179 .35235 L
.97288 .36246 L
.97345 .36888 L
.97408 .37707 L
.97464 .38633 L
.97517 .39745 L
.97567 .41322 L
.97619 .4932 L
s
.5 .97619 m
.51932 .97129 L
.54039 .96576 L
.56017 .96038 L
.5792 .95502 L
.59945 .9491 L
.61895 .94318 L
.63967 .9366 L
.65964 .92998 L
.67884 .9233 L
.69928 .91584 L
.71895 .90824 L
.73787 .90052 L
.75801 .89178 L
.7774 .88277 L
.79801 .87243 L
.81787 .86159 L
.83696 .85016 L
.85729 .83662 L
.87685 .82182 L
.89764 .80347 L
.91768 .78194 L
.93695 .75513 L
.94692 .73711 L
.952 .72606 L
.95745 .71209 L
.96252 .69601 L
.96714 .67679 L
.96937 .66474 L
.97054 .65715 L
.97179 .64765 L
.97288 .63754 L
.97345 .63112 L
.97408 .62293 L
.97464 .61367 L
.97517 .60255 L
.97567 .58678 L
.97619 .5068 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 1 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.47619 0.5 0.47619 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .5 m
1 .5 L
s
.5 0 m
.5 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.35.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "GraphicsArray", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S5.35.1"]
}, Open  ]],

Cell["This plots the intersection of a double cone with a ball. ", \
"MathCaption",
 CellTags->{"S5.35.1", "1.9"}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InequalityPlot3D", "[", " ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"], "+", 
      SuperscriptBox["z", "2"]}], "\[LessEqual]", "1"}], "\[And]", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"3", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"3", 
       SuperscriptBox["y", "2"]}]}], "\[LessEqual]", " ", 
     SuperscriptBox["z", "2"]}]}], ",", " ", 
   RowBox[{"{", "x", "}"}], ",", " ", 
   RowBox[{"{", "y", "}"}], ",", " ", 
   RowBox[{"{", "z", "}"}], ",", " ", 
   RowBox[{"Axes", " ", "->", " ", "False"}]}], "]"}]], "Input",
 CellLabel->"In[7]:= ",
 CellTags->"S5.35.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.62453 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.30443 1.63518 -0.0106411 1.63518 [
[ 0 0 0 0 ]
[ 1 1.62453 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.0843 .2212 m
0 1.32748 L
s
0 1.32748 m
.37669 1.62453 L
s
.37669 1.62453 m
.3971 .57309 L
s
.3971 .57309 m
.0843 .2212 L
s
.64785 0 m
.92348 .39072 L
s
.92348 .39072 m
1 1.47188 L
s
1 1.47188 m
.67613 1.13533 L
s
.67613 1.13533 m
.64785 0 L
s
.0843 .2212 m
0 1.32748 L
s
0 1.32748 m
.67613 1.13533 L
s
.67613 1.13533 m
.64785 0 L
s
.64785 0 m
.0843 .2212 L
s
.3971 .57309 m
.92348 .39072 L
s
.92348 .39072 m
1 1.47188 L
s
1 1.47188 m
.37669 1.62453 L
s
.37669 1.62453 m
.3971 .57309 L
s
0 0 m
1 0 L
1 1.62453 L
0 1.62453 L
closepath
clip
newpath
.5 Mabswid
.691 .645 .8 r
.47595 .52328 m .50545 .5781 L .58176 .57286 L p F P
0 g
s
.714 .671 .806 r
.50545 .5781 m .47595 .52328 L .39203 .52872 L p F P
0 g
s
.714 .671 .806 r
.39203 .52872 m .4151 .56716 L .50545 .5781 L p F P
0 g
s
.598 .187 .235 r
.58176 .57286 m .50545 .5781 L .47538 .61359 L p F P
0 g
s
.708 .292 .255 r
.50545 .5781 m .4151 .56716 L .39099 .57965 L p F P
0 g
s
.708 .292 .255 r
.39099 .57965 m .47538 .61359 L .50545 .5781 L p F P
0 g
s
.44 .032 .167 r
.64917 .55639 m .58176 .57286 L .54993 .62457 L p F P
0 g
s
.598 .187 .235 r
.47538 .61359 m .54993 .62457 L .58176 .57286 L p F P
0 g
s
.667 .627 .801 r
.54922 .50888 m .58176 .57286 L .64917 .55639 L p F P
0 g
s
.691 .645 .8 r
.58176 .57286 m .54922 .50888 L .47595 .52328 L p F P
0 g
s
.792 .696 .758 r
.25684 .48174 m .4151 .56716 L .39203 .52872 L closepath p F P
0 g
s
.853 .462 .305 r
.25684 .48174 m .39099 .57965 L .4151 .56716 L closepath p F P
0 g
s
.641 .613 .806 r
.61584 .48909 m .64917 .55639 L .70908 .52952 L p F P
0 g
s
.667 .627 .801 r
.64917 .55639 m .61584 .48909 L .54922 .50888 L p F P
0 g
s
.16 0 .004 r
.70908 .52952 m .64917 .55639 L .61801 .61378 L p F P
0 g
s
.44 .032 .167 r
.54993 .62457 m .61801 .61378 L .64917 .55639 L p F P
0 g
s
.7 .672 .819 r
.44601 .47418 m .47595 .52328 L .54922 .50888 L p F P
0 g
s
.726 .693 .818 r
.47595 .52328 m .44601 .47418 L .36862 .49351 L p F P
0 g
s
.726 .693 .818 r
.36862 .49351 m .39203 .52872 L .47595 .52328 L p F P
0 g
s
.674 .656 .824 r
.51626 .45216 m .54922 .50888 L .61584 .48909 L p F P
0 g
s
.7 .672 .819 r
.54922 .50888 m .51626 .45216 L .44601 .47418 L p F P
0 g
s
.781 .708 .784 r
.25684 .48174 m .39203 .52872 L .36862 .49351 L closepath p F P
0 g
s
.641 .613 .806 r
.70908 .52952 m .67698 .46448 L .61584 .48909 L p F P
0 g
s
.646 .642 .832 r
.58217 .42956 m .61584 .48909 L .67698 .46448 L p F P
0 g
s
.674 .656 .824 r
.61584 .48909 m .58217 .42956 L .51626 .45216 L p F P
0 g
s
.709 .699 .838 r
.41553 .43011 m .44601 .47418 L .51626 .45216 L p F P
0 g
s
.736 .715 .831 r
.44601 .47418 m .41553 .43011 L .34484 .4613 L p F P
0 g
s
.736 .715 .831 r
.34484 .4613 m .36862 .49351 L .44601 .47418 L p F P
0 g
s
.611 .601 .816 r
.67698 .46448 m .70908 .52952 L .76095 .49062 L p F P
0 g
s
0 0 0 r
.76095 .49062 m .70908 .52952 L .68023 .58072 L p F P
0 g
s
.16 0 .004 r
.61801 .61378 m .68023 .58072 L .70908 .52952 L p F P
0 g
s
.774 .724 .806 r
.25684 .48174 m .36862 .49351 L .34484 .4613 L closepath p F P
0 g
s
.681 .685 .848 r
.48273 .40166 m .51626 .45216 L .58217 .42956 L p F P
0 g
s
.709 .699 .838 r
.51626 .45216 m .48273 .40166 L .41553 .43011 L p F P
0 g
s
.743 .316 .235 r
.47538 .61359 m .39099 .57965 L .3664 .58411 L p F P
0 g
s
.844 .42 .226 r
.25684 .48174 m .3664 .58411 L .39099 .57965 L closepath p F P
0 g
s
.611 .601 .816 r
.76095 .49062 m .73235 .4339 L .67698 .46448 L p F P
0 g
s
.614 .629 .842 r
.64465 .4067 m .67698 .46448 L .73235 .4339 L p F P
0 g
s
.646 .642 .832 r
.67698 .46448 m .64465 .4067 L .58217 .42956 L p F P
0 g
s
.65 .672 .858 r
.548 .37665 m .58217 .42956 L .64465 .4067 L p F P
0 g
s
.681 .685 .848 r
.58217 .42956 m .548 .37665 L .48273 .40166 L p F P
0 g
s
.746 .738 .844 r
.32063 .43196 m .34484 .4613 L .41553 .43011 L p F P
0 g
s
.774 .743 .825 r
.25684 .48174 m .34484 .4613 L .32063 .43196 L closepath p F P
0 g
s
.652 .241 .252 r
.54993 .62457 m .47538 .61359 L .44409 .64175 L p F P
0 g
s
.743 .316 .235 r
.3664 .58411 m .44409 .64175 L .47538 .61359 L p F P
0 g
s
.718 .728 .858 r
.38441 .39074 m .41553 .43011 L .48273 .40166 L p F P
0 g
s
.746 .738 .844 r
.41553 .43011 m .38441 .39074 L .32063 .43196 L p F P
0 g
s
.57 .588 .832 r
.73235 .4339 m .76095 .49062 L .80097 .43348 L p F P
0 g
s
0 0 0 r
.68023 .58072 m .73577 .52507 L .76095 .49062 L p F P
0 g
s
.864 .98 .686 r
.80097 .43348 m .76095 .49062 L .73577 .52507 L p F P
0 g
s
.687 .717 .872 r
.4485 .35687 m .48273 .40166 L .548 .37665 L p F P
0 g
s
.718 .728 .858 r
.48273 .40166 m .4485 .35687 L .38441 .39074 L p F P
0 g
s
.783 .766 .837 r
.25684 .48174 m .32063 .43196 L .29594 .40548 L closepath p F P
0 g
s
.801 .79 .842 r
.25684 .48174 m .29594 .40548 L .27072 .38192 L closepath p F P
0 g
s
.828 .815 .837 r
.25684 .48174 m .27072 .38192 L .24491 .36142 L closepath p F P
0 g
s
.862 .836 .82 r
.25684 .48174 m .24491 .36142 L .21842 .34428 L closepath p F P
0 g
s
.82 .344 .065 r
.25684 .48174 m .3415 .57758 L .3664 .58411 L closepath p F P
0 g
s
.713 .203 0 r
.25684 .48174 m .31649 .55742 L .3415 .57758 L closepath p F P
0 g
s
0 0 .49 r
.25684 .48174 m .29157 .52244 L .31649 .55742 L closepath p F P
0 g
s
0 0 .529 r
.25684 .48174 m .26688 .47356 L .29157 .52244 L closepath p F P
0 g
s
0 0 .464 r
.25684 .48174 m .2425 .41323 L .26688 .47356 L closepath p F P
0 g
s
0 0 .374 r
.25684 .48174 m .21842 .34428 L .2425 .41323 L closepath p F P
0 g
s
.483 .074 .189 r
.61801 .61378 m .54993 .62457 L .51638 .67544 L p F P
0 g
s
.652 .241 .252 r
.44409 .64175 m .51638 .67544 L .54993 .62457 L p F P
0 g
s
.614 .629 .842 r
.73235 .4339 m .7036 .38289 L .64465 .4067 L p F P
0 g
s
.614 .658 .869 r
.61191 .35514 m .64465 .4067 L .7036 .38289 L p F P
0 g
s
.65 .672 .858 r
.64465 .4067 m .61191 .35514 L .548 .37665 L p F P
0 g
s
.755 .762 .858 r
.29594 .40548 m .32063 .43196 L .38441 .39074 L p F P
0 g
s
.779 .322 .161 r
.44409 .64175 m .3664 .58411 L .3415 .57758 L p F P
0 g
s
.653 .704 .885 r
.51316 .32978 m .548 .37665 L .61191 .35514 L p F P
0 g
s
.687 .717 .872 r
.548 .37665 m .51316 .32978 L .4485 .35687 L p F P
0 g
s
.57 .588 .832 r
.80097 .43348 m .77918 .39285 L .73235 .4339 L p F P
0 g
s
.572 .615 .857 r
.7036 .38289 m .73235 .4339 L .77918 .39285 L p F P
0 g
s
.726 .759 .879 r
.35256 .356 m .38441 .39074 L .4485 .35687 L p F P
0 g
s
.755 .762 .858 r
.38441 .39074 m .35256 .356 L .29594 .40548 L p F P
0 g
s
.049 0 0 r
.68023 .58072 m .61801 .61378 L .58507 .67447 L p F P
0 g
s
.483 .074 .189 r
.51638 .67544 m .58507 .67447 L .61801 .61378 L p F P
0 g
s
.692 .751 .897 r
.41343 .31768 m .4485 .35687 L .51316 .32978 L p F P
0 g
s
.726 .759 .879 r
.4485 .35687 m .41343 .31768 L .35256 .356 L p F P
0 g
s
.765 .788 .872 r
.27072 .38192 m .29594 .40548 L .35256 .356 L p F P
0 g
s
.614 .658 .869 r
.7036 .38289 m .67457 .33693 L .61191 .35514 L p F P
0 g
s
.612 .688 .897 r
.57862 .3093 m .61191 .35514 L .67457 .33693 L p F P
0 g
s
.653 .704 .885 r
.61191 .35514 m .57862 .3093 L .51316 .32978 L p F P
0 g
s
.572 .615 .857 r
.77918 .39285 m .7573 .35547 L .7036 .38289 L p F P
0 g
s
.569 .641 .882 r
.67457 .33693 m .7036 .38289 L .7573 .35547 L p F P
0 g
s
.685 .902 .55 r
.73577 .52507 m .68023 .58072 L .64972 .63108 L p F P
0 g
s
.049 0 0 r
.58507 .67447 m .64972 .63108 L .68023 .58072 L p F P
0 g
s
.367 .495 .856 r
.77918 .39285 m .80097 .43348 L .78274 .2923 L closepath p F P
0 g
s
.99 .888 .583 r
.78155 .4445 m .78274 .2923 L .80097 .43348 L closepath p F P
0 g
s
.864 .98 .686 r
.73577 .52507 m .78155 .4445 L .80097 .43348 L p F P
0 g
s
.779 .322 .161 r
.3415 .57758 m .41179 .65393 L .44409 .64175 L p F P
0 g
s
.76 .248 0 r
.41179 .65393 m .3415 .57758 L .31649 .55742 L p F P
0 g
s
.653 .739 .913 r
.47751 .28881 m .51316 .32978 L .57862 .3093 L p F P
0 g
s
.692 .751 .897 r
.51316 .32978 m .47751 .28881 L .41343 .31768 L p F P
0 g
s
.72 .301 .251 r
.51638 .67544 m .44409 .64175 L .41179 .65393 L p F P
0 g
s
.734 .794 .9 r
.31984 .32603 m .35256 .356 L .41343 .31768 L p F P
0 g
s
.765 .788 .872 r
.35256 .356 m .31984 .32603 L .27072 .38192 L p F P
0 g
s
.773 .816 .887 r
.24491 .36142 m .27072 .38192 L .31984 .32603 L p F P
0 g
s
.436 .557 .879 r
.7573 .35547 m .77918 .39285 L .78274 .2923 L closepath p F P
0 g
s
.947 .955 .727 r
.78155 .4445 m .73577 .52507 L .70916 .55209 L p F P
0 g
s
.685 .902 .55 r
.64972 .63108 m .70916 .55209 L .73577 .52507 L p F P
0 g
s
.569 .641 .882 r
.7573 .35547 m .73528 .32108 L .67457 .33693 L p F P
0 g
s
.561 .667 .909 r
.64517 .29567 m .67457 .33693 L .73528 .32108 L p F P
0 g
s
.612 .688 .897 r
.67457 .33693 m .64517 .29567 L .57862 .3093 L p F P
0 g
s
.696 .79 .923 r
.37736 .28431 m .41343 .31768 L .47751 .28881 L p F P
0 g
s
.734 .794 .9 r
.41343 .31768 m .37736 .28431 L .31984 .32603 L p F P
0 g
s
.606 .721 .926 r
.54466 .26904 m .57862 .3093 L .64517 .29567 L p F P
0 g
s
.653 .739 .913 r
.57862 .3093 m .54466 .26904 L .47751 .28881 L p F P
0 g
s
.76 .248 0 r
.31649 .55742 m .37895 .63667 L .41179 .65393 L p F P
0 g
s
0 .07 .63 r
.37895 .63667 m .31649 .55742 L .29157 .52244 L p F P
0 g
s
.475 .603 .899 r
.73528 .32108 m .7573 .35547 L .78274 .2923 L closepath p F P
0 g
s
.742 .833 .921 r
.28613 .30125 m .31984 .32603 L .37736 .28431 L p F P
0 g
s
.773 .816 .887 r
.31984 .32603 m .28613 .30125 L .24491 .36142 L p F P
0 g
s
.567 .161 .232 r
.58507 .67447 m .51638 .67544 L .48108 .71794 L p F P
0 g
s
.72 .301 .251 r
.41179 .65393 m .48108 .71794 L .51638 .67544 L p F P
0 g
s
.649 .779 .942 r
.44088 .25398 m .47751 .28881 L .54466 .26904 L p F P
0 g
s
.696 .79 .923 r
.47751 .28881 m .44088 .25398 L .37736 .28431 L p F P
0 g
s
.781 .848 .902 r
.21842 .34428 m .24491 .36142 L .28613 .30125 L p F P
0 g
s
.985 .891 .639 r
.76119 .44735 m .78274 .2923 L .78155 .4445 L closepath p F P
0 g
s
.947 .955 .727 r
.70916 .55209 m .76119 .44735 L .78155 .4445 L p F P
0 g
s
0 .07 .63 r
.29157 .52244 m .34627 .58156 L .37895 .63667 L p F P
0 g
s
.136 .253 .722 r
.34627 .58156 m .29157 .52244 L .26688 .47356 L p F P
0 g
s
.561 .667 .909 r
.73528 .32108 m .71308 .28957 L .64517 .29567 L p F P
0 g
s
.547 .694 .936 r
.61529 .25902 m .64517 .29567 L .71308 .28957 L p F P
0 g
s
.606 .721 .926 r
.64517 .29567 m .61529 .25902 L .54466 .26904 L p F P
0 g
s
.488 .635 .919 r
.71308 .28957 m .73528 .32108 L .78274 .2923 L closepath p F P
0 g
s
.785 .301 .069 r
.48108 .71794 m .41179 .65393 L .37895 .63667 L p F P
0 g
s
.592 .757 .957 r
.50987 .23459 m .54466 .26904 L .61529 .25902 L p F P
0 g
s
.649 .779 .942 r
.54466 .26904 m .50987 .23459 L .44088 .25398 L p F P
0 g
s
.136 .253 .722 r
.26688 .47356 m .3141 .49617 L .34627 .58156 L p F P
0 g
s
.285 .313 .715 r
.3141 .49617 m .26688 .47356 L .2425 .41323 L p F P
0 g
s
.696 .835 .95 r
.34011 .25735 m .37736 .28431 L .44088 .25398 L p F P
0 g
s
.742 .833 .921 r
.37736 .28431 m .34011 .25735 L .28613 .30125 L p F P
0 g
s
0 0 0 r
.64972 .63108 m .58507 .67447 L .55018 .73875 L p F P
0 g
s
.567 .161 .232 r
.48108 .71794 m .55018 .73875 L .58507 .67447 L p F P
0 g
s
.285 .313 .715 r
.2425 .41323 m .28245 .39359 L .3141 .49617 L p F P
0 g
s
.359 .346 .708 r
.28245 .39359 m .2425 .41323 L .21842 .34428 L p F P
0 g
s
.781 .848 .902 r
.28613 .30125 m .25124 .28243 L .21842 .34428 L p F P
0 g
s
.359 .346 .708 r
.21842 .34428 m .25124 .28243 L .28245 .39359 L p F P
0 g
s
.746 .878 .94 r
.25124 .28243 m .28613 .30125 L .34011 .25735 L p F P
0 g
s
.471 .654 .94 r
.69064 .2609 m .71308 .28957 L .78274 .2923 L closepath p F P
0 g
s
.547 .694 .936 r
.71308 .28957 m .69064 .2609 L .61529 .25902 L p F P
0 g
s
0 0 0 r
.55018 .73875 m .61736 .67301 L .64972 .63108 L p F P
0 g
s
.938 .965 .704 r
.70916 .55209 m .64972 .63108 L .61736 .67301 L p F P
0 g
s
.954 .885 .726 r
.76119 .44735 m .70916 .55209 L .68092 .56293 L p F P
0 g
s
.938 .965 .704 r
.61736 .67301 m .68092 .56293 L .70916 .55209 L p F P
0 g
s
.521 .721 .964 r
.58483 .22712 m .61529 .25902 L .69064 .2609 L p F P
0 g
s
.592 .757 .957 r
.61529 .25902 m .58483 .22712 L .50987 .23459 L p F P
0 g
s
.637 .823 .972 r
.40308 .22598 m .44088 .25398 L .50987 .23459 L p F P
0 g
s
.696 .835 .95 r
.44088 .25398 m .40308 .22598 L .34011 .25735 L p F P
0 g
s
.964 .868 .694 r
.73986 .439 m .78274 .2923 L .76119 .44735 L closepath p F P
0 g
s
.954 .885 .726 r
.68092 .56293 m .73986 .439 L .76119 .44735 L p F P
0 g
s
.785 .301 .069 r
.37895 .63667 m .44443 .71975 L .48108 .71794 L p F P
0 g
s
.065 .243 .736 r
.44443 .71975 m .37895 .63667 L .34627 .58156 L p F P
0 g
s
.563 .793 .985 r
.4741 .20655 m .50987 .23459 L .58483 .22712 L p F P
0 g
s
.637 .823 .972 r
.50987 .23459 m .4741 .20655 L .40308 .22598 L p F P
0 g
s
.411 .654 .958 r
.66792 .23513 m .69064 .2609 L .78274 .2923 L closepath p F P
0 g
s
.521 .721 .964 r
.69064 .2609 m .66792 .23513 L .58483 .22712 L p F P
0 g
s
.686 .885 .972 r
.30144 .238 m .34011 .25735 L .40308 .22598 L p F P
0 g
s
.746 .878 .94 r
.34011 .25735 m .30144 .238 L .25124 .28243 L p F P
0 g
s
.282 .615 .957 r
.64489 .21243 m .66792 .23513 L .78274 .2923 L closepath p F P
0 g
s
.041 .494 .886 r
.62148 .19307 m .64489 .21243 L .78274 .2923 L closepath p F P
0 g
s
.923 .811 .719 r
.71754 .41676 m .78274 .2923 L .73986 .439 L closepath p F P
0 g
s
.882 .746 .707 r
.69435 .37945 m .78274 .2923 L .71754 .41676 L closepath p F P
0 g
s
.859 .699 .682 r
.67047 .328 m .78274 .2923 L .69435 .37945 L closepath p F P
0 g
s
.853 .673 .658 r
.64612 .2649 m .78274 .2923 L .67047 .328 L closepath p F P
0 g
s
.473 .743 .987 r
.55369 .20041 m .58483 .22712 L .66792 .23513 L p F P
0 g
s
.473 .743 .987 r
.66792 .23513 m .64489 .21243 L .55369 .20041 L p F P
0 g
s
.386 .749 .992 r
.52173 .17964 m .55369 .20041 L .64489 .21243 L p F P
0 g
s
.386 .749 .992 r
.64489 .21243 m .62148 .19307 L .52173 .17964 L p F P
0 g
s
.854 .66 .639 r
.62148 .19307 m .78274 .2923 L .64612 .2649 L closepath p F P
0 g
s
.726 .338 .315 r
.55018 .73875 m .48108 .71794 L .44443 .71975 L p F P
0 g
s
.563 .793 .985 r
.58483 .22712 m .55369 .20041 L .4741 .20655 L p F P
0 g
s
.923 .811 .719 r
.73986 .439 m .68092 .56293 L .65091 .54396 L p F P
0 g
s
.923 .811 .719 r
.65091 .54396 m .71754 .41676 L .73986 .439 L p F P
0 g
s
.496 .42 .7 r
.33649 .37595 m .28245 .39359 L .25124 .28243 L p F P
0 g
s
.496 .42 .7 r
.25124 .28243 m .30144 .238 L .33649 .37595 L p F P
0 g
s
.065 .243 .736 r
.34627 .58156 m .40787 .63679 L .44443 .71975 L p F P
0 g
s
.382 .363 .714 r
.40787 .63679 m .34627 .58156 L .3141 .49617 L p F P
0 g
s
.458 .399 .704 r
.37194 .51145 m .3141 .49617 L .28245 .39359 L p F P
0 g
s
.458 .399 .704 r
.28245 .39359 m .33649 .37595 L .37194 .51145 L p F P
0 g
s
.604 .867 .992 r
.36387 .20612 m .40308 .22598 L .4741 .20655 L p F P
0 g
s
.686 .885 .972 r
.40308 .22598 m .36387 .20612 L .30144 .238 L p F P
0 g
s
.382 .363 .714 r
.3141 .49617 m .37194 .51145 L .40787 .63679 L p F P
0 g
s
.94 .844 .72 r
.68092 .56293 m .61736 .67301 L .5828 .67399 L p F P
0 g
s
.94 .844 .72 r
.5828 .67399 m .65091 .54396 L .68092 .56293 L p F P
0 g
s
.503 .823 1 r
.43713 .18609 m .4741 .20655 L .55369 .20041 L p F P
0 g
s
.604 .867 .992 r
.4741 .20655 m .43713 .18609 L .36387 .20612 L p F P
0 g
s
.873 .745 .718 r
.71754 .41676 m .65091 .54396 L .61939 .48669 L p F P
0 g
s
.873 .745 .718 r
.61939 .48669 m .69435 .37945 L .71754 .41676 L p F P
0 g
s
.965 .91 .709 r
.61736 .67301 m .55018 .73875 L .51316 .80695 L p F P
0 g
s
.726 .338 .315 r
.44443 .71975 m .51316 .80695 L .55018 .73875 L p F P
0 g
s
.576 .467 .693 r
.40058 .35388 m .33649 .37595 L .30144 .238 L p F P
0 g
s
.576 .467 .693 r
.30144 .238 m .36387 .20612 L .40058 .35388 L p F P
0 g
s
.965 .91 .709 r
.51316 .80695 m .5828 .67399 L .61736 .67301 L p F P
0 g
s
.503 .823 1 r
.55369 .20041 m .52173 .17964 L .43713 .18609 L p F P
0 g
s
.82 .686 .717 r
.69435 .37945 m .61939 .48669 L .58701 .39879 L p F P
0 g
s
.82 .686 .717 r
.58701 .39879 m .67047 .328 L .69435 .37945 L p F P
0 g
s
.565 .46 .694 r
.4377 .50325 m .37194 .51145 L .33649 .37595 L p F P
0 g
s
.565 .46 .694 r
.33649 .37595 m .40058 .35388 L .4377 .50325 L p F P
0 g
s
.488 .411 .695 r
.51316 .80695 m .44443 .71975 L .40787 .63679 L p F P
0 g
s
.844 .716 .722 r
.65091 .54396 m .5828 .67399 L .54644 .58969 L p F P
0 g
s
.844 .716 .722 r
.54644 .58969 m .61939 .48669 L .65091 .54396 L p F P
0 g
s
.773 .639 .713 r
.67047 .328 m .58701 .39879 L .55436 .29354 L p F P
0 g
s
.773 .639 .713 r
.55436 .29354 m .64612 .2649 L .67047 .328 L p F P
0 g
s
.636 .509 .691 r
.47327 .32564 m .40058 .35388 L .36387 .20612 L p F P
0 g
s
.636 .509 .691 r
.36387 .20612 m .43713 .18609 L .47327 .32564 L p F P
0 g
s
.544 .447 .695 r
.47522 .65426 m .40787 .63679 L .37194 .51145 L p F P
0 g
s
.544 .447 .695 r
.37194 .51145 m .4377 .50325 L .47522 .65426 L p F P
0 g
s
.488 .411 .695 r
.40787 .63679 m .47522 .65426 L .51316 .80695 L p F P
0 g
s
.738 .604 .708 r
.64612 .2649 m .55436 .29354 L .52173 .17964 L p F P
0 g
s
.738 .604 .708 r
.52173 .17964 m .62148 .19307 L .64612 .2649 L p F P
0 g
s
.688 .552 .694 r
.55436 .29354 m .47327 .32564 L .43713 .18609 L p F P
0 g
s
.688 .552 .694 r
.43713 .18609 m .52173 .17964 L .55436 .29354 L p F P
0 g
s
.646 .518 .693 r
.50974 .46277 m .4377 .50325 L .40058 .35388 L p F P
0 g
s
.646 .518 .693 r
.40058 .35388 m .47327 .32564 L .50974 .46277 L p F P
0 g
s
.76 .624 .71 r
.61939 .48669 m .54644 .58969 L .50974 .46277 L p F P
0 g
s
.76 .624 .71 r
.50974 .46277 m .58701 .39879 L .61939 .48669 L p F P
0 g
s
.713 .577 .7 r
.47327 .32564 m .55436 .29354 L .58701 .39879 L p F P
0 g
s
.713 .577 .7 r
.58701 .39879 m .50974 .46277 L .47327 .32564 L p F P
0 g
s
.748 .641 .742 r
.5828 .67399 m .51316 .80695 L .47522 .65426 L p F P
0 g
s
.748 .641 .742 r
.47522 .65426 m .54644 .58969 L .5828 .67399 L p F P
0 g
s
.668 .542 .702 r
.54644 .58969 m .47522 .65426 L .4377 .50325 L p F P
0 g
s
.668 .542 .702 r
.4377 .50325 m .50974 .46277 L .54644 .58969 L p F P
0 g
s
.488 .411 .695 r
.62268 .98396 m .58537 .89857 L .51316 .80695 L p F P
0 g
s
.488 .411 .695 r
.51316 .80695 m .55152 .96133 L .62268 .98396 L p F P
0 g
s
.749 .642 .743 r
.55152 .96133 m .51316 .80695 L .44193 .94293 L p F P
0 g
s
.965 .91 .709 r
.40243 .94928 m .44193 .94293 L .51316 .80695 L p F P
0 g
s
.726 .338 .315 r
.47381 .87943 m .51316 .80695 L .58537 .89857 L p F P
0 g
s
.965 .91 .709 r
.51316 .80695 m .47381 .87943 L .40243 .94928 L p F P
0 g
s
.544 .447 .695 r
.66068 1.11564 m .62268 .98396 L .55152 .96133 L p F P
0 g
s
.544 .447 .695 r
.55152 .96133 m .59031 1.11744 L .66068 1.11564 L p F P
0 g
s
.668 .541 .701 r
.59031 1.11744 m .55152 .96133 L .47946 1.02693 L p F P
0 g
s
.749 .642 .743 r
.44193 .94293 m .47946 1.02693 L .55152 .96133 L p F P
0 g
s
.668 .541 .701 r
.47946 1.02693 m .51663 1.15691 L .59031 1.11744 L p F P
0 g
s
.761 .625 .71 r
.51663 1.15691 m .47946 1.02693 L .40371 1.1369 L p F P
0 g
s
.846 .718 .722 r
.47946 1.02693 m .44193 .94293 L .36906 1.08204 L p F P
0 g
s
.846 .718 .722 r
.36906 1.08204 m .40371 1.1369 L .47946 1.02693 L p F P
0 g
s
.645 .518 .693 r
.62953 1.27531 m .59031 1.11744 L .51663 1.15691 L p F P
0 g
s
.645 .518 .693 r
.51663 1.15691 m .55404 1.30026 L .62953 1.27531 L p F P
0 g
s
.713 .577 .7 r
.55404 1.30026 m .51663 1.15691 L .43743 1.22545 L p F P
0 g
s
.761 .625 .71 r
.40371 1.1369 m .43743 1.22545 L .51663 1.15691 L p F P
0 g
s
.565 .46 .694 r
.6992 1.26081 m .66068 1.11564 L .59031 1.11744 L p F P
0 g
s
.565 .46 .694 r
.59031 1.11744 m .62953 1.27531 L .6992 1.26081 L p F P
0 g
s
.94 .844 .72 r
.44193 .94293 m .40243 .94928 L .33267 1.06947 L p F P
0 g
s
.94 .844 .72 r
.33267 1.06947 m .36906 1.08204 L .44193 .94293 L p F P
0 g
s
.635 .508 .691 r
.6692 1.43496 m .62953 1.27531 L .55404 1.30026 L p F P
0 g
s
.635 .508 .691 r
.55404 1.30026 m .59181 1.44921 L .6692 1.43496 L p F P
0 g
s
.687 .551 .694 r
.59181 1.44921 m .55404 1.30026 L .47086 1.334 L p F P
0 g
s
.713 .577 .7 r
.43743 1.22545 m .47086 1.334 L .55404 1.30026 L p F P
0 g
s
.775 .641 .713 r
.47086 1.334 m .43743 1.22545 L .34868 1.3077 L p F P
0 g
s
.822 .689 .717 r
.43743 1.22545 m .40371 1.1369 L .32199 1.25798 L p F P
0 g
s
.822 .689 .717 r
.32199 1.25798 m .34868 1.3077 L .43743 1.22545 L p F P
0 g
s
.687 .551 .694 r
.47086 1.334 m .50432 1.45375 L .59181 1.44921 L p F P
0 g
s
.739 .605 .708 r
.50432 1.45375 m .47086 1.334 L .37484 1.37082 L p F P
0 g
s
.775 .641 .713 r
.34868 1.3077 m .37484 1.37082 L .47086 1.334 L p F P
0 g
s
.875 .747 .718 r
.40371 1.1369 m .36906 1.08204 L .2945 1.22439 L p F P
0 g
s
.875 .747 .718 r
.2945 1.22439 m .32199 1.25798 L .40371 1.1369 L p F P
0 g
s
.739 .605 .708 r
.37484 1.37082 m .4007 1.44429 L .50432 1.45375 L p F P
0 g
s
.847 .656 .644 r
.21817 1.37009 m .4007 1.44429 L .37484 1.37082 L closepath p F P
0 g
s
.553 0 0 r
.21817 1.37009 m .37349 1.43731 L .4007 1.44429 L closepath p F P
0 g
s
.164 0 0 r
.4007 1.44429 m .37349 1.43731 L p .48299 1.45107 L F P
0 g
s
.164 0 0 r
.50432 1.45375 m .47661 1.45122 L p .48299 1.45107 L F P
0 g
s
.164 0 0 r
.47661 1.45122 m .4007 1.44429 L p .48299 1.45107 L F P
0 g
s
.164 0 0 r
.37349 1.43731 m .47013 1.45093 L .50432 1.45375 L p F P
0 g
s
.027 .599 .722 r
.47013 1.45093 m .55495 1.44935 L .55635 1.44935 L p F P
0 g
s
.027 .599 .722 r
.55635 1.44935 m .59181 1.44921 L p .5173 1.45026 L F P
0 g
s
.027 .599 .722 r
.47013 1.45093 m .55635 1.44935 L .5173 1.45026 L F
.59181 1.44921 m .50432 1.45375 L .47013 1.45093 L p F P
0 g
s
.576 .467 .693 r
.73819 1.41166 m .6992 1.26081 L .62953 1.27531 L p F P
0 g
s
.576 .467 .693 r
.62953 1.27531 m .6692 1.43496 L .73819 1.41166 L p F P
0 g
s
.233 .752 .815 r
.6692 1.43496 m .59181 1.44921 L .55495 1.44935 L p F P
0 g
s
.848 .67 .661 r
.21817 1.37009 m .37484 1.37082 L .34868 1.3077 L closepath p F P
0 g
s
.382 .364 .714 r
.72861 1.14332 m .69467 1.05207 L .62268 .98396 L p F P
0 g
s
.382 .364 .714 r
.62268 .98396 m .66068 1.11564 L .72861 1.14332 L p F P
0 g
s
.056 .238 .734 r
.58537 .89857 m .62268 .98396 L .69467 1.05207 L p F P
0 g
s
.459 .4 .704 r
.76316 1.25488 m .72861 1.14332 L .66068 1.11564 L p F P
0 g
s
.459 .4 .704 r
.66068 1.11564 m .6992 1.26081 L .76316 1.25488 L p F P
0 g
s
.444 .877 .896 r
.73819 1.41166 m .6692 1.43496 L .63233 1.43592 L p F P
0 g
s
.233 .752 .815 r
.55495 1.44935 m .63233 1.43592 L .6692 1.43496 L p F P
0 g
s
.857 .697 .683 r
.21817 1.37009 m .34868 1.3077 L .32199 1.25798 L closepath p F P
0 g
s
.923 .811 .719 r
.36906 1.08204 m .33267 1.06947 L .26594 1.2082 L p F P
0 g
s
.923 .811 .719 r
.26594 1.2082 m .2945 1.22439 L .36906 1.08204 L p F P
0 g
s
.056 .238 .734 r
.69467 1.05207 m .66135 .99497 L .58537 .89857 L p F P
0 g
s
.785 .301 .069 r
.54819 .90412 m .58537 .89857 L .66135 .99497 L p F P
0 g
s
.726 .338 .315 r
.58537 .89857 m .54819 .90412 L .47381 .87943 L p F P
0 g
s
.497 .421 .7 r
.79823 1.37783 m .76316 1.25488 L .6992 1.26081 L p F P
0 g
s
.497 .421 .7 r
.6992 1.26081 m .73819 1.41166 L .79823 1.37783 L p F P
0 g
s
.882 .746 .707 r
.21817 1.37009 m .32199 1.25798 L .2945 1.22439 L closepath p F P
0 g
s
.066 .603 .857 r
.47013 1.45093 m .37349 1.43731 L .3458 1.42528 L p F P
0 g
s
0 .303 .652 r
.21817 1.37009 m .3458 1.42528 L .37349 1.43731 L closepath p F P
0 g
s
.258 .74 .929 r
.55495 1.44935 m .47013 1.45093 L .43499 1.43934 L p F P
0 g
s
.066 .603 .857 r
.3458 1.42528 m .43499 1.43934 L .47013 1.45093 L p F P
0 g
s
.938 .965 .703 r
.40243 .94928 m .36019 1.00393 L .29401 1.09189 L p F P
0 g
s
.938 .965 .703 r
.29401 1.09189 m .33267 1.06947 L .40243 .94928 L p F P
0 g
s
0 0 0 r
.36019 1.00393 m .40243 .94928 L .47381 .87943 L p F P
0 g
s
.627 .948 .942 r
.79823 1.37783 m .73819 1.41166 L .7034 1.41113 L p F P
0 g
s
.444 .877 .896 r
.63233 1.43592 m .7034 1.41113 L .73819 1.41166 L p F P
0 g
s
.567 .161 .232 r
.43191 .95663 m .47381 .87943 L .54819 .90412 L p F P
0 g
s
0 0 0 r
.47381 .87943 m .43191 .95663 L .36019 1.00393 L p F P
0 g
s
.923 .811 .719 r
.21817 1.37009 m .2945 1.22439 L .26594 1.2082 L closepath p F P
0 g
s
.429 .839 .97 r
.63233 1.43592 m .55495 1.44935 L .51678 1.43843 L p F P
0 g
s
.258 .74 .929 r
.43499 1.43934 m .51678 1.43843 L .55495 1.44935 L p F P
0 g
s
.954 .885 .726 r
.33267 1.06947 m .29401 1.09189 L .2361 1.20863 L p F P
0 g
s
.954 .885 .726 r
.2361 1.20863 m .26594 1.2082 L .33267 1.06947 L p F P
0 g
s
.242 .676 .959 r
.43499 1.43934 m .3458 1.42528 L .31767 1.40839 L p F P
0 g
s
.002 .502 .863 r
.21817 1.37009 m .31767 1.40839 L .3458 1.42528 L closepath p F P
0 g
s
.289 .315 .715 r
.81855 1.25119 m .79245 1.18502 L .72861 1.14332 L p F P
0 g
s
.289 .315 .715 r
.72861 1.14332 m .76316 1.25488 L .81855 1.25119 L p F P
0 g
s
.135 .253 .722 r
.69467 1.05207 m .72861 1.14332 L .79245 1.18502 L p F P
0 g
s
.573 .899 .983 r
.7034 1.41113 m .63233 1.43592 L .59394 1.425 L p F P
0 g
s
.429 .839 .97 r
.51678 1.43843 m .59394 1.425 L .63233 1.43592 L p F P
0 g
s
.364 .349 .709 r
.84505 1.32794 m .81855 1.25119 L .76316 1.25488 L p F P
0 g
s
.364 .349 .709 r
.76316 1.25488 m .79823 1.37783 L .84505 1.32794 L p F P
0 g
s
.135 .253 .722 r
.79245 1.18502 m .76675 1.13254 L .69467 1.05207 L p F P
0 g
s
0 .063 .624 r
.66135 .99497 m .69467 1.05207 L .76675 1.13254 L p F P
0 g
s
.751 .948 .943 r
.84505 1.32794 m .79823 1.37783 L .76762 1.37375 L p F P
0 g
s
.627 .948 .942 r
.7034 1.41113 m .76762 1.37375 L .79823 1.37783 L p F P
0 g
s
.961 .864 .698 r
.21817 1.37009 m .26594 1.2082 L .2361 1.20863 L closepath p F P
0 g
s
.403 .771 .994 r
.51678 1.43843 m .43499 1.43934 L .39898 1.41953 L p F P
0 g
s
.242 .676 .959 r
.31767 1.40839 m .39898 1.41953 L .43499 1.43934 L p F P
0 g
s
.785 .301 .069 r
.66135 .99497 m .62829 .98074 L .54819 .90412 L p F P
0 g
s
.718 .296 .244 r
.50945 .9583 m .54819 .90412 L .62829 .98074 L p F P
0 g
s
.567 .161 .232 r
.54819 .90412 m .50945 .9583 L .43191 .95663 L p F P
0 g
s
.982 .883 .655 r
.21817 1.37009 m .2361 1.20863 L .20482 1.22333 L closepath p F P
0 g
s
.99 .881 .615 r
.21817 1.37009 m .20482 1.22333 L .17203 1.24959 L closepath p F P
0 g
s
.178 .582 .939 r
.21817 1.37009 m .28915 1.38668 L .31767 1.40839 L closepath p F P
0 g
s
.251 .586 .946 r
.21817 1.37009 m .26026 1.36012 L .28915 1.38668 L closepath p F P
0 g
s
.248 .546 .927 r
.21817 1.37009 m .23107 1.32859 L .26026 1.36012 L closepath p F P
0 g
s
.181 .47 .89 r
.21817 1.37009 m .20164 1.29186 L .23107 1.32859 L closepath p F P
0 g
s
.05 .35 .825 r
.21817 1.37009 m .17203 1.24959 L .20164 1.29186 L closepath p F P
0 g
s
.685 .922 .971 r
.76762 1.37375 m .7034 1.41113 L .6671 1.39942 L p F P
0 g
s
.573 .899 .983 r
.59394 1.425 m .6671 1.39942 L .7034 1.41113 L p F P
0 g
s
.354 .688 .981 r
.39898 1.41953 m .31767 1.40839 L .28915 1.38668 L p F P
0 g
s
.53 .83 .999 r
.59394 1.425 m .51678 1.43843 L .47741 1.41727 L p F P
0 g
s
.403 .771 .994 r
.39898 1.41953 m .47741 1.41727 L .51678 1.43843 L p F P
0 g
s
0 .063 .624 r
.76675 1.13254 m .7414 1.09653 L .66135 .99497 L p F P
0 g
s
.76 .248 0 r
.62829 .98074 m .66135 .99497 L .7414 1.09653 L p F P
0 g
s
.947 .957 .724 r
.20482 1.22333 m .2361 1.20863 L .29401 1.09189 L p F P
0 g
s
.629 .863 .986 r
.6671 1.39942 m .59394 1.425 L .55418 1.40314 L p F P
0 g
s
.53 .83 .999 r
.47741 1.41727 m .55418 1.40314 L .59394 1.425 L p F P
0 g
s
.482 .752 .989 r
.47741 1.41727 m .39898 1.41953 L .36219 1.39168 L p F P
0 g
s
.354 .688 .981 r
.28915 1.38668 m .36219 1.39168 L .39898 1.41953 L p F P
0 g
s
.676 .895 .54 r
.25291 1.13648 m .29401 1.09189 L .36019 1.00393 L p F P
0 g
s
.947 .957 .724 r
.29401 1.09189 m .25291 1.13648 L .20482 1.22333 L p F P
0 g
s
.058 0 0 r
.31513 1.07509 m .36019 1.00393 L .43191 .95663 L p F P
0 g
s
.676 .895 .54 r
.36019 1.00393 m .31513 1.07509 L .25291 1.13648 L p F P
0 g
s
.42 .671 .966 r
.36219 1.39168 m .28915 1.38668 L .26026 1.36012 L p F P
0 g
s
.751 .948 .943 r
.76762 1.37375 m .82168 1.31935 L .84505 1.32794 L p F P
0 g
s
.763 .91 .939 r
.82168 1.31935 m .76762 1.37375 L .73576 1.36071 L p F P
0 g
s
.685 .922 .971 r
.6671 1.39942 m .73576 1.36071 L .76762 1.37375 L p F P
0 g
s
0 0 .465 r
.81855 1.25119 m .84505 1.32794 L .82584 1.20367 L closepath p F P
0 g
s
.896 .934 .832 r
.82168 1.31935 m .82584 1.20367 L .84505 1.32794 L closepath p F P
0 g
s
0 0 .521 r
.79245 1.18502 m .81855 1.25119 L .82584 1.20367 L closepath p F P
0 g
s
.483 .074 .189 r
.38719 1.039 m .43191 .95663 L .50945 .9583 L p F P
0 g
s
.058 0 0 r
.43191 .95663 m .38719 1.039 L .31513 1.07509 L p F P
0 g
s
.706 .876 .961 r
.73576 1.36071 m .6671 1.39942 L .62943 1.37737 L p F P
0 g
s
.629 .863 .986 r
.55418 1.40314 m .62943 1.37737 L .6671 1.39942 L p F P
0 g
s
0 0 .554 r
.76675 1.13254 m .79245 1.18502 L .82584 1.20367 L closepath p F P
0 g
s
.578 .791 .98 r
.55418 1.40314 m .47741 1.41727 L .43696 1.38619 L p F P
0 g
s
.482 .752 .989 r
.36219 1.39168 m .43696 1.38619 L .47741 1.41727 L p F P
0 g
s
.76 .248 0 r
.7414 1.09653 m .71623 1.0783 L .62829 .98074 L p F P
0 g
s
.777 .316 .15 r
.59469 1.00196 m .62829 .98074 L .71623 1.0783 L p F P
0 g
s
.718 .296 .244 r
.62829 .98074 m .59469 1.00196 L .50945 .9583 L p F P
0 g
s
.42 .671 .966 r
.26026 1.36012 m .32469 1.35573 L .36219 1.39168 L p F P
0 g
s
.458 .644 .938 r
.32469 1.35573 m .26026 1.36012 L .23107 1.32859 L p F P
0 g
s
.524 .717 .96 r
.43696 1.38619 m .36219 1.39168 L .32469 1.35573 L p F P
0 g
s
0 0 .49 r
.7414 1.09653 m .76675 1.13254 L .82584 1.20367 L closepath p F P
0 g
s
.855 .977 .674 r
.17203 1.24959 m .20482 1.22333 L .25291 1.13648 L p F P
0 g
s
.856 .909 .869 r
.79755 1.30554 m .82584 1.20367 L .82168 1.31935 L closepath p F P
0 g
s
.763 .91 .939 r
.73576 1.36071 m .79755 1.30554 L .82168 1.31935 L p F P
0 g
s
.651 .814 .962 r
.62943 1.37737 m .55418 1.40314 L .51316 1.3707 L p F P
0 g
s
.578 .791 .98 r
.43696 1.38619 m .51316 1.3707 L .55418 1.40314 L p F P
0 g
s
.65 .236 .245 r
.46837 1.0291 m .50945 .9583 L .59469 1.00196 L p F P
0 g
s
.483 .074 .189 r
.50945 .9583 m .46837 1.0291 L .38719 1.039 L p F P
0 g
s
.764 .871 .926 r
.79755 1.30554 m .73576 1.36071 L .70274 1.33925 L p F P
0 g
s
.706 .876 .961 r
.62943 1.37737 m .70274 1.33925 L .73576 1.36071 L p F P
0 g
s
.458 .644 .938 r
.23107 1.32859 m .28661 1.3114 L .32469 1.35573 L p F P
0 g
s
.479 .612 .905 r
.28661 1.3114 m .23107 1.32859 L .20164 1.29186 L p F P
0 g
s
.713 .203 0 r
.71623 1.0783 m .7414 1.09653 L .82584 1.20367 L closepath p F P
0 g
s
.599 .746 .947 r
.51316 1.3707 m .43696 1.38619 L .39553 1.34511 L p F P
0 g
s
.524 .717 .96 r
.32469 1.35573 m .39553 1.34511 L .43696 1.38619 L p F P
0 g
s
.71 .828 .938 r
.70274 1.33925 m .62943 1.37737 L .59049 1.34527 L p F P
0 g
s
.651 .814 .962 r
.51316 1.3707 m .59049 1.34527 L .62943 1.37737 L p F P
0 g
s
.546 .678 .925 r
.39553 1.34511 m .32469 1.35573 L .28661 1.3114 L p F P
0 g
s
.855 .977 .674 r
.25291 1.13648 m .20923 1.19493 L .17203 1.24959 L p F P
0 g
s
0 0 0 r
.20923 1.19493 m .25291 1.13648 L .31513 1.07509 L p F P
0 g
s
.479 .612 .905 r
.20164 1.29186 m .24807 1.25811 L .28661 1.3114 L p F P
0 g
s
.488 .578 .872 r
.24807 1.25811 m .20164 1.29186 L .17203 1.24959 L p F P
0 g
s
.823 .875 .883 r
.77273 1.28668 m .82584 1.20367 L .79755 1.30554 L closepath p F P
0 g
s
.764 .871 .926 r
.70274 1.33925 m .77273 1.28668 L .79755 1.30554 L p F P
0 g
s
.758 .833 .909 r
.77273 1.28668 m .70274 1.33925 L .66864 1.30957 L p F P
0 g
s
.71 .828 .938 r
.59049 1.34527 m .66864 1.30957 L .70274 1.33925 L p F P
0 g
s
.777 .316 .15 r
.71623 1.0783 m .69102 1.07702 L .59469 1.00196 L p F P
0 g
s
.741 .308 .222 r
.5598 1.04566 m .59469 1.00196 L .69102 1.07702 L p F P
0 g
s
.65 .236 .245 r
.59469 1.00196 m .5598 1.04566 L .46837 1.0291 L p F P
0 g
s
.658 .767 .93 r
.59049 1.34527 m .51316 1.3707 L .47101 1.32759 L p F P
0 g
s
.599 .746 .947 r
.39553 1.34511 m .47101 1.32759 L .51316 1.3707 L p F P
0 g
s
.813 .33 .039 r
.69102 1.07702 m .71623 1.0783 L .82584 1.20367 L closepath p F P
0 g
s
.488 .578 .872 r
.17203 1.24959 m .20923 1.19493 L .24807 1.25811 L p F P
0 g
s
.167 0 .011 r
.26702 1.15548 m .31513 1.07509 L .38719 1.039 L p F P
0 g
s
0 0 0 r
.31513 1.07509 m .26702 1.15548 L .20923 1.19493 L p F P
0 g
s
.546 .678 .925 r
.28661 1.3114 m .35328 1.29361 L .39553 1.34511 L p F P
0 g
s
.557 .64 .888 r
.35328 1.29361 m .28661 1.3114 L .24807 1.25811 L p F P
0 g
s
.609 .702 .911 r
.47101 1.32759 m .39553 1.34511 L .35328 1.29361 L p F P
0 g
s
.801 .839 .88 r
.74723 1.26284 m .82584 1.20367 L .77273 1.28668 L closepath p F P
0 g
s
.758 .833 .909 r
.66864 1.30957 m .74723 1.26284 L .77273 1.28668 L p F P
0 g
s
.707 .783 .911 r
.66864 1.30957 m .59049 1.34527 L .5504 1.30305 L p F P
0 g
s
.658 .767 .93 r
.47101 1.32759 m .5504 1.30305 L .59049 1.34527 L p F P
0 g
s
.44 .032 .167 r
.33937 1.12709 m .38719 1.039 L .46837 1.0291 L p F P
0 g
s
.167 0 .011 r
.38719 1.039 m .33937 1.12709 L .26702 1.15548 L p F P
0 g
s
.749 .798 .892 r
.74723 1.26284 m .66864 1.30957 L .63354 1.2716 L p F P
0 g
s
.707 .783 .911 r
.5504 1.30305 m .63354 1.2716 L .66864 1.30957 L p F P
0 g
s
.557 .64 .888 r
.24807 1.25811 m .31037 1.23087 L .35328 1.29361 L p F P
0 g
s
.562 .603 .852 r
.31037 1.23087 m .24807 1.25811 L .20923 1.19493 L p F P
0 g
s
.658 .723 .897 r
.5504 1.30305 m .47101 1.32759 L .42786 1.27334 L p F P
0 g
s
.609 .702 .911 r
.35328 1.29361 m .42786 1.27334 L .47101 1.32759 L p F P
0 g
s
.84 .401 .185 r
.66547 1.09032 m .69102 1.07702 L .82584 1.20367 L closepath p F P
0 g
s
.741 .308 .222 r
.69102 1.07702 m .66547 1.09032 L .5598 1.04566 L p F P
0 g
s
.792 .806 .864 r
.72111 1.23398 m .82584 1.20367 L .74723 1.26284 L closepath p F P
0 g
s
.749 .798 .892 r
.63354 1.2716 m .72111 1.23398 L .74723 1.26284 L p F P
0 g
s
.611 .662 .875 r
.42786 1.27334 m .35328 1.29361 L .31037 1.23087 L p F P
0 g
s
.596 .182 .229 r
.42458 1.10922 m .46837 1.0291 L .5598 1.04566 L p F P
0 g
s
.44 .032 .167 r
.46837 1.0291 m .42458 1.10922 L .33937 1.12709 L p F P
0 g
s
.852 .442 .257 r
.63932 1.11545 m .66547 1.09032 L .82584 1.20367 L closepath p F P
0 g
s
.793 .777 .838 r
.69439 1.19997 m .82584 1.20367 L .72111 1.23398 L closepath p F P
0 g
s
.803 .754 .807 r
.66711 1.16057 m .82584 1.20367 L .69439 1.19997 L closepath p F P
0 g
s
.818 .735 .772 r
.63932 1.11545 m .82584 1.20367 L .66711 1.16057 L closepath p F P
0 g
s
.7 .742 .884 r
.63354 1.2716 m .5504 1.30305 L .50928 1.25029 L p F P
0 g
s
.658 .723 .897 r
.42786 1.27334 m .50928 1.25029 L .5504 1.30305 L p F P
0 g
s
.562 .603 .852 r
.20923 1.19493 m .26702 1.15548 L .31037 1.23087 L p F P
0 g
s
.739 .764 .874 r
.72111 1.23398 m .63354 1.2716 L .59752 1.22503 L p F P
0 g
s
.7 .742 .884 r
.50928 1.25029 m .59752 1.22503 L .63354 1.2716 L p F P
0 g
s
.705 .283 .241 r
.52315 1.10345 m .5598 1.04566 L .66547 1.09032 L p F P
0 g
s
.596 .182 .229 r
.5598 1.04566 m .52315 1.10345 L .42458 1.10922 L p F P
0 g
s
.739 .764 .874 r
.59752 1.22503 m .69439 1.19997 L .72111 1.23398 L p F P
0 g
s
.654 .682 .864 r
.50928 1.25029 m .42786 1.27334 L .38391 1.20703 L p F P
0 g
s
.611 .662 .875 r
.31037 1.23087 m .38391 1.20703 L .42786 1.27334 L p F P
0 g
s
.609 .622 .839 r
.38391 1.20703 m .31037 1.23087 L .26702 1.15548 L p F P
0 g
s
.705 .283 .241 r
.66547 1.09032 m .63932 1.11545 L .52315 1.10345 L p F P
0 g
s
.691 .704 .857 r
.59752 1.22503 m .50928 1.25029 L .46728 1.18615 L p F P
0 g
s
.654 .682 .864 r
.38391 1.20703 m .46728 1.18615 L .50928 1.25029 L p F P
0 g
s
.727 .733 .856 r
.69439 1.19997 m .59752 1.22503 L .56069 1.1693 L p F P
0 g
s
.727 .733 .856 r
.56069 1.1693 m .66711 1.16057 L .69439 1.19997 L p F P
0 g
s
.609 .622 .839 r
.26702 1.15548 m .33937 1.12709 L .38391 1.20703 L p F P
0 g
s
.691 .704 .857 r
.46728 1.18615 m .56069 1.1693 L .59752 1.22503 L p F P
0 g
s
.647 .643 .832 r
.46728 1.18615 m .38391 1.20703 L .33937 1.12709 L p F P
0 g
s
.712 .702 .839 r
.66711 1.16057 m .56069 1.1693 L .52315 1.10345 L p F P
0 g
s
.712 .702 .839 r
.52315 1.10345 m .63932 1.11545 L .66711 1.16057 L p F P
0 g
s
.681 .667 .83 r
.56069 1.1693 m .46728 1.18615 L .42458 1.10922 L p F P
0 g
s
.647 .643 .832 r
.33937 1.12709 m .42458 1.10922 L .46728 1.18615 L p F P
0 g
s
.681 .667 .83 r
.42458 1.10922 m .52315 1.10345 L .56069 1.1693 L p F P
0 g
s
.25 Mabswid
.64785 0 m
.92348 .39072 L
s
.92348 .39072 m
1 1.47188 L
s
1 1.47188 m
.67613 1.13533 L
s
.67613 1.13533 m
.64785 0 L
s
.0843 .2212 m
0 1.32748 L
s
0 1.32748 m
.67613 1.13533 L
s
.67613 1.13533 m
.64785 0 L
s
.64785 0 m
.0843 .2212 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.35.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics3D", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[7]= ",
 CellTags->"S5.35.1"]
}, Open  ]],

Cell[TextData[{
 "This plots the ellipsoid ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     StyleBox["x",
      "TI"], "2"], "+", "4", 
    SuperscriptBox[
     StyleBox["y",
      "TI"], "2"], "+", "9", 
    SuperscriptBox[
     StyleBox["z",
      "TI"], "2"], "\[LessEqual]", "36"}], TraditionalForm]], "InlineFormula",
  
  GridBoxOptions->{ColumnWidths->Automatic}],
 " intersected by the halfspace ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["x",
     "TI"], "+", "4", 
    StyleBox["y",
     "TI"], "+", "6", 
    StyleBox["z",
     "TI"], "\[GreaterEqual]", "3"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.35.1", "1.10"}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InequalityPlot3D", "[", "   ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      RowBox[{"4", 
       SuperscriptBox["y", "2"]}], "+", 
      RowBox[{"9", 
       SuperscriptBox["z", "2"]}]}], "\[LessEqual]", "36"}], "\[And]", 
    RowBox[{
     RowBox[{"x", "+", 
      RowBox[{"4", "y"}], "+", 
      RowBox[{"6", "z"}]}], "\[GreaterEqual]", "3"}]}], ",", " ", 
   RowBox[{"{", "x", "}"}], ",", " ", 
   RowBox[{"{", "y", "}"}], ",", " ", 
   RowBox[{"{", "z", "}"}]}], " ", "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellTags->"S5.35.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .66681 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0118139 1.01181 -0.146859 1.01181 [
[.05707 .25945 -5.35247 -9 ]
[.05707 .25945 6.64753 0 ]
[.21218 .20418 -11.153 -9 ]
[.21218 .20418 12.847 0 ]
[.37484 .14622 -2.90911 -9 ]
[.37484 .14622 3.09089 0 ]
[.54564 .08538 -9.11971 -9 ]
[.54564 .08538 8.88029 0 ]
[.7252 .02144 -3.18191 -9 ]
[.7252 .02144 2.81809 0 ]
[.89712 .09136 0 -6.02546 ]
[.89712 .09136 6 2.97454 ]
[.95613 .18051 0 -5.95926 ]
[.95613 .18051 6 3.04074 ]
[.98931 .24649 0 -5.91293 ]
[.98931 .24649 12 3.08707 ]
[.99653 .30672 0 -5.87523 ]
[.99653 .30672 6 3.12477 ]
[1.00397 .36877 0 -5.83647 ]
[1.00397 .36877 6 3.16353 ]
[1.01164 .43272 0 -5.7966 ]
[1.01164 .43272 6 3.2034 ]
[ 0 0 0 0 ]
[ 1 .66681 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02393 .28331 m
.82192 0 L
s
.05572 .27203 m
.05504 .27831 L
s
[(-5)] .05707 .25945 -0.10792 1 Mshowa
.21128 .21679 m
.21084 .2231 L
s
[(-2.5)] .21218 .20418 -0.07058 1 Mshowa
.37446 .15886 m
.37427 .16518 L
s
[(0)] .37484 .14622 -0.0303 1 Mshowa
.54581 .09803 m
.54589 .10435 L
s
[(2.5)] .54564 .08538 .0133 1 Mshowa
.72597 .03407 m
.72635 .04038 L
s
[(5)] .7252 .02144 .06064 1 Mshowa
.125 Mabswid
.08625 .26119 m
.08587 .26496 L
s
.11707 .25025 m
.11671 .25402 L
s
.14817 .2392 m
.14785 .24298 L
s
.17958 .22805 m
.17928 .23183 L
s
.24329 .20543 m
.24306 .20922 L
s
.27561 .19396 m
.2754 .19775 L
s
.30824 .18237 m
.30806 .18616 L
s
.34119 .17068 m
.34104 .17447 L
s
.40805 .14694 m
.40797 .15073 L
s
.44198 .13489 m
.44193 .13868 L
s
.47625 .12273 m
.47623 .12652 L
s
.51085 .11044 m
.51087 .11423 L
s
.58111 .08549 m
.5812 .08929 L
s
.61678 .07283 m
.6169 .07663 L
s
.6528 .06004 m
.65296 .06383 L
s
.6892 .04712 m
.68939 .05091 L
s
.02547 .28276 m
.02504 .28653 L
s
.76312 .02088 m
.76338 .02466 L
s
.80065 .00755 m
.80096 .01134 L
s
.25 Mabswid
.82192 0 m
.97494 .23096 L
s
.88514 .09542 m
.87915 .09745 L
s
[(0)] .89712 .09136 -1 .33899 Mshowa
.9441 .18441 m
.93808 .18636 L
s
[(2)] .95613 .18051 -1 .32428 Mshowa
.125 Mabswid
.83797 .02422 m
.83439 .02548 L
s
.85399 .0484 m
.8504 .04964 L
s
.86971 .07213 m
.86612 .07336 L
s
.90028 .11828 m
.89669 .11948 L
s
.91515 .14072 m
.91155 .14192 L
s
.92976 .16277 m
.92615 .16395 L
s
.95818 .20568 m
.95457 .20684 L
s
.97202 .22657 m
.96841 .22772 L
s
.25 Mabswid
.97494 .23096 m
1 .44054 L
s
.97725 .25028 m
.97121 .25217 L
s
[(-1)] .98931 .24649 -1 .31398 Mshowa
.98444 .31041 m
.97839 .31226 L
s
[(0)] .99653 .30672 -1 .30561 Mshowa
.99185 .37237 m
.98579 .37417 L
s
[(1)] 1.00397 .36877 -1 .29699 Mshowa
.99948 .43622 m
.99341 .43797 L
s
[(2)] 1.01164 .43272 -1 .28813 Mshowa
.125 Mabswid
.97867 .26216 m
.97505 .26329 L
s
.9801 .27412 m
.97647 .27525 L
s
.98154 .28615 m
.97791 .28727 L
s
.98298 .29824 m
.97936 .29936 L
s
.9859 .32266 m
.98227 .32376 L
s
.98738 .33497 m
.98374 .33607 L
s
.98886 .34736 m
.98522 .34846 L
s
.99035 .35983 m
.98671 .36091 L
s
.99336 .38498 m
.98972 .38606 L
s
.99487 .39768 m
.99123 .39875 L
s
.9964 .41045 m
.99276 .41151 L
s
.99794 .4233 m
.99429 .42435 L
s
.97583 .23846 m
.97222 .2396 L
s
.25 Mabswid
.02393 .28331 m
0 .49066 L
s
0 .49066 m
.21309 .66681 L
s
.21309 .66681 m
.22561 .46826 L
s
.22561 .46826 m
.02393 .28331 L
s
.82192 0 m
.97494 .23096 L
s
.97494 .23096 m
1 .44054 L
s
1 .44054 m
.84078 .21802 L
s
.84078 .21802 m
.82192 0 L
s
.02393 .28331 m
0 .49066 L
s
0 .49066 m
.84078 .21802 L
s
.84078 .21802 m
.82192 0 L
s
.82192 0 m
.02393 .28331 L
s
.22561 .46826 m
.97494 .23096 L
s
.97494 .23096 m
1 .44054 L
s
1 .44054 m
.21309 .66681 L
s
.21309 .66681 m
.22561 .46826 L
s
0 0 m
1 0 L
1 .66681 L
0 .66681 L
closepath
clip
newpath
.5 Mabswid
.658 .508 .669 r
.41278 .41394 m .41151 .40959 L .32579 .44784 L p F P
0 g
s
.658 .508 .669 r
.32579 .44784 m .3263 .45032 L .41278 .41394 L p F P
0 g
s
.706 .54 .66 r
.22852 .48712 m .3263 .45032 L .32579 .44784 L closepath p F P
0 g
s
.575 .939 .909 r
.3107 .44925 m .32579 .44784 L .41151 .40959 L p F P
0 g
s
.575 .939 .909 r
.32579 .44784 m .3107 .44925 L .21881 .48821 L p F P
0 g
s
.575 .939 .909 r
.21881 .48821 m .22852 .48712 L .32579 .44784 L p F P
0 g
s
.657 .503 .663 r
.41403 .41856 m .41278 .41394 L .3263 .45032 L p F P
0 g
s
.657 .503 .663 r
.3263 .45032 m .3268 .45296 L .41403 .41856 L p F P
0 g
s
.704 .534 .655 r
.22852 .48712 m .3268 .45296 L .3263 .45032 L closepath p F P
0 g
s
.656 .496 .656 r
.41529 .42349 m .41403 .41856 L .3268 .45296 L p F P
0 g
s
.656 .496 .656 r
.3268 .45296 m .32729 .4558 L .41529 .42349 L p F P
0 g
s
.702 .527 .649 r
.22852 .48712 m .32729 .4558 L .3268 .45296 L closepath p F P
0 g
s
.655 .489 .648 r
.41653 .42886 m .41529 .42349 L .32729 .4558 L p F P
0 g
s
.655 .489 .648 r
.32729 .4558 m .32777 .45889 L .41653 .42886 L p F P
0 g
s
.699 .52 .642 r
.22852 .48712 m .32777 .45889 L .32729 .4558 L closepath p F P
0 g
s
.653 .481 .638 r
.41777 .43483 m .41653 .42886 L .32777 .45889 L p F P
0 g
s
.653 .481 .638 r
.32777 .45889 m .32824 .46234 L .41777 .43483 L p F P
0 g
s
.696 .512 .634 r
.22852 .48712 m .32824 .46234 L .32777 .45889 L closepath p F P
0 g
s
.651 .471 .627 r
.41899 .44172 m .41777 .43483 L .32824 .46234 L p F P
0 g
s
.651 .471 .627 r
.32824 .46234 m .32868 .46635 L .41899 .44172 L p F P
0 g
s
.693 .502 .624 r
.22852 .48712 m .32868 .46635 L .32824 .46234 L closepath p F P
0 g
s
.647 .457 .612 r
.42018 .45039 m .41899 .44172 L .32868 .46635 L p F P
0 g
s
.647 .457 .612 r
.32868 .46635 m .32909 .47144 L .42018 .45039 L p F P
0 g
s
.689 .488 .61 r
.22852 .48712 m .32909 .47144 L .32868 .46635 L closepath p F P
0 g
s
.639 .427 .58 r
.42119 .46973 m .42018 .45039 L .32909 .47144 L p F P
0 g
s
.639 .427 .58 r
.32909 .47144 m .32924 .48302 L .42119 .46973 L p F P
0 g
s
.681 .461 .581 r
.22852 .48712 m .32924 .48302 L .32909 .47144 L closepath p F P
0 g
s
.575 .939 .909 r
.22852 .48712 m .21881 .48821 L .21276 .49057 L p F P
0 g
s
.575 .939 .909 r
.21276 .49057 m .22191 .48953 L .22852 .48712 L p F P
0 g
s
.67 .348 .421 r
.22852 .48712 m .22191 .48953 L .21121 .51417 L p F P
0 g
s
.67 .348 .421 r
.21121 .51417 m .21707 .51537 L .22852 .48712 L p F P
0 g
s
.671 .419 .531 r
.22852 .48712 m .32823 .49356 L .32924 .48302 L closepath p F P
0 g
s
.665 .387 .489 r
.22852 .48712 m .32747 .49759 L .32823 .49356 L closepath p F P
0 g
s
.662 .369 .464 r
.22852 .48712 m .32675 .50054 L .32747 .49759 L closepath p F P
0 g
s
.659 .353 .443 r
.22852 .48712 m .32604 .50294 L .32675 .50054 L closepath p F P
0 g
s
.657 .34 .424 r
.22852 .48712 m .32535 .50497 L .32604 .50294 L closepath p F P
0 g
s
.655 .327 .405 r
.22852 .48712 m .32468 .50675 L .32535 .50497 L closepath p F P
0 g
s
.653 .315 .388 r
.22852 .48712 m .324 .50833 L .32468 .50675 L closepath p F P
0 g
s
.651 .304 .371 r
.22852 .48712 m .32333 .50975 L .324 .50833 L closepath p F P
0 g
s
.549 .102 .143 r
.32333 .50975 m .22852 .48712 L .21707 .51537 L p F P
0 g
s
.575 .939 .909 r
.22191 .48953 m .21276 .49057 L .20654 .49295 L p F P
0 g
s
.575 .939 .909 r
.20654 .49295 m .21509 .49197 L .22191 .48953 L p F P
0 g
s
.678 .352 .415 r
.22191 .48953 m .21509 .49197 L .2052 .51294 L p F P
0 g
s
.678 .352 .415 r
.2052 .51294 m .21121 .51417 L .22191 .48953 L p F P
0 g
s
.644 .53 .71 r
.49459 .37702 m .49263 .37124 L .41151 .40959 L p F P
0 g
s
.644 .53 .71 r
.41151 .40959 m .41278 .41394 L .49459 .37702 L p F P
0 g
s
.575 .939 .909 r
.39432 .41083 m .41151 .40959 L .49263 .37124 L p F P
0 g
s
.575 .939 .909 r
.41151 .40959 m .39432 .41083 L .3107 .44925 L p F P
0 g
s
.687 .356 .408 r
.21509 .49197 m .20799 .49444 L .19901 .5117 L p F P
0 g
s
.687 .356 .408 r
.19901 .5117 m .2052 .51294 L .21509 .49197 L p F P
0 g
s
.575 .939 .909 r
.21509 .49197 m .20654 .49295 L .20013 .49535 L p F P
0 g
s
.575 .939 .909 r
.20013 .49535 m .20799 .49444 L .21509 .49197 L p F P
0 g
s
.642 .522 .702 r
.49654 .38313 m .49459 .37702 L .41278 .41394 L p F P
0 g
s
.642 .522 .702 r
.41278 .41394 m .41403 .41856 L .49654 .38313 L p F P
0 g
s
.64 .513 .693 r
.4985 .38968 m .49654 .38313 L .41403 .41856 L p F P
0 g
s
.64 .513 .693 r
.41403 .41856 m .41529 .42349 L .4985 .38968 L p F P
0 g
s
.617 .362 .509 r
.42119 .46973 m .32924 .48302 L .32823 .49356 L p F P
0 g
s
.637 .503 .683 r
.50046 .39678 m .4985 .38968 L .41529 .42349 L p F P
0 g
s
.637 .503 .683 r
.41529 .42349 m .41653 .42886 L .50046 .39678 L p F P
0 g
s
.634 .491 .671 r
.50242 .40465 m .50046 .39678 L .41653 .42886 L p F P
0 g
s
.634 .491 .671 r
.41653 .42886 m .41777 .43483 L .50242 .40465 L p F P
0 g
s
.575 .939 .909 r
.20799 .49444 m .20013 .49535 L .19344 .49779 L p F P
0 g
s
.575 .939 .909 r
.19344 .49779 m .20054 .49696 L .20799 .49444 L p F P
0 g
s
.697 .358 .399 r
.20799 .49444 m .20054 .49696 L .19255 .51051 L p F P
0 g
s
.697 .358 .399 r
.19255 .51051 m .19901 .5117 L .20799 .49444 L p F P
0 g
s
.63 .476 .656 r
.50439 .41371 m .50242 .40465 L .41777 .43483 L p F P
0 g
s
.63 .476 .656 r
.41777 .43483 m .41899 .44172 L .50439 .41371 L p F P
0 g
s
.624 .457 .636 r
.50636 .42506 m .50439 .41371 L .41899 .44172 L p F P
0 g
s
.624 .457 .636 r
.41899 .44172 m .42018 .45039 L .50636 .42506 L p F P
0 g
s
.575 .939 .909 r
.20054 .49696 m .19344 .49779 L .18639 .50027 L p F P
0 g
s
.575 .939 .909 r
.18639 .50027 m .19259 .49954 L .20054 .49696 L p F P
0 g
s
.707 .359 .386 r
.20054 .49696 m .19259 .49954 L .18573 .50943 L p F P
0 g
s
.707 .359 .386 r
.18573 .50943 m .19255 .51051 L .20054 .49696 L p F P
0 g
s
.608 .411 .59 r
.50839 .45003 m .50636 .42506 L .42018 .45039 L p F P
0 g
s
.608 .411 .59 r
.42018 .45039 m .42119 .46973 L .50839 .45003 L p F P
0 g
s
.617 .362 .509 r
.32823 .49356 m .41955 .48657 L .42119 .46973 L p F P
0 g
s
.593 .294 .43 r
.41955 .48657 m .32823 .49356 L .32747 .49759 L p F P
0 g
s
.575 .939 .909 r
.19259 .49954 m .18639 .50027 L .17875 .50283 L p F P
0 g
s
.575 .939 .909 r
.17875 .50283 m .18387 .50222 L .19259 .49954 L p F P
0 g
s
.717 .358 .367 r
.19259 .49954 m .18387 .50222 L .17833 .50858 L p F P
0 g
s
.717 .358 .367 r
.17833 .50858 m .18573 .50943 L .19259 .49954 L p F P
0 g
s
.575 .939 .909 r
.21881 .48821 m .20899 .48932 L .2035 .49162 L p F P
0 g
s
.575 .939 .909 r
.2035 .49162 m .21276 .49057 L .21881 .48821 L p F P
0 g
s
.575 .939 .909 r
.20899 .48932 m .21881 .48821 L .3107 .44925 L p F P
0 g
s
.593 .294 .43 r
.32747 .49759 m .41808 .49273 L .41955 .48657 L p F P
0 g
s
.576 .25 .379 r
.41808 .49273 m .32747 .49759 L .32675 .50054 L p F P
0 g
s
.575 .939 .909 r
.21276 .49057 m .2035 .49162 L .19791 .49394 L p F P
0 g
s
.575 .939 .909 r
.19791 .49394 m .20654 .49295 L .21276 .49057 L p F P
0 g
s
.575 .939 .909 r
.20654 .49295 m .19791 .49394 L .19218 .49627 L p F P
0 g
s
.575 .939 .909 r
.19218 .49627 m .20013 .49535 L .20654 .49295 L p F P
0 g
s
.575 .939 .909 r
.2953 .45069 m .3107 .44925 L .39432 .41083 L p F P
0 g
s
.575 .939 .909 r
.3107 .44925 m .2953 .45069 L .20899 .48932 L p F P
0 g
s
.576 .25 .379 r
.32675 .50054 m .41664 .49711 L .41808 .49273 L p F P
0 g
s
.56 .209 .331 r
.41664 .49711 m .32675 .50054 L .32604 .50294 L p F P
0 g
s
.73 .355 .34 r
.18387 .50222 m .17368 .50508 L .16981 .50814 L p F P
0 g
s
.73 .355 .34 r
.16981 .50814 m .17833 .50858 L .18387 .50222 L p F P
0 g
s
.575 .939 .909 r
.18387 .50222 m .17875 .50283 L .17001 .50552 L p F P
0 g
s
.575 .939 .909 r
.17001 .50552 m .17368 .50508 L .18387 .50222 L p F P
0 g
s
.575 .939 .909 r
.20013 .49535 m .19218 .49627 L .18628 .49863 L p F P
0 g
s
.575 .939 .909 r
.18628 .49863 m .19344 .49779 L .20013 .49535 L p F P
0 g
s
.56 .209 .331 r
.32604 .50294 m .41521 .50056 L .41664 .49711 L p F P
0 g
s
.543 .17 .284 r
.41521 .50056 m .32604 .50294 L .32535 .50497 L p F P
0 g
s
.571 .316 .491 r
.50839 .45003 m .42119 .46973 L .41955 .48657 L p F P
0 g
s
.575 .939 .909 r
.19344 .49779 m .18628 .49863 L .18013 .50101 L p F P
0 g
s
.575 .939 .909 r
.18013 .50101 m .18639 .50027 L .19344 .49779 L p F P
0 g
s
.543 .17 .284 r
.32535 .50497 m .41379 .50341 L .41521 .50056 L p F P
0 g
s
.525 .131 .237 r
.41379 .50341 m .32535 .50497 L .32468 .50675 L p F P
0 g
s
.575 .939 .909 r
.18639 .50027 m .18013 .50101 L .1736 .50344 L p F P
0 g
s
.575 .939 .909 r
.1736 .50344 m .17875 .50283 L .18639 .50027 L p F P
0 g
s
.525 .131 .237 r
.32468 .50675 m .41237 .50583 L .41379 .50341 L p F P
0 g
s
.506 .092 .19 r
.41237 .50583 m .32468 .50675 L .324 .50833 L p F P
0 g
s
.8 .429 .352 r
.15466 .50902 m .16981 .50814 L .17368 .50508 L closepath p F P
0 g
s
.575 .939 .909 r
.15466 .50902 m .17368 .50508 L .17001 .50552 L closepath p F P
0 g
s
.626 .531 .727 r
.57631 .34634 m .57376 .3391 L .49459 .37702 L p F P
0 g
s
.626 .531 .727 r
.49459 .37702 m .49654 .38313 L .57631 .34634 L p F P
0 g
s
.628 .54 .736 r
.49263 .37124 m .49459 .37702 L .57376 .3391 L p F P
0 g
s
.623 .52 .717 r
.57887 .35408 m .57631 .34634 L .49654 .38313 L p F P
0 g
s
.623 .52 .717 r
.49654 .38313 m .4985 .38968 L .57887 .35408 L p F P
0 g
s
.628 .54 .736 r
.57376 .3391 m .57123 .33226 L .49263 .37124 L p F P
0 g
s
.575 .939 .909 r
.47492 .37207 m .49263 .37124 L .57123 .33226 L p F P
0 g
s
.575 .939 .909 r
.49263 .37124 m .47492 .37207 L .39432 .41083 L p F P
0 g
s
.619 .508 .705 r
.58143 .36246 m .57887 .35408 L .4985 .38968 L p F P
0 g
s
.619 .508 .705 r
.4985 .38968 m .50046 .39678 L .58143 .36246 L p F P
0 g
s
.575 .939 .909 r
.17875 .50283 m .1736 .50344 L .16633 .50596 L p F P
0 g
s
.575 .939 .909 r
.16633 .50596 m .17001 .50552 L .17875 .50283 L p F P
0 g
s
.506 .092 .19 r
.324 .50833 m .41096 .50791 L .41237 .50583 L p F P
0 g
s
.486 .053 .141 r
.41096 .50791 m .324 .50833 L .32333 .50975 L p F P
0 g
s
.615 .494 .692 r
.58402 .37173 m .58143 .36246 L .50046 .39678 L p F P
0 g
s
.615 .494 .692 r
.50046 .39678 m .50242 .40465 L .58402 .37173 L p F P
0 g
s
.609 .476 .675 r
.58664 .38238 m .58402 .37173 L .50242 .40465 L p F P
0 g
s
.609 .476 .675 r
.50242 .40465 m .50439 .41371 L .58664 .38238 L p F P
0 g
s
.617 .144 .109 r
.19901 .5117 m .19255 .51051 L .18511 .51501 L p F P
0 g
s
.636 .172 .133 r
.19255 .51051 m .18573 .50943 L .17923 .51333 L p F P
0 g
s
.636 .172 .133 r
.17923 .51333 m .18511 .51501 L .19255 .51051 L p F P
0 g
s
.486 .053 .141 r
.32333 .50975 m .40954 .50972 L .41096 .50791 L p F P
0 g
s
.283 0 0 r
.40954 .50972 m .32333 .50975 L .30739 .52576 L p F P
0 g
s
.549 .102 .143 r
.21707 .51537 m .30739 .52576 L .32333 .50975 L p F P
0 g
s
.597 .115 .081 r
.2052 .51294 m .19901 .5117 L .19075 .51659 L p F P
0 g
s
.617 .144 .109 r
.18511 .51501 m .19075 .51659 L .19901 .5117 L p F P
0 g
s
.655 .196 .151 r
.18573 .50943 m .17833 .50858 L .17299 .51161 L p F P
0 g
s
.655 .196 .151 r
.17299 .51161 m .17923 .51333 L .18573 .50943 L p F P
0 g
s
.577 .085 .05 r
.21121 .51417 m .2052 .51294 L .19624 .51806 L p F P
0 g
s
.597 .115 .081 r
.19075 .51659 m .19624 .51806 L .2052 .51294 L p F P
0 g
s
.601 .452 .651 r
.58933 .39566 m .58664 .38238 L .50439 .41371 L p F P
0 g
s
.601 .452 .651 r
.50439 .41371 m .50636 .42506 L .58933 .39566 L p F P
0 g
s
.673 .217 .162 r
.17833 .50858 m .16981 .50814 L .16603 .50995 L p F P
0 g
s
.673 .217 .162 r
.16603 .50995 m .17299 .51161 L .17833 .50858 L p F P
0 g
s
.555 .053 .018 r
.21707 .51537 m .21121 .51417 L .20162 .51942 L p F P
0 g
s
.577 .085 .05 r
.19624 .51806 m .20162 .51942 L .21121 .51417 L p F P
0 g
s
.575 .939 .909 r
.19414 .49269 m .2035 .49162 L .20899 .48932 L p F P
0 g
s
.575 .939 .909 r
.2035 .49162 m .19414 .49269 L .18918 .49494 L p F P
0 g
s
.575 .939 .909 r
.18918 .49494 m .19791 .49394 L .2035 .49162 L p F P
0 g
s
.575 .939 .909 r
.20899 .48932 m .19905 .49044 L .19414 .49269 L p F P
0 g
s
.575 .939 .909 r
.19905 .49044 m .20899 .48932 L .2953 .45069 L p F P
0 g
s
.575 .939 .909 r
.19791 .49394 m .18918 .49494 L .18416 .4972 L p F P
0 g
s
.575 .939 .909 r
.18416 .4972 m .19218 .49627 L .19791 .49394 L p F P
0 g
s
.555 .053 .018 r
.20162 .51942 m .2069 .52067 L .21707 .51537 L p F P
0 g
s
.261 0 0 r
.30739 .52576 m .21707 .51537 L .2069 .52067 L p F P
0 g
s
.575 .939 .909 r
.19218 .49627 m .18416 .4972 L .17906 .49947 L p F P
0 g
s
.575 .939 .909 r
.17906 .49947 m .18628 .49863 L .19218 .49627 L p F P
0 g
s
.575 .939 .909 r
.15466 .50902 m .17001 .50552 L .16633 .50596 L closepath p F P
0 g
s
.575 .939 .909 r
.18628 .49863 m .17906 .49947 L .17383 .50175 L p F P
0 g
s
.575 .939 .909 r
.17383 .50175 m .18013 .50101 L .18628 .49863 L p F P
0 g
s
.579 .395 .596 r
.59238 .42457 m .58933 .39566 L .50636 .42506 L p F P
0 g
s
.579 .395 .596 r
.50636 .42506 m .50839 .45003 L .59238 .42457 L p F P
0 g
s
.571 .316 .491 r
.41955 .48657 m .5065 .47112 L .50839 .45003 L p F P
0 g
s
.526 .211 .377 r
.5065 .47112 m .41955 .48657 L .41808 .49273 L p F P
0 g
s
.575 .939 .909 r
.18013 .50101 m .17383 .50175 L .16842 .50406 L p F P
0 g
s
.575 .939 .909 r
.16842 .50406 m .1736 .50344 L .18013 .50101 L p F P
0 g
s
.731 .29 .203 r
.15466 .50902 m .16603 .50995 L .16981 .50814 L closepath p F P
0 g
s
.575 .939 .909 r
.1736 .50344 m .16842 .50406 L .16264 .50641 L p F P
0 g
s
.575 .939 .909 r
.16264 .50641 m .16633 .50596 L .1736 .50344 L p F P
0 g
s
.575 .939 .909 r
.3767 .41209 m .39432 .41083 L .47492 .37207 L p F P
0 g
s
.575 .939 .909 r
.39432 .41083 m .3767 .41209 L .2953 .45069 L p F P
0 g
s
.575 .939 .909 r
.15466 .50902 m .16633 .50596 L .16264 .50641 L closepath p F P
0 g
s
.526 .211 .377 r
.41808 .49273 m .50455 .47857 L .5065 .47112 L p F P
0 g
s
.492 .139 .296 r
.50455 .47857 m .41808 .49273 L .41664 .49711 L p F P
0 g
s
.566 .026 0 r
.17923 .51333 m .17299 .51161 L .16774 .51297 L p F P
0 g
s
.601 .076 0 r
.17299 .51161 m .16603 .50995 L .16229 .51093 L p F P
0 g
s
.601 .076 0 r
.16229 .51093 m .16774 .51297 L .17299 .51161 L p F P
0 g
s
.645 .136 .023 r
.15466 .50902 m .16229 .51093 L .16603 .50995 L closepath p F P
0 g
s
.528 0 0 r
.18511 .51501 m .17923 .51333 L .17285 .51483 L p F P
0 g
s
.566 .026 0 r
.16774 .51297 m .17285 .51483 L .17923 .51333 L p F P
0 g
s
.488 0 0 r
.19075 .51659 m .18511 .51501 L .1778 .5165 L p F P
0 g
s
.528 0 0 r
.17285 .51483 m .1778 .5165 L .18511 .51501 L p F P
0 g
s
.575 .939 .909 r
.1632 .50468 m .16842 .50406 L .17383 .50175 L p F P
0 g
s
.575 .939 .909 r
.16842 .50406 m .1632 .50468 L .15893 .50685 L p F P
0 g
s
.575 .939 .909 r
.15893 .50685 m .16264 .50641 L .16842 .50406 L p F P
0 g
s
.575 .939 .909 r
.16748 .5025 m .17383 .50175 L .17906 .49947 L p F P
0 g
s
.575 .939 .909 r
.17383 .50175 m .16748 .5025 L .1632 .50468 L p F P
0 g
s
.575 .939 .909 r
.15466 .50902 m .16264 .50641 L .15893 .50685 L closepath p F P
0 g
s
.575 .939 .909 r
.17177 .50032 m .17906 .49947 L .18416 .4972 L p F P
0 g
s
.575 .939 .909 r
.17906 .49947 m .17177 .50032 L .16748 .5025 L p F P
0 g
s
.575 .939 .909 r
.27958 .45216 m .2953 .45069 L .3767 .41209 L p F P
0 g
s
.575 .939 .909 r
.2953 .45069 m .27958 .45216 L .19905 .49044 L p F P
0 g
s
.446 0 0 r
.19624 .51806 m .19075 .51659 L .18266 .518 L p F P
0 g
s
.488 0 0 r
.1778 .5165 m .18266 .518 L .19075 .51659 L p F P
0 g
s
.575 .939 .909 r
.17606 .49814 m .18416 .4972 L .18918 .49494 L p F P
0 g
s
.575 .939 .909 r
.18416 .4972 m .17606 .49814 L .17177 .50032 L p F P
0 g
s
.492 .139 .296 r
.41664 .49711 m .50258 .48374 L .50455 .47857 L p F P
0 g
s
.455 .069 .217 r
.50258 .48374 m .41664 .49711 L .41521 .50056 L p F P
0 g
s
.525 .271 .473 r
.59238 .42457 m .50839 .45003 L .5065 .47112 L p F P
0 g
s
.575 .939 .909 r
.18036 .49595 m .18918 .49494 L .19414 .49269 L p F P
0 g
s
.575 .939 .909 r
.18918 .49494 m .18036 .49595 L .17606 .49814 L p F P
0 g
s
.402 0 0 r
.20162 .51942 m .19624 .51806 L .18745 .51932 L p F P
0 g
s
.446 0 0 r
.18266 .518 m .18745 .51932 L .19624 .51806 L p F P
0 g
s
.575 .939 .909 r
.18466 .49376 m .19414 .49269 L .19905 .49044 L p F P
0 g
s
.575 .939 .909 r
.19414 .49269 m .18466 .49376 L .18036 .49595 L p F P
0 g
s
.509 0 0 r
.16774 .51297 m .16229 .51093 L .15858 .51131 L p F P
0 g
s
.574 .02 0 r
.15466 .50902 m .15858 .51131 L .16229 .51093 L closepath p F P
0 g
s
.575 .939 .909 r
.19905 .49044 m .18898 .49157 L .18466 .49376 L p F P
0 g
s
.575 .939 .909 r
.18898 .49157 m .19905 .49044 L .27958 .45216 L p F P
0 g
s
.556 0 0 r
.15466 .50902 m .15489 .5112 L .15858 .51131 L closepath p F P
0 g
s
.594 .025 0 r
.15466 .50902 m .15122 .51069 L .15489 .5112 L closepath p F P
0 g
s
.664 .113 0 r
.15466 .50902 m .14756 .50982 L .15122 .51069 L closepath p F P
0 g
s
.738 .215 0 r
.15466 .50902 m .14391 .50865 L .14756 .50982 L closepath p F P
0 g
s
.575 .939 .909 r
.15466 .50902 m .15893 .50685 L .1552 .5073 L closepath p F P
0 g
s
.575 .939 .909 r
.15466 .50902 m .1552 .5073 L .15145 .50775 L closepath p F P
0 g
s
.575 .939 .909 r
.15466 .50902 m .15145 .50775 L .14769 .5082 L closepath p F P
0 g
s
.575 .939 .909 r
.15466 .50902 m .14769 .5082 L .14391 .50865 L closepath p F P
0 g
s
.358 0 0 r
.2069 .52067 m .20162 .51942 L .19219 .5205 L p F P
0 g
s
.402 0 0 r
.18745 .51932 m .19219 .5205 L .20162 .51942 L p F P
0 g
s
.442 0 0 r
.17285 .51483 m .16774 .51297 L .16254 .51322 L p F P
0 g
s
.509 0 0 r
.15858 .51131 m .16254 .51322 L .16774 .51297 L p F P
0 g
s
.455 .069 .217 r
.41521 .50056 m .5006 .48769 L .50258 .48374 L p F P
0 g
s
.416 0 .136 r
.5006 .48769 m .41521 .50056 L .41379 .50341 L p F P
0 g
s
.575 .939 .909 r
.1552 .5073 m .15893 .50685 L .1632 .50468 L p F P
0 g
s
.358 0 0 r
.19219 .5205 m .1969 .52154 L .2069 .52067 L p F P
0 g
s
.261 0 0 r
.2069 .52067 m .29166 .52846 L .30739 .52576 L p F P
0 g
s
.078 .627 .831 r
.29166 .52846 m .2069 .52067 L .1969 .52154 L p F P
0 g
s
.372 0 0 r
.1778 .5165 m .17285 .51483 L .16654 .51482 L p F P
0 g
s
.442 0 0 r
.16254 .51322 m .16654 .51482 L .17285 .51483 L p F P
0 g
s
.575 .939 .909 r
.15795 .5053 m .1632 .50468 L .16748 .5025 L p F P
0 g
s
.575 .939 .909 r
.1632 .50468 m .15795 .5053 L .1552 .5073 L p F P
0 g
s
.404 0 0 r
.16254 .51322 m .15858 .51131 L .15489 .5112 L p F P
0 g
s
.416 0 .136 r
.41379 .50341 m .49861 .49086 L .5006 .48769 L p F P
0 g
s
.373 0 .052 r
.49861 .49086 m .41379 .50341 L .41237 .50583 L p F P
0 g
s
.575 .939 .909 r
.16108 .50326 m .16748 .5025 L .17177 .50032 L p F P
0 g
s
.575 .939 .909 r
.16748 .5025 m .16108 .50326 L .15795 .5053 L p F P
0 g
s
.303 0 0 r
.18266 .518 m .1778 .5165 L .17057 .51618 L p F P
0 g
s
.372 0 0 r
.16654 .51482 m .17057 .51618 L .1778 .5165 L p F P
0 g
s
.575 .939 .909 r
.15145 .50775 m .1552 .5073 L .15795 .5053 L p F P
0 g
s
.575 .939 .909 r
.16441 .50118 m .17177 .50032 L .17606 .49814 L p F P
0 g
s
.575 .939 .909 r
.17177 .50032 m .16441 .50118 L .16108 .50326 L p F P
0 g
s
.599 .509 .724 r
.66022 .32548 m .65718 .31628 L .57887 .35408 L p F P
0 g
s
.599 .509 .724 r
.57887 .35408 m .58143 .36246 L .66022 .32548 L p F P
0 g
s
.603 .523 .736 r
.57631 .34634 m .57887 .35408 L .65718 .31628 L p F P
0 g
s
.294 0 0 r
.16654 .51482 m .16254 .51322 L .15738 .51263 L p F P
0 g
s
.404 0 0 r
.15489 .5112 m .15738 .51263 L .16254 .51322 L p F P
0 g
s
.603 .523 .736 r
.65718 .31628 m .65416 .30777 L .57631 .34634 L p F P
0 g
s
.607 .535 .747 r
.57376 .3391 m .57631 .34634 L .65416 .30777 L p F P
0 g
s
.594 .493 .709 r
.6633 .33566 m .66022 .32548 L .58143 .36246 L p F P
0 g
s
.594 .493 .709 r
.58143 .36246 m .58402 .37173 L .6633 .33566 L p F P
0 g
s
.235 0 0 r
.18745 .51932 m .18266 .518 L .17463 .51733 L p F P
0 g
s
.303 0 0 r
.17057 .51618 m .17463 .51733 L .18266 .518 L p F P
0 g
s
.373 0 .052 r
.41237 .50583 m .49661 .49346 L .49861 .49086 L p F P
0 g
s
.326 0 0 r
.49661 .49346 m .41237 .50583 L .41096 .50791 L p F P
0 g
s
.607 .535 .747 r
.65416 .30777 m .65116 .2998 L .57376 .3391 L p F P
0 g
s
.61 .545 .757 r
.57123 .33226 m .57376 .3391 L .65116 .2998 L p F P
0 g
s
.575 .939 .909 r
.16787 .49909 m .17606 .49814 L .18036 .49595 L p F P
0 g
s
.575 .939 .909 r
.17606 .49814 m .16787 .49909 L .16441 .50118 L p F P
0 g
s
.587 .472 .69 r
.66645 .34732 m .6633 .33566 L .58402 .37173 L p F P
0 g
s
.587 .472 .69 r
.58402 .37173 m .58664 .38238 L .66645 .34732 L p F P
0 g
s
.298 0 0 r
.15738 .51263 m .15489 .5112 L .15122 .51069 L p F P
0 g
s
.61 .545 .757 r
.65116 .2998 m .64817 .29227 L .57123 .33226 L p F P
0 g
s
.575 .939 .909 r
.55408 .33258 m .57123 .33226 L .64817 .29227 L p F P
0 g
s
.575 .939 .909 r
.57123 .33226 m .55408 .33258 L .47492 .37207 L p F P
0 g
s
.576 .444 .664 r
.66972 .3618 m .66645 .34732 L .58664 .38238 L p F P
0 g
s
.576 .444 .664 r
.58664 .38238 m .58933 .39566 L .66972 .3618 L p F P
0 g
s
.575 .939 .909 r
.17144 .49698 m .18036 .49595 L .18466 .49376 L p F P
0 g
s
.575 .939 .909 r
.18036 .49595 m .17144 .49698 L .16787 .49909 L p F P
0 g
s
.575 .939 .909 r
.15266 .50593 m .15795 .5053 L .16108 .50326 L p F P
0 g
s
.575 .939 .909 r
.15795 .5053 m .15266 .50593 L .15145 .50775 L p F P
0 g
s
.17 0 0 r
.19219 .5205 m .18745 .51932 L .17872 .51831 L p F P
0 g
s
.235 0 0 r
.17463 .51733 m .17872 .51831 L .18745 .51932 L p F P
0 g
s
.194 0 0 r
.17057 .51618 m .16654 .51482 L .16027 .51372 L p F P
0 g
s
.294 0 0 r
.15738 .51263 m .16027 .51372 L .16654 .51482 L p F P
0 g
s
.326 0 0 r
.41096 .50791 m .4946 .49563 L .49661 .49346 L p F P
0 g
s
.276 0 0 r
.4946 .49563 m .41096 .50791 L .40954 .50972 L p F P
0 g
s
.575 .939 .909 r
.45672 .37293 m .47492 .37207 L .55408 .33258 L p F P
0 g
s
.575 .939 .909 r
.47492 .37207 m .45672 .37293 L .3767 .41209 L p F P
0 g
s
.575 .939 .909 r
.14769 .5082 m .15145 .50775 L .15266 .50593 L p F P
0 g
s
.525 .271 .473 r
.5065 .47112 m .59052 .44833 L .59238 .42457 L p F P
0 g
s
.453 .126 .32 r
.59052 .44833 m .5065 .47112 L .50455 .47857 L p F P
0 g
s
.575 .939 .909 r
.17508 .49486 m .18466 .49376 L .18898 .49157 L p F P
0 g
s
.575 .939 .909 r
.18466 .49376 m .17508 .49486 L .17144 .49698 L p F P
0 g
s
.548 .377 .601 r
.67371 .39297 m .66972 .3618 L .58933 .39566 L p F P
0 g
s
.548 .377 .601 r
.58933 .39566 m .59238 .42457 L .67371 .39297 L p F P
0 g
s
.298 0 0 r
.15122 .51069 m .15223 .51137 L .15738 .51263 L p F P
0 g
s
0 .381 .695 r
.15223 .51137 m .15122 .51069 L .14756 .50982 L p F P
0 g
s
0 .481 .706 r
.1969 .52154 m .19219 .5205 L .18283 .51912 L p F P
0 g
s
.17 0 0 r
.17872 .51831 m .18283 .51912 L .19219 .5205 L p F P
0 g
s
.575 .939 .909 r
.18898 .49157 m .17878 .49272 L .17508 .49486 L p F P
0 g
s
.575 .939 .909 r
.27958 .45216 m .26353 .45366 L .18898 .49157 L p F P
0 g
s
.575 .939 .909 r
.17878 .49272 m .18898 .49157 L .26353 .45366 L p F P
0 g
s
.575 .939 .909 r
.15463 .50402 m .16108 .50326 L .16441 .50118 L p F P
0 g
s
.575 .939 .909 r
.16108 .50326 m .15463 .50402 L .15266 .50593 L p F P
0 g
s
.283 0 0 r
.30739 .52576 m .39172 .52046 L .40954 .50972 L p F P
0 g
s
.164 .702 .808 r
.39172 .52046 m .30739 .52576 L .29166 .52846 L p F P
0 g
s
0 .433 .725 r
.16027 .51372 m .15738 .51263 L .15223 .51137 L p F P
0 g
s
.276 0 0 r
.40954 .50972 m .49259 .49745 L .4946 .49563 L p F P
0 g
s
0 0 0 r
.49259 .49745 m .40954 .50972 L .39172 .52046 L p F P
0 g
s
0 .476 .742 r
.17463 .51733 m .17057 .51618 L .16338 .51454 L p F P
0 g
s
.194 0 0 r
.16027 .51372 m .16338 .51454 L .17057 .51618 L p F P
0 g
s
0 .481 .706 r
.18283 .51912 m .18696 .51981 L .1969 .52154 L p F P
0 g
s
.078 .627 .831 r
.1969 .52154 m .27588 .52537 L .29166 .52846 L p F P
0 g
s
.291 .721 .969 r
.27588 .52537 m .1969 .52154 L .18696 .51981 L p F P
0 g
s
.575 .939 .909 r
.15266 .50593 m .14735 .50656 L .14769 .5082 L p F P
0 g
s
.575 .939 .909 r
.14391 .50865 m .14769 .5082 L .14735 .50656 L p F P
0 g
s
.575 .939 .909 r
.15699 .50205 m .16441 .50118 L .16787 .49909 L p F P
0 g
s
.575 .939 .909 r
.16441 .50118 m .15699 .50205 L .15463 .50402 L p F P
0 g
s
.575 .939 .909 r
.35863 .41339 m .3767 .41209 L .45672 .37293 L p F P
0 g
s
.575 .939 .909 r
.3767 .41209 m .35863 .41339 L .27958 .45216 L p F P
0 g
s
.575 .939 .909 r
.14735 .50656 m .15266 .50593 L .15463 .50402 L p F P
0 g
s
0 .381 .695 r
.14756 .50982 m .14711 .50954 L .15223 .51137 L p F P
0 g
s
0 .43 .773 r
.14711 .50954 m .14756 .50982 L .14391 .50865 L p F P
0 g
s
0 .534 .805 r
.17872 .51831 m .17463 .51733 L .16665 .51517 L p F P
0 g
s
0 .476 .742 r
.16338 .51454 m .16665 .51517 L .17463 .51733 L p F P
0 g
s
.453 .126 .32 r
.50455 .47857 m .58829 .45645 L .59052 .44833 L p F P
0 g
s
.394 .02 .205 r
.58829 .45645 m .50455 .47857 L .50258 .48374 L p F P
0 g
s
0 .519 .818 r
.16338 .51454 m .16027 .51372 L .15402 .51173 L p F P
0 g
s
0 .433 .725 r
.15223 .51137 m .15402 .51173 L .16027 .51372 L p F P
0 g
s
.575 .939 .909 r
.15961 .50005 m .16787 .49909 L .17144 .49698 L p F P
0 g
s
.575 .939 .909 r
.16787 .49909 m .15961 .50005 L .15699 .50205 L p F P
0 g
s
.575 .939 .909 r
.26353 .45366 m .27958 .45216 L .35863 .41339 L p F P
0 g
s
0 .513 .835 r
.15402 .51173 m .15223 .51137 L .14711 .50954 L p F P
0 g
s
.044 .58 .853 r
.18283 .51912 m .17872 .51831 L .17003 .51563 L p F P
0 g
s
0 .534 .805 r
.16665 .51517 m .17003 .51563 L .17872 .51831 L p F P
0 g
s
.575 .939 .909 r
.14735 .50656 m .14199 .5072 L .14391 .50865 L p F P
0 g
s
0 .43 .773 r
.14391 .50865 m .14199 .5072 L .14711 .50954 L p F P
0 g
s
.575 .939 .909 r
.16242 .49801 m .17144 .49698 L .17508 .49486 L p F P
0 g
s
.575 .939 .909 r
.17144 .49698 m .16242 .49801 L .15961 .50005 L p F P
0 g
s
.575 .939 .909 r
.14812 .50478 m .15463 .50402 L .15699 .50205 L p F P
0 g
s
.575 .939 .909 r
.15463 .50402 m .14812 .50478 L .14735 .50656 L p F P
0 g
s
.062 .577 .879 r
.16665 .51517 m .16338 .51454 L .15622 .51185 L p F P
0 g
s
0 .519 .818 r
.15402 .51173 m .15622 .51185 L .16338 .51454 L p F P
0 g
s
.472 .222 .453 r
.67371 .39297 m .59238 .42457 L .59052 .44833 L p F P
0 g
s
.575 .939 .909 r
.14199 .5072 m .14735 .50656 L .14812 .50478 L p F P
0 g
s
.394 .02 .205 r
.50258 .48374 m .58597 .46192 L .58829 .45645 L p F P
0 g
s
.329 0 .088 r
.58597 .46192 m .50258 .48374 L .5006 .48769 L p F P
0 g
s
.575 .939 .909 r
.16538 .49596 m .17508 .49486 L .17878 .49272 L p F P
0 g
s
.575 .939 .909 r
.17508 .49486 m .16538 .49596 L .16242 .49801 L p F P
0 g
s
.103 .617 .89 r
.18696 .51981 m .18283 .51912 L .17351 .51595 L p F P
0 g
s
.044 .58 .853 r
.17003 .51563 m .17351 .51595 L .18283 .51912 L p F P
0 g
s
0 .513 .835 r
.14711 .50954 m .14779 .50898 L .15402 .51173 L p F P
0 g
s
.075 .557 .898 r
.14779 .50898 m .14711 .50954 L .14199 .5072 L p F P
0 g
s
.097 .583 .905 r
.15622 .51185 m .15402 .51173 L .14779 .50898 L p F P
0 g
s
.575 .939 .909 r
.1495 .50293 m .15699 .50205 L .15961 .50005 L p F P
0 g
s
.575 .939 .909 r
.15699 .50205 m .1495 .50293 L .14812 .50478 L p F P
0 g
s
.575 .939 .909 r
.17878 .49272 m .16845 .49388 L .16538 .49596 L p F P
0 g
s
.575 .939 .909 r
.26353 .45366 m .24714 .45519 L .17878 .49272 L p F P
0 g
s
.575 .939 .909 r
.16845 .49388 m .17878 .49272 L .24714 .45519 L p F P
0 g
s
.136 .618 .918 r
.17003 .51563 m .16665 .51517 L .15869 .5118 L p F P
0 g
s
.062 .577 .879 r
.15622 .51185 m .15869 .5118 L .16665 .51517 L p F P
0 g
s
.103 .617 .89 r
.17351 .51595 m .17706 .51614 L .18696 .51981 L p F P
0 g
s
.291 .721 .969 r
.18696 .51981 m .26002 .51834 L .27588 .52537 L p F P
0 g
s
.398 .726 .99 r
.26002 .51834 m .18696 .51981 L .17706 .51614 L p F P
0 g
s
.329 0 .088 r
.5006 .48769 m .58361 .46599 L .58597 .46192 L p F P
0 g
s
.258 0 0 r
.58361 .46599 m .5006 .48769 L .49861 .49086 L p F P
0 g
s
.575 .939 .909 r
.15126 .50101 m .15961 .50005 L .16242 .49801 L p F P
0 g
s
.575 .939 .909 r
.15961 .50005 m .15126 .50101 L .1495 .50293 L p F P
0 g
s
.575 .939 .909 r
.14157 .50556 m .14812 .50478 L .1495 .50293 L p F P
0 g
s
.575 .939 .909 r
.14812 .50478 m .14157 .50556 L .14199 .5072 L p F P
0 g
s
.182 .625 .942 r
.15869 .5118 m .15622 .51185 L .14907 .50824 L p F P
0 g
s
.097 .583 .905 r
.14779 .50898 m .14907 .50824 L .15622 .51185 L p F P
0 g
s
.075 .557 .898 r
.14199 .5072 m .14157 .50556 L .14779 .50898 L p F P
0 g
s
.196 .648 .944 r
.17351 .51595 m .17003 .51563 L .16137 .51161 L p F P
0 g
s
.136 .618 .918 r
.15869 .5118 m .16137 .51161 L .17003 .51563 L p F P
0 g
s
.189 .613 .945 r
.14907 .50824 m .14779 .50898 L .14157 .50556 L p F P
0 g
s
.575 .939 .909 r
.1533 .49906 m .16242 .49801 L .16538 .49596 L p F P
0 g
s
.575 .939 .909 r
.16242 .49801 m .1533 .49906 L .15126 .50101 L p F P
0 g
s
.258 0 0 r
.49861 .49086 m .58122 .46914 L .58361 .46599 L p F P
0 g
s
.18 0 0 r
.58122 .46914 m .49861 .49086 L .49661 .49346 L p F P
0 g
s
.244 .669 .961 r
.17706 .51614 m .17351 .51595 L .1642 .5113 L p F P
0 g
s
.196 .648 .944 r
.16137 .51161 m .1642 .5113 L .17351 .51595 L p F P
0 g
s
.575 .939 .909 r
.14194 .50381 m .1495 .50293 L .15126 .50101 L p F P
0 g
s
.575 .939 .909 r
.1495 .50293 m .14194 .50381 L .14157 .50556 L p F P
0 g
s
.245 .651 .962 r
.16137 .51161 m .15869 .5118 L .15075 .50737 L p F P
0 g
s
.182 .625 .942 r
.14907 .50824 m .15075 .50737 L .15869 .5118 L p F P
0 g
s
.164 .702 .808 r
.29166 .52846 m .37368 .52011 L .39172 .52046 L p F P
0 g
s
.41 .809 .984 r
.37368 .52011 m .29166 .52846 L .27588 .52537 L p F P
0 g
s
.575 .939 .909 r
.15556 .49707 m .16538 .49596 L .16845 .49388 L p F P
0 g
s
.575 .939 .909 r
.16538 .49596 m .15556 .49707 L .1533 .49906 L p F P
0 g
s
.575 .939 .909 r
.64817 .29227 m .6325 .29204 L .55408 .33258 L p F P
0 g
s
.575 .939 .909 r
.53645 .33291 m .55408 .33258 L .6325 .29204 L p F P
0 g
s
.575 .939 .909 r
.55408 .33258 m .53645 .33291 L .45672 .37293 L p F P
0 g
s
.264 .641 .964 r
.15075 .50737 m .14907 .50824 L .14194 .50381 L p F P
0 g
s
.189 .613 .945 r
.14157 .50556 m .14194 .50381 L .14907 .50824 L p F P
0 g
s
.18 0 0 r
.49661 .49346 m .5788 .47163 L .58122 .46914 L p F P
0 g
s
.097 0 0 r
.5788 .47163 m .49661 .49346 L .4946 .49563 L p F P
0 g
s
.244 .669 .961 r
.1642 .5113 m .16716 .5109 L .17706 .51614 L p F P
0 g
s
.398 .726 .99 r
.17706 .51614 m .24406 .5081 L .26002 .51834 L p F P
0 g
s
.452 .706 .976 r
.24406 .5081 m .17706 .51614 L .16716 .5109 L p F P
0 g
s
.567 .487 .725 r
.74025 .29552 m .73685 .28505 L .66022 .32548 L p F P
0 g
s
.567 .487 .725 r
.66022 .32548 m .6633 .33566 L .74025 .29552 L p F P
0 g
s
.573 .505 .741 r
.65718 .31628 m .66022 .32548 L .73685 .28505 L p F P
0 g
s
.472 .222 .453 r
.59052 .44833 m .67209 .41789 L .67371 .39297 L p F P
0 g
s
.363 .026 .254 r
.67209 .41789 m .59052 .44833 L .58829 .45645 L p F P
0 g
s
.573 .505 .741 r
.73685 .28505 m .7335 .27557 L .65718 .31628 L p F P
0 g
s
.578 .521 .754 r
.65416 .30777 m .65718 .31628 L .7335 .27557 L p F P
0 g
s
.558 .464 .704 r
.74375 .30749 m .74025 .29552 L .6633 .33566 L p F P
0 g
s
.558 .464 .704 r
.6633 .33566 m .66645 .34732 L .74375 .30749 L p F P
0 g
s
.578 .521 .754 r
.7335 .27557 m .73019 .26679 L .65416 .30777 L p F P
0 g
s
.583 .534 .766 r
.65116 .2998 m .65416 .30777 L .73019 .26679 L p F P
0 g
s
.294 .668 .973 r
.1642 .5113 m .16137 .51161 L .15271 .50641 L p F P
0 g
s
.245 .651 .962 r
.15075 .50737 m .15271 .50641 L .16137 .51161 L p F P
0 g
s
.575 .939 .909 r
.16845 .49388 m .158 .49506 L .15556 .49707 L p F P
0 g
s
.575 .939 .909 r
.24714 .45519 m .23039 .45676 L .16845 .49388 L p F P
0 g
s
.575 .939 .909 r
.158 .49506 m .16845 .49388 L .23039 .45676 L p F P
0 g
s
.575 .939 .909 r
.43801 .37381 m .45672 .37293 L .53645 .33291 L p F P
0 g
s
.575 .939 .909 r
.45672 .37293 m .43801 .37381 L .35863 .41339 L p F P
0 g
s
.544 .432 .676 r
.74742 .32229 m .74375 .30749 L .66645 .34732 L p F P
0 g
s
.544 .432 .676 r
.66645 .34732 m .66972 .3618 L .74742 .32229 L p F P
0 g
s
.575 .939 .909 r
.14282 .50199 m .15126 .50101 L .1533 .49906 L p F P
0 g
s
.575 .939 .909 r
.15126 .50101 m .14282 .50199 L .14194 .50381 L p F P
0 g
s
.583 .534 .766 r
.73019 .26679 m .72691 .25857 L .65116 .2998 L p F P
0 g
s
.586 .546 .776 r
.64817 .29227 m .65116 .2998 L .72691 .25857 L p F P
0 g
s
.575 .939 .909 r
.35863 .41339 m .34011 .41472 L .26353 .45366 L p F P
0 g
s
.575 .939 .909 r
.24714 .45519 m .26353 .45366 L .34011 .41472 L p F P
0 g
s
.586 .546 .776 r
.72691 .25857 m .72366 .25081 L .64817 .29227 L p F P
0 g
s
.575 .939 .909 r
.6325 .29204 m .64817 .29227 L .72366 .25081 L p F P
0 g
s
.097 0 0 r
.4946 .49563 m .57636 .4736 L .5788 .47163 L p F P
0 g
s
.012 0 0 r
.57636 .4736 m .4946 .49563 L .49259 .49745 L p F P
0 g
s
.508 .353 .605 r
.75213 .35377 m .74742 .32229 L .66972 .3618 L p F P
0 g
s
.508 .353 .605 r
.66972 .3618 m .67371 .39297 L .75213 .35377 L p F P
0 g
s
.575 .939 .909 r
.34011 .41472 m .35863 .41339 L .43801 .37381 L p F P
0 g
s
.318 .657 .972 r
.15271 .50641 m .15075 .50737 L .14282 .50199 L p F P
0 g
s
.264 .641 .964 r
.14194 .50381 m .14282 .50199 L .15075 .50737 L p F P
0 g
s
.333 .68 .978 r
.16716 .5109 m .1642 .5113 L .1549 .50536 L p F P
0 g
s
.294 .668 .973 r
.15271 .50641 m .1549 .50536 L .1642 .5113 L p F P
0 g
s
0 0 0 r
.39172 .52046 m .47431 .50415 L .49259 .49745 L p F P
0 g
s
.409 .844 .944 r
.47431 .50415 m .39172 .52046 L .37368 .52011 L p F P
0 g
s
.575 .939 .909 r
.14408 .50012 m .1533 .49906 L .15556 .49707 L p F P
0 g
s
.575 .939 .909 r
.1533 .49906 m .14408 .50012 L .14282 .50199 L p F P
0 g
s
.012 0 0 r
.49259 .49745 m .5739 .47516 L .57636 .4736 L p F P
0 g
s
.299 .792 .776 r
.5739 .47516 m .49259 .49745 L .47431 .50415 L p F P
0 g
s
.363 .026 .254 r
.58829 .45645 m .66973 .42609 L .67209 .41789 L p F P
0 g
s
.268 0 .095 r
.66973 .42609 m .58829 .45645 L .58597 .46192 L p F P
0 g
s
.333 .68 .978 r
.1549 .50536 m .15728 .50424 L .16716 .5109 L p F P
0 g
s
.452 .706 .976 r
.16716 .5109 m .22802 .49495 L .24406 .5081 L p F P
0 g
s
.48 .677 .952 r
.22802 .49495 m .16716 .5109 L .15728 .50424 L p F P
0 g
s
.358 .667 .974 r
.1549 .50536 m .15271 .50641 L .14408 .50012 L p F P
0 g
s
.318 .657 .972 r
.14282 .50199 m .14408 .50012 L .15271 .50641 L p F P
0 g
s
.575 .939 .909 r
.14562 .4982 m .15556 .49707 L .158 .49506 L p F P
0 g
s
.575 .939 .909 r
.15556 .49707 m .14562 .4982 L .14408 .50012 L p F P
0 g
s
.389 .673 .972 r
.15728 .50424 m .1549 .50536 L .14562 .4982 L p F P
0 g
s
.358 .667 .974 r
.14408 .50012 m .14562 .4982 L .1549 .50536 L p F P
0 g
s
.575 .939 .909 r
.158 .49506 m .1474 .49626 L .14562 .4982 L p F P
0 g
s
.575 .939 .909 r
.23039 .45676 m .21329 .45836 L .158 .49506 L p F P
0 g
s
.575 .939 .909 r
.1474 .49626 m .158 .49506 L .21329 .45836 L p F P
0 g
s
.401 .157 .426 r
.75213 .35377 m .67371 .39297 L .67209 .41789 L p F P
0 g
s
.268 0 .095 r
.58597 .46192 m .66723 .43143 L .66973 .42609 L p F P
0 g
s
.163 0 0 r
.66723 .43143 m .58597 .46192 L .58361 .46599 L p F P
0 g
s
.41 .809 .984 r
.27588 .52537 m .3554 .5137 L .37368 .52011 L p F P
0 g
s
.509 .796 .997 r
.3554 .5137 m .27588 .52537 L .26002 .51834 L p F P
0 g
s
.389 .673 .972 r
.14562 .4982 m .1474 .49626 L .15728 .50424 L p F P
0 g
s
.48 .677 .952 r
.15728 .50424 m .21193 .47896 L .22802 .49495 L p F P
0 g
s
.493 .644 .924 r
.21193 .47896 m .15728 .50424 L .1474 .49626 L p F P
0 g
s
.163 0 0 r
.58361 .46599 m .66465 .43526 L .66723 .43143 L p F P
0 g
s
.05 0 0 r
.66465 .43526 m .58361 .46599 L .58122 .46914 L p F P
0 g
s
.575 .939 .909 r
.34011 .41472 m .3211 .41609 L .24714 .45519 L p F P
0 g
s
.575 .939 .909 r
.23039 .45676 m .24714 .45519 L .3211 .41609 L p F P
0 g
s
.05 0 0 r
.58122 .46914 m .66201 .43809 L .66465 .43526 L p F P
0 g
s
0 0 0 r
.66201 .43809 m .58122 .46914 L .5788 .47163 L p F P
0 g
s
.575 .939 .909 r
.21329 .45836 m .1958 .46 L .1474 .49626 L p F P
0 g
s
.493 .644 .924 r
.1474 .49626 m .1958 .46 L .21193 .47896 L p F P
0 g
s
.575 .939 .909 r
.6325 .29204 m .61639 .2918 L .53645 .33291 L p F P
0 g
s
.575 .939 .909 r
.51831 .33325 m .53645 .33291 L .61639 .2918 L p F P
0 g
s
.575 .939 .909 r
.53645 .33291 m .51831 .33325 L .43801 .37381 L p F P
0 g
s
.575 .939 .909 r
.41878 .37471 m .43801 .37381 L .51831 .33325 L p F P
0 g
s
.575 .939 .909 r
.43801 .37381 m .41878 .37471 L .34011 .41472 L p F P
0 g
s
.575 .939 .909 r
.3211 .41609 m .34011 .41472 L .41878 .37471 L p F P
0 g
s
.575 .939 .909 r
.72366 .25081 m .71034 .25009 L .6325 .29204 L p F P
0 g
s
.575 .939 .909 r
.61639 .2918 m .6325 .29204 L .71034 .25009 L p F P
0 g
s
.409 .844 .944 r
.37368 .52011 m .45557 .50108 L .47431 .50415 L p F P
0 g
s
.545 .846 .998 r
.45557 .50108 m .37368 .52011 L .3554 .5137 L p F P
0 g
s
0 0 0 r
.5788 .47163 m .65933 .4402 L .66201 .43809 L p F P
0 g
s
0 0 0 r
.65933 .4402 m .5788 .47163 L .57636 .4736 L p F P
0 g
s
.401 .157 .426 r
.67209 .41789 m .75085 .3781 L .75213 .35377 L p F P
0 g
s
.232 0 .162 r
.75085 .3781 m .67209 .41789 L .66973 .42609 L p F P
0 g
s
.509 .796 .997 r
.26002 .51834 m .33688 .50276 L .3554 .5137 L p F P
0 g
s
.552 .762 .975 r
.33688 .50276 m .26002 .51834 L .24406 .5081 L p F P
0 g
s
0 0 0 r
.57636 .4736 m .65661 .44173 L .65933 .4402 L p F P
0 g
s
.275 .76 .668 r
.65661 .44173 m .57636 .4736 L .5739 .47516 L p F P
0 g
s
.299 .792 .776 r
.47431 .50415 m .5562 .47827 L .5739 .47516 L p F P
0 g
s
.548 .892 .982 r
.5562 .47827 m .47431 .50415 L .45557 .50108 L p F P
0 g
s
.511 .445 .719 r
.81702 .26033 m .81345 .24912 L .74025 .29552 L p F P
0 g
s
.511 .445 .719 r
.74025 .29552 m .74375 .30749 L .81702 .26033 L p F P
0 g
s
.522 .472 .742 r
.73685 .28505 m .74025 .29552 L .81345 .24912 L p F P
0 g
s
.522 .472 .742 r
.81345 .24912 m .81 .2393 L .73685 .28505 L p F P
0 g
s
.53 .493 .759 r
.7335 .27557 m .73685 .28505 L .81 .2393 L p F P
0 g
s
.493 .407 .687 r
.82079 .27413 m .81702 .26033 L .74375 .30749 L p F P
0 g
s
.493 .407 .687 r
.74375 .30749 m .74742 .32229 L .82079 .27413 L p F P
0 g
s
.53 .493 .759 r
.81 .2393 m .80662 .23039 L .7335 .27557 L p F P
0 g
s
.537 .51 .774 r
.73019 .26679 m .7335 .27557 L .80662 .23039 L p F P
0 g
s
.537 .51 .774 r
.80662 .23039 m .80328 .22214 L .73019 .26679 L p F P
0 g
s
.541 .525 .787 r
.72691 .25857 m .73019 .26679 L .80328 .22214 L p F P
0 g
s
.232 0 .162 r
.66973 .42609 m .74851 .3857 L .75085 .3781 L p F P
0 g
s
.082 0 0 r
.74851 .3857 m .66973 .42609 L .66723 .43143 L p F P
0 g
s
.443 .312 .607 r
.82578 .30296 m .82079 .27413 L .74742 .32229 L p F P
0 g
s
.443 .312 .607 r
.74742 .32229 m .75213 .35377 L .82578 .30296 L p F P
0 g
s
.541 .525 .787 r
.80328 .22214 m .79998 .21443 L .72691 .25857 L p F P
0 g
s
.545 .538 .798 r
.72366 .25081 m .72691 .25857 L .79998 .21443 L p F P
0 g
s
.275 .76 .668 r
.5739 .47516 m .65386 .44279 L .65661 .44173 L p F P
0 g
s
.505 .909 .901 r
.65386 .44279 m .5739 .47516 L .5562 .47827 L p F P
0 g
s
.545 .538 .798 r
.79998 .21443 m .79671 .20714 L .72366 .25081 L p F P
0 g
s
.575 .939 .909 r
.71034 .25009 m .72366 .25081 L .79671 .20714 L p F P
0 g
s
.575 .939 .909 r
.3211 .41609 m .30159 .41749 L .23039 .45676 L p F P
0 g
s
.575 .939 .909 r
.21329 .45836 m .23039 .45676 L .30159 .41749 L p F P
0 g
s
.082 0 0 r
.66723 .43143 m .74597 .39044 L .74851 .3857 L p F P
0 g
s
0 0 0 r
.74597 .39044 m .66723 .43143 L .66465 .43526 L p F P
0 g
s
.552 .762 .975 r
.24406 .5081 m .31814 .48793 L .33688 .50276 L p F P
0 g
s
.572 .726 .946 r
.31814 .48793 m .24406 .5081 L .22802 .49495 L p F P
0 g
s
.277 .049 .378 r
.82578 .30296 m .75213 .35377 L .75085 .3781 L p F P
0 g
s
.545 .846 .998 r
.3554 .5137 m .43642 .49196 L .45557 .50108 L p F P
0 g
s
.593 .806 .981 r
.43642 .49196 m .3554 .5137 L .33688 .50276 L p F P
0 g
s
0 0 0 r
.66465 .43526 m .74331 .39363 L .74597 .39044 L p F P
0 g
s
0 0 0 r
.74331 .39363 m .66465 .43526 L .66201 .43809 L p F P
0 g
s
.575 .939 .909 r
.41878 .37471 m .39901 .37565 L .3211 .41609 L p F P
0 g
s
.575 .939 .909 r
.30159 .41749 m .3211 .41609 L .39901 .37565 L p F P
0 g
s
.575 .939 .909 r
.61639 .2918 m .59983 .29156 L .51831 .33325 L p F P
0 g
s
.575 .939 .909 r
.49965 .33359 m .51831 .33325 L .59983 .29156 L p F P
0 g
s
.575 .939 .909 r
.51831 .33325 m .49965 .33359 L .41878 .37471 L p F P
0 g
s
.575 .939 .909 r
.39901 .37565 m .41878 .37471 L .49965 .33359 L p F P
0 g
s
.575 .939 .909 r
.71034 .25009 m .69669 .24935 L .61639 .2918 L p F P
0 g
s
.575 .939 .909 r
.59983 .29156 m .61639 .2918 L .69669 .24935 L p F P
0 g
s
0 0 0 r
.72428 .40458 m .74058 .39581 L .74125 .39528 L p F P
0 g
s
.357 .799 .643 r
.74058 .39581 m .66201 .43809 L .65933 .4402 L p F P
0 g
s
.357 .799 .643 r
.65933 .4402 m .71201 .41134 L p .74058 .39581 L F P
0 g
s
.357 .799 .643 r
.71201 .41134 m .73778 .39723 L .73951 .39635 L p F P
0 g
s
.357 .799 .643 r
.73951 .39635 m .74058 .39581 L p .71201 .41134 L F P
0 g
s
0 0 0 r
.66201 .43809 m .72428 .40458 L p .74331 .39363 L F P
0 g
s
.534 .924 .847 r
.73494 .39806 m .67097 .43372 L p .65386 .44279 L F P
0 g
s
.459 .879 .764 r
.66167 .43892 m .65933 .4402 L .65921 .44026 L p F P
0 g
s
.459 .879 .764 r
.65921 .44026 m .65661 .44173 L p .66167 .43892 L F P
0 g
s
.534 .924 .847 r
.67097 .43372 m .65661 .44173 L .65549 .44216 L p F P
0 g
s
.534 .924 .847 r
.65549 .44216 m .65386 .44279 L p .67097 .43372 L F P
0 g
s
.459 .879 .764 r
.73778 .39723 m .66167 .43892 L p .65661 .44173 L F P
0 g
s
0 0 0 r
.74125 .39528 m .74331 .39363 L p .72428 .40458 L F P
0 g
s
.548 .892 .982 r
.45557 .50108 m .53788 .47281 L .5562 .47827 L p F P
0 g
s
.619 .853 .987 r
.53788 .47281 m .45557 .50108 L .43642 .49196 L p F P
0 g
s
.572 .726 .946 r
.22802 .49495 m .29922 .46938 L .31814 .48793 L p F P
0 g
s
.581 .69 .916 r
.29922 .46938 m .22802 .49495 L .21193 .47896 L p F P
0 g
s
.575 .939 .909 r
.79671 .20714 m .78692 .20615 L .71034 .25009 L p F P
0 g
s
.575 .939 .909 r
.69669 .24935 m .71034 .25009 L .78692 .20615 L p F P
0 g
s
.277 .049 .378 r
.75085 .3781 m .8248 .32409 L .82578 .30296 L p F P
0 g
s
0 0 0 r
.8248 .32409 m .75085 .3781 L .74851 .3857 L p F P
0 g
s
.575 .939 .909 r
.30159 .41749 m .28156 .41893 L .21329 .45836 L p F P
0 g
s
.575 .939 .909 r
.1958 .46 m .21329 .45836 L .28156 .41893 L p F P
0 g
s
.505 .909 .901 r
.5562 .47827 m .6376 .4426 L .65386 .44279 L p F P
0 g
s
.637 .904 .984 r
.6376 .4426 m .5562 .47827 L .53788 .47281 L p F P
0 g
s
.459 .879 .764 r
.65661 .44173 m .73494 .39806 L .73778 .39723 L p F P
0 g
s
.593 .806 .981 r
.33688 .50276 m .41692 .47808 L .43642 .49196 L p F P
0 g
s
.612 .764 .952 r
.41692 .47808 m .33688 .50276 L .31814 .48793 L p F P
0 g
s
.534 .924 .847 r
.65386 .44279 m .73204 .3984 L .73494 .39806 L p F P
0 g
s
.652 .952 .948 r
.73204 .3984 m .65386 .44279 L .6376 .4426 L p F P
0 g
s
0 0 0 r
.74851 .3857 m .82258 .33014 L .8248 .32409 L p F P
0 g
s
0 0 0 r
.82258 .33014 m .74851 .3857 L .74597 .39044 L p F P
0 g
s
.581 .69 .916 r
.21193 .47896 m .28014 .44702 L .29922 .46938 L p F P
0 g
s
.584 .653 .885 r
.28014 .44702 m .21193 .47896 L .1958 .46 L p F P
0 g
s
.575 .939 .909 r
.39901 .37565 m .37866 .37661 L .30159 .41749 L p F P
0 g
s
.575 .939 .909 r
.28156 .41893 m .30159 .41749 L .37866 .37661 L p F P
0 g
s
0 0 0 r
.74597 .39044 m .82013 .33357 L .82258 .33014 L p F P
0 g
s
.438 .812 .56 r
.82013 .33357 m .74597 .39044 L .74331 .39363 L p F P
0 g
s
.575 .939 .909 r
.59983 .29156 m .58281 .29131 L .49965 .33359 L p F P
0 g
s
.575 .939 .909 r
.48045 .33395 m .49965 .33359 L .58281 .29131 L p F P
0 g
s
.575 .939 .909 r
.49965 .33359 m .48045 .33395 L .39901 .37565 L p F P
0 g
s
.575 .939 .909 r
.69669 .24935 m .68269 .24859 L .59983 .29156 L p F P
0 g
s
.575 .939 .909 r
.58281 .29131 m .59983 .29156 L .68269 .24859 L p F P
0 g
s
.342 .355 .728 r
.87427 .1922 m .87121 .1848 L .81345 .24912 L p F P
0 g
s
.342 .355 .728 r
.81345 .24912 m .81702 .26033 L .87427 .1922 L p F P
0 g
s
.359 .389 .756 r
.81 .2393 m .81345 .24912 L .87121 .1848 L p F P
0 g
s
.313 .304 .689 r
.87748 .20127 m .87427 .1922 L .81702 .26033 L p F P
0 g
s
.313 .304 .689 r
.81702 .26033 m .82079 .27413 L .87748 .20127 L p F P
0 g
s
.619 .853 .987 r
.43642 .49196 m .51907 .46158 L .53788 .47281 L p F P
0 g
s
.642 .805 .962 r
.51907 .46158 m .43642 .49196 L .41692 .47808 L p F P
0 g
s
.575 .939 .909 r
.37866 .37661 m .39901 .37565 L .48045 .33395 L p F P
0 g
s
.359 .389 .756 r
.87121 .1848 m .86824 .17838 L .81 .2393 L p F P
0 g
s
.369 .414 .777 r
.80662 .23039 m .81 .2393 L .86824 .17838 L p F P
0 g
s
.218 .165 .581 r
.88156 .2193 m .87748 .20127 L .82079 .27413 L p F P
0 g
s
.218 .165 .581 r
.82079 .27413 m .82578 .30296 L .88156 .2193 L p F P
0 g
s
.369 .414 .777 r
.86824 .17838 m .86533 .17264 L .80662 .23039 L p F P
0 g
s
.375 .434 .794 r
.80328 .22214 m .80662 .23039 L .86533 .17264 L p F P
0 g
s
.375 .434 .794 r
.86533 .17264 m .86246 .16747 L .80328 .22214 L p F P
0 g
s
.377 .449 .809 r
.79998 .21443 m .80328 .22214 L .86246 .16747 L p F P
0 g
s
.575 .939 .909 r
.28156 .41893 m .26099 .42041 L .1958 .46 L p F P
0 g
s
.584 .653 .885 r
.1958 .46 m .26099 .42041 L .28014 .44702 L p F P
0 g
s
.612 .764 .952 r
.31814 .48793 m .39708 .45992 L .41692 .47808 L p F P
0 g
s
.62 .726 .922 r
.39708 .45992 m .31814 .48793 L .29922 .46938 L p F P
0 g
s
.377 .449 .809 r
.86246 .16747 m .85964 .16278 L .79998 .21443 L p F P
0 g
s
.377 .463 .821 r
.79671 .20714 m .79998 .21443 L .85964 .16278 L p F P
0 g
s
.438 .812 .56 r
.74331 .39363 m .81755 .33557 L .82013 .33357 L p F P
0 g
s
.572 .922 .731 r
.81755 .33557 m .74331 .39363 L .74058 .39581 L p F P
0 g
s
.575 .939 .909 r
.78692 .20615 m .77693 .20514 L .69669 .24935 L p F P
0 g
s
.575 .939 .909 r
.68269 .24859 m .69669 .24935 L .77693 .20514 L p F P
0 g
s
.377 .463 .821 r
.85964 .16278 m .85684 .15855 L .79671 .20714 L p F P
0 g
s
.575 .939 .909 r
.78692 .20615 m .79671 .20714 L .85684 .15855 L p F P
0 g
s
.637 .904 .984 r
.53788 .47281 m .62068 .43514 L .6376 .4426 L p F P
0 g
s
.67 .851 .969 r
.62068 .43514 m .53788 .47281 L .51907 .46158 L p F P
0 g
s
0 0 .098 r
.88156 .2193 m .82578 .30296 L .8248 .32409 L p F P
0 g
s
.572 .922 .731 r
.74058 .39581 m .81488 .33662 L .81755 .33557 L p F P
0 g
s
.654 .97 .834 r
.81488 .33662 m .74058 .39581 L .73778 .39723 L p F P
0 g
s
.654 .97 .834 r
.73778 .39723 m .81213 .33695 L .81488 .33662 L p F P
0 g
s
.702 .982 .892 r
.81213 .33695 m .73778 .39723 L .73494 .39806 L p F P
0 g
s
.652 .952 .948 r
.6376 .4426 m .71811 .39522 L .73204 .3984 L p F P
0 g
s
.703 .9 .967 r
.71811 .39522 m .6376 .4426 L .62068 .43514 L p F P
0 g
s
.642 .805 .962 r
.41692 .47808 m .4998 .4456 L .51907 .46158 L p F P
0 g
s
.65 .762 .932 r
.4998 .4456 m .41692 .47808 L .39708 .45992 L p F P
0 g
s
.62 .726 .922 r
.29922 .46938 m .37697 .43755 L .39708 .45992 L p F P
0 g
s
.622 .689 .891 r
.37697 .43755 m .29922 .46938 L .28014 .44702 L p F P
0 g
s
.702 .982 .892 r
.73494 .39806 m .80933 .33671 L .81213 .33695 L p F P
0 g
s
.729 .976 .923 r
.80933 .33671 m .73494 .39806 L .73204 .3984 L p F P
0 g
s
.575 .939 .909 r
.37866 .37661 m .35771 .37759 L .28156 .41893 L p F P
0 g
s
.575 .939 .909 r
.26099 .42041 m .28156 .41893 L .35771 .37759 L p F P
0 g
s
0 0 .098 r
.8248 .32409 m .88021 .22964 L .88156 .2193 L p F P
0 g
s
.793 .957 .63 r
.88021 .22964 m .8248 .32409 L .82258 .33014 L p F P
0 g
s
.575 .939 .909 r
.85684 .15855 m .8544 .15816 L .78692 .20615 L p F P
0 g
s
.575 .939 .909 r
.77693 .20514 m .78692 .20615 L .8544 .15816 L p F P
0 g
s
.575 .939 .909 r
.68269 .24859 m .66834 .24782 L .58281 .29131 L p F P
0 g
s
.575 .939 .909 r
.56529 .29105 m .58281 .29131 L .66834 .24782 L p F P
0 g
s
.575 .939 .909 r
.58281 .29131 m .56529 .29105 L .48045 .33395 L p F P
0 g
s
.729 .976 .923 r
.73204 .3984 m .80647 .336 L .80933 .33671 L p F P
0 g
s
.758 .942 .942 r
.80647 .336 m .73204 .3984 L .71811 .39522 L p F P
0 g
s
.575 .939 .909 r
.46066 .33432 m .48045 .33395 L .56529 .29105 L p F P
0 g
s
.575 .939 .909 r
.48045 .33395 m .46066 .33432 L .37866 .37661 L p F P
0 g
s
.575 .939 .909 r
.35771 .37759 m .37866 .37661 L .46066 .33432 L p F P
0 g
s
.575 .939 .909 r
.77693 .20514 m .76675 .20411 L .68269 .24859 L p F P
0 g
s
.575 .939 .909 r
.66834 .24782 m .68269 .24859 L .76675 .20411 L p F P
0 g
s
.67 .851 .969 r
.51907 .46158 m .60322 .42244 L .62068 .43514 L p F P
0 g
s
.678 .802 .941 r
.60322 .42244 m .51907 .46158 L .4998 .4456 L p F P
0 g
s
.793 .957 .63 r
.82258 .33014 m .87797 .23099 L .88021 .22964 L p F P
0 g
s
.868 .994 .811 r
.87797 .23099 m .82258 .33014 L .82013 .33357 L p F P
0 g
s
.622 .689 .891 r
.28014 .44702 m .35663 .41069 L .37697 .43755 L p F P
0 g
s
.62 .65 .859 r
.35663 .41069 m .28014 .44702 L .26099 .42041 L p F P
0 g
s
.65 .762 .932 r
.39708 .45992 m .48014 .42521 L .4998 .4456 L p F P
0 g
s
.651 .723 .902 r
.48014 .42521 m .39708 .45992 L .37697 .43755 L p F P
0 g
s
.703 .9 .967 r
.62068 .43514 m .70356 .38633 L .71811 .39522 L p F P
0 g
s
.711 .844 .945 r
.70356 .38633 m .62068 .43514 L .60322 .42244 L p F P
0 g
s
.868 .994 .811 r
.82013 .33357 m .87555 .23061 L .87797 .23099 L p F P
0 g
s
.866 .959 .864 r
.87555 .23061 m .82013 .33357 L .81755 .33557 L p F P
0 g
s
.575 .939 .909 r
.8544 .15816 m .85194 .15777 L .77693 .20514 L p F P
0 g
s
.575 .939 .909 r
.76675 .20411 m .77693 .20514 L .85194 .15777 L p F P
0 g
s
.866 .959 .864 r
.81755 .33557 m .87303 .22923 L .87555 .23061 L p F P
0 g
s
.848 .917 .879 r
.87303 .22923 m .81755 .33557 L .81488 .33662 L p F P
0 g
s
.575 .939 .909 r
.35771 .37759 m .33614 .37861 L .26099 .42041 L p F P
0 g
s
.62 .65 .859 r
.26099 .42041 m .33614 .37861 L .35663 .41069 L p F P
0 g
s
.758 .942 .942 r
.71811 .39522 m .79603 .33048 L .80647 .336 L p F P
0 g
s
.76 .88 .932 r
.79603 .33048 m .71811 .39522 L .70356 .38633 L p F P
0 g
s
.678 .802 .941 r
.4998 .4456 m .58528 .40527 L .60322 .42244 L p F P
0 g
s
.678 .759 .912 r
.58528 .40527 m .4998 .4456 L .48014 .42521 L p F P
0 g
s
.848 .917 .879 r
.81488 .33662 m .87043 .22711 L .87303 .22923 L p F P
0 g
s
.829 .879 .88 r
.87043 .22711 m .81488 .33662 L .81213 .33695 L p F P
0 g
s
.575 .939 .909 r
.66834 .24782 m .65362 .24702 L .56529 .29105 L p F P
0 g
s
.575 .939 .909 r
.54727 .29079 m .56529 .29105 L .65362 .24702 L p F P
0 g
s
.575 .939 .909 r
.56529 .29105 m .54727 .29079 L .46066 .33432 L p F P
0 g
s
.575 .939 .909 r
.76675 .20411 m .75636 .20306 L .66834 .24782 L p F P
0 g
s
.575 .939 .909 r
.65362 .24702 m .66834 .24782 L .75636 .20306 L p F P
0 g
s
.651 .723 .902 r
.37697 .43755 m .46013 .40039 L .48014 .42521 L p F P
0 g
s
.649 .686 .871 r
.46013 .40039 m .37697 .43755 L .35663 .41069 L p F P
0 g
s
.575 .939 .909 r
.46066 .33432 m .44028 .3347 L .35771 .37759 L p F P
0 g
s
.575 .939 .909 r
.33614 .37861 m .35771 .37759 L .44028 .3347 L p F P
0 g
s
.575 .939 .909 r
.44028 .3347 m .46066 .33432 L .54727 .29079 L p F P
0 g
s
.829 .879 .88 r
.81213 .33695 m .86776 .2244 L .87043 .22711 L p F P
0 g
s
.811 .844 .875 r
.86776 .2244 m .81213 .33695 L .80933 .33671 L p F P
0 g
s
.711 .844 .945 r
.60322 .42244 m .68851 .37307 L .70356 .38633 L p F P
0 g
s
.71 .796 .918 r
.68851 .37307 m .60322 .42244 L .58528 .40527 L p F P
0 g
s
.811 .844 .875 r
.80933 .33671 m .86503 .22116 L .86776 .2244 L p F P
0 g
s
.794 .812 .867 r
.86503 .22116 m .80933 .33671 L .80647 .336 L p F P
0 g
s
.575 .939 .909 r
.85194 .15777 m .84946 .15737 L .76675 .20411 L p F P
0 g
s
.575 .939 .909 r
.75636 .20306 m .76675 .20411 L .84946 .15737 L p F P
0 g
s
.794 .812 .867 r
.80647 .336 m .86225 .21742 L .86503 .22116 L p F P
0 g
s
.793 .787 .847 r
.86225 .21742 m .80647 .336 L .79603 .33048 L p F P
0 g
s
.76 .88 .932 r
.70356 .38633 m .78515 .32127 L .79603 .33048 L p F P
0 g
s
.753 .829 .911 r
.78515 .32127 m .70356 .38633 L .68851 .37307 L p F P
0 g
s
.678 .759 .912 r
.48014 .42521 m .56691 .38386 L .58528 .40527 L p F P
0 g
s
.676 .721 .883 r
.56691 .38386 m .48014 .42521 L .46013 .40039 L p F P
0 g
s
.649 .686 .871 r
.35663 .41069 m .43981 .3707 L .46013 .40039 L p F P
0 g
s
.644 .647 .838 r
.43981 .3707 m .35663 .41069 L .33614 .37861 L p F P
0 g
s
0 0 .469 r
.88166 .21814 m .87758 .20028 L .87748 .20127 L p F P
0 g
s
0 0 .469 r
.87748 .20127 m .88156 .2193 L .88166 .21814 L p F P
0 g
s
0 .135 .66 r
.87427 .1922 m .87748 .20127 L .87758 .20028 L p F P
0 g
s
0 .135 .66 r
.87758 .20028 m .87436 .19129 L .87427 .1922 L p F P
0 g
s
.022 .212 .719 r
.87121 .1848 m .87427 .1922 L .87436 .19129 L p F P
0 g
s
0 0 .458 r
.88173 .21694 m .87766 .19926 L .87758 .20028 L p F P
0 g
s
0 0 .458 r
.87758 .20028 m .88166 .21814 L .88173 .21694 L p F P
0 g
s
0 .123 .654 r
.87436 .19129 m .87758 .20028 L .87766 .19926 L p F P
0 g
s
0 .123 .654 r
.87766 .19926 m .87443 .19034 L .87436 .19129 L p F P
0 g
s
.001 .2 .714 r
.8713 .18396 m .87436 .19129 L .87443 .19034 L p F P
0 g
s
.022 .212 .719 r
.87436 .19129 m .8713 .18396 L .87121 .1848 L p F P
0 g
s
0 0 .447 r
.88179 .21571 m .87771 .1982 L .87766 .19926 L p F P
0 g
s
0 0 .447 r
.87766 .19926 m .88173 .21694 L .88179 .21571 L p F P
0 g
s
0 .11 .647 r
.87443 .19034 m .87766 .19926 L .87771 .1982 L p F P
0 g
s
.039 .257 .755 r
.86824 .17838 m .87121 .1848 L .8713 .18396 L p F P
0 g
s
0 .11 .647 r
.87771 .1982 m .87447 .18934 L .87443 .19034 L p F P
0 g
s
0 .188 .708 r
.87136 .18307 m .87443 .19034 L .87447 .18934 L p F P
0 g
s
.001 .2 .714 r
.87443 .19034 m .87136 .18307 L .8713 .18396 L p F P
0 g
s
0 0 .435 r
.88181 .21444 m .87772 .19708 L .87771 .1982 L p F P
0 g
s
0 0 .435 r
.87771 .1982 m .88179 .21571 L .88181 .21444 L p F P
0 g
s
0 .097 .64 r
.87447 .18934 m .87771 .1982 L .87772 .19708 L p F P
0 g
s
.017 .245 .749 r
.86833 .17759 m .8713 .18396 L .87136 .18307 L p F P
0 g
s
.039 .257 .755 r
.8713 .18396 m .86833 .17759 L .86824 .17838 L p F P
0 g
s
.575 .939 .909 r
.75636 .20306 m .74576 .20199 L .65362 .24702 L p F P
0 g
s
.575 .939 .909 r
.63851 .2462 m .65362 .24702 L .74576 .20199 L p F P
0 g
s
.575 .939 .909 r
.65362 .24702 m .63851 .2462 L .54727 .29079 L p F P
0 g
s
.78 .684 .137 r
.88166 .21814 m .88156 .2193 L .88021 .22964 L p F P
0 g
s
.038 .285 .778 r
.86533 .17264 m .86824 .17838 L .86833 .17759 L p F P
0 g
s
0 .097 .64 r
.87772 .19708 m .87447 .18829 L .87447 .18934 L p F P
0 g
s
0 .174 .701 r
.87139 .18214 m .87447 .18934 L .87447 .18829 L p F P
0 g
s
0 .188 .708 r
.87447 .18934 m .87139 .18214 L .87136 .18307 L p F P
0 g
s
0 0 .421 r
.88181 .21312 m .8777 .1959 L .87772 .19708 L p F P
0 g
s
0 0 .421 r
.87772 .19708 m .88181 .21444 L .88181 .21312 L p F P
0 g
s
0 .082 .632 r
.87447 .18829 m .87772 .19708 L .8777 .1959 L p F P
0 g
s
.71 .796 .918 r
.58528 .40527 m .67301 .35593 L .68851 .37307 L p F P
0 g
s
.705 .755 .891 r
.67301 .35593 m .58528 .40527 L .56691 .38386 L p F P
0 g
s
0 .231 .743 r
.86838 .17678 m .87136 .18307 L .87139 .18214 L p F P
0 g
s
.017 .245 .749 r
.87136 .18307 m .86838 .17678 L .86833 .17759 L p F P
0 g
s
.799 .694 .152 r
.88173 .21694 m .88166 .21814 L .88027 .22826 L p F P
0 g
s
.78 .684 .137 r
.88021 .22964 m .88027 .22826 L .88166 .21814 L p F P
0 g
s
.013 .271 .772 r
.86541 .17193 m .86833 .17759 L .86838 .17678 L p F P
0 g
s
.038 .285 .778 r
.86833 .17759 m .86541 .17193 L .86533 .17264 L p F P
0 g
s
0 .082 .632 r
.8777 .1959 m .87441 .18717 L .87447 .18829 L p F P
0 g
s
0 .159 .693 r
.87136 .18116 m .87447 .18829 L .87441 .18717 L p F P
0 g
s
0 .174 .701 r
.87447 .18829 m .87136 .18116 L .87139 .18214 L p F P
0 g
s
.819 .704 .168 r
.88179 .21571 m .88173 .21694 L .88031 .22684 L p F P
0 g
s
.799 .694 .152 r
.88027 .22826 m .88031 .22684 L .88173 .21694 L p F P
0 g
s
0 0 .406 r
.88177 .21176 m .87761 .19462 L .8777 .1959 L p F P
0 g
s
0 0 .406 r
.8777 .1959 m .88181 .21312 L .88177 .21176 L p F P
0 g
s
0 .068 .623 r
.87441 .18717 m .8777 .1959 L .87761 .19462 L p F P
0 g
s
0 .217 .735 r
.86839 .17592 m .87139 .18214 L .87136 .18116 L p F P
0 g
s
0 .231 .743 r
.87139 .18214 m .86839 .17592 L .86838 .17678 L p F P
0 g
s
.023 .3 .793 r
.86246 .16747 m .86533 .17264 L .86541 .17193 L p F P
0 g
s
.839 .714 .184 r
.88181 .21444 m .88179 .21571 L .88032 .22537 L p F P
0 g
s
.819 .704 .168 r
.88031 .22684 m .88032 .22537 L .88179 .21571 L p F P
0 g
s
.575 .939 .909 r
.52872 .29051 m .54727 .29079 L .63851 .2462 L p F P
0 g
s
.575 .939 .909 r
.54727 .29079 m .52872 .29051 L .44028 .3347 L p F P
0 g
s
0 .256 .764 r
.86546 .17118 m .86838 .17678 L .86839 .17592 L p F P
0 g
s
.013 .271 .772 r
.86838 .17678 m .86546 .17118 L .86541 .17193 L p F P
0 g
s
.575 .939 .909 r
.84946 .15737 m .84698 .15698 L .75636 .20306 L p F P
0 g
s
.575 .939 .909 r
.74576 .20199 m .75636 .20306 L .84698 .15698 L p F P
0 g
s
0 .068 .623 r
.87761 .19462 m .87427 .18592 L .87441 .18717 L p F P
0 g
s
0 .144 .684 r
.87127 .18008 m .87441 .18717 L .87427 .18592 L p F P
0 g
s
0 .159 .693 r
.87441 .18717 m .87127 .18008 L .87136 .18116 L p F P
0 g
s
0 0 .39 r
.87745 .19318 m .87761 .19462 L p .88135 .20902 L F P
0 g
s
0 0 .39 r
.88157 .20885 m .88138 .20712 L p .88044 .20382 L F P
0 g
s
0 0 .39 r
.88131 .2088 m .87745 .19318 L p .88135 .20902 L F P
0 g
s
0 .055 .616 r
.87427 .18592 m .87761 .19462 L .87745 .19318 L p F P
0 g
s
0 .055 .616 r
.87745 .19318 m .87401 .18445 L .87427 .18592 L p F P
0 g
s
0 0 .374 r
.88157 .20885 m .87691 .19083 L .87745 .19318 L p F P
0 g
s
0 0 .374 r
.87745 .19318 m .88169 .21034 L .88157 .20885 L p F P
0 g
s
0 .07 .627 r
.87401 .18445 m .87745 .19318 L .87691 .19083 L p F P
0 g
s
0 .001 .578 r
.87624 .18906 m .87639 .18858 L p .87438 .18434 L F P
0 g
s
0 .07 .627 r
.8731 .18164 m .87401 .18445 L p .87543 .18757 L F P
0 g
s
0 .134 .679 r
.87074 .17741 m .87401 .18445 L .8731 .18164 L p F P
0 g
s
0 .048 .613 r
.87184 .17896 m .87226 .17912 L p .87065 .17629 L F P
0 g
s
0 .134 .679 r
.87231 .18004 m .86946 .17429 L p .87201 .17968 L F P
0 g
s
0 .048 .613 r
.86763 .171 m .8708 .17699 L p .87065 .17629 L F P
0 g
s
0 .048 .613 r
.8708 .17699 m .87184 .17896 L p .87065 .17629 L F P
0 g
s
0 .134 .679 r
.86946 .17429 m .87074 .17741 L p .87099 .17787 L F P
0 g
s
0 .134 .679 r
.87099 .17787 m .87201 .17968 L .87085 .17724 L F
.87099 .17787 m .87085 .17724 L .86946 .17429 L F
.8731 .18164 m .87231 .18004 L p .87201 .17968 L F P
0 g
s
0 .001 .578 r
.8724 .18014 m .87496 .18611 L .87438 .18434 L F
.87184 .17896 m .87231 .18004 L p .8724 .18014 L F P
0 g
s
0 .001 .578 r
.87231 .18004 m .87496 .18611 L p .8724 .18014 L F P
0 g
s
0 .001 .578 r
.87496 .18611 m .87624 .18906 L p .87438 .18434 L F P
0 g
s
0 .07 .627 r
.87543 .18757 m .87631 .18951 L .87508 .18648 L F
.87543 .18757 m .87508 .18648 L .8731 .18164 L F
.87691 .19083 m .87636 .18949 L p .87631 .18951 L F P
0 g
s
0 .07 .627 r
.87636 .18949 m .8731 .18164 L p .87631 .18951 L F P
0 g
s
0 0 .39 r
.87636 .18949 m .88085 .20619 L .88044 .20382 L F
.87624 .18906 m .87636 .18949 L p .87636 .18949 L F P
0 g
s
0 0 .39 r
.87636 .18949 m .88085 .20619 L p .87636 .18949 L F P
0 g
s
0 0 .39 r
.88085 .20619 m .88157 .20885 L p .88044 .20382 L F P
0 g
s
0 0 .39 r
.87639 .18858 m .87624 .18906 L p .88044 .20382 L F P
0 g
s
0 0 .39 r
.88138 .20712 m .88035 .20329 L p .88044 .20382 L F P
0 g
s
0 0 .39 r
.88035 .20329 m .87639 .18858 L p .88044 .20382 L F P
0 g
s
0 0 .39 r
.88169 .21034 m .88131 .2088 L p .88135 .20902 L F P
0 g
s
0 0 .39 r
.87761 .19462 m .88177 .21176 L .88169 .21034 L p F P
0 g
s
0 .2 .726 r
.86834 .17499 m .87136 .18116 L .87127 .18008 L p F P
0 g
s
0 .217 .735 r
.87136 .18116 m .86834 .17499 L .86839 .17592 L p F P
0 g
s
.859 .724 .202 r
.88181 .21312 m .88181 .21444 L .8803 .22384 L p F P
0 g
s
.839 .714 .184 r
.88032 .22537 m .8803 .22384 L .88181 .21444 L p F P
0 g
s
0 .285 .784 r
.86254 .16683 m .86541 .17193 L .86546 .17118 L p F P
0 g
s
.023 .3 .793 r
.86541 .17193 m .86254 .16683 L .86246 .16747 L p F P
0 g
s
0 .24 .754 r
.86545 .1704 m .86839 .17592 L .86834 .17499 L p F P
0 g
s
0 .256 .764 r
.86839 .17592 m .86545 .1704 L .86546 .17118 L p F P
0 g
s
0 .13 .676 r
.87109 .17888 m .87427 .18592 L .87401 .18445 L p F P
0 g
s
0 .144 .684 r
.87427 .18592 m .87109 .17888 L .87127 .18008 L p F P
0 g
s
0 .183 .715 r
.86822 .17399 m .87127 .18008 L .87109 .17888 L p F P
0 g
s
0 .2 .726 r
.87127 .18008 m .86822 .17399 L .86834 .17499 L p F P
0 g
s
.88 .733 .22 r
.88177 .21176 m .88181 .21312 L .88023 .22227 L p F P
0 g
s
.859 .724 .202 r
.8803 .22384 m .88023 .22227 L .88181 .21312 L p F P
0 g
s
.793 .787 .847 r
.79603 .33048 m .85942 .21321 L .86225 .21742 L p F P
0 g
s
.79 .763 .829 r
.85942 .21321 m .79603 .33048 L .78515 .32127 L p F P
0 g
s
0 .306 .799 r
.85964 .16278 m .86246 .16747 L .86254 .16683 L p F P
0 g
s
0 .268 .774 r
.86258 .16616 m .86546 .17118 L .86545 .1704 L p F P
0 g
s
0 .285 .784 r
.86546 .17118 m .86258 .16616 L .86254 .16683 L p F P
0 g
s
.575 .939 .909 r
.44028 .3347 m .41928 .33509 L .33614 .37861 L p F P
0 g
s
.644 .647 .838 r
.33614 .37861 m .41928 .33509 L .43981 .3707 L p F P
0 g
s
0 .221 .743 r
.86539 .16955 m .86834 .17499 L .86822 .17399 L p F P
0 g
s
0 .24 .754 r
.86834 .17499 m .86539 .16955 L .86545 .1704 L p F P
0 g
s
0 .13 .676 r
.87401 .18445 m .87074 .17741 L .87109 .17888 L p F P
0 g
s
.902 .742 .242 r
.88169 .21034 m .88177 .21176 L .88012 .22063 L p F P
0 g
s
.88 .733 .22 r
.88023 .22227 m .88012 .22063 L .88177 .21176 L p F P
0 g
s
.575 .939 .909 r
.41928 .33509 m .44028 .3347 L .52872 .29051 L p F P
0 g
s
0 .165 .704 r
.86799 .17284 m .87109 .17888 L .87074 .17741 L p F P
0 g
s
0 .183 .715 r
.87109 .17888 m .86799 .17284 L .86822 .17399 L p F P
0 g
s
0 .288 .788 r
.85971 .16223 m .86254 .16683 L .86258 .16616 L p F P
0 g
s
0 .306 .799 r
.86254 .16683 m .85971 .16223 L .85964 .16278 L p F P
0 g
s
0 .248 .762 r
.86256 .16546 m .86545 .1704 L .86539 .16955 L p F P
0 g
s
0 .268 .774 r
.86545 .1704 m .86256 .16546 L .86258 .16616 L p F P
0 g
s
.941 .751 .281 r
.88157 .20885 m .88169 .21034 L .87992 .21892 L p F P
0 g
s
.902 .742 .242 r
.88012 .22063 m .87992 .21892 L .88169 .21034 L p F P
0 g
s
0 .199 .729 r
.86524 .16862 m .86822 .17399 L .86799 .17284 L p F P
0 g
s
0 .221 .743 r
.86822 .17399 m .86524 .16862 L .86539 .16955 L p F P
0 g
s
0 0 .349 r
.88111 .20527 m .87648 .18809 L .87639 .18858 L p F P
0 g
s
0 0 .349 r
.87639 .18858 m .88138 .20712 L .88111 .20527 L p F P
0 g
s
0 0 .536 r
.87226 .17912 m .87639 .18858 L .87648 .18809 L p F P
0 g
s
0 .001 .578 r
.87639 .18858 m .87226 .17912 L .87184 .17896 L p F P
0 g
s
.676 .721 .883 r
.46013 .40039 m .54815 .35807 L .56691 .38386 L p F P
0 g
s
.671 .683 .853 r
.54815 .35807 m .46013 .40039 L .43981 .3707 L p F P
0 g
s
0 .267 .774 r
.85974 .16165 m .86258 .16616 L .86256 .16546 L p F P
0 g
s
0 .288 .788 r
.86258 .16616 m .85974 .16165 L .85971 .16223 L p F P
0 g
s
0 .149 .692 r
.86755 .17141 m .87074 .17741 L .86946 .17429 L p F P
0 g
s
0 .165 .704 r
.87074 .17741 m .86755 .17141 L .86799 .17284 L p F P
0 g
s
0 .301 .796 r
.85684 .15855 m .85964 .16278 L .85971 .16223 L p F P
0 g
s
0 .225 .746 r
.86248 .16471 m .86539 .16955 L .86524 .16862 L p F P
0 g
s
0 .248 .762 r
.86539 .16955 m .86248 .16471 L .86256 .16546 L p F P
0 g
s
.917 .773 .29 r
.87895 .2173 m .87893 .21502 L .87904 .21467 L p F P
0 g
s
.917 .773 .29 r
.87904 .21467 m .88138 .20712 L p .87901 .21706 L F P
0 g
s
.917 .773 .29 r
.87895 .2173 m .87904 .21467 L .87901 .21706 L F
.993 .869 .599 r
.87893 .21502 m .87895 .2173 L .87791 .21692 L p F P
0 g
s
.972 .848 .66 r
.87557 .21377 m .87536 .21598 L .87442 .2151 L p F P
0 g
s
.964 .831 .664 r
.87163 .2147 m .87157 .21456 L p .87324 .2142 L F P
0 g
s
.95 .819 .68 r
.87199 .21044 m .87154 .21243 L .8708 .21149 L p F P
0 g
s
.944 .808 .679 r
.86864 .21113 m .86797 .20948 L p .8699 .21049 L F P
0 g
s
.944 .808 .679 r
.86797 .20948 m .86645 .20573 L .86845 .20849 L p F P
0 g
s
.944 .808 .679 r
.86845 .20849 m .8699 .21049 L p .86797 .20948 L F P
0 g
s
.95 .819 .68 r
.8708 .21149 m .86845 .20849 L p .87091 .20969 L F P
0 g
s
.95 .819 .68 r
.86845 .20849 m .86755 .20733 L p .86864 .2081 L F P
0 g
s
.95 .819 .68 r
.86864 .2081 m .87091 .20969 L .86845 .20849 L F
.87091 .20969 m .87199 .21044 L .8708 .21149 L F
.964 .831 .664 r
.87157 .21456 m .87074 .21252 L p .8722 .21304 L F P
0 g
s
.964 .831 .664 r
.87074 .21252 m .8699 .21049 L .8708 .21149 L p F P
0 g
s
.964 .831 .664 r
.8708 .21149 m .8722 .21304 L p .87074 .21252 L F P
0 g
s
.964 .831 .664 r
.8722 .21304 m .87324 .2142 L p .87157 .21456 L F P
0 g
s
.972 .848 .66 r
.87442 .2151 m .8722 .21304 L p .87416 .2133 L F P
0 g
s
.972 .848 .66 r
.8722 .21304 m .87154 .21243 L p .87235 .2127 L F P
0 g
s
.972 .848 .66 r
.87235 .2127 m .87416 .2133 L .8722 .21304 L F
.87416 .2133 m .87557 .21377 L .87442 .2151 L F
.984 .85 .629 r
.87453 .21741 m .87324 .2142 L .87442 .2151 L p F P
0 g
s
.984 .85 .629 r
.87442 .2151 m .87575 .21612 L p .87472 .21721 L F P
0 g
s
.984 .85 .629 r
.87453 .21741 m .87442 .2151 L .87472 .21721 L F
.87575 .21612 m .87644 .21665 L p .87556 .217 L F P
0 g
s
.984 .85 .629 r
.87453 .21741 m .87575 .21612 L .87556 .217 L F
.993 .869 .599 r
.87791 .21692 m .87575 .21612 L p .87736 .21544 L F P
0 g
s
.993 .869 .599 r
.87575 .21612 m .87536 .21598 L p .8758 .21586 L F P
0 g
s
.993 .869 .599 r
.8758 .21586 m .87736 .21544 L .87575 .21612 L F
.87736 .21544 m .87893 .21502 L .87791 .21692 L F
.997 .855 .554 r
.87732 .21903 m .87644 .21665 L .87791 .21692 L p F P
0 g
s
.997 .855 .554 r
.87791 .21692 m .87901 .21712 L p .87829 .21794 L F P
0 g
s
.997 .855 .554 r
.87732 .21903 m .87791 .21692 L .87829 .21794 L F
.87901 .21712 m .87945 .2172 L p .87901 .21758 L F P
0 g
s
.997 .855 .554 r
.87732 .21903 m .87901 .21712 L .87901 .21758 L F
.917 .773 .29 r
.88138 .20712 m .88157 .20885 L .87901 .21712 L p F P
0 g
s
.917 .773 .29 r
.87901 .21712 m .87895 .2173 L p .87901 .21706 L F P
0 g
s
.917 .773 .29 r
.87901 .21706 m .88138 .20712 L .87901 .21712 L F
.941 .751 .281 r
.87992 .21892 m .87945 .2172 L .88157 .20885 L p F P
0 g
s
0 .175 .711 r
.86496 .16756 m .86799 .17284 L .86755 .17141 L p F P
0 g
s
0 .199 .729 r
.86799 .17284 m .86496 .16756 L .86524 .16862 L p F P
0 g
s
.753 .829 .911 r
.68851 .37307 m .77391 .30901 L .78515 .32127 L p F P
0 g
s
.745 .786 .886 r
.77391 .30901 m .68851 .37307 L .67301 .35593 L p F P
0 g
s
0 0 .3 r
.88074 .20328 m .87651 .18758 L .87648 .18809 L p F P
0 g
s
0 0 .3 r
.87648 .18809 m .88111 .20527 L .88074 .20328 L p F P
0 g
s
0 0 .484 r
.87266 .17932 m .87648 .18809 L .87651 .18758 L p F P
0 g
s
0 0 .536 r
.87648 .18809 m .87266 .17932 L .87226 .17912 L p F P
0 g
s
0 .279 .78 r
.85692 .15809 m .85971 .16223 L .85974 .16165 L p F P
0 g
s
0 .301 .796 r
.85971 .16223 m .85692 .15809 L .85684 .15855 L p F P
0 g
s
0 .242 .756 r
.85972 .16105 m .86256 .16546 L .86248 .16471 L p F P
0 g
s
0 .267 .774 r
.86256 .16546 m .85972 .16105 L .85974 .16165 L p F P
0 g
s
.929 .771 .294 r
.88111 .20527 m .88138 .20712 L .87893 .21502 L p F P
0 g
s
.97 .896 .531 r
.88027 .22826 m .88021 .22964 L .87797 .23099 L p F P
0 g
s
0 .197 .725 r
.8623 .16389 m .86524 .16862 L .86496 .16756 L p F P
0 g
s
0 .225 .746 r
.86524 .16862 m .8623 .16389 L .86248 .16471 L p F P
0 g
s
0 0 .569 r
.86832 .17167 m .87226 .17912 L .87266 .17932 L p F P
0 g
s
0 .048 .613 r
.87226 .17912 m .86832 .17167 L .86763 .171 L p F P
0 g
s
0 .038 .594 r
.86763 .171 m .86832 .17167 L p .86717 .16994 L F P
0 g
s
0 .129 .674 r
.86443 .16622 m .86755 .17141 L .86593 .16815 L p F P
0 g
s
0 .038 .594 r
.86355 .1645 m .86688 .1698 L p .86717 .16994 L F P
0 g
s
0 .038 .594 r
.86688 .1698 m .86763 .171 L p .86717 .16994 L F P
0 g
s
0 .149 .692 r
.86946 .17429 m .86688 .1698 L p .86755 .17141 L F P
0 g
s
0 .149 .692 r
.86688 .1698 m .86593 .16815 L .86671 .16972 L p F P
0 g
s
0 .149 .692 r
.86671 .16972 m .86755 .17141 L p .86688 .1698 L F P
0 g
s
.975 .893 .534 r
.88031 .22684 m .88027 .22826 L .87801 .22948 L p F P
0 g
s
.97 .896 .531 r
.87797 .23099 m .87801 .22948 L .88027 .22826 L p F P
0 g
s
0 .175 .711 r
.86755 .17141 m .86443 .16622 L .86496 .16756 L p F P
0 g
s
0 .253 .761 r
.85694 .15763 m .85974 .16165 L .85972 .16105 L p F P
0 g
s
0 .279 .78 r
.85974 .16165 m .85694 .15763 L .85692 .15809 L p F P
0 g
s
0 0 .241 r
.88024 .2011 m .87645 .18703 L .87651 .18758 L p F P
0 g
s
0 0 .241 r
.87651 .18758 m .88074 .20328 L .88024 .2011 L p F P
0 g
s
0 0 .418 r
.87301 .17956 m .87651 .18758 L .87645 .18703 L p F P
0 g
s
0 0 .484 r
.87651 .18758 m .87301 .17956 L .87266 .17932 L p F P
0 g
s
0 .213 .734 r
.85962 .16042 m .86248 .16471 L .8623 .16389 L p F P
0 g
s
0 .242 .756 r
.86248 .16471 m .85962 .16042 L .85972 .16105 L p F P
0 g
s
.575 .939 .909 r
.8544 .15816 m .85684 .15855 L .85692 .15809 L p F P
0 g
s
.94 .767 .298 r
.88074 .20328 m .88111 .20527 L .87883 .21259 L p F P
0 g
s
.929 .771 .294 r
.87893 .21502 m .87883 .21259 L .88111 .20527 L p F P
0 g
s
0 0 .513 r
.86901 .17241 m .87266 .17932 L .87301 .17956 L p F P
0 g
s
0 0 .569 r
.87266 .17932 m .86901 .17241 L .86832 .17167 L p F P
0 g
s
.98 .89 .537 r
.88032 .22537 m .88031 .22684 L .87803 .22793 L p F P
0 g
s
.975 .893 .534 r
.87801 .22948 m .87803 .22793 L .88031 .22684 L p F P
0 g
s
0 .164 .698 r
.86198 .16294 m .86496 .16756 L .86443 .16622 L p F P
0 g
s
0 .197 .725 r
.86496 .16756 m .86198 .16294 L .8623 .16389 L p F P
0 g
s
.984 .886 .54 r
.8803 .22384 m .88032 .22537 L .878 .22632 L p F P
0 g
s
.98 .89 .537 r
.87803 .22793 m .878 .22632 L .88032 .22537 L p F P
0 g
s
0 .221 .735 r
.85691 .15715 m .85972 .16105 L .85962 .16042 L p F P
0 g
s
0 .253 .761 r
.85972 .16105 m .85691 .15715 L .85694 .15763 L p F P
0 g
s
.575 .939 .909 r
.85463 .15773 m .85692 .15809 L .85694 .15763 L p F P
0 g
s
.575 .939 .909 r
.85692 .15809 m .85463 .15773 L .8544 .15816 L p F P
0 g
s
.95 .761 .302 r
.88024 .2011 m .88074 .20328 L .87866 .20995 L p F P
0 g
s
.94 .767 .298 r
.87883 .21259 m .87866 .20995 L .88074 .20328 L p F P
0 g
s
0 .177 .703 r
.85942 .15973 m .8623 .16389 L .86198 .16294 L p F P
0 g
s
0 .213 .734 r
.8623 .16389 m .85942 .15973 L .85962 .16042 L p F P
0 g
s
0 0 .334 r
.87332 .17986 m .87645 .18703 L .87627 .18646 L p F P
0 g
s
0 0 .418 r
.87645 .18703 m .87332 .17986 L .87301 .17956 L p F P
0 g
s
.697 .418 0 r
.87956 .19866 m .87627 .18646 L .87645 .18703 L p F P
0 g
s
.697 .418 0 r
.87645 .18703 m .88024 .2011 L .87956 .19866 L p F P
0 g
s
0 0 .444 r
.86968 .17325 m .87301 .17956 L .87332 .17986 L p F P
0 g
s
0 0 .513 r
.87301 .17956 m .86968 .17325 L .86901 .17241 L p F P
0 g
s
0 0 .546 r
.8645 .16559 m .86832 .17167 L .86901 .17241 L p F P
0 g
s
0 .038 .594 r
.86832 .17167 m .8645 .16559 L .86355 .1645 L p F P
0 g
s
.988 .882 .543 r
.88023 .22227 m .8803 .22384 L .87794 .22464 L p F P
0 g
s
.984 .886 .54 r
.878 .22632 m .87794 .22464 L .8803 .22384 L p F P
0 g
s
0 .129 .674 r
.86593 .16815 m .86247 .16298 L .86443 .16622 L p F P
0 g
s
0 .073 .617 r
.8629 .16369 m .86247 .16298 L p .86181 .16239 L F P
0 g
s
0 0 .517 r
.85957 .15932 m .8632 .16405 L p .8645 .16559 L F P
0 g
s
0 0 .517 r
.8632 .16405 m .86355 .1645 L .86412 .16516 L p F P
0 g
s
0 0 .517 r
.86412 .16516 m .8645 .16559 L p .8632 .16405 L F P
0 g
s
0 .073 .617 r
.86138 .16175 m .86181 .16239 L p .86247 .16298 L F P
0 g
s
0 .073 .617 r
.86181 .16239 m .86443 .16622 L .8629 .16369 L p F P
0 g
s
0 .164 .698 r
.86443 .16622 m .86138 .16175 L .86198 .16294 L p F P
0 g
s
.575 .939 .909 r
.85482 .15729 m .85694 .15763 L .85691 .15715 L p F P
0 g
s
.575 .939 .909 r
.85694 .15763 m .85482 .15729 L .85463 .15773 L p F P
0 g
s
0 .183 .701 r
.8568 .15667 m .85962 .16042 L .85942 .15973 L p F P
0 g
s
0 .221 .735 r
.85962 .16042 m .8568 .15667 L .85691 .15715 L p F P
0 g
s
.991 .876 .546 r
.88012 .22063 m .88023 .22227 L .87782 .22288 L p F P
0 g
s
.988 .882 .543 r
.87794 .22464 m .87782 .22288 L .88023 .22227 L p F P
0 g
s
.96 .754 .305 r
.87956 .19866 m .88024 .2011 L .87837 .20707 L p F P
0 g
s
.95 .761 .302 r
.87866 .20995 m .87837 .20707 L .88024 .2011 L p F P
0 g
s
0 0 .487 r
.86547 .16678 m .86901 .17241 L .86968 .17325 L p F P
0 g
s
0 0 .546 r
.86901 .17241 m .86547 .16678 L .8645 .16559 L p F P
0 g
s
0 0 .334 r
.87627 .18646 m .87356 .18023 L .87332 .17986 L p F P
0 g
s
0 0 .358 r
.87033 .1742 m .87332 .17986 L .87356 .18023 L p F P
0 g
s
0 0 .444 r
.87332 .17986 m .87033 .1742 L .86968 .17325 L p F P
0 g
s
0 .13 .66 r
.85905 .15896 m .86198 .16294 L .86138 .16175 L p F P
0 g
s
0 .177 .703 r
.86198 .16294 m .85905 .15896 L .85942 .15973 L p F P
0 g
s
.777 .482 0 r
.87859 .19579 m .8759 .18582 L .87627 .18646 L p F P
0 g
s
.777 .482 0 r
.87627 .18646 m .87956 .19866 L .87859 .19579 L p F P
0 g
s
.699 .345 0 r
.87356 .18023 m .87627 .18646 L .8759 .18582 L p F P
0 g
s
.982 .91 .641 r
.87801 .22948 m .87797 .23099 L .87555 .23061 L p F P
0 g
s
.994 .869 .549 r
.87992 .21892 m .88012 .22063 L .87763 .22102 L p F P
0 g
s
.991 .876 .546 r
.87782 .22288 m .87763 .22102 L .88012 .22063 L p F P
0 g
s
.575 .939 .909 r
.85497 .15684 m .85691 .15715 L .8568 .15667 L p F P
0 g
s
.575 .939 .909 r
.85691 .15715 m .85497 .15684 L .85482 .15729 L p F P
0 g
s
0 0 .416 r
.86644 .1681 m .86968 .17325 L .87033 .1742 L p F P
0 g
s
0 0 .487 r
.86968 .17325 m .86644 .1681 L .86547 .16678 L p F P
0 g
s
.575 .939 .909 r
.85194 .15777 m .8544 .15816 L .85463 .15773 L p F P
0 g
s
0 .135 .655 r
.85657 .15616 m .85942 .15973 L .85905 .15896 L p F P
0 g
s
0 .183 .701 r
.85942 .15973 m .85657 .15616 L .8568 .15667 L p F P
0 g
s
.983 .905 .64 r
.87803 .22793 m .87801 .22948 L .87558 .229 L p F P
0 g
s
.982 .91 .641 r
.87555 .23061 m .87558 .229 L .87801 .22948 L p F P
0 g
s
.968 .743 .308 r
.87859 .19579 m .87956 .19866 L .87794 .20382 L p F P
0 g
s
.96 .754 .305 r
.87837 .20707 m .87794 .20382 L .87956 .19866 L p F P
0 g
s
.699 .345 0 r
.8759 .18582 m .87368 .18072 L .87356 .18023 L p F P
0 g
s
0 0 .358 r
.87356 .18023 m .87097 .17533 L .87033 .1742 L p F P
0 g
s
.698 .312 0 r
.87097 .17533 m .87356 .18023 L .87368 .18072 L p F P
0 g
s
.997 .855 .554 r
.87945 .2172 m .87992 .21892 L .87732 .21903 L p F P
0 g
s
.994 .869 .549 r
.87763 .22102 m .87732 .21903 L .87992 .21892 L p F P
0 g
s
.985 .899 .638 r
.878 .22632 m .87803 .22793 L .87557 .22732 L p F P
0 g
s
.983 .905 .64 r
.87558 .229 m .87557 .22732 L .87803 .22793 L p F P
0 g
s
.575 .939 .909 r
.85232 .15736 m .85463 .15773 L .85482 .15729 L p F P
0 g
s
.575 .939 .909 r
.85463 .15773 m .85232 .15736 L .85194 .15777 L p F P
0 g
s
0 0 .517 r
.8645 .16559 m .86078 .16074 L .85957 .15932 L p F P
0 g
s
.625 .13 0 r
.85957 .15932 m .86078 .16074 L p .86076 .16072 L F P
0 g
s
0 .073 .617 r
.86247 .16298 m .85937 .15913 L p .86138 .16175 L F P
0 g
s
0 .073 .617 r
.85927 .15902 m .86138 .16175 L p .85937 .15913 L F P
0 g
s
0 0 .507 r
.85837 .15799 m .86138 .16175 L .85927 .15902 L p F P
0 g
s
0 0 .507 r
.85927 .15902 m .85909 .15879 L p .85865 .1583 L F P
0 g
s
0 0 .507 r
.85837 .15799 m .85927 .15902 L .85865 .1583 L F
.625 .13 0 r
.8606 .16056 m .85937 .15913 L .86076 .16072 L F
0 .13 .66 r
.86138 .16175 m .85837 .15799 L .85905 .15896 L p F P
0 g
s
.575 .939 .909 r
.85506 .15639 m .8568 .15667 L .85657 .15616 L p F P
0 g
s
.575 .939 .909 r
.8568 .15667 m .85506 .15639 L .85497 .15684 L p F P
0 g
s
.575 .939 .909 r
.85506 .15592 m .85657 .15616 L .85617 .15562 L p F P
0 g
s
.575 .939 .909 r
.85657 .15616 m .85506 .15592 L .85506 .15639 L p F P
0 g
s
.625 .13 0 r
.85571 .15561 m .85936 .15912 L p .8606 .16056 L F P
0 g
s
.625 .13 0 r
.85936 .15912 m .85937 .15913 L p .8606 .16056 L F P
0 g
s
.625 .13 0 r
.85937 .15913 m .85957 .15932 L p .86076 .16072 L F P
0 g
s
0 .073 .617 r
.85937 .15913 m .85909 .15879 L .85927 .15902 L p F P
0 g
s
.642 .225 0 r
.86744 .1696 m .87033 .1742 L .87097 .17533 L p F P
0 g
s
0 0 .416 r
.87033 .1742 m .86744 .1696 L .86644 .1681 L p F P
0 g
s
0 0 .466 r
.86078 .16074 m .8645 .16559 L .86547 .16678 L p F P
0 g
s
.859 .549 .023 r
.87707 .19213 m .87517 .18506 L .8759 .18582 L p F P
0 g
s
.859 .549 .023 r
.8759 .18582 m .87859 .19579 L .87707 .19213 L p F P
0 g
s
.807 .45 0 r
.87368 .18072 m .8759 .18582 L .87517 .18506 L p F P
0 g
s
.986 .892 .637 r
.87794 .22464 m .878 .22632 L .87551 .22558 L p F P
0 g
s
.985 .899 .638 r
.87557 .22732 m .87551 .22558 L .878 .22632 L p F P
0 g
s
.705 .755 .891 r
.56691 .38386 m .65709 .33502 L .67301 .35593 L p F P
0 g
s
.7 .718 .863 r
.65709 .33502 m .56691 .38386 L .54815 .35807 L p F P
0 g
s
.584 .13 0 r
.86202 .16229 m .86547 .16678 L .86644 .1681 L p F P
0 g
s
0 0 .466 r
.86547 .16678 m .86202 .16229 L .86078 .16074 L p F P
0 g
s
0 .069 .586 r
.85617 .15562 m .85905 .15896 L .85837 .15799 L p F P
0 g
s
0 0 .507 r
.85909 .15879 m .85876 .15847 L p .85837 .15799 L F P
0 g
s
0 0 .507 r
.85876 .15847 m .8558 .15568 L .858 .15766 L p F P
0 g
s
0 0 .507 r
.858 .15766 m .85837 .15799 L p .85876 .15847 L F P
0 g
s
0 .135 .655 r
.85905 .15896 m .85699 .15657 L p .85657 .15616 L F P
0 g
s
0 .135 .655 r
.85699 .15657 m .85617 .15562 L .85643 .15596 L p F P
0 g
s
0 .135 .655 r
.85643 .15596 m .85657 .15616 L p .85699 .15657 L F P
0 g
s
.575 .939 .909 r
.85269 .15695 m .85482 .15729 L .85497 .15684 L p F P
0 g
s
.575 .939 .909 r
.85482 .15729 m .85269 .15695 L .85232 .15736 L p F P
0 g
s
.975 .728 .311 r
.87707 .19213 m .87859 .19579 L .87726 .2 L p F P
0 g
s
.968 .743 .308 r
.87794 .20382 m .87726 .2 L .87859 .19579 L p F P
0 g
s
.698 .312 0 r
.87368 .18072 m .87156 .17672 L .87097 .17533 L p F P
0 g
s
.729 .316 0 r
.86846 .17133 m .87097 .17533 L .87156 .17672 L p F P
0 g
s
.642 .225 0 r
.87097 .17533 m .86846 .17133 L .86744 .1696 L p F P
0 g
s
.807 .45 0 r
.87517 .18506 m .87359 .18145 L .87368 .18072 L p F P
0 g
s
.805 .423 0 r
.87156 .17672 m .87368 .18072 L .87359 .18145 L p F P
0 g
s
.987 .885 .635 r
.87782 .22288 m .87794 .22464 L .87541 .22374 L p F P
0 g
s
.986 .892 .637 r
.87551 .22558 m .87541 .22374 L .87794 .22464 L p F P
0 g
s
.645 .194 0 r
.8633 .164 m .86644 .1681 L .86744 .1696 L p F P
0 g
s
.584 .13 0 r
.86644 .1681 m .8633 .164 L .86202 .16229 L p F P
0 g
s
.575 .939 .909 r
.85302 .15653 m .85497 .15684 L .85506 .15639 L p F P
0 g
s
.575 .939 .909 r
.85497 .15684 m .85302 .15653 L .85269 .15695 L p F P
0 g
s
.79 .763 .829 r
.78515 .32127 m .85653 .2085 L .85942 .21321 L p F P
0 g
s
.786 .74 .81 r
.85653 .2085 m .78515 .32127 L .77391 .30901 L p F P
0 g
s
.987 .877 .633 r
.87763 .22102 m .87782 .22288 L .87523 .2218 L p F P
0 g
s
.987 .885 .635 r
.87541 .22374 m .87523 .2218 L .87782 .22288 L p F P
0 g
s
.971 .897 .692 r
.87558 .229 m .87555 .23061 L .87303 .22923 L p F P
0 g
s
.709 .266 0 r
.86462 .16593 m .86744 .1696 L .86846 .17133 L p F P
0 g
s
.645 .194 0 r
.86744 .1696 m .86462 .16593 L .8633 .164 L p F P
0 g
s
.995 .86 .584 r
.87883 .21259 m .87893 .21502 L .87557 .21377 L p F P
0 g
s
.993 .869 .599 r
.87536 .21598 m .87557 .21377 L .87893 .21502 L p F P
0 g
s
.805 .423 0 r
.87359 .18145 m .87209 .17862 L .87156 .17672 L p F P
0 g
s
.821 .423 0 r
.86951 .17345 m .87156 .17672 L .87209 .17862 L p F P
0 g
s
.729 .316 0 r
.87156 .17672 m .86951 .17345 L .86846 .17133 L p F P
0 g
s
.951 .635 .208 r
.87517 .18506 m .87707 .19213 L .87219 .18362 L closepath p F P
0 g
s
.938 .601 .169 r
.87359 .18145 m .87517 .18506 L .87219 .18362 L closepath p F P
0 g
s
.575 .939 .909 r
.84946 .15737 m .85194 .15777 L .85232 .15736 L p F P
0 g
s
.997 .849 .567 r
.87866 .20995 m .87883 .21259 L .87572 .21142 L p F P
0 g
s
.995 .86 .584 r
.87557 .21377 m .87572 .21142 L .87883 .21259 L p F P
0 g
s
.575 .939 .909 r
.85494 .15542 m .85617 .15562 L .85543 .15503 L p F P
0 g
s
.575 .939 .909 r
.85617 .15562 m .85494 .15542 L .85506 .15592 L p F P
0 g
s
.652 .167 0 r
.85543 .15503 m .85837 .15799 L .8558 .15568 L p F P
0 g
s
0 .069 .586 r
.85837 .15799 m .85543 .15503 L .85617 .15562 L p F P
0 g
s
.987 .868 .63 r
.87732 .21903 m .87763 .22102 L .87497 .21971 L p F P
0 g
s
.987 .877 .633 r
.87523 .2218 m .87497 .21971 L .87763 .22102 L p F P
0 g
s
.972 .891 .688 r
.87557 .22732 m .87558 .229 L .87303 .22751 L p F P
0 g
s
.971 .897 .692 r
.87303 .22923 m .87303 .22751 L .87558 .229 L p F P
0 g
s
.575 .939 .909 r
.85331 .15611 m .85506 .15639 L .85506 .15592 L p F P
0 g
s
.575 .939 .909 r
.85506 .15639 m .85331 .15611 L .85302 .15653 L p F P
0 g
s
.777 .347 0 r
.86602 .16816 m .86846 .17133 L .86951 .17345 L p F P
0 g
s
.709 .266 0 r
.86846 .17133 m .86602 .16816 L .86462 .16593 L p F P
0 g
s
.978 .692 .312 r
.87613 .1951 m .87219 .18362 L .87707 .19213 L closepath p F P
0 g
s
.975 .728 .311 r
.87726 .2 m .87613 .1951 L .87707 .19213 L p F P
0 g
s
.575 .939 .909 r
.85001 .15699 m .85232 .15736 L .85269 .15695 L p F P
0 g
s
.575 .939 .909 r
.85232 .15736 m .85001 .15699 L .84946 .15737 L p F P
0 g
s
.998 .836 .547 r
.87837 .20707 m .87866 .20995 L .87581 .20888 L p F P
0 g
s
.997 .849 .567 r
.87572 .21142 m .87581 .20888 L .87866 .20995 L p F P
0 g
s
.935 .59 .162 r
.87209 .17862 m .87359 .18145 L .87219 .18362 L closepath p F P
0 g
s
.972 .884 .685 r
.87551 .22558 m .87557 .22732 L .873 .22571 L p F P
0 g
s
.972 .891 .688 r
.87303 .22751 m .873 .22571 L .87557 .22732 L p F P
0 g
s
.663 .175 0 r
.85717 .15727 m .86078 .16074 L .86202 .16229 L p F P
0 g
s
.625 .13 0 r
.86078 .16074 m .85717 .15727 L .85571 .15561 L p F P
0 g
s
.575 .939 .909 r
.84698 .15698 m .84448 .15658 L .74576 .20199 L p F P
0 g
s
.575 .939 .909 r
.73495 .20089 m .74576 .20199 L .84448 .15658 L p F P
0 g
s
.575 .939 .909 r
.74576 .20199 m .73495 .20089 L .63851 .2462 L p F P
0 g
s
.984 .85 .629 r
.87644 .21665 m .87732 .21903 L .87453 .21741 L p F P
0 g
s
.987 .868 .63 r
.87497 .21971 m .87453 .21741 L .87732 .21903 L p F P
0 g
s
.704 .223 0 r
.85868 .15908 m .86202 .16229 L .8633 .164 L p F P
0 g
s
.663 .175 0 r
.86202 .16229 m .85868 .15908 L .85717 .15727 L p F P
0 g
s
.999 .821 .524 r
.87794 .20382 m .87837 .20707 L .87583 .2061 L p F P
0 g
s
.998 .836 .547 r
.87581 .20888 m .87583 .2061 L .87837 .20707 L p F P
0 g
s
.575 .939 .909 r
.85054 .15661 m .85269 .15695 L .85302 .15653 L p F P
0 g
s
.575 .939 .909 r
.85269 .15695 m .85054 .15661 L .85001 .15699 L p F P
0 g
s
.575 .939 .909 r
.85355 .15567 m .85506 .15592 L .85494 .15542 L p F P
0 g
s
.575 .939 .909 r
.85506 .15592 m .85355 .15567 L .85331 .15611 L p F P
0 g
s
.972 .877 .681 r
.87541 .22374 m .87551 .22558 L .87291 .22382 L p F P
0 g
s
.972 .884 .685 r
.873 .22571 m .87291 .22382 L .87551 .22558 L p F P
0 g
s
.671 .683 .853 r
.43981 .3707 m .52904 .32731 L .54815 .35807 L p F P
0 g
s
.664 .643 .818 r
.52904 .32731 m .43981 .3707 L .41928 .33509 L p F P
0 g
s
.821 .423 0 r
.87209 .17862 m .87064 .17631 L .86951 .17345 L p F P
0 g
s
.848 .44 0 r
.86752 .17086 m .86951 .17345 L .87064 .17631 L p F P
0 g
s
.777 .347 0 r
.86951 .17345 m .86752 .17086 L .86602 .16816 L p F P
0 g
s
.937 .586 .168 r
.87064 .17631 m .87209 .17862 L .87219 .18362 L closepath p F P
0 g
s
.745 .276 0 r
.86025 .16108 m .8633 .164 L .86462 .16593 L p F P
0 g
s
.704 .223 0 r
.8633 .164 m .86025 .16108 L .85868 .15908 L p F P
0 g
s
.999 .801 .495 r
.87726 .2 m .87794 .20382 L .87573 .20297 L p F P
0 g
s
.999 .821 .524 r
.87583 .2061 m .87573 .20297 L .87794 .20382 L p F P
0 g
s
.575 .939 .909 r
.85106 .15622 m .85302 .15653 L .85331 .15611 L p F P
0 g
s
.575 .939 .909 r
.85302 .15653 m .85106 .15622 L .85054 .15661 L p F P
0 g
s
.972 .869 .676 r
.87523 .2218 m .87541 .22374 L .87276 .22183 L p F P
0 g
s
.972 .877 .681 r
.87291 .22382 m .87276 .22183 L .87541 .22374 L p F P
0 g
s
.788 .333 0 r
.8619 .16332 m .86462 .16593 L .86602 .16816 L p F P
0 g
s
.745 .276 0 r
.86462 .16593 m .8619 .16332 L .86025 .16108 L p F P
0 g
s
.997 .774 .457 r
.87613 .1951 m .87726 .2 L .87546 .19931 L p F P
0 g
s
.999 .801 .495 r
.87573 .20297 m .87546 .19931 L .87726 .2 L p F P
0 g
s
.833 .398 0 r
.86366 .1659 m .86602 .16816 L .86752 .17086 L p F P
0 g
s
.788 .333 0 r
.86602 .16816 m .86366 .1659 L .8619 .16332 L p F P
0 g
s
.941 .588 .182 r
.86923 .17448 m .87064 .17631 L .87219 .18362 L closepath p F P
0 g
s
.848 .44 0 r
.87064 .17631 m .86923 .17448 L .86752 .17086 L p F P
0 g
s
.575 .939 .909 r
.85543 .15503 m .85456 .15489 L .85494 .15542 L p F P
0 g
s
.575 .939 .909 r
.8537 .15522 m .85494 .15542 L .85456 .15489 L p F P
0 g
s
.575 .939 .909 r
.85494 .15542 m .8537 .15522 L .85355 .15567 L p F P
0 g
s
.575 .939 .909 r
.85156 .15582 m .85331 .15611 L .85355 .15567 L p F P
0 g
s
.575 .939 .909 r
.85331 .15611 m .85156 .15582 L .85106 .15622 L p F P
0 g
s
.956 .877 .717 r
.87303 .22751 m .87303 .22923 L .87043 .22711 L p F P
0 g
s
.575 .939 .909 r
.62299 .24537 m .63851 .2462 L .73495 .20089 L p F P
0 g
s
.575 .939 .909 r
.63851 .2462 m .62299 .24537 L .52872 .29051 L p F P
0 g
s
.971 .861 .672 r
.87497 .21971 m .87523 .2218 L .87254 .21969 L p F P
0 g
s
.972 .869 .676 r
.87276 .22183 m .87254 .21969 L .87523 .2218 L p F P
0 g
s
.575 .939 .909 r
.85456 .15489 m .85543 .15503 L .85263 .1541 L closepath p F P
0 g
s
.575 .939 .909 r
.85368 .15475 m .85456 .15489 L .85263 .1541 L closepath p F P
0 g
s
.652 .167 0 r
.8558 .15568 m .85263 .1541 L .85543 .15503 L p F P
0 g
s
.881 .472 .037 r
.8656 .16902 m .86752 .17086 L .86923 .17448 L p F P
0 g
s
.833 .398 0 r
.86752 .17086 m .8656 .16902 L .86366 .1659 L p F P
0 g
s
.956 .871 .712 r
.873 .22571 m .87303 .22751 L .87041 .22528 L p F P
0 g
s
.956 .877 .717 r
.87043 .22711 m .87041 .22528 L .87303 .22751 L p F P
0 g
s
.987 .714 .375 r
.87485 .19461 m .87219 .18362 L .87613 .1951 L closepath p F P
0 g
s
.997 .774 .457 r
.87546 .19931 m .87485 .19461 L .87613 .1951 L p F P
0 g
s
.745 .786 .886 r
.67301 .35593 m .76233 .29391 L .77391 .30901 L p F P
0 g
s
.736 .748 .862 r
.76233 .29391 m .67301 .35593 L .65709 .33502 L p F P
0 g
s
.575 .939 .909 r
.85203 .15543 m .85355 .15567 L .8537 .15522 L p F P
0 g
s
.575 .939 .909 r
.85355 .15567 m .85203 .15543 L .85156 .15582 L p F P
0 g
s
.97 .85 .666 r
.87453 .21741 m .87497 .21971 L .87219 .21735 L p F P
0 g
s
.971 .861 .672 r
.87254 .21969 m .87219 .21735 L .87497 .21971 L p F P
0 g
s
.575 .939 .909 r
.84698 .15698 m .84946 .15737 L .85001 .15699 L p F P
0 g
s
.956 .864 .707 r
.87291 .22382 m .873 .22571 L .87035 .22335 L p F P
0 g
s
.956 .871 .712 r
.87041 .22528 m .87035 .22335 L .873 .22571 L p F P
0 g
s
.946 .595 .206 r
.86787 .17318 m .86923 .17448 L .87219 .18362 L closepath p F P
0 g
s
.881 .472 .037 r
.86923 .17448 m .86787 .17318 L .8656 .16902 L p F P
0 g
s
.575 .939 .909 r
.84768 .15662 m .85001 .15699 L .85054 .15661 L p F P
0 g
s
.575 .939 .909 r
.85001 .15699 m .84768 .15662 L .84698 .15698 L p F P
0 g
s
.976 .842 .645 r
.87572 .21142 m .87557 .21377 L .87199 .21044 L p F P
0 g
s
.972 .848 .66 r
.87154 .21243 m .87199 .21044 L .87557 .21377 L p F P
0 g
s
.98 .835 .627 r
.87581 .20888 m .87572 .21142 L .87241 .20833 L p F P
0 g
s
.976 .842 .645 r
.87199 .21044 m .87241 .20833 L .87572 .21142 L p F P
0 g
s
.575 .939 .909 r
.84839 .15626 m .85054 .15661 L .85106 .15622 L p F P
0 g
s
.575 .939 .909 r
.85054 .15661 m .84839 .15626 L .84768 .15662 L p F P
0 g
s
.575 .939 .909 r
.85456 .15489 m .85368 .15475 L .8537 .15522 L p F P
0 g
s
.575 .939 .909 r
.85246 .15502 m .8537 .15522 L .85368 .15475 L p F P
0 g
s
.575 .939 .909 r
.85368 .15475 m .85281 .15461 L .85246 .15502 L p F P
0 g
s
.575 .939 .909 r
.85105 .15432 m .85193 .15446 L .85263 .1541 L closepath p F P
0 g
s
.575 .939 .909 r
.85016 .15418 m .85105 .15432 L .85263 .1541 L closepath p F P
0 g
s
.575 .939 .909 r
.84928 .15403 m .85016 .15418 L .85263 .1541 L closepath p F P
0 g
s
.575 .939 .909 r
.84839 .15389 m .84928 .15403 L .85263 .1541 L closepath p F P
0 g
s
.938 .572 .274 r
.84823 .15418 m .85227 .15408 L .8523 .15411 L F
.85263 .1541 m .85211 .15406 L .85191 .15407 L p F P
0 g
s
.938 .572 .274 r
.85143 .15404 m .85227 .15408 L p .85142 .1541 L F P
0 g
s
.938 .572 .274 r
.84823 .15418 m .85143 .15404 L .85142 .1541 L F
.85191 .15407 m .84823 .15418 L p .85142 .15412 L F P
0 g
s
.938 .572 .274 r
.85227 .15408 m .85263 .1541 L p .8523 .15411 L F P
0 g
s
.938 .572 .274 r
.85142 .15412 m .85263 .1541 L .85191 .15407 L F
.575 .939 .909 r
.8537 .15522 m .85246 .15502 L .85203 .15543 L p F P
0 g
s
.575 .939 .909 r
.8498 .15554 m .85156 .15582 L .85203 .15543 L p F P
0 g
s
.575 .939 .909 r
.85051 .15518 m .85203 .15543 L .85246 .15502 L p F P
0 g
s
.575 .939 .909 r
.85203 .15543 m .85051 .15518 L .8498 .15554 L p F P
0 g
s
.575 .939 .909 r
.85122 .15482 m .85246 .15502 L .85281 .15461 L p F P
0 g
s
.575 .939 .909 r
.85246 .15502 m .85122 .15482 L .85051 .15518 L p F P
0 g
s
.575 .939 .909 r
.85281 .15461 m .85193 .15446 L .85122 .15482 L p F P
0 g
s
.889 .497 .28 r
.85202 .15406 m .85372 .15583 L p .8505 .16042 L F P
0 g
s
.889 .497 .28 r
.84919 .1623 m .85099 .15704 L p .8505 .16042 L F P
0 g
s
.575 .939 .909 r
.8491 .1559 m .85106 .15622 L .85156 .15582 L p F P
0 g
s
.575 .939 .909 r
.85156 .15582 m .8498 .15554 L .8491 .1559 L p F P
0 g
s
.889 .497 .28 r
.85099 .15704 m .85202 .15406 L p .8505 .16042 L F P
0 g
s
.575 .939 .909 r
.85016 .15418 m .84928 .15403 L .84747 .15422 L p F P
0 g
s
.938 .572 .274 r
.84823 .15418 m .84839 .15389 L .85143 .15404 L p F P
0 g
s
.78 .287 0 r
.85571 .15561 m .85717 .15727 L p .85355 .15502 L F P
0 g
s
.575 .939 .909 r
.85193 .15446 m .85281 .15461 L .85263 .1541 L closepath p F P
0 g
s
.78 .287 0 r
.85202 .15406 m .85254 .15428 L p .85355 .15502 L F P
0 g
s
.78 .287 0 r
.85254 .15428 m .85571 .15561 L p .85355 .15502 L F P
0 g
s
.984 .826 .607 r
.87583 .2061 m .87581 .20888 L .87279 .20606 L p F P
0 g
s
.98 .835 .627 r
.87241 .20833 m .87279 .20606 L .87581 .20888 L p F P
0 g
s
.956 .857 .702 r
.87276 .22183 m .87291 .22382 L .87023 .22132 L p F P
0 g
s
.956 .864 .707 r
.87035 .22335 m .87023 .22132 L .87291 .22382 L p F P
0 g
s
.964 .831 .664 r
.87324 .2142 m .87453 .21741 L .87163 .2147 L p F P
0 g
s
.97 .85 .666 r
.87219 .21735 m .87163 .2147 L .87453 .21741 L p F P
0 g
s
.8 .317 0 r
.85372 .15583 m .85717 .15727 L .85868 .15908 L p F P
0 g
s
.78 .287 0 r
.85717 .15727 m .85372 .15583 L .85202 .15406 L p F P
0 g
s
.988 .815 .582 r
.87573 .20297 m .87583 .2061 L .87312 .20356 L p F P
0 g
s
.984 .826 .607 r
.87279 .20606 m .87312 .20356 L .87583 .2061 L p F P
0 g
s
.82 .349 0 r
.85549 .15775 m .85868 .15908 L .86025 .16108 L p F P
0 g
s
.8 .317 0 r
.85868 .15908 m .85549 .15775 L .85372 .15583 L p F P
0 g
s
.575 .939 .909 r
.85106 .15622 m .8491 .1559 L .84839 .15626 L p F P
0 g
s
.991 .799 .549 r
.87546 .19931 m .87573 .20297 L .87339 .20077 L p F P
0 g
s
.988 .815 .582 r
.87312 .20356 m .87339 .20077 L .87573 .20297 L p F P
0 g
s
.841 .384 0 r
.85734 .15986 m .86025 .16108 L .8619 .16332 L p F P
0 g
s
.82 .349 0 r
.86025 .16108 m .85734 .15986 L .85549 .15775 L p F P
0 g
s
.864 .422 .027 r
.8593 .16224 m .8619 .16332 L .86366 .1659 L p F P
0 g
s
.841 .384 0 r
.8619 .16332 m .8593 .16224 L .85734 .15986 L p F P
0 g
s
.993 .776 .504 r
.87485 .19461 m .87546 .19931 L .87354 .1975 L p F P
0 g
s
.991 .799 .549 r
.87339 .20077 m .87354 .1975 L .87546 .19931 L p F P
0 g
s
.887 .465 .075 r
.86142 .16497 m .86366 .1659 L .8656 .16902 L p F P
0 g
s
.864 .422 .027 r
.86366 .1659 m .86142 .16497 L .8593 .16224 L p F P
0 g
s
.956 .849 .696 r
.87254 .21969 m .87276 .22183 L .87004 .21915 L p F P
0 g
s
.956 .857 .702 r
.87023 .22132 m .87004 .21915 L .87276 .22183 L p F P
0 g
s
.988 .718 .4 r
.87349 .19333 m .87219 .18362 L .87485 .19461 L closepath p F P
0 g
s
.993 .776 .504 r
.87354 .1975 m .87349 .19333 L .87485 .19461 L p F P
0 g
s
.914 .516 .133 r
.86377 .16827 m .8656 .16902 L .86787 .17318 L p F P
0 g
s
.887 .465 .075 r
.8656 .16902 m .86377 .16827 L .86142 .16497 L p F P
0 g
s
.953 .607 .24 r
.86658 .17265 m .86787 .17318 L .87219 .18362 L closepath p F P
0 g
s
.914 .516 .133 r
.86787 .17318 m .86658 .17265 L .86377 .16827 L p F P
0 g
s
.964 .633 .307 r
.86561 .17559 m .86658 .17265 L .87219 .18362 L closepath p F P
0 g
s
.987 .718 .415 r
.87208 .1915 m .87219 .18362 L .87349 .19333 L closepath p F P
0 g
s
.985 .715 .422 r
.87063 .1892 m .87219 .18362 L .87208 .1915 L closepath p F P
0 g
s
.982 .708 .423 r
.86911 .18635 m .87219 .18362 L .87063 .1892 L closepath p F P
0 g
s
.979 .698 .416 r
.86753 .18271 m .87219 .18362 L .86911 .18635 L closepath p F P
0 g
s
.973 .675 .388 r
.86561 .17559 m .87219 .18362 L .86753 .18271 L closepath p F P
0 g
s
.941 .856 .729 r
.87041 .22528 m .87043 .22711 L .86776 .2244 L p F P
0 g
s
.575 .939 .909 r
.85281 .15461 m .85368 .15475 L .85263 .1541 L closepath p F P
0 g
s
.955 .84 .69 r
.87219 .21735 m .87254 .21969 L .86975 .2168 L p F P
0 g
s
.956 .849 .696 r
.87004 .21915 m .86975 .2168 L .87254 .21969 L p F P
0 g
s
.941 .85 .723 r
.87035 .22335 m .87041 .22528 L .86772 .22245 L p F P
0 g
s
.941 .856 .729 r
.86776 .2244 m .86772 .22245 L .87041 .22528 L p F P
0 g
s
.954 .829 .682 r
.87163 .2147 m .87219 .21735 L .86933 .21419 L p F P
0 g
s
.955 .84 .69 r
.86975 .2168 m .86933 .21419 L .87219 .21735 L p F P
0 g
s
.986 .769 .528 r
.87349 .19333 m .87354 .1975 L .87155 .19493 L p F P
0 g
s
.986 .769 .528 r
.87155 .19493 m .87208 .1915 L .87349 .19333 L p F P
0 g
s
.942 .843 .718 r
.87023 .22132 m .87035 .22335 L .86763 .22038 L p F P
0 g
s
.941 .85 .723 r
.86772 .22245 m .86763 .22038 L .87035 .22335 L p F P
0 g
s
.979 .787 .574 r
.87354 .1975 m .87339 .20077 L .87094 .19763 L p F P
0 g
s
.979 .787 .574 r
.87094 .19763 m .87155 .19493 L .87354 .1975 L p F P
0 g
s
.575 .939 .909 r
.50962 .29023 m .52872 .29051 L .62299 .24537 L p F P
0 g
s
.575 .939 .909 r
.52872 .29051 m .50962 .29023 L .41928 .33509 L p F P
0 g
s
.944 .59 .3 r
.86658 .17265 m .86561 .17559 L .86239 .17242 L p F P
0 g
s
.944 .59 .3 r
.86239 .17242 m .86377 .16827 L .86658 .17265 L p F P
0 g
s
.575 .939 .909 r
.84448 .15658 m .84698 .15698 L .84768 .15662 L p F P
0 g
s
.575 .939 .909 r
.84535 .15625 m .84768 .15662 L .84839 .15626 L p F P
0 g
s
.575 .939 .909 r
.84768 .15662 m .84535 .15625 L .84448 .15658 L p F P
0 g
s
.941 .836 .711 r
.87004 .21915 m .87023 .22132 L .86748 .21819 L p F P
0 g
s
.942 .843 .718 r
.86763 .22038 m .86748 .21819 L .87023 .22132 L p F P
0 g
s
.973 .798 .606 r
.87339 .20077 m .87312 .20356 L .8703 .19994 L p F P
0 g
s
.973 .798 .606 r
.8703 .19994 m .87094 .19763 L .87339 .20077 L p F P
0 g
s
.575 .939 .909 r
.84623 .15592 m .84839 .15626 L .8491 .1559 L p F P
0 g
s
.575 .939 .909 r
.84839 .15626 m .84623 .15592 L .84535 .15625 L p F P
0 g
s
.967 .806 .63 r
.87312 .20356 m .87279 .20606 L .86963 .20201 L p F P
0 g
s
.967 .806 .63 r
.86963 .20201 m .8703 .19994 L .87312 .20356 L p F P
0 g
s
.944 .808 .679 r
.8699 .21049 m .87163 .2147 L .86864 .21113 L p F P
0 g
s
.954 .829 .682 r
.86933 .21419 m .86864 .21113 L .87163 .2147 L p F P
0 g
s
.575 .939 .909 r
.84712 .15559 m .8491 .1559 L .8498 .15554 L p F P
0 g
s
.575 .939 .909 r
.8491 .1559 m .84712 .15559 L .84623 .15592 L p F P
0 g
s
.932 .567 .295 r
.86377 .16827 m .86239 .17242 L .85972 .17005 L p F P
0 g
s
.932 .567 .295 r
.85972 .17005 m .86142 .16497 L .86377 .16827 L p F P
0 g
s
.961 .811 .65 r
.87279 .20606 m .87241 .20833 L .86895 .20391 L p F P
0 g
s
.961 .811 .65 r
.86895 .20391 m .86963 .20201 L .87279 .20606 L p F P
0 g
s
.575 .939 .909 r
.84804 .15526 m .8498 .15554 L .85051 .15518 L p F P
0 g
s
.575 .939 .909 r
.8498 .15554 m .84804 .15526 L .84712 .15559 L p F P
0 g
s
.955 .816 .666 r
.87241 .20833 m .87199 .21044 L .86825 .20567 L p F P
0 g
s
.955 .816 .666 r
.86825 .20567 m .86895 .20391 L .87241 .20833 L p F P
0 g
s
.977 .757 .538 r
.87208 .1915 m .87155 .19493 L .86948 .19167 L p F P
0 g
s
.977 .757 .538 r
.86948 .19167 m .87063 .1892 L .87208 .1915 L p F P
0 g
s
.575 .939 .909 r
.84898 .15494 m .85051 .15518 L .85122 .15482 L p F P
0 g
s
.575 .939 .909 r
.85051 .15518 m .84898 .15494 L .84804 .15526 L p F P
0 g
s
.95 .819 .68 r
.86755 .20733 m .86825 .20567 L .87199 .21044 L p F P
0 g
s
.941 .828 .704 r
.86975 .2168 m .87004 .21915 L .86724 .21583 L p F P
0 g
s
.941 .836 .711 r
.86748 .21819 m .86724 .21583 L .87004 .21915 L p F P
0 g
s
.575 .939 .909 r
.84997 .15462 m .85122 .15482 L .85193 .15446 L p F P
0 g
s
.575 .939 .909 r
.85122 .15482 m .84997 .15462 L .84898 .15494 L p F P
0 g
s
.922 .549 .292 r
.86142 .16497 m .85972 .17005 L .85733 .16809 L p F P
0 g
s
.922 .549 .292 r
.85733 .16809 m .8593 .16224 L .86142 .16497 L p F P
0 g
s
.575 .939 .909 r
.85193 .15446 m .85105 .15432 L .84997 .15462 L p F P
0 g
s
.928 .835 .733 r
.86772 .22245 m .86776 .2244 L .86503 .22116 L p F P
0 g
s
.913 .534 .288 r
.8593 .16224 m .85733 .16809 L .85513 .1664 L p F P
0 g
s
.913 .534 .288 r
.85513 .1664 m .85734 .15986 L .8593 .16224 L p F P
0 g
s
.94 .818 .696 r
.86933 .21419 m .86975 .2168 L .8669 .21324 L p F P
0 g
s
.941 .828 .704 r
.86724 .21583 m .8669 .21324 L .86975 .2168 L p F P
0 g
s
.904 .521 .285 r
.85734 .15986 m .85513 .1664 L .85306 .1649 L p F P
0 g
s
.904 .521 .285 r
.85306 .1649 m .85549 .15775 L .85734 .15986 L p F P
0 g
s
.968 .77 .582 r
.87155 .19493 m .87094 .19763 L .86841 .19363 L p F P
0 g
s
.968 .77 .582 r
.86841 .19363 m .86948 .19167 L .87155 .19493 L p F P
0 g
s
.928 .829 .727 r
.86763 .22038 m .86772 .22245 L .86497 .21907 L p F P
0 g
s
.928 .835 .733 r
.86503 .22116 m .86497 .21907 L .86772 .22245 L p F P
0 g
s
.896 .508 .283 r
.85549 .15775 m .85306 .1649 L .85108 .16354 L p F P
0 g
s
.896 .508 .283 r
.85108 .16354 m .85372 .15583 L .85549 .15775 L p F P
0 g
s
.786 .74 .81 r
.77391 .30901 m .85359 .20326 L .85653 .2085 L p F P
0 g
s
.782 .717 .791 r
.85359 .20326 m .77391 .30901 L .76233 .29391 L p F P
0 g
s
.97 .741 .536 r
.87063 .1892 m .86948 .19167 L .86734 .18764 L p F P
0 g
s
.97 .741 .536 r
.86734 .18764 m .86911 .18635 L .87063 .1892 L p F P
0 g
s
.889 .497 .28 r
.85372 .15583 m .85108 .16354 L .84919 .1623 L p F P
0 g
s
.575 .939 .909 r
.84747 .15422 m .84872 .15442 L .85016 .15418 L p F P
0 g
s
.936 .57 .282 r
.84807 .15452 m .84823 .15418 L .85211 .15406 L p F P
0 g
s
.936 .57 .282 r
.85211 .15406 m .85159 .15411 L .84807 .15452 L p F P
0 g
s
.928 .823 .72 r
.86748 .21819 m .86763 .22038 L .86485 .21686 L p F P
0 g
s
.928 .829 .727 r
.86497 .21907 m .86485 .21686 L .86763 .22038 L p F P
0 g
s
.939 .806 .687 r
.86864 .21113 m .86933 .21419 L .86639 .21032 L p F P
0 g
s
.94 .818 .696 r
.8669 .21324 m .86639 .21032 L .86933 .21419 L p F P
0 g
s
.7 .718 .863 r
.54815 .35807 m .64079 .3101 L .65709 .33502 L p F P
0 g
s
.693 .68 .833 r
.64079 .3101 m .54815 .35807 L .52904 .32731 L p F P
0 g
s
.575 .939 .909 r
.85105 .15432 m .85016 .15418 L .84872 .15442 L p F P
0 g
s
.575 .939 .909 r
.84872 .15442 m .84997 .15462 L .85105 .15432 L p F P
0 g
s
.959 .777 .613 r
.87094 .19763 m .8703 .19994 L .86738 .19533 L p F P
0 g
s
.959 .777 .613 r
.86738 .19533 m .86841 .19363 L .87094 .19763 L p F P
0 g
s
.575 .939 .909 r
.84997 .15462 m .84872 .15442 L .84745 .15469 L p F P
0 g
s
.575 .939 .909 r
.84745 .15469 m .84898 .15494 L .84997 .15462 L p F P
0 g
s
.963 .719 .521 r
.86911 .18635 m .86734 .18764 L .8651 .18249 L p F P
0 g
s
.963 .719 .521 r
.8651 .18249 m .86753 .18271 L .86911 .18635 L p F P
0 g
s
.928 .815 .713 r
.86724 .21583 m .86748 .21819 L .86466 .21449 L p F P
0 g
s
.928 .823 .72 r
.86485 .21686 m .86466 .21449 L .86748 .21819 L p F P
0 g
s
.934 .569 .292 r
.85159 .15411 m .85109 .15428 L .84792 .15493 L p F P
0 g
s
.934 .569 .292 r
.84792 .15493 m .84807 .15452 L .85159 .15411 L p F P
0 g
s
.955 .674 .466 r
.86239 .17242 m .86561 .17559 L .86753 .18271 L p F P
0 g
s
.952 .782 .635 r
.8703 .19994 m .86963 .20201 L .86637 .19686 L p F P
0 g
s
.952 .782 .635 r
.86637 .19686 m .86738 .19533 L .8703 .19994 L p F P
0 g
s
.575 .939 .909 r
.84898 .15494 m .84745 .15469 L .84627 .15497 L p F P
0 g
s
.575 .939 .909 r
.84627 .15497 m .84804 .15526 L .84898 .15494 L p F P
0 g
s
.575 .939 .909 r
.84804 .15526 m .84627 .15497 L .84514 .15527 L p F P
0 g
s
.575 .939 .909 r
.84514 .15527 m .84712 .15559 L .84804 .15526 L p F P
0 g
s
.925 .783 .685 r
.86645 .20573 m .86864 .21113 L .86556 .20678 L p F P
0 g
s
.939 .806 .687 r
.86639 .21032 m .86556 .20678 L .86864 .21113 L p F P
0 g
s
.958 .749 .578 r
.86948 .19167 m .86841 .19363 L .86579 .1887 L p F P
0 g
s
.958 .749 .578 r
.86579 .1887 m .86734 .18764 L .86948 .19167 L p F P
0 g
s
.664 .643 .818 r
.41928 .33509 m .50962 .29023 L .52904 .32731 L p F P
0 g
s
.575 .939 .909 r
.84712 .15559 m .84514 .15527 L .84405 .15557 L p F P
0 g
s
.575 .939 .909 r
.84405 .15557 m .84623 .15592 L .84712 .15559 L p F P
0 g
s
.944 .785 .653 r
.86963 .20201 m .86895 .20391 L .86537 .19827 L p F P
0 g
s
.944 .785 .653 r
.86537 .19827 m .86637 .19686 L .86963 .20201 L p F P
0 g
s
.575 .939 .909 r
.84623 .15592 m .84405 .15557 L .843 .15587 L p F P
0 g
s
.575 .939 .909 r
.843 .15587 m .84535 .15625 L .84623 .15592 L p F P
0 g
s
.928 .807 .705 r
.8669 .21324 m .86724 .21583 L .86438 .21192 L p F P
0 g
s
.928 .815 .713 r
.86466 .21449 m .86438 .21192 L .86724 .21583 L p F P
0 g
s
.955 .674 .466 r
.86753 .18271 m .8651 .18249 L .86239 .17242 L p F P
0 g
s
.575 .939 .909 r
.84535 .15625 m .843 .15587 L .84196 .15618 L p F P
0 g
s
.575 .939 .909 r
.84196 .15618 m .84448 .15658 L .84535 .15625 L p F P
0 g
s
.575 .939 .909 r
.84448 .15658 m .84196 .15618 L .73495 .20089 L p F P
0 g
s
.932 .569 .304 r
.85109 .15428 m .85059 .15461 L .84777 .15543 L p F P
0 g
s
.932 .569 .304 r
.84777 .15543 m .84792 .15493 L .85109 .15428 L p F P
0 g
s
.916 .815 .732 r
.86497 .21907 m .86503 .22116 L .86225 .21742 L p F P
0 g
s
.938 .787 .668 r
.86895 .20391 m .86825 .20567 L .86438 .19959 L p F P
0 g
s
.938 .787 .668 r
.86438 .19959 m .86537 .19827 L .86895 .20391 L p F P
0 g
s
.928 .797 .695 r
.86639 .21032 m .8669 .21324 L .86398 .20906 L p F P
0 g
s
.928 .807 .705 r
.86438 .21192 m .86398 .20906 L .8669 .21324 L p F P
0 g
s
.925 .783 .685 r
.86556 .20678 m .86435 .20366 L p .86645 .20573 L F P
0 g
s
.925 .783 .685 r
.86435 .20366 m .8629 .19994 L .86438 .20236 L p F P
0 g
s
.925 .783 .685 r
.86438 .20236 m .86645 .20573 L p .86435 .20366 L F P
0 g
s
.931 .789 .68 r
.86825 .20567 m .86755 .20733 L .86438 .20236 L p F P
0 g
s
.931 .789 .68 r
.86438 .20236 m .86341 .20083 L p .8644 .20182 L F P
0 g
s
.931 .789 .68 r
.8644 .20182 m .86825 .20567 L .86438 .20236 L F
.86341 .20083 m .86438 .19959 L .86825 .20567 L p F P
0 g
s
.917 .809 .726 r
.86485 .21686 m .86497 .21907 L .86217 .2152 L p F P
0 g
s
.916 .815 .732 r
.86225 .21742 m .86217 .2152 L .86497 .21907 L p F P
0 g
s
.948 .753 .606 r
.86841 .19363 m .86738 .19533 L .86435 .18963 L p F P
0 g
s
.948 .753 .606 r
.86435 .18963 m .86579 .1887 L .86841 .19363 L p F P
0 g
s
.575 .939 .909 r
.84872 .15442 m .84747 .15422 L .84591 .15444 L p F P
0 g
s
.575 .939 .909 r
.84591 .15444 m .84745 .15469 L .84872 .15442 L p F P
0 g
s
.95 .723 .559 r
.86734 .18764 m .86579 .1887 L .86303 .18239 L p F P
0 g
s
.95 .723 .559 r
.86303 .18239 m .8651 .18249 L .86734 .18764 L p F P
0 g
s
.929 .569 .319 r
.85059 .15461 m .85012 .15513 L .84763 .15604 L p F P
0 g
s
.929 .569 .319 r
.84763 .15604 m .84777 .15543 L .85059 .15461 L p F P
0 g
s
.941 .67 .495 r
.85972 .17005 m .86239 .17242 L .8651 .18249 L p F P
0 g
s
.917 .802 .718 r
.86466 .21449 m .86485 .21686 L .86202 .21282 L p F P
0 g
s
.917 .809 .726 r
.86217 .2152 m .86202 .21282 L .86485 .21686 L p F P
0 g
s
.927 .784 .683 r
.86556 .20678 m .86639 .21032 L .86338 .20577 L p F P
0 g
s
.928 .797 .695 r
.86398 .20906 m .86338 .20577 L .86639 .21032 L p F P
0 g
s
.575 .939 .909 r
.84928 .15403 m .84839 .15389 L .84621 .15401 L p F P
0 g
s
.575 .939 .909 r
.84621 .15401 m .84747 .15422 L .84928 .15403 L p F P
0 g
s
.939 .755 .627 r
.86738 .19533 m .86637 .19686 L .86297 .19049 L p F P
0 g
s
.939 .755 .627 r
.86297 .19049 m .86435 .18963 L .86738 .19533 L p F P
0 g
s
.575 .939 .909 r
.84745 .15469 m .84591 .15444 L .84449 .15469 L p F P
0 g
s
.575 .939 .909 r
.84449 .15469 m .84627 .15497 L .84745 .15469 L p F P
0 g
s
.917 .795 .71 r
.86438 .21192 m .86466 .21449 L .86179 .21025 L p F P
0 g
s
.917 .802 .718 r
.86202 .21282 m .86179 .21025 L .86466 .21449 L p F P
0 g
s
.941 .67 .495 r
.8651 .18249 m .86303 .18239 L .85972 .17005 L p F P
0 g
s
.925 .571 .338 r
.85012 .15513 m .84967 .15598 L .84752 .15684 L p F P
0 g
s
.925 .571 .338 r
.84752 .15684 m .84763 .15604 L .85012 .15513 L p F P
0 g
s
.575 .939 .909 r
.84627 .15497 m .84449 .15469 L .84315 .15495 L p F P
0 g
s
.575 .939 .909 r
.84315 .15495 m .84514 .15527 L .84627 .15497 L p F P
0 g
s
.905 .755 .685 r
.8629 .19994 m .86556 .20678 L .8624 .20168 L p F P
0 g
s
.927 .784 .683 r
.86338 .20577 m .8624 .20168 L .86556 .20678 L p F P
0 g
s
.931 .756 .643 r
.86637 .19686 m .86537 .19827 L .86165 .19129 L p F P
0 g
s
.931 .756 .643 r
.86165 .19129 m .86297 .19049 L .86637 .19686 L p F P
0 g
s
.918 .786 .7 r
.86398 .20906 m .86438 .21192 L .86146 .20743 L p F P
0 g
s
.917 .795 .71 r
.86179 .21025 m .86146 .20743 L .86438 .21192 L p F P
0 g
s
.939 .724 .585 r
.86579 .1887 m .86435 .18963 L .86116 .18235 L p F P
0 g
s
.939 .724 .585 r
.86116 .18235 m .86303 .18239 L .86579 .1887 L p F P
0 g
s
.93 .665 .515 r
.85733 .16809 m .85972 .17005 L .86303 .18239 L p F P
0 g
s
.575 .939 .909 r
.84514 .15527 m .84315 .15495 L .84187 .15522 L p F P
0 g
s
.575 .939 .909 r
.84187 .15522 m .84405 .15557 L .84514 .15527 L p F P
0 g
s
.905 .797 .73 r
.86217 .2152 m .86225 .21742 L .85942 .21321 L p F P
0 g
s
.903 .527 .307 r
.84839 .15389 m .84823 .15418 L .84613 .15432 L p F P
0 g
s
.903 .527 .307 r
.84613 .15432 m .84621 .15401 L .84839 .15389 L p F P
0 g
s
.575 .939 .909 r
.84747 .15422 m .84621 .15401 L .84437 .15419 L p F P
0 g
s
.575 .939 .909 r
.84437 .15419 m .84591 .15444 L .84747 .15422 L p F P
0 g
s
.924 .757 .657 r
.86537 .19827 m .86438 .19959 L .86037 .19205 L p F P
0 g
s
.924 .757 .657 r
.86037 .19205 m .86165 .19129 L .86537 .19827 L p F P
0 g
s
.917 .775 .688 r
.86338 .20577 m .86398 .20906 L .86099 .20425 L p F P
0 g
s
.918 .786 .7 r
.86146 .20743 m .86099 .20425 L .86398 .20906 L p F P
0 g
s
.575 .939 .909 r
.84405 .15557 m .84187 .15522 L .84064 .1555 L p F P
0 g
s
.575 .939 .909 r
.84064 .1555 m .843 .15587 L .84405 .15557 L p F P
0 g
s
.903 .531 .318 r
.84823 .15418 m .84807 .15452 L .84606 .15466 L p F P
0 g
s
.903 .531 .318 r
.84606 .15466 m .84613 .15432 L .84823 .15418 L p F P
0 g
s
.906 .791 .723 r
.86202 .21282 m .86217 .2152 L .8595 .21113 L p F P
0 g
s
.905 .797 .73 r
.85942 .21321 m .8595 .21113 L .86217 .2152 L p F P
0 g
s
.921 .575 .363 r
.84967 .15598 m .84927 .15741 L .84743 .15799 L p F P
0 g
s
.921 .575 .363 r
.84743 .15799 m .84752 .15684 L .84967 .15598 L p F P
0 g
s
.575 .939 .909 r
.843 .15587 m .84064 .1555 L .83944 .15578 L p F P
0 g
s
.575 .939 .909 r
.83944 .15578 m .84196 .15618 L .843 .15587 L p F P
0 g
s
.902 .535 .33 r
.84807 .15452 m .84792 .15493 L .84598 .15506 L p F P
0 g
s
.902 .535 .33 r
.84598 .15506 m .84606 .15466 L .84807 .15452 L p F P
0 g
s
.929 .724 .604 r
.86435 .18963 m .86297 .19049 L .85941 .18234 L p F P
0 g
s
.929 .724 .604 r
.85941 .18234 m .86116 .18235 L .86435 .18963 L p F P
0 g
s
.93 .665 .515 r
.86303 .18239 m .86116 .18235 L .85733 .16809 L p F P
0 g
s
.906 .785 .716 r
.86179 .21025 m .86202 .21282 L .85954 .20893 L p F P
0 g
s
.906 .791 .723 r
.8595 .21113 m .85954 .20893 L .86202 .21282 L p F P
0 g
s
.877 .719 .683 r
.85916 .19573 m .85895 .1951 L p .85922 .193 L F P
0 g
s
.877 .719 .683 r
.85895 .1951 m .85539 .18447 L .85917 .19288 L p F P
0 g
s
.877 .719 .683 r
.85917 .19288 m .85922 .193 L p .85895 .1951 L F P
0 g
s
.917 .757 .668 r
.86438 .19959 m .86341 .20083 L .85917 .19288 L p F P
0 g
s
.917 .757 .668 r
.85917 .19288 m .85911 .19277 L p .85917 .19285 L F P
0 g
s
.917 .757 .668 r
.85917 .19285 m .86438 .19959 L .85917 .19288 L F
.85911 .19277 m .86037 .19205 L .86438 .19959 L p F P
0 g
s
.92 .661 .53 r
.85513 .1664 m .85733 .16809 L .86116 .18235 L p F P
0 g
s
.575 .939 .909 r
.84196 .15618 m .83944 .15578 L .72391 .19977 L p F P
0 g
s
.575 .939 .909 r
.72391 .19977 m .73495 .20089 L .84196 .15618 L p F P
0 g
s
.916 .761 .674 r
.8624 .20168 m .86338 .20577 L .86029 .20052 L p F P
0 g
s
.917 .775 .688 r
.86099 .20425 m .86029 .20052 L .86338 .20577 L p F P
0 g
s
.736 .748 .862 r
.65709 .33502 m .75043 .27594 L .76233 .29391 L p F P
0 g
s
.729 .712 .835 r
.75043 .27594 m .65709 .33502 L .64079 .3101 L p F P
0 g
s
.575 .939 .909 r
.84591 .15444 m .84437 .15419 L .84271 .1544 L p F P
0 g
s
.575 .939 .909 r
.84271 .1544 m .84449 .15469 L .84591 .15444 L p F P
0 g
s
.901 .539 .344 r
.84792 .15493 m .84777 .15543 L .84592 .15551 L p F P
0 g
s
.901 .539 .344 r
.84592 .15551 m .84598 .15506 L .84792 .15493 L p F P
0 g
s
.906 .778 .709 r
.86146 .20743 m .86179 .21025 L .85952 .20656 L p F P
0 g
s
.906 .785 .716 r
.85954 .20893 m .85952 .20656 L .86179 .21025 L p F P
0 g
s
.575 .939 .909 r
.73495 .20089 m .72391 .19977 L .62299 .24537 L p F P
0 g
s
.901 .545 .358 r
.84777 .15543 m .84763 .15604 L .84586 .15606 L p F P
0 g
s
.901 .545 .358 r
.84586 .15606 m .84592 .15551 L .84777 .15543 L p F P
0 g
s
.921 .723 .619 r
.86297 .19049 m .86165 .19129 L .85775 .18237 L p F P
0 g
s
.921 .723 .619 r
.85775 .18237 m .85941 .18234 L .86297 .19049 L p F P
0 g
s
.905 .755 .685 r
.8624 .20168 m .85922 .193 L .8629 .19994 L p F P
0 g
s
.919 .593 .408 r
.84927 .15741 m .84919 .1623 L .84753 .16125 L p F P
0 g
s
.919 .593 .408 r
.84753 .16125 m .84743 .15799 L .84927 .15741 L p F P
0 g
s
.905 .769 .7 r
.86099 .20425 m .86146 .20743 L .85941 .20398 L p F P
0 g
s
.906 .778 .709 r
.85952 .20656 m .85941 .20398 L .86146 .20743 L p F P
0 g
s
.92 .661 .53 r
.86116 .18235 m .85941 .18234 L .85513 .1664 L p F P
0 g
s
.911 .657 .541 r
.85306 .1649 m .85513 .1664 L .85941 .18234 L p F P
0 g
s
.877 .719 .683 r
.85922 .193 m .8624 .20168 L .85916 .19573 L p F P
0 g
s
.916 .761 .674 r
.86029 .20052 m .85916 .19573 L .8624 .20168 L p F P
0 g
s
.895 .534 .35 r
.84621 .15401 m .84613 .15432 L .84433 .15447 L p F P
0 g
s
.895 .534 .35 r
.84433 .15447 m .84437 .15419 L .84621 .15401 L p F P
0 g
s
.575 .939 .909 r
.84449 .15469 m .84271 .1544 L .84115 .15463 L p F P
0 g
s
.575 .939 .909 r
.84115 .15463 m .84315 .15495 L .84449 .15469 L p F P
0 g
s
.9 .551 .375 r
.84763 .15604 m .84752 .15684 L .84581 .15675 L p F P
0 g
s
.9 .551 .375 r
.84581 .15675 m .84586 .15606 L .84763 .15604 L p F P
0 g
s
.896 .779 .724 r
.8595 .21113 m .85942 .21321 L .85653 .2085 L p F P
0 g
s
.895 .537 .358 r
.84613 .15432 m .84606 .15466 L .8443 .15478 L p F P
0 g
s
.895 .537 .358 r
.8443 .15478 m .84433 .15447 L .84613 .15432 L p F P
0 g
s
.898 .774 .717 r
.85954 .20893 m .8595 .21113 L .85679 .20662 L p F P
0 g
s
.896 .779 .724 r
.85653 .2085 m .85679 .20662 L .8595 .21113 L p F P
0 g
s
.894 .541 .367 r
.84606 .15466 m .84598 .15506 L .84427 .15512 L p F P
0 g
s
.894 .541 .367 r
.84427 .15512 m .8443 .15478 L .84606 .15466 L p F P
0 g
s
.904 .759 .691 r
.86029 .20052 m .86099 .20425 L .8592 .20111 L p F P
0 g
s
.905 .769 .7 r
.85941 .20398 m .8592 .20111 L .86099 .20425 L p F P
0 g
s
.913 .722 .631 r
.86165 .19129 m .86037 .19205 L .85615 .18241 L p F P
0 g
s
.913 .722 .631 r
.85615 .18241 m .85775 .18237 L .86165 .19129 L p F P
0 g
s
.899 .769 .71 r
.85952 .20656 m .85954 .20893 L .85702 .20463 L p F P
0 g
s
.898 .774 .717 r
.85679 .20662 m .85702 .20463 L .85954 .20893 L p F P
0 g
s
.899 .56 .395 r
.84752 .15684 m .84743 .15799 L .84579 .1577 L p F P
0 g
s
.899 .56 .395 r
.84579 .1577 m .84581 .15675 L .84752 .15684 L p F P
0 g
s
.894 .544 .377 r
.84598 .15506 m .84592 .15551 L .84424 .15552 L p F P
0 g
s
.894 .544 .377 r
.84424 .15552 m .84427 .15512 L .84598 .15506 L p F P
0 g
s
.911 .657 .541 r
.85941 .18234 m .85775 .18237 L .85306 .1649 L p F P
0 g
s
.903 .653 .551 r
.85108 .16354 m .85306 .1649 L .85775 .18237 L p F P
0 g
s
.575 .939 .909 r
.84315 .15495 m .84115 .15463 L .83968 .15487 L p F P
0 g
s
.575 .939 .909 r
.83968 .15487 m .84187 .15522 L .84315 .15495 L p F P
0 g
s
.9 .763 .702 r
.85941 .20398 m .85952 .20656 L .8572 .20251 L p F P
0 g
s
.899 .769 .71 r
.85702 .20463 m .8572 .20251 L .85952 .20656 L p F P
0 g
s
.893 .549 .387 r
.84592 .15551 m .84586 .15606 L .84422 .15598 L p F P
0 g
s
.893 .549 .387 r
.84422 .15598 m .84424 .15552 L .84592 .15551 L p F P
0 g
s
.898 .744 .682 r
.85916 .19573 m .86029 .20052 L .85881 .19778 L p F P
0 g
s
.904 .759 .691 r
.8592 .20111 m .85881 .19778 L .86029 .20052 L p F P
0 g
s
.906 .721 .641 r
.86037 .19205 m .85911 .19277 L .8546 .18247 L p F P
0 g
s
.906 .721 .641 r
.8546 .18247 m .85615 .18241 L .86037 .19205 L p F P
0 g
s
.901 .756 .693 r
.8592 .20111 m .85941 .20398 L .85733 .20022 L p F P
0 g
s
.9 .763 .702 r
.8572 .20251 m .85733 .20022 L .85941 .20398 L p F P
0 g
s
.889 .542 .384 r
.84437 .15419 m .84433 .15447 L .84269 .15464 L p F P
0 g
s
.889 .542 .384 r
.84269 .15464 m .84271 .1544 L .84437 .15419 L p F P
0 g
s
.9 .578 .429 r
.84743 .15799 m .84753 .16125 L .84591 .16027 L p F P
0 g
s
.9 .578 .429 r
.84591 .16027 m .84579 .1577 L .84743 .15799 L p F P
0 g
s
.575 .939 .909 r
.84187 .15522 m .83968 .15487 L .83827 .15512 L p F P
0 g
s
.575 .939 .909 r
.83827 .15512 m .84064 .1555 L .84187 .15522 L p F P
0 g
s
.893 .554 .399 r
.84586 .15606 m .84581 .15675 L .84421 .15655 L p F P
0 g
s
.893 .554 .399 r
.84421 .15655 m .84422 .15598 L .84586 .15606 L p F P
0 g
s
.903 .653 .551 r
.85775 .18237 m .85615 .18241 L .85108 .16354 L p F P
0 g
s
.896 .65 .559 r
.84919 .1623 m .85108 .16354 L .85615 .18241 L p F P
0 g
s
.889 .545 .39 r
.84433 .15447 m .8443 .15478 L .84268 .15489 L p F P
0 g
s
.889 .545 .39 r
.84268 .15489 m .84269 .15464 L .84433 .15447 L p F P
0 g
s
.901 .748 .683 r
.85881 .19778 m .8592 .20111 L .85738 .19771 L p F P
0 g
s
.901 .756 .693 r
.85733 .20022 m .85738 .19771 L .8592 .20111 L p F P
0 g
s
.888 .547 .396 r
.8443 .15478 m .84427 .15512 L .84267 .15518 L p F P
0 g
s
.888 .547 .396 r
.84267 .15518 m .84268 .15489 L .8443 .15478 L p F P
0 g
s
.892 .561 .414 r
.84581 .15675 m .84579 .1577 L .84422 .15733 L p F P
0 g
s
.892 .561 .414 r
.84422 .15733 m .84421 .15655 L .84581 .15675 L p F P
0 g
s
.954 .741 .576 r
.8581 .1936 m .85539 .18447 L .85916 .19573 L closepath p F P
0 g
s
.898 .744 .682 r
.85881 .19778 m .8581 .1936 L .85916 .19573 L p F P
0 g
s
.888 .55 .403 r
.84427 .15512 m .84424 .15552 L .84267 .1555 L p F P
0 g
s
.888 .55 .403 r
.84267 .1555 m .84267 .15518 L .84427 .15512 L p F P
0 g
s
.575 .939 .909 r
.84064 .1555 m .83827 .15512 L .8369 .15538 L p F P
0 g
s
.575 .939 .909 r
.8369 .15538 m .83944 .15578 L .84064 .1555 L p F P
0 g
s
.898 .736 .672 r
.8581 .1936 m .85881 .19778 L .85731 .19485 L p F P
0 g
s
.901 .748 .683 r
.85738 .19771 m .85731 .19485 L .85881 .19778 L p F P
0 g
s
.887 .553 .41 r
.84424 .15552 m .84422 .15598 L .84267 .15587 L p F P
0 g
s
.887 .553 .41 r
.84267 .15587 m .84267 .1555 L .84424 .15552 L p F P
0 g
s
.888 .761 .715 r
.85679 .20662 m .85653 .2085 L .85359 .20326 L p F P
0 g
s
.896 .65 .559 r
.85615 .18241 m .8546 .18247 L .84919 .1623 L p F P
0 g
s
.897 .613 .499 r
.84753 .16125 m .84919 .1623 L .85031 .16894 L p F P
0 g
s
.892 .574 .439 r
.84579 .1577 m .84591 .16027 L .84434 .15935 L p F P
0 g
s
.892 .574 .439 r
.84434 .15935 m .84422 .15733 L .84579 .1577 L p F P
0 g
s
.89 .757 .708 r
.85702 .20463 m .85679 .20662 L .85403 .20161 L p F P
0 g
s
.888 .761 .715 r
.85359 .20326 m .85403 .20161 L .85679 .20662 L p F P
0 g
s
.892 .753 .701 r
.8572 .20251 m .85702 .20463 L .85445 .19988 L p F P
0 g
s
.89 .757 .708 r
.85403 .20161 m .85445 .19988 L .85702 .20463 L p F P
0 g
s
.887 .557 .419 r
.84422 .15598 m .84421 .15655 L .84267 .15632 L p F P
0 g
s
.887 .557 .419 r
.84267 .15632 m .84267 .15587 L .84422 .15598 L p F P
0 g
s
.94 .737 .603 r
.85702 .19136 m .85539 .18447 L .8581 .1936 L closepath p F P
0 g
s
.898 .736 .672 r
.85731 .19485 m .85702 .19136 L .8581 .1936 L p F P
0 g
s
.894 .749 .693 r
.85733 .20022 m .8572 .20251 L .85485 .19806 L p F P
0 g
s
.892 .753 .701 r
.85445 .19988 m .85485 .19806 L .8572 .20251 L p F P
0 g
s
.575 .939 .909 r
.83944 .15578 m .8369 .15538 L .71265 .19863 L p F P
0 g
s
.575 .939 .909 r
.71265 .19863 m .72391 .19977 L .83944 .15578 L p F P
0 g
s
.884 .549 .411 r
.84271 .1544 m .84269 .15464 L .84115 .15481 L p F P
0 g
s
.884 .549 .411 r
.84115 .15481 m .84115 .15463 L .84271 .1544 L p F P
0 g
s
.782 .717 .791 r
.76233 .29391 m .85059 .19741 L .85359 .20326 L p F P
0 g
s
.778 .693 .769 r
.85059 .19741 m .76233 .29391 L .75043 .27594 L p F P
0 g
s
.896 .743 .684 r
.85738 .19771 m .85733 .20022 L .85521 .19612 L p F P
0 g
s
.894 .749 .693 r
.85485 .19806 m .85521 .19612 L .85733 .20022 L p F P
0 g
s
.883 .551 .415 r
.84269 .15464 m .84268 .15489 L .84115 .15501 L p F P
0 g
s
.883 .551 .415 r
.84115 .15501 m .84115 .15481 L .84269 .15464 L p F P
0 g
s
.886 .562 .429 r
.84421 .15655 m .84422 .15733 L .84269 .15693 L p F P
0 g
s
.886 .562 .429 r
.84269 .15693 m .84267 .15632 L .84421 .15655 L p F P
0 g
s
.898 .736 .673 r
.85731 .19485 m .85738 .19771 L .85553 .19402 L p F P
0 g
s
.896 .743 .684 r
.85521 .19612 m .85553 .19402 L .85738 .19771 L p F P
0 g
s
.897 .613 .499 r
.85031 .16894 m .84807 .16515 L .84753 .16125 L p F P
0 g
s
.893 .6 .484 r
.84591 .16027 m .84753 .16125 L .84807 .16515 L p F P
0 g
s
.883 .553 .419 r
.84268 .15489 m .84267 .15518 L .84116 .15522 L p F P
0 g
s
.883 .553 .419 r
.84116 .15522 m .84115 .15501 L .84268 .15489 L p F P
0 g
s
.898 .727 .661 r
.85702 .19136 m .85731 .19485 L .85579 .19169 L p F P
0 g
s
.898 .736 .673 r
.85553 .19402 m .85579 .19169 L .85731 .19485 L p F P
0 g
s
.882 .554 .424 r
.84267 .15518 m .84267 .1555 L .84116 .15547 L p F P
0 g
s
.882 .554 .424 r
.84116 .15547 m .84116 .15522 L .84267 .15518 L p F P
0 g
s
.923 .73 .625 r
.85593 .18898 m .85539 .18447 L .85702 .19136 L closepath p F P
0 g
s
.898 .727 .661 r
.85579 .19169 m .85593 .18898 L .85702 .19136 L p F P
0 g
s
.886 .572 .448 r
.84422 .15733 m .84434 .15935 L .8428 .15848 L p F P
0 g
s
.886 .572 .448 r
.8428 .15848 m .84269 .15693 L .84422 .15733 L p F P
0 g
s
.882 .557 .429 r
.84267 .1555 m .84267 .15587 L .84117 .15574 L p F P
0 g
s
.882 .557 .429 r
.84117 .15574 m .84116 .15547 L .84267 .1555 L p F P
0 g
s
.882 .559 .435 r
.84267 .15587 m .84267 .15632 L .84118 .15608 L p F P
0 g
s
.882 .559 .435 r
.84118 .15608 m .84117 .15574 L .84267 .15587 L p F P
0 g
s
.893 .6 .484 r
.84807 .16515 m .84628 .1632 L .84591 .16027 L p F P
0 g
s
.888 .592 .48 r
.84434 .15935 m .84591 .16027 L .84628 .1632 L p F P
0 g
s
.907 .72 .638 r
.85483 .18645 m .85539 .18447 L .85593 .18898 L closepath p F P
0 g
s
.897 .718 .651 r
.85593 .18898 m .85579 .19169 L .85425 .18828 L p F P
0 g
s
.897 .718 .651 r
.85425 .18828 m .85483 .18645 L .85593 .18898 L p F P
0 g
s
.881 .562 .442 r
.84267 .15632 m .84269 .15693 L .8412 .15653 L p F P
0 g
s
.881 .562 .442 r
.8412 .15653 m .84118 .15608 L .84267 .15632 L p F P
0 g
s
.898 .709 .638 r
.85371 .18373 m .85539 .18447 L .85483 .18645 L closepath p F P
0 g
s
.901 .699 .621 r
.85256 .18077 m .85539 .18447 L .85371 .18373 L closepath p F P
0 g
s
.916 .692 .584 r
.85139 .17748 m .85539 .18447 L .85256 .18077 L closepath p F P
0 g
s
.938 .685 .528 r
.85017 .1737 m .85539 .18447 L .85139 .17748 L closepath p F P
0 g
s
.589 .563 .792 r
.85539 .18447 m .85017 .1737 L .8499 .17277 L p F P
0 g
s
.589 .563 .792 r
.8499 .17277 m .85472 .18277 L .85539 .18447 L p F P
0 g
s
.879 .555 .434 r
.84115 .15463 m .84115 .15481 L .83968 .15499 L p F P
0 g
s
.879 .555 .434 r
.83968 .15499 m .83968 .15487 L .84115 .15463 L p F P
0 g
s
.895 .724 .663 r
.85579 .19169 m .85553 .19402 L .85366 .18999 L p F P
0 g
s
.895 .724 .663 r
.85366 .18999 m .85425 .18828 L .85579 .19169 L p F P
0 g
s
.878 .556 .436 r
.84115 .15481 m .84115 .15501 L .83969 .15513 L p F P
0 g
s
.878 .556 .436 r
.83969 .15513 m .83968 .15499 L .84115 .15481 L p F P
0 g
s
.866 .629 .579 r
.84807 .16515 m .85031 .16894 L .85112 .17212 L p F P
0 g
s
.892 .729 .673 r
.85553 .19402 m .85521 .19612 L .85306 .19161 L p F P
0 g
s
.892 .729 .673 r
.85306 .19161 m .85366 .18999 L .85553 .19402 L p F P
0 g
s
.668 .595 .764 r
.85472 .18277 m .8499 .17277 L .84962 .17179 L p F P
0 g
s
.668 .595 .764 r
.84962 .17179 m .85403 .18098 L .85472 .18277 L p F P
0 g
s
.878 .557 .439 r
.84115 .15501 m .84116 .15522 L .83969 .15527 L p F P
0 g
s
.878 .557 .439 r
.83969 .15527 m .83969 .15513 L .84115 .15501 L p F P
0 g
s
.881 .569 .455 r
.84269 .15693 m .8428 .15848 L .84129 .15765 L p F P
0 g
s
.881 .569 .455 r
.84129 .15765 m .8412 .15653 L .84269 .15693 L p F P
0 g
s
.89 .733 .682 r
.85521 .19612 m .85485 .19806 L .85245 .19315 L p F P
0 g
s
.89 .733 .682 r
.85245 .19315 m .85306 .19161 L .85521 .19612 L p F P
0 g
s
.866 .629 .579 r
.85112 .17212 m .84842 .16694 L .84807 .16515 L p F P
0 g
s
.887 .617 .524 r
.84628 .1632 m .84807 .16515 L .84842 .16694 L p F P
0 g
s
.878 .558 .442 r
.84116 .15522 m .84116 .15547 L .8397 .15543 L p F P
0 g
s
.878 .558 .442 r
.8397 .15543 m .83969 .15527 L .84116 .15522 L p F P
0 g
s
.888 .592 .48 r
.84628 .1632 m .8446 .16158 L .84434 .15935 L p F P
0 g
s
.883 .586 .478 r
.8428 .15848 m .84434 .15935 L .8446 .16158 L p F P
0 g
s
.887 .737 .69 r
.85485 .19806 m .85445 .19988 L .85183 .19462 L p F P
0 g
s
.887 .737 .69 r
.85183 .19462 m .85245 .19315 L .85485 .19806 L p F P
0 g
s
.728 .615 .732 r
.85403 .18098 m .84962 .17179 L .84933 .17075 L p F P
0 g
s
.728 .615 .732 r
.84933 .17075 m .85333 .17906 L .85403 .18098 L p F P
0 g
s
.895 .708 .642 r
.85483 .18645 m .85425 .18828 L .85267 .18455 L p F P
0 g
s
.895 .708 .642 r
.85267 .18455 m .85371 .18373 L .85483 .18645 L p F P
0 g
s
.884 .74 .697 r
.85445 .19988 m .85403 .20161 L .85121 .19604 L p F P
0 g
s
.884 .74 .697 r
.85121 .19604 m .85183 .19462 L .85445 .19988 L p F P
0 g
s
.877 .56 .445 r
.84116 .15547 m .84117 .15574 L .83971 .15562 L p F P
0 g
s
.877 .56 .445 r
.83971 .15562 m .8397 .15543 L .84116 .15547 L p F P
0 g
s
.841 .634 .622 r
.84842 .16694 m .85112 .17212 L .85188 .17471 L p F P
0 g
s
.882 .743 .704 r
.85403 .20161 m .85359 .20326 L .85059 .19741 L p F P
0 g
s
.882 .743 .704 r
.85059 .19741 m .85121 .19604 L .85403 .20161 L p F P
0 g
s
.693 .68 .833 r
.52904 .32731 m .62412 .28048 L .64079 .3101 L p F P
0 g
s
.686 .639 .797 r
.62412 .28048 m .52904 .32731 L .50962 .29023 L p F P
0 g
s
.775 .628 .697 r
.85333 .17906 m .84933 .17075 L .84904 .16962 L p F P
0 g
s
.775 .628 .697 r
.84904 .16962 m .85262 .17699 L .85333 .17906 L p F P
0 g
s
.877 .561 .448 r
.84117 .15574 m .84118 .15608 L .83972 .15584 L p F P
0 g
s
.877 .561 .448 r
.83972 .15584 m .83971 .15562 L .84117 .15574 L p F P
0 g
s
.812 .634 .66 r
.85262 .17699 m .84904 .16962 L .84874 .16837 L p F P
0 g
s
.812 .634 .66 r
.84874 .16837 m .85188 .17471 L .85262 .17699 L p F P
0 g
s
.841 .634 .622 r
.85188 .17471 m .84874 .16837 L .84842 .16694 L p F P
0 g
s
.884 .626 .543 r
.84651 .16451 m .84842 .16694 L .84874 .16837 L p F P
0 g
s
.887 .617 .524 r
.84842 .16694 m .84651 .16451 L .84628 .1632 L p F P
0 g
s
.885 .606 .51 r
.8446 .16158 m .84628 .1632 L .84651 .16451 L p F P
0 g
s
.876 .563 .453 r
.84118 .15608 m .8412 .15653 L .83974 .15613 L p F P
0 g
s
.876 .563 .453 r
.83974 .15613 m .83972 .15584 L .84118 .15608 L p F P
0 g
s
.892 .711 .651 r
.85425 .18828 m .85366 .18999 L .85174 .18554 L p F P
0 g
s
.892 .711 .651 r
.85174 .18554 m .85267 .18455 L .85425 .18828 L p F P
0 g
s
.891 .696 .632 r
.85371 .18373 m .85267 .18455 L .85106 .18038 L p F P
0 g
s
.891 .696 .632 r
.85106 .18038 m .85256 .18077 L .85371 .18373 L p F P
0 g
s
.883 .586 .478 r
.8446 .16158 m .84298 .16014 L .8428 .15848 L p F P
0 g
s
.879 .58 .476 r
.84129 .15765 m .8428 .15848 L .84298 .16014 L p F P
0 g
s
.881 .632 .558 r
.84671 .16556 m .84874 .16837 L .84904 .16962 L p F P
0 g
s
.884 .626 .543 r
.84874 .16837 m .84671 .16556 L .84651 .16451 L p F P
0 g
s
.876 .567 .461 r
.8412 .15653 m .84129 .15765 L .8398 .15686 L p F P
0 g
s
.876 .567 .461 r
.8398 .15686 m .83974 .15613 L .8412 .15653 L p F P
0 g
s
.883 .613 .525 r
.84475 .16256 m .84651 .16451 L .84671 .16556 L p F P
0 g
s
.885 .606 .51 r
.84651 .16451 m .84475 .16256 L .8446 .16158 L p F P
0 g
s
.874 .56 .453 r
.83968 .15487 m .83968 .15499 L .83827 .15518 L p F P
0 g
s
.874 .56 .453 r
.83827 .15518 m .83827 .15512 L .83968 .15487 L p F P
0 g
s
.878 .637 .57 r
.84689 .16646 m .84904 .16962 L .84933 .17075 L p F P
0 g
s
.881 .632 .558 r
.84904 .16962 m .84689 .16646 L .84671 .16556 L p F P
0 g
s
.881 .596 .501 r
.84298 .16014 m .8446 .16158 L .84475 .16256 L p F P
0 g
s
.874 .561 .454 r
.83968 .15499 m .83969 .15513 L .83827 .15525 L p F P
0 g
s
.874 .561 .454 r
.83827 .15525 m .83827 .15518 L .83968 .15499 L p F P
0 g
s
.889 .714 .66 r
.85366 .18999 m .85306 .19161 L .85085 .18659 L p F P
0 g
s
.889 .714 .66 r
.85085 .18659 m .85174 .18554 L .85366 .18999 L p F P
0 g
s
.873 .561 .456 r
.83969 .15513 m .83969 .15527 L .83828 .15532 L p F P
0 g
s
.873 .561 .456 r
.83828 .15532 m .83827 .15525 L .83969 .15513 L p F P
0 g
s
.882 .681 .626 r
.85256 .18077 m .85106 .18038 L .84938 .17555 L p F P
0 g
s
.882 .681 .626 r
.84938 .17555 m .85139 .17748 L .85256 .18077 L p F P
0 g
s
.875 .642 .582 r
.84707 .16727 m .84933 .17075 L .84962 .17179 L p F P
0 g
s
.878 .637 .57 r
.84933 .17075 m .84707 .16727 L .84689 .16646 L p F P
0 g
s
.873 .561 .457 r
.83969 .15527 m .8397 .15543 L .83828 .1554 L p F P
0 g
s
.873 .561 .457 r
.83828 .1554 m .83828 .15532 L .83969 .15527 L p F P
0 g
s
.881 .618 .536 r
.84488 .16333 m .84671 .16556 L .84689 .16646 L p F P
0 g
s
.883 .613 .525 r
.84671 .16556 m .84488 .16333 L .84475 .16256 L p F P
0 g
s
.872 .646 .592 r
.84725 .16802 m .84962 .17179 L .8499 .17277 L p F P
0 g
s
.875 .642 .582 r
.84962 .17179 m .84725 .16802 L .84707 .16727 L p F P
0 g
s
.873 .562 .458 r
.8397 .15543 m .83971 .15562 L .83829 .1555 L p F P
0 g
s
.873 .562 .458 r
.83829 .1555 m .83828 .1554 L .8397 .15543 L p F P
0 g
s
.87 .649 .601 r
.84742 .16872 m .8499 .17277 L .85017 .1737 L p F P
0 g
s
.872 .646 .592 r
.8499 .17277 m .84742 .16872 L .84725 .16802 L p F P
0 g
s
.88 .602 .512 r
.84308 .16086 m .84475 .16256 L .84488 .16333 L p F P
0 g
s
.881 .596 .501 r
.84475 .16256 m .84308 .16086 L .84298 .16014 L p F P
0 g
s
.848 .651 .636 r
.85139 .17748 m .84938 .17555 L .84758 .16938 L p F P
0 g
s
.848 .651 .636 r
.84758 .16938 m .85017 .1737 L .85139 .17748 L p F P
0 g
s
.87 .649 .601 r
.85017 .1737 m .84758 .16938 L .84742 .16872 L p F P
0 g
s
.872 .562 .46 r
.83971 .15562 m .83972 .15584 L .8383 .15561 L p F P
0 g
s
.872 .562 .46 r
.8383 .15561 m .83829 .1555 L .83971 .15562 L p F P
0 g
s
.879 .58 .476 r
.84298 .16014 m .84141 .15882 L .84129 .15765 L p F P
0 g
s
.875 .574 .475 r
.8398 .15686 m .84129 .15765 L .84141 .15882 L p F P
0 g
s
.88 .622 .545 r
.845 .164 m .84689 .16646 L .84707 .16727 L p F P
0 g
s
.881 .618 .536 r
.84689 .16646 m .845 .164 L .84488 .16333 L p F P
0 g
s
.888 .696 .637 r
.85267 .18455 m .85174 .18554 L .84976 .18051 L p F P
0 g
s
.888 .696 .637 r
.84976 .18051 m .85106 .18038 L .85267 .18455 L p F P
0 g
s
.885 .717 .668 r
.85306 .19161 m .85245 .19315 L .84999 .18766 L p F P
0 g
s
.885 .717 .668 r
.84999 .18766 m .85085 .18659 L .85306 .19161 L p F P
0 g
s
.878 .588 .493 r
.84141 .15882 m .84298 .16014 L .84308 .16086 L p F P
0 g
s
.872 .563 .462 r
.83972 .15584 m .83974 .15613 L .83831 .15575 L p F P
0 g
s
.872 .563 .462 r
.83831 .15575 m .8383 .15561 L .83972 .15584 L p F P
0 g
s
.878 .626 .554 r
.84511 .1646 m .84707 .16727 L .84725 .16802 L p F P
0 g
s
.88 .622 .545 r
.84707 .16727 m .84511 .1646 L .845 .164 L p F P
0 g
s
.879 .606 .521 r
.84316 .16142 m .84488 .16333 L .845 .164 L p F P
0 g
s
.88 .602 .512 r
.84488 .16333 m .84316 .16142 L .84308 .16086 L p F P
0 g
s
.872 .565 .466 r
.83974 .15613 m .8398 .15686 L .83834 .1561 L p F P
0 g
s
.872 .565 .466 r
.83834 .1561 m .83831 .15575 L .83974 .15613 L p F P
0 g
s
.877 .63 .561 r
.84522 .16514 m .84725 .16802 L .84742 .16872 L p F P
0 g
s
.878 .626 .554 r
.84725 .16802 m .84522 .16514 L .84511 .1646 L p F P
0 g
s
.877 .592 .502 r
.84147 .15932 m .84308 .16086 L .84316 .16142 L p F P
0 g
s
.878 .588 .493 r
.84308 .16086 m .84147 .15932 L .84141 .15882 L p F P
0 g
s
.878 .61 .528 r
.84323 .1619 m .845 .164 L .84511 .1646 L p F P
0 g
s
.879 .606 .521 r
.845 .164 m .84323 .1619 L .84316 .16142 L p F P
0 g
s
.882 .719 .675 r
.85245 .19315 m .85183 .19462 L .84915 .18872 L p F P
0 g
s
.882 .719 .675 r
.84915 .18872 m .84999 .18766 L .85245 .19315 L p F P
0 g
s
.875 .633 .568 r
.84533 .16566 m .84742 .16872 L .84758 .16938 L p F P
0 g
s
.877 .63 .561 r
.84742 .16872 m .84533 .16566 L .84522 .16514 L p F P
0 g
s
.874 .58 .487 r
.83987 .1576 m .84141 .15882 L .84147 .15932 L p F P
0 g
s
.875 .574 .475 r
.84141 .15882 m .83987 .1576 L .8398 .15686 L p F P
0 g
s
.848 .636 .616 r
.84543 .16614 m .84758 .16938 L .84938 .17555 L p F P
0 g
s
.875 .633 .568 r
.84758 .16938 m .84543 .16614 L .84533 .16566 L p F P
0 g
s
.877 .613 .535 r
.84331 .16234 m .84511 .1646 L .84522 .16514 L p F P
0 g
s
.878 .61 .528 r
.84511 .1646 m .84331 .16234 L .84323 .1619 L p F P
0 g
s
.876 .595 .509 r
.84152 .15972 m .84316 .16142 L .84323 .1619 L p F P
0 g
s
.877 .592 .502 r
.84316 .16142 m .84152 .15972 L .84147 .15932 L p F P
0 g
s
.871 .569 .474 r
.83834 .1561 m .8398 .15686 L .83987 .1576 L p F P
0 g
s
.881 .676 .621 r
.85106 .18038 m .84976 .18051 L .8477 .17452 L p F P
0 g
s
.881 .676 .621 r
.8477 .17452 m .84938 .17555 L .85106 .18038 L p F P
0 g
s
.876 .615 .541 r
.84338 .16273 m .84522 .16514 L .84533 .16566 L p F P
0 g
s
.877 .613 .535 r
.84522 .16514 m .84338 .16273 L .84331 .16234 L p F P
0 g
s
.865 .553 .458 r
.8369 .15538 m .83827 .15512 L .83827 .15518 L closepath p F P
0 g
s
.885 .697 .643 r
.85174 .18554 m .85085 .18659 L .84858 .18087 L p F P
0 g
s
.885 .697 .643 r
.84858 .18087 m .84976 .18051 L .85174 .18554 L p F P
0 g
s
.875 .598 .514 r
.84156 .16005 m .84323 .1619 L .84331 .16234 L p F P
0 g
s
.876 .595 .509 r
.84323 .1619 m .84156 .16005 L .84152 .15972 L p F P
0 g
s
.879 .721 .682 r
.85183 .19462 m .85121 .19604 L .84833 .18978 L p F P
0 g
s
.879 .721 .682 r
.84833 .18978 m .84915 .18872 L .85183 .19462 L p F P
0 g
s
.873 .583 .493 r
.83991 .15792 m .84147 .15932 L .84152 .15972 L p F P
0 g
s
.874 .58 .487 r
.84147 .15932 m .83991 .15792 L .83987 .1576 L p F P
0 g
s
.865 .554 .458 r
.8369 .15538 m .83827 .15518 L .83827 .15525 L closepath p F P
0 g
s
.865 .554 .459 r
.8369 .15538 m .83827 .15525 L .83828 .15532 L closepath p F P
0 g
s
.875 .618 .546 r
.84344 .1631 m .84533 .16566 L .84543 .16614 L p F P
0 g
s
.876 .615 .541 r
.84533 .16566 m .84344 .1631 L .84338 .16273 L p F P
0 g
s
.866 .555 .46 r
.8369 .15538 m .83828 .15532 L .83828 .1554 L closepath p F P
0 g
s
.875 .6 .519 r
.84161 .16035 m .84331 .16234 L .84338 .16273 L p F P
0 g
s
.875 .598 .514 r
.84331 .16234 m .84161 .16035 L .84156 .16005 L p F P
0 g
s
.866 .556 .462 r
.8369 .15538 m .83828 .1554 L .83829 .1555 L closepath p F P
0 g
s
.873 .585 .498 r
.83993 .15816 m .84152 .15972 L .84156 .16005 L p F P
0 g
s
.873 .583 .493 r
.84152 .15972 m .83993 .15816 L .83991 .15792 L p F P
0 g
s
.866 .558 .463 r
.8369 .15538 m .83829 .1555 L .8383 .15561 L closepath p F P
0 g
s
.848 .636 .616 r
.84938 .17555 m .8477 .17452 L .84543 .16614 L p F P
0 g
s
.843 .624 .606 r
.84351 .16345 m .84543 .16614 L .8477 .17452 L p F P
0 g
s
.875 .618 .546 r
.84543 .16614 m .84351 .16345 L .84344 .1631 L p F P
0 g
s
.575 .939 .909 r
.60707 .2445 m .62299 .24537 L .72391 .19977 L p F P
0 g
s
.575 .939 .909 r
.62299 .24537 m .60707 .2445 L .50962 .29023 L p F P
0 g
s
.87 .573 .482 r
.83837 .15646 m .83987 .1576 L .83991 .15792 L p F P
0 g
s
.871 .569 .474 r
.83987 .1576 m .83837 .15646 L .83834 .1561 L p F P
0 g
s
.867 .559 .465 r
.8369 .15538 m .8383 .15561 L .83831 .15575 L closepath p F P
0 g
s
.874 .602 .524 r
.84165 .16062 m .84338 .16273 L .84344 .1631 L p F P
0 g
s
.875 .6 .519 r
.84338 .16273 m .84165 .16062 L .84161 .16035 L p F P
0 g
s
.872 .587 .503 r
.83996 .15837 m .84156 .16005 L .84161 .16035 L p F P
0 g
s
.873 .585 .498 r
.84156 .16005 m .83996 .15837 L .83993 .15816 L p F P
0 g
s
.876 .723 .688 r
.85121 .19604 m .85059 .19741 L .84752 .19082 L p F P
0 g
s
.876 .723 .688 r
.84752 .19082 m .84833 .18978 L .85121 .19604 L p F P
0 g
s
.867 .561 .468 r
.8369 .15538 m .83831 .15575 L .83834 .1561 L closepath p F P
0 g
s
.873 .604 .528 r
.84169 .16087 m .84344 .1631 L .84351 .16345 L p F P
0 g
s
.874 .602 .524 r
.84344 .1631 m .84169 .16087 L .84165 .16062 L p F P
0 g
s
.87 .575 .486 r
.83839 .15661 m .83991 .15792 L .83993 .15816 L p F P
0 g
s
.87 .573 .482 r
.83991 .15792 m .83839 .15661 L .83837 .15646 L p F P
0 g
s
.872 .589 .506 r
.83998 .15855 m .84161 .16035 L .84165 .16062 L p F P
0 g
s
.872 .587 .503 r
.84161 .16035 m .83998 .15855 L .83996 .15837 L p F P
0 g
s
.843 .624 .606 r
.8477 .17452 m .8462 .17397 L .84351 .16345 L p F P
0 g
s
.837 .614 .6 r
.84172 .16111 m .84351 .16345 L .8462 .17397 L p F P
0 g
s
.873 .604 .528 r
.84351 .16345 m .84172 .16111 L .84169 .16087 L p F P
0 g
s
.869 .576 .489 r
.8384 .15672 m .83993 .15816 L .83996 .15837 L p F P
0 g
s
.87 .575 .486 r
.83993 .15816 m .8384 .15672 L .83839 .15661 L p F P
0 g
s
.867 .564 .473 r
.8369 .15538 m .83834 .1561 L .83837 .15646 L closepath p F P
0 g
s
.871 .59 .51 r
.84 .15872 m .84165 .16062 L .84169 .16087 L p F P
0 g
s
.872 .589 .506 r
.84165 .16062 m .84 .15872 L .83998 .15855 L p F P
0 g
s
.778 .693 .769 r
.75043 .27594 m .84752 .19082 L .85059 .19741 L p F P
0 g
s
.869 .577 .492 r
.83841 .15682 m .83996 .15837 L .83998 .15855 L p F P
0 g
s
.869 .576 .489 r
.83996 .15837 m .83841 .15682 L .8384 .15672 L p F P
0 g
s
.871 .592 .513 r
.84002 .15888 m .84169 .16087 L .84172 .16111 L p F P
0 g
s
.871 .59 .51 r
.84169 .16087 m .84002 .15888 L .84 .15872 L p F P
0 g
s
.881 .698 .649 r
.85085 .18659 m .84999 .18766 L .84746 .18137 L p F P
0 g
s
.881 .698 .649 r
.84746 .18137 m .84858 .18087 L .85085 .18659 L p F P
0 g
s
.869 .578 .494 r
.83842 .15691 m .83998 .15855 L .84 .15872 L p F P
0 g
s
.869 .577 .492 r
.83998 .15855 m .83842 .15691 L .83841 .15682 L p F P
0 g
s
.867 .566 .477 r
.8369 .15538 m .83837 .15646 L .83839 .15661 L closepath p F P
0 g
s
.837 .614 .6 r
.8462 .17397 m .84481 .1737 L .84172 .16111 L p F P
0 g
s
.831 .605 .597 r
.84004 .15902 m .84172 .16111 L .84481 .1737 L p F P
0 g
s
.871 .592 .513 r
.84172 .16111 m .84004 .15902 L .84002 .15888 L p F P
0 g
s
.868 .579 .497 r
.83843 .15699 m .84 .15872 L .84002 .15888 L p F P
0 g
s
.869 .578 .494 r
.84 .15872 m .83843 .15699 L .83842 .15691 L p F P
0 g
s
.866 .567 .479 r
.8369 .15538 m .83839 .15661 L .8384 .15672 L closepath p F P
0 g
s
.879 .674 .622 r
.84976 .18051 m .84858 .18087 L .8462 .17397 L p F P
0 g
s
.879 .674 .622 r
.8462 .17397 m .8477 .17452 L .84976 .18051 L p F P
0 g
s
.868 .58 .499 r
.83843 .15706 m .84002 .15888 L .84004 .15902 L p F P
0 g
s
.868 .579 .497 r
.84002 .15888 m .83843 .15706 L .83843 .15699 L p F P
0 g
s
.866 .568 .481 r
.8369 .15538 m .8384 .15672 L .83841 .15682 L closepath p F P
0 g
s
.866 .568 .482 r
.8369 .15538 m .83841 .15682 L .83842 .15691 L closepath p F P
0 g
s
.831 .605 .597 r
.84481 .1737 m .84349 .17363 L .84004 .15902 L p F P
0 g
s
.825 .597 .594 r
.83844 .15712 m .84004 .15902 L .84349 .17363 L p F P
0 g
s
.868 .58 .499 r
.84004 .15902 m .83844 .15712 L .83843 .15706 L p F P
0 g
s
.865 .568 .484 r
.8369 .15538 m .83842 .15691 L .83843 .15699 L closepath p F P
0 g
s
.865 .569 .485 r
.8369 .15538 m .83843 .15699 L .83843 .15706 L closepath p F P
0 g
s
.865 .569 .486 r
.8369 .15538 m .83843 .15706 L .83844 .15712 L closepath p F P
0 g
s
.825 .597 .594 r
.84349 .17363 m .84224 .17369 L .83844 .15712 L p F P
0 g
s
.819 .59 .593 r
.8369 .15538 m .83844 .15712 L .84224 .17369 L p F P
0 g
s
.757 .549 .616 r
.71265 .19863 m .8369 .15538 L .84102 .17385 L p F P
0 g
s
.819 .59 .593 r
.84224 .17369 m .84102 .17385 L .8369 .15538 L p F P
0 g
s
.878 .699 .656 r
.84999 .18766 m .84915 .18872 L .84639 .18194 L p F P
0 g
s
.878 .699 .656 r
.84639 .18194 m .84746 .18137 L .84999 .18766 L p F P
0 g
s
.876 .673 .624 r
.84858 .18087 m .84746 .18137 L .84481 .1737 L p F P
0 g
s
.876 .673 .624 r
.84481 .1737 m .8462 .17397 L .84858 .18087 L p F P
0 g
s
.875 .7 .662 r
.84915 .18872 m .84833 .18978 L .84536 .18256 L p F P
0 g
s
.875 .7 .662 r
.84536 .18256 m .84639 .18194 L .84915 .18872 L p F P
0 g
s
.872 .701 .668 r
.84833 .18978 m .84752 .19082 L .84435 .1832 L p F P
0 g
s
.872 .701 .668 r
.84435 .1832 m .84536 .18256 L .84833 .18978 L p F P
0 g
s
.874 .673 .628 r
.84746 .18137 m .84639 .18194 L .84349 .17363 L p F P
0 g
s
.874 .673 .628 r
.84349 .17363 m .84481 .1737 L .84746 .18137 L p F P
0 g
s
.774 .666 .743 r
.84752 .19082 m .75043 .27594 L .7382 .25479 L p F P
0 g
s
.774 .666 .743 r
.7382 .25479 m .84435 .1832 L .84752 .19082 L p F P
0 g
s
.871 .673 .633 r
.84639 .18194 m .84536 .18256 L .84224 .17369 L p F P
0 g
s
.871 .673 .633 r
.84224 .17369 m .84349 .17363 L .84639 .18194 L p F P
0 g
s
.868 .673 .637 r
.84536 .18256 m .84435 .1832 L .84102 .17385 L p F P
0 g
s
.868 .673 .637 r
.84102 .17385 m .84224 .17369 L .84536 .18256 L p F P
0 g
s
.77 .631 .707 r
.84435 .1832 m .7382 .25479 L .72564 .22969 L p F P
0 g
s
.77 .631 .707 r
.72564 .22969 m .84102 .17385 L .84435 .1832 L p F P
0 g
s
.575 .939 .909 r
.72391 .19977 m .71265 .19863 L .60707 .2445 L p F P
0 g
s
.757 .549 .616 r
.84102 .17385 m .72564 .22969 L .71265 .19863 L p F P
0 g
s
.729 .712 .835 r
.64079 .3101 m .7382 .25479 L .75043 .27594 L p F P
0 g
s
.721 .675 .805 r
.7382 .25479 m .64079 .3101 L .62412 .28048 L p F P
0 g
s
.686 .639 .797 r
.50962 .29023 m .60707 .2445 L .62412 .28048 L p F P
0 g
s
.721 .675 .805 r
.62412 .28048 m .72564 .22969 L .7382 .25479 L p F P
0 g
s
.713 .631 .765 r
.72564 .22969 m .62412 .28048 L .60707 .2445 L p F P
0 g
s
.713 .631 .765 r
.60707 .2445 m .71265 .19863 L .72564 .22969 L p F P
0 g
s
.25 Mabswid
.82192 0 m
.97494 .23096 L
s
.97494 .23096 m
1 .44054 L
s
1 .44054 m
.84078 .21802 L
s
.84078 .21802 m
.82192 0 L
s
.02393 .28331 m
0 .49066 L
s
0 .49066 m
.84078 .21802 L
s
.84078 .21802 m
.82192 0 L
s
.82192 0 m
.02393 .28331 L
s
.02393 .28331 m
.82192 0 L
s
.05572 .27203 m
.05504 .27831 L
s
[(-5)] .05707 .25945 -0.10792 1 Mshowa
.21128 .21679 m
.21084 .2231 L
s
[(-2.5)] .21218 .20418 -0.07058 1 Mshowa
.37446 .15886 m
.37427 .16518 L
s
[(0)] .37484 .14622 -0.0303 1 Mshowa
.54581 .09803 m
.54589 .10435 L
s
[(2.5)] .54564 .08538 .0133 1 Mshowa
.72597 .03407 m
.72635 .04038 L
s
[(5)] .7252 .02144 .06064 1 Mshowa
.125 Mabswid
.08625 .26119 m
.08587 .26496 L
s
.11707 .25025 m
.11671 .25402 L
s
.14817 .2392 m
.14785 .24298 L
s
.17958 .22805 m
.17928 .23183 L
s
.24329 .20543 m
.24306 .20922 L
s
.27561 .19396 m
.2754 .19775 L
s
.30824 .18237 m
.30806 .18616 L
s
.34119 .17068 m
.34104 .17447 L
s
.40805 .14694 m
.40797 .15073 L
s
.44198 .13489 m
.44193 .13868 L
s
.47625 .12273 m
.47623 .12652 L
s
.51085 .11044 m
.51087 .11423 L
s
.58111 .08549 m
.5812 .08929 L
s
.61678 .07283 m
.6169 .07663 L
s
.6528 .06004 m
.65296 .06383 L
s
.6892 .04712 m
.68939 .05091 L
s
.02547 .28276 m
.02504 .28653 L
s
.76312 .02088 m
.76338 .02466 L
s
.80065 .00755 m
.80096 .01134 L
s
.25 Mabswid
.97494 .23096 m
1 .44054 L
s
.97725 .25028 m
.97121 .25217 L
s
[(-1)] .98931 .24649 -1 .31398 Mshowa
.98444 .31041 m
.97839 .31226 L
s
[(0)] .99653 .30672 -1 .30561 Mshowa
.99185 .37237 m
.98579 .37417 L
s
[(1)] 1.00397 .36877 -1 .29699 Mshowa
.99948 .43622 m
.99341 .43797 L
s
[(2)] 1.01164 .43272 -1 .28813 Mshowa
.125 Mabswid
.97867 .26216 m
.97505 .26329 L
s
.9801 .27412 m
.97647 .27525 L
s
.98154 .28615 m
.97791 .28727 L
s
.98298 .29824 m
.97936 .29936 L
s
.9859 .32266 m
.98227 .32376 L
s
.98738 .33497 m
.98374 .33607 L
s
.98886 .34736 m
.98522 .34846 L
s
.99035 .35983 m
.98671 .36091 L
s
.99336 .38498 m
.98972 .38606 L
s
.99487 .39768 m
.99123 .39875 L
s
.9964 .41045 m
.99276 .41151 L
s
.99794 .4233 m
.99429 .42435 L
s
.97583 .23846 m
.97222 .2396 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.35.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics3D", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[8]= ",
 CellTags->"S5.35.1"]
}, Open  ]],

Cell["This is a slightly more complex figure. ", "MathCaption",
 CellTags->{"S5.35.1", "1.11"}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InequalityPlot3D", "[", " ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Abs", "[", " ", 
      RowBox[{"x", " ", "y", " ", "z"}], "]"}], " ", "\[LessEqual]", " ", 
     "2"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], " ", "+", " ", 
      SuperscriptBox["y", "2"], " ", "+", " ", 
      SuperscriptBox["z", "2"]}], "<", "8"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", 
     RowBox[{"-", "4"}], ",", " ", "4"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"y", ",", " ", 
     RowBox[{"-", "4"}], ",", " ", "4"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"z", ",", " ", 
     RowBox[{"-", "4"}], ",", " ", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[9]:= ",
 CellTags->"S5.35.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.0855 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0567234 1.16608 6.04443e-17 1.16608 [
[.16507 .19847 -11.5244 -9 ]
[.16507 .19847 .47555 0 ]
[.3545 .11847 -5.39155 -9 ]
[.3545 .11847 .60845 0 ]
[.55936 .03204 -5.02088 -9 ]
[.55936 .03204 .97912 0 ]
[.07621 .87317 -6.79649 0 ]
[.07621 .87317 5.20351 9 ]
[.22056 .97437 -3.26269 0 ]
[.22056 .97437 2.73731 9 ]
[.34529 1.06181 -3.15173 0 ]
[.34529 1.06181 2.84827 9 ]
[.06259 .32899 -12 -2.67685 ]
[.06259 .32899 0 6.32315 ]
[.03462 .5041 -6 -2.83339 ]
[.03462 .5041 0 6.16661 ]
[.00297 .70226 -6 -3.01279 ]
[.00297 .70226 0 5.98721 ]
[ 0 0 0 0 ]
[ 1 1.0855 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.08846 .24555 m
.67245 0 L
s
.17494 .20919 m
.17988 .21455 L
s
[(-2)] .16507 .19847 .92074 1 Mshowa
.36358 .12987 m
.36813 .13557 L
s
[(0)] .3545 .11847 .79718 1 Mshowa
.56751 .04413 m
.57158 .05017 L
s
[(2)] .55936 .03204 .67363 1 Mshowa
.125 Mabswid
.22076 .18992 m
.22367 .19319 L
s
.26746 .17029 m
.27031 .1736 L
s
.31506 .15027 m
.31785 .15364 L
s
.41306 .10907 m
.41572 .11254 L
s
.46352 .08785 m
.46611 .09137 L
s
.51499 .06621 m
.51751 .06978 L
s
.12996 .2281 m
.13298 .23127 L
s
.62109 .0216 m
.62346 .02528 L
s
.25 Mabswid
0 .80374 m
.40037 1.0855 L
s
.07813 .85872 m
.07909 .8515 L
s
[(-2)] .07621 .87317 .13275 -1 Mshowa
.22183 .95985 m
.22246 .95259 L
s
[(0)] .22056 .97437 .08756 -1 Mshowa
.34602 1.04725 m
.34639 1.03997 L
s
[(2)] .34529 1.06181 .05058 -1 Mshowa
.125 Mabswid
.11613 .88546 m
.11665 .88112 L
s
.15269 .91119 m
.15317 .90685 L
s
.1879 .93597 m
.18833 .93162 L
s
.25454 .98287 m
.25488 .97851 L
s
.28611 1.00508 m
.28641 1.00072 L
s
.31658 1.02653 m
.31684 1.02216 L
s
.03861 .83091 m
.03924 .82658 L
s
.37448 1.06728 m
.37467 1.06291 L
s
.25 Mabswid
.08846 .24555 m
0 .80374 L
s
.0761 .32352 m
.08286 .32078 L
s
[(-2)] .06259 .32899 1 -0.40515 Mshowa
.04829 .49904 m
.05512 .49651 L
s
[(0)] .03462 .5041 1 -0.37036 Mshowa
.01681 .69768 m
.02373 .6954 L
s
[(2)] .00297 .70226 1 -0.33049 Mshowa
.125 Mabswid
.06946 .36545 m
.07352 .36384 L
s
.06261 .40865 m
.06669 .40707 L
s
.05556 .45316 m
.05965 .45161 L
s
.04079 .54636 m
.0449 .54488 L
s
.03305 .5952 m
.03717 .59375 L
s
.02506 .64561 m
.0292 .6442 L
s
.08256 .28278 m
.0866 .28111 L
s
.00828 .7515 m
.01244 .75017 L
s
.25 Mabswid
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.40037 1.0855 L
s
.40037 1.0855 m
.41799 .58158 L
s
.41799 .58158 m
.08846 .24555 L
s
.67245 0 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.67245 0 m
.08846 .24555 L
s
.41799 .58158 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.40037 1.0855 L
s
.40037 1.0855 m
.41799 .58158 L
s
0 0 m
1 0 L
1 1.0855 L
0 1.0855 L
closepath
clip
newpath
.5 Mabswid
.54 .409 .651 r
.58865 .58628 m .58381 .57018 L .58097 .66567 L p F P
0 g
s
.507 .392 .657 r
.58381 .57018 m .57985 .55796 L p .5797 .65867 L F P
0 g
s
.507 .392 .657 r
.5797 .65867 m .58097 .66567 L .58381 .57018 L p F P
0 g
s
.568 .423 .643 r
.59352 .60398 m .58865 .58628 L .58224 .67324 L p F P
0 g
s
.54 .409 .651 r
.58097 .66567 m .58224 .67324 L .58865 .58628 L p F P
0 g
s
.593 .433 .634 r
.59846 .6239 m .59352 .60398 L .58353 .68156 L p F P
0 g
s
.568 .423 .643 r
.58224 .67324 m .58353 .68156 L .59352 .60398 L p F P
0 g
s
.615 .441 .624 r
.60349 .64722 m .59846 .6239 L .58485 .69092 L p F P
0 g
s
.593 .433 .634 r
.58353 .68156 m .58485 .69092 L .59846 .6239 L p F P
0 g
s
.634 .446 .61 r
.60871 .67702 m .60349 .64722 L .58619 .70191 L p F P
0 g
s
.615 .441 .624 r
.58485 .69092 m .58619 .70191 L .60349 .64722 L p F P
0 g
s
.642 .485 .655 r
.6278 .74297 m .59195 .55383 L .5799 .55776 L p F P
0 g
s
.642 .485 .655 r
.5799 .55776 m .57982 .55779 L p .57986 .55794 L F P
0 g
s
.642 .485 .655 r
.57986 .55794 m .6278 .74297 L .5799 .55776 L F
.507 .392 .657 r
.57969 .55748 m .57899 .55531 L .579 .55653 L p F P
0 g
s
.47 .372 .662 r
.57899 .55531 m .57419 .54143 L .57845 .65211 L p F P
0 g
s
.47 .372 .662 r
.57845 .65211 m .5797 .65867 L .579 .55653 L p F P
0 g
s
.47 .372 .662 r
.579 .55653 m .57899 .55531 L p .57899 .55658 L F P
0 g
s
.47 .372 .662 r
.57845 .65211 m .579 .55653 L .57899 .55658 L F
.675 .589 .752 r
.58435 .54058 m .57969 .55748 L .59195 .55383 L F
.88 .704 .659 r
.56979 .63607 m .57845 .65211 L .57448 .54898 L p F P
0 g
s
.88 .704 .659 r
.57448 .54898 m .57419 .54143 L .57394 .54696 L p F P
0 g
s
.88 .704 .659 r
.57394 .54696 m .56979 .63607 L p .57448 .54898 L F P
0 g
s
.675 .589 .752 r
.56125 .50029 m .57915 .5561 L .58435 .54058 L F
.325 .473 .854 r
.57419 .54143 m .55105 .48416 L .49521 .43291 L p F P
0 g
s
.568 .626 .869 r
.52767 .43769 m .51203 .42918 L p .53995 .46379 L F P
0 g
s
.568 .626 .869 r
.54837 .47884 m .52767 .43769 L p .54809 .4811 L F P
0 g
s
.663 .689 .864 r
.50379 .39869 m .4696 .39508 L p .47213 .39693 L F P
0 g
s
.663 .689 .864 r
.47213 .39693 m .50778 .40802 L .50379 .39869 L F
.51805 .42198 m .50379 .39869 L p .51716 .42998 L F P
0 g
s
.71 .728 .864 r
.50379 .39869 m .47922 .36586 L .45646 .37871 L p F P
0 g
s
.71 .728 .864 r
.4696 .39508 m .50379 .39869 L p .4799 .3886 L F P
0 g
s
.71 .728 .864 r
.45646 .37871 m .46805 .39314 L p .4799 .3886 L F P
0 g
s
.71 .728 .864 r
.46805 .39314 m .4696 .39508 L p .4799 .3886 L F P
0 g
s
.707 .708 .848 r
.4968 .38212 m .50991 .40869 L .52555 .4087 L F
.47922 .36586 m .49215 .38391 L p .4968 .38212 L F P
0 g
s
.707 .708 .848 r
.49215 .38391 m .50991 .40869 L p .4968 .38212 L F P
0 g
s
.707 .708 .848 r
.50991 .40869 m .51375 .41405 L .5192 .41158 L p F P
0 g
s
.707 .708 .848 r
.5192 .41158 m .52555 .4087 L p .50991 .40869 L F P
0 g
s
.663 .689 .864 r
.47213 .39693 m .51716 .42998 L .50778 .40802 L F
.52767 .43769 m .51805 .42198 L p .51716 .42998 L F P
0 g
s
.663 .689 .864 r
.4696 .39508 m .48251 .41312 L .51203 .42918 L p F P
0 g
s
.663 .689 .864 r
.51203 .42918 m .52767 .43769 L p .51716 .42998 L F P
0 g
s
.663 .689 .864 r
.4696 .39508 m .51203 .42918 L .51716 .42998 L F
.692 .648 .802 r
.52776 .43164 m .54221 .46659 L .55898 .47083 L F
.5183 .41975 m .52407 .43106 L .52776 .43164 L F
.52407 .43106 m .54221 .46659 L .52776 .43164 L F
.51375 .41405 m .51805 .42198 L p .5183 .41975 L F P
0 g
s
.692 .648 .802 r
.51805 .42198 m .54221 .46659 L p .5183 .41975 L F P
0 g
s
.692 .648 .802 r
.54221 .46659 m .54706 .47555 L .54886 .47484 L p F P
0 g
s
.692 .648 .802 r
.54886 .47484 m .55898 .47083 L p .54221 .46659 L F P
0 g
s
.568 .626 .869 r
.48251 .41312 m .54809 .4811 L .53995 .46379 L F
.51203 .42918 m .48251 .41312 L p .53995 .46379 L F P
0 g
s
.568 .626 .869 r
.55105 .48416 m .54837 .47884 L p .54809 .4811 L F P
0 g
s
.568 .626 .869 r
.48251 .41312 m .49521 .43291 L .54729 .48071 L p F P
0 g
s
.568 .626 .869 r
.54729 .48071 m .55105 .48416 L p .54809 .4811 L F P
0 g
s
.568 .626 .869 r
.48251 .41312 m .54729 .48071 L .54809 .4811 L F
.675 .589 .752 r
.55106 .48252 m .57056 .53455 L .56125 .50029 L F
.54847 .47801 m .55004 .48203 L .55106 .48252 L F
.55004 .48203 m .57056 .53455 L .55106 .48252 L F
.54706 .47555 m .54837 .47884 L p .54847 .47801 L F P
0 g
s
.675 .589 .752 r
.54837 .47884 m .57056 .53455 L p .54847 .47801 L F P
0 g
s
.871 .696 .662 r
.56105 .61874 m .56979 .63607 L .57419 .54143 L closepath p F P
0 g
s
.861 .686 .663 r
.55224 .59981 m .56105 .61874 L .57419 .54143 L closepath p F P
0 g
s
.852 .674 .661 r
.54337 .57882 m .55224 .59981 L .57419 .54143 L closepath p F P
0 g
s
.844 .661 .655 r
.53445 .55511 m .54337 .57882 L .57419 .54143 L closepath p F P
0 g
s
.84 .648 .643 r
.52551 .52771 m .53445 .55511 L .57224 .54211 L p F P
0 g
s
.84 .648 .643 r
.57224 .54211 m .57419 .54143 L .5715 .54067 L p F P
0 g
s
.84 .648 .643 r
.5715 .54067 m .52551 .52771 L p .57224 .54211 L F P
0 g
s
.842 .637 .625 r
.51659 .49507 m .52551 .52771 L .5715 .54067 L p F P
0 g
s
.842 .637 .625 r
.5715 .54067 m .57419 .54143 L .56994 .53801 L p F P
0 g
s
.842 .637 .625 r
.56994 .53801 m .51659 .49507 L p .5715 .54067 L F P
0 g
s
.85 .629 .603 r
.50774 .4546 m .51659 .49507 L .56994 .53801 L p F P
0 g
s
.85 .629 .603 r
.56994 .53801 m .57419 .54143 L .5621 .52563 L p F P
0 g
s
.85 .629 .603 r
.5621 .52563 m .50774 .4546 L p .56994 .53801 L F P
0 g
s
.325 .473 .854 r
.49521 .43291 m .50774 .4546 L .5621 .52563 L p F P
0 g
s
.325 .473 .854 r
.5621 .52563 m .57419 .54143 L p .56604 .53022 L F P
0 g
s
.325 .473 .854 r
.49521 .43291 m .5621 .52563 L .56604 .53022 L F
.675 .589 .752 r
.57056 .53455 m .57127 .53633 L p .56125 .50029 L F P
0 g
s
.675 .589 .752 r
.57127 .53633 m .57533 .54653 L p .57275 .53806 L F P
0 g
s
.675 .589 .752 r
.57127 .53633 m .57275 .53806 L .56125 .50029 L F
.57533 .54653 m .57619 .54869 L p .57571 .54712 L F P
0 g
s
.675 .589 .752 r
.57533 .54653 m .57571 .54712 L .56125 .50029 L F
.57619 .54869 m .5782 .55373 L p .57709 .55021 L F P
0 g
s
.675 .589 .752 r
.57619 .54869 m .57709 .55021 L .56125 .50029 L F
.5782 .55373 m .57915 .5561 L p .57869 .55469 L F P
0 g
s
.675 .589 .752 r
.5782 .55373 m .57869 .55469 L .56125 .50029 L F
.57915 .5561 m .57969 .55748 L p .58435 .54058 L F P
0 g
s
.675 .589 .752 r
.57969 .55748 m .57982 .55779 L .5799 .55776 L p F P
0 g
s
.675 .589 .752 r
.5799 .55776 m .59195 .55383 L p .57969 .55748 L F P
0 g
s
.507 .392 .657 r
.57985 .55796 m .57969 .55748 L p .57903 .56107 L F P
0 g
s
.507 .392 .657 r
.579 .55653 m .57903 .56107 L p .57969 .55748 L F P
0 g
s
.507 .392 .657 r
.57903 .56107 m .5797 .65867 L p .57985 .55796 L F P
0 g
s
.639 .432 .585 r
.61502 .74533 m .60871 .67702 L .58761 .71603 L p F P
0 g
s
.634 .446 .61 r
.58619 .70191 m .58761 .71603 L .60871 .67702 L p F P
0 g
s
.642 .485 .655 r
.57982 .55779 m .61502 .74533 L .6278 .74297 L p F P
0 g
s
.633 .479 .656 r
.64035 .74032 m .60392 .54995 L .59195 .55383 L p F P
0 g
s
.633 .479 .656 r
.59195 .55383 m .6278 .74297 L .64035 .74032 L p F P
0 g
s
.666 .585 .755 r
.55898 .47083 m .59195 .55383 L .60392 .54995 L p F P
0 g
s
.675 .589 .752 r
.59195 .55383 m .55898 .47083 L .54706 .47555 L p F P
0 g
s
.623 .473 .657 r
.65267 .73737 m .61573 .54612 L .60392 .54995 L p F P
0 g
s
.623 .473 .657 r
.60392 .54995 m .64035 .74032 L .65267 .73737 L p F P
0 g
s
.657 .58 .757 r
.5708 .46634 m .60392 .54995 L .61573 .54612 L p F P
0 g
s
.666 .585 .755 r
.60392 .54995 m .5708 .46634 L .55898 .47083 L p F P
0 g
s
.807 .702 .749 r
.57845 .65211 m .56979 .63607 L .54625 .6632 L p F P
0 g
s
.807 .702 .749 r
.54625 .6632 m .55652 .68005 L .57845 .65211 L p F P
0 g
s
.668 .491 .637 r
.5797 .65867 m .57845 .65211 L .55652 .68005 L p F P
0 g
s
.668 .488 .633 r
.58097 .66567 m .5797 .65867 L .55724 .68485 L p F P
0 g
s
.668 .491 .637 r
.55652 .68005 m .55724 .68485 L .5797 .65867 L p F P
0 g
s
.613 .466 .658 r
.66477 .73412 m .62739 .54236 L .61573 .54612 L p F P
0 g
s
.613 .466 .658 r
.61573 .54612 m .65267 .73737 L .66477 .73412 L p F P
0 g
s
.647 .575 .76 r
.58253 .46207 m .61573 .54612 L .62739 .54236 L p F P
0 g
s
.657 .58 .757 r
.61573 .54612 m .58253 .46207 L .5708 .46634 L p F P
0 g
s
.668 .484 .628 r
.58224 .67324 m .58097 .66567 L .55797 .68999 L p F P
0 g
s
.668 .488 .633 r
.55724 .68485 m .55797 .68999 L .58097 .66567 L p F P
0 g
s
.689 .5 .626 r
.55724 .68485 m .55652 .68005 L .53065 .69404 L p F P
0 g
s
.772 .701 .785 r
.55652 .68005 m .54625 .6632 L .5199 .67758 L p F P
0 g
s
.772 .701 .785 r
.5199 .67758 m .53065 .69404 L .55652 .68005 L p F P
0 g
s
.667 .48 .622 r
.58353 .68156 m .58224 .67324 L .5587 .69554 L p F P
0 g
s
.668 .484 .628 r
.55797 .68999 m .5587 .69554 L .58224 .67324 L p F P
0 g
s
.689 .497 .622 r
.55797 .68999 m .55724 .68485 L .53115 .69797 L p F P
0 g
s
.689 .5 .626 r
.53065 .69404 m .53115 .69797 L .55724 .68485 L p F P
0 g
s
.603 .459 .659 r
.67667 .73056 m .63892 .53866 L .62739 .54236 L p F P
0 g
s
.603 .459 .659 r
.62739 .54236 m .66477 .73412 L .67667 .73056 L p F P
0 g
s
.637 .57 .762 r
.59418 .45802 m .62739 .54236 L .63892 .53866 L p F P
0 g
s
.647 .575 .76 r
.62739 .54236 m .59418 .45802 L .58253 .46207 L p F P
0 g
s
.807 .692 .738 r
.56979 .63607 m .56105 .61874 L .53586 .6449 L p F P
0 g
s
.807 .692 .738 r
.53586 .6449 m .54625 .6632 L .56979 .63607 L p F P
0 g
s
.709 .511 .62 r
.53115 .69797 m .53065 .69404 L .50228 .7008 L p F P
0 g
s
.748 .698 .804 r
.53065 .69404 m .5199 .67758 L .49167 .68519 L p F P
0 g
s
.748 .698 .804 r
.49167 .68519 m .50228 .7008 L .53065 .69404 L p F P
0 g
s
.688 .493 .618 r
.5587 .69554 m .55797 .68999 L .53165 .70217 L p F P
0 g
s
.689 .497 .622 r
.53115 .69797 m .53165 .70217 L .55797 .68999 L p F P
0 g
s
.667 .475 .616 r
.58485 .69092 m .58353 .68156 L .55944 .70165 L p F P
0 g
s
.667 .48 .622 r
.5587 .69554 m .55944 .70165 L .58353 .68156 L p F P
0 g
s
.708 .508 .616 r
.53165 .70217 m .53115 .69797 L .50267 .70425 L p F P
0 g
s
.709 .511 .62 r
.50228 .7008 m .50267 .70425 L .53115 .69797 L p F P
0 g
s
.682 .644 .806 r
.52555 .4087 m .55898 .47083 L .5708 .46634 L p F P
0 g
s
.692 .648 .802 r
.55898 .47083 m .52555 .4087 L .51375 .41405 L p F P
0 g
s
.687 .489 .614 r
.55944 .70165 m .5587 .69554 L .53216 .70672 L p F P
0 g
s
.688 .493 .618 r
.53165 .70217 m .53216 .70672 L .5587 .69554 L p F P
0 g
s
.708 .505 .613 r
.53216 .70672 m .53165 .70217 L .50306 .70794 L p F P
0 g
s
.708 .508 .616 r
.50267 .70425 m .50306 .70794 L .53165 .70217 L p F P
0 g
s
.729 .526 .617 r
.50267 .70425 m .50228 .7008 L .47146 .70219 L p F P
0 g
s
.733 .693 .813 r
.50228 .7008 m .49167 .68519 L .46151 .68775 L p F P
0 g
s
.733 .693 .813 r
.46151 .68775 m .47146 .70219 L .50228 .7008 L p F P
0 g
s
.592 .452 .66 r
.68836 .7267 m .65033 .53501 L .63892 .53866 L p F P
0 g
s
.592 .452 .66 r
.63892 .53866 m .67667 .73056 L .68836 .7267 L p F P
0 g
s
.627 .564 .764 r
.60575 .45419 m .63892 .53866 L .65033 .53501 L p F P
0 g
s
.637 .57 .762 r
.63892 .53866 m .60575 .45419 L .59418 .45802 L p F P
0 g
s
.666 .469 .609 r
.58619 .70191 m .58485 .69092 L .56018 .70853 L p F P
0 g
s
.667 .475 .616 r
.55944 .70165 m .56018 .70853 L .58485 .69092 L p F P
0 g
s
.686 .485 .608 r
.56018 .70853 m .55944 .70165 L .53266 .71171 L p F P
0 g
s
.687 .489 .614 r
.53216 .70672 m .53266 .71171 L .55944 .70165 L p F P
0 g
s
.729 .524 .614 r
.50306 .70794 m .50267 .70425 L .47181 .7054 L p F P
0 g
s
.729 .526 .617 r
.47146 .70219 m .47181 .7054 L .50267 .70425 L p F P
0 g
s
.707 .502 .609 r
.53266 .71171 m .53216 .70672 L .50345 .71193 L p F P
0 g
s
.708 .505 .613 r
.50306 .70794 m .50345 .71193 L .53216 .70672 L p F P
0 g
s
.673 .64 .809 r
.53731 .4037 m .5708 .46634 L .58253 .46207 L p F P
0 g
s
.682 .644 .806 r
.5708 .46634 m .53731 .4037 L .52555 .4087 L p F P
0 g
s
.806 .68 .726 r
.56105 .61874 m .55224 .59981 L .52539 .62472 L p F P
0 g
s
.806 .68 .726 r
.52539 .62472 m .53586 .6449 L .56105 .61874 L p F P
0 g
s
.728 .521 .61 r
.50345 .71193 m .50306 .70794 L .47215 .70884 L p F P
0 g
s
.729 .524 .614 r
.47181 .7054 m .47215 .70884 L .50306 .70794 L p F P
0 g
s
.773 .69 .772 r
.54625 .6632 m .53586 .6449 L .50903 .65971 L p F P
0 g
s
.773 .69 .772 r
.50903 .65971 m .5199 .67758 L .54625 .6632 L p F P
0 g
s
.686 .485 .608 r
.53266 .71171 m .53317 .71735 L .56018 .70853 L p F P
0 g
s
.706 .498 .604 r
.53317 .71735 m .53266 .71171 L .50384 .71632 L p F P
0 g
s
.707 .502 .609 r
.50345 .71193 m .50384 .71632 L .53266 .71171 L p F P
0 g
s
.717 .683 .816 r
.50774 .4546 m .49521 .43291 L .46343 .43263 L p F P
0 g
s
.717 .683 .816 r
.46343 .43263 m .47305 .44774 L .50774 .4546 L p F P
0 g
s
.772 .572 .629 r
.51659 .49507 m .50774 .4546 L .47305 .44774 L p F P
0 g
s
.666 .469 .609 r
.56018 .70853 m .56095 .71662 L .58619 .70191 L p F P
0 g
s
.685 .48 .602 r
.56095 .71662 m .56018 .70853 L .53317 .71735 L p F P
0 g
s
.728 .517 .606 r
.50384 .71632 m .50345 .71193 L .47249 .71256 L p F P
0 g
s
.728 .521 .61 r
.47215 .70884 m .47249 .71256 L .50345 .71193 L p F P
0 g
s
.724 .685 .812 r
.47146 .70219 m .46151 .68775 L .42892 .6852 L p F P
0 g
s
.724 .685 .812 r
.42892 .6852 m .43761 .69805 L .47146 .70219 L p F P
0 g
s
.751 .546 .617 r
.47181 .7054 m .47146 .70219 L .43761 .69805 L p F P
0 g
s
.581 .445 .66 r
.69984 .72253 m .6616 .53142 L .65033 .53501 L p F P
0 g
s
.581 .445 .66 r
.65033 .53501 m .68836 .7267 L .69984 .72253 L p F P
0 g
s
.616 .558 .766 r
.61725 .45057 m .65033 .53501 L .6616 .53142 L p F P
0 g
s
.627 .564 .764 r
.65033 .53501 m .61725 .45057 L .60575 .45419 L p F P
0 g
s
.665 .462 .6 r
.58761 .71603 m .58619 .70191 L .56095 .71662 L p F P
0 g
s
.662 .636 .813 r
.54904 .39905 m .58253 .46207 L .59418 .45802 L p F P
0 g
s
.673 .64 .809 r
.58253 .46207 m .54904 .39905 L .53731 .4037 L p F P
0 g
s
.751 .543 .614 r
.47215 .70884 m .47181 .7054 L .43797 .70126 L p F P
0 g
s
.751 .546 .617 r
.43761 .69805 m .43797 .70126 L .47181 .7054 L p F P
0 g
s
.685 .48 .602 r
.53317 .71735 m .53368 .72398 L .56095 .71662 L p F P
0 g
s
.705 .493 .599 r
.53368 .72398 m .53317 .71735 L .50422 .72127 L p F P
0 g
s
.706 .498 .604 r
.50384 .71632 m .50422 .72127 L .53317 .71735 L p F P
0 g
s
.727 .514 .602 r
.50422 .72127 m .50384 .71632 L .47283 .71665 L p F P
0 g
s
.728 .517 .606 r
.47249 .71256 m .47283 .71665 L .50384 .71632 L p F P
0 g
s
.749 .687 .791 r
.5199 .67758 m .50903 .65971 L .48096 .66826 L p F P
0 g
s
.749 .687 .791 r
.48096 .66826 m .49167 .68519 L .5199 .67758 L p F P
0 g
s
.751 .54 .61 r
.47249 .71256 m .47215 .70884 L .43833 .70468 L p F P
0 g
s
.751 .543 .614 r
.43797 .70126 m .43833 .70468 L .47215 .70884 L p F P
0 g
s
.665 .462 .6 r
.56095 .71662 m .56174 .72703 L .58761 .71603 L p F P
0 g
s
.684 .473 .595 r
.56174 .72703 m .56095 .71662 L .53368 .72398 L p F P
0 g
s
.803 .666 .711 r
.55224 .59981 m .54337 .57882 L .51484 .60198 L p F P
0 g
s
.803 .666 .711 r
.51484 .60198 m .52539 .62472 L .55224 .59981 L p F P
0 g
s
.705 .493 .599 r
.50422 .72127 m .5046 .72709 L .53368 .72398 L p F P
0 g
s
.726 .509 .597 r
.5046 .72709 m .50422 .72127 L .47316 .72126 L p F P
0 g
s
.727 .514 .602 r
.47283 .71665 m .47316 .72126 L .50422 .72127 L p F P
0 g
s
.75 .537 .607 r
.47283 .71665 m .47249 .71256 L .43868 .70839 L p F P
0 g
s
.751 .54 .61 r
.43833 .70468 m .43868 .70839 L .47249 .71256 L p F P
0 g
s
.684 .473 .595 r
.53368 .72398 m .53419 .73252 L .56174 .72703 L p F P
0 g
s
.704 .487 .592 r
.53419 .73252 m .53368 .72398 L .5046 .72709 L p F P
0 g
s
.652 .631 .816 r
.56075 .39474 m .59418 .45802 L .60575 .45419 L p F P
0 g
s
.662 .636 .813 r
.59418 .45802 m .56075 .39474 L .54904 .39905 L p F P
0 g
s
.734 .681 .8 r
.49167 .68519 m .48096 .66826 L .4515 .67211 L p F P
0 g
s
.734 .681 .8 r
.4515 .67211 m .46151 .68775 L .49167 .68519 L p F P
0 g
s
.75 .533 .602 r
.47316 .72126 m .47283 .71665 L .43903 .71246 L p F P
0 g
s
.75 .537 .607 r
.43868 .70839 m .43903 .71246 L .47283 .71665 L p F P
0 g
s
.319 .343 .729 r
.67682 .5405 m .72116 .62346 L p .67465 .53081 L F P
0 g
s
.605 .552 .769 r
.62869 .44716 m .6616 .53142 L .67269 .52791 L p F P
0 g
s
.605 .552 .769 r
.67269 .52791 m .67276 .52789 L p .67266 .5277 L F P
0 g
s
.605 .552 .769 r
.62869 .44716 m .67269 .52791 L .67266 .5277 L F
.319 .343 .729 r
.67244 .5264 m .6728 .52806 L .67465 .53081 L F
.67192 .52537 m .67264 .52757 L p .67244 .5264 L F P
0 g
s
.319 .343 .729 r
.67264 .52757 m .6728 .52806 L p .67244 .5264 L F P
0 g
s
.319 .343 .729 r
.6728 .52806 m .67682 .5405 L p .67465 .53081 L F P
0 g
s
.57 .437 .661 r
.71113 .71802 m .6728 .52806 L p .6616 .53142 L F P
0 g
s
.57 .437 .661 r
.6728 .52806 m .67276 .52789 L .67269 .52791 L p F P
0 g
s
.57 .437 .661 r
.67269 .52791 m .6616 .53142 L p .6728 .52806 L F P
0 g
s
.57 .437 .661 r
.6616 .53142 m .69984 .72253 L .71113 .71802 L p F P
0 g
s
.616 .558 .766 r
.6616 .53142 m .62869 .44716 L .61725 .45057 L p F P
0 g
s
.776 .572 .623 r
.43797 .70126 m .43761 .69805 L .39905 .68566 L p F P
0 g
s
.723 .669 .797 r
.43761 .69805 m .42892 .6852 L .39254 .6752 L p F P
0 g
s
.723 .669 .797 r
.39254 .6752 m .39905 .68566 L .43761 .69805 L p F P
0 g
s
.749 .7 .805 r
.47305 .44774 m .46343 .43263 L .43601 .44198 L p F P
0 g
s
.749 .7 .805 r
.43601 .44198 m .44412 .454 L .47305 .44774 L p F P
0 g
s
.772 .572 .629 r
.47305 .44774 m .48319 .50347 L .51659 .49507 L p F P
0 g
s
.729 .539 .634 r
.48319 .50347 m .47305 .44774 L .44412 .454 L p F P
0 g
s
.704 .487 .592 r
.5046 .72709 m .50497 .7346 L .53419 .73252 L p F P
0 g
s
.725 .504 .59 r
.50497 .7346 m .5046 .72709 L .47347 .72669 L p F P
0 g
s
.726 .509 .597 r
.47316 .72126 m .47347 .72669 L .5046 .72709 L p F P
0 g
s
.639 .432 .585 r
.58761 .71603 m .58939 .74903 L .61502 .74533 L p F P
0 g
s
.66 .444 .581 r
.58939 .74903 m .58761 .71603 L .56174 .72703 L p F P
0 g
s
.773 .677 .757 r
.53586 .6449 m .52539 .62472 L .49808 .63997 L p F P
0 g
s
.773 .677 .757 r
.49808 .63997 m .50903 .65971 L .53586 .6449 L p F P
0 g
s
.783 .601 .654 r
.52551 .52771 m .51659 .49507 L .48319 .50347 L p F P
0 g
s
.776 .569 .619 r
.43833 .70468 m .43797 .70126 L .39956 .6892 L p F P
0 g
s
.776 .572 .623 r
.39905 .68566 m .39956 .6892 L .43797 .70126 L p F P
0 g
s
.799 .648 .695 r
.54337 .57882 m .53445 .55511 L .50425 .57563 L p F P
0 g
s
.799 .648 .695 r
.50425 .57563 m .51484 .60198 L .54337 .57882 L p F P
0 g
s
.749 .529 .597 r
.47347 .72669 m .47316 .72126 L .43936 .71705 L p F P
0 g
s
.75 .533 .602 r
.43903 .71246 m .43936 .71705 L .47316 .72126 L p F P
0 g
s
.66 .444 .581 r
.56174 .72703 m .56269 .75152 L .58939 .74903 L p F P
0 g
s
.68 .459 .579 r
.56269 .75152 m .56174 .72703 L .53419 .73252 L p F P
0 g
s
.68 .459 .579 r
.53419 .73252 m .53474 .75268 L .56269 .75152 L p F P
0 g
s
.702 .475 .578 r
.53474 .75268 m .53419 .73252 L .50497 .7346 L p F P
0 g
s
.776 .566 .615 r
.43868 .70839 m .43833 .70468 L .40006 .69298 L p F P
0 g
s
.776 .569 .619 r
.39956 .6892 m .40006 .69298 L .43833 .70468 L p F P
0 g
s
.724 .673 .799 r
.46151 .68775 m .4515 .67211 L .42019 .67128 L p F P
0 g
s
.724 .673 .799 r
.42019 .67128 m .42892 .6852 L .46151 .68775 L p F P
0 g
s
.641 .626 .819 r
.57245 .39076 m .60575 .45419 L .61725 .45057 L p F P
0 g
s
.652 .631 .816 r
.60575 .45419 m .57245 .39076 L .56075 .39474 L p F P
0 g
s
.792 .626 .676 r
.53445 .55511 m .52551 .52771 L .49366 .54388 L p F P
0 g
s
.792 .626 .676 r
.49366 .54388 m .50425 .57563 L .53445 .55511 L p F P
0 g
s
.775 .562 .611 r
.43903 .71246 m .43868 .70839 L .40054 .69707 L p F P
0 g
s
.776 .566 .615 r
.40006 .69298 m .40054 .69707 L .43868 .70839 L p F P
0 g
s
.77 .709 .794 r
.44412 .454 m .43601 .44198 L .41064 .45712 L p F P
0 g
s
.77 .709 .794 r
.41064 .45712 m .41789 .4675 L .44412 .454 L p F P
0 g
s
.729 .539 .634 r
.44412 .454 m .45425 .51675 L .48319 .50347 L p F P
0 g
s
.7 .517 .637 r
.45425 .51675 m .44412 .454 L .41789 .4675 L p F P
0 g
s
.702 .475 .578 r
.50497 .7346 m .50528 .75233 L .53474 .75268 L p F P
0 g
s
.724 .493 .577 r
.50528 .75233 m .50497 .7346 L .47376 .73368 L p F P
0 g
s
.725 .504 .59 r
.47347 .72669 m .47376 .73368 L .50497 .7346 L p F P
0 g
s
.749 .524 .59 r
.47376 .73368 m .47347 .72669 L .43967 .72244 L p F P
0 g
s
.749 .529 .597 r
.43936 .71705 m .43967 .72244 L .47347 .72669 L p F P
0 g
s
.728 .702 .825 r
.49521 .43291 m .48251 .41312 L .45368 .41858 L p F P
0 g
s
.728 .702 .825 r
.45368 .41858 m .46343 .43263 L .49521 .43291 L p F P
0 g
s
.783 .601 .654 r
.48319 .50347 m .49366 .54388 L .52551 .52771 L p F P
0 g
s
.775 .559 .606 r
.43936 .71705 m .43903 .71246 L .40101 .70156 L p F P
0 g
s
.775 .562 .611 r
.40054 .69707 m .40101 .70156 L .43903 .71246 L p F P
0 g
s
.75 .672 .775 r
.50903 .65971 m .49808 .63997 L .47018 .64955 L p F P
0 g
s
.75 .672 .775 r
.47018 .64955 m .48096 .66826 L .50903 .65971 L p F P
0 g
s
.363 .359 .721 r
.72265 .63118 m .72116 .62346 L .67682 .5405 L p F P
0 g
s
.363 .359 .721 r
.67682 .5405 m .68178 .55688 L .72265 .63118 L p F P
0 g
s
.605 .552 .769 r
.64138 .44733 m .64007 .44398 L .6361 .44509 L p F P
0 g
s
.617 .614 .826 r
.59584 .38384 m .62869 .44716 L .6361 .44509 L p F P
0 g
s
.617 .614 .826 r
.6361 .44509 m .64007 .44398 L p .63556 .43784 L F P
0 g
s
.617 .614 .826 r
.59584 .38384 m .6361 .44509 L .63556 .43784 L F
.564 .573 .821 r
.63187 .38841 m .64138 .44733 L .63477 .38391 L F
.62106 .40518 m .63533 .43479 L p .63187 .38841 L F P
0 g
s
.617 .614 .826 r
.60754 .38089 m .59584 .38384 L p .59789 .38663 L F P
0 g
s
.617 .614 .826 r
.64007 .44398 m .61174 .38903 L p .59789 .38663 L F P
0 g
s
.617 .614 .826 r
.61174 .38903 m .60754 .38089 L p .59789 .38663 L F P
0 g
s
.621 .675 .88 r
.59584 .38384 m .60754 .38089 L p .60287 .37606 L F P
0 g
s
.621 .675 .88 r
.56219 .33392 m .59462 .38202 L p .60287 .37606 L F P
0 g
s
.621 .675 .88 r
.59462 .38202 m .59584 .38384 L p .60287 .37606 L F P
0 g
s
.602 .633 .854 r
.62037 .36342 m .61174 .38903 L .62266 .36325 L F
.5979 .36508 m .60384 .37536 L p .62037 .36342 L F P
0 g
s
.621 .675 .88 r
.60754 .38089 m .57428 .33114 L .56219 .33392 L p F P
0 g
s
.602 .633 .854 r
.60384 .37536 m .61174 .38903 L p .62037 .36342 L F P
0 g
s
.602 .633 .854 r
.61174 .38903 m .62106 .40518 L .62161 .39075 L p F P
0 g
s
.602 .633 .854 r
.62161 .39075 m .62266 .36325 L p .61174 .38903 L F P
0 g
s
.564 .573 .821 r
.63533 .43479 m .64138 .44733 L p .63187 .38841 L F P
0 g
s
.564 .573 .821 r
.64138 .44733 m .64401 .45278 L .64339 .44818 L p F P
0 g
s
.564 .573 .821 r
.64339 .44818 m .63477 .38391 L p .64138 .44733 L F P
0 g
s
.605 .552 .769 r
.67276 .52789 m .64138 .44733 L p .62869 .44716 L F P
0 g
s
.605 .552 .769 r
.6361 .44509 m .62869 .44716 L p .64138 .44733 L F P
0 g
s
.319 .343 .729 r
.72116 .62346 m .71972 .61631 L .67192 .52537 L p F P
0 g
s
.269 .323 .734 r
.66708 .51123 m .67192 .52537 L .71972 .61631 L p F P
0 g
s
.402 .371 .71 r
.72418 .63966 m .72265 .63118 L .68178 .55688 L p F P
0 g
s
.402 .371 .71 r
.68178 .55688 m .68682 .57487 L .72418 .63966 L p F P
0 g
s
.269 .323 .734 r
.71972 .61631 m .71831 .60962 L .66708 .51123 L p F P
0 g
s
0 0 .376 r
.66708 .51123 m .71831 .60962 L .70994 .59299 L closepath p F P
0 g
s
0 0 .447 r
.66708 .51123 m .70994 .59299 L .70144 .57505 L closepath p F P
0 g
s
0 0 .508 r
.66708 .51123 m .70144 .57505 L .69281 .55548 L closepath p F P
0 g
s
0 0 .547 r
.66708 .51123 m .69281 .55548 L .68402 .53382 L closepath p F P
0 g
s
0 0 .556 r
.66708 .51123 m .68402 .53382 L .67505 .50941 L closepath p F P
0 g
s
0 0 .526 r
.66708 .51123 m .67505 .50941 L .6659 .48126 L closepath p F P
0 g
s
0 0 .446 r
.66708 .51123 m .6659 .48126 L .65651 .44781 L closepath p F P
0 g
s
.475 .48 .783 r
.64401 .45278 m .66708 .51123 L .64681 .40647 L p F P
0 g
s
0 0 .304 r
.66708 .51123 m .65651 .44781 L .64681 .40647 L closepath p F P
0 g
s
.789 .713 .779 r
.41789 .4675 m .41064 .45712 L .38649 .47729 L p F P
0 g
s
.789 .713 .779 r
.38649 .47729 m .39332 .4869 L .41789 .4675 L p F P
0 g
s
.7 .517 .637 r
.41789 .4675 m .42742 .53096 L .45425 .51675 L p F P
0 g
s
.681 .504 .64 r
.42742 .53096 m .41789 .4675 L .39332 .4869 L p F P
0 g
s
.724 .493 .577 r
.47376 .73368 m .4739 .75019 L .50528 .75233 L p F P
0 g
s
.748 .513 .576 r
.4739 .75019 m .47376 .73368 L .43993 .72938 L p F P
0 g
s
.749 .524 .59 r
.43967 .72244 m .43993 .72938 L .47376 .73368 L p F P
0 g
s
.775 .554 .6 r
.43967 .72244 m .43936 .71705 L .40146 .70662 L p F P
0 g
s
.775 .559 .606 r
.40101 .70156 m .40146 .70662 L .43936 .71705 L p F P
0 g
s
.721 .656 .785 r
.42892 .6852 m .42019 .67128 L .38602 .66388 L p F P
0 g
s
.721 .656 .785 r
.38602 .66388 m .39254 .6752 L .42892 .6852 L p F P
0 g
s
.629 .62 .823 r
.58414 .38713 m .61725 .45057 L .62869 .44716 L p F P
0 g
s
.641 .626 .819 r
.61725 .45057 m .58414 .38713 L .57245 .39076 L p F P
0 g
s
.435 .378 .695 r
.72578 .6492 m .72418 .63966 L .68682 .57487 L p F P
0 g
s
.435 .378 .695 r
.68682 .57487 m .69199 .59509 L .72578 .6492 L p F P
0 g
s
.771 .66 .74 r
.52539 .62472 m .51484 .60198 L .48705 .61761 L p F P
0 g
s
.771 .66 .74 r
.48705 .61761 m .49808 .63997 L .52539 .62472 L p F P
0 g
s
.734 .667 .784 r
.48096 .66826 m .47018 .64955 L .44143 .65483 L p F P
0 g
s
.734 .667 .784 r
.44143 .65483 m .4515 .67211 L .48096 .66826 L p F P
0 g
s
.755 .715 .814 r
.46343 .43263 m .45368 .41858 L .42781 .43071 L p F P
0 g
s
.755 .715 .814 r
.42781 .43071 m .43601 .44198 L .46343 .43263 L p F P
0 g
s
.778 .623 .688 r
.39956 .6892 m .39905 .68566 L .34182 .6299 L p F P
0 g
s
.57 .607 .851 r
.34182 .6299 m .39905 .68566 L .39254 .6752 L closepath p F P
0 g
s
.807 .712 .76 r
.39332 .4869 m .38649 .47729 L .36332 .50315 L p F P
0 g
s
.807 .712 .76 r
.36332 .50315 m .37012 .51277 L .39332 .4869 L p F P
0 g
s
.681 .504 .64 r
.39332 .4869 m .40188 .5454 L .42742 .53096 L p F P
0 g
s
.668 .498 .646 r
.40188 .5454 m .39332 .4869 L .37012 .51277 L p F P
0 g
s
.775 .548 .592 r
.43993 .72938 m .43967 .72244 L .40188 .71254 L p F P
0 g
s
.775 .554 .6 r
.40146 .70662 m .40188 .71254 L .43967 .72244 L p F P
0 g
s
.783 .619 .678 r
.40006 .69298 m .39956 .6892 L .34409 .63633 L p F P
0 g
s
.778 .623 .688 r
.34182 .6299 m .34409 .63633 L .39956 .6892 L p F P
0 g
s
.464 .381 .677 r
.72748 .66039 m .72578 .6492 L .69199 .59509 L p F P
0 g
s
.464 .381 .677 r
.69199 .59509 m .69736 .61875 L .72748 .66039 L p F P
0 g
s
.787 .615 .667 r
.40054 .69707 m .40006 .69298 L .34633 .64324 L p F P
0 g
s
.824 .608 .61 r
.35773 .72437 m .34449 .63756 L p .33787 .63982 L F P
0 g
s
.824 .608 .61 r
.34449 .63756 m .34448 .63748 L .34443 .6375 L p F P
0 g
s
.824 .608 .61 r
.34443 .6375 m .33787 .63982 L p .34449 .63756 L F P
0 g
s
.783 .619 .678 r
.34409 .63633 m .34449 .63756 L p .40006 .69298 L F P
0 g
s
.783 .619 .678 r
.34449 .63756 m .34633 .64324 L .39461 .68794 L p F P
0 g
s
.783 .619 .678 r
.39461 .68794 m .40006 .69298 L p .34449 .63756 L F P
0 g
s
.776 .721 .802 r
.43601 .44198 m .42781 .43071 L .4033 .44737 L p F P
0 g
s
.776 .721 .802 r
.4033 .44737 m .41064 .45712 L .43601 .44198 L p F P
0 g
s
.723 .657 .784 r
.4515 .67211 m .44143 .65483 L .41144 .65591 L p F P
0 g
s
.723 .657 .784 r
.41144 .65591 m .42019 .67128 L .4515 .67211 L p F P
0 g
s
.791 .609 .656 r
.40101 .70156 m .40054 .69707 L .34855 .65073 L p F P
0 g
s
.787 .615 .667 r
.34633 .64324 m .34855 .65073 L .40054 .69707 L p F P
0 g
s
.674 .436 .552 r
.56269 .75152 m .53474 .75268 L .53429 .77209 L p F P
0 g
s
.698 .457 .555 r
.53474 .75268 m .50528 .75233 L .50474 .76944 L p F P
0 g
s
.698 .457 .555 r
.50474 .76944 m .53429 .77209 L .53474 .75268 L p F P
0 g
s
.748 .513 .576 r
.43993 .72938 m .43996 .74572 L .4739 .75019 L p F P
0 g
s
.774 .537 .576 r
.43996 .74572 m .43993 .72938 L .40224 .72015 L p F P
0 g
s
.775 .548 .592 r
.40188 .71254 m .40224 .72015 L .43993 .72938 L p F P
0 g
s
.629 .62 .823 r
.62869 .44716 m .59584 .38384 L .58414 .38713 L p F P
0 g
s
.722 .478 .557 r
.50528 .75233 m .4739 .75019 L .47324 .76609 L p F P
0 g
s
.722 .478 .557 r
.47324 .76609 m .50474 .76944 L .50528 .75233 L p F P
0 g
s
.795 .725 .787 r
.41064 .45712 m .4033 .44737 L .37957 .46828 L p F P
0 g
s
.795 .725 .787 r
.37957 .46828 m .38649 .47729 L .41064 .45712 L p F P
0 g
s
.823 .705 .735 r
.37012 .51277 m .36332 .50315 L .34154 .53744 L p F P
0 g
s
.823 .705 .735 r
.34154 .53744 m .34889 .54844 L .37012 .51277 L p F P
0 g
s
.668 .498 .646 r
.37012 .51277 m .37743 .56063 L .40188 .5454 L p F P
0 g
s
.663 .505 .66 r
.37743 .56063 m .37012 .51277 L .34889 .54844 L p F P
0 g
s
.748 .654 .757 r
.49808 .63997 m .48705 .61761 L .45935 .62834 L p F P
0 g
s
.748 .654 .757 r
.45935 .62834 m .47018 .64955 L .49808 .63997 L p F P
0 g
s
.767 .638 .719 r
.51484 .60198 m .50425 .57563 L .476 .59143 L p F P
0 g
s
.767 .638 .719 r
.476 .59143 m .48705 .61761 L .51484 .60198 L p F P
0 g
s
.648 .411 .546 r
.58939 .74903 m .56269 .75152 L .56226 .77497 L p F P
0 g
s
.674 .436 .552 r
.53429 .77209 m .56226 .77497 L .56269 .75152 L p F P
0 g
s
.794 .604 .644 r
.40146 .70662 m .40101 .70156 L .35072 .65898 L p F P
0 g
s
.791 .609 .656 r
.34855 .65073 m .35072 .65898 L .40101 .70156 L p F P
0 g
s
.623 .616 .823 r
.34182 .6299 m .39254 .6752 L .38602 .66388 L closepath p F P
0 g
s
.747 .579 .667 r
.49366 .54388 m .48319 .50347 L .45425 .51675 L p F P
0 g
s
.718 .641 .771 r
.42019 .67128 m .41144 .65591 L .37952 .65146 L p F P
0 g
s
.718 .641 .771 r
.37952 .65146 m .38602 .66388 L .42019 .67128 L p F P
0 g
s
.697 .704 .853 r
.49093 .35996 m .52555 .4087 L .53731 .4037 L p F P
0 g
s
.707 .708 .848 r
.52555 .4087 m .49093 .35996 L .47922 .36586 L p F P
0 g
s
.488 .376 .653 r
.7294 .67475 m .72748 .66039 L .69736 .61875 L p F P
0 g
s
.488 .376 .653 r
.69736 .61875 m .70312 .64895 L .7294 .67475 L p F P
0 g
s
.747 .499 .556 r
.4739 .75019 m .43996 .74572 L .43908 .76138 L p F P
0 g
s
.747 .499 .556 r
.43908 .76138 m .47324 .76609 L .4739 .75019 L p F P
0 g
s
.813 .724 .767 r
.38649 .47729 m .37957 .46828 L .35642 .49419 L p F P
0 g
s
.813 .724 .767 r
.35642 .49419 m .36332 .50315 L .38649 .47729 L p F P
0 g
s
.738 .721 .835 r
.48251 .41312 m .4696 .39508 L .4438 .40553 L p F P
0 g
s
.738 .721 .835 r
.4438 .40553 m .45368 .41858 L .48251 .41312 L p F P
0 g
s
.475 .48 .783 r
.64681 .40647 m .63477 .38391 L .64401 .45278 L p F P
0 g
s
.797 .597 .631 r
.40188 .71254 m .40146 .70662 L .35283 .66825 L p F P
0 g
s
.794 .604 .644 r
.35072 .65898 m .35283 .66825 L .40146 .70662 L p F P
0 g
s
.732 .648 .765 r
.47018 .64955 m .45935 .62834 L .43134 .63525 L p F P
0 g
s
.732 .648 .765 r
.43134 .63525 m .44143 .65483 L .47018 .64955 L p F P
0 g
s
.594 .351 .518 r
.61502 .74533 m .58939 .74903 L .58882 .78024 L p F P
0 g
s
.648 .411 .546 r
.56226 .77497 m .58882 .78024 L .58939 .74903 L p F P
0 g
s
.759 .612 .695 r
.50425 .57563 m .49366 .54388 L .46501 .55924 L p F P
0 g
s
.759 .612 .695 r
.46501 .55924 m .476 .59143 L .50425 .57563 L p F P
0 g
s
.801 .589 .615 r
.40224 .72015 m .40188 .71254 L .35487 .67911 L p F P
0 g
s
.797 .597 .631 r
.35283 .66825 m .35487 .67911 L .40188 .71254 L p F P
0 g
s
.686 .701 .858 r
.50268 .35452 m .53731 .4037 L .54904 .39905 L p F P
0 g
s
.697 .704 .853 r
.53731 .4037 m .50268 .35452 L .49093 .35996 L p F P
0 g
s
.762 .73 .823 r
.45368 .41858 m .4438 .40553 L .41951 .42017 L p F P
0 g
s
.762 .73 .823 r
.41951 .42017 m .42781 .43071 L .45368 .41858 L p F P
0 g
s
.747 .579 .667 r
.45425 .51675 m .46501 .55924 L .49366 .54388 L p F P
0 g
s
.659 .616 .795 r
.34182 .6299 m .38602 .66388 L .37952 .65146 L closepath p F P
0 g
s
.721 .638 .765 r
.44143 .65483 m .43134 .63525 L .4027 .63854 L p F P
0 g
s
.721 .638 .765 r
.4027 .63854 m .41144 .65591 L .44143 .65483 L p F P
0 g
s
.807 .653 .691 r
.34889 .54844 m .34154 .53744 L .33054 .60358 L p F P
0 g
s
.807 .653 .691 r
.33054 .60358 m .34182 .6299 L .34889 .54844 L p F P
0 g
s
.663 .505 .66 r
.34889 .54844 m .35443 .57931 L .37743 .56063 L p F P
0 g
s
.568 .441 .667 r
.34182 .6299 m .35443 .57931 L .34889 .54844 L closepath p F P
0 g
s
.782 .735 .81 r
.42781 .43071 m .41951 .42017 L .39588 .43821 L p F P
0 g
s
.782 .735 .81 r
.39588 .43821 m .4033 .44737 L .42781 .43071 L p F P
0 g
s
.83 .719 .742 r
.36332 .50315 m .35642 .49419 L .33407 .52741 L p F P
0 g
s
.83 .719 .742 r
.33407 .52741 m .34154 .53744 L .36332 .50315 L p F P
0 g
s
.744 .631 .734 r
.48705 .61761 m .476 .59143 L .44852 .6034 L p F P
0 g
s
.744 .631 .734 r
.44852 .6034 m .45935 .62834 L .48705 .61761 L p F P
0 g
s
.8 .737 .794 r
.4033 .44737 m .39588 .43821 L .37257 .45984 L p F P
0 g
s
.8 .737 .794 r
.37257 .45984 m .37957 .46828 L .4033 .44737 L p F P
0 g
s
.713 .623 .755 r
.41144 .65591 m .4027 .63854 L .37305 .63756 L p F P
0 g
s
.713 .623 .755 r
.37305 .63756 m .37952 .65146 L .41144 .65591 L p F P
0 g
s
.774 .537 .576 r
.40224 .72015 m .40221 .73793 L .43996 .74572 L p F P
0 g
s
.775 .523 .555 r
.43996 .74572 m .40221 .73793 L .40091 .75474 L p F P
0 g
s
.775 .523 .555 r
.40091 .75474 m .43908 .76138 L .43996 .74572 L p F P
0 g
s
.722 .563 .674 r
.46501 .55924 m .45425 .51675 L .42742 .53096 L p F P
0 g
s
.806 .573 .584 r
.40221 .73793 m .40224 .72015 L .35675 .69296 L p F P
0 g
s
.801 .589 .615 r
.35487 .67911 m .35675 .69296 L .40224 .72015 L p F P
0 g
s
.594 .351 .518 r
.58882 .78024 m .61205 .80642 L .61502 .74533 L p F P
0 g
s
.623 .327 .447 r
.61205 .80642 m .58882 .78024 L .58788 .79256 L p F P
0 g
s
.623 .327 .447 r
.58788 .79256 m .60792 .82889 L .61205 .80642 L p F P
0 g
s
.642 .317 .405 r
.60792 .82889 m .58788 .79256 L .58687 .80174 L p F P
0 g
s
.642 .317 .405 r
.58687 .80174 m .60353 .84474 L .60792 .82889 L p F P
0 g
s
.663 .313 .37 r
.60353 .84474 m .58687 .80174 L .58582 .80929 L p F P
0 g
s
.663 .313 .37 r
.58582 .80929 m .59897 .85704 L .60353 .84474 L p F P
0 g
s
.684 .314 .34 r
.59897 .85704 m .58582 .80929 L .58474 .81578 L p F P
0 g
s
.684 .314 .34 r
.58474 .81578 m .59429 .867 L .59897 .85704 L p F P
0 g
s
.705 .318 .313 r
.59429 .867 m .58474 .81578 L .58364 .82152 L p F P
0 g
s
.705 .318 .313 r
.58364 .82152 m .58949 .87521 L .59429 .867 L p F P
0 g
s
.726 .325 .29 r
.58949 .87521 m .58364 .82152 L .58253 .82669 L p F P
0 g
s
.726 .325 .29 r
.58253 .82669 m .58448 .87882 L p .58949 .87521 L F P
0 g
s
.726 .325 .29 r
.58457 .88136 m .5846 .88205 L .58531 .88105 L p F P
0 g
s
.746 .334 .269 r
.58253 .82669 m .5814 .8314 L p .58455 .88136 L F P
0 g
s
.746 .334 .269 r
.5846 .88205 m .58457 .88136 L p .58455 .88136 L F P
0 g
s
.746 .334 .269 r
.58457 .88136 m .58253 .82669 L p .58455 .88136 L F P
0 g
s
.29 0 0 r
.59892 .87976 m .58554 .88095 L p .58479 .88145 L F P
0 g
s
.746 .334 .269 r
.5814 .8314 m .57961 .88775 L .5846 .88205 L p F P
0 g
s
.892 .491 .247 r
.5814 .8314 m .57246 .83028 L .57918 .88424 L p F P
0 g
s
.892 .491 .247 r
.57918 .88424 m .57961 .88775 L .57974 .88372 L p F P
0 g
s
.892 .491 .247 r
.57974 .88372 m .5814 .8314 L p .57918 .88424 L F P
0 g
s
.883 .481 .255 r
.57246 .83028 m .56339 .83047 L .57873 .88463 L p F P
0 g
s
.883 .481 .255 r
.57873 .88463 m .57961 .88775 L .57918 .88424 L p F P
0 g
s
.883 .481 .255 r
.57918 .88424 m .57246 .83028 L p .57873 .88463 L F P
0 g
s
.874 .474 .272 r
.55417 .83238 m .57961 .88775 L .56339 .83047 L closepath p F P
0 g
s
.864 .473 .298 r
.54479 .83662 m .57961 .88775 L .55417 .83238 L closepath p F P
0 g
s
.856 .48 .334 r
.53522 .84408 m .57961 .88775 L .54479 .83662 L closepath p F P
0 g
s
.852 .495 .376 r
.53522 .84408 m .52543 .85616 L .5766 .886 L p F P
0 g
s
.852 .495 .376 r
.5766 .886 m .57961 .88775 L .57739 .88557 L p F P
0 g
s
.852 .495 .376 r
.57739 .88557 m .53522 .84408 L p .5766 .886 L F P
0 g
s
.29 0 0 r
.58531 .88105 m .58375 .88209 L p .58554 .88095 L F P
0 g
s
.853 .519 .419 r
.52543 .85616 m .51536 .87516 L .57492 .88683 L p F P
0 g
s
.853 .519 .419 r
.57492 .88683 m .57961 .88775 L .5766 .886 L p F P
0 g
s
.853 .519 .419 r
.5766 .886 m .52543 .85616 L p .57492 .88683 L F P
0 g
s
.29 0 0 r
.58375 .88209 m .58164 .8835 L p .58414 .88187 L F P
0 g
s
.86 .546 .455 r
.51536 .87516 m .50492 .90517 L .5664 .89084 L p F P
0 g
s
.86 .546 .455 r
.5664 .89084 m .57961 .88775 L .57492 .88683 L p F P
0 g
s
.86 .546 .455 r
.57492 .88683 m .51536 .87516 L p .5664 .89084 L F P
0 g
s
.29 0 0 r
.58164 .8835 m .58073 .8841 L p .58185 .88339 L F P
0 g
s
.29 0 0 r
.58073 .8841 m .57468 .88814 L p .58089 .88403 L F P
0 g
s
.29 0 0 r
.58089 .88403 m .58185 .88339 L .58073 .8841 L F
.58185 .88339 m .58414 .88187 L .58164 .8835 L F
.58414 .88187 m .58554 .88095 L .58375 .88209 L F
.742 .409 .417 r
.46494 .8996 m .50492 .90517 L .5086 .89458 L p F P
0 g
s
.742 .409 .417 r
.46494 .8996 m .5086 .89458 L .50005 .89251 L F
.46494 .8996 m .51002 .8905 L .49759 .88377 L F
.733 .273 .159 r
.52744 .89992 m .52193 .89694 L p .57961 .88775 L F P
0 g
s
.733 .273 .159 r
.51606 .90258 m .50492 .90517 L p .49027 .90199 L F P
0 g
s
.733 .273 .159 r
.49027 .90199 m .53306 .90296 L p .52193 .89694 L F P
0 g
s
.733 .273 .159 r
.53306 .90296 m .5545 .90345 L p .52193 .89694 L F P
0 g
s
.457 0 0 r
.49493 .89769 m .55116 .90313 L .50853 .90233 L F
.55025 .90336 m .49027 .90199 L p .55116 .90313 L F P
0 g
s
.457 0 0 r
.49027 .90199 m .4753 .89579 L p .49493 .89769 L F P
0 g
s
.457 0 0 r
.49493 .89769 m .50853 .90233 L .49027 .90199 L F
.4753 .89579 m .50974 .90162 L p .54678 .90381 L F P
0 g
s
.457 0 0 r
.50974 .90162 m .52788 .90469 L .54454 .90392 L p F P
0 g
s
.457 0 0 r
.54454 .90392 m .54678 .90381 L p .50974 .90162 L F P
0 g
s
.457 0 0 r
.4753 .89579 m .54678 .90381 L .53916 .90197 L F
.742 .409 .417 r
.51536 .87516 m .47819 .85433 L .46494 .8996 L p F P
0 g
s
.742 .409 .417 r
.5086 .89458 m .51002 .8905 L p .50005 .89251 L F P
0 g
s
.689 .369 .429 r
.43201 .89167 m .43893 .89334 L p .47819 .85433 L F P
0 g
s
.689 .369 .429 r
.43893 .89334 m .46494 .8996 L .46541 .89799 L p F P
0 g
s
.689 .369 .429 r
.46541 .89799 m .47819 .85433 L p .43893 .89334 L F P
0 g
s
0 .506 .743 r
.45356 .89542 m .49027 .90199 L .49904 .90389 L p F P
0 g
s
0 .506 .743 r
.49904 .90389 m .50492 .90517 L p .48756 .90188 L F P
0 g
s
0 .506 .743 r
.45356 .89542 m .49904 .90389 L .48756 .90188 L F
.478 .779 .997 r
.52542 .89892 m .51802 .89951 L p .47092 .87396 L F P
0 g
s
.1 .622 .88 r
.47204 .88988 m .48001 .8912 L .5167 .90061 L F
.50717 .89714 m .5167 .90061 L p .48001 .8912 L F P
0 g
s
.1 .622 .88 r
.47204 .88988 m .5167 .90061 L .5157 .90146 L F
.478 .779 .997 r
.51802 .89951 m .51167 .90002 L .50717 .89714 L p F P
0 g
s
.478 .779 .997 r
.50717 .89714 m .47092 .87396 L p .51802 .89951 L F P
0 g
s
.1 .622 .88 r
.49996 .89451 m .50717 .89714 L p .48001 .8912 L F P
0 g
s
.1 .622 .88 r
.5167 .90061 m .52788 .90469 L p .5157 .90146 L F P
0 g
s
.457 0 0 r
.5545 .90345 m .55025 .90336 L p .55116 .90313 L F P
0 g
s
.457 0 0 r
.5515 .90359 m .5545 .90345 L p .55116 .90313 L F P
0 g
s
.733 .273 .159 r
.5545 .90345 m .57961 .88775 L p .52193 .89694 L F P
0 g
s
.29 0 0 r
.55281 .90272 m .5515 .90359 L p .55282 .90272 L F P
0 g
s
.29 0 0 r
.5515 .90359 m .55003 .90457 L p .5515 .9036 L F P
0 g
s
.29 0 0 r
.5515 .9036 m .55282 .90272 L .5515 .90359 L F
.457 0 0 r
.54678 .90381 m .5515 .90359 L p .53916 .90197 L F P
0 g
s
.457 0 0 r
.53916 .90197 m .5515 .90359 L .55116 .90313 L F
.29 0 0 r
.55003 .90457 m .56583 .89655 L .57552 .88761 L F
.55003 .90457 m .56371 .90356 L .59892 .87976 L p F P
0 g
s
.204 .725 .861 r
.56371 .90356 m .5521 .90442 L p .51676 .90057 L F P
0 g
s
.204 .725 .861 r
.51167 .90002 m .51698 .90038 L .51676 .90057 L F
.51698 .90038 m .56371 .90356 L .51676 .90057 L F
.5521 .90442 m .55003 .90457 L .54454 .90392 L p F P
0 g
s
.204 .725 .861 r
.54454 .90392 m .51167 .90002 L p .5521 .90442 L F P
0 g
s
.1 .622 .88 r
.46003 .88669 m .46631 .88792 L p .47204 .88988 L F P
0 g
s
.1 .622 .88 r
.46631 .88792 m .49996 .89451 L p .47204 .88988 L F P
0 g
s
.29 0 0 r
.57468 .88814 m .55281 .90272 L p .57449 .8883 L F P
0 g
s
.29 0 0 r
.55282 .90272 m .57449 .8883 L .55281 .90272 L F
.742 .409 .417 r
.51002 .8905 m .51536 .87516 L p .49759 .88377 L F P
0 g
s
.29 0 0 r
.57449 .8883 m .58554 .88095 L .57468 .88814 L F
.57552 .88761 m .59086 .88385 L .58479 .88145 L F
.56583 .89655 m .59086 .88385 L .57552 .88761 L F
.59086 .88385 m .59892 .87976 L .58479 .88145 L F
.58554 .88095 m .58544 .88096 L .58531 .88105 L p F P
0 g
s
.726 .325 .29 r
.58448 .87882 m .58457 .88136 L p .58547 .88083 L F P
0 g
s
.726 .325 .29 r
.58531 .88105 m .58547 .88083 L p .58457 .88136 L F P
0 g
s
.726 .325 .29 r
.58547 .88083 m .58949 .87521 L p .58448 .87882 L F P
0 g
s
.563 .26 .412 r
.6278 .74297 m .61502 .74533 L .58547 .88083 L p F P
0 g
s
.563 .26 .412 r
.58547 .88083 m .58544 .88096 L p .58548 .88084 L F P
0 g
s
.563 .26 .412 r
.58548 .88084 m .6278 .74297 L .58547 .88083 L F
.674 .696 .863 r
.51447 .34951 m .54904 .39905 L .56075 .39474 L p F P
0 g
s
.686 .701 .858 r
.54904 .39905 m .51447 .34951 L .50268 .35452 L p F P
0 g
s
.819 .737 .774 r
.37957 .46828 m .37257 .45984 L .34944 .48587 L p F P
0 g
s
.819 .737 .774 r
.34944 .48587 m .35642 .49419 L .37957 .46828 L p F P
0 g
s
.682 .609 .767 r
.34182 .6299 m .37952 .65146 L .37305 .63756 L closepath p F P
0 g
s
.696 .443 .537 r
.53429 .77209 m .50474 .76944 L .50427 .77633 L p F P
0 g
s
.72 .466 .541 r
.50474 .76944 m .47324 .76609 L .47273 .77249 L p F P
0 g
s
.72 .466 .541 r
.47273 .77249 m .50427 .77633 L .50474 .76944 L p F P
0 g
s
.728 .623 .742 r
.45935 .62834 m .44852 .6034 L .42129 .61223 L p F P
0 g
s
.728 .623 .742 r
.42129 .61223 m .43134 .63525 L .45935 .62834 L p F P
0 g
s
.52 .358 .601 r
.73255 .70826 m .7294 .67475 L .70312 .64895 L p F P
0 g
s
.52 .358 .601 r
.70312 .64895 m .71113 .71802 L .73255 .70826 L p F P
0 g
s
.671 .418 .53 r
.56226 .77497 m .53429 .77209 L .5338 .77988 L p F P
0 g
s
.696 .443 .537 r
.50427 .77633 m .5338 .77988 L .53429 .77209 L p F P
0 g
s
.546 .244 .407 r
.64035 .74032 m .6278 .74297 L .59892 .87976 L p F P
0 g
s
.563 .26 .412 r
.58544 .88096 m .59892 .87976 L .6278 .74297 L p F P
0 g
s
.843 .664 .661 r
.32919 .60117 m .32856 .59967 L .32758 .60046 L p F P
0 g
s
.858 .698 .682 r
.3118 .57224 m .31039 .57411 L p .31382 .57569 L F P
0 g
s
.858 .698 .682 r
.3261 .59564 m .3118 .57224 L p .3268 .59793 L F P
0 g
s
.876 .729 .696 r
.29426 .55179 m .29055 .55931 L p .30999 .57114 L F P
0 g
s
.876 .729 .696 r
.3118 .57224 m .30983 .56994 L p .30999 .57114 L F P
0 g
s
.876 .729 .696 r
.30983 .56994 m .29426 .55179 L p .30999 .57114 L F P
0 g
s
.849 .711 .71 r
.30886 .56264 m .31395 .57575 L .33407 .52741 L F
.30675 .56559 m .30983 .56994 L p .30886 .56264 L F P
0 g
s
.876 .729 .696 r
.29055 .55931 m .30708 .57848 L .3118 .57224 L p F P
0 g
s
.849 .711 .71 r
.30983 .56994 m .31395 .57575 L p .30886 .56264 L F P
0 g
s
.849 .711 .71 r
.31395 .57575 m .31884 .58265 L .31997 .57854 L p F P
0 g
s
.849 .711 .71 r
.31997 .57854 m .33407 .52741 L p .31395 .57575 L F P
0 g
s
.858 .698 .682 r
.30708 .57848 m .3268 .59793 L .31382 .57569 L F
.31039 .57411 m .30708 .57848 L p .31382 .57569 L F P
0 g
s
.858 .698 .682 r
.32856 .59967 m .3261 .59564 L p .3268 .59793 L F P
0 g
s
.831 .685 .701 r
.32088 .57859 m .32919 .60117 L .34154 .53744 L F
.31884 .58265 m .3261 .59564 L p .32088 .57859 L F P
0 g
s
.858 .698 .682 r
.30708 .57848 m .32288 .60425 L .32856 .59967 L p F P
0 g
s
.831 .685 .701 r
.3261 .59564 m .32919 .60117 L p .32088 .57859 L F P
0 g
s
.831 .685 .701 r
.32919 .60117 m .33054 .60358 L .33082 .60189 L p F P
0 g
s
.831 .685 .701 r
.33082 .60189 m .34154 .53744 L p .32919 .60117 L F P
0 g
s
.843 .664 .661 r
.34448 .63748 m .32919 .60117 L p .32288 .60425 L F P
0 g
s
.843 .664 .661 r
.32758 .60046 m .32288 .60425 L p .32919 .60117 L F P
0 g
s
.843 .664 .661 r
.32288 .60425 m .33787 .63982 L .34448 .63748 L p F P
0 g
s
.722 .563 .674 r
.42742 .53096 m .43781 .57249 L .46501 .55924 L p F P
0 g
s
.704 .553 .679 r
.43781 .57249 m .42742 .53096 L .40188 .5454 L p F P
0 g
s
.831 .685 .701 r
.34154 .53744 m .33407 .52741 L .31884 .58265 L p F P
0 g
s
.691 .593 .742 r
.34182 .6299 m .37305 .63756 L .36667 .62162 L closepath p F P
0 g
s
.684 .567 .718 r
.34182 .6299 m .36667 .62162 L .36043 .60273 L closepath p F P
0 g
s
.651 .524 .695 r
.34182 .6299 m .36043 .60273 L .35443 .57931 L closepath p F P
0 g
s
.736 .601 .707 r
.476 .59143 m .46501 .55924 L .43781 .57249 L p F P
0 g
s
.736 .601 .707 r
.43781 .57249 m .44852 .6034 L .476 .59143 L p F P
0 g
s
.746 .489 .542 r
.47324 .76609 m .43908 .76138 L .43846 .76765 L p F P
0 g
s
.746 .489 .542 r
.43846 .76765 m .47273 .77249 L .47324 .76609 L p F P
0 g
s
.715 .614 .742 r
.43134 .63525 m .42129 .61223 L .39404 .61823 L p F P
0 g
s
.715 .614 .742 r
.39404 .61823 m .4027 .63854 L .43134 .63525 L p F P
0 g
s
.662 .692 .867 r
.52632 .34495 m .56075 .39474 L .57245 .39076 L p F P
0 g
s
.674 .696 .863 r
.56075 .39474 m .52632 .34495 L .51447 .34951 L p F P
0 g
s
.681 .542 .689 r
.38555 .59334 m .37743 .56063 L .35443 .57931 L p F P
0 g
s
.681 .542 .689 r
.35443 .57931 m .36043 .60273 L .38555 .59334 L p F P
0 g
s
.706 .601 .736 r
.4027 .63854 m .39404 .61823 L .36667 .62162 L p F P
0 g
s
.706 .601 .736 r
.36667 .62162 m .37305 .63756 L .4027 .63854 L p F P
0 g
s
.837 .733 .749 r
.35642 .49419 m .34944 .48587 L .32648 .51829 L p F P
0 g
s
.837 .733 .749 r
.32648 .51829 m .33407 .52741 L .35642 .49419 L p F P
0 g
s
.704 .553 .679 r
.40188 .5454 m .4114 .5837 L .43781 .57249 L p F P
0 g
s
.691 .545 .683 r
.4114 .5837 m .40188 .5454 L .37743 .56063 L p F P
0 g
s
.691 .545 .683 r
.37743 .56063 m .38555 .59334 L .4114 .5837 L p F P
0 g
s
.505 .397 .666 r
.74441 .62893 m .7435 .624 L .71831 .60962 L p F P
0 g
s
.505 .397 .666 r
.71831 .60962 m .71972 .61631 L .74441 .62893 L p F P
0 g
s
.306 .438 .831 r
.70994 .59299 m .71831 .60962 L .7435 .624 L p F P
0 g
s
.528 .229 .402 r
.65267 .73737 m .64035 .74032 L .61221 .87795 L p F P
0 g
s
.546 .244 .407 r
.59892 .87976 m .61221 .87795 L .64035 .74032 L p F P
0 g
s
.694 .436 .528 r
.5338 .77988 m .50427 .77633 L .50381 .78152 L p F P
0 g
s
.72 .46 .533 r
.50427 .77633 m .47273 .77249 L .47224 .77731 L p F P
0 g
s
.72 .46 .533 r
.47224 .77731 m .50381 .78152 L .50427 .77633 L p F P
0 g
s
.696 .574 .715 r
.36043 .60273 m .36667 .62162 L .39404 .61823 L p F P
0 g
s
.768 .745 .832 r
.41109 .41033 m .41951 .42017 L .4438 .40553 L p F P
0 g
s
.788 .749 .817 r
.41951 .42017 m .41109 .41033 L .38836 .42965 L p F P
0 g
s
.788 .749 .817 r
.38836 .42965 m .39588 .43821 L .41951 .42017 L p F P
0 g
s
.807 .75 .8 r
.39588 .43821 m .38836 .42965 L .36549 .45196 L p F P
0 g
s
.807 .75 .8 r
.36549 .45196 m .37257 .45984 L .39588 .43821 L p F P
0 g
s
.696 .574 .715 r
.39404 .61823 m .38555 .59334 L .36043 .60273 L p F P
0 g
s
.644 .387 .515 r
.58882 .78024 m .56226 .77497 L .56167 .78434 L p F P
0 g
s
.671 .418 .53 r
.5338 .77988 m .56167 .78434 L .56226 .77497 L p F P
0 g
s
.719 .592 .713 r
.44852 .6034 m .43781 .57249 L .4114 .5837 L p F P
0 g
s
.719 .592 .713 r
.4114 .5837 m .42129 .61223 L .44852 .6034 L p F P
0 g
s
.747 .74 .845 r
.43377 .39346 m .4438 .40553 L .4696 .39508 L p F P
0 g
s
.768 .745 .832 r
.4438 .40553 m .43377 .39346 L .41109 .41033 L p F P
0 g
s
.503 .391 .659 r
.74534 .63419 m .74441 .62893 L .71972 .61631 L p F P
0 g
s
.503 .391 .659 r
.71972 .61631 m .72116 .62346 L .74534 .63419 L p F P
0 g
s
.747 .74 .845 r
.4696 .39508 m .45646 .37871 L .43377 .39346 L p F P
0 g
s
.706 .583 .715 r
.38555 .59334 m .39404 .61823 L .42129 .61223 L p F P
0 g
s
.824 .608 .61 r
.33787 .63982 m .35026 .72155 L .35773 .72437 L p F P
0 g
s
.831 .613 .607 r
.35026 .72155 m .33787 .63982 L .33094 .64228 L p F P
0 g
s
.849 .666 .655 r
.33787 .63982 m .32288 .60425 L .31695 .60916 L p F P
0 g
s
.849 .666 .655 r
.31695 .60916 m .33094 .64228 L .33787 .63982 L p F P
0 g
s
.746 .484 .534 r
.47273 .77249 m .43846 .76765 L .43787 .77237 L p F P
0 g
s
.746 .484 .534 r
.43787 .77237 m .47224 .77731 L .47273 .77249 L p F P
0 g
s
.669 .408 .518 r
.56167 .78434 m .5338 .77988 L .53331 .78576 L p F P
0 g
s
.694 .436 .528 r
.50381 .78152 m .53331 .78576 L .5338 .77988 L p F P
0 g
s
.826 .75 .781 r
.37257 .45984 m .36549 .45196 L .34236 .47818 L p F P
0 g
s
.826 .75 .781 r
.34236 .47818 m .34944 .48587 L .37257 .45984 L p F P
0 g
s
.706 .583 .715 r
.42129 .61223 m .4114 .5837 L .38555 .59334 L p F P
0 g
s
.649 .687 .872 r
.53821 .34083 m .57245 .39076 L .58414 .38713 L p F P
0 g
s
.662 .692 .867 r
.57245 .39076 m .53821 .34083 L .52632 .34495 L p F P
0 g
s
.806 .573 .584 r
.35675 .69296 m .35773 .72437 L .40221 .73793 L p F P
0 g
s
.814 .557 .551 r
.40221 .73793 m .35773 .72437 L .35364 .75178 L p F P
0 g
s
.814 .557 .551 r
.35364 .75178 m .40091 .75474 L .40221 .73793 L p F P
0 g
s
.775 .514 .541 r
.43908 .76138 m .40091 .75474 L .4 .76139 L p F P
0 g
s
.775 .514 .541 r
.4 .76139 m .43846 .76765 L .43908 .76138 L p F P
0 g
s
.502 .384 .652 r
.7463 .63989 m .74534 .63419 L .72116 .62346 L p F P
0 g
s
.502 .384 .652 r
.72116 .62346 m .72265 .63118 L .7463 .63989 L p F P
0 g
s
.51 .212 .397 r
.66477 .73412 m .65267 .73737 L .62534 .87552 L p F P
0 g
s
.528 .229 .402 r
.61221 .87795 m .62534 .87552 L .65267 .73737 L p F P
0 g
s
.693 .429 .519 r
.53331 .78576 m .50381 .78152 L .50336 .78584 L p F P
0 g
s
.719 .455 .526 r
.50381 .78152 m .47224 .77731 L .47176 .78132 L p F P
0 g
s
.719 .455 .526 r
.47176 .78132 m .50336 .78584 L .50381 .78152 L p F P
0 g
s
.849 .711 .71 r
.33407 .52741 m .32648 .51829 L .30675 .56559 L p F P
0 g
s
.564 .573 .821 r
.63477 .38391 m .62266 .36325 L .62106 .40518 L p F P
0 g
s
.746 .479 .528 r
.47224 .77731 m .43787 .77237 L .4373 .77628 L p F P
0 g
s
.746 .479 .528 r
.4373 .77628 m .47176 .78132 L .47224 .77731 L p F P
0 g
s
.845 .748 .755 r
.34944 .48587 m .34236 .47818 L .31876 .51005 L p F P
0 g
s
.845 .748 .755 r
.31876 .51005 m .32648 .51829 L .34944 .48587 L p F P
0 g
s
.499 .376 .643 r
.74731 .64614 m .7463 .63989 L .72265 .63118 L p F P
0 g
s
.499 .376 .643 r
.72265 .63118 m .72418 .63966 L .74731 .64614 L p F P
0 g
s
.669 .408 .518 r
.53331 .78576 m .56105 .79139 L .56167 .78434 L p F P
0 g
s
.667 .4 .507 r
.56105 .79139 m .53331 .78576 L .53281 .79065 L p F P
0 g
s
.693 .429 .519 r
.50336 .78584 m .53281 .79065 L .53331 .78576 L p F P
0 g
s
.306 .438 .831 r
.7435 .624 m .73381 .60626 L .70994 .59299 L p F P
0 g
s
.285 .409 .813 r
.70144 .57505 m .70994 .59299 L .73381 .60626 L p F P
0 g
s
.693 .424 .512 r
.53281 .79065 m .50336 .78584 L .5029 .7896 L p F P
0 g
s
.719 .45 .519 r
.50336 .78584 m .47176 .78132 L .47129 .78481 L p F P
0 g
s
.719 .45 .519 r
.47129 .78481 m .5029 .7896 L .50336 .78584 L p F P
0 g
s
.831 .613 .607 r
.33094 .64228 m .34239 .71839 L .35026 .72155 L p F P
0 g
s
.839 .618 .603 r
.34239 .71839 m .33094 .64228 L .32358 .6449 L p F P
0 g
s
.855 .669 .649 r
.33094 .64228 m .31695 .60916 L .31071 .61448 L p F P
0 g
s
.855 .669 .649 r
.31071 .61448 m .32358 .6449 L .33094 .64228 L p F P
0 g
s
.636 .681 .876 r
.55017 .33715 m .58414 .38713 L .59584 .38384 L p F P
0 g
s
.649 .687 .872 r
.58414 .38713 m .55017 .33715 L .53821 .34083 L p F P
0 g
s
.644 .387 .515 r
.56167 .78434 m .58788 .79256 L .58882 .78024 L p F P
0 g
s
.641 .373 .497 r
.58788 .79256 m .56167 .78434 L .56105 .79139 L p F P
0 g
s
.775 .509 .533 r
.43846 .76765 m .4 .76139 L .39915 .76634 L p F P
0 g
s
.775 .509 .533 r
.39915 .76634 m .43787 .77237 L .43846 .76765 L p F P
0 g
s
.863 .698 .675 r
.32288 .60425 m .30708 .57848 L .30221 .5852 L p F P
0 g
s
.863 .698 .675 r
.30221 .5852 m .31695 .60916 L .32288 .60425 L p F P
0 g
s
.49 .195 .391 r
.67667 .73056 m .66477 .73412 L .6383 .87249 L p F P
0 g
s
.51 .212 .397 r
.62534 .87552 m .6383 .87249 L .66477 .73412 L p F P
0 g
s
.746 .475 .522 r
.47176 .78132 m .4373 .77628 L .43675 .77967 L p F P
0 g
s
.746 .475 .522 r
.43675 .77967 m .47129 .78481 L .47176 .78132 L p F P
0 g
s
.496 .367 .634 r
.74836 .65318 m .74731 .64614 L .72418 .63966 L p F P
0 g
s
.496 .367 .634 r
.72418 .63966 m .72578 .6492 L .74836 .65318 L p F P
0 g
s
.794 .763 .825 r
.38074 .42167 m .38836 .42965 L .41109 .41033 L p F P
0 g
s
.813 .764 .807 r
.38836 .42965 m .38074 .42167 L .35831 .44465 L p F P
0 g
s
.813 .764 .807 r
.35831 .44465 m .36549 .45196 L .38836 .42965 L p F P
0 g
s
.833 .764 .787 r
.36549 .45196 m .35831 .44465 L .33517 .47111 L p F P
0 g
s
.833 .764 .787 r
.33517 .47111 m .34236 .47818 L .36549 .45196 L p F P
0 g
s
.775 .762 .841 r
.40256 .40119 m .41109 .41033 L .43377 .39346 L p F P
0 g
s
.794 .763 .825 r
.41109 .41033 m .40256 .40119 L .38074 .42167 L p F P
0 g
s
.667 .4 .507 r
.53281 .79065 m .56042 .79722 L .56105 .79139 L p F P
0 g
s
.666 .393 .498 r
.56042 .79722 m .53281 .79065 L .53231 .79489 L p F P
0 g
s
.693 .424 .512 r
.5029 .7896 m .53231 .79489 L .53281 .79065 L p F P
0 g
s
.692 .419 .505 r
.53231 .79489 m .5029 .7896 L .50245 .79296 L p F P
0 g
s
.718 .446 .514 r
.5029 .7896 m .47129 .78481 L .47082 .78792 L p F P
0 g
s
.718 .446 .514 r
.47082 .78792 m .50245 .79296 L .5029 .7896 L p F P
0 g
s
.776 .505 .526 r
.43787 .77237 m .39915 .76634 L .39833 .77042 L p F P
0 g
s
.776 .505 .526 r
.39833 .77042 m .4373 .77628 L .43787 .77237 L p F P
0 g
s
.745 .472 .517 r
.47129 .78481 m .43675 .77967 L .4362 .7827 L p F P
0 g
s
.745 .472 .517 r
.4362 .7827 m .47082 .78792 L .47129 .78481 L p F P
0 g
s
.865 .737 .719 r
.32648 .51829 m .31876 .51005 L .29426 .55179 L p F P
0 g
s
.865 .737 .719 r
.29426 .55179 m .30675 .56559 L .32648 .51829 L p F P
0 g
s
.492 .355 .623 r
.74951 .66146 m .74836 .65318 L .72578 .6492 L p F P
0 g
s
.492 .355 .623 r
.72578 .6492 m .72748 .66039 L .74951 .66146 L p F P
0 g
s
.47 .177 .385 r
.68836 .7267 m .67667 .73056 L .65109 .86886 L p F P
0 g
s
.49 .195 .391 r
.6383 .87249 m .65109 .86886 L .67667 .73056 L p F P
0 g
s
.756 .76 .856 r
.42358 .38237 m .43377 .39346 L .45646 .37871 L p F P
0 g
s
.775 .762 .841 r
.43377 .39346 m .42358 .38237 L .40256 .40119 L p F P
0 g
s
.636 .681 .876 r
.59584 .38384 m .56219 .33392 L .55017 .33715 L p F P
0 g
s
.869 .699 .668 r
.31695 .60916 m .30221 .5852 L .29714 .59251 L p F P
0 g
s
.869 .699 .668 r
.29714 .59251 m .31071 .61448 L .31695 .60916 L p F P
0 g
s
.641 .373 .497 r
.56105 .79139 m .58687 .80174 L .58788 .79256 L p F P
0 g
s
.639 .361 .481 r
.58687 .80174 m .56105 .79139 L .56042 .79722 L p F P
0 g
s
.692 .419 .505 r
.50245 .79296 m .53181 .79868 L .53231 .79489 L p F P
0 g
s
.691 .414 .499 r
.53181 .79868 m .50245 .79296 L .502 .79602 L p F P
0 g
s
.718 .442 .508 r
.50245 .79296 m .47082 .78792 L .47036 .79076 L p F P
0 g
s
.718 .442 .508 r
.47036 .79076 m .502 .79602 L .50245 .79296 L p F P
0 g
s
.854 .763 .762 r
.34236 .47818 m .33517 .47111 L .31091 .50269 L p F P
0 g
s
.854 .763 .762 r
.31091 .50269 m .31876 .51005 L .34236 .47818 L p F P
0 g
s
.285 .409 .813 r
.73381 .60626 m .72394 .58703 L .70144 .57505 L p F P
0 g
s
.263 .377 .792 r
.69281 .55548 m .70144 .57505 L .72394 .58703 L p F P
0 g
s
.666 .393 .498 r
.53231 .79489 m .55977 .80228 L .56042 .79722 L p F P
0 g
s
.665 .386 .489 r
.55977 .80228 m .53231 .79489 L .53181 .79868 L p F P
0 g
s
.839 .618 .603 r
.32358 .6449 m .33403 .71481 L .34239 .71839 L p F P
0 g
s
.847 .624 .599 r
.33403 .71481 m .32358 .6449 L .31569 .64773 L p F P
0 g
s
.863 .671 .642 r
.32358 .6449 m .31071 .61448 L .30408 .62034 L p F P
0 g
s
.863 .671 .642 r
.30408 .62034 m .31569 .64773 L .32358 .6449 L p F P
0 g
s
.745 .469 .512 r
.47082 .78792 m .4362 .7827 L .43566 .78545 L p F P
0 g
s
.745 .469 .512 r
.43566 .78545 m .47036 .79076 L .47082 .78792 L p F P
0 g
s
.817 .551 .536 r
.40091 .75474 m .35364 .75178 L .35044 .7616 L p F P
0 g
s
.817 .551 .536 r
.35044 .7616 m .4 .76139 L .40091 .75474 L p F P
0 g
s
.776 .502 .521 r
.4373 .77628 m .39833 .77042 L .39754 .77394 L p F P
0 g
s
.776 .502 .521 r
.39754 .77394 m .43675 .77967 L .4373 .77628 L p F P
0 g
s
.202 .208 .642 r
.67079 .44002 m .6588 .38277 L .64681 .40647 L p F P
0 g
s
.202 .208 .642 r
.64681 .40647 m .65651 .44781 L .67079 .44002 L p F P
0 g
s
.568 .601 .846 r
.63477 .38391 m .64681 .40647 L .6588 .38277 L p F P
0 g
s
.691 .414 .499 r
.502 .79602 m .53131 .80213 L .53181 .79868 L p F P
0 g
s
.69 .41 .493 r
.53131 .80213 m .502 .79602 L .50155 .79884 L p F P
0 g
s
.717 .439 .503 r
.502 .79602 m .47036 .79076 L .47024 .79143 L p F P
0 g
s
.717 .439 .503 r
.483 .79445 m .502 .79602 L .47024 .79143 L F
.4699 .79337 m .50155 .79884 L .502 .79602 L p F P
0 g
s
.69 .41 .493 r
.50155 .79884 m .5308 .8053 L .53131 .80213 L p F P
0 g
s
.057 .578 .872 r
.5308 .8053 m .50159 .79885 L p .49049 .79386 L F P
0 g
s
.057 .578 .872 r
.50159 .79885 m .50155 .79884 L .50154 .79884 L p F P
0 g
s
.057 .578 .872 r
.50154 .79884 m .49049 .79386 L p .50159 .79885 L F P
0 g
s
.717 .439 .503 r
.47024 .79143 m .4699 .79337 L p .483 .79445 L F P
0 g
s
.745 .466 .507 r
.47036 .79076 m .43566 .78545 L .4354 .78666 L p F P
0 g
s
.745 .466 .507 r
.44701 .78891 m .47036 .79076 L .4354 .78666 L F
.43513 .78797 m .4699 .79337 L .47036 .79076 L p F P
0 g
s
.25 .698 .957 r
.50155 .79884 m .47045 .79346 L p .45947 .78877 L F P
0 g
s
.25 .698 .957 r
.47045 .79346 m .4699 .79337 L .46986 .79335 L p F P
0 g
s
.25 .698 .957 r
.46986 .79335 m .45947 .78877 L p .47045 .79346 L F P
0 g
s
.745 .466 .507 r
.4354 .78666 m .43513 .78797 L p .44701 .78891 L F P
0 g
s
.486 .34 .608 r
.75083 .6721 m .74951 .66146 L .72748 .66039 L p F P
0 g
s
.486 .34 .608 r
.72748 .66039 m .7294 .67475 L .75083 .6721 L p F P
0 g
s
.665 .386 .489 r
.53181 .79868 m .55912 .80678 L .55977 .80228 L p F P
0 g
s
.663 .38 .481 r
.55912 .80678 m .53181 .79868 L .53131 .80213 L p F P
0 g
s
.735 .759 .871 r
.44305 .36399 m .45646 .37871 L .47922 .36586 L p F P
0 g
s
.756 .76 .856 r
.45646 .37871 m .44305 .36399 L .42358 .38237 L p F P
0 g
s
.777 .499 .516 r
.43675 .77967 m .39754 .77394 L .39675 .77705 L p F P
0 g
s
.777 .499 .516 r
.39675 .77705 m .4362 .7827 L .43675 .77967 L p F P
0 g
s
.448 .158 .379 r
.69984 .72253 m .68836 .7267 L .66372 .8646 L p F P
0 g
s
.47 .177 .385 r
.65109 .86886 m .66372 .8646 L .68836 .7267 L p F P
0 g
s
.639 .361 .481 r
.56042 .79722 m .58582 .80929 L .58687 .80174 L p F P
0 g
s
.637 .35 .467 r
.58582 .80929 m .56042 .79722 L .55977 .80228 L p F P
0 g
s
.25 .698 .957 r
.45947 .78877 m .49049 .79386 L .50155 .79884 L p F P
0 g
s
.801 .778 .832 r
.37302 .4143 m .38074 .42167 L .40256 .40119 L p F P
0 g
s
.82 .778 .814 r
.38074 .42167 m .37302 .4143 L .35103 .4379 L p F P
0 g
s
.82 .778 .814 r
.35103 .4379 m .35831 .44465 L .38074 .42167 L p F P
0 g
s
.84 .778 .793 r
.35831 .44465 m .35103 .4379 L .32788 .46468 L p F P
0 g
s
.84 .778 .793 r
.32788 .46468 m .33517 .47111 L .35831 .44465 L p F P
0 g
s
.777 .494 .506 r
.43566 .78545 m .39598 .77985 L .39568 .78084 L p F P
0 g
s
.777 .494 .506 r
.39568 .78084 m .39521 .78242 L p .41099 .7836 L F P
0 g
s
.777 .494 .506 r
.41099 .7836 m .43566 .78545 L .39568 .78084 L F
.39521 .78242 m .43513 .78797 L .43566 .78545 L p F P
0 g
s
.35 .754 .983 r
.4699 .79337 m .43638 .78816 L p .4259 .78441 L F P
0 g
s
.35 .754 .983 r
.43638 .78816 m .43513 .78797 L .43498 .78791 L p F P
0 g
s
.35 .754 .983 r
.43498 .78791 m .4259 .78441 L p .43638 .78816 L F P
0 g
s
.35 .754 .983 r
.4259 .78441 m .45947 .78877 L .4699 .79337 L p F P
0 g
s
.876 .699 .659 r
.31071 .61448 m .29714 .59251 L .29183 .60059 L p F P
0 g
s
.876 .699 .659 r
.29183 .60059 m .30408 .62034 L .31071 .61448 L p F P
0 g
s
.821 .549 .527 r
.4 .76139 m .35044 .7616 L .34738 .7684 L p F P
0 g
s
.821 .549 .527 r
.34738 .7684 m .39915 .76634 L .4 .76139 L p F P
0 g
s
.263 .377 .792 r
.72394 .58703 m .71386 .56588 L .69281 .55548 L p F P
0 g
s
.241 .343 .768 r
.68402 .53382 m .69281 .55548 L .71386 .56588 L p F P
0 g
s
.777 .496 .511 r
.4362 .7827 m .39675 .77705 L .39598 .77985 L p F P
0 g
s
.777 .496 .511 r
.39598 .77985 m .43566 .78545 L .4362 .7827 L p F P
0 g
s
.663 .38 .481 r
.53131 .80213 m .55846 .81086 L .55912 .80678 L p F P
0 g
s
.662 .374 .473 r
.55846 .81086 m .53131 .80213 L .5308 .8053 L p F P
0 g
s
.881 .728 .687 r
.30708 .57848 m .29055 .55931 L .28679 .56741 L p F P
0 g
s
.881 .728 .687 r
.28679 .56741 m .30221 .5852 L .30708 .57848 L p F P
0 g
s
.782 .779 .85 r
.3939 .39277 m .40256 .40119 L .42358 .38237 L p F P
0 g
s
.801 .778 .832 r
.40256 .40119 m .3939 .39277 L .37302 .4143 L p F P
0 g
s
.832 .539 .494 r
.35773 .72437 m .35026 .72155 L .3297 .7768 L p F P
0 g
s
.836 .551 .506 r
.39675 .77705 m .39093 .77745 L p .33557 .78376 L F P
0 g
s
.836 .551 .506 r
.39093 .77745 m .33849 .78104 L .33609 .78328 L p F P
0 g
s
.836 .551 .506 r
.33609 .78328 m .33557 .78376 L p .39093 .77745 L F P
0 g
s
.832 .539 .494 r
.3297 .7768 m .33602 .78328 L p .35773 .72437 L F P
0 g
s
.832 .539 .494 r
.33602 .78328 m .33607 .78333 L .33609 .78328 L p F P
0 g
s
.832 .539 .494 r
.33609 .78328 m .35773 .72437 L p .33602 .78328 L F P
0 g
s
.881 .764 .728 r
.31876 .51005 m .31091 .50269 L .28135 .5411 L p F P
0 g
s
.881 .764 .728 r
.28135 .5411 m .29426 .55179 L .31876 .51005 L p F P
0 g
s
.847 .624 .599 r
.31569 .64773 m .32502 .71066 L .33403 .71481 L p F P
0 g
s
.857 .631 .594 r
.32502 .71066 m .31569 .64773 L .30703 .65085 L p F P
0 g
s
.871 .674 .633 r
.31569 .64773 m .30408 .62034 L .29689 .62696 L p F P
0 g
s
.871 .674 .633 r
.29689 .62696 m .30703 .65085 L .31569 .64773 L p F P
0 g
s
.447 .545 .863 r
.73381 .60626 m .7435 .624 L .7651 .62404 L p F P
0 g
s
.469 .355 .642 r
.76581 .6281 m .7651 .62404 L .7435 .624 L p F P
0 g
s
.469 .355 .642 r
.7435 .624 m .74441 .62893 L .76581 .6281 L p F P
0 g
s
.863 .779 .767 r
.33517 .47111 m .32788 .46468 L .30291 .49621 L p F P
0 g
s
.863 .779 .767 r
.30291 .49621 m .31091 .50269 L .33517 .47111 L p F P
0 g
s
.637 .35 .467 r
.55977 .80228 m .58474 .81578 L .58582 .80929 L p F P
0 g
s
.635 .341 .453 r
.58474 .81578 m .55977 .80228 L .55912 .80678 L p F P
0 g
s
.735 .759 .871 r
.47922 .36586 m .45374 .3389 L .44305 .36399 L p F P
0 g
s
.744 .787 .888 r
.42934 .35096 m .44305 .36399 L .45374 .3389 L p F P
0 g
s
.731 .871 .947 r
.44286 .32953 m .45453 .32313 L p .45227 .32241 L F P
0 g
s
.744 .787 .888 r
.4271 .31826 m .42789 .32981 L p .4287 .32957 L F P
0 g
s
.744 .787 .888 r
.44707 .33374 m .4271 .31826 L p .43159 .34985 L F P
0 g
s
.729 .816 .918 r
.41529 .33973 m .42934 .35096 L .42789 .32981 L p F P
0 g
s
.729 .816 .918 r
.42789 .32981 m .4271 .31826 L p .41774 .33527 L F P
0 g
s
.729 .816 .918 r
.41529 .33973 m .42789 .32981 L .41774 .33527 L F
.731 .871 .947 r
.44562 .32029 m .43803 .32674 L .45227 .32241 L F
.729 .816 .918 r
.39897 .30546 m .40011 .30787 L p .40041 .30775 L F P
0 g
s
.729 .816 .918 r
.40982 .3104 m .39897 .30546 L p .41774 .33527 L F P
0 g
s
.655 .838 .97 r
.40084 .33048 m .41529 .33973 L .40011 .30787 L p F P
0 g
s
.655 .838 .97 r
.40011 .30787 m .39897 .30546 L p .3992 .3086 L F P
0 g
s
.655 .838 .97 r
.40084 .33048 m .40011 .30787 L .3992 .3086 L F
.66 .964 .927 r
.4087 .30097 m .40228 .30697 L .41558 .30016 L F
.999 .84 .523 r
.38901 .34943 m .40084 .33048 L .37492 .30927 L p F P
0 g
s
.999 .84 .523 r
.37492 .30927 m .36878 .30424 L .37034 .30774 L p F P
0 g
s
.999 .84 .523 r
.37034 .30774 m .38901 .34943 L p .37492 .30927 L F P
0 g
s
.655 .838 .97 r
.39897 .30546 m .36878 .30424 L .40084 .33048 L p F P
0 g
s
.995 .861 .581 r
.3772 .36058 m .38901 .34943 L .37034 .30774 L p F P
0 g
s
.995 .861 .581 r
.37034 .30774 m .36878 .30424 L .36926 .30747 L p F P
0 g
s
.995 .861 .581 r
.36926 .30747 m .3772 .36058 L p .37034 .30774 L F P
0 g
s
.987 .866 .628 r
.36535 .36649 m .3772 .36058 L .36878 .30424 L closepath p F P
0 g
s
.976 .858 .657 r
.35342 .36868 m .36535 .36649 L .36878 .30424 L closepath p F P
0 g
s
.966 .843 .67 r
.34139 .36812 m .35342 .36868 L .36804 .30735 L p F P
0 g
s
.966 .843 .67 r
.36804 .30735 m .36878 .30424 L .36744 .30737 L p F P
0 g
s
.966 .843 .67 r
.36744 .30737 m .34139 .36812 L p .36804 .30735 L F P
0 g
s
.958 .827 .672 r
.32925 .36547 m .34139 .36812 L .36744 .30737 L p F P
0 g
s
.958 .827 .672 r
.36744 .30737 m .36878 .30424 L .36673 .30741 L p F P
0 g
s
.958 .827 .672 r
.36673 .30741 m .32925 .36547 L p .36744 .30737 L F P
0 g
s
.952 .813 .669 r
.31696 .36115 m .32925 .36547 L .36673 .30741 L p F P
0 g
s
.952 .813 .669 r
.36673 .30741 m .36878 .30424 L .36583 .30748 L p F P
0 g
s
.952 .813 .669 r
.36583 .30748 m .31696 .36115 L p .36673 .30741 L F P
0 g
s
.948 .801 .664 r
.30454 .35549 m .31696 .36115 L .36583 .30748 L p F P
0 g
s
.948 .801 .664 r
.36583 .30748 m .36878 .30424 L .36456 .3076 L p F P
0 g
s
.948 .801 .664 r
.36456 .3076 m .30454 .35549 L p .36583 .30748 L F P
0 g
s
.888 .842 .794 r
.30454 .35549 m .2775 .38754 L p .30502 .36913 L F P
0 g
s
.888 .842 .794 r
.30502 .36913 m .30625 .36517 L .30454 .35549 L F
.683 .307 .328 r
.33316 .33266 m .33358 .33232 L p .33244 .33332 L F P
0 g
s
.888 .842 .794 r
.30675 .36798 m .30788 .36636 L .30454 .35549 L F
.30788 .36636 m .31122 .35877 L .30454 .35549 L F
.31279 .35925 m .31131 .35857 L p .31266 .35948 L F P
0 g
s
.888 .842 .794 r
.31131 .35857 m .30454 .35549 L p .31122 .35877 L F P
0 g
s
.888 .842 .794 r
.31266 .35948 m .31131 .35857 L .31122 .35877 L F
.683 .307 .328 r
.32326 .34131 m .33316 .33266 L .33244 .33332 L F
.30246 .35941 m .32329 .34126 L .32326 .34131 L F
.32329 .34126 m .33316 .33266 L .32326 .34131 L F
.30246 .35941 m .30454 .35549 L .33316 .33266 L p F P
0 g
s
.683 .307 .328 r
.33358 .33232 m .34241 .32528 L p .33222 .33398 L F P
0 g
s
.683 .307 .328 r
.30246 .35941 m .33358 .33232 L .33222 .33398 L F
.34241 .32528 m .35108 .31836 L p .34046 .32732 L F P
0 g
s
.683 .307 .328 r
.30246 .35941 m .34241 .32528 L .34046 .32732 L F
.35108 .31836 m .35981 .31139 L p .34797 .3213 L F P
0 g
s
.683 .307 .328 r
.30246 .35941 m .35108 .31836 L .34797 .3213 L F
.35981 .31139 m .36456 .3076 L p .356 .31474 L F P
0 g
s
.683 .307 .328 r
.30246 .35941 m .35981 .31139 L .356 .31474 L F
.36456 .3076 m .36878 .30424 L p .36484 .30752 L F P
0 g
s
.683 .307 .328 r
.30246 .35941 m .36456 .3076 L .36484 .30752 L F
.36878 .30424 m .36218 .30618 L .31015 .35255 L p F P
0 g
s
.683 .307 .328 r
.31015 .35255 m .30246 .35941 L p .30996 .35317 L F P
0 g
s
.683 .307 .328 r
.30996 .35317 m .36878 .30424 L .31015 .35255 L F
.652 .282 .33 r
.30032 .36383 m .30246 .35941 L .3244 .33985 L p F P
0 g
s
.652 .282 .33 r
.3244 .33985 m .3615 .30679 L p .32184 .34378 L F P
0 g
s
.652 .282 .33 r
.32184 .34378 m .3615 .30679 L .36154 .30678 L F
.30032 .36383 m .3244 .33985 L .32184 .34378 L F
.35884 .3093 m .36154 .30678 L .35885 .30928 L F
.3615 .30679 m .36218 .30618 L p .36154 .30678 L F P
0 g
s
.652 .282 .33 r
.36154 .30678 m .36218 .30618 L .36154 .30678 L F
.36154 .30678 m .36154 .30678 L .31506 .35005 L F
.35542 .30921 m .3157 .34858 L p .36153 .30677 L F P
0 g
s
.652 .282 .33 r
.36218 .30618 m .3612 .30662 L p .36153 .30677 L F P
0 g
s
.652 .282 .33 r
.3612 .30662 m .35542 .30921 L p .36153 .30677 L F P
0 g
s
.652 .282 .33 r
.31506 .35005 m .36218 .30618 L .3157 .34858 L F
.66 .964 .927 r
.36116 .30661 m .36715 .30667 L .36543 .3061 L F
.36103 .30662 m .3612 .30662 L p .36116 .30661 L F P
0 g
s
.66 .964 .927 r
.3612 .30662 m .36715 .30667 L p .36116 .30661 L F P
0 g
s
.66 .964 .927 r
.36241 .30578 m .3611 .30658 L p .36251 .30645 L F P
0 g
s
.66 .964 .927 r
.36116 .30661 m .36251 .30645 L .3611 .30658 L F
.36251 .30645 m .36426 .30624 L .3636 .30608 L F
.36251 .30645 m .3636 .30608 L .36241 .30578 L F
.36543 .3061 m .36912 .30619 L .37187 .30534 L F
.41558 .30016 m .37275 .29951 L .36241 .30578 L p F P
0 g
s
.66 .964 .927 r
.36426 .30624 m .41558 .30016 L .36241 .30578 L F
.36715 .30667 m .40124 .30696 L p .36543 .3061 L F P
0 g
s
.871 .882 .841 r
.28701 .43119 m .3019 .43698 L .32111 .40753 L p F P
0 g
s
.916 .868 .777 r
.30676 .40268 m .32111 .40753 L .34139 .36812 L p F P
0 g
s
.871 .882 .841 r
.32111 .40753 m .30676 .40268 L .28701 .43119 L p F P
0 g
s
.916 .868 .777 r
.34139 .36812 m .32925 .36547 L .30676 .40268 L p F P
0 g
s
.171 0 .088 r
.30573 .42193 m .36098 .30672 L p .37275 .29951 L F P
0 g
s
.171 0 .088 r
.36098 .30672 m .36103 .30662 L .3611 .30658 L p F P
0 g
s
.66 .964 .927 r
.3611 .30658 m .36103 .30662 L p .36116 .30661 L F P
0 g
s
.171 0 .088 r
.3611 .30658 m .37275 .29951 L p .36098 .30672 L F P
0 g
s
.652 .282 .33 r
.31502 .35013 m .35884 .3093 L .31506 .35005 L F
.35884 .3093 m .35885 .30928 L .31506 .35005 L F
.888 .842 .794 r
.30788 .36636 m .31266 .35948 L .31122 .35877 L F
.31281 .35926 m .31279 .35925 L p .31266 .35948 L F P
0 g
s
.652 .282 .33 r
.30252 .36178 m .31502 .35013 L .30135 .36281 L F
.31502 .35013 m .31506 .35005 L .30135 .36281 L F
.3157 .34858 m .30135 .36281 L p .31506 .35005 L F P
0 g
s
.652 .282 .33 r
.30135 .36281 m .30032 .36383 L p .30252 .36178 L F P
0 g
s
.618 .256 .333 r
.29813 .36887 m .30032 .36383 L .35542 .30921 L p F P
0 g
s
.618 .256 .333 r
.35542 .30921 m .34849 .3136 L .32164 .34307 L p F P
0 g
s
.618 .256 .333 r
.32005 .34597 m .35542 .30921 L .32164 .34307 L F
.888 .842 .794 r
.30502 .36913 m .30675 .36798 L .30625 .36517 L F
.31696 .36115 m .31281 .35926 L p .30675 .36798 L F P
0 g
s
.618 .256 .333 r
.32164 .34307 m .30022 .36657 L p .32005 .34597 L F P
0 g
s
.618 .256 .333 r
.30149 .36537 m .35542 .30921 L .30022 .36657 L F
.30022 .36657 m .29813 .36887 L p .30149 .36537 L F P
0 g
s
.58 .229 .338 r
.29586 .37473 m .29813 .36887 L .34849 .3136 L p F P
0 g
s
.58 .229 .338 r
.34849 .3136 m .34133 .31974 L .29907 .37085 L p F P
0 g
s
.58 .229 .338 r
.30046 .36939 m .34849 .3136 L .29907 .37085 L F
.29907 .37085 m .29586 .37473 L p .30046 .36939 L F P
0 g
s
.888 .842 .794 r
.29223 .39587 m .31696 .36115 L p .30675 .36798 L F P
0 g
s
.888 .842 .794 r
.2775 .38754 m .2886 .39382 L p .30675 .36798 L F P
0 g
s
.888 .842 .794 r
.2886 .39382 m .29223 .39587 L p .30675 .36798 L F P
0 g
s
.54 .204 .346 r
.29348 .38174 m .29586 .37473 L .34133 .31974 L p F P
0 g
s
.54 .204 .346 r
.29944 .37402 m .33354 .32983 L .2979 .3759 L F
.33354 .32983 m .34133 .31974 L .3337 .32961 L F
.33354 .32983 m .3337 .32961 L .2979 .3759 L F
.3339 .32832 m .2979 .3759 L p .33097 .33314 L F P
0 g
s
.499 .181 .359 r
.3339 .32832 m .32608 .34067 L .29679 .38224 L p F P
0 g
s
.499 .181 .359 r
.29679 .38224 m .29095 .39053 L p .29851 .37958 L F P
0 g
s
.499 .181 .359 r
.29851 .37958 m .3339 .32832 L .29679 .38224 L F
.54 .204 .346 r
.34133 .31974 m .33602 .32588 L p .33097 .33314 L F P
0 g
s
.54 .204 .346 r
.33602 .32588 m .3339 .32832 L p .33097 .33314 L F P
0 g
s
.54 .204 .346 r
.2979 .3759 m .29348 .38174 L p .29944 .37402 L F P
0 g
s
.66 .964 .927 r
.37187 .30534 m .37713 .30638 L .4087 .30097 L F
.36912 .30619 m .37713 .30638 L .37187 .30534 L F
.37713 .30638 m .37869 .30642 L .38095 .30601 L F
.37713 .30638 m .38095 .30601 L .4087 .30097 L F
.37869 .30642 m .38228 .3065 L .3853 .30587 L F
.37869 .30642 m .3853 .30587 L .4087 .30097 L F
.38228 .3065 m .3967 .30685 L .39944 .30551 L F
.38228 .3065 m .39944 .30551 L .4087 .30097 L F
.3967 .30685 m .40124 .30696 L .40149 .30677 L F
.3967 .30685 m .40149 .30677 L .4087 .30097 L F
.40124 .30696 m .40228 .30697 L p .4087 .30097 L F P
0 g
s
.66 .964 .927 r
.40228 .30697 m .40392 .30698 L .40797 .30461 L p F P
0 g
s
.66 .964 .927 r
.40797 .30461 m .41558 .30016 L p .40228 .30697 L F P
0 g
s
.729 .816 .918 r
.41529 .33973 m .41774 .33527 L .40041 .30775 L F
.40011 .30787 m .41529 .33973 L p .40041 .30775 L F P
0 g
s
.729 .816 .918 r
.4271 .31826 m .40982 .3104 L p .41774 .33527 L F P
0 g
s
.731 .871 .947 r
.40927 .30869 m .43591 .32551 L .44562 .32029 L F
.40392 .30698 m .40982 .3104 L p .40927 .30869 L F P
0 g
s
.731 .871 .947 r
.40982 .3104 m .43591 .32551 L p .40927 .30869 L F P
0 g
s
.731 .871 .947 r
.43591 .32551 m .43803 .32674 L p .44562 .32029 L F P
0 g
s
.731 .871 .947 r
.43803 .32674 m .44286 .32953 L p .45227 .32241 L F P
0 g
s
.744 .787 .888 r
.42934 .35096 m .43159 .34985 L .4287 .32957 L F
.42789 .32981 m .42934 .35096 L p .4287 .32957 L F P
0 g
s
.744 .787 .888 r
.45374 .3389 m .44707 .33374 L p .43159 .34985 L F P
0 g
s
.723 .778 .897 r
.47922 .36586 m .49093 .35996 L p .44799 .33278 L F P
0 g
s
.723 .778 .897 r
.44286 .32953 m .44707 .33374 L p .44799 .33278 L F P
0 g
s
.723 .778 .897 r
.44707 .33374 m .47922 .36586 L p .44799 .33278 L F P
0 g
s
.662 .374 .473 r
.5308 .8053 m .55779 .81461 L .55846 .81086 L p F P
0 g
s
.291 0 0 r
.55779 .81461 m .5308 .8053 L .51965 .80061 L p F P
0 g
s
.057 .578 .872 r
.49049 .79386 m .51965 .80061 L .5308 .8053 L p F P
0 g
s
.425 .138 .372 r
.71113 .71802 m .69984 .72253 L .67617 .85972 L p F P
0 g
s
.448 .158 .379 r
.66372 .8646 m .67617 .85972 L .69984 .72253 L p F P
0 g
s
.473 .308 .576 r
.75316 .69709 m .75083 .6721 L .7294 .67475 L p F P
0 g
s
.473 .308 .576 r
.7294 .67475 m .73255 .70826 L .75316 .69709 L p F P
0 g
s
.466 .349 .636 r
.76653 .63243 m .76581 .6281 L .74441 .62893 L p F P
0 g
s
.466 .349 .636 r
.74441 .62893 m .74534 .63419 L .76653 .63243 L p F P
0 g
s
.825 .549 .521 r
.39915 .76634 m .34738 .7684 L .34438 .77358 L p F P
0 g
s
.825 .549 .521 r
.34438 .77358 m .39833 .77042 L .39915 .76634 L p F P
0 g
s
.197 .236 .676 r
.68211 .48174 m .67079 .44002 L .65651 .44781 L p F P
0 g
s
.197 .236 .676 r
.65651 .44781 m .6659 .48126 L .68211 .48174 L p F P
0 g
s
.241 .343 .768 r
.71386 .56588 m .70356 .54212 L .68402 .53382 L p F P
0 g
s
.221 .307 .74 r
.67505 .50941 m .68402 .53382 L .70356 .54212 L p F P
0 g
s
.839 .548 .496 r
.35026 .72155 m .34239 .71839 L .32306 .76962 L p F P
0 g
s
.839 .548 .496 r
.32306 .76962 m .3297 .7768 L .35026 .72155 L p F P
0 g
s
.886 .726 .678 r
.30221 .5852 m .28679 .56741 L .28296 .57624 L p F P
0 g
s
.886 .726 .678 r
.28296 .57624 m .29714 .59251 L .30221 .5852 L p F P
0 g
s
.839 .552 .502 r
.33267 .78598 m .39521 .78242 L .39598 .77985 L p F P
0 g
s
.414 .796 .991 r
.43513 .78797 m .39521 .78242 L .38812 .78071 L p F P
0 g
s
.414 .796 .991 r
.38812 .78071 m .4259 .78441 L .43513 .78797 L p F P
0 g
s
.463 .342 .63 r
.76728 .63711 m .76653 .63243 L .74534 .63419 L p F P
0 g
s
.463 .342 .63 r
.74534 .63419 m .7463 .63989 L .76728 .63711 L p F P
0 g
s
.883 .699 .648 r
.30408 .62034 m .29183 .60059 L .28618 .60977 L p F P
0 g
s
.883 .699 .648 r
.28618 .60977 m .29689 .62696 L .30408 .62034 L p F P
0 g
s
.763 .781 .867 r
.41321 .37226 m .42358 .38237 L .44305 .36399 L p F P
0 g
s
.782 .779 .85 r
.42358 .38237 m .41321 .37226 L .3939 .39277 L p F P
0 g
s
.71 .775 .903 r
.45453 .32313 m .49093 .35996 L .50268 .35452 L p F P
0 g
s
.723 .778 .897 r
.49093 .35996 m .45453 .32313 L .44286 .32953 L p F P
0 g
s
.635 .341 .453 r
.55912 .80678 m .58364 .82152 L .58474 .81578 L p F P
0 g
s
.634 .332 .441 r
.58364 .82152 m .55912 .80678 L .55846 .81086 L p F P
0 g
s
.221 .307 .74 r
.70356 .54212 m .693 .51467 L .67505 .50941 L p F P
0 g
s
.205 .27 .709 r
.6659 .48126 m .67505 .50941 L .693 .51467 L p F P
0 g
s
.568 .601 .846 r
.6588 .38277 m .64974 .36679 L .63477 .38391 L p F P
0 g
s
.569 .624 .867 r
.62266 .36325 m .63477 .38391 L .64974 .36679 L p F P
0 g
s
.205 .27 .709 r
.693 .51467 m .68211 .48174 L .6659 .48126 L p F P
0 g
s
.829 .549 .515 r
.39833 .77042 m .34438 .77358 L .34142 .77771 L p F P
0 g
s
.829 .549 .515 r
.34142 .77771 m .39754 .77394 L .39833 .77042 L p F P
0 g
s
.459 .334 .623 r
.76807 .64226 m .76728 .63711 L .7463 .63989 L p F P
0 g
s
.459 .334 .623 r
.7463 .63989 m .74731 .64614 L .76807 .64226 L p F P
0 g
s
.827 .793 .82 r
.34364 .43174 m .35103 .4379 L .37302 .4143 L p F P
0 g
s
.848 .794 .798 r
.35103 .4379 m .34364 .43174 L .32048 .45889 L p F P
0 g
s
.848 .794 .798 r
.32048 .45889 m .32788 .46468 L .35103 .4379 L p F P
0 g
s
.807 .794 .84 r
.36518 .40753 m .37302 .4143 L .3939 .39277 L p F P
0 g
s
.827 .793 .82 r
.37302 .4143 m .36518 .40753 L .34364 .43174 L p F P
0 g
s
.847 .558 .499 r
.34239 .71839 m .33403 .71481 L .3161 .76163 L p F P
0 g
s
.847 .558 .499 r
.3161 .76163 m .32306 .76962 L .34239 .71839 L p F P
0 g
s
.552 .334 .537 r
.73255 .70826 m .71113 .71802 L .71041 .7796 L p F P
0 g
s
.656 .354 .448 r
.69611 .84031 m .69198 .84848 L p .71723 .8022 L F P
0 g
s
.656 .354 .448 r
.71723 .8022 m .72949 .77975 L .71573 .8047 L F
.71723 .8022 m .71573 .8047 L .69611 .84031 L F
.69198 .84848 m .73097 .78155 L .73166 .77577 L p F P
0 g
s
.68 .368 .439 r
.69198 .84848 m .68847 .85405 L p .72121 .7982 L F P
0 g
s
.68 .368 .439 r
.72121 .7982 m .72977 .78361 L .72067 .79923 L F
.72121 .7982 m .72067 .79923 L .69198 .84848 L F
.73029 .78272 m .72061 .79933 L p .72977 .78361 L F P
0 g
s
.68 .368 .439 r
.72061 .79933 m .69198 .84848 L p .72067 .79923 L F P
0 g
s
.68 .368 .439 r
.72977 .78361 m .72061 .79933 L .72067 .79923 L F
.919 .906 .794 r
.72824 .78386 m .72937 .78282 L .72426 .7905 L F
.68 .368 .439 r
.73097 .78155 m .73029 .78272 L p .72977 .78361 L F P
0 g
s
.68 .368 .439 r
.69023 .85097 m .73097 .78155 L .68847 .85405 L F
.73024 .78675 m .73097 .78155 L p .69953 .83513 L F P
0 g
s
.402 .163 .434 r
.75388 .74866 m .73166 .77577 L .73097 .78155 L p F P
0 g
s
.402 .163 .434 r
.73097 .78155 m .75361 .75322 L .75388 .74866 L p F P
0 g
s
.396 .151 .421 r
.75361 .75322 m .73097 .78155 L .73024 .78675 L p F P
0 g
s
.396 .151 .421 r
.73024 .78675 m .75331 .75735 L .75361 .75322 L p F P
0 g
s
.39 .139 .409 r
.73024 .78675 m .72947 .79148 L p .74574 .7682 L F P
0 g
s
.39 .139 .409 r
.75331 .75735 m .74102 .77301 L p .74574 .7682 L F P
0 g
s
.39 .139 .409 r
.74102 .77301 m .73024 .78675 L p .74574 .7682 L F P
0 g
s
.408 .177 .448 r
.75411 .74354 m .7323 .76922 L .73166 .77577 L p F P
0 g
s
.408 .177 .448 r
.73166 .77577 m .75388 .74866 L .75411 .74354 L p F P
0 g
s
.341 .128 .438 r
.77418 .72739 m .75388 .74866 L .75361 .75322 L p F P
0 g
s
.341 .128 .438 r
.75361 .75322 m .77407 .73124 L .77418 .72739 L p F P
0 g
s
.333 .115 .426 r
.77407 .73124 m .75361 .75322 L .75331 .75735 L p F P
0 g
s
.333 .115 .426 r
.75331 .75735 m .77393 .73474 L .77407 .73124 L p F P
0 g
s
.325 .103 .415 r
.77393 .73474 m .75331 .75735 L .75299 .76114 L p F P
0 g
s
.325 .103 .415 r
.75299 .76114 m .77376 .73796 L .77393 .73474 L p F P
0 g
s
.854 .911 .871 r
.77376 .73796 m .75659 .75712 L p .74382 .75695 L F P
0 g
s
.39 .139 .409 r
.72947 .79148 m .75299 .76114 L .75331 .75735 L p F P
0 g
s
.854 .911 .871 r
.75659 .75712 m .75299 .76114 L .75276 .76103 L p F P
0 g
s
.854 .911 .871 r
.75276 .76103 m .74382 .75695 L p .75659 .75712 L F P
0 g
s
.919 .906 .794 r
.72937 .78282 m .75299 .76114 L .72653 .78817 L F
.72937 .78282 m .72653 .78817 L .72426 .7905 L F
.68 .368 .439 r
.6949 .84369 m .72511 .79501 L p .69953 .83513 L F P
0 g
s
.68 .368 .439 r
.72511 .79501 m .73024 .78675 L p .72488 .7952 L F P
0 g
s
.68 .368 .439 r
.72511 .79501 m .72488 .7952 L .69953 .83513 L F
.425 .138 .372 r
.67617 .85972 m .68838 .85422 L p .71113 .71802 L F P
0 g
s
.425 .138 .372 r
.68847 .85405 m .71113 .71802 L p .68838 .85422 L F P
0 g
s
.68 .368 .439 r
.68847 .85405 m .68834 .85427 L p .69023 .85097 L F P
0 g
s
0 0 0 r
.67617 .85972 m .66388 .86854 L p .68554 .8559 L F P
0 g
s
0 0 0 r
.68554 .8559 m .68577 .85566 L .67617 .85972 L F
.68641 .85539 m .68681 .85501 L .67617 .85972 L F
.68779 .85458 m .68799 .85441 L .67617 .85972 L F
.66388 .86854 m .64842 .87965 L p .68011 .85957 L F P
0 g
s
0 0 0 r
.64842 .87965 m .64374 .88302 L p .64978 .87913 L F P
0 g
s
0 0 0 r
.64978 .87913 m .68011 .85957 L .64842 .87965 L F
.64374 .88302 m .64937 .88046 L p .68781 .85466 L F P
0 g
s
0 0 0 r
.64937 .88046 m .65219 .87919 L p .6797 .86051 L F P
0 g
s
0 0 0 r
.65802 .87619 m .6797 .86051 L p .65219 .87919 L F P
0 g
s
0 0 0 r
.6797 .86051 m .68781 .85466 L p .64937 .88046 L F P
0 g
s
0 0 0 r
.64374 .88302 m .68781 .85466 L .68732 .85492 L F
.06 0 0 r
.65109 .86886 m .6383 .87249 L .60418 .89639 L p F P
0 g
s
0 0 0 r
.66372 .8646 m .65109 .86886 L .61747 .89263 L p F P
0 g
s
.06 0 0 r
.60418 .89639 m .61747 .89263 L .65109 .86886 L p F P
0 g
s
0 0 0 r
.67617 .85972 m .66372 .8646 L .63066 .88818 L p F P
0 g
s
0 0 0 r
.61747 .89263 m .63066 .88818 L .66372 .8646 L p F P
0 g
s
0 0 0 r
.63066 .88818 m .64374 .88302 L .67617 .85972 L p F P
0 g
s
.18 0 0 r
.62534 .87552 m .61221 .87795 L .5773 .90186 L p F P
0 g
s
.121 0 0 r
.6383 .87249 m .62534 .87552 L .59079 .89947 L p F P
0 g
s
.18 0 0 r
.5773 .90186 m .59079 .89947 L .62534 .87552 L p F P
0 g
s
.121 0 0 r
.59079 .89947 m .60418 .89639 L .6383 .87249 L p F P
0 g
s
.677 .901 .976 r
.63904 .85279 m .65256 .85969 L p .64912 .86329 L F P
0 g
s
.603 .936 .952 r
.62796 .87258 m .65164 .87633 L p .61718 .87731 L F P
0 g
s
.677 .901 .976 r
.63635 .87668 m .63727 .8685 L p .64912 .86329 L F P
0 g
s
.677 .901 .976 r
.63727 .8685 m .63904 .85279 L p .64912 .86329 L F P
0 g
s
.693 .854 .959 r
.56868 .85014 m .58292 .84405 L .61706 .8685 L p F P
0 g
s
.693 .854 .959 r
.61706 .8685 m .62129 .87153 L p .61592 .86935 L F P
0 g
s
.693 .854 .959 r
.56868 .85014 m .61706 .8685 L .61592 .86935 L F
.727 .869 .947 r
.63904 .85279 m .63727 .8685 L p .61955 .86662 L F P
0 g
s
.727 .869 .947 r
.61033 .86564 m .63638 .85398 L .61955 .86662 L F
.63638 .85398 m .63904 .85279 L .61955 .86662 L F
.603 .936 .952 r
.62594 .87226 m .62796 .87258 L p .6164 .87543 L F P
0 g
s
.603 .936 .952 r
.60767 .87758 m .62796 .87258 L .61718 .87731 L F
.727 .869 .947 r
.63727 .8685 m .63635 .87668 L .62594 .87226 L p F P
0 g
s
.727 .869 .947 r
.62594 .87226 m .61033 .86564 L p .63727 .8685 L F P
0 g
s
.603 .936 .952 r
.60767 .87758 m .62129 .87153 L .62594 .87226 L p F P
0 g
s
.603 .936 .952 r
.60767 .87758 m .62594 .87226 L .6164 .87543 L F
0 0 0 r
.65219 .87919 m .65671 .87714 L .65802 .87619 L p F P
0 g
s
.603 .936 .952 r
.65164 .87633 m .65671 .87714 L p .6518 .87718 L F P
0 g
s
.603 .936 .952 r
.60767 .87758 m .65164 .87633 L .6518 .87718 L F
.677 .901 .976 r
.65256 .85969 m .66024 .87505 L p .65151 .87564 L F P
0 g
s
.677 .901 .976 r
.63635 .87668 m .64912 .86329 L .65151 .87564 L F
.64912 .86329 m .65256 .85969 L .65151 .87564 L F
.66024 .87505 m .66078 .87613 L .65802 .87619 L p F P
0 g
s
.677 .901 .976 r
.65802 .87619 m .63635 .87668 L p .66024 .87505 L F P
0 g
s
0 0 0 r
.68641 .85539 m .68779 .85458 L .68681 .85501 L F
.68011 .85957 m .68835 .85425 L .66388 .86854 L F
.68838 .85422 m .67617 .85972 L p .68835 .85425 L F P
0 g
s
0 0 0 r
.68779 .85458 m .68835 .85425 L .68799 .85441 L F
.68 .368 .439 r
.68819 .85445 m .69023 .85097 L .68834 .85427 L F
0 0 0 r
.68781 .85466 m .68845 .85419 L p .68732 .85492 L F P
0 g
s
.703 .382 .431 r
.68771 .85527 m .68333 .8609 L p .69497 .8425 L F P
0 g
s
.68 .368 .439 r
.68819 .85445 m .6949 .84369 L .69953 .83513 L F
.68834 .85427 m .68771 .85527 L p .68819 .85445 L F P
0 g
s
.68 .368 .439 r
.68771 .85527 m .68823 .85442 L p .68819 .85445 L F P
0 g
s
.68 .368 .439 r
.68823 .85442 m .6949 .84369 L p .68819 .85445 L F P
0 g
s
.703 .382 .431 r
.69497 .8425 m .72534 .7945 L .68771 .85527 L F
.68636 .85611 m .69025 .85049 L .69497 .8425 L F
.6866 .85598 m .69025 .85049 L p .68636 .85611 L F P
0 g
s
.703 .382 .431 r
.73024 .78675 m .72511 .79501 L p .72534 .7945 L F P
0 g
s
.703 .382 .431 r
.72511 .79501 m .68771 .85527 L p .72534 .7945 L F P
0 g
s
.703 .382 .431 r
.70048 .83379 m .72947 .79148 L .72748 .79111 L F
.72947 .79148 m .73024 .78675 L p .72748 .79111 L F P
0 g
s
.703 .382 .431 r
.69497 .8425 m .69683 .84059 L .70048 .83379 L F
.69025 .85049 m .69683 .84059 L p .69497 .8425 L F P
0 g
s
.703 .382 .431 r
.69683 .84059 m .72947 .79148 L p .70048 .83379 L F P
0 g
s
.656 .354 .448 r
.72949 .77975 m .72972 .77932 L .71382 .80817 L F
.71387 .80809 m .71382 .80817 L .69611 .84031 L F
.72949 .77975 m .71382 .80817 L .71387 .80809 L F
.631 .34 .458 r
.70008 .83038 m .69611 .84031 L p .71121 .81065 L F P
0 g
s
.919 .906 .794 r
.72426 .7905 m .72395 .79044 L p .72824 .78386 L F P
0 g
s
.631 .34 .458 r
.7323 .76922 m .7093 .81287 L p .71281 .80749 L F P
0 g
s
.656 .354 .448 r
.73092 .77712 m .69611 .84031 L p .73012 .77859 L F P
0 g
s
.631 .34 .458 r
.69611 .84031 m .73166 .77577 L .7323 .76922 L p F P
0 g
s
.919 .906 .794 r
.72395 .79044 m .72157 .78999 L p .72824 .78386 L F P
0 g
s
.919 .906 .794 r
.72824 .78386 m .72824 .78386 L .72395 .79044 L F
.631 .34 .458 r
.71121 .81065 m .71281 .80749 L .70693 .81737 L F
.7093 .81287 m .70693 .81737 L p .71281 .80749 L F P
0 g
s
.631 .34 .458 r
.70693 .81737 m .70008 .83038 L p .71121 .81065 L F P
0 g
s
.656 .354 .448 r
.72949 .77975 m .73012 .77859 L .72972 .77932 L F
.73166 .77577 m .73092 .77712 L p .73012 .77859 L F P
0 g
s
.919 .906 .794 r
.72157 .78999 m .74413 .75709 L .72826 .78383 L F
.72824 .78386 m .72826 .78383 L .72824 .78386 L F
.72157 .78999 m .72826 .78383 L .72824 .78386 L F
.72157 .78999 m .74382 .75695 L .74413 .75709 L p F P
0 g
s
.919 .906 .794 r
.74413 .75709 m .75299 .76114 L p .72824 .78386 L F P
0 g
s
.982 .835 .621 r
.72157 .78999 m .72947 .79148 L .6866 .85598 L p F P
0 g
s
.703 .382 .431 r
.68333 .8609 m .6866 .85598 L p .68636 .85611 L F P
0 g
s
.982 .835 .621 r
.6866 .85598 m .68333 .8609 L .68564 .85661 L p F P
0 g
s
0 0 0 r
.68554 .8559 m .68641 .85539 L .68577 .85566 L F
.606 .328 .469 r
.73286 .76161 m .70386 .81807 L .70008 .83038 L p F P
0 g
s
.606 .328 .469 r
.70008 .83038 m .7323 .76922 L .73286 .76161 L p F P
0 g
s
.982 .835 .621 r
.68564 .85661 m .72157 .78999 L p .6866 .85598 L F P
0 g
s
.47 .865 .97 r
.65256 .85969 m .66565 .8635 L p .66136 .87461 L F P
0 g
s
.47 .865 .97 r
.66078 .87613 m .66024 .87505 L p .66136 .87461 L F P
0 g
s
.47 .865 .97 r
.66024 .87505 m .65256 .85969 L p .66136 .87461 L F P
0 g
s
.936 .795 .332 r
.66565 .8635 m .67343 .83334 L .68261 .85891 L p F P
0 g
s
.936 .795 .332 r
.68261 .85891 m .68333 .8609 L .68023 .86136 L p F P
0 g
s
.936 .795 .332 r
.68023 .86136 m .66565 .8635 L p .68261 .85891 L F P
0 g
s
.95 .839 .407 r
.67343 .83334 m .6814 .81441 L .68322 .85834 L p F P
0 g
s
.95 .839 .407 r
.68322 .85834 m .68333 .8609 L .68261 .85891 L p F P
0 g
s
.95 .839 .407 r
.68261 .85891 m .67343 .83334 L p .68322 .85834 L F P
0 g
s
.972 .875 .491 r
.6814 .81441 m .68946 .80252 L .68363 .85801 L p F P
0 g
s
.972 .875 .491 r
.68363 .85801 m .68333 .8609 L .68322 .85834 L p F P
0 g
s
.972 .875 .491 r
.68322 .85834 m .6814 .81441 L p .68363 .85801 L F P
0 g
s
0 0 0 r
.68845 .85419 m .68838 .85422 L p .68835 .85425 L F P
0 g
s
.919 .906 .794 r
.75299 .76114 m .72947 .79148 L .72688 .79099 L p F P
0 g
s
.919 .906 .794 r
.72688 .79099 m .72521 .79068 L p .72862 .78704 L F P
0 g
s
.919 .906 .794 r
.72862 .78704 m .75299 .76114 L .72688 .79099 L F
.72521 .79068 m .72426 .7905 L p .72653 .78817 L F P
0 g
s
.919 .906 .794 r
.72653 .78817 m .75299 .76114 L .72521 .79068 L F
.425 .138 .372 r
.68838 .85422 m .68845 .85419 L .68847 .85405 L p F P
0 g
s
.891 .724 .668 r
.29714 .59251 m .28296 .57624 L .27904 .58602 L p F P
0 g
s
.891 .724 .668 r
.27904 .58602 m .29183 .60059 L .29714 .59251 L p F P
0 g
s
.602 .633 .854 r
.62266 .36325 m .61045 .34435 L .5979 .36508 L p F P
0 g
s
.611 .681 .891 r
.57428 .33114 m .5979 .36508 L .61045 .34435 L p F P
0 g
s
.857 .631 .594 r
.30703 .65085 m .3151 .70573 L .32502 .71066 L p F P
0 g
s
.869 .638 .587 r
.3151 .70573 m .30703 .65085 L .2972 .65442 L p F P
0 g
s
.881 .676 .621 r
.30703 .65085 m .29689 .62696 L .28883 .63476 L p F P
0 g
s
.881 .676 .621 r
.28883 .63476 m .2972 .65442 L .30703 .65085 L p F P
0 g
s
.696 .772 .91 r
.46632 .31727 m .50268 .35452 L .51447 .34951 L p F P
0 g
s
.71 .775 .903 r
.50268 .35452 m .46632 .31727 L .45453 .32313 L p F P
0 g
s
.455 .325 .615 r
.76891 .64805 m .76807 .64226 L .74731 .64614 L p F P
0 g
s
.455 .325 .615 r
.74731 .64614 m .74836 .65318 L .76891 .64805 L p F P
0 g
s
.898 .796 .738 r
.31091 .50269 m .30291 .49621 L .26793 .53374 L p F P
0 g
s
.898 .761 .702 r
.29426 .55179 m .27796 .53925 L p .27322 .54609 L F P
0 g
s
.898 .761 .702 r
.27796 .53925 m .27586 .53763 L .27518 .53979 L p F P
0 g
s
.898 .761 .702 r
.27518 .53979 m .27322 .54609 L p .27796 .53925 L F P
0 g
s
.925 .795 .699 r
.25636 .53062 m .25616 .53187 L p .25898 .53168 L F P
0 g
s
.925 .795 .699 r
.2734 .53674 m .25636 .53062 L p .27402 .5378 L F P
0 g
s
.958 .831 .676 r
.23508 .54339 m .25489 .53962 L .25616 .53187 L p F P
0 g
s
.958 .831 .676 r
.25616 .53187 m .25636 .53062 L p .25568 .53103 L F P
0 g
s
.958 .831 .676 r
.23508 .54339 m .25616 .53187 L .25568 .53103 L F
.918 .838 .751 r
.25492 .52967 m .25927 .53166 L .30291 .49621 L F
.2539 .53038 m .25554 .53077 L p .25492 .52967 L F P
0 g
s
.958 .831 .676 r
.25636 .53062 m .23533 .53446 L p .23508 .54339 L F P
0 g
s
.958 .831 .676 r
.23533 .53446 m .23525 .53447 L .23525 .53455 L p F P
0 g
s
.958 .831 .676 r
.23525 .53455 m .23508 .54339 L p .23533 .53446 L F P
0 g
s
.997 .856 .536 r
.20969 .59548 m .23508 .54339 L .23525 .53455 L p F P
0 g
s
.997 .856 .536 r
.23525 .53455 m .23525 .53447 L p .23523 .53453 L F P
0 g
s
.997 .856 .536 r
.20969 .59548 m .23525 .53455 L .23523 .53453 L F
.96 .936 .712 r
.21494 .51507 m .23533 .53446 L .21493 .51506 L F
.23252 .53617 m .23523 .53452 L p .21494 .51507 L F P
0 g
s
.96 .936 .712 r
.23523 .53452 m .23533 .53446 L p .21494 .51507 L F P
0 g
s
.96 .936 .712 r
.23533 .53446 m .23581 .53417 L .23571 .53407 L p F P
0 g
s
.96 .936 .712 r
.23571 .53407 m .21493 .51506 L p .23533 .53446 L F P
0 g
s
.918 .838 .751 r
.25554 .53077 m .25927 .53166 L p .25492 .52967 L F P
0 g
s
.918 .838 .751 r
.25927 .53166 m .26793 .53374 L .27056 .53092 L p F P
0 g
s
.918 .838 .751 r
.27056 .53092 m .30291 .49621 L p .25927 .53166 L F P
0 g
s
.925 .795 .699 r
.25489 .53962 m .27402 .5378 L .25898 .53168 L F
.25616 .53187 m .25489 .53962 L p .25898 .53168 L F P
0 g
s
.925 .795 .699 r
.27586 .53763 m .2734 .53674 L p .27402 .5378 L F P
0 g
s
.898 .796 .738 r
.27054 .53186 m .27796 .53925 L .31091 .50269 L F
.26793 .53374 m .2734 .53674 L p .27054 .53186 L F P
0 g
s
.925 .795 .699 r
.25489 .53962 m .27322 .54609 L .27586 .53763 L p F P
0 g
s
.898 .796 .738 r
.2734 .53674 m .27796 .53925 L p .27054 .53186 L F P
0 g
s
.898 .796 .738 r
.27796 .53925 m .28135 .5411 L .28363 .53814 L p F P
0 g
s
.898 .796 .738 r
.28363 .53814 m .31091 .50269 L p .27796 .53925 L F P
0 g
s
.634 .332 .441 r
.55846 .81086 m .58253 .82669 L .58364 .82152 L p F P
0 g
s
.632 .323 .428 r
.58253 .82669 m .55846 .81086 L .55779 .81461 L p F P
0 g
s
.832 .55 .511 r
.39754 .77394 m .34142 .77771 L .33849 .78104 L p F P
0 g
s
.832 .55 .511 r
.33849 .78104 m .39675 .77705 L .39754 .77394 L p F P
0 g
s
.873 .797 .772 r
.32788 .46468 m .32048 .45889 L .29476 .49067 L p F P
0 g
s
.873 .797 .772 r
.29476 .49067 m .30291 .49621 L .32788 .46468 L p F P
0 g
s
.447 .545 .863 r
.7651 .62404 m .75517 .60645 L .73381 .60626 L p F P
0 g
s
.434 .521 .848 r
.72394 .58703 m .73381 .60626 L .75517 .60645 L p F P
0 g
s
.789 .797 .859 r
.3851 .38509 m .3939 .39277 L .41321 .37226 L p F P
0 g
s
.807 .794 .84 r
.3939 .39277 m .3851 .38509 L .36518 .40753 L p F P
0 g
s
.449 .314 .605 r
.76983 .65487 m .76891 .64805 L .74836 .65318 L p F P
0 g
s
.449 .314 .605 r
.74836 .65318 m .74951 .66146 L .76983 .65487 L p F P
0 g
s
.856 .569 .502 r
.33403 .71481 m .32502 .71066 L .30871 .75258 L p F P
0 g
s
.856 .569 .502 r
.30871 .75258 m .3161 .76163 L .33403 .71481 L p F P
0 g
s
.836 .551 .506 r
.33557 .78376 m .39598 .77985 L .39675 .77705 L p F P
0 g
s
.892 .699 .634 r
.29689 .62696 m .28618 .60977 L .27999 .62065 L p F P
0 g
s
.892 .699 .634 r
.27999 .62065 m .28883 .63476 L .29689 .62696 L p F P
0 g
s
.632 .323 .428 r
.55779 .81461 m .5814 .8314 L .58253 .82669 L p F P
0 g
s
.674 .128 0 r
.5814 .8314 m .55779 .81461 L .54717 .81106 L p F P
0 g
s
.291 0 0 r
.51965 .80061 m .54717 .81106 L .55779 .81461 L p F P
0 g
s
.682 .768 .916 r
.47822 .31194 m .51447 .34951 L .52632 .34495 L p F P
0 g
s
.696 .772 .91 r
.51447 .34951 m .47822 .31194 L .46632 .31727 L p F P
0 g
s
.898 .761 .702 r
.27322 .54609 m .29055 .55931 L .29426 .55179 L p F P
0 g
s
.763 .781 .867 r
.44305 .36399 m .42934 .35096 L .41321 .37226 L p F P
0 g
s
.119 .636 .888 r
.49049 .79386 m .45947 .78877 L .44884 .78524 L p F P
0 g
s
.243 .717 .94 r
.45947 .78877 m .4259 .78441 L .41651 .78183 L p F P
0 g
s
.243 .717 .94 r
.41651 .78183 m .44884 .78524 L .45947 .78877 L p F P
0 g
s
.898 .722 .656 r
.29183 .60059 m .27904 .58602 L .275 .59713 L p F P
0 g
s
.898 .722 .656 r
.275 .59713 m .28618 .60977 L .29183 .60059 L p F P
0 g
s
0 .47 .748 r
.51965 .80061 m .49049 .79386 L .47923 .79003 L p F P
0 g
s
.119 .636 .888 r
.44884 .78524 m .47923 .79003 L .49049 .79386 L p F P
0 g
s
.839 .552 .502 r
.39598 .77985 m .33557 .78376 L .33267 .78598 L p F P
0 g
s
.442 .3 .592 r
.7709 .66365 m .76983 .65487 L .74951 .66146 L p F P
0 g
s
.442 .3 .592 r
.74951 .66146 m .75083 .6721 L .7709 .66365 L p F P
0 g
s
.902 .758 .693 r
.29055 .55931 m .27322 .54609 L .27064 .5552 L p F P
0 g
s
.902 .758 .693 r
.27064 .5552 m .28679 .56741 L .29055 .55931 L p F P
0 g
s
.835 .809 .826 r
.33614 .42619 m .34364 .43174 L .36518 .40753 L p F P
0 g
s
.856 .81 .803 r
.34364 .43174 m .33614 .42619 L .31294 .45379 L p F P
0 g
s
.856 .81 .803 r
.32048 .45889 m .34364 .43174 L p .31569 .45182 L F P
0 g
s
.835 .809 .826 r
.36518 .40753 m .35722 .4014 L .33614 .42619 L p F P
0 g
s
.022 0 .096 r
.32144 .46241 m .33606 .42638 L p .35722 .4014 L F P
0 g
s
.022 0 .096 r
.33606 .42638 m .33614 .42619 L .33744 .42465 L p F P
0 g
s
.022 0 .096 r
.33744 .42465 m .35722 .4014 L p .33606 .42638 L F P
0 g
s
.856 .81 .803 r
.31294 .45379 m .3137 .4543 L p .31569 .45182 L F P
0 g
s
.856 .81 .803 r
.3137 .4543 m .32048 .45889 L p .31569 .45182 L F P
0 g
s
.666 .763 .923 r
.49025 .30713 m .52632 .34495 L .53821 .34083 L p F P
0 g
s
.682 .768 .916 r
.52632 .34495 m .49025 .30713 L .47822 .31194 L p F P
0 g
s
.815 .811 .847 r
.35722 .4014 m .36518 .40753 L .3851 .38509 L p F P
0 g
s
.866 .582 .505 r
.32502 .71066 m .3151 .70573 L .30072 .74206 L p F P
0 g
s
.866 .582 .505 r
.30072 .74206 m .30871 .75258 L .32502 .71066 L p F P
0 g
s
.314 .769 .954 r
.3809 .77983 m .41651 .78183 L .4259 .78441 L p F P
0 g
s
.314 .769 .954 r
.38812 .78071 m .3809 .77983 L p .40081 .78186 L F P
0 g
s
.608 .924 .971 r
.33267 .78598 m .3809 .77983 L .38812 .78071 L closepath p F P
0 g
s
.322 .808 .863 r
.33267 .78598 m .37356 .78008 L .3809 .77983 L closepath p F P
0 g
s
.149 .685 .844 r
.3809 .77983 m .37356 .78008 L p .38908 .78072 L F P
0 g
s
.149 .685 .844 r
.41651 .78183 m .39057 .78038 L p .38908 .78072 L F P
0 g
s
.149 .685 .844 r
.39057 .78038 m .3809 .77983 L p .38908 .78072 L F P
0 g
s
.149 .685 .844 r
.40692 .78066 m .41651 .78183 L p .39264 .78086 L F P
0 g
s
.314 .769 .954 r
.40473 .78233 m .38812 .78071 L p .40081 .78186 L F P
0 g
s
.739 .922 .953 r
.33267 .78598 m .38812 .78071 L .39521 .78242 L closepath p F P
0 g
s
.094 0 0 r
.3971 .78154 m .40692 .78066 L p .38665 .78127 L F P
0 g
s
.094 0 0 r
.36604 .78189 m .38486 .78168 L p .38665 .78127 L F P
0 g
s
.094 0 0 r
.38486 .78168 m .3971 .78154 L p .38665 .78127 L F P
0 g
s
.149 .685 .844 r
.37356 .78008 m .38835 .78034 L p .39264 .78086 L F P
0 g
s
.149 .685 .844 r
.38835 .78034 m .40692 .78066 L p .39264 .78086 L F P
0 g
s
.314 .769 .954 r
.4259 .78441 m .40473 .78233 L p .40081 .78186 L F P
0 g
s
.77 .804 .88 r
.40265 .36318 m .41321 .37226 L .42934 .35096 L p F P
0 g
s
.789 .797 .859 r
.41321 .37226 m .40265 .36318 L .3851 .38509 L p F P
0 g
s
.918 .838 .751 r
.30291 .49621 m .29476 .49067 L .2539 .53038 L p F P
0 g
s
.569 .624 .867 r
.64974 .36679 m .64065 .35188 L .62266 .36325 L p F P
0 g
s
.566 .646 .888 r
.61045 .34435 m .62266 .36325 L .64065 .35188 L p F P
0 g
s
.869 .638 .587 r
.2972 .65442 m .30377 .69958 L .3151 .70573 L p F P
0 g
s
.884 .649 .577 r
.30377 .69958 m .2972 .65442 L .28512 .65885 L p F P
0 g
s
.894 .68 .605 r
.2972 .65442 m .28883 .63476 L .27913 .64481 L p F P
0 g
s
.894 .68 .605 r
.27913 .64481 m .28512 .65885 L .2972 .65442 L p F P
0 g
s
.906 .754 .682 r
.28679 .56741 m .27064 .5552 L .26812 .56512 L p F P
0 g
s
.906 .754 .682 r
.26812 .56512 m .28296 .57624 L .28679 .56741 L p F P
0 g
s
.529 .598 .867 r
.64974 .36679 m .6588 .38277 L .67695 .37239 L p F P
0 g
s
.37 .304 .652 r
.68989 .4372 m .67695 .37239 L .6588 .38277 L p F P
0 g
s
.37 .304 .652 r
.6588 .38277 m .67079 .44002 L .68989 .4372 L p F P
0 g
s
.883 .815 .777 r
.32048 .45889 m .31294 .45379 L .28644 .48611 L p F P
0 g
s
.883 .815 .777 r
.29476 .49067 m .32048 .45889 L p .28997 .48328 L F P
0 g
s
.027 0 .077 r
.30009 .48271 m .31268 .45438 L p .33614 .42619 L F P
0 g
s
.027 0 .077 r
.31268 .45438 m .31294 .45379 L .31605 .45009 L p F P
0 g
s
.027 0 .077 r
.31605 .45009 m .33614 .42619 L p .31268 .45438 L F P
0 g
s
.883 .815 .777 r
.28644 .48611 m .28736 .48662 L p .28997 .48328 L F P
0 g
s
.883 .815 .777 r
.28736 .48662 m .29476 .49067 L p .28997 .48328 L F P
0 g
s
0 .47 .748 r
.47923 .79003 m .50829 .79717 L .51965 .80061 L p F P
0 g
s
.437 0 0 r
.54717 .81106 m .51965 .80061 L .50829 .79717 L p F P
0 g
s
.434 .521 .848 r
.75517 .60645 m .74504 .58739 L .72394 .58703 L p F P
0 g
s
.419 .494 .83 r
.71386 .56588 m .72394 .58703 L .74504 .58739 L p F P
0 g
s
.455 .264 .531 r
.75316 .69709 m .73255 .70826 L .73354 .73988 L p F P
0 g
s
.552 .334 .537 r
.71041 .7796 m .73354 .73988 L .73255 .70826 L p F P
0 g
s
.427 .271 .566 r
.77289 .68431 m .7709 .66365 L .75083 .6721 L p F P
0 g
s
.427 .271 .566 r
.75083 .6721 m .75316 .69709 L .77289 .68431 L p F P
0 g
s
.905 .719 .64 r
.28618 .60977 m .275 .59713 L .27078 .61031 L p F P
0 g
s
.905 .719 .64 r
.27078 .61031 m .27999 .62065 L .28618 .60977 L p F P
0 g
s
.419 .312 .626 r
.78525 .61998 m .78464 .61641 L .7651 .62404 L p F P
0 g
s
.419 .312 .626 r
.7651 .62404 m .76581 .6281 L .78525 .61998 L p F P
0 g
s
.514 .593 .871 r
.75517 .60645 m .7651 .62404 L .78464 .61641 L p F P
0 g
s
.65 .758 .928 r
.50241 .30285 m .53821 .34083 L .55017 .33715 L p F P
0 g
s
.666 .763 .923 r
.53821 .34083 m .50241 .30285 L .49025 .30713 L p F P
0 g
s
.903 .697 .615 r
.28883 .63476 m .27999 .62065 L .2728 .63477 L p F P
0 g
s
.903 .697 .615 r
.2728 .63477 m .27913 .64481 L .28883 .63476 L p F P
0 g
s
.796 .817 .868 r
.37615 .37816 m .3851 .38509 L .40265 .36318 L p F P
0 g
s
.815 .811 .847 r
.3851 .38509 m .37615 .37816 L .35722 .4014 L p F P
0 g
s
.91 .75 .671 r
.28296 .57624 m .26812 .56512 L .26567 .57611 L p F P
0 g
s
.91 .75 .671 r
.26567 .57611 m .27904 .58602 L .28296 .57624 L p F P
0 g
s
.415 .306 .621 r
.78589 .62381 m .78525 .61998 L .76581 .6281 L p F P
0 g
s
.415 .306 .621 r
.76581 .6281 m .76653 .63243 L .78589 .62381 L p F P
0 g
s
.878 .597 .509 r
.3151 .70573 m .30377 .69958 L .29179 .72924 L p F P
0 g
s
.878 .597 .509 r
.29179 .72924 m .30072 .74206 L .3151 .70573 L p F P
0 g
s
.412 .299 .615 r
.78655 .62794 m .78589 .62381 L .76653 .63243 L p F P
0 g
s
.412 .299 .615 r
.76653 .63243 m .76728 .63711 L .78655 .62794 L p F P
0 g
s
.027 0 .077 r
.33614 .42619 m .32144 .46241 L .30009 .48271 L p F P
0 g
s
.407 .291 .608 r
.78725 .63249 m .78655 .62794 L .76728 .63711 L p F P
0 g
s
.407 .291 .608 r
.76728 .63711 m .76807 .64226 L .78725 .63249 L p F P
0 g
s
.632 .752 .934 r
.5147 .2991 m .55017 .33715 L .56219 .33392 L p F P
0 g
s
.65 .758 .928 r
.55017 .33715 m .5147 .2991 L .50241 .30285 L p F P
0 g
s
.914 .744 .657 r
.27904 .58602 m .26567 .57611 L .26334 .58859 L p F P
0 g
s
.914 .744 .657 r
.26334 .58859 m .275 .59713 L .27904 .58602 L p F P
0 g
s
0 0 .049 r
.34175 .44042 m .35722 .4014 L .37615 .37816 L p F P
0 g
s
.022 0 .096 r
.35722 .4014 m .34175 .44042 L .32144 .46241 L p F P
0 g
s
.419 .494 .83 r
.74504 .58739 m .73469 .56641 L .71386 .56588 L p F P
0 g
s
.405 .462 .806 r
.70356 .54212 m .71386 .56588 L .73469 .56641 L p F P
0 g
s
.402 .282 .601 r
.78799 .63761 m .78725 .63249 L .76807 .64226 L p F P
0 g
s
.402 .282 .601 r
.76807 .64226 m .76891 .64805 L .78799 .63761 L p F P
0 g
s
.529 .598 .867 r
.67695 .37239 m .66948 .35947 L .64974 .36679 L p F P
0 g
s
.525 .615 .884 r
.64065 .35188 m .64974 .36679 L .66948 .35947 L p F P
0 g
s
.913 .713 .619 r
.27999 .62065 m .27078 .61031 L .26621 .62745 L p F P
0 g
s
.913 .713 .619 r
.26621 .62745 m .2728 .63477 L .27999 .62065 L p F P
0 g
s
.936 .907 .768 r
.29476 .49067 m .28644 .48611 L .23904 .53266 L p F P
0 g
s
.936 .907 .768 r
.23904 .53266 m .2539 .53038 L .29476 .49067 L p F P
0 g
s
0 0 0 r
.31294 .45379 m .30009 .48271 L .27696 .50317 L p F P
0 g
s
0 0 0 r
.27696 .50317 m .28644 .48611 L .31294 .45379 L p F P
0 g
s
0 .511 .736 r
.47923 .79003 m .44884 .78524 L .43799 .78326 L p F P
0 g
s
.073 .625 .823 r
.44884 .78524 m .41651 .78183 L .40692 .78066 L p F P
0 g
s
.073 .625 .823 r
.40692 .78066 m .43799 .78326 L .44884 .78524 L p F P
0 g
s
.674 .128 0 r
.54717 .81106 m .57246 .83028 L .5814 .8314 L p F P
0 g
s
.723 .206 0 r
.57246 .83028 m .54717 .81106 L .53636 .80886 L p F P
0 g
s
.437 0 0 r
.50829 .79717 m .53636 .80886 L .54717 .81106 L p F P
0 g
s
.396 .272 .592 r
.78881 .64363 m .78799 .63761 L .76891 .64805 L p F P
0 g
s
.396 .272 .592 r
.76891 .64805 m .76983 .65487 L .78881 .64363 L p F P
0 g
s
.884 .649 .577 r
.28512 .65885 m .28975 .69109 L .30377 .69958 L p F P
0 g
s
.892 .617 .513 r
.30377 .69958 m .28975 .69109 L .28108 .71204 L p F P
0 g
s
.892 .617 .513 r
.28108 .71204 m .29179 .72924 L .30377 .69958 L p F P
0 g
s
.77 .804 .88 r
.42934 .35096 m .41529 .33973 L .40265 .36318 L p F P
0 g
s
.614 .745 .939 r
.52713 .29588 m .56219 .33392 L .57428 .33114 L p F P
0 g
s
.632 .752 .934 r
.56219 .33392 m .52713 .29588 L .5147 .2991 L p F P
0 g
s
.919 .737 .64 r
.275 .59713 m .26334 .58859 L .26118 .60337 L p F P
0 g
s
.919 .737 .64 r
.26118 .60337 m .27078 .61031 L .275 .59713 L p F P
0 g
s
0 .511 .736 r
.43799 .78326 m .46773 .78788 L .47923 .79003 L p F P
0 g
s
.299 0 0 r
.50829 .79717 m .47923 .79003 L .46773 .78788 L p F P
0 g
s
.514 .593 .871 r
.78464 .61641 m .77503 .59947 L .75517 .60645 L p F P
0 g
s
.504 .572 .857 r
.74504 .58739 m .75517 .60645 L .77503 .59947 L p F P
0 g
s
.777 .828 .892 r
.39187 .35518 m .40265 .36318 L .41529 .33973 L p F P
0 g
s
.796 .817 .868 r
.40265 .36318 m .39187 .35518 L .37615 .37816 L p F P
0 g
s
.915 .67 .552 r
.25961 .66843 m .28975 .69109 L .28512 .65885 L closepath p F P
0 g
s
.92 .684 .565 r
.25961 .66843 m .28512 .65885 L .27913 .64481 L closepath p F P
0 g
s
.566 .646 .888 r
.64065 .35188 m .6315 .33796 L .61045 .34435 L p F P
0 g
s
.559 .669 .911 r
.5981 .32711 m .61045 .34435 L .6315 .33796 L p F P
0 g
s
.611 .681 .891 r
.61045 .34435 m .5981 .32711 L .57428 .33114 L p F P
0 g
s
.405 .462 .806 r
.73469 .56641 m .72408 .54274 L .70356 .54212 L p F P
0 g
s
.39 .426 .777 r
.693 .51467 m .70356 .54212 L .72408 .54274 L p F P
0 g
s
.388 .258 .58 r
.78978 .65138 m .78881 .64363 L .76983 .65487 L p F P
0 g
s
.388 .258 .58 r
.76983 .65487 m .7709 .66365 L .78978 .65138 L p F P
0 g
s
.403 .227 .526 r
.77289 .68431 m .75316 .69709 L .75427 .72096 L p F P
0 g
s
.455 .264 .531 r
.73354 .73988 m .75427 .72096 L .75316 .69709 L p F P
0 g
s
0 0 0 r
.36077 .41547 m .37615 .37816 L .39187 .35518 L p F P
0 g
s
0 0 .049 r
.37615 .37816 m .36077 .41547 L .34175 .44042 L p F P
0 g
s
.371 .344 .699 r
.70182 .48143 m .68989 .4372 L .67079 .44002 L p F P
0 g
s
.371 .344 .699 r
.67079 .44002 m .68211 .48174 L .70182 .48143 L p F P
0 g
s
.924 .692 .569 r
.25961 .66843 m .27913 .64481 L .2728 .63477 L closepath p F P
0 g
s
.927 .789 .689 r
.27322 .54609 m .25489 .53962 L .25358 .54931 L p F P
0 g
s
.927 .789 .689 r
.25358 .54931 m .27064 .5552 L .27322 .54609 L p F P
0 g
s
.482 .742 .985 r
.55001 .30306 m .58558 .31152 L p .58304 .31025 L F P
0 g
s
.614 .745 .939 r
.54371 .29761 m .53971 .29322 L .53388 .29445 L p F P
0 g
s
.565 .826 .995 r
.48999 .27168 m .52713 .29588 L .53388 .29445 L p F P
0 g
s
.565 .826 .995 r
.53388 .29445 m .53971 .29322 L p .5349 .29114 L F P
0 g
s
.565 .826 .995 r
.48999 .27168 m .53388 .29445 L .5349 .29114 L F
.482 .742 .985 r
.53619 .28693 m .54371 .29761 L .58304 .31025 L F
.52485 .28128 m .53518 .29023 L p .53619 .28693 L F P
0 g
s
.565 .826 .995 r
.53971 .29322 m .50869 .27271 L p .48999 .27168 L F P
0 g
s
.565 .826 .995 r
.50869 .27271 m .50315 .26905 L .50116 .26945 L p F P
0 g
s
.565 .826 .995 r
.50116 .26945 m .48999 .27168 L p .50869 .27271 L F P
0 g
s
.555 0 0 r
.55994 .28549 m .54675 .27535 L .51649 .27122 L p F P
0 g
s
.485 .731 .98 r
.55994 .28549 m .57288 .29761 L .60357 .30207 L p F P
0 g
s
.485 .731 .98 r
.60357 .30207 m .59407 .29211 L .55994 .28549 L p F P
0 g
s
.421 .74 .992 r
.59407 .29211 m .58444 .28323 L .54675 .27535 L p F P
0 g
s
.421 .74 .992 r
.55994 .28549 m .59407 .29211 L p .56301 .28111 L F P
0 g
s
.421 .74 .992 r
.54675 .27535 m .55212 .27948 L p .56301 .28111 L F P
0 g
s
.421 .74 .992 r
.55212 .27948 m .55994 .28549 L p .56301 .28111 L F P
0 g
s
.482 .742 .985 r
.54371 .29761 m .55001 .30306 L p .58304 .31025 L F P
0 g
s
.586 .722 .937 r
.5981 .32711 m .58558 .31152 L .55001 .30306 L p F P
0 g
s
.523 .713 .958 r
.57288 .29761 m .58558 .31152 L .61297 .31305 L p F P
0 g
s
.482 .742 .985 r
.58558 .31152 m .57288 .29761 L .52485 .28128 L p F P
0 g
s
.523 .713 .958 r
.61297 .31305 m .60357 .30207 L .57288 .29761 L p F P
0 g
s
.449 .692 .97 r
.59407 .29211 m .60357 .30207 L .63159 .30576 L p F P
0 g
s
.449 .692 .97 r
.63159 .30576 m .62386 .29717 L .59407 .29211 L p F P
0 g
s
.411 .702 .982 r
.58444 .28323 m .59407 .29211 L .62386 .29717 L p F P
0 g
s
.411 .702 .982 r
.62386 .29717 m .61606 .28934 L .58444 .28323 L p F P
0 g
s
.662 .283 .317 r
.57413 .31351 m .58409 .28426 L p .61606 .28934 L F P
0 g
s
.662 .283 .317 r
.58409 .28426 m .58444 .28323 L .60939 .28805 L p F P
0 g
s
.662 .283 .317 r
.60939 .28805 m .61606 .28934 L p .58409 .28426 L F P
0 g
s
.729 .327 .287 r
.54675 .27535 m .58444 .28323 L p .56485 .28764 L F P
0 g
s
.119 .61 .91 r
.51364 .27351 m .50869 .27271 L .56648 .29513 L F
.306 .797 .868 r
.50116 .26945 m .50315 .26905 L p .50154 .26907 L F P
0 g
s
.306 .797 .868 r
.44968 .26981 m .48677 .26928 L .47405 .26762 L F
.45476 .26881 m .47405 .26762 L .46553 .26717 L F
.46435 .26717 m .46553 .26717 L .46445 .26711 L F
.46315 .26716 m .45476 .26881 L p .46553 .26717 L F P
0 g
s
.306 .797 .868 r
.45476 .26881 m .44968 .26981 L p .47405 .26762 L F P
0 g
s
.306 .797 .868 r
.50165 .26898 m .46925 .26735 L p .50154 .26907 L F P
0 g
s
.306 .797 .868 r
.46361 .26707 m .46315 .26716 L p .46435 .26717 L F P
0 g
s
.306 .797 .868 r
.44968 .26981 m .48999 .27168 L .50116 .26945 L p F P
0 g
s
.306 .797 .868 r
.44968 .26981 m .50116 .26945 L .50154 .26907 L F
.671 .86 .972 r
.43954 .2883 m .47822 .31194 L .49025 .30713 L p F P
0 g
s
.648 .854 .979 r
.45183 .28325 m .49025 .30713 L .50241 .30285 L p F P
0 g
s
.671 .86 .972 r
.49025 .30713 m .45183 .28325 L .43954 .2883 L p F P
0 g
s
.648 .854 .979 r
.50241 .30285 m .46433 .2788 L .45183 .28325 L p F P
0 g
s
.48 .894 .914 r
.4098 .28186 m .45183 .28325 L .46433 .2788 L p F P
0 g
s
.426 .866 .903 r
.42277 .27722 m .46433 .2788 L .47705 .27494 L p F P
0 g
s
.48 .894 .914 r
.46433 .2788 m .42277 .27722 L .4098 .28186 L p F P
0 g
s
.368 .834 .888 r
.43607 .27319 m .47705 .27494 L .48999 .27168 L p F P
0 g
s
.426 .866 .903 r
.47705 .27494 m .43607 .27319 L .42277 .27722 L p F P
0 g
s
.368 .834 .888 r
.48999 .27168 m .44968 .26981 L .43607 .27319 L p F P
0 g
s
.712 .868 .955 r
.41558 .30016 m .45453 .32313 L .46632 .31727 L p F P
0 g
s
.731 .871 .947 r
.45453 .32313 m .41558 .30016 L .40392 .30698 L p F P
0 g
s
.692 .865 .964 r
.42746 .29393 m .46632 .31727 L .47822 .31194 L p F P
0 g
s
.712 .868 .955 r
.46632 .31727 m .42746 .29393 L .41558 .30016 L p F P
0 g
s
.692 .865 .964 r
.47822 .31194 m .43954 .2883 L .42746 .29393 L p F P
0 g
s
.531 .917 .922 r
.39713 .28713 m .43954 .2883 L .45183 .28325 L p F P
0 g
s
.531 .917 .922 r
.45183 .28325 m .4098 .28186 L .39713 .28713 L p F P
0 g
s
.443 .059 .214 r
.40069 .38506 m .44968 .26981 L .46351 .26709 L p F P
0 g
s
.443 .059 .214 r
.46351 .26709 m .46361 .26707 L p .46356 .26716 L F P
0 g
s
.443 .059 .214 r
.40069 .38506 m .46351 .26709 L .46356 .26716 L F
.46361 .26707 m .41612 .38145 L .40069 .38506 L p F P
0 g
s
.638 .114 0 r
.45852 .26947 m .46357 .26717 L p .46086 .2993 L F P
0 g
s
.638 .114 0 r
.46357 .26717 m .46377 .26708 L p .46374 .26741 L F P
0 g
s
.638 .114 0 r
.46357 .26717 m .46374 .26741 L .46086 .2993 L F
.46377 .26708 m .46465 .26667 L .46461 .26704 L p F P
0 g
s
.306 .797 .868 r
.46925 .26735 m .46377 .26708 L p .46906 .26736 L F P
0 g
s
.306 .797 .868 r
.46906 .26736 m .46377 .26708 L .46376 .26708 L F
.46435 .26717 m .46445 .26711 L .46361 .26707 L F
.638 .114 0 r
.46461 .26704 m .46086 .2993 L p .46377 .26708 L F P
0 g
s
.306 .797 .868 r
.46377 .26708 m .46361 .26707 L p .46376 .26708 L F P
0 g
s
.306 .797 .868 r
.50154 .26907 m .46925 .26735 L .46906 .26736 L F
.48677 .26928 m .48901 .26925 L .47814 .26807 L F
.48677 .26928 m .47814 .26807 L .47405 .26762 L F
.48901 .26925 m .49313 .26919 L .47893 .26802 L F
.48901 .26925 m .47893 .26802 L .47405 .26762 L F
.49313 .26919 m .50142 .26908 L .48012 .26794 L F
.49313 .26919 m .48012 .26794 L .47405 .26762 L F
.50142 .26908 m .50076 .26903 L .47405 .26762 L F
.119 .61 .91 r
.50192 .26871 m .50236 .26935 L .50632 .27051 L F
.306 .797 .868 r
.50315 .26905 m .50165 .26898 L p .50154 .26907 L F P
0 g
s
.119 .61 .91 r
.50165 .26898 m .50236 .26935 L p .50192 .26871 L F P
0 g
s
.119 .61 .91 r
.50192 .26871 m .56648 .29513 L .56473 .29429 L F
.50192 .26871 m .56648 .29513 L .50192 .26871 L F
.50632 .27051 m .50782 .2719 L .51364 .27351 L F
.50782 .2719 m .50869 .27271 L .51364 .27351 L F
.50236 .26935 m .50869 .27271 L p .50632 .27051 L F P
0 g
s
.119 .61 .91 r
.50869 .27271 m .52485 .28128 L .54172 .28702 L p F P
0 g
s
.119 .61 .91 r
.54172 .28702 m .57288 .29761 L p .50869 .27271 L F P
0 g
s
.119 .61 .91 r
.57288 .29761 m .55994 .28549 L .49854 .26733 L p F P
0 g
s
.306 .797 .868 r
.50142 .26908 m .50154 .26907 L .50076 .26903 L F
.119 .61 .91 r
.49854 .26733 m .50165 .26898 L p .50192 .26871 L F P
0 g
s
.119 .61 .91 r
.49854 .26733 m .50192 .26871 L .50192 .26871 L F
.555 0 0 r
.47068 .26496 m .49854 .26733 L .55994 .28549 L p F P
0 g
s
.555 0 0 r
.51649 .27122 m .48515 .26694 L p .53373 .27946 L F P
0 g
s
.555 0 0 r
.48051 .26722 m .53373 .27946 L .48515 .26694 L F
.53373 .27946 m .55994 .28549 L .51649 .27122 L F
.482 .742 .985 r
.53518 .29023 m .54371 .29761 L p .53619 .28693 L F P
0 g
s
.595 .837 .99 r
.52713 .29588 m .48999 .27168 L .47705 .27494 L p F P
0 g
s
.877 .519 .365 r
.54675 .27535 m .53716 .29387 L .47578 .26718 L p F P
0 g
s
.555 0 0 r
.48515 .26694 m .47068 .26496 L p .48051 .26722 L F P
0 g
s
.877 .519 .365 r
.47578 .26718 m .47068 .26496 L .48515 .26694 L p F P
0 g
s
.877 .519 .365 r
.48515 .26694 m .54675 .27535 L p .47578 .26718 L F P
0 g
s
.657 .123 0 r
.46253 .29544 m .46086 .2993 L .46461 .26704 L p F P
0 g
s
.657 .123 0 r
.46461 .26704 m .46465 .26667 L p .46463 .26703 L F P
0 g
s
.657 .123 0 r
.46463 .26703 m .46253 .29544 L .46461 .26704 L F
.623 .846 .985 r
.46433 .2788 m .50241 .30285 L .5147 .2991 L p F P
0 g
s
.595 .837 .99 r
.47705 .27494 m .5147 .2991 L .52713 .29588 L p F P
0 g
s
.623 .846 .985 r
.5147 .2991 m .47705 .27494 L .46433 .2788 L p F P
0 g
s
.853 .429 .218 r
.52722 .30452 m .517 .30987 L .473 .26721 L p F P
0 g
s
.853 .429 .218 r
.473 .26721 m .47068 .26496 L .47389 .26721 L p F P
0 g
s
.853 .429 .218 r
.47389 .26721 m .52722 .30452 L p .473 .26721 L F P
0 g
s
.847 .387 .02 r
.47383 .30185 m .46253 .29544 L .47015 .26694 L p F P
0 g
s
.847 .387 .02 r
.47015 .26694 m .47068 .26496 L .47086 .26704 L p F P
0 g
s
.847 .387 .02 r
.47086 .26704 m .47383 .30185 L p .47015 .26694 L F P
0 g
s
.84 .374 .023 r
.48493 .30689 m .47383 .30185 L .47086 .26704 L p F P
0 g
s
.84 .374 .023 r
.47086 .26704 m .47068 .26496 L .47141 .26711 L p F P
0 g
s
.84 .374 .023 r
.47141 .26711 m .48493 .30689 L p .47086 .26704 L F P
0 g
s
.837 .368 .041 r
.49584 .31023 m .48493 .30689 L .47141 .26711 L p F P
0 g
s
.837 .368 .041 r
.47141 .26711 m .47068 .26496 L .4719 .26716 L p F P
0 g
s
.837 .368 .041 r
.4719 .26716 m .49584 .31023 L p .47141 .26711 L F P
0 g
s
.838 .373 .08 r
.50653 .31144 m .49584 .31023 L .4719 .26716 L p F P
0 g
s
.838 .373 .08 r
.4719 .26716 m .47068 .26496 L .4724 .26719 L p F P
0 g
s
.838 .373 .08 r
.4724 .26719 m .50653 .31144 L p .4719 .26716 L F P
0 g
s
.729 .327 .287 r
.53716 .29387 m .54345 .28173 L p .56485 .28764 L F P
0 g
s
.729 .327 .287 r
.54345 .28173 m .54675 .27535 L p .56485 .28764 L F P
0 g
s
.119 .61 .91 r
.56473 .29429 m .56648 .29513 L .57288 .29761 L F
.729 .327 .287 r
.57413 .31351 m .53716 .29387 L p .56485 .28764 L F P
0 g
s
.729 .327 .287 r
.58444 .28323 m .5813 .29246 L p .56485 .28764 L F P
0 g
s
.729 .327 .287 r
.5813 .29246 m .57413 .31351 L p .56485 .28764 L F P
0 g
s
.614 .745 .939 r
.57428 .33114 m .54371 .29761 L p .52713 .29588 L F P
0 g
s
.614 .745 .939 r
.53388 .29445 m .52713 .29588 L p .54371 .29761 L F P
0 g
s
.586 .722 .937 r
.55001 .30306 m .57428 .33114 L .5981 .32711 L p F P
0 g
s
.925 .728 .618 r
.27078 .61031 m .26118 .60337 L .25936 .62258 L p F P
0 g
s
.925 .728 .618 r
.25936 .62258 m .26621 .62745 L .27078 .61031 L p F P
0 g
s
.561 0 0 r
.53636 .80886 m .50829 .79717 L .49669 .79553 L p F P
0 g
s
.299 0 0 r
.46773 .78788 m .49669 .79553 L .50829 .79717 L p F P
0 g
s
.929 .783 .677 r
.27064 .5552 m .25358 .54931 L .25246 .55984 L p F P
0 g
s
.929 .783 .677 r
.25246 .55984 m .26812 .56512 L .27064 .5552 L p F P
0 g
s
.39 .426 .777 r
.72408 .54274 m .71316 .51515 L .693 .51467 L p F P
0 g
s
.378 .386 .741 r
.68211 .48174 m .693 .51467 L .71316 .51515 L p F P
0 g
s
.371 .229 .555 r
.79162 .66965 m .78978 .65138 L .7709 .66365 L p F P
0 g
s
.371 .229 .555 r
.7709 .66365 m .77289 .68431 L .79162 .66965 L p F P
0 g
s
.525 .615 .884 r
.66948 .35947 m .66198 .34731 L .64065 .35188 L p F P
0 g
s
.518 .631 .902 r
.6315 .33796 m .64065 .35188 L .66198 .34731 L p F P
0 g
s
.378 .386 .741 r
.71316 .51515 m .70182 .48143 L .68211 .48174 L p F P
0 g
s
.46 .09 .248 r
.23904 .53266 m .28644 .48611 L .27696 .50317 L closepath p F P
0 g
s
.929 .699 .57 r
.25961 .66843 m .2728 .63477 L .26621 .62745 L closepath p F P
0 g
s
.932 .775 .665 r
.26812 .56512 m .25246 .55984 L .2516 .57148 L p F P
0 g
s
.932 .775 .665 r
.2516 .57148 m .26567 .57611 L .26812 .56512 L p F P
0 g
s
.476 .579 .879 r
.66948 .35947 m .67695 .37239 L .69834 .36943 L p F P
0 g
s
.445 .347 .65 r
.7114 .43538 m .69834 .36943 L .67695 .37239 L p F P
0 g
s
.445 .347 .65 r
.67695 .37239 m .68989 .4372 L .7114 .43538 L p F P
0 g
s
.433 .226 .497 r
.75427 .72096 m .73354 .73988 L .73331 .75234 L p F P
0 g
s
.556 .312 .501 r
.73354 .73988 m .71041 .7796 L .70736 .80218 L p F P
0 g
s
.556 .312 .501 r
.70736 .80218 m .73331 .75234 L .73354 .73988 L p F P
0 g
s
.919 .656 .522 r
.25961 .66843 m .28108 .71204 L .28975 .69109 L closepath p F P
0 g
s
.504 .572 .857 r
.77503 .59947 m .76523 .58115 L .74504 .58739 L p F P
0 g
s
.493 .547 .84 r
.73469 .56641 m .74504 .58739 L .76523 .58115 L p F P
0 g
s
.355 .265 .614 r
.8029 .60615 m .80231 .6028 L .78464 .61641 L p F P
0 g
s
.355 .265 .614 r
.78464 .61641 m .78525 .61998 L .8029 .60615 L p F P
0 g
s
.55 .616 .872 r
.77503 .59947 m .78464 .61641 L .80231 .6028 L p F P
0 g
s
.934 .766 .65 r
.26567 .57611 m .2516 .57148 L .25109 .58467 L p F P
0 g
s
.934 .766 .65 r
.25109 .58467 m .26334 .58859 L .26567 .57611 L p F P
0 g
s
.351 .258 .608 r
.80351 .60974 m .8029 .60615 L .78525 .61998 L p F P
0 g
s
.351 .258 .608 r
.78525 .61998 m .78589 .62381 L .80351 .60974 L p F P
0 g
s
.347 .251 .602 r
.80415 .61362 m .80351 .60974 L .78589 .62381 L p F P
0 g
s
.347 .251 .602 r
.78589 .62381 m .78655 .62794 L .80415 .61362 L p F P
0 g
s
.936 .756 .633 r
.26334 .58859 m .25109 .58467 L .25112 .60026 L p F P
0 g
s
.936 .756 .633 r
.25112 .60026 m .26118 .60337 L .26334 .58859 L p F P
0 g
s
.934 .705 .568 r
.25961 .66843 m .26621 .62745 L .25936 .62258 L closepath p F P
0 g
s
.165 0 0 r
.43799 .78326 m .40692 .78066 L .3971 .78154 L p F P
0 g
s
.094 0 0 r
.40692 .78066 m .37356 .78008 L .36604 .78189 L p F P
0 g
s
.342 .243 .595 r
.80482 .61788 m .80415 .61362 L .78655 .62794 L p F P
0 g
s
.342 .243 .595 r
.78655 .62794 m .78725 .63249 L .80482 .61788 L p F P
0 g
s
.299 0 0 r
.46773 .78788 m .43799 .78326 L .42687 .78361 L p F P
0 g
s
.165 0 0 r
.3971 .78154 m .42687 .78361 L .43799 .78326 L p F P
0 g
s
.777 .828 .892 r
.41529 .33973 m .40084 .33048 L .39187 .35518 L p F P
0 g
s
0 0 0 r
.39187 .35518 m .37753 .38598 L .36077 .41547 L p F P
0 g
s
.734 .815 .347 r
.37753 .38598 m .39187 .35518 L .40084 .33048 L p F P
0 g
s
.476 .579 .879 r
.69834 .36943 m .69178 .3581 L .66948 .35947 L p F P
0 g
s
.468 .592 .894 r
.66198 .34731 m .66948 .35947 L .69178 .3581 L p F P
0 g
s
.336 .233 .588 r
.80554 .62268 m .80482 .61788 L .78725 .63249 L p F P
0 g
s
.336 .233 .588 r
.78725 .63249 m .78799 .63761 L .80554 .62268 L p F P
0 g
s
.723 .206 0 r
.53636 .80886 m .56339 .83047 L .57246 .83028 L p F P
0 g
s
.756 .272 .086 r
.56339 .83047 m .53636 .80886 L .52534 .80854 L p F P
0 g
s
.561 0 0 r
.49669 .79553 m .52534 .80854 L .53636 .80886 L p F P
0 g
s
.559 .669 .911 r
.6315 .33796 m .62228 .32502 L .5981 .32711 L p F P
0 g
s
.546 .691 .934 r
.58558 .31152 m .5981 .32711 L .62228 .32502 L p F P
0 g
s
.938 .741 .611 r
.26118 .60337 m .25112 .60026 L .25221 .62048 L p F P
0 g
s
.938 .741 .611 r
.25221 .62048 m .25936 .62258 L .26118 .60337 L p F P
0 g
s
.403 .227 .526 r
.75427 .72096 m .77402 .70416 L .77289 .68431 L p F P
0 g
s
.381 .192 .495 r
.77402 .70416 m .75427 .72096 L .75436 .73048 L p F P
0 g
s
.433 .226 .497 r
.73331 .75234 m .75436 .73048 L .75427 .72096 L p F P
0 g
s
.343 .184 .516 r
.79162 .66965 m .77289 .68431 L .77402 .70416 L p F P
0 g
s
.518 .631 .902 r
.66198 .34731 m .65445 .33586 L .6315 .33796 L p F P
0 g
s
.508 .647 .919 r
.62228 .32502 m .6315 .33796 L .65445 .33586 L p F P
0 g
s
.476 0 0 r
.49669 .79553 m .46773 .78788 L .45594 .78827 L p F P
0 g
s
.299 0 0 r
.42687 .78361 m .45594 .78827 L .46773 .78788 L p F P
0 g
s
.329 .222 .578 r
.80634 .62832 m .80554 .62268 L .78799 .63761 L p F P
0 g
s
.329 .222 .578 r
.78799 .63761 m .78881 .64363 L .80634 .62832 L p F P
0 g
s
.493 .547 .84 r
.76523 .58115 m .7552 .56099 L .73469 .56641 L p F P
0 g
s
.481 .517 .817 r
.72408 .54274 m .73469 .56641 L .7552 .56099 L p F P
0 g
s
.423 .207 .479 r
.75436 .73048 m .73331 .75234 L .73286 .76161 L p F P
0 g
s
.58 .317 .483 r
.73331 .75234 m .70736 .80218 L .70386 .81807 L p F P
0 g
s
.58 .317 .483 r
.70386 .81807 m .73286 .76161 L .73331 .75234 L p F P
0 g
s
.088 0 0 r
.33267 .78598 m .36604 .78189 L .37356 .78008 L closepath p F P
0 g
s
.55 .616 .872 r
.80231 .6028 m .79345 .58691 L .77503 .59947 L p F P
0 g
s
.542 .597 .859 r
.76523 .58115 m .77503 .59947 L .79345 .58691 L p F P
0 g
s
.319 .207 .566 r
.80728 .63558 m .80634 .62832 L .78881 .64363 L p F P
0 g
s
.319 .207 .566 r
.78881 .64363 m .78978 .65138 L .80728 .63558 L p F P
0 g
s
.939 .71 .564 r
.25961 .66843 m .25936 .62258 L .25221 .62048 L closepath p F P
0 g
s
.381 .192 .495 r
.75436 .73048 m .77423 .71211 L .77402 .70416 L p F P
0 g
s
.369 .173 .478 r
.77423 .71211 m .75436 .73048 L .75428 .73763 L p F P
0 g
s
.423 .207 .479 r
.73286 .76161 m .75428 .73763 L .75436 .73048 L p F P
0 g
s
.468 .592 .894 r
.69178 .3581 m .68521 .34739 L .66198 .34731 L p F P
0 g
s
.458 .604 .908 r
.65445 .33586 m .66198 .34731 L .68521 .34739 L p F P
0 g
s
.649 .12 0 r
.52534 .80854 m .49669 .79553 L .48481 .79658 L p F P
0 g
s
.476 0 0 r
.45594 .78827 m .48481 .79658 L .49669 .79553 L p F P
0 g
s
.299 .177 .54 r
.80911 .65266 m .80728 .63558 L .78978 .65138 L p F P
0 g
s
.299 .177 .54 r
.78978 .65138 m .79162 .66965 L .80911 .65266 L p F P
0 g
s
.481 .517 .817 r
.7552 .56099 m .7449 .53825 L .72408 .54274 L p F P
0 g
s
.469 .481 .788 r
.71316 .51515 m .72408 .54274 L .7449 .53825 L p F P
0 g
s
.415 .191 .462 r
.75428 .73763 m .73286 .76161 L .7323 .76922 L p F P
0 g
s
.449 .393 .703 r
.72318 .47895 m .7114 .43538 L .68989 .4372 L p F P
0 g
s
.449 .393 .703 r
.68989 .4372 m .70182 .48143 L .72318 .47895 L p F P
0 g
s
.404 .543 .881 r
.69178 .3581 m .69834 .36943 L .72209 .37264 L p F P
0 g
s
.486 .371 .648 r
.73446 .43384 m .72209 .37264 L .69834 .36943 L p F P
0 g
s
.486 .371 .648 r
.69834 .36943 m .7114 .43538 L .73446 .43384 L p F P
0 g
s
.959 .822 .665 r
.23518 .55295 m .25358 .54931 L .25489 .53962 L p F P
0 g
s
.959 .812 .655 r
.25358 .54931 m .23518 .55295 L .23561 .56332 L p F P
0 g
s
.959 .812 .655 r
.23561 .56332 m .25246 .55984 L .25358 .54931 L p F P
0 g
s
.959 .801 .643 r
.25246 .55984 m .23561 .56332 L .23648 .57475 L p F P
0 g
s
.959 .801 .643 r
.23648 .57475 m .2516 .57148 L .25246 .55984 L p F P
0 g
s
.959 .822 .665 r
.25489 .53962 m .23508 .54339 L .23518 .55295 L p F P
0 g
s
.958 .788 .629 r
.2516 .57148 m .23648 .57475 L .23797 .58765 L p F P
0 g
s
.958 .788 .629 r
.23797 .58765 m .25109 .58467 L .2516 .57148 L p F P
0 g
s
.956 .772 .613 r
.25109 .58467 m .23797 .58765 L .2404 .60285 L p F P
0 g
s
.956 .772 .613 r
.2404 .60285 m .25112 .60026 L .25109 .58467 L p F P
0 g
s
.508 .647 .919 r
.65445 .33586 m .64688 .32512 L .62228 .32502 L p F P
0 g
s
.495 .663 .937 r
.61297 .31305 m .62228 .32502 L .64688 .32512 L p F P
0 g
s
.546 .691 .934 r
.62228 .32502 m .61297 .31305 L .58558 .31152 L p F P
0 g
s
.369 .173 .478 r
.75428 .73763 m .77428 .7181 L .77423 .71211 L p F P
0 g
s
.359 .156 .463 r
.77428 .7181 m .75428 .73763 L .75411 .74354 L p F P
0 g
s
.415 .191 .462 r
.7323 .76922 m .75411 .74354 L .75428 .73763 L p F P
0 g
s
.343 .184 .516 r
.77402 .70416 m .79276 .68722 L .79162 .66965 L p F P
0 g
s
.318 .148 .486 r
.79276 .68722 m .77402 .70416 L .77423 .71211 L p F P
0 g
s
.954 .753 .594 r
.25112 .60026 m .2404 .60285 L .24462 .62243 L p F P
0 g
s
.954 .753 .594 r
.24462 .62243 m .25221 .62048 L .25112 .60026 L p F P
0 g
s
.542 .597 .859 r
.79345 .58691 m .7844 .56976 L .76523 .58115 L p F P
0 g
s
.532 .573 .842 r
.7552 .56099 m .76523 .58115 L .7844 .56976 L p F P
0 g
s
.876 .529 .388 r
.32306 .76962 m .3161 .76163 L .30015 .768 L p F P
0 g
s
.884 .546 .403 r
.3161 .76163 m .30871 .75258 L .29432 .75817 L p F P
0 g
s
.884 .546 .403 r
.29432 .75817 m .30015 .768 L .3161 .76163 L p F P
0 g
s
.893 .564 .419 r
.30871 .75258 m .30072 .74206 L .28814 .74679 L p F P
0 g
s
.893 .564 .419 r
.28814 .74679 m .29432 .75817 L .30871 .75258 L p F P
0 g
s
.868 .513 .375 r
.3297 .7768 m .32306 .76962 L .30573 .77671 L p F P
0 g
s
.876 .529 .388 r
.30015 .768 m .30573 .77671 L .32306 .76962 L p F P
0 g
s
.397 0 0 r
.42687 .78361 m .3971 .78154 L .38698 .78558 L p F P
0 g
s
.343 0 0 r
.3971 .78154 m .36604 .78189 L .35831 .78594 L p F P
0 g
s
.343 0 0 r
.35831 .78594 m .38698 .78558 L .3971 .78154 L p F P
0 g
s
.902 .584 .437 r
.30072 .74206 m .29179 .72924 L .28143 .733 L p F P
0 g
s
.902 .584 .437 r
.28143 .733 m .28814 .74679 L .30072 .74206 L p F P
0 g
s
.861 .498 .362 r
.33607 .78333 m .3297 .7768 L .31113 .78456 L p F P
0 g
s
.868 .513 .375 r
.30573 .77671 m .31113 .78456 L .3297 .7768 L p F P
0 g
s
.842 .38 .084 r
.32414 .8251 m .31889 .7923 L p .30491 .79079 L F P
0 g
s
.842 .38 .084 r
.31889 .7923 m .31875 .79147 L .31717 .79139 L p F P
0 g
s
.861 .498 .362 r
.31546 .79049 m .31638 .79173 L .31717 .79139 L p F P
0 g
s
.876 .472 .258 r
.31113 .78456 m .29273 .78113 L p .31445 .79087 L F P
0 g
s
.876 .472 .258 r
.31638 .79173 m .31546 .79049 L p .31445 .79087 L F P
0 g
s
.876 .472 .258 r
.31546 .79049 m .31113 .78456 L p .31445 .79087 L F P
0 g
s
.876 .472 .258 r
.29273 .78113 m .29559 .78606 L p .31638 .79173 L F P
0 g
s
.876 .472 .258 r
.29559 .78606 m .29681 .78817 L .29933 .78863 L p F P
0 g
s
.876 .472 .258 r
.29933 .78863 m .31638 .79173 L p .29559 .78606 L F P
0 g
s
.826 .35 .012 r
.31553 .82105 m .30568 .79298 L p .29109 .78544 L F P
0 g
s
.826 .35 .012 r
.30568 .79298 m .30491 .79079 L .29933 .78863 L p F P
0 g
s
.882 .451 .151 r
.29273 .78113 m .27444 .76967 L p .2949 .7866 L F P
0 g
s
.882 .451 .151 r
.29681 .78817 m .29559 .78606 L p .2949 .7866 L F P
0 g
s
.882 .451 .151 r
.29559 .78606 m .29273 .78113 L p .2949 .7866 L F P
0 g
s
.882 .451 .151 r
.27444 .76967 m .27731 .77601 L .29681 .78817 L p F P
0 g
s
.826 .35 .012 r
.29933 .78863 m .29463 .78681 L p .30568 .79298 L F P
0 g
s
.826 .35 .012 r
.29463 .78681 m .29109 .78544 L p .29427 .78709 L F P
0 g
s
.826 .35 .012 r
.29427 .78709 m .30568 .79298 L .29463 .78681 L F
.842 .38 .084 r
.31717 .79139 m .31352 .79121 L p .31889 .7923 L F P
0 g
s
.842 .38 .084 r
.31352 .79121 m .30491 .79079 L p .31247 .79161 L F P
0 g
s
.842 .38 .084 r
.31247 .79161 m .31889 .7923 L .31352 .79121 L F
.861 .498 .362 r
.31113 .78456 m .31546 .79049 L p .33607 .78333 L F P
0 g
s
.861 .498 .362 r
.31717 .79139 m .33607 .78333 L p .31546 .79049 L F P
0 g
s
.469 .481 .788 r
.7449 .53825 m .73426 .51167 L .71316 .51515 L p F P
0 g
s
.457 .439 .75 r
.70182 .48143 m .71316 .51515 L .73426 .51167 L p F P
0 g
s
0 0 0 r
.26793 .51277 m .27696 .50317 L .30009 .48271 L p F P
0 g
s
0 0 0 r
.23904 .53266 m .27696 .50317 L .26793 .51277 L closepath p F P
0 g
s
.912 .609 .459 r
.29179 .72924 m .28108 .71204 L .27367 .71458 L p F P
0 g
s
.912 .609 .459 r
.27367 .71458 m .28143 .733 L .29179 .72924 L p F P
0 g
s
.372 0 0 r
.33267 .78598 m .35831 .78594 L .36604 .78189 L closepath p F P
0 g
s
.946 .714 .555 r
.25961 .66843 m .25221 .62048 L .24462 .62243 L closepath p F P
0 g
s
.571 .627 .868 r
.79345 .58691 m .80231 .6028 L .81769 .58281 L p F P
0 g
s
.27 .207 .599 r
.81833 .58618 m .81769 .58281 L .80231 .6028 L p F P
0 g
s
.27 .207 .599 r
.80231 .6028 m .8029 .60615 L .81833 .58618 L p F P
0 g
s
.929 .654 .5 r
.25961 .66843 m .27367 .71458 L .28108 .71204 L closepath p F P
0 g
s
.457 .439 .75 r
.73426 .51167 m .72318 .47895 L .70182 .48143 L p F P
0 g
s
0 0 0 r
.28802 .49651 m .30009 .48271 L .32144 .46241 L p F P
0 g
s
0 0 0 r
.30009 .48271 m .28802 .49651 L .26793 .51277 L p F P
0 g
s
.265 .199 .594 r
.81898 .58978 m .81833 .58618 L .8029 .60615 L p F P
0 g
s
.265 .199 .594 r
.8029 .60615 m .80351 .60974 L .81898 .58978 L p F P
0 g
s
.488 0 0 r
.45594 .78827 m .42687 .78361 L .41541 .78764 L p F P
0 g
s
.397 0 0 r
.38698 .78558 m .41541 .78764 L .42687 .78361 L p F P
0 g
s
.458 .604 .908 r
.68521 .34739 m .67862 .33728 L .65445 .33586 L p F P
0 g
s
.445 .616 .923 r
.64688 .32512 m .65445 .33586 L .67862 .33728 L p F P
0 g
s
.26 .191 .587 r
.81967 .59367 m .81898 .58978 L .80351 .60974 L p F P
0 g
s
.26 .191 .587 r
.80351 .60974 m .80415 .61362 L .81967 .59367 L p F P
0 g
s
.359 .156 .463 r
.75411 .74354 m .77426 .72307 L .77428 .7181 L p F P
0 g
s
.35 .142 .45 r
.77426 .72307 m .75411 .74354 L .75388 .74866 L p F P
0 g
s
.264 .127 .499 r
.80911 .65266 m .79162 .66965 L .79276 .68722 L p F P
0 g
s
.756 .272 .086 r
.52534 .80854 m .55417 .83238 L .56339 .83047 L p F P
0 g
s
.404 .543 .881 r
.72209 .37264 m .71601 .36199 L .69178 .3581 L p F P
0 g
s
.393 .553 .894 r
.68521 .34739 m .69178 .3581 L .71601 .36199 L p F P
0 g
s
.776 .325 .178 r
.55417 .83238 m .52534 .80854 L .51407 .81093 L p F P
0 g
s
.649 .12 0 r
.48481 .79658 m .51407 .81093 L .52534 .80854 L p F P
0 g
s
.318 .148 .486 r
.77423 .71211 m .79302 .69427 L .79276 .68722 L p F P
0 g
s
.305 .128 .468 r
.79302 .69427 m .77423 .71211 L .77428 .7181 L p F P
0 g
s
.254 .182 .579 r
.82039 .59794 m .81967 .59367 L .80415 .61362 L p F P
0 g
s
.254 .182 .579 r
.80415 .61362 m .80482 .61788 L .82039 .59794 L p F P
0 g
s
.956 .715 .533 r
.25961 .66843 m .24462 .62243 L .23523 .64292 L closepath p F P
0 g
s
.934 .656 .489 r
.25961 .66843 m .26651 .71293 L .27367 .71458 L closepath p F P
0 g
s
.94 .66 .481 r
.25961 .66843 m .25952 .70832 L .26651 .71293 L closepath p F P
0 g
s
.945 .665 .477 r
.25961 .66843 m .25269 .70104 L .25952 .70832 L closepath p F P
0 g
s
.95 .672 .476 r
.25961 .66843 m .24607 .69078 L .25269 .70104 L closepath p F P
0 g
s
.955 .681 .479 r
.25961 .66843 m .23979 .67623 L .24607 .69078 L closepath p F P
0 g
s
.96 .699 .495 r
.25961 .66843 m .23523 .64292 L .23979 .67623 L closepath p F P
0 g
s
0 0 0 r
.30765 .47847 m .32144 .46241 L .34175 .44042 L p F P
0 g
s
0 0 0 r
.32144 .46241 m .30765 .47847 L .28802 .49651 L p F P
0 g
s
.481 .02 .081 r
.33267 .78598 m .3503 .79332 L .35831 .78594 L closepath p F P
0 g
s
.475 .08 .21 r
.33267 .78598 m .34185 .80601 L .3503 .79332 L closepath p F P
0 g
s
.859 .42 .164 r
.33272 .82787 m .33267 .78598 L .31875 .79147 L p F P
0 g
s
.356 .028 .264 r
.33267 .78598 m .33272 .82787 L .34185 .80601 L closepath p F P
0 g
s
.247 .172 .571 r
.82116 .60274 m .82039 .59794 L .80482 .61788 L p F P
0 g
s
.247 .172 .571 r
.80482 .61788 m .80554 .62268 L .82116 .60274 L p F P
0 g
s
.595 .077 0 r
.48481 .79658 m .45594 .78827 L .4438 .79266 L p F P
0 g
s
.488 0 0 r
.41541 .78764 m .4438 .79266 L .45594 .78827 L p F P
0 g
s
.35 .142 .45 r
.75388 .74866 m .77418 .72739 L .77426 .72307 L p F P
0 g
s
.532 .573 .842 r
.7844 .56976 m .77514 .5509 L .7552 .56099 L p F P
0 g
s
.522 .544 .82 r
.7449 .53825 m .7552 .56099 L .77514 .5509 L p F P
0 g
s
.734 .815 .347 r
.40084 .33048 m .38901 .34943 L .37753 .38598 L p F P
0 g
s
.238 .159 .561 r
.82201 .60838 m .82116 .60274 L .80554 .62268 L p F P
0 g
s
.238 .159 .561 r
.80554 .62268 m .80634 .62832 L .82201 .60838 L p F P
0 g
s
.305 .128 .468 r
.77428 .7181 m .79313 .69959 L .79302 .69427 L p F P
0 g
s
.293 .111 .454 r
.79313 .69959 m .77428 .7181 L .77426 .72307 L p F P
0 g
s
.571 .627 .868 r
.81769 .58281 m .81003 .56849 L .79345 .58691 L p F P
0 g
s
.564 .608 .856 r
.7844 .56976 m .79345 .58691 L .81003 .56849 L p F P
0 g
s
.495 .663 .937 r
.64688 .32512 m .63927 .31508 L .61297 .31305 L p F P
0 g
s
.476 .678 .954 r
.60357 .30207 m .61297 .31305 L .63927 .31508 L p F P
0 g
s
.226 .142 .547 r
.82301 .61563 m .82201 .60838 L .80634 .62832 L p F P
0 g
s
.226 .142 .547 r
.80634 .62832 m .80728 .63558 L .82301 .61563 L p F P
0 g
s
0 0 0 r
.34175 .44042 m .32707 .45756 L .30765 .47847 L p F P
0 g
s
.626 .863 .5 r
.32707 .45756 m .34175 .44042 L .36077 .41547 L p F P
0 g
s
.393 .553 .894 r
.71601 .36199 m .70993 .35194 L .68521 .34739 L p F P
0 g
s
.38 .562 .907 r
.67862 .33728 m .68521 .34739 L .70993 .35194 L p F P
0 g
s
.978 .76 .539 r
.23523 .64292 m .24462 .62243 L .2404 .60285 L p F P
0 g
s
.445 .616 .923 r
.67862 .33728 m .672 .32777 L .64688 .32512 L p F P
0 g
s
.429 .628 .937 r
.63927 .31508 m .64688 .32512 L .672 .32777 L p F P
0 g
s
.293 .111 .454 r
.77426 .72307 m .79317 .704 L .79313 .69959 L p F P
0 g
s
.282 .095 .44 r
.79317 .704 m .77426 .72307 L .77418 .72739 L p F P
0 g
s
.925 .61 .427 r
.28143 .733 m .27367 .71458 L .26651 .71293 L p F P
0 g
s
.502 .034 .076 r
.38698 .78558 m .35831 .78594 L .3503 .79332 L p F P
0 g
s
.201 .107 .519 r
.82494 .63263 m .82301 .61563 L .80728 .63558 L p F P
0 g
s
.201 .107 .519 r
.80728 .63558 m .80911 .65266 L .82494 .63263 L p F P
0 g
s
.698 .226 .126 r
.51407 .81093 m .48481 .79658 L .4726 .80181 L p F P
0 g
s
.595 .077 0 r
.4438 .79266 m .4726 .80181 L .48481 .79658 L p F P
0 g
s
.264 .127 .499 r
.79276 .68722 m .81027 .66907 L .80911 .65266 L p F P
0 g
s
.235 .086 .466 r
.81027 .66907 m .79276 .68722 L .79302 .69427 L p F P
0 g
s
.522 .544 .82 r
.77514 .5509 m .76563 .52965 L .7449 .53825 L p F P
0 g
s
.511 .509 .79 r
.73426 .51167 m .7449 .53825 L .76563 .52965 L p F P
0 g
s
.988 .784 .541 r
.22699 .63159 m .2404 .60285 L .23797 .58765 L p F P
0 g
s
.978 .76 .539 r
.2404 .60285 m .22699 .63159 L .23523 .64292 L p F P
0 g
s
.282 .095 .44 r
.77418 .72739 m .79316 .70784 L .79317 .704 L p F P
0 g
s
.272 .081 .428 r
.79316 .70784 m .77418 .72739 L .77407 .73124 L p F P
0 g
s
.491 .419 .704 r
.74549 .47437 m .73446 .43384 L .7114 .43538 L p F P
0 g
s
.491 .419 .704 r
.7114 .43538 m .72318 .47895 L .74549 .47437 L p F P
0 g
s
.917 .582 .392 r
.28814 .74679 m .28143 .733 L .27135 .73078 L p F P
0 g
s
.925 .61 .427 r
.26651 .71293 m .27135 .73078 L .28143 .733 L p F P
0 g
s
.538 .071 .093 r
.41541 .78764 m .38698 .78558 L .37643 .7948 L p F P
0 g
s
.502 .034 .076 r
.3503 .79332 m .37643 .7948 L .38698 .78558 L p F P
0 g
s
.305 .484 .87 r
.71601 .36199 m .72209 .37264 L .74814 .38274 L p F P
0 g
s
.514 .39 .649 r
.75889 .43321 m .74814 .38274 L .72209 .37264 L p F P
0 g
s
.514 .39 .649 r
.72209 .37264 m .73446 .43384 L .75889 .43321 L p F P
0 g
s
.794 .933 .567 r
.34595 .43256 m .36077 .41547 L .37753 .38598 L p F P
0 g
s
.626 .863 .5 r
.36077 .41547 m .34595 .43256 L .32707 .45756 L p F P
0 g
s
.582 .921 .711 r
.25912 .51785 m .26793 .51277 L .28802 .49651 L p F P
0 g
s
.519 .889 .687 r
.23904 .53266 m .26793 .51277 L .25912 .51785 L closepath p F P
0 g
s
.994 .803 .542 r
.22146 .6226 m .23797 .58765 L .23648 .57475 L p F P
0 g
s
.988 .784 .541 r
.23797 .58765 m .22146 .6226 L .22699 .63159 L p F P
0 g
s
.564 .608 .856 r
.81003 .56849 m .8022 .55304 L .7844 .56976 L p F P
0 g
s
.556 .586 .839 r
.77514 .5509 m .7844 .56976 L .8022 .55304 L p F P
0 g
s
.272 .081 .428 r
.77407 .73124 m .79311 .71127 L .79316 .70784 L p F P
0 g
s
.263 .067 .416 r
.79311 .71127 m .77407 .73124 L .77393 .73474 L p F P
0 g
s
.235 .086 .466 r
.79302 .69427 m .81055 .67564 L .81027 .66907 L p F P
0 g
s
.218 .064 .447 r
.81055 .67564 m .79302 .69427 L .79313 .69959 L p F P
0 g
s
.909 .558 .361 r
.29432 .75817 m .28814 .74679 L .27586 .7442 L p F P
0 g
s
.917 .582 .392 r
.27135 .73078 m .27586 .7442 L .28814 .74679 L p F P
0 g
s
.38 .562 .907 r
.70993 .35194 m .70385 .34246 L .67862 .33728 L p F P
0 g
s
.363 .571 .918 r
.672 .32777 m .67862 .33728 L .70385 .34246 L p F P
0 g
s
.511 .509 .79 r
.76563 .52965 m .75579 .50485 L .73426 .51167 L p F P
0 g
s
.5 .467 .752 r
.72318 .47895 m .73426 .51167 L .75579 .50485 L p F P
0 g
s
.997 .819 .541 r
.21736 .61484 m .23648 .57475 L .23561 .56332 L p F P
0 g
s
.994 .803 .542 r
.23648 .57475 m .21736 .61484 L .22146 .6226 L p F P
0 g
s
.776 .325 .178 r
.51407 .81093 m .54479 .83662 L .55417 .83238 L p F P
0 g
s
.5 .467 .752 r
.75579 .50485 m .74549 .47437 L .72318 .47895 L p F P
0 g
s
.59 .133 .135 r
.4438 .79266 m .41541 .78764 L .40346 .79791 L p F P
0 g
s
.538 .071 .093 r
.37643 .7948 m .40346 .79791 L .41541 .78764 L p F P
0 g
s
.263 .067 .416 r
.77393 .73474 m .79304 .71438 L .79311 .71127 L p F P
0 g
s
.254 .054 .405 r
.79304 .71438 m .77393 .73474 L .77376 .73796 L p F P
0 g
s
.937 .615 .403 r
.27135 .73078 m .26651 .71293 L .25952 .70832 L p F P
0 g
s
.902 .535 .334 r
.30015 .768 m .29432 .75817 L .2802 .7553 L p F P
0 g
s
.909 .558 .361 r
.27586 .7442 m .2802 .7553 L .29432 .75817 L p F P
0 g
s
.429 .628 .937 r
.672 .32777 m .66536 .31884 L .63927 .31508 L p F P
0 g
s
.408 .638 .95 r
.63159 .30576 m .63927 .31508 L .66536 .31884 L p F P
0 g
s
.476 .678 .954 r
.63927 .31508 m .63159 .30576 L .60357 .30207 L p F P
0 g
s
.218 .064 .447 r
.79313 .69959 m .81069 .68059 L .81055 .67564 L p F P
0 g
s
.203 .044 .43 r
.81069 .68059 m .79313 .69959 L .79317 .704 L p F P
0 g
s
.154 .047 .47 r
.82494 .63263 m .80911 .65266 L .81027 .66907 L p F P
0 g
s
.305 .484 .87 r
.74814 .38274 m .74216 .37193 L .71601 .36199 L p F P
0 g
s
.29 .491 .881 r
.70993 .35194 m .71601 .36199 L .74216 .37193 L p F P
0 g
s
.999 .833 .54 r
.21418 .60786 m .23561 .56332 L .23518 .55295 L p F P
0 g
s
.997 .819 .541 r
.23561 .56332 m .21418 .60786 L .21736 .61484 L p F P
0 g
s
.589 .629 .859 r
.81003 .56849 m .81769 .58281 L .82937 .55314 L p F P
0 g
s
.141 .125 .577 r
.83018 .5569 m .82937 .55314 L .81769 .58281 L p F P
0 g
s
.141 .125 .577 r
.81769 .58281 m .81833 .58618 L .83018 .5569 L p F P
0 g
s
.679 .978 .872 r
.23904 .53266 m .25912 .51785 L .25044 .51997 L closepath p F P
0 g
s
.68 .961 .941 r
.23904 .53266 m .25044 .51997 L .24182 .52004 L closepath p F P
0 g
s
.621 .92 .977 r
.23904 .53266 m .24182 .52004 L .23323 .51862 L closepath p F P
0 g
s
.524 .862 .994 r
.23904 .53266 m .23323 .51862 L .22464 .51608 L closepath p F P
0 g
s
.397 .785 .99 r
.23904 .53266 m .22464 .51608 L .21602 .51268 L closepath p F P
0 g
s
.95 .94 .741 r
.23581 .53417 m .23904 .53266 L .21602 .51268 L p F P
0 g
s
.254 .054 .405 r
.77376 .73796 m .79295 .71725 L .79304 .71438 L p F P
0 g
s
.805 .906 .911 r
.79295 .71725 m .77376 .73796 L .7644 .73241 L p F P
0 g
s
.854 .911 .871 r
.74382 .75695 m .7644 .73241 L .77376 .73796 L p F P
0 g
s
.136 .116 .57 r
.83101 .56092 m .83018 .5569 L .81833 .58618 L p F P
0 g
s
.136 .116 .57 r
.81833 .58618 m .81898 .58978 L .83101 .56092 L p F P
0 g
s
.784 .366 .256 r
.54479 .83662 m .51407 .81093 L .50252 .81739 L p F P
0 g
s
.698 .226 .126 r
.4726 .80181 m .50252 .81739 L .51407 .81093 L p F P
0 g
s
.893 .514 .307 r
.30573 .77671 m .30015 .768 L .28444 .7649 L p F P
0 g
s
.902 .535 .334 r
.2802 .7553 m .28444 .7649 L .30015 .768 L p F P
0 g
s
.932 .944 .603 r
.36344 .40149 m .37753 .38598 L .38901 .34943 L p F P
0 g
s
.794 .933 .567 r
.37753 .38598 m .36344 .40149 L .34595 .43256 L p F P
0 g
s
.999 .845 .538 r
.21168 .60145 m .23518 .55295 L .23508 .54339 L p F P
0 g
s
.999 .833 .54 r
.23518 .55295 m .21168 .60145 L .21418 .60786 L p F P
0 g
s
.13 .107 .562 r
.83187 .56525 m .83101 .56092 L .81898 .58978 L p F P
0 g
s
.13 .107 .562 r
.81898 .58978 m .81967 .59367 L .83187 .56525 L p F P
0 g
s
.684 .97 .767 r
.27629 .5025 m .28802 .49651 L .30765 .47847 L p F P
0 g
s
.582 .921 .711 r
.28802 .49651 m .27629 .5025 L .25912 .51785 L p F P
0 g
s
.203 .044 .43 r
.79317 .704 m .81076 .6847 L .81069 .68059 L p F P
0 g
s
.19 .027 .416 r
.81076 .6847 m .79317 .704 L .79316 .70784 L p F P
0 g
s
.556 .586 .839 r
.8022 .55304 m .79419 .53609 L .77514 .5509 L p F P
0 g
s
.547 .558 .817 r
.76563 .52965 m .77514 .5509 L .79419 .53609 L p F P
0 g
s
.885 .493 .282 r
.31113 .78456 m .30573 .77671 L .28861 .77343 L p F P
0 g
s
.893 .514 .307 r
.28444 .7649 m .28861 .77343 L .30573 .77671 L p F P
0 g
s
.123 .097 .553 r
.83277 .57001 m .83187 .56525 L .81967 .59367 L p F P
0 g
s
.123 .097 .553 r
.81967 .59367 m .82039 .59794 L .83277 .57001 L p F P
0 g
s
.363 .571 .918 r
.70385 .34246 m .69775 .33355 L .672 .32777 L p F P
0 g
s
.342 .578 .929 r
.66536 .31884 m .672 .32777 L .69775 .33355 L p F P
0 g
s
.999 .845 .538 r
.23508 .54339 m .20969 .59548 L .21168 .60145 L p F P
0 g
s
.651 .212 .193 r
.4726 .80181 m .4438 .79266 L .43118 .80388 L p F P
0 g
s
.59 .133 .135 r
.40346 .79791 m .43118 .80388 L .4438 .79266 L p F P
0 g
s
.859 .42 .164 r
.31875 .79147 m .32414 .8251 L .33272 .82787 L p F P
0 g
s
.577 .198 .286 r
.37643 .7948 m .3503 .79332 L .34185 .80601 L p F P
0 g
s
.114 .085 .543 r
.83373 .57535 m .83277 .57001 L .82039 .59794 L p F P
0 g
s
.114 .085 .543 r
.82039 .59794 m .82116 .60274 L .83373 .57535 L p F P
0 g
s
.19 .027 .416 r
.79316 .70784 m .81077 .68827 L .81076 .6847 L p F P
0 g
s
.178 .01 .402 r
.81077 .68827 m .79316 .70784 L .79311 .71127 L p F P
0 g
s
.95 .94 .741 r
.21602 .51268 m .21493 .51506 L .23581 .53417 L p F P
0 g
s
.931 .586 .354 r
.27586 .7442 m .27135 .73078 L .26146 .72437 L p F P
0 g
s
.937 .615 .403 r
.25952 .70832 m .26146 .72437 L .27135 .73078 L p F P
0 g
s
.948 .625 .385 r
.26146 .72437 m .25952 .70832 L .25269 .70104 L p F P
0 g
s
.885 .493 .282 r
.28861 .77343 m .29273 .78113 L .31113 .78456 L p F P
0 g
s
.997 .856 .536 r
.23525 .53447 m .20811 .58984 L .20969 .59548 L p F P
0 g
s
.29 .491 .881 r
.74216 .37193 m .7362 .36179 L .70993 .35194 L p F P
0 g
s
.271 .497 .891 r
.70385 .34246 m .70993 .35194 L .7362 .36179 L p F P
0 g
s
.103 .07 .531 r
.83478 .5816 m .83373 .57535 L .82116 .60274 L p F P
0 g
s
.103 .07 .531 r
.82116 .60274 m .82201 .60838 L .83478 .5816 L p F P
0 g
s
.589 .629 .859 r
.82937 .55314 m .82359 .54139 L .81003 .56849 L p F P
0 g
s
.581 .61 .847 r
.8022 .55304 m .81003 .56849 L .82359 .54139 L p F P
0 g
s
.178 .01 .402 r
.79311 .71127 m .81075 .69146 L .81077 .68827 L p F P
0 g
s
.166 0 .389 r
.81075 .69146 m .79311 .71127 L .79304 .71438 L p F P
0 g
s
.408 .638 .95 r
.66536 .31884 m .65868 .31051 L .63159 .30576 L p F P
0 g
s
.382 .647 .961 r
.62386 .29717 m .63159 .30576 L .65868 .31051 L p F P
0 g
s
.713 .986 .874 r
.25044 .51997 m .25912 .51785 L .27629 .5025 L p F P
0 g
s
.154 .047 .47 r
.81027 .66907 m .82616 .64885 L .82494 .63263 L p F P
0 g
s
.114 0 .428 r
.82616 .64885 m .81027 .66907 L .81055 .67564 L p F P
0 g
s
.547 .558 .817 r
.79419 .53609 m .78595 .51704 L .76563 .52965 L p F P
0 g
s
.536 .523 .788 r
.75579 .50485 m .76563 .52965 L .78595 .51704 L p F P
0 g
s
.089 .05 .514 r
.83601 .5896 m .83478 .5816 L .82201 .60838 L p F P
0 g
s
.089 .05 .514 r
.82201 .60838 m .82301 .61563 L .83601 .5896 L p F P
0 g
s
.984 .713 .425 r
.23343 .67889 m .23979 .67623 L .23523 .64292 L p F P
0 g
s
.984 .713 .425 r
.23523 .64292 m .22699 .63159 L .23343 .67889 L p F P
0 g
s
.166 0 .389 r
.79304 .71438 m .81071 .69435 L .81075 .69146 L p F P
0 g
s
.154 0 .376 r
.81071 .69435 m .79304 .71438 L .79295 .71725 L p F P
0 g
s
.517 .436 .703 r
.76847 .46811 m .75889 .43321 L .73446 .43384 L p F P
0 g
s
.517 .436 .703 r
.73446 .43384 m .74549 .47437 L .76847 .46811 L p F P
0 g
s
.96 .936 .712 r
.21493 .51506 m .21382 .51769 L .23252 .53617 L p F P
0 g
s
.969 .931 .682 r
.22915 .5388 m .23252 .53617 L .21382 .51769 L p F P
0 g
s
.774 .995 .791 r
.2942 .48475 m .30765 .47847 L .32707 .45756 L p F P
0 g
s
.684 .97 .767 r
.30765 .47847 m .2942 .48475 L .27629 .5025 L p F P
0 g
s
.87 .934 .861 r
.7644 .73241 m .74382 .75695 L .73457 .75411 L p F P
0 g
s
.932 .921 .778 r
.74382 .75695 m .72157 .78999 L .7136 .78981 L p F P
0 g
s
.932 .921 .778 r
.7136 .78981 m .73457 .75411 L .74382 .75695 L p F P
0 g
s
.924 .558 .311 r
.2802 .7553 m .27586 .7442 L .26376 .73643 L p F P
0 g
s
.931 .586 .354 r
.26146 .72437 m .26376 .73643 L .27586 .7442 L p F P
0 g
s
.948 .625 .385 r
.25269 .70104 m .25177 .71411 L .26146 .72437 L p F P
0 g
s
.959 .64 .376 r
.25177 .71411 m .25269 .70104 L .24607 .69078 L p F P
0 g
s
.054 .006 .479 r
.8383 .60821 m .83601 .5896 L .82301 .61563 L p F P
0 g
s
.054 .006 .479 r
.82301 .61563 m .82494 .63263 L .8383 .60821 L p F P
0 g
s
.154 0 .376 r
.79295 .71725 m .81064 .69702 L .81071 .69435 L p F P
0 g
s
.77 .904 .934 r
.81064 .69702 m .79295 .71725 L .78395 .71123 L p F P
0 g
s
.805 .906 .911 r
.7644 .73241 m .78395 .71123 L .79295 .71725 L p F P
0 g
s
.716 .301 .258 r
.50252 .81739 m .4726 .80181 L .45994 .81402 L p F P
0 g
s
.651 .212 .193 r
.43118 .80388 m .45994 .81402 L .4726 .80181 L p F P
0 g
s
.342 .578 .929 r
.69775 .33355 m .69163 .3252 L .66536 .31884 L p F P
0 g
s
.316 .583 .938 r
.65868 .31051 m .66536 .31884 L .69163 .3252 L p F P
0 g
s
.599 .223 .301 r
.40346 .79791 m .37643 .7948 L .3652 .81331 L p F P
0 g
s
.577 .198 .286 r
.34185 .80601 m .3652 .81331 L .37643 .7948 L p F P
0 g
s
.15 .378 .83 r
.74216 .37193 m .74814 .38274 L .77746 .40343 L p F P
0 g
s
.538 .41 .654 r
.78522 .43636 m .77746 .40343 L .74814 .38274 L p F P
0 g
s
.538 .41 .654 r
.74814 .38274 m .75889 .43321 L .78522 .43636 L p F P
0 g
s
.114 0 .428 r
.81055 .67564 m .82645 .65531 L .82616 .64885 L p F P
0 g
s
.091 0 .404 r
.82645 .65531 m .81055 .67564 L .81069 .68059 L p F P
0 g
s
.271 .497 .891 r
.7362 .36179 m .73024 .3523 L .70385 .34246 L p F P
0 g
s
.247 .501 .899 r
.69775 .33355 m .70385 .34246 L .73024 .3523 L p F P
0 g
s
.536 .523 .788 r
.78595 .51704 m .77742 .49495 L .75579 .50485 L p F P
0 g
s
.526 .482 .75 r
.74549 .47437 m .75579 .50485 L .77742 .49495 L p F P
0 g
s
.986 .851 .621 r
.68333 .8609 m .7136 .78981 L .72157 .78999 L closepath p F P
0 g
s
.581 .61 .847 r
.82359 .54139 m .81768 .52875 L .8022 .55304 L p F P
0 g
s
.573 .588 .83 r
.79419 .53609 m .8022 .55304 L .81768 .52875 L p F P
0 g
s
.932 .944 .603 r
.38901 .34943 m .3772 .36058 L .36344 .40149 L p F P
0 g
s
.526 .482 .75 r
.77742 .49495 m .76847 .46811 L .74549 .47437 L p F P
0 g
s
.784 .366 .256 r
.50252 .81739 m .53522 .84408 L .54479 .83662 L p F P
0 g
s
.943 .595 .325 r
.26376 .73643 m .26146 .72437 L .25177 .71411 L p F P
0 g
s
.959 .64 .376 r
.24607 .69078 m .24236 .69957 L .25177 .71411 L p F P
0 g
s
.969 .664 .381 r
.24236 .69957 m .24607 .69078 L .23979 .67623 L p F P
0 g
s
.915 .532 .27 r
.28444 .7649 m .2802 .7553 L .26626 .74642 L p F P
0 g
s
.924 .558 .311 r
.26376 .73643 m .26626 .74642 L .2802 .7553 L p F P
0 g
s
.969 .931 .682 r
.21382 .51769 m .21267 .52065 L .22915 .5388 L p F P
0 g
s
.975 .924 .648 r
.22569 .54221 m .22915 .5388 L .21267 .52065 L p F P
0 g
s
.091 0 .404 r
.81069 .68059 m .82658 .66017 L .82645 .65531 L p F P
0 g
s
.07 0 .383 r
.82658 .66017 m .81069 .68059 L .81076 .6847 L p F P
0 g
s
.818 .932 .907 r
.78395 .71123 m .7644 .73241 L .75496 .72812 L p F P
0 g
s
.87 .934 .861 r
.73457 .75411 m .75496 .72812 L .7644 .73241 L p F P
0 g
s
.969 .664 .381 r
.23979 .67623 m .23343 .67889 L .24236 .69957 L p F P
0 g
s
.849 .998 .786 r
.31267 .46408 m .32707 .45756 L .34595 .43256 L p F P
0 g
s
.774 .995 .791 r
.32707 .45756 m .31267 .46408 L .2942 .48475 L p F P
0 g
s
.15 .378 .83 r
.77746 .40343 m .77101 .39097 L .74216 .37193 L p F P
0 g
s
.131 .384 .839 r
.7362 .36179 m .74216 .37193 L .77101 .39097 L p F P
0 g
s
.382 .647 .961 r
.65868 .31051 m .65197 .30279 L .62386 .29717 L p F P
0 g
s
.347 .652 .969 r
.61606 .28934 m .62386 .29717 L .65197 .30279 L p F P
0 g
s
.07 0 .383 r
.81076 .6847 m .82664 .66418 L .82658 .66017 L p F P
0 g
s
.052 0 .364 r
.82664 .66418 m .81076 .6847 L .81077 .68827 L p F P
0 g
s
.628 .256 .318 r
.43118 .80388 m .40346 .79791 L .39073 .81993 L p F P
0 g
s
.599 .223 .301 r
.3652 .81331 m .39073 .81993 L .40346 .79791 L p F P
0 g
s
.573 .588 .83 r
.81768 .52875 m .81165 .51495 L .79419 .53609 L p F P
0 g
s
.563 .561 .809 r
.78595 .51704 m .79419 .53609 L .81165 .51495 L p F P
0 g
s
.905 .505 .23 r
.28861 .77343 m .28444 .7649 L .26889 .75506 L p F P
0 g
s
.915 .532 .27 r
.26626 .74642 m .26889 .75506 L .28444 .7649 L p F P
0 g
s
.247 .501 .899 r
.73024 .3523 m .72428 .34344 L .69775 .33355 L p F P
0 g
s
.219 .503 .905 r
.69163 .3252 m .69775 .33355 L .72428 .34344 L p F P
0 g
s
0 0 .41 r
.8383 .60821 m .82494 .63263 L .82616 .64885 L p F P
0 g
s
.316 .583 .938 r
.69163 .3252 m .6855 .31742 L .65868 .31051 L p F P
0 g
s
.284 .586 .944 r
.65197 .30279 m .65868 .31051 L .6855 .31742 L p F P
0 g
s
.713 .986 .874 r
.27629 .5025 m .26471 .50389 L .25044 .51997 L p F P
0 g
s
.757 .971 .926 r
.24182 .52004 m .25044 .51997 L .26471 .50389 L p F P
0 g
s
.78 .987 .897 r
.26471 .50389 m .27629 .5025 L .2942 .48475 L p F P
0 g
s
.606 .292 .412 r
.3652 .81331 m .34185 .80601 L .33272 .82787 L p F P
0 g
s
.987 .714 .373 r
.22933 .68068 m .23343 .67889 L .22699 .63159 L p F P
0 g
s
.987 .714 .373 r
.22699 .63159 m .22146 .6226 L .22933 .68068 L p F P
0 g
s
.052 0 .364 r
.81077 .68827 m .82664 .66766 L .82664 .66418 L p F P
0 g
s
.035 0 .346 r
.82664 .66766 m .81077 .68827 L .81075 .69146 L p F P
0 g
s
.975 .924 .648 r
.21267 .52065 m .21147 .52404 L .22569 .54221 L p F P
0 g
s
.98 .914 .609 r
.22209 .54672 m .22569 .54221 L .21147 .52404 L p F P
0 g
s
.783 .395 .321 r
.53522 .84408 m .50252 .81739 L .49061 .83032 L p F P
0 g
s
.716 .301 .258 r
.45994 .81402 m .49061 .83032 L .50252 .81739 L p F P
0 g
s
.842 .38 .084 r
.30491 .79079 m .31553 .82105 L .32414 .8251 L p F P
0 g
s
.621 .952 .928 r
.37275 .29951 m .41558 .30016 L .42746 .29393 L p F P
0 g
s
.936 .566 .269 r
.26626 .74642 m .26376 .73643 L .25188 .72391 L p F P
0 g
s
.943 .595 .325 r
.25177 .71411 m .25188 .72391 L .26376 .73643 L p F P
0 g
s
.955 .613 .307 r
.25188 .72391 m .25177 .71411 L .24236 .69957 L p F P
0 g
s
.035 0 .346 r
.81075 .69146 m .82661 .67076 L .82664 .66766 L p F P
0 g
s
.018 0 .329 r
.82661 .67076 m .81075 .69146 L .81071 .69435 L p F P
0 g
s
0 0 .448 r
.82572 .48165 m .82333 .47457 L .82937 .55314 L p F P
0 g
s
0 .048 .609 r
.82614 .48291 m .82794 .48257 L p .82725 .48091 L F P
0 g
s
.71 .67 .809 r
.82359 .54139 m .82937 .55314 L .82351 .47697 L p F P
0 g
s
.71 .67 .809 r
.82351 .47697 m .82333 .47457 L .82333 .47638 L p F P
0 g
s
.71 .67 .809 r
.82333 .47638 m .82359 .54139 L p .82351 .47697 L F P
0 g
s
0 0 .452 r
.82817 .48923 m .82616 .483 L p .83018 .55686 L F P
0 g
s
0 0 .452 r
.83018 .5569 m .83101 .56092 L .82817 .48923 L p F P
0 g
s
0 0 .454 r
.83067 .49741 m .82817 .48923 L .83101 .56092 L p F P
0 g
s
0 0 .454 r
.83101 .56092 m .83187 .56525 L .83172 .5571 L p F P
0 g
s
0 0 .454 r
.83172 .5571 m .83067 .49741 L p .83099 .5577 L F P
0 g
s
0 0 .454 r
.83101 .56092 m .83172 .5571 L .83099 .5577 L F
.83326 .50638 m .83067 .49741 L .83187 .56525 L p F P
0 g
s
0 0 .454 r
.83187 .56525 m .83277 .57001 L .83284 .56034 L p F P
0 g
s
0 0 .454 r
.83284 .56034 m .83326 .50638 L p .83199 .56018 L F P
0 g
s
0 0 .454 r
.83187 .56525 m .83284 .56034 L .83199 .56018 L F
0 0 .452 r
.83596 .51643 m .83326 .50638 L .83277 .57001 L p F P
0 g
s
0 0 .452 r
.83277 .57001 m .83373 .57535 L .83417 .56377 L p F P
0 g
s
0 0 .452 r
.83417 .56377 m .83596 .51643 L p .83317 .56323 L F P
0 g
s
0 0 .452 r
.83277 .57001 m .83417 .56377 L .83317 .56323 L F
0 0 .446 r
.83883 .52814 m .83596 .51643 L .83373 .57535 L p F P
0 g
s
0 0 .446 r
.83373 .57535 m .83478 .5816 L .83883 .52814 L p F P
0 g
s
0 0 .435 r
.84203 .54296 m .83883 .52814 L .83478 .5816 L p F P
0 g
s
0 0 .435 r
.83478 .5816 m .83601 .5896 L .84203 .54296 L p F P
0 g
s
0 0 .392 r
.84714 .57618 m .84203 .54296 L .83601 .5896 L p F P
0 g
s
0 0 .482 r
.82614 .48291 m .84578 .57013 L p .84775 .57041 L F P
0 g
s
0 0 .482 r
.84578 .57013 m .84714 .57618 L .84767 .57117 L p F P
0 g
s
0 0 .482 r
.84767 .57117 m .84775 .57041 L p .84578 .57013 L F P
0 g
s
0 0 .482 r
.82616 .48299 m .84586 .56279 L .82615 .48291 L F
.84586 .56279 m .84775 .57041 L .84587 .56279 L F
.84586 .56279 m .84587 .56279 L .82615 .48291 L F
.82794 .48257 m .82615 .48291 L p .84234 .54849 L F P
0 g
s
0 0 .482 r
.84775 .57041 m .84273 .54817 L p .84234 .54849 L F P
0 g
s
0 0 .482 r
.84273 .54817 m .82794 .48257 L p .84234 .54849 L F P
0 g
s
0 0 .482 r
.82615 .48291 m .82614 .48291 L p .82616 .48299 L F P
0 g
s
0 0 .452 r
.83018 .5569 m .83018 .55686 L .82608 .48275 L F
.82616 .483 m .82608 .48275 L p .83018 .55686 L F P
0 g
s
0 0 .452 r
.82608 .48275 m .82572 .48165 L .82575 .48205 L p F P
0 g
s
0 0 .452 r
.82575 .48205 m .83018 .5569 L p .82608 .48275 L F P
0 g
s
0 .048 .609 r
.8258 .48201 m .82608 .48275 L p .82725 .48091 L F P
0 g
s
0 .048 .609 r
.82608 .48275 m .82614 .48291 L p .82615 .4829 L F P
0 g
s
0 .048 .609 r
.82608 .48275 m .82615 .4829 L .82725 .48091 L F
.672 .639 .808 r
.81768 .52875 m .82359 .54139 L .82333 .47457 L closepath p F P
0 g
s
.633 .603 .802 r
.81165 .51495 m .81768 .52875 L .82333 .47457 L closepath p F P
0 g
s
0 .002 .576 r
.77101 .39097 m .77746 .40343 L .82094 .47087 L p F P
0 g
s
0 .002 .576 r
.82094 .47087 m .82333 .47457 L p .8212 .47117 L F P
0 g
s
0 .002 .576 r
.77101 .39097 m .82094 .47087 L .8212 .47117 L F
0 .048 .609 r
.82502 .47564 m .8258 .48201 L .82725 .48091 L F
.81835 .45983 m .82278 .47302 L .82502 .47564 L F
.633 .483 .662 r
.77746 .40343 m .78522 .43636 L .82219 .47343 L p F P
0 g
s
.633 .483 .662 r
.82219 .47343 m .82333 .47457 L .82094 .47087 L p F P
0 g
s
.633 .483 .662 r
.82094 .47087 m .77746 .40343 L p .82219 .47343 L F P
0 g
s
.596 .565 .789 r
.80544 .4996 m .81165 .51495 L .82333 .47457 L closepath p F P
0 g
s
0 .002 .576 r
.82333 .47457 m .81222 .44531 L .77101 .39097 L p F P
0 g
s
.58 .48 .705 r
.78522 .43636 m .79233 .46159 L .82257 .47425 L p F P
0 g
s
.58 .48 .705 r
.82257 .47425 m .82333 .47457 L .82219 .47343 L p F P
0 g
s
.58 .48 .705 r
.82219 .47343 m .78522 .43636 L p .82257 .47425 L F P
0 g
s
.568 .526 .769 r
.79903 .48213 m .80544 .4996 L .82333 .47457 L closepath p F P
0 g
s
.56 .496 .74 r
.79233 .46159 m .79903 .48213 L .82333 .47457 L closepath p F P
0 g
s
0 .048 .609 r
.82191 .47165 m .82431 .47805 L p .81835 .45983 L F P
0 g
s
0 .048 .609 r
.82431 .47805 m .8258 .48201 L p .82489 .47931 L F P
0 g
s
0 .048 .609 r
.82431 .47805 m .82489 .47931 L .81835 .45983 L F
.82278 .47302 m .82454 .47825 L .82502 .47564 L F
.82454 .47825 m .8258 .48201 L .82561 .48045 L F
.82454 .47825 m .82561 .48045 L .82502 .47564 L F
0 .093 .649 r
.76461 .3795 m .77101 .39097 L .81116 .44391 L p F P
0 g
s
0 .093 .649 r
.81116 .44391 m .81222 .44531 L p .81125 .44396 L F P
0 g
s
0 .093 .649 r
.76461 .3795 m .81116 .44391 L .81125 .44396 L F
.8016 .42163 m .79882 .41847 L p .80682 .43371 L F P
0 g
s
0 .093 .649 r
.811 .44258 m .8016 .42163 L p .81125 .44396 L F P
0 g
s
0 .142 .685 r
.75823 .36895 m .76461 .3795 L .79882 .41847 L p F P
0 g
s
0 .142 .685 r
.79882 .41847 m .8016 .42163 L p .79899 .41846 L F P
0 g
s
0 .142 .685 r
.75823 .36895 m .79882 .41847 L .79899 .41846 L F
.79126 .40193 m .7887 .39938 L p .793 .40564 L F P
0 g
s
0 .142 .685 r
.79742 .41367 m .79126 .40193 L p .79899 .41846 L F P
0 g
s
0 .161 .695 r
.75188 .35929 m .75823 .36895 L .7887 .39938 L p F P
0 g
s
0 .161 .695 r
.7887 .39938 m .79126 .40193 L p .78852 .39896 L F P
0 g
s
0 .161 .695 r
.75188 .35929 m .7887 .39938 L .78852 .39896 L F
.79126 .40193 m .78111 .38558 L .75188 .35929 L p F P
0 g
s
0 .027 .589 r
.78585 .39294 m .7939 .40696 L .79912 .41357 L F
.78111 .38558 m .7868 .3951 L p .78585 .39294 L F P
0 g
s
0 .027 .589 r
.7868 .3951 m .7939 .40696 L p .78585 .39294 L F P
0 g
s
0 .027 .589 r
.7939 .40696 m .79552 .40966 L .79644 .41066 L p F P
0 g
s
0 .027 .589 r
.79644 .41066 m .79912 .41357 L p .7939 .40696 L F P
0 g
s
0 .142 .685 r
.75823 .36895 m .79899 .41846 L .793 .40564 L F
.7887 .39938 m .75823 .36895 L p .793 .40564 L F P
0 g
s
0 .142 .685 r
.8016 .42163 m .79742 .41367 L p .79899 .41846 L F P
0 g
s
0 .064 .628 r
.79708 .41263 m .7997 .41845 L .80015 .41845 L F
.79552 .40966 m .79742 .41367 L p .79708 .41263 L F P
0 g
s
0 .064 .628 r
.79742 .41367 m .7997 .41845 L p .79708 .41263 L F P
0 g
s
0 .064 .628 r
.80015 .41845 m .8082 .43633 L .8131 .44299 L F
.7997 .41845 m .8082 .43633 L p .80015 .41845 L F P
0 g
s
0 .064 .628 r
.8082 .43633 m .81038 .44091 L .81075 .4412 L p F P
0 g
s
0 .064 .628 r
.81075 .4412 m .8131 .44299 L p .8082 .43633 L F P
0 g
s
0 .093 .649 r
.76461 .3795 m .81125 .44396 L .80682 .43371 L F
.79882 .41847 m .76461 .3795 L p .80682 .43371 L F P
0 g
s
0 .093 .649 r
.81222 .44531 m .811 .44258 L p .81125 .44396 L F P
0 g
s
0 .048 .609 r
.81094 .44226 m .81161 .44419 L .81181 .44433 L F
.81038 .44091 m .811 .44258 L p .81094 .44226 L F P
0 g
s
0 .048 .609 r
.811 .44258 m .81161 .44419 L p .81094 .44226 L F P
0 g
s
0 .048 .609 r
.81181 .44433 m .82191 .47165 L .81835 .45983 L F
.81161 .44419 m .82191 .47165 L p .81181 .44433 L F P
0 g
s
0 0 .448 r
.82937 .55314 m .83018 .5569 L .82575 .48205 L p F P
0 g
s
0 0 .448 r
.82575 .48205 m .82572 .48165 L p .82574 .48206 L F P
0 g
s
0 0 .448 r
.82937 .55314 m .82575 .48205 L .82574 .48206 L F
.894 .478 .19 r
.29273 .78113 m .28861 .77343 L .27163 .76273 L p F P
0 g
s
.905 .505 .23 r
.26889 .75506 m .27163 .76273 L .28861 .77343 L p F P
0 g
s
.913 .98 .756 r
.3313 .43935 m .34595 .43256 L .36344 .40149 L p F P
0 g
s
.849 .998 .786 r
.34595 .43256 m .3313 .43935 L .31267 .46408 L p F P
0 g
s
.563 .561 .809 r
.81165 .51495 m .80544 .4996 L .78595 .51704 L p F P
0 g
s
.553 .528 .782 r
.77742 .49495 m .78595 .51704 L .80544 .4996 L p F P
0 g
s
.131 .384 .839 r
.77101 .39097 m .76461 .3795 L .7362 .36179 L p F P
0 g
s
.106 .387 .844 r
.73024 .3523 m .7362 .36179 L .76461 .3795 L p F P
0 g
s
.536 .449 .703 r
.79233 .46159 m .78522 .43636 L .75889 .43321 L p F P
0 g
s
.536 .449 .703 r
.75889 .43321 m .76847 .46811 L .79233 .46159 L p F P
0 g
s
.018 0 .329 r
.81071 .69435 m .82655 .67357 L .82661 .67076 L p F P
0 g
s
.002 0 .313 r
.82655 .67357 m .81071 .69435 L .81064 .69702 L p F P
0 g
s
.237 0 0 r
.61221 .87795 m .59892 .87976 L .56371 .90356 L p F P
0 g
s
.578 .936 .927 r
.38478 .29301 m .42746 .29393 L .43954 .2883 L p F P
0 g
s
.621 .952 .928 r
.42746 .29393 m .38478 .29301 L .37275 .29951 L p F P
0 g
s
.885 .961 .843 r
.75496 .72812 m .73457 .75411 L .72526 .75319 L p F P
0 g
s
.945 .938 .754 r
.73457 .75411 m .7136 .78981 L .70559 .79139 L p F P
0 g
s
.945 .938 .754 r
.70559 .79139 m .72526 .75319 L .73457 .75411 L p F P
0 g
s
.77 .904 .934 r
.78395 .71123 m .80243 .69128 L .81064 .69702 L p F P
0 g
s
.778 .931 .933 r
.80243 .69128 m .78395 .71123 L .77488 .70639 L p F P
0 g
s
.818 .932 .907 r
.75496 .72812 m .77488 .70639 L .78395 .71123 L p F P
0 g
s
.666 .297 .337 r
.45994 .81402 m .43118 .80388 L .41778 .82806 L p F P
0 g
s
.628 .256 .318 r
.39073 .81993 m .41778 .82806 L .43118 .80388 L p F P
0 g
s
.894 .478 .19 r
.27163 .76273 m .27444 .76967 L .29273 .78113 L p F P
0 g
s
.219 .503 .905 r
.72428 .34344 m .71832 .3352 L .69163 .3252 L p F P
0 g
s
.184 .501 .908 r
.6855 .31742 m .69163 .3252 L .71832 .3352 L p F P
0 g
s
.002 0 .313 r
.81064 .69702 m .82647 .67614 L .82655 .67357 L p F P
0 g
s
.746 .912 .949 r
.82647 .67614 m .81064 .69702 L .80243 .69128 L p F P
0 g
s
.98 .914 .609 r
.21147 .52404 m .2102 .52802 L .22209 .54672 L p F P
0 g
s
.981 .899 .563 r
.2183 .55288 m .22209 .54672 L .2102 .52802 L p F P
0 g
s
.553 .528 .782 r
.80544 .4996 m .79903 .48213 L .77742 .49495 L p F P
0 g
s
.543 .49 .747 r
.76847 .46811 m .77742 .49495 L .79903 .48213 L p F P
0 g
s
.99 .867 .615 r
.68333 .8609 m .70559 .79139 L .7136 .78981 L closepath p F P
0 g
s
.543 .49 .747 r
.79903 .48213 m .79233 .46159 L .76847 .46811 L p F P
0 g
s
.955 .613 .307 r
.24236 .69957 m .24031 .70609 L .25188 .72391 L p F P
0 g
s
.967 .644 .311 r
.24031 .70609 m .24236 .69957 L .23343 .67889 L p F P
0 g
s
0 0 .41 r
.82616 .64885 m .83961 .62567 L .8383 .60821 L p F P
0 g
s
0 0 .348 r
.83961 .62567 m .82616 .64885 L .82645 .65531 L p F P
0 g
s
.347 .652 .969 r
.65197 .30279 m .64521 .2957 L .61606 .28934 L p F P
0 g
s
.621 .257 .331 r
.60632 .3261 m .61606 .28934 L .64521 .2957 L p F P
0 g
s
.662 .283 .317 r
.61606 .28934 m .60632 .3261 L .57413 .31351 L p F P
0 g
s
.924 .536 .214 r
.26889 .75506 m .26626 .74642 L .25254 .732 L p F P
0 g
s
.936 .566 .269 r
.25188 .72391 m .25254 .732 L .26626 .74642 L p F P
0 g
s
.284 .586 .944 r
.6855 .31742 m .67934 .31023 L .65197 .30279 L p F P
0 g
s
.245 .585 .946 r
.64521 .2957 m .65197 .30279 L .67934 .31023 L p F P
0 g
s
.237 0 0 r
.56371 .90356 m .5773 .90186 L .61221 .87795 L p F P
0 g
s
.578 .936 .927 r
.43954 .2883 m .39713 .28713 L .38478 .29301 L p F P
0 g
s
.98 .707 .319 r
.22643 .68201 m .22933 .68068 L .22146 .6226 L p F P
0 g
s
.98 .707 .319 r
.22146 .6226 m .21736 .61484 L .22643 .68201 L p F P
0 g
s
.962 .938 .702 r
.3494 .40834 m .36344 .40149 L .3772 .36058 L p F P
0 g
s
.913 .98 .756 r
.36344 .40149 m .3494 .40834 L .3313 .43935 L p F P
0 g
s
.106 .387 .844 r
.76461 .3795 m .75823 .36895 L .73024 .3523 L p F P
0 g
s
.074 .385 .846 r
.72428 .34344 m .73024 .3523 L .75823 .36895 L p F P
0 g
s
.827 .977 .887 r
.28085 .48551 m .2942 .48475 L .31267 .46408 L p F P
0 g
s
.78 .987 .897 r
.2942 .48475 m .28085 .48551 L .26471 .50389 L p F P
0 g
s
.967 .644 .311 r
.23343 .67889 m .22933 .68068 L .24031 .70609 L p F P
0 g
s
.757 .971 .926 r
.26471 .50389 m .25316 .50233 L .24182 .52004 L p F P
0 g
s
.768 .939 .938 r
.23323 .51862 m .24182 .52004 L .25316 .50233 L p F P
0 g
s
.829 .964 .894 r
.77488 .70639 m .75496 .72812 L .74545 .72566 L p F P
0 g
s
.885 .961 .843 r
.72526 .75319 m .74545 .72566 L .75496 .72812 L p F P
0 g
s
.946 .584 .241 r
.25254 .732 m .25188 .72391 L .24031 .70609 L p F P
0 g
s
.783 .395 .321 r
.49061 .83032 m .52543 .85616 L .53522 .84408 L p F P
0 g
s
0 0 .348 r
.82645 .65531 m .83985 .63252 L .83961 .62567 L p F P
0 g
s
0 0 .31 r
.83985 .63252 m .82645 .65531 L .82658 .66017 L p F P
0 g
s
.62 .311 .426 r
.39073 .81993 m .3652 .81331 L .35269 .85102 L p F P
0 g
s
.606 .292 .412 r
.33272 .82787 m .35269 .85102 L .3652 .81331 L p F P
0 g
s
.981 .899 .563 r
.2102 .52802 m .20884 .53294 L .2183 .55288 L p F P
0 g
s
.976 .876 .501 r
.21417 .56218 m .2183 .55288 L .20884 .53294 L p F P
0 g
s
.91 .504 .159 r
.27163 .76273 m .26889 .75506 L .25355 .73899 L p F P
0 g
s
.924 .536 .214 r
.25254 .732 m .25355 .73899 L .26889 .75506 L p F P
0 g
s
.184 .501 .908 r
.71832 .3352 m .71235 .32761 L .6855 .31742 L p F P
0 g
s
.143 .495 .906 r
.67934 .31023 m .6855 .31742 L .71235 .32761 L p F P
0 g
s
0 0 .392 r
.83601 .5896 m .8383 .60821 L .84714 .57618 L p F P
0 g
s
.712 .348 .357 r
.49061 .83032 m .45994 .81402 L .4466 .83908 L p F P
0 g
s
.666 .297 .337 r
.41778 .82806 m .4466 .83908 L .45994 .81402 L p F P
0 g
s
0 0 .31 r
.82658 .66017 m .83992 .63762 L .83985 .63252 L p F P
0 g
s
0 0 .278 r
.83992 .63762 m .82658 .66017 L .82664 .66418 L p F P
0 g
s
.791 .947 .924 r
.25316 .50233 m .26471 .50389 L .28085 .48551 L p F P
0 g
s
.826 .35 .012 r
.29109 .78544 m .30689 .81577 L .31553 .82105 L p F P
0 g
s
.813 .331 0 r
.30689 .81577 m .29109 .78544 L .27731 .77601 L p F P
0 g
s
.962 .938 .702 r
.3772 .36058 m .36535 .36649 L .3494 .40834 L p F P
0 g
s
.965 .694 .264 r
.22431 .68305 m .22643 .68201 L .21736 .61484 L p F P
0 g
s
.965 .694 .264 r
.21736 .61484 m .21418 .60786 L .22431 .68305 L p F P
0 g
s
.074 .385 .846 r
.75823 .36895 m .75188 .35929 L .72428 .34344 L p F P
0 g
s
.034 .378 .843 r
.71832 .3352 m .72428 .34344 L .75188 .35929 L p F P
0 g
s
.245 .585 .946 r
.67934 .31023 m .67315 .30364 L .64521 .2957 L p F P
0 g
s
.595 .239 .335 r
.63655 .33418 m .64521 .2957 L .67315 .30364 L p F P
0 g
s
.621 .257 .331 r
.64521 .2957 m .63655 .33418 L .60632 .3261 L p F P
0 g
s
0 0 .278 r
.82664 .66418 m .8399 .6418 L .83992 .63762 L p F P
0 g
s
0 0 .248 r
.8399 .6418 m .82664 .66418 L .82664 .66766 L p F P
0 g
s
.946 .584 .241 r
.24031 .70609 m .23915 .71142 L .25254 .732 L p F P
0 g
s
.957 .619 .241 r
.23915 .71142 m .24031 .70609 L .22933 .68068 L p F P
0 g
s
.93 .552 .175 r
.25355 .73899 m .25254 .732 L .23915 .71142 L p F P
0 g
s
.893 .471 .105 r
.27444 .76967 m .27163 .76273 L .25483 .74518 L p F P
0 g
s
.91 .504 .159 r
.25355 .73899 m .25483 .74518 L .27163 .76273 L p F P
0 g
s
.87 .964 .858 r
.29832 .4646 m .31267 .46408 L .3313 .43935 L p F P
0 g
s
.827 .977 .887 r
.31267 .46408 m .29832 .4646 L .28085 .48551 L p F P
0 g
s
.746 .912 .949 r
.80243 .69128 m .81949 .67146 L .82647 .67614 L p F P
0 g
s
.747 .939 .947 r
.81949 .67146 m .80243 .69128 L .79417 .68664 L p F P
0 g
s
.778 .931 .933 r
.77488 .70639 m .79417 .68664 L .80243 .69128 L p F P
0 g
s
0 0 .248 r
.82664 .66766 m .83981 .64539 L .8399 .6418 L p F P
0 g
s
0 0 .22 r
.83981 .64539 m .82664 .66766 L .82661 .67076 L p F P
0 g
s
.718 .185 0 r
.35269 .85102 m .33272 .82787 L .32414 .8251 L p F P
0 g
s
.782 .964 .923 r
.79417 .68664 m .77488 .70639 L .76577 .70325 L p F P
0 g
s
.829 .964 .894 r
.74545 .72566 m .76577 .70325 L .77488 .70639 L p F P
0 g
s
.768 .939 .938 r
.25316 .50233 m .24159 .49873 L .23323 .51862 L p F P
0 g
s
.767 .909 .937 r
.22464 .51608 m .23323 .51862 L .24159 .49873 L p F P
0 g
s
.957 .619 .241 r
.22933 .68068 m .22643 .68201 L .23915 .71142 L p F P
0 g
s
.143 .495 .906 r
.71235 .32761 m .70637 .32066 L .67934 .31023 L p F P
0 g
s
.092 .484 .897 r
.67315 .30364 m .67934 .31023 L .70637 .32066 L p F P
0 g
s
0 0 .22 r
.82661 .67076 m .83968 .64857 L .83981 .64539 L p F P
0 g
s
0 0 .193 r
.83968 .64857 m .82661 .67076 L .82655 .67357 L p F P
0 g
s
.976 .876 .501 r
.20884 .53294 m .20728 .53963 L .21417 .56218 L p F P
0 g
s
.952 .816 .373 r
.20811 .58984 m .21417 .56218 L .20728 .53963 L p F P
0 g
s
.951 .953 .713 r
.72526 .75319 m .70559 .79139 L .69753 .79532 L p F P
0 g
s
.992 .882 .596 r
.68333 .8609 m .69753 .79532 L .70559 .79139 L closepath p F P
0 g
s
.889 .986 .803 r
.74545 .72566 m .72526 .75319 L .7159 .75503 L p F P
0 g
s
.951 .953 .713 r
.69753 .79532 m .7159 .75503 L .72526 .75319 L p F P
0 g
s
0 0 .229 r
.84714 .57618 m .8383 .60821 L .83961 .62567 L p F P
0 g
s
.94 .675 .206 r
.22276 .68386 m .22431 .68305 L .21418 .60786 L p F P
0 g
s
.94 .675 .206 r
.21418 .60786 m .21168 .60145 L .22276 .68386 L p F P
0 g
s
.77 .411 .374 r
.52543 .85616 m .49061 .83032 L .47819 .85433 L p F P
0 g
s
.712 .348 .357 r
.4466 .83908 m .47819 .85433 L .49061 .83032 L p F P
0 g
s
.873 .436 .05 r
.27731 .77601 m .27444 .76967 L .25631 .75077 L p F P
0 g
s
.893 .471 .105 r
.25483 .74518 m .25631 .75077 L .27444 .76967 L p F P
0 g
s
.034 .378 .843 r
.75188 .35929 m .74554 .35052 L .71832 .3352 L p F P
0 g
s
0 .365 .833 r
.71235 .32761 m .71832 .3352 L .74554 .35052 L p F P
0 g
s
0 0 .193 r
.82655 .67357 m .83952 .65142 L .83968 .64857 L p F P
0 g
s
0 0 .167 r
.83952 .65142 m .82655 .67357 L .82647 .67614 L p F P
0 g
s
.633 .325 .431 r
.41778 .82806 m .39073 .81993 L .37644 .86822 L p F P
0 g
s
.62 .311 .426 r
.35269 .85102 m .37644 .86822 L .39073 .81993 L p F P
0 g
s
.909 .516 .108 r
.25483 .74518 m .25355 .73899 L .23856 .71598 L p F P
0 g
s
.93 .552 .175 r
.23915 .71142 m .23856 .71598 L .25355 .73899 L p F P
0 g
s
0 0 .167 r
.82647 .67614 m .83933 .65402 L .83952 .65142 L p F P
0 g
s
.728 .942 .954 r
.83933 .65402 m .82647 .67614 L .81949 .67146 L p F P
0 g
s
.912 .945 .811 r
.31665 .4401 m .3313 .43935 L .3494 .40834 L p F P
0 g
s
.87 .964 .858 r
.3313 .43935 m .31665 .4401 L .29832 .4646 L p F P
0 g
s
.938 .589 .17 r
.23856 .71598 m .23915 .71142 L .22643 .68201 L p F P
0 g
s
.825 .994 .857 r
.76577 .70325 m .74545 .72566 L .73592 .72593 L p F P
0 g
s
.889 .986 .803 r
.7159 .75503 m .73592 .72593 L .74545 .72566 L p F P
0 g
s
.82 .931 .905 r
.2675 .4828 m .28085 .48551 L .29832 .4646 L p F P
0 g
s
.791 .947 .924 r
.28085 .48551 m .2675 .4828 L .25316 .50233 L p F P
0 g
s
.873 .436 .05 r
.25754 .75456 m .25796 .75587 L .26017 .75817 L p F P
0 g
s
.851 .436 0 r
.25631 .75077 m .23856 .72356 L p .25625 .75301 L F P
0 g
s
.851 .436 0 r
.25796 .75587 m .25754 .75456 L p .25625 .75301 L F P
0 g
s
.851 .436 0 r
.25754 .75456 m .25631 .75077 L p .25625 .75301 L F P
0 g
s
.851 .436 0 r
.23856 .72356 m .23892 .72635 L p .25556 .75219 L F P
0 g
s
.851 .436 0 r
.2418 .73112 m .25556 .75219 L p .23892 .72635 L F P
0 g
s
.815 .351 0 r
.25556 .75219 m .25004 .74503 L p .25442 .75082 L F P
0 g
s
.851 .436 0 r
.25556 .75219 m .25796 .75587 L p .25625 .75301 L F P
0 g
s
.815 .351 0 r
.25442 .75082 m .26556 .76556 L .25556 .75219 L F
.25442 .75082 m .28402 .79353 L .26556 .76556 L F
.28959 .80157 m .28602 .79621 L p .28402 .79353 L F P
0 g
s
.815 .351 0 r
.28602 .79621 m .26556 .76556 L p .28402 .79353 L F P
0 g
s
.815 .351 0 r
.25004 .74503 m .25238 .74837 L .25442 .75082 L F
.25238 .74837 m .28167 .79024 L .25442 .75082 L F
.28167 .79024 m .28959 .80157 L .28232 .79107 L F
.28167 .79024 m .28232 .79107 L .25442 .75082 L F
.25004 .74503 m .28094 .79263 L .28959 .80157 L p F P
0 g
s
.839 .395 0 r
.28094 .79263 m .26835 .77324 L p .26759 .77147 L F P
0 g
s
.839 .395 0 r
.26835 .77324 m .2523 .74852 L p .26759 .77147 L F P
0 g
s
.834 .47 0 r
.23856 .72356 m .22165 .68452 L p .23842 .72543 L F P
0 g
s
.834 .47 0 r
.23898 .7268 m .23892 .72635 L p .23842 .72543 L F P
0 g
s
.834 .47 0 r
.23892 .72635 m .23856 .72356 L p .23842 .72543 L F P
0 g
s
.834 .47 0 r
.2255 .69567 m .23758 .72356 L p .22453 .69155 L F P
0 g
s
.839 .395 0 r
.2418 .73112 m .23827 .72515 L p .2523 .74852 L F P
0 g
s
.839 .395 0 r
.23827 .72515 m .23673 .72254 L p .23806 .72477 L F P
0 g
s
.839 .395 0 r
.23806 .72477 m .2523 .74852 L .23827 .72515 L F
.834 .47 0 r
.23758 .72356 m .23827 .72515 L p .23756 .72333 L F P
0 g
s
.834 .47 0 r
.23827 .72515 m .23898 .7268 L p .23842 .72543 L F P
0 g
s
.834 .47 0 r
.23756 .72333 m .23827 .72515 L .23842 .72543 L F
.22453 .69155 m .23758 .72356 L .23756 .72333 L F
.839 .395 0 r
.23806 .72477 m .26759 .77147 L .2523 .74852 L F
.23761 .72395 m .26759 .77147 L .23806 .72477 L F
.2523 .74852 m .25004 .74503 L .2418 .73112 L p F P
0 g
s
.839 .395 0 r
.23761 .72395 m .25872 .75956 L .26759 .77147 L F
.23673 .72254 m .23761 .72395 L .23806 .72477 L F
.23673 .72254 m .23762 .72405 L p .23761 .72395 L F P
0 g
s
.839 .395 0 r
.23762 .72405 m .25872 .75956 L p .23761 .72395 L F P
0 g
s
.839 .395 0 r
.25872 .75956 m .2723 .78242 L p .26759 .77147 L F P
0 g
s
.851 .436 0 r
.23856 .72356 m .25556 .75219 L .25625 .75301 L F
.815 .351 0 r
.26017 .75817 m .25556 .75219 L p .26556 .76556 L F P
0 g
s
.883 .478 .04 r
.2384 .71998 m .23856 .72356 L .25631 .75077 L p F P
0 g
s
.876 .514 .025 r
.23856 .72356 m .2384 .71998 L .22276 .68386 L p F P
0 g
s
.876 .514 .025 r
.22276 .68386 m .22165 .68452 L .23856 .72356 L p F P
0 g
s
.881 .464 .042 r
.2723 .78242 m .23673 .72254 L .23599 .72088 L p F P
0 g
s
.881 .464 .042 r
.23599 .72088 m .22389 .69349 L p .24952 .74057 L F P
0 g
s
.881 .464 .042 r
.24952 .74057 m .2723 .78242 L .23599 .72088 L F
.22582 .69703 m .25823 .76024 L .25946 .76182 L F
.24952 .74057 m .25946 .76182 L .26482 .76867 L F
.22582 .69703 m .25946 .76182 L .24952 .74057 L F
.26369 .77086 m .2723 .78242 L p .26482 .76867 L F P
0 g
s
.881 .464 .042 r
.25823 .76024 m .26369 .77086 L p .26482 .76867 L F P
0 g
s
.839 .395 0 r
.2723 .78242 m .28094 .79263 L p .26759 .77147 L F P
0 g
s
.815 .351 0 r
.26556 .76556 m .26361 .76262 L .26017 .75817 L p F P
0 g
s
.873 .436 .05 r
.25631 .75077 m .25754 .75456 L p .27731 .77601 L F P
0 g
s
.873 .436 .05 r
.26017 .75817 m .27731 .77601 L p .25754 .75456 L F P
0 g
s
.807 .33 0 r
.29825 .80927 m .27731 .77601 L .26361 .76262 L p F P
0 g
s
.807 .33 0 r
.26361 .76262 m .28959 .80157 L .29825 .80927 L p F P
0 g
s
.497 .371 .638 r
.28822 .79803 m .26369 .77086 L .2616 .75815 L p F P
0 g
s
.813 .331 0 r
.27731 .77601 m .29825 .80927 L .30689 .81577 L p F P
0 g
s
.497 .371 .638 r
.2616 .75815 m .25781 .73516 L p .28637 .7942 L F P
0 g
s
.497 .371 .638 r
.28637 .7942 m .28822 .79803 L .2616 .75815 L F
.881 .464 .042 r
.22591 .69741 m .25823 .76024 L p .22582 .69703 L F P
0 g
s
.938 .589 .17 r
.22643 .68201 m .22431 .68305 L .23856 .71598 L p F P
0 g
s
.883 .478 .04 r
.25631 .75077 m .25483 .74518 L .2384 .71998 L p F P
0 g
s
.909 .516 .108 r
.23856 .71598 m .2384 .71998 L .25483 .74518 L p F P
0 g
s
.911 .554 .098 r
.2384 .71998 m .23856 .71598 L .22431 .68305 L p F P
0 g
s
.911 .554 .098 r
.22431 .68305 m .22276 .68386 L .2384 .71998 L p F P
0 g
s
.625 .474 .657 r
.25781 .73516 m .26369 .77086 L .22591 .69741 L p F P
0 g
s
.881 .464 .042 r
.22389 .69349 m .22591 .69741 L p .22582 .69703 L F P
0 g
s
.625 .474 .657 r
.22591 .69741 m .22389 .69349 L .22488 .69471 L p F P
0 g
s
.834 .47 0 r
.22165 .68452 m .22115 .68486 L p .2255 .69567 L F P
0 g
s
.834 .47 0 r
.22349 .69103 m .2255 .69567 L p .22115 .68486 L F P
0 g
s
.834 .47 0 r
.22165 .68452 m .2255 .69567 L .22453 .69155 L F
.625 .474 .657 r
.22488 .69471 m .25781 .73516 L p .22591 .69741 L F P
0 g
s
.834 .47 0 r
.22115 .68486 m .2209 .68503 L p .22128 .68594 L F P
0 g
s
.834 .47 0 r
.2209 .68503 m .22089 .68503 L .22096 .68519 L p F P
0 g
s
.834 .47 0 r
.22096 .68519 m .22128 .68594 L p .2209 .68503 L F P
0 g
s
.866 .619 .087 r
.22165 .68452 m .20969 .59548 L p .22088 .68495 L F P
0 g
s
.866 .619 .087 r
.22089 .68503 m .2209 .68503 L p .22088 .68495 L F P
0 g
s
.866 .619 .087 r
.2209 .68503 m .22165 .68452 L p .22088 .68495 L F P
0 g
s
.886 .648 .129 r
.22096 .68519 m .22088 .68494 L p .22124 .68593 L F P
0 g
s
.886 .648 .129 r
.22088 .68494 m .21882 .67861 L p .22081 .68463 L F P
0 g
s
.886 .648 .129 r
.22081 .68463 m .22124 .68593 L .22088 .68494 L F
.866 .619 .087 r
.20969 .59548 m .20811 .58984 L .22089 .68503 L p F P
0 g
s
.848 .671 .133 r
.20969 .63866 m .20795 .62345 L p .20426 .59147 L F P
0 g
s
.848 .671 .133 r
.20347 .58455 m .20457 .59415 L p .20426 .59147 L F P
0 g
s
.848 .671 .133 r
.20457 .59415 m .20969 .63866 L p .20426 .59147 L F P
0 g
s
.87 .713 .192 r
.20347 .5762 m .20795 .62345 L .20811 .58984 L p F P
0 g
s
.848 .671 .133 r
.20795 .62345 m .20347 .5762 L .20347 .58455 L p F P
0 g
s
.851 .658 .12 r
.20969 .63866 m .20347 .58455 L .20365 .59111 L p F P
0 g
s
.851 .658 .12 r
.21177 .6507 m .20969 .63866 L p .20432 .59639 L F P
0 g
s
.851 .658 .12 r
.20365 .59111 m .20465 .59844 L p .20432 .59639 L F P
0 g
s
.851 .658 .12 r
.20465 .59844 m .21177 .6507 L p .20432 .59639 L F P
0 g
s
.858 .652 .117 r
.21177 .6507 m .20365 .59111 L .20394 .59675 L p F P
0 g
s
.858 .652 .117 r
.21401 .66104 m .21177 .6507 L p .20449 .60052 L F P
0 g
s
.858 .652 .117 r
.20394 .59675 m .2048 .60223 L p .20449 .60052 L F P
0 g
s
.858 .652 .117 r
.2048 .60223 m .21401 .66104 L p .20449 .60052 L F P
0 g
s
.867 .649 .118 r
.21401 .66104 m .20394 .59675 L .20429 .60178 L p F P
0 g
s
.907 .65 .147 r
.22165 .68452 m .22276 .68386 L .21168 .60145 L p F P
0 g
s
.907 .65 .147 r
.21168 .60145 m .20969 .59548 L .22165 .68452 L p F P
0 g
s
.554 .633 .884 r
.21962 .59877 m .21362 .62685 L .20889 .6197 L p F P
0 g
s
.867 .649 .118 r
.21401 .66104 m .2045 .60308 L .21365 .65485 L F
.20478 .60457 m .21637 .67024 L p .2045 .60308 L F P
0 g
s
.867 .649 .118 r
.21637 .67024 m .21503 .66499 L p .21365 .65485 L F P
0 g
s
.867 .649 .118 r
.21503 .66499 m .21401 .66104 L p .21365 .65485 L F P
0 g
s
.867 .649 .118 r
.20429 .60178 m .20478 .60457 L p .2045 .60308 L F P
0 g
s
.877 .648 .122 r
.21637 .67024 m .20429 .60178 L .20469 .60639 L p F P
0 g
s
.877 .648 .122 r
.21882 .67861 m .21637 .67024 L p .2049 .60755 L F P
0 g
s
.877 .648 .122 r
.20469 .60639 m .20517 .60886 L p .2049 .60755 L F P
0 g
s
.877 .648 .122 r
.20517 .60886 m .21882 .67861 L p .2049 .60755 L F P
0 g
s
.886 .648 .129 r
.2165 .66713 m .20517 .60887 L .20512 .61067 L F
.20469 .60639 m .20512 .61067 L p .20517 .60887 L F P
0 g
s
.886 .648 .129 r
.21496 .65888 m .20469 .60639 L p .2165 .66713 L F P
0 g
s
.886 .648 .129 r
.21882 .67861 m .21496 .65888 L p .2165 .66713 L F P
0 g
s
.886 .648 .129 r
.21882 .67861 m .20919 .63085 L .22124 .68593 L F
.20512 .61067 m .20868 .62731 L p .20919 .63085 L F P
0 g
s
.886 .648 .129 r
.20868 .62731 m .22124 .68593 L p .20919 .63085 L F P
0 g
s
.554 .633 .884 r
.20889 .6197 m .20724 .61721 L p .20786 .61209 L F P
0 g
s
.896 .649 .136 r
.21331 .64891 m .20512 .61067 L p .21332 .64894 L F P
0 g
s
.896 .649 .136 r
.20512 .61067 m .20558 .61469 L p .20838 .62743 L F P
0 g
s
.896 .649 .136 r
.208 .62413 m .20512 .61067 L .20838 .62743 L F
.554 .633 .884 r
.20724 .61721 m .20558 .61469 L p .2067 .61341 L F P
0 g
s
.554 .633 .884 r
.2067 .61341 m .20786 .61209 L .20724 .61721 L F
.896 .649 .136 r
.21909 .67614 m .21091 .63768 L .21162 .64218 L F
.22124 .68593 m .21754 .66864 L .21909 .67614 L F
.21754 .66864 m .21091 .63768 L .21909 .67614 L F
.554 .633 .884 r
.20786 .61209 m .21962 .59877 L .20889 .6197 L F
.896 .649 .136 r
.22124 .68593 m .21331 .64891 L p .22124 .68593 L F P
0 g
s
.896 .649 .136 r
.21331 .64891 m .21332 .64894 L .22124 .68593 L F
.21162 .64218 m .208 .62413 L .20838 .62743 L F
.21091 .63768 m .208 .62413 L .21162 .64218 L F
.886 .648 .129 r
.22124 .68593 m .22133 .68632 L .22096 .68519 L p F P
0 g
s
.896 .649 .136 r
.22133 .68632 m .22124 .68593 L p .22124 .68593 L F P
0 g
s
.834 .47 0 r
.22128 .68594 m .22349 .69103 L p .22159 .68601 L F P
0 g
s
.834 .47 0 r
.22115 .68486 m .22128 .68594 L .22159 .68601 L F
.851 .436 0 r
.23892 .72635 m .23898 .7268 L .2418 .73112 L p F P
0 g
s
.783 .908 .927 r
.24159 .49873 m .25316 .50233 L .2675 .4828 L p F P
0 g
s
.718 .185 0 r
.32414 .8251 m .34473 .84766 L .35269 .85102 L p F P
0 g
s
.689 .149 0 r
.34473 .84766 m .32414 .8251 L .31553 .82105 L p F P
0 g
s
.767 .909 .937 r
.24159 .49873 m .22996 .49366 L .22464 .51608 L p F P
0 g
s
.763 .885 .933 r
.21602 .51268 m .22464 .51608 L .22996 .49366 L p F P
0 g
s
.092 .484 .897 r
.70637 .32066 m .70037 .3144 L .67315 .30364 L p F P
0 g
s
.578 .223 .33 r
.66581 .33932 m .67315 .30364 L .70037 .3144 L p F P
0 g
s
.595 .239 .335 r
.67315 .30364 m .66581 .33932 L .63655 .33418 L p F P
0 g
s
.77 .411 .374 r
.47819 .85433 m .51536 .87516 L .52543 .85616 L p F P
0 g
s
0 .365 .833 r
.74554 .35052 m .73921 .34265 L .71235 .32761 L p F P
0 g
s
0 .344 .813 r
.70637 .32066 m .71235 .32761 L .73921 .34265 L p F P
0 g
s
.95 .911 .743 r
.33532 .40976 m .3494 .40834 L .36535 .36649 L p F P
0 g
s
.912 .945 .811 r
.3494 .40834 m .33532 .40976 L .31665 .4401 L p F P
0 g
s
0 0 .229 r
.83961 .62567 m .84838 .60456 L .84714 .57618 L p F P
0 g
s
0 0 .058 r
.84838 .60456 m .83961 .62567 L .83985 .63252 L p F P
0 g
s
.747 .939 .947 r
.79417 .68664 m .81251 .66778 L .81949 .67146 L p F P
0 g
s
.737 .969 .933 r
.81251 .66778 m .79417 .68664 L .7859 .68358 L p F P
0 g
s
.782 .964 .923 r
.76577 .70325 m .7859 .68358 L .79417 .68664 L p F P
0 g
s
.654 .343 .432 r
.4466 .83908 m .41778 .82806 L .40285 .88143 L p F P
0 g
s
.633 .325 .431 r
.37644 .86822 m .40285 .88143 L .41778 .82806 L p F P
0 g
s
.95 .911 .743 r
.36535 .36649 m .35342 .36868 L .33532 .40976 L p F P
0 g
s
0 0 .058 r
.83985 .63252 m .84769 .6145 L .84838 .60456 L p F P
0 g
s
0 0 0 r
.84769 .6145 m .84189 .62783 L p .84132 .63345 L F P
0 g
s
0 0 0 r
.83992 .63762 m .84666 .62129 L .84769 .6145 L p F P
0 g
s
0 0 0 r
.83992 .63762 m .8399 .6418 L p .84074 .63923 L F P
0 g
s
0 0 0 r
.84666 .62129 m .84123 .63444 L p .84074 .63923 L F P
0 g
s
0 0 0 r
.84123 .63444 m .83992 .63762 L p .84074 .63923 L F P
0 g
s
.689 .74 .234 r
.84544 .62638 m .8399 .6418 L .83981 .64539 L p F P
0 g
s
.689 .74 .234 r
.84409 .63035 m .84544 .62638 L p .84003 .64465 L F P
0 g
s
.689 .74 .234 r
.83981 .64539 m .84004 .64458 L p .84003 .64465 L F P
0 g
s
.689 .74 .234 r
.84004 .64458 m .84409 .63035 L p .84003 .64465 L F P
0 g
s
.73 .797 .317 r
.83981 .64539 m .83968 .64857 L p .83976 .64825 L F P
0 g
s
.73 .797 .317 r
.84409 .63035 m .84004 .64458 L p .83976 .64825 L F P
0 g
s
.73 .797 .317 r
.84004 .64458 m .83981 .64539 L p .83976 .64825 L F P
0 g
s
0 0 0 r
.84544 .62638 m .84666 .62129 L p .84035 .64042 L F P
0 g
s
0 0 0 r
.84035 .64046 m .84544 .62638 L .84035 .64042 L F
.84026 .64078 m .84544 .62638 L p .84022 .64081 L F P
0 g
s
.73 .797 .317 r
.83968 .64857 m .84265 .6335 L .84409 .63035 L p F P
0 g
s
.763 .847 .397 r
.84008 .64671 m .83952 .65142 L p .84153 .63993 L F P
0 g
s
.763 .847 .397 r
.83952 .65142 m .83995 .64732 L .83968 .64857 L F
.84136 .64004 m .83968 .64857 L p .84153 .63993 L F P
0 g
s
0 0 0 r
.84775 .57041 m .84767 .57117 L p .8414 .63555 L F P
0 g
s
0 0 0 r
.8414 .63555 m .84775 .57041 L .8414 .63555 L F
.8414 .63561 m .84767 .57117 L .84696 .57814 L F
.84706 .57698 m .8414 .63561 L p .84725 .57514 L F P
0 g
s
0 0 0 r
.83985 .63252 m .83992 .63762 L p .84132 .63345 L F P
0 g
s
0 0 0 r
.84189 .62783 m .83985 .63252 L p .84132 .63345 L F P
0 g
s
0 0 0 r
.8414 .63561 m .84237 .62607 L .84775 .57041 L p F P
0 g
s
.737 .969 .933 r
.7859 .68358 m .80555 .66555 L .81251 .66778 L p F P
0 g
s
.691 .981 .876 r
.80555 .66555 m .7859 .68358 L .77767 .68291 L p F P
0 g
s
.67 .972 .902 r
.82924 .64962 m .81251 .66778 L .80555 .66555 L p F P
0 g
s
.67 .972 .902 r
.80555 .66555 m .82426 .64902 L .82924 .64962 L p F P
0 g
s
.573 .936 .797 r
.82426 .64902 m .80555 .66555 L .79865 .66543 L p F P
0 g
s
.691 .981 .876 r
.77767 .68291 m .79865 .66543 L .80555 .66555 L p F P
0 g
s
.573 .936 .797 r
.79865 .66543 m .81936 .65003 L .82426 .64902 L p F P
0 g
s
0 0 0 r
.81936 .65003 m .79865 .66543 L .79189 .66859 L p F P
0 g
s
.458 .882 .784 r
.81936 .65003 m .83955 .63797 L .82426 .64902 L closepath p F P
0 g
s
0 0 0 r
.79189 .66859 m .8146 .65338 L .81936 .65003 L p F P
0 g
s
.546 .904 .699 r
.79865 .66543 m .77767 .68291 L .76954 .68603 L p F P
0 g
s
.546 .904 .699 r
.76954 .68603 m .79189 .66859 L .79865 .66543 L p F P
0 g
s
0 0 0 r
.8146 .65338 m .79189 .66859 L .78543 .67712 L p F P
0 g
s
0 0 0 r
.8146 .65338 m .83955 .63797 L .81936 .65003 L closepath p F P
0 g
s
.465 .888 .903 r
.82426 .64902 m .83955 .63797 L .82924 .64962 L closepath p F P
0 g
s
0 0 0 r
.81006 .66021 m .83955 .63797 L .8146 .65338 L closepath p F P
0 g
s
0 0 0 r
.78543 .67712 m .81006 .66021 L .8146 .65338 L p F P
0 g
s
.762 .992 .883 r
.7859 .68358 m .76577 .70325 L .75666 .7027 L p F P
0 g
s
.762 .992 .883 r
.75666 .7027 m .77767 .68291 L .7859 .68358 L p F P
0 g
s
.093 0 .048 r
.81006 .66021 m .78543 .67712 L .77955 .69535 L p F P
0 g
s
.249 0 .102 r
.80592 .6726 m .83955 .63797 L .81006 .66021 L closepath p F P
0 g
s
.093 0 .048 r
.77955 .69535 m .80592 .6726 L .81006 .66021 L p F P
0 g
s
.664 .959 .746 r
.77767 .68291 m .75666 .7027 L .74762 .70627 L p F P
0 g
s
.664 .959 .746 r
.74762 .70627 m .76954 .68603 L .77767 .68291 L p F P
0 g
s
0 0 0 r
.79189 .66859 m .76954 .68603 L .76169 .6956 L p F P
0 g
s
0 0 0 r
.76169 .6956 m .78543 .67712 L .79189 .66859 L p F P
0 g
s
.963 .829 .664 r
.81887 .62575 m .81695 .63309 L p .8017 .62012 L F P
0 g
s
.959 .879 .712 r
.81466 .63388 m .81803 .63643 L p .80994 .63551 L F P
0 g
s
.963 .829 .664 r
.81695 .63309 m .8163 .63562 L .81466 .63388 L p F P
0 g
s
.963 .829 .664 r
.81466 .63388 m .8017 .62012 L p .81695 .63309 L F P
0 g
s
.959 .879 .712 r
.78313 .67883 m .80994 .63551 L p .81803 .63643 L F P
0 g
s
.959 .879 .712 r
.80994 .63551 m .81214 .63197 L .81466 .63388 L p F P
0 g
s
.959 .879 .712 r
.81803 .63643 m .822 .63945 L p .81973 .64175 L F P
0 g
s
.959 .879 .712 r
.78313 .67883 m .81803 .63643 L .81973 .64175 L F
.987 .869 .63 r
.83139 .63184 m .82992 .64054 L p .81796 .63622 L F P
0 g
s
.987 .869 .63 r
.8163 .63562 m .81766 .63528 L .81796 .63622 L F
.81766 .63528 m .83139 .63184 L .81796 .63622 L F
.966 .929 .7 r
.78977 .68543 m .81965 .64281 L p .83015 .64169 L F P
0 g
s
.966 .929 .7 r
.82773 .64103 m .83015 .64169 L p .81965 .64281 L F P
0 g
s
.987 .869 .63 r
.82992 .64054 m .82968 .64195 L .82773 .64103 L p F P
0 g
s
.987 .869 .63 r
.82773 .64103 m .8163 .63562 L p .82992 .64054 L F P
0 g
s
.966 .929 .7 r
.81965 .64281 m .822 .63945 L .82773 .64103 L p F P
0 g
s
.966 .929 .7 r
.83015 .64169 m .8312 .64198 L p .83039 .64284 L F P
0 g
s
.966 .929 .7 r
.78977 .68543 m .83015 .64169 L .83039 .64284 L F
.982 .881 .523 r
.84237 .62607 m .8414 .63554 L p .83015 .64169 L F P
0 g
s
.982 .881 .523 r
.82968 .64195 m .8301 .64142 L .83015 .64169 L F
.8301 .64142 m .84237 .62607 L .83015 .64169 L F
.763 .847 .397 r
.83952 .65142 m .84112 .63609 L p .8414 .63556 L F P
0 g
s
.763 .847 .397 r
.84265 .6335 m .84136 .64004 L p .84153 .63993 L F P
0 g
s
.763 .847 .397 r
.8414 .63556 m .84265 .6335 L p .83952 .65141 L F P
0 g
s
0 0 0 r
.8414 .63561 m .8414 .63555 L .8414 .63555 L F
.982 .881 .523 r
.8414 .63554 m .8414 .63561 L .84135 .63564 L p F P
0 g
s
.982 .881 .523 r
.84135 .63564 m .82968 .64195 L p .8414 .63554 L F P
0 g
s
.763 .847 .397 r
.84112 .63609 m .84113 .636 L .84135 .63564 L p F P
0 g
s
.763 .847 .397 r
.84135 .63564 m .8414 .63556 L p .84112 .63609 L F P
0 g
s
.788 .89 .473 r
.84031 .64425 m .84059 .64141 L .84031 .64385 L F
.84113 .636 m .84053 .64178 L p .84059 .64141 L F P
0 g
s
.788 .89 .473 r
.84053 .64178 m .84031 .64385 L p .84059 .64141 L F P
0 g
s
.788 .89 .473 r
.83952 .65142 m .83933 .65402 L p .84031 .64425 L F P
0 g
s
.788 .89 .473 r
.84031 .64385 m .83952 .65142 L p .84031 .64425 L F P
0 g
s
0 0 0 r
.84022 .64081 m .84035 .64046 L .84035 .64042 L F
.8399 .6418 m .84026 .64078 L p .84022 .64081 L F P
0 g
s
.763 .847 .397 r
.83952 .65142 m .8414 .63556 L .83952 .65141 L F
0 0 0 r
.84767 .57117 m .84725 .57514 L p .84696 .57814 L F P
0 g
s
0 0 0 r
.84725 .57514 m .84714 .57618 L .84706 .57698 L p F P
0 g
s
.825 .994 .857 r
.73592 .72593 m .75666 .7027 L .76577 .70325 L p F P
0 g
s
0 .048 .609 r
.82794 .48257 m .8131 .44299 L .81038 .44091 L p F P
0 g
s
0 .153 .682 r
.74554 .35052 m .75188 .35929 L .78111 .38558 L p F P
0 g
s
.728 .942 .954 r
.81949 .67146 m .83428 .65139 L .83933 .65402 L p F P
0 g
s
.712 .963 .941 r
.83428 .65139 m .81949 .67146 L .81251 .66778 L p F P
0 g
s
.853 .921 .876 r
.28392 .46135 m .29832 .4646 L .31665 .4401 L p F P
0 g
s
.82 .931 .905 r
.29832 .4646 m .28392 .46135 L .2675 .4828 L p F P
0 g
s
.753 .31 .201 r
.52722 .30452 m .53716 .29387 L .57413 .31351 L p F P
0 g
s
.865 .474 .298 r
.47068 .26496 m .53716 .29387 L .52722 .30452 L closepath p F P
0 g
s
0 0 .445 r
.84807 .56421 m .82959 .48231 L .82794 .48257 L p F P
0 g
s
0 0 .445 r
.82794 .48257 m .84775 .57041 L .84807 .56421 L p F P
0 g
s
0 0 .569 r
.8131 .44299 m .82794 .48257 L .82959 .48231 L p F P
0 g
s
.689 .149 0 r
.31553 .82105 m .33672 .84336 L .34473 .84766 L p F P
0 g
s
.654 .114 0 r
.33672 .84336 m .31553 .82105 L .30689 .81577 L p F P
0 g
s
.934 .955 .64 r
.7159 .75503 m .69753 .79532 L .68946 .80252 L p F P
0 g
s
.987 .888 .557 r
.68333 .8609 m .68946 .80252 L .69753 .79532 L closepath p F P
0 g
s
.896 .878 .446 r
.21493 .51506 m .21602 .51268 L .21825 .48748 L p F P
0 g
s
.763 .885 .933 r
.22996 .49366 m .21825 .48748 L .21602 .51268 L p F P
0 g
s
0 .344 .813 r
.73921 .34265 m .73289 .33571 L .70637 .32066 L p F P
0 g
s
0 .314 .781 r
.70037 .3144 m .70637 .32066 L .73289 .33571 L p F P
0 g
s
.952 .816 .373 r
.20728 .53963 m .2046 .55708 L .20811 .58984 L p F P
0 g
s
.87 .713 .192 r
.20811 .58984 m .2046 .55708 L .20347 .5762 L p F P
0 g
s
.853 .986 .707 r
.73592 .72593 m .7159 .75503 L .70654 .76101 L p F P
0 g
s
.934 .955 .64 r
.68946 .80252 m .70654 .76101 L .7159 .75503 L p F P
0 g
s
.671 .218 .17 r
.5631 .3283 m .57413 .31351 L .60632 .3261 L p F P
0 g
s
.753 .31 .201 r
.57413 .31351 m .5631 .3283 L .52722 .30452 L p F P
0 g
s
.896 .878 .446 r
.21825 .48748 m .21738 .48989 L .21493 .51506 L p F P
0 g
s
.884 .866 .42 r
.21382 .51769 m .21493 .51506 L .21738 .48989 L p F P
0 g
s
.783 .908 .927 r
.2675 .4828 m .25408 .47774 L .24159 .49873 L p F P
0 g
s
.773 .879 .924 r
.22996 .49366 m .24159 .49873 L .25408 .47774 L p F P
0 g
s
.689 .369 .429 r
.47819 .85433 m .4466 .83908 L .43201 .89167 L p F P
0 g
s
.654 .343 .432 r
.40285 .88143 m .43201 .89167 L .4466 .83908 L p F P
0 g
s
0 0 .569 r
.82959 .48231 m .81574 .44538 L .8131 .44299 L p F P
0 g
s
0 .005 .58 r
.79912 .41357 m .8131 .44299 L .81574 .44538 L p F P
0 g
s
0 .064 .628 r
.8131 .44299 m .79912 .41357 L .79552 .40966 L p F P
0 g
s
.47 .865 .97 r
.66565 .8635 m .68333 .8609 L .66078 .87613 L p F P
0 g
s
.804 .895 .908 r
.25408 .47774 m .2675 .4828 L .28392 .46135 L p F P
0 g
s
.884 .866 .42 r
.21738 .48989 m .21648 .49253 L .21382 .51769 L p F P
0 g
s
.871 .85 .392 r
.21267 .52065 m .21382 .51769 L .21648 .49253 L p F P
0 g
s
.542 0 0 r
.37644 .86822 m .35269 .85102 L .34473 .84766 L p F P
0 g
s
0 0 .399 r
.84805 .55745 m .83103 .48213 L .82959 .48231 L p F P
0 g
s
0 0 .399 r
.82959 .48231 m .84807 .56421 L .84805 .55745 L p F P
0 g
s
0 0 .517 r
.81574 .44538 m .82959 .48231 L .83103 .48213 L p F P
0 g
s
0 .153 .682 r
.78111 .38558 m .7711 .37241 L .74554 .35052 L p F P
0 g
s
0 .117 .64 r
.73921 .34265 m .74554 .35052 L .7711 .37241 L p F P
0 g
s
.762 .984 .745 r
.75666 .7027 m .73592 .72593 L .72642 .73048 L p F P
0 g
s
.853 .986 .707 r
.70654 .76101 m .72642 .73048 L .73592 .72593 L p F P
0 g
s
.891 .909 .831 r
.3019 .43698 m .31665 .4401 L .33532 .40976 L p F P
0 g
s
.853 .921 .876 r
.31665 .4401 m .3019 .43698 L .28392 .46135 L p F P
0 g
s
.871 .85 .392 r
.21648 .49253 m .21555 .49547 L .21267 .52065 L p F P
0 g
s
.855 .832 .36 r
.21147 .52404 m .21267 .52065 L .21555 .49547 L p F P
0 g
s
.654 .114 0 r
.30689 .81577 m .32869 .83813 L .33672 .84336 L p F P
0 g
s
.615 .081 0 r
.32869 .83813 m .30689 .81577 L .29825 .80927 L p F P
0 g
s
0 .314 .781 r
.73289 .33571 m .72657 .32979 L .70037 .3144 L p F P
0 g
s
.558 .195 .308 r
.69443 .34276 m .70037 .3144 L .72657 .32979 L p F P
0 g
s
.578 .223 .33 r
.70037 .3144 m .69443 .34276 L .66581 .33932 L p F P
0 g
s
.602 .144 .138 r
.5955 .34232 m .60632 .3261 L .63655 .33418 L p F P
0 g
s
.671 .218 .17 r
.60632 .3261 m .5955 .34232 L .5631 .3283 L p F P
0 g
s
.855 .832 .36 r
.21555 .49547 m .21458 .49881 L .21147 .52404 L p F P
0 g
s
.835 .81 .323 r
.2102 .52802 m .21147 .52404 L .21458 .49881 L p F P
0 g
s
.712 .963 .941 r
.81251 .66778 m .82924 .64962 L .83428 .65139 L p F P
0 g
s
0 0 .517 r
.83103 .48213 m .81829 .44815 L .81574 .44538 L p F P
0 g
s
0 0 .521 r
.80273 .41795 m .81574 .44538 L .81829 .44815 L p F P
0 g
s
0 .005 .58 r
.81574 .44538 m .80273 .41795 L .79912 .41357 L p F P
0 g
s
.933 .887 .764 r
.32111 .40753 m .33532 .40976 L .35342 .36868 L p F P
0 g
s
.891 .909 .831 r
.33532 .40976 m .32111 .40753 L .3019 .43698 L p F P
0 g
s
.835 .81 .323 r
.21458 .49881 m .21354 .5027 L .2102 .52802 L p F P
0 g
s
.81 .782 .278 r
.20884 .53294 m .2102 .52802 L .21354 .5027 L p F P
0 g
s
.542 0 0 r
.34473 .84766 m .3684 .86456 L .37644 .86822 L p F P
0 g
s
.487 0 0 r
.3684 .86456 m .34473 .84766 L .33672 .84336 L p F P
0 g
s
.326 .764 .967 r
.83428 .65139 m .83955 .63797 L .83933 .65402 L closepath p F P
0 g
s
.788 .89 .473 r
.83933 .65402 m .83955 .63797 L .84113 .636 L p F P
0 g
s
0 0 .34 r
.84755 .54998 m .8322 .48209 L .83103 .48213 L p F P
0 g
s
0 0 .34 r
.83103 .48213 m .84805 .55745 L .84755 .54998 L p F P
0 g
s
0 0 .45 r
.81829 .44815 m .83103 .48213 L .8322 .48209 L p F P
0 g
s
.933 .887 .764 r
.35342 .36868 m .34139 .36812 L .32111 .40753 L p F P
0 g
s
0 .117 .64 r
.7711 .37241 m .7686 .36995 L p .76862 .3701 L F P
0 g
s
0 0 .472 r
.78111 .38558 m .78559 .39093 L p .7686 .36992 L F P
0 g
s
0 0 .472 r
.76699 .36793 m .7686 .36995 L p .7686 .36992 L F P
0 g
s
0 0 .472 r
.7686 .36995 m .78111 .38558 L p .7686 .36992 L F P
0 g
s
0 .117 .64 r
.73921 .34265 m .76862 .3701 L .76347 .36491 L F
.7686 .36995 m .76121 .36264 L p .76862 .3701 L F P
0 g
s
0 .117 .64 r
.75954 .36112 m .73921 .34265 L p .76347 .36491 L F P
0 g
s
0 .049 .561 r
.73289 .33571 m .73921 .34265 L .76121 .36264 L p F P
0 g
s
.472 .008 .071 r
.68731 .35558 m .69443 .34276 L .72221 .34626 L p F P
0 g
s
.504 .042 .09 r
.69443 .34276 m .68731 .35558 L .65707 .35435 L p F P
0 g
s
.472 .008 .071 r
.72221 .34626 m .71718 .35503 L .68731 .35558 L p F P
0 g
s
.262 0 0 r
.67953 .36032 m .68731 .35558 L .71718 .35503 L p F P
0 g
s
.25 0 0 r
.71173 .35911 m .71718 .35503 L .74192 .35709 L closepath p F P
0 g
s
.262 0 0 r
.71718 .35503 m .71173 .35911 L .67953 .36032 L p F P
0 g
s
.013 0 0 r
.70599 .36012 m .71173 .35911 L .74192 .35709 L closepath p F P
0 g
s
.306 0 0 r
.68731 .35558 m .67953 .36032 L .64758 .35934 L p F P
0 g
s
.306 0 0 r
.64758 .35934 m .65707 .35435 L .68731 .35558 L p F P
0 g
s
.39 0 0 r
.65707 .35435 m .64758 .35934 L .61583 .35562 L p F P
0 g
s
.109 0 0 r
.6046 .35475 m .61583 .35562 L .6371 .35811 L p F P
0 g
s
.109 0 0 r
.6371 .35811 m .64758 .35934 L p .63741 .35825 L F P
0 g
s
.109 0 0 r
.6046 .35475 m .6371 .35811 L .63741 .35825 L F
.64758 .35934 m .63758 .35862 L .6046 .35475 L p F P
0 g
s
.055 .621 .735 r
.71173 .35911 m .70599 .36012 L .68639 .36022 L p F P
0 g
s
.008 .583 .738 r
.64758 .35934 m .67953 .36032 L p .66075 .35956 L F P
0 g
s
.008 .583 .738 r
.63758 .35862 m .64497 .35915 L p .66075 .35956 L F P
0 g
s
.008 .583 .738 r
.64497 .35915 m .64758 .35934 L p .66075 .35956 L F P
0 g
s
.008 .583 .738 r
.65904 .35969 m .63828 .35865 L p .67953 .36032 L F P
0 g
s
.008 .583 .738 r
.67953 .36032 m .6713 .36031 L .65904 .35969 L p F P
0 g
s
.008 .583 .738 r
.63826 .35865 m .67953 .36032 L .63828 .35865 L F
.055 .621 .735 r
.6713 .36031 m .67953 .36032 L p .68145 .36025 L F P
0 g
s
.055 .621 .735 r
.67982 .36005 m .68388 .36016 L .71173 .35911 L p F P
0 g
s
.055 .621 .735 r
.68639 .36022 m .6713 .36031 L p .67982 .36005 L F P
0 g
s
.055 .621 .735 r
.67982 .36005 m .71173 .35911 L .68639 .36022 L F
.008 .583 .738 r
.63828 .35865 m .63758 .35862 L p .63826 .35865 L F P
0 g
s
.292 .784 .888 r
.70001 .35898 m .70599 .36012 L .74192 .35709 L closepath p F P
0 g
s
.528 .886 .98 r
.69386 .35629 m .70001 .35898 L .74192 .35709 L closepath p F P
0 g
s
.332 0 0 r
.71718 .35503 m .72221 .34626 L .74192 .35709 L closepath p F P
0 g
s
.669 .91 .977 r
.68755 .35242 m .69386 .35629 L .74192 .35709 L closepath p F P
0 g
s
.504 .042 .09 r
.65707 .35435 m .66581 .33932 L .69443 .34276 L p F P
0 g
s
.546 .086 .112 r
.66581 .33932 m .65707 .35435 L .62656 .35034 L p F P
0 g
s
.502 .808 1 r
.69386 .35629 m .68755 .35242 L .64491 .34522 L p F P
0 g
s
.868 .509 .368 r
.73809 .35979 m .68022 .35259 L p .73971 .35815 L F P
0 g
s
.868 .509 .368 r
.74 .35818 m .73972 .35841 L p .73971 .35815 L F P
0 g
s
.859 .487 .343 r
.72938 .4128 m .73966 .35847 L p .74689 .36567 L F P
0 g
s
.859 .487 .343 r
.73966 .35847 m .73967 .35842 L .73972 .35847 L p F P
0 g
s
.859 .487 .343 r
.73972 .35847 m .74689 .36567 L p .73966 .35847 L F P
0 g
s
.868 .509 .368 r
.73972 .35841 m .73966 .35847 L p .73971 .35815 L F P
0 g
s
.868 .509 .368 r
.73966 .35847 m .73809 .35979 L p .73942 .35844 L F P
0 g
s
.868 .509 .368 r
.73971 .35815 m .73966 .35847 L .73942 .35844 L F
.818 .336 .009 r
.73972 .35843 m .7526 .35762 L .7594 .36476 L F
.73967 .35842 m .73972 .35841 L p .73972 .35843 L F P
0 g
s
.818 .336 .009 r
.73972 .35841 m .7526 .35762 L p .73972 .35843 L F P
0 g
s
0 .049 .561 r
.73289 .33571 m .75863 .36019 L .7521 .35724 L F
.75519 .35913 m .75146 .35696 L p .75863 .36019 L F P
0 g
s
.818 .336 .009 r
.7526 .35762 m .75312 .35759 L .75421 .35883 L p F P
0 g
s
.818 .336 .009 r
.75421 .35883 m .7594 .36476 L p .7526 .35762 L F P
0 g
s
0 .049 .561 r
.75146 .35696 m .75097 .3564 L p .7521 .35724 L F P
0 g
s
0 .049 .561 r
.75097 .3564 m .73289 .33571 L p .7521 .35724 L F P
0 g
s
0 .117 .64 r
.76121 .36264 m .75954 .36112 L p .76347 .36491 L F P
0 g
s
0 .049 .561 r
.76121 .36264 m .75519 .35913 L p .75863 .36019 L F P
0 g
s
0 0 .472 r
.78559 .39093 m .77236 .37439 L .76699 .36793 L p F P
0 g
s
.697 .192 0 r
.75472 .35899 m .76524 .36663 L .77236 .37439 L F
.75312 .35759 m .75519 .35913 L p .75472 .35899 L F P
0 g
s
.697 .192 0 r
.75519 .35913 m .76524 .36663 L p .75472 .35899 L F P
0 g
s
.697 .192 0 r
.76524 .36663 m .76699 .36793 L .76859 .36986 L p F P
0 g
s
.697 .192 0 r
.76859 .36986 m .77236 .37439 L p .76524 .36663 L F P
0 g
s
.762 .984 .745 r
.72642 .73048 m .74762 .70627 L .75666 .7027 L p F P
0 g
s
0 0 .532 r
.78559 .39093 m .79912 .41357 L .80273 .41795 L p F P
0 g
s
0 .027 .589 r
.79912 .41357 m .78559 .39093 L .78111 .38558 L p F P
0 g
s
.773 .879 .924 r
.25408 .47774 m .24054 .47101 L .22996 .49366 L p F P
0 g
s
.763 .857 .92 r
.21825 .48748 m .22996 .49366 L .24054 .47101 L p F P
0 g
s
.615 .081 0 r
.29825 .80927 m .32063 .83198 L .32869 .83813 L p F P
0 g
s
.574 .053 0 r
.29361 .80514 m .28959 .80157 L p .29888 .81067 L F P
0 g
s
.574 .053 0 r
.28959 .80157 m .31254 .82492 L .32063 .83198 L p F P
0 g
s
.532 .029 0 r
.28959 .80157 m .28094 .79263 L p .29419 .80617 L F P
0 g
s
.532 .029 0 r
.31254 .82492 m .29125 .80325 L p .29419 .80617 L F P
0 g
s
.532 .029 0 r
.29125 .80325 m .28959 .80157 L p .29419 .80617 L F P
0 g
s
.574 .053 0 r
.32063 .83198 m .29825 .80927 L .29361 .80514 L p F P
0 g
s
.574 .053 0 r
.29888 .81067 m .32063 .83198 L .29361 .80514 L F
0 0 .506 r
.2723 .78242 m .29633 .80797 L .29918 .81112 L p F P
0 g
s
.532 .029 0 r
.28094 .79263 m .30444 .81692 L .31132 .82371 L p F P
0 g
s
.532 .029 0 r
.28094 .79263 m .31132 .82371 L .30974 .82205 L F
0 0 .506 r
.29918 .81112 m .30444 .81692 L p .29725 .8092 L F P
0 g
s
0 0 .506 r
.2723 .78242 m .29918 .81112 L .29725 .8092 L F
.532 .029 0 r
.31132 .82371 m .31254 .82492 L p .30974 .82205 L F P
0 g
s
.833 .888 .881 r
.2694 .45555 m .28392 .46135 L .3019 .43698 L p F P
0 g
s
.804 .895 .908 r
.28392 .46135 m .2694 .45555 L .25408 .47774 L p F P
0 g
s
.81 .782 .278 r
.21354 .5027 m .21242 .50745 L .20884 .53294 L p F P
0 g
s
.776 .743 .222 r
.20728 .53963 m .20884 .53294 L .21242 .50745 L p F P
0 g
s
.851 .905 .494 r
.70654 .76101 m .68946 .80252 L .6814 .81441 L p F P
0 g
s
0 0 .45 r
.8322 .48209 m .82071 .45143 L .81829 .44815 L p F P
0 g
s
0 0 .447 r
.80633 .42294 m .81829 .44815 L .82071 .45143 L p F P
0 g
s
0 0 .521 r
.81829 .44815 m .80633 .42294 L .80273 .41795 L p F P
0 g
s
.742 .648 .09 r
.84807 .56421 m .84775 .57041 L .84237 .62607 L p F P
0 g
s
.546 .086 .112 r
.62656 .35034 m .63655 .33418 L .66581 .33932 L p F P
0 g
s
.602 .144 .138 r
.63655 .33418 m .62656 .35034 L .5955 .34232 L p F P
0 g
s
.79 .868 .906 r
.24054 .47101 m .25408 .47774 L .2694 .45555 L p F P
0 g
s
0 0 .465 r
.79015 .39689 m .80273 .41795 L .80633 .42294 L p F P
0 g
s
0 0 .532 r
.80273 .41795 m .79015 .39689 L .78559 .39093 L p F P
0 g
s
.896 .649 .136 r
.20558 .61469 m .22389 .69349 L .22133 .68632 L p F P
0 g
s
.553 .459 .702 r
.22389 .69349 m .25122 .70864 L .25781 .73516 L closepath p F P
0 g
s
.518 .472 .744 r
.22389 .69349 m .24419 .68743 L .25122 .70864 L closepath p F P
0 g
s
.528 .51 .779 r
.22389 .69349 m .23685 .66957 L .24419 .68743 L closepath p F P
0 g
s
.568 .559 .804 r
.22389 .69349 m .22928 .65392 L .23685 .66957 L closepath p F P
0 g
s
.619 .606 .816 r
.22389 .69349 m .22153 .63983 L .22928 .65392 L closepath p F P
0 g
s
.668 .645 .818 r
.22389 .69349 m .21362 .62685 L .22153 .63983 L closepath p F P
0 g
s
.709 .674 .814 r
.22389 .69349 m .20558 .61469 L .21362 .62685 L closepath p F P
0 g
s
.776 .743 .222 r
.21242 .50745 m .21112 .51386 L .20728 .53963 L p F P
0 g
s
.704 .662 .111 r
.2046 .55708 m .20728 .53963 L .21112 .51386 L p F P
0 g
s
.687 .871 .478 r
.70654 .76101 m .69727 .7736 L p .7248 .73288 L F P
0 g
s
.687 .871 .478 r
.7251 .73251 m .70654 .76101 L p .7248 .73288 L F P
0 g
s
.687 .871 .478 r
.69727 .7736 m .71708 .7422 L .72642 .73048 L p F P
0 g
s
0 0 0 r
.73881 .71687 m .74762 .70627 L p .72015 .73859 L F P
0 g
s
0 0 0 r
.71708 .7422 m .71962 .73924 L p .72015 .73859 L F P
0 g
s
0 0 0 r
.71962 .73924 m .73881 .71687 L p .72015 .73859 L F P
0 g
s
.687 .871 .478 r
.72642 .73048 m .7251 .73251 L p .7248 .73288 L F P
0 g
s
.851 .905 .494 r
.6814 .81441 m .69727 .7736 L .70654 .76101 L p F P
0 g
s
.487 0 0 r
.33672 .84336 m .36032 .86002 L .3684 .86456 L p F P
0 g
s
.427 0 0 r
.36032 .86002 m .33672 .84336 L .32869 .83813 L p F P
0 g
s
.747 .264 .092 r
.517 .30987 m .52722 .30452 L .5631 .3283 L p F P
0 g
s
0 0 .263 r
.84638 .5415 m .83298 .48222 L .8322 .48209 L p F P
0 g
s
0 0 .263 r
.8322 .48209 m .84755 .54998 L .84638 .5415 L p F P
0 g
s
0 0 .363 r
.82071 .45143 m .8322 .48209 L .83298 .48222 L p F P
0 g
s
.347 0 0 r
.40285 .88143 m .37644 .86822 L .3684 .86456 L p F P
0 g
s
.41 .838 .955 r
.82924 .64962 m .83955 .63797 L .83428 .65139 L closepath p F P
0 g
s
.558 .052 0 r
.72657 .32979 m .73289 .33571 L .75146 .35696 L p F P
0 g
s
.787 .668 .117 r
.84805 .55745 m .84807 .56421 L .84309 .61578 L p F P
0 g
s
.742 .648 .09 r
.84237 .62607 m .84309 .61578 L .84807 .56421 L p F P
0 g
s
.833 .888 .881 r
.3019 .43698 m .28701 .43119 L .2694 .45555 L p F P
0 g
s
.219 0 .112 r
.31785 .41547 m .37275 .29951 L .38478 .29301 L p F P
0 g
s
.171 0 .088 r
.37275 .29951 m .31785 .41547 L .30573 .42193 L p F P
0 g
s
0 0 .363 r
.83298 .48222 m .82294 .45542 L .82071 .45143 L p F P
0 g
s
0 0 .354 r
.80994 .42872 m .82071 .45143 L .82294 .45542 L p F P
0 g
s
0 0 .447 r
.82071 .45143 m .80994 .42872 L .80633 .42294 L p F P
0 g
s
0 0 0 r
.74762 .70627 m .72642 .73048 L .71708 .7422 L p F P
0 g
s
.763 .857 .92 r
.24054 .47101 m .22687 .463 L .21825 .48748 L p F P
0 g
s
.676 .746 .248 r
.21738 .48989 m .21825 .48748 L .22687 .463 L p F P
0 g
s
0 0 .386 r
.7948 .40362 m .80633 .42294 L .80994 .42872 L p F P
0 g
s
0 0 .465 r
.80633 .42294 m .7948 .40362 L .79015 .39689 L p F P
0 g
s
.676 .746 .248 r
.22687 .463 m .22604 .46551 L .21738 .48989 L p F P
0 g
s
0 0 0 r
.21648 .49253 m .21738 .48989 L .22604 .46551 L p F P
0 g
s
.427 0 0 r
.32869 .83813 m .35219 .85462 L .36032 .86002 L p F P
0 g
s
0 .167 .621 r
.35219 .85462 m .32869 .83813 L .32063 .83198 L p F P
0 g
s
.58 .119 0 r
.77236 .37439 m .78559 .39093 L .79015 .39689 L p F P
0 g
s
.275 .771 .89 r
.5773 .90186 m .56371 .90356 L .52542 .89892 L p F P
0 g
s
.204 .725 .861 r
.51167 .90002 m .52542 .89892 L .56371 .90356 L p F P
0 g
s
0 0 .506 r
.30444 .81692 m .28094 .79263 L .2723 .78242 L p F P
0 g
s
.264 0 .133 r
.33047 .40941 m .38478 .29301 L .39713 .28713 L p F P
0 g
s
.219 0 .112 r
.38478 .29301 m .33047 .40941 L .31785 .41547 L p F P
0 g
s
.627 .099 0 r
.55157 .3343 m .5631 .3283 L .5955 .34232 L p F P
0 g
s
.747 .264 .092 r
.5631 .3283 m .55157 .3343 L .517 .30987 L p F P
0 g
s
.83 .685 .145 r
.84755 .54998 m .84805 .55745 L .84347 .60455 L p F P
0 g
s
.787 .668 .117 r
.84309 .61578 m .84347 .60455 L .84805 .55745 L p F P
0 g
s
.704 .662 .111 r
.21112 .51386 m .20877 .5303 L .2046 .55708 L p F P
0 g
s
0 0 .032 r
.20757 .54802 m .20347 .5762 L .2046 .55708 L p F P
0 g
s
0 0 .032 r
.2046 .55708 m .20877 .5303 L .20757 .54802 L p F P
0 g
s
0 0 0 r
.22604 .46551 m .22518 .46825 L .21648 .49253 L p F P
0 g
s
0 0 0 r
.21555 .49547 m .21648 .49253 L .22518 .46825 L p F P
0 g
s
.347 0 0 r
.3684 .86456 m .39429 .87752 L .40285 .88143 L p F P
0 g
s
0 .29 .682 r
.39429 .87752 m .3684 .86456 L .36032 .86002 L p F P
0 g
s
0 0 .164 r
.84418 .53149 m .83313 .48263 L .83298 .48222 L p F P
0 g
s
0 0 .164 r
.83298 .48222 m .84638 .5415 L .84418 .53149 L p F P
0 g
s
.807 .524 0 r
.83997 .51851 m .83207 .48359 L .83313 .48263 L p F P
0 g
s
0 0 .248 r
.82294 .45542 m .83298 .48222 L .83313 .48263 L p F P
0 g
s
.816 .864 .883 r
.25473 .4479 m .2694 .45555 L .28701 .43119 L p F P
0 g
s
.79 .868 .906 r
.2694 .45555 m .25473 .4479 L .24054 .47101 L p F P
0 g
s
.487 .411 .697 r
.28059 .74135 m .25781 .73516 L .25122 .70864 L p F P
0 g
s
.487 .411 .697 r
.25122 .70864 m .27163 .70391 L .28059 .74135 L p F P
0 g
s
.491 .461 .751 r
.27163 .70391 m .25122 .70864 L .24419 .68743 L p F P
0 g
s
.558 .052 0 r
.75146 .35696 m .74192 .35709 L .72657 .32979 L p F P
0 g
s
.271 0 .165 r
.72221 .34626 m .72657 .32979 L .74192 .35709 L closepath p F P
0 g
s
.558 .195 .308 r
.72657 .32979 m .72221 .34626 L .69443 .34276 L p F P
0 g
s
.491 .461 .751 r
.24419 .68743 m .26195 .67578 L .27163 .70391 L p F P
0 g
s
.503 .508 .795 r
.26195 .67578 m .24419 .68743 L .23685 .66957 L p F P
0 g
s
0 0 0 r
.22518 .46825 m .22429 .47131 L .21555 .49547 L p F P
0 g
s
0 0 0 r
.21458 .49881 m .21555 .49547 L .22429 .47131 L p F P
0 g
s
.34 .811 .912 r
.59079 .89947 m .5773 .90186 L .53916 .89712 L p F P
0 g
s
.275 .771 .89 r
.52542 .89892 m .53916 .89712 L .5773 .90186 L p F P
0 g
s
.777 .848 .905 r
.22687 .463 m .24054 .47101 L .25473 .4479 L p F P
0 g
s
.305 0 .152 r
.34358 .40373 m .39713 .28713 L .4098 .28186 L p F P
0 g
s
.264 0 .133 r
.39713 .28713 m .34358 .40373 L .33047 .40941 L p F P
0 g
s
0 0 0 r
.76954 .68603 m .74762 .70627 L .73881 .71687 L p F P
0 g
s
.639 .181 0 r
.77788 .38155 m .79015 .39689 L .7948 .40362 L p F P
0 g
s
.58 .119 0 r
.79015 .39689 m .77788 .38155 L .77236 .37439 L p F P
0 g
s
0 0 .354 r
.82294 .45542 m .81354 .4356 L .80994 .42872 L p F P
0 g
s
0 0 .386 r
.80994 .42872 m .79958 .41136 L .7948 .40362 L p F P
0 g
s
.669 .261 0 r
.79958 .41136 m .80994 .42872 L .81354 .4356 L p F P
0 g
s
.503 .508 .795 r
.23685 .66957 m .25181 .65281 L .26195 .67578 L p F P
0 g
s
.517 .55 .829 r
.25181 .65281 m .23685 .66957 L .22928 .65392 L p F P
0 g
s
.497 .371 .638 r
.25781 .73516 m .28059 .74135 L .28822 .79803 L p F P
0 g
s
0 0 .248 r
.83313 .48263 m .82485 .46053 L .82294 .45542 L p F P
0 g
s
.698 .33 0 r
.81354 .4356 m .82294 .45542 L .82485 .46053 L p F P
0 g
s
0 0 0 r
.22429 .47131 m .22335 .47476 L .21458 .49881 L p F P
0 g
s
0 0 0 r
.21354 .5027 m .21458 .49881 L .22335 .47476 L p F P
0 g
s
0 0 .533 r
.29633 .80797 m .2723 .78242 L .26369 .77086 L p F P
0 g
s
0 .396 .732 r
.43201 .89167 m .40285 .88143 L .39429 .87752 L p F P
0 g
s
0 .167 .621 r
.32063 .83198 m .34402 .84834 L .35219 .85462 L p F P
0 g
s
0 .2 .673 r
.34402 .84834 m .32063 .83198 L .31254 .82492 L p F P
0 g
s
.872 .699 .175 r
.84638 .5415 m .84755 .54998 L .84342 .59211 L p F P
0 g
s
.83 .685 .145 r
.84347 .60455 m .84342 .59211 L .84755 .54998 L p F P
0 g
s
0 0 0 r
.69727 .7736 m .6814 .81441 L .67343 .83334 L p F P
0 g
s
.402 .845 .929 r
.60418 .89639 m .59079 .89947 L .5529 .89462 L p F P
0 g
s
.34 .811 .912 r
.53916 .89712 m .5529 .89462 L .59079 .89947 L p F P
0 g
s
.343 0 .17 r
.35716 .39846 m .4098 .28186 L .42277 .27722 L p F P
0 g
s
.305 0 .152 r
.4098 .28186 m .35716 .39846 L .34358 .40373 L p F P
0 g
s
.517 .55 .829 r
.22928 .65392 m .24134 .63299 L .25181 .65281 L p F P
0 g
s
.531 .584 .853 r
.24134 .63299 m .22928 .65392 L .22153 .63983 L p F P
0 g
s
0 0 0 r
.22335 .47476 m .22236 .47877 L .21354 .5027 L p F P
0 g
s
0 0 0 r
.21242 .50745 m .21354 .5027 L .22236 .47877 L p F P
0 g
s
.502 0 0 r
.58402 .34803 m .5955 .34232 L .62656 .35034 L p F P
0 g
s
.627 .099 0 r
.5955 .34232 m .58402 .34803 L .55157 .3343 L p F P
0 g
s
0 0 .112 r
.20741 .55571 m .20347 .58455 L .20347 .5762 L p F P
0 g
s
0 0 .112 r
.20347 .5762 m .20757 .54802 L .20741 .55571 L p F P
0 g
s
0 .29 .682 r
.36032 .86002 m .38566 .87264 L .39429 .87752 L p F P
0 g
s
0 .335 .749 r
.38566 .87264 m .36032 .86002 L .35219 .85462 L p F P
0 g
s
.698 .247 0 r
.78358 .3896 m .7948 .40362 L .79958 .41136 L p F P
0 g
s
.639 .181 0 r
.7948 .40362 m .78358 .3896 L .77788 .38155 L p F P
0 g
s
.844 .394 .141 r
.47068 .26496 m .517 .30987 L .50653 .31144 L closepath p F P
0 g
s
.657 .123 0 r
.46465 .26667 m .47068 .26496 L .46253 .29544 L p F P
0 g
s
.458 .875 .94 r
.61747 .89263 m .60418 .89639 L .56663 .89142 L p F P
0 g
s
.402 .845 .929 r
.5529 .89462 m .56663 .89142 L .60418 .89639 L p F P
0 g
s
.379 0 .186 r
.3712 .39358 m .42277 .27722 L .43607 .27319 L p F P
0 g
s
.343 0 .17 r
.42277 .27722 m .3712 .39358 L .35716 .39846 L p F P
0 g
s
0 0 .533 r
.26369 .77086 m .28822 .79803 L .29633 .80797 L p F P
0 g
s
0 0 0 r
.22236 .47877 m .22128 .48366 L .21242 .50745 L p F P
0 g
s
0 0 0 r
.21112 .51386 m .21242 .50745 L .22128 .48366 L p F P
0 g
s
.531 .584 .853 r
.22153 .63983 m .2306 .61519 L .24134 .63299 L p F P
0 g
s
.543 .612 .871 r
.2306 .61519 m .22153 .63983 L .21362 .62685 L p F P
0 g
s
.716 .193 0 r
.50653 .31144 m .517 .30987 L .55157 .3343 L p F P
0 g
s
.698 .33 0 r
.82485 .46053 m .81711 .44421 L .81354 .4356 L p F P
0 g
s
.755 .351 0 r
.80452 .4205 m .81354 .4356 L .81711 .44421 L p F P
0 g
s
.669 .261 0 r
.81354 .4356 m .80452 .4205 L .79958 .41136 L p F P
0 g
s
0 0 .149 r
.20743 .56173 m .20365 .59111 L .20347 .58455 L p F P
0 g
s
0 0 .149 r
.20347 .58455 m .20741 .55571 L .20743 .56173 L p F P
0 g
s
.853 .862 .847 r
.27194 .42345 m .28701 .43119 L .30676 .40268 L p F P
0 g
s
.816 .864 .883 r
.28701 .43119 m .27194 .42345 L .25473 .4479 L p F P
0 g
s
0 .506 .743 r
.50492 .90517 m .46494 .8996 L .45356 .89542 L p F P
0 g
s
.807 .524 0 r
.83313 .48263 m .84418 .53149 L .83997 .51851 L p F P
0 g
s
.791 .453 0 r
.82485 .46053 m .83313 .48263 L .83207 .48359 L p F P
0 g
s
0 0 0 r
.73881 .71687 m .76169 .6956 L .76954 .68603 L p F P
0 g
s
0 .2 .673 r
.31254 .82492 m .33582 .84119 L .34402 .84834 L p F P
0 g
s
0 .226 .714 r
.33582 .84119 m .31254 .82492 L .30444 .81692 L p F P
0 g
s
0 0 .178 r
.20754 .56689 m .20394 .59675 L .20365 .59111 L p F P
0 g
s
0 0 .178 r
.20365 .59111 m .20743 .56173 L .20754 .56689 L p F P
0 g
s
0 0 0 r
.71708 .7422 m .69727 .7736 L .68825 .79751 L p F P
0 g
s
0 0 0 r
.67343 .83334 m .68825 .79751 L .69727 .7736 L p F P
0 g
s
.91 .707 .206 r
.84418 .53149 m .84638 .5415 L .84277 .57798 L p F P
0 g
s
.872 .699 .175 r
.84342 .59211 m .84277 .57798 L .84638 .5415 L p F P
0 g
s
.511 .899 .948 r
.63066 .88818 m .61747 .89263 L .58033 .88752 L p F P
0 g
s
.458 .875 .94 r
.56663 .89142 m .58033 .88752 L .61747 .89263 L p F P
0 g
s
.412 .029 .201 r
.38572 .38911 m .43607 .27319 L .44968 .26981 L p F P
0 g
s
.379 0 .186 r
.43607 .27319 m .38572 .38911 L .3712 .39358 L p F P
0 g
s
0 .396 .732 r
.39429 .87752 m .42242 .88753 L .43201 .89167 L p F P
0 g
s
0 .452 .814 r
.42242 .88753 m .39429 .87752 L .38566 .87264 L p F P
0 g
s
.757 .316 0 r
.78952 .39881 m .79958 .41136 L .80452 .4205 L p F P
0 g
s
.698 .247 0 r
.79958 .41136 m .78952 .39881 L .78358 .3896 L p F P
0 g
s
0 .501 .796 r
.46494 .8996 m .43201 .89167 L .42242 .88753 L p F P
0 g
s
0 0 0 r
.22128 .48366 m .22002 .49024 L .21112 .51386 L p F P
0 g
s
0 0 .086 r
.20877 .5303 m .21112 .51386 L .22002 .49024 L p F P
0 g
s
.791 .453 0 r
.83207 .48359 m .82614 .46777 L .82485 .46053 L p F P
0 g
s
.81 .442 0 r
.81711 .44421 m .82485 .46053 L .82614 .46777 L p F P
0 g
s
.456 .39 .694 r
.3021 .74375 m .28059 .74135 L .27163 .70391 L p F P
0 g
s
.456 .39 .694 r
.27163 .70391 m .29152 .69945 L .3021 .74375 L p F P
0 g
s
.463 .447 .755 r
.29152 .69945 m .27163 .70391 L .26195 .67578 L p F P
0 g
s
.543 .612 .871 r
.21362 .62685 m .21962 .59877 L .2306 .61519 L p F P
0 g
s
0 0 .201 r
.20771 .5715 m .20429 .60178 L .20394 .59675 L p F P
0 g
s
0 0 .201 r
.20394 .59675 m .20754 .56689 L .20771 .5715 L p F P
0 g
s
.901 .853 .787 r
.32925 .36547 m .31696 .36115 L .29223 .39587 L p F P
0 g
s
.901 .853 .787 r
.29223 .39587 m .30676 .40268 L .32925 .36547 L p F P
0 g
s
.463 .447 .755 r
.26195 .67578 m .28011 .66693 L .29152 .69945 L p F P
0 g
s
.475 .499 .803 r
.28011 .66693 m .26195 .67578 L .25181 .65281 L p F P
0 g
s
.777 .848 .905 r
.25473 .4479 m .23988 .43886 L .22687 .463 L p F P
0 g
s
0 0 0 r
.22604 .46551 m .22687 .463 L .23988 .43886 L p F P
0 g
s
0 .335 .749 r
.35219 .85462 m .37696 .86683 L .38566 .87264 L p F P
0 g
s
0 .37 .8 r
.37696 .86683 m .35219 .85462 L .34402 .84834 L p F P
0 g
s
.732 .237 0 r
.7594 .36476 m .77236 .37439 L .77788 .38155 L p F P
0 g
s
.697 .192 0 r
.77236 .37439 m .7594 .36476 L .75312 .35759 L p F P
0 g
s
.39 0 0 r
.61583 .35562 m .62656 .35034 L .65707 .35435 L p F P
0 g
s
.502 0 0 r
.62656 .35034 m .61583 .35562 L .58402 .34803 L p F P
0 g
s
0 0 .221 r
.20792 .57571 m .20469 .60639 L .20429 .60178 L p F P
0 g
s
0 0 .221 r
.20429 .60178 m .20771 .5715 L .20792 .57571 L p F P
0 g
s
.802 .846 .884 r
.23988 .43886 m .25473 .4479 L .27194 .42345 L p F P
0 g
s
.853 .862 .847 r
.30676 .40268 m .29223 .39587 L .27194 .42345 L p F P
0 g
s
.559 .919 .951 r
.64374 .88302 m .63066 .88818 L .59401 .88291 L p F P
0 g
s
.511 .899 .948 r
.58033 .88752 m .59401 .88291 L .63066 .88818 L p F P
0 g
s
0 0 .238 r
.20816 .57962 m .20512 .61067 L .20469 .60639 L p F P
0 g
s
0 0 .238 r
.20469 .60639 m .20792 .57571 L .20816 .57962 L p F P
0 g
s
.412 .029 .201 r
.44968 .26981 m .40113 .38403 L p .38592 .38874 L F P
0 g
s
.524 .233 .414 r
.42516 .31948 m .45008 .34252 L p .41858 .37863 L F P
0 g
s
.524 .233 .414 r
.41612 .38145 m .41644 .37929 L p .41858 .37863 L F P
0 g
s
.524 .233 .414 r
.41644 .37929 m .42516 .31948 L p .41858 .37863 L F P
0 g
s
.412 .029 .201 r
.40069 .38506 m .38572 .38911 L p .38592 .38874 L F P
0 g
s
.412 .029 .201 r
.40113 .38403 m .40069 .38506 L p .38592 .38874 L F P
0 g
s
0 0 0 r
.23988 .43886 m .239 .44156 L .22604 .46551 L p F P
0 g
s
0 0 0 r
.22518 .46825 m .22604 .46551 L .239 .44156 L p F P
0 g
s
0 .501 .796 r
.42242 .88753 m .45356 .89542 L .46494 .8996 L p F P
0 g
s
.462 .34 .628 r
.31105 .81439 m .28822 .79803 L .28059 .74135 L p F P
0 g
s
.462 .34 .628 r
.28059 .74135 m .3021 .74375 L .31105 .81439 L p F P
0 g
s
0 0 .254 r
.20843 .58329 m .20558 .61469 L .20512 .61067 L p F P
0 g
s
0 0 .254 r
.20512 .61067 m .20816 .57962 L .20843 .58329 L p F P
0 g
s
0 .226 .714 r
.30444 .81692 m .32758 .83317 L .33582 .84119 L p F P
0 g
s
0 .245 .742 r
.32758 .83317 m .30444 .81692 L .29633 .80797 L p F P
0 g
s
.475 .499 .803 r
.25181 .65281 m .26817 .64063 L .28011 .66693 L p F P
0 g
s
.49 .543 .839 r
.26817 .64063 m .25181 .65281 L .24134 .63299 L p F P
0 g
s
0 0 0 r
.73881 .71687 m .71708 .7422 L .70816 .76711 L p F P
0 g
s
0 0 0 r
.68825 .79751 m .70816 .76711 L .71708 .7422 L p F P
0 g
s
.766 .284 0 r
.7659 .3727 m .77788 .38155 L .78358 .3896 L p F P
0 g
s
.732 .237 0 r
.77788 .38155 m .7659 .3727 L .7594 .36476 L p F P
0 g
s
.554 .633 .884 r
.20558 .61469 m .20843 .58329 L .21962 .59877 L p F P
0 g
s
0 0 0 r
.239 .44156 m .23808 .44451 L .22518 .46825 L p F P
0 g
s
0 0 0 r
.22429 .47131 m .22518 .46825 L .23808 .44451 L p F P
0 g
s
.81 .442 0 r
.82614 .46777 m .82062 .45612 L .81711 .44421 L p F P
0 g
s
.841 .452 0 r
.80971 .43182 m .81711 .44421 L .82062 .45612 L p F P
0 g
s
.755 .351 0 r
.81711 .44421 m .80971 .43182 L .80452 .4205 L p F P
0 g
s
.815 .391 0 r
.79579 .40964 m .80452 .4205 L .80971 .43182 L p F P
0 g
s
.757 .316 0 r
.80452 .4205 m .79579 .40964 L .78952 .39881 L p F P
0 g
s
.603 .936 .952 r
.65671 .87714 m .64374 .88302 L .60767 .87758 L p F P
0 g
s
.559 .919 .951 r
.59401 .88291 m .60767 .87758 L .64374 .88302 L p F P
0 g
s
.517 0 0 r
.53966 .33478 m .55157 .3343 L .58402 .34803 L p F P
0 g
s
.716 .193 0 r
.55157 .3343 m .53966 .33478 L .50653 .31144 L p F P
0 g
s
0 0 0 r
.23808 .44451 m .23714 .44779 L .22429 .47131 L p F P
0 g
s
0 0 .013 r
.22335 .47476 m .22429 .47131 L .23714 .44779 L p F P
0 g
s
.944 .708 .24 r
.83997 .51851 m .84418 .53149 L .84117 .56123 L p F P
0 g
s
.91 .707 .206 r
.84277 .57798 m .84117 .56123 L .84418 .53149 L p F P
0 g
s
0 .452 .814 r
.38566 .87264 m .41273 .88221 L .42242 .88753 L p F P
0 g
s
.008 .491 .869 r
.41273 .88221 m .38566 .87264 L .37696 .86683 L p F P
0 g
s
0 0 .086 r
.22002 .49024 m .21771 .50706 L .20877 .5303 L p F P
0 g
s
0 0 .207 r
.21647 .5251 m .20757 .54802 L .20877 .5303 L p F P
0 g
s
0 0 .207 r
.20877 .5303 m .21771 .50706 L .21647 .5251 L p F P
0 g
s
0 .37 .8 r
.34402 .84834 m .36821 .86007 L .37696 .86683 L p F P
0 g
s
0 .395 .834 r
.36821 .86007 m .34402 .84834 L .33582 .84119 L p F P
0 g
s
.8 .333 0 r
.77266 .38158 m .78358 .3896 L .78952 .39881 L p F P
0 g
s
.766 .284 0 r
.78358 .3896 m .77266 .38158 L .7659 .3727 L p F P
0 g
s
.49 .543 .839 r
.24134 .63299 m .25584 .61798 L .26817 .64063 L p F P
0 g
s
.504 .579 .864 r
.25584 .61798 m .24134 .63299 L .2306 .61519 L p F P
0 g
s
0 0 .013 r
.23714 .44779 m .23615 .45151 L .22335 .47476 L p F P
0 g
s
0 0 .049 r
.22236 .47877 m .22335 .47476 L .23615 .45151 L p F P
0 g
s
.062 .566 .886 r
.45356 .89542 m .42242 .88753 L .41273 .88221 L p F P
0 g
s
0 .245 .742 r
.29633 .80797 m .31933 .82424 L .32758 .83317 L p F P
0 g
s
0 .258 .761 r
.31933 .82424 m .29633 .80797 L .28822 .79803 L p F P
0 g
s
.1 .622 .88 r
.52788 .90469 m .4753 .89579 L .46003 .88669 L p F P
0 g
s
.008 0 .043 r
.76169 .6956 m .73881 .71687 L .73055 .74085 L p F P
0 g
s
0 0 0 r
.70816 .76711 m .73055 .74085 L .73881 .71687 L p F P
0 g
s
.946 .635 .194 r
.83207 .48359 m .83997 .51851 L .82351 .48789 L closepath p F P
0 g
s
.938 .607 .169 r
.82614 .46777 m .83207 .48359 L .82351 .48789 L closepath p F P
0 g
s
.838 .847 .851 r
.25667 .41422 m .27194 .42345 L .29223 .39587 L p F P
0 g
s
.802 .846 .884 r
.27194 .42345 m .25667 .41422 L .23988 .43886 L p F P
0 g
s
0 0 .049 r
.23615 .45151 m .2351 .45583 L .22236 .47877 L p F P
0 g
s
0 0 .089 r
.22128 .48366 m .22236 .47877 L .2351 .45583 L p F P
0 g
s
.834 .384 0 r
.77977 .3917 m .78952 .39881 L .79579 .40964 L p F P
0 g
s
.8 .333 0 r
.78952 .39881 m .77977 .3917 L .77266 .38158 L p F P
0 g
s
.939 .599 .171 r
.82062 .45612 m .82614 .46777 L .82351 .48789 L closepath p F P
0 g
s
.841 .452 0 r
.82062 .45612 m .81534 .44732 L .80971 .43182 L p F P
0 g
s
.874 .473 .017 r
.80256 .42296 m .80971 .43182 L .81534 .44732 L p F P
0 g
s
.815 .391 0 r
.80971 .43182 m .80256 .42296 L .79579 .40964 L p F P
0 g
s
.657 .101 0 r
.49584 .31023 m .50653 .31144 L .53966 .33478 L p F P
0 g
s
.412 .361 .691 r
.32271 .74547 m .3021 .74375 L .29152 .69945 L p F P
0 g
s
.412 .361 .691 r
.29152 .69945 m .31104 .69686 L .32271 .74547 L p F P
0 g
s
.419 .42 .754 r
.31104 .69686 m .29152 .69945 L .28011 .66693 L p F P
0 g
s
0 0 .092 r
.68825 .79751 m .67343 .83334 L .66565 .8635 L p F P
0 g
s
.504 .579 .864 r
.2306 .61519 m .24318 .59761 L .25584 .61798 L p F P
0 g
s
.517 .607 .882 r
.24318 .59761 m .2306 .61519 L .21962 .59877 L p F P
0 g
s
.119 .625 .899 r
.49027 .90199 m .45356 .89542 L .44203 .88955 L p F P
0 g
s
.119 .625 .899 r
.44203 .88955 m .4753 .89579 L .49027 .90199 L p F P
0 g
s
.419 .42 .754 r
.28011 .66693 m .29854 .66122 L .31104 .69686 L p F P
0 g
s
.433 .475 .804 r
.29854 .66122 m .28011 .66693 L .26817 .64063 L p F P
0 g
s
0 .395 .834 r
.33582 .84119 m .35941 .85236 L .36821 .86007 L p F P
0 g
s
.003 .411 .855 r
.35941 .85236 m .33582 .84119 L .32758 .83317 L p F P
0 g
s
0 0 .089 r
.2351 .45583 m .23395 .46111 L .22128 .48366 L p F P
0 g
s
0 0 .137 r
.22002 .49024 m .22128 .48366 L .23395 .46111 L p F P
0 g
s
.638 .114 0 r
.46086 .2993 m .45916 .30366 L .45852 .26947 L p F P
0 g
s
.619 .109 .016 r
.45225 .27363 m .45852 .26947 L .45916 .30366 L p F P
0 g
s
0 .258 .761 r
.28822 .79803 m .31105 .81439 L .31933 .82424 L p F P
0 g
s
.062 .566 .886 r
.41273 .88221 m .44203 .88955 L .45356 .89542 L p F P
0 g
s
.008 .491 .869 r
.37696 .86683 m .40294 .87572 L .41273 .88221 L p F P
0 g
s
.083 .515 .903 r
.40294 .87572 m .37696 .86683 L .36821 .86007 L p F P
0 g
s
.293 0 0 r
.57209 .34757 m .58402 .34803 L .61583 .35562 L p F P
0 g
s
.517 0 0 r
.58402 .34803 m .57209 .34757 L .53966 .33478 L p F P
0 g
s
0 0 .033 r
.239 .44156 m .23988 .43886 L .25667 .41422 L p F P
0 g
s
0 0 .277 r
.21627 .53291 m .20741 .55571 L .20757 .54802 L p F P
0 g
s
0 0 .277 r
.20757 .54802 m .21647 .5251 L .21627 .53291 L p F P
0 g
s
.942 .597 .183 r
.81534 .44732 m .82062 .45612 L .82351 .48789 L closepath p F P
0 g
s
.868 .44 .02 r
.78737 .40355 m .79579 .40964 L .80256 .42296 L p F P
0 g
s
.834 .384 0 r
.79579 .40964 m .78737 .40355 L .77977 .3917 L p F P
0 g
s
.092 0 .122 r
.30454 .35549 m .30246 .35941 L .29019 .37412 L p F P
0 g
s
.838 .847 .851 r
.29223 .39587 m .27788 .38775 L p .25667 .41422 L F P
0 g
s
.092 0 .122 r
.29019 .37412 m .27616 .39094 L p .28524 .3796 L F P
0 g
s
.092 0 .122 r
.28524 .3796 m .30454 .35549 L .29019 .37412 L F
.838 .847 .851 r
.27788 .38775 m .2775 .38754 L .27387 .39219 L p F P
0 g
s
.838 .847 .851 r
.27387 .39219 m .25667 .41422 L p .27788 .38775 L F P
0 g
s
.077 0 .065 r
.78543 .67712 m .76169 .6956 L .75446 .71738 L p F P
0 g
s
.008 0 .043 r
.73055 .74085 m .75446 .71738 L .76169 .6956 L p F P
0 g
s
.419 .309 .623 r
.33277 .82336 m .31105 .81439 L .3021 .74375 L p F P
0 g
s
.419 .309 .623 r
.3021 .74375 m .32271 .74547 L .33277 .82336 L p F P
0 g
s
0 0 .033 r
.25667 .41422 m .25564 .4172 L .239 .44156 L p F P
0 g
s
0 0 .061 r
.23808 .44451 m .239 .44156 L .25564 .4172 L p F P
0 g
s
.973 .689 .288 r
.83777 .53948 m .82351 .48789 L .83997 .51851 L closepath p F P
0 g
s
.944 .708 .24 r
.84117 .56123 m .83777 .53948 L .83997 .51851 L p F P
0 g
s
0 0 .31 r
.21625 .53903 m .20743 .56173 L .20741 .55571 L p F P
0 g
s
0 0 .31 r
.20741 .55571 m .21627 .53291 L .21625 .53903 L p F P
0 g
s
.433 .475 .804 r
.26817 .64063 m .28549 .63239 L .29854 .66122 L p F P
0 g
s
.449 .522 .841 r
.28549 .63239 m .26817 .64063 L .25584 .61798 L p F P
0 g
s
0 0 .137 r
.23395 .46111 m .23262 .46821 L .22002 .49024 L p F P
0 g
s
0 0 .221 r
.21771 .50706 m .22002 .49024 L .23262 .46821 L p F P
0 g
s
.162 .601 .935 r
.44203 .88955 m .41273 .88221 L .40294 .87572 L p F P
0 g
s
0 0 .061 r
.25564 .4172 m .25458 .42049 L .23808 .44451 L p F P
0 g
s
0 0 .09 r
.23714 .44779 m .23808 .44451 L .25458 .42049 L p F P
0 g
s
.517 .607 .882 r
.21962 .59877 m .23024 .57875 L .24318 .59761 L p F P
0 g
s
.528 .629 .895 r
.23024 .57875 m .21962 .59877 L .20843 .58329 L p F P
0 g
s
0 0 .335 r
.21632 .54426 m .20754 .56689 L .20743 .56173 L p F P
0 g
s
0 0 .335 r
.20743 .56173 m .21625 .53903 L .21632 .54426 L p F P
0 g
s
.003 .411 .855 r
.32758 .83317 m .35057 .84369 L .35941 .85236 L p F P
0 g
s
.053 .42 .866 r
.35057 .84369 m .32758 .83317 L .31933 .82424 L p F P
0 g
s
.835 .363 .034 r
.74689 .36567 m .7594 .36476 L .7659 .3727 L p F P
0 g
s
.818 .336 .009 r
.7594 .36476 m .74689 .36567 L .73967 .35842 L p F P
0 g
s
.947 .598 .203 r
.81028 .44108 m .81534 .44732 L .82351 .48789 L closepath p F P
0 g
s
.874 .473 .017 r
.81534 .44732 m .81028 .44108 L .80256 .42296 L p F P
0 g
s
.903 .502 .097 r
.7957 .41808 m .80256 .42296 L .81028 .44108 L p F P
0 g
s
.868 .44 .02 r
.80256 .42296 m .7957 .41808 L .78737 .40355 L p F P
0 g
s
0 0 .09 r
.25458 .42049 m .25349 .42415 L .23714 .44779 L p F P
0 g
s
0 0 .121 r
.23615 .45151 m .23714 .44779 L .25349 .42415 L p F P
0 g
s
.499 .181 .359 r
.29095 .39053 m .29348 .38174 L .3339 .32832 L p F P
0 g
s
0 0 .355 r
.21644 .54894 m .20771 .5715 L .20754 .56689 L p F P
0 g
s
0 0 .355 r
.20754 .56689 m .21632 .54426 L .21644 .54894 L p F P
0 g
s
.293 0 0 r
.61583 .35562 m .6046 .35475 L .57209 .34757 L p F P
0 g
s
.987 .869 .511 r
.84309 .61578 m .84237 .62607 L .83139 .63184 L p F P
0 g
s
.982 .881 .523 r
.82968 .64195 m .83139 .63184 L .84237 .62607 L p F P
0 g
s
.083 .515 .903 r
.36821 .86007 m .39308 .86806 L .40294 .87572 L p F P
0 g
s
.144 .528 .919 r
.39308 .86806 m .36821 .86007 L .35941 .85236 L p F P
0 g
s
0 0 .372 r
.21661 .55321 m .20792 .57571 L .20771 .5715 L p F P
0 g
s
0 0 .372 r
.20771 .5715 m .21644 .54894 L .21661 .55321 L p F P
0 g
s
.851 .392 .06 r
.75438 .37368 m .7659 .3727 L .77266 .38158 L p F P
0 g
s
.835 .363 .034 r
.7659 .3727 m .75438 .37368 L .74689 .36567 L p F P
0 g
s
.449 .522 .841 r
.25584 .61798 m .27202 .60754 L .28549 .63239 L p F P
0 g
s
.465 .56 .868 r
.27202 .60754 m .25584 .61798 L .24318 .59761 L p F P
0 g
s
0 0 .121 r
.25349 .42415 m .25234 .4283 L .23615 .45151 L p F P
0 g
s
0 0 .154 r
.2351 .45583 m .23615 .45151 L .25234 .4283 L p F P
0 g
s
.077 0 .065 r
.75446 .71738 m .77955 .69535 L .78543 .67712 L p F P
0 g
s
0 0 .388 r
.21681 .55718 m .20816 .57962 L .20792 .57571 L p F P
0 g
s
0 0 .388 r
.20792 .57571 m .21661 .55321 L .21681 .55718 L p F P
0 g
s
.99 .856 .497 r
.84347 .60455 m .84309 .61578 L .83289 .62096 L p F P
0 g
s
.987 .869 .511 r
.83139 .63184 m .83289 .62096 L .84309 .61578 L p F P
0 g
s
.084 0 .253 r
.70816 .76711 m .68825 .79751 L .67983 .84322 L p F P
0 g
s
0 0 .092 r
.66565 .8635 m .67983 .84322 L .68825 .79751 L p F P
0 g
s
.869 .423 .088 r
.76222 .38262 m .77266 .38158 L .77977 .3917 L p F P
0 g
s
.851 .392 .06 r
.77266 .38158 m .76222 .38262 L .75438 .37368 L p F P
0 g
s
.344 0 0 r
.52741 .33152 m .53966 .33478 L .57209 .34757 L p F P
0 g
s
.657 .101 0 r
.53966 .33478 m .52741 .33152 L .49584 .31023 L p F P
0 g
s
0 0 .401 r
.21704 .5609 m .20843 .58329 L .20816 .57962 L p F P
0 g
s
0 0 .401 r
.20816 .57962 m .21681 .55718 L .21704 .5609 L p F P
0 g
s
.619 .109 .016 r
.45916 .30366 m .45744 .30866 L .45225 .27363 L p F P
0 g
s
.599 .111 .066 r
.44584 .27956 m .45225 .27363 L .45744 .30866 L p F P
0 g
s
0 0 .096 r
.25564 .4172 m .25667 .41422 L .2775 .38754 L p F P
0 g
s
.506 .164 .322 r
.80249 .69463 m .83955 .63797 L .80592 .6726 L closepath p F P
0 g
s
.212 0 .244 r
.80592 .6726 m .77955 .69535 L .77509 .73275 L p F P
0 g
s
.212 0 .244 r
.77509 .73275 m .77498 .73367 L p .77687 .72994 L F P
0 g
s
.212 0 .244 r
.77687 .72994 m .80592 .6726 L .77509 .73275 L F
.77498 .73367 m .80249 .69463 L .80372 .68674 L p F P
0 g
s
.212 0 .244 r
.80372 .68674 m .80592 .6726 L p .77687 .72994 L F P
0 g
s
.212 0 .244 r
.77498 .73367 m .80372 .68674 L .77687 .72994 L F
.899 .961 .632 r
.79623 .69071 m .8312 .64198 L .83169 .64175 L p F P
0 g
s
.899 .961 .632 r
.83169 .64175 m .83315 .64104 L p .82689 .64946 L F P
0 g
s
.899 .961 .632 r
.79623 .69071 m .83169 .64175 L .82689 .64946 L F
.83315 .64104 m .83955 .63797 L p .82013 .6616 L F P
0 g
s
.899 .961 .632 r
.79623 .69071 m .83315 .64104 L .82013 .6616 L F
.83955 .63797 m .80249 .69463 L .79623 .69071 L p F P
0 g
s
.261 .676 .966 r
.4753 .89579 m .44203 .88955 L .43035 .88203 L p F P
0 g
s
.162 .601 .935 r
.40294 .87572 m .43035 .88203 L .44203 .88955 L p F P
0 g
s
.528 .629 .895 r
.20843 .58329 m .21704 .5609 L .23024 .57875 L p F P
0 g
s
.994 .84 .481 r
.84342 .59211 m .84347 .60455 L .83414 .60912 L p F P
0 g
s
.99 .856 .497 r
.83289 .62096 m .83414 .60912 L .84347 .60455 L p F P
0 g
s
.053 .42 .866 r
.31933 .82424 m .34168 .83403 L .35057 .84369 L p F P
0 g
s
.095 .423 .868 r
.34168 .83403 m .31933 .82424 L .31105 .81439 L p F P
0 g
s
0 0 .221 r
.23262 .46821 m .2302 .48637 L .21771 .50706 L p F P
0 g
s
0 0 .321 r
.22892 .50589 m .21647 .5251 L .21771 .50706 L p F P
0 g
s
0 0 .321 r
.21771 .50706 m .2302 .48637 L .22892 .50589 L p F P
0 g
s
0 0 .154 r
.25234 .4283 m .25113 .43315 L .2351 .45583 L p F P
0 g
s
0 0 .19 r
.23395 .46111 m .2351 .45583 L .25113 .43315 L p F P
0 g
s
.092 0 .122 r
.27616 .39094 m .2775 .38754 L .30454 .35549 L p F P
0 g
s
.238 .615 .955 r
.43035 .88203 m .40294 .87572 L .39308 .86806 L p F P
0 g
s
.886 .456 .118 r
.77051 .39278 m .77977 .3917 L .78737 .40355 L p F P
0 g
s
.869 .423 .088 r
.77977 .3917 m .77051 .39278 L .76222 .38262 L p F P
0 g
s
.952 .604 .229 r
.80544 .4377 m .81028 .44108 L .82351 .48789 L closepath p F P
0 g
s
.903 .502 .097 r
.81028 .44108 m .80544 .4377 L .7957 .41808 L p F P
0 g
s
0 0 .096 r
.2775 .38754 m .27616 .39094 L .25564 .4172 L p F P
0 g
s
0 0 .124 r
.25458 .42049 m .25564 .4172 L .27616 .39094 L p F P
0 g
s
.339 .313 .683 r
.34204 .74733 m .32271 .74547 L .31104 .69686 L p F P
0 g
s
.339 .313 .683 r
.31104 .69686 m .3298 .69682 L .34204 .74733 L p F P
0 g
s
.344 .37 .745 r
.3298 .69682 m .31104 .69686 L .29854 .66122 L p F P
0 g
s
.57 0 0 r
.48493 .30689 m .49584 .31023 L .52741 .33152 L p F P
0 g
s
.996 .822 .463 r
.84277 .57798 m .84342 .59211 L .83505 .59603 L p F P
0 g
s
.994 .84 .481 r
.83414 .60912 m .83505 .59603 L .84342 .59211 L p F P
0 g
s
.344 .37 .745 r
.29854 .66122 m .3168 .65917 L .3298 .69682 L p F P
0 g
s
.358 .427 .796 r
.3168 .65917 m .29854 .66122 L .28549 .63239 L p F P
0 g
s
.261 .676 .966 r
.43035 .88203 m .46003 .88669 L .4753 .89579 L p F P
0 g
s
.144 .528 .919 r
.35941 .85236 m .38314 .85924 L .39308 .86806 L p F P
0 g
s
.195 .531 .923 r
.38314 .85924 m .35941 .85236 L .35057 .84369 L p F P
0 g
s
.905 .493 .152 r
.77941 .40464 m .78737 .40355 L .7957 .41808 L p F P
0 g
s
.886 .456 .118 r
.78737 .40355 m .77941 .40464 L .77051 .39278 L p F P
0 g
s
0 0 .19 r
.25113 .43315 m .24981 .43908 L .23395 .46111 L p F P
0 g
s
0 0 .232 r
.23262 .46821 m .23395 .46111 L .24981 .43908 L p F P
0 g
s
0 0 .124 r
.27616 .39094 m .27478 .39471 L .25458 .42049 L p F P
0 g
s
0 0 .152 r
.25349 .42415 m .25458 .42049 L .27478 .39471 L p F P
0 g
s
.465 .56 .868 r
.24318 .59761 m .2582 .58516 L .27202 .60754 L p F P
0 g
s
.481 .591 .886 r
.2582 .58516 m .24318 .59761 L .23024 .57875 L p F P
0 g
s
.996 .8 .441 r
.84117 .56123 m .84277 .57798 L .83549 .58121 L p F P
0 g
s
.996 .822 .463 r
.83505 .59603 m .83549 .58121 L .84277 .57798 L p F P
0 g
s
.11 0 .15 r
.30246 .35941 m .30032 .36383 L .27478 .39471 L p F P
0 g
s
.11 0 .15 r
.27478 .39471 m .27616 .39094 L .30246 .35941 L p F P
0 g
s
.215 0 .306 r
.73055 .74085 m .70816 .76711 L .7003 .82041 L p F P
0 g
s
.084 0 .253 r
.67983 .84322 m .7003 .82041 L .70816 .76711 L p F P
0 g
s
.095 .423 .868 r
.31105 .81439 m .33277 .82336 L .34168 .83403 L p F P
0 g
s
.518 .797 .996 r
.53916 .89712 m .52542 .89892 L .48463 .87255 L p F P
0 g
s
.478 .779 .997 r
.47092 .87396 m .48463 .87255 L .52542 .89892 L p F P
0 g
s
.925 .536 .191 r
.78927 .41911 m .7957 .41808 L .80544 .4377 L p F P
0 g
s
.905 .493 .152 r
.7957 .41808 m .78927 .41911 L .77941 .40464 L p F P
0 g
s
.35 .264 .617 r
.35295 .82548 m .33277 .82336 L .32271 .74547 L p F P
0 g
s
.35 .264 .617 r
.32271 .74547 m .34204 .74733 L .35295 .82548 L p F P
0 g
s
0 0 .152 r
.27478 .39471 m .27336 .39894 L .25349 .42415 L p F P
0 g
s
.02 0 .182 r
.25234 .4283 m .25349 .42415 L .27336 .39894 L p F P
0 g
s
.995 .771 .413 r
.83777 .53948 m .84117 .56123 L .83519 .56371 L p F P
0 g
s
.996 .8 .441 r
.83549 .58121 m .83519 .56371 L .84117 .56123 L p F P
0 g
s
.358 .427 .796 r
.28549 .63239 m .30329 .62849 L .3168 .65917 L p F P
0 g
s
.378 .477 .834 r
.30329 .62849 m .28549 .63239 L .27202 .60754 L p F P
0 g
s
0 0 .232 r
.24981 .43908 m .24829 .4471 L .23262 .46821 L p F P
0 g
s
.026 0 .306 r
.2302 .48637 m .23262 .46821 L .24829 .4471 L p F P
0 g
s
0 .517 .795 r
.55977 .34313 m .57209 .34757 L .6046 .35475 L p F P
0 g
s
.344 0 0 r
.57209 .34757 m .55977 .34313 L .52741 .33152 L p F P
0 g
s
0 0 .38 r
.22873 .51435 m .21627 .53291 L .21647 .5251 L p F P
0 g
s
0 0 .38 r
.21647 .5251 m .22892 .50589 L .22873 .51435 L p F P
0 g
s
.128 0 .18 r
.30032 .36383 m .29813 .36887 L .27336 .39894 L p F P
0 g
s
.128 0 .18 r
.27336 .39894 m .27478 .39471 L .30032 .36383 L p F P
0 g
s
.957 .614 .264 r
.80095 .43858 m .80544 .4377 L .82351 .48789 L closepath p F P
0 g
s
.925 .536 .191 r
.80544 .4377 m .80095 .43858 L .78927 .41911 L p F P
0 g
s
.02 0 .182 r
.27336 .39894 m .27188 .40377 L .25234 .4283 L p F P
0 g
s
.046 0 .214 r
.25113 .43315 m .25234 .4283 L .27188 .40377 L p F P
0 g
s
.238 .615 .955 r
.39308 .86806 m .41853 .87285 L .43035 .88203 L p F P
0 g
s
.296 .615 .957 r
.41853 .87285 m .39308 .86806 L .38314 .85924 L p F P
0 g
s
.985 .71 .355 r
.83351 .54108 m .82351 .48789 L .83777 .53948 L closepath p F P
0 g
s
.995 .771 .413 r
.83519 .56371 m .83351 .54108 L .83777 .53948 L p F P
0 g
s
.461 .167 .379 r
.32608 .34067 m .31758 .36017 L .28812 .40275 L p F P
0 g
s
.461 .167 .379 r
.28812 .40275 m .29095 .39053 L .32608 .34067 L p F P
0 g
s
.195 .531 .923 r
.35057 .84369 m .37313 .84922 L .38314 .85924 L p F P
0 g
s
.235 .529 .919 r
.37313 .84922 m .35057 .84369 L .34168 .83403 L p F P
0 g
s
.555 .811 .993 r
.5529 .89462 m .53916 .89712 L .49844 .87047 L p F P
0 g
s
.518 .797 .996 r
.48463 .87255 m .49844 .87047 L .53916 .89712 L p F P
0 g
s
.267 .007 .321 r
.75446 .71738 m .73055 .74085 L .7237 .79507 L p F P
0 g
s
.215 0 .306 r
.7003 .82041 m .7237 .79507 L .73055 .74085 L p F P
0 g
s
.007 0 .408 r
.22872 .52098 m .21625 .53903 L .21627 .53291 L p F P
0 g
s
.007 0 .408 r
.21627 .53291 m .22873 .51435 L .22872 .52098 L p F P
0 g
s
.355 .684 .98 r
.46003 .88669 m .43035 .88203 L .41853 .87285 L p F P
0 g
s
.599 .111 .066 r
.45744 .30866 m .45569 .31449 L .44584 .27956 L p F P
0 g
s
.58 .12 .127 r
.43925 .28794 m .44584 .27956 L .45569 .31449 L p F P
0 g
s
.481 .591 .886 r
.23024 .57875 m .24406 .5644 L .2582 .58516 L p F P
0 g
s
.495 .615 .899 r
.24406 .5644 m .23024 .57875 L .21704 .5609 L p F P
0 g
s
.046 0 .214 r
.27188 .40377 m .27033 .40944 L .25113 .43315 L p F P
0 g
s
.074 0 .249 r
.24981 .43908 m .25113 .43315 L .27033 .40944 L p F P
0 g
s
.025 0 .429 r
.22881 .52666 m .21632 .54426 L .21625 .53903 L p F P
0 g
s
.025 0 .429 r
.21625 .53903 m .22872 .52098 L .22881 .52666 L p F P
0 g
s
.761 .926 .942 r
.67983 .84322 m .66565 .8635 L .65256 .85969 L p F P
0 g
s
.378 .477 .834 r
.27202 .60754 m .28937 .60195 L .30329 .62849 L p F P
0 g
s
.399 .519 .863 r
.28937 .60195 m .27202 .60754 L .2582 .58516 L p F P
0 g
s
.147 0 .211 r
.29813 .36887 m .29586 .37473 L .27188 .40377 L p F P
0 g
s
.147 0 .211 r
.27188 .40377 m .27336 .39894 L .29813 .36887 L p F P
0 g
s
.588 .823 .989 r
.56663 .89142 m .5529 .89462 L .51233 .86773 L p F P
0 g
s
.555 .811 .993 r
.49844 .87047 m .51233 .86773 L .5529 .89462 L p F P
0 g
s
.148 .658 .899 r
.59297 .34998 m .6046 .35475 L .63758 .35862 L p F P
0 g
s
0 .517 .795 r
.6046 .35475 m .59297 .34998 L .55977 .34313 L p F P
0 g
s
.431 .741 .992 r
.49996 .89451 m .46003 .88669 L .4445 .87475 L p F P
0 g
s
.431 .741 .992 r
.4445 .87475 m .47092 .87396 L .49996 .89451 L p F P
0 g
s
.04 0 .446 r
.22895 .53173 m .21644 .54894 L .21632 .54426 L p F P
0 g
s
.04 0 .446 r
.21632 .54426 m .22881 .52666 L .22895 .53173 L p F P
0 g
s
.75 .905 .946 r
.68112 .34763 m .68755 .35242 L .74192 .35709 L closepath p F P
0 g
s
.541 .801 .994 r
.68755 .35242 m .68281 .34889 L p .63568 .33727 L F P
0 g
s
.541 .801 .994 r
.68281 .34889 m .68112 .34763 L .66577 .34413 L p F P
0 g
s
.541 .801 .994 r
.66577 .34413 m .63568 .33727 L p .68281 .34889 L F P
0 g
s
.871 .509 .359 r
.74192 .35709 m .74 .35818 L .6926 .35163 L p F P
0 g
s
.871 .509 .359 r
.6926 .35163 m .68066 .34998 L p .69098 .35117 L F P
0 g
s
.871 .509 .359 r
.69098 .35117 m .74192 .35709 L .6926 .35163 L F
.68066 .34998 m .68112 .34763 L .74192 .35709 L p F P
0 g
s
.272 .002 .308 r
.77955 .69535 m .75446 .71738 L .74877 .76651 L p F P
0 g
s
.267 .007 .321 r
.7237 .79507 m .74721 .76828 L p .75446 .71738 L F P
0 g
s
.267 .007 .321 r
.7488 .76623 m .75446 .71738 L p .74721 .76828 L F P
0 g
s
.272 .002 .308 r
.74877 .76651 m .77148 .73805 L p .77955 .69535 L F P
0 g
s
.272 .002 .308 r
.77148 .73805 m .77498 .73367 L .77508 .73285 L p F P
0 g
s
.272 .002 .308 r
.77508 .73285 m .77955 .69535 L p .77148 .73805 L F P
0 g
s
.935 .909 .77 r
.76886 .72932 m .79623 .69071 L .80181 .6942 L p F P
0 g
s
.935 .909 .77 r
.80181 .6942 m .80249 .69463 L p .79907 .69816 L F P
0 g
s
.935 .909 .77 r
.76886 .72932 m .80181 .6942 L .79907 .69816 L F
.9 .903 .818 r
.74236 .76197 m .76886 .72932 L .77437 .73324 L p F P
0 g
s
.9 .903 .818 r
.77437 .73324 m .77498 .73367 L p .7721 .73617 L F P
0 g
s
.9 .903 .818 r
.74236 .76197 m .77437 .73324 L .7721 .73617 L F
.267 .007 .321 r
.74721 .76828 m .74877 .76651 L .7488 .76623 L p F P
0 g
s
.963 .634 .326 r
.79817 .45887 m .80095 .43858 L .82351 .48789 L closepath p F P
0 g
s
.987 .714 .383 r
.82874 .53824 m .82351 .48789 L .83351 .54108 L closepath p F P
0 g
s
.986 .713 .401 r
.82362 .53228 m .82351 .48789 L .82874 .53824 L closepath p F P
0 g
s
.984 .709 .412 r
.81819 .52349 m .82351 .48789 L .82362 .53228 L closepath p F P
0 g
s
.981 .702 .416 r
.81242 .51154 m .82351 .48789 L .81819 .52349 L closepath p F P
0 g
s
.977 .691 .414 r
.8062 .49507 m .82351 .48789 L .81242 .51154 L closepath p F P
0 g
s
.97 .668 .394 r
.79817 .45887 m .82351 .48789 L .8062 .49507 L closepath p F P
0 g
s
.053 0 .461 r
.22915 .53637 m .21661 .55321 L .21644 .54894 L p F P
0 g
s
.053 0 .461 r
.21644 .54894 m .22895 .53173 L .22915 .53637 L p F P
0 g
s
.074 0 .249 r
.27033 .40944 m .26865 .41644 L .24981 .43908 L p F P
0 g
s
.106 0 .289 r
.24829 .4471 m .24981 .43908 L .26865 .41644 L p F P
0 g
s
.57 0 0 r
.52741 .33152 m .51486 .32558 L .48493 .30689 L p F P
0 g
s
0 .409 .749 r
.51486 .32558 m .52741 .33152 L .55977 .34313 L p F P
0 g
s
.235 .529 .919 r
.34168 .83403 m .36306 .83798 L .37313 .84922 L p F P
0 g
s
.268 .522 .909 r
.36306 .83798 m .34168 .83403 L .33277 .82336 L p F P
0 g
s
.461 0 0 r
.47383 .30185 m .48493 .30689 L .51486 .32558 L p F P
0 g
s
.026 0 .306 r
.24829 .4471 m .24558 .46774 L .2302 .48637 L p F P
0 g
s
.1 0 .393 r
.24426 .49008 m .22892 .50589 L .2302 .48637 L p F P
0 g
s
.1 0 .393 r
.2302 .48637 m .24558 .46774 L .24426 .49008 L p F P
0 g
s
.168 0 .244 r
.27033 .40944 m .27188 .40377 L .29586 .37473 L p F P
0 g
s
.064 .007 .474 r
.22937 .54067 m .21681 .55718 L .21661 .55321 L p F P
0 g
s
.064 .007 .474 r
.21661 .55321 m .22915 .53637 L .22937 .54067 L p F P
0 g
s
.296 .615 .957 r
.38314 .85924 m .40659 .86201 L .41853 .87285 L p F P
0 g
s
.338 .606 .947 r
.40659 .86201 m .38314 .85924 L .37313 .84922 L p F P
0 g
s
.618 .833 .983 r
.58033 .88752 m .56663 .89142 L .52632 .86433 L p F P
0 g
s
.588 .823 .989 r
.51233 .86773 m .52632 .86433 L .56663 .89142 L p F P
0 g
s
.355 .684 .98 r
.41853 .87285 m .4445 .87475 L .46003 .88669 L p F P
0 g
s
.168 0 .244 r
.29586 .37473 m .29348 .38174 L .27033 .40944 L p F P
0 g
s
.255 .731 .937 r
.62722 .3543 m .63758 .35862 L .6713 .36031 L p F P
0 g
s
.148 .658 .899 r
.63758 .35862 m .62722 .3543 L .59297 .34998 L p F P
0 g
s
.074 .02 .485 r
.22962 .54471 m .21704 .5609 L .21681 .55718 L p F P
0 g
s
.074 .02 .485 r
.21681 .55718 m .22937 .54067 L .22962 .54471 L p F P
0 g
s
.966 .929 .7 r
.8312 .64198 m .79623 .69071 L .78977 .68543 L p F P
0 g
s
.197 .219 .657 r
.35894 .74874 m .34204 .74733 L .3298 .69682 L p F P
0 g
s
.197 .219 .657 r
.3298 .69682 m .3468 .69977 L .35894 .74874 L p F P
0 g
s
.198 .271 .714 r
.3468 .69977 m .3298 .69682 L .3168 .65917 L p F P
0 g
s
.936 .588 .338 r
.80095 .43858 m .79817 .45887 L .7851 .44752 L p F P
0 g
s
.936 .588 .338 r
.7851 .44752 m .78927 .41911 L .80095 .43858 L p F P
0 g
s
.541 .801 .994 r
.63568 .33727 m .64491 .34522 L .68755 .35242 L p F P
0 g
s
.868 .509 .368 r
.68022 .35259 m .68066 .34998 L .74 .35818 L p F P
0 g
s
.495 .615 .899 r
.21704 .5609 m .22962 .54471 L .24406 .5644 L p F P
0 g
s
.997 .774 .473 r
.83351 .54108 m .83519 .56371 L .82847 .55987 L p F P
0 g
s
.997 .774 .473 r
.82847 .55987 m .82874 .53824 L .83351 .54108 L p F P
0 g
s
.301 .771 .937 r
.70599 .36012 m .70001 .35898 L .66275 .35721 L p F P
0 g
s
.301 .771 .937 r
.66275 .35721 m .6713 .36031 L .70599 .36012 L p F P
0 g
s
.92 .564 .342 r
.78927 .41911 m .7851 .44752 L .77405 .43913 L p F P
0 g
s
.92 .564 .342 r
.77405 .43913 m .77941 .40464 L .78927 .41911 L p F P
0 g
s
.198 .271 .714 r
.3168 .65917 m .33407 .66189 L .3468 .69977 L p F P
0 g
s
.214 .327 .764 r
.33407 .66189 m .3168 .65917 L .30329 .62849 L p F P
0 g
s
.87 .5 .344 r
.73752 .41687 m .74689 .36567 L .75438 .37368 L p F P
0 g
s
.859 .487 .343 r
.74689 .36567 m .73752 .41687 L .72938 .4128 L p F P
0 g
s
.905 .545 .343 r
.77941 .40464 m .77405 .43913 L .76407 .4323 L p F P
0 g
s
.905 .545 .343 r
.76407 .4323 m .77051 .39278 L .77941 .40464 L p F P
0 g
s
.255 .731 .937 r
.6713 .36031 m .66275 .35721 L .62722 .3543 L p F P
0 g
s
.881 .513 .344 r
.74596 .4214 m .75438 .37368 L .76222 .38262 L p F P
0 g
s
.87 .5 .344 r
.75438 .37368 m .74596 .4214 L .73752 .41687 L p F P
0 g
s
.892 .528 .344 r
.77051 .39278 m .76407 .4323 L .75477 .42649 L p F P
0 g
s
.892 .528 .344 r
.75477 .42649 m .76222 .38262 L .77051 .39278 L p F P
0 g
s
.881 .513 .344 r
.76222 .38262 m .75477 .42649 L .74596 .4214 L p F P
0 g
s
.399 .519 .863 r
.2582 .58516 m .27509 .57804 L .28937 .60195 L p F P
0 g
s
.419 .553 .883 r
.27509 .57804 m .2582 .58516 L .24406 .5644 L p F P
0 g
s
.998 .801 .514 r
.83519 .56371 m .83549 .58121 L .82726 .57669 L p F P
0 g
s
.998 .801 .514 r
.82726 .57669 m .82847 .55987 L .83519 .56371 L p F P
0 g
s
.106 0 .289 r
.26865 .41644 m .26674 .42598 L .24829 .4471 L p F P
0 g
s
.165 0 .359 r
.24558 .46774 m .24829 .4471 L .26674 .42598 L p F P
0 g
s
.192 0 .279 r
.26865 .41644 m .27033 .40944 L .29348 .38174 L p F P
0 g
s
.645 .841 .976 r
.59401 .88291 m .58033 .88752 L .54037 .86027 L p F P
0 g
s
.618 .833 .983 r
.52632 .86433 m .54037 .86027 L .58033 .88752 L p F P
0 g
s
.413 .672 .967 r
.4445 .87475 m .41853 .87285 L .40659 .86201 L p F P
0 g
s
.997 .82 .546 r
.83549 .58121 m .83505 .59603 L .82556 .59099 L p F P
0 g
s
.997 .82 .546 r
.82556 .59099 m .82726 .57669 L .83549 .58121 L p F P
0 g
s
.995 .835 .571 r
.83505 .59603 m .83414 .60912 L .82354 .60366 L p F P
0 g
s
.995 .835 .571 r
.82354 .60366 m .82556 .59099 L .83505 .59603 L p F P
0 g
s
.99 .86 .613 r
.83289 .62096 m .83139 .63184 L .81887 .62575 L p F P
0 g
s
.987 .869 .63 r
.8163 .63562 m .81887 .62575 L .83139 .63184 L p F P
0 g
s
.993 .848 .593 r
.83414 .60912 m .83289 .62096 L .82129 .61516 L p F P
0 g
s
.993 .848 .593 r
.82129 .61516 m .82354 .60366 L .83414 .60912 L p F P
0 g
s
.99 .86 .613 r
.81887 .62575 m .82129 .61516 L .83289 .62096 L p F P
0 g
s
.268 .522 .909 r
.33277 .82336 m .35295 .82548 L .36306 .83798 L p F P
0 g
s
.216 .179 .6 r
.37016 .81909 m .35295 .82548 L .34204 .74733 L p F P
0 g
s
.216 .179 .6 r
.34204 .74733 m .35894 .74874 L .37016 .81909 L p F P
0 g
s
.192 0 .279 r
.29348 .38174 m .29095 .39053 L .26865 .41644 L p F P
0 g
s
.433 .807 .993 r
.70001 .35898 m .69386 .35629 L .65394 .35199 L p F P
0 g
s
.864 .509 .378 r
.73809 .35979 m .73622 .36204 L .67979 .35554 L p F P
0 g
s
.502 .808 1 r
.64491 .34522 m .65394 .35199 L .69386 .35629 L p F P
0 g
s
.864 .509 .378 r
.67979 .35554 m .68022 .35259 L .73809 .35979 L p F P
0 g
s
.58 .12 .127 r
.45569 .31449 m .4539 .32147 L .43925 .28794 L p F P
0 g
s
.562 .139 .197 r
.4324 .30011 m .43925 .28794 L .4539 .32147 L p F P
0 g
s
.214 .327 .764 r
.30329 .62849 m .32091 .63046 L .33407 .66189 L p F P
0 g
s
.239 .38 .805 r
.32091 .63046 m .30329 .62849 L .28937 .60195 L p F P
0 g
s
.67 .848 .968 r
.60767 .87758 m .59401 .88291 L .5545 .85554 L p F P
0 g
s
.645 .841 .976 r
.54037 .86027 m .5545 .85554 L .59401 .88291 L p F P
0 g
s
.144 .024 .446 r
.24413 .4998 m .22873 .51435 L .22892 .50589 L p F P
0 g
s
.144 .024 .446 r
.22892 .50589 m .24426 .49008 L .24413 .4998 L p F P
0 g
s
.145 .626 .921 r
.54712 .33594 m .55977 .34313 L .59297 .34998 L p F P
0 g
s
0 .409 .749 r
.55977 .34313 m .54712 .33594 L .51486 .32558 L p F P
0 g
s
.338 .606 .947 r
.37313 .84922 m .39453 .84948 L .40659 .86201 L p F P
0 g
s
.369 .593 .932 r
.39453 .84948 m .37313 .84922 L .36306 .83798 L p F P
0 g
s
.22 0 .321 r
.26674 .42598 m .26865 .41644 L .29095 .39053 L p F P
0 g
s
.989 .765 .504 r
.82874 .53824 m .82847 .55987 L .82121 .55157 L p F P
0 g
s
.989 .765 .504 r
.82121 .55157 m .82362 .53228 L .82874 .53824 L p F P
0 g
s
.693 .854 .959 r
.62129 .87153 m .60767 .87758 L .56868 .85014 L p F P
0 g
s
.67 .848 .968 r
.5545 .85554 m .56868 .85014 L .60767 .87758 L p F P
0 g
s
.164 .053 .471 r
.2442 .50743 m .22872 .52098 L .22873 .51435 L p F P
0 g
s
.164 .053 .471 r
.22873 .51435 m .24413 .4998 L .2442 .50743 L p F P
0 g
s
.463 .207 .44 r
.31758 .36017 m .30573 .42193 L .28357 .43564 L p F P
0 g
s
.463 .207 .44 r
.28357 .43564 m .28812 .40275 L .31758 .36017 L p F P
0 g
s
.419 .553 .883 r
.24406 .5644 m .26049 .55585 L .27509 .57804 L p F P
0 g
s
.437 .581 .898 r
.26049 .55585 m .24406 .5644 L .22962 .54471 L p F P
0 g
s
.86 .51 .389 r
.73622 .36204 m .7344 .36511 L .67939 .35893 L p F P
0 g
s
.433 .807 .993 r
.65394 .35199 m .66275 .35721 L .70001 .35898 L p F P
0 g
s
.86 .51 .389 r
.67939 .35893 m .67979 .35554 L .73622 .36204 L p F P
0 g
s
.761 .926 .942 r
.65256 .85969 m .66992 .83836 L .67983 .84322 L p F P
0 g
s
.766 .893 .933 r
.66992 .83836 m .65256 .85969 L .63904 .85279 L p F P
0 g
s
.22 0 .321 r
.29095 .39053 m .28812 .40275 L .26674 .42598 L p F P
0 g
s
.239 .38 .805 r
.28937 .60195 m .30739 .60307 L .32091 .63046 L p F P
0 g
s
.267 .428 .837 r
.30739 .60307 m .28937 .60195 L .27509 .57804 L p F P
0 g
s
.18 .075 .49 r
.24437 .51398 m .22881 .52666 L .22872 .52098 L p F P
0 g
s
.18 .075 .49 r
.22872 .52098 m .2442 .50743 L .24437 .51398 L p F P
0 g
s
.461 0 0 r
.51486 .32558 m .50204 .31762 L .47383 .30185 L p F P
0 g
s
0 .225 .622 r
.46253 .29544 m .47383 .30185 L .50204 .31762 L p F P
0 g
s
.305 .722 .975 r
.58102 .34256 m .59297 .34998 L .62722 .3543 L p F P
0 g
s
.145 .626 .921 r
.59297 .34998 m .58102 .34256 L .54712 .33594 L p F P
0 g
s
.413 .672 .967 r
.40659 .86201 m .42872 .85992 L .4445 .87475 L p F P
0 g
s
.448 .649 .945 r
.42872 .85992 m .40659 .86201 L .39453 .84948 L p F P
0 g
s
.165 0 .359 r
.26674 .42598 m .26346 .45088 L .24558 .46774 L p F P
0 g
s
.226 .064 .441 r
.26213 .47824 m .24426 .49008 L .24558 .46774 L p F P
0 g
s
.226 .064 .441 r
.24558 .46774 m .26346 .45088 L .26213 .47824 L p F P
0 g
s
.275 .059 .393 r
.26346 .45088 m .26674 .42598 L .28812 .40275 L p F P
0 g
s
.986 .785 .549 r
.82847 .55987 m .82726 .57669 L .81836 .56666 L p F P
0 g
s
.986 .785 .549 r
.81836 .56666 m .82121 .55157 L .82847 .55987 L p F P
0 g
s
.527 .707 .953 r
.47092 .87396 m .4445 .87475 L .42872 .85992 L p F P
0 g
s
.007 .514 .864 r
.50204 .31762 m .51486 .32558 L .54712 .33594 L p F P
0 g
s
.192 .093 .505 r
.24461 .51983 m .22895 .53173 L .22881 .52666 L p F P
0 g
s
.192 .093 .505 r
.22881 .52666 m .24437 .51398 L .24461 .51983 L p F P
0 g
s
.369 .593 .932 r
.36306 .83798 m .38239 .8352 L .39453 .84948 L p F P
0 g
s
.391 .576 .913 r
.38239 .8352 m .36306 .83798 L .35295 .82548 L p F P
0 g
s
.803 .913 .914 r
.7003 .82041 m .67983 .84322 L .66992 .83836 L p F P
0 g
s
.389 .771 .991 r
.61654 .34754 m .62722 .3543 L .66275 .35721 L p F P
0 g
s
.305 .722 .975 r
.62722 .3543 m .61654 .34754 L .58102 .34256 L p F P
0 g
s
.202 .108 .518 r
.2449 .52518 m .22915 .53637 L .22895 .53173 L p F P
0 g
s
.202 .108 .518 r
.22895 .53173 m .24461 .51983 L .2449 .52518 L p F P
0 g
s
.389 .771 .991 r
.66275 .35721 m .65394 .35199 L .61654 .34754 L p F P
0 g
s
.979 .749 .52 r
.82362 .53228 m .82121 .55157 L .81348 .5392 L p F P
0 g
s
.979 .749 .52 r
.81348 .5392 m .81819 .52349 L .82362 .53228 L p F P
0 g
s
.856 .512 .401 r
.7344 .36511 m .73263 .36932 L .67901 .36294 L p F P
0 g
s
.856 .512 .401 r
.67901 .36294 m .67939 .35893 L .7344 .36511 L p F P
0 g
s
.959 .879 .712 r
.822 .63945 m .78977 .68543 L .78313 .67883 L p F P
0 g
s
.982 .798 .582 r
.82726 .57669 m .82556 .59099 L .81527 .57956 L p F P
0 g
s
.982 .798 .582 r
.81527 .57956 m .81836 .56666 L .82726 .57669 L p F P
0 g
s
.211 .121 .529 r
.24522 .53016 m .22937 .54067 L .22915 .53637 L p F P
0 g
s
.211 .121 .529 r
.22915 .53637 m .2449 .52518 L .24522 .53016 L p F P
0 g
s
.219 .133 .54 r
.24558 .53483 m .22962 .54471 L .22937 .54067 L p F P
0 g
s
.219 .133 .54 r
.22937 .54067 m .24522 .53016 L .24558 .53483 L p F P
0 g
s
.977 .808 .608 r
.82556 .59099 m .82354 .60366 L .81203 .59102 L p F P
0 g
s
.977 .808 .608 r
.81203 .59102 m .81527 .57956 L .82556 .59099 L p F P
0 g
s
.437 .581 .898 r
.22962 .54471 m .24558 .53483 L .26049 .55585 L p F P
0 g
s
.267 .428 .837 r
.27509 .57804 m .29355 .57833 L .30739 .60307 L p F P
0 g
s
.295 .47 .863 r
.29355 .57833 m .27509 .57804 L .26049 .55585 L p F P
0 g
s
.941 .657 .472 r
.7851 .44752 m .79817 .45887 L .8062 .49507 L p F P
0 g
s
.275 .059 .393 r
.28812 .40275 m .28357 .43564 L .26346 .45088 L p F P
0 g
s
.562 .139 .197 r
.4539 .32147 m .45204 .33026 L .4324 .30011 L p F P
0 g
s
.548 .172 .281 r
.42516 .31948 m .4324 .30011 L .45204 .33026 L p F P
0 g
s
.391 .576 .913 r
.35295 .82548 m .37016 .81909 L .38239 .8352 L p F P
0 g
s
.972 .816 .629 r
.82354 .60366 m .82129 .61516 L .80867 .60146 L p F P
0 g
s
.972 .816 .629 r
.80867 .60146 m .81203 .59102 L .82354 .60366 L p F P
0 g
s
.968 .729 .523 r
.81819 .52349 m .81348 .5392 L .80527 .52229 L p F P
0 g
s
.968 .729 .523 r
.80527 .52229 m .81242 .51154 L .81819 .52349 L p F P
0 g
s
.935 .909 .77 r
.80249 .69463 m .77498 .73367 L .76886 .72932 L p F P
0 g
s
0 .005 .555 r
.37005 .74535 m .35894 .74874 L .3468 .69977 L p F P
0 g
s
0 .005 .555 r
.3468 .69977 m .35936 .70477 L .37005 .74535 L p F P
0 g
s
0 .046 .597 r
.35936 .70477 m .3468 .69977 L .33407 .66189 L p F P
0 g
s
.448 .649 .945 r
.39453 .84948 m .41274 .84214 L .42872 .85992 L p F P
0 g
s
.469 .623 .918 r
.41274 .84214 m .39453 .84948 L .38239 .8352 L p F P
0 g
s
.852 .515 .414 r
.73263 .36932 m .73098 .37525 L .67868 .36791 L p F P
0 g
s
.852 .515 .414 r
.67868 .36791 m .67901 .36294 L .73263 .36932 L p F P
0 g
s
.263 .122 .493 r
.26217 .49023 m .24413 .4998 L .24426 .49008 L p F P
0 g
s
.263 .122 .493 r
.24426 .49008 m .26213 .47824 L .26217 .49023 L p F P
0 g
s
0 .046 .597 r
.33407 .66189 m .34834 .67114 L .35936 .70477 L p F P
0 g
s
0 .098 .643 r
.34834 .67114 m .33407 .66189 L .32091 .63046 L p F P
0 g
s
.967 .823 .647 r
.82129 .61516 m .81887 .62575 L .80522 .61111 L p F P
0 g
s
.967 .823 .647 r
.80522 .61111 m .80867 .60146 L .82129 .61516 L p F P
0 g
s
.269 .676 .969 r
.53417 .32672 m .54712 .33594 L .58102 .34256 L p F P
0 g
s
.007 .514 .864 r
.54712 .33594 m .53417 .32672 L .50204 .31762 L p F P
0 g
s
.971 .762 .564 r
.82121 .55157 m .81836 .56666 L .80886 .55158 L p F P
0 g
s
.971 .762 .564 r
.80886 .55158 m .81348 .5392 L .82121 .55157 L p F P
0 g
s
.533 .643 .904 r
.42278 .8182 m .43321 .83247 L p .4111 .81552 L F P
0 g
s
.568 .621 .865 r
.44184 .82508 m .42827 .82705 L .42278 .8182 L p F P
0 g
s
0 .098 .643 r
.32091 .63046 m .33704 .64211 L .34834 .67114 L p F P
0 g
s
.695 .359 0 r
.33704 .64211 m .34814 .67394 L .34834 .67114 L closepath p F P
0 g
s
0 .154 .687 r
.33704 .64211 m .32091 .63046 L .30739 .60307 L p F P
0 g
s
0 .154 .687 r
.30739 .60307 m .32549 .61628 L .33704 .64211 L p F P
0 g
s
.726 .363 0 r
.33704 .64211 m .32549 .61628 L .34699 .671 L p F P
0 g
s
.726 .363 0 r
.34699 .671 m .34814 .67394 L .34758 .67235 L p F P
0 g
s
.726 .363 0 r
.34758 .67235 m .33704 .64211 L p .34699 .671 L F P
0 g
s
0 .211 .729 r
.32549 .61628 m .30739 .60307 L .29355 .57833 L p F P
0 g
s
0 .211 .729 r
.29355 .57833 m .31371 .59274 L .32549 .61628 L p F P
0 g
s
.017 .264 .766 r
.31371 .59274 m .29355 .57833 L .27941 .55541 L p F P
0 g
s
.017 .264 .766 r
.27941 .55541 m .30171 .57087 L .31371 .59274 L p F P
0 g
s
.512 .38 .637 r
.3537 .64889 m .34084 .65289 L p .30573 .42193 L F P
0 g
s
.512 .38 .637 r
.34084 .65289 m .34076 .65292 L .34073 .65269 L p F P
0 g
s
.512 .38 .637 r
.34073 .65269 m .30573 .42193 L p .34084 .65289 L F P
0 g
s
.772 .388 0 r
.31371 .59274 m .34814 .67394 L .32549 .61628 L closepath p F P
0 g
s
.053 .167 .666 r
.28702 .5334 m .33561 .63694 L .34073 .65269 L p F P
0 g
s
.053 .167 .666 r
.34073 .65269 m .34093 .65332 L p .34034 .652 L F P
0 g
s
.816 .42 0 r
.30171 .57087 m .34814 .67394 L .31371 .59274 L closepath p F P
0 g
s
.053 .167 .666 r
.28702 .5334 m .34073 .65269 L .34034 .652 L F
.34093 .65332 m .34184 .6561 L p .34124 .65477 L F P
0 g
s
.053 .167 .666 r
.28702 .5334 m .34093 .65332 L .34124 .65477 L F
.561 .538 .787 r
.34093 .65331 m .38907 .7555 L .38333 .7527 L F
.34076 .65292 m .34091 .65324 L .34093 .65331 L F
.34091 .65324 m .38907 .7555 L .34093 .65331 L F
.38272 .7524 m .37407 .73188 L p .38333 .7527 L F P
0 g
s
.561 .538 .787 r
.37407 .73188 m .34076 .65292 L p .38333 .7527 L F P
0 g
s
.561 .538 .787 r
.39776 .75367 m .38907 .7555 L p .34076 .65292 L F P
0 g
s
.482 .557 .856 r
.38272 .7524 m .39101 .76704 L p .38031 .75122 L F P
0 g
s
.561 .538 .787 r
.38907 .7555 m .38444 .75647 L .38272 .7524 L p F P
0 g
s
.482 .557 .856 r
.39658 .82125 m .38031 .75122 L p .39101 .76704 L F P
0 g
s
.482 .557 .856 r
.38031 .75122 m .37909 .74598 L .38272 .7524 L p F P
0 g
s
.482 .557 .856 r
.39101 .76704 m .41021 .80099 L p .39941 .81704 L F P
0 g
s
.482 .557 .856 r
.39658 .82125 m .39101 .76704 L .39941 .81704 L F
.568 .621 .865 r
.42278 .8182 m .39101 .76704 L p .43925 .82197 L F P
0 g
s
.568 .621 .865 r
.39101 .76704 m .38444 .75647 L p .39043 .76364 L F P
0 g
s
.568 .621 .865 r
.39043 .76364 m .43925 .82197 L .39101 .76704 L F
.43925 .82197 m .44184 .82508 L .42278 .8182 L F
.533 .643 .904 r
.41274 .84214 m .4111 .81552 L p .43321 .83247 L F P
0 g
s
.533 .643 .904 r
.4111 .81552 m .41021 .80099 L .42278 .8182 L p F P
0 g
s
.533 .643 .904 r
.43321 .83247 m .44093 .84304 L p .41532 .84222 L F P
0 g
s
.533 .643 .904 r
.41274 .84214 m .43321 .83247 L .41532 .84222 L F
.552 .702 .94 r
.48463 .87255 m .47092 .87396 L .43321 .83247 L p F P
0 g
s
.552 .702 .94 r
.43321 .83247 m .42827 .82705 L p .43427 .83189 L F P
0 g
s
.552 .702 .94 r
.43427 .83189 m .48463 .87255 L .43321 .83247 L F
.527 .707 .953 r
.42872 .85992 m .44093 .84304 L .47092 .87396 L p F P
0 g
s
.963 .829 .664 r
.8017 .62012 m .80522 .61111 L .81887 .62575 L p F P
0 g
s
.956 .704 .513 r
.81242 .51154 m .80527 .52229 L .79642 .49889 L p F P
0 g
s
.956 .704 .513 r
.79642 .49889 m .8062 .49507 L .81242 .51154 L p F P
0 g
s
.727 .869 .947 r
.61033 .86564 m .6251 .84293 L .63904 .85279 L p F P
0 g
s
.726 .828 .928 r
.6251 .84293 m .61033 .86564 L .58292 .84405 L p F P
0 g
s
0 .225 .622 r
.50204 .31762 m .48894 .30809 L .46253 .29544 L p F P
0 g
s
.554 .155 .241 r
.46086 .2993 m .46253 .29544 L .48894 .30809 L p F P
0 g
s
0 0 .522 r
.38029 .79701 m .37016 .81909 L .35894 .74874 L p F P
0 g
s
0 0 .522 r
.35894 .74874 m .37005 .74535 L .38029 .79701 L p F P
0 g
s
.836 .906 .886 r
.7237 .79507 m .7003 .82041 L .69217 .81553 L p F P
0 g
s
.803 .913 .914 r
.66992 .83836 m .69217 .81553 L .7003 .82041 L p F P
0 g
s
.324 .147 .479 r
.2824 .47289 m .26213 .47824 L .26346 .45088 L p F P
0 g
s
.324 .147 .479 r
.26346 .45088 m .28357 .43564 L .2824 .47289 L p F P
0 g
s
.28 .149 .517 r
.26243 .49968 m .2442 .50743 L .24413 .4998 L p F P
0 g
s
.28 .149 .517 r
.24413 .4998 m .26217 .49023 L .26243 .49968 L p F P
0 g
s
.533 .643 .904 r
.44093 .84304 m .42872 .85992 L .41274 .84214 L p F P
0 g
s
.941 .657 .472 r
.8062 .49507 m .79642 .49889 L .7851 .44752 L p F P
0 g
s
.8 .885 .907 r
.69217 .81553 m .66992 .83836 L .65977 .83174 L p F P
0 g
s
.766 .893 .933 r
.63904 .85279 m .65977 .83174 L .66992 .83836 L p F P
0 g
s
.295 .47 .863 r
.26049 .55585 m .27941 .55541 L .29355 .57833 L p F P
0 g
s
.322 .505 .882 r
.27941 .55541 m .26049 .55585 L .24558 .53483 L p F P
0 g
s
.395 .741 .992 r
.56877 .33321 m .58102 .34256 L .61654 .34754 L p F P
0 g
s
.269 .676 .969 r
.58102 .34256 m .56877 .33321 L .53417 .32672 L p F P
0 g
s
.963 .77 .595 r
.81836 .56666 m .81527 .57956 L .80427 .56223 L p F P
0 g
s
.963 .77 .595 r
.80427 .56223 m .80886 .55158 L .81836 .56666 L p F P
0 g
s
.578 .713 .935 r
.49844 .87047 m .48463 .87255 L .44184 .82508 L p F P
0 g
s
.552 .702 .94 r
.42827 .82705 m .44184 .82508 L .48463 .87255 L p F P
0 g
s
.461 .776 .998 r
.65394 .35199 m .64491 .34522 L .6056 .33901 L p F P
0 g
s
.461 .776 .998 r
.6056 .33901 m .61654 .34754 L .65394 .35199 L p F P
0 g
s
.765 .861 .921 r
.65977 .83174 m .63904 .85279 L .6251 .84293 L p F P
0 g
s
.923 .647 .5 r
.77405 .43913 m .7851 .44752 L .79642 .49889 L p F P
0 g
s
.293 .17 .535 r
.26282 .5078 m .24437 .51398 L .2442 .50743 L p F P
0 g
s
.293 .17 .535 r
.2442 .50743 m .26243 .49968 L .26282 .5078 L p F P
0 g
s
.848 .52 .431 r
.73098 .37525 m .72953 .38445 L .67845 .37473 L p F P
0 g
s
.848 .52 .431 r
.67845 .37473 m .67868 .36791 L .73098 .37525 L p F P
0 g
s
.131 .579 .924 r
.48894 .30809 m .50204 .31762 L .53417 .32672 L p F P
0 g
s
.554 .155 .241 r
.48894 .30809 m .488 .31147 L .46086 .2993 L p F P
0 g
s
.561 .175 .267 r
.45916 .30366 m .46086 .2993 L .488 .31147 L p F P
0 g
s
.395 .741 .992 r
.61654 .34754 m .6056 .33901 L .56877 .33321 L p F P
0 g
s
.9 .903 .818 r
.77498 .73367 m .74877 .76651 L .74236 .76197 L p F P
0 g
s
.926 .883 .773 r
.79623 .69071 m .76886 .72932 L .7626 .72398 L p F P
0 g
s
.926 .883 .773 r
.7626 .72398 m .78977 .68543 L .79623 .69071 L p F P
0 g
s
.956 .735 .564 r
.81348 .5392 m .80886 .55158 L .79875 .53088 L p F P
0 g
s
.956 .735 .564 r
.79875 .53088 m .80527 .52229 L .81348 .5392 L p F P
0 g
s
.469 .623 .918 r
.38239 .8352 m .39658 .82125 L .41274 .84214 L p F P
0 g
s
.478 .593 .89 r
.39658 .82125 m .38239 .8352 L .37016 .81909 L p F P
0 g
s
.303 .186 .55 r
.26329 .51507 m .24461 .51983 L .24437 .51398 L p F P
0 g
s
.303 .186 .55 r
.24437 .51398 m .26282 .5078 L .26329 .51507 L p F P
0 g
s
.941 .835 .711 r
.81214 .63197 m .78313 .67883 L .77632 .67095 L p F P
0 g
s
.941 .835 .711 r
.77632 .67095 m .8017 .62012 L .81214 .63197 L p F P
0 g
s
.868 .903 .855 r
.74877 .76651 m .7237 .79507 L .71665 .79035 L p F P
0 g
s
.836 .906 .886 r
.69217 .81553 m .71665 .79035 L .7237 .79507 L p F P
0 g
s
.956 .775 .618 r
.81527 .57956 m .81203 .59102 L .7997 .57175 L p F P
0 g
s
.956 .775 .618 r
.7997 .57175 m .80427 .56223 L .81527 .57956 L p F P
0 g
s
.602 .722 .929 r
.51233 .86773 m .49844 .87047 L .45562 .82254 L p F P
0 g
s
.578 .713 .935 r
.44184 .82508 m .45562 .82254 L .49844 .87047 L p F P
0 g
s
.311 .2 .563 r
.26381 .52173 m .2449 .52518 L .24461 .51983 L p F P
0 g
s
.311 .2 .563 r
.24461 .51983 m .26329 .51507 L .26381 .52173 L p F P
0 g
s
.868 .903 .855 r
.71665 .79035 m .74236 .76197 L .74877 .76651 L p F P
0 g
s
.561 .175 .267 r
.488 .31147 m .48705 .31522 L .45916 .30366 L p F P
0 g
s
.568 .195 .293 r
.45744 .30866 m .45916 .30366 L .48705 .31522 L p F P
0 g
s
.318 .213 .574 r
.26438 .52792 m .24522 .53016 L .2449 .52518 L p F P
0 g
s
.318 .213 .574 r
.2449 .52518 m .26381 .52173 L .26438 .52792 L p F P
0 g
s
.923 .647 .5 r
.79642 .49889 m .78786 .50216 L .77405 .43913 L p F P
0 g
s
.908 .638 .518 r
.76407 .4323 m .77405 .43913 L .78786 .50216 L p F P
0 g
s
.324 .224 .583 r
.26498 .53375 m .24558 .53483 L .24522 .53016 L p F P
0 g
s
.324 .224 .583 r
.24522 .53016 m .26438 .52792 L .26498 .53375 L p F P
0 g
s
.949 .779 .638 r
.81203 .59102 m .80867 .60146 L .79513 .58045 L p F P
0 g
s
.949 .779 .638 r
.79513 .58045 m .7997 .57175 L .81203 .59102 L p F P
0 g
s
.831 .881 .879 r
.71665 .79035 m .69217 .81553 L .68386 .80941 L p F P
0 g
s
.8 .885 .907 r
.65977 .83174 m .68386 .80941 L .69217 .81553 L p F P
0 g
s
.941 .704 .55 r
.80527 .52229 m .79875 .53088 L .78786 .50216 L p F P
0 g
s
.941 .704 .55 r
.78786 .50216 m .79642 .49889 L .80527 .52229 L p F P
0 g
s
.623 .73 .923 r
.52632 .86433 m .51233 .86773 L .4696 .81943 L p F P
0 g
s
.602 .722 .929 r
.45562 .82254 m .4696 .81943 L .51233 .86773 L p F P
0 g
s
.322 .505 .882 r
.24558 .53483 m .26498 .53375 L .27941 .55541 L p F P
0 g
s
.945 .738 .592 r
.80886 .55158 m .80427 .56223 L .79255 .53835 L p F P
0 g
s
.945 .738 .592 r
.79255 .53835 m .79875 .53088 L .80886 .55158 L p F P
0 g
s
.354 .204 .535 r
.28294 .48946 m .26217 .49023 L .26213 .47824 L p F P
0 g
s
.354 .204 .535 r
.26213 .47824 m .2824 .47289 L .28294 .48946 L p F P
0 g
s
.845 .533 .461 r
.72953 .38445 m .72938 .4128 L .6788 .39273 L p F P
0 g
s
.845 .533 .461 r
.6788 .39273 m .67845 .37473 L .72953 .38445 L p F P
0 g
s
.418 .243 .535 r
.30734 .5014 m .2824 .47289 L .28357 .43564 L p F P
0 g
s
.418 .243 .535 r
.28357 .43564 m .30573 .42193 L .30734 .5014 L p F P
0 g
s
.349 .699 .983 r
.52092 .31594 m .53417 .32672 L .56877 .33321 L p F P
0 g
s
.131 .579 .924 r
.53417 .32672 m .52092 .31594 L .48894 .30809 L p F P
0 g
s
.891 .88 .816 r
.76886 .72932 m .74236 .76197 L .73582 .7565 L p F P
0 g
s
.891 .88 .816 r
.73582 .7565 m .7626 .72398 L .76886 .72932 L p F P
0 g
s
.478 .593 .89 r
.37016 .81909 m .38029 .79701 L .39658 .82125 L p F P
0 g
s
.942 .782 .654 r
.80867 .60146 m .80522 .61111 L .79058 .58853 L p F P
0 g
s
.942 .782 .654 r
.79058 .58853 m .79513 .58045 L .80867 .60146 L p F P
0 g
s
.482 .557 .856 r
.41021 .80099 m .41274 .84214 L .39658 .82125 L p F P
0 g
s
.568 .195 .293 r
.48705 .31522 m .48609 .31943 L .45744 .30866 L p F P
0 g
s
.575 .215 .32 r
.45569 .31449 m .45744 .30866 L .48609 .31943 L p F P
0 g
s
.915 .858 .771 r
.78977 .68543 m .7626 .72398 L .7562 .71765 L p F P
0 g
s
.915 .858 .771 r
.7562 .71765 m .78313 .67883 L .78977 .68543 L p F P
0 g
s
.548 .172 .281 r
.45204 .33026 m .45008 .34252 L .42516 .31948 L p F P
0 g
s
.795 .858 .897 r
.68386 .80941 m .65977 .83174 L .64938 .82342 L p F P
0 g
s
.765 .861 .921 r
.6251 .84293 m .64938 .82342 L .65977 .83174 L p F P
0 g
s
.503 .773 .992 r
.64491 .34522 m .63583 .3374 L p .59441 .32914 L F P
0 g
s
.503 .773 .992 r
.63583 .3374 m .63568 .33727 L .6342 .33698 L p F P
0 g
s
.503 .773 .992 r
.6342 .33698 m .59441 .32914 L p .63583 .3374 L F P
0 g
s
.789 .436 .387 r
.68066 .34998 m .63532 .33967 L p .66345 .34456 L F P
0 g
s
.789 .436 .387 r
.68112 .34763 m .68084 .34907 L p .66345 .34456 L F P
0 g
s
.789 .436 .387 r
.68084 .34907 m .68066 .34998 L p .66345 .34456 L F P
0 g
s
.789 .436 .387 r
.63532 .33967 m .63568 .33727 L .68112 .34763 L p F P
0 g
s
.503 .773 .992 r
.59441 .32914 m .6056 .33901 L .64491 .34522 L p F P
0 g
s
.908 .638 .518 r
.78786 .50216 m .77994 .50514 L .76407 .4323 L p F P
0 g
s
.895 .631 .532 r
.75477 .42649 m .76407 .4323 L .77994 .50514 L p F P
0 g
s
.861 .879 .85 r
.74236 .76197 m .71665 .79035 L .70946 .78463 L p F P
0 g
s
.831 .881 .879 r
.68386 .80941 m .70946 .78463 L .71665 .79035 L p F P
0 g
s
.643 .737 .917 r
.54037 .86027 m .52632 .86433 L .48376 .81575 L p F P
0 g
s
.623 .73 .923 r
.4696 .81943 m .48376 .81575 L .52632 .86433 L p F P
0 g
s
.861 .879 .85 r
.70946 .78463 m .73582 .7565 L .74236 .76197 L p F P
0 g
s
.863 .612 .558 r
.75817 .51318 m .75139 .51565 L p .72938 .4128 L F P
0 g
s
.863 .612 .558 r
.75139 .51565 m .75133 .51567 L .75131 .51557 L p F P
0 g
s
.863 .612 .558 r
.75131 .51557 m .72938 .4128 L p .75139 .51565 L F P
0 g
s
.806 .631 .665 r
.68516 .44472 m .69173 .45129 L p .7514 .51585 L F P
0 g
s
.806 .631 .665 r
.69173 .45129 m .74904 .50854 L .75131 .51557 L p F P
0 g
s
.806 .631 .665 r
.75131 .51557 m .7514 .51585 L p .69173 .45129 L F P
0 g
s
.806 .631 .665 r
.7514 .51585 m .7518 .51709 L p .75148 .51674 L F P
0 g
s
.806 .631 .665 r
.68516 .44472 m .7514 .51585 L .75148 .51674 L F
.89 .693 .63 r
.77495 .55712 m .77028 .56166 L p .7514 .51583 L F P
0 g
s
.89 .693 .63 r
.75133 .51567 m .7514 .51578 L .7514 .51583 L F
.7514 .51578 m .77495 .55712 L .7514 .51583 L F
.873 .722 .691 r
.76858 .56076 m .77178 .56759 L p .76687 .55985 L F P
0 g
s
.89 .693 .63 r
.77028 .56166 m .76929 .56261 L .76858 .56076 L p F P
0 g
s
.89 .693 .63 r
.76858 .56076 m .75133 .51567 L p .77028 .56166 L F P
0 g
s
.873 .722 .691 r
.75488 .63944 m .76687 .55985 L p .77178 .56759 L F P
0 g
s
.873 .722 .691 r
.76687 .55985 m .76719 .55777 L .76858 .56076 L p F P
0 g
s
.873 .722 .691 r
.77178 .56759 m .77922 .58351 L p .77706 .58847 L F P
0 g
s
.873 .722 .691 r
.75488 .63944 m .77178 .56759 L .77706 .58847 L F
.911 .74 .656 r
.79058 .58853 m .78739 .59384 L p .77147 .56637 L F P
0 g
s
.911 .74 .656 r
.76929 .56261 m .77106 .56477 L .77147 .56637 L F
.77106 .56477 m .79058 .58853 L .77147 .56637 L F
.898 .76 .699 r
.78391 .59188 m .78781 .59886 L p .77796 .58853 L F P
0 g
s
.911 .74 .656 r
.78739 .59384 m .78602 .59611 L .78391 .59188 L p F P
0 g
s
.911 .74 .656 r
.78391 .59188 m .76929 .56261 L p .78739 .59384 L F P
0 g
s
.898 .76 .699 r
.76219 .65129 m .77796 .58853 L p .78781 .59886 L F P
0 g
s
.898 .76 .699 r
.77796 .58853 m .77922 .58351 L .78391 .59188 L p F P
0 g
s
.898 .76 .699 r
.78781 .59886 m .79072 .60405 L p .78856 .60763 L F P
0 g
s
.898 .76 .699 r
.76219 .65129 m .78781 .59886 L .78856 .60763 L F
.936 .784 .668 r
.80522 .61111 m .8017 .62012 L .78781 .59886 L p F P
0 g
s
.936 .784 .668 r
.78781 .59886 m .78602 .59611 L p .78769 .59742 L F P
0 g
s
.936 .784 .668 r
.78769 .59742 m .80522 .61111 L .78781 .59886 L F
.78602 .59611 m .79058 .58853 L .80522 .61111 L p F P
0 g
s
.368 .232 .561 r
.28378 .50259 m .26243 .49968 L .26217 .49023 L p F P
0 g
s
.368 .232 .561 r
.26217 .49023 m .28294 .48946 L .28378 .50259 L p F P
0 g
s
.789 .441 .396 r
.68066 .34998 m .68022 .35259 L .63496 .34232 L p F P
0 g
s
.789 .441 .396 r
.63496 .34232 m .63532 .33967 L .68066 .34998 L p F P
0 g
s
.449 .746 .992 r
.55623 .32239 m .56877 .33321 L .6056 .33901 L p F P
0 g
s
.349 .699 .983 r
.56877 .33321 m .55624 .32239 L p .52092 .31594 L F P
0 g
s
.449 .746 .992 r
.6056 .33901 m .59447 .32918 L p .55623 .32239 L F P
0 g
s
.449 .746 .992 r
.59447 .32918 m .59441 .32914 L .59375 .32902 L p F P
0 g
s
.449 .746 .992 r
.59375 .32902 m .55623 .32239 L p .59447 .32918 L F P
0 g
s
.745 .399 .396 r
.63532 .33967 m .59403 .33164 L p .62172 .33539 L F P
0 g
s
.745 .399 .396 r
.63568 .33727 m .63549 .33852 L p .62172 .33539 L F P
0 g
s
.745 .399 .396 r
.63549 .33852 m .63532 .33967 L p .62172 .33539 L F P
0 g
s
.705 .361 .391 r
.59403 .33164 m .55577 .32508 L p .57868 .32749 L F P
0 g
s
.705 .361 .391 r
.59441 .32914 m .59413 .33099 L p .57868 .32749 L F P
0 g
s
.705 .361 .391 r
.59413 .33099 m .59403 .33164 L p .57868 .32749 L F P
0 g
s
.349 .699 .983 r
.55624 .32239 m .55623 .32239 L .55618 .32238 L p F P
0 g
s
.349 .699 .983 r
.55618 .32238 m .52092 .31594 L p .55624 .32239 L F P
0 g
s
.936 .74 .613 r
.80427 .56223 m .7997 .57175 L .78656 .54509 L p F P
0 g
s
.936 .74 .613 r
.78656 .54509 m .79255 .53835 L .80427 .56223 L p F P
0 g
s
.759 .83 .907 r
.64938 .82342 m .6251 .84293 L .61079 .83014 L p F P
0 g
s
.726 .828 .928 r
.58292 .84405 m .61079 .83014 L .6251 .84293 L p F P
0 g
s
.92 .796 .706 r
.8017 .62012 m .77632 .67095 L .76933 .66177 L p F P
0 g
s
.92 .796 .706 r
.76933 .66177 m .79072 .60405 L .8017 .62012 L p F P
0 g
s
.575 .215 .32 r
.48609 .31943 m .48511 .32426 L .45569 .31449 L p F P
0 g
s
.583 .237 .348 r
.4539 .32147 m .45569 .31449 L .48511 .32426 L p F P
0 g
s
.662 .744 .911 r
.5545 .85554 m .54037 .86027 L .4981 .81151 L p F P
0 g
s
.643 .737 .917 r
.48376 .81575 m .4981 .81151 L .54037 .86027 L p F P
0 g
s
.616 .255 .334 r
.488 .31147 m .48894 .30809 L .52092 .31594 L p F P
0 g
s
.928 .702 .575 r
.79875 .53088 m .79255 .53835 L .77994 .50514 L p F P
0 g
s
.928 .702 .575 r
.77994 .50514 m .78786 .50216 L .79875 .53088 L p F P
0 g
s
.79 .446 .405 r
.68022 .35259 m .67979 .35554 L .63462 .34527 L p F P
0 g
s
.79 .446 .405 r
.63462 .34527 m .63496 .34232 L .68022 .35259 L p F P
0 g
s
.895 .631 .532 r
.77994 .50514 m .77242 .50794 L .75477 .42649 L p F P
0 g
s
.883 .624 .542 r
.74596 .4214 m .75477 .42649 L .77242 .50794 L p F P
0 g
s
.377 .251 .58 r
.28477 .51392 m .26282 .5078 L .26243 .49968 L p F P
0 g
s
.377 .251 .58 r
.26243 .49968 m .28378 .50259 L .28477 .51392 L p F P
0 g
s
.824 .857 .872 r
.70946 .78463 m .68386 .80941 L .67539 .80208 L p F P
0 g
s
.795 .858 .897 r
.64938 .82342 m .67539 .80208 L .68386 .80941 L p F P
0 g
s
.06 .314 .797 r
.30171 .57087 m .27941 .55541 L .26498 .53375 L p F P
0 g
s
.882 .858 .812 r
.7626 .72398 m .73582 .7565 L .72915 .75012 L p F P
0 g
s
.882 .858 .812 r
.72915 .75012 m .7562 .71765 L .7626 .72398 L p F P
0 g
s
.79 .452 .415 r
.67979 .35554 m .67939 .35893 L .63429 .34864 L p F P
0 g
s
.79 .452 .415 r
.63429 .34864 m .63462 .34527 L .67979 .35554 L p F P
0 g
s
.616 .255 .334 r
.52092 .31594 m .5203 .31892 L .488 .31147 L p F P
0 g
s
.62 .267 .349 r
.48705 .31522 m .488 .31147 L .5203 .31892 L p F P
0 g
s
.904 .835 .768 r
.78313 .67883 m .7562 .71765 L .74967 .71035 L p F P
0 g
s
.904 .835 .768 r
.74967 .71035 m .77632 .67095 L .78313 .67883 L p F P
0 g
s
.384 .267 .595 r
.28586 .52408 m .26329 .51507 L .26282 .5078 L p F P
0 g
s
.384 .267 .595 r
.26282 .5078 m .28477 .51392 L .28586 .52408 L p F P
0 g
s
.679 .749 .904 r
.56868 .85014 m .5545 .85554 L .51261 .8067 L p F P
0 g
s
.662 .744 .911 r
.4981 .81151 m .51261 .8067 L .5545 .85554 L p F P
0 g
s
.927 .74 .63 r
.7997 .57175 m .79513 .58045 L .7807 .55131 L p F P
0 g
s
.927 .74 .63 r
.7807 .55131 m .78656 .54509 L .7997 .57175 L p F P
0 g
s
.512 .38 .637 r
.30573 .42193 m .31785 .41547 L .3537 .64889 L p F P
0 g
s
.883 .624 .542 r
.77242 .50794 m .76518 .51061 L .74596 .4214 L p F P
0 g
s
.873 .618 .551 r
.73752 .41687 m .74596 .4214 L .76518 .51061 L p F P
0 g
s
.853 .857 .844 r
.73582 .7565 m .70946 .78463 L .70212 .77792 L p F P
0 g
s
.824 .857 .872 r
.67539 .80208 m .70212 .77792 L .70946 .78463 L p F P
0 g
s
.853 .857 .844 r
.70212 .77792 m .72915 .75012 L .73582 .7565 L p F P
0 g
s
.389 .28 .608 r
.28702 .5334 m .26381 .52173 L .26329 .51507 L p F P
0 g
s
.389 .28 .608 r
.26329 .51507 m .28586 .52408 L .28702 .5334 L p F P
0 g
s
.583 .237 .348 r
.48511 .32426 m .48412 .32995 L .4539 .32147 L p F P
0 g
s
.591 .261 .378 r
.45204 .33026 m .4539 .32147 L .48412 .32995 L p F P
0 g
s
.79 .458 .426 r
.67939 .35893 m .67901 .36294 L .63398 .35257 L p F P
0 g
s
.79 .458 .426 r
.63398 .35257 m .63429 .34864 L .67939 .35893 L p F P
0 g
s
.764 .476 0 r
.35936 .70477 m .34814 .67394 L .37005 .74535 L closepath p F P
0 g
s
.704 .395 0 r
.34834 .67114 m .34814 .67394 L .35936 .70477 L closepath p F P
0 g
s
.336 .41 .791 r
.37909 .74598 m .39658 .82125 L .38029 .79701 L p F P
0 g
s
.62 .267 .349 r
.5203 .31892 m .51967 .3222 L .48705 .31522 L p F P
0 g
s
.624 .279 .365 r
.48609 .31943 m .48705 .31522 L .51967 .3222 L p F P
0 g
s
.696 .755 .897 r
.58292 .84405 m .56868 .85014 L .52728 .80132 L p F P
0 g
s
.679 .749 .904 r
.51261 .8067 m .52728 .80132 L .56868 .85014 L p F P
0 g
s
.789 .833 .886 r
.67539 .80208 m .64938 .82342 L .63876 .81338 L p F P
0 g
s
.759 .83 .907 r
.61079 .83014 m .63876 .81338 L .64938 .82342 L p F P
0 g
s
.917 .7 .593 r
.79255 .53835 m .78656 .54509 L .77242 .50794 L p F P
0 g
s
.917 .7 .593 r
.77242 .50794 m .77994 .50514 L .79255 .53835 L p F P
0 g
s
.393 .292 .62 r
.28824 .54208 m .26438 .52792 L .26381 .52173 L p F P
0 g
s
.393 .292 .62 r
.26381 .52173 m .28702 .5334 L .28824 .54208 L p F P
0 g
s
.745 .399 .396 r
.59403 .33164 m .59441 .32914 L .63568 .33727 L p F P
0 g
s
.919 .74 .644 r
.79513 .58045 m .79058 .58853 L .77495 .55712 L p F P
0 g
s
.919 .74 .644 r
.77495 .55712 m .7807 .55131 L .79513 .58045 L p F P
0 g
s
.873 .618 .551 r
.76518 .51061 m .75817 .51318 L .73752 .41687 L p F P
0 g
s
.863 .612 .558 r
.72938 .4128 m .73752 .41687 L .75817 .51318 L p F P
0 g
s
.854 .578 .043 r
.37005 .74535 m .34814 .67394 L .38029 .79701 L closepath p F P
0 g
s
.791 .465 .438 r
.67901 .36294 m .67868 .36791 L .6337 .35739 L p F P
0 g
s
.791 .465 .438 r
.6337 .35739 m .63398 .35257 L .67901 .36294 L p F P
0 g
s
.396 .302 .63 r
.2895 .55025 m .26498 .53375 L .26438 .52792 L p F P
0 g
s
.396 .302 .63 r
.26438 .52792 m .28824 .54208 L .2895 .55025 L p F P
0 g
s
.366 .267 .608 r
.31223 .53834 m .28294 .48946 L .2824 .47289 L p F P
0 g
s
.366 .267 .608 r
.2824 .47289 m .30734 .5014 L .31223 .53834 L p F P
0 g
s
.531 .393 .638 r
.36707 .64471 m .3537 .64889 L .31785 .41547 L p F P
0 g
s
.531 .393 .638 r
.31785 .41547 m .33047 .40941 L .36707 .64471 L p F P
0 g
s
.663 .315 .374 r
.5203 .31892 m .52092 .31594 L .55623 .32239 L p F P
0 g
s
.696 .755 .897 r
.52728 .80132 m .53524 .79811 L p .56806 .82631 L F P
0 g
s
.696 .755 .897 r
.53524 .79811 m .5421 .79535 L .54682 .80098 L p F P
0 g
s
.696 .755 .897 r
.54682 .80098 m .56806 .82631 L p .53524 .79811 L F P
0 g
s
.628 .725 .917 r
.59612 .81439 m .55428 .8119 L .54682 .80098 L p F P
0 g
s
.628 .725 .917 r
.58111 .79561 m .59612 .81439 L p .53791 .77699 L F P
0 g
s
.682 .672 .833 r
.48404 .72825 m .49706 .72344 L p .53069 .77591 L F P
0 g
s
.682 .672 .833 r
.49706 .72344 m .49938 .72258 L .50578 .73349 L p F P
0 g
s
.682 .672 .833 r
.50578 .73349 m .53069 .77591 L p .49706 .72344 L F P
0 g
s
.488 .627 .913 r
.5658 .77363 m .58111 .79561 L p .49801 .71555 L F P
0 g
s
.663 .592 .766 r
.44001 .62145 m .45388 .61695 L p .49612 .71464 L F P
0 g
s
.372 .288 .631 r
.45656 .48422 m .45806 .4926 L p .45685 .61794 L F P
0 g
s
.663 .592 .766 r
.45665 .61856 m .46064 .62827 L p .45602 .62053 L F P
0 g
s
.372 .288 .631 r
.45684 .61961 m .45683 .618 L p .45685 .61794 L F P
0 g
s
.372 .288 .631 r
.45683 .618 m .45656 .48422 L p .45685 .61794 L F P
0 g
s
.619 .454 .636 r
.44001 .62145 m .40069 .38506 L p .4557 .61615 L F P
0 g
s
.619 .454 .636 r
.45574 .61635 m .45563 .61638 L p .4557 .61615 L F P
0 g
s
.619 .454 .636 r
.45563 .61638 m .44001 .62145 L p .4557 .61615 L F P
0 g
s
.619 .454 .636 r
.40069 .38506 m .41612 .38145 L .4557 .61612 L p F P
0 g
s
.619 .454 .636 r
.4557 .61612 m .45574 .61635 L p .4557 .61615 L F P
0 g
s
.619 .454 .636 r
.40069 .38506 m .4557 .61612 L .4557 .61615 L F
.424 .316 .628 r
.45591 .61676 m .4557 .61612 L p .45683 .618 L F P
0 g
s
.424 .316 .628 r
.4557 .61612 m .45048 .6 L p .45591 .61537 L F P
0 g
s
.424 .316 .628 r
.45591 .61537 m .45683 .618 L .4557 .61612 L F
.45656 .48422 m .45682 .612 L p .45048 .6 L F P
0 g
s
.424 .316 .628 r
.45682 .612 m .45683 .618 L p .45591 .61537 L F P
0 g
s
.424 .316 .628 r
.45048 .6 m .45682 .612 L .45591 .61537 L F
.663 .592 .766 r
.45388 .61695 m .45563 .61638 L p .45665 .61856 L F P
0 g
s
.663 .592 .766 r
.45388 .61695 m .45665 .61856 L .45602 .62053 L F
.424 .316 .628 r
.45683 .618 m .45684 .61961 L .45591 .61676 L p F P
0 g
s
.663 .592 .766 r
.45563 .61638 m .45574 .61635 L .45591 .61676 L p F P
0 g
s
.663 .592 .766 r
.45591 .61676 m .45665 .61856 L p .45563 .61638 L F P
0 g
s
.145 .391 .841 r
.55021 .74823 m .5658 .77363 L p .47418 .65237 L F P
0 g
s
.663 .592 .766 r
.46064 .62827 m .4618 .63109 L p .45388 .61695 L F P
0 g
s
.663 .592 .766 r
.4618 .63109 m .46726 .64439 L p .45759 .62457 L F P
0 g
s
.663 .592 .766 r
.45388 .61695 m .4618 .63109 L .45759 .62457 L F
.874 .635 .574 r
.53871 .69511 m .55021 .74823 L .47937 .65835 L p F P
0 g
s
.663 .592 .766 r
.45388 .61695 m .46726 .64439 L .46424 .6409 L F
.874 .635 .574 r
.47937 .65835 m .46322 .63787 L .46898 .64223 L p F P
0 g
s
.874 .635 .574 r
.46898 .64223 m .53871 .69511 L p .47937 .65835 L F P
0 g
s
.145 .391 .841 r
.46322 .63787 m .47937 .65835 L p .47418 .65237 L F P
0 g
s
.145 .391 .841 r
.47937 .65835 m .55021 .74823 L p .47418 .65237 L F P
0 g
s
.663 .592 .766 r
.46726 .64439 m .49612 .71464 L p .46424 .6409 L F P
0 g
s
.867 .645 .601 r
.52734 .65328 m .53871 .69511 L .46898 .64223 L p F P
0 g
s
.867 .645 .601 r
.46898 .64223 m .46322 .63787 L .4669 .63875 L p F P
0 g
s
.867 .645 .601 r
.4669 .63875 m .52734 .65328 L p .46898 .64223 L F P
0 g
s
.663 .592 .766 r
.44001 .62145 m .49612 .71464 L .49515 .71416 L F
.488 .627 .913 r
.49411 .7118 m .49905 .71606 L p .49801 .71555 L F P
0 g
s
.488 .627 .913 r
.49905 .71606 m .5658 .77363 L p .49801 .71555 L F P
0 g
s
.663 .592 .766 r
.49612 .71464 m .49767 .7184 L p .49515 .71416 L F P
0 g
s
.663 .592 .766 r
.49767 .7184 m .49938 .72258 L p .49754 .71945 L F P
0 g
s
.663 .592 .766 r
.44001 .62145 m .49767 .7184 L .49754 .71945 L F
.488 .627 .913 r
.58111 .79561 m .54441 .77797 L p .49787 .71674 L F P
0 g
s
.488 .627 .913 r
.49411 .7118 m .49801 .71555 L .49787 .71674 L F
.49801 .71555 m .58111 .79561 L .49787 .71674 L F
.54441 .77797 m .52459 .76844 L .50578 .73349 L p F P
0 g
s
.488 .627 .913 r
.50578 .73349 m .49411 .7118 L p .54441 .77797 L F P
0 g
s
.628 .725 .917 r
.52459 .76844 m .54441 .77797 L p .53791 .77699 L F P
0 g
s
.628 .725 .917 r
.54441 .77797 m .58111 .79561 L p .53791 .77699 L F P
0 g
s
.682 .672 .833 r
.53069 .77591 m .53674 .78623 L p .52685 .77534 L F P
0 g
s
.682 .672 .833 r
.48404 .72825 m .53069 .77591 L .52685 .77534 L F
.53674 .78623 m .5421 .79535 L p .53642 .78879 L F P
0 g
s
.682 .672 .833 r
.48404 .72825 m .53674 .78623 L .53642 .78879 L F
.628 .725 .917 r
.54682 .80098 m .53674 .78623 L p .59312 .81246 L F P
0 g
s
.628 .725 .917 r
.53674 .78623 m .52459 .76844 L p .53791 .77699 L F P
0 g
s
.628 .725 .917 r
.53791 .77699 m .59312 .81246 L .53674 .78623 L F
.59312 .81246 m .59612 .81439 L .54682 .80098 L F
.695 .783 .919 r
.55428 .8119 m .59612 .81439 L .59789 .81628 L p F P
0 g
s
.695 .783 .919 r
.59789 .81628 m .61079 .83014 L p .58318 .82123 L F P
0 g
s
.695 .783 .919 r
.55428 .8119 m .59789 .81628 L .58318 .82123 L F
.696 .755 .897 r
.56806 .82631 m .58292 .84405 L p .56233 .82824 L F P
0 g
s
.696 .755 .897 r
.52728 .80132 m .56806 .82631 L .56233 .82824 L F
.695 .783 .919 r
.61079 .83014 m .58292 .84405 L .55428 .8119 L p F P
0 g
s
.746 .405 .405 r
.63532 .33967 m .63496 .34232 L .59366 .3344 L p F P
0 g
s
.746 .405 .405 r
.59366 .3344 m .59403 .33164 L .63532 .33967 L p F P
0 g
s
.624 .279 .365 r
.51967 .3222 m .51903 .32586 L .48609 .31943 L p F P
0 g
s
.629 .292 .382 r
.48511 .32426 m .48609 .31943 L .51903 .32586 L p F P
0 g
s
.873 .836 .806 r
.7562 .71765 m .72915 .75012 L .72236 .74282 L p F P
0 g
s
.873 .836 .806 r
.72236 .74282 m .74967 .71035 L .7562 .71765 L p F P
0 g
s
.06 .314 .797 r
.29354 .55708 m .30171 .57087 L p .29043 .55947 L F P
0 g
s
.06 .314 .797 r
.26498 .53375 m .2895 .55025 L .29354 .55708 L p F P
0 g
s
.06 .314 .797 r
.26498 .53375 m .29354 .55708 L .29043 .55947 L F
.85 .45 0 r
.2895 .55025 m .34814 .67394 L .30171 .57087 L closepath p F P
0 g
s
0 .12 .649 r
.34184 .6561 m .34814 .67394 L p .29466 .55622 L F P
0 g
s
0 .12 .649 r
.28824 .54208 m .29482 .55609 L p .29466 .55622 L F P
0 g
s
0 .12 .649 r
.29482 .55609 m .34184 .6561 L p .29466 .55622 L F P
0 g
s
.898 .76 .699 r
.79072 .60405 m .76933 .66177 L .76219 .65129 L p F P
0 g
s
.893 .812 .762 r
.77632 .67095 m .74967 .71035 L .74301 .70208 L p F P
0 g
s
.893 .812 .762 r
.74301 .70208 m .76933 .66177 L .77632 .67095 L p F P
0 g
s
.837 .561 .52 r
.6788 .39273 m .72938 .4128 L .73401 .44841 L p F P
0 g
s
.817 .835 .863 r
.70212 .77792 m .67539 .80208 L .66675 .79354 L p F P
0 g
s
.789 .833 .886 r
.63876 .81338 m .66675 .79354 L .67539 .80208 L p F P
0 g
s
.911 .74 .656 r
.76929 .56261 m .77495 .55712 L .79058 .58853 L p F P
0 g
s
.663 .315 .374 r
.55623 .32239 m .55577 .32508 L .5203 .31892 L p F P
0 g
s
.666 .324 .385 r
.51967 .3222 m .5203 .31892 L .55577 .32508 L p F P
0 g
s
.747 .411 .414 r
.63496 .34232 m .63462 .34527 L .59329 .33746 L p F P
0 g
s
.747 .411 .414 r
.59329 .33746 m .59366 .3344 L .63496 .34232 L p F P
0 g
s
.791 .474 .452 r
.67868 .36791 m .67845 .37473 L .63349 .36393 L p F P
0 g
s
.791 .474 .452 r
.63349 .36393 m .6337 .35739 L .67868 .36791 L p F P
0 g
s
.591 .261 .378 r
.48412 .32995 m .4831 .33698 L .45204 .33026 L p F P
0 g
s
.6 .288 .412 r
.45008 .34252 m .45204 .33026 L .4831 .33698 L p F P
0 g
s
.907 .698 .608 r
.78656 .54509 m .7807 .55131 L .76518 .51061 L p F P
0 g
s
.907 .698 .608 r
.76518 .51061 m .77242 .50794 L .78656 .54509 L p F P
0 g
s
.705 .361 .391 r
.55577 .32508 m .55623 .32239 L .59441 .32914 L p F P
0 g
s
.845 .836 .837 r
.72915 .75012 m .70212 .77792 L .69466 .77022 L p F P
0 g
s
.845 .836 .837 r
.69466 .77022 m .72236 .74282 L .72915 .75012 L p F P
0 g
s
.817 .835 .863 r
.66675 .79354 m .69466 .77022 L .70212 .77792 L p F P
0 g
s
.629 .292 .382 r
.51903 .32586 m .5184 .33003 L .48511 .32426 L p F P
0 g
s
.633 .306 .4 r
.48412 .32995 m .48511 .32426 L .5184 .33003 L p F P
0 g
s
.547 .404 .638 r
.38086 .64036 m .36707 .64471 L .33047 .40941 L p F P
0 g
s
.547 .404 .638 r
.33047 .40941 m .34358 .40373 L .38086 .64036 L p F P
0 g
s
.748 .417 .423 r
.63462 .34527 m .63429 .34864 L .59293 .34094 L p F P
0 g
s
.748 .417 .423 r
.59293 .34094 m .59329 .33746 L .63462 .34527 L p F P
0 g
s
.751 .801 .893 r
.63876 .81338 m .61079 .83014 L .59612 .81439 L p F P
0 g
s
.666 .324 .385 r
.55577 .32508 m .55531 .32804 L .51967 .3222 L p F P
0 g
s
.668 .333 .397 r
.51903 .32586 m .51967 .3222 L .55531 .32804 L p F P
0 g
s
.325 .268 .639 r
.3177 .56787 m .28378 .50259 L .28294 .48946 L p F P
0 g
s
.325 .268 .639 r
.28294 .48946 m .31223 .53834 L .3177 .56787 L p F P
0 g
s
.706 .367 .401 r
.59403 .33164 m .59366 .3344 L .55531 .32804 L p F P
0 g
s
.706 .367 .401 r
.55531 .32804 m .55577 .32508 L .59403 .33164 L p F P
0 g
s
.336 .41 .791 r
.38029 .79701 m .34814 .67394 L .37909 .74598 L p F P
0 g
s
.749 .424 .434 r
.63429 .34864 m .63398 .35257 L .59258 .345 L p F P
0 g
s
.749 .424 .434 r
.59258 .345 m .59293 .34094 L .63429 .34864 L p F P
0 g
s
.793 .49 .478 r
.67845 .37473 m .6788 .39273 L .63365 .38084 L p F P
0 g
s
.793 .49 .478 r
.63365 .38084 m .63349 .36393 L .67845 .37473 L p F P
0 g
s
.708 .374 .411 r
.59366 .3344 m .59329 .33746 L .55485 .33134 L p F P
0 g
s
.708 .374 .411 r
.55485 .33134 m .55531 .32804 L .59366 .3344 L p F P
0 g
s
.668 .333 .397 r
.55531 .32804 m .55485 .33134 L .51903 .32586 L p F P
0 g
s
.671 .342 .409 r
.5184 .33003 m .51903 .32586 L .55485 .33134 L p F P
0 g
s
.865 .816 .8 r
.74967 .71035 m .72236 .74282 L .71544 .7346 L p F P
0 g
s
.865 .816 .8 r
.71544 .7346 m .74301 .70208 L .74967 .71035 L p F P
0 g
s
.633 .306 .4 r
.5184 .33003 m .51775 .3349 L .48412 .32995 L p F P
0 g
s
.638 .321 .419 r
.4831 .33698 m .48412 .32995 L .51775 .3349 L p F P
0 g
s
.898 .695 .62 r
.7807 .55131 m .77495 .55712 L .75817 .51318 L p F P
0 g
s
.898 .695 .62 r
.75817 .51318 m .76518 .51061 L .7807 .55131 L p F P
0 g
s
.588 .631 .861 r
.45562 .82254 m .44184 .82508 L .39776 .75367 L p F P
0 g
s
.568 .621 .865 r
.38444 .75647 m .39776 .75367 L .44184 .82508 L p F P
0 g
s
.782 .809 .874 r
.66675 .79354 m .63876 .81338 L .62793 .80164 L p F P
0 g
s
.751 .801 .893 r
.59612 .81439 m .62793 .80164 L .63876 .81338 L p F P
0 g
s
.563 .415 .638 r
.39506 .63586 m .38086 .64036 L .34358 .40373 L p F P
0 g
s
.563 .415 .638 r
.34358 .40373 m .35716 .39846 L .39506 .63586 L p F P
0 g
s
.273 .257 .658 r
.32349 .59337 m .28477 .51392 L .28378 .50259 L p F P
0 g
s
.273 .257 .658 r
.28378 .50259 m .3177 .56787 L .32349 .59337 L p F P
0 g
s
.882 .791 .755 r
.76933 .66177 m .74301 .70208 L .73623 .69281 L p F P
0 g
s
.882 .791 .755 r
.73623 .69281 m .76219 .65129 L .76933 .66177 L p F P
0 g
s
.709 .382 .421 r
.59329 .33746 m .59293 .34094 L .55439 .33508 L p F P
0 g
s
.709 .382 .421 r
.55439 .33508 m .55485 .33134 L .59329 .33746 L p F P
0 g
s
.75 .432 .446 r
.63398 .35257 m .6337 .35739 L .59225 .34996 L p F P
0 g
s
.75 .432 .446 r
.59225 .34996 m .59258 .345 L .63398 .35257 L p F P
0 g
s
.671 .342 .409 r
.55485 .33134 m .55439 .33508 L .5184 .33003 L p F P
0 g
s
.674 .353 .422 r
.51775 .3349 m .5184 .33003 L .55439 .33508 L p F P
0 g
s
.81 .813 .853 r
.69466 .77022 m .66675 .79354 L .65795 .78377 L p F P
0 g
s
.782 .809 .874 r
.62793 .80164 m .65795 .78377 L .66675 .79354 L p F P
0 g
s
.873 .722 .691 r
.77922 .58351 m .76219 .65129 L .75488 .63944 L p F P
0 g
s
.837 .816 .829 r
.72236 .74282 m .69466 .77022 L .68706 .76152 L p F P
0 g
s
.837 .816 .829 r
.68706 .76152 m .71544 .7346 L .72236 .74282 L p F P
0 g
s
.6 .288 .412 r
.4831 .33698 m .48203 .34659 L .45008 .34252 L p F P
0 g
s
.613 .332 .468 r
.44753 .3757 m .45008 .34252 L .48203 .34659 L p F P
0 g
s
.524 .233 .414 r
.45008 .34252 m .44753 .3757 L .41612 .38145 L p F P
0 g
s
.81 .813 .853 r
.65795 .78377 m .68706 .76152 L .69466 .77022 L p F P
0 g
s
.21 .236 .669 r
.32948 .61616 m .28586 .52408 L .28477 .51392 L p F P
0 g
s
.21 .236 .669 r
.28477 .51392 m .32349 .59337 L .32948 .61616 L p F P
0 g
s
.711 .39 .433 r
.59293 .34094 m .59258 .345 L .55393 .33944 L p F P
0 g
s
.711 .39 .433 r
.55393 .33944 m .55439 .33508 L .59293 .34094 L p F P
0 g
s
.578 .426 .638 r
.40966 .6312 m .39506 .63586 L .35716 .39846 L p F P
0 g
s
.578 .426 .638 r
.35716 .39846 m .3712 .39358 L .40966 .6312 L p F P
0 g
s
.89 .693 .63 r
.75133 .51567 m .75817 .51318 L .77495 .55712 L p F P
0 g
s
.751 .442 .459 r
.6337 .35739 m .63349 .36393 L .59195 .35666 L p F P
0 g
s
.751 .442 .459 r
.59195 .35666 m .59225 .34996 L .6337 .35739 L p F P
0 g
s
.638 .321 .419 r
.51775 .3349 m .51711 .34088 L .4831 .33698 L p F P
0 g
s
.643 .339 .441 r
.48203 .34659 m .4831 .33698 L .51711 .34088 L p F P
0 g
s
.606 .639 .857 r
.4696 .81943 m .45562 .82254 L .4114 .75044 L p F P
0 g
s
.588 .631 .861 r
.39776 .75367 m .4114 .75044 L .45562 .82254 L p F P
0 g
s
.674 .353 .422 r
.55439 .33508 m .55393 .33944 L .51775 .3349 L p F P
0 g
s
.677 .364 .437 r
.51711 .34088 m .51775 .3349 L .55393 .33944 L p F P
0 g
s
.137 .206 .672 r
.33561 .63694 m .28702 .5334 L .28586 .52408 L p F P
0 g
s
.137 .206 .672 r
.28586 .52408 m .32948 .61616 L .33561 .63694 L p F P
0 g
s
.831 .587 .571 r
.68045 .41271 m .73401 .44841 L .73731 .4648 L p F P
0 g
s
.837 .561 .52 r
.73401 .44841 m .68045 .41271 L .6788 .39273 L p F P
0 g
s
.856 .797 .792 r
.74301 .70208 m .71544 .7346 L .70841 .72545 L p F P
0 g
s
.856 .797 .792 r
.70841 .72545 m .73623 .69281 L .74301 .70208 L p F P
0 g
s
.713 .399 .445 r
.59258 .345 m .59225 .34996 L .55349 .34477 L p F P
0 g
s
.713 .399 .445 r
.55349 .34477 m .55393 .33944 L .59258 .345 L p F P
0 g
s
.872 .77 .747 r
.76219 .65129 m .73623 .69281 L .72932 .68253 L p F P
0 g
s
.872 .77 .747 r
.72932 .68253 m .75488 .63944 L .76219 .65129 L p F P
0 g
s
.677 .364 .437 r
.55393 .33944 m .55349 .34477 L .51711 .34088 L p F P
0 g
s
.592 .435 .638 r
.42464 .6264 m .40966 .6312 L .3712 .39358 L p F P
0 g
s
.592 .435 .638 r
.3712 .39358 m .38572 .38911 L .42464 .6264 L p F P
0 g
s
.053 .167 .666 r
.34184 .6561 m .28824 .54208 L .28702 .5334 L p F P
0 g
s
.687 .538 .678 r
.71018 .61072 m .67998 .62953 L .66745 .58222 L p F P
0 g
s
.687 .538 .678 r
.66745 .58222 m .69935 .57038 L .71018 .61072 L p F P
0 g
s
.706 .585 .717 r
.69935 .57038 m .66745 .58222 L .65549 .54714 L p F P
0 g
s
.703 .547 .673 r
.63515 .59601 m .66745 .58222 L .67998 .62953 L p F P
0 g
s
.722 .596 .715 r
.66745 .58222 m .63515 .59601 L .62214 .55796 L p F P
0 g
s
.722 .596 .715 r
.62214 .55796 m .65549 .54714 L .66745 .58222 L p F P
0 g
s
.754 .459 .484 r
.63349 .36393 m .63365 .38084 L .5919 .37389 L p F P
0 g
s
.754 .459 .484 r
.5919 .37389 m .59195 .35666 L .63349 .36393 L p F P
0 g
s
.793 .514 .514 r
.63365 .38084 m .6788 .39273 L .68045 .41271 L p F P
0 g
s
.676 .535 .685 r
.73872 .58764 m .71018 .61072 L .69935 .57038 L p F P
0 g
s
.676 .535 .685 r
.69935 .57038 m .73072 .55878 L .73872 .58764 L p F P
0 g
s
.693 .573 .716 r
.73072 .55878 m .69935 .57038 L .68908 .53973 L p F P
0 g
s
.706 .585 .717 r
.65549 .54714 m .68908 .53973 L .69935 .57038 L p F P
0 g
s
.623 .647 .853 r
.48376 .81575 m .4696 .81943 L .42536 .74681 L p F P
0 g
s
.606 .639 .857 r
.4114 .75044 m .42536 .74681 L .4696 .81943 L p F P
0 g
s
.703 .547 .673 r
.67998 .62953 m .64866 .64746 L .63515 .59601 L p F P
0 g
s
.725 .56 .666 r
.60203 .61243 m .63515 .59601 L .64866 .64746 L p F P
0 g
s
.743 .607 .707 r
.63515 .59601 m .60203 .61243 L .58855 .57266 L p F P
0 g
s
.743 .607 .707 r
.58855 .57266 m .62214 .55796 L .63515 .59601 L p F P
0 g
s
.717 .622 .75 r
.68908 .53973 m .65549 .54714 L .64377 .51848 L p F P
0 g
s
.732 .634 .749 r
.65549 .54714 m .62214 .55796 L .60929 .52691 L p F P
0 g
s
.732 .634 .749 r
.60929 .52691 m .64377 .51848 L .65549 .54714 L p F P
0 g
s
.83 .797 .82 r
.71544 .7346 m .68706 .76152 L .67934 .7518 L p F P
0 g
s
.83 .797 .82 r
.67934 .7518 m .70841 .72545 L .71544 .7346 L p F P
0 g
s
.68 .377 .455 r
.51645 .34899 m .51711 .34088 L .55349 .34477 L p F P
0 g
s
.643 .339 .441 r
.51711 .34088 m .51645 .34899 L .48203 .34659 L p F P
0 g
s
.715 .41 .46 r
.59225 .34996 m .59195 .35666 L .55306 .35198 L p F P
0 g
s
.715 .41 .46 r
.55306 .35198 m .55349 .34477 L .59225 .34996 L p F P
0 g
s
.84 .677 .681 r
.76719 .55777 m .75488 .63944 L .74741 .62616 L p F P
0 g
s
.84 .677 .681 r
.74741 .62616 m .75452 .52508 L .76719 .55777 L p F P
0 g
s
.693 .573 .716 r
.68908 .53973 m .7231 .53548 L .73072 .55878 L p F P
0 g
s
.705 .606 .743 r
.7231 .53548 m .68908 .53973 L .67907 .51446 L p F P
0 g
s
.717 .622 .75 r
.64377 .51848 m .67907 .51446 L .68908 .53973 L p F P
0 g
s
.827 .6 .596 r
.68151 .42152 m .73731 .4648 L .74039 .47788 L p F P
0 g
s
.831 .587 .571 r
.73731 .4648 m .68151 .42152 L .68045 .41271 L p F P
0 g
s
.741 .773 .879 r
.62793 .80164 m .59612 .81439 L .58111 .79561 L p F P
0 g
s
0 .12 .649 r
.34814 .67394 m .2895 .55025 L .28824 .54208 L p F P
0 g
s
.775 .786 .862 r
.65795 .78377 m .62793 .80164 L .61689 .78813 L p F P
0 g
s
.741 .773 .879 r
.58111 .79561 m .61689 .78813 L .62793 .80164 L p F P
0 g
s
.753 .644 .74 r
.62214 .55796 m .58855 .57266 L .57516 .54003 L p F P
0 g
s
.753 .644 .74 r
.57516 .54003 m .60929 .52691 L .62214 .55796 L p F P
0 g
s
.652 .37 .48 r
.48071 .3718 m .48203 .34659 L .51645 .34899 L p F P
0 g
s
.613 .332 .468 r
.48203 .34659 m .48071 .3718 L .44753 .3757 L p F P
0 g
s
.641 .514 .693 r
.73072 .55878 m .75452 .52508 L .73872 .58764 L closepath p F P
0 g
s
.679 .565 .72 r
.7231 .53548 m .75452 .52508 L .73072 .55878 L closepath p F P
0 g
s
.803 .793 .843 r
.68706 .76152 m .65795 .78377 L .64901 .77277 L p F P
0 g
s
.803 .793 .843 r
.64901 .77277 m .67934 .7518 L .68706 .76152 L p F P
0 g
s
.775 .786 .862 r
.61689 .78813 m .64901 .77277 L .65795 .78377 L p F P
0 g
s
.688 .596 .749 r
.7157 .51566 m .75452 .52508 L .7231 .53548 L closepath p F P
0 g
s
.705 .606 .743 r
.67907 .51446 m .7157 .51566 L .7231 .53548 L p F P
0 g
s
.68 .377 .455 r
.55349 .34477 m .55306 .35198 L .51645 .34899 L p F P
0 g
s
.606 .445 .637 r
.44001 .62145 m .42464 .6264 L .38572 .38911 L p F P
0 g
s
.606 .445 .637 r
.38572 .38911 m .40069 .38506 L .44001 .62145 L p F P
0 g
s
.822 .61 .616 r
.68248 .42846 m .74039 .47788 L .74335 .48918 L p F P
0 g
s
.827 .6 .596 r
.74039 .47788 m .68248 .42846 L .68151 .42152 L p F P
0 g
s
.654 .491 .651 r
.74741 .62616 m .7223 .6712 L .71018 .61072 L p F P
0 g
s
.654 .491 .651 r
.71018 .61072 m .73872 .58764 L .74741 .62616 L p F P
0 g
s
.66 .483 .634 r
.67998 .62953 m .71018 .61072 L .7223 .6712 L p F P
0 g
s
.66 .483 .634 r
.7223 .6712 m .694 .70426 L .67998 .62953 L p F P
0 g
s
.675 .488 .626 r
.64866 .64746 m .67998 .62953 L .694 .70426 L p F P
0 g
s
.725 .56 .666 r
.64866 .64746 m .61586 .66541 L .60203 .61243 L p F P
0 g
s
.756 .578 .656 r
.56702 .63186 m .60203 .61243 L .61586 .66541 L p F P
0 g
s
.772 .62 .691 r
.60203 .61243 m .56702 .63186 L .55386 .59228 L p F P
0 g
s
.772 .62 .691 r
.55386 .59228 m .58855 .57266 L .60203 .61243 L p F P
0 g
s
.848 .778 .784 r
.73623 .69281 m .70841 .72545 L .70126 .71535 L p F P
0 g
s
.848 .778 .784 r
.70126 .71535 m .72932 .68253 L .73623 .69281 L p F P
0 g
s
.677 .614 .778 r
.70842 .49816 m .75452 .52508 L .7157 .51566 L closepath p F P
0 g
s
.714 .633 .765 r
.7157 .51566 m .67907 .51446 L .66917 .49242 L p F P
0 g
s
.714 .633 .765 r
.66917 .49242 m .70842 .49816 L .7157 .51566 L p F P
0 g
s
.723 .651 .777 r
.67907 .51446 m .64377 .51848 L .63211 .49357 L p F P
0 g
s
.723 .651 .777 r
.63211 .49357 m .66917 .49242 L .67907 .51446 L p F P
0 g
s
.552 .425 .661 r
.73872 .58764 m .75452 .52508 L .74741 .62616 L closepath p F P
0 g
s
.639 .654 .848 r
.4981 .81151 m .48376 .81575 L .4396 .74278 L p F P
0 g
s
.623 .647 .853 r
.42536 .74681 m .4396 .74278 L .48376 .81575 L p F P
0 g
s
.817 .618 .633 r
.6834 .43445 m .74335 .48918 L .74623 .4993 L p F P
0 g
s
.822 .61 .616 r
.74335 .48918 m .6834 .43445 L .68248 .42846 L p F P
0 g
s
.737 .663 .777 r
.64377 .51848 m .60929 .52691 L .59646 .49993 L p F P
0 g
s
.737 .663 .777 r
.59646 .49993 m .63211 .49357 L .64377 .51848 L p F P
0 g
s
.719 .43 .486 r
.59195 .35666 m .5919 .37389 L .55272 .37052 L p F P
0 g
s
.719 .43 .486 r
.55272 .37052 m .55306 .35198 L .59195 .35666 L p F P
0 g
s
.781 .653 .722 r
.58855 .57266 m .55386 .59228 L .54071 .55929 L p F P
0 g
s
.781 .653 .722 r
.54071 .55929 m .57516 .54003 L .58855 .57266 L p F P
0 g
s
.8 .637 .68 r
.75452 .52508 m .68684 .4536 L .68601 .4493 L p F P
0 g
s
.8 .637 .68 r
.68601 .4493 m .7518 .51709 L .75452 .52508 L p F P
0 g
s
.65 .621 .807 r
.7012 .48226 m .75452 .52508 L .70842 .49816 L closepath p F P
0 g
s
.611 .619 .835 r
.69402 .46751 m .75452 .52508 L .7012 .48226 L closepath p F P
0 g
s
.558 .607 .858 r
.68684 .4536 m .75452 .52508 L .69402 .46751 L closepath p F P
0 g
s
.862 .75 .738 r
.75488 .63944 m .72932 .68253 L .7223 .6712 L p F P
0 g
s
.862 .75 .738 r
.7223 .6712 m .74741 .62616 L .75488 .63944 L p F P
0 g
s
.812 .625 .65 r
.68429 .43981 m .74623 .4993 L .74904 .50854 L p F P
0 g
s
.817 .618 .633 r
.74623 .4993 m .68429 .43981 L .6834 .43445 L p F P
0 g
s
.675 .488 .626 r
.694 .70426 m .66353 .72925 L .64866 .64746 L p F P
0 g
s
.698 .504 .621 r
.61586 .66541 m .64866 .64746 L .66353 .72925 L p F P
0 g
s
.806 .631 .665 r
.7518 .51709 m .68601 .4493 L .68516 .44472 L p F P
0 g
s
.812 .625 .65 r
.74904 .50854 m .68516 .44472 L .68429 .43981 L p F P
0 g
s
.686 .401 .485 r
.51574 .36998 m .51645 .34899 L .55306 .35198 L p F P
0 g
s
.652 .37 .48 r
.51645 .34899 m .51574 .36998 L .48071 .3718 L p F P
0 g
s
.757 .672 .768 r
.60929 .52691 m .57516 .54003 L .56174 .51163 L p F P
0 g
s
.757 .672 .768 r
.56174 .51163 m .59646 .49993 L .60929 .52691 L p F P
0 g
s
.686 .401 .485 r
.55306 .35198 m .55272 .37052 L .51574 .36998 L p F P
0 g
s
.719 .654 .784 r
.70842 .49816 m .66917 .49242 L .6593 .47247 L p F P
0 g
s
.719 .654 .784 r
.6593 .47247 m .7012 .48226 L .70842 .49816 L p F P
0 g
s
.823 .778 .811 r
.70841 .72545 m .67934 .7518 L .67149 .74106 L p F P
0 g
s
.823 .778 .811 r
.67149 .74106 m .70126 .71535 L .70841 .72545 L p F P
0 g
s
.654 .66 .843 r
.51261 .8067 m .4981 .81151 L .45414 .73834 L p F P
0 g
s
.639 .654 .848 r
.4396 .74278 m .45414 .73834 L .4981 .81151 L p F P
0 g
s
.607 .369 .531 r
.44819 .41352 m .42008 .46187 L .41612 .38145 L p F P
0 g
s
.607 .369 .531 r
.41612 .38145 m .44753 .3757 L .44819 .41352 L p F P
0 g
s
.795 .531 .539 r
.6348 .39924 m .68045 .41271 L .68151 .42152 L p F P
0 g
s
.793 .514 .514 r
.68045 .41271 m .6348 .39924 L .63365 .38084 L p F P
0 g
s
.698 .504 .621 r
.66353 .72925 m .63069 .74689 L .61586 .66541 L p F P
0 g
s
.733 .53 .617 r
.58037 .68278 m .61586 .66541 L .63069 .74689 L p F P
0 g
s
.756 .578 .656 r
.61586 .66541 m .58037 .68278 L .56702 .63186 L p F P
0 g
s
.757 .482 .517 r
.5919 .37389 m .63365 .38084 L .6348 .39924 L p F P
0 g
s
.726 .673 .799 r
.66917 .49242 m .63211 .49357 L .62043 .471 L p F P
0 g
s
.726 .673 .799 r
.62043 .471 m .6593 .47247 L .66917 .49242 L p F P
0 g
s
.796 .774 .832 r
.67934 .7518 m .64901 .77277 L .63992 .76049 L p F P
0 g
s
.796 .774 .832 r
.63992 .76049 m .67149 .74106 L .67934 .7518 L p F P
0 g
s
.785 .679 .747 r
.57516 .54003 m .54071 .55929 L .52749 .53039 L p F P
0 g
s
.785 .679 .747 r
.52749 .53039 m .56174 .51163 L .57516 .54003 L p F P
0 g
s
.84 .76 .775 r
.72932 .68253 m .70126 .71535 L .694 .70426 L p F P
0 g
s
.84 .76 .775 r
.694 .70426 m .7223 .6712 L .72932 .68253 L p F P
0 g
s
.767 .764 .85 r
.64901 .77277 m .61689 .78813 L .60566 .77282 L p F P
0 g
s
.767 .764 .85 r
.60566 .77282 m .63992 .76049 L .64901 .77277 L p F P
0 g
s
.738 .685 .799 r
.63211 .49357 m .59646 .49993 L .58356 .47547 L p F P
0 g
s
.738 .685 .799 r
.58356 .47547 m .62043 .471 L .63211 .49357 L p F P
0 g
s
.723 .672 .8 r
.7012 .48226 m .6593 .47247 L .64941 .45392 L p F P
0 g
s
.723 .672 .8 r
.64941 .45392 m .69402 .46751 L .7012 .48226 L p F P
0 g
s
.8 .605 .639 r
.52734 .65328 m .56702 .63186 L .58037 .68278 L p F P
0 g
s
.812 .637 .666 r
.56702 .63186 m .52734 .65328 L .51598 .6185 L p F P
0 g
s
.812 .637 .666 r
.51598 .6185 m .55386 .59228 L .56702 .63186 L p F P
0 g
s
.729 .746 .865 r
.61689 .78813 m .58111 .79561 L .5658 .77363 L p F P
0 g
s
.729 .746 .865 r
.5658 .77363 m .60566 .77282 L .61689 .78813 L p F P
0 g
s
.669 .666 .838 r
.52728 .80132 m .51261 .8067 L .46896 .7335 L p F P
0 g
s
.654 .66 .843 r
.45414 .73834 m .46896 .7335 L .51261 .8067 L p F P
0 g
s
.795 .54 .551 r
.63557 .40728 m .68151 .42152 L .68248 .42846 L p F P
0 g
s
.795 .531 .539 r
.68151 .42152 m .63557 .40728 L .6348 .39924 L p F P
0 g
s
.82 .664 .689 r
.55386 .59228 m .51598 .6185 L .50459 .58842 L p F P
0 g
s
.82 .664 .689 r
.50459 .58842 m .54071 .55929 L .55386 .59228 L p F P
0 g
s
.635 .387 .526 r
.48121 .39969 m .44819 .41352 L .44753 .3757 L p F P
0 g
s
.635 .387 .526 r
.44753 .3757 m .48071 .3718 L .48121 .39969 L p F P
0 g
s
.758 .693 .79 r
.59646 .49993 m .56174 .51163 L .54821 .48588 L p F P
0 g
s
.758 .693 .79 r
.54821 .48588 m .58356 .47547 L .59646 .49993 L p F P
0 g
s
.796 .547 .561 r
.63627 .41359 m .68248 .42846 L .6834 .43445 L p F P
0 g
s
.795 .54 .551 r
.68248 .42846 m .63627 .41359 L .63557 .40728 L p F P
0 g
s
.815 .761 .801 r
.70126 .71535 m .67149 .74106 L .66353 .72925 L p F P
0 g
s
.815 .761 .801 r
.66353 .72925 m .694 .70426 L .70126 .71535 L p F P
0 g
s
.757 .482 .517 r
.6348 .39924 m .59277 .39253 L .5919 .37389 L p F P
0 g
s
.724 .455 .52 r
.55272 .37052 m .5919 .37389 L .59277 .39253 L p F P
0 g
s
.682 .672 .833 r
.5421 .79535 m .52728 .80132 L .48404 .72825 L p F P
0 g
s
.669 .666 .838 r
.46896 .7335 m .48404 .72825 L .52728 .80132 L p F P
0 g
s
.726 .691 .816 r
.6593 .47247 m .62043 .471 L .60868 .44994 L p F P
0 g
s
.726 .691 .816 r
.60868 .44994 m .64941 .45392 L .6593 .47247 L p F P
0 g
s
.733 .53 .617 r
.63069 .74689 m .59425 .75561 L .58037 .68278 L p F P
0 g
s
.784 .569 .609 r
.53871 .69511 m .58037 .68278 L .59425 .75561 L p F P
0 g
s
.8 .605 .639 r
.58037 .68278 m .53871 .69511 L .52734 .65328 L p F P
0 g
s
.724 .687 .814 r
.69402 .46751 m .64941 .45392 L .63947 .43633 L p F P
0 g
s
.724 .687 .814 r
.63947 .43633 m .68684 .4536 L .69402 .46751 L p F P
0 g
s
.796 .552 .568 r
.63694 .41902 m .6834 .43445 L .68429 .43981 L p F P
0 g
s
.796 .547 .561 r
.6834 .43445 m .63694 .41902 L .63627 .41359 L p F P
0 g
s
.664 .409 .523 r
.5163 .39285 m .48121 .39969 L .48071 .3718 L p F P
0 g
s
.664 .409 .523 r
.48071 .3718 m .51574 .36998 L .5163 .39285 L p F P
0 g
s
.825 .686 .71 r
.54071 .55929 m .50459 .58842 L .49313 .56157 L p F P
0 g
s
.825 .686 .71 r
.49313 .56157 m .52749 .53039 L .54071 .55929 L p F P
0 g
s
.787 .699 .768 r
.56174 .51163 m .52749 .53039 L .51415 .50419 L p F P
0 g
s
.787 .699 .768 r
.51415 .50419 m .54821 .48588 L .56174 .51163 L p F P
0 g
s
.789 .755 .822 r
.67149 .74106 m .63992 .76049 L .63069 .74689 L p F P
0 g
s
.789 .755 .822 r
.63069 .74689 m .66353 .72925 L .67149 .74106 L p F P
0 g
s
.724 .455 .52 r
.59277 .39253 m .55342 .39059 L .55272 .37052 L p F P
0 g
s
.694 .431 .522 r
.51574 .36998 m .55272 .37052 L .55342 .39059 L p F P
0 g
s
.578 .548 .784 r
.4114 .75044 m .39776 .75367 L .3537 .64889 L p F P
0 g
s
.561 .538 .787 r
.34076 .65292 m .3537 .64889 L .39776 .75367 L p F P
0 g
s
.759 .498 .539 r
.59277 .39253 m .6348 .39924 L .63557 .40728 L p F P
0 g
s
.694 .431 .522 r
.55342 .39059 m .5163 .39285 L .51574 .36998 L p F P
0 g
s
.797 .557 .575 r
.63759 .42387 m .68429 .43981 L .68516 .44472 L p F P
0 g
s
.796 .552 .568 r
.68429 .43981 m .63759 .42387 L .63694 .41902 L p F P
0 g
s
.738 .702 .817 r
.62043 .471 m .58356 .47547 L .57054 .45263 L p F P
0 g
s
.738 .702 .817 r
.57054 .45263 m .60868 .44994 L .62043 .471 L p F P
0 g
s
.759 .743 .838 r
.63992 .76049 m .60566 .77282 L .59425 .75561 L p F P
0 g
s
.759 .743 .838 r
.59425 .75561 m .63069 .74689 L .63992 .76049 L p F P
0 g
s
.797 .562 .581 r
.63823 .42831 m .68516 .44472 L .68601 .4493 L p F P
0 g
s
.797 .557 .575 r
.68516 .44472 m .63823 .42831 L .63759 .42387 L p F P
0 g
s
.798 .566 .587 r
.63886 .43244 m .68601 .4493 L .68684 .4536 L p F P
0 g
s
.797 .562 .581 r
.68601 .4493 m .63886 .43244 L .63823 .42831 L p F P
0 g
s
.76 .507 .55 r
.59341 .40064 m .63557 .40728 L .63627 .41359 L p F P
0 g
s
.759 .498 .539 r
.63557 .40728 m .59341 .40064 L .59277 .39253 L p F P
0 g
s
.798 .566 .587 r
.68684 .4536 m .63947 .43633 L .63886 .43244 L p F P
0 g
s
.716 .719 .852 r
.60566 .77282 m .5658 .77363 L .55021 .74823 L p F P
0 g
s
.716 .719 .852 r
.55021 .74823 m .59425 .75561 L .60566 .77282 L p F P
0 g
s
.757 .709 .807 r
.58356 .47547 m .54821 .48588 L .53454 .46187 L p F P
0 g
s
.757 .709 .807 r
.53454 .46187 m .57054 .45263 L .58356 .47547 L p F P
0 g
s
.827 .703 .727 r
.52749 .53039 m .49313 .56157 L .48156 .53703 L p F P
0 g
s
.827 .703 .727 r
.48156 .53703 m .51415 .50419 L .52749 .53039 L p F P
0 g
s
.595 .556 .782 r
.42536 .74681 m .4114 .75044 L .36707 .64471 L p F P
0 g
s
.578 .548 .784 r
.3537 .64889 m .36707 .64471 L .4114 .75044 L p F P
0 g
s
.725 .704 .83 r
.64941 .45392 m .60868 .44994 L .59682 .4299 L p F P
0 g
s
.725 .704 .83 r
.59682 .4299 m .63947 .43633 L .64941 .45392 L p F P
0 g
s
.761 .513 .558 r
.59401 .40701 m .63627 .41359 L .63694 .41902 L p F P
0 g
s
.76 .507 .55 r
.63627 .41359 m .59401 .40701 L .59341 .40064 L p F P
0 g
s
.728 .472 .541 r
.55342 .39059 m .59277 .39253 L .59341 .40064 L p F P
0 g
s
.786 .714 .785 r
.54821 .48588 m .51415 .50419 L .50065 .47981 L p F P
0 g
s
.786 .714 .785 r
.50065 .47981 m .53454 .46187 L .54821 .48588 L p F P
0 g
s
.762 .518 .564 r
.59459 .41248 m .63694 .41902 L .63759 .42387 L p F P
0 g
s
.761 .513 .558 r
.63694 .41902 m .59459 .41248 L .59401 .40701 L p F P
0 g
s
.866 .66 .622 r
.46322 .63787 m .51598 .6185 L .52734 .65328 L closepath p F P
0 g
s
.145 .391 .841 r
.5658 .77363 m .49411 .7118 L .46322 .63787 L p F P
0 g
s
.729 .48 .551 r
.55401 .39933 m .59341 .40064 L .59401 .40701 L p F P
0 g
s
.728 .472 .541 r
.59341 .40064 m .55401 .39933 L .55342 .39059 L p F P
0 g
s
.699 .45 .544 r
.5163 .39285 m .55342 .39059 L .55401 .39933 L p F P
0 g
s
.763 .523 .57 r
.59516 .41736 m .63759 .42387 L .63823 .42831 L p F P
0 g
s
.762 .518 .564 r
.63759 .42387 m .59516 .41736 L .59459 .41248 L p F P
0 g
s
.871 .676 .637 r
.46322 .63787 m .50459 .58842 L .51598 .6185 L closepath p F P
0 g
s
.61 .565 .779 r
.4396 .74278 m .42536 .74681 L .38086 .64036 L p F P
0 g
s
.595 .556 .782 r
.36707 .64471 m .38086 .64036 L .42536 .74681 L p F P
0 g
s
.736 .714 .831 r
.60868 .44994 m .57054 .45263 L .55738 .43087 L p F P
0 g
s
.736 .714 .831 r
.55738 .43087 m .59682 .4299 L .60868 .44994 L p F P
0 g
s
.764 .527 .576 r
.59572 .42183 m .63823 .42831 L .63886 .43244 L p F P
0 g
s
.763 .523 .57 r
.63823 .42831 m .59572 .42183 L .59516 .41736 L p F P
0 g
s
.699 .45 .544 r
.55401 .39933 m .51691 .40284 L .5163 .39285 L p F P
0 g
s
.671 .43 .548 r
.48121 .39969 m .5163 .39285 L .51691 .40284 L p F P
0 g
s
.671 .43 .548 r
.51691 .40284 m .48196 .41196 L .48121 .39969 L p F P
0 g
s
.644 .415 .555 r
.44819 .41352 m .48121 .39969 L .48196 .41196 L p F P
0 g
s
.731 .487 .559 r
.55458 .4062 m .59401 .40701 L .59459 .41248 L p F P
0 g
s
.729 .48 .551 r
.59401 .40701 m .55458 .4062 L .55401 .39933 L p F P
0 g
s
.879 .692 .644 r
.46322 .63787 m .49313 .56157 L .50459 .58842 L closepath p F P
0 g
s
.764 .531 .58 r
.59628 .42599 m .63886 .43244 L .63947 .43633 L p F P
0 g
s
.764 .527 .576 r
.63886 .43244 m .59628 .42599 L .59572 .42183 L p F P
0 g
s
.784 .569 .609 r
.59425 .75561 m .55021 .74823 L .53871 .69511 L p F P
0 g
s
.828 .717 .743 r
.51415 .50419 m .48156 .53703 L .46988 .51419 L p F P
0 g
s
.828 .717 .743 r
.46988 .51419 m .50065 .47981 L .51415 .50419 L p F P
0 g
s
.644 .415 .555 r
.48196 .41196 m .44943 .4304 L .44819 .41352 L p F P
0 g
s
.602 .392 .569 r
.42008 .46187 m .44819 .41352 L .44943 .4304 L p F P
0 g
s
.701 .459 .554 r
.51691 .40284 m .55401 .39933 L .55458 .4062 L p F P
0 g
s
.764 .531 .58 r
.63947 .43633 m .59682 .4299 L .59628 .42599 L p F P
0 g
s
.732 .492 .566 r
.55515 .41209 m .59459 .41248 L .59516 .41736 L p F P
0 g
s
.731 .487 .559 r
.59459 .41248 m .55515 .41209 L .55458 .4062 L p F P
0 g
s
.754 .721 .822 r
.57054 .45263 m .53454 .46187 L .52069 .43903 L p F P
0 g
s
.754 .721 .822 r
.52069 .43903 m .55738 .43087 L .57054 .45263 L p F P
0 g
s
.624 .572 .776 r
.45414 .73834 m .4396 .74278 L .39506 .63586 L p F P
0 g
s
.61 .565 .779 r
.38086 .64036 m .39506 .63586 L .4396 .74278 L p F P
0 g
s
.701 .459 .554 r
.55458 .4062 m .51753 .4107 L .51691 .40284 L p F P
0 g
s
.674 .441 .56 r
.48196 .41196 m .51691 .40284 L .51753 .4107 L p F P
0 g
s
.733 .497 .571 r
.55571 .41735 m .59516 .41736 L .59572 .42183 L p F P
0 g
s
.732 .492 .566 r
.59516 .41736 m .55571 .41735 L .55515 .41209 L p F P
0 g
s
.702 .466 .563 r
.51753 .4107 m .55458 .4062 L .55515 .41209 L p F P
0 g
s
.89 .705 .646 r
.46322 .63787 m .48156 .53703 L .49313 .56157 L closepath p F P
0 g
s
.674 .441 .56 r
.51753 .4107 m .48276 .42165 L .48196 .41196 L p F P
0 g
s
.647 .426 .569 r
.44943 .4304 m .48196 .41196 L .48276 .42165 L p F P
0 g
s
.734 .501 .577 r
.55627 .42217 m .59572 .42183 L .59628 .42599 L p F P
0 g
s
.733 .497 .571 r
.59572 .42183 m .55627 .42217 L .55571 .41735 L p F P
0 g
s
.783 .726 .799 r
.53454 .46187 m .50065 .47981 L .48698 .4567 L p F P
0 g
s
.783 .726 .799 r
.48698 .4567 m .52069 .43903 L .53454 .46187 L p F P
0 g
s
.704 .472 .57 r
.51815 .41746 m .55515 .41209 L .55571 .41735 L p F P
0 g
s
.702 .466 .563 r
.55515 .41209 m .51815 .41746 L .51753 .4107 L p F P
0 g
s
.676 .449 .569 r
.48276 .42165 m .51753 .4107 L .51815 .41746 L p F P
0 g
s
.734 .505 .581 r
.55682 .42666 m .59628 .42599 L .59682 .4299 L p F P
0 g
s
.734 .501 .577 r
.59628 .42599 m .55682 .42666 L .55627 .42217 L p F P
0 g
s
.637 .579 .773 r
.46896 .7335 m .45414 .73834 L .40966 .6312 L p F P
0 g
s
.624 .572 .776 r
.39506 .63586 m .40966 .6312 L .45414 .73834 L p F P
0 g
s
.647 .426 .569 r
.48276 .42165 m .45078 .4438 L .44943 .4304 L p F P
0 g
s
.576 .387 .588 r
.42576 .49942 m .44943 .4304 L .45078 .4438 L p F P
0 g
s
.602 .392 .569 r
.44943 .4304 m .42576 .49942 L .42008 .46187 L p F P
0 g
s
.734 .505 .581 r
.59682 .4299 m .55738 .43087 L .55682 .42666 L p F P
0 g
s
.705 .477 .576 r
.51878 .4235 m .55571 .41735 L .55627 .42217 L p F P
0 g
s
.704 .472 .57 r
.55571 .41735 m .51878 .4235 L .51815 .41746 L p F P
0 g
s
.676 .449 .569 r
.51815 .41746 m .48358 .42999 L .48276 .42165 L p F P
0 g
s
.649 .435 .58 r
.45078 .4438 m .48276 .42165 L .48358 .42999 L p F P
0 g
s
.677 .455 .577 r
.48358 .42999 m .51815 .41746 L .51878 .4235 L p F P
0 g
s
.827 .729 .756 r
.50065 .47981 m .46988 .51419 L .45806 .4926 L p F P
0 g
s
.827 .729 .756 r
.45806 .4926 m .48698 .4567 L .50065 .47981 L p F P
0 g
s
.706 .481 .581 r
.51942 .42904 m .55627 .42217 L .55682 .42666 L p F P
0 g
s
.705 .477 .576 r
.55627 .42217 m .51942 .42904 L .51878 .4235 L p F P
0 g
s
.9 .716 .645 r
.46322 .63787 m .46988 .51419 L .48156 .53703 L closepath p F P
0 g
s
.65 .586 .769 r
.48404 .72825 m .46896 .7335 L .42464 .6264 L p F P
0 g
s
.637 .579 .773 r
.40966 .6312 m .42464 .6264 L .46896 .7335 L p F P
0 g
s
.679 .461 .583 r
.48441 .43746 m .51878 .4235 L .51942 .42904 L p F P
0 g
s
.677 .455 .577 r
.51878 .4235 m .48441 .43746 L .48358 .42999 L p F P
0 g
s
.707 .486 .586 r
.52005 .43419 m .55682 .42666 L .55738 .43087 L p F P
0 g
s
.706 .481 .581 r
.55682 .42666 m .52005 .43419 L .51942 .42904 L p F P
0 g
s
.65 .443 .589 r
.45218 .45537 m .48358 .42999 L .48441 .43746 L p F P
0 g
s
.649 .435 .58 r
.48358 .42999 m .45218 .45537 L .45078 .4438 L p F P
0 g
s
.546 .376 .602 r
.43175 .52948 m .45078 .4438 L .45218 .45537 L p F P
0 g
s
.576 .387 .588 r
.45078 .4438 m .43175 .52948 L .42576 .49942 L p F P
0 g
s
.707 .486 .586 r
.55738 .43087 m .52069 .43903 L .52005 .43419 L p F P
0 g
s
.68 .466 .589 r
.48526 .44431 m .51942 .42904 L .52005 .43419 L p F P
0 g
s
.679 .461 .583 r
.51942 .42904 m .48526 .44431 L .48441 .43746 L p F P
0 g
s
.651 .449 .597 r
.45361 .46577 m .48441 .43746 L .48526 .44431 L p F P
0 g
s
.65 .443 .589 r
.48441 .43746 m .45361 .46577 L .45218 .45537 L p F P
0 g
s
.663 .592 .766 r
.49938 .72258 m .48404 .72825 L .44001 .62145 L p F P
0 g
s
.65 .586 .769 r
.42464 .6264 m .44001 .62145 L .48404 .72825 L p F P
0 g
s
.681 .471 .595 r
.48612 .45069 m .52005 .43419 L .52069 .43903 L p F P
0 g
s
.68 .466 .589 r
.52005 .43419 m .48612 .45069 L .48526 .44431 L p F P
0 g
s
.511 .36 .613 r
.4379 .55549 m .45218 .45537 L .45361 .46577 L p F P
0 g
s
.546 .376 .602 r
.45218 .45537 m .4379 .55549 L .43175 .52948 L p F P
0 g
s
.652 .455 .604 r
.45508 .47532 m .48526 .44431 L .48612 .45069 L p F P
0 g
s
.651 .449 .597 r
.48526 .44431 m .45508 .47532 L .45361 .46577 L p F P
0 g
s
.681 .471 .595 r
.52069 .43903 m .48698 .4567 L .48612 .45069 L p F P
0 g
s
.909 .724 .641 r
.46322 .63787 m .45806 .4926 L .46988 .51419 L closepath p F P
0 g
s
.652 .46 .61 r
.45656 .48422 m .48612 .45069 L .48698 .4567 L p F P
0 g
s
.652 .455 .604 r
.48612 .45069 m .45656 .48422 L .45508 .47532 L p F P
0 g
s
.47 .34 .621 r
.44416 .57876 m .45361 .46577 L .45508 .47532 L p F P
0 g
s
.511 .36 .613 r
.45361 .46577 m .44416 .57876 L .4379 .55549 L p F P
0 g
s
.652 .46 .61 r
.48698 .4567 m .45806 .4926 L .45656 .48422 L p F P
0 g
s
.424 .316 .628 r
.45048 .6 m .45508 .47532 L .45656 .48422 L p F P
0 g
s
.47 .34 .621 r
.45508 .47532 m .45048 .6 L .44416 .57876 L p F P
0 g
s
.372 .288 .631 r
.45806 .4926 m .46322 .63787 L .45684 .61961 L p F P
0 g
s
.25 Mabswid
.67245 0 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.67245 0 m
.08846 .24555 L
s
.08846 .24555 m
.67245 0 L
s
.17494 .20919 m
.17988 .21455 L
s
[(-2)] .16507 .19847 .92074 1 Mshowa
.36358 .12987 m
.36813 .13557 L
s
[(0)] .3545 .11847 .79718 1 Mshowa
.56751 .04413 m
.57158 .05017 L
s
[(2)] .55936 .03204 .67363 1 Mshowa
.125 Mabswid
.22076 .18992 m
.22367 .19319 L
s
.26746 .17029 m
.27031 .1736 L
s
.31506 .15027 m
.31785 .15364 L
s
.41306 .10907 m
.41572 .11254 L
s
.46352 .08785 m
.46611 .09137 L
s
.51499 .06621 m
.51751 .06978 L
s
.12996 .2281 m
.13298 .23127 L
s
.62109 .0216 m
.62346 .02528 L
s
.25 Mabswid
0 .80374 m
.40037 1.0855 L
s
.07813 .85872 m
.07909 .8515 L
s
[(-2)] .07621 .87317 .13275 -1 Mshowa
.22183 .95985 m
.22246 .95259 L
s
[(0)] .22056 .97437 .08756 -1 Mshowa
.34602 1.04725 m
.34639 1.03997 L
s
[(2)] .34529 1.06181 .05058 -1 Mshowa
.125 Mabswid
.11613 .88546 m
.11665 .88112 L
s
.15269 .91119 m
.15317 .90685 L
s
.1879 .93597 m
.18833 .93162 L
s
.25454 .98287 m
.25488 .97851 L
s
.28611 1.00508 m
.28641 1.00072 L
s
.31658 1.02653 m
.31684 1.02216 L
s
.03861 .83091 m
.03924 .82658 L
s
.37448 1.06728 m
.37467 1.06291 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.35.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics3D", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[9]= ",
 CellTags->"S5.35.1"]
}, Open  ]],

Cell[TextData[{
 "You can also specify regions in the complex plane using inequalities. All \
operations on complex numbers need eventually to involve real quantities \
before using inequalities to specify these regions. Typically this means that \
complex arithmetic expressions are eventually wrapped in real\[Hyphen]valued \
functions such as ",
 StyleBox["Abs", "MR"],
 ", ",
 StyleBox["Re", "MR"],
 ", and ",
 StyleBox["Im", "MR"],
 ". "
}], "Text",
 CellTags->{"S5.35.1", "1.12"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["ComplexInequalityPlot[ ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ineqs", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["z", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["zmin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["zmax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "construct a graphic representation of the set of inequalities ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ineqs", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" in the variable ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["z", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" over the complex region given by ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["zmin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["zmax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[".",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.35.1"],

Cell["Visualizing complex regions. ", "Caption",
 CellTags->"S5.35.1"],

Cell["Here is the simplest complex region. ", "MathCaption",
 CellTags->{"S5.35.1", "1.13"}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexInequalityPlot", "[", " ", 
  RowBox[{
   RowBox[{
    RowBox[{"Abs", "[", "z", "]"}], " ", "\[LessEqual]", "1"}], ",", " ", 
   RowBox[{"{", "z", "}"}]}], " ", "]"}]], "Input",
 CellLabel->"In[10]:= ",
 CellTags->"S5.35.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 1 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.476191 0.5 0.476191 [
[.02381 .4875 -6 -9 ]
[.02381 .4875 6 0 ]
[.2619 .4875 -12 -9 ]
[.2619 .4875 12 0 ]
[.7381 .4875 -9 -9 ]
[.7381 .4875 9 0 ]
[.97619 .4875 -3 -9 ]
[.97619 .4875 3 0 ]
[.4875 .02381 -12 -4.5 ]
[.4875 .02381 0 4.5 ]
[.4875 .2619 -24 -4.5 ]
[.4875 .2619 0 4.5 ]
[.4875 .7381 -18 -4.5 ]
[.4875 .7381 0 4.5 ]
[.4875 .97619 -6 -4.5 ]
[.4875 .97619 0 4.5 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .5 m
.02381 .50625 L
s
[(-1)] .02381 .4875 0 1 Mshowa
.2619 .5 m
.2619 .50625 L
s
[(-0.5)] .2619 .4875 0 1 Mshowa
.7381 .5 m
.7381 .50625 L
s
[(0.5)] .7381 .4875 0 1 Mshowa
.97619 .5 m
.97619 .50625 L
s
[(1)] .97619 .4875 0 1 Mshowa
.125 Mabswid
.07143 .5 m
.07143 .50375 L
s
.11905 .5 m
.11905 .50375 L
s
.16667 .5 m
.16667 .50375 L
s
.21429 .5 m
.21429 .50375 L
s
.30952 .5 m
.30952 .50375 L
s
.35714 .5 m
.35714 .50375 L
s
.40476 .5 m
.40476 .50375 L
s
.45238 .5 m
.45238 .50375 L
s
.54762 .5 m
.54762 .50375 L
s
.59524 .5 m
.59524 .50375 L
s
.64286 .5 m
.64286 .50375 L
s
.69048 .5 m
.69048 .50375 L
s
.78571 .5 m
.78571 .50375 L
s
.83333 .5 m
.83333 .50375 L
s
.88095 .5 m
.88095 .50375 L
s
.92857 .5 m
.92857 .50375 L
s
.25 Mabswid
0 .5 m
1 .5 L
s
.5 .02381 m
.50625 .02381 L
s
[(-1)] .4875 .02381 1 0 Mshowa
.5 .2619 m
.50625 .2619 L
s
[(-0.5)] .4875 .2619 1 0 Mshowa
.5 .7381 m
.50625 .7381 L
s
[(0.5)] .4875 .7381 1 0 Mshowa
.5 .97619 m
.50625 .97619 L
s
[(1)] .4875 .97619 1 0 Mshowa
.125 Mabswid
.5 .07143 m
.50375 .07143 L
s
.5 .11905 m
.50375 .11905 L
s
.5 .16667 m
.50375 .16667 L
s
.5 .21429 m
.50375 .21429 L
s
.5 .30952 m
.50375 .30952 L
s
.5 .35714 m
.50375 .35714 L
s
.5 .40476 m
.50375 .40476 L
s
.5 .45238 m
.50375 .45238 L
s
.5 .54762 m
.50375 .54762 L
s
.5 .59524 m
.50375 .59524 L
s
.5 .64286 m
.50375 .64286 L
s
.5 .69048 m
.50375 .69048 L
s
.5 .78571 m
.50375 .78571 L
s
.5 .83333 m
.50375 .83333 L
s
.5 .88095 m
.50375 .88095 L
s
.5 .92857 m
.50375 .92857 L
s
.25 Mabswid
.5 0 m
.5 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 Mabswid
.02381 .49981 m
.02499 .46656 L
.02605 .45381 L
.02846 .43364 L
.03279 .40798 L
.03784 .38526 L
.04262 .36749 L
.06244 .31211 L
.08265 .27071 L
.10458 .23467 L
.14545 .18212 L
.1848 .14306 L
.22263 .11293 L
.26292 .08702 L
.30169 .06707 L
.34292 .05046 L
.36351 .04379 L
.38262 .0385 L
.40229 .03394 L
.42082 .03044 L
.44134 .02744 L
.45995 .0255 L
.46971 .02477 L
.47505 .02446 L
.48003 .02423 L
.48428 .02407 L
.48883 .02394 L
.49143 .02389 L
.49271 .02387 L
.49389 .02385 L
.49494 .02384 L
.4961 .02383 L
.49726 .02382 L
.4985 .02381 L
.49971 .02381 L
.50085 .02381 L
.50209 .02381 L
.50278 .02382 L
.50341 .02382 L
.50469 .02383 L
.50608 .02385 L
.50859 .02389 L
.51093 .02393 L
.51341 .024 L
.51785 .02414 L
.52298 .02436 L
.52778 .02462 L
.5387 .02538 L
.54911 .02635 L
.55899 .02748 L
Mistroke
.57753 .03016 L
.59737 .03387 L
.61577 .0381 L
.65495 .04973 L
.69659 .06628 L
.73671 .08681 L
.77531 .11146 L
.81636 .14409 L
.8559 .18363 L
.89393 .23246 L
.91511 .26668 L
.9344 .30493 L
.944 .32789 L
.95442 .35768 L
.9592 .37394 L
.96427 .39411 L
.9686 .41529 L
.97089 .42916 L
.97336 .4482 L
.97408 .45526 L
.97484 .46416 L
.97549 .47409 L
.97619 .49981 L
Mfstroke
.02381 .50019 m
.02499 .53344 L
.02605 .54619 L
.02846 .56636 L
.03279 .59202 L
.03784 .61474 L
.04262 .63251 L
.06244 .68789 L
.08265 .72929 L
.10458 .76533 L
.14545 .81788 L
.1848 .85694 L
.22263 .88707 L
.26292 .91298 L
.30169 .93293 L
.34292 .94954 L
.36351 .95621 L
.38262 .9615 L
.40229 .96606 L
.42082 .96956 L
.44134 .97256 L
.45995 .9745 L
.46971 .97523 L
.47505 .97554 L
.48003 .97577 L
.48428 .97593 L
.48883 .97606 L
.49143 .97611 L
.49271 .97613 L
.49389 .97615 L
.49494 .97616 L
.4961 .97617 L
.49726 .97618 L
.4985 .97619 L
.49971 .97619 L
.50085 .97619 L
.50209 .97619 L
.50278 .97618 L
.50341 .97618 L
.50469 .97617 L
.50608 .97615 L
.50859 .97611 L
.51093 .97607 L
.51341 .976 L
.51785 .97586 L
.52298 .97564 L
.52778 .97538 L
.5387 .97462 L
.54911 .97365 L
.55899 .97252 L
Mistroke
.57753 .96984 L
.59737 .96613 L
.61577 .9619 L
.65495 .95027 L
.69659 .93372 L
.73671 .91319 L
.77531 .88854 L
.81636 .85591 L
.8559 .81637 L
.89393 .76754 L
.91511 .73332 L
.9344 .69507 L
.944 .67211 L
.95442 .64232 L
.9592 .62606 L
.96427 .60589 L
.9686 .58471 L
.97089 .57084 L
.97336 .5518 L
.97408 .54474 L
.97484 .53584 L
.97549 .52591 L
.97619 .50019 L
Mfstroke
0 1 1 r
.02381 .49981 m
.02499 .46656 L
.02605 .45381 L
.02846 .43364 L
.03279 .40798 L
.03784 .38526 L
.04262 .36749 L
.06244 .31211 L
.08265 .27071 L
.10458 .23467 L
.14545 .18212 L
.1848 .14306 L
.22263 .11293 L
.26292 .08702 L
.30169 .06707 L
.34292 .05046 L
.36351 .04379 L
.38262 .0385 L
.40229 .03394 L
.42082 .03044 L
.44134 .02744 L
.45995 .0255 L
.46971 .02477 L
.47505 .02446 L
.48003 .02423 L
.48428 .02407 L
.48883 .02394 L
.49143 .02389 L
.49271 .02387 L
.49389 .02385 L
.49494 .02384 L
.4961 .02383 L
.49726 .02382 L
.4985 .02381 L
.49971 .02381 L
.50085 .02381 L
.50209 .02381 L
.50278 .02382 L
.50341 .02382 L
.50469 .02383 L
.50608 .02385 L
.50859 .02389 L
.51093 .02393 L
.51341 .024 L
.51785 .02414 L
.52298 .02436 L
.52778 .02462 L
.5387 .02538 L
.54911 .02635 L
.55899 .02748 L
.57753 .03016 L
.59737 .03387 L
.61577 .0381 L
.65495 .04973 L
.69659 .06628 L
.73671 .08681 L
.77531 .11146 L
.81636 .14409 L
.8559 .18363 L
.89393 .23246 L
.91511 .26668 L
.9344 .30493 L
.944 .32789 L
.95442 .35768 L
.9592 .37394 L
.96427 .39411 L
.9686 .41529 L
.97089 .42916 L
.97336 .4482 L
.97408 .45526 L
.97484 .46416 L
.97549 .47409 L
.97619 .49981 L
.97619 .50019 L
.97549 .52591 L
.97484 .53584 L
.97408 .54474 L
.97336 .5518 L
.97089 .57084 L
.9686 .58471 L
.96427 .60589 L
.9592 .62606 L
.95442 .64232 L
.944 .67211 L
.9344 .69507 L
.91511 .73332 L
.89393 .76754 L
.8559 .81637 L
.81636 .85591 L
.77531 .88854 L
.73671 .91319 L
.69659 .93372 L
.65495 .95027 L
.61577 .9619 L
.59737 .96613 L
.57753 .96984 L
.55899 .97252 L
.54911 .97365 L
.5387 .97462 L
.52778 .97538 L
.52298 .97564 L
.51785 .97586 L
.51341 .976 L
.51093 .97607 L
.50859 .97611 L
.50608 .97615 L
.50469 .97617 L
.50341 .97618 L
.50278 .97618 L
.50209 .97619 L
.50085 .97619 L
.49971 .97619 L
.4985 .97619 L
.49726 .97618 L
.4961 .97617 L
.49494 .97616 L
.49389 .97615 L
.49271 .97613 L
.49143 .97611 L
.48883 .97606 L
.48428 .97593 L
.48003 .97577 L
.47505 .97554 L
.46971 .97523 L
.45995 .9745 L
.44134 .97256 L
.42082 .96956 L
.40229 .96606 L
.38262 .9615 L
.36351 .95621 L
.34292 .94954 L
.30169 .93293 L
.26292 .91298 L
.22263 .88707 L
.1848 .85694 L
.14545 .81788 L
.10458 .76533 L
.08265 .72929 L
.06244 .68789 L
.04262 .63251 L
.03784 .61474 L
.03279 .59202 L
.02846 .56636 L
.02605 .54619 L
.02499 .53344 L
.02381 .50019 L
F
0 g
.02381 .49981 m
.02499 .46656 L
.02605 .45381 L
.02846 .43364 L
.03279 .40798 L
.03784 .38526 L
.04262 .36749 L
.06244 .31211 L
.08265 .27071 L
.10458 .23467 L
.14545 .18212 L
.1848 .14306 L
.22263 .11293 L
.26292 .08702 L
.30169 .06707 L
.34292 .05046 L
.36351 .04379 L
.38262 .0385 L
.40229 .03394 L
.42082 .03044 L
.44134 .02744 L
.45995 .0255 L
.46971 .02477 L
.47505 .02446 L
.48003 .02423 L
.48428 .02407 L
.48883 .02394 L
.49143 .02389 L
.49271 .02387 L
.49389 .02385 L
.49494 .02384 L
.4961 .02383 L
.49726 .02382 L
.4985 .02381 L
.49971 .02381 L
.50085 .02381 L
.50209 .02381 L
.50278 .02382 L
.50341 .02382 L
.50469 .02383 L
.50608 .02385 L
.50859 .02389 L
.51093 .02393 L
.51341 .024 L
.51785 .02414 L
.52298 .02436 L
.52778 .02462 L
.5387 .02538 L
.54911 .02635 L
.55899 .02748 L
Mistroke
.57753 .03016 L
.59737 .03387 L
.61577 .0381 L
.65495 .04973 L
.69659 .06628 L
.73671 .08681 L
.77531 .11146 L
.81636 .14409 L
.8559 .18363 L
.89393 .23246 L
.91511 .26668 L
.9344 .30493 L
.944 .32789 L
.95442 .35768 L
.9592 .37394 L
.96427 .39411 L
.9686 .41529 L
.97089 .42916 L
.97336 .4482 L
.97408 .45526 L
.97484 .46416 L
.97549 .47409 L
.97619 .49981 L
Mfstroke
.02381 .50019 m
.02499 .53344 L
.02605 .54619 L
.02846 .56636 L
.03279 .59202 L
.03784 .61474 L
.04262 .63251 L
.06244 .68789 L
.08265 .72929 L
.10458 .76533 L
.14545 .81788 L
.1848 .85694 L
.22263 .88707 L
.26292 .91298 L
.30169 .93293 L
.34292 .94954 L
.36351 .95621 L
.38262 .9615 L
.40229 .96606 L
.42082 .96956 L
.44134 .97256 L
.45995 .9745 L
.46971 .97523 L
.47505 .97554 L
.48003 .97577 L
.48428 .97593 L
.48883 .97606 L
.49143 .97611 L
.49271 .97613 L
.49389 .97615 L
.49494 .97616 L
.4961 .97617 L
.49726 .97618 L
.4985 .97619 L
.49971 .97619 L
.50085 .97619 L
.50209 .97619 L
.50278 .97618 L
.50341 .97618 L
.50469 .97617 L
.50608 .97615 L
.50859 .97611 L
.51093 .97607 L
.51341 .976 L
.51785 .97586 L
.52298 .97564 L
.52778 .97538 L
.5387 .97462 L
.54911 .97365 L
.55899 .97252 L
Mistroke
.57753 .96984 L
.59737 .96613 L
.61577 .9619 L
.65495 .95027 L
.69659 .93372 L
.73671 .91319 L
.77531 .88854 L
.81636 .85591 L
.8559 .81637 L
.89393 .76754 L
.91511 .73332 L
.9344 .69507 L
.944 .67211 L
.95442 .64232 L
.9592 .62606 L
.96427 .60589 L
.9686 .58471 L
.97089 .57084 L
.97336 .5518 L
.97408 .54474 L
.97484 .53584 L
.97549 .52591 L
.97619 .50019 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 1 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.476191 0.5 0.476191 [
[.02381 .4875 -6 -9 ]
[.02381 .4875 6 0 ]
[.2619 .4875 -12 -9 ]
[.2619 .4875 12 0 ]
[.7381 .4875 -9 -9 ]
[.7381 .4875 9 0 ]
[.97619 .4875 -3 -9 ]
[.97619 .4875 3 0 ]
[.4875 .02381 -12 -4.5 ]
[.4875 .02381 0 4.5 ]
[.4875 .2619 -24 -4.5 ]
[.4875 .2619 0 4.5 ]
[.4875 .7381 -18 -4.5 ]
[.4875 .7381 0 4.5 ]
[.4875 .97619 -6 -4.5 ]
[.4875 .97619 0 4.5 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .5 m
.02381 .50625 L
s
[(-1)] .02381 .4875 0 1 Mshowa
.2619 .5 m
.2619 .50625 L
s
[(-0.5)] .2619 .4875 0 1 Mshowa
.7381 .5 m
.7381 .50625 L
s
[(0.5)] .7381 .4875 0 1 Mshowa
.97619 .5 m
.97619 .50625 L
s
[(1)] .97619 .4875 0 1 Mshowa
.125 Mabswid
.07143 .5 m
.07143 .50375 L
s
.11905 .5 m
.11905 .50375 L
s
.16667 .5 m
.16667 .50375 L
s
.21429 .5 m
.21429 .50375 L
s
.30952 .5 m
.30952 .50375 L
s
.35714 .5 m
.35714 .50375 L
s
.40476 .5 m
.40476 .50375 L
s
.45238 .5 m
.45238 .50375 L
s
.54762 .5 m
.54762 .50375 L
s
.59524 .5 m
.59524 .50375 L
s
.64286 .5 m
.64286 .50375 L
s
.69048 .5 m
.69048 .50375 L
s
.78571 .5 m
.78571 .50375 L
s
.83333 .5 m
.83333 .50375 L
s
.88095 .5 m
.88095 .50375 L
s
.92857 .5 m
.92857 .50375 L
s
.25 Mabswid
0 .5 m
1 .5 L
s
.5 .02381 m
.50625 .02381 L
s
[(-1)] .4875 .02381 1 0 Mshowa
.5 .2619 m
.50625 .2619 L
s
[(-0.5)] .4875 .2619 1 0 Mshowa
.5 .7381 m
.50625 .7381 L
s
[(0.5)] .4875 .7381 1 0 Mshowa
.5 .97619 m
.50625 .97619 L
s
[(1)] .4875 .97619 1 0 Mshowa
.125 Mabswid
.5 .07143 m
.50375 .07143 L
s
.5 .11905 m
.50375 .11905 L
s
.5 .16667 m
.50375 .16667 L
s
.5 .21429 m
.50375 .21429 L
s
.5 .30952 m
.50375 .30952 L
s
.5 .35714 m
.50375 .35714 L
s
.5 .40476 m
.50375 .40476 L
s
.5 .45238 m
.50375 .45238 L
s
.5 .54762 m
.50375 .54762 L
s
.5 .59524 m
.50375 .59524 L
s
.5 .64286 m
.50375 .64286 L
s
.5 .69048 m
.50375 .69048 L
s
.5 .78571 m
.50375 .78571 L
s
.5 .83333 m
.50375 .83333 L
s
.5 .88095 m
.50375 .88095 L
s
.5 .92857 m
.50375 .92857 L
s
.25 Mabswid
.5 0 m
.5 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.35.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[10]= ",
 CellTags->"S5.35.1"]
}, Open  ]],

Cell[TextData[{
 "This is the region ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[LeftBracketingBar]", 
    SuperscriptBox[
     StyleBox["z",
      "TI"], "3"], "+", "3", 
    SuperscriptBox[
     StyleBox["z",
      "TI"], "2"], "-", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"2", "\[ImaginaryI]"}]}], ")"}], 
    SuperscriptBox["\[RightBracketingBar]", "2"], "\[LessEqual]", 
    "\[LeftBracketingBar]", 
    StyleBox["z",
     "TI"], "+", "\[ImaginaryI]", 
    SuperscriptBox["\[RightBracketingBar]", "2"]}], TraditionalForm]], 
  "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.35.1", "1.14"}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexInequalityPlot", "[", " ", 
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"Abs", "[", " ", 
      RowBox[{
       SuperscriptBox["z", "3"], "+", 
       RowBox[{"3", 
        SuperscriptBox["z", "2"]}], "-", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"2", "\[ImaginaryI]"}]}], ")"}]}], "]"}], "2"], 
    "\[LessEqual]", 
    SuperscriptBox[
     RowBox[{"Abs", "[", 
      RowBox[{"z", "+", "\[ImaginaryI]"}], "]"}], "2"]}], ",", " ", 
   RowBox[{"{", "z", "}"}]}], " ", "]"}]], "Input",
 CellLabel->"In[11]:= ",
 CellTags->"S5.35.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .34447 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.344468 [
[ 0 0 0 0 ]
[ 1 .34447 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .34447 L
0 .34447 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.344468 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.769512 0.228825 0.191653 0.228825 [
[.08304 .17915 -6 -9 ]
[.08304 .17915 6 0 ]
[.31186 .17915 -6 -9 ]
[.31186 .17915 6 0 ]
[.54069 .17915 -6 -9 ]
[.54069 .17915 6 0 ]
[.99834 .17915 -3 -9 ]
[.99834 .17915 3 0 ]
[.75701 .00859 -24 -4.5 ]
[.75701 .00859 0 4.5 ]
[.75701 .05436 -24 -4.5 ]
[.75701 .05436 0 4.5 ]
[.75701 .10012 -24 -4.5 ]
[.75701 .10012 0 4.5 ]
[.75701 .14589 -24 -4.5 ]
[.75701 .14589 0 4.5 ]
[.75701 .23742 -18 -4.5 ]
[.75701 .23742 0 4.5 ]
[.75701 .28318 -18 -4.5 ]
[.75701 .28318 0 4.5 ]
[.75701 .32895 -18 -4.5 ]
[.75701 .32895 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .34447 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.08304 .19165 m
.08304 .1979 L
s
[(-3)] .08304 .17915 0 1 Mshowa
.31186 .19165 m
.31186 .1979 L
s
[(-2)] .31186 .17915 0 1 Mshowa
.54069 .19165 m
.54069 .1979 L
s
[(-1)] .54069 .17915 0 1 Mshowa
.99834 .19165 m
.99834 .1979 L
s
[(1)] .99834 .17915 0 1 Mshowa
.125 Mabswid
.1288 .19165 m
.1288 .1954 L
s
.17457 .19165 m
.17457 .1954 L
s
.22033 .19165 m
.22033 .1954 L
s
.2661 .19165 m
.2661 .1954 L
s
.35763 .19165 m
.35763 .1954 L
s
.40339 .19165 m
.40339 .1954 L
s
.44916 .19165 m
.44916 .1954 L
s
.49492 .19165 m
.49492 .1954 L
s
.58645 .19165 m
.58645 .1954 L
s
.63222 .19165 m
.63222 .1954 L
s
.67798 .19165 m
.67798 .1954 L
s
.72375 .19165 m
.72375 .1954 L
s
.81528 .19165 m
.81528 .1954 L
s
.86104 .19165 m
.86104 .1954 L
s
.90681 .19165 m
.90681 .1954 L
s
.95257 .19165 m
.95257 .1954 L
s
.03727 .19165 m
.03727 .1954 L
s
.25 Mabswid
0 .19165 m
1 .19165 L
s
.76951 .00859 m
.77576 .00859 L
s
[(-0.8)] .75701 .00859 1 0 Mshowa
.76951 .05436 m
.77576 .05436 L
s
[(-0.6)] .75701 .05436 1 0 Mshowa
.76951 .10012 m
.77576 .10012 L
s
[(-0.4)] .75701 .10012 1 0 Mshowa
.76951 .14589 m
.77576 .14589 L
s
[(-0.2)] .75701 .14589 1 0 Mshowa
.76951 .23742 m
.77576 .23742 L
s
[(0.2)] .75701 .23742 1 0 Mshowa
.76951 .28318 m
.77576 .28318 L
s
[(0.4)] .75701 .28318 1 0 Mshowa
.76951 .32895 m
.77576 .32895 L
s
[(0.6)] .75701 .32895 1 0 Mshowa
.125 Mabswid
.76951 .02003 m
.77326 .02003 L
s
.76951 .03148 m
.77326 .03148 L
s
.76951 .04292 m
.77326 .04292 L
s
.76951 .0658 m
.77326 .0658 L
s
.76951 .07724 m
.77326 .07724 L
s
.76951 .08868 m
.77326 .08868 L
s
.76951 .11156 m
.77326 .11156 L
s
.76951 .12301 m
.77326 .12301 L
s
.76951 .13445 m
.77326 .13445 L
s
.76951 .15733 m
.77326 .15733 L
s
.76951 .16877 m
.77326 .16877 L
s
.76951 .18021 m
.77326 .18021 L
s
.76951 .20309 m
.77326 .20309 L
s
.76951 .21454 m
.77326 .21454 L
s
.76951 .22598 m
.77326 .22598 L
s
.76951 .24886 m
.77326 .24886 L
s
.76951 .2603 m
.77326 .2603 L
s
.76951 .27174 m
.77326 .27174 L
s
.76951 .29462 m
.77326 .29462 L
s
.76951 .30607 m
.77326 .30607 L
s
.76951 .31751 m
.77326 .31751 L
s
.76951 .34039 m
.77326 .34039 L
s
.25 Mabswid
.76951 0 m
.76951 .34447 L
s
0 0 m
1 0 L
1 .34447 L
0 .34447 L
closepath
clip
newpath
.5 Mabswid
.02381 .24811 m
.02403 .24202 L
.02424 .23968 L
.02469 .23599 L
.02552 .23128 L
.02648 .22712 L
.02739 .22386 L
.03115 .21371 L
.035 .20613 L
.03916 .19954 L
.04693 .18993 L
.05442 .18281 L
.06161 .17732 L
.06927 .17261 L
.07664 .16899 L
.08448 .16599 L
.08839 .16479 L
.09202 .16384 L
.09576 .16302 L
.09929 .16239 L
.10319 .16186 L
.10672 .16152 L
.10858 .16139 L
.10959 .16134 L
.11054 .1613 L
.11135 .16127 L
.11222 .16125 L
.11271 .16124 L
.11295 .16124 L
.11318 .16123 L
.11338 .16123 L
.1136 .16123 L
.11381 .16123 L
.11405 .16123 L
.11428 .16123 L
.1145 .16123 L
.11474 .16123 L
.11487 .16123 L
.11499 .16123 L
.11523 .16124 L
.11549 .16124 L
.11597 .16125 L
.11642 .16126 L
.11689 .16127 L
.11773 .1613 L
.11871 .16134 L
.11962 .16139 L
.1217 .16153 L
.12367 .16171 L
.12555 .16191 L
Mistroke
.12908 .1624 L
.13285 .16307 L
.13635 .16384 L
.1438 .16593 L
.15171 .1689 L
.15934 .17256 L
.16668 .17695 L
.17448 .18274 L
.182 .18973 L
.18923 .19835 L
.19326 .20439 L
.19692 .21114 L
.19875 .21519 L
.20073 .22045 L
.20164 .22333 L
.2026 .2269 L
.20342 .23065 L
.20386 .23311 L
.20433 .23649 L
.20447 .23774 L
.20461 .23933 L
.20473 .24109 L
.20487 .24567 L
Mfstroke
.02381 .24818 m
.02403 .25428 L
.02424 .25661 L
.02469 .26031 L
.02552 .265 L
.02648 .26916 L
.02739 .27241 L
.03115 .28253 L
.035 .29008 L
.03916 .29664 L
.04693 .30618 L
.05442 .31324 L
.06161 .31865 L
.06927 .32327 L
.07664 .3268 L
.08448 .32969 L
.08839 .33084 L
.09202 .33173 L
.09576 .33249 L
.09929 .33306 L
.10116 .3333 L
.10319 .33353 L
.10502 .33369 L
.10672 .3338 L
.10767 .33385 L
.10853 .33389 L
.10949 .33393 L
.11002 .33394 L
.11051 .33395 L
.111 .33396 L
.11124 .33396 L
.11138 .33396 L
.11151 .33396 L
.11174 .33396 L
.11199 .33397 L
.1122 .33397 L
.11243 .33397 L
.11268 .33396 L
.11282 .33396 L
.11295 .33396 L
.1132 .33396 L
.11343 .33396 L
.11395 .33395 L
.11452 .33394 L
.11545 .33391 L
.11632 .33387 L
.1183 .33377 L
.12023 .33362 L
.1223 .33342 L
.12632 .33289 L
Mistroke
.13015 .33223 L
.13742 .33051 L
.14515 .328 L
.1526 .32485 L
.16052 .32064 L
.16814 .31559 L
.17548 .30962 L
.18329 .30169 L
.19081 .29178 L
.1943 .28599 L
.19803 .27837 L
.19987 .27374 L
.20161 .26841 L
.20317 .26213 L
.2036 .25992 L
.20405 .2571 L
.20444 .25396 L
.20466 .25145 L
.20487 .24574 L
Mfstroke
0 1 1 r
.02381 .24811 m
.02403 .24202 L
.02424 .23968 L
.02469 .23599 L
.02552 .23128 L
.02648 .22712 L
.02739 .22386 L
.03115 .21371 L
.035 .20613 L
.03916 .19954 L
.04693 .18993 L
.05442 .18281 L
.06161 .17732 L
.06927 .17261 L
.07664 .16899 L
.08448 .16599 L
.08839 .16479 L
.09202 .16384 L
.09576 .16302 L
.09929 .16239 L
.10319 .16186 L
.10672 .16152 L
.10858 .16139 L
.10959 .16134 L
.11054 .1613 L
.11135 .16127 L
.11222 .16125 L
.11271 .16124 L
.11295 .16124 L
.11318 .16123 L
.11338 .16123 L
.1136 .16123 L
.11381 .16123 L
.11405 .16123 L
.11428 .16123 L
.1145 .16123 L
.11474 .16123 L
.11487 .16123 L
.11499 .16123 L
.11523 .16124 L
.11549 .16124 L
.11597 .16125 L
.11642 .16126 L
.11689 .16127 L
.11773 .1613 L
.11871 .16134 L
.11962 .16139 L
.1217 .16153 L
.12367 .16171 L
.12555 .16191 L
.12908 .1624 L
.13285 .16307 L
.13635 .16384 L
.1438 .16593 L
.15171 .1689 L
.15934 .17256 L
.16668 .17695 L
.17448 .18274 L
.182 .18973 L
.18923 .19835 L
.19326 .20439 L
.19692 .21114 L
.19875 .21519 L
.20073 .22045 L
.20164 .22333 L
.2026 .2269 L
.20342 .23065 L
.20386 .23311 L
.20433 .23649 L
.20447 .23774 L
.20461 .23933 L
.20473 .24109 L
.20487 .24567 L
.20487 .24574 L
.20466 .25145 L
.20444 .25396 L
.20405 .2571 L
.2036 .25992 L
.20317 .26213 L
.20161 .26841 L
.19987 .27374 L
.19803 .27837 L
.1943 .28599 L
.19081 .29178 L
.18329 .30169 L
.17548 .30962 L
.16814 .31559 L
.16052 .32064 L
.1526 .32485 L
.14515 .328 L
.13742 .33051 L
.13015 .33223 L
.12632 .33289 L
.1223 .33342 L
.12023 .33362 L
.1183 .33377 L
.11632 .33387 L
.11545 .33391 L
.11452 .33394 L
.11395 .33395 L
.11343 .33396 L
.1132 .33396 L
.11295 .33396 L
.11282 .33396 L
.11268 .33396 L
.11243 .33397 L
.1122 .33397 L
.11199 .33397 L
.11174 .33396 L
.11151 .33396 L
.11138 .33396 L
.11124 .33396 L
.111 .33396 L
.11051 .33395 L
.11002 .33394 L
.10949 .33393 L
.10853 .33389 L
.10767 .33385 L
.10672 .3338 L
.10502 .33369 L
.10319 .33353 L
.10116 .3333 L
.09929 .33306 L
.09576 .33249 L
.09202 .33173 L
.08839 .33084 L
.08448 .32969 L
.07664 .3268 L
.06927 .32327 L
.06161 .31865 L
.05442 .31324 L
.04693 .30618 L
.03916 .29664 L
.035 .29008 L
.03115 .28253 L
.02739 .27241 L
.02648 .26916 L
.02552 .265 L
.02469 .26031 L
.02424 .25661 L
.02403 .25428 L
.02381 .24818 L
F
0 g
.02381 .24811 m
.02403 .24202 L
.02424 .23968 L
.02469 .23599 L
.02552 .23128 L
.02648 .22712 L
.02739 .22386 L
.03115 .21371 L
.035 .20613 L
.03916 .19954 L
.04693 .18993 L
.05442 .18281 L
.06161 .17732 L
.06927 .17261 L
.07664 .16899 L
.08448 .16599 L
.08839 .16479 L
.09202 .16384 L
.09576 .16302 L
.09929 .16239 L
.10319 .16186 L
.10672 .16152 L
.10858 .16139 L
.10959 .16134 L
.11054 .1613 L
.11135 .16127 L
.11222 .16125 L
.11271 .16124 L
.11295 .16124 L
.11318 .16123 L
.11338 .16123 L
.1136 .16123 L
.11381 .16123 L
.11405 .16123 L
.11428 .16123 L
.1145 .16123 L
.11474 .16123 L
.11487 .16123 L
.11499 .16123 L
.11523 .16124 L
.11549 .16124 L
.11597 .16125 L
.11642 .16126 L
.11689 .16127 L
.11773 .1613 L
.11871 .16134 L
.11962 .16139 L
.1217 .16153 L
.12367 .16171 L
.12555 .16191 L
Mistroke
.12908 .1624 L
.13285 .16307 L
.13635 .16384 L
.1438 .16593 L
.15171 .1689 L
.15934 .17256 L
.16668 .17695 L
.17448 .18274 L
.182 .18973 L
.18923 .19835 L
.19326 .20439 L
.19692 .21114 L
.19875 .21519 L
.20073 .22045 L
.20164 .22333 L
.2026 .2269 L
.20342 .23065 L
.20386 .23311 L
.20433 .23649 L
.20447 .23774 L
.20461 .23933 L
.20473 .24109 L
.20487 .24567 L
Mfstroke
.02381 .24818 m
.02403 .25428 L
.02424 .25661 L
.02469 .26031 L
.02552 .265 L
.02648 .26916 L
.02739 .27241 L
.03115 .28253 L
.035 .29008 L
.03916 .29664 L
.04693 .30618 L
.05442 .31324 L
.06161 .31865 L
.06927 .32327 L
.07664 .3268 L
.08448 .32969 L
.08839 .33084 L
.09202 .33173 L
.09576 .33249 L
.09929 .33306 L
.10116 .3333 L
.10319 .33353 L
.10502 .33369 L
.10672 .3338 L
.10767 .33385 L
.10853 .33389 L
.10949 .33393 L
.11002 .33394 L
.11051 .33395 L
.111 .33396 L
.11124 .33396 L
.11138 .33396 L
.11151 .33396 L
.11174 .33396 L
.11199 .33397 L
.1122 .33397 L
.11243 .33397 L
.11268 .33396 L
.11282 .33396 L
.11295 .33396 L
.1132 .33396 L
.11343 .33396 L
.11395 .33395 L
.11452 .33394 L
.11545 .33391 L
.11632 .33387 L
.1183 .33377 L
.12023 .33362 L
.1223 .33342 L
.12632 .33289 L
Mistroke
.13015 .33223 L
.13742 .33051 L
.14515 .328 L
.1526 .32485 L
.16052 .32064 L
.16814 .31559 L
.17548 .30962 L
.18329 .30169 L
.19081 .29178 L
.1943 .28599 L
.19803 .27837 L
.19987 .27374 L
.20161 .26841 L
.20317 .26213 L
.2036 .25992 L
.20405 .2571 L
.20444 .25396 L
.20466 .25145 L
.20487 .24574 L
Mfstroke
.5344 .06299 m
.53453 .05932 L
.53464 .05791 L
.5349 .05567 L
.53537 .05282 L
.53591 .05029 L
.53643 .0483 L
.53856 .0421 L
.54073 .03743 L
.54309 .03334 L
.54749 .02734 L
.55173 .02284 L
.5558 .01934 L
.56013 .01629 L
.56431 .01391 L
.56874 .01188 L
.57302 .01038 L
.57713 .00932 L
.57924 .00892 L
.5815 .00858 L
.58261 .00846 L
.5838 .00835 L
.58435 .00831 L
.58493 .00828 L
.58548 .00825 L
.58597 .00823 L
.58622 .00822 L
.5865 .00822 L
.58676 .00821 L
.58699 .00821 L
.58712 .0082 L
.58725 .0082 L
.58738 .0082 L
.58746 .0082 L
.58752 .0082 L
.58766 .0082 L
.58773 .0082 L
.5878 .0082 L
.58794 .0082 L
.58802 .0082 L
.58809 .0082 L
.58821 .0082 L
.58834 .00821 L
.58857 .00821 L
.58883 .00822 L
.5891 .00822 L
.5896 .00824 L
.59006 .00826 L
.59118 .00833 L
.59224 .00842 L
Mistroke
.59424 .00864 L
.59637 .00898 L
.59835 .00938 L
.60257 .01052 L
.60705 .01221 L
.61137 .01435 L
.61552 .01696 L
.61994 .02045 L
.6242 .02474 L
.62829 .03011 L
.63057 .03391 L
.63264 .03821 L
.63368 .04083 L
.6348 .04428 L
.63531 .0462 L
.63586 .04865 L
.63632 .05137 L
.63645 .0523 L
.63659 .05348 L
.63672 .05488 L
.63684 .05679 L
.63689 .05923 L
Mfstroke
.5344 .06303 m
.53453 .06669 L
.53464 .06809 L
.5349 .0703 L
.53537 .0731 L
.53591 .07558 L
.53643 .07752 L
.53856 .08352 L
.54073 .08799 L
.54309 .09186 L
.54749 .09748 L
.55173 .10162 L
.5558 .1048 L
.56013 .10751 L
.56431 .10958 L
.56874 .11128 L
.57096 .11196 L
.57302 .11248 L
.57513 .11293 L
.57713 .11326 L
.57819 .1134 L
.57933 .11353 L
.58037 .11363 L
.58134 .1137 L
.58187 .11373 L
.58236 .11375 L
.5829 .11377 L
.5832 .11378 L
.58348 .11378 L
.58376 .11379 L
.58389 .11379 L
.58397 .11379 L
.58405 .11379 L
.58418 .11379 L
.58431 .11379 L
.58444 .11379 L
.58457 .11379 L
.58471 .11379 L
.58479 .11379 L
.58486 .11379 L
.58513 .11379 L
.58528 .11378 L
.58545 .11378 L
.58575 .11377 L
.58627 .11376 L
.58677 .11373 L
.58789 .11367 L
.58898 .11358 L
.59015 .11346 L
.59243 .11315 L
Mistroke
.59459 .11275 L
.59871 .11172 L
.60309 .1102 L
.60731 .1083 L
.61179 .10575 L
.6161 .10268 L
.62026 .09902 L
.62468 .09415 L
.62893 .08803 L
.63091 .08443 L
.63302 .07969 L
.63406 .0768 L
.63505 .07348 L
.63593 .06955 L
.63617 .06816 L
.63643 .0664 L
.63665 .06443 L
.63677 .06285 L
.63689 .05927 L
Mfstroke
0 1 1 r
.5344 .06299 m
.53453 .05932 L
.53464 .05791 L
.5349 .05567 L
.53537 .05282 L
.53591 .05029 L
.53643 .0483 L
.53856 .0421 L
.54073 .03743 L
.54309 .03334 L
.54749 .02734 L
.55173 .02284 L
.5558 .01934 L
.56013 .01629 L
.56431 .01391 L
.56874 .01188 L
.57302 .01038 L
.57713 .00932 L
.57924 .00892 L
.5815 .00858 L
.58261 .00846 L
.5838 .00835 L
.58435 .00831 L
.58493 .00828 L
.58548 .00825 L
.58597 .00823 L
.58622 .00822 L
.5865 .00822 L
.58676 .00821 L
.58699 .00821 L
.58712 .0082 L
.58725 .0082 L
.58738 .0082 L
.58746 .0082 L
.58752 .0082 L
.58766 .0082 L
.58773 .0082 L
.5878 .0082 L
.58794 .0082 L
.58802 .0082 L
.58809 .0082 L
.58821 .0082 L
.58834 .00821 L
.58857 .00821 L
.58883 .00822 L
.5891 .00822 L
.5896 .00824 L
.59006 .00826 L
.59118 .00833 L
.59224 .00842 L
.59424 .00864 L
.59637 .00898 L
.59835 .00938 L
.60257 .01052 L
.60705 .01221 L
.61137 .01435 L
.61552 .01696 L
.61994 .02045 L
.6242 .02474 L
.62829 .03011 L
.63057 .03391 L
.63264 .03821 L
.63368 .04083 L
.6348 .04428 L
.63531 .0462 L
.63586 .04865 L
.63632 .05137 L
.63645 .0523 L
.63659 .05348 L
.63672 .05488 L
.63684 .05679 L
.63689 .05923 L
.63689 .05927 L
.63677 .06285 L
.63665 .06443 L
.63643 .0664 L
.63617 .06816 L
.63593 .06955 L
.63505 .07348 L
.63406 .0768 L
.63302 .07969 L
.63091 .08443 L
.62893 .08803 L
.62468 .09415 L
.62026 .09902 L
.6161 .10268 L
.61179 .10575 L
.60731 .1083 L
.60309 .1102 L
.59871 .11172 L
.59459 .11275 L
.59243 .11315 L
.59015 .11346 L
.58898 .11358 L
.58789 .11367 L
.58677 .11373 L
.58627 .11376 L
.58575 .11377 L
.58545 .11378 L
.58528 .11378 L
.58513 .11379 L
.58486 .11379 L
.58479 .11379 L
.58471 .11379 L
.58457 .11379 L
.58444 .11379 L
.58431 .11379 L
.58418 .11379 L
.58405 .11379 L
.58397 .11379 L
.58389 .11379 L
.58376 .11379 L
.58348 .11378 L
.5832 .11378 L
.5829 .11377 L
.58236 .11375 L
.58187 .11373 L
.58134 .1137 L
.58037 .11363 L
.57933 .11353 L
.57819 .1134 L
.57713 .11326 L
.57513 .11293 L
.57302 .11248 L
.57096 .11196 L
.56874 .11128 L
.56431 .10958 L
.56013 .10751 L
.5558 .1048 L
.55173 .10162 L
.54749 .09748 L
.54309 .09186 L
.54073 .08799 L
.53856 .08352 L
.53643 .07752 L
.53591 .07558 L
.53537 .0731 L
.5349 .0703 L
.53464 .06809 L
.53453 .06669 L
.5344 .06303 L
F
0 g
.5344 .06299 m
.53453 .05932 L
.53464 .05791 L
.5349 .05567 L
.53537 .05282 L
.53591 .05029 L
.53643 .0483 L
.53856 .0421 L
.54073 .03743 L
.54309 .03334 L
.54749 .02734 L
.55173 .02284 L
.5558 .01934 L
.56013 .01629 L
.56431 .01391 L
.56874 .01188 L
.57302 .01038 L
.57713 .00932 L
.57924 .00892 L
.5815 .00858 L
.58261 .00846 L
.5838 .00835 L
.58435 .00831 L
.58493 .00828 L
.58548 .00825 L
.58597 .00823 L
.58622 .00822 L
.5865 .00822 L
.58676 .00821 L
.58699 .00821 L
.58712 .0082 L
.58725 .0082 L
.58738 .0082 L
.58746 .0082 L
.58752 .0082 L
.58766 .0082 L
.58773 .0082 L
.5878 .0082 L
.58794 .0082 L
.58802 .0082 L
.58809 .0082 L
.58821 .0082 L
.58834 .00821 L
.58857 .00821 L
.58883 .00822 L
.5891 .00822 L
.5896 .00824 L
.59006 .00826 L
.59118 .00833 L
.59224 .00842 L
Mistroke
.59424 .00864 L
.59637 .00898 L
.59835 .00938 L
.60257 .01052 L
.60705 .01221 L
.61137 .01435 L
.61552 .01696 L
.61994 .02045 L
.6242 .02474 L
.62829 .03011 L
.63057 .03391 L
.63264 .03821 L
.63368 .04083 L
.6348 .04428 L
.63531 .0462 L
.63586 .04865 L
.63632 .05137 L
.63645 .0523 L
.63659 .05348 L
.63672 .05488 L
.63684 .05679 L
.63689 .05923 L
Mfstroke
.5344 .06303 m
.53453 .06669 L
.53464 .06809 L
.5349 .0703 L
.53537 .0731 L
.53591 .07558 L
.53643 .07752 L
.53856 .08352 L
.54073 .08799 L
.54309 .09186 L
.54749 .09748 L
.55173 .10162 L
.5558 .1048 L
.56013 .10751 L
.56431 .10958 L
.56874 .11128 L
.57096 .11196 L
.57302 .11248 L
.57513 .11293 L
.57713 .11326 L
.57819 .1134 L
.57933 .11353 L
.58037 .11363 L
.58134 .1137 L
.58187 .11373 L
.58236 .11375 L
.5829 .11377 L
.5832 .11378 L
.58348 .11378 L
.58376 .11379 L
.58389 .11379 L
.58397 .11379 L
.58405 .11379 L
.58418 .11379 L
.58431 .11379 L
.58444 .11379 L
.58457 .11379 L
.58471 .11379 L
.58479 .11379 L
.58486 .11379 L
.58513 .11379 L
.58528 .11378 L
.58545 .11378 L
.58575 .11377 L
.58627 .11376 L
.58677 .11373 L
.58789 .11367 L
.58898 .11358 L
.59015 .11346 L
.59243 .11315 L
Mistroke
.59459 .11275 L
.59871 .11172 L
.60309 .1102 L
.60731 .1083 L
.61179 .10575 L
.6161 .10268 L
.62026 .09902 L
.62468 .09415 L
.62893 .08803 L
.63091 .08443 L
.63302 .07969 L
.63406 .0768 L
.63505 .07348 L
.63593 .06955 L
.63617 .06816 L
.63643 .0664 L
.63665 .06443 L
.63677 .06285 L
.63689 .05927 L
Mfstroke
.86072 .28142 m
.86086 .2776 L
.86099 .27614 L
.86128 .27382 L
.86181 .27086 L
.86242 .26825 L
.863 .2662 L
.8654 .2598 L
.86785 .255 L
.87051 .25081 L
.87547 .24465 L
.88024 .24004 L
.88483 .23645 L
.88971 .23334 L
.89441 .2309 L
.89941 .22885 L
.90422 .22733 L
.90885 .22627 L
.91124 .22587 L
.91378 .22556 L
.91503 .22544 L
.91569 .22539 L
.91638 .22534 L
.91699 .22531 L
.91765 .22528 L
.91826 .22526 L
.91853 .22525 L
.91882 .22524 L
.91897 .22524 L
.91914 .22524 L
.91929 .22524 L
.91943 .22524 L
.91959 .22523 L
.91968 .22523 L
.91977 .22523 L
.91992 .22523 L
.92001 .22523 L
.92009 .22523 L
.92025 .22523 L
.9204 .22523 L
.92053 .22523 L
.92067 .22524 L
.92099 .22524 L
.92129 .22525 L
.92181 .22526 L
.92238 .22528 L
.92354 .22534 L
.92477 .22543 L
.9259 .22553 L
.92843 .22584 L
Mistroke
.93074 .22622 L
.93325 .22674 L
.93819 .22812 L
.94294 .22991 L
.94799 .23239 L
.95285 .23542 L
.95753 .23907 L
.96251 .244 L
.96499 .247 L
.9673 .25025 L
.96972 .2543 L
.97191 .25888 L
.97297 .26156 L
.97411 .2651 L
.97464 .26708 L
.97519 .26962 L
.97567 .27246 L
.9758 .27345 L
.97594 .27474 L
.97607 .27635 L
.97619 .27996 L
Mfstroke
.86072 .28147 m
.86086 .28528 L
.86099 .28675 L
.86128 .28906 L
.86181 .29201 L
.86242 .29462 L
.863 .29666 L
.8654 .30302 L
.86785 .30778 L
.87051 .31193 L
.87547 .31799 L
.88024 .3225 L
.88483 .32598 L
.88971 .32898 L
.89441 .33129 L
.89941 .33321 L
.90191 .33398 L
.90422 .33459 L
.90661 .33512 L
.90885 .33552 L
.91134 .33586 L
.91242 .33598 L
.9136 .33608 L
.91478 .33616 L
.91543 .3362 L
.91603 .33622 L
.9166 .33624 L
.91711 .33626 L
.9174 .33626 L
.91755 .33626 L
.91771 .33626 L
.91785 .33627 L
.918 .33627 L
.91814 .33627 L
.91827 .33627 L
.91842 .33627 L
.91857 .33627 L
.91871 .33627 L
.91884 .33626 L
.919 .33626 L
.91916 .33626 L
.91946 .33625 L
.91978 .33625 L
.92012 .33624 L
.92072 .33622 L
.92179 .33616 L
.92296 .33608 L
.9242 .33597 L
.92532 .33585 L
.92785 .33549 L
Mistroke
.93016 .33507 L
.93268 .3345 L
.93761 .33304 L
.94236 .33117 L
.94741 .32863 L
.95227 .32555 L
.95695 .32187 L
.96193 .31696 L
.96672 .3108 L
.96914 .30688 L
.97133 .30252 L
.97246 .29983 L
.97368 .29635 L
.97435 .29403 L
.97497 .29145 L
.97556 .28823 L
.97586 .28596 L
.97594 .28517 L
.97603 .28414 L
.97619 .28 L
Mfstroke
0 1 1 r
.86072 .28142 m
.86086 .2776 L
.86099 .27614 L
.86128 .27382 L
.86181 .27086 L
.86242 .26825 L
.863 .2662 L
.8654 .2598 L
.86785 .255 L
.87051 .25081 L
.87547 .24465 L
.88024 .24004 L
.88483 .23645 L
.88971 .23334 L
.89441 .2309 L
.89941 .22885 L
.90422 .22733 L
.90885 .22627 L
.91124 .22587 L
.91378 .22556 L
.91503 .22544 L
.91569 .22539 L
.91638 .22534 L
.91699 .22531 L
.91765 .22528 L
.91826 .22526 L
.91853 .22525 L
.91882 .22524 L
.91897 .22524 L
.91914 .22524 L
.91929 .22524 L
.91943 .22524 L
.91959 .22523 L
.91968 .22523 L
.91977 .22523 L
.91992 .22523 L
.92001 .22523 L
.92009 .22523 L
.92025 .22523 L
.9204 .22523 L
.92053 .22523 L
.92067 .22524 L
.92099 .22524 L
.92129 .22525 L
.92181 .22526 L
.92238 .22528 L
.92354 .22534 L
.92477 .22543 L
.9259 .22553 L
.92843 .22584 L
.93074 .22622 L
.93325 .22674 L
.93819 .22812 L
.94294 .22991 L
.94799 .23239 L
.95285 .23542 L
.95753 .23907 L
.96251 .244 L
.96499 .247 L
.9673 .25025 L
.96972 .2543 L
.97191 .25888 L
.97297 .26156 L
.97411 .2651 L
.97464 .26708 L
.97519 .26962 L
.97567 .27246 L
.9758 .27345 L
.97594 .27474 L
.97607 .27635 L
.97619 .27996 L
.97619 .28 L
.97603 .28414 L
.97594 .28517 L
.97586 .28596 L
.97556 .28823 L
.97497 .29145 L
.97435 .29403 L
.97368 .29635 L
.97246 .29983 L
.97133 .30252 L
.96914 .30688 L
.96672 .3108 L
.96193 .31696 L
.95695 .32187 L
.95227 .32555 L
.94741 .32863 L
.94236 .33117 L
.93761 .33304 L
.93268 .3345 L
.93016 .33507 L
.92785 .33549 L
.92532 .33585 L
.9242 .33597 L
.92296 .33608 L
.92179 .33616 L
.92072 .33622 L
.92012 .33624 L
.91978 .33625 L
.91946 .33625 L
.91916 .33626 L
.919 .33626 L
.91884 .33626 L
.91871 .33627 L
.91857 .33627 L
.91842 .33627 L
.91827 .33627 L
.91814 .33627 L
.918 .33627 L
.91785 .33627 L
.91771 .33626 L
.91755 .33626 L
.9174 .33626 L
.91711 .33626 L
.9166 .33624 L
.91603 .33622 L
.91543 .3362 L
.91478 .33616 L
.9136 .33608 L
.91242 .33598 L
.91134 .33586 L
.90885 .33552 L
.90661 .33512 L
.90422 .33459 L
.90191 .33398 L
.89941 .33321 L
.89441 .33129 L
.88971 .32898 L
.88483 .32598 L
.88024 .3225 L
.87547 .31799 L
.87051 .31193 L
.86785 .30778 L
.8654 .30302 L
.863 .29666 L
.86242 .29462 L
.86181 .29201 L
.86128 .28906 L
.86099 .28675 L
.86086 .28528 L
.86072 .28147 L
F
0 g
.86072 .28142 m
.86086 .2776 L
.86099 .27614 L
.86128 .27382 L
.86181 .27086 L
.86242 .26825 L
.863 .2662 L
.8654 .2598 L
.86785 .255 L
.87051 .25081 L
.87547 .24465 L
.88024 .24004 L
.88483 .23645 L
.88971 .23334 L
.89441 .2309 L
.89941 .22885 L
.90422 .22733 L
.90885 .22627 L
.91124 .22587 L
.91378 .22556 L
.91503 .22544 L
.91569 .22539 L
.91638 .22534 L
.91699 .22531 L
.91765 .22528 L
.91826 .22526 L
.91853 .22525 L
.91882 .22524 L
.91897 .22524 L
.91914 .22524 L
.91929 .22524 L
.91943 .22524 L
.91959 .22523 L
.91968 .22523 L
.91977 .22523 L
.91992 .22523 L
.92001 .22523 L
.92009 .22523 L
.92025 .22523 L
.9204 .22523 L
.92053 .22523 L
.92067 .22524 L
.92099 .22524 L
.92129 .22525 L
.92181 .22526 L
.92238 .22528 L
.92354 .22534 L
.92477 .22543 L
.9259 .22553 L
.92843 .22584 L
Mistroke
.93074 .22622 L
.93325 .22674 L
.93819 .22812 L
.94294 .22991 L
.94799 .23239 L
.95285 .23542 L
.95753 .23907 L
.96251 .244 L
.96499 .247 L
.9673 .25025 L
.96972 .2543 L
.97191 .25888 L
.97297 .26156 L
.97411 .2651 L
.97464 .26708 L
.97519 .26962 L
.97567 .27246 L
.9758 .27345 L
.97594 .27474 L
.97607 .27635 L
.97619 .27996 L
Mfstroke
.86072 .28147 m
.86086 .28528 L
.86099 .28675 L
.86128 .28906 L
.86181 .29201 L
.86242 .29462 L
.863 .29666 L
.8654 .30302 L
.86785 .30778 L
.87051 .31193 L
.87547 .31799 L
.88024 .3225 L
.88483 .32598 L
.88971 .32898 L
.89441 .33129 L
.89941 .33321 L
.90191 .33398 L
.90422 .33459 L
.90661 .33512 L
.90885 .33552 L
.91134 .33586 L
.91242 .33598 L
.9136 .33608 L
.91478 .33616 L
.91543 .3362 L
.91603 .33622 L
.9166 .33624 L
.91711 .33626 L
.9174 .33626 L
.91755 .33626 L
.91771 .33626 L
.91785 .33627 L
.918 .33627 L
.91814 .33627 L
.91827 .33627 L
.91842 .33627 L
.91857 .33627 L
.91871 .33627 L
.91884 .33626 L
.919 .33626 L
.91916 .33626 L
.91946 .33625 L
.91978 .33625 L
.92012 .33624 L
.92072 .33622 L
.92179 .33616 L
.92296 .33608 L
.9242 .33597 L
.92532 .33585 L
.92785 .33549 L
Mistroke
.93016 .33507 L
.93268 .3345 L
.93761 .33304 L
.94236 .33117 L
.94741 .32863 L
.95227 .32555 L
.95695 .32187 L
.96193 .31696 L
.96672 .3108 L
.96914 .30688 L
.97133 .30252 L
.97246 .29983 L
.97368 .29635 L
.97435 .29403 L
.97497 .29145 L
.97556 .28823 L
.97586 .28596 L
.97594 .28517 L
.97603 .28414 L
.97619 .28 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.344468 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.769512 0.228825 0.191653 0.228825 [
[.08304 .17915 -6 -9 ]
[.08304 .17915 6 0 ]
[.31186 .17915 -6 -9 ]
[.31186 .17915 6 0 ]
[.54069 .17915 -6 -9 ]
[.54069 .17915 6 0 ]
[.99834 .17915 -3 -9 ]
[.99834 .17915 3 0 ]
[.75701 .00859 -24 -4.5 ]
[.75701 .00859 0 4.5 ]
[.75701 .05436 -24 -4.5 ]
[.75701 .05436 0 4.5 ]
[.75701 .10012 -24 -4.5 ]
[.75701 .10012 0 4.5 ]
[.75701 .14589 -24 -4.5 ]
[.75701 .14589 0 4.5 ]
[.75701 .23742 -18 -4.5 ]
[.75701 .23742 0 4.5 ]
[.75701 .28318 -18 -4.5 ]
[.75701 .28318 0 4.5 ]
[.75701 .32895 -18 -4.5 ]
[.75701 .32895 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .34447 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.08304 .19165 m
.08304 .1979 L
s
[(-3)] .08304 .17915 0 1 Mshowa
.31186 .19165 m
.31186 .1979 L
s
[(-2)] .31186 .17915 0 1 Mshowa
.54069 .19165 m
.54069 .1979 L
s
[(-1)] .54069 .17915 0 1 Mshowa
.99834 .19165 m
.99834 .1979 L
s
[(1)] .99834 .17915 0 1 Mshowa
.125 Mabswid
.1288 .19165 m
.1288 .1954 L
s
.17457 .19165 m
.17457 .1954 L
s
.22033 .19165 m
.22033 .1954 L
s
.2661 .19165 m
.2661 .1954 L
s
.35763 .19165 m
.35763 .1954 L
s
.40339 .19165 m
.40339 .1954 L
s
.44916 .19165 m
.44916 .1954 L
s
.49492 .19165 m
.49492 .1954 L
s
.58645 .19165 m
.58645 .1954 L
s
.63222 .19165 m
.63222 .1954 L
s
.67798 .19165 m
.67798 .1954 L
s
.72375 .19165 m
.72375 .1954 L
s
.81528 .19165 m
.81528 .1954 L
s
.86104 .19165 m
.86104 .1954 L
s
.90681 .19165 m
.90681 .1954 L
s
.95257 .19165 m
.95257 .1954 L
s
.03727 .19165 m
.03727 .1954 L
s
.25 Mabswid
0 .19165 m
1 .19165 L
s
.76951 .00859 m
.77576 .00859 L
s
[(-0.8)] .75701 .00859 1 0 Mshowa
.76951 .05436 m
.77576 .05436 L
s
[(-0.6)] .75701 .05436 1 0 Mshowa
.76951 .10012 m
.77576 .10012 L
s
[(-0.4)] .75701 .10012 1 0 Mshowa
.76951 .14589 m
.77576 .14589 L
s
[(-0.2)] .75701 .14589 1 0 Mshowa
.76951 .23742 m
.77576 .23742 L
s
[(0.2)] .75701 .23742 1 0 Mshowa
.76951 .28318 m
.77576 .28318 L
s
[(0.4)] .75701 .28318 1 0 Mshowa
.76951 .32895 m
.77576 .32895 L
s
[(0.6)] .75701 .32895 1 0 Mshowa
.125 Mabswid
.76951 .02003 m
.77326 .02003 L
s
.76951 .03148 m
.77326 .03148 L
s
.76951 .04292 m
.77326 .04292 L
s
.76951 .0658 m
.77326 .0658 L
s
.76951 .07724 m
.77326 .07724 L
s
.76951 .08868 m
.77326 .08868 L
s
.76951 .11156 m
.77326 .11156 L
s
.76951 .12301 m
.77326 .12301 L
s
.76951 .13445 m
.77326 .13445 L
s
.76951 .15733 m
.77326 .15733 L
s
.76951 .16877 m
.77326 .16877 L
s
.76951 .18021 m
.77326 .18021 L
s
.76951 .20309 m
.77326 .20309 L
s
.76951 .21454 m
.77326 .21454 L
s
.76951 .22598 m
.77326 .22598 L
s
.76951 .24886 m
.77326 .24886 L
s
.76951 .2603 m
.77326 .2603 L
s
.76951 .27174 m
.77326 .27174 L
s
.76951 .29462 m
.77326 .29462 L
s
.76951 .30607 m
.77326 .30607 L
s
.76951 .31751 m
.77326 .31751 L
s
.76951 .34039 m
.77326 .34039 L
s
.25 Mabswid
.76951 0 m
.76951 .34447 L
s
0 0 m
1 0 L
1 .34447 L
0 .34447 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.35.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[11]= ",
 CellTags->"S5.35.1"]
}, Open  ]],

Cell["\<\
This constructs an animation of a set of regions given by a bilinear or M\
\[ODoubleDot]bius transformation. \
\>", "MathCaption",
 CellTags->{"S5.35.1", "1.15"}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", " ", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"ComplexInequalityPlot", "[", 
      RowBox[{
       RowBox[{"1", "<", 
        RowBox[{"Abs", "[", " ", 
         FractionBox[
          RowBox[{"z", "-", "a"}], 
          RowBox[{
           RowBox[{"a", " ", "z"}], "-", "1"}]], "]"}], "<", "2"}], " ", ",", 
       " ", 
       RowBox[{"{", "z", "}"}], ",", " ", 
       RowBox[{"PlotRange", "->", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "10"}], ",", "2"}], "}"}], ",", " ", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "6"}], ",", "6"}], "}"}]}], "}"}]}]}], " ", "]"}], 
     "]"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"a", ",", " ", "0", ",", " ", 
      RowBox[{"4", "/", "10"}], ",", 
      RowBox[{"1", "/", "10"}]}], "}"}]}], " ", "]"}], ";"}]], "Input",
 CellLabel->"In[12]:= ",
 CellTags->"S5.35.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 1 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.833333 0.0833333 0.5 0.0833333 [
[0 .4875 -9 -9 ]
[0 .4875 9 0 ]
[.16667 .4875 -6 -9 ]
[.16667 .4875 6 0 ]
[.33333 .4875 -6 -9 ]
[.33333 .4875 6 0 ]
[.5 .4875 -6 -9 ]
[.5 .4875 6 0 ]
[.66667 .4875 -6 -9 ]
[.66667 .4875 6 0 ]
[1 .4875 -3 -9 ]
[1 .4875 3 0 ]
[.82083 0 -12 -4.5 ]
[.82083 0 0 4.5 ]
[.82083 .16667 -12 -4.5 ]
[.82083 .16667 0 4.5 ]
[.82083 .33333 -12 -4.5 ]
[.82083 .33333 0 4.5 ]
[.82083 .66667 -6 -4.5 ]
[.82083 .66667 0 4.5 ]
[.82083 .83333 -6 -4.5 ]
[.82083 .83333 0 4.5 ]
[.82083 1 -6 -4.5 ]
[.82083 1 0 4.5 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .5 m
0 .50625 L
s
[(-10)] 0 .4875 0 1 Mshowa
.16667 .5 m
.16667 .50625 L
s
[(-8)] .16667 .4875 0 1 Mshowa
.33333 .5 m
.33333 .50625 L
s
[(-6)] .33333 .4875 0 1 Mshowa
.5 .5 m
.5 .50625 L
s
[(-4)] .5 .4875 0 1 Mshowa
.66667 .5 m
.66667 .50625 L
s
[(-2)] .66667 .4875 0 1 Mshowa
1 .5 m
1 .50625 L
s
[(2)] 1 .4875 0 1 Mshowa
.125 Mabswid
.04167 .5 m
.04167 .50375 L
s
.08333 .5 m
.08333 .50375 L
s
.125 .5 m
.125 .50375 L
s
.20833 .5 m
.20833 .50375 L
s
.25 .5 m
.25 .50375 L
s
.29167 .5 m
.29167 .50375 L
s
.375 .5 m
.375 .50375 L
s
.41667 .5 m
.41667 .50375 L
s
.45833 .5 m
.45833 .50375 L
s
.54167 .5 m
.54167 .50375 L
s
.58333 .5 m
.58333 .50375 L
s
.625 .5 m
.625 .50375 L
s
.70833 .5 m
.70833 .50375 L
s
.75 .5 m
.75 .50375 L
s
.79167 .5 m
.79167 .50375 L
s
.875 .5 m
.875 .50375 L
s
.91667 .5 m
.91667 .50375 L
s
.95833 .5 m
.95833 .50375 L
s
.25 Mabswid
0 .5 m
1 .5 L
s
.83333 0 m
.83958 0 L
s
[(-6)] .82083 0 1 0 Mshowa
.83333 .16667 m
.83958 .16667 L
s
[(-4)] .82083 .16667 1 0 Mshowa
.83333 .33333 m
.83958 .33333 L
s
[(-2)] .82083 .33333 1 0 Mshowa
.83333 .66667 m
.83958 .66667 L
s
[(2)] .82083 .66667 1 0 Mshowa
.83333 .83333 m
.83958 .83333 L
s
[(4)] .82083 .83333 1 0 Mshowa
.83333 1 m
.83958 1 L
s
[(6)] .82083 1 1 0 Mshowa
.125 Mabswid
.83333 .04167 m
.83708 .04167 L
s
.83333 .08333 m
.83708 .08333 L
s
.83333 .125 m
.83708 .125 L
s
.83333 .20833 m
.83708 .20833 L
s
.83333 .25 m
.83708 .25 L
s
.83333 .29167 m
.83708 .29167 L
s
.83333 .375 m
.83708 .375 L
s
.83333 .41667 m
.83708 .41667 L
s
.83333 .45833 m
.83708 .45833 L
s
.83333 .54167 m
.83708 .54167 L
s
.83333 .58333 m
.83708 .58333 L
s
.83333 .625 m
.83708 .625 L
s
.83333 .70833 m
.83708 .70833 L
s
.83333 .75 m
.83708 .75 L
s
.83333 .79167 m
.83708 .79167 L
s
.83333 .875 m
.83708 .875 L
s
.83333 .91667 m
.83708 .91667 L
s
.83333 .95833 m
.83708 .95833 L
s
.25 Mabswid
.83333 0 m
.83333 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 Mabswid
.66667 .49997 m
.66677 .49415 L
.66686 .49191 L
.66707 .48837 L
.66745 .48384 L
.66789 .47981 L
.66831 .47664 L
.67005 .4666 L
.67182 .45889 L
.67373 .45198 L
.67731 .4414 L
.68075 .43294 L
.68406 .42586 L
.68759 .41915 L
.69098 .41332 L
.69459 .40765 L
.69806 .40264 L
.7014 .39815 L
.70496 .39371 L
.70839 .3897 L
.71202 .38571 L
.71553 .3821 L
.7189 .37882 L
.72249 .37553 L
.72595 .37254 L
.72927 .36981 L
.73281 .36706 L
.73621 .36456 L
.73983 .36203 L
.74332 .35973 L
.74667 .35764 L
.75 .35566 L
s
.66667 .50003 m
.66677 .50585 L
.66686 .50809 L
.66707 .51163 L
.66745 .51616 L
.66789 .52019 L
.66831 .52336 L
.67005 .5334 L
.67182 .54111 L
.67373 .54802 L
.67731 .5586 L
.68075 .56706 L
.68406 .57414 L
.68759 .58085 L
.69098 .58668 L
.69459 .59235 L
.69806 .59736 L
.7014 .60185 L
.70496 .60629 L
.70839 .6103 L
.71202 .61429 L
.71553 .6179 L
.7189 .62118 L
.72249 .62447 L
.72595 .62746 L
.72927 .63019 L
.73281 .63294 L
.73621 .63544 L
.73983 .63797 L
.74332 .64027 L
.74667 .64236 L
.75 .64434 L
s
0 1 1 r
.66667 .49997 m
.66677 .49415 L
.66686 .49191 L
.66707 .48837 L
.66745 .48384 L
.66789 .47981 L
.66831 .47664 L
.67005 .4666 L
.67182 .45889 L
.67373 .45198 L
.67731 .4414 L
.68075 .43294 L
.68406 .42586 L
.68759 .41915 L
.69098 .41332 L
.69459 .40765 L
.69806 .40264 L
.7014 .39815 L
.70496 .39371 L
.70839 .3897 L
.71202 .38571 L
.71553 .3821 L
.7189 .37882 L
.72249 .37553 L
.72595 .37254 L
.72927 .36981 L
.73281 .36706 L
.73621 .36456 L
.73983 .36203 L
.74332 .35973 L
.74667 .35764 L
.75 .35566 L
.75 .64434 L
.74667 .64236 L
.74332 .64027 L
.73983 .63797 L
.73621 .63544 L
.73281 .63294 L
.72927 .63019 L
.72595 .62746 L
.72249 .62447 L
.7189 .62118 L
.71553 .6179 L
.71202 .61429 L
.70839 .6103 L
.70496 .60629 L
.7014 .60185 L
.69806 .59736 L
.69459 .59235 L
.69098 .58668 L
.68759 .58085 L
.68406 .57414 L
.68075 .56706 L
.67731 .5586 L
.67373 .54802 L
.67182 .54111 L
.67005 .5334 L
.66831 .52336 L
.66789 .52019 L
.66745 .51616 L
.66707 .51163 L
.66686 .50809 L
.66677 .50585 L
.66667 .50003 L
F
0 g
.66667 .49997 m
.66677 .49415 L
.66686 .49191 L
.66707 .48837 L
.66745 .48384 L
.66789 .47981 L
.66831 .47664 L
.67005 .4666 L
.67182 .45889 L
.67373 .45198 L
.67731 .4414 L
.68075 .43294 L
.68406 .42586 L
.68759 .41915 L
.69098 .41332 L
.69459 .40765 L
.69806 .40264 L
.7014 .39815 L
.70496 .39371 L
.70839 .3897 L
.71202 .38571 L
.71553 .3821 L
.7189 .37882 L
.72249 .37553 L
.72595 .37254 L
.72927 .36981 L
.73281 .36706 L
.73621 .36456 L
.73983 .36203 L
.74332 .35973 L
.74667 .35764 L
.75 .35566 L
s
.66667 .50003 m
.66677 .50585 L
.66686 .50809 L
.66707 .51163 L
.66745 .51616 L
.66789 .52019 L
.66831 .52336 L
.67005 .5334 L
.67182 .54111 L
.67373 .54802 L
.67731 .5586 L
.68075 .56706 L
.68406 .57414 L
.68759 .58085 L
.69098 .58668 L
.69459 .59235 L
.69806 .59736 L
.7014 .60185 L
.70496 .60629 L
.70839 .6103 L
.71202 .61429 L
.71553 .6179 L
.7189 .62118 L
.72249 .62447 L
.72595 .62746 L
.72927 .63019 L
.73281 .63294 L
.73621 .63544 L
.73983 .63797 L
.74332 .64027 L
.74667 .64236 L
.75 .64434 L
s
.91667 .35566 m
.92005 .35767 L
.92373 .35998 L
.9272 .36228 L
.93053 .36461 L
.93407 .36722 L
.93748 .36988 L
.94111 .37287 L
.9446 .37592 L
.94796 .37901 L
.95154 .38251 L
.95498 .38607 L
.95829 .38972 L
.96182 .39384 L
.96521 .39809 L
.96882 .40294 L
.97229 .40798 L
.97564 .41324 L
.97919 .41936 L
.98262 .42589 L
.98625 .43372 L
.98976 .44248 L
.99313 .45265 L
.99484 .45886 L
.99672 .4671 L
.99754 .47147 L
.99842 .47708 L
.99884 .48039 L
.99924 .48415 L
.99961 .48856 L
.99971 .4901 L
.99981 .49206 L
.9999 .49425 L
1 .49997 L
s
.91667 .64434 m
.92005 .64233 L
.92373 .64002 L
.9272 .63772 L
.93053 .63539 L
.93407 .63278 L
.93748 .63012 L
.94111 .62713 L
.9446 .62408 L
.94796 .62099 L
.95154 .61749 L
.95498 .61393 L
.95829 .61028 L
.96182 .60616 L
.96521 .60191 L
.96882 .59706 L
.97229 .59202 L
.97564 .58676 L
.97919 .58064 L
.98262 .57411 L
.98625 .56628 L
.98976 .55752 L
.99313 .54735 L
.99484 .54114 L
.99672 .5329 L
.99754 .52853 L
.99842 .52292 L
.99884 .51961 L
.99924 .51585 L
.99961 .51144 L
.99971 .5099 L
.99981 .50794 L
.9999 .50575 L
1 .50003 L
s
0 1 1 r
.91667 .35566 m
.92005 .35767 L
.92373 .35998 L
.9272 .36228 L
.93053 .36461 L
.93407 .36722 L
.93748 .36988 L
.94111 .37287 L
.9446 .37592 L
.94796 .37901 L
.95154 .38251 L
.95498 .38607 L
.95829 .38972 L
.96182 .39384 L
.96521 .39809 L
.96882 .40294 L
.97229 .40798 L
.97564 .41324 L
.97919 .41936 L
.98262 .42589 L
.98625 .43372 L
.98976 .44248 L
.99313 .45265 L
.99484 .45886 L
.99672 .4671 L
.99754 .47147 L
.99842 .47708 L
.99884 .48039 L
.99924 .48415 L
.99961 .48856 L
.99971 .4901 L
.99981 .49206 L
.9999 .49425 L
1 .49997 L
1 .50003 L
.9999 .50575 L
.99981 .50794 L
.99971 .5099 L
.99961 .51144 L
.99924 .51585 L
.99884 .51961 L
.99842 .52292 L
.99754 .52853 L
.99672 .5329 L
.99484 .54114 L
.99313 .54735 L
.98976 .55752 L
.98625 .56628 L
.98262 .57411 L
.97919 .58064 L
.97564 .58676 L
.97229 .59202 L
.96882 .59706 L
.96521 .60191 L
.96182 .60616 L
.95829 .61028 L
.95498 .61393 L
.95154 .61749 L
.94796 .62099 L
.9446 .62408 L
.94111 .62713 L
.93748 .63012 L
.93407 .63278 L
.93053 .63539 L
.9272 .63772 L
.92373 .64002 L
.92005 .64233 L
.91667 .64434 L
F
0 g
.91667 .35566 m
.92005 .35767 L
.92373 .35998 L
.9272 .36228 L
.93053 .36461 L
.93407 .36722 L
.93748 .36988 L
.94111 .37287 L
.9446 .37592 L
.94796 .37901 L
.95154 .38251 L
.95498 .38607 L
.95829 .38972 L
.96182 .39384 L
.96521 .39809 L
.96882 .40294 L
.97229 .40798 L
.97564 .41324 L
.97919 .41936 L
.98262 .42589 L
.98625 .43372 L
.98976 .44248 L
.99313 .45265 L
.99484 .45886 L
.99672 .4671 L
.99754 .47147 L
.99842 .47708 L
.99884 .48039 L
.99924 .48415 L
.99961 .48856 L
.99971 .4901 L
.99981 .49206 L
.9999 .49425 L
1 .49997 L
s
.91667 .64434 m
.92005 .64233 L
.92373 .64002 L
.9272 .63772 L
.93053 .63539 L
.93407 .63278 L
.93748 .63012 L
.94111 .62713 L
.9446 .62408 L
.94796 .62099 L
.95154 .61749 L
.95498 .61393 L
.95829 .61028 L
.96182 .60616 L
.96521 .60191 L
.96882 .59706 L
.97229 .59202 L
.97564 .58676 L
.97919 .58064 L
.98262 .57411 L
.98625 .56628 L
.98976 .55752 L
.99313 .54735 L
.99484 .54114 L
.99672 .5329 L
.99754 .52853 L
.99842 .52292 L
.99884 .51961 L
.99924 .51585 L
.99961 .51144 L
.99971 .5099 L
.99981 .50794 L
.9999 .50575 L
1 .50003 L
s
.75 .50003 m
.75021 .50585 L
.75039 .50808 L
.75081 .51161 L
.75157 .5161 L
.75246 .52008 L
.75329 .52319 L
.75676 .53288 L
.7603 .54013 L
.76413 .54643 L
.77129 .55563 L
.77817 .56246 L
.78479 .56774 L
.79184 .57227 L
.79863 .57576 L
.80584 .57867 L
.80945 .57984 L
.81279 .58076 L
.81623 .58156 L
.81948 .58217 L
.82307 .5827 L
.82632 .58304 L
.82803 .58316 L
.82897 .58322 L
.82984 .58326 L
.83058 .58329 L
.83138 .58331 L
.83183 .58332 L
.83206 .58332 L
.83226 .58333 L
.83245 .58333 L
.83265 .58333 L
.83285 .58333 L
.83307 .58333 L
.83328 .58333 L
.83348 .58333 L
.8337 .58333 L
.83382 .58333 L
.83393 .58333 L
.83415 .58333 L
.8344 .58333 L
.83484 .58332 L
.83525 .58331 L
.83568 .5833 L
.83646 .58327 L
.83735 .58324 L
.83819 .58319 L
.84011 .58306 L
.84193 .58289 L
.84366 .58269 L
Mistroke
.8469 .58222 L
.85037 .58157 L
.85359 .58083 L
.86045 .5788 L
.86774 .5759 L
.87476 .57231 L
.88151 .56799 L
.8887 .56228 L
.89562 .55536 L
.90227 .54682 L
.90598 .54083 L
.90935 .53414 L
.91103 .53012 L
.91286 .52491 L
.91369 .52206 L
.91458 .51853 L
.91534 .51482 L
.91574 .5124 L
.91617 .50907 L
.9163 .50783 L
.91643 .50627 L
.91654 .50453 L
.91667 .50003 L
Mfstroke
.75 .64434 m
.75676 .64804 L
.76413 .65162 L
.77106 .6546 L
.77772 .65711 L
.78481 .65945 L
.79163 .66137 L
.79889 .66307 L
.80587 .66439 L
.8126 .66537 L
.816 .66576 L
.81975 .66611 L
.8233 .66636 L
.8249 .66645 L
.82663 .66653 L
.82758 .66657 L
.82845 .6666 L
.82936 .66662 L
.83018 .66664 L
.83098 .66665 L
.83136 .66665 L
.83175 .66666 L
.83216 .66666 L
.83235 .66666 L
.83255 .66666 L
.83276 .66667 L
.83296 .66667 L
.83309 .66667 L
.8332 .66667 L
.83342 .66667 L
.83362 .66667 L
.83383 .66667 L
.83404 .66667 L
.83422 .66666 L
.83465 .66666 L
.83511 .66666 L
.83555 .66665 L
.83597 .66665 L
.8369 .66663 L
.83846 .66659 L
.84013 .66653 L
.84192 .66645 L
.84386 .66633 L
.84739 .66607 L
.85087 .66574 L
.85455 .66531 L
.86118 .66432 L
.86824 .66297 L
.87503 .66137 L
.88226 .65932 L
Mistroke
.88921 .65702 L
.89591 .65447 L
.90303 .65139 L
.90989 .64805 L
.91667 .64434 L
Mfstroke
0 1 1 r
.75 .50003 m
.75021 .50585 L
.75039 .50808 L
.75081 .51161 L
.75157 .5161 L
.75246 .52008 L
.75329 .52319 L
.75676 .53288 L
.7603 .54013 L
.76413 .54643 L
.77129 .55563 L
.77817 .56246 L
.78479 .56774 L
.79184 .57227 L
.79863 .57576 L
.80584 .57867 L
.80945 .57984 L
.81279 .58076 L
.81623 .58156 L
.81948 .58217 L
.82307 .5827 L
.82632 .58304 L
.82803 .58316 L
.82897 .58322 L
.82984 .58326 L
.83058 .58329 L
.83138 .58331 L
.83183 .58332 L
.83206 .58332 L
.83226 .58333 L
.83245 .58333 L
.83265 .58333 L
.83285 .58333 L
.83307 .58333 L
.83328 .58333 L
.83348 .58333 L
.8337 .58333 L
.83382 .58333 L
.83393 .58333 L
.83415 .58333 L
.8344 .58333 L
.83484 .58332 L
.83525 .58331 L
.83568 .5833 L
.83646 .58327 L
.83735 .58324 L
.83819 .58319 L
.84011 .58306 L
.84193 .58289 L
.84366 .58269 L
.8469 .58222 L
.85037 .58157 L
.85359 .58083 L
.86045 .5788 L
.86774 .5759 L
.87476 .57231 L
.88151 .56799 L
.8887 .56228 L
.89562 .55536 L
.90227 .54682 L
.90598 .54083 L
.90935 .53414 L
.91103 .53012 L
.91286 .52491 L
.91369 .52206 L
.91458 .51853 L
.91534 .51482 L
.91574 .5124 L
.91617 .50907 L
.9163 .50783 L
.91643 .50627 L
.91654 .50453 L
.91667 .50003 L
.91667 .64434 L
.90989 .64805 L
.90303 .65139 L
.89591 .65447 L
.88921 .65702 L
.88226 .65932 L
.87503 .66137 L
.86824 .66297 L
.86118 .66432 L
.85455 .66531 L
.85087 .66574 L
.84739 .66607 L
.84386 .66633 L
.84192 .66645 L
.84013 .66653 L
.83846 .66659 L
.8369 .66663 L
.83597 .66665 L
.83555 .66665 L
.83511 .66666 L
.83465 .66666 L
.83422 .66666 L
.83404 .66667 L
.83383 .66667 L
.83362 .66667 L
.83342 .66667 L
.8332 .66667 L
.83309 .66667 L
.83296 .66667 L
.83276 .66667 L
.83255 .66666 L
.83235 .66666 L
.83216 .66666 L
.83175 .66666 L
.83136 .66665 L
.83098 .66665 L
.83018 .66664 L
.82936 .66662 L
.82845 .6666 L
.82758 .66657 L
.82663 .66653 L
.8249 .66645 L
.8233 .66636 L
.81975 .66611 L
.816 .66576 L
.8126 .66537 L
.80587 .66439 L
.79889 .66307 L
.79163 .66137 L
.78481 .65945 L
.77772 .65711 L
.77106 .6546 L
.76413 .65162 L
.75676 .64804 L
.75 .64434 L
F
0 g
.75 .50003 m
.75021 .50585 L
.75039 .50808 L
.75081 .51161 L
.75157 .5161 L
.75246 .52008 L
.75329 .52319 L
.75676 .53288 L
.7603 .54013 L
.76413 .54643 L
.77129 .55563 L
.77817 .56246 L
.78479 .56774 L
.79184 .57227 L
.79863 .57576 L
.80584 .57867 L
.80945 .57984 L
.81279 .58076 L
.81623 .58156 L
.81948 .58217 L
.82307 .5827 L
.82632 .58304 L
.82803 .58316 L
.82897 .58322 L
.82984 .58326 L
.83058 .58329 L
.83138 .58331 L
.83183 .58332 L
.83206 .58332 L
.83226 .58333 L
.83245 .58333 L
.83265 .58333 L
.83285 .58333 L
.83307 .58333 L
.83328 .58333 L
.83348 .58333 L
.8337 .58333 L
.83382 .58333 L
.83393 .58333 L
.83415 .58333 L
.8344 .58333 L
.83484 .58332 L
.83525 .58331 L
.83568 .5833 L
.83646 .58327 L
.83735 .58324 L
.83819 .58319 L
.84011 .58306 L
.84193 .58289 L
.84366 .58269 L
Mistroke
.8469 .58222 L
.85037 .58157 L
.85359 .58083 L
.86045 .5788 L
.86774 .5759 L
.87476 .57231 L
.88151 .56799 L
.8887 .56228 L
.89562 .55536 L
.90227 .54682 L
.90598 .54083 L
.90935 .53414 L
.91103 .53012 L
.91286 .52491 L
.91369 .52206 L
.91458 .51853 L
.91534 .51482 L
.91574 .5124 L
.91617 .50907 L
.9163 .50783 L
.91643 .50627 L
.91654 .50453 L
.91667 .50003 L
Mfstroke
.75 .64434 m
.75676 .64804 L
.76413 .65162 L
.77106 .6546 L
.77772 .65711 L
.78481 .65945 L
.79163 .66137 L
.79889 .66307 L
.80587 .66439 L
.8126 .66537 L
.816 .66576 L
.81975 .66611 L
.8233 .66636 L
.8249 .66645 L
.82663 .66653 L
.82758 .66657 L
.82845 .6666 L
.82936 .66662 L
.83018 .66664 L
.83098 .66665 L
.83136 .66665 L
.83175 .66666 L
.83216 .66666 L
.83235 .66666 L
.83255 .66666 L
.83276 .66667 L
.83296 .66667 L
.83309 .66667 L
.8332 .66667 L
.83342 .66667 L
.83362 .66667 L
.83383 .66667 L
.83404 .66667 L
.83422 .66666 L
.83465 .66666 L
.83511 .66666 L
.83555 .66665 L
.83597 .66665 L
.8369 .66663 L
.83846 .66659 L
.84013 .66653 L
.84192 .66645 L
.84386 .66633 L
.84739 .66607 L
.85087 .66574 L
.85455 .66531 L
.86118 .66432 L
.86824 .66297 L
.87503 .66137 L
.88226 .65932 L
Mistroke
.88921 .65702 L
.89591 .65447 L
.90303 .65139 L
.90989 .64805 L
.91667 .64434 L
Mfstroke
.75 .35566 m
.75676 .35196 L
.76413 .34838 L
.77106 .3454 L
.77772 .34289 L
.78481 .34055 L
.79163 .33863 L
.79889 .33693 L
.80587 .33561 L
.8126 .33463 L
.816 .33424 L
.81975 .33389 L
.8233 .33364 L
.8249 .33355 L
.82663 .33347 L
.82758 .33343 L
.82845 .3334 L
.82936 .33338 L
.83018 .33336 L
.83098 .33335 L
.83136 .33335 L
.83175 .33334 L
.83216 .33334 L
.83235 .33334 L
.83255 .33334 L
.83276 .33333 L
.83296 .33333 L
.83309 .33333 L
.8332 .33333 L
.83342 .33333 L
.83362 .33333 L
.83383 .33333 L
.83404 .33333 L
.83422 .33334 L
.83465 .33334 L
.83511 .33334 L
.83555 .33335 L
.83597 .33335 L
.8369 .33337 L
.83846 .33341 L
.84013 .33347 L
.84192 .33355 L
.84386 .33367 L
.84739 .33393 L
.85087 .33426 L
.85455 .33469 L
.86118 .33568 L
.86824 .33703 L
.87503 .33863 L
.88226 .34068 L
Mistroke
.88921 .34298 L
.89591 .34553 L
.90303 .34861 L
.90989 .35195 L
.91667 .35566 L
Mfstroke
.75 .49997 m
.75021 .49415 L
.75039 .49192 L
.75081 .48839 L
.75157 .4839 L
.75246 .47992 L
.75329 .47681 L
.75676 .46712 L
.7603 .45987 L
.76413 .45357 L
.77129 .44437 L
.77817 .43754 L
.78479 .43226 L
.79184 .42773 L
.79863 .42424 L
.80584 .42133 L
.80945 .42016 L
.81279 .41924 L
.81623 .41844 L
.81948 .41783 L
.82307 .4173 L
.82632 .41696 L
.82803 .41684 L
.82897 .41678 L
.82984 .41674 L
.83058 .41671 L
.83138 .41669 L
.83183 .41668 L
.83206 .41668 L
.83226 .41667 L
.83245 .41667 L
.83265 .41667 L
.83285 .41667 L
.83307 .41667 L
.83328 .41667 L
.83348 .41667 L
.8337 .41667 L
.83382 .41667 L
.83393 .41667 L
.83415 .41667 L
.8344 .41667 L
.83484 .41668 L
.83525 .41669 L
.83568 .4167 L
.83646 .41673 L
.83735 .41676 L
.83819 .41681 L
.84011 .41694 L
.84193 .41711 L
.84366 .41731 L
Mistroke
.8469 .41778 L
.85037 .41843 L
.85359 .41917 L
.86045 .4212 L
.86774 .4241 L
.87476 .42769 L
.88151 .43201 L
.8887 .43772 L
.89562 .44464 L
.90227 .45318 L
.90598 .45917 L
.90935 .46586 L
.91103 .46988 L
.91286 .47509 L
.91369 .47794 L
.91458 .48147 L
.91534 .48518 L
.91574 .4876 L
.91617 .49093 L
.9163 .49217 L
.91643 .49373 L
.91654 .49547 L
.91667 .49997 L
Mfstroke
0 1 1 r
.75 .35566 m
.75676 .35196 L
.76413 .34838 L
.77106 .3454 L
.77772 .34289 L
.78481 .34055 L
.79163 .33863 L
.79889 .33693 L
.80587 .33561 L
.8126 .33463 L
.816 .33424 L
.81975 .33389 L
.8233 .33364 L
.8249 .33355 L
.82663 .33347 L
.82758 .33343 L
.82845 .3334 L
.82936 .33338 L
.83018 .33336 L
.83098 .33335 L
.83136 .33335 L
.83175 .33334 L
.83216 .33334 L
.83235 .33334 L
.83255 .33334 L
.83276 .33333 L
.83296 .33333 L
.83309 .33333 L
.8332 .33333 L
.83342 .33333 L
.83362 .33333 L
.83383 .33333 L
.83404 .33333 L
.83422 .33334 L
.83465 .33334 L
.83511 .33334 L
.83555 .33335 L
.83597 .33335 L
.8369 .33337 L
.83846 .33341 L
.84013 .33347 L
.84192 .33355 L
.84386 .33367 L
.84739 .33393 L
.85087 .33426 L
.85455 .33469 L
.86118 .33568 L
.86824 .33703 L
.87503 .33863 L
.88226 .34068 L
.88921 .34298 L
.89591 .34553 L
.90303 .34861 L
.90989 .35195 L
.91667 .35566 L
.91667 .49997 L
.91654 .49547 L
.91643 .49373 L
.9163 .49217 L
.91617 .49093 L
.91574 .4876 L
.91534 .48518 L
.91458 .48147 L
.91369 .47794 L
.91286 .47509 L
.91103 .46988 L
.90935 .46586 L
.90598 .45917 L
.90227 .45318 L
.89562 .44464 L
.8887 .43772 L
.88151 .43201 L
.87476 .42769 L
.86774 .4241 L
.86045 .4212 L
.85359 .41917 L
.85037 .41843 L
.8469 .41778 L
.84366 .41731 L
.84193 .41711 L
.84011 .41694 L
.83819 .41681 L
.83735 .41676 L
.83646 .41673 L
.83568 .4167 L
.83525 .41669 L
.83484 .41668 L
.8344 .41667 L
.83415 .41667 L
.83393 .41667 L
.83382 .41667 L
.8337 .41667 L
.83348 .41667 L
.83328 .41667 L
.83307 .41667 L
.83285 .41667 L
.83265 .41667 L
.83245 .41667 L
.83226 .41667 L
.83206 .41668 L
.83183 .41668 L
.83138 .41669 L
.83058 .41671 L
.82984 .41674 L
.82897 .41678 L
.82803 .41684 L
.82632 .41696 L
.82307 .4173 L
.81948 .41783 L
.81623 .41844 L
.81279 .41924 L
.80945 .42016 L
.80584 .42133 L
.79863 .42424 L
.79184 .42773 L
.78479 .43226 L
.77817 .43754 L
.77129 .44437 L
.76413 .45357 L
.7603 .45987 L
.75676 .46712 L
.75329 .47681 L
.75246 .47992 L
.75157 .4839 L
.75081 .48839 L
.75039 .49192 L
.75021 .49415 L
.75 .49997 L
F
0 g
.75 .35566 m
.75676 .35196 L
.76413 .34838 L
.77106 .3454 L
.77772 .34289 L
.78481 .34055 L
.79163 .33863 L
.79889 .33693 L
.80587 .33561 L
.8126 .33463 L
.816 .33424 L
.81975 .33389 L
.8233 .33364 L
.8249 .33355 L
.82663 .33347 L
.82758 .33343 L
.82845 .3334 L
.82936 .33338 L
.83018 .33336 L
.83098 .33335 L
.83136 .33335 L
.83175 .33334 L
.83216 .33334 L
.83235 .33334 L
.83255 .33334 L
.83276 .33333 L
.83296 .33333 L
.83309 .33333 L
.8332 .33333 L
.83342 .33333 L
.83362 .33333 L
.83383 .33333 L
.83404 .33333 L
.83422 .33334 L
.83465 .33334 L
.83511 .33334 L
.83555 .33335 L
.83597 .33335 L
.8369 .33337 L
.83846 .33341 L
.84013 .33347 L
.84192 .33355 L
.84386 .33367 L
.84739 .33393 L
.85087 .33426 L
.85455 .33469 L
.86118 .33568 L
.86824 .33703 L
.87503 .33863 L
.88226 .34068 L
Mistroke
.88921 .34298 L
.89591 .34553 L
.90303 .34861 L
.90989 .35195 L
.91667 .35566 L
Mfstroke
.75 .49997 m
.75021 .49415 L
.75039 .49192 L
.75081 .48839 L
.75157 .4839 L
.75246 .47992 L
.75329 .47681 L
.75676 .46712 L
.7603 .45987 L
.76413 .45357 L
.77129 .44437 L
.77817 .43754 L
.78479 .43226 L
.79184 .42773 L
.79863 .42424 L
.80584 .42133 L
.80945 .42016 L
.81279 .41924 L
.81623 .41844 L
.81948 .41783 L
.82307 .4173 L
.82632 .41696 L
.82803 .41684 L
.82897 .41678 L
.82984 .41674 L
.83058 .41671 L
.83138 .41669 L
.83183 .41668 L
.83206 .41668 L
.83226 .41667 L
.83245 .41667 L
.83265 .41667 L
.83285 .41667 L
.83307 .41667 L
.83328 .41667 L
.83348 .41667 L
.8337 .41667 L
.83382 .41667 L
.83393 .41667 L
.83415 .41667 L
.8344 .41667 L
.83484 .41668 L
.83525 .41669 L
.83568 .4167 L
.83646 .41673 L
.83735 .41676 L
.83819 .41681 L
.84011 .41694 L
.84193 .41711 L
.84366 .41731 L
Mistroke
.8469 .41778 L
.85037 .41843 L
.85359 .41917 L
.86045 .4212 L
.86774 .4241 L
.87476 .42769 L
.88151 .43201 L
.8887 .43772 L
.89562 .44464 L
.90227 .45318 L
.90598 .45917 L
.90935 .46586 L
.91103 .46988 L
.91286 .47509 L
.91369 .47794 L
.91458 .48147 L
.91534 .48518 L
.91574 .4876 L
.91617 .49093 L
.9163 .49217 L
.91643 .49373 L
.91654 .49547 L
.91667 .49997 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 1 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.833333 0.0833333 0.5 0.0833333 [
[0 .4875 -9 -9 ]
[0 .4875 9 0 ]
[.16667 .4875 -6 -9 ]
[.16667 .4875 6 0 ]
[.33333 .4875 -6 -9 ]
[.33333 .4875 6 0 ]
[.5 .4875 -6 -9 ]
[.5 .4875 6 0 ]
[.66667 .4875 -6 -9 ]
[.66667 .4875 6 0 ]
[1 .4875 -3 -9 ]
[1 .4875 3 0 ]
[.82083 0 -12 -4.5 ]
[.82083 0 0 4.5 ]
[.82083 .16667 -12 -4.5 ]
[.82083 .16667 0 4.5 ]
[.82083 .33333 -12 -4.5 ]
[.82083 .33333 0 4.5 ]
[.82083 .66667 -6 -4.5 ]
[.82083 .66667 0 4.5 ]
[.82083 .83333 -6 -4.5 ]
[.82083 .83333 0 4.5 ]
[.82083 1 -6 -4.5 ]
[.82083 1 0 4.5 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .5 m
0 .50625 L
s
[(-10)] 0 .4875 0 1 Mshowa
.16667 .5 m
.16667 .50625 L
s
[(-8)] .16667 .4875 0 1 Mshowa
.33333 .5 m
.33333 .50625 L
s
[(-6)] .33333 .4875 0 1 Mshowa
.5 .5 m
.5 .50625 L
s
[(-4)] .5 .4875 0 1 Mshowa
.66667 .5 m
.66667 .50625 L
s
[(-2)] .66667 .4875 0 1 Mshowa
1 .5 m
1 .50625 L
s
[(2)] 1 .4875 0 1 Mshowa
.125 Mabswid
.04167 .5 m
.04167 .50375 L
s
.08333 .5 m
.08333 .50375 L
s
.125 .5 m
.125 .50375 L
s
.20833 .5 m
.20833 .50375 L
s
.25 .5 m
.25 .50375 L
s
.29167 .5 m
.29167 .50375 L
s
.375 .5 m
.375 .50375 L
s
.41667 .5 m
.41667 .50375 L
s
.45833 .5 m
.45833 .50375 L
s
.54167 .5 m
.54167 .50375 L
s
.58333 .5 m
.58333 .50375 L
s
.625 .5 m
.625 .50375 L
s
.70833 .5 m
.70833 .50375 L
s
.75 .5 m
.75 .50375 L
s
.79167 .5 m
.79167 .50375 L
s
.875 .5 m
.875 .50375 L
s
.91667 .5 m
.91667 .50375 L
s
.95833 .5 m
.95833 .50375 L
s
.25 Mabswid
0 .5 m
1 .5 L
s
.83333 0 m
.83958 0 L
s
[(-6)] .82083 0 1 0 Mshowa
.83333 .16667 m
.83958 .16667 L
s
[(-4)] .82083 .16667 1 0 Mshowa
.83333 .33333 m
.83958 .33333 L
s
[(-2)] .82083 .33333 1 0 Mshowa
.83333 .66667 m
.83958 .66667 L
s
[(2)] .82083 .66667 1 0 Mshowa
.83333 .83333 m
.83958 .83333 L
s
[(4)] .82083 .83333 1 0 Mshowa
.83333 1 m
.83958 1 L
s
[(6)] .82083 1 1 0 Mshowa
.125 Mabswid
.83333 .04167 m
.83708 .04167 L
s
.83333 .08333 m
.83708 .08333 L
s
.83333 .125 m
.83708 .125 L
s
.83333 .20833 m
.83708 .20833 L
s
.83333 .25 m
.83708 .25 L
s
.83333 .29167 m
.83708 .29167 L
s
.83333 .375 m
.83708 .375 L
s
.83333 .41667 m
.83708 .41667 L
s
.83333 .45833 m
.83708 .45833 L
s
.83333 .54167 m
.83708 .54167 L
s
.83333 .58333 m
.83708 .58333 L
s
.83333 .625 m
.83708 .625 L
s
.83333 .70833 m
.83708 .70833 L
s
.83333 .75 m
.83708 .75 L
s
.83333 .79167 m
.83708 .79167 L
s
.83333 .875 m
.83708 .875 L
s
.83333 .91667 m
.83708 .91667 L
s
.83333 .95833 m
.83708 .95833 L
s
.25 Mabswid
.83333 0 m
.83333 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.35.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Print",
 CellTags->"S5.35.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 1 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.833333 0.0833333 0.5 0.0833333 [
[0 .4875 -9 -9 ]
[0 .4875 9 0 ]
[.16667 .4875 -6 -9 ]
[.16667 .4875 6 0 ]
[.33333 .4875 -6 -9 ]
[.33333 .4875 6 0 ]
[.5 .4875 -6 -9 ]
[.5 .4875 6 0 ]
[.66667 .4875 -6 -9 ]
[.66667 .4875 6 0 ]
[1 .4875 -3 -9 ]
[1 .4875 3 0 ]
[.82083 0 -12 -4.5 ]
[.82083 0 0 4.5 ]
[.82083 .16667 -12 -4.5 ]
[.82083 .16667 0 4.5 ]
[.82083 .33333 -12 -4.5 ]
[.82083 .33333 0 4.5 ]
[.82083 .66667 -6 -4.5 ]
[.82083 .66667 0 4.5 ]
[.82083 .83333 -6 -4.5 ]
[.82083 .83333 0 4.5 ]
[.82083 1 -6 -4.5 ]
[.82083 1 0 4.5 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .5 m
0 .50625 L
s
[(-10)] 0 .4875 0 1 Mshowa
.16667 .5 m
.16667 .50625 L
s
[(-8)] .16667 .4875 0 1 Mshowa
.33333 .5 m
.33333 .50625 L
s
[(-6)] .33333 .4875 0 1 Mshowa
.5 .5 m
.5 .50625 L
s
[(-4)] .5 .4875 0 1 Mshowa
.66667 .5 m
.66667 .50625 L
s
[(-2)] .66667 .4875 0 1 Mshowa
1 .5 m
1 .50625 L
s
[(2)] 1 .4875 0 1 Mshowa
.125 Mabswid
.04167 .5 m
.04167 .50375 L
s
.08333 .5 m
.08333 .50375 L
s
.125 .5 m
.125 .50375 L
s
.20833 .5 m
.20833 .50375 L
s
.25 .5 m
.25 .50375 L
s
.29167 .5 m
.29167 .50375 L
s
.375 .5 m
.375 .50375 L
s
.41667 .5 m
.41667 .50375 L
s
.45833 .5 m
.45833 .50375 L
s
.54167 .5 m
.54167 .50375 L
s
.58333 .5 m
.58333 .50375 L
s
.625 .5 m
.625 .50375 L
s
.70833 .5 m
.70833 .50375 L
s
.75 .5 m
.75 .50375 L
s
.79167 .5 m
.79167 .50375 L
s
.875 .5 m
.875 .50375 L
s
.91667 .5 m
.91667 .50375 L
s
.95833 .5 m
.95833 .50375 L
s
.25 Mabswid
0 .5 m
1 .5 L
s
.83333 0 m
.83958 0 L
s
[(-6)] .82083 0 1 0 Mshowa
.83333 .16667 m
.83958 .16667 L
s
[(-4)] .82083 .16667 1 0 Mshowa
.83333 .33333 m
.83958 .33333 L
s
[(-2)] .82083 .33333 1 0 Mshowa
.83333 .66667 m
.83958 .66667 L
s
[(2)] .82083 .66667 1 0 Mshowa
.83333 .83333 m
.83958 .83333 L
s
[(4)] .82083 .83333 1 0 Mshowa
.83333 1 m
.83958 1 L
s
[(6)] .82083 1 1 0 Mshowa
.125 Mabswid
.83333 .04167 m
.83708 .04167 L
s
.83333 .08333 m
.83708 .08333 L
s
.83333 .125 m
.83708 .125 L
s
.83333 .20833 m
.83708 .20833 L
s
.83333 .25 m
.83708 .25 L
s
.83333 .29167 m
.83708 .29167 L
s
.83333 .375 m
.83708 .375 L
s
.83333 .41667 m
.83708 .41667 L
s
.83333 .45833 m
.83708 .45833 L
s
.83333 .54167 m
.83708 .54167 L
s
.83333 .58333 m
.83708 .58333 L
s
.83333 .625 m
.83708 .625 L
s
.83333 .70833 m
.83708 .70833 L
s
.83333 .75 m
.83708 .75 L
s
.83333 .79167 m
.83708 .79167 L
s
.83333 .875 m
.83708 .875 L
s
.83333 .91667 m
.83708 .91667 L
s
.83333 .95833 m
.83708 .95833 L
s
.25 Mabswid
.83333 0 m
.83333 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 Mabswid
.63542 .49996 m
.63556 .49303 L
.63569 .49037 L
.63598 .48615 L
.6365 .48076 L
.6371 .47597 L
.63768 .4722 L
.64006 .4603 L
.6425 .45118 L
.64513 .44303 L
.65005 .4306 L
.65479 .42074 L
.65934 .41253 L
.66418 .40481 L
.66885 .39814 L
.67381 .39173 L
.67859 .38609 L
.68318 .3811 L
.68807 .3762 L
.69278 .37183 L
.69778 .36753 L
.7026 .36369 L
.70724 .36025 L
.71217 .35684 L
.71693 .3538 L
.72149 .35107 L
.72636 .34837 L
.73104 .34597 L
.73601 .3436 L
.74081 .3415 L
.74542 .33965 L
.75 .33795 L
s
.63542 .50004 m
.63556 .50697 L
.63569 .50963 L
.63598 .51385 L
.6365 .51924 L
.6371 .52403 L
.63768 .5278 L
.64006 .5397 L
.6425 .54882 L
.64513 .55697 L
.65005 .5694 L
.65479 .57926 L
.65934 .58747 L
.66418 .59519 L
.66885 .60186 L
.67381 .60827 L
.67859 .61391 L
.68318 .6189 L
.68807 .6238 L
.69278 .62817 L
.69778 .63247 L
.7026 .63631 L
.70724 .63975 L
.71217 .64316 L
.71693 .6462 L
.72149 .64893 L
.72636 .65163 L
.73104 .65403 L
.73601 .6564 L
.74081 .6585 L
.74542 .66035 L
.75 .66205 L
s
0 1 1 r
.63542 .49996 m
.63556 .49303 L
.63569 .49037 L
.63598 .48615 L
.6365 .48076 L
.6371 .47597 L
.63768 .4722 L
.64006 .4603 L
.6425 .45118 L
.64513 .44303 L
.65005 .4306 L
.65479 .42074 L
.65934 .41253 L
.66418 .40481 L
.66885 .39814 L
.67381 .39173 L
.67859 .38609 L
.68318 .3811 L
.68807 .3762 L
.69278 .37183 L
.69778 .36753 L
.7026 .36369 L
.70724 .36025 L
.71217 .35684 L
.71693 .3538 L
.72149 .35107 L
.72636 .34837 L
.73104 .34597 L
.73601 .3436 L
.74081 .3415 L
.74542 .33965 L
.75 .33795 L
.75 .66205 L
.74542 .66035 L
.74081 .6585 L
.73601 .6564 L
.73104 .65403 L
.72636 .65163 L
.72149 .64893 L
.71693 .6462 L
.71217 .64316 L
.70724 .63975 L
.7026 .63631 L
.69778 .63247 L
.69278 .62817 L
.68807 .6238 L
.68318 .6189 L
.67859 .61391 L
.67381 .60827 L
.66885 .60186 L
.66418 .59519 L
.65934 .58747 L
.65479 .57926 L
.65005 .5694 L
.64513 .55697 L
.6425 .54882 L
.64006 .5397 L
.63768 .5278 L
.6371 .52403 L
.6365 .51924 L
.63598 .51385 L
.63569 .50963 L
.63556 .50697 L
.63542 .50004 L
F
0 g
.63542 .49996 m
.63556 .49303 L
.63569 .49037 L
.63598 .48615 L
.6365 .48076 L
.6371 .47597 L
.63768 .4722 L
.64006 .4603 L
.6425 .45118 L
.64513 .44303 L
.65005 .4306 L
.65479 .42074 L
.65934 .41253 L
.66418 .40481 L
.66885 .39814 L
.67381 .39173 L
.67859 .38609 L
.68318 .3811 L
.68807 .3762 L
.69278 .37183 L
.69778 .36753 L
.7026 .36369 L
.70724 .36025 L
.71217 .35684 L
.71693 .3538 L
.72149 .35107 L
.72636 .34837 L
.73104 .34597 L
.73601 .3436 L
.74081 .3415 L
.74542 .33965 L
.75 .33795 L
s
.63542 .50004 m
.63556 .50697 L
.63569 .50963 L
.63598 .51385 L
.6365 .51924 L
.6371 .52403 L
.63768 .5278 L
.64006 .5397 L
.6425 .54882 L
.64513 .55697 L
.65005 .5694 L
.65479 .57926 L
.65934 .58747 L
.66418 .59519 L
.66885 .60186 L
.67381 .60827 L
.67859 .61391 L
.68318 .6189 L
.68807 .6238 L
.69278 .62817 L
.69778 .63247 L
.7026 .63631 L
.70724 .63975 L
.71217 .64316 L
.71693 .6462 L
.72149 .64893 L
.72636 .65163 L
.73104 .65403 L
.73601 .6564 L
.74081 .6585 L
.74542 .66035 L
.75 .66205 L
s
.91667 .36742 m
.9192 .36955 L
.92197 .37197 L
.92456 .37435 L
.92706 .37673 L
.92972 .37937 L
.93228 .38202 L
.935 .38497 L
.93762 .38795 L
.94014 .39095 L
.94282 .3943 L
.9454 .3977 L
.94789 .40114 L
.95053 .40501 L
.95308 .40896 L
.95578 .41344 L
.95839 .41808 L
.96089 .42288 L
.96356 .42844 L
.96613 .43433 L
.96886 .44137 L
.97149 .4492 L
.97402 .45824 L
.9753 .46374 L
.97671 .47103 L
.97732 .47488 L
.97798 .47983 L
.9783 .48274 L
.9786 .48606 L
.97887 .48993 L
.97895 .49129 L
.97902 .49302 L
.97909 .49494 L
.97917 .49997 L
s
.91667 .63258 m
.9192 .63045 L
.92197 .62803 L
.92456 .62565 L
.92706 .62327 L
.92972 .62063 L
.93228 .61798 L
.935 .61503 L
.93762 .61205 L
.94014 .60905 L
.94282 .6057 L
.9454 .6023 L
.94789 .59886 L
.95053 .59499 L
.95308 .59104 L
.95578 .58656 L
.95839 .58192 L
.96089 .57712 L
.96356 .57156 L
.96613 .56567 L
.96886 .55863 L
.97149 .5508 L
.97402 .54176 L
.9753 .53626 L
.97671 .52897 L
.97732 .52512 L
.97798 .52017 L
.9783 .51726 L
.9786 .51394 L
.97887 .51007 L
.97895 .50871 L
.97902 .50698 L
.97909 .50506 L
.97917 .50003 L
s
0 1 1 r
.91667 .36742 m
.9192 .36955 L
.92197 .37197 L
.92456 .37435 L
.92706 .37673 L
.92972 .37937 L
.93228 .38202 L
.935 .38497 L
.93762 .38795 L
.94014 .39095 L
.94282 .3943 L
.9454 .3977 L
.94789 .40114 L
.95053 .40501 L
.95308 .40896 L
.95578 .41344 L
.95839 .41808 L
.96089 .42288 L
.96356 .42844 L
.96613 .43433 L
.96886 .44137 L
.97149 .4492 L
.97402 .45824 L
.9753 .46374 L
.97671 .47103 L
.97732 .47488 L
.97798 .47983 L
.9783 .48274 L
.9786 .48606 L
.97887 .48993 L
.97895 .49129 L
.97902 .49302 L
.97909 .49494 L
.97917 .49997 L
.97917 .50003 L
.97909 .50506 L
.97902 .50698 L
.97895 .50871 L
.97887 .51007 L
.9786 .51394 L
.9783 .51726 L
.97798 .52017 L
.97732 .52512 L
.97671 .52897 L
.9753 .53626 L
.97402 .54176 L
.97149 .5508 L
.96886 .55863 L
.96613 .56567 L
.96356 .57156 L
.96089 .57712 L
.95839 .58192 L
.95578 .58656 L
.95308 .59104 L
.95053 .59499 L
.94789 .59886 L
.9454 .6023 L
.94282 .6057 L
.94014 .60905 L
.93762 .61205 L
.935 .61503 L
.93228 .61798 L
.92972 .62063 L
.92706 .62327 L
.92456 .62565 L
.92197 .62803 L
.9192 .63045 L
.91667 .63258 L
F
0 g
.91667 .36742 m
.9192 .36955 L
.92197 .37197 L
.92456 .37435 L
.92706 .37673 L
.92972 .37937 L
.93228 .38202 L
.935 .38497 L
.93762 .38795 L
.94014 .39095 L
.94282 .3943 L
.9454 .3977 L
.94789 .40114 L
.95053 .40501 L
.95308 .40896 L
.95578 .41344 L
.95839 .41808 L
.96089 .42288 L
.96356 .42844 L
.96613 .43433 L
.96886 .44137 L
.97149 .4492 L
.97402 .45824 L
.9753 .46374 L
.97671 .47103 L
.97732 .47488 L
.97798 .47983 L
.9783 .48274 L
.9786 .48606 L
.97887 .48993 L
.97895 .49129 L
.97902 .49302 L
.97909 .49494 L
.97917 .49997 L
s
.91667 .63258 m
.9192 .63045 L
.92197 .62803 L
.92456 .62565 L
.92706 .62327 L
.92972 .62063 L
.93228 .61798 L
.935 .61503 L
.93762 .61205 L
.94014 .60905 L
.94282 .6057 L
.9454 .6023 L
.94789 .59886 L
.95053 .59499 L
.95308 .59104 L
.95578 .58656 L
.95839 .58192 L
.96089 .57712 L
.96356 .57156 L
.96613 .56567 L
.96886 .55863 L
.97149 .5508 L
.97402 .54176 L
.9753 .53626 L
.97671 .52897 L
.97732 .52512 L
.97798 .52017 L
.9783 .51726 L
.9786 .51394 L
.97887 .51007 L
.97895 .50871 L
.97902 .50698 L
.97909 .50506 L
.97917 .50003 L
s
.75 .33795 m
.75676 .33572 L
.76413 .33363 L
.77106 .33199 L
.77772 .33069 L
.78481 .3296 L
.79163 .32884 L
.79536 .32854 L
.79707 .32843 L
.79889 .32833 L
.80055 .32826 L
.80143 .32822 L
.80238 .3282 L
.80325 .32817 L
.80405 .32816 L
.80485 .32814 L
.80561 .32813 L
.80583 .32813 L
.80606 .32813 L
.80627 .32813 L
.80649 .32813 L
.80669 .32813 L
.8069 .32813 L
.8071 .32813 L
.80729 .32813 L
.8074 .32813 L
.80752 .32813 L
.80774 .32813 L
.80795 .32813 L
.80815 .32813 L
.80836 .32813 L
.8086 .32813 L
.80907 .32813 L
.80987 .32814 L
.81073 .32816 L
.81229 .3282 L
.81397 .32825 L
.8158 .32834 L
.81949 .32856 L
.82292 .32884 L
.82659 .32921 L
.83385 .33019 L
.84085 .33143 L
.84758 .33291 L
.85474 .3348 L
.86164 .33694 L
.86827 .3393 L
.87533 .34216 L
.88212 .34527 L
.88934 .34898 L
Mistroke
.8963 .35297 L
.90299 .35723 L
.91012 .36228 L
.91667 .36742 L
Mfstroke
.75 .49997 m
.75021 .49415 L
.75039 .49192 L
.75081 .48839 L
.75157 .4839 L
.75246 .47992 L
.75329 .47681 L
.75676 .46712 L
.7603 .45987 L
.76413 .45357 L
.77129 .44437 L
.77817 .43754 L
.78479 .43226 L
.79184 .42773 L
.79863 .42424 L
.80584 .42133 L
.80945 .42016 L
.81279 .41924 L
.81623 .41844 L
.81948 .41783 L
.82307 .4173 L
.82632 .41696 L
.82803 .41684 L
.82897 .41678 L
.82984 .41674 L
.83058 .41671 L
.83138 .41669 L
.83183 .41668 L
.83206 .41668 L
.83226 .41667 L
.83245 .41667 L
.83265 .41667 L
.83285 .41667 L
.83307 .41667 L
.83328 .41667 L
.83348 .41667 L
.8337 .41667 L
.83382 .41667 L
.83393 .41667 L
.83415 .41667 L
.8344 .41667 L
.83484 .41668 L
.83525 .41669 L
.83568 .4167 L
.83646 .41673 L
.83735 .41676 L
.83819 .41681 L
.84011 .41694 L
.84193 .41711 L
.84366 .41731 L
Mistroke
.8469 .41778 L
.85037 .41843 L
.85359 .41917 L
.86045 .4212 L
.86774 .4241 L
.87476 .42769 L
.88151 .43201 L
.8887 .43772 L
.89562 .44464 L
.90227 .45318 L
.90598 .45917 L
.90935 .46586 L
.91103 .46988 L
.91286 .47509 L
.91369 .47794 L
.91458 .48147 L
.91534 .48518 L
.91574 .4876 L
.91617 .49093 L
.9163 .49217 L
.91643 .49373 L
.91654 .49547 L
.91667 .49997 L
Mfstroke
0 1 1 r
.75 .33795 m
.75676 .33572 L
.76413 .33363 L
.77106 .33199 L
.77772 .33069 L
.78481 .3296 L
.79163 .32884 L
.79536 .32854 L
.79707 .32843 L
.79889 .32833 L
.80055 .32826 L
.80143 .32822 L
.80238 .3282 L
.80325 .32817 L
.80405 .32816 L
.80485 .32814 L
.80561 .32813 L
.80583 .32813 L
.80606 .32813 L
.80627 .32813 L
.80649 .32813 L
.80669 .32813 L
.8069 .32813 L
.8071 .32813 L
.80729 .32813 L
.8074 .32813 L
.80752 .32813 L
.80774 .32813 L
.80795 .32813 L
.80815 .32813 L
.80836 .32813 L
.8086 .32813 L
.80907 .32813 L
.80987 .32814 L
.81073 .32816 L
.81229 .3282 L
.81397 .32825 L
.8158 .32834 L
.81949 .32856 L
.82292 .32884 L
.82659 .32921 L
.83385 .33019 L
.84085 .33143 L
.84758 .33291 L
.85474 .3348 L
.86164 .33694 L
.86827 .3393 L
.87533 .34216 L
.88212 .34527 L
.88934 .34898 L
.8963 .35297 L
.90299 .35723 L
.91012 .36228 L
.91667 .36742 L
.91667 .49997 L
.91654 .49547 L
.91643 .49373 L
.9163 .49217 L
.91617 .49093 L
.91574 .4876 L
.91534 .48518 L
.91458 .48147 L
.91369 .47794 L
.91286 .47509 L
.91103 .46988 L
.90935 .46586 L
.90598 .45917 L
.90227 .45318 L
.89562 .44464 L
.8887 .43772 L
.88151 .43201 L
.87476 .42769 L
.86774 .4241 L
.86045 .4212 L
.85359 .41917 L
.85037 .41843 L
.8469 .41778 L
.84366 .41731 L
.84193 .41711 L
.84011 .41694 L
.83819 .41681 L
.83735 .41676 L
.83646 .41673 L
.83568 .4167 L
.83525 .41669 L
.83484 .41668 L
.8344 .41667 L
.83415 .41667 L
.83393 .41667 L
.83382 .41667 L
.8337 .41667 L
.83348 .41667 L
.83328 .41667 L
.83307 .41667 L
.83285 .41667 L
.83265 .41667 L
.83245 .41667 L
.83226 .41667 L
.83206 .41668 L
.83183 .41668 L
.83138 .41669 L
.83058 .41671 L
.82984 .41674 L
.82897 .41678 L
.82803 .41684 L
.82632 .41696 L
.82307 .4173 L
.81948 .41783 L
.81623 .41844 L
.81279 .41924 L
.80945 .42016 L
.80584 .42133 L
.79863 .42424 L
.79184 .42773 L
.78479 .43226 L
.77817 .43754 L
.77129 .44437 L
.76413 .45357 L
.7603 .45987 L
.75676 .46712 L
.75329 .47681 L
.75246 .47992 L
.75157 .4839 L
.75081 .48839 L
.75039 .49192 L
.75021 .49415 L
.75 .49997 L
F
0 g
.75 .33795 m
.75676 .33572 L
.76413 .33363 L
.77106 .33199 L
.77772 .33069 L
.78481 .3296 L
.79163 .32884 L
.79536 .32854 L
.79707 .32843 L
.79889 .32833 L
.80055 .32826 L
.80143 .32822 L
.80238 .3282 L
.80325 .32817 L
.80405 .32816 L
.80485 .32814 L
.80561 .32813 L
.80583 .32813 L
.80606 .32813 L
.80627 .32813 L
.80649 .32813 L
.80669 .32813 L
.8069 .32813 L
.8071 .32813 L
.80729 .32813 L
.8074 .32813 L
.80752 .32813 L
.80774 .32813 L
.80795 .32813 L
.80815 .32813 L
.80836 .32813 L
.8086 .32813 L
.80907 .32813 L
.80987 .32814 L
.81073 .32816 L
.81229 .3282 L
.81397 .32825 L
.8158 .32834 L
.81949 .32856 L
.82292 .32884 L
.82659 .32921 L
.83385 .33019 L
.84085 .33143 L
.84758 .33291 L
.85474 .3348 L
.86164 .33694 L
.86827 .3393 L
.87533 .34216 L
.88212 .34527 L
.88934 .34898 L
Mistroke
.8963 .35297 L
.90299 .35723 L
.91012 .36228 L
.91667 .36742 L
Mfstroke
.75 .49997 m
.75021 .49415 L
.75039 .49192 L
.75081 .48839 L
.75157 .4839 L
.75246 .47992 L
.75329 .47681 L
.75676 .46712 L
.7603 .45987 L
.76413 .45357 L
.77129 .44437 L
.77817 .43754 L
.78479 .43226 L
.79184 .42773 L
.79863 .42424 L
.80584 .42133 L
.80945 .42016 L
.81279 .41924 L
.81623 .41844 L
.81948 .41783 L
.82307 .4173 L
.82632 .41696 L
.82803 .41684 L
.82897 .41678 L
.82984 .41674 L
.83058 .41671 L
.83138 .41669 L
.83183 .41668 L
.83206 .41668 L
.83226 .41667 L
.83245 .41667 L
.83265 .41667 L
.83285 .41667 L
.83307 .41667 L
.83328 .41667 L
.83348 .41667 L
.8337 .41667 L
.83382 .41667 L
.83393 .41667 L
.83415 .41667 L
.8344 .41667 L
.83484 .41668 L
.83525 .41669 L
.83568 .4167 L
.83646 .41673 L
.83735 .41676 L
.83819 .41681 L
.84011 .41694 L
.84193 .41711 L
.84366 .41731 L
Mistroke
.8469 .41778 L
.85037 .41843 L
.85359 .41917 L
.86045 .4212 L
.86774 .4241 L
.87476 .42769 L
.88151 .43201 L
.8887 .43772 L
.89562 .44464 L
.90227 .45318 L
.90598 .45917 L
.90935 .46586 L
.91103 .46988 L
.91286 .47509 L
.91369 .47794 L
.91458 .48147 L
.91534 .48518 L
.91574 .4876 L
.91617 .49093 L
.9163 .49217 L
.91643 .49373 L
.91654 .49547 L
.91667 .49997 L
Mfstroke
.75 .50003 m
.75021 .50585 L
.75039 .50808 L
.75081 .51161 L
.75157 .5161 L
.75246 .52008 L
.75329 .52319 L
.75676 .53288 L
.7603 .54013 L
.76413 .54643 L
.77129 .55563 L
.77817 .56246 L
.78479 .56774 L
.79184 .57227 L
.79863 .57576 L
.80584 .57867 L
.80945 .57984 L
.81279 .58076 L
.81623 .58156 L
.81948 .58217 L
.82307 .5827 L
.82632 .58304 L
.82803 .58316 L
.82897 .58322 L
.82984 .58326 L
.83058 .58329 L
.83138 .58331 L
.83183 .58332 L
.83206 .58332 L
.83226 .58333 L
.83245 .58333 L
.83265 .58333 L
.83285 .58333 L
.83307 .58333 L
.83328 .58333 L
.83348 .58333 L
.8337 .58333 L
.83382 .58333 L
.83393 .58333 L
.83415 .58333 L
.8344 .58333 L
.83484 .58332 L
.83525 .58331 L
.83568 .5833 L
.83646 .58327 L
.83735 .58324 L
.83819 .58319 L
.84011 .58306 L
.84193 .58289 L
.84366 .58269 L
Mistroke
.8469 .58222 L
.85037 .58157 L
.85359 .58083 L
.86045 .5788 L
.86774 .5759 L
.87476 .57231 L
.88151 .56799 L
.8887 .56228 L
.89562 .55536 L
.90227 .54682 L
.90598 .54083 L
.90935 .53414 L
.91103 .53012 L
.91286 .52491 L
.91369 .52206 L
.91458 .51853 L
.91534 .51482 L
.91574 .5124 L
.91617 .50907 L
.9163 .50783 L
.91643 .50627 L
.91654 .50453 L
.91667 .50003 L
Mfstroke
.75 .66205 m
.75676 .66428 L
.76413 .66637 L
.77106 .66801 L
.77772 .66931 L
.78481 .6704 L
.79163 .67116 L
.79536 .67146 L
.79707 .67157 L
.79889 .67167 L
.80055 .67174 L
.80143 .67178 L
.80238 .6718 L
.80325 .67183 L
.80405 .67184 L
.80485 .67186 L
.80561 .67187 L
.80583 .67187 L
.80606 .67187 L
.80627 .67187 L
.80649 .67187 L
.80669 .67187 L
.8069 .67187 L
.8071 .67187 L
.80729 .67187 L
.8074 .67187 L
.80752 .67187 L
.80774 .67187 L
.80795 .67187 L
.80815 .67187 L
.80836 .67187 L
.8086 .67187 L
.80907 .67187 L
.80987 .67186 L
.81073 .67184 L
.81229 .6718 L
.81397 .67175 L
.8158 .67166 L
.81949 .67144 L
.82292 .67116 L
.82659 .67079 L
.83385 .66981 L
.84085 .66857 L
.84758 .66709 L
.85474 .6652 L
.86164 .66306 L
.86827 .6607 L
.87533 .65784 L
.88212 .65473 L
.88934 .65102 L
Mistroke
.8963 .64703 L
.90299 .64277 L
.91012 .63772 L
.91667 .63258 L
Mfstroke
0 1 1 r
.75 .50003 m
.75021 .50585 L
.75039 .50808 L
.75081 .51161 L
.75157 .5161 L
.75246 .52008 L
.75329 .52319 L
.75676 .53288 L
.7603 .54013 L
.76413 .54643 L
.77129 .55563 L
.77817 .56246 L
.78479 .56774 L
.79184 .57227 L
.79863 .57576 L
.80584 .57867 L
.80945 .57984 L
.81279 .58076 L
.81623 .58156 L
.81948 .58217 L
.82307 .5827 L
.82632 .58304 L
.82803 .58316 L
.82897 .58322 L
.82984 .58326 L
.83058 .58329 L
.83138 .58331 L
.83183 .58332 L
.83206 .58332 L
.83226 .58333 L
.83245 .58333 L
.83265 .58333 L
.83285 .58333 L
.83307 .58333 L
.83328 .58333 L
.83348 .58333 L
.8337 .58333 L
.83382 .58333 L
.83393 .58333 L
.83415 .58333 L
.8344 .58333 L
.83484 .58332 L
.83525 .58331 L
.83568 .5833 L
.83646 .58327 L
.83735 .58324 L
.83819 .58319 L
.84011 .58306 L
.84193 .58289 L
.84366 .58269 L
.8469 .58222 L
.85037 .58157 L
.85359 .58083 L
.86045 .5788 L
.86774 .5759 L
.87476 .57231 L
.88151 .56799 L
.8887 .56228 L
.89562 .55536 L
.90227 .54682 L
.90598 .54083 L
.90935 .53414 L
.91103 .53012 L
.91286 .52491 L
.91369 .52206 L
.91458 .51853 L
.91534 .51482 L
.91574 .5124 L
.91617 .50907 L
.9163 .50783 L
.91643 .50627 L
.91654 .50453 L
.91667 .50003 L
.91667 .63258 L
.91012 .63772 L
.90299 .64277 L
.8963 .64703 L
.88934 .65102 L
.88212 .65473 L
.87533 .65784 L
.86827 .6607 L
.86164 .66306 L
.85474 .6652 L
.84758 .66709 L
.84085 .66857 L
.83385 .66981 L
.82659 .67079 L
.82292 .67116 L
.81949 .67144 L
.8158 .67166 L
.81397 .67175 L
.81229 .6718 L
.81073 .67184 L
.80987 .67186 L
.80907 .67187 L
.8086 .67187 L
.80836 .67187 L
.80815 .67187 L
.80795 .67187 L
.80774 .67187 L
.80752 .67187 L
.8074 .67187 L
.80729 .67187 L
.8071 .67187 L
.8069 .67187 L
.80669 .67187 L
.80649 .67187 L
.80627 .67187 L
.80606 .67187 L
.80583 .67187 L
.80561 .67187 L
.80485 .67186 L
.80405 .67184 L
.80325 .67183 L
.80238 .6718 L
.80143 .67178 L
.80055 .67174 L
.79889 .67167 L
.79707 .67157 L
.79536 .67146 L
.79163 .67116 L
.78481 .6704 L
.77772 .66931 L
.77106 .66801 L
.76413 .66637 L
.75676 .66428 L
.75 .66205 L
F
0 g
.75 .50003 m
.75021 .50585 L
.75039 .50808 L
.75081 .51161 L
.75157 .5161 L
.75246 .52008 L
.75329 .52319 L
.75676 .53288 L
.7603 .54013 L
.76413 .54643 L
.77129 .55563 L
.77817 .56246 L
.78479 .56774 L
.79184 .57227 L
.79863 .57576 L
.80584 .57867 L
.80945 .57984 L
.81279 .58076 L
.81623 .58156 L
.81948 .58217 L
.82307 .5827 L
.82632 .58304 L
.82803 .58316 L
.82897 .58322 L
.82984 .58326 L
.83058 .58329 L
.83138 .58331 L
.83183 .58332 L
.83206 .58332 L
.83226 .58333 L
.83245 .58333 L
.83265 .58333 L
.83285 .58333 L
.83307 .58333 L
.83328 .58333 L
.83348 .58333 L
.8337 .58333 L
.83382 .58333 L
.83393 .58333 L
.83415 .58333 L
.8344 .58333 L
.83484 .58332 L
.83525 .58331 L
.83568 .5833 L
.83646 .58327 L
.83735 .58324 L
.83819 .58319 L
.84011 .58306 L
.84193 .58289 L
.84366 .58269 L
Mistroke
.8469 .58222 L
.85037 .58157 L
.85359 .58083 L
.86045 .5788 L
.86774 .5759 L
.87476 .57231 L
.88151 .56799 L
.8887 .56228 L
.89562 .55536 L
.90227 .54682 L
.90598 .54083 L
.90935 .53414 L
.91103 .53012 L
.91286 .52491 L
.91369 .52206 L
.91458 .51853 L
.91534 .51482 L
.91574 .5124 L
.91617 .50907 L
.9163 .50783 L
.91643 .50627 L
.91654 .50453 L
.91667 .50003 L
Mfstroke
.75 .66205 m
.75676 .66428 L
.76413 .66637 L
.77106 .66801 L
.77772 .66931 L
.78481 .6704 L
.79163 .67116 L
.79536 .67146 L
.79707 .67157 L
.79889 .67167 L
.80055 .67174 L
.80143 .67178 L
.80238 .6718 L
.80325 .67183 L
.80405 .67184 L
.80485 .67186 L
.80561 .67187 L
.80583 .67187 L
.80606 .67187 L
.80627 .67187 L
.80649 .67187 L
.80669 .67187 L
.8069 .67187 L
.8071 .67187 L
.80729 .67187 L
.8074 .67187 L
.80752 .67187 L
.80774 .67187 L
.80795 .67187 L
.80815 .67187 L
.80836 .67187 L
.8086 .67187 L
.80907 .67187 L
.80987 .67186 L
.81073 .67184 L
.81229 .6718 L
.81397 .67175 L
.8158 .67166 L
.81949 .67144 L
.82292 .67116 L
.82659 .67079 L
.83385 .66981 L
.84085 .66857 L
.84758 .66709 L
.85474 .6652 L
.86164 .66306 L
.86827 .6607 L
.87533 .65784 L
.88212 .65473 L
.88934 .65102 L
Mistroke
.8963 .64703 L
.90299 .64277 L
.91012 .63772 L
.91667 .63258 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 1 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.833333 0.0833333 0.5 0.0833333 [
[0 .4875 -9 -9 ]
[0 .4875 9 0 ]
[.16667 .4875 -6 -9 ]
[.16667 .4875 6 0 ]
[.33333 .4875 -6 -9 ]
[.33333 .4875 6 0 ]
[.5 .4875 -6 -9 ]
[.5 .4875 6 0 ]
[.66667 .4875 -6 -9 ]
[.66667 .4875 6 0 ]
[1 .4875 -3 -9 ]
[1 .4875 3 0 ]
[.82083 0 -12 -4.5 ]
[.82083 0 0 4.5 ]
[.82083 .16667 -12 -4.5 ]
[.82083 .16667 0 4.5 ]
[.82083 .33333 -12 -4.5 ]
[.82083 .33333 0 4.5 ]
[.82083 .66667 -6 -4.5 ]
[.82083 .66667 0 4.5 ]
[.82083 .83333 -6 -4.5 ]
[.82083 .83333 0 4.5 ]
[.82083 1 -6 -4.5 ]
[.82083 1 0 4.5 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .5 m
0 .50625 L
s
[(-10)] 0 .4875 0 1 Mshowa
.16667 .5 m
.16667 .50625 L
s
[(-8)] .16667 .4875 0 1 Mshowa
.33333 .5 m
.33333 .50625 L
s
[(-6)] .33333 .4875 0 1 Mshowa
.5 .5 m
.5 .50625 L
s
[(-4)] .5 .4875 0 1 Mshowa
.66667 .5 m
.66667 .50625 L
s
[(-2)] .66667 .4875 0 1 Mshowa
1 .5 m
1 .50625 L
s
[(2)] 1 .4875 0 1 Mshowa
.125 Mabswid
.04167 .5 m
.04167 .50375 L
s
.08333 .5 m
.08333 .50375 L
s
.125 .5 m
.125 .50375 L
s
.20833 .5 m
.20833 .50375 L
s
.25 .5 m
.25 .50375 L
s
.29167 .5 m
.29167 .50375 L
s
.375 .5 m
.375 .50375 L
s
.41667 .5 m
.41667 .50375 L
s
.45833 .5 m
.45833 .50375 L
s
.54167 .5 m
.54167 .50375 L
s
.58333 .5 m
.58333 .50375 L
s
.625 .5 m
.625 .50375 L
s
.70833 .5 m
.70833 .50375 L
s
.75 .5 m
.75 .50375 L
s
.79167 .5 m
.79167 .50375 L
s
.875 .5 m
.875 .50375 L
s
.91667 .5 m
.91667 .50375 L
s
.95833 .5 m
.95833 .50375 L
s
.25 Mabswid
0 .5 m
1 .5 L
s
.83333 0 m
.83958 0 L
s
[(-6)] .82083 0 1 0 Mshowa
.83333 .16667 m
.83958 .16667 L
s
[(-4)] .82083 .16667 1 0 Mshowa
.83333 .33333 m
.83958 .33333 L
s
[(-2)] .82083 .33333 1 0 Mshowa
.83333 .66667 m
.83958 .66667 L
s
[(2)] .82083 .66667 1 0 Mshowa
.83333 .83333 m
.83958 .83333 L
s
[(4)] .82083 .83333 1 0 Mshowa
.83333 1 m
.83958 1 L
s
[(6)] .82083 1 1 0 Mshowa
.125 Mabswid
.83333 .04167 m
.83708 .04167 L
s
.83333 .08333 m
.83708 .08333 L
s
.83333 .125 m
.83708 .125 L
s
.83333 .20833 m
.83708 .20833 L
s
.83333 .25 m
.83708 .25 L
s
.83333 .29167 m
.83708 .29167 L
s
.83333 .375 m
.83708 .375 L
s
.83333 .41667 m
.83708 .41667 L
s
.83333 .45833 m
.83708 .45833 L
s
.83333 .54167 m
.83708 .54167 L
s
.83333 .58333 m
.83708 .58333 L
s
.83333 .625 m
.83708 .625 L
s
.83333 .70833 m
.83708 .70833 L
s
.83333 .75 m
.83708 .75 L
s
.83333 .79167 m
.83708 .79167 L
s
.83333 .875 m
.83708 .875 L
s
.83333 .91667 m
.83708 .91667 L
s
.83333 .95833 m
.83708 .95833 L
s
.25 Mabswid
.83333 0 m
.83333 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.35.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Print",
 CellTags->"S5.35.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 1 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.833333 0.0833333 0.5 0.0833333 [
[0 .4875 -9 -9 ]
[0 .4875 9 0 ]
[.16667 .4875 -6 -9 ]
[.16667 .4875 6 0 ]
[.33333 .4875 -6 -9 ]
[.33333 .4875 6 0 ]
[.5 .4875 -6 -9 ]
[.5 .4875 6 0 ]
[.66667 .4875 -6 -9 ]
[.66667 .4875 6 0 ]
[1 .4875 -3 -9 ]
[1 .4875 3 0 ]
[.82083 0 -12 -4.5 ]
[.82083 0 0 4.5 ]
[.82083 .16667 -12 -4.5 ]
[.82083 .16667 0 4.5 ]
[.82083 .33333 -12 -4.5 ]
[.82083 .33333 0 4.5 ]
[.82083 .66667 -6 -4.5 ]
[.82083 .66667 0 4.5 ]
[.82083 .83333 -6 -4.5 ]
[.82083 .83333 0 4.5 ]
[.82083 1 -6 -4.5 ]
[.82083 1 0 4.5 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .5 m
0 .50625 L
s
[(-10)] 0 .4875 0 1 Mshowa
.16667 .5 m
.16667 .50625 L
s
[(-8)] .16667 .4875 0 1 Mshowa
.33333 .5 m
.33333 .50625 L
s
[(-6)] .33333 .4875 0 1 Mshowa
.5 .5 m
.5 .50625 L
s
[(-4)] .5 .4875 0 1 Mshowa
.66667 .5 m
.66667 .50625 L
s
[(-2)] .66667 .4875 0 1 Mshowa
1 .5 m
1 .50625 L
s
[(2)] 1 .4875 0 1 Mshowa
.125 Mabswid
.04167 .5 m
.04167 .50375 L
s
.08333 .5 m
.08333 .50375 L
s
.125 .5 m
.125 .50375 L
s
.20833 .5 m
.20833 .50375 L
s
.25 .5 m
.25 .50375 L
s
.29167 .5 m
.29167 .50375 L
s
.375 .5 m
.375 .50375 L
s
.41667 .5 m
.41667 .50375 L
s
.45833 .5 m
.45833 .50375 L
s
.54167 .5 m
.54167 .50375 L
s
.58333 .5 m
.58333 .50375 L
s
.625 .5 m
.625 .50375 L
s
.70833 .5 m
.70833 .50375 L
s
.75 .5 m
.75 .50375 L
s
.79167 .5 m
.79167 .50375 L
s
.875 .5 m
.875 .50375 L
s
.91667 .5 m
.91667 .50375 L
s
.95833 .5 m
.95833 .50375 L
s
.25 Mabswid
0 .5 m
1 .5 L
s
.83333 0 m
.83958 0 L
s
[(-6)] .82083 0 1 0 Mshowa
.83333 .16667 m
.83958 .16667 L
s
[(-4)] .82083 .16667 1 0 Mshowa
.83333 .33333 m
.83958 .33333 L
s
[(-2)] .82083 .33333 1 0 Mshowa
.83333 .66667 m
.83958 .66667 L
s
[(2)] .82083 .66667 1 0 Mshowa
.83333 .83333 m
.83958 .83333 L
s
[(4)] .82083 .83333 1 0 Mshowa
.83333 1 m
.83958 1 L
s
[(6)] .82083 1 1 0 Mshowa
.125 Mabswid
.83333 .04167 m
.83708 .04167 L
s
.83333 .08333 m
.83708 .08333 L
s
.83333 .125 m
.83708 .125 L
s
.83333 .20833 m
.83708 .20833 L
s
.83333 .25 m
.83708 .25 L
s
.83333 .29167 m
.83708 .29167 L
s
.83333 .375 m
.83708 .375 L
s
.83333 .41667 m
.83708 .41667 L
s
.83333 .45833 m
.83708 .45833 L
s
.83333 .54167 m
.83708 .54167 L
s
.83333 .58333 m
.83708 .58333 L
s
.83333 .625 m
.83708 .625 L
s
.83333 .70833 m
.83708 .70833 L
s
.83333 .75 m
.83708 .75 L
s
.83333 .79167 m
.83708 .79167 L
s
.83333 .875 m
.83708 .875 L
s
.83333 .91667 m
.83708 .91667 L
s
.83333 .95833 m
.83708 .95833 L
s
.25 Mabswid
.83333 0 m
.83333 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 Mabswid
.58333 .49995 m
.58354 .49115 L
.58373 .48777 L
.58415 .48242 L
.5849 .47559 L
.58579 .46952 L
.58662 .46474 L
.59009 .4497 L
.59363 .43822 L
.59747 .42799 L
.60462 .4125 L
.61151 .40031 L
.61813 .39025 L
.62518 .38088 L
.63196 .37288 L
.63918 .36526 L
.64613 .35866 L
.65281 .35289 L
.65992 .34732 L
.66677 .34244 L
.67405 .33774 L
.68106 .33363 L
.68781 .33005 L
.69498 .3266 L
.70189 .32362 L
.70854 .32106 L
.71561 .31863 L
.72242 .31659 L
.72966 .31471 L
.73663 .31319 L
.74334 .31198 L
.75 .31102 L
s
.58333 .50005 m
.58354 .50885 L
.58373 .51223 L
.58415 .51758 L
.5849 .52441 L
.58579 .53048 L
.58662 .53526 L
.59009 .5503 L
.59363 .56178 L
.59747 .57201 L
.60462 .5875 L
.61151 .59969 L
.61813 .60975 L
.62518 .61912 L
.63196 .62712 L
.63918 .63474 L
.64613 .64134 L
.65281 .64711 L
.65992 .65268 L
.66677 .65756 L
.67405 .66226 L
.68106 .66637 L
.68781 .66995 L
.69498 .6734 L
.70189 .67638 L
.70854 .67894 L
.71561 .68137 L
.72242 .68341 L
.72966 .68529 L
.73663 .68681 L
.74334 .68802 L
.75 .68898 L
s
0 1 1 r
.58333 .49995 m
.58354 .49115 L
.58373 .48777 L
.58415 .48242 L
.5849 .47559 L
.58579 .46952 L
.58662 .46474 L
.59009 .4497 L
.59363 .43822 L
.59747 .42799 L
.60462 .4125 L
.61151 .40031 L
.61813 .39025 L
.62518 .38088 L
.63196 .37288 L
.63918 .36526 L
.64613 .35866 L
.65281 .35289 L
.65992 .34732 L
.66677 .34244 L
.67405 .33774 L
.68106 .33363 L
.68781 .33005 L
.69498 .3266 L
.70189 .32362 L
.70854 .32106 L
.71561 .31863 L
.72242 .31659 L
.72966 .31471 L
.73663 .31319 L
.74334 .31198 L
.75 .31102 L
.75 .68898 L
.74334 .68802 L
.73663 .68681 L
.72966 .68529 L
.72242 .68341 L
.71561 .68137 L
.70854 .67894 L
.70189 .67638 L
.69498 .6734 L
.68781 .66995 L
.68106 .66637 L
.67405 .66226 L
.66677 .65756 L
.65992 .65268 L
.65281 .64711 L
.64613 .64134 L
.63918 .63474 L
.63196 .62712 L
.62518 .61912 L
.61813 .60975 L
.61151 .59969 L
.60462 .5875 L
.59747 .57201 L
.59363 .56178 L
.59009 .5503 L
.58662 .53526 L
.58579 .53048 L
.5849 .52441 L
.58415 .51758 L
.58373 .51223 L
.58354 .50885 L
.58333 .50005 L
F
0 g
.58333 .49995 m
.58354 .49115 L
.58373 .48777 L
.58415 .48242 L
.5849 .47559 L
.58579 .46952 L
.58662 .46474 L
.59009 .4497 L
.59363 .43822 L
.59747 .42799 L
.60462 .4125 L
.61151 .40031 L
.61813 .39025 L
.62518 .38088 L
.63196 .37288 L
.63918 .36526 L
.64613 .35866 L
.65281 .35289 L
.65992 .34732 L
.66677 .34244 L
.67405 .33774 L
.68106 .33363 L
.68781 .33005 L
.69498 .3266 L
.70189 .32362 L
.70854 .32106 L
.71561 .31863 L
.72242 .31659 L
.72966 .31471 L
.73663 .31319 L
.74334 .31198 L
.75 .31102 L
s
.58333 .50005 m
.58354 .50885 L
.58373 .51223 L
.58415 .51758 L
.5849 .52441 L
.58579 .53048 L
.58662 .53526 L
.59009 .5503 L
.59363 .56178 L
.59747 .57201 L
.60462 .5875 L
.61151 .59969 L
.61813 .60975 L
.62518 .61912 L
.63196 .62712 L
.63918 .63474 L
.64613 .64134 L
.65281 .64711 L
.65992 .65268 L
.66677 .65756 L
.67405 .66226 L
.68106 .66637 L
.68781 .66995 L
.69498 .6734 L
.70189 .67638 L
.70854 .67894 L
.71561 .68137 L
.72242 .68341 L
.72966 .68529 L
.73663 .68681 L
.74334 .68802 L
.75 .68898 L
s
.91667 .37401 m
.9186 .37624 L
.92071 .37874 L
.92268 .38118 L
.92459 .38361 L
.92661 .38628 L
.92856 .38895 L
.93063 .39189 L
.93263 .39485 L
.93455 .39781 L
.93659 .40109 L
.93856 .40441 L
.94045 .40775 L
.94247 .41148 L
.94441 .41528 L
.94647 .41956 L
.94845 .42397 L
.95036 .42852 L
.9524 .43376 L
.95435 .43929 L
.95643 .44586 L
.95843 .45315 L
.96036 .46154 L
.96134 .46663 L
.96241 .47335 L
.96288 .4769 L
.96338 .48146 L
.96362 .48414 L
.96385 .48719 L
.96406 .49075 L
.96412 .492 L
.96418 .49359 L
.96423 .49535 L
.96429 .49997 L
s
.91667 .62599 m
.9186 .62376 L
.92071 .62126 L
.92268 .61882 L
.92459 .61639 L
.92661 .61372 L
.92856 .61105 L
.93063 .60811 L
.93263 .60515 L
.93455 .60219 L
.93659 .59891 L
.93856 .59559 L
.94045 .59225 L
.94247 .58852 L
.94441 .58472 L
.94647 .58044 L
.94845 .57603 L
.95036 .57148 L
.9524 .56624 L
.95435 .56071 L
.95643 .55414 L
.95843 .54685 L
.96036 .53846 L
.96134 .53337 L
.96241 .52665 L
.96288 .5231 L
.96338 .51854 L
.96362 .51586 L
.96385 .51281 L
.96406 .50925 L
.96412 .508 L
.96418 .50641 L
.96423 .50465 L
.96429 .50003 L
s
0 1 1 r
.91667 .37401 m
.9186 .37624 L
.92071 .37874 L
.92268 .38118 L
.92459 .38361 L
.92661 .38628 L
.92856 .38895 L
.93063 .39189 L
.93263 .39485 L
.93455 .39781 L
.93659 .40109 L
.93856 .40441 L
.94045 .40775 L
.94247 .41148 L
.94441 .41528 L
.94647 .41956 L
.94845 .42397 L
.95036 .42852 L
.9524 .43376 L
.95435 .43929 L
.95643 .44586 L
.95843 .45315 L
.96036 .46154 L
.96134 .46663 L
.96241 .47335 L
.96288 .4769 L
.96338 .48146 L
.96362 .48414 L
.96385 .48719 L
.96406 .49075 L
.96412 .492 L
.96418 .49359 L
.96423 .49535 L
.96429 .49997 L
.96429 .50003 L
.96423 .50465 L
.96418 .50641 L
.96412 .508 L
.96406 .50925 L
.96385 .51281 L
.96362 .51586 L
.96338 .51854 L
.96288 .5231 L
.96241 .52665 L
.96134 .53337 L
.96036 .53846 L
.95843 .54685 L
.95643 .55414 L
.95435 .56071 L
.9524 .56624 L
.95036 .57148 L
.94845 .57603 L
.94647 .58044 L
.94441 .58472 L
.94247 .58852 L
.94045 .59225 L
.93856 .59559 L
.93659 .59891 L
.93455 .60219 L
.93263 .60515 L
.93063 .60811 L
.92856 .61105 L
.92661 .61372 L
.92459 .61639 L
.92268 .61882 L
.92071 .62126 L
.9186 .62376 L
.91667 .62599 L
F
0 g
.91667 .37401 m
.9186 .37624 L
.92071 .37874 L
.92268 .38118 L
.92459 .38361 L
.92661 .38628 L
.92856 .38895 L
.93063 .39189 L
.93263 .39485 L
.93455 .39781 L
.93659 .40109 L
.93856 .40441 L
.94045 .40775 L
.94247 .41148 L
.94441 .41528 L
.94647 .41956 L
.94845 .42397 L
.95036 .42852 L
.9524 .43376 L
.95435 .43929 L
.95643 .44586 L
.95843 .45315 L
.96036 .46154 L
.96134 .46663 L
.96241 .47335 L
.96288 .4769 L
.96338 .48146 L
.96362 .48414 L
.96385 .48719 L
.96406 .49075 L
.96412 .492 L
.96418 .49359 L
.96423 .49535 L
.96429 .49997 L
s
.91667 .62599 m
.9186 .62376 L
.92071 .62126 L
.92268 .61882 L
.92459 .61639 L
.92661 .61372 L
.92856 .61105 L
.93063 .60811 L
.93263 .60515 L
.93455 .60219 L
.93659 .59891 L
.93856 .59559 L
.94045 .59225 L
.94247 .58852 L
.94441 .58472 L
.94647 .58044 L
.94845 .57603 L
.95036 .57148 L
.9524 .56624 L
.95435 .56071 L
.95643 .55414 L
.95843 .54685 L
.96036 .53846 L
.96134 .53337 L
.96241 .52665 L
.96288 .5231 L
.96338 .51854 L
.96362 .51586 L
.96385 .51281 L
.96406 .50925 L
.96412 .508 L
.96418 .50641 L
.96423 .50465 L
.96429 .50003 L
s
.75 .31102 m
.75329 .31063 L
.75676 .31029 L
.76058 .30998 L
.76244 .30986 L
.76413 .30977 L
.76568 .3097 L
.76735 .30963 L
.76827 .3096 L
.76912 .30958 L
.77 .30956 L
.77079 .30955 L
.77161 .30954 L
.77206 .30953 L
.77249 .30953 L
.77268 .30953 L
.77288 .30953 L
.77305 .30953 L
.77324 .30952 L
.77347 .30952 L
.77368 .30952 L
.77388 .30952 L
.77407 .30952 L
.77428 .30952 L
.7745 .30953 L
.77472 .30953 L
.77491 .30953 L
.77538 .30953 L
.77583 .30953 L
.77671 .30955 L
.77768 .30956 L
.77933 .3096 L
.78114 .30966 L
.78304 .30975 L
.78482 .30984 L
.78835 .31008 L
.79159 .31036 L
.79852 .31113 L
.80519 .31213 L
.81229 .31345 L
.81912 .31499 L
.82638 .31692 L
.83338 .31908 L
.84011 .32144 L
.84727 .32426 L
.85417 .32731 L
.8608 .33055 L
.86786 .33436 L
.87465 .33841 L
.88188 .34315 L
Mistroke
.88883 .34818 L
.89553 .35349 L
.90265 .35971 L
.90951 .36633 L
.91667 .37401 L
Mfstroke
.75 .49997 m
.75021 .49415 L
.75039 .49192 L
.75081 .48839 L
.75157 .4839 L
.75246 .47992 L
.75329 .47681 L
.75676 .46712 L
.7603 .45987 L
.76413 .45357 L
.77129 .44437 L
.77817 .43754 L
.78479 .43226 L
.79184 .42773 L
.79863 .42424 L
.80584 .42133 L
.80945 .42016 L
.81279 .41924 L
.81623 .41844 L
.81948 .41783 L
.82307 .4173 L
.82632 .41696 L
.82803 .41684 L
.82897 .41678 L
.82984 .41674 L
.83058 .41671 L
.83138 .41669 L
.83183 .41668 L
.83206 .41668 L
.83226 .41667 L
.83245 .41667 L
.83265 .41667 L
.83285 .41667 L
.83307 .41667 L
.83328 .41667 L
.83348 .41667 L
.8337 .41667 L
.83382 .41667 L
.83393 .41667 L
.83415 .41667 L
.8344 .41667 L
.83484 .41668 L
.83525 .41669 L
.83568 .4167 L
.83646 .41673 L
.83735 .41676 L
.83819 .41681 L
.84011 .41694 L
.84193 .41711 L
.84366 .41731 L
Mistroke
.8469 .41778 L
.85037 .41843 L
.85359 .41917 L
.86045 .4212 L
.86774 .4241 L
.87476 .42769 L
.88151 .43201 L
.8887 .43772 L
.89562 .44464 L
.90227 .45318 L
.90598 .45917 L
.90935 .46586 L
.91103 .46988 L
.91286 .47509 L
.91369 .47794 L
.91458 .48147 L
.91534 .48518 L
.91574 .4876 L
.91617 .49093 L
.9163 .49217 L
.91643 .49373 L
.91654 .49547 L
.91667 .49997 L
Mfstroke
0 1 1 r
.75 .31102 m
.75329 .31063 L
.75676 .31029 L
.76058 .30998 L
.76244 .30986 L
.76413 .30977 L
.76568 .3097 L
.76735 .30963 L
.76827 .3096 L
.76912 .30958 L
.77 .30956 L
.77079 .30955 L
.77161 .30954 L
.77206 .30953 L
.77249 .30953 L
.77268 .30953 L
.77288 .30953 L
.77305 .30953 L
.77324 .30952 L
.77347 .30952 L
.77368 .30952 L
.77388 .30952 L
.77407 .30952 L
.77428 .30952 L
.7745 .30953 L
.77472 .30953 L
.77491 .30953 L
.77538 .30953 L
.77583 .30953 L
.77671 .30955 L
.77768 .30956 L
.77933 .3096 L
.78114 .30966 L
.78304 .30975 L
.78482 .30984 L
.78835 .31008 L
.79159 .31036 L
.79852 .31113 L
.80519 .31213 L
.81229 .31345 L
.81912 .31499 L
.82638 .31692 L
.83338 .31908 L
.84011 .32144 L
.84727 .32426 L
.85417 .32731 L
.8608 .33055 L
.86786 .33436 L
.87465 .33841 L
.88188 .34315 L
.88883 .34818 L
.89553 .35349 L
.90265 .35971 L
.90951 .36633 L
.91667 .37401 L
.91667 .49997 L
.91654 .49547 L
.91643 .49373 L
.9163 .49217 L
.91617 .49093 L
.91574 .4876 L
.91534 .48518 L
.91458 .48147 L
.91369 .47794 L
.91286 .47509 L
.91103 .46988 L
.90935 .46586 L
.90598 .45917 L
.90227 .45318 L
.89562 .44464 L
.8887 .43772 L
.88151 .43201 L
.87476 .42769 L
.86774 .4241 L
.86045 .4212 L
.85359 .41917 L
.85037 .41843 L
.8469 .41778 L
.84366 .41731 L
.84193 .41711 L
.84011 .41694 L
.83819 .41681 L
.83735 .41676 L
.83646 .41673 L
.83568 .4167 L
.83525 .41669 L
.83484 .41668 L
.8344 .41667 L
.83415 .41667 L
.83393 .41667 L
.83382 .41667 L
.8337 .41667 L
.83348 .41667 L
.83328 .41667 L
.83307 .41667 L
.83285 .41667 L
.83265 .41667 L
.83245 .41667 L
.83226 .41667 L
.83206 .41668 L
.83183 .41668 L
.83138 .41669 L
.83058 .41671 L
.82984 .41674 L
.82897 .41678 L
.82803 .41684 L
.82632 .41696 L
.82307 .4173 L
.81948 .41783 L
.81623 .41844 L
.81279 .41924 L
.80945 .42016 L
.80584 .42133 L
.79863 .42424 L
.79184 .42773 L
.78479 .43226 L
.77817 .43754 L
.77129 .44437 L
.76413 .45357 L
.7603 .45987 L
.75676 .46712 L
.75329 .47681 L
.75246 .47992 L
.75157 .4839 L
.75081 .48839 L
.75039 .49192 L
.75021 .49415 L
.75 .49997 L
F
0 g
.75 .31102 m
.75329 .31063 L
.75676 .31029 L
.76058 .30998 L
.76244 .30986 L
.76413 .30977 L
.76568 .3097 L
.76735 .30963 L
.76827 .3096 L
.76912 .30958 L
.77 .30956 L
.77079 .30955 L
.77161 .30954 L
.77206 .30953 L
.77249 .30953 L
.77268 .30953 L
.77288 .30953 L
.77305 .30953 L
.77324 .30952 L
.77347 .30952 L
.77368 .30952 L
.77388 .30952 L
.77407 .30952 L
.77428 .30952 L
.7745 .30953 L
.77472 .30953 L
.77491 .30953 L
.77538 .30953 L
.77583 .30953 L
.77671 .30955 L
.77768 .30956 L
.77933 .3096 L
.78114 .30966 L
.78304 .30975 L
.78482 .30984 L
.78835 .31008 L
.79159 .31036 L
.79852 .31113 L
.80519 .31213 L
.81229 .31345 L
.81912 .31499 L
.82638 .31692 L
.83338 .31908 L
.84011 .32144 L
.84727 .32426 L
.85417 .32731 L
.8608 .33055 L
.86786 .33436 L
.87465 .33841 L
.88188 .34315 L
Mistroke
.88883 .34818 L
.89553 .35349 L
.90265 .35971 L
.90951 .36633 L
.91667 .37401 L
Mfstroke
.75 .49997 m
.75021 .49415 L
.75039 .49192 L
.75081 .48839 L
.75157 .4839 L
.75246 .47992 L
.75329 .47681 L
.75676 .46712 L
.7603 .45987 L
.76413 .45357 L
.77129 .44437 L
.77817 .43754 L
.78479 .43226 L
.79184 .42773 L
.79863 .42424 L
.80584 .42133 L
.80945 .42016 L
.81279 .41924 L
.81623 .41844 L
.81948 .41783 L
.82307 .4173 L
.82632 .41696 L
.82803 .41684 L
.82897 .41678 L
.82984 .41674 L
.83058 .41671 L
.83138 .41669 L
.83183 .41668 L
.83206 .41668 L
.83226 .41667 L
.83245 .41667 L
.83265 .41667 L
.83285 .41667 L
.83307 .41667 L
.83328 .41667 L
.83348 .41667 L
.8337 .41667 L
.83382 .41667 L
.83393 .41667 L
.83415 .41667 L
.8344 .41667 L
.83484 .41668 L
.83525 .41669 L
.83568 .4167 L
.83646 .41673 L
.83735 .41676 L
.83819 .41681 L
.84011 .41694 L
.84193 .41711 L
.84366 .41731 L
Mistroke
.8469 .41778 L
.85037 .41843 L
.85359 .41917 L
.86045 .4212 L
.86774 .4241 L
.87476 .42769 L
.88151 .43201 L
.8887 .43772 L
.89562 .44464 L
.90227 .45318 L
.90598 .45917 L
.90935 .46586 L
.91103 .46988 L
.91286 .47509 L
.91369 .47794 L
.91458 .48147 L
.91534 .48518 L
.91574 .4876 L
.91617 .49093 L
.9163 .49217 L
.91643 .49373 L
.91654 .49547 L
.91667 .49997 L
Mfstroke
.75 .50003 m
.75021 .50585 L
.75039 .50808 L
.75081 .51161 L
.75157 .5161 L
.75246 .52008 L
.75329 .52319 L
.75676 .53288 L
.7603 .54013 L
.76413 .54643 L
.77129 .55563 L
.77817 .56246 L
.78479 .56774 L
.79184 .57227 L
.79863 .57576 L
.80584 .57867 L
.80945 .57984 L
.81279 .58076 L
.81623 .58156 L
.81948 .58217 L
.82307 .5827 L
.82632 .58304 L
.82803 .58316 L
.82897 .58322 L
.82984 .58326 L
.83058 .58329 L
.83138 .58331 L
.83183 .58332 L
.83206 .58332 L
.83226 .58333 L
.83245 .58333 L
.83265 .58333 L
.83285 .58333 L
.83307 .58333 L
.83328 .58333 L
.83348 .58333 L
.8337 .58333 L
.83382 .58333 L
.83393 .58333 L
.83415 .58333 L
.8344 .58333 L
.83484 .58332 L
.83525 .58331 L
.83568 .5833 L
.83646 .58327 L
.83735 .58324 L
.83819 .58319 L
.84011 .58306 L
.84193 .58289 L
.84366 .58269 L
Mistroke
.8469 .58222 L
.85037 .58157 L
.85359 .58083 L
.86045 .5788 L
.86774 .5759 L
.87476 .57231 L
.88151 .56799 L
.8887 .56228 L
.89562 .55536 L
.90227 .54682 L
.90598 .54083 L
.90935 .53414 L
.91103 .53012 L
.91286 .52491 L
.91369 .52206 L
.91458 .51853 L
.91534 .51482 L
.91574 .5124 L
.91617 .50907 L
.9163 .50783 L
.91643 .50627 L
.91654 .50453 L
.91667 .50003 L
Mfstroke
.75 .68898 m
.75329 .68937 L
.75676 .68971 L
.76058 .69002 L
.76244 .69014 L
.76413 .69023 L
.76568 .6903 L
.76735 .69037 L
.76827 .6904 L
.76912 .69042 L
.77 .69044 L
.77079 .69045 L
.77161 .69046 L
.77206 .69047 L
.77249 .69047 L
.77268 .69047 L
.77288 .69047 L
.77305 .69047 L
.77324 .69048 L
.77347 .69048 L
.77368 .69048 L
.77388 .69048 L
.77407 .69048 L
.77428 .69048 L
.7745 .69047 L
.77472 .69047 L
.77491 .69047 L
.77538 .69047 L
.77583 .69047 L
.77671 .69045 L
.77768 .69044 L
.77933 .6904 L
.78114 .69034 L
.78304 .69025 L
.78482 .69016 L
.78835 .68992 L
.79159 .68964 L
.79852 .68887 L
.80519 .68787 L
.81229 .68655 L
.81912 .68501 L
.82638 .68308 L
.83338 .68092 L
.84011 .67856 L
.84727 .67574 L
.85417 .67269 L
.8608 .66945 L
.86786 .66564 L
.87465 .66159 L
.88188 .65685 L
Mistroke
.88883 .65182 L
.89553 .64651 L
.90265 .64029 L
.90951 .63367 L
.91667 .62599 L
Mfstroke
0 1 1 r
.75 .50003 m
.75021 .50585 L
.75039 .50808 L
.75081 .51161 L
.75157 .5161 L
.75246 .52008 L
.75329 .52319 L
.75676 .53288 L
.7603 .54013 L
.76413 .54643 L
.77129 .55563 L
.77817 .56246 L
.78479 .56774 L
.79184 .57227 L
.79863 .57576 L
.80584 .57867 L
.80945 .57984 L
.81279 .58076 L
.81623 .58156 L
.81948 .58217 L
.82307 .5827 L
.82632 .58304 L
.82803 .58316 L
.82897 .58322 L
.82984 .58326 L
.83058 .58329 L
.83138 .58331 L
.83183 .58332 L
.83206 .58332 L
.83226 .58333 L
.83245 .58333 L
.83265 .58333 L
.83285 .58333 L
.83307 .58333 L
.83328 .58333 L
.83348 .58333 L
.8337 .58333 L
.83382 .58333 L
.83393 .58333 L
.83415 .58333 L
.8344 .58333 L
.83484 .58332 L
.83525 .58331 L
.83568 .5833 L
.83646 .58327 L
.83735 .58324 L
.83819 .58319 L
.84011 .58306 L
.84193 .58289 L
.84366 .58269 L
.8469 .58222 L
.85037 .58157 L
.85359 .58083 L
.86045 .5788 L
.86774 .5759 L
.87476 .57231 L
.88151 .56799 L
.8887 .56228 L
.89562 .55536 L
.90227 .54682 L
.90598 .54083 L
.90935 .53414 L
.91103 .53012 L
.91286 .52491 L
.91369 .52206 L
.91458 .51853 L
.91534 .51482 L
.91574 .5124 L
.91617 .50907 L
.9163 .50783 L
.91643 .50627 L
.91654 .50453 L
.91667 .50003 L
.91667 .62599 L
.90951 .63367 L
.90265 .64029 L
.89553 .64651 L
.88883 .65182 L
.88188 .65685 L
.87465 .66159 L
.86786 .66564 L
.8608 .66945 L
.85417 .67269 L
.84727 .67574 L
.84011 .67856 L
.83338 .68092 L
.82638 .68308 L
.81912 .68501 L
.81229 .68655 L
.80519 .68787 L
.79852 .68887 L
.79159 .68964 L
.78835 .68992 L
.78482 .69016 L
.78304 .69025 L
.78114 .69034 L
.77933 .6904 L
.77768 .69044 L
.77671 .69045 L
.77583 .69047 L
.77538 .69047 L
.77491 .69047 L
.77472 .69047 L
.7745 .69047 L
.77428 .69048 L
.77407 .69048 L
.77388 .69048 L
.77368 .69048 L
.77347 .69048 L
.77324 .69048 L
.77305 .69047 L
.77288 .69047 L
.77268 .69047 L
.77249 .69047 L
.77206 .69047 L
.77161 .69046 L
.77079 .69045 L
.77 .69044 L
.76912 .69042 L
.76827 .6904 L
.76735 .69037 L
.76568 .6903 L
.76413 .69023 L
.76244 .69014 L
.76058 .69002 L
.75676 .68971 L
.75329 .68937 L
.75 .68898 L
F
0 g
.75 .50003 m
.75021 .50585 L
.75039 .50808 L
.75081 .51161 L
.75157 .5161 L
.75246 .52008 L
.75329 .52319 L
.75676 .53288 L
.7603 .54013 L
.76413 .54643 L
.77129 .55563 L
.77817 .56246 L
.78479 .56774 L
.79184 .57227 L
.79863 .57576 L
.80584 .57867 L
.80945 .57984 L
.81279 .58076 L
.81623 .58156 L
.81948 .58217 L
.82307 .5827 L
.82632 .58304 L
.82803 .58316 L
.82897 .58322 L
.82984 .58326 L
.83058 .58329 L
.83138 .58331 L
.83183 .58332 L
.83206 .58332 L
.83226 .58333 L
.83245 .58333 L
.83265 .58333 L
.83285 .58333 L
.83307 .58333 L
.83328 .58333 L
.83348 .58333 L
.8337 .58333 L
.83382 .58333 L
.83393 .58333 L
.83415 .58333 L
.8344 .58333 L
.83484 .58332 L
.83525 .58331 L
.83568 .5833 L
.83646 .58327 L
.83735 .58324 L
.83819 .58319 L
.84011 .58306 L
.84193 .58289 L
.84366 .58269 L
Mistroke
.8469 .58222 L
.85037 .58157 L
.85359 .58083 L
.86045 .5788 L
.86774 .5759 L
.87476 .57231 L
.88151 .56799 L
.8887 .56228 L
.89562 .55536 L
.90227 .54682 L
.90598 .54083 L
.90935 .53414 L
.91103 .53012 L
.91286 .52491 L
.91369 .52206 L
.91458 .51853 L
.91534 .51482 L
.91574 .5124 L
.91617 .50907 L
.9163 .50783 L
.91643 .50627 L
.91654 .50453 L
.91667 .50003 L
Mfstroke
.75 .68898 m
.75329 .68937 L
.75676 .68971 L
.76058 .69002 L
.76244 .69014 L
.76413 .69023 L
.76568 .6903 L
.76735 .69037 L
.76827 .6904 L
.76912 .69042 L
.77 .69044 L
.77079 .69045 L
.77161 .69046 L
.77206 .69047 L
.77249 .69047 L
.77268 .69047 L
.77288 .69047 L
.77305 .69047 L
.77324 .69048 L
.77347 .69048 L
.77368 .69048 L
.77388 .69048 L
.77407 .69048 L
.77428 .69048 L
.7745 .69047 L
.77472 .69047 L
.77491 .69047 L
.77538 .69047 L
.77583 .69047 L
.77671 .69045 L
.77768 .69044 L
.77933 .6904 L
.78114 .69034 L
.78304 .69025 L
.78482 .69016 L
.78835 .68992 L
.79159 .68964 L
.79852 .68887 L
.80519 .68787 L
.81229 .68655 L
.81912 .68501 L
.82638 .68308 L
.83338 .68092 L
.84011 .67856 L
.84727 .67574 L
.85417 .67269 L
.8608 .66945 L
.86786 .66564 L
.87465 .66159 L
.88188 .65685 L
Mistroke
.88883 .65182 L
.89553 .64651 L
.90265 .64029 L
.90951 .63367 L
.91667 .62599 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 1 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.833333 0.0833333 0.5 0.0833333 [
[0 .4875 -9 -9 ]
[0 .4875 9 0 ]
[.16667 .4875 -6 -9 ]
[.16667 .4875 6 0 ]
[.33333 .4875 -6 -9 ]
[.33333 .4875 6 0 ]
[.5 .4875 -6 -9 ]
[.5 .4875 6 0 ]
[.66667 .4875 -6 -9 ]
[.66667 .4875 6 0 ]
[1 .4875 -3 -9 ]
[1 .4875 3 0 ]
[.82083 0 -12 -4.5 ]
[.82083 0 0 4.5 ]
[.82083 .16667 -12 -4.5 ]
[.82083 .16667 0 4.5 ]
[.82083 .33333 -12 -4.5 ]
[.82083 .33333 0 4.5 ]
[.82083 .66667 -6 -4.5 ]
[.82083 .66667 0 4.5 ]
[.82083 .83333 -6 -4.5 ]
[.82083 .83333 0 4.5 ]
[.82083 1 -6 -4.5 ]
[.82083 1 0 4.5 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .5 m
0 .50625 L
s
[(-10)] 0 .4875 0 1 Mshowa
.16667 .5 m
.16667 .50625 L
s
[(-8)] .16667 .4875 0 1 Mshowa
.33333 .5 m
.33333 .50625 L
s
[(-6)] .33333 .4875 0 1 Mshowa
.5 .5 m
.5 .50625 L
s
[(-4)] .5 .4875 0 1 Mshowa
.66667 .5 m
.66667 .50625 L
s
[(-2)] .66667 .4875 0 1 Mshowa
1 .5 m
1 .50625 L
s
[(2)] 1 .4875 0 1 Mshowa
.125 Mabswid
.04167 .5 m
.04167 .50375 L
s
.08333 .5 m
.08333 .50375 L
s
.125 .5 m
.125 .50375 L
s
.20833 .5 m
.20833 .50375 L
s
.25 .5 m
.25 .50375 L
s
.29167 .5 m
.29167 .50375 L
s
.375 .5 m
.375 .50375 L
s
.41667 .5 m
.41667 .50375 L
s
.45833 .5 m
.45833 .50375 L
s
.54167 .5 m
.54167 .50375 L
s
.58333 .5 m
.58333 .50375 L
s
.625 .5 m
.625 .50375 L
s
.70833 .5 m
.70833 .50375 L
s
.75 .5 m
.75 .50375 L
s
.79167 .5 m
.79167 .50375 L
s
.875 .5 m
.875 .50375 L
s
.91667 .5 m
.91667 .50375 L
s
.95833 .5 m
.95833 .50375 L
s
.25 Mabswid
0 .5 m
1 .5 L
s
.83333 0 m
.83958 0 L
s
[(-6)] .82083 0 1 0 Mshowa
.83333 .16667 m
.83958 .16667 L
s
[(-4)] .82083 .16667 1 0 Mshowa
.83333 .33333 m
.83958 .33333 L
s
[(-2)] .82083 .33333 1 0 Mshowa
.83333 .66667 m
.83958 .66667 L
s
[(2)] .82083 .66667 1 0 Mshowa
.83333 .83333 m
.83958 .83333 L
s
[(4)] .82083 .83333 1 0 Mshowa
.83333 1 m
.83958 1 L
s
[(6)] .82083 1 1 0 Mshowa
.125 Mabswid
.83333 .04167 m
.83708 .04167 L
s
.83333 .08333 m
.83708 .08333 L
s
.83333 .125 m
.83708 .125 L
s
.83333 .20833 m
.83708 .20833 L
s
.83333 .25 m
.83708 .25 L
s
.83333 .29167 m
.83708 .29167 L
s
.83333 .375 m
.83708 .375 L
s
.83333 .41667 m
.83708 .41667 L
s
.83333 .45833 m
.83708 .45833 L
s
.83333 .54167 m
.83708 .54167 L
s
.83333 .58333 m
.83708 .58333 L
s
.83333 .625 m
.83708 .625 L
s
.83333 .70833 m
.83708 .70833 L
s
.83333 .75 m
.83708 .75 L
s
.83333 .79167 m
.83708 .79167 L
s
.83333 .875 m
.83708 .875 L
s
.83333 .91667 m
.83708 .91667 L
s
.83333 .95833 m
.83708 .95833 L
s
.25 Mabswid
.83333 0 m
.83333 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.35.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Print",
 CellTags->"S5.35.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 1 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.833333 0.0833333 0.5 0.0833333 [
[0 .4875 -9 -9 ]
[0 .4875 9 0 ]
[.16667 .4875 -6 -9 ]
[.16667 .4875 6 0 ]
[.33333 .4875 -6 -9 ]
[.33333 .4875 6 0 ]
[.5 .4875 -6 -9 ]
[.5 .4875 6 0 ]
[.66667 .4875 -6 -9 ]
[.66667 .4875 6 0 ]
[1 .4875 -3 -9 ]
[1 .4875 3 0 ]
[.82083 0 -12 -4.5 ]
[.82083 0 0 4.5 ]
[.82083 .16667 -12 -4.5 ]
[.82083 .16667 0 4.5 ]
[.82083 .33333 -12 -4.5 ]
[.82083 .33333 0 4.5 ]
[.82083 .66667 -6 -4.5 ]
[.82083 .66667 0 4.5 ]
[.82083 .83333 -6 -4.5 ]
[.82083 .83333 0 4.5 ]
[.82083 1 -6 -4.5 ]
[.82083 1 0 4.5 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .5 m
0 .50625 L
s
[(-10)] 0 .4875 0 1 Mshowa
.16667 .5 m
.16667 .50625 L
s
[(-8)] .16667 .4875 0 1 Mshowa
.33333 .5 m
.33333 .50625 L
s
[(-6)] .33333 .4875 0 1 Mshowa
.5 .5 m
.5 .50625 L
s
[(-4)] .5 .4875 0 1 Mshowa
.66667 .5 m
.66667 .50625 L
s
[(-2)] .66667 .4875 0 1 Mshowa
1 .5 m
1 .50625 L
s
[(2)] 1 .4875 0 1 Mshowa
.125 Mabswid
.04167 .5 m
.04167 .50375 L
s
.08333 .5 m
.08333 .50375 L
s
.125 .5 m
.125 .50375 L
s
.20833 .5 m
.20833 .50375 L
s
.25 .5 m
.25 .50375 L
s
.29167 .5 m
.29167 .50375 L
s
.375 .5 m
.375 .50375 L
s
.41667 .5 m
.41667 .50375 L
s
.45833 .5 m
.45833 .50375 L
s
.54167 .5 m
.54167 .50375 L
s
.58333 .5 m
.58333 .50375 L
s
.625 .5 m
.625 .50375 L
s
.70833 .5 m
.70833 .50375 L
s
.75 .5 m
.75 .50375 L
s
.79167 .5 m
.79167 .50375 L
s
.875 .5 m
.875 .50375 L
s
.91667 .5 m
.91667 .50375 L
s
.95833 .5 m
.95833 .50375 L
s
.25 Mabswid
0 .5 m
1 .5 L
s
.83333 0 m
.83958 0 L
s
[(-6)] .82083 0 1 0 Mshowa
.83333 .16667 m
.83958 .16667 L
s
[(-4)] .82083 .16667 1 0 Mshowa
.83333 .33333 m
.83958 .33333 L
s
[(-2)] .82083 .33333 1 0 Mshowa
.83333 .66667 m
.83958 .66667 L
s
[(2)] .82083 .66667 1 0 Mshowa
.83333 .83333 m
.83958 .83333 L
s
[(4)] .82083 .83333 1 0 Mshowa
.83333 1 m
.83958 1 L
s
[(6)] .82083 1 1 0 Mshowa
.125 Mabswid
.83333 .04167 m
.83708 .04167 L
s
.83333 .08333 m
.83708 .08333 L
s
.83333 .125 m
.83708 .125 L
s
.83333 .20833 m
.83708 .20833 L
s
.83333 .25 m
.83708 .25 L
s
.83333 .29167 m
.83708 .29167 L
s
.83333 .375 m
.83708 .375 L
s
.83333 .41667 m
.83708 .41667 L
s
.83333 .45833 m
.83708 .45833 L
s
.83333 .54167 m
.83708 .54167 L
s
.83333 .58333 m
.83708 .58333 L
s
.83333 .625 m
.83708 .625 L
s
.83333 .70833 m
.83708 .70833 L
s
.83333 .75 m
.83708 .75 L
s
.83333 .79167 m
.83708 .79167 L
s
.83333 .875 m
.83708 .875 L
s
.83333 .91667 m
.83708 .91667 L
s
.83333 .95833 m
.83708 .95833 L
s
.25 Mabswid
.83333 0 m
.83333 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 Mabswid
.47917 .49993 m
.4795 .48742 L
.47981 .48262 L
.48049 .47501 L
.48172 .46531 L
.48316 .4567 L
.48452 .44994 L
.49015 .42868 L
.4959 .41253 L
.50214 .39822 L
.51376 .37672 L
.52495 .35999 L
.53571 .34637 L
.54716 .33386 L
.55819 .32334 L
.56991 .31352 L
.5812 .30519 L
.59207 .2981 L
.60362 .29144 L
.61475 .28581 L
.62658 .2806 L
.63797 .27629 L
.64893 .27275 L
.66059 .26962 L
.67182 .2672 L
.68262 .2654 L
.68863 .26462 L
.69412 .26405 L
.6998 .26359 L
.70236 .26342 L
.70518 .26327 L
.70793 .26316 L
.70933 .26312 L
.71084 .26308 L
.71225 .26305 L
.71287 .26304 L
.71355 .26304 L
.71419 .26303 L
.71478 .26302 L
.71511 .26302 L
.71541 .26302 L
.71576 .26302 L
.71608 .26302 L
.71641 .26302 L
.71676 .26302 L
.71709 .26302 L
.7174 .26302 L
.71775 .26303 L
.71814 .26303 L
.71885 .26304 L
Mistroke
.71958 .26305 L
.72036 .26306 L
.72177 .26309 L
.72319 .26313 L
.72453 .26317 L
.72702 .26327 L
.7298 .26341 L
.73274 .2636 L
.738 .26403 L
.74359 .26462 L
.74881 .26528 L
.75 .26545 L
Mfstroke
.47917 .50007 m
.4795 .51258 L
.47981 .51738 L
.48049 .52499 L
.48172 .53469 L
.48316 .5433 L
.48452 .55006 L
.49015 .57132 L
.4959 .58747 L
.50214 .60178 L
.51376 .62328 L
.52495 .64001 L
.53571 .65363 L
.54716 .66614 L
.55819 .67666 L
.56991 .68648 L
.5812 .69481 L
.59207 .7019 L
.60362 .70856 L
.61475 .71419 L
.62658 .7194 L
.63797 .72371 L
.64893 .72725 L
.66059 .73038 L
.67182 .7328 L
.68262 .7346 L
.68863 .73538 L
.69412 .73595 L
.6998 .73641 L
.70236 .73658 L
.70518 .73673 L
.70793 .73684 L
.70933 .73688 L
.71084 .73692 L
.71225 .73695 L
.71287 .73696 L
.71355 .73696 L
.71419 .73697 L
.71478 .73698 L
.71511 .73698 L
.71541 .73698 L
.71576 .73698 L
.71608 .73698 L
.71641 .73698 L
.71676 .73698 L
.71709 .73698 L
.7174 .73698 L
.71775 .73697 L
.71814 .73697 L
.71885 .73696 L
Mistroke
.71958 .73695 L
.72036 .73694 L
.72177 .73691 L
.72319 .73687 L
.72453 .73683 L
.72702 .73673 L
.7298 .73659 L
.73274 .7364 L
.738 .73597 L
.74359 .73538 L
.74881 .73472 L
.75 .73455 L
Mfstroke
0 1 1 r
.47917 .49993 m
.4795 .48742 L
.47981 .48262 L
.48049 .47501 L
.48172 .46531 L
.48316 .4567 L
.48452 .44994 L
.49015 .42868 L
.4959 .41253 L
.50214 .39822 L
.51376 .37672 L
.52495 .35999 L
.53571 .34637 L
.54716 .33386 L
.55819 .32334 L
.56991 .31352 L
.5812 .30519 L
.59207 .2981 L
.60362 .29144 L
.61475 .28581 L
.62658 .2806 L
.63797 .27629 L
.64893 .27275 L
.66059 .26962 L
.67182 .2672 L
.68262 .2654 L
.68863 .26462 L
.69412 .26405 L
.6998 .26359 L
.70236 .26342 L
.70518 .26327 L
.70793 .26316 L
.70933 .26312 L
.71084 .26308 L
.71225 .26305 L
.71287 .26304 L
.71355 .26304 L
.71419 .26303 L
.71478 .26302 L
.71511 .26302 L
.71541 .26302 L
.71576 .26302 L
.71608 .26302 L
.71641 .26302 L
.71676 .26302 L
.71709 .26302 L
.7174 .26302 L
.71775 .26303 L
.71814 .26303 L
.71885 .26304 L
.71958 .26305 L
.72036 .26306 L
.72177 .26309 L
.72319 .26313 L
.72453 .26317 L
.72702 .26327 L
.7298 .26341 L
.73274 .2636 L
.738 .26403 L
.74359 .26462 L
.74881 .26528 L
.75 .26545 L
.75 .73455 L
.74881 .73472 L
.74359 .73538 L
.738 .73597 L
.73274 .7364 L
.7298 .73659 L
.72702 .73673 L
.72453 .73683 L
.72319 .73687 L
.72177 .73691 L
.72036 .73694 L
.71958 .73695 L
.71885 .73696 L
.71814 .73697 L
.71775 .73697 L
.7174 .73698 L
.71709 .73698 L
.71676 .73698 L
.71641 .73698 L
.71608 .73698 L
.71576 .73698 L
.71541 .73698 L
.71511 .73698 L
.71478 .73698 L
.71419 .73697 L
.71355 .73696 L
.71287 .73696 L
.71225 .73695 L
.71084 .73692 L
.70933 .73688 L
.70793 .73684 L
.70518 .73673 L
.70236 .73658 L
.6998 .73641 L
.69412 .73595 L
.68863 .73538 L
.68262 .7346 L
.67182 .7328 L
.66059 .73038 L
.64893 .72725 L
.63797 .72371 L
.62658 .7194 L
.61475 .71419 L
.60362 .70856 L
.59207 .7019 L
.5812 .69481 L
.56991 .68648 L
.55819 .67666 L
.54716 .66614 L
.53571 .65363 L
.52495 .64001 L
.51376 .62328 L
.50214 .60178 L
.4959 .58747 L
.49015 .57132 L
.48452 .55006 L
.48316 .5433 L
.48172 .53469 L
.48049 .52499 L
.47981 .51738 L
.4795 .51258 L
.47917 .50007 L
F
0 g
.47917 .49993 m
.4795 .48742 L
.47981 .48262 L
.48049 .47501 L
.48172 .46531 L
.48316 .4567 L
.48452 .44994 L
.49015 .42868 L
.4959 .41253 L
.50214 .39822 L
.51376 .37672 L
.52495 .35999 L
.53571 .34637 L
.54716 .33386 L
.55819 .32334 L
.56991 .31352 L
.5812 .30519 L
.59207 .2981 L
.60362 .29144 L
.61475 .28581 L
.62658 .2806 L
.63797 .27629 L
.64893 .27275 L
.66059 .26962 L
.67182 .2672 L
.68262 .2654 L
.68863 .26462 L
.69412 .26405 L
.6998 .26359 L
.70236 .26342 L
.70518 .26327 L
.70793 .26316 L
.70933 .26312 L
.71084 .26308 L
.71225 .26305 L
.71287 .26304 L
.71355 .26304 L
.71419 .26303 L
.71478 .26302 L
.71511 .26302 L
.71541 .26302 L
.71576 .26302 L
.71608 .26302 L
.71641 .26302 L
.71676 .26302 L
.71709 .26302 L
.7174 .26302 L
.71775 .26303 L
.71814 .26303 L
.71885 .26304 L
Mistroke
.71958 .26305 L
.72036 .26306 L
.72177 .26309 L
.72319 .26313 L
.72453 .26317 L
.72702 .26327 L
.7298 .26341 L
.73274 .2636 L
.738 .26403 L
.74359 .26462 L
.74881 .26528 L
.75 .26545 L
Mfstroke
.47917 .50007 m
.4795 .51258 L
.47981 .51738 L
.48049 .52499 L
.48172 .53469 L
.48316 .5433 L
.48452 .55006 L
.49015 .57132 L
.4959 .58747 L
.50214 .60178 L
.51376 .62328 L
.52495 .64001 L
.53571 .65363 L
.54716 .66614 L
.55819 .67666 L
.56991 .68648 L
.5812 .69481 L
.59207 .7019 L
.60362 .70856 L
.61475 .71419 L
.62658 .7194 L
.63797 .72371 L
.64893 .72725 L
.66059 .73038 L
.67182 .7328 L
.68262 .7346 L
.68863 .73538 L
.69412 .73595 L
.6998 .73641 L
.70236 .73658 L
.70518 .73673 L
.70793 .73684 L
.70933 .73688 L
.71084 .73692 L
.71225 .73695 L
.71287 .73696 L
.71355 .73696 L
.71419 .73697 L
.71478 .73698 L
.71511 .73698 L
.71541 .73698 L
.71576 .73698 L
.71608 .73698 L
.71641 .73698 L
.71676 .73698 L
.71709 .73698 L
.7174 .73698 L
.71775 .73697 L
.71814 .73697 L
.71885 .73696 L
Mistroke
.71958 .73695 L
.72036 .73694 L
.72177 .73691 L
.72319 .73687 L
.72453 .73683 L
.72702 .73673 L
.7298 .73659 L
.73274 .7364 L
.738 .73597 L
.74359 .73538 L
.74881 .73472 L
.75 .73455 L
Mfstroke
.91667 .3737 m
.91815 .37608 L
.91976 .37875 L
.92127 .38133 L
.92273 .38389 L
.92428 .38669 L
.92577 .38948 L
.92736 .39254 L
.92889 .3956 L
.93036 .39865 L
.93192 .40203 L
.93343 .40541 L
.93488 .40881 L
.93642 .4126 L
.93791 .41644 L
.93948 .42076 L
.941 .42518 L
.94247 .42973 L
.94402 .43495 L
.94552 .44044 L
.94711 .44695 L
.94864 .45414 L
.95012 .46239 L
.95087 .46738 L
.95169 .47396 L
.95205 .47744 L
.95243 .48189 L
.95262 .48451 L
.95279 .48749 L
.95295 .49097 L
.953 .49219 L
.95304 .49374 L
.95308 .49546 L
.95312 .49997 L
s
.91667 .6263 m
.91815 .62392 L
.91976 .62125 L
.92127 .61867 L
.92273 .61611 L
.92428 .61331 L
.92577 .61052 L
.92736 .60746 L
.92889 .6044 L
.93036 .60135 L
.93192 .59797 L
.93343 .59459 L
.93488 .59119 L
.93642 .5874 L
.93791 .58356 L
.93948 .57924 L
.941 .57482 L
.94247 .57027 L
.94402 .56505 L
.94552 .55956 L
.94711 .55305 L
.94864 .54586 L
.95012 .53761 L
.95087 .53262 L
.95169 .52604 L
.95205 .52256 L
.95243 .51811 L
.95262 .51549 L
.95279 .51251 L
.95295 .50903 L
.953 .50781 L
.95304 .50626 L
.95308 .50454 L
.95312 .50003 L
s
0 1 1 r
.91667 .3737 m
.91815 .37608 L
.91976 .37875 L
.92127 .38133 L
.92273 .38389 L
.92428 .38669 L
.92577 .38948 L
.92736 .39254 L
.92889 .3956 L
.93036 .39865 L
.93192 .40203 L
.93343 .40541 L
.93488 .40881 L
.93642 .4126 L
.93791 .41644 L
.93948 .42076 L
.941 .42518 L
.94247 .42973 L
.94402 .43495 L
.94552 .44044 L
.94711 .44695 L
.94864 .45414 L
.95012 .46239 L
.95087 .46738 L
.95169 .47396 L
.95205 .47744 L
.95243 .48189 L
.95262 .48451 L
.95279 .48749 L
.95295 .49097 L
.953 .49219 L
.95304 .49374 L
.95308 .49546 L
.95312 .49997 L
.95312 .50003 L
.95308 .50454 L
.95304 .50626 L
.953 .50781 L
.95295 .50903 L
.95279 .51251 L
.95262 .51549 L
.95243 .51811 L
.95205 .52256 L
.95169 .52604 L
.95087 .53262 L
.95012 .53761 L
.94864 .54586 L
.94711 .55305 L
.94552 .55956 L
.94402 .56505 L
.94247 .57027 L
.941 .57482 L
.93948 .57924 L
.93791 .58356 L
.93642 .5874 L
.93488 .59119 L
.93343 .59459 L
.93192 .59797 L
.93036 .60135 L
.92889 .6044 L
.92736 .60746 L
.92577 .61052 L
.92428 .61331 L
.92273 .61611 L
.92127 .61867 L
.91976 .62125 L
.91815 .62392 L
.91667 .6263 L
F
0 g
.91667 .3737 m
.91815 .37608 L
.91976 .37875 L
.92127 .38133 L
.92273 .38389 L
.92428 .38669 L
.92577 .38948 L
.92736 .39254 L
.92889 .3956 L
.93036 .39865 L
.93192 .40203 L
.93343 .40541 L
.93488 .40881 L
.93642 .4126 L
.93791 .41644 L
.93948 .42076 L
.941 .42518 L
.94247 .42973 L
.94402 .43495 L
.94552 .44044 L
.94711 .44695 L
.94864 .45414 L
.95012 .46239 L
.95087 .46738 L
.95169 .47396 L
.95205 .47744 L
.95243 .48189 L
.95262 .48451 L
.95279 .48749 L
.95295 .49097 L
.953 .49219 L
.95304 .49374 L
.95308 .49546 L
.95312 .49997 L
s
.91667 .6263 m
.91815 .62392 L
.91976 .62125 L
.92127 .61867 L
.92273 .61611 L
.92428 .61331 L
.92577 .61052 L
.92736 .60746 L
.92889 .6044 L
.93036 .60135 L
.93192 .59797 L
.93343 .59459 L
.93488 .59119 L
.93642 .5874 L
.93791 .58356 L
.93948 .57924 L
.941 .57482 L
.94247 .57027 L
.94402 .56505 L
.94552 .55956 L
.94711 .55305 L
.94864 .54586 L
.95012 .53761 L
.95087 .53262 L
.95169 .52604 L
.95205 .52256 L
.95243 .51811 L
.95262 .51549 L
.95279 .51251 L
.95295 .50903 L
.953 .50781 L
.95304 .50626 L
.95308 .50454 L
.95312 .50003 L
s
.75 .26545 m
.75676 .26653 L
.76413 .26793 L
.77106 .26947 L
.77772 .27116 L
.78481 .27319 L
.79163 .27537 L
.79889 .27793 L
.80587 .28066 L
.8126 .28354 L
.81975 .28687 L
.82663 .29035 L
.83325 .29398 L
.84031 .29815 L
.84709 .30248 L
.8543 .30746 L
.86125 .31264 L
.86794 .31802 L
.87505 .32419 L
.8819 .33063 L
.88917 .33807 L
.89619 .34591 L
.90293 .35416 L
.91011 .36385 L
.91667 .3737 L
s
.75 .49997 m
.75021 .49415 L
.75039 .49192 L
.75081 .48839 L
.75157 .4839 L
.75246 .47992 L
.75329 .47681 L
.75676 .46712 L
.7603 .45987 L
.76413 .45357 L
.77129 .44437 L
.77817 .43754 L
.78479 .43226 L
.79184 .42773 L
.79863 .42424 L
.80584 .42133 L
.80945 .42016 L
.81279 .41924 L
.81623 .41844 L
.81948 .41783 L
.82307 .4173 L
.82632 .41696 L
.82803 .41684 L
.82897 .41678 L
.82984 .41674 L
.83058 .41671 L
.83138 .41669 L
.83183 .41668 L
.83206 .41668 L
.83226 .41667 L
.83245 .41667 L
.83265 .41667 L
.83285 .41667 L
.83307 .41667 L
.83328 .41667 L
.83348 .41667 L
.8337 .41667 L
.83382 .41667 L
.83393 .41667 L
.83415 .41667 L
.8344 .41667 L
.83484 .41668 L
.83525 .41669 L
.83568 .4167 L
.83646 .41673 L
.83735 .41676 L
.83819 .41681 L
.84011 .41694 L
.84193 .41711 L
.84366 .41731 L
Mistroke
.8469 .41778 L
.85037 .41843 L
.85359 .41917 L
.86045 .4212 L
.86774 .4241 L
.87476 .42769 L
.88151 .43201 L
.8887 .43772 L
.89562 .44464 L
.90227 .45318 L
.90598 .45917 L
.90935 .46586 L
.91103 .46988 L
.91286 .47509 L
.91369 .47794 L
.91458 .48147 L
.91534 .48518 L
.91574 .4876 L
.91617 .49093 L
.9163 .49217 L
.91643 .49373 L
.91654 .49547 L
.91667 .49997 L
Mfstroke
0 1 1 r
.75 .26545 m
.75676 .26653 L
.76413 .26793 L
.77106 .26947 L
.77772 .27116 L
.78481 .27319 L
.79163 .27537 L
.79889 .27793 L
.80587 .28066 L
.8126 .28354 L
.81975 .28687 L
.82663 .29035 L
.83325 .29398 L
.84031 .29815 L
.84709 .30248 L
.8543 .30746 L
.86125 .31264 L
.86794 .31802 L
.87505 .32419 L
.8819 .33063 L
.88917 .33807 L
.89619 .34591 L
.90293 .35416 L
.91011 .36385 L
.91667 .3737 L
.91667 .49997 L
.91654 .49547 L
.91643 .49373 L
.9163 .49217 L
.91617 .49093 L
.91574 .4876 L
.91534 .48518 L
.91458 .48147 L
.91369 .47794 L
.91286 .47509 L
.91103 .46988 L
.90935 .46586 L
.90598 .45917 L
.90227 .45318 L
.89562 .44464 L
.8887 .43772 L
.88151 .43201 L
.87476 .42769 L
.86774 .4241 L
.86045 .4212 L
.85359 .41917 L
.85037 .41843 L
.8469 .41778 L
.84366 .41731 L
.84193 .41711 L
.84011 .41694 L
.83819 .41681 L
.83735 .41676 L
.83646 .41673 L
.83568 .4167 L
.83525 .41669 L
.83484 .41668 L
.8344 .41667 L
.83415 .41667 L
.83393 .41667 L
.83382 .41667 L
.8337 .41667 L
.83348 .41667 L
.83328 .41667 L
.83307 .41667 L
.83285 .41667 L
.83265 .41667 L
.83245 .41667 L
.83226 .41667 L
.83206 .41668 L
.83183 .41668 L
.83138 .41669 L
.83058 .41671 L
.82984 .41674 L
.82897 .41678 L
.82803 .41684 L
.82632 .41696 L
.82307 .4173 L
.81948 .41783 L
.81623 .41844 L
.81279 .41924 L
.80945 .42016 L
.80584 .42133 L
.79863 .42424 L
.79184 .42773 L
.78479 .43226 L
.77817 .43754 L
.77129 .44437 L
.76413 .45357 L
.7603 .45987 L
.75676 .46712 L
.75329 .47681 L
.75246 .47992 L
.75157 .4839 L
.75081 .48839 L
.75039 .49192 L
.75021 .49415 L
.75 .49997 L
F
0 g
.75 .26545 m
.75676 .26653 L
.76413 .26793 L
.77106 .26947 L
.77772 .27116 L
.78481 .27319 L
.79163 .27537 L
.79889 .27793 L
.80587 .28066 L
.8126 .28354 L
.81975 .28687 L
.82663 .29035 L
.83325 .29398 L
.84031 .29815 L
.84709 .30248 L
.8543 .30746 L
.86125 .31264 L
.86794 .31802 L
.87505 .32419 L
.8819 .33063 L
.88917 .33807 L
.89619 .34591 L
.90293 .35416 L
.91011 .36385 L
.91667 .3737 L
s
.75 .49997 m
.75021 .49415 L
.75039 .49192 L
.75081 .48839 L
.75157 .4839 L
.75246 .47992 L
.75329 .47681 L
.75676 .46712 L
.7603 .45987 L
.76413 .45357 L
.77129 .44437 L
.77817 .43754 L
.78479 .43226 L
.79184 .42773 L
.79863 .42424 L
.80584 .42133 L
.80945 .42016 L
.81279 .41924 L
.81623 .41844 L
.81948 .41783 L
.82307 .4173 L
.82632 .41696 L
.82803 .41684 L
.82897 .41678 L
.82984 .41674 L
.83058 .41671 L
.83138 .41669 L
.83183 .41668 L
.83206 .41668 L
.83226 .41667 L
.83245 .41667 L
.83265 .41667 L
.83285 .41667 L
.83307 .41667 L
.83328 .41667 L
.83348 .41667 L
.8337 .41667 L
.83382 .41667 L
.83393 .41667 L
.83415 .41667 L
.8344 .41667 L
.83484 .41668 L
.83525 .41669 L
.83568 .4167 L
.83646 .41673 L
.83735 .41676 L
.83819 .41681 L
.84011 .41694 L
.84193 .41711 L
.84366 .41731 L
Mistroke
.8469 .41778 L
.85037 .41843 L
.85359 .41917 L
.86045 .4212 L
.86774 .4241 L
.87476 .42769 L
.88151 .43201 L
.8887 .43772 L
.89562 .44464 L
.90227 .45318 L
.90598 .45917 L
.90935 .46586 L
.91103 .46988 L
.91286 .47509 L
.91369 .47794 L
.91458 .48147 L
.91534 .48518 L
.91574 .4876 L
.91617 .49093 L
.9163 .49217 L
.91643 .49373 L
.91654 .49547 L
.91667 .49997 L
Mfstroke
.75 .50003 m
.75021 .50585 L
.75039 .50808 L
.75081 .51161 L
.75157 .5161 L
.75246 .52008 L
.75329 .52319 L
.75676 .53288 L
.7603 .54013 L
.76413 .54643 L
.77129 .55563 L
.77817 .56246 L
.78479 .56774 L
.79184 .57227 L
.79863 .57576 L
.80584 .57867 L
.80945 .57984 L
.81279 .58076 L
.81623 .58156 L
.81948 .58217 L
.82307 .5827 L
.82632 .58304 L
.82803 .58316 L
.82897 .58322 L
.82984 .58326 L
.83058 .58329 L
.83138 .58331 L
.83183 .58332 L
.83206 .58332 L
.83226 .58333 L
.83245 .58333 L
.83265 .58333 L
.83285 .58333 L
.83307 .58333 L
.83328 .58333 L
.83348 .58333 L
.8337 .58333 L
.83382 .58333 L
.83393 .58333 L
.83415 .58333 L
.8344 .58333 L
.83484 .58332 L
.83525 .58331 L
.83568 .5833 L
.83646 .58327 L
.83735 .58324 L
.83819 .58319 L
.84011 .58306 L
.84193 .58289 L
.84366 .58269 L
Mistroke
.8469 .58222 L
.85037 .58157 L
.85359 .58083 L
.86045 .5788 L
.86774 .5759 L
.87476 .57231 L
.88151 .56799 L
.8887 .56228 L
.89562 .55536 L
.90227 .54682 L
.90598 .54083 L
.90935 .53414 L
.91103 .53012 L
.91286 .52491 L
.91369 .52206 L
.91458 .51853 L
.91534 .51482 L
.91574 .5124 L
.91617 .50907 L
.9163 .50783 L
.91643 .50627 L
.91654 .50453 L
.91667 .50003 L
Mfstroke
.75 .73455 m
.75676 .73347 L
.76413 .73207 L
.77106 .73053 L
.77772 .72884 L
.78481 .72681 L
.79163 .72463 L
.79889 .72207 L
.80587 .71934 L
.8126 .71646 L
.81975 .71313 L
.82663 .70965 L
.83325 .70602 L
.84031 .70185 L
.84709 .69752 L
.8543 .69254 L
.86125 .68736 L
.86794 .68198 L
.87505 .67581 L
.8819 .66937 L
.88917 .66193 L
.89619 .65409 L
.90293 .64584 L
.91011 .63615 L
.91667 .6263 L
s
0 1 1 r
.75 .50003 m
.75021 .50585 L
.75039 .50808 L
.75081 .51161 L
.75157 .5161 L
.75246 .52008 L
.75329 .52319 L
.75676 .53288 L
.7603 .54013 L
.76413 .54643 L
.77129 .55563 L
.77817 .56246 L
.78479 .56774 L
.79184 .57227 L
.79863 .57576 L
.80584 .57867 L
.80945 .57984 L
.81279 .58076 L
.81623 .58156 L
.81948 .58217 L
.82307 .5827 L
.82632 .58304 L
.82803 .58316 L
.82897 .58322 L
.82984 .58326 L
.83058 .58329 L
.83138 .58331 L
.83183 .58332 L
.83206 .58332 L
.83226 .58333 L
.83245 .58333 L
.83265 .58333 L
.83285 .58333 L
.83307 .58333 L
.83328 .58333 L
.83348 .58333 L
.8337 .58333 L
.83382 .58333 L
.83393 .58333 L
.83415 .58333 L
.8344 .58333 L
.83484 .58332 L
.83525 .58331 L
.83568 .5833 L
.83646 .58327 L
.83735 .58324 L
.83819 .58319 L
.84011 .58306 L
.84193 .58289 L
.84366 .58269 L
.8469 .58222 L
.85037 .58157 L
.85359 .58083 L
.86045 .5788 L
.86774 .5759 L
.87476 .57231 L
.88151 .56799 L
.8887 .56228 L
.89562 .55536 L
.90227 .54682 L
.90598 .54083 L
.90935 .53414 L
.91103 .53012 L
.91286 .52491 L
.91369 .52206 L
.91458 .51853 L
.91534 .51482 L
.91574 .5124 L
.91617 .50907 L
.9163 .50783 L
.91643 .50627 L
.91654 .50453 L
.91667 .50003 L
.91667 .6263 L
.91011 .63615 L
.90293 .64584 L
.89619 .65409 L
.88917 .66193 L
.8819 .66937 L
.87505 .67581 L
.86794 .68198 L
.86125 .68736 L
.8543 .69254 L
.84709 .69752 L
.84031 .70185 L
.83325 .70602 L
.82663 .70965 L
.81975 .71313 L
.8126 .71646 L
.80587 .71934 L
.79889 .72207 L
.79163 .72463 L
.78481 .72681 L
.77772 .72884 L
.77106 .73053 L
.76413 .73207 L
.75676 .73347 L
.75 .73455 L
F
0 g
.75 .50003 m
.75021 .50585 L
.75039 .50808 L
.75081 .51161 L
.75157 .5161 L
.75246 .52008 L
.75329 .52319 L
.75676 .53288 L
.7603 .54013 L
.76413 .54643 L
.77129 .55563 L
.77817 .56246 L
.78479 .56774 L
.79184 .57227 L
.79863 .57576 L
.80584 .57867 L
.80945 .57984 L
.81279 .58076 L
.81623 .58156 L
.81948 .58217 L
.82307 .5827 L
.82632 .58304 L
.82803 .58316 L
.82897 .58322 L
.82984 .58326 L
.83058 .58329 L
.83138 .58331 L
.83183 .58332 L
.83206 .58332 L
.83226 .58333 L
.83245 .58333 L
.83265 .58333 L
.83285 .58333 L
.83307 .58333 L
.83328 .58333 L
.83348 .58333 L
.8337 .58333 L
.83382 .58333 L
.83393 .58333 L
.83415 .58333 L
.8344 .58333 L
.83484 .58332 L
.83525 .58331 L
.83568 .5833 L
.83646 .58327 L
.83735 .58324 L
.83819 .58319 L
.84011 .58306 L
.84193 .58289 L
.84366 .58269 L
Mistroke
.8469 .58222 L
.85037 .58157 L
.85359 .58083 L
.86045 .5788 L
.86774 .5759 L
.87476 .57231 L
.88151 .56799 L
.8887 .56228 L
.89562 .55536 L
.90227 .54682 L
.90598 .54083 L
.90935 .53414 L
.91103 .53012 L
.91286 .52491 L
.91369 .52206 L
.91458 .51853 L
.91534 .51482 L
.91574 .5124 L
.91617 .50907 L
.9163 .50783 L
.91643 .50627 L
.91654 .50453 L
.91667 .50003 L
Mfstroke
.75 .73455 m
.75676 .73347 L
.76413 .7