(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      8814,        307]*)
(*NotebookOutlinePosition[     11753,        400]*)
(*  CellTagsIndexPosition[     11521,        387]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Algebra",
 StyleBox["`", "MB"],
 "InequalitySolve",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.4.1", "1.1"}],

Cell[TextData[{
 "The package provides a function for solving systems of inequalities. ",
 StyleBox["InequalitySolve[", "MR"],
 StyleBox["expr", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["x", "TI"],
 StyleBox["]", "MR"],
 " finds conditions that must be satisfied by real values of ",
 StyleBox["x", "TI"],
 " in order for the expression ",
 StyleBox["expr", "TI"],
 " to be true. The expression should contain logical connectives and \
polynomial equations and inequalities in the specified variable.  "
}], "Text",
 CellTags->{"S5.4.1", "1.2"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["InequalitySolve[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["find all real values of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[
      " that satisfy the expression containing logical connectives and \
univariate polynomial equations and inequalities",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["InequalitySolve[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] }]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["find all real values of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], 
         StyleBox["i",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" that satisfy the inequalities",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.4.1"],

Cell["Finding solutions to inequalities. ", "Caption",
 CellTags->"S5.4.1"],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.4.1", "1.3"}],

Cell["<<Algebra`InequalitySolve`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.4.1"],

Cell["Here is a set of solutions to a polynomial inequality. ", "MathCaption",
 CellTags->{"S5.4.1", "1.4"}],

Cell[CellGroupData[{

Cell["InequalitySolve[x (x^2 - 2) (x^2 - 3) > 0, x]", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.4.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    SqrtBox["3"]}], "<", "x", "<", 
   RowBox[{"-", 
    SqrtBox["2"]}]}], "||", 
  RowBox[{"0", "<", "x", "<", 
   SqrtBox["2"]}], "||", 
  RowBox[{"x", ">", 
   SqrtBox["3"]}]}]], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.4.1"]
}, Open  ]],

Cell["\<\
The inequalities may contain absolute values and rational functions. \
\>", "MathCaption",
 CellTags->{"S5.4.1", "1.5"}],

Cell[CellGroupData[{

Cell["InequalitySolve[x/Abs[x - 1] >= 0 && 1/x < x + 1, x]", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.4.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SqrtBox["5"]}], ")"}]}], "<", "x", "<", "1"}], "||", 
  RowBox[{"x", ">", "1"}]}]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.4.1"]
}, Open  ]],

Cell["Multivariate inqualities may also be solved. ", "MathCaption",
 CellTags->{"S5.4.1", "1.6"}],

Cell[CellGroupData[{

Cell["InequalitySolve[x^2 + y^2 < 1 && x < y, {x, y}]", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.4.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"-", "1"}], "<", "x", "\[LessEqual]", 
    RowBox[{"-", 
     FractionBox["1", 
      SqrtBox["2"]]}]}], "&&", 
   RowBox[{
    RowBox[{"-", 
     SqrtBox[
      RowBox[{"1", "-", 
       SuperscriptBox["x", "2"]}]]}], "<", "y", "<", 
    SqrtBox[
     RowBox[{"1", "-", 
      SuperscriptBox["x", "2"]}]]}]}], "||", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", 
      SqrtBox["2"]]}], "<", "x", "<", 
    FractionBox["1", 
     SqrtBox["2"]]}], "&&", 
   RowBox[{"x", "<", "y", "<", 
    SqrtBox[
     RowBox[{"1", "-", 
      SuperscriptBox["x", "2"]}]]}]}]}]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.4.1"]
}, Open  ]],

Cell["\<\
Here the inequalities contain the exponential function. In general, if \
inequalities contain nonpolynomial functions of the specified variable, you \
may get an incorrect result. \
\>", "MathCaption",
 CellTags->{"S5.4.1", "1.7"}],

Cell[CellGroupData[{

Cell["InequalitySolve[Abs[x - 1] <= 5 && E^x <= 3, x]", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.4.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"InequalitySolve", "::", "\<\"npi\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"A nonpolynomial equation or inequality encountered. The \
solution set may be incorrect.\"\>"}]], "Message",
 CellTags->"S5.4.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "4"}], "\[LessEqual]", "x", "\[LessEqual]", 
  RowBox[{"Log", "[", "3", "]"}]}]], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S5.4.1"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.4.1"->{
    Cell[1776, 53, 138, 6, 36, "Subsection",
      CellTags->{"S5.4.1", "1.1"}],
    Cell[1917, 61, 544, 14, 72, "Text",
      CellTags->{"S5.4.1", "1.2"}],
    Cell[2464, 77, 3211, 99, 120, "DefinitionBox",
      CellTags->"S5.4.1"],
    Cell[5678, 178, 75, 1, 15, "Caption",
      CellTags->"S5.4.1"],
    Cell[5756, 181, 77, 1, 40, "MathCaption",
      CellTags->{"S5.4.1", "1.3"}],
    Cell[5836, 184, 88, 2, 28, "Input",
      CellTags->"S5.4.1"],
    Cell[5927, 188, 108, 1, 40, "MathCaption",
      CellTags->{"S5.4.1", "1.4"}],
    Cell[6060, 193, 107, 2, 28, "Input",
      CellTags->"S5.4.1"],
    Cell[6170, 197, 288, 12, 28, "Output",
      CellTags->"S5.4.1"],
    Cell[6473, 212, 130, 3, 40, "MathCaption",
      CellTags->{"S5.4.1", "1.5"}],
    Cell[6628, 219, 114, 2, 28, "Input",
      CellTags->"S5.4.1"],
    Cell[6745, 223, 288, 11, 40, "Output",
      CellTags->"S5.4.1"],
    Cell[7048, 237, 98, 1, 40, "MathCaption",
      CellTags->{"S5.4.1", "1.6"}],
    Cell[7171, 242, 109, 2, 28, "Input",
      CellTags->"S5.4.1"],
    Cell[7283, 246, 696, 28, 84, "Output",
      CellTags->"S5.4.1"],
    Cell[7994, 277, 241, 5, 70, "MathCaption",
      CellTags->{"S5.4.1", "1.7"}],
    Cell[8260, 286, 109, 2, 70, "Input",
      CellTags->"S5.4.1"],
    Cell[8372, 290, 236, 6, 70, "Message",
      CellTags->"S5.4.1"],
    Cell[8611, 298, 175, 5, 70, "Output",
      CellTags->"S5.4.1"]},
  "1.1"->{
    Cell[1776, 53, 138, 6, 36, "Subsection",
      CellTags->{"S5.4.1", "1.1"}]},
  "1.2"->{
    Cell[1917, 61, 544, 14, 72, "Text",
      CellTags->{"S5.4.1", "1.2"}]},
  "1.3"->{
    Cell[5756, 181, 77, 1, 40, "MathCaption",
      CellTags->{"S5.4.1", "1.3"}]},
  "1.4"->{
    Cell[5927, 188, 108, 1, 40, "MathCaption",
      CellTags->{"S5.4.1", "1.4"}]},
  "1.5"->{
    Cell[6473, 212, 130, 3, 40, "MathCaption",
      CellTags->{"S5.4.1", "1.5"}]},
  "1.6"->{
    Cell[7048, 237, 98, 1, 40, "MathCaption",
      CellTags->{"S5.4.1", "1.6"}]},
  "1.7"->{
    Cell[7994, 277, 241, 5, 70, "MathCaption",
      CellTags->{"S5.4.1", "1.7"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.4.1", 9436, 323},
  {"1.1", 10853, 362},
  {"1.2", 10946, 365},
  {"1.3", 11034, 368},
  {"1.4", 11128, 371},
  {"1.5", 11223, 374},
  {"1.6", 11318, 377},
  {"1.7", 11412, 380}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 138, 6, 36, "Subsection",
  CellTags->{"S5.4.1", "1.1"}],
Cell[1917, 61, 544, 14, 72, "Text",
  CellTags->{"S5.4.1", "1.2"}],
Cell[2464, 77, 3211, 99, 120, "DefinitionBox",
  CellTags->"S5.4.1"],
Cell[5678, 178, 75, 1, 15, "Caption",
  CellTags->"S5.4.1"],
Cell[5756, 181, 77, 1, 40, "MathCaption",
  CellTags->{"S5.4.1", "1.3"}],
Cell[5836, 184, 88, 2, 28, "Input",
  CellTags->"S5.4.1"],
Cell[5927, 188, 108, 1, 40, "MathCaption",
  CellTags->{"S5.4.1", "1.4"}],

Cell[CellGroupData[{
Cell[6060, 193, 107, 2, 28, "Input",
  CellTags->"S5.4.1"],
Cell[6170, 197, 288, 12, 28, "Output",
  CellTags->"S5.4.1"]
}, Open  ]],
Cell[6473, 212, 130, 3, 40, "MathCaption",
  CellTags->{"S5.4.1", "1.5"}],

Cell[CellGroupData[{
Cell[6628, 219, 114, 2, 28, "Input",
  CellTags->"S5.4.1"],
Cell[6745, 223, 288, 11, 40, "Output",
  CellTags->"S5.4.1"]
}, Open  ]],
Cell[7048, 237, 98, 1, 40, "MathCaption",
  CellTags->{"S5.4.1", "1.6"}],

Cell[CellGroupData[{
Cell[7171, 242, 109, 2, 28, "Input",
  CellTags->"S5.4.1"],
Cell[7283, 246, 696, 28, 84, "Output",
  CellTags->"S5.4.1"]
}, Open  ]],
Cell[7994, 277, 241, 5, 70, "MathCaption",
  CellTags->{"S5.4.1", "1.7"}],

Cell[CellGroupData[{
Cell[8260, 286, 109, 2, 70, "Input",
  CellTags->"S5.4.1"],
Cell[8372, 290, 236, 6, 70, "Message",
  CellTags->"S5.4.1"],
Cell[8611, 298, 175, 5, 70, "Output",
  CellTags->"S5.4.1"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

