(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     21069,        711]*)
(*NotebookOutlinePosition[     25582,        848]*)
(*  CellTagsIndexPosition[     25278,        832]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "NumericalMath",
 StyleBox["`", "MB"],
 "InterpolateRoot",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.82.1", "1.1"}],

Cell[TextData[{
 "The function ",
 StyleBox["FindRoot", "MR"],
 " is useful for finding a root of a function. It is fairly robust and will \
almost always find a root if it is given a sufficiently close starting value \
and the root is simple (or if it is multiple and the option ",
 StyleBox["DampingFactor", "MR"],
 " is appropriately set). To achieve this robustness ",
 StyleBox["FindRoot", "MR"],
 " makes compromises and is not particularly conservative about the number of \
function evaluations it uses. There are cases, however, where you know that \
the function is very well behaved, but evaluating it is extremely expensive, \
particularly for very high precision. In such cases ",
 StyleBox["InterpolateRoot", "MR"],
 " may be more efficient. "
}], "Text",
 CellTags->{"S5.82.1", "1.2"}],

Cell[TextData[{
 StyleBox["InterpolateRoot", "MR"],
 " looks at previous evaluations of the function, say ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     StyleBox["a",
      "TI"], ",", 
     StyleBox["f",
      "TI"], 
     RowBox[{"(", 
      StyleBox["a",
       "TI"], ")"}]}], "}"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     StyleBox["b",
      "TI"], ",", 
     StyleBox["f",
      "TI"], 
     RowBox[{"(", 
      StyleBox["b",
       "TI"], ")"}]}], "}"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     StyleBox["c",
      "TI"], ",", 
     StyleBox["f",
      "TI"], 
     RowBox[{"(", 
      StyleBox["c",
       "TI"], ")"}]}], "}"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     StyleBox["d",
      "TI"], ",", 
     StyleBox["f",
      "TI"], 
     RowBox[{"(", 
      StyleBox["d",
       "TI"], ")"}]}], "}"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and forms the interpolating polynomial which passes through the points ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     StyleBox["f",
      "TI"], 
     RowBox[{"(", 
      StyleBox["a",
       "TI"], ")"}], ",", 
     StyleBox["a",
      "TI"]}], "}"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     StyleBox["f",
      "TI"], 
     RowBox[{"(", 
      StyleBox["b",
       "TI"], ")"}], ",", 
     StyleBox["b",
      "TI"]}], "}"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     StyleBox["f",
      "TI"], 
     RowBox[{"(", 
      StyleBox["c",
       "TI"], ")"}], ",", 
     StyleBox["c",
      "TI"]}], "}"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     StyleBox["f",
      "TI"], 
     RowBox[{"(", 
      StyleBox["d",
       "TI"], ")"}], ",", 
     StyleBox["d",
      "TI"]}], "}"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". The algorithm gets the next approximation for the root of ",
 Cell[BoxData[
  FormBox[
   StyleBox["f",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " by evaluating the interpolating polynomial at ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". It turns out that using all of the previous data is not the best \
strategy. While the convergence rate increases with the use of additional \
data points, the rate is never greater than quadratic. Further, the more data \
points used, the less robust the algorithm becomes. ",
 StyleBox["InterpolateRoot", "MR"],
 " uses only the previous four data points since there is almost no benefit \
to using more. "
}], "Text",
 CellTags->{"S5.82.1", "1.3"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["InterpolateRoot[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["f",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["a", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["b", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["find a root of the function ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" near the starting points ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["a", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["b", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["InterpolateRoot[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["eqn", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["a", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["b", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["find a root of the equation ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["eqn", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" near the starting points ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["a", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and\[NonBreakingSpace]",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["b", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.82.1"],

Cell[TextData[{
 "Root finding with ",
 StyleBox["InterpolateRoot", "MR"],
 ". "
}], "Caption",
 CellTags->"S5.82.1"],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["option name", "TI",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["default value", "TI",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox["",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["AccuracyGoal", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Automatic", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "the desired accuracy in the root being sought",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["MaxIterations", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["15", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "maximum number of function evaluations before giving up",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["WorkingPrecision", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["40", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "the maximum precision to use in the arithmetic calculations",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ShowProgress", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["False", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "whether to print intermediate results and other information as the \
algorithm progresses",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
 GridBoxOptions->{RowLines->{True, False},
 RowSpacings->0.4},
 CellTags->"S5.82.1"],

Cell[TextData[{
 "Options for ",
 StyleBox["InterpolateRoot.", "MR"]
}], "Caption",
 CellTags->"S5.82.1"],

Cell[TextData[{
 "The ",
 StyleBox["Automatic", "MR"],
 " choice for ",
 StyleBox["AccuracyGoal", "MR"],
 " means that the ",
 StyleBox["AccuracyGoal", "MR"],
 " will be chosen to be ",
 Cell[BoxData[
  FormBox["20", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " digits less than the ",
 StyleBox["WorkingPrecision", "MR"],
 ". It should be noted that ",
 StyleBox["AccuracyGoal", "MR"],
 " as used in ",
 StyleBox["InterpolateRoot", "MR"],
 " is different from ",
 StyleBox["AccuracyGoal", "MR"],
 " in ",
 StyleBox["FindRoot", "MR"],
 ". ",
 StyleBox["FindRoot", "MR"],
 " is a much more general function that works for systems of equations. \
Trying to justify an accuracy in the value of the root itself is too \
difficult. ",
 StyleBox["FindRoot", "MR"],
 " merely stops when the value of the function is sufficiently small. ",
 StyleBox["InterpolateRoot", "MR"],
 " is much more specialized. It only works for a single function of a single \
variable at simple roots and assumes that the function is very well behaved. \
In such cases it is quite easy to justify an accuracy in the value of the \
root itself. "
}], "Text",
 CellTags->{"S5.82.1", "1.4"}],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.82.1", "1.5"}],

Cell["<<NumericalMath`InterpolateRoot`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.82.1"],

Cell[TextData[{
 "Set up a function whose root we wish to find, with a counter ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " to determine the number of evaluations. "
}], "MathCaption",
 CellTags->{"S5.82.1", "1.6"}],

Cell["f[x_?NumberQ] := (n++; Exp[x] - 2)", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.82.1"],

Cell[TextData[{
 "This uses ",
 StyleBox["FindRoot", "MR"],
 " to find ",
 StyleBox["Log[2]", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.82.1", "1.7"}],

Cell[CellGroupData[{

Cell["\<\
n = 0; FindRoot[f[x], {x, 0, 1},
          WorkingPrecision -> 800,
          AccuracyGoal -> 795]\
\>", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.82.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "x", "\[Rule]", 
   "0.693147180559945309417232121458176568075500134360255254120680009493393621\
969694715605863326996418687542001481020570685733685520235758130557032670751635\
075961930727570828371435190307038623891673471123350115364497955239120475172681\
574932065155524734139525882950453007095326366642654104239157814952043740430385\
500801944170641671518644712839968171784546957026271631064546150257207402481637\
773389638550695260668341137273873722928956493547025762652098859693201965058554\
764703306793654432547632744951250406069438147104689946506220167720424524529612\
687946546193165174681392672504103802546259656869144192871608293803172714367782\
654877566485085674077648451464439940461422603193096735402574446070308096085047\
486638523138181676751438667476647890881437141985494231519973548803751658612753\
52916610007105355824987941472950929303346557`800."}], "}"}]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.82.1"]
}, Open  ]],

Cell["\<\
Here is the number of function evaluations to get the result. \
\>", "MathCaption",
 CellTags->{"S5.82.1", "1.8"}],

Cell[CellGroupData[{

Cell["n", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.82.1"],

Cell[BoxData["18"], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.82.1"]
}, Open  ]],

Cell[TextData[{
 StyleBox["InterpolateRoot", "MR"],
 " requires fewer function evaluations to get the same result. "
}], "MathCaption",
 CellTags->{"S5.82.1", "1.9"}],

Cell[CellGroupData[{

Cell["\<\
n = 0; InterpolateRoot[f[x], {x, 0, 1},
          WorkingPrecision -> 800,
          AccuracyGoal -> 795]; n\
\>", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.82.1"],

Cell[BoxData["13"], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S5.82.1"]
}, Open  ]],

Cell["\<\
You can observe how the approximations converge to the root. \
\>", "MathCaption",
 CellTags->{"S5.82.1", "1.10"}],

Cell[CellGroupData[{

Cell["\<\
InterpolateRoot[Exp[x] == 2, {x, 0, 1},
          ShowProgress -> True,
          WorkingPrecision -> 40]\
\>", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.82.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0.58197670686932642438500200510901155855`20.954589770191003"}], 
  "}"}]], "Print",
 CellTags->"S5.82.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"20.954589770191003`", ",", "0", ",", 
   RowBox[{
   "-", "0.12246396352039524099846310239210750572`19.976047975799403"}]}], 
  "}"}]], "Print",
 CellTags->"S5.82.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", 
   "0.701935303788276401444337076472338673510537183601405128453`41.\
021139875759246"}], "}"}]], "Print",
 CellTags->"S5.82.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "20.954589770191003`", ",", "20.066550105568243`", ",", 
   "0.0130121629575404389120930392357057520880042512`30."}], "}"}]], "Print",
 CellTags->"S5.82.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "3", ",", 
   "0.693206577206526316528998579372636798857917709608292809465`41.\
021139875759246"}], "}"}]], "Print",
 CellTags->"S5.82.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "20.954589770191003`", ",", "20.066550105568243`", ",", 
   "0.000062480788747713548804773112636400519915488182`30."}], "}"}]], "Print",\

 CellTags->"S5.82.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "6", ",", 
   "0.693147193260393384161872605823729870238254108757127830985`41.\
06655010556824"}], "}"}]], "Print",
 CellTags->"S5.82.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "21", ",", "20.066550105568243`", ",", 
   "1.2644348369358488803846038760130247574333`30.*^-8"}], "}"}]], "Print",
 CellTags->"S5.82.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "12", ",", 
   "0.693147180559945119457822446955902592223035705048596912996438833389420078\
6695`60.06655010556823"}], "}"}]], "Print",
 CellTags->"S5.82.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"40", ",", "20.066550105568243`", ",", 
   RowBox[{"-", "1.89953767048152086910014149599812191397131`30.*^-16"}]}], 
  "}"}]], "Print",
 CellTags->"S5.82.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "24", ",", 
   "0.693147180559945309417232121457862571571181173372490767437846872153397739\
48898`60.06655010556823"}], "}"}]], "Print",
 CellTags->"S5.82.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "x", "\[Rule]", 
   "0.69314718055994530941723212145786257157`23.84082546104514"}], 
  "}"}]], "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S5.82.1"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.82.1"->{
    Cell[1776, 53, 145, 6, 36, "Subsection",
      CellTags->{"S5.82.1", "1.1"}],
    Cell[1924, 61, 800, 16, 120, "Text",
      CellTags->{"S5.82.1", "1.2"}],
    Cell[2727, 79, 3280, 124, 136, "Text",
      CellTags->{"S5.82.1", "1.3"}],
    Cell[6010, 205, 3838, 120, 102, "DefinitionBox",
      CellTags->"S5.82.1"],
    Cell[9851, 327, 117, 5, 15, "Caption",
      CellTags->"S5.82.1"],
    Cell[9971, 334, 4420, 126, 220, "DefinitionBox3Col",
      CellTags->"S5.82.1"],
    Cell[14394, 462, 105, 4, 70, "Caption",
      CellTags->"S5.82.1"],
    Cell[14502, 468, 1199, 34, 70, "Text",
      CellTags->{"S5.82.1", "1.4"}],
    Cell[15704, 504, 78, 1, 70, "MathCaption",
      CellTags->{"S5.82.1", "1.5"}],
    Cell[15785, 507, 95, 2, 70, "Input",
      CellTags->"S5.82.1"],
    Cell[15883, 511, 312, 9, 70, "MathCaption",
      CellTags->{"S5.82.1", "1.6"}],
    Cell[16198, 522, 97, 2, 70, "Input",
      CellTags->"S5.82.1"],
    Cell[16298, 526, 156, 7, 70, "MathCaption",
      CellTags->{"S5.82.1", "1.7"}],
    Cell[16479, 537, 169, 6, 70, "Input",
      CellTags->"S5.82.1"],
    Cell[16651, 545, 976, 16, 70, "Output",
      CellTags->"S5.82.1"],
    Cell[17642, 564, 124, 3, 70, "MathCaption",
      CellTags->{"S5.82.1", "1.8"}],
    Cell[17791, 571, 64, 2, 70, "Input",
      CellTags->"S5.82.1"],
    Cell[17858, 575, 75, 2, 70, "Output",
      CellTags->"S5.82.1"],
    Cell[17948, 580, 166, 4, 70, "MathCaption",
      CellTags->{"S5.82.1", "1.9"}],
    Cell[18139, 588, 179, 6, 70, "Input",
      CellTags->"S5.82.1"],
    Cell[18321, 596, 75, 2, 70, "Output",
      CellTags->"S5.82.1"],
    Cell[18411, 601, 124, 3, 70, "MathCaption",
      CellTags->{"S5.82.1", "1.10"}],
    Cell[18560, 608, 176, 6, 70, "Input",
      CellTags->"S5.82.1"],
    Cell[18739, 616, 158, 5, 70, "Print",
      CellTags->"S5.82.1"],
    Cell[18900, 623, 206, 6, 70, "Print",
      CellTags->"S5.82.1"],
    Cell[19109, 631, 180, 6, 70, "Print",
      CellTags->"S5.82.1"],
    Cell[19292, 639, 198, 5, 70, "Print",
      CellTags->"S5.82.1"],
    Cell[19493, 646, 180, 6, 70, "Print",
      CellTags->"S5.82.1"],
    Cell[19676, 654, 202, 6, 70, "Print",
      CellTags->"S5.82.1"],
    Cell[19881, 662, 179, 6, 70, "Print",
      CellTags->"S5.82.1"],
    Cell[20063, 670, 179, 5, 70, "Print",
      CellTags->"S5.82.1"],
    Cell[20245, 677, 199, 6, 70, "Print",
      CellTags->"S5.82.1"],
    Cell[20447, 685, 196, 5, 70, "Print",
      CellTags->"S5.82.1"],
    Cell[20646, 692, 200, 6, 70, "Print",
      CellTags->"S5.82.1"],
    Cell[20849, 700, 192, 7, 70, "Output",
      CellTags->"S5.82.1"]},
  "1.1"->{
    Cell[1776, 53, 145, 6, 36, "Subsection",
      CellTags->{"S5.82.1", "1.1"}]},
  "1.2"->{
    Cell[1924, 61, 800, 16, 120, "Text",
      CellTags->{"S5.82.1", "1.2"}]},
  "1.3"->{
    Cell[2727, 79, 3280, 124, 136, "Text",
      CellTags->{"S5.82.1", "1.3"}]},
  "1.4"->{
    Cell[14502, 468, 1199, 34, 70, "Text",
      CellTags->{"S5.82.1", "1.4"}]},
  "1.5"->{
    Cell[15704, 504, 78, 1, 70, "MathCaption",
      CellTags->{"S5.82.1", "1.5"}]},
  "1.6"->{
    Cell[15883, 511, 312, 9, 70, "MathCaption",
      CellTags->{"S5.82.1", "1.6"}]},
  "1.7"->{
    Cell[16298, 526, 156, 7, 70, "MathCaption",
      CellTags->{"S5.82.1", "1.7"}]},
  "1.8"->{
    Cell[17642, 564, 124, 3, 70, "MathCaption",
      CellTags->{"S5.82.1", "1.8"}]},
  "1.9"->{
    Cell[17948, 580, 166, 4, 70, "MathCaption",
      CellTags->{"S5.82.1", "1.9"}]},
  "1.10"->{
    Cell[18411, 601, 124, 3, 70, "MathCaption",
      CellTags->{"S5.82.1", "1.10"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.82.1", 21692, 727},
  {"1.1", 24313, 798},
  {"1.2", 24407, 801},
  {"1.3", 24497, 804},
  {"1.4", 24589, 807},
  {"1.5", 24681, 810},
  {"1.6", 24777, 813},
  {"1.7", 24874, 816},
  {"1.8", 24971, 819},
  {"1.9", 25068, 822},
  {"1.10", 25166, 825}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 145, 6, 36, "Subsection",
  CellTags->{"S5.82.1", "1.1"}],
Cell[1924, 61, 800, 16, 120, "Text",
  CellTags->{"S5.82.1", "1.2"}],
Cell[2727, 79, 3280, 124, 136, "Text",
  CellTags->{"S5.82.1", "1.3"}],
Cell[6010, 205, 3838, 120, 102, "DefinitionBox",
  CellTags->"S5.82.1"],
Cell[9851, 327, 117, 5, 15, "Caption",
  CellTags->"S5.82.1"],
Cell[9971, 334, 4420, 126, 220, "DefinitionBox3Col",
  CellTags->"S5.82.1"],
Cell[14394, 462, 105, 4, 70, "Caption",
  CellTags->"S5.82.1"],
Cell[14502, 468, 1199, 34, 70, "Text",
  CellTags->{"S5.82.1", "1.4"}],
Cell[15704, 504, 78, 1, 70, "MathCaption",
  CellTags->{"S5.82.1", "1.5"}],
Cell[15785, 507, 95, 2, 70, "Input",
  CellTags->"S5.82.1"],
Cell[15883, 511, 312, 9, 70, "MathCaption",
  CellTags->{"S5.82.1", "1.6"}],
Cell[16198, 522, 97, 2, 70, "Input",
  CellTags->"S5.82.1"],
Cell[16298, 526, 156, 7, 70, "MathCaption",
  CellTags->{"S5.82.1", "1.7"}],

Cell[CellGroupData[{
Cell[16479, 537, 169, 6, 70, "Input",
  CellTags->"S5.82.1"],
Cell[16651, 545, 976, 16, 70, "Output",
  CellTags->"S5.82.1"]
}, Open  ]],
Cell[17642, 564, 124, 3, 70, "MathCaption",
  CellTags->{"S5.82.1", "1.8"}],

Cell[CellGroupData[{
Cell[17791, 571, 64, 2, 70, "Input",
  CellTags->"S5.82.1"],
Cell[17858, 575, 75, 2, 70, "Output",
  CellTags->"S5.82.1"]
}, Open  ]],
Cell[17948, 580, 166, 4, 70, "MathCaption",
  CellTags->{"S5.82.1", "1.9"}],

Cell[CellGroupData[{
Cell[18139, 588, 179, 6, 70, "Input",
  CellTags->"S5.82.1"],
Cell[18321, 596, 75, 2, 70, "Output",
  CellTags->"S5.82.1"]
}, Open  ]],
Cell[18411, 601, 124, 3, 70, "MathCaption",
  CellTags->{"S5.82.1", "1.10"}],

Cell[CellGroupData[{
Cell[18560, 608, 176, 6, 70, "Input",
  CellTags->"S5.82.1"],
Cell[18739, 616, 158, 5, 70, "Print",
  CellTags->"S5.82.1"],
Cell[18900, 623, 206, 6, 70, "Print",
  CellTags->"S5.82.1"],
Cell[19109, 631, 180, 6, 70, "Print",
  CellTags->"S5.82.1"],
Cell[19292, 639, 198, 5, 70, "Print",
  CellTags->"S5.82.1"],
Cell[19493, 646, 180, 6, 70, "Print",
  CellTags->"S5.82.1"],
Cell[19676, 654, 202, 6, 70, "Print",
  CellTags->"S5.82.1"],
Cell[19881, 662, 179, 6, 70, "Print",
  CellTags->"S5.82.1"],
Cell[20063, 670, 179, 5, 70, "Print",
  CellTags->"S5.82.1"],
Cell[20245, 677, 199, 6, 70, "Print",
  CellTags->"S5.82.1"],
Cell[20447, 685, 196, 5, 70, "Print",
  CellTags->"S5.82.1"],
Cell[20646, 692, 200, 6, 70, "Print",
  CellTags->"S5.82.1"],
Cell[20849, 700, 192, 7, 70, "Output",
  CellTags->"S5.82.1"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

