(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     16724,        559]*)
(*NotebookOutlinePosition[     21314,        698]*)
(*  CellTagsIndexPosition[     20986,        681]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "NumericalMath",
 StyleBox["`", "MB"],
 "IntervalRoots",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.83.1", "1.1"}],

Cell[TextData[{
 "Interval methods in numerical computation provide a mechanism for verified \
calculation. With ordinary computer arithmetic you almost never know how much \
error is in the final result. With ",
 StyleBox["Mathematica", "TI"],
 "\[CloseCurlyQuote]s variable\[Hyphen]precision arithmetic this issue is \
addressed somewhat for basic arithmetic and the elementary functions, but no \
claim is made to rigor. With interval arithmetic absolute rigor is possible: \
the correct value is always maintained between two numbers, which are \
hopefully not too far apart. "
}], "Text",
 CellTags->{"S5.83.1", "1.2"}],

Cell[TextData[{
 "In addition to basic arithmetic, there are interval analogs of many of the \
standard algorithms of numerical analysis. The package ",
 StyleBox["NumericalMath`IntervalRoots`", "MR"],
 " provides three interval root\[Hyphen]finding methods: bisection, secant, \
and Newton\[CloseCurlyQuote]s method. A nice feature of interval \
root\[Hyphen]finding methods is that they find ",
 StyleBox["all", "TI"],
 " roots of the given function on a given interval. More precisely, they \
start with the given interval and discard parts of it that cannot possibly \
contain any roots. What you end up with are some subintervals of the given \
interval that are guaranteed to contain all of the roots that are contained \
in the the given interval. If the roots of the given interval are well \
separated then the result consists of short subintervals, each of which \
contains exactly one root. "
}], "Text",
 CellTags->{"S5.83.1", "1.3"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["IntervalBisection[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["int", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["eps", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["finds the roots of the function ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" of the variable ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" on the interval ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["int", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" to within tolerance ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["eps", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" using the interval bisection method",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["IntervalSecant[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["int", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["eps", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "finds the roots using the interval secant method",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["IntervalNewton[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["int", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["eps", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "finds the roots using the interval Newton method",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.83.1"],

Cell["\<\
Interval root\[Hyphen]finding methods. \
\>", "Caption",
 CellTags->"S5.83.1"],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["MaxRecursion", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "specifies the maximum level of recursion allowed",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["WorkingPrecision", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "specifies the precision to use in the calculations",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.83.1"],

Cell["\<\
Options for interval root\[Hyphen]finding methods.\
\>", "Caption",
 CellTags->"S5.83.1"],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.83.1", "1.4"}],

Cell["<<NumericalMath`IntervalRoots`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.83.1"],

Cell[TextData[{
 "This finds the roots of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"sin", 
    StyleBox["x",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " on the interval ",
 Cell[BoxData[
  FormBox[
   RowBox[{"[", 
    RowBox[{"2", ",", "8"}], "]"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and stops recursing when the subintervals have decreased to less than ",
 Cell[BoxData[
  FormBox["0.1", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.83.1", "1.5"}],

Cell[CellGroupData[{

Cell["IntervalBisection[Sin[x], x, Interval[{2., 8.}], .1]", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.83.1"],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3.1249999999999996`", ",", "3.2187500000000013`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6.218750000000003`", ",", "6.312500000000006`"}], "}"}]}], 
  "]"}]], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.83.1"]
}, Open  ]],

Cell[TextData[{
 "This attempts to find the roots with a smaller error tolerance. For each of \
the two roots ",
 StyleBox["MaxRecursion", "MR"],
 " is exceeded before the tolerance is achieved. "
}], "MathCaption",
 CellTags->{"S5.83.1", "1.6"}],

Cell[CellGroupData[{

Cell["IntervalBisection[Sin[x], x, Interval[{2., 8.}], .01]", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.83.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"IntervalBisection", "::", "\<\"rec\"\>"}], 
  RowBox[{":", " "}], "\<\"MaxRecursion exceeded.\"\>"}]], "Message",
 CellTags->"S5.83.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"IntervalBisection", "::", "\<\"rec\"\>"}], 
  RowBox[{":", " "}], "\<\"MaxRecursion exceeded.\"\>"}]], "Message",
 CellTags->"S5.83.1"],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3.124999999999999`", ",", "3.171875000000001`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6.2656250000000036`", ",", "6.312500000000007`"}], "}"}]}], 
  "]"}]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.83.1"]
}, Open  ]],

Cell[TextData[{
 "We can increase ",
 StyleBox["MaxRecursion", "MR"],
 " to achieve the smaller tolerance. "
}], "MathCaption",
 CellTags->{"S5.83.1", "1.7"}],

Cell[CellGroupData[{

Cell["\<\
IntervalBisection[Sin[x], x, Interval[{2., 8.}], .01,
           MaxRecursion -> 10]\
\>", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.83.1"],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3.1367187499999987`", ",", "3.1425781250000004`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6.277343750000003`", ",", "6.283203125000006`"}], "}"}]}], 
  "]"}]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.83.1"]
}, Open  ]],

Cell["\<\
The interval secant method converges more rapidly and does not need the extra \
recursion to achieve the same tolerance. \
\>", "MathCaption",
 CellTags->{"S5.83.1", "1.8"}],

Cell[CellGroupData[{

Cell["IntervalSecant[Sin[x], x, Interval[{2., 8.}], .01]", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.83.1"],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3.1415867482640145`", ",", "3.1415973603513447`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6.283158400943664`", ",", "6.283209401902729`"}], "}"}]}], 
  "]"}]], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S5.83.1"]
}, Open  ]],

Cell["\<\
The interval Newton\[CloseCurlyQuote]s method is used in the same way. \
\>", "MathCaption",
 CellTags->{"S5.83.1", "1.9"}],

Cell[CellGroupData[{

Cell["IntervalNewton[Sin[x], x, Interval[{2., 8.}], .01]", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.83.1"],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3.141297208703983`", ",", "3.141692880766018`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6.282778569085723`", ",", "6.290160459332559`"}], "}"}]}], 
  "]"}]], "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S5.83.1"]
}, Open  ]],

Cell["The working precision can be infinite. ", "MathCaption",
 CellTags->{"S5.83.1", "1.10"}],

Cell[CellGroupData[{

Cell["\<\
IntervalBisection[Sin[x], x, Interval[{2, 8}], .1,
           WorkingPrecision -> Infinity]\
\>", "Input",
 CellLabel->"In[7]:= ",
 CellTags->"S5.83.1"],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox["25", "8"], ",", 
     FractionBox["103", "32"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["199", "32"], ",", 
     FractionBox["101", "16"]}], "}"}]}], "]"}]], "Output",
 CellLabel->"Out[7]= ",
 CellTags->"S5.83.1"]
}, Open  ]],

Cell["\<\
Infinite precision with Newton\[CloseCurlyQuote]s method gives rather \
complicated results. \
\>", "MathCaption",
 CellTags->{"S5.83.1", "1.11"}],

Cell[CellGroupData[{

Cell["\<\
IntervalNewton[Sin[x], x, Interval[{2, 8}], .1,
           MaxRecursion -> 2,
           WorkingPrecision -> Infinity]\
\>", "Input",
 CellLabel->"In[8]:= ",
 CellTags->"S5.83.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"IntervalNewton", "::", "\<\"rec\"\>"}], 
  RowBox[{":", " "}], "\<\"MaxRecursion exceeded.\"\>"}]], "Message",
 CellTags->"S5.83.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"IntervalNewton", "::", "\<\"rec\"\>"}], 
  RowBox[{":", " "}], "\<\"MaxRecursion exceeded.\"\>"}]], "Message",
 CellTags->"S5.83.1"],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", 
         RowBox[{"Sin", "[", "5", "]"}]}], ")"}]}], "+", 
      RowBox[{"Sin", "[", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"7", "+", 
          RowBox[{"Sin", "[", "5", "]"}]}], ")"}]}], "]"}]}], ",", 
     RowBox[{
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", 
         RowBox[{"Sin", "[", "5", "]"}]}], ")"}]}], "-", 
      RowBox[{
       RowBox[{"Sec", "[", "2", "]"}], " ", 
       RowBox[{"Sin", "[", 
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"7", "+", 
           RowBox[{"Sin", "[", "5", "]"}]}], ")"}]}], "]"}]}]}]}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{
     RowBox[{"5", "-", 
      RowBox[{"Sin", "[", "5", "]"}]}], ",", 
     RowBox[{
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"13", "-", 
         RowBox[{"Sin", "[", "5", "]"}]}], ")"}]}], "-", 
      RowBox[{"Sin", "[", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"13", "-", 
          RowBox[{"Sin", "[", "5", "]"}]}], ")"}]}], "]"}]}]}], "}"}]}], 
  "]"}]], "Output",
 CellLabel->"Out[8]= ",
 CellTags->"S5.83.1"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.83.1"->{
    Cell[1776, 53, 143, 6, 36, "Subsection",
      CellTags->{"S5.83.1", "1.1"}],
    Cell[1922, 61, 624, 11, 104, "Text",
      CellTags->{"S5.83.1", "1.2"}],
    Cell[2549, 74, 946, 16, 136, "Text",
      CellTags->{"S5.83.1", "1.3"}],
    Cell[3498, 92, 4800, 148, 160, "DefinitionBox",
      CellTags->"S5.83.1"],
    Cell[8301, 242, 88, 3, 15, "Caption",
      CellTags->"S5.83.1"],
    Cell[8392, 247, 1200, 36, 66, "DefinitionBox",
      CellTags->"S5.83.1"],
    Cell[9595, 285, 99, 3, 15, "Caption",
      CellTags->"S5.83.1"],
    Cell[9697, 290, 78, 1, 40, "MathCaption",
      CellTags->{"S5.83.1", "1.4"}],
    Cell[9778, 293, 93, 2, 28, "Input",
      CellTags->"S5.83.1"],
    Cell[9874, 297, 632, 20, 56, "MathCaption",
      CellTags->{"S5.83.1", "1.5"}],
    Cell[10531, 321, 115, 2, 70, "Input",
      CellTags->"S5.83.1"],
    Cell[10649, 325, 302, 9, 70, "Output",
      CellTags->"S5.83.1"],
    Cell[10966, 337, 246, 6, 70, "MathCaption",
      CellTags->{"S5.83.1", "1.6"}],
    Cell[11237, 347, 116, 2, 70, "Input",
      CellTags->"S5.83.1"],
    Cell[11356, 351, 170, 4, 70, "Message",
      CellTags->"S5.83.1"],
    Cell[11529, 357, 170, 4, 70, "Message",
      CellTags->"S5.83.1"],
    Cell[11702, 363, 301, 9, 70, "Output",
      CellTags->"S5.83.1"],
    Cell[12018, 375, 158, 5, 70, "MathCaption",
      CellTags->{"S5.83.1", "1.7"}],
    Cell[12201, 384, 155, 5, 70, "Input",
      CellTags->"S5.83.1"],
    Cell[12359, 391, 302, 9, 70, "Output",
      CellTags->"S5.83.1"],
    Cell[12676, 403, 183, 4, 70, "MathCaption",
      CellTags->{"S5.83.1", "1.8"}],
    Cell[12884, 411, 113, 2, 70, "Input",
      CellTags->"S5.83.1"],
    Cell[13000, 415, 302, 9, 70, "Output",
      CellTags->"S5.83.1"],
    Cell[13317, 427, 133, 3, 70, "MathCaption",
      CellTags->{"S5.83.1", "1.9"}],
    Cell[13475, 434, 113, 2, 70, "Input",
      CellTags->"S5.83.1"],
    Cell[13591, 438, 300, 9, 70, "Output",
      CellTags->"S5.83.1"],
    Cell[13906, 450, 94, 1, 70, "MathCaption",
      CellTags->{"S5.83.1", "1.10"}],
    Cell[14025, 455, 162, 5, 70, "Input",
      CellTags->"S5.83.1"],
    Cell[14190, 462, 335, 12, 70, "Output",
      CellTags->"S5.83.1"],
    Cell[14540, 477, 156, 4, 70, "MathCaption",
      CellTags->{"S5.83.1", "1.11"}],
    Cell[14721, 485, 189, 6, 70, "Input",
      CellTags->"S5.83.1"],
    Cell[14913, 493, 167, 4, 70, "Message",
      CellTags->"S5.83.1"],
    Cell[15083, 499, 167, 4, 70, "Message",
      CellTags->"S5.83.1"],
    Cell[15253, 505, 1443, 50, 70, "Output",
      CellTags->"S5.83.1"]},
  "1.1"->{
    Cell[1776, 53, 143, 6, 36, "Subsection",
      CellTags->{"S5.83.1", "1.1"}]},
  "1.2"->{
    Cell[1922, 61, 624, 11, 104, "Text",
      CellTags->{"S5.83.1", "1.2"}]},
  "1.3"->{
    Cell[2549, 74, 946, 16, 136, "Text",
      CellTags->{"S5.83.1", "1.3"}]},
  "1.4"->{
    Cell[9697, 290, 78, 1, 40, "MathCaption",
      CellTags->{"S5.83.1", "1.4"}]},
  "1.5"->{
    Cell[9874, 297, 632, 20, 56, "MathCaption",
      CellTags->{"S5.83.1", "1.5"}]},
  "1.6"->{
    Cell[10966, 337, 246, 6, 70, "MathCaption",
      CellTags->{"S5.83.1", "1.6"}]},
  "1.7"->{
    Cell[12018, 375, 158, 5, 70, "MathCaption",
      CellTags->{"S5.83.1", "1.7"}]},
  "1.8"->{
    Cell[12676, 403, 183, 4, 70, "MathCaption",
      CellTags->{"S5.83.1", "1.8"}]},
  "1.9"->{
    Cell[13317, 427, 133, 3, 70, "MathCaption",
      CellTags->{"S5.83.1", "1.9"}]},
  "1.10"->{
    Cell[13906, 450, 94, 1, 70, "MathCaption",
      CellTags->{"S5.83.1", "1.10"}]},
  "1.11"->{
    Cell[14540, 477, 156, 4, 70, "MathCaption",
      CellTags->{"S5.83.1", "1.11"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.83.1", 17347, 575},
  {"1.1", 19921, 644},
  {"1.2", 20015, 647},
  {"1.3", 20105, 650},
  {"1.4", 20195, 653},
  {"1.5", 20290, 656},
  {"1.6", 20387, 659},
  {"1.7", 20484, 662},
  {"1.8", 20581, 665},
  {"1.9", 20678, 668},
  {"1.10", 20776, 671},
  {"1.11", 20874, 674}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 143, 6, 36, "Subsection",
  CellTags->{"S5.83.1", "1.1"}],
Cell[1922, 61, 624, 11, 104, "Text",
  CellTags->{"S5.83.1", "1.2"}],
Cell[2549, 74, 946, 16, 136, "Text",
  CellTags->{"S5.83.1", "1.3"}],
Cell[3498, 92, 4800, 148, 160, "DefinitionBox",
  CellTags->"S5.83.1"],
Cell[8301, 242, 88, 3, 15, "Caption",
  CellTags->"S5.83.1"],
Cell[8392, 247, 1200, 36, 66, "DefinitionBox",
  CellTags->"S5.83.1"],
Cell[9595, 285, 99, 3, 15, "Caption",
  CellTags->"S5.83.1"],
Cell[9697, 290, 78, 1, 40, "MathCaption",
  CellTags->{"S5.83.1", "1.4"}],
Cell[9778, 293, 93, 2, 28, "Input",
  CellTags->"S5.83.1"],
Cell[9874, 297, 632, 20, 56, "MathCaption",
  CellTags->{"S5.83.1", "1.5"}],

Cell[CellGroupData[{
Cell[10531, 321, 115, 2, 70, "Input",
  CellTags->"S5.83.1"],
Cell[10649, 325, 302, 9, 70, "Output",
  CellTags->"S5.83.1"]
}, Open  ]],
Cell[10966, 337, 246, 6, 70, "MathCaption",
  CellTags->{"S5.83.1", "1.6"}],

Cell[CellGroupData[{
Cell[11237, 347, 116, 2, 70, "Input",
  CellTags->"S5.83.1"],
Cell[11356, 351, 170, 4, 70, "Message",
  CellTags->"S5.83.1"],
Cell[11529, 357, 170, 4, 70, "Message",
  CellTags->"S5.83.1"],
Cell[11702, 363, 301, 9, 70, "Output",
  CellTags->"S5.83.1"]
}, Open  ]],
Cell[12018, 375, 158, 5, 70, "MathCaption",
  CellTags->{"S5.83.1", "1.7"}],

Cell[CellGroupData[{
Cell[12201, 384, 155, 5, 70, "Input",
  CellTags->"S5.83.1"],
Cell[12359, 391, 302, 9, 70, "Output",
  CellTags->"S5.83.1"]
}, Open  ]],
Cell[12676, 403, 183, 4, 70, "MathCaption",
  CellTags->{"S5.83.1", "1.8"}],

Cell[CellGroupData[{
Cell[12884, 411, 113, 2, 70, "Input",
  CellTags->"S5.83.1"],
Cell[13000, 415, 302, 9, 70, "Output",
  CellTags->"S5.83.1"]
}, Open  ]],
Cell[13317, 427, 133, 3, 70, "MathCaption",
  CellTags->{"S5.83.1", "1.9"}],

Cell[CellGroupData[{
Cell[13475, 434, 113, 2, 70, "Input",
  CellTags->"S5.83.1"],
Cell[13591, 438, 300, 9, 70, "Output",
  CellTags->"S5.83.1"]
}, Open  ]],
Cell[13906, 450, 94, 1, 70, "MathCaption",
  CellTags->{"S5.83.1", "1.10"}],

Cell[CellGroupData[{
Cell[14025, 455, 162, 5, 70, "Input",
  CellTags->"S5.83.1"],
Cell[14190, 462, 335, 12, 70, "Output",
  CellTags->"S5.83.1"]
}, Open  ]],
Cell[14540, 477, 156, 4, 70, "MathCaption",
  CellTags->{"S5.83.1", "1.11"}],

Cell[CellGroupData[{
Cell[14721, 485, 189, 6, 70, "Input",
  CellTags->"S5.83.1"],
Cell[14913, 493, 167, 4, 70, "Message",
  CellTags->"S5.83.1"],
Cell[15083, 499, 167, 4, 70, "Message",
  CellTags->"S5.83.1"],
Cell[15253, 505, 1443, 50, 70, "Output",
  CellTags->"S5.83.1"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

