(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    480207,      27060]*)
(*NotebookOutlinePosition[    519628,      28183]*)
(*  CellTagsIndexPosition[    516225,      28052]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 StyleBox["5.0 ", "HeadingNumber"],
 "Introduction"
}], "Section",
 CellTags->{"S5.0.0", "0.1"}],

Cell[CellGroupData[{

Cell["The Standard Add\[Hyphen]on Packages", "Subsection",
 CellTags->{"S5.0.1", "1.1"}],

Cell[TextData[{
 "The ",
 StyleBox["Mathematica", "TI"],
 " system contains a large number of built\[Hyphen]in functions. Most \
versions of ",
 StyleBox["Mathematica", "TI"],
 " also include a collection of standard add\[Hyphen]on packages that define \
many additional functions in areas such as algebra, calculus, graphics, \
discrete and numerical mathematics, number theory, and statistics. This book \
describes those functions. "
}], "Text",
 CellTags->{"S5.0.1", "1.2"}],

Cell[TextData[{
 "In addition to the standard add\[Hyphen]on packages, there are an immense \
number of specialized add\[Hyphen]ons available for ",
 StyleBox["Mathematica", "TI"],
 ". Some of these add\[Hyphen]ons are distributed by Wolfram Research; for a \
current listing, see our web site at ",
 ButtonBox["www.wolfram.com/products/applications",
  ButtonStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/products/applications"], None}],
 " or contact Wolfram Research. Many add\[Hyphen]ons are also available \
through the Mathematica Information Center at ",
 ButtonBox["library.wolfram.com",
  ButtonStyle->"Hyperlink",
  ButtonData->{
    URL["http://library.wolfram.com"], None}],
 ". "
}], "Text",
 CellTags->{"S5.0.1", "1.3"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[StyleBox["Algebra",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Calculus",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["DiscreteMath",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Geometry",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Graphics",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["LinearAlgebra",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Miscellaneous",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["NumberTheory",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["NumericalMath",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Statistics",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Utilities",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], "\[Null]"}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.0.1"],

Cell["\<\
Directories of standard add\[Hyphen]on packages.\
\>", "Caption",
 CellTags->"S5.0.1"],

Cell[TextData[{
 "The standard add\[Hyphen]on packages are divided into directories, each \
corresponding to a different topic. This introduction gives examples of the \
use of packages from each directory. Package functions are described in \
detail in the topic chapters. Functions that have made the transition from \
the standard add\[Hyphen]on packages to the ",
 StyleBox["Mathematica", "TI"],
 " kernel in Version 4.0, such as the Fourier, Laplace, and Z transforms, are \
also noted in the appropriate topic chapters. "
}], "Text",
 CellTags->{"S5.0.1", "1.4"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["<<", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dir", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["`", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["initialize all packages from directory ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dir", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["<<", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dir", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["`", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["package", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["`", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "read in a package from the named directory ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.0.1"],

Cell["\<\
Reading in standard add\[Hyphen]on packages.\
\>", "Caption",
 CellTags->"S5.0.1"],

Cell[TextData[{
 "Throughout this book, packages are specified with the backquote character \
(",
 StyleBox["`", "MR"],
 ") used in ",
 StyleBox["Mathematica", "TI"],
 " as a context mark. The appendices include information on contexts and how \
to set up ",
 StyleBox["Mathematica", "TI"],
 " packages. "
}], "Text",
 CellTags->{"S5.0.1", "1.5"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Algebra Packages", "Subsection",
 CellTags->{"S5.0.2", "2.1"}],

Cell[TextData[{
 StyleBox["Mathematica", "TI"],
 " provides many functions for working with polynomials, and the standard add\
\[Hyphen]on ",
 StyleBox["Algebra", "MR"],
 " packages extend that capability. There are functions for solving \
polynomial inequalities, counting and isolating roots of polynomials, and \
representing polynomials in terms of symmetric and remainder parts. The ",
 StyleBox["Algebra", "MR"],
 " packages define ",
 StyleBox["PolynomialExtendedGCD", "MR"],
 " and ",
 StyleBox["PolynomialPowerMod", "MR"],
 ", adjuncts to the built\[Hyphen]in functions ",
 StyleBox["PolynomialGCD", "MR"],
 " and ",
 StyleBox["PolynomialMod", "MR"],
 ". This group of packages also provides functions for manipulating \
quaternions and elements of Galois fields. "
}], "Text",
 CellTags->{"S5.0.2", "2.2"}],

Cell[TextData[{
 "This initializes the ",
 StyleBox["Algebra", "MR"],
 " packages. "
}], "MathCaption",
 CellTags->{"S5.0.2", "2.3"}],

Cell["<<Algebra`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.0.2"],

Cell[TextData[{
 "Define ",
 Cell[BoxData[
  FormBox[
   StyleBox["p",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " to be a fifth\[Hyphen]degree polynomial in ",
 Cell[BoxData[
  FormBox[
   StyleBox["x",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.0.2", "2.4"}],

Cell[CellGroupData[{

Cell["p = Expand[Product[x-j, {j, 5}]]", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.0.2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "120"}], "+", 
  RowBox[{"274", " ", "x"}], "-", 
  RowBox[{"225", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"85", " ", 
   SuperscriptBox["x", "3"]}], "-", 
  RowBox[{"15", " ", 
   SuperscriptBox["x", "4"]}], "+", 
  SuperscriptBox["x", "5"]}]], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.0.2"]
}, Open  ]],

Cell[TextData[{
 StyleBox["InequalitySolve", "MR"],
 " gives a logical expression representing the solution to this polynomial \
inequality. "
}], "MathCaption",
 CellTags->{"S5.0.2", "2.5"}],

Cell[CellGroupData[{

Cell["InequalitySolve[p < 0, x]", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.0.2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "<", "1"}], "||", 
  RowBox[{"2", "<", "x", "<", "3"}], "||", 
  RowBox[{"4", "<", "x", "<", "5"}]}]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.0.2"]
}, Open  ]],

Cell[TextData[{
 StyleBox["SemialgebraicComponents", "MR"],
 " gives a point in each connected component of the inequality solution set. \
"
}], "MathCaption",
 CellTags->{"S5.0.2", "2.6"}],

Cell[CellGroupData[{

Cell["SemialgebraicComponents[p < 0, x]", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.0.2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   FractionBox["91", "32"], ",", 
   FractionBox["33", "8"]}], "}"}]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.0.2"]
}, Open  ]],

Cell[TextData[{
 "Here ",
 StyleBox["CountRoots", "MR"],
 " gives the number of roots of ",
 Cell[BoxData[
  FormBox[
   StyleBox["p",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " in the interval ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"2.5", ",", "4.5"}], ")"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.0.2", "2.7"}],

Cell[CellGroupData[{

Cell["CountRoots[p, {x, 2.5, 4.5}]", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.0.2"],

Cell[BoxData["2"], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S5.0.2"]
}, Open  ]],

Cell[TextData[{
 "Quaternion numbers ",
 StyleBox["a", "TI"],
 StyleBox[" + I ", "MR"],
 StyleBox["b", "TI"],
 StyleBox[" + J ", "MR"],
 StyleBox["c", "TI"],
 StyleBox[" + K ", "MR"],
 StyleBox["d", "TI"],
 ", denoted by ",
 StyleBox["Quaternion[", "MR"],
 StyleBox["a", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["b", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["c", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["d", "TI"],
 StyleBox["]", "MR"],
 ", are an extension of the complex numbers ",
 StyleBox["a", "TI"],
 StyleBox[" + I ", "MR"],
 StyleBox["b", "TI"],
 ". "
}], "Text",
 CellTags->{"S5.0.2", "2.8"}],

Cell[TextData[{
 "Load the function ",
 StyleBox["ListPlotVectorField3D", "MR"],
 " for visualizing vector fields in three dimensions. "
}], "MathCaption",
 CellTags->{"S5.0.2", "2.9"}],

Cell["<<Graphics`PlotField3D`", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.0.2"],

Cell[TextData[{
 "Consider a set of 27 quaternions, each with a zero real part. This shows \
how the nonreal part of a quaternion ",
 Cell[BoxData[
  FormBox[
   StyleBox["q",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " from this set maps into the nonreal part of quaternion ",
 Cell[BoxData[
  FormBox[
   RowBox[{"exp", 
    RowBox[{"(", 
     StyleBox["q",
      "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.0.2", "2.10"}],

Cell[CellGroupData[{

Cell["\<\
ListPlotVectorField3D[
Flatten[
Table[ {{b, c, d},
  Apply[List, Rest[ Exp[Quaternion[0, b, c, d]] ]]},
  {b, 1, 3}, {c, 1, 3}, {d, 1, 3}], 2],
  VectorHeads->True, ScaleFactor->.5]\
\>", "Input",
 CellLabel->"In[7]:= ",
 CellTags->"S5.0.2"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.0859 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0568927 1.16638 -8.06646e-17 1.16638 [
[ 0 0 0 0 ]
[ 1 1.0859 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.08845 .24551 m
0 .80412 L
s
0 .80412 m
.40034 1.0859 L
s
.40034 1.0859 m
.41796 .58157 L
s
.41796 .58157 m
.08845 .24551 L
s
.67242 0 m
.92712 .41493 L
s
.92712 .41493 m
1 .94852 L
s
1 .94852 m
.70639 .58588 L
s
.70639 .58588 m
.67242 0 L
s
.08845 .24551 m
0 .80412 L
s
0 .80412 m
.70639 .58588 L
s
.70639 .58588 m
.67242 0 L
s
.67242 0 m
.08845 .24551 L
s
.41796 .58157 m
.92712 .41493 L
s
.92712 .41493 m
1 .94852 L
s
1 .94852 m
.40034 1.0859 L
s
.40034 1.0859 m
.41796 .58157 L
s
0 0 m
1 0 L
1 1.0859 L
0 1.0859 L
closepath
clip
newpath
.5 Mabswid
.45264 .60113 m
.43754 .58778 L
s
.44132 .58848 m
.44259 .58915 L
s
.43856 .59176 m
.44132 .58848 L
s
.44132 .58848 m
.43754 .58778 L
s
.43981 .59244 m
.43856 .59176 L
s
.43856 .59176 m
.43754 .58778 L
s
.43754 .58778 m
.43981 .59244 L
s
.43754 .58778 m
.44259 .58915 L
s
.44259 .58915 m
.43981 .59244 L
s
.6735 .53018 m
.61276 .49494 L
s
.62283 .50907 m
.61984 .50767 L
s
.61984 .50767 m
.62711 .49502 L
s
.61984 .50767 m
.61276 .49494 L
s
.62711 .49502 m
.63014 .49634 L
s
.62711 .49502 m
.61276 .49494 L
s
.61276 .49494 m
.62283 .50907 L
s
.61276 .49494 m
.63014 .49634 L
s
.63014 .49634 m
.62283 .50907 L
s
.44764 .81275 m
.40159 .75668 L
s
.41537 .76235 m
.41776 .76387 L
s
.40395 .77198 m
.41537 .76235 L
s
.41537 .76235 m
.40159 .75668 L
s
.40628 .77356 m
.40395 .77198 L
s
.40395 .77198 m
.40159 .75668 L
s
.37653 .50185 m
.36562 .51476 L
s
.3783 .50263 m
.37653 .50185 L
s
.37653 .50185 m
.38469 .51952 L
s
.36562 .51476 m
.36732 .51562 L
s
.38469 .51952 m
.36562 .51476 L
s
.40159 .75668 m
.40628 .77356 L
s
.40159 .75668 m
.41776 .76387 L
s
.41776 .76387 m
.40628 .77356 L
s
.38469 .51952 m
.36732 .51562 L
s
.3783 .50263 m
.38469 .51952 L
s
.32062 .46519 m
.38469 .51952 L
s
.36732 .51562 m
.3783 .50263 L
s
.81965 .42994 m
.81527 .42841 L
s
.81527 .42841 m
.8246 .40483 L
s
.81527 .42841 m
.799 .4084 L
s
.8246 .40483 m
.82909 .40609 L
s
.8246 .40483 m
.799 .4084 L
s
.91423 .45284 m
.799 .4084 L
s
.799 .4084 m
.81965 .42994 L
s
.799 .4084 m
.82909 .40609 L
s
.82909 .40609 m
.81965 .42994 L
s
.60737 .69912 m
.60594 .69716 L
s
.60594 .69716 m
.62042 .67951 L
s
.60594 .69716 m
.59639 .67492 L
s
.62042 .67951 m
.62201 .68128 L
s
.62042 .67951 m
.59639 .67492 L
s
.68394 .74652 m
.59639 .67492 L
s
.59639 .67492 m
.60737 .69912 L
s
.59639 .67492 m
.62201 .68128 L
s
.62201 .68128 m
.60737 .69912 L
s
.56766 .39023 m
.56764 .39028 L
s
.56936 .38665 m
.56766 .39023 L
s
.57203 .39014 m
.56766 .39023 L
s
.56933 .3867 m
.56936 .38665 L
s
.56936 .38665 m
.57203 .39014 L
s
.57203 .39014 m
.56764 .39028 L
s
.56933 .3867 m
.57203 .39014 L
s
.55438 .38175 m
.57203 .39014 L
s
.56764 .39028 m
.56933 .3867 L
s
.39663 .95768 m
.39855 .95967 L
s
.37427 .97213 m
.39663 .95768 L
s
.39663 .95768 m
.37246 .94364 L
s
.37593 .9743 m
.37427 .97213 L
s
.37427 .97213 m
.37246 .94364 L
s
.37246 .94364 m
.37593 .9743 L
s
.37246 .94364 m
.39855 .95967 L
s
.44192 1.05515 m
.37246 .94364 L
s
.39855 .95967 m
.37593 .9743 L
s
.8366 .63071 m
.83522 .62826 L
s
.83522 .62826 m
.84967 .6035 L
s
.83522 .62826 m
.81827 .60285 L
s
.31692 .69704 m
.31369 .69952 L
s
.31662 .69693 m
.31692 .69704 L
s
.31692 .69704 m
.31759 .7014 L
s
.31369 .69952 m
.31339 .69941 L
s
.31759 .7014 m
.31369 .69952 L
s
.84967 .6035 m
.85124 .60563 L
s
.84967 .6035 m
.81827 .60285 L
s
.30544 .68551 m
.31759 .7014 L
s
.31759 .7014 m
.31339 .69941 L
s
.31662 .69693 m
.31759 .7014 L
s
.31339 .69941 m
.31662 .69693 L
s
.81827 .60285 m
.8366 .63071 L
s
.81827 .60285 m
.85124 .60563 L
s
.94308 .67389 m
.81827 .60285 L
s
.85124 .60563 m
.8366 .63071 L
s
.16487 .30481 m
.27378 .38875 L
s
.24793 .38482 m
.23891 .38222 L
s
.26462 .36157 m
.24793 .38482 L
s
.27378 .38875 m
.24793 .38482 L
s
.74512 .28135 m
.7456 .28147 L
s
.7456 .28147 m
.75 .26539 L
s
.7456 .28147 m
.73174 .26916 L
s
.75 .26539 m
.74956 .26515 L
s
.75 .26539 m
.73174 .26916 L
s
.25578 .35867 m
.26462 .36157 L
s
.26462 .36157 m
.27378 .38875 L
s
.73174 .26916 m
.74512 .28135 L
s
.73174 .26916 m
.74956 .26515 L
s
.81108 .29013 m
.73174 .26916 L
s
.60443 .92026 m
.60546 .91757 L
s
.60546 .91757 m
.6269 .89758 L
s
.60546 .91757 m
.59579 .88721 L
s
.6269 .89758 m
.62615 .90001 L
s
.6269 .89758 m
.59579 .88721 L
s
.74956 .26515 m
.74512 .28135 L
s
.27378 .38875 m
.23891 .38222 L
s
.25578 .35867 m
.27378 .38875 L
s
.59579 .88721 m
.60443 .92026 L
s
.59579 .88721 m
.62615 .90001 L
s
.69598 .99589 m
.59579 .88721 L
s
.23891 .38222 m
.25578 .35867 L
s
.62615 .90001 m
.60443 .92026 L
s
.52322 .58769 m
.52504 .5877 L
s
.52504 .5877 m
.53068 .58012 L
s
.52504 .5877 m
.51958 .57821 L
s
.53068 .58012 m
.52888 .58007 L
s
.53068 .58012 m
.51958 .57821 L
s
.51958 .57821 m
.52322 .58769 L
s
.51958 .57821 m
.52888 .58007 L
s
.55656 .60671 m
.51958 .57821 L
s
.52888 .58007 m
.52322 .58769 L
s
.41275 .20527 m
.50067 .23143 L
s
.26466 .87661 m
.26166 .87543 L
s
.2495 .88522 m
.26466 .87661 L
s
.26466 .87661 m
.24755 .8653 L
s
.24639 .88411 m
.2495 .88522 L
s
.2495 .88522 m
.24755 .8653 L
s
.48359 .2361 m
.47708 .2354 L
s
.48874 .21697 m
.48359 .2361 L
s
.50067 .23143 m
.48359 .2361 L
s
.24755 .8653 m
.24639 .88411 L
s
.24755 .8653 m
.26166 .87543 L
s
.28784 .94096 m
.24755 .8653 L
s
.48225 .21611 m
.48874 .21697 L
s
.48874 .21697 m
.50067 .23143 L
s
.87934 .87478 m
.88036 .87145 L
s
.88036 .87145 m
.89702 .85006 L
s
.88036 .87145 m
.86634 .84549 L
s
.89702 .85006 m
.8962 .85315 L
s
.89702 .85006 m
.86634 .84549 L
s
.26166 .87543 m
.24639 .88411 L
s
.86634 .84549 m
.87934 .87478 L
s
.86634 .84549 m
.8962 .85315 L
s
.97656 .93045 m
.86634 .84549 L
s
.50067 .23143 m
.47708 .2354 L
s
.48225 .21611 m
.50067 .23143 L
s
.47708 .2354 m
.48225 .21611 L
s
.8962 .85315 m
.87934 .87478 L
s
.73317 .48695 m
.73809 .48634 L
s
.73809 .48634 m
.74908 .46284 L
s
.73809 .48634 m
.71817 .4638 L
s
.74908 .46284 m
.74427 .46319 L
s
.74908 .46284 m
.71817 .4638 L
s
.71817 .4638 m
.73317 .48695 L
s
.71817 .4638 m
.74427 .46319 L
s
.83433 .51955 m
.71817 .4638 L
s
.1356 .53355 m
.18541 .6091 L
s
.74427 .46319 m
.73317 .48695 L
s
.17295 .60186 m
.16285 .59858 L
s
.18771 .58907 m
.17295 .60186 L
s
.18541 .6091 m
.17295 .60186 L
s
.17772 .58567 m
.18771 .58907 L
s
.18771 .58907 m
.18541 .6091 L
s
.18541 .6091 m
.16285 .59858 L
s
.17772 .58567 m
.18541 .6091 L
s
.16285 .59858 m
.17772 .58567 L
s
.4754 .80047 m
.48374 .8006 L
s
.48374 .8006 m
.50221 .78215 L
s
.48374 .8006 m
.47159 .77202 L
s
.50221 .78215 m
.49407 .7818 L
s
.50221 .78215 m
.47159 .77202 L
s
.66501 .09599 m
.66655 .09624 L
s
.66655 .09624 m
.6671 .09054 L
s
.66655 .09624 m
.66075 .09283 L
s
.6671 .09054 m
.66556 .09028 L
s
.6671 .09054 m
.66075 .09283 L
s
.66075 .09283 m
.66501 .09599 L
s
.66075 .09283 m
.66556 .09028 L
s
.68737 .095 m
.66075 .09283 L
s
.47159 .77202 m
.4754 .80047 L
s
.47159 .77202 m
.49407 .7818 L
s
.5591 .86949 m
.47159 .77202 L
s
.66556 .09028 m
.66501 .09599 L
s
.49407 .7818 m
.4754 .80047 L
s
.40304 .43822 m
.41988 .4498 L
s
.41674 .4496 m
.41421 .44944 L
s
.41878 .44552 m
.41674 .4496 L
s
.41988 .4498 m
.41674 .4496 L
s
.41626 .44535 m
.41878 .44552 L
s
.41878 .44552 m
.41988 .4498 L
s
.41421 .44944 m
.41626 .44535 L
s
.41988 .4498 m
.41421 .44944 L
s
.41626 .44535 m
.41988 .4498 L
s
.73848 .72581 m
.74855 .72393 L
s
.74855 .72393 m
.76661 .69639 L
s
.74855 .72393 m
.72599 .6918 L
s
.76661 .69639 m
.75676 .69789 L
s
.76661 .69639 m
.72599 .6918 L
s
.72599 .6918 m
.73848 .72581 L
s
.72599 .6918 m
.75676 .69789 L
s
.86171 .78975 m
.72599 .6918 L
s
.08947 .78376 m
.0929 .78487 L
s
.0929 .78487 m
.09748 .78181 L
s
.0929 .78487 m
.09157 .77785 L
s
.09157 .77785 m
.08947 .78376 L
s
.09748 .78181 m
.09157 .77785 L
s
.09157 .77785 m
.09406 .78068 L
s
.10117 .80262 m
.09157 .77785 L
s
.09748 .78181 m
.09406 .78068 L
s
.75676 .69789 m
.73848 .72581 L
s
.09406 .78068 m
.08947 .78376 L
s
.62782 .31822 m
.63671 .31805 L
s
.63671 .31805 m
.64183 .29925 L
s
.63671 .31805 m
.61838 .30308 L
s
.61838 .30308 m
.62782 .31822 L
s
.64183 .29925 m
.61838 .30308 L
s
.61838 .30308 m
.63295 .29928 L
s
.70195 .33167 m
.61838 .30308 L
s
.64183 .29925 m
.63295 .29928 L
s
.63295 .29928 m
.62782 .31822 L
s
.33432 .66902 m
.34752 .66973 L
s
.34752 .66973 m
.35792 .6545 L
s
.34752 .66973 m
.33504 .64878 L
s
.33504 .64878 m
.33432 .66902 L
s
.35792 .6545 m
.33504 .64878 L
s
.33504 .64878 m
.34476 .65368 L
s
.39152 .71472 m
.33504 .64878 L
s
.35792 .6545 m
.34476 .65368 L
s
.34476 .65368 m
.33432 .66902 L
s
.59735 .56377 m
.61748 .56219 L
s
.61748 .56219 m
.63042 .53141 L
s
.61748 .56219 m
.58859 .53121 L
s
.58859 .53121 m
.59735 .56377 L
s
.63042 .53141 m
.58859 .53121 L
s
.58859 .53121 m
.61036 .53262 L
s
.71943 .61546 m
.58859 .53121 L
s
.63042 .53141 m
.61036 .53262 L
s
.61036 .53262 m
.59735 .56377 L
s
.25 Mabswid
.67242 0 m
.92712 .41493 L
s
.92712 .41493 m
1 .94852 L
s
1 .94852 m
.70639 .58588 L
s
.70639 .58588 m
.67242 0 L
s
.08845 .24551 m
0 .80412 L
s
0 .80412 m
.70639 .58588 L
s
.70639 .58588 m
.67242 0 L
s
.67242 0 m
.08845 .24551 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.0.2"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics3D", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[7]= ",
 CellTags->"S5.0.2"]
}, Open  ]],

Cell[TextData[{
 "The ",
 StyleBox["FiniteFields", "MR"],
 " package can be used to explore error\[Hyphen]correcting codes for digital \
transmission and storage, and for other applications of Galois sequences. For \
example, the Simplex Code based on ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["GF",
     "TI"], 
    RowBox[{"(", 
     SuperscriptBox["2", 
      StyleBox["m",
       "TI"]], ")"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", a finite field of order ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["2", 
    StyleBox["m",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", has efficiency ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["m",
     "TI"], "/", 
    SuperscriptBox["2", 
     StyleBox["m",
      "TI"]]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and detects ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["2", 
    RowBox[{
     StyleBox["m",
      "TI"], "-", "2"}]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " errors per codeword of length ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["2", 
     StyleBox["m",
      "TI"]], "-", "1"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "Text",
 CellTags->{"S5.0.2", "2.11"}],

Cell[TextData[{
 "This gives the Galois sequence for ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["GF",
     "TI"], 
    RowBox[{"(", 
     SuperscriptBox["2", "4"], ")"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.0.2", "2.12"}],

Cell[CellGroupData[{

Cell["sequence = First[Transpose[PowerList[GF[2, 4]]]]", "Input",
 CellLabel->"In[8]:= ",
 CellTags->"S5.0.2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "0", ",", "0", ",", "0", ",", "1", ",", "1", ",", "1", ",", "1", 
   ",", "0", ",", "1", ",", "0", ",", "1", ",", "1", ",", "0", ",", "0"}], 
  "}"}]], "Output",
 CellLabel->"Out[8]= ",
 CellTags->"S5.0.2"]
}, Open  ]],

Cell["\<\
This depicts the 15 codewords, each composed of four information bits and 11 \
check bits. Binary ones appear as white squares and binary zeros appear as \
black squares. \
\>", "MathCaption",
 CellTags->{"S5.0.2", "2.13"}],

Cell[CellGroupData[{

Cell["\<\
(codewords = Table[RotateRight[sequence, n],
  {n, 0, 14}];
ListDensityPlot[codewords,
  FrameTicks -> {{4, 15}, Range[15]}])\
\>", "Input",
 CellLabel->"In[9]:= ",
 CellTags->"S5.0.2"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.0641026 0.0192308 0.0641026 [
[.27564 -0.0125 -3 -9 ]
[.27564 -0.0125 3 0 ]
[.98077 -0.0125 -6 -9 ]
[.98077 -0.0125 6 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .08333 -6 -4.5 ]
[-0.0125 .08333 0 4.5 ]
[-0.0125 .14744 -6 -4.5 ]
[-0.0125 .14744 0 4.5 ]
[-0.0125 .21154 -6 -4.5 ]
[-0.0125 .21154 0 4.5 ]
[-0.0125 .27564 -6 -4.5 ]
[-0.0125 .27564 0 4.5 ]
[-0.0125 .33974 -6 -4.5 ]
[-0.0125 .33974 0 4.5 ]
[-0.0125 .40385 -6 -4.5 ]
[-0.0125 .40385 0 4.5 ]
[-0.0125 .46795 -6 -4.5 ]
[-0.0125 .46795 0 4.5 ]
[-0.0125 .53205 -6 -4.5 ]
[-0.0125 .53205 0 4.5 ]
[-0.0125 .59615 -6 -4.5 ]
[-0.0125 .59615 0 4.5 ]
[-0.0125 .66026 -12 -4.5 ]
[-0.0125 .66026 0 4.5 ]
[-0.0125 .72436 -12 -4.5 ]
[-0.0125 .72436 0 4.5 ]
[-0.0125 .78846 -12 -4.5 ]
[-0.0125 .78846 0 4.5 ]
[-0.0125 .85256 -12 -4.5 ]
[-0.0125 .85256 0 4.5 ]
[-0.0125 .91667 -12 -4.5 ]
[-0.0125 .91667 0 4.5 ]
[-0.0125 .98077 -12 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[.27564 1.0125 -3 0 ]
[.27564 1.0125 3 9 ]
[.98077 1.0125 -6 0 ]
[.98077 1.0125 6 9 ]
[ 0 1 .125 0 ]
[1.0125 .08333 0 -4.5 ]
[1.0125 .08333 6 4.5 ]
[1.0125 .14744 0 -4.5 ]
[1.0125 .14744 6 4.5 ]
[1.0125 .21154 0 -4.5 ]
[1.0125 .21154 6 4.5 ]
[1.0125 .27564 0 -4.5 ]
[1.0125 .27564 6 4.5 ]
[1.0125 .33974 0 -4.5 ]
[1.0125 .33974 6 4.5 ]
[1.0125 .40385 0 -4.5 ]
[1.0125 .40385 6 4.5 ]
[1.0125 .46795 0 -4.5 ]
[1.0125 .46795 6 4.5 ]
[1.0125 .53205 0 -4.5 ]
[1.0125 .53205 6 4.5 ]
[1.0125 .59615 0 -4.5 ]
[1.0125 .59615 6 4.5 ]
[1.0125 .66026 0 -4.5 ]
[1.0125 .66026 12 4.5 ]
[1.0125 .72436 0 -4.5 ]
[1.0125 .72436 12 4.5 ]
[1.0125 .78846 0 -4.5 ]
[1.0125 .78846 12 4.5 ]
[1.0125 .85256 0 -4.5 ]
[1.0125 .85256 12 4.5 ]
[1.0125 .91667 0 -4.5 ]
[1.0125 .91667 12 4.5 ]
[1.0125 .98077 0 -4.5 ]
[1.0125 .98077 12 4.5 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.27564 0 m
.27564 .00625 L
s
[(4)] .27564 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(15)] .98077 -0.0125 0 1 Mshowa
0 0 m
1 0 L
s
0 .08333 m
.00625 .08333 L
s
[(1)] -0.0125 .08333 1 0 Mshowa
0 .14744 m
.00625 .14744 L
s
[(2)] -0.0125 .14744 1 0 Mshowa
0 .21154 m
.00625 .21154 L
s
[(3)] -0.0125 .21154 1 0 Mshowa
0 .27564 m
.00625 .27564 L
s
[(4)] -0.0125 .27564 1 0 Mshowa
0 .33974 m
.00625 .33974 L
s
[(5)] -0.0125 .33974 1 0 Mshowa
0 .40385 m
.00625 .40385 L
s
[(6)] -0.0125 .40385 1 0 Mshowa
0 .46795 m
.00625 .46795 L
s
[(7)] -0.0125 .46795 1 0 Mshowa
0 .53205 m
.00625 .53205 L
s
[(8)] -0.0125 .53205 1 0 Mshowa
0 .59615 m
.00625 .59615 L
s
[(9)] -0.0125 .59615 1 0 Mshowa
0 .66026 m
.00625 .66026 L
s
[(10)] -0.0125 .66026 1 0 Mshowa
0 .72436 m
.00625 .72436 L
s
[(11)] -0.0125 .72436 1 0 Mshowa
0 .78846 m
.00625 .78846 L
s
[(12)] -0.0125 .78846 1 0 Mshowa
0 .85256 m
.00625 .85256 L
s
[(13)] -0.0125 .85256 1 0 Mshowa
0 .91667 m
.00625 .91667 L
s
[(14)] -0.0125 .91667 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(15)] -0.0125 .98077 1 0 Mshowa
0 0 m
0 1 L
s
.27564 .99375 m
.27564 1 L
s
[(4)] .27564 1.0125 0 -1 Mshowa
.98077 .99375 m
.98077 1 L
s
[(15)] .98077 1.0125 0 -1 Mshowa
0 1 m
1 1 L
s
.99375 .08333 m
1 .08333 L
s
[(1)] 1.0125 .08333 -1 0 Mshowa
.99375 .14744 m
1 .14744 L
s
[(2)] 1.0125 .14744 -1 0 Mshowa
.99375 .21154 m
1 .21154 L
s
[(3)] 1.0125 .21154 -1 0 Mshowa
.99375 .27564 m
1 .27564 L
s
[(4)] 1.0125 .27564 -1 0 Mshowa
.99375 .33974 m
1 .33974 L
s
[(5)] 1.0125 .33974 -1 0 Mshowa
.99375 .40385 m
1 .40385 L
s
[(6)] 1.0125 .40385 -1 0 Mshowa
.99375 .46795 m
1 .46795 L
s
[(7)] 1.0125 .46795 -1 0 Mshowa
.99375 .53205 m
1 .53205 L
s
[(8)] 1.0125 .53205 -1 0 Mshowa
.99375 .59615 m
1 .59615 L
s
[(9)] 1.0125 .59615 -1 0 Mshowa
.99375 .66026 m
1 .66026 L
s
[(10)] 1.0125 .66026 -1 0 Mshowa
.99375 .72436 m
1 .72436 L
s
[(11)] 1.0125 .72436 -1 0 Mshowa
.99375 .78846 m
1 .78846 L
s
[(12)] 1.0125 .78846 -1 0 Mshowa
.99375 .85256 m
1 .85256 L
s
[(13)] 1.0125 .85256 -1 0 Mshowa
.99375 .91667 m
1 .91667 L
s
[(14)] 1.0125 .91667 -1 0 Mshowa
.99375 .98077 m
1 .98077 L
s
[(15)] 1.0125 .98077 -1 0 Mshowa
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
15 string
15 15 8 [15 0 0 15 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FF000000FFFFFFFF00FF00FFFF0000
00FF000000FFFFFFFF00FF00FFFF00
0000FF000000FFFFFFFF00FF00FFFF
FF0000FF000000FFFFFFFF00FF00FF
FFFF0000FF000000FFFFFFFF00FF00
00FFFF0000FF000000FFFFFFFF00FF
FF00FFFF0000FF000000FFFFFFFF00
00FF00FFFF0000FF000000FFFFFFFF
FF00FF00FFFF0000FF000000FFFFFF
FFFF00FF00FFFF0000FF000000FFFF
FFFFFF00FF00FFFF0000FF000000FF
FFFFFFFF00FF00FFFF0000FF000000
00FFFFFFFF00FF00FFFF0000FF0000
0000FFFFFFFF00FF00FFFF0000FF00
000000FFFFFFFF00FF00FFFF0000FF
pop
P
% End of image
.01923 .01923 m
.01923 .98077 L
s
.08333 .01923 m
.08333 .98077 L
s
.14744 .01923 m
.14744 .98077 L
s
.21154 .01923 m
.21154 .98077 L
s
.27564 .01923 m
.27564 .98077 L
s
.33974 .01923 m
.33974 .98077 L
s
.40385 .01923 m
.40385 .98077 L
s
.46795 .01923 m
.46795 .98077 L
s
.53205 .01923 m
.53205 .98077 L
s
.59615 .01923 m
.59615 .98077 L
s
.66026 .01923 m
.66026 .98077 L
s
.72436 .01923 m
.72436 .98077 L
s
.78846 .01923 m
.78846 .98077 L
s
.85256 .01923 m
.85256 .98077 L
s
.91667 .01923 m
.91667 .98077 L
s
.98077 .01923 m
.98077 .98077 L
s
.01923 .01923 m
.98077 .01923 L
s
.01923 .08333 m
.98077 .08333 L
s
.01923 .14744 m
.98077 .14744 L
s
.01923 .21154 m
.98077 .21154 L
s
.01923 .27564 m
.98077 .27564 L
s
.01923 .33974 m
.98077 .33974 L
s
.01923 .40385 m
.98077 .40385 L
s
.01923 .46795 m
.98077 .46795 L
s
.01923 .53205 m
.98077 .53205 L
s
.01923 .59615 m
.98077 .59615 L
s
.01923 .66026 m
.98077 .66026 L
s
.01923 .72436 m
.98077 .72436 L
s
.01923 .78846 m
.98077 .78846 L
s
.01923 .85256 m
.98077 .85256 L
s
.01923 .91667 m
.98077 .91667 L
s
.01923 .98077 m
.98077 .98077 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.0.2"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "DensityGraphics", "\[SkeletonIndicator]"}],
  
  False,
  Editable->False]], "Output",
 CellLabel->"Out[9]= ",
 CellTags->"S5.0.2"]
}, Open  ]],

Cell["\<\
Here are the codewords after transmission through a channel that \
\[OpenCurlyDoubleQuote]flips\[CloseCurlyDoubleQuote] each bit with a \
probability of 0.25. Bits that differ from the original codewords are shaded \
gray. \
\>", "MathCaption",
 CellTags->{"S5.0.2", "2.14"}],

Cell[CellGroupData[{

Cell["\<\
(received = Map[If[Random[] < .25, Mod[#+1, 2], #]&,
  codewords, {2}];
delta = Abs[received-codewords];
ListDensityPlot[Table[If[delta[[i, j]] == 1,
  .5, codewords[[i, j]] ], {i, 15}, {j, 15}],
  FrameTicks -> {{4, 15}, Range[15]}])\
\>", "Input",
 CellLabel->"In[10]:= ",
 CellTags->"S5.0.2"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.0641026 0.0192308 0.0641026 [
[.27564 -0.0125 -3 -9 ]
[.27564 -0.0125 3 0 ]
[.98077 -0.0125 -6 -9 ]
[.98077 -0.0125 6 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .08333 -6 -4.5 ]
[-0.0125 .08333 0 4.5 ]
[-0.0125 .14744 -6 -4.5 ]
[-0.0125 .14744 0 4.5 ]
[-0.0125 .21154 -6 -4.5 ]
[-0.0125 .21154 0 4.5 ]
[-0.0125 .27564 -6 -4.5 ]
[-0.0125 .27564 0 4.5 ]
[-0.0125 .33974 -6 -4.5 ]
[-0.0125 .33974 0 4.5 ]
[-0.0125 .40385 -6 -4.5 ]
[-0.0125 .40385 0 4.5 ]
[-0.0125 .46795 -6 -4.5 ]
[-0.0125 .46795 0 4.5 ]
[-0.0125 .53205 -6 -4.5 ]
[-0.0125 .53205 0 4.5 ]
[-0.0125 .59615 -6 -4.5 ]
[-0.0125 .59615 0 4.5 ]
[-0.0125 .66026 -12 -4.5 ]
[-0.0125 .66026 0 4.5 ]
[-0.0125 .72436 -12 -4.5 ]
[-0.0125 .72436 0 4.5 ]
[-0.0125 .78846 -12 -4.5 ]
[-0.0125 .78846 0 4.5 ]
[-0.0125 .85256 -12 -4.5 ]
[-0.0125 .85256 0 4.5 ]
[-0.0125 .91667 -12 -4.5 ]
[-0.0125 .91667 0 4.5 ]
[-0.0125 .98077 -12 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[.27564 1.0125 -3 0 ]
[.27564 1.0125 3 9 ]
[.98077 1.0125 -6 0 ]
[.98077 1.0125 6 9 ]
[ 0 1 .125 0 ]
[1.0125 .08333 0 -4.5 ]
[1.0125 .08333 6 4.5 ]
[1.0125 .14744 0 -4.5 ]
[1.0125 .14744 6 4.5 ]
[1.0125 .21154 0 -4.5 ]
[1.0125 .21154 6 4.5 ]
[1.0125 .27564 0 -4.5 ]
[1.0125 .27564 6 4.5 ]
[1.0125 .33974 0 -4.5 ]
[1.0125 .33974 6 4.5 ]
[1.0125 .40385 0 -4.5 ]
[1.0125 .40385 6 4.5 ]
[1.0125 .46795 0 -4.5 ]
[1.0125 .46795 6 4.5 ]
[1.0125 .53205 0 -4.5 ]
[1.0125 .53205 6 4.5 ]
[1.0125 .59615 0 -4.5 ]
[1.0125 .59615 6 4.5 ]
[1.0125 .66026 0 -4.5 ]
[1.0125 .66026 12 4.5 ]
[1.0125 .72436 0 -4.5 ]
[1.0125 .72436 12 4.5 ]
[1.0125 .78846 0 -4.5 ]
[1.0125 .78846 12 4.5 ]
[1.0125 .85256 0 -4.5 ]
[1.0125 .85256 12 4.5 ]
[1.0125 .91667 0 -4.5 ]
[1.0125 .91667 12 4.5 ]
[1.0125 .98077 0 -4.5 ]
[1.0125 .98077 12 4.5 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.27564 0 m
.27564 .00625 L
s
[(4)] .27564 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(15)] .98077 -0.0125 0 1 Mshowa
0 0 m
1 0 L
s
0 .08333 m
.00625 .08333 L
s
[(1)] -0.0125 .08333 1 0 Mshowa
0 .14744 m
.00625 .14744 L
s
[(2)] -0.0125 .14744 1 0 Mshowa
0 .21154 m
.00625 .21154 L
s
[(3)] -0.0125 .21154 1 0 Mshowa
0 .27564 m
.00625 .27564 L
s
[(4)] -0.0125 .27564 1 0 Mshowa
0 .33974 m
.00625 .33974 L
s
[(5)] -0.0125 .33974 1 0 Mshowa
0 .40385 m
.00625 .40385 L
s
[(6)] -0.0125 .40385 1 0 Mshowa
0 .46795 m
.00625 .46795 L
s
[(7)] -0.0125 .46795 1 0 Mshowa
0 .53205 m
.00625 .53205 L
s
[(8)] -0.0125 .53205 1 0 Mshowa
0 .59615 m
.00625 .59615 L
s
[(9)] -0.0125 .59615 1 0 Mshowa
0 .66026 m
.00625 .66026 L
s
[(10)] -0.0125 .66026 1 0 Mshowa
0 .72436 m
.00625 .72436 L
s
[(11)] -0.0125 .72436 1 0 Mshowa
0 .78846 m
.00625 .78846 L
s
[(12)] -0.0125 .78846 1 0 Mshowa
0 .85256 m
.00625 .85256 L
s
[(13)] -0.0125 .85256 1 0 Mshowa
0 .91667 m
.00625 .91667 L
s
[(14)] -0.0125 .91667 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(15)] -0.0125 .98077 1 0 Mshowa
0 0 m
0 1 L
s
.27564 .99375 m
.27564 1 L
s
[(4)] .27564 1.0125 0 -1 Mshowa
.98077 .99375 m
.98077 1 L
s
[(15)] .98077 1.0125 0 -1 Mshowa
0 1 m
1 1 L
s
.99375 .08333 m
1 .08333 L
s
[(1)] 1.0125 .08333 -1 0 Mshowa
.99375 .14744 m
1 .14744 L
s
[(2)] 1.0125 .14744 -1 0 Mshowa
.99375 .21154 m
1 .21154 L
s
[(3)] 1.0125 .21154 -1 0 Mshowa
.99375 .27564 m
1 .27564 L
s
[(4)] 1.0125 .27564 -1 0 Mshowa
.99375 .33974 m
1 .33974 L
s
[(5)] 1.0125 .33974 -1 0 Mshowa
.99375 .40385 m
1 .40385 L
s
[(6)] 1.0125 .40385 -1 0 Mshowa
.99375 .46795 m
1 .46795 L
s
[(7)] 1.0125 .46795 -1 0 Mshowa
.99375 .53205 m
1 .53205 L
s
[(8)] 1.0125 .53205 -1 0 Mshowa
.99375 .59615 m
1 .59615 L
s
[(9)] 1.0125 .59615 -1 0 Mshowa
.99375 .66026 m
1 .66026 L
s
[(10)] 1.0125 .66026 -1 0 Mshowa
.99375 .72436 m
1 .72436 L
s
[(11)] 1.0125 .72436 -1 0 Mshowa
.99375 .78846 m
1 .78846 L
s
[(12)] 1.0125 .78846 -1 0 Mshowa
.99375 .85256 m
1 .85256 L
s
[(13)] 1.0125 .85256 -1 0 Mshowa
.99375 .91667 m
1 .91667 L
s
[(14)] 1.0125 .91667 -1 0 Mshowa
.99375 .98077 m
1 .98077 L
s
[(15)] 1.0125 .98077 -1 0 Mshowa
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
15 string
15 15 8 [15 0 0 15 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
80000000FFFFFFFF00FF0080FF0000
0080800000FFFFFFFF008080FFFF00
0000FF800000FFFF80FF008000FFFF
FF0080FF800080FFFFFFFF00FF80FF
FFFF000080000080FFFFFF8000FF80
00FFFF0080FF000000FFFFFFFF00FF
FF0080808000FF000000FFFFFFFF00
00FF0080FF8000FF008080FF8080FF
FF00FF00FFFF80008000000080FF80
FFFF00FF00FFFF0000FF800000FFFF
FFFFFF808000FF80000080000000FF
8080FFFF00FF00FFFF0000FF000080
00FFFFFFFF80FF00FF800000FF0000
0080FFFFFFFF008000FFFF0080FF00
800000FFFFFF8000FF00FFFF0000FF
pop
P
% End of image
.01923 .01923 m
.01923 .98077 L
s
.08333 .01923 m
.08333 .98077 L
s
.14744 .01923 m
.14744 .98077 L
s
.21154 .01923 m
.21154 .98077 L
s
.27564 .01923 m
.27564 .98077 L
s
.33974 .01923 m
.33974 .98077 L
s
.40385 .01923 m
.40385 .98077 L
s
.46795 .01923 m
.46795 .98077 L
s
.53205 .01923 m
.53205 .98077 L
s
.59615 .01923 m
.59615 .98077 L
s
.66026 .01923 m
.66026 .98077 L
s
.72436 .01923 m
.72436 .98077 L
s
.78846 .01923 m
.78846 .98077 L
s
.85256 .01923 m
.85256 .98077 L
s
.91667 .01923 m
.91667 .98077 L
s
.98077 .01923 m
.98077 .98077 L
s
.01923 .01923 m
.98077 .01923 L
s
.01923 .08333 m
.98077 .08333 L
s
.01923 .14744 m
.98077 .14744 L
s
.01923 .21154 m
.98077 .21154 L
s
.01923 .27564 m
.98077 .27564 L
s
.01923 .33974 m
.98077 .33974 L
s
.01923 .40385 m
.98077 .40385 L
s
.01923 .46795 m
.98077 .46795 L
s
.01923 .53205 m
.98077 .53205 L
s
.01923 .59615 m
.98077 .59615 L
s
.01923 .66026 m
.98077 .66026 L
s
.01923 .72436 m
.98077 .72436 L
s
.01923 .78846 m
.98077 .78846 L
s
.01923 .85256 m
.98077 .85256 L
s
.01923 .91667 m
.98077 .91667 L
s
.01923 .98077 m
.98077 .98077 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.0.2"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "DensityGraphics", "\[SkeletonIndicator]"}],
  
  False,
  Editable->False]], "Output",
 CellLabel->"Out[10]= ",
 CellTags->"S5.0.2"]
}, Open  ]],

Cell["\<\
Decoding is accomplished by correlating each received word with the original \
sequence and finding the position of the peak. \
\>", "MathCaption",
 CellTags->{"S5.0.2", "2.15"}],

Cell["\<\
decode[x_] := Module[{corr},
  corr = Table[Apply[Plus, (1-2 sequence) *
    RotateLeft[1-2 x, n]], {n, 0, 14}];
  codewords[[ Position[corr, Max[corr]][[1, 1]] ]] ]\
\>", "Input",
 CellLabel->"In[11]:= ",
 CellTags->"S5.0.2"],

Cell["\<\
Three received words were incorrectly decoded. Two words had four bits in \
error and one had six bits in error. \
\>", "MathCaption",
 CellTags->{"S5.0.2", "2.16"}],

Cell[CellGroupData[{

Cell["\<\
(corrected = Map[decode, received];
delta = Abs[corrected-codewords];
ListDensityPlot[Table[If[delta[[i, j]] == 1,
  .5, codewords[[i, j]] ], {i, 15}, {j, 15}],
  FrameTicks -> {{4, 15}, Range[15]}])\
\>", "Input",
 CellLabel->"In[12]:= ",
 CellTags->"S5.0.2"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.0641026 0.0192308 0.0641026 [
[.27564 -0.0125 -3 -9 ]
[.27564 -0.0125 3 0 ]
[.98077 -0.0125 -6 -9 ]
[.98077 -0.0125 6 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .08333 -6 -4.5 ]
[-0.0125 .08333 0 4.5 ]
[-0.0125 .14744 -6 -4.5 ]
[-0.0125 .14744 0 4.5 ]
[-0.0125 .21154 -6 -4.5 ]
[-0.0125 .21154 0 4.5 ]
[-0.0125 .27564 -6 -4.5 ]
[-0.0125 .27564 0 4.5 ]
[-0.0125 .33974 -6 -4.5 ]
[-0.0125 .33974 0 4.5 ]
[-0.0125 .40385 -6 -4.5 ]
[-0.0125 .40385 0 4.5 ]
[-0.0125 .46795 -6 -4.5 ]
[-0.0125 .46795 0 4.5 ]
[-0.0125 .53205 -6 -4.5 ]
[-0.0125 .53205 0 4.5 ]
[-0.0125 .59615 -6 -4.5 ]
[-0.0125 .59615 0 4.5 ]
[-0.0125 .66026 -12 -4.5 ]
[-0.0125 .66026 0 4.5 ]
[-0.0125 .72436 -12 -4.5 ]
[-0.0125 .72436 0 4.5 ]
[-0.0125 .78846 -12 -4.5 ]
[-0.0125 .78846 0 4.5 ]
[-0.0125 .85256 -12 -4.5 ]
[-0.0125 .85256 0 4.5 ]
[-0.0125 .91667 -12 -4.5 ]
[-0.0125 .91667 0 4.5 ]
[-0.0125 .98077 -12 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[.27564 1.0125 -3 0 ]
[.27564 1.0125 3 9 ]
[.98077 1.0125 -6 0 ]
[.98077 1.0125 6 9 ]
[ 0 1 .125 0 ]
[1.0125 .08333 0 -4.5 ]
[1.0125 .08333 6 4.5 ]
[1.0125 .14744 0 -4.5 ]
[1.0125 .14744 6 4.5 ]
[1.0125 .21154 0 -4.5 ]
[1.0125 .21154 6 4.5 ]
[1.0125 .27564 0 -4.5 ]
[1.0125 .27564 6 4.5 ]
[1.0125 .33974 0 -4.5 ]
[1.0125 .33974 6 4.5 ]
[1.0125 .40385 0 -4.5 ]
[1.0125 .40385 6 4.5 ]
[1.0125 .46795 0 -4.5 ]
[1.0125 .46795 6 4.5 ]
[1.0125 .53205 0 -4.5 ]
[1.0125 .53205 6 4.5 ]
[1.0125 .59615 0 -4.5 ]
[1.0125 .59615 6 4.5 ]
[1.0125 .66026 0 -4.5 ]
[1.0125 .66026 12 4.5 ]
[1.0125 .72436 0 -4.5 ]
[1.0125 .72436 12 4.5 ]
[1.0125 .78846 0 -4.5 ]
[1.0125 .78846 12 4.5 ]
[1.0125 .85256 0 -4.5 ]
[1.0125 .85256 12 4.5 ]
[1.0125 .91667 0 -4.5 ]
[1.0125 .91667 12 4.5 ]
[1.0125 .98077 0 -4.5 ]
[1.0125 .98077 12 4.5 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.27564 0 m
.27564 .00625 L
s
[(4)] .27564 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(15)] .98077 -0.0125 0 1 Mshowa
0 0 m
1 0 L
s
0 .08333 m
.00625 .08333 L
s
[(1)] -0.0125 .08333 1 0 Mshowa
0 .14744 m
.00625 .14744 L
s
[(2)] -0.0125 .14744 1 0 Mshowa
0 .21154 m
.00625 .21154 L
s
[(3)] -0.0125 .21154 1 0 Mshowa
0 .27564 m
.00625 .27564 L
s
[(4)] -0.0125 .27564 1 0 Mshowa
0 .33974 m
.00625 .33974 L
s
[(5)] -0.0125 .33974 1 0 Mshowa
0 .40385 m
.00625 .40385 L
s
[(6)] -0.0125 .40385 1 0 Mshowa
0 .46795 m
.00625 .46795 L
s
[(7)] -0.0125 .46795 1 0 Mshowa
0 .53205 m
.00625 .53205 L
s
[(8)] -0.0125 .53205 1 0 Mshowa
0 .59615 m
.00625 .59615 L
s
[(9)] -0.0125 .59615 1 0 Mshowa
0 .66026 m
.00625 .66026 L
s
[(10)] -0.0125 .66026 1 0 Mshowa
0 .72436 m
.00625 .72436 L
s
[(11)] -0.0125 .72436 1 0 Mshowa
0 .78846 m
.00625 .78846 L
s
[(12)] -0.0125 .78846 1 0 Mshowa
0 .85256 m
.00625 .85256 L
s
[(13)] -0.0125 .85256 1 0 Mshowa
0 .91667 m
.00625 .91667 L
s
[(14)] -0.0125 .91667 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(15)] -0.0125 .98077 1 0 Mshowa
0 0 m
0 1 L
s
.27564 .99375 m
.27564 1 L
s
[(4)] .27564 1.0125 0 -1 Mshowa
.98077 .99375 m
.98077 1 L
s
[(15)] .98077 1.0125 0 -1 Mshowa
0 1 m
1 1 L
s
.99375 .08333 m
1 .08333 L
s
[(1)] 1.0125 .08333 -1 0 Mshowa
.99375 .14744 m
1 .14744 L
s
[(2)] 1.0125 .14744 -1 0 Mshowa
.99375 .21154 m
1 .21154 L
s
[(3)] 1.0125 .21154 -1 0 Mshowa
.99375 .27564 m
1 .27564 L
s
[(4)] 1.0125 .27564 -1 0 Mshowa
.99375 .33974 m
1 .33974 L
s
[(5)] 1.0125 .33974 -1 0 Mshowa
.99375 .40385 m
1 .40385 L
s
[(6)] 1.0125 .40385 -1 0 Mshowa
.99375 .46795 m
1 .46795 L
s
[(7)] 1.0125 .46795 -1 0 Mshowa
.99375 .53205 m
1 .53205 L
s
[(8)] 1.0125 .53205 -1 0 Mshowa
.99375 .59615 m
1 .59615 L
s
[(9)] 1.0125 .59615 -1 0 Mshowa
.99375 .66026 m
1 .66026 L
s
[(10)] 1.0125 .66026 -1 0 Mshowa
.99375 .72436 m
1 .72436 L
s
[(11)] 1.0125 .72436 -1 0 Mshowa
.99375 .78846 m
1 .78846 L
s
[(12)] 1.0125 .78846 -1 0 Mshowa
.99375 .85256 m
1 .85256 L
s
[(13)] 1.0125 .85256 -1 0 Mshowa
.99375 .91667 m
1 .91667 L
s
[(14)] 1.0125 .91667 -1 0 Mshowa
.99375 .98077 m
1 .98077 L
s
[(15)] 1.0125 .98077 -1 0 Mshowa
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
15 string
15 15 8 [15 0 0 15 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FF000000FFFFFFFF00FF00FFFF0000
00FF000000FFFFFFFF00FF00FFFF00
0000FF000000FFFFFFFF00FF00FFFF
FF0000FF000000FFFFFFFF00FF00FF
FF80008080000080FFFFFF80808080
00FFFF0000FF000000FFFFFFFF00FF
FF00FFFF0000FF000000FFFFFFFF00
00FF808080800080008080FFFF80FF
FF00FF00FFFF0000FF000000FFFFFF
FFFF00FF00FFFF0000FF000000FFFF
FFFF80808080FF80008080000080FF
FFFFFFFF00FF00FFFF0000FF000000
00FFFFFFFF00FF00FFFF0000FF0000
0000FFFFFFFF00FF00FFFF0000FF00
000000FFFFFFFF00FF00FFFF0000FF
pop
P
% End of image
.01923 .01923 m
.01923 .98077 L
s
.08333 .01923 m
.08333 .98077 L
s
.14744 .01923 m
.14744 .98077 L
s
.21154 .01923 m
.21154 .98077 L
s
.27564 .01923 m
.27564 .98077 L
s
.33974 .01923 m
.33974 .98077 L
s
.40385 .01923 m
.40385 .98077 L
s
.46795 .01923 m
.46795 .98077 L
s
.53205 .01923 m
.53205 .98077 L
s
.59615 .01923 m
.59615 .98077 L
s
.66026 .01923 m
.66026 .98077 L
s
.72436 .01923 m
.72436 .98077 L
s
.78846 .01923 m
.78846 .98077 L
s
.85256 .01923 m
.85256 .98077 L
s
.91667 .01923 m
.91667 .98077 L
s
.98077 .01923 m
.98077 .98077 L
s
.01923 .01923 m
.98077 .01923 L
s
.01923 .08333 m
.98077 .08333 L
s
.01923 .14744 m
.98077 .14744 L
s
.01923 .21154 m
.98077 .21154 L
s
.01923 .27564 m
.98077 .27564 L
s
.01923 .33974 m
.98077 .33974 L
s
.01923 .40385 m
.98077 .40385 L
s
.01923 .46795 m
.98077 .46795 L
s
.01923 .53205 m
.98077 .53205 L
s
.01923 .59615 m
.98077 .59615 L
s
.01923 .66026 m
.98077 .66026 L
s
.01923 .72436 m
.98077 .72436 L
s
.01923 .78846 m
.98077 .78846 L
s
.01923 .85256 m
.98077 .85256 L
s
.01923 .91667 m
.98077 .91667 L
s
.01923 .98077 m
.98077 .98077 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.0.2"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "DensityGraphics", "\[SkeletonIndicator]"}],
  
  False,
  Editable->False]], "Output",
 CellLabel->"Out[12]= ",
 CellTags->"S5.0.2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Calculus Packages", "Subsection",
 CellTags->{"S5.0.3", "3.1"}],

Cell[TextData[{
 StyleBox["Mathematica", "TI"],
 " has extensive built\[Hyphen]in support for calculus, including \
integration, differentiation, differential equation solving, and limits. The \
",
 StyleBox["Calculus", "MR"],
 " packages extend this functionality by providing functions for finding \
complete integrals of differential equations, computing Pad\[EAcute] \
approximations, and doing vector operations in various \
three\[Hyphen]dimensional coordinate systems. The package ",
 StyleBox["VariationalMethods", "MR"],
 " is useful for solving for a function extremizing a definite integral \
functional, a problem that appears in many areas of physics and engineering. \
"
}], "Text",
 CellTags->{"S5.0.3", "3.2"}],

Cell[TextData[{
 "This causes each ",
 StyleBox["Calculus", "MR"],
 " package to load as needed. "
}], "MathCaption",
 CellTags->{"S5.0.3", "3.3"}],

Cell["<<Calculus`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.0.3"],

Cell[TextData[{
 "The function ",
 StyleBox["VariationalBound", "MR"],
 " can be used to give an upper bound on the first eigenvalue ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Lambda]", "1"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " associated with the vibrating string problem. Here assume that the string \
has unit length, density, and tension. The integral ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["\[Integral]", "0", "1"], 
    SuperscriptBox[
     RowBox[{
      SuperscriptBox["\[Phi]", "\[Prime]"], 
      RowBox[{"(", 
       StyleBox["x",
        "TI"], ")"}]}], "2"], "\[DifferentialD]", 
    StyleBox["x",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is minimized over all approximating eigenfunctions ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Phi]", 
    RowBox[{"(", 
     StyleBox["x",
      "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " having the same form as the specified trial function. "
}], "Text",
 CellTags->{"S5.0.3", "3.4"}],

Cell[TextData[{
 "For a vibrating string with a fixed end at ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["x",
     "TI"], "=", "0"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", a trial function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Phi]", 
    RowBox[{"(", 
     StyleBox["x",
      "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is picked such that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[Phi]", "(", "0", ")"}], "=", "0"}], TraditionalForm]], 
  "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". The parameter ",
 Cell[BoxData[
  FormBox[
   StyleBox["a",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is chosen to satisfy a normalization condition. "
}], "MathCaption",
 CellTags->{"S5.0.3", "3.5"}],

Cell[CellGroupData[{

Cell["\<\
(phitrial = a x^k;
eq = (Integrate[phitrial^2, {x, 0, 1},
  Assumptions -> {k > 1/2}] == 1);
phitrial = (phitrial /. Solve[eq, a])[[1]])\
\>", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.0.3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   SqrtBox[
    RowBox[{"1", "+", 
     RowBox[{"2", " ", "k"}]}]]}], " ", 
  SuperscriptBox["x", "k"]}]], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.0.3"]
}, Open  ]],

Cell[TextData[{
 "The bound is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Lambda]", "1"], "\[LessEqual]", "2.77"}], 
   TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", close to the precise value ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Lambda]", "1"], "=", 
    RowBox[{
     SuperscriptBox["\[Pi]", "2"], "/", "4"}]}], TraditionalForm]], 
  "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.0.3", "3.6"}],

Cell[CellGroupData[{

Cell["\<\
VariationalBound[D[phi[x], x]^2,
  phi[x], {x, 0, 1}, phitrial, {k}]\
\>", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.0.3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.02254248593736856`"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", "\[Rule]", 
     RowBox[{"-", "0.30901699437494745`"}]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.0.3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Discrete Mathematics Packages", "Subsection",
 CellTags->{"S5.0.4", "4.1"}],

Cell[TextData[{
 "Discrete mathematics is concerned with enumerable mathematical structures, \
such as are studied in combinatorics, graph theory, and computational \
geometry. The ",
 StyleBox["DiscreteMath", "MR"],
 " packages include, among others, ",
 StyleBox["Combinatorica", "MR"],
 ", which provides over 200 functions for the study of combinatorics and \
graph theory and ",
 StyleBox["ComputationalGeometry", "MR"],
 ", which provides several important geometric functions useful in \
nonparametric data analysis. "
}], "Text",
 CellTags->{"S5.0.4", "4.2"}],

Cell[TextData[{
 "This causes each ",
 StyleBox["DiscreteMath", "MR"],
 " package to load as needed. "
}], "MathCaption",
 CellTags->{"S5.0.4", "4.3"}],

Cell["<<DiscreteMath`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.0.4"],

Cell[TextData[{
 "The ",
 StyleBox["Combinatorica", "MR"],
 " package provides definitions of many graph objects. The \
five\[Hyphen]dimensional hypercube has a three\[Hyphen]dimensional cube in \
each corner of the square. "
}], "MathCaption",
 CellTags->{"S5.0.4", "4.4"}],

Cell[CellGroupData[{

Cell["ShowGraph[ Hypercube[5] ]", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.0.4"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0519095 1.03819 -0.15735 1.10224 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 0 r
.005 w
[ ] 0 setdash
.5 .11565 m
.52905 .05511 L
s
.5 .11565 m
.55702 .1465 L
s
.5 .11565 m
.41393 .14534 L
s
.5 .11565 m
.86202 .5 L
s
.5 .11565 m
.13798 .5 L
s
.52905 .05511 m
.58607 .08596 L
s
.52905 .05511 m
.44298 .0848 L
s
.52905 .05511 m
.89107 .43946 L
s
.52905 .05511 m
.16704 .43946 L
s
.58607 .08596 m
.55702 .1465 L
s
.58607 .08596 m
.5 .11565 L
s
.58607 .08596 m
.94809 .47031 L
s
.58607 .08596 m
.22406 .47031 L
s
.55702 .1465 m
.47095 .17619 L
s
.55702 .1465 m
.91904 .53085 L
s
.55702 .1465 m
.195 .53085 L
s
.41393 .14534 m
.44298 .0848 L
s
.41393 .14534 m
.47095 .17619 L
s
.41393 .14534 m
.77594 .52969 L
s
.41393 .14534 m
.05191 .52969 L
s
.44298 .0848 m
.5 .11565 L
s
.44298 .0848 m
.805 .46915 L
s
.44298 .0848 m
.08096 .46915 L
s
.5 .11565 m
.47095 .17619 L
s
.5 .11565 m
.86202 .5 L
s
.5 .11565 m
.13798 .5 L
s
.47095 .17619 m
.83296 .56054 L
s
.47095 .17619 m
.10893 .56054 L
s
.86202 .5 m
.89107 .43946 L
s
.86202 .5 m
.91904 .53085 L
s
.86202 .5 m
.77594 .52969 L
s
.86202 .5 m
.5 .88435 L
s
.89107 .43946 m
.94809 .47031 L
s
.89107 .43946 m
.805 .46915 L
s
.89107 .43946 m
.52905 .82381 L
s
.94809 .47031 m
.91904 .53085 L
s
.94809 .47031 m
.86202 .5 L
s
.94809 .47031 m
.58607 .85466 L
s
.91904 .53085 m
.83296 .56054 L
s
.91904 .53085 m
.55702 .9152 L
s
.77594 .52969 m
.805 .46915 L
s
.77594 .52969 m
.83296 .56054 L
s
.77594 .52969 m
.41393 .91404 L
s
.805 .46915 m
.86202 .5 L
s
.805 .46915 m
.44298 .8535 L
s
.86202 .5 m
.83296 .56054 L
s
.86202 .5 m
.5 .88435 L
s
.83296 .56054 m
.47095 .94489 L
s
.5 .88435 m
.52905 .82381 L
s
.5 .88435 m
.55702 .9152 L
s
.5 .88435 m
.41393 .91404 L
s
.5 .88435 m
.13798 .5 L
s
.52905 .82381 m
.58607 .85466 L
s
.52905 .82381 m
.44298 .8535 L
s
.52905 .82381 m
.16704 .43946 L
s
.58607 .85466 m
.55702 .9152 L
s
.58607 .85466 m
.5 .88435 L
s
.58607 .85466 m
.22406 .47031 L
s
.55702 .9152 m
.47095 .94489 L
s
.55702 .9152 m
.195 .53085 L
s
.41393 .91404 m
.44298 .8535 L
s
.41393 .91404 m
.47095 .94489 L
s
.41393 .91404 m
.05191 .52969 L
s
.44298 .8535 m
.5 .88435 L
s
.44298 .8535 m
.08096 .46915 L
s
.5 .88435 m
.47095 .94489 L
s
.5 .88435 m
.13798 .5 L
s
.47095 .94489 m
.10893 .56054 L
s
.13798 .5 m
.16704 .43946 L
s
.13798 .5 m
.195 .53085 L
s
.13798 .5 m
.05191 .52969 L
s
.16704 .43946 m
.22406 .47031 L
s
.16704 .43946 m
.08096 .46915 L
s
.22406 .47031 m
.195 .53085 L
s
.22406 .47031 m
.13798 .5 L
s
.195 .53085 m
.10893 .56054 L
s
.05191 .52969 m
.08096 .46915 L
s
.05191 .52969 m
.10893 .56054 L
s
.08096 .46915 m
.13798 .5 L
s
.13798 .5 m
.10893 .56054 L
s
.025 w
.5 .11565 Mdot
.52905 .05511 Mdot
.58607 .08596 Mdot
.55702 .1465 Mdot
.41393 .14534 Mdot
.44298 .0848 Mdot
.5 .11565 Mdot
.47095 .17619 Mdot
.86202 .5 Mdot
.89107 .43946 Mdot
.94809 .47031 Mdot
.91904 .53085 Mdot
.77594 .52969 Mdot
.805 .46915 Mdot
.86202 .5 Mdot
.83296 .56054 Mdot
.5 .88435 Mdot
.52905 .82381 Mdot
.58607 .85466 Mdot
.55702 .9152 Mdot
.41393 .91404 Mdot
.44298 .8535 Mdot
.5 .88435 Mdot
.47095 .94489 Mdot
.13798 .5 Mdot
.16704 .43946 Mdot
.22406 .47031 Mdot
.195 .53085 Mdot
.05191 .52969 Mdot
.08096 .46915 Mdot
.13798 .5 Mdot
.10893 .56054 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.0.4"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.0.4"]
}, Open  ]],

Cell[TextData[{
 "This reads a file of piezometric\[Hyphen]head data for the Wolfcamp aquifer \
in the western United States. The triples give an ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     StyleBox["x",
      "TI"], ",", 
     StyleBox["y",
      "TI"]}], ")"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " location with respect to an arbitrary origin and the water level in feet \
above sea level. "
}], "MathCaption",
 CellTags->{"S5.0.4", "4.5"}],

Cell["\<\
data = ReadList[\"wolfcamp.aquifer.data\",
  Number, RecordLists->True];\
\>", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.0.4"],

Cell["\<\
The Voronoi polygons are useful in spatial statistics because they define a \
\[OpenCurlyDoubleQuote]region of influence\[CloseCurlyDoubleQuote] for each \
data point. The aquifer water level throughout a polygonal region can be \
approximated by the measurement at the center of the polygon. \
\>", "MathCaption",
 CellTags->{"S5.0.4", "4.6"}],

Cell[CellGroupData[{

Cell["\<\
(data2D = Map[Drop[#, -1]&, data];
triangulation = DelaunayTriangulation[data2D];
{polygonVertices, polygonVal} =
  VoronoiDiagram[data2D, triangulation];
DiagramPlot[data2D, polygonVertices, polygonVal,
  Axes -> True, AxesLabel -> {x, y},
  AxesOrigin -> {-150, -30},
  LabelPoints -> False, TrimPoints -> 6,
  Ticks -> {Automatic, {-50, 0, 50, 100, 150, 200}}])\
\>", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.0.4"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.546586 0.00359129 0.147734 0.00359129 [
[.18746 .0275 -12 -9 ]
[.18746 .0275 12 0 ]
[.36702 .0275 -9 -9 ]
[.36702 .0275 9 0 ]
[.54659 .0275 -3 -9 ]
[.54659 .0275 3 0 ]
[.72615 .0275 -6 -9 ]
[.72615 .0275 6 0 ]
[.90571 .0275 -9 -9 ]
[.90571 .0275 9 0 ]
[1.025 .04 0 -4.90625 ]
[1.025 .04 10 4.90625 ]
[-0.00461 .14773 -6 -4.5 ]
[-0.00461 .14773 0 4.5 ]
[-0.00461 .3273 -12 -4.5 ]
[-0.00461 .3273 0 4.5 ]
[-0.00461 .50686 -18 -4.5 ]
[-0.00461 .50686 0 4.5 ]
[-0.00461 .68643 -18 -4.5 ]
[-0.00461 .68643 0 4.5 ]
[-0.00461 .86599 -18 -4.5 ]
[-0.00461 .86599 0 4.5 ]
[.00789 1.025 -5.03125 0 ]
[.00789 1.025 5.03125 9.8125 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.18746 .04 m
.18746 .04625 L
s
[(-100)] .18746 .0275 0 1 Mshowa
.36702 .04 m
.36702 .04625 L
s
[(-50)] .36702 .0275 0 1 Mshowa
.54659 .04 m
.54659 .04625 L
s
[(0)] .54659 .0275 0 1 Mshowa
.72615 .04 m
.72615 .04625 L
s
[(50)] .72615 .0275 0 1 Mshowa
.90571 .04 m
.90571 .04625 L
s
[(100)] .90571 .0275 0 1 Mshowa
.125 Mabswid
.04381 .04 m
.04381 .04375 L
s
.07972 .04 m
.07972 .04375 L
s
.11563 .04 m
.11563 .04375 L
s
.15154 .04 m
.15154 .04375 L
s
.22337 .04 m
.22337 .04375 L
s
.25928 .04 m
.25928 .04375 L
s
.2952 .04 m
.2952 .04375 L
s
.33111 .04 m
.33111 .04375 L
s
.40293 .04 m
.40293 .04375 L
s
.43885 .04 m
.43885 .04375 L
s
.47476 .04 m
.47476 .04375 L
s
.51067 .04 m
.51067 .04375 L
s
.5825 .04 m
.5825 .04375 L
s
.61841 .04 m
.61841 .04375 L
s
.65432 .04 m
.65432 .04375 L
s
.69024 .04 m
.69024 .04375 L
s
.76206 .04 m
.76206 .04375 L
s
.79798 .04 m
.79798 .04375 L
s
.83389 .04 m
.83389 .04375 L
s
.8698 .04 m
.8698 .04375 L
s
.94163 .04 m
.94163 .04375 L
s
.97754 .04 m
.97754 .04375 L
s
.25 Mabswid
0 .04 m
1 .04 L
s
gsave
1.025 .04 -61 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(x) show
1.000 setlinewidth
grestore
.00789 .14773 m
.01414 .14773 L
s
[(0)] -0.00461 .14773 1 0 Mshowa
.00789 .3273 m
.01414 .3273 L
s
[(50)] -0.00461 .3273 1 0 Mshowa
.00789 .50686 m
.01414 .50686 L
s
[(100)] -0.00461 .50686 1 0 Mshowa
.00789 .68643 m
.01414 .68643 L
s
[(150)] -0.00461 .68643 1 0 Mshowa
.00789 .86599 m
.01414 .86599 L
s
[(200)] -0.00461 .86599 1 0 Mshowa
.00789 0 m
.00789 1 L
s
gsave
.00789 1.025 -66.0312 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.062 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(y) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.012 w
.70023 .60606 Mdot
.4482 .47378 Mdot
.54241 .45262 Mdot
.47972 .4223 Mdot
.89302 .37966 Mdot
.93646 .44554 Mdot
.86392 .35048 Mdot
.86995 .28872 Mdot
.8812 .26646 Mdot
.89714 .34985 Mdot
.87206 .27372 Mdot
.87897 .29768 Mdot
.90388 .36019 Mdot
.46015 .81128 Mdot
.45299 .55741 Mdot
.7487 .24415 Mdot
.80889 .21554 Mdot
.83485 .19304 Mdot
.83472 .20023 Mdot
.7938 .53478 Mdot
.82096 .49248 Mdot
.77809 .5442 Mdot
.70244 .34028 Mdot
.68693 .37039 Mdot
.9517 .31131 Mdot
.74145 .6786 Mdot
.56861 .32129 Mdot
.53292 .29284 Mdot
.53858 .25515 Mdot
.5381 .26919 Mdot
.53873 .2687 Mdot
.77364 .43324 Mdot
.50788 .77662 Mdot
.47839 .76514 Mdot
.40804 .71705 Mdot
.84518 .71916 Mdot
.46829 .2017 Mdot
.46196 .18154 Mdot
.47435 .22708 Mdot
.48688 .20971 Mdot
.65399 .77667 Mdot
.909 .23026 Mdot
.91037 .2302 Mdot
.91744 .22079 Mdot
.49519 .26002 Mdot
.48146 .25612 Mdot
.48151 .25379 Mdot
.51108 .28472 Mdot
.5029 .28819 Mdot
.58845 .21501 Mdot
.76814 .26443 Mdot
.79646 .26915 Mdot
.7862 .2696 Mdot
.41495 .68971 Mdot
.47637 .64256 Mdot
.4701 .62116 Mdot
.46628 .64023 Mdot
.62253 .64786 Mdot
.57418 .60324 Mdot
.51666 .53479 Mdot
.75024 .76279 Mdot
.75847 .73868 Mdot
.79427 .78428 Mdot
.80122 .7273 Mdot
.80876 .73308 Mdot
.76085 .75863 Mdot
.76879 .7737 Mdot
.77538 .77231 Mdot
.56679 .43176 Mdot
.61212 .42567 Mdot
.85432 .64986 Mdot
.92395 .6219 Mdot
.18156 .18599 Mdot
.025 .24837 Mdot
.28086 .46367 Mdot
.20727 .45883 Mdot
.2275 .42322 Mdot
.1147 .43778 Mdot
.23765 .34297 Mdot
.28517 .30249 Mdot
.18683 .3018 Mdot
.26347 .29434 Mdot
.24603 .31475 Mdot
.2032 .27638 Mdot
.23215 .25329 Mdot
.086 .33543 Mdot
.09092 .75645 Mdot
.11518 .24704 Mdot
.12875 .24642 Mdot
.16418 .37691 Mdot
.1689 .41349 Mdot
.16951 .37512 Mdot
.19108 .23149 Mdot
.21375 .32052 Mdot
.21747 .30354 Mdot
.22109 .65525 Mdot
.23196 .64547 Mdot
.23312 .28607 Mdot
.23353 .28471 Mdot
.24439 .45636 Mdot
.26782 .31571 Mdot
.27502 .33871 Mdot
.29404 .39087 Mdot
.29792 .23558 Mdot
.31351 .3839 Mdot
.32097 .13386 Mdot
.32278 .59159 Mdot
.33893 .19139 Mdot
.36138 .2242 Mdot
.36139 .5207 Mdot
.3683 .38536 Mdot
.36928 .39006 Mdot
.36939 .23875 Mdot
.38006 .26553 Mdot
.38563 .60966 Mdot
.39307 .61565 Mdot
.39671 .336 Mdot
.3969 .33892 Mdot
.4234 .77008 Mdot
.42769 .25388 Mdot
.46052 .71577 Mdot
.46102 .68614 Mdot
.47352 .51428 Mdot
.47354 .63177 Mdot
.47413 .21371 Mdot
.47465 .70389 Mdot
.48249 .27864 Mdot
.4841 .79407 Mdot
.48655 .18489 Mdot
.48916 .25511 Mdot
.49635 .46787 Mdot
.4968 .57982 Mdot
.49832 .23498 Mdot
.50008 .48448 Mdot
.50115 .23319 Mdot
.50146 .27344 Mdot
.50746 .35804 Mdot
.50947 .35886 Mdot
.51391 .23108 Mdot
.51545 .3064 Mdot
.51688 .26354 Mdot
.51732 .26147 Mdot
.51859 .59157 Mdot
.5195 .70315 Mdot
.52301 .61726 Mdot
.52533 .40797 Mdot
.52568 .27886 Mdot
.52882 .37589 Mdot
.53286 .26199 Mdot
.53812 .20354 Mdot
.54164 .13615 Mdot
.54759 .69655 Mdot
.54819 .67991 Mdot
.5507 .28434 Mdot
.56596 .28801 Mdot
.58088 .9273 Mdot
.58095 .72627 Mdot
.58248 .37677 Mdot
.58471 .26142 Mdot
.59538 .2713 Mdot
.5981 .49303 Mdot
.60639 .51779 Mdot
.60757 .51754 Mdot
.62172 .36041 Mdot
.63631 .32526 Mdot
.63769 .58293 Mdot
.63901 .52425 Mdot
.64271 .28014 Mdot
.66269 .26196 Mdot
.67141 .70417 Mdot
.68163 .66461 Mdot
.68203 .50324 Mdot
.68994 .49216 Mdot
.69168 .45508 Mdot
.69415 .72445 Mdot
.69653 .73099 Mdot
.69901 .06224 Mdot
.6996 .06324 Mdot
.71325 .84695 Mdot
.7156 .93776 Mdot
.7211 .29007 Mdot
.74513 .38133 Mdot
.75121 .74966 Mdot
.756 .48951 Mdot
.75891 .76929 Mdot
.76076 .32442 Mdot
.76655 .48742 Mdot
.77006 .76341 Mdot
.77025 .61426 Mdot
.77172 .70247 Mdot
.77611 .79205 Mdot
.7804 .23322 Mdot
.78273 .35253 Mdot
.78285 .3506 Mdot
.78327 .74584 Mdot
.78477 .74778 Mdot
.78559 .23755 Mdot
.78627 .61862 Mdot
.78946 .75047 Mdot
.79003 .23942 Mdot
.79438 .33952 Mdot
.7979 .75766 Mdot
.79907 .6689 Mdot
.81492 .19627 Mdot
.81519 .67996 Mdot
.81914 .59491 Mdot
.82069 .70968 Mdot
.82351 .31536 Mdot
.83399 .27602 Mdot
.83445 .40895 Mdot
.83556 .24997 Mdot
.84237 .24258 Mdot
.84246 .42679 Mdot
.844 .7707 Mdot
.84989 .31793 Mdot
.85118 .2381 Mdot
.86335 .57166 Mdot
.86715 .22689 Mdot
.86825 .44326 Mdot
.8737 .55619 Mdot
.87905 .19745 Mdot
.87988 .19579 Mdot
.88008 .32654 Mdot
.88077 .36278 Mdot
.88448 .28312 Mdot
.88652 .28253 Mdot
.88725 .36367 Mdot
.90426 .53188 Mdot
.90938 .22209 Mdot
.91082 .26043 Mdot
.91195 .69271 Mdot
.91338 .31495 Mdot
.91902 .28485 Mdot
.92651 .27306 Mdot
.92869 .33663 Mdot
.94234 .3944 Mdot
.95671 .25767 Mdot
.975 .38193 Mdot
.003 w
.87988 .19579 m
.90763 .11319 L
s
.95671 .25767 m
0 0 rlineto s
.95671 .25767 m
1 .24129 L
s
.32097 .13386 m
0 0 rlineto s
.32097 .13386 m
.31885 0 L
s
.11518 .24704 m
.04089 .06062 L
s
.086 .33543 m
0 0 rlineto s
.086 .33543 m
0 .37616 L
s
.63769 .58293 m
.63901 .52425 L
.68203 .50324 L
.77025 .61426 L
.68163 .66461 L
.63769 .58293 L
s
.36139 .5207 m
.36928 .39006 L
.49635 .46787 L
.50008 .48448 L
.47352 .51428 L
.36139 .5207 L
s
.50008 .48448 m
.49635 .46787 L
.52533 .40797 L
.5981 .49303 L
.60757 .51754 L
.60639 .51779 L
.50008 .48448 L
s
.36928 .39006 m
.3683 .38536 L
.3969 .33892 L
.50746 .35804 L
.50947 .35886 L
.52882 .37589 L
.52533 .40797 L
.49635 .46787 L
.36928 .39006 L
s
.84246 .42679 m
.83445 .40895 L
.88077 .36278 L
.88725 .36367 L
.94234 .3944 L
.86825 .44326 L
.84246 .42679 L
s
.90426 .53188 m
.86825 .44326 L
.94234 .3944 L
.975 .38193 L
s
.975 .38193 m
1 .38477 L
s
1 .53867 m
.90426 .53188 L
s
.78273 .35253 m
.78285 .3506 L
.79438 .33952 L
.82351 .31536 L
.84989 .31793 L
.88008 .32654 L
.88077 .36278 L
.83445 .40895 L
.78273 .35253 L
s
.83399 .27602 m
.88448 .28312 L
.84989 .31793 L
.82351 .31536 L
.83399 .27602 L
s
.88652 .28253 m
.85118 .2381 L
.86715 .22689 L
.91082 .26043 L
.92651 .27306 L
.91902 .28485 L
.88652 .28253 L
s
.88077 .36278 m
.88008 .32654 L
.91338 .31495 L
.92869 .33663 L
.88725 .36367 L
.88077 .36278 L
s
.88448 .28312 m
.83399 .27602 L
.83556 .24997 L
.84237 .24258 L
.85118 .2381 L
.88652 .28253 L
.88448 .28312 L
s
.84989 .31793 m
.88448 .28312 L
.88652 .28253 L
.91902 .28485 L
.91338 .31495 L
.88008 .32654 L
.84989 .31793 L
s
.88725 .36367 m
.92869 .33663 L
.975 .38193 L
.94234 .3944 L
.88725 .36367 L
s
.00767 1 m
.4234 .77008 L
.4841 .79407 L
.58088 .9273 L
s
.58088 .9273 m
.59386 1 L
s
.32278 .59159 m
.36139 .5207 L
.47352 .51428 L
.4968 .57982 L
.38563 .60966 L
.32278 .59159 L
s
.69901 .06224 m
.6996 .06324 L
.7804 .23322 L
.7211 .29007 L
.66269 .26196 L
.69901 .06224 L
s
.79003 .23942 m
.78559 .23755 L
.7804 .23322 L
.6996 .06324 L
.81492 .19627 L
.84237 .24258 L
.83556 .24997 L
.79003 .23942 L
s
.87988 .19579 m
.87905 .19745 L
.81492 .19627 L
.6996 .06324 L
.69901 .06224 L
s
.69901 .06224 m
.69346 0 L
s
.81492 .19627 m
.87905 .19745 L
.86715 .22689 L
.85118 .2381 L
.84237 .24258 L
.81492 .19627 L
s
.756 .48951 m
.76655 .48742 L
.8737 .55619 L
.86335 .57166 L
.81914 .59491 L
.756 .48951 L
s
.76655 .48742 m
.84246 .42679 L
.86825 .44326 L
.90426 .53188 L
.8737 .55619 L
.76655 .48742 L
s
.77025 .61426 m
.68203 .50324 L
.68994 .49216 L
.756 .48951 L
.81914 .59491 L
.78627 .61862 L
.77025 .61426 L
s
.63631 .32526 m
.64271 .28014 L
.66269 .26196 L
.7211 .29007 L
.76076 .32442 L
.78285 .3506 L
.78273 .35253 L
.74513 .38133 L
.63631 .32526 L
s
.62172 .36041 m
.63631 .32526 L
.74513 .38133 L
.69168 .45508 L
.62172 .36041 L
s
1 .38477 m
.975 .38193 L
.92869 .33663 L
.91338 .31495 L
.91902 .28485 L
.92651 .27306 L
.95671 .25767 L
s
.67141 .70417 m
.68163 .66461 L
.77025 .61426 L
.78627 .61862 L
.79907 .6689 L
.77172 .70247 L
.69415 .72445 L
.67141 .70417 L
s
.52882 .37589 m
.50947 .35886 L
.56596 .28801 L
.59538 .2713 L
.64271 .28014 L
.63631 .32526 L
.62172 .36041 L
.58248 .37677 L
.52882 .37589 L
s
.50746 .35804 m
.51545 .3064 L
.52568 .27886 L
.5507 .28434 L
.56596 .28801 L
.50947 .35886 L
.50746 .35804 L
s
.51391 .23108 m
.53812 .20354 L
.58471 .26142 L
.53286 .26199 L
.51732 .26147 L
.51391 .23108 L
s
.52568 .27886 m
.51688 .26354 L
.51732 .26147 L
.53286 .26199 L
.5507 .28434 L
.52568 .27886 L
s
.5507 .28434 m
.53286 .26199 L
.58471 .26142 L
.59538 .2713 L
.56596 .28801 L
.5507 .28434 L
s
.69168 .45508 m
.74513 .38133 L
.78273 .35253 L
.83445 .40895 L
.84246 .42679 L
.76655 .48742 L
.756 .48951 L
.68994 .49216 L
.69168 .45508 L
s
.4841 .79407 m
.5195 .70315 L
.54759 .69655 L
.58095 .72627 L
.58088 .9273 L
.4841 .79407 L
s
.4234 .77008 m
.46052 .71577 L
.47465 .70389 L
.5195 .70315 L
.4841 .79407 L
.4234 .77008 L
s
.09092 .75645 m
.22109 .65525 L
.46052 .71577 L
.4234 .77008 L
s
.4234 .77008 m
.00767 1 L
s
0 .85196 m
.09092 .75645 L
s
.844 .7707 m
.82069 .70968 L
.81519 .67996 L
.91195 .69271 L
s
.91195 .69271 m
1 .76401 L
s
1 .89266 m
.844 .7707 L
s
.36138 .2242 m
.48655 .18489 L
.47413 .21371 L
.36939 .23875 L
.36138 .2242 L
s
.57767 0 m
.54164 .13615 L
.48655 .18489 L
.36138 .2242 L
.33893 .19139 L
.32097 .13386 L
s
.36939 .23875 m
.47413 .21371 L
.50115 .23319 L
.49832 .23498 L
.42769 .25388 L
.38006 .26553 L
.36939 .23875 L
s
.48655 .18489 m
.54164 .13615 L
.53812 .20354 L
.51391 .23108 L
.50115 .23319 L
.47413 .21371 L
.48655 .18489 L
s
.58088 .9273 m
.58095 .72627 L
.67141 .70417 L
.69415 .72445 L
.69653 .73099 L
.71325 .84695 L
.7156 .93776 L
s
.7156 .93776 m
.71222 1 L
s
.59386 1 m
.58088 .9273 L
s
.87905 .19745 m
.87988 .19579 L
.90938 .22209 L
.91082 .26043 L
.86715 .22689 L
.87905 .19745 L
s
.91082 .26043 m
.90938 .22209 L
.95671 .25767 L
.92651 .27306 L
.91082 .26043 L
s
.95671 .25767 m
.90938 .22209 L
.87988 .19579 L
s
.48916 .25511 m
.49832 .23498 L
.50115 .23319 L
.51391 .23108 L
.51732 .26147 L
.51688 .26354 L
.50146 .27344 L
.48249 .27864 L
.48916 .25511 L
s
.38006 .26553 m
.42769 .25388 L
.48916 .25511 L
.48249 .27864 L
.39671 .336 L
.38006 .26553 L
s
.42769 .25388 m
.49832 .23498 L
.48916 .25511 L
.42769 .25388 L
s
.50146 .27344 m
.51688 .26354 L
.52568 .27886 L
.51545 .3064 L
.50146 .27344 L
s
.3969 .33892 m
.39671 .336 L
.48249 .27864 L
.50146 .27344 L
.51545 .3064 L
.50746 .35804 L
.3969 .33892 L
s
.59538 .2713 m
.58471 .26142 L
.53812 .20354 L
.54164 .13615 L
s
.54164 .13615 m
.57767 0 L
s
.69346 0 m
.69901 .06224 L
.66269 .26196 L
.64271 .28014 L
.59538 .2713 L
s
.7211 .29007 m
.7804 .23322 L
.78559 .23755 L
.76076 .32442 L
.7211 .29007 L
s
.79003 .23942 m
.83556 .24997 L
.83399 .27602 L
.82351 .31536 L
.79438 .33952 L
.79003 .23942 L
s
.76076 .32442 m
.78559 .23755 L
.79003 .23942 L
.79438 .33952 L
.78285 .3506 L
.76076 .32442 L
s
.22109 .65525 m
.23196 .64547 L
.32278 .59159 L
.38563 .60966 L
.39307 .61565 L
.46102 .68614 L
.47465 .70389 L
.46052 .71577 L
.22109 .65525 L
s
.46102 .68614 m
.47354 .63177 L
.52301 .61726 L
.54819 .67991 L
.54759 .69655 L
.5195 .70315 L
.47465 .70389 L
.46102 .68614 L
s
.39307 .61565 m
.38563 .60966 L
.4968 .57982 L
.51859 .59157 L
.52301 .61726 L
.47354 .63177 L
.39307 .61565 L
s
.39307 .61565 m
.47354 .63177 L
.46102 .68614 L
.39307 .61565 L
s
.54759 .69655 m
.54819 .67991 L
.63769 .58293 L
.68163 .66461 L
.67141 .70417 L
.58095 .72627 L
.54759 .69655 L
s
.52301 .61726 m
.51859 .59157 L
.60639 .51779 L
.60757 .51754 L
.63901 .52425 L
.63769 .58293 L
.54819 .67991 L
.52301 .61726 L
s
.4968 .57982 m
.47352 .51428 L
.50008 .48448 L
.60639 .51779 L
.51859 .59157 L
.4968 .57982 L
s
.69653 .73099 m
.75121 .74966 L
.75891 .76929 L
.71325 .84695 L
.69653 .73099 L
s
.69653 .73099 m
.69415 .72445 L
.77172 .70247 L
.78327 .74584 L
.75121 .74966 L
.69653 .73099 L
s
.71222 1 m
.7156 .93776 L
.77611 .79205 L
.7979 .75766 L
.844 .7707 L
s
.844 .7707 m
1 .89266 L
s
.78477 .74778 m
.78327 .74584 L
.77172 .70247 L
.79907 .6689 L
.81519 .67996 L
.82069 .70968 L
.78946 .75047 L
.78477 .74778 L
s
.7979 .75766 m
.78946 .75047 L
.82069 .70968 L
.844 .7707 L
.7979 .75766 L
s
.75121 .74966 m
.78327 .74584 L
.78477 .74778 L
.77006 .76341 L
.75891 .76929 L
.75121 .74966 L
s
.71325 .84695 m
.75891 .76929 L
.77006 .76341 L
.77611 .79205 L
.7156 .93776 L
.71325 .84695 L
s
.77006 .76341 m
.78477 .74778 L
.78946 .75047 L
.7979 .75766 L
.77611 .79205 L
.77006 .76341 L
s
.52533 .40797 m
.52882 .37589 L
.58248 .37677 L
.5981 .49303 L
.52533 .40797 L
s
.60757 .51754 m
.5981 .49303 L
.58248 .37677 L
.62172 .36041 L
.69168 .45508 L
.68994 .49216 L
.68203 .50324 L
.63901 .52425 L
.60757 .51754 L
s
.81519 .67996 m
.79907 .6689 L
.78627 .61862 L
.81914 .59491 L
.86335 .57166 L
.91195 .69271 L
.81519 .67996 L
s
1 .76401 m
.91195 .69271 L
.86335 .57166 L
.8737 .55619 L
.90426 .53188 L
s
.90426 .53188 m
1 .53867 L
s
.32097 .13386 m
.19108 .23149 L
.12875 .24642 L
.11518 .24704 L
s
.11518 .24704 m
.086 .33543 L
s
.24439 .45636 m
.29404 .39087 L
.31351 .3839 L
.3683 .38536 L
.36928 .39006 L
.36139 .5207 L
.32278 .59159 L
.23196 .64547 L
.24439 .45636 L
s
.1689 .41349 m
.24439 .45636 L
.23196 .64547 L
.22109 .65525 L
.09092 .75645 L
.1689 .41349 L
s
.1689 .41349 m
.16418 .37691 L
.16951 .37512 L
.29404 .39087 L
.24439 .45636 L
.1689 .41349 L
s
.086 .33543 m
.16418 .37691 L
.1689 .41349 L
.09092 .75645 L
s
.09092 .75645 m
0 .85196 L
s
.16951 .37512 m
.21375 .32052 L
.27502 .33871 L
.31351 .3839 L
.29404 .39087 L
.16951 .37512 L
s
.27502 .33871 m
.26782 .31571 L
.29792 .23558 L
.33893 .19139 L
.36138 .2242 L
.36939 .23875 L
.38006 .26553 L
.39671 .336 L
.3969 .33892 L
.3683 .38536 L
.31351 .3839 L
.27502 .33871 L
s
.086 .33543 m
.11518 .24704 L
.12875 .24642 L
.21747 .30354 L
.21375 .32052 L
.16951 .37512 L
.16418 .37691 L
.086 .33543 L
s
.23312 .28607 m
.23353 .28471 L
.29792 .23558 L
.26782 .31571 L
.23312 .28607 L
s
.21375 .32052 m
.21747 .30354 L
.23312 .28607 L
.26782 .31571 L
.27502 .33871 L
.21375 .32052 L
s
.12875 .24642 m
.19108 .23149 L
.23353 .28471 L
.23312 .28607 L
.21747 .30354 L
.12875 .24642 L
s
.19108 .23149 m
.32097 .13386 L
.33893 .19139 L
.29792 .23558 L
.23353 .28471 L
.19108 .23149 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.0.4"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.0.4"]
}, Open  ]],

Cell["\<\
This displays the surface formed by a linear interpolation between the data \
points in the original three\[Hyphen]dimensional set. \
\>", "MathCaption",
 CellTags->{"S5.0.4", "4.7"}],

Cell[CellGroupData[{

Cell["\<\
TriangularSurfacePlot[data, triangulation,
  BoxRatios->{1, 1, .3}, Axes -> True,
  ViewPoint -> {1.3, 2.4, 2.}]\
\>", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.0.4"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .76154 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0493274 1.04933 -0.0923501 1.04933 [
[.86677 .20296 0 -8.96968 ]
[.86677 .20296 24 .03032 ]
[.62918 .11071 -0.45209 -9 ]
[.62918 .11071 5.54791 0 ]
[.36865 .00964 -2.77359 -9 ]
[.36865 .00964 15.2264 0 ]
[.01611 .41901 -6 -5.84056 ]
[.01611 .41901 0 3.15944 ]
[.07905 .32373 -12 -5.92685 ]
[.07905 .32373 0 3.07315 ]
[.14908 .21775 -18 -6.02502 ]
[.14908 .21775 0 2.97498 ]
[.22745 .09914 -18 -6.1377 ]
[.22745 .09914 0 2.8623 ]
[.98452 .26363 0 -2.76318 ]
[.98452 .26363 24 6.23682 ]
[.99474 .32766 0 -2.81693 ]
[.99474 .32766 24 6.18307 ]
[1.00538 .39435 0 -2.87315 ]
[1.00538 .39435 24 6.12685 ]
[ 0 0 0 0 ]
[ 1 .76154 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.97189 .25642 m
.30833 0 L
s
.85746 .2122 m
.85281 .21682 L
s
[(-100)] .86677 .20296 -1 .99326 Mshowa
.62069 .12071 m
.61645 .1257 L
s
[(0)] .62918 .11071 -0.8493 1 Mshowa
.36118 .02043 m
.35745 .02582 L
s
[(100)] .36865 .00964 -0.69182 1 Mshowa
.125 Mabswid
.81178 .19455 m
.80904 .19736 L
s
.76529 .17658 m
.76259 .17944 L
s
.71796 .15829 m
.71531 .1612 L
s
.66977 .13967 m
.66717 .14262 L
s
.57071 .10139 m
.56822 .10444 L
s
.5198 .08172 m
.51736 .08481 L
s
.46792 .06167 m
.46555 .06481 L
s
.41506 .04124 m
.41275 .04443 L
s
.90235 .22954 m
.89952 .23227 L
s
.94646 .24659 m
.94359 .24928 L
s
.25 Mabswid
.02319 .43105 m
.30833 0 L
s
.02868 .42275 m
.03496 .42462 L
s
[(0)] .01611 .41901 1 .2979 Mshowa
.09156 .3277 m
.09781 .32968 L
s
[(50)] .07905 .32373 1 .31708 Mshowa
.1615 .22196 m
.16771 .22406 L
s
[(100)] .14908 .21775 1 .33889 Mshowa
.23978 .10362 m
.24594 .10587 L
s
[(150)] .22745 .09914 1 .36393 Mshowa
.125 Mabswid
.04074 .40452 m
.04451 .40565 L
s
.05305 .3859 m
.05681 .38705 L
s
.06562 .36691 m
.06938 .36807 L
s
.07845 .34751 m
.08221 .34868 L
s
.10494 .30746 m
.10869 .30866 L
s
.11862 .28678 m
.12236 .288 L
s
.1326 .26565 m
.13634 .26688 L
s
.14689 .24404 m
.15062 .24529 L
s
.17645 .19937 m
.18017 .20064 L
s
.19173 .17626 m
.19545 .17755 L
s
.20738 .15261 m
.21109 .15392 L
s
.22339 .1284 m
.22709 .12973 L
s
.25657 .07825 m
.26026 .07961 L
s
.27376 .05225 m
.27745 .05363 L
s
.29139 .02561 m
.29506 .02701 L
s
.25 Mabswid
.97189 .25642 m
1 .43378 L
s
.97229 .25891 m
.96617 .25655 L
s
[(1000)] .98452 .26363 -1 -0.38596 Mshowa
.98245 .32306 m
.97631 .32076 L
s
[(2000)] .99474 .32766 -1 -0.37402 Mshowa
.99305 .3899 m
.98688 .38767 L
s
[(3000)] 1.00538 .39435 -1 -0.36152 Mshowa
.125 Mabswid
.97429 .27153 m
.97061 .27012 L
s
.97631 .28426 m
.97263 .28286 L
s
.97834 .29709 m
.97466 .29569 L
s
.98039 .31002 m
.97671 .30864 L
s
.98454 .33621 m
.98085 .33484 L
s
.98664 .34946 m
.98295 .3481 L
s
.98876 .36283 m
.98506 .36148 L
s
.99089 .37631 m
.98719 .37496 L
s
.99522 .4036 m
.99151 .40227 L
s
.99741 .41742 m
.9937 .4161 L
s
.99962 .43135 m
.99591 .43004 L
s
.25 Mabswid
.59691 .60101 m
.60252 .76154 L
s
.60252 .76154 m
1 .43378 L
s
1 .43378 m
.97189 .25642 L
s
.97189 .25642 m
.59691 .60101 L
s
.02319 .43105 m
.30833 0 L
s
.30833 0 m
.29755 .18561 L
s
.29755 .18561 m
0 .60069 L
s
0 .60069 m
.02319 .43105 L
s
.59691 .60101 m
.60252 .76154 L
s
.60252 .76154 m
0 .60069 L
s
0 .60069 m
.02319 .43105 L
s
.02319 .43105 m
.59691 .60101 L
s
.97189 .25642 m
.30833 0 L
s
.30833 0 m
.29755 .18561 L
s
.29755 .18561 m
1 .43378 L
s
1 .43378 m
.97189 .25642 L
s
0 0 m
1 0 L
1 .76154 L
0 .76154 L
closepath
clip
newpath
.5 Mabswid
.786 .713 .784 r
.52521 .70417 m .55369 .61012 L .5261 .63143 L closepath p F P
0 g
s
.416 .326 .646 r
.52521 .70417 m .57625 .62992 L .55369 .61012 L closepath p F P
0 g
s
.691 .695 .849 r
.52521 .70417 m .64514 .7022 L .57625 .62992 L closepath p F P
0 g
s
.696 .64 .789 r
.3564 .6124 m .52521 .70417 L .5261 .63143 L closepath p F P
0 g
s
.546 .653 .905 r
.64514 .7022 m .69016 .60915 L .57625 .62992 L closepath p F P
0 g
s
.778 .695 .772 r
.52633 .5829 m .55369 .61012 L .5261 .63143 L closepath p F P
0 g
s
.145 .465 .89 r
.52633 .5829 m .54669 .5922 L .55369 .61012 L closepath p F P
0 g
s
0 .203 .73 r
.57625 .62992 m .54669 .5922 L .55369 .61012 L closepath p F P
0 g
s
.97 .845 .662 r
.51731 .58642 m .52633 .5829 L .5261 .63143 L closepath p F P
0 g
s
.675 .682 .849 r
.3564 .6124 m .51731 .58642 L .5261 .63143 L closepath p F P
0 g
s
.815 .703 .741 r
.3564 .6124 m .35369 .57438 L .29213 .5673 L closepath p F P
0 g
s
.671 .712 .879 r
.36108 .59997 m .3564 .6124 L .51731 .58642 L closepath p F P
0 g
s
.318 .318 .702 r
.36108 .59997 m .3564 .6124 L .35369 .57438 L closepath p F P
0 g
s
.146 .534 .921 r
.12976 .47914 m .3564 .6124 L .29213 .5673 L closepath p F P
0 g
s
.276 .297 .702 r
.36813 .58786 m .35369 .57438 L .36977 .55644 L closepath p F P
0 g
s
.288 .299 .697 r
.36108 .59997 m .36813 .58786 L .35369 .57438 L closepath p F P
0 g
s
.697 .836 .949 r
.34056 .55107 m .35369 .57438 L .29213 .5673 L closepath p F P
0 g
s
.585 .778 .971 r
.34056 .55107 m .35369 .57438 L .36977 .55644 L closepath p F P
0 g
s
.649 .761 .931 r
.36108 .59997 m .36813 .58786 L .51731 .58642 L closepath p F P
0 g
s
.586 .072 0 r
.51731 .58642 m .52633 .5829 L .54669 .5922 L closepath p F P
0 g
s
.58 .581 .818 r
.56537 .58158 m .57625 .62992 L .54669 .5922 L closepath p F P
0 g
s
.661 .635 .813 r
.61089 .52768 m .56537 .58158 L .57625 .62992 L closepath p F P
0 g
s
.541 .505 .765 r
.61089 .52768 m .69016 .60915 L .57625 .62992 L closepath p F P
0 g
s
.706 .595 .73 r
.36813 .58786 m .37695 .54888 L .51731 .58642 L closepath p F P
0 g
s
0 0 .263 r
.36813 .58786 m .37695 .54888 L .3756 .56107 L closepath p F P
0 g
s
.847 .793 .799 r
.36813 .58786 m .36977 .55644 L .3756 .56107 L closepath p F P
0 g
s
.619 .686 .891 r
.56537 .58158 m .51731 .58642 L .54669 .5922 L closepath p F P
0 g
s
.625 .661 .865 r
.59908 .50142 m .56537 .58158 L .51731 .58642 L closepath p F P
0 g
s
.441 .71 .98 r
.37695 .54888 m .37734 .53712 L .51731 .58642 L closepath p F P
0 g
s
.656 .716 .892 r
.45323 .47426 m .59908 .50142 L .51731 .58642 L closepath p F P
0 g
s
.637 .706 .897 r
.45323 .47426 m .37734 .53712 L .51731 .58642 L closepath p F P
0 g
s
.89 .973 .667 r
.36977 .55644 m .37695 .54888 L .37734 .53712 L closepath p F P
0 g
s
.939 .72 .58 r
.36977 .55644 m .37695 .54888 L .3756 .56107 L closepath p F P
0 g
s
.675 .571 .731 r
.34056 .55107 m .34659 .53548 L .29213 .5673 L closepath p F P
0 g
s
.69 .971 .925 r
.34979 .52022 m .34659 .53548 L .29213 .5673 L closepath p F P
0 g
s
.562 .567 .816 r
.27376 .43192 m .34979 .52022 L .29213 .5673 L closepath p F P
0 g
s
.651 .632 .819 r
.204 .48247 m .27376 .43192 L .29213 .5673 L closepath p F P
0 g
s
.629 .629 .831 r
.204 .48247 m .12976 .47914 L .29213 .5673 L closepath p F P
0 g
s
.904 .975 .802 r
.36977 .55644 m .37049 .54407 L .37734 .53712 L closepath p F P
0 g
s
.392 .566 .905 r
.34723 .53447 m .36977 .55644 L .37049 .54407 L closepath p F P
0 g
s
.752 .653 .752 r
.34056 .55107 m .34723 .53447 L .36977 .55644 L closepath p F P
0 g
s
.787 .853 .9 r
.59908 .50142 m .61089 .52768 L .56537 .58158 L closepath p F P
0 g
s
.954 .93 .735 r
.34056 .55107 m .34723 .53447 L .34659 .53548 L closepath p F P
0 g
s
.216 .55 .931 r
.3603 .53517 m .34723 .53447 L .37049 .54407 L closepath p F P
0 g
s
.317 .053 .345 r
.3603 .53517 m .34723 .53447 L .34659 .53548 L closepath p F P
0 g
s
.848 .724 .727 r
.12976 .47914 m .13327 .4679 L .09576 .43377 L closepath p F P
0 g
s
.672 .531 .684 r
.15574 .46514 m .12976 .47914 L .13327 .4679 L closepath p F P
0 g
s
.654 .764 .93 r
.13565 .42608 m .15574 .46514 L .13327 .4679 L closepath p F P
0 g
s
.571 .696 .926 r
.12691 .42707 m .13327 .4679 L .09576 .43377 L closepath p F P
0 g
s
.61 .725 .927 r
.12691 .42707 m .13565 .42608 L .13327 .4679 L closepath p F P
0 g
s
.274 .603 .953 r
.34979 .52022 m .3603 .53517 L .34659 .53548 L closepath p F P
0 g
s
.605 .662 .879 r
.12976 .47914 m .09576 .43377 L .08688 .4357 L closepath p F P
0 g
s
.649 .483 .645 r
.204 .48247 m .15574 .46514 L .12976 .47914 L closepath p F P
0 g
s
.452 .373 .677 r
.15574 .46514 m .18427 .44014 L .19012 .45412 L closepath p F P
0 g
s
.303 .797 .803 r
.15574 .46514 m .2006 .45221 L .19012 .45412 L closepath p F P
0 g
s
.603 .541 .758 r
.204 .48247 m .15574 .46514 L .2006 .45221 L closepath p F P
0 g
s
.674 .774 .925 r
.13565 .42608 m .15574 .46514 L .18427 .44014 L closepath p F P
0 g
s
.856 .731 .725 r
.3603 .53517 m .37049 .54407 L .37734 .53712 L closepath p F P
0 g
s
.703 .875 .962 r
.45323 .47426 m .3603 .53517 L .37734 .53712 L closepath p F P
0 g
s
.607 .545 .758 r
.204 .48247 m .27376 .43192 L .2006 .45221 L closepath p F P
0 g
s
.7 .846 .953 r
.45323 .47426 m .34979 .52022 L .3603 .53517 L closepath p F P
0 g
s
.287 .787 .794 r
.27376 .43192 m .2006 .45221 L .19012 .45412 L closepath p F P
0 g
s
.545 .506 .763 r
.64188 .52163 m .61089 .52768 L .69016 .60915 L closepath p F P
0 g
s
.541 .72 .956 r
.59908 .50142 m .64188 .52163 L .61089 .52768 L closepath p F P
0 g
s
.548 .363 .583 r
.09576 .43377 m .09529 .42959 L .08688 .4357 L closepath p F P
0 g
s
.782 .911 .928 r
.09583 .38937 m .09529 .42959 L .08688 .4357 L closepath p F P
0 g
s
.518 .342 .582 r
.12691 .42707 m .09576 .43377 L .09529 .42959 L closepath p F P
0 g
s
.499 .683 .949 r
.12691 .42707 m .09583 .38937 L .09529 .42959 L closepath p F P
0 g
s
.447 .763 .996 r
.14231 .42294 m .13565 .42608 L .18427 .44014 L closepath p F P
0 g
s
0 0 .388 r
.17033 .39168 m .18427 .44014 L .19012 .45412 L closepath p F P
0 g
s
.687 .807 .939 r
.17033 .39168 m .14231 .42294 L .18427 .44014 L closepath p F P
0 g
s
.672 .74 .902 r
.17033 .39168 m .27376 .43192 L .19012 .45412 L closepath p F P
0 g
s
.698 .714 .861 r
.63313 .30106 m .59908 .50142 L .64188 .52163 L closepath p F P
0 g
s
.362 .415 .782 r
.65277 .27761 m .64188 .52163 L .69016 .60915 L closepath p F P
0 g
s
.755 .758 .855 r
.65277 .27761 m .63313 .30106 L .64188 .52163 L closepath p F P
0 g
s
.678 .676 .841 r
.34979 .52022 m .40153 .44169 L .36912 .43158 L closepath p F P
0 g
s
.634 .633 .832 r
.29565 .43776 m .34979 .52022 L .36912 .43158 L closepath p F P
0 g
s
.26 .447 .856 r
.27376 .43192 m .29565 .43776 L .34979 .52022 L closepath p F P
0 g
s
.685 .686 .846 r
.45323 .47426 m .34979 .52022 L .40153 .44169 L closepath p F P
0 g
s
.491 .517 .811 r
.67194 .18788 m .65277 .27761 L .69016 .60915 L closepath p F P
0 g
s
.739 .777 .884 r
.12691 .42707 m .14068 .40633 L .09583 .38937 L closepath p F P
0 g
s
.631 .624 .825 r
.12691 .42707 m .13565 .42608 L .14068 .40633 L closepath p F P
0 g
s
.289 .275 .671 r
.14231 .42294 m .13565 .42608 L .14068 .40633 L closepath p F P
0 g
s
.286 .431 .832 r
.27376 .43192 m .29565 .43776 L .26608 .36224 L closepath p F P
0 g
s
.672 .74 .902 r
.17033 .39168 m .27376 .43192 L .26608 .36224 L closepath p F P
0 g
s
.692 .708 .86 r
.53748 .39096 m .63313 .30106 L .59908 .50142 L closepath p F P
0 g
s
.727 .723 .846 r
.4985 .46023 m .53748 .39096 L .59908 .50142 L closepath p F P
0 g
s
.594 .746 .949 r
.4985 .46023 m .45323 .47426 L .59908 .50142 L closepath p F P
0 g
s
.41 .369 .702 r
.17033 .39168 m .14231 .42294 L .14068 .40633 L closepath p F P
0 g
s
.763 .768 .856 r
.14957 .36348 m .14068 .40633 L .09583 .38937 L closepath p F P
0 g
s
.447 .455 .774 r
.17033 .39168 m .14957 .36348 L .14068 .40633 L closepath p F P
0 g
s
.74 .676 .789 r
.42737 .42646 m .45323 .47426 L .40153 .44169 L closepath p F P
0 g
s
.586 .608 .841 r
.4985 .46023 m .42737 .42646 L .45323 .47426 L closepath p F P
0 g
s
.632 .649 .849 r
.29565 .43776 m .26608 .36224 L .36912 .43158 L closepath p F P
0 g
s
.351 0 .142 r
.14957 .36348 m .14727 .37344 L .09583 .38937 L closepath p F P
0 g
s
.26 .157 .543 r
.15888 .3154 m .09583 .38937 L .24585 .18478 L closepath p F P
0 g
s
.653 .731 .906 r
.15888 .3154 m .14727 .37344 L .09583 .38937 L closepath p F P
0 g
s
.034 .263 .761 r
.16231 .36624 m .17033 .39168 L .1696 .39068 L p F P
0 g
s
.034 .263 .761 r
.1696 .39068 m .14957 .36348 L .16231 .36624 L p F P
0 g
s
.619 .697 .9 r
.16231 .36624 m .15888 .3154 L .15417 .33895 L p F P
0 g
s
.187 0 .099 r
.16231 .36624 m .14957 .36348 L .14727 .37344 L closepath p F P
0 g
s
.619 .697 .9 r
.15417 .33895 m .14727 .37344 L .16231 .36624 L p F P
0 g
s
.723 .633 .757 r
.42737 .42646 m .40153 .44169 L .36912 .43158 L closepath p F P
0 g
s
.672 .723 .888 r
.16231 .36624 m .17033 .39168 L .26608 .36224 L closepath p F P
0 g
s
.717 .709 .842 r
.42737 .42646 m .48053 .29397 L .36912 .43158 L closepath p F P
0 g
s
.63 .609 .81 r
.42737 .42646 m .48053 .29397 L .48421 .37701 L closepath p F P
0 g
s
.623 .596 .802 r
.4985 .46023 m .42737 .42646 L .48421 .37701 L closepath p F P
0 g
s
.651 .649 .835 r
.31351 .27618 m .26608 .36224 L .36912 .43158 L closepath p F P
0 g
s
.717 .71 .842 r
.39646 .25862 m .48053 .29397 L .36912 .43158 L closepath p F P
0 g
s
.656 .652 .834 r
.39646 .25862 m .31351 .27618 L .36912 .43158 L closepath p F P
0 g
s
.638 .607 .802 r
.4985 .46023 m .53748 .39096 L .48421 .37701 L closepath p F P
0 g
s
.664 .738 .905 r
.16231 .36624 m .25951 .31543 L .26608 .36224 L closepath p F P
0 g
s
.662 .731 .901 r
.16231 .36624 m .15888 .3154 L .25951 .31543 L closepath p F P
0 g
s
.524 .49 .761 r
.29881 .26981 m .31351 .27618 L .26608 .36224 L closepath p F P
0 g
s
.859 .866 .844 r
.29881 .26981 m .25951 .31543 L .26608 .36224 L closepath p F P
0 g
s
.713 .674 .811 r
.55875 .31058 m .48053 .29397 L .48421 .37701 L closepath p F P
0 g
s
.66 .578 .752 r
.53748 .39096 m .55875 .31058 L .48421 .37701 L closepath p F P
0 g
s
.553 .469 .714 r
.53748 .39096 m .63313 .30106 L .55875 .31058 L closepath p F P
0 g
s
.089 .612 .878 r
.56638 .30928 m .55875 .31058 L .48053 .29397 L closepath p F P
0 g
s
.293 0 0 r
.63313 .30106 m .55875 .31058 L .57178 .31259 L closepath p F P
0 g
s
.063 .52 .896 r
.56638 .30928 m .55875 .31058 L .57178 .31259 L closepath p F P
0 g
s
.678 .702 .865 r
.15888 .3154 m .25951 .31543 L .24585 .18478 L closepath p F P
0 g
s
.835 .812 .828 r
.29881 .26981 m .25951 .31543 L .24585 .18478 L closepath p F P
0 g
s
.605 .661 .878 r
.56638 .30928 m .47069 .2478 L .48053 .29397 L closepath p F P
0 g
s
.691 .72 .871 r
.39646 .25862 m .47069 .2478 L .48053 .29397 L closepath p F P
0 g
s
.778 .796 .868 r
.29881 .26981 m .31037 .16521 L .24585 .18478 L closepath p F P
0 g
s
.467 .514 .822 r
.29881 .26981 m .31351 .27618 L .31037 .16521 L closepath p F P
0 g
s
.602 .76 .955 r
.63313 .30106 m .56638 .30928 L .57178 .31259 L closepath p F P
0 g
s
.555 .587 .841 r
.31351 .27618 m .40352 .21185 L .31037 .16521 L closepath p F P
0 g
s
.638 .785 .952 r
.39646 .25862 m .31351 .27618 L .40352 .21185 L closepath p F P
0 g
s
.638 .619 .815 r
.63213 .20613 m .63313 .30106 L .56638 .30928 L closepath p F P
0 g
s
.651 .661 .847 r
.61888 .19369 m .56638 .30928 L .47069 .2478 L closepath p F P
0 g
s
.774 .811 .882 r
.61888 .19369 m .63213 .20613 L .56638 .30928 L closepath p F P
0 g
s
.703 .672 .817 r
.63213 .20613 m .65277 .27761 L .63313 .30106 L closepath p F P
0 g
s
.658 .803 .952 r
.39646 .25862 m .40352 .21185 L .47069 .2478 L closepath p F P
0 g
s
.65 .656 .843 r
.61888 .19369 m .51715 .13133 L .47069 .2478 L closepath p F P
0 g
s
.775 .802 .875 r
.40352 .21185 m .51715 .13133 L .47069 .2478 L closepath p F P
0 g
s
.551 .576 .833 r
.67194 .18788 m .63213 .20613 L .65277 .27761 L closepath p F P
0 g
s
.594 .764 .96 r
.67194 .18788 m .61888 .19369 L .63213 .20613 L closepath p F P
0 g
s
.468 .891 .884 r
.34963 .14277 m .31037 .16521 L .24585 .18478 L closepath p F P
0 g
s
.404 .845 .732 r
.34963 .14277 m .38646 .12643 L .31037 .16521 L closepath p F P
0 g
s
.611 .571 .785 r
.40352 .21185 m .38646 .12643 L .31037 .16521 L closepath p F P
0 g
s
.635 .658 .855 r
.67194 .18788 m .61888 .19369 L .51715 .13133 L closepath p F P
0 g
s
.695 .628 .777 r
.40352 .21185 m .42287 .13379 L .38646 .12643 L closepath p F P
0 g
s
.54 .733 .964 r
.42287 .13379 m .38646 .12643 L .43151 .1241 L closepath p F P
0 g
s
.507 .759 .987 r
.38646 .12643 m .43151 .1241 L .42815 .11521 L closepath p F P
0 g
s
.429 .832 .977 r
.38646 .12643 m .38382 .12445 L .42815 .11521 L closepath p F P
0 g
s
.781 .981 .907 r
.34963 .14277 m .38646 .12643 L .38382 .12445 L closepath p F P
0 g
s
.396 .828 .956 r
.42053 .11163 m .38382 .12445 L .42815 .11521 L closepath p F P
0 g
s
0 0 0 r
.34963 .14277 m .42053 .11163 L .38382 .12445 L closepath p F P
0 g
s
.581 .484 .708 r
.34963 .14277 m .42053 .11163 L .24585 .18478 L closepath p F P
0 g
s
.718 .651 .782 r
.40352 .21185 m .51715 .13133 L .42287 .13379 L closepath p F P
0 g
s
.305 0 0 r
.51715 .13133 m .44117 .13874 L .42287 .13379 L closepath p F P
0 g
s
.232 .258 .682 r
.44117 .13874 m .42287 .13379 L .43151 .1241 L closepath p F P
0 g
s
.628 .189 0 r
.44117 .13874 m .43151 .1241 L .4335 .12806 L closepath p F P
0 g
s
0 0 .293 r
.43151 .1241 m .4335 .12806 L .42815 .11521 L closepath p F P
0 g
s
.892 .483 .069 r
.42053 .11163 m .4335 .12806 L .42815 .11521 L closepath p F P
0 g
s
.827 .754 .783 r
.51715 .13133 m .42053 .11163 L .4335 .12806 L closepath p F P
0 g
s
.783 .831 .889 r
.51715 .13133 m .44117 .13874 L .4335 .12806 L closepath p F P
0 g
s
.611 .057 0 r
.67194 .18788 m .51715 .13133 L .42053 .11163 L closepath p F P
0 g
s
.25 Mabswid
.02319 .43105 m
.30833 0 L
s
.30833 0 m
.29755 .18561 L
s
.29755 .18561 m
0 .60069 L
s
0 .60069 m
.02319 .43105 L
s
.97189 .25642 m
.30833 0 L
s
.30833 0 m
.29755 .18561 L
s
.29755 .18561 m
1 .43378 L
s
1 .43378 m
.97189 .25642 L
s
.97189 .25642 m
.30833 0 L
s
.85746 .2122 m
.85281 .21682 L
s
[(-100)] .86677 .20296 -1 .99326 Mshowa
.62069 .12071 m
.61645 .1257 L
s
[(0)] .62918 .11071 -0.8493 1 Mshowa
.36118 .02043 m
.35745 .02582 L
s
[(100)] .36865 .00964 -0.69182 1 Mshowa
.125 Mabswid
.81178 .19455 m
.80904 .19736 L
s
.76529 .17658 m
.76259 .17944 L
s
.71796 .15829 m
.71531 .1612 L
s
.66977 .13967 m
.66717 .14262 L
s
.57071 .10139 m
.56822 .10444 L
s
.5198 .08172 m
.51736 .08481 L
s
.46792 .06167 m
.46555 .06481 L
s
.41506 .04124 m
.41275 .04443 L
s
.90235 .22954 m
.89952 .23227 L
s
.94646 .24659 m
.94359 .24928 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.0.4"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics3D", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S5.0.4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Graphics and Geometry Packages", "Subsection",
 CellTags->{"S5.0.5", "5.1"}],

Cell[TextData[{
 "The ",
 StyleBox["Graphics", "MR"],
 " packages offer log, polar, error, scatter, vector field, surface of \
revolution, three\[Hyphen]dimensional contour, and implicit plots. Functions \
include maps for visualizing complex functions of complex numbers, and bar \
and pie charts for visualizing data. ",
 StyleBox["Mathematica", "TI"],
 "\[CloseCurlyQuote]s built\[Hyphen]in graphics are enhanced by arrow, \
legend, and color directives, and by two\[Hyphen]dimensional spline \
primitives and three\[Hyphen]dimensional shape primitives. There are \
functions for the stellation and geodesation of regular polyhedra, animation \
of a sequence of graphics, and support for the 3\[Hyphen]Script file format. \
The ",
 StyleBox["Geometry", "MR"],
 " packages provide functions giving the characteristics of regular polygons \
and polyhedra and rotation in two and three dimensions. "
}], "Text",
 CellTags->{"S5.0.5", "5.2"}],

Cell[TextData[{
 "This causes each ",
 StyleBox["Graphics", "MR"],
 " package to be loaded as functions from the package are needed. "
}], "MathCaption",
 CellTags->{"S5.0.5", "5.3"}],

Cell["<<Graphics`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.0.5"],

Cell[TextData[{
 "Here is a pie chart of the distribution of certain ",
 StyleBox["Mathematica", "TI"],
 " users by field. "
}], "MathCaption",
 CellTags->{"S5.0.5", "5.4"}],

Cell[CellGroupData[{

Cell["\<\
(styles = Map[Hue, Range[0, 10]/10 .7];
ShowLegend[
PieChart[ {29, 20, 16, 16, 5, 4, 3, 2, 1, 1, 4},
   PieStyle -> styles, PieLabels -> Join[
   {\"Engineering\", \"Physical Sciences\",
    \"Computer Sciences\", \"Mathematical Sciences\"},
   Table[\"\", {7}]], DisplayFunction -> Identity],
   {Transpose[{Drop[styles, 4],
    {\"Life Sciences\", \"Business Finance\",
     \"Administration\", \"Social Sciences\",
     \"Arts Humanities\", \"Technology\", \"Other\"}
    }], LegendTextSpace -> 8, LegendPosition->{.5, -1},
        LegendShadow->{0, 0}},
    ImageSize -> {370, 370}
])\
\>", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.0.5"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .86957 
%%ImageSize: 370 370 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.437888 0.414079 0.434783 0.414079 [
[ 0 0 0 0 ]
[ 1 .86957 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
% Start of sub-graphic
p
0.0238095 0.0207039 0.851967 0.848861 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.47619 0.5 0.47619 [
[.67715 .72417 -35 -5.0625 ]
[.67715 .72417 35 5.0625 ]
[.28434 .68741 -53 -5.0625 ]
[.28434 .68741 53 5.0625 ]
[.23733 .38759 -53 -5.0625 ]
[.23733 .38759 53 5.0625 ]
[.45136 .21846 -65 -5.0625 ]
[.45136 .21846 65 5.0625 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
1 0 0 r
.5 .5 m
.5 .5 .47619 0 103.366 arc
F
1 .42 0 r
.5 .5 m
.5 .5 .47619 103.366 174.653 arc
F
1 .84 0 r
.5 .5 m
.5 .5 .47619 174.653 231.683 arc
F
.74 1 0 r
.5 .5 m
.5 .5 .47619 231.683 288.713 arc
F
.32 1 0 r
.5 .5 m
.5 .5 .47619 288.713 306.535 arc
F
0 1 .1 r
.5 .5 m
.5 .5 .47619 306.535 320.792 arc
F
0 1 .52 r
.5 .5 m
.5 .5 .47619 320.792 331.485 arc
F
0 1 .94 r
.5 .5 m
.5 .5 .47619 331.485 338.614 arc
F
0 .64 1 r
.5 .5 m
.5 .5 .47619 338.614 342.178 arc
F
0 .22 1 r
.5 .5 m
.5 .5 .47619 342.178 345.743 arc
F
.2 0 1 r
.5 .5 m
.5 .5 .47619 345.743 360 arc
F
0 g
.5 Mabswid
[ ] 0 setdash
.5 .5 m
.97619 .5 L
s
.5 .5 m
.38992 .96329 L
s
newpath
.5 .5 .47619 0 103.366 arc
s
.5 .5 m
.38992 .96329 L
s
.5 .5 m
.02588 .54437 L
s
newpath
.5 .5 .47619 103.366 174.653 arc
s
.5 .5 m
.02588 .54437 L
s
.5 .5 m
.20476 .12638 L
s
newpath
.5 .5 .47619 174.653 231.683 arc
s
.5 .5 m
.20476 .12638 L
s
.5 .5 m
.65277 .04898 L
s
newpath
.5 .5 .47619 231.683 288.713 arc
s
.5 .5 m
.65277 .04898 L
s
.5 .5 m
.78348 .11738 L
s
newpath
.5 .5 .47619 288.713 306.535 arc
s
.5 .5 m
.78348 .11738 L
s
.5 .5 m
.86898 .19898 L
s
newpath
.5 .5 .47619 306.535 320.792 arc
s
.5 .5 m
.86898 .19898 L
s
.5 .5 m
.91843 .27267 L
s
newpath
.5 .5 .47619 320.792 331.485 arc
s
.5 .5 m
.91843 .27267 L
s
.5 .5 m
.9434 .32636 L
s
newpath
.5 .5 .47619 331.485 338.614 arc
s
.5 .5 m
.9434 .32636 L
s
.5 .5 m
.95334 .35426 L
s
newpath
.5 .5 .47619 338.614 342.178 arc
s
.5 .5 m
.95334 .35426 L
s
.5 .5 m
.96152 .38272 L
s
newpath
.5 .5 .47619 342.178 345.743 arc
s
.5 .5 m
.96152 .38272 L
s
.5 .5 m
.97619 .5 L
s
newpath
.5 .5 .47619 345.743 360 arc
s
gsave
.67715 .72417 -96 -9.0625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18.125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Engineering) show
129.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.28434 .68741 -114 -9.0625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18.125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Physical) show
117.000 11.562 moveto
(Sciences) show
165.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.23733 .38759 -114 -9.0625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18.125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Computer) show
117.000 11.562 moveto
(Sciences) show
165.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.45136 .21846 -126 -9.0625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18.125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Mathematical) show
141.000 11.562 moveto
(Sciences) show
189.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
0 g
.64493 .0207 m
.64493 .31516 L
.97619 .31516 L
.97619 .0207 L
F
1 g
.64493 .0207 m
.64493 .31516 L
.97619 .31516 L
.97619 .0207 L
F
0 g
.001 w
[ ] 0 setdash
.64493 .0207 m
.97619 .0207 L
.97619 .31516 L
.64493 .31516 L
.64493 .0207 L
s
% Start of sub-graphic
p
0.644928 0.0207039 0.97619 0.31516 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0106838 0.106838 0.0106838 0.106838 [
[ 0 0 0 0 ]
[ 1 .88889 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .88889 L
0 .88889 L
closepath
clip
newpath
.2 0 1 r
.01923 .01923 m
.01923 .12607 L
.12607 .12607 L
.12607 .01923 L
F
0 g
gsave
.13996 .07265 -61 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Other) show
93.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .22 1 r
.01923 .14316 m
.01923 .25 L
.12607 .25 L
.12607 .14316 L
F
0 g
gsave
.13996 .19658 -61 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Technology) show
123.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .64 1 r
.01923 .26709 m
.01923 .37393 L
.12607 .37393 L
.12607 .26709 L
F
0 g
gsave
.13996 .32051 -61 -9.0625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18.125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Arts) show
93.000 11.562 moveto
(Humanities) show
153.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 1 .94 r
.01923 .39103 m
.01923 .49786 L
.12607 .49786 L
.12607 .39103 L
F
0 g
gsave
.13996 .44444 -61 -9.0625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18.125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Social) show
105.000 11.562 moveto
(Sciences) show
153.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 1 .52 r
.01923 .51496 m
.01923 .62179 L
.12607 .62179 L
.12607 .51496 L
F
0 g
gsave
.13996 .56838 -61 -9.0625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18.125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Administration) show
147.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 1 .1 r
.01923 .63889 m
.01923 .74573 L
.12607 .74573 L
.12607 .63889 L
F
0 g
gsave
.13996 .69231 -61 -9.0625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18.125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Business) show
117.000 11.562 moveto
(Finance) show
159.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.32 1 0 r
.01923 .76282 m
.01923 .86966 L
.12607 .86966 L
.12607 .76282 L
F
0 g
gsave
.13996 .81624 -61 -9.0625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18.125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Life) show
93.000 11.562 moveto
(Sciences) show
141.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
MathSubEnd
P
% End of sub-graphic
0 0 m
1 0 L
1 .86957 L
0 .86957 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.0.5"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.0.5"]
}, Open  ]],

Cell[TextData[{
 "This gives a histogram of the number of primes near four different values \
of ",
 Cell[BoxData[
  FormBox[
   StyleBox["x",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". The bin widths are proportional to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"log", 
    StyleBox["x",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " in each case. "
}], "MathCaption",
 CellTags->{"S5.0.5", "5.5"}],

Cell[CellGroupData[{

Cell["\<\
(t = Map[ (w = 25 Log[#];
  Table[PrimePi[# + j w] - PrimePi[# + (j-1)w],
  {j, -3, 4}])&, 10^(1 + 2Range[4])];
BarChart3D[t, XSpacing -> .8,
  Ticks -> {{{1, 10^3}, {2, 10^5}, {3, 10^7}, {4, 10^9}},
  None, Automatic}])\
\>", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.0.5"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.0855 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0567234 1.16608 -8.27246e-17 1.16608 [
[.10639 .22326 -23.532 -9 ]
[.10639 .22326 .46801 0 ]
[.26898 .15458 -33.3322 -9 ]
[.26898 .15458 2.66779 0 ]
[.44302 .08111 -41.8219 -9 ]
[.44302 .08111 6.1781 0 ]
[.62976 .00236 -49.0011 -9 ]
[.62976 .00236 10.9989 0 ]
[.07325 .26228 -6 -2.6177 ]
[.07325 .26228 0 6.3823 ]
[.04987 .40863 -12 -2.74781 ]
[.04987 .40863 0 6.25219 ]
[.02388 .5713 -12 -2.89396 ]
[.02388 .5713 0 6.10604 ]
[-0.00517 .7532 -12 -3.05931 ]
[-0.00517 .7532 0 5.94069 ]
[ 0 0 0 0 ]
[ 1 1.0855 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.08846 .24555 m
.67245 0 L
s
.11649 .23377 m
.12154 .23902 L
s
[(1000)] .10639 .22326 .961 1 Mshowa
.27843 .16567 m
.28316 .17122 L
s
[(100000)] .26898 .15458 .85179 1 Mshowa
.45171 .09281 m
.45606 .09867 L
s
[(10000000)] .44302 .08111 .74258 1 Mshowa
.63756 .01467 m
.64146 .02083 L
s
[(1000000000)] .62976 .00236 .63337 1 Mshowa
0 .80374 m
.40037 1.0855 L
s
.08846 .24555 m
0 .80374 L
s
.0867 .25665 m
.09342 .25384 L
s
[(0)] .07325 .26228 1 -0.41829 Mshowa
.06345 .40334 m
.07024 .40069 L
s
[(10)] .04987 .40863 1 -0.38938 Mshowa
.03761 .5664 m
.04447 .56395 L
s
[(20)] .02388 .5713 1 -0.3569 Mshowa
.00871 .74875 m
.01565 .74653 L
s
[(30)] -0.00517 .7532 1 -0.32015 Mshowa
.125 Mabswid
.08224 .2848 m
.08628 .28313 L
s
.07768 .31352 m
.08174 .31187 L
s
.07304 .34284 m
.0771 .34121 L
s
.0683 .37277 m
.07236 .37117 L
s
.0585 .43456 m
.06259 .43299 L
s
.05345 .46645 m
.05754 .46491 L
s
.04829 .49904 m
.05239 .49752 L
s
.04301 .53235 m
.04712 .53086 L
s
.03209 .60123 m
.03622 .59978 L
s
.02645 .63684 m
.03058 .63543 L
s
.02067 .67328 m
.02482 .67189 L
s
.01476 .71058 m
.01892 .70921 L
s
.00252 .78784 m
.00669 .78654 L
s
.25 Mabswid
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.40037 1.0855 L
s
.40037 1.0855 m
.41799 .58158 L
s
.41799 .58158 m
.08846 .24555 L
s
.67245 0 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.67245 0 m
.08846 .24555 L
s
.41799 .58158 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.40037 1.0855 L
s
.40037 1.0855 m
.41799 .58158 L
s
0 0 m
1 0 L
1 1.0855 L
0 1.0855 L
closepath
clip
newpath
.5 Mabswid
.672 .728 .891 r
.45015 .57249 m .42216 .58164 L .38861 .54734 L p F P
0 g
s
.573 .367 .563 r
.44195 .90511 m .45015 .57249 L .42216 .58164 L p F P
0 g
s
.573 .367 .563 r
.42216 .58164 m .41101 .91323 L .44195 .90511 L p F P
0 g
s
.938 .685 .528 r
.38861 .54734 m .42216 .58164 L .41101 .91323 L p F P
0 g
s
.672 .728 .891 r
.38861 .54734 m .41699 .53781 L .45015 .57249 L p F P
0 g
s
.942 .686 .521 r
.41699 .53781 m .45015 .57249 L .44195 .90511 L p F P
0 g
s
.938 .685 .528 r
.41101 .91323 m .37354 .88275 L .38861 .54734 L p F P
0 g
s
.567 .357 .556 r
.40495 .87426 m .41699 .53781 L .38861 .54734 L p F P
0 g
s
.567 .357 .556 r
.38861 .54734 m .37354 .88275 L .40495 .87426 L p F P
0 g
s
.672 .728 .891 r
.41699 .53781 m .38861 .54734 L .35365 .5116 L p F P
0 g
s
.567 .357 .556 r
.40495 .87426 m .41699 .53781 L .38861 .54734 L p F P
0 g
s
.567 .357 .556 r
.38861 .54734 m .37354 .88275 L .40495 .87426 L p F P
0 g
s
.938 .685 .528 r
.35365 .5116 m .38861 .54734 L .37354 .88275 L p F P
0 g
s
.942 .686 .521 r
.44195 .90511 m .40495 .87426 L .41699 .53781 L p F P
0 g
s
.672 .728 .891 r
.35365 .5116 m .38243 .50166 L .41699 .53781 L p F P
0 g
s
.942 .686 .521 r
.38243 .50166 m .41699 .53781 L .40495 .87426 L p F P
0 g
s
.672 .728 .891 r
.59484 .52518 m .56525 .53485 L .53377 .49858 L p F P
0 g
s
.573 .367 .563 r
.60282 .87938 m .59484 .52518 L .56525 .53485 L p F P
0 g
s
.573 .367 .563 r
.56525 .53485 m .56976 .88796 L .60282 .87938 L p F P
0 g
s
.956 .688 .486 r
.53377 .49858 m .56525 .53485 L .56976 .88796 L p F P
0 g
s
.672 .728 .891 r
.53377 .49858 m .56381 .48849 L .59484 .52518 L p F P
0 g
s
.96 .688 .475 r
.56381 .48849 m .59484 .52518 L .60282 .87938 L p F P
0 g
s
.938 .685 .528 r
.37354 .88275 m .33431 .85085 L .35365 .5116 L p F P
0 g
s
.56 .347 .549 r
.36621 .84195 m .38243 .50166 L .35365 .5116 L p F P
0 g
s
.56 .347 .549 r
.35365 .5116 m .33431 .85085 L .36621 .84195 L p F P
0 g
s
.672 .728 .891 r
.38243 .50166 m .35365 .5116 L .31718 .47432 L p F P
0 g
s
.645 .763 .935 r
.33431 .85085 m .36621 .84195 L .40495 .87426 L p F P
0 g
s
.56 .347 .549 r
.36542 .8585 m .38243 .50166 L .35365 .5116 L p F P
0 g
s
.645 .763 .935 r
.40495 .87426 m .37354 .88275 L .33431 .85085 L p F P
0 g
s
.56 .347 .549 r
.35365 .5116 m .33337 .86733 L .36542 .8585 L p F P
0 g
s
.938 .685 .528 r
.31718 .47432 m .35365 .5116 L .33337 .86733 L p F P
0 g
s
.942 .686 .521 r
.40495 .87426 m .36621 .84195 L .38243 .50166 L p F P
0 g
s
.672 .728 .891 r
.31718 .47432 m .34637 .46395 L .38243 .50166 L p F P
0 g
s
.942 .686 .521 r
.34637 .46395 m .38243 .50166 L .36542 .8585 L p F P
0 g
s
.567 .357 .556 r
.56828 .84677 m .56381 .48849 L .53377 .49858 L p F P
0 g
s
.956 .688 .486 r
.56976 .88796 m .53465 .85575 L .53377 .49858 L p F P
0 g
s
.567 .357 .556 r
.53377 .49858 m .53465 .85575 L .56828 .84677 L p F P
0 g
s
.672 .728 .891 r
.56381 .48849 m .53377 .49858 L .50093 .46073 L p F P
0 g
s
.567 .357 .556 r
.56787 .81368 m .56381 .48849 L .53377 .49858 L p F P
0 g
s
.567 .357 .556 r
.53377 .49858 m .53457 .82279 L .56787 .81368 L p F P
0 g
s
.956 .688 .486 r
.50093 .46073 m .53377 .49858 L .53457 .82279 L p F P
0 g
s
.96 .688 .475 r
.60282 .87938 m .56828 .84677 L .56381 .48849 L p F P
0 g
s
.672 .728 .891 r
.50093 .46073 m .53142 .4502 L .56381 .48849 L p F P
0 g
s
.96 .688 .475 r
.53142 .4502 m .56381 .48849 L .56787 .81368 L p F P
0 g
s
.672 .728 .891 r
.74795 .47512 m .71662 .48536 L .68751 .44694 L p F P
0 g
s
.573 .367 .563 r
.78097 .92094 m .74795 .47512 L .71662 .48536 L p F P
0 g
s
.573 .367 .563 r
.71662 .48536 m .74478 .92975 L .78097 .92094 L p F P
0 g
s
.972 .685 .424 r
.68751 .44694 m .71662 .48536 L .74478 .92975 L p F P
0 g
s
.672 .728 .891 r
.68751 .44694 m .71935 .43624 L .74795 .47512 L p F P
0 g
s
.974 .683 .409 r
.71935 .43624 m .74795 .47512 L .78097 .92094 L p F P
0 g
s
.938 .685 .528 r
.33337 .86733 m .29203 .83413 L .31718 .47432 L p F P
0 g
s
.552 .336 .54 r
.32459 .82486 m .34637 .46395 L .31718 .47432 L p F P
0 g
s
.552 .336 .54 r
.31718 .47432 m .29203 .83413 L .32459 .82486 L p F P
0 g
s
.672 .728 .891 r
.34637 .46395 m .31718 .47432 L .27912 .43541 L p F P
0 g
s
.643 .765 .937 r
.29203 .83413 m .32459 .82486 L .36542 .8585 L p F P
0 g
s
.552 .336 .54 r
.32357 .8418 m .34637 .46395 L .31718 .47432 L p F P
0 g
s
.643 .765 .937 r
.36542 .8585 m .33337 .86733 L .29203 .83413 L p F P
0 g
s
.552 .336 .54 r
.31718 .47432 m .29085 .85101 L .32357 .8418 L p F P
0 g
s
.938 .685 .528 r
.27912 .43541 m .31718 .47432 L .29085 .85101 L p F P
0 g
s
.942 .686 .521 r
.36542 .8585 m .32459 .82486 L .34637 .46395 L p F P
0 g
s
.672 .728 .891 r
.27912 .43541 m .30873 .42458 L .34637 .46395 L p F P
0 g
s
.942 .686 .521 r
.30873 .42458 m .34637 .46395 L .32357 .8418 L p F P
0 g
s
.56 .347 .549 r
.53199 .77901 m .53142 .4502 L .50093 .46073 L p F P
0 g
s
.956 .688 .486 r
.53457 .82279 m .49813 .78857 L .50093 .46073 L p F P
0 g
s
.56 .347 .549 r
.50093 .46073 m .49813 .78857 L .53199 .77901 L p F P
0 g
s
.672 .728 .891 r
.53142 .4502 m .50093 .46073 L .46663 .42122 L p F P
0 g
s
.647 .762 .933 r
.56787 .81368 m .53457 .82279 L .49813 .78857 L p F P
0 g
s
.647 .762 .933 r
.49813 .78857 m .53199 .77901 L .56787 .81368 L p F P
0 g
s
.56 .347 .549 r
.53217 .88173 m .53142 .4502 L .50093 .46073 L p F P
0 g
s
.56 .347 .549 r
.50093 .46073 m .49726 .89089 L .53217 .88173 L p F P
0 g
s
.956 .688 .486 r
.46663 .42122 m .50093 .46073 L .49726 .89089 L p F P
0 g
s
.96 .688 .475 r
.56787 .81368 m .53199 .77901 L .53142 .4502 L p F P
0 g
s
.672 .728 .891 r
.46663 .42122 m .4976 .41021 L .53142 .4502 L p F P
0 g
s
.96 .688 .475 r
.4976 .41021 m .53142 .4502 L .53217 .88173 L p F P
0 g
s
.567 .357 .556 r
.74884 .8874 m .71935 .43624 L .68751 .44694 L p F P
0 g
s
.972 .685 .424 r
.74478 .92975 m .71196 .89665 L .68751 .44694 L p F P
0 g
s
.567 .357 .556 r
.68751 .44694 m .71196 .89665 L .74884 .8874 L p F P
0 g
s
.672 .728 .891 r
.71935 .43624 m .68751 .44694 L .6571 .4068 L p F P
0 g
s
.567 .357 .556 r
.74202 .7831 m .71935 .43624 L .68751 .44694 L p F P
0 g
s
.567 .357 .556 r
.68751 .44694 m .70631 .79275 L .74202 .7831 L p F P
0 g
s
.972 .685 .424 r
.6571 .4068 m .68751 .44694 L .70631 .79275 L p F P
0 g
s
.974 .683 .409 r
.78097 .92094 m .74884 .8874 L .71935 .43624 L p F P
0 g
s
.672 .728 .891 r
.6571 .4068 m .68947 .39562 L .71935 .43624 L p F P
0 g
s
.974 .683 .409 r
.68947 .39562 m .71935 .43624 L .74202 .7831 L p F P
0 g
s
.938 .685 .528 r
.29085 .85101 m .24722 .81641 L .27912 .43541 L p F P
0 g
s
.544 .324 .532 r
.28046 .80674 m .30873 .42458 L .27912 .43541 L p F P
0 g
s
.544 .324 .532 r
.27912 .43541 m .24722 .81641 L .28046 .80674 L p F P
0 g
s
.672 .728 .891 r
.30873 .42458 m .27912 .43541 L .23935 .39475 L p F P
0 g
s
.544 .324 .532 r
.28173 .78956 m .30873 .42458 L .27912 .43541 L p F P
0 g
s
.544 .324 .532 r
.27912 .43541 m .24866 .79929 L .28173 .78956 L p F P
0 g
s
.938 .685 .528 r
.23935 .39475 m .27912 .43541 L .24866 .79929 L p F P
0 g
s
.672 .728 .891 r
.91022 .42206 m .87699 .43292 L .8506 .39215 L p F P
0 g
s
.573 .367 .563 r
.9557 .77027 m .91022 .42206 L .87699 .43292 L p F P
0 g
s
.573 .367 .563 r
.87699 .43292 m .91826 .7801 L .9557 .77027 L p F P
0 g
s
.975 .669 .333 r
.8506 .39215 m .87699 .43292 L .91826 .7801 L p F P
0 g
s
.942 .686 .521 r
.32357 .8418 m .28046 .80674 L .30873 .42458 L p F P
0 g
s
.672 .728 .891 r
.23935 .39475 m .26938 .38342 L .30873 .42458 L p F P
0 g
s
.942 .686 .521 r
.26938 .38342 m .30873 .42458 L .28173 .78956 L p F P
0 g
s
.672 .728 .891 r
.8506 .39215 m .88441 .38079 L .91022 .42206 L p F P
0 g
s
.973 .663 .31 r
.88441 .38079 m .91022 .42206 L .9557 .77027 L p F P
0 g
s
.956 .688 .486 r
.49726 .89089 m .45779 .85644 L .46663 .42122 L p F P
0 g
s
.552 .336 .54 r
.49331 .84681 m .4976 .41021 L .46663 .42122 L p F P
0 g
s
.552 .336 .54 r
.46663 .42122 m .45779 .85644 L .49331 .84681 L p F P
0 g
s
.672 .728 .891 r
.4976 .41021 m .46663 .42122 L .43078 .37991 L p F P
0 g
s
.552 .336 .54 r
.4945 .72589 m .4976 .41021 L .46663 .42122 L p F P
0 g
s
.552 .336 .54 r
.46663 .42122 m .46023 .73598 L .4945 .72589 L p F P
0 g
s
.956 .688 .486 r
.43078 .37991 m .46663 .42122 L .46023 .73598 L p F P
0 g
s
.96 .688 .475 r
.53217 .88173 m .49331 .84681 L .4976 .41021 L p F P
0 g
s
.672 .728 .891 r
.43078 .37991 m .46223 .3684 L .4976 .41021 L p F P
0 g
s
.96 .688 .475 r
.46223 .3684 m .4976 .41021 L .4945 .72589 L p F P
0 g
s
.56 .347 .549 r
.70911 .7463 m .68947 .39562 L .6571 .4068 L p F P
0 g
s
.972 .685 .424 r
.70631 .79275 m .67273 .75645 L .6571 .4068 L p F P
0 g
s
.56 .347 .549 r
.6571 .4068 m .67273 .75645 L .70911 .7463 L p F P
0 g
s
.672 .728 .891 r
.68947 .39562 m .6571 .4068 L .6253 .36483 L p F P
0 g
s
.645 .763 .935 r
.74202 .7831 m .70631 .79275 L .67273 .75645 L p F P
0 g
s
.645 .763 .935 r
.67273 .75645 m .70911 .7463 L .74202 .7831 L p F P
0 g
s
.56 .347 .549 r
.71203 .79836 m .68947 .39562 L .6571 .4068 L p F P
0 g
s
.56 .347 .549 r
.6571 .4068 m .67505 .80831 L .71203 .79836 L p F P
0 g
s
.972 .685 .424 r
.6253 .36483 m .6571 .4068 L .67505 .80831 L p F P
0 g
s
.645 .763 .935 r
.44195 .90511 m .41101 .91323 L .37354 .88275 L p F P
0 g
s
.974 .683 .409 r
.74202 .7831 m .70911 .7463 L .68947 .39562 L p F P
0 g
s
.672 .728 .891 r
.6253 .36483 m .65822 .35313 L .68947 .39562 L p F P
0 g
s
.974 .683 .409 r
.65822 .35313 m .68947 .39562 L .71203 .79836 L p F P
0 g
s
.938 .685 .528 r
.24866 .79929 m .20309 .76269 L .23935 .39475 L p F P
0 g
s
.535 .311 .522 r
.23669 .75246 m .26938 .38342 L .23935 .39475 L p F P
0 g
s
.535 .311 .522 r
.23935 .39475 m .20309 .76269 L .23669 .75246 L p F P
0 g
s
.672 .728 .891 r
.26938 .38342 m .23935 .39475 L .19775 .35223 L p F P
0 g
s
.643 .765 .937 r
.20309 .76269 m .23669 .75246 L .28173 .78956 L p F P
0 g
s
.535 .311 .522 r
.23515 .76988 m .26938 .38342 L .23935 .39475 L p F P
0 g
s
.643 .765 .937 r
.28173 .78956 m .24866 .79929 L .20309 .76269 L p F P
0 g
s
.535 .311 .522 r
.23935 .39475 m .20138 .78005 L .23515 .76988 L p F P
0 g
s
.938 .685 .528 r
.19775 .35223 m .23935 .39475 L .20138 .78005 L p F P
0 g
s
.645 .763 .935 r
.37354 .88275 m .40495 .87426 L .44195 .90511 L p F P
0 g
s
.567 .357 .556 r
.92791 .73282 m .88441 .38079 L .8506 .39215 L p F P
0 g
s
.975 .669 .333 r
.91826 .7801 m .88972 .74315 L .8506 .39215 L p F P
0 g
s
.567 .357 .556 r
.8506 .39215 m .88972 .74315 L .92791 .73282 L p F P
0 g
s
.672 .728 .891 r
.88441 .38079 m .8506 .39215 L .82299 .34951 L p F P
0 g
s
.645 .763 .935 r
.9557 .77027 m .91826 .7801 L .88972 .74315 L p F P
0 g
s
.645 .763 .935 r
.88972 .74315 m .92791 .73282 L .9557 .77027 L p F P
0 g
s
.567 .357 .556 r
.93437 .78514 m .88441 .38079 L .8506 .39215 L p F P
0 g
s
.567 .357 .556 r
.8506 .39215 m .89553 .79527 L .93437 .78514 L p F P
0 g
s
.975 .669 .333 r
.82299 .34951 m .8506 .39215 L .89553 .79527 L p F P
0 g
s
.942 .686 .521 r
.28173 .78956 m .23669 .75246 L .26938 .38342 L p F P
0 g
s
.672 .728 .891 r
.19775 .35223 m .22822 .34037 L .26938 .38342 L p F P
0 g
s
.942 .686 .521 r
.22822 .34037 m .26938 .38342 L .23515 .76988 L p F P
0 g
s
.973 .663 .31 r
.9557 .77027 m .92791 .73282 L .88441 .38079 L p F P
0 g
s
.672 .728 .891 r
.82299 .34951 m .85741 .33762 L .88441 .38079 L p F P
0 g
s
.973 .663 .31 r
.85741 .33762 m .88441 .38079 L .93437 .78514 L p F P
0 g
s
.956 .688 .486 r
.46023 .73598 m .42029 .69804 L .43078 .37991 L p F P
0 g
s
.544 .324 .532 r
.45515 .68743 m .46223 .3684 L .43078 .37991 L p F P
0 g
s
.544 .324 .532 r
.43078 .37991 m .42029 .69804 L .45515 .68743 L p F P
0 g
s
.672 .728 .891 r
.46223 .3684 m .43078 .37991 L .39327 .3367 L p F P
0 g
s
.648 .76 .931 r
.4945 .72589 m .46023 .73598 L .42029 .69804 L p F P
0 g
s
.648 .76 .931 r
.42029 .69804 m .45515 .68743 L .4945 .72589 L p F P
0 g
s
.544 .324 .532 r
.45322 .77407 m .46223 .3684 L .43078 .37991 L p F P
0 g
s
.544 .324 .532 r
.43078 .37991 m .41744 .78436 L .45322 .77407 L p F P
0 g
s
.956 .688 .486 r
.39327 .3367 m .43078 .37991 L .41744 .78436 L p F P
0 g
s
.96 .688 .475 r
.4945 .72589 m .45515 .68743 L .46223 .3684 L p F P
0 g
s
.672 .728 .891 r
.39327 .3367 m .42522 .32464 L .46223 .3684 L p F P
0 g
s
.96 .688 .475 r
.42522 .32464 m .46223 .3684 L .45322 .77407 L p F P
0 g
s
.552 .336 .54 r
.67693 .7604 m .65822 .35313 L .6253 .36483 L p F P
0 g
s
.972 .685 .424 r
.67505 .80831 m .63924 .77088 L .6253 .36483 L p F P
0 g
s
.552 .336 .54 r
.6253 .36483 m .63924 .77088 L .67693 .7604 L p F P
0 g
s
.672 .728 .891 r
.65822 .35313 m .6253 .36483 L .59202 .32091 L p F P
0 g
s
.552 .336 .54 r
.67216 .65648 m .65822 .35313 L .6253 .36483 L p F P
0 g
s
.552 .336 .54 r
.6253 .36483 m .63569 .66734 L .67216 .65648 L p F P
0 g
s
.972 .685 .424 r
.59202 .32091 m .6253 .36483 L .63569 .66734 L p F P
0 g
s
.974 .683 .409 r
.71203 .79836 m .67693 .7604 L .65822 .35313 L p F P
0 g
s
.672 .728 .891 r
.59202 .32091 m .6255 .30866 L .65822 .35313 L p F P
0 g
s
.974 .683 .409 r
.6255 .30866 m .65822 .35313 L .67216 .65648 L p F P
0 g
s
.938 .685 .528 r
.20138 .78005 m .15315 .74179 L .19775 .35223 L p F P
0 g
s
.524 .296 .511 r
.18746 .73109 m .22822 .34037 L .19775 .35223 L p F P
0 g
s
.524 .296 .511 r
.19775 .35223 m .15315 .74179 L .18746 .73109 L p F P
0 g
s
.672 .728 .891 r
.22822 .34037 m .19775 .35223 L .1542 .30771 L p F P
0 g
s
.641 .767 .94 r
.23515 .76988 m .20138 .78005 L .15315 .74179 L p F P
0 g
s
.641 .767 .94 r
.15315 .74179 m .18746 .73109 L .23515 .76988 L p F P
0 g
s
.524 .296 .511 r
.18371 .76701 m .22822 .34037 L .19775 .35223 L p F P
0 g
s
.524 .296 .511 r
.19775 .35223 m .14905 .77758 L .18371 .76701 L p F P
0 g
s
.938 .685 .528 r
.1542 .30771 m .19775 .35223 L .14905 .77758 L p F P
0 g
s
.56 .347 .549 r
.90483 .74647 m .85741 .33762 L .82299 .34951 L p F P
0 g
s
.975 .669 .333 r
.89553 .79527 m .86517 .75715 L .82299 .34951 L p F P
0 g
s
.56 .347 .549 r
.82299 .34951 m .86517 .75715 L .90483 .74647 L p F P
0 g
s
.672 .728 .891 r
.85741 .33762 m .82299 .34951 L .79408 .30485 L p F P
0 g
s
.56 .347 .549 r
.89468 .659 m .85741 .33762 L .82299 .34951 L p F P
0 g
s
.56 .347 .549 r
.82299 .34951 m .85615 .66999 L .89468 .659 L p F P
0 g
s
.975 .669 .333 r
.79408 .30485 m .82299 .34951 L .85615 .66999 L p F P
0 g
s
.942 .686 .521 r
.23515 .76988 m .18746 .73109 L .22822 .34037 L p F P
0 g
s
.672 .728 .891 r
.1542 .30771 m .18511 .29529 L .22822 .34037 L p F P
0 g
s
.942 .686 .521 r
.18511 .29529 m .22822 .34037 L .18371 .76701 L p F P
0 g
s
.973 .663 .31 r
.93437 .78514 m .90483 .74647 L .85741 .33762 L p F P
0 g
s
.672 .728 .891 r
.79408 .30485 m .82914 .2924 L .85741 .33762 L p F P
0 g
s
.973 .663 .31 r
.82914 .2924 m .85741 .33762 L .89468 .659 L p F P
0 g
s
.643 .765 .937 r
.60282 .87938 m .56976 .88796 L .53465 .85575 L p F P
0 g
s
.956 .688 .486 r
.41744 .78436 m .37421 .74565 L .39327 .3367 L p F P
0 g
s
.535 .311 .522 r
.41063 .73481 m .42522 .32464 L .39327 .3367 L p F P
0 g
s
.535 .311 .522 r
.39327 .3367 m .37421 .74565 L .41063 .73481 L p F P
0 g
s
.672 .728 .891 r
.42522 .32464 m .39327 .3367 L .35398 .29143 L p F P
0 g
s
.535 .311 .522 r
.4119 .6991 m .42522 .32464 L .39327 .3367 L p F P
0 g
s
.535 .311 .522 r
.39327 .3367 m .37586 .71007 L .4119 .6991 L p F P
0 g
s
.956 .688 .486 r
.35398 .29143 m .39327 .3367 L .37586 .71007 L p F P
0 g
s
.643 .765 .937 r
.53465 .85575 m .56828 .84677 L .60282 .87938 L p F P
0 g
s
.96 .688 .475 r
.45322 .77407 m .41063 .73481 L .42522 .32464 L p F P
0 g
s
.672 .728 .891 r
.35398 .29143 m .38644 .2788 L .42522 .32464 L p F P
0 g
s
.96 .688 .475 r
.38644 .2788 m .42522 .32464 L .4119 .6991 L p F P
0 g
s
.544 .324 .532 r
.63625 .61508 m .6255 .30866 L .59202 .32091 L p F P
0 g
s
.972 .685 .424 r
.63569 .66734 m .59909 .6265 L .59202 .32091 L p F P
0 g
s
.544 .324 .532 r
.59202 .32091 m .59909 .6265 L .63625 .61508 L p F P
0 g
s
.672 .728 .891 r
.6255 .30866 m .59202 .32091 L .55715 .27488 L p F P
0 g
s
.65 .758 .929 r
.67216 .65648 m .63569 .66734 L .59909 .6265 L p F P
0 g
s
.65 .758 .929 r
.59909 .6265 m .63625 .61508 L .67216 .65648 L p F P
0 g
s
.544 .324 .532 r
.63869 .68451 m .6255 .30866 L .59202 .32091 L p F P
0 g
s
.544 .324 .532 r
.59202 .32091 m .6007 .69569 L .63869 .68451 L p F P
0 g
s
.972 .685 .424 r
.55715 .27488 m .59202 .32091 L .6007 .69569 L p F P
0 g
s
.974 .683 .409 r
.67216 .65648 m .63625 .61508 L .6255 .30866 L p F P
0 g
s
.672 .728 .891 r
.55715 .27488 m .59121 .26204 L .6255 .30866 L p F P
0 g
s
.974 .683 .409 r
.59121 .26204 m .6255 .30866 L .63869 .68451 L p F P
0 g
s
.938 .685 .528 r
.14905 .77758 m .09755 .73779 L .1542 .30771 L p F P
0 g
s
.513 .28 .498 r
.13278 .72664 m .18511 .29529 L .1542 .30771 L p F P
0 g
s
.513 .28 .498 r
.1542 .30771 m .09755 .73779 L .13278 .72664 L p F P
0 g
s
.672 .728 .891 r
.18511 .29529 m .1542 .30771 L .10855 .26104 L p F P
0 g
s
.637 .771 .944 r
.18371 .76701 m .14905 .77758 L .09755 .73779 L p F P
0 g
s
.637 .771 .944 r
.09755 .73779 m .13278 .72664 L .18371 .76701 L p F P
0 g
s
.513 .28 .498 r
.12826 .76392 m .18511 .29529 L .1542 .30771 L p F P
0 g
s
.513 .28 .498 r
.1542 .30771 m .09266 .77492 L .12826 .76392 L p F P
0 g
s
.938 .685 .528 r
.10855 .26104 m .1542 .30771 L .09266 .77492 L p F P
0 g
s
.552 .336 .54 r
.86412 .61704 m .82914 .2924 L .79408 .30485 L p F P
0 g
s
.975 .669 .333 r
.85615 .66999 m .8248 .62862 L .79408 .30485 L p F P
0 g
s
.552 .336 .54 r
.79408 .30485 m .8248 .62862 L .86412 .61704 L p F P
0 g
s
.672 .728 .891 r
.82914 .2924 m .79408 .30485 L .76378 .25805 L p F P
0 g
s
.648 .76 .931 r
.89468 .659 m .85615 .66999 L .8248 .62862 L p F P
0 g
s
.639 .769 .942 r
.93437 .78514 m .89553 .79527 L .86517 .75715 L p F P
0 g
s
.648 .76 .931 r
.8248 .62862 m .86412 .61704 L .89468 .659 L p F P
0 g
s
.639 .769 .942 r
.86517 .75715 m .90483 .74647 L .93437 .78514 L p F P
0 g
s
.552 .336 .54 r
.88172 .78033 m .82914 .2924 L .79408 .30485 L p F P
0 g
s
.552 .336 .54 r
.79408 .30485 m .84023 .79129 L .88172 .78033 L p F P
0 g
s
.975 .669 .333 r
.76378 .25805 m .79408 .30485 L .84023 .79129 L p F P
0 g
s
.942 .686 .521 r
.18371 .76701 m .13278 .72664 L .18511 .29529 L p F P
0 g
s
.672 .728 .891 r
.10855 .26104 m .13991 .24802 L .18511 .29529 L p F P
0 g
s
.942 .686 .521 r
.13991 .24802 m .18511 .29529 L .12826 .76392 L p F P
0 g
s
.973 .663 .31 r
.89468 .659 m .86412 .61704 L .82914 .2924 L p F P
0 g
s
.672 .728 .891 r
.76378 .25805 m .79949 .24499 L .82914 .2924 L p F P
0 g
s
.973 .663 .31 r
.79949 .24499 m .82914 .2924 L .88172 .78033 L p F P
0 g
s
.956 .688 .486 r
.37586 .71007 m .33083 .66876 L .35398 .29143 L p F P
0 g
s
.524 .296 .511 r
.36751 .65719 m .38644 .2788 L .35398 .29143 L p F P
0 g
s
.524 .296 .511 r
.35398 .29143 m .33083 .66876 L .36751 .65719 L p F P
0 g
s
.672 .728 .891 r
.38644 .2788 m .35398 .29143 L .31279 .24397 L p F P
0 g
s
.524 .296 .511 r
.36751 .65719 m .38644 .2788 L .35398 .29143 L p F P
0 g
s
.524 .296 .511 r
.35398 .29143 m .33083 .66876 L .36751 .65719 L p F P
0 g
s
.956 .688 .486 r
.31279 .24397 m .35398 .29143 L .33083 .66876 L p F P
0 g
s
.96 .688 .475 r
.4119 .6991 m .36751 .65719 L .38644 .2788 L p F P
0 g
s
.672 .728 .891 r
.31279 .24397 m .34577 .23072 L .38644 .2788 L p F P
0 g
s
.96 .688 .475 r
.34577 .23072 m .38644 .2788 L .36751 .65719 L p F P
0 g
s
.535 .311 .522 r
.60007 .6418 m .59121 .26204 L .55715 .27488 L p F P
0 g
s
.972 .685 .424 r
.6007 .69569 m .56133 .65359 L .55715 .27488 L p F P
0 g
s
.535 .311 .522 r
.55715 .27488 m .56133 .65359 L .60007 .6418 L p F P
0 g
s
.672 .728 .891 r
.59121 .26204 m .55715 .27488 L .52057 .22661 L p F P
0 g
s
.535 .311 .522 r
.59843 .57146 m .59121 .26204 L .55715 .27488 L p F P
0 g
s
.535 .311 .522 r
.55715 .27488 m .56056 .5835 L .59843 .57146 L p F P
0 g
s
.972 .685 .424 r
.52057 .22661 m .55715 .27488 L .56056 .5835 L p F P
0 g
s
.974 .683 .409 r
.63869 .68451 m .60007 .6418 L .59121 .26204 L p F P
0 g
s
.672 .728 .891 r
.52057 .22661 m .55522 .21312 L .59121 .26204 L p F P
0 g
s
.974 .683 .409 r
.55522 .21312 m .59121 .26204 L .59843 .57146 L p F P
0 g
s
.938 .685 .528 r
.09266 .77492 m .03752 .73347 L .10855 .26104 L p F P
0 g
s
.5 .261 .485 r
.07371 .72184 m .13991 .24802 L .10855 .26104 L p F P
0 g
s
.5 .261 .485 r
.10855 .26104 m .03752 .73347 L .07371 .72184 L p F P
0 g
s
.544 .324 .532 r
.84828 .7384 m .79949 .24499 L .76378 .25805 L p F P
0 g
s
.975 .669 .333 r
.84023 .79129 m .80587 .74999 L .76378 .25805 L p F P
0 g
s
.544 .324 .532 r
.76378 .25805 m .80587 .74999 L .84828 .7384 L p F P
0 g
s
.672 .728 .891 r
.79949 .24499 m .76378 .25805 L .73198 .20894 L p F P
0 g
s
.544 .324 .532 r
.8319 .57281 m .79949 .24499 L .76378 .25805 L p F P
0 g
s
.544 .324 .532 r
.76378 .25805 m .79176 .58502 L .8319 .57281 L p F P
0 g
s
.975 .669 .333 r
.73198 .20894 m .76378 .25805 L .79176 .58502 L p F P
0 g
s
.641 .767 .94 r
.32357 .8418 m .29085 .85101 L .24722 .81641 L p F P
0 g
s
.942 .686 .521 r
.12826 .76392 m .07371 .72184 L .13991 .24802 L p F P
0 g
s
.973 .663 .31 r
.88172 .78033 m .84828 .7384 L .79949 .24499 L p F P
0 g
s
.672 .728 .891 r
.73198 .20894 m .76836 .19522 L .79949 .24499 L p F P
0 g
s
.973 .663 .31 r
.76836 .19522 m .79949 .24499 L .8319 .57281 L p F P
0 g
s
.956 .688 .486 r
.33083 .66876 m .28332 .62517 L .31279 .24397 L p F P
0 g
s
.513 .28 .498 r
.32066 .61295 m .34577 .23072 L .31279 .24397 L p F P
0 g
s
.513 .28 .498 r
.31279 .24397 m .28332 .62517 L .32066 .61295 L p F P
0 g
s
.672 .728 .891 r
.34577 .23072 m .31279 .24397 L .26955 .19415 L p F P
0 g
s
.643 .765 .937 r
.36751 .65719 m .33083 .66876 L .28332 .62517 L p F P
0 g
s
.643 .765 .937 r
.28332 .62517 m .32066 .61295 L .36751 .65719 L p F P
0 g
s
.513 .28 .498 r
.31066 .76513 m .34577 .23072 L .31279 .24397 L p F P
0 g
s
.513 .28 .498 r
.31279 .24397 m .2716 .77675 L .31066 .76513 L p F P
0 g
s
.956 .688 .486 r
.26955 .19415 m .31279 .24397 L .2716 .77675 L p F P
0 g
s
.641 .767 .94 r
.24722 .81641 m .28046 .80674 L .32357 .8418 L p F P
0 g
s
.96 .688 .475 r
.36751 .65719 m .32066 .61295 L .34577 .23072 L p F P
0 g
s
.672 .728 .891 r
.26955 .19415 m .30306 .18023 L .34577 .23072 L p F P
0 g
s
.96 .688 .475 r
.30306 .18023 m .34577 .23072 L .31066 .76513 L p F P
0 g
s
.524 .296 .511 r
.55853 .52544 m .55522 .21312 L .52057 .22661 L p F P
0 g
s
.972 .685 .424 r
.56056 .5835 m .51992 .53815 L .52057 .22661 L p F P
0 g
s
.524 .296 .511 r
.52057 .22661 m .51992 .53815 L .55853 .52544 L p F P
0 g
s
.672 .728 .891 r
.55522 .21312 m .52057 .22661 L .48216 .17591 L p F P
0 g
s
.65 .758 .929 r
.59843 .57146 m .56056 .5835 L .51992 .53815 L p F P
0 g
s
.65 .758 .929 r
.51992 .53815 m .55853 .52544 L .59843 .57146 L p F P
0 g
s
.524 .296 .511 r
.5589 .56065 m .55522 .21312 L .52057 .22661 L p F P
0 g
s
.524 .296 .511 r
.52057 .22661 m .51985 .57324 L .5589 .56065 L p F P
0 g
s
.972 .685 .424 r
.48216 .17591 m .52057 .22661 L .51985 .57324 L p F P
0 g
s
.632 .775 .949 r
.78097 .92094 m .74478 .92975 L .71196 .89665 L p F P
0 g
s
.974 .683 .409 r
.59843 .57146 m .55853 .52544 L .55522 .21312 L p F P
0 g
s
.672 .728 .891 r
.48216 .17591 m .51742 .16174 L .55522 .21312 L p F P
0 g
s
.974 .683 .409 r
.51742 .16174 m .55522 .21312 L .5589 .56065 L p F P
0 g
s
.632 .775 .949 r
.71196 .89665 m .74884 .8874 L .78097 .92094 L p F P
0 g
s
.535 .311 .522 r
.79789 .52611 m .76836 .19522 L .73198 .20894 L p F P
0 g
s
.975 .669 .333 r
.79176 .58502 m .75688 .53901 L .73198 .20894 L p F P
0 g
s
.535 .311 .522 r
.73198 .20894 m .75688 .53901 L .79789 .52611 L p F P
0 g
s
.672 .728 .891 r
.76836 .19522 m .73198 .20894 L .69858 .15734 L p F P
0 g
s
.648 .76 .931 r
.8319 .57281 m .79176 .58502 L .75688 .53901 L p F P
0 g
s
.648 .76 .931 r
.75688 .53901 m .79789 .52611 L .8319 .57281 L p F P
0 g
s
.535 .311 .522 r
.80601 .61715 m .76836 .19522 L .73198 .20894 L p F P
0 g
s
.535 .311 .522 r
.73198 .20894 m .76373 .62973 L .80601 .61715 L p F P
0 g
s
.975 .669 .333 r
.69858 .15734 m .73198 .20894 L .76373 .62973 L p F P
0 g
s
.635 .773 .946 r
.53217 .88173 m .49726 .89089 L .45779 .85644 L p F P
0 g
s
.973 .663 .31 r
.8319 .57281 m .79789 .52611 L .76836 .19522 L p F P
0 g
s
.672 .728 .891 r
.69858 .15734 m .73565 .14291 L .76836 .19522 L p F P
0 g
s
.973 .663 .31 r
.73565 .14291 m .76836 .19522 L .80601 .61715 L p F P
0 g
s
.956 .688 .486 r
.2716 .77675 m .21854 .73291 L .26955 .19415 L p F P
0 g
s
.5 .261 .485 r
.25835 .72058 m .30306 .18023 L .26955 .19415 L p F P
0 g
s
.5 .261 .485 r
.26955 .19415 m .21854 .73291 L .25835 .72058 L p F P
0 g
s
.635 .773 .946 r
.45779 .85644 m .49331 .84681 L .53217 .88173 L p F P
0 g
s
.96 .688 .475 r
.31066 .76513 m .25835 .72058 L .30306 .18023 L p F P
0 g
s
.513 .28 .498 r
.51626 .51246 m .51742 .16174 L .48216 .17591 L p F P
0 g
s
.972 .685 .424 r
.51985 .57324 m .47643 .52578 L .48216 .17591 L p F P
0 g
s
.513 .28 .498 r
.48216 .17591 m .47643 .52578 L .51626 .51246 L p F P
0 g
s
.672 .728 .891 r
.51742 .16174 m .48216 .17591 L .44177 .1226 L p F P
0 g
s
.647 .762 .933 r
.5589 .56065 m .51985 .57324 L .47643 .52578 L p F P
0 g
s
.647 .762 .933 r
.47643 .52578 m .51626 .51246 L .5589 .56065 L p F P
0 g
s
.513 .28 .498 r
.51602 .58634 m .51742 .16174 L .48216 .17591 L p F P
0 g
s
.513 .28 .498 r
.48216 .17591 m .47522 .5994 L .51602 .58634 L p F P
0 g
s
.972 .685 .424 r
.44177 .1226 m .48216 .17591 L .47522 .5994 L p F P
0 g
s
.974 .683 .409 r
.5589 .56065 m .51626 .51246 L .51742 .16174 L p F P
0 g
s
.672 .728 .891 r
.44177 .1226 m .47767 .10769 L .51742 .16174 L p F P
0 g
s
.974 .683 .409 r
.47767 .10769 m .51742 .16174 L .51602 .58634 L p F P
0 g
s
.524 .296 .511 r
.76918 .56894 m .73565 .14291 L .69858 .15734 L p F P
0 g
s
.975 .669 .333 r
.76373 .62973 m .72595 .58228 L .69858 .15734 L p F P
0 g
s
.524 .296 .511 r
.69858 .15734 m .72595 .58228 L .76918 .56894 L p F P
0 g
s
.672 .728 .891 r
.73565 .14291 m .69858 .15734 L .66344 .10306 L p F P
0 g
s
.639 .769 .942 r
.80601 .61715 m .76373 .62973 L .72595 .58228 L p F P
0 g
s
.639 .769 .942 r
.72595 .58228 m .76918 .56894 L .80601 .61715 L p F P
0 g
s
.524 .296 .511 r
.77689 .66701 m .73565 .14291 L .69858 .15734 L p F P
0 g
s
.524 .296 .511 r
.69858 .15734 m .73224 .67996 L .77689 .66701 L p F P
0 g
s
.975 .669 .333 r
.66344 .10306 m .69858 .15734 L .73224 .67996 L p F P
0 g
s
.639 .769 .942 r
.71203 .79836 m .67505 .80831 L .63924 .77088 L p F P
0 g
s
.973 .663 .31 r
.80601 .61715 m .76918 .56894 L .73565 .14291 L p F P
0 g
s
.672 .728 .891 r
.66344 .10306 m .70123 .08787 L .73565 .14291 L p F P
0 g
s
.973 .663 .31 r
.70123 .08787 m .73565 .14291 L .77689 .66701 L p F P
0 g
s
.639 .769 .942 r
.63924 .77088 m .67693 .7604 L .71203 .79836 L p F P
0 g
s
.972 .685 .424 r
.47522 .5994 m .42808 .55012 L .44177 .1226 L p F P
0 g
s
.5 .261 .485 r
.46972 .53626 m .47767 .10769 L .44177 .1226 L p F P
0 g
s
.5 .261 .485 r
.44177 .1226 m .42808 .55012 L .46972 .53626 L p F P
0 g
s
.639 .769 .942 r
.45322 .77407 m .41744 .78436 L .37421 .74565 L p F P
0 g
s
.974 .683 .409 r
.51602 .58634 m .46972 .53626 L .47767 .10769 L p F P
0 g
s
.639 .769 .942 r
.37421 .74565 m .41063 .73481 L .45322 .77407 L p F P
0 g
s
.513 .28 .498 r
.73678 .61727 m .70123 .08787 L .66344 .10306 L p F P
0 g
s
.975 .669 .333 r
.73224 .67996 m .69107 .63105 L .66344 .10306 L p F P
0 g
s
.513 .28 .498 r
.66344 .10306 m .69107 .63105 L .73678 .61727 L p F P
0 g
s
.672 .728 .891 r
.70123 .08787 m .66344 .10306 L .62642 .04589 L p F P
0 g
s
.513 .28 .498 r
.72505 .44265 m .70123 .08787 L .66344 .10306 L p F P
0 g
s
.513 .28 .498 r
.66344 .10306 m .68196 .45706 L .72505 .44265 L p F P
0 g
s
.975 .669 .333 r
.62642 .04589 m .66344 .10306 L .68196 .45706 L p F P
0 g
s
.973 .663 .31 r
.77689 .66701 m .73678 .61727 L .70123 .08787 L p F P
0 g
s
.672 .728 .891 r
.62642 .04589 m .66497 .02988 L .70123 .08787 L p F P
0 g
s
.973 .663 .31 r
.66497 .02988 m .70123 .08787 L .72505 .44265 L p F P
0 g
s
.643 .765 .937 r
.4119 .6991 m .37586 .71007 L .33083 .66876 L p F P
0 g
s
.643 .765 .937 r
.33083 .66876 m .36751 .65719 L .4119 .6991 L p F P
0 g
s
.643 .765 .937 r
.63869 .68451 m .6007 .69569 L .56133 .65359 L p F P
0 g
s
.643 .765 .937 r
.56133 .65359 m .60007 .6418 L .63869 .68451 L p F P
0 g
s
.5 .261 .485 r
.68443 .38738 m .66497 .02988 L .62642 .04589 L p F P
0 g
s
.975 .669 .333 r
.68196 .45706 m .64036 .40268 L .62642 .04589 L p F P
0 g
s
.5 .261 .485 r
.62642 .04589 m .64036 .40268 L .68443 .38738 L p F P
0 g
s
.973 .663 .31 r
.72505 .44265 m .68443 .38738 L .66497 .02988 L p F P
0 g
s
.632 .775 .949 r
.12826 .76392 m .09266 .77492 L .03752 .73347 L p F P
0 g
s
.632 .775 .949 r
.03752 .73347 m .07371 .72184 L .12826 .76392 L p F P
0 g
s
.63 .777 .951 r
.88172 .78033 m .84023 .79129 L .80587 .74999 L p F P
0 g
s
.63 .777 .951 r
.80587 .74999 m .84828 .7384 L .88172 .78033 L p F P
0 g
s
.625 .78 .956 r
.31066 .76513 m .2716 .77675 L .21854 .73291 L p F P
0 g
s
.639 .769 .942 r
.51602 .58634 m .47522 .5994 L .42808 .55012 L p F P
0 g
s
.625 .78 .956 r
.21854 .73291 m .25835 .72058 L .31066 .76513 L p F P
0 g
s
.639 .769 .942 r
.42808 .55012 m .46972 .53626 L .51602 .58634 L p F P
0 g
s
.647 .762 .933 r
.72505 .44265 m .68196 .45706 L .64036 .40268 L p F P
0 g
s
.647 .762 .933 r
.64036 .40268 m .68443 .38738 L .72505 .44265 L p F P
0 g
s
.628 .778 .953 r
.77689 .66701 m .73224 .67996 L .69107 .63105 L p F P
0 g
s
.628 .778 .953 r
.69107 .63105 m .73678 .61727 L .77689 .66701 L p F P
0 g
s
.25 Mabswid
.67245 0 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.67245 0 m
.08846 .24555 L
s
.08846 .24555 m
.67245 0 L
s
.11649 .23377 m
.12154 .23902 L
s
[(1000)] .10639 .22326 .961 1 Mshowa
.27843 .16567 m
.28316 .17122 L
s
[(100000)] .26898 .15458 .85179 1 Mshowa
.45171 .09281 m
.45606 .09867 L
s
[(10000000)] .44302 .08111 .74258 1 Mshowa
.63756 .01467 m
.64146 .02083 L
s
[(1000000000)] .62976 .00236 .63337 1 Mshowa
0 .80374 m
.40037 1.0855 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.0.5"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics3D", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.0.5"]
}, Open  ]],

Cell[TextData[{
 "Here scattering cross section (",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Mu]", "b"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ") is plotted versus the incident momentum of a particle beam (GeV/c), \
measured in a laboratory frame of reference. The estimated standard deviation \
of the cross section at each value of the incident momentum is indicated \
using error bars. "
}], "MathCaption",
 CellTags->{"S5.0.5", "5.6"}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MultipleListPlot", "[", 
  RowBox[{
   RowBox[{"Apply", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"#1", ",", "#2"}], "}"}], ",", 
        RowBox[{"ErrorBar", "[", "#3", "]"}]}], "}"}], "&"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"4", ",", "367", ",", "17"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", "311", ",", "9"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8", ",", "295", ",", "9"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", "268", ",", "7"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12", ",", "253", ",", "7"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"15", ",", "239", ",", "6"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"20", ",", "220", ",", "6"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"30", ",", "213", ",", "6"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"75", ",", "193", ",", "5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"150", ",", "192", ",", "5"}], "}"}]}], "}"}], ",", "1"}], 
    "]"}], ",", 
   RowBox[{"Frame", "->", "True"}], ",", 
   RowBox[{"SymbolShape", "->", 
    RowBox[{"PlotSymbol", "[", 
     RowBox[{"Diamond", ",", ".5"}], "]"}]}], ",", 
   RowBox[{"FrameLabel", "->", 
    RowBox[{"{", 
     RowBox[{
     "\"\<incident momentum (GeV/c)\>\"", ",", 
      "\"\<cross section (\[Mu]b)\>\""}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.0.5"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.00634921 -0.54401 0.00298784 [
[.02381 -0.0125 -3 -9 ]
[.02381 -0.0125 3 0 ]
[.15079 -0.0125 -6 -9 ]
[.15079 -0.0125 6 0 ]
[.27778 -0.0125 -6 -9 ]
[.27778 -0.0125 6 0 ]
[.40476 -0.0125 -6 -9 ]
[.40476 -0.0125 6 0 ]
[.53175 -0.0125 -6 -9 ]
[.53175 -0.0125 6 0 ]
[.65873 -0.0125 -9 -9 ]
[.65873 -0.0125 9 0 ]
[.78571 -0.0125 -9 -9 ]
[.78571 -0.0125 9 0 ]
[.9127 -0.0125 -9 -9 ]
[.9127 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[.5 -0.0125 -77 -19.375 ]
[.5 -0.0125 77 -9 ]
[-0.0125 .05356 -18 -4.5 ]
[-0.0125 .05356 0 4.5 ]
[-0.0125 .20295 -18 -4.5 ]
[-0.0125 .20295 0 4.5 ]
[-0.0125 .35234 -18 -4.5 ]
[-0.0125 .35234 0 4.5 ]
[-0.0125 .50173 -18 -4.5 ]
[-0.0125 .50173 0 4.5 ]
[ 0 0 -0.125 0 ]
[-0.01875 .30902 -28.375 -56 ]
[-0.01875 .30902 -18 56 ]
[ 0 .61803 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 0 m
.02381 .00625 L
s
[(0)] .02381 -0.0125 0 1 Mshowa
.15079 0 m
.15079 .00625 L
s
[(20)] .15079 -0.0125 0 1 Mshowa
.27778 0 m
.27778 .00625 L
s
[(40)] .27778 -0.0125 0 1 Mshowa
.40476 0 m
.40476 .00625 L
s
[(60)] .40476 -0.0125 0 1 Mshowa
.53175 0 m
.53175 .00625 L
s
[(80)] .53175 -0.0125 0 1 Mshowa
.65873 0 m
.65873 .00625 L
s
[(100)] .65873 -0.0125 0 1 Mshowa
.78571 0 m
.78571 .00625 L
s
[(120)] .78571 -0.0125 0 1 Mshowa
.9127 0 m
.9127 .00625 L
s
[(140)] .9127 -0.0125 0 1 Mshowa
.125 Mabswid
.05556 0 m
.05556 .00375 L
s
.0873 0 m
.0873 .00375 L
s
.11905 0 m
.11905 .00375 L
s
.18254 0 m
.18254 .00375 L
s
.21429 0 m
.21429 .00375 L
s
.24603 0 m
.24603 .00375 L
s
.30952 0 m
.30952 .00375 L
s
.34127 0 m
.34127 .00375 L
s
.37302 0 m
.37302 .00375 L
s
.43651 0 m
.43651 .00375 L
s
.46825 0 m
.46825 .00375 L
s
.5 0 m
.5 .00375 L
s
.56349 0 m
.56349 .00375 L
s
.59524 0 m
.59524 .00375 L
s
.62698 0 m
.62698 .00375 L
s
.69048 0 m
.69048 .00375 L
s
.72222 0 m
.72222 .00375 L
s
.75397 0 m
.75397 .00375 L
s
.81746 0 m
.81746 .00375 L
s
.84921 0 m
.84921 .00375 L
s
.88095 0 m
.88095 .00375 L
s
.94444 0 m
.94444 .00375 L
s
.97619 0 m
.97619 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
gsave
.5 -0.0125 -138 -23.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(incident) show
117.000 11.562 moveto
(momentum) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
171.000 11.562 moveto
(H) show
177.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(GeV) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
195.000 11.562 moveto
(\\220) show
201.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(c) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
207.000 11.562 moveto
(L) show
213.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .05356 m
.00625 .05356 L
s
[(200)] -0.0125 .05356 1 0 Mshowa
0 .20295 m
.00625 .20295 L
s
[(250)] -0.0125 .20295 1 0 Mshowa
0 .35234 m
.00625 .35234 L
s
[(300)] -0.0125 .35234 1 0 Mshowa
0 .50173 m
.00625 .50173 L
s
[(350)] -0.0125 .50173 1 0 Mshowa
.125 Mabswid
0 .08344 m
.00375 .08344 L
s
0 .11331 m
.00375 .11331 L
s
0 .14319 m
.00375 .14319 L
s
0 .17307 m
.00375 .17307 L
s
0 .23283 m
.00375 .23283 L
s
0 .26271 m
.00375 .26271 L
s
0 .29258 m
.00375 .29258 L
s
0 .32246 m
.00375 .32246 L
s
0 .38222 m
.00375 .38222 L
s
0 .4121 m
.00375 .4121 L
s
0 .44198 m
.00375 .44198 L
s
0 .47185 m
.00375 .47185 L
s
0 .02368 m
.00375 .02368 L
s
0 .53161 m
.00375 .53161 L
s
0 .56149 m
.00375 .56149 L
s
0 .59137 m
.00375 .59137 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
gsave
-0.01875 .30902 -140.188 -9.1875 Mabsadd m
1 1 Mabs scale
currentpoint translate
117 9.1875 translate
90 rotate
-117 -9.1875 translate
0 18.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.562 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(cross) show
99.000 11.562 moveto
(section) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
147.000 11.562 moveto
(H) show
153.000 11.562 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(m) show
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(b) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
165.000 11.562 moveto
(L) show
171.000 11.562 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.02381 .61178 m
.02381 .61803 L
s
.15079 .61178 m
.15079 .61803 L
s
.27778 .61178 m
.27778 .61803 L
s
.40476 .61178 m
.40476 .61803 L
s
.53175 .61178 m
.53175 .61803 L
s
.65873 .61178 m
.65873 .61803 L
s
.78571 .61178 m
.78571 .61803 L
s
.9127 .61178 m
.9127 .61803 L
s
.125 Mabswid
.05556 .61428 m
.05556 .61803 L
s
.0873 .61428 m
.0873 .61803 L
s
.11905 .61428 m
.11905 .61803 L
s
.18254 .61428 m
.18254 .61803 L
s
.21429 .61428 m
.21429 .61803 L
s
.24603 .61428 m
.24603 .61803 L
s
.30952 .61428 m
.30952 .61803 L
s
.34127 .61428 m
.34127 .61803 L
s
.37302 .61428 m
.37302 .61803 L
s
.43651 .61428 m
.43651 .61803 L
s
.46825 .61428 m
.46825 .61803 L
s
.5 .61428 m
.5 .61803 L
s
.56349 .61428 m
.56349 .61803 L
s
.59524 .61428 m
.59524 .61803 L
s
.62698 .61428 m
.62698 .61803 L
s
.69048 .61428 m
.69048 .61803 L
s
.72222 .61428 m
.72222 .61803 L
s
.75397 .61428 m
.75397 .61803 L
s
.81746 .61428 m
.81746 .61803 L
s
.84921 .61428 m
.84921 .61803 L
s
.88095 .61428 m
.88095 .61803 L
s
.94444 .61428 m
.94444 .61803 L
s
.97619 .61428 m
.97619 .61803 L
s
.25 Mabswid
0 .61803 m
1 .61803 L
s
.99375 .05356 m
1 .05356 L
s
.99375 .20295 m
1 .20295 L
s
.99375 .35234 m
1 .35234 L
s
.99375 .50173 m
1 .50173 L
s
.125 Mabswid
.99625 .08344 m
1 .08344 L
s
.99625 .11331 m
1 .11331 L
s
.99625 .14319 m
1 .14319 L
s
.99625 .17307 m
1 .17307 L
s
.99625 .23283 m
1 .23283 L
s
.99625 .26271 m
1 .26271 L
s
.99625 .29258 m
1 .29258 L
s
.99625 .32246 m
1 .32246 L
s
.99625 .38222 m
1 .38222 L
s
.99625 .4121 m
1 .4121 L
s
.99625 .44198 m
1 .44198 L
s
.99625 .47185 m
1 .47185 L
s
.99625 .02368 m
1 .02368 L
s
.99625 .53161 m
1 .53161 L
s
.99625 .56149 m
1 .56149 L
s
.99625 .59137 m
1 .59137 L
s
.25 Mabswid
1 0 m
1 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.001 w
.04921 .60332 m
.04921 .50173 L
s
.04921 .60332 1.5 0 Mabsadd m
.04921 .60332 -1.5 0 Mabsadd L s
.04921 .50173 1.5 0 Mabsadd m
.04921 .50173 -1.5 0 Mabsadd L s
.0619 .4121 m
.0619 .35832 L
s
.0619 .4121 1.5 0 Mabsadd m
.0619 .4121 -1.5 0 Mabsadd L s
.0619 .35832 1.5 0 Mabsadd m
.0619 .35832 -1.5 0 Mabsadd L s
.0746 .36429 m
.0746 .31051 L
s
.0746 .36429 1.5 0 Mabsadd m
.0746 .36429 -1.5 0 Mabsadd L s
.0746 .31051 1.5 0 Mabsadd m
.0746 .31051 -1.5 0 Mabsadd L s
.0873 .27764 m
.0873 .23581 L
s
.0873 .27764 1.5 0 Mabsadd m
.0873 .27764 -1.5 0 Mabsadd L s
.0873 .23581 1.5 0 Mabsadd m
.0873 .23581 -1.5 0 Mabsadd L s
.1 .23283 m
.1 .191 L
s
.1 .23283 1.5 0 Mabsadd m
.1 .23283 -1.5 0 Mabsadd L s
.1 .191 1.5 0 Mabsadd m
.1 .191 -1.5 0 Mabsadd L s
.11905 .18801 m
.11905 .15216 L
s
.11905 .18801 1.5 0 Mabsadd m
.11905 .18801 -1.5 0 Mabsadd L s
.11905 .15216 1.5 0 Mabsadd m
.11905 .15216 -1.5 0 Mabsadd L s
.15079 .13124 m
.15079 .09539 L
s
.15079 .13124 1.5 0 Mabsadd m
.15079 .13124 -1.5 0 Mabsadd L s
.15079 .09539 1.5 0 Mabsadd m
.15079 .09539 -1.5 0 Mabsadd L s
.21429 .11033 m
.21429 .07447 L
s
.21429 .11033 1.5 0 Mabsadd m
.21429 .11033 -1.5 0 Mabsadd L s
.21429 .07447 1.5 0 Mabsadd m
.21429 .07447 -1.5 0 Mabsadd L s
.5 .04758 m
.5 .0177 L
s
.5 .04758 1.5 0 Mabsadd m
.5 .04758 -1.5 0 Mabsadd L s
.5 .0177 1.5 0 Mabsadd m
.5 .0177 -1.5 0 Mabsadd L s
.97619 .04459 m
.97619 .01472 L
s
.97619 .04459 1.5 0 Mabsadd m
.97619 .04459 -1.5 0 Mabsadd L s
.97619 .01472 1.5 0 Mabsadd m
.97619 .01472 -1.5 0 Mabsadd L s
.0001 w
.04921 .55253 -0.375 0 Mabsadd m
.04921 .55253 0 .5 Mabsadd L
.04921 .55253 .375 0 Mabsadd L
.04921 .55253 0 -0.5 Mabsadd L
.04921 .55253 -0.375 0 Mabsadd L closepath F
.0619 .38521 -0.375 0 Mabsadd m
.0619 .38521 0 .5 Mabsadd L
.0619 .38521 .375 0 Mabsadd L
.0619 .38521 0 -0.5 Mabsadd L
.0619 .38521 -0.375 0 Mabsadd L closepath F
.0746 .3374 -0.375 0 Mabsadd m
.0746 .3374 0 .5 Mabsadd L
.0746 .3374 .375 0 Mabsadd L
.0746 .3374 0 -0.5 Mabsadd L
.0746 .3374 -0.375 0 Mabsadd L closepath F
.0873 .25673 -0.375 0 Mabsadd m
.0873 .25673 0 .5 Mabsadd L
.0873 .25673 .375 0 Mabsadd L
.0873 .25673 0 -0.5 Mabsadd L
.0873 .25673 -0.375 0 Mabsadd L closepath F
.1 .21191 -0.375 0 Mabsadd m
.1 .21191 0 .5 Mabsadd L
.1 .21191 .375 0 Mabsadd L
.1 .21191 0 -0.5 Mabsadd L
.1 .21191 -0.375 0 Mabsadd L closepath F
.11905 .17008 -0.375 0 Mabsadd m
.11905 .17008 0 .5 Mabsadd L
.11905 .17008 .375 0 Mabsadd L
.11905 .17008 0 -0.5 Mabsadd L
.11905 .17008 -0.375 0 Mabsadd L closepath F
.15079 .11331 -0.375 0 Mabsadd m
.15079 .11331 0 .5 Mabsadd L
.15079 .11331 .375 0 Mabsadd L
.15079 .11331 0 -0.5 Mabsadd L
.15079 .11331 -0.375 0 Mabsadd L closepath F
.21429 .0924 -0.375 0 Mabsadd m
.21429 .0924 0 .5 Mabsadd L
.21429 .0924 .375 0 Mabsadd L
.21429 .0924 0 -0.5 Mabsadd L
.21429 .0924 -0.375 0 Mabsadd L closepath F
.5 .03264 -0.375 0 Mabsadd m
.5 .03264 0 .5 Mabsadd L
.5 .03264 .375 0 Mabsadd L
.5 .03264 0 -0.5 Mabsadd L
.5 .03264 -0.375 0 Mabsadd L closepath F
.97619 .02965 -0.375 0 Mabsadd m
.97619 .02965 0 .5 Mabsadd L
.97619 .02965 .375 0 Mabsadd L
.97619 .02965 0 -0.5 Mabsadd L
.97619 .02965 -0.375 0 Mabsadd L closepath F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.0.5"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.0.5"]
}, Open  ]],

Cell["\<\
Here is the Wolfcamp aquifer data again, this time displayed as a scatter \
plot. \
\>", "MathCaption",
 CellTags->{"S5.0.5", "5.7"}],

Cell[CellGroupData[{

Cell["\<\
(data = ReadList[\"wolfcamp.aquifer.data\",
   Number, RecordLists->True];
ScatterPlot3D[data, BoxRatios->{1, 1, .3}, Axes -> True,
   ViewPoint -> {1.3, 2.4, 2.}])\
\>", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.0.5"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .76154 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0493274 1.04933 -0.0923501 1.04933 [
[.86677 .20296 0 -8.96968 ]
[.86677 .20296 24 .03032 ]
[.62918 .11071 -0.45209 -9 ]
[.62918 .11071 5.54791 0 ]
[.36865 .00964 -2.77359 -9 ]
[.36865 .00964 15.2264 0 ]
[.01611 .41901 -6 -5.84056 ]
[.01611 .41901 0 3.15944 ]
[.07905 .32373 -12 -5.92685 ]
[.07905 .32373 0 3.07315 ]
[.14908 .21775 -18 -6.02502 ]
[.14908 .21775 0 2.97498 ]
[.22745 .09914 -18 -6.1377 ]
[.22745 .09914 0 2.8623 ]
[.98452 .26363 0 -2.76318 ]
[.98452 .26363 24 6.23682 ]
[.99474 .32766 0 -2.81693 ]
[.99474 .32766 24 6.18307 ]
[1.00538 .39435 0 -2.87315 ]
[1.00538 .39435 24 6.12685 ]
[ 0 0 0 0 ]
[ 1 .76154 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.97189 .25642 m
.30833 0 L
s
.85746 .2122 m
.85281 .21682 L
s
[(-100)] .86677 .20296 -1 .99326 Mshowa
.62069 .12071 m
.61645 .1257 L
s
[(0)] .62918 .11071 -0.8493 1 Mshowa
.36118 .02043 m
.35745 .02582 L
s
[(100)] .36865 .00964 -0.69182 1 Mshowa
.125 Mabswid
.81178 .19455 m
.80904 .19736 L
s
.76529 .17658 m
.76259 .17944 L
s
.71796 .15829 m
.71531 .1612 L
s
.66977 .13967 m
.66717 .14262 L
s
.57071 .10139 m
.56822 .10444 L
s
.5198 .08172 m
.51736 .08481 L
s
.46792 .06167 m
.46555 .06481 L
s
.41506 .04124 m
.41275 .04443 L
s
.90235 .22954 m
.89952 .23227 L
s
.94646 .24659 m
.94359 .24928 L
s
.25 Mabswid
.02319 .43105 m
.30833 0 L
s
.02868 .42275 m
.03496 .42462 L
s
[(0)] .01611 .41901 1 .2979 Mshowa
.09156 .3277 m
.09781 .32968 L
s
[(50)] .07905 .32373 1 .31708 Mshowa
.1615 .22196 m
.16771 .22406 L
s
[(100)] .14908 .21775 1 .33889 Mshowa
.23978 .10362 m
.24594 .10587 L
s
[(150)] .22745 .09914 1 .36393 Mshowa
.125 Mabswid
.04074 .40452 m
.04451 .40565 L
s
.05305 .3859 m
.05681 .38705 L
s
.06562 .36691 m
.06938 .36807 L
s
.07845 .34751 m
.08221 .34868 L
s
.10494 .30746 m
.10869 .30866 L
s
.11862 .28678 m
.12236 .288 L
s
.1326 .26565 m
.13634 .26688 L
s
.14689 .24404 m
.15062 .24529 L
s
.17645 .19937 m
.18017 .20064 L
s
.19173 .17626 m
.19545 .17755 L
s
.20738 .15261 m
.21109 .15392 L
s
.22339 .1284 m
.22709 .12973 L
s
.25657 .07825 m
.26026 .07961 L
s
.27376 .05225 m
.27745 .05363 L
s
.29139 .02561 m
.29506 .02701 L
s
.25 Mabswid
.97189 .25642 m
1 .43378 L
s
.97229 .25891 m
.96617 .25655 L
s
[(1000)] .98452 .26363 -1 -0.38596 Mshowa
.98245 .32306 m
.97631 .32076 L
s
[(2000)] .99474 .32766 -1 -0.37402 Mshowa
.99305 .3899 m
.98688 .38767 L
s
[(3000)] 1.00538 .39435 -1 -0.36152 Mshowa
.125 Mabswid
.97429 .27153 m
.97061 .27012 L
s
.97631 .28426 m
.97263 .28286 L
s
.97834 .29709 m
.97466 .29569 L
s
.98039 .31002 m
.97671 .30864 L
s
.98454 .33621 m
.98085 .33484 L
s
.98664 .34946 m
.98295 .3481 L
s
.98876 .36283 m
.98506 .36148 L
s
.99089 .37631 m
.98719 .37496 L
s
.99522 .4036 m
.99151 .40227 L
s
.99741 .41742 m
.9937 .4161 L
s
.99962 .43135 m
.99591 .43004 L
s
.25 Mabswid
.59691 .60101 m
.60252 .76154 L
s
.60252 .76154 m
1 .43378 L
s
1 .43378 m
.97189 .25642 L
s
.97189 .25642 m
.59691 .60101 L
s
.02319 .43105 m
.30833 0 L
s
.30833 0 m
.29755 .18561 L
s
.29755 .18561 m
0 .60069 L
s
0 .60069 m
.02319 .43105 L
s
.59691 .60101 m
.60252 .76154 L
s
.60252 .76154 m
0 .60069 L
s
0 .60069 m
.02319 .43105 L
s
.02319 .43105 m
.59691 .60101 L
s
.97189 .25642 m
.30833 0 L
s
.30833 0 m
.29755 .18561 L
s
.29755 .18561 m
1 .43378 L
s
1 .43378 m
.97189 .25642 L
s
0 0 m
1 0 L
1 .76154 L
0 .76154 L
closepath
clip
newpath
.01 w
.52521 .70417 Mdot
.64514 .7022 Mdot
.55369 .61012 Mdot
.5261 .63143 Mdot
.3564 .6124 Mdot
.35369 .57438 Mdot
.36108 .59997 Mdot
.52633 .5829 Mdot
.57625 .62992 Mdot
.36813 .58786 Mdot
.51731 .58642 Mdot
.54669 .5922 Mdot
.37695 .54888 Mdot
.3756 .56107 Mdot
.29213 .5673 Mdot
.36977 .55644 Mdot
.56537 .58158 Mdot
.34056 .55107 Mdot
.34723 .53447 Mdot
.13327 .4679 Mdot
.34659 .53548 Mdot
.12976 .47914 Mdot
.15574 .46514 Mdot
.37734 .53712 Mdot
.37049 .54407 Mdot
.204 .48247 Mdot
.3603 .53517 Mdot
.2006 .45221 Mdot
.61089 .52768 Mdot
.08688 .4357 Mdot
.09529 .42959 Mdot
.18427 .44014 Mdot
.09576 .43377 Mdot
.19012 .45412 Mdot
.64188 .52163 Mdot
.34979 .52022 Mdot
.69016 .60915 Mdot
.12691 .42707 Mdot
.13565 .42608 Mdot
.27376 .43192 Mdot
.59908 .50142 Mdot
.14231 .42294 Mdot
.14068 .40633 Mdot
.45323 .47426 Mdot
.29565 .43776 Mdot
.09583 .38937 Mdot
.14957 .36348 Mdot
.40153 .44169 Mdot
.17033 .39168 Mdot
.42737 .42646 Mdot
.36912 .43158 Mdot
.4985 .46023 Mdot
.14727 .37344 Mdot
.16231 .36624 Mdot
.26608 .36224 Mdot
.48421 .37701 Mdot
.53748 .39096 Mdot
.55875 .31058 Mdot
.15888 .3154 Mdot
.25951 .31543 Mdot
.48053 .29397 Mdot
.29881 .26981 Mdot
.57178 .31259 Mdot
.31351 .27618 Mdot
.56638 .30928 Mdot
.63313 .30106 Mdot
.39646 .25862 Mdot
.47069 .2478 Mdot
.65277 .27761 Mdot
.63213 .20613 Mdot
.31037 .16521 Mdot
.61888 .19369 Mdot
.24585 .18478 Mdot
.40352 .21185 Mdot
.67194 .18788 Mdot
.51715 .13133 Mdot
.42287 .13379 Mdot
.38646 .12643 Mdot
.38382 .12445 Mdot
.43151 .1241 Mdot
.34963 .14277 Mdot
.44117 .13874 Mdot
.42815 .11521 Mdot
.4335 .12806 Mdot
.42053 .11163 Mdot
.25 Mabswid
.02319 .43105 m
.30833 0 L
s
.30833 0 m
.29755 .18561 L
s
.29755 .18561 m
0 .60069 L
s
0 .60069 m
.02319 .43105 L
s
.97189 .25642 m
.30833 0 L
s
.30833 0 m
.29755 .18561 L
s
.29755 .18561 m
1 .43378 L
s
1 .43378 m
.97189 .25642 L
s
.97189 .25642 m
.30833 0 L
s
.85746 .2122 m
.85281 .21682 L
s
[(-100)] .86677 .20296 -1 .99326 Mshowa
.62069 .12071 m
.61645 .1257 L
s
[(0)] .62918 .11071 -0.8493 1 Mshowa
.36118 .02043 m
.35745 .02582 L
s
[(100)] .36865 .00964 -0.69182 1 Mshowa
.125 Mabswid
.81178 .19455 m
.80904 .19736 L
s
.76529 .17658 m
.76259 .17944 L
s
.71796 .15829 m
.71531 .1612 L
s
.66977 .13967 m
.66717 .14262 L
s
.57071 .10139 m
.56822 .10444 L
s
.5198 .08172 m
.51736 .08481 L
s
.46792 .06167 m
.46555 .06481 L
s
.41506 .04124 m
.41275 .04443 L
s
.90235 .22954 m
.89952 .23227 L
s
.94646 .24659 m
.94359 .24928 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.0.5"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics3D", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S5.0.5"]
}, Open  ]],

Cell["\<\
Load the statistics packages so distribution formulas can be used. \
\>", "MathCaption",
 CellTags->{"S5.0.5", "5.8"}],

Cell["Needs[\"Statistics`\"]", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.0.5"],

Cell["\<\
You can visualize the two\[Hyphen]parameter gamma probability density \
function by creating a row of stacked graphics. A function having three \
parameters can be visualized using a two\[Hyphen]dimensional array of stacked \
graphics. \
\>", "MathCaption",
 CellTags->{"S5.0.5", "5.9"}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"(", 
  RowBox[{
   RowBox[{"alphas", "=", 
    RowBox[{"{", 
     RowBox[{".5", ",", "1.", ",", "1.5", ",", "2."}], "}"}]}], ";", 
   RowBox[{"betas", "=", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "4"}], "}"}]}], ";", 
   RowBox[{"stacks", "=", 
    RowBox[{"MapThread", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Append", "[", 
        RowBox[{
         RowBox[{"StackGraphics", "[", "#1", "]"}], ",", 
         RowBox[{"PlotLabel", "->", 
          RowBox[{"\"\<\[Beta] = \>\"", "<>", 
           RowBox[{"ToString", "[", "#2", "]"}]}]}]}], "]"}], "&"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Apply", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Plot", "[", 
            RowBox[{
             RowBox[{"Evaluate", "[", 
              RowBox[{"PDF", "[", 
               RowBox[{
                RowBox[{"GammaDistribution", "[", 
                 RowBox[{"#2", ",", "#1"}], "]"}], ",", "x"}], "]"}], "]"}], 
             ",", 
             RowBox[{"{", 
              RowBox[{"x", ",", "$MachineEpsilon", ",", "4"}], "}"}], ",", 
             RowBox[{"DisplayFunction", "->", "Identity"}]}], "]"}], "&"}], 
          ",", 
          RowBox[{"Outer", "[", 
           RowBox[{"List", ",", "betas", ",", "alphas"}], "]"}], ",", 
          RowBox[{"{", "2", "}"}]}], "]"}], ",", "betas"}], "}"}]}], "]"}]}], 
   ";", 
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"GraphicsArray", "[", "stacks", "]"}], ",", 
     RowBox[{
     "PlotLabel", "->", 
      "\"\<gamma distribution for \[Alpha] = .5, 1, 1.5, 2\>\""}]}], "]"}]}], 
  ")"}]], "Input",
 CellLabel->"In[7]:= ",
 CellTags->"S5.0.5"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .33922 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.31746 0.0080766 0.31746 [
[.5 .35172 -122 0 ]
[.5 .35172 122 10.125 ]
[ 0 0 0 0 ]
[ 1 .33922 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
gsave
.5 .35172 -183 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18.125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.562 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(gamma) show
99.000 11.562 moveto
(distribution) show
177.000 11.562 moveto
(for) show
201.000 11.562 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a) show
213.000 11.562 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(=) show
225.000 11.562 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(.5) show
237.000 11.562 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(,) show
249.000 11.562 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
255.000 11.562 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(,) show
267.000 11.562 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.5) show
285.000 11.562 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(,) show
297.000 11.562 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
303.000 11.562 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .33922 L
0 .33922 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0080766 0.321429 0.331141 MathSubStart
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0567234 1.16608 8.0502e-17 1.16608 [
[.5 1.098 -17 0 ]
[.5 1.098 17 9.8125 ]
[.09072 .22988 -5.91576 -9 ]
[.09072 .22988 .08424 0 ]
[.21906 .17566 -5.65366 -9 ]
[.21906 .17566 .34634 0 ]
[.3545 .11847 -5.39155 -9 ]
[.3545 .11847 .60845 0 ]
[.49765 .05807 -5.12945 -9 ]
[.49765 .05807 .87055 0 ]
[.64919 -0.00583 -4.86734 -9 ]
[.64919 -0.00583 1.13266 0 ]
[.07325 .26228 -6 -2.6177 ]
[.07325 .26228 0 6.3823 ]
[.05646 .36736 -24 -2.71099 ]
[.05646 .36736 0 6.28901 ]
[.03835 .48072 -18 -2.81238 ]
[.03835 .48072 0 6.18762 ]
[.01876 .60339 -24 -2.92298 ]
[.01876 .60339 0 6.07702 ]
[-0.00251 .73656 -6 -3.0441 ]
[-0.00251 .73656 0 5.9559 ]
[ 0 0 0 0 ]
[ 1 1.0855 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
gsave
.5 1.098 -78 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(b) show
75.000 11.250 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(=) show
87.000 11.250 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
93.000 11.250 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.25 Mabswid
[ ] 0 setdash
.08846 .24555 m
.67245 0 L
s
.10087 .24033 m
.10595 .24556 L
s
[(0)] .09072 .22988 .97192 1 Mshowa
.22871 .18658 m
.23354 .19204 L
s
[(1)] .21906 .17566 .88455 1 Mshowa
.36358 .12987 m
.36813 .13557 L
s
[(2)] .3545 .11847 .79718 1 Mshowa
.50609 .06995 m
.51031 .07589 L
s
[(3)] .49765 .05807 .70982 1 Mshowa
.65689 .00654 m
.66074 .01273 L
s
[(4)] .64919 -0.00583 .62245 1 Mshowa
.125 Mabswid
.12591 .22981 m
.12892 .23297 L
s
.1512 .21917 m
.15419 .22236 L
s
.17676 .20842 m
.17972 .21164 L
s
.2026 .19756 m
.20553 .20081 L
s
.25511 .17548 m
.25797 .17879 L
s
.28179 .16426 m
.28462 .1676 L
s
.30875 .15292 m
.31155 .15628 L
s
.33602 .14146 m
.33878 .14485 L
s
.39145 .11815 m
.39414 .1216 L
s
.41963 .1063 m
.42229 .10978 L
s
.44813 .09432 m
.45074 .09783 L
s
.47695 .0822 m
.47952 .08574 L
s
.53556 .05756 m
.53805 .06115 L
s
.56537 .04502 m
.56782 .04865 L
s
.59553 .03235 m
.59793 .036 L
s
.62603 .01952 m
.62839 .0232 L
s
.25 Mabswid
.08846 .24555 m
0 .80374 L
s
.0867 .25665 m
.09342 .25384 L
s
[(0)] .07325 .26228 1 -0.41829 Mshowa
.07001 .36197 m
.07678 .35928 L
s
[(0.25)] .05646 .36736 1 -0.39756 Mshowa
.052 .4756 m
.05882 .47304 L
s
[(0.5)] .03835 .48072 1 -0.37503 Mshowa
.03251 .59857 m
.03939 .59616 L
s
[(0.75)] .01876 .60339 1 -0.35045 Mshowa
.01136 .73208 m
.01829 .72983 L
s
[(1)] -0.00251 .73656 1 -0.32353 Mshowa
.125 Mabswid
.08346 .2771 m
.0875 .27542 L
s
.08017 .29784 m
.08422 .29618 L
s
.07683 .3189 m
.08088 .31725 L
s
.07345 .34027 m
.0775 .33864 L
s
.06652 .384 m
.07059 .3824 L
s
.06297 .40637 m
.06705 .40479 L
s
.05937 .42909 m
.06345 .42752 L
s
.05571 .45216 m
.0598 .45061 L
s
.04823 .49941 m
.05233 .4979 L
s
.04439 .52361 m
.0485 .52211 L
s
.0405 .54819 m
.04461 .54671 L
s
.03654 .57318 m
.04066 .57171 L
s
.02842 .62439 m
.03256 .62296 L
s
.02426 .65063 m
.0284 .64923 L
s
.02003 .67732 m
.02418 .67594 L
s
.01573 .70447 m
.01989 .7031 L
s
.00691 .76016 m
.01107 .75884 L
s
.00238 .78874 m
.00655 .78743 L
s
.25 Mabswid
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.40037 1.0855 L
s
.40037 1.0855 m
.41799 .58158 L
s
.41799 .58158 m
.08846 .24555 L
s
.67245 0 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.67245 0 m
.08846 .24555 L
s
.41799 .58158 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.40037 1.0855 L
s
.40037 1.0855 m
.41799 .58158 L
s
0 0 m
1 0 L
1 1.0855 L
0 1.0855 L
closepath
clip
newpath
.5 Mabswid
.42216 .58164 m
.43011 .60673 L
s
.43011 .60673 m
.43881 .62904 L
s
.43881 .62904 m
.4487 .64913 L
s
.4487 .64913 m
.45818 .66402 L
s
.45818 .66402 m
.46751 .67523 L
s
.46751 .67523 m
.47647 .6833 L
s
.47647 .6833 m
.48651 .68967 L
s
.48651 .68967 m
.49575 .69341 L
s
.3295 .4871 m
.32806 .51771 L
s
.49575 .69341 m
.50061 .69466 L
s
.50061 .69466 m
.50578 .69551 L
s
.50578 .69551 m
.51065 .69588 L
s
.51065 .69588 m
.51511 .6959 L
s
.51511 .6959 m
.51989 .69558 L
s
.51989 .69558 m
.52235 .69529 L
s
.32806 .51771 m
.32781 .52934 L
s
.52235 .69529 m
.52505 .69489 L
s
.52505 .69489 m
.52753 .69443 L
s
.52753 .69443 m
.52874 .69418 L
s
.52874 .69418 m
.52984 .69394 L
s
.52984 .69394 m
.5309 .6937 L
s
.5309 .6937 m
.53205 .69342 L
s
.53205 .69342 m
.53268 .69326 L
s
.53268 .69326 m
.53326 .69311 L
s
.53326 .69311 m
.53381 .69296 L
s
.53381 .69296 m
.5344 .6928 L
s
.5344 .6928 m
.53505 .69262 L
s
.53505 .69262 m
.53566 .69244 L
s
.53566 .69244 m
.53626 .69226 L
s
.53626 .69226 m
.53681 .6921 L
s
.53681 .6921 m
.5374 .69192 L
s
.5374 .69192 m
.53806 .69171 L
s
.53806 .69171 m
.53839 .69161 L
s
.53839 .69161 m
.53875 .69149 L
s
.32781 .52934 m
.32774 .53952 L
s
.53875 .69149 m
.53939 .69129 L
s
.53939 .69129 m
.54058 .69089 L
s
.54058 .69089 m
.54182 .69046 L
s
.54182 .69046 m
.54406 .68965 L
s
.54406 .68965 m
.54668 .68864 L
s
.54668 .68864 m
.54913 .68764 L
s
.54913 .68764 m
.55468 .6852 L
s
.55468 .6852 m
.56523 .67994 L
s
.32774 .53952 m
.32779 .54746 L
s
.56523 .67994 m
.57483 .67453 L
s
.57483 .67453 m
.59551 .66138 L
s
.32779 .54746 m
.32846 .56974 L
s
.59551 .66138 m
.61545 .64734 L
s
.61545 .64734 m
.63668 .63154 L
s
.63668 .63154 m
.65715 .61592 L
s
.65715 .61592 m
.67687 .60084 L
s
.67687 .60084 m
.69792 .58494 L
s
.69792 .58494 m
.71824 .56993 L
s
.71824 .56993 m
.73993 .55442 L
s
.32846 .56974 m
.32965 .58734 L
s
.73993 .55442 m
.76091 .53996 L
s
.76091 .53996 m
.7812 .52654 L
s
.7812 .52654 m
.80291 .51277 L
s
.80291 .51277 m
.82394 .50002 L
s
.32965 .58734 m
.33124 .60221 L
s
.82394 .50002 m
.84644 .48699 L
s
.84644 .48699 m
.86828 .47491 L
s
.86828 .47491 m
.88946 .4637 L
s
.33124 .60221 m
.33501 .62428 L
s
.88946 .4637 m
.91215 .45217 L
s
.91215 .45217 m
.91403 .45123 L
s
.33501 .62428 m
.33892 .63871 L
s
.33892 .63871 m
.34321 .64951 L
s
.34321 .64951 m
.34818 .65801 L
s
.34818 .65801 m
.35358 .66398 L
s
.35358 .66398 m
.35605 .66587 L
s
.35605 .66587 m
.35879 .66745 L
s
.35879 .66745 m
.3615 .66858 L
s
.3615 .66858 m
.36405 .66927 L
s
.36405 .66927 m
.36671 .66966 L
s
.36671 .66966 m
.36914 .66976 L
s
.36914 .66976 m
.37029 .66972 L
s
.37029 .66972 m
.37154 .66963 L
s
.37154 .66963 m
.37263 .6695 L
s
.37263 .6695 m
.37382 .66932 L
s
.37382 .66932 m
.37509 .66907 L
s
.37509 .66907 m
.37579 .66892 L
s
.37579 .66892 m
.37644 .66876 L
s
.37644 .66876 m
.37705 .6686 L
s
.37705 .6686 m
.37761 .66845 L
s
.55075 .50967 m
.57273 .49012 L
s
.53011 .52905 m
.55075 .50967 L
s
.37761 .66845 m
.37825 .66826 L
s
.50864 .55018 m
.53011 .52905 L
s
.37825 .66826 m
.37886 .66807 L
s
.57273 .49012 m
.59391 .47236 L
s
.37886 .66807 m
.37946 .66787 L
s
.37946 .66787 m
.38011 .66765 L
s
.38011 .66765 m
.38073 .66742 L
s
.48631 .573 m
.50864 .55018 L
s
.38073 .66742 m
.38129 .66721 L
s
.38129 .66721 m
.38261 .66669 L
s
.59391 .47236 m
.6165 .45458 L
s
.38261 .66669 m
.38399 .6661 L
s
.38399 .6661 m
.38661 .66486 L
s
.46528 .5949 m
.48631 .573 L
s
.38661 .66486 m
.38948 .66335 L
s
.6165 .45458 m
.63833 .43846 L
s
.38948 .66335 m
.39462 .66027 L
s
.44339 .61748 m
.46528 .5949 L
s
.39462 .66027 m
.39942 .65702 L
s
.39942 .65702 m
.42067 .63952 L
s
.63833 .43846 m
.65942 .4238 L
s
.42067 .63952 m
.44339 .61748 L
s
.65942 .4238 m
.68199 .40903 L
s
.68199 .40903 m
.70384 .39554 L
s
.70384 .39554 m
.72722 .3819 L
s
.72722 .3819 m
.74991 .36935 L
s
.74991 .36935 m
.7719 .35776 L
s
.7719 .35776 m
.79548 .34587 L
s
.79548 .34587 m
.81837 .3348 L
s
.81837 .3348 m
.84056 .32445 L
s
.84056 .32445 m
.84056 .32445 L
s
.43257 .37868 m
.45511 .35841 L
s
.40908 .40206 m
.43257 .37868 L
s
.45511 .35841 m
.47675 .34064 L
s
.38684 .42665 m
.40908 .40206 L
s
.47675 .34064 m
.49982 .32327 L
s
.36349 .45547 m
.38684 .42665 L
s
.49982 .32327 m
.52208 .30781 L
s
.52208 .30781 m
.54584 .29247 L
s
.33886 .48966 m
.36349 .45547 L
s
.54584 .29247 m
.56884 .27861 L
s
.56884 .27861 m
.59109 .26596 L
s
.31518 .5267 m
.33886 .48966 L
s
.59109 .26596 m
.61493 .25311 L
s
.28987 .57134 m
.31518 .5267 L
s
.61493 .25311 m
.63805 .24122 L
s
.63805 .24122 m
.6628 .22903 L
s
.6628 .22903 m
.68685 .21762 L
s
.26521 .62031 m
.28987 .57134 L
s
.68685 .21762 m
.71019 .20689 L
s
.71019 .20689 m
.73521 .19569 L
s
.23835 .68024 m
.26521 .62031 L
s
.73521 .19569 m
.75829 .1856 L
s
.20795 .75675 m
.23835 .68024 L
s
.27762 .24165 m
.30143 .2215 L
s
.2526 .26606 m
.27762 .24165 L
s
.22853 .2937 m
.2526 .26606 L
s
.30143 .2215 m
.3242 .20435 L
s
.3242 .20435 m
.34837 .18787 L
s
.20261 .3297 m
.22853 .2937 L
s
.34837 .18787 m
.37167 .17328 L
s
.37167 .17328 m
.39415 .16015 L
s
.17676 .37425 m
.20261 .3297 L
s
.39415 .16015 m
.41819 .1469 L
s
.17789 .8416 m
.20795 .75675 L
s
.41819 .1469 m
.44146 .13469 L
s
.1614 .40603 m
.17676 .37425 L
s
.44146 .13469 m
.46638 .12215 L
s
.46638 .12215 m
.49057 .11039 L
s
.1458 .44323 m
.1614 .40603 L
s
.49057 .11039 m
.51401 .0993 L
s
.51401 .0993 m
.53917 .08767 L
s
.12784 .49319 m
.1458 .44323 L
s
.53917 .08767 m
.5636 .07658 L
s
.5636 .07658 m
.5898 .06488 L
s
.5898 .06488 m
.61529 .05365 L
s
.10877 .55563 m
.12784 .49319 L
s
.61529 .05365 m
.64003 .04286 L
s
.64003 .04286 m
.66508 .03202 L
s
.09681 .60003 m
.10877 .55563 L
s
.08155 .66267 m
.09681 .60003 L
s
.06608 .73265 m
.08155 .66267 L
s
.05588 .78206 m
.06608 .73265 L
s
.05245 .79956 m
.05588 .78206 L
s
.25 Mabswid
.67245 0 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.67245 0 m
.08846 .24555 L
s
.08846 .24555 m
.67245 0 L
s
.10087 .24033 m
.10595 .24556 L
s
[(0)] .09072 .22988 .97192 1 Mshowa
.22871 .18658 m
.23354 .19204 L
s
[(1)] .21906 .17566 .88455 1 Mshowa
.36358 .12987 m
.36813 .13557 L
s
[(2)] .3545 .11847 .79718 1 Mshowa
.50609 .06995 m
.51031 .07589 L
s
[(3)] .49765 .05807 .70982 1 Mshowa
.65689 .00654 m
.66074 .01273 L
s
[(4)] .64919 -0.00583 .62245 1 Mshowa
.125 Mabswid
.12591 .22981 m
.12892 .23297 L
s
.1512 .21917 m
.15419 .22236 L
s
.17676 .20842 m
.17972 .21164 L
s
.2026 .19756 m
.20553 .20081 L
s
.25511 .17548 m
.25797 .17879 L
s
.28179 .16426 m
.28462 .1676 L
s
.30875 .15292 m
.31155 .15628 L
s
.33602 .14146 m
.33878 .14485 L
s
.39145 .11815 m
.39414 .1216 L
s
.41963 .1063 m
.42229 .10978 L
s
.44813 .09432 m
.45074 .09783 L
s
.47695 .0822 m
.47952 .08574 L
s
.53556 .05756 m
.53805 .06115 L
s
.56537 .04502 m
.56782 .04865 L
s
.59553 .03235 m
.59793 .036 L
s
.62603 .01952 m
.62839 .0232 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.35119 0.0080766 0.64881 0.331141 MathSubStart
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0567234 1.16608 7.8171e-17 1.16608 [
[.5 1.098 -17 0 ]
[.5 1.098 17 9.8125 ]
[.09072 .22988 -5.91576 -9 ]
[.09072 .22988 .08424 0 ]
[.21906 .17566 -5.65366 -9 ]
[.21906 .17566 .34634 0 ]
[.3545 .11847 -5.39155 -9 ]
[.3545 .11847 .60845 0 ]
[.49765 .05807 -5.12945 -9 ]
[.49765 .05807 .87055 0 ]
[.64919 -0.00583 -4.86734 -9 ]
[.64919 -0.00583 1.13266 0 ]
[.07325 .26228 -6 -2.6177 ]
[.07325 .26228 0 6.3823 ]
[.04545 .43627 -18 -2.77254 ]
[.04545 .43627 0 6.22746 ]
[.01393 .63359 -18 -2.95035 ]
[.01393 .63359 0 6.04965 ]
[ 0 0 0 0 ]
[ 1 1.0855 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
gsave
.5 1.098 -78 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(b) show
75.000 11.250 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(=) show
87.000 11.250 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
93.000 11.250 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.25 Mabswid
[ ] 0 setdash
.08846 .24555 m
.67245 0 L
s
.10087 .24033 m
.10595 .24556 L
s
[(0)] .09072 .22988 .97192 1 Mshowa
.22871 .18658 m
.23354 .19204 L
s
[(1)] .21906 .17566 .88455 1 Mshowa
.36358 .12987 m
.36813 .13557 L
s
[(2)] .3545 .11847 .79718 1 Mshowa
.50609 .06995 m
.51031 .07589 L
s
[(3)] .49765 .05807 .70982 1 Mshowa
.65689 .00654 m
.66074 .01273 L
s
[(4)] .64919 -0.00583 .62245 1 Mshowa
.125 Mabswid
.12591 .22981 m
.12892 .23297 L
s
.1512 .21917 m
.15419 .22236 L
s
.17676 .20842 m
.17972 .21164 L
s
.2026 .19756 m
.20553 .20081 L
s
.25511 .17548 m
.25797 .17879 L
s
.28179 .16426 m
.28462 .1676 L
s
.30875 .15292 m
.31155 .15628 L
s
.33602 .14146 m
.33878 .14485 L
s
.39145 .11815 m
.39414 .1216 L
s
.41963 .1063 m
.42229 .10978 L
s
.44813 .09432 m
.45074 .09783 L
s
.47695 .0822 m
.47952 .08574 L
s
.53556 .05756 m
.53805 .06115 L
s
.56537 .04502 m
.56782 .04865 L
s
.59553 .03235 m
.59793 .036 L
s
.62603 .01952 m
.62839 .0232 L
s
.25 Mabswid
.08846 .24555 m
0 .80374 L
s
.0867 .25665 m
.09342 .25384 L
s
[(0)] .07325 .26228 1 -0.41829 Mshowa
.05906 .43105 m
.06586 .42844 L
s
[(0.2)] .04545 .43627 1 -0.38388 Mshowa
.02772 .62885 m
.03461 .62648 L
s
[(0.4)] .01393 .63359 1 -0.34437 Mshowa
.125 Mabswid
.0801 .29829 m
.08414 .29663 L
s
.0733 .34119 m
.07736 .33956 L
s
.06629 .38543 m
.07036 .38383 L
s
.0516 .47813 m
.05569 .4766 L
s
.0439 .52674 m
.048 .52524 L
s
.03594 .57695 m
.04006 .57549 L
s
.01921 .68251 m
.02336 .68113 L
s
.01041 .73804 m
.01457 .7367 L
s
.0013 .79553 m
.00548 .79424 L
s
.25 Mabswid
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.40037 1.0855 L
s
.40037 1.0855 m
.41799 .58158 L
s
.41799 .58158 m
.08846 .24555 L
s
.67245 0 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.67245 0 m
.08846 .24555 L
s
.41799 .58158 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.40037 1.0855 L
s
.40037 1.0855 m
.41799 .58158 L
s
0 0 m
1 0 L
1 1.0855 L
0 1.0855 L
closepath
clip
newpath
.5 Mabswid
.42216 .58164 m
.43948 .60472 L
s
.43948 .60472 m
.45901 .62528 L
s
.45901 .62528 m
.47788 .64059 L
s
.47788 .64059 m
.49643 .65198 L
s
.49643 .65198 m
.51657 .66085 L
s
.51657 .66085 m
.53628 .66654 L
s
.3295 .48705 m
.32863 .50886 L
s
.53628 .66654 m
.55753 .66987 L
s
.32863 .50886 m
.3286 .51715 L
s
.3286 .51715 m
.32872 .52443 L
s
.32872 .52443 m
.32891 .53014 L
s
.55753 .66987 m
.57825 .67071 L
s
.32891 .53014 m
.32996 .54635 L
s
.57825 .67071 m
.59838 .66959 L
s
.32996 .54635 m
.33142 .55948 L
s
.59838 .66959 m
.60885 .66835 L
s
.33142 .55948 m
.3332 .57092 L
s
.60885 .66835 m
.61999 .66659 L
s
.61999 .66659 m
.62499 .66566 L
s
.3332 .57092 m
.33717 .58886 L
s
.62499 .66566 m
.63038 .66456 L
s
.63038 .66456 m
.63543 .66345 L
s
.63543 .66345 m
.64014 .66235 L
s
.64014 .66235 m
.64554 .661 L
s
.64554 .661 m
.6484 .66026 L
s
.6484 .66026 m
.65145 .65944 L
s
.65145 .65944 m
.65285 .65906 L
s
.65285 .65906 m
.65436 .65864 L
s
.65436 .65864 m
.65569 .65826 L
s
.65569 .65826 m
.6571 .65786 L
s
.6571 .65786 m
.65838 .65749 L
s
.65838 .65749 m
.6591 .65728 L
s
.6591 .65728 m
.65977 .65708 L
s
.65977 .65708 m
.6604 .6569 L
s
.33717 .58886 m
.34112 .60164 L
s
.6604 .6569 m
.66096 .65673 L
s
.66096 .65673 m
.66162 .65653 L
s
.66162 .65653 m
.66224 .65635 L
s
.66224 .65635 m
.66285 .65617 L
s
.66285 .65617 m
.66351 .65597 L
s
.66351 .65597 m
.66413 .65578 L
s
.66413 .65578 m
.6647 .6556 L
s
.6647 .6556 m
.66603 .65519 L
s
.66603 .65519 m
.66743 .65476 L
s
.66743 .65476 m
.67007 .65393 L
s
.67007 .65393 m
.67296 .653 L
s
.67296 .653 m
.67811 .65129 L
s
.67811 .65129 m
.6829 .64965 L
s
.6829 .64965 m
.69397 .6457 L
s
.34112 .60164 m
.35022 .62173 L
s
.69397 .6457 m
.70406 .64189 L
s
.70406 .64189 m
.72583 .6331 L
s
.72583 .6331 m
.74688 .62396 L
s
.74688 .62396 m
.76936 .61363 L
s
.35022 .62173 m
.36044 .63604 L
s
.76936 .61363 m
.7911 .60319 L
s
.7911 .60319 m
.8121 .59279 L
s
.8121 .59279 m
.83455 .58139 L
s
.36044 .63604 m
.37 .64481 L
s
.83455 .58139 m
.85625 .57017 L
s
.85625 .57017 m
.87943 .55804 L
s
.37 .64481 m
.37919 .6504 L
s
.87943 .55804 m
.90186 .54621 L
s
.90186 .54621 m
.92354 .53473 L
s
.37919 .6504 m
.38956 .65426 L
s
.92354 .53473 m
.92484 .53405 L
s
.38956 .65426 m
.39919 .65607 L
s
.39919 .65607 m
.40919 .6565 L
s
.40919 .6565 m
.4149 .65621 L
s
.4149 .65621 m
.42023 .65562 L
s
.42023 .65562 m
.42294 .65521 L
s
.42294 .65521 m
.42589 .65469 L
s
.42589 .65469 m
.42849 .65417 L
s
.42849 .65417 m
.43125 .65356 L
s
.43125 .65356 m
.43375 .65295 L
s
.43375 .65295 m
.43507 .65261 L
s
.43507 .65261 m
.43649 .65223 L
s
.43649 .65223 m
.43779 .65187 L
s
.43779 .65187 m
.43899 .65153 L
s
.43899 .65153 m
.43956 .65136 L
s
.43956 .65136 m
.44018 .65118 L
s
.44018 .65118 m
.44077 .651 L
s
.44077 .651 m
.44132 .65084 L
s
.44132 .65084 m
.44196 .65064 L
s
.44196 .65064 m
.44263 .65043 L
s
.44263 .65043 m
.44321 .65025 L
s
.44321 .65025 m
.44384 .65005 L
s
.44384 .65005 m
.44452 .64983 L
s
.44452 .64983 m
.44524 .64959 L
s
.44524 .64959 m
.44655 .64915 L
s
.44655 .64915 m
.44788 .64869 L
s
.44788 .64869 m
.44913 .64826 L
s
.44913 .64826 m
.45148 .64741 L
s
.45148 .64741 m
.45429 .64636 L
s
.45429 .64636 m
.45688 .64534 L
s
.45688 .64534 m
.46275 .64293 L
s
.46275 .64293 m
.47306 .63831 L
s
.47306 .63831 m
.48445 .63271 L
s
.48445 .63271 m
.50682 .62053 L
s
.50682 .62053 m
.52846 .6076 L
s
.52846 .6076 m
.55156 .59295 L
s
.55156 .59295 m
.5739 .57823 L
s
.5739 .57823 m
.59546 .5637 L
s
.59546 .5637 m
.61847 .548 L
s
.61847 .548 m
.6407 .53279 L
s
.6407 .53279 m
.6644 .5166 L
s
.6644 .5166 m
.68733 .50108 L
s
.68733 .50108 m
.70947 .48625 L
s
.70947 .48625 m
.73312 .47063 L
s
.73312 .47063 m
.756 .45578 L
s
.756 .45578 m
.77811 .44169 L
s
.77811 .44169 m
.80176 .4269 L
s
.80176 .4269 m
.82465 .41288 L
s
.82465 .41288 m
.84874 .39844 L
s
.47496 .44371 m
.4989 .42177 L
s
.45246 .4654 m
.47496 .44371 L
s
.4989 .42177 m
.52194 .4017 L
s
.52194 .4017 m
.54645 .38135 L
s
.42899 .48923 m
.45246 .4654 L
s
.54645 .38135 m
.57012 .36262 L
s
.40452 .51548 m
.42899 .48923 L
s
.57012 .36262 m
.59294 .34534 L
s
.38139 .54171 m
.40452 .51548 L
s
.59294 .34534 m
.61732 .32765 L
s
.35717 .57077 m
.38139 .54171 L
s
.61732 .32765 m
.64088 .31125 L
s
.33178 .60308 m
.35717 .57077 L
s
.64088 .31125 m
.66605 .29441 L
s
.66605 .29441 m
.69044 .27872 L
s
.30762 .63573 m
.33178 .60308 L
s
.69044 .27872 m
.71404 .26405 L
s
.28214 .67223 m
.30762 .63573 L
s
.71404 .26405 m
.73931 .24887 L
s
.73931 .24887 m
.76256 .23534 L
s
.25781 .70923 m
.28214 .67223 L
s
.232 .75081 m
.25781 .70923 L
s
.20384 .79903 m
.232 .75081 L
s
.1773 .84732 m
.20384 .79903 L
s
.34449 .26031 m
.3688 .23879 L
s
.31909 .28488 m
.34449 .26031 L
s
.3688 .23879 m
.39211 .21968 L
s
.29498 .31063 m
.31909 .28488 L
s
.39211 .21968 m
.41691 .20071 L
s
.26954 .34099 m
.29498 .31063 L
s
.41691 .20071 m
.44082 .18354 L
s
.44082 .18354 m
.46631 .16624 L
s
.24248 .37773 m
.26954 .34099 L
s
.46631 .16624 m
.49096 .15036 L
s
.2161 .41916 m
.24248 .37773 L
s
.49096 .15036 m
.51479 .13567 L
s
.51479 .13567 m
.54029 .12057 L
s
.54029 .12057 m
.565 .10646 L
s
.1872 .47276 m
.2161 .41916 L
s
.565 .10646 m
.59145 .09185 L
s
.59145 .09185 m
.61713 .07809 L
s
.61713 .07809 m
.64203 .06508 L
s
.15651 .54179 m
.1872 .47276 L
s
.64203 .06508 m
.66621 .05273 L
s
.13816 .5904 m
.15651 .54179 L
s
.11983 .64537 m
.13816 .5904 L
s
.09767 .72114 m
.11983 .64537 L
s
.07986 .79116 m
.09767 .72114 L
s
.25 Mabswid
.67245 0 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.67245 0 m
.08846 .24555 L
s
.08846 .24555 m
.67245 0 L
s
.10087 .24033 m
.10595 .24556 L
s
[(0)] .09072 .22988 .97192 1 Mshowa
.22871 .18658 m
.23354 .19204 L
s
[(1)] .21906 .17566 .88455 1 Mshowa
.36358 .12987 m
.36813 .13557 L
s
[(2)] .3545 .11847 .79718 1 Mshowa
.50609 .06995 m
.51031 .07589 L
s
[(3)] .49765 .05807 .70982 1 Mshowa
.65689 .00654 m
.66074 .01273 L
s
[(4)] .64919 -0.00583 .62245 1 Mshowa
.125 Mabswid
.12591 .22981 m
.12892 .23297 L
s
.1512 .21917 m
.15419 .22236 L
s
.17676 .20842 m
.17972 .21164 L
s
.2026 .19756 m
.20553 .20081 L
s
.25511 .17548 m
.25797 .17879 L
s
.28179 .16426 m
.28462 .1676 L
s
.30875 .15292 m
.31155 .15628 L
s
.33602 .14146 m
.33878 .14485 L
s
.39145 .11815 m
.39414 .1216 L
s
.41963 .1063 m
.42229 .10978 L
s
.44813 .09432 m
.45074 .09783 L
s
.47695 .0822 m
.47952 .08574 L
s
.53556 .05756 m
.53805 .06115 L
s
.56537 .04502 m
.56782 .04865 L
s
.59553 .03235 m
.59793 .036 L
s
.62603 .01952 m
.62839 .0232 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.678571 0.0080766 0.97619 0.331141 MathSubStart
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0567234 1.16608 7.86589e-17 1.16608 [
[.5 1.098 -17 0 ]
[.5 1.098 17 9.8125 ]
[.09072 .22988 -5.91576 -9 ]
[.09072 .22988 .08424 0 ]
[.21906 .17566 -5.65366 -9 ]
[.21906 .17566 .34634 0 ]
[.3545 .11847 -5.39155 -9 ]
[.3545 .11847 .60845 0 ]
[.49765 .05807 -5.12945 -9 ]
[.49765 .05807 .87055 0 ]
[.64919 -0.00583 -4.86734 -9 ]
[.64919 -0.00583 1.13266 0 ]
[.07325 .26228 -6 -2.6177 ]
[.07325 .26228 0 6.3823 ]
[.05605 .36992 -18 -2.71327 ]
[.05605 .36992 0 6.28673 ]
[.03747 .48626 -18 -2.81735 ]
[.03747 .48626 0 6.18265 ]
[.01732 .6124 -18 -2.93114 ]
[.01732 .6124 0 6.06886 ]
[-0.0046 .74964 -18 -3.05605 ]
[-0.0046 .74964 0 5.94395 ]
[ 0 0 0 0 ]
[ 1 1.0855 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
gsave
.5 1.098 -78 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(b) show
75.000 11.250 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(=) show
87.000 11.250 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(4) show
93.000 11.250 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.25 Mabswid
[ ] 0 setdash
.08846 .24555 m
.67245 0 L
s
.10087 .24033 m
.10595 .24556 L
s
[(0)] .09072 .22988 .97192 1 Mshowa
.22871 .18658 m
.23354 .19204 L
s
[(1)] .21906 .17566 .88455 1 Mshowa
.36358 .12987 m
.36813 .13557 L
s
[(2)] .3545 .11847 .79718 1 Mshowa
.50609 .06995 m
.51031 .07589 L
s
[(3)] .49765 .05807 .70982 1 Mshowa
.65689 .00654 m
.66074 .01273 L
s
[(4)] .64919 -0.00583 .62245 1 Mshowa
.125 Mabswid
.12591 .22981 m
.12892 .23297 L
s
.1512 .21917 m
.15419 .22236 L
s
.17676 .20842 m
.17972 .21164 L
s
.2026 .19756 m
.20553 .20081 L
s
.25511 .17548 m
.25797 .17879 L
s
.28179 .16426 m
.28462 .1676 L
s
.30875 .15292 m
.31155 .15628 L
s
.33602 .14146 m
.33878 .14485 L
s
.39145 .11815 m
.39414 .1216 L
s
.41963 .1063 m
.42229 .10978 L
s
.44813 .09432 m
.45074 .09783 L
s
.47695 .0822 m
.47952 .08574 L
s
.53556 .05756 m
.53805 .06115 L
s
.56537 .04502 m
.56782 .04865 L
s
.59553 .03235 m
.59793 .036 L
s
.62603 .01952 m
.62839 .0232 L
s
.25 Mabswid
.08846 .24555 m
0 .80374 L
s
.0867 .25665 m
.09342 .25384 L
s
[(0)] .07325 .26228 1 -0.41829 Mshowa
.0696 .36454 m
.07637 .36185 L
s
[(0.1)] .05605 .36992 1 -0.39705 Mshowa
.05112 .48115 m
.05795 .4786 L
s
[(0.2)] .03747 .48626 1 -0.37392 Mshowa
.03108 .6076 m
.03796 .6052 L
s
[(0.3)] .01732 .6124 1 -0.34864 Mshowa
.00928 .74519 m
.01622 .74296 L
s
[(0.4)] -0.0046 .74964 1 -0.32088 Mshowa
.125 Mabswid
.08338 .27758 m
.08742 .27591 L
s
.08001 .29882 m
.08406 .29716 L
s
.0766 .32039 m
.08065 .31875 L
s
.07313 .34229 m
.07718 .34067 L
s
.06602 .38713 m
.07009 .38553 L
s
.06238 .41008 m
.06646 .4085 L
s
.05869 .43339 m
.06277 .43183 L
s
.05494 .45708 m
.05902 .45553 L
s
.04724 .50562 m
.05135 .5041 L
s
.0433 .53048 m
.04741 .52899 L
s
.0393 .55576 m
.04341 .55429 L
s
.03522 .58147 m
.03935 .58001 L
s
.02687 .63418 m
.03101 .63276 L
s
.02258 .66122 m
.02673 .65982 L
s
.01823 .68873 m
.02238 .68735 L
s
.01379 .71671 m
.01795 .71535 L
s
.00469 .77417 m
.00886 .77286 L
s
1e-05 .80367 m
.00419 .80238 L
s
.25 Mabswid
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.40037 1.0855 L
s
.40037 1.0855 m
.41799 .58158 L
s
.41799 .58158 m
.08846 .24555 L
s
.67245 0 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.67245 0 m
.08846 .24555 L
s
.41799 .58158 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.40037 1.0855 L
s
.40037 1.0855 m
.41799 .58158 L
s
0 0 m
1 0 L
1 1.0855 L
0 1.0855 L
closepath
clip
newpath
.5 Mabswid
.42216 .58164 m
.44003 .58521 L
s
.44003 .58521 m
.45981 .58829 L
s
.45981 .58829 m
.47865 .59044 L
s
.47865 .59044 m
.497 .59186 L
s
.497 .59186 m
.51678 .59271 L
s
.51678 .59271 m
.53605 .5929 L
s
.53605 .5929 m
.55677 .59248 L
s
.55677 .59248 m
.57696 .59148 L
s
.57696 .59148 m
.59658 .59 L
s
.59658 .59 m
.61767 .58789 L
s
.32951 .48698 m
.32943 .4966 L
s
.32943 .4966 m
.32971 .50019 L
s
.61767 .58789 m
.63818 .58537 L
s
.32971 .50019 m
.33009 .50333 L
s
.33009 .50333 m
.33049 .50576 L
s
.33049 .50576 m
.33212 .51263 L
s
.63818 .58537 m
.65808 .58252 L
s
.33212 .51263 m
.33404 .51813 L
s
.33404 .51813 m
.3362 .5229 L
s
.65808 .58252 m
.67946 .57903 L
s
.3362 .5229 m
.34504 .53565 L
s
.67946 .57903 m
.70021 .57527 L
s
.34504 .53565 m
.34996 .54044 L
s
.70021 .57527 m
.72247 .57086 L
s
.34996 .54044 m
.35526 .54458 L
s
.35526 .54458 m
.36495 .55027 L
s
.72247 .57086 m
.7441 .56622 L
s
.36495 .55027 m
.38353 .55693 L
s
.7441 .56622 m
.76506 .56142 L
s
.76506 .56142 m
.78755 .55596 L
s
.38353 .55693 m
.40381 .56028 L
s
.78755 .55596 m
.80938 .55039 L
s
.80938 .55039 m
.83275 .54415 L
s
.40381 .56028 m
.42369 .56101 L
s
.83275 .54415 m
.84455 .5409 L
s
.84455 .5409 m
.85545 .53784 L
s
.42369 .56101 m
.44516 .55981 L
s
.85545 .53784 m
.86681 .5346 L
s
.86681 .5346 m
.87745 .53151 L
s
.87745 .53151 m
.88825 .52833 L
s
.44516 .55981 m
.46613 .55715 L
s
.88825 .52833 m
.89399 .52662 L
s
.89399 .52662 m
.90015 .52477 L
s
.90015 .52477 m
.90569 .52309 L
s
.90569 .52309 m
.90883 .52214 L
s
.90883 .52214 m
.91173 .52126 L
s
.91173 .52126 m
.91426 .52048 L
s
.91426 .52048 m
.91572 .52004 L
s
.46613 .55715 m
.48653 .55346 L
s
.91572 .52004 m
.91706 .51963 L
s
.91706 .51963 m
.91847 .51919 L
s
.91847 .51919 m
.91921 .51896 L
s
.91921 .51896 m
.91998 .51873 L
s
.91998 .51873 m
.92066 .51852 L
s
.92066 .51852 m
.9213 .51832 L
s
.9213 .51832 m
.92199 .51811 L
s
.92199 .51811 m
.92273 .51788 L
s
.48653 .55346 m
.49712 .55119 L
s
.49712 .55119 m
.50846 .54853 L
s
.50846 .54853 m
.51933 .54578 L
s
.51933 .54578 m
.53114 .54259 L
s
.53114 .54259 m
.5367 .54102 L
s
.5367 .54102 m
.54259 .53931 L
s
.54259 .53931 m
.54813 .53767 L
s
.54813 .53767 m
.55318 .53613 L
s
.55318 .53613 m
.55843 .53451 L
s
.55843 .53451 m
.56132 .53361 L
s
.56132 .53361 m
.56406 .53274 L
s
.56406 .53274 m
.56659 .53193 L
s
.56659 .53193 m
.5678 .53154 L
s
.5678 .53154 m
.56894 .53118 L
s
.56894 .53118 m
.57016 .53078 L
s
.57016 .53078 m
.57081 .53057 L
s
.57081 .53057 m
.57152 .53034 L
s
.57152 .53034 m
.57221 .53012 L
s
.57221 .53012 m
.57294 .52988 L
s
.57294 .52988 m
.57357 .52967 L
s
.57357 .52967 m
.57426 .52945 L
s
.57426 .52945 m
.57499 .52921 L
s
.57499 .52921 m
.57567 .52898 L
s
.57567 .52898 m
.57602 .52887 L
s
.57602 .52887 m
.57641 .52874 L
s
.57641 .52874 m
.5772 .52848 L
s
.5772 .52848 m
.57864 .528 L
s
.57864 .528 m
.57999 .52755 L
s
.57999 .52755 m
.5825 .52671 L
s
.5825 .52671 m
.5852 .5258 L
s
.5852 .5258 m
.59133 .52372 L
s
.59133 .52372 m
.59694 .52178 L
s
.59694 .52178 m
.60765 .51801 L
s
.60765 .51801 m
.61936 .5138 L
s
.61936 .5138 m
.64248 .50521 L
s
.64248 .50521 m
.6649 .4966 L
s
.6649 .4966 m
.68891 .48713 L
s
.68891 .48713 m
.7122 .47771 L
s
.7122 .47771 m
.73477 .46842 L
s
.73477 .46842 m
.75895 .45832 L
s
.75895 .45832 m
.78239 .44839 L
s
.78239 .44839 m
.80509 .43869 L
s
.80509 .43869 m
.82942 .42821 L
s
.82942 .42821 m
.851 .41885 L
s
.19677 .65958 m
.21926 .6405 L
s
.21926 .6405 m
.24376 .62022 L
s
.24376 .62022 m
.26676 .60163 L
s
.26676 .60163 m
.28889 .58416 L
s
.28889 .58416 m
.31245 .56596 L
s
.31245 .56596 m
.33517 .54882 L
s
.33517 .54882 m
.35935 .53097 L
s
.35935 .53097 m
.3827 .51412 L
s
.3827 .51412 m
.40521 .4982 L
s
.40521 .4982 m
.42924 .48157 L
s
.42924 .48157 m
.45245 .46583 L
s
.45245 .46583 m
.47484 .45094 L
s
.47484 .45094 m
.49877 .43532 L
s
.49877 .43532 m
.52191 .42051 L
s
.52191 .42051 m
.54662 .40499 L
s
.54662 .40499 m
.57054 .39023 L
s
.57054 .39023 m
.59366 .37621 L
s
.59366 .37621 m
.6184 .36147 L
s
.6184 .36147 m
.64235 .34743 L
s
.64235 .34743 m
.66795 .33266 L
s
.66795 .33266 m
.69278 .31858 L
s
.69278 .31858 m
.71682 .30514 L
s
.71682 .30514 m
.74255 .29097 L
s
.74255 .29097 m
.76623 .27812 L
s
.34158 .3048 m
.36626 .28329 L
s
.31583 .32897 m
.34158 .3048 L
s
.29145 .35387 m
.31583 .32897 L
s
.36626 .28329 m
.38994 .26392 L
s
.26579 .38269 m
.29145 .35387 L
s
.38994 .26392 m
.41515 .24443 L
s
.41515 .24443 m
.43945 .22659 L
s
.23864 .4169 m
.26579 .38269 L
s
.43945 .22659 m
.46536 .20843 L
s
.46536 .20843 m
.49041 .19161 L
s
.21235 .45472 m
.23864 .4169 L
s
.49041 .19161 m
.51461 .17595 L
s
.51461 .17595 m
.5405 .15975 L
s
.18381 .50272 m
.21235 .45472 L
s
.5405 .15975 m
.56556 .14454 L
s
.56556 .14454 m
.59237 .12874 L
s
.1539 .56342 m
.18381 .50272 L
s
.59237 .12874 m
.61838 .1138 L
s
.61838 .1138 m
.64358 .09966 L
s
.64358 .09966 m
.66803 .08621 L
s
.13626 .60563 m
.1539 .56342 L
s
.11884 .653 m
.13626 .60563 L
s
.09811 .71782 m
.11884 .653 L
s
.07775 .79181 m
.09811 .71782 L
s
.25 Mabswid
.67245 0 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.67245 0 m
.08846 .24555 L
s
.08846 .24555 m
.67245 0 L
s
.10087 .24033 m
.10595 .24556 L
s
[(0)] .09072 .22988 .97192 1 Mshowa
.22871 .18658 m
.23354 .19204 L
s
[(1)] .21906 .17566 .88455 1 Mshowa
.36358 .12987 m
.36813 .13557 L
s
[(2)] .3545 .11847 .79718 1 Mshowa
.50609 .06995 m
.51031 .07589 L
s
[(3)] .49765 .05807 .70982 1 Mshowa
.65689 .00654 m
.66074 .01273 L
s
[(4)] .64919 -0.00583 .62245 1 Mshowa
.125 Mabswid
.12591 .22981 m
.12892 .23297 L
s
.1512 .21917 m
.15419 .22236 L
s
.17676 .20842 m
.17972 .21164 L
s
.2026 .19756 m
.20553 .20081 L
s
.25511 .17548 m
.25797 .17879 L
s
.28179 .16426 m
.28462 .1676 L
s
.30875 .15292 m
.31155 .15628 L
s
.33602 .14146 m
.33878 .14485 L
s
.39145 .11815 m
.39414 .1216 L
s
.41963 .1063 m
.42229 .10978 L
s
.44813 .09432 m
.45074 .09783 L
s
.47695 .0822 m
.47952 .08574 L
s
.53556 .05756 m
.53805 .06115 L
s
.56537 .04502 m
.56782 .04865 L
s
.59553 .03235 m
.59793 .036 L
s
.62603 .01952 m
.62839 .0232 L
s
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.0.5"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "GraphicsArray", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[7]= ",
 CellTags->"S5.0.5"]
}, Open  ]],

Cell[TextData[{
 "This initializes the ",
 StyleBox["Geometry", "MR"],
 " packages. "
}], "MathCaption",
 CellTags->{"S5.0.5", "5.10"}],

Cell["<<Geometry`", "Input",
 CellLabel->"In[8]:= ",
 CellTags->"S5.0.5"],

Cell["\<\
Here the regular polyhedra are plotted according to number of faces, number \
of edges, and volume when edges have unit length. \
\>", "MathCaption",
 CellTags->{"S5.0.5", "5.11"}],

Cell[CellGroupData[{

Cell["\<\
Apply[Show,
Join[
 Map[Polyhedron[#, {NumberOfFaces[#], NumberOfEdges[#],
   Volume[#]}, .7]&,
   {Tetrahedron, Cube, Octahedron, Dodecahedron,
    Icosahedron}],
 {Axes -> True, AxesLabel -> {\"# of faces\", \"# of edges\",
  \"volume\"},
  Ticks -> {{4, 6, 8, 12, 20}, {6, 12, 12, 30, 30},
         Automatic}}] ]\
\>", "Input",
 CellLabel->"In[9]:= ",
 CellTags->"S5.0.5"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .89244 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
4.97378e-17 1.06702 -0.036293 1.06702 [
[.06465 .19644 -5.98207 -9 ]
[.06465 .19644 .01793 0 ]
[.12224 .17396 -5.88664 -9 ]
[.12224 .17396 .11336 0 ]
[.18087 .15106 -5.79121 -9 ]
[.18087 .15106 .20879 0 ]
[.30142 .10401 -11.2007 -9 ]
[.30142 .10401 .79929 0 ]
[.55647 .0045 -10.4373 -9 ]
[.55647 .0045 1.56273 0 ]
[.25379 .05519 -59.8017 -9.9375 ]
[.25379 .05519 4.19829 0 ]
[.63656 .02375 0 -6.2262 ]
[.63656 .02375 6 2.7738 ]
[.733 .15769 0 -6.11692 ]
[.733 .15769 12 2.88308 ]
[.733 .15769 0 -6.11692 ]
[.733 .15769 12 2.88308 ]
[.97174 .48926 0 -5.85886 ]
[.97174 .48926 12 3.14114 ]
[.97174 .48926 0 -5.85886 ]
[.97174 .48926 12 3.14114 ]
[.88428 .25869 0 -6.64674 ]
[.88428 .25869 64 3.29076 ]
[.01856 .2457 -6 -2.76305 ]
[.01856 .2457 0 6.23695 ]
[.01154 .29873 -6 -2.79889 ]
[.01154 .29873 0 6.20111 ]
[.00433 .35325 -6 -2.83583 ]
[.00433 .35325 0 6.16417 ]
[-0.00309 .40933 -6 -2.87391 ]
[-0.00309 .40933 0 6.12609 ]
[-0.01073 .46704 -6 -2.91318 ]
[-0.01073 .46704 0 6.08682 ]
[-0.05774 .37282 -40 -3.08918 ]
[-0.05774 .37282 0 6.72332 ]
[ 0 0 0 0 ]
[ 1 .89244 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.03353 .22166 m
.60354 0 L
s
.07405 .2059 m
.07876 .21063 L
s
[(4)] .06465 .19644 .99402 1 Mshowa
.13149 .18357 m
.13611 .18837 L
s
[(6)] .12224 .17396 .96221 1 Mshowa
.18996 .16083 m
.1945 .16571 L
s
[(8)] .18087 .15106 .9304 1 Mshowa
.31016 .11409 m
.31452 .11913 L
s
[(12)] .30142 .10401 .86678 1 Mshowa
.5644 .01522 m
.56837 .02058 L
s
[(20)] .55647 .0045 .73955 1 Mshowa
gsave
.25379 .05519 -120.802 -13.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.9375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.375 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.375 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(#) show
75.000 11.375 moveto
(of) show
93.000 11.375 moveto
(faces) show
123.000 11.375 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.60354 0 m
.97416 .51419 L
s
.6241 .02853 m
.61788 .03092 L
s
[(6)] .63656 .02375 -1 .3836 Mshowa
.72045 .1622 m
.71417 .16445 L
s
[(12)] .733 .15769 -1 .35932 Mshowa
.72045 .1622 m
.71417 .16445 L
s
[(12)] .733 .15769 -1 .35932 Mshowa
.95898 .49312 m
.95259 .49505 L
s
[(30)] .97174 .48926 -1 .30197 Mshowa
.95898 .49312 m
.95259 .49505 L
s
[(30)] .97174 .48926 -1 .30197 Mshowa
gsave
.88428 .25869 -61 -10.6467 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.9375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.375 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.375 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(#) show
75.000 11.375 moveto
(of) show
93.000 11.375 moveto
(edges) show
123.000 11.375 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.03353 .22166 m
0 .47667 L
s
.031 .24089 m
.03722 .23849 L
s
[(0)] .01856 .2457 1 -0.38599 Mshowa
.02402 .29401 m
.03025 .29165 L
s
[(2)] .01154 .29873 1 -0.37802 Mshowa
.01683 .34862 m
.02309 .34631 L
s
[(4)] .00433 .35325 1 -0.36982 Mshowa
.00945 .4048 m
.01572 .40253 L
s
[(6)] -0.00309 .40933 1 -0.36135 Mshowa
.00185 .4626 m
.00814 .46038 L
s
[(8)] -0.01073 .46704 1 -0.35263 Mshowa
.125 Mabswid
.02927 .25404 m
.03301 .2526 L
s
.02753 .26727 m
.03127 .26584 L
s
.02578 .28059 m
.02952 .27917 L
s
.02224 .30752 m
.02598 .30611 L
s
.02045 .32113 m
.0242 .31972 L
s
.01865 .33483 m
.0224 .33343 L
s
.01501 .36252 m
.01876 .36114 L
s
.01317 .37651 m
.01693 .37514 L
s
.01132 .3906 m
.01508 .38924 L
s
.00757 .41909 m
.01134 .41774 L
s
.00568 .43349 m
.00944 .43215 L
s
.00377 .448 m
.00754 .44666 L
s
.03271 .22784 m
.03645 .22639 L
s
gsave
-0.05774 .37282 -101 -7.08918 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(volume) show
99.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.25 Mabswid
.03353 .22166 m
0 .47667 L
s
0 .47667 m
.47784 .89244 L
s
.47784 .89244 m
.48072 .66145 L
s
.48072 .66145 m
.03353 .22166 L
s
.60354 0 m
.97416 .51419 L
s
.97416 .51419 m
1 .75431 L
s
1 .75431 m
.60869 .26332 L
s
.60869 .26332 m
.60354 0 L
s
.03353 .22166 m
0 .47667 L
s
0 .47667 m
.60869 .26332 L
s
.60869 .26332 m
.60354 0 L
s
.60354 0 m
.03353 .22166 L
s
.48072 .66145 m
.97416 .51419 L
s
.97416 .51419 m
1 .75431 L
s
1 .75431 m
.47784 .89244 L
s
.47784 .89244 m
.48072 .66145 L
s
0 0 m
1 0 L
1 .89244 L
0 .89244 L
closepath
clip
newpath
.5 Mabswid
.759 .677 .771 r
.93319 .57998 m .93037 .55566 L .9103 .57341 L closepath p F P
0 g
s
.597 .559 .782 r
.95377 .56892 m .93037 .55566 L .93319 .57998 L closepath p F P
0 g
s
.797 .577 .603 r
.93319 .57998 m .9103 .57341 L .92122 .59769 L closepath p F P
0 g
s
.507 .364 .621 r
.95377 .56892 m .93319 .57998 L .94813 .59495 L closepath p F P
0 g
s
.633 .363 .491 r
.94813 .59495 m .93319 .57998 L .92122 .59769 L closepath p F P
0 g
s
.65 .758 .929 r
.69945 .76764 m .70667 .77517 L .72308 .77362 L p F P
0 g
s
.915 .776 .693 r
.70667 .77517 m .69945 .76764 L p .69353 .79392 L F P
0 g
s
.915 .776 .693 r
.69353 .79392 m .70303 .79135 L .70667 .77517 L p F P
0 g
s
.674 .525 .675 r
.70667 .77517 m .70303 .79135 L .71721 .79983 L p F P
0 g
s
.674 .525 .675 r
.72308 .77362 m .70667 .77517 L p .71721 .79983 L F P
0 g
s
.843 .961 .885 r
.9103 .57341 m .93037 .55566 L .91656 .55817 L closepath p F P
0 g
s
.914 .53 .115 r
.92122 .59769 m .9103 .57341 L .91085 .58431 L closepath p F P
0 g
s
0 0 .14 r
.9103 .57341 m .91656 .55817 L .91085 .58431 L closepath p F P
0 g
s
.259 .537 .921 r
.9436 .55536 m .93037 .55566 L .95377 .56892 L closepath p F P
0 g
s
.04 0 0 r
.91656 .55817 m .93037 .55566 L .9436 .55536 L closepath p F P
0 g
s
.761 .363 .299 r
.70303 .79135 m .69353 .79392 L p .71656 .80771 L F P
0 g
s
.761 .363 .299 r
.71656 .80771 m .71721 .79983 L .70303 .79135 L p F P
0 g
s
.65 .758 .929 r
.71146 .76138 m .69945 .76764 L p .72308 .77362 L F P
0 g
s
.65 .758 .929 r
.72308 .77362 m .72611 .76511 L .71146 .76138 L p F P
0 g
s
.674 .525 .675 r
.71721 .79983 m .72962 .78886 L .72308 .77362 L p F P
0 g
s
.22 .279 .712 r
.72308 .77362 m .72962 .78886 L .73675 .78988 L p F P
0 g
s
.22 .279 .712 r
.72611 .76511 m .72308 .77362 L p .73675 .78988 L F P
0 g
s
.271 0 .237 r
.71721 .79983 m .71656 .80771 L .72867 .80157 L p F P
0 g
s
.271 0 .237 r
.72962 .78886 m .71721 .79983 L p .72867 .80157 L F P
0 g
s
.271 0 .237 r
.72867 .80157 m .73675 .78988 L .72962 .78886 L p F P
0 g
s
.074 0 0 r
.9344 .59774 m .94813 .59495 L .92122 .59769 L closepath p F P
0 g
s
.241 .531 .919 r
.9344 .59774 m .92122 .59769 L .91085 .58431 L closepath p F P
0 g
s
0 0 .168 r
.95469 .57981 m .95377 .56892 L .94813 .59495 L closepath p F P
0 g
s
.904 .517 .086 r
.9436 .55536 m .95377 .56892 L .95469 .57981 L closepath p F P
0 g
s
.841 .966 .884 r
.9344 .59774 m .95469 .57981 L .94813 .59495 L closepath p F P
0 g
s
.257 0 .222 r
.69945 .76764 m .71146 .76138 L p .69825 .7802 L F P
0 g
s
.915 .776 .693 r
.69945 .76764 m .69128 .77922 L .69353 .79392 L p F P
0 g
s
.257 0 .222 r
.69825 .7802 m .69128 .77922 L .69945 .76764 L p F P
0 g
s
.761 .363 .299 r
.69353 .79392 m .70187 .80406 L .71656 .80771 L p F P
0 g
s
.206 .27 .709 r
.70187 .80406 m .69353 .79392 L .69128 .77922 L p F P
0 g
s
.22 .279 .712 r
.73675 .78988 m .73459 .77515 L .72611 .76511 L p F P
0 g
s
.76 .356 .288 r
.72611 .76511 m .73459 .77515 L .72514 .77767 L p F P
0 g
s
.76 .356 .288 r
.71146 .76138 m .72611 .76511 L p .72514 .77767 L F P
0 g
s
.647 .761 .932 r
.72867 .80157 m .71656 .80771 L .70187 .80406 L p F P
0 g
s
.206 .27 .709 r
.69128 .77922 m .69825 .7802 L p .70187 .80406 L F P
0 g
s
.918 .779 .692 r
.73459 .77515 m .73675 .78988 L .72867 .80157 L p F P
0 g
s
.76 .356 .288 r
.72514 .77767 m .71078 .76912 L .71146 .76138 L p F P
0 g
s
.257 0 .222 r
.71146 .76138 m .71078 .76912 L .69825 .7802 L p F P
0 g
s
.631 .359 .487 r
.91656 .55817 m .9436 .55536 L .93155 .57316 L closepath p F P
0 g
s
.503 .36 .619 r
.91085 .58431 m .91656 .55817 L .93155 .57316 L closepath p F P
0 g
s
.595 .558 .783 r
.9344 .59774 m .91085 .58431 L .93155 .57316 L closepath p F P
0 g
s
.798 .576 .601 r
.93155 .57316 m .9436 .55536 L .95469 .57981 L closepath p F P
0 g
s
.206 .27 .709 r
.69825 .7802 m .70483 .79562 L .70187 .80406 L p F P
0 g
s
.647 .761 .932 r
.70187 .80406 m .70483 .79562 L p .72867 .80157 L F P
0 g
s
.918 .779 .692 r
.72514 .77767 m .73459 .77515 L p .72867 .80157 L F P
0 g
s
.918 .779 .692 r
.72867 .80157 m .72146 .79407 L .72514 .77767 L p F P
0 g
s
.647 .761 .932 r
.70483 .79562 m .72146 .79407 L .72867 .80157 L p F P
0 g
s
.76 .679 .772 r
.9344 .59774 m .93155 .57316 L .95469 .57981 L closepath p F P
0 g
s
.674 .525 .674 r
.72146 .79407 m .70483 .79562 L .69825 .7802 L p F P
0 g
s
.674 .525 .674 r
.72514 .77767 m .72146 .79407 L p .69825 .7802 L F P
0 g
s
.674 .525 .674 r
.69825 .7802 m .71078 .76912 L .72514 .77767 L p F P
0 g
s
.661 .745 .912 r
.24247 .35274 m .26034 .37089 L .28813 .36109 L p F P
0 g
s
.953 .687 .496 r
.25856 .39667 m .26034 .37089 L .24247 .35274 L p F P
0 g
s
.527 .3 .513 r
.26034 .37089 m .25856 .39667 L .28652 .38692 L p F P
0 g
s
.527 .3 .513 r
.28652 .38692 m .28813 .36109 L .26034 .37089 L p F P
0 g
s
.661 .745 .912 r
.28813 .36109 m .2704 .34278 L .24247 .35274 L p F P
0 g
s
.955 .688 .49 r
.2704 .34278 m .28813 .36109 L .28652 .38692 L p F P
0 g
s
.953 .687 .496 r
.24247 .35274 m .24056 .3786 L .25856 .39667 L p F P
0 g
s
.66 .747 .914 r
.28652 .38692 m .25856 .39667 L .24056 .3786 L p F P
0 g
s
.755 .617 .706 r
.33951 .35433 m .32352 .31034 L .29393 .34593 L closepath p F P
0 g
s
.335 .375 .754 r
.35059 .32583 m .32352 .31034 L .33951 .35433 L closepath p F P
0 g
s
.605 .082 0 r
.32074 .36185 m .33951 .35433 L .29393 .34593 L closepath p F P
0 g
s
.879 .993 .778 r
.32074 .36185 m .35059 .32583 L .33951 .35433 L closepath p F P
0 g
s
.523 .295 .51 r
.24056 .3786 m .24247 .35274 L .2704 .34278 L p F P
0 g
s
.884 .991 .786 r
.32352 .31034 m .3045 .31723 L .29393 .34593 L closepath p F P
0 g
s
.595 .065 0 r
.35059 .32583 m .3045 .31723 L .32352 .31034 L closepath p F P
0 g
s
.325 .369 .753 r
.32074 .36185 m .29393 .34593 L .3045 .31723 L closepath p F P
0 g
s
.955 .688 .49 r
.28652 .38692 m .26866 .3687 L .2704 .34278 L p F P
0 g
s
.66 .747 .914 r
.24056 .3786 m .26866 .3687 L .28652 .38692 L p F P
0 g
s
.523 .295 .51 r
.2704 .34278 m .26866 .3687 L .24056 .3786 L p F P
0 g
s
.755 .617 .706 r
.32074 .36185 m .3045 .31723 L .35059 .32583 L closepath p F P
0 g
s
.662 .743 .91 r
.11955 .26463 m .11373 .21962 L .0574 .24127 L closepath p F P
0 g
s
.808 .416 .312 r
.09205 .28458 m .11955 .26463 L .0574 .24127 L closepath p F P
0 g
s
.979 .911 .661 r
.09205 .28458 m .11373 .21962 L .11955 .26463 L closepath p F P
0 g
s
.571 .417 .633 r
.09205 .28458 m .0574 .24127 L .11373 .21962 L closepath p F P
0 g
s
.25 Mabswid
.60354 0 m
.97416 .51419 L
s
.97416 .51419 m
1 .75431 L
s
1 .75431 m
.60869 .26332 L
s
.60869 .26332 m
.60354 0 L
s
.03353 .22166 m
0 .47667 L
s
0 .47667 m
.60869 .26332 L
s
.60869 .26332 m
.60354 0 L
s
.60354 0 m
.03353 .22166 L
s
.03353 .22166 m
.60354 0 L
s
.07405 .2059 m
.07876 .21063 L
s
[(4)] .06465 .19644 .99402 1 Mshowa
.13149 .18357 m
.13611 .18837 L
s
[(6)] .12224 .17396 .96221 1 Mshowa
.18996 .16083 m
.1945 .16571 L
s
[(8)] .18087 .15106 .9304 1 Mshowa
.31016 .11409 m
.31452 .11913 L
s
[(12)] .30142 .10401 .86678 1 Mshowa
.5644 .01522 m
.56837 .02058 L
s
[(20)] .55647 .0045 .73955 1 Mshowa
gsave
.25379 .05519 -120.802 -13.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.9375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.375 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.375 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(#) show
75.000 11.375 moveto
(of) show
93.000 11.375 moveto
(faces) show
123.000 11.375 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.0.5"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics3D", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[9]= ",
 CellTags->"S5.0.5"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Linear Algebra Packages", "Subsection",
 CellTags->{"S5.0.6", "6.1"}],

Cell[TextData[{
 "The ",
 StyleBox["LinearAlgebra", "MR"],
 " portion of the standard add\[Hyphen]on packages provide functions for \
producing orthonormal vectors, solving tridiagonal matrix equations, \
computing the LU factorization or Cholesky decomposition of a matrix, and \
other sorts of matrix manipulation. "
}], "Text",
 CellTags->{"S5.0.6", "6.2"}],

Cell[TextData[{
 "Fast transform algorithms can be expressed as sparse matrix factorizations. \
This example shows why the fast Fourier transform (FFT) is faster than the \
discrete Fourier transform (DFT). ",
 StyleBox["BlockMatrix", "MR"],
 " from the ",
 StyleBox["MatrixManipulation", "MR"],
 " package is used to demonstrate how the DFT matrix factors into smaller \
blocks. "
}], "Text",
 CellTags->{"S5.0.6", "6.3"}],

Cell[TextData[{
 "The discrete Fourier transform of the sequence ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    SubscriptBox[
     StyleBox["x",
      "TI"], 
     StyleBox["j",
      "TI"]], "}"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is defined by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     StyleBox["y",
      "TI"], 
     StyleBox["k",
      "TI"]], "=", 
    UnderoverscriptBox["\[Sum]", 
     RowBox[{
      StyleBox["j",
       "TI"], "=", "0"}], 
     RowBox[{
      StyleBox["n",
       "TI"], "-", "1"}],
     LimitsPositioning->True], 
    SubsuperscriptBox["\[Omega]", 
     StyleBox["n",
      "TI"], 
     StyleBox[
      RowBox[{"k", "j"}],
      "TI"]], 
    SubscriptBox[
     StyleBox["x",
      "TI"], 
     StyleBox["j",
      "TI"]]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " where ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Omega]", 
     StyleBox["n",
      "TI"]], "=", 
    SuperscriptBox[
     StyleBox["e",
      "TI"], 
     FractionBox[
      RowBox[{"2", "\[Pi]", 
       StyleBox["i",
        "TI"]}], 
      StyleBox["n",
       "TI"]]]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", or in matrix notation, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["y",
     "TI"], "=", 
    SubscriptBox[
     StyleBox["F",
      "TI"], 
     StyleBox["n",
      "TI"]], 
    StyleBox["x",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". The essential idea of the FFT is to find an efficient factorization of \
the matrix ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["F",
     "TI"], 
    StyleBox["n",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "Text",
 CellTags->{"S5.0.6", "6.4"}],

Cell["\<\
This initializes the linear algebra packages so that they load as needed. \
\>", "MathCaption",
 CellTags->{"S5.0.6", "6.5"}],

Cell["<<LinearAlgebra`", "Input",
 CellLabel->"In[10]:= ",
 CellTags->"S5.0.6"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["F",
     "TI"], "4"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is the DFT matrix transforming the input sequence ",
 Cell[BoxData[
  FormBox[
   StyleBox["x",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " into the output sequence ",
 Cell[BoxData[
  FormBox[
   StyleBox["y",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " when the sequence length is 4. "
}], "MathCaption",
 CellTags->{"S5.0.6", "6.6"}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{
   SubscriptBox["F", "4"], "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     SubsuperscriptBox["\[Omega]", "4", 
      RowBox[{"j", "k"}]], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "0", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "3"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[11]:= ",
 CellTags->"S5.0.6"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "1", "1", "1"},
     {"1", 
      SubscriptBox["\[Omega]", "4"], 
      SubsuperscriptBox["\[Omega]", "4", "2"], 
      SubsuperscriptBox["\[Omega]", "4", "3"]},
     {"1", 
      SubsuperscriptBox["\[Omega]", "4", "2"], 
      SubsuperscriptBox["\[Omega]", "4", "4"], 
      SubsuperscriptBox["\[Omega]", "4", "6"]},
     {"1", 
      SubsuperscriptBox["\[Omega]", "4", "3"], 
      SubsuperscriptBox["\[Omega]", "4", "6"], 
      SubsuperscriptBox["\[Omega]", "4", "9"]}
     }], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabel->"Out[11]//MatrixForm= ",
 CellTags->"S5.0.6"]
}, Open  ]],

Cell[TextData[{
 "Define the block matrix ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["P",
     "TI"], "4"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " in terms of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["F",
     "TI"], "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and the ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", "\[Cross]", "2"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " diagonal matrix ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[CapitalOmega]", "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". This factorization can be related to ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["F",
     "TI"], "4"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.0.6", "6.7"}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{
   SubscriptBox["P", "4"], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["F", "2"], ",", 
       RowBox[{
        SubscriptBox["\[CapitalOmega]", "2"], ".", 
        SubscriptBox["F", "2"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["F", "2"], ",", 
       RowBox[{"-", 
        RowBox[{
         SubscriptBox["\[CapitalOmega]", "2"], ".", 
         SubscriptBox["F", "2"]}]}]}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[12]:= ",
 CellTags->"S5.0.6"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      SubscriptBox["F", "2"], 
      RowBox[{
       SubscriptBox["\[CapitalOmega]", "2"], ".", 
       SubscriptBox["F", "2"]}]},
     {
      SubscriptBox["F", "2"], 
      RowBox[{"-", 
       RowBox[{
        SubscriptBox["\[CapitalOmega]", "2"], ".", 
        SubscriptBox["F", "2"]}]}]}
     }], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabel->"Out[12]//MatrixForm= ",
 CellTags->"S5.0.6"]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica", "TI"],
 "\[CloseCurlyQuote]s typeset output gives a clear depiction of the block \
structure of\[NonBreakingSpace]",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["P",
     "TI"], "4"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.0.6", "6.8"}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[CapitalOmega]", "2"], "=", 
   RowBox[{"DiagonalMatrix", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      SubscriptBox["\[Omega]", "4"]}], "}"}], "]"}]}], ";", 
  RowBox[{
   SubscriptBox["F", "2"], "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     SubsuperscriptBox["\[Omega]", "2", 
      RowBox[{"j", "k"}]], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "1"}], "}"}]}], "]"}]}], ";", 
  RowBox[{"MatrixForm", "[", 
   SubscriptBox["P", "4"], "]"}]}]], "Input",
 CellLabel->"In[13]:= ",
 CellTags->"S5.0.6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"1", "1"},
         {"1", 
          SubscriptBox["\[Omega]", "2"]}
         }], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"1", "1"},
         {
          SubscriptBox["\[Omega]", "4"], 
          RowBox[{
           SubscriptBox["\[Omega]", "2"], " ", 
           SubscriptBox["\[Omega]", "4"]}]}
         }], "\[NoBreak]", ")"}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"1", "1"},
         {"1", 
          SubscriptBox["\[Omega]", "2"]}
         }], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          RowBox[{"-", "1"}], 
          RowBox[{"-", "1"}]},
         {
          RowBox[{"-", 
           SubscriptBox["\[Omega]", "4"]}], 
          RowBox[{
           RowBox[{"-", 
            SubscriptBox["\[Omega]", "2"]}], " ", 
           SubscriptBox["\[Omega]", "4"]}]}
         }], "\[NoBreak]", ")"}]}
     }], "\[NoBreak]", ")"}],
  MatrixForm[{{{{1, 1}, {1, 
       Subscript[\[Omega], 2]}}, {{1, 1}, {
       Subscript[\[Omega], 4], Subscript[\[Omega], 2] 
       Subscript[\[Omega], 4]}}}, {{{1, 1}, {1, 
       Subscript[\[Omega], 2]}}, {{-1, -1}, {-
       Subscript[\[Omega], 4], (-Subscript[\[Omega], 2]) 
       Subscript[\[Omega], 4]}}}}]]], "Output",
 CellLabel->"Out[13]//MatrixForm= ",
 CellTags->"S5.0.6"]
}, Open  ]],

Cell[TextData[{
 "Define ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["I",
     "TI"], "4"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " to be the ",
 Cell[BoxData[
  FormBox[
   RowBox[{"4", "\[Cross]", "4"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " identity matrix and let ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[CapitalPi]", "4"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " be a permutation matrix such that even and odd columns are grouped \
together. The operation represented by the permutation matrix is referred to \
as shuffling or twiddling. "
}], "MathCaption",
 CellTags->{"S5.0.6", "6.9"}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["I", "4"], "=", 
   RowBox[{"IdentityMatrix", "[", "4", "]"}]}], ";", 
  RowBox[{"MatrixForm", "[", 
   RowBox[{
    SubscriptBox["\[CapitalPi]", "4"], "=", 
    RowBox[{
     SubscriptBox["I", "4"], "\[LeftDoubleBracket]", 
     RowBox[{"{", 
      RowBox[{"1", ",", "3", ",", "2", ",", "4"}], "}"}], 
     "\[RightDoubleBracket]"}]}], "]"}]}]], "Input",
 CellLabel->"In[14]:= ",
 CellTags->"S5.0.6"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", "0", "0"},
     {"0", "0", "1", "0"},
     {"0", "1", "0", "0"},
     {"0", "0", "0", "1"}
     }], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabel->"Out[14]//MatrixForm= ",
 CellTags->"S5.0.6"]
}, Open  ]],

Cell[TextData[{
 StyleBox["BlockMatrix", "MR"],
 " converts ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["P",
     "TI"], "4"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", a matrix of submatrices, into a single matrix. This equates the result of \
applying the DFT to the permutation matrix with the factorization represented \
by ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["P",
     "TI"], "4"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.0.6", "6.10"}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"MatrixForm", "[", 
   RowBox[{
    SubscriptBox["F", "4"], ".", 
    SubscriptBox["\[CapitalPi]", "4"]}], "]"}], "==", 
  RowBox[{"MatrixForm", "[", 
   RowBox[{"BlockMatrix", "[", 
    SubscriptBox["P", "4"], "]"}], "]"}]}]], "Input",
 CellLabel->"In[15]:= ",
 CellTags->"S5.0.6"],

Cell[BoxData[
 RowBox[{
  TagBox[
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"1", "1", "1", "1"},
      {"1", 
       SubsuperscriptBox["\[Omega]", "4", "2"], 
       SubscriptBox["\[Omega]", "4"], 
       SubsuperscriptBox["\[Omega]", "4", "3"]},
      {"1", 
       SubsuperscriptBox["\[Omega]", "4", "4"], 
       SubsuperscriptBox["\[Omega]", "4", "2"], 
       SubsuperscriptBox["\[Omega]", "4", "6"]},
      {"1", 
       SubsuperscriptBox["\[Omega]", "4", "6"], 
       SubsuperscriptBox["\[Omega]", "4", "3"], 
       SubsuperscriptBox["\[Omega]", "4", "9"]}
      }], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]], "\[Equal]", 
  TagBox[
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"1", "1", "1", "1"},
      {"1", 
       SubscriptBox["\[Omega]", "2"], 
       SubscriptBox["\[Omega]", "4"], 
       RowBox[{
        SubscriptBox["\[Omega]", "2"], " ", 
        SubscriptBox["\[Omega]", "4"]}]},
      {"1", "1", 
       RowBox[{"-", "1"}], 
       RowBox[{"-", "1"}]},
      {"1", 
       SubscriptBox["\[Omega]", "2"], 
       RowBox[{"-", 
        SubscriptBox["\[Omega]", "4"]}], 
       RowBox[{
        RowBox[{"-", 
         SubscriptBox["\[Omega]", "2"]}], " ", 
        SubscriptBox["\[Omega]", "4"]}]}
      }], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]]}]], "Output",
 CellLabel->"Out[15]= ",
 CellTags->"S5.0.6"]
}, Open  ]],

Cell[TextData[{
 "Substituting the definition of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Omega]", 
    StyleBox["n",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " verifies that the factorization ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["P",
     "TI"], "4"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is equivalent to the DFT matrix ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["F",
     "TI"], "4"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " applied to the permutation matrix ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[CapitalPi]", "4"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.0.6", "6.11"}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{
   SubscriptBox["\[Omega]", "n_"], "\[RuleDelayed]", 
   SuperscriptBox["E", 
    FractionBox[
     RowBox[{"2", "\[Pi]", "I"}], "n"]]}]}]], "Input",
 CellLabel->"In[16]:= ",
 CellTags->"S5.0.6"],

Cell[BoxData["True"], "Output",
 CellLabel->"Out[16]= ",
 CellTags->"S5.0.6"]
}, Open  ]],

Cell[TextData[{
 "Since the inverse of the permutation matrix is its transpose, the DFT \
matrix ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["F",
     "TI"], 
    StyleBox["n",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " may be written as the product of two block matrices and a permutation \
matrix "
}], "Text",
 CellTags->{"S5.0.6", "6.12"}],

Cell["", "Text",
 CellTags->{"S5.0.6", "6.13"}],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox[
    StyleBox["F",
     "TI"], 
    StyleBox["n",
     "TI"]], "=", 
   SubscriptBox[
    StyleBox["P",
     "TI"], 
    StyleBox["n",
     "TI"]], "\[CenterDot]", 
   SubsuperscriptBox["\[CapitalPi]", 
    StyleBox["n",
     "TI"], 
    StyleBox["T",
     "TI"]], "=", 
   RowBox[{"(", 
    RowBox[{"\[Null]", " ", Cell[BoxData[
      FormBox[GridBox[{
         {Cell[TextData[{
           StyleBox[" ",
            UnderoverscriptBoxOptions->{LimitsPositioning->True},
            GridBoxOptions->{ColumnWidths->Automatic}],
           StyleBox[Cell[BoxData[
            FormBox[
             StyleBox[
              SubscriptBox[
               StyleBox["I",
                "TI"], 
               StyleBox["m",
                "TI"]],
              "DisplayFormula"], TraditionalForm]],
            UnderoverscriptBoxOptions->{LimitsPositioning->True},
            GridBoxOptions->{RowLines->False,
            RowSpacings->0.4}],
            UnderoverscriptBoxOptions->{LimitsPositioning->True},
            GridBoxOptions->{ColumnWidths->Automatic}],
           StyleBox[" ",
            UnderoverscriptBoxOptions->{LimitsPositioning->True},
            GridBoxOptions->{ColumnWidths->Automatic}]
          }],
           UnderoverscriptBoxOptions->{LimitsPositioning->True},
           GridBoxOptions->{ColumnWidths->Automatic}], Cell[TextData[{
           StyleBox["   ",
            UnderoverscriptBoxOptions->{LimitsPositioning->True},
            GridBoxOptions->{ColumnWidths->Automatic}],
           StyleBox[Cell[BoxData[
            FormBox[
             StyleBox[
              SubscriptBox["\[CapitalOmega]", 
               StyleBox["m",
                "TI"]],
              "DisplayFormula"], TraditionalForm]],
            UnderoverscriptBoxOptions->{LimitsPositioning->True},
            GridBoxOptions->{RowLines->False,
            RowSpacings->0.4}],
            UnderoverscriptBoxOptions->{LimitsPositioning->True},
            GridBoxOptions->{ColumnWidths->Automatic}],
           StyleBox[" ",
            UnderoverscriptBoxOptions->{LimitsPositioning->True},
            GridBoxOptions->{ColumnWidths->Automatic}]
          }],
           UnderoverscriptBoxOptions->{LimitsPositioning->True},
           GridBoxOptions->{ColumnWidths->Automatic}]},
         {Cell[TextData[{
           StyleBox[" ",
            UnderoverscriptBoxOptions->{LimitsPositioning->True},
            GridBoxOptions->{ColumnWidths->Automatic}],
           StyleBox[Cell[BoxData[
            FormBox[
             StyleBox[
              SubscriptBox[
               StyleBox["I",
                "TI"], 
               StyleBox["m",
                "TI"]],
              "DisplayFormula"], TraditionalForm]],
            UnderoverscriptBoxOptions->{LimitsPositioning->True},
            GridBoxOptions->{RowLines->False,
            RowSpacings->0.4}],
            UnderoverscriptBoxOptions->{LimitsPositioning->True},
            GridBoxOptions->{ColumnWidths->Automatic}],
           StyleBox[" ",
            UnderoverscriptBoxOptions->{LimitsPositioning->True},
            GridBoxOptions->{ColumnWidths->Automatic}]
          }],
           UnderoverscriptBoxOptions->{LimitsPositioning->True},
           GridBoxOptions->{ColumnWidths->Automatic}], Cell[TextData[{
           StyleBox["   ",
            UnderoverscriptBoxOptions->{LimitsPositioning->True},
            GridBoxOptions->{ColumnWidths->Automatic}],
           StyleBox[Cell[BoxData[
            FormBox[
             StyleBox[
              RowBox[{"-", 
               SubscriptBox["\[CapitalOmega]", 
                StyleBox["m",
                 "TI"]]}],
              "DisplayFormula"], TraditionalForm]],
            UnderoverscriptBoxOptions->{LimitsPositioning->True},
            GridBoxOptions->{RowLines->False,
            RowSpacings->0.4}],
            UnderoverscriptBoxOptions->{LimitsPositioning->True},
            GridBoxOptions->{ColumnWidths->Automatic}],
           StyleBox[" ",
            UnderoverscriptBoxOptions->{LimitsPositioning->True},
            GridBoxOptions->{ColumnWidths->Automatic}]
          }],
           UnderoverscriptBoxOptions->{LimitsPositioning->True},
           GridBoxOptions->{ColumnWidths->Automatic}]}
         },
        ColumnAlignments->{Right, Left}], TraditionalForm]],
      UnderoverscriptBoxOptions->{LimitsPositioning->True},
      GridBoxOptions->{ColumnWidths->Automatic}], " "}], ")"}], 
   "\[CenterDot]", 
   RowBox[{"(", 
    RowBox[{"\[Null]", " ", Cell[BoxData[
      FormBox[GridBox[{
         {Cell[TextData[{
           StyleBox[" ",
            UnderoverscriptBoxOptions->{LimitsPositioning->True},
            GridBoxOptions->{ColumnWidths->Automatic}],
           StyleBox[Cell[BoxData[
            FormBox[
             StyleBox[
              SubscriptBox[
               StyleBox["F",
                "TI"], 
               StyleBox["m",
                "TI"]],
              "DisplayFormula"], TraditionalForm]],
            UnderoverscriptBoxOptions->{LimitsPositioning->True},
            GridBoxOptions->{RowLines->False,
            RowSpacings->0.4}],
            UnderoverscriptBoxOptions->{LimitsPositioning->True},
            GridBoxOptions->{ColumnWidths->Automatic}],
           StyleBox[" ",
            UnderoverscriptBoxOptions->{LimitsPositioning->True},
            GridBoxOptions->{ColumnWidths->Automatic}]
          }],
           UnderoverscriptBoxOptions->{LimitsPositioning->True},
           GridBoxOptions->{ColumnWidths->Automatic}], Cell[TextData[{
           StyleBox["   ",
            UnderoverscriptBoxOptions->{LimitsPositioning->True},
            GridBoxOptions->{ColumnWidths->Automatic}],
           StyleBox[Cell[BoxData[
            FormBox[
             StyleBox[
              SubscriptBox["0", 
               StyleBox["m",
                "TI"]],
              "DisplayFormula"], TraditionalForm]],
            UnderoverscriptBoxOptions->{LimitsPositioning->True},
            GridBoxOptions->{RowLines->False,
            RowSpacings->0.4}],
            UnderoverscriptBoxOptions->{LimitsPositioning->True},
            GridBoxOptions->{ColumnWidths->Automatic}],
           StyleBox[" ",
            UnderoverscriptBoxOptions->{LimitsPositioning->True},
            GridBoxOptions->{ColumnWidths->Automatic}]
          }],
           UnderoverscriptBoxOptions->{LimitsPositioning->True},
           GridBoxOptions->{ColumnWidths->Automatic}]},
         {Cell[TextData[{
           StyleBox[" ",
            UnderoverscriptBoxOptions->{LimitsPositioning->True},
            GridBoxOptions->{ColumnWidths->Automatic}],
           StyleBox[Cell[BoxData[
            FormBox[
             StyleBox[
              SubscriptBox["0", 
               StyleBox["m",
                "TI"]],
              "DisplayFormula"], TraditionalForm]],
            UnderoverscriptBoxOptions->{LimitsPositioning->True},
            GridBoxOptions->{RowLines->False,
            RowSpacings->0.4}],
            UnderoverscriptBoxOptions->{LimitsPositioning->True},
            GridBoxOptions->{ColumnWidths->Automatic}],
           StyleBox[" ",
            UnderoverscriptBoxOptions->{LimitsPositioning->True},
            GridBoxOptions->{ColumnWidths->Automatic}]
          }],
           UnderoverscriptBoxOptions->{LimitsPositioning->True},
           GridBoxOptions->{ColumnWidths->Automatic}], Cell[TextData[{
           StyleBox["   ",
            UnderoverscriptBoxOptions->{LimitsPositioning->True},
            GridBoxOptions->{ColumnWidths->Automatic}],
           StyleBox[Cell[BoxData[
            FormBox[
             StyleBox[
              SubscriptBox[
               StyleBox["F",
                "TI"], 
               StyleBox["m",
                "TI"]],
              "DisplayFormula"], TraditionalForm]],
            UnderoverscriptBoxOptions->{LimitsPositioning->True},
            GridBoxOptions->{RowLines->False,
            RowSpacings->0.4}],
            UnderoverscriptBoxOptions->{LimitsPositioning->True},
            GridBoxOptions->{ColumnWidths->Automatic}],
           StyleBox[" ",
            UnderoverscriptBoxOptions->{LimitsPositioning->True},
            GridBoxOptions->{ColumnWidths->Automatic}]
          }],
           UnderoverscriptBoxOptions->{LimitsPositioning->True},
           GridBoxOptions->{ColumnWidths->Automatic}]}
         },
        ColumnAlignments->{Right, Left}], TraditionalForm]],
      UnderoverscriptBoxOptions->{LimitsPositioning->True},
      GridBoxOptions->{ColumnWidths->Automatic}], " "}], ")"}], 
   "\[CenterDot]", 
   SubsuperscriptBox["\[CapitalPi]", 
    StyleBox["n",
     "TI"], 
    StyleBox["T",
     "TI"]]}], TraditionalForm]], "DisplayFormula",
 UnderoverscriptBoxOptions->{LimitsPositioning->True},
 GridBoxOptions->{ColumnWidths->Automatic},
 CellTags->{"S5.0.6", "6.14"}],

Cell[TextData[{
 "where ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["0", 
    StyleBox["m",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " denotes the ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["m",
     "TI"], "\[Cross]", 
    StyleBox["m",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " zero matrix. Thus, the DFT can be performed using two smaller DFTs, which \
are combined with a few multiplies and shuffling. This decomposition of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["F",
     "TI"], 
    StyleBox["n",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " into ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["F",
     "TI"], 
    StyleBox["m",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", where ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["m",
     "TI"], "=", 
    FractionBox[
     StyleBox["n",
      "TI"], "2"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", can be done ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["log", "2"], 
    StyleBox["n",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " times. The FFT takes advantage of this decomposition, leading to the ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["n",
     "TI"], 
    SubscriptBox["log", "2"], 
    StyleBox["n",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " time complexity of the FFT versus the ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["n",
     "TI"], "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " time complexity of the DFT. "
}], "Text",
 CellTags->{"S5.0.6", "6.15"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Miscellaneous Packages", "Subsection",
 CellTags->{"S5.0.7", "7.1"}],

Cell[TextData[{
 "The packages grouped under ",
 StyleBox["Miscellaneous", "MR"],
 " offer a diverse set of functions that are not easily categorized. There \
are functions for exploring the audio capabilities of ",
 StyleBox["Mathematica", "TI"],
 " via waveform modulation and musical scales. Other functions provide \
calendar dates, chemical element data, physical constants, unit conversions, \
geodetic measurements, and world plots. The package ",
 StyleBox["RealOnly", "MR"],
 " is useful for algebra students who have not yet encountered complex \
numbers. "
}], "Text",
 CellTags->{"S5.0.7", "7.2"}],

Cell["\<\
This loads a package for converting between systems of units. \
\>", "MathCaption",
 CellTags->{"S5.0.7", "7.3"}],

Cell["<<Miscellaneous`Units`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.0.7"],

Cell[TextData[{
 "Consider a particle with uniform acceleration of 5.00 cm/sec",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " for an interval of ",
 Cell[BoxData[
  FormBox[
   FractionBox["1", "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " hr, with an initial speed of 10.0 ft/sec. This gives the final speed in \
feet per second. "
}], "MathCaption",
 CellTags->{"S5.0.7", "7.4"}],

Cell[CellGroupData[{

Cell["\<\
Convert[10.0 Feet/Second + 5.00 Centi Meter/Second^2 1/2 Hour,
         Feet/Second]\
\>", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.0.7"],

Cell[BoxData[
 FractionBox[
  RowBox[{"305.2755905511811`", " ", "Feet"}], "Second"]], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.0.7"]
}, Open  ]],

Cell[TextData[{
 "The ",
 StyleBox["Music", "MR"],
 " package defines a set of equal\[Hyphen]tempered pitch/frequency \
equivalents. "
}], "MathCaption",
 CellTags->{"S5.0.7", "7.5"}],

Cell["<<Miscellaneous`Music`", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.0.7"],

Cell["You can use these definitions to construct a minor chord. ", \
"MathCaption",
 CellTags->{"S5.0.7", "7.6"}],

Cell[CellGroupData[{

Cell["\<\
Play[Sin[2 Pi F3 t] + Sin[2 Pi Aflat3 t] + Sin[2 Pi C4 t],
     {t, 0, .5}]\
\>", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.0.7"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.0147151 0.588604 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sampled sound
1 string
8192 4096 8
{ currentfile 1 index readhexstring pop }
 false 1 sampledsound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% End of sampled sound
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.0.7"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Sound", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.0.7"]
}, Open  ]],

Cell[TextData[{
 "The ",
 StyleBox["WorldPlot", "MR"],
 " package can be used to make maps of the continents. "
}], "MathCaption",
 CellTags->{"S5.0.7", "7.7"}],

Cell["<<Miscellaneous`WorldPlot`", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.0.7"],

Cell["Here is a plot of Oceania. ", "MathCaption",
 CellTags->{"S5.0.7", "7.8"}],

Cell[CellGroupData[{

Cell["WorldPlot[Oceania]", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.0.7"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .66667 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.928571 0.000176367 0.544974 0.000176367 [
[ 0 0 0 0 ]
[ 1 .66667 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .66667 L
0 .66667 L
closepath
clip
newpath
0 g
.001 w
[ ] 0 setdash
.02381 .01587 m
.02381 .0254 L
.02381 .03492 L
.02381 .04444 L
.02381 .05397 L
.02381 .06349 L
.02381 .07302 L
.02381 .08254 L
.02381 .09206 L
.02381 .10159 L
.02381 .11111 L
.02381 .12063 L
.02381 .13016 L
.02381 .13968 L
.02381 .14921 L
.02381 .15873 L
.02381 .16825 L
.02381 .17778 L
.02381 .1873 L
.02381 .19683 L
.02381 .20635 L
.02381 .21587 L
.02381 .2254 L
.02381 .23492 L
.02381 .24444 L
.02381 .25397 L
.02381 .26349 L
.02381 .27302 L
.02381 .28254 L
.02381 .29206 L
.02381 .30159 L
.02381 .31111 L
.02381 .32063 L
.02381 .33016 L
.02381 .33968 L
.02381 .34921 L
.02381 .35873 L
.02381 .36825 L
.02381 .37778 L
.02381 .3873 L
.02381 .39683 L
.02381 .40635 L
.02381 .41587 L
.02381 .4254 L
.02381 .43492 L
.02381 .44444 L
.02381 .45397 L
.02381 .46349 L
.02381 .47302 L
.02381 .48254 L
Mistroke
.02381 .49206 L
.02381 .50159 L
.02381 .51111 L
.02381 .52063 L
.02381 .53016 L
.02381 .53968 L
.02381 .54921 L
.02381 .55873 L
.02381 .56825 L
.02381 .57778 L
.02381 .5873 L
.02381 .59683 L
.02381 .60635 L
.02381 .61587 L
.02381 .6254 L
.02381 .63492 L
.02381 .64444 L
.02381 .65079 L
Mfstroke
.34127 .01587 m
.34127 .0254 L
.34127 .03492 L
.34127 .04444 L
.34127 .05397 L
.34127 .06349 L
.34127 .07302 L
.34127 .08254 L
.34127 .09206 L
.34127 .10159 L
.34127 .11111 L
.34127 .12063 L
.34127 .13016 L
.34127 .13968 L
.34127 .14921 L
.34127 .15873 L
.34127 .16825 L
.34127 .17778 L
.34127 .1873 L
.34127 .19683 L
.34127 .20635 L
.34127 .21587 L
.34127 .2254 L
.34127 .23492 L
.34127 .24444 L
.34127 .25397 L
.34127 .26349 L
.34127 .27302 L
.34127 .28254 L
.34127 .29206 L
.34127 .30159 L
.34127 .31111 L
.34127 .32063 L
.34127 .33016 L
.34127 .33968 L
.34127 .34921 L
.34127 .35873 L
.34127 .36825 L
.34127 .37778 L
.34127 .3873 L
.34127 .39683 L
.34127 .40635 L
.34127 .41587 L
.34127 .4254 L
.34127 .43492 L
.34127 .44444 L
.34127 .45397 L
.34127 .46349 L
.34127 .47302 L
.34127 .48254 L
Mistroke
.34127 .49206 L
.34127 .50159 L
.34127 .51111 L
.34127 .52063 L
.34127 .53016 L
.34127 .53968 L
.34127 .54921 L
.34127 .55873 L
.34127 .56825 L
.34127 .57778 L
.34127 .5873 L
.34127 .59683 L
.34127 .60635 L
.34127 .61587 L
.34127 .6254 L
.34127 .63492 L
.34127 .64444 L
.34127 .65079 L
Mfstroke
.65873 .01587 m
.65873 .0254 L
.65873 .03492 L
.65873 .04444 L
.65873 .05397 L
.65873 .06349 L
.65873 .07302 L
.65873 .08254 L
.65873 .09206 L
.65873 .10159 L
.65873 .11111 L
.65873 .12063 L
.65873 .13016 L
.65873 .13968 L
.65873 .14921 L
.65873 .15873 L
.65873 .16825 L
.65873 .17778 L
.65873 .1873 L
.65873 .19683 L
.65873 .20635 L
.65873 .21587 L
.65873 .2254 L
.65873 .23492 L
.65873 .24444 L
.65873 .25397 L
.65873 .26349 L
.65873 .27302 L
.65873 .28254 L
.65873 .29206 L
.65873 .30159 L
.65873 .31111 L
.65873 .32063 L
.65873 .33016 L
.65873 .33968 L
.65873 .34921 L
.65873 .35873 L
.65873 .36825 L
.65873 .37778 L
.65873 .3873 L
.65873 .39683 L
.65873 .40635 L
.65873 .41587 L
.65873 .4254 L
.65873 .43492 L
.65873 .44444 L
.65873 .45397 L
.65873 .46349 L
.65873 .47302 L
.65873 .48254 L
Mistroke
.65873 .49206 L
.65873 .50159 L
.65873 .51111 L
.65873 .52063 L
.65873 .53016 L
.65873 .53968 L
.65873 .54921 L
.65873 .55873 L
.65873 .56825 L
.65873 .57778 L
.65873 .5873 L
.65873 .59683 L
.65873 .60635 L
.65873 .61587 L
.65873 .6254 L
.65873 .63492 L
.65873 .64444 L
.65873 .65079 L
Mfstroke
.97619 .01587 m
.97619 .0254 L
.97619 .03492 L
.97619 .04444 L
.97619 .05397 L
.97619 .06349 L
.97619 .07302 L
.97619 .08254 L
.97619 .09206 L
.97619 .10159 L
.97619 .11111 L
.97619 .12063 L
.97619 .13016 L
.97619 .13968 L
.97619 .14921 L
.97619 .15873 L
.97619 .16825 L
.97619 .17778 L
.97619 .1873 L
.97619 .19683 L
.97619 .20635 L
.97619 .21587 L
.97619 .2254 L
.97619 .23492 L
.97619 .24444 L
.97619 .25397 L
.97619 .26349 L
.97619 .27302 L
.97619 .28254 L
.97619 .29206 L
.97619 .30159 L
.97619 .31111 L
.97619 .32063 L
.97619 .33016 L
.97619 .33968 L
.97619 .34921 L
.97619 .35873 L
.97619 .36825 L
.97619 .37778 L
.97619 .3873 L
.97619 .39683 L
.97619 .40635 L
.97619 .41587 L
.97619 .4254 L
.97619 .43492 L
.97619 .44444 L
.97619 .45397 L
.97619 .46349 L
.97619 .47302 L
.97619 .48254 L
Mistroke
.97619 .49206 L
.97619 .50159 L
.97619 .51111 L
.97619 .52063 L
.97619 .53016 L
.97619 .53968 L
.97619 .54921 L
.97619 .55873 L
.97619 .56825 L
.97619 .57778 L
.97619 .5873 L
.97619 .59683 L
.97619 .60635 L
.97619 .61587 L
.97619 .6254 L
.97619 .63492 L
.97619 .64444 L
.97619 .65079 L
Mfstroke
.02381 .22751 m
.03333 .22751 L
.04286 .22751 L
.05238 .22751 L
.0619 .22751 L
.07143 .22751 L
.08095 .22751 L
.09048 .22751 L
.1 .22751 L
.10952 .22751 L
.11905 .22751 L
.12857 .22751 L
.1381 .22751 L
.14762 .22751 L
.15714 .22751 L
.16667 .22751 L
.17619 .22751 L
.18571 .22751 L
.19524 .22751 L
.20476 .22751 L
.21429 .22751 L
.22381 .22751 L
.23333 .22751 L
.24286 .22751 L
.25238 .22751 L
.2619 .22751 L
.27143 .22751 L
.28095 .22751 L
.29048 .22751 L
.3 .22751 L
.30952 .22751 L
.31905 .22751 L
.32857 .22751 L
.3381 .22751 L
.34762 .22751 L
.35714 .22751 L
.36667 .22751 L
.37619 .22751 L
.38571 .22751 L
.39524 .22751 L
.40476 .22751 L
.41429 .22751 L
.42381 .22751 L
.43333 .22751 L
.44286 .22751 L
.45238 .22751 L
.4619 .22751 L
.47143 .22751 L
.48095 .22751 L
.49048 .22751 L
Mistroke
.5 .22751 L
.50952 .22751 L
.51905 .22751 L
.52857 .22751 L
.5381 .22751 L
.54762 .22751 L
.55714 .22751 L
.56667 .22751 L
.57619 .22751 L
.58571 .22751 L
.59524 .22751 L
.60476 .22751 L
.61429 .22751 L
.62381 .22751 L
.63333 .22751 L
.64286 .22751 L
.65238 .22751 L
.6619 .22751 L
.67143 .22751 L
.68095 .22751 L
.69048 .22751 L
.7 .22751 L
.70952 .22751 L
.71905 .22751 L
.72857 .22751 L
.7381 .22751 L
.74762 .22751 L
.75714 .22751 L
.76667 .22751 L
.77619 .22751 L
.78571 .22751 L
.79524 .22751 L
.80476 .22751 L
.81429 .22751 L
.82381 .22751 L
.83333 .22751 L
.84286 .22751 L
.85238 .22751 L
.8619 .22751 L
.87143 .22751 L
.88095 .22751 L
.89048 .22751 L
.9 .22751 L
.90952 .22751 L
.91905 .22751 L
.92857 .22751 L
.9381 .22751 L
.94762 .22751 L
.95714 .22751 L
.96667 .22751 L
Mistroke
.97619 .22751 L
.97619 .22751 L
Mfstroke
.02381 .54497 m
.03333 .54497 L
.04286 .54497 L
.05238 .54497 L
.0619 .54497 L
.07143 .54497 L
.08095 .54497 L
.09048 .54497 L
.1 .54497 L
.10952 .54497 L
.11905 .54497 L
.12857 .54497 L
.1381 .54497 L
.14762 .54497 L
.15714 .54497 L
.16667 .54497 L
.17619 .54497 L
.18571 .54497 L
.19524 .54497 L
.20476 .54497 L
.21429 .54497 L
.22381 .54497 L
.23333 .54497 L
.24286 .54497 L
.25238 .54497 L
.2619 .54497 L
.27143 .54497 L
.28095 .54497 L
.29048 .54497 L
.3 .54497 L
.30952 .54497 L
.31905 .54497 L
.32857 .54497 L
.3381 .54497 L
.34762 .54497 L
.35714 .54497 L
.36667 .54497 L
.37619 .54497 L
.38571 .54497 L
.39524 .54497 L
.40476 .54497 L
.41429 .54497 L
.42381 .54497 L
.43333 .54497 L
.44286 .54497 L
.45238 .54497 L
.4619 .54497 L
.47143 .54497 L
.48095 .54497 L
.49048 .54497 L
Mistroke
.5 .54497 L
.50952 .54497 L
.51905 .54497 L
.52857 .54497 L
.5381 .54497 L
.54762 .54497 L
.55714 .54497 L
.56667 .54497 L
.57619 .54497 L
.58571 .54497 L
.59524 .54497 L
.60476 .54497 L
.61429 .54497 L
.62381 .54497 L
.63333 .54497 L
.64286 .54497 L
.65238 .54497 L
.6619 .54497 L
.67143 .54497 L
.68095 .54497 L
.69048 .54497 L
.7 .54497 L
.70952 .54497 L
.71905 .54497 L
.72857 .54497 L
.7381 .54497 L
.74762 .54497 L
.75714 .54497 L
.76667 .54497 L
.77619 .54497 L
.78571 .54497 L
.79524 .54497 L
.80476 .54497 L
.81429 .54497 L
.82381 .54497 L
.83333 .54497 L
.84286 .54497 L
.85238 .54497 L
.8619 .54497 L
.87143 .54497 L
.88095 .54497 L
.89048 .54497 L
.9 .54497 L
.90952 .54497 L
.91905 .54497 L
.92857 .54497 L
.9381 .54497 L
.94762 .54497 L
.95714 .54497 L
.96667 .54497 L
Mistroke
.97619 .54497 L
.97619 .54497 L
Mfstroke
1 g
.07919 .60388 m
.10335 .60053 L
.16067 .55238 L
.15538 .54762 L
.16914 .54797 L
.17601 .53404 L
.1776 .5157 L
.194 .51076 L
.19083 .48325 L
.17901 .48219 L
.14656 .51093 L
.07919 .60388 L
F
.12116 .52628 m
.11781 .53527 L
.12116 .52628 L
F
.19189 .52928 m
.19859 .51217 L
.18395 .5231 L
.19206 .5291 L
F
.23175 .56684 m
.2261 .53968 L
.23792 .5134 L
.2552 .50723 L
.28448 .50071 L
.29894 .50741 L
.30123 .5261 L
.31905 .55679 L
.33086 .55538 L
.30988 .58307 L
.3157 .58907 L
.29753 .59118 L
.28713 .56684 L
.24145 .55397 L
.23175 .56684 L
F
.23439 .46208 m
.28377 .45203 L
.28236 .46243 L
.24621 .4769 L
.20406 .48236 L
.18483 .47337 L
.23439 .46208 L
F
.26649 .47196 m
.27919 .47143 L
.26667 .47196 L
F
.28289 .45926 m
.29594 .45608 L
.28289 .45944 L
F
.30247 .45802 m
.29912 .45062 L
.30265 .45802 L
F
.31182 .45626 m
.33069 .45626 L
.31005 .4485 L
.31182 .45626 L
F
.33104 .44515 m
.34991 .43933 L
.33104 .44515 L
F
.34409 .4575 m
.37302 .45767 L
.35203 .45026 L
.34021 .45115 L
.34427 .4575 L
F
.38854 .45891 m
.39559 .45679 L
.38854 .45891 L
F
.39524 .4448 m
.41852 .45608 L
.39577 .45362 L
.37795 .43527 L
.39524 .4448 L
F
.46455 .46966 m
.45908 .46014 L
.46455 .46966 L
F
.33686 .48554 m
.32822 .51217 L
.34162 .55256 L
.39683 .56085 L
.38624 .54885 L
.34392 .54868 L
.34832 .53016 L
.37778 .53686 L
.35503 .52593 L
.37196 .49841 L
.3575 .49841 L
.34938 .51728 L
.34497 .49859 L
.34198 .48589 L
F
.37884 .53122 m
.3709 .52963 L
.37884 .53104 L
F
.38801 .52751 m
.39753 .52504 L
.38801 .52751 L
F
.39859 .5261 m
.40847 .52575 L
.39859 .5261 L
F
.37002 .49612 m
.36543 .48801 L
.37002 .49612 L
F
.3739 .49841 m
.37108 .48483 L
.37372 .49841 L
F
.40617 .51199 m
.41799 .50935 L
.40617 .51199 L
F
.42787 .51464 m
.45326 .51182 L
.45591 .50406 L
.42504 .50723 L
.42787 .51464 L
F
.49489 .48748 m
.49295 .47901 L
.49489 .48748 L
F
.43545 .54709 m
.42504 .54709 L
.43051 .53527 L
.42134 .54938 L
.42646 .56825 L
.42205 .55467 L
.43545 .54709 L
F
.53757 .46684 m
.54127 .45944 L
.52804 .45573 L
.53774 .46684 L
F
.56349 .44832 m
.5545 .46155 L
.54145 .45714 L
.53245 .48783 L
.48907 .50423 L
.48801 .51393 L
.47778 .50176 L
.46772 .51552 L
.48871 .52275 L
.45714 .52981 L
.47284 .54127 L
.49189 .52981 L
.50123 .50935 L
.53016 .52945 L
.56349 .51746 L
.56349 .51746 L
.56349 .44832 L
F
.56349 .51746 m
.6321 .48166 L
.62892 .46596 L
.66808 .43668 L
.63457 .4381 L
.60071 .46561 L
.57549 .45785 L
.58818 .44938 L
.56349 .44832 L
.56349 .51746 L
F
.68183 .50106 m
.66966 .48095 L
.64145 .48695 L
.66861 .48695 L
.68183 .50106 L
F
.95326 .3612 m
.96243 .3545 L
.95503 .35168 L
F
.60194 .13933 m
.59048 .13369 L
.55679 .14339 L
.54744 .1649 L
.53263 .1836 L
.5194 .17143 L
.52928 .20088 L
.51005 .17478 L
.48713 .20406 L
.45979 .21182 L
.40459 .203 L
.34145 .18589 L
.31958 .17302 L
.28959 .18113 L
.29612 .20741 L
.26878 .26825 L
.28025 .26843 L
.27143 .28924 L
.27813 .31411 L
.30758 .32804 L
.3522 .33827 L
.37231 .37178 L
.38113 .35573 L
.37954 .37425 L
.39683 .38007 L
.40494 .39788 L
.41975 .39735 L
.42416 .37989 L
.43104 .38871 L
.44921 .38219 L
.44392 .39806 L
.45767 .41623 L
.47549 .41605 L
.46808 .42646 L
.50758 .41481 L
.52099 .41376 L
.50476 .38642 L
.55397 .3575 L
.57108 .38377 L
.57549 .42822 L
.58571 .41587 L
.59295 .39277 L
.6097 .3866 L
.6194 .34515 L
.64586 .33069 L
.65485 .30635 L
.6672 .30653 L
.68959 .27725 L
.697 .24039 L
.66102 .16684 L
.65467 .14586 L
.62028 .13069 L
.60194 .13933 L
F
.69083 .27231 m
.6933 .2836 L
.69083 .27231 L
F
.61393 .08818 m
.60265 .11446 L
.64127 .11146 L
.63739 .08801 L
.61393 .08836 L
F
.45697 .41869 m
.45115 .42646 L
.46226 .4254 L
.45697 .41869 L
F
.91287 .10388 m
.89912 .1164 L
.88589 .10317 L
.8358 .05591 L
.87866 .05944 L
.87549 .07143 L
.89365 .08042 L
.88042 .08677 L
.89947 .08713 L
.91287 .10388 L
F
.94374 .12504 m
.92575 .10459 L
.92698 .11958 L
.91058 .12787 L
.92275 .15273 L
.89894 .18078 L
.93386 .14674 L
.96085 .14603 L
.94374 .12504 L
F
0 g
.07919 .60388 m
.10335 .60053 L
.16067 .55238 L
.15538 .54762 L
.16914 .54797 L
.17601 .53404 L
.1776 .5157 L
.194 .51076 L
.19083 .48325 L
.17901 .48219 L
.14656 .51093 L
.07919 .60388 L
s
.12116 .52628 m
.11781 .53527 L
.12116 .52628 L
s
.19189 .52928 m
.19859 .51217 L
.18395 .5231 L
.19206 .5291 L
s
.23175 .56684 m
.2261 .53968 L
.23792 .5134 L
.2552 .50723 L
.28448 .50071 L
.29894 .50741 L
.30123 .5261 L
.31905 .55679 L
.33086 .55538 L
.30988 .58307 L
.3157 .58907 L
.29753 .59118 L
.28713 .56684 L
.24145 .55397 L
.23175 .56684 L
s
.23439 .46208 m
.28377 .45203 L
.28236 .46243 L
.24621 .4769 L
.20406 .48236 L
.18483 .47337 L
.23439 .46208 L
s
.26649 .47196 m
.27919 .47143 L
.26667 .47196 L
s
.28289 .45926 m
.29594 .45608 L
.28289 .45944 L
s
.30247 .45802 m
.29912 .45062 L
.30265 .45802 L
s
.31182 .45626 m
.33069 .45626 L
.31005 .4485 L
.31182 .45626 L
s
.33104 .44515 m
.34991 .43933 L
.33104 .44515 L
s
.34409 .4575 m
.37302 .45767 L
.35203 .45026 L
.34021 .45115 L
.34427 .4575 L
s
.38854 .45891 m
.39559 .45679 L
.38854 .45891 L
s
.39524 .4448 m
.41852 .45608 L
.39577 .45362 L
.37795 .43527 L
.39524 .4448 L
s
.46455 .46966 m
.45908 .46014 L
.46455 .46966 L
s
.33686 .48554 m
.32822 .51217 L
.34162 .55256 L
.39683 .56085 L
.38624 .54885 L
.34392 .54868 L
.34832 .53016 L
.37778 .53686 L
.35503 .52593 L
.37196 .49841 L
.3575 .49841 L
.34938 .51728 L
.34497 .49859 L
.34198 .48589 L
s
.37884 .53122 m
.3709 .52963 L
.37884 .53104 L
s
.38801 .52751 m
.39753 .52504 L
.38801 .52751 L
s
.39859 .5261 m
.40847 .52575 L
.39859 .5261 L
s
.37002 .49612 m
.36543 .48801 L
.37002 .49612 L
s
.3739 .49841 m
.37108 .48483 L
.37372 .49841 L
s
.40617 .51199 m
.41799 .50935 L
.40617 .51199 L
s
.42787 .51464 m
.45326 .51182 L
.45591 .50406 L
.42504 .50723 L
.42787 .51464 L
s
.49489 .48748 m
.49295 .47901 L
.49489 .48748 L
s
.43545 .54709 m
.42504 .54709 L
.43051 .53527 L
.42134 .54938 L
.42646 .56825 L
.42205 .55467 L
.43545 .54709 L
s
.53757 .46684 m
.54127 .45944 L
.52804 .45573 L
.53774 .46684 L
s
.56349 .44832 m
.5545 .46155 L
.54145 .45714 L
.53245 .48783 L
.48907 .50423 L
.48801 .51393 L
.47778 .50176 L
.46772 .51552 L
.48871 .52275 L
.45714 .52981 L
.47284 .54127 L
.49189 .52981 L
.50123 .50935 L
.53016 .52945 L
.56349 .51746 L
.56349 .51746 L
.56349 .44832 L
s
.56349 .51746 m
.6321 .48166 L
.62892 .46596 L
.66808 .43668 L
.63457 .4381 L
.60071 .46561 L
.57549 .45785 L
.58818 .44938 L
.56349 .44832 L
.56349 .51746 L
s
.68183 .50106 m
.66966 .48095 L
.64145 .48695 L
.66861 .48695 L
.68183 .50106 L
s
.95326 .3612 m
.96243 .3545 L
.95503 .35168 L
s
.60194 .13933 m
.59048 .13369 L
.55679 .14339 L
.54744 .1649 L
.53263 .1836 L
.5194 .17143 L
.52928 .20088 L
.51005 .17478 L
.48713 .20406 L
.45979 .21182 L
.40459 .203 L
.34145 .18589 L
.31958 .17302 L
.28959 .18113 L
.29612 .20741 L
.26878 .26825 L
.28025 .26843 L
.27143 .28924 L
.27813 .31411 L
.30758 .32804 L
.3522 .33827 L
.37231 .37178 L
.38113 .35573 L
.37954 .37425 L
.39683 .38007 L
.40494 .39788 L
.41975 .39735 L
.42416 .37989 L
.43104 .38871 L
.44921 .38219 L
.44392 .39806 L
.45767 .41623 L
.47549 .41605 L
.46808 .42646 L
.50758 .41481 L
.52099 .41376 L
.50476 .38642 L
.55397 .3575 L
.57108 .38377 L
.57549 .42822 L
.58571 .41587 L
.59295 .39277 L
.6097 .3866 L
.6194 .34515 L
.64586 .33069 L
.65485 .30635 L
.6672 .30653 L
.68959 .27725 L
.697 .24039 L
.66102 .16684 L
Mistroke
.65467 .14586 L
.62028 .13069 L
.60194 .13933 L
Mfstroke
.69083 .27231 m
.6933 .2836 L
.69083 .27231 L
s
.61393 .08818 m
.60265 .11446 L
.64127 .11146 L
.63739 .08801 L
.61393 .08836 L
s
.45697 .41869 m
.45115 .42646 L
.46226 .4254 L
.45697 .41869 L
s
.91287 .10388 m
.89912 .1164 L
.88589 .10317 L
.8358 .05591 L
.87866 .05944 L
.87549 .07143 L
.89365 .08042 L
.88042 .08677 L
.89947 .08713 L
.91287 .10388 L
s
.94374 .12504 m
.92575 .10459 L
.92698 .11958 L
.91058 .12787 L
.92275 .15273 L
.89894 .18078 L
.93386 .14674 L
.96085 .14603 L
.94374 .12504 L
s
.97619 .65079 m
.97619 .64444 L
.97619 .63492 L
.97619 .6254 L
.97619 .61587 L
.97619 .60635 L
.97619 .59683 L
.97619 .5873 L
.97619 .57778 L
.97619 .56825 L
.97619 .55873 L
.97619 .54921 L
.97619 .53968 L
.97619 .53016 L
.97619 .52063 L
.97619 .51111 L
.97619 .50159 L
.97619 .49206 L
.97619 .48254 L
.97619 .47302 L
.97619 .46349 L
.97619 .45397 L
.97619 .44444 L
.97619 .43492 L
.97619 .4254 L
.97619 .41587 L
.97619 .40635 L
.97619 .39683 L
.97619 .3873 L
.97619 .37778 L
.97619 .36825 L
.97619 .35873 L
.97619 .34921 L
.97619 .33968 L
.97619 .33016 L
.97619 .32063 L
.97619 .31111 L
.97619 .30159 L
.97619 .29206 L
.97619 .28254 L
.97619 .27302 L
.97619 .26349 L
.97619 .25397 L
.97619 .24444 L
.97619 .23492 L
.97619 .2254 L
.97619 .21587 L
.97619 .20635 L
.97619 .19683 L
.97619 .1873 L
Mistroke
.97619 .17778 L
.97619 .16825 L
.97619 .15873 L
.97619 .14921 L
.97619 .13968 L
.97619 .13016 L
.97619 .12063 L
.97619 .11111 L
.97619 .10159 L
.97619 .09206 L
.97619 .08254 L
.97619 .07302 L
.97619 .06349 L
.97619 .05397 L
.97619 .04444 L
.97619 .03492 L
.97619 .0254 L
.97619 .01587 L
Mfstroke
.97619 .01587 m
.97619 .01587 L
.96667 .01587 L
.95714 .01587 L
.94762 .01587 L
.9381 .01587 L
.92857 .01587 L
.91905 .01587 L
.90952 .01587 L
.9 .01587 L
.89048 .01587 L
.88095 .01587 L
.87143 .01587 L
.8619 .01587 L
.85238 .01587 L
.84286 .01587 L
.83333 .01587 L
.82381 .01587 L
.81429 .01587 L
.80476 .01587 L
.79524 .01587 L
.78571 .01587 L
.77619 .01587 L
.76667 .01587 L
.75714 .01587 L
.74762 .01587 L
.7381 .01587 L
.72857 .01587 L
.71905 .01587 L
.70952 .01587 L
.7 .01587 L
.69048 .01587 L
.68095 .01587 L
.67143 .01587 L
.6619 .01587 L
.65238 .01587 L
.64286 .01587 L
.63333 .01587 L
.62381 .01587 L
.61429 .01587 L
.60476 .01587 L
.59524 .01587 L
.58571 .01587 L
.57619 .01587 L
.56667 .01587 L
.55714 .01587 L
.54762 .01587 L
.5381 .01587 L
.52857 .01587 L
.51905 .01587 L
Mistroke
.50952 .01587 L
.5 .01587 L
.49048 .01587 L
.48095 .01587 L
.47143 .01587 L
.4619 .01587 L
.45238 .01587 L
.44286 .01587 L
.43333 .01587 L
.42381 .01587 L
.41429 .01587 L
.40476 .01587 L
.39524 .01587 L
.38571 .01587 L
.37619 .01587 L
.36667 .01587 L
.35714 .01587 L
.34762 .01587 L
.3381 .01587 L
.32857 .01587 L
.31905 .01587 L
.30952 .01587 L
.3 .01587 L
.29048 .01587 L
.28095 .01587 L
.27143 .01587 L
.2619 .01587 L
.25238 .01587 L
.24286 .01587 L
.23333 .01587 L
.22381 .01587 L
.21429 .01587 L
.20476 .01587 L
.19524 .01587 L
.18571 .01587 L
.17619 .01587 L
.16667 .01587 L
.15714 .01587 L
.14762 .01587 L
.1381 .01587 L
.12857 .01587 L
.11905 .01587 L
.10952 .01587 L
.1 .01587 L
.09048 .01587 L
.08095 .01587 L
.07143 .01587 L
.0619 .01587 L
.05238 .01587 L
.04286 .01587 L
Mistroke
.03333 .01587 L
.02381 .01587 L
Mfstroke
.02381 .01587 m
.02381 .0254 L
.02381 .03492 L
.02381 .04444 L
.02381 .05397 L
.02381 .06349 L
.02381 .07302 L
.02381 .08254 L
.02381 .09206 L
.02381 .10159 L
.02381 .11111 L
.02381 .12063 L
.02381 .13016 L
.02381 .13968 L
.02381 .14921 L
.02381 .15873 L
.02381 .16825 L
.02381 .17778 L
.02381 .1873 L
.02381 .19683 L
.02381 .20635 L
.02381 .21587 L
.02381 .2254 L
.02381 .23492 L
.02381 .24444 L
.02381 .25397 L
.02381 .26349 L
.02381 .27302 L
.02381 .28254 L
.02381 .29206 L
.02381 .30159 L
.02381 .31111 L
.02381 .32063 L
.02381 .33016 L
.02381 .33968 L
.02381 .34921 L
.02381 .35873 L
.02381 .36825 L
.02381 .37778 L
.02381 .3873 L
.02381 .39683 L
.02381 .40635 L
.02381 .41587 L
.02381 .4254 L
.02381 .43492 L
.02381 .44444 L
.02381 .45397 L
.02381 .46349 L
.02381 .47302 L
.02381 .48254 L
Mistroke
.02381 .49206 L
.02381 .50159 L
.02381 .51111 L
.02381 .52063 L
.02381 .53016 L
.02381 .53968 L
.02381 .54921 L
.02381 .55873 L
.02381 .56825 L
.02381 .57778 L
.02381 .5873 L
.02381 .59683 L
.02381 .60635 L
.02381 .61587 L
.02381 .6254 L
.02381 .63492 L
.02381 .64444 L
.02381 .65079 L
Mfstroke
.02381 .65079 m
.03333 .65079 L
.04286 .65079 L
.05238 .65079 L
.0619 .65079 L
.07143 .65079 L
.08095 .65079 L
.09048 .65079 L
.1 .65079 L
.10952 .65079 L
.11905 .65079 L
.12857 .65079 L
.1381 .65079 L
.14762 .65079 L
.15714 .65079 L
.16667 .65079 L
.17619 .65079 L
.18571 .65079 L
.19524 .65079 L
.20476 .65079 L
.21429 .65079 L
.22381 .65079 L
.23333 .65079 L
.24286 .65079 L
.25238 .65079 L
.2619 .65079 L
.27143 .65079 L
.28095 .65079 L
.29048 .65079 L
.3 .65079 L
.30952 .65079 L
.31905 .65079 L
.32857 .65079 L
.3381 .65079 L
.34762 .65079 L
.35714 .65079 L
.36667 .65079 L
.37619 .65079 L
.38571 .65079 L
.39524 .65079 L
.40476 .65079 L
.41429 .65079 L
.42381 .65079 L
.43333 .65079 L
.44286 .65079 L
.45238 .65079 L
.4619 .65079 L
.47143 .65079 L
.48095 .65079 L
.49048 .65079 L
Mistroke
.5 .65079 L
.50952 .65079 L
.51905 .65079 L
.52857 .65079 L
.5381 .65079 L
.54762 .65079 L
.55714 .65079 L
.56667 .65079 L
.57619 .65079 L
.58571 .65079 L
.59524 .65079 L
.60476 .65079 L
.61429 .65079 L
.62381 .65079 L
.63333 .65079 L
.64286 .65079 L
.65238 .65079 L
.6619 .65079 L
.67143 .65079 L
.68095 .65079 L
.69048 .65079 L
.7 .65079 L
.70952 .65079 L
.71905 .65079 L
.72857 .65079 L
.7381 .65079 L
.74762 .65079 L
.75714 .65079 L
.76667 .65079 L
.77619 .65079 L
.78571 .65079 L
.79524 .65079 L
.80476 .65079 L
.81429 .65079 L
.82381 .65079 L
.83333 .65079 L
.84286 .65079 L
.85238 .65079 L
.8619 .65079 L
.87143 .65079 L
.88095 .65079 L
.89048 .65079 L
.9 .65079 L
.90952 .65079 L
.91905 .65079 L
.92857 .65079 L
.9381 .65079 L
.94762 .65079 L
.95714 .65079 L
.96667 .65079 L
Mistroke
.97619 .65079 L
.97619 .65079 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.0.7"],

Cell[BoxData["\<\"-WorldGraphics-\"\>"], "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S5.0.7"]
}, Open  ]],

Cell[TextData[{
 "Basic properties of the chemical elements are provided in the ",
 StyleBox["ChemicalElements", "MR"],
 " package. "
}], "MathCaption",
 CellTags->{"S5.0.7", "7.9"}],

Cell["<<Miscellaneous`ChemicalElements`", "Input",
 CellLabel->"In[7]:= ",
 CellTags->"S5.0.7"],

Cell["\<\
This depicts the number of electrons in the outermost shell for each chemical \
element with a known electron configuration. \
\>", "MathCaption",
 CellTags->{"S5.0.7", "7.10"}],

Cell[CellGroupData[{

Cell["\<\
ListPlot[Apply[Plus, Map[Last,
         ElectronConfiguration[Drop[Elements, -2]]], 1]]\
\>", "Input",
 CellLabel->"In[8]:= ",
 CellTags->"S5.0.7"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.00865801 0.0147151 0.0619583 [
[.19697 .00222 -6 -9 ]
[.19697 .00222 6 0 ]
[.37013 .00222 -6 -9 ]
[.37013 .00222 6 0 ]
[.54329 .00222 -6 -9 ]
[.54329 .00222 6 0 ]
[.71645 .00222 -6 -9 ]
[.71645 .00222 6 0 ]
[.88961 .00222 -9 -9 ]
[.88961 .00222 9 0 ]
[.01131 .13863 -6 -4.5 ]
[.01131 .13863 0 4.5 ]
[.01131 .26255 -6 -4.5 ]
[.01131 .26255 0 4.5 ]
[.01131 .38646 -6 -4.5 ]
[.01131 .38646 0 4.5 ]
[.01131 .51038 -6 -4.5 ]
[.01131 .51038 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.19697 .01472 m
.19697 .02097 L
s
[(20)] .19697 .00222 0 1 Mshowa
.37013 .01472 m
.37013 .02097 L
s
[(40)] .37013 .00222 0 1 Mshowa
.54329 .01472 m
.54329 .02097 L
s
[(60)] .54329 .00222 0 1 Mshowa
.71645 .01472 m
.71645 .02097 L
s
[(80)] .71645 .00222 0 1 Mshowa
.88961 .01472 m
.88961 .02097 L
s
[(100)] .88961 .00222 0 1 Mshowa
.125 Mabswid
.0671 .01472 m
.0671 .01847 L
s
.11039 .01472 m
.11039 .01847 L
s
.15368 .01472 m
.15368 .01847 L
s
.24026 .01472 m
.24026 .01847 L
s
.28355 .01472 m
.28355 .01847 L
s
.32684 .01472 m
.32684 .01847 L
s
.41342 .01472 m
.41342 .01847 L
s
.45671 .01472 m
.45671 .01847 L
s
.5 .01472 m
.5 .01847 L
s
.58658 .01472 m
.58658 .01847 L
s
.62987 .01472 m
.62987 .01847 L
s
.67316 .01472 m
.67316 .01847 L
s
.75974 .01472 m
.75974 .01847 L
s
.80303 .01472 m
.80303 .01847 L
s
.84632 .01472 m
.84632 .01847 L
s
.9329 .01472 m
.9329 .01847 L
s
.97619 .01472 m
.97619 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .13863 m
.03006 .13863 L
s
[(2)] .01131 .13863 1 0 Mshowa
.02381 .26255 m
.03006 .26255 L
s
[(4)] .01131 .26255 1 0 Mshowa
.02381 .38646 m
.03006 .38646 L
s
[(6)] .01131 .38646 1 0 Mshowa
.02381 .51038 m
.03006 .51038 L
s
[(8)] .01131 .51038 1 0 Mshowa
.125 Mabswid
.02381 .04569 m
.02756 .04569 L
s
.02381 .07667 m
.02756 .07667 L
s
.02381 .10765 m
.02756 .10765 L
s
.02381 .16961 m
.02756 .16961 L
s
.02381 .20059 m
.02756 .20059 L
s
.02381 .23157 m
.02756 .23157 L
s
.02381 .29353 m
.02756 .29353 L
s
.02381 .32451 m
.02756 .32451 L
s
.02381 .35549 m
.02756 .35549 L
s
.02381 .41744 m
.02756 .41744 L
s
.02381 .44842 m
.02756 .44842 L
s
.02381 .4794 m
.02756 .4794 L
s
.02381 .54136 m
.02756 .54136 L
s
.02381 .57234 m
.02756 .57234 L
s
.02381 .60332 m
.02756 .60332 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.008 w
.03247 .07667 Mdot
.04113 .13863 Mdot
.04978 .07667 Mdot
.05844 .13863 Mdot
.0671 .20059 Mdot
.07576 .26255 Mdot
.08442 .32451 Mdot
.09307 .38646 Mdot
.10173 .44842 Mdot
.11039 .51038 Mdot
.11905 .07667 Mdot
.12771 .13863 Mdot
.13636 .20059 Mdot
.14502 .26255 Mdot
.15368 .32451 Mdot
.16234 .38646 Mdot
.171 .44842 Mdot
.17965 .51038 Mdot
.18831 .07667 Mdot
.19697 .13863 Mdot
.20563 .13863 Mdot
.21429 .13863 Mdot
.22294 .13863 Mdot
.2316 .07667 Mdot
.24026 .13863 Mdot
.24892 .13863 Mdot
.25758 .13863 Mdot
.26623 .13863 Mdot
.27489 .07667 Mdot
.28355 .13863 Mdot
.29221 .20059 Mdot
.30087 .26255 Mdot
.30952 .32451 Mdot
.31818 .38646 Mdot
.32684 .44842 Mdot
.3355 .51038 Mdot
.34416 .07667 Mdot
.35281 .13863 Mdot
.36147 .13863 Mdot
.37013 .13863 Mdot
.37879 .07667 Mdot
.38745 .07667 Mdot
.3961 .13863 Mdot
.40476 .07667 Mdot
.41342 .07667 Mdot
.43074 .07667 Mdot
.43939 .13863 Mdot
.44805 .20059 Mdot
.45671 .26255 Mdot
.46537 .32451 Mdot
.47403 .38646 Mdot
.48268 .44842 Mdot
.49134 .51038 Mdot
.5 .07667 Mdot
.50866 .13863 Mdot
.51732 .13863 Mdot
.52597 .13863 Mdot
.53463 .13863 Mdot
.54329 .13863 Mdot
.55195 .13863 Mdot
.56061 .13863 Mdot
.56926 .13863 Mdot
.57792 .13863 Mdot
.58658 .13863 Mdot
.59524 .13863 Mdot
.6039 .13863 Mdot
.61255 .13863 Mdot
.62121 .13863 Mdot
.62987 .13863 Mdot
.63853 .13863 Mdot
.64719 .13863 Mdot
.65584 .13863 Mdot
.6645 .13863 Mdot
.67316 .13863 Mdot
.68182 .13863 Mdot
.69048 .13863 Mdot
.69913 .07667 Mdot
.70779 .07667 Mdot
.71645 .13863 Mdot
.72511 .20059 Mdot
.73377 .26255 Mdot
.74242 .32451 Mdot
.75108 .38646 Mdot
.75974 .44842 Mdot
.7684 .51038 Mdot
.77706 .07667 Mdot
.78571 .13863 Mdot
.79437 .13863 Mdot
.80303 .13863 Mdot
.81169 .13863 Mdot
.82035 .13863 Mdot
.829 .13863 Mdot
.83766 .13863 Mdot
.84632 .13863 Mdot
.85498 .13863 Mdot
.86364 .13863 Mdot
.87229 .13863 Mdot
.88095 .13863 Mdot
.88961 .13863 Mdot
.89827 .13863 Mdot
.90693 .13863 Mdot
.91558 .13863 Mdot
.92424 .13863 Mdot
.9329 .13863 Mdot
.94156 .13863 Mdot
.95022 .13863 Mdot
.95887 .13863 Mdot
.96753 .13863 Mdot
.97619 .13863 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.0.7"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[8]= ",
 CellTags->"S5.0.7"]
}, Open  ]],

Cell[TextData[{
 "The ",
 StyleBox["RealOnly", "MR"],
 " package allows you to avoid expressing results in terms of complex \
numbers. The symbol ",
 StyleBox["Nonreal", "MR"],
 " replaces the result when a calculation is unable to avoid complex numbers. \
"
}], "MathCaption",
 CellTags->{"S5.0.7", "7.11"}],

Cell["<<Miscellaneous`RealOnly`", "Input",
 CellLabel->"In[9]:= ",
 CellTags->"S5.0.7"],

Cell["Only one of the solutions to this equation is real. ", "MathCaption",
 CellTags->{"S5.0.7", "7.12"}],

Cell[CellGroupData[{

Cell["Solve[x^3 + x^2 + x + 2. == 0, x]", "Input",
 CellLabel->"In[10]:= ",
 CellTags->"S5.0.7"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Nonreal", "::", "\<\"warning\"\>"}], 
  RowBox[{":", " "}], "\<\"Nonreal number encountered.\"\>"}]], "Message",
 CellTags->"S5.0.7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "1.3532099641993245`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "Nonreal"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "Nonreal"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[10]= ",
 CellTags->"S5.0.7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Number Theory Packages", "Subsection",
 CellTags->{"S5.0.8", "8.1"}],

Cell[TextData[{
 "Functions relevant to number theory are well represented in ",
 StyleBox["Mathematica", "TI"],
 " with examples such as ",
 StyleBox["PrimePi", "MR"],
 ", ",
 StyleBox["EulerPhi", "MR"],
 ", ",
 StyleBox["MoebiusMu", "MR"],
 ", and ",
 StyleBox["DivisorSigma", "MR"],
 ". The ",
 StyleBox["NumberTheory", "MR"],
 " packages broaden this set of functions. There are packages for proving \
primality, exploring the elliptic curve method for integer factorization, and \
finding primitive elements of multiple algebraic extensions of rationals. \
There are functions for approximating real numbers by rationals and \
approximating polynomials with real roots by polynomials with integer \
coefficients. Number theoretic functions such as Ramanujan ",
 Cell[BoxData[
  FormBox["\[Tau]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and Siegel ",
 Cell[BoxData[
  FormBox["\[CapitalTheta]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " are also supported. "
}], "Text",
 CellTags->{"S5.0.8", "8.2"}],

Cell[TextData[{
 "This causes the ",
 StyleBox["NumberTheory", "MR"],
 " packages to load as they are needed. "
}], "MathCaption",
 CellTags->{"S5.0.8", "8.3"}],

Cell["<<NumberTheory`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.0.8"],

Cell[TextData[{
 "Some of the plots in this section require the ",
 StyleBox["Graphics", "MR"],
 " packages. "
}], "MathCaption",
 CellTags->{"S5.0.8", "8.4"}],

Cell["<<Graphics`", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.0.8"],

Cell[TextData[{
 "The ratios of the integers given by ",
 StyleBox["ProjectiveRationalize", "MR"],
 " approximate the ratios of the corresponding real numbers ",
 Cell[BoxData[
  FormBox["1.", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", ",
 Cell[BoxData[
  FormBox["1.73245", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", ",
 Cell[BoxData[
  FormBox["2.71828", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", and ",
 Cell[BoxData[
  FormBox["3.14159", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " within an error of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["10", 
    RowBox[{"-", "5"}]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.0.8", "8.5"}],

Cell[CellGroupData[{

Cell["\<\
(reals = N[{1, 1/EulerGamma, E, Pi}];
prec = 5;
p = ProjectiveRationalize[reals, prec])\
\>", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.0.8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"80435", ",", "139350", ",", "218645", ",", "252694"}], 
  "}"}]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.0.8"]
}, Open  ]],

Cell[TextData[{
 "Several gear ratios can be approximated simultaneously, under the \
constraint that the smallest gear have fewer than 110 teeth. Here the \
approximation to ",
 Cell[BoxData[
  FormBox[
   FractionBox["1", "\[Pi]"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"71", "/", "223"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.0.8", "8.6"}],

Cell[CellGroupData[{

Cell["\<\
(While[p[[1]] > 110,
  prec--;
  p = ProjectiveRationalize[reals, prec]];
p)\
\>", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.0.8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"71", ",", "123", ",", "193", ",", "223"}], "}"}]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.0.8"]
}, Open  ]],

Cell[TextData[{
 "Square\[Hyphen]free integers have no factors that are perfect squares. ",
 StyleBox["SquareFreeQ", "MR"],
 " determines whether an integer is square\[Hyphen]free. "
}], "Text",
 CellTags->{"S5.0.8", "8.7"}],

Cell[TextData[{
 "Two integers are coprime if their greatest common divisor (GCD) is ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". This shows that there is a positive correlation between the square\
\[Hyphen]free property and coprimality. "
}], "MathCaption",
 CellTags->{"S5.0.8", "8.8"}],

Cell[CellGroupData[{

Cell["\<\
(sample = Table[Random[Integer, 1000000], {100}];
xor = Map[(squarefree = SquareFreeQ[#];
     coprime = (GCD[#, Random[Integer, 1000000]] == 1);
     If[Xor[squarefree, coprime], -1, 1])&, sample];
N[Apply[Plus, xor]/Length[xor]])\
\>", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.0.8"],

Cell[BoxData["0.4`"], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S5.0.8"]
}, Open  ]],

Cell[TextData[{
 "Every positive integer can be represented as the sum of four squares, but \
there are relatively few perfect squares. Each of the remaining integers can \
be minimally represented as a sum of either two or three squares. The number \
of representations of an integer ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " as a sum of ",
 Cell[BoxData[
  FormBox[
   StyleBox["d",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " squares ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     StyleBox["r",
      "TI"], 
     StyleBox["d",
      "TI"]], 
    RowBox[{"(", 
     StyleBox["n",
      "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is given by ",
 StyleBox["SumOfSquaresR[", "MR"],
 StyleBox["d", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["n", "TI"],
 StyleBox["]", "MR"],
 ". "
}], "Text",
 CellTags->{"S5.0.8", "8.9"}],

Cell[TextData[{
 "This shows the percentage of numbers from ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " to ",
 Cell[BoxData[
  FormBox["100", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " representable as a sum of a minimum of ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", ",
 Cell[BoxData[
  FormBox["2", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", ",
 Cell[BoxData[
  FormBox["3", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", or ",
 Cell[BoxData[
  FormBox["4", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " squares. "
}], "MathCaption",
 CellTags->{"S5.0.8", "8.10"}],

Cell[CellGroupData[{

Cell["\<\
(squares = Table[
Which[
        SumOfSquaresR[1, n] != 0, 1,
        SumOfSquaresR[2, n] != 0, 2,
        SumOfSquaresR[3, n] != 0, 3,
        True, 4], {n, 1, 100}];
PieChart[Map[Count[squares, #]&, Range[4]]])\
\>", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.0.8"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.47619 0.5 0.47619 [
[.77173 .58829 -3 -4.5 ]
[.77173 .58829 3 4.5 ]
[.47311 .78445 -3 -4.5 ]
[.47311 .78445 3 4.5 ]
[.31788 .27985 -3 -4.5 ]
[.31788 .27985 3 4.5 ]
[.75457 .37029 -3 -4.5 ]
[.75457 .37029 3 4.5 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
1 0 0 r
.5 .5 m
.5 .5 .47619 0 36 arc
F
.6 1 0 r
.5 .5 m
.5 .5 .47619 36 154.8 arc
F
0 1 .8 r
.5 .5 m
.5 .5 .47619 154.8 306 arc
F
.2 0 1 r
.5 .5 m
.5 .5 .47619 306 360 arc
F
0 g
.5 Mabswid
[ ] 0 setdash
.5 .5 m
.97619 .5 L
s
.5 .5 m
.88525 .7799 L
s
newpath
.5 .5 .47619 0 36 arc
s
.5 .5 m
.88525 .7799 L
s
.5 .5 m
.06913 .70275 L
s
newpath
.5 .5 .47619 36 154.8 arc
s
.5 .5 m
.06913 .70275 L
s
.5 .5 m
.7799 .11475 L
s
newpath
.5 .5 .47619 154.8 306 arc
s
.5 .5 m
.7799 .11475 L
s
.5 .5 m
.97619 .5 L
s
newpath
.5 .5 .47619 306 360 arc
s
[(1)] .77173 .58829 0 0 Mshowa
[(2)] .47311 .78445 0 0 Mshowa
[(3)] .31788 .27985 0 0 Mshowa
[(4)] .75457 .37029 0 0 Mshowa
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.0.8"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S5.0.8"]
}, Open  ]],

Cell[TextData[{
 StyleBox["PrimitiveRoot[", "MR"],
 StyleBox["p", "TI"],
 StyleBox["]", "MR"],
 " gives a cyclic generator of the multiplicative group mod ",
 Cell[BoxData[
  FormBox[
   StyleBox["p",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", where ",
 Cell[BoxData[
  FormBox[
   StyleBox["p",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is prime. Primitive root arrays are used for wave scattering over a range \
of frequencies. "
}], "Text",
 CellTags->{"S5.0.8", "8.11"}],

Cell[TextData[{
 "This gives the primitive root array for ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["p",
     "TI"], "=", "19"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.0.8", "8.12"}],

Cell[CellGroupData[{

Cell["\<\
(p = 19;
r = PrimitiveRoot[p];
array = Table[PowerMod[r, n, p], {n, 0, p-2}])\
\>", "Input",
 CellLabel->"In[7]:= ",
 CellTags->"S5.0.8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "4", ",", "8", ",", "16", ",", "13", ",", "7", ",", 
   "14", ",", "9", ",", "18", ",", "17", ",", "15", ",", "11", ",", "3", ",", 
   "6", ",", "12", ",", "5", ",", "10"}], "}"}]], "Output",
 CellLabel->"Out[7]= ",
 CellTags->"S5.0.8"]
}, Open  ]],

Cell["\<\
Here is a depiction of a reflection phase\[Hyphen]grating based on the array. \
The surface is pitted with a sequence of \[OpenCurlyDoubleQuote]wells\
\[CloseCurlyDoubleQuote] (shown in white) having depths proportional to the \
elements of the array. \
\>", "MathCaption",
 CellTags->{"S5.0.8", "8.13"}],

Cell[CellGroupData[{

Cell["\<\
(array5 = Flatten[Table[array, {5}]];
StackedBarChart[(p-array5), array5,
 BarLabels -> None, BarSpacing -> 0,
 BarStyle -> {GrayLevel[0], GrayLevel[1]},
 AspectRatio ->.1, Ticks -> None])\
\>", "Input",
 CellLabel->"In[8]:= ",
 CellTags->"S5.0.8"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.00555556 0.0111111 0.00238095 0.00501253 [
[ 0 0 0 0 ]
[ 1 .1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .00238 m
1 .00238 L
s
0 0 m
0 .1 L
s
0 0 m
1 0 L
1 .1 L
0 .1 L
closepath
clip
newpath
0 .00238 m
0 .09261 L
.01111 .09261 L
.01111 .00238 L
F
.5 Mabswid
0 .00238 m
0 .09261 L
.01111 .09261 L
.01111 .00238 L
0 .00238 L
s
.01111 .00238 m
.01111 .08759 L
.02222 .08759 L
.02222 .00238 L
F
.01111 .00238 m
.01111 .08759 L
.02222 .08759 L
.02222 .00238 L
.01111 .00238 L
s
.02222 .00238 m
.02222 .07757 L
.03333 .07757 L
.03333 .00238 L
F
.02222 .00238 m
.02222 .07757 L
.03333 .07757 L
.03333 .00238 L
.02222 .00238 L
s
.03333 .00238 m
.03333 .05752 L
.04444 .05752 L
.04444 .00238 L
F
.03333 .00238 m
.03333 .05752 L
.04444 .05752 L
.04444 .00238 L
.03333 .00238 L
s
.04444 .00238 m
.04444 .01742 L
.05556 .01742 L
.05556 .00238 L
F
.04444 .00238 m
.04444 .01742 L
.05556 .01742 L
.05556 .00238 L
.04444 .00238 L
s
.05556 .00238 m
.05556 .03246 L
.06667 .03246 L
.06667 .00238 L
F
.05556 .00238 m
.05556 .03246 L
.06667 .03246 L
.06667 .00238 L
.05556 .00238 L
s
.06667 .00238 m
.06667 .06253 L
.07778 .06253 L
.07778 .00238 L
F
.06667 .00238 m
.06667 .06253 L
.07778 .06253 L
.07778 .00238 L
.06667 .00238 L
s
.07778 .00238 m
.07778 .02744 L
.08889 .02744 L
.08889 .00238 L
F
.07778 .00238 m
.07778 .02744 L
.08889 .02744 L
.08889 .00238 L
.07778 .00238 L
s
.08889 .00238 m
.08889 .05251 L
.1 .05251 L
.1 .00238 L
F
.08889 .00238 m
.08889 .05251 L
.1 .05251 L
.1 .00238 L
.08889 .00238 L
s
.1 .00238 m
.1 .00739 L
.11111 .00739 L
.11111 .00238 L
F
.1 .00238 m
.1 .00739 L
.11111 .00739 L
.11111 .00238 L
.1 .00238 L
s
.11111 .00238 m
.11111 .01241 L
.12222 .01241 L
.12222 .00238 L
F
.11111 .00238 m
.11111 .01241 L
.12222 .01241 L
.12222 .00238 L
.11111 .00238 L
s
.12222 .00238 m
.12222 .02243 L
.13333 .02243 L
.13333 .00238 L
F
.12222 .00238 m
.12222 .02243 L
.13333 .02243 L
.13333 .00238 L
.12222 .00238 L
s
.13333 .00238 m
.13333 .04248 L
.14444 .04248 L
.14444 .00238 L
F
.13333 .00238 m
.13333 .04248 L
.14444 .04248 L
.14444 .00238 L
.13333 .00238 L
s
.14444 .00238 m
.14444 .08258 L
.15556 .08258 L
.15556 .00238 L
F
.14444 .00238 m
.14444 .08258 L
.15556 .08258 L
.15556 .00238 L
.14444 .00238 L
s
.15556 .00238 m
.15556 .06754 L
.16667 .06754 L
.16667 .00238 L
F
.15556 .00238 m
.15556 .06754 L
.16667 .06754 L
.16667 .00238 L
.15556 .00238 L
s
.16667 .00238 m
.16667 .03747 L
.17778 .03747 L
.17778 .00238 L
F
.16667 .00238 m
.16667 .03747 L
.17778 .03747 L
.17778 .00238 L
.16667 .00238 L
s
.17778 .00238 m
.17778 .07256 L
.18889 .07256 L
.18889 .00238 L
F
.17778 .00238 m
.17778 .07256 L
.18889 .07256 L
.18889 .00238 L
.17778 .00238 L
s
.18889 .00238 m
.18889 .04749 L
.2 .04749 L
.2 .00238 L
F
.18889 .00238 m
.18889 .04749 L
.2 .04749 L
.2 .00238 L
.18889 .00238 L
s
.2 .00238 m
.2 .09261 L
.21111 .09261 L
.21111 .00238 L
F
.2 .00238 m
.2 .09261 L
.21111 .09261 L
.21111 .00238 L
.2 .00238 L
s
.21111 .00238 m
.21111 .08759 L
.22222 .08759 L
.22222 .00238 L
F
.21111 .00238 m
.21111 .08759 L
.22222 .08759 L
.22222 .00238 L
.21111 .00238 L
s
.22222 .00238 m
.22222 .07757 L
.23333 .07757 L
.23333 .00238 L
F
.22222 .00238 m
.22222 .07757 L
.23333 .07757 L
.23333 .00238 L
.22222 .00238 L
s
.23333 .00238 m
.23333 .05752 L
.24444 .05752 L
.24444 .00238 L
F
.23333 .00238 m
.23333 .05752 L
.24444 .05752 L
.24444 .00238 L
.23333 .00238 L
s
.24444 .00238 m
.24444 .01742 L
.25556 .01742 L
.25556 .00238 L
F
.24444 .00238 m
.24444 .01742 L
.25556 .01742 L
.25556 .00238 L
.24444 .00238 L
s
.25556 .00238 m
.25556 .03246 L
.26667 .03246 L
.26667 .00238 L
F
.25556 .00238 m
.25556 .03246 L
.26667 .03246 L
.26667 .00238 L
.25556 .00238 L
s
.26667 .00238 m
.26667 .06253 L
.27778 .06253 L
.27778 .00238 L
F
.26667 .00238 m
.26667 .06253 L
.27778 .06253 L
.27778 .00238 L
.26667 .00238 L
s
.27778 .00238 m
.27778 .02744 L
.28889 .02744 L
.28889 .00238 L
F
.27778 .00238 m
.27778 .02744 L
.28889 .02744 L
.28889 .00238 L
.27778 .00238 L
s
.28889 .00238 m
.28889 .05251 L
.3 .05251 L
.3 .00238 L
F
.28889 .00238 m
.28889 .05251 L
.3 .05251 L
.3 .00238 L
.28889 .00238 L
s
.3 .00238 m
.3 .00739 L
.31111 .00739 L
.31111 .00238 L
F
.3 .00238 m
.3 .00739 L
.31111 .00739 L
.31111 .00238 L
.3 .00238 L
s
.31111 .00238 m
.31111 .01241 L
.32222 .01241 L
.32222 .00238 L
F
.31111 .00238 m
.31111 .01241 L
.32222 .01241 L
.32222 .00238 L
.31111 .00238 L
s
.32222 .00238 m
.32222 .02243 L
.33333 .02243 L
.33333 .00238 L
F
.32222 .00238 m
.32222 .02243 L
.33333 .02243 L
.33333 .00238 L
.32222 .00238 L
s
.33333 .00238 m
.33333 .04248 L
.34444 .04248 L
.34444 .00238 L
F
.33333 .00238 m
.33333 .04248 L
.34444 .04248 L
.34444 .00238 L
.33333 .00238 L
s
.34444 .00238 m
.34444 .08258 L
.35556 .08258 L
.35556 .00238 L
F
.34444 .00238 m
.34444 .08258 L
.35556 .08258 L
.35556 .00238 L
.34444 .00238 L
s
.35556 .00238 m
.35556 .06754 L
.36667 .06754 L
.36667 .00238 L
F
.35556 .00238 m
.35556 .06754 L
.36667 .06754 L
.36667 .00238 L
.35556 .00238 L
s
.36667 .00238 m
.36667 .03747 L
.37778 .03747 L
.37778 .00238 L
F
.36667 .00238 m
.36667 .03747 L
.37778 .03747 L
.37778 .00238 L
.36667 .00238 L
s
.37778 .00238 m
.37778 .07256 L
.38889 .07256 L
.38889 .00238 L
F
.37778 .00238 m
.37778 .07256 L
.38889 .07256 L
.38889 .00238 L
.37778 .00238 L
s
.38889 .00238 m
.38889 .04749 L
.4 .04749 L
.4 .00238 L
F
.38889 .00238 m
.38889 .04749 L
.4 .04749 L
.4 .00238 L
.38889 .00238 L
s
.4 .00238 m
.4 .09261 L
.41111 .09261 L
.41111 .00238 L
F
.4 .00238 m
.4 .09261 L
.41111 .09261 L
.41111 .00238 L
.4 .00238 L
s
.41111 .00238 m
.41111 .08759 L
.42222 .08759 L
.42222 .00238 L
F
.41111 .00238 m
.41111 .08759 L
.42222 .08759 L
.42222 .00238 L
.41111 .00238 L
s
.42222 .00238 m
.42222 .07757 L
.43333 .07757 L
.43333 .00238 L
F
.42222 .00238 m
.42222 .07757 L
.43333 .07757 L
.43333 .00238 L
.42222 .00238 L
s
.43333 .00238 m
.43333 .05752 L
.44444 .05752 L
.44444 .00238 L
F
.43333 .00238 m
.43333 .05752 L
.44444 .05752 L
.44444 .00238 L
.43333 .00238 L
s
.44444 .00238 m
.44444 .01742 L
.45556 .01742 L
.45556 .00238 L
F
.44444 .00238 m
.44444 .01742 L
.45556 .01742 L
.45556 .00238 L
.44444 .00238 L
s
.45556 .00238 m
.45556 .03246 L
.46667 .03246 L
.46667 .00238 L
F
.45556 .00238 m
.45556 .03246 L
.46667 .03246 L
.46667 .00238 L
.45556 .00238 L
s
.46667 .00238 m
.46667 .06253 L
.47778 .06253 L
.47778 .00238 L
F
.46667 .00238 m
.46667 .06253 L
.47778 .06253 L
.47778 .00238 L
.46667 .00238 L
s
.47778 .00238 m
.47778 .02744 L
.48889 .02744 L
.48889 .00238 L
F
.47778 .00238 m
.47778 .02744 L
.48889 .02744 L
.48889 .00238 L
.47778 .00238 L
s
.48889 .00238 m
.48889 .05251 L
.5 .05251 L
.5 .00238 L
F
.48889 .00238 m
.48889 .05251 L
.5 .05251 L
.5 .00238 L
.48889 .00238 L
s
.5 .00238 m
.5 .00739 L
.51111 .00739 L
.51111 .00238 L
F
.5 .00238 m
.5 .00739 L
.51111 .00739 L
.51111 .00238 L
.5 .00238 L
s
.51111 .00238 m
.51111 .01241 L
.52222 .01241 L
.52222 .00238 L
F
.51111 .00238 m
.51111 .01241 L
.52222 .01241 L
.52222 .00238 L
.51111 .00238 L
s
.52222 .00238 m
.52222 .02243 L
.53333 .02243 L
.53333 .00238 L
F
.52222 .00238 m
.52222 .02243 L
.53333 .02243 L
.53333 .00238 L
.52222 .00238 L
s
.53333 .00238 m
.53333 .04248 L
.54444 .04248 L
.54444 .00238 L
F
.53333 .00238 m
.53333 .04248 L
.54444 .04248 L
.54444 .00238 L
.53333 .00238 L
s
.54444 .00238 m
.54444 .08258 L
.55556 .08258 L
.55556 .00238 L
F
.54444 .00238 m
.54444 .08258 L
.55556 .08258 L
.55556 .00238 L
.54444 .00238 L
s
.55556 .00238 m
.55556 .06754 L
.56667 .06754 L
.56667 .00238 L
F
.55556 .00238 m
.55556 .06754 L
.56667 .06754 L
.56667 .00238 L
.55556 .00238 L
s
.56667 .00238 m
.56667 .03747 L
.57778 .03747 L
.57778 .00238 L
F
.56667 .00238 m
.56667 .03747 L
.57778 .03747 L
.57778 .00238 L
.56667 .00238 L
s
.57778 .00238 m
.57778 .07256 L
.58889 .07256 L
.58889 .00238 L
F
.57778 .00238 m
.57778 .07256 L
.58889 .07256 L
.58889 .00238 L
.57778 .00238 L
s
.58889 .00238 m
.58889 .04749 L
.6 .04749 L
.6 .00238 L
F
.58889 .00238 m
.58889 .04749 L
.6 .04749 L
.6 .00238 L
.58889 .00238 L
s
.6 .00238 m
.6 .09261 L
.61111 .09261 L
.61111 .00238 L
F
.6 .00238 m
.6 .09261 L
.61111 .09261 L
.61111 .00238 L
.6 .00238 L
s
.61111 .00238 m
.61111 .08759 L
.62222 .08759 L
.62222 .00238 L
F
.61111 .00238 m
.61111 .08759 L
.62222 .08759 L
.62222 .00238 L
.61111 .00238 L
s
.62222 .00238 m
.62222 .07757 L
.63333 .07757 L
.63333 .00238 L
F
.62222 .00238 m
.62222 .07757 L
.63333 .07757 L
.63333 .00238 L
.62222 .00238 L
s
.63333 .00238 m
.63333 .05752 L
.64444 .05752 L
.64444 .00238 L
F
.63333 .00238 m
.63333 .05752 L
.64444 .05752 L
.64444 .00238 L
.63333 .00238 L
s
.64444 .00238 m
.64444 .01742 L
.65556 .01742 L
.65556 .00238 L
F
.64444 .00238 m
.64444 .01742 L
.65556 .01742 L
.65556 .00238 L
.64444 .00238 L
s
.65556 .00238 m
.65556 .03246 L
.66667 .03246 L
.66667 .00238 L
F
.65556 .00238 m
.65556 .03246 L
.66667 .03246 L
.66667 .00238 L
.65556 .00238 L
s
.66667 .00238 m
.66667 .06253 L
.67778 .06253 L
.67778 .00238 L
F
.66667 .00238 m
.66667 .06253 L
.67778 .06253 L
.67778 .00238 L
.66667 .00238 L
s
.67778 .00238 m
.67778 .02744 L
.68889 .02744 L
.68889 .00238 L
F
.67778 .00238 m
.67778 .02744 L
.68889 .02744 L
.68889 .00238 L
.67778 .00238 L
s
.68889 .00238 m
.68889 .05251 L
.7 .05251 L
.7 .00238 L
F
.68889 .00238 m
.68889 .05251 L
.7 .05251 L
.7 .00238 L
.68889 .00238 L
s
.7 .00238 m
.7 .00739 L
.71111 .00739 L
.71111 .00238 L
F
.7 .00238 m
.7 .00739 L
.71111 .00739 L
.71111 .00238 L
.7 .00238 L
s
.71111 .00238 m
.71111 .01241 L
.72222 .01241 L
.72222 .00238 L
F
.71111 .00238 m
.71111 .01241 L
.72222 .01241 L
.72222 .00238 L
.71111 .00238 L
s
.72222 .00238 m
.72222 .02243 L
.73333 .02243 L
.73333 .00238 L
F
.72222 .00238 m
.72222 .02243 L
.73333 .02243 L
.73333 .00238 L
.72222 .00238 L
s
.73333 .00238 m
.73333 .04248 L
.74444 .04248 L
.74444 .00238 L
F
.73333 .00238 m
.73333 .04248 L
.74444 .04248 L
.74444 .00238 L
.73333 .00238 L
s
.74444 .00238 m
.74444 .08258 L
.75556 .08258 L
.75556 .00238 L
F
.74444 .00238 m
.74444 .08258 L
.75556 .08258 L
.75556 .00238 L
.74444 .00238 L
s
.75556 .00238 m
.75556 .06754 L
.76667 .06754 L
.76667 .00238 L
F
.75556 .00238 m
.75556 .06754 L
.76667 .06754 L
.76667 .00238 L
.75556 .00238 L
s
.76667 .00238 m
.76667 .03747 L
.77778 .03747 L
.77778 .00238 L
F
.76667 .00238 m
.76667 .03747 L
.77778 .03747 L
.77778 .00238 L
.76667 .00238 L
s
.77778 .00238 m
.77778 .07256 L
.78889 .07256 L
.78889 .00238 L
F
.77778 .00238 m
.77778 .07256 L
.78889 .07256 L
.78889 .00238 L
.77778 .00238 L
s
.78889 .00238 m
.78889 .04749 L
.8 .04749 L
.8 .00238 L
F
.78889 .00238 m
.78889 .04749 L
.8 .04749 L
.8 .00238 L
.78889 .00238 L
s
.8 .00238 m
.8 .09261 L
.81111 .09261 L
.81111 .00238 L
F
.8 .00238 m
.8 .09261 L
.81111 .09261 L
.81111 .00238 L
.8 .00238 L
s
.81111 .00238 m
.81111 .08759 L
.82222 .08759 L
.82222 .00238 L
F
.81111 .00238 m
.81111 .08759 L
.82222 .08759 L
.82222 .00238 L
.81111 .00238 L
s
.82222 .00238 m
.82222 .07757 L
.83333 .07757 L
.83333 .00238 L
F
.82222 .00238 m
.82222 .07757 L
.83333 .07757 L
.83333 .00238 L
.82222 .00238 L
s
.83333 .00238 m
.83333 .05752 L
.84444 .05752 L
.84444 .00238 L
F
.83333 .00238 m
.83333 .05752 L
.84444 .05752 L
.84444 .00238 L
.83333 .00238 L
s
.84444 .00238 m
.84444 .01742 L
.85556 .01742 L
.85556 .00238 L
F
.84444 .00238 m
.84444 .01742 L
.85556 .01742 L
.85556 .00238 L
.84444 .00238 L
s
.85556 .00238 m
.85556 .03246 L
.86667 .03246 L
.86667 .00238 L
F
.85556 .00238 m
.85556 .03246 L
.86667 .03246 L
.86667 .00238 L
.85556 .00238 L
s
.86667 .00238 m
.86667 .06253 L
.87778 .06253 L
.87778 .00238 L
F
.86667 .00238 m
.86667 .06253 L
.87778 .06253 L
.87778 .00238 L
.86667 .00238 L
s
.87778 .00238 m
.87778 .02744 L
.88889 .02744 L
.88889 .00238 L
F
.87778 .00238 m
.87778 .02744 L
.88889 .02744 L
.88889 .00238 L
.87778 .00238 L
s
.88889 .00238 m
.88889 .05251 L
.9 .05251 L
.9 .00238 L
F
.88889 .00238 m
.88889 .05251 L
.9 .05251 L
.9 .00238 L
.88889 .00238 L
s
.9 .00238 m
.9 .00739 L
.91111 .00739 L
.91111 .00238 L
F
.9 .00238 m
.9 .00739 L
.91111 .00739 L
.91111 .00238 L
.9 .00238 L
s
.91111 .00238 m
.91111 .01241 L
.92222 .01241 L
.92222 .00238 L
F
.91111 .00238 m
.91111 .01241 L
.92222 .01241 L
.92222 .00238 L
.91111 .00238 L
s
.92222 .00238 m
.92222 .02243 L
.93333 .02243 L
.93333 .00238 L
F
.92222 .00238 m
.92222 .02243 L
.93333 .02243 L
.93333 .00238 L
.92222 .00238 L
s
.93333 .00238 m
.93333 .04248 L
.94444 .04248 L
.94444 .00238 L
F
.93333 .00238 m
.93333 .04248 L
.94444 .04248 L
.94444 .00238 L
.93333 .00238 L
s
.94444 .00238 m
.94444 .08258 L
.95556 .08258 L
.95556 .00238 L
F
.94444 .00238 m
.94444 .08258 L
.95556 .08258 L
.95556 .00238 L
.94444 .00238 L
s
.95556 .00238 m
.95556 .06754 L
.96667 .06754 L
.96667 .00238 L
F
.95556 .00238 m
.95556 .06754 L
.96667 .06754 L
.96667 .00238 L
.95556 .00238 L
s
.96667 .00238 m
.96667 .03747 L
.97778 .03747 L
.97778 .00238 L
F
.96667 .00238 m
.96667 .03747 L
.97778 .03747 L
.97778 .00238 L
.96667 .00238 L
s
.97778 .00238 m
.97778 .07256 L
.98889 .07256 L
.98889 .00238 L
F
.97778 .00238 m
.97778 .07256 L
.98889 .07256 L
.98889 .00238 L
.97778 .00238 L
s
.98889 .00238 m
.98889 .04749 L
1 .04749 L
1 .00238 L
F
.98889 .00238 m
.98889 .04749 L
1 .04749 L
1 .00238 L
.98889 .00238 L
s
1 g
0 .09261 m
0 .09762 L
.01111 .09762 L
.01111 .09261 L
F
0 g
0 .09261 m
0 .09762 L
.01111 .09762 L
.01111 .09261 L
0 .09261 L
s
1 g
.01111 .08759 m
.01111 .09762 L
.02222 .09762 L
.02222 .08759 L
F
0 g
.01111 .08759 m
.01111 .09762 L
.02222 .09762 L
.02222 .08759 L
.01111 .08759 L
s
1 g
.02222 .07757 m
.02222 .09762 L
.03333 .09762 L
.03333 .07757 L
F
0 g
.02222 .07757 m
.02222 .09762 L
.03333 .09762 L
.03333 .07757 L
.02222 .07757 L
s
1 g
.03333 .05752 m
.03333 .09762 L
.04444 .09762 L
.04444 .05752 L
F
0 g
.03333 .05752 m
.03333 .09762 L
.04444 .09762 L
.04444 .05752 L
.03333 .05752 L
s
1 g
.04444 .01742 m
.04444 .09762 L
.05556 .09762 L
.05556 .01742 L
F
0 g
.04444 .01742 m
.04444 .09762 L
.05556 .09762 L
.05556 .01742 L
.04444 .01742 L
s
1 g
.05556 .03246 m
.05556 .09762 L
.06667 .09762 L
.06667 .03246 L
F
0 g
.05556 .03246 m
.05556 .09762 L
.06667 .09762 L
.06667 .03246 L
.05556 .03246 L
s
1 g
.06667 .06253 m
.06667 .09762 L
.07778 .09762 L
.07778 .06253 L
F
0 g
.06667 .06253 m
.06667 .09762 L
.07778 .09762 L
.07778 .06253 L
.06667 .06253 L
s
1 g
.07778 .02744 m
.07778 .09762 L
.08889 .09762 L
.08889 .02744 L
F
0 g
.07778 .02744 m
.07778 .09762 L
.08889 .09762 L
.08889 .02744 L
.07778 .02744 L
s
1 g
.08889 .05251 m
.08889 .09762 L
.1 .09762 L
.1 .05251 L
F
0 g
.08889 .05251 m
.08889 .09762 L
.1 .09762 L
.1 .05251 L
.08889 .05251 L
s
1 g
.1 .00739 m
.1 .09762 L
.11111 .09762 L
.11111 .00739 L
F
0 g
.1 .00739 m
.1 .09762 L
.11111 .09762 L
.11111 .00739 L
.1 .00739 L
s
1 g
.11111 .01241 m
.11111 .09762 L
.12222 .09762 L
.12222 .01241 L
F
0 g
.11111 .01241 m
.11111 .09762 L
.12222 .09762 L
.12222 .01241 L
.11111 .01241 L
s
1 g
.12222 .02243 m
.12222 .09762 L
.13333 .09762 L
.13333 .02243 L
F
0 g
.12222 .02243 m
.12222 .09762 L
.13333 .09762 L
.13333 .02243 L
.12222 .02243 L
s
1 g
.13333 .04248 m
.13333 .09762 L
.14444 .09762 L
.14444 .04248 L
F
0 g
.13333 .04248 m
.13333 .09762 L
.14444 .09762 L
.14444 .04248 L
.13333 .04248 L
s
1 g
.14444 .08258 m
.14444 .09762 L
.15556 .09762 L
.15556 .08258 L
F
0 g
.14444 .08258 m
.14444 .09762 L
.15556 .09762 L
.15556 .08258 L
.14444 .08258 L
s
1 g
.15556 .06754 m
.15556 .09762 L
.16667 .09762 L
.16667 .06754 L
F
0 g
.15556 .06754 m
.15556 .09762 L
.16667 .09762 L
.16667 .06754 L
.15556 .06754 L
s
1 g
.16667 .03747 m
.16667 .09762 L
.17778 .09762 L
.17778 .03747 L
F
0 g
.16667 .03747 m
.16667 .09762 L
.17778 .09762 L
.17778 .03747 L
.16667 .03747 L
s
1 g
.17778 .07256 m
.17778 .09762 L
.18889 .09762 L
.18889 .07256 L
F
0 g
.17778 .07256 m
.17778 .09762 L
.18889 .09762 L
.18889 .07256 L
.17778 .07256 L
s
1 g
.18889 .04749 m
.18889 .09762 L
.2 .09762 L
.2 .04749 L
F
0 g
.18889 .04749 m
.18889 .09762 L
.2 .09762 L
.2 .04749 L
.18889 .04749 L
s
1 g
.2 .09261 m
.2 .09762 L
.21111 .09762 L
.21111 .09261 L
F
0 g
.2 .09261 m
.2 .09762 L
.21111 .09762 L
.21111 .09261 L
.2 .09261 L
s
1 g
.21111 .08759 m
.21111 .09762 L
.22222 .09762 L
.22222 .08759 L
F
0 g
.21111 .08759 m
.21111 .09762 L
.22222 .09762 L
.22222 .08759 L
.21111 .08759 L
s
1 g
.22222 .07757 m
.22222 .09762 L
.23333 .09762 L
.23333 .07757 L
F
0 g
.22222 .07757 m
.22222 .09762 L
.23333 .09762 L
.23333 .07757 L
.22222 .07757 L
s
1 g
.23333 .05752 m
.23333 .09762 L
.24444 .09762 L
.24444 .05752 L
F
0 g
.23333 .05752 m
.23333 .09762 L
.24444 .09762 L
.24444 .05752 L
.23333 .05752 L
s
1 g
.24444 .01742 m
.24444 .09762 L
.25556 .09762 L
.25556 .01742 L
F
0 g
.24444 .01742 m
.24444 .09762 L
.25556 .09762 L
.25556 .01742 L
.24444 .01742 L
s
1 g
.25556 .03246 m
.25556 .09762 L
.26667 .09762 L
.26667 .03246 L
F
0 g
.25556 .03246 m
.25556 .09762 L
.26667 .09762 L
.26667 .03246 L
.25556 .03246 L
s
1 g
.26667 .06253 m
.26667 .09762 L
.27778 .09762 L
.27778 .06253 L
F
0 g
.26667 .06253 m
.26667 .09762 L
.27778 .09762 L
.27778 .06253 L
.26667 .06253 L
s
1 g
.27778 .02744 m
.27778 .09762 L
.28889 .09762 L
.28889 .02744 L
F
0 g
.27778 .02744 m
.27778 .09762 L
.28889 .09762 L
.28889 .02744 L
.27778 .02744 L
s
1 g
.28889 .05251 m
.28889 .09762 L
.3 .09762 L
.3 .05251 L
F
0 g
.28889 .05251 m
.28889 .09762 L
.3 .09762 L
.3 .05251 L
.28889 .05251 L
s
1 g
.3 .00739 m
.3 .09762 L
.31111 .09762 L
.31111 .00739 L
F
0 g
.3 .00739 m
.3 .09762 L
.31111 .09762 L
.31111 .00739 L
.3 .00739 L
s
1 g
.31111 .01241 m
.31111 .09762 L
.32222 .09762 L
.32222 .01241 L
F
0 g
.31111 .01241 m
.31111 .09762 L
.32222 .09762 L
.32222 .01241 L
.31111 .01241 L
s
1 g
.32222 .02243 m
.32222 .09762 L
.33333 .09762 L
.33333 .02243 L
F
0 g
.32222 .02243 m
.32222 .09762 L
.33333 .09762 L
.33333 .02243 L
.32222 .02243 L
s
1 g
.33333 .04248 m
.33333 .09762 L
.34444 .09762 L
.34444 .04248 L
F
0 g
.33333 .04248 m
.33333 .09762 L
.34444 .09762 L
.34444 .04248 L
.33333 .04248 L
s
1 g
.34444 .08258 m
.34444 .09762 L
.35556 .09762 L
.35556 .08258 L
F
0 g
.34444 .08258 m
.34444 .09762 L
.35556 .09762 L
.35556 .08258 L
.34444 .08258 L
s
1 g
.35556 .06754 m
.35556 .09762 L
.36667 .09762 L
.36667 .06754 L
F
0 g
.35556 .06754 m
.35556 .09762 L
.36667 .09762 L
.36667 .06754 L
.35556 .06754 L
s
1 g
.36667 .03747 m
.36667 .09762 L
.37778 .09762 L
.37778 .03747 L
F
0 g
.36667 .03747 m
.36667 .09762 L
.37778 .09762 L
.37778 .03747 L
.36667 .03747 L
s
1 g
.37778 .07256 m
.37778 .09762 L
.38889 .09762 L
.38889 .07256 L
F
0 g
.37778 .07256 m
.37778 .09762 L
.38889 .09762 L
.38889 .07256 L
.37778 .07256 L
s
1 g
.38889 .04749 m
.38889 .09762 L
.4 .09762 L
.4 .04749 L
F
0 g
.38889 .04749 m
.38889 .09762 L
.4 .09762 L
.4 .04749 L
.38889 .04749 L
s
1 g
.4 .09261 m
.4 .09762 L
.41111 .09762 L
.41111 .09261 L
F
0 g
.4 .09261 m
.4 .09762 L
.41111 .09762 L
.41111 .09261 L
.4 .09261 L
s
1 g
.41111 .08759 m
.41111 .09762 L
.42222 .09762 L
.42222 .08759 L
F
0 g
.41111 .08759 m
.41111 .09762 L
.42222 .09762 L
.42222 .08759 L
.41111 .08759 L
s
1 g
.42222 .07757 m
.42222 .09762 L
.43333 .09762 L
.43333 .07757 L
F
0 g
.42222 .07757 m
.42222 .09762 L
.43333 .09762 L
.43333 .07757 L
.42222 .07757 L
s
1 g
.43333 .05752 m
.43333 .09762 L
.44444 .09762 L
.44444 .05752 L
F
0 g
.43333 .05752 m
.43333 .09762 L
.44444 .09762 L
.44444 .05752 L
.43333 .05752 L
s
1 g
.44444 .01742 m
.44444 .09762 L
.45556 .09762 L
.45556 .01742 L
F
0 g
.44444 .01742 m
.44444 .09762 L
.45556 .09762 L
.45556 .01742 L
.44444 .01742 L
s
1 g
.45556 .03246 m
.45556 .09762 L
.46667 .09762 L
.46667 .03246 L
F
0 g
.45556 .03246 m
.45556 .09762 L
.46667 .09762 L
.46667 .03246 L
.45556 .03246 L
s
1 g
.46667 .06253 m
.46667 .09762 L
.47778 .09762 L
.47778 .06253 L
F
0 g
.46667 .06253 m
.46667 .09762 L
.47778 .09762 L
.47778 .06253 L
.46667 .06253 L
s
1 g
.47778 .02744 m
.47778 .09762 L
.48889 .09762 L
.48889 .02744 L
F
0 g
.47778 .02744 m
.47778 .09762 L
.48889 .09762 L
.48889 .02744 L
.47778 .02744 L
s
1 g
.48889 .05251 m
.48889 .09762 L
.5 .09762 L
.5 .05251 L
F
0 g
.48889 .05251 m
.48889 .09762 L
.5 .09762 L
.5 .05251 L
.48889 .05251 L
s
1 g
.5 .00739 m
.5 .09762 L
.51111 .09762 L
.51111 .00739 L
F
0 g
.5 .00739 m
.5 .09762 L
.51111 .09762 L
.51111 .00739 L
.5 .00739 L
s
1 g
.51111 .01241 m
.51111 .09762 L
.52222 .09762 L
.52222 .01241 L
F
0 g
.51111 .01241 m
.51111 .09762 L
.52222 .09762 L
.52222 .01241 L
.51111 .01241 L
s
1 g
.52222 .02243 m
.52222 .09762 L
.53333 .09762 L
.53333 .02243 L
F
0 g
.52222 .02243 m
.52222 .09762 L
.53333 .09762 L
.53333 .02243 L
.52222 .02243 L
s
1 g
.53333 .04248 m
.53333 .09762 L
.54444 .09762 L
.54444 .04248 L
F
0 g
.53333 .04248 m
.53333 .09762 L
.54444 .09762 L
.54444 .04248 L
.53333 .04248 L
s
1 g
.54444 .08258 m
.54444 .09762 L
.55556 .09762 L
.55556 .08258 L
F
0 g
.54444 .08258 m
.54444 .09762 L
.55556 .09762 L
.55556 .08258 L
.54444 .08258 L
s
1 g
.55556 .06754 m
.55556 .09762 L
.56667 .09762 L
.56667 .06754 L
F
0 g
.55556 .06754 m
.55556 .09762 L
.56667 .09762 L
.56667 .06754 L
.55556 .06754 L
s
1 g
.56667 .03747 m
.56667 .09762 L
.57778 .09762 L
.57778 .03747 L
F
0 g
.56667 .03747 m
.56667 .09762 L
.57778 .09762 L
.57778 .03747 L
.56667 .03747 L
s
1 g
.57778 .07256 m
.57778 .09762 L
.58889 .09762 L
.58889 .07256 L
F
0 g
.57778 .07256 m
.57778 .09762 L
.58889 .09762 L
.58889 .07256 L
.57778 .07256 L
s
1 g
.58889 .04749 m
.58889 .09762 L
.6 .09762 L
.6 .04749 L
F
0 g
.58889 .04749 m
.58889 .09762 L
.6 .09762 L
.6 .04749 L
.58889 .04749 L
s
1 g
.6 .09261 m
.6 .09762 L
.61111 .09762 L
.61111 .09261 L
F
0 g
.6 .09261 m
.6 .09762 L
.61111 .09762 L
.61111 .09261 L
.6 .09261 L
s
1 g
.61111 .08759 m
.61111 .09762 L
.62222 .09762 L
.62222 .08759 L
F
0 g
.61111 .08759 m
.61111 .09762 L
.62222 .09762 L
.62222 .08759 L
.61111 .08759 L
s
1 g
.62222 .07757 m
.62222 .09762 L
.63333 .09762 L
.63333 .07757 L
F
0 g
.62222 .07757 m
.62222 .09762 L
.63333 .09762 L
.63333 .07757 L
.62222 .07757 L
s
1 g
.63333 .05752 m
.63333 .09762 L
.64444 .09762 L
.64444 .05752 L
F
0 g
.63333 .05752 m
.63333 .09762 L
.64444 .09762 L
.64444 .05752 L
.63333 .05752 L
s
1 g
.64444 .01742 m
.64444 .09762 L
.65556 .09762 L
.65556 .01742 L
F
0 g
.64444 .01742 m
.64444 .09762 L
.65556 .09762 L
.65556 .01742 L
.64444 .01742 L
s
1 g
.65556 .03246 m
.65556 .09762 L
.66667 .09762 L
.66667 .03246 L
F
0 g
.65556 .03246 m
.65556 .09762 L
.66667 .09762 L
.66667 .03246 L
.65556 .03246 L
s
1 g
.66667 .06253 m
.66667 .09762 L
.67778 .09762 L
.67778 .06253 L
F
0 g
.66667 .06253 m
.66667 .09762 L
.67778 .09762 L
.67778 .06253 L
.66667 .06253 L
s
1 g
.67778 .02744 m
.67778 .09762 L
.68889 .09762 L
.68889 .02744 L
F
0 g
.67778 .02744 m
.67778 .09762 L
.68889 .09762 L
.68889 .02744 L
.67778 .02744 L
s
1 g
.68889 .05251 m
.68889 .09762 L
.7 .09762 L
.7 .05251 L
F
0 g
.68889 .05251 m
.68889 .09762 L
.7 .09762 L
.7 .05251 L
.68889 .05251 L
s
1 g
.7 .00739 m
.7 .09762 L
.71111 .09762 L
.71111 .00739 L
F
0 g
.7 .00739 m
.7 .09762 L
.71111 .09762 L
.71111 .00739 L
.7 .00739 L
s
1 g
.71111 .01241 m
.71111 .09762 L
.72222 .09762 L
.72222 .01241 L
F
0 g
.71111 .01241 m
.71111 .09762 L
.72222 .09762 L
.72222 .01241 L
.71111 .01241 L
s
1 g
.72222 .02243 m
.72222 .09762 L
.73333 .09762 L
.73333 .02243 L
F
0 g
.72222 .02243 m
.72222 .09762 L
.73333 .09762 L
.73333 .02243 L
.72222 .02243 L
s
1 g
.73333 .04248 m
.73333 .09762 L
.74444 .09762 L
.74444 .04248 L
F
0 g
.73333 .04248 m
.73333 .09762 L
.74444 .09762 L
.74444 .04248 L
.73333 .04248 L
s
1 g
.74444 .08258 m
.74444 .09762 L
.75556 .09762 L
.75556 .08258 L
F
0 g
.74444 .08258 m
.74444 .09762 L
.75556 .09762 L
.75556 .08258 L
.74444 .08258 L
s
1 g
.75556 .06754 m
.75556 .09762 L
.76667 .09762 L
.76667 .06754 L
F
0 g
.75556 .06754 m
.75556 .09762 L
.76667 .09762 L
.76667 .06754 L
.75556 .06754 L
s
1 g
.76667 .03747 m
.76667 .09762 L
.77778 .09762 L
.77778 .03747 L
F
0 g
.76667 .03747 m
.76667 .09762 L
.77778 .09762 L
.77778 .03747 L
.76667 .03747 L
s
1 g
.77778 .07256 m
.77778 .09762 L
.78889 .09762 L
.78889 .07256 L
F
0 g
.77778 .07256 m
.77778 .09762 L
.78889 .09762 L
.78889 .07256 L
.77778 .07256 L
s
1 g
.78889 .04749 m
.78889 .09762 L
.8 .09762 L
.8 .04749 L
F
0 g
.78889 .04749 m
.78889 .09762 L
.8 .09762 L
.8 .04749 L
.78889 .04749 L
s
1 g
.8 .09261 m
.8 .09762 L
.81111 .09762 L
.81111 .09261 L
F
0 g
.8 .09261 m
.8 .09762 L
.81111 .09762 L
.81111 .09261 L
.8 .09261 L
s
1 g
.81111 .08759 m
.81111 .09762 L
.82222 .09762 L
.82222 .08759 L
F
0 g
.81111 .08759 m
.81111 .09762 L
.82222 .09762 L
.82222 .08759 L
.81111 .08759 L
s
1 g
.82222 .07757 m
.82222 .09762 L
.83333 .09762 L
.83333 .07757 L
F
0 g
.82222 .07757 m
.82222 .09762 L
.83333 .09762 L
.83333 .07757 L
.82222 .07757 L
s
1 g
.83333 .05752 m
.83333 .09762 L
.84444 .09762 L
.84444 .05752 L
F
0 g
.83333 .05752 m
.83333 .09762 L
.84444 .09762 L
.84444 .05752 L
.83333 .05752 L
s
1 g
.84444 .01742 m
.84444 .09762 L
.85556 .09762 L
.85556 .01742 L
F
0 g
.84444 .01742 m
.84444 .09762 L
.85556 .09762 L
.85556 .01742 L
.84444 .01742 L
s
1 g
.85556 .03246 m
.85556 .09762 L
.86667 .09762 L
.86667 .03246 L
F
0 g
.85556 .03246 m
.85556 .09762 L
.86667 .09762 L
.86667 .03246 L
.85556 .03246 L
s
1 g
.86667 .06253 m
.86667 .09762 L
.87778 .09762 L
.87778 .06253 L
F
0 g
.86667 .06253 m
.86667 .09762 L
.87778 .09762 L
.87778 .06253 L
.86667 .06253 L
s
1 g
.87778 .02744 m
.87778 .09762 L
.88889 .09762 L
.88889 .02744 L
F
0 g
.87778 .02744 m
.87778 .09762 L
.88889 .09762 L
.88889 .02744 L
.87778 .02744 L
s
1 g
.88889 .05251 m
.88889 .09762 L
.9 .09762 L
.9 .05251 L
F
0 g
.88889 .05251 m
.88889 .09762 L
.9 .09762 L
.9 .05251 L
.88889 .05251 L
s
1 g
.9 .00739 m
.9 .09762 L
.91111 .09762 L
.91111 .00739 L
F
0 g
.9 .00739 m
.9 .09762 L
.91111 .09762 L
.91111 .00739 L
.9 .00739 L
s
1 g
.91111 .01241 m
.91111 .09762 L
.92222 .09762 L
.92222 .01241 L
F
0 g
.91111 .01241 m
.91111 .09762 L
.92222 .09762 L
.92222 .01241 L
.91111 .01241 L
s
1 g
.92222 .02243 m
.92222 .09762 L
.93333 .09762 L
.93333 .02243 L
F
0 g
.92222 .02243 m
.92222 .09762 L
.93333 .09762 L
.93333 .02243 L
.92222 .02243 L
s
1 g
.93333 .04248 m
.93333 .09762 L
.94444 .09762 L
.94444 .04248 L
F
0 g
.93333 .04248 m
.93333 .09762 L
.94444 .09762 L
.94444 .04248 L
.93333 .04248 L
s
1 g
.94444 .08258 m
.94444 .09762 L
.95556 .09762 L
.95556 .08258 L
F
0 g
.94444 .08258 m
.94444 .09762 L
.95556 .09762 L
.95556 .08258 L
.94444 .08258 L
s
1 g
.95556 .06754 m
.95556 .09762 L
.96667 .09762 L
.96667 .06754 L
F
0 g
.95556 .06754 m
.95556 .09762 L
.96667 .09762 L
.96667 .06754 L
.95556 .06754 L
s
1 g
.96667 .03747 m
.96667 .09762 L
.97778 .09762 L
.97778 .03747 L
F
0 g
.96667 .03747 m
.96667 .09762 L
.97778 .09762 L
.97778 .03747 L
.96667 .03747 L
s
1 g
.97778 .07256 m
.97778 .09762 L
.98889 .09762 L
.98889 .07256 L
F
0 g
.97778 .07256 m
.97778 .09762 L
.98889 .09762 L
.98889 .07256 L
.97778 .07256 L
s
1 g
.98889 .04749 m
.98889 .09762 L
1 .09762 L
1 .04749 L
F
0 g
.98889 .04749 m
.98889 .09762 L
1 .09762 L
1 .04749 L
.98889 .04749 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.0.8"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[8]= ",
 CellTags->"S5.0.8"]
}, Open  ]],

Cell["\<\
Using a simple model of the complex amplitude of the reflected wave, it can \
be shown that the spectrum is flat except at zero. This implies that the wave \
is reflected in all directions except the specular direction. \
\>", "Text",
 CellTags->{"S5.0.8", "8.14"}],

Cell["\<\
Equal intensity is scattered into all diffraction orders except the zero \
order. \
\>", "MathCaption",
 CellTags->{"S5.0.8", "8.15"}],

Cell[CellGroupData[{

Cell["\<\
(reflected = Map[Exp[I 2 Pi #/p]&, array];
powerspectrum = Abs[Fourier[reflected]]^2;
ListPlot[powerspectrum, AxesOrigin -> {0, 0},
 PlotJoined -> True, PlotRange -> All])\
\>", "Input",
 CellLabel->"In[9]:= ",
 CellTags->"S5.0.8"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0322129 0.0560224 -0.0179851 0.588604 [
[.10784 -0.03049 -9 -9 ]
[.10784 -0.03049 9 0 ]
[.2479 -0.03049 -3 -9 ]
[.2479 -0.03049 3 0 ]
[.38796 -0.03049 -9 -9 ]
[.38796 -0.03049 9 0 ]
[.52801 -0.03049 -6 -9 ]
[.52801 -0.03049 6 0 ]
[.66807 -0.03049 -12 -9 ]
[.66807 -0.03049 12 0 ]
[.80812 -0.03049 -6 -9 ]
[.80812 -0.03049 6 0 ]
[.94818 -0.03049 -12 -9 ]
[.94818 -0.03049 12 0 ]
[-0.04471 .09974 -18 -4.5 ]
[-0.04471 .09974 0 4.5 ]
[-0.04471 .21746 -18 -4.5 ]
[-0.04471 .21746 0 4.5 ]
[-0.04471 .33518 -18 -4.5 ]
[-0.04471 .33518 0 4.5 ]
[-0.04471 .4529 -18 -4.5 ]
[-0.04471 .4529 0 4.5 ]
[-0.04471 .57062 -6 -4.5 ]
[-0.04471 .57062 0 4.5 ]
[ -0.03221 -0.01799 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10784 -0.01799 m
.10784 -0.01174 L
s
[(2.5)] .10784 -0.03049 0 1 Mshowa
.2479 -0.01799 m
.2479 -0.01174 L
s
[(5)] .2479 -0.03049 0 1 Mshowa
.38796 -0.01799 m
.38796 -0.01174 L
s
[(7.5)] .38796 -0.03049 0 1 Mshowa
.52801 -0.01799 m
.52801 -0.01174 L
s
[(10)] .52801 -0.03049 0 1 Mshowa
.66807 -0.01799 m
.66807 -0.01174 L
s
[(12.5)] .66807 -0.03049 0 1 Mshowa
.80812 -0.01799 m
.80812 -0.01174 L
s
[(15)] .80812 -0.03049 0 1 Mshowa
.94818 -0.01799 m
.94818 -0.01174 L
s
[(17.5)] .94818 -0.03049 0 1 Mshowa
.125 Mabswid
.13585 -0.01799 m
.13585 -0.01424 L
s
.16387 -0.01799 m
.16387 -0.01424 L
s
.19188 -0.01799 m
.19188 -0.01424 L
s
.21989 -0.01799 m
.21989 -0.01424 L
s
.27591 -0.01799 m
.27591 -0.01424 L
s
.30392 -0.01799 m
.30392 -0.01424 L
s
.33193 -0.01799 m
.33193 -0.01424 L
s
.35994 -0.01799 m
.35994 -0.01424 L
s
.41597 -0.01799 m
.41597 -0.01424 L
s
.44398 -0.01799 m
.44398 -0.01424 L
s
.47199 -0.01799 m
.47199 -0.01424 L
s
.5 -0.01799 m
.5 -0.01424 L
s
.55602 -0.01799 m
.55602 -0.01424 L
s
.58403 -0.01799 m
.58403 -0.01424 L
s
.61204 -0.01799 m
.61204 -0.01424 L
s
.64006 -0.01799 m
.64006 -0.01424 L
s
.69608 -0.01799 m
.69608 -0.01424 L
s
.72409 -0.01799 m
.72409 -0.01424 L
s
.7521 -0.01799 m
.7521 -0.01424 L
s
.78011 -0.01799 m
.78011 -0.01424 L
s
.83613 -0.01799 m
.83613 -0.01424 L
s
.86415 -0.01799 m
.86415 -0.01424 L
s
.89216 -0.01799 m
.89216 -0.01424 L
s
.92017 -0.01799 m
.92017 -0.01424 L
s
.07983 -0.01799 m
.07983 -0.01424 L
s
.05182 -0.01799 m
.05182 -0.01424 L
s
.02381 -0.01799 m
.02381 -0.01424 L
s
.97619 -0.01799 m
.97619 -0.01424 L
s
.25 Mabswid
0 -0.01799 m
1 -0.01799 L
s
-0.03221 .09974 m
-0.02596 .09974 L
s
[(0.2)] -0.04471 .09974 1 0 Mshowa
-0.03221 .21746 m
-0.02596 .21746 L
s
[(0.4)] -0.04471 .21746 1 0 Mshowa
-0.03221 .33518 m
-0.02596 .33518 L
s
[(0.6)] -0.04471 .33518 1 0 Mshowa
-0.03221 .4529 m
-0.02596 .4529 L
s
[(0.8)] -0.04471 .4529 1 0 Mshowa
-0.03221 .57062 m
-0.02596 .57062 L
s
[(1)] -0.04471 .57062 1 0 Mshowa
.125 Mabswid
-0.03221 .12917 m
-0.02846 .12917 L
s
-0.03221 .1586 m
-0.02846 .1586 L
s
-0.03221 .18803 m
-0.02846 .18803 L
s
-0.03221 .24689 m
-0.02846 .24689 L
s
-0.03221 .27632 m
-0.02846 .27632 L
s
-0.03221 .30575 m
-0.02846 .30575 L
s
-0.03221 .36461 m
-0.02846 .36461 L
s
-0.03221 .39404 m
-0.02846 .39404 L
s
-0.03221 .42347 m
-0.02846 .42347 L
s
-0.03221 .48233 m
-0.02846 .48233 L
s
-0.03221 .51176 m
-0.02846 .51176 L
s
-0.03221 .54119 m
-0.02846 .54119 L
s
-0.03221 .07031 m
-0.02846 .07031 L
s
-0.03221 .04088 m
-0.02846 .04088 L
s
-0.03221 .01145 m
-0.02846 .01145 L
s
-0.03221 .60005 m
-0.02846 .60005 L
s
.25 Mabswid
-0.03221 0 m
-0.03221 .61803 L
s
.5 Mabswid
.02381 .01472 m
.07983 .60332 L
.13585 .60332 L
.19188 .60332 L
.2479 .60332 L
.30392 .60332 L
.35994 .60332 L
.41597 .60332 L
.47199 .60332 L
.52801 .60332 L
.58403 .60332 L
.64006 .60332 L
.69608 .60332 L
.7521 .60332 L
.80812 .60332 L
.86415 .60332 L
.92017 .60332 L
.97619 .60332 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.0.8"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[9]= ",
 CellTags->"S5.0.8"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Numerical Mathematics Packages", "Subsection",
 CellTags->{"S5.0.9", "9.1"}],

Cell[TextData[{
 "The standard add\[Hyphen]on packages for numerical mathematics extend the \
set of built\[Hyphen]in numerical functions, and take advantage of the \
arbitrary\[Hyphen]precision arithmetic that is the foundation of numerical \
computations in ",
 StyleBox["Mathematica", "TI"],
 ". The ",
 StyleBox["NumericalMath", "MR"],
 " packages provide fitting functions (polynomial, spline, trigonometric), \
numerical versions of some of the kernel functions (",
 StyleBox["ND", "MR"],
 ", ",
 StyleBox["NLimit", "MR"],
 ", ",
 StyleBox["NResidue", "MR"],
 ", ",
 StyleBox["NSeries", "MR"],
 "), numerical integration functions (",
 StyleBox["CauchyPrincipalValue", "MR"],
 ", ",
 StyleBox["ListIntegrate", "MR"],
 ", ",
 StyleBox["NIntegrateInterpolationFunction", "MR"],
 "), support for numerical solution of differential equations (",
 StyleBox["BesselZeros", "MR"],
 ", ",
 StyleBox["Butcher", "MR"],
 ", ",
 StyleBox["OrderStar", "MR"],
 "), alternatives to ",
 StyleBox["FindRoot", "MR"],
 " using interpolation or interval methods, functions for approximating by a \
ratio of polynomials, and pedagogical functions for exploring floating\
\[Hyphen]point arithmetic and numerical quadrature. "
}], "Text",
 CellTags->{"S5.0.9", "9.2"}],

Cell["\<\
This initializes the numerical mathematics packages so that they load as \
needed. \
\>", "MathCaption",
 CellTags->{"S5.0.9", "9.3"}],

Cell["<<NumericalMath`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.0.9"],

Cell["Here is a set of points that lie approximately on a circle. ", \
"MathCaption",
 CellTags->{"S5.0.9", "9.4"}],

Cell[CellGroupData[{

Cell["\<\
(data = Table[(x = Random[Real, {-1, 1}];
  Table[Random[Real, {-.1, .1}], {2}] +
  {x, Sign[.5 - Random[]] Sqrt[1 - x^2]}), {15}];
ListPlot[data, AspectRatio -> 1,
        Ticks -> {{-1., -.5, .5, 1.}, Automatic}])\
\>", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.0.9"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.507119 0.543533 0.457135 0.478783 [
[.23535 .44464 -12 -9 ]
[.23535 .44464 12 0 ]
[.77889 .44464 -9 -9 ]
[.77889 .44464 9 0 ]
[.49462 .21774 -24 -4.5 ]
[.49462 .21774 0 4.5 ]
[.49462 .69653 -18 -4.5 ]
[.49462 .69653 0 4.5 ]
[.49462 .93592 -6 -4.5 ]
[.49462 .93592 0 4.5 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.23535 .45714 m
.23535 .46339 L
s
[(-0.5)] .23535 .44464 0 1 Mshowa
.77889 .45714 m
.77889 .46339 L
s
[(0.5)] .77889 .44464 0 1 Mshowa
0 .45714 m
1 .45714 L
s
.50712 .21774 m
.51337 .21774 L
s
[(-0.5)] .49462 .21774 1 0 Mshowa
.50712 .69653 m
.51337 .69653 L
s
[(0.5)] .49462 .69653 1 0 Mshowa
.50712 .93592 m
.51337 .93592 L
s
[(1)] .49462 .93592 1 0 Mshowa
.125 Mabswid
.50712 .26562 m
.51087 .26562 L
s
.50712 .3135 m
.51087 .3135 L
s
.50712 .36138 m
.51087 .36138 L
s
.50712 .40926 m
.51087 .40926 L
s
.50712 .50501 m
.51087 .50501 L
s
.50712 .55289 m
.51087 .55289 L
s
.50712 .60077 m
.51087 .60077 L
s
.50712 .64865 m
.51087 .64865 L
s
.50712 .74441 m
.51087 .74441 L
s
.50712 .79228 m
.51087 .79228 L
s
.50712 .84016 m
.51087 .84016 L
s
.50712 .88804 m
.51087 .88804 L
s
.50712 .16987 m
.51087 .16987 L
s
.50712 .12199 m
.51087 .12199 L
s
.50712 .07411 m
.51087 .07411 L
s
.50712 .02623 m
.51087 .02623 L
s
.50712 .9838 m
.51087 .9838 L
s
.25 Mabswid
.50712 0 m
.50712 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.008 w
.03534 .65087 Mdot
.24952 .04004 Mdot
.16554 .09458 Mdot
.18988 .05511 Mdot
.06268 .62473 Mdot
.04121 .68791 Mdot
.02381 .34255 Mdot
.77058 .89121 Mdot
.51428 .97619 Mdot
.34234 .02381 Mdot
.29759 .9099 Mdot
.27433 .83512 Mdot
.26846 .90453 Mdot
.49417 .90394 Mdot
.97619 .22765 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.0.9"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.0.9"]
}, Open  ]],

Cell[TextData[{
 "The points given to ",
 StyleBox["SplineFit", "MR"],
 " are first sorted according to polar angle. The resulting spline \
interpolates the points. "
}], "MathCaption",
 CellTags->{"S5.0.9", "9.5"}],

Cell[CellGroupData[{

Cell["\<\
(data = Map[Last,
        Sort[Map[{Apply[ArcTan, #], #}&, data]]];
spline = SplineFit[Join[data, {First[data]}], Cubic];
ParametricPlot[spline[u], {u, 0, 15},
   AspectRatio -> 1, Compiled -> False,
   Ticks -> {{-1., -.5, .5, 1.}, Automatic}])\
\>", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.0.9"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.498513 0.519877 0.445576 0.464881 [
[.23857 .43308 -12 -9 ]
[.23857 .43308 12 0 ]
[.75845 .43308 -9 -9 ]
[.75845 .43308 9 0 ]
[.48601 .21314 -24 -4.5 ]
[.48601 .21314 0 4.5 ]
[.48601 .67802 -18 -4.5 ]
[.48601 .67802 0 4.5 ]
[.48601 .91046 -6 -4.5 ]
[.48601 .91046 0 4.5 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.23857 .44558 m
.23857 .45183 L
s
[(-0.5)] .23857 .43308 0 1 Mshowa
.75845 .44558 m
.75845 .45183 L
s
[(0.5)] .75845 .43308 0 1 Mshowa
0 .44558 m
1 .44558 L
s
.49851 .21314 m
.50476 .21314 L
s
[(-0.5)] .48601 .21314 1 0 Mshowa
.49851 .67802 m
.50476 .67802 L
s
[(0.5)] .48601 .67802 1 0 Mshowa
.49851 .91046 m
.50476 .91046 L
s
[(1)] .48601 .91046 1 0 Mshowa
.125 Mabswid
.49851 .25962 m
.50226 .25962 L
s
.49851 .30611 m
.50226 .30611 L
s
.49851 .3526 m
.50226 .3526 L
s
.49851 .39909 m
.50226 .39909 L
s
.49851 .49206 m
.50226 .49206 L
s
.49851 .53855 m
.50226 .53855 L
s
.49851 .58504 m
.50226 .58504 L
s
.49851 .63153 m
.50226 .63153 L
s
.49851 .7245 m
.50226 .7245 L
s
.49851 .77099 m
.50226 .77099 L
s
.49851 .81748 m
.50226 .81748 L
s
.49851 .86397 m
.50226 .86397 L
s
.49851 .16665 m
.50226 .16665 L
s
.49851 .12016 m
.50226 .12016 L
s
.49851 .07367 m
.50226 .07367 L
s
.49851 .02718 m
.50226 .02718 L
s
.49851 .95695 m
.50226 .95695 L
s
.25 Mabswid
.49851 0 m
.49851 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 Mabswid
.03624 .33432 m
.13238 .16779 L
.18271 .06687 L
.1849 .0593 L
.18524 .05802 L
.18555 .05691 L
.18581 .05617 L
.18595 .05582 L
.18609 .05555 L
.18623 .05533 L
.18639 .05514 L
.18649 .05505 L
.18658 .05498 L
.18678 .05487 L
.18698 .05479 L
.18718 .05474 L
.18743 .0547 L
.18772 .05469 L
.18802 .05469 L
.18838 .05471 L
.18876 .05474 L
.18914 .05478 L
.19097 .05498 L
.19214 .05508 L
.19286 .05513 L
.1936 .05517 L
.19434 .0552 L
.1952 .05523 L
.19603 .05524 L
.19684 .05524 L
.19785 .05522 L
.19884 .0552 L
.19998 .05516 L
.20126 .05511 L
.20402 .05495 L
.20671 .05475 L
.21217 .05424 L
.21846 .05349 L
.2312 .05141 L
.23742 .05003 L
.24264 .04857 L
.2466 .04713 L
.24844 .04627 L
.2499 .04544 L
.25113 .04452 L
.25164 .04402 L
.25206 .04347 L
.25223 .04319 L
.25237 .04288 L
.25247 .04259 L
Mistroke
.25252 .04232 L
.25254 .0418 L
.2525 .0415 L
.25243 .04124 L
.25219 .0407 L
.25187 .0402 L
.25139 .03965 L
.25078 .03906 L
.24787 .03696 L
.24112 .03288 L
.23949 .03176 L
.23882 .03122 L
.23829 .03073 L
.23791 .0303 L
.23758 .02984 L
.23737 .02939 L
.2373 .02892 L
.23736 .02852 L
.23758 .0281 L
.23789 .02776 L
.23837 .0274 L
.23907 .02702 L
.24004 .02664 L
.24117 .0263 L
.24238 .026 L
.24532 .02547 L
.24732 .0252 L
.2494 .02497 L
.25383 .0246 L
.25638 .02443 L
.25944 .02428 L
.26319 .02412 L
.267 .02401 L
.27154 .02391 L
.27398 .02387 L
.27681 .02384 L
.2818 .02381 L
.28478 .02381 L
.28761 .02381 L
.2931 .02384 L
.29927 .0239 L
.30518 .02399 L
.31187 .0241 L
.32494 .02439 L
.35967 .02545 L
.38191 .02634 L
.40811 .02765 L
.46031 .03116 L
.51551 .03639 L
.56897 .0432 L
Mistroke
.62228 .052 L
.67958 .06424 L
.73242 .07877 L
.77866 .09488 L
.82897 .1175 L
.85346 .13123 L
.87767 .14729 L
.89885 .16419 L
.9161 .18081 L
.93147 .19888 L
.94381 .21697 L
.95404 .23621 L
.95898 .24779 L
.96291 .25865 L
.96929 .28174 L
.97189 .29491 L
.97377 .30767 L
.97496 .31884 L
.97578 .3309 L
.97615 .34134 L
.97619 .35302 L
.97583 .3657 L
.975 .37953 L
.97378 .39274 L
.97233 .40497 L
.96787 .43293 L
.96235 .45929 L
.9454 .51987 L
.92378 .579 L
.89622 .64106 L
.83667 .74906 L
.7674 .847 L
.7365 .88249 L
.70539 .91284 L
.67783 .93511 L
.65408 .95069 L
.63066 .96266 L
.60995 .97026 L
.59926 .97303 L
.59431 .97403 L
.58977 .97479 L
.58721 .97514 L
.58449 .97547 L
.57983 .97589 L
.57724 .97605 L
.57454 .97615 L
.56982 .97619 L
.56579 .97607 L
.56222 .97584 L
.55821 .97544 L
Mistroke
.55452 .97493 L
.54823 .97374 L
.54178 .97208 L
.53516 .96984 L
.5287 .96706 L
.51856 .96128 L
.50988 .95436 L
.50394 .94777 L
.50148 .94415 L
.49938 .94021 L
.49792 .93653 L
.49696 .93315 L
.49662 .93153 L
.49634 .92979 L
.49615 .92816 L
.49604 .92667 L
.49598 .92533 L
.49596 .92387 L
.49599 .92235 L
.49606 .92095 L
.49618 .91933 L
.49634 .91781 L
.49671 .91499 L
.49781 .90891 L
.49897 .90308 L
.49943 .90038 L
.49959 .89923 L
.49974 .898 L
.49984 .89682 L
.4999 .8956 L
.49991 .89431 L
.49985 .89315 L
.49979 .89249 L
.49971 .89188 L
.4995 .89076 L
.49935 .89015 L
.49918 .8896 L
.49872 .88838 L
.4983 .88752 L
.49777 .88663 L
.49657 .8851 L
.49472 .88342 L
.4926 .88202 L
.48991 .88072 L
.48636 .87947 L
.4824 .87847 L
.47821 .87769 L
.47555 .8773 L
.47259 .87693 L
.4669 .87639 L
Mistroke
.46352 .87615 L
.46024 .87596 L
.45652 .8758 L
.45439 .87573 L
.45239 .87568 L
.44871 .87561 L
.44673 .87558 L
.4446 .87557 L
.44096 .87556 L
.43886 .87557 L
.43687 .87559 L
.43312 .87564 L
.42963 .8757 L
.42575 .8758 L
.4216 .87592 L
.40607 .87656 L
.39125 .87739 L
.35755 .87982 L
.30077 .88495 L
.28019 .88684 L
.272 .88751 L
.26872 .88773 L
.26613 .88788 L
.26495 .88794 L
.26378 .88798 L
.26318 .888 L
.26265 .88801 L
.26217 .88801 L
.26169 .88802 L
.26124 .88801 L
.26078 .88801 L
.26038 .88799 L
.26003 .88798 L
.25968 .88795 L
.25932 .88792 L
.25898 .88788 L
.2587 .88784 L
.25848 .8878 L
.25827 .88775 L
.25795 .88765 L
.25771 .88754 L
.25756 .88742 L
.25747 .88728 L
.25745 .88719 L
.25745 .88711 L
.25751 .88692 L
.25757 .8868 L
.25765 .88669 L
.25814 .88623 L
.25884 .88574 L
Mistroke
.2612 .88439 L
.26791 .88109 L
.27765 .87625 L
.28277 .87329 L
.28733 .87016 L
.29107 .86701 L
.2946 .86313 L
.29613 .86092 L
.29733 .85873 L
.29833 .85629 L
.29875 .85486 L
.29906 .85351 L
.29926 .85218 L
.29938 .8509 L
.29942 .84945 L
.29935 .84785 L
.29916 .84622 L
.29903 .84537 L
.29884 .84444 L
.2984 .84273 L
.2979 .84114 L
.29657 .83786 L
.29466 .83419 L
.2898 .82709 L
.28167 .81805 L
.26954 .80721 L
.2394 .78511 L
.16363 .73776 L
.08096 .68816 L
.05283 .66962 L
.04163 .66112 L
.03379 .6542 L
.02871 .64872 L
.0268 .64618 L
.02532 .64373 L
.0248 .64265 L
.02441 .64169 L
.02415 .64087 L
.02395 .64003 L
.02384 .63927 L
.02381 .63851 L
.02385 .6379 L
.02395 .63727 L
.02417 .63656 L
.02445 .63596 L
.02484 .63534 L
.02535 .63475 L
.02639 .63389 L
.02709 .63347 L
.02781 .63312 L
Mistroke
.02854 .63283 L
.02929 .63259 L
.03 .6324 L
.03079 .63223 L
.03168 .63208 L
.03253 .63197 L
.03359 .63189 L
.03457 .63184 L
.03568 .63183 L
.03624 .63184 L
.03687 .63186 L
.038 .63193 L
.03906 .63202 L
.04033 .63217 L
.04149 .63235 L
.04411 .63285 L
.04634 .63341 L
.0487 .63415 L
.05277 .63572 L
.06018 .63911 L
.06175 .63979 L
.0633 .6404 L
.06466 .64083 L
.06529 .64098 L
.06584 .6411 L
.06641 .64118 L
.067 .64122 L
.06761 .64121 L
.06817 .64115 L
.06873 .64102 L
.06923 .64083 L
.06974 .64056 L
.07026 .64019 L
.07072 .63976 L
.07118 .63919 L
.07192 .63791 L
.07232 .63694 L
.07266 .63589 L
.07293 .63484 L
.0732 .63355 L
.0734 .63224 L
.07357 .63092 L
.07371 .62935 L
.07377 .62851 L
.07383 .62754 L
.0739 .62582 L
.07392 .6248 L
.07394 .62384 L
.07395 .62187 L
.07393 .61989 L
Mistroke
.07388 .61787 L
.0738 .6156 L
.07359 .6112 L
.07326 .60598 L
.07277 .59963 L
.06932 .56642 L
.06437 .52727 L
.03643 .33557 L
.03624 .33432 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.0.9"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.0.9"]
}, Open  ]],

Cell[TextData[{
 "You can use ",
 StyleBox["GeneralMiniMaxApproximation", "MR"],
 " to approximate the inverse to the Euler gamma function on an interval. \
This shows the gamma function on ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1.5", "\[LessEqual]", 
    StyleBox["t",
     "TI"], "\[LessEqual]", "6"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.0.9", "9.6"}],

Cell[CellGroupData[{

Cell["\<\
Plot[Gamma[t], {t, 1.5, 6},
   AxesOrigin -> {1.5, 0}, AspectRatio ->1,
   AxesLabel -> {\"t\", \"Gamma[t]\"}]\
\>", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.0.9"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.293651 0.21164 0.0238095 0.0147538 [
[.12963 .01131 -3 -9 ]
[.12963 .01131 3 0 ]
[.34127 .01131 -3 -9 ]
[.34127 .01131 3 0 ]
[.55291 .01131 -3 -9 ]
[.55291 .01131 3 0 ]
[.76455 .01131 -3 -9 ]
[.76455 .01131 3 0 ]
[.97619 .01131 -3 -9 ]
[.97619 .01131 3 0 ]
[1.025 .02381 0 -4.90625 ]
[1.025 .02381 10 4.90625 ]
[.01131 .17135 -12 -4.5 ]
[.01131 .17135 0 4.5 ]
[.01131 .31889 -12 -4.5 ]
[.01131 .31889 0 4.5 ]
[.01131 .46642 -12 -4.5 ]
[.01131 .46642 0 4.5 ]
[.01131 .61396 -12 -4.5 ]
[.01131 .61396 0 4.5 ]
[.01131 .7615 -12 -4.5 ]
[.01131 .7615 0 4.5 ]
[.01131 .90904 -12 -4.5 ]
[.01131 .90904 0 4.5 ]
[.02381 1.025 -26 0 ]
[.02381 1.025 26 10.125 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.12963 .02381 m
.12963 .03006 L
s
[(2)] .12963 .01131 0 1 Mshowa
.34127 .02381 m
.34127 .03006 L
s
[(3)] .34127 .01131 0 1 Mshowa
.55291 .02381 m
.55291 .03006 L
s
[(4)] .55291 .01131 0 1 Mshowa
.76455 .02381 m
.76455 .03006 L
s
[(5)] .76455 .01131 0 1 Mshowa
.97619 .02381 m
.97619 .03006 L
s
[(6)] .97619 .01131 0 1 Mshowa
.125 Mabswid
.17196 .02381 m
.17196 .02756 L
s
.21429 .02381 m
.21429 .02756 L
s
.25661 .02381 m
.25661 .02756 L
s
.29894 .02381 m
.29894 .02756 L
s
.3836 .02381 m
.3836 .02756 L
s
.42593 .02381 m
.42593 .02756 L
s
.46825 .02381 m
.46825 .02756 L
s
.51058 .02381 m
.51058 .02756 L
s
.59524 .02381 m
.59524 .02756 L
s
.63757 .02381 m
.63757 .02756 L
s
.67989 .02381 m
.67989 .02756 L
s
.72222 .02381 m
.72222 .02756 L
s
.80688 .02381 m
.80688 .02756 L
s
.84921 .02381 m
.84921 .02756 L
s
.89153 .02381 m
.89153 .02756 L
s
.93386 .02381 m
.93386 .02756 L
s
.0873 .02381 m
.0873 .02756 L
s
.04497 .02381 m
.04497 .02756 L
s
.00265 .02381 m
.00265 .02756 L
s
.25 Mabswid
0 .02381 m
1 .02381 L
s
gsave
1.025 .02381 -61 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
69.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.02381 .17135 m
.03006 .17135 L
s
[(10)] .01131 .17135 1 0 Mshowa
.02381 .31889 m
.03006 .31889 L
s
[(20)] .01131 .31889 1 0 Mshowa
.02381 .46642 m
.03006 .46642 L
s
[(30)] .01131 .46642 1 0 Mshowa
.02381 .61396 m
.03006 .61396 L
s
[(40)] .01131 .61396 1 0 Mshowa
.02381 .7615 m
.03006 .7615 L
s
[(50)] .01131 .7615 1 0 Mshowa
.02381 .90904 m
.03006 .90904 L
s
[(60)] .01131 .90904 1 0 Mshowa
.125 Mabswid
.02381 .05332 m
.02756 .05332 L
s
.02381 .08282 m
.02756 .08282 L
s
.02381 .11233 m
.02756 .11233 L
s
.02381 .14184 m
.02756 .14184 L
s
.02381 .20086 m
.02756 .20086 L
s
.02381 .23036 m
.02756 .23036 L
s
.02381 .25987 m
.02756 .25987 L
s
.02381 .28938 m
.02756 .28938 L
s
.02381 .34839 m
.02756 .34839 L
s
.02381 .3779 m
.02756 .3779 L
s
.02381 .40741 m
.02756 .40741 L
s
.02381 .43692 m
.02756 .43692 L
s
.02381 .49593 m
.02756 .49593 L
s
.02381 .52544 m
.02756 .52544 L
s
.02381 .55495 m
.02756 .55495 L
s
.02381 .58445 m
.02756 .58445 L
s
.02381 .64347 m
.02756 .64347 L
s
.02381 .67298 m
.02756 .67298 L
s
.02381 .70248 m
.02756 .70248 L
s
.02381 .73199 m
.02756 .73199 L
s
.02381 .79101 m
.02756 .79101 L
s
.02381 .82052 m
.02756 .82052 L
s
.02381 .85002 m
.02756 .85002 L
s
.02381 .87953 m
.02756 .87953 L
s
.02381 .93855 m
.02756 .93855 L
s
.02381 .96805 m
.02756 .96805 L
s
.02381 .99756 m
.02756 .99756 L
s
.25 Mabswid
.02381 0 m
.02381 1 L
s
gsave
.02381 1.025 -87 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18.125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Gamma) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
93.000 11.250 moveto
(@) show
99.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
105.000 11.250 moveto
(D) show
111.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 Mabswid
.02381 .03688 m
.02846 .0369 L
.03279 .03692 L
.03754 .03694 L
.04262 .03697 L
.053 .03706 L
.06244 .03717 L
.0841 .03749 L
.10458 .03791 L
.14299 .03898 L
.18386 .04059 L
.22321 .04266 L
.26105 .04524 L
.30133 .04878 L
.34011 .05317 L
.38133 .05919 L
.42104 .06672 L
.45923 .07607 L
.49988 .08902 L
.53901 .10537 L
.58059 .12839 L
.62066 .15803 L
.65921 .19596 L
.70021 .25017 L
.7397 .32096 L
.77767 .41271 L
.81809 .54574 L
.857 .72162 L
.89836 .98112 L
s
.89836 .98112 m
.90051 1 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.0.9"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.0.9"]
}, Open  ]],

Cell[TextData[{
 "This gives a degree ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"2", ",", "4"}], ")"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " rational function that approximates the inverse on ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[CapitalGamma]", 
    RowBox[{"(", "1.5", ")"}], "\[LessEqual]", 
    StyleBox["x",
     "TI"], "\[LessEqual]", "\[CapitalGamma]", 
    RowBox[{"(", "6", ")"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.0.9", "9.7"}],

Cell[CellGroupData[{

Cell["\<\
(gmma = GeneralMiniMaxApproximation[{Gamma[t], t},
   {t, {1.5, 6}, 2, 4}, s];
inverseGamma = gmma[[2, 1]])\
\>", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.0.9"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"0.5022231869533185`", "\[InvisibleSpace]"}], "+", 
   RowBox[{"2.8606840258387947`", " ", "s"}], "-", 
   RowBox[{"4.134444307734635`", " ", 
    SuperscriptBox["s", "2"]}]}], 
  RowBox[{"1", "-", 
   RowBox[{"0.5243457488094458`", " ", "s"}], "-", 
   RowBox[{"0.860537396694092`", " ", 
    SuperscriptBox["s", "2"]}], "+", 
   RowBox[{"0.003240750151727416`", " ", 
    SuperscriptBox["s", "3"]}], "-", 
   RowBox[{"0.000015054090702777268`", " ", 
    SuperscriptBox["s", "4"]}]}]]], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S5.0.9"]
}, Open  ]],

Cell["\<\
Here is a plot of the approximation. For a minimax approximation, the error \
is distributed over the interval. \
\>", "MathCaption",
 CellTags->{"S5.0.9", "9.8"}],

Cell[CellGroupData[{

Cell["\<\
(Plot[inverseGamma, {s, Gamma[1.5], Gamma[6]},
   AxesOrigin -> {0, 1.5},
   AspectRatio ->1, AxesLabel -> {\"s\", \"inverseGamma[s]\"}])\
\>", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.0.9"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.00793651 -0.302235 0.214987 [
[.18254 .00775 -6 -9 ]
[.18254 .00775 6 0 ]
[.34127 .00775 -6 -9 ]
[.34127 .00775 6 0 ]
[.5 .00775 -6 -9 ]
[.5 .00775 6 0 ]
[.65873 .00775 -6 -9 ]
[.65873 .00775 6 0 ]
[.81746 .00775 -9 -9 ]
[.81746 .00775 9 0 ]
[.97619 .00775 -9 -9 ]
[.97619 .00775 9 0 ]
[1.025 .02025 0 -4.90625 ]
[1.025 .02025 10 4.90625 ]
[.01131 .12774 -6 -4.5 ]
[.01131 .12774 0 4.5 ]
[.01131 .34273 -6 -4.5 ]
[.01131 .34273 0 4.5 ]
[.01131 .55771 -6 -4.5 ]
[.01131 .55771 0 4.5 ]
[.01131 .7727 -6 -4.5 ]
[.01131 .7727 0 4.5 ]
[.01131 .98769 -6 -4.5 ]
[.01131 .98769 0 4.5 ]
[.02381 1.025 -47 0 ]
[.02381 1.025 47 10.4375 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.18254 .02025 m
.18254 .0265 L
s
[(20)] .18254 .00775 0 1 Mshowa
.34127 .02025 m
.34127 .0265 L
s
[(40)] .34127 .00775 0 1 Mshowa
.5 .02025 m
.5 .0265 L
s
[(60)] .5 .00775 0 1 Mshowa
.65873 .02025 m
.65873 .0265 L
s
[(80)] .65873 .00775 0 1 Mshowa
.81746 .02025 m
.81746 .0265 L
s
[(100)] .81746 .00775 0 1 Mshowa
.97619 .02025 m
.97619 .0265 L
s
[(120)] .97619 .00775 0 1 Mshowa
.125 Mabswid
.06349 .02025 m
.06349 .024 L
s
.10317 .02025 m
.10317 .024 L
s
.14286 .02025 m
.14286 .024 L
s
.22222 .02025 m
.22222 .024 L
s
.2619 .02025 m
.2619 .024 L
s
.30159 .02025 m
.30159 .024 L
s
.38095 .02025 m
.38095 .024 L
s
.42063 .02025 m
.42063 .024 L
s
.46032 .02025 m
.46032 .024 L
s
.53968 .02025 m
.53968 .024 L
s
.57937 .02025 m
.57937 .024 L
s
.61905 .02025 m
.61905 .024 L
s
.69841 .02025 m
.69841 .024 L
s
.7381 .02025 m
.7381 .024 L
s
.77778 .02025 m
.77778 .024 L
s
.85714 .02025 m
.85714 .024 L
s
.89683 .02025 m
.89683 .024 L
s
.93651 .02025 m
.93651 .024 L
s
.25 Mabswid
0 .02025 m
1 .02025 L
s
gsave
1.025 .02025 -61 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(s) show
69.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.02381 .12774 m
.03006 .12774 L
s
[(2)] .01131 .12774 1 0 Mshowa
.02381 .34273 m
.03006 .34273 L
s
[(3)] .01131 .34273 1 0 Mshowa
.02381 .55771 m
.03006 .55771 L
s
[(4)] .01131 .55771 1 0 Mshowa
.02381 .7727 m
.03006 .7727 L
s
[(5)] .01131 .7727 1 0 Mshowa
.02381 .98769 m
.03006 .98769 L
s
[(6)] .01131 .98769 1 0 Mshowa
.125 Mabswid
.02381 .17074 m
.02756 .17074 L
s
.02381 .21374 m
.02756 .21374 L
s
.02381 .25673 m
.02756 .25673 L
s
.02381 .29973 m
.02756 .29973 L
s
.02381 .38572 m
.02756 .38572 L
s
.02381 .42872 m
.02756 .42872 L
s
.02381 .47172 m
.02756 .47172 L
s
.02381 .51472 m
.02756 .51472 L
s
.02381 .60071 m
.02756 .60071 L
s
.02381 .64371 m
.02756 .64371 L
s
.02381 .68671 m
.02756 .68671 L
s
.02381 .7297 m
.02756 .7297 L
s
.02381 .8157 m
.02756 .8157 L
s
.02381 .8587 m
.02756 .8587 L
s
.02381 .90169 m
.02756 .90169 L
s
.02381 .94469 m
.02756 .94469 L
s
.02381 .08474 m
.02756 .08474 L
s
.02381 .04175 m
.02756 .04175 L
s
.25 Mabswid
.02381 0 m
.02381 1 L
s
gsave
.02381 1.025 -108 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18.4375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(inverseGamma) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
135.000 11.562 moveto
(@) show
141.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(s) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
147.000 11.562 moveto
(D) show
153.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 Mabswid
.03084 .02381 m
.03201 .14753 L
.03307 .19194 L
.0343 .22923 L
.03546 .25818 L
.03975 .33877 L
.04219 .3731 L
.04443 .40003 L
.04951 .44894 L
.05406 .48288 L
.05907 .51297 L
.06919 .55875 L
.0796 .59284 L
.09079 .62082 L
.11102 .65829 L
.132 .6871 L
.15194 .70913 L
.18985 .7429 L
.23019 .77218 L
.26903 .79659 L
.31031 .8198 L
.35008 .84015 L
.38835 .8582 L
.42905 .8759 L
.46824 .89159 L
.50593 .90546 L
.54606 .91892 L
.58468 .93058 L
.62574 .94158 L
.66529 .95079 L
.70333 .95834 L
.74381 .96493 L
.78279 .96986 L
.82026 .97327 L
.83947 .97452 L
.84935 .97502 L
.86017 .97547 L
.87047 .9758 L
.87541 .97592 L
.88006 .97602 L
.88261 .97606 L
.88537 .9761 L
.88766 .97613 L
.89019 .97615 L
.89292 .97617 L
.89442 .97618 L
.89513 .97618 L
.89582 .97618 L
.89712 .97619 L
.89832 .97619 L
Mistroke
.8996 .97619 L
.90033 .97619 L
.901 .97619 L
.90229 .97619 L
.90293 .97618 L
.90364 .97618 L
.90606 .97617 L
.90742 .97616 L
.90889 .97615 L
.91152 .97612 L
.9167 .97605 L
.92142 .97597 L
.93091 .97573 L
.9399 .97544 L
.95876 .97457 L
.97619 .97348 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.0.9"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S5.0.9"]
}, Open  ]],

Cell["\<\
When you want to solve differential equations approximately, there are many \
considerations to take into account. You must ensure that the numerical \
solution process is sufficiently accurate (it is consistent with the \
differential system), that it actually solves the problem in which you are \
interested (it is convergent), and that any errors do not cause your \
approximate solution to drift far from the true solution (it is stable). \
Further, you may wish to ensure that your approximate solution samples \
(interpolates) the exact solution at specific points. Order stars provide a \
framework for the study and construction of numerical methods with these \
desirable properties. \
\>", "Text",
 CellTags->{"S5.0.9", "9.9"}],

Cell["\<\
This loads the function Pade for calculating Pad\[EAcute] approximations. \
\>", "MathCaption",
 CellTags->{"S5.0.9", "9.10"}],

Cell["<<Calculus`Pade`", "Input",
 CellLabel->"In[7]:= ",
 CellTags->"S5.0.9"],

Cell[TextData[{
 "Here the Pad\[EAcute] approximation ",
 Cell[BoxData[
  FormBox[
   StyleBox["r",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " to ",
 Cell[BoxData[
  FormBox[
   StyleBox["f",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " represents the approximate solution of a differential equation, while ",
 Cell[BoxData[
  FormBox[
   StyleBox["f",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " represents the exact solution. "
}], "MathCaption",
 CellTags->{"S5.0.9", "9.11"}],

Cell[CellGroupData[{

Cell["\<\
(f = (z^2*(1 + z^2) + (1 + z/2)*(1 - z - z^3))/
   (z^2*(1 + z^2) + (1 - z/2)*(1 - z - z^3));
r = Pade[f, {z, 0, 1, 1}])\
\>", "Input",
 CellLabel->"In[8]:= ",
 CellTags->"S5.0.9"],

Cell[BoxData[
 FractionBox[
  RowBox[{"1", "+", 
   FractionBox["z", "2"]}], 
  RowBox[{"1", "-", 
   FractionBox["z", "2"]}]]], "Output",
 CellLabel->"Out[8]= ",
 CellTags->"S5.0.9"]
}, Open  ]],

Cell["\<\
This is an order star plot for analyzing the numerical method represented by \
the Pad\[EAcute] approximation. \
\>", "MathCaption",
 CellTags->{"S5.0.9", "9.12"}],

Cell[CellGroupData[{

Cell["\<\
OrderStar[r, f, OrderStarInterpolation -> True,
     OrderStarLegend -> True, ImageSize -> {500, Automatic}]\
\>", "Input",
 CellLabel->"In[9]:= ",
 CellTags->"S5.0.9"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .64072 
%%ImageSize: 500 320.358 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.640716 [
[ 0 0 0 0 ]
[ 1 .64072 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .64072 L
0 .64072 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.640716 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.138889 0.320358 0.138889 [
[ 0 0 -0.125 0 ]
[ 0 0 -0.125 0 ]
[ 0 .64072 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .64072 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 0 m
1 0 L
s
0 0 m
0 .64072 L
s
0 .64072 m
1 .64072 L
s
1 0 m
1 .64072 L
s
0 .32036 m
1 .32036 L
s
.5 0 m
.5 .64072 L
s
0 0 m
1 0 L
1 .64072 L
0 .64072 L
closepath
clip
newpath
.5 g
0 .64072 m
1 .64072 L
1 0 L
0 0 L
F
1 g
0 .58445 m
.01266 .59017 L
.01718 .59205 L
.02532 .59521 L
.03797 .59959 L
.03976 .60016 L
.05063 .60336 L
.06329 .60652 L
.07154 .60827 L
.07595 .60911 L
.08861 .61114 L
.10127 .61262 L
.11392 .61356 L
.12658 .61398 L
.13924 .61387 L
.1519 .61324 L
.16456 .61208 L
.17722 .6104 L
.18944 .60827 L
.18987 .60819 L
.20253 .60543 L
.21519 .60213 L
.22186 .60016 L
.22785 .59826 L
.24051 .5938 L
.24508 .59205 L
.25316 .58875 L
.26398 .58394 L
.26582 .58307 L
.27848 .57674 L
.28019 .57583 L
.29114 .56972 L
.29451 .56772 L
.3038 .56195 L
.30738 .55961 L
.31646 .55339 L
.31908 .5515 L
.32911 .54393 L
.32979 .54339 L
.33962 .53528 L
.34177 .53341 L
.34861 .52717 L
.35443 .52147 L
.35675 .51906 L
.36395 .51095 L
.36709 .507 L
.37003 .50284 L
.37481 .49473 L
.37818 .48662 L
.37975 .48078 L
.38019 .47851 L
.38129 .4704 L
.38201 .46229 L
.38273 .45418 L
.38375 .44607 L
.38524 .43796 L
.3873 .42985 L
.39003 .42174 L
.39241 .41596 L
.39349 .41363 L
.39776 .40552 L
.40292 .39741 L
.40506 .39444 L
.409 .3893 L
.41622 .38119 L
.41772 .37967 L
.42432 .37307 L
.43038 .36794 L
.43345 .36496 L
.44304 .35786 L
.44363 .35685 L
.45564 .34874 L
.4557 .34871 L
.46758 .34063 L
.46835 .34025 L
.48005 .33252 L
.48101 .3319 L
.49322 .32441 L
.49322 .3163 L
.48101 .30881 L
.48005 .30819 L
.46835 .30047 L
.46758 .30008 L
.4557 .292 L
.45564 .29197 L
.44363 .28386 L
.44304 .28285 L
.43345 .27575 L
.43038 .27277 L
.42432 .26764 L
.41772 .26105 L
.41622 .25953 L
.409 .25142 L
.40506 .24628 L
.40292 .24331 L
.39776 .2352 L
.39349 .22709 L
.39241 .22476 L
.39003 .21898 L
.3873 .21087 L
.38524 .20276 L
.38375 .19465 L
.38273 .18654 L
.38201 .17843 L
.38129 .17032 L
.38019 .16221 L
.37975 .15993 L
.37818 .1541 L
.37481 .14599 L
.37003 .13788 L
.36709 .13372 L
.36395 .12977 L
.35675 .12165 L
.35443 .11925 L
.34861 .11354 L
.34177 .10731 L
.33962 .10543 L
.32979 .09732 L
.32911 .09679 L
.31908 .08921 L
.31646 .08733 L
.30738 .0811 L
.3038 .07876 L
.29451 .07299 L
.29114 .071 L
.28019 .06488 L
.27848 .06397 L
.26582 .05764 L
.26398 .05677 L
.25316 .05196 L
.24508 .04866 L
.24051 .04691 L
.22785 .04246 L
.22186 .04055 L
.21519 .03859 L
.20253 .03528 L
.18987 .03253 L
.18944 .03244 L
.17722 .03031 L
.16456 .02863 L
.1519 .02748 L
.13924 .02684 L
.12658 .02673 L
.11392 .02715 L
.10127 .0281 L
.08861 .02958 L
.07595 .03161 L
.07154 .03244 L
.06329 .0342 L
.05063 .03736 L
.03976 .04055 L
.03797 .04112 L
.02532 .0455 L
.01718 .04866 L
.01266 .05054 L
0 .05627 L
F
0 g
.5 Mabswid
0 .58445 m
.01266 .59017 L
.01718 .59205 L
.02532 .59521 L
.03797 .59959 L
.03976 .60016 L
.05063 .60336 L
.06329 .60652 L
.07154 .60827 L
.07595 .60911 L
.08861 .61114 L
.10127 .61262 L
.11392 .61356 L
.12658 .61398 L
.13924 .61387 L
.1519 .61324 L
.16456 .61208 L
.17722 .6104 L
.18944 .60827 L
.18987 .60819 L
.20253 .60543 L
.21519 .60213 L
.22186 .60016 L
.22785 .59826 L
.24051 .5938 L
.24508 .59205 L
.25316 .58875 L
.26398 .58394 L
.26582 .58307 L
.27848 .57674 L
.28019 .57583 L
.29114 .56972 L
.29451 .56772 L
.3038 .56195 L
.30738 .55961 L
.31646 .55339 L
.31908 .5515 L
.32911 .54393 L
.32979 .54339 L
.33962 .53528 L
.34177 .53341 L
.34861 .52717 L
.35443 .52147 L
.35675 .51906 L
.36395 .51095 L
.36709 .507 L
.37003 .50284 L
.37481 .49473 L
.37818 .48662 L
.37975 .48078 L
Mistroke
.38019 .47851 L
.38129 .4704 L
.38201 .46229 L
.38273 .45418 L
.38375 .44607 L
.38524 .43796 L
.3873 .42985 L
.39003 .42174 L
.39241 .41596 L
.39349 .41363 L
.39776 .40552 L
.40292 .39741 L
.40506 .39444 L
.409 .3893 L
.41622 .38119 L
.41772 .37967 L
.42432 .37307 L
.43038 .36794 L
.43345 .36496 L
.44304 .35786 L
.44363 .35685 L
.45564 .34874 L
.4557 .34871 L
.46758 .34063 L
.46835 .34025 L
.48005 .33252 L
.48101 .3319 L
.49322 .32441 L
.49322 .3163 L
.48101 .30881 L
.48005 .30819 L
.46835 .30047 L
.46758 .30008 L
.4557 .292 L
.45564 .29197 L
.44363 .28386 L
.44304 .28285 L
.43345 .27575 L
.43038 .27277 L
.42432 .26764 L
.41772 .26105 L
.41622 .25953 L
.409 .25142 L
.40506 .24628 L
.40292 .24331 L
.39776 .2352 L
.39349 .22709 L
.39241 .22476 L
.39003 .21898 L
.3873 .21087 L
Mistroke
.38524 .20276 L
.38375 .19465 L
.38273 .18654 L
.38201 .17843 L
.38129 .17032 L
.38019 .16221 L
.37975 .15993 L
.37818 .1541 L
.37481 .14599 L
.37003 .13788 L
.36709 .13372 L
.36395 .12977 L
.35675 .12165 L
.35443 .11925 L
.34861 .11354 L
.34177 .10731 L
.33962 .10543 L
.32979 .09732 L
.32911 .09679 L
.31908 .08921 L
.31646 .08733 L
.30738 .0811 L
.3038 .07876 L
.29451 .07299 L
.29114 .071 L
.28019 .06488 L
.27848 .06397 L
.26582 .05764 L
.26398 .05677 L
.25316 .05196 L
.24508 .04866 L
.24051 .04691 L
.22785 .04246 L
.22186 .04055 L
.21519 .03859 L
.20253 .03528 L
.18987 .03253 L
.18944 .03244 L
.17722 .03031 L
.16456 .02863 L
.1519 .02748 L
.13924 .02684 L
.12658 .02673 L
.11392 .02715 L
.10127 .0281 L
.08861 .02958 L
.07595 .03161 L
.07154 .03244 L
.06329 .0342 L
.05063 .03736 L
Mistroke
.03976 .04055 L
.03797 .04112 L
.02532 .0455 L
.01718 .04866 L
.01266 .05054 L
0 .05627 L
Mfstroke
1 g
.44304 .14259 m
.4557 .13888 L
.46835 .14023 L
.48067 .14599 L
.48101 .14622 L
.4899 .1541 L
.49367 .15963 L
.49507 .16221 L
.49837 .17032 L
.49991 .17843 L
.49964 .18654 L
.49668 .19465 L
.49367 .19798 L
.48101 .20095 L
.46835 .19614 L
.46612 .19465 L
.4557 .18886 L
.45245 .18654 L
.4444 .17843 L
.44304 .17661 L
.43832 .17032 L
.4371 .16221 L
.43533 .1541 L
.4391 .14599 L
F
0 g
.44304 .14259 m
.4557 .13888 L
.46835 .14023 L
.48067 .14599 L
.48101 .14622 L
.4899 .1541 L
.49367 .15963 L
.49507 .16221 L
.49837 .17032 L
.49991 .17843 L
.49964 .18654 L
.49668 .19465 L
.49367 .19798 L
.48101 .20095 L
.46835 .19614 L
.46612 .19465 L
.4557 .18886 L
.45245 .18654 L
.4444 .17843 L
.44304 .17661 L
.43832 .17032 L
.4371 .16221 L
.43533 .1541 L
.4391 .14599 L
.44304 .14259 L
s
1 g
.46835 .44458 m
.48101 .43976 L
.49367 .44274 L
.49668 .44607 L
.49964 .45418 L
.49991 .46229 L
.49837 .4704 L
.49507 .47851 L
.49367 .48108 L
.4899 .48662 L
.48101 .4945 L
.48067 .49473 L
.46835 .50049 L
.4557 .50183 L
.44304 .49812 L
.4391 .49473 L
.43533 .48662 L
.4371 .47851 L
.43832 .4704 L
.44304 .46411 L
.4444 .46229 L
.45245 .45418 L
.4557 .45185 L
.46612 .44607 L
F
0 g
.46835 .44458 m
.48101 .43976 L
.49367 .44274 L
.49668 .44607 L
.49964 .45418 L
.49991 .46229 L
.49837 .4704 L
.49507 .47851 L
.49367 .48108 L
.4899 .48662 L
.48101 .4945 L
.48067 .49473 L
.46835 .50049 L
.4557 .50183 L
.44304 .49812 L
.4391 .49473 L
.43533 .48662 L
.4371 .47851 L
.43832 .4704 L
.44304 .46411 L
.4444 .46229 L
.45245 .45418 L
.4557 .45185 L
.46612 .44607 L
.46835 .44458 L
s
1 g
.5443 .22594 m
.55696 .22379 L
.56962 .22389 L
.58228 .2269 L
.58275 .22709 L
.59494 .23503 L
.5951 .2352 L
.6008 .24331 L
.60303 .25142 L
.60248 .25953 L
.59911 .26764 L
.59494 .2732 L
.59235 .27575 L
.58228 .28302 L
.58085 .28386 L
.56962 .28914 L
.5629 .29197 L
.55696 .29408 L
.5443 .29895 L
.54165 .30008 L
.53165 .30382 L
.52324 .30819 L
.51899 .31016 L
.50778 .3163 L
.50778 .32441 L
.51899 .33056 L
.52324 .33252 L
.53165 .33689 L
.54165 .34063 L
.5443 .34176 L
.55696 .34664 L
.5629 .34874 L
.56962 .35157 L
.58085 .35685 L
.58228 .35769 L
.59235 .36496 L
.59494 .36751 L
.59911 .37307 L
.60248 .38119 L
.60303 .3893 L
.6008 .39741 L
.5951 .40552 L
.59494 .40568 L
.58275 .41363 L
.58228 .41382 L
.56962 .41683 L
.55696 .41693 L
.5443 .41478 L
.54032 .41363 L
.53165 .41016 L
.52445 .40552 L
.51899 .3998 L
.51726 .39741 L
.51274 .3893 L
.50952 .38119 L
.50697 .37307 L
.50633 .37071 L
.50496 .36496 L
.50345 .35685 L
.5025 .34874 L
.50306 .34063 L
.50015 .33252 L
.49794 .32441 L
.49794 .3163 L
.50015 .30819 L
.50306 .30008 L
.5025 .29197 L
.50345 .28386 L
.50496 .27575 L
.50633 .27001 L
.50697 .26764 L
.50952 .25953 L
.51274 .25142 L
.51726 .24331 L
.51899 .24092 L
.52445 .2352 L
.53165 .23055 L
.54032 .22709 L
F
0 g
.5443 .22594 m
.55696 .22379 L
.56962 .22389 L
.58228 .2269 L
.58275 .22709 L
.59494 .23503 L
.5951 .2352 L
.6008 .24331 L
.60303 .25142 L
.60248 .25953 L
.59911 .26764 L
.59494 .2732 L
.59235 .27575 L
.58228 .28302 L
.58085 .28386 L
.56962 .28914 L
.5629 .29197 L
.55696 .29408 L
.5443 .29895 L
.54165 .30008 L
.53165 .30382 L
.52324 .30819 L
.51899 .31016 L
.50778 .3163 L
.50778 .32441 L
.51899 .33056 L
.52324 .33252 L
.53165 .33689 L
.54165 .34063 L
.5443 .34176 L
.55696 .34664 L
.5629 .34874 L
.56962 .35157 L
.58085 .35685 L
.58228 .35769 L
.59235 .36496 L
.59494 .36751 L
.59911 .37307 L
.60248 .38119 L
.60303 .3893 L
.6008 .39741 L
.5951 .40552 L
.59494 .40568 L
.58275 .41363 L
.58228 .41382 L
.56962 .41683 L
.55696 .41693 L
.5443 .41478 L
.54032 .41363 L
.53165 .41016 L
Mistroke
.52445 .40552 L
.51899 .3998 L
.51726 .39741 L
.51274 .3893 L
.50952 .38119 L
.50697 .37307 L
.50633 .37071 L
.50496 .36496 L
.50345 .35685 L
.5025 .34874 L
.50306 .34063 L
.50015 .33252 L
.49794 .32441 L
.49794 .3163 L
.50015 .30819 L
.50306 .30008 L
.5025 .29197 L
.50345 .28386 L
.50496 .27575 L
.50633 .27001 L
.50697 .26764 L
.50952 .25953 L
.51274 .25142 L
.51726 .24331 L
.51899 .24092 L
.52445 .2352 L
.53165 .23055 L
.54032 .22709 L
.5443 .22594 L
Mfstroke
1 g
.45 .35239 m
.55 .35239 L
.55 .28832 L
.45 .28832 L
F
.5 g
.45048 .35239 m
.45256 .35091 L
.45279 .35075 L
.45513 .34911 L
.45513 .34911 L
.45749 .34746 L
.45769 .34732 L
.45988 .34582 L
.46026 .34556 L
.46229 .34418 L
.46282 .34382 L
.46472 .34254 L
.46538 .34209 L
.46718 .34089 L
.46795 .34038 L
.46965 .33925 L
.47051 .33869 L
.47215 .33761 L
.47308 .33701 L
.47467 .33596 L
.47564 .33534 L
.47721 .33432 L
.47821 .33369 L
.47976 .33268 L
.48077 .33206 L
.48234 .33104 L
.48333 .33044 L
.48493 .32939 L
.4859 .32884 L
.48753 .32775 L
.48846 .32725 L
.49012 .32611 L
.49103 .3257 L
.49303 .32446 L
.49359 .3242 L
.49579 .32282 L
.49615 .32261 L
.49859 .32118 L
.49859 .31954 L
.49615 .31811 L
.49579 .31789 L
.49359 .31652 L
.49303 .31625 L
.49103 .31502 L
.49012 .31461 L
.48846 .31346 L
.48753 .31296 L
.4859 .31188 L
.48493 .31132 L
.48333 .31028 L
.48234 .30968 L
.48077 .30866 L
.47976 .30804 L
.47821 .30702 L
.47721 .30639 L
.47564 .30537 L
.47467 .30475 L
.47308 .30371 L
.47215 .30311 L
.47051 .30203 L
.46965 .30146 L
.46795 .30033 L
.46718 .29982 L
.46538 .29862 L
.46472 .29818 L
.46282 .2969 L
.46229 .29654 L
.46026 .29515 L
.45988 .29489 L
.45769 .29339 L
.45749 .29325 L
.45513 .29161 L
.45513 .29161 L
.45279 .28996 L
.45256 .28981 L
.45048 .28832 L
.55 .28832 L
.55 .35239 L
F
0 g
.45048 .35239 m
.45256 .35091 L
.45279 .35075 L
.45513 .34911 L
.45513 .34911 L
.45749 .34746 L
.45769 .34732 L
.45988 .34582 L
.46026 .34556 L
.46229 .34418 L
.46282 .34382 L
.46472 .34254 L
.46538 .34209 L
.46718 .34089 L
.46795 .34038 L
.46965 .33925 L
.47051 .33869 L
.47215 .33761 L
.47308 .33701 L
.47467 .33596 L
.47564 .33534 L
.47721 .33432 L
.47821 .33369 L
.47976 .33268 L
.48077 .33206 L
.48234 .33104 L
.48333 .33044 L
.48493 .32939 L
.4859 .32884 L
.48753 .32775 L
.48846 .32725 L
.49012 .32611 L
.49103 .3257 L
.49303 .32446 L
.49359 .3242 L
.49579 .32282 L
.49615 .32261 L
.49859 .32118 L
.49859 .31954 L
.49615 .31811 L
.49579 .31789 L
.49359 .31652 L
.49303 .31625 L
.49103 .31502 L
.49012 .31461 L
.48846 .31346 L
.48753 .31296 L
.4859 .31188 L
.48493 .31132 L
.48333 .31028 L
Mistroke
.48234 .30968 L
.48077 .30866 L
.47976 .30804 L
.47821 .30702 L
.47721 .30639 L
.47564 .30537 L
.47467 .30475 L
.47308 .30371 L
.47215 .30311 L
.47051 .30203 L
.46965 .30146 L
.46795 .30033 L
.46718 .29982 L
.46538 .29862 L
.46472 .29818 L
.46282 .2969 L
.46229 .29654 L
.46026 .29515 L
.45988 .29489 L
.45769 .29339 L
.45749 .29325 L
.45513 .29161 L
.45513 .29161 L
.45279 .28996 L
.45256 .28981 L
.45048 .28832 L
Mfstroke
1 g
.50249 .35239 m
.50224 .35075 L
.502 .34911 L
.50178 .34746 L
.50157 .34582 L
.50137 .34418 L
.50128 .34342 L
.50119 .34254 L
.50102 .34089 L
.50086 .33925 L
.50072 .33761 L
.50059 .33596 L
.50047 .33432 L
.50037 .33268 L
.50028 .33104 L
.5002 .32939 L
.50014 .32775 L
.5001 .32611 L
.50012 .32446 L
.50001 .32282 L
.49992 .32118 L
.49992 .31954 L
.50001 .31789 L
.50012 .31625 L
.5001 .31461 L
.50014 .31296 L
.5002 .31132 L
.50028 .30968 L
.50037 .30804 L
.50047 .30639 L
.50059 .30475 L
.50072 .30311 L
.50086 .30146 L
.50102 .29982 L
.50119 .29818 L
.50128 .2973 L
.50137 .29654 L
.50157 .29489 L
.50178 .29325 L
.502 .29161 L
.50224 .28996 L
.50249 .28832 L
.55 .28832 L
.55 .35239 L
F
0 g
.50249 .35239 m
.50224 .35075 L
.502 .34911 L
.50178 .34746 L
.50157 .34582 L
.50137 .34418 L
.50128 .34342 L
.50119 .34254 L
.50102 .34089 L
.50086 .33925 L
.50072 .33761 L
.50059 .33596 L
.50047 .33432 L
.50037 .33268 L
.50028 .33104 L
.5002 .32939 L
.50014 .32775 L
.5001 .32611 L
.50012 .32446 L
.50001 .32282 L
.49992 .32118 L
.49992 .31954 L
.50001 .31789 L
.50012 .31625 L
.5001 .31461 L
.50014 .31296 L
.5002 .31132 L
.50028 .30968 L
.50037 .30804 L
.50047 .30639 L
.50059 .30475 L
.50072 .30311 L
.50086 .30146 L
.50102 .29982 L
.50119 .29818 L
.50128 .2973 L
.50137 .29654 L
.50157 .29489 L
.50178 .29325 L
.502 .29161 L
.50224 .28996 L
.50249 .28832 L
s
.5 g
.55 .34393 m
.54744 .34295 L
.54638 .34254 L
.54487 .34195 L
.54231 .34094 L
.54219 .34089 L
.53974 .33991 L
.53815 .33925 L
.53718 .33885 L
.53462 .33777 L
.53424 .33761 L
.53205 .33667 L
.53048 .33596 L
.52949 .33553 L
.52692 .33437 L
.52683 .33432 L
.52436 .33318 L
.52335 .33268 L
.52179 .33195 L
.51995 .33104 L
.51923 .3307 L
.51667 .32941 L
.51664 .32939 L
.5141 .3281 L
.51369 .32775 L
.51154 .32676 L
.51032 .32611 L
.50897 .32541 L
.50729 .32446 L
.50641 .32406 L
.50433 .32282 L
.50385 .32255 L
.50144 .32118 L
.50144 .31954 L
.50385 .31817 L
.50433 .31789 L
.50641 .31665 L
.50729 .31625 L
.50897 .31531 L
.51032 .31461 L
.51154 .31395 L
.51369 .31296 L
.5141 .31261 L
.51664 .31132 L
.51667 .3113 L
.51923 .31001 L
.51995 .30968 L
.52179 .30876 L
.52335 .30804 L
.52436 .30754 L
.52683 .30639 L
.52692 .30635 L
.52949 .30518 L
.53048 .30475 L
.53205 .30405 L
.53424 .30311 L
.53462 .30294 L
.53718 .30186 L
.53815 .30146 L
.53974 .30081 L
.54219 .29982 L
.54231 .29978 L
.54487 .29876 L
.54638 .29818 L
.54744 .29777 L
.55 .29678 L
F
0 g
.55 .34393 m
.54744 .34295 L
.54638 .34254 L
.54487 .34195 L
.54231 .34094 L
.54219 .34089 L
.53974 .33991 L
.53815 .33925 L
.53718 .33885 L
.53462 .33777 L
.53424 .33761 L
.53205 .33667 L
.53048 .33596 L
.52949 .33553 L
.52692 .33437 L
.52683 .33432 L
.52436 .33318 L
.52335 .33268 L
.52179 .33195 L
.51995 .33104 L
.51923 .3307 L
.51667 .32941 L
.51664 .32939 L
.5141 .3281 L
.51369 .32775 L
.51154 .32676 L
.51032 .32611 L
.50897 .32541 L
.50729 .32446 L
.50641 .32406 L
.50433 .32282 L
.50385 .32255 L
.50144 .32118 L
.50144 .31954 L
.50385 .31817 L
.50433 .31789 L
.50641 .31665 L
.50729 .31625 L
.50897 .31531 L
.51032 .31461 L
.51154 .31395 L
.51369 .31296 L
.5141 .31261 L
.51664 .31132 L
.51667 .3113 L
.51923 .31001 L
.51995 .30968 L
.52179 .30876 L
.52335 .30804 L
.52436 .30754 L
Mistroke
.52683 .30639 L
.52692 .30635 L
.52949 .30518 L
.53048 .30475 L
.53205 .30405 L
.53424 .30311 L
.53462 .30294 L
.53718 .30186 L
.53815 .30146 L
.53974 .30081 L
.54219 .29982 L
.54231 .29978 L
.54487 .29876 L
.54638 .29818 L
.54744 .29777 L
.55 .29678 L
Mfstroke
1 g
.5 .45925 m
.5 .45925 .01 0 365.73 arc
F
.5 .18147 m
.5 .18147 .01 0 365.73 arc
F
.5 .32036 m
.5 .32036 .01 0 365.73 arc
F
.5 .32036 m
.5 .32036 .01 0 365.73 arc
F
.5 .32036 m
.5 .32036 .01 0 365.73 arc
F
.76378 .32036 m
.77778 .30636 L
.79178 .32036 L
.77778 .33436 L
.76378 .32036 L
F
.21222 .31036 m
.23222 .31036 L
.23222 .33036 L
.21222 .33036 L
.21222 .31036 L
F
0 g
.003 w
newpath
.5 .45925 .01 0 365.73 arc
s
newpath
.5 .18147 .01 0 365.73 arc
s
newpath
.5 .32036 .01 0 365.73 arc
s
newpath
.5 .32036 .01 0 365.73 arc
s
newpath
.5 .32036 .01 0 365.73 arc
s
.45053 .46995 m
.47053 .44995 L
s
.45053 .44995 m
.47053 .46995 L
s
.45053 .19077 m
.47053 .17077 L
s
.45053 .17077 m
.47053 .19077 L
s
.57577 .39693 m
.59577 .37693 L
s
.57577 .37693 m
.59577 .39693 L
s
.57577 .26378 m
.59577 .24378 L
s
.57577 .24378 m
.59577 .26378 L
s
.76378 .32036 m
.77778 .30636 L
.79178 .32036 L
.77778 .33436 L
.76378 .32036 L
s
.69101 .37704 m
.69101 .39704 L
s
.68101 .38704 m
.70101 .38704 L
s
.69101 .24368 m
.69101 .26368 L
s
.68101 .25368 m
.70101 .25368 L
s
.44788 .43472 m
.44788 .45472 L
s
.43788 .44472 m
.45788 .44472 L
s
.44788 .186 m
.44788 .206 L
s
.43788 .196 m
.45788 .196 L
s
.21222 .31036 m
.23222 .31036 L
.23222 .33036 L
.21222 .33036 L
.21222 .31036 L
s
1 g
.01 .39072 m
.01 .63072 L
.35 .63072 L
.35 .39072 L
F
0 g
.01 .39072 m
.01 .63072 L
.35 .63072 L
.35 .39072 L
.01 .39072 L
s
% Start of sub-graphic
p
0.01 0.390716 0.35 0.630716 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.0168067 0.672269 [
[ 0 0 0 0 ]
[ 1 .70588 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .70588 L
0 .70588 L
closepath
clip
newpath
1 g
.03866 .62185 m
.07983 .58067 L
.12101 .62185 L
.07983 .66303 L
.03866 .62185 L
F
0 g
.00882 w
[ ] 0 setdash
.03866 .62185 m
.07983 .58067 L
.12101 .62185 L
.07983 .66303 L
.03866 .62185 L
s
gsave
.17647 .63529 -61 -9.0625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18.125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Poles) show
105.000 11.562 moveto
(of) show
123.000 11.562 moveto
(approximant) show
189.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
1 g
.05042 .45798 m
.10924 .45798 L
.10924 .51681 L
.05042 .51681 L
.05042 .45798 L
F
0 g
.05042 .45798 m
.10924 .45798 L
.10924 .51681 L
.05042 .51681 L
.05042 .45798 L
s
gsave
.17647 .49412 -61 -9.0625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18.125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Zeros) show
105.000 11.562 moveto
(of) show
123.000 11.562 moveto
(approximant) show
189.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.05042 .38235 m
.10924 .32353 L
s
.05042 .32353 m
.10924 .38235 L
s
gsave
.17647 .35294 -61 -9.0625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18.125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Poles) show
105.000 11.562 moveto
(of) show
123.000 11.562 moveto
(function) show
171.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.07983 .18908 m
.07983 .2479 L
s
.05042 .21849 m
.10924 .21849 L
s
gsave
.17647 .21176 -61 -9.0625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18.125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Zeros) show
105.000 11.562 moveto
(of) show
123.000 11.562 moveto
(function) show
171.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
1 g
.07983 .08403 m
matrix currentmatrix
0.0294118 0.0294118 scale
2.71422 2.85702 1 0 365.73 arc
setmatrix F
0 g
newpath
matrix currentmatrix
0.0294118 0.0294118 scale
2.71422 2.85702 1 0 365.73 arc
setmatrix s
gsave
.17647 .07059 -61 -9.0625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18.125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Interpolation) show
153.000 11.562 moveto
(points) show
189.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
MathSubEnd
P
% End of sub-graphic
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.640716 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.138889 0.320358 0.138889 [
[ 0 0 -0.125 0 ]
[ 0 0 -0.125 0 ]
[ 0 .64072 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .64072 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 0 m
1 0 L
s
0 0 m
0 .64072 L
s
0 .64072 m
1 .64072 L
s
1 0 m
1 .64072 L
s
0 .32036 m
1 .32036 L
s
.5 0 m
.5 .64072 L
s
0 0 m
1 0 L
1 .64072 L
0 .64072 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.0.9"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[9]= ",
 CellTags->"S5.0.9"]
}, Open  ]],

Cell[TextData[{
 "The order star reflects the fact that the order of the approximant at the \
origin is ",
 Cell[BoxData[
  FormBox["2", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", which is one less than the number of adjoining sectors there. The shaded \
region gives the region of growth of the approximant over the function and \
yields information on the accumulation of numerical errors. "
}], "Text",
 CellTags->{"S5.0.9", "9.13"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Statistics Packages", "Subsection",
 CellTags->{"S5.0.10", "10.1"}],

Cell[TextData[{
 StyleBox["Mathematica", "TI"],
 " users from a wide range of disciplines count on the basic statistical \
functions provided in the standard add\[Hyphen]on packages to do their work. \
Continuous and discrete univariate and multivariate statistical distributions \
are supported. There are packages offering descriptive statistics for \
univariate and multivariate data, data manipulation and smoothing, and \
classical hypothesis testing and confidence interval estimation. Both linear \
and nonlinear regression functions permit users to take advantage of an \
extensive collection of diagnostics. "
}], "Text",
 CellTags->{"S5.0.10", "10.2"}],

Cell[TextData[{
 "This causes each ",
 StyleBox["Statistics", "MR"],
 " package to be loaded as needed. "
}], "MathCaption",
 CellTags->{"S5.0.10", "10.3"}],

Cell["<<Statistics`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.0.10"],

Cell[TextData[{
 "About ",
 Cell[BoxData[
  FormBox[
   RowBox[{"90", "%"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " of this simulated data derives from a binormal distribution with nearly \
circular contours located at the origin. The remainder derives from a \
binormal having highly elliptical contours located in the lower left \
quadrant. "
}], "MathCaption",
 CellTags->{"S5.0.10", "10.4"}],

Cell[CellGroupData[{

Cell["\<\
(dist0 = MultinormalDistribution[{0, 0},
  {{1, .1}, {.1, 1}}];
dist1 = MultinormalDistribution[{-3, -2},
  {{3.2, -2.9}, {-2.9, 2.8}}];
ListPlot[data = Table[If[Random[] < .9,
         Random[dist0], Random[dist1]], {100}],
         AspectRatio->1, PlotRange -> All])\
\>", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.0.10"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.767453 0.109761 0.570605 0.178352 [
[.10889 .55811 -6 -9 ]
[.10889 .55811 6 0 ]
[.32841 .55811 -6 -9 ]
[.32841 .55811 6 0 ]
[.54793 .55811 -6 -9 ]
[.54793 .55811 6 0 ]
[.98698 .55811 -3 -9 ]
[.98698 .55811 3 0 ]
[.75495 .03555 -12 -4.5 ]
[.75495 .03555 0 4.5 ]
[.75495 .2139 -12 -4.5 ]
[.75495 .2139 0 4.5 ]
[.75495 .39225 -12 -4.5 ]
[.75495 .39225 0 4.5 ]
[.75495 .74896 -6 -4.5 ]
[.75495 .74896 0 4.5 ]
[.75495 .92731 -6 -4.5 ]
[.75495 .92731 0 4.5 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10889 .57061 m
.10889 .57686 L
s
[(-6)] .10889 .55811 0 1 Mshowa
.32841 .57061 m
.32841 .57686 L
s
[(-4)] .32841 .55811 0 1 Mshowa
.54793 .57061 m
.54793 .57686 L
s
[(-2)] .54793 .55811 0 1 Mshowa
.98698 .57061 m
.98698 .57686 L
s
[(2)] .98698 .55811 0 1 Mshowa
.125 Mabswid
.16377 .57061 m
.16377 .57436 L
s
.21865 .57061 m
.21865 .57436 L
s
.27353 .57061 m
.27353 .57436 L
s
.38329 .57061 m
.38329 .57436 L
s
.43817 .57061 m
.43817 .57436 L
s
.49305 .57061 m
.49305 .57436 L
s
.60281 .57061 m
.60281 .57436 L
s
.65769 .57061 m
.65769 .57436 L
s
.71257 .57061 m
.71257 .57436 L
s
.82233 .57061 m
.82233 .57436 L
s
.87721 .57061 m
.87721 .57436 L
s
.9321 .57061 m
.9321 .57436 L
s
.054 .57061 m
.054 .57436 L
s
.25 Mabswid
0 .57061 m
1 .57061 L
s
.76745 .03555 m
.7737 .03555 L
s
[(-3)] .75495 .03555 1 0 Mshowa
.76745 .2139 m
.7737 .2139 L
s
[(-2)] .75495 .2139 1 0 Mshowa
.76745 .39225 m
.7737 .39225 L
s
[(-1)] .75495 .39225 1 0 Mshowa
.76745 .74896 m
.7737 .74896 L
s
[(1)] .75495 .74896 1 0 Mshowa
.76745 .92731 m
.7737 .92731 L
s
[(2)] .75495 .92731 1 0 Mshowa
.125 Mabswid
.76745 .07122 m
.7712 .07122 L
s
.76745 .10689 m
.7712 .10689 L
s
.76745 .14256 m
.7712 .14256 L
s
.76745 .17823 m
.7712 .17823 L
s
.76745 .24957 m
.7712 .24957 L
s
.76745 .28524 m
.7712 .28524 L
s
.76745 .32091 m
.7712 .32091 L
s
.76745 .35658 m
.7712 .35658 L
s
.76745 .42792 m
.7712 .42792 L
s
.76745 .46359 m
.7712 .46359 L
s
.76745 .49926 m
.7712 .49926 L
s
.76745 .53493 m
.7712 .53493 L
s
.76745 .60628 m
.7712 .60628 L
s
.76745 .64195 m
.7712 .64195 L
s
.76745 .67762 m
.7712 .67762 L
s
.76745 .71329 m
.7712 .71329 L
s
.76745 .78463 m
.7712 .78463 L
s
.76745 .8203 m
.7712 .8203 L
s
.76745 .85597 m
.7712 .85597 L
s
.76745 .89164 m
.7712 .89164 L
s
.76745 .96298 m
.7712 .96298 L
s
.76745 .99865 m
.7712 .99865 L
s
.25 Mabswid
.76745 0 m
.76745 1 L
s
.008 w
.70029 .69114 Mdot
.71521 .51247 Mdot
.67367 .74531 Mdot
.78653 .63447 Mdot
.7584 .65178 Mdot
.85232 .87156 Mdot
.79815 .51253 Mdot
.72539 .33965 Mdot
.95472 .71798 Mdot
.73705 .52842 Mdot
.64607 .4362 Mdot
.75319 .81178 Mdot
.89434 .75865 Mdot
.84099 .74499 Mdot
.72359 .43563 Mdot
.83295 .58731 Mdot
.80499 .23239 Mdot
.72637 .5467 Mdot
.7198 .67809 Mdot
.52157 .60116 Mdot
.78325 .56767 Mdot
.8955 .26423 Mdot
.57635 .70154 Mdot
.80481 .64579 Mdot
.89524 .73567 Mdot
.52386 .02381 Mdot
.72937 .86643 Mdot
.76686 .37937 Mdot
.66264 .44053 Mdot
.71649 .39363 Mdot
.81742 .68742 Mdot
.50548 .17024 Mdot
.82873 .51818 Mdot
.79493 .56946 Mdot
.71234 .34971 Mdot
.73068 .43221 Mdot
.79121 .61147 Mdot
.74309 .78701 Mdot
.67752 .97619 Mdot
.59686 .66912 Mdot
.69394 .80519 Mdot
.72905 .68733 Mdot
.91844 .67992 Mdot
.68299 .33078 Mdot
.78084 .6534 Mdot
.68243 .4323 Mdot
.4185 .28746 Mdot
.69871 .64252 Mdot
.5989 .70421 Mdot
.81646 .50357 Mdot
.79468 .29252 Mdot
.55135 .24809 Mdot
.8743 .27616 Mdot
.56009 .50339 Mdot
.80453 .52621 Mdot
.54414 .51311 Mdot
.74952 .45405 Mdot
.88351 .49301 Mdot
.74634 .3961 Mdot
.93704 .61067 Mdot
.29607 .43272 Mdot
.76865 .68611 Mdot
.90475 .47257 Mdot
.84779 .4141 Mdot
.78903 .3481 Mdot
.02381 .81281 Mdot
.64576 .71784 Mdot
.64876 .85341 Mdot
.73385 .48072 Mdot
.68025 .44736 Mdot
.72996 .42946 Mdot
.83771 .42996 Mdot
.77793 .50643 Mdot
.74658 .58641 Mdot
.66401 .45005 Mdot
.8253 .87143 Mdot
.73546 .54226 Mdot
.70185 .71496 Mdot
.8771 .43849 Mdot
.38381 .28388 Mdot
.90589 .9633 Mdot
.72252 .48244 Mdot
.78023 .92132 Mdot
.8748 .52386 Mdot
.82255 .58722 Mdot
.64039 .50363 Mdot
.64879 .40007 Mdot
.81558 .39816 Mdot
.67442 .69892 Mdot
.78537 .54272 Mdot
.7653 .54048 Mdot
.78127 .57892 Mdot
.97619 .55727 Mdot
.61975 .31398 Mdot
.70838 .51967 Mdot
.80554 .5874 Mdot
.6586 .48183 Mdot
.74173 .4526 Mdot
.51674 .11004 Mdot
.77283 .56211 Mdot
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.0.10"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.0.10"]
}, Open  ]],

Cell["The population distribution is bimodal. ", "MathCaption",
 CellTags->{"S5.0.10", "10.5"}],

Cell[CellGroupData[{

Cell["\<\
({{xmin, xmax}, {ymin, ymax}} = Map[{Min[#], Max[#]}&,
  Transpose[data]];
ContourPlot[.9 PDF[dist0, {x, y}] +
  .1 PDF[dist1, {x, y}],
  {x, xmin, xmax}, {y, ymin, ymax},
  ContourShading -> False])\
\>", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.0.10"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% ContourGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.770025 0.110817 0.571284 0.180067 [
[.10512 -0.0125 -6 -9 ]
[.10512 -0.0125 6 0 ]
[.32676 -0.0125 -6 -9 ]
[.32676 -0.0125 6 0 ]
[.54839 -0.0125 -6 -9 ]
[.54839 -0.0125 6 0 ]
[.77002 -0.0125 -3 -9 ]
[.77002 -0.0125 3 0 ]
[.99166 -0.0125 -3 -9 ]
[.99166 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .03108 -12 -4.5 ]
[-0.0125 .03108 0 4.5 ]
[-0.0125 .21115 -12 -4.5 ]
[-0.0125 .21115 0 4.5 ]
[-0.0125 .39122 -12 -4.5 ]
[-0.0125 .39122 0 4.5 ]
[-0.0125 .57128 -6 -4.5 ]
[-0.0125 .57128 0 4.5 ]
[-0.0125 .75135 -6 -4.5 ]
[-0.0125 .75135 0 4.5 ]
[-0.0125 .93142 -6 -4.5 ]
[-0.0125 .93142 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10512 0 m
.10512 .00625 L
s
[(-6)] .10512 -0.0125 0 1 Mshowa
.32676 0 m
.32676 .00625 L
s
[(-4)] .32676 -0.0125 0 1 Mshowa
.54839 0 m
.54839 .00625 L
s
[(-2)] .54839 -0.0125 0 1 Mshowa
.77002 0 m
.77002 .00625 L
s
[(0)] .77002 -0.0125 0 1 Mshowa
.99166 0 m
.99166 .00625 L
s
[(2)] .99166 -0.0125 0 1 Mshowa
.125 Mabswid
.16053 0 m
.16053 .00375 L
s
.21594 0 m
.21594 .00375 L
s
.27135 0 m
.27135 .00375 L
s
.38217 0 m
.38217 .00375 L
s
.43757 0 m
.43757 .00375 L
s
.49298 0 m
.49298 .00375 L
s
.6038 0 m
.6038 .00375 L
s
.65921 0 m
.65921 .00375 L
s
.71462 0 m
.71462 .00375 L
s
.82543 0 m
.82543 .00375 L
s
.88084 0 m
.88084 .00375 L
s
.93625 0 m
.93625 .00375 L
s
.04972 0 m
.04972 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .03108 m
.00625 .03108 L
s
[(-3)] -0.0125 .03108 1 0 Mshowa
0 .21115 m
.00625 .21115 L
s
[(-2)] -0.0125 .21115 1 0 Mshowa
0 .39122 m
.00625 .39122 L
s
[(-1)] -0.0125 .39122 1 0 Mshowa
0 .57128 m
.00625 .57128 L
s
[(0)] -0.0125 .57128 1 0 Mshowa
0 .75135 m
.00625 .75135 L
s
[(1)] -0.0125 .75135 1 0 Mshowa
0 .93142 m
.00625 .93142 L
s
[(2)] -0.0125 .93142 1 0 Mshowa
.125 Mabswid
0 .0671 m
.00375 .0671 L
s
0 .10311 m
.00375 .10311 L
s
0 .13912 m
.00375 .13912 L
s
0 .17514 m
.00375 .17514 L
s
0 .24716 m
.00375 .24716 L
s
0 .28318 m
.00375 .28318 L
s
0 .31919 m
.00375 .31919 L
s
0 .3552 m
.00375 .3552 L
s
0 .42723 m
.00375 .42723 L
s
0 .46324 m
.00375 .46324 L
s
0 .49926 m
.00375 .49926 L
s
0 .53527 m
.00375 .53527 L
s
0 .6073 m
.00375 .6073 L
s
0 .64331 m
.00375 .64331 L
s
0 .67932 m
.00375 .67932 L
s
0 .71534 m
.00375 .71534 L
s
0 .78736 m
.00375 .78736 L
s
0 .82338 m
.00375 .82338 L
s
0 .85939 m
.00375 .85939 L
s
0 .8954 m
.00375 .8954 L
s
0 .96743 m
.00375 .96743 L
s
.25 Mabswid
0 0 m
0 1 L
s
.10512 .99375 m
.10512 1 L
s
.32676 .99375 m
.32676 1 L
s
.54839 .99375 m
.54839 1 L
s
.77002 .99375 m
.77002 1 L
s
.99166 .99375 m
.99166 1 L
s
.125 Mabswid
.16053 .99625 m
.16053 1 L
s
.21594 .99625 m
.21594 1 L
s
.27135 .99625 m
.27135 1 L
s
.38217 .99625 m
.38217 1 L
s
.43757 .99625 m
.43757 1 L
s
.49298 .99625 m
.49298 1 L
s
.6038 .99625 m
.6038 1 L
s
.65921 .99625 m
.65921 1 L
s
.71462 .99625 m
.71462 1 L
s
.82543 .99625 m
.82543 1 L
s
.88084 .99625 m
.88084 1 L
s
.93625 .99625 m
.93625 1 L
s
.04972 .99625 m
.04972 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .03108 m
1 .03108 L
s
.99375 .21115 m
1 .21115 L
s
.99375 .39122 m
1 .39122 L
s
.99375 .57128 m
1 .57128 L
s
.99375 .75135 m
1 .75135 L
s
.99375 .93142 m
1 .93142 L
s
.125 Mabswid
.99625 .0671 m
1 .0671 L
s
.99625 .10311 m
1 .10311 L
s
.99625 .13912 m
1 .13912 L
s
.99625 .17514 m
1 .17514 L
s
.99625 .24716 m
1 .24716 L
s
.99625 .28318 m
1 .28318 L
s
.99625 .31919 m
1 .31919 L
s
.99625 .3552 m
1 .3552 L
s
.99625 .42723 m
1 .42723 L
s
.99625 .46324 m
1 .46324 L
s
.99625 .49926 m
1 .49926 L
s
.99625 .53527 m
1 .53527 L
s
.99625 .6073 m
1 .6073 L
s
.99625 .64331 m
1 .64331 L
s
.99625 .67932 m
1 .67932 L
s
.99625 .71534 m
1 .71534 L
s
.99625 .78736 m
1 .78736 L
s
.99625 .82338 m
1 .82338 L
s
.99625 .85939 m
1 .85939 L
s
.99625 .8954 m
1 .8954 L
s
.99625 .96743 m
1 .96743 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 Mabswid
.70032 .40815 m
.74038 .38362 L
.78045 .38471 L
.82051 .40899 L
.83201 .41987 L
.85782 .45994 L
.86058 .46613 L
.87353 .5 L
.88294 .54006 L
.88688 .58013 L
.8856 .62019 L
.87852 .66026 L
.86342 .70032 L
.86058 .70564 L
.83849 .74038 L
.82051 .74998 L
.78045 .76125 L
.74038 .74931 L
.72235 .74038 L
.70032 .71176 L
.69231 .70032 L
.67233 .66026 L
.66062 .62019 L
.66026 .61848 L
.65442 .58013 L
.6534 .54006 L
.65782 .5 L
.66026 .48621 L
.66824 .45994 L
.68948 .41987 L
.70032 .40815 L
s
.74038 .36553 m
.78045 .3671 L
.80724 .37981 L
.82051 .38969 L
.84885 .41987 L
.86058 .44009 L
.87053 .45994 L
.8851 .5 L
.89384 .54006 L
.89762 .58013 L
.89665 .62019 L
.89053 .66026 L
.87787 .70032 L
.86058 .7319 L
.85731 .74038 L
.82051 .76929 L
.78045 .77889 L
.74038 .76743 L
.70356 .74038 L
.70032 .73315 L
.67794 .70032 L
.66061 .66026 L
.66026 .65935 L
.64957 .62019 L
.64366 .58013 L
.6425 .54006 L
.64627 .5 L
.65586 .45994 L
.66026 .4473 L
.67257 .41987 L
.70032 .38677 L
.70921 .37981 L
.74038 .36553 L
s
.70032 .36559 m
.74038 .34696 L
.78045 .34895 L
.82051 .37018 L
.83249 .37981 L
.86058 .41555 L
.86331 .41987 L
.88349 .45994 L
.89685 .5 L
.90064 .51284 L
.90492 .54006 L
.90854 .58013 L
.90786 .62019 L
.90255 .66026 L
.90064 .67013 L
.89162 .70032 L
.87239 .74038 L
.86058 .75648 L
.84182 .78045 L
.82051 .7888 L
.78045 .79698 L
.74038 .78596 L
.72744 .78045 L
.70032 .75433 L
.68847 .74038 L
.66436 .70032 L
.66026 .69143 L
.64854 .66026 L
.63819 .62019 L
.63251 .58013 L
.63124 .54006 L
.6345 .5 L
.64291 .45994 L
.65811 .41987 L
.66026 .41561 L
.68346 .37981 L
.70032 .36559 L
s
.74038 .32764 m
.78045 .32997 L
.80441 .33974 L
.82051 .34994 L
.85245 .37981 L
.86058 .39122 L
.87856 .41987 L
.89672 .45994 L
.90064 .4706 L
.90884 .5 L
.91648 .54006 L
.92009 .58013 L
.91966 .62019 L
.91495 .66026 L
.90532 .70032 L
.90064 .71429 L
.88915 .74038 L
.86089 .78045 L
.86058 .78077 L
.82051 .80903 L
.78045 .81603 L
.74038 .80531 L
.70307 .78045 L
.70032 .77598 L
.67171 .74038 L
.66026 .72046 L
.65066 .70032 L
.63597 .66026 L
.62619 .62019 L
.62072 .58013 L
.62019 .57302 L
.61942 .54006 L
.62019 .52094 L
.6222 .5 L
.62966 .45994 L
.64286 .41987 L
.66026 .38645 L
.66422 .37981 L
.70032 .34394 L
.70708 .33974 L
.74038 .32764 L
s
.70032 .32132 m
.74038 .30693 L
.78045 .30961 L
.82051 .32853 L
.83602 .33974 L
.86058 .36639 L
.87068 .37981 L
.89409 .41987 L
.90064 .43403 L
.91032 .45994 L
.92173 .5 L
.92915 .54006 L
.93274 .58013 L
.93252 .62019 L
.92831 .66026 L
.91966 .70032 L
.90552 .74038 L
.90064 .75094 L
.88324 .78045 L
.86058 .80562 L
.85086 .82051 L
.82051 .83045 L
.78045 .8363 L
.74038 .826 L
.7267 .82051 L
.70032 .79859 L
.68266 .78045 L
.66026 .74885 L
.65534 .74038 L
.63622 .70032 L
.62249 .66026 L
.62019 .6525 L
.61371 .62019 L
.6087 .58013 L
.60727 .54006 L
.60957 .5 L
.6159 .45994 L
.62019 .44148 L
.62733 .41987 L
.64576 .37981 L
.66026 .35804 L
.67473 .33974 L
.70032 .32132 L
s
.70032 .29679 m
.74038 .28434 L
.78045 .28731 L
.81141 .29968 L
.82051 .3051 L
.86041 .33974 L
.86058 .33994 L
.88973 .37981 L
.90064 .39917 L
.91022 .41987 L
.92527 .45994 L
.93621 .5 L
.94071 .52065 L
.94335 .54006 L
.94687 .58013 L
.94684 .62019 L
.94313 .66026 L
.94071 .67705 L
.93535 .70032 L
.92277 .74038 L
.90386 .78045 L
.90064 .78584 L
.8739 .82051 L
.86058 .83198 L
.82051 .85387 L
.78045 .85878 L
.74038 .84864 L
.70032 .82313 L
.69721 .82051 L
.66186 .78045 L
.66026 .77812 L
.63809 .74038 L
.62048 .70032 L
.62019 .69957 L
.60849 .66026 L
.6 .62019 L
.59496 .58013 L
.59339 .54006 L
.59539 .5 L
.60118 .45994 L
.61119 .41987 L
.62019 .3942 L
.62672 .37981 L
.65109 .33974 L
.66026 .32882 L
.69417 .29968 L
.70032 .29679 L
s
.74038 .25844 m
.77005 .25962 L
.78045 .2617 L
.82051 .27878 L
.84962 .29968 L
.86058 .31084 L
.88497 .33974 L
.90064 .36322 L
.90977 .37981 L
.92832 .41987 L
.94071 .4539 L
.94258 .45994 L
.95285 .5 L
.95952 .54006 L
.96287 .58013 L
.96304 .62019 L
.9599 .66026 L
.95309 .70032 L
.94198 .74038 L
.94071 .74412 L
.92556 .78045 L
.90163 .82051 L
.90064 .82185 L
.86159 .86058 L
.86058 .86124 L
.82051 .88019 L
.78045 .88409 L
.74038 .87432 L
.71123 .86058 L
.70032 .85054 L
.66895 .82051 L
.66026 .8097 L
.6403 .78045 L
.62019 .74318 L
.619 .74038 L
.6038 .70032 L
.59202 .66026 L
.58368 .62019 L
.58013 .60109 L
.57896 .58013 L
.57756 .54006 L
.57897 .5 L
.58013 .48033 L
.58397 .45994 L
.59311 .41987 L
.60675 .37981 L
.62019 .35069 L
.6265 .33974 L
.65761 .29968 L
.66026 .29716 L
Mistroke
.70032 .26937 L
.73151 .25962 L
.74038 .25844 L
Mfstroke
.98077 .63837 m
.97911 .66026 L
.97359 .70032 L
.96431 .74038 L
.95036 .78045 L
.94071 .80157 L
.93045 .82051 L
.90184 .86058 L
.90064 .86191 L
.86058 .89536 L
.85109 .90064 L
.82051 .91169 L
.78045 .91459 L
.74038 .90527 L
.72729 .90064 L
.70032 .88297 L
.67366 .86058 L
.66026 .84603 L
.64042 .82051 L
.62019 .78874 L
.61595 .78045 L
.59765 .74038 L
.58281 .70032 L
.58013 .69193 L
.57298 .66026 L
.56581 .62019 L
.56123 .58013 L
.55948 .54006 L
.56069 .5 L
.56495 .45994 L
.57231 .41987 L
.58013 .38892 L
.58332 .37981 L
.60036 .33974 L
.62019 .3051 L
.62398 .29968 L
.66026 .26074 L
.66133 .25962 L
.70032 .23695 L
.74038 .22766 L
.78045 .23128 L
.82051 .2473 L
.84079 .25962 L
.86058 .27675 L
.88253 .29968 L
.90064 .32321 L
.91119 .33974 L
.93301 .37981 L
.94071 .39646 L
.95021 .41987 L
Mistroke
.9631 .45994 L
.97221 .5 L
.97809 .54006 L
.98077 .57261 L
Mfstroke
.98077 .77951 m
.98047 .78045 L
.965 .82051 L
.94295 .86058 L
.94071 .86395 L
.91169 .90064 L
.90064 .91131 L
.86058 .93942 L
.85801 .94071 L
.82051 .95351 L
.78045 .95549 L
.74038 .94616 L
.72551 .94071 L
.70032 .92523 L
.66874 .90064 L
.66026 .89222 L
.633 .86058 L
.62019 .84288 L
.60683 .82051 L
.58563 .78045 L
.58013 .76864 L
.57028 .74038 L
.55748 .70032 L
.54703 .66026 L
.54006 .62427 L
.53967 .62019 L
.53638 .58013 L
.5349 .54006 L
.53554 .5 L
.53836 .45994 L
.54006 .4428 L
.54461 .41987 L
.55498 .37981 L
.569 .33974 L
.58013 .31221 L
.58688 .29968 L
.61344 .25962 L
.62019 .251 L
.65321 .21955 L
.66026 .2147 L
.70032 .19468 L
.74038 .18711 L
.78045 .19108 L
.82051 .20613 L
.84407 .21955 L
.86058 .2328 L
.88861 .25962 L
.90064 .27369 L
.91942 .29968 L
.94071 .33411 L
Mistroke
.94386 .33974 L
.96307 .37981 L
.97739 .41987 L
.98077 .43151 L
Mfstroke
.5919 .01923 m
.58013 .0436 L
.57235 .05929 L
.55823 .09936 L
.54006 .1256 L
.52913 .13942 L
.50197 .17949 L
.5 .1872 L
.49257 .21955 L
.45994 .25061 L
.45156 .25962 L
.42239 .29968 L
.41987 .30463 L
.39426 .33974 L
.37981 .36138 L
.36263 .37981 L
.33974 .40882 L
.32901 .41987 L
.29968 .45277 L
.28014 .41987 L
.29553 .37981 L
.29968 .3723 L
.31858 .33974 L
.33974 .3017 L
.34098 .29968 L
.35068 .25962 L
.37981 .22927 L
.38942 .21955 L
.41436 .17949 L
.41987 .17152 L
.44125 .13942 L
.45994 .10926 L
.46975 .09936 L
.49804 .05929 L
.5 .05736 L
.52974 .01923 L
s
.98077 .89747 m
.97901 .90064 L
.95128 .94071 L
.94071 .95306 L
.91089 .98077 L
s
.98077 .31368 m
.97425 .29968 L
.95086 .25962 L
.94071 .24552 L
.92061 .21955 L
.90064 .19705 L
.88249 .17949 L
.86058 .16248 L
.8231 .13942 L
.82051 .13837 L
.78045 .12536 L
.74038 .12108 L
.70032 .12644 L
.66242 .13942 L
.66026 .14104 L
.62019 .16727 L
.60671 .17949 L
.58013 .20743 L
.55361 .17949 L
.57533 .13942 L
.58013 .12876 L
.5964 .09936 L
.61317 .05929 L
.62019 .04868 L
.63677 .01923 L
s
.67947 .98077 m
.66026 .96603 L
.6347 .94071 L
.62019 .92427 L
.60254 .90064 L
.58013 .86749 L
.5767 .86058 L
.55661 .82051 L
.54006 .7851 L
.53884 .78045 L
.52711 .74038 L
.51534 .70032 L
.50552 .66026 L
.5 .63147 L
.49927 .62019 L
.49679 .58013 L
.49541 .54006 L
.49576 .5 L
.49561 .45994 L
.5 .42306 L
.50063 .41987 L
.51017 .37981 L
.51843 .33974 L
.53142 .29968 L
.54006 .27721 L
.54821 .25962 L
.57126 .21955 L
.54006 .19961 L
.52849 .21955 L
.5 .25283 L
.497 .25962 L
.46597 .29968 L
.45994 .30693 L
.43633 .33974 L
.41987 .35699 L
.40618 .37981 L
.37981 .41281 L
.37446 .41987 L
.34574 .45994 L
.33974 .46551 L
.31079 .5 L
.29968 .51816 L
.28742 .54006 L
.25962 .56915 L
.25073 .58013 L
.21955 .61634 L
.21529 .62019 L
.17949 .65672 L
.17463 .66026 L
.13942 .6833 L
Mistroke
.12772 .66026 L
.1378 .62019 L
.13942 .61658 L
.15377 .58013 L
.17447 .54006 L
.17949 .52447 L
.19092 .5 L
.21781 .45994 L
.21955 .44892 L
.23813 .41987 L
.25782 .37981 L
.25962 .37745 L
.28798 .33974 L
.29968 .30953 L
.30632 .29968 L
.32884 .25962 L
.33974 .24555 L
.35979 .21955 L
.37981 .18068 L
.38062 .17949 L
.40541 .13942 L
.41987 .12154 L
.43707 .09936 L
.45994 .06059 L
.46077 .05929 L
.49574 .01923 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.0.10"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "ContourGraphics", "\[SkeletonIndicator]"}],
  
  False,
  Editable->False]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.0.10"]
}, Open  ]],

Cell["\<\
You can visualize the sample distribution by assuming a binormal form and \
using the sample covariance matrix. But this hides the bimodal nature of the \
data. \
\>", "MathCaption",
 CellTags->{"S5.0.10", "10.6"}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"(", 
  RowBox[{
   RowBox[{"\[CapitalSigma]", "=", 
    RowBox[{"CovarianceMatrix", "[", "data", "]"}]}], ";", 
   RowBox[{"approx", "=", 
    RowBox[{
     RowBox[{"Apply", "[", 
      RowBox[{"Plus", ",", 
       RowBox[{"Map", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"PDF", "[", 
           RowBox[{
            RowBox[{"MultinormalDistribution", "[", 
             RowBox[{"#", ",", "\[CapitalSigma]"}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "&"}], ",", "data"}], 
        "]"}]}], "]"}], "/", 
     RowBox[{"Length", "[", "data", "]"}]}]}], ";", 
   RowBox[{"ContourPlot", "[", 
    RowBox[{"approx", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "xmin", ",", "xmax"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "ymin", ",", "ymax"}], "}"}], ",", 
     RowBox[{"ContourShading", "->", "False"}]}], "]"}]}], ")"}]], "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.0.10"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% ContourGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.770025 0.110817 0.571284 0.180067 [
[.10512 -0.0125 -6 -9 ]
[.10512 -0.0125 6 0 ]
[.32676 -0.0125 -6 -9 ]
[.32676 -0.0125 6 0 ]
[.54839 -0.0125 -6 -9 ]
[.54839 -0.0125 6 0 ]
[.77002 -0.0125 -3 -9 ]
[.77002 -0.0125 3 0 ]
[.99166 -0.0125 -3 -9 ]
[.99166 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .03108 -12 -4.5 ]
[-0.0125 .03108 0 4.5 ]
[-0.0125 .21115 -12 -4.5 ]
[-0.0125 .21115 0 4.5 ]
[-0.0125 .39122 -12 -4.5 ]
[-0.0125 .39122 0 4.5 ]
[-0.0125 .57128 -6 -4.5 ]
[-0.0125 .57128 0 4.5 ]
[-0.0125 .75135 -6 -4.5 ]
[-0.0125 .75135 0 4.5 ]
[-0.0125 .93142 -6 -4.5 ]
[-0.0125 .93142 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10512 0 m
.10512 .00625 L
s
[(-6)] .10512 -0.0125 0 1 Mshowa
.32676 0 m
.32676 .00625 L
s
[(-4)] .32676 -0.0125 0 1 Mshowa
.54839 0 m
.54839 .00625 L
s
[(-2)] .54839 -0.0125 0 1 Mshowa
.77002 0 m
.77002 .00625 L
s
[(0)] .77002 -0.0125 0 1 Mshowa
.99166 0 m
.99166 .00625 L
s
[(2)] .99166 -0.0125 0 1 Mshowa
.125 Mabswid
.16053 0 m
.16053 .00375 L
s
.21594 0 m
.21594 .00375 L
s
.27135 0 m
.27135 .00375 L
s
.38217 0 m
.38217 .00375 L
s
.43757 0 m
.43757 .00375 L
s
.49298 0 m
.49298 .00375 L
s
.6038 0 m
.6038 .00375 L
s
.65921 0 m
.65921 .00375 L
s
.71462 0 m
.71462 .00375 L
s
.82543 0 m
.82543 .00375 L
s
.88084 0 m
.88084 .00375 L
s
.93625 0 m
.93625 .00375 L
s
.04972 0 m
.04972 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .03108 m
.00625 .03108 L
s
[(-3)] -0.0125 .03108 1 0 Mshowa
0 .21115 m
.00625 .21115 L
s
[(-2)] -0.0125 .21115 1 0 Mshowa
0 .39122 m
.00625 .39122 L
s
[(-1)] -0.0125 .39122 1 0 Mshowa
0 .57128 m
.00625 .57128 L
s
[(0)] -0.0125 .57128 1 0 Mshowa
0 .75135 m
.00625 .75135 L
s
[(1)] -0.0125 .75135 1 0 Mshowa
0 .93142 m
.00625 .93142 L
s
[(2)] -0.0125 .93142 1 0 Mshowa
.125 Mabswid
0 .0671 m
.00375 .0671 L
s
0 .10311 m
.00375 .10311 L
s
0 .13912 m
.00375 .13912 L
s
0 .17514 m
.00375 .17514 L
s
0 .24716 m
.00375 .24716 L
s
0 .28318 m
.00375 .28318 L
s
0 .31919 m
.00375 .31919 L
s
0 .3552 m
.00375 .3552 L
s
0 .42723 m
.00375 .42723 L
s
0 .46324 m
.00375 .46324 L
s
0 .49926 m
.00375 .49926 L
s
0 .53527 m
.00375 .53527 L
s
0 .6073 m
.00375 .6073 L
s
0 .64331 m
.00375 .64331 L
s
0 .67932 m
.00375 .67932 L
s
0 .71534 m
.00375 .71534 L
s
0 .78736 m
.00375 .78736 L
s
0 .82338 m
.00375 .82338 L
s
0 .85939 m
.00375 .85939 L
s
0 .8954 m
.00375 .8954 L
s
0 .96743 m
.00375 .96743 L
s
.25 Mabswid
0 0 m
0 1 L
s
.10512 .99375 m
.10512 1 L
s
.32676 .99375 m
.32676 1 L
s
.54839 .99375 m
.54839 1 L
s
.77002 .99375 m
.77002 1 L
s
.99166 .99375 m
.99166 1 L
s
.125 Mabswid
.16053 .99625 m
.16053 1 L
s
.21594 .99625 m
.21594 1 L
s
.27135 .99625 m
.27135 1 L
s
.38217 .99625 m
.38217 1 L
s
.43757 .99625 m
.43757 1 L
s
.49298 .99625 m
.49298 1 L
s
.6038 .99625 m
.6038 1 L
s
.65921 .99625 m
.65921 1 L
s
.71462 .99625 m
.71462 1 L
s
.82543 .99625 m
.82543 1 L
s
.88084 .99625 m
.88084 1 L
s
.93625 .99625 m
.93625 1 L
s
.04972 .99625 m
.04972 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .03108 m
1 .03108 L
s
.99375 .21115 m
1 .21115 L
s
.99375 .39122 m
1 .39122 L
s
.99375 .57128 m
1 .57128 L
s
.99375 .75135 m
1 .75135 L
s
.99375 .93142 m
1 .93142 L
s
.125 Mabswid
.99625 .0671 m
1 .0671 L
s
.99625 .10311 m
1 .10311 L
s
.99625 .13912 m
1 .13912 L
s
.99625 .17514 m
1 .17514 L
s
.99625 .24716 m
1 .24716 L
s
.99625 .28318 m
1 .28318 L
s
.99625 .31919 m
1 .31919 L
s
.99625 .3552 m
1 .3552 L
s
.99625 .42723 m
1 .42723 L
s
.99625 .46324 m
1 .46324 L
s
.99625 .49926 m
1 .49926 L
s
.99625 .53527 m
1 .53527 L
s
.99625 .6073 m
1 .6073 L
s
.99625 .64331 m
1 .64331 L
s
.99625 .67932 m
1 .67932 L
s
.99625 .71534 m
1 .71534 L
s
.99625 .78736 m
1 .78736 L
s
.99625 .82338 m
1 .82338 L
s
.99625 .85939 m
1 .85939 L
s
.99625 .8954 m
1 .8954 L
s
.99625 .96743 m
1 .96743 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 Mabswid
.74038 .44129 m
.78045 .45466 L
.78628 .45994 L
.81329 .5 L
.82051 .5224 L
.82396 .54006 L
.82241 .58013 L
.82051 .58726 L
.80441 .62019 L
.78045 .63817 L
.74038 .6313 L
.72723 .62019 L
.70152 .58013 L
.70032 .57706 L
.69009 .54006 L
.69089 .5 L
.70032 .47499 L
.70992 .45994 L
.74038 .44129 L
s
.70032 .40135 m
.74038 .38988 L
.78045 .40165 L
.80417 .41987 L
.82051 .43781 L
.83524 .45994 L
.85193 .5 L
.85941 .54006 L
.86015 .58013 L
.8544 .62019 L
.83609 .66026 L
.82051 .67517 L
.78045 .69437 L
.74038 .68753 L
.70503 .66026 L
.70032 .65504 L
.67684 .62019 L
.66249 .58013 L
.66026 .56999 L
.65492 .54006 L
.65388 .5 L
.66026 .46268 L
.66076 .45994 L
.6754 .41987 L
.70032 .40135 L
s
.70032 .35408 m
.74038 .34852 L
.78045 .35999 L
.81454 .37981 L
.82051 .38932 L
.84607 .41987 L
.86058 .44589 L
.86703 .45994 L
.88083 .5 L
.88829 .54006 L
.89006 .58013 L
.88593 .62019 L
.87442 .66026 L
.86058 .68738 L
.85412 .70032 L
.82051 .72791 L
.78086 .74038 L
.78045 .74041 L
.77072 .74038 L
.74038 .73357 L
.70032 .70731 L
.69273 .70032 L
.66329 .66026 L
.66026 .65444 L
.64436 .62019 L
.63203 .58013 L
.62519 .54006 L
.62343 .5 L
.62719 .45994 L
.63831 .41987 L
.66026 .38346 L
.66361 .37981 L
.70032 .35408 L
s
.66026 .33191 m
.70032 .31299 L
.74038 .31074 L
.78045 .32207 L
.81331 .33974 L
.82051 .34761 L
.85188 .37981 L
.86058 .39203 L
.8777 .41987 L
.89558 .45994 L
.90064 .47388 L
.90756 .5 L
.9146 .54006 L
.91693 .58013 L
.91438 .62019 L
.90629 .66026 L
.90064 .67848 L
.89151 .70032 L
.86517 .74038 L
.86058 .74522 L
.82051 .77416 L
.80169 .78045 L
.78045 .78322 L
.75423 .78045 L
.74038 .77642 L
.70032 .75374 L
.68428 .74038 L
.66026 .7115 L
.65243 .70032 L
.63034 .66026 L
.62019 .63574 L
.61484 .62019 L
.60409 .58013 L
.59763 .54006 L
.59534 .5 L
.59754 .45994 L
.60523 .41987 L
.62019 .38093 L
.62078 .37981 L
.65015 .33974 L
.66026 .33191 L
s
.66026 .2865 m
.70032 .27379 L
.74038 .27383 L
.78045 .28505 L
.81048 .29968 L
.82051 .30804 L
.85551 .33974 L
.86058 .34573 L
.88567 .37981 L
.90064 .40624 L
.90721 .41987 L
.92293 .45994 L
.93388 .5 L
.9406 .54006 L
.94071 .54098 L
.9433 .58013 L
.94189 .62019 L
.94071 .6315 L
.93603 .66026 L
.92494 .70032 L
.90685 .74038 L
.90064 .75075 L
.87841 .78045 L
.86058 .79637 L
.82051 .81885 L
.81533 .82051 L
.78045 .82562 L
.74564 .82051 L
.74038 .8189 L
.70032 .79865 L
.67679 .78045 L
.66026 .76272 L
.64232 .74038 L
.62019 .70463 L
.61789 .70032 L
.59961 .66026 L
.58605 .62019 L
.58013 .59822 L
.57638 .58013 L
.57023 .54006 L
.56755 .5 L
.56856 .45994 L
.57388 .41987 L
.58013 .39294 L
.58471 .37981 L
.60375 .33974 L
.62019 .3178 L
.63812 .29968 L
.66026 .2865 L
s
.66026 .24224 m
.70032 .234 L
.74038 .23586 L
.78045 .247 L
.80837 .25962 L
.82051 .26804 L
.85924 .29968 L
.86058 .30106 L
.89319 .33974 L
.90064 .35066 L
.91795 .37981 L
.93672 .41987 L
.94071 .42989 L
.95082 .45994 L
.96094 .5 L
.96744 .54006 L
.97046 .58013 L
.96991 .62019 L
.96556 .66026 L
.95701 .70032 L
.94348 .74038 L
.94071 .74699 L
.92335 .78045 L
.90064 .81147 L
.89281 .82051 L
.86058 .84659 L
.83291 .86058 L
.82051 .86469 L
.78045 .86969 L
.74038 .86301 L
.73018 .86058 L
.70032 .8446 L
.66775 .82051 L
.66026 .81309 L
.6313 .78045 L
.62019 .7649 L
.60482 .74038 L
.58445 .70032 L
.58013 .69039 L
.56865 .66026 L
.55647 .62019 L
.54746 .58013 L
.54142 .54006 L
.54006 .52681 L
.53834 .5 L
.53836 .45994 L
.54006 .43526 L
.54187 .41987 L
.54965 .37981 L
.56312 .33974 L
Mistroke
.58013 .30742 L
.58532 .29968 L
.62019 .26368 L
.62487 .25962 L
.66026 .24224 L
Mfstroke
.98077 .73797 m
.97997 .74038 L
.96446 .78045 L
.94301 .82051 L
.94071 .82411 L
.91193 .86058 L
.90064 .87142 L
.86058 .89957 L
.85847 .90064 L
.82051 .91417 L
.78045 .91765 L
.74038 .91093 L
.70901 .90064 L
.70032 .894 L
.66026 .86591 L
.65411 .86058 L
.62019 .82452 L
.61697 .82051 L
.58913 .78045 L
.58013 .76508 L
.56723 .74038 L
.54959 .70032 L
.54006 .67457 L
.53543 .66026 L
.52427 .62019 L
.51571 .58013 L
.50963 .54006 L
.50604 .5 L
.50506 .45994 L
.50698 .41987 L
.51228 .37981 L
.52178 .33974 L
.53698 .29968 L
.54006 .29335 L
.56112 .25962 L
.58013 .23845 L
.6034 .21955 L
.62019 .21011 L
.66026 .19585 L
.70032 .19128 L
.74038 .19473 L
.78045 .20586 L
.81139 .21955 L
.82051 .22528 L
.86058 .25464 L
.86616 .25962 L
.90064 .29692 L
.90281 .29968 L
.93012 .33974 L
.94071 .35847 L
Mistroke
.95136 .37981 L
.96798 .41987 L
.98077 .45993 L
Mfstroke
.98077 .84224 m
.96982 .86058 L
.94071 .90014 L
.94027 .90064 L
.90064 .93685 L
.89563 .94071 L
.86058 .95944 L
.82051 .97094 L
.78045 .97295 L
.74038 .96611 L
.70032 .95035 L
.68257 .94071 L
.66026 .92505 L
.63168 .90064 L
.62019 .88894 L
.59576 .86058 L
.58013 .83937 L
.56771 .82051 L
.54483 .78045 L
.54006 .77108 L
.52602 .74038 L
.51027 .70032 L
.5 .66967 L
.49723 .66026 L
.48673 .62019 L
.47829 .58013 L
.47189 .54006 L
.46756 .5 L
.4654 .45994 L
.46562 .41987 L
.46855 .37981 L
.47469 .33974 L
.48482 .29968 L
.5 .26033 L
.50034 .25962 L
.5242 .21955 L
.54006 .20069 L
.5639 .17949 L
.58013 .16893 L
.62019 .15152 L
.66026 .14337 L
.70032 .14224 L
.74038 .14728 L
.78045 .15849 L
.82051 .17647 L
.82603 .17949 L
.86058 .20271 L
.88077 .21955 L
.90064 .23921 L
.91844 .25962 L
Mistroke
.94071 .28973 L
.94725 .29968 L
.97011 .33974 L
.98077 .36199 L
Mfstroke
.98077 .94605 m
.94897 .98077 L
s
.98077 .26746 m
.97591 .25962 L
.94744 .21955 L
.94071 .21133 L
.91132 .17949 L
.90064 .16952 L
.86252 .13942 L
.86058 .13812 L
.82051 .11499 L
.78395 .09936 L
.78045 .09818 L
.74038 .08687 L
.70032 .08 L
.66026 .07733 L
.62019 .07919 L
.58013 .08677 L
.54598 .09936 L
.54006 .10249 L
.5 .13093 L
.49137 .13942 L
.46108 .17949 L
.45994 .18139 L
.44111 .21955 L
.42736 .25962 L
.41987 .29028 L
.41813 .29968 L
.41259 .33974 L
.40999 .37981 L
.40988 .41987 L
.41192 .45994 L
.4158 .5 L
.41987 .53111 L
.42139 .54006 L
.42883 .58013 L
.43787 .62019 L
.44847 .66026 L
.45994 .69821 L
.46065 .70032 L
.4753 .74038 L
.49205 .78045 L
.5 .79782 L
.51153 .82051 L
.53434 .86058 L
.54006 .86975 L
.56144 .90064 L
.58013 .92443 L
.5944 .94071 L
.62019 .96647 L
.63683 .98077 L
s
.98077 .13961 m
.98062 .13942 L
.94319 .09936 L
.94071 .09706 L
.90064 .0639 L
.89428 .05929 L
.86058 .0378 L
.82335 .01923 L
s
.52216 .98077 m
.5 .94979 L
.49421 .94071 L
.46986 .90064 L
.45994 .88313 L
.44847 .86058 L
.42898 .82051 L
.41987 .80067 L
.41171 .78045 L
.39587 .74038 L
.38085 .70032 L
.37981 .69743 L
.36789 .66026 L
.35526 .62019 L
.34326 .58013 L
.33974 .56782 L
.33266 .54006 L
.32305 .5 L
.31472 .45994 L
.3082 .41987 L
.30396 .37981 L
.30235 .33974 L
.30364 .29968 L
.30797 .25962 L
.31543 .21955 L
.32614 .17949 L
.33974 .14079 L
.3403 .13942 L
.35871 .09936 L
.37981 .06334 L
.38255 .05929 L
.41552 .01923 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.0.10"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "ContourGraphics", "\[SkeletonIndicator]"}],
  
  False,
  Editable->False]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.0.10"]
}, Open  ]],

Cell["\<\
In the previous example, the observations followed a bivariate statistical \
distribution. You can also simulate data where the value of the independent \
variable is known with relative certainty, while the measured response is \
assumed to follow a univariate statistical distribution. \
\>", "Text",
 CellTags->{"S5.0.10", "10.7"}],

Cell[TextData[{
 "The nonrandom component of the response is a sum of Gaussians, one centered \
at ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["x",
     "TI"], "=", "3"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and another centered at ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["x",
     "TI"], "=", "18"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.0.10", "10.8"}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"(", 
  RowBox[{
   RowBox[{
    RowBox[{"gaussian", "[", 
     RowBox[{"\[Mu]_", ",", "\[Sigma]_", ",", "x_"}], "]"}], ":=", 
    RowBox[{
     RowBox[{"PDF", "[", 
      RowBox[{
       RowBox[{"NormalDistribution", "[", 
        RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", "x"}], "]"}], "/", 
     RowBox[{"PDF", "[", 
      RowBox[{
       RowBox[{"NormalDistribution", "[", 
        RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", "\[Mu]"}], "]"}]}]}], 
   ";", 
   RowBox[{"peaks", "=", 
    RowBox[{
     RowBox[{".6", 
      RowBox[{"gaussian", "[", 
       RowBox[{"3", ",", "2", ",", "x"}], "]"}]}], "+", 
     RowBox[{"2", 
      RowBox[{"gaussian", "[", 
       RowBox[{"18", ",", "2", ",", "x"}], "]"}]}]}]}]}], ")"}]], "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.0.10"],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", "8"]}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "18"}], "+", "x"}], ")"}], "2"]}]]}], "+", 
  RowBox[{"0.6`", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", "8"]}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "3"}], "+", "x"}], ")"}], "2"]}]]}]}]], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S5.0.10"]
}, Open  ]],

Cell[TextData[{
 "Here is a plot of the data, two Gaussian peaks contaminated by noise \
(uniformly distributed between ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox["1.5", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "), perhaps simulating mass spectrometer measurements. From the plot you \
might guess that there is a peak near ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["x",
     "TI"], "=", "2"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and another near ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["x",
     "TI"], "=", "19"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.0.10", "10.9"}],

Cell[CellGroupData[{

Cell["\<\
(data = Table[{x, peaks + Random[Real, 1.5]},
                {x, 1, 30}];
dataplot = ListPlot[data])\
\>", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.0.10"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.031746 0.0147151 0.214698 [
[.18254 .00222 -3 -9 ]
[.18254 .00222 3 0 ]
[.34127 .00222 -6 -9 ]
[.34127 .00222 6 0 ]
[.5 .00222 -6 -9 ]
[.5 .00222 6 0 ]
[.65873 .00222 -6 -9 ]
[.65873 .00222 6 0 ]
[.81746 .00222 -6 -9 ]
[.81746 .00222 6 0 ]
[.97619 .00222 -6 -9 ]
[.97619 .00222 6 0 ]
[.01131 .12206 -18 -4.5 ]
[.01131 .12206 0 4.5 ]
[.01131 .22941 -6 -4.5 ]
[.01131 .22941 0 4.5 ]
[.01131 .33676 -18 -4.5 ]
[.01131 .33676 0 4.5 ]
[.01131 .44411 -6 -4.5 ]
[.01131 .44411 0 4.5 ]
[.01131 .55146 -18 -4.5 ]
[.01131 .55146 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.18254 .01472 m
.18254 .02097 L
s
[(5)] .18254 .00222 0 1 Mshowa
.34127 .01472 m
.34127 .02097 L
s
[(10)] .34127 .00222 0 1 Mshowa
.5 .01472 m
.5 .02097 L
s
[(15)] .5 .00222 0 1 Mshowa
.65873 .01472 m
.65873 .02097 L
s
[(20)] .65873 .00222 0 1 Mshowa
.81746 .01472 m
.81746 .02097 L
s
[(25)] .81746 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(30)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.05556 .01472 m
.05556 .01847 L
s
.0873 .01472 m
.0873 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.15079 .01472 m
.15079 .01847 L
s
.21429 .01472 m
.21429 .01847 L
s
.24603 .01472 m
.24603 .01847 L
s
.27778 .01472 m
.27778 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.37302 .01472 m
.37302 .01847 L
s
.40476 .01472 m
.40476 .01847 L
s
.43651 .01472 m
.43651 .01847 L
s
.46825 .01472 m
.46825 .01847 L
s
.53175 .01472 m
.53175 .01847 L
s
.56349 .01472 m
.56349 .01847 L
s
.59524 .01472 m
.59524 .01847 L
s
.62698 .01472 m
.62698 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.72222 .01472 m
.72222 .01847 L
s
.75397 .01472 m
.75397 .01847 L
s
.78571 .01472 m
.78571 .01847 L
s
.84921 .01472 m
.84921 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.9127 .01472 m
.9127 .01847 L
s
.94444 .01472 m
.94444 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .12206 m
.03006 .12206 L
s
[(0.5)] .01131 .12206 1 0 Mshowa
.02381 .22941 m
.03006 .22941 L
s
[(1)] .01131 .22941 1 0 Mshowa
.02381 .33676 m
.03006 .33676 L
s
[(1.5)] .01131 .33676 1 0 Mshowa
.02381 .44411 m
.03006 .44411 L
s
[(2)] .01131 .44411 1 0 Mshowa
.02381 .55146 m
.03006 .55146 L
s
[(2.5)] .01131 .55146 1 0 Mshowa
.125 Mabswid
.02381 .03618 m
.02756 .03618 L
s
.02381 .05765 m
.02756 .05765 L
s
.02381 .07912 m
.02756 .07912 L
s
.02381 .10059 m
.02756 .10059 L
s
.02381 .14353 m
.02756 .14353 L
s
.02381 .165 m
.02756 .165 L
s
.02381 .18647 m
.02756 .18647 L
s
.02381 .20794 m
.02756 .20794 L
s
.02381 .25088 m
.02756 .25088 L
s
.02381 .27235 m
.02756 .27235 L
s
.02381 .29382 m
.02756 .29382 L
s
.02381 .31529 m
.02756 .31529 L
s
.02381 .35823 m
.02756 .35823 L
s
.02381 .3797 m
.02756 .3797 L
s
.02381 .40117 m
.02756 .40117 L
s
.02381 .42264 m
.02756 .42264 L
s
.02381 .46558 m
.02756 .46558 L
s
.02381 .48705 m
.02756 .48705 L
s
.02381 .50852 m
.02756 .50852 L
s
.02381 .52999 m
.02756 .52999 L
s
.02381 .57293 m
.02756 .57293 L
s
.02381 .5944 m
.02756 .5944 L
s
.02381 .61587 m
.02756 .61587 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.008 w
.05556 .3162 Mdot
.0873 .42899 Mdot
.11905 .3601 Mdot
.15079 .35419 Mdot
.18254 .12567 Mdot
.21429 .14366 Mdot
.24603 .28291 Mdot
.27778 .04003 Mdot
.30952 .32252 Mdot
.34127 .15639 Mdot
.37302 .15094 Mdot
.40476 .26864 Mdot
.43651 .18514 Mdot
.46825 .36537 Mdot
.5 .23465 Mdot
.53175 .40301 Mdot
.56349 .56669 Mdot
.59524 .46095 Mdot
.62698 .60332 Mdot
.65873 .36205 Mdot
.69048 .27356 Mdot
.72222 .21858 Mdot
.75397 .35102 Mdot
.78571 .28753 Mdot
.81746 .23379 Mdot
.84921 .18206 Mdot
.88095 .11561 Mdot
.9127 .05698 Mdot
.94444 .20003 Mdot
.97619 .09479 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.0.10"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S5.0.10"]
}, Open  ]],

Cell[TextData[{
 "A nonlinear model is chosen: a sum of Gaussians with different locations \
(",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Mu]", "1"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Mu]", "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ") and amplitudes (",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["a",
     "TI"], "1"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["a",
     "TI"], "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "), but the same width (",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Sigma]", "3"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "). "
}], "MathCaption",
 CellTags->{"S5.0.10", "10.10"}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"model", " ", "=", " ", 
  RowBox[{
   RowBox[{
    SubscriptBox["a", "1"], " ", 
    RowBox[{"gaussian", "[", 
     RowBox[{
      SubscriptBox["\[Mu]", "1"], ",", " ", 
      SubscriptBox["\[Sigma]", "3"], ",", " ", "x"}], "]"}]}], " ", "+", "\n",
    "\t\t", 
   RowBox[{
    SubscriptBox["a", "2"], " ", 
    RowBox[{"gaussian", "[", 
     RowBox[{
      SubscriptBox["\[Mu]", "2"], ",", " ", 
      SubscriptBox["\[Sigma]", "3"], ",", " ", "x"}], "]"}]}]}]}]], "Input",
 CellLabel->"In[7]:= ",
 CellTags->"S5.0.10"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"x", "-", 
         SubscriptBox["\[Mu]", "1"]}], ")"}], "2"], 
      RowBox[{"2", " ", 
       SubsuperscriptBox["\[Sigma]", "3", "2"]}]]}]], " ", 
   SubscriptBox["a", "1"]}], "+", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"x", "-", 
         SubscriptBox["\[Mu]", "2"]}], ")"}], "2"], 
      RowBox[{"2", " ", 
       SubsuperscriptBox["\[Sigma]", "3", "2"]}]]}]], " ", 
   SubscriptBox["a", "2"]}]}]], "Output",
 CellLabel->"Out[7]= ",
 CellTags->"S5.0.10"]
}, Open  ]],

Cell["\<\
A nonlinear model requires good starting values for the parameters to \
initialize the search for the least\[Hyphen]squares estimates. These can be \
guessed at by looking at the plot. Here is the model at our initial guess for \
the parameter values. \
\>", "MathCaption",
 CellTags->{"S5.0.10", "10.11"}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"(", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["\[Mu]", "10"], ",", " ", 
      SubscriptBox["\[Mu]", "20"], ",", " ", 
      SubscriptBox["a", "10"], ",", " ", 
      SubscriptBox["a", "20"], ",", " ", 
      SubscriptBox["\[Sigma]", "30"]}], "}"}], " ", "=", "\n", "   ", 
    RowBox[{"{", 
     RowBox[{"2", ",", " ", "19", ",", " ", 
      RowBox[{"data", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", " ", "2"}], "]"}], "]"}], ",", " ", 
      RowBox[{"data", "[", 
       RowBox[{"[", 
        RowBox[{"19", ",", " ", "2"}], "]"}], "]"}], ",", " ", "1"}], "}"}]}],
    ";", "\n", 
   RowBox[{"model0", " ", "=", " ", 
    RowBox[{"model", " ", "/.", " ", 
     RowBox[{"Thread", "[", 
      RowBox[{"Rule", "[", "\n", "  ", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox["\[Mu]", "1"], ",", " ", 
          SubscriptBox["\[Mu]", "2"], ",", " ", 
          SubscriptBox["a", "1"], ",", " ", 
          SubscriptBox["a", "2"], ",", " ", 
          SubscriptBox["\[Sigma]", "3"]}], "}"}], ",", "\n", "  ", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox["\[Mu]", "10"], ",", " ", 
          SubscriptBox["\[Mu]", "20"], ",", " ", 
          SubscriptBox["a", "10"], ",", " ", 
          SubscriptBox["a", "20"], ",", " ", 
          SubscriptBox["\[Sigma]", "30"]}], "}"}]}], "]"}], "]"}]}]}], ";", 
   "\n", 
   RowBox[{"Plot", "[", 
    RowBox[{"model0", ",", " ", 
     RowBox[{"{", 
      RowBox[{"x", ",", " ", "1", ",", " ", "30"}], "}"}], ",", " ", 
     RowBox[{"PlotRange", " ", "->", " ", "All"}], ",", "\n", "  ", 
     RowBox[{"AxesOrigin", " ", "->", " ", 
      RowBox[{"{", 
       RowBox[{"0", ",", " ", "0"}], "}"}]}]}], "]"}]}], ")"}]], "Input",
 CellLabel->"In[8]:= ",
 CellTags->"S5.0.10"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.00903124 0.0328407 0.0147151 0.214714 [
[.15517 .00222 -3 -9 ]
[.15517 .00222 3 0 ]
[.31938 .00222 -6 -9 ]
[.31938 .00222 6 0 ]
[.48358 .00222 -6 -9 ]
[.48358 .00222 6 0 ]
[.64778 .00222 -6 -9 ]
[.64778 .00222 6 0 ]
[.81199 .00222 -6 -9 ]
[.81199 .00222 6 0 ]
[.97619 .00222 -6 -9 ]
[.97619 .00222 6 0 ]
[-0.02153 .12207 -18 -4.5 ]
[-0.02153 .12207 0 4.5 ]
[-0.02153 .22943 -6 -4.5 ]
[-0.02153 .22943 0 4.5 ]
[-0.02153 .33679 -18 -4.5 ]
[-0.02153 .33679 0 4.5 ]
[-0.02153 .44414 -6 -4.5 ]
[-0.02153 .44414 0 4.5 ]
[-0.02153 .5515 -18 -4.5 ]
[-0.02153 .5515 0 4.5 ]
[ -0.00903 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.15517 .01472 m
.15517 .02097 L
s
[(5)] .15517 .00222 0 1 Mshowa
.31938 .01472 m
.31938 .02097 L
s
[(10)] .31938 .00222 0 1 Mshowa
.48358 .01472 m
.48358 .02097 L
s
[(15)] .48358 .00222 0 1 Mshowa
.64778 .01472 m
.64778 .02097 L
s
[(20)] .64778 .00222 0 1 Mshowa
.81199 .01472 m
.81199 .02097 L
s
[(25)] .81199 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(30)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.18801 .01472 m
.18801 .01847 L
s
.22085 .01472 m
.22085 .01847 L
s
.25369 .01472 m
.25369 .01847 L
s
.28654 .01472 m
.28654 .01847 L
s
.35222 .01472 m
.35222 .01847 L
s
.38506 .01472 m
.38506 .01847 L
s
.4179 .01472 m
.4179 .01847 L
s
.45074 .01472 m
.45074 .01847 L
s
.51642 .01472 m
.51642 .01847 L
s
.54926 .01472 m
.54926 .01847 L
s
.5821 .01472 m
.5821 .01847 L
s
.61494 .01472 m
.61494 .01847 L
s
.68062 .01472 m
.68062 .01847 L
s
.71346 .01472 m
.71346 .01847 L
s
.74631 .01472 m
.74631 .01847 L
s
.77915 .01472 m
.77915 .01847 L
s
.84483 .01472 m
.84483 .01847 L
s
.87767 .01472 m
.87767 .01847 L
s
.91051 .01472 m
.91051 .01847 L
s
.94335 .01472 m
.94335 .01847 L
s
.12233 .01472 m
.12233 .01847 L
s
.08949 .01472 m
.08949 .01847 L
s
.05665 .01472 m
.05665 .01847 L
s
.02381 .01472 m
.02381 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
-0.00903 .12207 m
-0.00278 .12207 L
s
[(0.5)] -0.02153 .12207 1 0 Mshowa
-0.00903 .22943 m
-0.00278 .22943 L
s
[(1)] -0.02153 .22943 1 0 Mshowa
-0.00903 .33679 m
-0.00278 .33679 L
s
[(1.5)] -0.02153 .33679 1 0 Mshowa
-0.00903 .44414 m
-0.00278 .44414 L
s
[(2)] -0.02153 .44414 1 0 Mshowa
-0.00903 .5515 m
-0.00278 .5515 L
s
[(2.5)] -0.02153 .5515 1 0 Mshowa
.125 Mabswid
-0.00903 .03619 m
-0.00528 .03619 L
s
-0.00903 .05766 m
-0.00528 .05766 L
s
-0.00903 .07913 m
-0.00528 .07913 L
s
-0.00903 .1006 m
-0.00528 .1006 L
s
-0.00903 .14354 m
-0.00528 .14354 L
s
-0.00903 .16501 m
-0.00528 .16501 L
s
-0.00903 .18649 m
-0.00528 .18649 L
s
-0.00903 .20796 m
-0.00528 .20796 L
s
-0.00903 .2509 m
-0.00528 .2509 L
s
-0.00903 .27237 m
-0.00528 .27237 L
s
-0.00903 .29384 m
-0.00528 .29384 L
s
-0.00903 .31531 m
-0.00528 .31531 L
s
-0.00903 .35826 m
-0.00528 .35826 L
s
-0.00903 .37973 m
-0.00528 .37973 L
s
-0.00903 .4012 m
-0.00528 .4012 L
s
-0.00903 .42267 m
-0.00528 .42267 L
s
-0.00903 .46561 m
-0.00528 .46561 L
s
-0.00903 .48709 m
-0.00528 .48709 L
s
-0.00903 .50856 m
-0.00528 .50856 L
s
-0.00903 .53003 m
-0.00528 .53003 L
s
-0.00903 .57297 m
-0.00528 .57297 L
s
-0.00903 .59444 m
-0.00528 .59444 L
s
-0.00903 .61591 m
-0.00528 .61591 L
s
.25 Mabswid
-0.00903 0 m
-0.00903 .61803 L
s
.5 Mabswid
.02381 .26601 m
.03279 .33288 L
.03793 .36692 L
.04262 .39288 L
.045 .40374 L
.04758 .41351 L
.04899 .41792 L
.0503 .42136 L
.05164 .42422 L
.05288 .42631 L
.05395 .42762 L
.05509 .42856 L
.05636 .42901 L
.05752 .42888 L
.05873 .42819 L
.06005 .42681 L
.06129 .42491 L
.06244 .42263 L
.06509 .41557 L
.06795 .4052 L
.07314 .37995 L
.08284 .31618 L
.0932 .23772 L
.10458 .15754 L
.10956 .12789 L
.11489 .10069 L
.1195 .08108 L
.12452 .06369 L
.13018 .04851 L
.13554 .03786 L
.14076 .03032 L
.14558 .02531 L
.15022 .02187 L
.15282 .02041 L
.15521 .0193 L
.15961 .01776 L
.16183 .01717 L
.16425 .01665 L
.1669 .01619 L
.16941 .01586 L
.1723 .01556 L
.17492 .01535 L
.1774 .0152 L
.17968 .01509 L
.18219 .01499 L
.18485 .01492 L
.18738 .01487 L
.18978 .01483 L
.19194 .0148 L
.19429 .01478 L
Mistroke
.19683 .01476 L
.19955 .01475 L
.20211 .01474 L
.20442 .01473 L
.20679 .01473 L
.20896 .01472 L
.21134 .01472 L
.21386 .01472 L
.21605 .01472 L
.21809 .01472 L
.22034 .01472 L
.22274 .01472 L
.22396 .01472 L
.22531 .01472 L
.22662 .01472 L
.22804 .01472 L
.22936 .01472 L
.23057 .01472 L
.23294 .01472 L
.23427 .01472 L
.23552 .01472 L
.237 .01472 L
.23834 .01472 L
.23966 .01472 L
.24109 .01472 L
.24259 .01472 L
.24402 .01472 L
.24644 .01472 L
.24782 .01472 L
.24911 .01472 L
.25045 .01472 L
.25171 .01472 L
.25317 .01472 L
.2545 .01472 L
.25566 .01472 L
.2569 .01472 L
.25912 .01472 L
.26035 .01472 L
.26151 .01472 L
.26279 .01472 L
.26415 .01472 L
.26542 .01472 L
.26658 .01472 L
.26884 .01472 L
.2701 .01472 L
.27147 .01472 L
.27277 .01472 L
.27397 .01472 L
.27512 .01472 L
.27636 .01472 L
Mistroke
.27771 .01472 L
.27899 .01472 L
.28041 .01472 L
.28177 .01472 L
.28298 .01472 L
.28431 .01472 L
.28556 .01472 L
.28674 .01472 L
.28782 .01472 L
.28895 .01472 L
.29019 .01472 L
.29133 .01472 L
.29256 .01472 L
.2939 .01472 L
.29507 .01472 L
.29613 .01472 L
.29735 .01472 L
.29851 .01472 L
.29951 .01472 L
.30057 .01472 L
.30173 .01472 L
.30281 .01472 L
.30394 .01472 L
.30519 .01472 L
.30649 .01472 L
.3077 .01472 L
.30884 .01472 L
.30987 .01472 L
.31106 .01472 L
.31218 .01472 L
.31341 .01472 L
.31471 .01472 L
.31582 .01472 L
.31704 .01472 L
.31835 .01472 L
.31975 .01472 L
.32108 .01472 L
.32229 .01472 L
.32342 .01472 L
.32462 .01472 L
.32576 .01472 L
.32678 .01472 L
.32799 .01472 L
.3293 .01472 L
.33054 .01472 L
.33167 .01472 L
.33274 .01472 L
.33374 .01472 L
.33484 .01472 L
.33601 .01472 L
Mistroke
.33724 .01472 L
.3384 .01472 L
.33944 .01472 L
.34058 .01472 L
.3418 .01472 L
.34292 .01472 L
.34422 .01472 L
.34545 .01472 L
.34658 .01472 L
.34763 .01472 L
.34878 .01472 L
.35001 .01472 L
.35136 .01472 L
.35282 .01472 L
.35419 .01472 L
.35546 .01472 L
.35661 .01472 L
.35786 .01472 L
.35918 .01472 L
.3604 .01472 L
.36171 .01472 L
.36313 .01472 L
.36447 .01472 L
.36571 .01472 L
.36683 .01472 L
.36806 .01472 L
.36934 .01472 L
.37055 .01472 L
.37188 .01472 L
.37328 .01472 L
.37448 .01472 L
.37578 .01472 L
.3772 .01472 L
.37871 .01472 L
.38013 .01472 L
.38143 .01472 L
.38262 .01472 L
.38374 .01472 L
.38496 .01472 L
.38627 .01472 L
.38765 .01472 L
.38896 .01472 L
.39013 .01472 L
.39141 .01472 L
.39262 .01472 L
.39372 .01472 L
.39499 .01472 L
.39618 .01472 L
.39831 .01472 L
.3995 .01472 L
Mistroke
.40061 .01472 L
.40181 .01472 L
.4031 .01472 L
.40432 .01472 L
.40543 .01472 L
.40673 .01472 L
.40815 .01472 L
.40949 .01472 L
.41072 .01472 L
.41319 .01472 L
.41459 .01472 L
.4159 .01472 L
.41728 .01472 L
.41855 .01472 L
.41994 .01472 L
.4214 .01472 L
.42264 .01472 L
.42398 .01472 L
.42516 .01472 L
.42641 .01472 L
.42754 .01472 L
.42878 .01472 L
.43096 .01472 L
.43229 .01472 L
.43351 .01472 L
.43482 .01472 L
.43624 .01472 L
.43755 .01472 L
.43877 .01472 L
.43993 .01472 L
.44117 .01472 L
.44335 .01472 L
.4454 .01472 L
.44784 .01472 L
.45008 .01472 L
.45228 .01472 L
.45469 .01472 L
.4572 .01472 L
.45955 .01472 L
.46217 .01473 L
.46458 .01473 L
.46724 .01474 L
.46857 .01474 L
.47005 .01475 L
.47252 .01476 L
.47517 .01478 L
.47768 .01481 L
.47997 .01484 L
.48233 .01488 L
.48453 .01494 L
Mistroke
.48693 .01501 L
.4895 .01511 L
.49194 .01524 L
.49424 .0154 L
.49855 .01582 L
.50096 .01614 L
.50321 .01652 L
.50588 .01709 L
.50832 .01774 L
.5133 .01961 L
.51604 .02103 L
.51863 .0227 L
.52323 .02664 L
.52748 .03169 L
.53215 .03925 L
.53711 .0502 L
.542 .06466 L
.54648 .08173 L
.55658 .13609 L
.56549 .20415 L
.57487 .29427 L
.58514 .40468 L
.59484 .50277 L
.59907 .53845 L
.60354 .56895 L
.60588 .58138 L
.60712 .58691 L
.60845 .59199 L
.60968 .59584 L
.61079 .59868 L
.61192 .60087 L
.61298 .60231 L
.61422 .60322 L
.61534 .60332 L
.61663 .60258 L
.61785 .60106 L
.61898 .59892 L
.62002 .59636 L
.62237 .58851 L
.62474 .57773 L
.62735 .56284 L
.6326 .52416 L
.65355 .30967 L
.6636 .21114 L
.6731 .1374 L
.67836 .10597 L
.68406 .07899 L
.68924 .06025 L
.69403 .0471 L
.69868 .03751 L
Mistroke
.70369 .02999 L
.70842 .02496 L
.71274 .0217 L
.71536 .02021 L
.71779 .01908 L
.72068 .01802 L
.72331 .01726 L
.72564 .01672 L
.72817 .01626 L
.73084 .01588 L
.73336 .0156 L
.73573 .0154 L
.73827 .01523 L
.74067 .0151 L
.74285 .01501 L
.74542 .01494 L
.74821 .01487 L
.75084 .01483 L
.75328 .0148 L
.75578 .01477 L
.75813 .01476 L
.76071 .01475 L
.76204 .01474 L
.76349 .01474 L
.76624 .01473 L
.76775 .01473 L
.76915 .01472 L
.77166 .01472 L
.77306 .01472 L
.77434 .01472 L
.77664 .01472 L
.77918 .01472 L
.78046 .01472 L
.78183 .01472 L
.78301 .01472 L
.78431 .01472 L
.78559 .01472 L
.78677 .01472 L
.78911 .01472 L
.79124 .01472 L
.79351 .01472 L
.79491 .01472 L
.79621 .01472 L
.7976 .01472 L
.79912 .01472 L
.8017 .01472 L
.8031 .01472 L
.80441 .01472 L
.8057 .01472 L
.80691 .01472 L
Mistroke
.80918 .01472 L
.81046 .01472 L
.81163 .01472 L
.81293 .01472 L
.8143 .01472 L
.81545 .01472 L
.81672 .01472 L
.81894 .01472 L
.82019 .01472 L
.82153 .01472 L
.82394 .01472 L
.82511 .01472 L
.82638 .01472 L
.82749 .01472 L
.82868 .01472 L
.82974 .01472 L
.83092 .01472 L
.83298 .01472 L
.83436 .01472 L
.83567 .01472 L
.83684 .01472 L
.83812 .01472 L
.8395 .01472 L
.84098 .01472 L
.84237 .01472 L
.84363 .01472 L
.84492 .01472 L
.8461 .01472 L
.8474 .01472 L
.84876 .01472 L
.84996 .01472 L
.85107 .01472 L
.85229 .01472 L
.85359 .01472 L
.85482 .01472 L
.85617 .01472 L
.85758 .01472 L
.8589 .01472 L
.86013 .01472 L
.86126 .01472 L
.86257 .01472 L
.8638 .01472 L
.86513 .01472 L
.86655 .01472 L
.86789 .01472 L
.8691 .01472 L
.87054 .01472 L
.87129 .01472 L
.87208 .01472 L
.87355 .01472 L
Mistroke
.87489 .01472 L
.87614 .01472 L
.87729 .01472 L
.87861 .01472 L
.87986 .01472 L
.88101 .01472 L
.88208 .01472 L
.88325 .01472 L
.88449 .01472 L
.88573 .01472 L
.88708 .01472 L
.88834 .01472 L
.8895 .01472 L
.89079 .01472 L
.89219 .01472 L
.8929 .01472 L
.89366 .01472 L
.89503 .01472 L
.89626 .01472 L
.89762 .01472 L
.8983 .01472 L
.89903 .01472 L
.90036 .01472 L
.90167 .01472 L
.90293 .01472 L
.90405 .01472 L
.90527 .01472 L
.90603 .01472 L
.90673 .01472 L
.90806 .01472 L
.9088 .01472 L
.90949 .01472 L
.91029 .01472 L
.91103 .01472 L
.91227 .01472 L
.91293 .01472 L
.91363 .01472 L
.91437 .01472 L
.91507 .01472 L
.91637 .01472 L
.91753 .01472 L
.91881 .01472 L
.91945 .01472 L
.92014 .01472 L
.92139 .01472 L
.92257 .01472 L
.92381 .01472 L
.92487 .01472 L
.92603 .01472 L
.92674 .01472 L
Mistroke
.92741 .01472 L
.92866 .01472 L
.92936 .01472 L
.93001 .01472 L
.93076 .01472 L
.93147 .01472 L
.93264 .01472 L
.93393 .01472 L
.93518 .01472 L
.93588 .01472 L
.93652 .01472 L
.93769 .01472 L
.93879 .01472 L
.94 .01472 L
.9413 .01472 L
.94259 .01472 L
.94324 .01472 L
.94395 .01472 L
.94521 .01472 L
.94638 .01472 L
.94757 .01472 L
.94869 .01472 L
.9497 .01472 L
.9508 .01472 L
.95199 .01472 L
.95325 .01472 L
.95433 .01472 L
.95551 .01472 L
.95617 .01472 L
.95689 .01472 L
.9582 .01472 L
.95948 .01472 L
.96066 .01472 L
.96138 .01472 L
.96206 .01472 L
.96334 .01472 L
.96405 .01472 L
.96471 .01472 L
.96542 .01472 L
.96619 .01472 L
.96739 .01472 L
.96851 .01472 L
.96919 .01472 L
.96984 .01472 L
.97105 .01472 L
.97233 .01472 L
.97352 .01472 L
.97481 .01472 L
.97547 .01472 L
.97619 .01472 L
Mistroke
Mfstroke
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.0.10"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[8]= ",
 CellTags->"S5.0.10"]
}, Open  ]],

Cell[TextData[{
 "The \[OpenCurlyDoubleQuote]true\[CloseCurlyDoubleQuote] values for ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Mu]", "1"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Mu]", "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["a",
     "TI"], "1"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["a",
     "TI"], "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " (",
 Cell[BoxData[
  FormBox["3.0", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", ",
 Cell[BoxData[
  FormBox["18.0", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", ",
 Cell[BoxData[
  FormBox["0.6", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", ",
 Cell[BoxData[
  FormBox["2.0", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ") lie within the ",
 Cell[BoxData[
  FormBox[
   RowBox[{"95", "%"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " confidence intervals ",
 StyleBox["NonlinearRegress", "MR"],
 " provides for the parameter estimates. The true value for ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Sigma]", "3"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " (",
 Cell[BoxData[
  FormBox["2.0", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ") falls outside the ",
 Cell[BoxData[
  FormBox[
   RowBox[{"95", "%"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " interval. "
}], "MathCaption",
 CellTags->{"S5.0.10", "10.12"}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"NumberForm", "[", 
    RowBox[{"#1", ",", "3"}], "]"}], "&"}], "[", 
  RowBox[{"regress", " ", "=", 
   RowBox[{"NonlinearRegress", "[", 
    RowBox[{"data", ",", " ", "model", ",", " ", "x", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Mu]", "1"], ",", " ", 
         SubscriptBox["\[Mu]", "10"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Mu]", "2"], ",", " ", 
         SubscriptBox["\[Mu]", "20"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["a", "1"], ",", " ", 
         SubscriptBox["a", "10"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["a", "2"], ",", " ", 
         SubscriptBox["a", "20"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "3"], ",", " ", 
         SubscriptBox["\[Sigma]", "30"]}], "}"}]}], "}"}], ",", 
     RowBox[{"RegressionReport", "->", 
      RowBox[{"{", 
       RowBox[{
       "BestFitParameters", ",", "ParameterCITable", ",", "EstimatedVariance",
         ",", "FitCurvatureTable"}], "}"}]}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[9]:= ",
 CellTags->"S5.0.10"],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"BestFitParameters", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SubscriptBox["\[Mu]", 
         InterpretationBox["\<\"1\"\>",
          1,
          Editable->False]], "\[Rule]", 
        InterpretationBox["\<\"-0.642\"\>",
         -0.641965649132674,
         AutoDelete->True]}], ",", 
       RowBox[{
        SubscriptBox["\[Mu]", 
         InterpretationBox["\<\"2\"\>",
          2,
          Editable->False]], "\[Rule]", 
        InterpretationBox["\<\"18.5\"\>",
         18.4640543685611,
         AutoDelete->True]}], ",", 
       RowBox[{
        SubscriptBox["a", 
         InterpretationBox["\<\"1\"\>",
          1,
          Editable->False]], "\[Rule]", 
        InterpretationBox["\<\"1.82\"\>",
         1.81643296426912,
         AutoDelete->True]}], ",", 
       RowBox[{
        SubscriptBox["a", 
         InterpretationBox["\<\"2\"\>",
          2,
          Editable->False]], "\[Rule]", 
        InterpretationBox["\<\"2.01\"\>",
         2.00561888719204,
         AutoDelete->True]}], ",", 
       RowBox[{
        SubscriptBox["\[Sigma]", 
         InterpretationBox["\<\"3\"\>",
          3,
          Editable->False]], "\[Rule]", 
        InterpretationBox["\<\"5.16\"\>",
         5.16387083895852,
         AutoDelete->True]}]}], "}"}]}], ",", 
    RowBox[{"ParameterCITable", "\[Rule]", 
     TagBox[GridBox[{
        {"\<\"\"\>", "\<\"Estimate\"\>", "\<\"Asymptotic SE\"\>", \
"\<\"CI\"\>"},
        {
         SubscriptBox["\[Mu]", 
          InterpretationBox["\<\"1\"\>",
           1,
           Editable->False]], 
         InterpretationBox["\<\"-0.642\"\>",
          -0.641965649132674,
          AutoDelete->True], 
         InterpretationBox["\<\"2.7\"\>",
          2.69671392635218,
          AutoDelete->True], 
         RowBox[{"{", 
          RowBox[{
           InterpretationBox["\<\"-6.2\"\>",
            -6.19595194620169,
            AutoDelete->True], ",", 
           InterpretationBox["\<\"4.91\"\>",
            4.91202064793634,
            AutoDelete->True]}], "}"}]},
        {
         SubscriptBox["\[Mu]", 
          InterpretationBox["\<\"2\"\>",
           2,
           Editable->False]], 
         InterpretationBox["\<\"18.5\"\>",
          18.4640543685611,
          AutoDelete->True], 
         InterpretationBox["\<\"0.57\"\>",
          0.570307529457681,
          AutoDelete->True], 
         RowBox[{"{", 
          RowBox[{
           InterpretationBox["\<\"17.3\"\>",
            17.2894840247175,
            AutoDelete->True], ",", 
           InterpretationBox["\<\"19.6\"\>",
            19.6386247124047,
            AutoDelete->True]}], "}"}]},
        {
         SubscriptBox["a", 
          InterpretationBox["\<\"1\"\>",
           1,
           Editable->False]], 
         InterpretationBox["\<\"1.82\"\>",
          1.81643296426912,
          AutoDelete->True], 
         InterpretationBox["\<\"0.591\"\>",
          0.591305042835452,
          AutoDelete->True], 
         RowBox[{"{", 
          RowBox[{
           InterpretationBox["\<\"0.599\"\>",
            0.598617432112065,
            AutoDelete->True], ",", 
           InterpretationBox["\<\"3.03\"\>",
            3.03424849642617,
            AutoDelete->True]}], "}"}]},
        {
         SubscriptBox["a", 
          InterpretationBox["\<\"2\"\>",
           2,
           Editable->False]], 
         InterpretationBox["\<\"2.01\"\>",
          2.00561888719204,
          AutoDelete->True], 
         InterpretationBox["\<\"0.181\"\>",
          0.181121933460161,
          AutoDelete->True], 
         RowBox[{"{", 
          RowBox[{
           InterpretationBox["\<\"1.63\"\>",
            1.63259128248162,
            AutoDelete->True], ",", 
           InterpretationBox["\<\"2.38\"\>",
            2.37864649190245,
            AutoDelete->True]}], "}"}]},
        {
         SubscriptBox["\[Sigma]", 
          InterpretationBox["\<\"3\"\>",
           3,
           Editable->False]], 
         InterpretationBox["\<\"5.16\"\>",
          5.16387083895852,
          AutoDelete->True], 
         InterpretationBox["\<\"0.573\"\>",
          0.573401352276042,
          AutoDelete->True], 
         RowBox[{"{", 
          RowBox[{
           InterpretationBox["\<\"3.98\"\>",
            3.98292864774514,
            AutoDelete->True], ",", 
           InterpretationBox["\<\"6.34\"\>",
            6.3448130301719,
            AutoDelete->True]}], "}"}]}
        },
       RowSpacings->1,
       ColumnSpacings->3,
       RowAlignments->Baseline,
       ColumnAlignments->{Left}],
      Function[BoxForm`e$, 
       TableForm[BoxForm`e$, TableDepth -> 2, TableHeadings -> {{
           Subscript[\[Mu], 1], 
           Subscript[\[Mu], 2], 
           Subscript[a, 1], 
           Subscript[a, 2], 
           Subscript[\[Sigma], 3]}, {"Estimate", "Asymptotic SE", "CI"}}]]]}],
     ",", 
    RowBox[{"EstimatedVariance", "\[Rule]", 
     InterpretationBox["\<\"0.194\"\>",
      0.19361873798409,
      AutoDelete->True]}], ",", 
    RowBox[{"FitCurvatureTable", "\[Rule]", 
     TagBox[GridBox[{
        {"\<\"\"\>", "\<\"Curvature\"\>"},
        {"\<\"Max Intrinsic\"\>", 
         InterpretationBox["\<\"0.35\"\>",
          0.349726682711138,
          AutoDelete->True]},
        {"\<\"Max Parameter-Effects\"\>", 
         InterpretationBox["\<\"4.35\"\>",
          4.34923201820881,
          AutoDelete->True]},
        {"\<\"95. % Confidence Region\"\>", 
         InterpretationBox["\<\"0.62\"\>",
          0.619817689578136,
          AutoDelete->True]}
        },
       RowSpacings->1,
       ColumnSpacings->3,
       RowAlignments->Baseline,
       ColumnAlignments->{Left}],
      Function[BoxForm`e$, 
       TableForm[
       BoxForm`e$, TableDepth -> 2, 
        TableHeadings -> {{
          "Max Intrinsic", "Max Parameter-Effects", 
           "95. % Confidence Region"}, {"Curvature"}}]]]}]}], "}"}],
  (NumberForm[#, 3]& )]], "Output",
 CellLabel->"Out[9]//NumberForm= ",
 CellTags->"S5.0.10"]
}, Open  ]],

Cell[TextData[{
 "Diagnostics provide an evaluation of the least\[Hyphen]squares fit. Here \
the maximum relative intrinsic curvature is smaller than the relative \
curvature of the ",
 Cell[BoxData[
  FormBox[
   RowBox[{"95", "%"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " confidence region, but not by much. The data analyst should be skeptical \
about whether the intrinsic form of the chosen model is appropriate. The \
maximum relative parameter\[Hyphen]effects curvature is greater than the ",
 Cell[BoxData[
  FormBox[
   RowBox[{"95", "%"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " threshold, indicating that the model parametrization could be improved. "
}], "Text",
 CellTags->{"S5.0.10", "10.13"}],

Cell[TextData[{
 "Recall that the error in the simulated data was uniformly distributed \
between ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox["1.5", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", so there is actually a background constant term of ",
 Cell[BoxData[
  FormBox["0.75", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " unaccounted for in the model. Including the background in the model should \
yield a better fit. "
}], "MathCaption",
 CellTags->{"S5.0.10", "10.14"}],

Cell[CellGroupData[{

Cell["\<\
(trueplot = Plot[peaks, {x, 1, 30},
         DisplayFunction -> Identity];
estimatedplot = Plot[(model /. (BestFitParameters /. regress)),
                {x, 1, 30}, DisplayFunction -> Identity];
Show[dataplot, trueplot, estimatedplot])\
\>", "Input",
 CellLabel->"In[10]:= ",
 CellTags->"S5.0.10"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.031746 0.0147151 0.214698 [
[.18254 .00222 -3 -9 ]
[.18254 .00222 3 0 ]
[.34127 .00222 -6 -9 ]
[.34127 .00222 6 0 ]
[.5 .00222 -6 -9 ]
[.5 .00222 6 0 ]
[.65873 .00222 -6 -9 ]
[.65873 .00222 6 0 ]
[.81746 .00222 -6 -9 ]
[.81746 .00222 6 0 ]
[.97619 .00222 -6 -9 ]
[.97619 .00222 6 0 ]
[.01131 .12206 -18 -4.5 ]
[.01131 .12206 0 4.5 ]
[.01131 .22941 -6 -4.5 ]
[.01131 .22941 0 4.5 ]
[.01131 .33676 -18 -4.5 ]
[.01131 .33676 0 4.5 ]
[.01131 .44411 -6 -4.5 ]
[.01131 .44411 0 4.5 ]
[.01131 .55146 -18 -4.5 ]
[.01131 .55146 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.18254 .01472 m
.18254 .02097 L
s
[(5)] .18254 .00222 0 1 Mshowa
.34127 .01472 m
.34127 .02097 L
s
[(10)] .34127 .00222 0 1 Mshowa
.5 .01472 m
.5 .02097 L
s
[(15)] .5 .00222 0 1 Mshowa
.65873 .01472 m
.65873 .02097 L
s
[(20)] .65873 .00222 0 1 Mshowa
.81746 .01472 m
.81746 .02097 L
s
[(25)] .81746 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(30)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.05556 .01472 m
.05556 .01847 L
s
.0873 .01472 m
.0873 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.15079 .01472 m
.15079 .01847 L
s
.21429 .01472 m
.21429 .01847 L
s
.24603 .01472 m
.24603 .01847 L
s
.27778 .01472 m
.27778 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.37302 .01472 m
.37302 .01847 L
s
.40476 .01472 m
.40476 .01847 L
s
.43651 .01472 m
.43651 .01847 L
s
.46825 .01472 m
.46825 .01847 L
s
.53175 .01472 m
.53175 .01847 L
s
.56349 .01472 m
.56349 .01847 L
s
.59524 .01472 m
.59524 .01847 L
s
.62698 .01472 m
.62698 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.72222 .01472 m
.72222 .01847 L
s
.75397 .01472 m
.75397 .01847 L
s
.78571 .01472 m
.78571 .01847 L
s
.84921 .01472 m
.84921 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.9127 .01472 m
.9127 .01847 L
s
.94444 .01472 m
.94444 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .12206 m
.03006 .12206 L
s
[(0.5)] .01131 .12206 1 0 Mshowa
.02381 .22941 m
.03006 .22941 L
s
[(1)] .01131 .22941 1 0 Mshowa
.02381 .33676 m
.03006 .33676 L
s
[(1.5)] .01131 .33676 1 0 Mshowa
.02381 .44411 m
.03006 .44411 L
s
[(2)] .01131 .44411 1 0 Mshowa
.02381 .55146 m
.03006 .55146 L
s
[(2.5)] .01131 .55146 1 0 Mshowa
.125 Mabswid
.02381 .03618 m
.02756 .03618 L
s
.02381 .05765 m
.02756 .05765 L
s
.02381 .07912 m
.02756 .07912 L
s
.02381 .10059 m
.02756 .10059 L
s
.02381 .14353 m
.02756 .14353 L
s
.02381 .165 m
.02756 .165 L
s
.02381 .18647 m
.02756 .18647 L
s
.02381 .20794 m
.02756 .20794 L
s
.02381 .25088 m
.02756 .25088 L
s
.02381 .27235 m
.02756 .27235 L
s
.02381 .29382 m
.02756 .29382 L
s
.02381 .31529 m
.02756 .31529 L
s
.02381 .35823 m
.02756 .35823 L
s
.02381 .3797 m
.02756 .3797 L
s
.02381 .40117 m
.02756 .40117 L
s
.02381 .42264 m
.02756 .42264 L
s
.02381 .46558 m
.02756 .46558 L
s
.02381 .48705 m
.02756 .48705 L
s
.02381 .50852 m
.02756 .50852 L
s
.02381 .52999 m
.02756 .52999 L
s
.02381 .57293 m
.02756 .57293 L
s
.02381 .5944 m
.02756 .5944 L
s
.02381 .61587 m
.02756 .61587 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.008 w
.05556 .3162 Mdot
.0873 .42899 Mdot
.11905 .3601 Mdot
.15079 .35419 Mdot
.18254 .12567 Mdot
.21429 .14366 Mdot
.24603 .28291 Mdot
.27778 .04003 Mdot
.30952 .32252 Mdot
.34127 .15639 Mdot
.37302 .15094 Mdot
.40476 .26864 Mdot
.43651 .18514 Mdot
.46825 .36537 Mdot
.5 .23465 Mdot
.53175 .40301 Mdot
.56349 .56669 Mdot
.59524 .46095 Mdot
.62698 .60332 Mdot
.65873 .36205 Mdot
.69048 .27356 Mdot
.72222 .21858 Mdot
.75397 .35102 Mdot
.78571 .28753 Mdot
.81746 .23379 Mdot
.84921 .18206 Mdot
.88095 .11561 Mdot
.9127 .05698 Mdot
.94444 .20003 Mdot
.97619 .09479 Mdot
.5 Mabswid
.05556 .09285 m
.07374 .11457 L
.083 .12436 L
.0929 .13306 L
.09817 .13676 L
.10297 .13947 L
.10528 .14054 L
.10779 .14152 L
.11014 .14227 L
.11234 .14282 L
.11357 .14306 L
.1149 .14326 L
.11565 .14335 L
.11637 .14342 L
.11701 .14347 L
.11772 .14351 L
.11847 .14353 L
.11915 .14353 L
.11993 .14352 L
.12067 .14349 L
.12136 .14345 L
.12199 .1434 L
.12341 .14323 L
.12464 .14304 L
.12578 .14281 L
.12838 .14215 L
.13092 .1413 L
.13363 .14018 L
.13874 .13748 L
.14347 .13435 L
.15417 .12526 L
.17362 .10375 L
.19319 .07985 L
.21157 .05926 L
.22913 .04337 L
.24807 .03106 L
.25732 .02674 L
.26744 .02311 L
.278 .02033 L
.28783 .01848 L
.29272 .01778 L
.29801 .01715 L
.30267 .01669 L
.30761 .0163 L
.31206 .016 L
.31696 .01574 L
.32108 .01557 L
.32558 .01542 L
.32819 .01534 L
.33062 .01529 L
Mistroke
.33313 .01524 L
.3354 .0152 L
.33749 .01517 L
.33975 .01515 L
.34099 .01514 L
.34213 .01514 L
.34323 .01513 L
.34438 .01513 L
.34564 .01513 L
.34679 .01513 L
.34742 .01513 L
.34811 .01513 L
.34936 .01513 L
.35054 .01514 L
.35178 .01515 L
.35401 .01517 L
.3566 .0152 L
.35904 .01524 L
.36191 .0153 L
.36457 .01537 L
.36913 .01553 L
.3741 .01575 L
.37895 .01604 L
.38412 .01644 L
.38895 .01692 L
.39351 .01749 L
.40202 .01891 L
.40651 .0199 L
.41144 .02122 L
.41625 .02279 L
.42141 .02484 L
.43063 .02962 L
.43926 .03572 L
.44907 .04506 L
.45976 .05879 L
.46986 .07582 L
.47921 .09556 L
.49723 .14515 L
.51713 .21621 L
.53738 .29822 L
.55597 .36935 L
.56539 .39918 L
.57416 .42109 L
.57858 .42959 L
.58331 .4366 L
.58601 .4396 L
.58734 .4408 L
.58856 .44174 L
.58965 .44245 L
.59085 .44309 L
Mistroke
.59205 .44357 L
.59333 .44392 L
.59458 .44409 L
.59574 .4441 L
.59701 .44395 L
.59772 .44378 L
.59836 .44359 L
.59954 .44313 L
.60082 .44245 L
.60314 .4408 L
.60541 .43863 L
.60781 .43577 L
.61211 .42922 L
.61709 .41942 L
.62173 .4083 L
.6323 .37686 L
.66993 .22968 L
.68909 .15872 L
.6992 .1271 L
.70993 .09872 L
.71945 .07807 L
.72995 .05994 L
.7395 .04721 L
.74846 .03806 L
.75798 .03079 L
.76799 .02532 L
.77654 .022 L
.78138 .02056 L
.78588 .01945 L
.79077 .01846 L
.79606 .0176 L
.80073 .017 L
.80567 .01648 L
.81013 .01611 L
.81503 .01579 L
.81915 .01557 L
.82364 .01538 L
.82869 .01521 L
.83348 .01509 L
.83814 .015 L
.84246 .01493 L
.8476 .01487 L
.85224 .01483 L
.85761 .0148 L
.86266 .01478 L
.86718 .01476 L
.87213 .01475 L
.8773 .01474 L
.88212 .01473 L
.88664 .01473 L
Mistroke
.89076 .01472 L
.8955 .01472 L
.89999 .01472 L
.90445 .01472 L
.90936 .01472 L
.91183 .01472 L
.91449 .01472 L
.91679 .01472 L
.91929 .01472 L
.92177 .01472 L
.92406 .01472 L
.9286 .01472 L
.93272 .01472 L
.93712 .01472 L
.93956 .01472 L
.94215 .01472 L
.94678 .01472 L
.94936 .01472 L
.95176 .01472 L
.95457 .01472 L
.95723 .01472 L
.95952 .01472 L
.96202 .01472 L
.96638 .01472 L
.96885 .01472 L
.97148 .01472 L
.97619 .01472 L
Mfstroke
.05556 .38689 m
.0929 .35371 L
.13363 .30552 L
.17189 .25684 L
.20867 .21434 L
.22918 .19482 L
.24783 .1806 L
.25712 .17495 L
.26721 .16997 L
.27183 .16811 L
.27673 .16643 L
.28124 .16515 L
.28553 .16418 L
.2878 .16377 L
.29028 .16339 L
.29253 .16312 L
.29462 .16293 L
.2959 .16284 L
.29711 .16277 L
.29819 .16273 L
.29936 .16271 L
.29997 .1627 L
.30064 .1627 L
.30134 .1627 L
.30199 .16271 L
.30316 .16274 L
.30441 .1628 L
.30559 .16287 L
.30669 .16295 L
.30916 .1632 L
.31134 .16348 L
.31366 .16385 L
.31767 .16467 L
.3221 .16581 L
.33186 .16925 L
.3408 .17349 L
.36096 .18672 L
.37926 .20283 L
.39927 .22436 L
.43848 .27538 L
.47622 .3295 L
.51633 .38342 L
.53644 .40609 L
.55498 .42312 L
.57304 .43546 L
.58215 .43993 L
.58729 .4419 L
.59217 .4434 L
.59687 .4445 L
.59952 .44497 L
Mistroke
.60199 .44531 L
.60317 .44543 L
.60427 .44553 L
.60528 .4456 L
.60634 .44566 L
.6075 .44571 L
.60856 .44573 L
.60971 .44574 L
.61097 .44572 L
.61162 .4457 L
.61232 .44567 L
.61361 .44559 L
.61486 .4455 L
.61601 .44539 L
.61864 .44506 L
.62142 .44459 L
.62605 .44354 L
.63116 .44199 L
.64094 .4379 L
.6499 .4329 L
.67008 .41743 L
.6884 .39881 L
.70843 .37429 L
.74769 .3173 L
.78548 .25747 L
.82565 .19594 L
.86435 .1439 L
.90158 .10322 L
.94119 .07064 L
.97619 .05023 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.0.10"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[10]= ",
 CellTags->"S5.0.10"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.0.0"->{
    Cell[1776, 53, 112, 4, 61, "Section",
      CellTags->{"S5.0.0", "0.1"}]},
  "0.1"->{
    Cell[1776, 53, 112, 4, 61, "Section",
      CellTags->{"S5.0.0", "0.1"}]},
  "S5.0.1"->{
    Cell[1913, 61, 88, 1, 36, "Subsection",
      CellTags->{"S5.0.1", "1.1"}],
    Cell[2004, 64, 478, 11, 72, "Text",
      CellTags->{"S5.0.1", "1.2"}],
    Cell[2485, 77, 756, 18, 72, "Text",
      CellTags->{"S5.0.1", "1.3"}],
    Cell[3244, 97, 2100, 56, 150, "DefinitionBox",
      CellTags->"S5.0.1"],
    Cell[5347, 155, 96, 3, 15, "Caption",
      CellTags->"S5.0.1"],
    Cell[5446, 160, 569, 10, 88, "Text",
      CellTags->{"S5.0.1", "1.4"}],
    Cell[6018, 172, 1840, 58, 66, "DefinitionBox",
      CellTags->"S5.0.1"],
    Cell[7861, 232, 92, 3, 15, "Caption",
      CellTags->"S5.0.1"],
    Cell[7956, 237, 347, 11, 56, "Text",
      CellTags->{"S5.0.1", "1.5"}]},
  "1.1"->{
    Cell[1913, 61, 88, 1, 36, "Subsection",
      CellTags->{"S5.0.1", "1.1"}]},
  "1.2"->{
    Cell[2004, 64, 478, 11, 72, "Text",
      CellTags->{"S5.0.1", "1.2"}]},
  "1.3"->{
    Cell[2485, 77, 756, 18, 72, "Text",
      CellTags->{"S5.0.1", "1.3"}]},
  "1.4"->{
    Cell[5446, 160, 569, 10, 88, "Text",
      CellTags->{"S5.0.1", "1.4"}]},
  "1.5"->{
    Cell[7956, 237, 347, 11, 56, "Text",
      CellTags->{"S5.0.1", "1.5"}]},
  "S5.0.2"->{
    Cell[8340, 253, 68, 1, 36, "Subsection",
      CellTags->{"S5.0.2", "2.1"}],
    Cell[8411, 256, 816, 20, 70, "Text",
      CellTags->{"S5.0.2", "2.2"}],
    Cell[9230, 278, 133, 5, 70, "MathCaption",
      CellTags->{"S5.0.2", "2.3"}],
    Cell[9366, 285, 72, 2, 70, "Input",
      CellTags->"S5.0.2"],
    Cell[9441, 289, 403, 15, 70, "MathCaption",
      CellTags->{"S5.0.2", "2.4"}],
    Cell[9869, 308, 94, 2, 70, "Input",
      CellTags->"S5.0.2"],
    Cell[9966, 312, 352, 12, 70, "Output",
      CellTags->"S5.0.2"],
    Cell[10333, 327, 191, 5, 70, "MathCaption",
      CellTags->{"S5.0.2", "2.5"}],
    Cell[10549, 336, 87, 2, 70, "Input",
      CellTags->"S5.0.2"],
    Cell[10639, 340, 196, 6, 70, "Output",
      CellTags->"S5.0.2"],
    Cell[10850, 349, 189, 5, 70, "MathCaption",
      CellTags->{"S5.0.2", "2.6"}],
    Cell[11064, 358, 95, 2, 70, "Input",
      CellTags->"S5.0.2"],
    Cell[11162, 362, 175, 6, 70, "Output",
      CellTags->"S5.0.2"],
    Cell[11352, 371, 469, 17, 70, "MathCaption",
      CellTags->{"S5.0.2", "2.7"}],
    Cell[11846, 392, 90, 2, 70, "Input",
      CellTags->"S5.0.2"],
    Cell[11939, 396, 73, 2, 70, "Output",
      CellTags->"S5.0.2"],
    Cell[12027, 401, 599, 25, 70, "Text",
      CellTags->{"S5.0.2", "2.8"}],
    Cell[12629, 428, 185, 5, 70, "MathCaption",
      CellTags->{"S5.0.2", "2.9"}],
    Cell[12817, 435, 85, 2, 70, "Input",
      CellTags->"S5.0.2"],
    Cell[12905, 439, 571, 18, 70, "MathCaption",
      CellTags->{"S5.0.2", "2.10"}],
    Cell[13501, 461, 251, 9, 70, "Input",
      CellTags->"S5.0.2"],
    Cell[13755, 472, 9585, 845, 70, 9515, 842, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.0.2"],
    Cell[23343, 1319, 181, 6, 70, "Output",
      CellTags->"S5.0.2"],
    Cell[23539, 1328, 1409, 51, 70, "Text",
      CellTags->{"S5.0.2", "2.11"}],
    Cell[24951, 1381, 321, 12, 70, "MathCaption",
      CellTags->{"S5.0.2", "2.12"}],
    Cell[25297, 1397, 110, 2, 70, "Input",
      CellTags->"S5.0.2"],
    Cell[25410, 1401, 258, 7, 70, "Output",
      CellTags->"S5.0.2"],
    Cell[25683, 1411, 233, 5, 70, "MathCaption",
      CellTags->{"S5.0.2", "2.13"}],
    Cell[25941, 1420, 195, 7, 70, "Input",
      CellTags->"S5.0.2"],
    Cell[26139, 1429, 6274, 387, 70, 6204, 384, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.0.2"],
    Cell[32416, 1818, 189, 7, 70, "Output",
      CellTags->"S5.0.2"],
    Cell[32620, 1828, 285, 6, 70, "MathCaption",
      CellTags->{"S5.0.2", "2.14"}],
    Cell[32930, 1838, 305, 9, 70, "Input",
      CellTags->"S5.0.2"],
    Cell[33238, 1849, 6274, 387, 70, 6204, 384, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.0.2"],
    Cell[39515, 2238, 190, 7, 70, "Output",
      CellTags->"S5.0.2"],
    Cell[39720, 2248, 188, 4, 70, "MathCaption",
      CellTags->{"S5.0.2", "2.15"}],
    Cell[39911, 2254, 236, 7, 70, "Input",
      CellTags->"S5.0.2"],
    Cell[40150, 2263, 175, 4, 70, "MathCaption",
      CellTags->{"S5.0.2", "2.16"}],
    Cell[40350, 2271, 270, 8, 70, "Input",
      CellTags->"S5.0.2"],
    Cell[40623, 2281, 6274, 387, 70, 6204, 384, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.0.2"],
    Cell[46900, 2670, 190, 7, 70, "Output",
      CellTags->"S5.0.2"]},
  "2.1"->{
    Cell[8340, 253, 68, 1, 36, "Subsection",
      CellTags->{"S5.0.2", "2.1"}]},
  "2.2"->{
    Cell[8411, 256, 816, 20, 70, "Text",
      CellTags->{"S5.0.2", "2.2"}]},
  "2.3"->{
    Cell[9230, 278, 133, 5, 70, "MathCaption",
      CellTags->{"S5.0.2", "2.3"}]},
  "2.4"->{
    Cell[9441, 289, 403, 15, 70, "MathCaption",
      CellTags->{"S5.0.2", "2.4"}]},
  "2.5"->{
    Cell[10333, 327, 191, 5, 70, "MathCaption",
      CellTags->{"S5.0.2", "2.5"}]},
  "2.6"->{
    Cell[10850, 349, 189, 5, 70, "MathCaption",
      CellTags->{"S5.0.2", "2.6"}]},
  "2.7"->{
    Cell[11352, 371, 469, 17, 70, "MathCaption",
      CellTags->{"S5.0.2", "2.7"}]},
  "2.8"->{
    Cell[12027, 401, 599, 25, 70, "Text",
      CellTags->{"S5.0.2", "2.8"}]},
  "2.9"->{
    Cell[12629, 428, 185, 5, 70, "MathCaption",
      CellTags->{"S5.0.2", "2.9"}]},
  "2.10"->{
    Cell[12905, 439, 571, 18, 70, "MathCaption",
      CellTags->{"S5.0.2", "2.10"}]},
  "2.11"->{
    Cell[23539, 1328, 1409, 51, 70, "Text",
      CellTags->{"S5.0.2", "2.11"}]},
  "2.12"->{
    Cell[24951, 1381, 321, 12, 70, "MathCaption",
      CellTags->{"S5.0.2", "2.12"}]},
  "2.13"->{
    Cell[25683, 1411, 233, 5, 70, "MathCaption",
      CellTags->{"S5.0.2", "2.13"}]},
  "2.14"->{
    Cell[32620, 1828, 285, 6, 70, "MathCaption",
      CellTags->{"S5.0.2", "2.14"}]},
  "2.15"->{
    Cell[39720, 2248, 188, 4, 70, "MathCaption",
      CellTags->{"S5.0.2", "2.15"}]},
  "2.16"->{
    Cell[40150, 2263, 175, 4, 70, "MathCaption",
      CellTags->{"S5.0.2", "2.16"}]},
  "S5.0.3"->{
    Cell[47139, 2683, 69, 1, 70, "Subsection",
      CellTags->{"S5.0.3", "3.1"}],
    Cell[47211, 2686, 726, 15, 70, "Text",
      CellTags->{"S5.0.3", "3.2"}],
    Cell[47940, 2703, 147, 5, 70, "MathCaption",
      CellTags->{"S5.0.3", "3.3"}],
    Cell[48090, 2710, 73, 2, 70, "Input",
      CellTags->"S5.0.3"],
    Cell[48166, 2714, 1131, 33, 70, "Text",
      CellTags->{"S5.0.3", "3.4"}],
    Cell[49300, 2749, 897, 31, 70, "MathCaption",
      CellTags->{"S5.0.3", "3.5"}],
    Cell[50222, 2784, 206, 7, 70, "Input",
      CellTags->"S5.0.3"],
    Cell[50431, 2793, 201, 8, 70, "Output",
      CellTags->"S5.0.3"],
    Cell[50647, 2804, 535, 19, 70, "MathCaption",
      CellTags->{"S5.0.3", "3.6"}],
    Cell[51207, 2827, 138, 5, 70, "Input",
      CellTags->"S5.0.3"],
    Cell[51348, 2834, 251, 8, 70, "Output",
      CellTags->"S5.0.3"]},
  "3.1"->{
    Cell[47139, 2683, 69, 1, 70, "Subsection",
      CellTags->{"S5.0.3", "3.1"}]},
  "3.2"->{
    Cell[47211, 2686, 726, 15, 70, "Text",
      CellTags->{"S5.0.3", "3.2"}]},
  "3.3"->{
    Cell[47940, 2703, 147, 5, 70, "MathCaption",
      CellTags->{"S5.0.3", "3.3"}]},
  "3.4"->{
    Cell[48166, 2714, 1131, 33, 70, "Text",
      CellTags->{"S5.0.3", "3.4"}]},
  "3.5"->{
    Cell[49300, 2749, 897, 31, 70, "MathCaption",
      CellTags->{"S5.0.3", "3.5"}]},
  "3.6"->{
    Cell[50647, 2804, 535, 19, 70, "MathCaption",
      CellTags->{"S5.0.3", "3.6"}]},
  "S5.0.4"->{
    Cell[51648, 2848, 81, 1, 70, "Subsection",
      CellTags->{"S5.0.4", "4.1"}],
    Cell[51732, 2851, 567, 13, 70, "Text",
      CellTags->{"S5.0.4", "4.2"}],
    Cell[52302, 2866, 151, 5, 70, "MathCaption",
      CellTags->{"S5.0.4", "4.3"}],
    Cell[52456, 2873, 77, 2, 70, "Input",
      CellTags->"S5.0.4"],
    Cell[52536, 2877, 274, 7, 70, "MathCaption",
      CellTags->{"S5.0.4", "4.4"}],
    Cell[52835, 2888, 87, 2, 70, "Input",
      CellTags->"S5.0.4"],
    Cell[52925, 2892, 3769, 315, 70, 3699, 312, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.0.4"],
    Cell[56697, 3209, 179, 6, 70, "Output",
      CellTags->"S5.0.4"],
    Cell[56891, 3218, 511, 15, 70, "MathCaption",
      CellTags->{"S5.0.4", "4.5"}],
    Cell[57405, 3235, 142, 5, 70, "Input",
      CellTags->"S5.0.4"],
    Cell[57550, 3242, 354, 6, 70, "MathCaption",
      CellTags->{"S5.0.4", "4.6"}],
    Cell[57929, 3252, 434, 12, 70, "Input",
      CellTags->"S5.0.4"],
    Cell[58366, 3266, 18181, 1173, 70, 18111, 1170, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.0.4"],
    Cell[76550, 4441, 179, 6, 70, "Output",
      CellTags->"S5.0.4"],
    Cell[76744, 4450, 193, 4, 70, "MathCaption",
      CellTags->{"S5.0.4", "4.7"}],
    Cell[76962, 4458, 182, 6, 70, "Input",
      CellTags->"S5.0.4"],
    Cell[77147, 4466, 18385, 985, 70, 18315, 982, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.0.4"],
    Cell[95535, 5453, 181, 6, 70, "Output",
      CellTags->"S5.0.4"]},
  "4.1"->{
    Cell[51648, 2848, 81, 1, 70, "Subsection",
      CellTags->{"S5.0.4", "4.1"}]},
  "4.2"->{
    Cell[51732, 2851, 567, 13, 70, "Text",
      CellTags->{"S5.0.4", "4.2"}]},
  "4.3"->{
    Cell[52302, 2866, 151, 5, 70, "MathCaption",
      CellTags->{"S5.0.4", "4.3"}]},
  "4.4"->{
    Cell[52536, 2877, 274, 7, 70, "MathCaption",
      CellTags->{"S5.0.4", "4.4"}]},
  "4.5"->{
    Cell[56891, 3218, 511, 15, 70, "MathCaption",
      CellTags->{"S5.0.4", "4.5"}]},
  "4.6"->{
    Cell[57550, 3242, 354, 6, 70, "MathCaption",
      CellTags->{"S5.0.4", "4.6"}]},
  "4.7"->{
    Cell[76744, 4450, 193, 4, 70, "MathCaption",
      CellTags->{"S5.0.4", "4.7"}]},
  "S5.0.5"->{
    Cell[95765, 5465, 82, 1, 70, "Subsection",
      CellTags->{"S5.0.5", "5.1"}],
    Cell[95850, 5468, 941, 18, 70, "Text",
      CellTags->{"S5.0.5", "5.2"}],
    Cell[96794, 5488, 183, 5, 70, "MathCaption",
      CellTags->{"S5.0.5", "5.3"}],
    Cell[96980, 5495, 73, 2, 70, "Input",
      CellTags->"S5.0.5"],
    Cell[97056, 5499, 173, 5, 70, "MathCaption",
      CellTags->{"S5.0.5", "5.4"}],
    Cell[97254, 5508, 658, 18, 70, "Input",
      CellTags->"S5.0.5"],
    Cell[97915, 5528, 18835, 858, 70, 18765, 855, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.0.5"],
    Cell[116753, 6388, 179, 6, 70, "Output",
      CellTags->"S5.0.5"],
    Cell[116947, 6397, 504, 17, 70, "MathCaption",
      CellTags->{"S5.0.5", "5.5"}],
    Cell[117476, 6418, 290, 9, 70, "Input",
      CellTags->"S5.0.5"],
    Cell[117769, 6429, 32603, 1772, 70, 32533, 1769, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.0.5"],
    Cell[150375, 8203, 181, 6, 70, "Output",
      CellTags->"S5.0.5"],
    Cell[150571, 8212, 484, 11, 70, "MathCaption",
      CellTags->{"S5.0.5", "5.6"}],
    Cell[151080, 8227, 1539, 44, 70, "Input",
      CellTags->"S5.0.5"],
    Cell[152622, 8273, 13328, 720, 70, 13258, 717, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.0.5"],
    Cell[165953, 8995, 179, 6, 70, "Output",
      CellTags->"S5.0.5"],
    Cell[166147, 9004, 143, 4, 70, "MathCaption",
      CellTags->{"S5.0.5", "5.7"}],
    Cell[166315, 9012, 234, 7, 70, "Input",
      CellTags->"S5.0.5"],
    Cell[166552, 9021, 6291, 430, 70, 6221, 427, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.0.5"],
    Cell[172846, 9453, 181, 6, 70, "Output",
      CellTags->"S5.0.5"],
    Cell[173042, 9462, 128, 3, 70, "MathCaption",
      CellTags->{"S5.0.5", "5.8"}],
    Cell[173173, 9467, 84, 2, 70, "Input",
      CellTags->"S5.0.5"],
    Cell[173260, 9471, 297, 6, 70, "MathCaption",
      CellTags->{"S5.0.5", "5.9"}],
    Cell[173582, 9481, 1675, 48, 70, "Input",
      CellTags->"S5.0.5"],
    Cell[175260, 9531, 40676, 2881, 70, 40606, 2878, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.0.5"],
    Cell[215939, 12414, 184, 6, 70, "Output",
      CellTags->"S5.0.5"],
    Cell[216138, 12423, 135, 5, 70, "MathCaption",
      CellTags->{"S5.0.5", "5.10"}],
    Cell[216276, 12430, 73, 2, 70, "Input",
      CellTags->"S5.0.5"],
    Cell[216352, 12434, 190, 4, 70, "MathCaption",
      CellTags->{"S5.0.5", "5.11"}],
    Cell[216567, 12442, 385, 13, 70, "Input",
      CellTags->"S5.0.5"],
    Cell[216955, 12457, 16216, 809, 70, 16146, 806, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.0.5"],
    Cell[233174, 13268, 181, 6, 70, "Output",
      CellTags->"S5.0.5"]},
  "5.1"->{
    Cell[95765, 5465, 82, 1, 70, "Subsection",
      CellTags->{"S5.0.5", "5.1"}]},
  "5.2"->{
    Cell[95850, 5468, 941, 18, 70, "Text",
      CellTags->{"S5.0.5", "5.2"}]},
  "5.3"->{
    Cell[96794, 5488, 183, 5, 70, "MathCaption",
      CellTags->{"S5.0.5", "5.3"}]},
  "5.4"->{
    Cell[97056, 5499, 173, 5, 70, "MathCaption",
      CellTags->{"S5.0.5", "5.4"}]},
  "5.5"->{
    Cell[116947, 6397, 504, 17, 70, "MathCaption",
      CellTags->{"S5.0.5", "5.5"}]},
  "5.6"->{
    Cell[150571, 8212, 484, 11, 70, "MathCaption",
      CellTags->{"S5.0.5", "5.6"}]},
  "5.7"->{
    Cell[166147, 9004, 143, 4, 70, "MathCaption",
      CellTags->{"S5.0.5", "5.7"}]},
  "5.8"->{
    Cell[173042, 9462, 128, 3, 70, "MathCaption",
      CellTags->{"S5.0.5", "5.8"}]},
  "5.9"->{
    Cell[173260, 9471, 297, 6, 70, "MathCaption",
      CellTags->{"S5.0.5", "5.9"}]},
  "5.10"->{
    Cell[216138, 12423, 135, 5, 70, "MathCaption",
      CellTags->{"S5.0.5", "5.10"}]},
  "5.11"->{
    Cell[216352, 12434, 190, 4, 70, "MathCaption",
      CellTags->{"S5.0.5", "5.11"}]},
  "S5.0.6"->{
    Cell[233404, 13280, 75, 1, 70, "Subsection",
      CellTags->{"S5.0.6", "6.1"}],
    Cell[233482, 13283, 360, 8, 70, "Text",
      CellTags->{"S5.0.6", "6.2"}],
    Cell[233845, 13293, 423, 10, 70, "Text",
      CellTags->{"S5.0.6", "6.3"}],
    Cell[234271, 13305, 1917, 83, 70, "Text",
      CellTags->{"S5.0.6", "6.4"}],
    Cell[236191, 13390, 135, 3, 70, "MathCaption",
      CellTags->{"S5.0.6", "6.5"}],
    Cell[236329, 13395, 79, 2, 70, "Input",
      CellTags->"S5.0.6"],
    Cell[236411, 13399, 620, 21, 70, "MathCaption",
      CellTags->{"S5.0.6", "6.6"}],
    Cell[237056, 13424, 413, 13, 70, "Input",
      CellTags->"S5.0.6"],
    Cell[237472, 13439, 697, 20, 70, "Output",
      CellTags->"S5.0.6"],
    Cell[238184, 13462, 972, 34, 70, "MathCaption",
      CellTags->{"S5.0.6", "6.7"}],
    Cell[239181, 13500, 586, 20, 70, "Input",
      CellTags->"S5.0.6"],
    Cell[239770, 13522, 513, 18, 70, "Output",
      CellTags->"S5.0.6"],
    Cell[240298, 13543, 373, 12, 70, "MathCaption",
      CellTags->{"S5.0.6", "6.8"}],
    Cell[240696, 13559, 655, 21, 70, "Input",
      CellTags->"S5.0.6"],
    Cell[241354, 13582, 1448, 44, 70, "Output",
      CellTags->"S5.0.6"],
    Cell[242817, 13629, 752, 22, 70, "MathCaption",
      CellTags->{"S5.0.6", "6.9"}],
    Cell[243594, 13655, 452, 14, 70, "Input",
      CellTags->"S5.0.6"],
    Cell[244049, 13671, 320, 11, 70, "Output",
      CellTags->"S5.0.6"],
    Cell[244384, 13685, 606, 20, 70, "MathCaption",
      CellTags->{"S5.0.6", "6.10"}],
    Cell[245015, 13709, 316, 10, 70, "Input",
      CellTags->"S5.0.6"],
    Cell[245334, 13721, 1402, 44, 70, "Output",
      CellTags->"S5.0.6"],
    Cell[246751, 13768, 859, 29, 70, "MathCaption",
      CellTags->{"S5.0.6", "6.11"}],
    Cell[247635, 13801, 241, 8, 70, "Input",
      CellTags->"S5.0.6"],
    Cell[247879, 13811, 77, 2, 70, "Output",
      CellTags->"S5.0.6"],
    Cell[247971, 13816, 413, 14, 70, "Text",
      CellTags->{"S5.0.6", "6.12"}],
    Cell[248387, 13832, 47, 1, 70, "Text",
      CellTags->{"S5.0.6", "6.13"}],
    Cell[248437, 13835, 8895, 222, 70, "DisplayFormula",
      CellTags->{"S5.0.6", "6.14"}],
    Cell[257335, 14059, 1939, 73, 70, "Text",
      CellTags->{"S5.0.6", "6.15"}]},
  "6.1"->{
    Cell[233404, 13280, 75, 1, 70, "Subsection",
      CellTags->{"S5.0.6", "6.1"}]},
  "6.2"->{
    Cell[233482, 13283, 360, 8, 70, "Text",
      CellTags->{"S5.0.6", "6.2"}]},
  "6.3"->{
    Cell[233845, 13293, 423, 10, 70, "Text",
      CellTags->{"S5.0.6", "6.3"}]},
  "6.4"->{
    Cell[234271, 13305, 1917, 83, 70, "Text",
      CellTags->{"S5.0.6", "6.4"}]},
  "6.5"->{
    Cell[236191, 13390, 135, 3, 70, "MathCaption",
      CellTags->{"S5.0.6", "6.5"}]},
  "6.6"->{
    Cell[236411, 13399, 620, 21, 70, "MathCaption",
      CellTags->{"S5.0.6", "6.6"}]},
  "6.7"->{
    Cell[238184, 13462, 972, 34, 70, "MathCaption",
      CellTags->{"S5.0.6", "6.7"}]},
  "6.8"->{
    Cell[240298, 13543, 373, 12, 70, "MathCaption",
      CellTags->{"S5.0.6", "6.8"}]},
  "6.9"->{
    Cell[242817, 13629, 752, 22, 70, "MathCaption",
      CellTags->{"S5.0.6", "6.9"}]},
  "6.10"->{
    Cell[244384, 13685, 606, 20, 70, "MathCaption",
      CellTags->{"S5.0.6", "6.10"}]},
  "6.11"->{
    Cell[246751, 13768, 859, 29, 70, "MathCaption",
      CellTags->{"S5.0.6", "6.11"}]},
  "6.12"->{
    Cell[247971, 13816, 413, 14, 70, "Text",
      CellTags->{"S5.0.6", "6.12"}]},
  "6.13"->{
    Cell[248387, 13832, 47, 1, 70, "Text",
      CellTags->{"S5.0.6", "6.13"}]},
  "6.14"->{
    Cell[248437, 13835, 8895, 222, 70, "DisplayFormula",
      CellTags->{"S5.0.6", "6.14"}]},
  "6.15"->{
    Cell[257335, 14059, 1939, 73, 70, "Text",
      CellTags->{"S5.0.6", "6.15"}]},
  "S5.0.7"->{
    Cell[259311, 14137, 74, 1, 70, "Subsection",
      CellTags->{"S5.0.7", "7.1"}],
    Cell[259388, 14140, 609, 13, 70, "Text",
      CellTags->{"S5.0.7", "7.2"}],
    Cell[260000, 14155, 123, 3, 70, "MathCaption",
      CellTags->{"S5.0.7", "7.3"}],
    Cell[260126, 14160, 84, 2, 70, "Input",
      CellTags->"S5.0.7"],
    Cell[260213, 14164, 527, 14, 70, "MathCaption",
      CellTags->{"S5.0.7", "7.4"}],
    Cell[260765, 14182, 154, 5, 70, "Input",
      CellTags->"S5.0.7"],
    Cell[260922, 14189, 141, 4, 70, "Output",
      CellTags->"S5.0.7"],
    Cell[261078, 14196, 183, 6, 70, "MathCaption",
      CellTags->{"S5.0.7", "7.5"}],
    Cell[261264, 14204, 84, 2, 70, "Input",
      CellTags->"S5.0.7"],
    Cell[261351, 14208, 113, 2, 70, "MathCaption",
      CellTags->{"S5.0.7", "7.6"}],
    Cell[261489, 14214, 145, 5, 70, "Input",
      CellTags->"S5.0.7"],
    Cell[261637, 14221, 9105, 154, 70, 9035, 151, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.0.7"],
    Cell[270745, 14377, 176, 6, 70, "Output",
      CellTags->"S5.0.7"],
    Cell[270936, 14386, 160, 5, 70, "MathCaption",
      CellTags->{"S5.0.7", "7.7"}],
    Cell[271099, 14393, 88, 2, 70, "Input",
      CellTags->"S5.0.7"],
    Cell[271190, 14397, 80, 1, 70, "MathCaption",
      CellTags->{"S5.0.7", "7.8"}],
    Cell[271295, 14402, 80, 2, 70, "Input",
      CellTags->"S5.0.7"],
    Cell[271378, 14406, 21658, 1441, 70, 21588, 1438, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.0.7"],
    Cell[293039, 15849, 95, 2, 70, "Output",
      CellTags->"S5.0.7"],
    Cell[293149, 15854, 182, 5, 70, "MathCaption",
      CellTags->{"S5.0.7", "7.9"}],
    Cell[293334, 15861, 95, 2, 70, "Input",
      CellTags->"S5.0.7"],
    Cell[293432, 15865, 187, 4, 70, "MathCaption",
      CellTags->{"S5.0.7", "7.10"}],
    Cell[293644, 15873, 157, 5, 70, "Input",
      CellTags->"S5.0.7"],
    Cell[293804, 15880, 4943, 312, 70, 4873, 309, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.0.7"],
    Cell[298750, 16194, 179, 6, 70, "Output",
      CellTags->"S5.0.7"],
    Cell[298944, 16203, 308, 9, 70, "MathCaption",
      CellTags->{"S5.0.7", "7.11"}],
    Cell[299255, 16214, 87, 2, 70, "Input",
      CellTags->"S5.0.7"],
    Cell[299345, 16218, 106, 1, 70, "MathCaption",
      CellTags->{"S5.0.7", "7.12"}],
    Cell[299476, 16223, 96, 2, 70, "Input",
      CellTags->"S5.0.7"],
    Cell[299575, 16227, 168, 4, 70, "Message",
      CellTags->"S5.0.7"],
    Cell[299746, 16233, 345, 11, 70, "Output",
      CellTags->"S5.0.7"]},
  "7.1"->{
    Cell[259311, 14137, 74, 1, 70, "Subsection",
      CellTags->{"S5.0.7", "7.1"}]},
  "7.2"->{
    Cell[259388, 14140, 609, 13, 70, "Text",
      CellTags->{"S5.0.7", "7.2"}]},
  "7.3"->{
    Cell[260000, 14155, 123, 3, 70, "MathCaption",
      CellTags->{"S5.0.7", "7.3"}]},
  "7.4"->{
    Cell[260213, 14164, 527, 14, 70, "MathCaption",
      CellTags->{"S5.0.7", "7.4"}]},
  "7.5"->{
    Cell[261078, 14196, 183, 6, 70, "MathCaption",
      CellTags->{"S5.0.7", "7.5"}]},
  "7.6"->{
    Cell[261351, 14208, 113, 2, 70, "MathCaption",
      CellTags->{"S5.0.7", "7.6"}]},
  "7.7"->{
    Cell[270936, 14386, 160, 5, 70, "MathCaption",
      CellTags->{"S5.0.7", "7.7"}]},
  "7.8"->{
    Cell[271190, 14397, 80, 1, 70, "MathCaption",
      CellTags->{"S5.0.7", "7.8"}]},
  "7.9"->{
    Cell[293149, 15854, 182, 5, 70, "MathCaption",
      CellTags->{"S5.0.7", "7.9"}]},
  "7.10"->{
    Cell[293432, 15865, 187, 4, 70, "MathCaption",
      CellTags->{"S5.0.7", "7.10"}]},
  "7.11"->{
    Cell[298944, 16203, 308, 9, 70, "MathCaption",
      CellTags->{"S5.0.7", "7.11"}]},
  "7.12"->{
    Cell[299345, 16218, 106, 1, 70, "MathCaption",
      CellTags->{"S5.0.7", "7.12"}]},
  "S5.0.8"->{
    Cell[300140, 16250, 74, 1, 70, "Subsection",
      CellTags->{"S5.0.8", "8.1"}],
    Cell[300217, 16253, 1092, 28, 70, "Text",
      CellTags->{"S5.0.8", "8.2"}],
    Cell[301312, 16283, 160, 5, 70, "MathCaption",
      CellTags->{"S5.0.8", "8.3"}],
    Cell[301475, 16290, 77, 2, 70, "Input",
      CellTags->"S5.0.8"],
    Cell[301555, 16294, 159, 5, 70, "MathCaption",
      CellTags->{"S5.0.8", "8.4"}],
    Cell[301717, 16301, 73, 2, 70, "Input",
      CellTags->"S5.0.8"],
    Cell[301793, 16305, 891, 27, 70, "MathCaption",
      CellTags->{"S5.0.8", "8.5"}],
    Cell[302709, 16336, 157, 6, 70, "Input",
      CellTags->"S5.0.8"],
    Cell[302869, 16344, 160, 5, 70, "Output",
      CellTags->"S5.0.8"],
    Cell[303044, 16352, 518, 15, 70, "MathCaption",
      CellTags->{"S5.0.8", "8.6"}],
    Cell[303587, 16371, 146, 7, 70, "Input",
      CellTags->"S5.0.8"],
    Cell[303736, 16380, 145, 4, 70, "Output",
      CellTags->"S5.0.8"],
    Cell[303896, 16387, 224, 5, 70, "Text",
      CellTags->{"S5.0.8", "8.7"}],
    Cell[304123, 16394, 362, 8, 70, "MathCaption",
      CellTags->{"S5.0.8", "8.8"}],
    Cell[304510, 16406, 301, 8, 70, "Input",
      CellTags->"S5.0.8"],
    Cell[304814, 16416, 76, 2, 70, "Output",
      CellTags->"S5.0.8"],
    Cell[304905, 16421, 1045, 37, 70, "Text",
      CellTags->{"S5.0.8", "8.9"}],
    Cell[305953, 16460, 878, 27, 70, "MathCaption",
      CellTags->{"S5.0.8", "8.10"}],
    Cell[306856, 16491, 282, 10, 70, "Input",
      CellTags->"S5.0.8"],
    Cell[307141, 16503, 1490, 106, 70, 1420, 103, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.0.8"],
    Cell[308634, 16611, 179, 6, 70, "Output",
      CellTags->"S5.0.8"],
    Cell[308828, 16620, 582, 19, 70, "Text",
      CellTags->{"S5.0.8", "8.11"}],
    Cell[309413, 16641, 279, 10, 70, "MathCaption",
      CellTags->{"S5.0.8", "8.12"}],
    Cell[309717, 16655, 147, 6, 70, "Input",
      CellTags->"S5.0.8"],
    Cell[309867, 16663, 298, 7, 70, "Output",
      CellTags->"S5.0.8"],
    Cell[310180, 16673, 314, 6, 70, "MathCaption",
      CellTags->{"S5.0.8", "8.13"}],
    Cell[310519, 16683, 258, 8, 70, "Input",
      CellTags->"S5.0.8"],
    Cell[310780, 16693, 27360, 2209, 70, 27290, 2206, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.0.8"],
    Cell[338143, 18904, 179, 6, 70, "Output",
      CellTags->"S5.0.8"],
    Cell[338337, 18913, 275, 5, 70, "Text",
      CellTags->{"S5.0.8", "8.14"}],
    Cell[338615, 18920, 144, 4, 70, "MathCaption",
      CellTags->{"S5.0.8", "8.15"}],
    Cell[338784, 18928, 241, 7, 70, "Input",
      CellTags->"S5.0.8"],
    Cell[339028, 18937, 4251, 276, 70, 4181, 273, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.0.8"],
    Cell[343282, 19215, 179, 6, 70, "Output",
      CellTags->"S5.0.8"]},
  "8.1"->{
    Cell[300140, 16250, 74, 1, 70, "Subsection",
      CellTags->{"S5.0.8", "8.1"}]},
  "8.2"->{
    Cell[300217, 16253, 1092, 28, 70, "Text",
      CellTags->{"S5.0.8", "8.2"}]},
  "8.3"->{
    Cell[301312, 16283, 160, 5, 70, "MathCaption",
      CellTags->{"S5.0.8", "8.3"}]},
  "8.4"->{
    Cell[301555, 16294, 159, 5, 70, "MathCaption",
      CellTags->{"S5.0.8", "8.4"}]},
  "8.5"->{
    Cell[301793, 16305, 891, 27, 70, "MathCaption",
      CellTags->{"S5.0.8", "8.5"}]},
  "8.6"->{
    Cell[303044, 16352, 518, 15, 70, "MathCaption",
      CellTags->{"S5.0.8", "8.6"}]},
  "8.7"->{
    Cell[303896, 16387, 224, 5, 70, "Text",
      CellTags->{"S5.0.8", "8.7"}]},
  "8.8"->{
    Cell[304123, 16394, 362, 8, 70, "MathCaption",
      CellTags->{"S5.0.8", "8.8"}]},
  "8.9"->{
    Cell[304905, 16421, 1045, 37, 70, "Text",
      CellTags->{"S5.0.8", "8.9"}]},
  "8.10"->{
    Cell[305953, 16460, 878, 27, 70, "MathCaption",
      CellTags->{"S5.0.8", "8.10"}]},
  "8.11"->{
    Cell[308828, 16620, 582, 19, 70, "Text",
      CellTags->{"S5.0.8", "8.11"}]},
  "8.12"->{
    Cell[309413, 16641, 279, 10, 70, "MathCaption",
      CellTags->{"S5.0.8", "8.12"}]},
  "8.13"->{
    Cell[310180, 16673, 314, 6, 70, "MathCaption",
      CellTags->{"S5.0.8", "8.13"}]},
  "8.14"->{
    Cell[338337, 18913, 275, 5, 70, "Text",
      CellTags->{"S5.0.8", "8.14"}]},
  "8.15"->{
    Cell[338615, 18920, 144, 4, 70, "MathCaption",
      CellTags->{"S5.0.8", "8.15"}]},
  "S5.0.9"->{
    Cell[343510, 19227, 82, 1, 70, "Subsection",
      CellTags->{"S5.0.9", "9.1"}],
    Cell[343595, 19230, 1251, 35, 70, "Text",
      CellTags->{"S5.0.9", "9.2"}],
    Cell[344849, 19267, 144, 4, 70, "MathCaption",
      CellTags->{"S5.0.9", "9.3"}],
    Cell[344996, 19273, 78, 2, 70, "Input",
      CellTags->"S5.0.9"],
    Cell[345077, 19277, 115, 2, 70, "MathCaption",
      CellTags->{"S5.0.9", "9.4"}],
    Cell[345217, 19283, 285, 8, 70, "Input",
      CellTags->"S5.0.9"],
    Cell[345505, 19293, 2185, 147, 70, 2115, 144, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.0.9"],
    Cell[347693, 19442, 179, 6, 70, "Output",
      CellTags->"S5.0.9"],
    Cell[347887, 19451, 215, 6, 70, "MathCaption",
      CellTags->{"S5.0.9", "9.5"}],
    Cell[348127, 19461, 315, 9, 70, "Input",
      CellTags->"S5.0.9"],
    Cell[348445, 19472, 7619, 499, 70, 7549, 496, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.0.9"],
    Cell[356067, 19973, 179, 6, 70, "Output",
      CellTags->"S5.0.9"],
    Cell[356261, 19982, 443, 13, 70, "MathCaption",
      CellTags->{"S5.0.9", "9.6"}],
    Cell[356729, 19999, 180, 6, 70, "Input",
      CellTags->"S5.0.9"],
    Cell[356912, 20007, 7371, 411, 70, 7301, 408, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.0.9"],
    Cell[364286, 20420, 179, 6, 70, "Output",
      CellTags->"S5.0.9"],
    Cell[364480, 20429, 597, 18, 70, "MathCaption",
      CellTags->{"S5.0.9", "9.7"}],
    Cell[365102, 20451, 177, 6, 70, "Input",
      CellTags->"S5.0.9"],
    Cell[365282, 20459, 593, 16, 70, "Output",
      CellTags->"S5.0.9"],
    Cell[365890, 20478, 173, 4, 70, "MathCaption",
      CellTags->{"S5.0.9", "9.8"}],
    Cell[366088, 20486, 207, 6, 70, "Input",
      CellTags->"S5.0.9"],
    Cell[366298, 20494, 7540, 416, 70, 7470, 413, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.0.9"],
    Cell[373841, 20912, 179, 6, 70, "Output",
      CellTags->"S5.0.9"],
    Cell[374035, 20921, 748, 12, 70, "Text",
      CellTags->{"S5.0.9", "9.9"}],
    Cell[374786, 20935, 136, 3, 70, "MathCaption",
      CellTags->{"S5.0.9", "9.10"}],
    Cell[374925, 20940, 78, 2, 70, "Input",
      CellTags->"S5.0.9"],
    Cell[375006, 20944, 635, 21, 70, "MathCaption",
      CellTags->{"S5.0.9", "9.11"}],
    Cell[375666, 20969, 190, 6, 70, "Input",
      CellTags->"S5.0.9"],
    Cell[375859, 20977, 183, 7, 70, "Output",
      CellTags->"S5.0.9"],
    Cell[376057, 20987, 173, 4, 70, "MathCaption",
      CellTags->{"S5.0.9", "9.12"}],
    Cell[376255, 20995, 178, 5, 70, "Input",
      CellTags->"S5.0.9"],
    Cell[376436, 21002, 26396, 1584, 70, 26326, 1581, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.0.9"],
    Cell[402835, 22588, 179, 6, 70, "Output",
      CellTags->"S5.0.9"],
    Cell[403029, 22597, 479, 10, 70, "Text",
      CellTags->{"S5.0.9", "9.13"}]},
  "9.1"->{
    Cell[343510, 19227, 82, 1, 70, "Subsection",
      CellTags->{"S5.0.9", "9.1"}]},
  "9.2"->{
    Cell[343595, 19230, 1251, 35, 70, "Text",
      CellTags->{"S5.0.9", "9.2"}]},
  "9.3"->{
    Cell[344849, 19267, 144, 4, 70, "MathCaption",
      CellTags->{"S5.0.9", "9.3"}]},
  "9.4"->{
    Cell[345077, 19277, 115, 2, 70, "MathCaption",
      CellTags->{"S5.0.9", "9.4"}]},
  "9.5"->{
    Cell[347887, 19451, 215, 6, 70, "MathCaption",
      CellTags->{"S5.0.9", "9.5"}]},
  "9.6"->{
    Cell[356261, 19982, 443, 13, 70, "MathCaption",
      CellTags->{"S5.0.9", "9.6"}]},
  "9.7"->{
    Cell[364480, 20429, 597, 18, 70, "MathCaption",
      CellTags->{"S5.0.9", "9.7"}]},
  "9.8"->{
    Cell[365890, 20478, 173, 4, 70, "MathCaption",
      CellTags->{"S5.0.9", "9.8"}]},
  "9.9"->{
    Cell[374035, 20921, 748, 12, 70, "Text",
      CellTags->{"S5.0.9", "9.9"}]},
  "9.10"->{
    Cell[374786, 20935, 136, 3, 70, "MathCaption",
      CellTags->{"S5.0.9", "9.10"}]},
  "9.11"->{
    Cell[375006, 20944, 635, 21, 70, "MathCaption",
      CellTags->{"S5.0.9", "9.11"}]},
  "9.12"->{
    Cell[376057, 20987, 173, 4, 70, "MathCaption",
      CellTags->{"S5.0.9", "9.12"}]},
  "9.13"->{
    Cell[403029, 22597, 479, 10, 70, "Text",
      CellTags->{"S5.0.9", "9.13"}]},
  "S5.0.10"->{
    Cell[403545, 22612, 73, 1, 70, "Subsection",
      CellTags->{"S5.0.10", "10.1"}],
    Cell[403621, 22615, 662, 11, 70, "Text",
      CellTags->{"S5.0.10", "10.2"}],
    Cell[404286, 22628, 156, 5, 70, "MathCaption",
      CellTags->{"S5.0.10", "10.3"}],
    Cell[404445, 22635, 76, 2, 70, "Input",
      CellTags->"S5.0.10"],
    Cell[404524, 22639, 441, 11, 70, "MathCaption",
      CellTags->{"S5.0.10", "10.4"}],
    Cell[404990, 22654, 339, 10, 70, "Input",
      CellTags->"S5.0.10"],
    Cell[405332, 22666, 4821, 312, 70, 4750, 309, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.0.10"],
    Cell[410156, 22980, 180, 6, 70, "Output",
      CellTags->"S5.0.10"],
    Cell[410351, 22989, 95, 1, 70, "MathCaption",
      CellTags->{"S5.0.10", "10.5"}],
    Cell[410471, 22994, 270, 9, 70, "Input",
      CellTags->"S5.0.10"],
    Cell[410744, 23005, 12882, 922, 70, 12811, 919, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.0.10"],
    Cell[423629, 23929, 190, 7, 70, "Output",
      CellTags->"S5.0.10"],
    Cell[423834, 23939, 224, 5, 70, "MathCaption",
      CellTags->{"S5.0.10", "10.6"}],
    Cell[424083, 23948, 989, 28, 70, "Input",
      CellTags->"S5.0.10"],
    Cell[425075, 23978, 11067, 805, 70, 10996, 802, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.0.10"],
    Cell[436145, 24785, 190, 7, 70, "Output",
      CellTags->"S5.0.10"],
    Cell[436350, 24795, 344, 6, 70, "Text",
      CellTags->{"S5.0.10", "10.7"}],
    Cell[436697, 24803, 513, 18, 70, "MathCaption",
      CellTags->{"S5.0.10", "10.8"}],
    Cell[437235, 24825, 814, 25, 70, "Input",
      CellTags->"S5.0.10"],
    Cell[438052, 24852, 578, 21, 70, "Output",
      CellTags->"S5.0.10"],
    Cell[438645, 24876, 880, 27, 70, "MathCaption",
      CellTags->{"S5.0.10", "10.9"}],
    Cell[439550, 24907, 172, 6, 70, "Input",
      CellTags->"S5.0.10"],
    Cell[439725, 24915, 4170, 290, 70, 4099, 287, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.0.10"],
    Cell[443898, 25207, 180, 6, 70, "Output",
      CellTags->"S5.0.10"],
    Cell[444093, 25216, 962, 33, 70, "MathCaption",
      CellTags->{"S5.0.10", "10.10"}],
    Cell[445080, 25253, 543, 17, 70, "Input",
      CellTags->"S5.0.10"],
    Cell[445626, 25272, 732, 25, 70, "Output",
      CellTags->"S5.0.10"],
    Cell[446373, 25300, 316, 6, 70, "MathCaption",
      CellTags->{"S5.0.10", "10.11"}],
    Cell[446714, 25310, 1824, 49, 70, "Input",
      CellTags->"S5.0.10"],
    Cell[448541, 25361, 11815, 771, 70, 11744, 768, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.0.10"],
    Cell[460359, 26134, 180, 6, 70, "Output",
      CellTags->"S5.0.10"],
    Cell[460554, 26143, 1965, 64, 70, "MathCaption",
      CellTags->{"S5.0.10", "10.12"}],
    Cell[462544, 26211, 1247, 36, 70, "Input",
      CellTags->"S5.0.10"],
    Cell[463794, 26249, 6090, 191, 70, "Output",
      CellTags->"S5.0.10"],
    Cell[469899, 26443, 799, 17, 70, "Text",
      CellTags->{"S5.0.10", "10.13"}],
    Cell[470701, 26462, 663, 17, 70, "MathCaption",
      CellTags->{"S5.0.10", "10.14"}],
    Cell[471389, 26483, 309, 8, 70, "Input",
      CellTags->"S5.0.10"],
    Cell[471701, 26493, 8282, 554, 70, 8211, 551, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.0.10"],
    Cell[479986, 27049, 181, 6, 70, "Output",
      CellTags->"S5.0.10"]},
  "10.1"->{
    Cell[403545, 22612, 73, 1, 70, "Subsection",
      CellTags->{"S5.0.10", "10.1"}]},
  "10.2"->{
    Cell[403621, 22615, 662, 11, 70, "Text",
      CellTags->{"S5.0.10", "10.2"}]},
  "10.3"->{
    Cell[404286, 22628, 156, 5, 70, "MathCaption",
      CellTags->{"S5.0.10", "10.3"}]},
  "10.4"->{
    Cell[404524, 22639, 441, 11, 70, "MathCaption",
      CellTags->{"S5.0.10", "10.4"}]},
  "10.5"->{
    Cell[410351, 22989, 95, 1, 70, "MathCaption",
      CellTags->{"S5.0.10", "10.5"}]},
  "10.6"->{
    Cell[423834, 23939, 224, 5, 70, "MathCaption",
      CellTags->{"S5.0.10", "10.6"}]},
  "10.7"->{
    Cell[436350, 24795, 344, 6, 70, "Text",
      CellTags->{"S5.0.10", "10.7"}]},
  "10.8"->{
    Cell[436697, 24803, 513, 18, 70, "MathCaption",
      CellTags->{"S5.0.10", "10.8"}]},
  "10.9"->{
    Cell[438645, 24876, 880, 27, 70, "MathCaption",
      CellTags->{"S5.0.10", "10.9"}]},
  "10.10"->{
    Cell[444093, 25216, 962, 33, 70, "MathCaption",
      CellTags->{"S5.0.10", "10.10"}]},
  "10.11"->{
    Cell[446373, 25300, 316, 6, 70, "MathCaption",
      CellTags->{"S5.0.10", "10.11"}]},
  "10.12"->{
    Cell[460554, 26143, 1965, 64, 70, "MathCaption",
      CellTags->{"S5.0.10", "10.12"}]},
  "10.13"->{
    Cell[469899, 26443, 799, 17, 70, "Text",
      CellTags->{"S5.0.10", "10.13"}]},
  "10.14"->{
    Cell[470701, 26462, 663, 17, 70, "MathCaption",
      CellTags->{"S5.0.10", "10.14"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.0.0", 480829, 27076},
  {"0.1", 480919, 27079},
  {"S5.0.1", 481012, 27082},
  {"1.1", 481704, 27101},
  {"1.2", 481796, 27104},
  {"1.3", 481884, 27107},
  {"1.4", 481972, 27110},
  {"1.5", 482061, 27113},
  {"S5.0.2", 482153, 27116},
  {"2.1", 485569, 27207},
  {"2.2", 485662, 27210},
  {"2.3", 485751, 27213},
  {"2.4", 485846, 27216},
  {"2.5", 485942, 27219},
  {"2.6", 486038, 27222},
  {"2.7", 486134, 27225},
  {"2.8", 486231, 27228},
  {"2.9", 486321, 27231},
  {"2.10", 486418, 27234},
  {"2.11", 486517, 27237},
  {"2.12", 486611, 27240},
  {"2.13", 486711, 27243},
  {"2.14", 486810, 27246},
  {"2.15", 486909, 27249},
  {"2.16", 487008, 27252},
  {"S5.0.3", 487109, 27255},
  {"3.1", 487971, 27278},
  {"3.2", 488066, 27281},
  {"3.3", 488157, 27284},
  {"3.4", 488254, 27287},
  {"3.5", 488346, 27290},
  {"3.6", 488444, 27293},
  {"S5.0.4", 488545, 27296},
  {"4.1", 490169, 27339},
  {"4.2", 490264, 27342},
  {"4.3", 490355, 27345},
  {"4.4", 490452, 27348},
  {"4.5", 490549, 27351},
  {"4.6", 490647, 27354},
  {"4.7", 490744, 27357},
  {"S5.0.5", 490844, 27360},
  {"5.1", 493804, 27437},
  {"5.2", 493899, 27440},
  {"5.3", 493990, 27443},
  {"5.4", 494087, 27446},
  {"5.5", 494184, 27449},
  {"5.6", 494283, 27452},
  {"5.7", 494382, 27455},
  {"5.8", 494480, 27458},
  {"5.9", 494578, 27461},
  {"5.10", 494677, 27464},
  {"5.11", 494778, 27467},
  {"S5.0.6", 494881, 27470},
  {"6.1", 497129, 27527},
  {"6.2", 497226, 27530},
  {"6.3", 497318, 27533},
  {"6.4", 497411, 27536},
  {"6.5", 497505, 27539},
  {"6.6", 497604, 27542},
  {"6.7", 497704, 27545},
  {"6.8", 497804, 27548},
  {"6.9", 497904, 27551},
  {"6.10", 498005, 27554},
  {"6.11", 498107, 27557},
  {"6.12", 498209, 27560},
  {"6.13", 498304, 27563},
  {"6.14", 498397, 27566},
  {"6.15", 498504, 27569},
  {"S5.0.7", 498602, 27572},
  {"7.1", 501271, 27641},
  {"7.2", 501368, 27644},
  {"7.3", 501461, 27647},
  {"7.4", 501560, 27650},
  {"7.5", 501660, 27653},
  {"7.6", 501759, 27656},
  {"7.7", 501858, 27659},
  {"7.8", 501957, 27662},
  {"7.9", 502055, 27665},
  {"7.10", 502155, 27668},
  {"7.11", 502256, 27671},
  {"7.12", 502357, 27674},
  {"S5.0.8", 502460, 27677},
  {"8.1", 505378, 27752},
  {"8.2", 505475, 27755},
  {"8.3", 505569, 27758},
  {"8.4", 505668, 27761},
  {"8.5", 505767, 27764},
  {"8.6", 505867, 27767},
  {"8.7", 505967, 27770},
  {"8.8", 506059, 27773},
  {"8.9", 506158, 27776},
  {"8.10", 506253, 27779},
  {"8.11", 506355, 27782},
  {"8.12", 506450, 27785},
  {"8.13", 506552, 27788},
  {"8.14", 506653, 27791},
  {"8.15", 506747, 27794},
  {"S5.0.9", 506850, 27797},
  {"9.1", 509913, 27876},
  {"9.2", 510010, 27879},
  {"9.3", 510104, 27882},
  {"9.4", 510203, 27885},
  {"9.5", 510302, 27888},
  {"9.6", 510401, 27891},
  {"9.7", 510501, 27894},
  {"9.8", 510601, 27897},
  {"9.9", 510700, 27900},
  {"9.10", 510794, 27903},
  {"9.11", 510895, 27906},
  {"9.12", 510997, 27909},
  {"9.13", 511098, 27912},
  {"S5.0.10", 511196, 27915},
  {"10.1", 514789, 28006},
  {"10.2", 514889, 28009},
  {"10.3", 514985, 28012},
  {"10.4", 515087, 28015},
  {"10.5", 515190, 28018},
  {"10.6", 515291, 28021},
  {"10.7", 515393, 28024},
  {"10.8", 515488, 28027},
  {"10.9", 515591, 28030},
  {"10.10", 515695, 28033},
  {"10.11", 515800, 28036},
  {"10.12", 515904, 28039},
  {"10.13", 516010, 28042},
  {"10.14", 516108, 28045}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 112, 4, 61, "Section",
  CellTags->{"S5.0.0", "0.1"}],

Cell[CellGroupData[{
Cell[1913, 61, 88, 1, 36, "Subsection",
  CellTags->{"S5.0.1", "1.1"}],
Cell[2004, 64, 478, 11, 72, "Text",
  CellTags->{"S5.0.1", "1.2"}],
Cell[2485, 77, 756, 18, 72, "Text",
  CellTags->{"S5.0.1", "1.3"}],
Cell[3244, 97, 2100, 56, 150, "DefinitionBox",
  CellTags->"S5.0.1"],
Cell[5347, 155, 96, 3, 15, "Caption",
  CellTags->"S5.0.1"],
Cell[5446, 160, 569, 10, 88, "Text",
  CellTags->{"S5.0.1", "1.4"}],
Cell[6018, 172, 1840, 58, 66, "DefinitionBox",
  CellTags->"S5.0.1"],
Cell[7861, 232, 92, 3, 15, "Caption",
  CellTags->"S5.0.1"],
Cell[7956, 237, 347, 11, 56, "Text",
  CellTags->{"S5.0.1", "1.5"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[8340, 253, 68, 1, 36, "Subsection",
  CellTags->{"S5.0.2", "2.1"}],
Cell[8411, 256, 816, 20, 70, "Text",
  CellTags->{"S5.0.2", "2.2"}],
Cell[9230, 278, 133, 5, 70, "MathCaption",
  CellTags->{"S5.0.2", "2.3"}],
Cell[9366, 285, 72, 2, 70, "Input",
  CellTags->"S5.0.2"],
Cell[9441, 289, 403, 15, 70, "MathCaption",
  CellTags->{"S5.0.2", "2.4"}],

Cell[CellGroupData[{
Cell[9869, 308, 94, 2, 70, "Input",
  CellTags->"S5.0.2"],
Cell[9966, 312, 352, 12, 70, "Output",
  CellTags->"S5.0.2"]
}, Open  ]],
Cell[10333, 327, 191, 5, 70, "MathCaption",
  CellTags->{"S5.0.2", "2.5"}],

Cell[CellGroupData[{
Cell[10549, 336, 87, 2, 70, "Input",
  CellTags->"S5.0.2"],
Cell[10639, 340, 196, 6, 70, "Output",
  CellTags->"S5.0.2"]
}, Open  ]],
Cell[10850, 349, 189, 5, 70, "MathCaption",
  CellTags->{"S5.0.2", "2.6"}],

Cell[CellGroupData[{
Cell[11064, 358, 95, 2, 70, "Input",
  CellTags->"S5.0.2"],
Cell[11162, 362, 175, 6, 70, "Output",
  CellTags->"S5.0.2"]
}, Open  ]],
Cell[11352, 371, 469, 17, 70, "MathCaption",
  CellTags->{"S5.0.2", "2.7"}],

Cell[CellGroupData[{
Cell[11846, 392, 90, 2, 70, "Input",
  CellTags->"S5.0.2"],
Cell[11939, 396, 73, 2, 70, "Output",
  CellTags->"S5.0.2"]
}, Open  ]],
Cell[12027, 401, 599, 25, 70, "Text",
  CellTags->{"S5.0.2", "2.8"}],
Cell[12629, 428, 185, 5, 70, "MathCaption",
  CellTags->{"S5.0.2", "2.9"}],
Cell[12817, 435, 85, 2, 70, "Input",
  CellTags->"S5.0.2"],
Cell[12905, 439, 571, 18, 70, "MathCaption",
  CellTags->{"S5.0.2", "2.10"}],

Cell[CellGroupData[{
Cell[13501, 461, 251, 9, 70, "Input",
  CellTags->"S5.0.2"],
Cell[13755, 472, 9585, 845, 70, 9515, 842, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.0.2"],
Cell[23343, 1319, 181, 6, 70, "Output",
  CellTags->"S5.0.2"]
}, Open  ]],
Cell[23539, 1328, 1409, 51, 70, "Text",
  CellTags->{"S5.0.2", "2.11"}],
Cell[24951, 1381, 321, 12, 70, "MathCaption",
  CellTags->{"S5.0.2", "2.12"}],

Cell[CellGroupData[{
Cell[25297, 1397, 110, 2, 70, "Input",
  CellTags->"S5.0.2"],
Cell[25410, 1401, 258, 7, 70, "Output",
  CellTags->"S5.0.2"]
}, Open  ]],
Cell[25683, 1411, 233, 5, 70, "MathCaption",
  CellTags->{"S5.0.2", "2.13"}],

Cell[CellGroupData[{
Cell[25941, 1420, 195, 7, 70, "Input",
  CellTags->"S5.0.2"],
Cell[26139, 1429, 6274, 387, 70, 6204, 384, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.0.2"],
Cell[32416, 1818, 189, 7, 70, "Output",
  CellTags->"S5.0.2"]
}, Open  ]],
Cell[32620, 1828, 285, 6, 70, "MathCaption",
  CellTags->{"S5.0.2", "2.14"}],

Cell[CellGroupData[{
Cell[32930, 1838, 305, 9, 70, "Input",
  CellTags->"S5.0.2"],
Cell[33238, 1849, 6274, 387, 70, 6204, 384, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.0.2"],
Cell[39515, 2238, 190, 7, 70, "Output",
  CellTags->"S5.0.2"]
}, Open  ]],
Cell[39720, 2248, 188, 4, 70, "MathCaption",
  CellTags->{"S5.0.2", "2.15"}],
Cell[39911, 2254, 236, 7, 70, "Input",
  CellTags->"S5.0.2"],
Cell[40150, 2263, 175, 4, 70, "MathCaption",
  CellTags->{"S5.0.2", "2.16"}],

Cell[CellGroupData[{
Cell[40350, 2271, 270, 8, 70, "Input",
  CellTags->"S5.0.2"],
Cell[40623, 2281, 6274, 387, 70, 6204, 384, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.0.2"],
Cell[46900, 2670, 190, 7, 70, "Output",
  CellTags->"S5.0.2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[47139, 2683, 69, 1, 70, "Subsection",
  CellTags->{"S5.0.3", "3.1"}],
Cell[47211, 2686, 726, 15, 70, "Text",
  CellTags->{"S5.0.3", "3.2"}],
Cell[47940, 2703, 147, 5, 70, "MathCaption",
  CellTags->{"S5.0.3", "3.3"}],
Cell[48090, 2710, 73, 2, 70, "Input",
  CellTags->"S5.0.3"],
Cell[48166, 2714, 1131, 33, 70, "Text",
  CellTags->{"S5.0.3", "3.4"}],
Cell[49300, 2749, 897, 31, 70, "MathCaption",
  CellTags->{"S5.0.3", "3.5"}],

Cell[CellGroupData[{
Cell[50222, 2784, 206, 7, 70, "Input",
  CellTags->"S5.0.3"],
Cell[50431, 2793, 201, 8, 70, "Output",
  CellTags->"S5.0.3"]
}, Open  ]],
Cell[50647, 2804, 535, 19, 70, "MathCaption",
  CellTags->{"S5.0.3", "3.6"}],

Cell[CellGroupData[{
Cell[51207, 2827, 138, 5, 70, "Input",
  CellTags->"S5.0.3"],
Cell[51348, 2834, 251, 8, 70, "Output",
  CellTags->"S5.0.3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[51648, 2848, 81, 1, 70, "Subsection",
  CellTags->{"S5.0.4", "4.1"}],
Cell[51732, 2851, 567, 13, 70, "Text",
  CellTags->{"S5.0.4", "4.2"}],
Cell[52302, 2866, 151, 5, 70, "MathCaption",
  CellTags->{"S5.0.4", "4.3"}],
Cell[52456, 2873, 77, 2, 70, "Input",
  CellTags->"S5.0.4"],
Cell[52536, 2877, 274, 7, 70, "MathCaption",
  CellTags->{"S5.0.4", "4.4"}],

Cell[CellGroupData[{
Cell[52835, 2888, 87, 2, 70, "Input",
  CellTags->"S5.0.4"],
Cell[52925, 2892, 3769, 315, 70, 3699, 312, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.0.4"],
Cell[56697, 3209, 179, 6, 70, "Output",
  CellTags->"S5.0.4"]
}, Open  ]],
Cell[56891, 3218, 511, 15, 70, "MathCaption",
  CellTags->{"S5.0.4", "4.5"}],
Cell[57405, 3235, 142, 5, 70, "Input",
  CellTags->"S5.0.4"],
Cell[57550, 3242, 354, 6, 70, "MathCaption",
  CellTags->{"S5.0.4", "4.6"}],

Cell[CellGroupData[{
Cell[57929, 3252, 434, 12, 70, "Input",
  CellTags->"S5.0.4"],
Cell[58366, 3266, 18181, 1173, 70, 18111, 1170, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.0.4"],
Cell[76550, 4441, 179, 6, 70, "Output",
  CellTags->"S5.0.4"]
}, Open  ]],
Cell[76744, 4450, 193, 4, 70, "MathCaption",
  CellTags->{"S5.0.4", "4.7"}],

Cell[CellGroupData[{
Cell[76962, 4458, 182, 6, 70, "Input",
  CellTags->"S5.0.4"],
Cell[77147, 4466, 18385, 985, 70, 18315, 982, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.0.4"],
Cell[95535, 5453, 181, 6, 70, "Output",
  CellTags->"S5.0.4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[95765, 5465, 82, 1, 70, "Subsection",
  CellTags->{"S5.0.5", "5.1"}],
Cell[95850, 5468, 941, 18, 70, "Text",
  CellTags->{"S5.0.5", "5.2"}],
Cell[96794, 5488, 183, 5, 70, "MathCaption",
  CellTags->{"S5.0.5", "5.3"}],
Cell[96980, 5495, 73, 2, 70, "Input",
  CellTags->"S5.0.5"],
Cell[97056, 5499, 173, 5, 70, "MathCaption",
  CellTags->{"S5.0.5", "5.4"}],

Cell[CellGroupData[{
Cell[97254, 5508, 658, 18, 70, "Input",
  CellTags->"S5.0.5"],
Cell[97915, 5528, 18835, 858, 70, 18765, 855, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.0.5"],
Cell[116753, 6388, 179, 6, 70, "Output",
  CellTags->"S5.0.5"]
}, Open  ]],
Cell[116947, 6397, 504, 17, 70, "MathCaption",
  CellTags->{"S5.0.5", "5.5"}],

Cell[CellGroupData[{
Cell[117476, 6418, 290, 9, 70, "Input",
  CellTags->"S5.0.5"],
Cell[117769, 6429, 32603, 1772, 70, 32533, 1769, "GraphicsData", \
"PostScript", "Graphics",
  ImageCacheValid->False,
  CellTags->"S5.0.5"],
Cell[150375, 8203, 181, 6, 70, "Output",
  CellTags->"S5.0.5"]
}, Open  ]],
Cell[150571, 8212, 484, 11, 70, "MathCaption",
  CellTags->{"S5.0.5", "5.6"}],

Cell[CellGroupData[{
Cell[151080, 8227, 1539, 44, 70, "Input",
  CellTags->"S5.0.5"],
Cell[152622, 8273, 13328, 720, 70, 13258, 717, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.0.5"],
Cell[165953, 8995, 179, 6, 70, "Output",
  CellTags->"S5.0.5"]
}, Open  ]],
Cell[166147, 9004, 143, 4, 70, "MathCaption",
  CellTags->{"S5.0.5", "5.7"}],

Cell[CellGroupData[{
Cell[166315, 9012, 234, 7, 70, "Input",
  CellTags->"S5.0.5"],
Cell[166552, 9021, 6291, 430, 70, 6221, 427, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.0.5"],
Cell[172846, 9453, 181, 6, 70, "Output",
  CellTags->"S5.0.5"]
}, Open  ]],
Cell[173042, 9462, 128, 3, 70, "MathCaption",
  CellTags->{"S5.0.5", "5.8"}],
Cell[173173, 9467, 84, 2, 70, "Input",
  CellTags->"S5.0.5"],
Cell[173260, 9471, 297, 6, 70, "MathCaption",
  CellTags->{"S5.0.5", "5.9"}],

Cell[CellGroupData[{
Cell[173582, 9481, 1675, 48, 70, "Input",
  CellTags->"S5.0.5"],
Cell[175260, 9531, 40676, 2881, 70, 40606, 2878, "GraphicsData", \
"PostScript", "Graphics",
  ImageCacheValid->False,
  CellTags->"S5.0.5"],
Cell[215939, 12414, 184, 6, 70, "Output",
  CellTags->"S5.0.5"]
}, Open  ]],
Cell[216138, 12423, 135, 5, 70, "MathCaption",
  CellTags->{"S5.0.5", "5.10"}],
Cell[216276, 12430, 73, 2, 70, "Input",
  CellTags->"S5.0.5"],
Cell[216352, 12434, 190, 4, 70, "MathCaption",
  CellTags->{"S5.0.5", "5.11"}],

Cell[CellGroupData[{
Cell[216567, 12442, 385, 13, 70, "Input",
  CellTags->"S5.0.5"],
Cell[216955, 12457, 16216, 809, 70, 16146, 806, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.0.5"],
Cell[233174, 13268, 181, 6, 70, "Output",
  CellTags->"S5.0.5"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[233404, 13280, 75, 1, 70, "Subsection",
  CellTags->{"S5.0.6", "6.1"}],
Cell[233482, 13283, 360, 8, 70, "Text",
  CellTags->{"S5.0.6", "6.2"}],
Cell[233845, 13293, 423, 10, 70, "Text",
  CellTags->{"S5.0.6", "6.3"}],
Cell[234271, 13305, 1917, 83, 70, "Text",
  CellTags->{"S5.0.6", "6.4"}],
Cell[236191, 13390, 135, 3, 70, "MathCaption",
  CellTags->{"S5.0.6", "6.5"}],
Cell[236329, 13395, 79, 2, 70, "Input",
  CellTags->"S5.0.6"],
Cell[236411, 13399, 620, 21, 70, "MathCaption",
  CellTags->{"S5.0.6", "6.6"}],

Cell[CellGroupData[{
Cell[237056, 13424, 413, 13, 70, "Input",
  CellTags->"S5.0.6"],
Cell[237472, 13439, 697, 20, 70, "Output",
  CellTags->"S5.0.6"]
}, Open  ]],
Cell[238184, 13462, 972, 34, 70, "MathCaption",
  CellTags->{"S5.0.6", "6.7"}],

Cell[CellGroupData[{
Cell[239181, 13500, 586, 20, 70, "Input",
  CellTags->"S5.0.6"],
Cell[239770, 13522, 513, 18, 70, "Output",
  CellTags->"S5.0.6"]
}, Open  ]],
Cell[240298, 13543, 373, 12, 70, "MathCaption",
  CellTags->{"S5.0.6", "6.8"}],

Cell[CellGroupData[{
Cell[240696, 13559, 655, 21, 70, "Input",
  CellTags->"S5.0.6"],
Cell[241354, 13582, 1448, 44, 70, "Output",
  CellTags->"S5.0.6"]
}, Open  ]],
Cell[242817, 13629, 752, 22, 70, "MathCaption",
  CellTags->{"S5.0.6", "6.9"}],

Cell[CellGroupData[{
Cell[243594, 13655, 452, 14, 70, "Input",
  CellTags->"S5.0.6"],
Cell[244049, 13671, 320, 11, 70, "Output",
  CellTags->"S5.0.6"]
}, Open  ]],
Cell[244384, 13685, 606, 20, 70, "MathCaption",
  CellTags->{"S5.0.6", "6.10"}],

Cell[CellGroupData[{
Cell[245015, 13709, 316, 10, 70, "Input",
  CellTags->"S5.0.6"],
Cell[245334, 13721, 1402, 44, 70, "Output",
  CellTags->"S5.0.6"]
}, Open  ]],
Cell[246751, 13768, 859, 29, 70, "MathCaption",
  CellTags->{"S5.0.6", "6.11"}],

Cell[CellGroupData[{
Cell[247635, 13801, 241, 8, 70, "Input",
  CellTags->"S5.0.6"],
Cell[247879, 13811, 77, 2, 70, "Output",
  CellTags->"S5.0.6"]
}, Open  ]],
Cell[247971, 13816, 413, 14, 70, "Text",
  CellTags->{"S5.0.6", "6.12"}],
Cell[248387, 13832, 47, 1, 70, "Text",
  CellTags->{"S5.0.6", "6.13"}],
Cell[248437, 13835, 8895, 222, 70, "DisplayFormula",
  CellTags->{"S5.0.6", "6.14"}],
Cell[257335, 14059, 1939, 73, 70, "Text",
  CellTags->{"S5.0.6", "6.15"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[259311, 14137, 74, 1, 70, "Subsection",
  CellTags->{"S5.0.7", "7.1"}],
Cell[259388, 14140, 609, 13, 70, "Text",
  CellTags->{"S5.0.7", "7.2"}],
Cell[260000, 14155, 123, 3, 70, "MathCaption",
  CellTags->{"S5.0.7", "7.3"}],
Cell[260126, 14160, 84, 2, 70, "Input",
  CellTags->"S5.0.7"],
Cell[260213, 14164, 527, 14, 70, "MathCaption",
  CellTags->{"S5.0.7", "7.4"}],

Cell[CellGroupData[{
Cell[260765, 14182, 154, 5, 70, "Input",
  CellTags->"S5.0.7"],
Cell[260922, 14189, 141, 4, 70, "Output",
  CellTags->"S5.0.7"]
}, Open  ]],
Cell[261078, 14196, 183, 6, 70, "MathCaption",
  CellTags->{"S5.0.7", "7.5"}],
Cell[261264, 14204, 84, 2, 70, "Input",
  CellTags->"S5.0.7"],
Cell[261351, 14208, 113, 2, 70, "MathCaption",
  CellTags->{"S5.0.7", "7.6"}],

Cell[CellGroupData[{
Cell[261489, 14214, 145, 5, 70, "Input",
  CellTags->"S5.0.7"],
Cell[261637, 14221, 9105, 154, 70, 9035, 151, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.0.7"],
Cell[270745, 14377, 176, 6, 70, "Output",
  CellTags->"S5.0.7"]
}, Open  ]],
Cell[270936, 14386, 160, 5, 70, "MathCaption",
  CellTags->{"S5.0.7", "7.7"}],
Cell[271099, 14393, 88, 2, 70, "Input",
  CellTags->"S5.0.7"],
Cell[271190, 14397, 80, 1, 70, "MathCaption",
  CellTags->{"S5.0.7", "7.8"}],

Cell[CellGroupData[{
Cell[271295, 14402, 80, 2, 70, "Input",
  CellTags->"S5.0.7"],
Cell[271378, 14406, 21658, 1441, 70, 21588, 1438, "GraphicsData", \
"PostScript", "Graphics",
  ImageCacheValid->False,
  CellTags->"S5.0.7"],
Cell[293039, 15849, 95, 2, 70, "Output",
  CellTags->"S5.0.7"]
}, Open  ]],
Cell[293149, 15854, 182, 5, 70, "MathCaption",
  CellTags->{"S5.0.7", "7.9"}],
Cell[293334, 15861, 95, 2, 70, "Input",
  CellTags->"S5.0.7"],
Cell[293432, 15865, 187, 4, 70, "MathCaption",
  CellTags->{"S5.0.7", "7.10"}],

Cell[CellGroupData[{
Cell[293644, 15873, 157, 5, 70, "Input",
  CellTags->"S5.0.7"],
Cell[293804, 15880, 4943, 312, 70, 4873, 309, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.0.7"],
Cell[298750, 16194, 179, 6, 70, "Output",
  CellTags->"S5.0.7"]
}, Open  ]],
Cell[298944, 16203, 308, 9, 70, "MathCaption",
  CellTags->{"S5.0.7", "7.11"}],
Cell[299255, 16214, 87, 2, 70, "Input",
  CellTags->"S5.0.7"],
Cell[299345, 16218, 106, 1, 70, "MathCaption",
  CellTags->{"S5.0.7", "7.12"}],

Cell[CellGroupData[{
Cell[299476, 16223, 96, 2, 70, "Input",
  CellTags->"S5.0.7"],
Cell[299575, 16227, 168, 4, 70, "Message",
  CellTags->"S5.0.7"],
Cell[299746, 16233, 345, 11, 70, "Output",
  CellTags->"S5.0.7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[300140, 16250, 74, 1, 70, "Subsection",
  CellTags->{"S5.0.8", "8.1"}],
Cell[300217, 16253, 1092, 28, 70, "Text",
  CellTags->{"S5.0.8", "8.2"}],
Cell[301312, 16283, 160, 5, 70, "MathCaption",
  CellTags->{"S5.0.8", "8.3"}],
Cell[301475, 16290, 77, 2, 70, "Input",
  CellTags->"S5.0.8"],
Cell[301555, 16294, 159, 5, 70, "MathCaption",
  CellTags->{"S5.0.8", "8.4"}],
Cell[301717, 16301, 73, 2, 70, "Input",
  CellTags->"S5.0.8"],
Cell[301793, 16305, 891, 27, 70, "MathCaption",
  CellTags->{"S5.0.8", "8.5"}],

Cell[CellGroupData[{
Cell[302709, 16336, 157, 6, 70, "Input",
  CellTags->"S5.0.8"],
Cell[302869, 16344, 160, 5, 70, "Output",
  CellTags->"S5.0.8"]
}, Open  ]],
Cell[303044, 16352, 518, 15, 70, "MathCaption",
  CellTags->{"S5.0.8", "8.6"}],

Cell[CellGroupData[{
Cell[303587, 16371, 146, 7, 70, "Input",
  CellTags->"S5.0.8"],
Cell[303736, 16380, 145, 4, 70, "Output",
  CellTags->"S5.0.8"]
}, Open  ]],
Cell[303896, 16387, 224, 5, 70, "Text",
  CellTags->{"S5.0.8", "8.7"}],
Cell[304123, 16394, 362, 8, 70, "MathCaption",
  CellTags->{"S5.0.8", "8.8"}],

Cell[CellGroupData[{
Cell[304510, 16406, 301, 8, 70, "Input",
  CellTags->"S5.0.8"],
Cell[304814, 16416, 76, 2, 70, "Output",
  CellTags->"S5.0.8"]
}, Open  ]],
Cell[304905, 16421, 1045, 37, 70, "Text",
  CellTags->{"S5.0.8", "8.9"}],
Cell[305953, 16460, 878, 27, 70, "MathCaption",
  CellTags->{"S5.0.8", "8.10"}],

Cell[CellGroupData[{
Cell[306856, 16491, 282, 10, 70, "Input",
  CellTags->"S5.0.8"],
Cell[307141, 16503, 1490, 106, 70, 1420, 103, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.0.8"],
Cell[308634, 16611, 179, 6, 70, "Output",
  CellTags->"S5.0.8"]
}, Open  ]],
Cell[308828, 16620, 582, 19, 70, "Text",
  CellTags->{"S5.0.8", "8.11"}],
Cell[309413, 16641, 279, 10, 70, "MathCaption",
  CellTags->{"S5.0.8", "8.12"}],

Cell[CellGroupData[{
Cell[309717, 16655, 147, 6, 70, "Input",
  CellTags->"S5.0.8"],
Cell[309867, 16663, 298, 7, 70, "Output",
  CellTags->"S5.0.8"]
}, Open  ]],
Cell[310180, 16673, 314, 6, 70, "MathCaption",
  CellTags->{"S5.0.8", "8.13"}],

Cell[CellGroupData[{
Cell[310519, 16683, 258, 8, 70, "Input",
  CellTags->"S5.0.8"],
Cell[310780, 16693, 27360, 2209, 70, 27290, 2206, "GraphicsData", \
"PostScript", "Graphics",
  ImageCacheValid->False,
  CellTags->"S5.0.8"],
Cell[338143, 18904, 179, 6, 70, "Output",
  CellTags->"S5.0.8"]
}, Open  ]],
Cell[338337, 18913, 275, 5, 70, "Text",
  CellTags->{"S5.0.8", "8.14"}],
Cell[338615, 18920, 144, 4, 70, "MathCaption",
  CellTags->{"S5.0.8", "8.15"}],

Cell[CellGroupData[{
Cell[338784, 18928, 241, 7, 70, "Input",
  CellTags->"S5.0.8"],
Cell[339028, 18937, 4251, 276, 70, 4181, 273, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.0.8"],
Cell[343282, 19215, 179, 6, 70, "Output",
  CellTags->"S5.0.8"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[343510, 19227, 82, 1, 70, "Subsection",
  CellTags->{"S5.0.9", "9.1"}],
Cell[343595, 19230, 1251, 35, 70, "Text",
  CellTags->{"S5.0.9", "9.2"}],
Cell[344849, 19267, 144, 4, 70, "MathCaption",
  CellTags->{"S5.0.9", "9.3"}],
Cell[344996, 19273, 78, 2, 70, "Input",
  CellTags->"S5.0.9"],
Cell[345077, 19277, 115, 2, 70, "MathCaption",
  CellTags->{"S5.0.9", "9.4"}],

Cell[CellGroupData[{
Cell[345217, 19283, 285, 8, 70, "Input",
  CellTags->"S5.0.9"],
Cell[345505, 19293, 2185, 147, 70, 2115, 144, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.0.9"],
Cell[347693, 19442, 179, 6, 70, "Output",
  CellTags->"S5.0.9"]
}, Open  ]],
Cell[347887, 19451, 215, 6, 70, "MathCaption",
  CellTags->{"S5.0.9", "9.5"}],

Cell[CellGroupData[{
Cell[348127, 19461, 315, 9, 70, "Input",
  CellTags->"S5.0.9"],
Cell[348445, 19472, 7619, 499, 70, 7549, 496, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.0.9"],
Cell[356067, 19973, 179, 6, 70, "Output",
  CellTags->"S5.0.9"]
}, Open  ]],
Cell[356261, 19982, 443, 13, 70, "MathCaption",
  CellTags->{"S5.0.9", "9.6"}],

Cell[CellGroupData[{
Cell[356729, 19999, 180, 6, 70, "Input",
  CellTags->"S5.0.9"],
Cell[356912, 20007, 7371, 411, 70, 7301, 408, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.0.9"],
Cell[364286, 20420, 179, 6, 70, "Output",
  CellTags->"S5.0.9"]
}, Open  ]],
Cell[364480, 20429, 597, 18, 70, "MathCaption",
  CellTags->{"S5.0.9", "9.7"}],

Cell[CellGroupData[{
Cell[365102, 20451, 177, 6, 70, "Input",
  CellTags->"S5.0.9"],
Cell[365282, 20459, 593, 16, 70, "Output",
  CellTags->"S5.0.9"]
}, Open  ]],
Cell[365890, 20478, 173, 4, 70, "MathCaption",
  CellTags->{"S5.0.9", "9.8"}],

Cell[CellGroupData[{
Cell[366088, 20486, 207, 6, 70, "Input",
  CellTags->"S5.0.9"],
Cell[366298, 20494, 7540, 416, 70, 7470, 413, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.0.9"],
Cell[373841, 20912, 179, 6, 70, "Output",
  CellTags->"S5.0.9"]
}, Open  ]],
Cell[374035, 20921, 748, 12, 70, "Text",
  CellTags->{"S5.0.9", "9.9"}],
Cell[374786, 20935, 136, 3, 70, "MathCaption",
  CellTags->{"S5.0.9", "9.10"}],
Cell[374925, 20940, 78, 2, 70, "Input",
  CellTags->"S5.0.9"],
Cell[375006, 20944, 635, 21, 70, "MathCaption",
  CellTags->{"S5.0.9", "9.11"}],

Cell[CellGroupData[{
Cell[375666, 20969, 190, 6, 70, "Input",
  CellTags->"S5.0.9"],
Cell[375859, 20977, 183, 7, 70, "Output",
  CellTags->"S5.0.9"]
}, Open  ]],
Cell[376057, 20987, 173, 4, 70, "MathCaption",
  CellTags->{"S5.0.9", "9.12"}],

Cell[CellGroupData[{
Cell[376255, 20995, 178, 5, 70, "Input",
  CellTags->"S5.0.9"],
Cell[376436, 21002, 26396, 1584, 70, 26326, 1581, "GraphicsData", \
"PostScript", "Graphics",
  ImageCacheValid->False,
  CellTags->"S5.0.9"],
Cell[402835, 22588, 179, 6, 70, "Output",
  CellTags->"S5.0.9"]
}, Open  ]],
Cell[403029, 22597, 479, 10, 70, "Text",
  CellTags->{"S5.0.9", "9.13"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[403545, 22612, 73, 1, 70, "Subsection",
  CellTags->{"S5.0.10", "10.1"}],
Cell[403621, 22615, 662, 11, 70, "Text",
  CellTags->{"S5.0.10", "10.2"}],
Cell[404286, 22628, 156, 5, 70, "MathCaption",
  CellTags->{"S5.0.10", "10.3"}],
Cell[404445, 22635, 76, 2, 70, "Input",
  CellTags->"S5.0.10"],
Cell[404524, 22639, 441, 11, 70, "MathCaption",
  CellTags->{"S5.0.10", "10.4"}],

Cell[CellGroupData[{
Cell[404990, 22654, 339, 10, 70, "Input",
  CellTags->"S5.0.10"],
Cell[405332, 22666, 4821, 312, 70, 4750, 309, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.0.10"],
Cell[410156, 22980, 180, 6, 70, "Output",
  CellTags->"S5.0.10"]
}, Open  ]],
Cell[410351, 22989, 95, 1, 70, "MathCaption",
  CellTags->{"S5.0.10", "10.5"}],

Cell[CellGroupData[{
Cell[410471, 22994, 270, 9, 70, "Input",
  CellTags->"S5.0.10"],
Cell[410744, 23005, 12882, 922, 70, 12811, 919, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.0.10"],
Cell[423629, 23929, 190, 7, 70, "Output",
  CellTags->"S5.0.10"]
}, Open  ]],
Cell[423834, 23939, 224, 5, 70, "MathCaption",
  CellTags->{"S5.0.10", "10.6"}],

Cell[CellGroupData[{
Cell[424083, 23948, 989, 28, 70, "Input",
  CellTags->"S5.0.10"],
Cell[425075, 23978, 11067, 805, 70, 10996, 802, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.0.10"],
Cell[436145, 24785, 190, 7, 70, "Output",
  CellTags->"S5.0.10"]
}, Open  ]],
Cell[436350, 24795, 344, 6, 70, "Text",
  CellTags->{"S5.0.10", "10.7"}],
Cell[436697, 24803, 513, 18, 70, "MathCaption",
  CellTags->{"S5.0.10", "10.8"}],

Cell[CellGroupData[{
Cell[437235, 24825, 814, 25, 70, "Input",
  CellTags->"S5.0.10"],
Cell[438052, 24852, 578, 21, 70, "Output",
  CellTags->"S5.0.10"]
}, Open  ]],
Cell[438645, 24876, 880, 27, 70, "MathCaption",
  CellTags->{"S5.0.10", "10.9"}],

Cell[CellGroupData[{
Cell[439550, 24907, 172, 6, 70, "Input",
  CellTags->"S5.0.10"],
Cell[439725, 24915, 4170, 290, 70, 4099, 287, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.0.10"],
Cell[443898, 25207, 180, 6, 70, "Output",
  CellTags->"S5.0.10"]
}, Open  ]],
Cell[444093, 25216, 962, 33, 70, "MathCaption",
  CellTags->{"S5.0.10", "10.10"}],

Cell[CellGroupData[{
Cell[445080, 25253, 543, 17, 70, "Input",
  CellTags->"S5.0.10"],
Cell[445626, 25272, 732, 25, 70, "Output",
  CellTags->"S5.0.10"]
}, Open  ]],
Cell[446373, 25300, 316, 6, 70, "MathCaption",
  CellTags->{"S5.0.10", "10.11"}],

Cell[CellGroupData[{
Cell[446714, 25310, 1824, 49, 70, "Input",
  CellTags->"S5.0.10"],
Cell[448541, 25361, 11815, 771, 70, 11744, 768, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.0.10"],
Cell[460359, 26134, 180, 6, 70, "Output",
  CellTags->"S5.0.10"]
}, Open  ]],
Cell[460554, 26143, 1965, 64, 70, "MathCaption",
  CellTags->{"S5.0.10", "10.12"}],

Cell[CellGroupData[{
Cell[462544, 26211, 1247, 36, 70, "Input",
  CellTags->"S5.0.10"],
Cell[463794, 26249, 6090, 191, 70, "Output",
  CellTags->"S5.0.10"]
}, Open  ]],
Cell[469899, 26443, 799, 17, 70, "Text",
  CellTags->{"S5.0.10", "10.13"}],
Cell[470701, 26462, 663, 17, 70, "MathCaption",
  CellTags->{"S5.0.10", "10.14"}],

Cell[CellGroupData[{
Cell[471389, 26483, 309, 8, 70, "Input",
  CellTags->"S5.0.10"],
Cell[471701, 26493, 8282, 554, 70, 8211, 551, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.0.10"],
Cell[479986, 27049, 181, 6, 70, "Output",
  CellTags->"S5.0.10"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

