(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     78587,       3525]*)
(*NotebookOutlinePosition[     83711,       3676]*)
(*  CellTagsIndexPosition[     83371,       3659]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Graphics",
 StyleBox["`", "MB"],
 "Legend",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.36.1", "1.1"}],

Cell[TextData[{
 "There are two ways to use the functions in this package to place a legend \
in a graphic; the first can only be used as an option to the built\[Hyphen]in \
function ",
 StyleBox["Plot", "MR"],
 ", the second can be applied to any two\[Hyphen]dimensional graphic. To use \
the ",
 StyleBox["PlotLegend", "MR"],
 " option to ",
 StyleBox["Plot", "MR"],
 ", you simply specify the text for each curve. If there are more curves than \
text, the text is used cyclically. The second way of placing a legend in a \
graphic is to use ",
 StyleBox["ShowLegend", "MR"],
 ". With ",
 StyleBox["ShowLegend", "MR"],
 " you specify the graphic and legend as arguments. "
}], "Text",
 CellTags->{"S5.36.1", "1.2"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["PlotLegend -> {", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["text",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["text",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] }", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["option for ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["Plot", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[" to place a legend with text for each curve",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ShowLegend[", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["graphic", "TI",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["legend",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["legend",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] ]", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["place the ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["legend",
          "TI"], 
         StyleBox["i",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[" in the given graphic",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["{{{", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["box",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["text",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["}, \[Ellipsis] }, ", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["opts", "TI",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["}", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "specification of a legend, with color primitives or graphics for the ",
       
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["box",
          "TI"], 
         StyleBox["i",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[" and expression suitable for placement in ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["Text", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[" primitives in the ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["text",
          "TI"], 
         StyleBox["i",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["{", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["colorfunction", "TI",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["minstring", "TI",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["maxstring", "TI",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["opts", "TI",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["}", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["specification of a legend with ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[" boxes, each colored with the ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["colorfunction", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["; also with optional strings placed by the end boxes",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, True, False},
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->{False, True, False},
 RowSpacings->0.4},
 CellTags->"S5.36.1"],

Cell["Functions for placing a legend or key in a graphic. ", "Caption",
 CellTags->"S5.36.1"],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.36.1", "1.3"}],

Cell["<< Graphics`Legend`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.36.1"],

Cell["Here are sine and cosine curves with a legend. ", "MathCaption",
 CellTags->{"S5.36.1", "1.4"}],

Cell[CellGroupData[{

Cell["\<\
Plot[{Sin[x], Cos[x]},
    {x, -2 Pi, 2 Pi},
    PlotStyle ->
        {GrayLevel[0], Dashing[{.03}]},
    PlotLegend -> {\"Sine\", \"Cosine\"}]\
\>", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.36.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .67549 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.54329 0.4329 0.391855 0.4329 [
[ 0 0 0 0 ]
[ 1 .67549 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
% Start of sub-graphic
p
0.11039 0.124308 0.97619 0.659402 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.0757881 0.309017 0.294302 [
[.04527 .29652 -6 -9 ]
[.04527 .29652 6 0 ]
[.19685 .29652 -6 -9 ]
[.19685 .29652 6 0 ]
[.34842 .29652 -6 -9 ]
[.34842 .29652 6 0 ]
[.65158 .29652 -3 -9 ]
[.65158 .29652 3 0 ]
[.80315 .29652 -3 -9 ]
[.80315 .29652 3 0 ]
[.95473 .29652 -3 -9 ]
[.95473 .29652 3 0 ]
[.4875 .01471 -12 -4.5 ]
[.4875 .01471 0 4.5 ]
[.4875 .16187 -24 -4.5 ]
[.4875 .16187 0 4.5 ]
[.4875 .45617 -18 -4.5 ]
[.4875 .45617 0 4.5 ]
[.4875 .60332 -6 -4.5 ]
[.4875 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.04527 .30902 m
.04527 .31527 L
s
[(-6)] .04527 .29652 0 1 Mshowa
.19685 .30902 m
.19685 .31527 L
s
[(-4)] .19685 .29652 0 1 Mshowa
.34842 .30902 m
.34842 .31527 L
s
[(-2)] .34842 .29652 0 1 Mshowa
.65158 .30902 m
.65158 .31527 L
s
[(2)] .65158 .29652 0 1 Mshowa
.80315 .30902 m
.80315 .31527 L
s
[(4)] .80315 .29652 0 1 Mshowa
.95473 .30902 m
.95473 .31527 L
s
[(6)] .95473 .29652 0 1 Mshowa
.125 Mabswid
.08317 .30902 m
.08317 .31277 L
s
.12106 .30902 m
.12106 .31277 L
s
.15895 .30902 m
.15895 .31277 L
s
.23474 .30902 m
.23474 .31277 L
s
.27264 .30902 m
.27264 .31277 L
s
.31053 .30902 m
.31053 .31277 L
s
.38632 .30902 m
.38632 .31277 L
s
.42421 .30902 m
.42421 .31277 L
s
.46211 .30902 m
.46211 .31277 L
s
.53789 .30902 m
.53789 .31277 L
s
.57579 .30902 m
.57579 .31277 L
s
.61368 .30902 m
.61368 .31277 L
s
.68947 .30902 m
.68947 .31277 L
s
.72736 .30902 m
.72736 .31277 L
s
.76526 .30902 m
.76526 .31277 L
s
.84105 .30902 m
.84105 .31277 L
s
.87894 .30902 m
.87894 .31277 L
s
.91683 .30902 m
.91683 .31277 L
s
.00738 .30902 m
.00738 .31277 L
s
.99262 .30902 m
.99262 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 .01471 m
.50625 .01471 L
s
[(-1)] .4875 .01471 1 0 Mshowa
.5 .16187 m
.50625 .16187 L
s
[(-0.5)] .4875 .16187 1 0 Mshowa
.5 .45617 m
.50625 .45617 L
s
[(0.5)] .4875 .45617 1 0 Mshowa
.5 .60332 m
.50625 .60332 L
s
[(1)] .4875 .60332 1 0 Mshowa
.125 Mabswid
.5 .04415 m
.50375 .04415 L
s
.5 .07358 m
.50375 .07358 L
s
.5 .10301 m
.50375 .10301 L
s
.5 .13244 m
.50375 .13244 L
s
.5 .1913 m
.50375 .1913 L
s
.5 .22073 m
.50375 .22073 L
s
.5 .25016 m
.50375 .25016 L
s
.5 .27959 m
.50375 .27959 L
s
.5 .33845 m
.50375 .33845 L
s
.5 .36788 m
.50375 .36788 L
s
.5 .39731 m
.50375 .39731 L
s
.5 .42674 m
.50375 .42674 L
s
.5 .4856 m
.50375 .4856 L
s
.5 .51503 m
.50375 .51503 L
s
.5 .54446 m
.50375 .54446 L
s
.5 .57389 m
.50375 .57389 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .45263 L
.08255 .51497 L
.0932 .54236 L
.10458 .56657 L
.11009 .57624 L
.11531 .58409 L
.12038 .59047 L
.12507 .59525 L
.12951 .59877 L
.13178 .60018 L
.13422 .60141 L
.13549 .60193 L
.13666 .60234 L
.13784 .60268 L
.13895 .60293 L
.14022 .60314 L
.1409 .60322 L
.14161 .60328 L
.1423 .60331 L
.14295 .60332 L
.14415 .60328 L
.14531 .60316 L
.14656 .60297 L
.14773 .60271 L
.14881 .60241 L
.15143 .60144 L
.15392 .60019 L
.15886 .59679 L
.16423 .59169 L
.17382 .57909 L
.1827 .56357 L
.20137 .51989 L
.22197 .45702 L
.26217 .30798 L
.30086 .16432 L
.32051 .10346 L
.3309 .0766 L
.342 .05274 L
.35275 .03485 L
.35784 .0283 L
.36253 .02337 L
.36724 .01952 L
.36972 .01794 L
.37235 .01661 L
.37463 .01574 L
.37573 .01541 L
.37677 .01516 L
.37799 .01494 L
.37911 .0148 L
Mistroke
.38031 .01473 L
.38162 .01473 L
.38227 .01476 L
.38296 .01482 L
.38419 .01498 L
.38551 .01525 L
.38695 .01564 L
.38955 .01661 L
.39197 .01782 L
.39649 .02088 L
.40134 .02529 L
.40698 .0319 L
.41232 .03956 L
.42232 .05748 L
.44227 .1059 L
.4607 .16316 L
.50002 .3091 L
.53782 .44987 L
.55884 .51523 L
.56803 .53913 L
.57808 .56136 L
.58722 .57774 L
.59696 .59091 L
.60236 .59621 L
.60726 .59976 L
.60962 .60104 L
.61086 .6016 L
.61218 .60211 L
.61333 .60248 L
.61459 .60281 L
.61574 .60304 L
.61682 .60319 L
.61808 .60329 L
.61871 .60332 L
.61941 .60332 L
.62065 .60325 L
.62181 .60312 L
.62248 .60302 L
.62318 .60288 L
.62443 .60258 L
.62578 .60216 L
.62725 .6016 L
.62973 .6004 L
.63238 .59878 L
.63715 .59497 L
.64214 .58976 L
.64686 .58372 L
.6557 .56958 L
.67568 .52489 L
.69413 .47033 L
Mistroke
.7335 .32685 L
.77136 .18397 L
.79241 .1157 L
.81166 .06613 L
.82118 .04724 L
.8262 .0389 L
.83155 .03133 L
.8367 .02536 L
.84136 .02108 L
.84361 .01939 L
.84604 .01787 L
.84835 .01669 L
.85045 .01586 L
.85159 .0155 L
.85283 .01519 L
.85414 .01495 L
.85538 .01479 L
.85653 .01472 L
.85776 .01472 L
.85881 .01479 L
.85997 .01492 L
.86063 .01503 L
.86132 .01516 L
.86256 .01547 L
.86535 .01644 L
.86777 .0176 L
.87041 .01921 L
.87569 .02348 L
.88133 .02957 L
.89148 .0444 L
.90173 .06419 L
.91284 .09067 L
.933 .15022 L
.97393 .30026 L
.97619 .30902 L
Mfstroke
[ .03 ] 0 setdash
.02381 .60332 m
.02499 .60328 L
.02605 .60319 L
.02729 .60301 L
.02846 .60277 L
.03053 .60216 L
.03279 .60126 L
.03527 .59996 L
.0379 .59825 L
.04262 .5943 L
.05205 .58312 L
.06244 .5659 L
.0842 .51473 L
.10458 .45142 L
.14335 .3071 L
.18458 .15507 L
.20517 .0934 L
.21519 .06887 L
.22428 .05023 L
.2338 .03472 L
.24277 .02404 L
.2477 .01987 L
.25224 .01711 L
.25461 .01608 L
.25597 .01562 L
.25722 .01528 L
.25853 .01501 L
.25925 .0149 L
.25994 .01481 L
.26115 .01473 L
.26184 .01472 L
.26248 .01472 L
.26365 .01479 L
.26489 .01494 L
.26595 .01513 L
.26711 .01541 L
.2697 .01627 L
.2721 .01738 L
.27647 .02014 L
.28114 .02415 L
.28669 .03032 L
.29194 .03752 L
.30174 .05445 L
.32176 .10182 L
.34021 .15832 L
.37961 .30382 L
.4175 .4455 L
.43858 .51185 L
.45784 .55895 L
.46737 .57646 L
Mistroke
.4724 .58402 L
.47776 .59073 L
.48291 .59586 L
.48757 .59937 L
.48982 .60067 L
.49225 .60178 L
.49337 .60219 L
.49455 .60256 L
.49565 .60283 L
.49666 .60303 L
.49789 .6032 L
.49854 .60326 L
.49922 .6033 L
.50037 .60332 L
.50164 .60325 L
.50276 .60312 L
.50398 .60291 L
.50512 .60265 L
.50617 .60234 L
.50854 .60145 L
.51113 .60015 L
.51634 .5965 L
.52094 .59215 L
.52585 .58636 L
.53469 .57303 L
.54496 .55304 L
.55607 .52637 L
.57624 .46655 L
.61721 .31615 L
.65666 .16887 L
.6765 .10667 L
.6946 .06186 L
.70461 .04298 L
.71409 .02936 L
.71929 .02373 L
.7241 .01972 L
.72661 .01809 L
.72938 .01666 L
.73077 .01609 L
.73228 .01558 L
.73369 .01521 L
.735 .01496 L
.73627 .0148 L
.73747 .01472 L
.73855 .01472 L
.73973 .01478 L
.741 .01493 L
.74165 .01504 L
.74236 .01518 L
.74362 .0155 L
Mistroke
.74478 .01586 L
.74705 .01677 L
.74949 .01803 L
.7539 .02109 L
.75897 .02581 L
.76451 .03241 L
.77459 .04818 L
.79428 .09194 L
.81525 .15451 L
.85686 .3079 L
.89694 .45656 L
.91533 .51343 L
.92577 .54056 L
.93551 .56194 L
.94506 .57884 L
.94997 .58588 L
.9553 .59221 L
.95822 .59508 L
.96091 .59736 L
.96344 .59916 L
.96623 .60078 L
.96872 .60189 L
.97106 .60264 L
.97235 .60294 L
.97353 .60314 L
.97483 .60327 L
.97548 .60331 L
.97619 .60332 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
0 g
.04545 .01608 m
.04545 .27582 L
.39177 .27582 L
.39177 .01608 L
F
1 g
.02381 .03773 m
.02381 .29747 L
.37013 .29747 L
.37013 .03773 L
F
0 g
.001 w
[ ] 0 setdash
.02381 .03773 m
.37013 .03773 L
.37013 .29747 L
.02381 .29747 L
.02381 .03773 L
s
% Start of sub-graphic
p
0.0238095 0.037728 0.37013 0.297468 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0297619 0.297619 0.0297619 0.297619 [
[ 0 0 0 0 ]
[ 1 .75 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .75 L
0 .75 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0535714 0.0535714 0.35119 0.35119 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.309017 0.294302 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 g
.5 Mabswid
[ .2 ] 0 setdash
.02381 .30902 m
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
0 g
gsave
.38988 .20238 -61 -9.0625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18.125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Cosine) show
99.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% Start of sub-graphic
p
0.0535714 0.39881 0.35119 0.696429 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.309017 0.294302 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.02381 .30902 m
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
0 g
gsave
.38988 .54762 -61 -9.0625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18.125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Sine) show
87.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
MathSubEnd
P
% End of sub-graphic
0 0 m
1 0 L
1 .67549 L
0 .67549 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.36.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.36.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["option name", "TI",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["default value", "TI",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox["",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["LegendPosition", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["{-1,", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["-1}", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "specify position of legend in relation to graphic, where center of \
graphic is at ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["{0,", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["0}", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["LegendSize", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Automatic", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give length or ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["{", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["y", "TI",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["}", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" dimensions in same coordinate system as ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["LegendPosition", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["LegendShadow", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Automatic", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["None", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" gives no drop shadow for box, ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["{", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["y", "TI",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["}", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" gives offset for drop shadow",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["LegendOrientation", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Vertical", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Horizontal", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" or ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["Vertical", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[", determine the orientation of boxes",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["LegendLabel", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["None", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox["label for legend",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["LegendTextDirection", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Automatic", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["direction text is rotated, as in ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["Text", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" graphics primitive",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["LegendTextOffset", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Automatic", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["offset of text, as in ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["Text", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" graphics primitive",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
 GridBoxOptions->{RowLines->{True, False},
 RowSpacings->0.4},
 CellTags->"S5.36.1"],

Cell["Options for use with legends.", "Caption",
 CellTags->"S5.36.1"],

Cell[TextData[{
 "There are various options that can be used to control the shape and \
characteristics of a legend. The most important of these is ",
 StyleBox["LegendPosition", "MR"],
 ", which places the lower\[Hyphen]left corner of a legend box in a position \
specified by a coordinate system scaled so the center of the graphic is at ",
 StyleBox["{0, 0}", "MR"],
 ", and the longest side of the graphic runs from ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "1"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{RowLines->{False, True, False},
  RowSpacings->0.4,
  ColumnWidths->Automatic}],
 " to ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{RowLines->{False, True, False},
  RowSpacings->0.4,
  ColumnWidths->Automatic}],
 ". This same coordinate system is used for ",
 StyleBox["LegendSize", "MR"],
 " and ",
 StyleBox["LegendShadow", "MR"],
 ". "
}], "Text",
 CellTags->{"S5.36.1", "1.5"}],

Cell[TextData[{
 "Here is a density plot with a legend positioned using ",
 StyleBox["LegendPosition", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.36.1", "1.6"}],

Cell[CellGroupData[{

Cell["\<\
ShowLegend[
  DensityPlot[Sin[x y], {x, 0, Pi},
    {y, 0, Pi},
  Mesh -> False, PlotPoints -> 30,
  DisplayFunction -> Identity],
  {GrayLevel[1 - #]&, 10, \" 1\", \"-1\",
    LegendPosition -> {1.1, -.4}}]\
\>", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.36.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .83299 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.420473 0.396663 0.416497 0.396663 [
[ 0 0 0 0 ]
[ 1 .83299 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
% Start of sub-graphic
p
0.0238095 0.0198332 0.817136 0.81316 MathSubStart
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.306067 0.0192308 0.306067 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.17226 -0.0125 -9 -9 ]
[.17226 -0.0125 9 0 ]
[.3253 -0.0125 -3 -9 ]
[.3253 -0.0125 3 0 ]
[.47833 -0.0125 -9 -9 ]
[.47833 -0.0125 9 0 ]
[.63137 -0.0125 -3 -9 ]
[.63137 -0.0125 3 0 ]
[.7844 -0.0125 -9 -9 ]
[.7844 -0.0125 9 0 ]
[.93743 -0.0125 -3 -9 ]
[.93743 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .17226 -18 -4.5 ]
[-0.0125 .17226 0 4.5 ]
[-0.0125 .3253 -6 -4.5 ]
[-0.0125 .3253 0 4.5 ]
[-0.0125 .47833 -18 -4.5 ]
[-0.0125 .47833 0 4.5 ]
[-0.0125 .63137 -6 -4.5 ]
[-0.0125 .63137 0 4.5 ]
[-0.0125 .7844 -18 -4.5 ]
[-0.0125 .7844 0 4.5 ]
[-0.0125 .93743 -6 -4.5 ]
[-0.0125 .93743 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.17226 0 m
.17226 .00625 L
s
[(0.5)] .17226 -0.0125 0 1 Mshowa
.3253 0 m
.3253 .00625 L
s
[(1)] .3253 -0.0125 0 1 Mshowa
.47833 0 m
.47833 .00625 L
s
[(1.5)] .47833 -0.0125 0 1 Mshowa
.63137 0 m
.63137 .00625 L
s
[(2)] .63137 -0.0125 0 1 Mshowa
.7844 0 m
.7844 .00625 L
s
[(2.5)] .7844 -0.0125 0 1 Mshowa
.93743 0 m
.93743 .00625 L
s
[(3)] .93743 -0.0125 0 1 Mshowa
.125 Mabswid
.04984 0 m
.04984 .00375 L
s
.08044 0 m
.08044 .00375 L
s
.11105 0 m
.11105 .00375 L
s
.14166 0 m
.14166 .00375 L
s
.20287 0 m
.20287 .00375 L
s
.23348 0 m
.23348 .00375 L
s
.26408 0 m
.26408 .00375 L
s
.29469 0 m
.29469 .00375 L
s
.3559 0 m
.3559 .00375 L
s
.38651 0 m
.38651 .00375 L
s
.41712 0 m
.41712 .00375 L
s
.44772 0 m
.44772 .00375 L
s
.50894 0 m
.50894 .00375 L
s
.53955 0 m
.53955 .00375 L
s
.57015 0 m
.57015 .00375 L
s
.60076 0 m
.60076 .00375 L
s
.66197 0 m
.66197 .00375 L
s
.69258 0 m
.69258 .00375 L
s
.72319 0 m
.72319 .00375 L
s
.75379 0 m
.75379 .00375 L
s
.81501 0 m
.81501 .00375 L
s
.84561 0 m
.84561 .00375 L
s
.87622 0 m
.87622 .00375 L
s
.90683 0 m
.90683 .00375 L
s
.96804 0 m
.96804 .00375 L
s
.99865 0 m
.99865 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .17226 m
.00625 .17226 L
s
[(0.5)] -0.0125 .17226 1 0 Mshowa
0 .3253 m
.00625 .3253 L
s
[(1)] -0.0125 .3253 1 0 Mshowa
0 .47833 m
.00625 .47833 L
s
[(1.5)] -0.0125 .47833 1 0 Mshowa
0 .63137 m
.00625 .63137 L
s
[(2)] -0.0125 .63137 1 0 Mshowa
0 .7844 m
.00625 .7844 L
s
[(2.5)] -0.0125 .7844 1 0 Mshowa
0 .93743 m
.00625 .93743 L
s
[(3)] -0.0125 .93743 1 0 Mshowa
.125 Mabswid
0 .04984 m
.00375 .04984 L
s
0 .08044 m
.00375 .08044 L
s
0 .11105 m
.00375 .11105 L
s
0 .14166 m
.00375 .14166 L
s
0 .20287 m
.00375 .20287 L
s
0 .23348 m
.00375 .23348 L
s
0 .26408 m
.00375 .26408 L
s
0 .29469 m
.00375 .29469 L
s
0 .3559 m
.00375 .3559 L
s
0 .38651 m
.00375 .38651 L
s
0 .41712 m
.00375 .41712 L
s
0 .44772 m
.00375 .44772 L
s
0 .50894 m
.00375 .50894 L
s
0 .53955 m
.00375 .53955 L
s
0 .57015 m
.00375 .57015 L
s
0 .60076 m
.00375 .60076 L
s
0 .66197 m
.00375 .66197 L
s
0 .69258 m
.00375 .69258 L
s
0 .72319 m
.00375 .72319 L
s
0 .75379 m
.00375 .75379 L
s
0 .81501 m
.00375 .81501 L
s
0 .84561 m
.00375 .84561 L
s
0 .87622 m
.00375 .87622 L
s
0 .90683 m
.00375 .90683 L
s
0 .96804 m
.00375 .96804 L
s
0 .99865 m
.00375 .99865 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.17226 .99375 m
.17226 1 L
s
.3253 .99375 m
.3253 1 L
s
.47833 .99375 m
.47833 1 L
s
.63137 .99375 m
.63137 1 L
s
.7844 .99375 m
.7844 1 L
s
.93743 .99375 m
.93743 1 L
s
.125 Mabswid
.04984 .99625 m
.04984 1 L
s
.08044 .99625 m
.08044 1 L
s
.11105 .99625 m
.11105 1 L
s
.14166 .99625 m
.14166 1 L
s
.20287 .99625 m
.20287 1 L
s
.23348 .99625 m
.23348 1 L
s
.26408 .99625 m
.26408 1 L
s
.29469 .99625 m
.29469 1 L
s
.3559 .99625 m
.3559 1 L
s
.38651 .99625 m
.38651 1 L
s
.41712 .99625 m
.41712 1 L
s
.44772 .99625 m
.44772 1 L
s
.50894 .99625 m
.50894 1 L
s
.53955 .99625 m
.53955 1 L
s
.57015 .99625 m
.57015 1 L
s
.60076 .99625 m
.60076 1 L
s
.66197 .99625 m
.66197 1 L
s
.69258 .99625 m
.69258 1 L
s
.72319 .99625 m
.72319 1 L
s
.75379 .99625 m
.75379 1 L
s
.81501 .99625 m
.81501 1 L
s
.84561 .99625 m
.84561 1 L
s
.87622 .99625 m
.87622 1 L
s
.90683 .99625 m
.90683 1 L
s
.96804 .99625 m
.96804 1 L
s
.99865 .99625 m
.99865 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .17226 m
1 .17226 L
s
.99375 .3253 m
1 .3253 L
s
.99375 .47833 m
1 .47833 L
s
.99375 .63137 m
1 .63137 L
s
.99375 .7844 m
1 .7844 L
s
.99375 .93743 m
1 .93743 L
s
.125 Mabswid
.99625 .04984 m
1 .04984 L
s
.99625 .08044 m
1 .08044 L
s
.99625 .11105 m
1 .11105 L
s
.99625 .14166 m
1 .14166 L
s
.99625 .20287 m
1 .20287 L
s
.99625 .23348 m
1 .23348 L
s
.99625 .26408 m
1 .26408 L
s
.99625 .29469 m
1 .29469 L
s
.99625 .3559 m
1 .3559 L
s
.99625 .38651 m
1 .38651 L
s
.99625 .41712 m
1 .41712 L
s
.99625 .44772 m
1 .44772 L
s
.99625 .50894 m
1 .50894 L
s
.99625 .53955 m
1 .53955 L
s
.99625 .57015 m
1 .57015 L
s
.99625 .60076 m
1 .60076 L
s
.99625 .66197 m
1 .66197 L
s
.99625 .69258 m
1 .69258 L
s
.99625 .72319 m
1 .72319 L
s
.99625 .75379 m
1 .75379 L
s
.99625 .81501 m
1 .81501 L
s
.99625 .84561 m
1 .84561 L
s
.99625 .87622 m
1 .87622 L
s
.99625 .90683 m
1 .90683 L
s
.99625 .96804 m
1 .96804 L
s
.99625 .99865 m
1 .99865 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
30 string
30 30 8 [30 0 0 30 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F
7F8182848587888A8B8D8E909193949697999A9C9D9FA0A2A3A5A6A7A9AA
7F8285888B8E9194979A9DA0A3A6A9ACAEB1B4B7B9BCBFC1C4C6C9CBCED0
7F84888D91969A9FA3A7ACB0B4B8BCC0C4C8CBCFD2D6D9DCDFE2E5E8EAED
7F858B91979DA3A9AEB4B9BFC4C9CED2D7DBDFE3E7EAEDF0F3F6F8FAFBFD
7F878E969DA5ACB3B9C0C6CDD2D8DDE2E7EBEFF2F6F8FBFCFEFFFFFFFFFE
7F88919AA3ACB4BCC4CBD2D9DFE5EAEFF3F7FAFCFEFFFFFFFFFDFBF9F5F2
7F8A949FA9B3BCC5CED6DDE4EAF0F4F8FBFEFFFFFFFEFCF9F5F1ECE6DFD8
7F8B97A3AEB9C4CED7DFE7EDF3F8FBFEFFFFFFFDFAF5F0EAE3DBD2C8BEB4
7F8D9AA7B4C0CBD6DFE8EFF5FAFDFFFFFFFCF9F4EDE6DDD3C8BDB1A4978A
7F8E9DACB9C6D2DDE7EFF6FBFEFFFFFDFAF4EDE5DBD0C3B6A89A8B7C6D5E
7F90A0B0BFCDD9E4EDF5FBFEFFFFFCF7F0E7DDD1C3B5A695857564544537
7F91A3B4C4D2DFEAF3FAFEFFFFFBF5EDE3D7C8B9A8978573615040312418
7F93A6B8C9D8E5F0F8FDFFFFFBF5ECE0D2C2B19E8B786452403021150C05
7F94A9BCCEDDEAF4FBFFFFFCF5ECDFD0BEAB97826D59453324160C040000
7F96ACC0D2E2EFF8FEFFFDF7EDE0D0BDA8927C66503C2A1B0E0601000209
7F97AEC4D7E7F3FBFFFFFAF0E3D2BEA89179614B36241509020001081220
7F99B1C8DBEBF7FEFFFCF4E7D7C2AB92796048321F11060000040E1B2D42
7F9AB4CBDFEFFAFFFFF9EDDDC8B1977C6148311D0E04000108142439516B
7F9CB7CFE3F2FCFFFDF4E5D1B99E82664B321D0E0400020A192C445E7A97
7F9DB9D2E7F6FEFFFAEDDBC3A88B6D50361F0E0400020C1C324C6886A4BF
7F9FBCD6EAF8FFFEF5E6D0B59778593C24110400020D1E3651708FAECAE1
7FA0BFD9EDFBFFFCF0DDC3A68564452A150600020C1E37547495B5D1E7F7
7FA2C1DCF0FCFFF9EAD3B6957352331B0900010A1C36547698B9D5ECFAFF
7FA3C4DFF3FEFFF5E3C8A8856140240E0200081932517498BAD8EEFCFFF9
7FA5C6E2F6FFFDF1DBBD9A75503016060004142C4C7095B9D8EFFCFFF7E5
7FA6C9E5F8FFFBECD2B18B6440210C01010E2444688FB5D5EEFCFFF6E2C5
7FA7CBE8FAFFF9E6C8A47C5431150400081B395E86AED1ECFCFFF6E1C39D
7FA9CEEAFBFFF5DFBE976D45240C0002122D517AA4CAE7FAFFF7E2C39C72
7FAAD0EDFDFEF2D8B48A5E371805000920426B97BFE1F7FFF9E5C59D7248
pop
P
% End of image
MathSubEnd
P
% End of sub-graphic
0 g
.87664 .238 m
.87664 .55533 L
.97619 .55533 L
.97619 .238 L
F
1 g
.8568 .25783 m
.8568 .57516 L
.95636 .57516 L
.95636 .25783 L
F
0 g
.001 w
[ ] 0 setdash
.8568 .25783 m
.95636 .25783 L
.95636 .57516 L
.8568 .57516 L
.8568 .25783 L
s
% Start of sub-graphic
p
0.856803 0.257831 0.956357 0.575162 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.03125 0.3125 0.03125 0.3125 [
[ 0 0 0 0 ]
[ 1 3.1875 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 3.1875 L
0 3.1875 L
closepath
clip
newpath
0 g
.03125 .03125 m
.03125 .34375 L
.34375 .34375 L
.34375 .03125 L
F
gsave
.35938 .1875 -61 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
69.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
75.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.111 g
.03125 .34375 m
.03125 .65625 L
.34375 .65625 L
.34375 .34375 L
F
.222 g
.03125 .65625 m
.03125 .96875 L
.34375 .96875 L
.34375 .65625 L
F
.333 g
.03125 .96875 m
.03125 1.28125 L
.34375 1.28125 L
.34375 .96875 L
F
.444 g
.03125 1.28125 m
.03125 1.59375 L
.34375 1.59375 L
.34375 1.28125 L
F
.556 g
.03125 1.59375 m
.03125 1.90625 L
.34375 1.90625 L
.34375 1.59375 L
F
.667 g
.03125 1.90625 m
.03125 2.21875 L
.34375 2.21875 L
.34375 1.90625 L
F
.778 g
.03125 2.21875 m
.03125 2.53125 L
.34375 2.53125 L
.34375 2.21875 L
F
.889 g
.03125 2.53125 m
.03125 2.84375 L
.34375 2.84375 L
.34375 2.53125 L
F
1 g
.03125 2.84375 m
.03125 3.15625 L
.34375 3.15625 L
.34375 2.84375 L
F
0 g
gsave
.35938 3 -61 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
75.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
MathSubEnd
P
% End of sub-graphic
0 0 m
1 0 L
1 .83299 L
0 .83299 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.36.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.36.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["option name", "TI",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["default value", "TI",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox["",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["LegendSpacing", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Automatic", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "space around each key box in the legend, expressed as the ratio of the \
space to the size of the key box",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["LegendTextSpace", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Automatic", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "space allocated next to the key boxes for text, expressed as in ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["LegendSpacing", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["LegendLabelSpace", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Automatic", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["space allocated for the legend label, as in ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["LegendSpacing", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["LegendBorderSpace", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Automatic", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["space allocated around the entire legend, as in ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["LegendSpacing", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["LegendBorder", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Automatic", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "style for a border line around the legend box, can only be used if ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["LegendShadow", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" is not ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["None", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["LegendBackground", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Automatic", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["style for a background to the legend, can only be used if ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["LegendShadow", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" is not ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["None", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ShadowBackground", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["GrayLevel[0]", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "color for the legend\[CloseCurlyQuote]s drop\[Hyphen]shadow",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
 GridBoxOptions->{RowLines->{True, False},
 RowSpacings->0.4},
 CellTags->"S5.36.1"],

Cell["More options for use with legends.", "Caption",
 CellTags->"S5.36.1"],

Cell[TextData[{
 "Several of the options that determine the amount of blank space around the \
various elements of a legend accept a number that is the ratio of the size of \
the space desired to the size of one of the key boxes\[LongDash]the colored \
boxes that denote a key in the legend. These options include ",
 StyleBox["LegendSpacing", "MR"],
 ", ",
 StyleBox["LegendTextSpace", "MR"],
 ", ",
 StyleBox["LegendLabelSpace", "MR"],
 ", and ",
 StyleBox["LegendBorderSpace", "MR"],
 ". "
}], "Text",
 CellTags->{"S5.36.1", "1.7"}],

Cell["This example uses many of the options for legends. ", "MathCaption",
 CellTags->{"S5.36.1", "1.8"}],

Cell[CellGroupData[{

Cell["\<\
Plot[{Sin[x], Cos[x]}, {x, 0, 2 Pi},
    PlotStyle -> {GrayLevel[0],
        {GrayLevel[0], Dashing[{.03}]}},
    PlotLegend -> {\"sin\", \"cos\"},
    LegendPosition -> {.5, -.7},
    LegendTextSpace -> .5,
    LegendLabel -> \"Trig Funcs\",
    LegendLabelSpace -> .5,
    LegendOrientation -> Horizontal,
    LegendBackground -> GrayLevel[.5],
    LegendShadow -> {.1, -.2},
    Background -> GrayLevel[.8]]\
\>", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.36.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .63251 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Background color
.8 g
MFill
% Scaling calculations
0.420635 0.396825 0.372203 0.396825 [
[ 0 0 0 0 ]
[ 1 .63251 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
% Start of sub-graphic
p
0.0238095 0.126951 0.81746 0.617454 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Background color
.8 g
MFill
% Scaling calculations
0.0238095 0.151576 0.309016 0.294303 [
[.17539 .29652 -3 -9 ]
[.17539 .29652 3 0 ]
[.32696 .29652 -3 -9 ]
[.32696 .29652 3 0 ]
[.47854 .29652 -3 -9 ]
[.47854 .29652 3 0 ]
[.63011 .29652 -3 -9 ]
[.63011 .29652 3 0 ]
[.78169 .29652 -3 -9 ]
[.78169 .29652 3 0 ]
[.93327 .29652 -3 -9 ]
[.93327 .29652 3 0 ]
[.01131 .01471 -12 -4.5 ]
[.01131 .01471 0 4.5 ]
[.01131 .16186 -24 -4.5 ]
[.01131 .16186 0 4.5 ]
[.01131 .45617 -18 -4.5 ]
[.01131 .45617 0 4.5 ]
[.01131 .60332 -6 -4.5 ]
[.01131 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.17539 .30902 m
.17539 .31527 L
s
[(1)] .17539 .29652 0 1 Mshowa
.32696 .30902 m
.32696 .31527 L
s
[(2)] .32696 .29652 0 1 Mshowa
.47854 .30902 m
.47854 .31527 L
s
[(3)] .47854 .29652 0 1 Mshowa
.63011 .30902 m
.63011 .31527 L
s
[(4)] .63011 .29652 0 1 Mshowa
.78169 .30902 m
.78169 .31527 L
s
[(5)] .78169 .29652 0 1 Mshowa
.93327 .30902 m
.93327 .31527 L
s
[(6)] .93327 .29652 0 1 Mshowa
.125 Mabswid
.05412 .30902 m
.05412 .31277 L
s
.08444 .30902 m
.08444 .31277 L
s
.11476 .30902 m
.11476 .31277 L
s
.14507 .30902 m
.14507 .31277 L
s
.2057 .30902 m
.2057 .31277 L
s
.23602 .30902 m
.23602 .31277 L
s
.26633 .30902 m
.26633 .31277 L
s
.29665 .30902 m
.29665 .31277 L
s
.35728 .30902 m
.35728 .31277 L
s
.38759 .30902 m
.38759 .31277 L
s
.41791 .30902 m
.41791 .31277 L
s
.44822 .30902 m
.44822 .31277 L
s
.50885 .30902 m
.50885 .31277 L
s
.53917 .30902 m
.53917 .31277 L
s
.56948 .30902 m
.56948 .31277 L
s
.5998 .30902 m
.5998 .31277 L
s
.66043 .30902 m
.66043 .31277 L
s
.69074 .30902 m
.69074 .31277 L
s
.72106 .30902 m
.72106 .31277 L
s
.75138 .30902 m
.75138 .31277 L
s
.81201 .30902 m
.81201 .31277 L
s
.84232 .30902 m
.84232 .31277 L
s
.87264 .30902 m
.87264 .31277 L
s
.90295 .30902 m
.90295 .31277 L
s
.96358 .30902 m
.96358 .31277 L
s
.9939 .30902 m
.9939 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.02381 .01471 m
.03006 .01471 L
s
[(-1)] .01131 .01471 1 0 Mshowa
.02381 .16186 m
.03006 .16186 L
s
[(-0.5)] .01131 .16186 1 0 Mshowa
.02381 .45617 m
.03006 .45617 L
s
[(0.5)] .01131 .45617 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(1)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .04414 m
.02756 .04414 L
s
.02381 .07357 m
.02756 .07357 L
s
.02381 .103 m
.02756 .103 L
s
.02381 .13243 m
.02756 .13243 L
s
.02381 .1913 m
.02756 .1913 L
s
.02381 .22073 m
.02756 .22073 L
s
.02381 .25016 m
.02756 .25016 L
s
.02381 .27959 m
.02756 .27959 L
s
.02381 .33845 m
.02756 .33845 L
s
.02381 .36788 m
.02756 .36788 L
s
.02381 .39731 m
.02756 .39731 L
s
.02381 .42674 m
.02756 .42674 L
s
.02381 .4856 m
.02756 .4856 L
s
.02381 .51503 m
.02756 .51503 L
s
.02381 .54446 m
.02756 .54446 L
s
.02381 .57389 m
.02756 .57389 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .38322 L
.10458 .45852 L
.14415 .51889 L
.18221 .56357 L
.20178 .58047 L
.21267 .58793 L
.22272 .59354 L
.23293 .59796 L
.23832 .59976 L
.24402 .60127 L
.24641 .60178 L
.24897 .60225 L
.25119 .60258 L
.25361 .60288 L
.25507 .60302 L
.25643 .60313 L
.25773 .60321 L
.2584 .60324 L
.25912 .60327 L
.25983 .60329 L
.26048 .60331 L
.26176 .60332 L
.26293 .60331 L
.26416 .60329 L
.26538 .60324 L
.26607 .60321 L
.26671 .60317 L
.26912 .60299 L
.27131 .60275 L
.27364 .60244 L
.27847 .60156 L
.2838 .60025 L
.29326 .59705 L
.30213 .59301 L
.32232 .58025 L
.34082 .56432 L
.38045 .51781 L
.41855 .45965 L
.45912 .38744 L
.49816 .31259 L
.53966 .23289 L
.57964 .1614 L
.61811 .10221 L
.63759 .07707 L
.65902 .05386 L
.67938 .03652 L
.69843 .02473 L
.70884 .02018 L
.71396 .01844 L
Mistroke
.71872 .01712 L
.72301 .01617 L
.72758 .01542 L
.7302 .01511 L
.73148 .01499 L
.73266 .0149 L
.73371 .01484 L
.73487 .01478 L
.73603 .01474 L
.73725 .01472 L
.73856 .01472 L
.73977 .01473 L
.7404 .01475 L
.7411 .01477 L
.74251 .01484 L
.74375 .01492 L
.74508 .01503 L
.74748 .01528 L
.74985 .0156 L
.75235 .01601 L
.7568 .01695 L
.76198 .01836 L
.7668 .01998 L
.77773 .02472 L
.78828 .0307 L
.79823 .03757 L
.81683 .05353 L
.85534 .09846 L
.89632 .16101 L
.93577 .23146 L
.97371 .3042 L
.97619 .30902 L
Mfstroke
[ .03 ] 0 setdash
.02381 .60332 m
.02499 .60331 L
.02605 .60329 L
.02729 .60324 L
.02846 .60318 L
.03053 .60303 L
.03279 .6028 L
.03527 .60248 L
.0379 .60205 L
.04262 .60106 L
.04749 .59974 L
.05205 .59822 L
.06244 .59381 L
.07305 .58793 L
.08274 .58135 L
.10458 .56251 L
.14429 .51515 L
.18248 .45627 L
.22313 .38349 L
.26226 .30833 L
.30384 .22863 L
.34391 .15746 L
.38246 .09886 L
.402 .07411 L
.42346 .05145 L
.44388 .03466 L
.45301 .02874 L
.46295 .02346 L
.46838 .0211 L
.4734 .01923 L
.4781 .01778 L
.4833 .0165 L
.48553 .01605 L
.48794 .01564 L
.49002 .01535 L
.4923 .01509 L
.49473 .01489 L
.49605 .01481 L
.49728 .01476 L
.49844 .01473 L
.49949 .01472 L
.50071 .01472 L
.50186 .01474 L
.50301 .01477 L
.50425 .01483 L
.50542 .0149 L
.50648 .01498 L
.5091 .01524 L
.51158 .01557 L
.5165 .01646 L
Mistroke
.52187 .01777 L
.53144 .02102 L
.54032 .02507 L
.56088 .03814 L
.5795 .05428 L
.61962 .1017 L
.65822 .16102 L
.69928 .23447 L
.73882 .31042 L
.77684 .38343 L
.81732 .45593 L
.85628 .51593 L
.87613 .54149 L
.89769 .56473 L
.91843 .58221 L
.92832 .58876 L
.93759 .59383 L
.94643 .59767 L
.95595 .6007 L
.9611 .60186 L
.96369 .60232 L
.96652 .60272 L
.96894 .60298 L
.9703 .6031 L
.97153 .60318 L
.97268 .60324 L
.97393 .60329 L
.97511 .60331 L
.97619 .60332 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
0 g
.65873 .01506 m
.65873 .31236 L
.97619 .31236 L
.97619 .01506 L
F
.5 g
.61905 .09442 m
.61905 .39173 L
.93651 .39173 L
.93651 .09442 L
F
0 g
.001 w
[ ] 0 setdash
.61905 .09442 m
.93651 .09442 L
.93651 .39173 L
.61905 .39173 L
.61905 .09442 L
s
% Start of sub-graphic
p
0.619048 0.0944249 0.936508 0.391729 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0396825 0.396825 0.0396825 0.396825 [
[ 0 0 0 0 ]
[ 1 .93651 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .93651 L
0 .93651 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0714286 0.0714286 0.468254 0.468254 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.309017 0.294302 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.02381 .30902 m
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
0 g
gsave
.26984 .5 -72 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18.125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(sin) show
81.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% Start of sub-graphic
p
0.531746 0.0714286 0.928571 0.468254 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.309017 0.294302 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 g
.5 Mabswid
[ .2 ] 0 setdash
.02381 .30902 m
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
0 g
gsave
.73016 .5 -72 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(cos) show
81.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.5 .79762 -93 -9.0625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18.125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Trig) show
93.000 11.562 moveto
(Funcs) show
123.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
MathSubEnd
P
% End of sub-graphic
0 0 m
1 0 L
1 .63251 L
0 .63251 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.36.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.36.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["Legend[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["legendargs", "TI",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["opts", "TI",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "give the graphics primitives that describe an individual legend",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ShadowBox[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["pos", "TI",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["size", "TI",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["opts", "TI",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "give the graphics primitives for a box with a drop shadow",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.36.1"],

Cell["Legend functions that do not display a graphic. ", "Caption",
 CellTags->"S5.36.1"],

Cell[TextData[{
 "The arguments for ",
 StyleBox["Legend", "MR"],
 " are the same as those inside the first set of braces in the description of \
a legend given in ",
 StyleBox["ShowLegend", "MR"],
 ". Using ",
 StyleBox["Legend", "MR"],
 " or ",
 StyleBox["ShadowBox", "MR"],
 ", you can generate just the graphics primitives of a legend or box with a \
drop shadow to be used elsewhere in your own graphics. "
}], "Text",
 CellTags->{"S5.36.1", "1.9"}],

Cell["This represents a box with a shadow. ", "MathCaption",
 CellTags->{"S5.36.1", "1.10"}],

Cell[CellGroupData[{

Cell["\<\
ShadowBox[{0, 0}, {1, 1},
    ShadowBackground -> GrayLevel[.7]]\
\>", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.36.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"GrayLevel", "[", "0.7`", "]"}], ",", 
   RowBox[{"Rectangle", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.1`", ",", 
       RowBox[{"-", "0.1`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.1`", ",", "0.9`"}], "}"}]}], "]"}], ",", 
   RowBox[{"GrayLevel", "[", "1", "]"}], ",", 
   RowBox[{"Rectangle", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]}], "]"}], ",", 
   RowBox[{"Thickness", "[", "0.001`", "]"}], ",", 
   RowBox[{"GrayLevel", "[", "0", "]"}], ",", 
   RowBox[{"Line", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], "}"}], "]"}]}], "}"}]], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S5.36.1"]
}, Open  ]],

Cell["Here is what the box looks like. ", "MathCaption",
 CellTags->{"S5.36.1", "1.11"}],

Cell[CellGroupData[{

Cell["Show[Graphics[%]]", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.36.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.865801 0.0682245 0.535094 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.7 g
.11039 .01472 m
.11039 .54981 L
.97619 .54981 L
.97619 .01472 L
F
1 g
.02381 .06822 m
.02381 .60332 L
.88961 .60332 L
.88961 .06822 L
F
0 g
.001 w
[ ] 0 setdash
.02381 .06822 m
.88961 .06822 L
.88961 .60332 L
.02381 .60332 L
.02381 .06822 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.36.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S5.36.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["ShadowOffset -> {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["y", "TI",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["}", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[" and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["y", "TI",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[" offset of the shadow from the box",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ShadowBackground -> ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["color", "TI",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "give the color of the shadow",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ShadowForeground -> ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["color", "TI",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "give the color of the box with the shadow",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ShadowBorder -> ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["style", "TI",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "give a graphics primitive or list of primitives denoting the style of \
the line around the box",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.36.1"],

Cell[TextData[{
 "Options for ",
 StyleBox["ShadowBox", "MR"],
 ". "
}], "Caption",
 CellTags->"S5.36.1"]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.36.1"->{
    Cell[1776, 53, 131, 6, 36, "Subsection",
      CellTags->{"S5.36.1", "1.1"}],
    Cell[1910, 61, 717, 18, 104, "Text",
      CellTags->{"S5.36.1", "1.2"}],
    Cell[2630, 81, 8717, 240, 218, "DefinitionBox",
      CellTags->"S5.36.1"],
    Cell[11350, 323, 93, 1, 15, "Caption",
      CellTags->"S5.36.1"],
    Cell[11446, 326, 78, 1, 40, "MathCaption",
      CellTags->{"S5.36.1", "1.3"}],
    Cell[11527, 329, 82, 2, 28, "Input",
      CellTags->"S5.36.1"],
    Cell[11612, 333, 101, 1, 40, "MathCaption",
      CellTags->{"S5.36.1", "1.4"}],
    Cell[11738, 338, 214, 8, 96, "Input",
      CellTags->"S5.36.1"],
    Cell[11955, 348, 11969, 726, 186, 11898, 723, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.36.1"],
    Cell[23927, 1076, 180, 6, 70, "Output",
      CellTags->"S5.36.1"],
    Cell[24122, 1085, 9693, 282, 70, "DefinitionBox3Col",
      CellTags->"S5.36.1"],
    Cell[33818, 1369, 70, 1, 70, "Caption",
      CellTags->"S5.36.1"],
    Cell[33891, 1372, 952, 26, 70, "Text",
      CellTags->{"S5.36.1", "1.5"}],
    Cell[34846, 1400, 165, 5, 70, "MathCaption",
      CellTags->{"S5.36.1", "1.6"}],
    Cell[35036, 1409, 278, 10, 70, "Input",
      CellTags->"S5.36.1"],
    Cell[35317, 1421, 12506, 785, 70, 12435, 782, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.36.1"],
    Cell[47826, 2208, 180, 6, 70, "Output",
      CellTags->"S5.36.1"],
    Cell[48021, 2217, 8118, 232, 70, "DefinitionBox3Col",
      CellTags->"S5.36.1"],
    Cell[56142, 2451, 75, 1, 70, "Caption",
      CellTags->"S5.36.1"],
    Cell[56220, 2454, 535, 14, 70, "Text",
      CellTags->{"S5.36.1", "1.7"}],
    Cell[56758, 2470, 105, 1, 70, "MathCaption",
      CellTags->{"S5.36.1", "1.8"}],
    Cell[56888, 2475, 481, 15, 70, "Input",
      CellTags->"S5.36.1"],
    Cell[57372, 2492, 12037, 696, 70, 11966, 693, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.36.1"],
    Cell[69412, 3190, 180, 6, 70, "Output",
      CellTags->"S5.36.1"],
    Cell[69607, 3199, 2249, 66, 70, "DefinitionBox",
      CellTags->"S5.36.1"],
    Cell[71859, 3267, 89, 1, 70, "Caption",
      CellTags->"S5.36.1"],
    Cell[71951, 3270, 454, 13, 70, "Text",
      CellTags->{"S5.36.1", "1.9"}],
    Cell[72408, 3285, 92, 1, 70, "MathCaption",
      CellTags->{"S5.36.1", "1.10"}],
    Cell[72525, 3290, 135, 5, 70, "Input",
      CellTags->"S5.36.1"],
    Cell[72663, 3297, 1084, 34, 70, "Output",
      CellTags->"S5.36.1"],
    Cell[73762, 3334, 88, 1, 70, "MathCaption",
      CellTags->{"S5.36.1", "1.11"}],
    Cell[73875, 3339, 80, 2, 70, "Input",
      CellTags->"S5.36.1"],
    Cell[73958, 3343, 917, 60, 70, 846, 57, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.36.1"],
    Cell[74878, 3405, 180, 6, 70, "Output",
      CellTags->"S5.36.1"],
    Cell[75073, 3414, 3390, 101, 70, "DefinitionBox",
      CellTags->"S5.36.1"],
    Cell[78466, 3517, 105, 5, 70, "Caption",
      CellTags->"S5.36.1"]},
  "1.1"->{
    Cell[1776, 53, 131, 6, 36, "Subsection",
      CellTags->{"S5.36.1", "1.1"}]},
  "1.2"->{
    Cell[1910, 61, 717, 18, 104, "Text",
      CellTags->{"S5.36.1", "1.2"}]},
  "1.3"->{
    Cell[11446, 326, 78, 1, 40, "MathCaption",
      CellTags->{"S5.36.1", "1.3"}]},
  "1.4"->{
    Cell[11612, 333, 101, 1, 40, "MathCaption",
      CellTags->{"S5.36.1", "1.4"}]},
  "1.5"->{
    Cell[33891, 1372, 952, 26, 70, "Text",
      CellTags->{"S5.36.1", "1.5"}]},
  "1.6"->{
    Cell[34846, 1400, 165, 5, 70, "MathCaption",
      CellTags->{"S5.36.1", "1.6"}]},
  "1.7"->{
    Cell[56220, 2454, 535, 14, 70, "Text",
      CellTags->{"S5.36.1", "1.7"}]},
  "1.8"->{
    Cell[56758, 2470, 105, 1, 70, "MathCaption",
      CellTags->{"S5.36.1", "1.8"}]},
  "1.9"->{
    Cell[71951, 3270, 454, 13, 70, "Text",
      CellTags->{"S5.36.1", "1.9"}]},
  "1.10"->{
    Cell[72408, 3285, 92, 1, 70, "MathCaption",
      CellTags->{"S5.36.1", "1.10"}]},
  "1.11"->{
    Cell[73762, 3334, 88, 1, 70, "MathCaption",
      CellTags->{"S5.36.1", "1.11"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.36.1", 79210, 3541},
  {"1.1", 82310, 3622},
  {"1.2", 82404, 3625},
  {"1.3", 82494, 3628},
  {"1.4", 82590, 3631},
  {"1.5", 82687, 3634},
  {"1.6", 82779, 3637},
  {"1.7", 82877, 3640},
  {"1.8", 82969, 3643},
  {"1.9", 83067, 3646},
  {"1.10", 83160, 3649},
  {"1.11", 83259, 3652}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 131, 6, 36, "Subsection",
  CellTags->{"S5.36.1", "1.1"}],
Cell[1910, 61, 717, 18, 104, "Text",
  CellTags->{"S5.36.1", "1.2"}],
Cell[2630, 81, 8717, 240, 218, "DefinitionBox",
  CellTags->"S5.36.1"],
Cell[11350, 323, 93, 1, 15, "Caption",
  CellTags->"S5.36.1"],
Cell[11446, 326, 78, 1, 40, "MathCaption",
  CellTags->{"S5.36.1", "1.3"}],
Cell[11527, 329, 82, 2, 28, "Input",
  CellTags->"S5.36.1"],
Cell[11612, 333, 101, 1, 40, "MathCaption",
  CellTags->{"S5.36.1", "1.4"}],

Cell[CellGroupData[{
Cell[11738, 338, 214, 8, 96, "Input",
  CellTags->"S5.36.1"],
Cell[11955, 348, 11969, 726, 186, 11898, 723, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.36.1"],
Cell[23927, 1076, 180, 6, 70, "Output",
  CellTags->"S5.36.1"]
}, Open  ]],
Cell[24122, 1085, 9693, 282, 70, "DefinitionBox3Col",
  CellTags->"S5.36.1"],
Cell[33818, 1369, 70, 1, 70, "Caption",
  CellTags->"S5.36.1"],
Cell[33891, 1372, 952, 26, 70, "Text",
  CellTags->{"S5.36.1", "1.5"}],
Cell[34846, 1400, 165, 5, 70, "MathCaption",
  CellTags->{"S5.36.1", "1.6"}],

Cell[CellGroupData[{
Cell[35036, 1409, 278, 10, 70, "Input",
  CellTags->"S5.36.1"],
Cell[35317, 1421, 12506, 785, 70, 12435, 782, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.36.1"],
Cell[47826, 2208, 180, 6, 70, "Output",
  CellTags->"S5.36.1"]
}, Open  ]],
Cell[48021, 2217, 8118, 232, 70, "DefinitionBox3Col",
  CellTags->"S5.36.1"],
Cell[56142, 2451, 75, 1, 70, "Caption",
  CellTags->"S5.36.1"],
Cell[56220, 2454, 535, 14, 70, "Text",
  CellTags->{"S5.36.1", "1.7"}],
Cell[56758, 2470, 105, 1, 70, "MathCaption",
  CellTags->{"S5.36.1", "1.8"}],

Cell[CellGroupData[{
Cell[56888, 2475, 481, 15, 70, "Input",
  CellTags->"S5.36.1"],
Cell[57372, 2492, 12037, 696, 70, 11966, 693, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.36.1"],
Cell[69412, 3190, 180, 6, 70, "Output",
  CellTags->"S5.36.1"]
}, Open  ]],
Cell[69607, 3199, 2249, 66, 70, "DefinitionBox",
  CellTags->"S5.36.1"],
Cell[71859, 3267, 89, 1, 70, "Caption",
  CellTags->"S5.36.1"],
Cell[71951, 3270, 454, 13, 70, "Text",
  CellTags->{"S5.36.1", "1.9"}],
Cell[72408, 3285, 92, 1, 70, "MathCaption",
  CellTags->{"S5.36.1", "1.10"}],

Cell[CellGroupData[{
Cell[72525, 3290, 135, 5, 70, "Input",
  CellTags->"S5.36.1"],
Cell[72663, 3297, 1084, 34, 70, "Output",
  CellTags->"S5.36.1"]
}, Open  ]],
Cell[73762, 3334, 88, 1, 70, "MathCaption",
  CellTags->{"S5.36.1", "1.11"}],

Cell[CellGroupData[{
Cell[73875, 3339, 80, 2, 70, "Input",
  CellTags->"S5.36.1"],
Cell[73958, 3343, 917, 60, 70, 846, 57, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.36.1"],
Cell[74878, 3405, 180, 6, 70, "Output",
  CellTags->"S5.36.1"]
}, Open  ]],
Cell[75073, 3414, 3390, 101, 70, "DefinitionBox",
  CellTags->"S5.36.1"],
Cell[78466, 3517, 105, 5, 70, "Caption",
  CellTags->"S5.36.1"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

