(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    136645,       4483]*)
(*NotebookOutlinePosition[    149990,       4872]*)
(*  CellTagsIndexPosition[    148859,       4825]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  "Statistics",
  StyleBox["`", "MB"],
  "LinearRegression",
  StyleBox["`", "MB"]
}], "Subsection",
  CellTags->{"S6.3.1", "1.1"}],

Cell[TextData[{
  "The built\[Hyphen]in function ",
  StyleBox["Fit", "MR"],
  " finds a least\[Hyphen]squares fit to a list of data as a linear \
combination of the specified basis functions. The functions ",
  StyleBox["Regress", "MR"],
  " and ",
  StyleBox["DesignedRegress", "MR"],
  " provided in this package augment ",
  StyleBox["Fit", "MR"],
  " by giving a list of commonly required diagnostics such as the coefficient \
of determination ",
  StyleBox["RSquared", "MR"],
  ", the analysis of variance table ",
  StyleBox["ANOVATable", "MR"],
  ", and the mean squared error ",
  StyleBox["EstimatedVariance", "MR"],
  ". The output of regression functions can be controlled so that only needed \
information is produced. "
}], "Text",
  CellTags->{"S6.3.1", "1.2"}],

Cell[TextData[{
  "The basis functions ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["f",
            "TI"], 
          StyleBox["j",
            "TI"]], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " specify the predictors as functions of the independent variables. The \
resulting model for the response variable is ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["y",
              "TI"], 
            StyleBox["i",
              "TI"]], "=", \(\[Beta]\_1\), 
          SubscriptBox[
            StyleBox["f",
              "TI"], 
            RowBox[{"1", 
              StyleBox["i",
                "TI"]}]], "+", \(\[Beta]\_2\), 
          SubscriptBox[
            StyleBox["f",
              "TI"], 
            RowBox[{"2", 
              StyleBox["i",
                "TI"]}]], "+", "\[Ellipsis]", "+", 
          SubscriptBox["\[Beta]", 
            StyleBox["p",
              "TI"]], 
          SubscriptBox[
            StyleBox["f",
              "TI"], 
            StyleBox[\(p  i\),
              "TI"]], "+", 
          SubscriptBox[
            StyleBox["e",
              "TI"], 
            StyleBox["i",
              "TI"]]}], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  ", where ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["y",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " is the ",
  Cell[BoxData[
      FormBox[
        StyleBox["i",
          "TI"], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  Cell[BoxData[
      \(TraditionalForm\`\[Null]\^th\)], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  "response, ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["f",
            "TI"], 
          StyleBox[\(j  i\),
            "TI"]], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " is the ",
  Cell[BoxData[
      FormBox[
        StyleBox["j",
          "TI"], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  Cell[BoxData[
      \(TraditionalForm\`\[Null]\^th\)], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " basis function evaluated at the ",
  Cell[BoxData[
      FormBox[
        StyleBox["i",
          "TI"], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  Cell[BoxData[
      \(TraditionalForm\`\[Null]\^th\)], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " observation, and ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["e",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " is the ",
  Cell[BoxData[
      FormBox[
        StyleBox["i",
          "TI"], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  Cell[BoxData[
      \(TraditionalForm\`\[Null]\^th\)], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " statistical error. "
}], "Text",
  CellTags->{"S6.3.1", "1.3"}],

Cell[TextData[{
  "Estimates of the coefficients ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Beta]\_1\), ",", "\[Ellipsis]", ",", 
          SubscriptBox["\[Beta]", 
            StyleBox["p",
              "TI"]]}], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " are calculated to minimize ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          UnderscriptBox["\[Sum]", 
            StyleBox["i",
              "TI"],
            LimitsPositioning->True], 
          SubsuperscriptBox[
            StyleBox["e",
              "TI"], 
            StyleBox["i",
              "TI"], "2"]}], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  ", the error or residual sum of squares. For example, simple linear \
regression is accomplished by defining the basis functions as ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["f",
              "TI"], "1"], "=", "1"}], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " and ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["f",
              "TI"], "2"], "=", 
          StyleBox["x",
            "TI"]}], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  ", in which case ",
  Cell[BoxData[
      \(TraditionalForm\`\[Beta]\_1\)], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Beta]\_2\)], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " are found to minimize ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          UnderscriptBox["\[Sum]", 
            StyleBox["i",
              "TI"],
            LimitsPositioning->True], 
          SuperscriptBox[
            RowBox[{"[", 
              RowBox[{
                SubscriptBox[
                  StyleBox["y",
                    "TI"], 
                  StyleBox["i",
                    "TI"]], "-", 
                RowBox[{"(", 
                  RowBox[{\(\[Beta]\_1\), "+", \(\[Beta]\_2\), 
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["i",
                        "TI"]]}], ")"}]}], "]"}], "2"]}], TraditionalForm]], 
    "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  ". "
}], "Text",
  CellTags->{"S6.3.1", "1.4"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Regress[", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["data", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[", {", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["1", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[", ", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["x", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[", ", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["x", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["^2}, ", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["x", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["]", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[{
              StyleBox["fit a list of data points ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["data", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" to a quadratic model ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[{
              StyleBox["Regress[", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["data", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[",", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  \(TraditionalForm\`{\)], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox["1", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[", ", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[", ", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[", ", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              Cell[BoxData[
                  \(TraditionalForm\`}\)], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[", {", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[", ", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox["}]", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[{
              StyleBox["fit ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["data", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[
              " to a model that includes interaction between independent \
variables ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[" and ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[{
              StyleBox["Regress[", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["data", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[", {", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["f",
                        "TI"], "1"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[", ", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["f",
                        "TI"], "2"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[", \[Ellipsis] }, ", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["vars", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["]", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[{
              StyleBox["fit ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["data", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[
              " to a model composed of a linear combination of the functions \
",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["f",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[" of the variables ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["vars", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S6.3.1"],

Cell[TextData[{
  "Using ",
  StyleBox["Regress", "MR"],
  "."
}], "Caption",
  CellTags->"S6.3.1"],

Cell[TextData[{
  "The arguments of ",
  StyleBox["Regress", "MR"],
  " are of the same form as those of ",
  StyleBox["Fit", "MR"],
  ". The data can be a list of vectors, each vector consisting of the \
observed values of the independent variables and the associated response. The \
basis functions ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["f",
            "TI"], 
          StyleBox["j",
            "TI"]], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " must be functions of the symbols given as variables. These symbols \
correspond to the independent variables represented in the data. "
}], "Text",
  CellTags->{"S6.3.1", "1.5"}],

Cell[TextData[{
  "The data can also be a vector of data points. In this case, ",
  StyleBox["Regress", "MR"],
  " assumes that this vector represents the values of a response variable \
with the independent variable having values ",
  Cell[BoxData[
      \(TraditionalForm\`1\)], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`2\)], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  ", \[Ellipsis] . "
}], "Text",
  CellTags->{"S6.3.1", "1.6"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["{", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], "1"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[",", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], "2"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[", \[Ellipsis] }", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[{
              StyleBox[
              "data points specified by a list of response values, where a \
single independent variable is assumed to take the values ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  \(TraditionalForm\`1\)], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[", ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  \(TraditionalForm\`2\)], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[", \[Ellipsis] ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[{
              StyleBox["{{", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "11"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[", ", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "12"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[", \[Ellipsis] , ", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], "1"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox["},{", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "21"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[", ", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "22"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[", \[Ellipsis] , ", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], "2"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox["}, \[Ellipsis] }", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[{
              StyleBox["data points specified by a matrix, where ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox[\(i  k\),
                        "TI"]], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[" is the value of the ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    StyleBox["i",
                      "TI"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[" case of the ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    StyleBox["k",
                      "TI"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[" independent variable, and ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[" is the ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    StyleBox["i",
                      "TI"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[" response ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S6.3.1"],

Cell[TextData[{
  "Ways of specifying data in ",
  StyleBox["Regress", "MR"],
  "."
}], "Caption",
  CellTags->"S6.3.1"],

Cell["This loads the package. ", "MathCaption",
  CellTags->{"S6.3.1", "1.7"}],

Cell["<<Statistics`LinearRegression`", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S6.3.1"],

Cell["\<\
In this data, the first element in each pair gives the value of the \
independent variable, while the second gives the observed response. \
\>", \
"MathCaption",
  CellTags->{"S6.3.1", "1.8"}],

Cell["\<\
data = {{0.055, 90}, {0.091, 97}, {0.138, 107},
 {0.167, 124}, {0.182, 142}, {0.211, 150},
 {0.232, 172}, {0.248, 189}, {0.284, 209},
 {0.351, 253}};\
\>", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S6.3.1"],

Cell["This is a plot of the data. ", "MathCaption",
  CellTags->{"S6.3.1", "1.9"}],

Cell[CellGroupData[{

Cell["dplot = ListPlot[data]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S6.3.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.153153 3.2175 -0.310281 0.00361107 [
[.00772 .02027 -12 -9 ]
[.00772 .02027 12 0 ]
[.32947 .02027 -12 -9 ]
[.32947 .02027 12 0 ]
[.49035 .02027 -9 -9 ]
[.49035 .02027 9 0 ]
[.65122 .02027 -12 -9 ]
[.65122 .02027 12 0 ]
[.8121 .02027 -9 -9 ]
[.8121 .02027 9 0 ]
[.97297 .02027 -12 -9 ]
[.97297 .02027 12 0 ]
[.1561 .05083 -18 -4.5 ]
[.1561 .05083 0 4.5 ]
[.1561 .1411 -18 -4.5 ]
[.1561 .1411 0 4.5 ]
[.1561 .23138 -18 -4.5 ]
[.1561 .23138 0 4.5 ]
[.1561 .32166 -18 -4.5 ]
[.1561 .32166 0 4.5 ]
[.1561 .41193 -18 -4.5 ]
[.1561 .41193 0 4.5 ]
[.1561 .50221 -18 -4.5 ]
[.1561 .50221 0 4.5 ]
[.1561 .59249 -18 -4.5 ]
[.1561 .59249 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.00772 .03277 m
.00772 .03902 L
s
[(0.05)] .00772 .02027 0 1 Mshowa
.32947 .03277 m
.32947 .03902 L
s
[(0.15)] .32947 .02027 0 1 Mshowa
.49035 .03277 m
.49035 .03902 L
s
[(0.2)] .49035 .02027 0 1 Mshowa
.65122 .03277 m
.65122 .03902 L
s
[(0.25)] .65122 .02027 0 1 Mshowa
.8121 .03277 m
.8121 .03902 L
s
[(0.3)] .8121 .02027 0 1 Mshowa
.97297 .03277 m
.97297 .03902 L
s
[(0.35)] .97297 .02027 0 1 Mshowa
.125 Mabswid
.0399 .03277 m
.0399 .03652 L
s
.07207 .03277 m
.07207 .03652 L
s
.10425 .03277 m
.10425 .03652 L
s
.13642 .03277 m
.13642 .03652 L
s
.20077 .03277 m
.20077 .03652 L
s
.23295 .03277 m
.23295 .03652 L
s
.26512 .03277 m
.26512 .03652 L
s
.2973 .03277 m
.2973 .03652 L
s
.36165 .03277 m
.36165 .03652 L
s
.39382 .03277 m
.39382 .03652 L
s
.426 .03277 m
.426 .03652 L
s
.45817 .03277 m
.45817 .03652 L
s
.52252 .03277 m
.52252 .03652 L
s
.5547 .03277 m
.5547 .03652 L
s
.58687 .03277 m
.58687 .03652 L
s
.61905 .03277 m
.61905 .03652 L
s
.6834 .03277 m
.6834 .03652 L
s
.71557 .03277 m
.71557 .03652 L
s
.74775 .03277 m
.74775 .03652 L
s
.77992 .03277 m
.77992 .03652 L
s
.84427 .03277 m
.84427 .03652 L
s
.87645 .03277 m
.87645 .03652 L
s
.90862 .03277 m
.90862 .03652 L
s
.9408 .03277 m
.9408 .03652 L
s
.25 Mabswid
0 .03277 m
1 .03277 L
s
.1686 .05083 m
.17485 .05083 L
s
[(100)] .1561 .05083 1 0 Mshowa
.1686 .1411 m
.17485 .1411 L
s
[(125)] .1561 .1411 1 0 Mshowa
.1686 .23138 m
.17485 .23138 L
s
[(150)] .1561 .23138 1 0 Mshowa
.1686 .32166 m
.17485 .32166 L
s
[(175)] .1561 .32166 1 0 Mshowa
.1686 .41193 m
.17485 .41193 L
s
[(200)] .1561 .41193 1 0 Mshowa
.1686 .50221 m
.17485 .50221 L
s
[(225)] .1561 .50221 1 0 Mshowa
.1686 .59249 m
.17485 .59249 L
s
[(250)] .1561 .59249 1 0 Mshowa
.125 Mabswid
.1686 .06888 m
.17235 .06888 L
s
.1686 .08694 m
.17235 .08694 L
s
.1686 .10499 m
.17235 .10499 L
s
.1686 .12305 m
.17235 .12305 L
s
.1686 .15916 m
.17235 .15916 L
s
.1686 .17721 m
.17235 .17721 L
s
.1686 .19527 m
.17235 .19527 L
s
.1686 .21332 m
.17235 .21332 L
s
.1686 .24943 m
.17235 .24943 L
s
.1686 .26749 m
.17235 .26749 L
s
.1686 .28555 m
.17235 .28555 L
s
.1686 .3036 m
.17235 .3036 L
s
.1686 .33971 m
.17235 .33971 L
s
.1686 .35777 m
.17235 .35777 L
s
.1686 .37582 m
.17235 .37582 L
s
.1686 .39388 m
.17235 .39388 L
s
.1686 .42999 m
.17235 .42999 L
s
.1686 .44804 m
.17235 .44804 L
s
.1686 .4661 m
.17235 .4661 L
s
.1686 .48415 m
.17235 .48415 L
s
.1686 .52026 m
.17235 .52026 L
s
.1686 .53832 m
.17235 .53832 L
s
.1686 .55638 m
.17235 .55638 L
s
.1686 .57443 m
.17235 .57443 L
s
.1686 .01472 m
.17235 .01472 L
s
.1686 .61054 m
.17235 .61054 L
s
.25 Mabswid
.1686 0 m
.1686 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.008 w
.02381 .01472 Mdot
.13964 .03999 Mdot
.29086 .0761 Mdot
.38417 .13749 Mdot
.43243 .20249 Mdot
.52574 .23138 Mdot
.59331 .31082 Mdot
.64479 .37221 Mdot
.76062 .44443 Mdot
.97619 .60332 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S6.3.1"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S6.3.1"]
}, Open  ]],

Cell[TextData[{
  "This is the regression output for fitting the model ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["y",
              "TI"], 
            StyleBox["i",
              "TI"]], "=", \(\[Beta]\_0\), "+", \(\[Beta]\_1\), 
          SubsuperscriptBox[
            StyleBox["x",
              "TI"], 
            StyleBox["i",
              "TI"], "2"], "+", 
          SubscriptBox[
            StyleBox["e",
              "TI"], 
            StyleBox["i",
              "TI"]]}], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  ". ",
  StyleBox["Chop", "MR"],
  " replaces the p\[Hyphen]values below ",
  Cell[BoxData[
      \(TraditionalForm\`10\^\(-6\)\)], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " with ",
  StyleBox["0", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S6.3.1", "1.10"}],

Cell[CellGroupData[{

Cell["\<\
(regress = Regress[data, {1, x^2}, x];
Chop[regress, 10^(-6)])\
\>", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S6.3.1"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"ParameterTable", "\[Rule]", 
          TagBox[GridBox[{
                {"\<\"\"\>", "\<\"Estimate\"\>", "\<\"SE\"\>", \
"\<\"TStat\"\>", "\<\"PValue\"\>"},
                {"1", "88.19401431869144`", "4.211668077193906`", 
                  "20.940400027309884`", "0"},
                {\(x\^2\), "1430.6838233610401`", "73.69505688361104`", 
                  "19.41356562924654`", "0"}
                },
              RowSpacings->1,
              ColumnSpacings->3,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}],
            Function[ BoxForm`e$, 
              TableForm[ BoxForm`e$, TableHeadings -> {{1, 
                Power[ x, 2]}, {"Estimate", "SE", "TStat", "PValue"}}]]]}], 
        ",", \(RSquared \[Rule] 0.9792146532360269`\), 
        ",", \(AdjustedRSquared \[Rule] 0.9766164848905302`\), 
        ",", \(EstimatedVariance \[Rule] 64.91289776072271`\), ",", 
        RowBox[{"ANOVATable", "\[Rule]", 
          InterpretationBox[GridBox[{
                {"\<\"\"\>", "\<\"DF\"\>", "\<\"SumOfSq\"\>", \
"\<\"MeanSq\"\>", "\<\"FRatio\"\>", "\<\"PValue\"\>"},
                {"\<\"Model\"\>", "1", "24464.796817914215`", 
                  "24464.796817914215`", "376.88653044106275`", "0"},
                {"\<\"Error\"\>", "8", "519.3031820857817`", 
                  "64.91289776072271`", "\<\"\"\>", "\<\"\"\>"},
                {"\<\"Total\"\>", "9", 
                  "24984.1`", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"}
                },
              RowSpacings->1,
              ColumnSpacings->3,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}],
            
            TableForm[ {{1, 24464.7968179142, 24464.7968179142, 
              376.886530441063, 0}, {8, 519.303182085782, 64.9128977607227}, {
              9, 24984.1}}, TableHeadings -> {{"Model", "Error", "Total"}, {
              "DF", "SumOfSq", "MeanSq", "FRatio", "PValue"}}]]}]}], 
      "}"}]], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S6.3.1"]
}, Open  ]],

Cell[TextData[{
  "You can use ",
  StyleBox["Fit", "MR"],
  " if you only want the fit function. "
}], "MathCaption",
  CellTags->{"S6.3.1", "1.11"}],

Cell[CellGroupData[{

Cell["func = Fit[data, {1, x^2}, x]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S6.3.1"],

Cell[BoxData[
    \(\(\(88.19401431869147`\)\(\[InvisibleSpace]\)\) + 
      1430.6838233610406`\ x\^2\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S6.3.1"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["option name", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->{True, False}}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->{True, False}}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}], Cell[TextData[{
              StyleBox["default value", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->{True, False}}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->{True, False}}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}], Cell[TextData[StyleBox["",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}]},
          {Cell[TextData[{
              StyleBox["IncludeConstant", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->{True, False}}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->{True, False}}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}], Cell[TextData[StyleBox["True", "MR",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}], Cell[TextData[StyleBox[
            "constant automatically included in model ",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}]},
          {Cell[TextData[{
              StyleBox["Weights", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->{True, False}}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->{True, False}}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}], Cell[TextData[{
              StyleBox["Automatic", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->{True, False}}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->{True, False}}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}], Cell[TextData[StyleBox[
            "list of weights for each data point or pure function",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}]},
          {Cell[TextData[{
              StyleBox["RegressionReport", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->{True, False}}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->{True, False}}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}], Cell[TextData[{
              StyleBox["SummaryReport", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->{True, False}}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->{True, False}}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}], Cell[TextData[StyleBox[
            "objects to be included in output ",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}]},
          {Cell[TextData[{
              StyleBox["BasisNames", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->{True, False}}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->{True, False}}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}], Cell[TextData[{
              StyleBox["Automatic", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->{True, False}}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->{True, False}}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}], Cell[TextData[StyleBox[
            "names of basis elements for table headings ",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False}},
  CellTags->"S6.3.1"],

Cell[TextData[{
  "Options for ",
  StyleBox["Regress", "MR"],
  "."
}], "Caption",
  CellTags->"S6.3.1"],

Cell[TextData[{
  "Two of the options of ",
  StyleBox["Regress", "MR"],
  " influence the method of calculation. ",
  StyleBox["IncludeConstant", "MR"],
  " has a default setting ",
  StyleBox["True", "MR"],
  ", which causes a constant term to be added to the model even if it is not \
specified in the basis functions. To fit a model without this constant term, \
specify ",
  StyleBox["IncludeConstant", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["False", "MR"],
  " and do not include a constant in the basis functions. "
}], "Text",
  CellTags->{"S6.3.1", "1.12"}],

Cell[TextData[{
  "The ",
  StyleBox["Weights", "MR"],
  " option allows you to implement weighted least squares by specifying a \
list of weights, one for each data point; the default ",
  StyleBox["Weights -> Automatic", "MR"],
  " implies a weight of unity for each data point. When ",
  StyleBox["Weights -> {", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["w",
            "TI"], "1"], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  StyleBox[", \[Ellipsis] , ", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["w",
            "TI"], 
          StyleBox["n",
            "TI"]], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  StyleBox["}", "MR"],
  ", the parameter estimates are chosen to minimize the weighted sum of \
squared residuals ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          UnderoverscriptBox["\[Sum]", 
            RowBox[{
              StyleBox["i",
                "TI"], "=", "1"}], 
            StyleBox["n",
              "TI"],
            LimitsPositioning->True], 
          SubscriptBox[
            StyleBox["w",
              "TI"], 
            StyleBox["i",
              "TI"]], " ", 
          SubsuperscriptBox[
            StyleBox["e",
              "TI"], 
            StyleBox["i",
              "TI"], "2"]}], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  ". "
}], "Text",
  CellTags->{"S6.3.1", "1.13"}],

Cell[TextData[{
  StyleBox["Weights", "MR"],
  " can also specify a pure function of the response. For example, to choose \
parameter estimates to minimize ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          UnderoverscriptBox["\[Sum]", 
            RowBox[{
              StyleBox["i",
                "TI"], "=", "1"}], 
            StyleBox["n",
              "TI"],
            LimitsPositioning->True], 
          SqrtBox[
            SubscriptBox[
              StyleBox["y",
                "TI"], 
              StyleBox["i",
                "TI"]]], " ", 
          SubsuperscriptBox[
            StyleBox["e",
              "TI"], 
            StyleBox["i",
              "TI"], "2"]}], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  ", set ",
  StyleBox["Weights -> (Sqrt[#] &)", "MR"],
  ". "
}], "Text",
  CellTags->{"S6.3.1", "1.14"}],

Cell[TextData[{
  "The options ",
  StyleBox["RegressionReport", "MR"],
  " and ",
  StyleBox["BasisNames", "MR"],
  " affect the form and content of the output. If ",
  StyleBox["RegressionReport", "MR"],
  " is not specified, ",
  StyleBox["Regress", "MR"],
  " automatically gives a list including values for ",
  StyleBox["ParameterTable", "MR"],
  ", ",
  StyleBox["RSquared", "MR"],
  ", ",
  StyleBox["AdjustedRSquared", "MR"],
  ", ",
  StyleBox["EstimatedVariance", "MR"],
  ", and ",
  StyleBox["ANOVATable", "MR"],
  ". This set of objects comprises the default ",
  StyleBox["SummaryReport", "MR"],
  ". The option ",
  StyleBox["RegressionReport", "MR"],
  " can be used to specify a single object or a list of objects so that more \
(or less) than the default set of results is included in the output. ",
  StyleBox["RegressionReportValues[Regress]", "MR"],
  " gives the objects that may be included in the ",
  StyleBox["RegressionReport", "MR"],
  " list for the ",
  StyleBox["Regress", "MR"],
  " function. "
}], "Text",
  CellTags->{"S6.3.1", "1.15"}],

Cell[TextData[{
  "With the option ",
  StyleBox["BasisNames", "MR"],
  ", you can label the headings of predictors in tables such as ",
  StyleBox["ParameterTable", "MR"],
  " and ",
  StyleBox["ParameterCITable", "MR"],
  ". "
}], "Text",
  CellTags->{"S6.3.1", "1.16"}],

Cell[TextData[{
  "The regression functions will also accept any option that can be specified \
for ",
  StyleBox["SingularValues", "MR"],
  " or ",
  StyleBox["StudentTCI", "MR"],
  ". In particular, the numerical tolerance for the internal singular value \
decomposition is specified using ",
  StyleBox["Tolerance", "MR"],
  ", and the confidence level for hypothesis testing and confidence intervals \
is specified using ",
  StyleBox["ConfidenceLevel", "MR"],
  ". "
}], "Text",
  CellTags->{"S6.3.1", "1.17"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["BestFit", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[StyleBox["best fit function ",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[{
              StyleBox["BestFitParameters", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[StyleBox[
            "best fit parameters",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[{
              StyleBox["ANOVATable", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[StyleBox[
            "analysis of variance table",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[{
              StyleBox["EstimatedVariance", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[StyleBox[
            "estimated error variance ",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[{
              StyleBox["ParameterTable", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[StyleBox[
            "table of parameter information including standard errors and \
test statistics ",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[{
              StyleBox["ParameterCITable", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[StyleBox[
            "table of confidence intervals for the fit parameters",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[{
              StyleBox["ParameterConfidenceRegion", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[StyleBox[
            "ellipsoidal joint confidence region for the fit parameters",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[{
              StyleBox["ParameterConfidenceRegion[{", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["f",
                        "TI"], 
                      RowBox[{
                        StyleBox["i",
                          "TI"], "1"}]], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[", ", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["f",
                        "TI"], 
                      RowBox[{
                        StyleBox["i",
                          "TI"], "2"}]], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[", \[Ellipsis] }]", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[{
              StyleBox[
              "ellipsoidal conditional joint confidence region for the fit \
parameters corresponding to the basis functions ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["{", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["f",
                        "TI"], 
                      RowBox[{
                        StyleBox["i",
                          "TI"], "1"}]], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[", ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["f",
                        "TI"], 
                      RowBox[{
                        StyleBox["i",
                          "TI"], "2"}]], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[", \[Ellipsis] }",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[{
              StyleBox["FitResiduals", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[StyleBox[
            "differences between the observed responses and the predicted \
responses ",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[{
              StyleBox["PredictedResponse", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[StyleBox[
            "fitted values obtained by evaluating the best fit function at \
the observed values of the independent variables",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[{
              StyleBox["SinglePredictionCITable", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[StyleBox[
            "table of confidence intervals for predicting a single \
observation of the response variable",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[{
              StyleBox["MeanPredictionCITable", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[StyleBox[
            "table of confidence intervals for predicting the expected value \
of the response variable",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[{
              StyleBox["RSquared", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[StyleBox[
            "coefficient of determination ",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[{
              StyleBox["AdjustedRSquared", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[StyleBox[
            "adjusted coefficient of determination ",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[{
              StyleBox["CoefficientOfVariation", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[StyleBox[
            "coefficient of variation ",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[{
              StyleBox["CovarianceMatrix", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[StyleBox[
            "covariance matrix of the fit parameters ",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[{
              StyleBox["CorrelationMatrix", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[StyleBox[
            "correlation matrix of the fit parameters ",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S6.3.1"],

Cell[TextData[{
  "Some option settings for ",
  StyleBox["RegressionReport", "MR"],
  " or objects that may be included in a list specified by ",
  StyleBox["RegressionReport", "MR"],
  "."
}], "Caption",
  CellTags->"S6.3.1"],

Cell[TextData[{
  StyleBox["ANOVATable", "MR"],
  ", a table for analysis of variance, provides a comparison of the given \
model to a smaller one including only a constant term. If ",
  StyleBox["IncludeConstant -> False", "MR"],
  " is specified, then the smaller model is reduced to the data. The table \
includes the degrees of freedom, the sum of squares and the mean squares due \
to the model (in the row labeled ",
  StyleBox["Model", "MR"],
  ") and due to the residuals (in the row labeled ",
  StyleBox["Error", "MR"],
  "). The residual mean square is also available in ",
  StyleBox["EstimatedVariance", "MR"],
  ", and is calculated by dividing the residual sum of squares by its degrees \
of freedom. The ",
  Cell[BoxData[
      FormBox[
        StyleBox["F",
          "TI"], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  "\[Hyphen]test compares the two models using the ratio of their mean \
squares. If the value of ",
  Cell[BoxData[
      FormBox[
        StyleBox["F",
          "TI"], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " is large, the null hypothesis supporting the smaller model is rejected. "
}], "Text",
  CellTags->{"S6.3.1", "1.18"}],

Cell[TextData[{
  "To evaluate the importance of each basis function, you can get information \
about the parameter estimates from the parameter table obtained by setting ",
  StyleBox["RegressionReport", "MR"],
  " to ",
  StyleBox["ParameterTable", "MR"],
  ", or by including ",
  StyleBox["ParameterTable", "MR"],
  " in the list specified by ",
  StyleBox["RegressionReport", "MR"],
  ". This table includes the estimates, their standard errors, and ",
  Cell[BoxData[
      FormBox[
        StyleBox["t",
          "TI"], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  "\[Hyphen]statistics for testing whether each parameter is zero. The ",
  Cell[BoxData[
      FormBox[
        StyleBox["p",
          "TI"], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  "\[Hyphen]values are calculated by comparing the obtained statistic to the \
",
  Cell[BoxData[
      FormBox[
        StyleBox["t",
          "TI"], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " distribution with ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["n",
            "TI"], "-", 
          StyleBox["p",
            "TI"]}], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " degrees of freedom, where ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " is the sample size and ",
  Cell[BoxData[
      FormBox[
        StyleBox["p",
          "TI"], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " is the number of predictors. Confidence intervals for the parameter \
estimates, also based on the ",
  Cell[BoxData[
      FormBox[
        StyleBox["t",
          "TI"], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " distribution, can be found by specifying ",
  StyleBox["ParameterCITable", "MR"],
  ". ",
  StyleBox["ParameterConfidenceRegion", "MR"],
  " specifies the ellipsoidal joint confidence region of all fit parameters. \
",
  StyleBox["ParameterConfidenceRegion[{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["f",
            "TI"], 
          RowBox[{
            StyleBox["i",
              "TI"], "1"}]], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  StyleBox[", ", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["f",
            "TI"], 
          RowBox[{
            StyleBox["i",
              "TI"], "2"}]], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  StyleBox[", \[Ellipsis] }]", "MR"],
  " specifies the joint conditional confidence region of the fit parameters \
associated with basis functions ",
  StyleBox["{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["f",
            "TI"], 
          RowBox[{
            StyleBox["i",
              "TI"], "1"}]], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  StyleBox[", ", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["f",
            "TI"], 
          RowBox[{
            StyleBox["i",
              "TI"], "2"}]], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  StyleBox[", \[Ellipsis] }", "MR"],
  ", a subset of the complete set of basis functions. "
}], "Text",
  CellTags->{"S6.3.1", "1.19"}],

Cell[TextData[{
  "The square of the multiple correlation coefficient is called the \
coefficient of determination ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["R",
            "TI"], "2"], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  ", and is given by the ratio of the model sum of squares to the total sum \
of squares. It is a summary statistic that describes the relationship between \
the predictors and the response variable. ",
  StyleBox["AdjustedRSquared", "MR"],
  " is defined as ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox[
            OverscriptBox[
              StyleBox["R",
                "TI"], "_"], "2"], "=", "1", "-", 
          RowBox[{"(", 
            FractionBox[
              RowBox[{
                StyleBox["n",
                  "TI"], "-", "1"}], 
              RowBox[{
                StyleBox["n",
                  "TI"], "-", 
                StyleBox["p",
                  "TI"]}]], ")"}], 
          RowBox[{"(", 
            RowBox[{"1", "-", 
              SuperscriptBox[
                StyleBox["R",
                  "TI"], "2"]}], ")"}]}], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  ", and gives an adjusted value that you can use to compare subsequent \
subsets of models. The coefficient of variation is given by the ratio of the \
residual root mean square to the mean of the response variable. If the \
response is strictly positive, this is sometimes used to measure the relative \
magnitude of error variation. "
}], "Text",
  CellTags->{"S6.3.1", "1.20"}],

Cell[TextData[{
  "Each row in ",
  StyleBox["MeanPredictionCITable", "MR"],
  " gives the confidence interval for the mean response at each of the values \
of the independent variables. Each row in ",
  StyleBox["SinglePredictionCITable", "MR"],
  " gives the confidence interval for a single observed response at each of \
the values of the independent variables. ",
  StyleBox["MeanPredictionCITable", "MR"],
  " gives a region likely to contain the regression curve, while ",
  StyleBox["SinglePredictionCITable", "MR"],
  " gives a region likely to contain all possible observations. "
}], "Text",
  CellTags->{"S6.3.1", "1.21"}],

Cell["\<\
In this example, only the residuals, the confidence interval table \
for the predicted response of single observations, and the parameter joint \
confidence region are produced. \
\>", "MathCaption",
  CellTags->{"S6.3.1", "1.22"}],

Cell[CellGroupData[{

Cell["\<\
regress = Regress[data, {1, x^2}, x,
RegressionReport ->
 {FitResiduals, SinglePredictionCITable,
 ParameterConfidenceRegion}]\
\>", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S6.3.1"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{\(FitResiduals \[Rule] {\(-2.521832884358588`\), \
\(-3.041507059944223`\), \(-8.4399570507791`\), \(-4.094355468407485`\), 
            6.416014716297468`, \(-1.8894888185483012`\), 6.800859572723937`, 
            12.813207809311137`, 
            5.412751224300507`, \(-11.455692040594954`\)}\), ",", 
        RowBox[{"SinglePredictionCITable", "\[Rule]", 
          TagBox[GridBox[{
                {"\<\"Observed\"\>", "\<\"Predicted\"\>", "\<\"SE\"\>", \
"\<\"CI\"\>"},
                {"90.`", "92.52183288435859`", 
                  "9.01140986899679`", \({71.74148446243237`, 
                    113.30218130628481`}\)},
                {"97.`", "100.04150705994422`", 
                  "8.884269134919004`", \({79.55434569655426`, 
                    120.52866842333418`}\)},
                {"107.`", "115.4399570507791`", 
                  "8.672220520843055`", \({95.44178066831259`, 
                    135.4381334332456`}\)},
                {"124.`", "128.09435546840749`", 
                  "8.549263466706952`", \({108.37971856123136`, 
                    147.8089923755836`}\)},
                {"142.`", "135.58398528370253`", 
                  "8.499232352925056`", \({115.98472033179632`, 
                    155.18325023560874`}\)},
                {"150.`", "151.8894888185483`", 
                  "8.450412204432501`", \({132.4028033309472`, 
                    171.3761743061494`}\)},
                {"172.`", "165.19914042727606`", 
                  "8.472300141581353`", \({145.66198126609862`, 
                    184.7362995884535`}\)},
                {"189.`", "176.18679219068886`", 
                  "8.531940559449225`", \({156.51210197928282`, 
                    195.8614824020949`}\)},
                {"209.`", "203.5872487756995`", 
                  "8.838207903292053`", \({183.20630480291388`, 
                    223.9681927484851`}\)},
                {"253.`", "264.45569204059495`", 
                  "10.207227699036881`", \({240.9177827576454`, 
                    287.9936013235445`}\)}
                },
              RowSpacings->1,
              ColumnSpacings->3,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}],
            Function[ BoxForm`e$, 
              TableForm[ 
              BoxForm`e$, TableDepth -> 2, TableHeadings -> {None, {
                "Observed", "Predicted", "SE", "CI"}}]]]}], 
        ",", \(ParameterConfidenceRegion \[Rule] 
          Ellipsoid[{88.19401431869144`, 
              1430.6838233610401`}, {220.30299076799488`, 
              7.600602502506946`}, {{\(-0.045514028708473174`\), 
                0.9989636996361401`}, {0.9989636996361401`, 
                0.04551402870847315`}}]\)}], "}"}]], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S6.3.1"]
}, Open  ]],

Cell["This is a list of the residuals extracted from the output. ", \
"MathCaption",
  CellTags->{"S6.3.1", "1.23"}],

Cell[CellGroupData[{

Cell["errors = FitResiduals /. regress", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S6.3.1"],

Cell[BoxData[
    \({\(-2.521832884358588`\), \(-3.041507059944223`\), \
\(-8.4399570507791`\), \(-4.094355468407485`\), 
      6.416014716297468`, \(-1.8894888185483012`\), 6.800859572723937`, 
      12.813207809311137`, 
      5.412751224300507`, \(-11.455692040594954`\)}\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S6.3.1"]
}, Open  ]],

Cell["\<\
The observed response, the predicted response, the standard errors \
of the predicted response, and the confidence intervals may also be \
extracted. \
\>", "MathCaption",
  CellTags->{"S6.3.1", "1.24"}],

Cell["\<\
{observed, predicted, se, ci} =
  Transpose[(SinglePredictionCITable /. regress)[[1]]];\
\>", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S6.3.1"],

Cell["\<\
You can now plot the predicted responses against the residuals for \
diagnostic purposes. \
\>", "MathCaption",
  CellTags->{"S6.3.1", "1.25"}],

Cell[CellGroupData[{

Cell["ListPlot[Transpose[{predicted, errors}]]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S6.3.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.48869 0.00553923 0.292555 0.0242534 [
[.06523 .28005 -9 -9 ]
[.06523 .28005 9 0 ]
[.20371 .28005 -9 -9 ]
[.20371 .28005 9 0 ]
[.34219 .28005 -9 -9 ]
[.34219 .28005 9 0 ]
[.48067 .28005 -9 -9 ]
[.48067 .28005 9 0 ]
[.61916 .28005 -9 -9 ]
[.61916 .28005 9 0 ]
[.75764 .28005 -9 -9 ]
[.75764 .28005 9 0 ]
[.89612 .28005 -9 -9 ]
[.89612 .28005 9 0 ]
[.02504 .05002 -18 -4.5 ]
[.02504 .05002 0 4.5 ]
[.02504 .17129 -12 -4.5 ]
[.02504 .17129 0 4.5 ]
[.02504 .41382 -6 -4.5 ]
[.02504 .41382 0 4.5 ]
[.02504 .53509 -12 -4.5 ]
[.02504 .53509 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.06523 .29255 m
.06523 .2988 L
s
[(100)] .06523 .28005 0 1 Mshowa
.20371 .29255 m
.20371 .2988 L
s
[(125)] .20371 .28005 0 1 Mshowa
.34219 .29255 m
.34219 .2988 L
s
[(150)] .34219 .28005 0 1 Mshowa
.48067 .29255 m
.48067 .2988 L
s
[(175)] .48067 .28005 0 1 Mshowa
.61916 .29255 m
.61916 .2988 L
s
[(200)] .61916 .28005 0 1 Mshowa
.75764 .29255 m
.75764 .2988 L
s
[(225)] .75764 .28005 0 1 Mshowa
.89612 .29255 m
.89612 .2988 L
s
[(250)] .89612 .28005 0 1 Mshowa
.125 Mabswid
.09293 .29255 m
.09293 .2963 L
s
.12063 .29255 m
.12063 .2963 L
s
.14832 .29255 m
.14832 .2963 L
s
.17602 .29255 m
.17602 .2963 L
s
.23141 .29255 m
.23141 .2963 L
s
.25911 .29255 m
.25911 .2963 L
s
.2868 .29255 m
.2868 .2963 L
s
.3145 .29255 m
.3145 .2963 L
s
.36989 .29255 m
.36989 .2963 L
s
.39759 .29255 m
.39759 .2963 L
s
.42528 .29255 m
.42528 .2963 L
s
.45298 .29255 m
.45298 .2963 L
s
.50837 .29255 m
.50837 .2963 L
s
.53607 .29255 m
.53607 .2963 L
s
.56376 .29255 m
.56376 .2963 L
s
.59146 .29255 m
.59146 .2963 L
s
.64685 .29255 m
.64685 .2963 L
s
.67455 .29255 m
.67455 .2963 L
s
.70224 .29255 m
.70224 .2963 L
s
.72994 .29255 m
.72994 .2963 L
s
.78533 .29255 m
.78533 .2963 L
s
.81303 .29255 m
.81303 .2963 L
s
.84072 .29255 m
.84072 .2963 L
s
.86842 .29255 m
.86842 .2963 L
s
.00984 .29255 m
.00984 .2963 L
s
.92381 .29255 m
.92381 .2963 L
s
.95151 .29255 m
.95151 .2963 L
s
.97921 .29255 m
.97921 .2963 L
s
.25 Mabswid
0 .29255 m
1 .29255 L
s
.03754 .05002 m
.04379 .05002 L
s
[(-10)] .02504 .05002 1 0 Mshowa
.03754 .17129 m
.04379 .17129 L
s
[(-5)] .02504 .17129 1 0 Mshowa
.03754 .41382 m
.04379 .41382 L
s
[(5)] .02504 .41382 1 0 Mshowa
.03754 .53509 m
.04379 .53509 L
s
[(10)] .02504 .53509 1 0 Mshowa
.125 Mabswid
.03754 .07427 m
.04129 .07427 L
s
.03754 .09853 m
.04129 .09853 L
s
.03754 .12278 m
.04129 .12278 L
s
.03754 .14703 m
.04129 .14703 L
s
.03754 .19554 m
.04129 .19554 L
s
.03754 .21979 m
.04129 .21979 L
s
.03754 .24405 m
.04129 .24405 L
s
.03754 .2683 m
.04129 .2683 L
s
.03754 .31681 m
.04129 .31681 L
s
.03754 .34106 m
.04129 .34106 L
s
.03754 .36532 m
.04129 .36532 L
s
.03754 .38957 m
.04129 .38957 L
s
.03754 .43808 m
.04129 .43808 L
s
.03754 .46233 m
.04129 .46233 L
s
.03754 .48658 m
.04129 .48658 L
s
.03754 .51084 m
.04129 .51084 L
s
.03754 .02577 m
.04129 .02577 L
s
.03754 .00151 m
.04129 .00151 L
s
.03754 .55934 m
.04129 .55934 L
s
.03754 .5836 m
.04129 .5836 L
s
.03754 .60785 m
.04129 .60785 L
s
.25 Mabswid
.03754 0 m
.03754 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.008 w
.02381 .23139 Mdot
.06546 .21879 Mdot
.15076 .08786 Mdot
.22085 .19325 Mdot
.26234 .44817 Mdot
.35266 .24673 Mdot
.42639 .4575 Mdot
.48725 .60332 Mdot
.63903 .42383 Mdot
.97619 .01472 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S6.3.1"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S6.3.1"]
}, Open  ]],

Cell[TextData[{
  "Here the predicted responses and lower and upper confidence limits are \
paired with the corresponding ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " values. "
}], "MathCaption",
  CellTags->{"S6.3.1", "1.26"}],

Cell["\<\
(xval = Map[First, data];
predicted = Transpose[{xval, predicted}];
lowerCI = Transpose[{xval, Map[First, ci]}];
upperCI = Transpose[{xval, Map[Last, ci]}]);\
\>", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S6.3.1"],

Cell[TextData[{
  "This loads the function ",
  StyleBox["MultipleListPlot", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S6.3.1", "1.27"}],

Cell["<<Graphics`MultipleListPlot`", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S6.3.1"],

Cell[TextData[{
  "This displays the raw data, fitted curve, and the ",
  Cell[BoxData[
      \(TraditionalForm\`95  %\)], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " confidence intervals for the predicted responses of single observations. \
"
}], "MathCaption",
  CellTags->{"S6.3.1", "1.28"}],

Cell[CellGroupData[{

Cell["\<\
MultipleListPlot[
 data, predicted, lowerCI, upperCI,
 SymbolShape -> {PlotSymbol[Diamond], None, None,
 None},
 PlotJoined -> {False, True, True, True},
 PlotStyle -> {Automatic, Automatic,
 Dashing[{.05, .05}], Dashing[{.05, .05}]}
]\
\>", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S6.3.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 2.71334 -0.180554 0.00272184 [
[.15948 .05191 -12 -9 ]
[.15948 .05191 12 0 ]
[.29514 .05191 -9 -9 ]
[.29514 .05191 9 0 ]
[.43081 .05191 -12 -9 ]
[.43081 .05191 12 0 ]
[.56648 .05191 -9 -9 ]
[.56648 .05191 9 0 ]
[.70214 .05191 -12 -9 ]
[.70214 .05191 12 0 ]
[.83781 .05191 -9 -9 ]
[.83781 .05191 9 0 ]
[.97348 .05191 -12 -9 ]
[.97348 .05191 12 0 ]
[.01131 .09163 -18 -4.5 ]
[.01131 .09163 0 4.5 ]
[.01131 .22772 -18 -4.5 ]
[.01131 .22772 0 4.5 ]
[.01131 .36381 -18 -4.5 ]
[.01131 .36381 0 4.5 ]
[.01131 .49991 -18 -4.5 ]
[.01131 .49991 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.15948 .06441 m
.15948 .07066 L
s
[(0.05)] .15948 .05191 0 1 Mshowa
.29514 .06441 m
.29514 .07066 L
s
[(0.1)] .29514 .05191 0 1 Mshowa
.43081 .06441 m
.43081 .07066 L
s
[(0.15)] .43081 .05191 0 1 Mshowa
.56648 .06441 m
.56648 .07066 L
s
[(0.2)] .56648 .05191 0 1 Mshowa
.70214 .06441 m
.70214 .07066 L
s
[(0.25)] .70214 .05191 0 1 Mshowa
.83781 .06441 m
.83781 .07066 L
s
[(0.3)] .83781 .05191 0 1 Mshowa
.97348 .06441 m
.97348 .07066 L
s
[(0.35)] .97348 .05191 0 1 Mshowa
.125 Mabswid
.05094 .06441 m
.05094 .06816 L
s
.07808 .06441 m
.07808 .06816 L
s
.10521 .06441 m
.10521 .06816 L
s
.13234 .06441 m
.13234 .06816 L
s
.18661 .06441 m
.18661 .06816 L
s
.21374 .06441 m
.21374 .06816 L
s
.24088 .06441 m
.24088 .06816 L
s
.26801 .06441 m
.26801 .06816 L
s
.32228 .06441 m
.32228 .06816 L
s
.34941 .06441 m
.34941 .06816 L
s
.37654 .06441 m
.37654 .06816 L
s
.40368 .06441 m
.40368 .06816 L
s
.45794 .06441 m
.45794 .06816 L
s
.48508 .06441 m
.48508 .06816 L
s
.51221 .06441 m
.51221 .06816 L
s
.53934 .06441 m
.53934 .06816 L
s
.59361 .06441 m
.59361 .06816 L
s
.62074 .06441 m
.62074 .06816 L
s
.64788 .06441 m
.64788 .06816 L
s
.67501 .06441 m
.67501 .06816 L
s
.72928 .06441 m
.72928 .06816 L
s
.75641 .06441 m
.75641 .06816 L
s
.78354 .06441 m
.78354 .06816 L
s
.81068 .06441 m
.81068 .06816 L
s
.86494 .06441 m
.86494 .06816 L
s
.89208 .06441 m
.89208 .06816 L
s
.91921 .06441 m
.91921 .06816 L
s
.94634 .06441 m
.94634 .06816 L
s
.25 Mabswid
0 .06441 m
1 .06441 L
s
.02381 .09163 m
.03006 .09163 L
s
[(100)] .01131 .09163 1 0 Mshowa
.02381 .22772 m
.03006 .22772 L
s
[(150)] .01131 .22772 1 0 Mshowa
.02381 .36381 m
.03006 .36381 L
s
[(200)] .01131 .36381 1 0 Mshowa
.02381 .49991 m
.03006 .49991 L
s
[(250)] .01131 .49991 1 0 Mshowa
.125 Mabswid
.02381 .11885 m
.02756 .11885 L
s
.02381 .14607 m
.02756 .14607 L
s
.02381 .17329 m
.02756 .17329 L
s
.02381 .2005 m
.02756 .2005 L
s
.02381 .25494 m
.02756 .25494 L
s
.02381 .28216 m
.02756 .28216 L
s
.02381 .30938 m
.02756 .30938 L
s
.02381 .3366 m
.02756 .3366 L
s
.02381 .39103 m
.02756 .39103 L
s
.02381 .41825 m
.02756 .41825 L
s
.02381 .44547 m
.02756 .44547 L
s
.02381 .47269 m
.02756 .47269 L
s
.02381 .03719 m
.02756 .03719 L
s
.02381 .00998 m
.02756 .00998 L
s
.02381 .52712 m
.02756 .52712 L
s
.02381 .55434 m
.02756 .55434 L
s
.02381 .58156 m
.02756 .58156 L
s
.02381 .60878 m
.02756 .60878 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.0001 w
.17304 .06441 -1.875 0 Mabsadd m
.17304 .06441 0 2.5 Mabsadd L
.17304 .06441 1.875 0 Mabsadd L
.17304 .06441 0 -2.5 Mabsadd L
.17304 .06441 -1.875 0 Mabsadd L closepath F
.27072 .08346 -1.875 0 Mabsadd m
.27072 .08346 0 2.5 Mabsadd L
.27072 .08346 1.875 0 Mabsadd L
.27072 .08346 0 -2.5 Mabsadd L
.27072 .08346 -1.875 0 Mabsadd L closepath F
.39825 .11068 -1.875 0 Mabsadd m
.39825 .11068 0 2.5 Mabsadd L
.39825 .11068 1.875 0 Mabsadd L
.39825 .11068 0 -2.5 Mabsadd L
.39825 .11068 -1.875 0 Mabsadd L closepath F
.47694 .15695 -1.875 0 Mabsadd m
.47694 .15695 0 2.5 Mabsadd L
.47694 .15695 1.875 0 Mabsadd L
.47694 .15695 0 -2.5 Mabsadd L
.47694 .15695 -1.875 0 Mabsadd L closepath F
.51764 .20595 -1.875 0 Mabsadd m
.51764 .20595 0 2.5 Mabsadd L
.51764 .20595 1.875 0 Mabsadd L
.51764 .20595 0 -2.5 Mabsadd L
.51764 .20595 -1.875 0 Mabsadd L closepath F
.59632 .22772 -1.875 0 Mabsadd m
.59632 .22772 0 2.5 Mabsadd L
.59632 .22772 1.875 0 Mabsadd L
.59632 .22772 0 -2.5 Mabsadd L
.59632 .22772 -1.875 0 Mabsadd L closepath F
.6533 .2876 -1.875 0 Mabsadd m
.6533 .2876 0 2.5 Mabsadd L
.6533 .2876 1.875 0 Mabsadd L
.6533 .2876 0 -2.5 Mabsadd L
.6533 .2876 -1.875 0 Mabsadd L closepath F
.69672 .33387 -1.875 0 Mabsadd m
.69672 .33387 0 2.5 Mabsadd L
.69672 .33387 1.875 0 Mabsadd L
.69672 .33387 0 -2.5 Mabsadd L
.69672 .33387 -1.875 0 Mabsadd L closepath F
.7944 .38831 -1.875 0 Mabsadd m
.7944 .38831 0 2.5 Mabsadd L
.7944 .38831 1.875 0 Mabsadd L
.7944 .38831 0 -2.5 Mabsadd L
.7944 .38831 -1.875 0 Mabsadd L closepath F
.97619 .50807 -1.875 0 Mabsadd m
.97619 .50807 0 2.5 Mabsadd L
.97619 .50807 1.875 0 Mabsadd L
.97619 .50807 0 -2.5 Mabsadd L
.97619 .50807 -1.875 0 Mabsadd L closepath F
.001 w
.17304 .07128 m
.27072 .09174 L
.39825 .13366 L
.47694 .1681 L
.51764 .18848 L
.59632 .23287 L
.6533 .26909 L
.69672 .299 L
.7944 .37358 L
.97619 .53925 L
s
[ .05 .05 ] 0 setdash
.17304 .01472 m
.27072 .03598 L
.39825 .07922 L
.47694 .11444 L
.51764 .13514 L
.59632 .17983 L
.6533 .21591 L
.69672 .24545 L
.7944 .3181 L
.97619 .47519 L
s
.17304 .12784 m
.27072 .14751 L
.39825 .18809 L
.47694 .22176 L
.51764 .24183 L
.59632 .2859 L
.6533 .32227 L
.69672 .35255 L
.7944 .42905 L
.97619 .60332 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S6.3.1"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S6.3.1"]
}, Open  ]],

Cell[TextData[{
  "The functions ",
  StyleBox["Show", "MR"],
  " and ",
  StyleBox["Graphics", "MR"],
  " may be used to display an ",
  StyleBox["Ellipsoid", "MR"],
  " object. This is the joint ",
  Cell[BoxData[
      \(TraditionalForm\`95  %\)], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " confidence region of the regression parameters. "
}], "MathCaption",
  CellTags->{"S6.3.1", "1.29"}],

Cell[CellGroupData[{

Cell["\<\
Show[Graphics[ParameterConfidenceRegion /. regress],
  Axes -> True, AxesLabel -> {\"Constant\",\"x Squared\"}]\
\>", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S6.3.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-2.83913 0.0378612 -1.60421 0.00133728 [
[.18976 -0.01197 -6 -9 ]
[.18976 -0.01197 6 0 ]
[.37907 -0.01197 -6 -9 ]
[.37907 -0.01197 6 0 ]
[.56838 -0.01197 -6 -9 ]
[.56838 -0.01197 6 0 ]
[.75768 -0.01197 -6 -9 ]
[.75768 -0.01197 6 0 ]
[.94699 -0.01197 -9 -9 ]
[.94699 -0.01197 9 0 ]
[1.025 .00053 0 -4.90625 ]
[1.025 .00053 52 4.90625 ]
[-0.01204 .13426 -24 -4.5 ]
[-0.01204 .13426 0 4.5 ]
[-0.01204 .26798 -24 -4.5 ]
[-0.01204 .26798 0 4.5 ]
[-0.01204 .40171 -24 -4.5 ]
[-0.01204 .40171 0 4.5 ]
[-0.01204 .53544 -24 -4.5 ]
[-0.01204 .53544 0 4.5 ]
[.00046 .64303 -29 0 ]
[.00046 .64303 29 9.8125 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.18976 .00053 m
.18976 .00678 L
s
[(80)] .18976 -0.01197 0 1 Mshowa
.37907 .00053 m
.37907 .00678 L
s
[(85)] .37907 -0.01197 0 1 Mshowa
.56838 .00053 m
.56838 .00678 L
s
[(90)] .56838 -0.01197 0 1 Mshowa
.75768 .00053 m
.75768 .00678 L
s
[(95)] .75768 -0.01197 0 1 Mshowa
.94699 .00053 m
.94699 .00678 L
s
[(100)] .94699 -0.01197 0 1 Mshowa
.125 Mabswid
.03832 .00053 m
.03832 .00428 L
s
.07618 .00053 m
.07618 .00428 L
s
.11404 .00053 m
.11404 .00428 L
s
.1519 .00053 m
.1519 .00428 L
s
.22763 .00053 m
.22763 .00428 L
s
.26549 .00053 m
.26549 .00428 L
s
.30335 .00053 m
.30335 .00428 L
s
.34121 .00053 m
.34121 .00428 L
s
.41693 .00053 m
.41693 .00428 L
s
.45479 .00053 m
.45479 .00428 L
s
.49265 .00053 m
.49265 .00428 L
s
.53052 .00053 m
.53052 .00428 L
s
.60624 .00053 m
.60624 .00428 L
s
.6441 .00053 m
.6441 .00428 L
s
.68196 .00053 m
.68196 .00428 L
s
.71982 .00053 m
.71982 .00428 L
s
.79554 .00053 m
.79554 .00428 L
s
.83341 .00053 m
.83341 .00428 L
s
.87127 .00053 m
.87127 .00428 L
s
.90913 .00053 m
.90913 .00428 L
s
.98485 .00053 m
.98485 .00428 L
s
.25 Mabswid
0 .00053 m
1 .00053 L
s
gsave
1.025 .00053 -61 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Constant) show
111.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.00046 .13426 m
.00671 .13426 L
s
[(1300)] -0.01204 .13426 1 0 Mshowa
.00046 .26798 m
.00671 .26798 L
s
[(1400)] -0.01204 .26798 1 0 Mshowa
.00046 .40171 m
.00671 .40171 L
s
[(1500)] -0.01204 .40171 1 0 Mshowa
.00046 .53544 m
.00671 .53544 L
s
[(1600)] -0.01204 .53544 1 0 Mshowa
.125 Mabswid
.00046 .02727 m
.00421 .02727 L
s
.00046 .05402 m
.00421 .05402 L
s
.00046 .08076 m
.00421 .08076 L
s
.00046 .10751 m
.00421 .10751 L
s
.00046 .161 m
.00421 .161 L
s
.00046 .18775 m
.00421 .18775 L
s
.00046 .21449 m
.00421 .21449 L
s
.00046 .24124 m
.00421 .24124 L
s
.00046 .29473 m
.00421 .29473 L
s
.00046 .32148 m
.00421 .32148 L
s
.00046 .34822 m
.00421 .34822 L
s
.00046 .37497 m
.00421 .37497 L
s
.00046 .42846 m
.00421 .42846 L
s
.00046 .4552 m
.00421 .4552 L
s
.00046 .48195 m
.00421 .48195 L
s
.00046 .50869 m
.00421 .50869 L
s
.00046 .56219 m
.00421 .56219 L
s
.00046 .58893 m
.00421 .58893 L
s
.00046 .61568 m
.00421 .61568 L
s
.25 Mabswid
.00046 0 m
.00046 .61803 L
s
gsave
.00046 .64303 -90 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(x) show
75.000 11.250 moveto
(Squared) show
117.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.87963 .01472 m
.88147 .01472 L
.88313 .01474 L
.88502 .01478 L
.8868 .01482 L
.88992 .01493 L
.89326 .01509 L
.89686 .01532 L
.9006 .01562 L
.9071 .01631 L
.91352 .01723 L
.91928 .01828 L
.93141 .02134 L
.9372 .0233 L
.94235 .02541 L
.95106 .02997 L
.95902 .03575 L
.96287 .03941 L
.96601 .04307 L
.96855 .04666 L
.97088 .05078 L
.9727 .05488 L
.97404 .05883 L
.97497 .06255 L
.97539 .06472 L
.97569 .06679 L
.97583 .06793 L
.97594 .06901 L
.97602 .07001 L
.97609 .07108 L
.97615 .07224 L
.97618 .07334 L
.97619 .07452 L
.97619 .0752 L
.97618 .07584 L
.97615 .077 L
.9761 .07824 L
.97603 .07943 L
.97594 .08052 L
.97567 .08322 L
.97533 .08581 L
.97438 .09109 L
.97295 .097 L
.96938 .10802 L
.96495 .11867 L
.95199 .14262 L
.93227 .17097 L
.87818 .23109 L
.80884 .29255 L
.72003 .35862 L
Mistroke
.62391 .41994 L
.5259 .47404 L
.42048 .52369 L
.32261 .56153 L
.27548 .57651 L
.22758 .5891 L
.20632 .59369 L
.18487 .59757 L
.16741 .60011 L
.15856 .60115 L
.14922 .60205 L
.14446 .60242 L
.14012 .60271 L
.13613 .60293 L
.13179 .60312 L
.12994 .60318 L
.12797 .60323 L
.12613 .60327 L
.12445 .6033 L
.12267 .60331 L
.12074 .60332 L
.11875 .60331 L
.11691 .60329 L
.1149 .60325 L
.11377 .60323 L
.11274 .6032 L
.10888 .60305 L
.10544 .60287 L
.10187 .60262 L
.09468 .60193 L
.08716 .60091 L
.08055 .59972 L
.07461 .59837 L
.06429 .59527 L
.05445 .59111 L
.04525 .58563 L
.03861 .58012 L
.03268 .5732 L
.03027 .56941 L
.02809 .56508 L
.02645 .56077 L
.0258 .55863 L
.02528 .55663 L
.02486 .55464 L
.02447 .55244 L
.0243 .55122 L
.02417 .55007 L
.02405 .5489 L
.02396 .54778 L
.0239 .54683 L
Mistroke
.02385 .54579 L
.02382 .54463 L
.02381 .54356 L
.02382 .54244 L
.02384 .5412 L
.02389 .54003 L
.02395 .53893 L
.02405 .53762 L
.02418 .53619 L
.02448 .53357 L
.0253 .52854 L
.02666 .52249 L
.0283 .51675 L
.03244 .50537 L
.03749 .49425 L
.0532 .46732 L
.098 .41142 L
.16539 .34701 L
.24645 .28309 L
.33577 .22272 L
.43859 .16269 L
.54051 .11169 L
.6368 .07116 L
.68806 .05291 L
.73288 .03912 L
.77356 .02867 L
.79397 .02429 L
.81483 .02051 L
.83379 .01778 L
.85016 .01604 L
.85775 .01546 L
.86166 .01522 L
.86575 .01502 L
.86926 .01488 L
.87124 .01482 L
.87307 .01478 L
.87474 .01475 L
.87626 .01473 L
.87799 .01472 L
.87963 .01472 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S6.3.1"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S6.3.1"]
}, Open  ]],

Cell[TextData[{
  "This package provides numerous diagnostics for evaluating the data and the \
fit. The ",
  StyleBox["HatDiagonal", "MR"],
  " gives the leverage of each point, measuring whether each observation of \
the independent variables is unusual. ",
  StyleBox["CookD", "MR"],
  " and ",
  StyleBox["PredictedResponseDelta", "MR"],
  " are influence diagnostics, simultaneously measuring whether the \
independent variables and the response variable are unusual. Unfortunately, \
these diagnostics are primarily useful in detecting single outliers. In \
particular, the diagnostics may indicate a single outlier, but deleting that \
observation and recomputing the diagnostics may indicate others. All of these \
diagnostics are subject to this masking effect. They are described in greater \
detail in ",
  StyleBox["Regression Diagnostics: Identifying Influential Data and Sources \
of Collinearity", "TI"],
  ", by D. A. Belsley, E. Kuh, and R. E. Welsch (John Wiley & Sons, 1980), \
and \[OpenCurlyDoubleQuote]Detection of influential observations in linear \
regression\[CloseCurlyDoubleQuote], by R. D. Cook, ",
  StyleBox["Technometrics", "TI"],
  ", 19, 1977. "
}], "Text",
  CellTags->{"S6.3.1", "1.30"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["HatDiagonal", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[{
              StyleBox["diagonal of the hat matrix ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      StyleBox["X",
                        "TI"], 
                      SuperscriptBox[
                        RowBox[{"(", 
                          RowBox[{
                            SuperscriptBox[
                              StyleBox["X",
                                "TI"], 
                              StyleBox["T",
                                "TI"]], 
                            StyleBox["X",
                              "TI"]}], ")"}], \(-1\)], 
                      SuperscriptBox[
                        StyleBox["X",
                          "TI"], 
                        StyleBox["T",
                          "TI"]]}], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[", where ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    StyleBox["X",
                      "TI"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[" is the ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    StyleBox["n",
                      "TI"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[" by ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    StyleBox["p",
                      "TI"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[" (weighted) design matrix ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[{
              StyleBox["JackknifedVariance", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[{
              StyleBox["{", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["v",
                        "TI"], "1"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[", \[Ellipsis] , ", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["v",
                        "TI"], 
                      StyleBox["n",
                        "TI"]], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox["}", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[", where ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["v",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[
              " is the estimated error variance computed using the data with \
the ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    StyleBox["i",
                      "TI"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[" case deleted ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[{
              StyleBox["StandardizedResiduals", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[StyleBox[
            
            "fit residuals scaled by their standard errors, computed using \
the estimated error variance",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[{
              StyleBox["StudentizedResiduals", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[StyleBox[
            "fit residuals scaled by their standard errors, computed using \
the jackknifed estimated error variances",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[{
              StyleBox["CookD", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[{
              StyleBox["{", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["d",
                        "TI"], "1"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[", \[Ellipsis] , ", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["d",
                        "TI"], 
                      StyleBox["n",
                        "TI"]], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox["}", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[", where ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["d",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[
              " is Cook\[CloseCurlyQuote]s squared distance diagnostic for \
evaluating whether the ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    StyleBox["i",
                      "TI"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[" case is an outlier ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[{
              StyleBox["PredictedResponseDelta", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[{
              StyleBox["{", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["d",
                        "TI"], "1"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[", \[Ellipsis] , ", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["d",
                        "TI"], 
                      StyleBox["n",
                        "TI"]], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox["}", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[", where ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["d",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[
              " is Kuh and Welsch\[CloseCurlyQuote]s DFFITS diagnostic giving \
the standardized signed difference in the ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    StyleBox["i",
                      "TI"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[
              " predicted response, between using all the data and the data \
with the ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    StyleBox["i",
                      "TI"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[" case deleted ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[{
              StyleBox["BestFitParametersDelta", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[{
              StyleBox["{{", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["d",
                        "TI"], "11"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[", \[Ellipsis] , ", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["d",
                        "TI"], 
                      RowBox[{"1", 
                        StyleBox["p",
                          "TI"]}]], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox["}, \[Ellipsis] , {", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["d",
                        "TI"], 
                      RowBox[{
                        StyleBox["n",
                          "TI"], "1"}]], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[", \[Ellipsis] , ", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["d",
                        "TI"], 
                      StyleBox[\(n  p\),
                        "TI"]], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox["}}", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[", where ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["d",
                        "TI"], 
                      StyleBox[\(i  j\),
                        "TI"]], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[
              " is Kuh and Welsch\[CloseCurlyQuote]s DFBETAS diagnostic \
giving the standardized signed difference in the ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    StyleBox["j",
                      "TI"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[
              " parameter estimate, between using all the data and the data \
with the ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    StyleBox["i",
                      "TI"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[" case deleted ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[{
              StyleBox["CovarianceMatrixDetRatio", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[{
              StyleBox["{", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["r",
                        "TI"], "1"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[", \[Ellipsis] , ", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["r",
                        "TI"], 
                      StyleBox["n",
                        "TI"]], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox["}", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[", where ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["r",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[
              " is Kuh and Welsch\[CloseCurlyQuote]s COVRATIO diagnostic \
giving the ratio of the determinant of the parameter covariance matrix \
computed using the data with the ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    StyleBox["i",
                      "TI"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[
              " case deleted, to the determinant of the parameter covariance \
matrix computed using the original data ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S6.3.1"],

Cell["Diagnostics for detecting outliers.", "Caption",
  CellTags->"S6.3.1"],

Cell[TextData[{
  "Some diagnostics indicate the degree to which individual basis functions \
contribute to the fit, or whether the basis functions are involved in a \
collinear relationship. The sum of the elements in the ",
  StyleBox["SequentialSumOfSquares", "MR"],
  " vector gives the model sum of squares listed in the ",
  StyleBox["ANOVATable", "MR"],
  ". Each element corresponds to the increment in the model sum of squares \
obtained by sequentially adding each (nonconstant) basis function to the \
model. Each element in the ",
  StyleBox["PartialSumOfSquares", "MR"],
  " vector gives the increase in the model sum of squares due to adding the \
corresponding (nonconstant) basis function to a model consisting of all other \
basis functions. ",
  StyleBox["SequentialSumOfSquares", "MR"],
  " is useful in determining the degree of a univariate polynomial model, \
while ",
  StyleBox["PartialSumOfSquares", "MR"],
  " is useful in trimming a large set of predictors. ",
  StyleBox["VarianceInflation", "MR"],
  " or ",
  StyleBox["EigenstructureTable", "MR"],
  " may also be used for predictor set trimming. "
}], "Text",
  CellTags->{"S6.3.1", "1.31"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["PartialSumOfSquares", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[StyleBox[
            "a list giving the increase in the model sum of squares due to \
adding each nonconstant basis function to the model consisting of the \
remaining basis functions ",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[{
              StyleBox["SequentialSumOfSquares", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[StyleBox[
            "a list giving a partitioning of the model sum of squares, one \
element for each nonconstant basis function added sequentially to the model ",
              
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[{
              StyleBox["VarianceInflation", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[{
              StyleBox["{", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["v",
                        "TI"], "1"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[", \[Ellipsis] , ", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["v",
                        "TI"], 
                      StyleBox["p",
                        "TI"]], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox["}", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[", where ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["v",
                        "TI"], 
                      StyleBox["j",
                        "TI"]], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[
              " is the variance inflation factor associated with the ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    StyleBox["j",
                      "TI"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[" parameter ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[{
              StyleBox["EigenstructureTable", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[StyleBox[
            "table giving the eigenstructure of the correlation matrix of the \
nonconstant basis functions",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S6.3.1"],

Cell["\<\
Diagnostics for evaluating basis functions and detecting \
collinearity.\
\>", "Caption",
  CellTags->"S6.3.1"],

Cell[TextData[{
  "The Durbin\[Hyphen]Watson ",
  StyleBox["d",
    FontSlant->"Italic"],
  " statistic is used for testing the existence of a first\[Hyphen]order \
autoregressive process. The statistic takes on values between 0 and 4, with \
values near the middle of that range  indicating uncorrelated errors, an \
underlying assumption of the regression model. Critical values for the \
statistic vary with sample size, the number of parameters in the model, and \
the desired significance. These values can be found in published tables."
}], "Text",
  CellTags->{"S6.3.1", "1.32"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["DurbinWatsonD", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[{
              StyleBox["Durbin\[Hyphen]Watson ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    StyleBox["d",
                      "TI"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[" statistic",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S6.3.1"],

Cell["Correlated errors diagnostic.", "Caption",
  CellTags->"S6.3.1"],

Cell[TextData[{
  "Other statistics not mentioned here can be computed with the help of the \
catcher matrix. This matrix catches all the information the predictors have \
about the parameter vector. This matrix can be exported from ",
  StyleBox["Regress", "MR"],
  " by specifying ",
  StyleBox["CatcherMatrix", "MR"],
  " with the ",
  StyleBox["RegressionReport", "MR"],
  " option. "
}], "Text",
  CellTags->{"S6.3.1", "1.33"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["CatcherMatrix", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    StyleBox["p",
                      "TI"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[" by ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    StyleBox["n",
                      "TI"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[" matrix ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    StyleBox["C",
                      "TI"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[", where ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      StyleBox["C",
                        "TI"], "\[CenterDot]", 
                      StyleBox["y",
                        "TI"]}], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[" is the estimated parameter vector and ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    StyleBox["y",
                      "TI"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[" is the response vector ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S6.3.1"],

Cell["\<\
Matrix describing the parameter information provided by the \
predictors.\
\>", "Caption",
  CellTags->"S6.3.1"],

Cell[TextData[{
  "Frequently, linear regression is applied to an existing design matrix \
rather than the original data. A design matrix is a list containing the basis \
functions evaluated at the observed values of the independent variable. If \
your data are already in the form of a design matrix with a corresponding \
vector of response data, you can use ",
  StyleBox["DesignedRegress", "MR"],
  " for the same analyses as provided by ",
  StyleBox["Regress", "MR"],
  ". ",
  StyleBox["DesignMatrix", "MR"],
  " puts your data in the form of a design matrix. "
}], "Text",
  CellTags->{"S6.3.1", "1.34"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["DesignedRegress[", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->True}],
              StyleBox["designmatrix", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->True}],
              StyleBox[", ", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->True}],
              StyleBox["response", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->True}],
              StyleBox["]", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->True}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->True}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->True}], Cell[TextData[{
              StyleBox["fit the model represented by ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->True}],
              StyleBox["designmatrix", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->True}],
              StyleBox[" given the vector ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->True}],
              StyleBox["response", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->True}],
              StyleBox[" of response data ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->True}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->True}]},
          {Cell[TextData[{
              StyleBox["DesignMatrix[", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->True}],
              StyleBox["data", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->True}],
              StyleBox[", {", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->True}],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["f",
                        "TI"], "1"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[", ", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->True}],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["f",
                        "TI"], "2"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[", \[Ellipsis] }, ", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->True}],
              StyleBox["vars", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->True}],
              StyleBox["]", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->True}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->True}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->True}], Cell[TextData[{
              StyleBox[
              "give the design matrix for modeling the data as a linear \
combination of the functions ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->True}],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["f",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[" of variables ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->True}],
              StyleBox["vars", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->True}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->True}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->True}]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->True},
  CellTags->"S6.3.1"],

Cell["Functions for linear regression using a design matrix.", "Caption",
  CellTags->"S6.3.1"],

Cell[TextData[{
  StyleBox["DesignMatrix", "MR"],
  " takes the same arguments as ",
  StyleBox["Regress", "MR"],
  ". It can be used to get the necessary arguments for ",
  StyleBox["DesignedRegress", "MR"],
  ", or to check whether you correctly specified your basis functions. When \
you use ",
  StyleBox["DesignMatrix", "MR"],
  ", the constant term is always included in the model unless ",
  StyleBox["IncludeConstant -> False", "MR"],
  " is specified. Every option of ",
  StyleBox["Regress", "MR"],
  " except ",
  StyleBox["IncludeConstant", "MR"],
  " is accepted by ",
  StyleBox["DesignedRegress", "MR"],
  ". ",
  StyleBox["RegressionReportValues[DesignedRegress]", "MR"],
  " gives the values that may be included in the ",
  StyleBox["RegressionReport", "MR"],
  " list for the ",
  StyleBox["DesignedRegress", "MR"],
  " function. "
}], "Text",
  CellTags->{"S6.3.1", "1.35"}],

Cell["\<\
This is the design matrix used in the previous regression analysis. \
\
\>", "MathCaption",
  CellTags->{"S6.3.1", "1.36"}],

Cell[CellGroupData[{

Cell["mat = DesignMatrix[data, {1, x^2}, x]", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S6.3.1"],

Cell[BoxData[
    \({{1, 0.003025`}, {1, 0.008281`}, {1, 0.019044000000000002`}, {1, 
        0.027889000000000004`}, {1, 0.033124`}, {1, 0.044521`}, {1, 
        0.053824000000000004`}, {1, 0.061503999999999996`}, {1, 
        0.08065599999999999`}, {1, 0.12320099999999999`}}\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S6.3.1"]
}, Open  ]],

Cell["Here is the vector of observed responses. ", "MathCaption",
  CellTags->{"S6.3.1", "1.37"}],

Cell[CellGroupData[{

Cell["response = Map[Last, data]", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S6.3.1"],

Cell[BoxData[
    \({90, 97, 107, 124, 142, 150, 172, 189, 209, 253}\)], "Output",
  CellLabel->"Out[15]= ",
  CellTags->"S6.3.1"]
}, Open  ]],

Cell[TextData[{
  "The result of ",
  StyleBox["DesignedRegress", "MR"],
  " is identical to that of ",
  StyleBox["Regress", "MR"],
  ". Note that the predictor names that were specified for the output appear \
in the ",
  StyleBox["ParameterTable", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S6.3.1", "1.38"}],

Cell[CellGroupData[{

Cell["\<\
DesignedRegress[mat, response, BasisNames ->
{\"Constant\",\"x Squared\"}] // Chop[#, 10^(-6)]&\
\>", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S6.3.1"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"ParameterTable", "\[Rule]", 
          TagBox[GridBox[{
                {"\<\"\"\>", "\<\"Estimate\"\>", "\<\"SE\"\>", \
"\<\"TStat\"\>", "\<\"PValue\"\>"},
                {"\<\"Constant\"\>", "88.19401431869144`", 
                  "4.211668077193906`", "20.940400027309884`", "0"},
                {"\<\"x Squared\"\>", "1430.6838233610401`", 
                  "73.69505688361104`", "19.41356562924654`", "0"}
                },
              RowSpacings->1,
              ColumnSpacings->3,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}],
            Function[ BoxForm`e$, 
              TableForm[ 
              BoxForm`e$, TableHeadings -> {{"Constant", "x Squared"}, {
                "Estimate", "SE", "TStat", "PValue"}}]]]}], 
        ",", \(RSquared \[Rule] 0.9792146532360267`\), 
        ",", \(AdjustedRSquared \[Rule] 0.9766164848905301`\), 
        ",", \(EstimatedVariance \[Rule] 64.91289776072271`\), ",", 
        RowBox[{"ANOVATable", "\[Rule]", 
          InterpretationBox[GridBox[{
                {"\<\"\"\>", "\<\"DF\"\>", "\<\"SumOfSq\"\>", \
"\<\"MeanSq\"\>", "\<\"FRatio\"\>", "\<\"PValue\"\>"},
                {"\<\"Model\"\>", "1", "24464.796817914215`", 
                  "24464.796817914215`", "376.88653044106275`", "0"},
                {"\<\"Error\"\>", "8", "519.3031820857817`", 
                  "64.91289776072271`", "\<\"\"\>", "\<\"\"\>"},
                {"\<\"Total\"\>", "9", 
                  "24984.1`14.7608577102269", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>"}
                },
              RowSpacings->1,
              ColumnSpacings->3,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}],
            
            TableForm[ {{1, 24464.7968179142, 24464.7968179142, 
              376.886530441063, 0}, {8, 519.303182085782, 64.9128977607227}, {
              9, 24984.1}}, TableHeadings -> {{"Model", "Error", "Total"}, {
              "DF", "SumOfSq", "MeanSq", "FRatio", "PValue"}}]]}]}], 
      "}"}]], "Output",
  CellLabel->"Out[16]= ",
  CellTags->"S6.3.1"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["DesignedRegress[", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["svd", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[", ", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["response", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["]", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[{
              StyleBox["fit the model represented by ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["svd", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[
              ", the singular value decomposition of the design matrix, given \
the vector ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["response", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" of response data ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S6.3.1"],

Cell["\<\
Linear regression using the singular value decomposition of the \
design matrix.\
\>", "Caption",
  CellTags->"S6.3.1"],

Cell[TextData[{
  StyleBox["DesignedRegress", "MR"],
  " will also accept the singular value decomposition of the design matrix. \
If the regression is not weighted, this approach will save recomputing the \
design matrix decomposition. "
}], "Text",
  CellTags->{"S6.3.1", "1.39"}],

Cell["\<\
This is the singular value decomposition of the design matrix. \
\
\>", "MathCaption",
  CellTags->{"S6.3.1", "1.40"}],

Cell["svd = SingularValueDecomposition[mat];", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S6.3.1"],

Cell["\<\
When several responses are of interest, this will save recomputing \
the design matrix decomposition. \
\>", "MathCaption",
  CellTags->{"S6.3.1", "1.41"}],

Cell[CellGroupData[{

Cell["\<\
DesignedRegress[svd, response,
 RegressionReport -> BestFitParameters]\
\>", "Input",
  CellLabel->"In[18]:= ",
  CellTags->"S6.3.1"],

Cell[BoxData[
    \({BestFitParameters \[Rule] {88.19401431869144`, 
          1430.683823361041`}}\)], "Output",
  CellLabel->"Out[18]= ",
  CellTags->"S6.3.1"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S6.3.1"->{
    Cell[1776, 53, 147, 6, 36, "Subsection",
      CellTags->{"S6.3.1", "1.1"}],
    Cell[1926, 61, 776, 20, 104, "Text",
      CellTags->{"S6.3.1", "1.2"}],
    Cell[2705, 83, 3340, 111, 81, "Text",
      CellTags->{"S6.3.1", "1.3"}],
    Cell[6048, 196, 2492, 77, 57, "Text",
      CellTags->{"S6.3.1", "1.4"}],
    Cell[8543, 275, 9637, 237, 142, "DefinitionBox",
      CellTags->"S6.3.1"],
    Cell[18183, 514, 99, 5, 15, "Caption",
      CellTags->"S6.3.1"],
    Cell[18285, 521, 711, 19, 75, "Text",
      CellTags->{"S6.3.1", "1.5"}],
    Cell[18999, 542, 529, 14, 40, "Text",
      CellTags->{"S6.3.1", "1.6"}],
    Cell[19531, 558, 7587, 179, 70, "DefinitionBox",
      CellTags->"S6.3.1"],
    Cell[27121, 739, 120, 5, 70, "Caption",
      CellTags->"S6.3.1"],
    Cell[27244, 746, 78, 1, 70, "MathCaption",
      CellTags->{"S6.3.1", "1.7"}],
    Cell[27325, 749, 94, 2, 70, "Input",
      CellTags->"S6.3.1"],
    Cell[27422, 753, 202, 5, 70, "MathCaption",
      CellTags->{"S6.3.1", "1.8"}],
    Cell[27627, 760, 221, 7, 70, "Input",
      CellTags->"S6.3.1"],
    Cell[27851, 769, 82, 1, 70, "MathCaption",
      CellTags->{"S6.3.1", "1.9"}],
    Cell[27958, 774, 86, 2, 70, "Input",
      CellTags->"S6.3.1"],
    Cell[28047, 778, 4106, 291, 70, 4033, 288, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S6.3.1"],
    Cell[32156, 1071, 177, 5, 70, "Output",
      CellTags->"S6.3.1"],
    Cell[32348, 1079, 917, 31, 70, "MathCaption",
      CellTags->{"S6.3.1", "1.10"}],
    Cell[33290, 1114, 134, 5, 70, "Input",
      CellTags->"S6.3.1"],
    Cell[33427, 1121, 2077, 44, 70, "Output",
      CellTags->"S6.3.1"],
    Cell[35519, 1168, 150, 5, 70, "MathCaption",
      CellTags->{"S6.3.1", "1.11"}],
    Cell[35694, 1177, 93, 2, 70, "Input",
      CellTags->"S6.3.1"],
    Cell[35790, 1181, 163, 4, 70, "Output",
      CellTags->"S6.3.1"],
    Cell[35968, 1188, 5181, 120, 70, "DefinitionBox3Col",
      CellTags->"S6.3.1"],
    Cell[41152, 1310, 105, 5, 70, "Caption",
      CellTags->"S6.3.1"],
    Cell[41260, 1317, 583, 17, 70, "Text",
      CellTags->{"S6.3.1", "1.12"}],
    Cell[41846, 1336, 1541, 49, 70, "Text",
      CellTags->{"S6.3.1", "1.13"}],
    Cell[43390, 1387, 896, 30, 70, "Text",
      CellTags->{"S6.3.1", "1.14"}],
    Cell[44289, 1419, 1071, 32, 70, "Text",
      CellTags->{"S6.3.1", "1.15"}],
    Cell[45363, 1453, 272, 9, 70, "Text",
      CellTags->{"S6.3.1", "1.16"}],
    Cell[45638, 1464, 515, 14, 70, "Text",
      CellTags->{"S6.3.1", "1.17"}],
    Cell[46156, 1480, 13081, 319, 70, "DefinitionBox",
      CellTags->"S6.3.1"],
    Cell[59240, 1801, 227, 7, 70, "Caption",
      CellTags->"S6.3.1"],
    Cell[59470, 1810, 1253, 29, 70, "Text",
      CellTags->{"S6.3.1", "1.18"}],
    Cell[60726, 1841, 3608, 109, 70, "Text",
      CellTags->{"S6.3.1", "1.19"}],
    Cell[64337, 1952, 1660, 43, 70, "Text",
      CellTags->{"S6.3.1", "1.20"}],
    Cell[66000, 1997, 634, 13, 70, "Text",
      CellTags->{"S6.3.1", "1.21"}],
    Cell[66637, 2012, 241, 5, 70, "MathCaption",
      CellTags->{"S6.3.1", "1.22"}],
    Cell[66903, 2021, 198, 7, 70, "Input",
      CellTags->"S6.3.1"],
    Cell[67104, 2030, 2843, 57, 70, "Output",
      CellTags->"S6.3.1"],
    Cell[69962, 2090, 116, 2, 70, "MathCaption",
      CellTags->{"S6.3.1", "1.23"}],
    Cell[70103, 2096, 96, 2, 70, "Input",
      CellTags->"S6.3.1"],
    Cell[70202, 2100, 335, 7, 70, "Output",
      CellTags->"S6.3.1"],
    Cell[70552, 2110, 213, 5, 70, "MathCaption",
      CellTags->{"S6.3.1", "1.24"}],
    Cell[70768, 2117, 159, 5, 70, "Input",
      CellTags->"S6.3.1"],
    Cell[70930, 2124, 153, 4, 70, "MathCaption",
      CellTags->{"S6.3.1", "1.25"}],
    Cell[71108, 2132, 104, 2, 70, "Input",
      CellTags->"S6.3.1"],
    Cell[71215, 2136, 3860, 276, 70, 3787, 273, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S6.3.1"],
    Cell[75078, 2414, 177, 5, 70, "Output",
      CellTags->"S6.3.1"],
    Cell[75270, 2422, 343, 10, 70, "MathCaption",
      CellTags->{"S6.3.1", "1.26"}],
    Cell[75616, 2434, 230, 7, 70, "Input",
      CellTags->"S6.3.1"],
    Cell[75849, 2443, 141, 5, 70, "MathCaption",
      CellTags->{"S6.3.1", "1.27"}],
    Cell[75993, 2450, 93, 2, 70, "Input",
      CellTags->"S6.3.1"],
    Cell[76089, 2454, 319, 8, 70, "MathCaption",
      CellTags->{"S6.3.1", "1.28"}],
    Cell[76433, 2466, 308, 11, 70, "Input",
      CellTags->"S6.3.1"],
    Cell[76744, 2479, 5825, 342, 70, 5752, 339, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S6.3.1"],
    Cell[82572, 2823, 178, 5, 70, "Output",
      CellTags->"S6.3.1"],
    Cell[82765, 2831, 420, 13, 70, "MathCaption",
      CellTags->{"S6.3.1", "1.29"}],
    Cell[83210, 2848, 184, 5, 70, "Input",
      CellTags->"S6.3.1"],
    Cell[83397, 2855, 8225, 472, 70, 8152, 469, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S6.3.1"],
    Cell[91625, 3329, 178, 5, 70, "Output",
      CellTags->"S6.3.1"],
    Cell[91818, 3337, 1223, 24, 70, "Text",
      CellTags->{"S6.3.1", "1.30"}],
    Cell[93044, 3363, 19557, 471, 70, "DefinitionBox",
      CellTags->"S6.3.1"],
    Cell[112604, 3836, 76, 1, 70, "Caption",
      CellTags->"S6.3.1"],
    Cell[112683, 3839, 1172, 24, 70, "Text",
      CellTags->{"S6.3.1", "1.31"}],
    Cell[113858, 3865, 4926, 118, 70, "DefinitionBox",
      CellTags->"S6.3.1"],
    Cell[118787, 3985, 121, 4, 70, "Caption",
      CellTags->"S6.3.1"],
    Cell[118911, 3991, 586, 11, 70, "Text",
      CellTags->{"S6.3.1", "1.32"}],
    Cell[119500, 4004, 1160, 30, 70, "DefinitionBox",
      CellTags->"S6.3.1"],
    Cell[120663, 4036, 70, 1, 70, "Caption",
      CellTags->"S6.3.1"],
    Cell[120736, 4039, 432, 11, 70, "Text",
      CellTags->{"S6.3.1", "1.33"}],
    Cell[121171, 4052, 2525, 62, 70, "DefinitionBox",
      CellTags->"S6.3.1"],
    Cell[123699, 4116, 122, 4, 70, "Caption",
      CellTags->"S6.3.1"],
    Cell[123824, 4122, 612, 13, 70, "Text",
      CellTags->{"S6.3.1", "1.34"}],
    Cell[124439, 4137, 4470, 111, 70, "DefinitionBox",
      CellTags->"S6.3.1"],
    Cell[128912, 4250, 95, 1, 70, "Caption",
      CellTags->"S6.3.1"],
    Cell[129010, 4253, 894, 25, 70, "Text",
      CellTags->{"S6.3.1", "1.35"}],
    Cell[129907, 4280, 133, 4, 70, "MathCaption",
      CellTags->{"S6.3.1", "1.36"}],
    Cell[130065, 4288, 102, 2, 70, "Input",
      CellTags->"S6.3.1"],
    Cell[130170, 4292, 339, 6, 70, "Output",
      CellTags->"S6.3.1"],
    Cell[130524, 4301, 97, 1, 70, "MathCaption",
      CellTags->{"S6.3.1", "1.37"}],
    Cell[130646, 4306, 91, 2, 70, "Input",
      CellTags->"S6.3.1"],
    Cell[130740, 4310, 130, 3, 70, "Output",
      CellTags->"S6.3.1"],
    Cell[130885, 4316, 315, 10, 70, "MathCaption",
      CellTags->{"S6.3.1", "1.38"}],
    Cell[131225, 4330, 168, 5, 70, "Input",
      CellTags->"S6.3.1"],
    Cell[131396, 4337, 2145, 46, 70, "Output",
      CellTags->"S6.3.1"],
    Cell[133556, 4386, 1907, 48, 70, "DefinitionBox",
      CellTags->"S6.3.1"],
    Cell[135466, 4436, 129, 4, 70, "Caption",
      CellTags->"S6.3.1"],
    Cell[135598, 4442, 282, 6, 70, "Text",
      CellTags->{"S6.3.1", "1.39"}],
    Cell[135883, 4450, 128, 4, 70, "MathCaption",
      CellTags->{"S6.3.1", "1.40"}],
    Cell[136014, 4456, 103, 2, 70, "Input",
      CellTags->"S6.3.1"],
    Cell[136120, 4460, 165, 4, 70, "MathCaption",
      CellTags->{"S6.3.1", "1.41"}],
    Cell[136310, 4468, 143, 5, 70, "Input",
      CellTags->"S6.3.1"],
    Cell[136456, 4475, 161, 4, 70, "Output",
      CellTags->"S6.3.1"]},
  "1.1"->{
    Cell[1776, 53, 147, 6, 36, "Subsection",
      CellTags->{"S6.3.1", "1.1"}]},
  "1.2"->{
    Cell[1926, 61, 776, 20, 104, "Text",
      CellTags->{"S6.3.1", "1.2"}]},
  "1.3"->{
    Cell[2705, 83, 3340, 111, 81, "Text",
      CellTags->{"S6.3.1", "1.3"}]},
  "1.4"->{
    Cell[6048, 196, 2492, 77, 57, "Text",
      CellTags->{"S6.3.1", "1.4"}]},
  "1.5"->{
    Cell[18285, 521, 711, 19, 75, "Text",
      CellTags->{"S6.3.1", "1.5"}]},
  "1.6"->{
    Cell[18999, 542, 529, 14, 40, "Text",
      CellTags->{"S6.3.1", "1.6"}]},
  "1.7"->{
    Cell[27244, 746, 78, 1, 70, "MathCaption",
      CellTags->{"S6.3.1", "1.7"}]},
  "1.8"->{
    Cell[27422, 753, 202, 5, 70, "MathCaption",
      CellTags->{"S6.3.1", "1.8"}]},
  "1.9"->{
    Cell[27851, 769, 82, 1, 70, "MathCaption",
      CellTags->{"S6.3.1", "1.9"}]},
  "1.10"->{
    Cell[32348, 1079, 917, 31, 70, "MathCaption",
      CellTags->{"S6.3.1", "1.10"}]},
  "1.11"->{
    Cell[35519, 1168, 150, 5, 70, "MathCaption",
      CellTags->{"S6.3.1", "1.11"}]},
  "1.12"->{
    Cell[41260, 1317, 583, 17, 70, "Text",
      CellTags->{"S6.3.1", "1.12"}]},
  "1.13"->{
    Cell[41846, 1336, 1541, 49, 70, "Text",
      CellTags->{"S6.3.1", "1.13"}]},
  "1.14"->{
    Cell[43390, 1387, 896, 30, 70, "Text",
      CellTags->{"S6.3.1", "1.14"}]},
  "1.15"->{
    Cell[44289, 1419, 1071, 32, 70, "Text",
      CellTags->{"S6.3.1", "1.15"}]},
  "1.16"->{
    Cell[45363, 1453, 272, 9, 70, "Text",
      CellTags->{"S6.3.1", "1.16"}]},
  "1.17"->{
    Cell[45638, 1464, 515, 14, 70, "Text",
      CellTags->{"S6.3.1", "1.17"}]},
  "1.18"->{
    Cell[59470, 1810, 1253, 29, 70, "Text",
      CellTags->{"S6.3.1", "1.18"}]},
  "1.19"->{
    Cell[60726, 1841, 3608, 109, 70, "Text",
      CellTags->{"S6.3.1", "1.19"}]},
  "1.20"->{
    Cell[64337, 1952, 1660, 43, 70, "Text",
      CellTags->{"S6.3.1", "1.20"}]},
  "1.21"->{
    Cell[66000, 1997, 634, 13, 70, "Text",
      CellTags->{"S6.3.1", "1.21"}]},
  "1.22"->{
    Cell[66637, 2012, 241, 5, 70, "MathCaption",
      CellTags->{"S6.3.1", "1.22"}]},
  "1.23"->{
    Cell[69962, 2090, 116, 2, 70, "MathCaption",
      CellTags->{"S6.3.1", "1.23"}]},
  "1.24"->{
    Cell[70552, 2110, 213, 5, 70, "MathCaption",
      CellTags->{"S6.3.1", "1.24"}]},
  "1.25"->{
    Cell[70930, 2124, 153, 4, 70, "MathCaption",
      CellTags->{"S6.3.1", "1.25"}]},
  "1.26"->{
    Cell[75270, 2422, 343, 10, 70, "MathCaption",
      CellTags->{"S6.3.1", "1.26"}]},
  "1.27"->{
    Cell[75849, 2443, 141, 5, 70, "MathCaption",
      CellTags->{"S6.3.1", "1.27"}]},
  "1.28"->{
    Cell[76089, 2454, 319, 8, 70, "MathCaption",
      CellTags->{"S6.3.1", "1.28"}]},
  "1.29"->{
    Cell[82765, 2831, 420, 13, 70, "MathCaption",
      CellTags->{"S6.3.1", "1.29"}]},
  "1.30"->{
    Cell[91818, 3337, 1223, 24, 70, "Text",
      CellTags->{"S6.3.1", "1.30"}]},
  "1.31"->{
    Cell[112683, 3839, 1172, 24, 70, "Text",
      CellTags->{"S6.3.1", "1.31"}]},
  "1.32"->{
    Cell[118911, 3991, 586, 11, 70, "Text",
      CellTags->{"S6.3.1", "1.32"}]},
  "1.33"->{
    Cell[120736, 4039, 432, 11, 70, "Text",
      CellTags->{"S6.3.1", "1.33"}]},
  "1.34"->{
    Cell[123824, 4122, 612, 13, 70, "Text",
      CellTags->{"S6.3.1", "1.34"}]},
  "1.35"->{
    Cell[129010, 4253, 894, 25, 70, "Text",
      CellTags->{"S6.3.1", "1.35"}]},
  "1.36"->{
    Cell[129907, 4280, 133, 4, 70, "MathCaption",
      CellTags->{"S6.3.1", "1.36"}]},
  "1.37"->{
    Cell[130524, 4301, 97, 1, 70, "MathCaption",
      CellTags->{"S6.3.1", "1.37"}]},
  "1.38"->{
    Cell[130885, 4316, 315, 10, 70, "MathCaption",
      CellTags->{"S6.3.1", "1.38"}]},
  "1.39"->{
    Cell[135598, 4442, 282, 6, 70, "Text",
      CellTags->{"S6.3.1", "1.39"}]},
  "1.40"->{
    Cell[135883, 4450, 128, 4, 70, "MathCaption",
      CellTags->{"S6.3.1", "1.40"}]},
  "1.41"->{
    Cell[136120, 4460, 165, 4, 70, "MathCaption",
      CellTags->{"S6.3.1", "1.41"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S6.3.1", 137267, 4499},
  {"1.1", 144931, 4698},
  {"1.2", 145024, 4701},
  {"1.3", 145113, 4704},
  {"1.4", 145203, 4707},
  {"1.5", 145293, 4710},
  {"1.6", 145383, 4713},
  {"1.7", 145473, 4716},
  {"1.8", 145568, 4719},
  {"1.9", 145664, 4722},
  {"1.10", 145760, 4725},
  {"1.11", 145860, 4728},
  {"1.12", 145959, 4731},
  {"1.13", 146052, 4734},
  {"1.14", 146146, 4737},
  {"1.15", 146239, 4740},
  {"1.16", 146333, 4743},
  {"1.17", 146425, 4746},
  {"1.18", 146518, 4749},
  {"1.19", 146612, 4752},
  {"1.20", 146707, 4755},
  {"1.21", 146801, 4758},
  {"1.22", 146894, 4761},
  {"1.23", 146993, 4764},
  {"1.24", 147092, 4767},
  {"1.25", 147191, 4770},
  {"1.26", 147290, 4773},
  {"1.27", 147390, 4776},
  {"1.28", 147489, 4779},
  {"1.29", 147588, 4782},
  {"1.30", 147688, 4785},
  {"1.31", 147782, 4788},
  {"1.32", 147877, 4791},
  {"1.33", 147971, 4794},
  {"1.34", 148065, 4797},
  {"1.35", 148159, 4800},
  {"1.36", 148253, 4803},
  {"1.37", 148353, 4806},
  {"1.38", 148452, 4809},
  {"1.39", 148553, 4812},
  {"1.40", 148646, 4815},
  {"1.41", 148746, 4818}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 147, 6, 36, "Subsection",
  CellTags->{"S6.3.1", "1.1"}],
Cell[1926, 61, 776, 20, 104, "Text",
  CellTags->{"S6.3.1", "1.2"}],
Cell[2705, 83, 3340, 111, 81, "Text",
  CellTags->{"S6.3.1", "1.3"}],
Cell[6048, 196, 2492, 77, 57, "Text",
  CellTags->{"S6.3.1", "1.4"}],
Cell[8543, 275, 9637, 237, 142, "DefinitionBox",
  CellTags->"S6.3.1"],
Cell[18183, 514, 99, 5, 15, "Caption",
  CellTags->"S6.3.1"],
Cell[18285, 521, 711, 19, 75, "Text",
  CellTags->{"S6.3.1", "1.5"}],
Cell[18999, 542, 529, 14, 40, "Text",
  CellTags->{"S6.3.1", "1.6"}],
Cell[19531, 558, 7587, 179, 70, "DefinitionBox",
  CellTags->"S6.3.1"],
Cell[27121, 739, 120, 5, 70, "Caption",
  CellTags->"S6.3.1"],
Cell[27244, 746, 78, 1, 70, "MathCaption",
  CellTags->{"S6.3.1", "1.7"}],
Cell[27325, 749, 94, 2, 70, "Input",
  CellTags->"S6.3.1"],
Cell[27422, 753, 202, 5, 70, "MathCaption",
  CellTags->{"S6.3.1", "1.8"}],
Cell[27627, 760, 221, 7, 70, "Input",
  CellTags->"S6.3.1"],
Cell[27851, 769, 82, 1, 70, "MathCaption",
  CellTags->{"S6.3.1", "1.9"}],

Cell[CellGroupData[{
Cell[27958, 774, 86, 2, 70, "Input",
  CellTags->"S6.3.1"],
Cell[28047, 778, 4106, 291, 70, 4033, 288, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S6.3.1"],
Cell[32156, 1071, 177, 5, 70, "Output",
  CellTags->"S6.3.1"]
}, Open  ]],
Cell[32348, 1079, 917, 31, 70, "MathCaption",
  CellTags->{"S6.3.1", "1.10"}],

Cell[CellGroupData[{
Cell[33290, 1114, 134, 5, 70, "Input",
  CellTags->"S6.3.1"],
Cell[33427, 1121, 2077, 44, 70, "Output",
  CellTags->"S6.3.1"]
}, Open  ]],
Cell[35519, 1168, 150, 5, 70, "MathCaption",
  CellTags->{"S6.3.1", "1.11"}],

Cell[CellGroupData[{
Cell[35694, 1177, 93, 2, 70, "Input",
  CellTags->"S6.3.1"],
Cell[35790, 1181, 163, 4, 70, "Output",
  CellTags->"S6.3.1"]
}, Open  ]],
Cell[35968, 1188, 5181, 120, 70, "DefinitionBox3Col",
  CellTags->"S6.3.1"],
Cell[41152, 1310, 105, 5, 70, "Caption",
  CellTags->"S6.3.1"],
Cell[41260, 1317, 583, 17, 70, "Text",
  CellTags->{"S6.3.1", "1.12"}],
Cell[41846, 1336, 1541, 49, 70, "Text",
  CellTags->{"S6.3.1", "1.13"}],
Cell[43390, 1387, 896, 30, 70, "Text",
  CellTags->{"S6.3.1", "1.14"}],
Cell[44289, 1419, 1071, 32, 70, "Text",
  CellTags->{"S6.3.1", "1.15"}],
Cell[45363, 1453, 272, 9, 70, "Text",
  CellTags->{"S6.3.1", "1.16"}],
Cell[45638, 1464, 515, 14, 70, "Text",
  CellTags->{"S6.3.1", "1.17"}],
Cell[46156, 1480, 13081, 319, 70, "DefinitionBox",
  CellTags->"S6.3.1"],
Cell[59240, 1801, 227, 7, 70, "Caption",
  CellTags->"S6.3.1"],
Cell[59470, 1810, 1253, 29, 70, "Text",
  CellTags->{"S6.3.1", "1.18"}],
Cell[60726, 1841, 3608, 109, 70, "Text",
  CellTags->{"S6.3.1", "1.19"}],
Cell[64337, 1952, 1660, 43, 70, "Text",
  CellTags->{"S6.3.1", "1.20"}],
Cell[66000, 1997, 634, 13, 70, "Text",
  CellTags->{"S6.3.1", "1.21"}],
Cell[66637, 2012, 241, 5, 70, "MathCaption",
  CellTags->{"S6.3.1", "1.22"}],

Cell[CellGroupData[{
Cell[66903, 2021, 198, 7, 70, "Input",
  CellTags->"S6.3.1"],
Cell[67104, 2030, 2843, 57, 70, "Output",
  CellTags->"S6.3.1"]
}, Open  ]],
Cell[69962, 2090, 116, 2, 70, "MathCaption",
  CellTags->{"S6.3.1", "1.23"}],

Cell[CellGroupData[{
Cell[70103, 2096, 96, 2, 70, "Input",
  CellTags->"S6.3.1"],
Cell[70202, 2100, 335, 7, 70, "Output",
  CellTags->"S6.3.1"]
}, Open  ]],
Cell[70552, 2110, 213, 5, 70, "MathCaption",
  CellTags->{"S6.3.1", "1.24"}],
Cell[70768, 2117, 159, 5, 70, "Input",
  CellTags->"S6.3.1"],
Cell[70930, 2124, 153, 4, 70, "MathCaption",
  CellTags->{"S6.3.1", "1.25"}],

Cell[CellGroupData[{
Cell[71108, 2132, 104, 2, 70, "Input",
  CellTags->"S6.3.1"],
Cell[71215, 2136, 3860, 276, 70, 3787, 273, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S6.3.1"],
Cell[75078, 2414, 177, 5, 70, "Output",
  CellTags->"S6.3.1"]
}, Open  ]],
Cell[75270, 2422, 343, 10, 70, "MathCaption",
  CellTags->{"S6.3.1", "1.26"}],
Cell[75616, 2434, 230, 7, 70, "Input",
  CellTags->"S6.3.1"],
Cell[75849, 2443, 141, 5, 70, "MathCaption",
  CellTags->{"S6.3.1", "1.27"}],
Cell[75993, 2450, 93, 2, 70, "Input",
  CellTags->"S6.3.1"],
Cell[76089, 2454, 319, 8, 70, "MathCaption",
  CellTags->{"S6.3.1", "1.28"}],

Cell[CellGroupData[{
Cell[76433, 2466, 308, 11, 70, "Input",
  CellTags->"S6.3.1"],
Cell[76744, 2479, 5825, 342, 70, 5752, 339, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S6.3.1"],
Cell[82572, 2823, 178, 5, 70, "Output",
  CellTags->"S6.3.1"]
}, Open  ]],
Cell[82765, 2831, 420, 13, 70, "MathCaption",
  CellTags->{"S6.3.1", "1.29"}],

Cell[CellGroupData[{
Cell[83210, 2848, 184, 5, 70, "Input",
  CellTags->"S6.3.1"],
Cell[83397, 2855, 8225, 472, 70, 8152, 469, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S6.3.1"],
Cell[91625, 3329, 178, 5, 70, "Output",
  CellTags->"S6.3.1"]
}, Open  ]],
Cell[91818, 3337, 1223, 24, 70, "Text",
  CellTags->{"S6.3.1", "1.30"}],
Cell[93044, 3363, 19557, 471, 70, "DefinitionBox",
  CellTags->"S6.3.1"],
Cell[112604, 3836, 76, 1, 70, "Caption",
  CellTags->"S6.3.1"],
Cell[112683, 3839, 1172, 24, 70, "Text",
  CellTags->{"S6.3.1", "1.31"}],
Cell[113858, 3865, 4926, 118, 70, "DefinitionBox",
  CellTags->"S6.3.1"],
Cell[118787, 3985, 121, 4, 70, "Caption",
  CellTags->"S6.3.1"],
Cell[118911, 3991, 586, 11, 70, "Text",
  CellTags->{"S6.3.1", "1.32"}],
Cell[119500, 4004, 1160, 30, 70, "DefinitionBox",
  CellTags->"S6.3.1"],
Cell[120663, 4036, 70, 1, 70, "Caption",
  CellTags->"S6.3.1"],
Cell[120736, 4039, 432, 11, 70, "Text",
  CellTags->{"S6.3.1", "1.33"}],
Cell[121171, 4052, 2525, 62, 70, "DefinitionBox",
  CellTags->"S6.3.1"],
Cell[123699, 4116, 122, 4, 70, "Caption",
  CellTags->"S6.3.1"],
Cell[123824, 4122, 612, 13, 70, "Text",
  CellTags->{"S6.3.1", "1.34"}],
Cell[124439, 4137, 4470, 111, 70, "DefinitionBox",
  CellTags->"S6.3.1"],
Cell[128912, 4250, 95, 1, 70, "Caption",
  CellTags->"S6.3.1"],
Cell[129010, 4253, 894, 25, 70, "Text",
  CellTags->{"S6.3.1", "1.35"}],
Cell[129907, 4280, 133, 4, 70, "MathCaption",
  CellTags->{"S6.3.1", "1.36"}],

Cell[CellGroupData[{
Cell[130065, 4288, 102, 2, 70, "Input",
  CellTags->"S6.3.1"],
Cell[130170, 4292, 339, 6, 70, "Output",
  CellTags->"S6.3.1"]
}, Open  ]],
Cell[130524, 4301, 97, 1, 70, "MathCaption",
  CellTags->{"S6.3.1", "1.37"}],

Cell[CellGroupData[{
Cell[130646, 4306, 91, 2, 70, "Input",
  CellTags->"S6.3.1"],
Cell[130740, 4310, 130, 3, 70, "Output",
  CellTags->"S6.3.1"]
}, Open  ]],
Cell[130885, 4316, 315, 10, 70, "MathCaption",
  CellTags->{"S6.3.1", "1.38"}],

Cell[CellGroupData[{
Cell[131225, 4330, 168, 5, 70, "Input",
  CellTags->"S6.3.1"],
Cell[131396, 4337, 2145, 46, 70, "Output",
  CellTags->"S6.3.1"]
}, Open  ]],
Cell[133556, 4386, 1907, 48, 70, "DefinitionBox",
  CellTags->"S6.3.1"],
Cell[135466, 4436, 129, 4, 70, "Caption",
  CellTags->"S6.3.1"],
Cell[135598, 4442, 282, 6, 70, "Text",
  CellTags->{"S6.3.1", "1.39"}],
Cell[135883, 4450, 128, 4, 70, "MathCaption",
  CellTags->{"S6.3.1", "1.40"}],
Cell[136014, 4456, 103, 2, 70, "Input",
  CellTags->"S6.3.1"],
Cell[136120, 4460, 165, 4, 70, "MathCaption",
  CellTags->{"S6.3.1", "1.41"}],

Cell[CellGroupData[{
Cell[136310, 4468, 143, 5, 70, "Input",
  CellTags->"S6.3.1"],
Cell[136456, 4475, 161, 4, 70, "Output",
  CellTags->"S6.3.1"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

