(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     17651,        610]*)
(*NotebookOutlinePosition[     23299,        781]*)
(*  CellTagsIndexPosition[     22827,        758]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "NumericalMath",
 StyleBox["`", "MB"],
 "ListIntegrate",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.84.1", "1.1"}],

Cell[TextData[{
 "The ",
 StyleBox["Mathematica", "TI"],
 " function ",
 StyleBox["NIntegrate", "MR"],
 " computes a numerical approximation to a definite integral. To use ",
 StyleBox["NIntegrate", "MR"],
 " you must enter a symbolic expression for the function you want to \
integrate. There are many situations that arise in experimental and numerical \
work in which all you have is a list of values of the function to be \
integrated. The function ",
 StyleBox["ListIntegrate", "MR"],
 " given in this package will compute an approximation to the integral in \
this case. "
}], "Text",
 CellTags->{"S5.84.1", "1.2"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["ListIntegrate[{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] , ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], 
         StyleBox["n",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["h", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "give an approximation to the integral of the function having values ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] , ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], 
         StyleBox["n",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" using constant step size ", "TR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["h", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" in ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ListIntegrate[{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] , ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], 
         StyleBox["n",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["h", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["k", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["do the approximation using the nearest ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["k", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" points for each subinterval",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ListIntegrate[{{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, \[Ellipsis] , {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], 
         StyleBox["n",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], 
         StyleBox["n",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}}, ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["k", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "do the approximation for variable step\[Hyphen]size data",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.84.1"],

Cell["\<\
Approximating a definite integral from a list of function values. \
\>", "Caption",
 CellTags->"S5.84.1"],

Cell[TextData[{
 StyleBox["ListIntegrate", "MR"],
 " works by using ",
 StyleBox["Interpolation", "MR"],
 " to construct an ",
 StyleBox["InterpolatingFunction", "MR"],
 " object to approximate the function that produced the data with a \
collection of interpolating polynomials. The ",
 StyleBox["InterpolatingFunction", "MR"],
 " is integrated to obtain the result. You can specify the degree of the \
polynomial used in the ",
 StyleBox["InterpolatingFunction", "MR"],
 " object by giving a value for ",
 StyleBox["k", "TI"],
 ". ",
 StyleBox["k", "TI"],
 " is the number of points used to construct each polynomial and the degree \
of each polynomial is ",
 StyleBox["k", "TI"],
 Cell[BoxData[
  FormBox["-", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "1 (",
 StyleBox["InterpolationOrder->", "MR"],
 StyleBox["k", "TI"],
 Cell[BoxData[
  FormBox["-", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "1). The default value for ",
 StyleBox["k", "TI"],
 " is ",
 Cell[BoxData[
  FormBox["4", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "Text",
 CellTags->{"S5.84.1", "1.3"}],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.84.1", "1.4"}],

Cell["<<NumericalMath`ListIntegrate`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.84.1"],

Cell[TextData[{
 "This gives a list of function values for\[NonBreakingSpace]",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["x",
     "TI"], "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.84.1", "1.5"}],

Cell[CellGroupData[{

Cell["data = Table[ n^2, {n, 0, 7}]", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.84.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "1", ",", "4", ",", "9", ",", "16", ",", "25", ",", "36", ",", 
   "49"}], "}"}]], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.84.1"]
}, Open  ]],

Cell[TextData[{
 "This gives an approximation to the integral of the function that produced \
the list of data. The step size of 1 means that the values in the list come \
from ",
 StyleBox["x", "TI"],
 " values that are 1 unit apart. "
}], "MathCaption",
 CellTags->{"S5.84.1", "1.6"}],

Cell[CellGroupData[{

Cell["ListIntegrate[data, 1]", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.84.1"],

Cell[BoxData[
 FractionBox["343", "3"]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.84.1"]
}, Open  ]],

Cell["\<\
Because the data were created by a degree two polynomial, the approximation \
is exact. \
\>", "MathCaption",
 CellTags->{"S5.84.1", "1.7"}],

Cell[CellGroupData[{

Cell["Integrate[x^2, {x, 0, 7}]", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.84.1"],

Cell[BoxData[
 FractionBox["343", "3"]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.84.1"]
}, Open  ]],

Cell["\<\
This gives the integral derived from the same data with a small random \
perturbation added. \
\>", "MathCaption",
 CellTags->{"S5.84.1", "1.8"}],

Cell[CellGroupData[{

Cell["\<\
ListIntegrate[
    Table[ n^2 + .1 Random[ ],
        {n, 0, 7}], 1]\
\>", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.84.1"],

Cell[BoxData["114.78454015709804`"], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S5.84.1"]
}, Open  ]],

Cell["\<\
If the data are a little noisy, the approximation is still fairly good. \
\>", "MathCaption",
 CellTags->{"S5.84.1", "1.9"}],

Cell[CellGroupData[{

Cell["% - %%", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.84.1"],

Cell[BoxData["0.4512068237647071`"], "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S5.84.1"]
}, Open  ]],

Cell[TextData[{
 "By giving a list of pairs you can work with variable step\[Hyphen]size \
data. The approximation is not as good as before, because the degree of the \
approximation has been reduced to ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", that is, linear interpolation. "
}], "MathCaption",
 CellTags->{"S5.84.1", "1.10"}],

Cell[CellGroupData[{

Cell["\<\
ListIntegrate[
    {{0,0},{1,1},{2,4},{5,25},{7,49}},2]\
\>", "Input",
 CellLabel->"In[7]:= ",
 CellTags->"S5.84.1"],

Cell[BoxData[
 FractionBox["241", "2"]], "Output",
 CellLabel->"Out[7]= ",
 CellTags->"S5.84.1"]
}, Open  ]],

Cell[TextData[{
 "If you know that there is significant error in your data, that is, it \
differs a great deal from the true function, it is better to smooth the error \
using ",
 StyleBox["Fit", "MR"],
 " and then use ",
 StyleBox["NIntegrate", "MR"],
 " to compute the integral of the fit. "
}], "Text",
 CellTags->{"S5.84.1", "1.11"}],

Cell[CellGroupData[{

Cell["Integration Using Interpolation", "Subsubsection",
 CellTags->{"S5.84.1", "1.12"}],

Cell[TextData[{
 "This package has been included for compatibility with previous versions of \
",
 StyleBox["Mathematica", "TI"],
 ". The functionality of this package has been superseded by improvements \
made to ",
 StyleBox["InterpolatingFunction", "MR"],
 ". For example, the first and last examples can just as easily be done \
directly. "
}], "Text",
 CellTags->{"S5.84.1", "1.13"}],

Cell[TextData[{
 "This makes an ",
 StyleBox["InterpolatingFunction", "MR"],
 " approximation. "
}], "MathCaption",
 CellTags->{"S5.84.1", "1.14"}],

Cell[CellGroupData[{

Cell["app = ListInterpolation[data,{{0,7}}]", "Input",
 CellLabel->"In[8]:= ",
 CellTags->"S5.84.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0", ",", "7"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[8]= ",
 CellTags->"S5.84.1"]
}, Open  ]],

Cell["This integrates the approximation. ", "MathCaption",
 CellTags->{"S5.84.1", "1.15"}],

Cell[CellGroupData[{

Cell["Integrate[app[x],{x,0,7}]", "Input",
 CellLabel->"In[9]:= ",
 CellTags->"S5.84.1"],

Cell[BoxData[
 FractionBox["343", "3"]], "Output",
 CellLabel->"Out[9]= ",
 CellTags->"S5.84.1"]
}, Open  ]],

Cell["\<\
Here approximation and integration are performed in one step. \
\>", "MathCaption",
 CellTags->{"S5.84.1", "1.16"}],

Cell[CellGroupData[{

Cell["\<\
Integrate[Interpolation[{{0,0},{1,1},{2,4},{5,25},{7,49}},
InterpolationOrder->1][x],{x,0,7}]\
\>", "Input",
 CellLabel->"In[10]:= ",
 CellTags->"S5.84.1"],

Cell[BoxData[
 FractionBox["241", "2"]], "Output",
 CellLabel->"Out[10]= ",
 CellTags->"S5.84.1"]
}, Open  ]],

Cell["\<\
It is advantageous to use the direct construction because it can be used to \
find the integral over part of the interval between the points, an \
approximate indefinite integral function, or the approximate integral for \
multidimensional data on tensor product grids. \
\>", "Text",
 CellTags->{"S5.84.1", "1.17"}]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.84.1"->{
    Cell[1776, 53, 143, 6, 36, "Subsection",
      CellTags->{"S5.84.1", "1.1"}],
    Cell[1922, 61, 621, 15, 88, "Text",
      CellTags->{"S5.84.1", "1.2"}],
    Cell[2546, 78, 8151, 252, 160, "DefinitionBox",
      CellTags->"S5.84.1"],
    Cell[10700, 332, 115, 3, 15, "Caption",
      CellTags->"S5.84.1"],
    Cell[10818, 337, 1200, 36, 104, "Text",
      CellTags->{"S5.84.1", "1.3"}],
    Cell[12021, 375, 78, 1, 40, "MathCaption",
      CellTags->{"S5.84.1", "1.4"}],
    Cell[12102, 378, 93, 2, 28, "Input",
      CellTags->"S5.84.1"],
    Cell[12198, 382, 298, 10, 40, "MathCaption",
      CellTags->{"S5.84.1", "1.5"}],
    Cell[12521, 396, 92, 2, 28, "Input",
      CellTags->"S5.84.1"],
    Cell[12616, 400, 190, 6, 23, "Output",
      CellTags->"S5.84.1"],
    Cell[12821, 409, 286, 7, 56, "MathCaption",
      CellTags->{"S5.84.1", "1.6"}],
    Cell[13132, 420, 85, 2, 70, "Input",
      CellTags->"S5.84.1"],
    Cell[13220, 424, 96, 3, 70, "Output",
      CellTags->"S5.84.1"],
    Cell[13331, 430, 150, 4, 70, "MathCaption",
      CellTags->{"S5.84.1", "1.7"}],
    Cell[13506, 438, 88, 2, 70, "Input",
      CellTags->"S5.84.1"],
    Cell[13597, 442, 96, 3, 70, "Output",
      CellTags->"S5.84.1"],
    Cell[13708, 448, 155, 4, 70, "MathCaption",
      CellTags->{"S5.84.1", "1.8"}],
    Cell[13888, 456, 139, 6, 70, "Input",
      CellTags->"S5.84.1"],
    Cell[14030, 464, 92, 2, 70, "Output",
      CellTags->"S5.84.1"],
    Cell[14137, 469, 134, 3, 70, "MathCaption",
      CellTags->{"S5.84.1", "1.9"}],
    Cell[14296, 476, 69, 2, 70, "Input",
      CellTags->"S5.84.1"],
    Cell[14368, 480, 92, 2, 70, "Output",
      CellTags->"S5.84.1"],
    Cell[14475, 485, 405, 9, 70, "MathCaption",
      CellTags->{"S5.84.1", "1.10"}],
    Cell[14905, 498, 126, 5, 70, "Input",
      CellTags->"S5.84.1"],
    Cell[15034, 505, 96, 3, 70, "Output",
      CellTags->"S5.84.1"],
    Cell[15145, 511, 337, 9, 70, "Text",
      CellTags->{"S5.84.1", "1.11"}],
    Cell[15507, 524, 88, 1, 70, "Subsubsection",
      CellTags->{"S5.84.1", "1.12"}],
    Cell[15598, 527, 388, 10, 70, "Text",
      CellTags->{"S5.84.1", "1.13"}],
    Cell[15989, 539, 147, 5, 70, "MathCaption",
      CellTags->{"S5.84.1", "1.14"}],
    Cell[16161, 548, 100, 2, 70, "Input",
      CellTags->"S5.84.1"],
    Cell[16264, 552, 271, 10, 70, "Output",
      CellTags->"S5.84.1"],
    Cell[16550, 565, 90, 1, 70, "MathCaption",
      CellTags->{"S5.84.1", "1.15"}],
    Cell[16665, 570, 88, 2, 70, "Input",
      CellTags->"S5.84.1"],
    Cell[16756, 574, 96, 3, 70, "Output",
      CellTags->"S5.84.1"],
    Cell[16867, 580, 125, 3, 70, "MathCaption",
      CellTags->{"S5.84.1", "1.16"}],
    Cell[17017, 587, 165, 5, 70, "Input",
      CellTags->"S5.84.1"],
    Cell[17185, 594, 97, 3, 70, "Output",
      CellTags->"S5.84.1"],
    Cell[17297, 600, 326, 6, 70, "Text",
      CellTags->{"S5.84.1", "1.17"}]},
  "1.1"->{
    Cell[1776, 53, 143, 6, 36, "Subsection",
      CellTags->{"S5.84.1", "1.1"}]},
  "1.2"->{
    Cell[1922, 61, 621, 15, 88, "Text",
      CellTags->{"S5.84.1", "1.2"}]},
  "1.3"->{
    Cell[10818, 337, 1200, 36, 104, "Text",
      CellTags->{"S5.84.1", "1.3"}]},
  "1.4"->{
    Cell[12021, 375, 78, 1, 40, "MathCaption",
      CellTags->{"S5.84.1", "1.4"}]},
  "1.5"->{
    Cell[12198, 382, 298, 10, 40, "MathCaption",
      CellTags->{"S5.84.1", "1.5"}]},
  "1.6"->{
    Cell[12821, 409, 286, 7, 56, "MathCaption",
      CellTags->{"S5.84.1", "1.6"}]},
  "1.7"->{
    Cell[13331, 430, 150, 4, 70, "MathCaption",
      CellTags->{"S5.84.1", "1.7"}]},
  "1.8"->{
    Cell[13708, 448, 155, 4, 70, "MathCaption",
      CellTags->{"S5.84.1", "1.8"}]},
  "1.9"->{
    Cell[14137, 469, 134, 3, 70, "MathCaption",
      CellTags->{"S5.84.1", "1.9"}]},
  "1.10"->{
    Cell[14475, 485, 405, 9, 70, "MathCaption",
      CellTags->{"S5.84.1", "1.10"}]},
  "1.11"->{
    Cell[15145, 511, 337, 9, 70, "Text",
      CellTags->{"S5.84.1", "1.11"}]},
  "1.12"->{
    Cell[15507, 524, 88, 1, 70, "Subsubsection",
      CellTags->{"S5.84.1", "1.12"}]},
  "1.13"->{
    Cell[15598, 527, 388, 10, 70, "Text",
      CellTags->{"S5.84.1", "1.13"}]},
  "1.14"->{
    Cell[15989, 539, 147, 5, 70, "MathCaption",
      CellTags->{"S5.84.1", "1.14"}]},
  "1.15"->{
    Cell[16550, 565, 90, 1, 70, "MathCaption",
      CellTags->{"S5.84.1", "1.15"}]},
  "1.16"->{
    Cell[16867, 580, 125, 3, 70, "MathCaption",
      CellTags->{"S5.84.1", "1.16"}]},
  "1.17"->{
    Cell[17297, 600, 326, 6, 70, "Text",
      CellTags->{"S5.84.1", "1.17"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.84.1", 18274, 626},
  {"1.1", 21183, 703},
  {"1.2", 21277, 706},
  {"1.3", 21366, 709},
  {"1.4", 21459, 712},
  {"1.5", 21555, 715},
  {"1.6", 21653, 718},
  {"1.7", 21750, 721},
  {"1.8", 21847, 724},
  {"1.9", 21944, 727},
  {"1.10", 22042, 730},
  {"1.11", 22141, 733},
  {"1.12", 22233, 736},
  {"1.13", 22333, 739},
  {"1.14", 22426, 742},
  {"1.15", 22525, 745},
  {"1.16", 22623, 748},
  {"1.17", 22722, 751}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 143, 6, 36, "Subsection",
  CellTags->{"S5.84.1", "1.1"}],
Cell[1922, 61, 621, 15, 88, "Text",
  CellTags->{"S5.84.1", "1.2"}],
Cell[2546, 78, 8151, 252, 160, "DefinitionBox",
  CellTags->"S5.84.1"],
Cell[10700, 332, 115, 3, 15, "Caption",
  CellTags->"S5.84.1"],
Cell[10818, 337, 1200, 36, 104, "Text",
  CellTags->{"S5.84.1", "1.3"}],
Cell[12021, 375, 78, 1, 40, "MathCaption",
  CellTags->{"S5.84.1", "1.4"}],
Cell[12102, 378, 93, 2, 28, "Input",
  CellTags->"S5.84.1"],
Cell[12198, 382, 298, 10, 40, "MathCaption",
  CellTags->{"S5.84.1", "1.5"}],

Cell[CellGroupData[{
Cell[12521, 396, 92, 2, 28, "Input",
  CellTags->"S5.84.1"],
Cell[12616, 400, 190, 6, 23, "Output",
  CellTags->"S5.84.1"]
}, Open  ]],
Cell[12821, 409, 286, 7, 56, "MathCaption",
  CellTags->{"S5.84.1", "1.6"}],

Cell[CellGroupData[{
Cell[13132, 420, 85, 2, 70, "Input",
  CellTags->"S5.84.1"],
Cell[13220, 424, 96, 3, 70, "Output",
  CellTags->"S5.84.1"]
}, Open  ]],
Cell[13331, 430, 150, 4, 70, "MathCaption",
  CellTags->{"S5.84.1", "1.7"}],

Cell[CellGroupData[{
Cell[13506, 438, 88, 2, 70, "Input",
  CellTags->"S5.84.1"],
Cell[13597, 442, 96, 3, 70, "Output",
  CellTags->"S5.84.1"]
}, Open  ]],
Cell[13708, 448, 155, 4, 70, "MathCaption",
  CellTags->{"S5.84.1", "1.8"}],

Cell[CellGroupData[{
Cell[13888, 456, 139, 6, 70, "Input",
  CellTags->"S5.84.1"],
Cell[14030, 464, 92, 2, 70, "Output",
  CellTags->"S5.84.1"]
}, Open  ]],
Cell[14137, 469, 134, 3, 70, "MathCaption",
  CellTags->{"S5.84.1", "1.9"}],

Cell[CellGroupData[{
Cell[14296, 476, 69, 2, 70, "Input",
  CellTags->"S5.84.1"],
Cell[14368, 480, 92, 2, 70, "Output",
  CellTags->"S5.84.1"]
}, Open  ]],
Cell[14475, 485, 405, 9, 70, "MathCaption",
  CellTags->{"S5.84.1", "1.10"}],

Cell[CellGroupData[{
Cell[14905, 498, 126, 5, 70, "Input",
  CellTags->"S5.84.1"],
Cell[15034, 505, 96, 3, 70, "Output",
  CellTags->"S5.84.1"]
}, Open  ]],
Cell[15145, 511, 337, 9, 70, "Text",
  CellTags->{"S5.84.1", "1.11"}],

Cell[CellGroupData[{
Cell[15507, 524, 88, 1, 70, "Subsubsection",
  CellTags->{"S5.84.1", "1.12"}],
Cell[15598, 527, 388, 10, 70, "Text",
  CellTags->{"S5.84.1", "1.13"}],
Cell[15989, 539, 147, 5, 70, "MathCaption",
  CellTags->{"S5.84.1", "1.14"}],

Cell[CellGroupData[{
Cell[16161, 548, 100, 2, 70, "Input",
  CellTags->"S5.84.1"],
Cell[16264, 552, 271, 10, 70, "Output",
  CellTags->"S5.84.1"]
}, Open  ]],
Cell[16550, 565, 90, 1, 70, "MathCaption",
  CellTags->{"S5.84.1", "1.15"}],

Cell[CellGroupData[{
Cell[16665, 570, 88, 2, 70, "Input",
  CellTags->"S5.84.1"],
Cell[16756, 574, 96, 3, 70, "Output",
  CellTags->"S5.84.1"]
}, Open  ]],
Cell[16867, 580, 125, 3, 70, "MathCaption",
  CellTags->{"S5.84.1", "1.16"}],

Cell[CellGroupData[{
Cell[17017, 587, 165, 5, 70, "Input",
  CellTags->"S5.84.1"],
Cell[17185, 594, 97, 3, 70, "Output",
  CellTags->"S5.84.1"]
}, Open  ]],
Cell[17297, 600, 326, 6, 70, "Text",
  CellTags->{"S5.84.1", "1.17"}]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

