(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    155120,       6154]*)
(*NotebookOutlinePosition[    174931,       6717]*)
(*  CellTagsIndexPosition[    173539,       6660]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "LinearAlgebra",
 StyleBox["`", "MB"],
 "MatrixManipulation",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.48.1", "1.1"}],

Cell["\<\
This package includes functions for composing and separating matrices using \
rows, columns, and submatrices. All of the definitions involve simple \
combinations of built\[Hyphen]in functions. Also included are functions for \
constructing a variety of special matrices. \
\>", "Text",
 CellTags->{"S5.48.1", "1.2"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["AppendColumns[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["m",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["m",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] ]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["join the columns in matrices ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["m",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["m",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"\[Ellipsis]", " "}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["AppendRows[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["m",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["m",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] ]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["join the rows in matrices ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["m",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["m",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"\[Ellipsis]", " "}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["BlockMatrix[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["blocks", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["join rows and columns of submatrices in ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["blocks", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" to form a new matrix ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.48.1"],

Cell["Functions for combining matrices. ", "Caption",
 CellTags->"S5.48.1"],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.48.1", "1.3"}],

Cell["<< LinearAlgebra`MatrixManipulation`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.48.1"],

Cell[TextData[{
 "Define a ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", "\[Cross]", "2"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " matrix. "
}], "MathCaption",
 CellTags->{"S5.48.1", "1.4"}],

Cell[CellGroupData[{

Cell["a = {{a11, a12}, {a21, a22}}; MatrixForm[a]", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.48.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"a11", "a12"},
     {"a21", "a22"}
     }], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabel->"Out[2]//MatrixForm= ",
 CellTags->"S5.48.1"]
}, Open  ]],

Cell["Define a second matrix. ", "MathCaption",
 CellTags->{"S5.48.1", "1.5"}],

Cell[CellGroupData[{

Cell["b = {{b11, b12}, {b21, b22}}; MatrixForm[b]", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.48.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"b11", "b12"},
     {"b21", "b22"}
     }], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabel->"Out[3]//MatrixForm= ",
 CellTags->"S5.48.1"]
}, Open  ]],

Cell["\<\
This constructs a matrix by combining the columns of the two matrices. \
\>", "MathCaption",
 CellTags->{"S5.48.1", "1.6"}],

Cell[CellGroupData[{

Cell["AppendColumns[a, b]", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.48.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a11", ",", "a12"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a21", ",", "a22"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b11", ",", "b12"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b21", ",", "b22"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.48.1"]
}, Open  ]],

Cell[TextData[{
 "Here is the same matrix displayed using ",
 StyleBox["MatrixForm", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.48.1", "1.7"}],

Cell[CellGroupData[{

Cell["MatrixForm[%]", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.48.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"a11", "a12"},
     {"a21", "a22"},
     {"b11", "b12"},
     {"b21", "b22"}
     }], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabel->"Out[5]//MatrixForm= ",
 CellTags->"S5.48.1"]
}, Open  ]],

Cell["\<\
A matrix can also be constructed by combining the rows of these matrices. \
\>", "MathCaption",
 CellTags->{"S5.48.1", "1.8"}],

Cell[CellGroupData[{

Cell["AppendRows[a, b]//MatrixForm", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.48.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"a11", "a12", "b11", "b12"},
     {"a21", "a22", "b21", "b22"}
     }], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabel->"Out[6]//MatrixForm= ",
 CellTags->"S5.48.1"]
}, Open  ]],

Cell[TextData[{
 "Here is a matrix constructed from submatrices ",
 StyleBox["a", "MR"],
 " and ",
 StyleBox["b", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.48.1", "1.9"}],

Cell[CellGroupData[{

Cell["\<\
BlockMatrix[{{a, b}, {b, {{0, 0},
  {0, 0}}}}]//MatrixForm\
\>", "Input",
 CellLabel->"In[7]:= ",
 CellTags->"S5.48.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"a11", "a12", "b11", "b12"},
     {"a21", "a22", "b21", "b22"},
     {"b11", "b12", "0", "0"},
     {"b21", "b22", "0", "0"}
     }], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabel->"Out[7]//MatrixForm= ",
 CellTags->"S5.48.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["TakeRows[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["mat", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["take the first ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" rows in ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["mat", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["TakeRows[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["mat", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", -", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["take the last ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" rows in ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["mat", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["TakeRows[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["mat", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["m", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["take rows ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["m", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" through ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" in ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["mat", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["TakeColumns[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["mat", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["take the first ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" columns in ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["mat", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["TakeColumns[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["mat", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", -", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["take the last ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" columns in ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["mat", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["TakeColumns[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["mat", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["m", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["take columns ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["m", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" through ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" in ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["mat", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["TakeMatrix[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["mat", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["pos",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["pos",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["take the submatrix of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["mat", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" between elements at positions ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["pos",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["pos",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["SubMatrix[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["mat", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["pos", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dim", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["take the submatrix of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["mat", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" of dimension ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dim", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" starting at position ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["pos", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.48.1"],

Cell["Functions for picking out pieces of matrices. ", "Caption",
 CellTags->"S5.48.1"],

Cell[TextData[{
 "Here is a ",
 Cell[BoxData[
  FormBox[
   RowBox[{"4", "\[Cross]", "4"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " matrix. "
}], "MathCaption",
 CellTags->{"S5.48.1", "1.10"}],

Cell[CellGroupData[{

Cell["mat = Array[m, {4, 4}]; MatrixForm[mat]", "Input",
 CellLabel->"In[8]:= ",
 CellTags->"S5.48.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"m", "[", 
       RowBox[{"1", ",", "1"}], "]"}], 
      RowBox[{"m", "[", 
       RowBox[{"1", ",", "2"}], "]"}], 
      RowBox[{"m", "[", 
       RowBox[{"1", ",", "3"}], "]"}], 
      RowBox[{"m", "[", 
       RowBox[{"1", ",", "4"}], "]"}]},
     {
      RowBox[{"m", "[", 
       RowBox[{"2", ",", "1"}], "]"}], 
      RowBox[{"m", "[", 
       RowBox[{"2", ",", "2"}], "]"}], 
      RowBox[{"m", "[", 
       RowBox[{"2", ",", "3"}], "]"}], 
      RowBox[{"m", "[", 
       RowBox[{"2", ",", "4"}], "]"}]},
     {
      RowBox[{"m", "[", 
       RowBox[{"3", ",", "1"}], "]"}], 
      RowBox[{"m", "[", 
       RowBox[{"3", ",", "2"}], "]"}], 
      RowBox[{"m", "[", 
       RowBox[{"3", ",", "3"}], "]"}], 
      RowBox[{"m", "[", 
       RowBox[{"3", ",", "4"}], "]"}]},
     {
      RowBox[{"m", "[", 
       RowBox[{"4", ",", "1"}], "]"}], 
      RowBox[{"m", "[", 
       RowBox[{"4", ",", "2"}], "]"}], 
      RowBox[{"m", "[", 
       RowBox[{"4", ",", "3"}], "]"}], 
      RowBox[{"m", "[", 
       RowBox[{"4", ",", "4"}], "]"}]}
     }], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabel->"Out[8]//MatrixForm= ",
 CellTags->"S5.48.1"]
}, Open  ]],

Cell[TextData[{
 "This takes the last two rows of the matrix. The same result is obtained \
with ",
 StyleBox["Take[mat, -2]", "MR"],
 " or ",
 StyleBox["mat[[{3, 4}]]", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.48.1", "1.11"}],

Cell[CellGroupData[{

Cell["TakeRows[mat, -2]//MatrixForm", "Input",
 CellLabel->"In[9]:= ",
 CellTags->"S5.48.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"m", "[", 
       RowBox[{"3", ",", "1"}], "]"}], 
      RowBox[{"m", "[", 
       RowBox[{"3", ",", "2"}], "]"}], 
      RowBox[{"m", "[", 
       RowBox[{"3", ",", "3"}], "]"}], 
      RowBox[{"m", "[", 
       RowBox[{"3", ",", "4"}], "]"}]},
     {
      RowBox[{"m", "[", 
       RowBox[{"4", ",", "1"}], "]"}], 
      RowBox[{"m", "[", 
       RowBox[{"4", ",", "2"}], "]"}], 
      RowBox[{"m", "[", 
       RowBox[{"4", ",", "3"}], "]"}], 
      RowBox[{"m", "[", 
       RowBox[{"4", ",", "4"}], "]"}]}
     }], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabel->"Out[9]//MatrixForm= ",
 CellTags->"S5.48.1"]
}, Open  ]],

Cell[TextData[{
 "This takes the second and third columns of the matrix. The same result is \
obtained with ",
 StyleBox["Take[mat, All, {2, 3}]", "MR"],
 " or ",
 StyleBox["mat[[All, {2, 3}]]", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.48.1", "1.12"}],

Cell[CellGroupData[{

Cell["TakeColumns[mat, {2, 3}]//MatrixForm", "Input",
 CellLabel->"In[10]:= ",
 CellTags->"S5.48.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"m", "[", 
       RowBox[{"1", ",", "2"}], "]"}], 
      RowBox[{"m", "[", 
       RowBox[{"1", ",", "3"}], "]"}]},
     {
      RowBox[{"m", "[", 
       RowBox[{"2", ",", "2"}], "]"}], 
      RowBox[{"m", "[", 
       RowBox[{"2", ",", "3"}], "]"}]},
     {
      RowBox[{"m", "[", 
       RowBox[{"3", ",", "2"}], "]"}], 
      RowBox[{"m", "[", 
       RowBox[{"3", ",", "3"}], "]"}]},
     {
      RowBox[{"m", "[", 
       RowBox[{"4", ",", "2"}], "]"}], 
      RowBox[{"m", "[", 
       RowBox[{"4", ",", "3"}], "]"}]}
     }], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabel->"Out[10]//MatrixForm= ",
 CellTags->"S5.48.1"]
}, Open  ]],

Cell[TextData[{
 "Here are the first three columns. The same result is obtained with ",
 StyleBox["Take[mat, All, 3]", "MR"],
 " or ",
 StyleBox["mat[[All, {1, 2, 3}]]", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.48.1", "1.13"}],

Cell[CellGroupData[{

Cell["TakeColumns[mat, 3]//MatrixForm", "Input",
 CellLabel->"In[11]:= ",
 CellTags->"S5.48.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"m", "[", 
       RowBox[{"1", ",", "1"}], "]"}], 
      RowBox[{"m", "[", 
       RowBox[{"1", ",", "2"}], "]"}], 
      RowBox[{"m", "[", 
       RowBox[{"1", ",", "3"}], "]"}]},
     {
      RowBox[{"m", "[", 
       RowBox[{"2", ",", "1"}], "]"}], 
      RowBox[{"m", "[", 
       RowBox[{"2", ",", "2"}], "]"}], 
      RowBox[{"m", "[", 
       RowBox[{"2", ",", "3"}], "]"}]},
     {
      RowBox[{"m", "[", 
       RowBox[{"3", ",", "1"}], "]"}], 
      RowBox[{"m", "[", 
       RowBox[{"3", ",", "2"}], "]"}], 
      RowBox[{"m", "[", 
       RowBox[{"3", ",", "3"}], "]"}]},
     {
      RowBox[{"m", "[", 
       RowBox[{"4", ",", "1"}], "]"}], 
      RowBox[{"m", "[", 
       RowBox[{"4", ",", "2"}], "]"}], 
      RowBox[{"m", "[", 
       RowBox[{"4", ",", "3"}], "]"}]}
     }], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabel->"Out[11]//MatrixForm= ",
 CellTags->"S5.48.1"]
}, Open  ]],

Cell[TextData[{
 "This takes the submatrix between the element at position ",
 StyleBox["{2, 3}", "MR"],
 " and the element at position ",
 StyleBox["{4, 4}", "MR"],
 ". The same result is obtained with ",
 StyleBox["Take[mat, {2, 4}, {3, 4}]", "MR"],
 " or ",
 StyleBox["mat[[{2, 3, 4}, {3, 4}]]", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.48.1", "1.14"}],

Cell[CellGroupData[{

Cell["TakeMatrix[mat, {2, 3}, {4, 4}]//MatrixForm", "Input",
 CellLabel->"In[12]:= ",
 CellTags->"S5.48.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"m", "[", 
       RowBox[{"2", ",", "3"}], "]"}], 
      RowBox[{"m", "[", 
       RowBox[{"2", ",", "4"}], "]"}]},
     {
      RowBox[{"m", "[", 
       RowBox[{"3", ",", "3"}], "]"}], 
      RowBox[{"m", "[", 
       RowBox[{"3", ",", "4"}], "]"}]},
     {
      RowBox[{"m", "[", 
       RowBox[{"4", ",", "3"}], "]"}], 
      RowBox[{"m", "[", 
       RowBox[{"4", ",", "4"}], "]"}]}
     }], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabel->"Out[12]//MatrixForm= ",
 CellTags->"S5.48.1"]
}, Open  ]],

Cell[TextData[{
 "Here is the same submatrix, specified as a ",
 Cell[BoxData[
  FormBox[
   RowBox[{"3", "\[Cross]", "2"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " matrix starting with the element at position ",
 StyleBox["{2, 3}", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.48.1", "1.15"}],

Cell[CellGroupData[{

Cell["SubMatrix[mat, {2, 3}, {3, 2}]//MatrixForm", "Input",
 CellLabel->"In[13]:= ",
 CellTags->"S5.48.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"m", "[", 
       RowBox[{"2", ",", "3"}], "]"}], 
      RowBox[{"m", "[", 
       RowBox[{"2", ",", "4"}], "]"}]},
     {
      RowBox[{"m", "[", 
       RowBox[{"3", ",", "3"}], "]"}], 
      RowBox[{"m", "[", 
       RowBox[{"3", ",", "4"}], "]"}]},
     {
      RowBox[{"m", "[", 
       RowBox[{"4", ",", "3"}], "]"}], 
      RowBox[{"m", "[", 
       RowBox[{"4", ",", "4"}], "]"}]}
     }], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabel->"Out[13]//MatrixForm= ",
 CellTags->"S5.48.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["SquareMatrixQ[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["mat", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["test whether ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["mat", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is a square matrix ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.48.1"],

Cell["Square matrix test. ", "Caption",
 CellTags->"S5.48.1"],

Cell[TextData[{
 "You can test whether matrices ",
 StyleBox["a", "MR"],
 ", ",
 StyleBox["b", "MR"],
 ", and ",
 StyleBox["mat", "MR"],
 " are square. "
}], "MathCaption",
 CellTags->{"S5.48.1", "1.16"}],

Cell[CellGroupData[{

Cell["Map[SquareMatrixQ, {a, b, mat}]", "Input",
 CellLabel->"In[14]:= ",
 CellTags->"S5.48.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True", ",", "True"}], "}"}]], "Output",
 CellLabel->"Out[14]= ",
 CellTags->"S5.48.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["UpperDiagonalMatrix[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["create an ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["n",
          "TI"], "\[Cross]", 
         StyleBox["n",
          "TI"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" matrix with elements ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["i", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["j", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" above the diagonal",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["LowerDiagonalMatrix[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["create an ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["n",
          "TI"], "\[Cross]", 
         StyleBox["n",
          "TI"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" matrix with elements ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["i", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["j", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" below the diagonal",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["TridiagonalMatrix[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["create an ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["n",
          "TI"], "\[Cross]", 
         StyleBox["n",
          "TI"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" matrix with elements ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["i", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["j", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" on the diagonals",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ZeroMatrix[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["create an ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["n",
          "TI"], "\[Cross]", 
         StyleBox["n",
          "TI"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" matrix of zeros",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ZeroMatrix[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["m", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["create an ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["m",
          "TI"], "\[Cross]", 
         StyleBox["n",
          "TI"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" matrix of zeros",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["HilbertMatrix[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["create an ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["n",
          "TI"], "\[Cross]", 
         StyleBox["n",
          "TI"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" Hilbert matrix, with elements given by ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{
           StyleBox["i",
            "TI"], "+", 
           StyleBox["j",
            "TI"], "-", "1"}], ")"}]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["HilbertMatrix[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["m", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["create an ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["m",
          "TI"], "\[Cross]", 
         StyleBox["n",
          "TI"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" Hilbert matrix",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["HankelMatrix[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["create an ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["n",
          "TI"], "\[Cross]", 
         StyleBox["n",
          "TI"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" Hankel matrix with the first column given by ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["1", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["2", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["\[Ellipsis]", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["n",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and zeros beneath the main antidiagonal",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["HankelMatrix[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["list", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["create a Hankel matrix with the first column given by ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["list", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and zeros beneath the main antidiagonal",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["HankelMatrix[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["col", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["row", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "create a Hankel matrix with the first column given by the list ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["col", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and the last row given by the list ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["row", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.48.1"],

Cell["Special matrices. ", "Caption",
 CellTags->"S5.48.1"],

Cell[TextData[{
 "Here is an upper diagonal matrix with elements ",
 StyleBox["f[", "MR"],
 StyleBox["i", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["j", "TI"],
 StyleBox["]", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.48.1", "1.17"}],

Cell[CellGroupData[{

Cell["UpperDiagonalMatrix[f, 3]//MatrixForm", "Input",
 CellLabel->"In[15]:= ",
 CellTags->"S5.48.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"f", "[", 
       RowBox[{"1", ",", "1"}], "]"}], 
      RowBox[{"f", "[", 
       RowBox[{"1", ",", "2"}], "]"}], 
      RowBox[{"f", "[", 
       RowBox[{"1", ",", "3"}], "]"}]},
     {"0", 
      RowBox[{"f", "[", 
       RowBox[{"2", ",", "2"}], "]"}], 
      RowBox[{"f", "[", 
       RowBox[{"2", ",", "3"}], "]"}]},
     {"0", "0", 
      RowBox[{"f", "[", 
       RowBox[{"3", ",", "3"}], "]"}]}
     }], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabel->"Out[15]//MatrixForm= ",
 CellTags->"S5.48.1"]
}, Open  ]],

Cell["Matrix elements can be specified using a pure function. ", "MathCaption",
 CellTags->{"S5.48.1", "1.18"}],

Cell[CellGroupData[{

Cell["LowerDiagonalMatrix[#1 + #2 &, 3]//MatrixForm", "Input",
 CellLabel->"In[16]:= ",
 CellTags->"S5.48.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"2", "0", "0"},
     {"3", "4", "0"},
     {"4", "5", "6"}
     }], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabel->"Out[16]//MatrixForm= ",
 CellTags->"S5.48.1"]
}, Open  ]],

Cell["\<\
Tridiagonal matrices can be constructed with a similar syntax. \
\>", "MathCaption",
 CellTags->{"S5.48.1", "1.19"}],

Cell[CellGroupData[{

Cell["TridiagonalMatrix[Plus, 4]//MatrixForm", "Input",
 CellLabel->"In[17]:= ",
 CellTags->"S5.48.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"2", "3", "0", "0"},
     {"3", "4", "5", "0"},
     {"0", "5", "6", "7"},
     {"0", "0", "7", "8"}
     }], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabel->"Out[17]//MatrixForm= ",
 CellTags->"S5.48.1"]
}, Open  ]],

Cell[TextData[{
 "Here is a ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", "\[Cross]", "4"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " Hilbert matrix. "
}], "MathCaption",
 CellTags->{"S5.48.1", "1.20"}],

Cell[CellGroupData[{

Cell["HilbertMatrix[2, 4]//MatrixForm", "Input",
 CellLabel->"In[18]:= ",
 CellTags->"S5.48.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", 
      FractionBox["1", "2"], 
      FractionBox["1", "3"], 
      FractionBox["1", "4"]},
     {
      FractionBox["1", "2"], 
      FractionBox["1", "3"], 
      FractionBox["1", "4"], 
      FractionBox["1", "5"]}
     }], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabel->"Out[18]//MatrixForm= ",
 CellTags->"S5.48.1"]
}, Open  ]],

Cell["The elements of the Hankel matrix can be given as a list. ", \
"MathCaption",
 CellTags->{"S5.48.1", "1.21"}],

Cell[CellGroupData[{

Cell["HankelMatrix[{w, x, y, z}]//MatrixForm", "Input",
 CellLabel->"In[19]:= ",
 CellTags->"S5.48.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"w", "x", "y", "z"},
     {"x", "y", "z", "0"},
     {"y", "z", "0", "0"},
     {"z", "0", "0", "0"}
     }], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabel->"Out[19]//MatrixForm= ",
 CellTags->"S5.48.1"]
}, Open  ]],

Cell["\<\
The Hankel matrix can be filled with nonzero values by giving the final row. \
This also allows a non\[Hyphen]square matrix to be generated. Note that the \
last element of the first column and the first element of the final row must \
be identical. \
\>", "MathCaption",
 CellTags->{"S5.48.1", "1.22"}],

Cell[CellGroupData[{

Cell["HankelMatrix[{w, x, y, z}, {z, m, n}]//MatrixForm", "Input",
 CellLabel->"In[20]:= ",
 CellTags->"S5.48.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"w", "x", "y"},
     {"x", "y", "z"},
     {"y", "z", "m"},
     {"z", "m", "n"}
     }], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabel->"Out[20]//MatrixForm= ",
 CellTags->"S5.48.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["LinearEquationsToMatrices[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["eqns", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["vars", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give a list of the form ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["mat", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["vec", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", where ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["mat", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[
      " is the matrix of coefficients of the linear equations in the \
specified variables, and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["vec", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is the vector of right\[Hyphen]hand sides ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.48.1"],

Cell["Creating matrices from a set of linear equations. ", "Caption",
 CellTags->"S5.48.1"],

Cell["\<\
This extracts the matrix of coefficients and the vector of right\[Hyphen]hand \
sides from a list of linear equations. \
\>", "MathCaption",
 CellTags->{"S5.48.1", "1.23"}],

Cell[CellGroupData[{

Cell["\<\
LinearEquationsToMatrices[
        {a11 x + a12 y == c1,
         a21 x + a22 y == c2}, {x, y}]\
\>", "Input",
 CellLabel->"In[21]:= ",
 CellTags->"S5.48.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a11", ",", "a12"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a21", ",", "a22"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c1", ",", "c2"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[21]= ",
 CellTags->"S5.48.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["PolarDecomposition[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["mat", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give a list of the form ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["u", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["s", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", where ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["s", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is a positive definite matrix, ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["u",
          "TI"], ".", 
         SuperscriptBox[
          StyleBox["u",
           "TI"], "*"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" gives the identity matrix, and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["u",
          "TI"], ".", 
         StyleBox["s",
          "TI"], "=", 
         StyleBox["m",
          "TI"], 
         StyleBox["a",
          "TI"], 
         StyleBox["t",
          "TI"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.48.1"],

Cell["Polar decomposition of a matrix. ", "Caption",
 CellTags->"S5.48.1"],

Cell[TextData[{
 "This computes the polar decomposition of a ",
 Cell[BoxData[
  FormBox[
   RowBox[{"3", "\[Cross]", "3"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " matrix, then extracts the matrices ",
 StyleBox["u", "MR"],
 " and ",
 StyleBox["s", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.48.1", "1.24"}],

Cell[CellGroupData[{

Cell["\<\
(mat = {{2., 0, 0}, {3., 4., 0}, {4., 5., 6.}};
{u, s} = PolarDecomposition[mat])\
\>", "Input",
 CellLabel->"In[22]:= ",
 CellTags->"S5.48.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.8771662257084577`", ",", 
       RowBox[{"-", "0.4714911206502558`"}], ",", 
       RowBox[{"-", "0.0909699710033196`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.3727670972621749`", ",", "0.7880308429682144`", ",", 
       RowBox[{"-", "0.4899511013657773`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.30269473678131675`", ",", "0.39585794633778937`", ",", 
       "0.8669904166979686`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "4.083412690328711`", ",", "3.004542072955287`", ",", 
       "1.816168420687904`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "3.0045420729552874`", ",", "5.131413103561801`", ",", 
       "2.375147678026735`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1.816168420687904`", ",", "2.375147678026734`", ",", 
       "5.201942500187811`"}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[22]= ",
 CellTags->"S5.48.1"]
}, Open  ]],

Cell["This gives the identity matrix. ", "MathCaption",
 CellTags->{"S5.48.1", "1.25"}],

Cell[CellGroupData[{

Cell["u . Transpose[Conjugate[u]] // Chop", "Input",
 CellLabel->"In[23]:= ",
 CellTags->"S5.48.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.9999999999999998`", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1.0000000000000004`", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1.`"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[23]= ",
 CellTags->"S5.48.1"]
}, Open  ]],

Cell["This gives the original matrix. ", "MathCaption",
 CellTags->{"S5.48.1", "1.26"}],

Cell[CellGroupData[{

Cell["u . s // Chop", "Input",
 CellLabel->"In[24]:= ",
 CellTags->"S5.48.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2.`", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.`", ",", "4.`", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.9999999999999996`", ",", "5.`", ",", "6.`"}], "}"}]}], 
  "}"}]], "Output",
 CellLabel->"Out[24]= ",
 CellTags->"S5.48.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["LUMatrices[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["lu", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give a list of the form ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["l", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["u", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", where ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["l",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["u",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[
      " are the lower and upper matrices of the LU decomposition of matrix ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["mat", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["lu", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is the first element of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["LUDecomposition[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["mat", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.48.1"],

Cell["LU decomposition of a matrix. ", "Caption",
 CellTags->"S5.48.1"],

Cell[TextData[{
 "This computes the LU decomposition of a ",
 Cell[BoxData[
  FormBox[
   RowBox[{"3", "\[Cross]", "3"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " matrix, returning a combination of the lower and upper triangular \
matrices, a pivot permutation vector, and a condition number for the matrix. \
"
}], "MathCaption",
 CellTags->{"S5.48.1", "1.27"}],

Cell[CellGroupData[{

Cell["{lu, p, cn} = LUDecomposition[mat]", "Input",
 CellLabel->"In[25]:= ",
 CellTags->"S5.48.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4.`", ",", "0.5`", ",", "0.75`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5.`", ",", 
       RowBox[{"-", "2.5`"}], ",", 
       RowBox[{"-", "0.1`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6.`", ",", 
       RowBox[{"-", "3.`"}], ",", 
       RowBox[{"-", "4.8`"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1", ",", "2"}], "}"}], ",", "7.5`"}], "}"}]], "Output",\

 CellLabel->"Out[25]= ",
 CellTags->"S5.48.1"]
}, Open  ]],

Cell["\<\
This gives the lower and upper triangular matrices explicitly. \
\>", "MathCaption",
 CellTags->{"S5.48.1", "1.28"}],

Cell[CellGroupData[{

Cell["{l, u} = LUMatrices[lu]", "Input",
 CellLabel->"In[26]:= ",
 CellTags->"S5.48.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.`", ",", "0.`", ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.5`", ",", "1.`", ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.75`", ",", 
       RowBox[{"-", "0.1`"}], ",", "1.`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4.`", ",", "5.`", ",", "6.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2.5`"}], ",", 
       RowBox[{"-", "3.`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
       RowBox[{"-", "4.8`"}]}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[26]= ",
 CellTags->"S5.48.1"]
}, Open  ]],

Cell["\<\
You need to permute the original matrix to verify the decomposition. \
\>", "MathCaption",
 CellTags->{"S5.48.1", "1.29"}],

Cell[CellGroupData[{

Cell["mat[[p]] - l.u // Chop", "Input",
 CellLabel->"In[27]:= ",
 CellTags->"S5.48.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[27]= ",
 CellTags->"S5.48.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["InverseMatrixNorm[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["mat", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, False, True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["infinity\[Hyphen]norm of the inverse of matrix ",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox["mat", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, False, True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["InverseMatrixNorm[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["lu", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, False, True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "infinity\[Hyphen]norm of the inverse of a matrix having LU \
decomposition ",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox["lu", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, False, True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["InverseMatrixNorm[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["mat", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox["InverseMatrixNorm[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["lu", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, False, True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["p",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox["\[Hyphen]norm of the inverse of a matrix",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, False, True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["MatrixConditionNumber[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["mat", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, False, True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "infinity\[Hyphen]norm condition number of a matrix of approximate \
numbers ",
      GridBoxOptions->{RowLines->{False, False, True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{False, False, True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["MatrixConditionNumber[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["mat", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, False, True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["p",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox["\[Hyphen]norm condition number of a matrix, where ",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["p",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[" may be 1, 2, or ",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["\[Infinity]", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{False, False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, False, True, False},
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->{False, False, True, False},
 RowSpacings->0.4},
 CellTags->"S5.48.1"],

Cell[TextData[{
 "Functions related to ",
 StyleBox["Norm", "MR"],
 ". "
}], "Caption",
 CellTags->"S5.48.1"],

Cell[TextData[{
 StyleBox["Mathematica", "TI"],
 " defines functionality for computing norms of vectors and matrices in the \
kernel function ",
 StyleBox["Norm", "MR"],
 ". The package extends this functionality by adding some useful utilities. "
}], "Text",
 CellTags->{"S5.48.1", "1.30"}],

Cell[TextData[{
 "For the norm of the inverse of a matrix, you can explicitly compute the \
norm of the inverse of ",
 StyleBox["mat", "TI"],
 ", but asymptotically, it is about three times faster to work with the LU \
decomposition of ",
 StyleBox["mat", "TI"],
 ". Hence, either ",
 StyleBox["mat", "TI"],
 " or the LU decomposition of ",
 StyleBox["mat", "TI"],
 " may be an argument to ",
 StyleBox["InverseMatrixNorm", "MR"],
 ". "
}], "Text",
 CellTags->{"S5.48.1", "1.31"}],

Cell["Here is a random matrix. ", "MathCaption",
 CellTags->{"S5.48.1", "1.32"}],

Cell["dat = Table[Random[], {500}, {500}];", "Input",
 CellLabel->"In[28]:= ",
 CellTags->"S5.48.1"],

Cell["\<\
The 2\[Hyphen]norm of the inverse can be computed directly. \
\>", "MathCaption",
 CellTags->{"S5.48.1", "1.33"}],

Cell[CellGroupData[{

Cell["Norm[Inverse[dat]]//Timing", "Input",
 CellLabel->"In[29]:= ",
 CellTags->"S5.48.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2.67`", " ", "Second"}], ",", "678.810102204134`"}], 
  "}"}]], "Output",
 CellLabel->"Out[29]= ",
 CellTags->"S5.48.1"]
}, Open  ]],

Cell["\<\
The LU\[Hyphen]decomposition can be generated. \
\>", "MathCaption",
 CellTags->{"S5.48.1", "1.34"}],

Cell["decomp = LUDecomposition[dat];", "Input",
 CellLabel->"In[30]:= ",
 CellTags->"S5.48.1"],

Cell[TextData[{
 "If we have the LU\[Hyphen]decomposition already available, computing the \
norm of the inverse can be faster than the direct call by using ",
 StyleBox["InverseMatrixNorm", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.48.1", "1.35"}],

Cell[CellGroupData[{

Cell["InverseMatrixNorm[decomp, 2]//Timing", "Input",
 CellLabel->"In[31]:= ",
 CellTags->"S5.48.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.4599999999999998`", " ", "Second"}], ",", 
   "678.8101022041338`"}], "}"}]], "Output",
 CellLabel->"Out[31]= ",
 CellTags->"S5.48.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["MatrixPlot[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["mat", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["show the structure of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["mat", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["MatrixPlot[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["mat", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["cen", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["show ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["mat", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" with center value ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["cen", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.48.1"],

Cell["Displaying matrix structure. ", "Caption",
 CellTags->"S5.48.1"],

Cell[TextData[{
 "Matrix structure can be graphically displayed via the ",
 StyleBox["MatrixPlot", "MR"],
 " functionality. The array is shown as a grid of black and white cells, by \
default representing zero\[Hyphen]valued cells as white, and non\[Hyphen]zero \
values as black. The center value can also be specified explicitly. "
}], "Text",
 CellTags->{"S5.48.1", "1.36"}],

Cell["Display the structure of a random array. ", "MathCaption",
 CellTags->{"S5.48.1", "1.37"}],

Cell[CellGroupData[{

Cell["MatrixPlot[Table[Random[Integer], {50},{50}]]", "Input",
 CellLabel->"In[32]:= ",
 CellTags->"S5.48.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.00961538 0.0192308 0.990385 0.0192308 [
[.00962 -0.0125 -3 -9 ]
[.00962 -0.0125 3 0 ]
[.20192 -0.0125 -6 -9 ]
[.20192 -0.0125 6 0 ]
[.39423 -0.0125 -6 -9 ]
[.39423 -0.0125 6 0 ]
[.58654 -0.0125 -6 -9 ]
[.58654 -0.0125 6 0 ]
[.77885 -0.0125 -6 -9 ]
[.77885 -0.0125 6 0 ]
[.97115 -0.0125 -6 -9 ]
[.97115 -0.0125 6 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .02885 -12 -4.5 ]
[-0.0125 .02885 0 4.5 ]
[-0.0125 .22115 -12 -4.5 ]
[-0.0125 .22115 0 4.5 ]
[-0.0125 .41346 -12 -4.5 ]
[-0.0125 .41346 0 4.5 ]
[-0.0125 .60577 -12 -4.5 ]
[-0.0125 .60577 0 4.5 ]
[-0.0125 .79808 -12 -4.5 ]
[-0.0125 .79808 0 4.5 ]
[-0.0125 .99038 -6 -4.5 ]
[-0.0125 .99038 0 4.5 ]
[ 0 0 -0.125 0 ]
[.00962 1.0125 -3 0 ]
[.00962 1.0125 3 9 ]
[.20192 1.0125 -6 0 ]
[.20192 1.0125 6 9 ]
[.39423 1.0125 -6 0 ]
[.39423 1.0125 6 9 ]
[.58654 1.0125 -6 0 ]
[.58654 1.0125 6 9 ]
[.77885 1.0125 -6 0 ]
[.77885 1.0125 6 9 ]
[.97115 1.0125 -6 0 ]
[.97115 1.0125 6 9 ]
[ 0 1 .125 0 ]
[1.0125 .02885 0 -4.5 ]
[1.0125 .02885 12 4.5 ]
[1.0125 .22115 0 -4.5 ]
[1.0125 .22115 12 4.5 ]
[1.0125 .41346 0 -4.5 ]
[1.0125 .41346 12 4.5 ]
[1.0125 .60577 0 -4.5 ]
[1.0125 .60577 12 4.5 ]
[1.0125 .79808 0 -4.5 ]
[1.0125 .79808 12 4.5 ]
[1.0125 .99038 0 -4.5 ]
[1.0125 .99038 6 4.5 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.00962 0 m
.00962 .00625 L
s
[(0)] .00962 -0.0125 0 1 Mshowa
.20192 0 m
.20192 .00625 L
s
[(10)] .20192 -0.0125 0 1 Mshowa
.39423 0 m
.39423 .00625 L
s
[(20)] .39423 -0.0125 0 1 Mshowa
.58654 0 m
.58654 .00625 L
s
[(30)] .58654 -0.0125 0 1 Mshowa
.77885 0 m
.77885 .00625 L
s
[(40)] .77885 -0.0125 0 1 Mshowa
.97115 0 m
.97115 .00625 L
s
[(50)] .97115 -0.0125 0 1 Mshowa
0 0 m
1 0 L
s
0 .02885 m
.00625 .02885 L
s
[(50)] -0.0125 .02885 1 0 Mshowa
0 .22115 m
.00625 .22115 L
s
[(40)] -0.0125 .22115 1 0 Mshowa
0 .41346 m
.00625 .41346 L
s
[(30)] -0.0125 .41346 1 0 Mshowa
0 .60577 m
.00625 .60577 L
s
[(20)] -0.0125 .60577 1 0 Mshowa
0 .79808 m
.00625 .79808 L
s
[(10)] -0.0125 .79808 1 0 Mshowa
0 .99038 m
.00625 .99038 L
s
[(0)] -0.0125 .99038 1 0 Mshowa
0 0 m
0 1 L
s
.00962 .99375 m
.00962 1 L
s
[(0)] .00962 1.0125 0 -1 Mshowa
.20192 .99375 m
.20192 1 L
s
[(10)] .20192 1.0125 0 -1 Mshowa
.39423 .99375 m
.39423 1 L
s
[(20)] .39423 1.0125 0 -1 Mshowa
.58654 .99375 m
.58654 1 L
s
[(30)] .58654 1.0125 0 -1 Mshowa
.77885 .99375 m
.77885 1 L
s
[(40)] .77885 1.0125 0 -1 Mshowa
.97115 .99375 m
.97115 1 L
s
[(50)] .97115 1.0125 0 -1 Mshowa
0 1 m
1 1 L
s
.99375 .02885 m
1 .02885 L
s
[(50)] 1.0125 .02885 -1 0 Mshowa
.99375 .22115 m
1 .22115 L
s
[(40)] 1.0125 .22115 -1 0 Mshowa
.99375 .41346 m
1 .41346 L
s
[(30)] 1.0125 .41346 -1 0 Mshowa
.99375 .60577 m
1 .60577 L
s
[(20)] 1.0125 .60577 -1 0 Mshowa
.99375 .79808 m
1 .79808 L
s
[(10)] 1.0125 .79808 -1 0 Mshowa
.99375 .99038 m
1 .99038 L
s
[(0)] 1.0125 .99038 -1 0 Mshowa
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
50 string
50 50 8 [50 0 0 50 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FFFF00FFFFFF00FF00000000FFFFFF00FF0000FF00FFFF00FF00FFFFFF000000FFFF0000
00FFFFFFFF0000FF00FF0000FFFF
000000FF00FF00FFFFFF00FFFFFFFFFF000000FFFF000000000000FFFFFFFFFFFF0000FF
FF00FF000000000000FFFF00FF00
FFFFFFFF00FF0000000000FFFF000000FF00FFFFFF0000FF0000FF0000FF0000000000FF
FF00FFFFFF0000FFFFFFFFFFFFFF
00FFFFFF00FFFF000000FFFFFF0000FFFF0000FF000000FFFFFF00FF00FF00FF000000FF
0000FF00FFFFFFFF0000FFFFFFFF
00FFFF00FF00FF0000FF00000000FF00FF00FF0000FF0000FF00FFFF00FFFFFF000000FF
FF000000FFFF00FFFF000000FF00
FF0000000000000000000000FFFF00FFFFFF00000000000000FF00FFFFFFFF0000000000
FF00FFFFFF0000FFFFFFFFFF0000
FFFF0000FF0000FFFF00FF000000FF00FFFF00FF00FF00FFFF00FFFF00FF00FFFFFFFFFF
FF0000000000FF00FFFFFFFFFF00
00FF0000FF00FFFFFF00FF00FF0000FF00FFFFFFFFFFFFFF0000FF000000FFFF00FFFFFF
FF0000FFFF00000000FFFFFFFF00
FFFFFF0000FFFF0000FF00FF00FFFFFFFF00FF00FFFF0000FFFFFF0000000000FFFF00FF
0000FFFFFFFFFF0000FF0000FF00
0000FF00FFFFFF000000FF00FF00FF0000FF00FF00FF00FFFFFF0000FFFF00FFFFFFFF00
00FF00FFFFFFFF0000FF00000000
00FF00FFFFFF00000000FFFFFF000000FFFF0000000000FFFF00FF00FF00FFFF000000FF
00FF00FFFFFF00FFFF0000FFFF00
0000FF00FF00FFFF000000FF00000000FFFFFFFF00FF00FFFFFFFF000000000000FFFFFF
00FFFFFF0000000000FFFF0000FF
00FF0000FFFF00FFFF00000000FF00FFFF000000000000FFFF00FF00FF00FFFF00000000
00FF00FF0000FF00FFFFFFFFFFFF
FFFF00FF00FFFFFFFF000000FFFF00FFFF00FFFF0000FFFF00FF00FFFFFF00FF00FF00FF
FFFF00000000FF0000FFFF0000FF
FF0000FF00FF0000FFFF00FFFF00FFFFFF000000FFFFFFFF00FFFF00FF00000000FFFFFF
FFFF0000000000FFFFFFFFFFFFFF
00FFFFFFFF00000000FFFFFFFF00FFFF00FFFFFFFF0000FF00FF0000FFFFFFFF0000FFFF
FF00FFFF0000FF000000FFFFFFFF
00000000FFFF00FF0000FFFFFFFF00FFFF00FFFFFF00FF000000000000FF000000FF0000
00FF00FFFFFFFF0000FF00FFFFFF
00FF00FF00FF00FF000000FF000000FF00FFFFFF00FFFFFFFF00FF0000FFFF00FF00FFFF
FF00FFFFFF00FFFFFFFF00000000
FF0000FF00FF00000000FF00000000FFFF0000FF00FFFF0000000000000000FFFFFFFFFF
FF0000FF0000FFFFFFFF00FF00FF
000000FFFF000000000000000000FFFFFF0000FFFFFF0000FF00000000FF00000000FFFF
00FF00FF0000FFFFFF00FFFFFFFF
00FF00FF0000FF00FFFFFFFF00FFFF000000000000FF0000FFFF000000FFFFFFFFFFFFFF
00FFFFFFFF00FF0000FF0000FF00
FFFF000000FFFFFF00FF0000FF00FF00FF000000FF00FFFFFF0000FFFFFFFF0000FF00FF
0000FF00FF00FF0000FFFFFFFFFF
00FF00FF000000000000000000FF0000FFFF0000FF0000FF00FF00FFFFFF00FFFF000000
FFFFFF0000FFFFFFFFFF00FFFF00
FF0000FF000000000000FFFF0000FF00FF00FF0000FFFFFF000000000000FFFF0000FFFF
00000000FF000000000000FF0000
FFFF00FF00FFFF00FFFF00FF00FFFF000000FFFFFF00FF0000FF00FFFF00FFFF00FF0000
FF00FF00FFFFFFFFFF0000FFFFFF
00FFFF00FFFF000000FF000000FF000000FFFF0000FF0000FFFF00FFFF0000FFFFFFFF00
00FFFFFF0000000000FF0000FFFF
FF00FFFF00FFFF00000000FF00000000FFFF00FFFFFFFF00000000FFFF00FF00FF00FF00
FFFF00FFFF00FF00FF00000000FF
0000FFFF00FF0000FFFF00FFFFFFFFFFFF00FF00FFFF0000FF00FF00FF0000FF0000FF00
00000000FF00FFFF00FFFF00FFFF
FFFFFFFFFFFF0000FFFF00FF0000FFFFFF0000FF00000000FF00FF00FFFF00FFFFFFFF00
0000FF0000FFFF000000FF00FFFF
FF0000FF00FFFF00FFFFFF00000000FF000000FFFF0000FFFFFFFF0000FF0000000000FF
FF00FF00FFFFFFFFFF00FFFFFFFF
FF0000FFFFFF00FF00000000FF00FFFFFFFFFF00FF000000000000000000000000000000
FF000000FFFF00FFFF00000000FF
FF000000FFFF00FFFFFF0000FFFF00FFFFFF00FF00FF00FFFFFFFFFFFFFFFF00FFFF00FF
FFFFFF00FF00FF00000000000000
0000FFFFFFFF000000FFFF000000FFFF000000FF00FFFFFFFF00FF00FF000000FFFFFF00
FFFFFF0000FF00FF000000FF0000
FF00FF0000FFFFFF0000FFFFFFFFFF00000000FFFFFFFF00FFFFFF00FF0000FFFF00FF00
0000FF00FFFFFFFFFFFF00FF0000
FF0000FFFFFF0000FF00FFFF0000000000FF0000FF000000FF00FF0000FFFFFFFFFFFFFF
FF000000FF0000FF00FF00000000
FF0000FFFFFF00FFFF0000000000FFFF000000000000FF0000FF00FFFFFF00FF00FFFFFF
FFFFFF00FFFFFF00FF00FF00FFFF
FF00FFFF00FF0000FFFFFF00FFFF000000000000FF00FF00000000000000FF000000FF00
FFFFFFFFFF00FF00FF0000FFFF00
00FFFF00FFFFFFFF00FF000000000000FF00FF0000FF00000000000000FFFF0000FF0000
FFFFFF00000000FF00FFFFFFFFFF
FF00000000FFFF0000FF0000FFFFFFFFFF0000FFFFFFFFFF000000FF0000000000FF00FF
00FF0000FFFF00FFFF00FFFF00FF
FF00FFFF0000000000FF00FFFFFF000000FFFF0000FF000000FFFFFF00FFFF0000FF00FF
FFFF0000FFFFFF0000000000FFFF
00FF00FF0000FF00FFFFFFFFFF0000FFFF00FFFFFFFF00FF00FFFFFFFFFF00000000FFFF
FF00FFFF000000FFFFFFFFFFFF00
FF0000FFFF0000FF00000000FFFF0000FFFFFFFFFF00FF00FF00FF00FFFFFF000000FFFF
00000000FFFFFF0000FF0000FF00
00FF00FFFF000000FFFF0000FF00FF000000FF0000000000FF00FF00FFFF00FFFF00FFFF
0000FFFF000000FF00000000FFFF
FF00FF0000FF00000000FFFF000000FF00FF00FFFFFF0000FF00000000FFFF00FFFFFF00
000000000000FFFFFFFF00FFFFFF
00FF000000FFFFFF00FF0000FFFF0000FF00FF00FFFFFF0000FF00FF0000FF000000FFFF
00FF00FFFFFFFF00000000FFFFFF
00FFFFFF00FF00FFFFFFFFFF0000FFFF0000FF000000FF0000FF0000FF0000FF00000000
FFFFFF0000FFFF00000000FF00FF
00FFFF00FFFFFF00FFFF00FFFF0000FF00FF0000FF00000000FF00FF00FF0000FF0000FF
0000FFFF0000FFFF00FF00FFFF00
00FF0000000000FF00FFFF00FFFFFF000000FF00FF0000FFFF0000FFFF0000FFFFFF00FF
FFFF00FFFF00FF00FFFFFFFF0000
FF00FFFF00FF00FF0000FF00FFFF00000000FF0000FF00000000FF0000FF00FFFF00FF00
FF0000FFFF00000000000000FFFF
FF000000FF0000FF00FF00FFFF00FFFF00FF00FF00FFFFFFFFFFFFFFFF0000000000FFFF
00FF00FF000000FF00FFFFFFFFFF
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.48.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "DensityGraphics", "\[SkeletonIndicator]"}],
  
  False,
  Editable->False]], "Output",
 CellLabel->"Out[32]= ",
 CellTags->"S5.48.1"]
}, Open  ]],

Cell["Set up a sparse array. ", "MathCaption",
 CellTags->{"S5.48.1", "1.38"}],

Cell[CellGroupData[{

Cell["idsparse = SparseArray[IdentityMatrix[100]]", "Input",
 CellLabel->"In[33]:= ",
 CellTags->"S5.48.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "100", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 100, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"100", ",", "100"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[33]= ",
 CellTags->"S5.48.1"]
}, Open  ]],

Cell[TextData[{
 StyleBox["MatrixPlot", "MR"],
 " is effective in displaying sparse array structure. "
}], "MathCaption",
 CellTags->{"S5.48.1", "1.39"}],

Cell[CellGroupData[{

Cell["MatrixPlot[idsparse]", "Input",
 CellLabel->"In[34]:= ",
 CellTags->"S5.48.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0144231 0.00961538 0.985577 0.00961538 [
[.01442 -0.0125 -3 -9 ]
[.01442 -0.0125 3 0 ]
[.20673 -0.0125 -6 -9 ]
[.20673 -0.0125 6 0 ]
[.39904 -0.0125 -6 -9 ]
[.39904 -0.0125 6 0 ]
[.59135 -0.0125 -6 -9 ]
[.59135 -0.0125 6 0 ]
[.78365 -0.0125 -6 -9 ]
[.78365 -0.0125 6 0 ]
[.97596 -0.0125 -9 -9 ]
[.97596 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .02404 -18 -4.5 ]
[-0.0125 .02404 0 4.5 ]
[-0.0125 .21635 -12 -4.5 ]
[-0.0125 .21635 0 4.5 ]
[-0.0125 .40865 -12 -4.5 ]
[-0.0125 .40865 0 4.5 ]
[-0.0125 .60096 -12 -4.5 ]
[-0.0125 .60096 0 4.5 ]
[-0.0125 .79327 -12 -4.5 ]
[-0.0125 .79327 0 4.5 ]
[-0.0125 .98558 -6 -4.5 ]
[-0.0125 .98558 0 4.5 ]
[ 0 0 -0.125 0 ]
[.01442 1.0125 -3 0 ]
[.01442 1.0125 3 9 ]
[.20673 1.0125 -6 0 ]
[.20673 1.0125 6 9 ]
[.39904 1.0125 -6 0 ]
[.39904 1.0125 6 9 ]
[.59135 1.0125 -6 0 ]
[.59135 1.0125 6 9 ]
[.78365 1.0125 -6 0 ]
[.78365 1.0125 6 9 ]
[.97596 1.0125 -9 0 ]
[.97596 1.0125 9 9 ]
[ 0 1 .125 0 ]
[1.0125 .02404 0 -4.5 ]
[1.0125 .02404 18 4.5 ]
[1.0125 .21635 0 -4.5 ]
[1.0125 .21635 12 4.5 ]
[1.0125 .40865 0 -4.5 ]
[1.0125 .40865 12 4.5 ]
[1.0125 .60096 0 -4.5 ]
[1.0125 .60096 12 4.5 ]
[1.0125 .79327 0 -4.5 ]
[1.0125 .79327 12 4.5 ]
[1.0125 .98558 0 -4.5 ]
[1.0125 .98558 6 4.5 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01442 0 m
.01442 .00625 L
s
[(0)] .01442 -0.0125 0 1 Mshowa
.20673 0 m
.20673 .00625 L
s
[(20)] .20673 -0.0125 0 1 Mshowa
.39904 0 m
.39904 .00625 L
s
[(40)] .39904 -0.0125 0 1 Mshowa
.59135 0 m
.59135 .00625 L
s
[(60)] .59135 -0.0125 0 1 Mshowa
.78365 0 m
.78365 .00625 L
s
[(80)] .78365 -0.0125 0 1 Mshowa
.97596 0 m
.97596 .00625 L
s
[(100)] .97596 -0.0125 0 1 Mshowa
0 0 m
1 0 L
s
0 .02404 m
.00625 .02404 L
s
[(100)] -0.0125 .02404 1 0 Mshowa
0 .21635 m
.00625 .21635 L
s
[(80)] -0.0125 .21635 1 0 Mshowa
0 .40865 m
.00625 .40865 L
s
[(60)] -0.0125 .40865 1 0 Mshowa
0 .60096 m
.00625 .60096 L
s
[(40)] -0.0125 .60096 1 0 Mshowa
0 .79327 m
.00625 .79327 L
s
[(20)] -0.0125 .79327 1 0 Mshowa
0 .98558 m
.00625 .98558 L
s
[(0)] -0.0125 .98558 1 0 Mshowa
0 0 m
0 1 L
s
.01442 .99375 m
.01442 1 L
s
[(0)] .01442 1.0125 0 -1 Mshowa
.20673 .99375 m
.20673 1 L
s
[(20)] .20673 1.0125 0 -1 Mshowa
.39904 .99375 m
.39904 1 L
s
[(40)] .39904 1.0125 0 -1 Mshowa
.59135 .99375 m
.59135 1 L
s
[(60)] .59135 1.0125 0 -1 Mshowa
.78365 .99375 m
.78365 1 L
s
[(80)] .78365 1.0125 0 -1 Mshowa
.97596 .99375 m
.97596 1 L
s
[(100)] .97596 1.0125 0 -1 Mshowa
0 1 m
1 1 L
s
.99375 .02404 m
1 .02404 L
s
[(100)] 1.0125 .02404 -1 0 Mshowa
.99375 .21635 m
1 .21635 L
s
[(80)] 1.0125 .21635 -1 0 Mshowa
.99375 .40865 m
1 .40865 L
s
[(60)] 1.0125 .40865 -1 0 Mshowa
.99375 .60096 m
1 .60096 L
s
[(40)] 1.0125 .60096 -1 0 Mshowa
.99375 .79327 m
1 .79327 L
s
[(20)] 1.0125 .79327 -1 0 Mshowa
.99375 .98558 m
1 .98558 L
s
[(0)] 1.0125 .98558 -1 0 Mshowa
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
1 g
.01923 .01923 m
.01923 .98077 L
.98077 .98077 L
.98077 .01923 L
F
0 g
.97115 .01923 m
.97115 .02885 L
.98077 .02885 L
.98077 .01923 L
F
.96154 .02885 m
.96154 .03846 L
.97115 .03846 L
.97115 .02885 L
F
.95192 .03846 m
.95192 .04808 L
.96154 .04808 L
.96154 .03846 L
F
.94231 .04808 m
.94231 .05769 L
.95192 .05769 L
.95192 .04808 L
F
.93269 .05769 m
.93269 .06731 L
.94231 .06731 L
.94231 .05769 L
F
.92308 .06731 m
.92308 .07692 L
.93269 .07692 L
.93269 .06731 L
F
.91346 .07692 m
.91346 .08654 L
.92308 .08654 L
.92308 .07692 L
F
.90385 .08654 m
.90385 .09615 L
.91346 .09615 L
.91346 .08654 L
F
.89423 .09615 m
.89423 .10577 L
.90385 .10577 L
.90385 .09615 L
F
.88462 .10577 m
.88462 .11538 L
.89423 .11538 L
.89423 .10577 L
F
.875 .11538 m
.875 .125 L
.88462 .125 L
.88462 .11538 L
F
.86538 .125 m
.86538 .13462 L
.875 .13462 L
.875 .125 L
F
.85577 .13462 m
.85577 .14423 L
.86538 .14423 L
.86538 .13462 L
F
.84615 .14423 m
.84615 .15385 L
.85577 .15385 L
.85577 .14423 L
F
.83654 .15385 m
.83654 .16346 L
.84615 .16346 L
.84615 .15385 L
F
.82692 .16346 m
.82692 .17308 L
.83654 .17308 L
.83654 .16346 L
F
.81731 .17308 m
.81731 .18269 L
.82692 .18269 L
.82692 .17308 L
F
.80769 .18269 m
.80769 .19231 L
.81731 .19231 L
.81731 .18269 L
F
.79808 .19231 m
.79808 .20192 L
.80769 .20192 L
.80769 .19231 L
F
.78846 .20192 m
.78846 .21154 L
.79808 .21154 L
.79808 .20192 L
F
.77885 .21154 m
.77885 .22115 L
.78846 .22115 L
.78846 .21154 L
F
.76923 .22115 m
.76923 .23077 L
.77885 .23077 L
.77885 .22115 L
F
.75962 .23077 m
.75962 .24038 L
.76923 .24038 L
.76923 .23077 L
F
.75 .24038 m
.75 .25 L
.75962 .25 L
.75962 .24038 L
F
.74038 .25 m
.74038 .25962 L
.75 .25962 L
.75 .25 L
F
.73077 .25962 m
.73077 .26923 L
.74038 .26923 L
.74038 .25962 L
F
.72115 .26923 m
.72115 .27885 L
.73077 .27885 L
.73077 .26923 L
F
.71154 .27885 m
.71154 .28846 L
.72115 .28846 L
.72115 .27885 L
F
.70192 .28846 m
.70192 .29808 L
.71154 .29808 L
.71154 .28846 L
F
.69231 .29808 m
.69231 .30769 L
.70192 .30769 L
.70192 .29808 L
F
.68269 .30769 m
.68269 .31731 L
.69231 .31731 L
.69231 .30769 L
F
.67308 .31731 m
.67308 .32692 L
.68269 .32692 L
.68269 .31731 L
F
.66346 .32692 m
.66346 .33654 L
.67308 .33654 L
.67308 .32692 L
F
.65385 .33654 m
.65385 .34615 L
.66346 .34615 L
.66346 .33654 L
F
.64423 .34615 m
.64423 .35577 L
.65385 .35577 L
.65385 .34615 L
F
.63462 .35577 m
.63462 .36538 L
.64423 .36538 L
.64423 .35577 L
F
.625 .36538 m
.625 .375 L
.63462 .375 L
.63462 .36538 L
F
.61538 .375 m
.61538 .38462 L
.625 .38462 L
.625 .375 L
F
.60577 .38462 m
.60577 .39423 L
.61538 .39423 L
.61538 .38462 L
F
.59615 .39423 m
.59615 .40385 L
.60577 .40385 L
.60577 .39423 L
F
.58654 .40385 m
.58654 .41346 L
.59615 .41346 L
.59615 .40385 L
F
.57692 .41346 m
.57692 .42308 L
.58654 .42308 L
.58654 .41346 L
F
.56731 .42308 m
.56731 .43269 L
.57692 .43269 L
.57692 .42308 L
F
.55769 .43269 m
.55769 .44231 L
.56731 .44231 L
.56731 .43269 L
F
.54808 .44231 m
.54808 .45192 L
.55769 .45192 L
.55769 .44231 L
F
.53846 .45192 m
.53846 .46154 L
.54808 .46154 L
.54808 .45192 L
F
.52885 .46154 m
.52885 .47115 L
.53846 .47115 L
.53846 .46154 L
F
.51923 .47115 m
.51923 .48077 L
.52885 .48077 L
.52885 .47115 L
F
.50962 .48077 m
.50962 .49038 L
.51923 .49038 L
.51923 .48077 L
F
.5 .49038 m
.5 .5 L
.50962 .5 L
.50962 .49038 L
F
.49038 .5 m
.49038 .50962 L
.5 .50962 L
.5 .5 L
F
.48077 .50962 m
.48077 .51923 L
.49038 .51923 L
.49038 .50962 L
F
.47115 .51923 m
.47115 .52885 L
.48077 .52885 L
.48077 .51923 L
F
.46154 .52885 m
.46154 .53846 L
.47115 .53846 L
.47115 .52885 L
F
.45192 .53846 m
.45192 .54808 L
.46154 .54808 L
.46154 .53846 L
F
.44231 .54808 m
.44231 .55769 L
.45192 .55769 L
.45192 .54808 L
F
.43269 .55769 m
.43269 .56731 L
.44231 .56731 L
.44231 .55769 L
F
.42308 .56731 m
.42308 .57692 L
.43269 .57692 L
.43269 .56731 L
F
.41346 .57692 m
.41346 .58654 L
.42308 .58654 L
.42308 .57692 L
F
.40385 .58654 m
.40385 .59615 L
.41346 .59615 L
.41346 .58654 L
F
.39423 .59615 m
.39423 .60577 L
.40385 .60577 L
.40385 .59615 L
F
.38462 .60577 m
.38462 .61538 L
.39423 .61538 L
.39423 .60577 L
F
.375 .61538 m
.375 .625 L
.38462 .625 L
.38462 .61538 L
F
.36538 .625 m
.36538 .63462 L
.375 .63462 L
.375 .625 L
F
.35577 .63462 m
.35577 .64423 L
.36538 .64423 L
.36538 .63462 L
F
.34615 .64423 m
.34615 .65385 L
.35577 .65385 L
.35577 .64423 L
F
.33654 .65385 m
.33654 .66346 L
.34615 .66346 L
.34615 .65385 L
F
.32692 .66346 m
.32692 .67308 L
.33654 .67308 L
.33654 .66346 L
F
.31731 .67308 m
.31731 .68269 L
.32692 .68269 L
.32692 .67308 L
F
.30769 .68269 m
.30769 .69231 L
.31731 .69231 L
.31731 .68269 L
F
.29808 .69231 m
.29808 .70192 L
.30769 .70192 L
.30769 .69231 L
F
.28846 .70192 m
.28846 .71154 L
.29808 .71154 L
.29808 .70192 L
F
.27885 .71154 m
.27885 .72115 L
.28846 .72115 L
.28846 .71154 L
F
.26923 .72115 m
.26923 .73077 L
.27885 .73077 L
.27885 .72115 L
F
.25962 .73077 m
.25962 .74038 L
.26923 .74038 L
.26923 .73077 L
F
.25 .74038 m
.25 .75 L
.25962 .75 L
.25962 .74038 L
F
.24038 .75 m
.24038 .75962 L
.25 .75962 L
.25 .75 L
F
.23077 .75962 m
.23077 .76923 L
.24038 .76923 L
.24038 .75962 L
F
.22115 .76923 m
.22115 .77885 L
.23077 .77885 L
.23077 .76923 L
F
.21154 .77885 m
.21154 .78846 L
.22115 .78846 L
.22115 .77885 L
F
.20192 .78846 m
.20192 .79808 L
.21154 .79808 L
.21154 .78846 L
F
.19231 .79808 m
.19231 .80769 L
.20192 .80769 L
.20192 .79808 L
F
.18269 .80769 m
.18269 .81731 L
.19231 .81731 L
.19231 .80769 L
F
.17308 .81731 m
.17308 .82692 L
.18269 .82692 L
.18269 .81731 L
F
.16346 .82692 m
.16346 .83654 L
.17308 .83654 L
.17308 .82692 L
F
.15385 .83654 m
.15385 .84615 L
.16346 .84615 L
.16346 .83654 L
F
.14423 .84615 m
.14423 .85577 L
.15385 .85577 L
.15385 .84615 L
F
.13462 .85577 m
.13462 .86538 L
.14423 .86538 L
.14423 .85577 L
F
.125 .86538 m
.125 .875 L
.13462 .875 L
.13462 .86538 L
F
.11538 .875 m
.11538 .88462 L
.125 .88462 L
.125 .875 L
F
.10577 .88462 m
.10577 .89423 L
.11538 .89423 L
.11538 .88462 L
F
.09615 .89423 m
.09615 .90385 L
.10577 .90385 L
.10577 .89423 L
F
.08654 .90385 m
.08654 .91346 L
.09615 .91346 L
.09615 .90385 L
F
.07692 .91346 m
.07692 .92308 L
.08654 .92308 L
.08654 .91346 L
F
.06731 .92308 m
.06731 .93269 L
.07692 .93269 L
.07692 .92308 L
F
.05769 .93269 m
.05769 .94231 L
.06731 .94231 L
.06731 .93269 L
F
.04808 .94231 m
.04808 .95192 L
.05769 .95192 L
.05769 .94231 L
F
.03846 .95192 m
.03846 .96154 L
.04808 .96154 L
.04808 .95192 L
F
.02885 .96154 m
.02885 .97115 L
.03846 .97115 L
.03846 .96154 L
F
.01923 .97115 m
.01923 .98077 L
.02885 .98077 L
.02885 .97115 L
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.48.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "DensityGraphics", "\[SkeletonIndicator]"}],
  
  False,
  Editable->False]], "Output",
 CellLabel->"Out[34]= ",
 CellTags->"S5.48.1"]
}, Open  ]],

Cell["The center value can be set to a specific value. ", "MathCaption",
 CellTags->{"S5.48.1", "1.40"}],

Cell[CellGroupData[{

Cell["MatrixPlot[idsparse, 1]", "Input",
 CellLabel->"In[35]:= ",
 CellTags->"S5.48.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0144231 0.00961538 0.985577 0.00961538 [
[.01442 -0.0125 -3 -9 ]
[.01442 -0.0125 3 0 ]
[.20673 -0.0125 -6 -9 ]
[.20673 -0.0125 6 0 ]
[.39904 -0.0125 -6 -9 ]
[.39904 -0.0125 6 0 ]
[.59135 -0.0125 -6 -9 ]
[.59135 -0.0125 6 0 ]
[.78365 -0.0125 -6 -9 ]
[.78365 -0.0125 6 0 ]
[.97596 -0.0125 -9 -9 ]
[.97596 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .02404 -18 -4.5 ]
[-0.0125 .02404 0 4.5 ]
[-0.0125 .21635 -12 -4.5 ]
[-0.0125 .21635 0 4.5 ]
[-0.0125 .40865 -12 -4.5 ]
[-0.0125 .40865 0 4.5 ]
[-0.0125 .60096 -12 -4.5 ]
[-0.0125 .60096 0 4.5 ]
[-0.0125 .79327 -12 -4.5 ]
[-0.0125 .79327 0 4.5 ]
[-0.0125 .98558 -6 -4.5 ]
[-0.0125 .98558 0 4.5 ]
[ 0 0 -0.125 0 ]
[.01442 1.0125 -3 0 ]
[.01442 1.0125 3 9 ]
[.20673 1.0125 -6 0 ]
[.20673 1.0125 6 9 ]
[.39904 1.0125 -6 0 ]
[.39904 1.0125 6 9 ]
[.59135 1.0125 -6 0 ]
[.59135 1.0125 6 9 ]
[.78365 1.0125 -6 0 ]
[.78365 1.0125 6 9 ]
[.97596 1.0125 -9 0 ]
[.97596 1.0125 9 9 ]
[ 0 1 .125 0 ]
[1.0125 .02404 0 -4.5 ]
[1.0125 .02404 18 4.5 ]
[1.0125 .21635 0 -4.5 ]
[1.0125 .21635 12 4.5 ]
[1.0125 .40865 0 -4.5 ]
[1.0125 .40865 12 4.5 ]
[1.0125 .60096 0 -4.5 ]
[1.0125 .60096 12 4.5 ]
[1.0125 .79327 0 -4.5 ]
[1.0125 .79327 12 4.5 ]
[1.0125 .98558 0 -4.5 ]
[1.0125 .98558 6 4.5 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01442 0 m
.01442 .00625 L
s
[(0)] .01442 -0.0125 0 1 Mshowa
.20673 0 m
.20673 .00625 L
s
[(20)] .20673 -0.0125 0 1 Mshowa
.39904 0 m
.39904 .00625 L
s
[(40)] .39904 -0.0125 0 1 Mshowa
.59135 0 m
.59135 .00625 L
s
[(60)] .59135 -0.0125 0 1 Mshowa
.78365 0 m
.78365 .00625 L
s
[(80)] .78365 -0.0125 0 1 Mshowa
.97596 0 m
.97596 .00625 L
s
[(100)] .97596 -0.0125 0 1 Mshowa
0 0 m
1 0 L
s
0 .02404 m
.00625 .02404 L
s
[(100)] -0.0125 .02404 1 0 Mshowa
0 .21635 m
.00625 .21635 L
s
[(80)] -0.0125 .21635 1 0 Mshowa
0 .40865 m
.00625 .40865 L
s
[(60)] -0.0125 .40865 1 0 Mshowa
0 .60096 m
.00625 .60096 L
s
[(40)] -0.0125 .60096 1 0 Mshowa
0 .79327 m
.00625 .79327 L
s
[(20)] -0.0125 .79327 1 0 Mshowa
0 .98558 m
.00625 .98558 L
s
[(0)] -0.0125 .98558 1 0 Mshowa
0 0 m
0 1 L
s
.01442 .99375 m
.01442 1 L
s
[(0)] .01442 1.0125 0 -1 Mshowa
.20673 .99375 m
.20673 1 L
s
[(20)] .20673 1.0125 0 -1 Mshowa
.39904 .99375 m
.39904 1 L
s
[(40)] .39904 1.0125 0 -1 Mshowa
.59135 .99375 m
.59135 1 L
s
[(60)] .59135 1.0125 0 -1 Mshowa
.78365 .99375 m
.78365 1 L
s
[(80)] .78365 1.0125 0 -1 Mshowa
.97596 .99375 m
.97596 1 L
s
[(100)] .97596 1.0125 0 -1 Mshowa
0 1 m
1 1 L
s
.99375 .02404 m
1 .02404 L
s
[(100)] 1.0125 .02404 -1 0 Mshowa
.99375 .21635 m
1 .21635 L
s
[(80)] 1.0125 .21635 -1 0 Mshowa
.99375 .40865 m
1 .40865 L
s
[(60)] 1.0125 .40865 -1 0 Mshowa
.99375 .60096 m
1 .60096 L
s
[(40)] 1.0125 .60096 -1 0 Mshowa
.99375 .79327 m
1 .79327 L
s
[(20)] 1.0125 .79327 -1 0 Mshowa
.99375 .98558 m
1 .98558 L
s
[(0)] 1.0125 .98558 -1 0 Mshowa
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.01923 .01923 m
.01923 .98077 L
.98077 .98077 L
.98077 .01923 L
F
1 g
.97115 .01923 m
.97115 .02885 L
.98077 .02885 L
.98077 .01923 L
F
.96154 .02885 m
.96154 .03846 L
.97115 .03846 L
.97115 .02885 L
F
.95192 .03846 m
.95192 .04808 L
.96154 .04808 L
.96154 .03846 L
F
.94231 .04808 m
.94231 .05769 L
.95192 .05769 L
.95192 .04808 L
F
.93269 .05769 m
.93269 .06731 L
.94231 .06731 L
.94231 .05769 L
F
.92308 .06731 m
.92308 .07692 L
.93269 .07692 L
.93269 .06731 L
F
.91346 .07692 m
.91346 .08654 L
.92308 .08654 L
.92308 .07692 L
F
.90385 .08654 m
.90385 .09615 L
.91346 .09615 L
.91346 .08654 L
F
.89423 .09615 m
.89423 .10577 L
.90385 .10577 L
.90385 .09615 L
F
.88462 .10577 m
.88462 .11538 L
.89423 .11538 L
.89423 .10577 L
F
.875 .11538 m
.875 .125 L
.88462 .125 L
.88462 .11538 L
F
.86538 .125 m
.86538 .13462 L
.875 .13462 L
.875 .125 L
F
.85577 .13462 m
.85577 .14423 L
.86538 .14423 L
.86538 .13462 L
F
.84615 .14423 m
.84615 .15385 L
.85577 .15385 L
.85577 .14423 L
F
.83654 .15385 m
.83654 .16346 L
.84615 .16346 L
.84615 .15385 L
F
.82692 .16346 m
.82692 .17308 L
.83654 .17308 L
.83654 .16346 L
F
.81731 .17308 m
.81731 .18269 L
.82692 .18269 L
.82692 .17308 L
F
.80769 .18269 m
.80769 .19231 L
.81731 .19231 L
.81731 .18269 L
F
.79808 .19231 m
.79808 .20192 L
.80769 .20192 L
.80769 .19231 L
F
.78846 .20192 m
.78846 .21154 L
.79808 .21154 L
.79808 .20192 L
F
.77885 .21154 m
.77885 .22115 L
.78846 .22115 L
.78846 .21154 L
F
.76923 .22115 m
.76923 .23077 L
.77885 .23077 L
.77885 .22115 L
F
.75962 .23077 m
.75962 .24038 L
.76923 .24038 L
.76923 .23077 L
F
.75 .24038 m
.75 .25 L
.75962 .25 L
.75962 .24038 L
F
.74038 .25 m
.74038 .25962 L
.75 .25962 L
.75 .25 L
F
.73077 .25962 m
.73077 .26923 L
.74038 .26923 L
.74038 .25962 L
F
.72115 .26923 m
.72115 .27885 L
.73077 .27885 L
.73077 .26923 L
F
.71154 .27885 m
.71154 .28846 L
.72115 .28846 L
.72115 .27885 L
F
.70192 .28846 m
.70192 .29808 L
.71154 .29808 L
.71154 .28846 L
F
.69231 .29808 m
.69231 .30769 L
.70192 .30769 L
.70192 .29808 L
F
.68269 .30769 m
.68269 .31731 L
.69231 .31731 L
.69231 .30769 L
F
.67308 .31731 m
.67308 .32692 L
.68269 .32692 L
.68269 .31731 L
F
.66346 .32692 m
.66346 .33654 L
.67308 .33654 L
.67308 .32692 L
F
.65385 .33654 m
.65385 .34615 L
.66346 .34615 L
.66346 .33654 L
F
.64423 .34615 m
.64423 .35577 L
.65385 .35577 L
.65385 .34615 L
F
.63462 .35577 m
.63462 .36538 L
.64423 .36538 L
.64423 .35577 L
F
.625 .36538 m
.625 .375 L
.63462 .375 L
.63462 .36538 L
F
.61538 .375 m
.61538 .38462 L
.625 .38462 L
.625 .375 L
F
.60577 .38462 m
.60577 .39423 L
.61538 .39423 L
.61538 .38462 L
F
.59615 .39423 m
.59615 .40385 L
.60577 .40385 L
.60577 .39423 L
F
.58654 .40385 m
.58654 .41346 L
.59615 .41346 L
.59615 .40385 L
F
.57692 .41346 m
.57692 .42308 L
.58654 .42308 L
.58654 .41346 L
F
.56731 .42308 m
.56731 .43269 L
.57692 .43269 L
.57692 .42308 L
F
.55769 .43269 m
.55769 .44231 L
.56731 .44231 L
.56731 .43269 L
F
.54808 .44231 m
.54808 .45192 L
.55769 .45192 L
.55769 .44231 L
F
.53846 .45192 m
.53846 .46154 L
.54808 .46154 L
.54808 .45192 L
F
.52885 .46154 m
.52885 .47115 L
.53846 .47115 L
.53846 .46154 L
F
.51923 .47115 m
.51923 .48077 L
.52885 .48077 L
.52885 .47115 L
F
.50962 .48077 m
.50962 .49038 L
.51923 .49038 L
.51923 .48077 L
F
.5 .49038 m
.5 .5 L
.50962 .5 L
.50962 .49038 L
F
.49038 .5 m
.49038 .50962 L
.5 .50962 L
.5 .5 L
F
.48077 .50962 m
.48077 .51923 L
.49038 .51923 L
.49038 .50962 L
F
.47115 .51923 m
.47115 .52885 L
.48077 .52885 L
.48077 .51923 L
F
.46154 .52885 m
.46154 .53846 L
.47115 .53846 L
.47115 .52885 L
F
.45192 .53846 m
.45192 .54808 L
.46154 .54808 L
.46154 .53846 L
F
.44231 .54808 m
.44231 .55769 L
.45192 .55769 L
.45192 .54808 L
F
.43269 .55769 m
.43269 .56731 L
.44231 .56731 L
.44231 .55769 L
F
.42308 .56731 m
.42308 .57692 L
.43269 .57692 L
.43269 .56731 L
F
.41346 .57692 m
.41346 .58654 L
.42308 .58654 L
.42308 .57692 L
F
.40385 .58654 m
.40385 .59615 L
.41346 .59615 L
.41346 .58654 L
F
.39423 .59615 m
.39423 .60577 L
.40385 .60577 L
.40385 .59615 L
F
.38462 .60577 m
.38462 .61538 L
.39423 .61538 L
.39423 .60577 L
F
.375 .61538 m
.375 .625 L
.38462 .625 L
.38462 .61538 L
F
.36538 .625 m
.36538 .63462 L
.375 .63462 L
.375 .625 L
F
.35577 .63462 m
.35577 .64423 L
.36538 .64423 L
.36538 .63462 L
F
.34615 .64423 m
.34615 .65385 L
.35577 .65385 L
.35577 .64423 L
F
.33654 .65385 m
.33654 .66346 L
.34615 .66346 L
.34615 .65385 L
F
.32692 .66346 m
.32692 .67308 L
.33654 .67308 L
.33654 .66346 L
F
.31731 .67308 m
.31731 .68269 L
.32692 .68269 L
.32692 .67308 L
F
.30769 .68269 m
.30769 .69231 L
.31731 .69231 L
.31731 .68269 L
F
.29808 .69231 m
.29808 .70192 L
.30769 .70192 L
.30769 .69231 L
F
.28846 .70192 m
.28846 .71154 L
.29808 .71154 L
.29808 .70192 L
F
.27885 .71154 m
.27885 .72115 L
.28846 .72115 L
.28846 .71154 L
F
.26923 .72115 m
.26923 .73077 L
.27885 .73077 L
.27885 .72115 L
F
.25962 .73077 m
.25962 .74038 L
.26923 .74038 L
.26923 .73077 L
F
.25 .74038 m
.25 .75 L
.25962 .75 L
.25962 .74038 L
F
.24038 .75 m
.24038 .75962 L
.25 .75962 L
.25 .75 L
F
.23077 .75962 m
.23077 .76923 L
.24038 .76923 L
.24038 .75962 L
F
.22115 .76923 m
.22115 .77885 L
.23077 .77885 L
.23077 .76923 L
F
.21154 .77885 m
.21154 .78846 L
.22115 .78846 L
.22115 .77885 L
F
.20192 .78846 m
.20192 .79808 L
.21154 .79808 L
.21154 .78846 L
F
.19231 .79808 m
.19231 .80769 L
.20192 .80769 L
.20192 .79808 L
F
.18269 .80769 m
.18269 .81731 L
.19231 .81731 L
.19231 .80769 L
F
.17308 .81731 m
.17308 .82692 L
.18269 .82692 L
.18269 .81731 L
F
.16346 .82692 m
.16346 .83654 L
.17308 .83654 L
.17308 .82692 L
F
.15385 .83654 m
.15385 .84615 L
.16346 .84615 L
.16346 .83654 L
F
.14423 .84615 m
.14423 .85577 L
.15385 .85577 L
.15385 .84615 L
F
.13462 .85577 m
.13462 .86538 L
.14423 .86538 L
.14423 .85577 L
F
.125 .86538 m
.125 .875 L
.13462 .875 L
.13462 .86538 L
F
.11538 .875 m
.11538 .88462 L
.125 .88462 L
.125 .875 L
F
.10577 .88462 m
.10577 .89423 L
.11538 .89423 L
.11538 .88462 L
F
.09615 .89423 m
.09615 .90385 L
.10577 .90385 L
.10577 .89423 L
F
.08654 .90385 m
.08654 .91346 L
.09615 .91346 L
.09615 .90385 L
F
.07692 .91346 m
.07692 .92308 L
.08654 .92308 L
.08654 .91346 L
F
.06731 .92308 m
.06731 .93269 L
.07692 .93269 L
.07692 .92308 L
F
.05769 .93269 m
.05769 .94231 L
.06731 .94231 L
.06731 .93269 L
F
.04808 .94231 m
.04808 .95192 L
.05769 .95192 L
.05769 .94231 L
F
.03846 .95192 m
.03846 .96154 L
.04808 .96154 L
.04808 .95192 L
F
.02885 .96154 m
.02885 .97115 L
.03846 .97115 L
.03846 .96154 L
F
.01923 .97115 m
.01923 .98077 L
.02885 .98077 L
.02885 .97115 L
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.48.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "DensityGraphics", "\[SkeletonIndicator]"}],
  
  False,
  Editable->False]], "Output",
 CellLabel->"Out[35]= ",
 CellTags->"S5.48.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["MaxMatrixSize -> ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "maximum display size for matrix",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.48.1"],

Cell[TextData[{
 "Options specific to ",
 StyleBox["MatrixPlot", "MR"],
 "."
}], "Caption",
 CellTags->"S5.48.1"],

Cell[TextData[{
 StyleBox["MatrixPlot", "MR"],
 " accept the usual range of options for a graphics function. In addition, it \
takes the ",
 StyleBox["MaxMatrixSize", "MR"],
 " option, specifying a maximum display size to use for the array. By \
default, this is set to ",
 Cell[BoxData[
  FormBox["512", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". If the matrix dimensions are larger than this size, the matrix is \
downsampled to this size or less so that the output graphic size can be \
controlled. In this case, a darkened cell indicates that at least one of the \
covered cells has a non\[Hyphen]central value. The ",
 StyleBox["MaxMatrixSize", "MR"],
 " may be set to ",
 StyleBox["Infnity", "MR"],
 " to prevent downsampling before display. "
}], "Text",
 CellTags->{"S5.48.1", "1.41"}],

Cell[TextData[{
 "Display the sparse identity matrix with a maximum size of ",
 Cell[BoxData[
  FormBox["4", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.48.1", "1.42"}],

Cell[CellGroupData[{

Cell["MatrixPlot[idsparse, MaxMatrixSize -> 4]", "Input",
 CellLabel->"In[36]:= ",
 CellTags->"S5.48.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0144231 0.00961538 0.985577 0.00961538 [
[.01442 -0.0125 -3 -9 ]
[.01442 -0.0125 3 0 ]
[.20673 -0.0125 -6 -9 ]
[.20673 -0.0125 6 0 ]
[.39904 -0.0125 -6 -9 ]
[.39904 -0.0125 6 0 ]
[.59135 -0.0125 -6 -9 ]
[.59135 -0.0125 6 0 ]
[.78365 -0.0125 -6 -9 ]
[.78365 -0.0125 6 0 ]
[.97596 -0.0125 -9 -9 ]
[.97596 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .02404 -18 -4.5 ]
[-0.0125 .02404 0 4.5 ]
[-0.0125 .21635 -12 -4.5 ]
[-0.0125 .21635 0 4.5 ]
[-0.0125 .40865 -12 -4.5 ]
[-0.0125 .40865 0 4.5 ]
[-0.0125 .60096 -12 -4.5 ]
[-0.0125 .60096 0 4.5 ]
[-0.0125 .79327 -12 -4.5 ]
[-0.0125 .79327 0 4.5 ]
[-0.0125 .98558 -6 -4.5 ]
[-0.0125 .98558 0 4.5 ]
[ 0 0 -0.125 0 ]
[.01442 1.0125 -3 0 ]
[.01442 1.0125 3 9 ]
[.20673 1.0125 -6 0 ]
[.20673 1.0125 6 9 ]
[.39904 1.0125 -6 0 ]
[.39904 1.0125 6 9 ]
[.59135 1.0125 -6 0 ]
[.59135 1.0125 6 9 ]
[.78365 1.0125 -6 0 ]
[.78365 1.0125 6 9 ]
[.97596 1.0125 -9 0 ]
[.97596 1.0125 9 9 ]
[ 0 1 .125 0 ]
[1.0125 .02404 0 -4.5 ]
[1.0125 .02404 18 4.5 ]
[1.0125 .21635 0 -4.5 ]
[1.0125 .21635 12 4.5 ]
[1.0125 .40865 0 -4.5 ]
[1.0125 .40865 12 4.5 ]
[1.0125 .60096 0 -4.5 ]
[1.0125 .60096 12 4.5 ]
[1.0125 .79327 0 -4.5 ]
[1.0125 .79327 12 4.5 ]
[1.0125 .98558 0 -4.5 ]
[1.0125 .98558 6 4.5 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01442 0 m
.01442 .00625 L
s
[(0)] .01442 -0.0125 0 1 Mshowa
.20673 0 m
.20673 .00625 L
s
[(20)] .20673 -0.0125 0 1 Mshowa
.39904 0 m
.39904 .00625 L
s
[(40)] .39904 -0.0125 0 1 Mshowa
.59135 0 m
.59135 .00625 L
s
[(60)] .59135 -0.0125 0 1 Mshowa
.78365 0 m
.78365 .00625 L
s
[(80)] .78365 -0.0125 0 1 Mshowa
.97596 0 m
.97596 .00625 L
s
[(100)] .97596 -0.0125 0 1 Mshowa
0 0 m
1 0 L
s
0 .02404 m
.00625 .02404 L
s
[(100)] -0.0125 .02404 1 0 Mshowa
0 .21635 m
.00625 .21635 L
s
[(80)] -0.0125 .21635 1 0 Mshowa
0 .40865 m
.00625 .40865 L
s
[(60)] -0.0125 .40865 1 0 Mshowa
0 .60096 m
.00625 .60096 L
s
[(40)] -0.0125 .60096 1 0 Mshowa
0 .79327 m
.00625 .79327 L
s
[(20)] -0.0125 .79327 1 0 Mshowa
0 .98558 m
.00625 .98558 L
s
[(0)] -0.0125 .98558 1 0 Mshowa
0 0 m
0 1 L
s
.01442 .99375 m
.01442 1 L
s
[(0)] .01442 1.0125 0 -1 Mshowa
.20673 .99375 m
.20673 1 L
s
[(20)] .20673 1.0125 0 -1 Mshowa
.39904 .99375 m
.39904 1 L
s
[(40)] .39904 1.0125 0 -1 Mshowa
.59135 .99375 m
.59135 1 L
s
[(60)] .59135 1.0125 0 -1 Mshowa
.78365 .99375 m
.78365 1 L
s
[(80)] .78365 1.0125 0 -1 Mshowa
.97596 .99375 m
.97596 1 L
s
[(100)] .97596 1.0125 0 -1 Mshowa
0 1 m
1 1 L
s
.99375 .02404 m
1 .02404 L
s
[(100)] 1.0125 .02404 -1 0 Mshowa
.99375 .21635 m
1 .21635 L
s
[(80)] 1.0125 .21635 -1 0 Mshowa
.99375 .40865 m
1 .40865 L
s
[(60)] 1.0125 .40865 -1 0 Mshowa
.99375 .60096 m
1 .60096 L
s
[(40)] 1.0125 .60096 -1 0 Mshowa
.99375 .79327 m
1 .79327 L
s
[(20)] 1.0125 .79327 -1 0 Mshowa
.99375 .98558 m
1 .98558 L
s
[(0)] 1.0125 .98558 -1 0 Mshowa
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
4 string
4 4 8 [4 0 0 4 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FFFFFF00
FFFF00FF
FF00FFFF
00FFFFFF
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.48.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "DensityGraphics", "\[SkeletonIndicator]"}],
  
  False,
  Editable->False]], "Output",
 CellLabel->"Out[36]= ",
 CellTags->"S5.48.1"]
}, Open  ]],

Cell["\<\
Note that when displaying a matrix in this fashion, sampling effects from the \
graphic rendering or the downsampling procedure can distort the structure. \
Showing a graphic at a number of pixels that is not commensurate with the \
matrix dimensions can lead to fuzziness or other artifacts in the graphic, \
while downsampling effects can make a matrix seem denser than it really is. \
\>", "Text",
 CellTags->{"S5.48.1", "1.43"}],

Cell["\<\
When using a display size smaller than the actual matrix dimensions, the \
count of non\[Hyphen]central values can be displayed via a color function. \
\>", "Text",
 CellTags->{"S5.48.1", "1.44"}],

Cell["Load statistical distributions. ", "MathCaption",
 CellTags->{"S5.48.1", "1.45"}],

Cell["<<Statistics`", "Input",
 CellLabel->"In[37]:= ",
 CellTags->"S5.48.1"],

Cell[TextData[{
 "Generate an array of ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " with varying distribution. "
}], "MathCaption",
 CellTags->{"S5.48.1", "1.46"}],

Cell["\<\
mat = Table[
    Random[BernoulliDistribution[m * n]],
   {n, 0, 1, 0.01}, {m, 0, 1, 0.01}];\
\>", "Input",
 CellLabel->"In[38]:= ",
 CellTags->"S5.48.1"],

Cell["Display the array. ", "MathCaption",
 CellTags->{"S5.48.1", "1.47"}],

Cell[CellGroupData[{

Cell["MatrixPlot[mat]", "Input",
 CellLabel->"In[39]:= ",
 CellTags->"S5.48.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0144707 0.00952018 0.985529 0.00952018 [
[.01447 -0.0125 -3 -9 ]
[.01447 -0.0125 3 0 ]
[.20487 -0.0125 -6 -9 ]
[.20487 -0.0125 6 0 ]
[.39528 -0.0125 -6 -9 ]
[.39528 -0.0125 6 0 ]
[.58568 -0.0125 -6 -9 ]
[.58568 -0.0125 6 0 ]
[.77609 -0.0125 -6 -9 ]
[.77609 -0.0125 6 0 ]
[.96649 -0.0125 -9 -9 ]
[.96649 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .03351 -18 -4.5 ]
[-0.0125 .03351 0 4.5 ]
[-0.0125 .22391 -12 -4.5 ]
[-0.0125 .22391 0 4.5 ]
[-0.0125 .41432 -12 -4.5 ]
[-0.0125 .41432 0 4.5 ]
[-0.0125 .60472 -12 -4.5 ]
[-0.0125 .60472 0 4.5 ]
[-0.0125 .79513 -12 -4.5 ]
[-0.0125 .79513 0 4.5 ]
[-0.0125 .98553 -6 -4.5 ]
[-0.0125 .98553 0 4.5 ]
[ 0 0 -0.125 0 ]
[.01447 1.0125 -3 0 ]
[.01447 1.0125 3 9 ]
[.20487 1.0125 -6 0 ]
[.20487 1.0125 6 9 ]
[.39528 1.0125 -6 0 ]
[.39528 1.0125 6 9 ]
[.58568 1.0125 -6 0 ]
[.58568 1.0125 6 9 ]
[.77609 1.0125 -6 0 ]
[.77609 1.0125 6 9 ]
[.96649 1.0125 -9 0 ]
[.96649 1.0125 9 9 ]
[ 0 1 .125 0 ]
[1.0125 .03351 0 -4.5 ]
[1.0125 .03351 18 4.5 ]
[1.0125 .22391 0 -4.5 ]
[1.0125 .22391 12 4.5 ]
[1.0125 .41432 0 -4.5 ]
[1.0125 .41432 12 4.5 ]
[1.0125 .60472 0 -4.5 ]
[1.0125 .60472 12 4.5 ]
[1.0125 .79513 0 -4.5 ]
[1.0125 .79513 12 4.5 ]
[1.0125 .98553 0 -4.5 ]
[1.0125 .98553 6 4.5 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01447 0 m
.01447 .00625 L
s
[(0)] .01447 -0.0125 0 1 Mshowa
.20487 0 m
.20487 .00625 L
s
[(20)] .20487 -0.0125 0 1 Mshowa
.39528 0 m
.39528 .00625 L
s
[(40)] .39528 -0.0125 0 1 Mshowa
.58568 0 m
.58568 .00625 L
s
[(60)] .58568 -0.0125 0 1 Mshowa
.77609 0 m
.77609 .00625 L
s
[(80)] .77609 -0.0125 0 1 Mshowa
.96649 0 m
.96649 .00625 L
s
[(100)] .96649 -0.0125 0 1 Mshowa
0 0 m
1 0 L
s
0 .03351 m
.00625 .03351 L
s
[(100)] -0.0125 .03351 1 0 Mshowa
0 .22391 m
.00625 .22391 L
s
[(80)] -0.0125 .22391 1 0 Mshowa
0 .41432 m
.00625 .41432 L
s
[(60)] -0.0125 .41432 1 0 Mshowa
0 .60472 m
.00625 .60472 L
s
[(40)] -0.0125 .60472 1 0 Mshowa
0 .79513 m
.00625 .79513 L
s
[(20)] -0.0125 .79513 1 0 Mshowa
0 .98553 m
.00625 .98553 L
s
[(0)] -0.0125 .98553 1 0 Mshowa
0 0 m
0 1 L
s
.01447 .99375 m
.01447 1 L
s
[(0)] .01447 1.0125 0 -1 Mshowa
.20487 .99375 m
.20487 1 L
s
[(20)] .20487 1.0125 0 -1 Mshowa
.39528 .99375 m
.39528 1 L
s
[(40)] .39528 1.0125 0 -1 Mshowa
.58568 .99375 m
.58568 1 L
s
[(60)] .58568 1.0125 0 -1 Mshowa
.77609 .99375 m
.77609 1 L
s
[(80)] .77609 1.0125 0 -1 Mshowa
.96649 .99375 m
.96649 1 L
s
[(100)] .96649 1.0125 0 -1 Mshowa
0 1 m
1 1 L
s
.99375 .03351 m
1 .03351 L
s
[(100)] 1.0125 .03351 -1 0 Mshowa
.99375 .22391 m
1 .22391 L
s
[(80)] 1.0125 .22391 -1 0 Mshowa
.99375 .41432 m
1 .41432 L
s
[(60)] 1.0125 .41432 -1 0 Mshowa
.99375 .60472 m
1 .60472 L
s
[(40)] 1.0125 .60472 -1 0 Mshowa
.99375 .79513 m
1 .79513 L
s
[(20)] 1.0125 .79513 -1 0 Mshowa
.99375 .98553 m
1 .98553 L
s
[(0)] 1.0125 .98553 -1 0 Mshowa
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
101 string
101 101 8 [101 0 0 101 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FFFF0000FF
FFFF00FF0000FFFF00FF00FFFFFFFF0000000000FF0000FFFF000000000000000000FF00
FFFF00FF00000000000000000000000000000000000000000000000000
FFFFFFFFFFFF00FF00FFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFF00FFFFFFFFFF00
FF0000FF00FFFF0000FFFF000000FFFFFFFF0000FF00FF00FF0000FF0000FF0000FF0000
FF0000000000FFFF00000000FF00FF00000000000000FF000000000000
FFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFF000000FF00FF
FF00000000FFFF00FFFFFFFF0000FF00FF0000FFFFFF000000000000FFFF000000FFFF00
000000000000FF000000000000FF00000000000000000000FF00000000
FFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF0000FFFFFF00FFFF00FFFFFF00FFFF00FFFF
00FFFFFFFFFFFF0000FF0000FF00FFFFFF00FFFFFF0000000000FF00FF00000000FF00FF
FFFF0000000000000000000000FF00000000000000000000FF00000000
FFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF0000FFFFFFFFFF0000FFFF00FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF00FF0000FF0000FFFFFF0000FFFF000000000000FFFF0000FF000000FF
FF00000000FFFF000000FF00000000000000FF000000000000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFF00FFFFFF00FFFFFFFFFF00FFFFFFFF00FFFFFF
FFFFFFFFFF00FFFFFF0000FF0000FF000000FFFF00FF00000000FFFFFF0000FF00FF0000
FFFF00FF0000FFFF000000FF0000FF0000FF0000000000000000000000
FFFFFF00FFFFFFFFFFFFFFFFFF00FF00FFFF00FFFF00FFFF00FFFFFFFFFFFFFF00FF00FF
00FFFFFFFFFFFFFFFFFF00FFFFFF00FF00FFFF00FF00FF00FF00000000FFFFFF00FF0000
FF00FF00FF000000000000000000000000000000FF00FF000000FF0000
FFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF00FF00FFFFFFFFFFFF0000FFFF00FFFFFFFF
FF000000FFFF00FFFFFFFF000000000000FF0000FF00FF00FF00FF00FFFF00FF0000FF00
0000FF0000FF00000000000000000000000000FF000000000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFF00FFFFFF00FFFFFFFF0000FF
FFFFFFFF00FFFF00FFFFFFFFFF00FFFF0000FF000000000000FFFFFF000000FFFFFF0000
000000000000000000FFFF000000FF00000000000000FFFF0000000000
FFFFFFFFFF00FFFFFFFF00FFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00FFFF000000FFFFFFFFFFFF0000FF00FFFF00FF0000FFFF00FF00FF0000FFFF00FFFF
FF000000FFFF000000000000000000000000000000FF00000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFF
FFFF00FFFF00FF00FFFF00FF00000000FFFFFF0000FF00FF00FF00FF00FF0000FF0000FF
FFFFFFFF00FF0000FF000000000000FF00000000000000000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF000000FF00FF
FFFFFF00000000FFFFFF0000FFFFFFFFFF00FF00000000FFFF00FF00FFFFFFFF0000FFFF
0000FF00FF0000FF00FFFF0000FFFFFF0000000000000000FF00000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF00FFFFFF00FFFFFF000000
FFFFFF00FF00FFFFFFFFFF00FFFF00FFFFFFFF0000FF00FF00FFFFFF00FFFFFF00FF0000
000000FF0000000000FF0000FFFF00FF000000FF0000FF000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFF00FFFF00FF00FFFF0000FFFF
FFFF00FFFF00000000FFFFFFFFFF00FF0000FFFF00000000FF00FF00FF00FF00FF000000
FFFFFF00000000000000FF00FF000000FFFF0000000000FF0000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF0000FFFF
FFFFFF00FFFF00FF00FFFF00FF0000FF0000FF0000000000FF00FF00FFFF00FF00000000
FFFFFF000000FF0000000000FFFF000000FF000000FF00FFFF0000FF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FFFFFFFFFFFFFFFFFFFF00FFFF00FF00FFFF
FFFFFFFFFFFF0000FFFF00FFFFFFFFFF00FFFFFFFFFF000000FFFFFF00000000FF000000
00FFFF000000FF000000000000000000FF000000FF0000000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF0000FF00FFFF00FFFFFFFFFFFFFF00
FFFFFF0000FFFFFFFFFF00FFFFFFFFFF00FFFFFF00FF00FFFF00FFFFFF0000FFFF00FFFF
0000000000000000FF000000FF0000FF00FF00FF00FF00FFFFFFFF0000
FFFFFF00FFFFFFFF000000FFFFFFFF000000FFFF00FFFFFFFF00FFFFFF00FF00FF00FFFF
00FF00FF00FFFF0000FFFFFFFFFFFFFF00FF000000FFFF00FF00FFFFFFFF000000FFFFFF
00FF0000000000FF00000000000000FF00FF000000000000FF00FF0000
FFFFFFFFFFFFFF00FFFFFFFF00FFFF0000FF00FFFFFFFFFFFFFFFFFF00FF00FFFF00FF00
FFFFFF00FFFFFFFF000000FFFF00FFFFFF00FFFF000000FF00FF00FFFF0000FF00000000
00FFFFFFFF0000FFFF00000000000000000000FF00FF000000FF000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFF00FFFF00FFFFFFFFFFFFFF0000FF00FFFFFF
FFFFFFFF0000FF00000000FF0000FF00FF0000FFFFFFFFFF00FFFF000000FF00FF00FF00
FF000000FF0000000000000000FFFF000000FFFF00000000FFFFFF00FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF000000FFFF00FF00FFFF00
FFFFFFFF00FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00FFFFFFFFFF00FF00
000000000000FFFF00FF000000FF00FF0000FFFF00FFFF000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF0000FF00FFFF00FFFFFF00FFFFFFFFFFFF
00FFFFFFFFFFFFFFFF00FFFFFF000000FFFFFFFF0000FF00FF0000FF00FFFF00FF000000
FF00FF0000000000FF00000000000000FF00FF0000FF00FF0000FF0000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF00FFFFFF00FFFFFFFFFFFFFF
00FFFFFFFF00FFFFFF00FFFF000000FF00FF00FF00FF00FF00FFFF000000FFFFFF000000
FFFFFF000000FF00000000000000FF00000000FFFF00FF000000FF0000
FFFFFFFFFF00FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFF00FFFFFFFF0000FFFFFF
00FFFF00FF00FFFFFFFFFFFFFFFFFF00FF00000000FFFF000000FF00FF000000FF000000
0000FF00FFFF00FF0000000000FF000000000000000000FF000000FF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFF00FFFFFFFF
FFFFFFFFFFFFFFFFFFFF00FF00FFFF00FF00FF00FF0000FF00FFFFFFFFFFFF00FF0000FF
FF00FFFFFF0000FF0000FF0000FF0000FFFF00FFFFFFFF000000000000
FFFFFFFFFFFFFFFFFFFF00FFFFFFFF00FFFF00FFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF00FF0000FFFFFFFFFF0000FFFFFFFF0000000000000000FFFF00
000000FF00000000FFFF00FFFFFF00FFFFFF0000000000FF00FF000000
FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF00FFFFFFFFFFFFFF00FFFF00FFFFFFFFFFFF
00FFFFFFFF00FFFFFFFF00FF00FFFFFF00FF00FF0000FF0000FFFF00FF0000FFFFFF0000
FF0000FF0000FFFF000000000000000000000000FF00000000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FFFF00FF
00FFFF00FFFFFFFFFF00FF000000FFFFFF00FFFFFF00FF00FFFFFFFFFF00FF00FF00FF00
FF0000FF00FFFF00000000FFFFFF00FFFF0000000000FF0000FF000000
FFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF00FFFFFFFFFF00FFFFFFFFFFFFFFFF00FF00FF00
FFFFFFFFFFFFFF00FFFFFFFFFF0000FF0000FFFF0000FFFF00000000FFFF000000FF00FF
00FF00FFFF0000FF0000FF0000FF0000FF0000FF0000FF0000FFFFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF00FFFFFFFFFFFFFFFFFFFF00FFFF
FFFFFFFF00FFFF00FFFFFFFF00FFFF0000FF00FFFF000000FFFFFFFFFFFF000000FFFFFF
FF00FF00FFFFFF00000000000000FFFF00000000000000FF000000FF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFF00FFFFFFFF0000
00FF00FFFFFFFFFF00FFFF00FFFFFFFFFFFFFFFF00FFFFFFFF0000FFFF00FF0000FF0000
FFFF00FF0000FF0000FF000000FFFF00FF00FF0000FFFFFF000000FF00
FFFFFFFFFF00FFFFFFFFFFFFFFFF0000FFFFFFFFFFFF00FFFFFFFFFF00FFFFFF00FFFF00
FF00FF00FF00FF00FFFFFFFFFFFF00FFFF00FFFFFF0000FF0000000000FFFF0000FFFFFF
00FFFFFF0000FFFFFF00FF00FFFFFF0000FF00000000000000FF00FF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFF00FFFF00FF00FFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFF00FFFFFF0000FF00FF000000FFFFFFFF00FFFF00FF0000FF00FF00
0000FF00FFFFFF00FF00000000FF00FFFF00FF0000FFFF0000FF00FF00
FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF00FFFFFFFFFFFF0000FFFFFFFFFF
FF00FFFFFFFFFFFFFFFFFFFF00FFFF00FFFFFFFF00FFFF00FFFFFFFFFFFF00FF00FFFF00
FF00000000FF0000FFFFFF00FF0000FF00FFFFFF00FF00000000FF0000
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FF00FFFF00FFFFFF00FF000000FFFFFFFFFFFF
FF00FFFFFFFFFFFFFFFF00FF00FFFFFF00FF00FFFF0000000000FF00FF00FFFF00FFFF00
0000FFFF00FFFFFFFF00FFFF00000000FF0000FF000000FFFF00000000
FFFFFFFFFF00FFFFFFFFFF00FF00FFFFFFFFFFFFFF00FFFFFFFFFFFFFF00FFFFFFFFFFFF
0000FF00FFFFFF000000FFFF0000FF00FFFFFFFFFFFF00FFFF00FFFF0000FFFF00FF00FF
00FF00FF00FF00FFFF000000FFFF000000FFFFFF00FF000000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF00FF00FFFFFFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF0000FFFFFFFFFF000000FFFFFFFF
00FF00FF00FF00FFFFFFFFFFFF0000FF0000FF0000FF00FF0000FFFF00
FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFF
FFFFFFFFFF00FFFF0000FFFFFFFFFFFFFFFF0000FFFFFF00FFFFFFFF00FFFF0000FFFF00
FF0000FFFF00FF0000000000FFFFFF00FF0000FFFFFF0000FF00000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FFFFFF00FFFFFF00FF00
FF00FFFFFFFFFFFF00FFFF00FFFFFFFFFFFFFFFF00FFFFFFFF00000000FF00FFFFFFFFFF
0000FFFFFFFF00000000FFFF00FFFF00FF00000000FF00FFFF0000FF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00
FFFFFFFF00FFFFFFFFFFFF00FF00FF000000FF00FFFF00FFFFFF00FF0000FF00FFFFFF00
00FF000000FF0000FFFF00000000FF00FFFF00FF000000FFFF00000000
FFFFFFFFFFFF00FF00FFFFFFFFFFFFFF00FF00FFFFFFFFFFFF00FFFFFFFFFFFFFFFF00FF
0000FFFF00FFFFFF0000FFFFFFFFFF00000000FFFFFF0000FF00FF00FFFFFF00FFFF0000
FFFFFF00FFFFFFFFFF00000000FFFF00000000FFFF00FFFFFFFF00FF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFF00FFFF00FF
FFFF00FFFF00FFFFFFFFFFFF00FFFFFF00FFFF00FFFFFFFFFFFFFFFF00FFFF00FFFFFF00
FFFF00000000FFFFFFFFFF00FF00FFFF00FF00FFFF0000000000FF00FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFF00FFFF00FF00
00FFFF00FFFFFFFFFFFFFF00FFFF00FFFF00000000FF00000000FF0000FFFFFFFFFF0000
FF00FFFF00FFFFFF0000FF0000FFFF00FF00FFFF0000FFFFFF00FFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFF00FFFFFF
FFFF00FFFFFF00FFFF00000000FFFFFF0000FF00FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF
0000FF000000000000FF00FFFFFFFF00FFFF0000FF00FF0000FF00FF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFF
0000FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FFFF000000FFFFFF00FFFFFF
FFFF000000FFFFFFFF00FFFF00FFFFFF000000FF000000FF000000FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF0000FFFFFFFFFFFFFFFFFF
FFFF00FFFF0000FFFFFFFFFF00FFFFFFFFFF00FFFF00FFFFFFFFFF000000FFFFFFFFFFFF
FFFF0000FFFF00FF00FF00FF0000FFFF00FFFF00FF0000FF0000FFFF00
FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF00FFFFFFFFFFFF00FFFF0000FFFFFF00FFFF
FFFFFFFFFFFFFFFFFF00FFFFFF000000FFFF00FFFFFFFFFF00FFFF0000FFFFFF00FF0000
FFFF0000FFFFFF0000FF00FF0000FFFFFF00FFFFFFFFFF0000FFFF0000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FFFFFFFF00FFFF
FFFFFFFFFFFFFFFFFFFFFFFF0000FF000000FFFFFF00FFFF0000FFFFFFFFFF00FF00FFFF
FFFF00FFFFFF00FF00FFFFFFFFFFFFFF00FF00FF00FF00FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFF
00FFFFFFFFFFFF00FFFF00FFFFFFFF00FFFF0000FF0000FF00FF0000FF00FF0000FF00FF
FF0000FF00FF00FFFFFF00FFFFFFFFFF00FFFF00FF00000000FF00FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFF
FFFFFFFFFFFFFFFF00FFFF0000FFFF00FFFF00FF00000000FFFFFFFF000000FFFFFFFFFF
FFFFFFFF0000000000000000FFFFFFFF0000FFFFFFFF0000FFFFFF00FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFF00FFFFFFFF00FF0000FF00FFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFF00FFFF
FF00FFFFFFFFFF000000FFFFFF00FF00FFFFFFFF000000FFFF00FFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFF00FFFFFF00FFFFFFFFFFFFFFFF
FF0000FFFFFFFFFFFFFFFFFFFF00FFFFFFFF0000FFFF00FF00FFFF00FFFFFFFFFFFFFF00
FFFF00FFFF00FFFFFFFFFF000000FFFF00000000FFFFFFFF00FF00FF00
FFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FF00FF00FF
FFFFFF0000FF00FFFF00FFFF00FFFFFFFFFF00FFFFFF0000FFFFFF00FFFFFFFFFFFFFFFF
FF00000000FFFFFFFFFFFFFF00FFFFFFFF000000FFFFFF0000FFFF00FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF000000FF00FFFFFFFFFFFF00
FFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF00FFFFFFFF00FF00FFFFFFFF00FF00FFFFFF00
FFFFFF0000FFFFFFFFFFFFFFFF00FF000000FF00FFFF00FFFFFF0000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFF00FF00FFFFFF00FFFFFFFFFFFFFFFFFF
00FFFFFFFF0000FFFFFF00FFFFFF0000FFFFFFFFFFFFFFFF00FFFF00FF00FFFFFFFFFF00
000000000000FF00FFFFFF00FF000000FFFFFFFF00000000FFFFFF00FF
FFFFFFFFFFFFFFFFFF00FFFFFFFF00FFFFFFFFFFFFFFFFFFFF00FFFFFFFF0000FFFFFFFF
FF00FF0000FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF0000FF000000FFFFFFFF0000FF
FFFFFFFF00FF00FF0000FF0000FFFF00FFFF00FF00FFFF00FFFFFF00FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFF00FF00FFFFFFFFFFFFFF00FF00FFFFFF00FF0000FF00FFFF
FFFF00FF0000FF00FF000000FFFFFFFFFFFF00FFFFFF0000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF00FFFFFFFF0000FFFFFFFFFFFF00FF00FFFFFFFF00FFFFFFFFFF0000000000FFFFFF
FFFF00FF00FF0000FF0000FFFFFF0000FF0000FFFF00FF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFF00FF00FFFFFF00FF00FF
FFFFFFFFFF00FFFF00FF00FFFFFF0000FFFF00FFFF0000FFFFFFFFFFFFFF0000FFFF0000
0000FF00FF00FFFFFF00FF00FFFFFFFF00FFFFFFFF00FFFFFF00FF00FF
FFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFF
FFFFFFFF00FFFFFF00FFFFFF00FF00FFFFFFFF00FFFF00FFFFFFFFFFFF00FF00FFFF00FF
00FF00FF00FFFFFFFF000000FFFFFF0000FF0000FFFF00FFFFFF00FF00
FFFFFFFFFFFFFFFF00FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF00FFFFFF00
FFFFFFFFFFFFFF000000FFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFF
FFFF0000FFFFFFFF00FFFF0000FFFFFFFFFFFF0000FF00FFFFFFFFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF00FF00FFFFFFFFFFFFFF00FF00
FF00FFFFFF00FFFF00FFFF00FFFF00FF00FFFFFFFF0000FFFF00FFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FF00FFFFFF00
FFFFFFFFFFFF0000FFFFFF00FF00FF00FFFFFF00FFFFFF00FFFF00FFFFFF00FFFFFFFFFF
00FFFFFFFFFF0000FF00FF00FF00FFFF00FF00FFFFFFFFFFFFFF0000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF00FFFFFFFFFF00FFFFFFFF
FFFF00FF00FFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF00FF00FFFF00FFFFFFFF
00FFFF000000FFFFFFFF00FF00FFFF00FFFFFFFFFF00FF00FFFF00FF00
FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF00FFFF00FF00
FF00FFFF00FF00FF00FFFFFFFFFFFF00FFFFFFFFFF00FFFFFF00FF00FFFFFFFF00FFFF00
FFFFFFFF0000FFFFFFFFFF00FFFF00FF00FF000000FF00FF0000FFFF00
FFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00FFFFFFFFFF00FFFF00FFFFFFFFFF00FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF00FF00FFFFFFFFFF0000FFFFFF0000FF00FFFF00FFFF0000FF0000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFFFF00FF00FFFFFFFFFFFFFFFF
FF00FFFFFFFF00FF0000FF00FFFF000000FF00FFFFFFFFFFFFFFFFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF0000000000FFFFFFFFFFFFFFFF00FF00FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF0000FF00FFFFFF00FFFF00FF00FF00FF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFF
FFFFFF00FFFFFFFFFF00FFFFFFFFFF00FF00FFFF00FF00FFFFFFFF00FFFFFFFFFFFFFF00
000000FFFF00FFFFFFFFFFFF0000FF00FFFFFF00FFFFFF00FFFF000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF00FFFF
FFFF00FF00FFFFFFFFFFFFFF0000FF00FFFF00000000FF00FFFFFFFFFF
FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF0000FFFF00FFFF
FF00FFFFFFFFFFFFFF00FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF
FFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF0000FFFF00FFFFFFFFFF00FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFF00FFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFF00FFFFFF00FF00FFFFFF00FF00FFFF00FFFF00FFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFF0000FFFFFF00FF00FFFFFFFFFF000000FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFF00FFFFFFFFFF00FFFF0000FF00FFFFFFFFFFFFFFFFFFFFFFFF00000000FF
FFFFFFFFFFFFFFFFFF0000FFFFFFFF00FFFFFFFFFFFFFFFF00FF000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FF
FFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFF00FFFF00FFFFFFFFFF00000000FF00
00FFFFFFFFFF00FF00FFFFFFFFFF00FFFFFF00FFFFFFFFFFFFFFFF0000
FFFFFFFFFFFFFFFFFFFF00FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF
FFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFFFF00FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00FF00FFFF00FF0000FFFF00FFFFFFFFFFFFFFFFFFFFFF00FF
FFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFF00FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF00FFFFFFFF00FFFFFFFFFF00FFFFFFFF
FF00FFFF00FFFFFF00FF00FFFFFFFFFF00FFFF00FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFF00FFFFFFFFFFFFFFFFFF00FFFFFFFF
FFFFFF00FFFF00FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFF00FF00FF00FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFF00FF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF0000FFFFFFFFFFFF00FFFFFF00FF00FFFF00FFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFFFF00FFFFFF00FF00FFFFFFFFFFFFFF00FFFFFFFFFFFF00FFFFFF
FFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF00FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF00FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FFFF00FFFF00FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF00FFFFFFFF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF
FFFFFF00FF0000FF00FFFFFFFFFFFF00FF00FFFFFF00FF0000FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFF00FFFF00FFFFFFFFFFFFFFFFFFFFFF
FFFF00FFFFFF00FFFFFFFFFFFFFFFFFF00FFFFFFFF00FFFFFFFFFFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF00FFFF00FF00FFFFFFFFFFFFFFFFFFFFFFFFFF00
FFFF0000FF00FF00FF00FFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFF00FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFF00FFFFFF
FFFFFFFF00FF00FFFFFFFF0000FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
FFFFFFFFFF00FFFFFFFFFFFF00FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF00FFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF
FFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFF0000FFFFFF
FFFFFFFFFFFFFF00FFFFFF00FF00FFFFFFFFFFFFFFFFFFFF00FF00FFFF
FFFFFFFFFFFFFFFFFF00FFFFFFFF00FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF
FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFF0000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF00FFFFFFFFFF00FFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFF
FFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFF
FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF00FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.48.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "DensityGraphics", "\[SkeletonIndicator]"}],
  
  False,
  Editable->False]], "Output",
 CellLabel->"Out[39]= ",
 CellTags->"S5.48.1"]
}, Open  ]],

Cell["\<\
Display with a small matrix size. Note that the density of non\[Hyphen]zero \
values is now obscured. \
\>", "MathCaption",
 CellTags->{"S5.48.1", "1.48"}],

Cell[CellGroupData[{

Cell["MatrixPlot[mat, MaxMatrixSize -> 20]", "Input",
 CellLabel->"In[40]:= ",
 CellTags->"S5.48.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0144707 0.00952018 0.985529 0.00952018 [
[.01447 -0.0125 -3 -9 ]
[.01447 -0.0125 3 0 ]
[.20487 -0.0125 -6 -9 ]
[.20487 -0.0125 6 0 ]
[.39528 -0.0125 -6 -9 ]
[.39528 -0.0125 6 0 ]
[.58568 -0.0125 -6 -9 ]
[.58568 -0.0125 6 0 ]
[.77609 -0.0125 -6 -9 ]
[.77609 -0.0125 6 0 ]
[.96649 -0.0125 -9 -9 ]
[.96649 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .03351 -18 -4.5 ]
[-0.0125 .03351 0 4.5 ]
[-0.0125 .22391 -12 -4.5 ]
[-0.0125 .22391 0 4.5 ]
[-0.0125 .41432 -12 -4.5 ]
[-0.0125 .41432 0 4.5 ]
[-0.0125 .60472 -12 -4.5 ]
[-0.0125 .60472 0 4.5 ]
[-0.0125 .79513 -12 -4.5 ]
[-0.0125 .79513 0 4.5 ]
[-0.0125 .98553 -6 -4.5 ]
[-0.0125 .98553 0 4.5 ]
[ 0 0 -0.125 0 ]
[.01447 1.0125 -3 0 ]
[.01447 1.0125 3 9 ]
[.20487 1.0125 -6 0 ]
[.20487 1.0125 6 9 ]
[.39528 1.0125 -6 0 ]
[.39528 1.0125 6 9 ]
[.58568 1.0125 -6 0 ]
[.58568 1.0125 6 9 ]
[.77609 1.0125 -6 0 ]
[.77609 1.0125 6 9 ]
[.96649 1.0125 -9 0 ]
[.96649 1.0125 9 9 ]
[ 0 1 .125 0 ]
[1.0125 .03351 0 -4.5 ]
[1.0125 .03351 18 4.5 ]
[1.0125 .22391 0 -4.5 ]
[1.0125 .22391 12 4.5 ]
[1.0125 .41432 0 -4.5 ]
[1.0125 .41432 12 4.5 ]
[1.0125 .60472 0 -4.5 ]
[1.0125 .60472 12 4.5 ]
[1.0125 .79513 0 -4.5 ]
[1.0125 .79513 12 4.5 ]
[1.0125 .98553 0 -4.5 ]
[1.0125 .98553 6 4.5 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01447 0 m
.01447 .00625 L
s
[(0)] .01447 -0.0125 0 1 Mshowa
.20487 0 m
.20487 .00625 L
s
[(20)] .20487 -0.0125 0 1 Mshowa
.39528 0 m
.39528 .00625 L
s
[(40)] .39528 -0.0125 0 1 Mshowa
.58568 0 m
.58568 .00625 L
s
[(60)] .58568 -0.0125 0 1 Mshowa
.77609 0 m
.77609 .00625 L
s
[(80)] .77609 -0.0125 0 1 Mshowa
.96649 0 m
.96649 .00625 L
s
[(100)] .96649 -0.0125 0 1 Mshowa
0 0 m
1 0 L
s
0 .03351 m
.00625 .03351 L
s
[(100)] -0.0125 .03351 1 0 Mshowa
0 .22391 m
.00625 .22391 L
s
[(80)] -0.0125 .22391 1 0 Mshowa
0 .41432 m
.00625 .41432 L
s
[(60)] -0.0125 .41432 1 0 Mshowa
0 .60472 m
.00625 .60472 L
s
[(40)] -0.0125 .60472 1 0 Mshowa
0 .79513 m
.00625 .79513 L
s
[(20)] -0.0125 .79513 1 0 Mshowa
0 .98553 m
.00625 .98553 L
s
[(0)] -0.0125 .98553 1 0 Mshowa
0 0 m
0 1 L
s
.01447 .99375 m
.01447 1 L
s
[(0)] .01447 1.0125 0 -1 Mshowa
.20487 .99375 m
.20487 1 L
s
[(20)] .20487 1.0125 0 -1 Mshowa
.39528 .99375 m
.39528 1 L
s
[(40)] .39528 1.0125 0 -1 Mshowa
.58568 .99375 m
.58568 1 L
s
[(60)] .58568 1.0125 0 -1 Mshowa
.77609 .99375 m
.77609 1 L
s
[(80)] .77609 1.0125 0 -1 Mshowa
.96649 .99375 m
.96649 1 L
s
[(100)] .96649 1.0125 0 -1 Mshowa
0 1 m
1 1 L
s
.99375 .03351 m
1 .03351 L
s
[(100)] 1.0125 .03351 -1 0 Mshowa
.99375 .22391 m
1 .22391 L
s
[(80)] 1.0125 .22391 -1 0 Mshowa
.99375 .41432 m
1 .41432 L
s
[(60)] 1.0125 .41432 -1 0 Mshowa
.99375 .60472 m
1 .60472 L
s
[(40)] 1.0125 .60472 -1 0 Mshowa
.99375 .79513 m
1 .79513 L
s
[(20)] 1.0125 .79513 -1 0 Mshowa
.99375 .98553 m
1 .98553 L
s
[(0)] 1.0125 .98553 -1 0 Mshowa
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
17 string
17 17 8 [17 0 0 17 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FF00000000000000000000000000000000
0000000000000000000000000000000000
FFFF000000000000000000000000000000
0000000000000000000000000000000000
0000000000000000000000000000000000
00FF000000000000000000000000000000
0000000000000000000000000000000000
FFFF000000000000000000000000000000
FF00000000000000000000000000000000
FF00000000000000000000000000000000
FF00000000000000000000000000000000
FF00FF0000000000000000000000000000
FF0000000000FF00000000000000000000
FF0000FF00000000000000000000000000
FF000000FF000000000000000000000000
FF00000000FF00FF00000000FF00000000
FF00FF00000000FFFFFF00FFFF00000000
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.48.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "DensityGraphics", "\[SkeletonIndicator]"}],
  
  False,
  Editable->False]], "Output",
 CellLabel->"Out[40]= ",
 CellTags->"S5.48.1"]
}, Open  ]],

Cell["\<\
Display with shading indicating the density of non\[Hyphen]zero elements. \
\>", "MathCaption",
 CellTags->{"S5.48.1", "1.49"}],

Cell[CellGroupData[{

Cell["\<\
MatrixPlot[mat,
    MaxMatrixSize -> 20,
    ColorFunction -> (GrayLevel[1 - #] &),
    ColorFunctionScaling -> True]\
\>", "Input",
 CellLabel->"In[41]:= ",
 CellTags->"S5.48.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0144707 0.00952018 0.985529 0.00952018 [
[.01447 -0.0125 -3 -9 ]
[.01447 -0.0125 3 0 ]
[.20487 -0.0125 -6 -9 ]
[.20487 -0.0125 6 0 ]
[.39528 -0.0125 -6 -9 ]
[.39528 -0.0125 6 0 ]
[.58568 -0.0125 -6 -9 ]
[.58568 -0.0125 6 0 ]
[.77609 -0.0125 -6 -9 ]
[.77609 -0.0125 6 0 ]
[.96649 -0.0125 -9 -9 ]
[.96649 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .03351 -18 -4.5 ]
[-0.0125 .03351 0 4.5 ]
[-0.0125 .22391 -12 -4.5 ]
[-0.0125 .22391 0 4.5 ]
[-0.0125 .41432 -12 -4.5 ]
[-0.0125 .41432 0 4.5 ]
[-0.0125 .60472 -12 -4.5 ]
[-0.0125 .60472 0 4.5 ]
[-0.0125 .79513 -12 -4.5 ]
[-0.0125 .79513 0 4.5 ]
[-0.0125 .98553 -6 -4.5 ]
[-0.0125 .98553 0 4.5 ]
[ 0 0 -0.125 0 ]
[.01447 1.0125 -3 0 ]
[.01447 1.0125 3 9 ]
[.20487 1.0125 -6 0 ]
[.20487 1.0125 6 9 ]
[.39528 1.0125 -6 0 ]
[.39528 1.0125 6 9 ]
[.58568 1.0125 -6 0 ]
[.58568 1.0125 6 9 ]
[.77609 1.0125 -6 0 ]
[.77609 1.0125 6 9 ]
[.96649 1.0125 -9 0 ]
[.96649 1.0125 9 9 ]
[ 0 1 .125 0 ]
[1.0125 .03351 0 -4.5 ]
[1.0125 .03351 18 4.5 ]
[1.0125 .22391 0 -4.5 ]
[1.0125 .22391 12 4.5 ]
[1.0125 .41432 0 -4.5 ]
[1.0125 .41432 12 4.5 ]
[1.0125 .60472 0 -4.5 ]
[1.0125 .60472 12 4.5 ]
[1.0125 .79513 0 -4.5 ]
[1.0125 .79513 12 4.5 ]
[1.0125 .98553 0 -4.5 ]
[1.0125 .98553 6 4.5 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01447 0 m
.01447 .00625 L
s
[(0)] .01447 -0.0125 0 1 Mshowa
.20487 0 m
.20487 .00625 L
s
[(20)] .20487 -0.0125 0 1 Mshowa
.39528 0 m
.39528 .00625 L
s
[(40)] .39528 -0.0125 0 1 Mshowa
.58568 0 m
.58568 .00625 L
s
[(60)] .58568 -0.0125 0 1 Mshowa
.77609 0 m
.77609 .00625 L
s
[(80)] .77609 -0.0125 0 1 Mshowa
.96649 0 m
.96649 .00625 L
s
[(100)] .96649 -0.0125 0 1 Mshowa
0 0 m
1 0 L
s
0 .03351 m
.00625 .03351 L
s
[(100)] -0.0125 .03351 1 0 Mshowa
0 .22391 m
.00625 .22391 L
s
[(80)] -0.0125 .22391 1 0 Mshowa
0 .41432 m
.00625 .41432 L
s
[(60)] -0.0125 .41432 1 0 Mshowa
0 .60472 m
.00625 .60472 L
s
[(40)] -0.0125 .60472 1 0 Mshowa
0 .79513 m
.00625 .79513 L
s
[(20)] -0.0125 .79513 1 0 Mshowa
0 .98553 m
.00625 .98553 L
s
[(0)] -0.0125 .98553 1 0 Mshowa
0 0 m
0 1 L
s
.01447 .99375 m
.01447 1 L
s
[(0)] .01447 1.0125 0 -1 Mshowa
.20487 .99375 m
.20487 1 L
s
[(20)] .20487 1.0125 0 -1 Mshowa
.39528 .99375 m
.39528 1 L
s
[(40)] .39528 1.0125 0 -1 Mshowa
.58568 .99375 m
.58568 1 L
s
[(60)] .58568 1.0125 0 -1 Mshowa
.77609 .99375 m
.77609 1 L
s
[(80)] .77609 1.0125 0 -1 Mshowa
.96649 .99375 m
.96649 1 L
s
[(100)] .96649 1.0125 0 -1 Mshowa
0 1 m
1 1 L
s
.99375 .03351 m
1 .03351 L
s
[(100)] 1.0125 .03351 -1 0 Mshowa
.99375 .22391 m
1 .22391 L
s
[(80)] 1.0125 .22391 -1 0 Mshowa
.99375 .41432 m
1 .41432 L
s
[(60)] 1.0125 .41432 -1 0 Mshowa
.99375 .60472 m
1 .60472 L
s
[(40)] 1.0125 .60472 -1 0 Mshowa
.99375 .79513 m
1 .79513 L
s
[(20)] 1.0125 .79513 -1 0 Mshowa
.99375 .98553 m
1 .98553 L
s
[(0)] 1.0125 .98553 -1 0 Mshowa
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
17 string
17 17 8 [17 0 0 17 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FFD8F0C8D8B0A898907058585038302050
F0F0D8D0D0C8A8B8505870606010001018
FFFFE8E0B888B090A86090583820602840
F8E0C0B8A8B0B0A0909070604020205058
F8E8E8E0D0C0C8D0807870506040583048
F0FFC8C8B8C8C0D0A08090707068604850
F0E8E8E8D0C8B8B0B09090988058686860
FFFFF8D8D0C8B0C8A8A090B87088887078
FFF8E8F8E0C0D0C89880A0C09890A078B0
FFF8E8E0C0D8C0C8B0C8988870809880D0
FFE8F8E0D0C0D0B8B8D0C0B89098A888A0
FFF0FFF8E0E8E0E0C8B8E8D8B8C88098A0
FFF0F8F8E8D0FFE0B8B8E8A0D8A0C0D8B0
FFF8F8FFF0F8F8F8E8E0E8E8C8C8D0C8D8
FFF8F8F8FFD8D8F8F0E0F8C8D8C8E0E8D0
FFF8E8F8F8FFF8FFF0F8E8F8FFE8F0F8E8
FFF8FFF8F8F8F8FFFFFFF8FFFFF8F8F8F8
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.48.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "DensityGraphics", "\[SkeletonIndicator]"}],
  
  False,
  Editable->False]], "Output",
 CellLabel->"Out[41]= ",
 CellTags->"S5.48.1"]
}, Open  ]],

Cell["\<\
The functionality can be applied to symbolic matrices as well as numeric \
matrices. \
\>", "Text",
 CellTags->{"S5.48.1", "1.50"}],

Cell[TextData[{
 "Display structure of a matrix composed of ",
 StyleBox["True", "MR"],
 " and ",
 StyleBox["False", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.48.1", "1.51"}],

Cell[CellGroupData[{

Cell["\<\
MatrixPlot[Table[IntegerQ[Sqrt[n * m]],
              {n, 10}, {m, 10}],
           False]\
\>", "Input",
 CellLabel->"In[42]:= ",
 CellTags->"S5.48.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0288462 0.0961538 1.02885 0.0961538 [
[.16346 -0.0125 -3 -9 ]
[.16346 -0.0125 3 0 ]
[.35577 -0.0125 -3 -9 ]
[.35577 -0.0125 3 0 ]
[.54808 -0.0125 -3 -9 ]
[.54808 -0.0125 3 0 ]
[.74038 -0.0125 -3 -9 ]
[.74038 -0.0125 3 0 ]
[.93269 -0.0125 -6 -9 ]
[.93269 -0.0125 6 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .06731 -12 -4.5 ]
[-0.0125 .06731 0 4.5 ]
[-0.0125 .25962 -6 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .45192 -6 -4.5 ]
[-0.0125 .45192 0 4.5 ]
[-0.0125 .64423 -6 -4.5 ]
[-0.0125 .64423 0 4.5 ]
[-0.0125 .83654 -6 -4.5 ]
[-0.0125 .83654 0 4.5 ]
[ 0 0 -0.125 0 ]
[.16346 1.0125 -3 0 ]
[.16346 1.0125 3 9 ]
[.35577 1.0125 -3 0 ]
[.35577 1.0125 3 9 ]
[.54808 1.0125 -3 0 ]
[.54808 1.0125 3 9 ]
[.74038 1.0125 -3 0 ]
[.74038 1.0125 3 9 ]
[.93269 1.0125 -6 0 ]
[.93269 1.0125 6 9 ]
[ 0 1 .125 0 ]
[1.0125 .06731 0 -4.5 ]
[1.0125 .06731 12 4.5 ]
[1.0125 .25962 0 -4.5 ]
[1.0125 .25962 6 4.5 ]
[1.0125 .45192 0 -4.5 ]
[1.0125 .45192 6 4.5 ]
[1.0125 .64423 0 -4.5 ]
[1.0125 .64423 6 4.5 ]
[1.0125 .83654 0 -4.5 ]
[1.0125 .83654 6 4.5 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.16346 0 m
.16346 .00625 L
s
[(2)] .16346 -0.0125 0 1 Mshowa
.35577 0 m
.35577 .00625 L
s
[(4)] .35577 -0.0125 0 1 Mshowa
.54808 0 m
.54808 .00625 L
s
[(6)] .54808 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(8)] .74038 -0.0125 0 1 Mshowa
.93269 0 m
.93269 .00625 L
s
[(10)] .93269 -0.0125 0 1 Mshowa
0 0 m
1 0 L
s
0 .06731 m
.00625 .06731 L
s
[(10)] -0.0125 .06731 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(8)] -0.0125 .25962 1 0 Mshowa
0 .45192 m
.00625 .45192 L
s
[(6)] -0.0125 .45192 1 0 Mshowa
0 .64423 m
.00625 .64423 L
s
[(4)] -0.0125 .64423 1 0 Mshowa
0 .83654 m
.00625 .83654 L
s
[(2)] -0.0125 .83654 1 0 Mshowa
0 0 m
0 1 L
s
.16346 .99375 m
.16346 1 L
s
[(2)] .16346 1.0125 0 -1 Mshowa
.35577 .99375 m
.35577 1 L
s
[(4)] .35577 1.0125 0 -1 Mshowa
.54808 .99375 m
.54808 1 L
s
[(6)] .54808 1.0125 0 -1 Mshowa
.74038 .99375 m
.74038 1 L
s
[(8)] .74038 1.0125 0 -1 Mshowa
.93269 .99375 m
.93269 1 L
s
[(10)] .93269 1.0125 0 -1 Mshowa
0 1 m
1 1 L
s
.99375 .06731 m
1 .06731 L
s
[(10)] 1.0125 .06731 -1 0 Mshowa
.99375 .25962 m
1 .25962 L
s
[(8)] 1.0125 .25962 -1 0 Mshowa
.99375 .45192 m
1 .45192 L
s
[(6)] 1.0125 .45192 -1 0 Mshowa
.99375 .64423 m
1 .64423 L
s
[(4)] 1.0125 .64423 -1 0 Mshowa
.99375 .83654 m
1 .83654 L
s
[(2)] 1.0125 .83654 -1 0 Mshowa
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
10 string
10 10 8 [10 0 0 10 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FFFFFFFFFFFFFFFFFF00
00FFFF00FFFFFFFF00FF
FF00FFFFFFFFFF00FFFF
FFFFFFFFFFFF00FFFFFF
FFFFFFFFFF00FFFFFFFF
FFFFFFFF00FFFFFFFFFF
00FFFF00FFFFFFFF00FF
FFFF00FFFFFFFFFFFFFF
FF00FFFFFFFFFF00FFFF
00FFFF00FFFFFFFF00FF
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.48.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "DensityGraphics", "\[SkeletonIndicator]"}],
  
  False,
  Editable->False]], "Output",
 CellLabel->"Out[42]= ",
 CellTags->"S5.48.1"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.48.1"->{
    Cell[1776, 53, 148, 6, 36, "Subsection",
      CellTags->{"S5.48.1", "1.1"}],
    Cell[1927, 61, 327, 6, 56, "Text",
      CellTags->{"S5.48.1", "1.2"}],
    Cell[2257, 69, 5465, 166, 106, "DefinitionBox",
      CellTags->"S5.48.1"],
    Cell[7725, 237, 75, 1, 15, "Caption",
      CellTags->"S5.48.1"],
    Cell[7803, 240, 78, 1, 40, "MathCaption",
      CellTags->{"S5.48.1", "1.3"}],
    Cell[7884, 243, 99, 2, 28, "Input",
      CellTags->"S5.48.1"],
    Cell[7986, 247, 235, 8, 40, "MathCaption",
      CellTags->{"S5.48.1", "1.4"}],
    Cell[8246, 259, 106, 2, 28, "Input",
      CellTags->"S5.48.1"],
    Cell[8355, 263, 254, 9, 51, "Output",
      CellTags->"S5.48.1"],
    Cell[8624, 275, 78, 1, 40, "MathCaption",
      CellTags->{"S5.48.1", "1.5"}],
    Cell[8727, 280, 106, 2, 28, "Input",
      CellTags->"S5.48.1"],
    Cell[8836, 284, 254, 9, 51, "Output",
      CellTags->"S5.48.1"],
    Cell[9105, 296, 133, 3, 40, "MathCaption",
      CellTags->{"S5.48.1", "1.6"}],
    Cell[9263, 303, 82, 2, 28, "Input",
      CellTags->"S5.48.1"],
    Cell[9348, 307, 351, 12, 25, "Output",
      CellTags->"S5.48.1"],
    Cell[9714, 322, 147, 5, 40, "MathCaption",
      CellTags->{"S5.48.1", "1.7"}],
    Cell[9886, 331, 76, 2, 70, "Input",
      CellTags->"S5.48.1"],
    Cell[9965, 335, 296, 11, 70, "Output",
      CellTags->"S5.48.1"],
    Cell[10276, 349, 136, 3, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.8"}],
    Cell[10437, 356, 91, 2, 70, "Input",
      CellTags->"S5.48.1"],
    Cell[10531, 360, 282, 9, 70, "Output",
      CellTags->"S5.48.1"],
    Cell[10828, 372, 176, 7, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.9"}],
    Cell[11029, 383, 129, 5, 70, "Input",
      CellTags->"S5.48.1"],
    Cell[11161, 390, 344, 11, 70, "Output",
      CellTags->"S5.48.1"],
    Cell[11520, 404, 12319, 394, 70, "DefinitionBox",
      CellTags->"S5.48.1"],
    Cell[23842, 800, 87, 1, 70, "Caption",
      CellTags->"S5.48.1"],
    Cell[23932, 803, 237, 8, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.10"}],
    Cell[24194, 815, 102, 2, 70, "Input",
      CellTags->"S5.48.1"],
    Cell[24299, 819, 1280, 43, 70, "Output",
      CellTags->"S5.48.1"],
    Cell[25594, 865, 233, 8, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.11"}],
    Cell[25852, 877, 92, 2, 70, "Input",
      CellTags->"S5.48.1"],
    Cell[25947, 881, 746, 25, 70, "Output",
      CellTags->"S5.48.1"],
    Cell[26708, 909, 258, 8, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.12"}],
    Cell[26991, 921, 100, 2, 70, "Input",
      CellTags->"S5.48.1"],
    Cell[27094, 925, 761, 27, 70, "Output",
      CellTags->"S5.48.1"],
    Cell[27870, 955, 233, 7, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.13"}],
    Cell[28128, 966, 95, 2, 70, "Input",
      CellTags->"S5.48.1"],
    Cell[28226, 970, 1021, 35, 70, "Output",
      CellTags->"S5.48.1"],
    Cell[29262, 1008, 362, 11, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.14"}],
    Cell[29649, 1023, 107, 2, 70, "Input",
      CellTags->"S5.48.1"],
    Cell[29759, 1027, 624, 22, 70, "Output",
      CellTags->"S5.48.1"],
    Cell[30398, 1052, 341, 10, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.15"}],
    Cell[30764, 1066, 106, 2, 70, "Input",
      CellTags->"S5.48.1"],
    Cell[30873, 1070, 624, 22, 70, "Output",
      CellTags->"S5.48.1"],
    Cell[31512, 1095, 1062, 34, 70, "DefinitionBox",
      CellTags->"S5.48.1"],
    Cell[32577, 1131, 61, 1, 70, "Caption",
      CellTags->"S5.48.1"],
    Cell[32641, 1134, 204, 9, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.16"}],
    Cell[32870, 1147, 95, 2, 70, "Input",
      CellTags->"S5.48.1"],
    Cell[32968, 1151, 139, 4, 70, "Output",
      CellTags->"S5.48.1"],
    Cell[33122, 1158, 15767, 494, 70, "DefinitionBox",
      CellTags->"S5.48.1"],
    Cell[48892, 1654, 59, 1, 70, "Caption",
      CellTags->"S5.48.1"],
    Cell[48954, 1657, 236, 9, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.17"}],
    Cell[49215, 1670, 101, 2, 70, "Input",
      CellTags->"S5.48.1"],
    Cell[49319, 1674, 639, 22, 70, "Output",
      CellTags->"S5.48.1"],
    Cell[49973, 1699, 111, 1, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.18"}],
    Cell[50109, 1704, 109, 2, 70, "Input",
      CellTags->"S5.48.1"],
    Cell[50221, 1708, 279, 10, 70, "Output",
      CellTags->"S5.48.1"],
    Cell[50515, 1721, 126, 3, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.19"}],
    Cell[50666, 1728, 102, 2, 70, "Input",
      CellTags->"S5.48.1"],
    Cell[50771, 1732, 321, 11, 70, "Output",
      CellTags->"S5.48.1"],
    Cell[51107, 1746, 245, 8, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.20"}],
    Cell[51377, 1758, 95, 2, 70, "Input",
      CellTags->"S5.48.1"],
    Cell[51475, 1762, 442, 16, 70, "Output",
      CellTags->"S5.48.1"],
    Cell[51932, 1781, 115, 2, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.21"}],
    Cell[52072, 1787, 102, 2, 70, "Input",
      CellTags->"S5.48.1"],
    Cell[52177, 1791, 321, 11, 70, "Output",
      CellTags->"S5.48.1"],
    Cell[52513, 1805, 313, 6, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.22"}],
    Cell[52851, 1815, 113, 2, 70, "Input",
      CellTags->"S5.48.1"],
    Cell[52967, 1819, 301, 11, 70, "Output",
      CellTags->"S5.48.1"],
    Cell[53283, 1833, 2150, 66, 70, "DefinitionBox",
      CellTags->"S5.48.1"],
    Cell[55436, 1901, 91, 1, 70, "Caption",
      CellTags->"S5.48.1"],
    Cell[55530, 1904, 182, 4, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.23"}],
    Cell[55737, 1912, 167, 6, 70, "Input",
      CellTags->"S5.48.1"],
    Cell[55907, 1920, 334, 12, 70, "Output",
      CellTags->"S5.48.1"],
    Cell[56256, 1935, 2544, 82, 70, "DefinitionBox",
      CellTags->"S5.48.1"],
    Cell[58803, 2019, 74, 1, 70, "Caption",
      CellTags->"S5.48.1"],
    Cell[58880, 2022, 358, 12, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.24"}],
    Cell[59263, 2038, 153, 5, 70, "Input",
      CellTags->"S5.48.1"],
    Cell[59419, 2045, 1063, 31, 70, "Output",
      CellTags->"S5.48.1"],
    Cell[60497, 2079, 87, 1, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.25"}],
    Cell[60609, 2084, 99, 2, 70, "Input",
      CellTags->"S5.48.1"],
    Cell[60711, 2088, 345, 10, 70, "Output",
      CellTags->"S5.48.1"],
    Cell[61071, 2101, 87, 1, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.26"}],
    Cell[61183, 2106, 77, 2, 70, "Input",
      CellTags->"S5.48.1"],
    Cell[61263, 2110, 338, 11, 70, "Output",
      CellTags->"S5.48.1"],
    Cell[61616, 2124, 2856, 88, 70, "DefinitionBox",
      CellTags->"S5.48.1"],
    Cell[64475, 2214, 71, 1, 70, "Caption",
      CellTags->"S5.48.1"],
    Cell[64549, 2217, 406, 10, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.27"}],
    Cell[64980, 2231, 98, 2, 70, "Input",
      CellTags->"S5.48.1"],
    Cell[65081, 2235, 558, 19, 70, "Output",
      CellTags->"S5.48.1"],
    Cell[65654, 2257, 126, 3, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.28"}],
    Cell[65805, 2264, 87, 2, 70, "Input",
      CellTags->"S5.48.1"],
    Cell[65895, 2268, 744, 24, 70, "Output",
      CellTags->"S5.48.1"],
    Cell[66654, 2295, 132, 3, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.29"}],
    Cell[66811, 2302, 86, 2, 70, "Input",
      CellTags->"S5.48.1"],
    Cell[66900, 2306, 307, 10, 70, "Output",
      CellTags->"S5.48.1"],
    Cell[67222, 2319, 6892, 192, 70, "DefinitionBox",
      CellTags->"S5.48.1"],
    Cell[74117, 2513, 109, 5, 70, "Caption",
      CellTags->"S5.48.1"],
    Cell[74229, 2520, 291, 7, 70, "Text",
      CellTags->{"S5.48.1", "1.30"}],
    Cell[74523, 2529, 480, 15, 70, "Text",
      CellTags->{"S5.48.1", "1.31"}],
    Cell[75006, 2546, 80, 1, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.32"}],
    Cell[75089, 2549, 100, 2, 70, "Input",
      CellTags->"S5.48.1"],
    Cell[75192, 2553, 123, 3, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.33"}],
    Cell[75340, 2560, 90, 2, 70, "Input",
      CellTags->"S5.48.1"],
    Cell[75433, 2564, 172, 6, 70, "Output",
      CellTags->"S5.48.1"],
    Cell[75620, 2573, 110, 3, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.34"}],
    Cell[75733, 2578, 94, 2, 70, "Input",
      CellTags->"S5.48.1"],
    Cell[75830, 2582, 254, 6, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.35"}],
    Cell[76109, 2592, 100, 2, 70, "Input",
      CellTags->"S5.48.1"],
    Cell[76212, 2596, 188, 6, 70, "Output",
      CellTags->"S5.48.1"],
    Cell[76415, 2605, 2110, 68, 70, "DefinitionBox",
      CellTags->"S5.48.1"],
    Cell[78528, 2675, 70, 1, 70, "Caption",
      CellTags->"S5.48.1"],
    Cell[78601, 2678, 377, 7, 70, "Text",
      CellTags->{"S5.48.1", "1.36"}],
    Cell[78981, 2687, 96, 1, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.37"}],
    Cell[79102, 2692, 109, 2, 70, "Input",
      CellTags->"S5.48.1"],
    Cell[79214, 2696, 8699, 316, 70, 8628, 313, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.48.1"],
    Cell[87916, 3014, 191, 7, 70, "Output",
      CellTags->"S5.48.1"],
    Cell[88122, 3024, 78, 1, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.38"}],
    Cell[88225, 3029, 107, 2, 70, "Input",
      CellTags->"S5.48.1"],
    Cell[88335, 3033, 403, 14, 70, "Output",
      CellTags->"S5.48.1"],
    Cell[88753, 3050, 153, 4, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.39"}],
    Cell[88931, 3058, 84, 2, 70, "Input",
      CellTags->"S5.48.1"],
    Cell[89018, 3062, 9953, 709, 70, 9882, 706, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.48.1"],
    Cell[98974, 3773, 191, 7, 70, "Output",
      CellTags->"S5.48.1"],
    Cell[99180, 3783, 104, 1, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.40"}],
    Cell[99309, 3788, 87, 2, 70, "Input",
      CellTags->"S5.48.1"],
    Cell[99399, 3792, 9949, 708, 70, 9878, 705, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.48.1"],
    Cell[109351, 4502, 191, 7, 70, "Output",
      CellTags->"S5.48.1"],
    Cell[109557, 4512, 773, 24, 70, "DefinitionBox",
      CellTags->"S5.48.1"],
    Cell[110333, 4538, 113, 5, 70, "Caption",
      CellTags->"S5.48.1"],
    Cell[110449, 4545, 836, 19, 70, "Text",
      CellTags->{"S5.48.1", "1.41"}],
    Cell[111288, 4566, 247, 7, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.42"}],
    Cell[111560, 4577, 104, 2, 70, "Input",
      CellTags->"S5.48.1"],
    Cell[111667, 4581, 3635, 220, 70, 3564, 217, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.48.1"],
    Cell[115305, 4803, 191, 7, 70, "Output",
      CellTags->"S5.48.1"],
    Cell[115511, 4813, 442, 7, 70, "Text",
      CellTags->{"S5.48.1", "1.43"}],
    Cell[115956, 4822, 206, 4, 70, "Text",
      CellTags->{"S5.48.1", "1.44"}],
    Cell[116165, 4828, 87, 1, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.45"}],
    Cell[116255, 4831, 77, 2, 70, "Input",
      CellTags->"S5.48.1"],
    Cell[116335, 4835, 358, 11, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.46"}],
    Cell[116696, 4848, 164, 6, 70, "Input",
      CellTags->"S5.48.1"],
    Cell[116863, 4856, 74, 1, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.47"}],
    Cell[116962, 4861, 79, 2, 70, "Input",
      CellTags->"S5.48.1"],
    Cell[117044, 4865, 24314, 519, 70, 24243, 516, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.48.1"],
    Cell[141361, 5386, 191, 7, 70, "Output",
      CellTags->"S5.48.1"],
    Cell[141567, 5396, 165, 4, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.48"}],
    Cell[141757, 5404, 100, 2, 70, "Input",
      CellTags->"S5.48.1"],
    Cell[141860, 5408, 4199, 233, 70, 4128, 230, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.48.1"],
    Cell[146062, 5643, 191, 7, 70, "Output",
      CellTags->"S5.48.1"],
    Cell[146268, 5653, 137, 3, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.49"}],
    Cell[146430, 5660, 189, 7, 70, "Input",
      CellTags->"S5.48.1"],
    Cell[146622, 5669, 4199, 233, 70, 4128, 230, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.48.1"],
    Cell[150824, 5904, 191, 7, 70, "Output",
      CellTags->"S5.48.1"],
    Cell[151030, 5914, 141, 4, 70, "Text",
      CellTags->{"S5.48.1", "1.50"}],
    Cell[151174, 5920, 180, 7, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.51"}],
    Cell[151379, 5931, 162, 6, 70, "Input",
      CellTags->"S5.48.1"],
    Cell[151544, 5939, 3354, 202, 70, 3283, 199, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.48.1"],
    Cell[154901, 6143, 191, 7, 70, "Output",
      CellTags->"S5.48.1"]},
  "1.1"->{
    Cell[1776, 53, 148, 6, 36, "Subsection",
      CellTags->{"S5.48.1", "1.1"}]},
  "1.2"->{
    Cell[1927, 61, 327, 6, 56, "Text",
      CellTags->{"S5.48.1", "1.2"}]},
  "1.3"->{
    Cell[7803, 240, 78, 1, 40, "MathCaption",
      CellTags->{"S5.48.1", "1.3"}]},
  "1.4"->{
    Cell[7986, 247, 235, 8, 40, "MathCaption",
      CellTags->{"S5.48.1", "1.4"}]},
  "1.5"->{
    Cell[8624, 275, 78, 1, 40, "MathCaption",
      CellTags->{"S5.48.1", "1.5"}]},
  "1.6"->{
    Cell[9105, 296, 133, 3, 40, "MathCaption",
      CellTags->{"S5.48.1", "1.6"}]},
  "1.7"->{
    Cell[9714, 322, 147, 5, 40, "MathCaption",
      CellTags->{"S5.48.1", "1.7"}]},
  "1.8"->{
    Cell[10276, 349, 136, 3, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.8"}]},
  "1.9"->{
    Cell[10828, 372, 176, 7, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.9"}]},
  "1.10"->{
    Cell[23932, 803, 237, 8, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.10"}]},
  "1.11"->{
    Cell[25594, 865, 233, 8, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.11"}]},
  "1.12"->{
    Cell[26708, 909, 258, 8, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.12"}]},
  "1.13"->{
    Cell[27870, 955, 233, 7, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.13"}]},
  "1.14"->{
    Cell[29262, 1008, 362, 11, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.14"}]},
  "1.15"->{
    Cell[30398, 1052, 341, 10, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.15"}]},
  "1.16"->{
    Cell[32641, 1134, 204, 9, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.16"}]},
  "1.17"->{
    Cell[48954, 1657, 236, 9, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.17"}]},
  "1.18"->{
    Cell[49973, 1699, 111, 1, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.18"}]},
  "1.19"->{
    Cell[50515, 1721, 126, 3, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.19"}]},
  "1.20"->{
    Cell[51107, 1746, 245, 8, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.20"}]},
  "1.21"->{
    Cell[51932, 1781, 115, 2, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.21"}]},
  "1.22"->{
    Cell[52513, 1805, 313, 6, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.22"}]},
  "1.23"->{
    Cell[55530, 1904, 182, 4, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.23"}]},
  "1.24"->{
    Cell[58880, 2022, 358, 12, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.24"}]},
  "1.25"->{
    Cell[60497, 2079, 87, 1, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.25"}]},
  "1.26"->{
    Cell[61071, 2101, 87, 1, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.26"}]},
  "1.27"->{
    Cell[64549, 2217, 406, 10, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.27"}]},
  "1.28"->{
    Cell[65654, 2257, 126, 3, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.28"}]},
  "1.29"->{
    Cell[66654, 2295, 132, 3, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.29"}]},
  "1.30"->{
    Cell[74229, 2520, 291, 7, 70, "Text",
      CellTags->{"S5.48.1", "1.30"}]},
  "1.31"->{
    Cell[74523, 2529, 480, 15, 70, "Text",
      CellTags->{"S5.48.1", "1.31"}]},
  "1.32"->{
    Cell[75006, 2546, 80, 1, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.32"}]},
  "1.33"->{
    Cell[75192, 2553, 123, 3, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.33"}]},
  "1.34"->{
    Cell[75620, 2573, 110, 3, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.34"}]},
  "1.35"->{
    Cell[75830, 2582, 254, 6, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.35"}]},
  "1.36"->{
    Cell[78601, 2678, 377, 7, 70, "Text",
      CellTags->{"S5.48.1", "1.36"}]},
  "1.37"->{
    Cell[78981, 2687, 96, 1, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.37"}]},
  "1.38"->{
    Cell[88122, 3024, 78, 1, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.38"}]},
  "1.39"->{
    Cell[88753, 3050, 153, 4, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.39"}]},
  "1.40"->{
    Cell[99180, 3783, 104, 1, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.40"}]},
  "1.41"->{
    Cell[110449, 4545, 836, 19, 70, "Text",
      CellTags->{"S5.48.1", "1.41"}]},
  "1.42"->{
    Cell[111288, 4566, 247, 7, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.42"}]},
  "1.43"->{
    Cell[115511, 4813, 442, 7, 70, "Text",
      CellTags->{"S5.48.1", "1.43"}]},
  "1.44"->{
    Cell[115956, 4822, 206, 4, 70, "Text",
      CellTags->{"S5.48.1", "1.44"}]},
  "1.45"->{
    Cell[116165, 4828, 87, 1, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.45"}]},
  "1.46"->{
    Cell[116335, 4835, 358, 11, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.46"}]},
  "1.47"->{
    Cell[116863, 4856, 74, 1, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.47"}]},
  "1.48"->{
    Cell[141567, 5396, 165, 4, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.48"}]},
  "1.49"->{
    Cell[146268, 5653, 137, 3, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.49"}]},
  "1.50"->{
    Cell[151030, 5914, 141, 4, 70, "Text",
      CellTags->{"S5.48.1", "1.50"}]},
  "1.51"->{
    Cell[151174, 5920, 180, 7, 70, "MathCaption",
      CellTags->{"S5.48.1", "1.51"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.48.1", 155743, 6170},
  {"1.1", 168513, 6503},
  {"1.2", 168607, 6506},
  {"1.3", 168695, 6509},
  {"1.4", 168790, 6512},
  {"1.5", 168886, 6515},
  {"1.6", 168981, 6518},
  {"1.7", 169077, 6521},
  {"1.8", 169173, 6524},
  {"1.9", 169270, 6527},
  {"1.10", 169368, 6530},
  {"1.11", 169467, 6533},
  {"1.12", 169566, 6536},
  {"1.13", 169665, 6539},
  {"1.14", 169764, 6542},
  {"1.15", 169865, 6545},
  {"1.16", 169966, 6548},
  {"1.17", 170066, 6551},
  {"1.18", 170166, 6554},
  {"1.19", 170266, 6557},
  {"1.20", 170366, 6560},
  {"1.21", 170466, 6563},
  {"1.22", 170566, 6566},
  {"1.23", 170666, 6569},
  {"1.24", 170766, 6572},
  {"1.25", 170867, 6575},
  {"1.26", 170966, 6578},
  {"1.27", 171065, 6581},
  {"1.28", 171166, 6584},
  {"1.29", 171266, 6587},
  {"1.30", 171366, 6590},
  {"1.31", 171459, 6593},
  {"1.32", 171553, 6596},
  {"1.33", 171652, 6599},
  {"1.34", 171752, 6602},
  {"1.35", 171852, 6605},
  {"1.36", 171952, 6608},
  {"1.37", 172045, 6611},
  {"1.38", 172144, 6614},
  {"1.39", 172243, 6617},
  {"1.40", 172343, 6620},
  {"1.41", 172443, 6623},
  {"1.42", 172538, 6626},
  {"1.43", 172639, 6629},
  {"1.44", 172733, 6632},
  {"1.45", 172827, 6635},
  {"1.46", 172927, 6638},
  {"1.47", 173029, 6641},
  {"1.48", 173129, 6644},
  {"1.49", 173230, 6647},
  {"1.50", 173331, 6650},
  {"1.51", 173425, 6653}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 148, 6, 36, "Subsection",
  CellTags->{"S5.48.1", "1.1"}],
Cell[1927, 61, 327, 6, 56, "Text",
  CellTags->{"S5.48.1", "1.2"}],
Cell[2257, 69, 5465, 166, 106, "DefinitionBox",
  CellTags->"S5.48.1"],
Cell[7725, 237, 75, 1, 15, "Caption",
  CellTags->"S5.48.1"],
Cell[7803, 240, 78, 1, 40, "MathCaption",
  CellTags->{"S5.48.1", "1.3"}],
Cell[7884, 243, 99, 2, 28, "Input",
  CellTags->"S5.48.1"],
Cell[7986, 247, 235, 8, 40, "MathCaption",
  CellTags->{"S5.48.1", "1.4"}],

Cell[CellGroupData[{
Cell[8246, 259, 106, 2, 28, "Input",
  CellTags->"S5.48.1"],
Cell[8355, 263, 254, 9, 51, "Output",
  CellTags->"S5.48.1"]
}, Open  ]],
Cell[8624, 275, 78, 1, 40, "MathCaption",
  CellTags->{"S5.48.1", "1.5"}],

Cell[CellGroupData[{
Cell[8727, 280, 106, 2, 28, "Input",
  CellTags->"S5.48.1"],
Cell[8836, 284, 254, 9, 51, "Output",
  CellTags->"S5.48.1"]
}, Open  ]],
Cell[9105, 296, 133, 3, 40, "MathCaption",
  CellTags->{"S5.48.1", "1.6"}],

Cell[CellGroupData[{
Cell[9263, 303, 82, 2, 28, "Input",
  CellTags->"S5.48.1"],
Cell[9348, 307, 351, 12, 25, "Output",
  CellTags->"S5.48.1"]
}, Open  ]],
Cell[9714, 322, 147, 5, 40, "MathCaption",
  CellTags->{"S5.48.1", "1.7"}],

Cell[CellGroupData[{
Cell[9886, 331, 76, 2, 70, "Input",
  CellTags->"S5.48.1"],
Cell[9965, 335, 296, 11, 70, "Output",
  CellTags->"S5.48.1"]
}, Open  ]],
Cell[10276, 349, 136, 3, 70, "MathCaption",
  CellTags->{"S5.48.1", "1.8"}],

Cell[CellGroupData[{
Cell[10437, 356, 91, 2, 70, "Input",
  CellTags->"S5.48.1"],
Cell[10531, 360, 282, 9, 70, "Output",
  CellTags->"S5.48.1"]
}, Open  ]],
Cell[10828, 372, 176, 7, 70, "MathCaption",
  CellTags->{"S5.48.1", "1.9"}],

Cell[CellGroupData[{
Cell[11029, 383, 129, 5, 70, "Input",
  CellTags->"S5.48.1"],
Cell[11161, 390, 344, 11, 70, "Output",
  CellTags->"S5.48.1"]
}, Open  ]],
Cell[11520, 404, 12319, 394, 70, "DefinitionBox",
  CellTags->"S5.48.1"],
Cell[23842, 800, 87, 1, 70, "Caption",
  CellTags->"S5.48.1"],
Cell[23932, 803, 237, 8, 70, "MathCaption",
  CellTags->{"S5.48.1", "1.10"}],

Cell[CellGroupData[{
Cell[24194, 815, 102, 2, 70, "Input",
  CellTags->"S5.48.1"],
Cell[24299, 819, 1280, 43, 70, "Output",
  CellTags->"S5.48.1"]
}, Open  ]],
Cell[25594, 865, 233, 8, 70, "MathCaption",
  CellTags->{"S5.48.1", "1.11"}],

Cell[CellGroupData[{
Cell[25852, 877, 92, 2, 70, "Input",
  CellTags->"S5.48.1"],
Cell[25947, 881, 746, 25, 70, "Output",
  CellTags->"S5.48.1"]
}, Open  ]],
Cell[26708, 909, 258, 8, 70, "MathCaption",
  CellTags->{"S5.48.1", "1.12"}],

Cell[CellGroupData[{
Cell[26991, 921, 100, 2, 70, "Input",
  CellTags->"S5.48.1"],
Cell[27094, 925, 761, 27, 70, "Output",
  CellTags->"S5.48.1"]
}, Open  ]],
Cell[27870, 955, 233, 7, 70, "MathCaption",
  CellTags->{"S5.48.1", "1.13"}],

Cell[CellGroupData[{
Cell[28128, 966, 95, 2, 70, "Input",
  CellTags->"S5.48.1"],
Cell[28226, 970, 1021, 35, 70, "Output",
  CellTags->"S5.48.1"]
}, Open  ]],
Cell[29262, 1008, 362, 11, 70, "MathCaption",
  CellTags->{"S5.48.1", "1.14"}],

Cell[CellGroupData[{
Cell[29649, 1023, 107, 2, 70, "Input",
  CellTags->"S5.48.1"],
Cell[29759, 1027, 624, 22, 70, "Output",
  CellTags->"S5.48.1"]
}, Open  ]],
Cell[30398, 1052, 341, 10, 70, "MathCaption",
  CellTags->{"S5.48.1", "1.15"}],

Cell[CellGroupData[{
Cell[30764, 1066, 106, 2, 70, "Input",
  CellTags->"S5.48.1"],
Cell[30873, 1070, 624, 22, 70, "Output",
  CellTags->"S5.48.1"]
}, Open  ]],
Cell[31512, 1095, 1062, 34, 70, "DefinitionBox",
  CellTags->"S5.48.1"],
Cell[32577, 1131, 61, 1, 70, "Caption",
  CellTags->"S5.48.1"],
Cell[32641, 1134, 204, 9, 70, "MathCaption",
  CellTags->{"S5.48.1", "1.16"}],

Cell[CellGroupData[{
Cell[32870, 1147, 95, 2, 70, "Input",
  CellTags->"S5.48.1"],
Cell[32968, 1151, 139, 4, 70, "Output",
  CellTags->"S5.48.1"]
}, Open  ]],
Cell[33122, 1158, 15767, 494, 70, "DefinitionBox",
  CellTags->"S5.48.1"],
Cell[48892, 1654, 59, 1, 70, "Caption",
  CellTags->"S5.48.1"],
Cell[48954, 1657, 236, 9, 70, "MathCaption",
  CellTags->{"S5.48.1", "1.17"}],

Cell[CellGroupData[{
Cell[49215, 1670, 101, 2, 70, "Input",
  CellTags->"S5.48.1"],
Cell[49319, 1674, 639, 22, 70, "Output",
  CellTags->"S5.48.1"]
}, Open  ]],
Cell[49973, 1699, 111, 1, 70, "MathCaption",
  CellTags->{"S5.48.1", "1.18"}],

Cell[CellGroupData[{
Cell[50109, 1704, 109, 2, 70, "Input",
  CellTags->"S5.48.1"],
Cell[50221, 1708, 279, 10, 70, "Output",
  CellTags->"S5.48.1"]
}, Open  ]],
Cell[50515, 1721, 126, 3, 70, "MathCaption",
  CellTags->{"S5.48.1", "1.19"}],

Cell[CellGroupData[{
Cell[50666, 1728, 102, 2, 70, "Input",
  CellTags->"S5.48.1"],
Cell[50771, 1732, 321, 11, 70, "Output",
  CellTags->"S5.48.1"]
}, Open  ]],
Cell[51107, 1746, 245, 8, 70, "MathCaption",
  CellTags->{"S5.48.1", "1.20"}],

Cell[CellGroupData[{
Cell[51377, 1758, 95, 2, 70, "Input",
  CellTags->"S5.48.1"],
Cell[51475, 1762, 442, 16, 70, "Output",
  CellTags->"S5.48.1"]
}, Open  ]],
Cell[51932, 1781, 115, 2, 70, "MathCaption",
  CellTags->{"S5.48.1", "1.21"}],

Cell[CellGroupData[{
Cell[52072, 1787, 102, 2, 70, "Input",
  CellTags->"S5.48.1"],
Cell[52177, 1791, 321, 11, 70, "Output",
  CellTags->"S5.48.1"]
}, Open  ]],
Cell[52513, 1805, 313, 6, 70, "MathCaption",
  CellTags->{"S5.48.1", "1.22"}],

Cell[CellGroupData[{
Cell[52851, 1815, 113, 2, 70, "Input",
  CellTags->"S5.48.1"],
Cell[52967, 1819, 301, 11, 70, "Output",
  CellTags->"S5.48.1"]
}, Open  ]],
Cell[53283, 1833, 2150, 66, 70, "DefinitionBox",
  CellTags->"S5.48.1"],
Cell[55436, 1901, 91, 1, 70, "Caption",
  CellTags->"S5.48.1"],
Cell[55530, 1904, 182, 4, 70, "MathCaption",
  CellTags->{"S5.48.1", "1.23"}],

Cell[CellGroupData[{
Cell[55737, 1912, 167, 6, 70, "Input",
  CellTags->"S5.48.1"],
Cell[55907, 1920, 334, 12, 70, "Output",
  CellTags->"S5.48.1"]
}, Open  ]],
Cell[56256, 1935, 2544, 82, 70, "DefinitionBox",
  CellTags->"S5.48.1"],
Cell[58803, 2019, 74, 1, 70, "Caption",
  CellTags->"S5.48.1"],
Cell[58880, 2022, 358, 12, 70, "MathCaption",
  CellTags->{"S5.48.1", "1.24"}],

Cell[CellGroupData[{
Cell[59263, 2038, 153, 5, 70, "Input",
  CellTags->"S5.48.1"],
Cell[59419, 2045, 1063, 31, 70, "Output",
  CellTags->"S5.48.1"]
}, Open  ]],
Cell[60497, 2079, 87, 1, 70, "MathCaption",
  CellTags->{"S5.48.1", "1.25"}],

Cell[CellGroupData[{
Cell[60609, 2084, 99, 2, 70, "Input",
  CellTags->"S5.48.1"],
Cell[60711, 2088, 345, 10, 70, "Output",
  CellTags->"S5.48.1"]
}, Open  ]],
Cell[61071, 2101, 87, 1, 70, "MathCaption",
  CellTags->{"S5.48.1", "1.26"}],

Cell[CellGroupData[{
Cell[61183, 2106, 77, 2, 70, "Input",
  CellTags->"S5.48.1"],
Cell[61263, 2110, 338, 11, 70, "Output",
  CellTags->"S5.48.1"]
}, Open  ]],
Cell[61616, 2124, 2856, 88, 70, "DefinitionBox",
  CellTags->"S5.48.1"],
Cell[64475, 2214, 71, 1, 70, "Caption",
  CellTags->"S5.48.1"],
Cell[64549, 2217, 406, 10, 70, "MathCaption",
  CellTags->{"S5.48.1", "1.27"}],

Cell[CellGroupData[{
Cell[64980, 2231, 98, 2, 70, "Input",
  CellTags->"S5.48.1"],
Cell[65081, 2235, 558, 19, 70, "Output",
  CellTags->"S5.48.1"]
}, Open  ]],
Cell[65654, 2257, 126, 3, 70, "MathCaption",
  CellTags->{"S5.48.1", "1.28"}],

Cell[CellGroupData[{
Cell[65805, 2264, 87, 2, 70, "Input",
  CellTags->"S5.48.1"],
Cell[65895, 2268, 744, 24, 70, "Output",
  CellTags->"S5.48.1"]
}, Open  ]],
Cell[66654, 2295, 132, 3, 70, "MathCaption",
  CellTags->{"S5.48.1", "1.29"}],

Cell[CellGroupData[{
Cell[66811, 2302, 86, 2, 70, "Input",
  CellTags->"S5.48.1"],
Cell[66900, 2306, 307, 10, 70, "Output",
  CellTags->"S5.48.1"]
}, Open  ]],
Cell[67222, 2319, 6892, 192, 70, "DefinitionBox",
  CellTags->"S5.48.1"],
Cell[74117, 2513, 109, 5, 70, "Caption",
  CellTags->"S5.48.1"],
Cell[74229, 2520, 291, 7, 70, "Text",
  CellTags->{"S5.48.1", "1.30"}],
Cell[74523, 2529, 480, 15, 70, "Text",
  CellTags->{"S5.48.1", "1.31"}],
Cell[75006, 2546, 80, 1, 70, "MathCaption",
  CellTags->{"S5.48.1", "1.32"}],
Cell[75089, 2549, 100, 2, 70, "Input",
  CellTags->"S5.48.1"],
Cell[75192, 2553, 123, 3, 70, "MathCaption",
  CellTags->{"S5.48.1", "1.33"}],

Cell[CellGroupData[{
Cell[75340, 2560, 90, 2, 70, "Input",
  CellTags->"S5.48.1"],
Cell[75433, 2564, 172, 6, 70, "Output",
  CellTags->"S5.48.1"]
}, Open  ]],
Cell[75620, 2573, 110, 3, 70, "MathCaption",
  CellTags->{"S5.48.1", "1.34"}],
Cell[75733, 2578, 94, 2, 70, "Input",
  CellTags->"S5.48.1"],
Cell[75830, 2582, 254, 6, 70, "MathCaption",
  CellTags->{"S5.48.1", "1.35"}],

Cell[CellGroupData[{
Cell[76109, 2592, 100, 2, 70, "Input",
  CellTags->"S5.48.1"],
Cell[76212, 2596, 188, 6, 70, "Output",
  CellTags->"S5.48.1"]
}, Open  ]],
Cell[76415, 2605, 2110, 68, 70, "DefinitionBox",
  CellTags->"S5.48.1"],
Cell[78528, 2675, 70, 1, 70, "Caption",
  CellTags->"S5.48.1"],
Cell[78601, 2678, 377, 7, 70, "Text",
  CellTags->{"S5.48.1", "1.36"}],
Cell[78981, 2687, 96, 1, 70, "MathCaption",
  CellTags->{"S5.48.1", "1.37"}],

Cell[CellGroupData[{
Cell[79102, 2692, 109, 2, 70, "Input",
  CellTags->"S5.48.1"],
Cell[79214, 2696, 8699, 316, 70, 8628, 313, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.48.1"],
Cell[87916, 3014, 191, 7, 70, "Output",
  CellTags->"S5.48.1"]
}, Open  ]],
Cell[88122, 3024, 78, 1, 70, "MathCaption",
  CellTags->{"S5.48.1", "1.38"}],

Cell[CellGroupData[{
Cell[88225, 3029, 107, 2, 70, "Input",
  CellTags->"S5.48.1"],
Cell[88335, 3033, 403, 14, 70, "Output",
  CellTags->"S5.48.1"]
}, Open  ]],
Cell[88753, 3050, 153, 4, 70, "MathCaption",
  CellTags->{"S5.48.1", "1.39"}],

Cell[CellGroupData[{
Cell[88931, 3058, 84, 2, 70, "Input",
  CellTags->"S5.48.1"],
Cell[89018, 3062, 9953, 709, 70, 9882, 706, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.48.1"],
Cell[98974, 3773, 191, 7, 70, "Output",
  CellTags->"S5.48.1"]
}, Open  ]],
Cell[99180, 3783, 104, 1, 70, "MathCaption",
  CellTags->{"S5.48.1", "1.40"}],

Cell[CellGroupData[{
Cell[99309, 3788, 87, 2, 70, "Input",
  CellTags->"S5.48.1"],
Cell[99399, 3792, 9949, 708, 70, 9878, 705, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.48.1"],
Cell[109351, 4502, 191, 7, 70, "Output",
  CellTags->"S5.48.1"]
}, Open  ]],
Cell[109557, 4512, 773, 24, 70, "DefinitionBox",
  CellTags->"S5.48.1"],
Cell[110333, 4538, 113, 5, 70, "Caption",
  CellTags->"S5.48.1"],
Cell[110449, 4545, 836, 19, 70, "Text",
  CellTags->{"S5.48.1", "1.41"}],
Cell[111288, 4566, 247, 7, 70, "MathCaption",
  CellTags->{"S5.48.1", "1.42"}],

Cell[CellGroupData[{
Cell[111560, 4577, 104, 2, 70, "Input",
  CellTags->"S5.48.1"],
Cell[111667, 4581, 3635, 220, 70, 3564, 217, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.48.1"],
Cell[115305, 4803, 191, 7, 70, "Output",
  CellTags->"S5.48.1"]
}, Open  ]],
Cell[115511, 4813, 442, 7, 70, "Text",
  CellTags->{"S5.48.1", "1.43"}],
Cell[115956, 4822, 206, 4, 70, "Text",
  CellTags->{"S5.48.1", "1.44"}],
Cell[116165, 4828, 87, 1, 70, "MathCaption",
  CellTags->{"S5.48.1", "1.45"}],
Cell[116255, 4831, 77, 2, 70, "Input",
  CellTags->"S5.48.1"],
Cell[116335, 4835, 358, 11, 70, "MathCaption",
  CellTags->{"S5.48.1", "1.46"}],
Cell[116696, 4848, 164, 6, 70, "Input",
  CellTags->"S5.48.1"],
Cell[116863, 4856, 74, 1, 70, "MathCaption",
  CellTags->{"S5.48.1", "1.47"}],

Cell[CellGroupData[{
Cell[116962, 4861, 79, 2, 70, "Input",
  CellTags->"S5.48.1"],
Cell[117044, 4865, 24314, 519, 70, 24243, 516, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.48.1"],
Cell[141361, 5386, 191, 7, 70, "Output",
  CellTags->"S5.48.1"]
}, Open  ]],
Cell[141567, 5396, 165, 4, 70, "MathCaption",
  CellTags->{"S5.48.1", "1.48"}],

Cell[CellGroupData[{
Cell[141757, 5404, 100, 2, 70, "Input",
  CellTags->"S5.48.1"],
Cell[141860, 5408, 4199, 233, 70, 4128, 230, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.48.1"],
Cell[146062, 5643, 191, 7, 70, "Output",
  CellTags->"S5.48.1"]
}, Open  ]],
Cell[146268, 5653, 137, 3, 70, "MathCaption",
  CellTags->{"S5.48.1", "1.49"}],

Cell[CellGroupData[{
Cell[146430, 5660, 189, 7, 70, "Input",
  CellTags->"S5.48.1"],
Cell[146622, 5669, 4199, 233, 70, 4128, 230, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.48.1"],
Cell[150824, 5904, 191, 7, 70, "Output",
  CellTags->"S5.48.1"]
}, Open  ]],
Cell[151030, 5914, 141, 4, 70, "Text",
  CellTags->{"S5.48.1", "1.50"}],
Cell[151174, 5920, 180, 7, 70, "MathCaption",
  CellTags->{"S5.48.1", "1.51"}],

Cell[CellGroupData[{
Cell[151379, 5931, 162, 6, 70, "Input",
  CellTags->"S5.48.1"],
Cell[151544, 5939, 3354, 202, 70, 3283, 199, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.48.1"],
Cell[154901, 6143, 191, 7, 70, "Output",
  CellTags->"S5.48.1"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

