(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      6528,        228]*)
(*NotebookOutlinePosition[      9865,        333]*)
(*  CellTagsIndexPosition[      9595,        318]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Utilities",
 StyleBox["`", "MB"],
 "MemoryConserve",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S6.13.1", "1.1"}],

Cell[TextData[{
 "On computers that have small amounts of installed memory, ",
 StyleBox["Mathematica", "TI"],
 "\[CloseCurlyQuote]s performance will begin to suffer after carrying out \
many memory\[Hyphen]intensive calculations. This package optimizes ",
 StyleBox["Mathematica", "TI"],
 "\[CloseCurlyQuote]s use of memory by automatically executing the kernel \
command ",
 StyleBox["Share[", "MR"],
 " ",
 StyleBox["]", "MR"],
 " whenever memory usage increases by a specified amount. "
}], "Text",
 CellTags->{"S6.13.1", "1.2"}],

Cell[TextData[{
 StyleBox["Share[", "MR"],
 " ",
 StyleBox["]", "MR"],
 " tries to minimize the memory used to store all expressions by sharing the \
storage of common subexpressions between different parts of an expression, or \
different expressions. Using ",
 StyleBox["Share[", "MR"],
 " ",
 StyleBox["]", "MR"],
 " will never affect the results you get from ",
 StyleBox["Mathematica", "TI"],
 ". It may, however, reduce the amount of memory used, and in many cases also \
the amount of time taken. Note, however, that the ",
 StyleBox["Share[", "MR"],
 " ",
 StyleBox["]", "MR"],
 " command itself may take some time to run. "
}], "Text",
 CellTags->{"S6.13.1", "1.3"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["On[MemoryConserve]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "enable automatic memory conservation",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Off[MemoryConserve]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "halt automatic memory conservation",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S6.13.1"],

Cell["Commands for memory conservation. ", "Caption",
 CellTags->"S6.13.1"],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S6.13.1", "1.4"}],

Cell["<<Utilities`MemoryConserve`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S6.13.1"],

Cell[TextData[{
 "When memory usage has increased by ",
 StyleBox["$MemoryIncrement", "MR"],
 " bytes ",
 StyleBox["Share[", "MR"],
 " ",
 StyleBox["]", "MR"],
 " will be run automatically. "
}], "MathCaption",
 CellTags->{"S6.13.1", "1.5"}],

Cell[CellGroupData[{

Cell["$MemoryIncrement", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S6.13.1"],

Cell[BoxData["100000"], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S6.13.1"]
}, Open  ]],

Cell["\<\
This generates a large list containing multiple copies of the same \
expression. \
\>", "MathCaption",
 CellTags->{"S6.13.1", "1.6"}],

Cell["Table[ ToString[0], {2^15} ];", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S6.13.1"],

Cell[TextData[{
 "As you do subsequent calculations, ",
 StyleBox["Share[", "MR"],
 " ",
 StyleBox["]", "MR"],
 " is called and a significant amount of memory is freed up. The amount freed \
will vary from one computer system to another. "
}], "MathCaption",
 CellTags->{"S6.13.1", "1.7"}],

Cell[CellGroupData[{

Cell["Length[ % ]", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S6.13.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MemoryConserve", "::", "\<\"start\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Running Share[] to conserve memory.\"\>"}]], "Message",
 CellTags->"S6.13.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MemoryConserve", "::", "\<\"end\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Finished running Share[]; \\!\\(924320\\) bytes of memory \
freed.\"\>"}]], "Message",
 CellTags->"S6.13.1"],

Cell[BoxData["32768"], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S6.13.1"]
}, Open  ]],

Cell["This stops automatic memory conservation. ", "MathCaption",
 CellTags->{"S6.13.1", "1.8"}],

Cell["Off[ MemoryConserve ]", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S6.13.1"],

Cell["This restarts automatic memory conservation. ", "MathCaption",
 CellTags->{"S6.13.1", "1.9"}],

Cell["On[ MemoryConserve ]", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S6.13.1"]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S6.13.1"->{
    Cell[1776, 53, 140, 6, 36, "Subsection",
      CellTags->{"S6.13.1", "1.1"}],
    Cell[1919, 61, 533, 13, 72, "Text",
      CellTags->{"S6.13.1", "1.2"}],
    Cell[2455, 76, 675, 19, 88, "Text",
      CellTags->{"S6.13.1", "1.3"}],
    Cell[3133, 97, 1181, 36, 66, "DefinitionBox",
      CellTags->"S6.13.1"],
    Cell[4317, 135, 75, 1, 15, "Caption",
      CellTags->"S6.13.1"],
    Cell[4395, 138, 78, 1, 40, "MathCaption",
      CellTags->{"S6.13.1", "1.4"}],
    Cell[4476, 141, 90, 2, 28, "Input",
      CellTags->"S6.13.1"],
    Cell[4569, 145, 241, 9, 56, "MathCaption",
      CellTags->{"S6.13.1", "1.5"}],
    Cell[4835, 158, 79, 2, 28, "Input",
      CellTags->"S6.13.1"],
    Cell[4917, 162, 79, 2, 25, "Output",
      CellTags->"S6.13.1"],
    Cell[5011, 167, 143, 4, 40, "MathCaption",
      CellTags->{"S6.13.1", "1.6"}],
    Cell[5157, 173, 92, 2, 28, "Input",
      CellTags->"S6.13.1"],
    Cell[5252, 177, 289, 8, 56, "MathCaption",
      CellTags->{"S6.13.1", "1.7"}],
    Cell[5566, 189, 74, 2, 28, "Input",
      CellTags->"S6.13.1"],
    Cell[5643, 193, 185, 5, 19, "Message",
      CellTags->"S6.13.1"],
    Cell[5831, 200, 214, 6, 70, "Message",
      CellTags->"S6.13.1"],
    Cell[6048, 208, 78, 2, 70, "Output",
      CellTags->"S6.13.1"],
    Cell[6141, 213, 96, 1, 70, "MathCaption",
      CellTags->{"S6.13.1", "1.8"}],
    Cell[6240, 216, 84, 2, 70, "Input",
      CellTags->"S6.13.1"],
    Cell[6327, 220, 99, 1, 70, "MathCaption",
      CellTags->{"S6.13.1", "1.9"}],
    Cell[6429, 223, 83, 2, 70, "Input",
      CellTags->"S6.13.1"]},
  "1.1"->{
    Cell[1776, 53, 140, 6, 36, "Subsection",
      CellTags->{"S6.13.1", "1.1"}]},
  "1.2"->{
    Cell[1919, 61, 533, 13, 72, "Text",
      CellTags->{"S6.13.1", "1.2"}]},
  "1.3"->{
    Cell[2455, 76, 675, 19, 88, "Text",
      CellTags->{"S6.13.1", "1.3"}]},
  "1.4"->{
    Cell[4395, 138, 78, 1, 40, "MathCaption",
      CellTags->{"S6.13.1", "1.4"}]},
  "1.5"->{
    Cell[4569, 145, 241, 9, 56, "MathCaption",
      CellTags->{"S6.13.1", "1.5"}]},
  "1.6"->{
    Cell[5011, 167, 143, 4, 40, "MathCaption",
      CellTags->{"S6.13.1", "1.6"}]},
  "1.7"->{
    Cell[5252, 177, 289, 8, 56, "MathCaption",
      CellTags->{"S6.13.1", "1.7"}]},
  "1.8"->{
    Cell[6141, 213, 96, 1, 70, "MathCaption",
      CellTags->{"S6.13.1", "1.8"}]},
  "1.9"->{
    Cell[6327, 220, 99, 1, 70, "MathCaption",
      CellTags->{"S6.13.1", "1.9"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S6.13.1", 7151, 244},
  {"1.1", 8736, 287},
  {"1.2", 8830, 290},
  {"1.3", 8919, 293},
  {"1.4", 9008, 296},
  {"1.5", 9103, 299},
  {"1.6", 9199, 302},
  {"1.7", 9295, 305},
  {"1.8", 9391, 308},
  {"1.9", 9486, 311}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 140, 6, 36, "Subsection",
  CellTags->{"S6.13.1", "1.1"}],
Cell[1919, 61, 533, 13, 72, "Text",
  CellTags->{"S6.13.1", "1.2"}],
Cell[2455, 76, 675, 19, 88, "Text",
  CellTags->{"S6.13.1", "1.3"}],
Cell[3133, 97, 1181, 36, 66, "DefinitionBox",
  CellTags->"S6.13.1"],
Cell[4317, 135, 75, 1, 15, "Caption",
  CellTags->"S6.13.1"],
Cell[4395, 138, 78, 1, 40, "MathCaption",
  CellTags->{"S6.13.1", "1.4"}],
Cell[4476, 141, 90, 2, 28, "Input",
  CellTags->"S6.13.1"],
Cell[4569, 145, 241, 9, 56, "MathCaption",
  CellTags->{"S6.13.1", "1.5"}],

Cell[CellGroupData[{
Cell[4835, 158, 79, 2, 28, "Input",
  CellTags->"S6.13.1"],
Cell[4917, 162, 79, 2, 25, "Output",
  CellTags->"S6.13.1"]
}, Open  ]],
Cell[5011, 167, 143, 4, 40, "MathCaption",
  CellTags->{"S6.13.1", "1.6"}],
Cell[5157, 173, 92, 2, 28, "Input",
  CellTags->"S6.13.1"],
Cell[5252, 177, 289, 8, 56, "MathCaption",
  CellTags->{"S6.13.1", "1.7"}],

Cell[CellGroupData[{
Cell[5566, 189, 74, 2, 28, "Input",
  CellTags->"S6.13.1"],
Cell[5643, 193, 185, 5, 19, "Message",
  CellTags->"S6.13.1"],
Cell[5831, 200, 214, 6, 70, "Message",
  CellTags->"S6.13.1"],
Cell[6048, 208, 78, 2, 70, "Output",
  CellTags->"S6.13.1"]
}, Open  ]],
Cell[6141, 213, 96, 1, 70, "MathCaption",
  CellTags->{"S6.13.1", "1.8"}],
Cell[6240, 216, 84, 2, 70, "Input",
  CellTags->"S6.13.1"],
Cell[6327, 220, 99, 1, 70, "MathCaption",
  CellTags->{"S6.13.1", "1.9"}],
Cell[6429, 223, 83, 2, 70, "Input",
  CellTags->"S6.13.1"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

