(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     78159,       3498]*)
(*NotebookOutlinePosition[     90207,       3847]*)
(*  CellTagsIndexPosition[     89342,       3809]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "NumericalMath",
 StyleBox["`", "MB"],
 "Microscope",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.85.1", "1.1"}],

Cell[TextData[{
 StyleBox["Mathematica", "TI"],
 " uses both the machine arithmetic that is provided by the machine and its \
own arbitrary\[Hyphen]precision arithmetic, which is the same on all machines \
(except for the variations in the size of the largest representable number \
and the amount of memory on the machine). This package deals with the \
floating\[Hyphen]point arithmetic provided by the machine, not the arbitrary\
\[Hyphen]precision arithmetic of ",
 StyleBox["Mathematica", "TI"],
 ". "
}], "Text",
 CellTags->{"S5.85.1", "1.2"}],

Cell[TextData[{
 "Numbers on a computer comprise a discrete set. There are gaps between the \
numbers and when you do arithmetic the result often is not representable. \
When the result falls between two representable numbers the best that can be \
done is to use the closest representable number as the result instead of the \
correct result. The set of numbers that can be represented on a computer in \
floating\[Hyphen]point format are commonly referred to as the set of machine \
numbers. If you want to investigate how arithmetic is done on computers in a \
general sense you should use the package ",
 StyleBox["NumericalMath`ComputerArithmetic`", "MR"],
 ". That package allows you to vary certain fundamental parameters that \
control the arithmetic. "
}], "Text",
 CellTags->{"S5.85.1", "1.3"}],

Cell[TextData[{
 "The difference between two consecutive machine numbers is called an ulp \
(unit in the last place, ",
 StyleBox["i.e.", "TI"],
 ", one digit in the least significant place). The size of an ulp varies \
depending on where you are in the set of machine numbers. Between ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox["2", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " an ulp is equal to ",
 StyleBox["$MachineEpsilon", "MR"],
 ". Between ",
 Cell[BoxData[
  FormBox["2", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox["4", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " it is equal to ",
 StyleBox["2", "MR"],
 " ",
 StyleBox["$MachineEpsilon", "MR"],
 ". Ideally no function should ever return a result with error exceeding half \
of an ulp since the distance from the true result to the nearest machine \
number is always less than half of an ulp, the worst case being when it is \
exactly halfway between two machine numbers. It is relatively easy to achieve \
this ideal for the four arithmetic operations and for the square root \
function. For the elementary transcendental functions it becomes more \
difficult due to the fact that they cannot be evaluated in a single operation \
and the combined effects of all the rounding errors would have to be made \
less than half an ulp. Nevertheless, it is quite possible to design \
algorithms for these functions such that the error is never more than one \
ulp. "
}], "Text",
 CellTags->{"S5.85.1", "1.4"}],

Cell[TextData[{
 "The package ",
 StyleBox["NumericalMath`Microscope`", "MR"],
 " provides four functions that are useful in examining the machine floating\
\[Hyphen]point arithmetic on your machine. "
}], "Text",
 CellTags->{"S5.85.1", "1.5"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["Ulp[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["a", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the size of an ulp near ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["a", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["MachineError[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" -> ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["a", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the error in evaluating ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" at ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" = ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["a", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" using machine arithmetic",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Microscope[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["a", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["plot ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" near ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" = ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["a", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" using machine arithmetic",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["MicroscopicError[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["a", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["plot the error in evaluating ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" near ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" = ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["a", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" using machine arithmetic",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.85.1"],

Cell["\<\
Functions for examining machine floating\[Hyphen]point arithmetic. \
\>", "Caption",
 CellTags->"S5.85.1"],

Cell[TextData[{
 "The default neighborhood of the point ",
 StyleBox["x", "TI"],
 StyleBox[" = ", "MR"],
 StyleBox["a", "TI"],
 " used in ",
 StyleBox["Microscope", "MR"],
 " and ",
 StyleBox["MicroscopicError", "MR"],
 " is from 30 ulps to the left of ",
 StyleBox["a", "TI"],
 " to 30 ulps to the right of ",
 StyleBox["a", "TI"],
 ", where the ulp used is that defined at ",
 StyleBox["x", "TI"],
 StyleBox[" = ", "MR"],
 StyleBox["a", "TI"],
 ", that is, ",
 StyleBox["Ulp[", "MR"],
 StyleBox["a", "TI"],
 StyleBox["]", "MR"],
 ". Near powers of 2 and near 0 it is not clear what should be done since the \
size of an ulp changes. Near powers of 2 it is not much of a problem in the \
abscissa since an ulp is chosen to be the smaller of the two values and the \
resulting machine numbers just get included multiple times due to rounding \
effects. You can change the default size of the neighborhood by including a \
third value in the neighborhood specification. "
}], "Text",
 CellTags->{"S5.85.1", "1.6"}],

Cell[TextData[{
 "A problem arises with ",
 StyleBox["Microscope", "MR"],
 " and ",
 StyleBox["MicroscopicError", "MR"],
 " near places where the function value becomes infinite. Since the function \
is changing by orders of magnitude very rapidly it is difficult to choose a \
good scale that displays the information in which you are interested. In such \
cases you may have to examine the function several hundreds of ulps away from \
the point you really want. "
}], "Text",
 CellTags->{"S5.85.1", "1.7"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["Microscope[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["a", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["plot ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" from ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" = ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["a", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" - ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" Ulp[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["a", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" to ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" = ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["a", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" + ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" Ulp[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["a", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" using machine arithmetic",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["MicroscopicError[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["a", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["plot the error in evaluating ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" from ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" = ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["a", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" - ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" Ulp[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["a", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" to ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" = ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["a", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" + ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" Ulp[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["a", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" using machine arithmetic",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.85.1"],

Cell["Controlling the size of the neighborhood. ", "Caption",
 CellTags->"S5.85.1"],

Cell[TextData[{
 "The option ",
 StyleBox["PlotJoined", "MR"],
 " controls the way the plot is drawn. It cannot be overemphasized that the \
functions that we are examining map the machine numbers to the machine \
numbers. For our purposes the real numbers in between do not even exist. Thus \
the plots produced by ",
 StyleBox["Microscope", "MR"],
 " and ",
 StyleBox["MicroscopicError", "MR"],
 " should be nothing but a set of plotted points. However, it is easier to \
see what is happening if the points are joined with straight line segments. \
Finally, if you want to see what a function does as a map from the real \
numbers to the real numbers, that is, rounding the real argument to the \
nearest machine number and applying the function to this result, you can do \
so, but when you see large errors, don\[CloseCurlyQuote]t conclude that the \
function is to blame; it can\[CloseCurlyQuote]t do any better than deal with \
the machine numbers that it gets as arguments. "
}], "Text",
 CellTags->{"S5.85.1", "1.8"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["option name", "TI",
       GridBoxOptions->{RowLines->True,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->True,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->True,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["default value", "TI",
       GridBoxOptions->{RowLines->True,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->True,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->True,
      RowSpacings->0.4}], Cell[TextData[StyleBox["",
      GridBoxOptions->{RowLines->True,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->True,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["PlotJoined", "MR",
       GridBoxOptions->{RowLines->True,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->True,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->True,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["True", "MR",
       GridBoxOptions->{RowLines->True,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->True,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->True,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["the way the points are to be connected; either ",
       GridBoxOptions->{RowLines->True,
       RowSpacings->0.4}],
      StyleBox["True", "MR",
       GridBoxOptions->{RowLines->True,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->True,
       RowSpacings->0.4}],
      StyleBox["False", "MR",
       GridBoxOptions->{RowLines->True,
       RowSpacings->0.4}],
      StyleBox[", or ",
       GridBoxOptions->{RowLines->True,
       RowSpacings->0.4}],
      StyleBox["Real", "MR",
       GridBoxOptions->{RowLines->True,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->True,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
 GridBoxOptions->{RowLines->True,
 RowSpacings->0.4},
 CellTags->"S5.85.1"],

Cell[TextData[{
 "Options for ",
 StyleBox["Microscope", "MR"],
 " and ",
 StyleBox["MicroscopicError", "MR"],
 "."
}], "Caption",
 CellTags->"S5.85.1"],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.85.1", "1.9"}],

Cell["<<NumericalMath`Microscope`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.85.1"],

Cell["Here is the size of an ulp at 1. ", "MathCaption",
 CellTags->{"S5.85.1", "1.10"}],

Cell[CellGroupData[{

Cell["Ulp[1]", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.85.1"],

Cell[BoxData["1.1102230246251565`*^-16"], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.85.1"]
}, Open  ]],

Cell["The size of an ulp changes at powers of 2. ", "MathCaption",
 CellTags->{"S5.85.1", "1.11"}],

Cell[CellGroupData[{

Cell["{Ulp[7.999999], Ulp[8], Ulp[8.000001]}", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.85.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "8.881784197001252`*^-16", ",", "8.881784197001252`*^-16", ",", 
   "1.7763568394002505`*^-15"}], "}"}]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.85.1"]
}, Open  ]],

Cell["There is a large hole near 0. ", "MathCaption",
 CellTags->{"S5.85.1", "1.12"}],

Cell[CellGroupData[{

Cell["{Ulp[0], Ulp[$MinMachineNumber]}", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.85.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2.2250738585072014`*^-308", ",", 
   "4.94065645841246544176568792868221`15.954589770191005*^-324"}], 
  "}"}]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.85.1"]
}, Open  ]],

Cell[TextData[{
 "Here are the combined errors of rounding ",
 Cell[BoxData[
  FormBox[
   RowBox[{"49", 
    RowBox[{"\[Pi]", "/", "50"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " to the nearest machine number and then taking the square root. "
}], "MathCaption",
 CellTags->{"S5.85.1", "1.13"}],

Cell[CellGroupData[{

Cell["MachineError[Sqrt[x], x -> 49 Pi/50]", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.85.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1.2221878982084162`"}], " ", "Ulps"}]], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S5.85.1"]
}, Open  ]],

Cell["Here is the error of just the square root. ", "MathCaption",
 CellTags->{"S5.85.1", "1.14"}],

Cell[CellGroupData[{

Cell["MachineError[Sqrt[x], x -> N[49 Pi/50]]", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.85.1"],

Cell[BoxData[
 RowBox[{"0.04581618252996657`", " ", "Ulps"}]], "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S5.85.1"]
}, Open  ]],

Cell[TextData[{
 "For another number close to ",
 StyleBox["N[49 Pi/50]", "MR"],
 ", the error in the square root function is less than half an ulp. "
}], "MathCaption",
 CellTags->{"S5.85.1", "1.15"}],

Cell[CellGroupData[{

Cell["\<\
MachineError[Sqrt[x],
  x -> N[49 Pi/50] - 6 Ulp[49 Pi/50]]\
\>", "Input",
 CellLabel->"In[7]:= ",
 CellTags->"S5.85.1"],

Cell[BoxData[
 RowBox[{"0.46532144311367607`", " ", "Ulps"}]], "Output",
 CellLabel->"Out[7]= ",
 CellTags->"S5.85.1"]
}, Open  ]],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"tan", 
    RowBox[{"(", 
     SqrtBox[
      SuperscriptBox[
       StyleBox["e",
        "TI"], 
       RowBox[{"sin", 
        RowBox[{"(", 
         RowBox[{"log", 
          StyleBox["x",
           "TI"]}], ")"}]}]]], ")"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is not provided by the computer manufacturer so it is evaluated as a \
nested sequence of operations that are provided. This shows how much error is \
involved in the sequence, but this information is rarely useful. For testing \
purposes you normally want to look at an individual function evaluated at a \
machine number to avoid the effect of an ill\[Hyphen]conditioned function \
magnifying prior error. "
}], "MathCaption",
 CellTags->{"S5.85.1", "1.16"}],

Cell[CellGroupData[{

Cell["\<\
MachineError[Tan[Sqrt[Exp[Sin[Log[x]]]]],
 x -> N[Pi]]\
\>", "Input",
 CellLabel->"In[8]:= ",
 CellTags->"S5.85.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "26.89112964425968`"}], " ", "Ulps"}]], "Output",
 CellLabel->"Out[8]= ",
 CellTags->"S5.85.1"]
}, Open  ]],

Cell[TextData[{
 "Here is the ",
 Cell[BoxData[
  FormBox["log", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " function evaluated at machine numbers near 7. "
}], "MathCaption",
 CellTags->{"S5.85.1", "1.17"}],

Cell[CellGroupData[{

Cell["\<\
Microscope[Log[x], {x, 7},
 PlotJoined -> False]\
\>", "Input",
 CellLabel->"In[9]:= ",
 CellTags->"S5.85.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.015873 0.309017 0.27699 [
[.5 .00222 -8 -9.8125 ]
[.5 .00222 8 0 ]
[.01131 .30902 -46 -4.90625 ]
[.01131 .30902 0 4.90625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.5 .01472 m
.5 .02097 L
s
gsave
.5 .00222 -69 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(7.) show
75.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .01472 m
1 .01472 L
s
.02381 .30902 m
.03006 .30902 L
s
gsave
.01131 .30902 -107 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.94591) show
105.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.02381 0 m
.02381 .61803 L
s
.00667 w
.02381 .01472 Mdot
.03968 .03203 Mdot
.05556 .03203 Mdot
.07143 .04934 Mdot
.0873 .04934 Mdot
.10317 .06665 Mdot
.11905 .08396 Mdot
.13492 .08396 Mdot
.15079 .10127 Mdot
.16667 .10127 Mdot
.18254 .11859 Mdot
.19841 .11859 Mdot
.21429 .1359 Mdot
.23016 .15321 Mdot
.24603 .15321 Mdot
.2619 .17052 Mdot
.27778 .17052 Mdot
.29365 .18783 Mdot
.30952 .18783 Mdot
.3254 .20515 Mdot
.34127 .22246 Mdot
.35714 .22246 Mdot
.37302 .23977 Mdot
.38889 .23977 Mdot
.40476 .25708 Mdot
.42063 .25708 Mdot
.43651 .27439 Mdot
.45238 .29171 Mdot
.46825 .29171 Mdot
.48413 .30902 Mdot
.5 .30902 Mdot
.51587 .32633 Mdot
.53175 .32633 Mdot
.54762 .34364 Mdot
.56349 .36095 Mdot
.57937 .36095 Mdot
.59524 .37826 Mdot
.61111 .37826 Mdot
.62698 .39558 Mdot
.64286 .39558 Mdot
.65873 .41289 Mdot
.6746 .4302 Mdot
.69048 .4302 Mdot
.70635 .44751 Mdot
.72222 .44751 Mdot
.7381 .46482 Mdot
.75397 .46482 Mdot
.76984 .48214 Mdot
.78571 .49945 Mdot
.80159 .49945 Mdot
.81746 .51676 Mdot
.83333 .51676 Mdot
.84921 .53407 Mdot
.86508 .53407 Mdot
.88095 .55138 Mdot
.89683 .5687 Mdot
.9127 .5687 Mdot
.92857 .58601 Mdot
.94444 .58601 Mdot
.96032 .60332 Mdot
.97619 .60332 Mdot
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.85.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[9]= ",
 CellTags->"S5.85.1"]
}, Open  ]],

Cell[TextData[{
 "Here is the ",
 Cell[BoxData[
  FormBox["log", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " function evaluated at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"10", "+", "1", "+", "10"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " machine numbers near 7 with the points joined by straight lines. "
}], "MathCaption",
 CellTags->{"S5.85.1", "1.18"}],

Cell[CellGroupData[{

Cell["Microscope[Log[x], {x, 7, 10}]", "Input",
 CellLabel->"In[10]:= ",
 CellTags->"S5.85.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.047619 0.282262 0.428075 [
[.5 .00222 -8 -9.8125 ]
[.5 .00222 8 0 ]
[.01131 .28226 -46 -4.90625 ]
[.01131 .28226 0 4.90625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.5 .01472 m
.5 .02097 L
s
gsave
.5 .00222 -69 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(7.) show
75.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .01472 m
1 .01472 L
s
.02381 .28226 m
.03006 .28226 L
s
gsave
.01131 .28226 -107 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.94591) show
105.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.02381 0 m
.02381 .61803 L
s
.02 w
.02381 .01472 Mdot
.07143 .01472 Mdot
.11905 .06822 Mdot
.16667 .06822 Mdot
.21429 .12173 Mdot
.2619 .12173 Mdot
.30952 .17524 Mdot
.35714 .22875 Mdot
.40476 .22875 Mdot
.45238 .28226 Mdot
.5 .28226 Mdot
.54762 .33577 Mdot
.59524 .33577 Mdot
.64286 .38928 Mdot
.69048 .44279 Mdot
.7381 .44279 Mdot
.78571 .4963 Mdot
.83333 .4963 Mdot
.88095 .54981 Mdot
.92857 .54981 Mdot
.97619 .60332 Mdot
.001 w
.02381 .01472 m
.07143 .01472 L
.11905 .06822 L
.16667 .06822 L
.21429 .12173 L
.2619 .12173 L
.30952 .17524 L
.35714 .22875 L
.40476 .22875 L
.45238 .28226 L
.5 .28226 L
.54762 .33577 L
.59524 .33577 L
.64286 .38928 L
.69048 .44279 L
.7381 .44279 L
.78571 .4963 L
.83333 .4963 L
.88095 .54981 L
.92857 .54981 L
.97619 .60332 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.85.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[10]= ",
 CellTags->"S5.85.1"]
}, Open  ]],

Cell[TextData[{
 "And here are the combined effects of rounding real numbers to the nearest \
machine number and taking the ",
 Cell[BoxData[
  FormBox["log", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " of the result. This is ",
 StyleBox["not", "TI"],
 " a valid test of the ",
 Cell[BoxData[
  FormBox["log", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " function. "
}], "MathCaption",
 CellTags->{"S5.85.1", "1.19"}],

Cell[CellGroupData[{

Cell["\<\
Microscope[Log[x], {x, 7, 10},
  PlotJoined -> Real]\
\>", "Input",
 CellLabel->"In[11]:= ",
 CellTags->"S5.85.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.047619 0.282262 0.428075 [
[.5 .00222 -8 -9.8125 ]
[.5 .00222 8 0 ]
[.01131 .28226 -46 -4.90625 ]
[.01131 .28226 0 4.90625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.5 .01472 m
.5 .02097 L
s
gsave
.5 .00222 -69 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(7.) show
75.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .01472 m
1 .01472 L
s
.02381 .28226 m
.03006 .28226 L
s
gsave
.01131 .28226 -107 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.94591) show
105.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.02381 0 m
.02381 .61803 L
s
.02 w
.02381 .01472 Mdot
.07143 .01472 Mdot
.11905 .06822 Mdot
.16667 .06822 Mdot
.21429 .12173 Mdot
.2619 .12173 Mdot
.30952 .17524 Mdot
.35714 .22875 Mdot
.40476 .22875 Mdot
.45238 .28226 Mdot
.5 .28226 Mdot
.54762 .33577 Mdot
.59524 .33577 Mdot
.64286 .38928 Mdot
.69048 .44279 Mdot
.7381 .44279 Mdot
.78571 .4963 Mdot
.83333 .4963 Mdot
.88095 .54981 Mdot
.92857 .54981 Mdot
.97619 .60332 Mdot
.001 w
.04762 .01472 m
.04762 .01472 L
.09524 .01472 L
.09524 .06822 L
.14286 .06822 L
.14286 .06822 L
.19048 .06822 L
.19048 .12173 L
.2381 .12173 L
.2381 .12173 L
.28571 .12173 L
.28571 .17524 L
.33333 .17524 L
.33333 .22875 L
.38095 .22875 L
.38095 .22875 L
.42857 .22875 L
.42857 .28226 L
.47619 .28226 L
.47619 .28226 L
.52381 .28226 L
.52381 .33577 L
.57143 .33577 L
.57143 .33577 L
.61905 .33577 L
.61905 .38928 L
.66667 .38928 L
.66667 .44279 L
.71429 .44279 L
.71429 .44279 L
.7619 .44279 L
.7619 .4963 L
.80952 .4963 L
.80952 .4963 L
.85714 .4963 L
.85714 .54981 L
.90476 .54981 L
.90476 .54981 L
.95238 .54981 L
.95238 .60332 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.85.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[11]= ",
 CellTags->"S5.85.1"]
}, Open  ]],

Cell[TextData[{
 "This shows the error in evaluating the sine function at ",
 Cell[BoxData[
  FormBox["31", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " machine numbers near 16. Note how the size of an ulp changes at 16. Note \
also that rounding has moved some points to coincide so that there appear to \
be fewer than ",
 Cell[BoxData[
  FormBox["31", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " points. The scale on the vertical axis represents ulps. "
}], "MathCaption",
 CellTags->{"S5.85.1", "1.20"}],

Cell[CellGroupData[{

Cell["\<\
MicroscopicError[Sin[x], {x, 16, 15},
 PlotJoined -> False]\
\>", "Input",
 CellLabel->"In[12]:= ",
 CellTags->"S5.85.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.484639 0.030722 0.316343 0.608843 [
[.48464 .30384 -11 -9.8125 ]
[.48464 .30384 11 0 ]
[.01131 .07281 -24 -4.5 ]
[.01131 .07281 0 4.5 ]
[.01131 .19457 -24 -4.5 ]
[.01131 .19457 0 4.5 ]
[.01131 .43811 -18 -4.5 ]
[.01131 .43811 0 4.5 ]
[.01131 .55988 -18 -4.5 ]
[.01131 .55988 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.48464 .31634 m
.48464 .32259 L
s
gsave
.48464 .30384 -72 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(16.) show
81.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .31634 m
1 .31634 L
s
.02381 .07281 m
.03006 .07281 L
s
[(-0.4)] .01131 .07281 1 0 Mshowa
.02381 .19457 m
.03006 .19457 L
s
[(-0.2)] .01131 .19457 1 0 Mshowa
.02381 .43811 m
.03006 .43811 L
s
[(0.2)] .01131 .43811 1 0 Mshowa
.02381 .55988 m
.03006 .55988 L
s
[(0.4)] .01131 .55988 1 0 Mshowa
.125 Mabswid
.02381 .10325 m
.02756 .10325 L
s
.02381 .13369 m
.02756 .13369 L
s
.02381 .16413 m
.02756 .16413 L
s
.02381 .22502 m
.02756 .22502 L
s
.02381 .25546 m
.02756 .25546 L
s
.02381 .2859 m
.02756 .2859 L
s
.02381 .34679 m
.02756 .34679 L
s
.02381 .37723 m
.02756 .37723 L
s
.02381 .40767 m
.02756 .40767 L
s
.02381 .46855 m
.02756 .46855 L
s
.02381 .499 m
.02756 .499 L
s
.02381 .52944 m
.02756 .52944 L
s
.02381 .04236 m
.02756 .04236 L
s
.02381 .01192 m
.02756 .01192 L
s
.02381 .59032 m
.02756 .59032 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
.01333 w
.02381 .44687 Mdot
.05453 .23079 Mdot
.08525 .01472 Mdot
.11598 .40748 Mdot
.1467 .19141 Mdot
.17742 .58417 Mdot
.20814 .3681 Mdot
.23886 .15202 Mdot
.26959 .54479 Mdot
.30031 .32871 Mdot
.33103 .11263 Mdot
.36175 .5054 Mdot
.39247 .28932 Mdot
.4232 .07325 Mdot
.45392 .46601 Mdot
.48464 .24994 Mdot
.48464 .24994 Mdot
.54608 .42663 Mdot
.60753 .60332 Mdot
.60753 .60332 Mdot
.60753 .60332 Mdot
.66897 .17117 Mdot
.73041 .34786 Mdot
.73041 .34786 Mdot
.73041 .34786 Mdot
.79186 .52455 Mdot
.8533 .09239 Mdot
.8533 .09239 Mdot
.8533 .09239 Mdot
.91475 .26908 Mdot
.97619 .44577 Mdot
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.85.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[12]= ",
 CellTags->"S5.85.1"]
}, Open  ]],

Cell["\<\
Here is the error in evaluating sine at 21 machine numbers near 31 with the \
points joined by straight lines. \
\>", "MathCaption",
 CellTags->{"S5.85.1", "1.21"}],

Cell[CellGroupData[{

Cell["\<\
MicroscopicError[Sin[x], {x, 31, 10},
 PlotJoined -> True]\
\>", "Input",
 CellLabel->"In[13]:= ",
 CellTags->"S5.85.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.047619 0.296119 0.629955 [
[.5 .28362 -11 -9.8125 ]
[.5 .28362 11 0 ]
[.01131 .04414 -24 -4.5 ]
[.01131 .04414 0 4.5 ]
[.01131 .17013 -24 -4.5 ]
[.01131 .17013 0 4.5 ]
[.01131 .42211 -18 -4.5 ]
[.01131 .42211 0 4.5 ]
[.01131 .5481 -18 -4.5 ]
[.01131 .5481 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.5 .29612 m
.5 .30237 L
s
gsave
.5 .28362 -72 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(31.) show
81.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .29612 m
1 .29612 L
s
.02381 .04414 m
.03006 .04414 L
s
[(-0.4)] .01131 .04414 1 0 Mshowa
.02381 .17013 m
.03006 .17013 L
s
[(-0.2)] .01131 .17013 1 0 Mshowa
.02381 .42211 m
.03006 .42211 L
s
[(0.2)] .01131 .42211 1 0 Mshowa
.02381 .5481 m
.03006 .5481 L
s
[(0.4)] .01131 .5481 1 0 Mshowa
.125 Mabswid
.02381 .07564 m
.02756 .07564 L
s
.02381 .10713 m
.02756 .10713 L
s
.02381 .13863 m
.02756 .13863 L
s
.02381 .20163 m
.02756 .20163 L
s
.02381 .23312 m
.02756 .23312 L
s
.02381 .26462 m
.02756 .26462 L
s
.02381 .32762 m
.02756 .32762 L
s
.02381 .35911 m
.02756 .35911 L
s
.02381 .39061 m
.02756 .39061 L
s
.02381 .45361 m
.02756 .45361 L
s
.02381 .48511 m
.02756 .48511 L
s
.02381 .5166 m
.02756 .5166 L
s
.02381 .01264 m
.02756 .01264 L
s
.02381 .5796 m
.02756 .5796 L
s
.02381 .6111 m
.02756 .6111 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
.02 w
.02381 .41192 Mdot
.07143 .06953 Mdot
.11905 .3571 Mdot
.16667 .01472 Mdot
.21429 .30228 Mdot
.2619 .58985 Mdot
.30952 .24746 Mdot
.35714 .53503 Mdot
.40476 .19264 Mdot
.45238 .48021 Mdot
.5 .13782 Mdot
.54762 .42539 Mdot
.59524 .083 Mdot
.64286 .37057 Mdot
.69048 .02818 Mdot
.7381 .31575 Mdot
.78571 .60332 Mdot
.83333 .26093 Mdot
.88095 .5485 Mdot
.92857 .20611 Mdot
.97619 .49368 Mdot
.001 w
.02381 .41192 m
.07143 .06953 L
.11905 .3571 L
.16667 .01472 L
.21429 .30228 L
.2619 .58985 L
.30952 .24746 L
.35714 .53503 L
.40476 .19264 L
.45238 .48021 L
.5 .13782 L
.54762 .42539 L
.59524 .083 L
.64286 .37057 L
.69048 .02818 L
.7381 .31575 L
.78571 .60332 L
.83333 .26093 L
.88095 .5485 L
.92857 .20611 L
.97619 .49368 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.85.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[13]= ",
 CellTags->"S5.85.1"]
}, Open  ]],

Cell[TextData[{
 "And here are the combined effects of rounding real numbers to the nearest \
machine number and taking the sine of the result. This is ",
 StyleBox["not", "TI"],
 " a valid test of the sine function. The error in evaluating the sine \
function at a machine number near 31 is much smaller than the combination of \
errors resulting from first rounding a real number to the nearest machine \
number and then taking the sine of that machine number. "
}], "MathCaption",
 CellTags->{"S5.85.1", "1.22"}],

Cell[CellGroupData[{

Cell["\<\
MicroscopicError[Sin[x], {x, 31, 10},
 PlotJoined -> Real]\
\>", "Input",
 CellLabel->"In[14]:= ",
 CellTags->"S5.85.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.047619 0.308814 0.00989618 [
[.5 .29631 -11 -9.8125 ]
[.5 .29631 11 0 ]
[.01131 .01193 -18 -4.5 ]
[.01131 .01193 0 4.5 ]
[.01131 .11089 -18 -4.5 ]
[.01131 .11089 0 4.5 ]
[.01131 .20985 -18 -4.5 ]
[.01131 .20985 0 4.5 ]
[.01131 .40778 -12 -4.5 ]
[.01131 .40778 0 4.5 ]
[.01131 .50674 -12 -4.5 ]
[.01131 .50674 0 4.5 ]
[.01131 .6057 -12 -4.5 ]
[.01131 .6057 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.5 .30881 m
.5 .31506 L
s
gsave
.5 .29631 -72 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(31.) show
81.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .30881 m
1 .30881 L
s
.02381 .01193 m
.03006 .01193 L
s
[(-30)] .01131 .01193 1 0 Mshowa
.02381 .11089 m
.03006 .11089 L
s
[(-20)] .01131 .11089 1 0 Mshowa
.02381 .20985 m
.03006 .20985 L
s
[(-10)] .01131 .20985 1 0 Mshowa
.02381 .40778 m
.03006 .40778 L
s
[(10)] .01131 .40778 1 0 Mshowa
.02381 .50674 m
.03006 .50674 L
s
[(20)] .01131 .50674 1 0 Mshowa
.02381 .6057 m
.03006 .6057 L
s
[(30)] .01131 .6057 1 0 Mshowa
.125 Mabswid
.02381 .03172 m
.02756 .03172 L
s
.02381 .05151 m
.02756 .05151 L
s
.02381 .07131 m
.02756 .07131 L
s
.02381 .0911 m
.02756 .0911 L
s
.02381 .13068 m
.02756 .13068 L
s
.02381 .15048 m
.02756 .15048 L
s
.02381 .17027 m
.02756 .17027 L
s
.02381 .19006 m
.02756 .19006 L
s
.02381 .22964 m
.02756 .22964 L
s
.02381 .24944 m
.02756 .24944 L
s
.02381 .26923 m
.02756 .26923 L
s
.02381 .28902 m
.02756 .28902 L
s
.02381 .32861 m
.02756 .32861 L
s
.02381 .3484 m
.02756 .3484 L
s
.02381 .36819 m
.02756 .36819 L
s
.02381 .38798 m
.02756 .38798 L
s
.02381 .42757 m
.02756 .42757 L
s
.02381 .44736 m
.02756 .44736 L
s
.02381 .46715 m
.02756 .46715 L
s
.02381 .48695 m
.02756 .48695 L
s
.02381 .52653 m
.02756 .52653 L
s
.02381 .54632 m
.02756 .54632 L
s
.02381 .56612 m
.02756 .56612 L
s
.02381 .58591 m
.02756 .58591 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
.02 w
.02381 .31063 Mdot
.07143 .30525 Mdot
.11905 .30977 Mdot
.16667 .30439 Mdot
.21429 .30891 Mdot
.2619 .31343 Mdot
.30952 .30805 Mdot
.35714 .31257 Mdot
.40476 .30719 Mdot
.45238 .31171 Mdot
.5 .30633 Mdot
.54762 .31085 Mdot
.59524 .30547 Mdot
.64286 .30998 Mdot
.69048 .30461 Mdot
.7381 .30912 Mdot
.78571 .31364 Mdot
.83333 .30826 Mdot
.88095 .31278 Mdot
.92857 .3074 Mdot
.97619 .31192 Mdot
.001 w
.04762 .02095 m
.04762 .59493 L
.09524 .01558 L
.09524 .59945 L
.14286 .02009 L
.14286 .59407 L
.19048 .01472 L
.19048 .59859 L
.2381 .01923 L
.2381 .60311 L
.28571 .02375 L
.28571 .59773 L
.33333 .01837 L
.33333 .60225 L
.38095 .02289 L
.38095 .59687 L
.42857 .01751 L
.42857 .60138 L
.47619 .02203 L
.47619 .59601 L
.52381 .01665 L
.52381 .60052 L
.57143 .02117 L
.57143 .59515 L
.61905 .01579 L
.61905 .59966 L
.66667 .02031 L
.66667 .59428 L
.71429 .01493 L
.71429 .5988 L
.7619 .01944 L
.7619 .60332 L
.80952 .02396 L
.80952 .59794 L
.85714 .01858 L
.85714 .60246 L
.90476 .0231 L
.90476 .59708 L
.95238 .01772 L
.95238 .6016 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.85.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[14]= ",
 CellTags->"S5.85.1"]
}, Open  ]],

Cell[TextData[{
 "Here you see how bad the square root function really is. It appears that \
near ",
 Cell[BoxData[
  FormBox["3.3", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " its error is bounded by about ",
 Cell[BoxData[
  FormBox["1.0", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " ulps. "
}], "MathCaption",
 CellTags->{"S5.85.1", "1.23"}],

Cell[CellGroupData[{

Cell["MicroscopicError[Sqrt[x], {x, 3.3, 100}]", "Input",
 CellLabel->"In[15]:= ",
 CellTags->"S5.85.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.0047619 0.309473 0.59282 [
[.5 .29697 -11 -9.8125 ]
[.5 .29697 11 0 ]
[.01131 .07234 -24 -4.5 ]
[.01131 .07234 0 4.5 ]
[.01131 .19091 -24 -4.5 ]
[.01131 .19091 0 4.5 ]
[.01131 .42804 -18 -4.5 ]
[.01131 .42804 0 4.5 ]
[.01131 .5466 -18 -4.5 ]
[.01131 .5466 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.5 .30947 m
.5 .31572 L
s
gsave
.5 .29697 -72 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3.3) show
81.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .30947 m
1 .30947 L
s
.02381 .07234 m
.03006 .07234 L
s
[(-0.4)] .01131 .07234 1 0 Mshowa
.02381 .19091 m
.03006 .19091 L
s
[(-0.2)] .01131 .19091 1 0 Mshowa
.02381 .42804 m
.03006 .42804 L
s
[(0.2)] .01131 .42804 1 0 Mshowa
.02381 .5466 m
.03006 .5466 L
s
[(0.4)] .01131 .5466 1 0 Mshowa
.125 Mabswid
.02381 .10199 m
.02756 .10199 L
s
.02381 .13163 m
.02756 .13163 L
s
.02381 .16127 m
.02756 .16127 L
s
.02381 .22055 m
.02756 .22055 L
s
.02381 .25019 m
.02756 .25019 L
s
.02381 .27983 m
.02756 .27983 L
s
.02381 .33911 m
.02756 .33911 L
s
.02381 .36875 m
.02756 .36875 L
s
.02381 .3984 m
.02756 .3984 L
s
.02381 .45768 m
.02756 .45768 L
s
.02381 .48732 m
.02756 .48732 L
s
.02381 .51696 m
.02756 .51696 L
s
.02381 .0427 m
.02756 .0427 L
s
.02381 .01306 m
.02756 .01306 L
s
.02381 .57624 m
.02756 .57624 L
s
.02381 .60588 m
.02756 .60588 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
.002 w
.02381 .32691 Mdot
.02857 .59339 Mdot
.03333 .26705 Mdot
.0381 .53354 Mdot
.04286 .2072 Mdot
.04762 .47368 Mdot
.05238 .14735 Mdot
.05714 .41383 Mdot
.0619 .08749 Mdot
.06667 .35398 Mdot
.07143 .02764 Mdot
.07619 .29412 Mdot
.08095 .56061 Mdot
.08571 .23427 Mdot
.09048 .50075 Mdot
.09524 .17442 Mdot
.1 .4409 Mdot
.10476 .11456 Mdot
.10952 .38105 Mdot
.11429 .05471 Mdot
.11905 .32119 Mdot
.12381 .58768 Mdot
.12857 .26134 Mdot
.13333 .52782 Mdot
.1381 .20149 Mdot
.14286 .46797 Mdot
.14762 .14163 Mdot
.15238 .40812 Mdot
.15714 .08178 Mdot
.1619 .34826 Mdot
.16667 .02193 Mdot
.17143 .28841 Mdot
.17619 .55489 Mdot
.18095 .22856 Mdot
.18571 .49504 Mdot
.19048 .1687 Mdot
.19524 .43519 Mdot
.2 .10885 Mdot
.20476 .37533 Mdot
.20952 .049 Mdot
.21429 .31548 Mdot
.21905 .58196 Mdot
.22381 .25563 Mdot
.22857 .52211 Mdot
.23333 .19577 Mdot
.2381 .46226 Mdot
.24286 .13592 Mdot
.24762 .4024 Mdot
.25238 .07607 Mdot
.25714 .34255 Mdot
.2619 .01621 Mdot
.26667 .2827 Mdot
.27143 .54918 Mdot
.27619 .22284 Mdot
.28095 .48933 Mdot
.28571 .16299 Mdot
.29048 .42947 Mdot
.29524 .10314 Mdot
.3 .36962 Mdot
.30476 .04328 Mdot
.30952 .30977 Mdot
.31429 .57625 Mdot
.31905 .24991 Mdot
.32381 .5164 Mdot
.32857 .19006 Mdot
.33333 .45654 Mdot
.3381 .13021 Mdot
.34286 .39669 Mdot
.34762 .07035 Mdot
.35238 .33684 Mdot
.35714 .60332 Mdot
.3619 .27698 Mdot
.36667 .54347 Mdot
.37143 .21713 Mdot
.37619 .48361 Mdot
.38095 .15728 Mdot
.38571 .42376 Mdot
.39048 .09742 Mdot
.39524 .36391 Mdot
.4 .03757 Mdot
.40476 .30405 Mdot
.40952 .57054 Mdot
.41429 .2442 Mdot
.41905 .51068 Mdot
.42381 .18435 Mdot
.42857 .45083 Mdot
.43333 .12449 Mdot
.4381 .39098 Mdot
.44286 .06464 Mdot
.44762 .33112 Mdot
.45238 .59761 Mdot
.45714 .27127 Mdot
.4619 .53775 Mdot
.46667 .21142 Mdot
.47143 .4779 Mdot
.47619 .15156 Mdot
.48095 .41805 Mdot
.48571 .09171 Mdot
.49048 .35819 Mdot
.49524 .03186 Mdot
.5 .29834 Mdot
.50476 .56482 Mdot
.50952 .23849 Mdot
.51429 .50497 Mdot
.51905 .17863 Mdot
.52381 .44512 Mdot
.52857 .11878 Mdot
.53333 .38526 Mdot
.5381 .05893 Mdot
.54286 .32541 Mdot
.54762 .59189 Mdot
.55238 .26556 Mdot
.55714 .53204 Mdot
.5619 .2057 Mdot
.56667 .47219 Mdot
.57143 .14585 Mdot
.57619 .41233 Mdot
.58095 .086 Mdot
.58571 .35248 Mdot
.59048 .02614 Mdot
.59524 .29263 Mdot
.6 .55911 Mdot
.60476 .23277 Mdot
.60952 .49926 Mdot
.61429 .17292 Mdot
.61905 .4394 Mdot
.62381 .11307 Mdot
.62857 .37955 Mdot
.63333 .05321 Mdot
.6381 .3197 Mdot
.64286 .58618 Mdot
.64762 .25984 Mdot
.65238 .52633 Mdot
.65714 .19999 Mdot
.6619 .46647 Mdot
.66667 .14014 Mdot
.67143 .40662 Mdot
.67619 .08028 Mdot
.68095 .34677 Mdot
.68571 .02043 Mdot
.69048 .28691 Mdot
.69524 .5534 Mdot
.7 .22706 Mdot
.70476 .49354 Mdot
.70952 .16721 Mdot
.71429 .43369 Mdot
.71905 .10735 Mdot
.72381 .37384 Mdot
.72857 .0475 Mdot
.73333 .31398 Mdot
.7381 .58047 Mdot
.74286 .25413 Mdot
.74762 .52061 Mdot
.75238 .19428 Mdot
.75714 .46076 Mdot
.7619 .13442 Mdot
.76667 .40091 Mdot
.77143 .07457 Mdot
.77619 .34105 Mdot
.78095 .01472 Mdot
.78571 .2812 Mdot
.79048 .54768 Mdot
.79524 .22135 Mdot
.8 .48783 Mdot
.80476 .16149 Mdot
.80952 .42798 Mdot
.81429 .10164 Mdot
.81905 .36812 Mdot
.82381 .04179 Mdot
.82857 .30827 Mdot
.83333 .57475 Mdot
.8381 .24842 Mdot
.84286 .5149 Mdot
.84762 .18856 Mdot
.85238 .45505 Mdot
.85714 .12871 Mdot
.8619 .39519 Mdot
.86667 .06886 Mdot
.87143 .33534 Mdot
.87619 .60182 Mdot
.88095 .27549 Mdot
.88571 .54197 Mdot
.89048 .21563 Mdot
.89524 .48212 Mdot
.9 .15578 Mdot
.90476 .42226 Mdot
.90952 .09593 Mdot
.91429 .36241 Mdot
.91905 .03607 Mdot
.92381 .30256 Mdot
.92857 .56904 Mdot
.93333 .2427 Mdot
.9381 .50919 Mdot
.94286 .18285 Mdot
.94762 .44933 Mdot
.95238 .123 Mdot
.95714 .38948 Mdot
.9619 .06314 Mdot
.96667 .32963 Mdot
.97143 .59611 Mdot
.97619 .26977 Mdot
.001 w
.02381 .32691 m
.02857 .59339 L
.03333 .26705 L
.0381 .53354 L
.04286 .2072 L
.04762 .47368 L
.05238 .14735 L
.05714 .41383 L
.0619 .08749 L
.06667 .35398 L
.07143 .02764 L
.07619 .29412 L
.08095 .56061 L
.08571 .23427 L
.09048 .50075 L
.09524 .17442 L
.1 .4409 L
.10476 .11456 L
.10952 .38105 L
.11429 .05471 L
.11905 .32119 L
.12381 .58768 L
.12857 .26134 L
.13333 .52782 L
.1381 .20149 L
.14286 .46797 L
.14762 .14163 L
.15238 .40812 L
.15714 .08178 L
.1619 .34826 L
.16667 .02193 L
.17143 .28841 L
.17619 .55489 L
.18095 .22856 L
.18571 .49504 L
.19048 .1687 L
.19524 .43519 L
.2 .10885 L
.20476 .37533 L
.20952 .049 L
.21429 .31548 L
.21905 .58196 L
.22381 .25563 L
.22857 .52211 L
.23333 .19577 L
.2381 .46226 L
.24286 .13592 L
.24762 .4024 L
.25238 .07607 L
.25714 .34255 L
Mistroke
.2619 .01621 L
.26667 .2827 L
.27143 .54918 L
.27619 .22284 L
.28095 .48933 L
.28571 .16299 L
.29048 .42947 L
.29524 .10314 L
.3 .36962 L
.30476 .04328 L
.30952 .30977 L
.31429 .57625 L
.31905 .24991 L
.32381 .5164 L
.32857 .19006 L
.33333 .45654 L
.3381 .13021 L
.34286 .39669 L
.34762 .07035 L
.35238 .33684 L
.35714 .60332 L
.3619 .27698 L
.36667 .54347 L
.37143 .21713 L
.37619 .48361 L
.38095 .15728 L
.38571 .42376 L
.39048 .09742 L
.39524 .36391 L
.4 .03757 L
.40476 .30405 L
.40952 .57054 L
.41429 .2442 L
.41905 .51068 L
.42381 .18435 L
.42857 .45083 L
.43333 .12449 L
.4381 .39098 L
.44286 .06464 L
.44762 .33112 L
.45238 .59761 L
.45714 .27127 L
.4619 .53775 L
.46667 .21142 L
.47143 .4779 L
.47619 .15156 L
.48095 .41805 L
.48571 .09171 L
.49048 .35819 L
.49524 .03186 L
Mistroke
.5 .29834 L
.50476 .56482 L
.50952 .23849 L
.51429 .50497 L
.51905 .17863 L
.52381 .44512 L
.52857 .11878 L
.53333 .38526 L
.5381 .05893 L
.54286 .32541 L
.54762 .59189 L
.55238 .26556 L
.55714 .53204 L
.5619 .2057 L
.56667 .47219 L
.57143 .14585 L
.57619 .41233 L
.58095 .086 L
.58571 .35248 L
.59048 .02614 L
.59524 .29263 L
.6 .55911 L
.60476 .23277 L
.60952 .49926 L
.61429 .17292 L
.61905 .4394 L
.62381 .11307 L
.62857 .37955 L
.63333 .05321 L
.6381 .3197 L
.64286 .58618 L
.64762 .25984 L
.65238 .52633 L
.65714 .19999 L
.6619 .46647 L
.66667 .14014 L
.67143 .40662 L
.67619 .08028 L
.68095 .34677 L
.68571 .02043 L
.69048 .28691 L
.69524 .5534 L
.7 .22706 L
.70476 .49354 L
.70952 .16721 L
.71429 .43369 L
.71905 .10735 L
.72381 .37384 L
.72857 .0475 L
.73333 .31398 L
Mistroke
.7381 .58047 L
.74286 .25413 L
.74762 .52061 L
.75238 .19428 L
.75714 .46076 L
.7619 .13442 L
.76667 .40091 L
.77143 .07457 L
.77619 .34105 L
.78095 .01472 L
.78571 .2812 L
.79048 .54768 L
.79524 .22135 L
.8 .48783 L
.80476 .16149 L
.80952 .42798 L
.81429 .10164 L
.81905 .36812 L
.82381 .04179 L
.82857 .30827 L
.83333 .57475 L
.8381 .24842 L
.84286 .5149 L
.84762 .18856 L
.85238 .45505 L
.85714 .12871 L
.8619 .39519 L
.86667 .06886 L
.87143 .33534 L
.87619 .60182 L
.88095 .27549 L
.88571 .54197 L
.89048 .21563 L
.89524 .48212 L
.9 .15578 L
.90476 .42226 L
.90952 .09593 L
.91429 .36241 L
.91905 .03607 L
.92381 .30256 L
.92857 .56904 L
.93333 .2427 L
.9381 .50919 L
.94286 .18285 L
.94762 .44933 L
.95238 .123 L
.95714 .38948 L
.9619 .06314 L
.96667 .32963 L
.97143 .59611 L
Mistroke
.97619 .26977 L
Mfstroke
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.85.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[15]= ",
 CellTags->"S5.85.1"]
}, Open  ]],

Cell[TextData[{
 "You cannot examine this function exactly at 1 since it is singular there. \
You can, however, examine it near 1. The label for ",
 StyleBox["1", "MR"],
 " ",
 StyleBox["+", "MR"],
 " ",
 StyleBox["300", "MR"],
 " ",
 StyleBox["Ulp[1]", "MR"],
 " is printed as ",
 StyleBox["1.", "MR"],
 " because the label is limited to 6 characters. "
}], "MathCaption",
 CellTags->{"S5.85.1", "1.24"}],

Cell[CellGroupData[{

Cell["\<\
MicroscopicError[1/(x - 1) - 1/(x + 1),
               {x, 1 + 300 Ulp[1]}]\
\>", "Input",
 CellLabel->"In[16]:= ",
 CellTags->"S5.85.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.015873 0.20787 0.398691 [
[.5 .19537 -8 -9.8125 ]
[.5 .19537 8 0 ]
[.01131 .04839 -24 -4.5 ]
[.01131 .04839 0 4.5 ]
[.01131 .12813 -24 -4.5 ]
[.01131 .12813 0 4.5 ]
[.01131 .28761 -18 -4.5 ]
[.01131 .28761 0 4.5 ]
[.01131 .36735 -18 -4.5 ]
[.01131 .36735 0 4.5 ]
[.01131 .44708 -18 -4.5 ]
[.01131 .44708 0 4.5 ]
[.01131 .52682 -18 -4.5 ]
[.01131 .52682 0 4.5 ]
[.01131 .60656 -6 -4.5 ]
[.01131 .60656 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.5 .20787 m
.5 .21412 L
s
gsave
.5 .19537 -69 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.) show
75.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .20787 m
1 .20787 L
s
.02381 .04839 m
.03006 .04839 L
s
[(-0.4)] .01131 .04839 1 0 Mshowa
.02381 .12813 m
.03006 .12813 L
s
[(-0.2)] .01131 .12813 1 0 Mshowa
.02381 .28761 m
.03006 .28761 L
s
[(0.2)] .01131 .28761 1 0 Mshowa
.02381 .36735 m
.03006 .36735 L
s
[(0.4)] .01131 .36735 1 0 Mshowa
.02381 .44708 m
.03006 .44708 L
s
[(0.6)] .01131 .44708 1 0 Mshowa
.02381 .52682 m
.03006 .52682 L
s
[(0.8)] .01131 .52682 1 0 Mshowa
.02381 .60656 m
.03006 .60656 L
s
[(1)] .01131 .60656 1 0 Mshowa
.125 Mabswid
.02381 .06833 m
.02756 .06833 L
s
.02381 .08826 m
.02756 .08826 L
s
.02381 .1082 m
.02756 .1082 L
s
.02381 .14807 m
.02756 .14807 L
s
.02381 .168 m
.02756 .168 L
s
.02381 .18794 m
.02756 .18794 L
s
.02381 .2278 m
.02756 .2278 L
s
.02381 .24774 m
.02756 .24774 L
s
.02381 .26767 m
.02756 .26767 L
s
.02381 .30754 m
.02756 .30754 L
s
.02381 .32748 m
.02756 .32748 L
s
.02381 .34741 m
.02756 .34741 L
s
.02381 .38728 m
.02756 .38728 L
s
.02381 .40721 m
.02756 .40721 L
s
.02381 .42715 m
.02756 .42715 L
s
.02381 .46702 m
.02756 .46702 L
s
.02381 .48695 m
.02756 .48695 L
s
.02381 .50689 m
.02756 .50689 L
s
.02381 .54676 m
.02756 .54676 L
s
.02381 .56669 m
.02756 .56669 L
s
.02381 .58663 m
.02756 .58663 L
s
.02381 .02846 m
.02756 .02846 L
s
.02381 .00852 m
.02756 .00852 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
.00667 w
.02381 .20787 Mdot
.03968 .20787 Mdot
.05556 .20787 Mdot
.07143 .60332 Mdot
.0873 .20787 Mdot
.10317 .20787 Mdot
.11905 .20787 Mdot
.13492 .20787 Mdot
.15079 .20787 Mdot
.16667 .20787 Mdot
.18254 .20787 Mdot
.19841 .20787 Mdot
.21429 .20787 Mdot
.23016 .20787 Mdot
.24603 .20787 Mdot
.2619 .20787 Mdot
.27778 .20787 Mdot
.29365 .20787 Mdot
.30952 .20787 Mdot
.3254 .20787 Mdot
.34127 .20787 Mdot
.35714 .20787 Mdot
.37302 .20787 Mdot
.38889 .20787 Mdot
.40476 .20787 Mdot
.42063 .20787 Mdot
.43651 .20787 Mdot
.45238 .20787 Mdot
.46825 .20787 Mdot
.48413 .20787 Mdot
.5 .40456 Mdot
.51587 .20787 Mdot
.53175 .20787 Mdot
.54762 .20787 Mdot
.56349 .40463 Mdot
.57937 .20787 Mdot
.59524 .20787 Mdot
.61111 .20787 Mdot
.62698 .20787 Mdot
.64286 .20787 Mdot
.65873 .20787 Mdot
.6746 .01472 Mdot
.69048 .20787 Mdot
.70635 .20787 Mdot
.72222 .20787 Mdot
.7381 .20787 Mdot
.75397 .20787 Mdot
.76984 .37499 Mdot
.78571 .05599 Mdot
.80159 .20787 Mdot
.81746 .20787 Mdot
.83333 .05865 Mdot
.84921 .20787 Mdot
.86508 .20787 Mdot
.88095 .20787 Mdot
.89683 .20787 Mdot
.9127 .20787 Mdot
.92857 .20787 Mdot
.94444 .20787 Mdot
.96032 .20787 Mdot
.97619 .20787 Mdot
.001 w
.02381 .20787 m
.03968 .20787 L
.05556 .20787 L
.07143 .60332 L
.0873 .20787 L
.10317 .20787 L
.11905 .20787 L
.13492 .20787 L
.15079 .20787 L
.16667 .20787 L
.18254 .20787 L
.19841 .20787 L
.21429 .20787 L
.23016 .20787 L
.24603 .20787 L
.2619 .20787 L
.27778 .20787 L
.29365 .20787 L
.30952 .20787 L
.3254 .20787 L
.34127 .20787 L
.35714 .20787 L
.37302 .20787 L
.38889 .20787 L
.40476 .20787 L
.42063 .20787 L
.43651 .20787 L
.45238 .20787 L
.46825 .20787 L
.48413 .20787 L
.5 .40456 L
.51587 .20787 L
.53175 .20787 L
.54762 .20787 L
.56349 .40463 L
.57937 .20787 L
.59524 .20787 L
.61111 .20787 L
.62698 .20787 L
.64286 .20787 L
.65873 .20787 L
.6746 .01472 L
.69048 .20787 L
.70635 .20787 L
.72222 .20787 L
.7381 .20787 L
.75397 .20787 L
.76984 .37499 L
.78571 .05599 L
.80159 .20787 L
Mistroke
.81746 .20787 L
.83333 .05865 L
.84921 .20787 L
.86508 .20787 L
.88095 .20787 L
.89683 .20787 L
.9127 .20787 L
.92857 .20787 L
.94444 .20787 L
.96032 .20787 L
.97619 .20787 L
Mfstroke
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.85.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[16]= ",
 CellTags->"S5.85.1"]
}, Open  ]],

Cell[TextData[{
 "One point needs to be made clear here since rounding errors are often \
misunderstood and blame is incorrectly placed on an algorithm that has \
nothing to do with the error. Algorithms are designed to map the set of \
machine numbers into the set of machine numbers. To consider other numbers \
does not make sense. As far as the computer is concerned there ",
 StyleBox["are", "TI"],
 " no other numbers. So, for example, if you want to find the square root of \
",
 Cell[BoxData[
  FormBox[
   RowBox[{"49", 
    RowBox[{"\[Pi]", "/", "50"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", you might do it as follows. "
}], "Text",
 CellTags->{"S5.85.1", "1.25"}],

Cell[TextData[{
 "Start with a good numerical approximation to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"49", 
    RowBox[{"\[Pi]", "/", "50"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.85.1", "1.26"}],

Cell[CellGroupData[{

Cell["a = N[49 Pi/50, 30]", "Input",
 CellLabel->"In[17]:= ",
 CellTags->"S5.85.1"],

Cell[BoxData["3.078760800517997373693390515613912826513226011386`30."], \
"Output",
 CellLabel->"Out[17]= ",
 CellTags->"S5.85.1"]
}, Open  ]],

Cell[TextData[{
 "This finds the nearest machine number to ",
 StyleBox["a", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.85.1", "1.27"}],

Cell[CellGroupData[{

Cell["b = N[a]", "Input",
 CellLabel->"In[18]:= ",
 CellTags->"S5.85.1"],

Cell[BoxData["3.078760800517997`"], "Output",
 CellLabel->"Out[18]= ",
 CellTags->"S5.85.1"]
}, Open  ]],

Cell[TextData[{
 "This finds the square root of the machine number ",
 StyleBox["b", "MR"],
 " using the machine\[Hyphen]precision algorithm for square root. "
}], "MathCaption",
 CellTags->{"S5.85.1", "1.28"}],

Cell[CellGroupData[{

Cell["c = Sqrt[b]", "Input",
 CellLabel->"In[19]:= ",
 CellTags->"S5.85.1"],

Cell[BoxData["1.7546397922417003`"], "Output",
 CellLabel->"Out[19]= ",
 CellTags->"S5.85.1"]
}, Open  ]],

Cell[TextData[{
 "Here the error in ",
 StyleBox["c", "MR"],
 " is measured in ulps. This result gives the error for the particular \
machine on which this example was run. Your machine may give a very different \
result. "
}], "MathCaption",
 CellTags->{"S5.85.1", "1.29"}],

Cell[CellGroupData[{

Cell["(SetPrecision[c,30]-Sqrt[a])/$MachineEpsilon", "Input",
 CellLabel->"In[20]:= ",
 CellTags->"S5.85.1"],

Cell[BoxData[
 RowBox[{"-", "0.22218789820841633`"}]], "Output",
 CellLabel->"Out[20]= ",
 CellTags->"S5.85.1"]
}, Open  ]],

Cell[TextData[{
 "Here the error is less than half an ulp. However, this error is due to both \
the square root function and the rounding error incurred in converting the \
number ",
 StyleBox["a", "MR"],
 " to the machine number ",
 StyleBox["b", "MR"],
 ". In fact, the square root function has an error of less than 0.1 ulps. "
}], "Text",
 CellTags->{"S5.85.1", "1.30"}],

Cell[TextData[{
 "Here is the correct value for the square root of ",
 StyleBox["b", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.85.1", "1.31"}],

Cell[CellGroupData[{

Cell["d = Sqrt[SetPrecision[b, 30]]", "Input",
 CellLabel->"In[21]:= ",
 CellTags->"S5.85.1"],

Cell[BoxData["1.754639792241700292182175473517310164292198791789`30.\
30102999566398"], "Output",
 CellLabel->"Out[21]= ",
 CellTags->"S5.85.1"]
}, Open  ]],

Cell["This shows the error in the square root function. ", "MathCaption",
 CellTags->{"S5.85.1", "1.32"}],

Cell[CellGroupData[{

Cell["(SetPrecision[c, 30] - d)/$MachineEpsilon", "Input",
 CellLabel->"In[22]:= ",
 CellTags->"S5.85.1"],

Cell[BoxData["0.04581618252996657`"], "Output",
 CellLabel->"Out[22]= ",
 CellTags->"S5.85.1"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.85.1"->{
    Cell[1776, 53, 140, 6, 36, "Subsection",
      CellTags->{"S5.85.1", "1.1"}],
    Cell[1919, 61, 549, 11, 88, "Text",
      CellTags->{"S5.85.1", "1.2"}],
    Cell[2471, 74, 804, 13, 136, "Text",
      CellTags->{"S5.85.1", "1.3"}],
    Cell[3278, 89, 1725, 39, 184, "Text",
      CellTags->{"S5.85.1", "1.4"}],
    Cell[5006, 130, 244, 6, 40, "Text",
      CellTags->{"S5.85.1", "1.5"}],
    Cell[5253, 138, 5874, 187, 144, "DefinitionBox",
      CellTags->"S5.85.1"],
    Cell[11130, 327, 116, 3, 70, "Caption",
      CellTags->"S5.85.1"],
    Cell[11249, 332, 1013, 28, 70, "Text",
      CellTags->{"S5.85.1", "1.6"}],
    Cell[12265, 362, 509, 11, 70, "Text",
      CellTags->{"S5.85.1", "1.7"}],
    Cell[12777, 375, 6492, 206, 70, "DefinitionBox",
      CellTags->"S5.85.1"],
    Cell[19272, 583, 83, 1, 70, "Caption",
      CellTags->"S5.85.1"],
    Cell[19358, 586, 1026, 19, 70, "Text",
      CellTags->{"S5.85.1", "1.8"}],
    Cell[20387, 607, 2154, 69, 70, "DefinitionBox3Col",
      CellTags->"S5.85.1"],
    Cell[22544, 678, 152, 7, 70, "Caption",
      CellTags->"S5.85.1"],
    Cell[22699, 687, 78, 1, 70, "MathCaption",
      CellTags->{"S5.85.1", "1.9"}],
    Cell[22780, 690, 90, 2, 70, "Input",
      CellTags->"S5.85.1"],
    Cell[22873, 694, 88, 1, 70, "MathCaption",
      CellTags->{"S5.85.1", "1.10"}],
    Cell[22986, 699, 69, 2, 70, "Input",
      CellTags->"S5.85.1"],
    Cell[23058, 703, 97, 2, 70, "Output",
      CellTags->"S5.85.1"],
    Cell[23170, 708, 98, 1, 70, "MathCaption",
      CellTags->{"S5.85.1", "1.11"}],
    Cell[23293, 713, 101, 2, 70, "Input",
      CellTags->"S5.85.1"],
    Cell[23397, 717, 203, 6, 70, "Output",
      CellTags->"S5.85.1"],
    Cell[23615, 726, 85, 1, 70, "MathCaption",
      CellTags->{"S5.85.1", "1.12"}],
    Cell[23725, 731, 95, 2, 70, "Input",
      CellTags->"S5.85.1"],
    Cell[23823, 735, 211, 7, 70, "Output",
      CellTags->"S5.85.1"],
    Cell[24049, 745, 342, 9, 70, "MathCaption",
      CellTags->{"S5.85.1", "1.13"}],
    Cell[24416, 758, 99, 2, 70, "Input",
      CellTags->"S5.85.1"],
    Cell[24518, 762, 135, 4, 70, "Output",
      CellTags->"S5.85.1"],
    Cell[24668, 769, 98, 1, 70, "MathCaption",
      CellTags->{"S5.85.1", "1.14"}],
    Cell[24791, 774, 102, 2, 70, "Input",
      CellTags->"S5.85.1"],
    Cell[24896, 778, 118, 3, 70, "Output",
      CellTags->"S5.85.1"],
    Cell[25029, 784, 201, 5, 70, "MathCaption",
      CellTags->{"S5.85.1", "1.15"}],
    Cell[25255, 793, 130, 5, 70, "Input",
      CellTags->"S5.85.1"],
    Cell[25388, 800, 118, 3, 70, "Output",
      CellTags->"S5.85.1"],
    Cell[25521, 806, 849, 23, 70, "MathCaption",
      CellTags->{"S5.85.1", "1.16"}],
    Cell[26395, 833, 125, 5, 70, "Input",
      CellTags->"S5.85.1"],
    Cell[26523, 840, 134, 4, 70, "Output",
      CellTags->"S5.85.1"],
    Cell[26672, 847, 248, 7, 70, "MathCaption",
      CellTags->{"S5.85.1", "1.17"}],
    Cell[26945, 858, 119, 5, 70, "Input",
      CellTags->"S5.85.1"],
    Cell[27067, 865, 4666, 216, 70, 4595, 213, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.85.1"],
    Cell[31736, 1083, 180, 6, 70, "Output",
      CellTags->"S5.85.1"],
    Cell[31931, 1092, 443, 12, 70, "MathCaption",
      CellTags->{"S5.85.1", "1.18"}],
    Cell[32399, 1108, 94, 2, 70, "Input",
      CellTags->"S5.85.1"],
    Cell[32496, 1112, 4248, 199, 70, 4177, 196, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.85.1"],
    Cell[36747, 1313, 181, 6, 70, "Output",
      CellTags->"S5.85.1"],
    Cell[36943, 1322, 499, 14, 70, "MathCaption",
      CellTags->{"S5.85.1", "1.19"}],
    Cell[37467, 1340, 124, 5, 70, "Input",
      CellTags->"S5.85.1"],
    Cell[37594, 1347, 4552, 218, 70, 4481, 215, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.85.1"],
    Cell[42149, 1567, 181, 6, 70, "Output",
      CellTags->"S5.85.1"],
    Cell[42345, 1576, 588, 13, 70, "MathCaption",
      CellTags->{"S5.85.1", "1.20"}],
    Cell[42958, 1593, 131, 5, 70, "Input",
      CellTags->"S5.85.1"],
    Cell[43092, 1600, 3726, 204, 70, 3655, 201, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.85.1"],
    Cell[46821, 1806, 181, 6, 70, "Output",
      CellTags->"S5.85.1"],
    Cell[47017, 1815, 174, 4, 70, "MathCaption",
      CellTags->{"S5.85.1", "1.21"}],
    Cell[47216, 1823, 130, 5, 70, "Input",
      CellTags->"S5.85.1"],
    Cell[47349, 1830, 3835, 217, 70, 3764, 214, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.85.1"],
    Cell[51187, 2049, 181, 6, 70, "Output",
      CellTags->"S5.85.1"],
    Cell[51383, 2058, 515, 9, 70, "MathCaption",
      CellTags->{"S5.85.1", "1.22"}],
    Cell[51923, 2071, 130, 5, 70, "Input",
      CellTags->"S5.85.1"],
    Cell[52056, 2078, 4682, 275, 70, 4611, 272, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.85.1"],
    Cell[56741, 2355, 181, 6, 70, "Output",
      CellTags->"S5.85.1"],
    Cell[56937, 2364, 426, 12, 70, "MathCaption",
      CellTags->{"S5.85.1", "1.23"}],
    Cell[57388, 2380, 104, 2, 70, "Input",
      CellTags->"S5.85.1"],
    Cell[57495, 2384, 10079, 584, 70, 10008, 581, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.85.1"],
    Cell[67577, 2970, 181, 6, 70, "Output",
      CellTags->"S5.85.1"],
    Cell[67773, 2979, 405, 14, 70, "MathCaption",
      CellTags->{"S5.85.1", "1.24"}],
    Cell[68203, 2997, 147, 5, 70, "Input",
      CellTags->"S5.85.1"],
    Cell[68353, 3004, 5870, 340, 70, 5799, 337, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.85.1"],
    Cell[74226, 3346, 181, 6, 70, "Output",
      CellTags->"S5.85.1"],
    Cell[74422, 3355, 725, 16, 70, "Text",
      CellTags->{"S5.85.1", "1.25"}],
    Cell[75150, 3373, 284, 9, 70, "MathCaption",
      CellTags->{"S5.85.1", "1.26"}],
    Cell[75459, 3386, 83, 2, 70, "Input",
      CellTags->"S5.85.1"],
    Cell[75545, 3390, 130, 3, 70, "Output",
      CellTags->"S5.85.1"],
    Cell[75690, 3396, 140, 5, 70, "MathCaption",
      CellTags->{"S5.85.1", "1.27"}],
    Cell[75855, 3405, 72, 2, 70, "Input",
      CellTags->"S5.85.1"],
    Cell[75930, 3409, 92, 2, 70, "Output",
      CellTags->"S5.85.1"],
    Cell[76037, 3414, 210, 5, 70, "MathCaption",
      CellTags->{"S5.85.1", "1.28"}],
    Cell[76272, 3423, 75, 2, 70, "Input",
      CellTags->"S5.85.1"],
    Cell[76350, 3427, 93, 2, 70, "Output",
      CellTags->"S5.85.1"],
    Cell[76458, 3432, 274, 7, 70, "MathCaption",
      CellTags->{"S5.85.1", "1.29"}],
    Cell[76757, 3443, 108, 2, 70, "Input",
      CellTags->"S5.85.1"],
    Cell[76868, 3447, 111, 3, 70, "Output",
      CellTags->"S5.85.1"],
    Cell[76994, 3453, 374, 9, 70, "Text",
      CellTags->{"S5.85.1", "1.30"}],
    Cell[77371, 3464, 148, 5, 70, "MathCaption",
      CellTags->{"S5.85.1", "1.31"}],
    Cell[77544, 3473, 93, 2, 70, "Input",
      CellTags->"S5.85.1"],
    Cell[77640, 3477, 144, 3, 70, "Output",
      CellTags->"S5.85.1"],
    Cell[77799, 3483, 105, 1, 70, "MathCaption",
      CellTags->{"S5.85.1", "1.32"}],
    Cell[77929, 3488, 105, 2, 70, "Input",
      CellTags->"S5.85.1"],
    Cell[78037, 3492, 94, 2, 70, "Output",
      CellTags->"S5.85.1"]},
  "1.1"->{
    Cell[1776, 53, 140, 6, 36, "Subsection",
      CellTags->{"S5.85.1", "1.1"}]},
  "1.2"->{
    Cell[1919, 61, 549, 11, 88, "Text",
      CellTags->{"S5.85.1", "1.2"}]},
  "1.3"->{
    Cell[2471, 74, 804, 13, 136, "Text",
      CellTags->{"S5.85.1", "1.3"}]},
  "1.4"->{
    Cell[3278, 89, 1725, 39, 184, "Text",
      CellTags->{"S5.85.1", "1.4"}]},
  "1.5"->{
    Cell[5006, 130, 244, 6, 40, "Text",
      CellTags->{"S5.85.1", "1.5"}]},
  "1.6"->{
    Cell[11249, 332, 1013, 28, 70, "Text",
      CellTags->{"S5.85.1", "1.6"}]},
  "1.7"->{
    Cell[12265, 362, 509, 11, 70, "Text",
      CellTags->{"S5.85.1", "1.7"}]},
  "1.8"->{
    Cell[19358, 586, 1026, 19, 70, "Text",
      CellTags->{"S5.85.1", "1.8"}]},
  "1.9"->{
    Cell[22699, 687, 78, 1, 70, "MathCaption",
      CellTags->{"S5.85.1", "1.9"}]},
  "1.10"->{
    Cell[22873, 694, 88, 1, 70, "MathCaption",
      CellTags->{"S5.85.1", "1.10"}]},
  "1.11"->{
    Cell[23170, 708, 98, 1, 70, "MathCaption",
      CellTags->{"S5.85.1", "1.11"}]},
  "1.12"->{
    Cell[23615, 726, 85, 1, 70, "MathCaption",
      CellTags->{"S5.85.1", "1.12"}]},
  "1.13"->{
    Cell[24049, 745, 342, 9, 70, "MathCaption",
      CellTags->{"S5.85.1", "1.13"}]},
  "1.14"->{
    Cell[24668, 769, 98, 1, 70, "MathCaption",
      CellTags->{"S5.85.1", "1.14"}]},
  "1.15"->{
    Cell[25029, 784, 201, 5, 70, "MathCaption",
      CellTags->{"S5.85.1", "1.15"}]},
  "1.16"->{
    Cell[25521, 806, 849, 23, 70, "MathCaption",
      CellTags->{"S5.85.1", "1.16"}]},
  "1.17"->{
    Cell[26672, 847, 248, 7, 70, "MathCaption",
      CellTags->{"S5.85.1", "1.17"}]},
  "1.18"->{
    Cell[31931, 1092, 443, 12, 70, "MathCaption",
      CellTags->{"S5.85.1", "1.18"}]},
  "1.19"->{
    Cell[36943, 1322, 499, 14, 70, "MathCaption",
      CellTags->{"S5.85.1", "1.19"}]},
  "1.20"->{
    Cell[42345, 1576, 588, 13, 70, "MathCaption",
      CellTags->{"S5.85.1", "1.20"}]},
  "1.21"->{
    Cell[47017, 1815, 174, 4, 70, "MathCaption",
      CellTags->{"S5.85.1", "1.21"}]},
  "1.22"->{
    Cell[51383, 2058, 515, 9, 70, "MathCaption",
      CellTags->{"S5.85.1", "1.22"}]},
  "1.23"->{
    Cell[56937, 2364, 426, 12, 70, "MathCaption",
      CellTags->{"S5.85.1", "1.23"}]},
  "1.24"->{
    Cell[67773, 2979, 405, 14, 70, "MathCaption",
      CellTags->{"S5.85.1", "1.24"}]},
  "1.25"->{
    Cell[74422, 3355, 725, 16, 70, "Text",
      CellTags->{"S5.85.1", "1.25"}]},
  "1.26"->{
    Cell[75150, 3373, 284, 9, 70, "MathCaption",
      CellTags->{"S5.85.1", "1.26"}]},
  "1.27"->{
    Cell[75690, 3396, 140, 5, 70, "MathCaption",
      CellTags->{"S5.85.1", "1.27"}]},
  "1.28"->{
    Cell[76037, 3414, 210, 5, 70, "MathCaption",
      CellTags->{"S5.85.1", "1.28"}]},
  "1.29"->{
    Cell[76458, 3432, 274, 7, 70, "MathCaption",
      CellTags->{"S5.85.1", "1.29"}]},
  "1.30"->{
    Cell[76994, 3453, 374, 9, 70, "Text",
      CellTags->{"S5.85.1", "1.30"}]},
  "1.31"->{
    Cell[77371, 3464, 148, 5, 70, "MathCaption",
      CellTags->{"S5.85.1", "1.31"}]},
  "1.32"->{
    Cell[77799, 3483, 105, 1, 70, "MathCaption",
      CellTags->{"S5.85.1", "1.32"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.85.1", 78782, 3514},
  {"1.1", 86223, 3709},
  {"1.2", 86317, 3712},
  {"1.3", 86406, 3715},
  {"1.4", 86496, 3718},
  {"1.5", 86587, 3721},
  {"1.6", 86676, 3724},
  {"1.7", 86768, 3727},
  {"1.8", 86859, 3730},
  {"1.9", 86951, 3733},
  {"1.10", 87048, 3736},
  {"1.11", 87146, 3739},
  {"1.12", 87244, 3742},
  {"1.13", 87342, 3745},
  {"1.14", 87441, 3748},
  {"1.15", 87539, 3751},
  {"1.16", 87638, 3754},
  {"1.17", 87738, 3757},
  {"1.18", 87837, 3760},
  {"1.19", 87938, 3763},
  {"1.20", 88039, 3766},
  {"1.21", 88140, 3769},
  {"1.22", 88240, 3772},
  {"1.23", 88340, 3775},
  {"1.24", 88441, 3778},
  {"1.25", 88542, 3781},
  {"1.26", 88636, 3784},
  {"1.27", 88736, 3787},
  {"1.28", 88836, 3790},
  {"1.29", 88936, 3793},
  {"1.30", 89036, 3796},
  {"1.31", 89129, 3799},
  {"1.32", 89229, 3802}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 140, 6, 36, "Subsection",
  CellTags->{"S5.85.1", "1.1"}],
Cell[1919, 61, 549, 11, 88, "Text",
  CellTags->{"S5.85.1", "1.2"}],
Cell[2471, 74, 804, 13, 136, "Text",
  CellTags->{"S5.85.1", "1.3"}],
Cell[3278, 89, 1725, 39, 184, "Text",
  CellTags->{"S5.85.1", "1.4"}],
Cell[5006, 130, 244, 6, 40, "Text",
  CellTags->{"S5.85.1", "1.5"}],
Cell[5253, 138, 5874, 187, 144, "DefinitionBox",
  CellTags->"S5.85.1"],
Cell[11130, 327, 116, 3, 70, "Caption",
  CellTags->"S5.85.1"],
Cell[11249, 332, 1013, 28, 70, "Text",
  CellTags->{"S5.85.1", "1.6"}],
Cell[12265, 362, 509, 11, 70, "Text",
  CellTags->{"S5.85.1", "1.7"}],
Cell[12777, 375, 6492, 206, 70, "DefinitionBox",
  CellTags->"S5.85.1"],
Cell[19272, 583, 83, 1, 70, "Caption",
  CellTags->"S5.85.1"],
Cell[19358, 586, 1026, 19, 70, "Text",
  CellTags->{"S5.85.1", "1.8"}],
Cell[20387, 607, 2154, 69, 70, "DefinitionBox3Col",
  CellTags->"S5.85.1"],
Cell[22544, 678, 152, 7, 70, "Caption",
  CellTags->"S5.85.1"],
Cell[22699, 687, 78, 1, 70, "MathCaption",
  CellTags->{"S5.85.1", "1.9"}],
Cell[22780, 690, 90, 2, 70, "Input",
  CellTags->"S5.85.1"],
Cell[22873, 694, 88, 1, 70, "MathCaption",
  CellTags->{"S5.85.1", "1.10"}],

Cell[CellGroupData[{
Cell[22986, 699, 69, 2, 70, "Input",
  CellTags->"S5.85.1"],
Cell[23058, 703, 97, 2, 70, "Output",
  CellTags->"S5.85.1"]
}, Open  ]],
Cell[23170, 708, 98, 1, 70, "MathCaption",
  CellTags->{"S5.85.1", "1.11"}],

Cell[CellGroupData[{
Cell[23293, 713, 101, 2, 70, "Input",
  CellTags->"S5.85.1"],
Cell[23397, 717, 203, 6, 70, "Output",
  CellTags->"S5.85.1"]
}, Open  ]],
Cell[23615, 726, 85, 1, 70, "MathCaption",
  CellTags->{"S5.85.1", "1.12"}],

Cell[CellGroupData[{
Cell[23725, 731, 95, 2, 70, "Input",
  CellTags->"S5.85.1"],
Cell[23823, 735, 211, 7, 70, "Output",
  CellTags->"S5.85.1"]
}, Open  ]],
Cell[24049, 745, 342, 9, 70, "MathCaption",
  CellTags->{"S5.85.1", "1.13"}],

Cell[CellGroupData[{
Cell[24416, 758, 99, 2, 70, "Input",
  CellTags->"S5.85.1"],
Cell[24518, 762, 135, 4, 70, "Output",
  CellTags->"S5.85.1"]
}, Open  ]],
Cell[24668, 769, 98, 1, 70, "MathCaption",
  CellTags->{"S5.85.1", "1.14"}],

Cell[CellGroupData[{
Cell[24791, 774, 102, 2, 70, "Input",
  CellTags->"S5.85.1"],
Cell[24896, 778, 118, 3, 70, "Output",
  CellTags->"S5.85.1"]
}, Open  ]],
Cell[25029, 784, 201, 5, 70, "MathCaption",
  CellTags->{"S5.85.1", "1.15"}],

Cell[CellGroupData[{
Cell[25255, 793, 130, 5, 70, "Input",
  CellTags->"S5.85.1"],
Cell[25388, 800, 118, 3, 70, "Output",
  CellTags->"S5.85.1"]
}, Open  ]],
Cell[25521, 806, 849, 23, 70, "MathCaption",
  CellTags->{"S5.85.1", "1.16"}],

Cell[CellGroupData[{
Cell[26395, 833, 125, 5, 70, "Input",
  CellTags->"S5.85.1"],
Cell[26523, 840, 134, 4, 70, "Output",
  CellTags->"S5.85.1"]
}, Open  ]],
Cell[26672, 847, 248, 7, 70, "MathCaption",
  CellTags->{"S5.85.1", "1.17"}],

Cell[CellGroupData[{
Cell[26945, 858, 119, 5, 70, "Input",
  CellTags->"S5.85.1"],
Cell[27067, 865, 4666, 216, 70, 4595, 213, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.85.1"],
Cell[31736, 1083, 180, 6, 70, "Output",
  CellTags->"S5.85.1"]
}, Open  ]],
Cell[31931, 1092, 443, 12, 70, "MathCaption",
  CellTags->{"S5.85.1", "1.18"}],

Cell[CellGroupData[{
Cell[32399, 1108, 94, 2, 70, "Input",
  CellTags->"S5.85.1"],
Cell[32496, 1112, 4248, 199, 70, 4177, 196, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.85.1"],
Cell[36747, 1313, 181, 6, 70, "Output",
  CellTags->"S5.85.1"]
}, Open  ]],
Cell[36943, 1322, 499, 14, 70, "MathCaption",
  CellTags->{"S5.85.1", "1.19"}],

Cell[CellGroupData[{
Cell[37467, 1340, 124, 5, 70, "Input",
  CellTags->"S5.85.1"],
Cell[37594, 1347, 4552, 218, 70, 4481, 215, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.85.1"],
Cell[42149, 1567, 181, 6, 70, "Output",
  CellTags->"S5.85.1"]
}, Open  ]],
Cell[42345, 1576, 588, 13, 70, "MathCaption",
  CellTags->{"S5.85.1", "1.20"}],

Cell[CellGroupData[{
Cell[42958, 1593, 131, 5, 70, "Input",
  CellTags->"S5.85.1"],
Cell[43092, 1600, 3726, 204, 70, 3655, 201, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.85.1"],
Cell[46821, 1806, 181, 6, 70, "Output",
  CellTags->"S5.85.1"]
}, Open  ]],
Cell[47017, 1815, 174, 4, 70, "MathCaption",
  CellTags->{"S5.85.1", "1.21"}],

Cell[CellGroupData[{
Cell[47216, 1823, 130, 5, 70, "Input",
  CellTags->"S5.85.1"],
Cell[47349, 1830, 3835, 217, 70, 3764, 214, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.85.1"],
Cell[51187, 2049, 181, 6, 70, "Output",
  CellTags->"S5.85.1"]
}, Open  ]],
Cell[51383, 2058, 515, 9, 70, "MathCaption",
  CellTags->{"S5.85.1", "1.22"}],

Cell[CellGroupData[{
Cell[51923, 2071, 130, 5, 70, "Input",
  CellTags->"S5.85.1"],
Cell[52056, 2078, 4682, 275, 70, 4611, 272, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.85.1"],
Cell[56741, 2355, 181, 6, 70, "Output",
  CellTags->"S5.85.1"]
}, Open  ]],
Cell[56937, 2364, 426, 12, 70, "MathCaption",
  CellTags->{"S5.85.1", "1.23"}],

Cell[CellGroupData[{
Cell[57388, 2380, 104, 2, 70, "Input",
  CellTags->"S5.85.1"],
Cell[57495, 2384, 10079, 584, 70, 10008, 581, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.85.1"],
Cell[67577, 2970, 181, 6, 70, "Output",
  CellTags->"S5.85.1"]
}, Open  ]],
Cell[67773, 2979, 405, 14, 70, "MathCaption",
  CellTags->{"S5.85.1", "1.24"}],

Cell[CellGroupData[{
Cell[68203, 2997, 147, 5, 70, "Input",
  CellTags->"S5.85.1"],
Cell[68353, 3004, 5870, 340, 70, 5799, 337, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.85.1"],
Cell[74226, 3346, 181, 6, 70, "Output",
  CellTags->"S5.85.1"]
}, Open  ]],
Cell[74422, 3355, 725, 16, 70, "Text",
  CellTags->{"S5.85.1", "1.25"}],
Cell[75150, 3373, 284, 9, 70, "MathCaption",
  CellTags->{"S5.85.1", "1.26"}],

Cell[CellGroupData[{
Cell[75459, 3386, 83, 2, 70, "Input",
  CellTags->"S5.85.1"],
Cell[75545, 3390, 130, 3, 70, "Output",
  CellTags->"S5.85.1"]
}, Open  ]],
Cell[75690, 3396, 140, 5, 70, "MathCaption",
  CellTags->{"S5.85.1", "1.27"}],

Cell[CellGroupData[{
Cell[75855, 3405, 72, 2, 70, "Input",
  CellTags->"S5.85.1"],
Cell[75930, 3409, 92, 2, 70, "Output",
  CellTags->"S5.85.1"]
}, Open  ]],
Cell[76037, 3414, 210, 5, 70, "MathCaption",
  CellTags->{"S5.85.1", "1.28"}],

Cell[CellGroupData[{
Cell[76272, 3423, 75, 2, 70, "Input",
  CellTags->"S5.85.1"],
Cell[76350, 3427, 93, 2, 70, "Output",
  CellTags->"S5.85.1"]
}, Open  ]],
Cell[76458, 3432, 274, 7, 70, "MathCaption",
  CellTags->{"S5.85.1", "1.29"}],

Cell[CellGroupData[{
Cell[76757, 3443, 108, 2, 70, "Input",
  CellTags->"S5.85.1"],
Cell[76868, 3447, 111, 3, 70, "Output",
  CellTags->"S5.85.1"]
}, Open  ]],
Cell[76994, 3453, 374, 9, 70, "Text",
  CellTags->{"S5.85.1", "1.30"}],
Cell[77371, 3464, 148, 5, 70, "MathCaption",
  CellTags->{"S5.85.1", "1.31"}],

Cell[CellGroupData[{
Cell[77544, 3473, 93, 2, 70, "Input",
  CellTags->"S5.85.1"],
Cell[77640, 3477, 144, 3, 70, "Output",
  CellTags->"S5.85.1"]
}, Open  ]],
Cell[77799, 3483, 105, 1, 70, "MathCaption",
  CellTags->{"S5.85.1", "1.32"}],

Cell[CellGroupData[{
Cell[77929, 3488, 105, 2, 70, "Input",
  CellTags->"S5.85.1"],
Cell[78037, 3492, 94, 2, 70, "Output",
  CellTags->"S5.85.1"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

