(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    204998,       7614]*)
(*NotebookOutlinePosition[    230957,       8361]*)
(*  CellTagsIndexPosition[    228864,       8277]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Statistics",
 StyleBox["`", "MB"],
 "MultiDescriptiveStatistics",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S6.4.1", "1.1"}],

Cell[TextData[{
 "Multivariate data consist of observations on two or more variables measured \
on a set of objects. Descriptive statistics of multivariate data must not \
only measure properties such as location, dispersion, and shape, but also the \
interdependence between variables. The functions in this package compute \
descriptive statistics of data arranged in a ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["n",
     "TI"], "\[Cross]", 
    StyleBox["p",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " ",
 StyleBox["data matrix", "TI"],
 ". Specifically, the ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " rows of a data matrix are treated as independent identically distributed \
",
 Cell[BoxData[
  FormBox[
   StyleBox["p",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "\[Hyphen]variate observations. If your data (vector\[Hyphen] or scalar\
\[Hyphen]valued) are ordered or you suspect the data exhibit a trend, then \
you should consider describing and analyzing your data using the functions \
provided by the ",
 ButtonBox["Time Series Pack",
  ButtonStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/products/applications/timeseries/"], None}],
 ", an application available through Wolfram Research. "
}], "Text",
 CellTags->{"S6.4.1", "1.2"}],

Cell[TextData[{
 "You can calculate some of the standard descriptive statistics for \
distributions based on the multivariate normal distribution by using the ",
 StyleBox["Statistics`MultinormalDistribution`", "MR"],
 " package. "
}], "Text",
 CellTags->{"S6.4.1", "1.3"}],

Cell[TextData[{
 "The first effect of loading ",
 StyleBox["MultiDescriptiveStatistics", "MR"],
 " is to trivially extend most of the univariate descriptive statistics made \
available in the package ",
 StyleBox["Statistics`DescriptiveStatistics`", "MR"],
 ", by applying them to the columns of the data matrix. "
}], "Text",
 CellTags->{"S6.4.1", "1.4"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[StyleBox["Mean",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Median",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Mode",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["GeometricMean",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["HarmonicMean",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["RootMeanSquare",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["TrimmedMean",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Quantile",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["InterpolatedQuantile",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Quartiles",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S6.4.1"],

Cell["\<\
Univariate location statistics applied to columns of a data matrix.\
\>", "Caption",
 CellTags->"S6.4.1"],

Cell[TextData[{
 "Note that the functions ",
 StyleBox["Mean", "MR"],
 ", ",
 StyleBox["Median", "MR"],
 ", and ",
 StyleBox["Quantile", "MR"],
 " are found in the kernel. This package does not need to be loaded to use \
them on data. "
}], "Text",
 CellTags->{"S6.4.1", "1.5"}],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S6.4.1", "1.6"}],

Cell["<<Statistics`MultiDescriptiveStatistics`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S6.4.1"],

Cell[TextData[{
 "Here is a bivariate data set consisting of measurements of stiffness \
(modulus of elasticity) and bending strength in ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["pounds",
     "TI"], "/", 
    SuperscriptBox[
     RowBox[{"(", 
      StyleBox["inches",
       "TI"], ")"}], "2"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " for a sample of 30 pieces of a particular grade of lumber (courtesy of \
United States Forest Products Laboratory). "
}], "MathCaption",
 CellTags->{"S6.4.1", "1.7"}],

Cell["\<\
data = {{1232, 4175}, {1115, 6652}, {2205, 7612},
{1897, 10914}, {1932, 10850}, {1612, 7627}, {1598, 6954},
{1804, 8365}, {1752, 9469}, {2067, 6410}, {2365, 10327},
{1646, 7320}, {1579, 8196}, {1880, 9709}, {1773, 10370},
{1712, 7749}, {1932, 6818}, {1820, 9307}, {1900, 6457},
{2426, 10102}, {1558, 7414}, {1470, 7556}, {1858, 7833},
{1587, 8309}, {2208, 9559}, {1487, 6255}, {2206, 10723},
{2332, 5430}, {2540, 12090}, {2322, 10072}} // N;\
\>", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S6.4.1"],

Cell["This gives the mean of the data. ", "MathCaption",
 CellTags->{"S6.4.1", "1.8"}],

Cell[CellGroupData[{

Cell["M = Mean[data]", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S6.4.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1860.5`", ",", "8354.133333333333`"}], "}"}]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S6.4.1"]
}, Open  ]],

Cell["This gives the median for each coordinate of the data. ", "MathCaption",
 CellTags->{"S6.4.1", "1.9"}],

Cell[CellGroupData[{

Cell["m = Median[data]", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S6.4.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1839.`", ",", "8014.5`"}], "}"}]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S6.4.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[StyleBox["SampleRange",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Variance",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["VarianceMLE",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["VarianceOfSampleMean",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["StandardDeviation",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["StandardDeviationMLE",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["StandardErrorOfSampleMean",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["MeanDeviation",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["MedianDeviation",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["InterquartileRange",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["QuartileDeviation",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], "\[Null]"}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S6.4.1"],

Cell["\<\
Univariate dispersion statistics applied to columns of a data matrix.\
\>", "Caption",
 CellTags->"S6.4.1"],

Cell[TextData[{
 "Note that the functions ",
 StyleBox["Variance", "MR"],
 " and ",
 StyleBox["StandardDeviation", "MR"],
 " are found in the kernel. This package does not need to be loaded to use \
them on data. "
}], "Text",
 CellTags->{"S6.4.1", "1.10"}],

Cell["\<\
This gives the variances of the stiffness and bending strength variables. \
\>", "MathCaption",
 CellTags->{"S6.4.1", "1.11"}],

Cell[CellGroupData[{

Cell["Variance[data]", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S6.4.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"124054.6724137931`", ",", "3.4863331540229884`*^6"}], 
  "}"}]], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S6.4.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[StyleBox["CentralMoment",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Skewness",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["PearsonSkewness1",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["PearsonSkewness2",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["QuartileSkewness",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Kurtosis",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["KurtosisExcess",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], "\[Null]"}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S6.4.1"],

Cell["\<\
Univariate shape statistics applied to columns of a data matrix.\
\>", "Caption",
 CellTags->"S6.4.1"],

Cell["\<\
The univariate shape statistics can be checked to determine whether the \
marginal distributions are normal. Since the marginal distributions must be \
normal for the data to be multinormal, univariate shape statistics can be \
instrumental in ruling out multinormality. \
\>", "Text",
 CellTags->{"S6.4.1", "1.12"}],

Cell["\<\
This gives skewness for the stiffness and bending strength variables. These \
values should be close to zero for symmetrically distributed data. \
\>", "MathCaption",
 CellTags->{"S6.4.1", "1.13"}],

Cell[CellGroupData[{

Cell["skewness = Skewness[data]", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S6.4.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.053283450897836225`", ",", 
   RowBox[{"-", "0.03125991302425026`"}]}], "}"}]], "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S6.4.1"]
}, Open  ]],

Cell[TextData[{
 "As ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["n",
     "TI"], "\[Rule]", "\[Infinity]"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", the distribution of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["n",
     "TI"], "/", "6", 
    SubscriptBox["\[Beta]", "1"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " (where ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Beta]", "1"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is univariate skewness squared) approaches ",
 Cell[BoxData[
  FormBox[
   SubsuperscriptBox["\[Chi]", "1", "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". At a 5% level of significance, the hypothesis that each marginal \
distribution is symmetrical is not rejected. "
}], "MathCaption",
 CellTags->{"S6.4.1", "1.14"}],

Cell[CellGroupData[{

Cell["\<\
Map[(30/6 #^2 > Quantile[ChiSquareDistribution[1], .95])&,
skewness]\
\>", "Input",
 CellLabel->"In[7]:= ",
 CellTags->"S6.4.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"False", ",", "False"}], "}"}]], "Output",
 CellLabel->"Out[7]= ",
 CellTags->"S6.4.1"]
}, Open  ]],

Cell["\<\
This gives kurtosis excess for the two variables. These values should be \
close to zero for normally distributed data. \
\>", "MathCaption",
 CellTags->{"S6.4.1", "1.15"}],

Cell[CellGroupData[{

Cell["kurtosisExcess = KurtosisExcess[data]", "Input",
 CellLabel->"In[8]:= ",
 CellTags->"S6.4.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.5451811760152787`"}], ",", 
   RowBox[{"-", "0.6189410573640424`"}]}], "}"}]], "Output",
 CellLabel->"Out[8]= ",
 CellTags->"S6.4.1"]
}, Open  ]],

Cell[TextData[{
 "As ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["n",
     "TI"], "\[Rule]", "\[Infinity]"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", the distribution of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SqrtBox[
     RowBox[{
      StyleBox["n",
       "TI"], "/", "24"}]], " ", 
    SubscriptBox["\[Gamma]", "2"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " (where ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Gamma]", "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is univariate kurtosis excess) approaches ",
 StyleBox["N", "TI"],
 "(0, 1). At a 5% level of significance, the hypothesis that each marginal \
distribution has a normal shape is not rejected. "
}], "MathCaption",
 CellTags->{"S6.4.1", "1.16"}],

Cell[CellGroupData[{

Cell["\<\
Map[(Abs[Sqrt[30/24] #] >
Quantile[NormalDistribution[0, 1], .975])&,
kurtosisExcess]\
\>", "Input",
 CellLabel->"In[9]:= ",
 CellTags->"S6.4.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"False", ",", "False"}], "}"}]], "Output",
 CellLabel->"Out[9]= ",
 CellTags->"S6.4.1"]
}, Open  ]],

Cell["\<\
According to the univariate shape statistics, the lumber data may follow a \
binormal distribution. \
\>", "Text",
 CellTags->{"S6.4.1", "1.17"}],

Cell["\<\
The coordinate\[Hyphen]wise multivariate extensions of univariate descriptive \
statistics are provided to simplify the transition between univariate and \
multivariate data analysis. However, much more information about the \
multivariate data structure can be learned from statistics that have no \
analogues in the univariate case. These statistics can be classified as \
estimating location, dispersion, association, and shape, and are discussed in \
the following sections. \
\>", "Text",
 CellTags->{"S6.4.1", "1.18"}],

Cell[CellGroupData[{

Cell["Multivariate Location", "Subsubsection",
 CellTags->{"S6.4.1", "1.19"}],

Cell["\<\
The coordinate\[Hyphen]wise mean is identical to the mean obtained when \
considering all variates simultaneously. Unfortunately, the coordinate\
\[Hyphen]wise definition is not the best multivariate generalization for \
other location measures such as the median, mode, and quantiles. This section \
describes various location measures requiring special definitions in the \
multivariate case. \
\>", "Text",
 CellTags->{"S6.4.1", "1.20"}],

Cell[TextData[{
 "It is well known that the mean has the disadvantage of being sensitive to \
outliers and other deviations from multinormality. The median is resistant to \
such deviations. Multivariate definitions of the median often make use of \
geometric ideas, such as minimizing the sum of simplex volumes or peeling \
convex hulls. The package ",
 StyleBox["DiscreteMath`ComputationalGeometry`", "MR"],
 " is automatically loaded to take advantage of some geometric functions \
defined therein. "
}], "Text",
 CellTags->{"S6.4.1", "1.21"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["SpatialMedian[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["multivariate median equal to the ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["p",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[
      "\[Hyphen]vector minimizing the sum of Euclidean distances between the \
vector and rows from the data matrix",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["SimplexMedian[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["multivariate median equal to the ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["p",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["\[Hyphen]vector minimizing the sum of volumes of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["p",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[
      " dimensional simplices the vector forms with all possible combinations \
of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["p",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" rows from the data matrix",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ConvexHullMedian[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "multivariate median computed by ordering the data according to the \
convex hull layer on which they lie, and taking the median to be the mean of \
the data lying on the innermost layer",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["MultivariateTrimmedMean[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["mean of remaining data when a fraction ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["f",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is removed, outermost points first",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["MultivariateMode[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "mode considering all variates simultaneously",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S6.4.1"],

Cell["Multivariate location statistics. ", "Caption",
 CellTags->"S6.4.1"],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["L",
     "TI"], "1"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " median or ",
 StyleBox["SpatialMedian", "MR"],
 " gives the ",
 Cell[BoxData[
  FormBox[
   StyleBox["p",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " dimensional point that minimizes the sum of the Euclidean distances \
between the point and the data. This estimator is orthogonally equivariant, \
but not affinely equivariant. "
}], "Text",
 CellTags->{"S6.4.1", "1.22"}],

Cell[TextData[{
 "The ",
 StyleBox["SimplexMedian", "MR"],
 " gives the ",
 Cell[BoxData[
  FormBox[
   StyleBox["p",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " dimensional point that, when joined with all possible combinations of ",
 Cell[BoxData[
  FormBox[
   StyleBox["p",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " points to form ",
 Cell[BoxData[
  FormBox[
   StyleBox["p",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " dimensional simplices, yields the smallest total simplex volume. In the \
case of the lumber data, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["n",
     "TI"], "=", "30"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["p",
     "TI"], "=", "2"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", so there are ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["n",
     "TI"], "!", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        StyleBox["n",
         "TI"], "-", 
        StyleBox["p",
         "TI"]}], ")"}], "!", 
      StyleBox["p",
       "TI"], "!"}], ")"}], "=", "435"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " simplices to consider. Ordering points according to the convex hull on \
which they lie is the basis for ",
 StyleBox["ConvexHullMedian", "MR"],
 ". Both ",
 StyleBox["SimplexMedian", "MR"],
 " and ",
 StyleBox["ConvexHullMedian", "MR"],
 " are affinely equivariant estimators. "
}], "Text",
 CellTags->{"S6.4.1", "1.23"}],

Cell["\<\
This vector minimizes the sum of the Euclidean distances between the vector \
and the data. \
\>", "MathCaption",
 CellTags->{"S6.4.1", "1.24"}],

Cell[CellGroupData[{

Cell["s = SpatialMedian[data]", "Input",
 CellLabel->"In[10]:= ",
 CellTags->"S6.4.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1757.5346066635323`", ",", "8062.875733671694`"}], "}"}]], "Output",\

 CellLabel->"Out[10]= ",
 CellTags->"S6.4.1"]
}, Open  ]],

Cell["\<\
This vector minimizes the sum of the volumes of all possible simplices having \
the vector as a vertex. \
\>", "MathCaption",
 CellTags->{"S6.4.1", "1.25"}],

Cell[CellGroupData[{

Cell["v = SimplexMedian[data]", "Input",
 CellLabel->"In[11]:= ",
 CellTags->"S6.4.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindMinimum", "::", "\<\"lstol\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"The line search decreased the step size to within \
tolerance specified by AccuracyGoal and PrecisionGoal but was unable to find \
a sufficient decrease in the function.  You may need more than \
\\!\\(MachinePrecision\\) digits of working precision to meet these \
tolerances.\"\>"}]], "Message",
 CellTags->"S6.4.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1804.0000000000032`", ",", "8364.999999999989`"}], "}"}]], "Output",\

 CellLabel->"Out[11]= ",
 CellTags->"S6.4.1"]
}, Open  ]],

Cell["\<\
This gives the median formed by peeling the convex layers of the data and \
taking the mean of the data lying on the innermost layer. \
\>", "MathCaption",
 CellTags->{"S6.4.1", "1.26"}],

Cell[CellGroupData[{

Cell["c = ConvexHullMedian[data]", "Input",
 CellLabel->"In[12]:= ",
 CellTags->"S6.4.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1791.3333333333333`", ",", "7982.333333333333`"}], "}"}]], "Output",\

 CellLabel->"Out[12]= ",
 CellTags->"S6.4.1"]
}, Open  ]],

Cell[TextData[{
 "This loads the ",
 StyleBox["TextListPlot", "MR"],
 " function. "
}], "MathCaption",
 CellTags->{"S6.4.1", "1.27"}],

Cell["<<Graphics`Graphics`", "Input",
 CellLabel->"In[13]:= ",
 CellTags->"S6.4.1"],

Cell["\<\
Here is a plot comparing the mean (M), the coordinate\[Hyphen]wise median \
(m), the median computed by minimizing the sum of Euclidean distances (s), \
the median computed by minimizing the sum of simplex volumes (v), the median \
computed by peeling convex hulls (c), and the data. If the data is \
contaminated with outliers, the mean will be a poor estimate of location. \
Here the data is well approximated by a binormal distribution, so all the \
location estimates are quite similar. \
\>", "MathCaption",
 CellTags->{"S6.4.1", "1.28"}],

Cell[CellGroupData[{

Cell["\<\
(labeled1 = Transpose[Append[Transpose[{M, m, s, v, c}],
                {\"M\", \"m\", \"s\", \"v\", \"c\"}]];
Show[
  TextListPlot[labeled1, DisplayFunction :> Identity],
  ListPlot[data, DisplayFunction :> Identity],
  DisplayFunction :> $DisplayFunction, AspectRatio -> 1,
  Ticks -> {{1200, 1600, 2000, 2400}, Automatic}])\
\>", "Input",
 CellLabel->"In[14]:= ",
 CellTags->"S6.4.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.721387 0.000668338 -0.478552 0.000120326 [
[.34795 -0.00975 -12 -9 ]
[.34795 -0.00975 12 0 ]
[.61529 -0.00975 -12 -9 ]
[.61529 -0.00975 12 0 ]
[.88262 -0.00975 -12 -9 ]
[.88262 -0.00975 12 0 ]
[.06812 .2434 -24 -4.5 ]
[.06812 .2434 0 4.5 ]
[.06812 .48406 -24 -4.5 ]
[.06812 .48406 0 4.5 ]
[.06812 .72471 -30 -4.5 ]
[.06812 .72471 0 4.5 ]
[.06812 .96536 -30 -4.5 ]
[.06812 .96536 0 4.5 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.34795 .00275 m
.34795 .009 L
s
[(1600)] .34795 -0.00975 0 1 Mshowa
.61529 .00275 m
.61529 .009 L
s
[(2000)] .61529 -0.00975 0 1 Mshowa
.88262 .00275 m
.88262 .009 L
s
[(2400)] .88262 -0.00975 0 1 Mshowa
0 .00275 m
1 .00275 L
s
.08062 .2434 m
.08687 .2434 L
s
[(6000)] .06812 .2434 1 0 Mshowa
.08062 .48406 m
.08687 .48406 L
s
[(8000)] .06812 .48406 1 0 Mshowa
.08062 .72471 m
.08687 .72471 L
s
[(10000)] .06812 .72471 1 0 Mshowa
.08062 .96536 m
.08687 .96536 L
s
[(12000)] .06812 .96536 1 0 Mshowa
.125 Mabswid
.08062 .06292 m
.08437 .06292 L
s
.08062 .12308 m
.08437 .12308 L
s
.08062 .18324 m
.08437 .18324 L
s
.08062 .30357 m
.08437 .30357 L
s
.08062 .36373 m
.08437 .36373 L
s
.08062 .42389 m
.08437 .42389 L
s
.08062 .54422 m
.08437 .54422 L
s
.08062 .60438 m
.08437 .60438 L
s
.08062 .66455 m
.08437 .66455 L
s
.08062 .78487 m
.08437 .78487 L
s
.08062 .84504 m
.08437 .84504 L
s
.08062 .9052 m
.08437 .9052 L
s
.25 Mabswid
.08062 0 m
.08062 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
gsave
.52206 .52667 -66 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(M) show
69.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.50769 .4858 -66 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(m) show
69.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.45324 .49162 -66 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(s) show
69.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.48429 .52798 -66 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(v) show
69.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.47583 .48193 -66 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(c) show
69.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.008 w
.10201 .02381 Mdot
.02381 .32186 Mdot
.7523 .43737 Mdot
.54645 .83469 Mdot
.56984 .82699 Mdot
.35597 .43918 Mdot
.34662 .3582 Mdot
.48429 .52798 Mdot
.44954 .66082 Mdot
.66007 .29274 Mdot
.85923 .76406 Mdot
.3787 .40224 Mdot
.33392 .50764 Mdot
.53509 .68969 Mdot
.46358 .76923 Mdot
.42281 .45385 Mdot
.56984 .34183 Mdot
.49499 .64132 Mdot
.54845 .29839 Mdot
.9 .73698 Mdot
.31988 .41355 Mdot
.26107 .43063 Mdot
.52038 .46396 Mdot
.33926 .52124 Mdot
.7543 .67165 Mdot
.27243 .27409 Mdot
.75297 .8117 Mdot
.83718 .17482 Mdot
.97619 .97619 Mdot
.83049 .73337 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S6.4.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[14]= ",
 CellTags->"S6.4.1"]
}, Open  ]],

Cell[TextData[{
 StyleBox["MultivariateTrimmedMean", "MR"],
 " gives an array of estimates ranging from the mean (no trimming) to the \
convex hull median (all outer convex layers trimmed). This plot shows trims \
of 20, 40, 60, and 80 percent, in comparison with the mean (M) and the convex \
hull median (c). "
}], "MathCaption",
 CellTags->{"S6.4.1", "1.29"}],

Cell[CellGroupData[{

Cell["\<\
(labeled2 = Join[ labeled1[[{1, 5}]],
   Map[Append[MultivariateTrimmedMean[data, #/10],
     ToString[#]]&, {2, 4, 6, 8}] ];
TextListPlot[labeled2, AspectRatio -> 1])\
\>", "Input",
 CellLabel->"In[15]:= ",
 CellTags->"S6.4.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-21.1472 0.0118186 -19.3511 0.00242722 [
[.36261 .05419 -12 -9 ]
[.36261 .05419 12 0 ]
[.59898 .05419 -12 -9 ]
[.59898 .05419 12 0 ]
[.83535 .05419 -12 -9 ]
[.83535 .05419 12 0 ]
[.11374 .30941 -24 -4.5 ]
[.11374 .30941 0 4.5 ]
[.11374 .55213 -24 -4.5 ]
[.11374 .55213 0 4.5 ]
[.11374 .79486 -24 -4.5 ]
[.11374 .79486 0 4.5 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.36261 .06669 m
.36261 .07294 L
s
[(1820)] .36261 .05419 0 1 Mshowa
.59898 .06669 m
.59898 .07294 L
s
[(1840)] .59898 .05419 0 1 Mshowa
.83535 .06669 m
.83535 .07294 L
s
[(1860)] .83535 .05419 0 1 Mshowa
.125 Mabswid
.18533 .06669 m
.18533 .07044 L
s
.24442 .06669 m
.24442 .07044 L
s
.30352 .06669 m
.30352 .07044 L
s
.4217 .06669 m
.4217 .07044 L
s
.48079 .06669 m
.48079 .07044 L
s
.53989 .06669 m
.53989 .07044 L
s
.65807 .06669 m
.65807 .07044 L
s
.71717 .06669 m
.71717 .07044 L
s
.77626 .06669 m
.77626 .07044 L
s
.06714 .06669 m
.06714 .07044 L
s
.00805 .06669 m
.00805 .07044 L
s
.89445 .06669 m
.89445 .07044 L
s
.95354 .06669 m
.95354 .07044 L
s
.25 Mabswid
0 .06669 m
1 .06669 L
s
.12624 .30941 m
.13249 .30941 L
s
[(8100)] .11374 .30941 1 0 Mshowa
.12624 .55213 m
.13249 .55213 L
s
[(8200)] .11374 .55213 1 0 Mshowa
.12624 .79486 m
.13249 .79486 L
s
[(8300)] .11374 .79486 1 0 Mshowa
.125 Mabswid
.12624 .11523 m
.12999 .11523 L
s
.12624 .16378 m
.12999 .16378 L
s
.12624 .21232 m
.12999 .21232 L
s
.12624 .26087 m
.12999 .26087 L
s
.12624 .35796 m
.12999 .35796 L
s
.12624 .4065 m
.12999 .4065 L
s
.12624 .45505 m
.12999 .45505 L
s
.12624 .50359 m
.12999 .50359 L
s
.12624 .60068 m
.12999 .60068 L
s
.12624 .64922 m
.12999 .64922 L
s
.12624 .69777 m
.12999 .69777 L
s
.12624 .74631 m
.12999 .74631 L
s
.12624 .01815 m
.12999 .01815 L
s
.12624 .8434 m
.12999 .8434 L
s
.12624 .89195 m
.12999 .89195 L
s
.12624 .94049 m
.12999 .94049 L
s
.12624 .98903 m
.12999 .98903 L
s
.25 Mabswid
.12624 0 m
.12624 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
gsave
.84126 .92625 -66 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(M) show
69.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.02381 .02381 -66 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(c) show
69.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.97619 .97619 -66 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
69.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.321 .65337 -66 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(4) show
69.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.25624 .39391 -66 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(6) show
69.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.25545 .15476 -66 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(8) show
69.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S6.4.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[15]= ",
 CellTags->"S6.4.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["Ellipsoid[{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] , ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], 
         StyleBox["p",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["r",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] , ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["r",
          "TI"], 
         StyleBox["p",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["d",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] , ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["d",
          "TI"], 
         StyleBox["p",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["a ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["p",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["\[Hyphen]dimensional ellipsoid, centered at ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] , ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], 
         StyleBox["p",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", with radii ", "TR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["r",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] , ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["r",
          "TI"], 
         StyleBox["p",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", where ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["r",
          "TI"], 
         StyleBox["i",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is the radius in direction ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["d",
          "TI"], 
         StyleBox["i",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Polytope[{{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "11"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] , ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], 
         RowBox[{"1", 
          StyleBox["p",
           "TI"]}]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, \[Ellipsis] , {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], 
         RowBox[{
          StyleBox["m",
           "TI"], "1"}]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] , ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], 
         StyleBox[
          RowBox[{"m", "p"}],
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}}, ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["conn", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["a ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["p",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["\[Hyphen]dimensional polytope with ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["m",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" vertices, where the vertex connectivity is specified by ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["conn", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S6.4.1"],

Cell["Geometric primitives. ", "Caption",
 CellTags->"S6.4.1"],

Cell[TextData[{
 "In the case of a univariate sample, the ",
 Cell[BoxData[
  FormBox[
   StyleBox["q",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " quantile is that number below which a fraction ",
 Cell[BoxData[
  FormBox[
   StyleBox["q",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " of the sample lies. In the case of a multivariate sample and an associated \
estimate of the underlying population location, we can take the ",
 Cell[BoxData[
  FormBox[
   StyleBox["q",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " quantile to be that locus, centered on the location estimate, within which \
a fraction ",
 Cell[BoxData[
  FormBox[
   StyleBox["q",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " of the sample lies. This leads to different definitions of a multivariate \
quantile, depending on how the location estimate and the quantile locus are \
defined. For example, the locus can be an ellipsoid centered on the mean, or \
a convex polytope centered on the median. "
}], "Text",
 CellTags->{"S6.4.1", "1.30"}],

Cell[TextData[{
 "This package defines geometric primitives for representing multidimensional \
ellipsoids and polytopes. The ",
 StyleBox["Ellipsoid", "MR"],
 " and ",
 StyleBox["Polytope", "MR"],
 " primitives can be plotted using ",
 StyleBox["Graphics", "MR"],
 " and ",
 StyleBox["Show", "MR"],
 " for ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["p",
     "TI"], "=", "2"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". The results of the location statistics ",
 StyleBox["EllipsoidQuantile", "MR"],
 " and ",
 StyleBox["EllipsoidQuartiles", "MR"],
 " are expressed in terms of ",
 StyleBox["Ellipsoid", "MR"],
 ". The results of the location statistics ",
 StyleBox["PolytopeQuantile", "MR"],
 " and ",
 StyleBox["PolytopeQuartiles", "MR"],
 " are expressed in terms of ",
 StyleBox["Polytope", "MR"],
 ". "
}], "Text",
 CellTags->{"S6.4.1", "1.31"}],

Cell[TextData[{
 "The third argument of ",
 StyleBox["Ellipsoid", "MR"],
 ", specifying the directions of the semi\[Hyphen]axes, is automatically \
dropped when the semi\[Hyphen]axes lie along the coordinate axes. The radii \
are reordered if necessary. "
}], "MathCaption",
 CellTags->{"S6.4.1", "1.32"}],

Cell[CellGroupData[{

Cell["\<\
Ellipsoid[{1, 2, 3}, {4, 5, 6},
        {{0, 1, 0}, {1, 0, 0}, {0, 0, 1}}]\
\>", "Input",
 CellLabel->"In[16]:= ",
 CellTags->"S6.4.1"],

Cell[BoxData[
 RowBox[{"Ellipsoid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "4", ",", "6"}], "}"}]}], "]"}]], "Output",
 CellLabel->"Out[16]= ",
 CellTags->"S6.4.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["EllipsoidQuantile[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["q", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["p",
          "TI"], "-", "1"}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" dimensional locus of the ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["q",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SuperscriptBox["\[Null]", "th"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" quantile of the ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["p",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[
      "\[Hyphen]variate data, where the data have been ordered using \
ellipsoids centered on the mean",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["EllipsoidQuartiles[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["list of the ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["p",
          "TI"], "-", "1"}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" dimensional loci of the quartiles of the ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["p",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[
      "\[Hyphen]variate data, where the data have been ordered using \
ellipsoids centered on the mean",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["PolytopeQuantile[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["q", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["p",
          "TI"], "-", "1"}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" dimensional locus of the ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["q",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SuperscriptBox["\[Null]", "th"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" quantile of the ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["p",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[
      "\[Hyphen]variate data, where the data have been ordered using convex \
hulls centered on the median",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["PolytopeQuartiles[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["list of the ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["p",
          "TI"], "-", "1"}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" dimensional loci of the quartiles of the ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["p",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[
      "\[Hyphen]variate data, where the data have been ordered using convex \
hulls centered on the median",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S6.4.1"],

Cell["More multivariate location statistics. ", "Caption",
 CellTags->"S6.4.1"],

Cell["\<\
This gives the minimum and maximum values for the individual stiffness and \
strength variables. \
\>", "MathCaption",
 CellTags->{"S6.4.1", "1.33"}],

Cell[CellGroupData[{

Cell["\<\
({stiffness, strength} = Transpose[data];
{{minx, maxx}, {miny, maxy}} =
Map[{Min[#], Max[#]}&, {stiffness, strength}])\
\>", "Input",
 CellLabel->"In[17]:= ",
 CellTags->"S6.4.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1115.`", ",", "2540.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4175.`", ",", "12090.`"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[17]= ",
 CellTags->"S6.4.1"]
}, Open  ]],

Cell["\<\
Here is a plot of the quartile contours of the data, assuming the \
distribution is elliptically contoured. \
\>", "MathCaption",
 CellTags->{"S6.4.1", "1.34"}],

Cell[CellGroupData[{

Cell["\<\
(q = EllipsoidQuartiles[data];
Show[Graphics[q], Frame->True, AspectRatio->1,
        PlotRange -> {{minx, maxx}, {miny, maxy}},
        FrameTicks -> {{1200, 1600, 2000, 2400},
        Automatic}])\
\>", "Input",
 CellLabel->"In[18]:= ",
 CellTags->"S6.4.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.782456 0.000701754 -0.527479 0.000126342 [
[.05965 -0.0125 -12 -9 ]
[.05965 -0.0125 12 0 ]
[.34035 -0.0125 -12 -9 ]
[.34035 -0.0125 12 0 ]
[.62105 -0.0125 -12 -9 ]
[.62105 -0.0125 12 0 ]
[.90175 -0.0125 -12 -9 ]
[.90175 -0.0125 12 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .10423 -24 -4.5 ]
[-0.0125 .10423 0 4.5 ]
[-0.0125 .23057 -24 -4.5 ]
[-0.0125 .23057 0 4.5 ]
[-0.0125 .35692 -24 -4.5 ]
[-0.0125 .35692 0 4.5 ]
[-0.0125 .48326 -24 -4.5 ]
[-0.0125 .48326 0 4.5 ]
[-0.0125 .6096 -24 -4.5 ]
[-0.0125 .6096 0 4.5 ]
[-0.0125 .73594 -30 -4.5 ]
[-0.0125 .73594 0 4.5 ]
[-0.0125 .86229 -30 -4.5 ]
[-0.0125 .86229 0 4.5 ]
[-0.0125 .98863 -30 -4.5 ]
[-0.0125 .98863 0 4.5 ]
[ 0 0 -0.125 0 ]
[.05965 1.0125 -12 0 ]
[.05965 1.0125 12 9 ]
[.34035 1.0125 -12 0 ]
[.34035 1.0125 12 9 ]
[.62105 1.0125 -12 0 ]
[.62105 1.0125 12 9 ]
[.90175 1.0125 -12 0 ]
[.90175 1.0125 12 9 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.05965 0 m
.05965 .00625 L
s
[(1200)] .05965 -0.0125 0 1 Mshowa
.34035 0 m
.34035 .00625 L
s
[(1600)] .34035 -0.0125 0 1 Mshowa
.62105 0 m
.62105 .00625 L
s
[(2000)] .62105 -0.0125 0 1 Mshowa
.90175 0 m
.90175 .00625 L
s
[(2400)] .90175 -0.0125 0 1 Mshowa
0 0 m
1 0 L
s
0 .10423 m
.00625 .10423 L
s
[(5000)] -0.0125 .10423 1 0 Mshowa
0 .23057 m
.00625 .23057 L
s
[(6000)] -0.0125 .23057 1 0 Mshowa
0 .35692 m
.00625 .35692 L
s
[(7000)] -0.0125 .35692 1 0 Mshowa
0 .48326 m
.00625 .48326 L
s
[(8000)] -0.0125 .48326 1 0 Mshowa
0 .6096 m
.00625 .6096 L
s
[(9000)] -0.0125 .6096 1 0 Mshowa
0 .73594 m
.00625 .73594 L
s
[(10000)] -0.0125 .73594 1 0 Mshowa
0 .86229 m
.00625 .86229 L
s
[(11000)] -0.0125 .86229 1 0 Mshowa
0 .98863 m
.00625 .98863 L
s
[(12000)] -0.0125 .98863 1 0 Mshowa
.125 Mabswid
0 .1295 m
.00375 .1295 L
s
0 .15477 m
.00375 .15477 L
s
0 .18004 m
.00375 .18004 L
s
0 .20531 m
.00375 .20531 L
s
0 .25584 m
.00375 .25584 L
s
0 .28111 m
.00375 .28111 L
s
0 .30638 m
.00375 .30638 L
s
0 .33165 m
.00375 .33165 L
s
0 .38219 m
.00375 .38219 L
s
0 .40745 m
.00375 .40745 L
s
0 .43272 m
.00375 .43272 L
s
0 .45799 m
.00375 .45799 L
s
0 .50853 m
.00375 .50853 L
s
0 .5338 m
.00375 .5338 L
s
0 .55907 m
.00375 .55907 L
s
0 .58433 m
.00375 .58433 L
s
0 .63487 m
.00375 .63487 L
s
0 .66014 m
.00375 .66014 L
s
0 .68541 m
.00375 .68541 L
s
0 .71068 m
.00375 .71068 L
s
0 .76121 m
.00375 .76121 L
s
0 .78648 m
.00375 .78648 L
s
0 .81175 m
.00375 .81175 L
s
0 .83702 m
.00375 .83702 L
s
0 .88756 m
.00375 .88756 L
s
0 .91282 m
.00375 .91282 L
s
0 .93809 m
.00375 .93809 L
s
0 .96336 m
.00375 .96336 L
s
0 .07896 m
.00375 .07896 L
s
0 .0537 m
.00375 .0537 L
s
0 .02843 m
.00375 .02843 L
s
0 .00316 m
.00375 .00316 L
s
.25 Mabswid
0 0 m
0 1 L
s
.05965 .99375 m
.05965 1 L
s
[(1200)] .05965 1.0125 0 -1 Mshowa
.34035 .99375 m
.34035 1 L
s
[(1600)] .34035 1.0125 0 -1 Mshowa
.62105 .99375 m
.62105 1 L
s
[(2000)] .62105 1.0125 0 -1 Mshowa
.90175 .99375 m
.90175 1 L
s
[(2400)] .90175 1.0125 0 -1 Mshowa
0 1 m
1 1 L
s
.99375 .10423 m
1 .10423 L
s
.99375 .23057 m
1 .23057 L
s
.99375 .35692 m
1 .35692 L
s
.99375 .48326 m
1 .48326 L
s
.99375 .6096 m
1 .6096 L
s
.99375 .73594 m
1 .73594 L
s
.99375 .86229 m
1 .86229 L
s
.99375 .98863 m
1 .98863 L
s
.125 Mabswid
.99625 .1295 m
1 .1295 L
s
.99625 .15477 m
1 .15477 L
s
.99625 .18004 m
1 .18004 L
s
.99625 .20531 m
1 .20531 L
s
.99625 .25584 m
1 .25584 L
s
.99625 .28111 m
1 .28111 L
s
.99625 .30638 m
1 .30638 L
s
.99625 .33165 m
1 .33165 L
s
.99625 .38219 m
1 .38219 L
s
.99625 .40745 m
1 .40745 L
s
.99625 .43272 m
1 .43272 L
s
.99625 .45799 m
1 .45799 L
s
.99625 .50853 m
1 .50853 L
s
.99625 .5338 m
1 .5338 L
s
.99625 .55907 m
1 .55907 L
s
.99625 .58433 m
1 .58433 L
s
.99625 .63487 m
1 .63487 L
s
.99625 .66014 m
1 .66014 L
s
.99625 .68541 m
1 .68541 L
s
.99625 .71068 m
1 .71068 L
s
.99625 .76121 m
1 .76121 L
s
.99625 .78648 m
1 .78648 L
s
.99625 .81175 m
1 .81175 L
s
.99625 .83702 m
1 .83702 L
s
.99625 .88756 m
1 .88756 L
s
.99625 .91282 m
1 .91282 L
s
.99625 .93809 m
1 .93809 L
s
.99625 .96336 m
1 .96336 L
s
.99625 .07896 m
1 .07896 L
s
.99625 .0537 m
1 .0537 L
s
.99625 .02843 m
1 .02843 L
s
.99625 .00316 m
1 .00316 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 Mabswid
.4059 .32947 m
.40701 .32945 L
.40801 .32945 L
.40919 .32944 L
.4103 .32945 L
.41133 .32947 L
.41228 .32948 L
.41334 .32951 L
.41446 .32955 L
.41681 .32965 L
.41902 .32978 L
.42413 .33018 L
.42915 .33072 L
.43381 .33134 L
.44448 .33318 L
.45546 .33565 L
.46769 .33905 L
.49047 .34706 L
.53649 .36949 L
.58021 .39845 L
.62377 .43565 L
.66089 .47599 L
.69043 .51718 L
.70265 .53836 L
.71372 .56146 L
.72182 .58303 L
.72465 .59247 L
.72716 .60256 L
.72828 .60798 L
.72916 .61293 L
.72983 .61752 L
.73043 .62251 L
.73063 .62463 L
.73081 .6269 L
.73094 .62885 L
.73105 .63097 L
.7311 .63205 L
.73114 .63321 L
.73116 .63385 L
.73117 .63443 L
.73119 .63555 L
.7312 .63658 L
.7312 .63769 L
.73119 .63873 L
.73117 .63968 L
.73115 .6408 L
.73111 .64186 L
.73102 .64384 L
.7309 .64594 L
.73071 .64821 L
Mistroke
.73028 .65223 L
.72976 .65589 L
.72812 .66398 L
.72694 .66833 L
.7257 .67216 L
.72301 .67896 L
.71959 .68571 L
.71519 .69258 L
.71055 .69838 L
.70561 .70344 L
.69978 .70833 L
.6879 .71574 L
.68057 .71905 L
.67206 .72197 L
.66797 .72307 L
.66352 .72408 L
.65923 .72486 L
.65522 .72545 L
.65116 .72592 L
.64906 .7261 L
.6468 .72627 L
.6445 .7264 L
.64347 .72644 L
.64235 .72648 L
.64165 .7265 L
.64102 .72652 L
.64042 .72653 L
.63975 .72654 L
.6386 .72656 L
.63738 .72656 L
.63622 .72655 L
.63511 .72654 L
.63411 .72652 L
.63301 .72649 L
.63182 .72645 L
.63055 .7264 L
.62825 .72628 L
.62411 .72599 L
.61947 .72555 L
.6145 .72494 L
.60919 .72415 L
.59952 .72235 L
.57705 .71647 L
.55514 .70866 L
.53441 .69951 L
.49024 .67448 L
.44497 .64066 L
.40511 .60261 L
.37201 .56264 L
.35771 .54171 L
Mistroke
.34412 .5185 L
.33337 .49633 L
.32564 .47641 L
.31983 .4564 L
.31761 .4457 L
.31676 .44047 L
.31614 .4358 L
.31566 .43109 L
.31549 .42895 L
.31535 .42671 L
.31529 .42558 L
.31523 .42434 L
.31519 .4232 L
.31516 .42217 L
.31515 .42159 L
.31514 .42096 L
.31513 .42029 L
.31512 .41966 L
.31512 .41908 L
.31512 .41845 L
.31513 .41734 L
.31514 .41633 L
.31516 .4154 L
.31519 .41438 L
.31524 .41332 L
.31533 .41153 L
.31545 .4096 L
.31585 .4053 L
.31636 .40137 L
.31707 .3972 L
.31801 .39279 L
.32018 .3851 L
.32288 .37802 L
.32585 .37187 L
.33364 .36013 L
.33896 .35425 L
.3445 .34927 L
.35084 .34464 L
.35738 .3408 L
.36429 .33755 L
.37093 .33507 L
.37859 .33287 L
.38266 .33196 L
.38717 .33112 L
.39147 .3305 L
.39551 .33005 L
.39944 .32974 L
.40144 .32963 L
.40365 .32953 L
.40474 .3295 L
Mistroke
.4059 .32947 L
Mfstroke
.36477 .25984 m
.36627 .25982 L
.36763 .25981 L
.36921 .25981 L
.37071 .25981 L
.37211 .25983 L
.3734 .25986 L
.37482 .2599 L
.37634 .25995 L
.37951 .26008 L
.3825 .26026 L
.3894 .2608 L
.39618 .26153 L
.40247 .26236 L
.41689 .26485 L
.43172 .26819 L
.44823 .27278 L
.479 .2836 L
.54117 .3139 L
.60021 .35302 L
.65906 .40326 L
.7092 .45775 L
.74909 .51338 L
.76561 .54199 L
.78055 .5732 L
.7915 .60234 L
.79532 .61509 L
.79871 .62871 L
.80022 .63603 L
.8014 .64272 L
.80232 .64891 L
.80312 .65565 L
.80339 .65852 L
.80364 .66159 L
.80382 .66422 L
.80397 .66708 L
.80403 .66855 L
.80408 .67011 L
.80411 .67097 L
.80412 .67175 L
.80415 .67327 L
.80416 .67466 L
.80416 .67616 L
.80415 .67756 L
.80413 .67885 L
.80409 .68037 L
.80405 .6818 L
.80393 .68446 L
.80376 .68731 L
.80351 .69037 L
Mistroke
.80293 .6958 L
.80222 .70074 L
.80001 .71168 L
.79841 .71755 L
.79674 .72272 L
.7931 .73191 L
.78849 .74102 L
.78254 .7503 L
.77627 .75814 L
.7696 .76497 L
.76172 .77158 L
.74567 .78158 L
.73578 .78605 L
.72428 .79 L
.71876 .79149 L
.71275 .79284 L
.70696 .79391 L
.70154 .79471 L
.69605 .79533 L
.69322 .79558 L
.69017 .7958 L
.68706 .79598 L
.68567 .79604 L
.68415 .7961 L
.68321 .79612 L
.68235 .79615 L
.68154 .79616 L
.68065 .79618 L
.67909 .79619 L
.67744 .7962 L
.67587 .79619 L
.67437 .79617 L
.67302 .79615 L
.67154 .79611 L
.66994 .79606 L
.66822 .79599 L
.66511 .79583 L
.65952 .79543 L
.65325 .79484 L
.64654 .79402 L
.63936 .79295 L
.6263 .79051 L
.59595 .78257 L
.56636 .77202 L
.53836 .75966 L
.4787 .72586 L
.41755 .68017 L
.3637 .62877 L
.319 .57479 L
.29968 .54652 L
Mistroke
.28132 .51516 L
.26681 .48523 L
.25636 .45831 L
.24852 .43129 L
.24552 .41684 L
.24437 .40977 L
.24354 .40346 L
.24289 .3971 L
.24266 .39421 L
.24246 .39119 L
.24238 .38966 L
.24231 .38798 L
.24225 .38645 L
.24221 .38505 L
.24219 .38427 L
.24218 .38341 L
.24216 .38251 L
.24216 .38166 L
.24215 .38087 L
.24215 .38003 L
.24217 .37853 L
.24219 .37716 L
.24221 .3759 L
.24226 .37453 L
.24231 .37309 L
.24243 .37069 L
.24261 .36808 L
.24314 .36226 L
.24383 .35696 L
.24479 .35133 L
.24606 .34537 L
.249 .33499 L
.25263 .32542 L
.25665 .31711 L
.26717 .30126 L
.27435 .2933 L
.28183 .28659 L
.29041 .28034 L
.29924 .27514 L
.30857 .27075 L
.31754 .2674 L
.32789 .26443 L
.33339 .2632 L
.33948 .26207 L
.34529 .26123 L
.35074 .26063 L
.35604 .26021 L
.35875 .26005 L
.36174 .25992 L
.3632 .25988 L
Mistroke
.36477 .25984 L
Mfstroke
.31645 .17803 m
.3184 .178 L
.32018 .17798 L
.32224 .17798 L
.3242 .17799 L
.32602 .17802 L
.32771 .17805 L
.32956 .1781 L
.33154 .17816 L
.33568 .17834 L
.33959 .17857 L
.34859 .17928 L
.35744 .18023 L
.36564 .18132 L
.38446 .18457 L
.40382 .18893 L
.42537 .19491 L
.46553 .20903 L
.54666 .24858 L
.62372 .29963 L
.70053 .3652 L
.76596 .43632 L
.81803 .50892 L
.83958 .54626 L
.85908 .58699 L
.87337 .62501 L
.87836 .64165 L
.88278 .65943 L
.88475 .66899 L
.8863 .67772 L
.88749 .6858 L
.88853 .6946 L
.88889 .69834 L
.88922 .70234 L
.88945 .70578 L
.88964 .70951 L
.88972 .71143 L
.88979 .71347 L
.88982 .71459 L
.88984 .71561 L
.88988 .71759 L
.88989 .7194 L
.88989 .72136 L
.88988 .72319 L
.88985 .72488 L
.88981 .72685 L
.88975 .72872 L
.88959 .7322 L
.88936 .73591 L
.88904 .73991 L
Mistroke
.88828 .747 L
.88736 .75344 L
.88447 .76771 L
.88239 .77538 L
.88021 .78212 L
.87546 .79412 L
.86944 .80601 L
.86167 .81812 L
.85349 .82835 L
.84478 .83727 L
.8345 .8459 L
.81356 .85895 L
.80065 .86478 L
.78564 .86993 L
.77844 .87187 L
.77059 .87365 L
.76304 .87504 L
.75596 .87608 L
.7488 .87689 L
.74511 .87722 L
.74112 .87751 L
.73707 .87774 L
.73525 .87782 L
.73327 .87789 L
.73205 .87793 L
.73092 .87795 L
.72986 .87798 L
.7287 .878 L
.72667 .87802 L
.72451 .87802 L
.72246 .87801 L
.7205 .87799 L
.71874 .87796 L
.71682 .87791 L
.71472 .87784 L
.71248 .87775 L
.70843 .87754 L
.70112 .87703 L
.69295 .87625 L
.68418 .87518 L
.67481 .87378 L
.65777 .8706 L
.61815 .86023 L
.57954 .84647 L
.543 .83034 L
.46514 .78622 L
.38533 .72659 L
.31506 .65952 L
.25672 .58906 L
.23149 .55216 L
Mistroke
.20754 .51125 L
.1886 .47218 L
.17496 .43705 L
.16473 .40179 L
.16081 .38292 L
.15931 .3737 L
.15823 .36546 L
.15738 .35716 L
.15708 .35339 L
.15682 .34945 L
.15672 .34745 L
.15662 .34526 L
.15655 .34326 L
.1565 .34144 L
.15647 .34041 L
.15645 .3393 L
.15644 .33813 L
.15643 .33702 L
.15642 .33598 L
.15642 .33489 L
.15644 .33293 L
.15646 .33114 L
.1565 .3295 L
.15655 .32771 L
.15663 .32583 L
.15679 .32269 L
.15701 .31928 L
.15771 .31169 L
.15861 .30478 L
.15986 .29742 L
.16151 .28965 L
.16535 .2761 L
.1701 .26362 L
.17534 .25277 L
.18907 .23208 L
.19844 .2217 L
.20821 .21293 L
.2194 .20477 L
.23092 .198 L
.24311 .19227 L
.25481 .1879 L
.26831 .18402 L
.27549 .18241 L
.28344 .18094 L
.29102 .17984 L
.29813 .17905 L
.30506 .1785 L
.30859 .1783 L
.31249 .17813 L
.3144 .17807 L
Mistroke
.31645 .17803 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S6.4.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[18]= ",
 CellTags->"S6.4.1"]
}, Open  ]],

Cell["\<\
Here is a plot of the quartile contours of the data, found by linear \
interpolation between convex layers of the data. \
\>", "MathCaption",
 CellTags->{"S6.4.1", "1.35"}],

Cell[CellGroupData[{

Cell["\<\
(q = PolytopeQuartiles[data];
Show[Graphics[q], Frame->True, AspectRatio->1,
        PlotRange -> {{minx, maxx}, {miny, maxy}},
        FrameTicks -> {{1200, 1600, 2000, 2400},
        Automatic}])\
\>", "Input",
 CellLabel->"In[19]:= ",
 CellTags->"S6.4.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.782456 0.000701754 -0.527479 0.000126342 [
[.05965 -0.0125 -12 -9 ]
[.05965 -0.0125 12 0 ]
[.34035 -0.0125 -12 -9 ]
[.34035 -0.0125 12 0 ]
[.62105 -0.0125 -12 -9 ]
[.62105 -0.0125 12 0 ]
[.90175 -0.0125 -12 -9 ]
[.90175 -0.0125 12 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .10423 -24 -4.5 ]
[-0.0125 .10423 0 4.5 ]
[-0.0125 .23057 -24 -4.5 ]
[-0.0125 .23057 0 4.5 ]
[-0.0125 .35692 -24 -4.5 ]
[-0.0125 .35692 0 4.5 ]
[-0.0125 .48326 -24 -4.5 ]
[-0.0125 .48326 0 4.5 ]
[-0.0125 .6096 -24 -4.5 ]
[-0.0125 .6096 0 4.5 ]
[-0.0125 .73594 -30 -4.5 ]
[-0.0125 .73594 0 4.5 ]
[-0.0125 .86229 -30 -4.5 ]
[-0.0125 .86229 0 4.5 ]
[-0.0125 .98863 -30 -4.5 ]
[-0.0125 .98863 0 4.5 ]
[ 0 0 -0.125 0 ]
[.05965 1.0125 -12 0 ]
[.05965 1.0125 12 9 ]
[.34035 1.0125 -12 0 ]
[.34035 1.0125 12 9 ]
[.62105 1.0125 -12 0 ]
[.62105 1.0125 12 9 ]
[.90175 1.0125 -12 0 ]
[.90175 1.0125 12 9 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.05965 0 m
.05965 .00625 L
s
[(1200)] .05965 -0.0125 0 1 Mshowa
.34035 0 m
.34035 .00625 L
s
[(1600)] .34035 -0.0125 0 1 Mshowa
.62105 0 m
.62105 .00625 L
s
[(2000)] .62105 -0.0125 0 1 Mshowa
.90175 0 m
.90175 .00625 L
s
[(2400)] .90175 -0.0125 0 1 Mshowa
0 0 m
1 0 L
s
0 .10423 m
.00625 .10423 L
s
[(5000)] -0.0125 .10423 1 0 Mshowa
0 .23057 m
.00625 .23057 L
s
[(6000)] -0.0125 .23057 1 0 Mshowa
0 .35692 m
.00625 .35692 L
s
[(7000)] -0.0125 .35692 1 0 Mshowa
0 .48326 m
.00625 .48326 L
s
[(8000)] -0.0125 .48326 1 0 Mshowa
0 .6096 m
.00625 .6096 L
s
[(9000)] -0.0125 .6096 1 0 Mshowa
0 .73594 m
.00625 .73594 L
s
[(10000)] -0.0125 .73594 1 0 Mshowa
0 .86229 m
.00625 .86229 L
s
[(11000)] -0.0125 .86229 1 0 Mshowa
0 .98863 m
.00625 .98863 L
s
[(12000)] -0.0125 .98863 1 0 Mshowa
.125 Mabswid
0 .1295 m
.00375 .1295 L
s
0 .15477 m
.00375 .15477 L
s
0 .18004 m
.00375 .18004 L
s
0 .20531 m
.00375 .20531 L
s
0 .25584 m
.00375 .25584 L
s
0 .28111 m
.00375 .28111 L
s
0 .30638 m
.00375 .30638 L
s
0 .33165 m
.00375 .33165 L
s
0 .38219 m
.00375 .38219 L
s
0 .40745 m
.00375 .40745 L
s
0 .43272 m
.00375 .43272 L
s
0 .45799 m
.00375 .45799 L
s
0 .50853 m
.00375 .50853 L
s
0 .5338 m
.00375 .5338 L
s
0 .55907 m
.00375 .55907 L
s
0 .58433 m
.00375 .58433 L
s
0 .63487 m
.00375 .63487 L
s
0 .66014 m
.00375 .66014 L
s
0 .68541 m
.00375 .68541 L
s
0 .71068 m
.00375 .71068 L
s
0 .76121 m
.00375 .76121 L
s
0 .78648 m
.00375 .78648 L
s
0 .81175 m
.00375 .81175 L
s
0 .83702 m
.00375 .83702 L
s
0 .88756 m
.00375 .88756 L
s
0 .91282 m
.00375 .91282 L
s
0 .93809 m
.00375 .93809 L
s
0 .96336 m
.00375 .96336 L
s
0 .07896 m
.00375 .07896 L
s
0 .0537 m
.00375 .0537 L
s
0 .02843 m
.00375 .02843 L
s
0 .00316 m
.00375 .00316 L
s
.25 Mabswid
0 0 m
0 1 L
s
.05965 .99375 m
.05965 1 L
s
[(1200)] .05965 1.0125 0 -1 Mshowa
.34035 .99375 m
.34035 1 L
s
[(1600)] .34035 1.0125 0 -1 Mshowa
.62105 .99375 m
.62105 1 L
s
[(2000)] .62105 1.0125 0 -1 Mshowa
.90175 .99375 m
.90175 1 L
s
[(2400)] .90175 1.0125 0 -1 Mshowa
0 1 m
1 1 L
s
.99375 .10423 m
1 .10423 L
s
.99375 .23057 m
1 .23057 L
s
.99375 .35692 m
1 .35692 L
s
.99375 .48326 m
1 .48326 L
s
.99375 .6096 m
1 .6096 L
s
.99375 .73594 m
1 .73594 L
s
.99375 .86229 m
1 .86229 L
s
.99375 .98863 m
1 .98863 L
s
.125 Mabswid
.99625 .1295 m
1 .1295 L
s
.99625 .15477 m
1 .15477 L
s
.99625 .18004 m
1 .18004 L
s
.99625 .20531 m
1 .20531 L
s
.99625 .25584 m
1 .25584 L
s
.99625 .28111 m
1 .28111 L
s
.99625 .30638 m
1 .30638 L
s
.99625 .33165 m
1 .33165 L
s
.99625 .38219 m
1 .38219 L
s
.99625 .40745 m
1 .40745 L
s
.99625 .43272 m
1 .43272 L
s
.99625 .45799 m
1 .45799 L
s
.99625 .50853 m
1 .50853 L
s
.99625 .5338 m
1 .5338 L
s
.99625 .55907 m
1 .55907 L
s
.99625 .58433 m
1 .58433 L
s
.99625 .63487 m
1 .63487 L
s
.99625 .66014 m
1 .66014 L
s
.99625 .68541 m
1 .68541 L
s
.99625 .71068 m
1 .71068 L
s
.99625 .76121 m
1 .76121 L
s
.99625 .78648 m
1 .78648 L
s
.99625 .81175 m
1 .81175 L
s
.99625 .83702 m
1 .83702 L
s
.99625 .88756 m
1 .88756 L
s
.99625 .91282 m
1 .91282 L
s
.99625 .93809 m
1 .93809 L
s
.99625 .96336 m
1 .96336 L
s
.99625 .07896 m
1 .07896 L
s
.99625 .0537 m
1 .0537 L
s
.99625 .02843 m
1 .02843 L
s
.99625 .00316 m
1 .00316 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 Mabswid
.74039 .66209 m
.50341 .63763 L
.49325 .63605 L
.35692 .43904 L
.36487 .42291 L
.37952 .403 L
.56495 .34642 L
.61221 .42554 L
.74039 .66209 L
s
.83531 .73674 m
.53515 .69325 L
.49875 .68175 L
.44838 .6596 L
.33924 .51999 L
.33368 .50656 L
.31746 .42496 L
.31624 .41157 L
.33753 .36854 L
.34453 .35645 L
.5479 .29584 L
.5765 .3292 L
.82654 .72078 L
.83531 .73674 L
s
.89833 .7358 m
.87794 .76696 L
.86834 .77075 L
.74865 .8071 L
.57016 .816 L
.56592 .81611 L
.44578 .67729 L
.32592 .52383 L
.316 .50976 L
.26165 .43016 L
.26327 .38835 L
.2749 .28977 L
.2769 .27898 L
.55453 .27908 L
.65445 .29637 L
.74464 .43751 L
.89833 .7358 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S6.4.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[19]= ",
 CellTags->"S6.4.1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Multivariate Dispersion", "Subsubsection",
 CellTags->{"S6.4.1", "1.36"}],

Cell[TextData[{
 "While measures of location of ",
 Cell[BoxData[
  FormBox[
   StyleBox["p",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "\[Hyphen]variate data have ",
 Cell[BoxData[
  FormBox[
   StyleBox["p",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " components, measures of dispersion of ",
 Cell[BoxData[
  FormBox[
   StyleBox["p",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "\[Hyphen]variate data may be matrix\[Hyphen], vector\[Hyphen], or scalar\
\[Hyphen]valued. We have already seen vector\[Hyphen]valued dispersion \
measures in the coordinate\[Hyphen]wise extensions of the univariate \
dispersion measures. This section describes bivariate dispersion measures, \
matrix\[Hyphen]valued measures of the dispersion of all variable pairs, and \
finally scalar\[Hyphen]valued multivariate dispersion measures. "
}], "Text",
 CellTags->{"S6.4.1", "1.37"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["Covariance[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xlist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ylist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["unbiased estimate of covariance between ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["x",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["y",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         FractionBox["1", 
          RowBox[{
           StyleBox["n",
            "TI"], "-", "1"}]], 
         UnderscriptBox["\[Sum]", 
          StyleBox["i",
           "TI"],
          LimitsPositioning->True], 
         RowBox[{"(", 
          RowBox[{
           SubscriptBox[
            StyleBox["x",
             "TI"], 
            StyleBox["i",
             "TI"]], "-", 
           OverscriptBox[
            StyleBox["x",
             "TI"], "_"]}], ")"}], 
         RowBox[{"(", 
          RowBox[{
           SubscriptBox[
            StyleBox["y",
             "TI"], 
            StyleBox["i",
             "TI"]], "-", 
           OverscriptBox[
            StyleBox["y",
             "TI"], "_"]}], ")"}]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["CovarianceMLE[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xlist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ylist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["maximum likelihood estimate of covariance between ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["x",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["y",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         FractionBox["1", 
          StyleBox["n",
           "TI"]], 
         UnderscriptBox["\[Sum]", 
          StyleBox["i",
           "TI"],
          LimitsPositioning->True], 
         RowBox[{"(", 
          RowBox[{
           SubscriptBox[
            StyleBox["x",
             "TI"], 
            StyleBox["i",
             "TI"]], "-", 
           OverscriptBox[
            StyleBox["x",
             "TI"], "_"]}], ")"}], 
         RowBox[{"(", 
          RowBox[{
           SubscriptBox[
            StyleBox["y",
             "TI"], 
            StyleBox["i",
             "TI"]], "-", 
           OverscriptBox[
            StyleBox["y",
             "TI"], "_"]}], ")"}]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Covariance[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xlist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ylist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ScaleMethod -> ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["method", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["alternative estimate of covariance between ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["x",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["y",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         SubscriptBox["\[Sigma]", 
          StyleBox["x",
           "TI"]], 
         SubscriptBox["\[Sigma]", 
          StyleBox["y",
           "TI"]], 
         RowBox[{"(", 
          RowBox[{
           SubsuperscriptBox["\[Sigma]", "+", "2"], "-", 
           SubsuperscriptBox["\[Sigma]", "-", "2"]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{
           SubsuperscriptBox["\[Sigma]", "+", "2"], "+", 
           SubsuperscriptBox["\[Sigma]", "-", "2"]}], ")"}]}], 
        TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", where ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox["\[Sigma]", "+"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is the scale of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"(", 
         RowBox[{
          StyleBox["x",
           "TI"], "/", 
          SubscriptBox["\[Sigma]", 
           StyleBox["x",
            "TI"]], "+", 
          StyleBox["y",
           "TI"], "/", 
          SubscriptBox["\[Sigma]", 
           StyleBox["y",
            "TI"]]}], ")"}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox["\[Sigma]", "-"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is the scale of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"(", 
         RowBox[{
          StyleBox["x",
           "TI"], "/", 
          SubscriptBox["\[Sigma]", 
           StyleBox["x",
            "TI"]], "-", 
          StyleBox["y",
           "TI"], "/", 
          SubscriptBox["\[Sigma]", 
           StyleBox["y",
            "TI"]]}], ")"}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox["\[Sigma]", 
         StyleBox["x",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is the scale of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["x",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox["\[Sigma]", 
         StyleBox["y",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is the scale of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["y",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", and scale is estimated using ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["method", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S6.4.1"],

Cell["Bivariate dispersion statistics. ", "Caption",
 CellTags->"S6.4.1"],

Cell[TextData[{
 StyleBox["Covariance", "MR"],
 " and ",
 StyleBox["CovarianceMLE", "MR"],
 " consider only a pair of variables at a time. These scalar\[Hyphen]valued \
measures of dispersion are generalizations of ",
 StyleBox["Variance", "MR"],
 " and ",
 StyleBox["VarianceMLE", "MR"],
 ", respectively. ",
 StyleBox["Covariance", "MR"],
 " gives a robust measure of covariance if a robust measure of scale (i.e., \
",
 StyleBox["MeanDeviation", "MR"],
 ", ",
 StyleBox["MedianDeviation", "MR"],
 ", or ",
 StyleBox["QuartileDeviation", "MR"],
 ") is selected using the option ",
 StyleBox["ScaleMethod", "MR"],
 ". "
}], "Text",
 CellTags->{"S6.4.1", "1.38"}],

Cell[TextData[{
 "This gives the value of the off\[Hyphen]diagonal elements in ",
 StyleBox["CovarianceMatrix[data]", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S6.4.1", "1.39"}],

Cell[CellGroupData[{

Cell["cov = Covariance[stiffness, strength]", "Input",
 CellLabel->"In[20]:= ",
 CellTags->"S6.4.1"],

Cell[BoxData["361620.4482758621`"], "Output",
 CellLabel->"Out[20]= ",
 CellTags->"S6.4.1"]
}, Open  ]],

Cell["\<\
The autocovariance of the stiffness is identical to the variance of the \
stiffness. \
\>", "MathCaption",
 CellTags->{"S6.4.1", "1.40"}],

Cell[CellGroupData[{

Cell["Covariance[stiffness, stiffness]", "Input",
 CellLabel->"In[21]:= ",
 CellTags->"S6.4.1"],

Cell[BoxData["124054.6724137931`"], "Output",
 CellLabel->"Out[21]= ",
 CellTags->"S6.4.1"]
}, Open  ]],

Cell[TextData[{
 "These are alternatives to the usual measure of covariance, employing \
measures of scale other than ",
 StyleBox["StandardDeviation", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S6.4.1", "1.41"}],

Cell[CellGroupData[{

Cell["\<\
Map[Covariance[stiffness, strength, ScaleMethod -> #]&,
{MeanDeviation, MedianDeviation, QuartileDeviation}]\
\>", "Input",
 CellLabel->"In[22]:= ",
 CellTags->"S6.4.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "395846.236442042`", ",", "300860.1206005812`", ",", "751302.7890604048`"}],
   "}"}]], "Output",
 CellLabel->"Out[22]= ",
 CellTags->"S6.4.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["CovarianceMatrix[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xdata", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["unbiased estimate of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["p",
          "TI"], "\[Cross]", 
         StyleBox["p",
          "TI"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" covariance matrix of the vector ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["x",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" based on ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["n",
          "TI"], "\[Cross]", 
         StyleBox["p",
          "TI"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" data matrix ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xdata", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         FractionBox["1", 
          RowBox[{
           StyleBox["n",
            "TI"], "-", "1"}]], 
         UnderscriptBox["\[Sum]", 
          StyleBox["i",
           "TI"],
          LimitsPositioning->True], 
         RowBox[{"(", 
          RowBox[{
           SubscriptBox[
            StyleBox["x",
             "TI"], 
            StyleBox["i",
             "TI"]], "-", 
           OverscriptBox[
            StyleBox["x",
             "TI"], "_"]}], ")"}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SubscriptBox[
             StyleBox["x",
              "TI"], 
             StyleBox["i",
              "TI"]], "-", 
            OverscriptBox[
             StyleBox["x",
              "TI"], "_"]}], ")"}], "\[Prime]"]}], TraditionalForm]], 
       "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["CovarianceMatrix[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xdata", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ydata", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["unbiased estimate of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["p",
          "TI"], "\[Cross]", 
         StyleBox["q",
          "TI"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" covariance matrix between the vectors ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["x",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["y",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" based on the ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["n",
          "TI"], "\[Cross]", 
         StyleBox["p",
          "TI"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" data matrix ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xdata", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and the ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["n",
          "TI"], "\[Cross]", 
         StyleBox["q",
          "TI"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" data matrix ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ydata", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         FractionBox["1", 
          RowBox[{
           StyleBox["n",
            "TI"], "-", "1"}]], 
         UnderscriptBox["\[Sum]", 
          StyleBox["i",
           "TI"],
          LimitsPositioning->True], 
         RowBox[{"(", 
          RowBox[{
           SubscriptBox[
            StyleBox["x",
             "TI"], 
            StyleBox["i",
             "TI"]], "-", 
           OverscriptBox[
            StyleBox["x",
             "TI"], "_"]}], ")"}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SubscriptBox[
             StyleBox["y",
              "TI"], 
             StyleBox["i",
              "TI"]], "-", 
            OverscriptBox[
             StyleBox["y",
              "TI"], "_"]}], ")"}], "\[Prime]"]}], TraditionalForm]], 
       "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["CovarianceMatrix[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xdata", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ScaleMethod -> ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["method", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "alternative estimate of the covariance matrix, using the specified \
method of estimating scale ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["CovarianceMatrixMLE[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xdata", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["maximum likelihood estimate of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["p",
          "TI"], "\[Cross]", 
         StyleBox["p",
          "TI"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" covariance matrix of the vector ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["x",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" based on ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["n",
          "TI"], "\[Cross]", 
         StyleBox["p",
          "TI"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" data matrix ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xdata", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         FractionBox["1", 
          StyleBox["n",
           "TI"]], 
         UnderscriptBox["\[Sum]", 
          StyleBox["i",
           "TI"],
          LimitsPositioning->True], 
         RowBox[{"(", 
          RowBox[{
           SubscriptBox[
            StyleBox["x",
             "TI"], 
            StyleBox["i",
             "TI"]], "-", 
           OverscriptBox[
            StyleBox["x",
             "TI"], "_"]}], ")"}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SubscriptBox[
             StyleBox["x",
              "TI"], 
             StyleBox["i",
              "TI"]], "-", 
            OverscriptBox[
             StyleBox["x",
              "TI"], "_"]}], ")"}], "\[Prime]"]}], TraditionalForm]], 
       "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["CovarianceMatrixMLE[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xdata", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ydata", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["maximum likelihood estimate of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["p",
          "TI"], "\[Cross]", 
         StyleBox["q",
          "TI"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" covariance matrix between the vectors ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["x",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["y",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" based on the ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["n",
          "TI"], "\[Cross]", 
         StyleBox["p",
          "TI"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" data matrix ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xdata", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and the ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["n",
          "TI"], "\[Cross]", 
         StyleBox["q",
          "TI"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" matrix ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ydata", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         FractionBox["1", 
          StyleBox["n",
           "TI"]], 
         UnderscriptBox["\[Sum]", 
          StyleBox["i",
           "TI"],
          LimitsPositioning->True], 
         RowBox[{"(", 
          RowBox[{
           SubscriptBox[
            StyleBox["x",
             "TI"], 
            StyleBox["i",
             "TI"]], "-", 
           OverscriptBox[
            StyleBox["x",
             "TI"], "_"]}], ")"}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SubscriptBox[
             StyleBox["y",
              "TI"], 
             StyleBox["i",
              "TI"]], "-", 
            OverscriptBox[
             StyleBox["y",
              "TI"], "_"]}], ")"}], "\[Prime]"]}], TraditionalForm]], 
       "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["CovarianceMatrixOfSampleMean[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xdata", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["estimate of covariance matrix of sample mean vector ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        OverscriptBox[
         StyleBox["x",
          "TI"], "_"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        FractionBox["1", 
         StyleBox["n",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["CovarianceMatrix[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["DispersionMatrix[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xdata", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["estimate of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["p",
          "TI"], "\[Cross]", 
         StyleBox["p",
          "TI"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" dispersion matrix of the vector ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["x",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" based on the ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["p",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["\[Hyphen]variate points inside the convex hull of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xdata", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S6.4.1"],

Cell["\<\
Matrix\[Hyphen]valued multivariate dispersion statistics. \
\>", "Caption",
 CellTags->"S6.4.1"],

Cell[TextData[{
 "A dispersion measure such as ",
 StyleBox["CovarianceMatrix", "MR"],
 " (using the default option setting ",
 StyleBox["ScaleMethod", "MR"],
 " ",
 StyleBox["->", "MR"],
 " ",
 StyleBox["StandardDeviation", "MR"],
 ") is sensitive to outliers and other deviations from multinormality. One \
way to reduce this sensitivity is to replace each element of the covariance \
matrix with a robust measure of dispersion using an option setting such as ",
 StyleBox["ScaleMethod", "MR"],
 " ",
 StyleBox["->", "MR"],
 " ",
 StyleBox["MedianDeviation", "MR"],
 ". When this does not result in a positive definite matrix, ",
 StyleBox["CovarianceMatrix", "MR"],
 " returns unevaluated. A robust alternative that is guaranteed positive\
\[Hyphen]definite is ",
 StyleBox["DispersionMatrix", "MR"],
 ". This function computes a covariance matrix using only those points inside \
the convex hull of the data. Like ",
 StyleBox["CovarianceMatrix", "MR"],
 " with the default setting ",
 StyleBox["ScaleMethod", "MR"],
 " ",
 StyleBox["->", "MR"],
 " ",
 StyleBox["StandardDeviation", "MR"],
 ", it is affinely equivariant. It is scaled so that the determinant of the \
matrix is an unbiased estimate of the determinant of the population \
covariance matrix, when the population distribution is multinormal. "
}], "Text",
 CellTags->{"S6.4.1", "1.42"}],

Cell[TextData[{
 "This gives an unbiased estimate for the covariance of the data with ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["n",
     "TI"], "-", "1"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " as the divisor. Note that the diagonal agrees with ",
 StyleBox["Variance[data]", "MR"],
 " and the off\[Hyphen]diagonal elements agree with ",
 StyleBox["Covariance[stiffness, strength]", "MR"],
 ".  "
}], "MathCaption",
 CellTags->{"S6.4.1", "1.43"}],

Cell[CellGroupData[{

Cell["CovarianceMatrix[data]", "Input",
 CellLabel->"In[23]:= ",
 CellTags->"S6.4.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"124054.6724137931`", ",", "361620.4482758621`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"361620.4482758621`", ",", "3.4863331540229884`*^6"}], "}"}]}], 
  "}"}]], "Output",
 CellLabel->"Out[23]= ",
 CellTags->"S6.4.1"]
}, Open  ]],

Cell[TextData[{
 "Here the off\[Hyphen]diagonal elements agree with the result obtained for \
the covariance of stiffness and strength using ",
 StyleBox["ScaleMethod", "MR"],
 " ",
 StyleBox["->", "MR"],
 " ",
 StyleBox["MedianDeviation", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S6.4.1", "1.44"}],

Cell[CellGroupData[{

Cell["CovarianceMatrix[data, ScaleMethod -> MedianDeviation]", "Input",
 CellLabel->"In[24]:= ",
 CellTags->"S6.4.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"133562.06914219662`", ",", "300860.1206005812`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"300860.1206005812`", ",", "4.9424493967347555`*^6"}], "}"}]}], 
  "}"}]], "Output",
 CellLabel->"Out[24]= ",
 CellTags->"S6.4.1"]
}, Open  ]],

Cell["\<\
This estimate of the dispersion of the data is resistant to outliers that \
fall on the convex hull of the data. \
\>", "MathCaption",
 CellTags->{"S6.4.1", "1.45"}],

Cell[CellGroupData[{

Cell["DispersionMatrix[data]", "Input",
 CellLabel->"In[25]:= ",
 CellTags->"S6.4.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"149354.2119593212`", ",", "444399.6974696548`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"444399.6974696548`", ",", "3.6374038608700735`*^6"}], "}"}]}], 
  "}"}]], "Output",
 CellLabel->"Out[25]= ",
 CellTags->"S6.4.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["GeneralizedVariance[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "determinant of the covariance matrix",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["TotalVariation[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "trace of the covariance matrix",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ConvexHullArea[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "area of region enclosed by convex hull of the bivariate data",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["MultivariateMeanDeviation[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["scalar mean of the Euclidean distances between the ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["p",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["\[Hyphen]variate mean and the ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["p",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["\[Hyphen]variate data",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["MultivariateMedianDeviation[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["scalar median of the Euclidean distances between the ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["p",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["\[Hyphen]variate median and the ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["p",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["\[Hyphen]variate data",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S6.4.1"],

Cell["\<\
Scalar\[Hyphen]valued multivariate dispersion statistics. \
\>", "Caption",
 CellTags->"S6.4.1"],

Cell[TextData[{
 "These scalar\[Hyphen]valued measures of dispersion consider all ",
 Cell[BoxData[
  FormBox[
   StyleBox["p",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " variates simultaneously. ",
 StyleBox["GeneralizedVariance", "MR"],
 " gives the product of the variances of the principal components of the \
data, while ",
 StyleBox["TotalVariation", "MR"],
 " gives the sum of the variances of the principal components of the data. ",
 StyleBox["MultivariateMedianDeviation", "MR"],
 " accepts the option ",
 StyleBox["MedianMethod", "MR"],
 " for selecting the coordinate\[Hyphen]wise median ",
 StyleBox["Median", "MR"],
 ", the total distance minimizing median ",
 StyleBox["SpatialMedian", "MR"],
 ", the total simplex volume minimizing median ",
 StyleBox["SimplexMedian", "MR"],
 ", or the peeled convex hull median ",
 StyleBox["ConvexHullMedian", "MR"],
 ". "
}], "Text",
 CellTags->{"S6.4.1", "1.46"}],

Cell[TextData[{
 "The ",
 StyleBox["GeneralizedVariance", "MR"],
 " of the data gives the product of the variances of the principal components \
of the data. "
}], "MathCaption",
 CellTags->{"S6.4.1", "1.47"}],

Cell[CellGroupData[{

Cell["GeneralizedVariance[data]", "Input",
 CellLabel->"In[26]:= ",
 CellTags->"S6.4.1"],

Cell[BoxData["3.017265687364325`*^11"], "Output",
 CellLabel->"Out[26]= ",
 CellTags->"S6.4.1"]
}, Open  ]],

Cell[TextData[{
 "The ",
 StyleBox["TotalVariation", "MR"],
 " of the data gives the sum of the variances of the principal components of \
the data. "
}], "MathCaption",
 CellTags->{"S6.4.1", "1.48"}],

Cell[CellGroupData[{

Cell["TotalVariation[data]", "Input",
 CellLabel->"In[27]:= ",
 CellTags->"S6.4.1"],

Cell[BoxData["3.6103878264367813`*^6"], "Output",
 CellLabel->"Out[27]= ",
 CellTags->"S6.4.1"]
}, Open  ]],

Cell["\<\
This gives the ratio of the area of the convex hull of the data to the area \
of the smallest box that will enclose the data. \
\>", "MathCaption",
 CellTags->{"S6.4.1", "1.49"}],

Cell[CellGroupData[{

Cell["\<\
ConvexHullArea[data] / Apply[Times,
        SampleRange[data]]\
\>", "Input",
 CellLabel->"In[28]:= ",
 CellTags->"S6.4.1"],

Cell[BoxData["0.5831629927630193`"], "Output",
 CellLabel->"Out[28]= ",
 CellTags->"S6.4.1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Multivariate Association", "Subsubsection",
 CellTags->{"S6.4.1", "1.50"}],

Cell[TextData[{
 "The scalar measures of association introduced by this package are \
constrained to lie between ",
 Cell[BoxData[
  FormBox["-", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "1 and 1. Variables are said to be either negatively correlated, \
uncorrelated, or positively correlated. Pearson\[CloseCurlyQuote]s \
correlation coefficient is given by ",
 StyleBox["Correlation", "MR"],
 " and is useful for measuring linear correlation. A value close to zero \
indicates there is little linear correlation between the variables, but does \
not rule out significant nonlinear correlation. The default measure of scale \
is ",
 StyleBox["StandardDeviation", "MR"],
 ", but alternative measures of scale can be chosen using the option ",
 StyleBox["ScaleMethod", "MR"],
 ". "
}], "Text",
 CellTags->{"S6.4.1", "1.51"}],

Cell[TextData[{
 StyleBox["SpearmanRankCorrelation", "MR"],
 " and ",
 StyleBox["KendallRankCorrelation", "MR"],
 " are useful when dealing with imprecise numerical or ordinal data. A value \
close to zero indicates there is not a significant ",
 StyleBox["monotonic", "TI"],
 " relationship (linear or nonlinear) between the variables. "
}], "Text",
 CellTags->{"S6.4.1", "1.52"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["Correlation[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xlist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ylist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Pearson\[CloseCurlyQuote]s correlation coefficient between ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["x",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["y",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         UnderscriptBox["\[Sum]", 
          StyleBox["i",
           "TI"],
          LimitsPositioning->True], 
         RowBox[{"(", 
          RowBox[{
           SubscriptBox[
            StyleBox["x",
             "TI"], 
            StyleBox["i",
             "TI"]], "-", 
           OverscriptBox[
            StyleBox["x",
             "TI"], "_"]}], ")"}], 
         RowBox[{"(", 
          RowBox[{
           SubscriptBox[
            StyleBox["y",
             "TI"], 
            StyleBox["i",
             "TI"]], "-", 
           OverscriptBox[
            StyleBox["y",
             "TI"], "_"]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{
           SqrtBox[
            RowBox[{
             UnderscriptBox["\[Sum]", 
              StyleBox["i",
               "TI"],
              LimitsPositioning->True], 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                SubscriptBox[
                 StyleBox["x",
                  "TI"], 
                 StyleBox["i",
                  "TI"]], "-", 
                OverscriptBox[
                 StyleBox["x",
                  "TI"], "_"]}], ")"}], "2"]}]], 
           SqrtBox[
            RowBox[{
             UnderscriptBox["\[Sum]", 
              StyleBox["i",
               "TI"],
              LimitsPositioning->True], 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                SubscriptBox[
                 StyleBox["y",
                  "TI"], 
                 StyleBox["i",
                  "TI"]], "-", 
                OverscriptBox[
                 StyleBox["y",
                  "TI"], "_"]}], ")"}], "2"]}]]}], ")"}]}], TraditionalForm]],
        "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Correlation[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xlist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ylist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ScaleMethod -> ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["method", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["alternative estimate of correlation between ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["x",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["y",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SubsuperscriptBox["\[Sigma]", "+", "2"], "-", 
           SubsuperscriptBox["\[Sigma]", "-", "2"]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{
           SubsuperscriptBox["\[Sigma]", "+", "2"], "+", 
           SubsuperscriptBox["\[Sigma]", "-", "2"]}], ")"}]}], 
        TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", where ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox["\[Sigma]", "+"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is the scale of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"(", 
         RowBox[{
          StyleBox["x",
           "TI"], "/", 
          SubscriptBox["\[Sigma]", 
           StyleBox["x",
            "TI"]], "+", 
          StyleBox["y",
           "TI"], "/", 
          SubscriptBox["\[Sigma]", 
           StyleBox["y",
            "TI"]]}], ")"}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox["\[Sigma]", "-"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is the scale of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"(", 
         RowBox[{
          StyleBox["x",
           "TI"], "/", 
          SubscriptBox["\[Sigma]", 
           StyleBox["x",
            "TI"]], "-", 
          StyleBox["y",
           "TI"], "/", 
          SubscriptBox["\[Sigma]", 
           StyleBox["y",
            "TI"]]}], ")"}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox["\[Sigma]", 
         StyleBox["x",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is the scale of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["x",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox["\[Sigma]", 
         StyleBox["y",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is the scale of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["y",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", and scale is estimated using ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["method", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["SpearmanRankCorrelation[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xlist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ylist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "Spearman\[CloseCurlyQuote]s rank correlation coefficient between ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["x",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["y",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox[
              StyleBox["n",
               "TI"], "3"], "-", 
             StyleBox["n",
              "TI"]}], ")"}], "/", "6", "-", 
           SubscriptBox[
            StyleBox["T",
             "TI"], 
            StyleBox["x",
             "TI"]], "-", 
           SubscriptBox[
            StyleBox["T",
             "TI"], 
            StyleBox["y",
             "TI"]], "-", 
           UnderscriptBox["\[Sum]", 
            StyleBox["i",
             "TI"],
            LimitsPositioning->True], 
           SubsuperscriptBox[
            StyleBox["r",
             "TI"], 
            StyleBox["i",
             "TI"], "2"]}], ")"}], "/"}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SqrtBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox[
               StyleBox["n",
                "TI"], "3"], "-", 
              StyleBox["n",
               "TI"]}], ")"}], "/", "6", "-", "2", 
            SubscriptBox[
             StyleBox["T",
              "TI"], 
             StyleBox["x",
              "TI"]]}], ")"}], 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox[
               StyleBox["n",
                "TI"], "3"], "-", 
              StyleBox["n",
               "TI"]}], ")"}], "/", "6", "-", "2", 
            SubscriptBox[
             StyleBox["T",
              "TI"], 
             StyleBox["y",
              "TI"]]}], ")"}]}]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" where ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["n",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is the length of the lists, ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["r",
          "TI"], 
         StyleBox["i",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is the rank difference between ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], 
         StyleBox["i",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], 
         StyleBox["i",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["T",
          "TI"], 
         StyleBox["x",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is the correction term for ties in ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xlist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["T",
          "TI"], 
         StyleBox["y",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is the correction term for ties in ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ylist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["KendallRankCorrelation[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xlist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ylist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "Kendall\[CloseCurlyQuote]s rank correlation coefficient between ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["x",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["y",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SubscriptBox[
            StyleBox["n",
             "TI"], 
            StyleBox["c",
             "TI"]], "-", 
           SubscriptBox[
            StyleBox["n",
             "TI"], 
            StyleBox["d",
             "TI"]]}], ")"}], "/", 
         SqrtBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             SubscriptBox[
              StyleBox["n",
               "TI"], 
              StyleBox["c",
               "TI"]], "+", 
             SubscriptBox[
              StyleBox["n",
               "TI"], 
              StyleBox["d",
               "TI"]], "+", 
             SubscriptBox[
              StyleBox["n",
               "TI"], 
              StyleBox["x",
               "TI"]]}], ")"}], 
           RowBox[{"(", 
            RowBox[{
             SubscriptBox[
              StyleBox["n",
               "TI"], 
              StyleBox["c",
               "TI"]], "+", 
             SubscriptBox[
              StyleBox["n",
               "TI"], 
              StyleBox["d",
               "TI"]], "+", 
             SubscriptBox[
              StyleBox["n",
               "TI"], 
              StyleBox["y",
               "TI"]]}], ")"}]}]]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" where ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["n",
          "TI"], 
         StyleBox["c",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is the number of concordant pairs of observations, ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["n",
          "TI"], 
         StyleBox["d",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is the number of discordant pairs, ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["n",
          "TI"], 
         StyleBox["x",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is the number of ties involving only the ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["x",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" variable, and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["n",
          "TI"], 
         StyleBox["y",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is the number of ties involving only the ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["y",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" variable ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S6.4.1"],

Cell["\<\
Scalar\[Hyphen]valued association statistics. \
\>", "Caption",
 CellTags->"S6.4.1"],

Cell["\<\
This measures a positive linear correlation between stiffness and strength. \
\>", "MathCaption",
 CellTags->{"S6.4.1", "1.53"}],

Cell[CellGroupData[{

Cell["r = Correlation[stiffness, strength]", "Input",
 CellLabel->"In[29]:= ",
 CellTags->"S6.4.1"],

Cell[BoxData["0.5498724666450516`"], "Output",
 CellLabel->"Out[29]= ",
 CellTags->"S6.4.1"]
}, Open  ]],

Cell[TextData[{
 StyleBox["Correlation", "MR"],
 " can be used to construct a ",
 Cell[BoxData[
  FormBox[
   StyleBox["t",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " statistic with ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["n",
     "TI"], "-", "2"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " degrees of freedom, where ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is the sample size. At a 5% level, there is significant nonzero linear \
correlation between stiffness and strength. "
}], "MathCaption",
 CellTags->{"S6.4.1", "1.54"}],

Cell[CellGroupData[{

Cell["\<\
Abs[r] Sqrt[(30-2)/(1-r^2)] >
        Quantile[StudentTDistribution[30-2], .975]\
\>", "Input",
 CellLabel->"In[30]:= ",
 CellTags->"S6.4.1"],

Cell[BoxData["True"], "Output",
 CellLabel->"Out[30]= ",
 CellTags->"S6.4.1"]
}, Open  ]],

Cell[TextData[{
 "These are alternatives to the Pearson correlation coefficient employing \
measures of scale other than ",
 StyleBox["StandardDeviation", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S6.4.1", "1.55"}],

Cell[CellGroupData[{

Cell["\<\
Map[Correlation[stiffness, strength, ScaleMethod -> #]&,
{MeanDeviation, MedianDeviation, QuartileDeviation}]\
\>", "Input",
 CellLabel->"In[31]:= ",
 CellTags->"S6.4.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.5854505029483074`", ",", "0.3702984892877794`", ",", 
   "0.7223719922158935`"}], "}"}]], "Output",
 CellLabel->"Out[31]= ",
 CellTags->"S6.4.1"]
}, Open  ]],

Cell["\<\
These rank measures indicate that there is a positive correlation (possibly \
nonlinear) between stiffness and strength. \
\>", "MathCaption",
 CellTags->{"S6.4.1", "1.56"}],

Cell[CellGroupData[{

Cell["\<\
{SpearmanRankCorrelation[stiffness, strength],
KendallRankCorrelation[stiffness, strength]} // N\
\>", "Input",
 CellLabel->"In[32]:= ",
 CellTags->"S6.4.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.4823673408422493`", ",", "0.37284259438895667`"}], 
  "}"}]], "Output",
 CellLabel->"Out[32]= ",
 CellTags->"S6.4.1"]
}, Open  ]],

Cell[TextData[{
 "As ",
 StyleBox["DispersionMatrix", "MR"],
 " is a robust alternative to ",
 StyleBox["CovarianceMatrix", "MR"],
 ", so is ",
 StyleBox["AssociationMatrix", "MR"],
 " a robust alternative to ",
 StyleBox["CorrelationMatrix", "MR"],
 ". In the case of the lumber data, the off\[Hyphen]diagonal elements of ",
 StyleBox["AssociationMatrix", "MR"],
 " are greater than the off\[Hyphen]diagonal elements of ",
 StyleBox["CorrelationMatrix", "MR"],
 ", indicating that the correlation between stiffness and strength is weaker \
for the outlying observations. "
}], "Text",
 CellTags->{"S6.4.1", "1.57"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["CorrelationMatrix[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xdata", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["estimate of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["p",
          "TI"], "\[Cross]", 
         StyleBox["p",
          "TI"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" correlation matrix of vector ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["x",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", based on ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["n",
          "TI"], "\[Cross]", 
         StyleBox["p",
          "TI"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" data matrix ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xdata", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["CorrelationMatrix[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xdata", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ydata", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["estimate of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["p",
          "TI"], "\[Cross]", 
         StyleBox["q",
          "TI"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" correlation matrix between vectors ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["x",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["y",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", based on ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["n",
          "TI"], "\[Cross]", 
         StyleBox["p",
          "TI"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" data matrix ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xdata", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["n",
          "TI"], "\[Cross]", 
         StyleBox["q",
          "TI"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" data matrix ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ydata", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["CorrelationMatrix[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xdata", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ScaleMethod -> ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["method", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "alternative estimate of the correlation matrix, using the specified \
method of estimating scale ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["AssociationMatrix[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xdata", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["estimate of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["p",
          "TI"], "\[Cross]", 
         StyleBox["p",
          "TI"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" association matrix of the vector ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["x",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" based on the ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["p",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["\[Hyphen]variate points inside the convex hull of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xdata", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S6.4.1"],

Cell["\<\
Matrix\[Hyphen]valued association statistics. \
\>", "Caption",
 CellTags->"S6.4.1"],

Cell[TextData[{
 "The off\[Hyphen]diagonal elements of this matrix correspond to ",
 StyleBox["Correlation[stiffness, strength]", "MR"],
 ".  "
}], "MathCaption",
 CellTags->{"S6.4.1", "1.58"}],

Cell[CellGroupData[{

Cell["CorrelationMatrix[data]", "Input",
 CellLabel->"In[33]:= ",
 CellTags->"S6.4.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.`", ",", "0.5498724666450515`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5498724666450515`", ",", "1.`"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[33]= ",
 CellTags->"S6.4.1"]
}, Open  ]],

Cell[TextData[{
 "Here the off\[Hyphen]diagonal elements agree with the result obtained for \
the correlation of stiffness and strength using ",
 StyleBox["ScaleMethod", "MR"],
 " ",
 StyleBox["->", "MR"],
 " ",
 StyleBox["MedianDeviation", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S6.4.1", "1.59"}],

Cell[CellGroupData[{

Cell["CorrelationMatrix[data, ScaleMethod -> MedianDeviation]", "Input",
 CellLabel->"In[34]:= ",
 CellTags->"S6.4.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.`", ",", "0.3702984892877794`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.3702984892877794`", ",", "1.`"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[34]= ",
 CellTags->"S6.4.1"]
}, Open  ]],

Cell["\<\
This estimate of the association of the data is resistant to outliers that \
fall on the convex hull of the data. \
\>", "MathCaption",
 CellTags->{"S6.4.1", "1.60"}],

Cell[CellGroupData[{

Cell["AssociationMatrix[data]", "Input",
 CellLabel->"In[35]:= ",
 CellTags->"S6.4.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.`", ",", "0.6029332790844045`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.6029332790844045`", ",", "1.`"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[35]= ",
 CellTags->"S6.4.1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Multivariate Shape", "Subsubsection",
 CellTags->{"S6.4.1", "1.61"}],

Cell[TextData[{
 "Multivariate shape statistics consider all variables of the data \
simultaneously. The functions ",
 StyleBox["MultivariateSkewness", "MR"],
 " and ",
 StyleBox["MultivariateKurtosisExcess", "MR"],
 " can be used to test for elliptical symmetry or multinormal shape, \
respectively. ",
 StyleBox["MultivariatePearsonSkewness1", "MR"],
 " measures the skew between the multivariate mean and the multivariate mode, \
while ",
 StyleBox["MultivariatePearsonSkewness2", "MR"],
 " measures the skew between the multivariate mean and the multivariate \
median. Note that ",
 StyleBox["MultivariateMode", "MR"],
 " is not an interpolated mode and yields ",
 StyleBox["{}", "MR"],
 " when all points in the sample are unique. Thus, unless there are many \
replications in the data, ",
 StyleBox["MultivariatePearsonSkewness1", "MR"],
 " is not recommended. ",
 StyleBox["MultivariatePearsonSkewness2", "MR"],
 " accepts the option ",
 StyleBox["MedianMethod", "MR"],
 " for choosing the median. "
}], "Text",
 CellTags->{"S6.4.1", "1.62"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["CentralMoment[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["r",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["r",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] , ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["r",
          "TI"], 
         StyleBox["p",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["r",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SuperscriptBox["\[Null]", "th"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" central moment ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         FractionBox["1", 
          StyleBox["n",
           "TI"]], 
         UnderscriptBox["\[Sum]", 
          StyleBox["i",
           "TI"],
          LimitsPositioning->True], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SubscriptBox[
             StyleBox["x",
              "TI"], 
             RowBox[{
              StyleBox["i",
               "TI"], "1"}]], "-", 
            SubscriptBox[
             OverscriptBox[
              StyleBox["x",
               "TI"], "_"], "1"]}], ")"}], 
          SubscriptBox[
           StyleBox["r",
            "TI"], "1"]], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SubscriptBox[
             StyleBox["x",
              "TI"], 
             RowBox[{
              StyleBox["i",
               "TI"], "2"}]], "-", 
            SubscriptBox[
             OverscriptBox[
              StyleBox["x",
               "TI"], "_"], "2"]}], ")"}], 
          SubscriptBox[
           StyleBox["r",
            "TI"], "2"]], "\[Ellipsis]", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SubscriptBox[
             StyleBox["x",
              "TI"], 
             StyleBox[
              RowBox[{"i", "p"}],
              "TI"]], "-", 
            SubscriptBox[
             OverscriptBox[
              StyleBox["x",
               "TI"], "_"], 
             StyleBox["p",
              "TI"]]}], ")"}], 
          SubscriptBox[
           StyleBox["r",
            "TI"], 
           StyleBox["p",
            "TI"]]]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" where ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is an ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["n",
          "TI"], "\[Cross]", 
         StyleBox["p",
          "TI"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" data matrix and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["r",
          "TI"], "=", 
         SubscriptBox[
          StyleBox["r",
           "TI"], "1"], "+", 
         SubscriptBox[
          StyleBox["r",
           "TI"], "2"], "+", "\[Ellipsis]", "+", 
         SubscriptBox[
          StyleBox["r",
           "TI"], 
          StyleBox["p",
           "TI"]]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["MultivariatePearsonSkewness1[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "multivariate Pearson\[CloseCurlyQuote]s first coefficient of skewness, \
",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"9", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SubscriptBox["\[Mu]", 
             StyleBox[
              RowBox[{"m", "e", "a", "n"}],
              "TI"]], "-", 
            SubscriptBox["\[Mu]", 
             StyleBox[
              RowBox[{"m", "o", "d", "e"}],
              "TI"]]}], ")"}], "\[Prime]"], 
         SuperscriptBox[Cell[BoxData["\[CapitalSigma]"], "InlineFormula",
           GridBoxOptions->{ColumnWidths->Automatic}], 
          RowBox[{"-", "1"}]], 
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["\[Mu]", 
            StyleBox[
             RowBox[{"m", "e", "a", "n"}],
             "TI"]], "-", 
           SubscriptBox["\[Mu]", 
            StyleBox[
             RowBox[{"m", "o", "d", "e"}],
             "TI"]]}], ")"}]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", where ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["\[CapitalSigma]", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is an unbiased estimate of the population covariance",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["MultivariatePearsonSkewness2[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "multivariate Pearson\[CloseCurlyQuote]s second coefficient of \
skewness, ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"9", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SubscriptBox["\[Mu]", 
             StyleBox[
              RowBox[{"m", "e", "a", "n"}],
              "TI"]], "-", 
            SubscriptBox["\[Mu]", 
             StyleBox[
              RowBox[{"m", "e", "d", "i", "a", "n"}],
              "TI"]]}], ")"}], "\[Prime]"], 
         SuperscriptBox[Cell[BoxData["\[CapitalSigma]"], "InlineFormula",
           GridBoxOptions->{ColumnWidths->Automatic}], 
          RowBox[{"-", "1"}]], 
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["\[Mu]", 
            StyleBox[
             RowBox[{"m", "e", "a", "n"}],
             "TI"]], "-", 
           SubscriptBox["\[Mu]", 
            StyleBox[
             RowBox[{"m", "e", "d", "i", "a", "n"}],
             "TI"]]}], ")"}]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", where ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["\[CapitalSigma]", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is an unbiased estimate of the population covariance",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["MultivariateSkewness[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["multivariate coefficient of skewness, ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         FractionBox["1", 
          SuperscriptBox[
           StyleBox["n",
            "TI"], "2"]], 
         UnderscriptBox["\[Sum]", 
          StyleBox["i",
           "TI"],
          LimitsPositioning->True], 
         UnderscriptBox["\[Sum]", 
          StyleBox["j",
           "TI"],
          LimitsPositioning->True], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               SubscriptBox[
                StyleBox["x",
                 "TI"], 
                StyleBox["i",
                 "TI"]], "-", 
               OverscriptBox[
                StyleBox["x",
                 "TI"], "_"]}], ")"}], "\[Prime]"], 
            SuperscriptBox[Cell[BoxData["\[CapitalSigma]"], "InlineFormula",
              GridBoxOptions->{ColumnWidths->Automatic}], 
             RowBox[{"-", "1"}]], 
            RowBox[{"(", 
             RowBox[{
              SubscriptBox[
               StyleBox["x",
                "TI"], 
               StyleBox["j",
                "TI"]], "-", 
              OverscriptBox[
               StyleBox["x",
                "TI"], "_"]}], ")"}]}], ")"}], "3"]}], TraditionalForm]], 
       "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", where ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["\[CapitalSigma]", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[
      " is the maximum likelihood estimate of the population covariance",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["MultivariateKurtosis[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["multivariate kurtosis coefficient, ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         FractionBox["1", 
          StyleBox["n",
           "TI"]], 
         UnderscriptBox["\[Sum]", 
          StyleBox["i",
           "TI"],
          LimitsPositioning->True], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               SubscriptBox[
                StyleBox["x",
                 "TI"], 
                StyleBox["i",
                 "TI"]], "-", 
               OverscriptBox[
                StyleBox["x",
                 "TI"], "_"]}], ")"}], "\[Prime]"], 
            SuperscriptBox[Cell[BoxData["\[CapitalSigma]"], "InlineFormula",
              GridBoxOptions->{ColumnWidths->Automatic}], 
             RowBox[{"-", "1"}]], 
            RowBox[{"(", 
             RowBox[{
              SubscriptBox[
               StyleBox["x",
                "TI"], 
               StyleBox["i",
                "TI"]], "-", 
              OverscriptBox[
               StyleBox["x",
                "TI"], "_"]}], ")"}]}], ")"}], "2"]}], TraditionalForm]], 
       "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", where ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["\[CapitalSigma]", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[
      " is the maximum likelihood estimate of the population covariance",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["MultivariateKurtosisExcess[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["multivariate kurtosis excess, ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         RowBox[{
          StyleBox["MultivariateKurtosis",
           "MR"], 
          RowBox[{"[", 
           StyleBox["data",
            "TI"], "]"}]}], "-", 
         StyleBox["p",
          "TI"], 
         RowBox[{"(", 
          RowBox[{
           StyleBox["p",
            "TI"], "+", "2"}], ")"}]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S6.4.1"],

Cell["Multivariate shape statistics. ", "Caption",
 CellTags->"S6.4.1"],

Cell[TextData[{
 "This list of second\[Hyphen]order central moments gives ",
 StyleBox["VarianceMLE[data]", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S6.4.1", "1.63"}],

Cell[CellGroupData[{

Cell["\<\
{CentralMoment[data, {2, 0}],
CentralMoment[data, {0, 2}]}\
\>", "Input",
 CellLabel->"In[36]:= ",
 CellTags->"S6.4.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"119919.51666666666`", ",", "3.370122048888889`*^6"}], 
  "}"}]], "Output",
 CellLabel->"Out[36]= ",
 CellTags->"S6.4.1"]
}, Open  ]],

Cell["\<\
Here is a measure of the skew between the mean and the median computed by \
peeling the convex hulls. \
\>", "MathCaption",
 CellTags->{"S6.4.1", "1.64"}],

Cell[CellGroupData[{

Cell["\<\
MultivariatePearsonSkewness2[data,
                        MedianMethod -> ConvexHullMedian]\
\>", "Input",
 CellLabel->"In[37]:= ",
 CellTags->"S6.4.1"],

Cell[BoxData["0.45423950645838496`"], "Output",
 CellLabel->"Out[37]= ",
 CellTags->"S6.4.1"]
}, Open  ]],

Cell["\<\
This gives a single value for skewness for the stiffness and bending strength \
variables. It should be close to zero for elliptically symmetrical data. \
\>", "MathCaption",
 CellTags->{"S6.4.1", "1.65"}],

Cell[CellGroupData[{

Cell["multiskewness = MultivariateSkewness[data]", "Input",
 CellLabel->"In[38]:= ",
 CellTags->"S6.4.1"],

Cell[BoxData["1.026276749863267`"], "Output",
 CellLabel->"Out[38]= ",
 CellTags->"S6.4.1"]
}, Open  ]],

Cell[TextData[{
 "As ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["n",
     "TI"], "\[Rule]", "\[Infinity]"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", the distribution of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Beta]", "1"], 
    StyleBox["n",
     "TI"], "/", "6"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " (where ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Beta]", "1"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is multivariate skewness) approaches ",
 Cell[BoxData[
  FormBox[
   SubsuperscriptBox["\[Chi]", 
    StyleBox["f",
     "TI"], "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["f",
     "TI"], "=", 
    FractionBox["1", "6"], 
    StyleBox["p",
     "TI"], 
    RowBox[{"(", 
     RowBox[{
      StyleBox["p",
       "TI"], "+", "1"}], ")"}], 
    RowBox[{"(", 
     RowBox[{
      StyleBox["p",
       "TI"], "+", "2"}], ")"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". At a 5% level of significance, the hypothesis of elliptical symmetry is \
not rejected. "
}], "MathCaption",
 CellTags->{"S6.4.1", "1.66"}],

Cell[CellGroupData[{

Cell["\<\
multiskewness 30/6 >
Quantile[ChiSquareDistribution[4], .95]\
\>", "Input",
 CellLabel->"In[39]:= ",
 CellTags->"S6.4.1"],

Cell[BoxData["False"], "Output",
 CellLabel->"Out[39]= ",
 CellTags->"S6.4.1"]
}, Open  ]],

Cell["\<\
This gives a single value for kurtosis excess for the two variables. It \
should be close to zero for multinormally distributed data. \
\>", "MathCaption",
 CellTags->{"S6.4.1", "1.67"}],

Cell[CellGroupData[{

Cell["multikurtosisExcess = MultivariateKurtosisExcess[data]", "Input",
 CellLabel->"In[40]:= ",
 CellTags->"S6.4.1"],

Cell[BoxData["0.01720124790558586`"], "Output",
 CellLabel->"Out[40]= ",
 CellTags->"S6.4.1"]
}, Open  ]],

Cell[TextData[{
 "As ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["n",
     "TI"], "\[Rule]", "\[Infinity]"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", the distribution of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Gamma]", "2"], "/", 
    SqrtBox[
     RowBox[{"8", 
      StyleBox["p",
       "TI"], 
      RowBox[{"(", 
       RowBox[{
        StyleBox["p",
         "TI"], "+", "2"}], ")"}], "/", 
      StyleBox["n",
       "TI"]}]]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " (where ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Gamma]", "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is multivariate kurtosis excess) approaches ",
 StyleBox["N", "TI"],
 "(0, 1). At a 5% level of significance, the hypothesis of multinormal shape \
is not rejected. "
}], "MathCaption",
 CellTags->{"S6.4.1", "1.68"}],

Cell[CellGroupData[{

Cell["\<\
Abs[ multikurtosisExcess / Sqrt[ 8 2 (2+2)/30 ] ] >
Quantile[NormalDistribution[0, 1], .975]\
\>", "Input",
 CellLabel->"In[41]:= ",
 CellTags->"S6.4.1"],

Cell[BoxData["False"], "Output",
 CellLabel->"Out[41]= ",
 CellTags->"S6.4.1"]
}, Open  ]],

Cell["\<\
The bivariate shape statistics support the hypothesis that the lumber data \
follows a binormal distribution. \
\>", "Text",
 CellTags->{"S6.4.1", "1.69"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Multivariate Expected Value", "Subsubsection",
 CellTags->{"S6.4.1", "1.70"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["ExpectedValue[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["expected value of the pure function ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["f",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" with respect to the sample distribution of the data ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ExpectedValue[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["expected value of the function ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["f",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["x",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[
      " with respect to the sample distribution of the data, where ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["x",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[
      " is scalar\[Hyphen], vector\[Hyphen], or matrix\[Hyphen]valued \
depending on the data ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S6.4.1"],

Cell["Expected value. ", "Caption",
 CellTags->"S6.4.1"],

Cell["\<\
Other location, dispersion, and shape statistics can be computed by taking \
the expected values of functions with respect to the sample distribution of \
the data. \
\>", "Text",
 CellTags->{"S6.4.1", "1.71"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Multivariate Data Transformations", "Subsubsection",
 CellTags->{"S6.4.1", "1.72"}],

Cell[TextData[{
 "As with univariate descriptive statistics, univariate data transformations \
are applied to columns of the data matrix. ",
 StyleBox["ZeroMean[", "MR"],
 StyleBox["data", "TI"],
 StyleBox["]", "MR"],
 " and ",
 StyleBox["Standardize[", "MR"],
 StyleBox["data", "TI"],
 StyleBox["]", "MR"],
 " do not affect the correlation structure of the data. The package ",
 StyleBox["MultiDescriptiveStatistics", "MR"],
 " extends ",
 StyleBox["Standardize", "MR"],
 " to accept the option ",
 StyleBox["Decorrelate", "MR"],
 " and provides the data transformation ",
 StyleBox["PrincipalComponents", "MR"],
 ". Both of these transformations decorrelate the data. "
}], "Text",
 CellTags->{"S6.4.1", "1.73"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[StyleBox["ZeroMean",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Standardize",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S6.4.1"],

Cell["\<\
Univariate data transformations applied to columns of a data matrix.\
\>", "Caption",
 CellTags->"S6.4.1"],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["Standardize[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", Decorrelate -> True]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "transform the data so that the covariance matrix of the result is the \
identity matrix",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["PrincipalComponents[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "transform the data so that the covariance matrix of the result is a \
diagonal matrix with variables ordered from largest variance to smallest ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S6.4.1"],

Cell["Multivariate data transformations. ", "Caption",
 CellTags->"S6.4.1"],

Cell["\<\
Changing the location of the data does not affect the covariance. \
\>", "MathCaption",
 CellTags->{"S6.4.1", "1.74"}],

Cell[CellGroupData[{

Cell["CovarianceMatrix[ZeroMean[data]]", "Input",
 CellLabel->"In[42]:= ",
 CellTags->"S6.4.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"124054.6724137931`", ",", "361620.4482758621`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"361620.4482758621`", ",", "3.4863331540229884`*^6"}], "}"}]}], 
  "}"}]], "Output",
 CellLabel->"Out[42]= ",
 CellTags->"S6.4.1"]
}, Open  ]],

Cell["\<\
Standardizing the data coordinate\[Hyphen]wise yields unit variances, but \
does not decorrelate the data. \
\>", "MathCaption",
 CellTags->{"S6.4.1", "1.75"}],

Cell[CellGroupData[{

Cell["CovarianceMatrix[Standardize[data]]", "Input",
 CellLabel->"In[43]:= ",
 CellTags->"S6.4.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.9999999999999999`", ",", "0.5498724666450516`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5498724666450516`", ",", "1.`"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[43]= ",
 CellTags->"S6.4.1"]
}, Open  ]],

Cell[TextData[{
 "Standardizing the data with ",
 StyleBox["Decorrelate", "MR"],
 " ",
 StyleBox["->", "MR"],
 " ",
 StyleBox["True", "MR"],
 " gives a new data set with a sample covariance matrix equal to the identity \
matrix. "
}], "MathCaption",
 CellTags->{"S6.4.1", "1.76"}],

Cell[CellGroupData[{

Cell["CovarianceMatrix[Standardize[data, Decorrelate -> True]]", "Input",
 CellLabel->"In[44]:= ",
 CellTags->"S6.4.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.`", ",", 
     RowBox[{"-", "1.0336559194785941`*^-16"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.0336559194785941`*^-16"}], ",", "0.9999999999999999`"}], 
    "}"}]}], "}"}]], "Output",
 CellLabel->"Out[44]= ",
 CellTags->"S6.4.1"]
}, Open  ]],

Cell["\<\
The principal component transformation yields decorrelated variables ordered \
from largest variance to smallest. \
\>", "MathCaption",
 CellTags->{"S6.4.1", "1.77"}],

Cell[CellGroupData[{

Cell["CovarianceMatrix[PrincipalComponents[data]]", "Input",
 CellLabel->"In[45]:= ",
 CellTags->"S6.4.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3.5247864508808143`*^6", ",", 
     RowBox[{"-", "2.6093089375002635`*^-11"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2.6093089375002635`*^-11"}], ",", "85601.375555967`"}], 
    "}"}]}], "}"}]], "Output",
 CellLabel->"Out[45]= ",
 CellTags->"S6.4.1"]
}, Open  ]],

Cell[TextData[{
 "If you wish to approximate a multivariate data set by a univariate set, you \
can take the first column of ",
 StyleBox["PrincipalComponents[", "MR"],
 StyleBox["data", "TI"],
 StyleBox["]", "MR"],
 " and still retain a significant portion of the information conveyed by the \
original multivariate set. For a data set with ",
 Cell[BoxData[
  FormBox[
   StyleBox["p",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " > 2, a scatter plot of the first two principal components can sometimes be \
more informative than scatterplots of all possible variable pairs. Also, some \
nonparametric procedures that are prohibitively time consuming for higher\
\[Hyphen]dimensional data, can be applied to the first two or three principal \
components in reasonable time. "
}], "Text",
 CellTags->{"S6.4.1", "1.78"}]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S6.4.1"->{
    Cell[1776, 53, 152, 6, 36, "Subsection",
      CellTags->{"S6.4.1", "1.1"}],
    Cell[1931, 61, 1483, 39, 136, "Text",
      CellTags->{"S6.4.1", "1.2"}],
    Cell[3417, 102, 273, 6, 40, "Text",
      CellTags->{"S6.4.1", "1.3"}],
    Cell[3693, 110, 356, 8, 56, "Text",
      CellTags->{"S6.4.1", "1.4"}],
    Cell[4052, 120, 1911, 51, 130, "DefinitionBox",
      CellTags->"S6.4.1"],
    Cell[5966, 173, 115, 3, 15, "Caption",
      CellTags->"S6.4.1"],
    Cell[6084, 178, 278, 10, 40, "Text",
      CellTags->{"S6.4.1", "1.5"}],
    Cell[6365, 190, 77, 1, 40, "MathCaption",
      CellTags->{"S6.4.1", "1.6"}],
    Cell[6445, 193, 102, 2, 28, "Input",
      CellTags->"S6.4.1"],
    Cell[6550, 197, 563, 16, 73, "MathCaption",
      CellTags->{"S6.4.1", "1.7"}],
    Cell[7116, 215, 511, 11, 232, "Input",
      CellTags->"S6.4.1"],
    Cell[7630, 228, 86, 1, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.8"}],
    Cell[7741, 233, 76, 2, 70, "Input",
      CellTags->"S6.4.1"],
    Cell[7820, 237, 141, 4, 70, "Output",
      CellTags->"S6.4.1"],
    Cell[7976, 244, 108, 1, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.9"}],
    Cell[8109, 249, 78, 2, 70, "Input",
      CellTags->"S6.4.1"],
    Cell[8190, 253, 129, 4, 70, "Output",
      CellTags->"S6.4.1"],
    Cell[8334, 260, 2162, 56, 70, "DefinitionBox",
      CellTags->"S6.4.1"],
    Cell[10499, 318, 117, 3, 70, "Caption",
      CellTags->"S6.4.1"],
    Cell[10619, 323, 257, 8, 70, "Text",
      CellTags->{"S6.4.1", "1.10"}],
    Cell[10879, 333, 136, 3, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.11"}],
    Cell[11040, 340, 76, 2, 70, "Input",
      CellTags->"S6.4.1"],
    Cell[11119, 344, 159, 5, 70, "Output",
      CellTags->"S6.4.1"],
    Cell[11293, 352, 1426, 38, 70, "DefinitionBox",
      CellTags->"S6.4.1"],
    Cell[12722, 392, 112, 3, 70, "Caption",
      CellTags->"S6.4.1"],
    Cell[12837, 397, 326, 6, 70, "Text",
      CellTags->{"S6.4.1", "1.12"}],
    Cell[13166, 405, 207, 4, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.13"}],
    Cell[13398, 413, 87, 2, 70, "Input",
      CellTags->"S6.4.1"],
    Cell[13488, 417, 176, 5, 70, "Output",
      CellTags->"S6.4.1"],
    Cell[13679, 425, 946, 29, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.14"}],
    Cell[14650, 458, 138, 5, 70, "Input",
      CellTags->"S6.4.1"],
    Cell[14791, 465, 126, 4, 70, "Output",
      CellTags->"S6.4.1"],
    Cell[14932, 472, 182, 4, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.15"}],
    Cell[15139, 480, 99, 2, 70, "Input",
      CellTags->"S6.4.1"],
    Cell[15241, 484, 192, 6, 70, "Output",
      CellTags->"S6.4.1"],
    Cell[15448, 493, 869, 28, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.16"}],
    Cell[16342, 525, 155, 6, 70, "Input",
      CellTags->"S6.4.1"],
    Cell[16500, 533, 126, 4, 70, "Output",
      CellTags->"S6.4.1"],
    Cell[16641, 540, 155, 4, 70, "Text",
      CellTags->{"S6.4.1", "1.17"}],
    Cell[16799, 546, 534, 9, 70, "Text",
      CellTags->{"S6.4.1", "1.18"}],
    Cell[17358, 559, 77, 1, 70, "Subsubsection",
      CellTags->{"S6.4.1", "1.19"}],
    Cell[17438, 562, 450, 8, 70, "Text",
      CellTags->{"S6.4.1", "1.20"}],
    Cell[17891, 572, 547, 10, 70, "Text",
      CellTags->{"S6.4.1", "1.21"}],
    Cell[18441, 584, 5932, 176, 70, "DefinitionBox",
      CellTags->"S6.4.1"],
    Cell[24376, 762, 74, 1, 70, "Caption",
      CellTags->"S6.4.1"],
    Cell[24453, 765, 613, 20, 70, "Text",
      CellTags->{"S6.4.1", "1.22"}],
    Cell[25069, 787, 1753, 62, 70, "Text",
      CellTags->{"S6.4.1", "1.23"}],
    Cell[26825, 851, 154, 4, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.24"}],
    Cell[27004, 859, 86, 2, 70, "Input",
      CellTags->"S6.4.1"],
    Cell[27093, 863, 156, 5, 70, "Output",
      CellTags->"S6.4.1"],
    Cell[27264, 871, 166, 4, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.25"}],
    Cell[27455, 879, 86, 2, 70, "Input",
      CellTags->"S6.4.1"],
    Cell[27544, 883, 423, 9, 70, "Message",
      CellTags->"S6.4.1"],
    Cell[27970, 894, 156, 5, 70, "Output",
      CellTags->"S6.4.1"],
    Cell[28141, 902, 196, 4, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.26"}],
    Cell[28362, 910, 89, 2, 70, "Input",
      CellTags->"S6.4.1"],
    Cell[28454, 914, 156, 5, 70, "Output",
      CellTags->"S6.4.1"],
    Cell[28625, 922, 133, 5, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.27"}],
    Cell[28761, 929, 83, 2, 70, "Input",
      CellTags->"S6.4.1"],
    Cell[28847, 933, 553, 9, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.28"}],
    Cell[29425, 946, 398, 10, 70, "Input",
      CellTags->"S6.4.1"],
    Cell[29826, 958, 9064, 399, 70, 8994, 396, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S6.4.1"],
    Cell[38893, 1359, 180, 6, 70, "Output",
      CellTags->"S6.4.1"],
    Cell[39088, 1368, 362, 7, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.29"}],
    Cell[39475, 1379, 238, 7, 70, "Input",
      CellTags->"S6.4.1"],
    Cell[39716, 1388, 10300, 466, 70, 10230, 463, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S6.4.1"],
    Cell[50019, 1856, 180, 6, 70, "Output",
      CellTags->"S6.4.1"],
    Cell[50214, 1865, 9277, 288, 70, "DefinitionBox",
      CellTags->"S6.4.1"],
    Cell[59494, 2155, 62, 1, 70, "Caption",
      CellTags->"S6.4.1"],
    Cell[59559, 2158, 1509, 40, 70, "Text",
      CellTags->{"S6.4.1", "1.30"}],
    Cell[61071, 2200, 907, 31, 70, "Text",
      CellTags->{"S6.4.1", "1.31"}],
    Cell[61981, 2233, 305, 7, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.32"}],
    Cell[62311, 2244, 145, 5, 70, "Input",
      CellTags->"S6.4.1"],
    Cell[62459, 2251, 250, 8, 70, "Output",
      CellTags->"S6.4.1"],
    Cell[62724, 2262, 7509, 224, 70, "DefinitionBox",
      CellTags->"S6.4.1"],
    Cell[70236, 2488, 79, 1, 70, "Caption",
      CellTags->"S6.4.1"],
    Cell[70318, 2491, 159, 4, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.33"}],
    Cell[70502, 2499, 190, 6, 70, "Input",
      CellTags->"S6.4.1"],
    Cell[70695, 2507, 238, 8, 70, "Output",
      CellTags->"S6.4.1"],
    Cell[70948, 2518, 170, 4, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.34"}],
    Cell[71143, 2526, 269, 8, 70, "Input",
      CellTags->"S6.4.1"],
    Cell[71415, 2536, 11988, 840, 70, 11918, 837, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S6.4.1"],
    Cell[83406, 3378, 180, 6, 70, "Output",
      CellTags->"S6.4.1"],
    Cell[83601, 3387, 182, 4, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.35"}],
    Cell[83808, 3395, 268, 8, 70, "Input",
      CellTags->"S6.4.1"],
    Cell[84079, 3405, 5372, 418, 70, 5302, 415, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S6.4.1"],
    Cell[89454, 3825, 180, 6, 70, "Output",
      CellTags->"S6.4.1"],
    Cell[89683, 3837, 79, 1, 70, "Subsubsection",
      CellTags->{"S6.4.1", "1.36"}],
    Cell[89765, 3840, 1018, 26, 70, "Text",
      CellTags->{"S6.4.1", "1.37"}],
    Cell[90786, 3868, 11415, 359, 70, "DefinitionBox",
      CellTags->"S6.4.1"],
    Cell[102204, 4229, 73, 1, 70, "Caption",
      CellTags->"S6.4.1"],
    Cell[102280, 4232, 663, 22, 70, "Text",
      CellTags->{"S6.4.1", "1.38"}],
    Cell[102946, 4256, 180, 5, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.39"}],
    Cell[103151, 4265, 100, 2, 70, "Input",
      CellTags->"S6.4.1"],
    Cell[103254, 4269, 91, 2, 70, "Output",
      CellTags->"S6.4.1"],
    Cell[103360, 4274, 147, 4, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.40"}],
    Cell[103532, 4282, 95, 2, 70, "Input",
      CellTags->"S6.4.1"],
    Cell[103630, 4286, 91, 2, 70, "Output",
      CellTags->"S6.4.1"],
    Cell[103736, 4291, 214, 6, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.41"}],
    Cell[103975, 4301, 179, 5, 70, "Input",
      CellTags->"S6.4.1"],
    Cell[104157, 4308, 185, 6, 70, "Output",
      CellTags->"S6.4.1"],
    Cell[104357, 4317, 19509, 622, 70, "DefinitionBox",
      CellTags->"S6.4.1"],
    Cell[123869, 4941, 106, 3, 70, "Caption",
      CellTags->"S6.4.1"],
    Cell[123978, 4946, 1354, 35, 70, "Text",
      CellTags->{"S6.4.1", "1.42"}],
    Cell[125335, 4983, 506, 14, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.43"}],
    Cell[125866, 5001, 85, 2, 70, "Input",
      CellTags->"S6.4.1"],
    Cell[125954, 5005, 292, 9, 70, "Output",
      CellTags->"S6.4.1"],
    Cell[126261, 5017, 302, 10, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.44"}],
    Cell[126588, 5031, 117, 2, 70, "Input",
      CellTags->"S6.4.1"],
    Cell[126708, 5035, 293, 9, 70, "Output",
      CellTags->"S6.4.1"],
    Cell[127016, 5047, 175, 4, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.45"}],
    Cell[127216, 5055, 85, 2, 70, "Input",
      CellTags->"S6.4.1"],
    Cell[127304, 5059, 292, 9, 70, "Output",
      CellTags->"S6.4.1"],
    Cell[127611, 5071, 5117, 153, 70, "DefinitionBox",
      CellTags->"S6.4.1"],
    Cell[132731, 5226, 106, 3, 70, "Caption",
      CellTags->"S6.4.1"],
    Cell[132840, 5231, 970, 26, 70, "Text",
      CellTags->{"S6.4.1", "1.46"}],
    Cell[133813, 5259, 209, 6, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.47"}],
    Cell[134047, 5269, 88, 2, 70, "Input",
      CellTags->"S6.4.1"],
    Cell[134138, 5273, 95, 2, 70, "Output",
      CellTags->"S6.4.1"],
    Cell[134248, 5278, 200, 6, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.48"}],
    Cell[134473, 5288, 83, 2, 70, "Input",
      CellTags->"S6.4.1"],
    Cell[134559, 5292, 95, 2, 70, "Output",
      CellTags->"S6.4.1"],
    Cell[134669, 5297, 188, 4, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.49"}],
    Cell[134882, 5305, 133, 5, 70, "Input",
      CellTags->"S6.4.1"],
    Cell[135018, 5312, 92, 2, 70, "Output",
      CellTags->"S6.4.1"],
    Cell[135159, 5320, 80, 1, 70, "Subsubsection",
      CellTags->{"S6.4.1", "1.50"}],
    Cell[135242, 5323, 865, 19, 70, "Text",
      CellTags->{"S6.4.1", "1.51"}],
    Cell[136110, 5344, 381, 9, 70, "Text",
      CellTags->{"S6.4.1", "1.52"}],
    Cell[136494, 5355, 21776, 688, 70, "DefinitionBox",
      CellTags->"S6.4.1"],
    Cell[158273, 6045, 94, 3, 70, "Caption",
      CellTags->"S6.4.1"],
    Cell[158370, 6050, 138, 3, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.53"}],
    Cell[158533, 6057, 99, 2, 70, "Input",
      CellTags->"S6.4.1"],
    Cell[158635, 6061, 92, 2, 70, "Output",
      CellTags->"S6.4.1"],
    Cell[158742, 6066, 739, 24, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.54"}],
    Cell[159506, 6094, 151, 5, 70, "Input",
      CellTags->"S6.4.1"],
    Cell[159660, 6101, 77, 2, 70, "Output",
      CellTags->"S6.4.1"],
    Cell[159752, 6106, 217, 6, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.55"}],
    Cell[159994, 6116, 180, 5, 70, "Input",
      CellTags->"S6.4.1"],
    Cell[160177, 6123, 190, 6, 70, "Output",
      CellTags->"S6.4.1"],
    Cell[160382, 6132, 183, 4, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.56"}],
    Cell[160590, 6140, 167, 5, 70, "Input",
      CellTags->"S6.4.1"],
    Cell[160760, 6147, 159, 5, 70, "Output",
      CellTags->"S6.4.1"],
    Cell[160934, 6155, 616, 16, 70, "Text",
      CellTags->{"S6.4.1", "1.57"}],
    Cell[161553, 6173, 8188, 252, 70, "DefinitionBox",
      CellTags->"S6.4.1"],
    Cell[169744, 6427, 94, 3, 70, "Caption",
      CellTags->"S6.4.1"],
    Cell[169841, 6432, 193, 5, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.58"}],
    Cell[170059, 6441, 86, 2, 70, "Input",
      CellTags->"S6.4.1"],
    Cell[170148, 6445, 257, 8, 70, "Output",
      CellTags->"S6.4.1"],
    Cell[170420, 6456, 303, 10, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.59"}],
    Cell[170748, 6470, 118, 2, 70, "Input",
      CellTags->"S6.4.1"],
    Cell[170869, 6474, 257, 8, 70, "Output",
      CellTags->"S6.4.1"],
    Cell[171141, 6485, 176, 4, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.60"}],
    Cell[171342, 6493, 86, 2, 70, "Input",
      CellTags->"S6.4.1"],
    Cell[171431, 6497, 257, 8, 70, "Output",
      CellTags->"S6.4.1"],
    Cell[171737, 6511, 74, 1, 70, "Subsubsection",
      CellTags->{"S6.4.1", "1.61"}],
    Cell[171814, 6514, 1049, 26, 70, "Text",
      CellTags->{"S6.4.1", "1.62"}],
    Cell[172866, 6542, 16323, 507, 70, "DefinitionBox",
      CellTags->"S6.4.1"],
    Cell[189192, 7051, 71, 1, 70, "Caption",
      CellTags->"S6.4.1"],
    Cell[189266, 7054, 170, 5, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.63"}],
    Cell[189461, 7063, 129, 5, 70, "Input",
      CellTags->"S6.4.1"],
    Cell[189593, 7070, 160, 5, 70, "Output",
      CellTags->"S6.4.1"],
    Cell[189768, 7078, 164, 4, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.64"}],
    Cell[189957, 7086, 163, 5, 70, "Input",
      CellTags->"S6.4.1"],
    Cell[190123, 7093, 93, 2, 70, "Output",
      CellTags->"S6.4.1"],
    Cell[190231, 7098, 215, 4, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.65"}],
    Cell[190471, 7106, 105, 2, 70, "Input",
      CellTags->"S6.4.1"],
    Cell[190579, 7110, 91, 2, 70, "Output",
      CellTags->"S6.4.1"],
    Cell[190685, 7115, 1337, 49, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.66"}],
    Cell[192047, 7168, 131, 5, 70, "Input",
      CellTags->"S6.4.1"],
    Cell[192181, 7175, 78, 2, 70, "Output",
      CellTags->"S6.4.1"],
    Cell[192274, 7180, 196, 4, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.67"}],
    Cell[192495, 7188, 117, 2, 70, "Input",
      CellTags->"S6.4.1"],
    Cell[192615, 7192, 93, 2, 70, "Output",
      CellTags->"S6.4.1"],
    Cell[192723, 7197, 969, 34, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.68"}],
    Cell[193717, 7235, 163, 5, 70, "Input",
      CellTags->"S6.4.1"],
    Cell[193883, 7242, 78, 2, 70, "Output",
      CellTags->"S6.4.1"],
    Cell[193976, 7247, 165, 4, 70, "Text",
      CellTags->{"S6.4.1", "1.69"}],
    Cell[194178, 7256, 83, 1, 70, "Subsubsection",
      CellTags->{"S6.4.1", "1.70"}],
    Cell[194264, 7259, 3657, 111, 70, "DefinitionBox",
      CellTags->"S6.4.1"],
    Cell[197924, 7372, 56, 1, 70, "Caption",
      CellTags->"S6.4.1"],
    Cell[197983, 7375, 220, 5, 70, "Text",
      CellTags->{"S6.4.1", "1.71"}],
    Cell[198240, 7385, 89, 1, 70, "Subsubsection",
      CellTags->{"S6.4.1", "1.72"}],
    Cell[198332, 7388, 714, 20, 70, "Text",
      CellTags->{"S6.4.1", "1.73"}],
    Cell[199049, 7410, 525, 15, 70, "DefinitionBox",
      CellTags->"S6.4.1"],
    Cell[199577, 7427, 116, 3, 70, "Caption",
      CellTags->"S6.4.1"],
    Cell[199696, 7432, 1738, 50, 70, "DefinitionBox",
      CellTags->"S6.4.1"],
    Cell[201437, 7484, 75, 1, 70, "Caption",
      CellTags->"S6.4.1"],
    Cell[201515, 7487, 128, 3, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.74"}],
    Cell[201668, 7494, 95, 2, 70, "Input",
      CellTags->"S6.4.1"],
    Cell[201766, 7498, 292, 9, 70, "Output",
      CellTags->"S6.4.1"],
    Cell[202073, 7510, 169, 4, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.75"}],
    Cell[202267, 7518, 98, 2, 70, "Input",
      CellTags->"S6.4.1"],
    Cell[202368, 7522, 273, 8, 70, "Output",
      CellTags->"S6.4.1"],
    Cell[202656, 7533, 280, 10, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.76"}],
    Cell[202961, 7547, 119, 2, 70, "Input",
      CellTags->"S6.4.1"],
    Cell[203083, 7551, 330, 11, 70, "Output",
      CellTags->"S6.4.1"],
    Cell[203428, 7565, 176, 4, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.77"}],
    Cell[203629, 7573, 106, 2, 70, "Input",
      CellTags->"S6.4.1"],
    Cell[203738, 7577, 346, 11, 70, "Output",
      CellTags->"S6.4.1"],
    Cell[204099, 7591, 871, 19, 70, "Text",
      CellTags->{"S6.4.1", "1.78"}]},
  "1.1"->{
    Cell[1776, 53, 152, 6, 36, "Subsection",
      CellTags->{"S6.4.1", "1.1"}]},
  "1.2"->{
    Cell[1931, 61, 1483, 39, 136, "Text",
      CellTags->{"S6.4.1", "1.2"}]},
  "1.3"->{
    Cell[3417, 102, 273, 6, 40, "Text",
      CellTags->{"S6.4.1", "1.3"}]},
  "1.4"->{
    Cell[3693, 110, 356, 8, 56, "Text",
      CellTags->{"S6.4.1", "1.4"}]},
  "1.5"->{
    Cell[6084, 178, 278, 10, 40, "Text",
      CellTags->{"S6.4.1", "1.5"}]},
  "1.6"->{
    Cell[6365, 190, 77, 1, 40, "MathCaption",
      CellTags->{"S6.4.1", "1.6"}]},
  "1.7"->{
    Cell[6550, 197, 563, 16, 73, "MathCaption",
      CellTags->{"S6.4.1", "1.7"}]},
  "1.8"->{
    Cell[7630, 228, 86, 1, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.8"}]},
  "1.9"->{
    Cell[7976, 244, 108, 1, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.9"}]},
  "1.10"->{
    Cell[10619, 323, 257, 8, 70, "Text",
      CellTags->{"S6.4.1", "1.10"}]},
  "1.11"->{
    Cell[10879, 333, 136, 3, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.11"}]},
  "1.12"->{
    Cell[12837, 397, 326, 6, 70, "Text",
      CellTags->{"S6.4.1", "1.12"}]},
  "1.13"->{
    Cell[13166, 405, 207, 4, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.13"}]},
  "1.14"->{
    Cell[13679, 425, 946, 29, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.14"}]},
  "1.15"->{
    Cell[14932, 472, 182, 4, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.15"}]},
  "1.16"->{
    Cell[15448, 493, 869, 28, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.16"}]},
  "1.17"->{
    Cell[16641, 540, 155, 4, 70, "Text",
      CellTags->{"S6.4.1", "1.17"}]},
  "1.18"->{
    Cell[16799, 546, 534, 9, 70, "Text",
      CellTags->{"S6.4.1", "1.18"}]},
  "1.19"->{
    Cell[17358, 559, 77, 1, 70, "Subsubsection",
      CellTags->{"S6.4.1", "1.19"}]},
  "1.20"->{
    Cell[17438, 562, 450, 8, 70, "Text",
      CellTags->{"S6.4.1", "1.20"}]},
  "1.21"->{
    Cell[17891, 572, 547, 10, 70, "Text",
      CellTags->{"S6.4.1", "1.21"}]},
  "1.22"->{
    Cell[24453, 765, 613, 20, 70, "Text",
      CellTags->{"S6.4.1", "1.22"}]},
  "1.23"->{
    Cell[25069, 787, 1753, 62, 70, "Text",
      CellTags->{"S6.4.1", "1.23"}]},
  "1.24"->{
    Cell[26825, 851, 154, 4, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.24"}]},
  "1.25"->{
    Cell[27264, 871, 166, 4, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.25"}]},
  "1.26"->{
    Cell[28141, 902, 196, 4, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.26"}]},
  "1.27"->{
    Cell[28625, 922, 133, 5, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.27"}]},
  "1.28"->{
    Cell[28847, 933, 553, 9, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.28"}]},
  "1.29"->{
    Cell[39088, 1368, 362, 7, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.29"}]},
  "1.30"->{
    Cell[59559, 2158, 1509, 40, 70, "Text",
      CellTags->{"S6.4.1", "1.30"}]},
  "1.31"->{
    Cell[61071, 2200, 907, 31, 70, "Text",
      CellTags->{"S6.4.1", "1.31"}]},
  "1.32"->{
    Cell[61981, 2233, 305, 7, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.32"}]},
  "1.33"->{
    Cell[70318, 2491, 159, 4, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.33"}]},
  "1.34"->{
    Cell[70948, 2518, 170, 4, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.34"}]},
  "1.35"->{
    Cell[83601, 3387, 182, 4, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.35"}]},
  "1.36"->{
    Cell[89683, 3837, 79, 1, 70, "Subsubsection",
      CellTags->{"S6.4.1", "1.36"}]},
  "1.37"->{
    Cell[89765, 3840, 1018, 26, 70, "Text",
      CellTags->{"S6.4.1", "1.37"}]},
  "1.38"->{
    Cell[102280, 4232, 663, 22, 70, "Text",
      CellTags->{"S6.4.1", "1.38"}]},
  "1.39"->{
    Cell[102946, 4256, 180, 5, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.39"}]},
  "1.40"->{
    Cell[103360, 4274, 147, 4, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.40"}]},
  "1.41"->{
    Cell[103736, 4291, 214, 6, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.41"}]},
  "1.42"->{
    Cell[123978, 4946, 1354, 35, 70, "Text",
      CellTags->{"S6.4.1", "1.42"}]},
  "1.43"->{
    Cell[125335, 4983, 506, 14, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.43"}]},
  "1.44"->{
    Cell[126261, 5017, 302, 10, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.44"}]},
  "1.45"->{
    Cell[127016, 5047, 175, 4, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.45"}]},
  "1.46"->{
    Cell[132840, 5231, 970, 26, 70, "Text",
      CellTags->{"S6.4.1", "1.46"}]},
  "1.47"->{
    Cell[133813, 5259, 209, 6, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.47"}]},
  "1.48"->{
    Cell[134248, 5278, 200, 6, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.48"}]},
  "1.49"->{
    Cell[134669, 5297, 188, 4, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.49"}]},
  "1.50"->{
    Cell[135159, 5320, 80, 1, 70, "Subsubsection",
      CellTags->{"S6.4.1", "1.50"}]},
  "1.51"->{
    Cell[135242, 5323, 865, 19, 70, "Text",
      CellTags->{"S6.4.1", "1.51"}]},
  "1.52"->{
    Cell[136110, 5344, 381, 9, 70, "Text",
      CellTags->{"S6.4.1", "1.52"}]},
  "1.53"->{
    Cell[158370, 6050, 138, 3, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.53"}]},
  "1.54"->{
    Cell[158742, 6066, 739, 24, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.54"}]},
  "1.55"->{
    Cell[159752, 6106, 217, 6, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.55"}]},
  "1.56"->{
    Cell[160382, 6132, 183, 4, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.56"}]},
  "1.57"->{
    Cell[160934, 6155, 616, 16, 70, "Text",
      CellTags->{"S6.4.1", "1.57"}]},
  "1.58"->{
    Cell[169841, 6432, 193, 5, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.58"}]},
  "1.59"->{
    Cell[170420, 6456, 303, 10, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.59"}]},
  "1.60"->{
    Cell[171141, 6485, 176, 4, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.60"}]},
  "1.61"->{
    Cell[171737, 6511, 74, 1, 70, "Subsubsection",
      CellTags->{"S6.4.1", "1.61"}]},
  "1.62"->{
    Cell[171814, 6514, 1049, 26, 70, "Text",
      CellTags->{"S6.4.1", "1.62"}]},
  "1.63"->{
    Cell[189266, 7054, 170, 5, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.63"}]},
  "1.64"->{
    Cell[189768, 7078, 164, 4, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.64"}]},
  "1.65"->{
    Cell[190231, 7098, 215, 4, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.65"}]},
  "1.66"->{
    Cell[190685, 7115, 1337, 49, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.66"}]},
  "1.67"->{
    Cell[192274, 7180, 196, 4, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.67"}]},
  "1.68"->{
    Cell[192723, 7197, 969, 34, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.68"}]},
  "1.69"->{
    Cell[193976, 7247, 165, 4, 70, "Text",
      CellTags->{"S6.4.1", "1.69"}]},
  "1.70"->{
    Cell[194178, 7256, 83, 1, 70, "Subsubsection",
      CellTags->{"S6.4.1", "1.70"}]},
  "1.71"->{
    Cell[197983, 7375, 220, 5, 70, "Text",
      CellTags->{"S6.4.1", "1.71"}]},
  "1.72"->{
    Cell[198240, 7385, 89, 1, 70, "Subsubsection",
      CellTags->{"S6.4.1", "1.72"}]},
  "1.73"->{
    Cell[198332, 7388, 714, 20, 70, "Text",
      CellTags->{"S6.4.1", "1.73"}]},
  "1.74"->{
    Cell[201515, 7487, 128, 3, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.74"}]},
  "1.75"->{
    Cell[202073, 7510, 169, 4, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.75"}]},
  "1.76"->{
    Cell[202656, 7533, 280, 10, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.76"}]},
  "1.77"->{
    Cell[203428, 7565, 176, 4, 70, "MathCaption",
      CellTags->{"S6.4.1", "1.77"}]},
  "1.78"->{
    Cell[204099, 7591, 871, 19, 70, "Text",
      CellTags->{"S6.4.1", "1.78"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S6.4.1", 205620, 7630},
  {"1.1", 221289, 8039},
  {"1.2", 221382, 8042},
  {"1.3", 221472, 8045},
  {"1.4", 221560, 8048},
  {"1.5", 221648, 8051},
  {"1.6", 221737, 8054},
  {"1.7", 221831, 8057},
  {"1.8", 221927, 8060},
  {"1.9", 222021, 8063},
  {"1.10", 222117, 8066},
  {"1.11", 222208, 8069},
  {"1.12", 222306, 8072},
  {"1.13", 222397, 8075},
  {"1.14", 222495, 8078},
  {"1.15", 222594, 8081},
  {"1.16", 222692, 8084},
  {"1.17", 222791, 8087},
  {"1.18", 222882, 8090},
  {"1.19", 222973, 8093},
  {"1.20", 223072, 8096},
  {"1.21", 223163, 8099},
  {"1.22", 223255, 8102},
  {"1.23", 223347, 8105},
  {"1.24", 223440, 8108},
  {"1.25", 223538, 8111},
  {"1.26", 223636, 8114},
  {"1.27", 223734, 8117},
  {"1.28", 223832, 8120},
  {"1.29", 223930, 8123},
  {"1.30", 224029, 8126},
  {"1.31", 224123, 8129},
  {"1.32", 224216, 8132},
  {"1.33", 224315, 8135},
  {"1.34", 224414, 8138},
  {"1.35", 224513, 8141},
  {"1.36", 224612, 8144},
  {"1.37", 224712, 8147},
  {"1.38", 224806, 8150},
  {"1.39", 224900, 8153},
  {"1.40", 225000, 8156},
  {"1.41", 225100, 8159},
  {"1.42", 225200, 8162},
  {"1.43", 225295, 8165},
  {"1.44", 225396, 8168},
  {"1.45", 225497, 8171},
  {"1.46", 225597, 8174},
  {"1.47", 225691, 8177},
  {"1.48", 225791, 8180},
  {"1.49", 225891, 8183},
  {"1.50", 225991, 8186},
  {"1.51", 226092, 8189},
  {"1.52", 226186, 8192},
  {"1.53", 226279, 8195},
  {"1.54", 226379, 8198},
  {"1.55", 226480, 8201},
  {"1.56", 226580, 8204},
  {"1.57", 226680, 8207},
  {"1.58", 226774, 8210},
  {"1.59", 226874, 8213},
  {"1.60", 226975, 8216},
  {"1.61", 227075, 8219},
  {"1.62", 227176, 8222},
  {"1.63", 227271, 8225},
  {"1.64", 227371, 8228},
  {"1.65", 227471, 8231},
  {"1.66", 227571, 8234},
  {"1.67", 227673, 8237},
  {"1.68", 227773, 8240},
  {"1.69", 227874, 8243},
  {"1.70", 227967, 8246},
  {"1.71", 228068, 8249},
  {"1.72", 228161, 8252},
  {"1.73", 228262, 8255},
  {"1.74", 228356, 8258},
  {"1.75", 228456, 8261},
  {"1.76", 228556, 8264},
  {"1.77", 228657, 8267},
  {"1.78", 228757, 8270}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 152, 6, 36, "Subsection",
  CellTags->{"S6.4.1", "1.1"}],
Cell[1931, 61, 1483, 39, 136, "Text",
  CellTags->{"S6.4.1", "1.2"}],
Cell[3417, 102, 273, 6, 40, "Text",
  CellTags->{"S6.4.1", "1.3"}],
Cell[3693, 110, 356, 8, 56, "Text",
  CellTags->{"S6.4.1", "1.4"}],
Cell[4052, 120, 1911, 51, 130, "DefinitionBox",
  CellTags->"S6.4.1"],
Cell[5966, 173, 115, 3, 15, "Caption",
  CellTags->"S6.4.1"],
Cell[6084, 178, 278, 10, 40, "Text",
  CellTags->{"S6.4.1", "1.5"}],
Cell[6365, 190, 77, 1, 40, "MathCaption",
  CellTags->{"S6.4.1", "1.6"}],
Cell[6445, 193, 102, 2, 28, "Input",
  CellTags->"S6.4.1"],
Cell[6550, 197, 563, 16, 73, "MathCaption",
  CellTags->{"S6.4.1", "1.7"}],
Cell[7116, 215, 511, 11, 232, "Input",
  CellTags->"S6.4.1"],
Cell[7630, 228, 86, 1, 70, "MathCaption",
  CellTags->{"S6.4.1", "1.8"}],

Cell[CellGroupData[{
Cell[7741, 233, 76, 2, 70, "Input",
  CellTags->"S6.4.1"],
Cell[7820, 237, 141, 4, 70, "Output",
  CellTags->"S6.4.1"]
}, Open  ]],
Cell[7976, 244, 108, 1, 70, "MathCaption",
  CellTags->{"S6.4.1", "1.9"}],

Cell[CellGroupData[{
Cell[8109, 249, 78, 2, 70, "Input",
  CellTags->"S6.4.1"],
Cell[8190, 253, 129, 4, 70, "Output",
  CellTags->"S6.4.1"]
}, Open  ]],
Cell[8334, 260, 2162, 56, 70, "DefinitionBox",
  CellTags->"S6.4.1"],
Cell[10499, 318, 117, 3, 70, "Caption",
  CellTags->"S6.4.1"],
Cell[10619, 323, 257, 8, 70, "Text",
  CellTags->{"S6.4.1", "1.10"}],
Cell[10879, 333, 136, 3, 70, "MathCaption",
  CellTags->{"S6.4.1", "1.11"}],

Cell[CellGroupData[{
Cell[11040, 340, 76, 2, 70, "Input",
  CellTags->"S6.4.1"],
Cell[11119, 344, 159, 5, 70, "Output",
  CellTags->"S6.4.1"]
}, Open  ]],
Cell[11293, 352, 1426, 38, 70, "DefinitionBox",
  CellTags->"S6.4.1"],
Cell[12722, 392, 112, 3, 70, "Caption",
  CellTags->"S6.4.1"],
Cell[12837, 397, 326, 6, 70, "Text",
  CellTags->{"S6.4.1", "1.12"}],
Cell[13166, 405, 207, 4, 70, "MathCaption",
  CellTags->{"S6.4.1", "1.13"}],

Cell[CellGroupData[{
Cell[13398, 413, 87, 2, 70, "Input",
  CellTags->"S6.4.1"],
Cell[13488, 417, 176, 5, 70, "Output",
  CellTags->"S6.4.1"]
}, Open  ]],
Cell[13679, 425, 946, 29, 70, "MathCaption",
  CellTags->{"S6.4.1", "1.14"}],

Cell[CellGroupData[{
Cell[14650, 458, 138, 5, 70, "Input",
  CellTags->"S6.4.1"],
Cell[14791, 465, 126, 4, 70, "Output",
  CellTags->"S6.4.1"]
}, Open  ]],
Cell[14932, 472, 182, 4, 70, "MathCaption",
  CellTags->{"S6.4.1", "1.15"}],

Cell[CellGroupData[{
Cell[15139, 480, 99, 2, 70, "Input",
  CellTags->"S6.4.1"],
Cell[15241, 484, 192, 6, 70, "Output",
  CellTags->"S6.4.1"]
}, Open  ]],
Cell[15448, 493, 869, 28, 70, "MathCaption",
  CellTags->{"S6.4.1", "1.16"}],

Cell[CellGroupData[{
Cell[16342, 525, 155, 6, 70, "Input",
  CellTags->"S6.4.1"],
Cell[16500, 533, 126, 4, 70, "Output",
  CellTags->"S6.4.1"]
}, Open  ]],
Cell[16641, 540, 155, 4, 70, "Text",
  CellTags->{"S6.4.1", "1.17"}],
Cell[16799, 546, 534, 9, 70, "Text",
  CellTags->{"S6.4.1", "1.18"}],

Cell[CellGroupData[{
Cell[17358, 559, 77, 1, 70, "Subsubsection",
  CellTags->{"S6.4.1", "1.19"}],
Cell[17438, 562, 450, 8, 70, "Text",
  CellTags->{"S6.4.1", "1.20"}],
Cell[17891, 572, 547, 10, 70, "Text",
  CellTags->{"S6.4.1", "1.21"}],
Cell[18441, 584, 5932, 176, 70, "DefinitionBox",
  CellTags->"S6.4.1"],
Cell[24376, 762, 74, 1, 70, "Caption",
  CellTags->"S6.4.1"],
Cell[24453, 765, 613, 20, 70, "Text",
  CellTags->{"S6.4.1", "1.22"}],
Cell[25069, 787, 1753, 62, 70, "Text",
  CellTags->{"S6.4.1", "1.23"}],
Cell[26825, 851, 154, 4, 70, "MathCaption",
  CellTags->{"S6.4.1", "1.24"}],

Cell[CellGroupData[{
Cell[27004, 859, 86, 2, 70, "Input",
  CellTags->"S6.4.1"],
Cell[27093, 863, 156, 5, 70, "Output",
  CellTags->"S6.4.1"]
}, Open  ]],
Cell[27264, 871, 166, 4, 70, "MathCaption",
  CellTags->{"S6.4.1", "1.25"}],

Cell[CellGroupData[{
Cell[27455, 879, 86, 2, 70, "Input",
  CellTags->"S6.4.1"],
Cell[27544, 883, 423, 9, 70, "Message",
  CellTags->"S6.4.1"],
Cell[27970, 894, 156, 5, 70, "Output",
  CellTags->"S6.4.1"]
}, Open  ]],
Cell[28141, 902, 196, 4, 70, "MathCaption",
  CellTags->{"S6.4.1", "1.26"}],

Cell[CellGroupData[{
Cell[28362, 910, 89, 2, 70, "Input",
  CellTags->"S6.4.1"],
Cell[28454, 914, 156, 5, 70, "Output",
  CellTags->"S6.4.1"]
}, Open  ]],
Cell[28625, 922, 133, 5, 70, "MathCaption",
  CellTags->{"S6.4.1", "1.27"}],
Cell[28761, 929, 83, 2, 70, "Input",
  CellTags->"S6.4.1"],
Cell[28847, 933, 553, 9, 70, "MathCaption",
  CellTags->{"S6.4.1", "1.28"}],

Cell[CellGroupData[{
Cell[29425, 946, 398, 10, 70, "Input",
  CellTags->"S6.4.1"],
Cell[29826, 958, 9064, 399, 70, 8994, 396, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S6.4.1"],
Cell[38893, 1359, 180, 6, 70, "Output",
  CellTags->"S6.4.1"]
}, Open  ]],
Cell[39088, 1368, 362, 7, 70, "MathCaption",
  CellTags->{"S6.4.1", "1.29"}],

Cell[CellGroupData[{
Cell[39475, 1379, 238, 7, 70, "Input",
  CellTags->"S6.4.1"],
Cell[39716, 1388, 10300, 466, 70, 10230, 463, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S6.4.1"],
Cell[50019, 1856, 180, 6, 70, "Output",
  CellTags->"S6.4.1"]
}, Open  ]],
Cell[50214, 1865, 9277, 288, 70, "DefinitionBox",
  CellTags->"S6.4.1"],
Cell[59494, 2155, 62, 1, 70, "Caption",
  CellTags->"S6.4.1"],
Cell[59559, 2158, 1509, 40, 70, "Text",
  CellTags->{"S6.4.1", "1.30"}],
Cell[61071, 2200, 907, 31, 70, "Text",
  CellTags->{"S6.4.1", "1.31"}],
Cell[61981, 2233, 305, 7, 70, "MathCaption",
  CellTags->{"S6.4.1", "1.32"}],

Cell[CellGroupData[{
Cell[62311, 2244, 145, 5, 70, "Input",
  CellTags->"S6.4.1"],
Cell[62459, 2251, 250, 8, 70, "Output",
  CellTags->"S6.4.1"]
}, Open  ]],
Cell[62724, 2262, 7509, 224, 70, "DefinitionBox",
  CellTags->"S6.4.1"],
Cell[70236, 2488, 79, 1, 70, "Caption",
  CellTags->"S6.4.1"],
Cell[70318, 2491, 159, 4, 70, "MathCaption",
  CellTags->{"S6.4.1", "1.33"}],

Cell[CellGroupData[{
Cell[70502, 2499, 190, 6, 70, "Input",
  CellTags->"S6.4.1"],
Cell[70695, 2507, 238, 8, 70, "Output",
  CellTags->"S6.4.1"]
}, Open  ]],
Cell[70948, 2518, 170, 4, 70, "MathCaption",
  CellTags->{"S6.4.1", "1.34"}],

Cell[CellGroupData[{
Cell[71143, 2526, 269, 8, 70, "Input",
  CellTags->"S6.4.1"],
Cell[71415, 2536, 11988, 840, 70, 11918, 837, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S6.4.1"],
Cell[83406, 3378, 180, 6, 70, "Output",
  CellTags->"S6.4.1"]
}, Open  ]],
Cell[83601, 3387, 182, 4, 70, "MathCaption",
  CellTags->{"S6.4.1", "1.35"}],

Cell[CellGroupData[{
Cell[83808, 3395, 268, 8, 70, "Input",
  CellTags->"S6.4.1"],
Cell[84079, 3405, 5372, 418, 70, 5302, 415, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S6.4.1"],
Cell[89454, 3825, 180, 6, 70, "Output",
  CellTags->"S6.4.1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[89683, 3837, 79, 1, 70, "Subsubsection",
  CellTags->{"S6.4.1", "1.36"}],
Cell[89765, 3840, 1018, 26, 70, "Text",
  CellTags->{"S6.4.1", "1.37"}],
Cell[90786, 3868, 11415, 359, 70, "DefinitionBox",
  CellTags->"S6.4.1"],
Cell[102204, 4229, 73, 1, 70, "Caption",
  CellTags->"S6.4.1"],
Cell[102280, 4232, 663, 22, 70, "Text",
  CellTags->{"S6.4.1", "1.38"}],
Cell[102946, 4256, 180, 5, 70, "MathCaption",
  CellTags->{"S6.4.1", "1.39"}],

Cell[CellGroupData[{
Cell[103151, 4265, 100, 2, 70, "Input",
  CellTags->"S6.4.1"],
Cell[103254, 4269, 91, 2, 70, "Output",
  CellTags->"S6.4.1"]
}, Open  ]],
Cell[103360, 4274, 147, 4, 70, "MathCaption",
  CellTags->{"S6.4.1", "1.40"}],

Cell[CellGroupData[{
Cell[103532, 4282, 95, 2, 70, "Input",
  CellTags->"S6.4.1"],
Cell[103630, 4286, 91, 2, 70, "Output",
  CellTags->"S6.4.1"]
}, Open  ]],
Cell[103736, 4291, 214, 6, 70, "MathCaption",
  CellTags->{"S6.4.1", "1.41"}],

Cell[CellGroupData[{
Cell[103975, 4301, 179, 5, 70, "Input",
  CellTags->"S6.4.1"],
Cell[104157, 4308, 185, 6, 70, "Output",
  CellTags->"S6.4.1"]
}, Open  ]],
Cell[104357, 4317, 19509, 622, 70, "DefinitionBox",
  CellTags->"S6.4.1"],
Cell[123869, 4941, 106, 3, 70, "Caption",
  CellTags->"S6.4.1"],
Cell[123978, 4946, 1354, 35, 70, "Text",
  CellTags->{"S6.4.1", "1.42"}],
Cell[125335, 4983, 506, 14, 70, "MathCaption",
  CellTags->{"S6.4.1", "1.43"}],

Cell[CellGroupData[{
Cell[125866, 5001, 85, 2, 70, "Input",
  CellTags->"S6.4.1"],
Cell[125954, 5005, 292, 9, 70, "Output",
  CellTags->"S6.4.1"]
}, Open  ]],
Cell[126261, 5017, 302, 10, 70, "MathCaption",
  CellTags->{"S6.4.1", "1.44"}],

Cell[CellGroupData[{
Cell[126588, 5031, 117, 2, 70, "Input",
  CellTags->"S6.4.1"],
Cell[126708, 5035, 293, 9, 70, "Output",
  CellTags->"S6.4.1"]
}, Open  ]],
Cell[127016, 5047, 175, 4, 70, "MathCaption",
  CellTags->{"S6.4.1", "1.45"}],

Cell[CellGroupData[{
Cell[127216, 5055, 85, 2, 70, "Input",
  CellTags->"S6.4.1"],
Cell[127304, 5059, 292, 9, 70, "Output",
  CellTags->"S6.4.1"]
}, Open  ]],
Cell[127611, 5071, 5117, 153, 70, "DefinitionBox",
  CellTags->"S6.4.1"],
Cell[132731, 5226, 106, 3, 70, "Caption",
  CellTags->"S6.4.1"],
Cell[132840, 5231, 970, 26, 70, "Text",
  CellTags->{"S6.4.1", "1.46"}],
Cell[133813, 5259, 209, 6, 70, "MathCaption",
  CellTags->{"S6.4.1", "1.47"}],

Cell[CellGroupData[{
Cell[134047, 5269, 88, 2, 70, "Input",
  CellTags->"S6.4.1"],
Cell[134138, 5273, 95, 2, 70, "Output",
  CellTags->"S6.4.1"]
}, Open  ]],
Cell[134248, 5278, 200, 6, 70, "MathCaption",
  CellTags->{"S6.4.1", "1.48"}],

Cell[CellGroupData[{
Cell[134473, 5288, 83, 2, 70, "Input",
  CellTags->"S6.4.1"],
Cell[134559, 5292, 95, 2, 70, "Output",
  CellTags->"S6.4.1"]
}, Open  ]],
Cell[134669, 5297, 188, 4, 70, "MathCaption",
  CellTags->{"S6.4.1", "1.49"}],

Cell[CellGroupData[{
Cell[134882, 5305, 133, 5, 70, "Input",
  CellTags->"S6.4.1"],
Cell[135018, 5312, 92, 2, 70, "Output",
  CellTags->"S6.4.1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[135159, 5320, 80, 1, 70, "Subsubsection",
  CellTags->{"S6.4.1", "1.50"}],
Cell[135242, 5323, 865, 19, 70, "Text",
  CellTags->{"S6.4.1", "1.51"}],
Cell[136110, 5344, 381, 9, 70, "Text",
  CellTags->{"S6.4.1", "1.52"}],
Cell[136494, 5355, 21776, 688, 70, "DefinitionBox",
  CellTags->"S6.4.1"],
Cell[158273, 6045, 94, 3, 70, "Caption",
  CellTags->"S6.4.1"],
Cell[158370, 6050, 138, 3, 70, "MathCaption",
  CellTags->{"S6.4.1", "1.53"}],

Cell[CellGroupData[{
Cell[158533, 6057, 99, 2, 70, "Input",
  CellTags->"S6.4.1"],
Cell[158635, 6061, 92, 2, 70, "Output",
  CellTags->"S6.4.1"]
}, Open  ]],
Cell[158742, 6066, 739, 24, 70, "MathCaption",
  CellTags->{"S6.4.1", "1.54"}],

Cell[CellGroupData[{
Cell[159506, 6094, 151, 5, 70, "Input",
  CellTags->"S6.4.1"],
Cell[159660, 6101, 77, 2, 70, "Output",
  CellTags->"S6.4.1"]
}, Open  ]],
Cell[159752, 6106, 217, 6, 70, "MathCaption",
  CellTags->{"S6.4.1", "1.55"}],

Cell[CellGroupData[{
Cell[159994, 6116, 180, 5, 70, "Input",
  CellTags->"S6.4.1"],
Cell[160177, 6123, 190, 6, 70, "Output",
  CellTags->"S6.4.1"]
}, Open  ]],
Cell[160382, 6132, 183, 4, 70, "MathCaption",
  CellTags->{"S6.4.1", "1.56"}],

Cell[CellGroupData[{
Cell[160590, 6140, 167, 5, 70, "Input",
  CellTags->"S6.4.1"],
Cell[160760, 6147, 159, 5, 70, "Output",
  CellTags->"S6.4.1"]
}, Open  ]],
Cell[160934, 6155, 616, 16, 70, "Text",
  CellTags->{"S6.4.1", "1.57"}],
Cell[161553, 6173, 8188, 252, 70, "DefinitionBox",
  CellTags->"S6.4.1"],
Cell[169744, 6427, 94, 3, 70, "Caption",
  CellTags->"S6.4.1"],
Cell[169841, 6432, 193, 5, 70, "MathCaption",
  CellTags->{"S6.4.1", "1.58"}],

Cell[CellGroupData[{
Cell[170059, 6441, 86, 2, 70, "Input",
  CellTags->"S6.4.1"],
Cell[170148, 6445, 257, 8, 70, "Output",
  CellTags->"S6.4.1"]
}, Open  ]],
Cell[170420, 6456, 303, 10, 70, "MathCaption",
  CellTags->{"S6.4.1", "1.59"}],

Cell[CellGroupData[{
Cell[170748, 6470, 118, 2, 70, "Input",
  CellTags->"S6.4.1"],
Cell[170869, 6474, 257, 8, 70, "Output",
  CellTags->"S6.4.1"]
}, Open  ]],
Cell[171141, 6485, 176, 4, 70, "MathCaption",
  CellTags->{"S6.4.1", "1.60"}],

Cell[CellGroupData[{
Cell[171342, 6493, 86, 2, 70, "Input",
  CellTags->"S6.4.1"],
Cell[171431, 6497, 257, 8, 70, "Output",
  CellTags->"S6.4.1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[171737, 6511, 74, 1, 70, "Subsubsection",
  CellTags->{"S6.4.1", "1.61"}],
Cell[171814, 6514, 1049, 26, 70, "Text",
  CellTags->{"S6.4.1", "1.62"}],
Cell[172866, 6542, 16323, 507, 70, "DefinitionBox",
  CellTags->"S6.4.1"],
Cell[189192, 7051, 71, 1, 70, "Caption",
  CellTags->"S6.4.1"],
Cell[189266, 7054, 170, 5, 70, "MathCaption",
  CellTags->{"S6.4.1", "1.63"}],

Cell[CellGroupData[{
Cell[189461, 7063, 129, 5, 70, "Input",
  CellTags->"S6.4.1"],
Cell[189593, 7070, 160, 5, 70, "Output",
  CellTags->"S6.4.1"]
}, Open  ]],
Cell[189768, 7078, 164, 4, 70, "MathCaption",
  CellTags->{"S6.4.1", "1.64"}],

Cell[CellGroupData[{
Cell[189957, 7086, 163, 5, 70, "Input",
  CellTags->"S6.4.1"],
Cell[190123, 7093, 93, 2, 70, "Output",
  CellTags->"S6.4.1"]
}, Open  ]],
Cell[190231, 7098, 215, 4, 70, "MathCaption",
  CellTags->{"S6.4.1", "1.65"}],

Cell[CellGroupData[{
Cell[190471, 7106, 105, 2, 70, "Input",
  CellTags->"S6.4.1"],
Cell[190579, 7110, 91, 2, 70, "Output",
  CellTags->"S6.4.1"]
}, Open  ]],
Cell[190685, 7115, 1337, 49, 70, "MathCaption",
  CellTags->{"S6.4.1", "1.66"}],

Cell[CellGroupData[{
Cell[192047, 7168, 131, 5, 70, "Input",
  CellTags->"S6.4.1"],
Cell[192181, 7175, 78, 2, 70, "Output",
  CellTags->"S6.4.1"]
}, Open  ]],
Cell[192274, 7180, 196, 4, 70, "MathCaption",
  CellTags->{"S6.4.1", "1.67"}],

Cell[CellGroupData[{
Cell[192495, 7188, 117, 2, 70, "Input",
  CellTags->"S6.4.1"],
Cell[192615, 7192, 93, 2, 70, "Output",
  CellTags->"S6.4.1"]
}, Open  ]],
Cell[192723, 7197, 969, 34, 70, "MathCaption",
  CellTags->{"S6.4.1", "1.68"}],

Cell[CellGroupData[{
Cell[193717, 7235, 163, 5, 70, "Input",
  CellTags->"S6.4.1"],
Cell[193883, 7242, 78, 2, 70, "Output",
  CellTags->"S6.4.1"]
}, Open  ]],
Cell[193976, 7247, 165, 4, 70, "Text",
  CellTags->{"S6.4.1", "1.69"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[194178, 7256, 83, 1, 70, "Subsubsection",
  CellTags->{"S6.4.1", "1.70"}],
Cell[194264, 7259, 3657, 111, 70, "DefinitionBox",
  CellTags->"S6.4.1"],
Cell[197924, 7372, 56, 1, 70, "Caption",
  CellTags->"S6.4.1"],
Cell[197983, 7375, 220, 5, 70, "Text",
  CellTags->{"S6.4.1", "1.71"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[198240, 7385, 89, 1, 70, "Subsubsection",
  CellTags->{"S6.4.1", "1.72"}],
Cell[198332, 7388, 714, 20, 70, "Text",
  CellTags->{"S6.4.1", "1.73"}],
Cell[199049, 7410, 525, 15, 70, "DefinitionBox",
  CellTags->"S6.4.1"],
Cell[199577, 7427, 116, 3, 70, "Caption",
  CellTags->"S6.4.1"],
Cell[199696, 7432, 1738, 50, 70, "DefinitionBox",
  CellTags->"S6.4.1"],
Cell[201437, 7484, 75, 1, 70, "Caption",
  CellTags->"S6.4.1"],
Cell[201515, 7487, 128, 3, 70, "MathCaption",
  CellTags->{"S6.4.1", "1.74"}],

Cell[CellGroupData[{
Cell[201668, 7494, 95, 2, 70, "Input",
  CellTags->"S6.4.1"],
Cell[201766, 7498, 292, 9, 70, "Output",
  CellTags->"S6.4.1"]
}, Open  ]],
Cell[202073, 7510, 169, 4, 70, "MathCaption",
  CellTags->{"S6.4.1", "1.75"}],

Cell[CellGroupData[{
Cell[202267, 7518, 98, 2, 70, "Input",
  CellTags->"S6.4.1"],
Cell[202368, 7522, 273, 8, 70, "Output",
  CellTags->"S6.4.1"]
}, Open  ]],
Cell[202656, 7533, 280, 10, 70, "MathCaption",
  CellTags->{"S6.4.1", "1.76"}],

Cell[CellGroupData[{
Cell[202961, 7547, 119, 2, 70, "Input",
  CellTags->"S6.4.1"],
Cell[203083, 7551, 330, 11, 70, "Output",
  CellTags->"S6.4.1"]
}, Open  ]],
Cell[203428, 7565, 176, 4, 70, "MathCaption",
  CellTags->{"S6.4.1", "1.77"}],

Cell[CellGroupData[{
Cell[203629, 7573, 106, 2, 70, "Input",
  CellTags->"S6.4.1"],
Cell[203738, 7577, 346, 11, 70, "Output",
  CellTags->"S6.4.1"]
}, Open  ]],
Cell[204099, 7591, 871, 19, 70, "Text",
  CellTags->{"S6.4.1", "1.78"}]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

