(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     45628,       1720]*)
(*NotebookOutlinePosition[     51215,       1889]*)
(*  CellTagsIndexPosition[     50751,       1867]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Statistics",
 StyleBox["`", "MB"],
 "MultiDiscreteDistributions",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S6.5.1", "1.1"}],

Cell["\<\
This package provides support for several important multivariate discrete \
distributions: the multinomial, negative multinomial, and multiple Poisson \
distributions. \
\>", "Text",
 CellTags->{"S6.5.1", "1.2"}],

Cell[TextData[{
 "Distributions are usually represented in the symbolic form ",
 StyleBox["name", "TI"],
 StyleBox["[", "MR"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["param",
     "TI"], "1"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox[", ", "MR"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["param",
     "TI"], "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox[", \[Ellipsis] ]", "MR"],
 ". When there are many parameters, they may be organized into a list; an \
example of this is the probability vector parameterizing the multinomial and \
negative multinomial distributions. Functions such as ",
 StyleBox["Mean", "MR"],
 ", which give properties of statistical distributions, take the symbolic \
representation of the distribution as an argument. "
}], "Text",
 CellTags->{"S6.5.1", "1.3"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["MultinomialDistribution[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["multinomial distribution with index ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["n",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and probability vector ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["p",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["NegativeMultinomialDistribution[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["negative multinomial distribution with success count ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["n",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and failure probability vector ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["p",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["MultiPoissonDistribution[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox["\[Mu]", "0"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["\[Mu]", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["multiple Poisson distribution with mean vector ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           SubscriptBox["\[Mu]", "0"], "+", 
           SubscriptBox["\[Mu]", "1"]}], ",", 
          RowBox[{
           SubscriptBox["\[Mu]", "0"], "+", 
           SubscriptBox["\[Mu]", "2"]}], ",", "..."}], "}"}], 
        TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[".",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S6.5.1"],

Cell["Discrete multivariate probability distributions.", "Caption",
 CellTags->"S6.5.1"],

Cell[TextData[{
 "A ",
 Cell[BoxData[
  FormBox[
   StyleBox["k",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "\[Hyphen]variate ",
 StyleBox["multinomial distribution", "TB"],
 " with index ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and probability vector ",
 Cell[BoxData[
  FormBox[
   StyleBox["p",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " may be used to describe a series of ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " independent trials, in each of which just one of ",
 Cell[BoxData[
  FormBox[
   StyleBox["k",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " mutually exclusive events is observed with probability ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["p",
     "TI"], 
    StyleBox["i",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["i",
     "TI"], "=", "1", ",", "...", ",", 
    StyleBox["k",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "Text",
 CellTags->{"S6.5.1", "1.4"}],

Cell[TextData[{
 "A ",
 Cell[BoxData[
  FormBox[
   StyleBox["k",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "\[Hyphen]variate ",
 StyleBox["negative multinomial distribution", "TB"],
 " with success count ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and failure probability vector ",
 Cell[BoxData[
  FormBox[
   StyleBox["p",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " may be used to describe a series of independent trials, in each of which \
there may be a success or one of ",
 Cell[BoxData[
  FormBox[
   StyleBox["k",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " mutually exclusive modes of failure. The ",
 Cell[BoxData[
  FormBox[
   StyleBox["i",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " failure mode is observed with probability ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["p",
     "TI"], 
    StyleBox["i",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["i",
     "TI"], "=", "1", ",", "...", ",", 
    StyleBox["k",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", and the trials are discontinued when ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " successes are observed. "
}], "Text",
 CellTags->{"S6.5.1", "1.5"}],

Cell[TextData[{
 "A ",
 Cell[BoxData[
  FormBox[
   StyleBox["k",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "\[Hyphen]variate ",
 StyleBox["multiple Poisson distribution", "TB"],
 " with mean vector ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Mu]", "0"], "+", 
     SubscriptBox["\[Mu]", "1"], ",", "...", ",", 
     SubscriptBox["\[Mu]", "0"], "+", 
     SubscriptBox["\[Mu]", 
      StyleBox["k",
       "TI"]]}], "}"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is a common way to generalize the univariate Poisson distribution. Here \
the random ",
 Cell[BoxData[
  FormBox[
   StyleBox["k",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "\[Hyphen]vector ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["X",
       "TI"], "1"], ",", "...", ",", 
     SubscriptBox[
      StyleBox["X",
       "TI"], 
      StyleBox["k",
       "TI"]]}], "}"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " following this distribution is equivalent to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["Y",
       "TI"], "1"], "+", 
     SubscriptBox[
      StyleBox["Y",
       "TI"], "0"], ",", "...", ",", 
     SubscriptBox[
      StyleBox["Y",
       "TI"], 
      StyleBox["k",
       "TI"]], "+", 
     SubscriptBox[
      StyleBox["Y",
       "TI"], "0"]}], "}"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", where ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["Y",
     "TI"], 
    StyleBox["i",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is a Poisson random variable with mean ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Mu]", 
    StyleBox["i",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["i",
     "TI"], "=", "0", ",", "...", ",", 
    StyleBox["k",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "Text",
 CellTags->{"S6.5.1", "1.6"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["PDF[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["probability density function at ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["x",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", where ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["x",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is vector\[Hyphen]valued",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["CDF[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["cumulative distribution function at ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["x",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Domain[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "range of values or support of the random vector ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Mean[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["mean ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Variance[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["variance ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["StandardDeviation[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["standard deviation ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Skewness[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["coefficient of skewness ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Kurtosis[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["coefficient of kurtosis ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["KurtosisExcess[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["kurtosis excess ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["CharacteristicFunction[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["t", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["characteristic function ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"\[Phi]", 
         RowBox[{"(", 
          StyleBox["t",
           "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", where ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["t",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is vector\[Hyphen]valued",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ExpectedValue[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["expected value of pure function ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["f",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" with respect to the specified distribution ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ExpectedValue[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["expected value of function ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["f",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["x",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" with respect to the specified distribution, where ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["x",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is vector\[Hyphen]valued ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Random[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "pseudorandom vector with specified distribution ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["RandomArray[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dims", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["pseudorandom array with dimensionality ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dims", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", and elements from the specified distribution ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S6.5.1"],

Cell["\<\
Functions of univariate statistical distributions applicable to multivariate \
distributions. \
\>", "Caption",
 CellTags->"S6.5.1"],

Cell[TextData[{
 "In this package distributions are represented in symbolic form. Generally, \
",
 StyleBox["PDF[", "MR"],
 StyleBox["dist", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["x", "TI"],
 StyleBox["]", "MR"],
 " evaluates the density at ",
 Cell[BoxData[
  FormBox[
   StyleBox["x",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " if ",
 Cell[BoxData[
  FormBox[
   StyleBox["x",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is a vector, and otherwise leaves the function in symbolic form. \
Similarly, ",
 StyleBox["CDF[", "MR"],
 StyleBox["dist", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["x", "TI"],
 StyleBox["]", "MR"],
 " gives the cumulative density and ",
 StyleBox["CharacteristicFunction[", "MR"],
 StyleBox["dist", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["t", "TI"],
 StyleBox["]", "MR"],
 " gives the characteristic function of the specified distribution. "
}], "Text",
 CellTags->{"S6.5.1", "1.7"}],

Cell[TextData[{
 "Note that for a vector\[Hyphen]valued distribution, functions like ",
 StyleBox["Mean", "MR"],
 ", ",
 StyleBox["Variance", "MR"],
 ", and ",
 StyleBox["Kurtosis", "MR"],
 " give a vector\[Hyphen]valued result since they are applied to each \
coordinate of the vector. "
}], "Text",
 CellTags->{"S6.5.1", "1.8"}],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S6.5.1", "1.9"}],

Cell["<<Statistics`MultiDiscreteDistributions`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S6.5.1"],

Cell["\<\
Here is a symbolic representation of a bivariate multinomial distribution. \
\>", "MathCaption",
 CellTags->{"S6.5.1", "1.10"}],

Cell[CellGroupData[{

Cell["\<\
(p = {.4, .6};
mdist = MultinomialDistribution[10, p])\
\>", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S6.5.1"],

Cell[BoxData[
 RowBox[{"MultinomialDistribution", "[", 
  RowBox[{"10", ",", 
   TagBox[
    RowBox[{"{", 
     RowBox[{"0.4`", ",", "0.6`"}], "}"}],
    Short]}], "]"}]], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S6.5.1"]
}, Open  ]],

Cell["This gives its probability density function. ", "MathCaption",
 CellTags->{"S6.5.1", "1.11"}],

Cell[CellGroupData[{

Cell["pdf = PDF[mdist, {x1, x2}]", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S6.5.1"],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x1", "+", "x2"}], "\[Equal]", "10"}], ",", 
   RowBox[{
    SuperscriptBox["0.4`", "x1"], " ", 
    SuperscriptBox["0.6`", "x2"], " ", 
    RowBox[{"Multinomial", "[", 
     RowBox[{"x1", ",", "x2"}], "]"}]}], ",", "0"}], "]"}]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S6.5.1"]
}, Open  ]],

Cell["\<\
You can make a plot of the density to observe its distribution. \
\>", "MathCaption",
 CellTags->{"S6.5.1", "1.12"}],

Cell[CellGroupData[{

Cell["\<\
(r = Range[0, 10];  t = Transpose[{r + .5, r}];
 ListDensityPlot[
 Table[pdf, {x1, 0, 10}, {x2, 0, 10}],
 FrameTicks -> {t, t}])\
\>", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S6.5.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.0874126 0.0192308 0.0874126 [
[.06294 -0.0125 -3 -9 ]
[.06294 -0.0125 3 0 ]
[.15035 -0.0125 -3 -9 ]
[.15035 -0.0125 3 0 ]
[.23776 -0.0125 -3 -9 ]
[.23776 -0.0125 3 0 ]
[.32517 -0.0125 -3 -9 ]
[.32517 -0.0125 3 0 ]
[.41259 -0.0125 -3 -9 ]
[.41259 -0.0125 3 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.58741 -0.0125 -3 -9 ]
[.58741 -0.0125 3 0 ]
[.67483 -0.0125 -3 -9 ]
[.67483 -0.0125 3 0 ]
[.76224 -0.0125 -3 -9 ]
[.76224 -0.0125 3 0 ]
[.84965 -0.0125 -3 -9 ]
[.84965 -0.0125 3 0 ]
[.93706 -0.0125 -6 -9 ]
[.93706 -0.0125 6 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .06294 -6 -4.5 ]
[-0.0125 .06294 0 4.5 ]
[-0.0125 .15035 -6 -4.5 ]
[-0.0125 .15035 0 4.5 ]
[-0.0125 .23776 -6 -4.5 ]
[-0.0125 .23776 0 4.5 ]
[-0.0125 .32517 -6 -4.5 ]
[-0.0125 .32517 0 4.5 ]
[-0.0125 .41259 -6 -4.5 ]
[-0.0125 .41259 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .58741 -6 -4.5 ]
[-0.0125 .58741 0 4.5 ]
[-0.0125 .67483 -6 -4.5 ]
[-0.0125 .67483 0 4.5 ]
[-0.0125 .76224 -6 -4.5 ]
[-0.0125 .76224 0 4.5 ]
[-0.0125 .84965 -6 -4.5 ]
[-0.0125 .84965 0 4.5 ]
[-0.0125 .93706 -12 -4.5 ]
[-0.0125 .93706 0 4.5 ]
[ 0 0 -0.125 0 ]
[.06294 1.0125 -3 0 ]
[.06294 1.0125 3 9 ]
[.15035 1.0125 -3 0 ]
[.15035 1.0125 3 9 ]
[.23776 1.0125 -3 0 ]
[.23776 1.0125 3 9 ]
[.32517 1.0125 -3 0 ]
[.32517 1.0125 3 9 ]
[.41259 1.0125 -3 0 ]
[.41259 1.0125 3 9 ]
[.5 1.0125 -3 0 ]
[.5 1.0125 3 9 ]
[.58741 1.0125 -3 0 ]
[.58741 1.0125 3 9 ]
[.67483 1.0125 -3 0 ]
[.67483 1.0125 3 9 ]
[.76224 1.0125 -3 0 ]
[.76224 1.0125 3 9 ]
[.84965 1.0125 -3 0 ]
[.84965 1.0125 3 9 ]
[.93706 1.0125 -6 0 ]
[.93706 1.0125 6 9 ]
[ 0 1 .125 0 ]
[1.0125 .06294 0 -4.5 ]
[1.0125 .06294 6 4.5 ]
[1.0125 .15035 0 -4.5 ]
[1.0125 .15035 6 4.5 ]
[1.0125 .23776 0 -4.5 ]
[1.0125 .23776 6 4.5 ]
[1.0125 .32517 0 -4.5 ]
[1.0125 .32517 6 4.5 ]
[1.0125 .41259 0 -4.5 ]
[1.0125 .41259 6 4.5 ]
[1.0125 .5 0 -4.5 ]
[1.0125 .5 6 4.5 ]
[1.0125 .58741 0 -4.5 ]
[1.0125 .58741 6 4.5 ]
[1.0125 .67483 0 -4.5 ]
[1.0125 .67483 6 4.5 ]
[1.0125 .76224 0 -4.5 ]
[1.0125 .76224 6 4.5 ]
[1.0125 .84965 0 -4.5 ]
[1.0125 .84965 6 4.5 ]
[1.0125 .93706 0 -4.5 ]
[1.0125 .93706 12 4.5 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.06294 0 m
.06294 .00625 L
s
[(0)] .06294 -0.0125 0 1 Mshowa
.15035 0 m
.15035 .00625 L
s
[(1)] .15035 -0.0125 0 1 Mshowa
.23776 0 m
.23776 .00625 L
s
[(2)] .23776 -0.0125 0 1 Mshowa
.32517 0 m
.32517 .00625 L
s
[(3)] .32517 -0.0125 0 1 Mshowa
.41259 0 m
.41259 .00625 L
s
[(4)] .41259 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(5)] .5 -0.0125 0 1 Mshowa
.58741 0 m
.58741 .00625 L
s
[(6)] .58741 -0.0125 0 1 Mshowa
.67483 0 m
.67483 .00625 L
s
[(7)] .67483 -0.0125 0 1 Mshowa
.76224 0 m
.76224 .00625 L
s
[(8)] .76224 -0.0125 0 1 Mshowa
.84965 0 m
.84965 .00625 L
s
[(9)] .84965 -0.0125 0 1 Mshowa
.93706 0 m
.93706 .00625 L
s
[(10)] .93706 -0.0125 0 1 Mshowa
0 0 m
1 0 L
s
0 .06294 m
.00625 .06294 L
s
[(0)] -0.0125 .06294 1 0 Mshowa
0 .15035 m
.00625 .15035 L
s
[(1)] -0.0125 .15035 1 0 Mshowa
0 .23776 m
.00625 .23776 L
s
[(2)] -0.0125 .23776 1 0 Mshowa
0 .32517 m
.00625 .32517 L
s
[(3)] -0.0125 .32517 1 0 Mshowa
0 .41259 m
.00625 .41259 L
s
[(4)] -0.0125 .41259 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(5)] -0.0125 .5 1 0 Mshowa
0 .58741 m
.00625 .58741 L
s
[(6)] -0.0125 .58741 1 0 Mshowa
0 .67483 m
.00625 .67483 L
s
[(7)] -0.0125 .67483 1 0 Mshowa
0 .76224 m
.00625 .76224 L
s
[(8)] -0.0125 .76224 1 0 Mshowa
0 .84965 m
.00625 .84965 L
s
[(9)] -0.0125 .84965 1 0 Mshowa
0 .93706 m
.00625 .93706 L
s
[(10)] -0.0125 .93706 1 0 Mshowa
0 0 m
0 1 L
s
.06294 .99375 m
.06294 1 L
s
[(0)] .06294 1.0125 0 -1 Mshowa
.15035 .99375 m
.15035 1 L
s
[(1)] .15035 1.0125 0 -1 Mshowa
.23776 .99375 m
.23776 1 L
s
[(2)] .23776 1.0125 0 -1 Mshowa
.32517 .99375 m
.32517 1 L
s
[(3)] .32517 1.0125 0 -1 Mshowa
.41259 .99375 m
.41259 1 L
s
[(4)] .41259 1.0125 0 -1 Mshowa
.5 .99375 m
.5 1 L
s
[(5)] .5 1.0125 0 -1 Mshowa
.58741 .99375 m
.58741 1 L
s
[(6)] .58741 1.0125 0 -1 Mshowa
.67483 .99375 m
.67483 1 L
s
[(7)] .67483 1.0125 0 -1 Mshowa
.76224 .99375 m
.76224 1 L
s
[(8)] .76224 1.0125 0 -1 Mshowa
.84965 .99375 m
.84965 1 L
s
[(9)] .84965 1.0125 0 -1 Mshowa
.93706 .99375 m
.93706 1 L
s
[(10)] .93706 1.0125 0 -1 Mshowa
0 1 m
1 1 L
s
.99375 .06294 m
1 .06294 L
s
[(0)] 1.0125 .06294 -1 0 Mshowa
.99375 .15035 m
1 .15035 L
s
[(1)] 1.0125 .15035 -1 0 Mshowa
.99375 .23776 m
1 .23776 L
s
[(2)] 1.0125 .23776 -1 0 Mshowa
.99375 .32517 m
1 .32517 L
s
[(3)] 1.0125 .32517 -1 0 Mshowa
.99375 .41259 m
1 .41259 L
s
[(4)] 1.0125 .41259 -1 0 Mshowa
.99375 .5 m
1 .5 L
s
[(5)] 1.0125 .5 -1 0 Mshowa
.99375 .58741 m
1 .58741 L
s
[(6)] 1.0125 .58741 -1 0 Mshowa
.99375 .67483 m
1 .67483 L
s
[(7)] 1.0125 .67483 -1 0 Mshowa
.99375 .76224 m
1 .76224 L
s
[(8)] 1.0125 .76224 -1 0 Mshowa
.99375 .84965 m
1 .84965 L
s
[(9)] 1.0125 .84965 -1 0 Mshowa
.99375 .93706 m
1 .93706 L
s
[(10)] 1.0125 .93706 -1 0 Mshowa
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
11 string
11 11 8 [11 0 0 11 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
0000000000000000000006
0000000000000000002900
00000000000000007B0000
00000000000000DB000000
000000000000FF00000000
0000000000CC0000000000
0000000071000000000000
0000002B00000000000000
00000A0000000000000000
0001000000000000000000
0000000000000000000000
pop
P
% End of image
.01923 .01923 m
.01923 .98077 L
s
.10664 .01923 m
.10664 .98077 L
s
.19406 .01923 m
.19406 .98077 L
s
.28147 .01923 m
.28147 .98077 L
s
.36888 .01923 m
.36888 .98077 L
s
.45629 .01923 m
.45629 .98077 L
s
.54371 .01923 m
.54371 .98077 L
s
.63112 .01923 m
.63112 .98077 L
s
.71853 .01923 m
.71853 .98077 L
s
.80594 .01923 m
.80594 .98077 L
s
.89336 .01923 m
.89336 .98077 L
s
.98077 .01923 m
.98077 .98077 L
s
.01923 .01923 m
.98077 .01923 L
s
.01923 .10664 m
.98077 .10664 L
s
.01923 .19406 m
.98077 .19406 L
s
.01923 .28147 m
.98077 .28147 L
s
.01923 .36888 m
.98077 .36888 L
s
.01923 .45629 m
.98077 .45629 L
s
.01923 .54371 m
.98077 .54371 L
s
.01923 .63112 m
.98077 .63112 L
s
.01923 .71853 m
.98077 .71853 L
s
.01923 .80594 m
.98077 .80594 L
s
.01923 .89336 m
.98077 .89336 L
s
.01923 .98077 m
.98077 .98077 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S6.5.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "DensityGraphics", "\[SkeletonIndicator]"}],
  
  False,
  Editable->False]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S6.5.1"]
}, Open  ]],

Cell[TextData[{
 "Here is the probability of the distribution in the region ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     StyleBox["x",
      "TI"], "1"], "<", "6", "\[Intersection]", 
    SubscriptBox[
     StyleBox["x",
      "TI"], "2"], "<", "7"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S6.5.1", "1.13"}],

Cell[CellGroupData[{

Cell["CDF[mdist, {6, 7}]", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S6.5.1"],

Cell[BoxData["0.7779483648000001`"], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S6.5.1"]
}, Open  ]],

Cell["\<\
This gives the mean vectors of the trivariate versions of the three \
distributions. \
\>", "MathCaption",
 CellTags->{"S6.5.1", "1.14"}],

Cell[CellGroupData[{

Cell["\<\
{Mean[MultinomialDistribution[n, {p1, p2, p3}]],
Mean[NegativeMultinomialDistribution[n, {p1, p2, p3}]],
Mean[MultiPoissonDistribution[mu0, {mu1, mu2, mu3}]]}\
\>", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S6.5.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"n", " ", "p1"}], ",", 
     RowBox[{"n", " ", "p2"}], ",", 
     RowBox[{"n", " ", "p3"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"n", " ", "p1"}], 
      RowBox[{"1", "-", "p1", "-", "p2", "-", "p3"}]], ",", 
     FractionBox[
      RowBox[{"n", " ", "p2"}], 
      RowBox[{"1", "-", "p1", "-", "p2", "-", "p3"}]], ",", 
     FractionBox[
      RowBox[{"n", " ", "p3"}], 
      RowBox[{"1", "-", "p1", "-", "p2", "-", "p3"}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"mu0", "+", "mu1"}], ",", 
     RowBox[{"mu0", "+", "mu2"}], ",", 
     RowBox[{"mu0", "+", "mu3"}]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S6.5.1"]
}, Open  ]],

Cell["Here is a sample from each of the distributions. ", "MathCaption",
 CellTags->{"S6.5.1", "1.15"}],

Cell[CellGroupData[{

Cell["\<\
{Random[MultinomialDistribution[10, {.2, .3, .5}]],
Random[NegativeMultinomialDistribution[5, {2/15, 1/5, 1/3}]],
Random[MultiPoissonDistribution[1, {1, 2, 4}]]}\
\>", "Input",
 CellLabel->"In[7]:= ",
 CellTags->"S6.5.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "4", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3", ",", "9"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[7]= ",
 CellTags->"S6.5.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["CovarianceMatrix[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "covariance matrix of the specified distribution ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["CorrelationMatrix[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "correlation matrix of the specified distribution ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["MultivariateSkewness[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "multivariate coefficient of skewness ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["MultivariateKurtosis[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "multivariate kurtosis coefficient ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["MultivariateKurtosisExcess[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "multivariate kurtosis excess ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S6.5.1"],

Cell["\<\
Functions of vector\[Hyphen]valued multivariate statistical distributions.\
\>", "Caption",
 CellTags->"S6.5.1"],

Cell["\<\
The covariance for the bivariate form of the distributions is given here. The \
covariance is negative for the multinomial distribution, but positive for the \
negative multinomial and multiple Poisson. \
\>", "MathCaption",
 CellTags->{"S6.5.1", "1.16"}],

Cell[CellGroupData[{

Cell["\<\
{CovarianceMatrix[
   MultinomialDistribution[n, {p1, p2}]
 ][[1, 2]],
CovarianceMatrix[
   NegativeMultinomialDistribution[n, {p1, p2}]
 ][[1, 2]],
CovarianceMatrix[
   MultiPoissonDistribution[mu0, {mu1, mu2}]
 ][[1, 2]]}\
\>", "Input",
 CellLabel->"In[8]:= ",
 CellTags->"S6.5.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "n"}], " ", "p1", " ", "p2"}], ",", 
   FractionBox[
    RowBox[{"n", " ", "p1", " ", "p2"}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", "p1", "-", "p2"}], ")"}], "2"]], ",", "mu0"}], 
  "}"}]], "Output",
 CellLabel->"Out[8]= ",
 CellTags->"S6.5.1"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S6.5.1"->{
    Cell[1776, 53, 152, 6, 36, "Subsection",
      CellTags->{"S6.5.1", "1.1"}],
    Cell[1931, 61, 222, 5, 40, "Text",
      CellTags->{"S6.5.1", "1.2"}],
    Cell[2156, 68, 923, 25, 89, "Text",
      CellTags->{"S6.5.1", "1.3"}],
    Cell[3082, 95, 5172, 155, 142, "DefinitionBox",
      CellTags->"S6.5.1"],
    Cell[8257, 252, 88, 1, 15, "Caption",
      CellTags->"S6.5.1"],
    Cell[8348, 255, 1425, 53, 57, "Text",
      CellTags->{"S6.5.1", "1.4"}],
    Cell[9776, 310, 1848, 64, 73, "Text",
      CellTags->{"S6.5.1", "1.5"}],
    Cell[11627, 376, 2322, 89, 72, "Text",
      CellTags->{"S6.5.1", "1.6"}],
    Cell[13952, 467, 14363, 440, 366, "DefinitionBox",
      CellTags->"S6.5.1"],
    Cell[28318, 909, 142, 4, 70, "Caption",
      CellTags->"S6.5.1"],
    Cell[28463, 915, 1014, 35, 70, "Text",
      CellTags->{"S6.5.1", "1.7"}],
    Cell[29480, 952, 330, 10, 70, "Text",
      CellTags->{"S6.5.1", "1.8"}],
    Cell[29813, 964, 77, 1, 70, "MathCaption",
      CellTags->{"S6.5.1", "1.9"}],
    Cell[29893, 967, 102, 2, 70, "Input",
      CellTags->"S6.5.1"],
    Cell[29998, 971, 137, 3, 70, "MathCaption",
      CellTags->{"S6.5.1", "1.10"}],
    Cell[30160, 978, 124, 5, 70, "Input",
      CellTags->"S6.5.1"],
    Cell[30287, 985, 226, 8, 70, "Output",
      CellTags->"S6.5.1"],
    Cell[30528, 996, 99, 1, 70, "MathCaption",
      CellTags->{"S6.5.1", "1.11"}],
    Cell[30652, 1001, 88, 2, 70, "Input",
      CellTags->"S6.5.1"],
    Cell[30743, 1005, 355, 11, 70, "Output",
      CellTags->"S6.5.1"],
    Cell[31113, 1019, 126, 3, 70, "MathCaption",
      CellTags->{"S6.5.1", "1.12"}],
    Cell[31264, 1026, 198, 7, 70, "Input",
      CellTags->"S6.5.1"],
    Cell[31465, 1035, 6713, 419, 70, 6643, 416, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S6.5.1"],
    Cell[38181, 1456, 189, 7, 70, "Output",
      CellTags->"S6.5.1"],
    Cell[38385, 1466, 408, 14, 70, "MathCaption",
      CellTags->{"S6.5.1", "1.13"}],
    Cell[38818, 1484, 80, 2, 70, "Input",
      CellTags->"S6.5.1"],
    Cell[38901, 1488, 91, 2, 70, "Output",
      CellTags->"S6.5.1"],
    Cell[39007, 1493, 147, 4, 70, "MathCaption",
      CellTags->{"S6.5.1", "1.14"}],
    Cell[39179, 1501, 228, 6, 70, "Input",
      CellTags->"S6.5.1"],
    Cell[39410, 1509, 782, 25, 70, "Output",
      CellTags->"S6.5.1"],
    Cell[40207, 1537, 103, 1, 70, "MathCaption",
      CellTags->{"S6.5.1", "1.15"}],
    Cell[40335, 1542, 231, 6, 70, "Input",
      CellTags->"S6.5.1"],
    Cell[40569, 1550, 305, 10, 70, "Output",
      CellTags->"S6.5.1"],
    Cell[40889, 1563, 3658, 111, 70, "DefinitionBox",
      CellTags->"S6.5.1"],
    Cell[44550, 1676, 122, 3, 70, "Caption",
      CellTags->"S6.5.1"],
    Cell[44675, 1681, 265, 5, 70, "MathCaption",
      CellTags->{"S6.5.1", "1.16"}],
    Cell[44965, 1690, 293, 12, 70, "Input",
      CellTags->"S6.5.1"],
    Cell[45261, 1704, 339, 12, 70, "Output",
      CellTags->"S6.5.1"]},
  "1.1"->{
    Cell[1776, 53, 152, 6, 36, "Subsection",
      CellTags->{"S6.5.1", "1.1"}]},
  "1.2"->{
    Cell[1931, 61, 222, 5, 40, "Text",
      CellTags->{"S6.5.1", "1.2"}]},
  "1.3"->{
    Cell[2156, 68, 923, 25, 89, "Text",
      CellTags->{"S6.5.1", "1.3"}]},
  "1.4"->{
    Cell[8348, 255, 1425, 53, 57, "Text",
      CellTags->{"S6.5.1", "1.4"}]},
  "1.5"->{
    Cell[9776, 310, 1848, 64, 73, "Text",
      CellTags->{"S6.5.1", "1.5"}]},
  "1.6"->{
    Cell[11627, 376, 2322, 89, 72, "Text",
      CellTags->{"S6.5.1", "1.6"}]},
  "1.7"->{
    Cell[28463, 915, 1014, 35, 70, "Text",
      CellTags->{"S6.5.1", "1.7"}]},
  "1.8"->{
    Cell[29480, 952, 330, 10, 70, "Text",
      CellTags->{"S6.5.1", "1.8"}]},
  "1.9"->{
    Cell[29813, 964, 77, 1, 70, "MathCaption",
      CellTags->{"S6.5.1", "1.9"}]},
  "1.10"->{
    Cell[29998, 971, 137, 3, 70, "MathCaption",
      CellTags->{"S6.5.1", "1.10"}]},
  "1.11"->{
    Cell[30528, 996, 99, 1, 70, "MathCaption",
      CellTags->{"S6.5.1", "1.11"}]},
  "1.12"->{
    Cell[31113, 1019, 126, 3, 70, "MathCaption",
      CellTags->{"S6.5.1", "1.12"}]},
  "1.13"->{
    Cell[38385, 1466, 408, 14, 70, "MathCaption",
      CellTags->{"S6.5.1", "1.13"}]},
  "1.14"->{
    Cell[39007, 1493, 147, 4, 70, "MathCaption",
      CellTags->{"S6.5.1", "1.14"}]},
  "1.15"->{
    Cell[40207, 1537, 103, 1, 70, "MathCaption",
      CellTags->{"S6.5.1", "1.15"}]},
  "1.16"->{
    Cell[44675, 1681, 265, 5, 70, "MathCaption",
      CellTags->{"S6.5.1", "1.16"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S6.5.1", 46250, 1736},
  {"1.1", 49231, 1815},
  {"1.2", 49324, 1818},
  {"1.3", 49411, 1821},
  {"1.4", 49499, 1824},
  {"1.5", 49589, 1827},
  {"1.6", 49679, 1830},
  {"1.7", 49770, 1833},
  {"1.8", 49861, 1836},
  {"1.9", 49951, 1839},
  {"1.10", 50047, 1842},
  {"1.11", 50145, 1845},
  {"1.12", 50242, 1848},
  {"1.13", 50341, 1851},
  {"1.14", 50441, 1854},
  {"1.15", 50540, 1857},
  {"1.16", 50639, 1860}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 152, 6, 36, "Subsection",
  CellTags->{"S6.5.1", "1.1"}],
Cell[1931, 61, 222, 5, 40, "Text",
  CellTags->{"S6.5.1", "1.2"}],
Cell[2156, 68, 923, 25, 89, "Text",
  CellTags->{"S6.5.1", "1.3"}],
Cell[3082, 95, 5172, 155, 142, "DefinitionBox",
  CellTags->"S6.5.1"],
Cell[8257, 252, 88, 1, 15, "Caption",
  CellTags->"S6.5.1"],
Cell[8348, 255, 1425, 53, 57, "Text",
  CellTags->{"S6.5.1", "1.4"}],
Cell[9776, 310, 1848, 64, 73, "Text",
  CellTags->{"S6.5.1", "1.5"}],
Cell[11627, 376, 2322, 89, 72, "Text",
  CellTags->{"S6.5.1", "1.6"}],
Cell[13952, 467, 14363, 440, 366, "DefinitionBox",
  CellTags->"S6.5.1"],
Cell[28318, 909, 142, 4, 70, "Caption",
  CellTags->"S6.5.1"],
Cell[28463, 915, 1014, 35, 70, "Text",
  CellTags->{"S6.5.1", "1.7"}],
Cell[29480, 952, 330, 10, 70, "Text",
  CellTags->{"S6.5.1", "1.8"}],
Cell[29813, 964, 77, 1, 70, "MathCaption",
  CellTags->{"S6.5.1", "1.9"}],
Cell[29893, 967, 102, 2, 70, "Input",
  CellTags->"S6.5.1"],
Cell[29998, 971, 137, 3, 70, "MathCaption",
  CellTags->{"S6.5.1", "1.10"}],

Cell[CellGroupData[{
Cell[30160, 978, 124, 5, 70, "Input",
  CellTags->"S6.5.1"],
Cell[30287, 985, 226, 8, 70, "Output",
  CellTags->"S6.5.1"]
}, Open  ]],
Cell[30528, 996, 99, 1, 70, "MathCaption",
  CellTags->{"S6.5.1", "1.11"}],

Cell[CellGroupData[{
Cell[30652, 1001, 88, 2, 70, "Input",
  CellTags->"S6.5.1"],
Cell[30743, 1005, 355, 11, 70, "Output",
  CellTags->"S6.5.1"]
}, Open  ]],
Cell[31113, 1019, 126, 3, 70, "MathCaption",
  CellTags->{"S6.5.1", "1.12"}],

Cell[CellGroupData[{
Cell[31264, 1026, 198, 7, 70, "Input",
  CellTags->"S6.5.1"],
Cell[31465, 1035, 6713, 419, 70, 6643, 416, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S6.5.1"],
Cell[38181, 1456, 189, 7, 70, "Output",
  CellTags->"S6.5.1"]
}, Open  ]],
Cell[38385, 1466, 408, 14, 70, "MathCaption",
  CellTags->{"S6.5.1", "1.13"}],

Cell[CellGroupData[{
Cell[38818, 1484, 80, 2, 70, "Input",
  CellTags->"S6.5.1"],
Cell[38901, 1488, 91, 2, 70, "Output",
  CellTags->"S6.5.1"]
}, Open  ]],
Cell[39007, 1493, 147, 4, 70, "MathCaption",
  CellTags->{"S6.5.1", "1.14"}],

Cell[CellGroupData[{
Cell[39179, 1501, 228, 6, 70, "Input",
  CellTags->"S6.5.1"],
Cell[39410, 1509, 782, 25, 70, "Output",
  CellTags->"S6.5.1"]
}, Open  ]],
Cell[40207, 1537, 103, 1, 70, "MathCaption",
  CellTags->{"S6.5.1", "1.15"}],

Cell[CellGroupData[{
Cell[40335, 1542, 231, 6, 70, "Input",
  CellTags->"S6.5.1"],
Cell[40569, 1550, 305, 10, 70, "Output",
  CellTags->"S6.5.1"]
}, Open  ]],
Cell[40889, 1563, 3658, 111, 70, "DefinitionBox",
  CellTags->"S6.5.1"],
Cell[44550, 1676, 122, 3, 70, "Caption",
  CellTags->"S6.5.1"],
Cell[44675, 1681, 265, 5, 70, "MathCaption",
  CellTags->{"S6.5.1", "1.16"}],

Cell[CellGroupData[{
Cell[44965, 1690, 293, 12, 70, "Input",
  CellTags->"S6.5.1"],
Cell[45261, 1704, 339, 12, 70, "Output",
  CellTags->"S6.5.1"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

