(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    191184,       8154]*)
(*NotebookOutlinePosition[    200390,       8419]*)
(*  CellTagsIndexPosition[    199701,       8389]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  "Statistics",
  StyleBox["`", "MB"],
  "MultinormalDistribution",
  StyleBox["`", "MB"]
}], "Subsection",
  CellTags->{"S6.6.1", "1.1"}],

Cell[TextData[{
  "The most commonly used probability distributions for multivariate data \
analysis are those derived from the multinormal (multivariate Gaussian) \
distribution. This package contains multinormal, multivariate Student ",
  Cell[BoxData[
      FormBox[
        StyleBox["t",
          "TI"], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  ", Wishart, Hotelling ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["T",
            "TI"], "2"], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  ", and quadratic form distributions. "
}], "Text",
  CellTags->{"S6.6.1", "1.2"}],

Cell[TextData[{
  "Distributions are usually represented in the symbolic form ",
  StyleBox["name", "TI"],
  StyleBox["[", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["param",
            "TI"], "1"], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  StyleBox[", ", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["param",
            "TI"], "2"], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  StyleBox[", \[Ellipsis] ]", "MR"],
  ". When there are many parameters, they may be organized into lists, as in \
the case of ",
  StyleBox["QuadraticFormDistribution", "MR"],
  ". Functions such as ",
  StyleBox["Mean", "MR"],
  ", which give properties of statistical distributions, take the symbolic \
representation of the distribution as an argument. "
}], "Text",
  CellTags->{"S6.6.1", "1.3"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["MultinormalDistribution[", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["mu", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[", ", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["sigma", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["]", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[{
              StyleBox[
              "multinormal (multivariate Gaussian) distribution with mean \
vector ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  \(TraditionalForm\`\[Mu]\)], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[" and covariance matrix ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  \(TraditionalForm\`\[CapitalSigma]\)], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[{
              StyleBox["MultivariateTDistribution[", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["r", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[", ", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["m", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["]", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[{
              StyleBox["multivariate Student ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    StyleBox["t",
                      "TI"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[" distribution with correlation matrix ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    StyleBox["R",
                      "TB"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[" and ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    StyleBox["m",
                      "TI"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[" degrees of freedom ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[{
              StyleBox["WishartDistribution[", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["sigma", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[", ", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["m", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["]", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[{
              StyleBox["Wishart distribution with scale matrix ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  \(TraditionalForm\`\[CapitalSigma]\)], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[" and ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    StyleBox["m",
                      "TI"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[" degrees of freedom ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[{
              StyleBox["HotellingTSquareDistribution[", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["p", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[", ", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["m", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["]", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[{
              StyleBox["Hotelling ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    SuperscriptBox[
                      StyleBox["T",
                        "TI"], "2"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[" distribution with dimensionality parameter ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    StyleBox["p",
                      "TI"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[" and ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    StyleBox["m",
                      "TI"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[" degrees of freedom ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[{
              StyleBox["QuadraticFormDistribution[{", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["A", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[", ", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["b", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[", ", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["c", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["}, {", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["mu", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[", ", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["sigma", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["}]", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[{
              StyleBox[
              "distribution of the quadratic form of a multinormal, where ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    StyleBox["A",
                      "TI"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[", ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    StyleBox["b",
                      "TI"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[", and ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    StyleBox["c",
                      "TI"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[" are the parameters of the quadratic form ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      SuperscriptBox[
                        StyleBox["z",
                          "TI"], "\[Prime]"], 
                      StyleBox["A",
                        "TI"], 
                      StyleBox["z",
                        "TI"], "+", 
                      SuperscriptBox[
                        StyleBox["b",
                          "TI"], "\[Prime]"], 
                      StyleBox["z",
                        "TI"], "+", 
                      StyleBox["c",
                        "TI"]}], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[", and ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    StyleBox["z",
                      "TI"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[" is distributed multinormally, with mean vector ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  \(TraditionalForm\`\[Mu]\)], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[" and covariance matrix ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  \(TraditionalForm\`\[CapitalSigma]\)], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S6.6.1"],

Cell["\<\
Standard probability distributions derived from the multivariate \
Gaussian distribution.\
\>", "Caption",
  CellTags->"S6.6.1"],

Cell[TextData[{
  "A ",
  Cell[BoxData[
      FormBox[
        StyleBox["p",
          "TI"], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  "\[Hyphen]variate ",
  StyleBox["multinormal distribution", "TB",
    GridBoxOptions->{RowSpacings->0.4,
    RowLines->False}],
  " with mean vector ",
  Cell[BoxData[
      \(TraditionalForm\`\[Mu]\)], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " and covariance matrix ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalSigma]\)], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " is denoted ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["N",
              "TI"], 
            StyleBox["p",
              "TI"]], 
          RowBox[{"(", 
            RowBox[{"\[Mu]", ",", Cell[BoxData[
                  \(\[CapitalSigma]\)], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}]}], ")"}]}], 
        TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  ". If ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["X",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["i",
            "TI"], "=", "1", ",", "\[Ellipsis]", ",", 
          StyleBox["m",
            "TI"]}], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  ", is distributed ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["N",
              "TI"], 
            StyleBox["p",
              "TI"]], 
          RowBox[{"(", 
            RowBox[{\(0\& \[RightVector] \), ",", Cell[BoxData[
                  \(\[CapitalSigma]\)], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}]}], ")"}]}], 
        TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " (where ",
  Cell[BoxData[
      \(TraditionalForm\`\(0\& \[RightVector] \)\)], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " is the zero vector), and ",
  StyleBox["X", "TB",
    GridBoxOptions->{RowSpacings->0.4,
    RowLines->False}],
  " denotes the ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["m",
            "TI"], "\[Cross]", 
          StyleBox["p",
            "TI"]}], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " data matrix composed of the ",
  Cell[BoxData[
      FormBox[
        StyleBox["m",
          "TI"], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " row vectors ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["X",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  ", then the ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["p",
            "TI"], "\[Cross]", 
          StyleBox["p",
            "TI"]}], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " matrix ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox[
            StyleBox["X",
              "TB"], "\[Prime]"], 
          StyleBox["X",
            "TB"]}], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " has a ",
  StyleBox["Wishart distribution", "TB",
    GridBoxOptions->{RowSpacings->0.4,
    RowLines->False}],
  " with scale matrix ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalSigma]\)], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " and degrees of freedom parameter ",
  Cell[BoxData[
      FormBox[
        StyleBox["m",
          "TI"], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  ", denoted ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["W",
              "TI"], 
            StyleBox["p",
              "TI"]], 
          RowBox[{"(", 
            RowBox[{Cell[BoxData[
                  \(\[CapitalSigma]\)], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}], ",", 
              StyleBox["m",
                "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  ". The Wishart distribution is most typically used when describing the \
covariance matrix of multinormal samples. "
}], "Text",
  CellTags->{"S6.6.1", "1.4"}],

Cell[TextData[{
  "A vector that has a ",
  StyleBox["multivariate Student ", "TB",
    GridBoxOptions->{RowSpacings->0.4,
    RowLines->False}],
  StyleBox["t", "TBI"],
  StyleBox[" distribution", "TB",
    GridBoxOptions->{RowSpacings->0.4,
    RowLines->False}],
  " can also be written as a function of a multinormal random vector. Let ",
  Cell[BoxData[
      FormBox[
        StyleBox["X",
          "TI"], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " be a standardized multinormal vector with covariance matrix ",
  Cell[BoxData[
      FormBox[
        StyleBox["R",
          "TB"], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " and let ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["S",
            "TI"], "2"], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " be a chi\[Hyphen]square variable with ",
  Cell[BoxData[
      FormBox[
        StyleBox["m",
          "TI"], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " degrees of freedom. (Note that since ",
  Cell[BoxData[
      FormBox[
        StyleBox["X",
          "TI"], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " is standardized, ",
  Cell[BoxData[
      \(TraditionalForm\`\(0\& \[RightVector] \)\)], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " is the mean vector of ",
  Cell[BoxData[
      FormBox[
        StyleBox["X",
          "TI"], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " and ",
  Cell[BoxData[
      FormBox[
        StyleBox["R",
          "TB"], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " is also the correlation matrix of ",
  Cell[BoxData[
      FormBox[
        StyleBox["X",
          "TI"], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  ".) Then ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["X",
            "TI"], "/", 
          StyleBox["S",
            "TI"], "/", 
          SqrtBox[
            StyleBox["m",
              "TI"]]}], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " has a multivariate ",
  Cell[BoxData[
      FormBox[
        StyleBox["t",
          "TI"], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " distribution with correlation matrix ",
  Cell[BoxData[
      FormBox[
        StyleBox["R",
          "TB"], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " and ",
  Cell[BoxData[
      FormBox[
        StyleBox["m",
          "TI"], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " degrees of freedom, denoted ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["t",
            "TI"], 
          RowBox[{"(", 
            RowBox[{
              StyleBox["R",
                "TB"], ",", 
              StyleBox["m",
                "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  ". The multivariate Student ",
  Cell[BoxData[
      FormBox[
        StyleBox["t",
          "TI"], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " distribution is elliptically contoured like the multinormal distribution, \
and characterizes the ratio of a multinormal vector to the standard deviation \
common to each variate. When ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["R",
            "TB"], "=", 
          StyleBox["I",
            "TB"]}], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " and ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["m",
            "TI"], "=", "1"}], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  ", the multivariate ",
  Cell[BoxData[
      FormBox[
        StyleBox["t",
          "TI"], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " distribution is the same as the multivariate Cauchy distribution (here ",
  Cell[BoxData[
      FormBox[
        StyleBox["I",
          "TB"], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " denotes the identity matrix). "
}], "Text",
  CellTags->{"S6.6.1", "1.5"}],

Cell[TextData[{
  "The ",
  StyleBox["Hotelling ", "TB"],
  StyleBox["T", "TBI"],
  Cell[BoxData[
      FormBox[
        SuperscriptBox["\[Null]", 
          StyleBox["2",
            "TB"]], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  StyleBox[" distribution", "TB"],
  " is a univariate distribution proportional to the ",
  StyleBox["F", "TI"],
  "\[Hyphen]ratio distribution. If vector ",
  Cell[BoxData[
      FormBox[
        StyleBox["d",
          "TI"], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " and matrix ",
  Cell[BoxData[
      FormBox[
        StyleBox["M",
          "TB"], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " are independently distributed ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["N",
              "TI"], 
            StyleBox["p",
              "TI"]], 
          RowBox[{"(", 
            RowBox[{\(0\& \[RightVector] \), ",", 
              StyleBox["I",
                "TB"]}], ")"}]}], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " and ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["W",
              "TI"], 
            StyleBox["p",
              "TI"]], 
          RowBox[{"(", 
            RowBox[{
              StyleBox["I",
                "TB"], ",", 
              StyleBox["m",
                "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  ", then ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["m",
            "TI"], 
          SuperscriptBox[
            StyleBox["d",
              "TI"], "\[Prime]"], 
          SuperscriptBox[
            StyleBox["M",
              "TB"], \(-1\)], 
          StyleBox["d",
            "TI"]}], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " has the Hotelling ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["T",
            "TI"], "2"], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " distribution with parameters ",
  Cell[BoxData[
      FormBox[
        StyleBox["p",
          "TI"], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " and ",
  Cell[BoxData[
      FormBox[
        StyleBox["m",
          "TI"], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  ", denoted ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox[
            StyleBox["T",
              "TI"], "2"], 
          RowBox[{"(", 
            RowBox[{
              StyleBox["p",
                "TI"], ",", 
              StyleBox["m",
                "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  ". This distribution is commonly used to describe the sample Mahalanobis \
distance between two populations. "
}], "Text",
  CellTags->{"S6.6.1", "1.6"}],

Cell[TextData[{
  "A ",
  StyleBox["quadratic form", "TB"],
  " in a multinormal vector ",
  Cell[BoxData[
      FormBox[
        StyleBox["X",
          "TI"], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " distributed ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["N",
              "TI"], 
            StyleBox["p",
              "TI"]], 
          RowBox[{"(", 
            RowBox[{"\[Mu]", ",", Cell[BoxData[
                  \(\[CapitalSigma]\)], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}]}], ")"}]}], 
        TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " is given by ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox[
            StyleBox["X",
              "TI"], "\[Prime]"], 
          StyleBox["A",
            "TI"], 
          StyleBox["X",
            "TI"], "+", 
          SuperscriptBox[
            StyleBox["b",
              "TI"], "\[Prime]"], 
          StyleBox["X",
            "TI"], "+", 
          StyleBox["c",
            "TI"]}], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  ", where ",
  Cell[BoxData[
      FormBox[
        StyleBox["A",
          "TI"], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " is a symmetric ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["p",
            "TI"], "\[Cross]", 
          StyleBox["p",
            "TI"]}], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " matrix, ",
  Cell[BoxData[
      FormBox[
        StyleBox["b",
          "TI"], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " is a ",
  Cell[BoxData[
      FormBox[
        StyleBox["p",
          "TI"], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  "\[Hyphen]vector, and ",
  Cell[BoxData[
      FormBox[
        StyleBox["c",
          "TI"], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " is a scalar. This univariate distribution can be useful in discriminant \
analysis of multinormal samples. "
}], "Text",
  CellTags->{"S6.6.1", "1.7"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["PDF[", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["dist", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[", ", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["x", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["]", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[{
              StyleBox["probability density function at ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    StyleBox["x",
                      "TI"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[", where ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    StyleBox["x",
                      "TI"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[
              " is scalar\[Hyphen], vector\[Hyphen], or matrix\[Hyphen]valued \
depending on ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["dist", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[{
              StyleBox["CDF[", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["dist", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[", ", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["x", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["]", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[{
              StyleBox["cumulative distribution function at ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    StyleBox["x",
                      "TI"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[{
              StyleBox["Domain[", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["dist", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["]", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[StyleBox[
            "range of values or support of the random variable, vector, or \
matrix ",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[{
              StyleBox["Mean[", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["dist", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["]", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[StyleBox["mean ",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[{
              StyleBox["Variance[", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["dist", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["]", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[StyleBox["variance ",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[{
              StyleBox["StandardDeviation[", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["dist", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["]", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[StyleBox[
            "standard deviation ",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[{
              StyleBox["Skewness[", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["dist", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["]", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[StyleBox[
            "coefficient of skewness ",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[{
              StyleBox["Kurtosis[", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["dist", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["]", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[StyleBox[
            "coefficient of kurtosis ",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[{
              StyleBox["KurtosisExcess[", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["dist", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["]", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[StyleBox["kurtosis excess ",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[{
              StyleBox["CharacteristicFunction[", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["dist", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[", ", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["t", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["]", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[{
              StyleBox["characteristic function ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    RowBox[{"\[CurlyPhi]", 
                      RowBox[{"(", 
                        StyleBox["t",
                          "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[", where ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    StyleBox["t",
                      "TI"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[
              " is scalar\[Hyphen], vector\[Hyphen], or matrix\[Hyphen]valued \
depending on ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["dist", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[{
              StyleBox["ExpectedValue[", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["f", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[", ", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["dist", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["]", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[{
              StyleBox["expected value of pure function ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    StyleBox["f",
                      "TI"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[" with respect to the specified distribution ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[{
              StyleBox["ExpectedValue[", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["f", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[", ", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["dist", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[", ", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["x", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["]", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[{
              StyleBox["expected value of function ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    StyleBox["f",
                      "TI"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[" of ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    StyleBox["x",
                      "TI"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[" with respect to the specified distribution, where ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    StyleBox["x",
                      "TI"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[
              " is scalar\[Hyphen], vector\[Hyphen], or matrix\[Hyphen]valued \
depending on ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["dist", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[{
              StyleBox["Random[", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["dist", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["]", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[StyleBox[
            "pseudorandom number, vector, or matrix with specified \
distribution ",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[{
              StyleBox["RandomArray[", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["dist", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[", ", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["dims", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["]", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[{
              StyleBox["pseudorandom array with dimensionality ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["dims", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[",", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" and elements from the specified distribution ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S6.6.1"],

Cell["\<\
Functions of univariate statistical distributions applicable to \
multivariate distributions. \
\>", "Caption",
  CellTags->"S6.6.1"],

Cell[TextData[{
  "In this package distributions are represented in symbolic form. Generally, \
",
  StyleBox["PDF[", "MR"],
  StyleBox["dist", "TI"],
  StyleBox[", ", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  " evaluates the density at ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " if ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " is a numerical value, vector, or matrix, and otherwise leaves the \
function in symbolic form. Similarly, ",
  StyleBox["CDF[", "MR"],
  StyleBox["dist", "TI"],
  StyleBox[", ", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  " gives the cumulative density and ",
  StyleBox["CharacteristicFunction[", "MR"],
  StyleBox["dist", "TI"],
  StyleBox[", ", "MR"],
  StyleBox["t", "TI"],
  StyleBox["]", "MR"],
  " gives the characteristic function of the specified distribution. "
}], "Text",
  CellTags->{"S6.6.1", "1.8"}],

Cell[TextData[{
  "In some cases explicit forms of these expressions are not available. For \
example, ",
  StyleBox["PDF[QuadraticFormDistribution[{", "MR"],
  StyleBox["A", "TI"],
  StyleBox[", ", "MR"],
  StyleBox["b", "TI"],
  StyleBox[", ", "MR"],
  StyleBox["c", "TI"],
  StyleBox["}, {", "MR"],
  StyleBox["mu", "TI"],
  StyleBox[", ", "MR"],
  StyleBox["sigma", "TI"],
  StyleBox["}], ", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  " does not evaluate, but a ",
  StyleBox["Series", "MR"],
  " expansion of the ",
  StyleBox["PDF", "MR"],
  " about the lower support point of the domain (for a positive definite \
quadratic form) does evaluate. The ",
  StyleBox["CDF", "MR"],
  " of ",
  StyleBox["MultinormalDistribution", "MR"],
  " and ",
  StyleBox["StudentTDistribution", "MR"],
  " is available for numerical vector arguments, but not for symbolic vector \
arguments. In the case of ",
  StyleBox["MultivariateTDistribution", "MR"],
  ", the ",
  StyleBox["CharacteristicFunction", "MR"],
  " is expressed in terms of an integral. "
}], "Text",
  CellTags->{"S6.6.1", "1.9"}],

Cell[TextData[{
  "If \[CapitalSigma] is a diagonal matrix, the closed form result for ",
  StyleBox["CDF[MultinormalDistribution[", "MR"],
  StyleBox["mu", "TI"],
  StyleBox[",", "MR"],
  StyleBox["sigma", "TI"],
  StyleBox["],", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  " is computed directly. If \[CapitalSigma] is not diagonal and ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[CapitalSigma]", "=", 
          RowBox[{"(", 
            SubscriptBox["\[Sigma]", 
              StyleBox[\(i  j\),
                "TI"]], ")"}]}], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " has the form ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox["\[Sigma]", 
            StyleBox[\(i  j\),
              "TI"]], "=", 
          SubsuperscriptBox["\[Sigma]", 
            StyleBox["i",
              "TI"], "2"]}], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " for ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["i",
            "TI"], "=", 
          StyleBox["j",
            "TI"]}], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " and ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox["\[Sigma]", 
            StyleBox[\(i  j\),
              "TI"]], "=", 
          SubscriptBox["\[Sigma]", 
            StyleBox["i",
              "TI"]], 
          SubscriptBox["\[Sigma]", 
            StyleBox["j",
              "TI"]], 
          SubscriptBox["\[Lambda]", 
            StyleBox["i",
              "TI"]], 
          SubscriptBox["\[Lambda]", 
            StyleBox["j",
              "TI"]]}], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " for ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["i",
            "TI"], "\[NotEqual]", 
          StyleBox["j",
            "TI"]}], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  ", where ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox["\[Lambda]", 
            StyleBox["i",
              "TI"]], "\[Element]", \(\([\)\(\(-1\), 1\)\(]\)\)}], 
        TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  ", a method for multivariate normal distributions with product-covariance \
structures described in Y.\[NonBreakingSpace]L.\[NonBreakingSpace]Tong, ",
  StyleBox["The Multivariate Normal Distribution", "TI"],
  ", Springer\[Hyphen]Verlag, 1990 is used. If \[CapitalSigma] does not have \
either of these special forms, a general method described in Alan Genz, \
\[OpenCurlyDoubleQuote]Numerical Computation of Multivariate Normal \
Probabilities,",
  "\[CloseCurlyDoubleQuote]",
  " Journal of Computational and Graphical Statistics 1 (1992), pp. 141-149 \
is used."
}], "Text",
  CellTags->{"S6.6.1", "1.10"}],

Cell[TextData[{
  "If the correlation matrix ",
  Cell[BoxData[
      FormBox[
        StyleBox["R",
          "TB"], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " in ",
  StyleBox["CDF[MultivariateTDistribution[", "MR"],
  StyleBox["r", "TI"],
  StyleBox[", ", "MR"],
  StyleBox["m", "TI"],
  StyleBox["], ", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  " is diagonal, a single numeric integration is performed using the closed \
form result for the multivariate normal CDF and the relationship between \
multivariate normal and multivariate T distributions. Otherwise, general \
methods based on separation of variable techniques in Alan Genz and Frank \
Bretz, \[OpenCurlyDoubleQuote]Comparison of Methods for the Computation of \
Multivariate ",
  StyleBox["t",
    FontSlant->"Italic"],
  "-Probabilities,",
  "\[CloseCurlyDoubleQuote]",
  " Journal of Computational and Graphical Statistics 11 (2002), pp. 950-971 \
are used."
}], "Text",
  CellTags->{"S6.6.1", "1.10"}],

Cell["This loads the package. ", "MathCaption",
  CellTags->{"S6.6.1", "1.12"}],

Cell["<<Statistics`MultinormalDistribution`", "Input",
  CellLabel->"In[1]:=",
  CellTags->"S6.6.1"],

Cell["\<\
Here is a symbolic representation of a standardized binormal \
distribution. A standardized random vector has a zero mean vector and a \
covariance matrix equal to its correlation matrix. \
\>", "MathCaption",
  CellTags->{"S6.6.1", "1.13"}],

Cell[CellGroupData[{

Cell["\<\
(r = {{1, 1/Sqrt[3]}, {1/Sqrt[3], 1}};
ndist = MultinormalDistribution[{0, 0}, r])\
\>", "Input",
  CellLabel->"In[2]:=",
  CellTags->"S6.6.1"],

Cell[BoxData[
    RowBox[{"MultinormalDistribution", "[", 
      RowBox[{\({0, 0}\), ",", 
        TagBox[\({{1, 1\/\@3}, {1\/\@3, 1}}\),
          Short]}], "]"}]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"S6.6.1"]
}, Open  ]],

Cell["This gives its probability density function. ", "MathCaption",
  CellTags->{"S6.6.1", "1.14"}],

Cell[CellGroupData[{

Cell["pdf = PDF[ndist, {x1, x2}]", "Input",
  CellLabel->"In[3]:=",
  CellTags->"S6.6.1"],

Cell[BoxData[
    \(\(\@\(3\/2\)\ \[ExponentialE]\^\(1\/2\ \((\(-x2\)\ \((\(-\(\(\@3\ \
x1\)\/2\)\) + \(3\ x2\)\/2)\) - x1\ \((\(3\ x1\)\/2 - \(\@3\ \
x2\)\/2)\))\)\)\)\/\(2\ \[Pi]\)\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"S6.6.1"]
}, Open  ]],

Cell["\<\
You can make a plot of the density to observe its distribution. \
\
\>", "MathCaption",
  CellTags->{"S6.6.1", "1.15"}],

Cell[CellGroupData[{

Cell["\<\
Plot3D[pdf, {x1, -3, 3}, {x2, -3, 3},
        PlotRange->All]\
\>", "Input",
  CellLabel->"In[4]:=",
  CellTags->"S6.6.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .81114 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-1.55041e-017 1.04977 -0.0679587 1.04977 [
[.13542 .20373 -11.9677 -9 ]
[.13542 .20373 .03234 0 ]
[.3345 .12542 -5.5867 -9 ]
[.3345 .12542 .4133 0 ]
[.54972 .04081 -5.18957 -9 ]
[.54972 .04081 .81043 0 ]
[.76189 .08851 0 -6.17016 ]
[.76189 .08851 12 2.82984 ]
[.8565 .23339 0 -6.03127 ]
[.8565 .23339 6 2.96873 ]
[.93905 .3598 0 -5.91371 ]
[.93905 .3598 6 3.08629 ]
[.02411 .26511 -6 -2.74232 ]
[.02411 .26511 0 6.25768 ]
[.01546 .31935 -24 -2.78818 ]
[.01546 .31935 0 6.21182 ]
[.00649 .37554 -18 -2.83586 ]
[.00649 .37554 0 6.16414 ]
[-0.0028 .43378 -24 -2.88546 ]
[-0.0028 .43378 0 6.11454 ]
[ 0 0 0 0 ]
[ 1 .81114 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.03716 .25514 m
.68874 0 L
s
.14467 .21304 m
.1493 .21769 L
s
[(-2)] .13542 .20373 .99461 1 Mshowa
.34306 .13535 m
.34735 .14032 L
s
[(0)] .3345 .12542 .86223 1 Mshowa
.55745 .05141 m
.56132 .05671 L
s
[(2)] .54972 .04081 .72986 1 Mshowa
.125 Mabswid
.19287 .19417 m
.1956 .197 L
s
.24198 .17493 m
.24466 .17782 L
s
.29204 .15533 m
.29467 .15827 L
s
.39509 .11498 m
.3976 .11801 L
s
.44814 .09421 m
.45059 .09729 L
s
.50225 .07302 m
.50464 .07615 L
s
.09737 .23156 m
.10019 .23431 L
s
.05093 .24975 m
.05379 .25245 L
s
.61378 .02935 m
.61603 .03258 L
s
.67126 .00684 m
.67344 .01012 L
s
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.74959 .09308 m
.74344 .09536 L
s
[(-2)] .76189 .08851 -1 .37115 Mshowa
.84407 .23761 m
.83786 .23973 L
s
[(0)] .8565 .23339 -1 .34028 Mshowa
.92653 .36374 m
.92027 .3657 L
s
[(2)] .93905 .3598 -1 .31416 Mshowa
.125 Mabswid
.77448 .13116 m
.77078 .1325 L
s
.79849 .16789 m
.79478 .16921 L
s
.82168 .20336 m
.81796 .20465 L
s
.86572 .27073 m
.86199 .27197 L
s
.88666 .30275 m
.88291 .30397 L
s
.90691 .33374 m
.90316 .33494 L
s
.72377 .05359 m
.72009 .05499 L
s
.69697 .0126 m
.69331 .01403 L
s
.94552 .3928 m
.94176 .39396 L
s
.96393 .42096 m
.96017 .4221 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
.03634 .26033 m
.04245 .25795 L
s
[(0)] .02411 .26511 1 -0.3906 Mshowa
.02772 .31468 m
.03386 .31235 L
s
[(0.05)] .01546 .31935 1 -0.3804 Mshowa
.0188 .37099 m
.02496 .36871 L
s
[(0.1)] .00649 .37554 1 -0.36981 Mshowa
.00955 .42935 m
.01573 .42713 L
s
[(0.15)] -0.0028 .43378 1 -0.35879 Mshowa
.125 Mabswid
.03464 .27105 m
.03831 .26963 L
s
.03293 .28185 m
.0366 .28043 L
s
.0312 .29272 m
.03488 .2913 L
s
.02947 .30366 m
.03315 .30226 L
s
.02596 .32579 m
.02965 .32439 L
s
.02419 .33697 m
.02788 .33558 L
s
.02241 .34823 m
.0261 .34685 L
s
.02061 .35957 m
.0243 .35819 L
s
.01698 .38249 m
.02067 .38113 L
s
.01514 .39408 m
.01884 .39273 L
s
.01329 .40575 m
.01699 .4044 L
s
.01143 .4175 m
.01513 .41617 L
s
.00766 .44128 m
.01137 .43995 L
s
.00576 .45329 m
.00947 .45198 L
s
.00384 .4654 m
.00755 .46409 L
s
.00191 .47759 m
.00562 .47629 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
.40529 .59895 m
.03716 .25514 L
s
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.40529 .59895 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
0 0 m
1 0 L
1 .81114 L
0 .81114 L
closepath
clip
newpath
.813 .955 1 r
.38907 .5735 m .44535 .58261 L .41009 .59325 L F
.38907 .5735 m .42463 .5626 L .44535 .58261 L F
.43441 .55961 m .44535 .58261 L .42463 .5626 L F
.43441 .55961 m .45505 .57969 L .44535 .58261 L F
0 g
.5 Mabswid
.41009 .59325 m
.44535 .58261 L
s
.813 .955 1 r
.43441 .55961 m .48108 .57184 L .45505 .57969 L F
0 g
.45482 .57947 m
.45505 .57969 L
s
.44535 .58261 m
.45505 .57969 L
s
.813 .955 1 r
.41889 .55706 m .38907 .5735 L .38325 .56803 L F
.41889 .55706 m .42463 .5626 L .38907 .5735 L F
0 g
.38907 .5735 m
.41009 .59325 L
s
.813 .955 1 r
.43441 .55961 m .46066 .55156 L .48108 .57184 L F
.48052 .54547 m .48108 .57184 L .46066 .55156 L F
.48052 .54547 m .50077 .5659 L .48108 .57184 L F
0 g
.45505 .57969 m
.48108 .57184 L
s
.813 .955 1 r
.41889 .55706 m .38325 .56803 L .36754 .55327 L F
0 g
.38325 .56803 m
.38364 .56791 L
s
.38325 .56803 m
.38907 .5735 L
s
.813 .955 1 r
.48052 .54547 m .51728 .56091 L .50077 .5659 L F
0 g
.50022 .56534 m
.50077 .5659 L
s
.48108 .57184 m
.50077 .5659 L
s
.813 .955 1 r
.42869 .55404 m .42463 .5626 L .41889 .55706 L F
.42869 .55404 m .43441 .55961 L .42463 .5626 L F
.48052 .54547 m .49718 .54037 L .51728 .56091 L F
.52742 .53112 m .51728 .56091 L .49718 .54037 L F
.52742 .53112 m .54726 .55187 L .51728 .56091 L F
0 g
.50077 .5659 m
.51728 .56091 L
s
.813 .955 1 r
.455 .54594 m .43441 .55961 L .42869 .55404 L F
.455 .54594 m .46066 .55156 L .43441 .55961 L F
0 g
.43441 .55961 m
.45482 .57947 L
s
.813 .955 1 r
.41889 .55706 m .36754 .55327 L .4034 .5421 L F
.42869 .55404 m .41889 .55706 L .4034 .5421 L F
0 g
.38364 .56791 m
.41889 .55706 L
s
.813 .955 1 r
.455 .54594 m .42869 .55404 L .41326 .53903 L F
.42869 .55404 m .4034 .5421 L .41326 .53903 L F
0 g
.41889 .55706 m
.42869 .55404 L
s
.42869 .55404 m
.43441 .55961 L
s
.813 .955 1 r
.39159 .5307 m .36754 .55327 L .35557 .54202 L F
.39159 .5307 m .4034 .5421 L .36754 .55327 L F
0 g
.36754 .55327 m
.38325 .56803 L
s
.813 .955 1 r
.52742 .53112 m .55397 .54985 L .54726 .55187 L F
0 g
.51728 .56091 m
.54726 .55187 L
s
.813 .955 1 r
.47491 .53982 m .46066 .55156 L .455 .54594 L F
.47491 .53982 m .48052 .54547 L .46066 .55156 L F
.53419 .52904 m .59115 .53865 L .55397 .54985 L F
.52742 .53112 m .53419 .52904 L .55397 .54985 L F
0 g
.53604 .54013 m
.54726 .55187 L
s
.54726 .55187 m
.55397 .54985 L
s
.813 .955 1 r
.455 .54594 m .41326 .53903 L .43973 .53078 L F
.47491 .53982 m .455 .54594 L .43973 .53078 L F
0 g
.42869 .55404 m
.455 .54594 L
s
.813 .955 1 r
.49161 .53468 m .48052 .54547 L .47491 .53982 L F
.49161 .53468 m .49718 .54037 L .48052 .54547 L F
0 g
.48052 .54547 m
.50022 .56534 L
s
.813 .955 1 r
.4015 .52759 m .4034 .5421 L .39159 .5307 L F
.4015 .52759 m .41326 .53903 L .4034 .5421 L F
.39159 .5307 m .35557 .54202 L .34547 .53253 L F
0 g
.35557 .54202 m
.36754 .55327 L
s
.813 .955 1 r
.52192 .52539 m .49718 .54037 L .49161 .53468 L F
.52192 .52539 m .52742 .53112 L .49718 .54037 L F
.49161 .53468 m .47491 .53982 L .45976 .52455 L F
.47491 .53982 m .43973 .53078 L .45976 .52455 L F
0 g
.455 .54594 m
.47491 .53982 L
s
.47491 .53982 m
.48052 .54547 L
s
.813 .955 1 r
.42809 .51924 m .41326 .53903 L .4015 .52759 L F
.42809 .51924 m .43973 .53078 L .41326 .53903 L F
0 g
.41326 .53903 m
.42869 .55404 L
s
.813 .955 1 r
.53419 .52904 m .5717 .51764 L .59115 .53865 L F
.813 .954 1 r
.57514 .51662 m .59115 .53865 L .5717 .51764 L F
.57514 .51662 m .59456 .53762 L .59115 .53865 L F
0 g
.55397 .54985 m
.59115 .53865 L
s
.813 .954 1 r
.57514 .51662 m .62884 .52733 L .59456 .53762 L F
0 g
.59171 .53454 m
.59456 .53762 L
s
.59115 .53865 m
.59456 .53762 L
s
.813 .955 1 r
.49161 .53468 m .45976 .52455 L .47656 .51933 L F
.813 .954 1 r
.52192 .52539 m .49161 .53468 L .47656 .51933 L F
0 g
.47491 .53982 m
.49161 .53468 L
s
.49161 .53468 m
.50049 .53196 L
s
.813 .955 1 r
.36341 .5035 m .34547 .53253 L .32701 .51517 L F
0 g
.35557 .54202 m
.35746 .54143 L
s
.813 .955 1 r
.36341 .5035 m .38163 .52108 L .34547 .53253 L F
.39159 .5307 m .34547 .53253 L .38163 .52108 L F
0 g
.34547 .53253 m
.35557 .54202 L
s
.813 .955 1 r
.5287 .52331 m .52742 .53112 L .52192 .52539 L F
.5287 .52331 m .53419 .52904 L .52742 .53112 L F
0 g
.52742 .53112 m
.53604 .54013 L
s
.813 .955 1 r
.44822 .51297 m .43973 .53078 L .42809 .51924 L F
.44822 .51297 m .45976 .52455 L .43973 .53078 L F
.4015 .52759 m .39159 .5307 L .38163 .52108 L F
0 g
.35746 .54143 m
.39159 .5307 L
s
.813 .954 1 r
.56631 .51196 m .53419 .52904 L .5287 .52331 L F
.56631 .51196 m .5717 .51764 L .53419 .52904 L F
.813 .955 1 r
.42809 .51924 m .4015 .52759 L .39157 .51794 L F
.4015 .52759 m .38163 .52108 L .39157 .51794 L F
0 g
.39159 .5307 m
.4015 .52759 L
s
.4015 .52759 m
.41326 .53903 L
s
.813 .954 1 r
.57514 .51662 m .60974 .50633 L .62884 .52733 L F
.812 .953 1 r
.62371 .50239 m .62884 .52733 L .60974 .50633 L F
.62371 .50239 m .64267 .52322 L .62884 .52733 L F
0 g
.59456 .53762 m
.62884 .52733 L
s
.813 .954 1 r
.5287 .52331 m .52192 .52539 L .50707 .50994 L F
.52192 .52539 m .47656 .51933 L .50707 .50994 L F
0 g
.50049 .53196 m
.52192 .52539 L
s
.52192 .52539 m
.52742 .53112 L
s
.813 .954 1 r
.4651 .5077 m .45976 .52455 L .44822 .51297 L F
.4651 .5077 m .47656 .51933 L .45976 .52455 L F
0 g
.45976 .52455 m
.47491 .53982 L
s
.812 .954 1 r
.56631 .51196 m .5287 .52331 L .5139 .50784 L F
.813 .954 1 r
.5287 .52331 m .50707 .50994 L .5139 .50784 L F
0 g
.52192 .52539 m
.5287 .52331 L
s
.811 .953 1 r
.62371 .50239 m .66704 .51597 L .64267 .52322 L F
0 g
.63816 .51826 m
.64267 .52322 L
s
.62884 .52733 m
.64267 .52322 L
s
.813 .955 1 r
.37342 .50032 m .38163 .52108 L .36341 .5035 L F
.37342 .50032 m .39157 .51794 L .38163 .52108 L F
.812 .954 1 r
.49575 .49845 m .47656 .51933 L .4651 .5077 L F
.49575 .49845 m .50707 .50994 L .47656 .51933 L F
.813 .955 1 r
.42809 .51924 m .39157 .51794 L .41827 .5095 L F
.813 .954 1 r
.44822 .51297 m .42809 .51924 L .41827 .5095 L F
0 g
.4015 .52759 m
.42809 .51924 L
s
.813 .954 1 r
.40031 .49177 m .39157 .51794 L .37342 .50032 L F
.40031 .49177 m .41827 .5095 L .39157 .51794 L F
0 g
.39157 .51794 m
.4015 .52759 L
s
.811 .953 1 r
.56976 .51097 m .5717 .51764 L .56631 .51196 L F
.56976 .51097 m .57514 .51662 L .5717 .51764 L F
.60446 .50095 m .57514 .51662 L .56976 .51097 L F
.60446 .50095 m .60974 .50633 L .57514 .51662 L F
0 g
.57514 .51662 m
.59171 .53454 L
s
.811 .953 1 r
.62371 .50239 m .64833 .49543 L .66704 .51597 L F
.809 .952 1 r
.6732 .48895 m .66704 .51597 L .64833 .49543 L F
.6732 .48895 m .69164 .5088 L .66704 .51597 L F
0 g
.64267 .52322 m
.66704 .51597 L
s
.813 .955 1 r
.36341 .5035 m .32701 .51517 L .32285 .51127 L F
0 g
.32701 .51517 m
.34547 .53253 L
s
.813 .954 1 r
.4651 .5077 m .44822 .51297 L .43847 .50319 L F
.44822 .51297 m .41827 .5095 L .43847 .50319 L F
0 g
.42809 .51924 m
.44822 .51297 L
s
.44822 .51297 m
.45976 .52455 L
s
.812 .954 1 r
.56631 .51196 m .5139 .50784 L .55176 .49662 L F
.81 .952 1 r
.56976 .51097 m .56631 .51196 L .55176 .49662 L F
0 g
.5287 .52331 m
.56631 .51196 L
s
.813 .955 1 r
.29965 .48947 m .35931 .49955 L .32285 .51127 L F
.36341 .5035 m .32285 .51127 L .35931 .49955 L F
0 g
.32701 .51517 m
.34764 .50856 L
s
.32285 .51127 m
.32701 .51517 L
s
.809 .951 1 r
.60446 .50095 m .56976 .51097 L .55523 .4957 L F
.81 .952 1 r
.56976 .51097 m .55176 .49662 L .55523 .4957 L F
0 g
.56631 .51196 m
.56976 .51097 L
s
.56976 .51097 m
.57514 .51662 L
s
.812 .954 1 r
.50261 .49638 m .50707 .50994 L .49575 .49845 L F
.50261 .49638 m .5139 .50784 L .50707 .50994 L F
0 g
.50707 .50994 m
.52192 .52539 L
s
.812 .954 1 r
.42064 .4856 m .41827 .5095 L .40031 .49177 L F
.42064 .4856 m .43847 .50319 L .41827 .5095 L F
.808 .951 1 r
.6732 .48895 m .70579 .50467 L .69164 .5088 L F
0 g
.66704 .51597 m
.69164 .5088 L
s
.809 .951 1 r
.54067 .4861 m .5139 .50784 L .50261 .49638 L F
.54067 .4861 m .55176 .49662 L .5139 .50784 L F
.813 .954 1 r
.4651 .5077 m .43847 .50319 L .45542 .49789 L F
.812 .953 1 r
.49575 .49845 m .4651 .5077 L .45542 .49789 L F
0 g
.44822 .51297 m
.4651 .5077 L
s
.807 .95 1 r
.61847 .49726 m .60974 .50633 L .60446 .50095 L F
.61847 .49726 m .62371 .50239 L .60974 .50633 L F
.808 .951 1 r
.6732 .48895 m .68752 .48521 L .70579 .50467 L F
.806 .95 1 r
.72369 .47625 m .70579 .50467 L .68752 .48521 L F
.72369 .47625 m .7415 .49448 L .70579 .50467 L F
0 g
.69164 .5088 m
.70579 .50467 L
s
.813 .954 1 r
.37342 .50032 m .36341 .5035 L .35931 .49955 L F
0 g
.34764 .50856 m
.36341 .5035 L
s
.812 .954 1 r
.43771 .48042 m .43847 .50319 L .42064 .4856 L F
.43771 .48042 m .45542 .49789 L .43847 .50319 L F
0 g
.43847 .50319 m
.44822 .51297 L
s
.806 .949 1 r
.64318 .49077 m .62371 .50239 L .61847 .49726 L F
.64318 .49077 m .64833 .49543 L .62371 .50239 L F
0 g
.62371 .50239 m
.63816 .51826 L
s
.813 .954 1 r
.40031 .49177 m .37342 .50032 L .36933 .49635 L F
.37342 .50032 m .35931 .49955 L .36933 .49635 L F
0 g
.36341 .5035 m
.37342 .50032 L
s
.37342 .50032 m
.39157 .51794 L
s
.812 .954 1 r
.34651 .47439 m .35931 .49955 L .33641 .47753 L F
.34651 .47439 m .36933 .49635 L .35931 .49955 L F
.813 .955 1 r
.29965 .48947 m .33641 .47753 L .35931 .49955 L F
.809 .951 1 r
.60446 .50095 m .55523 .4957 L .59018 .48641 L F
.804 .948 1 r
.61847 .49726 m .60446 .50095 L .59018 .48641 L F
0 g
.56976 .51097 m
.60446 .50095 L
s
.811 .953 1 r
.50261 .49638 m .49575 .49845 L .4862 .48875 L F
.812 .953 1 r
.49575 .49845 m .45542 .49789 L .4862 .48875 L F
0 g
.4651 .5077 m
.49575 .49845 L
s
.49575 .49845 m
.50707 .50994 L
s
.808 .951 1 r
.46868 .47261 m .45542 .49789 L .43771 .48042 L F
.46868 .47261 m .4862 .48875 L .45542 .49789 L F
.812 .954 1 r
.34651 .47439 m .39626 .48779 L .36933 .49635 L F
.813 .954 1 r
.40031 .49177 m .36933 .49635 L .39626 .48779 L F
0 g
.36933 .49635 m
.37342 .50032 L
s
.803 .947 1 r
.54416 .4854 m .55176 .49662 L .54067 .4861 L F
.54416 .4854 m .55523 .4957 L .55176 .49662 L F
.807 .95 1 r
.54067 .4861 m .50261 .49638 L .49309 .48671 L F
.811 .953 1 r
.50261 .49638 m .4862 .48875 L .49309 .48671 L F
0 g
.49575 .49845 m
.50261 .49638 L
s
.803 .947 1 r
.64318 .49077 m .61847 .49726 L .60431 .48342 L F
.804 .948 1 r
.61847 .49726 m .59018 .48641 L .60431 .48342 L F
0 g
.60446 .50095 m
.61847 .49726 L
s
.61847 .49726 m
.62371 .50239 L
s
.61829 .49709 m
.61847 .49726 L
s
.8 .945 1 r
.57933 .47837 m .55523 .4957 L .54416 .4854 L F
.57933 .47837 m .59018 .48641 L .55523 .4957 L F
0 g
.55523 .4957 m
.56976 .51097 L
s
.801 .945 1 r
.66816 .48495 m .64833 .49543 L .64318 .49077 L F
.66816 .48495 m .6732 .48895 L .64833 .49543 L F
.805 .949 1 r
.72369 .47625 m .7451 .49345 L .7415 .49448 L F
0 g
.70579 .50467 m
.7415 .49448 L
s
.805 .949 1 r
.72734 .47534 m .78497 .4821 L .7451 .49345 L F
0 g
.74116 .49413 m
.7415 .49448 L
s
.805 .949 1 r
.72369 .47625 m .72734 .47534 L .7451 .49345 L F
0 g
.7415 .49448 m
.7451 .49345 L
s
.811 .953 1 r
.42064 .4856 m .40031 .49177 L .39626 .48779 L F
0 g
.37342 .50032 m
.40031 .49177 L
s
.813 .954 1 r
.33429 .47553 m .29965 .48947 L .29751 .48747 L F
.33429 .47553 m .33641 .47753 L .29965 .48947 L F
0 g
.29965 .48947 m
.32285 .51127 L
s
.806 .95 1 r
.47562 .47086 m .4862 .48875 L .46868 .47261 L F
.47562 .47086 m .49309 .48671 L .4862 .48875 L F
0 g
.4862 .48875 m
.49575 .49845 L
s
.808 .951 1 r
.39416 .46074 m .39626 .48779 L .37366 .46595 L F
.39416 .46074 m .41663 .48164 L .39626 .48779 L F
.812 .954 1 r
.34651 .47439 m .37366 .46595 L .39626 .48779 L F
.811 .953 1 r
.42064 .4856 m .39626 .48779 L .41663 .48164 L F
.813 .954 1 r
.33429 .47553 m .29751 .48747 L .27584 .46716 L F
0 g
.29751 .48747 m
.30294 .48571 L
s
.29751 .48747 m
.29965 .48947 L
s
.803 .947 1 r
.64318 .49077 m .60431 .48342 L .62924 .47815 L F
.796 .942 1 r
.66816 .48495 m .64318 .49077 L .62924 .47815 L F
0 g
.61847 .49726 m
.64318 .49077 L
s
.64318 .49077 m
.64445 .49047 L
s
.795 .941 1 r
.51411 .46624 m .49309 .48671 L .47562 .47086 L F
0 g
.50261 .49638 m
.50912 .49462 L
s
.795 .941 1 r
.51411 .46624 m .5313 .47721 L .49309 .48671 L F
.807 .95 1 r
.54067 .4861 m .49309 .48671 L .5313 .47721 L F
.798 .944 1 r
.68254 .4816 m .6732 .48895 L .66816 .48495 L F
.68254 .4816 m .68752 .48521 L .6732 .48895 L F
0 g
.6732 .48895 m
.69164 .5088 L
s
.811 .953 1 r
.43771 .48042 m .42064 .4856 L .41663 .48164 L F
0 g
.42064 .4856 m
.43847 .50319 L
s
.40031 .49177 m
.42064 .4856 L
s
.798 .943 1 r
.54416 .4854 m .54067 .4861 L .5313 .47721 L F
0 g
.50912 .49462 m
.54067 .4861 L
s
.789 .937 1 r
.59359 .47692 m .59018 .48641 L .57933 .47837 L F
.59359 .47692 m .60431 .48342 L .59018 .48641 L F
.795 .941 1 r
.57933 .47837 m .54416 .4854 L .5348 .4767 L F
.798 .943 1 r
.54416 .4854 m .5313 .47721 L .5348 .4767 L F
0 g
.54067 .4861 m
.54416 .4854 L
s
.54416 .4854 m
.55523 .4957 L
s
.807 .95 1 r
.39416 .46074 m .43372 .47649 L .41663 .48164 L F
.811 .953 1 r
.43771 .48042 m .41663 .48164 L .43372 .47649 L F
0 g
.41663 .48164 m
.42064 .4856 L
s
.795 .941 1 r
.71888 .47343 m .68752 .48521 L .68254 .4816 L F
.71888 .47343 m .72369 .47625 L .68752 .48521 L F
.805 .949 1 r
.72734 .47534 m .76773 .4647 L .78497 .4821 L F
0 g
.72458 .47715 m
.74116 .49413 L
s
.807 .95 1 r
.77511 .46243 m .78497 .4821 L .76773 .4647 L F
.77511 .46243 m .79227 .47996 L .78497 .4821 L F
0 g
.7451 .49345 m
.78497 .4821 L
s
.805 .949 1 r
.46868 .47261 m .43771 .48042 L .43372 .47649 L F
0 g
.42064 .4856 m
.43771 .48042 L
s
.794 .94 1 r
.68254 .4816 m .66816 .48495 L .65449 .47414 L F
.796 .942 1 r
.66816 .48495 m .62924 .47815 L .65449 .47414 L F
0 g
.64445 .49047 m
.66816 .48495 L
s
.66816 .48495 m
.6732 .48895 L
s
.785 .933 1 r
.61876 .47436 m .60431 .48342 L .59359 .47692 L F
.61876 .47436 m .62924 .47815 L .60431 .48342 L F
0 g
.60431 .48342 m
.61829 .49709 L
s
.811 .953 1 r
.34441 .47241 m .33641 .47753 L .33429 .47553 L F
.34441 .47241 m .34651 .47439 L .33641 .47753 L F
.807 .95 1 r
.77511 .46243 m .82538 .47024 L .79227 .47996 L F
0 g
.7911 .47876 m
.79227 .47996 L
s
.78497 .4821 m
.79227 .47996 L
s
.81 .952 1 r
.34441 .47241 m .33429 .47553 L .31289 .4552 L F
.813 .954 1 r
.33429 .47553 m .27584 .46716 L .31289 .4552 L F
0 g
.30294 .48571 m
.33429 .47553 L
s
.807 .95 1 r
.39416 .46074 m .41138 .45637 L .43372 .47649 L F
.805 .949 1 r
.46868 .47261 m .43372 .47649 L .46474 .46897 L F
.794 .94 1 r
.44255 .45374 m .43372 .47649 L .41138 .45637 L F
0 g
.43771 .48042 m
.43962 .47994 L
s
.794 .94 1 r
.44255 .45374 m .46474 .46897 L .43372 .47649 L F
.81 .953 1 r
.37157 .46404 m .34651 .47439 L .34441 .47241 L F
.37157 .46404 m .37366 .46595 L .34651 .47439 L F
0 g
.34651 .47439 m
.36933 .49635 L
s
.794 .94 1 r
.68254 .4816 m .65449 .47414 L .66904 .47182 L F
.791 .938 1 r
.71888 .47343 m .68254 .4816 L .66904 .47182 L F
0 g
.66816 .48495 m
.68254 .4816 L
s
.68254 .4816 m
.68423 .48122 L
s
.81 .952 1 r
.34441 .47241 m .31289 .4552 L .32306 .45235 L F
.809 .951 1 r
.37157 .46404 m .34441 .47241 L .32306 .45235 L F
0 g
.33429 .47553 m
.34441 .47241 L
s
.34441 .47241 m
.34651 .47439 L
s
.777 .928 1 r
.51765 .4666 m .5313 .47721 L .51411 .46624 L F
.51765 .4666 m .5348 .4767 L .5313 .47721 L F
.777 .922 1 r
.55342 .47024 m .5348 .4767 L .51765 .4666 L F
.55342 .47024 m .57016 .47156 L .5348 .4767 L F
.795 .941 1 r
.57933 .47837 m .5348 .4767 L .57016 .47156 L F
0 g
.5348 .4767 m
.54416 .4854 L
s
.777 .925 1 r
.6443 .47321 m .62924 .47815 L .61876 .47436 L F
.6443 .47321 m .65449 .47414 L .62924 .47815 L F
.793 .939 1 r
.72255 .47261 m .72369 .47625 L .71888 .47343 L F
.72255 .47261 m .72734 .47534 L .72369 .47625 L F
0 g
.72369 .47625 m
.72458 .47715 L
s
.781 .931 1 r
.59359 .47692 m .57933 .47837 L .57016 .47156 L F
0 g
.54416 .4854 m
.57933 .47837 L
s
.804 .948 1 r
.47562 .47086 m .46868 .47261 L .46474 .46897 L F
0 g
.43962 .47994 m
.46868 .47261 L
s
.46868 .47261 m
.4862 .48875 L
s
.812 .953 1 r
.30417 .44714 m .27584 .46716 L .26703 .45894 L F
.30417 .44714 m .31289 .4552 L .27584 .46716 L F
0 g
.27584 .46716 m
.29751 .48747 L
s
.794 .941 1 r
.76309 .46199 m .72734 .47534 L .72255 .47261 L F
.76309 .46199 m .76773 .4647 L .72734 .47534 L F
.807 .95 1 r
.77511 .46243 m .80858 .45216 L .82538 .47024 L F
.81 .952 1 r
.82727 .44563 m .82538 .47024 L .80858 .45216 L F
.82727 .44563 m .84392 .46453 L .82538 .47024 L F
0 g
.79227 .47996 m
.82538 .47024 L
s
.788 .936 1 r
.51411 .46624 m .47562 .47086 L .47169 .46729 L F
.804 .948 1 r
.47562 .47086 m .46474 .46897 L .47169 .46729 L F
0 g
.46868 .47261 m
.47562 .47086 L
s
.803 .947 1 r
.39208 .45906 m .37366 .46595 L .37157 .46404 L F
.39208 .45906 m .39416 .46074 L .37366 .46595 L F
.79 .938 1 r
.44255 .45374 m .47169 .46729 L .46474 .46897 L F
0 g
.46474 .46897 m
.46868 .47261 L
s
.798 .943 1 r
.39208 .45906 m .37157 .46404 L .35039 .44471 L F
.809 .951 1 r
.37157 .46404 m .32306 .45235 L .35039 .44471 L F
0 g
.34441 .47241 m
.37157 .46404 L
s
.776 .927 1 r
.61876 .47436 m .59359 .47692 L .5845 .47141 L F
.781 .931 1 r
.59359 .47692 m .57016 .47156 L .5845 .47141 L F
0 g
.57933 .47837 m
.59359 .47692 L
s
.59359 .47692 m
.60431 .48342 L
s
.811 .953 1 r
.82727 .44563 m .86631 .45764 L .84392 .46453 L F
0 g
.82538 .47024 m
.84392 .46453 L
s
.79 .938 1 r
.44255 .45374 m .44955 .45315 L .47169 .46729 L F
.778 .916 1 r
.44955 .45315 m .51024 .46376 L .47169 .46729 L F
.788 .936 1 r
.51411 .46624 m .47169 .46729 L .51024 .46376 L F
0 g
.47562 .47086 m
.51137 .46657 L
s
.789 .937 1 r
.72255 .47261 m .71888 .47343 L .70583 .46579 L F
.791 .938 1 r
.71888 .47343 m .66904 .47182 L .70583 .46579 L F
0 g
.68423 .48122 m
.71888 .47343 L
s
.71888 .47343 m
.72369 .47625 L
s
.789 .937 1 r
.72255 .47261 m .70583 .46579 L .70954 .46518 L F
.794 .94 1 r
.76309 .46199 m .72255 .47261 L .70954 .46518 L F
0 g
.71888 .47343 m
.72255 .47261 L
s
.811 .953 1 r
.30417 .44714 m .26703 .45894 L .2514 .44437 L F
0 g
.26703 .45894 m
.2759 .45612 L
s
.26703 .45894 m
.27584 .46716 L
s
.777 .922 1 r
.65905 .47254 m .65088 .47381 L .6443 .47321 L F
.778 .915 1 r
.65905 .47254 m .6443 .47321 L .63565 .47241 L F
.65905 .47254 m .64013 .47244 L .65054 .47315 L F
.64013 .47244 m .63565 .47241 L .65054 .47315 L F
.777 .922 1 r
.65905 .47254 m .65449 .47414 L .65088 .47381 L F
.65905 .47254 m .66904 .47182 L .65449 .47414 L F
.779 .903 1 r
.67358 .48639 m .68341 .47538 L .65054 .47315 L F
.778 .919 1 r
.66615 .47144 m .65905 .47254 L .65054 .47315 L F
.777 .921 1 r
.69626 .46813 m .70583 .46579 L .66904 .47182 L F
.778 .919 1 r
.69626 .46813 m .65905 .47254 L .66615 .47144 L F
.777 .921 1 r
.69626 .46813 m .66904 .47182 L .65905 .47254 L F
.779 .903 1 r
.68341 .47538 m .68811 .47013 L .65054 .47315 L F
0 g
.6604 .47881 m
.66816 .48495 L
s
.8 .945 1 r
.4093 .45488 m .39416 .46074 L .39208 .45906 L F
.4093 .45488 m .41138 .45637 L .39416 .46074 L F
0 g
.39416 .46074 m
.41663 .48164 L
s
.779 .905 1 r
.56798 .47455 m .57016 .47156 L .55342 .47024 L F
.56798 .47455 m .5845 .47141 L .57016 .47156 L F
.798 .943 1 r
.39208 .45906 m .35039 .44471 L .37094 .442 L F
.795 .941 1 r
.4093 .45488 m .39208 .45906 L .37094 .442 L F
0 g
.37157 .46404 m
.39208 .45906 L
s
.39208 .45906 m
.39416 .46074 L
s
.811 .953 1 r
.82727 .44563 m .84985 .43775 L .86631 .45764 L F
.813 .955 1 r
.88016 .42676 m .86631 .45764 L .84985 .43775 L F
.88016 .42676 m .89641 .44808 L .86631 .45764 L F
0 g
.84392 .46453 m
.86631 .45764 L
s
.806 .949 1 r
.31435 .44456 m .31289 .4552 L .30417 .44714 L F
.31435 .44456 m .32306 .45235 L .31289 .4552 L F
.799 .944 1 r
.77049 .45956 m .76773 .4647 L .76309 .46199 L F
.77049 .45956 m .77511 .46243 L .76773 .4647 L F
.801 .946 1 r
.80403 .44853 m .77511 .46243 L .77049 .45956 L F
.80403 .44853 m .80858 .45216 L .77511 .46243 L F
0 g
.77511 .46243 m
.7911 .47876 L
s
.776 .927 1 r
.61876 .47436 m .5845 .47141 L .60987 .47115 L F
.778 .919 1 r
.6443 .47321 m .61876 .47436 L .60987 .47115 L F
0 g
.59359 .47692 m
.61876 .47436 L
s
.779 .929 1 r
.44048 .45312 m .41138 .45637 L .4093 .45488 L F
.44048 .45312 m .44255 .45374 L .41138 .45637 L F
.805 .948 1 r
.34173 .43761 m .32306 .45235 L .31435 .44456 L F
.34173 .43761 m .35039 .44471 L .32306 .45235 L F
0 g
.32306 .45235 m
.34441 .47241 L
s
.78 .898 1 r
.59385 .4822 m .5845 .47141 L .56798 .47455 L F
.59385 .4822 m .60987 .47115 L .5845 .47141 L F
.777 .918 1 r
.51765 .4666 m .51411 .46624 L .51024 .46376 L F
0 g
.51137 .46657 m
.51411 .46624 L
s
.777 .919 1 r
.44048 .45312 m .4093 .45488 L .38824 .43972 L F
.795 .941 1 r
.4093 .45488 m .37094 .442 L .38824 .43972 L F
0 g
.39208 .45906 m
.4093 .45488 L
s
.4093 .45488 m
.43638 .45335 L
s
.778 .913 1 r
.55342 .47024 m .51765 .4666 L .51377 .46431 L F
.777 .918 1 r
.51765 .4666 m .51024 .46376 L .51377 .46431 L F
0 g
.51411 .46624 m
.51765 .4666 L
s
.51765 .4666 m
.5348 .4767 L
s
.803 .947 1 r
.31435 .44456 m .30417 .44714 L .28871 .43285 L F
.811 .953 1 r
.30417 .44714 m .2514 .44437 L .28871 .43285 L F
0 g
.2759 .45612 m
.30417 .44714 L
s
.814 .955 1 r
.88016 .42676 m .90778 .44447 L .89641 .44808 L F
0 g
.86631 .45764 m
.89641 .44808 L
s
.794 .94 1 r
.76309 .46199 m .70954 .46518 L .75051 .45465 L F
.803 .947 1 r
.77049 .45956 m .76309 .46199 L .75051 .45465 L F
0 g
.72255 .47261 m
.76309 .46199 L
s
.809 .951 1 r
.27293 .41885 m .2514 .44437 L .2355 .42969 L F
.27293 .41885 m .28871 .43285 L .2514 .44437 L F
0 g
.2514 .44437 m
.26703 .45894 L
s
.778 .916 1 r
.44955 .45315 m .48834 .46319 L .51024 .46376 L F
0 g
.44414 .45483 m
.46474 .46897 L
s
.781 .888 1 r
.49191 .46557 m .51024 .46376 L .48834 .46319 L F
.49191 .46557 m .51377 .46431 L .51024 .46376 L F
.804 .948 1 r
.80403 .44853 m .77049 .45956 L .75796 .45177 L F
.803 .947 1 r
.77049 .45956 m .75051 .45465 L .75796 .45177 L F
0 g
.76309 .46199 m
.77049 .45956 L
s
.77049 .45956 m
.77511 .46243 L
s
.815 .956 1 r
.8916 .42261 m .94982 .43113 L .90778 .44447 L F
.814 .955 1 r
.88016 .42676 m .8916 .42261 L .90778 .44447 L F
0 g
.89641 .44808 m
.90778 .44447 L
s
.803 .947 1 r
.31435 .44456 m .28871 .43285 L .29891 .43073 L F
.801 .946 1 r
.34173 .43761 m .31435 .44456 L .29891 .43073 L F
0 g
.31435 .44456 m
.32306 .45235 L
s
.30417 .44714 m
.31435 .44456 L
s
.782 .879 1 r
.49191 .46557 m .54962 .46993 L .51377 .46431 L F
.778 .913 1 r
.55342 .47024 m .51377 .46431 L .54962 .46993 L F
.808 .951 1 r
.82274 .44142 m .80858 .45216 L .80403 .44853 L F
.82274 .44142 m .82727 .44563 L .80858 .45216 L F
.787 .935 1 r
.36226 .43646 m .35039 .44471 L .34173 .43761 L F
.36226 .43646 m .37094 .442 L .35039 .44471 L F
.778 .919 1 r
.6443 .47321 m .60987 .47115 L .63565 .47241 L F
0 g
.6443 .47321 m
.64818 .47303 L
s
.6443 .47321 m
.65185 .4739 L
s
.61876 .47436 m
.6443 .47321 L
s
.777 .92 1 r
.70002 .46769 m .70583 .46579 L .69626 .46813 L F
.70002 .46769 m .70954 .46518 L .70583 .46579 L F
0 g
.70627 .46604 m
.71888 .47343 L
s
.781 .931 1 r
.74124 .45462 m .70954 .46518 L .70002 .46769 L F
.74124 .45462 m .75051 .45465 L .70954 .46518 L F
.781 .89 1 r
.62017 .48855 m .60987 .47115 L .59385 .4822 L F
.62017 .48855 m .63565 .47241 L .60987 .47115 L F
.777 .924 1 r
.44748 .45273 m .44255 .45374 L .44048 .45312 L F
.44748 .45273 m .44955 .45315 L .44255 .45374 L F
0 g
.44255 .45374 m
.44414 .45483 L
s
.81 .953 1 r
.84533 .43284 m .82727 .44563 L .82274 .44142 L F
.84533 .43284 m .84985 .43775 L .82727 .44563 L F
0 g
.82727 .44563 m
.84392 .46453 L
s
.777 .919 1 r
.44048 .45312 m .38824 .43972 L .41938 .44679 L F
.778 .914 1 r
.44748 .45273 m .44048 .45312 L .41938 .44679 L F
0 g
.43638 .45335 m
.44048 .45312 L
s
.44048 .45312 m
.44255 .45374 L
s
.804 .948 1 r
.80403 .44853 m .75796 .45177 L .7917 .43871 L F
.812 .954 1 r
.82274 .44142 m .80403 .44853 L .7917 .43871 L F
0 g
.77049 .45956 m
.80403 .44853 L
s
.781 .892 1 r
.48629 .46459 m .44955 .45315 L .44748 .45273 L F
.48629 .46459 m .48834 .46319 L .44955 .45315 L F
.782 .931 1 r
.37956 .43548 m .37094 .442 L .36226 .43646 L F
.37956 .43548 m .38824 .43972 L .37094 .442 L F
0 g
.37094 .442 m
.39208 .45906 L
s
.778 .928 1 r
.36226 .43646 m .34173 .43761 L .32634 .42501 L F
.801 .946 1 r
.34173 .43761 m .29891 .43073 L .32634 .42501 L F
0 g
.31435 .44456 m
.34173 .43761 L
s
.797 .943 1 r
.28313 .41741 m .28871 .43285 L .27293 .41885 L F
.28313 .41741 m .29891 .43073 L .28871 .43285 L F
.778 .914 1 r
.44748 .45273 m .41938 .44679 L .4264 .44839 L F
.783 .875 1 r
.48629 .46459 m .44748 .45273 L .4264 .44839 L F
0 g
.44048 .45312 m
.4433 .45296 L
s
.44748 .45273 m
.4551 .45506 L
s
.815 .956 1 r
.8916 .42261 m .93398 .40785 L .94982 .43113 L F
0 g
.90778 .44447 m
.94982 .43113 L
s
.88183 .42894 m
.89641 .44808 L
s
.814 .955 1 r
.87568 .42112 m .84985 .43775 L .84533 .43284 L F
.87568 .42112 m .88016 .42676 L .84985 .43775 L F
.807 .95 1 r
.27293 .41885 m .2355 .42969 L .22629 .42119 L F
0 g
.2355 .42969 m
.2514 .44437 L
s
.815 .956 1 r
.84533 .43284 m .82274 .44142 L .81047 .43003 L F
.812 .954 1 r
.82274 .44142 m .7917 .43871 L .81047 .43003 L F
0 g
.80403 .44853 m
.82274 .44142 L
s
.82274 .44142 m
.82727 .44563 L
s
.781 .892 1 r
.56798 .47455 m .55342 .47024 L .54962 .46993 L F
.795 .941 1 r
.31059 .41351 m .29891 .43073 L .28313 .41741 L F
.31059 .41351 m .32634 .42501 L .29891 .43073 L F
0 g
.29891 .43073 m
.31435 .44456 L
s
.78 .9 1 r
.41064 .44706 m .41938 .44679 L .38824 .43972 L F
.41064 .44706 m .38824 .43972 L .37956 .43548 L F
.781 .886 1 r
.63543 .49223 m .63565 .47241 L .62017 .48855 L F
.63543 .49223 m .65054 .47315 L .63565 .47241 L F
.799 .944 1 r
.7487 .45079 m .75051 .45465 L .74124 .45462 L F
.7487 .45079 m .75796 .45177 L .75051 .45465 L F
.815 .956 1 r
.84533 .43284 m .81047 .43003 L .83312 .41956 L F
.818 .958 1 r
.87568 .42112 m .84533 .43284 L .83312 .41956 L F
0 g
.82274 .44142 m
.84533 .43284 L
s
.84533 .43284 m
.87362 .42192 L
s
.778 .928 1 r
.36226 .43646 m .32634 .42501 L .34683 .4266 L F
.777 .925 1 r
.37956 .43548 m .36226 .43646 L .34683 .4266 L F
0 g
.36226 .43646 m
.37094 .442 L
s
.34173 .43761 m
.36226 .43646 L
s
.804 .948 1 r
.78244 .4335 m .75796 .45177 L .7487 .45079 L F
.78244 .4335 m .7917 .43871 L .75796 .45177 L F
0 g
.75796 .45177 m
.77049 .45956 L
s
.816 .957 1 r
.88713 .4167 m .88016 .42676 L .87568 .42112 L F
.88713 .4167 m .8916 .42261 L .88016 .42676 L F
0 g
.88016 .42676 m
.88183 .42894 L
s
.782 .879 1 r
.49191 .46557 m .52827 .48987 L .54962 .46993 L F
.781 .892 1 r
.56798 .47455 m .54962 .46993 L .56423 .47526 L F
.784 .858 1 r
.54319 .5015 m .54962 .46993 L .52827 .48987 L F
.54319 .5015 m .56423 .47526 L .54962 .46993 L F
.805 .948 1 r
.24049 .39057 m .22629 .42119 L .20284 .3998 L F
0 g
.2355 .42969 m
.23713 .42921 L
s
.805 .948 1 r
.24049 .39057 m .26379 .41074 L .22629 .42119 L F
.807 .95 1 r
.27293 .41885 m .22629 .42119 L .26379 .41074 L F
0 g
.22629 .42119 m
.2355 .42969 L
s
.782 .886 1 r
.59385 .4822 m .56798 .47455 L .56423 .47526 L F
0 g
.55342 .47024 m
.56798 .47455 L
s
.56798 .47455 m
.5845 .47141 L
s
.816 .957 1 r
.92958 .40139 m .8916 .42261 L .88713 .4167 L F
.92958 .40139 m .93398 .40785 L .8916 .42261 L F
0 g
.93398 .40785 m
.94982 .43113 L
s
.778 .917 1 r
.70002 .46769 m .69626 .46813 L .68811 .47013 L F
.778 .919 1 r
.69626 .46813 m .65054 .47315 L .68811 .47013 L F
0 g
.69626 .46813 m
.70583 .46579 L
s
.779 .903 1 r
.67358 .48639 m .65054 .47315 L .63543 .49223 L F
.778 .917 1 r
.70002 .46769 m .69109 .46952 L .6919 .46982 L F
.69109 .46952 m .68811 .47013 L .6919 .46982 L F
.789 .937 1 r
.69793 .4721 m .6919 .46982 L .67743 .4858 L F
.786 .934 1 r
.74124 .45462 m .70002 .46769 L .6919 .46982 L F
.74124 .45462 m .6919 .46982 L .73335 .45458 L F
.789 .937 1 r
.71898 .45802 m .73335 .45458 L .6919 .46982 L F
.71898 .45802 m .6919 .46982 L .69793 .4721 L F
0 g
.69077 .46948 m
.69517 .4684 L
s
.777 .918 1 r
.33099 .418 m .32634 .42501 L .31059 .41351 L F
.33099 .418 m .34683 .4266 L .32634 .42501 L F
.793 .939 1 r
.28313 .41741 m .27293 .41885 L .26379 .41074 L F
0 g
.23713 .42921 m
.27293 .41885 L
s
.82 .959 1 r
.88713 .4167 m .87568 .42112 L .86356 .40587 L F
.818 .958 1 r
.87568 .42112 m .83312 .41956 L .86356 .40587 L F
0 g
.87362 .42192 m
.87568 .42112 L
s
.87568 .42112 m
.88016 .42676 L
s
.781 .888 1 r
.41064 .44706 m .37956 .43548 L .36411 .42794 L F
.777 .925 1 r
.37956 .43548 m .34683 .4266 L .36411 .42794 L F
0 g
.36226 .43646 m
.37956 .43548 L
s
.37956 .43548 m
.39086 .43969 L
s
.816 .957 1 r
.8012 .4227 m .7917 .43871 L .78244 .4335 L F
.8012 .4227 m .81047 .43003 L .7917 .43871 L F
.818 .958 1 r
.92958 .40139 m .88713 .4167 L .87504 .40071 L F
.82 .959 1 r
.88713 .4167 m .86356 .40587 L .87504 .40071 L F
0 g
.87568 .42112 m
.88713 .4167 L
s
.785 .85 1 r
.54319 .5015 m .59021 .48472 L .56423 .47526 L F
.782 .886 1 r
.59385 .4822 m .56423 .47526 L .59021 .48472 L F
0 g
.56423 .47526 m
.56798 .47455 L
s
.793 .939 1 r
.28313 .41741 m .26379 .41074 L .27399 .40969 L F
.79 .937 1 r
.31059 .41351 m .28313 .41741 L .27399 .40969 L F
0 g
.27293 .41885 m
.28313 .41741 L
s
.28313 .41741 m
.29891 .43073 L
s
.785 .856 1 r
.48986 .46714 m .48834 .46319 L .48629 .46459 L F
.48986 .46714 m .49191 .46557 L .48834 .46319 L F
.821 .961 1 r
.8238 .40968 m .81047 .43003 L .8012 .4227 L F
.8238 .40968 m .83312 .41956 L .81047 .43003 L F
0 g
.81047 .43003 m
.82274 .44142 L
s
.787 .935 1 r
.25068 .39032 m .26379 .41074 L .24049 .39057 L F
.25068 .39032 m .27399 .40969 L .26379 .41074 L F
.785 .847 1 r
.52628 .49315 m .49191 .46557 L .48986 .46714 L F
.52628 .49315 m .52827 .48987 L .49191 .46557 L F
0 g
.49191 .46557 m
.51377 .46431 L
s
.786 .84 1 r
.48986 .46714 m .48629 .46459 L .46524 .479 L F
.783 .875 1 r
.48629 .46459 m .4264 .44839 L .46524 .479 L F
0 g
.4551 .45506 m
.48629 .46459 L
s
.781 .893 1 r
.41766 .44967 m .41938 .44679 L .41064 .44706 L F
.41766 .44967 m .4264 .44839 L .41938 .44679 L F
0 g
.42526 .44856 m
.42744 .44921 L
s
.808 .951 1 r
.7487 .45079 m .74124 .45462 L .73335 .45458 L F
0 g
.70859 .46497 m
.74124 .45462 L
s
.778 .914 1 r
.34823 .42179 m .34683 .4266 L .33099 .418 L F
.34823 .42179 m .36411 .42794 L .34683 .4266 L F
0 g
.34683 .4266 m
.36226 .43646 L
s
.823 .962 1 r
.85428 .39408 m .83312 .41956 L .8238 .40968 L F
.85428 .39408 m .86356 .40587 L .83312 .41956 L F
.814 .955 1 r
.78244 .4335 m .7487 .45079 L .74083 .44996 L F
.808 .951 1 r
.7487 .45079 m .73335 .45458 L .74083 .44996 L F
0 g
.74124 .45462 m
.7487 .45079 L
s
.7487 .45079 m
.75796 .45177 L
s
.782 .883 1 r
.62017 .48855 m .59385 .4822 L .59021 .48472 L F
0 g
.56798 .47455 m
.59385 .4822 L
s
.785 .934 1 r
.27815 .38964 m .27399 .40969 L .25068 .39032 L F
.27815 .38964 m .30144 .40684 L .27399 .40969 L F
.79 .937 1 r
.31059 .41351 m .27399 .40969 L .30144 .40684 L F
0 g
.27399 .40969 m
.28313 .41741 L
s
.786 .84 1 r
.48986 .46714 m .46524 .479 L .46883 .48326 L F
.787 .831 1 r
.52628 .49315 m .48986 .46714 L .46883 .48326 L F
0 g
.48986 .46714 m
.49191 .46557 L
s
.48629 .46459 m
.48986 .46714 L
s
.4872 .46918 m
.48986 .46714 L
s
.48986 .46714 m
.4945 .47045 L
s
.779 .905 1 r
.67743 .4858 m .68811 .47013 L .67358 .48639 L F
.67743 .4858 m .6919 .46982 L .68811 .47013 L F
0 g
.68811 .47013 m
.69077 .46948 L
s
.818 .958 1 r
.92958 .40139 m .87504 .40071 L .9177 .38393 L F
0 g
.92958 .40139 m
.93398 .40785 L
s
.88713 .4167 m
.92958 .40139 L
s
.785 .85 1 r
.45651 .48662 m .4264 .44839 L .41766 .44967 L F
.45651 .48662 m .46524 .479 L .4264 .44839 L F
.803 .947 1 r
.24049 .39057 m .20284 .3998 L .20046 .39763 L F
0 g
.20284 .3998 m
.22629 .42119 L
s
.778 .911 1 r
.33099 .418 m .31059 .41351 L .30144 .40684 L F
0 g
.28313 .41741 m
.31059 .41351 L
s
.802 .946 1 r
.17392 .37345 m .23813 .38853 L .20046 .39763 L F
0 g
.20284 .3998 m
.20357 .39962 L
s
.803 .947 1 r
.24049 .39057 m .20046 .39763 L .23813 .38853 L F
0 g
.20046 .39763 m
.20284 .3998 L
s
.825 .963 1 r
.86577 .3882 m .86356 .40587 L .85428 .39408 L F
.86577 .3882 m .87504 .40071 L .86356 .40587 L F
0 g
.86356 .40587 m
.87568 .42112 L
s
.814 .955 1 r
.78244 .4335 m .74083 .44996 L .77458 .42908 L F
.825 .963 1 r
.8012 .4227 m .78244 .4335 L .77458 .42908 L F
0 g
.7487 .45079 m
.78244 .4335 L
s
.782 .875 1 r
.37903 .44654 m .36411 .42794 L .34823 .42179 L F
.37903 .44654 m .39502 .44753 L .36411 .42794 L F
0 g
.39086 .43969 m
.40494 .44494 L
s
.781 .888 1 r
.41064 .44706 m .36411 .42794 L .39502 .44753 L F
.785 .85 1 r
.54319 .5015 m .56985 .52227 L .59021 .48472 L F
0 g
.5491 .49412 m
.56423 .47526 L
s
.782 .883 1 r
.62017 .48855 m .59021 .48472 L .61664 .49224 L F
.783 .864 1 r
.59695 .52997 m .59021 .48472 L .56985 .52227 L F
.59695 .52997 m .61664 .49224 L .59021 .48472 L F
.82 .96 1 r
.90861 .37039 m .87504 .40071 L .86577 .3882 L F
.90861 .37039 m .9177 .38393 L .87504 .40071 L F
0 g
.9177 .38393 m
.92958 .40139 L
s
.83 .967 1 r
.8238 .40968 m .8012 .4227 L .79334 .41648 L F
.825 .963 1 r
.8012 .4227 m .77458 .42908 L .79334 .41648 L F
0 g
.78244 .4335 m
.8012 .4227 L
s
.8012 .4227 m
.81047 .43003 L
s
.782 .881 1 r
.41766 .44967 m .41064 .44706 L .39502 .44753 L F
0 g
.41064 .44706 m
.41938 .44679 L
s
.778 .907 1 r
.29846 .39747 m .30144 .40684 L .27815 .38964 L F
.29846 .39747 m .32179 .413 L .30144 .40684 L F
.778 .911 1 r
.33099 .418 m .30144 .40684 L .32179 .413 L F
.83 .967 1 r
.8238 .40968 m .79334 .41648 L .81592 .40133 L F
.827 .965 1 r
.85428 .39408 m .8238 .40968 L .81592 .40133 L F
0 g
.8012 .4227 m
.8238 .40968 L
s
.821 .96 1 r
.72644 .45096 m .73335 .45458 L .71898 .45802 L F
.72644 .45096 m .74083 .44996 L .73335 .45458 L F
.83 .967 1 r
.75999 .41921 m .74083 .44996 L .72644 .45096 L F
.75999 .41921 m .77458 .42908 L .74083 .44996 L F
0 g
.74083 .44996 m
.7487 .45079 L
s
.782 .878 1 r
.63543 .49223 m .62017 .48855 L .61664 .49224 L F
0 g
.59385 .4822 m
.62017 .48855 L
s
.62017 .48855 m
.63565 .47241 L
s
.782 .881 1 r
.41766 .44967 m .39502 .44753 L .40202 .45196 L F
.786 .837 1 r
.45651 .48662 m .41766 .44967 L .40202 .45196 L F
0 g
.41064 .44706 m
.41766 .44967 L
s
.779 .907 1 r
.34823 .42179 m .33099 .418 L .32179 .413 L F
0 g
.31059 .41351 m
.33099 .418 L
s
.33099 .418 m
.34683 .4266 L
s
.783 .932 1 r
.25068 .39032 m .24049 .39057 L .23813 .38853 L F
0 g
.20357 .39962 m
.24049 .39057 L
s
.83 .967 1 r
.86577 .3882 m .85428 .39408 L .84644 .38412 L F
.827 .965 1 r
.85428 .39408 m .81592 .40133 L .84644 .38412 L F
0 g
.8238 .40968 m
.85428 .39408 L
s
.85428 .39408 m
.86356 .40587 L
s
.784 .933 1 r
.22202 .36488 m .23813 .38853 L .21178 .36503 L F
.22202 .36488 m .24831 .38835 L .23813 .38853 L F
.802 .946 1 r
.17392 .37345 m .21178 .36503 L .23813 .38853 L F
.783 .932 1 r
.25068 .39032 m .23813 .38853 L .24831 .38835 L F
.839 .974 1 r
.77873 .40298 m .77458 .42908 L .75999 .41921 L F
.77873 .40298 m .79334 .41648 L .77458 .42908 L F
.822 .961 1 r
.90861 .37039 m .86577 .3882 L .85794 .37764 L F
.83 .967 1 r
.86577 .3882 m .84644 .38412 L .85794 .37764 L F
0 g
.85428 .39408 m
.86577 .3882 L
s
.844 .978 1 r
.80123 .38348 m .79334 .41648 L .77873 .40298 L F
.80123 .38348 m .81592 .40133 L .79334 .41648 L F
0 g
.79334 .41648 m
.8012 .4227 L
s
.781 .931 1 r
.27815 .38964 m .25068 .39032 L .24831 .38835 L F
0 g
.24049 .39057 m
.25068 .39032 L
s
.25068 .39032 m
.27399 .40969 L
s
.783 .864 1 r
.59695 .52997 m .63197 .49659 L .61664 .49224 L F
.782 .878 1 r
.63543 .49223 m .61664 .49224 L .63197 .49659 L F
0 g
.61664 .49224 m
.62017 .48855 L
s
.779 .906 1 r
.67358 .48639 m .63543 .49223 L .63197 .49659 L F
0 g
.62017 .48855 m
.63543 .49223 L
s
.835 .971 1 r
.83189 .36413 m .81592 .40133 L .80123 .38348 L F
.83189 .36413 m .84644 .38412 L .81592 .40133 L F
.784 .932 1 r
.22202 .36488 m .27578 .38789 L .24831 .38835 L F
.781 .931 1 r
.27815 .38964 m .24831 .38835 L .27578 .38789 L F
0 g
.24831 .38835 m
.25068 .39032 L
s
.786 .832 1 r
.54122 .50492 m .52827 .48987 L .52628 .49315 L F
.54122 .50492 m .54319 .5015 L .52827 .48987 L F
.779 .906 1 r
.31567 .4041 m .32179 .413 L .29846 .39747 L F
.31567 .4041 m .33899 .41822 L .32179 .413 L F
.782 .877 1 r
.32569 .41218 m .33899 .41822 L .31567 .4041 L F
.779 .907 1 r
.34318 .42012 m .32179 .413 L .33899 .41822 L F
.782 .877 1 r
.3466 .42905 m .33899 .41822 L .32569 .41218 L F
.779 .907 1 r
.34823 .42179 m .34318 .42012 L .33899 .41822 L F
0 g
.33099 .418 m
.33362 .41858 L
s
.34028 .42004 m
.34474 .42103 L
s
.32179 .413 m
.33099 .418 L
s
.783 .867 1 r
.37903 .44654 m .34823 .42179 L .33899 .41822 L F
.802 .946 1 r
.20694 .36036 m .17392 .37345 L .16903 .36891 L F
.20694 .36036 m .21178 .36503 L .17392 .37345 L F
0 g
.17392 .37345 m
.20046 .39763 L
s
.837 .972 1 r
.84344 .35685 m .84644 .38412 L .83189 .36413 L F
.84344 .35685 m .85794 .37764 L .84644 .38412 L F
0 g
.84644 .38412 m
.85428 .39408 L
s
.787 .83 1 r
.54122 .50492 m .52628 .49315 L .50565 .52698 L F
.787 .831 1 r
.52628 .49315 m .46883 .48326 L .50565 .52698 L F
0 g
.4945 .47045 m
.52628 .49315 L
s
.822 .961 1 r
.90861 .37039 m .85794 .37764 L .90093 .35895 L F
0 g
.86577 .3882 m
.90861 .37039 L
s
.90861 .37039 m
.9177 .38393 L
s
.824 .963 1 r
.88679 .33751 m .85794 .37764 L .84344 .35685 L F
.88679 .33751 m .90093 .35895 L .85794 .37764 L F
0 g
.90093 .35895 m
.90861 .37039 L
s
.803 .947 1 r
.20694 .36036 m .16903 .36891 L .14668 .34822 L F
0 g
.16903 .36891 m
.17392 .37345 L
s
.783 .864 1 r
.59695 .52997 m .61267 .53444 L .63197 .49659 L F
.779 .906 1 r
.67358 .48639 m .63197 .49659 L .67027 .49011 L F
.777 .915 1 r
.65138 .51002 m .63197 .49659 L .61267 .53444 L F
.65138 .51002 m .67027 .49011 L .63197 .49659 L F
.783 .871 1 r
.38602 .45216 m .39502 .44753 L .37903 .44654 L F
.38602 .45216 m .40202 .45196 L .39502 .44753 L F
0 g
.39502 .44753 m
.41064 .44706 L
s
.779 .904 1 r
.29846 .39747 m .27815 .38964 L .27578 .38789 L F
0 g
.25068 .39032 m
.27815 .38964 L
s
.787 .822 1 r
.46011 .49103 m .46524 .479 L .45651 .48662 L F
.46011 .49103 m .46883 .48326 L .46524 .479 L F
.782 .877 1 r
.3466 .42905 m .36971 .44597 L .33899 .41822 L F
.783 .867 1 r
.37903 .44654 m .33899 .41822 L .36971 .44597 L F
.779 .908 1 r
.67743 .4858 m .67358 .48639 L .67027 .49011 L F
0 g
.63543 .49223 m
.67358 .48639 L
s
.67358 .48639 m
.68811 .47013 L
s
.778 .913 1 r
.27021 .36991 m .27578 .38789 L .24964 .3645 L F
.27021 .36991 m .29609 .39589 L .27578 .38789 L F
.784 .932 1 r
.22202 .36488 m .24964 .3645 L .27578 .38789 L F
.779 .904 1 r
.29846 .39747 m .27578 .38789 L .29609 .39589 L F
.786 .831 1 r
.56794 .52597 m .54319 .5015 L .54122 .50492 L F
.56794 .52597 m .56985 .52227 L .54319 .5015 L F
0 g
.54319 .5015 m
.5491 .49412 L
s
.785 .839 1 r
.42493 .50079 m .40202 .45196 L .38602 .45216 L F
.42493 .50079 m .4408 .50034 L .40202 .45196 L F
.786 .837 1 r
.45651 .48662 m .40202 .45196 L .4408 .50034 L F
0 g
.41766 .44967 m
.44564 .47628 L
s
.804 .948 1 r
.71898 .45802 m .67743 .4858 L .67413 .48945 L F
.779 .908 1 r
.67743 .4858 m .67027 .49011 L .67413 .48945 L F
0 g
.67358 .48639 m
.67743 .4858 L
s
.787 .82 1 r
.49709 .53633 m .46883 .48326 L .46011 .49103 L F
.49709 .53633 m .50565 .52698 L .46883 .48326 L F
0 g
.46883 .48326 m
.4872 .46918 L
s
.787 .935 1 r
.2172 .36004 m .21178 .36503 L .20694 .36036 L F
.2172 .36004 m .22202 .36488 L .21178 .36503 L F
.787 .83 1 r
.54122 .50492 m .50565 .52698 L .52088 .54031 L F
.787 .829 1 r
.56794 .52597 m .54122 .50492 L .52088 .54031 L F
0 g
.52628 .49315 m
.54122 .50492 L
s
.54122 .50492 m
.54319 .5015 L
s
.54122 .50492 m
.5415 .50514 L
s
.846 .979 1 r
.75999 .41921 m .72317 .45119 L .75669 .41698 L F
.75999 .41921 m .72644 .45096 L .72317 .45119 L F
.848 .981 1 r
.77873 .40298 m .75999 .41921 L .75669 .41698 L F
.854 .985 1 r
.80123 .38348 m .77873 .40298 L .77543 .39992 L F
.848 .981 1 r
.77873 .40298 m .75669 .41698 L .77543 .39992 L F
0 g
.75999 .41921 m
.77873 .40298 L
s
.77873 .40298 m
.79334 .41648 L
s
.837 .972 1 r
.72644 .45096 m .71571 .4588 L .72317 .45119 L F
.72644 .45096 m .71898 .45802 L .71571 .4588 L F
0 g
.72644 .45096 m
.74083 .44996 L
s
.72644 .45096 m
.75999 .41921 L
s
.804 .948 1 r
.71898 .45802 m .67413 .48945 L .71571 .4588 L F
0 g
.71898 .45802 m
.72644 .45096 L
s
.67743 .4858 m
.69518 .47393 L
s
.854 .985 1 r
.80123 .38348 m .77543 .39992 L .79791 .37945 L F
.838 .973 1 r
.83189 .36413 m .80123 .38348 L .79791 .37945 L F
0 g
.77873 .40298 m
.80123 .38348 L
s
.776 .924 1 r
.65138 .51002 m .67413 .48945 L .67027 .49011 L F
0 g
.67027 .49011 m
.67358 .48639 L
s
.79 .937 1 r
.2172 .36004 m .20694 .36036 L .18486 .33906 L F
.803 .947 1 r
.20694 .36036 m .14668 .34822 L .18486 .33906 L F
0 g
.16903 .36891 m
.20694 .36036 L
s
.838 .973 1 r
.65527 .50757 m .71571 .4588 L .67413 .48945 L F
.776 .924 1 r
.65138 .51002 m .65527 .50757 L .67413 .48945 L F
.788 .936 1 r
.24489 .35919 m .22202 .36488 L .2172 .36004 L F
.24489 .35919 m .24964 .3645 L .22202 .36488 L F
0 g
.22202 .36488 m
.24831 .38835 L
s
.84 .974 1 r
.84344 .35685 m .83189 .36413 L .82862 .35963 L F
.838 .973 1 r
.83189 .36413 m .79791 .37945 L .82862 .35963 L F
0 g
.80123 .38348 m
.83189 .36413 L
s
.83189 .36413 m
.84644 .38412 L
s
.876 1 1 r
.70412 .44129 m .75669 .41698 L .72317 .45119 L F
.70412 .44129 m .73746 .39417 L .75669 .41698 L F
.865 .993 1 r
.75633 .37478 m .75669 .41698 L .73746 .39417 L F
.75633 .37478 m .77543 .39992 L .75669 .41698 L F
.868 .995 1 r
.75633 .37478 m .79791 .37945 L .77543 .39992 L F
0 g
.77543 .39992 m
.77873 .40298 L
s
.868 .995 1 r
.75633 .37478 m .77894 .35155 L .79791 .37945 L F
.843 .976 1 r
.81003 .33168 m .79791 .37945 L .77894 .35155 L F
.81003 .33168 m .82862 .35963 L .79791 .37945 L F
.825 .963 1 r
.88679 .33751 m .84344 .35685 L .84017 .35217 L F
.84 .974 1 r
.84344 .35685 m .82862 .35963 L .84017 .35217 L F
0 g
.83189 .36413 m
.84344 .35685 L
s
.867 .994 1 r
.70412 .44129 m .72317 .45119 L .71571 .4588 L F
0 g
.72317 .45119 m
.72644 .45096 L
s
.779 .903 1 r
.31567 .4041 m .29846 .39747 L .29609 .39589 L F
0 g
.29846 .39747 m
.32179 .413 L
s
.27815 .38964 m
.29846 .39747 L
s
.805 .948 1 r
.17246 .32623 m .14668 .34822 L .13408 .33626 L F
.17246 .32623 m .18486 .33906 L .14668 .34822 L F
0 g
.14668 .34822 m
.16903 .36891 L
s
.838 .973 1 r
.65527 .50757 m .69666 .45183 L .71571 .4588 L F
.867 .994 1 r
.70412 .44129 m .71571 .4588 L .69666 .45183 L F
.79 .937 1 r
.2172 .36004 m .18486 .33906 L .19524 .33797 L F
.792 .938 1 r
.24489 .35919 m .2172 .36004 L .19524 .33797 L F
0 g
.20694 .36036 m
.2172 .36004 L
s
.2172 .36004 m
.22202 .36488 L
s
.788 .819 1 r
.46011 .49103 m .45651 .48662 L .4408 .50034 L F
0 g
.44564 .47628 m
.45651 .48662 L
s
.843 .976 1 r
.81003 .33168 m .84017 .35217 L .82862 .35963 L F
0 g
.82862 .35963 m
.83189 .36413 L
s
.777 .915 1 r
.27021 .36991 m .3133 .40266 L .29609 .39589 L F
.778 .905 1 r
.31934 .38645 m .332 .40723 L .3133 .40266 L F
.779 .903 1 r
.31567 .4041 m .31078 .40205 L .3133 .40266 L F
.781 .88 1 r
.3466 .42905 m .31567 .4041 L .3133 .40266 L F
.3466 .42905 m .3133 .40266 L .34425 .42733 L F
.778 .905 1 r
.332 .40723 m .34425 .42733 L .3133 .40266 L F
.779 .903 1 r
.31078 .40205 m .29609 .39589 L .3133 .40266 L F
0 g
.29846 .39747 m
.31006 .40194 L
s
.31006 .40194 m
.31457 .40367 L
s
.29609 .39589 m
.29846 .39747 L
s
.843 .976 1 r
.81003 .33168 m .82173 .3242 L .84017 .35217 L F
.825 .963 1 r
.82173 .3242 m .88361 .33268 L .84017 .35217 L F
.88679 .33751 m .84017 .35217 L .88361 .33268 L F
0 g
.84344 .35685 m
.88679 .33751 L
s
.88679 .33751 m
.90093 .35895 L
s
.784 .863 1 r
.38602 .45216 m .37903 .44654 L .36971 .44597 L F
0 g
.37903 .44654 m
.39502 .44753 L
s
.34823 .42179 m
.37903 .44654 L
s
.788 .819 1 r
.46011 .49103 m .4408 .50034 L .44443 .50503 L F
.788 .818 1 r
.49709 .53633 m .46011 .49103 L .44443 .50503 L F
0 g
.45651 .48662 m
.46011 .49103 L
s
.46011 .49103 m
.46883 .48326 L
s
.45995 .49118 m
.46011 .49103 L
s
.783 .87 1 r
.59507 .53251 m .56985 .52227 L .56794 .52597 L F
.59507 .53251 m .59695 .52997 L .56985 .52227 L F
.785 .839 1 r
.42493 .50079 m .38602 .45216 L .37668 .45227 L F
.784 .863 1 r
.38602 .45216 m .36971 .44597 L .37668 .45227 L F
0 g
.37903 .44654 m
.38602 .45216 L
s
.807 .95 1 r
.17246 .32623 m .13408 .33626 L .11874 .3217 L F
0 g
.13408 .33626 m
.14668 .34822 L
s
.776 .923 1 r
.26555 .36365 m .24964 .3645 L .24489 .35919 L F
.26555 .36365 m .27021 .36991 L .24964 .3645 L F
.825 .963 1 r
.82173 .3242 m .86577 .30531 L .88361 .33268 L F
0 g
.88361 .33268 m
.88679 .33751 L
s
.778 .905 1 r
.31934 .38645 m .3133 .40266 L .28762 .37449 L F
0 g
.29431 .3941 m
.29609 .39589 L
s
.777 .915 1 r
.27021 .36991 m .28762 .37449 L .3133 .40266 L F
.781 .886 1 r
.59507 .53251 m .56794 .52597 L .54814 .56419 L F
0 g
.57151 .52683 m
.57826 .52846 L
s
.787 .829 1 r
.56794 .52597 m .52088 .54031 L .54814 .56419 L F
0 g
.5415 .50514 m
.56794 .52597 L
s
.56794 .52597 m
.57151 .52683 L
s
.797 .942 1 r
.18293 .32453 m .18486 .33906 L .17246 .32623 L F
.18293 .32453 m .19524 .33797 L .18486 .33906 L F
.782 .931 1 r
.26555 .36365 m .24489 .35919 L .22323 .33503 L F
.792 .938 1 r
.24489 .35919 m .19524 .33797 L .22323 .33503 L F
0 g
.2172 .36004 m
.24489 .35919 L
s
.781 .878 1 r
.35362 .43471 m .36971 .44597 L .3466 .42905 L F
.35362 .43471 m .37668 .45227 L .36971 .44597 L F
0 g
.36971 .44597 m
.37903 .44654 L
s
.799 .944 1 r
.21114 .31997 m .19524 .33797 L .18293 .32453 L F
.21114 .31997 m .22323 .33503 L .19524 .33797 L F
0 g
.19524 .33797 m
.2172 .36004 L
s
.845 .978 1 r
.8083 .32896 m .77894 .35155 L .77716 .34863 L F
.8083 .32896 m .81003 .33168 L .77894 .35155 L F
.879 1 1 r
.77716 .34863 m .77894 .35155 L .75633 .37478 L F
.881 1 1 r
.75451 .37171 m .75633 .37478 L .73746 .39417 L F
.879 1 1 r
.77716 .34863 m .75633 .37478 L .75451 .37171 L F
0 g
.75633 .37478 m
.77543 .39992 L
s
.842 .975 1 r
.8083 .32896 m .77716 .34863 L .75916 .31904 L F
.875 1 1 r
.77716 .34863 m .73613 .34062 L .75916 .31904 L F
.77716 .34863 m .75451 .37171 L .73613 .34062 L F
.881 1 1 r
.75451 .37171 m .73746 .39417 L .73562 .39097 L F
.909 1 1 r
.73562 .39097 m .73746 .39417 L .70412 .44129 L F
.809 .952 1 r
.13697 .28905 m .11874 .3217 L .09796 .30164 L F
.13697 .28905 m .15738 .31062 L .11874 .3217 L F
.807 .95 1 r
.17246 .32623 m .11874 .3217 L .15738 .31062 L F
0 g
.11874 .3217 m
.13408 .33626 L
s
.877 1 1 r
.75451 .37171 m .71694 .35862 L .73613 .34062 L F
.75451 .37171 m .73562 .39097 L .71694 .35862 L F
0 g
.75451 .37171 m
.75633 .37478 L
s
.75451 .37171 m
.77716 .34863 L
s
.785 .839 1 r
.42493 .50079 m .37668 .45227 L .41567 .50105 L F
.781 .877 1 r
.39329 .46547 m .41567 .50105 L .37668 .45227 L F
.39329 .46547 m .37668 .45227 L .35362 .43471 L F
0 g
.38602 .45216 m
.40125 .47119 L
s
.909 1 1 r
.73562 .39097 m .70412 .44129 L .70224 .43842 L F
.913 1 1 r
.73562 .39097 m .68327 .40936 L .71694 .35862 L F
.73562 .39097 m .70224 .43842 L .68327 .40936 L F
0 g
.73562 .39097 m
.75451 .37171 L
s
.843 .977 1 r
.82003 .32156 m .81003 .33168 L .8083 .32896 L F
.82003 .32156 m .82173 .3242 L .81003 .33168 L F
0 g
.81003 .33168 m
.82862 .35963 L
s
.777 .927 1 r
.28302 .36742 m .27021 .36991 L .26555 .36365 L F
.28302 .36742 m .28762 .37449 L .27021 .36991 L F
0 g
.27021 .36991 m
.29431 .3941 L
s
.802 .946 1 r
.18293 .32453 m .17246 .32623 L .15738 .31062 L F
0 g
.13408 .33626 m
.17246 .32623 L
s
.782 .879 1 r
.61081 .5363 m .59695 .52997 L .59507 .53251 L F
.61081 .5363 m .61267 .53444 L .59695 .52997 L F
0 g
.59695 .52997 m
.61664 .49224 L
s
.824 .963 1 r
.86412 .30278 m .82173 .3242 L .82003 .32156 L F
.86412 .30278 m .86577 .30531 L .82173 .3242 L F
0 g
.86577 .30531 m
.88361 .33268 L
s
.84 .974 1 r
.82003 .32156 m .8083 .32896 L .79081 .30144 L F
.842 .975 1 r
.8083 .32896 m .75916 .31904 L .79081 .30144 L F
0 g
.77716 .34863 m
.8083 .32896 L
s
.8083 .32896 m
.81003 .33168 L
s
.84 .974 1 r
.82003 .32156 m .79081 .30144 L .80273 .29481 L F
.822 .961 1 r
.86412 .30278 m .82003 .32156 L .80273 .29481 L F
0 g
.8083 .32896 m
.82003 .32156 L
s
.82003 .32156 m
.86326 .30315 L
s
.785 .849 1 r
.51242 .54705 m .50565 .52698 L .49709 .53633 L F
.51242 .54705 m .52088 .54031 L .50565 .52698 L F
.782 .931 1 r
.26555 .36365 m .22323 .33503 L .24431 .33516 L F
.787 .934 1 r
.28302 .36742 m .26555 .36365 L .24431 .33516 L F
0 g
.24489 .35919 m
.26555 .36365 L
s
.26555 .36365 m
.27021 .36991 L
s
.802 .946 1 r
.18293 .32453 m .15738 .31062 L .16796 .3082 L F
.804 .948 1 r
.21114 .31997 m .18293 .32453 L .16796 .3082 L F
0 g
.17246 .32623 m
.18293 .32453 L
s
.18293 .32453 m
.19524 .33797 L
s
.781 .886 1 r
.59507 .53251 m .54814 .56419 L .57575 .55866 L F
.78 .895 1 r
.61081 .5363 m .59507 .53251 L .57575 .55866 L F
0 g
.57826 .52846 m
.59507 .53251 L
s
.59507 .53251 m
.59695 .52997 L
s
.907 1 1 r
.70224 .43842 m .70412 .44129 L .69666 .45183 L F
0 g
.70412 .44129 m
.72317 .45119 L
s
.785 .847 1 r
.4286 .50432 m .4408 .50034 L .42493 .50079 L F
.4286 .50432 m .44443 .50503 L .4408 .50034 L F
.907 1 1 r
.70224 .43842 m .69666 .45183 L .69478 .44903 L F
.892 1 1 r
.69478 .44903 m .69666 .45183 L .65527 .50757 L F
.911 1 1 r
.70224 .43842 m .67574 .42072 L .68327 .40936 L F
.70224 .43842 m .69478 .44903 L .67574 .42072 L F
0 g
.70224 .43842 m
.73562 .39097 L
s
.70224 .43842 m
.70412 .44129 L
s
.797 .942 1 r
.23245 .31793 m .22323 .33503 L .21114 .31997 L F
.23245 .31793 m .24431 .33516 L .22323 .33503 L F
.892 1 1 r
.69478 .44903 m .65527 .50757 L .6534 .50661 L F
.911 1 1 r
.69478 .44903 m .63437 .49692 L .67574 .42072 L F
.69478 .44903 m .6534 .50661 L .63437 .49692 L F
0 g
.69478 .44903 m
.70224 .43842 L
s
.809 .952 1 r
.64952 .50932 m .65138 .51002 L .61267 .53444 L F
.64952 .50932 m .61267 .53444 L .61081 .5363 L F
.784 .856 1 r
.46619 .54043 m .44443 .50503 L .4286 .50432 L F
.46619 .54043 m .48167 .55319 L .44443 .50503 L F
.788 .818 1 r
.49709 .53633 m .44443 .50503 L .48167 .55319 L F
0 g
.44443 .50503 m
.45995 .49118 L
s
.779 .928 1 r
.31489 .37691 m .28762 .37449 L .28302 .36742 L F
.31489 .37691 m .31934 .38645 L .28762 .37449 L F
.807 .95 1 r
.14768 .28586 m .15738 .31062 L .13697 .28905 L F
.14768 .28586 m .16796 .3082 L .15738 .31062 L F
.822 .961 1 r
.86412 .30278 m .80273 .29481 L .84742 .27719 L F
0 g
.86412 .30278 m
.86577 .30531 L
s
.86326 .30315 m
.86412 .30278 L
s
.838 .973 1 r
.64952 .50932 m .61081 .5363 L .59167 .55547 L F
.78 .895 1 r
.61081 .5363 m .57575 .55866 L .59167 .55547 L F
0 g
.59507 .53251 m
.61081 .5363 L
s
.61081 .5363 m
.64467 .5127 L
s
.795 .94 1 r
.31489 .37691 m .28302 .36742 L .26209 .33526 L F
.787 .934 1 r
.28302 .36742 m .24431 .33516 L .26209 .33526 L F
0 g
.26555 .36365 m
.28302 .36742 L
s
.811 .953 1 r
.13697 .28905 m .09796 .30164 L .09007 .29402 L F
0 g
.09796 .30164 m
.11874 .3217 L
s
.826 .964 1 r
.6534 .50661 m .65138 .51002 L .64952 .50932 L F
.6534 .50661 m .65527 .50757 L .65138 .51002 L F
.837 .972 1 r
.7837 .29037 m .75916 .31904 L .75184 .30694 L F
.7837 .29037 m .79081 .30144 L .75916 .31904 L F
.871 .997 1 r
.75184 .30694 m .75916 .31904 L .73613 .34062 L F
.876 1 1 r
.7286 .32689 m .73613 .34062 L .71694 .35862 L F
.871 .997 1 r
.75184 .30694 m .73613 .34062 L .7286 .32689 L F
0 g
.73613 .34062 m
.75451 .37171 L
s
.876 1 1 r
.7286 .32689 m .71694 .35862 L .70924 .3435 L F
.925 1 1 r
.70924 .3435 m .71694 .35862 L .68327 .40936 L F
.781 .881 1 r
.35362 .43471 m .3466 .42905 L .34425 .42733 L F
0 g
.3466 .42905 m
.36971 .44597 L
s
.34404 .42698 m
.3466 .42905 L
s
.809 .951 1 r
.17652 .2773 m .16796 .3082 L .14768 .28586 L F
.17652 .2773 m .19645 .30168 L .16796 .3082 L F
.804 .948 1 r
.21114 .31997 m .16796 .3082 L .19645 .30168 L F
0 g
.14906 .28738 m
.16796 .3082 L
s
.16796 .3082 m
.18293 .32453 L
s
.784 .858 1 r
.53981 .5662 m .52088 .54031 L .51242 .54705 L F
.53981 .5662 m .54814 .56419 L .52088 .54031 L F
0 g
.52088 .54031 m
.54122 .50492 L
s
.805 .948 1 r
.23245 .31793 m .21114 .31997 L .19645 .30168 L F
0 g
.18293 .32453 m
.21114 .31997 L
s
.838 .973 1 r
.64952 .50932 m .59167 .55547 L .63051 .50221 L F
.855 .985 1 r
.6534 .50661 m .64952 .50932 L .63051 .50221 L F
0 g
.64952 .50932 m
.65138 .51002 L
s
.781 .881 1 r
.35362 .43471 m .34425 .42733 L .35127 .43293 L F
.776 .911 1 r
.31934 .38645 m .35127 .43293 L .34425 .42733 L F
.855 .985 1 r
.6534 .50661 m .63051 .50221 L .63437 .49692 L F
0 g
.6534 .50661 m
.69478 .44903 L
s
.64952 .50932 m
.6534 .50661 L
s
.801 .945 1 r
.2504 .3162 m .24431 .33516 L .23245 .31793 L F
.2504 .3162 m .26209 .33526 L .24431 .33516 L F
0 g
.24431 .33516 m
.26555 .36365 L
s
.784 .865 1 r
.51242 .54705 m .49709 .53633 L .48167 .55319 L F
0 g
.46011 .49103 m
.49709 .53633 L
s
.834 .97 1 r
.79571 .28412 m .79081 .30144 L .7837 .29037 L F
.79571 .28412 m .80273 .29481 L .79081 .30144 L F
0 g
.79081 .30144 m
.8083 .32896 L
s
.812 .954 1 r
.06057 .26556 m .12921 .28085 L .09007 .29402 L F
.811 .953 1 r
.13697 .28905 m .09007 .29402 L .12921 .28085 L F
0 g
.09007 .29402 m
.09796 .30164 L
s
.925 1 1 r
.70924 .3435 m .68327 .40936 L .67528 .39141 L F
.867 .994 1 r
.7286 .32689 m .70924 .3435 L .69565 .3168 L F
.916 1 1 r
.70924 .3435 m .66119 .35979 L .69565 .3168 L F
.70924 .3435 m .67528 .39141 L .66119 .35979 L F
.867 .994 1 r
.7286 .32689 m .69565 .3168 L .71527 .3026 L F
.862 .99 1 r
.75184 .30694 m .7286 .32689 L .71527 .3026 L F
0 g
.7286 .32689 m
.73613 .34062 L
s
.70924 .3435 m
.7286 .32689 L
s
.779 .892 1 r
.39329 .46547 m .35362 .43471 L .35127 .43293 L F
0 g
.35111 .43269 m
.35362 .43471 L
s
.832 .968 1 r
.7837 .29037 m .75184 .30694 L .73888 .28551 L F
.862 .99 1 r
.75184 .30694 m .71527 .3026 L .73888 .28551 L F
0 g
.7286 .32689 m
.75184 .30694 L
s
.82 .959 1 r
.84063 .26686 m .80273 .29481 L .79571 .28412 L F
.84063 .26686 m .84742 .27719 L .80273 .29481 L F
0 g
.84742 .27719 m
.86412 .30278 L
s
.785 .932 1 r
.3265 .38916 m .39102 .46188 L .35127 .43293 L F
0 g
.34014 .42058 m
.34425 .42733 L
s
.776 .911 1 r
.31934 .38645 m .3265 .38916 L .35127 .43293 L F
.779 .892 1 r
.39329 .46547 m .35127 .43293 L .39102 .46188 L F
.93 1 1 r
.67528 .39141 m .68327 .40936 L .67574 .42072 L F
0 g
.68327 .40936 m
.70224 .43842 L
s
.805 .948 1 r
.23245 .31793 m .19645 .30168 L .21806 .29703 L F
.81 .952 1 r
.2504 .3162 m .23245 .31793 L .21806 .29703 L F
0 g
.21114 .31997 m
.23245 .31793 L
s
.23245 .31793 m
.24431 .33516 L
s
.93 1 1 r
.67528 .39141 m .67574 .42072 L .66769 .40213 L F
.958 1 1 r
.66769 .40213 m .67574 .42072 L .63437 .49692 L F
.812 .953 1 r
.1984 .27066 m .19645 .30168 L .17652 .2773 L F
.1984 .27066 m .21806 .29703 L .19645 .30168 L F
.28336 .31093 m .26209 .33526 L .2504 .3162 L F
.28336 .31093 m .29474 .33371 L .26209 .33526 L F
.795 .94 1 r
.31489 .37691 m .26209 .33526 L .29474 .33371 L F
.811 .953 1 r
.14768 .28586 m .13697 .28905 L .12921 .28085 L F
0 g
.09796 .30164 m
.13697 .28905 L
s
.832 .968 1 r
.7837 .29037 m .73888 .28551 L .7711 .27073 L F
.83 .967 1 r
.79571 .28412 m .7837 .29037 L .7711 .27073 L F
0 g
.7837 .29037 m
.79081 .30144 L
s
.75184 .30694 m
.7837 .29037 L
s
.783 .863 1 r
.4286 .50432 m .42493 .50079 L .41567 .50105 L F
0 g
.40125 .47119 m
.42493 .50079 L
s
.921 1 1 r
.67528 .39141 m .6535 .36938 L .66119 .35979 L F
.67528 .39141 m .66769 .40213 L .6535 .36938 L F
0 g
.67528 .39141 m
.70924 .3435 L
s
.67528 .39141 m
.68327 .40936 L
s
.83 .967 1 r
.79571 .28412 m .7711 .27073 L .78326 .26515 L F
.818 .958 1 r
.84063 .26686 m .79571 .28412 L .78326 .26515 L F
0 g
.7837 .29037 m
.79571 .28412 L
s
.79571 .28412 m
.83271 .26991 L
s
.853 .984 1 r
.70185 .27945 m .69565 .3168 L .68197 .29136 L F
.70185 .27945 m .71527 .3026 L .69565 .3168 L F
.9 1 1 r
.68197 .29136 m .69565 .3168 L .66119 .35979 L F
.958 1 1 r
.66769 .40213 m .63437 .49692 L .62613 .47854 L F
.66769 .40213 m .61162 .44617 L .6535 .36938 L F
.66769 .40213 m .62613 .47854 L .61162 .44617 L F
0 g
.66769 .40213 m
.67528 .39141 L
s
.783 .863 1 r
.4286 .50432 m .41567 .50105 L .41937 .5039 L F
.782 .872 1 r
.46619 .54043 m .4286 .50432 L .41937 .5039 L F
0 g
.42493 .50079 m
.4286 .50432 L
s
.4286 .50432 m
.44443 .50503 L
s
.811 .953 1 r
.14768 .28586 m .12921 .28085 L .13998 .27738 L F
.813 .954 1 r
.17652 .2773 m .14768 .28586 L .13998 .27738 L F
0 g
.13697 .28905 m
.14768 .28586 L
s
.14768 .28586 m
.14906 .28738 L
s
.784 .865 1 r
.51242 .54705 m .48167 .55319 L .49722 .55917 L F
.783 .874 1 r
.53981 .5662 m .51242 .54705 L .49722 .55917 L F
0 g
.49709 .53633 m
.51242 .54705 L
s
.51242 .54705 m
.52088 .54031 L
s
.849 .981 1 r
.7258 .2651 m .71527 .3026 L .70185 .27945 L F
.7258 .2651 m .73888 .28551 L .71527 .3026 L F
0 g
.71527 .3026 m
.7286 .32689 L
s
.788 .934 1 r
.32208 .37905 m .31934 .38645 L .31489 .37691 L F
.32208 .37905 m .3265 .38916 L .31934 .38645 L F
0 g
.31934 .38645 m
.34014 .42058 L
s
.813 .954 1 r
.1111 .24679 m .12921 .28085 L .10018 .25084 L F
.1111 .24679 m .13998 .27738 L .12921 .28085 L F
.812 .954 1 r
.06057 .26556 m .10018 .25084 L .12921 .28085 L F
0 g
.06057 .26556 m
.09007 .29402 L
s
.825 .964 1 r
.75834 .25153 m .73888 .28551 L .7258 .2651 L F
.75834 .25153 m .7711 .27073 L .73888 .28551 L F
.822 .96 1 r
.28336 .31093 m .2504 .3162 L .23624 .29311 L F
.81 .952 1 r
.2504 .3162 m .21806 .29703 L .23624 .29311 L F
0 g
.23245 .31793 m
.2504 .3162 L
s
.804 .946 1 r
.32208 .37905 m .31489 .37691 L .29474 .33371 L F
0 g
.31489 .37691 m
.31934 .38645 L
s
.28302 .36742 m
.31489 .37691 L
s
.814 .955 1 r
.2168 .26508 m .21806 .29703 L .1984 .27066 L F
.2168 .26508 m .23624 .29311 L .21806 .29703 L F
0 g
.21806 .29703 m
.23245 .31793 L
s
.908 1 1 r
.64692 .3264 m .66119 .35979 L .6535 .36938 L F
.9 1 1 r
.68197 .29136 m .66119 .35979 L .64692 .3264 L F
0 g
.66119 .35979 m
.67528 .39141 L
s
.908 1 1 r
.64692 .3264 m .6535 .36938 L .63912 .33419 L F
.961 1 1 r
.63912 .33419 m .6535 .36938 L .61162 .44617 L F
.814 .955 1 r
.1111 .24679 m .16895 .26804 L .13998 .27738 L F
.813 .954 1 r
.17652 .2773 m .13998 .27738 L .16895 .26804 L F
0 g
.13998 .27738 m
.14768 .28586 L
s
.13709 .27432 m
.13998 .27738 L
s
.82 .957 1 r
.363 .37972 m .3265 .38916 L .32208 .37905 L F
.363 .37972 m .36729 .39277 L .3265 .38916 L F
.785 .932 1 r
.3265 .38916 m .36729 .39277 L .39102 .46188 L F
.797 .943 1 r
.56751 .55278 m .54814 .56419 L .53981 .5662 L F
.56751 .55278 m .57575 .55866 L .54814 .56419 L F
.804 .946 1 r
.32208 .37905 m .29474 .33371 L .30209 .33336 L F
.835 .969 1 r
.363 .37972 m .32208 .37905 L .30209 .33336 L F
0 g
.29787 .3404 m
.31489 .37691 L
s
.31489 .37691 m
.32208 .37905 L
s
.775 .921 1 r
.39708 .46574 m .41567 .50105 L .39329 .46547 L F
.39708 .46574 m .41937 .5039 L .41567 .50105 L F
.845 .978 1 r
.70185 .27945 m .68197 .29136 L .67407 .27666 L F
.885 1 1 r
.68197 .29136 m .63871 .3072 L .67407 .27666 L F
.68197 .29136 m .64692 .3264 L .63871 .3072 L F
.818 .958 1 r
.84063 .26686 m .78326 .26515 L .82858 .24852 L F
0 g
.84063 .26686 m
.84742 .27719 L
s
.83271 .26991 m
.84063 .26686 L
s
.824 .962 1 r
.77063 .24641 m .7711 .27073 L .75834 .25153 L F
.77063 .24641 m .78326 .26515 L .7711 .27073 L F
0 g
.7711 .27073 m
.7837 .29037 L
s
.816 .957 1 r
.1984 .27066 m .17652 .2773 L .16895 .26804 L F
0 g
.14768 .28586 m
.17652 .2773 L
s
.893 1 1 r
.64692 .3264 m .63086 .31398 L .63871 .3072 L F
.64692 .3264 m .63912 .33419 L .63086 .31398 L F
0 g
.64692 .3264 m
.68197 .29136 L
s
.64692 .3264 m
.66119 .35979 L
s
.961 1 1 r
.63912 .33419 m .61162 .44617 L .59669 .39993 L F
.946 1 1 r
.63912 .33419 m .58815 .37351 L .63086 .31398 L F
.63912 .33419 m .59669 .39993 L .58815 .37351 L F
0 g
.63912 .33419 m
.64692 .3264 L
s
.06057 .26556 m
.10018 .25084 L
s
.822 .961 1 r
.25045 .25318 m .23624 .29311 L .2168 .26508 L F
.25045 .25318 m .26959 .2834 L .23624 .29311 L F
.822 .96 1 r
.28336 .31093 m .23624 .29311 L .26959 .2834 L F
.818 .957 1 r
.29076 .30975 m .29474 .33371 L .28336 .31093 L F
.29076 .30975 m .30209 .33336 L .29474 .33371 L F
0 g
.29474 .33371 m
.29787 .3404 L
s
.786 .932 1 r
.4355 .46847 m .41937 .5039 L .39708 .46574 L F
.4355 .46847 m .4572 .53302 L .41937 .5039 L F
.782 .872 1 r
.46619 .54043 m .41937 .5039 L .4572 .53302 L F
.845 .978 1 r
.70185 .27945 m .67407 .27666 L .69408 .26607 L F
.84 .974 1 r
.7258 .2651 m .70185 .27945 L .69408 .26607 L F
0 g
.70185 .27945 m
.71527 .3026 L
s
.68197 .29136 m
.70185 .27945 L
s
.816 .957 1 r
.81631 .22999 m .78326 .26515 L .77063 .24641 L F
.81631 .22999 m .82858 .24852 L .78326 .26515 L F
0 g
.82858 .24852 m
.84063 .26686 L
s
.929 1 1 r
.62613 .47854 m .63437 .49692 L .63051 .50221 L F
.919 1 1 r
.62228 .48455 m .63051 .50221 L .59167 .55547 L F
.929 1 1 r
.62613 .47854 m .63051 .50221 L .62228 .48455 L F
0 g
.63051 .50221 m
.64952 .50932 L
s
.867 .994 1 r
.61824 .26607 m .63086 .31398 L .61027 .27085 L F
.61824 .26607 m .63871 .3072 L .63086 .31398 L F
.915 1 1 r
.61027 .27085 m .63086 .31398 L .58815 .37351 L F
.86 .989 1 r
.65427 .24446 m .63871 .3072 L .61824 .26607 L F
.65427 .24446 m .67407 .27666 L .63871 .3072 L F
0 g
.63871 .3072 m
.64692 .3264 L
s
.84 .973 1 r
.33247 .29499 m .30209 .33336 L .29076 .30975 L F
.33247 .29499 m .34365 .32095 L .30209 .33336 L F
.835 .969 1 r
.363 .37972 m .30209 .33336 L .34365 .32095 L F
.832 .968 1 r
.67456 .23576 m .67407 .27666 L .65427 .24446 L F
.67456 .23576 m .69408 .26607 L .67407 .27666 L F
.816 .956 1 r
.16271 .2274 m .16895 .26804 L .14044 .23588 L F
.16271 .2274 m .19094 .26066 L .16895 .26804 L F
.814 .955 1 r
.1111 .24679 m .14044 .23588 L .16895 .26804 L F
0 g
.1111 .24679 m
.13709 .27432 L
s
.816 .957 1 r
.1984 .27066 m .16895 .26804 L .19094 .26066 L F
.822 .961 1 r
.75834 .25153 m .7258 .2651 L .71822 .25329 L F
.84 .974 1 r
.7258 .2651 m .69408 .26607 L .71822 .25329 L F
0 g
.70185 .27945 m
.7258 .2651 L
s
.827 .964 1 r
.29076 .30975 m .28336 .31093 L .26959 .2834 L F
0 g
.28336 .31093 m
.29474 .33371 L
s
.2504 .3162 m
.28336 .31093 L
s
.815 .956 1 r
.58342 .54507 m .57575 .55866 L .56751 .55278 L F
.58342 .54507 m .59167 .55547 L .57575 .55866 L F
0 g
.58465 .54662 m
.59507 .53251 L
s
.949 1 1 r
.62613 .47854 m .60777 .4534 L .61162 .44617 L F
.62613 .47854 m .62228 .48455 L .60777 .4534 L F
0 g
.62613 .47854 m
.66769 .40213 L
s
.819 .958 1 r
.2168 .26508 m .1984 .27066 L .19094 .26066 L F
0 g
.17652 .2773 m
.1984 .27066 L
s
.1984 .27066 m
.21806 .29703 L
s
.78 .93 1 r
.4819 .53849 m .48167 .55319 L .46619 .54043 L F
.4819 .53849 m .49722 .55917 L .48167 .55319 L F
.919 1 1 r
.62228 .48455 m .59167 .55547 L .58342 .54507 L F
.938 1 1 r
.62228 .48455 m .56879 .52662 L .60777 .4534 L F
.62228 .48455 m .58342 .54507 L .56879 .52662 L F
0 g
.61017 .45855 m
.62228 .48455 L
s
.62228 .48455 m
.63051 .50221 L
s
.62228 .48455 m
.62613 .47854 L
s
.829 .966 1 r
.69908 .22526 m .69408 .26607 L .67456 .23576 L F
.69908 .22526 m .71822 .25329 L .69408 .26607 L F
0 g
.69408 .26607 m
.70185 .27945 L
s
.827 .964 1 r
.29076 .30975 m .26959 .2834 L .27707 .28122 L F
.844 .976 1 r
.33247 .29499 m .29076 .30975 L .27707 .28122 L F
0 g
.28336 .31093 m
.29076 .30975 L
s
.783 .874 1 r
.53981 .5662 m .49722 .55917 L .52489 .5698 L F
.829 .966 1 r
.56751 .55278 m .53981 .5662 L .52489 .5698 L F
0 g
.51242 .54705 m
.53766 .56469 L
s
.824 .962 1 r
.25799 .25051 m .26959 .2834 L .25045 .25318 L F
.25799 .25051 m .27707 .28122 L .26959 .2834 L F
0 g
.26959 .2834 m
.28336 .31093 L
s
.817 .957 1 r
.16271 .2274 m .20943 .25446 L .19094 .26066 L F
.819 .958 1 r
.2168 .26508 m .19094 .26066 L .20943 .25446 L F
0 g
.19094 .26066 m
.1984 .27066 L
s
.818 .958 1 r
.73219 .21304 m .71822 .25329 L .69908 .22526 L F
0 g
.7258 .2651 m
.74037 .25903 L
s
.818 .958 1 r
.73219 .21304 m .75094 .24041 L .71822 .25329 L F
.822 .961 1 r
.75834 .25153 m .71822 .25329 L .75094 .24041 L F
.981 1 1 r
.59669 .39993 m .61162 .44617 L .60777 .4534 L F
.821 .96 1 r
.77063 .24641 m .75834 .25153 L .75094 .24041 L F
0 g
.75834 .25153 m
.7711 .27073 L
s
.74037 .25903 m
.75834 .25153 L
s
.10018 .25084 m
.1111 .24679 L
s
.8 .944 1 r
.39708 .46574 m .39329 .46547 L .39102 .46188 L F
.981 1 1 r
.59669 .39993 m .60777 .4534 L .59281 .40695 L F
.978 1 1 r
.59669 .39993 m .58426 .38041 L .58815 .37351 L F
.59669 .39993 m .59281 .40695 L .58426 .38041 L F
0 g
.59669 .39993 m
.63912 .33419 L
s
.825 .963 1 r
.25045 .25318 m .2168 .26508 L .20943 .25446 L F
0 g
.1984 .27066 m
.2168 .26508 L
s
.915 1 1 r
.61027 .27085 m .58815 .37351 L .56685 .31158 L F
.957 1 1 r
.56685 .31158 m .58815 .37351 L .58426 .38041 L F
.832 .968 1 r
.30008 .23288 m .27707 .28122 L .25799 .25051 L F
.30008 .23288 m .319 .26367 L .27707 .28122 L F
.844 .976 1 r
.33247 .29499 m .27707 .28122 L .319 .26367 L F
.851 .98 1 r
.37116 .39093 m .39102 .46188 L .36729 .39277 L F
.37116 .39093 m .39483 .46189 L .39102 .46188 L F
.8 .944 1 r
.39708 .46574 m .39102 .46188 L .39483 .46189 L F
.982 1 1 r
.59281 .40695 m .60777 .4534 L .56879 .52662 L F
0 g
.60777 .4534 m
.61017 .45855 L
s
.982 1 1 r
.59281 .40695 m .56879 .52662 L .55364 .47798 L F
.98 1 1 r
.59281 .40695 m .545 .4502 L .58426 .38041 L F
.59281 .40695 m .55364 .47798 L .545 .4502 L F
0 g
.59281 .40695 m
.59669 .39993 L
s
.59281 .40695 m
.60777 .4534 L
s
.967 1 1 r
.56292 .31679 m .58426 .38041 L .545 .4502 L F
.957 1 1 r
.56685 .31158 m .58426 .38041 L .56292 .31679 L F
0 g
.58426 .38041 m
.59281 .40695 L
s
.815 .955 1 r
.4355 .46847 m .39708 .46574 L .39483 .46189 L F
0 g
.39329 .46547 m
.39708 .46574 L
s
.39708 .46574 m
.41937 .5039 L
s
.855 .985 1 r
.61824 .26607 m .61027 .27085 L .60819 .2665 L F
.895 1 1 r
.61027 .27085 m .56472 .30538 L .60819 .2665 L F
.61027 .27085 m .56685 .31158 L .56472 .30538 L F
.829 .966 1 r
.56751 .55278 m .52489 .5698 L .55283 .54231 L F
.846 .979 1 r
.58342 .54507 m .56751 .55278 L .55283 .54231 L F
0 g
.53981 .5662 m
.56751 .55278 L
s
.56751 .55278 m
.57575 .55866 L
s
.938 1 1 r
.56685 .31158 m .56078 .31042 L .56472 .30538 L F
.56685 .31158 m .56292 .31679 L .56078 .31042 L F
0 g
.56685 .31158 m
.61027 .27085 L
s
.865 .992 1 r
.5413 .25336 m .60819 .2665 L .56472 .30538 L F
.9 1 1 r
.53732 .25655 m .56472 .30538 L .56078 .31042 L F
.53732 .25655 m .5413 .25336 L .56472 .30538 L F
.815 .956 1 r
.81631 .22999 m .77063 .24641 L .7633 .23554 L F
.821 .96 1 r
.77063 .24641 m .75094 .24041 L .7633 .23554 L F
0 g
.75834 .25153 m
.77063 .24641 L
s
.861 .987 1 r
.37116 .39093 m .43333 .46201 L .39483 .46189 L F
.815 .955 1 r
.4355 .46847 m .39483 .46189 L .43333 .46201 L F
0 g
.39483 .46189 m
.39708 .46574 L
s
.836 .971 1 r
.59343 .22481 m .60819 .2665 L .58535 .22829 L F
.59343 .22481 m .61618 .26192 L .60819 .2665 L F
.865 .992 1 r
.5413 .25336 m .58535 .22829 L .60819 .2665 L F
.855 .985 1 r
.61824 .26607 m .60819 .2665 L .61618 .26192 L F
.848 .98 1 r
.65427 .24446 m .61824 .26607 L .61618 .26192 L F
0 g
.61824 .26607 m
.63871 .3072 L
s
.61027 .27085 m
.61824 .26607 L
s
.967 1 1 r
.56292 .31679 m .545 .4502 L .5234 .36918 L F
.948 1 1 r
.56292 .31679 m .52125 .36112 L .56078 .31042 L F
.56292 .31679 m .5234 .36918 L .52125 .36112 L F
0 g
.56292 .31679 m
.58426 .38041 L
s
.56292 .31679 m
.56685 .31158 L
s
.1111 .24679 m
.14044 .23588 L
s
.911 1 1 r
.53732 .25655 m .56078 .31042 L .52125 .36112 L F
0 g
.542 .26731 m
.56078 .31042 L
s
.56078 .31042 m
.56292 .31679 L
s
.873 .996 1 r
.36687 .3778 m .36729 .39277 L .363 .37972 L F
.36687 .3778 m .37116 .39093 L .36729 .39277 L F
.797 .942 1 r
.50968 .53508 m .49722 .55917 L .4819 .53849 L F
.50968 .53508 m .52489 .5698 L .49722 .55917 L F
.877 .999 1 r
.36687 .3778 m .363 .37972 L .34365 .32095 L F
0 g
.32208 .37905 m
.363 .37972 L
s
.863 .99 1 r
.33635 .29287 m .34365 .32095 L .33247 .29499 L F
.33635 .29287 m .34752 .3187 L .34365 .32095 L F
.877 .999 1 r
.36687 .3778 m .34365 .32095 L .34752 .3187 L F
.875 .998 1 r
.40578 .35848 m .37116 .39093 L .36687 .3778 L F
.40578 .35848 m .41007 .37235 L .37116 .39093 L F
.861 .987 1 r
.37116 .39093 m .41007 .37235 L .43333 .46201 L F
0 g
.37116 .39093 m
.39483 .46189 L
s
.879 1 1 r
.40578 .35848 m .36687 .3778 L .34752 .3187 L F
0 g
.36687 .3778 m
.37116 .39093 L
s
.363 .37972 m
.36687 .3778 L
s
.833 .969 1 r
.59343 .22481 m .65226 .2412 L .61618 .26192 L F
.848 .98 1 r
.65427 .24446 m .61618 .26192 L .65226 .2412 L F
0 g
.61824 .26607 m
.65018 .24691 L
s
.61618 .26192 m
.61824 .26607 L
s
.61459 .25932 m
.61618 .26192 L
s
.82 .959 1 r
.21547 .20683 m .20943 .25446 L .18141 .22028 L F
.21547 .20683 m .2432 .24173 L .20943 .25446 L F
.817 .957 1 r
.16271 .2274 m .18141 .22028 L .20943 .25446 L F
0 g
.17008 .23608 m
.19094 .26066 L
s
.16271 .2274 m
.17008 .23608 L
s
.825 .963 1 r
.25045 .25318 m .20943 .25446 L .2432 .24173 L F
.861 .989 1 r
.37528 .27157 m .34752 .3187 L .33635 .29287 L F
.37528 .27157 m .38648 .29611 L .34752 .3187 L F
.879 1 1 r
.40578 .35848 m .34752 .3187 L .38648 .29611 L F
0 g
.34752 .3187 m
.36687 .3778 L
s
.846 .979 1 r
.58342 .54507 m .55283 .54231 L .56879 .52662 L F
0 g
.58342 .54507 m
.62228 .48455 L
s
.56751 .55278 m
.58342 .54507 L
s
.817 .957 1 r
.7447 .20843 m .75094 .24041 L .73219 .21304 L F
.7447 .20843 m .7633 .23554 L .75094 .24041 L F
0 g
.75094 .24041 m
.75834 .25153 L
s
.859 .987 1 r
.33635 .29287 m .33247 .29499 L .319 .26367 L F
0 g
.29076 .30975 m
.33247 .29499 L
s
.826 .964 1 r
.67456 .23576 m .65427 .24446 L .65226 .2412 L F
0 g
.65018 .24691 m
.65427 .24446 L
s
.859 .987 1 r
.33635 .29287 m .319 .26367 L .32286 .2617 L F
.857 .986 1 r
.37528 .27157 m .33635 .29287 L .32286 .2617 L F
0 g
.33247 .29499 m
.33635 .29287 L
s
.33635 .29287 m
.34752 .3187 L
s
.812 .953 1 r
.4819 .53849 m .46619 .54043 L .4572 .53302 L F
0 g
.45659 .53121 m
.45886 .53339 L
s
.911 1 1 r
.53732 .25655 m .52125 .36112 L .49758 .28839 L F
0 g
.52615 .36553 m
.56292 .31679 L
s
.936 1 1 r
.48168 .30426 m .52125 .36112 L .50532 .38324 L F
.48168 .30426 m .49758 .28839 L .52125 .36112 L F
.965 1 1 r
.5234 .36918 m .50532 .38324 L .52125 .36112 L F
.827 .965 1 r
.25799 .25051 m .25045 .25318 L .2432 .24173 L F
0 g
.25045 .25318 m
.26959 .2834 L
s
.2168 .26508 m
.25045 .25318 L
s
.82 .959 1 r
.65063 .20129 m .65226 .2412 L .63006 .20904 L F
.65063 .20129 m .67258 .23269 L .65226 .2412 L F
.833 .969 1 r
.59343 .22481 m .63006 .20904 L .65226 .2412 L F
.826 .964 1 r
.67456 .23576 m .65226 .2412 L .67258 .23269 L F
.814 .955 1 r
.7911 .19198 m .7633 .23554 L .7447 .20843 L F
0 g
.77063 .24641 m
.78812 .24012 L
s
.814 .955 1 r
.7911 .19198 m .8092 .21925 L .7633 .23554 L F
.815 .956 1 r
.81631 .22999 m .7633 .23554 L .8092 .21925 L F
0 g
.78812 .24012 m
.81631 .22999 L
s
.81631 .22999 m
.82858 .24852 L
s
.869 .995 1 r
.53302 .24931 m .49758 .28839 L .49324 .27914 L F
.53302 .24931 m .53732 .25655 L .49758 .28839 L F
.894 1 1 r
.49324 .27914 m .49758 .28839 L .48168 .30426 L F
.967 1 1 r
.5234 .36918 m .52905 .4737 L .50747 .39143 L F
.5234 .36918 m .545 .4502 L .52905 .4737 L F
.965 1 1 r
.5234 .36918 m .50747 .39143 L .50532 .38324 L F
0 g
.5234 .36918 m
.52615 .36553 L
s
.903 1 1 r
.47733 .29399 m .48168 .30426 L .45381 .33207 L F
.944 1 1 r
.48168 .30426 m .47727 .42221 L .45381 .33207 L F
.48168 .30426 m .50532 .38324 L .47727 .42221 L F
.894 1 1 r
.49324 .27914 m .48168 .30426 L .47733 .29399 L F
.866 .993 1 r
.391 .26187 m .38648 .29611 L .37528 .27157 L F
.391 .26187 m .40223 .285 L .38648 .29611 L F
.901 1 1 r
.42166 .34449 m .38648 .29611 L .40223 .285 L F
.42166 .34449 m .40578 .35848 L .38648 .29611 L F
0 g
.14044 .23588 m
.16271 .2274 L
s
.838 .972 1 r
.30394 .23113 m .319 .26367 L .30008 .23288 L F
.30394 .23113 m .32286 .2617 L .319 .26367 L F
.91 1 1 r
.42166 .34449 m .41007 .37235 L .40578 .35848 L F
0 g
.36687 .3778 m
.40578 .35848 L
s
.903 1 1 r
.47733 .29399 m .45381 .33207 L .44947 .31999 L F
.905 1 1 r
.44947 .31999 m .45381 .33207 L .42598 .3577 L F
.926 1 1 r
.42598 .3577 m .45381 .33207 L .47727 .42221 L F
.832 .968 1 r
.30008 .23288 m .25799 .25051 L .25077 .23887 L F
.827 .965 1 r
.25799 .25051 m .2432 .24173 L .25077 .23887 L F
0 g
.25045 .25318 m
.25799 .25051 L
s
.91 1 1 r
.42166 .34449 m .42598 .3577 L .41007 .37235 L F
.926 1 1 r
.42598 .3577 m .43333 .46201 L .41007 .37235 L F
.42598 .3577 m .4493 .44754 L .43333 .46201 L F
.905 1 1 r
.44947 .31999 m .42598 .3577 L .42166 .34449 L F
.926 1 1 r
.42598 .3577 m .47727 .42221 L .4493 .44754 L F
.896 1 1 r
.44947 .31999 m .42166 .34449 L .40223 .285 L F
0 g
.42166 .34449 m
.42598 .3577 L
s
.40578 .35848 m
.42166 .34449 L
s
.856 .986 1 r
.53302 .24931 m .49324 .27914 L .47354 .23723 L F
.879 1 1 r
.49324 .27914 m .45763 .24754 L .47354 .23723 L F
.49324 .27914 m .47733 .29399 L .45763 .24754 L F
0 g
.49324 .27914 m
.52796 .25311 L
s
.887 1 1 r
.47733 .29399 m .42989 .26551 L .45763 .24754 L F
.47733 .29399 m .44947 .31999 L .42989 .26551 L F
0 g
.47733 .29399 m
.49324 .27914 L
s
.47733 .29399 m
.48168 .30426 L
s
.46487 .26461 m
.47733 .29399 L
s
.46819 .30252 m
.47733 .29399 L
s
.862 .99 1 r
.53701 .24632 m .53732 .25655 L .53302 .24931 L F
.53701 .24632 m .5413 .25336 L .53732 .25655 L F
0 g
.53732 .25655 m
.542 .26731 L
s
.836 .971 1 r
.34288 .21345 m .32286 .2617 L .30394 .23113 L F
.34288 .21345 m .36175 .24194 L .32286 .2617 L F
.857 .986 1 r
.37528 .27157 m .32286 .2617 L .36175 .24194 L F
0 g
.32286 .2617 m
.33635 .29287 L
s
.896 1 1 r
.44947 .31999 m .40223 .285 L .42989 .26551 L F
0 g
.42166 .34449 m
.44947 .31999 L
s
.44947 .31999 m
.46819 .30252 L
s
.861 .989 1 r
.41865 .24481 m .40223 .285 L .391 .26187 L F
.41865 .24481 m .42989 .26551 L .40223 .285 L F
0 g
.40223 .285 m
.42166 .34449 L
s
.838 .973 1 r
.58116 .22235 m .5413 .25336 L .53701 .24632 L F
.58116 .22235 m .58535 .22829 L .5413 .25336 L F
.824 .962 1 r
.69908 .22526 m .67456 .23576 L .67258 .23269 L F
0 g
.67456 .23576 m
.69408 .26607 L
s
.65427 .24446 m
.67456 .23576 L
s
.966 1 1 r
.50747 .39143 m .47727 .42221 L .50532 .38324 L F
0 g
.48168 .30426 m
.50532 .38324 L
s
.8092 .21925 m
.81631 .22999 L
s
.969 1 1 r
.50747 .39143 m .50094 .51512 L .47941 .43061 L F
.50747 .39143 m .52905 .4737 L .50094 .51512 L F
.966 1 1 r
.50747 .39143 m .47941 .43061 L .47727 .42221 L F
0 g
.47982 .43004 m
.50747 .39143 L
s
.50747 .39143 m
.5234 .36918 L
s
.50532 .38324 m
.50747 .39143 L
s
.82 .959 1 r
.21547 .20683 m .25077 .23887 L .2432 .24173 L F
0 g
.2432 .24173 m
.25045 .25318 L
s
.819 .959 1 r
.65063 .20129 m .69714 .22242 L .67258 .23269 L F
.824 .962 1 r
.69908 .22526 m .67258 .23269 L .69714 .22242 L F
0 g
.67258 .23269 m
.67456 .23576 L
s
.812 .953 1 r
.4819 .53849 m .4572 .53302 L .47304 .52654 L F
.829 .966 1 r
.50968 .53508 m .4819 .53849 L .47304 .52654 L F
0 g
.46619 .54043 m
.4819 .53849 L
s
.4819 .53849 m
.49722 .55917 L
s
.857 .986 1 r
.391 .26187 m .37528 .27157 L .36175 .24194 L F
0 g
.33635 .29287 m
.37528 .27157 L
s
.856 .986 1 r
.53302 .24931 m .47354 .23723 L .51349 .21637 L F
.849 .981 1 r
.53701 .24632 m .53302 .24931 L .51349 .21637 L F
0 g
.52796 .25311 m
.53302 .24931 L
s
.53302 .24931 m
.53732 .25655 L
s
.85 .982 1 r
.44641 .22915 m .42989 .26551 L .41865 .24481 L F
.44641 .22915 m .45763 .24754 L .42989 .26551 L F
.849 .981 1 r
.53701 .24632 m .51349 .21637 L .51751 .21427 L F
.832 .968 1 r
.58116 .22235 m .53701 .24632 L .51751 .21427 L F
0 g
.53302 .24931 m
.53701 .24632 L
s
.53701 .24632 m
.54012 .24464 L
s
.82 .959 1 r
.21547 .20683 m .2231 .20381 L .25077 .23887 L F
.821 .961 1 r
.2231 .20381 m .29291 .22122 L .25077 .23887 L F
.832 .968 1 r
.30008 .23288 m .25077 .23887 L .29291 .22122 L F
.946 1 1 r
.55364 .47798 m .52905 .4737 L .545 .4502 L F
.927 1 1 r
.55364 .47798 m .55283 .54231 L .53771 .49867 L F
.55364 .47798 m .56879 .52662 L .55283 .54231 L F
.946 1 1 r
.55364 .47798 m .53771 .49867 L .52905 .4737 L F
0 g
.55364 .47798 m
.59281 .40695 L
s
.889 1 1 r
.45146 .45471 m .4572 .53302 L .4355 .46847 L F
.45146 .45471 m .47304 .52654 L .4572 .53302 L F
.857 .986 1 r
.391 .26187 m .36175 .24194 L .37743 .23389 L F
.852 .983 1 r
.41865 .24481 m .391 .26187 L .37743 .23389 L F
0 g
.37528 .27157 m
.391 .26187 L
s
.391 .26187 m
.40223 .285 L
s
.917 1 1 r
.53771 .49867 m .55283 .54231 L .52489 .5698 L F
0 g
.55283 .54231 m
.56751 .55278 L
s
.16271 .2274 m
.18141 .22028 L
s
.816 .957 1 r
.73219 .21304 m .69908 .22526 L .69714 .22242 L F
0 g
.67456 .23576 m
.69908 .22526 L
s
.917 1 1 r
.53771 .49867 m .52489 .5698 L .50968 .53508 L F
.909 1 1 r
.45146 .45471 m .4355 .46847 L .43333 .46201 L F
0 g
.39708 .46574 m
.4355 .46847 L
s
.909 1 1 r
.45146 .45471 m .43333 .46201 L .4493 .44754 L F
.846 .978 1 r
.46236 .22016 m .45763 .24754 L .44641 .22915 L F
.46236 .22016 m .47354 .23723 L .45763 .24754 L F
0 g
.45763 .24754 m
.46487 .26461 L
s
.919 1 1 r
.47941 .43061 m .4493 .44754 L .47727 .42221 L F
.47941 .43061 m .45146 .45471 L .4493 .44754 L F
0 g
.42598 .3577 m
.4493 .44754 L
s
.899 1 1 r
.47941 .43061 m .47304 .52654 L .45146 .45471 L F
0 g
.4355 .46847 m
.45146 .45471 L
s
.4493 .44754 m
.45146 .45471 L
s
.936 1 1 r
.53771 .49867 m .50094 .51512 L .52905 .4737 L F
0 g
.50747 .39143 m
.52905 .4737 L
s
.936 1 1 r
.53771 .49867 m .50968 .53508 L .50094 .51512 L F
0 g
.53771 .49867 m
.55364 .47798 L
s
.53771 .49867 m
.55283 .54231 L
s
.52905 .4737 m
.53771 .49867 L
s
.823 .962 1 r
.58926 .21893 m .58535 .22829 L .58116 .22235 L F
.58926 .21893 m .59343 .22481 L .58535 .22829 L F
.899 1 1 r
.47941 .43061 m .50094 .51512 L .47304 .52654 L F
0 g
.47941 .43061 m
.47982 .43004 L
s
.45146 .45471 m
.47941 .43061 L
s
.815 .956 1 r
.70905 .17977 m .69714 .22242 L .67551 .19191 L F
.70905 .17977 m .73029 .21027 L .69714 .22242 L F
.819 .959 1 r
.65063 .20129 m .67551 .19191 L .69714 .22242 L F
.816 .957 1 r
.73219 .21304 m .69714 .22242 L .73029 .21027 L F
0 g
.69908 .22526 m
.70704 .22232 L
s
.833 .969 1 r
.35859 .20643 m .36175 .24194 L .34288 .21345 L F
.35859 .20643 m .37743 .23389 L .36175 .24194 L F
.829 .966 1 r
.50968 .53508 m .47304 .52654 L .50094 .51512 L F
0 g
.45146 .45471 m
.47304 .52654 L
s
.47304 .52654 m
.4819 .53849 L
s
.4819 .53849 m
.50968 .53508 L
s
.50968 .53508 m
.53771 .49867 L
s
.832 .968 1 r
.50246 .20121 m .47354 .23723 L .46236 .22016 L F
.50246 .20121 m .51349 .21637 L .47354 .23723 L F
.842 .975 1 r
.44641 .22915 m .41865 .24481 L .40503 .21973 L F
.852 .983 1 r
.41865 .24481 m .37743 .23389 L .40503 .21973 L F
0 g
.391 .26187 m
.41865 .24481 L
s
.822 .961 1 r
.62596 .20345 m .59343 .22481 L .58926 .21893 L F
.62596 .20345 m .63006 .20904 L .59343 .22481 L F
0 g
.59343 .22481 m
.61459 .25932 L
s
.834 .969 1 r
.30394 .23113 m .30008 .23288 L .29291 .22122 L F
0 g
.25799 .25051 m
.30008 .23288 L
s
.18141 .22028 m
.21547 .20683 L
s
.82 .96 1 r
.58926 .21893 m .58116 .22235 L .56204 .19526 L F
.832 .968 1 r
.58116 .22235 m .51751 .21427 L .56204 .19526 L F
0 g
.54012 .24464 m
.58116 .22235 L
s
.51572 .22013 m
.53302 .24931 L
s
.83 .967 1 r
.38627 .19407 m .37743 .23389 L .35859 .20643 L F
.38627 .19407 m .40503 .21973 L .37743 .23389 L F
0 g
.37743 .23389 m
.391 .26187 L
s
.37617 .23205 m
.37743 .23389 L
s
.834 .969 1 r
.30394 .23113 m .29291 .22122 L .29677 .21954 L F
.832 .968 1 r
.34288 .21345 m .30394 .23113 L .29677 .21954 L F
0 g
.30008 .23288 m
.30394 .23113 L
s
.30394 .23113 m
.32286 .2617 L
s
.82 .96 1 r
.58926 .21893 m .56204 .19526 L .57021 .19213 L F
.819 .959 1 r
.62596 .20345 m .58926 .21893 L .57021 .19213 L F
0 g
.58926 .21893 m
.59343 .22481 L
s
.58116 .22235 m
.58926 .21893 L
s
.58904 .21863 m
.58926 .21893 L
s
.58926 .21893 m
.58968 .21875 L
s
.816 .956 1 r
.7447 .20843 m .73219 .21304 L .73029 .21027 L F
0 g
.73219 .21304 m
.75094 .24041 L
s
.70704 .22232 m
.73219 .21304 L
s
.842 .975 1 r
.44641 .22915 m .40503 .21973 L .4328 .20684 L F
.837 .972 1 r
.46236 .22016 m .44641 .22915 L .4328 .20684 L F
0 g
.44641 .22915 m
.45763 .24754 L
s
.41865 .24481 m
.44641 .22915 L
s
.821 .961 1 r
.26939 .18515 m .29291 .22122 L .2655 .18671 L F
.26939 .18515 m .29677 .21954 L .29291 .22122 L F
.2231 .20381 m .2655 .18671 L .29291 .22122 L F
0 g
.21742 .20927 m
.2432 .24173 L
s
.21547 .20683 m
.21742 .20927 L
s
.82 .96 1 r
.26939 .18515 m .33572 .20264 L .29677 .21954 L F
.832 .968 1 r
.34288 .21345 m .29677 .21954 L .33572 .20264 L F
0 g
.29677 .21954 m
.30394 .23113 L
s
.29545 .21787 m
.29677 .21954 L
s
.814 .955 1 r
.70905 .17977 m .74281 .20567 L .73029 .21027 L F
.816 .956 1 r
.7447 .20843 m .73029 .21027 L .74281 .20567 L F
0 g
.73029 .21027 m
.73219 .21304 L
s
.829 .966 1 r
.50649 .1993 m .51349 .21637 L .50246 .20121 L F
.50649 .1993 m .51751 .21427 L .51349 .21637 L F
0 g
.51349 .21637 m
.51572 .22013 L
s
.824 .963 1 r
.41418 .18239 m .40503 .21973 L .38627 .19407 L F
.41418 .18239 m .4328 .20684 L .40503 .21973 L F
.826 .964 1 r
.50246 .20121 m .46236 .22016 L .44877 .19943 L F
.837 .972 1 r
.46236 .22016 m .4328 .20684 L .44877 .19943 L F
0 g
.44641 .22915 m
.46236 .22016 L
s
.814 .955 1 r
.7911 .19198 m .7447 .20843 L .74281 .20567 L F
0 g
.73219 .21304 m
.7447 .20843 L
s
.82 .96 1 r
.55124 .18103 m .51751 .21427 L .50649 .1993 L F
.55124 .18103 m .56204 .19526 L .51751 .21427 L F
.816 .956 1 r
.64658 .19571 m .63006 .20904 L .62596 .20345 L F
.64658 .19571 m .65063 .20129 L .63006 .20904 L F
.814 .955 1 r
.72173 .17518 m .78926 .18922 L .74281 .20567 L F
.70905 .17977 m .72173 .17518 L .74281 .20567 L F
.7911 .19198 m .74281 .20567 L .78926 .18922 L F
0 g
.78416 .19444 m
.7911 .19198 L
s
.7447 .20843 m
.78416 .19444 L
s
.7911 .19198 m
.8092 .21925 L
s
.828 .965 1 r
.35859 .20643 m .34288 .21345 L .33572 .20264 L F
0 g
.30394 .23113 m
.34288 .21345 L
s
.21547 .20683 m
.2231 .20381 L
s
.815 .956 1 r
.64658 .19571 m .62596 .20345 L .60727 .17793 L F
.819 .959 1 r
.62596 .20345 m .57021 .19213 L .60727 .17793 L F
0 g
.58968 .21875 m
.62596 .20345 L
s
.2231 .20381 m
.2655 .18671 L
s
.815 .956 1 r
.67151 .18635 m .65063 .20129 L .64658 .19571 L F
.67151 .18635 m .67551 .19191 L .65063 .20129 L F
0 g
.65063 .20129 m
.67258 .23269 L
s
.822 .961 1 r
.43024 .17566 m .4328 .20684 L .41418 .18239 L F
.43024 .17566 m .44877 .19943 L .4328 .20684 L F
0 g
.4328 .20684 m
.44641 .22915 L
s
.828 .965 1 r
.35859 .20643 m .33572 .20264 L .35144 .19601 L F
.826 .964 1 r
.38627 .19407 m .35859 .20643 L .35144 .19601 L F
0 g
.34288 .21345 m
.35859 .20643 L
s
.35859 .20643 m
.37617 .23205 L
s
.818 .958 1 r
.3244 .16309 m .33572 .20264 L .30858 .16937 L F
.3244 .16309 m .35144 .19601 L .33572 .20264 L F
.82 .96 1 r
.26939 .18515 m .30858 .16937 L .33572 .20264 L F
0 g
.26939 .18515 m
.26993 .18582 L
s
.26993 .18582 m
.29545 .21787 L
s
.826 .964 1 r
.50246 .20121 m .44877 .19943 L .48903 .18276 L F
.824 .962 1 r
.50649 .1993 m .50246 .20121 L .48903 .18276 L F
0 g
.46236 .22016 m
.50246 .20121 L
s
.50246 .20121 m
.51349 .21637 L
s
.824 .962 1 r
.50649 .1993 m .48903 .18276 L .49309 .18108 L F
.818 .958 1 r
.55124 .18103 m .50649 .1993 L .49309 .18108 L F
0 g
.50246 .20121 m
.50649 .1993 L
s
.818 .958 1 r
.47078 .15964 m .44877 .19943 L .43024 .17566 L F
.47078 .15964 m .48903 .18276 L .44877 .19943 L F
.815 .956 1 r
.64658 .19571 m .60727 .17793 L .62808 .17025 L F
.67151 .18635 m .64658 .19571 L .62808 .17025 L F
0 g
.62596 .20345 m
.64658 .19571 L
s
.64658 .19571 m
.65063 .20129 L
s
.816 .956 1 r
.55945 .17791 m .56204 .19526 L .55124 .18103 L F
.55945 .17791 m .57021 .19213 L .56204 .19526 L F
.814 .955 1 r
.70512 .17416 m .67551 .19191 L .67151 .18635 L F
.70512 .17416 m .70905 .17977 L .67551 .19191 L F
.818 .958 1 r
.3244 .16309 m .37914 .18432 L .35144 .19601 L F
.826 .964 1 r
.38627 .19407 m .35144 .19601 L .37914 .18432 L F
0 g
.35144 .19601 m
.35859 .20643 L
s
.815 .956 1 r
.5967 .16377 m .57021 .19213 L .55945 .17791 L F
.5967 .16377 m .60727 .17793 L .57021 .19213 L F
0 g
.57021 .19213 m
.58904 .21863 L
s
.821 .96 1 r
.41418 .18239 m .38627 .19407 L .37914 .18432 L F
0 g
.35859 .20643 m
.38627 .19407 L
s
.814 .955 1 r
.72173 .17518 m .76871 .15832 L .78926 .18922 L F
0 g
.78926 .18922 m
.7911 .19198 L
s
.814 .955 1 r
.70512 .17416 m .67151 .18635 L .65325 .16095 L F
.815 .956 1 r
.67151 .18635 m .62808 .17025 L .65325 .16095 L F
0 g
.64658 .19571 m
.67151 .18635 L
s
.67151 .18635 m
.70218 .17523 L
s
.2655 .18671 m
.26939 .18515 L
s
.26939 .18515 m
.30858 .16937 L
s
.816 .956 1 r
.38053 .14096 m .37914 .18432 L .35233 .15201 L F
.38053 .14096 m .40709 .17309 L .37914 .18432 L F
.818 .958 1 r
.3244 .16309 m .35233 .15201 L .37914 .18432 L F
0 g
.3292 .16893 m
.35144 .19601 L
s
.3244 .16309 m
.3292 .16893 L
s
.821 .96 1 r
.41418 .18239 m .37914 .18432 L .40709 .17309 L F
.817 .957 1 r
.47487 .15803 m .48903 .18276 L .47078 .15964 L F
.47487 .15803 m .49309 .18108 L .48903 .18276 L F
0 g
.48903 .18276 m
.50246 .20121 L
s
.815 .956 1 r
.55945 .17791 m .55124 .18103 L .53808 .16371 L F
.818 .958 1 r
.55124 .18103 m .49309 .18108 L .53808 .16371 L F
0 g
.50649 .1993 m
.55124 .18103 L
s
.815 .956 1 r
.52021 .14065 m .49309 .18108 L .47487 .15803 L F
.52021 .14065 m .53808 .16371 L .49309 .18108 L F
.814 .955 1 r
.71782 .16956 m .70905 .17977 L .70512 .17416 L F
.71782 .16956 m .72173 .17518 L .70905 .17977 L F
0 g
.70905 .17977 m
.73029 .21027 L
s
.819 .959 1 r
.43024 .17566 m .41418 .18239 L .40709 .17309 L F
0 g
.41418 .18239 m
.4328 .20684 L
s
.38627 .19407 m
.41418 .18239 L
s
.814 .955 1 r
.61761 .15601 m .60727 .17793 L .5967 .16377 L F
.61761 .15601 m .62808 .17025 L .60727 .17793 L F
.815 .956 1 r
.55945 .17791 m .53808 .16371 L .54634 .1606 L F
.5967 .16377 m .55945 .17791 L .54634 .1606 L F
0 g
.55945 .17791 m
.57021 .19213 L
s
.55124 .18103 m
.55945 .17791 L
s
.813 .955 1 r
.76491 .1526 m .72173 .17518 L .71782 .16956 L F
.76491 .1526 m .76871 .15832 L .72173 .17518 L F
0 g
.76871 .15832 m
.78926 .18922 L
s
.814 .955 1 r
.70512 .17416 m .65325 .16095 L .68717 .14854 L F
.71782 .16956 m .70512 .17416 L .68717 .14854 L F
0 g
.70218 .17523 m
.70512 .17416 L
s
.70512 .17416 m
.70905 .17977 L
s
.816 .957 1 r
.47078 .15964 m .43024 .17566 L .42319 .16662 L F
.819 .959 1 r
.43024 .17566 m .40709 .17309 L .42319 .16662 L F
0 g
.41418 .18239 m
.43024 .17566 L
s
.815 .956 1 r
.38053 .14096 m .42319 .16662 L .40709 .17309 L F
0 g
.40709 .17309 m
.41418 .18239 L
s
.814 .955 1 r
.64291 .14662 m .62808 .17025 L .61761 .15601 L F
.64291 .14662 m .65325 .16095 L .62808 .17025 L F
0 g
.62808 .17025 m
.64658 .19571 L
s
.814 .955 1 r
.71782 .16956 m .68717 .14854 L .7 .14384 L F
.813 .955 1 r
.76491 .1526 m .71782 .16956 L .7 .14384 L F
0 g
.70512 .17416 m
.71782 .16956 L
s
.71782 .16956 m
.73805 .16227 L
s
.30858 .16937 m
.3244 .16309 L
s
.814 .955 1 r
.43784 .11862 m .42319 .16662 L .39678 .13459 L F
.43784 .11862 m .46383 .15084 L .42319 .16662 L F
.815 .956 1 r
.38053 .14096 m .39678 .13459 L .42319 .16662 L F
0 g
.38053 .14096 m
.40709 .17309 L
s
.816 .957 1 r
.47078 .15964 m .42319 .16662 L .46383 .15084 L F
0 g
.43024 .17566 m
.45933 .16417 L
s
.814 .955 1 r
.61761 .15601 m .5967 .16377 L .58382 .14652 L F
.815 .956 1 r
.5967 .16377 m .54634 .1606 L .58382 .14652 L F
0 g
.55945 .17791 m
.5967 .16377 L
s
.814 .955 1 r
.52853 .13749 m .53808 .16371 L .52021 .14065 L F
.52853 .13749 m .54634 .1606 L .53808 .16371 L F
0 g
.3244 .16309 m
.35233 .15201 L
s
.813 .955 1 r
.67701 .13404 m .65325 .16095 L .64291 .14662 L F
.67701 .13404 m .68717 .14854 L .65325 .16095 L F
.814 .955 1 r
.56631 .12317 m .54634 .1606 L .52853 .13749 L F
.56631 .12317 m .58382 .14652 L .54634 .1606 L F
0 g
.54634 .1606 m
.55945 .17791 L
s
.815 .956 1 r
.47487 .15803 m .47078 .15964 L .46383 .15084 L F
0 g
.47078 .15964 m
.48903 .18276 L
s
.45933 .16417 m
.47078 .15964 L
s
.815 .956 1 r
.47487 .15803 m .46383 .15084 L .46793 .14925 L F
.814 .955 1 r
.52021 .14065 m .47487 .15803 L .46793 .14925 L F
0 g
.47078 .15964 m
.47487 .15803 L
s
.814 .955 1 r
.61761 .15601 m .58382 .14652 L .60486 .13867 L F
.64291 .14662 m .61761 .15601 L .60486 .13867 L F
0 g
.61761 .15601 m
.62808 .17025 L
s
.5967 .16377 m
.61761 .15601 L
s
.813 .955 1 r
.76491 .1526 m .7 .14384 L .74753 .12647 L F
0 g
.76491 .1526 m
.76871 .15832 L
s
.73805 .16227 m
.76491 .1526 L
s
.35233 .15201 m
.38053 .14096 L
s
.814 .955 1 r
.43784 .11862 m .46793 .14925 L .46383 .15084 L F
0 g
.46383 .15084 m
.47078 .15964 L
s
.814 .955 1 r
.44198 .11701 m .5134 .13187 L .46793 .14925 L F
.43784 .11862 m .44198 .11701 L .46793 .14925 L F
0 g
.43784 .11862 m
.44175 .12347 L
s
.814 .955 1 r
.52021 .14065 m .46793 .14925 L .5134 .13187 L F
.813 .955 1 r
.6899 .12928 m .68717 .14854 L .67701 .13404 L F
.6899 .12928 m .7 .14384 L .68717 .14854 L F
0 g
.68717 .14854 m
.70512 .17416 L
s
.813 .955 1 r
.67701 .13404 m .64291 .14662 L .63031 .12916 L F
.814 .955 1 r
.64291 .14662 m .60486 .13867 L .63031 .12916 L F
0 g
.61761 .15601 m
.64291 .14662 L
s
.813 .955 1 r
.58752 .11515 m .58382 .14652 L .56631 .12317 L F
.58752 .11515 m .60486 .13867 L .58382 .14652 L F
.73768 .11167 m .7 .14384 L .6899 .12928 L F
.73768 .11167 m .74753 .12647 L .7 .14384 L F
0 g
.74753 .12647 m
.76491 .1526 L
s
.38053 .14096 m
.39678 .13459 L
s
.814 .955 1 r
.52853 .13749 m .52021 .14065 L .5134 .13187 L F
0 g
.47487 .15803 m
.52021 .14065 L
s
.813 .955 1 r
.61318 .10544 m .60486 .13867 L .58752 .11515 L F
.61318 .10544 m .63031 .12916 L .60486 .13867 L F
0 g
.60486 .13867 m
.61761 .15601 L
s
.814 .955 1 r
.52853 .13749 m .5134 .13187 L .52175 .12869 L F
.56631 .12317 m .52853 .13749 L .52175 .12869 L F
0 g
.52021 .14065 m
.52853 .13749 L
s
.52853 .13749 m
.54634 .1606 L
s
.39678 .13459 m
.43784 .11862 L
s
.813 .955 1 r
.67701 .13404 m .63031 .12916 L .66462 .11638 L F
.6899 .12928 m .67701 .13404 L .66462 .11638 L F
0 g
.67701 .13404 m
.68717 .14854 L
s
.64291 .14662 m
.67701 .13404 L
s
.813 .955 1 r
.49638 .0959 m .5134 .13187 L .48794 .09917 L F
.49638 .0959 m .52175 .12869 L .5134 .13187 L F
.814 .955 1 r
.44198 .11701 m .48794 .09917 L .5134 .13187 L F
0 g
.44175 .12347 m
.46383 .15084 L
s
.813 .955 1 r
.6899 .12928 m .66462 .11638 L .6776 .11154 L F
.73768 .11167 m .6899 .12928 L .6776 .11154 L F
0 g
.67701 .13404 m
.6899 .12928 L
s
.6899 .12928 m
.70587 .1234 L
s
.813 .955 1 r
.64778 .09236 m .63031 .12916 L .61318 .10544 L F
.64778 .09236 m .66462 .11638 L .63031 .12916 L F
.49638 .0959 m .55964 .11428 L .52175 .12869 L F
.814 .955 1 r
.56631 .12317 m .52175 .12869 L .55964 .11428 L F
0 g
.52175 .12869 m
.52853 .13749 L
s
.5109 .11467 m
.52175 .12869 L
s
.813 .955 1 r
.58752 .11515 m .56631 .12317 L .55964 .11428 L F
0 g
.52853 .13749 m
.56631 .12317 L
s
.43784 .11862 m
.44198 .11701 L
s
.44198 .11701 m
.48794 .09917 L
s
.813 .955 1 r
.66086 .08742 m .66462 .11638 L .64778 .09236 L F
.66086 .08742 m .6776 .11154 L .66462 .11638 L F
0 g
.66462 .11638 m
.67701 .13404 L
s
.813 .955 1 r
.58752 .11515 m .55964 .11428 L .58091 .10619 L F
.61318 .10544 m .58752 .11515 L .58091 .10619 L F
0 g
.56631 .12317 m
.58752 .11515 L
s
.58752 .11515 m
.60486 .13867 L
s
.813 .955 1 r
.55621 .0727 m .55964 .11428 L .53469 .08104 L F
.55621 .0727 m .58091 .10619 L .55964 .11428 L F
.49638 .0959 m .53469 .08104 L .55964 .11428 L F
0 g
.49638 .0959 m
.5109 .11467 L
s
.813 .955 1 r
.73768 .11167 m .6776 .11154 L .72568 .09363 L F
0 g
.73768 .11167 m
.74753 .12647 L
s
.70587 .1234 m
.73768 .11167 L
s
.813 .955 1 r
.70936 .06908 m .6776 .11154 L .66086 .08742 L F
.70936 .06908 m .72568 .09363 L .6776 .11154 L F
0 g
.72568 .09363 m
.73768 .11167 L
s
.813 .955 1 r
.55621 .0727 m .60666 .0964 L .58091 .10619 L F
.61318 .10544 m .58091 .10619 L .60666 .0964 L F
0 g
.58091 .10619 m
.58752 .11515 L
s
.813 .955 1 r
.64778 .09236 m .61318 .10544 L .60666 .0964 L F
0 g
.58752 .11515 m
.61318 .10544 L
s
.48794 .09917 m
.49638 .0959 L
s
.813 .955 1 r
.61735 .04899 m .60666 .0964 L .58225 .0626 L F
.61735 .04899 m .64136 .08321 L .60666 .0964 L F
.55621 .0727 m .58225 .0626 L .60666 .0964 L F
0 g
.5727 .09505 m
.58091 .10619 L
s
.55621 .0727 m
.5727 .09505 L
s
.813 .955 1 r
.64778 .09236 m .60666 .0964 L .64136 .08321 L F
0 g
.61318 .10544 m
.64762 .09242 L
s
.49638 .0959 m
.53469 .08104 L
s
.813 .955 1 r
.66086 .08742 m .64778 .09236 L .64136 .08321 L F
0 g
.64778 .09236 m
.66462 .11638 L
s
.64762 .09242 m
.64778 .09236 L
s
.813 .955 1 r
.70936 .06908 m .66086 .08742 L .65448 .07822 L F
.66086 .08742 m .64136 .08321 L .65448 .07822 L F
0 g
.64778 .09236 m
.66086 .08742 L
s
.813 .955 1 r
.61735 .04899 m .65448 .07822 L .64136 .08321 L F
0 g
.64136 .08321 m
.64778 .09236 L
s
.53469 .08104 m
.55621 .0727 L
s
.813 .955 1 r
.61735 .04899 m .63063 .04384 L .65448 .07822 L F
.63063 .04384 m .70314 .05973 L .65448 .07822 L F
0 g
.61735 .04899 m
.61762 .04937 L
s
.813 .955 1 r
.70936 .06908 m .65448 .07822 L .70314 .05973 L F
0 g
.70882 .06929 m
.70936 .06908 L
s
.66086 .08742 m
.70882 .06929 L
s
.70936 .06908 m
.72568 .09363 L
s
.55621 .0727 m
.58225 .0626 L
s
.58225 .0626 m
.61735 .04899 L
s
.813 .955 1 r
.63063 .04384 m .67986 .02474 L .70314 .05973 L F
0 g
.67986 .02474 m
.70314 .05973 L
s
.70314 .05973 m
.70936 .06908 L
s
.61762 .04937 m
.64136 .08321 L
s
.61735 .04899 m
.63063 .04384 L
s
.63063 .04384 m
.67986 .02474 L
s
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.03716 .25514 m
.68874 0 L
s
.14467 .21304 m
.1493 .21769 L
s
[(-2)] .13542 .20373 .99461 1 Mshowa
.34306 .13535 m
.34735 .14032 L
s
[(0)] .3345 .12542 .86223 1 Mshowa
.55745 .05141 m
.56132 .05671 L
s
[(2)] .54972 .04081 .72986 1 Mshowa
.125 Mabswid
.19287 .19417 m
.1956 .197 L
s
.24198 .17493 m
.24466 .17782 L
s
.29204 .15533 m
.29467 .15827 L
s
.39509 .11498 m
.3976 .11801 L
s
.44814 .09421 m
.45059 .09729 L
s
.50225 .07302 m
.50464 .07615 L
s
.09737 .23156 m
.10019 .23431 L
s
.05093 .24975 m
.05379 .25245 L
s
.61378 .02935 m
.61603 .03258 L
s
.67126 .00684 m
.67344 .01012 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[4]:=",
  ImageSize->{299.938, 283.875},
  ImageCacheValid->False,
  CellTags->"S6.6.1"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[4]=",
  CellTags->"S6.6.1"]
}, Open  ]],

Cell[TextData[{
  "Here is the probability of the distribution in the region ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["x",
              "TI"], "1"], "<", \(-1\), "\[Intersection]", 
          SubscriptBox[
            StyleBox["x",
              "TI"], "2"], "<", "1"}], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  ". "
}], "MathCaption",
  CellTags->{"S6.6.1", "1.16"}],

Cell[CellGroupData[{

Cell["CDF[ndist, {-1, 1}]", "Input",
  CellLabel->"In[5]:=",
  CellTags->"S6.6.1"],

Cell[BoxData[
    \(0.15654424797762276`\)], "Output",
  CellLabel->"Out[5]=",
  CellTags->"S6.6.1"]
}, Open  ]],

Cell[TextData[{
  "This gives the domain of the quadratic form distribution ",
  StyleBox["qdist", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S6.6.1", "1.17"}],

Cell[CellGroupData[{

Cell["\<\
(qdist = QuadraticFormDistribution[{{{8, -4}, {-4, 3}},
         {-2, 1}, 6}, {{-1, 1}, {{1, 1}, {1, 2}}}];
Domain[qdist])\
\>", "Input",
  CellLabel->"In[6]:=",
  CellTags->"S6.6.1"],

Cell[BoxData[
    \(Interval[{47\/8, \[Infinity]}]\)], "Output",
  CellLabel->"Out[6]=",
  CellTags->"S6.6.1"]
}, Open  ]],

Cell[TextData[{
  "The series expansion of the ",
  StyleBox["PDF", "MR"],
  " of the quadratic form distribution can be plotted. A 20\[Hyphen]term \
expansion is clearly poor for ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            "TI"], ">", "45"}], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  ". "
}], "MathCaption",
  CellTags->{"S6.6.1", "1.18"}],

Cell[CellGroupData[{

Cell["\<\
(polynomial = Normal[Series[PDF[qdist, x],
         {x, 47/8, 20}]];
Plot[polynomial, {x, 47/8, 50}])\
\>", "Input",
  CellLabel->"In[7]:=",
  CellTags->"S6.6.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0190476 -0.40245 42.4879 [
[.21429 .00993 -6 -9 ]
[.21429 .00993 6 0 ]
[.40476 .00993 -6 -9 ]
[.40476 .00993 6 0 ]
[.59524 .00993 -6 -9 ]
[.59524 .00993 6 0 ]
[.78571 .00993 -6 -9 ]
[.78571 .00993 6 0 ]
[.97619 .00993 -6 -9 ]
[.97619 .00993 6 0 ]
[.01131 .1074 -30 -4.5 ]
[.01131 .1074 0 4.5 ]
[.01131 .19238 -30 -4.5 ]
[.01131 .19238 0 4.5 ]
[.01131 .27736 -30 -4.5 ]
[.01131 .27736 0 4.5 ]
[.01131 .36233 -30 -4.5 ]
[.01131 .36233 0 4.5 ]
[.01131 .44731 -24 -4.5 ]
[.01131 .44731 0 4.5 ]
[.01131 .53228 -30 -4.5 ]
[.01131 .53228 0 4.5 ]
[.01131 .61726 -30 -4.5 ]
[.01131 .61726 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .02243 m
.21429 .02868 L
s
[(10)] .21429 .00993 0 1 Mshowa
.40476 .02243 m
.40476 .02868 L
s
[(20)] .40476 .00993 0 1 Mshowa
.59524 .02243 m
.59524 .02868 L
s
[(30)] .59524 .00993 0 1 Mshowa
.78571 .02243 m
.78571 .02868 L
s
[(40)] .78571 .00993 0 1 Mshowa
.97619 .02243 m
.97619 .02868 L
s
[(50)] .97619 .00993 0 1 Mshowa
.125 Mabswid
.0619 .02243 m
.0619 .02618 L
s
.1 .02243 m
.1 .02618 L
s
.1381 .02243 m
.1381 .02618 L
s
.17619 .02243 m
.17619 .02618 L
s
.25238 .02243 m
.25238 .02618 L
s
.29048 .02243 m
.29048 .02618 L
s
.32857 .02243 m
.32857 .02618 L
s
.36667 .02243 m
.36667 .02618 L
s
.44286 .02243 m
.44286 .02618 L
s
.48095 .02243 m
.48095 .02618 L
s
.51905 .02243 m
.51905 .02618 L
s
.55714 .02243 m
.55714 .02618 L
s
.63333 .02243 m
.63333 .02618 L
s
.67143 .02243 m
.67143 .02618 L
s
.70952 .02243 m
.70952 .02618 L
s
.74762 .02243 m
.74762 .02618 L
s
.82381 .02243 m
.82381 .02618 L
s
.8619 .02243 m
.8619 .02618 L
s
.9 .02243 m
.9 .02618 L
s
.9381 .02243 m
.9381 .02618 L
s
.25 Mabswid
0 .02243 m
1 .02243 L
s
.02381 .1074 m
.03006 .1074 L
s
[(0.012)] .01131 .1074 1 0 Mshowa
.02381 .19238 m
.03006 .19238 L
s
[(0.014)] .01131 .19238 1 0 Mshowa
.02381 .27736 m
.03006 .27736 L
s
[(0.016)] .01131 .27736 1 0 Mshowa
.02381 .36233 m
.03006 .36233 L
s
[(0.018)] .01131 .36233 1 0 Mshowa
.02381 .44731 m
.03006 .44731 L
s
[(0.02)] .01131 .44731 1 0 Mshowa
.02381 .53228 m
.03006 .53228 L
s
[(0.022)] .01131 .53228 1 0 Mshowa
.02381 .61726 m
.03006 .61726 L
s
[(0.024)] .01131 .61726 1 0 Mshowa
.125 Mabswid
.02381 .04367 m
.02756 .04367 L
s
.02381 .06492 m
.02756 .06492 L
s
.02381 .08616 m
.02756 .08616 L
s
.02381 .12865 m
.02756 .12865 L
s
.02381 .14989 m
.02756 .14989 L
s
.02381 .17114 m
.02756 .17114 L
s
.02381 .21362 m
.02756 .21362 L
s
.02381 .23487 m
.02756 .23487 L
s
.02381 .25611 m
.02756 .25611 L
s
.02381 .2986 m
.02756 .2986 L
s
.02381 .31984 m
.02756 .31984 L
s
.02381 .34109 m
.02756 .34109 L
s
.02381 .38358 m
.02756 .38358 L
s
.02381 .40482 m
.02756 .40482 L
s
.02381 .42606 m
.02756 .42606 L
s
.02381 .46855 m
.02756 .46855 L
s
.02381 .4898 m
.02756 .4898 L
s
.02381 .51104 m
.02756 .51104 L
s
.02381 .55353 m
.02756 .55353 L
s
.02381 .57477 m
.02756 .57477 L
s
.02381 .59602 m
.02756 .59602 L
s
.02381 .00119 m
.02756 .00119 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.13571 .01472 m
.13675 .01934 L
.13778 .02394 L
.13984 .03308 L
.14396 .05112 L
.15221 .08626 L
.1701 .15804 L
.1868 .21966 L
.20317 .27507 L
.22093 .32966 L
.2375 .37554 L
.25547 .41989 L
.2731 .45817 L
.28955 .48934 L
.30739 .51839 L
.32404 .54125 L
.34036 .55986 L
.35808 .57601 L
.3746 .58749 L
.38356 .59233 L
.38804 .59441 L
.39252 .59626 L
.40131 .59923 L
.40571 .60041 L
.41011 .60138 L
.41421 .6021 L
.41626 .6024 L
.41831 .60266 L
.42036 .60287 L
.42138 .60296 L
.42241 .60304 L
.42343 .60311 L
.42446 .60317 L
.42548 .60322 L
.42651 .60326 L
.42762 .60329 L
.42873 .60331 L
.42984 .60332 L
.43095 .60331 L
.43207 .6033 L
.43318 .60327 L
.43429 .60323 L
.4354 .60318 L
.43651 .60312 L
.43763 .60304 L
.43985 .60286 L
.44207 .60264 L
.4443 .60236 L
.44637 .60207 L
.44845 .60174 L
Mistroke
.4526 .60097 L
.45675 .60004 L
.4609 .59898 L
.4699 .59618 L
.47889 .59275 L
.49656 .58426 L
.51304 .57442 L
.5309 .56185 L
.54758 .54851 L
.56394 .53408 L
.58168 .51707 L
.59824 .5001 L
.61618 .48064 L
.6338 .46062 L
.65023 .44126 L
.66805 .41965 L
.68468 .399 L
.70099 .37842 L
.71868 .35582 L
.73519 .33459 L
.75309 .31154 L
.7698 .2901 L
.78618 .26929 L
.80395 .24718 L
.82054 .2272 L
.83851 .20668 L
.85616 .18828 L
.87262 .17344 L
.88154 .16672 L
.88601 .16379 L
.89047 .16119 L
.89463 .1591 L
.89672 .15818 L
.8988 .15736 L
.90088 .15663 L
.90297 .15601 L
.90505 .15549 L
.90713 .15509 L
.90815 .15494 L
.90917 .15481 L
.91019 .15472 L
.91122 .15465 L
.91224 .15462 L
.91326 .15461 L
.91428 .15464 L
.9153 .15471 L
.91632 .15481 L
.91734 .15494 L
.91836 .15511 L
.91938 .15532 L
Mistroke
.92143 .15584 L
.92347 .15653 L
.92568 .15746 L
.9279 .15859 L
.93011 .15994 L
.93233 .16152 L
.93676 .1654 L
.94119 .17033 L
.94533 .17599 L
.94946 .18276 L
.95359 .19075 L
.95773 .20008 L
.96669 .22554 L
.97565 .25945 L
.97619 .26178 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[7]:=",
  ImageSize->{350, 216.25},
  ImageCacheValid->False,
  CellTags->"S6.6.1"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[7]=",
  CellTags->"S6.6.1"]
}, Open  ]],

Cell[TextData[{
  StyleBox["CDF[MultinormalDistribution[", "MR"],
  StyleBox["mu", "TI"],
  StyleBox[",", "MR"],
  StyleBox["sigma", "TI"],
  StyleBox["],", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  " and",
  StyleBox[" CDF[MultivariateTDistribution[", "MR"],
  StyleBox["r", "TI"],
  StyleBox[", ", "MR"],
  StyleBox["m", "TI"],
  StyleBox["], ", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  " are computed as multidimensional numeric integrals with the same default \
options as NIntegrate.  If fewer digits of precision are required, quicker \
results can be obtained by setting a lower value for PrecisionGoal. For large \
values of ",
  StyleBox["m",
    FontSlant->"Italic"],
  ", a change of variable is performed by CDF to provide accurate results. \
The change of variable is made for ",
  StyleBox["m ",
    FontSlant->"Italic"],
  "> 400 if the correlation matrix R is diagonal and for ",
  StyleBox["m ",
    FontSlant->"Italic"],
  "> 550 if R is not diagonal.  For values of ",
  StyleBox["m",
    FontSlant->"Italic"],
  " above these threshholds, computations will generally be slower. Also, \
sharp features near the edges of the integration region may pose additional \
problems for convergence as precision and accuracy goals are increased. \
Increasing the value of ",
  StyleBox["SingularityDepth", "MR"],
  " or ",
  StyleBox["MaxRecursion", "MR"],
  " will often overcome these problems."
}], "Text"],

Cell["The following CDF may take several seconds to integrate.", "MathCaption",
  CellTags->{"S6.6.1", "1.18"}],

Cell[CellGroupData[{

Cell["\<\
Timing[CDF[MultinormalDistribution[{0, 1, 2, 3}, 
    {{2, 0.2, 0.8, 0.4},
     {0.2, 1.5, -0.3, 0.1},
     {0.8, -0.3, 3, -1}, 
     {0.4, 0.1, -1, 2.5}}],
  {-1.2, 1, 5, 4}]]\
\>", "Input",
  CellLabel->"In[8]:="],

Cell[BoxData[
    \({83.453`\ Second, 0.09028648680959558`}\)], "Output",
  CellLabel->"Out[8]="]
}, Open  ]],

Cell[TextData[{
  "If only 3 digits of precision are required, good results can be obtained \
in a fraction of a second by use of the ",
  StyleBox["PrecisionGoal", "MR"],
  " option."
}], "MathCaption",
  CellTags->{"S6.6.1", "1.18"}],

Cell[CellGroupData[{

Cell["\<\
Timing[CDF[MultinormalDistribution[{0, 1, 2, 3}, 
    {{2, 0.2, 0.8, 0.4},
     {0.2, 1.5, -0.3, 0.1},
     {0.8, -0.3, 3, -1}, 
     {0.4, 0.1, -1, 2.5}}],
  {-1.2, 1, 5, 4},
  PrecisionGoal -> 3]]\
\>", "Input",
  CellLabel->"In[9]:="],

Cell[BoxData[
    \({1.1569999999999965`\ Second, 0.09027945425673418`}\)], "Output",
  CellLabel->"Out[9]="]
}, Open  ]],

Cell["\<\
The change of variables used for large m may slow down the \
computations with default settings.\
\>", "MathCaption",
  CellTags->{"S6.6.1", "1.18"}],

Cell[CellGroupData[{

Cell["\<\
CDF[MultivariateTDistribution[{{1, 0.2}, {0.2, 1}}, 10], 
   {1, 1}, PrecisionGoal -> 4]//Timing\
\>", "Input",
  CellLabel->"In[10]:="],

Cell[BoxData[
    \({0.10899999999999466`\ Second, 0.7049492629283287`}\)], "Output",
  CellLabel->"Out[10]="]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
CDF[MultivariateTDistribution[{{1, 0.2}, {0.2, 1}}, 800], 
   {1, 1}, PrecisionGoal -> 4]//Timing\
\>", "Input",
  CellLabel->"In[11]:="],

Cell[BoxData[
    \({0.703000000000003`\ Second, 0.7205479597488799`}\)], "Output",
  CellLabel->"Out[11]="]
}, Open  ]],

Cell["\<\
Furthermore, convergence problems may exist, unless options are \
chosen to improve the integration.\
\>", "MathCaption",
  CellTags->{"S6.6.1", "1.18"}],

Cell[CellGroupData[{

Cell["\<\
CDF[MultivariateTDistribution[{{1, 0.2}, {0.2, 1}}, 551], 
{1, 1}, SingularityDepth -> 10]\
\>", "Input",
  CellLabel->"In[12]:="],

Cell[BoxData[
    \(0.7204616674417166`\)], "Output",
  CellLabel->"Out[12]="]
}, Open  ]],

Cell["\<\
Many of the multivariate distributions have hidden arguments that \
are evaluated when the distribution is first entered. Random variate \
generation will be more efficient if these arguments are evaluated only once. \
\
\>", "Text",
  CellTags->{"S6.6.1", "1.19"}],

Cell["\<\
This is an inefficient means of computing 1000 multinormal variates \
because the Cholesky decomposition of the covariance matrix is computed for \
each variate. \
\>", "MathCaption",
  CellTags->{"S6.6.1", "1.20"}],

Cell[CellGroupData[{

Cell["\<\
(mu = {1, 2, 3, 4};
sigma = {{1, 1/2, 1/3, 1/4}, {1/2, 1/3, 1/4, 1/5},
        {1/3, 1/4, 1/5, 1/6}, {1/4, 1/5, 1/6, 1/7}};
Timing[Table[Random[MultinormalDistribution[mu, sigma]],
        {1000}]][[1]])\
\>", "Input",
  CellLabel->"In[13]:=",
  CellTags->"S6.6.1"],

Cell[BoxData[
    \(1.2650000000000006`\ Second\)], "Output",
  CellLabel->"Out[13]=",
  CellTags->"S6.6.1"]
}, Open  ]],

Cell["\<\
This method of generating 1000 variates is more efficient because \
the Cholesky decomposition is computed once. \
\>", "MathCaption",
  CellTags->{"S6.6.1", "1.21"}],

Cell[CellGroupData[{

Cell["\<\
Timing[RandomArray[
        MultinormalDistribution[mu, sigma],
        1000]][[1]]\
\>", "Input",
  CellLabel->"In[14]:=",
  CellTags->"S6.6.1"],

Cell[BoxData[
    \(0.06199999999999761`\ Second\)], "Output",
  CellLabel->"Out[14]=",
  CellTags->"S6.6.1"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Quantile[", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["dist", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[", ", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["q", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["]", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    StyleBox["q",
                      "TI"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[" quantile of the univariate distribution ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["dist", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S6.6.1"],

Cell["\<\
Functions of univariate statistical distributions not applicable to \
multivariate distributions. \
\>", "Caption",
  CellTags->"S6.6.1"],

Cell[TextData[{
  "In the multivariate case, it is difficult to define ",
  StyleBox["Quantile", "MR"],
  " as the inverse of the ",
  StyleBox["CDF", "MR"],
  " function, since many values of the random vector (or random matrix) \
correspond to a single probability value. This package defines ",
  StyleBox["Quantile", "MR"],
  " only for the univariate distribution ",
  StyleBox["HotellingTSquareDistribution", "MR"],
  " and some minor degenerate cases of the other distributions. The \
elliptically\[Hyphen]contoured distributions ",
  StyleBox["MultinormalDistribution", "MR"],
  " and ",
  StyleBox["MultivariateTDistribution", "MR"],
  " support ",
  StyleBox["EllipsoidQuantile", "MR"],
  " and its inverse ",
  StyleBox["RegionProbability", "MR"],
  ". "
}], "Text",
  CellTags->{"S6.6.1", "1.22"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["RegionProbability[", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["dist", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[", ", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["domain", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["]", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[StyleBox[
            "cumulative probability within the specified domain ",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[{
              StyleBox["EllipsoidQuantile[", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["dist", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[", ", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["q", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["]", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    StyleBox["q",
                      "TI"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[" elliptically contoured quantile ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[{
              StyleBox["CovarianceMatrix[", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["dist", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["]", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[StyleBox[
            "covariance matrix of the specified distribution ",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[{
              StyleBox["CorrelationMatrix[", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["dist", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["]", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[StyleBox[
            "correlation matrix of the specified distribution ",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[{
              StyleBox["MultivariateSkewness[", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["dist", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["]", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[StyleBox[
            "multivariate coefficient of skewness ",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[{
              StyleBox["MultivariateKurtosis[", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["dist", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["]", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[StyleBox[
            "multivariate kurtosis coefficient ",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[{
              StyleBox["MultivariateKurtosisExcess[", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["dist", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["]", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[StyleBox[
            "multivariate kurtosis excess ",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S6.6.1"],

Cell["\<\
Functions of vector\[Hyphen]valued multivariate statistical \
distributions.\
\>", "Caption",
  CellTags->"S6.6.1"],

Cell[TextData[{
  "This gives the ellipse centered on the mean that encloses 50% of the ",
  StyleBox["ndist", "MR"],
  " distribution. "
}], "MathCaption",
  CellTags->{"S6.6.1", "1.23"}],

Cell[CellGroupData[{

Cell["ellipse = EllipsoidQuantile[ndist, .5]", "Input",
  CellLabel->"In[15]:=",
  CellTags->"S6.6.1"],

Cell[BoxData[
    \(Ellipsoid[{0, 0}, {1.478739931052286`, 
        0.7654521138198402`}, {{0.7071067811865475`, 
          0.7071067811865475`}, {0.7071067811865476`, \
\(-0.7071067811865476`\)}}]\)], "Output",
  CellLabel->"Out[15]=",
  CellTags->"S6.6.1"]
}, Open  ]],

Cell["\<\
This gives the probability of the distribution within the ellipse. \
Note that the ellipse must correspond to a constant\[Hyphen]probability \
contour of the prescribed distribution. \
\>", "MathCaption",
  CellTags->{"S6.6.1", "1.24"}],

Cell[CellGroupData[{

Cell["RegionProbability[ndist, ellipse]", "Input",
  CellLabel->"In[16]:=",
  CellTags->"S6.6.1"],

Cell[BoxData[
    \(0.5`\)], "Output",
  CellLabel->"Out[16]=",
  CellTags->"S6.6.1"]
}, Open  ]],

Cell[TextData[{
  "As ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["m",
            "TI"], "\[Rule]", "\[Infinity]"}], TraditionalForm]], 
    "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  ", the ",
  Cell[BoxData[
      FormBox[
        StyleBox["q",
          "TI"], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  Cell[BoxData[
      \(TraditionalForm\`\[Null]\^th\)], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " elliptical contour of ",
  StyleBox["MultivariateTDistribution[", "MR"],
  StyleBox["m", "TI"],
  StyleBox[", ", "MR"],
  StyleBox["r", "TI"],
  StyleBox["]", "MR"],
  " approaches the ",
  Cell[BoxData[
      FormBox[
        StyleBox["q",
          "TI"], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  Cell[BoxData[
      \(TraditionalForm\`\[Null]\^th\)], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " elliptical contour of a multinormal distribution with zero mean vector \
and covariance matrix ",
  Cell[BoxData[
      FormBox[
        StyleBox["r",
          "TI"], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  ". "
}], "MathCaption",
  CellTags->{"S6.6.1", "1.25"}],

Cell[CellGroupData[{

Cell["\<\
Show[Graphics[{ellipse,
        {Dashing[{.04, .02}], EllipsoidQuantile[
        MultivariateTDistribution[r, 2], .5]},
        {Dashing[{.02, .04}], EllipsoidQuantile[
        MultivariateTDistribution[r, 1], .5]}}
], Axes->True]\
\>", "Input",
  CellLabel->"In[17]:=",
  CellTags->"S6.6.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.500002 0.274931 0.5 0.274931 [
[.08761 .4875 -12 -9 ]
[.08761 .4875 12 0 ]
[.22507 .4875 -6 -9 ]
[.22507 .4875 6 0 ]
[.36254 .4875 -12 -9 ]
[.36254 .4875 12 0 ]
[.63747 .4875 -9 -9 ]
[.63747 .4875 9 0 ]
[.77493 .4875 -3 -9 ]
[.77493 .4875 3 0 ]
[.9124 .4875 -9 -9 ]
[.9124 .4875 9 0 ]
[.4875 .0876 -24 -4.5 ]
[.4875 .0876 0 4.5 ]
[.4875 .22507 -12 -4.5 ]
[.4875 .22507 0 4.5 ]
[.4875 .36253 -24 -4.5 ]
[.4875 .36253 0 4.5 ]
[.4875 .63747 -18 -4.5 ]
[.4875 .63747 0 4.5 ]
[.4875 .77493 -6 -4.5 ]
[.4875 .77493 0 4.5 ]
[.4875 .9124 -18 -4.5 ]
[.4875 .9124 0 4.5 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.08761 .5 m
.08761 .50625 L
s
[(-1.5)] .08761 .4875 0 1 Mshowa
.22507 .5 m
.22507 .50625 L
s
[(-1)] .22507 .4875 0 1 Mshowa
.36254 .5 m
.36254 .50625 L
s
[(-0.5)] .36254 .4875 0 1 Mshowa
.63747 .5 m
.63747 .50625 L
s
[(0.5)] .63747 .4875 0 1 Mshowa
.77493 .5 m
.77493 .50625 L
s
[(1)] .77493 .4875 0 1 Mshowa
.9124 .5 m
.9124 .50625 L
s
[(1.5)] .9124 .4875 0 1 Mshowa
.125 Mabswid
.1151 .5 m
.1151 .50375 L
s
.14259 .5 m
.14259 .50375 L
s
.17009 .5 m
.17009 .50375 L
s
.19758 .5 m
.19758 .50375 L
s
.25256 .5 m
.25256 .50375 L
s
.28006 .5 m
.28006 .50375 L
s
.30755 .5 m
.30755 .50375 L
s
.33504 .5 m
.33504 .50375 L
s
.39003 .5 m
.39003 .50375 L
s
.41752 .5 m
.41752 .50375 L
s
.44502 .5 m
.44502 .50375 L
s
.47251 .5 m
.47251 .50375 L
s
.5275 .5 m
.5275 .50375 L
s
.55499 .5 m
.55499 .50375 L
s
.58248 .5 m
.58248 .50375 L
s
.60997 .5 m
.60997 .50375 L
s
.66496 .5 m
.66496 .50375 L
s
.69245 .5 m
.69245 .50375 L
s
.71995 .5 m
.71995 .50375 L
s
.74744 .5 m
.74744 .50375 L
s
.80243 .5 m
.80243 .50375 L
s
.82992 .5 m
.82992 .50375 L
s
.85741 .5 m
.85741 .50375 L
s
.88491 .5 m
.88491 .50375 L
s
.06011 .5 m
.06011 .50375 L
s
.03262 .5 m
.03262 .50375 L
s
.00513 .5 m
.00513 .50375 L
s
.93989 .5 m
.93989 .50375 L
s
.96738 .5 m
.96738 .50375 L
s
.99488 .5 m
.99488 .50375 L
s
.25 Mabswid
0 .5 m
1 .5 L
s
.5 .0876 m
.50625 .0876 L
s
[(-1.5)] .4875 .0876 1 0 Mshowa
.5 .22507 m
.50625 .22507 L
s
[(-1)] .4875 .22507 1 0 Mshowa
.5 .36253 m
.50625 .36253 L
s
[(-0.5)] .4875 .36253 1 0 Mshowa
.5 .63747 m
.50625 .63747 L
s
[(0.5)] .4875 .63747 1 0 Mshowa
.5 .77493 m
.50625 .77493 L
s
[(1)] .4875 .77493 1 0 Mshowa
.5 .9124 m
.50625 .9124 L
s
[(1.5)] .4875 .9124 1 0 Mshowa
.125 Mabswid
.5 .1151 m
.50375 .1151 L
s
.5 .14259 m
.50375 .14259 L
s
.5 .17008 m
.50375 .17008 L
s
.5 .19758 m
.50375 .19758 L
s
.5 .25256 m
.50375 .25256 L
s
.5 .28006 m
.50375 .28006 L
s
.5 .30755 m
.50375 .30755 L
s
.5 .33504 m
.50375 .33504 L
s
.5 .39003 m
.50375 .39003 L
s
.5 .41752 m
.50375 .41752 L
s
.5 .44501 m
.50375 .44501 L
s
.5 .47251 m
.50375 .47251 L
s
.5 .52749 m
.50375 .52749 L
s
.5 .55499 m
.50375 .55499 L
s
.5 .58248 m
.50375 .58248 L
s
.5 .60997 m
.50375 .60997 L
s
.5 .66496 m
.50375 .66496 L
s
.5 .69245 m
.50375 .69245 L
s
.5 .71994 m
.50375 .71994 L
s
.5 .74744 m
.50375 .74744 L
s
.5 .80242 m
.50375 .80242 L
s
.5 .82992 m
.50375 .82992 L
s
.5 .85741 m
.50375 .85741 L
s
.5 .8849 m
.50375 .8849 L
s
.5 .06011 m
.50375 .06011 L
s
.5 .03262 m
.50375 .03262 L
s
.5 .00512 m
.50375 .00512 L
s
.5 .93989 m
.50375 .93989 L
s
.5 .96738 m
.50375 .96738 L
s
.5 .99488 m
.50375 .99488 L
s
.25 Mabswid
.5 0 m
.5 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 Mabswid
.21253 .21253 m
.21449 .21061 L
.2165 .20875 L
.22067 .20517 L
.22956 .19861 L
.23919 .19287 L
.24953 .18796 L
.25542 .18565 L
.26151 .1836 L
.26778 .18179 L
.27424 .18024 L
.28088 .17895 L
.28427 .17839 L
.2877 .17791 L
.29117 .17748 L
.29468 .17712 L
.29824 .17683 L
.30183 .1766 L
.30522 .17644 L
.30865 .17634 L
.31211 .1763 L
.3156 .17631 L
.31912 .17638 L
.32268 .1765 L
.32626 .17668 L
.32988 .17692 L
.33352 .17721 L
.3372 .17756 L
.34463 .17843 L
.35217 .17952 L
.35982 .18083 L
.3674 .18233 L
.37508 .18405 L
.39068 .18811 L
.40657 .193 L
.42271 .19872 L
.45838 .21386 L
.49458 .2326 L
.56197 .27636 L
.63185 .33473 L
.6939 .40031 L
.7432 .46598 L
.76568 .50239 L
.78478 .53876 L
.79937 .57228 L
.80543 .58877 L
.81064 .60501 L
.81492 .62065 L
.81675 .62835 L
.81836 .63596 L
Mistroke
.81977 .64349 L
.82096 .65092 L
.82194 .65825 L
.8227 .66548 L
.82303 .66935 L
.82329 .67319 L
.82349 .677 L
.82362 .68077 L
.8237 .68451 L
.8237 .68821 L
.82365 .69187 L
.82353 .6955 L
.82335 .69909 L
.82311 .70264 L
.8228 .70615 L
.82243 .70962 L
.8215 .71643 L
.82032 .72308 L
.81899 .72912 L
.81745 .73501 L
.81569 .74074 L
.81371 .7463 L
.80912 .75693 L
.80368 .76685 L
.79686 .77678 L
.78909 .78583 L
.78039 .79396 L
.77079 .80116 L
.76053 .80728 L
.7551 .80999 L
.74947 .81246 L
.73763 .81667 L
.73144 .81841 L
.72506 .81991 L
.71896 .82108 L
.71586 .82159 L
.71272 .82204 L
.70954 .82244 L
.70633 .82278 L
.70308 .82307 L
.6998 .82331 L
.69648 .82349 L
.69314 .82361 L
.68976 .82369 L
.68634 .82371 L
.6829 .82367 L
.67943 .82358 L
.67592 .82344 L
.67239 .82324 L
.66853 .82296 L
Mistroke
.66463 .82262 L
.65673 .82175 L
.64872 .82062 L
.64058 .81924 L
.62399 .81573 L
.60701 .81123 L
.57444 .8002 L
.54105 .78587 L
.50438 .76681 L
.46765 .74431 L
.39718 .69126 L
.33597 .63316 L
.27768 .56376 L
.23339 .49597 L
.21588 .46261 L
.20825 .44607 L
.2014 .42966 L
.1893 .39477 L
.1847 .3778 L
.18109 .3612 L
.17975 .35361 L
.17863 .34611 L
.17772 .33872 L
.17735 .33506 L
.17704 .33144 L
.17678 .32784 L
.17658 .32427 L
.17643 .32073 L
.17633 .31722 L
.1763 .31375 L
.17631 .3103 L
.17639 .30689 L
.17652 .30351 L
.17672 .29989 L
.17698 .2963 L
.17731 .29276 L
.17771 .28926 L
.17869 .28238 L
.17994 .27568 L
.18144 .26916 L
.18319 .26282 L
.18746 .25073 L
.18983 .24529 L
.19243 .24003 L
.19827 .23008 L
.20497 .2209 L
.20865 .21661 L
.21056 .21454 L
.21253 .21253 L
Mfstroke
.15471 .15471 m
.15707 .15241 L
.15948 .15017 L
.16449 .14587 L
.17517 .13799 L
.18674 .13109 L
.19916 .1252 L
.20623 .12243 L
.21354 .11996 L
.22108 .11779 L
.22884 .11593 L
.23681 .11437 L
.24088 .11371 L
.245 .11313 L
.24917 .11262 L
.25339 .11219 L
.25766 .11183 L
.26197 .11155 L
.26605 .11137 L
.27016 .11125 L
.27432 .11119 L
.27851 .11121 L
.28274 .11129 L
.28701 .11144 L
.29132 .11165 L
.29566 .11194 L
.30004 .11229 L
.30445 .11271 L
.31338 .11375 L
.32244 .11506 L
.33162 .11664 L
.34074 .11844 L
.34996 .1205 L
.36869 .12538 L
.38778 .13126 L
.40717 .13812 L
.45001 .15631 L
.49349 .17882 L
.57443 .23138 L
.65837 .30149 L
.7329 .38026 L
.79212 .45914 L
.81911 .50287 L
.84206 .54656 L
.85958 .58682 L
.86685 .60662 L
.87312 .62613 L
.87826 .64491 L
.88045 .65416 L
.88239 .66331 L
Mistroke
.88408 .67235 L
.88551 .68127 L
.88668 .69008 L
.8876 .69876 L
.88799 .70341 L
.88831 .70802 L
.88855 .7126 L
.88871 .71713 L
.8888 .72162 L
.88881 .72606 L
.88874 .73046 L
.8886 .73482 L
.88838 .73913 L
.88809 .74339 L
.88772 .74761 L
.88728 .75177 L
.88616 .75996 L
.88474 .76794 L
.88315 .7752 L
.88129 .78228 L
.87918 .78916 L
.8768 .79584 L
.87129 .8086 L
.86476 .82052 L
.85657 .83245 L
.84723 .84332 L
.83678 .85309 L
.82526 .86173 L
.81293 .86908 L
.8064 .87234 L
.79964 .8753 L
.78542 .88036 L
.77798 .88245 L
.77033 .88425 L
.763 .88566 L
.75927 .88627 L
.7555 .88681 L
.75168 .88729 L
.74782 .8877 L
.74392 .88805 L
.73998 .88833 L
.736 .88855 L
.73198 .8887 L
.72792 .88879 L
.72382 .88881 L
.71969 .88877 L
.71551 .88866 L
.71131 .88849 L
.70706 .88825 L
.70242 .88791 L
Mistroke
.69774 .88751 L
.68826 .88646 L
.67863 .88511 L
.66886 .88345 L
.64893 .87923 L
.62853 .87382 L
.58941 .86058 L
.54931 .84337 L
.50526 .82047 L
.46115 .79344 L
.3765 .72972 L
.30298 .65994 L
.23297 .57658 L
.17977 .49515 L
.15874 .4551 L
.14958 .43522 L
.14135 .41552 L
.12681 .37361 L
.12129 .35322 L
.11695 .33329 L
.11534 .32416 L
.11399 .31516 L
.1129 .30628 L
.11246 .30189 L
.11208 .29753 L
.11177 .29321 L
.11153 .28893 L
.11135 .28468 L
.11124 .28046 L
.11119 .27629 L
.11121 .27215 L
.1113 .26805 L
.11145 .26399 L
.1117 .25964 L
.11202 .25534 L
.11241 .25108 L
.11289 .24687 L
.11407 .23861 L
.11556 .23057 L
.11737 .22273 L
.11947 .21512 L
.12461 .20059 L
.12745 .19406 L
.13056 .18775 L
.13758 .17579 L
.14564 .16477 L
.15005 .15962 L
.15235 .15713 L
.15471 .15471 L
Mfstroke
.07711 .0771 m
.07999 .07429 L
.08295 .07155 L
.08908 .06628 L
.10217 .05663 L
.11633 .04819 L
.13154 .04097 L
.14021 .03757 L
.14916 .03455 L
.15839 .03189 L
.16789 .02961 L
.17766 .02771 L
.18264 .02689 L
.18769 .02618 L
.19279 .02555 L
.19796 .02503 L
.20319 .02459 L
.20848 .02425 L
.21347 .02402 L
.21851 .02387 L
.22359 .02381 L
.22873 .02383 L
.23391 .02393 L
.23914 .02411 L
.24442 .02438 L
.24974 .02472 L
.2551 .02516 L
.2605 .02567 L
.27144 .02694 L
.28253 .02855 L
.29378 .03048 L
.30494 .03269 L
.31623 .03521 L
.33918 .04118 L
.36256 .04838 L
.38631 .05679 L
.43878 .07907 L
.49202 .10664 L
.59115 .17101 L
.69396 .25688 L
.78524 .35334 L
.85777 .44996 L
.89083 .50351 L
.91894 .55702 L
.94039 .60633 L
.9493 .63058 L
.95697 .65447 L
.96327 .67748 L
.96595 .68881 L
.96833 .70001 L
Mistroke
.9704 .71108 L
.97215 .72201 L
.97359 .7328 L
.97471 .74343 L
.97519 .74912 L
.97558 .75477 L
.97587 .76038 L
.97607 .76592 L
.97618 .77142 L
.97619 .77687 L
.97611 .78226 L
.97594 .78759 L
.97567 .79287 L
.97531 .79809 L
.97486 .80326 L
.97432 .80836 L
.97295 .81839 L
.97121 .82816 L
.96926 .83706 L
.96699 .84572 L
.96439 .85414 L
.96149 .86233 L
.95473 .87796 L
.94674 .89255 L
.9367 .90717 L
.92527 .92048 L
.91247 .93244 L
.89836 .94302 L
.88326 .95203 L
.87526 .95602 L
.86698 .95965 L
.84957 .96585 L
.84046 .96841 L
.83108 .97061 L
.82211 .97233 L
.81754 .97308 L
.81292 .97374 L
.80824 .97433 L
.80352 .97483 L
.79874 .97526 L
.79391 .97561 L
.78904 .97587 L
.78411 .97606 L
.77914 .97617 L
.77412 .97619 L
.76906 .97614 L
.76395 .97601 L
.75879 .9758 L
.7536 .9755 L
.74791 .9751 L
Mistroke
.74218 .9746 L
.73057 .97331 L
.71877 .97166 L
.70681 .96963 L
.6824 .96447 L
.65741 .95784 L
.6095 .94161 L
.56039 .92054 L
.50644 .8925 L
.45241 .85939 L
.34875 .78135 L
.2587 .69588 L
.17296 .59379 L
.1078 .49407 L
.08204 .445 L
.07082 .42066 L
.06074 .39653 L
.04294 .3452 L
.03617 .32023 L
.03086 .29582 L
.02889 .28464 L
.02724 .27362 L
.02591 .26274 L
.02536 .25737 L
.0249 .25203 L
.02452 .24674 L
.02422 .24149 L
.024 .23628 L
.02387 .23112 L
.02381 .22601 L
.02384 .22094 L
.02394 .21592 L
.02413 .21095 L
.02443 .20562 L
.02482 .20035 L
.0253 .19514 L
.02589 .18998 L
.02734 .17987 L
.02916 .17001 L
.03137 .16042 L
.03395 .1511 L
.04024 .1333 L
.04372 .1253 L
.04754 .11757 L
.05613 .10293 L
.066 .08943 L
.0714 .08312 L
.07421 .08007 L
.07711 .0771 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[17]:=",
  ImageSize->{350, 350},
  ImageCacheValid->False,
  CellTags->"S6.6.1"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[17]=",
  CellTags->"S6.6.1"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S6.6.1"->{
    Cell[1776, 53, 154, 6, 36, "Subsection",
      CellTags->{"S6.6.1", "1.1"}],
    Cell[1933, 61, 691, 18, 56, "Text",
      CellTags->{"S6.6.1", "1.2"}],
    Cell[2627, 81, 936, 26, 73, "Text",
      CellTags->{"S6.6.1", "1.3"}],
    Cell[3566, 109, 12751, 307, 256, "DefinitionBox",
      CellTags->"S6.6.1"],
    Cell[16320, 418, 138, 4, 15, "Caption",
      CellTags->"S6.6.1"],
    Cell[16461, 424, 4695, 151, 106, "Text",
      CellTags->{"S6.6.1", "1.4"}],
    Cell[21159, 577, 4542, 143, 70, "Text",
      CellTags->{"S6.6.1", "1.5"}],
    Cell[25704, 722, 3135, 106, 70, "Text",
      CellTags->{"S6.6.1", "1.6"}],
    Cell[28842, 830, 2332, 79, 70, "Text",
      CellTags->{"S6.6.1", "1.7"}],
    Cell[31177, 911, 18390, 454, 70, "DefinitionBox",
      CellTags->"S6.6.1"],
    Cell[49570, 1367, 143, 4, 70, "Caption",
      CellTags->"S6.6.1"],
    Cell[49716, 1373, 1100, 35, 70, "Text",
      CellTags->{"S6.6.1", "1.8"}],
    Cell[50819, 1410, 1101, 34, 70, "Text",
      CellTags->{"S6.6.1", "1.9"}],
    Cell[51923, 1446, 2941, 87, 70, "Text",
      CellTags->{"S6.6.1", "1.10"}],
    Cell[54867, 1535, 1028, 28, 70, "Text",
      CellTags->{"S6.6.1", "1.10"}],
    Cell[55898, 1565, 79, 1, 70, "MathCaption",
      CellTags->{"S6.6.1", "1.12"}],
    Cell[55980, 1568, 100, 2, 70, "Input",
      CellTags->"S6.6.1"],
    Cell[56083, 1572, 251, 5, 70, "MathCaption",
      CellTags->{"S6.6.1", "1.13"}],
    Cell[56359, 1581, 153, 5, 70, "Input",
      CellTags->"S6.6.1"],
    Cell[56515, 1588, 221, 6, 70, "Output",
      CellTags->"S6.6.1"],
    Cell[56751, 1597, 100, 1, 70, "MathCaption",
      CellTags->{"S6.6.1", "1.14"}],
    Cell[56876, 1602, 89, 2, 70, "Input",
      CellTags->"S6.6.1"],
    Cell[56968, 1606, 242, 5, 70, "Output",
      CellTags->"S6.6.1"],
    Cell[57225, 1614, 129, 4, 70, "MathCaption",
      CellTags->{"S6.6.1", "1.15"}],
    Cell[57379, 1622, 132, 5, 70, "Input",
      CellTags->"S6.6.1"],
    Cell[57514, 1629, 96778, 4733, 70, 96668, 4729, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S6.6.1"],
    Cell[154295, 6364, 176, 5, 70, "Output",
      CellTags->"S6.6.1"],
    Cell[154486, 6372, 468, 14, 70, "MathCaption",
      CellTags->{"S6.6.1", "1.16"}],
    Cell[154979, 6390, 82, 2, 70, "Input",
      CellTags->"S6.6.1"],
    Cell[155064, 6394, 100, 3, 70, "Output",
      CellTags->"S6.6.1"],
    Cell[155179, 6400, 163, 5, 70, "MathCaption",
      CellTags->{"S6.6.1", "1.17"}],
    Cell[155367, 6409, 193, 6, 70, "Input",
      CellTags->"S6.6.1"],
    Cell[155563, 6417, 110, 3, 70, "Output",
      CellTags->"S6.6.1"],
    Cell[155688, 6423, 428, 13, 70, "MathCaption",
      CellTags->{"S6.6.1", "1.18"}],
    Cell[156141, 6440, 172, 6, 70, "Input",
      CellTags->"S6.6.1"],
    Cell[156316, 6448, 5457, 370, 70, 5352, 366, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S6.6.1"],
    Cell[161776, 6820, 176, 5, 70, "Output",
      CellTags->"S6.6.1"],
    Cell[163416, 6870, 111, 1, 70, "MathCaption",
      CellTags->{"S6.6.1", "1.18"}],
    Cell[163892, 6890, 235, 6, 70, "MathCaption",
      CellTags->{"S6.6.1", "1.18"}],
    Cell[164526, 6916, 159, 4, 70, "MathCaption",
      CellTags->{"S6.6.1", "1.18"}],
    Cell[165279, 6948, 163, 4, 70, "MathCaption",
      CellTags->{"S6.6.1", "1.18"}],
    Cell[165703, 6967, 275, 6, 70, "Text",
      CellTags->{"S6.6.1", "1.19"}],
    Cell[165981, 6975, 225, 5, 70, "MathCaption",
      CellTags->{"S6.6.1", "1.20"}],
    Cell[166231, 6984, 275, 8, 70, "Input",
      CellTags->"S6.6.1"],
    Cell[166509, 6994, 108, 3, 70, "Output",
      CellTags->"S6.6.1"],
    Cell[166632, 7000, 176, 4, 70, "MathCaption",
      CellTags->{"S6.6.1", "1.21"}],
    Cell[166833, 7008, 155, 6, 70, "Input",
      CellTags->"S6.6.1"],
    Cell[166991, 7016, 109, 3, 70, "Output",
      CellTags->"S6.6.1"],
    Cell[167115, 7022, 1931, 48, 70, "DefinitionBox",
      CellTags->"S6.6.1"],
    Cell[169049, 7072, 147, 4, 70, "Caption",
      CellTags->"S6.6.1"],
    Cell[169199, 7078, 809, 21, 70, "Text",
      CellTags->{"S6.6.1", "1.22"}],
    Cell[170011, 7101, 7147, 174, 70, "DefinitionBox",
      CellTags->"S6.6.1"],
    Cell[177161, 7277, 125, 4, 70, "Caption",
      CellTags->"S6.6.1"],
    Cell[177289, 7283, 188, 5, 70, "MathCaption",
      CellTags->{"S6.6.1", "1.23"}],
    Cell[177502, 7292, 102, 2, 70, "Input",
      CellTags->"S6.6.1"],
    Cell[177607, 7296, 258, 6, 70, "Output",
      CellTags->"S6.6.1"],
    Cell[177880, 7305, 246, 5, 70, "MathCaption",
      CellTags->{"S6.6.1", "1.24"}],
    Cell[178151, 7314, 97, 2, 70, "Input",
      CellTags->"S6.6.1"],
    Cell[178251, 7318, 85, 3, 70, "Output",
      CellTags->"S6.6.1"],
    Cell[178351, 7324, 1302, 42, 70, "MathCaption",
      CellTags->{"S6.6.1", "1.25"}],
    Cell[179678, 7370, 302, 9, 70, "Input",
      CellTags->"S6.6.1"],
    Cell[179983, 7381, 10993, 762, 70, 10890, 758, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S6.6.1"],
    Cell[190979, 8145, 177, 5, 70, "Output",
      CellTags->"S6.6.1"]},
  "1.1"->{
    Cell[1776, 53, 154, 6, 36, "Subsection",
      CellTags->{"S6.6.1", "1.1"}]},
  "1.2"->{
    Cell[1933, 61, 691, 18, 56, "Text",
      CellTags->{"S6.6.1", "1.2"}]},
  "1.3"->{
    Cell[2627, 81, 936, 26, 73, "Text",
      CellTags->{"S6.6.1", "1.3"}]},
  "1.4"->{
    Cell[16461, 424, 4695, 151, 106, "Text",
      CellTags->{"S6.6.1", "1.4"}]},
  "1.5"->{
    Cell[21159, 577, 4542, 143, 70, "Text",
      CellTags->{"S6.6.1", "1.5"}]},
  "1.6"->{
    Cell[25704, 722, 3135, 106, 70, "Text",
      CellTags->{"S6.6.1", "1.6"}]},
  "1.7"->{
    Cell[28842, 830, 2332, 79, 70, "Text",
      CellTags->{"S6.6.1", "1.7"}]},
  "1.8"->{
    Cell[49716, 1373, 1100, 35, 70, "Text",
      CellTags->{"S6.6.1", "1.8"}]},
  "1.9"->{
    Cell[50819, 1410, 1101, 34, 70, "Text",
      CellTags->{"S6.6.1", "1.9"}]},
  "1.10"->{
    Cell[51923, 1446, 2941, 87, 70, "Text",
      CellTags->{"S6.6.1", "1.10"}],
    Cell[54867, 1535, 1028, 28, 70, "Text",
      CellTags->{"S6.6.1", "1.10"}]},
  "1.12"->{
    Cell[55898, 1565, 79, 1, 70, "MathCaption",
      CellTags->{"S6.6.1", "1.12"}]},
  "1.13"->{
    Cell[56083, 1572, 251, 5, 70, "MathCaption",
      CellTags->{"S6.6.1", "1.13"}]},
  "1.14"->{
    Cell[56751, 1597, 100, 1, 70, "MathCaption",
      CellTags->{"S6.6.1", "1.14"}]},
  "1.15"->{
    Cell[57225, 1614, 129, 4, 70, "MathCaption",
      CellTags->{"S6.6.1", "1.15"}]},
  "1.16"->{
    Cell[154486, 6372, 468, 14, 70, "MathCaption",
      CellTags->{"S6.6.1", "1.16"}]},
  "1.17"->{
    Cell[155179, 6400, 163, 5, 70, "MathCaption",
      CellTags->{"S6.6.1", "1.17"}]},
  "1.18"->{
    Cell[155688, 6423, 428, 13, 70, "MathCaption",
      CellTags->{"S6.6.1", "1.18"}],
    Cell[163416, 6870, 111, 1, 70, "MathCaption",
      CellTags->{"S6.6.1", "1.18"}],
    Cell[163892, 6890, 235, 6, 70, "MathCaption",
      CellTags->{"S6.6.1", "1.18"}],
    Cell[164526, 6916, 159, 4, 70, "MathCaption",
      CellTags->{"S6.6.1", "1.18"}],
    Cell[165279, 6948, 163, 4, 70, "MathCaption",
      CellTags->{"S6.6.1", "1.18"}]},
  "1.19"->{
    Cell[165703, 6967, 275, 6, 70, "Text",
      CellTags->{"S6.6.1", "1.19"}]},
  "1.20"->{
    Cell[165981, 6975, 225, 5, 70, "MathCaption",
      CellTags->{"S6.6.1", "1.20"}]},
  "1.21"->{
    Cell[166632, 7000, 176, 4, 70, "MathCaption",
      CellTags->{"S6.6.1", "1.21"}]},
  "1.22"->{
    Cell[169199, 7078, 809, 21, 70, "Text",
      CellTags->{"S6.6.1", "1.22"}]},
  "1.23"->{
    Cell[177289, 7283, 188, 5, 70, "MathCaption",
      CellTags->{"S6.6.1", "1.23"}]},
  "1.24"->{
    Cell[177880, 7305, 246, 5, 70, "MathCaption",
      CellTags->{"S6.6.1", "1.24"}]},
  "1.25"->{
    Cell[178351, 7324, 1302, 42, 70, "MathCaption",
      CellTags->{"S6.6.1", "1.25"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S6.6.1", 191806, 8170},
  {"1.1", 196957, 8303},
  {"1.2", 197050, 8306},
  {"1.3", 197138, 8309},
  {"1.4", 197226, 8312},
  {"1.5", 197319, 8315},
  {"1.6", 197411, 8318},
  {"1.7", 197503, 8321},
  {"1.8", 197594, 8324},
  {"1.9", 197686, 8327},
  {"1.10", 197779, 8330},
  {"1.12", 197954, 8335},
  {"1.13", 198052, 8338},
  {"1.14", 198151, 8341},
  {"1.15", 198250, 8344},
  {"1.16", 198349, 8347},
  {"1.17", 198450, 8350},
  {"1.18", 198550, 8353},
  {"1.19", 198999, 8364},
  {"1.20", 199092, 8367},
  {"1.21", 199192, 8370},
  {"1.22", 199292, 8373},
  {"1.23", 199386, 8376},
  {"1.24", 199486, 8379},
  {"1.25", 199586, 8382}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 154, 6, 36, "Subsection",
  CellTags->{"S6.6.1", "1.1"}],
Cell[1933, 61, 691, 18, 56, "Text",
  CellTags->{"S6.6.1", "1.2"}],
Cell[2627, 81, 936, 26, 73, "Text",
  CellTags->{"S6.6.1", "1.3"}],
Cell[3566, 109, 12751, 307, 256, "DefinitionBox",
  CellTags->"S6.6.1"],
Cell[16320, 418, 138, 4, 15, "Caption",
  CellTags->"S6.6.1"],
Cell[16461, 424, 4695, 151, 106, "Text",
  CellTags->{"S6.6.1", "1.4"}],
Cell[21159, 577, 4542, 143, 70, "Text",
  CellTags->{"S6.6.1", "1.5"}],
Cell[25704, 722, 3135, 106, 70, "Text",
  CellTags->{"S6.6.1", "1.6"}],
Cell[28842, 830, 2332, 79, 70, "Text",
  CellTags->{"S6.6.1", "1.7"}],
Cell[31177, 911, 18390, 454, 70, "DefinitionBox",
  CellTags->"S6.6.1"],
Cell[49570, 1367, 143, 4, 70, "Caption",
  CellTags->"S6.6.1"],
Cell[49716, 1373, 1100, 35, 70, "Text",
  CellTags->{"S6.6.1", "1.8"}],
Cell[50819, 1410, 1101, 34, 70, "Text",
  CellTags->{"S6.6.1", "1.9"}],
Cell[51923, 1446, 2941, 87, 70, "Text",
  CellTags->{"S6.6.1", "1.10"}],
Cell[54867, 1535, 1028, 28, 70, "Text",
  CellTags->{"S6.6.1", "1.10"}],
Cell[55898, 1565, 79, 1, 70, "MathCaption",
  CellTags->{"S6.6.1", "1.12"}],
Cell[55980, 1568, 100, 2, 70, "Input",
  CellTags->"S6.6.1"],
Cell[56083, 1572, 251, 5, 70, "MathCaption",
  CellTags->{"S6.6.1", "1.13"}],

Cell[CellGroupData[{
Cell[56359, 1581, 153, 5, 70, "Input",
  CellTags->"S6.6.1"],
Cell[56515, 1588, 221, 6, 70, "Output",
  CellTags->"S6.6.1"]
}, Open  ]],
Cell[56751, 1597, 100, 1, 70, "MathCaption",
  CellTags->{"S6.6.1", "1.14"}],

Cell[CellGroupData[{
Cell[56876, 1602, 89, 2, 70, "Input",
  CellTags->"S6.6.1"],
Cell[56968, 1606, 242, 5, 70, "Output",
  CellTags->"S6.6.1"]
}, Open  ]],
Cell[57225, 1614, 129, 4, 70, "MathCaption",
  CellTags->{"S6.6.1", "1.15"}],

Cell[CellGroupData[{
Cell[57379, 1622, 132, 5, 70, "Input",
  CellTags->"S6.6.1"],
Cell[57514, 1629, 96778, 4733, 70, 96668, 4729, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S6.6.1"],
Cell[154295, 6364, 176, 5, 70, "Output",
  CellTags->"S6.6.1"]
}, Open  ]],
Cell[154486, 6372, 468, 14, 70, "MathCaption",
  CellTags->{"S6.6.1", "1.16"}],

Cell[CellGroupData[{
Cell[154979, 6390, 82, 2, 70, "Input",
  CellTags->"S6.6.1"],
Cell[155064, 6394, 100, 3, 70, "Output",
  CellTags->"S6.6.1"]
}, Open  ]],
Cell[155179, 6400, 163, 5, 70, "MathCaption",
  CellTags->{"S6.6.1", "1.17"}],

Cell[CellGroupData[{
Cell[155367, 6409, 193, 6, 70, "Input",
  CellTags->"S6.6.1"],
Cell[155563, 6417, 110, 3, 70, "Output",
  CellTags->"S6.6.1"]
}, Open  ]],
Cell[155688, 6423, 428, 13, 70, "MathCaption",
  CellTags->{"S6.6.1", "1.18"}],

Cell[CellGroupData[{
Cell[156141, 6440, 172, 6, 70, "Input",
  CellTags->"S6.6.1"],
Cell[156316, 6448, 5457, 370, 70, 5352, 366, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S6.6.1"],
Cell[161776, 6820, 176, 5, 70, "Output",
  CellTags->"S6.6.1"]
}, Open  ]],
Cell[161967, 6828, 1446, 40, 70, "Text"],
Cell[163416, 6870, 111, 1, 70, "MathCaption",
  CellTags->{"S6.6.1", "1.18"}],

Cell[CellGroupData[{
Cell[163552, 6875, 225, 8, 70, "Input"],
Cell[163780, 6885, 97, 2, 70, "Output"]
}, Open  ]],
Cell[163892, 6890, 235, 6, 70, "MathCaption",
  CellTags->{"S6.6.1", "1.18"}],

Cell[CellGroupData[{
Cell[164152, 6900, 247, 9, 70, "Input"],
Cell[164402, 6911, 109, 2, 70, "Output"]
}, Open  ]],
Cell[164526, 6916, 159, 4, 70, "MathCaption",
  CellTags->{"S6.6.1", "1.18"}],

Cell[CellGroupData[{
Cell[164710, 6924, 146, 4, 70, "Input"],
Cell[164859, 6930, 110, 2, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[165006, 6937, 147, 4, 70, "Input"],
Cell[165156, 6943, 108, 2, 70, "Output"]
}, Open  ]],
Cell[165279, 6948, 163, 4, 70, "MathCaption",
  CellTags->{"S6.6.1", "1.18"}],

Cell[CellGroupData[{
Cell[165467, 6956, 140, 4, 70, "Input"],
Cell[165610, 6962, 78, 2, 70, "Output"]
}, Open  ]],
Cell[165703, 6967, 275, 6, 70, "Text",
  CellTags->{"S6.6.1", "1.19"}],
Cell[165981, 6975, 225, 5, 70, "MathCaption",
  CellTags->{"S6.6.1", "1.20"}],

Cell[CellGroupData[{
Cell[166231, 6984, 275, 8, 70, "Input",
  CellTags->"S6.6.1"],
Cell[166509, 6994, 108, 3, 70, "Output",
  CellTags->"S6.6.1"]
}, Open  ]],
Cell[166632, 7000, 176, 4, 70, "MathCaption",
  CellTags->{"S6.6.1", "1.21"}],

Cell[CellGroupData[{
Cell[166833, 7008, 155, 6, 70, "Input",
  CellTags->"S6.6.1"],
Cell[166991, 7016, 109, 3, 70, "Output",
  CellTags->"S6.6.1"]
}, Open  ]],
Cell[167115, 7022, 1931, 48, 70, "DefinitionBox",
  CellTags->"S6.6.1"],
Cell[169049, 7072, 147, 4, 70, "Caption",
  CellTags->"S6.6.1"],
Cell[169199, 7078, 809, 21, 70, "Text",
  CellTags->{"S6.6.1", "1.22"}],
Cell[170011, 7101, 7147, 174, 70, "DefinitionBox",
  CellTags->"S6.6.1"],
Cell[177161, 7277, 125, 4, 70, "Caption",
  CellTags->"S6.6.1"],
Cell[177289, 7283, 188, 5, 70, "MathCaption",
  CellTags->{"S6.6.1", "1.23"}],

Cell[CellGroupData[{
Cell[177502, 7292, 102, 2, 70, "Input",
  CellTags->"S6.6.1"],
Cell[177607, 7296, 258, 6, 70, "Output",
  CellTags->"S6.6.1"]
}, Open  ]],
Cell[177880, 7305, 246, 5, 70, "MathCaption",
  CellTags->{"S6.6.1", "1.24"}],

Cell[CellGroupData[{
Cell[178151, 7314, 97, 2, 70, "Input",
  CellTags->"S6.6.1"],
Cell[178251, 7318, 85, 3, 70, "Output",
  CellTags->"S6.6.1"]
}, Open  ]],
Cell[178351, 7324, 1302, 42, 70, "MathCaption",
  CellTags->{"S6.6.1", "1.25"}],

Cell[CellGroupData[{
Cell[179678, 7370, 302, 9, 70, "Input",
  CellTags->"S6.6.1"],
Cell[179983, 7381, 10993, 762, 70, 10890, 758, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S6.6.1"],
Cell[190979, 8145, 177, 5, 70, "Output",
  CellTags->"S6.6.1"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

