(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    203218,       7975]*)
(*NotebookOutlinePosition[    215275,       8319]*)
(*  CellTagsIndexPosition[    214429,       8283]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Graphics",
 StyleBox["`", "MB"],
 "MultipleListPlot",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.37.1", "1.1"}],

Cell[TextData[{
 StyleBox["MultipleListPlot", "MR"],
 " augments the built\[Hyphen]in function ",
 StyleBox["ListPlot", "MR"],
 " by providing a convenient way to plot several lists on the same axes, each \
with a different style of plotting symbol. You can specify error bars with \
each data point, and a variety of styles for symbol styles exist, including \
various forms of labeled points. "
}], "Text",
 CellTags->{"S5.37.1", "1.2"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["MultipleListPlot[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["list",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["list",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] ]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "plot the lists of data on the same graph",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.37.1"],

Cell["Plotting several lists. ", "Caption",
 CellTags->"S5.37.1"],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.37.1", "1.3"}],

Cell["<<Graphics`MultipleListPlot`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.37.1"],

Cell["Here are some sets of data for use in the examples. ", "MathCaption",
 CellTags->{"S5.37.1", "1.4"}],

Cell["\<\
(list1 = Table[{x, Sin[2 Pi x]},
                {x, 0, 1, 0.1}];
 list2 = Table[{x, Cos[2 Pi x]},
                {x, 0, 1, 0.1}]);\
\>", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.37.1"],

Cell["This plots the lists on the same graph. ", "MathCaption",
 CellTags->{"S5.37.1", "1.5"}],

Cell[CellGroupData[{

Cell["MultipleListPlot[list1, list2]", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.37.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.309017 0.294302 [
[.21429 .29652 -9 -9 ]
[.21429 .29652 9 0 ]
[.40476 .29652 -9 -9 ]
[.40476 .29652 9 0 ]
[.59524 .29652 -9 -9 ]
[.59524 .29652 9 0 ]
[.78571 .29652 -9 -9 ]
[.78571 .29652 9 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.01131 .01472 -12 -4.5 ]
[.01131 .01472 0 4.5 ]
[.01131 .16187 -24 -4.5 ]
[.01131 .16187 0 4.5 ]
[.01131 .45617 -18 -4.5 ]
[.01131 .45617 0 4.5 ]
[.01131 .60332 -6 -4.5 ]
[.01131 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .30902 m
.21429 .31527 L
s
[(0.2)] .21429 .29652 0 1 Mshowa
.40476 .30902 m
.40476 .31527 L
s
[(0.4)] .40476 .29652 0 1 Mshowa
.59524 .30902 m
.59524 .31527 L
s
[(0.6)] .59524 .29652 0 1 Mshowa
.78571 .30902 m
.78571 .31527 L
s
[(0.8)] .78571 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(1)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.07143 .30902 m
.07143 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.16667 .30902 m
.16667 .31277 L
s
.2619 .30902 m
.2619 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.35714 .30902 m
.35714 .31277 L
s
.45238 .30902 m
.45238 .31277 L
s
.5 .30902 m
.5 .31277 L
s
.54762 .30902 m
.54762 .31277 L
s
.64286 .30902 m
.64286 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.7381 .30902 m
.7381 .31277 L
s
.83333 .30902 m
.83333 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.92857 .30902 m
.92857 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.02381 .01472 m
.03006 .01472 L
s
[(-1)] .01131 .01472 1 0 Mshowa
.02381 .16187 m
.03006 .16187 L
s
[(-0.5)] .01131 .16187 1 0 Mshowa
.02381 .45617 m
.03006 .45617 L
s
[(0.5)] .01131 .45617 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(1)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .04415 m
.02756 .04415 L
s
.02381 .07358 m
.02756 .07358 L
s
.02381 .10301 m
.02756 .10301 L
s
.02381 .13244 m
.02756 .13244 L
s
.02381 .1913 m
.02756 .1913 L
s
.02381 .22073 m
.02756 .22073 L
s
.02381 .25016 m
.02756 .25016 L
s
.02381 .27959 m
.02756 .27959 L
s
.02381 .33845 m
.02756 .33845 L
s
.02381 .36788 m
.02756 .36788 L
s
.02381 .39731 m
.02756 .39731 L
s
.02381 .42674 m
.02756 .42674 L
s
.02381 .4856 m
.02756 .4856 L
s
.02381 .51503 m
.02756 .51503 L
s
.02381 .54446 m
.02756 .54446 L
s
.02381 .57389 m
.02756 .57389 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.0001 w
.02381 .30902 -1.875 0 Mabsadd m
.02381 .30902 0 2.5 Mabsadd L
.02381 .30902 1.875 0 Mabsadd L
.02381 .30902 0 -2.5 Mabsadd L
.02381 .30902 -1.875 0 Mabsadd L closepath F
.11905 .482 -1.875 0 Mabsadd m
.11905 .482 0 2.5 Mabsadd L
.11905 .482 1.875 0 Mabsadd L
.11905 .482 0 -2.5 Mabsadd L
.11905 .482 -1.875 0 Mabsadd L closepath F
.21429 .58891 -1.875 0 Mabsadd m
.21429 .58891 0 2.5 Mabsadd L
.21429 .58891 1.875 0 Mabsadd L
.21429 .58891 0 -2.5 Mabsadd L
.21429 .58891 -1.875 0 Mabsadd L closepath F
.30952 .58891 -1.875 0 Mabsadd m
.30952 .58891 0 2.5 Mabsadd L
.30952 .58891 1.875 0 Mabsadd L
.30952 .58891 0 -2.5 Mabsadd L
.30952 .58891 -1.875 0 Mabsadd L closepath F
.40476 .482 -1.875 0 Mabsadd m
.40476 .482 0 2.5 Mabsadd L
.40476 .482 1.875 0 Mabsadd L
.40476 .482 0 -2.5 Mabsadd L
.40476 .482 -1.875 0 Mabsadd L closepath F
.5 .30902 -1.875 0 Mabsadd m
.5 .30902 0 2.5 Mabsadd L
.5 .30902 1.875 0 Mabsadd L
.5 .30902 0 -2.5 Mabsadd L
.5 .30902 -1.875 0 Mabsadd L closepath F
.59524 .13603 -1.875 0 Mabsadd m
.59524 .13603 0 2.5 Mabsadd L
.59524 .13603 1.875 0 Mabsadd L
.59524 .13603 0 -2.5 Mabsadd L
.59524 .13603 -1.875 0 Mabsadd L closepath F
.69048 .02912 -1.875 0 Mabsadd m
.69048 .02912 0 2.5 Mabsadd L
.69048 .02912 1.875 0 Mabsadd L
.69048 .02912 0 -2.5 Mabsadd L
.69048 .02912 -1.875 0 Mabsadd L closepath F
.78571 .02912 -1.875 0 Mabsadd m
.78571 .02912 0 2.5 Mabsadd L
.78571 .02912 1.875 0 Mabsadd L
.78571 .02912 0 -2.5 Mabsadd L
.78571 .02912 -1.875 0 Mabsadd L closepath F
.88095 .13603 -1.875 0 Mabsadd m
.88095 .13603 0 2.5 Mabsadd L
.88095 .13603 1.875 0 Mabsadd L
.88095 .13603 0 -2.5 Mabsadd L
.88095 .13603 -1.875 0 Mabsadd L closepath F
.97619 .30902 -1.875 0 Mabsadd m
.97619 .30902 0 2.5 Mabsadd L
.97619 .30902 1.875 0 Mabsadd L
.97619 .30902 0 -2.5 Mabsadd L
.97619 .30902 -1.875 0 Mabsadd L closepath F
.02381 .60332 0 2.5 Mabsadd m
.02381 .60332 -0.56518 .7779 Mabsadd L
.02381 .60332 -2.37764 .77254 Mabsadd L
.02381 .60332 -0.91448 -0.29713 Mabsadd L
.02381 .60332 -1.46946 -2.02254 Mabsadd L
.02381 .60332 0 -0.96154 Mabsadd L
.02381 .60332 1.46946 -2.02254 Mabsadd L
.02381 .60332 .91448 -0.29713 Mabsadd L
.02381 .60332 2.37764 .77254 Mabsadd L
.02381 .60332 .56518 .7779 Mabsadd L
.02381 .60332 0 2.5 Mabsadd L closepath F
.11905 .54711 0 2.5 Mabsadd m
.11905 .54711 -0.56518 .7779 Mabsadd L
.11905 .54711 -2.37764 .77254 Mabsadd L
.11905 .54711 -0.91448 -0.29713 Mabsadd L
.11905 .54711 -1.46946 -2.02254 Mabsadd L
.11905 .54711 0 -0.96154 Mabsadd L
.11905 .54711 1.46946 -2.02254 Mabsadd L
.11905 .54711 .91448 -0.29713 Mabsadd L
.11905 .54711 2.37764 .77254 Mabsadd L
.11905 .54711 .56518 .7779 Mabsadd L
.11905 .54711 0 2.5 Mabsadd L closepath F
.21429 .39996 0 2.5 Mabsadd m
.21429 .39996 -0.56518 .7779 Mabsadd L
.21429 .39996 -2.37764 .77254 Mabsadd L
.21429 .39996 -0.91448 -0.29713 Mabsadd L
.21429 .39996 -1.46946 -2.02254 Mabsadd L
.21429 .39996 0 -0.96154 Mabsadd L
.21429 .39996 1.46946 -2.02254 Mabsadd L
.21429 .39996 .91448 -0.29713 Mabsadd L
.21429 .39996 2.37764 .77254 Mabsadd L
.21429 .39996 .56518 .7779 Mabsadd L
.21429 .39996 0 2.5 Mabsadd L closepath F
.30952 .21807 0 2.5 Mabsadd m
.30952 .21807 -0.56518 .7779 Mabsadd L
.30952 .21807 -2.37764 .77254 Mabsadd L
.30952 .21807 -0.91448 -0.29713 Mabsadd L
.30952 .21807 -1.46946 -2.02254 Mabsadd L
.30952 .21807 0 -0.96154 Mabsadd L
.30952 .21807 1.46946 -2.02254 Mabsadd L
.30952 .21807 .91448 -0.29713 Mabsadd L
.30952 .21807 2.37764 .77254 Mabsadd L
.30952 .21807 .56518 .7779 Mabsadd L
.30952 .21807 0 2.5 Mabsadd L closepath F
.40476 .07092 0 2.5 Mabsadd m
.40476 .07092 -0.56518 .7779 Mabsadd L
.40476 .07092 -2.37764 .77254 Mabsadd L
.40476 .07092 -0.91448 -0.29713 Mabsadd L
.40476 .07092 -1.46946 -2.02254 Mabsadd L
.40476 .07092 0 -0.96154 Mabsadd L
.40476 .07092 1.46946 -2.02254 Mabsadd L
.40476 .07092 .91448 -0.29713 Mabsadd L
.40476 .07092 2.37764 .77254 Mabsadd L
.40476 .07092 .56518 .7779 Mabsadd L
.40476 .07092 0 2.5 Mabsadd L closepath F
.5 .01472 0 2.5 Mabsadd m
.5 .01472 -0.56518 .7779 Mabsadd L
.5 .01472 -2.37764 .77254 Mabsadd L
.5 .01472 -0.91448 -0.29713 Mabsadd L
.5 .01472 -1.46946 -2.02254 Mabsadd L
.5 .01472 0 -0.96154 Mabsadd L
.5 .01472 1.46946 -2.02254 Mabsadd L
.5 .01472 .91448 -0.29713 Mabsadd L
.5 .01472 2.37764 .77254 Mabsadd L
.5 .01472 .56518 .7779 Mabsadd L
.5 .01472 0 2.5 Mabsadd L closepath F
.59524 .07092 0 2.5 Mabsadd m
.59524 .07092 -0.56518 .7779 Mabsadd L
.59524 .07092 -2.37764 .77254 Mabsadd L
.59524 .07092 -0.91448 -0.29713 Mabsadd L
.59524 .07092 -1.46946 -2.02254 Mabsadd L
.59524 .07092 0 -0.96154 Mabsadd L
.59524 .07092 1.46946 -2.02254 Mabsadd L
.59524 .07092 .91448 -0.29713 Mabsadd L
.59524 .07092 2.37764 .77254 Mabsadd L
.59524 .07092 .56518 .7779 Mabsadd L
.59524 .07092 0 2.5 Mabsadd L closepath F
.69048 .21807 0 2.5 Mabsadd m
.69048 .21807 -0.56518 .7779 Mabsadd L
.69048 .21807 -2.37764 .77254 Mabsadd L
.69048 .21807 -0.91448 -0.29713 Mabsadd L
.69048 .21807 -1.46946 -2.02254 Mabsadd L
.69048 .21807 0 -0.96154 Mabsadd L
.69048 .21807 1.46946 -2.02254 Mabsadd L
.69048 .21807 .91448 -0.29713 Mabsadd L
.69048 .21807 2.37764 .77254 Mabsadd L
.69048 .21807 .56518 .7779 Mabsadd L
.69048 .21807 0 2.5 Mabsadd L closepath F
.78571 .39996 0 2.5 Mabsadd m
.78571 .39996 -0.56518 .7779 Mabsadd L
.78571 .39996 -2.37764 .77254 Mabsadd L
.78571 .39996 -0.91448 -0.29713 Mabsadd L
.78571 .39996 -1.46946 -2.02254 Mabsadd L
.78571 .39996 0 -0.96154 Mabsadd L
.78571 .39996 1.46946 -2.02254 Mabsadd L
.78571 .39996 .91448 -0.29713 Mabsadd L
.78571 .39996 2.37764 .77254 Mabsadd L
.78571 .39996 .56518 .7779 Mabsadd L
.78571 .39996 0 2.5 Mabsadd L closepath F
.88095 .54711 0 2.5 Mabsadd m
.88095 .54711 -0.56518 .7779 Mabsadd L
.88095 .54711 -2.37764 .77254 Mabsadd L
.88095 .54711 -0.91448 -0.29713 Mabsadd L
.88095 .54711 -1.46946 -2.02254 Mabsadd L
.88095 .54711 0 -0.96154 Mabsadd L
.88095 .54711 1.46946 -2.02254 Mabsadd L
.88095 .54711 .91448 -0.29713 Mabsadd L
.88095 .54711 2.37764 .77254 Mabsadd L
.88095 .54711 .56518 .7779 Mabsadd L
.88095 .54711 0 2.5 Mabsadd L closepath F
.97619 .60332 0 2.5 Mabsadd m
.97619 .60332 -0.56518 .7779 Mabsadd L
.97619 .60332 -2.37764 .77254 Mabsadd L
.97619 .60332 -0.91448 -0.29713 Mabsadd L
.97619 .60332 -1.46946 -2.02254 Mabsadd L
.97619 .60332 0 -0.96154 Mabsadd L
.97619 .60332 1.46946 -2.02254 Mabsadd L
.97619 .60332 .91448 -0.29713 Mabsadd L
.97619 .60332 2.37764 .77254 Mabsadd L
.97619 .60332 .56518 .7779 Mabsadd L
.97619 .60332 0 2.5 Mabsadd L closepath F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004/0000]2000`400?l00000o`00003oooooool]
ooooo`00ooooool]ooooo`00ooooool]ooooo`00ooooool]ooooo`006oooool00ooRh^;ohN7Qoooo
o`3oooooo`oooooo000Booooo`06oooomon[IRko0000o`000?l0073od_Oo0oooool00ooPh>3ogmoO
ooooo`3oooooo`oooooo000<ooooo`03oookl_oZj^[oj^[Z00;oj^[Z00Gol__oooooooooooool/R9
od62b005ooooo`03on3Ph?oOgmoooooo083ooooo00Coo_knoiRHV?odm?CoXj>SR_ooool000cooooo
00?ol/fAo`000?l000000_l000001On9b>koooooooooooobcHWo@H;800Gooooo00?oh>3Pol[:b_o_
knl0POooool00omMGEgo30`<ohf=S@2:ooooo`005?ooool00oobcHWo@H;8ooooo`04ooooo`03on3P
h?nl_;coi>CT083ooooo00Go[:b/oaPH6?l0003o9bLWolC4a029ooooo`005?ooool00ookdY7o@H;8
ooooo`04ooooo`03on3Ph?oOgmoooooo087ooooo00?ono_kodA4A?ooool0<oooool00ooTi>Cooooo
ooooo`0Gooooo`03onWYjOokno_ooooo03[ooooo000Booooo`04oooonoo2TG3oCbh0obj9b0Gooooo
00?oh>3PomoOgoooool0P_ooool00ooNg]koooooooooo`0aooooo`03ol?3`olA4A7of][J01Oooooo
00?ono_koc`l??mgMgL0>oooool001?ooooo00?ono;Zolfm/Onab>D01Oooool00ooPh>3ogmoOoooo
o`2eooooo`05on_[jolL71co0000oc0`<?ogmoL05_ooool01?mgMgOo0000o`410Onf][Hjooooo`00
6oooool00ooPh>3ogmoOooooo`2eooooo`05om;Bd_l820So0000oa@D5?oVi^H05_ooool01?m:BT[o
0000o`000?n:RXXjooooo`006oooool00ooPh>3ogmoOooooo`2fooooo`03oiNGUol10@7o][Jf01Oo
oooo00Cojn_[oa`L7?m9BDWoo_kn>_ooool001_ooooo00?oh>3PomoOgoooool0]oooool00one]KGo
ooooooooo`0Gooooo`03olW9bOo[jn_ooooo03[ooooo000Kooooo`03on3Ph?oJf][ooooo0?oooooo
3oooool001_ooooo00?oh>3PolS8b?ooool0ooooool?ooooo`006oooool00ooPh>3ogmoOooooo`3o
ooooo`oooooo000Kooooo`03on3Ph?oOgmoooooo0?oooooo3oooool001_ooooo00?oh>3PomoOgooo
ool0ooooool?ooooo`006oooool00ooPh>3ogmoOooooo`3oooooo`oooooo000Kooooo`03on3Ph?oO
gmoooooo06Kooooo00ComoOgoooooooooooomoOg<Oooool01?ogmoOoooooooooooogmoM_ooooo`00
6oooool00ooPh>3ogmoOooooo`1Vooooo`04ok6a/OmoOgooIFEUomOGec7ooooo00Co/K6aogmoOomU
IFGogMgMKoooool001_ooooo00?oh>3PomoOgoooool0I_ooool01?o:b/[o0000o`P82?oShn<aoooo
o`04ol[:b_l0003o410@onOWifoooooo000Kooooo`03on3Ph?o3`l?ooooo06Gooooo00KokNg]ogUi
NOlb<S;o@410oh>3Poofm_H_ooooo`06ong]kOmiNGWo<S8bod10@?n5QHGomoOgK_ooool001_ooooo
00?oh>3PomoOgoooool0Ioooool00on_[jood=3@ooooo`0booooo`03ojn_[oo@d=3ooooo06oooooo
000Kooooo`03on3Ph?oOgmoooooo06Oooooo00?on_[jooooooooool0<_ooool00oojn_[ooooooooo
o`1_ooooo`006oooool00ooPh>3ogmoOooooo`3oooooo`oooooo000Kooooo`03on3Ph?oOgmoooooo
0?oooooo3oooool001_ooooo00?oh>3PomoOgoooool0ooooool?ooooo`006oooool00ooPh>3ogmoO
ooooo`3oooooo`oooooo000Kooooo`03on3Ph?oOgmoooooo0?oooooo3oooool001_ooooo00?oh>3P
olW9bOooool0ooooool?ooooo`006oooool00ooPh>3ofMWIooooo`3oooooo`oooooo000Kooooo`03
on3Ph?oOgmoooooo0?oooooo3oooool001_ooooo00?oh>3PomoOgoooool0ooooool?ooooo`006ooo
ool00ooPh>3ogmoOooooo`3oooooo`oooooo000Kooooo`03on3Ph?oOgmoooooo0?oooooo3oooool0
01_ooooo00?oh>3PomoOgoooool0ooooool?ooooo`006oooool00ooPh>3ogmoOooooo`2Looooo`03
om7AdOoShn?ooooo04cooooo00?oo_knokJf]_ooool08?ooool001_ooooo00?oh>3Polk>c_ooool0
Voooool01?obl_;o9BDUoc`l??okno]<ooooo`03ohN7Qol410Co`l?3023ooooo000Kooooo`03on3P
h?oDe=Cooooo09_ooooo00CoFUYJo`000?l0003oNWYjBoooool01Oo6a/Ko10@4o`000?lL71cok^k^
01oooooo000Kooooo`03on3Ph?oOgmoooooo09_ooooo00CoQhN7o`000?l0003oYjNWBoooool01OoS
hn?o51@Do`000?ll?3cono_k01oooooo000Kooooo`03on3Ph?oOgmoooooo09_ooooo00?oo_knodU9
BOmWIfL0COooool00onf][Ko5ADEon?Sh`0Pooooo`006oooool00ooPh>3ogmoOooooo`2Looooo`03
ong]kOogmoOooooo04gooooo00?oi>CTooooooooool07oooool000Sooooo00?ono;^onkbnoooool0
2?ooool00oooooOol_;boo;gn`05ooooo`03on3Ph?oOgmoooooo0?oooooo3oooool000Oooooo00Co
iL:Ao`000?l0003oTL;U0_ooool02_oonmcoN@00o`00NOoLnoooooooooo^`_m1003o02h^o`000?m`
Zm84ooooo`03on3Ph?oOgmoooooo0?oooooo3oooool00003oookl_oZj^[oj^[Z00;oj^[Z01?ol__o
ooool_n9003oYN3ooooUZol008Wok_ooooooooooonGoRDl0o`11ROoUoooooooooooomoo^k_Oooooo
ooo^`_l^05coeo_o00?ooooo00?oh>3PomoOgoooool0ooooool?ooooo`0000?ol/fAo`000?l00000
0_l000001on9b>koooO=odl0L?oLoooooooPog00Coo8l_l02Oooool00oooomcoG011olSbo`03oooo
o`03on3Ph?o7alOok>c/0?oooooo3oooool000Kooooo00KoooO=oea1TOo^oooooooboi51Coo2k_l6
ooooo`06ooool_nHCbkoG7V2og110?l0IZ_omooo0oooool00ooPh>3o_knoonOWi`3oooooo`oooooo
0006ooooo`06ooooh?m`047ob?OooookcOm1073oh?oo1_ooool01?oooo;oTD4^oiS2cOoBenD5oooo
o`03on3Ph?oOgmoooooo0?oooooo3oooool000Kooooo00Kooookok5`0?l^NIooWgU1o`1V/Ookool6
ooooo`05ooool_n9003oChVHoiRAROnU`^001?ooool00ooPh>3ogmoOooooo`3oooooo`oooooo0007
ooooo`04ooook_ngV8WoRIRgonkoo`Oooooo00Gooookomc=_Ong]kOo]k6aol;GkP04ooooo`03on3P
h?oOgmoooooo0?oooooo3oooool001_ooooo00?oh>3PomoOgoooool0ooooool?ooooo`006oooool0
0ooPh>3ogmoOooooo`3oooooo`oooooo000Kooooo`03on3Ph?oOgmoooooo0?oooooo3oooool001_o
oooo00?oh>3PomSHf?ooool0ooooool?ooooo`006oooool00ooPh>3ob/[:ooooo`3oooooo`oooooo
000Kooooo`03on3Ph?oOgmoooooo0?oooooo3oooool001_ooooo00?oh>3PomoOgoooool0ooooool?
ooooo`006oooool00ooPh>3ogmoOooooo`3oooooo`oooooo000Kooooo`03on3Ph?oOgmoooooo0?oo
oooo3oooool001_ooooo00?oh>3PomoOgoooool0C?ooool00ooclo?ooooooo;blP1Vooooo`04ookn
o_oclo?ooooooo?cleGooooo000Kooooo`03on3Ph?oOgmoooooo04cooooo00?oI6AToi6ATOm[Jf/0
Ioooool00omHF5SoT92@ogQhN01Eooooo`006oooool00ooPh>3og]kNooooo`1;ooooo`05ooShn?m>
CTko0000oeeMGOolo?`0IOooool01OoemOGo@D51o`000?mYJFWooOgm05Cooooo000Kooooo`03on3P
h?o4a<Cooooo04_ooooo00Go/[:bogUiNOl;2`_oOgmool30`01Uooooo`05ojZZZ_mcLg?o2PX:ogmo
Ooo2`/80E?ooool001_ooooo00?oh>3PomoOgoooool0COooool00on:RX[oooooooooo`1Wooooo`03
ohB4Q?oooooooooo05Cooooo000Kooooo`03on3Ph?oOgmoooooo04gooooo00?oo?clooooooooool0
Ioooool00oolo?coooooooooo`1Dooooo`006oooool00ooPh>3ogmoOooooo`3oooooo`oooooo000K
ooooo`03on3Ph?oOgmoooooo0?oooooo3oooool001_ooooo00?oh>3PomoOgoooool0ooooool?oooo
o`006oooool00ooPh>3ogmoOooooo`3oooooo`oooooo000Kooooo`03on3Ph?oOgmoooooo0?oooooo
3oooool001_ooooo00?oh>3PolO7aoooool0ooooool?ooooo`006oooool00ooPh>3ofm_Kooooo`3o
ooooo`oooooo000Kooooo`03on3Ph?oOgmoooooo0?oooooo3oooool001_ooooo00?oh>3PomoOgooo
ool0ooooool?ooooo`006oooool00ooPh>3ogmoOooooo`0[ooooo`03oookl_o^k_;ooooo03;ooooo
00?ooo_bonk^l_ooool0<_ooool00ooono;ok^kbooooo`09ooooo`03oookmoo^k_;ooooo02Kooooo
00?ooo_bonk^l_ooool02Oooool00ooomo;oj^kbooooo`0eooooo`006oooool00ooPh>3ogmoOoooo
o`0Zooooo`05oo_U`_mL003o0000odnA`_okool00_ooool01_ngNBko000^oj_Lmooooooooo_Gog00
00;o000000?o0011olSbooooool08oooool01OokiL;oG000o`000?m?TL;onooo00;ooooo00?o]gT^
o`00;_n[g?L00oooool01?okg:_o@@00o`00L?oBmolTooooo`05oo_U`_mL003o0000odnA`_okool0
0_ooool00ongNBko000^oj_Lm`02ooooo`05ooOU_Om?003o0000o`1?V?oZool09?ooool01OokiL;o
G000o`000?m?TL;onooo00;ooooo00?o]gT^o`00;_n[g?L00_ooool01OoZ`Y7o0000obh^0?l0@I7o
iO_o02[ooooo00GoejE`o`000?l0003o000^ojGGlP05ooooo`006oooool00ooPh>3ogmoOooooo`0Z
ooooo`05olf9;_m?YN3ooooPoe`0;_o2l_l00_ooool00oo2TDoo001?okgUn`02ooooo`05omNUG?l0
05cocO;kon[GcOoUmol09?ooool01Oo=RBkoCjGPooooh?mL02ko`_;o00;ooooo00[o`Y5?o`00Conm
iO_ooooooooonooG`[Oo/KNgojF9G?mLP[7oj__o9?ooool01Oo=RBkoCjGPooooh?mL02ko`_;o00;o
oooo00?o`Y5?o`00ConmiO/00_ooool01Oo2NBkoI[7Uooool_nA003oV=Ob02Cooooo00GocHT^odnU
h?ooon3oG00^ol;bo`02ooooo`0:ol:ACol004oo_NGkoooooooooo;oV2h0oioGnoooooooYDl0oi7=
lR_ooooo00?ooo;8odl^ROo^ool01_ooool001_ooooo00?oh>3PomoOgoooool0:Oooool01_oooo;o
V44^oj_Pnooooo_o/FH^ohW=kPSooooo00?og;5io`00Coo=l_l09?ooool01_oooo;oV44^oj_Pnooo
oo_o/FH^ohW=kPKooooo00KoooobohT00?m1PYSoTG1Lobi?L?nmh?LSooooo`06ooool_nH@BkoZn3k
oooononaIRkoRLg^1_ooool01_oooo;oTBh0ogW2k_oooo;oTBh0oiSBlR?ooooo00KooooboiQ1;_n[
h?_ooookok5V;_n9cNh6ooooo`06oooomon[IRkoIZG=onkZcOm`02koYMcg:oooool00oool/SoCbjA
onkoo`06ooooo`006oooool00ooPh>3oc<c<ooooo`0Yooooo`06ooook_n9;Toob?;oooooooo=RDoo
P/;^2Oooool00ooBV47o06Jaoo_oo`0Sooooo`06ooook_n9;Toob?;oooooooo=RDooP/;^1oooool0
1?oP/G3oG9oLoo_GWonAb?8Tooooo`06ooook_n9;Toob?;oooooooo=RDooP/;^1_ooool01_oooo;o
V440o`000?l^;P3o046AonGoob?ooooo00Koooo^ohT^Coo8l_ooooooolf9Con2`^h7ooooo`05oo;=
TOl0003o0000o`0^TOobool0:oooool00oool/SoCbjAonkoo`06ooooo`006oooool00ooPh>3oe]KF
ooooo`0Yooooo`06oooonongIRkoRLggoooomonA;RkoZn3k1oooool01Oobk_;ooooooooog?mL047o
b?;o02?ooooo00KooookokMV;_n9cOOoooogoi4^;_n[h?/7ooooo`04ooook_n9@EcoV:F9oiS8kRCo
oooo00KooookokMV;_n9cOOoooogoi4^;_n[h?/7ooooo`03olR9@Om1TLSok_;b02Gooooo00Kooook
okMV;_n9cOOoooogoi4^;_n[h?/6ooooo`06oooomonUC`3oP/SboooomonA003oV=Ob:oooool00ooo
nlgoCbj9onkoo`06ooooo`006oooool00ooPh>3ogmoOooooo`0Zooooo`05on2aL?l0;WWoZjEio`00
L?oLnol01_ooool01_ooooOoWd40obj2ZonmZh;o001VomOkobCooooo00Goh;5`o`0^NOn[YGWo001`
omcko`08ooooo`03oo_LZol0003oRLS^02Gooooo00Goh;5`o`0^NOn[YGWo001`omcko`07ooooo`05
ooogd_mV003oIY6aolS=d_o^nol09?ooool01OoP/G3o02iioj^UNOl0073og?_o00Oooooo00Gob8U1
o`1`YOoBb:Go;P11ol;^o`0Zooooo`04on[8WomLCbko02jAonkoo`Kooooo000Kooooo`03on3Ph?oO
gmoooooo02_ooooo00?oekNOoh:9WooGk_l02?ooool01?oomn[o`Z^HohV9WooBj_LVooooo`03omNg
Won2RIooenko00[ooooo00?od[6UolSUmoooool09Oooool00ooG]iooPXVOomO^o`09ooooo`04oook
iOngWi7oPX:Hom;^obGooooo00?oekNOoh:9WooGk_l02?ooool01?ooonko`Z^Hoh:2V?o2g?8[oooo
o`04oookl_oLcKgoZk7=ooOoo`Kooooo000Kooooo`03on3Ph?oOgmoooooo0?oooooo3oooool001_o
oooo00?oh>3PomoOgoooool0ooooool?ooooo`006oooool2ol[:bX?ooooo00?oclo?ooooooooool0
POooool00ooJf][omOGeooooo`05ooooo`006_ooool01?omoOgo>CTiocTi>OomoOf1ooooo`03ojn_
[ol61PKobLW9087ooooo00?omOGeobXZ:_mOGel01_ooool001Gooooo00?ok>c/on3Ph?oPh>000_oP
h>001?m_Kfoo0000o`000?m_Kfn0on3Ph005ol?3`ol>3Pko0000oa`L7?oAdM40P?oPh>001?mCDe?o
0000o`000?n;Rh/4on3Ph07ol?3`000Eooooo`03on_[jooOgmoogmoO00;ogmoO00CoKfm_o`000?l0
003oKfm_2_oOgml00ooHf=Sob/[:omoOg`0:omoOg`03omkNg_o4a<CogmoO00_ogmoO00?obLW9omWI
fOoOgml02_oOgml00oo0`<3oa/K6omoOg`0:omoOg`03omOGeoo;bl_ogmoO00[ogmoO00?og]kNolC4
a?oOgml02ooOgml00oo9bLWofMWIomoOg`0:omoOg`03ol30`?o6a/KogmoO00[ogmoO00?oemOGol_;
booOgml02OoOgml01Oo3`l?o3@d=o`000?lK6a_odM7A00[ogmoO00?obLW9omWIfOoOgml02_oOgml0
0oo0`<3oa/K6omoOg`0:omoOg`03omOGeoo;bl_ogmoO00[ogmoO00?og]kNolC4a?oOgml02ooOgml0
0oo7alOofm_KomoOg`0:omoOg`03okbl_?o:b/[ogmoO00[ogmoO00?oeMGEolg=cOoOgml02_oOgml0
0ooLg=coa/K6omoOg`0;omoOg`03olO7aooKfm_ogmoO00WogmoO00CoDe=Co`000?l0003oRh^;1?oO
gml1ono_k`006_ooool01?omoOgo>CTiocTi>OomoOd;ooooo`03ookno_oooooooooo00[ooooo00?o
o_knooooooooool02_ooool00oono_koooooooooo`0:ooooo`03onGUiOoZj^[ooooo00_ooooo00?o
o_knooooooooool02_ooool00oono_koooooooooo`0:ooooo`03ookno_oooooooooo00[ooooo00?o
iNGUon[Zj_ooool02oooool00oono_koooooooooo`09ooooo`03ojn_[ol51@Gob/[:00_ooooo00?o
o_knooooooooool02_ooool00ooUiNGoj^[Zooooo`0;ooooo`03ookno_oooooooooo00[ooooo00?o
o_knooooooooool02_ooool00oono_koooooooooo`0:ooooo`03on;Rh_o]kNgooooo00_ooooo00?o
o_knooooooooool02_ooool00oono_koooooooooo`0:ooooo`03ookno_oooooooooo00Wooooo00?o
mOGeobDU9OmIFET01_ooool001_ooooo0_o:b/Z3ooooo`03olo?cooooooooooo087ooooo00?of][J
ooGemOooool01Oooool001_ooooo00?oh>3PomoOgoooool0ooooool?ooooo`006oooool00ooPh>3o
gmoOooooo`3oooooo`oooooo000Kooooo`03on3Ph?oOgmoooooo0?oooooo3oooool001_ooooo00?o
h>3PomoOgoooool0ooooool?ooooo`006oooool00ooPh>3oemOGooooo`3oooooo`oooooo000Koooo
o`03on3Ph?o;bl_ooooo0?oooooo3oooool001_ooooo00?oh>3PomoOgoooool0ooooool?ooooo`00
6oooool00ooPh>3ogmoOooooo`3oooooo`oooooo000Kooooo`03on3Ph?oOgmoooooo0?oooooo3ooo
ool001_ooooo00?oh>3PomoOgoooool0ooooool?ooooo`006oooool00ooPh>3ogmoOooooo`3ooooo
o`oooooo000Kooooo`03on3Ph?oOgmoooooo0?oooooo3oooool001_ooooo00?oh>3PomcLg?ooool0
ooooool?ooooo`006oooool00ooPh>3oa/K6ooooo`3oooooo`oooooo000Kooooo`03on3Ph?oOgmoo
oooo0?oooooo3oooool001_ooooo00?oh>3PomoOgoooool0ooooool?ooooo`006oooool00ooPh>3o
gmoOooooo`3oooooo`oooooo000Kooooo`03on3Ph?oOgmoooooo0?oooooo3oooool001_ooooo00?o
h>3PomoOgoooool0ooooool?ooooo`006oooool00ooPh>3ogmoOooooo`3oooooo`oooooo000Koooo
o`03on3Ph?oOgmoooooo037ooooo00Coc/k>onKVi_oLg=coe=CDVoooool01?o9bLWok>c/omGEeOoK
fm/jooooo`006oooool00ooPh>3oaLG5ooooo`0aooooo`04onGUiOlG5aOo4a<Coo3`l9_ooooo00Co
e]KFoaTI6OlG5aOon?Sh>_ooool001_ooooo00?oh>3PomgMgOooool0<?ooool01_odm?CoIFEUo`00
0?l10@7oMWIfoo_kniWooooo00Kol?3`oeYJF_l0003o0`<3oh:2P_omoOdiooooo`006oooool00ooP
h>3ogmoOooooo`0`ooooo`06ooWinOo_knooOWinoibLW?o_knoono_kVOooool01_ohn?Sokno_ofm_
Kon[Zj_okno_ooclo3Wooooo000Kooooo`03on3Ph?oOgmoooooo03;ooooo00?ofMWIoo3`l?ooool0
W?ooool00oo@d=3on?Shooooo`0jooooo`006oooool00ooPh>3ogmoOooooo`3oooooo`oooooo000K
ooooo`03on3Ph?oOgmoooooo0?oooooo3oooool001_ooooo00?oh>3PomoOgoooool0ooooool?oooo
o`006oooool00ooPh>3ogmoOooooo`3oooooo`oooooo000Kooooo`03on3Ph?o:b/[ooooo0?oooooo
3oooool001_ooooo00?oh>3PomSHf?ooool0ooooool?ooooo`006oooool00ooPh>3ogmoOooooo`3o
ooooo`oooooo000Kooooo`03on3Ph?oOgmoooooo0?oooooo3oooool000Sooooo00?ono;^onkbnooo
ool02?ooool00oooooOol_;boo;gn`05ooooo`03on3Ph?oOgmoooooo0?oooooo3oooool000Oooooo
00CoiL:Ao`000?l0003oTL;U0_ooool02_oonmcoN@00o`00NOoLnoooooooooo^`_m1003o02h^o`00
0?m`Zm84ooooo`03on3Ph?oOgmoooooo0?oooooo3oooool000Kooooo01;oooobohT00?nUh?ooonF[
o`00ROo^ooooooooooooiOn9C`3o0469onGoooooooooooogonk^moooooooonk2obh0G?oGnol3oooo
o`03on3Ph?oOgmoooooo0?oooooo3oooool000Kooooo00KoooO=odl0L?oLoooooooPog00Coo8l_l9
ooooo`03oooog?mL047ob?;o00?ooooo00?oh>3PomoOgoooool0ooooool?ooooo`001_ooool01_oo
mlgoG46Aonkooooooo;oTD5?ol;^o`Kooooo00KooooboiQ?;_mLNH;oL440o`1VZoogool3ooooo`03
on3Ph?o0`<3oinOW0?oooooo3oooool000Kooooo00KooooPog00@Oo8mooooo_=od40L?oPool6oooo
o`04ooool_nA@BkoV<;=om;Gi@Gooooo00?oh>3PolK6a_o/k>`0ooooool?ooooo`001_ooool01_oo
oo_o/G00obiiWonOND7o06Jaoo_oo`Kooooo00GoooobohT00?m?RISoV969ojG2h004ooooo`03on3P
h?oOgmoooooo0?oooooo3oooool000Oooooo00Coooo^okNHROn9V;Ook_oo1oooool01Ooooo_og<fm
okNg]ong/K7o`]O^00Cooooo00?oh>3PomoOgoooool0ooooool?ooooo`006oooool00ooPh>3ogmoO
ooooo`3oooooo`oooooo000Kooooo`03on3Ph?oOgmoooooo01Sooooo00?oi>CTooooooooool0C?oo
ool00oo]kNgomoOgooooo`2Tooooo`006oooool00ooPh>3ogmoOooooo`0Gooooo`03ol?3`olA4A7o
f][J04cooooo00?oo_knodU9BOmWIfL0YOooool001_ooooo00?oh>3PomoOgoooool05_ooool01Oo[
jn_o71`Lo`000?l`<33omoOg04_ooooo00CoQhN7o`000?l0003oYjNWY?ooool001_ooooo00?oh>3P
omGEeOooool05_ooool01OoBd];o20P8o`000?lD51Coi^KV04_ooooo00CoFUYJo`000?l0003oNWYj
Y?ooool001_ooooo00?oh>3Polg=cOooool05oooool00onGUiOo0@41okJf]P1<ooooo`04oo;bl_lU
9BGo?3`loo_knjCooooo000Kooooo`03on3Ph?oOgmoooooo01Sooooo00?o]KFeooooooooool0C?oo
ool00ooAdM7ohn?Sooooo`2Tooooo`006oooool00ooPh>3ogmoOooooo`3oooooo`oooooo000Koooo
o`03on3Ph?oOgmoooooo0?oooooo3oooool001_ooooo00?oh>3PomoOgoooool0ooooool?ooooo`00
6oooool00ooPh>3ogmoOooooo`3oooooo`oooooo000Kooooo`03on3Ph?oOgmoooooo0?oooooo3ooo
ool001_ooooo00?oh>3Pom[Jf_ooool0ooooool?ooooo`006oooool00ooPh>3ob<S8ooooo`3ooooo
o`oooooo000Kooooo`03on3Ph?oOgmoooooo0?oooooo3oooool001_ooooo00?oh>3PomoOgoooool0
ooooool?ooooo`006oooool00ooPh>3ogmoOooooo`3oooooo`oooooo000Kooooo`03on3Ph?oOgmoo
oooo0?oooooo3oooool001_ooooo00?oh>3PomoOgoooool0ooooool?ooooo`006oooool00ooPh>3o
gmoOooooo`3oooooo`oooooo000Kooooo`03on3Ph?oOgmoooooo01Oooooo00?oZJVYoo_knonWYjL0
d?ooool01?ono_koZZZZooWinOnZZZXPooooo`006oooool00ooPh>3o`l?3ooooo`0Gooooo`03of][
JolF5QKoNg]k0=7ooooo00?oFe]KoaHF5_n;Rh/08?ooool001_ooooo00?oh>3PomoOgoooool05_oo
ool01On`/;3o51@Do`000?lJ6Q[o^[Zj0<oooooo00GoYJFUo`l?3ol0003o8R8Rol[:bP0Oooooo`00
6oooool00ooPh>3ogmoOooooo`0Gooooo`03ooWinOl^;Rkoo_kn0=7ooooo00?ol_;bod10@?ooool0
8?ooool001_ooooo00?oh>3PomoOgoooool06?ooool00oo?clooooooooooo`3Aooooo`03om7AdOoo
oooooooo01oooooo000Kooooo`03on3Ph?oOgmoooooo0?oooooo3oooool001_ooooo00?oh>3PomoO
goooool0ooooool?ooooo`006oooool00ooPh>3ogmoOooooo`3oooooo`oooooo000Kooooo`03on3P
h?oOgmoooooo0?oooooo3oooool001_ooooo00?oh>3PolW9bOooool0ooooool?ooooo`006oooool0
0ooPh>3ofMWIooooo`3oooooo`oooooo000Kooooo`03on3Ph?oOgmoooooo03;ooooo00?odM7Aon?S
hoooool06?ooool00one]KGoooooooooo`2nooooo`006oooool00ooPh>3ogmoOooooo`0aooooo`04
oo;bl_lU9BGo?3`loo_knaOooooo00?oUiNGo`410Onf][H0_oooool001_ooooo00?oh>3PomoOgooo
ool0<Oooool01?mJFU[o0000o`000?mjNWXFooooo`05om;Bd_l820So0000oa@D5?oVi^H0__ooool0
01;ooooo00Koooogoj]V;_l0003o0000o`00L?oBmol3ooooo`03on3Ph?oOgmoooooo037ooooo00Co
QhN7o`000?l0003oYjNW5_ooool01Oo[jn_o71`Lo`000?l`<33omoOg0;kooooo000Dooooo`03oo;8
ROm1P/Sooooo00?ooooo00Cono_kon3Ph?oOgmoono_k<Oooool00oono_koBDU9ofMWI`0Hooooo`03
ol?3`olA4A7of][J0;Kooooo00Cono_koooooooooooono_k1Oooool001Cooooo00?ol/f9od62b?oo
ool00oooool01?nm_KgoM7Adog1`L?o;bl/booooo`03ong]kOogmoOooooo01Sooooo00?oi>CToooo
ooooool0]Oooool01?n[Zj_oUYJFofi^K_oIfMT5ooooo`005?ooool00oobcHWo@H;8ooooo`03oooo
o`04omoOgol0003o1@D5olo?cooooooo1_ooool01?o3`l?o0000oa4A4Oo`l?05ooooo`005?ooool0
0ookdY7o@H;8ooooo`02ooooo`06oo;bl_mdM7Co:BTYobDU9Om_Kfoolo?cooooool4ooooo`06onSX
j?m[Jf_o8b<Soc/k>on1PH7on_[j1?ooool001;ooooo00Cooookol:AL?m?;P3o;XW81Oooool2oj2P
X?oooooo2?ooool00onGUiOof=SHooooo`05ooooo`004oooool00ookl^[ocKfaok78i@05ooooo`03
om_KfooJf][ooooo0?oooooo1oooool00oodm?Coooooooooo`05ooooo`006oooool00ooRh^;ohN7Q
ooooo`3oooooo`oooooo003oooooobgooooo003oooooobgooooo003oooooobgooooo003oooooobgo
oooo0000\
\>"],
 ImageRangeCache->{{{0, 299}, {179, 0}} -> {-0.103731, -1.09335, 0.00377504, \
0.0122163}},
 CellTags->"S5.37.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.37.1"]
}, Open  ]],

Cell["\<\
This connects the plotting symbols with lines of different styles. \
\>", "MathCaption",
 CellTags->{"S5.37.1", "1.6"}],

Cell[CellGroupData[{

Cell["\<\
MultipleListPlot[list1, list2,
 PlotJoined -> True]\
\>", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.37.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.309017 0.294302 [
[.21429 .29652 -9 -9 ]
[.21429 .29652 9 0 ]
[.40476 .29652 -9 -9 ]
[.40476 .29652 9 0 ]
[.59524 .29652 -9 -9 ]
[.59524 .29652 9 0 ]
[.78571 .29652 -9 -9 ]
[.78571 .29652 9 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.01131 .01472 -12 -4.5 ]
[.01131 .01472 0 4.5 ]
[.01131 .16187 -24 -4.5 ]
[.01131 .16187 0 4.5 ]
[.01131 .45617 -18 -4.5 ]
[.01131 .45617 0 4.5 ]
[.01131 .60332 -6 -4.5 ]
[.01131 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .30902 m
.21429 .31527 L
s
[(0.2)] .21429 .29652 0 1 Mshowa
.40476 .30902 m
.40476 .31527 L
s
[(0.4)] .40476 .29652 0 1 Mshowa
.59524 .30902 m
.59524 .31527 L
s
[(0.6)] .59524 .29652 0 1 Mshowa
.78571 .30902 m
.78571 .31527 L
s
[(0.8)] .78571 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(1)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.07143 .30902 m
.07143 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.16667 .30902 m
.16667 .31277 L
s
.2619 .30902 m
.2619 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.35714 .30902 m
.35714 .31277 L
s
.45238 .30902 m
.45238 .31277 L
s
.5 .30902 m
.5 .31277 L
s
.54762 .30902 m
.54762 .31277 L
s
.64286 .30902 m
.64286 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.7381 .30902 m
.7381 .31277 L
s
.83333 .30902 m
.83333 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.92857 .30902 m
.92857 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.02381 .01472 m
.03006 .01472 L
s
[(-1)] .01131 .01472 1 0 Mshowa
.02381 .16187 m
.03006 .16187 L
s
[(-0.5)] .01131 .16187 1 0 Mshowa
.02381 .45617 m
.03006 .45617 L
s
[(0.5)] .01131 .45617 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(1)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .04415 m
.02756 .04415 L
s
.02381 .07358 m
.02756 .07358 L
s
.02381 .10301 m
.02756 .10301 L
s
.02381 .13244 m
.02756 .13244 L
s
.02381 .1913 m
.02756 .1913 L
s
.02381 .22073 m
.02756 .22073 L
s
.02381 .25016 m
.02756 .25016 L
s
.02381 .27959 m
.02756 .27959 L
s
.02381 .33845 m
.02756 .33845 L
s
.02381 .36788 m
.02756 .36788 L
s
.02381 .39731 m
.02756 .39731 L
s
.02381 .42674 m
.02756 .42674 L
s
.02381 .4856 m
.02756 .4856 L
s
.02381 .51503 m
.02756 .51503 L
s
.02381 .54446 m
.02756 .54446 L
s
.02381 .57389 m
.02756 .57389 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.001 w
.02381 .30902 m
.11905 .482 L
.21429 .58891 L
.30952 .58891 L
.40476 .482 L
.5 .30902 L
.59524 .13603 L
.69048 .02912 L
.78571 .02912 L
.88095 .13603 L
.97619 .30902 L
s
.0001 w
.02381 .30902 -1.875 0 Mabsadd m
.02381 .30902 0 2.5 Mabsadd L
.02381 .30902 1.875 0 Mabsadd L
.02381 .30902 0 -2.5 Mabsadd L
.02381 .30902 -1.875 0 Mabsadd L closepath F
.11905 .482 -1.875 0 Mabsadd m
.11905 .482 0 2.5 Mabsadd L
.11905 .482 1.875 0 Mabsadd L
.11905 .482 0 -2.5 Mabsadd L
.11905 .482 -1.875 0 Mabsadd L closepath F
.21429 .58891 -1.875 0 Mabsadd m
.21429 .58891 0 2.5 Mabsadd L
.21429 .58891 1.875 0 Mabsadd L
.21429 .58891 0 -2.5 Mabsadd L
.21429 .58891 -1.875 0 Mabsadd L closepath F
.30952 .58891 -1.875 0 Mabsadd m
.30952 .58891 0 2.5 Mabsadd L
.30952 .58891 1.875 0 Mabsadd L
.30952 .58891 0 -2.5 Mabsadd L
.30952 .58891 -1.875 0 Mabsadd L closepath F
.40476 .482 -1.875 0 Mabsadd m
.40476 .482 0 2.5 Mabsadd L
.40476 .482 1.875 0 Mabsadd L
.40476 .482 0 -2.5 Mabsadd L
.40476 .482 -1.875 0 Mabsadd L closepath F
.5 .30902 -1.875 0 Mabsadd m
.5 .30902 0 2.5 Mabsadd L
.5 .30902 1.875 0 Mabsadd L
.5 .30902 0 -2.5 Mabsadd L
.5 .30902 -1.875 0 Mabsadd L closepath F
.59524 .13603 -1.875 0 Mabsadd m
.59524 .13603 0 2.5 Mabsadd L
.59524 .13603 1.875 0 Mabsadd L
.59524 .13603 0 -2.5 Mabsadd L
.59524 .13603 -1.875 0 Mabsadd L closepath F
.69048 .02912 -1.875 0 Mabsadd m
.69048 .02912 0 2.5 Mabsadd L
.69048 .02912 1.875 0 Mabsadd L
.69048 .02912 0 -2.5 Mabsadd L
.69048 .02912 -1.875 0 Mabsadd L closepath F
.78571 .02912 -1.875 0 Mabsadd m
.78571 .02912 0 2.5 Mabsadd L
.78571 .02912 1.875 0 Mabsadd L
.78571 .02912 0 -2.5 Mabsadd L
.78571 .02912 -1.875 0 Mabsadd L closepath F
.88095 .13603 -1.875 0 Mabsadd m
.88095 .13603 0 2.5 Mabsadd L
.88095 .13603 1.875 0 Mabsadd L
.88095 .13603 0 -2.5 Mabsadd L
.88095 .13603 -1.875 0 Mabsadd L closepath F
.97619 .30902 -1.875 0 Mabsadd m
.97619 .30902 0 2.5 Mabsadd L
.97619 .30902 1.875 0 Mabsadd L
.97619 .30902 0 -2.5 Mabsadd L
.97619 .30902 -1.875 0 Mabsadd L closepath F
.001 w
[ .5 3 ] 0 Mabsdash
.02381 .60332 m
.11905 .54711 L
.21429 .39996 L
.30952 .21807 L
.40476 .07092 L
.5 .01472 L
.59524 .07092 L
.69048 .21807 L
.78571 .39996 L
.88095 .54711 L
.97619 .60332 L
s
.0001 w
[ ] 0 setdash
.02381 .60332 0 2.5 Mabsadd m
.02381 .60332 -0.56518 .7779 Mabsadd L
.02381 .60332 -2.37764 .77254 Mabsadd L
.02381 .60332 -0.91448 -0.29713 Mabsadd L
.02381 .60332 -1.46946 -2.02254 Mabsadd L
.02381 .60332 0 -0.96154 Mabsadd L
.02381 .60332 1.46946 -2.02254 Mabsadd L
.02381 .60332 .91448 -0.29713 Mabsadd L
.02381 .60332 2.37764 .77254 Mabsadd L
.02381 .60332 .56518 .7779 Mabsadd L
.02381 .60332 0 2.5 Mabsadd L closepath F
.11905 .54711 0 2.5 Mabsadd m
.11905 .54711 -0.56518 .7779 Mabsadd L
.11905 .54711 -2.37764 .77254 Mabsadd L
.11905 .54711 -0.91448 -0.29713 Mabsadd L
.11905 .54711 -1.46946 -2.02254 Mabsadd L
.11905 .54711 0 -0.96154 Mabsadd L
.11905 .54711 1.46946 -2.02254 Mabsadd L
.11905 .54711 .91448 -0.29713 Mabsadd L
.11905 .54711 2.37764 .77254 Mabsadd L
.11905 .54711 .56518 .7779 Mabsadd L
.11905 .54711 0 2.5 Mabsadd L closepath F
.21429 .39996 0 2.5 Mabsadd m
.21429 .39996 -0.56518 .7779 Mabsadd L
.21429 .39996 -2.37764 .77254 Mabsadd L
.21429 .39996 -0.91448 -0.29713 Mabsadd L
.21429 .39996 -1.46946 -2.02254 Mabsadd L
.21429 .39996 0 -0.96154 Mabsadd L
.21429 .39996 1.46946 -2.02254 Mabsadd L
.21429 .39996 .91448 -0.29713 Mabsadd L
.21429 .39996 2.37764 .77254 Mabsadd L
.21429 .39996 .56518 .7779 Mabsadd L
.21429 .39996 0 2.5 Mabsadd L closepath F
.30952 .21807 0 2.5 Mabsadd m
.30952 .21807 -0.56518 .7779 Mabsadd L
.30952 .21807 -2.37764 .77254 Mabsadd L
.30952 .21807 -0.91448 -0.29713 Mabsadd L
.30952 .21807 -1.46946 -2.02254 Mabsadd L
.30952 .21807 0 -0.96154 Mabsadd L
.30952 .21807 1.46946 -2.02254 Mabsadd L
.30952 .21807 .91448 -0.29713 Mabsadd L
.30952 .21807 2.37764 .77254 Mabsadd L
.30952 .21807 .56518 .7779 Mabsadd L
.30952 .21807 0 2.5 Mabsadd L closepath F
.40476 .07092 0 2.5 Mabsadd m
.40476 .07092 -0.56518 .7779 Mabsadd L
.40476 .07092 -2.37764 .77254 Mabsadd L
.40476 .07092 -0.91448 -0.29713 Mabsadd L
.40476 .07092 -1.46946 -2.02254 Mabsadd L
.40476 .07092 0 -0.96154 Mabsadd L
.40476 .07092 1.46946 -2.02254 Mabsadd L
.40476 .07092 .91448 -0.29713 Mabsadd L
.40476 .07092 2.37764 .77254 Mabsadd L
.40476 .07092 .56518 .7779 Mabsadd L
.40476 .07092 0 2.5 Mabsadd L closepath F
.5 .01472 0 2.5 Mabsadd m
.5 .01472 -0.56518 .7779 Mabsadd L
.5 .01472 -2.37764 .77254 Mabsadd L
.5 .01472 -0.91448 -0.29713 Mabsadd L
.5 .01472 -1.46946 -2.02254 Mabsadd L
.5 .01472 0 -0.96154 Mabsadd L
.5 .01472 1.46946 -2.02254 Mabsadd L
.5 .01472 .91448 -0.29713 Mabsadd L
.5 .01472 2.37764 .77254 Mabsadd L
.5 .01472 .56518 .7779 Mabsadd L
.5 .01472 0 2.5 Mabsadd L closepath F
.59524 .07092 0 2.5 Mabsadd m
.59524 .07092 -0.56518 .7779 Mabsadd L
.59524 .07092 -2.37764 .77254 Mabsadd L
.59524 .07092 -0.91448 -0.29713 Mabsadd L
.59524 .07092 -1.46946 -2.02254 Mabsadd L
.59524 .07092 0 -0.96154 Mabsadd L
.59524 .07092 1.46946 -2.02254 Mabsadd L
.59524 .07092 .91448 -0.29713 Mabsadd L
.59524 .07092 2.37764 .77254 Mabsadd L
.59524 .07092 .56518 .7779 Mabsadd L
.59524 .07092 0 2.5 Mabsadd L closepath F
.69048 .21807 0 2.5 Mabsadd m
.69048 .21807 -0.56518 .7779 Mabsadd L
.69048 .21807 -2.37764 .77254 Mabsadd L
.69048 .21807 -0.91448 -0.29713 Mabsadd L
.69048 .21807 -1.46946 -2.02254 Mabsadd L
.69048 .21807 0 -0.96154 Mabsadd L
.69048 .21807 1.46946 -2.02254 Mabsadd L
.69048 .21807 .91448 -0.29713 Mabsadd L
.69048 .21807 2.37764 .77254 Mabsadd L
.69048 .21807 .56518 .7779 Mabsadd L
.69048 .21807 0 2.5 Mabsadd L closepath F
.78571 .39996 0 2.5 Mabsadd m
.78571 .39996 -0.56518 .7779 Mabsadd L
.78571 .39996 -2.37764 .77254 Mabsadd L
.78571 .39996 -0.91448 -0.29713 Mabsadd L
.78571 .39996 -1.46946 -2.02254 Mabsadd L
.78571 .39996 0 -0.96154 Mabsadd L
.78571 .39996 1.46946 -2.02254 Mabsadd L
.78571 .39996 .91448 -0.29713 Mabsadd L
.78571 .39996 2.37764 .77254 Mabsadd L
.78571 .39996 .56518 .7779 Mabsadd L
.78571 .39996 0 2.5 Mabsadd L closepath F
.88095 .54711 0 2.5 Mabsadd m
.88095 .54711 -0.56518 .7779 Mabsadd L
.88095 .54711 -2.37764 .77254 Mabsadd L
.88095 .54711 -0.91448 -0.29713 Mabsadd L
.88095 .54711 -1.46946 -2.02254 Mabsadd L
.88095 .54711 0 -0.96154 Mabsadd L
.88095 .54711 1.46946 -2.02254 Mabsadd L
.88095 .54711 .91448 -0.29713 Mabsadd L
.88095 .54711 2.37764 .77254 Mabsadd L
.88095 .54711 .56518 .7779 Mabsadd L
.88095 .54711 0 2.5 Mabsadd L closepath F
.97619 .60332 0 2.5 Mabsadd m
.97619 .60332 -0.56518 .7779 Mabsadd L
.97619 .60332 -2.37764 .77254 Mabsadd L
.97619 .60332 -0.91448 -0.29713 Mabsadd L
.97619 .60332 -1.46946 -2.02254 Mabsadd L
.97619 .60332 0 -0.96154 Mabsadd L
.97619 .60332 1.46946 -2.02254 Mabsadd L
.97619 .60332 .91448 -0.29713 Mabsadd L
.97619 .60332 2.37764 .77254 Mabsadd L
.97619 .60332 .56518 .7779 Mabsadd L
.97619 .60332 0 2.5 Mabsadd L closepath F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.37.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.37.1"]
}, Open  ]],

Cell["The lines can be drawn for particular lists of data. ", "MathCaption",
 CellTags->{"S5.37.1", "1.7"}],

Cell[CellGroupData[{

Cell["\<\
MultipleListPlot[list1, list2,
 PlotJoined -> {True, False}]\
\>", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.37.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.309017 0.294302 [
[.21429 .29652 -9 -9 ]
[.21429 .29652 9 0 ]
[.40476 .29652 -9 -9 ]
[.40476 .29652 9 0 ]
[.59524 .29652 -9 -9 ]
[.59524 .29652 9 0 ]
[.78571 .29652 -9 -9 ]
[.78571 .29652 9 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.01131 .01472 -12 -4.5 ]
[.01131 .01472 0 4.5 ]
[.01131 .16187 -24 -4.5 ]
[.01131 .16187 0 4.5 ]
[.01131 .45617 -18 -4.5 ]
[.01131 .45617 0 4.5 ]
[.01131 .60332 -6 -4.5 ]
[.01131 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .30902 m
.21429 .31527 L
s
[(0.2)] .21429 .29652 0 1 Mshowa
.40476 .30902 m
.40476 .31527 L
s
[(0.4)] .40476 .29652 0 1 Mshowa
.59524 .30902 m
.59524 .31527 L
s
[(0.6)] .59524 .29652 0 1 Mshowa
.78571 .30902 m
.78571 .31527 L
s
[(0.8)] .78571 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(1)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.07143 .30902 m
.07143 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.16667 .30902 m
.16667 .31277 L
s
.2619 .30902 m
.2619 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.35714 .30902 m
.35714 .31277 L
s
.45238 .30902 m
.45238 .31277 L
s
.5 .30902 m
.5 .31277 L
s
.54762 .30902 m
.54762 .31277 L
s
.64286 .30902 m
.64286 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.7381 .30902 m
.7381 .31277 L
s
.83333 .30902 m
.83333 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.92857 .30902 m
.92857 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.02381 .01472 m
.03006 .01472 L
s
[(-1)] .01131 .01472 1 0 Mshowa
.02381 .16187 m
.03006 .16187 L
s
[(-0.5)] .01131 .16187 1 0 Mshowa
.02381 .45617 m
.03006 .45617 L
s
[(0.5)] .01131 .45617 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(1)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .04415 m
.02756 .04415 L
s
.02381 .07358 m
.02756 .07358 L
s
.02381 .10301 m
.02756 .10301 L
s
.02381 .13244 m
.02756 .13244 L
s
.02381 .1913 m
.02756 .1913 L
s
.02381 .22073 m
.02756 .22073 L
s
.02381 .25016 m
.02756 .25016 L
s
.02381 .27959 m
.02756 .27959 L
s
.02381 .33845 m
.02756 .33845 L
s
.02381 .36788 m
.02756 .36788 L
s
.02381 .39731 m
.02756 .39731 L
s
.02381 .42674 m
.02756 .42674 L
s
.02381 .4856 m
.02756 .4856 L
s
.02381 .51503 m
.02756 .51503 L
s
.02381 .54446 m
.02756 .54446 L
s
.02381 .57389 m
.02756 .57389 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.001 w
.02381 .30902 m
.11905 .482 L
.21429 .58891 L
.30952 .58891 L
.40476 .482 L
.5 .30902 L
.59524 .13603 L
.69048 .02912 L
.78571 .02912 L
.88095 .13603 L
.97619 .30902 L
s
.0001 w
.02381 .30902 -1.875 0 Mabsadd m
.02381 .30902 0 2.5 Mabsadd L
.02381 .30902 1.875 0 Mabsadd L
.02381 .30902 0 -2.5 Mabsadd L
.02381 .30902 -1.875 0 Mabsadd L closepath F
.11905 .482 -1.875 0 Mabsadd m
.11905 .482 0 2.5 Mabsadd L
.11905 .482 1.875 0 Mabsadd L
.11905 .482 0 -2.5 Mabsadd L
.11905 .482 -1.875 0 Mabsadd L closepath F
.21429 .58891 -1.875 0 Mabsadd m
.21429 .58891 0 2.5 Mabsadd L
.21429 .58891 1.875 0 Mabsadd L
.21429 .58891 0 -2.5 Mabsadd L
.21429 .58891 -1.875 0 Mabsadd L closepath F
.30952 .58891 -1.875 0 Mabsadd m
.30952 .58891 0 2.5 Mabsadd L
.30952 .58891 1.875 0 Mabsadd L
.30952 .58891 0 -2.5 Mabsadd L
.30952 .58891 -1.875 0 Mabsadd L closepath F
.40476 .482 -1.875 0 Mabsadd m
.40476 .482 0 2.5 Mabsadd L
.40476 .482 1.875 0 Mabsadd L
.40476 .482 0 -2.5 Mabsadd L
.40476 .482 -1.875 0 Mabsadd L closepath F
.5 .30902 -1.875 0 Mabsadd m
.5 .30902 0 2.5 Mabsadd L
.5 .30902 1.875 0 Mabsadd L
.5 .30902 0 -2.5 Mabsadd L
.5 .30902 -1.875 0 Mabsadd L closepath F
.59524 .13603 -1.875 0 Mabsadd m
.59524 .13603 0 2.5 Mabsadd L
.59524 .13603 1.875 0 Mabsadd L
.59524 .13603 0 -2.5 Mabsadd L
.59524 .13603 -1.875 0 Mabsadd L closepath F
.69048 .02912 -1.875 0 Mabsadd m
.69048 .02912 0 2.5 Mabsadd L
.69048 .02912 1.875 0 Mabsadd L
.69048 .02912 0 -2.5 Mabsadd L
.69048 .02912 -1.875 0 Mabsadd L closepath F
.78571 .02912 -1.875 0 Mabsadd m
.78571 .02912 0 2.5 Mabsadd L
.78571 .02912 1.875 0 Mabsadd L
.78571 .02912 0 -2.5 Mabsadd L
.78571 .02912 -1.875 0 Mabsadd L closepath F
.88095 .13603 -1.875 0 Mabsadd m
.88095 .13603 0 2.5 Mabsadd L
.88095 .13603 1.875 0 Mabsadd L
.88095 .13603 0 -2.5 Mabsadd L
.88095 .13603 -1.875 0 Mabsadd L closepath F
.97619 .30902 -1.875 0 Mabsadd m
.97619 .30902 0 2.5 Mabsadd L
.97619 .30902 1.875 0 Mabsadd L
.97619 .30902 0 -2.5 Mabsadd L
.97619 .30902 -1.875 0 Mabsadd L closepath F
.02381 .60332 0 2.5 Mabsadd m
.02381 .60332 -0.56518 .7779 Mabsadd L
.02381 .60332 -2.37764 .77254 Mabsadd L
.02381 .60332 -0.91448 -0.29713 Mabsadd L
.02381 .60332 -1.46946 -2.02254 Mabsadd L
.02381 .60332 0 -0.96154 Mabsadd L
.02381 .60332 1.46946 -2.02254 Mabsadd L
.02381 .60332 .91448 -0.29713 Mabsadd L
.02381 .60332 2.37764 .77254 Mabsadd L
.02381 .60332 .56518 .7779 Mabsadd L
.02381 .60332 0 2.5 Mabsadd L closepath F
.11905 .54711 0 2.5 Mabsadd m
.11905 .54711 -0.56518 .7779 Mabsadd L
.11905 .54711 -2.37764 .77254 Mabsadd L
.11905 .54711 -0.91448 -0.29713 Mabsadd L
.11905 .54711 -1.46946 -2.02254 Mabsadd L
.11905 .54711 0 -0.96154 Mabsadd L
.11905 .54711 1.46946 -2.02254 Mabsadd L
.11905 .54711 .91448 -0.29713 Mabsadd L
.11905 .54711 2.37764 .77254 Mabsadd L
.11905 .54711 .56518 .7779 Mabsadd L
.11905 .54711 0 2.5 Mabsadd L closepath F
.21429 .39996 0 2.5 Mabsadd m
.21429 .39996 -0.56518 .7779 Mabsadd L
.21429 .39996 -2.37764 .77254 Mabsadd L
.21429 .39996 -0.91448 -0.29713 Mabsadd L
.21429 .39996 -1.46946 -2.02254 Mabsadd L
.21429 .39996 0 -0.96154 Mabsadd L
.21429 .39996 1.46946 -2.02254 Mabsadd L
.21429 .39996 .91448 -0.29713 Mabsadd L
.21429 .39996 2.37764 .77254 Mabsadd L
.21429 .39996 .56518 .7779 Mabsadd L
.21429 .39996 0 2.5 Mabsadd L closepath F
.30952 .21807 0 2.5 Mabsadd m
.30952 .21807 -0.56518 .7779 Mabsadd L
.30952 .21807 -2.37764 .77254 Mabsadd L
.30952 .21807 -0.91448 -0.29713 Mabsadd L
.30952 .21807 -1.46946 -2.02254 Mabsadd L
.30952 .21807 0 -0.96154 Mabsadd L
.30952 .21807 1.46946 -2.02254 Mabsadd L
.30952 .21807 .91448 -0.29713 Mabsadd L
.30952 .21807 2.37764 .77254 Mabsadd L
.30952 .21807 .56518 .7779 Mabsadd L
.30952 .21807 0 2.5 Mabsadd L closepath F
.40476 .07092 0 2.5 Mabsadd m
.40476 .07092 -0.56518 .7779 Mabsadd L
.40476 .07092 -2.37764 .77254 Mabsadd L
.40476 .07092 -0.91448 -0.29713 Mabsadd L
.40476 .07092 -1.46946 -2.02254 Mabsadd L
.40476 .07092 0 -0.96154 Mabsadd L
.40476 .07092 1.46946 -2.02254 Mabsadd L
.40476 .07092 .91448 -0.29713 Mabsadd L
.40476 .07092 2.37764 .77254 Mabsadd L
.40476 .07092 .56518 .7779 Mabsadd L
.40476 .07092 0 2.5 Mabsadd L closepath F
.5 .01472 0 2.5 Mabsadd m
.5 .01472 -0.56518 .7779 Mabsadd L
.5 .01472 -2.37764 .77254 Mabsadd L
.5 .01472 -0.91448 -0.29713 Mabsadd L
.5 .01472 -1.46946 -2.02254 Mabsadd L
.5 .01472 0 -0.96154 Mabsadd L
.5 .01472 1.46946 -2.02254 Mabsadd L
.5 .01472 .91448 -0.29713 Mabsadd L
.5 .01472 2.37764 .77254 Mabsadd L
.5 .01472 .56518 .7779 Mabsadd L
.5 .01472 0 2.5 Mabsadd L closepath F
.59524 .07092 0 2.5 Mabsadd m
.59524 .07092 -0.56518 .7779 Mabsadd L
.59524 .07092 -2.37764 .77254 Mabsadd L
.59524 .07092 -0.91448 -0.29713 Mabsadd L
.59524 .07092 -1.46946 -2.02254 Mabsadd L
.59524 .07092 0 -0.96154 Mabsadd L
.59524 .07092 1.46946 -2.02254 Mabsadd L
.59524 .07092 .91448 -0.29713 Mabsadd L
.59524 .07092 2.37764 .77254 Mabsadd L
.59524 .07092 .56518 .7779 Mabsadd L
.59524 .07092 0 2.5 Mabsadd L closepath F
.69048 .21807 0 2.5 Mabsadd m
.69048 .21807 -0.56518 .7779 Mabsadd L
.69048 .21807 -2.37764 .77254 Mabsadd L
.69048 .21807 -0.91448 -0.29713 Mabsadd L
.69048 .21807 -1.46946 -2.02254 Mabsadd L
.69048 .21807 0 -0.96154 Mabsadd L
.69048 .21807 1.46946 -2.02254 Mabsadd L
.69048 .21807 .91448 -0.29713 Mabsadd L
.69048 .21807 2.37764 .77254 Mabsadd L
.69048 .21807 .56518 .7779 Mabsadd L
.69048 .21807 0 2.5 Mabsadd L closepath F
.78571 .39996 0 2.5 Mabsadd m
.78571 .39996 -0.56518 .7779 Mabsadd L
.78571 .39996 -2.37764 .77254 Mabsadd L
.78571 .39996 -0.91448 -0.29713 Mabsadd L
.78571 .39996 -1.46946 -2.02254 Mabsadd L
.78571 .39996 0 -0.96154 Mabsadd L
.78571 .39996 1.46946 -2.02254 Mabsadd L
.78571 .39996 .91448 -0.29713 Mabsadd L
.78571 .39996 2.37764 .77254 Mabsadd L
.78571 .39996 .56518 .7779 Mabsadd L
.78571 .39996 0 2.5 Mabsadd L closepath F
.88095 .54711 0 2.5 Mabsadd m
.88095 .54711 -0.56518 .7779 Mabsadd L
.88095 .54711 -2.37764 .77254 Mabsadd L
.88095 .54711 -0.91448 -0.29713 Mabsadd L
.88095 .54711 -1.46946 -2.02254 Mabsadd L
.88095 .54711 0 -0.96154 Mabsadd L
.88095 .54711 1.46946 -2.02254 Mabsadd L
.88095 .54711 .91448 -0.29713 Mabsadd L
.88095 .54711 2.37764 .77254 Mabsadd L
.88095 .54711 .56518 .7779 Mabsadd L
.88095 .54711 0 2.5 Mabsadd L closepath F
.97619 .60332 0 2.5 Mabsadd m
.97619 .60332 -0.56518 .7779 Mabsadd L
.97619 .60332 -2.37764 .77254 Mabsadd L
.97619 .60332 -0.91448 -0.29713 Mabsadd L
.97619 .60332 -1.46946 -2.02254 Mabsadd L
.97619 .60332 0 -0.96154 Mabsadd L
.97619 .60332 1.46946 -2.02254 Mabsadd L
.97619 .60332 .91448 -0.29713 Mabsadd L
.97619 .60332 2.37764 .77254 Mabsadd L
.97619 .60332 .56518 .7779 Mabsadd L
.97619 .60332 0 2.5 Mabsadd L closepath F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.37.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S5.37.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["y", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["a ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["y",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[" value, with the ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["x",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[" value determined by the position in the list",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["{", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["y", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["a point denoted by ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["{", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["y", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[" coordinates",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["{", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["point", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ErrorBar[", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["yerr", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]}", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["a point with an error, where the point may be specified as ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["y",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[" or ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["{", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["y", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[", and the error is ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["yerr", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" in both the positive and negative directions of the ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["y",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[" coordinate",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["{", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["point", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ErrorBar[{", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["negerr", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["poserr", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]}", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "a point with different errors in the positive and negative directions",
      GridBoxOptions->{RowLines->{False, True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{False, True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["{", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["point", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ErrorBar[", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["xerr", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["yerr", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]}", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["a point with errors specified for both the ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["x",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[" and ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["y",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[" coordinates",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ErrorBar[{", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["ymin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["ymax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[" or ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["ErrorBar[{", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["xmin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["xmax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["ymin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["ymax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "data given only by a range, where the symbol for the point is drawn at \
the center of the error bars",
      GridBoxOptions->{RowLines->{False, True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{False, True, False},
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->{False, True, False},
 RowSpacings->0.4},
 CellTags->"S5.37.1"],

Cell[TextData[{
 "Ways to specify a data point in a list of points for ",
 StyleBox["MultipleListPlot", "MR"],
 ". "
}], "Caption",
 CellTags->"S5.37.1"],

Cell[TextData[{
 "There are several ways to specify the points in the data sets. The most \
basic involve only the locations of the points. If a point is given as a \
single number, the value is treated as a ",
 Cell[BoxData[
  FormBox[
   StyleBox["y",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " value, and the ",
 Cell[BoxData[
  FormBox[
   StyleBox["x",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " value is determined by the position of the point in the list of data. If \
given as a pair ",
 StyleBox["{", "MR"],
 StyleBox["x", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["y", "TI"],
 StyleBox["}", "MR"],
 ", the point is placed at the ",
 StyleBox["{", "MR"],
 StyleBox["x", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["y", "TI"],
 StyleBox["}", "MR"],
 " coordinates. Each point can be grouped with an error specification, given \
as an ",
 StyleBox["ErrorBar", "MR"],
 " object. An ",
 StyleBox["ErrorBar", "MR"],
 " object can accept a specification of error in the ",
 Cell[BoxData[
  FormBox[
   StyleBox["y",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " variable or in both ",
 Cell[BoxData[
  FormBox[
   StyleBox["x",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox["y",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". An error given as a single value indicates the same error in the positive \
and negative directions; a negative number paired with a positive number \
indicates a different error in each direction. "
}], "Text",
 CellTags->{"S5.37.1", "1.8"}],

Cell["\<\
This plots a single data set that has points with a variety of error \
specifications. \
\>", "MathCaption",
 CellTags->{"S5.37.1", "1.9"}],

Cell[CellGroupData[{

Cell["\<\
MultipleListPlot[
 {2,
  {1.5, 3.2},
  {2.5, ErrorBar[0.3]},
  {{4.4, 5.2}, ErrorBar[{-0.5, 0.3}]},
  {{5.5, 2.1}, ErrorBar[{-0.4, 0.3}, {-0.2, 0.5}]} },
 PlotRange -> All,
 Frame -> True]\
\>", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.37.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.174603 0.198413 -0.295937 0.163501 [
[.02381 -0.0125 -3 -9 ]
[.02381 -0.0125 3 0 ]
[.22222 -0.0125 -3 -9 ]
[.22222 -0.0125 3 0 ]
[.42063 -0.0125 -3 -9 ]
[.42063 -0.0125 3 0 ]
[.61905 -0.0125 -3 -9 ]
[.61905 -0.0125 3 0 ]
[.81746 -0.0125 -3 -9 ]
[.81746 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .03107 -6 -4.5 ]
[-0.0125 .03107 0 4.5 ]
[-0.0125 .11282 -18 -4.5 ]
[-0.0125 .11282 0 4.5 ]
[-0.0125 .19457 -6 -4.5 ]
[-0.0125 .19457 0 4.5 ]
[-0.0125 .27632 -18 -4.5 ]
[-0.0125 .27632 0 4.5 ]
[-0.0125 .35807 -6 -4.5 ]
[-0.0125 .35807 0 4.5 ]
[-0.0125 .43982 -18 -4.5 ]
[-0.0125 .43982 0 4.5 ]
[-0.0125 .52157 -6 -4.5 ]
[-0.0125 .52157 0 4.5 ]
[-0.0125 .60332 -18 -4.5 ]
[-0.0125 .60332 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 .61803 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 0 m
.02381 .00625 L
s
[(1)] .02381 -0.0125 0 1 Mshowa
.22222 0 m
.22222 .00625 L
s
[(2)] .22222 -0.0125 0 1 Mshowa
.42063 0 m
.42063 .00625 L
s
[(3)] .42063 -0.0125 0 1 Mshowa
.61905 0 m
.61905 .00625 L
s
[(4)] .61905 -0.0125 0 1 Mshowa
.81746 0 m
.81746 .00625 L
s
[(5)] .81746 -0.0125 0 1 Mshowa
.125 Mabswid
.06349 0 m
.06349 .00375 L
s
.10317 0 m
.10317 .00375 L
s
.14286 0 m
.14286 .00375 L
s
.18254 0 m
.18254 .00375 L
s
.2619 0 m
.2619 .00375 L
s
.30159 0 m
.30159 .00375 L
s
.34127 0 m
.34127 .00375 L
s
.38095 0 m
.38095 .00375 L
s
.46032 0 m
.46032 .00375 L
s
.5 0 m
.5 .00375 L
s
.53968 0 m
.53968 .00375 L
s
.57937 0 m
.57937 .00375 L
s
.65873 0 m
.65873 .00375 L
s
.69841 0 m
.69841 .00375 L
s
.7381 0 m
.7381 .00375 L
s
.77778 0 m
.77778 .00375 L
s
.85714 0 m
.85714 .00375 L
s
.89683 0 m
.89683 .00375 L
s
.93651 0 m
.93651 .00375 L
s
.97619 0 m
.97619 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .03107 m
.00625 .03107 L
s
[(2)] -0.0125 .03107 1 0 Mshowa
0 .11282 m
.00625 .11282 L
s
[(2.5)] -0.0125 .11282 1 0 Mshowa
0 .19457 m
.00625 .19457 L
s
[(3)] -0.0125 .19457 1 0 Mshowa
0 .27632 m
.00625 .27632 L
s
[(3.5)] -0.0125 .27632 1 0 Mshowa
0 .35807 m
.00625 .35807 L
s
[(4)] -0.0125 .35807 1 0 Mshowa
0 .43982 m
.00625 .43982 L
s
[(4.5)] -0.0125 .43982 1 0 Mshowa
0 .52157 m
.00625 .52157 L
s
[(5)] -0.0125 .52157 1 0 Mshowa
0 .60332 m
.00625 .60332 L
s
[(5.5)] -0.0125 .60332 1 0 Mshowa
.125 Mabswid
0 .04742 m
.00375 .04742 L
s
0 .06377 m
.00375 .06377 L
s
0 .08012 m
.00375 .08012 L
s
0 .09647 m
.00375 .09647 L
s
0 .12917 m
.00375 .12917 L
s
0 .14552 m
.00375 .14552 L
s
0 .16187 m
.00375 .16187 L
s
0 .17822 m
.00375 .17822 L
s
0 .21092 m
.00375 .21092 L
s
0 .22727 m
.00375 .22727 L
s
0 .24362 m
.00375 .24362 L
s
0 .25997 m
.00375 .25997 L
s
0 .29267 m
.00375 .29267 L
s
0 .30902 m
.00375 .30902 L
s
0 .32537 m
.00375 .32537 L
s
0 .34172 m
.00375 .34172 L
s
0 .37442 m
.00375 .37442 L
s
0 .39077 m
.00375 .39077 L
s
0 .40712 m
.00375 .40712 L
s
0 .42347 m
.00375 .42347 L
s
0 .45617 m
.00375 .45617 L
s
0 .47252 m
.00375 .47252 L
s
0 .48887 m
.00375 .48887 L
s
0 .50522 m
.00375 .50522 L
s
0 .53792 m
.00375 .53792 L
s
0 .55427 m
.00375 .55427 L
s
0 .57062 m
.00375 .57062 L
s
0 .58697 m
.00375 .58697 L
s
0 .01472 m
.00375 .01472 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
.02381 .61178 m
.02381 .61803 L
s
.22222 .61178 m
.22222 .61803 L
s
.42063 .61178 m
.42063 .61803 L
s
.61905 .61178 m
.61905 .61803 L
s
.81746 .61178 m
.81746 .61803 L
s
.125 Mabswid
.06349 .61428 m
.06349 .61803 L
s
.10317 .61428 m
.10317 .61803 L
s
.14286 .61428 m
.14286 .61803 L
s
.18254 .61428 m
.18254 .61803 L
s
.2619 .61428 m
.2619 .61803 L
s
.30159 .61428 m
.30159 .61803 L
s
.34127 .61428 m
.34127 .61803 L
s
.38095 .61428 m
.38095 .61803 L
s
.46032 .61428 m
.46032 .61803 L
s
.5 .61428 m
.5 .61803 L
s
.53968 .61428 m
.53968 .61803 L
s
.57937 .61428 m
.57937 .61803 L
s
.65873 .61428 m
.65873 .61803 L
s
.69841 .61428 m
.69841 .61803 L
s
.7381 .61428 m
.7381 .61803 L
s
.77778 .61428 m
.77778 .61803 L
s
.85714 .61428 m
.85714 .61803 L
s
.89683 .61428 m
.89683 .61803 L
s
.93651 .61428 m
.93651 .61803 L
s
.97619 .61428 m
.97619 .61803 L
s
.25 Mabswid
0 .61803 m
1 .61803 L
s
.99375 .03107 m
1 .03107 L
s
.99375 .11282 m
1 .11282 L
s
.99375 .19457 m
1 .19457 L
s
.99375 .27632 m
1 .27632 L
s
.99375 .35807 m
1 .35807 L
s
.99375 .43982 m
1 .43982 L
s
.99375 .52157 m
1 .52157 L
s
.99375 .60332 m
1 .60332 L
s
.125 Mabswid
.99625 .04742 m
1 .04742 L
s
.99625 .06377 m
1 .06377 L
s
.99625 .08012 m
1 .08012 L
s
.99625 .09647 m
1 .09647 L
s
.99625 .12917 m
1 .12917 L
s
.99625 .14552 m
1 .14552 L
s
.99625 .16187 m
1 .16187 L
s
.99625 .17822 m
1 .17822 L
s
.99625 .21092 m
1 .21092 L
s
.99625 .22727 m
1 .22727 L
s
.99625 .24362 m
1 .24362 L
s
.99625 .25997 m
1 .25997 L
s
.99625 .29267 m
1 .29267 L
s
.99625 .30902 m
1 .30902 L
s
.99625 .32537 m
1 .32537 L
s
.99625 .34172 m
1 .34172 L
s
.99625 .37442 m
1 .37442 L
s
.99625 .39077 m
1 .39077 L
s
.99625 .40712 m
1 .40712 L
s
.99625 .42347 m
1 .42347 L
s
.99625 .45617 m
1 .45617 L
s
.99625 .47252 m
1 .47252 L
s
.99625 .48887 m
1 .48887 L
s
.99625 .50522 m
1 .50522 L
s
.99625 .53792 m
1 .53792 L
s
.99625 .55427 m
1 .55427 L
s
.99625 .57062 m
1 .57062 L
s
.99625 .58697 m
1 .58697 L
s
.99625 .01472 m
1 .01472 L
s
.25 Mabswid
1 0 m
1 .61803 L
s
.001 w
.42063 .16187 m
.42063 .06377 L
s
.42063 .16187 1.5 0 Mabsadd m
.42063 .16187 -1.5 0 Mabsadd L s
.42063 .06377 1.5 0 Mabsadd m
.42063 .06377 -1.5 0 Mabsadd L s
.69841 .60332 m
.69841 .47252 L
s
.69841 .60332 1.5 0 Mabsadd m
.69841 .60332 -1.5 0 Mabsadd L s
.69841 .47252 1.5 0 Mabsadd m
.69841 .47252 -1.5 0 Mabsadd L s
.97619 .04742 m
.8373 .04742 L
s
.97619 .04742 0 1.5 Mabsadd m
.97619 .04742 0 -1.5 Mabsadd L s
.8373 .04742 0 1.5 Mabsadd m
.8373 .04742 0 -1.5 Mabsadd L s
.91667 .12917 m
.91667 .01472 L
s
.91667 .12917 1.5 0 Mabsadd m
.91667 .12917 -1.5 0 Mabsadd L s
.91667 .01472 1.5 0 Mabsadd m
.91667 .01472 -1.5 0 Mabsadd L s
.0001 w
.02381 .03107 -1.875 0 Mabsadd m
.02381 .03107 0 2.5 Mabsadd L
.02381 .03107 1.875 0 Mabsadd L
.02381 .03107 0 -2.5 Mabsadd L
.02381 .03107 -1.875 0 Mabsadd L closepath F
.12302 .22727 -1.875 0 Mabsadd m
.12302 .22727 0 2.5 Mabsadd L
.12302 .22727 1.875 0 Mabsadd L
.12302 .22727 0 -2.5 Mabsadd L
.12302 .22727 -1.875 0 Mabsadd L closepath F
.42063 .11282 -1.875 0 Mabsadd m
.42063 .11282 0 2.5 Mabsadd L
.42063 .11282 1.875 0 Mabsadd L
.42063 .11282 0 -2.5 Mabsadd L
.42063 .11282 -1.875 0 Mabsadd L closepath F
.69841 .55427 -1.875 0 Mabsadd m
.69841 .55427 0 2.5 Mabsadd L
.69841 .55427 1.875 0 Mabsadd L
.69841 .55427 0 -2.5 Mabsadd L
.69841 .55427 -1.875 0 Mabsadd L closepath F
.91667 .04742 -1.875 0 Mabsadd m
.91667 .04742 0 2.5 Mabsadd L
.91667 .04742 1.875 0 Mabsadd L
.91667 .04742 0 -2.5 Mabsadd L
.91667 .04742 -1.875 0 Mabsadd L closepath F
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.37.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S5.37.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["option name", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["default value", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox["",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["PlotJoined", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["False", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "whether to join points in the data sets; can be a list with one entry \
for each data set",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["PlotStyle", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Automatic", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "styles for the lines associated with the data sets",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["SymbolShape", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Automatic", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "shapes for the points in each data set",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["SymbolStyle", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Automatic", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "styles for the points in each data set",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["SymbolLabel", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["None", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "labels for the data points",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["PlotLegend", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Automatic", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "if given a list of expressions, draws a legend for the plot with each \
style labeled by an element of the list",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ErrorBarFunction", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Automatic", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "a function specifying how to draw error bars",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ZeroOffsets", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["None", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "offsets for data to be plotted",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
 GridBoxOptions->{RowLines->{True, False},
 RowSpacings->0.4},
 CellTags->"S5.37.1"],

Cell[TextData[{
 "Options for ",
 StyleBox["MultipleListPlot", "MR"],
 ". "
}], "Caption",
 CellTags->"S5.37.1"],

Cell[TextData[{
 "A variety of characteristics of the plot can be modified by use of options. \
",
 StyleBox["MultipleListPlot", "MR"],
 " accepts all the usual ",
 StyleBox["Graphics", "MR"],
 " and ",
 StyleBox["Legend", "MR"],
 " options, as well as the options listed in the preceding table. ",
 StyleBox["Legend", "MR"],
 " options are not employed unless ",
 StyleBox["PlotLegend", "MR"],
 " is set to a list of labels for the data sets. Most of the options listed \
in the preceding table, except ",
 StyleBox["ErrorBarFunction", "MR"],
 ", cyclically reuse the arguments if given in a list that is not as long as \
the number of data sets. The default symbol shapes and line styles provide \
for five data sets before cycling. "
}], "Text",
 CellTags->{"S5.37.1", "1.10"}],

Cell[TextData[{
 "The ",
 StyleBox["SymbolShape", "MR"],
 " option may be set to a list of functions. Each function in the list should \
accept one argument specifying the location of a data point and should return \
graphics primitives representing the data point. The ",
 StyleBox["MultipleListPlot", "MR"],
 " package includes some utilities to make generating these shapes easier, \
such as ",
 StyleBox["PlotSymbol", "MR"],
 ", ",
 StyleBox["MakeSymbol", "MR"],
 ", ",
 StyleBox["RegularPolygon", "MR"],
 ", and ",
 StyleBox["Stem", "MR"],
 ". ",
 StyleBox["SymbolShape", "MR"],
 " can also take ",
 StyleBox["None", "MR"],
 ", representing no drawn point (for instance, if only a line is desired), \
and ",
 StyleBox["Label", "MR"],
 ", where the symbol is a label specified individually for each point by the \
",
 StyleBox["SymbolLabel", "MR"],
 " option. "
}], "Text",
 CellTags->{"S5.37.1", "1.11"}],

Cell[TextData[{
 "This uses some options to ",
 StyleBox["MultipleListPlot", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.37.1", "1.12"}],

Cell[CellGroupData[{

Cell["\<\
MultipleListPlot[list1, list2,
  PlotStyle -> {GrayLevel[0], Dashing[{Dot, Dash}]},
  SymbolShape -> {PlotSymbol[Triangle], PlotSymbol[Box]},
  SymbolStyle -> {GrayLevel[0], GrayLevel[.5]}]\
\>", "Input",
 CellLabel->"In[7]:= ",
 CellTags->"S5.37.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.309017 0.294302 [
[.21429 .29652 -9 -9 ]
[.21429 .29652 9 0 ]
[.40476 .29652 -9 -9 ]
[.40476 .29652 9 0 ]
[.59524 .29652 -9 -9 ]
[.59524 .29652 9 0 ]
[.78571 .29652 -9 -9 ]
[.78571 .29652 9 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.01131 .01472 -12 -4.5 ]
[.01131 .01472 0 4.5 ]
[.01131 .16187 -24 -4.5 ]
[.01131 .16187 0 4.5 ]
[.01131 .45617 -18 -4.5 ]
[.01131 .45617 0 4.5 ]
[.01131 .60332 -6 -4.5 ]
[.01131 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .30902 m
.21429 .31527 L
s
[(0.2)] .21429 .29652 0 1 Mshowa
.40476 .30902 m
.40476 .31527 L
s
[(0.4)] .40476 .29652 0 1 Mshowa
.59524 .30902 m
.59524 .31527 L
s
[(0.6)] .59524 .29652 0 1 Mshowa
.78571 .30902 m
.78571 .31527 L
s
[(0.8)] .78571 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(1)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.07143 .30902 m
.07143 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.16667 .30902 m
.16667 .31277 L
s
.2619 .30902 m
.2619 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.35714 .30902 m
.35714 .31277 L
s
.45238 .30902 m
.45238 .31277 L
s
.5 .30902 m
.5 .31277 L
s
.54762 .30902 m
.54762 .31277 L
s
.64286 .30902 m
.64286 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.7381 .30902 m
.7381 .31277 L
s
.83333 .30902 m
.83333 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.92857 .30902 m
.92857 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.02381 .01472 m
.03006 .01472 L
s
[(-1)] .01131 .01472 1 0 Mshowa
.02381 .16187 m
.03006 .16187 L
s
[(-0.5)] .01131 .16187 1 0 Mshowa
.02381 .45617 m
.03006 .45617 L
s
[(0.5)] .01131 .45617 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(1)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .04415 m
.02756 .04415 L
s
.02381 .07358 m
.02756 .07358 L
s
.02381 .10301 m
.02756 .10301 L
s
.02381 .13244 m
.02756 .13244 L
s
.02381 .1913 m
.02756 .1913 L
s
.02381 .22073 m
.02756 .22073 L
s
.02381 .25016 m
.02756 .25016 L
s
.02381 .27959 m
.02756 .27959 L
s
.02381 .33845 m
.02756 .33845 L
s
.02381 .36788 m
.02756 .36788 L
s
.02381 .39731 m
.02756 .39731 L
s
.02381 .42674 m
.02756 .42674 L
s
.02381 .4856 m
.02756 .4856 L
s
.02381 .51503 m
.02756 .51503 L
s
.02381 .54446 m
.02756 .54446 L
s
.02381 .57389 m
.02756 .57389 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.0001 w
.02381 .30902 0 2.5 Mabsadd m
.02381 .30902 -2.165 -1.25 Mabsadd L
.02381 .30902 2.165 -1.25 Mabsadd L
.02381 .30902 0 2.5 Mabsadd L closepath F
.11905 .482 0 2.5 Mabsadd m
.11905 .482 -2.165 -1.25 Mabsadd L
.11905 .482 2.165 -1.25 Mabsadd L
.11905 .482 0 2.5 Mabsadd L closepath F
.21429 .58891 0 2.5 Mabsadd m
.21429 .58891 -2.165 -1.25 Mabsadd L
.21429 .58891 2.165 -1.25 Mabsadd L
.21429 .58891 0 2.5 Mabsadd L closepath F
.30952 .58891 0 2.5 Mabsadd m
.30952 .58891 -2.165 -1.25 Mabsadd L
.30952 .58891 2.165 -1.25 Mabsadd L
.30952 .58891 0 2.5 Mabsadd L closepath F
.40476 .482 0 2.5 Mabsadd m
.40476 .482 -2.165 -1.25 Mabsadd L
.40476 .482 2.165 -1.25 Mabsadd L
.40476 .482 0 2.5 Mabsadd L closepath F
.5 .30902 0 2.5 Mabsadd m
.5 .30902 -2.165 -1.25 Mabsadd L
.5 .30902 2.165 -1.25 Mabsadd L
.5 .30902 0 2.5 Mabsadd L closepath F
.59524 .13603 0 2.5 Mabsadd m
.59524 .13603 -2.165 -1.25 Mabsadd L
.59524 .13603 2.165 -1.25 Mabsadd L
.59524 .13603 0 2.5 Mabsadd L closepath F
.69048 .02912 0 2.5 Mabsadd m
.69048 .02912 -2.165 -1.25 Mabsadd L
.69048 .02912 2.165 -1.25 Mabsadd L
.69048 .02912 0 2.5 Mabsadd L closepath F
.78571 .02912 0 2.5 Mabsadd m
.78571 .02912 -2.165 -1.25 Mabsadd L
.78571 .02912 2.165 -1.25 Mabsadd L
.78571 .02912 0 2.5 Mabsadd L closepath F
.88095 .13603 0 2.5 Mabsadd m
.88095 .13603 -2.165 -1.25 Mabsadd L
.88095 .13603 2.165 -1.25 Mabsadd L
.88095 .13603 0 2.5 Mabsadd L closepath F
.97619 .30902 0 2.5 Mabsadd m
.97619 .30902 -2.165 -1.25 Mabsadd L
.97619 .30902 2.165 -1.25 Mabsadd L
.97619 .30902 0 2.5 Mabsadd L closepath F
.5 g
.02381 .60332 -2.5 2.5 Mabsadd m
.02381 .60332 2.5 2.5 Mabsadd L
.02381 .60332 2.5 -2.5 Mabsadd L
.02381 .60332 -2.5 -2.5 Mabsadd L
.02381 .60332 -2.5 2.5 Mabsadd L closepath F
.11905 .54711 -2.5 2.5 Mabsadd m
.11905 .54711 2.5 2.5 Mabsadd L
.11905 .54711 2.5 -2.5 Mabsadd L
.11905 .54711 -2.5 -2.5 Mabsadd L
.11905 .54711 -2.5 2.5 Mabsadd L closepath F
.21429 .39996 -2.5 2.5 Mabsadd m
.21429 .39996 2.5 2.5 Mabsadd L
.21429 .39996 2.5 -2.5 Mabsadd L
.21429 .39996 -2.5 -2.5 Mabsadd L
.21429 .39996 -2.5 2.5 Mabsadd L closepath F
.30952 .21807 -2.5 2.5 Mabsadd m
.30952 .21807 2.5 2.5 Mabsadd L
.30952 .21807 2.5 -2.5 Mabsadd L
.30952 .21807 -2.5 -2.5 Mabsadd L
.30952 .21807 -2.5 2.5 Mabsadd L closepath F
.40476 .07092 -2.5 2.5 Mabsadd m
.40476 .07092 2.5 2.5 Mabsadd L
.40476 .07092 2.5 -2.5 Mabsadd L
.40476 .07092 -2.5 -2.5 Mabsadd L
.40476 .07092 -2.5 2.5 Mabsadd L closepath F
.5 .01472 -2.5 2.5 Mabsadd m
.5 .01472 2.5 2.5 Mabsadd L
.5 .01472 2.5 -2.5 Mabsadd L
.5 .01472 -2.5 -2.5 Mabsadd L
.5 .01472 -2.5 2.5 Mabsadd L closepath F
.59524 .07092 -2.5 2.5 Mabsadd m
.59524 .07092 2.5 2.5 Mabsadd L
.59524 .07092 2.5 -2.5 Mabsadd L
.59524 .07092 -2.5 -2.5 Mabsadd L
.59524 .07092 -2.5 2.5 Mabsadd L closepath F
.69048 .21807 -2.5 2.5 Mabsadd m
.69048 .21807 2.5 2.5 Mabsadd L
.69048 .21807 2.5 -2.5 Mabsadd L
.69048 .21807 -2.5 -2.5 Mabsadd L
.69048 .21807 -2.5 2.5 Mabsadd L closepath F
.78571 .39996 -2.5 2.5 Mabsadd m
.78571 .39996 2.5 2.5 Mabsadd L
.78571 .39996 2.5 -2.5 Mabsadd L
.78571 .39996 -2.5 -2.5 Mabsadd L
.78571 .39996 -2.5 2.5 Mabsadd L closepath F
.88095 .54711 -2.5 2.5 Mabsadd m
.88095 .54711 2.5 2.5 Mabsadd L
.88095 .54711 2.5 -2.5 Mabsadd L
.88095 .54711 -2.5 -2.5 Mabsadd L
.88095 .54711 -2.5 2.5 Mabsadd L closepath F
.97619 .60332 -2.5 2.5 Mabsadd m
.97619 .60332 2.5 2.5 Mabsadd L
.97619 .60332 2.5 -2.5 Mabsadd L
.97619 .60332 -2.5 -2.5 Mabsadd L
.97619 .60332 -2.5 2.5 Mabsadd L closepath F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.37.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[7]= ",
 CellTags->"S5.37.1"]
}, Open  ]],

Cell[TextData[{
 "The ",
 StyleBox["SymbolShape", "MR"],
 " option can also be used for the production of stem plots as found in \
discrete signal processing. "
}], "MathCaption",
 CellTags->{"S5.37.1", "1.13"}],

Cell[CellGroupData[{

Cell["MultipleListPlot[list1, SymbolShape -> Stem]", "Input",
 CellLabel->"In[8]:= ",
 CellTags->"S5.37.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.309017 0.309447 [
[.21429 .29652 -9 -9 ]
[.21429 .29652 9 0 ]
[.40476 .29652 -9 -9 ]
[.40476 .29652 9 0 ]
[.59524 .29652 -9 -9 ]
[.59524 .29652 9 0 ]
[.78571 .29652 -9 -9 ]
[.78571 .29652 9 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.01131 .07693 -30 -4.5 ]
[.01131 .07693 0 4.5 ]
[.01131 .15429 -24 -4.5 ]
[.01131 .15429 0 4.5 ]
[.01131 .23166 -30 -4.5 ]
[.01131 .23166 0 4.5 ]
[.01131 .38638 -24 -4.5 ]
[.01131 .38638 0 4.5 ]
[.01131 .46374 -18 -4.5 ]
[.01131 .46374 0 4.5 ]
[.01131 .5411 -24 -4.5 ]
[.01131 .5411 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .30902 m
.21429 .31527 L
s
[(0.2)] .21429 .29652 0 1 Mshowa
.40476 .30902 m
.40476 .31527 L
s
[(0.4)] .40476 .29652 0 1 Mshowa
.59524 .30902 m
.59524 .31527 L
s
[(0.6)] .59524 .29652 0 1 Mshowa
.78571 .30902 m
.78571 .31527 L
s
[(0.8)] .78571 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(1)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.07143 .30902 m
.07143 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.16667 .30902 m
.16667 .31277 L
s
.2619 .30902 m
.2619 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.35714 .30902 m
.35714 .31277 L
s
.45238 .30902 m
.45238 .31277 L
s
.5 .30902 m
.5 .31277 L
s
.54762 .30902 m
.54762 .31277 L
s
.64286 .30902 m
.64286 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.7381 .30902 m
.7381 .31277 L
s
.83333 .30902 m
.83333 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.92857 .30902 m
.92857 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.02381 .07693 m
.03006 .07693 L
s
[(-0.75)] .01131 .07693 1 0 Mshowa
.02381 .15429 m
.03006 .15429 L
s
[(-0.5)] .01131 .15429 1 0 Mshowa
.02381 .23166 m
.03006 .23166 L
s
[(-0.25)] .01131 .23166 1 0 Mshowa
.02381 .38638 m
.03006 .38638 L
s
[(0.25)] .01131 .38638 1 0 Mshowa
.02381 .46374 m
.03006 .46374 L
s
[(0.5)] .01131 .46374 1 0 Mshowa
.02381 .5411 m
.03006 .5411 L
s
[(0.75)] .01131 .5411 1 0 Mshowa
.125 Mabswid
.02381 .01504 m
.02756 .01504 L
s
.02381 .03051 m
.02756 .03051 L
s
.02381 .04599 m
.02756 .04599 L
s
.02381 .06146 m
.02756 .06146 L
s
.02381 .0924 m
.02756 .0924 L
s
.02381 .10788 m
.02756 .10788 L
s
.02381 .12335 m
.02756 .12335 L
s
.02381 .13882 m
.02756 .13882 L
s
.02381 .16977 m
.02756 .16977 L
s
.02381 .18524 m
.02756 .18524 L
s
.02381 .20071 m
.02756 .20071 L
s
.02381 .21618 m
.02756 .21618 L
s
.02381 .24713 m
.02756 .24713 L
s
.02381 .2626 m
.02756 .2626 L
s
.02381 .27807 m
.02756 .27807 L
s
.02381 .29354 m
.02756 .29354 L
s
.02381 .32449 m
.02756 .32449 L
s
.02381 .33996 m
.02756 .33996 L
s
.02381 .35543 m
.02756 .35543 L
s
.02381 .37091 m
.02756 .37091 L
s
.02381 .40185 m
.02756 .40185 L
s
.02381 .41732 m
.02756 .41732 L
s
.02381 .4328 m
.02756 .4328 L
s
.02381 .44827 m
.02756 .44827 L
s
.02381 .47921 m
.02756 .47921 L
s
.02381 .49469 m
.02756 .49469 L
s
.02381 .51016 m
.02756 .51016 L
s
.02381 .52563 m
.02756 .52563 L
s
.02381 .55657 m
.02756 .55657 L
s
.02381 .57205 m
.02756 .57205 L
s
.02381 .58752 m
.02756 .58752 L
s
.02381 .60299 m
.02756 .60299 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.02 w
.02381 .30902 Mdot
.0001 w
.02381 .30902 m
.02381 .30902 L
s
.02 w
.11905 .49091 Mdot
.0001 w
.11905 .49091 m
.11905 .30902 L
s
.02 w
.21429 .60332 Mdot
.0001 w
.21429 .60332 m
.21429 .30902 L
s
.02 w
.30952 .60332 Mdot
.0001 w
.30952 .60332 m
.30952 .30902 L
s
.02 w
.40476 .49091 Mdot
.0001 w
.40476 .49091 m
.40476 .30902 L
s
.02 w
.5 .30902 Mdot
.0001 w
.5 .30902 m
.5 .30902 L
s
.02 w
.59524 .12713 Mdot
.0001 w
.59524 .12713 m
.59524 .30902 L
s
.02 w
.69048 .01472 Mdot
.0001 w
.69048 .01472 m
.69048 .30902 L
s
.02 w
.78571 .01472 Mdot
.0001 w
.78571 .01472 m
.78571 .30902 L
s
.02 w
.88095 .12713 Mdot
.0001 w
.88095 .12713 m
.88095 .30902 L
s
.02 w
.97619 .30902 Mdot
.0001 w
.97619 .30902 m
.97619 .30902 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.37.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[8]= ",
 CellTags->"S5.37.1"]
}, Open  ]],

Cell[TextData[{
 StyleBox["MultipleListPlot", "MR"],
 " can automatically generate a legend based on the styles for points and \
lines. The boxes in the legend are labeled by items from the ",
 StyleBox["PlotLegend", "MR"],
 " option. All of the standard options to the ",
 StyleBox["Legend", "MR"],
 " function (detailed in the chapter on the ",
 StyleBox["Graphics`Legend`", "MR"],
 " package) can be used, including ",
 StyleBox["LegendPosition", "MR"],
 ", ",
 StyleBox["LegendSize", "MR"],
 ", ",
 StyleBox["LegendShadow", "MR"],
 ", and others. "
}], "Text",
 CellTags->{"S5.37.1", "1.14"}],

Cell[TextData[{
 "This is a ",
 StyleBox["MultipleListPlot", "MR"],
 " with a legend. "
}], "MathCaption",
 CellTags->{"S5.37.1", "1.15"}],

Cell[CellGroupData[{

Cell["\<\
MultipleListPlot[list1, list2,
    PlotLegend -> {\"Sine\", \"Cosine\"},
    PlotJoined -> {False, True}
]\
\>", "Input",
 CellLabel->"In[9]:= ",
 CellTags->"S5.37.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .42623 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.352217 0.328407 0.213115 0.328407 [
[ 0 0 0 0 ]
[ 1 .42623 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
% Start of sub-graphic
p
0.0238095 0.0101483 0.680624 0.416082 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.309017 0.294302 [
[.21429 .29652 -9 -9 ]
[.21429 .29652 9 0 ]
[.40476 .29652 -9 -9 ]
[.40476 .29652 9 0 ]
[.59524 .29652 -9 -9 ]
[.59524 .29652 9 0 ]
[.78571 .29652 -9 -9 ]
[.78571 .29652 9 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.01131 .01472 -12 -4.5 ]
[.01131 .01472 0 4.5 ]
[.01131 .16187 -24 -4.5 ]
[.01131 .16187 0 4.5 ]
[.01131 .45617 -18 -4.5 ]
[.01131 .45617 0 4.5 ]
[.01131 .60332 -6 -4.5 ]
[.01131 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .30902 m
.21429 .31527 L
s
[(0.2)] .21429 .29652 0 1 Mshowa
.40476 .30902 m
.40476 .31527 L
s
[(0.4)] .40476 .29652 0 1 Mshowa
.59524 .30902 m
.59524 .31527 L
s
[(0.6)] .59524 .29652 0 1 Mshowa
.78571 .30902 m
.78571 .31527 L
s
[(0.8)] .78571 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(1)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.07143 .30902 m
.07143 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.16667 .30902 m
.16667 .31277 L
s
.2619 .30902 m
.2619 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.35714 .30902 m
.35714 .31277 L
s
.45238 .30902 m
.45238 .31277 L
s
.5 .30902 m
.5 .31277 L
s
.54762 .30902 m
.54762 .31277 L
s
.64286 .30902 m
.64286 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.7381 .30902 m
.7381 .31277 L
s
.83333 .30902 m
.83333 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.92857 .30902 m
.92857 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.02381 .01472 m
.03006 .01472 L
s
[(-1)] .01131 .01472 1 0 Mshowa
.02381 .16187 m
.03006 .16187 L
s
[(-0.5)] .01131 .16187 1 0 Mshowa
.02381 .45617 m
.03006 .45617 L
s
[(0.5)] .01131 .45617 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(1)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .04415 m
.02756 .04415 L
s
.02381 .07358 m
.02756 .07358 L
s
.02381 .10301 m
.02756 .10301 L
s
.02381 .13244 m
.02756 .13244 L
s
.02381 .1913 m
.02756 .1913 L
s
.02381 .22073 m
.02756 .22073 L
s
.02381 .25016 m
.02756 .25016 L
s
.02381 .27959 m
.02756 .27959 L
s
.02381 .33845 m
.02756 .33845 L
s
.02381 .36788 m
.02756 .36788 L
s
.02381 .39731 m
.02756 .39731 L
s
.02381 .42674 m
.02756 .42674 L
s
.02381 .4856 m
.02756 .4856 L
s
.02381 .51503 m
.02756 .51503 L
s
.02381 .54446 m
.02756 .54446 L
s
.02381 .57389 m
.02756 .57389 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.0001 w
.02381 .30902 -1.875 0 Mabsadd m
.02381 .30902 0 2.5 Mabsadd L
.02381 .30902 1.875 0 Mabsadd L
.02381 .30902 0 -2.5 Mabsadd L
.02381 .30902 -1.875 0 Mabsadd L closepath F
.11905 .482 -1.875 0 Mabsadd m
.11905 .482 0 2.5 Mabsadd L
.11905 .482 1.875 0 Mabsadd L
.11905 .482 0 -2.5 Mabsadd L
.11905 .482 -1.875 0 Mabsadd L closepath F
.21429 .58891 -1.875 0 Mabsadd m
.21429 .58891 0 2.5 Mabsadd L
.21429 .58891 1.875 0 Mabsadd L
.21429 .58891 0 -2.5 Mabsadd L
.21429 .58891 -1.875 0 Mabsadd L closepath F
.30952 .58891 -1.875 0 Mabsadd m
.30952 .58891 0 2.5 Mabsadd L
.30952 .58891 1.875 0 Mabsadd L
.30952 .58891 0 -2.5 Mabsadd L
.30952 .58891 -1.875 0 Mabsadd L closepath F
.40476 .482 -1.875 0 Mabsadd m
.40476 .482 0 2.5 Mabsadd L
.40476 .482 1.875 0 Mabsadd L
.40476 .482 0 -2.5 Mabsadd L
.40476 .482 -1.875 0 Mabsadd L closepath F
.5 .30902 -1.875 0 Mabsadd m
.5 .30902 0 2.5 Mabsadd L
.5 .30902 1.875 0 Mabsadd L
.5 .30902 0 -2.5 Mabsadd L
.5 .30902 -1.875 0 Mabsadd L closepath F
.59524 .13603 -1.875 0 Mabsadd m
.59524 .13603 0 2.5 Mabsadd L
.59524 .13603 1.875 0 Mabsadd L
.59524 .13603 0 -2.5 Mabsadd L
.59524 .13603 -1.875 0 Mabsadd L closepath F
.69048 .02912 -1.875 0 Mabsadd m
.69048 .02912 0 2.5 Mabsadd L
.69048 .02912 1.875 0 Mabsadd L
.69048 .02912 0 -2.5 Mabsadd L
.69048 .02912 -1.875 0 Mabsadd L closepath F
.78571 .02912 -1.875 0 Mabsadd m
.78571 .02912 0 2.5 Mabsadd L
.78571 .02912 1.875 0 Mabsadd L
.78571 .02912 0 -2.5 Mabsadd L
.78571 .02912 -1.875 0 Mabsadd L closepath F
.88095 .13603 -1.875 0 Mabsadd m
.88095 .13603 0 2.5 Mabsadd L
.88095 .13603 1.875 0 Mabsadd L
.88095 .13603 0 -2.5 Mabsadd L
.88095 .13603 -1.875 0 Mabsadd L closepath F
.97619 .30902 -1.875 0 Mabsadd m
.97619 .30902 0 2.5 Mabsadd L
.97619 .30902 1.875 0 Mabsadd L
.97619 .30902 0 -2.5 Mabsadd L
.97619 .30902 -1.875 0 Mabsadd L closepath F
.001 w
[ .5 3 ] 0 Mabsdash
.02381 .60332 m
.11905 .54711 L
.21429 .39996 L
.30952 .21807 L
.40476 .07092 L
.5 .01472 L
.59524 .07092 L
.69048 .21807 L
.78571 .39996 L
.88095 .54711 L
.97619 .60332 L
s
.0001 w
[ ] 0 setdash
.02381 .60332 0 2.5 Mabsadd m
.02381 .60332 -0.56518 .7779 Mabsadd L
.02381 .60332 -2.37764 .77254 Mabsadd L
.02381 .60332 -0.91448 -0.29713 Mabsadd L
.02381 .60332 -1.46946 -2.02254 Mabsadd L
.02381 .60332 0 -0.96154 Mabsadd L
.02381 .60332 1.46946 -2.02254 Mabsadd L
.02381 .60332 .91448 -0.29713 Mabsadd L
.02381 .60332 2.37764 .77254 Mabsadd L
.02381 .60332 .56518 .7779 Mabsadd L
.02381 .60332 0 2.5 Mabsadd L closepath F
.11905 .54711 0 2.5 Mabsadd m
.11905 .54711 -0.56518 .7779 Mabsadd L
.11905 .54711 -2.37764 .77254 Mabsadd L
.11905 .54711 -0.91448 -0.29713 Mabsadd L
.11905 .54711 -1.46946 -2.02254 Mabsadd L
.11905 .54711 0 -0.96154 Mabsadd L
.11905 .54711 1.46946 -2.02254 Mabsadd L
.11905 .54711 .91448 -0.29713 Mabsadd L
.11905 .54711 2.37764 .77254 Mabsadd L
.11905 .54711 .56518 .7779 Mabsadd L
.11905 .54711 0 2.5 Mabsadd L closepath F
.21429 .39996 0 2.5 Mabsadd m
.21429 .39996 -0.56518 .7779 Mabsadd L
.21429 .39996 -2.37764 .77254 Mabsadd L
.21429 .39996 -0.91448 -0.29713 Mabsadd L
.21429 .39996 -1.46946 -2.02254 Mabsadd L
.21429 .39996 0 -0.96154 Mabsadd L
.21429 .39996 1.46946 -2.02254 Mabsadd L
.21429 .39996 .91448 -0.29713 Mabsadd L
.21429 .39996 2.37764 .77254 Mabsadd L
.21429 .39996 .56518 .7779 Mabsadd L
.21429 .39996 0 2.5 Mabsadd L closepath F
.30952 .21807 0 2.5 Mabsadd m
.30952 .21807 -0.56518 .7779 Mabsadd L
.30952 .21807 -2.37764 .77254 Mabsadd L
.30952 .21807 -0.91448 -0.29713 Mabsadd L
.30952 .21807 -1.46946 -2.02254 Mabsadd L
.30952 .21807 0 -0.96154 Mabsadd L
.30952 .21807 1.46946 -2.02254 Mabsadd L
.30952 .21807 .91448 -0.29713 Mabsadd L
.30952 .21807 2.37764 .77254 Mabsadd L
.30952 .21807 .56518 .7779 Mabsadd L
.30952 .21807 0 2.5 Mabsadd L closepath F
.40476 .07092 0 2.5 Mabsadd m
.40476 .07092 -0.56518 .7779 Mabsadd L
.40476 .07092 -2.37764 .77254 Mabsadd L
.40476 .07092 -0.91448 -0.29713 Mabsadd L
.40476 .07092 -1.46946 -2.02254 Mabsadd L
.40476 .07092 0 -0.96154 Mabsadd L
.40476 .07092 1.46946 -2.02254 Mabsadd L
.40476 .07092 .91448 -0.29713 Mabsadd L
.40476 .07092 2.37764 .77254 Mabsadd L
.40476 .07092 .56518 .7779 Mabsadd L
.40476 .07092 0 2.5 Mabsadd L closepath F
.5 .01472 0 2.5 Mabsadd m
.5 .01472 -0.56518 .7779 Mabsadd L
.5 .01472 -2.37764 .77254 Mabsadd L
.5 .01472 -0.91448 -0.29713 Mabsadd L
.5 .01472 -1.46946 -2.02254 Mabsadd L
.5 .01472 0 -0.96154 Mabsadd L
.5 .01472 1.46946 -2.02254 Mabsadd L
.5 .01472 .91448 -0.29713 Mabsadd L
.5 .01472 2.37764 .77254 Mabsadd L
.5 .01472 .56518 .7779 Mabsadd L
.5 .01472 0 2.5 Mabsadd L closepath F
.59524 .07092 0 2.5 Mabsadd m
.59524 .07092 -0.56518 .7779 Mabsadd L
.59524 .07092 -2.37764 .77254 Mabsadd L
.59524 .07092 -0.91448 -0.29713 Mabsadd L
.59524 .07092 -1.46946 -2.02254 Mabsadd L
.59524 .07092 0 -0.96154 Mabsadd L
.59524 .07092 1.46946 -2.02254 Mabsadd L
.59524 .07092 .91448 -0.29713 Mabsadd L
.59524 .07092 2.37764 .77254 Mabsadd L
.59524 .07092 .56518 .7779 Mabsadd L
.59524 .07092 0 2.5 Mabsadd L closepath F
.69048 .21807 0 2.5 Mabsadd m
.69048 .21807 -0.56518 .7779 Mabsadd L
.69048 .21807 -2.37764 .77254 Mabsadd L
.69048 .21807 -0.91448 -0.29713 Mabsadd L
.69048 .21807 -1.46946 -2.02254 Mabsadd L
.69048 .21807 0 -0.96154 Mabsadd L
.69048 .21807 1.46946 -2.02254 Mabsadd L
.69048 .21807 .91448 -0.29713 Mabsadd L
.69048 .21807 2.37764 .77254 Mabsadd L
.69048 .21807 .56518 .7779 Mabsadd L
.69048 .21807 0 2.5 Mabsadd L closepath F
.78571 .39996 0 2.5 Mabsadd m
.78571 .39996 -0.56518 .7779 Mabsadd L
.78571 .39996 -2.37764 .77254 Mabsadd L
.78571 .39996 -0.91448 -0.29713 Mabsadd L
.78571 .39996 -1.46946 -2.02254 Mabsadd L
.78571 .39996 0 -0.96154 Mabsadd L
.78571 .39996 1.46946 -2.02254 Mabsadd L
.78571 .39996 .91448 -0.29713 Mabsadd L
.78571 .39996 2.37764 .77254 Mabsadd L
.78571 .39996 .56518 .7779 Mabsadd L
.78571 .39996 0 2.5 Mabsadd L closepath F
.88095 .54711 0 2.5 Mabsadd m
.88095 .54711 -0.56518 .7779 Mabsadd L
.88095 .54711 -2.37764 .77254 Mabsadd L
.88095 .54711 -0.91448 -0.29713 Mabsadd L
.88095 .54711 -1.46946 -2.02254 Mabsadd L
.88095 .54711 0 -0.96154 Mabsadd L
.88095 .54711 1.46946 -2.02254 Mabsadd L
.88095 .54711 .91448 -0.29713 Mabsadd L
.88095 .54711 2.37764 .77254 Mabsadd L
.88095 .54711 .56518 .7779 Mabsadd L
.88095 .54711 0 2.5 Mabsadd L closepath F
.97619 .60332 0 2.5 Mabsadd m
.97619 .60332 -0.56518 .7779 Mabsadd L
.97619 .60332 -2.37764 .77254 Mabsadd L
.97619 .60332 -0.91448 -0.29713 Mabsadd L
.97619 .60332 -1.46946 -2.02254 Mabsadd L
.97619 .60332 0 -0.96154 Mabsadd L
.97619 .60332 1.46946 -2.02254 Mabsadd L
.97619 .60332 .91448 -0.29713 Mabsadd L
.97619 .60332 2.37764 .77254 Mabsadd L
.97619 .60332 .56518 .7779 Mabsadd L
.97619 .60332 0 2.5 Mabsadd L closepath F
MathSubEnd
P
% End of sub-graphic
0 g
.71346 .08175 m
.71346 .2788 L
.97619 .2788 L
.97619 .08175 L
F
1 g
.71346 .08175 m
.71346 .2788 L
.97619 .2788 L
.97619 .08175 L
F
0 g
.001 w
[ ] 0 setdash
.71346 .08175 m
.97619 .08175 L
.97619 .2788 L
.71346 .2788 L
.71346 .08175 L
s
% Start of sub-graphic
p
0.713465 0.0817523 0.97619 0.278797 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0297619 0.297619 0.0297619 0.297619 [
[ 0 0 0 0 ]
[ 1 .75 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .75 L
0 .75 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0535714 0.0535714 0.35119 0.35119 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.00468 w
[ .5 3 ] 0 Mabsdash
0 .5 m
1 .5 L
s
.00047 w
[ ] 0 setdash
.5 .5 0 2.5 Mabsadd m
.5 .5 -0.56518 .7779 Mabsadd L
.5 .5 -2.37764 .77254 Mabsadd L
.5 .5 -0.91448 -0.29713 Mabsadd L
.5 .5 -1.46946 -2.02254 Mabsadd L
.5 .5 0 -0.96154 Mabsadd L
.5 .5 1.46946 -2.02254 Mabsadd L
.5 .5 .91448 -0.29713 Mabsadd L
.5 .5 2.37764 .77254 Mabsadd L
.5 .5 .56518 .7779 Mabsadd L
.5 .5 0 2.5 Mabsadd L closepath F
MathSubEnd
P
% End of sub-graphic
0 g
gsave
.38988 .20238 -61 -9.0625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18.125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Cosine) show
99.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% Start of sub-graphic
p
0.0535714 0.39881 0.35119 0.696429 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.00047 w
[ ] 0 setdash
.5 .5 -1.875 0 Mabsadd m
.5 .5 0 2.5 Mabsadd L
.5 .5 1.875 0 Mabsadd L
.5 .5 0 -2.5 Mabsadd L
.5 .5 -1.875 0 Mabsadd L closepath F
MathSubEnd
P
% End of sub-graphic
0 g
gsave
.38988 .54762 -61 -9.0625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18.125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Sine) show
87.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
MathSubEnd
P
% End of sub-graphic
0 0 m
1 0 L
1 .42623 L
0 .42623 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.37.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[9]= ",
 CellTags->"S5.37.1"]
}, Open  ]],

Cell["\<\
Points can be labeled in a variety of ways. Labels can be placed by each \
point, or in place of the plotting symbol. Labels can be automatically \
generated, numbering the data set and the position in that data set. A user\
\[Hyphen]specified function can also be used to automatically generate labels \
based on the position of the point in the data set. \
\>", "Text",
 CellTags->{"S5.37.1", "1.16"}],

Cell["\<\
Here is an example of labeling data points and using labels for symbols. \
\>", "MathCaption",
 CellTags->{"S5.37.1", "1.17"}],

Cell[CellGroupData[{

Cell["\<\
MultipleListPlot[list1, list2,
    SymbolShape ->
  {PlotSymbol[Star, Filled -> False], Label},
    SymbolLabel ->
  {Automatic, {\"a\", \"b\", \"c\", \"d\", \"e\"}},
    Frame -> True,
 PlotRange -> All
]\
\>", "Input",
 CellLabel->"In[10]:= ",
 CellTags->"S5.37.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.309017 0.294302 [
[.02381 -0.0125 -3 -9 ]
[.02381 -0.0125 3 0 ]
[.21429 -0.0125 -9 -9 ]
[.21429 -0.0125 9 0 ]
[.40476 -0.0125 -9 -9 ]
[.40476 -0.0125 9 0 ]
[.59524 -0.0125 -9 -9 ]
[.59524 -0.0125 9 0 ]
[.78571 -0.0125 -9 -9 ]
[.78571 -0.0125 9 0 ]
[.97619 -0.0125 -3 -9 ]
[.97619 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01472 -12 -4.5 ]
[-0.0125 .01472 0 4.5 ]
[-0.0125 .16187 -24 -4.5 ]
[-0.0125 .16187 0 4.5 ]
[-0.0125 .30902 -6 -4.5 ]
[-0.0125 .30902 0 4.5 ]
[-0.0125 .45617 -18 -4.5 ]
[-0.0125 .45617 0 4.5 ]
[-0.0125 .60332 -6 -4.5 ]
[-0.0125 .60332 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 .61803 .125 0 ]
[ 1 0 .125 0 ]
[.02381 .30902 5.5 3.43438 ]
[.02381 .30902 27.5 13.2469 ]
[.11905 .482 5.5 3.43438 ]
[.11905 .482 27.5 13.2469 ]
[.21429 .58891 5.5 3.43438 ]
[.21429 .58891 27.5 13.2469 ]
[.30952 .58891 5.5 3.43438 ]
[.30952 .58891 27.5 13.2469 ]
[.40476 .482 5.5 3.43438 ]
[.40476 .482 27.5 13.2469 ]
[.5 .30902 5.5 3.43438 ]
[.5 .30902 27.5 13.2469 ]
[.59524 .13603 5.5 3.43438 ]
[.59524 .13603 27.5 13.2469 ]
[.69048 .02912 5.5 3.43438 ]
[.69048 .02912 27.5 13.2469 ]
[.78571 .02912 5.5 3.43438 ]
[.78571 .02912 27.5 13.2469 ]
[.88095 .13603 7 3.43438 ]
[.88095 .13603 35 13.2469 ]
[.97619 .30902 7 3.43438 ]
[.97619 .30902 35 13.2469 ]
[.02381 .60332 -5 -4.90625 ]
[.02381 .60332 5 4.90625 ]
[.11905 .54711 -5 -4.90625 ]
[.11905 .54711 5 4.90625 ]
[.21429 .39996 -5 -4.90625 ]
[.21429 .39996 5 4.90625 ]
[.30952 .21807 -5 -4.90625 ]
[.30952 .21807 5 4.90625 ]
[.40476 .07092 -5 -4.90625 ]
[.40476 .07092 5 4.90625 ]
[.5 .01472 -5 -4.90625 ]
[.5 .01472 5 4.90625 ]
[.59524 .07092 -5 -4.90625 ]
[.59524 .07092 5 4.90625 ]
[.69048 .21807 -5 -4.90625 ]
[.69048 .21807 5 4.90625 ]
[.78571 .39996 -5 -4.90625 ]
[.78571 .39996 5 4.90625 ]
[.88095 .54711 -5 -4.90625 ]
[.88095 .54711 5 4.90625 ]
[.97619 .60332 -5 -4.90625 ]
[.97619 .60332 5 4.90625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 0 m
.02381 .00625 L
s
[(0)] .02381 -0.0125 0 1 Mshowa
.21429 0 m
.21429 .00625 L
s
[(0.2)] .21429 -0.0125 0 1 Mshowa
.40476 0 m
.40476 .00625 L
s
[(0.4)] .40476 -0.0125 0 1 Mshowa
.59524 0 m
.59524 .00625 L
s
[(0.6)] .59524 -0.0125 0 1 Mshowa
.78571 0 m
.78571 .00625 L
s
[(0.8)] .78571 -0.0125 0 1 Mshowa
.97619 0 m
.97619 .00625 L
s
[(1)] .97619 -0.0125 0 1 Mshowa
.125 Mabswid
.07143 0 m
.07143 .00375 L
s
.11905 0 m
.11905 .00375 L
s
.16667 0 m
.16667 .00375 L
s
.2619 0 m
.2619 .00375 L
s
.30952 0 m
.30952 .00375 L
s
.35714 0 m
.35714 .00375 L
s
.45238 0 m
.45238 .00375 L
s
.5 0 m
.5 .00375 L
s
.54762 0 m
.54762 .00375 L
s
.64286 0 m
.64286 .00375 L
s
.69048 0 m
.69048 .00375 L
s
.7381 0 m
.7381 .00375 L
s
.83333 0 m
.83333 .00375 L
s
.88095 0 m
.88095 .00375 L
s
.92857 0 m
.92857 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01472 m
.00625 .01472 L
s
[(-1)] -0.0125 .01472 1 0 Mshowa
0 .16187 m
.00625 .16187 L
s
[(-0.5)] -0.0125 .16187 1 0 Mshowa
0 .30902 m
.00625 .30902 L
s
[(0)] -0.0125 .30902 1 0 Mshowa
0 .45617 m
.00625 .45617 L
s
[(0.5)] -0.0125 .45617 1 0 Mshowa
0 .60332 m
.00625 .60332 L
s
[(1)] -0.0125 .60332 1 0 Mshowa
.125 Mabswid
0 .04415 m
.00375 .04415 L
s
0 .07358 m
.00375 .07358 L
s
0 .10301 m
.00375 .10301 L
s
0 .13244 m
.00375 .13244 L
s
0 .1913 m
.00375 .1913 L
s
0 .22073 m
.00375 .22073 L
s
0 .25016 m
.00375 .25016 L
s
0 .27959 m
.00375 .27959 L
s
0 .33845 m
.00375 .33845 L
s
0 .36788 m
.00375 .36788 L
s
0 .39731 m
.00375 .39731 L
s
0 .42674 m
.00375 .42674 L
s
0 .4856 m
.00375 .4856 L
s
0 .51503 m
.00375 .51503 L
s
0 .54446 m
.00375 .54446 L
s
0 .57389 m
.00375 .57389 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
.02381 .61178 m
.02381 .61803 L
s
.21429 .61178 m
.21429 .61803 L
s
.40476 .61178 m
.40476 .61803 L
s
.59524 .61178 m
.59524 .61803 L
s
.78571 .61178 m
.78571 .61803 L
s
.97619 .61178 m
.97619 .61803 L
s
.125 Mabswid
.07143 .61428 m
.07143 .61803 L
s
.11905 .61428 m
.11905 .61803 L
s
.16667 .61428 m
.16667 .61803 L
s
.2619 .61428 m
.2619 .61803 L
s
.30952 .61428 m
.30952 .61803 L
s
.35714 .61428 m
.35714 .61803 L
s
.45238 .61428 m
.45238 .61803 L
s
.5 .61428 m
.5 .61803 L
s
.54762 .61428 m
.54762 .61803 L
s
.64286 .61428 m
.64286 .61803 L
s
.69048 .61428 m
.69048 .61803 L
s
.7381 .61428 m
.7381 .61803 L
s
.83333 .61428 m
.83333 .61803 L
s
.88095 .61428 m
.88095 .61803 L
s
.92857 .61428 m
.92857 .61803 L
s
.25 Mabswid
0 .61803 m
1 .61803 L
s
.99375 .01472 m
1 .01472 L
s
.99375 .16187 m
1 .16187 L
s
.99375 .30902 m
1 .30902 L
s
.99375 .45617 m
1 .45617 L
s
.99375 .60332 m
1 .60332 L
s
.125 Mabswid
.99625 .04415 m
1 .04415 L
s
.99625 .07358 m
1 .07358 L
s
.99625 .10301 m
1 .10301 L
s
.99625 .13244 m
1 .13244 L
s
.99625 .1913 m
1 .1913 L
s
.99625 .22073 m
1 .22073 L
s
.99625 .25016 m
1 .25016 L
s
.99625 .27959 m
1 .27959 L
s
.99625 .33845 m
1 .33845 L
s
.99625 .36788 m
1 .36788 L
s
.99625 .39731 m
1 .39731 L
s
.99625 .42674 m
1 .42674 L
s
.99625 .4856 m
1 .4856 L
s
.99625 .51503 m
1 .51503 L
s
.99625 .54446 m
1 .54446 L
s
.99625 .57389 m
1 .57389 L
s
.25 Mabswid
1 0 m
1 .61803 L
s
0 .30902 m
1 .30902 L
s
.0001 w
.02381 .30902 0 2.5 Mabsadd m
.02381 .30902 -0.56518 .7779 Mabsadd L
.02381 .30902 -2.37764 .77254 Mabsadd L
.02381 .30902 -0.91448 -0.29713 Mabsadd L
.02381 .30902 -1.46946 -2.02254 Mabsadd L
.02381 .30902 0 -0.96154 Mabsadd L
.02381 .30902 1.46946 -2.02254 Mabsadd L
.02381 .30902 .91448 -0.29713 Mabsadd L
.02381 .30902 2.37764 .77254 Mabsadd L
.02381 .30902 .56518 .7779 Mabsadd L
.02381 .30902 0 2.5 Mabsadd L s
gsave
.02381 .30902 -55.5 -0.56563 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
69.000 11.250 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
75.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
81.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.11905 .482 0 2.5 Mabsadd m
.11905 .482 -0.56518 .7779 Mabsadd L
.11905 .482 -2.37764 .77254 Mabsadd L
.11905 .482 -0.91448 -0.29713 Mabsadd L
.11905 .482 -1.46946 -2.02254 Mabsadd L
.11905 .482 0 -0.96154 Mabsadd L
.11905 .482 1.46946 -2.02254 Mabsadd L
.11905 .482 .91448 -0.29713 Mabsadd L
.11905 .482 2.37764 .77254 Mabsadd L
.11905 .482 .56518 .7779 Mabsadd L
.11905 .482 0 2.5 Mabsadd L s
gsave
.11905 .482 -55.5 -0.56563 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
69.000 11.250 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
75.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
81.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.21429 .58891 0 2.5 Mabsadd m
.21429 .58891 -0.56518 .7779 Mabsadd L
.21429 .58891 -2.37764 .77254 Mabsadd L
.21429 .58891 -0.91448 -0.29713 Mabsadd L
.21429 .58891 -1.46946 -2.02254 Mabsadd L
.21429 .58891 0 -0.96154 Mabsadd L
.21429 .58891 1.46946 -2.02254 Mabsadd L
.21429 .58891 .91448 -0.29713 Mabsadd L
.21429 .58891 2.37764 .77254 Mabsadd L
.21429 .58891 .56518 .7779 Mabsadd L
.21429 .58891 0 2.5 Mabsadd L s
gsave
.21429 .58891 -55.5 -0.56563 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
69.000 11.250 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
75.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3) show
81.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.30952 .58891 0 2.5 Mabsadd m
.30952 .58891 -0.56518 .7779 Mabsadd L
.30952 .58891 -2.37764 .77254 Mabsadd L
.30952 .58891 -0.91448 -0.29713 Mabsadd L
.30952 .58891 -1.46946 -2.02254 Mabsadd L
.30952 .58891 0 -0.96154 Mabsadd L
.30952 .58891 1.46946 -2.02254 Mabsadd L
.30952 .58891 .91448 -0.29713 Mabsadd L
.30952 .58891 2.37764 .77254 Mabsadd L
.30952 .58891 .56518 .7779 Mabsadd L
.30952 .58891 0 2.5 Mabsadd L s
gsave
.30952 .58891 -55.5 -0.56563 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
69.000 11.250 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
75.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(4) show
81.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.40476 .482 0 2.5 Mabsadd m
.40476 .482 -0.56518 .7779 Mabsadd L
.40476 .482 -2.37764 .77254 Mabsadd L
.40476 .482 -0.91448 -0.29713 Mabsadd L
.40476 .482 -1.46946 -2.02254 Mabsadd L
.40476 .482 0 -0.96154 Mabsadd L
.40476 .482 1.46946 -2.02254 Mabsadd L
.40476 .482 .91448 -0.29713 Mabsadd L
.40476 .482 2.37764 .77254 Mabsadd L
.40476 .482 .56518 .7779 Mabsadd L
.40476 .482 0 2.5 Mabsadd L s
gsave
.40476 .482 -55.5 -0.56563 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
69.000 11.250 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
75.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(5) show
81.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 .30902 0 2.5 Mabsadd m
.5 .30902 -0.56518 .7779 Mabsadd L
.5 .30902 -2.37764 .77254 Mabsadd L
.5 .30902 -0.91448 -0.29713 Mabsadd L
.5 .30902 -1.46946 -2.02254 Mabsadd L
.5 .30902 0 -0.96154 Mabsadd L
.5 .30902 1.46946 -2.02254 Mabsadd L
.5 .30902 .91448 -0.29713 Mabsadd L
.5 .30902 2.37764 .77254 Mabsadd L
.5 .30902 .56518 .7779 Mabsadd L
.5 .30902 0 2.5 Mabsadd L s
gsave
.5 .30902 -55.5 -0.56563 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
69.000 11.250 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
75.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(6) show
81.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.59524 .13603 0 2.5 Mabsadd m
.59524 .13603 -0.56518 .7779 Mabsadd L
.59524 .13603 -2.37764 .77254 Mabsadd L
.59524 .13603 -0.91448 -0.29713 Mabsadd L
.59524 .13603 -1.46946 -2.02254 Mabsadd L
.59524 .13603 0 -0.96154 Mabsadd L
.59524 .13603 1.46946 -2.02254 Mabsadd L
.59524 .13603 .91448 -0.29713 Mabsadd L
.59524 .13603 2.37764 .77254 Mabsadd L
.59524 .13603 .56518 .7779 Mabsadd L
.59524 .13603 0 2.5 Mabsadd L s
gsave
.59524 .13603 -55.5 -0.56563 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
69.000 11.250 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
75.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(7) show
81.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.69048 .02912 0 2.5 Mabsadd m
.69048 .02912 -0.56518 .7779 Mabsadd L
.69048 .02912 -2.37764 .77254 Mabsadd L
.69048 .02912 -0.91448 -0.29713 Mabsadd L
.69048 .02912 -1.46946 -2.02254 Mabsadd L
.69048 .02912 0 -0.96154 Mabsadd L
.69048 .02912 1.46946 -2.02254 Mabsadd L
.69048 .02912 .91448 -0.29713 Mabsadd L
.69048 .02912 2.37764 .77254 Mabsadd L
.69048 .02912 .56518 .7779 Mabsadd L
.69048 .02912 0 2.5 Mabsadd L s
gsave
.69048 .02912 -55.5 -0.56563 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
69.000 11.250 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
75.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(8) show
81.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.78571 .02912 0 2.5 Mabsadd m
.78571 .02912 -0.56518 .7779 Mabsadd L
.78571 .02912 -2.37764 .77254 Mabsadd L
.78571 .02912 -0.91448 -0.29713 Mabsadd L
.78571 .02912 -1.46946 -2.02254 Mabsadd L
.78571 .02912 0 -0.96154 Mabsadd L
.78571 .02912 1.46946 -2.02254 Mabsadd L
.78571 .02912 .91448 -0.29713 Mabsadd L
.78571 .02912 2.37764 .77254 Mabsadd L
.78571 .02912 .56518 .7779 Mabsadd L
.78571 .02912 0 2.5 Mabsadd L s
gsave
.78571 .02912 -55.5 -0.56563 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
69.000 11.250 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
75.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(9) show
81.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.88095 .13603 0 2.5 Mabsadd m
.88095 .13603 -0.56518 .7779 Mabsadd L
.88095 .13603 -2.37764 .77254 Mabsadd L
.88095 .13603 -0.91448 -0.29713 Mabsadd L
.88095 .13603 -1.46946 -2.02254 Mabsadd L
.88095 .13603 0 -0.96154 Mabsadd L
.88095 .13603 1.46946 -2.02254 Mabsadd L
.88095 .13603 .91448 -0.29713 Mabsadd L
.88095 .13603 2.37764 .77254 Mabsadd L
.88095 .13603 .56518 .7779 Mabsadd L
.88095 .13603 0 2.5 Mabsadd L s
gsave
.88095 .13603 -54 -0.56563 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
69.000 11.250 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
75.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(10) show
87.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.97619 .30902 0 2.5 Mabsadd m
.97619 .30902 -0.56518 .7779 Mabsadd L
.97619 .30902 -2.37764 .77254 Mabsadd L
.97619 .30902 -0.91448 -0.29713 Mabsadd L
.97619 .30902 -1.46946 -2.02254 Mabsadd L
.97619 .30902 0 -0.96154 Mabsadd L
.97619 .30902 1.46946 -2.02254 Mabsadd L
.97619 .30902 .91448 -0.29713 Mabsadd L
.97619 .30902 2.37764 .77254 Mabsadd L
.97619 .30902 .56518 .7779 Mabsadd L
.97619 .30902 0 2.5 Mabsadd L s
gsave
.97619 .30902 -54 -0.56563 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
69.000 11.250 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
75.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(11) show
87.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.02381 .60332 -66 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a) show
69.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.11905 .54711 -66 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(b) show
69.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.21429 .39996 -66 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(c) show
69.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.30952 .21807 -66 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(d) show
69.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.40476 .07092 -66 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(e) show
69.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.5 .01472 -66 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a) show
69.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.59524 .07092 -66 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(b) show
69.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.69048 .21807 -66 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(c) show
69.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.78571 .39996 -66 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(d) show
69.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.88095 .54711 -66 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(e) show
69.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.97619 .60332 -66 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a) show
69.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.37.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[10]= ",
 CellTags->"S5.37.1"]
}, Open  ]],

Cell[TextData[{
 "The ",
 StyleBox["ErrorBarFunction", "MR"],
 " option can be employed to draw the errors in a different fashion than the \
standard error bars. For instance, common alternatives are to draw error bars \
without serifs, or draw the area of the error in a rectangle or ellipse. The \
user function should take two arguments, where the first is the data point, \
and the second is an ",
 StyleBox["ErrorBar", "MR"],
 " object. The point and error bar will always be completely specified, with \
the point as ",
 StyleBox["{", "MR"],
 StyleBox["x", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["y", "TI"],
 StyleBox["}", "MR"],
 " and the error bar as ",
 StyleBox["ErrorBar[", "MR"],
 StyleBox["xerr", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["yerr", "TI"],
 StyleBox["]", "MR"],
 ", no matter what the input form of the data point. "
}], "Text",
 CellTags->{"S5.37.1", "1.18"}],

Cell["\<\
This defines a sample function to use for drawing the errors. \
\>", "MathCaption",
 CellTags->{"S5.37.1", "1.19"}],

Cell["\<\
mybarfunc[pt_, ErrorBar[xerr_, yerr_]] :=
   {GrayLevel[0.5],
   Disk[pt, {Max[Abs[xerr]], Max[Abs[yerr]]}]}\
\>", "Input",
 CellLabel->"In[11]:= ",
 CellTags->"S5.37.1"],

Cell["\<\
This plots the error bars as ellipses as defined by the given function. \
\>", "MathCaption",
 CellTags->{"S5.37.1", "1.20"}],

Cell[CellGroupData[{

Cell["\<\
MultipleListPlot[
  {{{1, 2},     ErrorBar[0.2, 0.4]},
   {{1.5, 3.2}, ErrorBar[0.4, 0.2]},
   {{3, 2.5},   ErrorBar[0.3, 0.1]},
   {{4.4, 5.2}, ErrorBar[.2, {-0.5, 0.3}]},
   {{5.5, 2.1}, ErrorBar[{-0.4, 0.3}, {-0.2, 0.5}]} },
ErrorBarFunction -> mybarfunc]\
\>", "Input",
 CellLabel->"In[12]:= ",
 CellTags->"S5.37.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.161421 -0.214984 0.143562 [
[.18523 .05964 -3 -9 ]
[.18523 .05964 3 0 ]
[.34665 .05964 -3 -9 ]
[.34665 .05964 3 0 ]
[.50807 .05964 -3 -9 ]
[.50807 .05964 3 0 ]
[.66949 .05964 -3 -9 ]
[.66949 .05964 3 0 ]
[.83091 .05964 -3 -9 ]
[.83091 .05964 3 0 ]
[.99233 .05964 -3 -9 ]
[.99233 .05964 3 0 ]
[.01131 .2157 -6 -4.5 ]
[.01131 .2157 0 4.5 ]
[.01131 .35926 -6 -4.5 ]
[.01131 .35926 0 4.5 ]
[.01131 .50283 -6 -4.5 ]
[.01131 .50283 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.18523 .07214 m
.18523 .07839 L
s
[(1)] .18523 .05964 0 1 Mshowa
.34665 .07214 m
.34665 .07839 L
s
[(2)] .34665 .05964 0 1 Mshowa
.50807 .07214 m
.50807 .07839 L
s
[(3)] .50807 .05964 0 1 Mshowa
.66949 .07214 m
.66949 .07839 L
s
[(4)] .66949 .05964 0 1 Mshowa
.83091 .07214 m
.83091 .07839 L
s
[(5)] .83091 .05964 0 1 Mshowa
.99233 .07214 m
.99233 .07839 L
s
[(6)] .99233 .05964 0 1 Mshowa
.125 Mabswid
.05609 .07214 m
.05609 .07589 L
s
.08838 .07214 m
.08838 .07589 L
s
.12066 .07214 m
.12066 .07589 L
s
.15295 .07214 m
.15295 .07589 L
s
.21751 .07214 m
.21751 .07589 L
s
.2498 .07214 m
.2498 .07589 L
s
.28208 .07214 m
.28208 .07589 L
s
.31437 .07214 m
.31437 .07589 L
s
.37893 .07214 m
.37893 .07589 L
s
.41122 .07214 m
.41122 .07589 L
s
.4435 .07214 m
.4435 .07589 L
s
.47579 .07214 m
.47579 .07589 L
s
.54036 .07214 m
.54036 .07589 L
s
.57264 .07214 m
.57264 .07589 L
s
.60492 .07214 m
.60492 .07589 L
s
.63721 .07214 m
.63721 .07589 L
s
.70178 .07214 m
.70178 .07589 L
s
.73406 .07214 m
.73406 .07589 L
s
.76634 .07214 m
.76634 .07589 L
s
.79863 .07214 m
.79863 .07589 L
s
.8632 .07214 m
.8632 .07589 L
s
.89548 .07214 m
.89548 .07589 L
s
.92776 .07214 m
.92776 .07589 L
s
.96005 .07214 m
.96005 .07589 L
s
.25 Mabswid
0 .07214 m
1 .07214 L
s
.02381 .2157 m
.03006 .2157 L
s
[(3)] .01131 .2157 1 0 Mshowa
.02381 .35926 m
.03006 .35926 L
s
[(4)] .01131 .35926 1 0 Mshowa
.02381 .50283 m
.03006 .50283 L
s
[(5)] .01131 .50283 1 0 Mshowa
.125 Mabswid
.02381 .10085 m
.02756 .10085 L
s
.02381 .12956 m
.02756 .12956 L
s
.02381 .15828 m
.02756 .15828 L
s
.02381 .18699 m
.02756 .18699 L
s
.02381 .24441 m
.02756 .24441 L
s
.02381 .27313 m
.02756 .27313 L
s
.02381 .30184 m
.02756 .30184 L
s
.02381 .33055 m
.02756 .33055 L
s
.02381 .38798 m
.02756 .38798 L
s
.02381 .41669 m
.02756 .41669 L
s
.02381 .4454 m
.02756 .4454 L
s
.02381 .47411 m
.02756 .47411 L
s
.02381 .04343 m
.02756 .04343 L
s
.02381 .01472 m
.02756 .01472 L
s
.02381 .53154 m
.02756 .53154 L
s
.02381 .56025 m
.02756 .56025 L
s
.02381 .58896 m
.02756 .58896 L
s
.02381 .61768 m
.02756 .61768 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 g
.18523 .07214 m
matrix currentmatrix
0.0322841 0.0574248 scale
5.7375 1.25625 1 0 365.73 arc
setmatrix F
.26594 .24441 m
matrix currentmatrix
0.0645682 0.0287124 scale
4.11875 8.51236 1 0 365.73 arc
setmatrix F
.50807 .14392 m
matrix currentmatrix
0.0484262 0.0143562 scale
10.4916 10.0249 1 0 365.73 arc
setmatrix F
.73406 .53154 m
matrix currentmatrix
0.0322841 0.071781 scale
22.7375 7.40503 1 0 365.73 arc
setmatrix F
.91162 .0865 m
matrix currentmatrix
0.0645682 0.071781 scale
14.1187 1.20506 1 0 365.73 arc
setmatrix F
0 g
.0001 w
.18523 .07214 -1.875 0 Mabsadd m
.18523 .07214 0 2.5 Mabsadd L
.18523 .07214 1.875 0 Mabsadd L
.18523 .07214 0 -2.5 Mabsadd L
.18523 .07214 -1.875 0 Mabsadd L closepath F
.26594 .24441 -1.875 0 Mabsadd m
.26594 .24441 0 2.5 Mabsadd L
.26594 .24441 1.875 0 Mabsadd L
.26594 .24441 0 -2.5 Mabsadd L
.26594 .24441 -1.875 0 Mabsadd L closepath F
.50807 .14392 -1.875 0 Mabsadd m
.50807 .14392 0 2.5 Mabsadd L
.50807 .14392 1.875 0 Mabsadd L
.50807 .14392 0 -2.5 Mabsadd L
.50807 .14392 -1.875 0 Mabsadd L closepath F
.73406 .53154 -1.875 0 Mabsadd m
.73406 .53154 0 2.5 Mabsadd L
.73406 .53154 1.875 0 Mabsadd L
.73406 .53154 0 -2.5 Mabsadd L
.73406 .53154 -1.875 0 Mabsadd L closepath F
.91162 .0865 -1.875 0 Mabsadd m
.91162 .0865 0 2.5 Mabsadd L
.91162 .0865 1.875 0 Mabsadd L
.91162 .0865 0 -2.5 Mabsadd L
.91162 .0865 -1.875 0 Mabsadd L closepath F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.37.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[12]= ",
 CellTags->"S5.37.1"]
}, Open  ]],

Cell[TextData[{
 "The ",
 StyleBox["ZeroOffsets", "MR"],
 " option can be used to perform a translation of the data before plotting \
it. This is particularly useful when plotting a data set given as a simple \
list that has been truncated at the start, as in data sets reduced by \
smoothing. ",
 StyleBox["ZeroOffsets", "MR"],
 " accepts a list of offsets, which can be either single numbers indicating a \
horizontal offset, or ",
 StyleBox["{", "MR"],
 StyleBox["x", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["y", "TI"],
 StyleBox["}", "MR"],
 " pairs denoting a general translation. "
}], "Text",
 CellTags->{"S5.37.1", "1.21"}],

Cell["Load the data smoothing package. ", "MathCaption",
 CellTags->{"S5.37.1", "1.22"}],

Cell["<<Statistics`DataSmoothing`", "Input",
 CellLabel->"In[13]:= ",
 CellTags->"S5.37.1"],

Cell["Generate a data set and a smoothed version. ", "MathCaption",
 CellTags->{"S5.37.1", "1.23"}],

Cell["\<\
data = Table[Sin[x] + Random[Real, {-0.1, 0.1}],
             {x, 0., 2., .1}];
d1 = MovingAverage[data, 5];\
\>", "Input",
 CellLabel->"In[14]:= ",
 CellTags->"S5.37.1"],

Cell["\<\
Display the data sets with an offset to align the smoothed version with the \
original data. \
\>", "MathCaption",
 CellTags->{"S5.37.1", "1.24"}],

Cell[CellGroupData[{

Cell["\<\
MultipleListPlot[data, d1,
  PlotJoined -> {False, True},
  PlotStyle -> GrayLevel[0],
  ZeroOffsets -> {0, 2}
]\
\>", "Input",
 CellLabel->"In[15]:= ",
 CellTags->"S5.37.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0453515 0.0653889 0.524714 [
[.25057 .05289 -3 -9 ]
[.25057 .05289 3 0 ]
[.47732 .05289 -6 -9 ]
[.47732 .05289 6 0 ]
[.70408 .05289 -6 -9 ]
[.70408 .05289 6 0 ]
[.93084 .05289 -6 -9 ]
[.93084 .05289 6 0 ]
[.01131 .17033 -18 -4.5 ]
[.01131 .17033 0 4.5 ]
[.01131 .27527 -18 -4.5 ]
[.01131 .27527 0 4.5 ]
[.01131 .38022 -18 -4.5 ]
[.01131 .38022 0 4.5 ]
[.01131 .48516 -18 -4.5 ]
[.01131 .48516 0 4.5 ]
[.01131 .5901 -6 -4.5 ]
[.01131 .5901 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.25057 .06539 m
.25057 .07164 L
s
[(5)] .25057 .05289 0 1 Mshowa
.47732 .06539 m
.47732 .07164 L
s
[(10)] .47732 .05289 0 1 Mshowa
.70408 .06539 m
.70408 .07164 L
s
[(15)] .70408 .05289 0 1 Mshowa
.93084 .06539 m
.93084 .07164 L
s
[(20)] .93084 .05289 0 1 Mshowa
.125 Mabswid
.06916 .06539 m
.06916 .06914 L
s
.11451 .06539 m
.11451 .06914 L
s
.15986 .06539 m
.15986 .06914 L
s
.20522 .06539 m
.20522 .06914 L
s
.29592 .06539 m
.29592 .06914 L
s
.34127 .06539 m
.34127 .06914 L
s
.38662 .06539 m
.38662 .06914 L
s
.43197 .06539 m
.43197 .06914 L
s
.52268 .06539 m
.52268 .06914 L
s
.56803 .06539 m
.56803 .06914 L
s
.61338 .06539 m
.61338 .06914 L
s
.65873 .06539 m
.65873 .06914 L
s
.74943 .06539 m
.74943 .06914 L
s
.79478 .06539 m
.79478 .06914 L
s
.84014 .06539 m
.84014 .06914 L
s
.88549 .06539 m
.88549 .06914 L
s
.97619 .06539 m
.97619 .06914 L
s
.25 Mabswid
0 .06539 m
1 .06539 L
s
.02381 .17033 m
.03006 .17033 L
s
[(0.2)] .01131 .17033 1 0 Mshowa
.02381 .27527 m
.03006 .27527 L
s
[(0.4)] .01131 .27527 1 0 Mshowa
.02381 .38022 m
.03006 .38022 L
s
[(0.6)] .01131 .38022 1 0 Mshowa
.02381 .48516 m
.03006 .48516 L
s
[(0.8)] .01131 .48516 1 0 Mshowa
.02381 .5901 m
.03006 .5901 L
s
[(1)] .01131 .5901 1 0 Mshowa
.125 Mabswid
.02381 .09162 m
.02756 .09162 L
s
.02381 .11786 m
.02756 .11786 L
s
.02381 .1441 m
.02756 .1441 L
s
.02381 .19657 m
.02756 .19657 L
s
.02381 .2228 m
.02756 .2228 L
s
.02381 .24904 m
.02756 .24904 L
s
.02381 .30151 m
.02756 .30151 L
s
.02381 .32775 m
.02756 .32775 L
s
.02381 .35398 m
.02756 .35398 L
s
.02381 .40645 m
.02756 .40645 L
s
.02381 .43269 m
.02756 .43269 L
s
.02381 .45892 m
.02756 .45892 L
s
.02381 .5114 m
.02756 .5114 L
s
.02381 .53763 m
.02756 .53763 L
s
.02381 .56387 m
.02756 .56387 L
s
.02381 .03915 m
.02756 .03915 L
s
.02381 .01292 m
.02756 .01292 L
s
.02381 .61634 m
.02756 .61634 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.0001 w
.06916 .01472 -1.875 0 Mabsadd m
.06916 .01472 0 2.5 Mabsadd L
.06916 .01472 1.875 0 Mabsadd L
.06916 .01472 0 -2.5 Mabsadd L
.06916 .01472 -1.875 0 Mabsadd L closepath F
.11451 .11951 -1.875 0 Mabsadd m
.11451 .11951 0 2.5 Mabsadd L
.11451 .11951 1.875 0 Mabsadd L
.11451 .11951 0 -2.5 Mabsadd L
.11451 .11951 -1.875 0 Mabsadd L closepath F
.15986 .15267 -1.875 0 Mabsadd m
.15986 .15267 0 2.5 Mabsadd L
.15986 .15267 1.875 0 Mabsadd L
.15986 .15267 0 -2.5 Mabsadd L
.15986 .15267 -1.875 0 Mabsadd L closepath F
.20522 .19488 -1.875 0 Mabsadd m
.20522 .19488 0 2.5 Mabsadd L
.20522 .19488 1.875 0 Mabsadd L
.20522 .19488 0 -2.5 Mabsadd L
.20522 .19488 -1.875 0 Mabsadd L closepath F
.25057 .31677 -1.875 0 Mabsadd m
.25057 .31677 0 2.5 Mabsadd L
.25057 .31677 1.875 0 Mabsadd L
.25057 .31677 0 -2.5 Mabsadd L
.25057 .31677 -1.875 0 Mabsadd L closepath F
.29592 .2715 -1.875 0 Mabsadd m
.29592 .2715 0 2.5 Mabsadd L
.29592 .2715 1.875 0 Mabsadd L
.29592 .2715 0 -2.5 Mabsadd L
.29592 .2715 -1.875 0 Mabsadd L closepath F
.34127 .32969 -1.875 0 Mabsadd m
.34127 .32969 0 2.5 Mabsadd L
.34127 .32969 1.875 0 Mabsadd L
.34127 .32969 0 -2.5 Mabsadd L
.34127 .32969 -1.875 0 Mabsadd L closepath F
.38662 .4143 -1.875 0 Mabsadd m
.38662 .4143 0 2.5 Mabsadd L
.38662 .4143 1.875 0 Mabsadd L
.38662 .4143 0 -2.5 Mabsadd L
.38662 .4143 -1.875 0 Mabsadd L closepath F
.43197 .42492 -1.875 0 Mabsadd m
.43197 .42492 0 2.5 Mabsadd L
.43197 .42492 1.875 0 Mabsadd L
.43197 .42492 0 -2.5 Mabsadd L
.43197 .42492 -1.875 0 Mabsadd L closepath F
.47732 .45495 -1.875 0 Mabsadd m
.47732 .45495 0 2.5 Mabsadd L
.47732 .45495 1.875 0 Mabsadd L
.47732 .45495 0 -2.5 Mabsadd L
.47732 .45495 -1.875 0 Mabsadd L closepath F
.52268 .50056 -1.875 0 Mabsadd m
.52268 .50056 0 2.5 Mabsadd L
.52268 .50056 1.875 0 Mabsadd L
.52268 .50056 0 -2.5 Mabsadd L
.52268 .50056 -1.875 0 Mabsadd L closepath F
.56803 .51649 -1.875 0 Mabsadd m
.56803 .51649 0 2.5 Mabsadd L
.56803 .51649 1.875 0 Mabsadd L
.56803 .51649 0 -2.5 Mabsadd L
.56803 .51649 -1.875 0 Mabsadd L closepath F
.61338 .56481 -1.875 0 Mabsadd m
.61338 .56481 0 2.5 Mabsadd L
.61338 .56481 1.875 0 Mabsadd L
.61338 .56481 0 -2.5 Mabsadd L
.61338 .56481 -1.875 0 Mabsadd L closepath F
.65873 .5946 -1.875 0 Mabsadd m
.65873 .5946 0 2.5 Mabsadd L
.65873 .5946 1.875 0 Mabsadd L
.65873 .5946 0 -2.5 Mabsadd L
.65873 .5946 -1.875 0 Mabsadd L closepath F
.70408 .55398 -1.875 0 Mabsadd m
.70408 .55398 0 2.5 Mabsadd L
.70408 .55398 1.875 0 Mabsadd L
.70408 .55398 0 -2.5 Mabsadd L
.70408 .55398 -1.875 0 Mabsadd L closepath F
.74943 .60332 -1.875 0 Mabsadd m
.74943 .60332 0 2.5 Mabsadd L
.74943 .60332 1.875 0 Mabsadd L
.74943 .60332 0 -2.5 Mabsadd L
.74943 .60332 -1.875 0 Mabsadd L closepath F
.79478 .56276 -1.875 0 Mabsadd m
.79478 .56276 0 2.5 Mabsadd L
.79478 .56276 1.875 0 Mabsadd L
.79478 .56276 0 -2.5 Mabsadd L
.79478 .56276 -1.875 0 Mabsadd L closepath F
.84014 .54709 -1.875 0 Mabsadd m
.84014 .54709 0 2.5 Mabsadd L
.84014 .54709 1.875 0 Mabsadd L
.84014 .54709 0 -2.5 Mabsadd L
.84014 .54709 -1.875 0 Mabsadd L closepath F
.88549 .54919 -1.875 0 Mabsadd m
.88549 .54919 0 2.5 Mabsadd L
.88549 .54919 1.875 0 Mabsadd L
.88549 .54919 0 -2.5 Mabsadd L
.88549 .54919 -1.875 0 Mabsadd L closepath F
.93084 .59093 -1.875 0 Mabsadd m
.93084 .59093 0 2.5 Mabsadd L
.93084 .59093 1.875 0 Mabsadd L
.93084 .59093 0 -2.5 Mabsadd L
.93084 .59093 -1.875 0 Mabsadd L closepath F
.97619 .50723 -1.875 0 Mabsadd m
.97619 .50723 0 2.5 Mabsadd L
.97619 .50723 1.875 0 Mabsadd L
.97619 .50723 0 -2.5 Mabsadd L
.97619 .50723 -1.875 0 Mabsadd L closepath F
.001 w
.15986 .15971 m
.20522 .21106 L
.25057 .2531 L
.29592 .30543 L
.34127 .35144 L
.38662 .37907 L
.43197 .42488 L
.47732 .46224 L
.52268 .49234 L
.56803 .52628 L
.61338 .54609 L
.65873 .56664 L
.70408 .57589 L
.74943 .57235 L
.79478 .56327 L
.84014 .57066 L
.88549 .55144 L
s
.0001 w
.15986 .15971 0 2.5 Mabsadd m
.15986 .15971 -0.56518 .7779 Mabsadd L
.15986 .15971 -2.37764 .77254 Mabsadd L
.15986 .15971 -0.91448 -0.29713 Mabsadd L
.15986 .15971 -1.46946 -2.02254 Mabsadd L
.15986 .15971 0 -0.96154 Mabsadd L
.15986 .15971 1.46946 -2.02254 Mabsadd L
.15986 .15971 .91448 -0.29713 Mabsadd L
.15986 .15971 2.37764 .77254 Mabsadd L
.15986 .15971 .56518 .7779 Mabsadd L
.15986 .15971 0 2.5 Mabsadd L closepath F
.20522 .21106 0 2.5 Mabsadd m
.20522 .21106 -0.56518 .7779 Mabsadd L
.20522 .21106 -2.37764 .77254 Mabsadd L
.20522 .21106 -0.91448 -0.29713 Mabsadd L
.20522 .21106 -1.46946 -2.02254 Mabsadd L
.20522 .21106 0 -0.96154 Mabsadd L
.20522 .21106 1.46946 -2.02254 Mabsadd L
.20522 .21106 .91448 -0.29713 Mabsadd L
.20522 .21106 2.37764 .77254 Mabsadd L
.20522 .21106 .56518 .7779 Mabsadd L
.20522 .21106 0 2.5 Mabsadd L closepath F
.25057 .2531 0 2.5 Mabsadd m
.25057 .2531 -0.56518 .7779 Mabsadd L
.25057 .2531 -2.37764 .77254 Mabsadd L
.25057 .2531 -0.91448 -0.29713 Mabsadd L
.25057 .2531 -1.46946 -2.02254 Mabsadd L
.25057 .2531 0 -0.96154 Mabsadd L
.25057 .2531 1.46946 -2.02254 Mabsadd L
.25057 .2531 .91448 -0.29713 Mabsadd L
.25057 .2531 2.37764 .77254 Mabsadd L
.25057 .2531 .56518 .7779 Mabsadd L
.25057 .2531 0 2.5 Mabsadd L closepath F
.29592 .30543 0 2.5 Mabsadd m
.29592 .30543 -0.56518 .7779 Mabsadd L
.29592 .30543 -2.37764 .77254 Mabsadd L
.29592 .30543 -0.91448 -0.29713 Mabsadd L
.29592 .30543 -1.46946 -2.02254 Mabsadd L
.29592 .30543 0 -0.96154 Mabsadd L
.29592 .30543 1.46946 -2.02254 Mabsadd L
.29592 .30543 .91448 -0.29713 Mabsadd L
.29592 .30543 2.37764 .77254 Mabsadd L
.29592 .30543 .56518 .7779 Mabsadd L
.29592 .30543 0 2.5 Mabsadd L closepath F
.34127 .35144 0 2.5 Mabsadd m
.34127 .35144 -0.56518 .7779 Mabsadd L
.34127 .35144 -2.37764 .77254 Mabsadd L
.34127 .35144 -0.91448 -0.29713 Mabsadd L
.34127 .35144 -1.46946 -2.02254 Mabsadd L
.34127 .35144 0 -0.96154 Mabsadd L
.34127 .35144 1.46946 -2.02254 Mabsadd L
.34127 .35144 .91448 -0.29713 Mabsadd L
.34127 .35144 2.37764 .77254 Mabsadd L
.34127 .35144 .56518 .7779 Mabsadd L
.34127 .35144 0 2.5 Mabsadd L closepath F
.38662 .37907 0 2.5 Mabsadd m
.38662 .37907 -0.56518 .7779 Mabsadd L
.38662 .37907 -2.37764 .77254 Mabsadd L
.38662 .37907 -0.91448 -0.29713 Mabsadd L
.38662 .37907 -1.46946 -2.02254 Mabsadd L
.38662 .37907 0 -0.96154 Mabsadd L
.38662 .37907 1.46946 -2.02254 Mabsadd L
.38662 .37907 .91448 -0.29713 Mabsadd L
.38662 .37907 2.37764 .77254 Mabsadd L
.38662 .37907 .56518 .7779 Mabsadd L
.38662 .37907 0 2.5 Mabsadd L closepath F
.43197 .42488 0 2.5 Mabsadd m
.43197 .42488 -0.56518 .7779 Mabsadd L
.43197 .42488 -2.37764 .77254 Mabsadd L
.43197 .42488 -0.91448 -0.29713 Mabsadd L
.43197 .42488 -1.46946 -2.02254 Mabsadd L
.43197 .42488 0 -0.96154 Mabsadd L
.43197 .42488 1.46946 -2.02254 Mabsadd L
.43197 .42488 .91448 -0.29713 Mabsadd L
.43197 .42488 2.37764 .77254 Mabsadd L
.43197 .42488 .56518 .7779 Mabsadd L
.43197 .42488 0 2.5 Mabsadd L closepath F
.47732 .46224 0 2.5 Mabsadd m
.47732 .46224 -0.56518 .7779 Mabsadd L
.47732 .46224 -2.37764 .77254 Mabsadd L
.47732 .46224 -0.91448 -0.29713 Mabsadd L
.47732 .46224 -1.46946 -2.02254 Mabsadd L
.47732 .46224 0 -0.96154 Mabsadd L
.47732 .46224 1.46946 -2.02254 Mabsadd L
.47732 .46224 .91448 -0.29713 Mabsadd L
.47732 .46224 2.37764 .77254 Mabsadd L
.47732 .46224 .56518 .7779 Mabsadd L
.47732 .46224 0 2.5 Mabsadd L closepath F
.52268 .49234 0 2.5 Mabsadd m
.52268 .49234 -0.56518 .7779 Mabsadd L
.52268 .49234 -2.37764 .77254 Mabsadd L
.52268 .49234 -0.91448 -0.29713 Mabsadd L
.52268 .49234 -1.46946 -2.02254 Mabsadd L
.52268 .49234 0 -0.96154 Mabsadd L
.52268 .49234 1.46946 -2.02254 Mabsadd L
.52268 .49234 .91448 -0.29713 Mabsadd L
.52268 .49234 2.37764 .77254 Mabsadd L
.52268 .49234 .56518 .7779 Mabsadd L
.52268 .49234 0 2.5 Mabsadd L closepath F
.56803 .52628 0 2.5 Mabsadd m
.56803 .52628 -0.56518 .7779 Mabsadd L
.56803 .52628 -2.37764 .77254 Mabsadd L
.56803 .52628 -0.91448 -0.29713 Mabsadd L
.56803 .52628 -1.46946 -2.02254 Mabsadd L
.56803 .52628 0 -0.96154 Mabsadd L
.56803 .52628 1.46946 -2.02254 Mabsadd L
.56803 .52628 .91448 -0.29713 Mabsadd L
.56803 .52628 2.37764 .77254 Mabsadd L
.56803 .52628 .56518 .7779 Mabsadd L
.56803 .52628 0 2.5 Mabsadd L closepath F
.61338 .54609 0 2.5 Mabsadd m
.61338 .54609 -0.56518 .7779 Mabsadd L
.61338 .54609 -2.37764 .77254 Mabsadd L
.61338 .54609 -0.91448 -0.29713 Mabsadd L
.61338 .54609 -1.46946 -2.02254 Mabsadd L
.61338 .54609 0 -0.96154 Mabsadd L
.61338 .54609 1.46946 -2.02254 Mabsadd L
.61338 .54609 .91448 -0.29713 Mabsadd L
.61338 .54609 2.37764 .77254 Mabsadd L
.61338 .54609 .56518 .7779 Mabsadd L
.61338 .54609 0 2.5 Mabsadd L closepath F
.65873 .56664 0 2.5 Mabsadd m
.65873 .56664 -0.56518 .7779 Mabsadd L
.65873 .56664 -2.37764 .77254 Mabsadd L
.65873 .56664 -0.91448 -0.29713 Mabsadd L
.65873 .56664 -1.46946 -2.02254 Mabsadd L
.65873 .56664 0 -0.96154 Mabsadd L
.65873 .56664 1.46946 -2.02254 Mabsadd L
.65873 .56664 .91448 -0.29713 Mabsadd L
.65873 .56664 2.37764 .77254 Mabsadd L
.65873 .56664 .56518 .7779 Mabsadd L
.65873 .56664 0 2.5 Mabsadd L closepath F
.70408 .57589 0 2.5 Mabsadd m
.70408 .57589 -0.56518 .7779 Mabsadd L
.70408 .57589 -2.37764 .77254 Mabsadd L
.70408 .57589 -0.91448 -0.29713 Mabsadd L
.70408 .57589 -1.46946 -2.02254 Mabsadd L
.70408 .57589 0 -0.96154 Mabsadd L
.70408 .57589 1.46946 -2.02254 Mabsadd L
.70408 .57589 .91448 -0.29713 Mabsadd L
.70408 .57589 2.37764 .77254 Mabsadd L
.70408 .57589 .56518 .7779 Mabsadd L
.70408 .57589 0 2.5 Mabsadd L closepath F
.74943 .57235 0 2.5 Mabsadd m
.74943 .57235 -0.56518 .7779 Mabsadd L
.74943 .57235 -2.37764 .77254 Mabsadd L
.74943 .57235 -0.91448 -0.29713 Mabsadd L
.74943 .57235 -1.46946 -2.02254 Mabsadd L
.74943 .57235 0 -0.96154 Mabsadd L
.74943 .57235 1.46946 -2.02254 Mabsadd L
.74943 .57235 .91448 -0.29713 Mabsadd L
.74943 .57235 2.37764 .77254 Mabsadd L
.74943 .57235 .56518 .7779 Mabsadd L
.74943 .57235 0 2.5 Mabsadd L closepath F
.79478 .56327 0 2.5 Mabsadd m
.79478 .56327 -0.56518 .7779 Mabsadd L
.79478 .56327 -2.37764 .77254 Mabsadd L
.79478 .56327 -0.91448 -0.29713 Mabsadd L
.79478 .56327 -1.46946 -2.02254 Mabsadd L
.79478 .56327 0 -0.96154 Mabsadd L
.79478 .56327 1.46946 -2.02254 Mabsadd L
.79478 .56327 .91448 -0.29713 Mabsadd L
.79478 .56327 2.37764 .77254 Mabsadd L
.79478 .56327 .56518 .7779 Mabsadd L
.79478 .56327 0 2.5 Mabsadd L closepath F
.84014 .57066 0 2.5 Mabsadd m
.84014 .57066 -0.56518 .7779 Mabsadd L
.84014 .57066 -2.37764 .77254 Mabsadd L
.84014 .57066 -0.91448 -0.29713 Mabsadd L
.84014 .57066 -1.46946 -2.02254 Mabsadd L
.84014 .57066 0 -0.96154 Mabsadd L
.84014 .57066 1.46946 -2.02254 Mabsadd L
.84014 .57066 .91448 -0.29713 Mabsadd L
.84014 .57066 2.37764 .77254 Mabsadd L
.84014 .57066 .56518 .7779 Mabsadd L
.84014 .57066 0 2.5 Mabsadd L closepath F
.88549 .55144 0 2.5 Mabsadd m
.88549 .55144 -0.56518 .7779 Mabsadd L
.88549 .55144 -2.37764 .77254 Mabsadd L
.88549 .55144 -0.91448 -0.29713 Mabsadd L
.88549 .55144 -1.46946 -2.02254 Mabsadd L
.88549 .55144 0 -0.96154 Mabsadd L
.88549 .55144 1.46946 -2.02254 Mabsadd L
.88549 .55144 .91448 -0.29713 Mabsadd L
.88549 .55144 2.37764 .77254 Mabsadd L
.88549 .55144 .56518 .7779 Mabsadd L
.88549 .55144 0 2.5 Mabsadd L closepath F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.37.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[16]= ",
 CellTags->"S5.37.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["PlotSymbol[", "MR",
       GridBoxOptions->{RowLines->{False, False, False, False, True},
       RowSpacings->0.4}],
      StyleBox["type", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->{False, False, False, False, True},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{False, False, False, False, True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, False, False, False, True},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "generate a function for a plot symbol of the specified type, where ",
       GridBoxOptions->{RowLines->{False, False, False, False, True},
       RowSpacings->0.4}],
      StyleBox["type", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is one of ",
       GridBoxOptions->{RowLines->{False, False, False, False, True},
       RowSpacings->0.4}],
      StyleBox["Box", "MR",
       GridBoxOptions->{RowLines->{False, False, False, False, True},
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->{False, False, False, False, True},
       RowSpacings->0.4}],
      StyleBox["Diamond", "MR",
       GridBoxOptions->{RowLines->{False, False, False, False, True},
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->{False, False, False, False, True},
       RowSpacings->0.4}],
      StyleBox["Star", "MR",
       GridBoxOptions->{RowLines->{False, False, False, False, True},
       RowSpacings->0.4}],
      StyleBox[", or ",
       GridBoxOptions->{RowLines->{False, False, False, False, True},
       RowSpacings->0.4}],
      StyleBox["Triangle", "MR",
       GridBoxOptions->{RowLines->{False, False, False, False, True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, False, False, False, True},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["PlotSymbol[", "MR",
       GridBoxOptions->{RowLines->{False, False, False, False, True},
       RowSpacings->0.4}],
      StyleBox["type", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->{False, False, False, False, True},
       RowSpacings->0.4}],
      StyleBox["size", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->{False, False, False, False, True},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{False, False, False, False, True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, False, False, False, True},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "generate a function for a plot symbol of the specified type, with a \
radius of approximately ",
       GridBoxOptions->{RowLines->{False, False, False, False, True},
       RowSpacings->0.4}],
      StyleBox["size", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" points",
       GridBoxOptions->{RowLines->{False, False, False, False, True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, False, False, False, True},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["PlotSymbol[", "MR",
       GridBoxOptions->{RowLines->{False, False, False, False, True},
       RowSpacings->0.4}],
      StyleBox["type", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", Filled -> False]", "MR",
       GridBoxOptions->{RowLines->{False, False, False, False, True},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{False, False, False, False, True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, False, False, False, True},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "generate a function for a plot symbol of the specified type, where the \
symbol is drawn in outline",
      GridBoxOptions->{RowLines->{False, False, False, False, True},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{False, False, False, False, True},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Stem", "MR",
       GridBoxOptions->{RowLines->{False, False, False, False, True},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{False, False, False, False, True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, False, False, False, True},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "a function for plot symbols given as stems",
      GridBoxOptions->{RowLines->{False, False, False, False, True},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{False, False, False, False, True},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Stem[", "MR",
       GridBoxOptions->{RowLines->{False, False, False, False, True},
       RowSpacings->0.4}],
      StyleBox["size", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->{False, False, False, False, True},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{False, False, False, False, True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, False, False, False, True},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "make the point on the stem a particular size",
      GridBoxOptions->{RowLines->{False, False, False, False, True},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{False, False, False, False, True},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["MakeSymbol[", "MR",
       GridBoxOptions->{RowLines->{False, False, False, False, True},
       RowSpacings->0.4}],
      StyleBox["primitives", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->{False, False, False, False, True},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{False, False, False, False, True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, False, False, False, True},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "given a list of graphics primitives, treat the coordinates as offsets \
from an input point and return a function that can be used to draw a symbol",
      GridBoxOptions->{RowLines->{False, False, False, False, True},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{False, False, False, False, True},
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->{False, False, False, False, True},
 RowSpacings->0.4},
 CellTags->"S5.37.1"],

Cell["Specification of some standard plotting symbols. ", "Caption",
 CellTags->"S5.37.1"],

Cell[TextData[{
 "Some standard plot symbols are supplied for use with the ",
 StyleBox["SymbolShape", "MR"],
 " option. These symbols can be drawn with a particular size and can also be \
drawn in outline. Completely arbitrary symbols can be constructed by applying \
",
 StyleBox["MakeSymbol", "MR"],
 " to a list of graphics primitives. The coordinates for the symbol are \
treated as offsets (in the ",
 StyleBox["Offset", "MR"],
 " coordinate system) from the data point. "
}], "Text",
 CellTags->{"S5.37.1", "1.25"}],

Cell["\<\
This is an example using some of the ways of creating additional plot \
symbols. \
\>", "MathCaption",
 CellTags->{"S5.37.1", "1.26"}],

Cell[CellGroupData[{

Cell["\<\
MultipleListPlot[
   Range[7],
   Table[3.5, {7}],
   Sqrt[Range[7]],
 SymbolShape ->
   {PlotSymbol[Triangle],
    MakeSymbol[RegularPolygon[5, 3]],
    MakeSymbol[
      {Line[{{2, 2}, {-2, -2}}],
       Line[{{-2, 2}, {2, -2}}]}
     ]}
]\
\>", "Input",
 CellLabel->"In[16]:= ",
 CellTags->"S5.37.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.136054 0.0147151 0.0840863 [
[.15986 .00222 -3 -9 ]
[.15986 .00222 3 0 ]
[.29592 .00222 -3 -9 ]
[.29592 .00222 3 0 ]
[.43197 .00222 -3 -9 ]
[.43197 .00222 3 0 ]
[.56803 .00222 -3 -9 ]
[.56803 .00222 3 0 ]
[.70408 .00222 -3 -9 ]
[.70408 .00222 3 0 ]
[.84014 .00222 -3 -9 ]
[.84014 .00222 3 0 ]
[.97619 .00222 -3 -9 ]
[.97619 .00222 3 0 ]
[.01131 .0988 -6 -4.5 ]
[.01131 .0988 0 4.5 ]
[.01131 .18289 -6 -4.5 ]
[.01131 .18289 0 4.5 ]
[.01131 .26697 -6 -4.5 ]
[.01131 .26697 0 4.5 ]
[.01131 .35106 -6 -4.5 ]
[.01131 .35106 0 4.5 ]
[.01131 .43515 -6 -4.5 ]
[.01131 .43515 0 4.5 ]
[.01131 .51923 -6 -4.5 ]
[.01131 .51923 0 4.5 ]
[.01131 .60332 -6 -4.5 ]
[.01131 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.15986 .01472 m
.15986 .02097 L
s
[(1)] .15986 .00222 0 1 Mshowa
.29592 .01472 m
.29592 .02097 L
s
[(2)] .29592 .00222 0 1 Mshowa
.43197 .01472 m
.43197 .02097 L
s
[(3)] .43197 .00222 0 1 Mshowa
.56803 .01472 m
.56803 .02097 L
s
[(4)] .56803 .00222 0 1 Mshowa
.70408 .01472 m
.70408 .02097 L
s
[(5)] .70408 .00222 0 1 Mshowa
.84014 .01472 m
.84014 .02097 L
s
[(6)] .84014 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(7)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.05102 .01472 m
.05102 .01847 L
s
.07823 .01472 m
.07823 .01847 L
s
.10544 .01472 m
.10544 .01847 L
s
.13265 .01472 m
.13265 .01847 L
s
.18707 .01472 m
.18707 .01847 L
s
.21429 .01472 m
.21429 .01847 L
s
.2415 .01472 m
.2415 .01847 L
s
.26871 .01472 m
.26871 .01847 L
s
.32313 .01472 m
.32313 .01847 L
s
.35034 .01472 m
.35034 .01847 L
s
.37755 .01472 m
.37755 .01847 L
s
.40476 .01472 m
.40476 .01847 L
s
.45918 .01472 m
.45918 .01847 L
s
.48639 .01472 m
.48639 .01847 L
s
.51361 .01472 m
.51361 .01847 L
s
.54082 .01472 m
.54082 .01847 L
s
.59524 .01472 m
.59524 .01847 L
s
.62245 .01472 m
.62245 .01847 L
s
.64966 .01472 m
.64966 .01847 L
s
.67687 .01472 m
.67687 .01847 L
s
.73129 .01472 m
.73129 .01847 L
s
.7585 .01472 m
.7585 .01847 L
s
.78571 .01472 m
.78571 .01847 L
s
.81293 .01472 m
.81293 .01847 L
s
.86735 .01472 m
.86735 .01847 L
s
.89456 .01472 m
.89456 .01847 L
s
.92177 .01472 m
.92177 .01847 L
s
.94898 .01472 m
.94898 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .0988 m
.03006 .0988 L
s
[(1)] .01131 .0988 1 0 Mshowa
.02381 .18289 m
.03006 .18289 L
s
[(2)] .01131 .18289 1 0 Mshowa
.02381 .26697 m
.03006 .26697 L
s
[(3)] .01131 .26697 1 0 Mshowa
.02381 .35106 m
.03006 .35106 L
s
[(4)] .01131 .35106 1 0 Mshowa
.02381 .43515 m
.03006 .43515 L
s
[(5)] .01131 .43515 1 0 Mshowa
.02381 .51923 m
.03006 .51923 L
s
[(6)] .01131 .51923 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(7)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .03153 m
.02756 .03153 L
s
.02381 .04835 m
.02756 .04835 L
s
.02381 .06517 m
.02756 .06517 L
s
.02381 .08198 m
.02756 .08198 L
s
.02381 .11562 m
.02756 .11562 L
s
.02381 .13244 m
.02756 .13244 L
s
.02381 .14925 m
.02756 .14925 L
s
.02381 .16607 m
.02756 .16607 L
s
.02381 .1997 m
.02756 .1997 L
s
.02381 .21652 m
.02756 .21652 L
s
.02381 .23334 m
.02756 .23334 L
s
.02381 .25016 m
.02756 .25016 L
s
.02381 .28379 m
.02756 .28379 L
s
.02381 .30061 m
.02756 .30061 L
s
.02381 .31743 m
.02756 .31743 L
s
.02381 .33424 m
.02756 .33424 L
s
.02381 .36788 m
.02756 .36788 L
s
.02381 .38469 m
.02756 .38469 L
s
.02381 .40151 m
.02756 .40151 L
s
.02381 .41833 m
.02756 .41833 L
s
.02381 .45196 m
.02756 .45196 L
s
.02381 .46878 m
.02756 .46878 L
s
.02381 .4856 m
.02756 .4856 L
s
.02381 .50242 m
.02756 .50242 L
s
.02381 .53605 m
.02756 .53605 L
s
.02381 .55287 m
.02756 .55287 L
s
.02381 .56968 m
.02756 .56968 L
s
.02381 .5865 m
.02756 .5865 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.0001 w
.15986 .0988 0 2.5 Mabsadd m
.15986 .0988 -2.165 -1.25 Mabsadd L
.15986 .0988 2.165 -1.25 Mabsadd L
.15986 .0988 0 2.5 Mabsadd L closepath F
.29592 .18289 0 2.5 Mabsadd m
.29592 .18289 -2.165 -1.25 Mabsadd L
.29592 .18289 2.165 -1.25 Mabsadd L
.29592 .18289 0 2.5 Mabsadd L closepath F
.43197 .26697 0 2.5 Mabsadd m
.43197 .26697 -2.165 -1.25 Mabsadd L
.43197 .26697 2.165 -1.25 Mabsadd L
.43197 .26697 0 2.5 Mabsadd L closepath F
.56803 .35106 0 2.5 Mabsadd m
.56803 .35106 -2.165 -1.25 Mabsadd L
.56803 .35106 2.165 -1.25 Mabsadd L
.56803 .35106 0 2.5 Mabsadd L closepath F
.70408 .43515 0 2.5 Mabsadd m
.70408 .43515 -2.165 -1.25 Mabsadd L
.70408 .43515 2.165 -1.25 Mabsadd L
.70408 .43515 0 2.5 Mabsadd L closepath F
.84014 .51923 0 2.5 Mabsadd m
.84014 .51923 -2.165 -1.25 Mabsadd L
.84014 .51923 2.165 -1.25 Mabsadd L
.84014 .51923 0 2.5 Mabsadd L closepath F
.97619 .60332 0 2.5 Mabsadd m
.97619 .60332 -2.165 -1.25 Mabsadd L
.97619 .60332 2.165 -1.25 Mabsadd L
.97619 .60332 0 2.5 Mabsadd L closepath F
.15986 .30902 0 3 Mabsadd m
.15986 .30902 -2.85317 .92705 Mabsadd L
.15986 .30902 -1.76336 -2.42705 Mabsadd L
.15986 .30902 1.76336 -2.42705 Mabsadd L
.15986 .30902 2.85317 .92705 Mabsadd L
.15986 .30902 0 3 Mabsadd L s
.29592 .30902 0 3 Mabsadd m
.29592 .30902 -2.85317 .92705 Mabsadd L
.29592 .30902 -1.76336 -2.42705 Mabsadd L
.29592 .30902 1.76336 -2.42705 Mabsadd L
.29592 .30902 2.85317 .92705 Mabsadd L
.29592 .30902 0 3 Mabsadd L s
.43197 .30902 0 3 Mabsadd m
.43197 .30902 -2.85317 .92705 Mabsadd L
.43197 .30902 -1.76336 -2.42705 Mabsadd L
.43197 .30902 1.76336 -2.42705 Mabsadd L
.43197 .30902 2.85317 .92705 Mabsadd L
.43197 .30902 0 3 Mabsadd L s
.56803 .30902 0 3 Mabsadd m
.56803 .30902 -2.85317 .92705 Mabsadd L
.56803 .30902 -1.76336 -2.42705 Mabsadd L
.56803 .30902 1.76336 -2.42705 Mabsadd L
.56803 .30902 2.85317 .92705 Mabsadd L
.56803 .30902 0 3 Mabsadd L s
.70408 .30902 0 3 Mabsadd m
.70408 .30902 -2.85317 .92705 Mabsadd L
.70408 .30902 -1.76336 -2.42705 Mabsadd L
.70408 .30902 1.76336 -2.42705 Mabsadd L
.70408 .30902 2.85317 .92705 Mabsadd L
.70408 .30902 0 3 Mabsadd L s
.84014 .30902 0 3 Mabsadd m
.84014 .30902 -2.85317 .92705 Mabsadd L
.84014 .30902 -1.76336 -2.42705 Mabsadd L
.84014 .30902 1.76336 -2.42705 Mabsadd L
.84014 .30902 2.85317 .92705 Mabsadd L
.84014 .30902 0 3 Mabsadd L s
.97619 .30902 0 3 Mabsadd m
.97619 .30902 -2.85317 .92705 Mabsadd L
.97619 .30902 -1.76336 -2.42705 Mabsadd L
.97619 .30902 1.76336 -2.42705 Mabsadd L
.97619 .30902 2.85317 .92705 Mabsadd L
.97619 .30902 0 3 Mabsadd L s
.15986 .0988 2 2 Mabsadd m
.15986 .0988 -2 -2 Mabsadd L s
.15986 .0988 -2 2 Mabsadd m
.15986 .0988 2 -2 Mabsadd L s
.29592 .13363 2 2 Mabsadd m
.29592 .13363 -2 -2 Mabsadd L s
.29592 .13363 -2 2 Mabsadd m
.29592 .13363 2 -2 Mabsadd L s
.43197 .16036 2 2 Mabsadd m
.43197 .16036 -2 -2 Mabsadd L s
.43197 .16036 -2 2 Mabsadd m
.43197 .16036 2 -2 Mabsadd L s
.56803 .18289 2 2 Mabsadd m
.56803 .18289 -2 -2 Mabsadd L s
.56803 .18289 -2 2 Mabsadd m
.56803 .18289 2 -2 Mabsadd L s
.70408 .20274 2 2 Mabsadd m
.70408 .20274 -2 -2 Mabsadd L s
.70408 .20274 -2 2 Mabsadd m
.70408 .20274 2 -2 Mabsadd L s
.84014 .22068 2 2 Mabsadd m
.84014 .22068 -2 -2 Mabsadd L s
.84014 .22068 -2 2 Mabsadd m
.84014 .22068 2 -2 Mabsadd L s
.97619 .23719 2 2 Mabsadd m
.97619 .23719 -2 -2 Mabsadd L s
.97619 .23719 -2 2 Mabsadd m
.97619 .23719 2 -2 Mabsadd L s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.37.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[17]= ",
 CellTags->"S5.37.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["RegularPolygon[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["generate a regular ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["n",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["\[Hyphen]sided polygon",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["RegularPolygon[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["rad", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["use radius ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["rad", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["RegularPolygon[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["rad", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ctr", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["use center ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ctr", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["RegularPolygon[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["rad", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ctr", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["tilt", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["tilt the ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["n",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["\[Hyphen]sided polygon counterclockwise by angle ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["tilt", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["RegularPolygon[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["rad", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ctr", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["tilt", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["k", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["connect every ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["k", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" vertices",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.37.1"],

Cell["Generating regular polygon symbols. ", "Caption",
 CellTags->"S5.37.1"],

Cell[TextData[{
 "Additional plotting symbols can be created using the functions ",
 StyleBox["MakeSymbol", "MR"],
 " and ",
 StyleBox["RegularPolygon", "MR"],
 ". ",
 StyleBox["RegularPolygon", "MR"],
 " generates a list of graphics primitives corresponding to shapes based on \
the regular polyhedra. ",
 StyleBox["MakeSymbol", "MR"],
 " is applied to the primitives to create a plotting symbol. As an example, \
if you give a specification ",
 StyleBox["SymbolShape -> {MakeSymbol[RegularPolygon[", "MR"],
 StyleBox["m", "TI"],
 StyleBox["]], MakeSymbol[RegularPolygon[", "MR"],
 StyleBox["n", "TI"],
 StyleBox["]]}", "MR"],
 ", your first list will be plotted using regular ",
 Cell[BoxData[
  FormBox[
   StyleBox["m",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "\[Hyphen]sided polygons, the second list using regular ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "\[Hyphen]sided polygons, the third list using ",
 Cell[BoxData[
  FormBox[
   StyleBox["m",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "\[Hyphen]sided polygons again, etc. "
}], "Text",
 CellTags->{"S5.37.1", "1.27"}],

Cell["\<\
This displays a seven\[Hyphen]pointed star. \
\>", "MathCaption",
 CellTags->{"S5.37.1", "1.28"}],

Cell[CellGroupData[{

Cell["\<\
Show[Graphics[
    RegularPolygon[7, 2, {0, 0}, 0, 3],
AspectRatio -> Automatic]]\
\>", "Input",
 CellLabel->"In[17]:= ",
 CellTags->"S5.37.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .97493 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.244218 0.463279 0.244218 [
[ 0 0 0 0 ]
[ 1 .97493 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .97493 L
0 .97493 L
closepath
clip
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.5 .95172 m
.28808 .02321 L
.88188 .76781 L
.02381 .35459 L
.97619 .35459 L
.11812 .76781 L
.71192 .02321 L
.5 .95172 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.37.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[18]= ",
 CellTags->"S5.37.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["Dashing[{Dot, Dash, LongDash, \[Ellipsis] }]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["AbsoluteDashing[{Dot, \[Ellipsis] }]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "specify a dashing pattern as a combination of dots, dashes, and long \
dashes",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.37.1"],

Cell["Specifying dashing styles. ", "Caption",
 CellTags->"S5.37.1"],

Cell[TextData[{
 "The ",
 StyleBox["MultipleListPlot", "MR"],
 " package enhances the ",
 StyleBox["Dashing", "MR"],
 " and ",
 StyleBox["AbsoluteDashing", "MR"],
 " styles to allow easy specification of dashing patterns in terms of dots, \
dashes, and long dashes. "
}], "Text",
 CellTags->{"S5.37.1", "1.29"}],

Cell["\<\
This is a graphic demonstrating some possible dashing patterns. \
\>", "MathCaption",
 CellTags->{"S5.37.1", "1.30"}],

Cell[CellGroupData[{

Cell["\<\
Show[Graphics[MapIndexed[
   {#1, Line[{{0, -First[#2]}, {1, -First[#2]}}]}&,
  {Dashing[{Dot}],
   Dashing[{Dot, Dash}],
   Dashing[{Dot, Dash, Dot, LongDash}],
   Dashing[{Dot, Dot, Dash}]
  }
]]]\
\>", "Input",
 CellLabel->"In[18]:= ",
 CellTags->"S5.37.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.79952 0.196201 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 g
.5 Mabswid
[ .003 .02 ] 0 setdash
.02381 .60332 m
.97619 .60332 L
s
[ .003 .03 .04 .03 ] 0 setdash
.02381 .40712 m
.97619 .40712 L
s
[ .003 .03 .04 .03 .003 .03 .09 .03 ] 0 setdash
.02381 .21092 m
.97619 .21092 L
s
[ .003 .02 .003 .03 .04 .03 ] 0 setdash
.02381 .01472 m
.97619 .01472 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.37.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[19]= ",
 CellTags->"S5.37.1"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.37.1"->{
    Cell[1776, 53, 141, 6, 36, "Subsection",
      CellTags->{"S5.37.1", "1.1"}],
    Cell[1920, 61, 439, 9, 72, "Text",
      CellTags->{"S5.37.1", "1.2"}],
    Cell[2362, 72, 1433, 43, 64, "DefinitionBox",
      CellTags->"S5.37.1"],
    Cell[3798, 117, 65, 1, 15, "Caption",
      CellTags->"S5.37.1"],
    Cell[3866, 120, 78, 1, 40, "MathCaption",
      CellTags->{"S5.37.1", "1.3"}],
    Cell[3947, 123, 91, 2, 28, "Input",
      CellTags->"S5.37.1"],
    Cell[4041, 127, 106, 1, 40, "MathCaption",
      CellTags->{"S5.37.1", "1.4"}],
    Cell[4150, 130, 203, 7, 79, "Input",
      CellTags->"S5.37.1"],
    Cell[4356, 139, 94, 1, 40, "MathCaption",
      CellTags->{"S5.37.1", "1.5"}],
    Cell[4475, 144, 93, 2, 28, "Input",
      CellTags->"S5.37.1"],
    Cell[4571, 148, 25679, 580, 186, 9284, 373, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"S5.37.1"],
    Cell[30253, 730, 180, 6, 70, "Output",
      CellTags->"S5.37.1"],
    Cell[30448, 739, 129, 3, 70, "MathCaption",
      CellTags->{"S5.37.1", "1.6"}],
    Cell[30602, 746, 122, 5, 70, "Input",
      CellTags->"S5.37.1"],
    Cell[30727, 753, 9755, 405, 70, 9684, 402, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.37.1"],
    Cell[40485, 1160, 180, 6, 70, "Output",
      CellTags->"S5.37.1"],
    Cell[40680, 1169, 107, 1, 70, "MathCaption",
      CellTags->{"S5.37.1", "1.7"}],
    Cell[40812, 1174, 131, 5, 70, "Input",
      CellTags->"S5.37.1"],
    Cell[40946, 1181, 9532, 389, 70, 9461, 386, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.37.1"],
    Cell[50481, 1572, 180, 6, 70, "Output",
      CellTags->"S5.37.1"],
    Cell[50676, 1581, 10958, 305, 70, "DefinitionBox",
      CellTags->"S5.37.1"],
    Cell[61637, 1888, 153, 5, 70, "Caption",
      CellTags->"S5.37.1"],
    Cell[61793, 1895, 1766, 55, 70, "Text",
      CellTags->{"S5.37.1", "1.8"}],
    Cell[63562, 1952, 149, 4, 70, "MathCaption",
      CellTags->{"S5.37.1", "1.9"}],
    Cell[63736, 1960, 259, 11, 70, "Input",
      CellTags->"S5.37.1"],
    Cell[63998, 1973, 7206, 532, 70, 7135, 529, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.37.1"],
    Cell[71207, 2507, 180, 6, 70, "Output",
      CellTags->"S5.37.1"],
    Cell[71402, 2516, 7770, 223, 70, "DefinitionBox3Col",
      CellTags->"S5.37.1"],
    Cell[79175, 2741, 112, 5, 70, "Caption",
      CellTags->"S5.37.1"],
    Cell[79290, 2748, 780, 19, 70, "Text",
      CellTags->{"S5.37.1", "1.10"}],
    Cell[80073, 2769, 909, 28, 70, "Text",
      CellTags->{"S5.37.1", "1.11"}],
    Cell[80985, 2799, 140, 5, 70, "MathCaption",
      CellTags->{"S5.37.1", "1.12"}],
    Cell[81150, 2808, 260, 7, 70, "Input",
      CellTags->"S5.37.1"],
    Cell[81413, 2817, 6356, 300, 70, 6285, 297, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.37.1"],
    Cell[87772, 3119, 180, 6, 70, "Output",
      CellTags->"S5.37.1"],
    Cell[87967, 3128, 211, 6, 70, "MathCaption",
      CellTags->{"S5.37.1", "1.13"}],
    Cell[88203, 3138, 107, 2, 70, "Input",
      CellTags->"S5.37.1"],
    Cell[88313, 3142, 4357, 325, 70, 4286, 322, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.37.1"],
    Cell[92673, 3469, 180, 6, 70, "Output",
      CellTags->"S5.37.1"],
    Cell[92868, 3478, 596, 17, 70, "Text",
      CellTags->{"S5.37.1", "1.14"}],
    Cell[93467, 3497, 138, 5, 70, "MathCaption",
      CellTags->{"S5.37.1", "1.15"}],
    Cell[93630, 3506, 177, 7, 70, "Input",
      CellTags->"S5.37.1"],
    Cell[93810, 3515, 14650, 642, 70, 14579, 639, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.37.1"],
    Cell[108463, 4159, 180, 6, 70, "Output",
      CellTags->"S5.37.1"],
    Cell[108658, 4168, 413, 7, 70, "Text",
      CellTags->{"S5.37.1", "1.16"}],
    Cell[109074, 4177, 136, 3, 70, "MathCaption",
      CellTags->{"S5.37.1", "1.17"}],
    Cell[109235, 4184, 277, 11, 70, "Input",
      CellTags->"S5.37.1"],
    Cell[109515, 4197, 43108, 1730, 70, 43037, 1727, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.37.1"],
    Cell[152626, 5929, 181, 6, 70, "Output",
      CellTags->"S5.37.1"],
    Cell[152822, 5938, 887, 24, 70, "Text",
      CellTags->{"S5.37.1", "1.18"}],
    Cell[153712, 5964, 125, 3, 70, "MathCaption",
      CellTags->{"S5.37.1", "1.19"}],
    Cell[153840, 5969, 180, 6, 70, "Input",
      CellTags->"S5.37.1"],
    Cell[154023, 5977, 135, 3, 70, "MathCaption",
      CellTags->{"S5.37.1", "1.20"}],
    Cell[154183, 5984, 330, 10, 70, "Input",
      CellTags->"S5.37.1"],
    Cell[154516, 5996, 4603, 285, 70, 4532, 282, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.37.1"],
    Cell[159122, 6283, 181, 6, 70, "Output",
      CellTags->"S5.37.1"],
    Cell[159318, 6292, 631, 17, 70, "Text",
      CellTags->{"S5.37.1", "1.21"}],
    Cell[159952, 6311, 88, 1, 70, "MathCaption",
      CellTags->{"S5.37.1", "1.22"}],
    Cell[160043, 6314, 91, 2, 70, "Input",
      CellTags->"S5.37.1"],
    Cell[160137, 6318, 99, 1, 70, "MathCaption",
      CellTags->{"S5.37.1", "1.23"}],
    Cell[160239, 6321, 180, 6, 70, "Input",
      CellTags->"S5.37.1"],
    Cell[160422, 6329, 156, 4, 70, "MathCaption",
      CellTags->{"S5.37.1", "1.24"}],
    Cell[160603, 6337, 184, 8, 70, "Input",
      CellTags->"S5.37.1"],
    Cell[160790, 6347, 14118, 524, 70, 14047, 521, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.37.1"],
    Cell[174911, 6873, 181, 6, 70, "Output",
      CellTags->"S5.37.1"],
    Cell[175107, 6882, 6982, 172, 70, "DefinitionBox",
      CellTags->"S5.37.1"],
    Cell[182092, 7056, 90, 1, 70, "Caption",
      CellTags->"S5.37.1"],
    Cell[182185, 7059, 522, 12, 70, "Text",
      CellTags->{"S5.37.1", "1.25"}],
    Cell[182710, 7073, 144, 4, 70, "MathCaption",
      CellTags->{"S5.37.1", "1.26"}],
    Cell[182879, 7081, 313, 15, 70, "Input",
      CellTags->"S5.37.1"],
    Cell[183195, 7098, 7641, 403, 70, 7570, 400, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.37.1"],
    Cell[190839, 7503, 181, 6, 70, "Output",
      CellTags->"S5.37.1"],
    Cell[191035, 7512, 6647, 211, 70, "DefinitionBox",
      CellTags->"S5.37.1"],
    Cell[197685, 7725, 77, 1, 70, "Caption",
      CellTags->"S5.37.1"],
    Cell[197765, 7728, 1283, 37, 70, "Text",
      CellTags->{"S5.37.1", "1.27"}],
    Cell[199051, 7767, 107, 3, 70, "MathCaption",
      CellTags->{"S5.37.1", "1.28"}],
    Cell[199183, 7774, 153, 6, 70, "Input",
      CellTags->"S5.37.1"],
    Cell[199339, 7782, 813, 51, 70, 742, 48, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.37.1"],
    Cell[200155, 7835, 181, 6, 70, "Output",
      CellTags->"S5.37.1"],
    Cell[200351, 7844, 882, 25, 70, "DefinitionBox",
      CellTags->"S5.37.1"],
    Cell[201236, 7871, 68, 1, 70, "Caption",
      CellTags->"S5.37.1"],
    Cell[201307, 7874, 311, 10, 70, "Text",
      CellTags->{"S5.37.1", "1.29"}],
    Cell[201621, 7886, 127, 3, 70, "MathCaption",
      CellTags->{"S5.37.1", "1.30"}],
    Cell[201773, 7893, 270, 11, 70, "Input",
      CellTags->"S5.37.1"],
    Cell[202046, 7906, 960, 57, 70, 889, 54, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.37.1"],
    Cell[203009, 7965, 181, 6, 70, "Output",
      CellTags->"S5.37.1"]},
  "1.1"->{
    Cell[1776, 53, 141, 6, 36, "Subsection",
      CellTags->{"S5.37.1", "1.1"}]},
  "1.2"->{
    Cell[1920, 61, 439, 9, 72, "Text",
      CellTags->{"S5.37.1", "1.2"}]},
  "1.3"->{
    Cell[3866, 120, 78, 1, 40, "MathCaption",
      CellTags->{"S5.37.1", "1.3"}]},
  "1.4"->{
    Cell[4041, 127, 106, 1, 40, "MathCaption",
      CellTags->{"S5.37.1", "1.4"}]},
  "1.5"->{
    Cell[4356, 139, 94, 1, 40, "MathCaption",
      CellTags->{"S5.37.1", "1.5"}]},
  "1.6"->{
    Cell[30448, 739, 129, 3, 70, "MathCaption",
      CellTags->{"S5.37.1", "1.6"}]},
  "1.7"->{
    Cell[40680, 1169, 107, 1, 70, "MathCaption",
      CellTags->{"S5.37.1", "1.7"}]},
  "1.8"->{
    Cell[61793, 1895, 1766, 55, 70, "Text",
      CellTags->{"S5.37.1", "1.8"}]},
  "1.9"->{
    Cell[63562, 1952, 149, 4, 70, "MathCaption",
      CellTags->{"S5.37.1", "1.9"}]},
  "1.10"->{
    Cell[79290, 2748, 780, 19, 70, "Text",
      CellTags->{"S5.37.1", "1.10"}]},
  "1.11"->{
    Cell[80073, 2769, 909, 28, 70, "Text",
      CellTags->{"S5.37.1", "1.11"}]},
  "1.12"->{
    Cell[80985, 2799, 140, 5, 70, "MathCaption",
      CellTags->{"S5.37.1", "1.12"}]},
  "1.13"->{
    Cell[87967, 3128, 211, 6, 70, "MathCaption",
      CellTags->{"S5.37.1", "1.13"}]},
  "1.14"->{
    Cell[92868, 3478, 596, 17, 70, "Text",
      CellTags->{"S5.37.1", "1.14"}]},
  "1.15"->{
    Cell[93467, 3497, 138, 5, 70, "MathCaption",
      CellTags->{"S5.37.1", "1.15"}]},
  "1.16"->{
    Cell[108658, 4168, 413, 7, 70, "Text",
      CellTags->{"S5.37.1", "1.16"}]},
  "1.17"->{
    Cell[109074, 4177, 136, 3, 70, "MathCaption",
      CellTags->{"S5.37.1", "1.17"}]},
  "1.18"->{
    Cell[152822, 5938, 887, 24, 70, "Text",
      CellTags->{"S5.37.1", "1.18"}]},
  "1.19"->{
    Cell[153712, 5964, 125, 3, 70, "MathCaption",
      CellTags->{"S5.37.1", "1.19"}]},
  "1.20"->{
    Cell[154023, 5977, 135, 3, 70, "MathCaption",
      CellTags->{"S5.37.1", "1.20"}]},
  "1.21"->{
    Cell[159318, 6292, 631, 17, 70, "Text",
      CellTags->{"S5.37.1", "1.21"}]},
  "1.22"->{
    Cell[159952, 6311, 88, 1, 70, "MathCaption",
      CellTags->{"S5.37.1", "1.22"}]},
  "1.23"->{
    Cell[160137, 6318, 99, 1, 70, "MathCaption",
      CellTags->{"S5.37.1", "1.23"}]},
  "1.24"->{
    Cell[160422, 6329, 156, 4, 70, "MathCaption",
      CellTags->{"S5.37.1", "1.24"}]},
  "1.25"->{
    Cell[182185, 7059, 522, 12, 70, "Text",
      CellTags->{"S5.37.1", "1.25"}]},
  "1.26"->{
    Cell[182710, 7073, 144, 4, 70, "MathCaption",
      CellTags->{"S5.37.1", "1.26"}]},
  "1.27"->{
    Cell[197765, 7728, 1283, 37, 70, "Text",
      CellTags->{"S5.37.1", "1.27"}]},
  "1.28"->{
    Cell[199051, 7767, 107, 3, 70, "MathCaption",
      CellTags->{"S5.37.1", "1.28"}]},
  "1.29"->{
    Cell[201307, 7874, 311, 10, 70, "Text",
      CellTags->{"S5.37.1", "1.29"}]},
  "1.30"->{
    Cell[201621, 7886, 127, 3, 70, "MathCaption",
      CellTags->{"S5.37.1", "1.30"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.37.1", 203841, 7991},
  {"1.1", 211502, 8189},
  {"1.2", 211596, 8192},
  {"1.3", 211684, 8195},
  {"1.4", 211779, 8198},
  {"1.5", 211875, 8201},
  {"1.6", 211970, 8204},
  {"1.7", 212067, 8207},
  {"1.8", 212165, 8210},
  {"1.9", 212258, 8213},
  {"1.10", 212357, 8216},
  {"1.11", 212451, 8219},
  {"1.12", 212545, 8222},
  {"1.13", 212645, 8225},
  {"1.14", 212745, 8228},
  {"1.15", 212839, 8231},
  {"1.16", 212939, 8234},
  {"1.17", 213033, 8237},
  {"1.18", 213134, 8240},
  {"1.19", 213229, 8243},
  {"1.20", 213330, 8246},
  {"1.21", 213431, 8249},
  {"1.22", 213526, 8252},
  {"1.23", 213626, 8255},
  {"1.24", 213726, 8258},
  {"1.25", 213827, 8261},
  {"1.26", 213922, 8264},
  {"1.27", 214023, 8267},
  {"1.28", 214119, 8270},
  {"1.29", 214220, 8273},
  {"1.30", 214315, 8276}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 141, 6, 36, "Subsection",
  CellTags->{"S5.37.1", "1.1"}],
Cell[1920, 61, 439, 9, 72, "Text",
  CellTags->{"S5.37.1", "1.2"}],
Cell[2362, 72, 1433, 43, 64, "DefinitionBox",
  CellTags->"S5.37.1"],
Cell[3798, 117, 65, 1, 15, "Caption",
  CellTags->"S5.37.1"],
Cell[3866, 120, 78, 1, 40, "MathCaption",
  CellTags->{"S5.37.1", "1.3"}],
Cell[3947, 123, 91, 2, 28, "Input",
  CellTags->"S5.37.1"],
Cell[4041, 127, 106, 1, 40, "MathCaption",
  CellTags->{"S5.37.1", "1.4"}],
Cell[4150, 130, 203, 7, 79, "Input",
  CellTags->"S5.37.1"],
Cell[4356, 139, 94, 1, 40, "MathCaption",
  CellTags->{"S5.37.1", "1.5"}],

Cell[CellGroupData[{
Cell[4475, 144, 93, 2, 28, "Input",
  CellTags->"S5.37.1"],
Cell[4571, 148, 25679, 580, 186, 9284, 373, "GraphicsData", "PostScript", \
"Graphics",
  CellTags->"S5.37.1"],
Cell[30253, 730, 180, 6, 70, "Output",
  CellTags->"S5.37.1"]
}, Open  ]],
Cell[30448, 739, 129, 3, 70, "MathCaption",
  CellTags->{"S5.37.1", "1.6"}],

Cell[CellGroupData[{
Cell[30602, 746, 122, 5, 70, "Input",
  CellTags->"S5.37.1"],
Cell[30727, 753, 9755, 405, 70, 9684, 402, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.37.1"],
Cell[40485, 1160, 180, 6, 70, "Output",
  CellTags->"S5.37.1"]
}, Open  ]],
Cell[40680, 1169, 107, 1, 70, "MathCaption",
  CellTags->{"S5.37.1", "1.7"}],

Cell[CellGroupData[{
Cell[40812, 1174, 131, 5, 70, "Input",
  CellTags->"S5.37.1"],
Cell[40946, 1181, 9532, 389, 70, 9461, 386, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.37.1"],
Cell[50481, 1572, 180, 6, 70, "Output",
  CellTags->"S5.37.1"]
}, Open  ]],
Cell[50676, 1581, 10958, 305, 70, "DefinitionBox",
  CellTags->"S5.37.1"],
Cell[61637, 1888, 153, 5, 70, "Caption",
  CellTags->"S5.37.1"],
Cell[61793, 1895, 1766, 55, 70, "Text",
  CellTags->{"S5.37.1", "1.8"}],
Cell[63562, 1952, 149, 4, 70, "MathCaption",
  CellTags->{"S5.37.1", "1.9"}],

Cell[CellGroupData[{
Cell[63736, 1960, 259, 11, 70, "Input",
  CellTags->"S5.37.1"],
Cell[63998, 1973, 7206, 532, 70, 7135, 529, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.37.1"],
Cell[71207, 2507, 180, 6, 70, "Output",
  CellTags->"S5.37.1"]
}, Open  ]],
Cell[71402, 2516, 7770, 223, 70, "DefinitionBox3Col",
  CellTags->"S5.37.1"],
Cell[79175, 2741, 112, 5, 70, "Caption",
  CellTags->"S5.37.1"],
Cell[79290, 2748, 780, 19, 70, "Text",
  CellTags->{"S5.37.1", "1.10"}],
Cell[80073, 2769, 909, 28, 70, "Text",
  CellTags->{"S5.37.1", "1.11"}],
Cell[80985, 2799, 140, 5, 70, "MathCaption",
  CellTags->{"S5.37.1", "1.12"}],

Cell[CellGroupData[{
Cell[81150, 2808, 260, 7, 70, "Input",
  CellTags->"S5.37.1"],
Cell[81413, 2817, 6356, 300, 70, 6285, 297, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.37.1"],
Cell[87772, 3119, 180, 6, 70, "Output",
  CellTags->"S5.37.1"]
}, Open  ]],
Cell[87967, 3128, 211, 6, 70, "MathCaption",
  CellTags->{"S5.37.1", "1.13"}],

Cell[CellGroupData[{
Cell[88203, 3138, 107, 2, 70, "Input",
  CellTags->"S5.37.1"],
Cell[88313, 3142, 4357, 325, 70, 4286, 322, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.37.1"],
Cell[92673, 3469, 180, 6, 70, "Output",
  CellTags->"S5.37.1"]
}, Open  ]],
Cell[92868, 3478, 596, 17, 70, "Text",
  CellTags->{"S5.37.1", "1.14"}],
Cell[93467, 3497, 138, 5, 70, "MathCaption",
  CellTags->{"S5.37.1", "1.15"}],

Cell[CellGroupData[{
Cell[93630, 3506, 177, 7, 70, "Input",
  CellTags->"S5.37.1"],
Cell[93810, 3515, 14650, 642, 70, 14579, 639, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.37.1"],
Cell[108463, 4159, 180, 6, 70, "Output",
  CellTags->"S5.37.1"]
}, Open  ]],
Cell[108658, 4168, 413, 7, 70, "Text",
  CellTags->{"S5.37.1", "1.16"}],
Cell[109074, 4177, 136, 3, 70, "MathCaption",
  CellTags->{"S5.37.1", "1.17"}],

Cell[CellGroupData[{
Cell[109235, 4184, 277, 11, 70, "Input",
  CellTags->"S5.37.1"],
Cell[109515, 4197, 43108, 1730, 70, 43037, 1727, "GraphicsData", \
"PostScript", "Graphics",
  ImageCacheValid->False,
  CellTags->"S5.37.1"],
Cell[152626, 5929, 181, 6, 70, "Output",
  CellTags->"S5.37.1"]
}, Open  ]],
Cell[152822, 5938, 887, 24, 70, "Text",
  CellTags->{"S5.37.1", "1.18"}],
Cell[153712, 5964, 125, 3, 70, "MathCaption",
  CellTags->{"S5.37.1", "1.19"}],
Cell[153840, 5969, 180, 6, 70, "Input",
  CellTags->"S5.37.1"],
Cell[154023, 5977, 135, 3, 70, "MathCaption",
  CellTags->{"S5.37.1", "1.20"}],

Cell[CellGroupData[{
Cell[154183, 5984, 330, 10, 70, "Input",
  CellTags->"S5.37.1"],
Cell[154516, 5996, 4603, 285, 70, 4532, 282, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.37.1"],
Cell[159122, 6283, 181, 6, 70, "Output",
  CellTags->"S5.37.1"]
}, Open  ]],
Cell[159318, 6292, 631, 17, 70, "Text",
  CellTags->{"S5.37.1", "1.21"}],
Cell[159952, 6311, 88, 1, 70, "MathCaption",
  CellTags->{"S5.37.1", "1.22"}],
Cell[160043, 6314, 91, 2, 70, "Input",
  CellTags->"S5.37.1"],
Cell[160137, 6318, 99, 1, 70, "MathCaption",
  CellTags->{"S5.37.1", "1.23"}],
Cell[160239, 6321, 180, 6, 70, "Input",
  CellTags->"S5.37.1"],
Cell[160422, 6329, 156, 4, 70, "MathCaption",
  CellTags->{"S5.37.1", "1.24"}],

Cell[CellGroupData[{
Cell[160603, 6337, 184, 8, 70, "Input",
  CellTags->"S5.37.1"],
Cell[160790, 6347, 14118, 524, 70, 14047, 521, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.37.1"],
Cell[174911, 6873, 181, 6, 70, "Output",
  CellTags->"S5.37.1"]
}, Open  ]],
Cell[175107, 6882, 6982, 172, 70, "DefinitionBox",
  CellTags->"S5.37.1"],
Cell[182092, 7056, 90, 1, 70, "Caption",
  CellTags->"S5.37.1"],
Cell[182185, 7059, 522, 12, 70, "Text",
  CellTags->{"S5.37.1", "1.25"}],
Cell[182710, 7073, 144, 4, 70, "MathCaption",
  CellTags->{"S5.37.1", "1.26"}],

Cell[CellGroupData[{
Cell[182879, 7081, 313, 15, 70, "Input",
  CellTags->"S5.37.1"],
Cell[183195, 7098, 7641, 403, 70, 7570, 400, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.37.1"],
Cell[190839, 7503, 181, 6, 70, "Output",
  CellTags->"S5.37.1"]
}, Open  ]],
Cell[191035, 7512, 6647, 211, 70, "DefinitionBox",
  CellTags->"S5.37.1"],
Cell[197685, 7725, 77, 1, 70, "Caption",
  CellTags->"S5.37.1"],
Cell[197765, 7728, 1283, 37, 70, "Text",
  CellTags->{"S5.37.1", "1.27"}],
Cell[199051, 7767, 107, 3, 70, "MathCaption",
  CellTags->{"S5.37.1", "1.28"}],

Cell[CellGroupData[{
Cell[199183, 7774, 153, 6, 70, "Input",
  CellTags->"S5.37.1"],
Cell[199339, 7782, 813, 51, 70, 742, 48, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.37.1"],
Cell[200155, 7835, 181, 6, 70, "Output",
  CellTags->"S5.37.1"]
}, Open  ]],
Cell[200351, 7844, 882, 25, 70, "DefinitionBox",
  CellTags->"S5.37.1"],
Cell[201236, 7871, 68, 1, 70, "Caption",
  CellTags->"S5.37.1"],
Cell[201307, 7874, 311, 10, 70, "Text",
  CellTags->{"S5.37.1", "1.29"}],
Cell[201621, 7886, 127, 3, 70, "MathCaption",
  CellTags->{"S5.37.1", "1.30"}],

Cell[CellGroupData[{
Cell[201773, 7893, 270, 11, 70, "Input",
  CellTags->"S5.37.1"],
Cell[202046, 7906, 960, 57, 70, 889, 54, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.37.1"],
Cell[203009, 7965, 181, 6, 70, "Output",
  CellTags->"S5.37.1"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

