(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     17977,        574]*)
(*NotebookOutlinePosition[     24235,        763]*)
(*  CellTagsIndexPosition[     23739,        739]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Miscellaneous",
 StyleBox["`", "MB"],
 "Music",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.57.1", "1.1"}],

Cell[TextData[{
 "The functions defined in ",
 StyleBox["Miscellaneous`Music`", "MR"],
 " allow you to make conversions between cents and hertz, and play scales in \
one of the common tuning systems, or in a user\[Hyphen]specified tuning \
system. In addition, a set of equal\[Hyphen]tempered pitch/frequency \
equivalents is defined. "
}], "Text",
 CellTags->{"S5.57.1", "1.2"}],

Cell[TextData[{
 "When you try the examples in this documentation, your computer display may \
not look exactly the same, since the graphic displays accompanying ",
 StyleBox["Mathematica", "TI"],
 "\[CloseCurlyQuote]s sound generation vary from platform to platform. "
}], "Text",
 CellTags->{"S5.57.1", "1.3"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["Scale[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ilist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["freq", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dur", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["create a ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["Sound", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" object that is a sequence of pitches corresponding to ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ilist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", a list of intervals measured in cents, starting at ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["freq", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" hertz and lasting ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dur", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" seconds",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.57.1"],

Cell["Creating a scale. ", "Caption",
 CellTags->"S5.57.1"],

Cell[TextData[{
 StyleBox["Scale", "MR"],
 " creates a pitch sequence from a predefined interval list or an arbitrary \
list of numbers interpreted as intervals measured in cents. "
}], "Text",
 CellTags->{"S5.57.1", "1.4"}],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.57.1", "1.5"}],

Cell["<< Miscellaneous`Music`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.57.1"],

Cell[TextData[{
 StyleBox["JustMajor", "MR"],
 " is an interval list. This plays a major scale in just intonation that \
starts at 440 Hz and lasts for 3 seconds. "
}], "MathCaption",
 CellTags->{"S5.57.1", "1.6"}],

Cell[CellGroupData[{

Cell["Scale[JustMajor, 440, 3] // Show", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.57.1"],

Cell["        -Sound-", "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.57.1"]
}, Open  ]],

Cell["\<\
The list of intervals does not have to be in ascending or descending order. \
Here the starting frequncy is 880 Hz. \
\>", "MathCaption",
 CellTags->{"S5.57.1", "1.7"}],

Cell[CellGroupData[{

Cell["Scale[{100, 950, 350, 1200}, 880, 1] // Show", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.57.1"],

Cell["        -Sound-", "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.57.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[StyleBox["QuarterTone",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["PythagoreanMajor",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["PythagoreanChromatic",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["MeanMajor",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["MeanMinor",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["MeanChromatic",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["SixthTone",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["JustMajor",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["JustMinor",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["TemperedMajor",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["TemperedMinor",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["TemperedChromatic",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.57.1"],

Cell["Predefined interval lists measured in cents.", "Caption",
 CellTags->"S5.57.1"],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["HertzToCents[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["flist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "convert a list of frequencies measured in hertz to a list of intervals \
measured in cents",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["CentsToHertz[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ilist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "convert a list of intervals measured in cents to a list of frequencies \
measured in hertz, beginning at frequency 440 hertz",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["CentsToHertz[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ilist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "convert a list of intervals measured in cents to a list of frequencies \
measured in hertz, beginning at frequency ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["f",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.57.1"],

Cell["Converting between hertz and cents. ", "Caption",
 CellTags->"S5.57.1"],

Cell[TextData[{
 "The two functions ",
 StyleBox["HertzToCents", "MR"],
 " and ",
 StyleBox["CentsToHertz", "MR"],
 " convert a list of one type to its complementary type. "
}], "Text",
 CellTags->{"S5.57.1", "1.8"}],

Cell["\<\
This takes a list of frequencies in hertz and gives the distance from one \
frequency to the next in cents. \
\>", "MathCaption",
 CellTags->{"S5.57.1", "1.9"}],

Cell[CellGroupData[{

Cell["HertzToCents[{400, 450, 525}]", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.57.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"203.9100017376895`", ",", "266.87090561278586`"}], "}"}]], "Output",\

 CellLabel->"Out[4]= ",
 CellTags->"S5.57.1"]
}, Open  ]],

Cell["\<\
Here is a list consisting of the frequencies in a one\[Hyphen]octave, equal\
\[Hyphen]tempered chromatic scale starting at 440 hertz. \
\>", "MathCaption",
 CellTags->{"S5.57.1", "1.10"}],

Cell[CellGroupData[{

Cell["alist = Table[ N[440 2^(i/12)], {i, 0, 12}]", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.57.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "440.`", ",", "466.1637615180899`", ",", "493.8833012561241`", ",", 
   "523.2511306011972`", ",", "554.3652619537442`", ",", "587.3295358348153`",
    ",", "622.2539674441618`", ",", "659.2551138257401`", ",", 
   "698.4564628660078`", ",", "739.9888454232688`", ",", "783.9908719634988`",
    ",", "830.6093951598907`", ",", "880.`"}], "}"}]], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S5.57.1"]
}, Open  ]],

Cell[TextData[{
 "This confirms that the distance between adjacent pairs of frequencies in ",
 StyleBox["alist", "MR"],
 " is 100 cents. "
}], "MathCaption",
 CellTags->{"S5.57.1", "1.11"}],

Cell[CellGroupData[{

Cell["HertzToCents[alist]", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.57.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "100.00000000339193`", ",", "100.00000000339016`", ",", 
   "100.00000000339016`", ",", "100.00000000339193`", ",", 
   "100.00000000339016`", ",", "100.00000000339016`", ",", 
   "100.00000000339193`", ",", "100.00000000339016`", ",", 
   "100.00000000339016`", ",", "100.00000000339193`", ",", 
   "100.00000000339016`", ",", "100.00000000339016`"}], "}"}]], "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S5.57.1"]
}, Open  ]],

Cell["\<\
This gives the frequency that is 600 cents above the default frequency, 440 \
hertz, or in musical terminology, one\[Hyphen]half octave above the pitch A4. \
\
\>", "MathCaption",
 CellTags->{"S5.57.1", "1.12"}],

Cell[CellGroupData[{

Cell["CentsToHertz[{0, 600}]", "Input",
 CellLabel->"In[7]:= ",
 CellTags->"S5.57.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"440.`", ",", "622.2539674441618`"}], "}"}]], "Output",
 CellLabel->"Out[7]= ",
 CellTags->"S5.57.1"]
}, Open  ]],

Cell["\<\
Here is a list of all the frequencies of equal\[Hyphen]tempered \
half\[Hyphen]steps between 880 and 1760 hertz. \
\>", "MathCaption",
 CellTags->{"S5.57.1", "1.13"}],

Cell[CellGroupData[{

Cell["CentsToHertz[Range[0, 1200, 100], 880]", "Input",
 CellLabel->"In[8]:= ",
 CellTags->"S5.57.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "880.`", ",", "932.3275230361799`", ",", "987.7666025122483`", ",", 
   "1046.5022612023945`", ",", "1108.7305239074883`", ",", 
   "1174.6590716696305`", ",", "1244.5079348883237`", ",", 
   "1318.5102276514801`", ",", "1396.9129257320155`", ",", 
   "1479.9776908465376`", ",", "1567.9817439269975`", ",", 
   "1661.2187903197814`", ",", "1760.`"}], "}"}]], "Output",
 CellLabel->"Out[8]= ",
 CellTags->"S5.57.1"]
}, Open  ]],

Cell["\<\
Here are the frequencies of a 36\[Hyphen]tone octave, starting at 660 hertz. \
\
\>", "MathCaption",
 CellTags->{"S5.57.1", "1.14"}],

Cell[CellGroupData[{

Cell["CentsToHertz[Range[0, 1200, 33.333333], 660]", "Input",
 CellLabel->"In[9]:= ",
 CellTags->"S5.57.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "660.`", ",", "672.8308247138681`", ",", "685.9110889168848`", ",", 
   "699.2456418732347`", ",", "712.8394271199192`", ",", "726.6974842994796`",
    ",", "740.8249510283517`", ",", "755.2270648015406`", ",", 
   "769.909164934325`", ",", "784.8766945417082`", ",", "800.135202556352`", 
   ",", "815.6903457857399`", ",", "831.5478910093326`", ",", 
   "847.7137171164956`", ",", "864.1938172859856`", ",", "880.9943012078114`",
    ",", "898.1213973482874`", ",", "915.5814552591211`", ",", 
   "933.3809479313908`", ",", "951.5264741952875`", ",", "970.0247611665068`",
    ",", "988.8826667402026`", ",", "1008.1071821334239`", ",", 
   "1027.7054344769776`", ",", "1047.6846894576804`", ",", 
   "1068.0523540119757`", ",", "1088.815979071918`", ",", "1109.98326236454`",
    ",", "1131.5620512656412`", ",", "1153.5603457090574`", ",", 
   "1175.9863011524847`", ",", "1198.8482316009658`", ",", 
   "1222.154612689152`", ",", "1245.9140848234852`", ",", 
   "1270.1354563854695`", ",", "1294.8277069972132`", ",", 
   "1319.9999908504572`"}], "}"}]], "Output",
 CellLabel->"Out[9]= ",
 CellTags->"S5.57.1"]
}, Open  ]],

Cell[TextData[{
 "The ",
 StyleBox["Miscellaneous`Music`", "MR"],
 " package provides a list of equal\[Hyphen]tempered pitch/frequency \
equivalents. Pitches are named in pitch class/octave notation, where the \
pitch class is given by a letter from A to G, and the octave is an integer \
from 0 and 7. Flat notes are designated with the appendage flat (as in ",
 StyleBox["Bflat", "MR"],
 " for B\[Hyphen]flat), and sharp notes are designated with the appendage \
sharp (as in ",
 StyleBox["Gsharp", "MR"],
 " for G\[Hyphen]sharp). "
}], "Text",
 CellTags->{"S5.57.1", "1.15"}],

Cell["\<\
Most chromatic equivalences are available, for example, C\[Hyphen]flat is the \
same as B, and E\[Hyphen]sharp is the same as F. Double\[Hyphen]flats and \
double\[Hyphen]sharps are not defined. \
\>", "Text",
 CellTags->{"S5.57.1", "1.16"}],

Cell[TextData[{
 "The difference between ",
 StyleBox["Aflat4", "MR"],
 " and ",
 StyleBox["Eflat5", "MR"],
 " is 700 cents in equal temperament. "
}], "MathCaption",
 CellTags->{"S5.57.1", "1.17"}],

Cell[CellGroupData[{

Cell["HertzToCents[{Aflat4, Eflat5}]", "Input",
 CellLabel->"In[10]:= ",
 CellTags->"S5.57.1"],

Cell[BoxData[
 RowBox[{"{", "700.0000000237346`", "}"}]], "Output",
 CellLabel->"Out[10]= ",
 CellTags->"S5.57.1"]
}, Open  ]],

Cell["This plays a perfect fifth. ", "MathCaption",
 CellTags->{"S5.57.1", "1.18"}],

Cell[CellGroupData[{

Cell["\<\
Play[Sin[2 Pi Aflat4 t] + Sin[2 Pi Eflat5 t],
        {t, 0, 0.2}]\
\>", "Input",
 CellLabel->"In[11]:= ",
 CellTags->"S5.57.1"],

Cell["        -Sound-", "Output",
 CellLabel->"Out[11]= ",
 CellTags->"S5.57.1"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.57.1"->{
    Cell[1776, 53, 135, 6, 36, "Subsection",
      CellTags->{"S5.57.1", "1.1"}],
    Cell[1914, 61, 379, 8, 56, "Text",
      CellTags->{"S5.57.1", "1.2"}],
    Cell[2296, 71, 312, 6, 56, "Text",
      CellTags->{"S5.57.1", "1.3"}],
    Cell[2611, 79, 2104, 64, 82, "DefinitionBox",
      CellTags->"S5.57.1"],
    Cell[4718, 145, 59, 1, 15, "Caption",
      CellTags->"S5.57.1"],
    Cell[4780, 148, 224, 5, 40, "Text",
      CellTags->{"S5.57.1", "1.4"}],
    Cell[5007, 155, 78, 1, 40, "MathCaption",
      CellTags->{"S5.57.1", "1.5"}],
    Cell[5088, 158, 86, 2, 28, "Input",
      CellTags->"S5.57.1"],
    Cell[5177, 162, 214, 5, 56, "MathCaption",
      CellTags->{"S5.57.1", "1.6"}],
    Cell[5416, 171, 95, 2, 28, "Input",
      CellTags->"S5.57.1"],
    Cell[5514, 175, 79, 2, 27, "Output",
      CellTags->"S5.57.1"],
    Cell[5608, 180, 178, 4, 56, "MathCaption",
      CellTags->{"S5.57.1", "1.7"}],
    Cell[5811, 188, 107, 2, 28, "Input",
      CellTags->"S5.57.1"],
    Cell[5921, 192, 79, 2, 27, "Output",
      CellTags->"S5.57.1"],
    Cell[6015, 197, 2285, 60, 150, "DefinitionBox",
      CellTags->"S5.57.1"],
    Cell[8303, 259, 85, 1, 70, "Caption",
      CellTags->"S5.57.1"],
    Cell[8391, 262, 2906, 87, 70, "DefinitionBox",
      CellTags->"S5.57.1"],
    Cell[11300, 351, 77, 1, 70, "Caption",
      CellTags->"S5.57.1"],
    Cell[11380, 354, 216, 7, 70, "Text",
      CellTags->{"S5.57.1", "1.8"}],
    Cell[11599, 363, 170, 4, 70, "MathCaption",
      CellTags->{"S5.57.1", "1.9"}],
    Cell[11794, 371, 92, 2, 70, "Input",
      CellTags->"S5.57.1"],
    Cell[11889, 375, 156, 5, 70, "Output",
      CellTags->"S5.57.1"],
    Cell[12060, 383, 197, 4, 70, "MathCaption",
      CellTags->{"S5.57.1", "1.10"}],
    Cell[12282, 391, 106, 2, 70, "Input",
      CellTags->"S5.57.1"],
    Cell[12391, 395, 443, 9, 70, "Output",
      CellTags->"S5.57.1"],
    Cell[12849, 407, 189, 5, 70, "MathCaption",
      CellTags->{"S5.57.1", "1.11"}],
    Cell[13063, 416, 82, 2, 70, "Input",
      CellTags->"S5.57.1"],
    Cell[13148, 420, 458, 10, 70, "Output",
      CellTags->"S5.57.1"],
    Cell[13621, 433, 221, 5, 70, "MathCaption",
      CellTags->{"S5.57.1", "1.12"}],
    Cell[13867, 442, 85, 2, 70, "Input",
      CellTags->"S5.57.1"],
    Cell[13955, 446, 140, 4, 70, "Output",
      CellTags->"S5.57.1"],
    Cell[14110, 453, 176, 4, 70, "MathCaption",
      CellTags->{"S5.57.1", "1.13"}],
    Cell[14311, 461, 101, 2, 70, "Input",
      CellTags->"S5.57.1"],
    Cell[14415, 465, 457, 10, 70, "Output",
      CellTags->"S5.57.1"],
    Cell[14887, 478, 142, 4, 70, "MathCaption",
      CellTags->{"S5.57.1", "1.14"}],
    Cell[15054, 486, 107, 2, 70, "Input",
      CellTags->"S5.57.1"],
    Cell[15164, 490, 1157, 20, 70, "Output",
      CellTags->"S5.57.1"],
    Cell[16336, 513, 578, 13, 70, "Text",
      CellTags->{"S5.57.1", "1.15"}],
    Cell[16917, 528, 251, 5, 70, "Text",
      CellTags->{"S5.57.1", "1.16"}],
    Cell[17171, 535, 198, 7, 70, "MathCaption",
      CellTags->{"S5.57.1", "1.17"}],
    Cell[17394, 546, 94, 2, 70, "Input",
      CellTags->"S5.57.1"],
    Cell[17491, 550, 114, 3, 70, "Output",
      CellTags->"S5.57.1"],
    Cell[17620, 556, 83, 1, 70, "MathCaption",
      CellTags->{"S5.57.1", "1.18"}],
    Cell[17728, 561, 138, 5, 70, "Input",
      CellTags->"S5.57.1"],
    Cell[17869, 568, 80, 2, 70, "Output",
      CellTags->"S5.57.1"]},
  "1.1"->{
    Cell[1776, 53, 135, 6, 36, "Subsection",
      CellTags->{"S5.57.1", "1.1"}]},
  "1.2"->{
    Cell[1914, 61, 379, 8, 56, "Text",
      CellTags->{"S5.57.1", "1.2"}]},
  "1.3"->{
    Cell[2296, 71, 312, 6, 56, "Text",
      CellTags->{"S5.57.1", "1.3"}]},
  "1.4"->{
    Cell[4780, 148, 224, 5, 40, "Text",
      CellTags->{"S5.57.1", "1.4"}]},
  "1.5"->{
    Cell[5007, 155, 78, 1, 40, "MathCaption",
      CellTags->{"S5.57.1", "1.5"}]},
  "1.6"->{
    Cell[5177, 162, 214, 5, 56, "MathCaption",
      CellTags->{"S5.57.1", "1.6"}]},
  "1.7"->{
    Cell[5608, 180, 178, 4, 56, "MathCaption",
      CellTags->{"S5.57.1", "1.7"}]},
  "1.8"->{
    Cell[11380, 354, 216, 7, 70, "Text",
      CellTags->{"S5.57.1", "1.8"}]},
  "1.9"->{
    Cell[11599, 363, 170, 4, 70, "MathCaption",
      CellTags->{"S5.57.1", "1.9"}]},
  "1.10"->{
    Cell[12060, 383, 197, 4, 70, "MathCaption",
      CellTags->{"S5.57.1", "1.10"}]},
  "1.11"->{
    Cell[12849, 407, 189, 5, 70, "MathCaption",
      CellTags->{"S5.57.1", "1.11"}]},
  "1.12"->{
    Cell[13621, 433, 221, 5, 70, "MathCaption",
      CellTags->{"S5.57.1", "1.12"}]},
  "1.13"->{
    Cell[14110, 453, 176, 4, 70, "MathCaption",
      CellTags->{"S5.57.1", "1.13"}]},
  "1.14"->{
    Cell[14887, 478, 142, 4, 70, "MathCaption",
      CellTags->{"S5.57.1", "1.14"}]},
  "1.15"->{
    Cell[16336, 513, 578, 13, 70, "Text",
      CellTags->{"S5.57.1", "1.15"}]},
  "1.16"->{
    Cell[16917, 528, 251, 5, 70, "Text",
      CellTags->{"S5.57.1", "1.16"}]},
  "1.17"->{
    Cell[17171, 535, 198, 7, 70, "MathCaption",
      CellTags->{"S5.57.1", "1.17"}]},
  "1.18"->{
    Cell[17620, 556, 83, 1, 70, "MathCaption",
      CellTags->{"S5.57.1", "1.18"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.57.1", 18600, 590},
  {"1.1", 22015, 681},
  {"1.2", 22109, 684},
  {"1.3", 22197, 687},
  {"1.4", 22285, 690},
  {"1.5", 22374, 693},
  {"1.6", 22469, 696},
  {"1.7", 22565, 699},
  {"1.8", 22661, 702},
  {"1.9", 22751, 705},
  {"1.10", 22849, 708},
  {"1.11", 22948, 711},
  {"1.12", 23047, 714},
  {"1.13", 23146, 717},
  {"1.14", 23245, 720},
  {"1.15", 23344, 723},
  {"1.16", 23437, 726},
  {"1.17", 23529, 729},
  {"1.18", 23628, 732}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 135, 6, 36, "Subsection",
  CellTags->{"S5.57.1", "1.1"}],
Cell[1914, 61, 379, 8, 56, "Text",
  CellTags->{"S5.57.1", "1.2"}],
Cell[2296, 71, 312, 6, 56, "Text",
  CellTags->{"S5.57.1", "1.3"}],
Cell[2611, 79, 2104, 64, 82, "DefinitionBox",
  CellTags->"S5.57.1"],
Cell[4718, 145, 59, 1, 15, "Caption",
  CellTags->"S5.57.1"],
Cell[4780, 148, 224, 5, 40, "Text",
  CellTags->{"S5.57.1", "1.4"}],
Cell[5007, 155, 78, 1, 40, "MathCaption",
  CellTags->{"S5.57.1", "1.5"}],
Cell[5088, 158, 86, 2, 28, "Input",
  CellTags->"S5.57.1"],
Cell[5177, 162, 214, 5, 56, "MathCaption",
  CellTags->{"S5.57.1", "1.6"}],

Cell[CellGroupData[{
Cell[5416, 171, 95, 2, 28, "Input",
  CellTags->"S5.57.1"],
Cell[5514, 175, 79, 2, 27, "Output",
  CellTags->"S5.57.1"]
}, Open  ]],
Cell[5608, 180, 178, 4, 56, "MathCaption",
  CellTags->{"S5.57.1", "1.7"}],

Cell[CellGroupData[{
Cell[5811, 188, 107, 2, 28, "Input",
  CellTags->"S5.57.1"],
Cell[5921, 192, 79, 2, 27, "Output",
  CellTags->"S5.57.1"]
}, Open  ]],
Cell[6015, 197, 2285, 60, 150, "DefinitionBox",
  CellTags->"S5.57.1"],
Cell[8303, 259, 85, 1, 70, "Caption",
  CellTags->"S5.57.1"],
Cell[8391, 262, 2906, 87, 70, "DefinitionBox",
  CellTags->"S5.57.1"],
Cell[11300, 351, 77, 1, 70, "Caption",
  CellTags->"S5.57.1"],
Cell[11380, 354, 216, 7, 70, "Text",
  CellTags->{"S5.57.1", "1.8"}],
Cell[11599, 363, 170, 4, 70, "MathCaption",
  CellTags->{"S5.57.1", "1.9"}],

Cell[CellGroupData[{
Cell[11794, 371, 92, 2, 70, "Input",
  CellTags->"S5.57.1"],
Cell[11889, 375, 156, 5, 70, "Output",
  CellTags->"S5.57.1"]
}, Open  ]],
Cell[12060, 383, 197, 4, 70, "MathCaption",
  CellTags->{"S5.57.1", "1.10"}],

Cell[CellGroupData[{
Cell[12282, 391, 106, 2, 70, "Input",
  CellTags->"S5.57.1"],
Cell[12391, 395, 443, 9, 70, "Output",
  CellTags->"S5.57.1"]
}, Open  ]],
Cell[12849, 407, 189, 5, 70, "MathCaption",
  CellTags->{"S5.57.1", "1.11"}],

Cell[CellGroupData[{
Cell[13063, 416, 82, 2, 70, "Input",
  CellTags->"S5.57.1"],
Cell[13148, 420, 458, 10, 70, "Output",
  CellTags->"S5.57.1"]
}, Open  ]],
Cell[13621, 433, 221, 5, 70, "MathCaption",
  CellTags->{"S5.57.1", "1.12"}],

Cell[CellGroupData[{
Cell[13867, 442, 85, 2, 70, "Input",
  CellTags->"S5.57.1"],
Cell[13955, 446, 140, 4, 70, "Output",
  CellTags->"S5.57.1"]
}, Open  ]],
Cell[14110, 453, 176, 4, 70, "MathCaption",
  CellTags->{"S5.57.1", "1.13"}],

Cell[CellGroupData[{
Cell[14311, 461, 101, 2, 70, "Input",
  CellTags->"S5.57.1"],
Cell[14415, 465, 457, 10, 70, "Output",
  CellTags->"S5.57.1"]
}, Open  ]],
Cell[14887, 478, 142, 4, 70, "MathCaption",
  CellTags->{"S5.57.1", "1.14"}],

Cell[CellGroupData[{
Cell[15054, 486, 107, 2, 70, "Input",
  CellTags->"S5.57.1"],
Cell[15164, 490, 1157, 20, 70, "Output",
  CellTags->"S5.57.1"]
}, Open  ]],
Cell[16336, 513, 578, 13, 70, "Text",
  CellTags->{"S5.57.1", "1.15"}],
Cell[16917, 528, 251, 5, 70, "Text",
  CellTags->{"S5.57.1", "1.16"}],
Cell[17171, 535, 198, 7, 70, "MathCaption",
  CellTags->{"S5.57.1", "1.17"}],

Cell[CellGroupData[{
Cell[17394, 546, 94, 2, 70, "Input",
  CellTags->"S5.57.1"],
Cell[17491, 550, 114, 3, 70, "Output",
  CellTags->"S5.57.1"]
}, Open  ]],
Cell[17620, 556, 83, 1, 70, "MathCaption",
  CellTags->{"S5.57.1", "1.18"}],

Cell[CellGroupData[{
Cell[17728, 561, 138, 5, 70, "Input",
  CellTags->"S5.57.1"],
Cell[17869, 568, 80, 2, 70, "Output",
  CellTags->"S5.57.1"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

