(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     10249,        338]*)
(*NotebookOutlinePosition[     13262,        433]*)
(*  CellTagsIndexPosition[     13005,        419]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "NumericalMath",
 StyleBox["`", "MB"],
 "NIntegrateInterpolatingFunct",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.86.1", "1.1"}],

Cell[TextData[{
 "The ",
 StyleBox["Mathematica", "TI"],
 " function ",
 StyleBox["NIntegrate", "MR"],
 " uses algorithms that assume that the integrand is smooth to at least \
several orders. ",
 StyleBox["InterpolatingFunction", "MR"],
 " objects typically do not satisfy this assumption; they are continuous, but \
only piecewise smooth. The algorithms used by ",
 StyleBox["NIntegrate", "MR"],
 " converge very slowly when applied to ",
 StyleBox["InterpolatingFunction", "MR"],
 " objects, especially in several dimensions. ",
 StyleBox["NIntegrate", "MR"],
 " allows the domain of integration to be broken up into several pieces and \
the integral evaluated over each piece. If the pieces of the domain \
correspond to the pieces over which the ",
 StyleBox["InterpolatingFunction", "MR"],
 " is smooth, ",
 StyleBox["NIntegrate", "MR"],
 " will converge much more rapidly. ",
 StyleBox["NIntegrateInterpolatingFunction", "MR"],
 " automatically breaks up the domain of integration. "
}], "Text",
 CellTags->{"S5.86.1", "1.2"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["NIntegrateInterpolatingFunction[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xmin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xmax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["find a numerical approximation to an integral with ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["InterpolatingFunction", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" objects in the integrand",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["NIntegrateInterpolatingFunction[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xmin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xmax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["y", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ymin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ymax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, \[Ellipsis] ]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "find a numerical approximation to a multidimensional integral with ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["InterpolatingFunction", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" objects in the integrand",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.86.1"],

Cell[TextData[{
 "Numerical approximations to integrals with ",
 StyleBox["InterpolatingFunction", "MR"],
 " objects in the integrand. "
}], "Caption",
 CellTags->"S5.86.1"],

Cell[TextData[{
 StyleBox["NIntegrateInterpolatingFunction", "MR"],
 " uses the function ",
 StyleBox["NIntegrate", "MR"],
 ", but it breaks up the domain into sections where the ",
 StyleBox["InterpolatingFunction", "MR"],
 " object is smooth. "
}], "Text",
 CellTags->{"S5.86.1", "1.3"}],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.86.1", "1.4"}],

Cell["<<NumericalMath`NIntegrateInterpolatingFunct`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.86.1"],

Cell[TextData[{
 "This creates an ",
 StyleBox["InterpolatingFunction", "MR"],
 " object approximating an oscillatory function in two dimensions. "
}], "MathCaption",
 CellTags->{"S5.86.1", "1.5"}],

Cell[CellGroupData[{

Cell["\<\
sin = Interpolation[
    Flatten[Table[{x, y, Sin[x y]},
                  {x, 0, 4, .5}, {y, 0, 4, 0.5}],
            1]]\
\>", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.86.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0.`", ",", "4.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.`", ",", "4.`"}], "}"}]}], "}"}], ",", "\<\"<>\"\>"}], 
   "]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.86.1"]
}, Open  ]],

Cell["\<\
This list gives the time used to evaluate the integral plus the result of the \
integral. \
\>", "MathCaption",
 CellTags->{"S5.86.1", "1.6"}],

Cell[CellGroupData[{

Cell["\<\
NIntegrateInterpolatingFunction[sin[y^2, x^2]^2,
    {x, 0, 2}, {y, 0, 2}] // Timing\
\>", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.86.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1.25`", " ", "Second"}], ",", "1.2233227547415957`"}], 
  "}"}]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.86.1"]
}, Open  ]],

Cell[TextData[{
 StyleBox["NIntegrate", "MR"],
 " produces almost exactly the same result, but takes much longer because the \
convergence is poor if the domain is not properly broken up. "
}], "MathCaption",
 CellTags->{"S5.86.1", "1.7"}],

Cell[CellGroupData[{

Cell["\<\
NIntegrate[sin[y^2, x^2]^2,
    {x, 0, 2}, {y, 0, 2}] // Timing\
\>", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.86.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"slwcon\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Numerical integration converging too slowly; suspect one \
of the following: singularity, value of the integration being 0, oscillatory \
integrand, or insufficient WorkingPrecision. If your integrand is oscillatory \
try using the option Method->Oscillatory in NIntegrate.\"\>"}]], "Message",
 CellTags->"S5.86.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"4.57`", " ", "Second"}], ",", "1.223322525150588`"}], 
  "}"}]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.86.1"]
}, Open  ]],

Cell[TextData[{
 "If you simply need to find the integral of an ",
 StyleBox["InterpolatingFunction", "MR"],
 " object (as opposed to a function of one), it is better to use ",
 StyleBox["Integrate", "MR"],
 " because this gives you the result which is exact for the polynomial \
approximation used in the ",
 StyleBox["InterpolatingFunction", "MR"],
 " object. "
}], "Text",
 CellTags->{"S5.86.1", "1.8"}]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.86.1"->{
    Cell[1776, 53, 158, 6, 36, "Subsection",
      CellTags->{"S5.86.1", "1.1"}],
    Cell[1937, 61, 1033, 25, 136, "Text",
      CellTags->{"S5.86.1", "1.2"}],
    Cell[2973, 88, 3858, 117, 120, "DefinitionBox",
      CellTags->"S5.86.1"],
    Cell[6834, 207, 173, 5, 15, "Caption",
      CellTags->"S5.86.1"],
    Cell[7010, 214, 289, 8, 40, "Text",
      CellTags->{"S5.86.1", "1.3"}],
    Cell[7302, 224, 78, 1, 40, "MathCaption",
      CellTags->{"S5.86.1", "1.4"}],
    Cell[7383, 227, 108, 2, 28, "Input",
      CellTags->"S5.86.1"],
    Cell[7494, 231, 197, 5, 56, "MathCaption",
      CellTags->{"S5.86.1", "1.5"}],
    Cell[7716, 240, 193, 7, 79, "Input",
      CellTags->"S5.86.1"],
    Cell[7912, 249, 366, 14, 25, "Output",
      CellTags->"S5.86.1"],
    Cell[8293, 266, 152, 4, 40, "MathCaption",
      CellTags->{"S5.86.1", "1.6"}],
    Cell[8470, 274, 155, 5, 45, "Input",
      CellTags->"S5.86.1"],
    Cell[8628, 281, 173, 6, 70, "Output",
      CellTags->"S5.86.1"],
    Cell[8816, 290, 239, 5, 70, "MathCaption",
      CellTags->{"S5.86.1", "1.7"}],
    Cell[9080, 299, 134, 5, 70, "Input",
      CellTags->"S5.86.1"],
    Cell[9217, 306, 420, 8, 70, "Message",
      CellTags->"S5.86.1"],
    Cell[9640, 316, 172, 6, 70, "Output",
      CellTags->"S5.86.1"],
    Cell[9827, 325, 406, 10, 70, "Text",
      CellTags->{"S5.86.1", "1.8"}]},
  "1.1"->{
    Cell[1776, 53, 158, 6, 36, "Subsection",
      CellTags->{"S5.86.1", "1.1"}]},
  "1.2"->{
    Cell[1937, 61, 1033, 25, 136, "Text",
      CellTags->{"S5.86.1", "1.2"}]},
  "1.3"->{
    Cell[7010, 214, 289, 8, 40, "Text",
      CellTags->{"S5.86.1", "1.3"}]},
  "1.4"->{
    Cell[7302, 224, 78, 1, 40, "MathCaption",
      CellTags->{"S5.86.1", "1.4"}]},
  "1.5"->{
    Cell[7494, 231, 197, 5, 56, "MathCaption",
      CellTags->{"S5.86.1", "1.5"}]},
  "1.6"->{
    Cell[8293, 266, 152, 4, 40, "MathCaption",
      CellTags->{"S5.86.1", "1.6"}]},
  "1.7"->{
    Cell[8816, 290, 239, 5, 70, "MathCaption",
      CellTags->{"S5.86.1", "1.7"}]},
  "1.8"->{
    Cell[9827, 325, 406, 10, 70, "Text",
      CellTags->{"S5.86.1", "1.8"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.86.1", 10872, 354},
  {"1.1", 12244, 391},
  {"1.2", 12338, 394},
  {"1.3", 12429, 397},
  {"1.4", 12518, 400},
  {"1.5", 12613, 403},
  {"1.6", 12709, 406},
  {"1.7", 12805, 409},
  {"1.8", 12901, 412}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 158, 6, 36, "Subsection",
  CellTags->{"S5.86.1", "1.1"}],
Cell[1937, 61, 1033, 25, 136, "Text",
  CellTags->{"S5.86.1", "1.2"}],
Cell[2973, 88, 3858, 117, 120, "DefinitionBox",
  CellTags->"S5.86.1"],
Cell[6834, 207, 173, 5, 15, "Caption",
  CellTags->"S5.86.1"],
Cell[7010, 214, 289, 8, 40, "Text",
  CellTags->{"S5.86.1", "1.3"}],
Cell[7302, 224, 78, 1, 40, "MathCaption",
  CellTags->{"S5.86.1", "1.4"}],
Cell[7383, 227, 108, 2, 28, "Input",
  CellTags->"S5.86.1"],
Cell[7494, 231, 197, 5, 56, "MathCaption",
  CellTags->{"S5.86.1", "1.5"}],

Cell[CellGroupData[{
Cell[7716, 240, 193, 7, 79, "Input",
  CellTags->"S5.86.1"],
Cell[7912, 249, 366, 14, 25, "Output",
  CellTags->"S5.86.1"]
}, Open  ]],
Cell[8293, 266, 152, 4, 40, "MathCaption",
  CellTags->{"S5.86.1", "1.6"}],

Cell[CellGroupData[{
Cell[8470, 274, 155, 5, 45, "Input",
  CellTags->"S5.86.1"],
Cell[8628, 281, 173, 6, 70, "Output",
  CellTags->"S5.86.1"]
}, Open  ]],
Cell[8816, 290, 239, 5, 70, "MathCaption",
  CellTags->{"S5.86.1", "1.7"}],

Cell[CellGroupData[{
Cell[9080, 299, 134, 5, 70, "Input",
  CellTags->"S5.86.1"],
Cell[9217, 306, 420, 8, 70, "Message",
  CellTags->"S5.86.1"],
Cell[9640, 316, 172, 6, 70, "Output",
  CellTags->"S5.86.1"]
}, Open  ]],
Cell[9827, 325, 406, 10, 70, "Text",
  CellTags->{"S5.86.1", "1.8"}]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

