(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     32422,       1063]*)
(*NotebookOutlinePosition[     38636,       1248]*)
(*  CellTagsIndexPosition[     38171,       1226]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "NumericalMath",
 StyleBox["`", "MB"],
 "NLimit",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.87.1", "1.1"}],

Cell[TextData[{
 "The built\[Hyphen]in function ",
 StyleBox["Limit", "MR"],
 " computes limits using symbolic and analytic methods. The function ",
 StyleBox["NLimit", "MR"],
 " contained in this package works by numerically evaluating a short sequence \
of function values as the argument approaches the specified point. The result \
of this calculation is passed to a routine that uses either Wynn\
\[CloseCurlyQuote]s ",
 Cell[BoxData[
  FormBox["\[Epsilon]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "\[Hyphen]algorithm or a generalized Euler transformation to find an \
approximation to the limit. "
}], "Text",
 CellTags->{"S5.87.1", "1.2"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["NLimit[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" -> ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "0"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["numerically find the limit as ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" approaches ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "0"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.87.1"],

Cell["Computing numerical limits. ", "Caption",
 CellTags->"S5.87.1"],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.87.1", "1.3"}],

Cell["<<NumericalMath`NLimit`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.87.1"],

Cell["Here is the numerical computation of a limit. ", "MathCaption",
 CellTags->{"S5.87.1", "1.4"}],

Cell[CellGroupData[{

Cell["NLimit[Zeta[s] - 1/(s-1), s->1]", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.87.1"],

Cell[BoxData["0.577215659504251`"], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.87.1"]
}, Open  ]],

Cell["\<\
The limit gives the number known as Euler\[CloseCurlyQuote]s gamma. \
\>", "MathCaption",
 CellTags->{"S5.87.1", "1.5"}],

Cell[CellGroupData[{

Cell["N[EulerGamma]", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.87.1"],

Cell[BoxData["0.5772156649015329`"], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.87.1"]
}, Open  ]],

Cell[TextData[{
 "You can also compute limits as ",
 Cell[BoxData[
  FormBox[
   StyleBox["x",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " approaches infinity. "
}], "MathCaption",
 CellTags->{"S5.87.1", "1.6"}],

Cell[CellGroupData[{

Cell["\<\
NLimit[(2 x^3 +  Sin[x])/(5 x^3 + Log[x]),
 x->Infinity]\
\>", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.87.1"],

Cell[BoxData["0.3999999999999999`"], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.87.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["option name", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["default value", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox["",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["WorkingPrecision", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["MachinePrecision", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "number of digits of precision to be used ",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Scale", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["1", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox["initial step size ",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Terms", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["7", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "total number of terms generated in the sequence ",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Method", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["EulerSum", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["method of evaluation, either ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["EulerSum", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" or ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["SequenceLimit", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["WynnDegree", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["1", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "degree to use in the Wynn method",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
 GridBoxOptions->{RowLines->{True, False},
 RowSpacings->0.4},
 CellTags->"S5.87.1"],

Cell[TextData[{
 "Options for ",
 StyleBox["NLimit", "MR"],
 "."
}], "Caption",
 CellTags->"S5.87.1"],

Cell[TextData[{
 "There are many specialized techniques for accelerating the convergence of a \
series. Faster convergence means that in a numerical evaluation fewer terms \
are needed to give a result of the desired accuracy. One such technique, \
Euler\[CloseCurlyQuote]s transformation, is used by ",
 StyleBox["EulerSum", "MR"],
 ". "
}], "Text",
 CellTags->{"S5.87.1", "1.7"}],

Cell[TextData[{
 StyleBox["EulerSum", "MR"],
 " is particularly good for working with alternating series and series whose \
terms have the form ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["p",
     "TI"], 
    RowBox[{"(", 
     StyleBox["n",
      "TI"], ")"}], 
    SuperscriptBox[
     StyleBox["r",
      "TI"], 
     StyleBox["n",
      "TI"]]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " where ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["p",
     "TI"], 
    RowBox[{"(", 
     StyleBox["n",
      "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is a polynomial in ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". It is a useful adjunct to the built\[Hyphen]in ",
 StyleBox["NSum", "MR"],
 ", which is designed to be an effective general case algorithm. "
}], "Text",
 CellTags->{"S5.87.1", "1.8"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["EulerSum[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["i", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["imin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", Infinity}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "use Euler\[CloseCurlyQuote]s transformation to numerically evaluate ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         UnderoverscriptBox["\[Sum]", 
          StyleBox["imin",
           "TI"], "\[Infinity]",
          LimitsPositioning->True], " ", 
         StyleBox["f",
          "TI"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.87.1"],

Cell["\<\
Numerical evaluation of sums using Euler\[CloseCurlyQuote]s transformation. \
\>", "Caption",
 CellTags->"S5.87.1"],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["option name", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["default value", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox["",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["WorkingPrecision", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["MachinePrecision", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "number of digits of precision to be used ",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Terms", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["5", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "total number of terms generated before extrapolation ",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ExtraTerms", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["7", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "number of terms to be used in the extrapolation process; must be at \
least 2",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["EulerRatio", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Automatic", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "the fixed ratio to be used in the transformation ",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
 GridBoxOptions->{RowLines->{True, False},
 RowSpacings->0.4},
 CellTags->"S5.87.1"],

Cell[TextData[{
 "Options for ",
 StyleBox["EulerSum", "MR"],
 "."
}], "Caption",
 CellTags->"S5.87.1"],

Cell[TextData[{
 "This uses ",
 StyleBox["EulerSum", "MR"],
 " to compute a numerical approximation to the sum of an alternating series. \
"
}], "MathCaption",
 CellTags->{"S5.87.1", "1.9"}],

Cell[CellGroupData[{

Cell["EulerSum[(-1)^k/(2k + 1), {k, 0, Infinity}]", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.87.1"],

Cell[BoxData["0.7853983570594825`"], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S5.87.1"]
}, Open  ]],

Cell["\<\
Increasing the precision and the number of terms does not change the answer \
in the first six decimal places. This provides a check on the accuracy of the \
numerically computed result. \
\>", "MathCaption",
 CellTags->{"S5.87.1", "1.10"}],

Cell[CellGroupData[{

Cell["\<\
EulerSum[(-1)^k/(2k + 1), {k, 0, Infinity},
 WorkingPrecision->40, Terms->30,
 ExtraTerms->30]\
\>", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.87.1"],

Cell[BoxData["0.785398163397448309615660845791303225402456063807378793771`39.\
14491374808192"], "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S5.87.1"]
}, Open  ]],

Cell["\<\
The result is also in good agreement with the known exact result. \
\>", "MathCaption",
 CellTags->{"S5.87.1", "1.11"}],

Cell[CellGroupData[{

Cell["% - N[Pi/4, 40]", "Input",
 CellLabel->"In[7]:= ",
 CellTags->"S5.87.1"],

Cell[BoxData[
 RowBox[{"-", 
  "2.8572495646836286036397661475`10.649016130894474*^-29"}]], "Output",
 CellLabel->"Out[7]= ",
 CellTags->"S5.87.1"]
}, Open  ]],

Cell[TextData[{
 "There are occasionally instances in which it is difficult or impossible to \
analytically compute the derivative of a function. In these cases you can \
compute the derivative using the function ",
 StyleBox["ND", "MR"],
 " instead of the built\[Hyphen]in function ",
 StyleBox["D", "MR"],
 ". "
}], "Text",
 CellTags->{"S5.87.1", "1.12"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["ND[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "0"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give a numerical approximation to ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        FractionBox[
         RowBox[{"\[PartialD]", 
          StyleBox["f",
           "TI"]}], 
         RowBox[{"\[PartialD]", 
          StyleBox["x",
           "TI"]}]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" evaluated at the point\[NonBreakingSpace]",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "0"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ND[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "0"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SuperscriptBox[
         StyleBox["n",
          "TI"], "th"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" derivative",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.87.1"],

Cell["Numerical computation of derivatives. ", "Caption",
 CellTags->"S5.87.1"],

Cell[TextData[{
 "Here is a numerical approximation of the derivative of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["e",
     "TI"], 
    RowBox[{"sin", 
     RowBox[{"(", 
      StyleBox["x",
       "TI"], ")"}]}]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " at ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["x",
     "TI"], "=", "2"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.87.1", "1.13"}],

Cell[CellGroupData[{

Cell["ND[Exp[Sin[x]], x, 2]", "Input",
 CellLabel->"In[8]:= ",
 CellTags->"S5.87.1"],

Cell[BoxData[
 RowBox[{"-", "1.0331168751058337`"}]], "Output",
 CellLabel->"Out[8]= ",
 CellTags->"S5.87.1"]
}, Open  ]],

Cell[TextData[{
 "After increasing the setting of the option ",
 StyleBox["Terms", "MR"],
 ", the difference between the symbolically computed result and the numerical \
result for a third derivative is quite small. "
}], "MathCaption",
 CellTags->{"S5.87.1", "1.14"}],

Cell[CellGroupData[{

Cell["\<\
ND[Exp[Sin[x]], {x, 3}, 2, Terms->10] -
    N[D[Exp[Sin[x]], {x, 3}] /. x->2]\
\>", "Input",
 CellLabel->"In[9]:= ",
 CellTags->"S5.87.1"],

Cell[BoxData["2.2398865340278462`*^-7"], "Output",
 CellLabel->"Out[9]= ",
 CellTags->"S5.87.1"]
}, Open  ]],

Cell["\<\
This is the error in the numerical derivative using Cauchy\[CloseCurlyQuote]s \
integral formula. \
\>", "MathCaption",
 CellTags->{"S5.87.1", "1.15"}],

Cell[CellGroupData[{

Cell["\<\
ND[Exp[Sin[x]], {x, 3}, 2, Method -> NIntegrate] -
    N[D[Exp[Sin[x]], {x, 3}] /. x->2]\
\>", "Input",
 CellLabel->"In[10]:= ",
 CellTags->"S5.87.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1.3322676295501878`*^-13"}], "+", 
  RowBox[{"1.706967900361178`*^-15", " ", "\[ImaginaryI]"}]}]], "Output",
 CellLabel->"Out[10]= ",
 CellTags->"S5.87.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["option name", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["default value", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox["",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["WorkingPrecision", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["MachinePrecision", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "number of digits of precision to be used",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Scale", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["1", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "size of steps in the evaluation ",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Terms", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["7", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "total number of terms generated in the sequence ",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Method", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["EulerSum", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["method of evaluation, either ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["EulerSum", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" (numerical limit of difference quotients) or ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["NIntegrate", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" (Cauchy\[CloseCurlyQuote]s integral formula) ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
 GridBoxOptions->{RowLines->{True, False},
 RowSpacings->0.4},
 CellTags->"S5.87.1"],

Cell[TextData[{
 "Options for ",
 StyleBox["ND", "MR"],
 "."
}], "Caption",
 CellTags->"S5.87.1"],

Cell[TextData[{
 "You should realize that with sufficiently pathological examples, the \
algorithms used for ",
 StyleBox["EulerSum", "MR"],
 ", ",
 StyleBox["NLimit", "MR"],
 ", or ",
 StyleBox["ND", "MR"],
 " can give wrong answers. In most cases, you can test your answer by looking \
at the sensitivity to changes in the setting of options. "
}], "Text",
 CellTags->{"S5.87.1", "1.16"}]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.87.1"->{
    Cell[1776, 53, 136, 6, 36, "Subsection",
      CellTags->{"S5.87.1", "1.1"}],
    Cell[1915, 61, 690, 15, 88, "Text",
      CellTags->{"S5.87.1", "1.2"}],
    Cell[2608, 78, 1885, 59, 46, "DefinitionBox",
      CellTags->"S5.87.1"],
    Cell[4496, 139, 69, 1, 15, "Caption",
      CellTags->"S5.87.1"],
    Cell[4568, 142, 78, 1, 40, "MathCaption",
      CellTags->{"S5.87.1", "1.3"}],
    Cell[4649, 145, 86, 2, 28, "Input",
      CellTags->"S5.87.1"],
    Cell[4738, 149, 100, 1, 40, "MathCaption",
      CellTags->{"S5.87.1", "1.4"}],
    Cell[4863, 154, 94, 2, 28, "Input",
      CellTags->"S5.87.1"],
    Cell[4960, 158, 91, 2, 25, "Output",
      CellTags->"S5.87.1"],
    Cell[5066, 163, 130, 3, 40, "MathCaption",
      CellTags->{"S5.87.1", "1.5"}],
    Cell[5221, 170, 76, 2, 28, "Input",
      CellTags->"S5.87.1"],
    Cell[5300, 174, 92, 2, 25, "Output",
      CellTags->"S5.87.1"],
    Cell[5407, 179, 263, 9, 40, "MathCaption",
      CellTags->{"S5.87.1", "1.6"}],
    Cell[5695, 192, 127, 5, 45, "Input",
      CellTags->"S5.87.1"],
    Cell[5825, 199, 92, 2, 23, "Output",
      CellTags->"S5.87.1"],
    Cell[5932, 204, 5523, 161, 206, "DefinitionBox3Col",
      CellTags->"S5.87.1"],
    Cell[11458, 367, 101, 5, 70, "Caption",
      CellTags->"S5.87.1"],
    Cell[11562, 374, 381, 8, 70, "Text",
      CellTags->{"S5.87.1", "1.7"}],
    Cell[11946, 384, 1015, 38, 70, "Text",
      CellTags->{"S5.87.1", "1.8"}],
    Cell[12964, 424, 1795, 56, 70, "DefinitionBox",
      CellTags->"S5.87.1"],
    Cell[14762, 482, 125, 3, 70, "Caption",
      CellTags->"S5.87.1"],
    Cell[14890, 487, 4373, 126, 70, "DefinitionBox3Col",
      CellTags->"S5.87.1"],
    Cell[19266, 615, 103, 5, 70, "Caption",
      CellTags->"S5.87.1"],
    Cell[19372, 622, 190, 6, 70, "MathCaption",
      CellTags->{"S5.87.1", "1.9"}],
    Cell[19587, 632, 106, 2, 70, "Input",
      CellTags->"S5.87.1"],
    Cell[19696, 636, 92, 2, 70, "Output",
      CellTags->"S5.87.1"],
    Cell[19803, 641, 250, 5, 70, "MathCaption",
      CellTags->{"S5.87.1", "1.10"}],
    Cell[20078, 650, 165, 6, 70, "Input",
      CellTags->"S5.87.1"],
    Cell[20246, 658, 152, 3, 70, "Output",
      CellTags->"S5.87.1"],
    Cell[20413, 664, 129, 3, 70, "MathCaption",
      CellTags->{"S5.87.1", "1.11"}],
    Cell[20567, 671, 78, 2, 70, "Input",
      CellTags->"S5.87.1"],
    Cell[20648, 675, 147, 4, 70, "Output",
      CellTags->"S5.87.1"],
    Cell[20810, 682, 357, 9, 70, "Text",
      CellTags->{"S5.87.1", "1.12"}],
    Cell[21170, 693, 3959, 124, 70, "DefinitionBox",
      CellTags->"S5.87.1"],
    Cell[25132, 819, 79, 1, 70, "Caption",
      CellTags->"S5.87.1"],
    Cell[25214, 822, 544, 21, 70, "MathCaption",
      CellTags->{"S5.87.1", "1.13"}],
    Cell[25783, 847, 84, 2, 70, "Input",
      CellTags->"S5.87.1"],
    Cell[25870, 851, 109, 3, 70, "Output",
      CellTags->"S5.87.1"],
    Cell[25994, 857, 268, 6, 70, "MathCaption",
      CellTags->{"S5.87.1", "1.14"}],
    Cell[26287, 867, 148, 5, 70, "Input",
      CellTags->"S5.87.1"],
    Cell[26438, 874, 96, 2, 70, "Output",
      CellTags->"S5.87.1"],
    Cell[26549, 879, 161, 4, 70, "MathCaption",
      CellTags->{"S5.87.1", "1.15"}],
    Cell[26735, 887, 160, 5, 70, "Input",
      CellTags->"S5.87.1"],
    Cell[26898, 894, 195, 5, 70, "Output",
      CellTags->"S5.87.1"],
    Cell[27108, 902, 4805, 138, 70, "DefinitionBox3Col",
      CellTags->"S5.87.1"],
    Cell[31916, 1042, 97, 5, 70, "Caption",
      CellTags->"S5.87.1"],
    Cell[32016, 1049, 390, 11, 70, "Text",
      CellTags->{"S5.87.1", "1.16"}]},
  "1.1"->{
    Cell[1776, 53, 136, 6, 36, "Subsection",
      CellTags->{"S5.87.1", "1.1"}]},
  "1.2"->{
    Cell[1915, 61, 690, 15, 88, "Text",
      CellTags->{"S5.87.1", "1.2"}]},
  "1.3"->{
    Cell[4568, 142, 78, 1, 40, "MathCaption",
      CellTags->{"S5.87.1", "1.3"}]},
  "1.4"->{
    Cell[4738, 149, 100, 1, 40, "MathCaption",
      CellTags->{"S5.87.1", "1.4"}]},
  "1.5"->{
    Cell[5066, 163, 130, 3, 40, "MathCaption",
      CellTags->{"S5.87.1", "1.5"}]},
  "1.6"->{
    Cell[5407, 179, 263, 9, 40, "MathCaption",
      CellTags->{"S5.87.1", "1.6"}]},
  "1.7"->{
    Cell[11562, 374, 381, 8, 70, "Text",
      CellTags->{"S5.87.1", "1.7"}]},
  "1.8"->{
    Cell[11946, 384, 1015, 38, 70, "Text",
      CellTags->{"S5.87.1", "1.8"}]},
  "1.9"->{
    Cell[19372, 622, 190, 6, 70, "MathCaption",
      CellTags->{"S5.87.1", "1.9"}]},
  "1.10"->{
    Cell[19803, 641, 250, 5, 70, "MathCaption",
      CellTags->{"S5.87.1", "1.10"}]},
  "1.11"->{
    Cell[20413, 664, 129, 3, 70, "MathCaption",
      CellTags->{"S5.87.1", "1.11"}]},
  "1.12"->{
    Cell[20810, 682, 357, 9, 70, "Text",
      CellTags->{"S5.87.1", "1.12"}]},
  "1.13"->{
    Cell[25214, 822, 544, 21, 70, "MathCaption",
      CellTags->{"S5.87.1", "1.13"}]},
  "1.14"->{
    Cell[25994, 857, 268, 6, 70, "MathCaption",
      CellTags->{"S5.87.1", "1.14"}]},
  "1.15"->{
    Cell[26549, 879, 161, 4, 70, "MathCaption",
      CellTags->{"S5.87.1", "1.15"}]},
  "1.16"->{
    Cell[32016, 1049, 390, 11, 70, "Text",
      CellTags->{"S5.87.1", "1.16"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.87.1", 33045, 1079},
  {"1.1", 36630, 1174},
  {"1.2", 36724, 1177},
  {"1.3", 36813, 1180},
  {"1.4", 36908, 1183},
  {"1.5", 37004, 1186},
  {"1.6", 37100, 1189},
  {"1.7", 37196, 1192},
  {"1.8", 37286, 1195},
  {"1.9", 37378, 1198},
  {"1.10", 37476, 1201},
  {"1.11", 37575, 1204},
  {"1.12", 37674, 1207},
  {"1.13", 37766, 1210},
  {"1.14", 37866, 1213},
  {"1.15", 37965, 1216},
  {"1.16", 38064, 1219}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 136, 6, 36, "Subsection",
  CellTags->{"S5.87.1", "1.1"}],
Cell[1915, 61, 690, 15, 88, "Text",
  CellTags->{"S5.87.1", "1.2"}],
Cell[2608, 78, 1885, 59, 46, "DefinitionBox",
  CellTags->"S5.87.1"],
Cell[4496, 139, 69, 1, 15, "Caption",
  CellTags->"S5.87.1"],
Cell[4568, 142, 78, 1, 40, "MathCaption",
  CellTags->{"S5.87.1", "1.3"}],
Cell[4649, 145, 86, 2, 28, "Input",
  CellTags->"S5.87.1"],
Cell[4738, 149, 100, 1, 40, "MathCaption",
  CellTags->{"S5.87.1", "1.4"}],

Cell[CellGroupData[{
Cell[4863, 154, 94, 2, 28, "Input",
  CellTags->"S5.87.1"],
Cell[4960, 158, 91, 2, 25, "Output",
  CellTags->"S5.87.1"]
}, Open  ]],
Cell[5066, 163, 130, 3, 40, "MathCaption",
  CellTags->{"S5.87.1", "1.5"}],

Cell[CellGroupData[{
Cell[5221, 170, 76, 2, 28, "Input",
  CellTags->"S5.87.1"],
Cell[5300, 174, 92, 2, 25, "Output",
  CellTags->"S5.87.1"]
}, Open  ]],
Cell[5407, 179, 263, 9, 40, "MathCaption",
  CellTags->{"S5.87.1", "1.6"}],

Cell[CellGroupData[{
Cell[5695, 192, 127, 5, 45, "Input",
  CellTags->"S5.87.1"],
Cell[5825, 199, 92, 2, 23, "Output",
  CellTags->"S5.87.1"]
}, Open  ]],
Cell[5932, 204, 5523, 161, 206, "DefinitionBox3Col",
  CellTags->"S5.87.1"],
Cell[11458, 367, 101, 5, 70, "Caption",
  CellTags->"S5.87.1"],
Cell[11562, 374, 381, 8, 70, "Text",
  CellTags->{"S5.87.1", "1.7"}],
Cell[11946, 384, 1015, 38, 70, "Text",
  CellTags->{"S5.87.1", "1.8"}],
Cell[12964, 424, 1795, 56, 70, "DefinitionBox",
  CellTags->"S5.87.1"],
Cell[14762, 482, 125, 3, 70, "Caption",
  CellTags->"S5.87.1"],
Cell[14890, 487, 4373, 126, 70, "DefinitionBox3Col",
  CellTags->"S5.87.1"],
Cell[19266, 615, 103, 5, 70, "Caption",
  CellTags->"S5.87.1"],
Cell[19372, 622, 190, 6, 70, "MathCaption",
  CellTags->{"S5.87.1", "1.9"}],

Cell[CellGroupData[{
Cell[19587, 632, 106, 2, 70, "Input",
  CellTags->"S5.87.1"],
Cell[19696, 636, 92, 2, 70, "Output",
  CellTags->"S5.87.1"]
}, Open  ]],
Cell[19803, 641, 250, 5, 70, "MathCaption",
  CellTags->{"S5.87.1", "1.10"}],

Cell[CellGroupData[{
Cell[20078, 650, 165, 6, 70, "Input",
  CellTags->"S5.87.1"],
Cell[20246, 658, 152, 3, 70, "Output",
  CellTags->"S5.87.1"]
}, Open  ]],
Cell[20413, 664, 129, 3, 70, "MathCaption",
  CellTags->{"S5.87.1", "1.11"}],

Cell[CellGroupData[{
Cell[20567, 671, 78, 2, 70, "Input",
  CellTags->"S5.87.1"],
Cell[20648, 675, 147, 4, 70, "Output",
  CellTags->"S5.87.1"]
}, Open  ]],
Cell[20810, 682, 357, 9, 70, "Text",
  CellTags->{"S5.87.1", "1.12"}],
Cell[21170, 693, 3959, 124, 70, "DefinitionBox",
  CellTags->"S5.87.1"],
Cell[25132, 819, 79, 1, 70, "Caption",
  CellTags->"S5.87.1"],
Cell[25214, 822, 544, 21, 70, "MathCaption",
  CellTags->{"S5.87.1", "1.13"}],

Cell[CellGroupData[{
Cell[25783, 847, 84, 2, 70, "Input",
  CellTags->"S5.87.1"],
Cell[25870, 851, 109, 3, 70, "Output",
  CellTags->"S5.87.1"]
}, Open  ]],
Cell[25994, 857, 268, 6, 70, "MathCaption",
  CellTags->{"S5.87.1", "1.14"}],

Cell[CellGroupData[{
Cell[26287, 867, 148, 5, 70, "Input",
  CellTags->"S5.87.1"],
Cell[26438, 874, 96, 2, 70, "Output",
  CellTags->"S5.87.1"]
}, Open  ]],
Cell[26549, 879, 161, 4, 70, "MathCaption",
  CellTags->{"S5.87.1", "1.15"}],

Cell[CellGroupData[{
Cell[26735, 887, 160, 5, 70, "Input",
  CellTags->"S5.87.1"],
Cell[26898, 894, 195, 5, 70, "Output",
  CellTags->"S5.87.1"]
}, Open  ]],
Cell[27108, 902, 4805, 138, 70, "DefinitionBox3Col",
  CellTags->"S5.87.1"],
Cell[31916, 1042, 97, 5, 70, "Caption",
  CellTags->"S5.87.1"],
Cell[32016, 1049, 390, 11, 70, "Text",
  CellTags->{"S5.87.1", "1.16"}]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

