(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     10543,        368]*)
(*NotebookOutlinePosition[     14118,        479]*)
(*  CellTagsIndexPosition[     13838,        464]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "NumericalMath",
 StyleBox["`", "MB"],
 "NResidue",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.88.1", "1.1"}],

Cell[TextData[{
 "The ",
 StyleBox["Mathematica", "TI"],
 " function ",
 StyleBox["Residue", "MR"],
 " symbolically finds the residue of an expression at a point in the complex \
plane. Because it is symbolic in nature it is sometimes unable to get a \
result. "
}], "Text",
 CellTags->{"S5.88.1", "1.2"}],

Cell[TextData[{
 StyleBox["NResidue", "MR"],
 " is the numerical version of ",
 StyleBox["Residue", "MR"],
 ". It works by numerically integrating around a small circle centered at the \
point at which the residue is being sought. The obvious problem with this \
approach is that it in fact finds the sum of the residues at all of the \
points contained within the circle. By making the radius of the circle \
sufficiently small you can exclude all singularities but the one in question. \
"
}], "Text",
 CellTags->{"S5.88.1", "1.3"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["NResidue[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "0"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["numerically find the residue of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" at the point ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" = ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "0"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.88.1"],

Cell["Numerical evaluation of residues. ", "Caption",
 CellTags->"S5.88.1"],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["Radius", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "specifies the radius of the circle around which the integration is \
performed ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["PrecisionGoal", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["the ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["PrecisionGoal", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" to be used by ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["NIntegrate", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["WorkingPrecision", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["the ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["WorkingPrecision", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" to be used by ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["NIntegrate", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.88.1"],

Cell[TextData[{
 "Options for ",
 StyleBox["NResidue", "MR"],
 ". "
}], "Caption",
 CellTags->"S5.88.1"],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.88.1", "1.4"}],

Cell["<<NumericalMath`NResidue`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.88.1"],

Cell[TextData[{
 "Find the residue of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "/", 
    StyleBox["z",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " at the origin. "
}], "MathCaption",
 CellTags->{"S5.88.1", "1.5"}],

Cell[CellGroupData[{

Cell["NResidue[1/z, {z, 0}]", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.88.1"],

Cell[BoxData["1.`"], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.88.1"]
}, Open  ]],

Cell["Define an expression whose residue you will find. ", "MathCaption",
 CellTags->{"S5.88.1", "1.6"}],

Cell[CellGroupData[{

Cell["f = 1/Expand[(z-1.7)(z+.2+.5 I)(z+.2-.5 I)]", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.88.1"],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "0.493`"}], "-", 
     RowBox[{"7.209944447028604`*^-18", " ", "\[ImaginaryI]"}]}], ")"}], "-", 
   
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"0.39`", "\[InvisibleSpace]"}], "+", 
      RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", "z"}], "-", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"1.3`", "\[InvisibleSpace]"}], "+", 
      RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
    SuperscriptBox["z", "2"]}], "+", 
   SuperscriptBox["z", "3"]}]]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.88.1"]
}, Open  ]],

Cell[TextData[{
 "Find the residue. Strictly speaking, ",
 StyleBox["f", "MR"],
 " has no singularity at ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["z",
     "TI"], "=", "1.7"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", but it has one very near to 1.7. "
}], "MathCaption",
 CellTags->{"S5.88.1", "1.7"}],

Cell[CellGroupData[{

Cell["Residue[f, {z, 1.7}]", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.88.1"],

Cell[BoxData["0"], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.88.1"]
}, Open  ]],

Cell["Numerically find the residue. ", "MathCaption",
 CellTags->{"S5.88.1", "1.8"}],

Cell[CellGroupData[{

Cell["NResidue[f, {z, 1.7}]", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.88.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"0.2590673575129531`", "\[InvisibleSpace]"}], "-", 
  RowBox[{"2.3906657903305373`*^-17", " ", "\[ImaginaryI]"}]}]], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S5.88.1"]
}, Open  ]],

Cell["This is another way to find the residue. ", "MathCaption",
 CellTags->{"S5.88.1", "1.9"}],

Cell[CellGroupData[{

Cell["1/((z+.2+.5 I)(z+.2-.5 I)) /. z -> 1.7", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.88.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"0.2590673575129534`", "\[InvisibleSpace]"}], "+", 
  RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]], "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S5.88.1"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.88.1"->{
    Cell[1776, 53, 138, 6, 36, "Subsection",
      CellTags->{"S5.88.1", "1.1"}],
    Cell[1917, 61, 305, 9, 40, "Text",
      CellTags->{"S5.88.1", "1.2"}],
    Cell[2225, 72, 534, 11, 88, "Text",
      CellTags->{"S5.88.1", "1.3"}],
    Cell[2762, 85, 2172, 68, 46, "DefinitionBox",
      CellTags->"S5.88.1"],
    Cell[4937, 155, 75, 1, 15, "Caption",
      CellTags->"S5.88.1"],
    Cell[5015, 158, 2462, 78, 106, "DefinitionBox",
      CellTags->"S5.88.1"],
    Cell[7480, 238, 104, 5, 15, "Caption",
      CellTags->"S5.88.1"],
    Cell[7587, 245, 78, 1, 40, "MathCaption",
      CellTags->{"S5.88.1", "1.4"}],
    Cell[7668, 248, 88, 2, 28, "Input",
      CellTags->"S5.88.1"],
    Cell[7759, 252, 272, 10, 40, "MathCaption",
      CellTags->{"S5.88.1", "1.5"}],
    Cell[8056, 266, 84, 2, 28, "Input",
      CellTags->"S5.88.1"],
    Cell[8143, 270, 76, 2, 25, "Output",
      CellTags->"S5.88.1"],
    Cell[8234, 275, 104, 1, 40, "MathCaption",
      CellTags->{"S5.88.1", "1.6"}],
    Cell[8363, 280, 106, 2, 28, "Input",
      CellTags->"S5.88.1"],
    Cell[8472, 284, 642, 21, 42, "Output",
      CellTags->"S5.88.1"],
    Cell[9129, 308, 360, 12, 56, "MathCaption",
      CellTags->{"S5.88.1", "1.7"}],
    Cell[9514, 324, 83, 2, 70, "Input",
      CellTags->"S5.88.1"],
    Cell[9600, 328, 74, 2, 70, "Output",
      CellTags->"S5.88.1"],
    Cell[9689, 333, 84, 1, 70, "MathCaption",
      CellTags->{"S5.88.1", "1.8"}],
    Cell[9798, 338, 84, 2, 70, "Input",
      CellTags->"S5.88.1"],
    Cell[9885, 342, 206, 5, 70, "Output",
      CellTags->"S5.88.1"],
    Cell[10106, 350, 95, 1, 70, "MathCaption",
      CellTags->{"S5.88.1", "1.9"}],
    Cell[10226, 355, 101, 2, 70, "Input",
      CellTags->"S5.88.1"],
    Cell[10330, 359, 185, 5, 70, "Output",
      CellTags->"S5.88.1"]},
  "1.1"->{
    Cell[1776, 53, 138, 6, 36, "Subsection",
      CellTags->{"S5.88.1", "1.1"}]},
  "1.2"->{
    Cell[1917, 61, 305, 9, 40, "Text",
      CellTags->{"S5.88.1", "1.2"}]},
  "1.3"->{
    Cell[2225, 72, 534, 11, 88, "Text",
      CellTags->{"S5.88.1", "1.3"}]},
  "1.4"->{
    Cell[7587, 245, 78, 1, 40, "MathCaption",
      CellTags->{"S5.88.1", "1.4"}]},
  "1.5"->{
    Cell[7759, 252, 272, 10, 40, "MathCaption",
      CellTags->{"S5.88.1", "1.5"}]},
  "1.6"->{
    Cell[8234, 275, 104, 1, 40, "MathCaption",
      CellTags->{"S5.88.1", "1.6"}]},
  "1.7"->{
    Cell[9129, 308, 360, 12, 56, "MathCaption",
      CellTags->{"S5.88.1", "1.7"}]},
  "1.8"->{
    Cell[9689, 333, 84, 1, 70, "MathCaption",
      CellTags->{"S5.88.1", "1.8"}]},
  "1.9"->{
    Cell[10106, 350, 95, 1, 70, "MathCaption",
      CellTags->{"S5.88.1", "1.9"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.88.1", 11166, 384},
  {"1.1", 12977, 433},
  {"1.2", 13071, 436},
  {"1.3", 13159, 439},
  {"1.4", 13248, 442},
  {"1.5", 13343, 445},
  {"1.6", 13440, 448},
  {"1.7", 13536, 451},
  {"1.8", 13633, 454},
  {"1.9", 13728, 457}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 138, 6, 36, "Subsection",
  CellTags->{"S5.88.1", "1.1"}],
Cell[1917, 61, 305, 9, 40, "Text",
  CellTags->{"S5.88.1", "1.2"}],
Cell[2225, 72, 534, 11, 88, "Text",
  CellTags->{"S5.88.1", "1.3"}],
Cell[2762, 85, 2172, 68, 46, "DefinitionBox",
  CellTags->"S5.88.1"],
Cell[4937, 155, 75, 1, 15, "Caption",
  CellTags->"S5.88.1"],
Cell[5015, 158, 2462, 78, 106, "DefinitionBox",
  CellTags->"S5.88.1"],
Cell[7480, 238, 104, 5, 15, "Caption",
  CellTags->"S5.88.1"],
Cell[7587, 245, 78, 1, 40, "MathCaption",
  CellTags->{"S5.88.1", "1.4"}],
Cell[7668, 248, 88, 2, 28, "Input",
  CellTags->"S5.88.1"],
Cell[7759, 252, 272, 10, 40, "MathCaption",
  CellTags->{"S5.88.1", "1.5"}],

Cell[CellGroupData[{
Cell[8056, 266, 84, 2, 28, "Input",
  CellTags->"S5.88.1"],
Cell[8143, 270, 76, 2, 25, "Output",
  CellTags->"S5.88.1"]
}, Open  ]],
Cell[8234, 275, 104, 1, 40, "MathCaption",
  CellTags->{"S5.88.1", "1.6"}],

Cell[CellGroupData[{
Cell[8363, 280, 106, 2, 28, "Input",
  CellTags->"S5.88.1"],
Cell[8472, 284, 642, 21, 42, "Output",
  CellTags->"S5.88.1"]
}, Open  ]],
Cell[9129, 308, 360, 12, 56, "MathCaption",
  CellTags->{"S5.88.1", "1.7"}],

Cell[CellGroupData[{
Cell[9514, 324, 83, 2, 70, "Input",
  CellTags->"S5.88.1"],
Cell[9600, 328, 74, 2, 70, "Output",
  CellTags->"S5.88.1"]
}, Open  ]],
Cell[9689, 333, 84, 1, 70, "MathCaption",
  CellTags->{"S5.88.1", "1.8"}],

Cell[CellGroupData[{
Cell[9798, 338, 84, 2, 70, "Input",
  CellTags->"S5.88.1"],
Cell[9885, 342, 206, 5, 70, "Output",
  CellTags->"S5.88.1"]
}, Open  ]],
Cell[10106, 350, 95, 1, 70, "MathCaption",
  CellTags->{"S5.88.1", "1.9"}],

Cell[CellGroupData[{
Cell[10226, 355, 101, 2, 70, "Input",
  CellTags->"S5.88.1"],
Cell[10330, 359, 185, 5, 70, "Output",
  CellTags->"S5.88.1"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

