(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     17903,        594]*)
(*NotebookOutlinePosition[     21866,        715]*)
(*  CellTagsIndexPosition[     21562,        699]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "NumericalMath",
 StyleBox["`", "MB"],
 "NSeries",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.89.1", "1.1"}],

Cell[TextData[{
 "The ",
 StyleBox["Mathematica", "TI"],
 " function ",
 StyleBox["Series", "MR"],
 " finds a power series expansion of a function about a point by evaluating \
derivatives. However, sometimes you only want a numerical approximation to a \
series and the derivatives are difficult to evaluate. You could use ",
 StyleBox["ND", "MR"],
 " to evaluate the derivatives, but that would involve repeating most of the \
work (",
 StyleBox["i.e.", "TI"],
 ", evaluating the function itself at several points) for each derivative. If \
the function is analytic and can be evaluated in the complex plane, the \
solution is to use the ",
 StyleBox["NSeries", "MR"],
 ". "
}], "Text",
 CellTags->{"S5.89.1", "1.2"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["NSeries[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "0"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give a numerical approximation to the series expansion of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" about ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["x",
          "TI"], "=", 
         SubscriptBox[
          StyleBox["x",
           "TI"], "0"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" including the terms ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           StyleBox["x",
            "TI"], "-", 
           SubscriptBox[
            StyleBox["x",
             "TI"], "0"]}], ")"}], 
         RowBox[{"-", 
          StyleBox["n",
           "TI"]}]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" through ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           StyleBox["x",
            "TI"], "-", 
           SubscriptBox[
            StyleBox["x",
             "TI"], "0"]}], ")"}], 
         StyleBox["n",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.89.1"],

Cell["Numerically finding series expansions. ", "Caption",
 CellTags->"S5.89.1"],

Cell[TextData[{
 StyleBox["NSeries", "MR"],
 " works by evaluating the function at discrete points on a circle centered \
at the expansion point. It then uses ",
 StyleBox["InverseFourier", "MR"],
 " to express the function as a sum of orthogonal basis functions, each of \
which is trivial to integrate around the circle. By Cauchy\[CloseCurlyQuote]s \
integral formula it is seen that ",
 StyleBox["InverseFourier", "MR"],
 " essentially gives us the required series coefficients; very little \
additional work is required and ",
 StyleBox["NSeries", "MR"],
 " does it all for you. Because it is based on Cauchy\[CloseCurlyQuote]s \
integral formula, care should be taken to ensure that no singularities of the \
function occur inside the circle of sample points. "
}], "Text",
 CellTags->{"S5.89.1", "1.3"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["option name", "TI",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["default value", "TI",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox["",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["WorkingPrecision", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["MachinePrecision", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "precision of the arithmetic to use in calculations ",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Radius", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["1", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "radius of the circle on which the function is sampled ",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
 GridBoxOptions->{RowLines->{True, False},
 RowSpacings->0.4},
 CellTags->"S5.89.1"],

Cell[TextData[{
 "Options for ",
 StyleBox["NSeries", "MR"],
 "."
}], "Caption",
 CellTags->"S5.89.1"],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.89.1", "1.4"}],

Cell["<< NumericalMath`NSeries`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.89.1"],

Cell[TextData[{
 "This gives an approximation to the series expansion of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["e",
     "TI"], 
    StyleBox["x",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " about the origin. Note that ",
 StyleBox["NSeries", "MR"],
 " is unable to recognize small numbers that should in fact be zero. "
}], "MathCaption",
 CellTags->{"S5.89.1", "1.5"}],

Cell[CellGroupData[{

Cell["NSeries[Exp[x], {x, 0, 3}]", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.89.1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    RowBox[{"1.60590252169324`*^-10", "+", 
     RowBox[{"9.964482154979935`*^-17", " ", "\[ImaginaryI]"}]}], 
    SuperscriptBox["x", "3"]], "+", 
   FractionBox[
    RowBox[{"1.1470626345603608`*^-11", "-", 
     RowBox[{"4.133846159260233`*^-17", " ", "\[ImaginaryI]"}]}], 
    SuperscriptBox["x", "2"]], "+", 
   FractionBox[
    RowBox[{"7.64700291072196`*^-13", "-", 
     RowBox[{"6.227738477912172`*^-17", " ", "\[ImaginaryI]"}]}], "x"], "+", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"1.0000000000000477`", "\[InvisibleSpace]"}], "-", 
     RowBox[{"1.8001009829851848`*^-17", " ", "\[ImaginaryI]"}]}], ")"}], "+",
    
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"1.0000000000000027`", "\[InvisibleSpace]"}], "-", 
      RowBox[{"1.618579661901263`*^-16", " ", "\[ImaginaryI]"}]}], ")"}], " ",
     "x"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"0.5000000000000002`", "\[InvisibleSpace]"}], "-", 
      RowBox[{"9.770003390290348`*^-17", " ", "\[ImaginaryI]"}]}], ")"}], " ",
     
    SuperscriptBox["x", "2"]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"0.1666666666666667`", "\[InvisibleSpace]"}], "-", 
      RowBox[{"4.484544672462822`*^-17", " ", "\[ImaginaryI]"}]}], ")"}], " ",
     
    SuperscriptBox["x", "3"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "4"],
    SeriesData[x, 0, {}, -3, 4, 1],
    Editable->False]}],
  SeriesData[x, 0, {
    Complex[1.60590252169324*^-10, 9.96448215497993*^-17], 
    Complex[1.14706263456036*^-11, -4.13384615926023*^-17], 
    Complex[7.64700291072196*^-13, -6.22773847791217*^-17], 
    Complex[1.00000000000005, -1.80010098298518*^-17], 
    Complex[1., -1.61857966190126*^-16], 
    Complex[0.5, -9.77000339029035*^-17], 
    Complex[0.166666666666667, -4.48454467246282*^-17]}, -3, 4, 1],
  Editable->False]], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.89.1"]
}, Open  ]],

Cell[TextData[{
 StyleBox["Chop", "MR"],
 " and ",
 StyleBox["Rationalize", "MR"],
 " can often clean up the result. "
}], "MathCaption",
 CellTags->{"S5.89.1", "1.6"}],

Cell[CellGroupData[{

Cell["Rationalize[Chop[%]]", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.89.1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["1.60590252169324`*^-10", 
    SuperscriptBox["x", "3"]], "+", "1", "+", "x", "+", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "6"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "4"],
    SeriesData[x, 0, {}, -3, 4, 1],
    Editable->False]}],
  SeriesData[x, 0, {1.60590252169324*^-10, 0, 0, 1, 1, 
    Rational[1, 2], 
    Rational[1, 6]}, -3, 4, 1],
  Editable->False]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.89.1"]
}, Open  ]],

Cell["If the radius is too small, cancellation becomes a problem. ", \
"MathCaption",
 CellTags->{"S5.89.1", "1.7"}],

Cell[CellGroupData[{

Cell["\<\
Rationalize[Chop[NSeries[Exp[x], {x, 0, 5},
              Radius -> 1/8]]]\
\>", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.89.1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "+", "x", "+", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "6"], "+", 
   RowBox[{"0.041666666666638645`", " ", 
    SuperscriptBox["x", "4"]}], "+", 
   RowBox[{"0.008333333333285757`", " ", 
    SuperscriptBox["x", "5"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "6"],
    SeriesData[x, 0, {}, 0, 6, 1],
    Editable->False]}],
  SeriesData[x, 0, {1, 1, 
    Rational[1, 2], 
    Rational[1, 6], 0.0416666666666386, 0.00833333333328576}, 0, 6, 1],
  Editable->False]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.89.1"]
}, Open  ]],

Cell[TextData[{
 "Increasing the ",
 StyleBox["WorkingPrecision", "MR"],
 " will usually solve this problem. "
}], "MathCaption",
 CellTags->{"S5.89.1", "1.8"}],

Cell[CellGroupData[{

Cell["\<\
Rationalize[Chop[NSeries[Exp[x], {x, 0, 5},
          WorkingPrecision -> 40, Radius -> 1/8]]]\
\>", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.89.1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "+", "x", "+", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "6"], "+", 
   FractionBox[
    SuperscriptBox["x", "4"], "24"], "+", 
   FractionBox[
    SuperscriptBox["x", "5"], "120"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "6"],
    SeriesData[x, 0, {}, 0, 6, 1],
    Editable->False]}],
  SeriesData[x, 0, {1, 1, 
    Rational[1, 2], 
    Rational[1, 6], 
    Rational[1, 24], 
    Rational[1, 120]}, 0, 6, 1],
  Editable->False]], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S5.89.1"]
}, Open  ]],

Cell["\<\
If the radius is too large, the sample points become too scattered and it \
starts looking like poles exist. \
\>", "MathCaption",
 CellTags->{"S5.89.1", "1.9"}],

Cell[CellGroupData[{

Cell["\<\
Rationalize[Chop[NSeries[Exp[x], {x, 0, 5},
          Radius -> 4]]]\
\>", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.89.1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["1.6929665169751475`*^-9", 
    SuperscriptBox["x", "5"]], "+", "1", "+", "x", "+", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "6"], "+", 
   FractionBox[
    SuperscriptBox["x", "4"], "24"], "+", 
   FractionBox[
    SuperscriptBox["x", "5"], "120"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "6"],
    SeriesData[x, 0, {}, -5, 6, 1],
    Editable->False]}],
  SeriesData[x, 0, {1.69296651697515*^-9, 0, 0, 0, 0, 1, 1, 
    Rational[1, 2], 
    Rational[1, 6], 
    Rational[1, 24], 
    Rational[1, 120]}, -5, 6, 1],
  Editable->False]], "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S5.89.1"]
}, Open  ]],

Cell[TextData[{
 StyleBox["NSeries", "MR"],
 " also recognizes poles. "
}], "MathCaption",
 CellTags->{"S5.89.1", "1.10"}],

Cell[CellGroupData[{

Cell["Chop[NSeries[Zeta[s], {s, 1, 5}]]", "Input",
 CellLabel->"In[7]:= ",
 CellTags->"S5.89.1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["1", 
    RowBox[{"s", "-", "1"}]], "+", "0.577215664901533`", "+", 
   RowBox[{"0.07281584548367678`", " ", 
    RowBox[{"(", 
     RowBox[{"s", "-", "1"}], ")"}]}], "-", 
   RowBox[{"0.004845181596436547`", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"s", "-", "1"}], ")"}], "2"]}], "-", 
   RowBox[{"0.0003423057367166465`", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"s", "-", "1"}], ")"}], "3"]}], "+", 
   RowBox[{"0.00009689041939378817`", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"s", "-", "1"}], ")"}], "4"]}], "-", 
   RowBox[{"6.611031810479472`*^-6", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"s", "-", "1"}], ")"}], "5"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"s", "-", "1"}], "]"}], "6"],
    SeriesData[s, 1, {}, -1, 6, 1],
    Editable->False]}],
  SeriesData[
  s, 1, {1, 0.577215664901533, 
    0.0728158454836768, -0.00484518159643655, -0.000342305736716647, 
    9.68904193937882*^-5, -6.61103181047947*^-6}, -1, 6, 1],
  Editable->False]], "Output",
 CellLabel->"Out[7]= ",
 CellTags->"S5.89.1"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.89.1"->{
    Cell[1776, 53, 137, 6, 36, "Subsection",
      CellTags->{"S5.89.1", "1.1"}],
    Cell[1916, 61, 719, 18, 104, "Text",
      CellTags->{"S5.89.1", "1.2"}],
    Cell[2638, 81, 3370, 108, 82, "DefinitionBox",
      CellTags->"S5.89.1"],
    Cell[6011, 191, 80, 1, 15, "Caption",
      CellTags->"S5.89.1"],
    Cell[6094, 194, 810, 16, 120, "Text",
      CellTags->{"S5.89.1", "1.3"}],
    Cell[6907, 212, 2689, 77, 124, "DefinitionBox3Col",
      CellTags->"S5.89.1"],
    Cell[9599, 291, 102, 5, 15, "Caption",
      CellTags->"S5.89.1"],
    Cell[9704, 298, 78, 1, 40, "MathCaption",
      CellTags->{"S5.89.1", "1.4"}],
    Cell[9785, 301, 88, 2, 28, "Input",
      CellTags->"S5.89.1"],
    Cell[9876, 305, 447, 14, 56, "MathCaption",
      CellTags->{"S5.89.1", "1.5"}],
    Cell[10348, 323, 89, 2, 28, "Input",
      CellTags->"S5.89.1"],
    Cell[10440, 327, 1996, 54, 70, "Output",
      CellTags->"S5.89.1"],
    Cell[12451, 384, 168, 6, 70, "MathCaption",
      CellTags->{"S5.89.1", "1.6"}],
    Cell[12644, 394, 83, 2, 70, "Input",
      CellTags->"S5.89.1"],
    Cell[12730, 398, 588, 19, 70, "Output",
      CellTags->"S5.89.1"],
    Cell[13333, 420, 116, 2, 70, "MathCaption",
      CellTags->{"S5.89.1", "1.7"}],
    Cell[13474, 426, 145, 5, 70, "Input",
      CellTags->"S5.89.1"],
    Cell[13622, 433, 679, 21, 70, "Output",
      CellTags->"S5.89.1"],
    Cell[14316, 457, 160, 5, 70, "MathCaption",
      CellTags->{"S5.89.1", "1.8"}],
    Cell[14501, 466, 165, 5, 70, "Input",
      CellTags->"S5.89.1"],
    Cell[14669, 473, 642, 23, 70, "Output",
      CellTags->"S5.89.1"],
    Cell[15326, 499, 171, 4, 70, "MathCaption",
      CellTags->{"S5.89.1", "1.9"}],
    Cell[15522, 507, 139, 5, 70, "Input",
      CellTags->"S5.89.1"],
    Cell[15664, 514, 758, 25, 70, "Output",
      CellTags->"S5.89.1"],
    Cell[16437, 542, 122, 4, 70, "MathCaption",
      CellTags->{"S5.89.1", "1.10"}],
    Cell[16584, 550, 96, 2, 70, "Input",
      CellTags->"S5.89.1"],
    Cell[16683, 554, 1192, 36, 70, "Output",
      CellTags->"S5.89.1"]},
  "1.1"->{
    Cell[1776, 53, 137, 6, 36, "Subsection",
      CellTags->{"S5.89.1", "1.1"}]},
  "1.2"->{
    Cell[1916, 61, 719, 18, 104, "Text",
      CellTags->{"S5.89.1", "1.2"}]},
  "1.3"->{
    Cell[6094, 194, 810, 16, 120, "Text",
      CellTags->{"S5.89.1", "1.3"}]},
  "1.4"->{
    Cell[9704, 298, 78, 1, 40, "MathCaption",
      CellTags->{"S5.89.1", "1.4"}]},
  "1.5"->{
    Cell[9876, 305, 447, 14, 56, "MathCaption",
      CellTags->{"S5.89.1", "1.5"}]},
  "1.6"->{
    Cell[12451, 384, 168, 6, 70, "MathCaption",
      CellTags->{"S5.89.1", "1.6"}]},
  "1.7"->{
    Cell[13333, 420, 116, 2, 70, "MathCaption",
      CellTags->{"S5.89.1", "1.7"}]},
  "1.8"->{
    Cell[14316, 457, 160, 5, 70, "MathCaption",
      CellTags->{"S5.89.1", "1.8"}]},
  "1.9"->{
    Cell[15326, 499, 171, 4, 70, "MathCaption",
      CellTags->{"S5.89.1", "1.9"}]},
  "1.10"->{
    Cell[16437, 542, 122, 4, 70, "MathCaption",
      CellTags->{"S5.89.1", "1.10"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.89.1", 18526, 610},
  {"1.1", 20594, 665},
  {"1.2", 20688, 668},
  {"1.3", 20778, 671},
  {"1.4", 20869, 674},
  {"1.5", 20964, 677},
  {"1.6", 21061, 680},
  {"1.7", 21158, 683},
  {"1.8", 21255, 686},
  {"1.9", 21352, 689},
  {"1.10", 21450, 692}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 137, 6, 36, "Subsection",
  CellTags->{"S5.89.1", "1.1"}],
Cell[1916, 61, 719, 18, 104, "Text",
  CellTags->{"S5.89.1", "1.2"}],
Cell[2638, 81, 3370, 108, 82, "DefinitionBox",
  CellTags->"S5.89.1"],
Cell[6011, 191, 80, 1, 15, "Caption",
  CellTags->"S5.89.1"],
Cell[6094, 194, 810, 16, 120, "Text",
  CellTags->{"S5.89.1", "1.3"}],
Cell[6907, 212, 2689, 77, 124, "DefinitionBox3Col",
  CellTags->"S5.89.1"],
Cell[9599, 291, 102, 5, 15, "Caption",
  CellTags->"S5.89.1"],
Cell[9704, 298, 78, 1, 40, "MathCaption",
  CellTags->{"S5.89.1", "1.4"}],
Cell[9785, 301, 88, 2, 28, "Input",
  CellTags->"S5.89.1"],
Cell[9876, 305, 447, 14, 56, "MathCaption",
  CellTags->{"S5.89.1", "1.5"}],

Cell[CellGroupData[{
Cell[10348, 323, 89, 2, 28, "Input",
  CellTags->"S5.89.1"],
Cell[10440, 327, 1996, 54, 70, "Output",
  CellTags->"S5.89.1"]
}, Open  ]],
Cell[12451, 384, 168, 6, 70, "MathCaption",
  CellTags->{"S5.89.1", "1.6"}],

Cell[CellGroupData[{
Cell[12644, 394, 83, 2, 70, "Input",
  CellTags->"S5.89.1"],
Cell[12730, 398, 588, 19, 70, "Output",
  CellTags->"S5.89.1"]
}, Open  ]],
Cell[13333, 420, 116, 2, 70, "MathCaption",
  CellTags->{"S5.89.1", "1.7"}],

Cell[CellGroupData[{
Cell[13474, 426, 145, 5, 70, "Input",
  CellTags->"S5.89.1"],
Cell[13622, 433, 679, 21, 70, "Output",
  CellTags->"S5.89.1"]
}, Open  ]],
Cell[14316, 457, 160, 5, 70, "MathCaption",
  CellTags->{"S5.89.1", "1.8"}],

Cell[CellGroupData[{
Cell[14501, 466, 165, 5, 70, "Input",
  CellTags->"S5.89.1"],
Cell[14669, 473, 642, 23, 70, "Output",
  CellTags->"S5.89.1"]
}, Open  ]],
Cell[15326, 499, 171, 4, 70, "MathCaption",
  CellTags->{"S5.89.1", "1.9"}],

Cell[CellGroupData[{
Cell[15522, 507, 139, 5, 70, "Input",
  CellTags->"S5.89.1"],
Cell[15664, 514, 758, 25, 70, "Output",
  CellTags->"S5.89.1"]
}, Open  ]],
Cell[16437, 542, 122, 4, 70, "MathCaption",
  CellTags->{"S5.89.1", "1.10"}],

Cell[CellGroupData[{
Cell[16584, 550, 96, 2, 70, "Input",
  CellTags->"S5.89.1"],
Cell[16683, 554, 1192, 36, 70, "Output",
  CellTags->"S5.89.1"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

