(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     14903,        522]*)
(*NotebookOutlinePosition[     19113,        651]*)
(*  CellTagsIndexPosition[     18761,        633]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "NumericalMath",
 StyleBox["`", "MB"],
 "NewtonCotes",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.90.1", "1.1"}],

Cell[TextData[{
 "As one of its methods, the ",
 StyleBox["Mathematica", "TI"],
 " function ",
 StyleBox["NIntegrate", "MR"],
 " uses a fairly sophisticated Gauss\[Hyphen]Kronrod based algorithm. Other \
types of quadrature formulas exist, each with their own advantages. For \
example, Gaussian quadrature uses values of the integrand at oddly spaced \
abscissas. If you want to integrate a function presented in tabular form at \
equally spaced abscissas, it won\[CloseCurlyQuote]t work very well. An \
alternative is to use Newton\[Hyphen]Cotes quadrature. "
}], "Text",
 CellTags->{"S5.90.1", "1.2"}],

Cell["\<\
The basic idea behind Newton\[Hyphen]Cotes quadrature is to approximate the \
value of an integral as a linear combination of values of the integrand \
evaluated at equally spaced points: \
\>", "Text",
 CellTags->{"S5.90.1", "1.3"}],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubsuperscriptBox["\[Integral]", 
    StyleBox["a",
     "TI"], 
    StyleBox["b",
     "TI"]], 
   StyleBox["f",
    "TI"], 
   RowBox[{"(", 
    StyleBox["x",
     "TI"], ")"}], "\[DifferentialD]", 
   StyleBox["x",
    "TI"], "=", 
   UnderoverscriptBox["\[Sum]", 
    RowBox[{
     StyleBox["i",
      "TI"], "=", "1"}], 
    StyleBox["n",
     "TI"],
    LimitsPositioning->False], 
   SubscriptBox[
    StyleBox["w",
     "TI"], 
    StyleBox["i",
     "TI"]], 
   StyleBox["f",
    "TI"], 
   RowBox[{"(", 
    SubscriptBox[
     StyleBox["x",
      "TI"], 
     StyleBox["i",
      "TI"]], ")"}]}], TraditionalForm]], "DisplayFormula",
 UnderoverscriptBoxOptions->{LimitsPositioning->True},
 GridBoxOptions->{ColumnWidths->Automatic},
 CellTags->{"S5.90.1", "1.4"}],

Cell["\<\
In addition, there is the question of whether or not to include the end \
points in the sum. If they are included, the quadrature formula is referred \
to as a closed formula. If not, it is an open formula. If the formula is open \
there is some ambiguity as to where the first abscissa is to be placed. The \
open formulas given in this package have the first abscissa one half step \
from the lower end point. \
\>", "Text",
 CellTags->{"S5.90.1", "1.5"}],

Cell[TextData[{
 "Since there are ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " free parameters to be chosen (the weights) and since both integration and \
the sum are linear operations, you can expect to be able to make the formula \
correct for all polynomials of degree less than about ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". In addition to knowing what the weights are, it is often desirable to \
know how large the error in the approximation will be. This package allows \
you to answer both of these questions. "
}], "Text",
 CellTags->{"S5.90.1", "1.6"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["NewtonCotesWeights[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["a", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["b", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give a list of the ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["n",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" pairs ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"(", 
         RowBox[{
          SubscriptBox[
           StyleBox["x",
            "TI"], 
           StyleBox["i",
            "TI"]], ",", 
          SubscriptBox[
           StyleBox["w",
            "TI"], 
           StyleBox["i",
            "TI"]]}], ")"}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" for quadrature on the interval ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["a", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" to ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["b", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["NewtonCotesError[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["a", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["b", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "give the error in the formula",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.90.1"],

Cell["\<\
Finding formulas for Newton\[Hyphen]Cotes quadrature. \
\>", "Caption",
 CellTags->"S5.90.1"],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["option name", "TI",
       GridBoxOptions->{RowLines->True,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->True,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->True,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["default value", "TI",
       GridBoxOptions->{RowLines->True,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->True,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->True,
      RowSpacings->0.4}], Cell[TextData[StyleBox["",
      GridBoxOptions->{RowLines->True,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->True,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["QuadratureType", "MR",
       GridBoxOptions->{RowLines->True,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->True,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->True,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Closed", "MR",
       GridBoxOptions->{RowLines->True,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->True,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->True,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["the type of quadrature, ",
       GridBoxOptions->{RowLines->True,
       RowSpacings->0.4}],
      StyleBox["Open", "MR",
       GridBoxOptions->{RowLines->True,
       RowSpacings->0.4}],
      StyleBox[" or ",
       GridBoxOptions->{RowLines->True,
       RowSpacings->0.4}],
      StyleBox["Closed", "MR",
       GridBoxOptions->{RowLines->True,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->True,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
 GridBoxOptions->{RowLines->True,
 RowSpacings->0.4},
 CellTags->"S5.90.1"],

Cell[TextData[{
 "Option for ",
 StyleBox["NewtonCotesWeights", "MR"],
 " and ",
 StyleBox["NewtonCotesError", "MR"],
 "."
}], "Caption",
 CellTags->"S5.90.1"],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.90.1", "1.7"}],

Cell["<<NumericalMath`NewtonCotes`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.90.1"],

Cell[TextData[{
 "Here are the abscissas and weights for the five\[Hyphen]point closed Newton\
\[Hyphen]Cotes quadrature formula on the interval ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "3"}], ",", "7"}], ")"}], TraditionalForm]], 
  "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.90.1", "1.8"}],

Cell[CellGroupData[{

Cell["NewtonCotesWeights[5, -3, 7]", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.90.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "3"}], ",", 
     FractionBox["7", "9"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", "2"]}], ",", 
     FractionBox["32", "9"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     FractionBox["4", "3"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["9", "2"], ",", 
     FractionBox["32", "9"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", 
     FractionBox["7", "9"]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.90.1"]
}, Open  ]],

Cell[TextData[{
 "Here is the error in that formula. Unfortunately it involves the sixth \
derivative of ",
 Cell[BoxData[
  FormBox[
   StyleBox["f",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " at an unknown point so you don\[CloseCurlyQuote]t really know what the \
error itself is. "
}], "MathCaption",
 CellTags->{"S5.90.1", "1.9"}],

Cell[CellGroupData[{

Cell["NewtonCotesError[5, f, -3, 7]", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.90.1"],

Cell[BoxData[
 FractionBox[
  RowBox[{"15625", " ", 
   SuperscriptBox["f", 
    TagBox[
     RowBox[{"(", "6", ")"}],
     Derivative],
    MultilineFunction->None]}], "3024"]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.90.1"]
}, Open  ]],

Cell["\<\
You can see that the error decreases rapidly with the length of the interval. \
\
\>", "MathCaption",
 CellTags->{"S5.90.1", "1.10"}],

Cell[CellGroupData[{

Cell["NewtonCotesError[5, f, a, a+h]", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.90.1"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["h", "7"], " ", 
   SuperscriptBox["f", 
    TagBox[
     RowBox[{"(", "6", ")"}],
     Derivative],
    MultilineFunction->None]}], "1935360"]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.90.1"]
}, Open  ]],

Cell[TextData[{
 "This gives the abscissas and weights for the five\[Hyphen]point open Newton\
\[Hyphen]Cotes quadrature formula on the interval (",
 Cell[BoxData[
  FormBox["-", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "3, 7). "
}], "MathCaption",
 CellTags->{"S5.90.1", "1.11"}],

Cell[CellGroupData[{

Cell["NewtonCotesWeights[5, -3, 7, QuadratureType -> Open]", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.90.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2"}], ",", 
     FractionBox["1375", "576"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox["125", "144"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     FractionBox["335", "96"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", 
     FractionBox["125", "144"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", 
     FractionBox["1375", "576"]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S5.90.1"]
}, Open  ]],

Cell["Here is the error in that formula. ", "MathCaption",
 CellTags->{"S5.90.1", "1.12"}],

Cell[CellGroupData[{

Cell["NewtonCotesError[5, f, -3, 7, QuadratureType -> Open]", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.90.1"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"5575", " ", 
    SuperscriptBox["f", 
     TagBox[
      RowBox[{"(", "6", ")"}],
      Derivative],
     MultilineFunction->None]}], "1512"]}]], "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S5.90.1"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.90.1"->{
    Cell[1776, 53, 141, 6, 36, "Subsection",
      CellTags->{"S5.90.1", "1.1"}],
    Cell[1920, 61, 604, 12, 88, "Text",
      CellTags->{"S5.90.1", "1.2"}],
    Cell[2527, 75, 243, 5, 40, "Text",
      CellTags->{"S5.90.1", "1.3"}],
    Cell[2773, 82, 811, 37, 52, "DisplayFormula",
      CellTags->{"S5.90.1", "1.4"}],
    Cell[3587, 121, 467, 8, 72, "Text",
      CellTags->{"S5.90.1", "1.5"}],
    Cell[4057, 131, 760, 19, 88, "Text",
      CellTags->{"S5.90.1", "1.6"}],
    Cell[4820, 152, 3703, 118, 102, "DefinitionBox",
      CellTags->"S5.90.1"],
    Cell[8526, 272, 103, 3, 15, "Caption",
      CellTags->"S5.90.1"],
    Cell[8632, 277, 1953, 63, 68, "DefinitionBox3Col",
      CellTags->"S5.90.1"],
    Cell[10588, 342, 159, 7, 15, "Caption",
      CellTags->"S5.90.1"],
    Cell[10750, 351, 78, 1, 40, "MathCaption",
      CellTags->{"S5.90.1", "1.7"}],
    Cell[10831, 354, 91, 2, 28, "Input",
      CellTags->"S5.90.1"],
    Cell[10925, 358, 388, 12, 70, "MathCaption",
      CellTags->{"S5.90.1", "1.8"}],
    Cell[11338, 374, 91, 2, 70, "Input",
      CellTags->"S5.90.1"],
    Cell[11432, 378, 607, 23, 70, "Output",
      CellTags->"S5.90.1"],
    Cell[12054, 404, 388, 11, 70, "MathCaption",
      CellTags->{"S5.90.1", "1.9"}],
    Cell[12467, 419, 92, 2, 70, "Input",
      CellTags->"S5.90.1"],
    Cell[12562, 423, 234, 9, 70, "Output",
      CellTags->"S5.90.1"],
    Cell[12811, 435, 143, 4, 70, "MathCaption",
      CellTags->{"S5.90.1", "1.10"}],
    Cell[12979, 443, 93, 2, 70, "Input",
      CellTags->"S5.90.1"],
    Cell[13075, 447, 258, 10, 70, "Output",
      CellTags->"S5.90.1"],
    Cell[13348, 460, 322, 8, 70, "MathCaption",
      CellTags->{"S5.90.1", "1.11"}],
    Cell[13695, 472, 115, 2, 70, "Input",
      CellTags->"S5.90.1"],
    Cell[13813, 476, 556, 20, 70, "Output",
      CellTags->"S5.90.1"],
    Cell[14384, 499, 90, 1, 70, "MathCaption",
      CellTags->{"S5.90.1", "1.12"}],
    Cell[14499, 504, 116, 2, 70, "Input",
      CellTags->"S5.90.1"],
    Cell[14618, 508, 257, 10, 70, "Output",
      CellTags->"S5.90.1"]},
  "1.1"->{
    Cell[1776, 53, 141, 6, 36, "Subsection",
      CellTags->{"S5.90.1", "1.1"}]},
  "1.2"->{
    Cell[1920, 61, 604, 12, 88, "Text",
      CellTags->{"S5.90.1", "1.2"}]},
  "1.3"->{
    Cell[2527, 75, 243, 5, 40, "Text",
      CellTags->{"S5.90.1", "1.3"}]},
  "1.4"->{
    Cell[2773, 82, 811, 37, 52, "DisplayFormula",
      CellTags->{"S5.90.1", "1.4"}]},
  "1.5"->{
    Cell[3587, 121, 467, 8, 72, "Text",
      CellTags->{"S5.90.1", "1.5"}]},
  "1.6"->{
    Cell[4057, 131, 760, 19, 88, "Text",
      CellTags->{"S5.90.1", "1.6"}]},
  "1.7"->{
    Cell[10750, 351, 78, 1, 40, "MathCaption",
      CellTags->{"S5.90.1", "1.7"}]},
  "1.8"->{
    Cell[10925, 358, 388, 12, 70, "MathCaption",
      CellTags->{"S5.90.1", "1.8"}]},
  "1.9"->{
    Cell[12054, 404, 388, 11, 70, "MathCaption",
      CellTags->{"S5.90.1", "1.9"}]},
  "1.10"->{
    Cell[12811, 435, 143, 4, 70, "MathCaption",
      CellTags->{"S5.90.1", "1.10"}]},
  "1.11"->{
    Cell[13348, 460, 322, 8, 70, "MathCaption",
      CellTags->{"S5.90.1", "1.11"}]},
  "1.12"->{
    Cell[14384, 499, 90, 1, 70, "MathCaption",
      CellTags->{"S5.90.1", "1.12"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.90.1", 15526, 538},
  {"1.1", 17610, 593},
  {"1.2", 17704, 596},
  {"1.3", 17793, 599},
  {"1.4", 17881, 602},
  {"1.5", 17980, 605},
  {"1.6", 18069, 608},
  {"1.7", 18159, 611},
  {"1.8", 18255, 614},
  {"1.9", 18353, 617},
  {"1.10", 18452, 620},
  {"1.11", 18551, 623},
  {"1.12", 18650, 626}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 141, 6, 36, "Subsection",
  CellTags->{"S5.90.1", "1.1"}],
Cell[1920, 61, 604, 12, 88, "Text",
  CellTags->{"S5.90.1", "1.2"}],
Cell[2527, 75, 243, 5, 40, "Text",
  CellTags->{"S5.90.1", "1.3"}],
Cell[2773, 82, 811, 37, 52, "DisplayFormula",
  CellTags->{"S5.90.1", "1.4"}],
Cell[3587, 121, 467, 8, 72, "Text",
  CellTags->{"S5.90.1", "1.5"}],
Cell[4057, 131, 760, 19, 88, "Text",
  CellTags->{"S5.90.1", "1.6"}],
Cell[4820, 152, 3703, 118, 102, "DefinitionBox",
  CellTags->"S5.90.1"],
Cell[8526, 272, 103, 3, 15, "Caption",
  CellTags->"S5.90.1"],
Cell[8632, 277, 1953, 63, 68, "DefinitionBox3Col",
  CellTags->"S5.90.1"],
Cell[10588, 342, 159, 7, 15, "Caption",
  CellTags->"S5.90.1"],
Cell[10750, 351, 78, 1, 40, "MathCaption",
  CellTags->{"S5.90.1", "1.7"}],
Cell[10831, 354, 91, 2, 28, "Input",
  CellTags->"S5.90.1"],
Cell[10925, 358, 388, 12, 70, "MathCaption",
  CellTags->{"S5.90.1", "1.8"}],

Cell[CellGroupData[{
Cell[11338, 374, 91, 2, 70, "Input",
  CellTags->"S5.90.1"],
Cell[11432, 378, 607, 23, 70, "Output",
  CellTags->"S5.90.1"]
}, Open  ]],
Cell[12054, 404, 388, 11, 70, "MathCaption",
  CellTags->{"S5.90.1", "1.9"}],

Cell[CellGroupData[{
Cell[12467, 419, 92, 2, 70, "Input",
  CellTags->"S5.90.1"],
Cell[12562, 423, 234, 9, 70, "Output",
  CellTags->"S5.90.1"]
}, Open  ]],
Cell[12811, 435, 143, 4, 70, "MathCaption",
  CellTags->{"S5.90.1", "1.10"}],

Cell[CellGroupData[{
Cell[12979, 443, 93, 2, 70, "Input",
  CellTags->"S5.90.1"],
Cell[13075, 447, 258, 10, 70, "Output",
  CellTags->"S5.90.1"]
}, Open  ]],
Cell[13348, 460, 322, 8, 70, "MathCaption",
  CellTags->{"S5.90.1", "1.11"}],

Cell[CellGroupData[{
Cell[13695, 472, 115, 2, 70, "Input",
  CellTags->"S5.90.1"],
Cell[13813, 476, 556, 20, 70, "Output",
  CellTags->"S5.90.1"]
}, Open  ]],
Cell[14384, 499, 90, 1, 70, "MathCaption",
  CellTags->{"S5.90.1", "1.12"}],

Cell[CellGroupData[{
Cell[14499, 504, 116, 2, 70, "Input",
  CellTags->"S5.90.1"],
Cell[14618, 508, 257, 10, 70, "Output",
  CellTags->"S5.90.1"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

