(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     74069,       2320]*)
(*NotebookOutlinePosition[     82520,       2573]*)
(*  CellTagsIndexPosition[     81731,       2538]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Statistics",
 StyleBox["`", "MB"],
 "NonlinearFit",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S6.7.1", "1.1"}],

Cell[TextData[{
 "The built\[Hyphen]in function ",
 StyleBox["Fit", "MR"],
 " finds a least\[Hyphen]squares fit to a list of data for a model that is a \
linear combination of the given basis functions; the coefficients of the \
linear combination are the parameters of the fit. Often a more sophisticated \
model is desired, where the model is not linear in the parameters. The \
function ",
 StyleBox["NonlinearFit", "MR"],
 " allows you to perform this kind of least\[Hyphen]squares fit. ",
 StyleBox["NonlinearFit", "MR"],
 " gives an expression for the model, similar to the output of the built\
\[Hyphen]in function ",
 StyleBox["Fit", "MR"],
 ". The function ",
 StyleBox["NonlinearRegress", "MR"],
 " gives a number of regression diagnostics and allows you to specify exactly \
what will be included in the output, as does the package function ",
 StyleBox["Regress", "MR"],
 ". "
}], "Text",
 CellTags->{"S6.7.1", "1.2"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["NonlinearFit[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["model", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["variables", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["parameters", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "fit the data to the model with the named variables and parameters, \
returning the model evaluated at the parameter estimates achieving the least\
\[Hyphen]squares fit",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["NonlinearRegress[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["model", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["variables", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["parameters", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "fit the data to the model with the named variables and parameters, \
returning a list of rules expressing the fit parameter estimates and fit \
diagnostics",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S6.7.1"],

Cell[TextData[{
 "The ",
 StyleBox["NonlinearFit", "MR"],
 " and ",
 StyleBox["NonlinearRegress", "MR"],
 " functions. "
}], "Caption",
 CellTags->"S6.7.1"],

Cell[TextData[{
 "The model argument of ",
 StyleBox["NonlinearFit", "MR"],
 " and ",
 StyleBox["NonlinearRegress", "MR"],
 " must be completely specified by the symbols in the variables argument and \
the symbols in the parameters argument. The variables argument specifies the \
independent variables represented in the data. The parameters argument \
specifies the model parameters for which you would like estimates. "
}], "Text",
 CellTags->{"S6.7.1", "1.3"}],

Cell[TextData[{
 "The data argument can be a list of vectors, each vector consisting of the \
values of the independent variables ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["x",
     "TI"], "1"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["x",
     "TI"], "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", \[Ellipsis] , followed by the observed value of the associated response \
",
 Cell[BoxData[
  FormBox[
   StyleBox["y",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". The data argument can also be a vector, in which case it is assumed that \
the vector represents the observed values of the response variable, with the \
independent variable(s) for the ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["i",
     "TI"], "th"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " response equal to ",
 Cell[BoxData[
  FormBox[
   StyleBox["i",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "Text",
 CellTags->{"S6.7.1", "1.4"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] }", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["data points specified by a list of response values, where ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["i",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[
      " is the value of the independent variable associated with the ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["i",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SuperscriptBox["\[Null]", "th"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" response, ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], 
         StyleBox["i",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["{{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "11"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "12"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] , ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["},{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "21"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "22"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] , ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, \[Ellipsis] }", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["data points specified by a matrix, where ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], 
         StyleBox[
          RowBox[{"i", "k"}],
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is the value of the ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["i",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SuperscriptBox["\[Null]", "th"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" case of the ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["k",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SuperscriptBox["\[Null]", "th"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" independent variable, and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], 
         StyleBox["i",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is the ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["i",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SuperscriptBox["\[Null]", "th"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" response ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S6.7.1"],

Cell[TextData[{
 "Ways of specifying data in ",
 StyleBox["NonlinearFit", "MR"],
 " and ",
 StyleBox["NonlinearRegress", "MR"],
 "."
}], "Caption",
 CellTags->"S6.7.1"],

Cell[TextData[{
 "The estimates of the model parameters are chosen to minimize the ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Chi]", "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " merit function given by the sum of squared residuals ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderscriptBox["\[Sum]", 
     StyleBox["i",
      "TI"],
     LimitsPositioning->True], 
    SubsuperscriptBox[
     StyleBox["e",
      "TI"], 
     StyleBox["i",
      "TI"], "2"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". The optimization methods used by ",
 StyleBox["NonlinearFit", "MR"],
 " and ",
 StyleBox["NonlinearRegress", "MR"],
 " are iterative so starting values are required for the parameter estimate \
search. Careful choice of starting values may be necessary, as the parameter \
estimates found by ",
 StyleBox["NonlinearFit", "MR"],
 " and ",
 StyleBox["NonlinearRegress", "MR"],
 " may represent a local minimum in the ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Chi]", "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " merit function. "
}], "Text",
 CellTags->{"S6.7.1", "1.5"}],

Cell[TextData[{
 "The simplest way to specify a parameter is as a symbol, assuming a starting \
point of 1.0, or as a ",
 StyleBox["{", "MR"],
 StyleBox["symbol", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["start", "TI"],
 StyleBox["}", "MR"],
 " pair. When elements in the parameter are specified as ",
 StyleBox["{", "MR"],
 StyleBox["symbol", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["min", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["max", "TI"],
 StyleBox["}", "MR"],
 ", the starting parameter values are taken to be those minimizing the ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Chi]", "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " merit function out of the set forming a ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["2", 
    StyleBox["p",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " factorial design based on the parameter ranges, where ",
 Cell[BoxData[
  FormBox[
   StyleBox["p",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is the number of parameters. For example, if the parameter list is \
specified as ",
 StyleBox["{{", "MR"],
 StyleBox["a", "TI"],
 StyleBox[", 0, 1}, {", "MR"],
 StyleBox["b", "TI"],
 StyleBox[", 0, 3}}", "MR"],
 ", then the value of ",
 StyleBox["{", "MR"],
 StyleBox["a", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["b", "TI"],
 StyleBox["}", "MR"],
 " in ",
 StyleBox["{{1/3, 1}, {1/3, 2}, {2/3, 1}, {2/3, 2}}", "MR"],
 " that yields the minimum ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Chi]", "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " gives starting values for parameters ",
 Cell[BoxData[
  FormBox[
   StyleBox["a",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox["b",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "Text",
 CellTags->{"S6.7.1", "1.6"}],

Cell[TextData[{
 "If a parameter is specified as ",
 StyleBox["{", "MR"],
 StyleBox["symbol", "TI"],
 StyleBox[", {", "MR"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["start",
     "TI"], "0"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox[", ", "MR"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["start",
     "TI"], "1"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox["}}", "MR"],
 ", then the search for parameter estimates uses ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["start",
     "TI"], "0"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["start",
     "TI"], "1"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " as the first two values of ",
 StyleBox["symbol", "TI"],
 ". This form must be used if symbolic derivatives of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Chi]", "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " with respect to the parameters cannot be found. "
}], "Text",
 CellTags->{"S6.7.1", "1.7"}],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S6.7.1", "1.8"}],

Cell["<< Statistics`NonlinearFit`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S6.7.1"],

Cell[TextData[{
 "This data set [Meyer and Roth, 1972] gives five values for ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["x",
     "TI"], "1"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["x",
     "TI"], "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", and ",
 Cell[BoxData[
  FormBox[
   StyleBox["y",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", describing a reaction involving the catalytic dehydration of \
n\[Hyphen]hexyl alcohol. Here ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["x",
     "TI"], "1"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is partial pressure of alchohol, ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["x",
     "TI"], "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is olefin, and ",
 Cell[BoxData[
  FormBox[
   StyleBox["y",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is the rate of reaction. "
}], "MathCaption",
 CellTags->{"S6.7.1", "1.9"}],

Cell["\<\
data = {{1.0, 1.0, .126}, {2.0, 1.0, .219},
{1.0, 2.0, .076}, {2.0, 2.0, .126}, {.1, .0, .186}};\
\>", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S6.7.1"],

Cell[TextData[{
 "This finds the values of the parameters ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Theta]", "1"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Theta]", "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Theta]", "3"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", such that the model ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["y",
     "TI"], "=", 
    SubscriptBox["\[Theta]", "1"], 
    SubscriptBox["\[Theta]", "3"], 
    SubscriptBox[
     StyleBox["x",
      "TI"], "1"], "/", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SubscriptBox["\[Theta]", "1"], 
      SubscriptBox[
       StyleBox["x",
        "TI"], "1"], "+", 
      SubscriptBox["\[Theta]", "2"], 
      SubscriptBox[
       StyleBox["x",
        "TI"], "2"]}], ")"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " best fits the ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     SubscriptBox[
      StyleBox["x",
       "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["x",
       "TI"], "2"], ",", 
     StyleBox["y",
      "TI"]}], ")"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " data triples in a least\[Hyphen]squares sense. The least\[Hyphen]squares \
parameters are substituted into the model, just as in ",
 StyleBox["Fit", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S6.7.1", "1.10"}],

Cell[CellGroupData[{

Cell["\<\
NonlinearFit[data,
theta1 theta3 x1 / (1 + theta1 x1 + theta2 x2),
{x1, x2}, {theta1, theta2, theta3}]\
\>", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S6.7.1"],

Cell[BoxData[
 FractionBox[
  RowBox[{"2.442770157576406`", " ", "x1"}], 
  RowBox[{"1", "+", 
   RowBox[{"3.131505252231769`", " ", "x1"}], "+", 
   RowBox[{"15.15936211334844`", " ", "x2"}]}]]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S6.7.1"]
}, Open  ]],

Cell[TextData[{
 StyleBox["NonlinearRegress", "MR"],
 " can be used to produce a list of replacement rules for the parameters. "
}], "MathCaption",
 CellTags->{"S6.7.1", "1.11"}],

Cell[CellGroupData[{

Cell["\<\
BestFitParameters /. NonlinearRegress[data,
theta1 theta3 x1 / (1 + theta1 x1 + theta2 x2),
{x1, x2}, {theta1, theta2, theta3},
RegressionReport -> BestFitParameters]\
\>", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S6.7.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"theta1", "\[Rule]", "3.131505252231769`"}], ",", 
   RowBox[{"theta2", "\[Rule]", "15.15936211334844`"}], ",", 
   RowBox[{"theta3", "\[Rule]", "0.7800626091351712`"}]}], "}"}]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S6.7.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["option name", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["default value", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox["",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["AccuracyGoal", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Automatic", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["accuracy desired for the ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SuperscriptBox["\[Chi]", "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" merit function",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Compiled", "MR",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Automatic", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "whether to try compiled functions for speed",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Gradient", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Automatic", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "list of gradient functions",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["MaxIterations", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["100", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "maximum number of iterations in search",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Method", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["LevenbergMarquardt", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox["method used in fit",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["PrecisionGoal", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Automatic", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["precision desired for the ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SuperscriptBox["\[Chi]", "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" merit function",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Weights", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Automatic", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "list of weights for each data point or pure function",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["WorkingPrecision", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["MachinePrecision", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "precision of the arithmetic to use in calculations",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
 GridBoxOptions->{RowLines->{True, False},
 RowSpacings->0.4},
 CellTags->"S6.7.1"],

Cell[TextData[{
 "Options for ",
 StyleBox["NonlinearFit", "MR"],
 " and ",
 StyleBox["NonlinearRegress", "MR"],
 "."
}], "Caption",
 CellTags->"S6.7.1"],

Cell[TextData[{
 StyleBox["NonlinearFit", "MR"],
 " and ",
 StyleBox["NonlinearRegress", "MR"],
 " use ",
 StyleBox["FindFit", "MR"],
 " to find parameter estimates, thus both functions accept the ",
 StyleBox["FindFit", "MR"],
 " options ",
 StyleBox["AccuracyGoal", "MR"],
 ", ",
 StyleBox["Compiled", "MR"],
 ", ",
 StyleBox["Gradient", "MR"],
 ", ",
 StyleBox["MaxIterations", "MR"],
 ", ",
 StyleBox["Method", "MR"],
 ", ",
 StyleBox["PrecisionGoal", "MR"],
 ", and ",
 StyleBox["WorkingPrecision", "MR"],
 ". The ",
 StyleBox["Method", "MR"],
 " option allows you to choose between algorithms for performing the \
minimization of the ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Chi]", "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " merit function. The ",
 StyleBox["LevenbergMarquardt", "MR"],
 " method gradually shifts the search for the minimum of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Chi]", "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " from steepest descent to quadratic minimization. Other possible settings \
for ",
 StyleBox["Method", "MR"],
 " are ",
 StyleBox["Gradient", "MR"],
 " (steepest descent), ",
 StyleBox["Newton", "MR"],
 ", ",
 StyleBox["QuasiNewton", "MR"],
 ", and ",
 StyleBox["Automatic", "MR"],
 ". "
}], "Text",
 CellTags->{"S6.7.1", "1.12"}],

Cell[TextData[{
 "The ",
 StyleBox["Weights", "MR"],
 " option allows you to implement weighted least squares by specifying a list \
of weights, one for each data point; the default ",
 StyleBox["Weights -> Automatic", "MR"],
 " implies a weight of unity for each data point. When ",
 StyleBox["Weights -> {", "MR"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["w",
     "TI"], "1"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox[", \[Ellipsis] , ", "MR"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["w",
     "TI"], 
    StyleBox["n",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox["}", "MR"],
 ", the parameter estimates are chosen to minimize the weighted sum of \
squared residuals ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{
      StyleBox["i",
       "TI"], "=", "1"}], 
     StyleBox["n",
      "TI"],
     LimitsPositioning->True], 
    SubscriptBox[
     StyleBox["w",
      "TI"], 
     StyleBox["i",
      "TI"]], " ", 
    SubsuperscriptBox[
     StyleBox["e",
      "TI"], 
     StyleBox["i",
      "TI"], "2"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "Text",
 CellTags->{"S6.7.1", "1.13"}],

Cell[TextData[{
 StyleBox["Weights", "MR"],
 " can also specify a pure function of the response. For example, to choose \
parameter estimates to minimize ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{
      StyleBox["i",
       "TI"], "=", "1"}], 
     StyleBox["n",
      "TI"],
     LimitsPositioning->True], 
    SqrtBox[
     SubscriptBox[
      StyleBox["y",
       "TI"], 
      StyleBox["i",
       "TI"]]], " ", 
    SubsuperscriptBox[
     StyleBox["e",
      "TI"], 
     StyleBox["i",
      "TI"], "2"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", set ",
 StyleBox["Weights -> (Sqrt[#] &)", "MR"],
 ". "
}], "Text",
 CellTags->{"S6.7.1", "1.14"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["option name", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["default value", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox["",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["RegressionReport", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["SummaryReport", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "objects to be included in output",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Tolerance", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Automatic", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "numerical tolerance for matrix operations",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
 GridBoxOptions->{RowLines->{True, False},
 RowSpacings->0.4},
 CellTags->"S6.7.1"],

Cell[TextData[{
 "Options unique to ",
 StyleBox["NonlinearRegress", "MR"],
 "."
}], "Caption",
 CellTags->"S6.7.1"],

Cell[TextData[{
 "The option ",
 StyleBox["RegressionReport", "MR"],
 " is accepted by ",
 StyleBox["NonlinearRegress", "MR"],
 ", but not ",
 StyleBox["NonlinearFit", "MR"],
 ". If ",
 StyleBox["RegressionReport", "MR"],
 " is not specified, ",
 StyleBox["NonlinearRegress", "MR"],
 " automatically gives a list including values for ",
 StyleBox["BestFitParameters", "MR"],
 ", ",
 StyleBox["ParameterCITable", "MR"],
 ", ",
 StyleBox["EstimatedVariance", "MR"],
 ", ",
 StyleBox["ANOVATable", "MR"],
 ", ",
 StyleBox["AsymptoticCorrelationMatrix", "MR"],
 ", and ",
 StyleBox["FitCurvatureTable", "MR"],
 ". This set of objects comprises the default ",
 StyleBox["SummaryReport", "MR"],
 ". The option ",
 StyleBox["RegressionReport", "MR"],
 " can be used to specify a single object or a list of objects so that more \
(or less) than the default set of results is included in the output. ",
 StyleBox["RegressionReportValues[NonlinearRegress]", "MR"],
 " gives the objects that may be included in the ",
 StyleBox["RegressionReport", "MR"],
 " list for the ",
 StyleBox["NonlinearRegress", "MR"],
 " function. "
}], "Text",
 CellTags->{"S6.7.1", "1.15"}],

Cell[TextData[{
 StyleBox["NonlinearRegress", "MR"],
 " will also accept any option that can be specified for ",
 StyleBox["StudentTCI", "MR"],
 ". In particular, ",
 StyleBox["ConfidenceLevel", "MR"],
 " specifies the reference parameter confidence region (the relative \
curvature of which is given in ",
 StyleBox["FitCurvatureTable", "MR"],
 ") and the individual parameter confidence intervals given in ",
 StyleBox["ParameterCITable", "MR"],
 ". "
}], "Text",
 CellTags->{"S6.7.1", "1.16"}],

Cell[TextData[{
 "If the ",
 StyleBox["RegressionReport", "MR"],
 " option is not specified, the default regression output is produced. Note \
that the ",
 StyleBox["AsymptoticCorrelationMatrix", "MR"],
 " indicates that the parameters ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Theta]", "1"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Theta]", "3"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " are highly correlated, a negative aspect of this model. "
}], "MathCaption",
 CellTags->{"S6.7.1", "1.17"}],

Cell[CellGroupData[{

Cell["\<\
NonlinearRegress[data,
theta1 theta3 x1 / (1 + theta1 x1 + theta2 x2),
{x1, x2}, {theta1, theta2, theta3}]\
\>", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S6.7.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"BestFitParameters", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"theta1", "\[Rule]", "3.131505252231769`"}], ",", 
      RowBox[{"theta2", "\[Rule]", "15.15936211334844`"}], ",", 
      RowBox[{"theta3", "\[Rule]", "0.7800626091351712`"}]}], "}"}]}], ",", 
   RowBox[{"ParameterCITable", "\[Rule]", 
    TagBox[GridBox[{
       {"\<\"\"\>", "\<\"Estimate\"\>", "\<\"Asymptotic SE\"\>", \
"\<\"CI\"\>"},
       {"theta1", "3.131505252231769`", "0.808417000408599`", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.3468323613521629`"}], ",", "6.6098428658157005`"}], 
         "}"}]},
       {"theta2", "15.15936211334844`", "0.6312240700715965`", 
        RowBox[{"{", 
         RowBox[{"12.443424145171319`", ",", "17.875300081525562`"}], "}"}]},
       {"theta3", "0.7800626091351712`", "0.15179713972340986`", 
        RowBox[{"{", 
         RowBox[{"0.12693223153608102`", ",", "1.4331929867342614`"}], "}"}]}
       },
      RowSpacings->1,
      ColumnSpacings->3,
      RowAlignments->Baseline,
      ColumnAlignments->{Left}],
     Function[BoxForm`e$, 
      TableForm[
      BoxForm`e$, TableDepth -> 2, 
       TableHeadings -> {{theta1, theta2, theta3}, {
         "Estimate", "Asymptotic SE", "CI"}}]]]}], ",", 
   RowBox[{"EstimatedVariance", "\[Rule]", "0.000021776330970950753`"}], ",", 
   
   RowBox[{"ANOVATable", "\[Rule]", 
    InterpretationBox[GridBox[{
       {"\<\"\"\>", "\<\"DF\"\>", "\<\"SumOfSq\"\>", "\<\"MeanSq\"\>"},
       {"\<\"Model\"\>", "3", "0.12004144733805809`", 
        "0.040013815779352695`"},
       {"\<\"Error\"\>", "2", "0.000043552661941901505`", 
        "0.000021776330970950753`"},
       {"\<\"Uncorrected Total\"\>", "5", "0.120085`", "\<\"\"\>"},
       {"\<\"Corrected Total\"\>", "4", "0.0126272`", "\<\"\"\>"}
       },
      RowSpacings->1,
      ColumnSpacings->3,
      RowAlignments->Baseline,
      ColumnAlignments->{Left}],
     TableForm[{{3, 0.120041447338058, 0.0400138157793527}, {
       2, 4.35526619419015*^-5, 2.17763309709508*^-5}, {5, 0.120085}, {
       4, 0.0126272}}, 
      TableHeadings -> {{
        "Model", "Error", "Uncorrected Total", "Corrected Total"}, {
        "DF", "SumOfSq", "MeanSq"}}]]}], ",", 
   RowBox[{"AsymptoticCorrelationMatrix", "\[Rule]", 
    TagBox[
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {"1.`", "0.2870146705177362`", 
         RowBox[{"-", "0.9918299927009434`"}]},
        {"0.2870146705177362`", "0.9999999999999999`", 
         RowBox[{"-", "0.18202083962724933`"}]},
        {
         RowBox[{"-", "0.9918299927009436`"}], 
         RowBox[{"-", "0.18202083962724935`"}], "1.0000000000000002`"}
        }], "\[NoBreak]", ")"}],
     Function[BoxForm`e$, 
      MatrixForm[BoxForm`e$]]]}], ",", 
   RowBox[{"FitCurvatureTable", "\[Rule]", 
    TagBox[GridBox[{
       {"\<\"\"\>", "\<\"Curvature\"\>"},
       {"\<\"Max Intrinsic\"\>", "0.037466950375689874`"},
       {"\<\"Max Parameter-Effects\"\>", "12.816088475336768`"},
       {"\<\"95. % Confidence Region\"\>", "0.22843024672369971`"}
       },
      RowSpacings->1,
      ColumnSpacings->3,
      RowAlignments->Baseline,
      ColumnAlignments->{Left}],
     Function[BoxForm`e$, 
      TableForm[
      BoxForm`e$, TableDepth -> 2, 
       TableHeadings -> {{
         "Max Intrinsic", "Max Parameter-Effects", 
          "95. % Confidence Region"}, {"Curvature"}}]]]}]}], "}"}]], "Output",\

 CellLabel->"Out[5]= ",
 CellTags->"S6.7.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["BestFit", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["best fit function ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["BestFitParameters", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "best fit parameter estimates",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ANOVATable", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "analysis of variance table",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["EstimatedVariance", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["estimated error variance ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ParameterTable", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "table of parameter information including asymptotic standard errors and \
test statistics ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ParameterCITable", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "table of asymptotic confidence intervals for the parameters",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ParameterConfidenceRegion", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "asymptotic ellipsoidal joint confidence region for the parameters",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ParameterConfidenceRegion[{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["parm",
          "TI"], 
         RowBox[{
          StyleBox["i",
           "TI"], "1"}]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["parm",
          "TI"], 
         RowBox[{
          StyleBox["i",
           "TI"], "2"}]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] }]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "asymptotic ellipsoidal conditional joint confidence region for the \
parameters ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["parm",
          "TI"], 
         RowBox[{
          StyleBox["i",
           "TI"], "1"}]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["parm",
          "TI"], 
         RowBox[{
          StyleBox["i",
           "TI"], "2"}]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] }",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["FitResiduals", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "differences between the observed responses and the predicted responses \
",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["PredictedResponse", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "fitted values obtained by evaluating the best fit function at the \
observed values of the independent variables",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["SinglePredictionCITable", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "table of asymptotic confidence intervals for predicting a single \
observation of the response variable ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["MeanPredictionCITable", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "table of asymptotic confidence intervals for predicting the expected \
value of the response variable",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["AsymptoticCovarianceMatrix", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "asymptotic covariance matrix of the parameters ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["AsymptoticCorrelationMatrix", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "asymptotic correlation matrix of the parameters ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S6.7.1"],

Cell[TextData[{
 "Some option settings for ",
 StyleBox["RegressionReport", "MR"],
 " or objects that may be included in a list specified by ",
 StyleBox["RegressionReport", "MR"],
 "."
}], "Caption",
 CellTags->"S6.7.1"],

Cell[TextData[{
 StyleBox["ANOVATable", "MR"],
 " provides a partitioning of the sum of squares. Both the uncorrected total \
sum of squares (without intercept term) and the corrected total sum of \
squares (with intercept term) are included. The corrected total sum of \
squares is useful for calculating a value for ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["R",
     "TI"], "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " comparable to that produced by ",
 StyleBox["Regress", "MR"],
 ", so that the fit of a nonlinear model can be compared to the fit of a \
linear model. For example, one possible definition of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["R",
     "TI"], "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " for a nonlinear regression is the ratio of the difference between the \
corrected total sum of squares and the residual sum of squares to the \
corrected total sum of squares. The other objects in this table have meanings \
similar to what they would have if specified by the ",
 StyleBox["RegressionReport", "MR"],
 " option of the linear regression function ",
 StyleBox["Regress", "MR"],
 ". "
}], "Text",
 CellTags->{"S6.7.1", "1.18"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["StartingParameters", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "starting values for the parameters",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S6.7.1"],

Cell["\<\
Objects describing the search for the least\[Hyphen]squares fit.\
\>", "Caption",
 CellTags->"S6.7.1"],

Cell[TextData[{
 "Including ",
 StyleBox["StartingParameters", "MR"],
 " in the list of objects requested by ",
 StyleBox["RegressionReport", "MR"],
 " is helpful if the search for a least\[Hyphen]squares fit is unsuccessful \
and it is necessary to restart the search at a new point. "
}], "Text",
 CellTags->{"S6.7.1", "1.19"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["HatDiagonal", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["diagonal of the hat matrix ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["X",
          "TI"], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox[
             StyleBox["X",
              "TI"], 
             StyleBox["T",
              "TI"]], 
            StyleBox["X",
             "TI"]}], ")"}], 
          RowBox[{"-", "1"}]], 
         SuperscriptBox[
          StyleBox["X",
           "TI"], 
          StyleBox["T",
           "TI"]]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", where ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["X",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[
      " is the design matrix for the approximate linear model at the least\
\[Hyphen]squares parameter estimates ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["StandardizedResiduals", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "fit residuals scaled by their asymptotic standard errors, computed \
using the estimated error variance",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S6.7.1"],

Cell["Diagnostics for detecting outliers.", "Caption",
 CellTags->"S6.7.1"],

Cell[TextData[{
 "If the nonlinear model is approximately linear at the least\[Hyphen]squares \
fit, ",
 StyleBox["HatDiagonal", "MR"],
 " and ",
 StyleBox["StandardizedResiduals", "MR"],
 " are useful for detecting outliers in the data. ",
 StyleBox["HatDiagonal", "MR"],
 " gives the leverage of each point, measuring whether each observation of \
the predictor variables is unusual; a leverage of zero indicates no \
influence, while a leverage of one indicates that a degree of freedom has \
been lost to fitting that point. "
}], "Text",
 CellTags->{"S6.7.1", "1.20"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["FitCurvatureTable", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "maximum relative intrinsic curvature, maximum relative parameter\
\[Hyphen]effects curvature, and relative curvature of the \
least\[Hyphen]squares solution confidence region (where confidence level is \
given by ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ConfidenceLevel", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[")",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ParameterBias", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "bias in the least\[Hyphen]squares estimates of the parameters in a \
nonlinear model",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S6.7.1"],

Cell["\<\
Diagnostics for evaluating the validity of a linear model approximation to \
the nonlinear model.\
\>", "Caption",
 CellTags->"S6.7.1"],

Cell[TextData[{
 StyleBox["FitCurvatureTable", "MR"],
 " expresses the relative curvature of the solution locus at the least\
\[Hyphen]squares estimate in terms of two components, intrinsic and parameter\
\[Hyphen]effects. For the combination of data and model given above, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["p",
     "TI"], "=", "3"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["n",
     "TI"], "=", "5"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". The solution locus is a ",
 Cell[BoxData[
  FormBox["3", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "\[Hyphen]dimensional subspace of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["R",
     "TI"], "5"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"1.0", " "}], 
      SubscriptBox["\[Theta]", "1"], 
      RowBox[{
       SubscriptBox["\[Theta]", "3"], "/", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{
          RowBox[{"1.0", " "}], 
          SubscriptBox["\[Theta]", "1"]}], "+", 
         RowBox[{
          RowBox[{"1.0", " "}], 
          SubscriptBox["\[Theta]", "2"]}]}], ")"}]}]}], ","}]}], 
   TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"2.0", " "}], 
     SubscriptBox["\[Theta]", "1"], 
     RowBox[{
      SubscriptBox["\[Theta]", "3"], "/", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{
         RowBox[{"2.0", " "}], 
         SubscriptBox["\[Theta]", "1"]}], "+", 
        RowBox[{
         RowBox[{"1.0", " "}], 
         SubscriptBox["\[Theta]", "2"]}]}], ")"}]}]}], ","}], 
   TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"1.0", " "}], 
     SubscriptBox["\[Theta]", "1"], 
     RowBox[{
      SubscriptBox["\[Theta]", "3"], "/", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{
         RowBox[{"1.0", " "}], 
         SubscriptBox["\[Theta]", "1"]}], "+", 
        RowBox[{
         RowBox[{"2.0", " "}], 
         SubscriptBox["\[Theta]", "2"]}]}], ")"}]}]}], ","}], 
   TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"2.0", " "}], 
     SubscriptBox["\[Theta]", "1"], 
     RowBox[{
      SubscriptBox["\[Theta]", "3"], "/", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{
         RowBox[{"2.0", " "}], 
         SubscriptBox["\[Theta]", "1"]}], "+", 
        RowBox[{
         RowBox[{"2.0", " "}], 
         SubscriptBox["\[Theta]", "2"]}]}], ")"}]}]}], ","}], 
   TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " ",
 Cell[BoxData[
  RowBox[{
   FormBox[
    RowBox[{
     RowBox[{"0.1", " "}], 
     SubscriptBox["\[Theta]", "1"], 
     RowBox[{
      SubscriptBox["\[Theta]", "3"], "/", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{
         RowBox[{"0.1", " "}], 
         SubscriptBox["\[Theta]", "1"]}]}], ")"}]}]}],
    TraditionalForm], "}"}]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["\[Theta]", "1"], ",", 
      SubscriptBox["\[Theta]", "2"], ",", 
      SubscriptBox["\[Theta]", "3"]}], "}"}], "\[Element]", 
    SubscriptBox[
     StyleBox["R",
      "TI"], "3"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "Text",
 CellTags->{"S6.7.1", "1.21"}],

Cell[TextData[{
 "Intrinsic curvature describes the normal component of the solution locus \
curvature at the least\[Hyphen]squares estimate. Parameter\[Hyphen]effects \
curvature describes the tangential component of the solution locus curvature \
at the least\[Hyphen]squares estimate. Standardizing curvature to be response\
\[Hyphen]invariant gives relative curvature. Maximizing the relative \
intrinsic curvature over the ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     StyleBox["n",
      "TI"], "-", 
     StyleBox["p",
      "TI"]}], ")"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "\[Hyphen]dimensional subspace normal to the locus gives the maximum \
relative intrinsic curvature. Similarly, maximizing the relative parameter\
\[Hyphen]effects curvature over the ",
 Cell[BoxData[
  FormBox[
   StyleBox["p",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "\[Hyphen]dimensional subspace tangential to the locus gives the maximum \
relative parameter\[Hyphen]effects curvature. "
}], "Text",
 CellTags->{"S6.7.1", "1.22"}],

Cell["\<\
Both of these quantities can be compared to the relative curvature of the \
confidence region centered on the least\[Hyphen]squares parameter estimates. \
If the maximum relative intrinsic curvature is small compared to the \
confidence region relative curvature, the solution locus is approximately \
planar over the confidence region. If the maximum relative \
parameter\[Hyphen]effects curvature is small compared to the confidence \
region relative curvature, the parameter coordinates projected onto the \
tangential plane are approximately parallel and uniformly spaced over the \
confidence region. \
\>", "Text",
 CellTags->{"S6.7.1", "1.23"}],

Cell[TextData[{
 StyleBox["ParameterBias", "MR"],
 " is based on the average curvature of the solution locus tangential to the \
least\[Hyphen]squares estimate. "
}], "Text",
 CellTags->{"S6.7.1", "1.24"}],

Cell[TextData[{
 "Here the same data is fit to a reparametrized model, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["y",
     "TI"], "=", 
    SubscriptBox[
     StyleBox["x",
      "TI"], "1"], "/", 
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["\[Phi]", "0"], "+", 
      SubscriptBox["\[Phi]", "1"], 
      SubscriptBox[
       StyleBox["x",
        "TI"], "1"], "+", 
      SubscriptBox["\[Phi]", "2"], 
      SubscriptBox[
       StyleBox["x",
        "TI"], "2"]}], ")"}], "."}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " Only the ",
 StyleBox["BestFit", "MR"],
 ", ",
 StyleBox["AsymptoticCorrelationMatrix", "MR"],
 ", and ",
 StyleBox["FitCurvatureTable", "MR"],
 " are calculated. "
}], "MathCaption",
 CellTags->{"S6.7.1", "1.25"}],

Cell[CellGroupData[{

Cell["\<\
NonlinearRegress[data,
x1 / (phi0 + phi1 x1 + phi2 x2),
{x1, x2}, {phi0, phi1, phi2},
RegressionReport -> {BestFit,
 AsymptoticCorrelationMatrix, FitCurvatureTable}]\
\>", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S6.7.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"BestFit", "\[Rule]", 
    FractionBox["x1", 
     RowBox[{
      RowBox[{"0.4093713020322022`", "\[InvisibleSpace]"}], "+", 
      RowBox[{"1.2819483825747544`", " ", "x1"}], "+", 
      RowBox[{"6.205807806333394`", " ", "x2"}]}]]}], ",", 
   RowBox[{"AsymptoticCorrelationMatrix", "\[Rule]", 
    TagBox[
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {"1.`", 
         RowBox[{"-", "0.8814080653861742`"}], "0.8026386256373869`"},
        {
         RowBox[{"-", "0.8814080653861742`"}], "1.0000000000000002`", 
         RowBox[{"-", "0.9274654903594932`"}]},
        {"0.8026386256373869`", 
         RowBox[{"-", "0.9274654903594932`"}], "1.`"}
        }], "\[NoBreak]", ")"}],
     Function[BoxForm`e$, 
      MatrixForm[BoxForm`e$]]]}], ",", 
   RowBox[{"FitCurvatureTable", "\[Rule]", 
    TagBox[GridBox[{
       {"\<\"\"\>", "\<\"Curvature\"\>"},
       {"\<\"Max Intrinsic\"\>", "0.03746690753980467`"},
       {"\<\"Max Parameter-Effects\"\>", "0.08932052625292317`"},
       {"\<\"95. % Confidence Region\"\>", "0.22843024672369971`"}
       },
      RowSpacings->1,
      ColumnSpacings->3,
      RowAlignments->Baseline,
      ColumnAlignments->{Left}],
     Function[BoxForm`e$, 
      TableForm[
      BoxForm`e$, TableDepth -> 2, 
       TableHeadings -> {{
         "Max Intrinsic", "Max Parameter-Effects", 
          "95. % Confidence Region"}, {"Curvature"}}]]]}]}], "}"}]], "Output",\

 CellLabel->"Out[6]= ",
 CellTags->"S6.7.1"]
}, Open  ]],

Cell[TextData[{
 "Note that reparametrizing the model does not affect the intrinsic \
curvature. However, here reparametrization has reduced the \
parameter\[Hyphen]effects curvature below the critical value of 0.22843. This \
indicates that the least\[Hyphen]squares estimates of the parameters ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Phi]", "0"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Phi]", "1"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Phi]", "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " have nearly linear behavior. This could not be said about the least\
\[Hyphen]squares estimates of the parameters ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Theta]", "1"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Theta]", "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Theta]", "3"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " in the original model [Ratkowsky, 1983]. Unfortunately, now the asymptotic \
correlation between parameters is high for all pairs; a model with fewer \
parameters should be considered. "
}], "Text",
 CellTags->{"S6.7.1", "1.26"}],

Cell[TextData[{
 "The maximum relative curvature diagnostics are useful if you wish to make \
inferences based on the linear approximation to the nonlinear model. For \
example, diagnostics based on the asymptotic standard errors of the \
parameters, such as ",
 StyleBox["ParameterCITable", "MR"],
 " and ",
 StyleBox["ParameterConfidenceRegion", "MR"],
 ", are of questionable validity when the linear approximation to the model \
is poor at the least\[Hyphen]squares parameter estimates. The linear \
approximation is based on the planar assumption, tested by maximum relative \
intrinsic curvature, and the uniform coordinate assumption, tested by maximum \
relative parameter\[Hyphen]effects curvature. It is usually the uniform \
coordinate assumption that is invalid [Bates and Watts, 1988]. "
}], "Text",
 CellTags->{"S6.7.1", "1.27"}],

Cell[CellGroupData[{

Cell["References", "Subsubsection",
 CellTags->{"S6.7.1", "1.28"}],

Cell[TextData[{
 "Bates, D. M. and Watts, D. G. (1988). ",
 StyleBox["Nonlinear Regression Analysis and Its Applications", "TI"],
 ", John Wiley & Sons, New York. \nMeyer, R. R. and Roth, P. M. (1972). \
\[OpenCurlyDoubleQuote]Modified Damped Least Squares: An Algorithm for \
Nonlinear Estimation,\[CloseCurlyDoubleQuote] ",
 StyleBox["J. Inst. Math. Appl.", "TI"],
 " 9, 218\[Dash]233.\nRatkowsky, David A. (1983). ",
 StyleBox["Nonlinear Regression Modeling, A Unified Practical Approach", 
  "TI"],
 ", Marcel Dekker, New York. "
}], "Text",
 CellTags->{"S6.7.1", "1.29"}]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S6.7.1"->{
    Cell[1776, 53, 138, 6, 36, "Subsection",
      CellTags->{"S6.7.1", "1.1"}],
    Cell[1917, 61, 930, 21, 120, "Text",
      CellTags->{"S6.7.1", "1.2"}],
    Cell[2850, 84, 2983, 88, 138, "DefinitionBox",
      CellTags->"S6.7.1"],
    Cell[5836, 174, 156, 7, 15, "Caption",
      CellTags->"S6.7.1"],
    Cell[5995, 183, 464, 10, 72, "Text",
      CellTags->{"S6.7.1", "1.3"}],
    Cell[6462, 195, 1243, 40, 72, "Text",
      CellTags->{"S6.7.1", "1.4"}],
    Cell[7708, 237, 8108, 241, 138, "DefinitionBox",
      CellTags->"S6.7.1"],
    Cell[15819, 480, 168, 7, 16, "Caption",
      CellTags->"S6.7.1"],
    Cell[15990, 489, 1223, 37, 109, "Text",
      CellTags->{"S6.7.1", "1.5"}],
    Cell[17216, 528, 2052, 68, 122, "Text",
      CellTags->{"S6.7.1", "1.6"}],
    Cell[19271, 598, 1246, 42, 57, "Text",
      CellTags->{"S6.7.1", "1.7"}],
    Cell[20520, 642, 77, 1, 40, "MathCaption",
      CellTags->{"S6.7.1", "1.8"}],
    Cell[20600, 645, 89, 2, 28, "Input",
      CellTags->"S6.7.1"],
    Cell[20692, 649, 1252, 44, 72, "MathCaption",
      CellTags->{"S6.7.1", "1.9"}],
    Cell[21947, 695, 166, 5, 45, "Input",
      CellTags->"S6.7.1"],
    Cell[22116, 702, 1624, 57, 72, "MathCaption",
      CellTags->{"S6.7.1", "1.10"}],
    Cell[23765, 763, 172, 6, 62, "Input",
      CellTags->"S6.7.1"],
    Cell[23940, 771, 251, 7, 39, "Output",
      CellTags->"S6.7.1"],
    Cell[24206, 781, 178, 4, 56, "MathCaption",
      CellTags->{"S6.7.1", "1.11"}],
    Cell[24409, 789, 236, 7, 79, "Input",
      CellTags->"S6.7.1"],
    Cell[24648, 798, 285, 7, 23, "Output",
      CellTags->"S6.7.1"],
    Cell[24948, 808, 8256, 235, 312, "DefinitionBox3Col",
      CellTags->"S6.7.1"],
    Cell[33207, 1045, 153, 7, 16, "Caption",
      CellTags->"S6.7.1"],
    Cell[33363, 1054, 1384, 50, 122, "Text",
      CellTags->{"S6.7.1", "1.12"}],
    Cell[34750, 1106, 1331, 49, 75, "Text",
      CellTags->{"S6.7.1", "1.13"}],
    Cell[36084, 1157, 743, 30, 45, "Text",
      CellTags->{"S6.7.1", "1.14"}],
    Cell[36830, 1189, 2648, 77, 120, "DefinitionBox3Col",
      CellTags->"S6.7.1"],
    Cell[39481, 1268, 116, 5, 16, "Caption",
      CellTags->"S6.7.1"],
    Cell[39600, 1275, 1157, 36, 152, "Text",
      CellTags->{"S6.7.1", "1.15"}],
    Cell[40760, 1313, 496, 13, 72, "Text",
      CellTags->{"S6.7.1", "1.16"}],
    Cell[41259, 1328, 643, 18, 72, "MathCaption",
      CellTags->{"S6.7.1", "1.17"}],
    Cell[41927, 1350, 176, 6, 62, "Input",
      CellTags->"S6.7.1"],
    Cell[42106, 1358, 3506, 88, 391, "Output",
      CellTags->"S6.7.1"],
    Cell[45627, 1449, 9355, 281, 70, "DefinitionBox",
      CellTags->"S6.7.1"],
    Cell[54985, 1732, 221, 7, 70, "Caption",
      CellTags->"S6.7.1"],
    Cell[55209, 1741, 1286, 31, 70, "Text",
      CellTags->{"S6.7.1", "1.18"}],
    Cell[56498, 1774, 682, 21, 70, "DefinitionBox",
      CellTags->"S6.7.1"],
    Cell[57183, 1797, 112, 3, 70, "Caption",
      CellTags->"S6.7.1"],
    Cell[57298, 1802, 329, 8, 70, "Text",
      CellTags->{"S6.7.1", "1.19"}],
    Cell[57630, 1812, 2434, 77, 70, "DefinitionBox",
      CellTags->"S6.7.1"],
    Cell[60067, 1891, 75, 1, 70, "Caption",
      CellTags->"S6.7.1"],
    Cell[60145, 1894, 573, 13, 70, "Text",
      CellTags->{"S6.7.1", "1.20"}],
    Cell[60721, 1909, 1614, 48, 70, "DefinitionBox",
      CellTags->"S6.7.1"],
    Cell[62338, 1959, 145, 4, 70, "Caption",
      CellTags->"S6.7.1"],
    Cell[62486, 1965, 3905, 137, 70, "Text",
      CellTags->{"S6.7.1", "1.21"}],
    Cell[66394, 2104, 1137, 27, 70, "Text",
      CellTags->{"S6.7.1", "1.22"}],
    Cell[67534, 2133, 661, 11, 70, "Text",
      CellTags->{"S6.7.1", "1.23"}],
    Cell[68198, 2146, 205, 5, 70, "Text",
      CellTags->{"S6.7.1", "1.24"}],
    Cell[68406, 2153, 800, 30, 70, "MathCaption",
      CellTags->{"S6.7.1", "1.25"}],
    Cell[69231, 2187, 235, 8, 70, "Input",
      CellTags->"S6.7.1"],
    Cell[69469, 2197, 1508, 41, 70, "Output",
      CellTags->"S6.7.1"],
    Cell[70992, 2241, 1533, 39, 70, "Text",
      CellTags->{"S6.7.1", "1.26"}],
    Cell[72528, 2282, 843, 15, 70, "Text",
      CellTags->{"S6.7.1", "1.27"}],
    Cell[73396, 2301, 66, 1, 70, "Subsubsection",
      CellTags->{"S6.7.1", "1.28"}],
    Cell[73465, 2304, 576, 12, 70, "Text",
      CellTags->{"S6.7.1", "1.29"}]},
  "1.1"->{
    Cell[1776, 53, 138, 6, 36, "Subsection",
      CellTags->{"S6.7.1", "1.1"}]},
  "1.2"->{
    Cell[1917, 61, 930, 21, 120, "Text",
      CellTags->{"S6.7.1", "1.2"}]},
  "1.3"->{
    Cell[5995, 183, 464, 10, 72, "Text",
      CellTags->{"S6.7.1", "1.3"}]},
  "1.4"->{
    Cell[6462, 195, 1243, 40, 72, "Text",
      CellTags->{"S6.7.1", "1.4"}]},
  "1.5"->{
    Cell[15990, 489, 1223, 37, 109, "Text",
      CellTags->{"S6.7.1", "1.5"}]},
  "1.6"->{
    Cell[17216, 528, 2052, 68, 122, "Text",
      CellTags->{"S6.7.1", "1.6"}]},
  "1.7"->{
    Cell[19271, 598, 1246, 42, 57, "Text",
      CellTags->{"S6.7.1", "1.7"}]},
  "1.8"->{
    Cell[20520, 642, 77, 1, 40, "MathCaption",
      CellTags->{"S6.7.1", "1.8"}]},
  "1.9"->{
    Cell[20692, 649, 1252, 44, 72, "MathCaption",
      CellTags->{"S6.7.1", "1.9"}]},
  "1.10"->{
    Cell[22116, 702, 1624, 57, 72, "MathCaption",
      CellTags->{"S6.7.1", "1.10"}]},
  "1.11"->{
    Cell[24206, 781, 178, 4, 56, "MathCaption",
      CellTags->{"S6.7.1", "1.11"}]},
  "1.12"->{
    Cell[33363, 1054, 1384, 50, 122, "Text",
      CellTags->{"S6.7.1", "1.12"}]},
  "1.13"->{
    Cell[34750, 1106, 1331, 49, 75, "Text",
      CellTags->{"S6.7.1", "1.13"}]},
  "1.14"->{
    Cell[36084, 1157, 743, 30, 45, "Text",
      CellTags->{"S6.7.1", "1.14"}]},
  "1.15"->{
    Cell[39600, 1275, 1157, 36, 152, "Text",
      CellTags->{"S6.7.1", "1.15"}]},
  "1.16"->{
    Cell[40760, 1313, 496, 13, 72, "Text",
      CellTags->{"S6.7.1", "1.16"}]},
  "1.17"->{
    Cell[41259, 1328, 643, 18, 72, "MathCaption",
      CellTags->{"S6.7.1", "1.17"}]},
  "1.18"->{
    Cell[55209, 1741, 1286, 31, 70, "Text",
      CellTags->{"S6.7.1", "1.18"}]},
  "1.19"->{
    Cell[57298, 1802, 329, 8, 70, "Text",
      CellTags->{"S6.7.1", "1.19"}]},
  "1.20"->{
    Cell[60145, 1894, 573, 13, 70, "Text",
      CellTags->{"S6.7.1", "1.20"}]},
  "1.21"->{
    Cell[62486, 1965, 3905, 137, 70, "Text",
      CellTags->{"S6.7.1", "1.21"}]},
  "1.22"->{
    Cell[66394, 2104, 1137, 27, 70, "Text",
      CellTags->{"S6.7.1", "1.22"}]},
  "1.23"->{
    Cell[67534, 2133, 661, 11, 70, "Text",
      CellTags->{"S6.7.1", "1.23"}]},
  "1.24"->{
    Cell[68198, 2146, 205, 5, 70, "Text",
      CellTags->{"S6.7.1", "1.24"}]},
  "1.25"->{
    Cell[68406, 2153, 800, 30, 70, "MathCaption",
      CellTags->{"S6.7.1", "1.25"}]},
  "1.26"->{
    Cell[70992, 2241, 1533, 39, 70, "Text",
      CellTags->{"S6.7.1", "1.26"}]},
  "1.27"->{
    Cell[72528, 2282, 843, 15, 70, "Text",
      CellTags->{"S6.7.1", "1.27"}]},
  "1.28"->{
    Cell[73396, 2301, 66, 1, 70, "Subsubsection",
      CellTags->{"S6.7.1", "1.28"}]},
  "1.29"->{
    Cell[73465, 2304, 576, 12, 70, "Text",
      CellTags->{"S6.7.1", "1.29"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S6.7.1", 74691, 2336},
  {"1.1", 78987, 2447},
  {"1.2", 79080, 2450},
  {"1.3", 79169, 2453},
  {"1.4", 79258, 2456},
  {"1.5", 79348, 2459},
  {"1.6", 79440, 2462},
  {"1.7", 79532, 2465},
  {"1.8", 79623, 2468},
  {"1.9", 79718, 2471},
  {"1.10", 79817, 2474},
  {"1.11", 79917, 2477},
  {"1.12", 80015, 2480},
  {"1.13", 80110, 2483},
  {"1.14", 80204, 2486},
  {"1.15", 80297, 2489},
  {"1.16", 80392, 2492},
  {"1.17", 80485, 2495},
  {"1.18", 80585, 2498},
  {"1.19", 80679, 2501},
  {"1.20", 80771, 2504},
  {"1.21", 80864, 2507},
  {"1.22", 80959, 2510},
  {"1.23", 81053, 2513},
  {"1.24", 81146, 2516},
  {"1.25", 81238, 2519},
  {"1.26", 81338, 2522},
  {"1.27", 81432, 2525},
  {"1.28", 81525, 2528},
  {"1.29", 81625, 2531}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 138, 6, 36, "Subsection",
  CellTags->{"S6.7.1", "1.1"}],
Cell[1917, 61, 930, 21, 120, "Text",
  CellTags->{"S6.7.1", "1.2"}],
Cell[2850, 84, 2983, 88, 138, "DefinitionBox",
  CellTags->"S6.7.1"],
Cell[5836, 174, 156, 7, 15, "Caption",
  CellTags->"S6.7.1"],
Cell[5995, 183, 464, 10, 72, "Text",
  CellTags->{"S6.7.1", "1.3"}],
Cell[6462, 195, 1243, 40, 72, "Text",
  CellTags->{"S6.7.1", "1.4"}],
Cell[7708, 237, 8108, 241, 138, "DefinitionBox",
  CellTags->"S6.7.1"],
Cell[15819, 480, 168, 7, 16, "Caption",
  CellTags->"S6.7.1"],
Cell[15990, 489, 1223, 37, 109, "Text",
  CellTags->{"S6.7.1", "1.5"}],
Cell[17216, 528, 2052, 68, 122, "Text",
  CellTags->{"S6.7.1", "1.6"}],
Cell[19271, 598, 1246, 42, 57, "Text",
  CellTags->{"S6.7.1", "1.7"}],
Cell[20520, 642, 77, 1, 40, "MathCaption",
  CellTags->{"S6.7.1", "1.8"}],
Cell[20600, 645, 89, 2, 28, "Input",
  CellTags->"S6.7.1"],
Cell[20692, 649, 1252, 44, 72, "MathCaption",
  CellTags->{"S6.7.1", "1.9"}],
Cell[21947, 695, 166, 5, 45, "Input",
  CellTags->"S6.7.1"],
Cell[22116, 702, 1624, 57, 72, "MathCaption",
  CellTags->{"S6.7.1", "1.10"}],

Cell[CellGroupData[{
Cell[23765, 763, 172, 6, 62, "Input",
  CellTags->"S6.7.1"],
Cell[23940, 771, 251, 7, 39, "Output",
  CellTags->"S6.7.1"]
}, Open  ]],
Cell[24206, 781, 178, 4, 56, "MathCaption",
  CellTags->{"S6.7.1", "1.11"}],

Cell[CellGroupData[{
Cell[24409, 789, 236, 7, 79, "Input",
  CellTags->"S6.7.1"],
Cell[24648, 798, 285, 7, 23, "Output",
  CellTags->"S6.7.1"]
}, Open  ]],
Cell[24948, 808, 8256, 235, 312, "DefinitionBox3Col",
  CellTags->"S6.7.1"],
Cell[33207, 1045, 153, 7, 16, "Caption",
  CellTags->"S6.7.1"],
Cell[33363, 1054, 1384, 50, 122, "Text",
  CellTags->{"S6.7.1", "1.12"}],
Cell[34750, 1106, 1331, 49, 75, "Text",
  CellTags->{"S6.7.1", "1.13"}],
Cell[36084, 1157, 743, 30, 45, "Text",
  CellTags->{"S6.7.1", "1.14"}],
Cell[36830, 1189, 2648, 77, 120, "DefinitionBox3Col",
  CellTags->"S6.7.1"],
Cell[39481, 1268, 116, 5, 16, "Caption",
  CellTags->"S6.7.1"],
Cell[39600, 1275, 1157, 36, 152, "Text",
  CellTags->{"S6.7.1", "1.15"}],
Cell[40760, 1313, 496, 13, 72, "Text",
  CellTags->{"S6.7.1", "1.16"}],
Cell[41259, 1328, 643, 18, 72, "MathCaption",
  CellTags->{"S6.7.1", "1.17"}],

Cell[CellGroupData[{
Cell[41927, 1350, 176, 6, 62, "Input",
  CellTags->"S6.7.1"],
Cell[42106, 1358, 3506, 88, 391, "Output",
  CellTags->"S6.7.1"]
}, Open  ]],
Cell[45627, 1449, 9355, 281, 70, "DefinitionBox",
  CellTags->"S6.7.1"],
Cell[54985, 1732, 221, 7, 70, "Caption",
  CellTags->"S6.7.1"],
Cell[55209, 1741, 1286, 31, 70, "Text",
  CellTags->{"S6.7.1", "1.18"}],
Cell[56498, 1774, 682, 21, 70, "DefinitionBox",
  CellTags->"S6.7.1"],
Cell[57183, 1797, 112, 3, 70, "Caption",
  CellTags->"S6.7.1"],
Cell[57298, 1802, 329, 8, 70, "Text",
  CellTags->{"S6.7.1", "1.19"}],
Cell[57630, 1812, 2434, 77, 70, "DefinitionBox",
  CellTags->"S6.7.1"],
Cell[60067, 1891, 75, 1, 70, "Caption",
  CellTags->"S6.7.1"],
Cell[60145, 1894, 573, 13, 70, "Text",
  CellTags->{"S6.7.1", "1.20"}],
Cell[60721, 1909, 1614, 48, 70, "DefinitionBox",
  CellTags->"S6.7.1"],
Cell[62338, 1959, 145, 4, 70, "Caption",
  CellTags->"S6.7.1"],
Cell[62486, 1965, 3905, 137, 70, "Text",
  CellTags->{"S6.7.1", "1.21"}],
Cell[66394, 2104, 1137, 27, 70, "Text",
  CellTags->{"S6.7.1", "1.22"}],
Cell[67534, 2133, 661, 11, 70, "Text",
  CellTags->{"S6.7.1", "1.23"}],
Cell[68198, 2146, 205, 5, 70, "Text",
  CellTags->{"S6.7.1", "1.24"}],
Cell[68406, 2153, 800, 30, 70, "MathCaption",
  CellTags->{"S6.7.1", "1.25"}],

Cell[CellGroupData[{
Cell[69231, 2187, 235, 8, 70, "Input",
  CellTags->"S6.7.1"],
Cell[69469, 2197, 1508, 41, 70, "Output",
  CellTags->"S6.7.1"]
}, Open  ]],
Cell[70992, 2241, 1533, 39, 70, "Text",
  CellTags->{"S6.7.1", "1.26"}],
Cell[72528, 2282, 843, 15, 70, "Text",
  CellTags->{"S6.7.1", "1.27"}],

Cell[CellGroupData[{
Cell[73396, 2301, 66, 1, 70, "Subsubsection",
  CellTags->{"S6.7.1", "1.28"}],
Cell[73465, 2304, 576, 12, 70, "Text",
  CellTags->{"S6.7.1", "1.29"}]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

