(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     37042,       1378]*)
(*NotebookOutlinePosition[     42267,       1537]*)
(*  CellTagsIndexPosition[     41828,       1516]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Statistics",
 StyleBox["`", "MB"],
 "NormalDistribution",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S6.8.1", "1.1"}],

Cell[TextData[{
 "The most commonly used probability distributions for univariate data \
analysis are those derived from the normal (Gaussian) distribution. This \
package contains normal, Student ",
 Cell[BoxData[
  FormBox[
   StyleBox["t",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", chi\[Hyphen]square, and ",
 Cell[BoxData[
  FormBox[
   StyleBox["F",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "\[Hyphen]ratio distributions, which are also included in the package ",
 StyleBox["Statistics`ContinuousDistributions`", "MR"],
 ". If these distributions are all you need, you can save time by loading the \
",
 StyleBox["Statistics`NormalDistribution`", "MR"],
 " package instead of the larger ",
 StyleBox["Statistics`ContinuousDistributions`", "MR"],
 ". "
}], "Text",
 CellTags->{"S6.8.1", "1.2"}],

Cell[TextData[{
 "The distributions are represented in the symbolic form ",
 StyleBox["name", "TI"],
 StyleBox["[", "MR"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["param",
     "TI"], "1"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox[", ", "MR"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["param",
     "TI"], "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox[", \[Ellipsis] ]", "MR"],
 ". Functions such as ",
 StyleBox["Mean", "MR"],
 ", which give properties of statistical distributions, take the symbolic \
representation of the distribution as an argument. "
}], "Text",
 CellTags->{"S6.8.1", "1.3"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["NormalDistribution[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["mu", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["sigma", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["normal (Gaussian) distribution with mean ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["\[Mu]", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and standard deviation ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["\[Sigma]", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["StudentTDistribution[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["r", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Student ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["t",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" distribution with ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["r",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" degrees of freedom ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ChiSquareDistribution[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["r", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["chi\[Hyphen]square distribution with ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["r",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" degrees of freedom ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["FRatioDistribution[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["r",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["r",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["F",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["\[Hyphen]ratio distribution with ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["r",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" numerator and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["r",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" denominator degrees of freedom ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S6.8.1"],

Cell["\<\
Standard probability distributions derived from the Gaussian distribution.\
\>", "Caption",
 CellTags->"S6.8.1"],

Cell[TextData[{
 "If each ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["X",
     "TI"], 
    StyleBox["i",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is a normal random variable with unit variance and mean zero, then ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{
      StyleBox["i",
       "TI"], "=", "1"}], 
     StyleBox["r",
      "TI"],
     LimitsPositioning->True], 
    SuperscriptBox[
     SubscriptBox[
      StyleBox["X",
       "TI"], 
      StyleBox["i",
       "TI"]], "2"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " has a ",
 StyleBox["chi\[Hyphen]square distribution", "TB"],
 " with ",
 Cell[BoxData[
  FormBox[
   StyleBox["r",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " degrees of freedom. If a normal variable is standardized by subtracting \
its mean and dividing by its standard deviation, then the sum of squares of \
such quantities follows this distribution. The chi\[Hyphen]square \
distribution is most typically used when describing the variance of normal \
samples. "
}], "Text",
 CellTags->{"S6.8.1", "1.4"}],

Cell[TextData[{
 "A variable that has a ",
 StyleBox["Student ", "TB"],
 StyleBox["t", "SBO"],
 StyleBox[" distribution", "TB"],
 " can also be written as a function of normal random variables. Let ",
 Cell[BoxData[
  FormBox[
   StyleBox["X",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " be a normal variable with unit variance and zero mean and ",
 Cell[BoxData[
  FormBox[
   StyleBox["Z",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " be a chi\[Hyphen]square variable with ",
 Cell[BoxData[
  FormBox[
   StyleBox["r",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " degrees of freedom. In this case, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["X",
     "TI"], "/", 
    SqrtBox[
     RowBox[{
      StyleBox["Z",
       "TI"], "/", 
      StyleBox["r",
       "TI"]}]]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " has a ",
 Cell[BoxData[
  FormBox[
   StyleBox["t",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " distribution with ",
 Cell[BoxData[
  FormBox[
   StyleBox["r",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " degrees of freedom. The Student ",
 Cell[BoxData[
  FormBox[
   StyleBox["t",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " distribution is symmetric about the vertical axis, and characterizes the \
ratio of a normal variable to its standard deviation. When ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["r",
     "TI"], "=", "1"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", the ",
 Cell[BoxData[
  FormBox[
   StyleBox["t",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " distribution is the same as the Cauchy distribution. "
}], "Text",
 CellTags->{"S6.8.1", "1.5"}],

Cell[TextData[{
 "The ",
 StyleBox["F\[Hyphen]ratio distribution", "TB"],
 " is the distribution of the ratio of two chi\[Hyphen]square variables \
divided by their respective degrees of freedom. It is commonly used when \
comparing the variances of two populations in hypothesis testing. "
}], "Text",
 CellTags->{"S6.8.1", "1.6"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["PDF[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["probability density function at ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["x",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["CDF[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["cumulative distribution function at ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["x",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Quantile[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["q", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["q",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SuperscriptBox["\[Null]", "th"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" quantile ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Domain[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "range of values of the variable (support) ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Mean[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["mean ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Variance[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["variance ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["StandardDeviation[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["standard deviation ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Skewness[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["coefficient of skewness ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Kurtosis[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["coefficient of kurtosis ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["KurtosisExcess[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["kurtosis excess ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["CharacteristicFunction[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["t", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["characteristic function ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"\[Phi]", 
         RowBox[{"(", 
          StyleBox["t",
           "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ExpectedValue[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["expected value of pure function ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["f",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" with respect to the specified distribution ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ExpectedValue[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["expected value of function ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["f",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["x",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" with respect to the specified distribution ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Random[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "pseudorandom number with specified distribution ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["RandomArray[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dims", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["pseudorandom array with dimensionality ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dims", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", and elements from the specified distribution ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S6.8.1"],

Cell["Functions of statistical distributions. ", "Caption",
 CellTags->"S6.8.1"],

Cell[TextData[{
 "In this package distributions are represented in symbolic form. ",
 StyleBox["PDF[", "MR"],
 StyleBox["dist", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["x", "TI"],
 StyleBox["]", "MR"],
 " evaluates the distribution at ",
 Cell[BoxData[
  FormBox[
   StyleBox["x",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " if ",
 Cell[BoxData[
  FormBox[
   StyleBox["x",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is a numerical value, and otherwise leaves the function in symbolic form. \
Similarly, ",
 StyleBox["CDF[", "MR"],
 StyleBox["dist", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["x", "TI"],
 StyleBox["]", "MR"],
 " gives the cumulative distribution and ",
 StyleBox["Mean[", "MR"],
 StyleBox["dist", "TI"],
 StyleBox["]", "MR"],
 " gives the mean of the specified distribution. For a more complete \
description of the various functions of statistical distributions, see the \
section that describes the package ",
 StyleBox["Statistics`ContinuousDistributions`", "MR"],
 ". "
}], "Text",
 CellTags->{"S6.8.1", "1.7"}],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S6.8.1", "1.8"}],

Cell["<<Statistics`NormalDistribution`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S6.8.1"],

Cell["\<\
Here is a symbolic representation of the normal distribution with zero mean \
and unit variance. \
\>", "MathCaption",
 CellTags->{"S6.8.1", "1.9"}],

Cell[CellGroupData[{

Cell["ndist = NormalDistribution[0, 1]", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S6.8.1"],

Cell[BoxData[
 RowBox[{"NormalDistribution", "[", 
  RowBox[{"0", ",", "1"}], "]"}]], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S6.8.1"]
}, Open  ]],

Cell["This gives its probability density function. ", "MathCaption",
 CellTags->{"S6.8.1", "1.10"}],

Cell[CellGroupData[{

Cell["pdf = PDF[ndist, x]", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S6.8.1"],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", 
    FractionBox[
     SuperscriptBox["x", "2"], "2"]}]], 
  SqrtBox[
   RowBox[{"2", " ", "\[Pi]"}]]]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S6.8.1"]
}, Open  ]],

Cell["\<\
You can make a plot of the density to observe its distribution. \
\>", "MathCaption",
 CellTags->{"S6.8.1", "1.11"}],

Cell[CellGroupData[{

Cell["Plot[pdf,{x, -3, 3}]", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S6.8.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0147151 1.47542 [
[.02381 .00222 -6 -9 ]
[.02381 .00222 6 0 ]
[.18254 .00222 -6 -9 ]
[.18254 .00222 6 0 ]
[.34127 .00222 -6 -9 ]
[.34127 .00222 6 0 ]
[.65873 .00222 -3 -9 ]
[.65873 .00222 3 0 ]
[.81746 .00222 -3 -9 ]
[.81746 .00222 3 0 ]
[.97619 .00222 -3 -9 ]
[.97619 .00222 3 0 ]
[.4875 .16226 -18 -4.5 ]
[.4875 .16226 0 4.5 ]
[.4875 .3098 -18 -4.5 ]
[.4875 .3098 0 4.5 ]
[.4875 .45734 -18 -4.5 ]
[.4875 .45734 0 4.5 ]
[.4875 .60488 -18 -4.5 ]
[.4875 .60488 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .01472 m
.02381 .02097 L
s
[(-3)] .02381 .00222 0 1 Mshowa
.18254 .01472 m
.18254 .02097 L
s
[(-2)] .18254 .00222 0 1 Mshowa
.34127 .01472 m
.34127 .02097 L
s
[(-1)] .34127 .00222 0 1 Mshowa
.65873 .01472 m
.65873 .02097 L
s
[(1)] .65873 .00222 0 1 Mshowa
.81746 .01472 m
.81746 .02097 L
s
[(2)] .81746 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(3)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.05556 .01472 m
.05556 .01847 L
s
.0873 .01472 m
.0873 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.15079 .01472 m
.15079 .01847 L
s
.21429 .01472 m
.21429 .01847 L
s
.24603 .01472 m
.24603 .01847 L
s
.27778 .01472 m
.27778 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.37302 .01472 m
.37302 .01847 L
s
.40476 .01472 m
.40476 .01847 L
s
.43651 .01472 m
.43651 .01847 L
s
.46825 .01472 m
.46825 .01847 L
s
.53175 .01472 m
.53175 .01847 L
s
.56349 .01472 m
.56349 .01847 L
s
.59524 .01472 m
.59524 .01847 L
s
.62698 .01472 m
.62698 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.72222 .01472 m
.72222 .01847 L
s
.75397 .01472 m
.75397 .01847 L
s
.78571 .01472 m
.78571 .01847 L
s
.84921 .01472 m
.84921 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.9127 .01472 m
.9127 .01847 L
s
.94444 .01472 m
.94444 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.5 .16226 m
.50625 .16226 L
s
[(0.1)] .4875 .16226 1 0 Mshowa
.5 .3098 m
.50625 .3098 L
s
[(0.2)] .4875 .3098 1 0 Mshowa
.5 .45734 m
.50625 .45734 L
s
[(0.3)] .4875 .45734 1 0 Mshowa
.5 .60488 m
.50625 .60488 L
s
[(0.4)] .4875 .60488 1 0 Mshowa
.125 Mabswid
.5 .04422 m
.50375 .04422 L
s
.5 .07373 m
.50375 .07373 L
s
.5 .10324 m
.50375 .10324 L
s
.5 .13275 m
.50375 .13275 L
s
.5 .19177 m
.50375 .19177 L
s
.5 .22127 m
.50375 .22127 L
s
.5 .25078 m
.50375 .25078 L
s
.5 .28029 m
.50375 .28029 L
s
.5 .33931 m
.50375 .33931 L
s
.5 .36882 m
.50375 .36882 L
s
.5 .39832 m
.50375 .39832 L
s
.5 .42783 m
.50375 .42783 L
s
.5 .48685 m
.50375 .48685 L
s
.5 .51636 m
.50375 .51636 L
s
.5 .54587 m
.50375 .54587 L
s
.5 .57537 m
.50375 .57537 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .02125 m
.04262 .02398 L
.06244 .02789 L
.08255 .03325 L
.10458 .04115 L
.12415 .05039 L
.14509 .06304 L
.16496 .07816 L
.18653 .09846 L
.22646 .14806 L
.26733 .21574 L
.30668 .29508 L
.34452 .37902 L
.3848 .46705 L
.42358 .5389 L
.44471 .56867 L
.45443 .57956 L
.4648 .58903 L
.47015 .593 L
.47519 .59617 L
.48009 .59871 L
.48461 .60056 L
.4889 .60188 L
.49106 .60239 L
.49344 .60282 L
.49469 .60299 L
.49582 .60312 L
.49714 .60323 L
.49838 .60329 L
.49953 .60332 L
.50059 .60332 L
.50175 .60329 L
.50299 .60322 L
.50413 .60312 L
.50537 .60298 L
.50788 .6026 L
.5102 .60211 L
.51236 .60154 L
.51725 .59986 L
.52246 .59746 L
.53204 .59145 L
.54074 .58425 L
.55993 .56283 L
.58073 .53192 L
.62164 .45354 L
.66105 .36651 L
.69893 .28309 L
.73927 .20368 L
.7781 .14156 L
.79785 .11593 L
Mistroke
.81938 .09247 L
.85914 .06024 L
.87885 .04882 L
.89983 .03938 L
.92129 .0321 L
.94147 .02702 L
.95956 .02362 L
.97619 .02125 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S6.8.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S6.8.1"]
}, Open  ]],

Cell[TextData[{
 "Here is the probability of the lower tail of the distribution, to the left \
of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "2"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S6.8.1", "1.12"}],

Cell[CellGroupData[{

Cell["CDF[ndist, -2]", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S6.8.1"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{"1", "-", 
    RowBox[{"Erf", "[", 
     SqrtBox["2"], "]"}]}], ")"}]}]], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S6.8.1"]
}, Open  ]],

Cell["This is the domain. ", "MathCaption",
 CellTags->{"S6.8.1", "1.13"}],

Cell[CellGroupData[{

Cell["Domain[ndist]", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S6.8.1"],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}], 
  "]"}]], "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S6.8.1"]
}, Open  ]],

Cell["\<\
This gives the expected value of a pure function with respect to the chi\
\[Hyphen]square distribution with 5 degrees of freedom. \
\>", "MathCaption",
 CellTags->{"S6.8.1", "1.14"}],

Cell[CellGroupData[{

Cell["ExpectedValue[#^2&, ChiSquareDistribution[5]]", "Input",
 CellLabel->"In[7]:= ",
 CellTags->"S6.8.1"],

Cell[BoxData["35"], "Output",
 CellLabel->"Out[7]= ",
 CellTags->"S6.8.1"]
}, Open  ]],

Cell[TextData[{
 "Here the function is expressed in terms of ",
 Cell[BoxData[
  FormBox[
   StyleBox["x",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S6.8.1", "1.15"}],

Cell[CellGroupData[{

Cell["ExpectedValue[x^2, ChiSquareDistribution[5], x]", "Input",
 CellLabel->"In[8]:= ",
 CellTags->"S6.8.1"],

Cell[BoxData["35"], "Output",
 CellLabel->"Out[8]= ",
 CellTags->"S6.8.1"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S6.8.1"->{
    Cell[1776, 53, 144, 6, 36, "Subsection",
      CellTags->{"S6.8.1", "1.1"}],
    Cell[1923, 61, 906, 24, 104, "Text",
      CellTags->{"S6.8.1", "1.2"}],
    Cell[2832, 87, 732, 23, 57, "Text",
      CellTags->{"S6.8.1", "1.3"}],
    Cell[3567, 112, 6333, 191, 144, "DefinitionBox",
      CellTags->"S6.8.1"],
    Cell[9903, 305, 122, 3, 15, "Caption",
      CellTags->"S6.8.1"],
    Cell[10028, 310, 1248, 42, 88, "Text",
      CellTags->{"S6.8.1", "1.4"}],
    Cell[11279, 354, 2049, 70, 105, "Text",
      CellTags->{"S6.8.1", "1.5"}],
    Cell[13331, 426, 332, 7, 50, "Text",
      CellTags->{"S6.8.1", "1.6"}],
    Cell[13666, 435, 14617, 451, 412, "DefinitionBox",
      CellTags->"S6.8.1"],
    Cell[28286, 888, 80, 1, 70, "Caption",
      CellTags->"S6.8.1"],
    Cell[28369, 891, 1135, 36, 70, "Text",
      CellTags->{"S6.8.1", "1.7"}],
    Cell[29507, 929, 77, 1, 70, "MathCaption",
      CellTags->{"S6.8.1", "1.8"}],
    Cell[29587, 932, 94, 2, 70, "Input",
      CellTags->"S6.8.1"],
    Cell[29684, 936, 158, 4, 70, "MathCaption",
      CellTags->{"S6.8.1", "1.9"}],
    Cell[29867, 944, 94, 2, 70, "Input",
      CellTags->"S6.8.1"],
    Cell[29964, 948, 140, 4, 70, "Output",
      CellTags->"S6.8.1"],
    Cell[30119, 955, 99, 1, 70, "MathCaption",
      CellTags->{"S6.8.1", "1.10"}],
    Cell[30243, 960, 81, 2, 70, "Input",
      CellTags->"S6.8.1"],
    Cell[30327, 964, 240, 9, 70, "Output",
      CellTags->"S6.8.1"],
    Cell[30582, 976, 126, 3, 70, "MathCaption",
      CellTags->{"S6.8.1", "1.11"}],
    Cell[30733, 983, 82, 2, 70, "Input",
      CellTags->"S6.8.1"],
    Cell[30818, 987, 4112, 293, 70, 4042, 290, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S6.8.1"],
    Cell[34933, 1282, 179, 6, 70, "Output",
      CellTags->"S6.8.1"],
    Cell[35127, 1291, 287, 9, 70, "MathCaption",
      CellTags->{"S6.8.1", "1.12"}],
    Cell[35439, 1304, 76, 2, 70, "Input",
      CellTags->"S6.8.1"],
    Cell[35518, 1308, 210, 8, 70, "Output",
      CellTags->"S6.8.1"],
    Cell[35743, 1319, 74, 1, 70, "MathCaption",
      CellTags->{"S6.8.1", "1.13"}],
    Cell[35842, 1324, 75, 2, 70, "Input",
      CellTags->"S6.8.1"],
    Cell[35920, 1328, 197, 7, 70, "Output",
      CellTags->"S6.8.1"],
    Cell[36132, 1338, 192, 4, 70, "MathCaption",
      CellTags->{"S6.8.1", "1.14"}],
    Cell[36349, 1346, 107, 2, 70, "Input",
      CellTags->"S6.8.1"],
    Cell[36459, 1350, 74, 2, 70, "Output",
      CellTags->"S6.8.1"],
    Cell[36548, 1355, 255, 9, 70, "MathCaption",
      CellTags->{"S6.8.1", "1.15"}],
    Cell[36828, 1368, 109, 2, 70, "Input",
      CellTags->"S6.8.1"],
    Cell[36940, 1372, 74, 2, 70, "Output",
      CellTags->"S6.8.1"]},
  "1.1"->{
    Cell[1776, 53, 144, 6, 36, "Subsection",
      CellTags->{"S6.8.1", "1.1"}]},
  "1.2"->{
    Cell[1923, 61, 906, 24, 104, "Text",
      CellTags->{"S6.8.1", "1.2"}]},
  "1.3"->{
    Cell[2832, 87, 732, 23, 57, "Text",
      CellTags->{"S6.8.1", "1.3"}]},
  "1.4"->{
    Cell[10028, 310, 1248, 42, 88, "Text",
      CellTags->{"S6.8.1", "1.4"}]},
  "1.5"->{
    Cell[11279, 354, 2049, 70, 105, "Text",
      CellTags->{"S6.8.1", "1.5"}]},
  "1.6"->{
    Cell[13331, 426, 332, 7, 50, "Text",
      CellTags->{"S6.8.1", "1.6"}]},
  "1.7"->{
    Cell[28369, 891, 1135, 36, 70, "Text",
      CellTags->{"S6.8.1", "1.7"}]},
  "1.8"->{
    Cell[29507, 929, 77, 1, 70, "MathCaption",
      CellTags->{"S6.8.1", "1.8"}]},
  "1.9"->{
    Cell[29684, 936, 158, 4, 70, "MathCaption",
      CellTags->{"S6.8.1", "1.9"}]},
  "1.10"->{
    Cell[30119, 955, 99, 1, 70, "MathCaption",
      CellTags->{"S6.8.1", "1.10"}]},
  "1.11"->{
    Cell[30582, 976, 126, 3, 70, "MathCaption",
      CellTags->{"S6.8.1", "1.11"}]},
  "1.12"->{
    Cell[35127, 1291, 287, 9, 70, "MathCaption",
      CellTags->{"S6.8.1", "1.12"}]},
  "1.13"->{
    Cell[35743, 1319, 74, 1, 70, "MathCaption",
      CellTags->{"S6.8.1", "1.13"}]},
  "1.14"->{
    Cell[36132, 1338, 192, 4, 70, "MathCaption",
      CellTags->{"S6.8.1", "1.14"}]},
  "1.15"->{
    Cell[36548, 1355, 255, 9, 70, "MathCaption",
      CellTags->{"S6.8.1", "1.15"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S6.8.1", 37664, 1394},
  {"1.1", 40400, 1467},
  {"1.2", 40493, 1470},
  {"1.3", 40582, 1473},
  {"1.4", 40670, 1476},
  {"1.5", 40761, 1479},
  {"1.6", 40853, 1482},
  {"1.7", 40942, 1485},
  {"1.8", 41033, 1488},
  {"1.9", 41128, 1491},
  {"1.10", 41225, 1494},
  {"1.11", 41322, 1497},
  {"1.12", 41420, 1500},
  {"1.13", 41519, 1503},
  {"1.14", 41617, 1506},
  {"1.15", 41716, 1509}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 144, 6, 36, "Subsection",
  CellTags->{"S6.8.1", "1.1"}],
Cell[1923, 61, 906, 24, 104, "Text",
  CellTags->{"S6.8.1", "1.2"}],
Cell[2832, 87, 732, 23, 57, "Text",
  CellTags->{"S6.8.1", "1.3"}],
Cell[3567, 112, 6333, 191, 144, "DefinitionBox",
  CellTags->"S6.8.1"],
Cell[9903, 305, 122, 3, 15, "Caption",
  CellTags->"S6.8.1"],
Cell[10028, 310, 1248, 42, 88, "Text",
  CellTags->{"S6.8.1", "1.4"}],
Cell[11279, 354, 2049, 70, 105, "Text",
  CellTags->{"S6.8.1", "1.5"}],
Cell[13331, 426, 332, 7, 50, "Text",
  CellTags->{"S6.8.1", "1.6"}],
Cell[13666, 435, 14617, 451, 412, "DefinitionBox",
  CellTags->"S6.8.1"],
Cell[28286, 888, 80, 1, 70, "Caption",
  CellTags->"S6.8.1"],
Cell[28369, 891, 1135, 36, 70, "Text",
  CellTags->{"S6.8.1", "1.7"}],
Cell[29507, 929, 77, 1, 70, "MathCaption",
  CellTags->{"S6.8.1", "1.8"}],
Cell[29587, 932, 94, 2, 70, "Input",
  CellTags->"S6.8.1"],
Cell[29684, 936, 158, 4, 70, "MathCaption",
  CellTags->{"S6.8.1", "1.9"}],

Cell[CellGroupData[{
Cell[29867, 944, 94, 2, 70, "Input",
  CellTags->"S6.8.1"],
Cell[29964, 948, 140, 4, 70, "Output",
  CellTags->"S6.8.1"]
}, Open  ]],
Cell[30119, 955, 99, 1, 70, "MathCaption",
  CellTags->{"S6.8.1", "1.10"}],

Cell[CellGroupData[{
Cell[30243, 960, 81, 2, 70, "Input",
  CellTags->"S6.8.1"],
Cell[30327, 964, 240, 9, 70, "Output",
  CellTags->"S6.8.1"]
}, Open  ]],
Cell[30582, 976, 126, 3, 70, "MathCaption",
  CellTags->{"S6.8.1", "1.11"}],

Cell[CellGroupData[{
Cell[30733, 983, 82, 2, 70, "Input",
  CellTags->"S6.8.1"],
Cell[30818, 987, 4112, 293, 70, 4042, 290, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S6.8.1"],
Cell[34933, 1282, 179, 6, 70, "Output",
  CellTags->"S6.8.1"]
}, Open  ]],
Cell[35127, 1291, 287, 9, 70, "MathCaption",
  CellTags->{"S6.8.1", "1.12"}],

Cell[CellGroupData[{
Cell[35439, 1304, 76, 2, 70, "Input",
  CellTags->"S6.8.1"],
Cell[35518, 1308, 210, 8, 70, "Output",
  CellTags->"S6.8.1"]
}, Open  ]],
Cell[35743, 1319, 74, 1, 70, "MathCaption",
  CellTags->{"S6.8.1", "1.13"}],

Cell[CellGroupData[{
Cell[35842, 1324, 75, 2, 70, "Input",
  CellTags->"S6.8.1"],
Cell[35920, 1328, 197, 7, 70, "Output",
  CellTags->"S6.8.1"]
}, Open  ]],
Cell[36132, 1338, 192, 4, 70, "MathCaption",
  CellTags->{"S6.8.1", "1.14"}],

Cell[CellGroupData[{
Cell[36349, 1346, 107, 2, 70, "Input",
  CellTags->"S6.8.1"],
Cell[36459, 1350, 74, 2, 70, "Output",
  CellTags->"S6.8.1"]
}, Open  ]],
Cell[36548, 1355, 255, 9, 70, "MathCaption",
  CellTags->{"S6.8.1", "1.15"}],

Cell[CellGroupData[{
Cell[36828, 1368, 109, 2, 70, "Input",
  CellTags->"S6.8.1"],
Cell[36940, 1372, 74, 2, 70, "Output",
  CellTags->"S6.8.1"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

