(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    108688,       3990]*)
(*NotebookOutlinePosition[    138082,       4833]*)
(*  CellTagsIndexPosition[    135702,       4738]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "NumberTheory",
 StyleBox["`", "MB"],
 "NumberTheoryFunctions",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.69.1", "1.1"}],

Cell[TextData[{
 "This package contains a variety of functions that are useful for number \
theory applications. For more information on the mathematics related to these \
functions, see references such as \
G.\[NonBreakingSpace]H.\[NonBreakingSpace]Hardy and E.\[NonBreakingSpace]M.\
\[NonBreakingSpace]Wright, ",
 StyleBox["An Introduction to the Theory of Numbers", "TI"],
 ", Oxford University Press, 1988, \
D.\[NonBreakingSpace]E.\[NonBreakingSpace]Knuth, ",
 StyleBox["Seminumerical Algorithms", "TI"],
 ", Addison\[Hyphen]Wesley, 1981, E.\[NonBreakingSpace]Grosswald, ",
 StyleBox["Representations of Integers as Sums of Squares", "TI"],
 ", Springer, 1985, and H.\[NonBreakingSpace]Cohen, ",
 StyleBox["A Course in Computational Algebraic Number Theory", "TI"],
 ", Springer\[Hyphen]Verlag, 1993. "
}], "Text",
 CellTags->{"S5.69.1", "1.2"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["SquareFreeQ[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["True", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" if ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" does not contain a squared factor, ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["False", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" otherwise",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.69.1"],

Cell["Testing for a squared factor. ", "Caption",
 CellTags->"S5.69.1"],

Cell[TextData[{
 StyleBox["SquareFreeQ[", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 StyleBox["n", "TI"],
 StyleBox["]", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 " checks to see if ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " has a square prime factor. This is done by computing ",
 StyleBox["MoebiusMu[", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 StyleBox["n", "TI"],
 StyleBox["]", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 " and seeing if the result is zero; if it is, then ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is not squarefree, otherwise it is. Computing ",
 StyleBox["MoebiusMu[", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 StyleBox["n", "TI"],
 StyleBox["]", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 " involves finding the smallest prime factor ",
 Cell[BoxData[
  FormBox[
   StyleBox["q",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " of ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". If ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " has a small prime factor (less than or equal to ",
 Cell[BoxData[
  FormBox["1223", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "), this is very fast. Otherwise, ",
 StyleBox["FactorInteger", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 " is used to find ",
 Cell[BoxData[
  FormBox[
   StyleBox["q",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "Text",
 CellTags->{"S5.69.1", "1.3"}],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.69.1", "1.4"}],

Cell["<<NumberTheory`NumberTheoryFunctions`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.69.1"],

Cell["This product of primes contains no squared factors. ", "MathCaption",
 CellTags->{"S5.69.1", "1.5"}],

Cell[CellGroupData[{

Cell["SquareFreeQ[2*3*5*7]", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.69.1"],

Cell[BoxData["True"], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.69.1"]
}, Open  ]],

Cell[TextData[{
 "The square number ",
 Cell[BoxData[
  FormBox["4", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " divides ",
 Cell[BoxData[
  FormBox["60", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.69.1", "1.6"}],

Cell[CellGroupData[{

Cell["SquareFreeQ[60]", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.69.1"],

Cell[BoxData["False"], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.69.1"]
}, Open  ]],

Cell[TextData[{
 StyleBox["SquareFreeQ", "MR"],
 " can handle large integers. "
}], "MathCaption",
 CellTags->{"S5.69.1", "1.7"}],

Cell[CellGroupData[{

Cell["SquareFreeQ[2^101 - 1]", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.69.1"],

Cell[BoxData["True"], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.69.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["NextPrime[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the smallest prime larger than ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["PreviousPrime[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the largest prime smaller than ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Random[Prime, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["min", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["max", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["return a random prime number between ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["min", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["max", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.69.1"],

Cell["Finding prime numbers. ", "Caption",
 CellTags->"S5.69.1"],

Cell[TextData[{
 StyleBox["NextPrime[", "MR"],
 StyleBox["n", "TI"],
 StyleBox["]", "MR"],
 " finds the smallest prime ",
 Cell[BoxData[
  FormBox[
   StyleBox["p",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " such that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["p",
     "TI"], ">", 
    StyleBox["n",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", while ",
 StyleBox["PreviousPrime[", "MR"],
 StyleBox["n", "TI"],
 StyleBox["]", "MR"],
 " finds the largest prime ",
 Cell[BoxData[
  FormBox[
   StyleBox["p",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " such that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["p",
     "TI"], "<", 
    StyleBox["n",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". For ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " less than 20 digits, the algorithm does a direct search using ",
 StyleBox["PrimeQ", "MR"],
 " on the odd numbers greater than ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". For ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " with more than 20 digits, the algorithm builds a small sieve and first \
checks to see whether the candidate prime is divisible by a small prime \
before using ",
 StyleBox["PrimeQ", "MR"],
 ". This seems to be slightly faster than a direct search. "
}], "Text",
 CellTags->{"S5.69.1", "1.8"}],

Cell[TextData[{
 "This gives the next prime after ",
 Cell[BoxData[
  FormBox["10", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.69.1", "1.9"}],

Cell[CellGroupData[{

Cell["NextPrime[10]", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.69.1"],

Cell[BoxData["11"], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S5.69.1"]
}, Open  ]],

Cell["\<\
Even for large numbers, the next prime can be computed rather quickly. \
\>", "MathCaption",
 CellTags->{"S5.69.1", "1.10"}],

Cell[CellGroupData[{

Cell["NextPrime[10^100]//Timing", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.69.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.11`", " ", "Second"}], ",", 
   "10000000000000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000267"}], "}"}]], "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S5.69.1"]
}, Open  ]],

Cell[TextData[{
 "This gives the largest prime less than ",
 Cell[BoxData[
  FormBox["34", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.69.1", "1.11"}],

Cell[CellGroupData[{

Cell["PreviousPrime[34]", "Input",
 CellLabel->"In[7]:= ",
 CellTags->"S5.69.1"],

Cell[BoxData["31"], "Output",
 CellLabel->"Out[7]= ",
 CellTags->"S5.69.1"]
}, Open  ]],

Cell[TextData[{
 "For ",
 StyleBox["Random[Prime, ", "MR"],
 StyleBox["range", "TI"],
 StyleBox["]", "MR"],
 ", a random prime ",
 Cell[BoxData[
  FormBox[
   StyleBox["p",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is computed by first finding a random integer ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " in that range and then computing the smallest prime ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["p",
     "TI"], "\[GreaterEqual]", 
    StyleBox["n",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", assuming ",
 Cell[BoxData[
  FormBox[
   StyleBox["p",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is in that range, otherwise the process is repeated until a prime is found \
in the range. If no prime exists in the specified range, the input is \
returned unevaluated with an error message. "
}], "Text",
 CellTags->{"S5.69.1", "1.12"}],

Cell[TextData[{
 "Here\[CloseCurlyQuote]s a random prime between ",
 Cell[BoxData[
  FormBox["10", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox["100", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.69.1", "1.13"}],

Cell[CellGroupData[{

Cell["Random[Prime, {10, 100}]", "Input",
 CellLabel->"In[8]:= ",
 CellTags->"S5.69.1"],

Cell[BoxData["47"], "Output",
 CellLabel->"Out[8]= ",
 CellTags->"S5.69.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["PrimeFactorList[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["r", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["return the list of prime factors of rational ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["r",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["LeastPrimeFactor[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["return the least prime factor of the integer ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["n",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["PrimePowerQ[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["determine whether ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["n",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is a positive integer power of a rational prime",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.69.1"],

Cell["Operations involving prime factors. ", "Caption",
 CellTags->"S5.69.1"],

Cell[TextData[{
 "Here is the list of prime factors of ",
 Cell[BoxData[
  FormBox["713", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.69.1", "1.14"}],

Cell[CellGroupData[{

Cell["PrimeFactorList[713]", "Input",
 CellLabel->"In[9]:= ",
 CellTags->"S5.69.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"23", ",", "31"}], "}"}]], "Output",
 CellLabel->"Out[9]= ",
 CellTags->"S5.69.1"]
}, Open  ]],

Cell["We can find the least prime factor directly. ", "MathCaption",
 CellTags->{"S5.69.1", "1.15"}],

Cell[CellGroupData[{

Cell["LeastPrimeFactor[713]", "Input",
 CellLabel->"In[10]:= ",
 CellTags->"S5.69.1"],

Cell[BoxData["23"], "Output",
 CellLabel->"Out[10]= ",
 CellTags->"S5.69.1"]
}, Open  ]],

Cell[TextData[{
 StyleBox["PrimeFactorList", "MR"],
 " operates on rational numbers. "
}], "MathCaption",
 CellTags->{"S5.69.1", "1.16"}],

Cell[CellGroupData[{

Cell["PrimeFactorList[78/41]", "Input",
 CellLabel->"In[11]:= ",
 CellTags->"S5.69.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "3", ",", "13", ",", "41"}], "}"}]], "Output",
 CellLabel->"Out[11]= ",
 CellTags->"S5.69.1"]
}, Open  ]],

Cell[TextData[{
 "The algorithm for ",
 StyleBox["PrimePowerQ", "MR"],
 " involves first computing the least prime factor ",
 Cell[BoxData[
  FormBox[
   StyleBox["p",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " of ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and then attempting division by ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " until either ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is obtained, in which case ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is a prime power, or until division is no longer possible, in which case \
",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is not a prime power. "
}], "Text",
 CellTags->{"S5.69.1", "1.17"}],

Cell["Here is a number that is a power of a single prime. ", "MathCaption",
 CellTags->{"S5.69.1", "1.18"}],

Cell[CellGroupData[{

Cell["PrimePowerQ[12167]", "Input",
 CellLabel->"In[12]:= ",
 CellTags->"S5.69.1"],

Cell[BoxData["True"], "Output",
 CellLabel->"Out[12]= ",
 CellTags->"S5.69.1"]
}, Open  ]],

Cell["\<\
We can verify this by noting that the list of prime factors has a single \
element. \
\>", "MathCaption",
 CellTags->{"S5.69.1", "1.19"}],

Cell[CellGroupData[{

Cell["PrimeFactorList[12167]", "Input",
 CellLabel->"In[13]:= ",
 CellTags->"S5.69.1"],

Cell[BoxData[
 RowBox[{"{", "23", "}"}]], "Output",
 CellLabel->"Out[13]= ",
 CellTags->"S5.69.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["ChineseRemainder[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["list",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["list",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["] ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the smallest non\[Hyphen]negative integer ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["r", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" with ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["Mod[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["r", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["list",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["] == ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["list",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.69.1"],

Cell["Solving simultaneous congruences. ", "Caption",
 CellTags->"S5.69.1"],

Cell[TextData[{
 "The ",
 StyleBox["Chinese Remainder Theorem", "TI"],
 " states that a certain class of simultaneous congruences always has a \
solution. ",
 StyleBox["ChineseRemainder[", "MR"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["list",
     "TI"], "1"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox[", ", "MR"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["list",
     "TI"], "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox["]", "MR"],
 " finds the smallest non\[Hyphen]negative integer ",
 Cell[BoxData[
  FormBox[
   StyleBox["r",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " such that ",
 StyleBox["Mod[", "MR"],
 StyleBox["r", "TI"],
 StyleBox[", ", "MR"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["list",
     "TI"], "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox["]", "MR"],
 " is ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["list",
     "TI"], "1"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". The solution is unique modulo the least common multiple of the elements \
of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["list",
     "TI"], "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". The code for ",
 StyleBox["ChineseRemainder", "MR"],
 " was contributed by Stan Wagon of Macalaster College. "
}], "Text",
 CellTags->{"S5.69.1", "1.20"}],

Cell[TextData[{
 "This means that ",
 Cell[BoxData[
  FormBox[
   RowBox[{"244", "\[Congruent]", 
    RowBox[{
     RowBox[{"0", " "}], "mod", " ", "4"}]}], TraditionalForm]], 
  "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"244", "\[Congruent]", 
    RowBox[{
     RowBox[{"1", " "}], "mod", " ", "9"}]}], TraditionalForm]], 
  "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"244", "\[Congruent]", 
    RowBox[{
     RowBox[{"2", " "}], "mod", " ", "121"}]}], TraditionalForm]], 
  "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.69.1", "1.21"}],

Cell[CellGroupData[{

Cell["ChineseRemainder[{0, 1, 2}, {4, 9, 121}]", "Input",
 CellLabel->"In[14]:= ",
 CellTags->"S5.69.1"],

Cell[BoxData["244"], "Output",
 CellLabel->"Out[14]= ",
 CellTags->"S5.69.1"]
}, Open  ]],

Cell["This confirms the result. ", "MathCaption",
 CellTags->{"S5.69.1", "1.22"}],

Cell[CellGroupData[{

Cell["Mod[244, {4, 9, 121}]", "Input",
 CellLabel->"In[15]:= ",
 CellTags->"S5.69.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "1", ",", "2"}], "}"}]], "Output",
 CellLabel->"Out[15]= ",
 CellTags->"S5.69.1"]
}, Open  ]],

Cell["For longer lists the routine is still quite fast. ", "MathCaption",
 CellTags->{"S5.69.1", "1.23"}],

Cell[CellGroupData[{

Cell["ChineseRemainder[Range[20], Prime[Range[20]]]", "Input",
 CellLabel->"In[16]:= ",
 CellTags->"S5.69.1"],

Cell[BoxData["169991099649125127278835143"], "Output",
 CellLabel->"Out[16]= ",
 CellTags->"S5.69.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["SqrtMod[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["d", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the least nonnegative square root of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["d",
          "TI"], "mod", 
         StyleBox["n",
          "TI"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["SqrtModList[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["d", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the list of all square roots of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["d",
          "TI"], "mod", 
         StyleBox["n",
          "TI"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.69.1"],

Cell[TextData[{
 "Finding square roots modulo ",
 StyleBox["n", "MR"],
 ". "
}], "Caption",
 CellTags->"S5.69.1"],

Cell[TextData[{
 StyleBox["SqrtMod[", "MR"],
 StyleBox["d", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["n", "TI"],
 StyleBox["]", "MR"],
 " computes the square root of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["d",
     "TI"], "mod", 
    StyleBox["n",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". In other words, it returns the least nonnegative integer ",
 Cell[BoxData[
  FormBox[
   StyleBox["m",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", where ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     StyleBox["m",
      "TI"], "2"], "\[Congruent]", 
    StyleBox["d",
     "TI"], "mod", 
    StyleBox["n",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", when ",
 Cell[BoxData[
  FormBox[
   StyleBox["m",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " exists. "
}], "Text",
 CellTags->{"S5.69.1", "1.24"}],

Cell[TextData[{
 "For given ",
 Cell[BoxData[
  FormBox[
   StyleBox["d",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", there may not exist an integer ",
 Cell[BoxData[
  FormBox[
   StyleBox["x",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " with ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     StyleBox["x",
      "TI"], "2"], "\[Congruent]", 
    StyleBox["d",
     "TI"], "mod", 
    StyleBox["n",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". Clearly ",
 Cell[BoxData[
  FormBox[
   StyleBox["d",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " must be a perfect square ",
 Cell[BoxData[
  FormBox[
   RowBox[{"mod", " ", 
    StyleBox["n",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", so to have a solution one must have that ",
 StyleBox["JacobiSymbol[", "MR"],
 StyleBox["d", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["n", "TI"],
 StyleBox["]", "MR"],
 " be equal to 1. This condition is also sufficient if ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is a prime. The algorithm used for the case when ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is prime was discovered by Shanks. "
}], "Text",
 CellTags->{"S5.69.1", "1.25"}],

Cell[TextData[{
 "Note that the square root ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["d",
     "TI"], "mod", 
    StyleBox["n",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " need not be unique. ",
 StyleBox["SqrtMod", "MR"],
 " returns the least nonnegative integer less than ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " whose square is congruent to ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["d",
     "TI"], "mod", 
    StyleBox["n",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". ",
 StyleBox["SqrtModList", "MR"],
 " returns all such integers that satisfy this relationship. "
}], "Text",
 CellTags->{"S5.69.1", "1.26"}],

Cell[TextData[{
 "This finds the smallest nonnegative integer ",
 Cell[BoxData[
  FormBox[
   StyleBox["x",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " so that ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["x",
     "TI"], "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is equal to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"3", "mod", "11"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.69.1", "1.27"}],

Cell[CellGroupData[{

Cell["SqrtMod[3, 11]", "Input",
 CellLabel->"In[17]:= ",
 CellTags->"S5.69.1"],

Cell[BoxData["5"], "Output",
 CellLabel->"Out[17]= ",
 CellTags->"S5.69.1"]
}, Open  ]],

Cell["This verifies the result. ", "MathCaption",
 CellTags->{"S5.69.1", "1.28"}],

Cell[CellGroupData[{

Cell["Mod[5^2, 11]", "Input",
 CellLabel->"In[18]:= ",
 CellTags->"S5.69.1"],

Cell[BoxData["3"], "Output",
 CellLabel->"Out[18]= ",
 CellTags->"S5.69.1"]
}, Open  ]],

Cell["\<\
This returns all integers less than 11 which satisfy the relation. \
\>", "MathCaption",
 CellTags->{"S5.69.1", "1.29"}],

Cell[CellGroupData[{

Cell["SqrtModList[3,11]", "Input",
 CellLabel->"In[19]:= ",
 CellTags->"S5.69.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5", ",", "6"}], "}"}]], "Output",
 CellLabel->"Out[19]= ",
 CellTags->"S5.69.1"]
}, Open  ]],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  FormBox[
   StyleBox["d",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " does not have a square root modulo ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", ",
 StyleBox["SqrtMod[", "MR"],
 StyleBox["d", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["n", "TI"],
 StyleBox["]", "MR"],
 " will remain unevaluated. ",
 StyleBox["SqrtModList", "MR"],
 " will return an empty list in this case. "
}], "MathCaption",
 CellTags->{"S5.69.1", "1.30"}],

Cell[CellGroupData[{

Cell["SqrtMod[3, 5]", "Input",
 CellLabel->"In[20]:= ",
 CellTags->"S5.69.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"PowerMod", "::", "\<\"root\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"The equation x^\\!\\(2\\) = \\!\\(3\\) (mod \\!\\(5\\)) \
has no integer solutions.\"\>"}]], "Message",
 CellTags->"S5.69.1"],

Cell[BoxData[
 RowBox[{"SqrtMod", "[", 
  RowBox[{"3", ",", "5"}], "]"}]], "Output",
 CellLabel->"Out[20]= ",
 CellTags->"S5.69.1"]
}, Open  ]],

Cell["This checks that 3 is not a square modulo 5. ", "MathCaption",
 CellTags->{"S5.69.1", "1.31"}],

Cell[CellGroupData[{

Cell["Mod[{0, 1, 2, 3, 4}^2, 5]", "Input",
 CellLabel->"In[21]:= ",
 CellTags->"S5.69.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "1", ",", "4", ",", "4", ",", "1"}], "}"}]], "Output",
 CellLabel->"Out[21]= ",
 CellTags->"S5.69.1"]
}, Open  ]],

Cell["\<\
Even for large modulus, the square root can be computed fairly quickly. \
\>", "MathCaption",
 CellTags->{"S5.69.1", "1.32"}],

Cell[CellGroupData[{

Cell["SqrtMod[2, 10^64 + 57]//Timing", "Input",
 CellLabel->"In[22]:= ",
 CellTags->"S5.69.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.019999999999999976`", " ", "Second"}], ",", 
   "876504467496681643735926111996546100401033611976777074909122865"}], 
  "}"}]], "Output",
 CellLabel->"Out[22]= ",
 CellTags->"S5.69.1"]
}, Open  ]],

Cell[TextData[{
 StyleBox["SqrtMod[", "MR"],
 StyleBox["d", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["n", "TI"],
 StyleBox["]", "MR"],
 " also works for composite ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.69.1", "1.33"}],

Cell[CellGroupData[{

Cell["SqrtMod[3, 11^3]", "Input",
 CellLabel->"In[23]:= ",
 CellTags->"S5.69.1"],

Cell[BoxData["578"], "Output",
 CellLabel->"Out[23]= ",
 CellTags->"S5.69.1"]
}, Open  ]],

Cell[TextData[{
 "Since the algorithm factors ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", ",
 StyleBox["SqrtMod[", "MR"],
 StyleBox["d", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["n", "TI"],
 StyleBox["]", "MR"],
 " may not return a result for very large composite values of ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "Text",
 CellTags->{"S5.69.1", "1.34"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["PrimitiveRoot[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give a primitive root of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["n",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", where ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["n",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is a prime power or twice a prime power",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.69.1"],

Cell["Computing primitive roots. ", "Caption",
 CellTags->"S5.69.1"],

Cell[TextData[{
 StyleBox["PrimitiveRoot[", "MR"],
 StyleBox["n", "TI"],
 StyleBox["]", "MR"],
 " returns a generator for the group of numbers relatively prime to ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " under multiplication ",
 Cell[BoxData[
  FormBox[
   RowBox[{"mod", " ", 
    StyleBox["n",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". This has a generator if and only if ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is 2, 4, a power of an odd prime, or twice a power of an odd prime. The \
algorithm is deterministic and uses ",
 StyleBox["FactorInteger", "MR"],
 ". If ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is a prime or prime power, the least positive primitive root will be \
returned. "
}], "Text",
 CellTags->{"S5.69.1", "1.35"}],

Cell[TextData[{
 "Here is a primitive root of ",
 Cell[BoxData[
  FormBox["5", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.69.1", "1.36"}],

Cell[CellGroupData[{

Cell["PrimitiveRoot[5]", "Input",
 CellLabel->"In[24]:= ",
 CellTags->"S5.69.1"],

Cell[BoxData["2"], "Output",
 CellLabel->"Out[24]= ",
 CellTags->"S5.69.1"]
}, Open  ]],

Cell["This confirms that it does generate the group. ", "MathCaption",
 CellTags->{"S5.69.1", "1.37"}],

Cell[CellGroupData[{

Cell["Sort[Mod[2^Range[4], 5]]", "Input",
 CellLabel->"In[25]:= ",
 CellTags->"S5.69.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}]], "Output",
 CellLabel->"Out[25]= ",
 CellTags->"S5.69.1"]
}, Open  ]],

Cell["Here is a primitive root of a prime power. ", "MathCaption",
 CellTags->{"S5.69.1", "1.38"}],

Cell[CellGroupData[{

Cell["PrimitiveRoot[1093^3]", "Input",
 CellLabel->"In[26]:= ",
 CellTags->"S5.69.1"],

Cell[BoxData["5"], "Output",
 CellLabel->"Out[26]= ",
 CellTags->"S5.69.1"]
}, Open  ]],

Cell["Here is a primitive root of twice a prime power. ", "MathCaption",
 CellTags->{"S5.69.1", "1.39"}],

Cell[CellGroupData[{

Cell["PrimitiveRoot[2*5^5]", "Input",
 CellLabel->"In[27]:= ",
 CellTags->"S5.69.1"],

Cell[BoxData["3127"], "Output",
 CellLabel->"Out[27]= ",
 CellTags->"S5.69.1"]
}, Open  ]],

Cell["\<\
If the argument is composite and not a prime power or twice a prime power, \
the function does not evaluate. \
\>", "MathCaption",
 CellTags->{"S5.69.1", "1.40"}],

Cell[CellGroupData[{

Cell["PrimitiveRoot[11*13]", "Input",
 CellLabel->"In[28]:= ",
 CellTags->"S5.69.1"],

Cell[BoxData[
 RowBox[{"PrimitiveRoot", "[", "143", "]"}]], "Output",
 CellLabel->"Out[28]= ",
 CellTags->"S5.69.1"]
}, Open  ]],

Cell[TextData[{
 StyleBox["PrimitiveRoot", "MR"],
 " uses ",
 StyleBox["FactorInteger", "MR"],
 " as a subroutine, so it may not return a result for very large arguments. "
}], "Text",
 CellTags->{"S5.69.1", "1.41"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["QuadraticRepresentation[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["d", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["y", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" solving ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         SuperscriptBox[
          StyleBox["x",
           "TI"], "2"], "+", 
         StyleBox["d",
          "TI"], 
         SuperscriptBox[
          StyleBox["y",
           "TI"], "2"], "=", 
         StyleBox["n",
          "TI"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" (when a solution exists), for odd ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["n",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and positive ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["d",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.69.1"],

Cell["Finding quadratic representations. ", "Caption",
 CellTags->"S5.69.1"],

Cell[TextData[{
 StyleBox["QuadraticRepresentation[", "MR"],
 StyleBox["d", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["n", "TI"],
 StyleBox["]", "MR"],
 " returns ",
 StyleBox["{", "MR"],
 StyleBox["x", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["y", "TI"],
 StyleBox["}", "MR"],
 " where ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     StyleBox["x",
      "TI"], "2"], "+", 
    StyleBox["d",
     "TI"], " ", 
    SuperscriptBox[
     StyleBox["y",
      "TI"], "2"], "=", 
    StyleBox["n",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", if such a representation exists. Here ",
 Cell[BoxData[
  FormBox[
   StyleBox["d",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " must be a positive integer and ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is odd. The algorithm resembles the Euclidean algorithm, and for the case \
of prime ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " was discovered by Cornacchia, see S.\[NonBreakingSpace]Wagon, \
\[OpenCurlyDoubleQuote]The Euclidean Algorithm Strikes Again,\
\[CloseCurlyDoubleQuote] ",
 StyleBox["American Mathematical Monthly", "TI"],
 " 97 (1990), pages 124\[Dash]125. The generalization to all ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is given in the paper by K.\[NonBreakingSpace]Hardy, \
J.\[NonBreakingSpace]B.\[NonBreakingSpace]Muskat, and K.\[NonBreakingSpace]S.\
\[NonBreakingSpace]Williams, \[OpenCurlyDoubleQuote]A Deterministic Algorithm \
for Solving ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["n",
     "TI"], "=", 
    StyleBox["f",
     "TI"], 
    SuperscriptBox[
     StyleBox["u",
      "TI"], "2"], "+", 
    StyleBox["g",
     "TI"], 
    SuperscriptBox[
     StyleBox["v",
      "TI"], "2"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " in Coprime Integers ",
 Cell[BoxData[
  FormBox[
   StyleBox["u",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox["v",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ",\[CloseCurlyDoubleQuote] ",
 StyleBox["Mathematics of Computation", "TI"],
 " 55 (1990), pages 327\[Dash]343. This algorithm uses ",
 StyleBox["SqrtMod[-", "MR"],
 StyleBox["d", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["n", "TI"],
 StyleBox["]", "MR"],
 " as a subroutine and therefore requires the factorization of ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "Text",
 CellTags->{"S5.69.1", "1.42"}],

Cell[TextData[{
 StyleBox["QuadraticRepresentation[", "MR"],
 StyleBox["d", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["n", "TI"],
 StyleBox["]", "MR"],
 " may not return an answer for two reasons: "
}], "Text",
 CellTags->{"S5.69.1", "1.43"}],

Cell[TextData[{
 "(1)\[NonBreakingSpace]",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", 
    StyleBox["d",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is not a perfect square ",
 Cell[BoxData[
  FormBox[
   RowBox[{"mod", " ", 
    StyleBox["n",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", that is, ",
 StyleBox["JacobiSymbol[-", "MR"],
 StyleBox["d", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["n", "TI"],
 StyleBox["]", "MR"],
 " is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "1"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "Text",
 CellTags->{"S5.69.1", "1.44"}],

Cell[TextData[{
 "(2)\[NonBreakingSpace]The class number of the extension field ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[DoubleStruckCapitalQ]", 
    RowBox[{"(", 
     SqrtBox[
      RowBox[{"-", 
       StyleBox["d",
        "TI"]}]], ")"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is greater than one, and a prime divisor ",
 Cell[BoxData[
  FormBox[
   StyleBox["p",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " of ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " splits into prime ideals not in the principal class. "
}], "Text",
 CellTags->{"S5.69.1", "1.45"}],

Cell[TextData[{
 "The reason that condition\[NonBreakingSpace](1) can imply the nonexistence \
of a representation is that the equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     StyleBox["x",
      "TI"], "2"], "+", 
    StyleBox["d",
     "TI"], " ", 
    SuperscriptBox[
     StyleBox["y",
      "TI"], "2"], "=", 
    StyleBox["n",
     "TI"], " ", "mod", " ", 
    StyleBox["n",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " implies that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     StyleBox["x",
      "TI"], "2"], "+", 
    StyleBox["d",
     "TI"], " ", 
    SuperscriptBox[
     StyleBox["y",
      "TI"], "2"], "=", 
    RowBox[{"0", " "}], "mod", " ", 
    StyleBox["n",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", so that ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", 
    StyleBox["d",
     "TI"], "=", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       StyleBox["x",
        "TI"], "/", 
       StyleBox["y",
        "TI"]}], ")"}], "2"], " ", "mod", " ", 
    StyleBox["n",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is a perfect square ",
 Cell[BoxData[
  FormBox[
   RowBox[{"mod", " ", 
    StyleBox["n",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " (here division is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"mod", " ", 
    StyleBox["n",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "). It follows from this that for such a representation to exist, each prime \
",
 Cell[BoxData[
  FormBox[
   StyleBox["p",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " that divides ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and for which ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", 
    StyleBox["d",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is not a perfect square must divide ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " to an even power. "
}], "Text",
 CellTags->{"S5.69.1", "1.46"}],

Cell[TextData[{
 "A complete analysis of condition\[NonBreakingSpace](2) is given in the book \
D.\[NonBreakingSpace]A.\[NonBreakingSpace]Cox, ",
 StyleBox["Primes of the Form", "TI"],
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     StyleBox["x",
      "TI"], "2"], "+", 
    StyleBox["n",
     "TI"], 
    SuperscriptBox[
     StyleBox["y",
      "TI"], "2"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", Wiley, 1989. "
}], "Text",
 CellTags->{"S5.69.1", "1.47"}],

Cell[TextData[{
 "This gives a quadratic representation of\[NonBreakingSpace]",
 Cell[BoxData[
  FormBox["13", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.69.1", "1.48"}],

Cell[CellGroupData[{

Cell["QuadraticRepresentation[1, 13]", "Input",
 CellLabel->"In[29]:= ",
 CellTags->"S5.69.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "2"}], "}"}]], "Output",
 CellLabel->"Out[29]= ",
 CellTags->"S5.69.1"]
}, Open  ]],

Cell["This verifies the result. ", "MathCaption",
 CellTags->{"S5.69.1", "1.49"}],

Cell[CellGroupData[{

Cell["(%^2) . {1, 1}", "Input",
 CellLabel->"In[30]:= ",
 CellTags->"S5.69.1"],

Cell[BoxData["13"], "Output",
 CellLabel->"Out[30]= ",
 CellTags->"S5.69.1"]
}, Open  ]],

Cell[TextData[{
 "The case ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["d",
     "TI"], "=", "1"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is essentially the same as ",
 StyleBox["FactorInteger[", "MR"],
 StyleBox["n", "TI"],
 StyleBox[", GaussianIntegers", "MR"],
 " ",
 StyleBox["->", "MR"],
 " ",
 StyleBox["True]", "MR"],
 " "
}], "MathCaption",
 CellTags->{"S5.69.1", "1.50"}],

Cell[CellGroupData[{

Cell["FactorInteger[13, GaussianIntegers -> True]", "Input",
 CellLabel->"In[31]:= ",
 CellTags->"S5.69.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "\[ImaginaryI]"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", "+", 
      RowBox[{"3", " ", "\[ImaginaryI]"}]}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"3", "+", 
      RowBox[{"2", " ", "\[ImaginaryI]"}]}], ",", "1"}], "}"}]}], 
  "}"}]], "Output",
 CellLabel->"Out[31]= ",
 CellTags->"S5.69.1"]
}, Open  ]],

Cell["Here is a fairly large composite number. ", "MathCaption",
 CellTags->{"S5.69.1", "1.51"}],

Cell[CellGroupData[{

Cell["13*31*61*Prime[10^7]", "Input",
 CellLabel->"In[32]:= ",
 CellTags->"S5.69.1"],

Cell[BoxData["4410796736359"], "Output",
 CellLabel->"Out[32]= ",
 CellTags->"S5.69.1"]
}, Open  ]],

Cell[TextData[{
 "This computes its quadratic representation using ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["d",
     "TI"], "=", "3"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.69.1", "1.52"}],

Cell[CellGroupData[{

Cell["QuadraticRepresentation[3, %]", "Input",
 CellLabel->"In[33]:= ",
 CellTags->"S5.69.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1864234", ",", "558399"}], "}"}]], "Output",
 CellLabel->"Out[33]= ",
 CellTags->"S5.69.1"]
}, Open  ]],

Cell["This verifies the result. ", "MathCaption",
 CellTags->{"S5.69.1", "1.53"}],

Cell[CellGroupData[{

Cell["(%^2) . {1, 3}", "Input",
 CellLabel->"In[34]:= ",
 CellTags->"S5.69.1"],

Cell[BoxData["4410796736359"], "Output",
 CellLabel->"Out[34]= ",
 CellTags->"S5.69.1"]
}, Open  ]],

Cell["\<\
Even for large numbers, you can get a quadratic representation fairly \
quickly. \
\>", "MathCaption",
 CellTags->{"S5.69.1", "1.54"}],

Cell[CellGroupData[{

Cell["QuadraticRepresentation[1, 10^64+57]//Timing", "Input",
 CellLabel->"In[35]:= ",
 CellTags->"S5.69.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.01999999999999995`", " ", "Second"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "84124543127432900917005691375104", ",", 
     "54065342351645956058977745119829"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[35]= ",
 CellTags->"S5.69.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["FundamentalDiscriminantQ[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["d", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["determine whether ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["d", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is a fundamental discriminant",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ClassList[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["d", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "give a list of inequivalent quadratic forms of discriminant ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["d",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", where ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["d",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is a negative integer",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ClassNumber[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["d", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "give the class number of the quadratic number field corresponding to ",
       
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["d",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.69.1"],

Cell[TextData[{
 "Using ",
 StyleBox["ClassList", "MR"],
 ". "
}], "Caption",
 CellTags->"S5.69.1"],

Cell[TextData[{
 "An integer ",
 Cell[BoxData[
  FormBox[
   StyleBox["d",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is a fundamental discriminant if it is either congruent to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"0", ",", 
    RowBox[{"1", "mod", "4"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " where ",
 Cell[BoxData[
  FormBox[
   StyleBox["d",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is odd and square\[Hyphen]free, or it is congruent to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", ",", 
    RowBox[{"3", "mod", "4"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox["d",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is even and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["d",
     "TI"], "/", "4"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is square\[Hyphen]free. "
}], "Text",
 CellTags->{"S5.69.1", "1.55"}],

Cell[TextData[{
 StyleBox["ClassList[", "MR"],
 StyleBox["d", "TI"],
 StyleBox["]", "MR"],
 " gives a set of representatives of the equivalence classes under \
composition of binary quadratic forms ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["a",
     "TI"], 
    SuperscriptBox[
     StyleBox["x",
      "TI"], "2"], "+", 
    StyleBox["b",
     "TI"], 
    StyleBox["x",
     "TI"], 
    StyleBox["y",
     "TI"], "+", 
    StyleBox["c",
     "TI"], 
    SuperscriptBox[
     StyleBox["y",
      "TI"], "2"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " of negative integer ",
 Cell[BoxData[
  FormBox[
   StyleBox["d",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". This list will have elements for ",
 Cell[BoxData[
  FormBox[
   StyleBox["d",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " square\[Hyphen]free and of the form ",
 Cell[BoxData[
  FormBox[
   RowBox[{"4", 
    StyleBox["n",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " or ",
 Cell[BoxData[
  FormBox[
   RowBox[{"4", 
    StyleBox["n",
     "TI"], "+", "1"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". A quadratic form is represented by the list ",
 StyleBox["{", "MR"],
 StyleBox["a", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["b", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["c", "TI"],
 StyleBox["}", "MR"],
 ". The algorithm is the most straightforward one and is slow for inputs much \
larger in magnitude than ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["10", "4"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "Text",
 CellTags->{"S5.69.1", "1.56"}],

Cell[TextData[{
 StyleBox["ClassNumber[", "MR"],
 StyleBox["d", "TI"],
 StyleBox["]", "MR"],
 " finds the class number of the quadratic number field ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[DoubleStruckCapitalQ]", 
    RowBox[{"(", 
     SqrtBox[
      StyleBox["d",
       "TI"]], ")"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " where ",
 Cell[BoxData[
  FormBox[
   StyleBox["d",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is a fundamental discriminant. This is equal to the length of ",
 StyleBox["ClassList[", "MR"],
 StyleBox["d", "TI"],
 StyleBox["]", "MR"],
 " for negative ",
 Cell[BoxData[
  FormBox[
   StyleBox["d",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". ",
 StyleBox["ClassNumber", "MR"],
 " uses an analytic formula which is asymptotically faster than a brute force \
search. "
}], "Text",
 CellTags->{"S5.69.1", "1.57"}],

Cell[TextData[{
 "Here are representatives of the three quadratic forms with discriminant ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "23"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.69.1", "1.58"}],

Cell[CellGroupData[{

Cell["ClassList[-23]", "Input",
 CellLabel->"In[36]:= ",
 CellTags->"S5.69.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "1"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "3"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[36]= ",
 CellTags->"S5.69.1"]
}, Open  ]],

Cell["\<\
Here we verify that the input integer is a fundamental discriminant. \
\>", "MathCaption",
 CellTags->{"S5.69.1", "1.59"}],

Cell[CellGroupData[{

Cell["FundamentalDiscriminantQ[-10099]", "Input",
 CellLabel->"In[37]:= ",
 CellTags->"S5.69.1"],

Cell[BoxData["True"], "Output",
 CellLabel->"Out[37]= ",
 CellTags->"S5.69.1"]
}, Open  ]],

Cell["\<\
The class number is just the number of inequivalent quadratic forms with the \
given discriminant, if the discriminant is fundamental. \
\>", "MathCaption",
 CellTags->{"S5.69.1", "1.60"}],

Cell[CellGroupData[{

Cell["ClassNumber[-10099]", "Input",
 CellLabel->"In[38]:= ",
 CellTags->"S5.69.1"],

Cell[BoxData["25"], "Output",
 CellLabel->"Out[38]= ",
 CellTags->"S5.69.1"]
}, Open  ]],

Cell[TextData[{
 StyleBox["ClassNumber", "MR"],
 " can accept positive discriminants, unlike ",
 StyleBox["ClassList", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.69.1", "1.61"}],

Cell[CellGroupData[{

Cell["ClassNumber[65]", "Input",
 CellLabel->"In[39]:= ",
 CellTags->"S5.69.1"],

Cell[BoxData["2"], "Output",
 CellLabel->"Out[39]= ",
 CellTags->"S5.69.1"]
}, Open  ]],

Cell["\<\
Gauss conjectured and H.\[NonBreakingSpace]Stark proved in 1968 that this is \
the last negative discriminant of class number one. \
\>", "MathCaption",
 CellTags->{"S5.69.1", "1.62"}],

Cell[CellGroupData[{

Cell["ClassNumber[-163]", "Input",
 CellLabel->"In[40]:= ",
 CellTags->"S5.69.1"],

Cell[BoxData["1"], "Output",
 CellLabel->"Out[40]= ",
 CellTags->"S5.69.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["KroneckerSymbol[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["m", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["find the Kronecker symbol corresponding to the integers ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["m", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.69.1"],

Cell["Kronecker symbols. ", "Caption",
 CellTags->"S5.69.1"],

Cell[TextData[{
 "Kronecker symbols are extensions of Jacobi symbols to all integers ",
 Cell[BoxData[
  FormBox[
   StyleBox["m",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". They are used in operations involving discriminants of quadratic fields. \
"
}], "Text",
 CellTags->{"S5.69.1", "1.63"}],

Cell[TextData[{
 "This finds the Kronecker symbol ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    FractionBox["5", "3"], ")"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "."
}], "MathCaption",
 CellTags->{"S5.69.1", "1.64"}],

Cell[CellGroupData[{

Cell["KroneckerSymbol[5, 3]", "Input",
 CellLabel->"In[41]:= ",
 CellTags->"S5.69.1"],

Cell[BoxData[
 RowBox[{"-", "1"}]], "Output",
 CellLabel->"Out[41]= ",
 CellTags->"S5.69.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["SumOfSquaresR[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["d", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the number of representations of an integer ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["n",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" as a sum of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["d",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" squares",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["SumOfSquaresRepresentations[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["d", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give a list of all representations of an integer ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["n",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" as a sum of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["d",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" squares",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["OrderedSumOfSquaresRepresentations[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["d", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give a list of ordered representations of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["n",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" as a sum of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["d",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" squares of nonnegative integers",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.69.1"],

Cell["Representing an integer as a sum of squares. ", "Caption",
 CellTags->"S5.69.1"],

Cell[TextData[{
 StyleBox["SumOfSquaresRepresentations[", "MR"],
 StyleBox["d", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["n", "TI"],
 StyleBox["]", "MR"],
 " gives a set of representations of the integer ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " as a sum of ",
 Cell[BoxData[
  FormBox[
   StyleBox["d",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " squares, while ",
 StyleBox["OrderedSumOfSquaresRepresentations[", "MR"],
 StyleBox["d", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["n", "TI"],
 StyleBox["]", "MR"],
 " gives only those representations as a sum of ",
 Cell[BoxData[
  FormBox[
   StyleBox["d",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " nondecreasing nonnegative squares. ",
 StyleBox["SumOfSquaresR[", "MR"],
 StyleBox["d", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["n", "TI"],
 StyleBox["]", "MR"],
 " gives ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     StyleBox["r",
      "TI"], 
     StyleBox["d",
      "TI"]], 
    RowBox[{"(", 
     StyleBox["n",
      "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", the number of representations of the integer ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " as a sum of ",
 Cell[BoxData[
  FormBox[
   StyleBox["d",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " squares. For ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["d",
     "TI"], "=", "2", ",", "4", ",", "6", ",", "8"}], TraditionalForm]], 
  "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", ",
 StyleBox["SumOfSquaresR[", "MR"],
 StyleBox["d", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["n", "TI"],
 StyleBox["]", "MR"],
 " can handle large integer values of ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", as long as ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " can be factored. For other values of ",
 Cell[BoxData[
  FormBox[
   StyleBox["d",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", ",
 StyleBox["SumOfSquaresR[", "MR"],
 StyleBox["d", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["n", "TI"],
 StyleBox["]", "MR"],
 " uses recursion, thus only modestly sized values of ",
 Cell[BoxData[
  FormBox[
   StyleBox["m",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox["d",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " can be used. "
}], "Text",
 CellTags->{"S5.69.1", "1.65"}],

Cell[TextData[{
 "Here are the representations of ",
 Cell[BoxData[
  FormBox["100", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " as a sum of ",
 Cell[BoxData[
  FormBox["3", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " squares. "
}], "MathCaption",
 CellTags->{"S5.69.1", "1.66"}],

Cell[CellGroupData[{

Cell["SumOfSquaresRepresentations[3, 100]", "Input",
 CellLabel->"In[42]:= ",
 CellTags->"S5.69.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "10"}], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "8"}], ",", 
     RowBox[{"-", "6"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "8"}], ",", "0", ",", 
     RowBox[{"-", "6"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "8"}], ",", "0", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "8"}], ",", "6", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "6"}], ",", 
     RowBox[{"-", "8"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "6"}], ",", "0", ",", 
     RowBox[{"-", "8"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "6"}], ",", "0", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "6"}], ",", "8", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"-", "10"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"-", "8"}], ",", 
     RowBox[{"-", "6"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"-", "8"}], ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"-", "6"}], ",", 
     RowBox[{"-", "8"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"-", "6"}], ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{"-", "10"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "6", ",", 
     RowBox[{"-", "8"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "6", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "8", ",", 
     RowBox[{"-", "6"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "8", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "10", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", 
     RowBox[{"-", "8"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "0", ",", 
     RowBox[{"-", "8"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "0", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "8", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", 
     RowBox[{"-", "6"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "0", ",", 
     RowBox[{"-", "6"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "0", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "6", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[42]= ",
 CellTags->"S5.69.1"]
}, Open  ]],

Cell["This checks that the representations are valid. ", "MathCaption",
 CellTags->{"S5.69.1", "1.67"}],

Cell[CellGroupData[{

Cell["Apply[Plus, (%^2), 2]", "Input",
 CellLabel->"In[43]:= ",
 CellTags->"S5.69.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "100", ",", "100", ",", "100", ",", "100", ",", "100", ",", "100", ",", 
   "100", ",", "100", ",", "100", ",", "100", ",", "100", ",", "100", ",", 
   "100", ",", "100", ",", "100", ",", "100", ",", "100", ",", "100", ",", 
   "100", ",", "100", ",", "100", ",", "100", ",", "100", ",", "100", ",", 
   "100", ",", "100", ",", "100", ",", "100", ",", "100", ",", "100"}], 
  "}"}]], "Output",
 CellLabel->"Out[43]= ",
 CellTags->"S5.69.1"]
}, Open  ]],

Cell["Here is the ordered list of the same representations. ", "MathCaption",
 CellTags->{"S5.69.1", "1.68"}],

Cell[CellGroupData[{

Cell["OrderedSumOfSquaresRepresentations[3, 100]", "Input",
 CellLabel->"In[44]:= ",
 CellTags->"S5.69.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"10", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "6", ",", "0"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[44]= ",
 CellTags->"S5.69.1"]
}, Open  ]],

Cell[TextData[{
 "The asymptotic average value of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["r",
     "TI"], "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is ",
 Cell[BoxData[
  FormBox["\[Pi]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.69.1", "1.69"}],

Cell[CellGroupData[{

Cell["Sum[N[SumOfSquaresR[2, k]], {k, 200}] / 200", "Input",
 CellLabel->"In[45]:= ",
 CellTags->"S5.69.1"],

Cell[BoxData["3.16`"], "Output",
 CellLabel->"Out[45]= ",
 CellTags->"S5.69.1"]
}, Open  ]],

Cell[TextData[{
 StyleBox["SumOfSquaresRepresentations", "MR"],
 " and ",
 StyleBox["SumOfSquaresR", "MR"],
 " are modifications of algorithms contributed by Stan Wagon. "
}], "Text",
 CellTags->{"S5.69.1", "1.70"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["WhichRootOfUnity[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["a", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["given an algebraic number ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["a", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", determine which root of unity it corresponds to, if any",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.69.1"],

Cell["Identifying de Moivre numbers. ", "Caption",
 CellTags->"S5.69.1"],

Cell[TextData[{
 "Solutions to the cylcotomic equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     StyleBox["x",
      "TI"], 
     StyleBox["n",
      "TI"]], "=", "1"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " are algebraic numbers lying on the unit circle forming the vertices of a \
regular polygon. They are called de Moivre numbers, or roots of unity. They \
can be expressed in the form ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["e",
     "TI"], 
    RowBox[{"2", "\[Pi]", 
     StyleBox["i",
      "TI"], 
     StyleBox["k",
      "TI"], "/", 
     StyleBox["n",
      "TI"]}]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", where ",
 Cell[BoxData[
  FormBox[
   StyleBox["k",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " designate which root the number corresponds to. ",
 StyleBox["WhichRootOfUnity", "MR"],
 " returns the pair ",
 StyleBox["{", "MR"],
 StyleBox["n", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["k", "TI"],
 StyleBox["}", "MR"],
 ". "
}], "Text",
 CellTags->{"S5.69.1", "1.71"}],

Cell["\<\
This finds that the input is a de Moivre corresponding to the first sixth \
root of unity. \
\>", "MathCaption",
 CellTags->{"S5.69.1", "1.72"}],

Cell["WhichRootOfUnity[(1 + I Sqrt[3])/2]", "Input",
 CellLabel->"In[46]:= ",
 CellTags->"S5.69.1"],

Cell[TextData[{
 "Note that ",
 StyleBox["WhichRootOfUnity", "MR"],
 " may not recognize a root of unity if it is not simplified enough. "
}], "Text",
 CellTags->{"S5.69.1", "1.73"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["SumOfFactors[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["return the sum of the nontrivial divisors of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["AliquotSequence[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["return the aliquot sequence starting at ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["AliquotCycle[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["return the cyclic portion of the aliquot sequence for ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.69.1"],

Cell["Functions for working with aliquot sequences. ", "Caption",
 CellTags->"S5.69.1"],

Cell[TextData[{
 "Given an integer ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", we can find the positive divisors which are less than ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and sum them. For example, ",
 Cell[BoxData[
  FormBox["14", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " has divisors ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", ",
 Cell[BoxData[
  FormBox["2", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", and ",
 Cell[BoxData[
  FormBox["7", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", which sum to ",
 Cell[BoxData[
  FormBox["10", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". The function ",
 StyleBox["SumOfFactors", "MR"],
 " computes this sum directly. Now, suppose that ",
 StyleBox["SumOfFactors", "MR"],
 " is applied recursively to the sum? The resulting sequence of numbers is \
called an aliquot sequence. This sequence will terminate when the sum reaches \
",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". The sequence may not terminate, but become cyclic; the function ",
 StyleBox["AliquotCycle", "MR"],
 " returns the cyclic portion. It has been theorized that all aliquot \
sequences must terminate or become cyclic, though this is unproven, and some \
evidence suggests that it is false. The smallest number for which we do not \
yet know whether the sequence terminates is ",
 Cell[BoxData[
  FormBox["276", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", as of April 2003. "
}], "Text",
 CellTags->{"S5.69.1", "1.74"}],

Cell[TextData[{
 "Here is the sum of divisors of ",
 Cell[BoxData[
  FormBox["14", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.69.1", "1.75"}],

Cell[CellGroupData[{

Cell["SumOfFactors[14]", "Input",
 CellLabel->"In[47]:= ",
 CellTags->"S5.69.1"],

Cell[BoxData["10"], "Output",
 CellLabel->"Out[47]= ",
 CellTags->"S5.69.1"]
}, Open  ]],

Cell[TextData[{
 "If ",
 StyleBox["SumOfFactors[", "MR"],
 StyleBox["n", "TI"],
 StyleBox["]", "MR"],
 " equals ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", then ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is said to be perfect. "
}], "MathCaption",
 CellTags->{"S5.69.1", "1.76"}],

Cell[CellGroupData[{

Cell["SumOfFactors[6]", "Input",
 CellLabel->"In[48]:= ",
 CellTags->"S5.69.1"],

Cell[BoxData["6"], "Output",
 CellLabel->"Out[48]= ",
 CellTags->"S5.69.1"]
}, Open  ]],

Cell[TextData[{
 "Here is the aliquot sequence starting at 95. Note that it is cyclic, \
terminating at ",
 Cell[BoxData[
  FormBox["6", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.69.1", "1.77"}],

Cell[CellGroupData[{

Cell["AliquotSequence[95]", "Input",
 CellLabel->"In[49]:= ",
 CellTags->"S5.69.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"95", ",", "25", ",", "6", ",", "6"}], "}"}]], "Output",
 CellLabel->"Out[49]= ",
 CellTags->"S5.69.1"]
}, Open  ]],

Cell["This returns the cyclic portion directly. ", "MathCaption",
 CellTags->{"S5.69.1", "1.78"}],

Cell[CellGroupData[{

Cell["AliquotCycle[95]", "Input",
 CellLabel->"In[50]:= ",
 CellTags->"S5.69.1"],

Cell[BoxData[
 RowBox[{"{", "6", "}"}]], "Output",
 CellLabel->"Out[50]= ",
 CellTags->"S5.69.1"]
}, Open  ]],

Cell[TextData[{
 "If the cycle is of length greater than ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", it is called a amicable chain, and its elements are called sociable \
numbers. If the cycle is of length ",
 Cell[BoxData[
  FormBox["2", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", the elements are called amicable numbers. ",
 Cell[BoxData[
  FormBox["220", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is the smallest amicable number. "
}], "Text",
 CellTags->{"S5.69.1", "1.79"}],

Cell[TextData[{
 "Here is an amicable chain of length ",
 Cell[BoxData[
  FormBox["5", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", discovered by Poulet in 1918. "
}], "MathCaption",
 CellTags->{"S5.69.1", "1.80"}],

Cell[CellGroupData[{

Cell["AliquotCycle[12496]", "Input",
 CellLabel->"In[51]:= ",
 CellTags->"S5.69.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"12496", ",", "14288", ",", "15472", ",", "14536", ",", "14264"}], 
  "}"}]], "Output",
 CellLabel->"Out[51]= ",
 CellTags->"S5.69.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["option name", "TI",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["default value", "TI",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox["",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["SumOfFactorsType", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Automatic", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox["type of factor sum",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["TermIncrement", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["0", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "value to add to each teration",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ShowProgress", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["False", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "whether to print progress information for each cycle",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["MaxIterations", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Infinity", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "maximum length of sequence",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["MaxTerms", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Infinity", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "maximum size of terms in sequence",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
 GridBoxOptions->{RowLines->{True, False},
 RowSpacings->0.4},
 CellTags->"S5.69.1"],

Cell["Options for aliquot functions. ", "Caption",
 CellTags->"S5.69.1"],

Cell[TextData[{
 "A variety of options can be used to modify the computations in ",
 StyleBox["AliquotSequence", "MR"],
 " and ",
 StyleBox["AliquotCycle", "MR"],
 ". The ",
 StyleBox["MaxIterations", "MR"],
 " and ",
 StyleBox["MaxTerms", "MR"],
 " options can limit the size computations for the aliquot sequence, by \
specifying the maximum number of terms the sequence should have and the size \
of the terms. ",
 StyleBox["ShowProgress", "MR"],
 " can be set to ",
 StyleBox["True", "MR"],
 " to monitor the progress of the computation. ",
 StyleBox["TermIncrement", "MR"],
 " can be used to add an extra increment to the result of computing the value \
for each term in the sequence. "
}], "Text",
 CellTags->{"S5.69.1", "1.81"}],

Cell[TextData[{
 "The ",
 StyleBox["SumOfFactorsType", "MR"],
 " option applies to ",
 StyleBox["SumOfFactors", "MR"],
 " as well as the aliquot functions. It determines what definition to use for \
the divisors. By default, all divisors are summed. Other definitions can be \
applied by setting this option to ",
 StyleBox["Unitary", "MR"],
 ", ",
 StyleBox["Biunitary", "MR"],
 ", ",
 StyleBox["Exponential", "MR"],
 ", ",
 StyleBox["ModifiedExponential", "MR"],
 ", or ",
 StyleBox["Infinitary", "MR"],
 ". "
}], "Text",
 CellTags->{"S5.69.1", "1.82"}],

Cell["Here is the ordinary sum of divisors with default behavior. ", \
"MathCaption",
 CellTags->{"S5.69.1", "1.83"}],

Cell[CellGroupData[{

Cell["SumOfFactors[12]", "Input",
 CellLabel->"In[52]:= ",
 CellTags->"S5.69.1"],

Cell[BoxData["16"], "Output",
 CellLabel->"Out[52]= ",
 CellTags->"S5.69.1"]
}, Open  ]],

Cell[TextData[{
 StyleBox["Unitary", "MR"],
 " indicates only unitary divisors are to be added. A nontrivial factor ",
 Cell[BoxData[
  FormBox[
   StyleBox["d",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " of ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is unitary if ",
 Cell[BoxData[
  FormBox[
   StyleBox["d",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["n",
     "TI"], "/", 
    StyleBox["d",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " are coprime. "
}], "MathCaption",
 CellTags->{"S5.69.1", "1.84"}],

Cell[CellGroupData[{

Cell["SumOfFactors[12, SumOfFactorsType -> Unitary]", "Input",
 CellLabel->"In[53]:= ",
 CellTags->"S5.69.1"],

Cell[BoxData["8"], "Output",
 CellLabel->"Out[53]= ",
 CellTags->"S5.69.1"]
}, Open  ]],

Cell[TextData[{
 StyleBox["Biunitary", "MR"],
 " denotes nontrivial divisors ",
 Cell[BoxData[
  FormBox[
   StyleBox["d",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " for which if for every prime factor ",
 Cell[BoxData[
  FormBox[
   StyleBox["p",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " of ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["p",
     "TI"], 
    StyleBox["e",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is not the largest power of ",
 Cell[BoxData[
  FormBox[
   StyleBox["p",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " dividing ",
 Cell[BoxData[
  FormBox[
   StyleBox["d",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " where ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["p",
     "TI"], 
    RowBox[{"2", 
     StyleBox["e",
      "TI"]}]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is the largest power of ",
 Cell[BoxData[
  FormBox[
   StyleBox["p",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " dividing ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.69.1", "1.85"}],

Cell[CellGroupData[{

Cell["SumOfFactors[12, SumOfFactorsType -> Biunitary]", "Input",
 CellLabel->"In[54]:= ",
 CellTags->"S5.69.1"],

Cell[BoxData["8"], "Output",
 CellLabel->"Out[54]= ",
 CellTags->"S5.69.1"]
}, Open  ]],

Cell[TextData[{
 "Here, an infinitary divisor ",
 Cell[BoxData[
  FormBox[
   StyleBox["d",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " of ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is one where if for every prime factor ",
 Cell[BoxData[
  FormBox[
   StyleBox["p",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " of ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", if ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["p",
     "TI"], 
    StyleBox["a",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is the largest power of ",
 Cell[BoxData[
  FormBox[
   StyleBox["p",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " dividing ",
 Cell[BoxData[
  FormBox[
   StyleBox["d",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["p",
     "TI"], 
    StyleBox["c",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is the largest power of ",
 Cell[BoxData[
  FormBox[
   StyleBox["p",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " dividing ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", then all binary digits of ",
 Cell[BoxData[
  FormBox[
   StyleBox["c",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " that are zero are also zero for ",
 Cell[BoxData[
  FormBox[
   StyleBox["a",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.69.1", "1.86"}],

Cell[CellGroupData[{

Cell["SumOfFactors[12, SumOfFactorsType -> Infinitary]", "Input",
 CellLabel->"In[55]:= ",
 CellTags->"S5.69.1"],

Cell[BoxData["8"], "Output",
 CellLabel->"Out[55]= ",
 CellTags->"S5.69.1"]
}, Open  ]],

Cell[TextData[{
 StyleBox["Exponential", "MR"],
 " divisors use the same notation as ",
 StyleBox["Infinitary", "MR"],
 ", but in this case either ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["a",
     "TI"], "=", "0"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " or ",
 Cell[BoxData[
  FormBox[
   StyleBox["a",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " divides ",
 Cell[BoxData[
  FormBox[
   StyleBox["c",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.69.1", "1.87"}],

Cell[CellGroupData[{

Cell["SumOfFactors[12, SumOfFactorsType -> Exponential]", "Input",
 CellLabel->"In[56]:= ",
 CellTags->"S5.69.1"],

Cell[BoxData["16"], "Output",
 CellLabel->"Out[56]= ",
 CellTags->"S5.69.1"]
}, Open  ]],

Cell[TextData[{
 "The ",
 StyleBox["ModifiedExponential", "MR"],
 " case is similar to ",
 StyleBox["Exponential", "MR"],
 ", except that here the condition for ",
 Cell[BoxData[
  FormBox[
   StyleBox["d",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " to be a divisor is that ",
 Cell[BoxData[
  FormBox[
   StyleBox["a",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " divides ",
 Cell[BoxData[
  FormBox[
   StyleBox["c",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["a",
     "TI"], "+", "1"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " divides ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["c",
     "TI"], "+", "1"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.69.1", "1.88"}],

Cell[CellGroupData[{

Cell["SumOfFactors[12, SumOfFactorsType -> ModifiedExponential]", "Input",
 CellLabel->"In[57]:= ",
 CellTags->"S5.69.1"],

Cell[BoxData["8"], "Output",
 CellLabel->"Out[57]= ",
 CellTags->"S5.69.1"]
}, Open  ]],

Cell[TextData[{
 "Powers of ",
 Cell[BoxData[
  FormBox["2", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " become perfect in this case, since the sum of the nontrivial divisors of \
",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["2", 
    StyleBox["e",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["2", 
     StyleBox["e",
      "TI"]], "-", "1"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.69.1", "1.89"}],

Cell[CellGroupData[{

Cell["AliquotSequence[16, TermIncrement -> 1]", "Input",
 CellLabel->"In[58]:= ",
 CellTags->"S5.69.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"16", ",", "16"}], "}"}]], "Output",
 CellLabel->"Out[58]= ",
 CellTags->"S5.69.1"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.69.1"->{
    Cell[1776, 53, 150, 6, 36, "Subsection",
      CellTags->{"S5.69.1", "1.1"}],
    Cell[1929, 61, 850, 16, 104, "Text",
      CellTags->{"S5.69.1", "1.2"}],
    Cell[2782, 79, 1447, 46, 64, "DefinitionBox",
      CellTags->"S5.69.1"],
    Cell[4232, 127, 71, 1, 15, "Caption",
      CellTags->"S5.69.1"],
    Cell[4306, 130, 2026, 70, 72, "Text",
      CellTags->{"S5.69.1", "1.3"}],
    Cell[6335, 202, 78, 1, 40, "MathCaption",
      CellTags->{"S5.69.1", "1.4"}],
    Cell[6416, 205, 100, 2, 28, "Input",
      CellTags->"S5.69.1"],
    Cell[6519, 209, 106, 1, 40, "MathCaption",
      CellTags->{"S5.69.1", "1.5"}],
    Cell[6650, 214, 83, 2, 28, "Input",
      CellTags->"S5.69.1"],
    Cell[6736, 218, 77, 2, 25, "Output",
      CellTags->"S5.69.1"],
    Cell[6828, 223, 333, 11, 40, "MathCaption",
      CellTags->{"S5.69.1", "1.6"}],
    Cell[7186, 238, 78, 2, 28, "Input",
      CellTags->"S5.69.1"],
    Cell[7267, 242, 78, 2, 23, "Output",
      CellTags->"S5.69.1"],
    Cell[7360, 247, 129, 4, 40, "MathCaption",
      CellTags->{"S5.69.1", "1.7"}],
    Cell[7514, 255, 85, 2, 28, "Input",
      CellTags->"S5.69.1"],
    Cell[7602, 259, 77, 2, 25, "Output",
      CellTags->"S5.69.1"],
    Cell[7694, 264, 2928, 93, 70, "DefinitionBox",
      CellTags->"S5.69.1"],
    Cell[10625, 359, 64, 1, 70, "Caption",
      CellTags->"S5.69.1"],
    Cell[10692, 362, 1783, 64, 70, "Text",
      CellTags->{"S5.69.1", "1.8"}],
    Cell[12478, 428, 221, 7, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.9"}],
    Cell[12724, 439, 76, 2, 70, "Input",
      CellTags->"S5.69.1"],
    Cell[12803, 443, 75, 2, 70, "Output",
      CellTags->"S5.69.1"],
    Cell[12893, 448, 134, 3, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.10"}],
    Cell[13052, 455, 88, 2, 70, "Input",
      CellTags->"S5.69.1"],
    Cell[13143, 459, 258, 7, 70, "Output",
      CellTags->"S5.69.1"],
    Cell[13416, 469, 229, 7, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.11"}],
    Cell[13670, 480, 80, 2, 70, "Input",
      CellTags->"S5.69.1"],
    Cell[13753, 484, 75, 2, 70, "Output",
      CellTags->"S5.69.1"],
    Cell[13843, 489, 1107, 36, 70, "Text",
      CellTags->{"S5.69.1", "1.12"}],
    Cell[14953, 527, 361, 11, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.13"}],
    Cell[15339, 542, 87, 2, 70, "Input",
      CellTags->"S5.69.1"],
    Cell[15429, 546, 75, 2, 70, "Output",
      CellTags->"S5.69.1"],
    Cell[15519, 551, 3116, 96, 70, "DefinitionBox",
      CellTags->"S5.69.1"],
    Cell[18638, 649, 77, 1, 70, "Caption",
      CellTags->"S5.69.1"],
    Cell[18718, 652, 228, 7, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.14"}],
    Cell[18971, 663, 83, 2, 70, "Input",
      CellTags->"S5.69.1"],
    Cell[19057, 667, 121, 4, 70, "Output",
      CellTags->"S5.69.1"],
    Cell[19193, 674, 100, 1, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.15"}],
    Cell[19318, 679, 85, 2, 70, "Input",
      CellTags->"S5.69.1"],
    Cell[19406, 683, 76, 2, 70, "Output",
      CellTags->"S5.69.1"],
    Cell[19497, 688, 137, 4, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.16"}],
    Cell[19659, 696, 86, 2, 70, "Input",
      CellTags->"S5.69.1"],
    Cell[19748, 700, 142, 4, 70, "Output",
      CellTags->"S5.69.1"],
    Cell[19905, 707, 1167, 40, 70, "Text",
      CellTags->{"S5.69.1", "1.17"}],
    Cell[21075, 749, 107, 1, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.18"}],
    Cell[21207, 754, 82, 2, 70, "Input",
      CellTags->"S5.69.1"],
    Cell[21292, 758, 78, 2, 70, "Output",
      CellTags->"S5.69.1"],
    Cell[21385, 763, 147, 4, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.19"}],
    Cell[21557, 771, 86, 2, 70, "Input",
      CellTags->"S5.69.1"],
    Cell[21646, 775, 98, 3, 70, "Output",
      CellTags->"S5.69.1"],
    Cell[21759, 781, 2457, 75, 70, "DefinitionBox",
      CellTags->"S5.69.1"],
    Cell[24219, 858, 75, 1, 70, "Caption",
      CellTags->"S5.69.1"],
    Cell[24297, 861, 1610, 56, 70, "Text",
      CellTags->{"S5.69.1", "1.20"}],
    Cell[25910, 919, 728, 27, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.21"}],
    Cell[26663, 950, 104, 2, 70, "Input",
      CellTags->"S5.69.1"],
    Cell[26770, 954, 77, 2, 70, "Output",
      CellTags->"S5.69.1"],
    Cell[26862, 959, 81, 1, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.22"}],
    Cell[26968, 964, 85, 2, 70, "Input",
      CellTags->"S5.69.1"],
    Cell[27056, 968, 130, 4, 70, "Output",
      CellTags->"S5.69.1"],
    Cell[27201, 975, 105, 1, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.23"}],
    Cell[27331, 980, 109, 2, 70, "Input",
      CellTags->"S5.69.1"],
    Cell[27443, 984, 101, 2, 70, "Output",
      CellTags->"S5.69.1"],
    Cell[27559, 989, 2563, 82, 70, "DefinitionBox",
      CellTags->"S5.69.1"],
    Cell[30125, 1073, 113, 5, 70, "Caption",
      CellTags->"S5.69.1"],
    Cell[30241, 1080, 1040, 41, 70, "Text",
      CellTags->{"S5.69.1", "1.24"}],
    Cell[31284, 1123, 1748, 64, 70, "Text",
      CellTags->{"S5.69.1", "1.25"}],
    Cell[33035, 1189, 851, 31, 70, "Text",
      CellTags->{"S5.69.1", "1.26"}],
    Cell[33889, 1222, 591, 21, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.27"}],
    Cell[34505, 1247, 78, 2, 70, "Input",
      CellTags->"S5.69.1"],
    Cell[34586, 1251, 75, 2, 70, "Output",
      CellTags->"S5.69.1"],
    Cell[34676, 1256, 81, 1, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.28"}],
    Cell[34782, 1261, 76, 2, 70, "Input",
      CellTags->"S5.69.1"],
    Cell[34861, 1265, 75, 2, 70, "Output",
      CellTags->"S5.69.1"],
    Cell[34951, 1270, 130, 3, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.29"}],
    Cell[35106, 1277, 81, 2, 70, "Input",
      CellTags->"S5.69.1"],
    Cell[35190, 1281, 120, 4, 70, "Output",
      CellTags->"S5.69.1"],
    Cell[35325, 1288, 620, 23, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.30"}],
    Cell[35970, 1315, 77, 2, 70, "Input",
      CellTags->"S5.69.1"],
    Cell[36050, 1319, 226, 6, 70, "Message",
      CellTags->"S5.69.1"],
    Cell[36279, 1327, 131, 4, 70, "Output",
      CellTags->"S5.69.1"],
    Cell[36425, 1334, 100, 1, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.31"}],
    Cell[36550, 1339, 89, 2, 70, "Input",
      CellTags->"S5.69.1"],
    Cell[36642, 1343, 150, 4, 70, "Output",
      CellTags->"S5.69.1"],
    Cell[36807, 1350, 135, 3, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.32"}],
    Cell[36967, 1357, 94, 2, 70, "Input",
      CellTags->"S5.69.1"],
    Cell[37064, 1361, 238, 7, 70, "Output",
      CellTags->"S5.69.1"],
    Cell[37317, 1371, 357, 14, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.33"}],
    Cell[37699, 1389, 80, 2, 70, "Input",
      CellTags->"S5.69.1"],
    Cell[37782, 1393, 77, 2, 70, "Output",
      CellTags->"S5.69.1"],
    Cell[37874, 1398, 560, 21, 70, "Text",
      CellTags->{"S5.69.1", "1.34"}],
    Cell[38437, 1421, 1567, 48, 70, "DefinitionBox",
      CellTags->"S5.69.1"],
    Cell[40007, 1471, 68, 1, 70, "Caption",
      CellTags->"S5.69.1"],
    Cell[40078, 1474, 1097, 35, 70, "Text",
      CellTags->{"S5.69.1", "1.35"}],
    Cell[41178, 1511, 217, 7, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.36"}],
    Cell[41420, 1522, 80, 2, 70, "Input",
      CellTags->"S5.69.1"],
    Cell[41503, 1526, 75, 2, 70, "Output",
      CellTags->"S5.69.1"],
    Cell[41593, 1531, 102, 1, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.37"}],
    Cell[41720, 1536, 88, 2, 70, "Input",
      CellTags->"S5.69.1"],
    Cell[41811, 1540, 140, 4, 70, "Output",
      CellTags->"S5.69.1"],
    Cell[41966, 1547, 98, 1, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.38"}],
    Cell[42089, 1552, 85, 2, 70, "Input",
      CellTags->"S5.69.1"],
    Cell[42177, 1556, 75, 2, 70, "Output",
      CellTags->"S5.69.1"],
    Cell[42267, 1561, 104, 1, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.39"}],
    Cell[42396, 1566, 84, 2, 70, "Input",
      CellTags->"S5.69.1"],
    Cell[42483, 1570, 78, 2, 70, "Output",
      CellTags->"S5.69.1"],
    Cell[42576, 1575, 172, 4, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.40"}],
    Cell[42773, 1583, 84, 2, 70, "Input",
      CellTags->"S5.69.1"],
    Cell[42860, 1587, 116, 3, 70, "Output",
      CellTags->"S5.69.1"],
    Cell[42991, 1593, 216, 6, 70, "Text",
      CellTags->{"S5.69.1", "1.41"}],
    Cell[43210, 1601, 2772, 88, 70, "DefinitionBox",
      CellTags->"S5.69.1"],
    Cell[45985, 1691, 76, 1, 70, "Caption",
      CellTags->"S5.69.1"],
    Cell[46064, 1694, 2980, 104, 70, "Text",
      CellTags->{"S5.69.1", "1.42"}],
    Cell[49047, 1800, 240, 8, 70, "Text",
      CellTags->{"S5.69.1", "1.43"}],
    Cell[49290, 1810, 723, 28, 70, "Text",
      CellTags->{"S5.69.1", "1.44"}],
    Cell[50016, 1840, 759, 25, 70, "Text",
      CellTags->{"S5.69.1", "1.45"}],
    Cell[50778, 1867, 2421, 93, 70, "Text",
      CellTags->{"S5.69.1", "1.46"}],
    Cell[53202, 1962, 528, 19, 70, "Text",
      CellTags->{"S5.69.1", "1.47"}],
    Cell[53733, 1983, 249, 7, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.48"}],
    Cell[54007, 1994, 94, 2, 70, "Input",
      CellTags->"S5.69.1"],
    Cell[54104, 1998, 120, 4, 70, "Output",
      CellTags->"S5.69.1"],
    Cell[54239, 2005, 81, 1, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.49"}],
    Cell[54345, 2010, 78, 2, 70, "Input",
      CellTags->"S5.69.1"],
    Cell[54426, 2014, 76, 2, 70, "Output",
      CellTags->"S5.69.1"],
    Cell[54517, 2019, 437, 18, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.50"}],
    Cell[54979, 2041, 107, 2, 70, "Input",
      CellTags->"S5.69.1"],
    Cell[55089, 2045, 443, 16, 70, "Output",
      CellTags->"S5.69.1"],
    Cell[55547, 2064, 96, 1, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.51"}],
    Cell[55668, 2069, 84, 2, 70, "Input",
      CellTags->"S5.69.1"],
    Cell[55755, 2073, 87, 2, 70, "Output",
      CellTags->"S5.69.1"],
    Cell[55857, 2078, 288, 10, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.52"}],
    Cell[56170, 2092, 93, 2, 70, "Input",
      CellTags->"S5.69.1"],
    Cell[56266, 2096, 131, 4, 70, "Output",
      CellTags->"S5.69.1"],
    Cell[56412, 2103, 81, 1, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.53"}],
    Cell[56518, 2108, 78, 2, 70, "Input",
      CellTags->"S5.69.1"],
    Cell[56599, 2112, 87, 2, 70, "Output",
      CellTags->"S5.69.1"],
    Cell[56701, 2117, 144, 4, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.54"}],
    Cell[56870, 2125, 108, 2, 70, "Input",
      CellTags->"S5.69.1"],
    Cell[56981, 2129, 290, 9, 70, "Output",
      CellTags->"S5.69.1"],
    Cell[57286, 2141, 3459, 108, 70, "DefinitionBox",
      CellTags->"S5.69.1"],
    Cell[60748, 2251, 99, 5, 70, "Caption",
      CellTags->"S5.69.1"],
    Cell[60850, 2258, 1165, 40, 70, "Text",
      CellTags->{"S5.69.1", "1.55"}],
    Cell[62018, 2300, 1820, 68, 70, "Text",
      CellTags->{"S5.69.1", "1.56"}],
    Cell[63841, 2370, 993, 34, 70, "Text",
      CellTags->{"S5.69.1", "1.57"}],
    Cell[64837, 2406, 281, 8, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.58"}],
    Cell[65143, 2418, 78, 2, 70, "Input",
      CellTags->"S5.69.1"],
    Cell[65224, 2422, 328, 11, 70, "Output",
      CellTags->"S5.69.1"],
    Cell[65567, 2436, 132, 3, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.59"}],
    Cell[65724, 2443, 96, 2, 70, "Input",
      CellTags->"S5.69.1"],
    Cell[65823, 2447, 78, 2, 70, "Output",
      CellTags->"S5.69.1"],
    Cell[65916, 2452, 198, 4, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.60"}],
    Cell[66139, 2460, 83, 2, 70, "Input",
      CellTags->"S5.69.1"],
    Cell[66225, 2464, 76, 2, 70, "Output",
      CellTags->"S5.69.1"],
    Cell[66316, 2469, 182, 6, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.61"}],
    Cell[66523, 2479, 79, 2, 70, "Input",
      CellTags->"S5.69.1"],
    Cell[66605, 2483, 75, 2, 70, "Output",
      CellTags->"S5.69.1"],
    Cell[66695, 2488, 194, 4, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.62"}],
    Cell[66914, 2496, 81, 2, 70, "Input",
      CellTags->"S5.69.1"],
    Cell[66998, 2500, 75, 2, 70, "Output",
      CellTags->"S5.69.1"],
    Cell[67088, 2505, 1371, 43, 70, "DefinitionBox",
      CellTags->"S5.69.1"],
    Cell[68462, 2550, 60, 1, 70, "Caption",
      CellTags->"S5.69.1"],
    Cell[68525, 2553, 491, 16, 70, "Text",
      CellTags->{"S5.69.1", "1.63"}],
    Cell[69019, 2571, 267, 9, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.64"}],
    Cell[69311, 2584, 85, 2, 70, "Input",
      CellTags->"S5.69.1"],
    Cell[69399, 2588, 92, 3, 70, "Output",
      CellTags->"S5.69.1"],
    Cell[69506, 2594, 4935, 150, 70, "DefinitionBox",
      CellTags->"S5.69.1"],
    Cell[74444, 2746, 86, 1, 70, "Caption",
      CellTags->"S5.69.1"],
    Cell[74533, 2749, 3018, 113, 70, "Text",
      CellTags->{"S5.69.1", "1.65"}],
    Cell[77554, 2864, 361, 11, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.66"}],
    Cell[77940, 2879, 99, 2, 70, "Input",
      CellTags->"S5.69.1"],
    Cell[78042, 2883, 2743, 91, 70, "Output",
      CellTags->"S5.69.1"],
    Cell[80800, 2977, 103, 1, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.67"}],
    Cell[80928, 2982, 85, 2, 70, "Input",
      CellTags->"S5.69.1"],
    Cell[81016, 2986, 482, 10, 70, "Output",
      CellTags->"S5.69.1"],
    Cell[81513, 2999, 109, 1, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.68"}],
    Cell[81647, 3004, 106, 2, 70, "Input",
      CellTags->"S5.69.1"],
    Cell[81756, 3008, 239, 8, 70, "Output",
      CellTags->"S5.69.1"],
    Cell[82010, 3019, 395, 14, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.69"}],
    Cell[82430, 3037, 107, 2, 70, "Input",
      CellTags->"S5.69.1"],
    Cell[82540, 3041, 79, 2, 70, "Output",
      CellTags->"S5.69.1"],
    Cell[82634, 3046, 215, 6, 70, "Text",
      CellTags->{"S5.69.1", "1.70"}],
    Cell[82852, 3054, 1111, 34, 70, "DefinitionBox",
      CellTags->"S5.69.1"],
    Cell[83966, 3090, 72, 1, 70, "Caption",
      CellTags->"S5.69.1"],
    Cell[84041, 3093, 1324, 49, 70, "Text",
      CellTags->{"S5.69.1", "1.71"}],
    Cell[85368, 3144, 154, 4, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.72"}],
    Cell[85525, 3150, 99, 2, 70, "Input",
      CellTags->"S5.69.1"],
    Cell[85627, 3154, 182, 5, 70, "Text",
      CellTags->{"S5.69.1", "1.73"}],
    Cell[85812, 3161, 2577, 81, 70, "DefinitionBox",
      CellTags->"S5.69.1"],
    Cell[88392, 3244, 87, 1, 70, "Caption",
      CellTags->"S5.69.1"],
    Cell[88482, 3247, 1994, 54, 70, "Text",
      CellTags->{"S5.69.1", "1.74"}],
    Cell[90479, 3303, 221, 7, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.75"}],
    Cell[90725, 3314, 80, 2, 70, "Input",
      CellTags->"S5.69.1"],
    Cell[90808, 3318, 76, 2, 70, "Output",
      CellTags->"S5.69.1"],
    Cell[90899, 3323, 477, 19, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.76"}],
    Cell[91401, 3346, 79, 2, 70, "Input",
      CellTags->"S5.69.1"],
    Cell[91483, 3350, 75, 2, 70, "Output",
      CellTags->"S5.69.1"],
    Cell[91573, 3355, 275, 8, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.77"}],
    Cell[91873, 3367, 83, 2, 70, "Input",
      CellTags->"S5.69.1"],
    Cell[91959, 3371, 142, 4, 70, "Output",
      CellTags->"S5.69.1"],
    Cell[92116, 3378, 97, 1, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.78"}],
    Cell[92238, 3383, 80, 2, 70, "Input",
      CellTags->"S5.69.1"],
    Cell[92321, 3387, 97, 3, 70, "Output",
      CellTags->"S5.69.1"],
    Cell[92433, 3393, 640, 16, 70, "Text",
      CellTags->{"S5.69.1", "1.79"}],
    Cell[93076, 3411, 255, 7, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.80"}],
    Cell[93356, 3422, 83, 2, 70, "Input",
      CellTags->"S5.69.1"],
    Cell[93442, 3426, 173, 5, 70, "Output",
      CellTags->"S5.69.1"],
    Cell[93630, 3434, 5044, 148, 70, "DefinitionBox3Col",
      CellTags->"S5.69.1"],
    Cell[98677, 3584, 72, 1, 70, "Caption",
      CellTags->"S5.69.1"],
    Cell[98752, 3587, 735, 20, 70, "Text",
      CellTags->{"S5.69.1", "1.81"}],
    Cell[99490, 3609, 555, 19, 70, "Text",
      CellTags->{"S5.69.1", "1.82"}],
    Cell[100048, 3630, 117, 2, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.83"}],
    Cell[100190, 3636, 80, 2, 70, "Input",
      CellTags->"S5.69.1"],
    Cell[100273, 3640, 76, 2, 70, "Output",
      CellTags->"S5.69.1"],
    Cell[100364, 3645, 822, 31, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.84"}],
    Cell[101211, 3680, 109, 2, 70, "Input",
      CellTags->"S5.69.1"],
    Cell[101323, 3684, 75, 2, 70, "Output",
      CellTags->"S5.69.1"],
    Cell[101413, 3689, 1652, 65, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.85"}],
    Cell[103090, 3758, 111, 2, 70, "Input",
      CellTags->"S5.69.1"],
    Cell[103204, 3762, 75, 2, 70, "Output",
      CellTags->"S5.69.1"],
    Cell[103294, 3767, 2087, 81, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.86"}],
    Cell[105406, 3852, 112, 2, 70, "Input",
      CellTags->"S5.69.1"],
    Cell[105521, 3856, 75, 2, 70, "Output",
      CellTags->"S5.69.1"],
    Cell[105611, 3861, 663, 25, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.87"}],
    Cell[106299, 3890, 113, 2, 70, "Input",
      CellTags->"S5.69.1"],
    Cell[106415, 3894, 76, 2, 70, "Output",
      CellTags->"S5.69.1"],
    Cell[106506, 3899, 1020, 39, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.88"}],
    Cell[107551, 3942, 121, 2, 70, "Input",
      CellTags->"S5.69.1"],
    Cell[107675, 3946, 75, 2, 70, "Output",
      CellTags->"S5.69.1"],
    Cell[107765, 3951, 642, 23, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.89"}],
    Cell[108432, 3978, 103, 2, 70, "Input",
      CellTags->"S5.69.1"],
    Cell[108538, 3982, 122, 4, 70, "Output",
      CellTags->"S5.69.1"]},
  "1.1"->{
    Cell[1776, 53, 150, 6, 36, "Subsection",
      CellTags->{"S5.69.1", "1.1"}]},
  "1.2"->{
    Cell[1929, 61, 850, 16, 104, "Text",
      CellTags->{"S5.69.1", "1.2"}]},
  "1.3"->{
    Cell[4306, 130, 2026, 70, 72, "Text",
      CellTags->{"S5.69.1", "1.3"}]},
  "1.4"->{
    Cell[6335, 202, 78, 1, 40, "MathCaption",
      CellTags->{"S5.69.1", "1.4"}]},
  "1.5"->{
    Cell[6519, 209, 106, 1, 40, "MathCaption",
      CellTags->{"S5.69.1", "1.5"}]},
  "1.6"->{
    Cell[6828, 223, 333, 11, 40, "MathCaption",
      CellTags->{"S5.69.1", "1.6"}]},
  "1.7"->{
    Cell[7360, 247, 129, 4, 40, "MathCaption",
      CellTags->{"S5.69.1", "1.7"}]},
  "1.8"->{
    Cell[10692, 362, 1783, 64, 70, "Text",
      CellTags->{"S5.69.1", "1.8"}]},
  "1.9"->{
    Cell[12478, 428, 221, 7, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.9"}]},
  "1.10"->{
    Cell[12893, 448, 134, 3, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.10"}]},
  "1.11"->{
    Cell[13416, 469, 229, 7, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.11"}]},
  "1.12"->{
    Cell[13843, 489, 1107, 36, 70, "Text",
      CellTags->{"S5.69.1", "1.12"}]},
  "1.13"->{
    Cell[14953, 527, 361, 11, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.13"}]},
  "1.14"->{
    Cell[18718, 652, 228, 7, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.14"}]},
  "1.15"->{
    Cell[19193, 674, 100, 1, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.15"}]},
  "1.16"->{
    Cell[19497, 688, 137, 4, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.16"}]},
  "1.17"->{
    Cell[19905, 707, 1167, 40, 70, "Text",
      CellTags->{"S5.69.1", "1.17"}]},
  "1.18"->{
    Cell[21075, 749, 107, 1, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.18"}]},
  "1.19"->{
    Cell[21385, 763, 147, 4, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.19"}]},
  "1.20"->{
    Cell[24297, 861, 1610, 56, 70, "Text",
      CellTags->{"S5.69.1", "1.20"}]},
  "1.21"->{
    Cell[25910, 919, 728, 27, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.21"}]},
  "1.22"->{
    Cell[26862, 959, 81, 1, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.22"}]},
  "1.23"->{
    Cell[27201, 975, 105, 1, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.23"}]},
  "1.24"->{
    Cell[30241, 1080, 1040, 41, 70, "Text",
      CellTags->{"S5.69.1", "1.24"}]},
  "1.25"->{
    Cell[31284, 1123, 1748, 64, 70, "Text",
      CellTags->{"S5.69.1", "1.25"}]},
  "1.26"->{
    Cell[33035, 1189, 851, 31, 70, "Text",
      CellTags->{"S5.69.1", "1.26"}]},
  "1.27"->{
    Cell[33889, 1222, 591, 21, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.27"}]},
  "1.28"->{
    Cell[34676, 1256, 81, 1, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.28"}]},
  "1.29"->{
    Cell[34951, 1270, 130, 3, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.29"}]},
  "1.30"->{
    Cell[35325, 1288, 620, 23, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.30"}]},
  "1.31"->{
    Cell[36425, 1334, 100, 1, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.31"}]},
  "1.32"->{
    Cell[36807, 1350, 135, 3, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.32"}]},
  "1.33"->{
    Cell[37317, 1371, 357, 14, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.33"}]},
  "1.34"->{
    Cell[37874, 1398, 560, 21, 70, "Text",
      CellTags->{"S5.69.1", "1.34"}]},
  "1.35"->{
    Cell[40078, 1474, 1097, 35, 70, "Text",
      CellTags->{"S5.69.1", "1.35"}]},
  "1.36"->{
    Cell[41178, 1511, 217, 7, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.36"}]},
  "1.37"->{
    Cell[41593, 1531, 102, 1, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.37"}]},
  "1.38"->{
    Cell[41966, 1547, 98, 1, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.38"}]},
  "1.39"->{
    Cell[42267, 1561, 104, 1, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.39"}]},
  "1.40"->{
    Cell[42576, 1575, 172, 4, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.40"}]},
  "1.41"->{
    Cell[42991, 1593, 216, 6, 70, "Text",
      CellTags->{"S5.69.1", "1.41"}]},
  "1.42"->{
    Cell[46064, 1694, 2980, 104, 70, "Text",
      CellTags->{"S5.69.1", "1.42"}]},
  "1.43"->{
    Cell[49047, 1800, 240, 8, 70, "Text",
      CellTags->{"S5.69.1", "1.43"}]},
  "1.44"->{
    Cell[49290, 1810, 723, 28, 70, "Text",
      CellTags->{"S5.69.1", "1.44"}]},
  "1.45"->{
    Cell[50016, 1840, 759, 25, 70, "Text",
      CellTags->{"S5.69.1", "1.45"}]},
  "1.46"->{
    Cell[50778, 1867, 2421, 93, 70, "Text",
      CellTags->{"S5.69.1", "1.46"}]},
  "1.47"->{
    Cell[53202, 1962, 528, 19, 70, "Text",
      CellTags->{"S5.69.1", "1.47"}]},
  "1.48"->{
    Cell[53733, 1983, 249, 7, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.48"}]},
  "1.49"->{
    Cell[54239, 2005, 81, 1, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.49"}]},
  "1.50"->{
    Cell[54517, 2019, 437, 18, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.50"}]},
  "1.51"->{
    Cell[55547, 2064, 96, 1, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.51"}]},
  "1.52"->{
    Cell[55857, 2078, 288, 10, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.52"}]},
  "1.53"->{
    Cell[56412, 2103, 81, 1, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.53"}]},
  "1.54"->{
    Cell[56701, 2117, 144, 4, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.54"}]},
  "1.55"->{
    Cell[60850, 2258, 1165, 40, 70, "Text",
      CellTags->{"S5.69.1", "1.55"}]},
  "1.56"->{
    Cell[62018, 2300, 1820, 68, 70, "Text",
      CellTags->{"S5.69.1", "1.56"}]},
  "1.57"->{
    Cell[63841, 2370, 993, 34, 70, "Text",
      CellTags->{"S5.69.1", "1.57"}]},
  "1.58"->{
    Cell[64837, 2406, 281, 8, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.58"}]},
  "1.59"->{
    Cell[65567, 2436, 132, 3, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.59"}]},
  "1.60"->{
    Cell[65916, 2452, 198, 4, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.60"}]},
  "1.61"->{
    Cell[66316, 2469, 182, 6, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.61"}]},
  "1.62"->{
    Cell[66695, 2488, 194, 4, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.62"}]},
  "1.63"->{
    Cell[68525, 2553, 491, 16, 70, "Text",
      CellTags->{"S5.69.1", "1.63"}]},
  "1.64"->{
    Cell[69019, 2571, 267, 9, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.64"}]},
  "1.65"->{
    Cell[74533, 2749, 3018, 113, 70, "Text",
      CellTags->{"S5.69.1", "1.65"}]},
  "1.66"->{
    Cell[77554, 2864, 361, 11, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.66"}]},
  "1.67"->{
    Cell[80800, 2977, 103, 1, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.67"}]},
  "1.68"->{
    Cell[81513, 2999, 109, 1, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.68"}]},
  "1.69"->{
    Cell[82010, 3019, 395, 14, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.69"}]},
  "1.70"->{
    Cell[82634, 3046, 215, 6, 70, "Text",
      CellTags->{"S5.69.1", "1.70"}]},
  "1.71"->{
    Cell[84041, 3093, 1324, 49, 70, "Text",
      CellTags->{"S5.69.1", "1.71"}]},
  "1.72"->{
    Cell[85368, 3144, 154, 4, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.72"}]},
  "1.73"->{
    Cell[85627, 3154, 182, 5, 70, "Text",
      CellTags->{"S5.69.1", "1.73"}]},
  "1.74"->{
    Cell[88482, 3247, 1994, 54, 70, "Text",
      CellTags->{"S5.69.1", "1.74"}]},
  "1.75"->{
    Cell[90479, 3303, 221, 7, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.75"}]},
  "1.76"->{
    Cell[90899, 3323, 477, 19, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.76"}]},
  "1.77"->{
    Cell[91573, 3355, 275, 8, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.77"}]},
  "1.78"->{
    Cell[92116, 3378, 97, 1, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.78"}]},
  "1.79"->{
    Cell[92433, 3393, 640, 16, 70, "Text",
      CellTags->{"S5.69.1", "1.79"}]},
  "1.80"->{
    Cell[93076, 3411, 255, 7, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.80"}]},
  "1.81"->{
    Cell[98752, 3587, 735, 20, 70, "Text",
      CellTags->{"S5.69.1", "1.81"}]},
  "1.82"->{
    Cell[99490, 3609, 555, 19, 70, "Text",
      CellTags->{"S5.69.1", "1.82"}]},
  "1.83"->{
    Cell[100048, 3630, 117, 2, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.83"}]},
  "1.84"->{
    Cell[100364, 3645, 822, 31, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.84"}]},
  "1.85"->{
    Cell[101413, 3689, 1652, 65, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.85"}]},
  "1.86"->{
    Cell[103294, 3767, 2087, 81, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.86"}]},
  "1.87"->{
    Cell[105611, 3861, 663, 25, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.87"}]},
  "1.88"->{
    Cell[106506, 3899, 1020, 39, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.88"}]},
  "1.89"->{
    Cell[107765, 3951, 642, 23, 70, "MathCaption",
      CellTags->{"S5.69.1", "1.89"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.69.1", 109311, 4006},
  {"1.1", 126986, 4467},
  {"1.2", 127080, 4470},
  {"1.3", 127170, 4473},
  {"1.4", 127261, 4476},
  {"1.5", 127356, 4479},
  {"1.6", 127452, 4482},
  {"1.7", 127549, 4485},
  {"1.8", 127645, 4488},
  {"1.9", 127737, 4491},
  {"1.10", 127835, 4494},
  {"1.11", 127934, 4497},
  {"1.12", 128033, 4500},
  {"1.13", 128127, 4503},
  {"1.14", 128227, 4506},
  {"1.15", 128326, 4509},
  {"1.16", 128425, 4512},
  {"1.17", 128524, 4515},
  {"1.18", 128618, 4518},
  {"1.19", 128717, 4521},
  {"1.20", 128816, 4524},
  {"1.21", 128910, 4527},
  {"1.22", 129010, 4530},
  {"1.23", 129108, 4533},
  {"1.24", 129207, 4536},
  {"1.25", 129302, 4539},
  {"1.26", 129397, 4542},
  {"1.27", 129491, 4545},
  {"1.28", 129592, 4548},
  {"1.29", 129691, 4551},
  {"1.30", 129791, 4554},
  {"1.31", 129892, 4557},
  {"1.32", 129992, 4560},
  {"1.33", 130092, 4563},
  {"1.34", 130193, 4566},
  {"1.35", 130287, 4569},
  {"1.36", 130382, 4572},
  {"1.37", 130482, 4575},
  {"1.38", 130582, 4578},
  {"1.39", 130681, 4581},
  {"1.40", 130781, 4584},
  {"1.41", 130881, 4587},
  {"1.42", 130974, 4590},
  {"1.43", 131070, 4593},
  {"1.44", 131163, 4596},
  {"1.45", 131257, 4599},
  {"1.46", 131351, 4602},
  {"1.47", 131446, 4605},
  {"1.48", 131540, 4608},
  {"1.49", 131640, 4611},
  {"1.50", 131739, 4614},
  {"1.51", 131840, 4617},
  {"1.52", 131939, 4620},
  {"1.53", 132040, 4623},
  {"1.54", 132139, 4626},
  {"1.55", 132239, 4629},
  {"1.56", 132334, 4632},
  {"1.57", 132429, 4635},
  {"1.58", 132523, 4638},
  {"1.59", 132623, 4641},
  {"1.60", 132723, 4644},
  {"1.61", 132823, 4647},
  {"1.62", 132923, 4650},
  {"1.63", 133023, 4653},
  {"1.64", 133117, 4656},
  {"1.65", 133217, 4659},
  {"1.66", 133313, 4662},
  {"1.67", 133414, 4665},
  {"1.68", 133514, 4668},
  {"1.69", 133614, 4671},
  {"1.70", 133715, 4674},
  {"1.71", 133808, 4677},
  {"1.72", 133903, 4680},
  {"1.73", 134003, 4683},
  {"1.74", 134096, 4686},
  {"1.75", 134191, 4689},
  {"1.76", 134291, 4692},
  {"1.77", 134392, 4695},
  {"1.78", 134492, 4698},
  {"1.79", 134591, 4701},
  {"1.80", 134685, 4704},
  {"1.81", 134785, 4707},
  {"1.82", 134879, 4710},
  {"1.83", 134973, 4713},
  {"1.84", 135074, 4716},
  {"1.85", 135176, 4719},
  {"1.86", 135279, 4722},
  {"1.87", 135382, 4725},
  {"1.88", 135484, 4728},
  {"1.89", 135587, 4731}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 150, 6, 36, "Subsection",
  CellTags->{"S5.69.1", "1.1"}],
Cell[1929, 61, 850, 16, 104, "Text",
  CellTags->{"S5.69.1", "1.2"}],
Cell[2782, 79, 1447, 46, 64, "DefinitionBox",
  CellTags->"S5.69.1"],
Cell[4232, 127, 71, 1, 15, "Caption",
  CellTags->"S5.69.1"],
Cell[4306, 130, 2026, 70, 72, "Text",
  CellTags->{"S5.69.1", "1.3"}],
Cell[6335, 202, 78, 1, 40, "MathCaption",
  CellTags->{"S5.69.1", "1.4"}],
Cell[6416, 205, 100, 2, 28, "Input",
  CellTags->"S5.69.1"],
Cell[6519, 209, 106, 1, 40, "MathCaption",
  CellTags->{"S5.69.1", "1.5"}],

Cell[CellGroupData[{
Cell[6650, 214, 83, 2, 28, "Input",
  CellTags->"S5.69.1"],
Cell[6736, 218, 77, 2, 25, "Output",
  CellTags->"S5.69.1"]
}, Open  ]],
Cell[6828, 223, 333, 11, 40, "MathCaption",
  CellTags->{"S5.69.1", "1.6"}],

Cell[CellGroupData[{
Cell[7186, 238, 78, 2, 28, "Input",
  CellTags->"S5.69.1"],
Cell[7267, 242, 78, 2, 23, "Output",
  CellTags->"S5.69.1"]
}, Open  ]],
Cell[7360, 247, 129, 4, 40, "MathCaption",
  CellTags->{"S5.69.1", "1.7"}],

Cell[CellGroupData[{
Cell[7514, 255, 85, 2, 28, "Input",
  CellTags->"S5.69.1"],
Cell[7602, 259, 77, 2, 25, "Output",
  CellTags->"S5.69.1"]
}, Open  ]],
Cell[7694, 264, 2928, 93, 70, "DefinitionBox",
  CellTags->"S5.69.1"],
Cell[10625, 359, 64, 1, 70, "Caption",
  CellTags->"S5.69.1"],
Cell[10692, 362, 1783, 64, 70, "Text",
  CellTags->{"S5.69.1", "1.8"}],
Cell[12478, 428, 221, 7, 70, "MathCaption",
  CellTags->{"S5.69.1", "1.9"}],

Cell[CellGroupData[{
Cell[12724, 439, 76, 2, 70, "Input",
  CellTags->"S5.69.1"],
Cell[12803, 443, 75, 2, 70, "Output",
  CellTags->"S5.69.1"]
}, Open  ]],
Cell[12893, 448, 134, 3, 70, "MathCaption",
  CellTags->{"S5.69.1", "1.10"}],

Cell[CellGroupData[{
Cell[13052, 455, 88, 2, 70, "Input",
  CellTags->"S5.69.1"],
Cell[13143, 459, 258, 7, 70, "Output",
  CellTags->"S5.69.1"]
}, Open  ]],
Cell[13416, 469, 229, 7, 70, "MathCaption",
  CellTags->{"S5.69.1", "1.11"}],

Cell[CellGroupData[{
Cell[13670, 480, 80, 2, 70, "Input",
  CellTags->"S5.69.1"],
Cell[13753, 484, 75, 2, 70, "Output",
  CellTags->"S5.69.1"]
}, Open  ]],
Cell[13843, 489, 1107, 36, 70, "Text",
  CellTags->{"S5.69.1", "1.12"}],
Cell[14953, 527, 361, 11, 70, "MathCaption",
  CellTags->{"S5.69.1", "1.13"}],

Cell[CellGroupData[{
Cell[15339, 542, 87, 2, 70, "Input",
  CellTags->"S5.69.1"],
Cell[15429, 546, 75, 2, 70, "Output",
  CellTags->"S5.69.1"]
}, Open  ]],
Cell[15519, 551, 3116, 96, 70, "DefinitionBox",
  CellTags->"S5.69.1"],
Cell[18638, 649, 77, 1, 70, "Caption",
  CellTags->"S5.69.1"],
Cell[18718, 652, 228, 7, 70, "MathCaption",
  CellTags->{"S5.69.1", "1.14"}],

Cell[CellGroupData[{
Cell[18971, 663, 83, 2, 70, "Input",
  CellTags->"S5.69.1"],
Cell[19057, 667, 121, 4, 70, "Output",
  CellTags->"S5.69.1"]
}, Open  ]],
Cell[19193, 674, 100, 1, 70, "MathCaption",
  CellTags->{"S5.69.1", "1.15"}],

Cell[CellGroupData[{
Cell[19318, 679, 85, 2, 70, "Input",
  CellTags->"S5.69.1"],
Cell[19406, 683, 76, 2, 70, "Output",
  CellTags->"S5.69.1"]
}, Open  ]],
Cell[19497, 688, 137, 4, 70, "MathCaption",
  CellTags->{"S5.69.1", "1.16"}],

Cell[CellGroupData[{
Cell[19659, 696, 86, 2, 70, "Input",
  CellTags->"S5.69.1"],
Cell[19748, 700, 142, 4, 70, "Output",
  CellTags->"S5.69.1"]
}, Open  ]],
Cell[19905, 707, 1167, 40, 70, "Text",
  CellTags->{"S5.69.1", "1.17"}],
Cell[21075, 749, 107, 1, 70, "MathCaption",
  CellTags->{"S5.69.1", "1.18"}],

Cell[CellGroupData[{
Cell[21207, 754, 82, 2, 70, "Input",
  CellTags->"S5.69.1"],
Cell[21292, 758, 78, 2, 70, "Output",
  CellTags->"S5.69.1"]
}, Open  ]],
Cell[21385, 763, 147, 4, 70, "MathCaption",
  CellTags->{"S5.69.1", "1.19"}],

Cell[CellGroupData[{
Cell[21557, 771, 86, 2, 70, "Input",
  CellTags->"S5.69.1"],
Cell[21646, 775, 98, 3, 70, "Output",
  CellTags->"S5.69.1"]
}, Open  ]],
Cell[21759, 781, 2457, 75, 70, "DefinitionBox",
  CellTags->"S5.69.1"],
Cell[24219, 858, 75, 1, 70, "Caption",
  CellTags->"S5.69.1"],
Cell[24297, 861, 1610, 56, 70, "Text",
  CellTags->{"S5.69.1", "1.20"}],
Cell[25910, 919, 728, 27, 70, "MathCaption",
  CellTags->{"S5.69.1", "1.21"}],

Cell[CellGroupData[{
Cell[26663, 950, 104, 2, 70, "Input",
  CellTags->"S5.69.1"],
Cell[26770, 954, 77, 2, 70, "Output",
  CellTags->"S5.69.1"]
}, Open  ]],
Cell[26862, 959, 81, 1, 70, "MathCaption",
  CellTags->{"S5.69.1", "1.22"}],

Cell[CellGroupData[{
Cell[26968, 964, 85, 2, 70, "Input",
  CellTags->"S5.69.1"],
Cell[27056, 968, 130, 4, 70, "Output",
  CellTags->"S5.69.1"]
}, Open  ]],
Cell[27201, 975, 105, 1, 70, "MathCaption",
  CellTags->{"S5.69.1", "1.23"}],

Cell[CellGroupData[{
Cell[27331, 980, 109, 2, 70, "Input",
  CellTags->"S5.69.1"],
Cell[27443, 984, 101, 2, 70, "Output",
  CellTags->"S5.69.1"]
}, Open  ]],
Cell[27559, 989, 2563, 82, 70, "DefinitionBox",
  CellTags->"S5.69.1"],
Cell[30125, 1073, 113, 5, 70, "Caption",
  CellTags->"S5.69.1"],
Cell[30241, 1080, 1040, 41, 70, "Text",
  CellTags->{"S5.69.1", "1.24"}],
Cell[31284, 1123, 1748, 64, 70, "Text",
  CellTags->{"S5.69.1", "1.25"}],
Cell[33035, 1189, 851, 31, 70, "Text",
  CellTags->{"S5.69.1", "1.26"}],
Cell[33889, 1222, 591, 21, 70, "MathCaption",
  CellTags->{"S5.69.1", "1.27"}],

Cell[CellGroupData[{
Cell[34505, 1247, 78, 2, 70, "Input",
  CellTags->"S5.69.1"],
Cell[34586, 1251, 75, 2, 70, "Output",
  CellTags->"S5.69.1"]
}, Open  ]],
Cell[34676, 1256, 81, 1, 70, "MathCaption",
  CellTags->{"S5.69.1", "1.28"}],

Cell[CellGroupData[{
Cell[34782, 1261, 76, 2, 70, "Input",
  CellTags->"S5.69.1"],
Cell[34861, 1265, 75, 2, 70, "Output",
  CellTags->"S5.69.1"]
}, Open  ]],
Cell[34951, 1270, 130, 3, 70, "MathCaption",
  CellTags->{"S5.69.1", "1.29"}],

Cell[CellGroupData[{
Cell[35106, 1277, 81, 2, 70, "Input",
  CellTags->"S5.69.1"],
Cell[35190, 1281, 120, 4, 70, "Output",
  CellTags->"S5.69.1"]
}, Open  ]],
Cell[35325, 1288, 620, 23, 70, "MathCaption",
  CellTags->{"S5.69.1", "1.30"}],

Cell[CellGroupData[{
Cell[35970, 1315, 77, 2, 70, "Input",
  CellTags->"S5.69.1"],
Cell[36050, 1319, 226, 6, 70, "Message",
  CellTags->"S5.69.1"],
Cell[36279, 1327, 131, 4, 70, "Output",
  CellTags->"S5.69.1"]
}, Open  ]],
Cell[36425, 1334, 100, 1, 70, "MathCaption",
  CellTags->{"S5.69.1", "1.31"}],

Cell[CellGroupData[{
Cell[36550, 1339, 89, 2, 70, "Input",
  CellTags->"S5.69.1"],
Cell[36642, 1343, 150, 4, 70, "Output",
  CellTags->"S5.69.1"]
}, Open  ]],
Cell[36807, 1350, 135, 3, 70, "MathCaption",
  CellTags->{"S5.69.1", "1.32"}],

Cell[CellGroupData[{
Cell[36967, 1357, 94, 2, 70, "Input",
  CellTags->"S5.69.1"],
Cell[37064, 1361, 238, 7, 70, "Output",
  CellTags->"S5.69.1"]
}, Open  ]],
Cell[37317, 1371, 357, 14, 70, "MathCaption",
  CellTags->{"S5.69.1", "1.33"}],

Cell[CellGroupData[{
Cell[37699, 1389, 80, 2, 70, "Input",
  CellTags->"S5.69.1"],
Cell[37782, 1393, 77, 2, 70, "Output",
  CellTags->"S5.69.1"]
}, Open  ]],
Cell[37874, 1398, 560, 21, 70, "Text",
  CellTags->{"S5.69.1", "1.34"}],
Cell[38437, 1421, 1567, 48, 70, "DefinitionBox",
  CellTags->"S5.69.1"],
Cell[40007, 1471, 68, 1, 70, "Caption",
  CellTags->"S5.69.1"],
Cell[40078, 1474, 1097, 35, 70, "Text",
  CellTags->{"S5.69.1", "1.35"}],
Cell[41178, 1511, 217, 7, 70, "MathCaption",
  CellTags->{"S5.69.1", "1.36"}],

Cell[CellGroupData[{
Cell[41420, 1522, 80, 2, 70, "Input",
  CellTags->"S5.69.1"],
Cell[41503, 1526, 75, 2, 70, "Output",
  CellTags->"S5.69.1"]
}, Open  ]],
Cell[41593, 1531, 102, 1, 70, "MathCaption",
  CellTags->{"S5.69.1", "1.37"}],

Cell[CellGroupData[{
Cell[41720, 1536, 88, 2, 70, "Input",
  CellTags->"S5.69.1"],
Cell[41811, 1540, 140, 4, 70, "Output",
  CellTags->"S5.69.1"]
}, Open  ]],
Cell[41966, 1547, 98, 1, 70, "MathCaption",
  CellTags->{"S5.69.1", "1.38"}],

Cell[CellGroupData[{
Cell[42089, 1552, 85, 2, 70, "Input",
  CellTags->"S5.69.1"],
Cell[42177, 1556, 75, 2, 70, "Output",
  CellTags->"S5.69.1"]
}, Open  ]],
Cell[42267, 1561, 104, 1, 70, "MathCaption",
  CellTags->{"S5.69.1", "1.39"}],

Cell[CellGroupData[{
Cell[42396, 1566, 84, 2, 70, "Input",
  CellTags->"S5.69.1"],
Cell[42483, 1570, 78, 2, 70, "Output",
  CellTags->"S5.69.1"]
}, Open  ]],
Cell[42576, 1575, 172, 4, 70, "MathCaption",
  CellTags->{"S5.69.1", "1.40"}],

Cell[CellGroupData[{
Cell[42773, 1583, 84, 2, 70, "Input",
  CellTags->"S5.69.1"],
Cell[42860, 1587, 116, 3, 70, "Output",
  CellTags->"S5.69.1"]
}, Open  ]],
Cell[42991, 1593, 216, 6, 70, "Text",
  CellTags->{"S5.69.1", "1.41"}],
Cell[43210, 1601, 2772, 88, 70, "DefinitionBox",
  CellTags->"S5.69.1"],
Cell[45985, 1691, 76, 1, 70, "Caption",
  CellTags->"S5.69.1"],
Cell[46064, 1694, 2980, 104, 70, "Text",
  CellTags->{"S5.69.1", "1.42"}],
Cell[49047, 1800, 240, 8, 70, "Text",
  CellTags->{"S5.69.1", "1.43"}],
Cell[49290, 1810, 723, 28, 70, "Text",
  CellTags->{"S5.69.1", "1.44"}],
Cell[50016, 1840, 759, 25, 70, "Text",
  CellTags->{"S5.69.1", "1.45"}],
Cell[50778, 1867, 2421, 93, 70, "Text",
  CellTags->{"S5.69.1", "1.46"}],
Cell[53202, 1962, 528, 19, 70, "Text",
  CellTags->{"S5.69.1", "1.47"}],
Cell[53733, 1983, 249, 7, 70, "MathCaption",
  CellTags->{"S5.69.1", "1.48"}],

Cell[CellGroupData[{
Cell[54007, 1994, 94, 2, 70, "Input",
  CellTags->"S5.69.1"],
Cell[54104, 1998, 120, 4, 70, "Output",
  CellTags->"S5.69.1"]
}, Open  ]],
Cell[54239, 2005, 81, 1, 70, "MathCaption",
  CellTags->{"S5.69.1", "1.49"}],

Cell[CellGroupData[{
Cell[54345, 2010, 78, 2, 70, "Input",
  CellTags->"S5.69.1"],
Cell[54426, 2014, 76, 2, 70, "Output",
  CellTags->"S5.69.1"]
}, Open  ]],
Cell[54517, 2019, 437, 18, 70, "MathCaption",
  CellTags->{"S5.69.1", "1.50"}],

Cell[CellGroupData[{
Cell[54979, 2041, 107, 2, 70, "Input",
  CellTags->"S5.69.1"],
Cell[55089, 2045, 443, 16, 70, "Output",
  CellTags->"S5.69.1"]
}, Open  ]],
Cell[55547, 2064, 96, 1, 70, "MathCaption",
  CellTags->{"S5.69.1", "1.51"}],

Cell[CellGroupData[{
Cell[55668, 2069, 84, 2, 70, "Input",
  CellTags->"S5.69.1"],
Cell[55755, 2073, 87, 2, 70, "Output",
  CellTags->"S5.69.1"]
}, Open  ]],
Cell[55857, 2078, 288, 10, 70, "MathCaption",
  CellTags->{"S5.69.1", "1.52"}],

Cell[CellGroupData[{
Cell[56170, 2092, 93, 2, 70, "Input",
  CellTags->"S5.69.1"],
Cell[56266, 2096, 131, 4, 70, "Output",
  CellTags->"S5.69.1"]
}, Open  ]],
Cell[56412, 2103, 81, 1, 70, "MathCaption",
  CellTags->{"S5.69.1", "1.53"}],

Cell[CellGroupData[{
Cell[56518, 2108, 78, 2, 70, "Input",
  CellTags->"S5.69.1"],
Cell[56599, 2112, 87, 2, 70, "Output",
  CellTags->"S5.69.1"]
}, Open  ]],
Cell[56701, 2117, 144, 4, 70, "MathCaption",
  CellTags->{"S5.69.1", "1.54"}],

Cell[CellGroupData[{
Cell[56870, 2125, 108, 2, 70, "Input",
  CellTags->"S5.69.1"],
Cell[56981, 2129, 290, 9, 70, "Output",
  CellTags->"S5.69.1"]
}, Open  ]],
Cell[57286, 2141, 3459, 108, 70, "DefinitionBox",
  CellTags->"S5.69.1"],
Cell[60748, 2251, 99, 5, 70, "Caption",
  CellTags->"S5.69.1"],
Cell[60850, 2258, 1165, 40, 70, "Text",
  CellTags->{"S5.69.1", "1.55"}],
Cell[62018, 2300, 1820, 68, 70, "Text",
  CellTags->{"S5.69.1", "1.56"}],
Cell[63841, 2370, 993, 34, 70, "Text",
  CellTags->{"S5.69.1", "1.57"}],
Cell[64837, 2406, 281, 8, 70, "MathCaption",
  CellTags->{"S5.69.1", "1.58"}],

Cell[CellGroupData[{
Cell[65143, 2418, 78, 2, 70, "Input",
  CellTags->"S5.69.1"],
Cell[65224, 2422, 328, 11, 70, "Output",
  CellTags->"S5.69.1"]
}, Open  ]],
Cell[65567, 2436, 132, 3, 70, "MathCaption",
  CellTags->{"S5.69.1", "1.59"}],

Cell[CellGroupData[{
Cell[65724, 2443, 96, 2, 70, "Input",
  CellTags->"S5.69.1"],
Cell[65823, 2447, 78, 2, 70, "Output",
  CellTags->"S5.69.1"]
}, Open  ]],
Cell[65916, 2452, 198, 4, 70, "MathCaption",
  CellTags->{"S5.69.1", "1.60"}],

Cell[CellGroupData[{
Cell[66139, 2460, 83, 2, 70, "Input",
  CellTags->"S5.69.1"],
Cell[66225, 2464, 76, 2, 70, "Output",
  CellTags->"S5.69.1"]
}, Open  ]],
Cell[66316, 2469, 182, 6, 70, "MathCaption",
  CellTags->{"S5.69.1", "1.61"}],

Cell[CellGroupData[{
Cell[66523, 2479, 79, 2, 70, "Input",
  CellTags->"S5.69.1"],
Cell[66605, 2483, 75, 2, 70, "Output",
  CellTags->"S5.69.1"]
}, Open  ]],
Cell[66695, 2488, 194, 4, 70, "MathCaption",
  CellTags->{"S5.69.1", "1.62"}],

Cell[CellGroupData[{
Cell[66914, 2496, 81, 2, 70, "Input",
  CellTags->"S5.69.1"],
Cell[66998, 2500, 75, 2, 70, "Output",
  CellTags->"S5.69.1"]
}, Open  ]],
Cell[67088, 2505, 1371, 43, 70, "DefinitionBox",
  CellTags->"S5.69.1"],
Cell[68462, 2550, 60, 1, 70, "Caption",
  CellTags->"S5.69.1"],
Cell[68525, 2553, 491, 16, 70, "Text",
  CellTags->{"S5.69.1", "1.63"}],
Cell[69019, 2571, 267, 9, 70, "MathCaption",
  CellTags->{"S5.69.1", "1.64"}],

Cell[CellGroupData[{
Cell[69311, 2584, 85, 2, 70, "Input",
  CellTags->"S5.69.1"],
Cell[69399, 2588, 92, 3, 70, "Output",
  CellTags->"S5.69.1"]
}, Open  ]],
Cell[69506, 2594, 4935, 150, 70, "DefinitionBox",
  CellTags->"S5.69.1"],
Cell[74444, 2746, 86, 1, 70, "Caption",
  CellTags->"S5.69.1"],
Cell[74533, 2749, 3018, 113, 70, "Text",
  CellTags->{"S5.69.1", "1.65"}],
Cell[77554, 2864, 361, 11, 70, "MathCaption",
  CellTags->{"S5.69.1", "1.66"}],

Cell[CellGroupData[{
Cell[77940, 2879, 99, 2, 70, "Input",
  CellTags->"S5.69.1"],
Cell[78042, 2883, 2743, 91, 70, "Output",
  CellTags->"S5.69.1"]
}, Open  ]],
Cell[80800, 2977, 103, 1, 70, "MathCaption",
  CellTags->{"S5.69.1", "1.67"}],

Cell[CellGroupData[{
Cell[80928, 2982, 85, 2, 70, "Input",
  CellTags->"S5.69.1"],
Cell[81016, 2986, 482, 10, 70, "Output",
  CellTags->"S5.69.1"]
}, Open  ]],
Cell[81513, 2999, 109, 1, 70, "MathCaption",
  CellTags->{"S5.69.1", "1.68"}],

Cell[CellGroupData[{
Cell[81647, 3004, 106, 2, 70, "Input",
  CellTags->"S5.69.1"],
Cell[81756, 3008, 239, 8, 70, "Output",
  CellTags->"S5.69.1"]
}, Open  ]],
Cell[82010, 3019, 395, 14, 70, "MathCaption",
  CellTags->{"S5.69.1", "1.69"}],

Cell[CellGroupData[{
Cell[82430, 3037, 107, 2, 70, "Input",
  CellTags->"S5.69.1"],
Cell[82540, 3041, 79, 2, 70, "Output",
  CellTags->"S5.69.1"]
}, Open  ]],
Cell[82634, 3046, 215, 6, 70, "Text",
  CellTags->{"S5.69.1", "1.70"}],
Cell[82852, 3054, 1111, 34, 70, "DefinitionBox",
  CellTags->"S5.69.1"],
Cell[83966, 3090, 72, 1, 70, "Caption",
  CellTags->"S5.69.1"],
Cell[84041, 3093, 1324, 49, 70, "Text",
  CellTags->{"S5.69.1", "1.71"}],
Cell[85368, 3144, 154, 4, 70, "MathCaption",
  CellTags->{"S5.69.1", "1.72"}],
Cell[85525, 3150, 99, 2, 70, "Input",
  CellTags->"S5.69.1"],
Cell[85627, 3154, 182, 5, 70, "Text",
  CellTags->{"S5.69.1", "1.73"}],
Cell[85812, 3161, 2577, 81, 70, "DefinitionBox",
  CellTags->"S5.69.1"],
Cell[88392, 3244, 87, 1, 70, "Caption",
  CellTags->"S5.69.1"],
Cell[88482, 3247, 1994, 54, 70, "Text",
  CellTags->{"S5.69.1", "1.74"}],
Cell[90479, 3303, 221, 7, 70, "MathCaption",
  CellTags->{"S5.69.1", "1.75"}],

Cell[CellGroupData[{
Cell[90725, 3314, 80, 2, 70, "Input",
  CellTags->"S5.69.1"],
Cell[90808, 3318, 76, 2, 70, "Output",
  CellTags->"S5.69.1"]
}, Open  ]],
Cell[90899, 3323, 477, 19, 70, "MathCaption",
  CellTags->{"S5.69.1", "1.76"}],

Cell[CellGroupData[{
Cell[91401, 3346, 79, 2, 70, "Input",
  CellTags->"S5.69.1"],
Cell[91483, 3350, 75, 2, 70, "Output",
  CellTags->"S5.69.1"]
}, Open  ]],
Cell[91573, 3355, 275, 8, 70, "MathCaption",
  CellTags->{"S5.69.1", "1.77"}],

Cell[CellGroupData[{
Cell[91873, 3367, 83, 2, 70, "Input",
  CellTags->"S5.69.1"],
Cell[91959, 3371, 142, 4, 70, "Output",
  CellTags->"S5.69.1"]
}, Open  ]],
Cell[92116, 3378, 97, 1, 70, "MathCaption",
  CellTags->{"S5.69.1", "1.78"}],

Cell[CellGroupData[{
Cell[92238, 3383, 80, 2, 70, "Input",
  CellTags->"S5.69.1"],
Cell[92321, 3387, 97, 3, 70, "Output",
  CellTags->"S5.69.1"]
}, Open  ]],
Cell[92433, 3393, 640, 16, 70, "Text",
  CellTags->{"S5.69.1", "1.79"}],
Cell[93076, 3411, 255, 7, 70, "MathCaption",
  CellTags->{"S5.69.1", "1.80"}],

Cell[CellGroupData[{
Cell[93356, 3422, 83, 2, 70, "Input",
  CellTags->"S5.69.1"],
Cell[93442, 3426, 173, 5, 70, "Output",
  CellTags->"S5.69.1"]
}, Open  ]],
Cell[93630, 3434, 5044, 148, 70, "DefinitionBox3Col",
  CellTags->"S5.69.1"],
Cell[98677, 3584, 72, 1, 70, "Caption",
  CellTags->"S5.69.1"],
Cell[98752, 3587, 735, 20, 70, "Text",
  CellTags->{"S5.69.1", "1.81"}],
Cell[99490, 3609, 555, 19, 70, "Text",
  CellTags->{"S5.69.1", "1.82"}],
Cell[100048, 3630, 117, 2, 70, "MathCaption",
  CellTags->{"S5.69.1", "1.83"}],

Cell[CellGroupData[{
Cell[100190, 3636, 80, 2, 70, "Input",
  CellTags->"S5.69.1"],
Cell[100273, 3640, 76, 2, 70, "Output",
  CellTags->"S5.69.1"]
}, Open  ]],
Cell[100364, 3645, 822, 31, 70, "MathCaption",
  CellTags->{"S5.69.1", "1.84"}],

Cell[CellGroupData[{
Cell[101211, 3680, 109, 2, 70, "Input",
  CellTags->"S5.69.1"],
Cell[101323, 3684, 75, 2, 70, "Output",
  CellTags->"S5.69.1"]
}, Open  ]],
Cell[101413, 3689, 1652, 65, 70, "MathCaption",
  CellTags->{"S5.69.1", "1.85"}],

Cell[CellGroupData[{
Cell[103090, 3758, 111, 2, 70, "Input",
  CellTags->"S5.69.1"],
Cell[103204, 3762, 75, 2, 70, "Output",
  CellTags->"S5.69.1"]
}, Open  ]],
Cell[103294, 3767, 2087, 81, 70, "MathCaption",
  CellTags->{"S5.69.1", "1.86"}],

Cell[CellGroupData[{
Cell[105406, 3852, 112, 2, 70, "Input",
  CellTags->"S5.69.1"],
Cell[105521, 3856, 75, 2, 70, "Output",
  CellTags->"S5.69.1"]
}, Open  ]],
Cell[105611, 3861, 663, 25, 70, "MathCaption",
  CellTags->{"S5.69.1", "1.87"}],

Cell[CellGroupData[{
Cell[106299, 3890, 113, 2, 70, "Input",
  CellTags->"S5.69.1"],
Cell[106415, 3894, 76, 2, 70, "Output",
  CellTags->"S5.69.1"]
}, Open  ]],
Cell[106506, 3899, 1020, 39, 70, "MathCaption",
  CellTags->{"S5.69.1", "1.88"}],

Cell[CellGroupData[{
Cell[107551, 3942, 121, 2, 70, "Input",
  CellTags->"S5.69.1"],
Cell[107675, 3946, 75, 2, 70, "Output",
  CellTags->"S5.69.1"]
}, Open  ]],
Cell[107765, 3951, 642, 23, 70, "MathCaption",
  CellTags->{"S5.69.1", "1.89"}],

Cell[CellGroupData[{
Cell[108432, 3978, 103, 2, 70, "Input",
  CellTags->"S5.69.1"],
Cell[108538, 3982, 122, 4, 70, "Output",
  CellTags->"S5.69.1"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

